﻿USE sofia;
DROP TABLE IF EXISTS sofia.med_vpl;
CREATE TABLE med_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES med_vpl WRITE;
INSERT INTO med_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ya ei Jisas Kraist nga wamp pundun kʉngan kalk, tʉk mek yant ok, Depit kangʉm nʉk, Depit Aparam kangʉm nʉk etʉng ei nga. ");
INSERT INTO med_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aparam ni, Aisak nga tipam, Aisak ni, Jekop nga tipam, Jekop ni, Jura kʉn ʉngʉnʉl nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jura ni, Peres kʉn Jeral raⱡ nga tipam, wote wu raⱡ nga mema, Tamar Peres ni, Esron nga tipam, Esron ni, Ram nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ni, Aminarap nga tipam, Aminarap ni, Nason nga tipam, Nason ni, Salmon nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ni, Bowas nga tipam, wote mam Reiyap, Bowas ni, Opet nga tipam, Opet ni, Jesi nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ni, wu peng mumuk Depit nga tipam murum. Depit ni, Solomon nga tipam, mam amp Yuraiya ni, wu ei nga ambʉm. ");
INSERT INTO med_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ni, Riyopowam nga tipam, Riyopowam ni, Apaija nga tipam, Apaija ni, Eisa nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Eisa ni, Jeyosopat nga tipam, Jeyosopat ni, Jeyoram nga tipam, Jeyoram ni, Atariya nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Atariya ni, Jotam nga tipam, Jotam ni, Eiyas nga tipam, Eiyas ni, Etikaiya nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Etikaiya ni, Manasa nga tipam, Manasa ni, Amon nga tipam, Amon ni, Josaiya nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiya ni, Jeoiyakin kʉn ʉngʉnʉl ni kʉⱡ nga tipam murum. ");
INSERT INTO med_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ui ni kʉn, Isrel wamp mbʉ rok makrʉk Bapolon kona nila mek purung. Bapolon kona mek ok mondrung ni kʉn, Jeoiyakin ni, Seldiyel nga tipam, Seldiyel ni, Serupapel nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serupapel ni, Apiyut nga tipam, Apiyut ni, Eliyakim nga tipam, Eliyakim ni, Asor nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ni, Seitok nga tipam, Seitok ni, Akim nga tipam, Akim ni, Eliyut nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyut ni, Eliyeisor nga tipam, Eliyeisor ni, Matan nga tipam. Matan ni, Jekop nga tipam, ");
INSERT INTO med_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ni, Josep nga tipam, Josep ambʉm ei Mariya, kang Jisas mam, akup mbi tek Kraist nʉtmin ei, Jisas ei, Got nga ngurum wu. ");
INSERT INTO med_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ei kʉn, Aparam ni kʉn, yant ndupa, wamp rʉⱡaip 14 mel molk oⱡina mba, Depit metʉng. Wote, Depit ni kʉn, yant ndupa, wamp rʉⱡaip 14 mel molk oⱡina mba, Bapolon mʉi kona ou ei ndi, Isrel wamp rok, kan ngʉk mek purung. Bapolon ok morung ei kʉn, yant ndupa, wamp rʉⱡaip 14 mel molk oⱡina mba, Kraist ei, Got nga ngurum wu ei metʉng. ");
INSERT INTO med_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ya ei, Jisas Kraist mitim mel: Jisas mam, amp Mariya ni, wu Josep nga ol ik nundʉk mondrung. Wote ei Josep nga kuima ngok tʉk manga tenda ila pindi nʉpindi kʉn kandrung ei, amp Mariya ni, Muⱡnga Wingti nga ronduⱡ ila kangambuⱡa mundrum. ");
INSERT INTO med_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nambuⱡ emel, Josep amp Mariya tʉmba nʉtʉng wu ni, uⱡ minʉpi mbʉ nga iti natʉpa itim. Uⱡ ei ndi, amp Mariya kangambuⱡa mondpa itim ni, tʉpa pena ila pendʉp etʉp tʉngambuⱡ kundi nʉkʉndimp nimba, kiyang nʉmp wak ruimp nimba pitim. ");
INSERT INTO med_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Numan i etpa pilpa murum ni, ur pepa, ur kump itim nila, Got nga anggelo ti ndi omba kundpa nimba mel, “Josep, nim Depit nga pundun ei, amp Mariya tʉkʉn nim nga ambnʉm rundʉn ei nga, mundmong iti nʉti! Kangambuⱡa mondpa morum ei, Muⱡnga Wingti ei nga ronduⱡ ila mondpa morum. ");
INSERT INTO med_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amp ei ndi, kang ti memba ei mbi tekʉn Jisas ni, nambuⱡ emel, wu ei ndi, elim nga wamp mbʉ uⱡ kit mbila mormin ei nga, etpa peng kont tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Uⱡ kʉⱡ itim ei, Oⱡa Nuim Got ei nga keta tʉpa painui wu ti ndi, nitim ik ei kupa itim. ");
INSERT INTO med_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Amp wendʉp ei, kangambuⱡa mondʉmba. Wote, kang ti memba ei mbi tek, “Imanuwel,” ning ei nga puⱡ ei, “Got tʉn kʉn morum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ni kʉn, Josep ur pepa rut nimba kʉn, Got nga anggelo ei ndi, ur kump ngumba nitim ni mel, amp Mariya ni tʉpa, elim nga ambʉm rundrum. ");
INSERT INTO med_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tʉpa ambʉm rundrum ei kʉn, rʉp rokʉⱡ iti natʉtʉnggil, amp ei elim wendʉp murum ei mel ku moⱡpa mba, kang ei mitim. Wote Josep ndi, kang ei mbi tepa, Jisas nitim. ");
INSERT INTO med_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas ni wʉl Juriya mʉi kʉmp ei nga kona peng ti mbi tek, Betelem nʉtmin kona ila metʉng. Ui ei kʉn Erot ni, wu ei king murum. Ei kʉn ku, akil tepa wu kat oⱡa muⱡ ila mipil mbila, kandʉk ko rok etmin wu kʉⱡ al ant oⱡa orum orunga molk ok, Jerusalem kona peng ila ping orung. ");
INSERT INTO med_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalem rʉk ok waldʉk nʉk mel, “Kang nana Jura wamp mbʉ nga King moⱡmba kang mem nʉng ni nant? Wu king moⱡmba ei nga mipil ei, tʉn al ant oⱡa ui orunga, kandpʉn ombun mbi paka rundmin onmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","4","King Erot ni, wu king ti meng nʉtʉng ik ei pilpa, rot nimba, popʉⱡ kurum ei mel ku, Jerusalem ila ik ei pʉtʉng wamp mbʉ pilik, rot nʉk popʉⱡ mundʉk etʉng ku. Ni kʉn, wu pris kuimbal mbʉ na, mi ik mbo wu na mbʉ ok, tʉk tenda itʉi nilinga, oⱡina waldpa nimba mel, “Got ndi mbi ropa mundum wu Nuim Mumuk Kraist ei, nant tila meng nda?” Erot nitim. ");
INSERT INTO med_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Wu ni kʉⱡ ndi, nʉk int nduk Betelem kona peng Juriya kona ila meng,” nʉtʉng. “Ei painui wu ti ndi, ik pai nomba i etpa ropa pinditim: ");
INSERT INTO med_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Juriya orunga kona Betelem ye, nim kona peng kel ti mon. Ei nambuⱡ emel, Betelem kona ila wu ti meng ei ndi, Isrel wamp mbʉ nga king moⱡpa, wamp mbʉ rʉp etpa tʉpa kun etmba,’” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ei kʉn, Erot ndi, al ant oⱡa ui orunga, wu tʉma ni kʉⱡ tʉpa tenda etpa, mou kel ti rorung nila waldpa nimba mel, “Mipil ei ant mong kun nant ei kʉn, muⱡ ila oⱡa oⱡnga kanʉng?” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nʉtʉng ik ni pilpa, wu ni kʉⱡ tʉpa, Betelem mondpa ik ei mel nimba “Puk wang nduk kang ninmin ei kurʉi! Kandʉk tʉng ndam, yant ok na kondʉk nangina, na i ku etʉp, mbo mbi paka rimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wu kʉⱡ, king ei nitim ik ni pilik, en enim ping orung ni mel puk, nombuⱡa mam ila mipil unt kandʉk, pep rok orung ni pitim. Wote, mipil ni kandrung ei kʉn, ama numan mam ti elinga, kai pilik morung. Wote mipil ni oⱡa muⱡ ila ndui nimba kuimp tilinga, wu ni kʉⱡ akil tek puⱡʉngina, mipil ni mba, kang nana ni pitim manga nila omba murum. ");
INSERT INTO med_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mipil rʉⱡang nomba pitim, manga nila murʉk puk, amp Mariya kʉn, kang nana Jisas raⱡ kandʉk tʉk, rumaⱡi pek, Jisas nga mbi paka rondrʉng. Wote, en enim nga wal mek orung nimbʉ, elpa elpa aptʉk tek, ku eng nui mat ngok, kopung mura rui, ou ni mat kʉn, nde ongum i ku etpa mura rui mat angge nʉk ngok etʉng. ");
INSERT INTO med_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mel nimbʉ ngok pendʉk, en enim kelik mang kona nombuⱡa mam elpa tila ku purung. Ei nambuⱡ emel, Got ndi, rumbʉⱡ rui ur kump ila man ngumba, king Erot morum ila aldpa int pi nʉpʉi nitim ei nga etʉng. ");
INSERT INTO med_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ant oⱡa ui wu tʉma ni kʉⱡ puⱡʉngina, mbuldung orunga, Got nd, Josep ur pitim nila ur kump ngumba, kundpa nimba mel, “Oⱡa molkʉn! Kang nana ei kʉn, mam kʉn kongundkʉn mekʉn, Isip mʉi kʉmp ila nʉng nʉkʉn pi! Puk ila muⱡangina, na ndi, yant ui nʉnt tila pilkʉn, yant ui! Nambuⱡ emel, ʉkpi nundpa, king Erot ndi, elim nga el wu mbʉ tʉpa mundangga, ya kang nana ei rok kunding enmin ei mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ik ei pilpa, rumbʉⱡ tenda nila ku, kang nana ni kʉn, mam kʉn kongundpa melinga, Isip kona ila purung. ");
INSERT INTO med_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kona nila puk molk, ui mat tʉk mundʉⱡina, wote king Erot ni kurum. Ei nga, Pai nui wu Aisaiya ndi, ik nitim ei omba kupa itim. Ei nga, ik pai nui wu ei ndi, Oⱡa Nuim Got nga keta tʉpa nitim ik ei mel, “Na nga kangʉm ei, al Isip murum ei, wi rop Isip wak ropa kelpa ekit wangga nʉnt!” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wu pilpa kungʉndi ni kʉⱡ ndi, King Erot elim tʉk kumngui randrʉng, uⱡ ei tʉpa mendpa popʉⱡ kurum. Popʉⱡ ei ndi, elim nga el wu mbʉ kundpa nimba mel, “Kang nana ya Betelem kona ila kep, Betelem nga nondpa petmin wamp mbʉ nga kang nana pana raⱡ ndi, mana ndupa, kanʉng mbʉ rok kundʉi!” nitim. Ei nga, tʉma ila ant oⱡa ui orunga orung wu ni kʉⱡ ndi, mipil kuimp tepa pilinga nilinga, kandʉk ok nʉtʉng ik ni pilpa moⱡpa, Jisas ni rop kundimp nimba, pilpa pana to ei mel, kang nana mbʉ rok kundʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","I itim uⱡ ei ndi, painui wu Jerimaiya ndi, pai nomba nitim ik ei, omba kupa itim, ik ei mel, ");
INSERT INTO med_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wi Rama kona ila, wi ti urum pitmin ni, wamp ka rom ʉⱡmbʉⱡ ik ei pitmʉn. Ni kʉn, amp Reisel ndi, elim nga kangambuⱡa mbʉ nga ka itim. Numan wang ndangga nʉk, kont kondʉnmin ei, kont kuⱡi nʉⱡi!” nitim. “Ei nambuⱡ emel, elim nga kangambuⱡa mbʉ, kolk pora ndung ei nga!” nitim. Isip Morung Ni Mel Nasaret Kelik Yant Orung ");
INSERT INTO med_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Erot kurum ni kʉn, Josep wʉl Isip murum nila, ur kump itim ei, Got nga anggelo ti ndi omba, Josep kundpa nimba mel, “Nim oⱡa molkʉn, kang ei kʉn, mam kʉn kongundkʉn mekʉn, nim nga Isrel mʉi ila rukʉr pi! Nambuⱡ emel, kang ei, rop kundmin nʉtʉng wu nimbʉ korung,” nitim. ");
INSERT INTO med_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ni kʉn, Josep ik ni pilpa, rut nimba rumbʉⱡ tenda nila, kang ei kʉn mam kʉn kongundpa mepa, Isrel mʉi ila yant urum. ");
INSERT INTO med_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Wote Erot koⱡnga, kangʉm Arkaleyas ni, tipam nga koⱡ ila, Jura wamp mbʉ, rʉp enim nʉtʉng ik ni Josep pilpa, Jura kona ila mba ei nga mundmong itim. Ni kʉn, Got ndi, ur kump ngumba nduimp rundrum mel, Galili ni, kona ei nga kona peng ti mbi tek, ‘Nasaret,’ nʉtmin nila, mba pepa murum. I itim uⱡ ei ndi, painui wu ti ndi, Jisas nga nʉndpa nitim ik ni omba kupa itim, “Wu ei mbi tek, ‘Nasaret wu ei,’” nitim. ");
INSERT INTO med_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Ui nimbʉ kʉn, wamp nu tindi wu Jon ni Jura kona kui waka ronggʉt Got nga ik ei puⱡ mondpa, wamp mbʉ kʉn nimba mel, “Got nga wamp tʉpa mumuk rui kona ei nundpa onum kʉn, en enim nga uⱡ kit mbʉ tʉk mbuldung ngʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ni wu ei, painui wu Aisaiya ndi, nitim wu ni, nimba mel, “Kona kui waka ila, wamp ti wi ropa, ‘Wu Nuim ei tʉn kʉn omba ei nga nombuⱡa mam ei kʉtʉk kai itʉi! Nombuⱡa rondung ei, kun pangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nga muⱡ mbal wal pʉki pʉkrʉm mbʉ, kng kamel nga kʉng mbila rok rambrʉng. Wote, kng kʉng ei, kʉp kan rurum. Rʉng nui mel, uipʉ nguimba mbʉ ropa numba, pilma muⱡ mbʉ tʉpa numba itim. ");
INSERT INTO med_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Elim nga ik nitim ni kʉnmin nʉk, Jerusalem ila wamp na, Jura wamp rʉⱡaip na, nu Joran ʉldʉ ila wamp rʉⱡaip na mbʉ orung. ");
INSERT INTO med_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","En enim nga uⱡ kit etʉng nimbʉ nʉk para nduⱡina, nu Joran ila nu tinditim. ");
INSERT INTO med_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Perisi na, Sarusi wu minal Jon ndi, nu tʉndangga nʉk, orung ni kandpa, i nitim, “Enim kimbuⱡa mbʉ ye! Enim Got ndi, popʉⱡ tʉpa mundʉmba enim ila enim nʉng nʉk, ping nimba wamp nam ndi nitim? ");
INSERT INTO med_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nim nga uⱡ in mbʉ ndi, nim nga numan ropʉⱡ run uⱡ ei, tʉpa mot ndangga. ");
INSERT INTO med_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wote, mindil tʉpa mundʉmba uⱡ ei na, Aparam nga pundun kungan ei, nʉmp kʉn na, nʉng nʉmp mbi nʉk pili nʉpʉlʉi! Na ndi, enim kundʉp namp, ‘Ku mbʉ mana, Got ndi, etpa Aparam nga wamp pundun kungan kapⱡa randʉmba!’ ");
INSERT INTO med_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Rui ti ndi, nde ei nga puⱡ pilkan kʉⱡ, rung ndumba ei nga tʉpa kun etpa morum. Nde ti, mong kai ropa iti natʉm nde ei, rui rok tʉk, ndip ila munding. ");
INSERT INTO med_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na enim nu ila mint nu tindint ei ndi, nim kupa numan ropʉⱡ rʉn nʉmp ent. Wote, akil tepa omba wu ei ndi, Muⱡnga Wingti kʉn, ndip kʉn pendpa nu tʉndʉmba. Wu ei, na mel kapⱡa mon! Wu Nuim ei nga ronduⱡ ei, kot oⱡa mel, na wu mana orunga ei ndi, elim nga kʉmp rʉk mel raⱡ kep, tʉp mimp mel kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wu ei ndi, wit ropa muⱡ petʉm mana, ropa nʉnou rorum mbʉ apurʉrmʉn ni mel, mana wamp mbʉ i etpa, apʉrpa wamp kit kai mbʉ, tʉpa elpa elpa mondʉmba. Wit ropa muⱡ pem mbʉ tʉpa, manga etpa, wit ropa nʉnou rom mbʉ tʉpa, ndip tila kaⱡmba, ndip ei kumbʉⱡi nambʉrʉm!” nitim. ");
INSERT INTO med_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jon wamp nu tinditim ui ni kʉn, Jisas wil Galili orunga moⱡpa, omba nu Joran ila omba, Jon ndi elim nu tʉndangga nimba urum. ");
INSERT INTO med_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ni kʉn, Jon ndi numan pilpa onum ei, wak rangga nimba Jisas kundpa, “Na wu mana ei, nim ndi nu tʉndʉn nʉmp kel rondʉp mor ndi, wote na ndi, nim nu tʉndamp nʉn ei, etʉk pilik nʉn mel nant?” nitim. ");
INSERT INTO med_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ni Jisas ndi, ik punt ropa nimba mel, “Akup nʉnt uⱡ ei mel, peng piyangga. I etʉp mbuⱡ uⱡ ei, Got nga numan ila pilangga kapⱡa etmba,” nitim. Wote Jon ndi, Jisas nitim ni mel pilpa teng ndupa itim. ");
INSERT INTO med_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wote Jon ndi, nu tʉndʉlnga, Jisas nu mil ni wak ropa ekit oⱡnga, wi muⱡ ei, wei guⱡ gaⱡa nimba kumba tilinga, Got nga Muⱡnga ni kʉi Imil mel ndui nimba mana omba, Jisas nga peng ila rʉⱡang ngumba murum. ");
INSERT INTO med_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ni kʉn, wi muⱡ ila ik ti ekit omba nimba mel, “Ya wu ei, na nga kangʉm mendpʉⱡ ei, nanim kandʉp numan ndi kont,” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Seitan ndi, Jisas oⱡa tʉpa kanʉmba ei nga, Got nga muⱡnga ei ndi, Jisas mepa kona kui waka tila purum. ");
INSERT INTO med_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Rumbʉⱡ 40, wote ant 40 mel rʉng ti nui nandpa pitim ei nga, Jisas ama kump kun ndi kurum. ");
INSERT INTO med_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ni kʉn, Seitan Jisas murum nila omba kundpa nimba mel, “Nim Got nga kangʉm ei ndam, ya ku kʉⱡ nana omba oka rʉⱡangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wote Jisas ndi, ik punt ropa nimba mel, “Got nga ik mong ti petʉm ei ndi, nimba mel, ‘Oka ndi, mendpʉⱡ wamp ti ombʉl ʉmbʉⱡi nambrʉm. Got nga keta ila ik mong ekit orum ei ndi, wamp ombʉl ambrʉm,’” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Nitim ni kʉn, akil tepa Seitan ndi, Jisas tʉpa mepa kona wingti Jerusalem nga manga wingti ou im ila mondpa, Jisas kundpa, “Nim Got nga kangʉm ndam, pukʉ rokʉn mana pi, Got nga ik mong ti petʉm ei ndi, nimba mel, ‘Elim nga anggelo mbʉ, nim nga nʉndpa tʉpa mundangga, nim tʉk ki kaimp pol ila ambulk, oⱡa nduk mek wangina, nim nga kʉmp kot kep, ropa nit pindi napundʉmba’” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ni kʉn, Jisas ndi, ik punt ropa nimba mel, “Got nga ik mong ila ku, ik ti petʉm ei ndi nimba mel, ‘Nim nga Wu Nuim Got ei, oⱡa tʉkʉn, kʉni nʉkʉni mon, nimba petʉm!’” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Aldpa Seitan ndi, Jisas tʉpa mepa komnga oⱡa tila mba, muⱡ uⱡ ila kng mel tetʉm mbʉ kʉn, wamp rʉⱡaip mormin mbʉ kʉn, tʉpa ora ndupa, nimba mel, “Na kʉn rumʉⱡi pekʉn na nga mbi paka rundʉn ndam, ya kona na mel, na kan mbʉ pʉkʉ nim nguimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ei kʉn, Jisas ndi, nimba int ndupa, “Seitan nim kelkʉn pi! Got nga kʉndʉk ik mong unt nga petʉm ei ndi, nimba mel, ‘Nim nga Oⱡa Nuim Got ei mendpʉⱡ, mbi paka rondkʉn kongun indi!’” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Seitan ni, Jisas wak ropa kelpa puⱡnga, anggelo mbʉ ndi ok, Jisas tʉk rapʉndrʉng. ");
INSERT INTO med_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jon tʉk kan manga ila pendʉtʉng nʉtʉng ik ni Jisas pilpa, Juriya mʉi kona ei wak ropa kelpa, Galili int purum. ");
INSERT INTO med_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jisas mba Nasaret muⱡi nambʉⱡpa, kelpa mba Kaperniyum kona peng ila pepa murum. Kona peng ei, num Galili ei nga ʉldʉ wote, Sepulun kʉn, Neptali wu rʉⱡaip raⱡ nga oi ila. ");
INSERT INTO med_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Uⱡ itim ei, Oⱡa Nuim Got ei nga keta tʉpa ik pai nui wu Aisaiya ndi, nitim ik ei omba kupa itim. ");
INSERT INTO med_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepulun kʉn, Neptali wu rʉⱡaip kʉⱡ nga mʉi kʉmp, wote num kuta morum orunga ndi, Joran al orunga, Galili mbo wamp rʉⱡaip elpa mbʉ nga mʉi ila, ");
INSERT INTO med_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","enim rumbʉⱡ ila morung wamp mbʉ, akup rʉⱡang ti kʉning! Enim wamp kui nga mʉi ila petʉng wamp mbʉ, akup rʉⱡang ei ndi, rʉⱡang ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ui ni kʉn, Jisas nga nombuⱡa rung ik mbʉ puⱡ mondpa wamp mbʉ kʉn nimba mel, “Muⱡ ila tʉpa mumuk rui uⱡ ei enim kʉn onum. En enim nga uⱡ kit mbʉ wak rʉiya!” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas, num Galili ei nga ʉldʉ orunga omba kʉndrʉm mel, oma wal mundi wu ʉngʉn ʉngʉn raⱡ Saimon wote, (mbi tek Pita) nʉtmʉn. Ni kʉn, ʉngʉn akil Andru raⱡ oma ruimbil nʉkʉⱡ, oma wal nu ila mundkʉⱡ morunggil. ");
INSERT INTO med_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ni kʉn, Jisas ndi nimba mel, “Enmbil na kʉn wʉl! Na ndi, enmbil wamp wal mondʉk tinggil ei mel, mbo indimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nitim ni mel teng ndukʉⱡ, oma wal nimbʉ tʉngʉnda mint wak rokʉⱡ, elim purum nila kunda purung. ");
INSERT INTO med_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wote, num ni nga ʉldʉ orunga mba, ama merʉng orunga nu mil ila, wu ʉngʉn ʉngʉn elpa ralt ku morunggil. Ni raⱡ, wu Sepeti kangʉm Jeims kʉn, Jon kʉn, wu raⱡ nga tipam Sepeti kʉn, nu kanu ila oma wal mundmin nʉk, wal tek kun etʉk moⱡina, Jisas ndi, omba wi rurum. ");
INSERT INTO med_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ni kʉn, tʉngʉnda rot nʉk, oⱡa anggilikʉⱡ, en enmbil nga tipam ni kep, nu kanu ni kep, mondʉk kelkʉⱡ wak rokʉⱡ, Jisas purum nila kunda purung. ");
INSERT INTO med_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas mba Galili orunga andpa, kapⱡa endpa, atinga manga mbila, Got nga ik mbo endpa, tʉpa mumuk rui kona kʉndʉk ik kai ei, nimba ngumba, kui mbo elpa elpa na, kʉmp ki rambuⱡpa itim wamp mbʉ etpa, we mondpa itim. ");
INSERT INTO med_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","I itim uⱡ mbʉ nga timan ei, Siriya kona orunga pora purum ila, kui elpa elpa roⱡnga, mindil norung wamp na, kur kit rurum wamp na, numan mbila ropa kupʉr mundrum wamp na, on por murum wamp na mbʉ mek oⱡina, Jisas ndi, wamp mbʉ pora etpa titim. ");
INSERT INTO med_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","I itim ila kandʉk, Galili kona peng kʉⱡ kʉn, Jerusalem, Juriya nui orunga na, Joran noi orunga wamp nimbʉ, kʉmp kʉn ok, elim purum mel, kandʉk pep rok purung. ");
INSERT INTO med_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Jisas wamp num ni kandpa, elim komnga mong tila oⱡa mba murum. Elim nga kitip kʉni wu ni kʉⱡ, elim murum nila molk, pok elingina, puⱡ mondpa wamp nimbʉ, ik mbo endpa nimba mel, ");
INSERT INTO med_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","4","“Got nga uⱡ mbʉ nga kapⱡa iti natilinga, keⱡ rundi rundi mormin wamp mbʉ, kai pileing. Got nga wamp tʉpa mumuk rui kona ei, wamp mbʉ nga, mʉi kona uⱡ kit mbʉ ndi elinga, mundmong mindil tʉnmin wamp mbʉ, kai pileing wamp mbʉ, Got ndi, etpa numan wang ndumba! ");
INSERT INTO med_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Numan koma tʉi wamp mbʉ, kai pileing, Got ndi, kela memp mʉi nguimp nitim ei, en enim puⱡ puⱡ ralk ting! ");
INSERT INTO med_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Got nga numan ngorum uⱡ mbʉ, etamin ka nʉk, kum pendʉtmʉn wamp mbʉ kai pileing, numan ngʉng uⱡ mbʉ mel etpa, kapⱡa endangga! ");
INSERT INTO med_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wamp elpa mbʉ kaimp kurmin wamp mbʉ kai pileing, wamp kit kai kʉmp ti ui ei kʉn, Got ndi, wamp i etmin mbʉ, kaimp koⱡmba! ");
INSERT INTO med_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Numan kun kai pendpa, Got nga nimba pilim wamp ei kai pilangga! Wamp mbʉ Got kʉning. ");
INSERT INTO med_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wamp molk kundeing nʉk, kongun etmin wamp mbʉ kai pileing, wamp mbʉ Got ndi, el elim nga kangambuⱡa nimba! ");
INSERT INTO med_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Got nga numan ngorum uⱡ mbʉ elingina, rok pep rok, rok pint panda etʉk mek andinmin wamp mbʉ, kai pilʉi! Muⱡ kona tʉpa mumuk rui kona ei, wamp mbʉ nga! ");
INSERT INTO med_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Enim na nga kitip kʉni wamp kʉⱡ, ui nant mat ila enim wamp kit nʉk, rok pint panda etʉk, tʉk mbuldung oldung etʉk, ik kit mbʉ, we ndil ndil polk nʉng wamp mbʉ kai pilʉi! Nambuⱡ ei mel, enim na pep rormin wamp kʉⱡ. ");
INSERT INTO med_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Enim numan kai pendʉk, rui mʉi nʉk muⱡʉi! Enim nga mel mam kai ti punt ropa ngumba ei, muⱡ kona ila tendpa morum. Enim mul nʉmbil unt mbila, ik pai nomba ni, wu mat morung mbʉ ei ku etʉk, rok pint panda etʉk, mek andrʉng. ");
INSERT INTO med_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Enim Got nga wamp ya mʉi kona wamp mbʉ kʉn, ip kuta mel, wote ip kuta ei nga tʉngʉn ei purpa wei ai em ndam, ip kuta ei nga tʉngʉn ei, etʉp timin mel nant? Ip kuta purpa kit etʉm ei, mundʉk kelik mʉi ila wamp mbʉ ndi kambitmin. ");
INSERT INTO med_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Enim, muⱡ uⱡ mbila wamp molk pʉnmin mbʉ nga rʉⱡang mbʉ. Manga rʉⱡaip ti mek, komnga mong ila rakurmin ei nga rʉⱡang ei, mou rui napʉrʉm ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wamp ti ndi, ndip lam kandpa, lam rʉⱡang ei, panda ropa mundi namʉndrʉm mon. Wote lam kandʉk, oⱡa nduk monduⱡina, manga ila mormin wamp ei, rʉⱡang ngʉⱡnga rʉⱡang ei, kandʉk mormin ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ei mel ku, enim nga rʉⱡang ei, wamp mbʉ nga kuimp keta ila rʉⱡang pangga! Enim nga uⱡ kai eng mbʉ, wamp mbʉ ndi kandʉk, enim nga Tipanʉm Got wi muⱡ kona morum ei nga mbi ei, paka rundeing. ");
INSERT INTO med_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Na ik mbo endʉnt uⱡ ei nga, enim ndi, pilik pai nui wu mbʉ nga ik niting na, Got nga mi ik Moses ngurum na mbʉ, rop mbuⱡ mbaⱡ indimp nʉmp, ur nʉk pili nʉpʉlʉi mon! Na rop mbuⱡ mbaⱡ indimp nʉmp ui nʉwʉr mon. Na ik kʉⱡ etʉp, kupa indimp nʉmp mana ur. ");
INSERT INTO med_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pilik muⱡʉi! Ya akup moⱡʉp onmʉn ui ei, mba muⱡ mʉi raⱡ pora nimba ei kʉn, rʉk ting ila, Moses nga mi ik ei nga, ik mong tenda kot kep, mʉi ila uⱡ mbʉ ndi, ropa kawa ndui nʉndangga. Got nga ik ei ndi, etmba nitim uⱡ mbʉ, etpa pora ndumba. ");
INSERT INTO med_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ei nga, wamp nam ti ndi, Got nga mi ik ei nga, ik mong onunga ti, tʉpa pei mondrum uⱡ ei mel, wamp mat i ku iteing nimba, mbo endim ndam, wamp ei Got nga tʉpa mumuk rui kona ila wamp nuim muⱡi nambuⱡmba. Wote, wamp nam ti ndi, mi ik ei, tʉpa ou ndupa, wamp mat i ku etʉk tʉk, ou ndʉi nimba mbo endim ndam, wamp ei, Got nga tʉpa mumuk rui kona ila wamp nuim moⱡmba. ");
INSERT INTO med_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na enim kundʉp namp, enim Moses nga mi ik mbo wu na, Perisi wu na mbʉ, kun kai mormin uⱡ ei, tʉk mana mel nduk, enim Got nga numan ngorum uⱡ mendpʉⱡ mbʉ mel, pep rok eng ndam, enim tʉpa mumuk rui kona ila rukʉr ping. ");
INSERT INTO med_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tʉn nga anda kouwʉmʉn Jura wamp mbʉ, man ngok, wamp rok kundi nʉkʉndʉi nʉtʉm. Rom wamp ei, kombulk nangina mba, kupa em ndam, mong tangga. ");
INSERT INTO med_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ni kʉn wote, akup na ndi, enim ik i etʉp kondʉp nʉnt, wamp nam ti ndi, elim nga ʉngʉn ti kʉn popʉⱡ kuⱡʉm ndam, wamp kʉmp ti, wu ei nga kuimp keta ila mba anggilmba. Wamp nam ti ndi ʉngʉn ti nimba kit mondum ndam, ‘Nim ik ei mek puk, rʉp wu,’ mbʉ kʉn, nʉk mot ndʉi! ‘Wamp nam ti ndi, elim nga ʉngʉn ei kundpa, nim kur kupʉr wamp ti kant ei ka!’ nim ndam, nim wamp ei ndip kona ila mindil nomba. ");
INSERT INTO med_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Wamp ti ndi, Got kʉn rat pol wingti ila mel mat, wei gem nguimp nʉkʉn, oⱡa pukʉn molkʉn, wamp mbo ei kʉn, ik puⱡ mat ropa mondpa nimba pilpa em ik ei, omba rondum pin ndam, nim nga wei gem ngʉn mekʉn mel ei, rat pol wingti ei nga kuimp keta ila tʉkʉn kelkʉn, tʉkrʉk yant okʉn, wamp mbo ei kʉn, pem ik mbʉ nʉkʉⱡ mʉn mondkʉⱡ kʉn, yant okʉn, wote Got wei gem nguin mekʉn pun mel ei ngui. ");
INSERT INTO med_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wamp ti ndi, nim mepa kot indimp nim ndam, wamp ei kʉn, ik puⱡ pem ei kot manga ila pi nʉpi kʉn, nombuⱡa paka ila unt nʉk rotʉk tʉl muna, i iti natʉkʉⱡ, kot manga ila kun punggil ndam, nim tʉpa wamp kʉmp tʉtʉm wu ei kʉn ngangga wu ei ndi, nim tʉpa, el nde wu kʉⱡ kʉn ngangga, nim mek puk kan nguing. ");
INSERT INTO med_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ik kupa ei, nim kondʉp nʉnt, mel punt mat nim kʉn petʉm mbʉ, punt rokʉn pora ndun ndam, mint kan manga ei wak rokʉn ekit pin,” nitim. ");
INSERT INTO med_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas ndi, nimba mel, “Tʉn nga anda kouwʉmʉn mbʉ ndi, Jura wamp mbʉ, man ngok nitmin pʉtmin ik ei, ‘Wu ti nga amp ei tek pi nʉpʉi,’ nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ni nga wote, akup ila na ndi, enim ik i etʉp kundʉp nʉnt. Wu nam ti ndi, amp ti kandpa amp kant ei, tep pilmba ndam, pʉp nimba pʉtʉm. Uⱡ ni ndi, mundmong ila amp ni, unt tepa pepa pora ndurum. ");
INSERT INTO med_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ei kʉn, nim nga mong orunga ndi, nim etpa nit paka ila pendʉm ndam, mong orunga polkʉn tʉkʉn, rok mundʉk kili! Kʉng ei nga mel imp tenda ti ndi, etangga nim nga kʉng kʉⱡ pʉkʉ, ndip kona ila mba ei mon. Kʉng ei nga em mel tenda ei, kʉng ila muⱡi nambʉⱡʉm uⱡ ei kai. ");
INSERT INTO med_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Muna, nim nga ki mbo orunga ndi, nim etpa nit paka ila pendʉm ndam, koⱡmung etkʉn mondʉk kili! Ki tenda ei ndi, etangga nim nga kʉng kʉⱡ pʉkʉ, ndip kona ila mba ei mon. Em ki ei nga koⱡmung kopʉt, ki ila muⱡi nambʉⱡʉm uⱡ ei kai! ");
INSERT INTO med_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tʉn nga anda kouwʉmʉn mbʉ ndi, Jura wamp mbʉ man ngok, ‘Wu nam ti ndi, elim nga ambʉm ei, mondpa kelim ndam, amp ei akup mondʉp kent nimba, wu amp ndenggʉⱡa ndui pepa ti ropa ngangga.’ ");
INSERT INTO med_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ni nga wote, akup na ndi, enim ik i etʉp kundʉp nʉnt, wu ti ndi, ambʉm ei, wu elpa ti ndi, tepa pi nʉpangga. Ik elpa tila nimba, oⱡa ndupa tepa ambʉm mundpa kilangga, amp ei mba wu kont nga ti pum ndam, wu elpa tʉpa tepa pei uⱡ ei nga mong ei, amp mundpa kelim wu ei tʉmba. Wote, mundpa kelim amp ei, tʉm wu ei, amp elpa tepa pei uⱡ ei nga mong ei tʉmba. ");
INSERT INTO med_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tʉn nga anda kouwʉmʉn mbʉ ndi, Jura wamp mbʉ man ngʉk nʉtʉng petmin ei mel, ‘Nim nga mi tekʉn itimp nin uⱡ ei, rokʉn puⱡa rui nʉri! Wote, nim nga Got ei kʉn, mi tekʉn itimp nin uⱡ ei mel etkʉn kapⱡa indi.’ ");
INSERT INTO med_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Ni nga wote, akup ila na ndi, enim i etʉp kundʉp nʉnt, nim mi tekʉn uⱡ ti itimp nʉkʉn pin ndam, kona ti mbi tekʉn ni nʉni! Wote ik ti nʉmp ronduⱡ mundimp nʉkʉn, muⱡ kona ei mbi ti nʉti! Nambuⱡ emel, muⱡ kona ei Got nga rʉpndi pol ei, muna ya mʉi ei mbi ti nʉtʉi! Ei nambuⱡ emel, ya mʉi ei, Got nga kʉmp raⱡ kambitim kona ei, muna Jerusalem mbi ti nʉti! Nambuⱡ emel, Jerusalem ei, Got wu peng mumuk ei nga kona peng ei tetʉm. ");
INSERT INTO med_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Muna ik ti nimp ronduⱡ mundimp nʉkʉn, nim nga peng ombʉl ei ʉmbʉⱡi nʉmbʉⱡi. Nambuⱡ emel, nim nga peng ombʉl ei ambuⱡana. Nim nga peng ndi kot kep, pomp ndumba muna, kurʉmʉⱡa iti natʉmba. ");
INSERT INTO med_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nim nga nin ik ei, kapⱡa nin ndam kep, mon nin ndam, ik tenda ei ni, merʉng ik mat pendʉp nʉmp ronduⱡ mundimp nʉkʉn nin ndam, Seitan kʉn orum ik mbʉ nin. ");
INSERT INTO med_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tʉn nga anda kouwʉmʉn mbʉ ndi, man ngʉk niting pʉtmʉn ei mel, ‘Wamp ti ndi, nim nga mong orunga ropa tʉm ndam, mong elim nga mong ei rokʉn ti ku, nim nga gu ei ropa randum ndam, elim nga gu ei ku rokʉn rʉngʉn.’ ");
INSERT INTO med_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ni nga wote, akup ila na ndi, enim i etʉp kundʉp nʉnt, wamp ti ndi, nim kʉn uⱡ kit mat em kandkʉn, ei mel ku etʉp punt rop tamp nʉkʉn iti nʉti! Wamp ti ndi, nim nga keng orunga ki ⱡurwa nde rom ndam, keng orunga nont ndana pendpa rangga! ");
INSERT INTO med_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wote, wamp ti ndi, nim nga wal pʉki kel rukrʉng orunga kʉⱡ tʉmp nimba, nim mepa kot endim ndam, nim nga wal pʉki ekit orunga kʉⱡ ngana pendpa tangga! ");
INSERT INTO med_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wamp ti ndi, pilkʉⱡ ngumba, nim kona nundpa tila, pi nim ndam, nim ndi, oma kona roⱡ tila pi. ");
INSERT INTO med_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wamp ti ndi, nim mel ti waldʉm ndam, waldʉm mel ei ngui! Wamp ti nim nga mel ei mep mbo etʉp, wote mep omp ngeimp nim ndam, wak rok ngana mepa etpa, wote mepa omba ngangga! ");
INSERT INTO med_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tʉn nga anda kouwʉmʉn mbʉ ndi, man ngʉk nʉtʉng pʉtmʉn ei mel, ‘Nim numan ngʉng wamp mbʉ numan ngukʉn, nim numan ngangʉng wamp mbʉ, numan ngui ngʉngi,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ni nga wote, akup na ndi, enim i etʉp kundʉp nʉnt, nim nga el rui wamp mbʉ numan ngokʉn, nim rok pint panda eng wamp mbʉ, Got kʉn atinga rundi. ");
INSERT INTO med_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Uⱡ ei mel etangina, oⱡa muⱡ kona Wuta ei nga kangambuⱡa ralk muⱡeing. Oⱡa nuim ndi, wamp kit, kai mbʉ kʉn, ant tenda ei nga rʉⱡang ei wamp mbʉ kʉn, ngumba kapⱡa endʉtʉm. Wote kona ndamʉng ei, i ku etpa rangga nilinga, wamp kit kai mbʉ mormin kona ila rorum. ");
INSERT INTO med_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ei kʉn, nim numan ngʉng wamp mbʉ ku, numan ngʉn ndam, wote Got ndi, nim namba tangga mel ti ngumba? Gapman nga ku moni takis tʉndʉtmin wu mbʉ, uⱡ emel etmʉn ei ka. ");
INSERT INTO med_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wote, nim nga wamp puⱡ na, wamp min na mbʉ mint ik rungʉndʉn ndam, uⱡ ei mbo wamp mbʉ kʉn, uⱡ kont ti mon? Got kʉn mondpa pili nʉpili wamp mbʉ, i ku etmʉn. ");
INSERT INTO med_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ei kʉn, nim nga oⱡa Wu Tipanʉm ei, muⱡ kona ila kun kai morum ei mel, nim i ku etkʉn, kun kai muⱡi! ");
INSERT INTO med_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nim kandʉk neing nʉkʉn, nim nga wamp minal moⱡung ila tʉpa rʉpndi uⱡ mbʉ iti nʉti! Uⱡ ei mel in ndam, nim nga Oⱡa Wu Tipanʉm ei ndi, nim muⱡ kona ila mel ti ngui ngangʉmba. ");
INSERT INTO med_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ei nga nim ndi, wamp ki ngui uⱡ ila, wamp korpa num ti mel ti ngʉn ndam, wamp ndi, kandʉk neing nʉkʉn na uⱡ ti iti nʉti! Wamp mat ndi, kun kai mul kump ralk manga wingti na, kona peng na mbila wamp ndi kandʉk, en enim nga mbi ei, mek oⱡa piyeing nʉk etmin. Enim ik kupa ei kundʉp nʉnt, wamp ndi kandʉk, neing nʉk elingina, kandʉk nitmin uⱡ ni ndi, muⱡ kona ila ting mel ei, tʉk pora ndurmʉn. Wote Got ndi, mel ti ngui ngangʉmba. ");
INSERT INTO med_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ei kʉn, nim ndi, wamp ki ngui uⱡ ila wamp korpa nom ti tʉk rʉpʉndʉn ndam, nim nga wamp min ti, in uⱡ ei pili nʉpʉlangga. ");
INSERT INTO med_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wote, wamp roldʉnga ei, pili nʉpʉlʉng. Nim nga muⱡ kona Wu Tipanʉm ei ndi, uⱡ mo ropa in mbʉ kandpa kʉn mel kai ti punt ropa ngumba. ");
INSERT INTO med_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nim atinga ruin ei kʉn, kun kai mul kump rʉl wamp mbʉ, etmin ei mel iti nʉti! Wamp mbʉ ndi atinga manga na kona pena na mbila, numan mondʉk, anggilik atinga rormʉn. I etamin ei, wamp ndi, kandʉk, enim nga mbi ei, mek oⱡa piyeing nʉk etmin. Nim ik kupa ei kundʉp nʉnt, wamp kandʉk niyeing nʉk elingina, kandʉk nitmin ni ndi, ting mel ei tʉk pora ndurmʉn. ");
INSERT INTO med_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nim atinga ruin pilkʉn, manga ila murʉk pukʉn, manga kumba angʉndkʉn, nim nga muⱡ kona kʉni nʉkʉni! Wu Tipanʉm ei kʉn, atinga rui! Nim nga muⱡ kona Wu Tipanʉm, uⱡ mo ropa iti na, numan rukʉr pili na mbʉ, kandrum wu ei ndi, nim mel kai ti punt ropa ngumba. ");
INSERT INTO med_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nim atinga ruin ei, mbo wamp atinga ropa kʉni nʉkʉni, wamp ralkʉn, ik mong puⱡ pi nʉpi mat, ou nduk ni nʉni! I etpʉn, atinga roⱡ mat ramina, Got ndi, pilmba ku nʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Atinga rok roⱡ purmin ei mel, rui nʉri! Nim nga Tipanʉm Got ndi, nim pilik rondkʉn, mawa in mel ei, mawa iti nʉti, unt pilpa pora ndurum. ");
INSERT INTO med_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Atinga ya ei mel rʉi! ‘Tʉn nga muⱡ kona Wuta o! Nim nga mbi ei, tʉp wingti rʉndamin! ");
INSERT INTO med_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nim nga wamp tʉpa mumuk rui uⱡ ei wangga! Muⱡ kona ila nim nga man ik pʉtmʉn ei mel, ya mʉi kona mbila i ku itamin! ");
INSERT INTO med_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Akup nga nuimin rʉng mbʉ nguiyo! ");
INSERT INTO med_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tʉn nga uⱡ kit imʉn mbʉ wak rundi! Tʉn ndi, i ku etpʉn, tʉn kʉn uⱡ kit eng wamp mbʉ nga uⱡ kit mbʉ wak rundmin. ");
INSERT INTO med_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tʉn uⱡ kit mbila oⱡa tʉkʉn kʉni nʉkʉnʉi! Wote tʉn wu kit ei nga kan ila tinga ndukʉn tiyo!’ ");
INSERT INTO med_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nim ndi, nim kʉn uⱡ kit eng wamp mbʉ nga nit mbʉ, pendʉk kin ndam, nim nga muⱡ kona Wu Tipanʉm ei ndi, nim nga uⱡ kit mbʉ pendpa kelmba ku. ");
INSERT INTO med_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wote, nim kʉn uⱡ kit eng wamp mbʉ nga nit mbʉ pendʉk kili nʉkʉn ndam, nim nga muⱡ kona Wu Tipanʉm ei ndi, nim nga uⱡ kit mbʉ pendpa kili nakilmba ku. ");
INSERT INTO med_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Enim Got nga nʉk rʉng mi rok, mowi ping pilik, kun kai mul kump rʉl wamp mbʉ ndi, kuimp keta kit kit pilik, mowi petmin ei mel pi nʉpʉi! Wamp mbʉ ndi, en enim nga kuimp keta kit kit petmin uⱡ ei, mot nga etangga, wamp ndi, rʉng mowi peng nʉk kandʉk, neing nʉk etmin. Nim ik kupa ei kundʉp nʉnt, wamp mbʉ ndi, kandʉk neing nʉk elingina, kandʉk nitmin uⱡ ni ndi, ting mel ei tʉk pora ndurmin. ");
INSERT INTO med_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Nim rʉng mowi pin ei kʉn, kuimp keta el ⱡumʉi rokʉn peng ndi, kom etkʉn, in uⱡ ndi, nim rʉng mowi pin uⱡ ei mot nga iti natʉmba. Nim nga muⱡ kona Wu Tipanʉm, uⱡ mo ropa nimba iti na, numan rukʉr pili na mbʉ kandrum wu ei ndi, nim punt ropa mel kai ti ngumba. ");
INSERT INTO med_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ya mʉi kona ila mel kai mat kui koka nomba, wu raⱡ ropa, wote kʉndʉp wu mbʉ ndi, manga akʉk, waning ting mel mbʉ nga ou ndup, tʉp mou rop timp nʉkʉn it nʉti! ");
INSERT INTO med_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ei mon, nim nga mel ou ndupa, muⱡ kona ila tʉk mou rui, kona ila kui ndi nandʉmba ku. Wote, wu raⱡ rui narʉmba. Wote, kʉndʉp wu ndi kep, manga akʉk waning ti nʉting ku. ");
INSERT INTO med_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ei nambuⱡ emel, nim nga numan ei, rʉk rʉk nim nga mel kai mbʉ, tem kona ila mba. ");
INSERT INTO med_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","“Nim nga mong raⱡ kʉng ei nga lam kiya norum ei mel kapⱡa, nim nga mong raⱡ kai em ndam, ‘Nim nga kʉng ei rʉⱡang mba,’ wote ‘Nim nga mong raⱡ kit moⱡum ndam, kʉng ei rumbʉⱡ moⱡmba.’ Nim nga rʉⱡang aⱡʉm ei, rumbʉⱡ moⱡum ndam, nim nga rukrʉng orunga ama rumbʉⱡ elpa ti mel moⱡmba! ");
INSERT INTO med_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wamp ti ndi, wu nuim raⱡ nga kongun kindmant endʉmba mel kapⱡa mon. Ti numan ngui nganggʉpa, ti numan ngumba. Ti kʉn, rʉmp ndupa, ti tʉpa pei mondʉmba. Enim ndi, Got nga kongun ei etʉk kʉn, ku moni kongun numan minal mondʉk, raⱡ tʉk rak nduk, kongun inding mel kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Na ndi, enim kundʉp nʉnt, enim kont molk, nu rʉng mbʉ kandʉk tʉk normin. Wote, enim nga kʉng orunga, muⱡ mbal mbʉ tʉk ralk etmin. Wote enim ndi, mel mbʉ nga numan ou ndupa pili nʉpʉlʉi! Enim kont mba mul muⱡnga ei, tek mormin ei mel ingk ei, rʉng mbʉ kʉn kapⱡa mon. Enim nga kʉng kʉⱡ muⱡ mbal ei mel mon, kʉng kʉⱡ mel ingk. ");
INSERT INTO med_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kʉi mbur nʉk andinmin mbʉ, kopʉt kʉnʉiya! Pana etʉk rʉⱡi nakʉrmin. Wote, rʉng manga tila kep, kona ruⱡ tila kep, puk rʉng nuing ei nga, ti natʉtmʉn ku. Ei nga, enim nga muⱡ kona Wu Tipanʉm ndi, namba mel, kʉi mbʉ nuing ei tʉpa ngorum! Ei nga, enim i ku, kʉi mbʉ mel mon. Enim wamp mbʉ ama mel ingk kʉⱡ. ");
INSERT INTO med_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Enim kont molk ping ei nga, kel rondum wamp ti, ya mʉi kona ila moⱡpa, ruⱡ mba mel kapⱡa mon! ");
INSERT INTO med_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Muⱡ mbal rʉⱡing ei nga, nambuⱡ emel, keⱡ ou nduk rondunmʉn? Plawa kuk na ndi, pana roldʉnga ila pʉnʉm ei kʉnʉiya! Mel mbʉ muⱡ mbal rʉⱡing ei nga mim iti natʉtmʉn. Wote, rʉng nuing ei nga pana ti etʉk rʉⱡi nakʉrmin. ");
INSERT INTO med_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ei nga, akup ila na ndi, enim i etpa kundʉp nʉnt, unt kor nga king Solomon ni wu ei, kng mel mbʉ nga ou ndupa ropa titim. Ei nga wote, plawa kuk na mbʉ eng norum ei mel, King Solomon nga wal pʉki na mbʉ, i etpa eng nui nʉndrʉm. ");
INSERT INTO med_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wote, ema pana mel roldʉnga mbʉ, akup kuk ropa, utʉma oⱡʉl nʉtʉm mel mbʉ, Got ndi, etpa muⱡ mbal mel eng nondrʉm ndam, wote ema pana mel roldʉnga mbʉ runggulk, tʉk ndip kalk etmin. Ei nga wote, nim wamp ei keⱡ mam ei, rondʉmba nʉmp pʉnt ei? Nim Got kʉn mondʉk pʉtʉn uⱡ ei, ronduⱡ pi napʉrʉm ei ka! ");
INSERT INTO med_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ei nga, na rʉng nuimp ei nant tila, tʉp nuimp muna, nu nuimp muna, muⱡ mbal mbʉ, nant tila timp nda? Nʉkʉn kel rundi nʉndi! ");
INSERT INTO med_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mbo wamp mbʉ ndi, rʉk rʉk mel mbʉ nga kel rondʉrmin. Wote, nim nga muⱡ kona Wu Tipanʉm ei ndi, nim mel ti nga mon ndurum ei pilpa morum. ");
INSERT INTO med_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ei kʉn, Got nga wamp tʉpa mumuk rui uⱡ ei nga kel rangga molkʉn, wote Got elim nga namba uⱡ mat indʉn nimba pʉtʉm ei mel in ndam, nim namba mel numan ngun mbʉ, ngangga kapⱡa etmba. ");
INSERT INTO med_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ei kʉn, utʉma nga mel mbʉ tʉkʉn, akup ila kel rundi nʉndi. Utʉma nga kel rundʉn uⱡ ei, elpa tetʉm. Ant tenda ti nga mindil nuimin uⱡ mbʉ, elim elpa tetʉm. ");
INSERT INTO med_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Wamp mat nga uⱡ eng mbʉ kʉmp tʉkʉn ni nʉni! Wote, ei mel ku, Got ndi, nim kʉmp ti natʉmba. ");
INSERT INTO med_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wamp mat nga kʉmp tʉkʉn, nin ei mel ku, Got ndi, nim kʉn i ku etmba. Nim wamp mat kʉn ronduⱡ mondʉk kʉn, nin ei mel ku, Got ndi, nim kʉn i ku etpa, ronduⱡ mondpa nimba. ");
INSERT INTO med_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nambuⱡ emel, nim nga angina nga mong waⱡ ila nde karʉⱡ tetʉm ei, tʉk mundimp nʉkʉn, nim nga mong waⱡ ila nde koⱡmung tetʉm ei, tʉk mindi namʉndʉn ye? ");
INSERT INTO med_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nim nga mong waⱡ ila nde koⱡmung ei tiyangga nʉkʉn, angina kondkʉn, ‘Ana raka moⱡa, nim nga mong ila nde karʉⱡ tetʉm ei, tʉp mundamp,’ nin ei kapⱡa etmba ye!’ ");
INSERT INTO med_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nim kun kai rʉl wu ye! Unt nim nga mong ila nde koⱡmung ei tʉkʉn mundkʉn kʉn, wote nim nga mong ei piral nangga kandkʉn, wote angina nga mong ila nde karʉⱡ ei, tʉk mundi! ");
INSERT INTO med_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mel wingti ti tʉkʉn owa mbʉ ngui ngʉngi! Wote nim ngun ndam, kelpa yant omba nim nomba. Nim nga tʉt pal kai mbʉ, kng moⱡʉng kuimp keta ila rok mindi nʉmʉndi! I in ndam, kamblik nim nim nduk ting. Atinga Ronduⱡ Mundʉk Rormin ");
INSERT INTO med_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Got kʉn mawa in ndam, mawa in mel mbʉ ngumba. Wote, mindil tʉkʉn kurun ndam, kandkʉn tin. Kumba ei rok gep gep ndun ndam, kumba ei tʉndʉmba. ");
INSERT INTO med_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pilpa kelpa mindil tʉpa mawa em ei ndi tʉmba. Pilpa kelpa mindil tʉpa kurum ei ndi, kandpa tʉmba. Pilpa kelpa mindil tʉpa kumba ropa gep gep ndun ndam, ei nga kumba tʉndʉmba. ");
INSERT INTO med_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wu nam ti ndi, kangʉm kang kel ti oka nuimp nimba, mawa em ndam, ku ti nguin ye? ");
INSERT INTO med_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ei mel ku, muna oma ti mawa em ndam, kimbuⱡa ti nguin ye? ");
INSERT INTO med_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Enim wamp kiraⱡ mbʉ ndi, enim nga kangambuⱡa mbʉ mel, kai mbʉ ngurmʉn. Ei mel ku, enim nga muⱡ kona Wu Tipanʉm kai ei ndi, mawa eng mel kai mbʉ teng ndupa ngumba.” ");
INSERT INTO med_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nim nga indeing nʉkʉn pʉtʉn uⱡ mbʉ mel ku, nim ndi, wamp mbʉ nga indi! Ya ik ei, Moses nga mi ik kʉⱡ kʉn, painui wu kʉⱡ nga mbo endʉtʉng ik mbʉ nga puⱡ mendpʉⱡ ei. ");
INSERT INTO med_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Keta puⱡ puⱡ kel ila murʉk pʉi! Nambuⱡ emel, ndip kona ila purum nombuⱡa mam ei nga keta puⱡ puⱡ ei, para etpa tetʉm ila ping ei, wei wei etpa tetʉm. Wote, wamp minal nombuⱡa ila purmʉn. ");
INSERT INTO med_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wote, omba uⱡ nga kʉnt nga kona ila nombuⱡa mam tepa purum ei nga keta puⱡ puⱡ ti ei, mindil tʉk purmin. Nombuⱡa mam ila, wamp onunga etʉk purmin. ");
INSERT INTO med_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ik kol painui wu mbʉ nga tʉk mendʉk muⱡʉi! Ekit orunga, kng sipsip kʉng kulk uing. Ei wote, wu mbʉ nga rukrʉng orunga numan ei, owa rakra na ei mel numan pendʉk uing. ");
INSERT INTO med_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wu mbʉ uⱡ eng ei ndi, tʉkʉn mindin. Ruwa rʉⱡwa ti ndi, ropa muⱡ pi napʉtʉm. Muna rakum ei ndi, neka mel ropa koⱡ muⱡi nambrʉm. ");
INSERT INTO med_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nde kai ti ndi, mong ropa kai mondrum. Wote, nde kit ti ndi, mong ropa kit mondrum. ");
INSERT INTO med_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nde kai kat ndi, nde mong kit kat rui narʉmba. Wote, nde kit kat ndi, nde mong kai kat rui narʉmba. ");
INSERT INTO med_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wote, nde mong kit rom nde ei, rui rok tʉk ndip ila kʉⱡing. ");
INSERT INTO med_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ei mel ku, painui wu kol ropa kʉⱡ nga uⱡ eng mbʉ mel, kandʉk poⱡ ndʉi. ");
INSERT INTO med_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Na kondʉk, ‘Nuim ei! Nuim ei!’ neng wamp mbʉ pʉkʉ, muⱡ kona tʉpa mumuk rui kona ila rukrʉng pi nʉping. Na nga muⱡ kona Wuta nga man ik ei pilik, tʉk teng ndung wamp mbʉ mint rukʉr ping. ");
INSERT INTO med_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wamp kʉmp tʉmba ui mam ni om kʉn, na kondʉk, ‘Nuim ei! Nuim ei!’ Nim nga mbi ila, Got nga ik mbʉ wamp nimbun ngurmʉn? Nim nga mbi ila, kur kit murum wamp mbʉ, nimbun tʉp mundi nʉmʉndʉrmʉn muna, nim nga mbi ila uⱡ rʉpndi mat wengʉndpʉn iti nʉtʉtmʉn ye?’ ");
INSERT INTO med_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ik ei mel nangina, na ndi, ik ei mel nimp, ‘Na enim kandʉp mbi ndui nandʉnt, kelik pʉiya! Enim punt kunt wamp mbʉ ye!’ nimp. ");
INSERT INTO med_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na nga man ik ei nga puⱡ mendpʉⱡ ei, pilpa tʉpa teng ndupa em wamp ei, wu mong rui ti elim nga manga ei, mepa ku pol ila rukrʉm ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kona ndamʉng tʉmʉ ropa, nu kui omba, kʉpkʉ ronduⱡ ropa itim. Ni kʉn, manga ei, nen nimba murum. Ei nambuⱡ emel, manga ei ku pol ila rukrʉm. ");
INSERT INTO med_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Omba wamp ti ndi, na nga ik mong kʉⱡ pilpa kelpa, wote tʉpa rei ndurum wamp ei, wu rundi ti manga mepa ku ok pena ila rukrʉm ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kona ndamʉng tʉmʉ ropa, nu kui omba, kʉpkʉ mam ropa itim ni kʉn, manga ni akpa tilinga mba pitim,” nitim. ");
INSERT INTO med_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas ik kʉⱡ mel nimba, pora ndurum ni kʉn, wamp minal morung nimbʉ ndi, ik ronduⱡ pi nitim nimbʉ, pilik min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jisas ni, mi ik mbo wu na nʉtmin mbʉ mel ni nʉndʉtʉm. Jisas nga ik ei, wu nuim mbʉ nga el ik nilingina, ronduⱡ purum ik ei mel nitim. ");
INSERT INTO med_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas komnga ila, mana urum ni kʉn, wamp minal purum ni mel pep rok akil tetʉng. ");
INSERT INTO med_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Orung ila kint pombuⱡma rurum wu ti omba, Jisas nga kuimp keta ila rumaⱡi pepa, nimba mel, “Nuim ei! Nim ndi pilana, kapⱡa em ndam, na etkʉn mbo kʉng tindin ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas ndi, ki ni rundpa wu ni, mindi ndupa nimba mel, “Nin ei mel endamp, mbo kʉng ta!” nitim ni kʉn, mint mbo kʉng titim. ");
INSERT INTO med_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wote, wu ni kundpa, “Kum tʉiya! Uⱡ ei ndi, wamp ti kʉn, timan rui nʉri pukʉn, Pris ei moⱡum ila, nim nga kʉng kʉⱡ tʉkʉn, ora ndana kʉnangga! Wote, Moses nga mi ik ei ndi, nitim ei mel, ‘Got kʉn angk ngui mel, ti mek ngana wamp ndi, nim kupa mbo kʉng tin nʉk, pilik ndeimp rondʉk, nim akup kapⱡa morʉn ming,’” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jisas omba Kaperniyum kona peng ila, ruk urum. Ni kʉn, Roman el wu ei nga wu peng ti ndi omba. Jisas kʉn kont iti ik ranggʉpa waldpa, “Nuim ye! Na nga kindmant kang wu ei, kui mam ti ndi, tʉl nga kʉmp ki raⱡ kep, roka ndupa iti natʉpa, ur mint pepa morum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wote, Jisas nimba mel, “Na kunda mbuⱡ, wu ei itamba, wei muⱡangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ni kʉn, el wamp nga wu peng ni ndi, punt ropa int ndupa nimba mel, “Mon, Nuim ei! Na wu kai nant ei nga mang kona ila uin? Ik mong ti ya morʉn ila nin ndam, na nga kindmant kang wu ei, kui pora nangga, omba mba ei nga pilip nʉnt. ");
INSERT INTO med_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na wu iti ti ku, wu nuim mat nga mana orunga moⱡʉp, iti nʉtmin uⱡ mbʉ, teng ndup et. Wote na ndi, el wu rʉⱡaip mat rʉp et ku. Rʉp et wu mbʉ kundʉp, ‘Pi!’ nʉt ndam, purmʉn. Omba ti kundʉp, ‘Ui!’ nʉt ndam, orum. Wote, na nga kongun kindmant wu ei kundʉp, ‘Ya ei mel iti!’ nʉt ndam, ei mel ku etʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ik i nitim ik ni kʉⱡ, Jisas pilpa min ngʉn mondpa, wamp elim pep rok orung nimbʉ kundpa, “Ik kupa ei, enim kundʉp nʉnt. Ya Isrel kona ila wamp ti, ya wu ei, mondpa pʉtʉm uⱡ ei mel, wamp ti kʉni nakʉndʉr. ");
INSERT INTO med_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pʉnmʉn an! Wamp minal al ant oⱡa ui orunga kʉn, wʉl ant mana pi orunga kʉn, tʉk tenda etʉk, mou rok ok, Aparam, Aisak kʉn, Jekop kʉn, tʉpa mumuk rui kona ila tʉk tenda etʉk, rʉng rat pol tenda ila molk nuing. ");
INSERT INTO med_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wote, tʉpa mumuk rui kona ei, puⱡ puⱡ ralk tilingina, wamp kʉⱡ, ekit orunga kona rumbʉⱡ mul ila rok ekit mundangina, gu konggilik gi nduk, ka rom rok etʉk muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisas ndi, el wu kuimbal ni kundpa, “Kapⱡa mang kona pa! Nim nga mondʉk pʉn ei ndi, nim nga nʉkʉn un uⱡ ei endʉmba,” nitim. Ni kʉn mint, kindmant kang wu ni nga kui ni pora nitim. ");
INSERT INTO med_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas mba, Pita nga mang kona moⱡpa kʉndrʉm mel, Pita nga kulpam amp ni, kui emʉngi roⱡnga pitim. ");
INSERT INTO med_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ni kandpa, amp ni nga ki ni, ambuⱡa nga kui ni wang nilinga, oⱡa moⱡpa, Jisas rʉng kaⱡpa ngumba itim. ");
INSERT INTO med_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wote, epindama kur kit moⱡpa itim, wamp minal mek orung. Kur kit murum nimbʉ, Jisas nga ik ila wamp mbʉ, wak reing nimba makrʉpa mondpa, kui rurum wamp nimbʉ, etpa wang ndupa itim. ");
INSERT INTO med_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Uⱡ ei mel elinga, Painui wu Aisaiya nga ik pai nurum kʉⱡ, omba kupa itim. I nimba kʉn, “Wu elim ndi, tʉn nga kui elpa elpa mbʉ nga mindil nuimin uⱡ mbun mbʉ, tʉpa mepa ruⱡ etpa purum,” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wamp minal ndi, Jisas elim murum kona nila, tʉk paⱡa elingina kandpa, elim nga kitip kʉni wu ni kʉⱡ kundpa nimba mel, “Num Galili noi ʉldʉ orunga pamin!” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mi ik mbo wu ti ndi, omba Jisas kundpa, nimba mel, “Ik mbo wu ye! Nim nant tila pun ei mel, na kandʉp pep rop uimp!” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wote Jisas ndi, ik punt ropa nimba mel, “Owa rakra mbʉ nga nde kuimp tetʉm. Kʉi mbʉ nga mi manga ei anggʉtʉm. Na Muⱡʉl Wu Kupa, mana ui ei nga peng kilanda ti mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kitip kʉni wu ni kʉⱡ nga ti ndi, nimba mel, “Nuim ei, na nim kʉn uimp ei nga tʉp kun etʉp mor. Ei wote, unt yant mbo, wuta kuⱡangga kʉn, tʉp on etʉp pendʉp uimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wote Jisas ndi, ik punt ropa, “Akup na punt ei mel kandkʉn nim pep rokʉn ui! Wote, wamp on mbʉ ndi, en enim nga on mbʉ tʉk ʉngʉndeing,” nitim. ");
INSERT INTO med_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas omba nu kanu kat ila, rukʉr purum ni mel, elim nga kitip kʉni wu ni kʉⱡ akil tetʉng. ");
INSERT INTO med_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ni kʉn, tʉngʉnda mint kona tʉmʉ mam ti tʉmʉn tʉpa oⱡnga, num ni pʉnin nimba omba, nu kanu ni kʉⱡ oi ndumba itim. Ni kʉn, Jisas ur pitim. ");
INSERT INTO med_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Elim nga kitip kʉni wu ni kʉⱡ ndi ok, ronduⱡ rok rʉt nduk, nʉk mel, “Nuim ei, tʉn nu ndi, tʉpa wangʉmba enim ei, pilkʉn petʉm ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wote Jisas ndi, punt ropa nimba mel, “Nambuⱡ emel, enim mundmong mam enmin! Enim nga mondpa pili ei ronduⱡ pi naprʉm kant ei ka!” nitim. Nimba oⱡa moⱡpa kona kʉpkʉ kʉn, nu pʉnin nimba urum ni kʉn, tiyu ni nilinga, tʉngʉnda mint kʉr nitim. ");
INSERT INTO med_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jisas elim nga kitip kʉni wu nimbʉ, min ngʉn mundʉk nʉk mel, “Wu ei namba wu ti nda? Kona kʉpkʉ ei ndi kep, nu pʉnin ei ndi kep, wu ei nga ik teng ndonmbil ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas omba, Galili noi orunga, Gandera wamp nga kona orunga ekit urum ni kʉn, wu ralt wamp on kona, ku manga ila molkʉⱡ, ekit okʉⱡ, Jisas kandʉk tʉtʉnggil. Wu raⱡ kor mbo kit ei nga murum mbʉ ndi, rok rakra mundʉⱡina, kona ila wamp mbʉ ruinggil elinggila, wamp mbʉ mundmong etʉk, nombuⱡa mam ila wamp andʉk iti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jisas urum ni, kandkʉⱡ ke nʉkʉⱡ mel, “Nim Got nga kangʉm ye! Tʉn kʉn nambuⱡ itimp nʉkʉn on? Muⱡ mʉi raⱡ pora ni nʉni. Tʉn unt tʉkʉn mindil nguin on ei ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wote, morung kona ila, kng ama puⱡi ila, rʉng nok morung. ");
INSERT INTO med_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kur nimbʉ ndi, kont iti ik ranggʉk nʉk mel, “Nim tʉn mak rʉkʉn mundin ndam, mak rʉkʉn kng kʉⱡ nga oⱡ ila mundana muⱡamin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wote Jisas ndi, kur kit nimbʉ kundpa nimba mel, “Wu raⱡ wak rok pʉiya!” nitim. Nilinga, kongundʉk ekit puk, kng mbʉ nga oⱡ ila, rukʉr puⱡina kng nimbʉ, komnga ramba ila, pʉkʉ rok, puk num ila pek, nu wanggʉk korung. ");
INSERT INTO med_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kng rʉp etʉng wu nimbʉ, pʉn nʉk, kona peng ila puk, Jisas ndi, uⱡ i etpa em mel ya, ya nʉk, wu ni raⱡ kur kit etpa, titim ni mel timan rok etʉng. ");
INSERT INTO med_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ik ei pilik, kona peng ila wamp petʉng nimbʉ puk, Jisas kandʉp timin nʉk orung. Ok kandʉk tʉk, Jisas kont iti ik ranggʉk, en enim nga kona ei wak ropa, mba kona elpa tila pangga nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas kelpa nu kanu urum ni kʉⱡ ila ku, rukʉr mba, num Galili puⱡa ropa, elim nga kona peng ila int purum. ");
INSERT INTO med_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kona peng ila wamp mat ndi, on por murum wu ti, rupⱡaima ila koma rok mek, elim urum nila orung. Jisas ndi, wamp mbʉ nga mondpa pili ronduⱡ purum uⱡ ei kandpa, wu on por mul ni kundpa nimba mel, “Na nga wu kangʉm ye! Numan wang ndui! Nim nga uⱡ kit mbʉ pendʉp kent,” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jisas nʉtʉm ik ni pilik, Moses nga mi ik mbo wu kat, en enim nʉk int yant etʉk, “Wu ei ndi, Got nga ik mbuldung orunga nindinim ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ik nʉtʉng ei, Jisas ndi, tʉpa mendpa nimba mel, “Enim numan kit i etpa mbʉ nambuⱡ emel pʉnmʉn? ");
INSERT INTO med_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Nim nga uⱡ kit mbʉ pendʉp, kent nimp ik ei kapⱡa,’ muna ‘Oⱡa molkʉn nombuⱡa mam pi,’ nimp ik ei kapⱡa?” ");
INSERT INTO med_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ei mel, na Muⱡʉl Wu Kupa, ya mʉi kona ila ronduⱡ tep mor ei ndi, uⱡ it eng mbʉ pendʉp kilimp, nʉnt ik ei mel, itamba kandʉk poⱡ ndeing. Ei kʉn, on por mul wu ni kundpa nimba mel, “Oⱡa molkʉn, nim nga rupⱡaima kʉⱡ, koma rokʉn mekʉn mang kona pi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I pilinga, wu ni oⱡa moⱡpa, mang kona purum. ");
INSERT INTO med_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wamp ila morung nimba, uⱡ i itim ei nga kandʉk, mundmong etʉk, Got ndi, mʉi kona wamp, ronduⱡ mam ti ngurum ei ka! Nʉk kʉn, Got nga mbi paka rondrʉng. ");
INSERT INTO med_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas kona ni wak ropa, nombuⱡa mam ila mba kʉndrʉm mel, ku moni takis ti, wu Matyu ni, elim nga kongun manga ila murum ila kundpa nimba mel, “Na pep rokʉn ui!” nitim. Matyu, Jisas nitim ik ni pilpa, pep ropa akil tepa purum. ");
INSERT INTO med_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas kʉn, elim nga kitip kʉni wu kʉⱡ kʉn puk, Matyu mang kona ila puk rʉng norung. Ku moni takis ti wu na, punt wu minal rʉk ok, Jisas kʉn elim nga kitip kʉni wu kʉⱡ kʉn, morung ila molk, rʉk ndurʉng. ");
INSERT INTO med_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Perisi wu nimbʉ ndi, Jisas i etpa, rʉng numba murum uⱡ ni kandʉk, elim nga kitip kʉni wu nimbʉ waldʉk nʉk mel, “Enim nga ik mbo wu ei, ⱡawa etpa, ku moni takis ti wu na, punt ti wu na mbʉ kʉn, rʉng numba morum ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Waldʉtʉng ik ni, Jisas pilpa nimba int ndupa nimba mel, “Kui rui narʉrʉm wamp ei, dokta morum ila pi napʉrmʉn. Kui rorum wamp ei mint purmin. ");
INSERT INTO med_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Painui wu Oseiya ndi, mon ti ropa i nimba mel, ‘Got ndi, nim wamp elpa mbʉ kaimp kʉⱡ nimba pʉtʉm. Kng rʉng mel mbʉ, kaⱡpa tindiⱡim mundi uⱡ ei mon. Na wamp kun kai mbʉ kʉn, Got nga uⱡ mbʉ pep reing nʉmp ui nʉwʉr mon!’ nʉtʉm. Na uⱡ kit iti wamp na, wote punt ti wamp na mbʉ, etʉp timp nʉmp ur,” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wamp nu tindi wu Jon nga kitip kʉni wu kʉⱡ ok, Jisas murum nila waldʉk, “Tʉn kʉn Perisi wu kʉⱡ kʉn, rʉng mowi rʉk rʉk petmin. Ei wote, nim nga kitip kʉni wu kʉⱡ, rʉng mowi pi napʉtmin, ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wote Jisas ndi, ik punt ropa nimba mel, “Wamp tʉma ong mbʉ, amp tʉmba wu ei kont moⱡum ei kʉn, wamp tʉma ong mbʉ, numan kai pendʉk muⱡing. Wote, amp tʉmba wu ei, imp molk mek pung ei kʉn, wamp tʉma mbʉ, rʉng nandʉk kont kolk mowi ping. ");
INSERT INTO med_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wamp ti ndi, muⱡ uni kont ti tʉpa, wal pʉki unt nga kat mbila, nʉtʉm ila pendpa, kapⱡa ropa rumbʉⱡi nambrʉm. Ei nambuⱡ emel, muⱡ uni kont pendpa rambʉⱡʉm ei, ronduⱡ mba wal pʉki unt nga kʉⱡ mepa, rʉk omba ou ndupa ou ndurum. ");
INSERT INTO med_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Muna, wamp ti ndi, nu wain kont ei tʉpa, kng meme kʉng ming unt nga ila, oi ndupa mundi namʉndrʉm. I etʉm ndam, meme kʉng ming unt nga ei, wain kont ei ndi, pepa mbun itangga, meme ming ei rung nimba. Wote, wain kont ei etpa, kit ku moⱡmba. Mon, wain kont ei meme kʉng ming kont tila ku, ming rumʉn uⱡ ei ndi, nu kep, ming kep, pʉkʉ etpa kai moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas ik nimba moⱡnga, Jura wamp atinga manga kel rʉp wu ti, omba Jisas murum nila, mura ropa mondpa nimba mel, “Na nga mbuⱡam ambuⱡa ei, ʉkpi mendpʉⱡ koⱡmba enim. Wote nim okʉn, nim nga ki ei ndi, minda ndun ndam, kont mba moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ni kʉn, Jisas pilpa anggilpa wu ni purum mel akil tilinga, elim nga kitip kʉni wu nimbʉ, Jisas purum mel rʉp rok purung. ");
INSERT INTO med_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ni kʉn, nombuⱡa mam paka ila amp ti ku, puk ropa, mema omba mba mint moⱡnga, pana 12 omba purum amp ni ndi, omba Jisas nga wal pʉki roⱡ kʉⱡ nga punt ila, minda ndurum. ");
INSERT INTO med_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Minda ndupa numan rukʉr nimba mel, “Na elim nga wal pʉki kʉⱡ mint minda ndunt uⱡ ei ndi, na nga kui ei pora nimba,” ni pitim. ");
INSERT INTO med_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas tʉpa pelinga ndupa, amp ni kandpa nimba mel, “Na nga ambuⱡa ye! Nim numan wang nda! Nim nga mondpa pili ei ndi, ninim etpa wei mondnʉm,” nitim. Tʉngʉnda mint, amp ei nga mema rurum uⱡ ni kʉr nitim. ");
INSERT INTO med_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","I etpa pendpa, wote Jisas ni, mba rʉp wu ni nga manga ila, murʉk purum. Mba kʉndrʉm mel, koⱡa manga kowa pela ik ndurmʉn wu mbʉ kʉn, koⱡa manga morung, wamp nimbʉ nga ka rom ik ei, ama oⱡa purum. ");
INSERT INTO med_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas kandpa, omba nimba mel, “Enim wamp pʉkʉ, ok pena pʉiya! Ambuⱡa kel ei kuⱡi naⱡʉm. Ambuⱡa ei, ur mendpʉⱡ petʉm!” nitim. I nitim ik ni nga wamp ndi, ik nitim ni, tʉk ik ong paka pendʉk, oi endʉk etʉng. ");
INSERT INTO med_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jisas ndi, wamp nimbʉ pʉkʉ, makrʉpa tʉpa pena ndupa, pora ndupa, ambuⱡa on tetʉng ruⱡmina nila murʉk mba, ambuⱡa ni nga ki ni ambuⱡpa, oⱡa tilinga, ambuⱡa ni rʉt nimba, oⱡa murum. ");
INSERT INTO med_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Uⱡ itim ei nga timan ik ei nʉk, mek ekit puⱡmina, kona nondpa wamp mbʉ ndi, pilik kapⱡa endʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas kona ni wak ropa, nombuⱡa mam tila omba purum mel, mong titim wu ralt akil tekʉⱡ, wi nop nʉmp rokʉⱡ nʉkʉⱡ mel, “Depit nga kangʉm ye! Tʉl kont kun ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wote, Jisas manga ila murʉk purum ni kʉn, mong ti wu ni raⱡ akil tekʉⱡ, elim murum nila oⱡunggila, wu raⱡ kundpa nimba mel, “Na ndi, enmbil kapⱡa, etʉp timp ni kʉⱡ mondkʉⱡ pʉnmbil ye?” nimba wuldʉtʉm. Wote, ni wu ni raⱡ ndi, “Nuim ei! Nim ndi, kapⱡa tʉl etkʉn tin,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wote Jisas ndi, wu ni raⱡ nga mong ei, minda ndupa, “Enmbil nga mondpa pili ei ndi, enmbil etpa tʉnʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nimba, mong ni raⱡ etpa piral ndurum. Wote Jisas ndi, wu ni raⱡ kʉn, ronduⱡ mundpa man ngumba mel, “Ya ent uⱡ ei, wamp ti kundʉk ni nʉnʉl mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wote, Jisas nitim ik ni, pilik kelkʉⱡ, Jisas nga itim uⱡ ei, kona mbila timan roⱡʉnggila. Wamp ndi, pilik kapⱡa endʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wu ni raⱡ kelik poⱡunggila mel, wamp mat ndi, ik nʉndʉtʉm wu ti kur kit moⱡpa itim wu ti, mek Jisas murum ila orung. ");
INSERT INTO med_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Wote Jisas ndi, kur kit ni makrʉpa monduⱡnga, wu ni nga ik ei peⱡa nitim. Wamp morung nimbʉ ndi, kandʉk min ngʉn mundʉk ei mel nʉtʉng, “Tʉn ya, Isrel kona ila uⱡ ei mel ti, kʉni nakʉndʉrmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wote, Perisi wu nimbʉ ndi, nʉk mel, “Kur kit tʉpa ekit ndunʉm ei, kur kit mbʉ nga Nuim ei ndi, wu ei ronduⱡ ngurum ei nga enim,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas kona ou kel titim nimbila, atinga manga murum nimbila, andʉp Got nga kʉndʉk ik kai ei nimba ngumba. Omba elim ndi, Got nga tʉpa mumuk rui kona ei nga nimba. Wote, kui namba kui mbʉ nga pitim wamp mbʉ, etpa wei mondpa itim. ");
INSERT INTO med_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wote, Jisas wamp mam ti kʉndrʉm. Ni kʉn, kont minal kurum. Ei nambuⱡ emel, kng sipsip na mat, rʉp wu mon etʉm ni mel, wamp mbʉ, mindil nok pilik rondʉk puk morung. ");
INSERT INTO med_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","I itim ei nga kandpa, elim nga kitip kʉni wu ni kʉⱡ kundpa nimba mel, “Kongun rʉng mbʉ ou ndunʉm. Ei wote, rʉng tʉk mou ruing ei nga kongun wamp onunga enim! ");
INSERT INTO med_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ei nga, kongun rʉng puⱡ wu ei kʉn, atinga rangina, kongun wamp puⱡi tʉpa mundangga, rʉng mbʉ tʉk mou reing,” nitim. ");
INSERT INTO med_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas elim nga kitip kʉni wu 12 ni kʉⱡ, wi ropa rukʉr tʉpa, ronduⱡ ngumba kur kit moⱡum wamp mbʉ nga kur kit mbʉ, tʉk mundʉk, kui ou kel mbʉ nga elpa elpa pem wamp mbʉ, etʉk ting ei nga ronduⱡ ngurum. ");
INSERT INTO med_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Nombuⱡa rung wu 12 kʉⱡ nga mbi kʉⱡ ya ei mel, kuimbal murum wu ei, Saimon ei, mbi kont ti tek, Pita nitmin ni kʉn, ʉngʉn akil Andru kʉn, wu Sepeti kangʉm Jeims kʉn, Jon raⱡ kʉn, Pilip kʉn Bartolomiyu kʉn, Tomas kʉn, Matyu ku moni takis ti wu ni kʉn, Jeims wu Alpiyas kangʉm kʉn, Tatiyas kʉn, Saimon ei, wu el kum kat Rom rup wamp ei, ropa nga tʉpa mana nduimin nʉk etʉng. Wu kʉⱡ nga wu ei kʉn, Juras Iskariyot, wote Jisas rʉk murum wu ni kʉn. ");
INSERT INTO med_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas ndi, elim nga kitip kʉni wu 12 ni kʉⱡ, tʉpa kongun ila mundpa, ik kʉⱡ mel man ngumba mel, “Got nga ik nʉpʉl, mbo wamp mormin kona mbila kep, Sameriya kona mbʉ nga kona peng mbila kep, rukʉr pi nʉpʉi! ");
INSERT INTO med_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Enim puk Isrel wamp mbʉ, rʉp wu ti mon elinga, kng sipsip mel, tiki polk mormin mbila pʉi! ");
INSERT INTO med_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Puk kʉn, Got nga ik puⱡ i etʉk nʉk mel, ‘Got nga wamp tʉpa mumuk rui uⱡ ei nondpa omba nʉi!’ ");
INSERT INTO med_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kui peng em wamp mbʉ etʉk tʉk, wamp on mbʉ, rok rot nduk, kint pombuⱡma rorum wamp mbʉ etʉk tʉk, kur kit wamp kʉn moⱡum mbʉ, makrʉk tʉk mundʉk etʉi! Enim memp tʉnmin ei, wei nʉwʉ tʉnmin ei mel ku, wamp mbʉ ya nʉnt uⱡ mbʉ mel, gem ku etʉk pindʉi! Uⱡ mbʉ mel etpʉn, wote mel na ti, punt rok ngeing nʉk, pilik iti nʉtʉi! ");
INSERT INTO med_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ku moni mat tʉk enim nga kʉng ila pendʉk, mek pi nʉpʉi mon! ");
INSERT INTO med_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wal kumbana na kel kat kep, rapʉk mek pi mon. Wote, wal pʉki na ei nga kep, kʉmp rʉk mel mek pi nʉpʉi mon ku! Omba, nombuⱡa mam pangina, kʉmp ambuⱡmba ei nga tʉmbʉⱡ na ti kep mon ku. Nambuⱡ emel, pung kona mbila mel mbʉ nga tʉk kun inding. ");
INSERT INTO med_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Enim kona peng kel muna, manga rʉⱡaip na tila puk eng ei kʉn, wamp nam ti ngorum puⱡ orunga, kai etʉm wamp ei nga, manga ila pek muⱡʉi! Molk wote, kona tila ku pʉi! ");
INSERT INTO med_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wote, manga tila murʉk puk, manga puⱡ wamp ei kundʉk, moⱡpa kundi uⱡ ei, enim kʉn piyangga, ngʉi! ");
INSERT INTO med_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Manga puⱡ wamp mbʉ ndi, enim numan ngʉk, rawe etʉk tʉng ndam, enim nga memp ik ei, wamp kʉⱡ kʉn piyangga! Muna, enim numan ngui nganggʉk, rawe etʉk ti natʉng ndam, enim nga memp ik ei, en enim kʉn yant wangga, ngʉi! ");
INSERT INTO med_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wote manga rʉⱡaip ti ndi, muna kona peng kel ti nga wamp mat ndi, enim rawe etʉk ti natʉk, Got nga ik ei tʉk pei mundʉk tʉk, nguna kandʉk, piling ei nga numan ngui nganggʉk, eng kona ei wak rok, enim nga kʉmp kaimp ila kʉng ngupʉn moⱡum ei ila, ndanda nduk, tek kelik pʉi! ");
INSERT INTO med_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Enim ik kupa ei kundʉp nʉnt, muⱡ mʉi raⱡ pora nangga! Got ndi, wamp kʉmp tʉm ui ei kʉn, kona peng na, manga rʉⱡaip na mat, Got nga ik ei tʉk nguna kandʉk, tʉk pei mundʉk piling ei, numan ngui nganggʉk, enim wamp nimbʉ, mindil mam ti nuing. Ei, unt kor nga ei, kona Sorum, Gomora raⱡ, ropa kaⱡnga mindil norung ei mel mon. Wote, ama mindil elpa ti mel ku nuing. ");
INSERT INTO med_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kum tʉiya! Na ndi, enim owa rakra mormin kona ila, kng sipsip tʉk mondʉrmin ni mel, enim tʉp mundunt. Ei kʉn, kimbuⱡa mel tʉk mendʉk, kʉi imil mel, koma tek ʉndʉi! ");
INSERT INTO med_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Wamp ndi, enim imp molk mek puk, wu ou mbʉ ngangina, atinga manga kel mbila, kanda ndi rok iting ei nga tʉk mendʉk ʉndʉi! ");
INSERT INTO med_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Omba, mbo wamp moⱡʉng kona mbila na ndi, nʉi nʉnt ik mbʉ nʉk, itʉi nʉnt uⱡ mbʉ mel eng ei kʉn, enim tʉk mek puk, Rom kona mbʉ nga rup nokundurmʉn wu mbʉ kʉn, kona mbʉ nga wu peng mumuk mbʉ kʉn, moⱡʉng mbila, enim kot inding. Mbo wamp moⱡʉng mbila, i eng uⱡ ndi, na nga ik ei para mba. ");
INSERT INTO med_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Enim kot inding pilik imp molk mek ong ei kʉn, etʉp nʉmin mel nant nʉk, kʉⱡ keⱡ numan ou nduk pili nʉpʉlʉi! Enim nga ik ropʉl rok, ning ui ei om kʉn, Got elim ndi, enim nga keta ila nimba ngui ngui endʉmba. ");
INSERT INTO med_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ik ning ei, enim ndi, kanda ni nʉning. Enim ik ning ei mel, enim nga Oⱡa Wuta nga Muⱡnga ei ndi, enim kʉn moⱡpa, ni nʉndʉmba. ");
INSERT INTO med_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wu ʉngʉn ti ndi, ti rʉk muⱡangga rok kunding. Wu Tipam ti ndi, elim nga kangambuⱡa mbʉ, rʉk muⱡangga, rok kunding. Muna, kangambuⱡa ndi, en enim nga mam tipamʉl mbʉ, rʉk muⱡangina, rok kunding. ");
INSERT INTO med_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wamp minal ei ndi, na nga nʉndʉk eng uⱡ ila kandʉk, enim numan ngui ngʉnging. Ei kʉn, wamp nam ti ndi, na nga ik ei pewa aiwa nimba, ambuⱡpa gi ndupa muⱡangga, kot ending uⱡ ei, pora nim ndam Got ndi, wamp ei etpa tʉmba. ");
INSERT INTO med_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Enim kona peng ila pangina, tʉk kot ending ndam, kona ei wak rok kelik, kona peng elpa tila ku pʉi! Enim ik kupa ei kundʉp nʉnt, Got nga ik ei, Isrel kona peng tetʉm mbʉ nga kona peng mat ila kundʉk, ni nʉni muⱡangina, wote Muⱡʉl Wu Kupa ei, yant omba. ");
INSERT INTO med_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Skul kangambuⱡa ti ndi, elim nga ik mbo wu ei, tʉpa mana ndumba mel mon. Kindmant wamp ei ndi, elim nga wu nuim ei tʉpa mana ndumba mel mon. ");
INSERT INTO med_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ei kʉn skul kangambuⱡa ti ndi, ik mbo wu ei mel, kapⱡa muⱡimp nimba pilpa, mil kan etpa om ndam, kapⱡa etmba ku. Omba kindmant wu ti ndi, elim nga wu nuim ei nga kitip kandpa, kongun em ndam, kapⱡa ku etmba. Wote, wamp mbʉ ndi, manga puⱡ wu ei kundʉk, Biyelsipul kur kit mbʉ nga nuim ei, nʉng ndam, wote manga tenda ila petmin wamp mbʉ i ku etʉk, ik kit wei mat ku nʉnding. ");
INSERT INTO med_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ei kʉn, enim wamp mbʉ nga mundmong iti nʉtʉi! Uⱡ mo rok, ik mo rok nʉk eng mbʉ, etpa tʉpa mot ndumba. ");
INSERT INTO med_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na enim rumbʉⱡ ila, kundʉp nʉnt ik kʉⱡ, wote rʉnggilmʉ nʉk, mot ndʉi! Wote, enim ol tep kundʉp nʉnt ik kʉⱡ, tʉk pena ila pendʉk nʉi! ");
INSERT INTO med_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Enim nga kʉng kʉⱡ rok kunding. Wote, min ei rok kundi nʉkʉnding. Wote wamp mbʉ nga, mundmong indi nʉndʉi! Kʉng kep, min kep, pʉkʉ ropa, ndip kona ila mundʉmba wu Got ei nga mint mundmong indʉi! ");
INSERT INTO med_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kʉi waⱡ raⱡ nga ku kuⱡi tenda na, ei mel rop mundpʉn tilmina. Ei wote, enim nga muⱡ kona morum Wu Tipanʉm kupa ei ndi, kandpa kilangga, kʉi raⱡ nga ti tʉpa, kawa ndupa mana omba, koⱡmba mel mon. ");
INSERT INTO med_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Enim wamp mbʉ, nga peng ila, peng ndi namba iti morum ei, Got ndi pilpa ketʉm. ");
INSERT INTO med_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ei nga, mundmong iti nʉtʉi! Enim wamp mbʉ kʉi waⱡ na ei mel mon. Enim wamp ei, Got nga kuimp keta ila, mel numan ngui elpa ti mel ku mormʉn. ");
INSERT INTO med_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Wamp nam ti ndi, wamp moⱡʉng kona pena mbila moⱡpa, na nga para ndupa, nimba mot ndum ndam, na ndi i ku etʉp, na nga muⱡ kona Wuta morum ila, wamp ei nga nimp mot nduimp. ");
INSERT INTO med_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Muna wamp nam ti ndi, wamp moⱡʉng kona pena mbila moⱡpa, na nga ik ei pi napʉtmʉn nim ndam, na ndi, i ku etʉp, na nga muⱡ kona Wuta moⱡum ila, wamp ei na pi napʉt ku nimp. ");
INSERT INTO med_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Enim ndi, na ya mʉi kona ila, moⱡpa kundi uⱡ ei nga mep ur nʉk, pili nʉpilʉi mon! Na ya moⱡpa kundi uⱡ ei, mep ui nʉwʉr. Na ndi, wamp mbʉ etʉp, oi kan pindimp pilip, koiya nengina ti mep ur. ");
INSERT INTO med_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Puⱡ geka nangga nʉmp ur ei mel, na ndi, wu tipam kangʉm raⱡ, mam mbuⱡam raⱡ, amp apʉm apʉm raⱡ mbʉ, oi piyangga nʉmp ur. Wote, wu ti nga el puⱡa wamp mendpʉⱡ muⱡing kʉⱡ, elim nga manga tenda wamp kʉⱡ. ");
INSERT INTO med_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wamp nam ti ndi, elim nga mam tipam raⱡ numan minal ngumba. Na wei wei etpa, numan ngum ndam, wamp ei na nga kitip kʉni wamp moⱡmba mel kapⱡa mon! Wamp nam ti ndi, i ku etpa, elim nga kangambuⱡa mbʉ, numan minal ngumba. Na wei wei etpa, numan ngum ndam, wamp ei na nga kitip kʉni wamp moⱡmba mel, kaⱡpa mon. ");
INSERT INTO med_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wamp nam ti ndi, elim nga nde peta ei koma rui narʉpa, na kʉn pep ropa ui nawʉm ndam, na nga kitip kʉni wamp moⱡmba mel, kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wamp nam ti ndi, elim nga mʉi kona ila moⱡpa mba, uⱡ ei nga kel rondum ndam, wamp ei kont mba mul uⱡ ei ti natʉmba. Muna wamp nam ti ndi, na nga nʉndpa uⱡ mat itangga! Wote, elim rok kondung ndam, kont mba mul uⱡ kupa ei tʉmba. ");
INSERT INTO med_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Wamp nam ti, enim rawe etpa tʉm wamp ei, na rawe etpa tʉmba. Wote, wamp nam ti, na rawe etpa tʉm wamp ei, wi muⱡ kona na tʉpa mundrum wu ei, rawe etpa tʉmba. ");
INSERT INTO med_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wamp nam ti ndi wamp ei, Got nga nombuⱡa rung wamp ei nimba, rawe etpa tʉpa mepa, elim nga mang kona pum ndam, wamp ei Got nga nombuⱡa rung wamp ei nga punt mel, Got ndi, ngumba ei kunda tinggil. Wote, wamp nam ti ndi, wamp ei, uⱡ kai mbʉ etʉm nimba, rawe etpa tʉm ndam, wamp ei uⱡ kai mbʉ etʉm wamp ei nga punt mel, Got ndi, ngumba kunda tinggil. ");
INSERT INTO med_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na ik kupa ei nʉnt, wamp nam ti ndi, wamp kurpa ti kandpa wamp ei, Jisas nga kitip kʉni wamp ti, kant ei ka nimba, mbo nu kot nui nimba, kuⱡpa ngum ndam, wamp ei, Got ndi, wak ropa wei mundi namʉndʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas elim nga kitip kʉni wu 12 ni kʉⱡ, ik nimba, ndoimp rondpa pora ndupa, murum kona ni wak ropa, Galili orunga kona peng tetʉm nimbila, wamp ik mbo endpa, Got nga ik puⱡ nimba, ngumba etmba purum. ");
INSERT INTO med_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wamp nu tindi wu Jon ni, kan manga ila pepa moⱡpa, Kraist uⱡ enim nʉtʉng ik nimbʉ pilpa, Jon elim nga kitip kʉni wu ralt, Jisas murum kona nila tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wote okʉⱡ, Jisas nitim ik ni mel waldkʉⱡ, “Nim wu Jon ndi, wote omba nitim wu ni waⱡʉm, muna mon? Muna tʉn wu elpa ti nga nukʉndamin ye?” nitinggil. ");
INSERT INTO med_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wote Jisas ndi, ik pʉnt ropa nimba mel, “Int pukʉⱡ, Jon kun timan rokʉⱡ, ya uⱡ mbʉ mel kandpʉⱡ pilpʉⱡ onmbʉⱡ nil! ");
INSERT INTO med_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mong ti wamp mbʉ, mong piral ninim. On por morum wamp mbʉ, nombuⱡa mam andinmin. Wote, kint pombuⱡma wamp mbʉ, mbo kʉng tʉnmin. Kum ngorum wamp mbʉ, ik pʉnmʉn. Wamp on mbʉ, ropa rut nduⱡnga, kont monmʉn. Omba, Got nga ik kai mbʉ, wamp kurpa mbʉ kʉn, ik mbo endnim nil! ");
INSERT INTO med_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na nga uⱡ ent kʉⱡ ndi, wamp ti nga mondpa pili ei, ropa mbuⱡ mbaⱡ ndui nandʉm ndam, wamp ei kai pilangga nʉnʉm niⱡ!” nitim. ");
INSERT INTO med_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon nga kitip kʉni wu ni raⱡ kelik, Jon kʉn int puⱡʉnggila mel, Jisas ndi, wamp num morung nimbʉ, Jon nga nʉndpa nimba mel, “Enim unt kona kui waka ila namba mel, ei kʉning pilik purung? Nde kaipa mʉn ei, kʉpkʉ ropa, ruimp rika nitim ila, kʉning pilik purung ye? ");
INSERT INTO med_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Muna, wu ti kui kuk mbal raⱡpa, mʉkʉ etpa murum ila, kʉning pilik purung? Kui kuk mbal ralk, moke etmin uⱡ ei, wu nuim mbʉ nga mʉkʉ pena ila mormun ni. ");
INSERT INTO med_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Namba mel ei, kʉnmin nʉk, kona ila purung? Na kundʉk nʉiya! Pʉnmin an! Wu ni, painui wu mint mon. Wu ni, painui wu mbʉ, tʉpa mana ndupa, wu oⱡa orunga, wu elpa ti mel. ");
INSERT INTO med_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Got nga ik mong ti petʉm ei ndi, wu Jon ei nga nʉndpa mel, ‘Enim pilʉiya! Na nga nombuⱡa rung wu ei, kuimp tep tʉp mundamba mba, nombuⱡa mam ti ropa tʉpa kun indangga,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Enim ik kupa ei, kundʉp nʉnt. Ya mʉi kona wu metʉng mbʉ nga wu ti ndi, wamp nu tindi wu Jon ei, kapⱡa ropa mana ndumba mel mon. Wote, muⱡ ila Got nga tʉpa mumuk rui kona ila wamp mana ti ndi, Jon ni tʉpa, mana ndupa, elim ni oⱡa mba morum. ");
INSERT INTO med_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wamp nu tindi wu Jon ei, Got nga ik nimba ngumba ʉndrʉm ui ei kʉn, wote yant ndupa omba, akup monmʉn ui ila, Got nga tʉpa mumuk rui uⱡ ei, mindil mam mat tʉpa onum. Ei, punt wu mbʉ ndi, wu rok wei ai inding pilik enmin. ");
INSERT INTO med_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Uⱡ etmba mbʉ mel, painui wu na Moses nga mi ik na mbʉ ndi, wamp nu tindi wu Jon kʉn, wu Mesaiya raⱡ nga nʉndʉk, mint moⱡina, wote Jon ni ekit urum. Ei kʉn, akup painui wu mbʉ, Elaija yant omba, nʉk pilik mormin uⱡ ni nga, Jon ni Elaija mel urum. Ei pilik itʉi! ");
INSERT INTO med_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Enim kum nombuⱡa tem ndam, ik ei pilik kun itʉi! ");
INSERT INTO med_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Na ndi, akup ui ila wamp kat namba mel ei kʉn, to tindimp? Kangambuⱡa kel rarʉp rop kona pena ila molk, kindmal mel etʉk, ke nʉk int yant etʉk, ‘Tʉn enim ou nein nimbun nditing rumʉn ei, enim ou ni nandʉtʉng. Tʉn ka nde mundpʉn ka imʉn ei kʉn, enim ka iti natʉtmʉn,’ ni mel. ");
INSERT INTO med_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon urum ni kʉn, rʉng mowi pepa, nu wain nui nandpa itim ei kʉn, wamp ndi, ‘Kur kit ti mondpa morum,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jon moⱡnga kʉn, wote wu ei, Muⱡʉl Wu Kupa ni omba, nu rʉng mel mbʉ nurum ei kʉn, wamp mbʉ ndi, nʉk mel, ‘Wu ei kʉnʉiya! Wu ei rʉng wal numba, nu ronduⱡ minal numba, ku moni takis wu na, uⱡ kit etmin wu na mbʉ nga wu mʉn ei morum,’ nʉtʉng. Wote, Got nga uⱡ rʉpndi etʉm mbʉ ndi, elim nga pilpa kungʉndi ronduⱡ ei, tʉpa mot ndurum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas ndi, uⱡ wengʉndupa minal etpa, kona peng ila morung wamp mbʉ, ora ndurum. Wote, wamp mbʉ ndi, en enim nga uⱡ kit etʉng mbʉ, wak rui narʉrʉng kona peng ila petmin wamp mbʉ kʉn, ik mura itim. ");
INSERT INTO med_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jisas ndi, nimba mel, “Enim kona Korasin kʉn Betseita raⱡ nga wamp mbʉ ye! Enmbil kona raⱡ ila nga petmin wamp mbʉ kʉn, uⱡ kit mat etmba. Enim wamp mbʉ kʉn, uⱡ wengʉndupa mat etʉp, ora ndunt nimba, wʉl Taiya kʉn Sairon kona raⱡ ila elimba ndam, kona raⱡ ila wamp mbʉ, kandʉk etʉk rok, ui kik raⱡ etʉk, gel mbal ping mbʉ ralk, uⱡ kit etmin mbʉ, wak ronmʉn, nilingina. ");
INSERT INTO med_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Enim ik ti kundʉp nʉnt ei, tʉn wamp kui kont raⱡ kʉmp tʉm ui ei kʉn, enim wamp mbʉ, mindil mam ti nuing. Wote, kona Taiya kʉn Sairon raⱡ mindil kot onunga, etpa mel nuinggil. ");
INSERT INTO med_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Wote, nim Kaperniyum kona ei, kona peng kel mbʉ nga ronduⱡ mbʉ, nim ʉmbuⱡimp nʉkʉn pilʉn ei nga? Nim ropa ndip kaⱡmba ei ka! Nim kʉn uⱡ rʉpndi mat, unt etpa ora ndunt nimbʉ, Sorum wamp mbʉ kanduⱡina ndam, Sorum kona ei, akup uⱡ ila telinga. ");
INSERT INTO med_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Enim ik kupa ei kundʉp nʉnt. Wamp kui kont raⱡ kʉmp tʉm ui ei kʉn, Sorum kona wamp mbʉ, mindil orunga etʉk nangina, enim Kaperniyum nga wamp mbʉ, mindil mam ti nuing,” nitim. ");
INSERT INTO med_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ei kʉn, Jisas ndi, nimba mel, “Wuta, nim muⱡ mʉi raⱡ nga Wu Mumuk ei, nim kʉn angge nʉnt. Ei nambuⱡ emel, nim ninim ndi, wamp mong rui mbʉ kʉn, ik kupa kʉn, uⱡ kupa mbʉ kʉn, etkʉn mo rokʉn pendkʉn, wote kangambuⱡa kel mel mbʉ kʉn, apʉtkʉn tʉkʉn, mot ndukʉn etʉn. ");
INSERT INTO med_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wuta ye! Ninim ndi, itangga nʉkʉn pitin ei mel ku etʉm. ");
INSERT INTO med_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Na nga Wuta ei ndi, elim nga mel mbʉ pora, na ngumba rukʉr ndurum. Ei nga, na wu elim nga kanim ei nga numan ei, mana mʉi kona ila wamp ti ndi, kʉni nakʉndrʉm mon. Wuta elim ndi kandrum. Wote, Wuta nga numan ei, mana mʉi kona ila wamp ti ndi, kʉni nakʉndrʉm mon. Na wu elim nga kangʉm ei kʉn, wote elim nga kangʉm ndi, mbi ropa, titim wamp mbʉ, elim nga pʉtʉm uⱡ mbʉ mel, tʉpa pena ila pendpa, Wuta nga timan ik ei, wamp nam ti ndi, pilpa tʉtʉm. Wamp ki kunda. ");
INSERT INTO med_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Enim mbun koma ronmin wamp mbʉ, na kʉn wʉi! Na nanim ei ndi, enim etʉp piya nduimp. ");
INSERT INTO med_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na nga ik kupa nʉnt kʉⱡ, pilik rukʉr tʉk, na nga ent uⱡ mbʉ, pilik tʉi! Ei nambuⱡ emel, na wu koma ti, numan wang ndui wu ei mor. Enim nga min ei, omba kʉndʉk ndupa, moⱡmba kona ei na. ");
INSERT INTO med_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ei nambuⱡ emel, na ik mong enim mbo endʉnt kʉⱡ, wei wei etʉk pilik ting, omba na ndi, enim mbun ti kona rundimp ei pʉiya!” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mowi kor ou ui ei kʉn, Jisas kʉn elim nga kitip kʉni wu mbʉ kʉn, wit pana kuta tetʉm ei nga, rʉk ting nombuⱡa mam ila purung. Jisas elim nga kitip kʉni wu ni kʉⱡ, kump kun ndi kolk, wit ropa pitim nimbʉ nga mong mat, oldʉk kont norung. ");
INSERT INTO med_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","I etʉng uⱡ ni, Perisi wu mat ndi kandʉk, Jisas kundʉk nʉk mel, “Kana! Nim nga kitip kʉni wu kʉⱡ ndi, Moses nga mi ik ei, rok puⱡa rok, mowi kor ui ila, iti nʉtʉi nʉtʉm. Wote, uⱡ kʉⱡ enmin ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wote Jisas ndi, nimba mel, “Buk Wingti ila, Depit kʉn elim nga wu mbʉ kʉn, kump kun kurung ei kʉn, namba uⱡ ti etʉng ei, enim kʉmp rok pʉtmin, muna mon? ");
INSERT INTO med_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Elim Got nga manga ila murʉk mba, Got kʉn angge nʉk, bret ngorung mbʉ, tʉpa elim numba, elim nga wu kunda purung mbʉ, bret mat nguⱡnga norung. Angge bret mbʉ, Moses nga mi ik ei ndi, nimba mel, ‘Wu pris kʉⱡ mint neing,’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ei kupa, enim Moses nga mi ik ei, kʉmp rok kandʉrmin ei? Mowi kor ei kʉn, kongun mon nʉtʉm. Ei nga wote, wu pris kʉⱡ ndi, mowi kor ei kʉn, Got nga manga wingti ila murʉk puk, Got kʉn rʉng kalk tindiⱡim mundʉk etʉng. Ei wote, ⱡawa iti natʉtmin. ");
INSERT INTO med_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pʉnmʉn ye! Mel ti ya omba morum ei ndi, manga wingti nga ronduⱡ mbʉ, akpa tʉpa oⱡa ndupa morum. ");
INSERT INTO med_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Got nga ik mong ti, painui wu mbʉ ndi, rorung ei ndi nimba mel, ‘Wamp kont kul uⱡ ei, na numan ngor, omba kng rʉng mbʉ kapⱡa tʉndʉtʉm mundi uⱡ ei, na numan ngui nganggʉr.’ Ik ei nga puⱡ ei, enim pilingina ndam, ya wu nit muⱡi nʉmbʉⱡi kʉⱡ ik, ngui nganggʉⱡina. ");
INSERT INTO med_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na Muⱡʉl Wu Kupa ei, mowi kor ei nga Nuim ei,” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Jisas ik nimba, murum kona ni wak ropa, mba manga wingti kel tila, murʉk purum ila, wu ti ki orunga, kuⱡpa kel etʉm wu ti murum. Manga ila wamp mat, Jisas uⱡ ⱡawa mat enim, Jisas kʉn nimbun ndil ndil poⱡʉp nʉmin nʉk pilik morung nimbʉ ndi, Jisas waldʉk nʉk mel, “Mowi kor ei kʉn, wamp etpa ti uⱡ ei, Moses nga mi ik ei ndi, mon nʉtʉm uⱡ ei etmin ei, kapⱡa muna mon?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas ndi, punt ropa nimba mel, “Akup enim mormun wamp kʉⱡ nga, kng sipsip tenda ti mowi kor ei kʉn, mba kut tila mana pum ndam, enim nambuⱡ ti iting? Kng puⱡ wu ei ndi, kelpa oⱡa ti natʉmba ye? Ei mon, kng ei oⱡa tʉmba mint. ");
INSERT INTO med_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ei kʉn, enim wamp mbʉ, kng sipsip na mel nʉrnga mbʉ mel mon! Enim wamp mel imp ei nga, wamp ti mowi kor ei kʉn, wamp ti tʉpa rapʉndʉm ndam, kapⱡa etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","I nimba kʉn, ki kuⱡpa kel itim wu ni kundpa nimba mel, “Nim nga ki ei, tʉkʉn ron ndui!” nitim. Nilinga, ki ni ron nduⱡnga, tʉngʉnda mint ki ni, omba kai itim. ");
INSERT INTO med_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Perisi wu ni kʉⱡ, Jisas itim uⱡ ni kandʉk, popʉⱡ kolk int puk, kanggʉp ambulk, Jisas rop kundmin, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas elim ruimin nʉtʉng ik ni pilpa, kona ei wak ropa, kona elpa ronggʉt ku purum. Wamp minal ndi, purum ni mel, akil tek pep rok orung. Wote, rʉk ting mbila, kui peng itim wamp mat orung nimbʉ, etpa kai mundrum. ");
INSERT INTO med_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wamp etpa kai itim nimbʉ kundpa, int puk, na enim nga endʉnt uⱡ mbʉ wamp mat kundʉk, ‘Ni nʉnʉi! nitim. ");
INSERT INTO med_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I itim uⱡ kʉⱡ ndi, unt painui wu Aisaiya ndi, ik ti pai numba nitim ik ei, omba kupa itim, ");
INSERT INTO med_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ya wu ei, na kandʉp mbi ndup, tʉp mundʉr kongun wu ei, wu na numan ngor ei, wote na nga numan ei ndi, numan minal ngor ku. Na nga Muⱡnga ei, tʉp mundamba omba, wu ei kʉn moⱡmba, na nga wamp kʉmp timp uⱡ ei, muⱡ uⱡ wamp mormun mbʉ kʉn, kundpa nʉndpa kapⱡa endʉmba. ");
INSERT INTO med_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wote, nombuⱡa mam ʉldʉ mbila, elim nga kʉng orunga, mepa oⱡa mba el ik nimba, ik mura etpa iti natʉmba. ");
INSERT INTO med_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","El elim ndi, wamp wening em mbʉ kʉn, raka raka nimba uⱡ mbʉ etmba. El elim ndi, wamp wening eng mbʉ kʉn, uⱡ kai etʉk tʉk, rʉpʉndeing ei mel tʉpa ora ndumba. Uⱡ mbʉ, etpa mint pangga, Got nga pʉtʉm uⱡ kʉⱡ pilik, kapⱡa ending ei kʉn, uⱡ kit mbʉ, el etpa int pendʉmba. ");
INSERT INTO med_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wu ei ndi, enim muⱡ uⱡ ila wamp mbʉ, etpa tʉmba nʉk, nokundʉk muⱡeing,” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ei kʉn wamp mat ndi, kur kit ei ndi, wu ti nga rukʉr orunga moⱡpa, wu ei nga mong ei, kit etpa, keta mum petʉm wu ni, mek Jisas murum ila orung. Wu ni, Jisas ndi, etpa tilinga wu ei nga mong na, keta na mbʉ piral nilinga, ik nimba kona kandpa itim. ");
INSERT INTO med_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wamp minal morung nimbʉ, Jisas uⱡ itim ei kandʉk, min ngʉn mundʉk, “Wu ei Depit nga kangʉm ei muna?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Perisi wu ni kʉⱡ wamp mbʉ nga, waldʉtʉng ik ni pilik, punt rok nʉk mel “Kur kit mbʉ nga nuim Biyelsipul ndi, wu ei ronduⱡ nguⱡnga, ronduⱡ mondpa, kur kit ei tʉpa ekit ndonʉm,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Perisi wu kʉⱡ, i nʉk pilik etʉng ik nimbʉ, Jisas tʉpa mendpa ei mel nitim, “Wu rʉⱡaip tenda ti, rʉk ila palk, orung orung etkʉⱡ, el int yant enggil ndam, molk roⱡ pi nʉpʉnggil. Wote, kona peng ti muna, wamp mbo tenda kat kep, rʉk ila palk, orung orung etʉk, el eng ndam, kona peng muna, wamp mbo tenda kʉⱡ molk, roⱡ pi nʉpʉng! ");
INSERT INTO med_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ei mel ku, akup Seitan nga kona mumuk ila wu rʉⱡaip mbʉ, geka nangga, el rʉk eng ndam, Seitan elim nga rʉⱡaip mbʉ namba etʉk, ronduⱡ mundʉk muⱡing? ");
INSERT INTO med_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Enim na kur kit mbʉ nga nuim Biyelsipul ei ndi, na ronduⱡ nguⱡnga, kur kit mbʉ, tʉp mundunt ninmin. Akup enim kʉn, pep rormʉn wamp mbʉ nam ndi, ronduⱡ nguⱡnga, kur kit mbʉ tʉk mundʉnmʉn? I ninmin ik ei ndi, enim kʉn pep rok ormʉn wamp mbʉ ndi, kur kit tʉk mundʉnmʉn uⱡ ei ndi, ora ndupa, enim ⱡawa enmin. ");
INSERT INTO med_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wote, na kur kit tʉp mondunt uⱡ ei, Got nga Muⱡnga ei ndi, ronduⱡ nguⱡnga int ndam, ya ila ekpi mendpʉⱡ ora ndupa, Got nga tʉpa mumuk rui uⱡ ei, enim kʉn omba morum. ");
INSERT INTO med_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Wamp nam ti ndi, wu mong kundi ti nga mel mbʉ, namba etʉk, manga ambulk kʉndʉp ting. Tʉmba ndam, wu ei kapⱡa ambuⱡpa, kan ngumba, akil tepa mel mbʉ tʉmba. ");
INSERT INTO med_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na kʉn, rʉmp nanim ti ndi, na tʉpa rei ndupa, na nga wamp mbʉ, tʉpa rapundpa, tʉpa kʉkʉp iti natʉm ti ndi, ropa mboⱡ mbaⱡ etʉm. ");
INSERT INTO med_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ei kʉn, enim kundʉp nʉnt, wamp mbʉ nga wei uⱡ menʉpi na, ik kit Got kʉn, muna wamp ti kʉn, nʉng ndam, Got ndi, uⱡ nit mbʉ, wak romba. Wote, wamp nam ti ndi, Muⱡnga Wingti ei kʉn, ik kit minʉpi mat nimba, em ndam, wamp ei nga uⱡ nit mbʉ, Got ndi, wak rui narʉmba. ");
INSERT INTO med_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Omba, wamp nam ti ndi, Muⱡʉl Wu Kupa ei kʉn, ik kit mat nim ndam, wamp ei nga nit ei, Got ndi, wak romba. Wote, wamp nam ti ndi, Muⱡnga Wingti ei kʉn, ik kit mat nimba em ndam, nit mbʉ akup kep, wote kep, Got ndi, wak rui narʉmba. ");
INSERT INTO med_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nde kit ei ndi, mong kit mbʉ rorum. Nde kai ei ndi, mong kai mbʉ rorum. Nde kit muna, kai ei mong rorum. Ei kʉn, kandʉp kun etmin. ");
INSERT INTO med_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Enim kimbuⱡa mbʉ ye! Enim uⱡ kit mbʉ etmin. Ei nga wote, ik kai mbʉ etʉk, ning mel nant? Wamp numan ila peka ropa petʉm uⱡ mbʉ, keta ila ekit orum. ");
INSERT INTO med_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wamp kai ei ndi, numan kai mbʉ pendʉtʉm. Ei mel ku, ik kai mbʉ nʉtʉm. Wamp kit ei ndi, numan kit mbʉ pendʉtʉm. Ei mel ku, ik kit mbʉ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pʉnmʉn an! Wamp kit kai raⱡ kʉmp tʉm Ui Ou ei kʉn, wamp mbʉ ndi, elpa elpa ik kurpa karpa nʉk mek andinmin mbʉ mel, wote Got kundʉk ning. ");
INSERT INTO med_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nim tʉpa mong ngumba muna, tʉpa kun mundʉmba ei, nim nga nʉtʉn ik kʉⱡ ndi, nimba kʉmp tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ei kʉn, mi ik mbo wu mat kʉn, Perisi wu mat kʉn ok, Jisas waldʉk, “Ik mbo wu ye! Nim uⱡ rʉpndi ti itana kʉnmʉn ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ni kʉn, Jisas ndi, nimba mel, “Enim akup kalk tʉnmin wamp mbʉ, meka rok kelik, Got nga ik tʉk rui nduk enmin. Enim na uⱡ rʉpndi ti itamba kʉnmʉn ninmin ei? Ei mon! Na uⱡ rʉpndi ti itamba, kʉning ei, unt kor nga painui wu Jona kʉn, itim uⱡ kandrung ei mel ku. ");
INSERT INTO med_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ant raldika rumbʉⱡ raldika oma mam ei nga, oⱡ rukʉr ila pitim ei mel, Muⱡʉl Wu Kupa ei, mana urum mʉi min mana orunga piyangga, ant raldika rumbʉⱡ raldika etmba. ");
INSERT INTO med_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wamp kit, kai raⱡ kʉmp tʉm ui ei kʉn, Ninipa kona ila wamp mbʉ ndi, oⱡa anggilik, enim ik mura nguing. Ei nambuⱡ emel, wamp mbʉ ndi, Jona Got nga ik puⱡ nimba ngurum ei kʉn pilik, numan ropʉl rorung. Pʉnmʉn ye! ‘Ya ila wamp ti, omba morum ei Jona mel mon, wamp ama muⱡ ei! ");
INSERT INTO med_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wamp kit kai raⱡ kʉmp tʉm ui ou ei kʉn, mek Sipa kona Amp Kwin ei ndi anggilpa, enim ik mura ngumba. Ei nambuⱡ emel, amp ei, elim nga mʉi mana kona roⱡ ei wak ropa omba, king Solomon nga ik pilpa, kungʉndi mbo endʉtʉm mbʉ nga mat, pilimp nimba urum. Ei mel ku, enim nʉmp ndoimp rundamp, ya ila wu ti omba morum ei, King Solomon murum ei mel mon. Wu ei, ama oⱡa ndupa ei, omba morum!” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","“Kur kit wamp kʉn morum ei, makrʉk tʉk, ekit ndormʉn ei kʉn, mba kona kʉp, kui waka tila muⱡ tʉp, muⱡimp nimba purum. Wote, kona kʉp ei mel ti kandpa, ti natʉpa pilpa kʉn, ei mel nʉtʉm, ‘Na pep moⱡʉp unt manga ila kelip yant pamp!’ I nimba kʉn mba kandrum mel, manga ni ⱡumʉiya rok, etʉk mon mundʉk telingina, nuwa tetʉm. ");
INSERT INTO med_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ei kʉn int mba, kur kit 7 elim, ei mel mon, ok ila pek mormin. Ei kʉn, wamp ei akup morum ni, unt moⱡnga kit murum ei mel mon. Wote ama muⱡangga, kit elpa ti mel moⱡmba. Akup ui ila wamp rʉⱡaip kalk tʉnmin mbʉ, uⱡ ei mel etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas wamp nimba kʉn, ik nimba moⱡnga, elim nga ʉngʉnʉl mbʉ kʉn, mam kʉn orung. Ok pena orunga molk, Jisas kʉn ik rungʉndmin nʉmp onmʉn ei, ka nʉk, wamp morung nimbʉ waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Waldʉtʉng ik ni, wamp morung nimbʉ nga ti ndi, pilpa mba Jisas kundpa nimba mel, “Pʉn ei! Nim nga manim kʉn, ʉngʉnʉl mbʉ kʉn ok, nim kʉn ik rungʉndmin nʉk, pena anggilik mormun ei ka,” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wote Jisas ndi nimba mel, “Na nga manʉm kʉn, na nga ʉngʉnʉl kʉⱡ namin?” nitim. ");
INSERT INTO med_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I nimba kʉn, elim nga kitip kʉni wu morung ni kʉⱡ kʉn, ki ruⱡ ropa nimba mel, “Kanmin ei! Ya kʉⱡ, na nga mam kupa kʉn ʉngʉnʉl kupa mbʉ. ");
INSERT INTO med_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wamp nam ti ndi, na nga muⱡ kona Wuta ei ndi, itangga nimba pʉtʉm uⱡ kʉⱡ mel etʉm wamp, ei na nga ʉngʉn, na nga kimʉn, omba na nga mam,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","2","Ant tenda ei kʉn, Jisas murum manga ni, wak ropa mba, num Galili ei nga ʉldʉ ila, ik mbo endʉmba ei nga, murum kona ila wamp minal ok, num pelingina wamp nimbʉ, nu ʉldʉ ila mondpa kelpa, elim mba nu kanu kat titim kʉⱡ ila, rukʉr mba pol ila murum. ");
INSERT INTO med_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ila moⱡpa wamp mbʉ, ik minal mbo inditim. Ik ek mbʉ mint ropa nitim. Ik ek ti, ropa nimba mel, “Tʉnggʉt kʉn, wu ti pana ila wit mong mbo mundimp nimba purum. ");
INSERT INTO med_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wit mong mbʉ, mepa andpa ndanda ndupa munduⱡnga mat ni, nombuⱡa ʉldʉ ila titim nimbʉ, kʉi ndi ok norung. ");
INSERT INTO med_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wit mong mat, ku pol ila mana mba, mʉi wei wei etpa titim ila, tʉkrʉpa mʉlʉ ropa oⱡa urum. ");
INSERT INTO med_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wote ant ndi, oⱡa omba kʉndrʉm ei kʉn, kui nimba kurum. Ei nambuⱡ emel, ku pol ila pilkan mundʉmba, ei mel mon ei nga kurum. ");
INSERT INTO med_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit mong mat, mana puⱡnga kumbʉⱡ nde ⱡʉmbʉⱡ rong mul mbʉ kʉn, rukʉrʉⱡa etpa oⱡa urum. Wote, rʉng mong mbʉ, ropa kurʉp ila inditim. ");
INSERT INTO med_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mong mat mʉi kai ila, mana purum mbʉ, mʉlʉ ropa kai mondpa oⱡa omba mong rorum. Mat mong 100, mat mong 60, mat mong 30 ropa pitim,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ik ek kʉⱡ ropa pora ndupa ei nimba mel, “Kum nombuⱡa tem ndam, na ik nʉnt ei, pilik tʉi!” nitim. Jisas Ik Mbʉ Namba Elinga Ek Ropa Nitim? ");
INSERT INTO med_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wote, kitip kʉni wu, ni kʉⱡ ok, Jisas waldʉk nʉk mel, “Nim ndi, wamp mbʉ ik ek rokʉn, ik mbo endin ei, nambuⱡ emel en?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wote, Jisas ndi, nimba mel, “Enim Got ndi, muⱡ kona tʉpa mumuk rui uⱡ ei, ting ei nga ik mou ropa petʉm mbʉ nga pilpa kungʉndi nguⱡnga, pilik kun enmin. Wote, wamp wei mbʉ, ei mel mon. ");
INSERT INTO med_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pilpa kungʉndi tʉpa moⱡum wamp ei, Got ndi, pilpa kungʉndi ou ndupa ngumba, wote wamp ti pilpa kungʉndi ei nga, numan ngui ngangʉm wamp ei, pilpa kungʉndi onunga, etpa tʉpa moⱡum kʉⱡ, Got ndi, elim rukʉr tʉmba. ");
INSERT INTO med_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na ik ek puⱡi rop wamp mbʉ, ik mbo endʉnt. Ei nambuⱡ emel, ‘Kanmin ei wote, kandʉk mbi ndui nandʉnmin. Wote, kum tenmin ei, wote ik puⱡ ei, pilik kun iti natʉnmin,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ei kʉn, Painui wu Aisaiya ndi, ik ti unt kor nga pai nomba nitim ei, ya wamp kʉⱡ kʉn omba kupa enim. ‘Enim kum tek pili piling, wote pilik kun iti nʉtʉng. Kandʉk kʉni kʉning, wote kandʉk kun iti nʉting. ");
INSERT INTO med_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ei nambuⱡ emel, wamp mbʉ nga numan ei, piral ni nʉndʉtʉm, wote ik kum tek pili napʉnmin, wote mong raⱡ ndi, kʉni nakʉnmin. Muna uⱡ mbʉ mel iti natʉlina ndam, mong raⱡ ndi kandʉk poⱡ nduⱡina, kum raⱡ ndi, pilik kun etangina numan ei ndi, pilik ndoimp rondʉk, numan ropʉl rok, na wu Got ei kʉn, yant wangina, na ndi, wamp mbʉ etʉp tilmba!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wote, enim na nga kitip kʉni wu kʉⱡ kai pilʉiya! En enim nga mong raⱡ ndi, kandʉk mbi ndʉnmin omba, enim nga kum raⱡ ila pilik mbi rondʉnmin. ");
INSERT INTO med_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Enim nʉmp ndoimp rondʉp nʉnt, unt kor nga Painui wu minal kʉn, Got nga wamp minal mbʉ, akup enim kanmin uⱡ mbʉ mel kʉnamʉn nʉk pʉtʉng ei, wote kʉni nakʉndrʉng. Omba akup, pʉnmʉn ik mbʉ mel pilamin nʉk pʉtʉng ei, wote pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kum tek pilʉi! Rʉng mong mundi ik ek ei nga, puⱡ ei pilik, kun itʉiya! ");
INSERT INTO med_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mat ndi, tʉpa mumuk rui uⱡ ei nga, nombuⱡa rung ik ei, pilik ndoimp rundi nandʉrmin mbʉ, wit mong mat, nombuⱡa mam ila mana purum ei mel, Got nga ik ei, mundmong ila mbo mundʉk pendʉtmin ei, wu kit ei ndi, omba tʉpa ropa wei ai endʉtʉm ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Omba rʉng mong mat, ku pol titim mʉi mbila mana purum ei, Got nga ik ei pʉtmʉn ei kʉn, mint numan kai ndi, kurmin ei mel. ");
INSERT INTO med_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wote, pʉtmʉn ik ei, puⱡ pilkan etpa, roⱡ pi napʉrʉm. Ui mat kʉn wamp ei, Got nga ik pʉtʉm uⱡ ila wamp mat ndi, ei rok kongundʉk. Wote, mbun kandʉk tʉk ngʉk etmin ei kʉn, Got nga ik ei tʉk mbuⱡ ngurmin. ");
INSERT INTO med_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wote, rʉng mong mat ni, nde rong murum mbila, mana puⱡnga ndi, rong mul kʉⱡ ndi, ropa kurʉp ila inditim ei, tʉpa mumuk rui uⱡ ei nga, nombuⱡa rung ik ei pili pʉtmʉn. Wote, kʉng orunga mel mbʉ, kel rondʉk, kng mel mbʉ nga kom pendʉk etmin uⱡ ei ndi, Got nga ik mong ei, ropa kurʉp ila enduⱡnga, mong rui narʉrʉm. ");
INSERT INTO med_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Omba, wit mong mʉi kai ila mʉlʉ ropa kai itim ei, wamp ti, nombuⱡa rung ik ei, pilpa ndoimp rondrum ei ndi, mong ropa 100, mat ropa 60, omba mat ropa 30 endʉtʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wote Jisas ndi, ik ek ti ku kitip kʉni wu ni kʉⱡ, ku ropa ngumba nimba mel, “Muⱡ ila tʉpa mumuk rui uⱡ wu ti, ei ya ei mel kapⱡa, wu ti, elim nga pana ila, wit mong kai mat mundrum. ");
INSERT INTO med_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","“Rumbʉⱡ roⱡnga wamp pʉkʉ ur petʉng ni kʉn, pana puⱡ wu ei nga, el rui wu ti ndi, wit rʉng mundpa pinditim pol nimbila, eta kit mong mbʉ, mbo mundpa pendpa purum. ");
INSERT INTO med_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wote wit nimbʉ, mʉlʉ ropa mong kokila romba elinga, eta kit ni kʉⱡ, kunda oⱡa urum. ");
INSERT INTO med_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Wu ni nga kongun wamp mbʉ ndi nʉk mel, ‘Wu Nuim ye! Pana ila wit mong kai mbʉ nga, mint mbo mundrʉn. Ni wote, eta kit mat kunda oⱡa onmʉn ei, nant ila pitim mbʉ onum nda?’ nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ni kʉn, pana puⱡ wu ei ndi, punt ropa nimba mel, ‘Ei el rui wu ti ndi omba itim,’ nitim. Wote kongun wamp nimbʉ ndi, int nduk nʉk mel, ‘Tʉn mbun eta mbʉ rʉnggʉⱡpʉn mundamin nʉkʉn pʉn muna mon?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wote, pana puⱡ wu ei ndi, punt ropa nimba mel, ‘Mon nʉnt. Ei nambuⱡ emel, eta kʉⱡ rʉnggʉⱡmin nʉk itangina mel, wit mat pendpa rʉnggʉⱡpa oⱡa omba, ei nga mon,’ nʉnt. ");
INSERT INTO med_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Kandʉk kont itangina, eta mbʉ kʉn, wit mbʉ kʉn kunda oⱡa wangina, wit ropa rangga rʉngmin ui ei kʉn, tʉpʉn elpa elpa itmin. Ei kʉn, wit rangʉng wamp mbʉ kundʉp, eta mbʉ kuimp tek runggulk, ot rok tek ndip kʉⱡeing. Wote, wit rʉng mbʉ tʉk tenda etʉk mek pok, na nga wit rʉng tet manga ila tindʉi nimp!’” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas ndi, ik ek ti ropa nimba mel, “Muⱡ ila tʉpa mumuk rui uⱡ ei ya ei mel kapⱡa. Wu ti nde mastat mong mat mepa mba elim nga pana ila mbo mundrum. ");
INSERT INTO med_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nde wei mbʉ nga mong mbʉ wei, ya mastat mong ei mel wei kʉⱡ, wote mʉlʉ ropa oⱡa orum ei kʉn, pana ila kim na rʉng wei mbʉ, ropa mana ndupa mastat ei oⱡa purum. Wote oⱡa omba mam etʉm ei kʉn, kʉi mbʉ ndi, nde puⱡa mbila mi manga rok pek etmin,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ik ti, ek ropa nimba mel, “Got nga wamp tʉpa mumuk rui uⱡ ei ya ei mel kapⱡa. Amp ti ndi, plawa ila yis mundpa ropʉl mapʉl ropa, nu mundpa telinga, plawa ei mepa oⱡa orum ei mel,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas ndi, wamp nimbʉ kʉn, ik ek mbʉ mint, ropa kundpa nitim. Ik ti kʉn, para ndupa mbo indi nʉndʉtʉm mon! Ik mbʉ pora, ek mint ropa kundpa nitim. ");
INSERT INTO med_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I itim uⱡ kʉⱡ, painui wu Aisaiya nga ik nitim kʉⱡ, etʉp kupa indimp nimba nitim, “Na ik kundʉp nimp etʉp ik ek mint rop nimp, muⱡ mʉi raⱡ iti nʉti kʉn, ik mo ropa titim mbʉ, ndupa para ndup nimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wote, Jisas wamp num morung nimbʉ, kelik pʉi nimba mundpa, manga ila murʉk purum ni kʉn, elim nga kitip kʉni wu ni kʉⱡ ndi, akil tek ok nʉk mel, “Pana eta ei mel ik ek ron ni nga puⱡ ei, tʉn kundkʉn ni,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas ndi, punt ropa pendpa nimba mel, “Rʉng mong kai mbʉ mundrum wu ei, ‘Na Muⱡʉl Wu Kupa’ ei mel. ");
INSERT INTO med_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Pana kuta ei, ya mʉi kona ei mel, rʉng mbo kai kʉⱡ ei, Got nga tʉpa mumuk rui uⱡ ila wamp mormun ei mel, pana eta ei, Seitan ei nga wamp mbʉ mel, el rui wu ti, eta kit kʉⱡ, mepa omba mundrum wu ei, Seitan. Rʉng poⱡ roⱡnga ranggʉrʉng ei, muⱡ mʉi raⱡ pora nimba ei mel, rʉng ranggʉrʉng wamp mbʉ, anggelo mbʉ mel. ");
INSERT INTO med_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Wote eta mbʉ, tʉk mʉk rok, ndip pol etʉk, ndip karmin ei mel ku, muⱡ mʉi raⱡ pora nim ei kʉn, uⱡ ei mel ku pemba. ");
INSERT INTO med_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Muⱡʉl Wu Kupa ei ndi, elim nga anggelo mbʉ, tʉpa mundangga, Got nga tʉpa mumuk rui wamp mormin mbʉ nga mat ndi, wamp mat kʉn ⱡawa etmin. Wote, wamp mat uⱡ kit etmin mbʉ kʉn, anggelo mbʉ ndi, aprʉk ekit tʉk rok, ndip kona ku mel, kundpa moⱡum ila mundangina, gu konggilik gʉkʉr tʉk, ka rom rok muⱡing. ");
INSERT INTO med_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ei kʉn, Got nga kindmant endʉtmin wamp mbʉ, en enim nga tipam kʉnt ei nga tʉpa mumuk rui kona ila, kona ant na, rʉⱡang purum ni mel, rʉⱡang ti ku pangga muⱡing. Ei kʉn, enim kum nombuⱡa tem ndam, na nʉnt ik ei, kum tek pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Got nga muⱡ kona ila wamp tʉpa mumuk rui uⱡ ei, mel kai mat kongun kona tila mou rok pendʉtʉng. Ei kʉn, wu ti ndi, kandpa tʉpa numan ndi koⱡpa, wote mel mbʉ mʉi akpa, mou ropa pendpa. Wote mba, elim nga tepa morum mel mbʉ, rarʉp ropa ku tʉpa, wote ku mbʉ mepa yant mba kongun kona ei, rop ropa titim ei mel. ");
INSERT INTO med_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Wote uⱡ ti, muⱡ kona wamp tʉpa mumuk rui uⱡ ei, wu ti ndi, ku eng nui mat andpa kʉrʉrʉm ni mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wote, kurpa andpa mel ronduⱡ eng nui ei, kandpa tʉtʉm ei kʉn, int mba elim nga mel kai tepa morum mbʉ, mepa mba ku moni tʉpa ku moni mbʉ ndi, mepa yant omba, mel ronduⱡ eng nui ei, rarʉp ropa tʉmba ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Omba uⱡ ti, muⱡ ila wamp tʉpa mumuk rui uⱡ ei, ya ei mel, oma wal mundi wu mat ndi, oma wal mbʉ, num ila pendʉk, oma mbo elpa elpa mbʉ nga imp molk, tʉtmʉn ei mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Oma wal ei oma ndi, peka rurum ei kʉn, ʉldʉ ila ekit tʉk tek, oma mbʉ aprʉk tʉk, elpa elpa etmin. Oma kai mbʉ tʉk wal ila rakilik, oma kit mbʉ, rok mundʉk ketmin. ");
INSERT INTO med_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Muⱡ mʉi raⱡ pora nim ei kʉn, uⱡ ei mel ku etmba. Anggelo mbʉ ndi, ekit pok, uⱡ kit eng wamp mbʉ, aprʉk tʉk elpa mondʉk uⱡ kai etmin wamp mbʉ, aprʉk tʉk tila mondʉk iting. ");
INSERT INTO med_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Uⱡ kit iti wamp mbʉ rok tʉk, ndip ila rok mundangina, ka etʉk, gu konggilik, gʉkʉr tʉk muⱡing. ");
INSERT INTO med_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas ndi, nimba mel, “Enim ik mbo endʉnt mbʉ, pilik kun enmin muna mon?” nimba waldilinga. Wote, wu kʉⱡ ndi, nʉk mel, “Pilpʉn kun enmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wote, Jisas ndi, punt ropa nimba mel, “I pilik kun enmin pʉnt ei kʉn, mi ik mbo wu na ti ndi, muⱡ ila wamp tʉpa mumuk rui uⱡ ei nga kitip kʉni wu kandpa, kongun etʉm. Wu ti ndi, elim nga wal kum ila, elim nga mel unt nga, kont nga mbʉ pora, apʉtpa tʉpa, ekit ndurum ni mel kapⱡa,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Wote Jisas ni, ik ek nimbʉ pora ndupa, murum kona ni wak ropa, elim nga mʉi mang kona ila mba, atinga manga ila moⱡpa, ik mbo inditim. Ik pʉtʉng wamp nimbʉ ndi, pilik min ngʉn mundʉk nʉk mel, “Wu ei pilpa, kongundpa ni, ik na, uⱡ rʉpndi ronduⱡ na mbʉ, etpa pilpa titim mel nant nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Elim nga puⱡ ei, tʉn pilpʉn mormun ye? Elim wu kamnda ei nga kangʉm ant ko! Mam amp Mariya nʉmp pʉnmʉn ye? Jeims, Josep, Saimon, Juras min kʉⱡ, elim nga ʉngʉnʉl, wote elim nga amp kimʉnʉl mbʉ kep, ya tʉn nga kona ila mormun ant ko! Uⱡ mbʉ nam ndi, mbo inditim nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ik kʉⱡ mel nʉk pilik, Jisas nga itim uⱡ mbʉ, tʉk mbuⱡ ngorung. Ni kʉn, Jisas ndi, kandpa nimba mel, “Painui wu ti, kona elpa mbila, elim tʉk ou ndurmin. Wote, elim nga mang kona ila kep, elim nga wamp mema tenda mbʉ ndi kep, elim tʉk pei mondʉrmin,” nitim. ");
INSERT INTO med_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wu ei, uⱡ rʉpndi mat, Nasaret wamp mbʉ kʉn, etpa ora ndui nʉndrʉm. Ei nambuⱡ emel, elim ni, mondʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Ui ei kʉn, Galili kona ei, nʉkʉndrʉm wu Erot ni, Jisas nga timan ei pilpa, elim nga kongun wu ni kʉⱡ kundpa, nimba mel, “Wu ei, wamp nu ti ndi, wu Jon ni, ⱡoporpa oⱡa moⱡpa, wamp kui nga ronduⱡ ei, tepa uⱡ wengʉndupa mbʉ, enim nʉmp pʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ei mel nitim, ei nambuⱡ emel, unt Erot elim ndi nilinga, Jon ni tʉk imp molk, kʉmp ki raⱡ kan ngʉk, mek kan manga ila pendʉtʉng. Uⱡ ei mel itim, ei nambuⱡ emel, elim nga ʉngʉn Pilip nga ambʉm Erotiyas nga ik ei, kum tepa itim. ");
INSERT INTO med_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jon kan ngui ngʉngi ui ei kʉn, Jon ndi, Erot kundpa, “Nim amp ei tʉkʉn mekʉn andrʉn ei, ⱡawa etʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erot popʉⱡ koⱡpa, Jon rop kundimp nimba pitim ei, wote Jura wamp mbʉ nga mundmong itim. Ei nambuⱡ emel, wamp mbʉ ndi, Jon ei, en enim nga painui wu muⱡ ti, mondpʉn mormʉn nʉk pʉtʉng ei nga. ");
INSERT INTO med_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Erot elim metʉng ui ni, ekit urum ei kʉn, kng rʉng mbʉ kui elingina, wamp tʉma ok, nok morung ila, Erotiyas mbuⱡam amp wendʉp ni, moke etpa, pena omba, welt rʉrʉm ila, Erot ndi kandpa, numan ndi koⱡpa, mi tepa nimba mel, “Nim namba mel ti nin ei nguimp mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Amp ni nga mam ndi, kunt punt ropa nimba mel, “Ming tila, wamp nu tindi wu Jon ei nga peng ei, poⱡa rokʉn, mekʉn okʉn ngui!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","11","Wu king Erot ni, ik ei pilinga, mundmong ei mi elinga, ei pilpa kelpa ninim ei mel, tʉk ngʉi nitim. Ei nambuⱡ emel, unt wamp tʉma mbʉ nga kuimp keta ila, mi tepa nitim ei nga, wu mat tʉpa munduⱡnga, kan manga ila puk, Jon nga peng ei rok, poⱡa rok, mek ok, amp wendʉp ei nguⱡina, mepa mba mam ngurum. ");
INSERT INTO med_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon nga on ni, elim nga kitip kʉni wu ni kʉⱡ ndi ok, tʉk mek puk on etʉk pendʉk, wote puk, Jisas kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jon ni rorung timan ei pilpa, Jisas murum kona ni, wak ropa mba, nu kanu ila rukʉr mba, num noi orunga, kona tiyu nimba tʉtʉm tila purum. Wamp morung nimbʉ ndi, Jisas purum ik ni pilik, pep rok akil tek, Jisas purum kona nila purung. ");
INSERT INTO med_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas nu kanu ila ekit omba, wamp num pitim ila, kandpa kont ndi koⱡpa, kui peng itim wamp nimbʉ etpa titim. ");
INSERT INTO med_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kona ant ni mana puⱡnga, elim nga kitip kʉni wu kʉⱡ ndi ok elim kundʉk nʉk mel, “Kona kui waka ila, ant ei mana punum ei kʉn, wamp mbʉ pʉi nʉkʉn, mundana puk, manga rʉⱡaip nondpa moⱡum mbila, rʉng rarʉp rok iteing,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wote Jisas ndi, punt ropa nimba mel, “Wamp mbʉ pi nʉpeing, mon. Enim ndi, wamp mbʉ nuing rʉng mat ngʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Wote, tʉn rʉng mat, tep mul mel bret 5 kat kʉn, oma raⱡ kʉn mendpʉⱡ, tepʉn mormʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wote Jisas ndi, nimba mel, “Tek mormin rʉng kʉⱡ mek ok, na ngʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wamp num ni, numa pana ila, “Mana muⱡʉi!” nimba. Wote, bret 5 ni kʉⱡ kʉn, oma raⱡ kʉn, tʉpa ambuⱡpa, muⱡ ila oⱡa ndupa kandpa, Got kʉn angge nimba. Atinga ropa, bret nimbʉ, ambuⱡpa puk ropa, elim nga kitip kʉni wu mbʉ, ngumba nimba mel, “Wamp mbʉ, mok rok ngʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wamp morung nimbʉ, pʉkʉ nok pilʉng kundʉk, kapⱡa endʉtʉng. Noⱡina mba mana tʉtʉm nimbʉ, kitip kʉni wu kʉⱡ ndi, kowa wal 12 rakʉⱡina, peka rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Rʉng norung wamp mbʉ nga, amp, kangambuⱡa, wamp ei, kʉmp rui narʉk, wu mint kʉmp rorung ei, wu 5000 itim. ");
INSERT INTO med_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wote, Jisas ei ndi, elim nga kitip kʉni wu kʉⱡ ok, nu kanu ila rukʉr pok, kuimp tek puk, “Num Galili noi orunga muⱡʉi! Elim wamp mbʉ pʉi nʉmp mundʉp, akil tep wamp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wamp mbʉ pʉi nimba pendpa, elim komnga tila oⱡa mba, atinga romba pilpa purum. Kona ni rumbʉⱡ rʉrʉm ei kʉn, elim ni kou murum. ");
INSERT INTO med_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wote, ei kʉn ku, kitip kʉni wu ni kʉⱡ puk, num Galili rʉk ila pelingina, kona kʉpkʉ mam ti omba, nu ndi ropa elinga, nu kanu kʉⱡ ropa, noi ya itim. ");
INSERT INTO med_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kona rangʉmba pilpa, ⱡant gu nitim ni kʉn, Jisas nu ndi pol ila, elim nga kitip kʉni wu kʉⱡ morung nila urum. ");
INSERT INTO med_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wote, kitip kʉni wu ni kʉⱡ Jisas nu ndi, ila urum ni kandʉk, mundmong minal etʉng. “Ei kur ti, onum kant ei ka!” nʉk runga etʉk, ke nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ni kʉn mint, Jisas ndi, wu kʉⱡ kundpa nimba mel, “Mundmong iti nʉtʉi! Ei na ont, ronduⱡ puk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wote Pita ndi, ik punt ropa nimba mel, “Nuim ye! Ei nim kupa em ndam, na nim int on ei mel, nim ndi, na ui nana wamp!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas ndi nimba mel, “Un ka!” nitim. Nilinga, Pita ndi, nu kanu kʉⱡ wak ropa, ekit mba, nu ndi pol ila, kump kambilpa, Jisas murum ila purum. ");
INSERT INTO med_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mba kʉndrʉm mel, kʉpkʉ ei ndi, nu ndi, ei ropa pʉnin ndupa, mepa urum ila kandpa, mundmong itim. Ei kʉn, elim ni nu ila mana tilinga, ke nimba mel, “Nuim ye! Na etkʉn tin ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na kʉn, tʉngʉnda mint Jisas ndi, elim nga ki ni norung ndupa, Pita ambuⱡpa, oⱡa tʉpa nimba mel, “Nim nga mondpa pili ama mel wei kot kant ei ka! Nambuⱡ emel, numan ʉkpʉk tin?” nitim. ");
INSERT INTO med_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wote, wu ni raⱡ okʉⱡ, nu kanu nila rukʉr puⱡʉnggila, kona kʉpkʉ ni, kʉr nimba titim. ");
INSERT INTO med_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ei kʉn, kitip kʉni wu nu kanu ila morung ni kʉⱡ ndi, Jisas nga mbi paka rondʉk, nʉk mel, “Kupa, nim Got nga kangʉm ei!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wu ni kʉⱡ, num ei poⱡa rok, pok noi Genesaret kona ila purung. ");
INSERT INTO med_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wote, kona ila nga wamp nimbʉ ndi, Jisas kandʉk poⱡ nduk, kona nimbila rung mundʉk, kui peng em wamp mbʉ, mek wei nilingina, mek orung. ");
INSERT INTO med_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kona ila wamp nimbʉ ndi, kui peng itim wamp mbʉ, nim nga wal pʉki punt orunga, mint minda ndeing nʉk, Jisas kʉn mawa etʉng. Wote, minda ndurʉng wamp mbʉ, kui nimbʉ, tʉngʉnda mint pora nitim. ");
INSERT INTO med_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Wote, Jerusalem orunga wu Perisi kat kʉn, Moses nga mi ik mbo wu kat kʉn ok, Jisas waldʉk, nʉk mel, “Nim nga kitip kʉni wu kʉⱡ ndi, tʉn nga anda kouwʉmʉn kʉⱡ nga ik mbo endʉtʉng kʉⱡ, tʉk roi nduk, rʉng nuing etʉk, ki ⱡumʉi rui narʉk normin ei? Nambuⱡ emel etmin?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nʉtʉng ni, Jisas ndi, punt ropa nimba mel, “Enim wote, Got nga mi ik ei, pep rui narʉk, en enim nga anda kouwʉmʉn mbʉ nga mi ik pep rormin. Ei nambuⱡ emel etmin? ");
INSERT INTO med_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wote, Got ndi nimba mel, ‘Nim nga manʉm tipanʉm raⱡ tʉkʉn ou ndui!’ Wote, ‘Wamp nam ti ndi, elim nga mam kep, tipam kʉn kep, ik kit nʉm ndam, wamp ei rok kundeing,’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Wote enim ndi, ik ti mel ku mbo endʉk, wote wamp ti ndi, mam tipam raⱡ kundpa, mel ei ni enmbil nguⱡmba. Ei wote, tʉp Got ngʉnt ei ka nʉtʉm ndam, wote enim nga ik mbo endʉtmin ei ndi, elim nga mam tipam raⱡ tʉpa, rʉpndi napʉndrʉm. Ik i etʉk, mbo endʉtmin mbʉ ndi, Got nga mi ik ei, pep rui narʉk, en enim nga ik mbʉ mendpʉⱡ pep rormin. ");
INSERT INTO med_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enim ik kol nga puⱡ wu mbʉ ye! Enim nga puⱡ ei, unt painui wu Aisaiya ndi, ei mel nimba mot ndurum! ");
INSERT INTO med_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Wamp mbʉ ndi, na keta kʉng ila, mbi mundʉrmʉn. Wote numan ei, na kʉn roⱡ etpa tetʉm. ");
INSERT INTO med_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na nga mbi paka rondʉrmin uⱡ ei pendʉk kileing. Ei nambuⱡ emel, mʉi kona wamp nga mi ik mim etmin mbʉ, mbo rondʉk tʉk, Got nga randʉk etmin!” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wote, wamp minal morung nimbʉ, wi ropa kundpa nimba mel, “Ik nʉnt kʉⱡ pilik kungʉndʉi! ");
INSERT INTO med_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wamp nga keta ila, mana purum mel mbʉ ndi, wamp etpa ⱡar mundi namʉndrʉm. Wote, keta ila ekit orum mel mbʉ ndi, wamp etpa ⱡar mondrum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wote, elim nga kitip kʉni wu ni kʉⱡ ndi ok, Jisas kundʉk nʉk mel, “Nim nga ik nʉn ei ndi, Perisi wu kʉⱡ pilik kit pʉnmin ei, pʉn muna mon nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wote Jisas ndi, ik punt ropa nimba mel, “Na nga muⱡ kona Wuta ei ndi, kongun kona ila mel mat elim ndi, mbo rui nʉrʉrʉm mbʉ, elim ndi, nangga runggulk munding. ");
INSERT INTO med_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Enim numan ou nduk pili nʉpʉlʉi! Wu kʉⱡ, rʉp wu mong tʉtʉm kʉⱡ, mong ti wu ti ndi, ti ki ambuⱡpa mepa purum ndam, raⱡ kunda kut ila mana pinggil,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wote, Pita ei ndi, waldpa nimba mel, “Nim ik ek ron ei nga puⱡ ei, nʉkʉn mot ndui,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wote Jisas ndi, nimba mel, “Enim ik ek ei nga puⱡ ei kep, pilik kun iti natʉnmin ku ei? ");
INSERT INTO med_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wote kep, mel ti keta ila mana purum ei, mba kitim ila tepa, wote te raⱡpa omba ekit purum ei, enim pilik kun iti natʉnmin ku ei? ");
INSERT INTO med_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wote, mel mat keta ila, ekit orum ei mundmong ila pepa orum mbʉ ndi, wamp etpa ⱡar mondrum. ");
INSERT INTO med_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wote, wamp nga mundmong ila numan kit pepa ekit orum kʉⱡ ndi, elinga wamp rok kondʉk, kandʉk kom pendʉk, kindʉp nok, ik kol rok, wamp mat kʉn ik kit nʉk, uⱡ kit mbʉ etʉk etmin. ");
INSERT INTO med_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Got nga kuimp keta ila uⱡ kʉⱡ ndi, wamp etpa ⱡar mondrum. Wote, rʉng ti ki ⱡumʉi rui narkʉn nun uⱡ ei ndi, nim etpa kit mundi namʉndʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas murum kona ni, wak ropa mba kona peng Taiya kʉn Sairon raⱡ nga, kona ʉldʉ tetʉm mbila purum. ");
INSERT INTO med_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kona ila Keinen amp ti, ekit omba wi ropa nimba mel, “Nuim ye! Nim Depit nga kangʉm ei, na kont kun ka! Na nga mbuⱡam ambuⱡa ei, kur kit rukʉr orunga moⱡnga, ambuⱡa ei, etpa kit mondrum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ik nitim ni, Jisas ndi, ik ti punt rui nʉrʉrʉm. Wote, elim nga kitip kʉni wu ni kʉⱡ ndi, ik mana tek nʉk mel, “Kelpa pangga ni! Tʉn pep ropa, ka etpa onum ei mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ei kʉn, Jisas ndi, punt ropa nimba mel, “Isrel wamp mbʉ, kng sipsip mel tiki polk andʉrmʉn ei nga nimba, Got ndi, na tʉpa mundrum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","I nitim ik ni, amp ni pilpa omba, Jisas nga kʉmp puⱡ ila rumaⱡi pepa nimba mel, “Nuim ei! Na tʉkʉn rʉpʉndʉn ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wote Jisas ndi, ik punt ropa nimba mel, “Kangambuⱡa mbʉ nga rʉng mbʉ tʉpʉn owa mbʉ ngʉmʉn ndam, kapⱡa iti natʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Amp ni ndi, “Nuim ye! Ik ei piram nʉn ei wote, owa mbʉ ndi, en enim nga puⱡ wu mbʉ, rat pol ila molk, rʉng noⱡina nurpʉn, mana purum mbʉ, tʉk normin ku ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wote Jisas ndi, nimba mel, “Nim nga mondpa pili ei, ronduⱡ purum kant ei kʉn, nim nga numan ngʉn uⱡ ei mel etmba,” nitim. Ni kʉn mint, amp ei nga mbuⱡam nga kui ni wang nitim. ");
INSERT INTO med_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas murum kona ni, wak ropa omba, Num Galili ʉldʉ orung purum. Wote komnga tila oⱡa mba, muⱡ tʉpa mana murum. ");
INSERT INTO med_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ila wamp minal ruk ok, wamp on por mul na, mong ti wamp na, ik ni nʉni wamp na, elkʉna rumbʉⱡi wamp na, uⱡ elpa elpa itim wamp na nimbʉ mek ok, Jisas nga kʉmp puⱡ ila monduⱡnga, etpa titim. ");
INSERT INTO med_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wamp wei nimbʉ, min ngʉn minal mundrʉng. Ei nambuⱡ emel, ik ni nʉni wamp mbʉ, ik nʉtʉng. Ki rumbʉⱡi wamp omba kun purum. On por murum wamp mbʉ, nombuⱡa andrʉng. Mong ti wamp mbʉ, kona kandrung. Isrel wamp nga Nuim Got ei nga mbi paka rondrʉng. ");
INSERT INTO med_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Wote Jisas ndi, kitip kʉni wu ni kʉⱡ wi ropa ruk tʉpa nimba mel, “Na wamp mbʉ nga kont enim. Ei nambuⱡ emel, na kʉn moⱡina rumbʉⱡ raldika omba pum. Ei nga akup, nuing mel ti tek muⱡi nambʉrmʉn. Kump kun pʉi mang kona pʉi, nint ndam, nombuⱡa mam paka ila kʉmp kun ndi, kʉmp ambuⱡmba ei mon,” nitim. ");
INSERT INTO med_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wote, kitip kʉni wu ni kʉⱡ ndi waldʉk nʉk mel, “Ya kona kui wak ila, rʉng nant ila pem ei nga wamp rʉⱡaip mam ei, rʉng ambuⱡpʉn kapⱡa indimin ei nga nʉn?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wote Jisas ndi, “Enim bret namba iti tek mormin?” nimba wuldʉtʉm. Ni kʉn, wu kʉⱡ ndi, punt rok nʉk mel, “Bret 7 kat kʉn oma kʉralt tetʉm ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","I nilingina, Jisas ndi, wamp num ni pora, mana muⱡʉi, nimba. Bret 7 ni kʉⱡ kʉn, oma ni kuraⱡ kʉn tʉpa ambuⱡpa, Got kʉn angge nimba, puk ropa, elim nga kitip kʉni wu ni kʉⱡ ngurum. Wote wu ni kʉⱡ ndi, mok rok wamp nimbʉ ngorung. ");
INSERT INTO med_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wote, wamp morung nimbʉ, pʉkʉ nok pilʉng kunduⱡina, mana tʉtʉm mbʉ, aprʉk tʉk kowa wal 7 mel rok peka rondrʉng. ");
INSERT INTO med_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Rʉng norung ei, amp kangambuⱡa nimbʉ, kʉmp rui narʉk wu mint kʉmp rorung ei mba, 4,000 ei mel itim. ");
INSERT INTO med_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wote Jisas ndi, wamp nimbʉ peing nimba mundpa, elim ni nu kanu ila omba, rukrʉng mba, noi Makadan ni kona ila purum. ");
INSERT INTO med_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Perisi wu mat kʉn, Sarusi wu mat kʉn, Jisas murum ila rʉk ok, Jisas ei kupa, Got nga kangʉm nda nʉk, oⱡa tʉk muⱡ ila kʉning pilik muⱡ ila uⱡ rʉpndi ti itangga kʉnmin, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wote Jisas ndi, punt ropa nimba mel, “Kona ant ei mana purum ei kʉn, enim ndi, nʉk mel, ‘Muⱡ ei kunt enim ei, kona kai etmba,’ nʉtmin. ");
INSERT INTO med_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wote, ipri unt ei kʉn, ‘Mʉkʉlmʉ rumbʉⱡ morum ei kʉn kona romba,’ nitmin. Kona ant mba muna, kona romba ei oⱡa muⱡ ei kandʉk kʉn, tʉk mendʉtmin. Wote enim ndi, akup penim uⱡ mbʉ kandʉk, tʉk mindi namindʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Enim uⱡ kit mbʉ etʉk, Got pep rui nʉri wamp mbʉ ye! Na uⱡ rʉpndi ti itamba kʉnmin ninmin ei? Ei mon! Got ndi, Jona kʉn uⱡ rʉpndi itim ei mel, na uⱡ rʉpndi ti, wote itamba kʉning,” nitim. Ei mel nimba pendpa, wu ni kʉⱡ wak ropa kelpa purum. ");
INSERT INTO med_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, num Galili poⱡa rok noi orunga purung. Wote, rʉng nuing ei nga bret mat, mek pi naprʉng. ");
INSERT INTO med_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Wote Jisas ndi, wu kʉⱡ kundpa nimba mel, “Enim Perisi na, Sarusi wu kʉⱡ nga Yis ei nga, tʉk mendʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","En enim ol tek nʉk int yant etʉk nʉk mel, “I nʉnʉm, ei nambuⱡ emel, tʉn bret ti, mep ui nawʉnmʉn ei nga ninim nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wu kʉⱡ nʉtʉng ik ni, Jisas tʉpa mendpa waldpa nimba mel, “Enim bret ti, mek ui nawʉng ei nga, nambuⱡ emel, ol wal tenmin? Enim Got kʉn mondʉk pʉtmʉn ei, ronduⱡ pi naprʉm kant ei ka! ");
INSERT INTO med_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Enim tʉk mindi namindʉnmʉn ye? Na bret 5 kʉⱡ puk rop nguⱡmba wu 5000 rʉng endʉtʉng. Wote, rʉng mana titim ei, kowa wal namba iti rok peka rondrʉng ye? ");
INSERT INTO med_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Muna bret 7 kʉⱡ ila, wu 4000 rʉng endʉtʉng. Wote, rʉng norung mana titim ei, kowa wal namba iti rok peka rondrʉng ye? ");
INSERT INTO med_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na bret mendpʉⱡ ei nga ik ti, ni nanʉnt. Ei nambuⱡ emel, pilik kun iti natʉnmʉn? Enim Perisi na, Sarusi wu kʉⱡ nga yis ei, tʉk mendʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I nitim ila, kitip kʉni wu ni kʉⱡ, yis bret ila mundʉrmʉn ei nga ni nʉndʉtʉm. Ya Perisi na, Sarusi wu kʉⱡ nga, ik mong wamp mbo endʉtmin kʉⱡ nga, tʉk mendʉk muⱡeing nimba nitim ik ei, akil tek pilik kun etʉng. ");
INSERT INTO med_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas kʉn, elim nga kitip kʉni wu kʉⱡ kʉn puk, Sesariya nga kona peng Pilipai nga tetʉm kona tila puk molk, elim nga kitip kʉni wu kʉⱡ, waldpa nimba mel, “Wamp mbʉ ndi, Muⱡʉl Wu Kupa ei, kundʉk wu nam ninmin?” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wu nimbʉ ndi, punt rok nʉk mel, “Wamp mat ndi, wamp nu tindi wu Jon ninmin mat ndi, wu Ilaija ninmin mat ndi, wu Jerimaiya muna, painui wu ti ninmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Wote enim ndi, na wu nam ninmin?” nimba wu ni kʉⱡ wuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Wote, Saimon Pita ndi, ik punt ropa nimba mel, “Nim Wu Kraist, nim kont moⱡpa, mint pi Wu Got ei nga Kangʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ni kʉn, Jisas ndi, ik punt ropa nimba mel, “Wu Jon kangʉm Saimon ye! Got ndi, nim memp pindilinga, nim ik kupa nʉn. Ya mʉi kona ila wamp ti nga ronduⱡ tila tʉkʉn, ni nanʉn mon. Ik nʉn ei, na nga muⱡ kona Wu Tipam ei ndi, nim nimba nguⱡnga nʉn. ");
INSERT INTO med_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ei kʉn, Pita ei, nim ik kupa ei kundʉp nʉnt, nim ku mel muⱡana, ku pol ila na nga manga wingti ei, rʉⱡimp wamp mbʉ, tʉp oⱡa ndup mundimp. Wote, wamp kul uⱡ ei ndi, manga wingti ei ropa mana ndui nandʉmba. ");
INSERT INTO med_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Muⱡ ila tʉpa mumuk rui kona ei nga kumba ki kʉⱡ, nim nguimp. Nim ndi, ya mʉi kona ila mi run uⱡ mbʉ, oⱡa muⱡ kona ila mi ku romba. Ya mʉi kona ila, kapⱡa nin uⱡ mbʉ, oⱡa muⱡ ila kapⱡa ku nimba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","I nimba, kitip kʉni wu ni kʉⱡ kundpa, wamp ti kandʉk, elim Kraist ei, ni nʉnʉi nitim. ");
INSERT INTO med_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ui ni kʉn, puⱡ mondpa, elim nga kitip kʉni wu ni kʉⱡ kʉn, nimba mot ndupa, na wi Jerusalem pamba rʉp wu na, wu peng mumuk na, mi ik mbo wu na mbʉ nga ki pol ila mindil mam nomp, wote rok kundangina, rumbʉⱡ raldika omba pangga! Wote Got ndi, ⱡoporpa kont mundʉmba. ");
INSERT INTO med_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wote Pita ndi, ik ni pilpa, Jisas ʉldʉ tila ekit tʉpa, ik ngumba nimba mel, “Nuim ye! Uⱡ mbʉ nim kʉn omba ei, Got ndi, pendpa kilangga. Nin uⱡ mbʉ, nim kʉn omba pi nʉpangga!” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas tʉpa ropʉl ropa, Pita ni tʉpa pendpa ik ngumba, “Seitan ye! Na mor ila kelkʉn pa! Nambuⱡ emel, na nga mbi nombuⱡa mam ei imp mon? Nim nga pilkʉn nʉn ik kʉⱡ, Got kʉn ui nawʉnʉm mon. Nim wamp nga numan ila pilkʉn nʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jisas ndi, ik ei nimba kʉn, wote elim nga kitip kʉni wu kʉⱡ kundpa nimba mel, “Wamp ti ndi, na kʉn uimp nimba pilim ndam, elim nga mul uⱡ ei wak ropa, elim nga nde peta ei koma ropa, na punt mel kandpa, pep ropa akil tepa wangga! ");
INSERT INTO med_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wamp ti ndi, elim nga kont mul uⱡ ei, ambuⱡpa gi ndum ndam, uⱡ nga kʉnt nga kont mul uⱡ ei ti natʉmba. Wote, wamp ti ndi, elim nga mul uⱡ ei na nga nimba wak rom ndam, uⱡ nga kʉnt nga kont mul uⱡ ei tʉmba. ");
INSERT INTO med_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wamp ti ndi, ya mʉi kona ila mel mbʉ nga etpa nomba, elim nga min ei nimba etpa yant tʉmba. Ei kapⱡa iti natʉmba. Ei kʉn, namba mel mat ndi, int ndupa ngumba, elim nga min ei etpa tʉmba? ");
INSERT INTO med_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Muⱡʉl Wu Kupa ei, elim nga anggelo mbʉ kʉn, tipam nga rʉpndi pol ila omba, tʉn wamp mbʉ uⱡ etmin mbʉ mel, punt ropa elpa elpa ngumba. ");
INSERT INTO med_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Enim ik kupa ei, kundʉp nʉnt, ya wamp mormin mbʉ nga mat, kuⱡi nʉⱡangina, Wu Nuim Mumuk ei, elim nga Tipam nga rʉpndi pol ila Nuim moⱡpa, wangga kʉning,” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Rumbʉⱡ 6 omba puⱡnga, Jisas ndi, Pita, kʉn wu ʉngʉn ʉngʉn Jeims kʉn, Jon ni kʉⱡ tʉpa mepa, komnga mong oⱡa pi tila, monduⱡnga kou morung. ");
INSERT INTO med_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Molk kandrung ni, Jisas ni etpa mon munduⱡnga, elim nga kuimp keta ni, kona ant mel rʉⱡang purum. Wote, elim nga muⱡ rʉrʉm nimbʉ omba, kurʉmʉⱡa raⱡpa rʉⱡang ndi ʉlt nitim. ");
INSERT INTO med_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wote, kitip kʉni wu raldika ni kʉⱡ ndi, kandrung mel, Moses kʉn Ilaija raⱡ okʉⱡ, Jisas kʉn ik ni kʉⱡ morunggil. ");
INSERT INTO med_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ei kʉn, Pita ndi, Jisas kundpa nimba mel, “Nuim ye! Tʉn ya ila mbo ngʉn tʉnʉm kant ei kʉn, nim ndi, kapⱡa nʉkʉn pin ndam, na ndi, ya ila manga kouwʉ raldika ramp, ti nim mel, ti Moses mel, ti Ilaija mel,” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","I nimba moⱡnga, kopa rʉⱡang pi kat omba, morung kona ni, panda ropa pelinga, kopa rʉk ting ila ik ti, ekit omba nimba mel, “Ya ei, na nga numan ngur kang ei. Nanim kandʉp numan ngʉmp mor. Elim ik nim ei, kum tek pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kitip kʉni wu ni kʉⱡ ik ei, pilik min ngʉn mundʉk rumaⱡi petʉng. ");
INSERT INTO med_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wote, Jisas ndi omba, elim nga ki ei ndi, wu ni kʉⱡ minda ndupa, “Enim mundmong iti natʉk, oⱡa muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tʉk oⱡa nduk kandrung ei, wamp wei ti, kʉni nakʉndrʉng, Jisas mendpʉⱡ murum. ");
INSERT INTO med_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Komnga ila mana ok mel, Jisas ndi, wu ni kʉⱡ kʉn, mi tepa nimba mel, “Enim uⱡ kanmin ni mel wamp ti kʉn timan rok ni nʉnʉi! Na Muⱡʉl Muⱡʉl Wu Kupa ei kuⱡamba, wote ⱡoporpa tʉpa oⱡa mondum ei kʉn, kandʉk neing!” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wote, kitip kʉni wu ni kʉⱡ ndi, waldʉk nʉk mel, “Mi ik mbo wu mbʉ ndi, Ilaija kuimp tepa omba nʉtmʉn ndi, namba elinga nʉtmʉn?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nilingina ik ni, punt ropa nimba mel, “Ik mong ti Buk Wingti ila petʉm ei ndi, Ilaija kuimp tepa omba, wamp mbʉ tʉpa kun etmba. ");
INSERT INTO med_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wote na ndi, enim ik ti kundʉp namp ei, Ilaija ni kor urum ni, wote wamp ndi, kandʉk poⱡ ndui nandʉk, rok pint panda etʉng. I etʉng ei mel ku, na Muⱡʉl Wu Kupa ei, wamp mbʉ nga ki pol ila mindil nuimp!” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","I nitim ei kʉn, kitip kʉni wu ni kʉⱡ ndi, ik ninim ei, wamp nu tindi wu Jon nga ninim pʉnt nʉk tʉk mendʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Wote yant ok, wamp num morung nila orung ei kun, wu ti omba Jisas kʉn mura kopʉtʉng ropa rumaⱡi pepa nimba mel, “Nuim ye! Na nga kang ei kaimp kun ka! Kang ei, ropa wʉlʉ munduⱡnga, purpur ropa ndip ila kep, nu num na mbila kep, ropa rʉk ndurum. ");
INSERT INTO med_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kang ei mep, nim nga kitip kʉni wu kʉⱡ kʉn oⱡʉmba, etʉk ting ei pilik rundrung,” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas ndi, punt ropa nimba mel, “Enim na mondʉk pili napilik, numan mbo pi nʉpi wamp mbʉ ye! Na enim kʉn moⱡʉp mint mbi ei? Enim wamp mbʉ nga na mindil nondʉp mint mbi ei? I kang ei, na mor ila mek wʉiya!” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wote kang ni, mek oⱡina, Jisas ndi, tʉpa pendpa kur kit ni, ik nguⱡnga, kur ni kang ei, wak ropa puⱡnga, ni kʉn ku kui ni wang nitim. ");
INSERT INTO med_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ei kʉn, kitip kʉni wu ni kʉⱡ ndi ok, Jisas mo rok waldʉk nʉk mel, “Tʉn kur kit ei, mak rʉp tʉp mundmin nʉmp etʉp koi nimʉn ei, namba ei mel em nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ik ni, punt ropa nimba mel, “Ei nambuⱡ emel, enim nga Got kʉn mondpa pili ei, ronduⱡ pi napʉrʉm. Ik kupa ei enim kundʉp nʉnt, enim Got kʉn mondʉk pilik muⱡing uⱡ ei, nde kaipa mong ei mel kapⱡa pem ndam, int komnga ei kundʉk, ‘Nim akʉkʉn pukʉn noi ila mul nana mba moⱡmba.’ Wote nim ndi i etkʉn uⱡ mat kapⱡa itʉn ku. ");
INSERT INTO med_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kur kit mbʉ, wei ok pi nʉping, enim atinga rok, rʉng mowi pek eng ei ndi, kapⱡa makrʉk munding,” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Wote, kitip kʉni wu ni kʉⱡ ok, Galili kona ila tʉk tenda etʉng. Ni kʉn, Jisas ndi, wu kʉⱡ kundpa nimba mel, “Muⱡʉl Wu Kupa ei, imp molk, tʉk wu mat ngangina, wu mbʉ ndi, rok kunding. Wote, ant raldika omba pangga, ⱡoporpa tʉpa oⱡa mondʉmba,” nitim. Wote, kitip kʉni wu ni kʉⱡ ik ei, pilik munt mindil tʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wi Kaperniyum yant oⱡina, manga wingti ku takis tʉtmʉn wu kʉⱡ ndi ok, Pita waldʉk nʉk mel, “Nim nga ik mbo wu ei, manga wingti ku takis ngorum muna mon?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ndi, “Ngorum ei ka!” Nimba pendpa, manga nila murʉk puⱡnga, Jisas ndi, kuimp tepa nimba mel, “Saimon ye! Nim etʉk pʉn mel nant? Ya mʉi kona wu peng mumuk mbʉ, ku takis ei nam kʉn tʉtmʉn? Mʉi puⱡ wamp mbʉ kʉn tʉtmʉn muna, wamp elpa mbʉ kʉn tʉtmʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ndi, nimba mel, “Wamp elpa mbʉ kʉn tʉtmʉn,” nitim. Jisas ndi, punt ropa nimba mel, “I pʉnt ei kʉn, mʉi puⱡ wamp mbʉ, ku takis ngui ngʉngmin. ");
INSERT INTO med_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wote tʉn ndi, ku takis ngui ngʉngmin ndam, tʉn kʉn, pilik kit piling ei mon. Wote nim pukʉn, met num ʉldʉ ila oma uk mundana, oma kuimp tepa omba pem oma ei nga keta ei. Ambulkʉn aka etkʉn kʉni, ku moni ti, pemba ku ei ndi, mek pukʉn tilinga, ku takis ngui,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ei kʉn, kitip kʉni wu ni kʉⱡ ndi ok, Jisas waldʉk nʉk mel, “Got nga wamp tʉpa mumuk rui uⱡ ila wamp nam ti, nuim moⱡmba?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Wote Jisas ndi, kangambuⱡa ti, wi ropa tʉpa rʉk ting ila mondpa nimba mel, “Enim ik kupa ei, kundʉp nʉnt, enim nga numan ei, ropʉl rok, kangambuⱡa mel rʉⱡi naⱡʉng ndam, enim Got nga wamp tʉpa mumuk rui uⱡ ila rukʉr puk, muⱡing mel kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wamp ti ndi, ya kangambuⱡa kel ei mel raⱡpa, elim nga orunga mepa mana omba moⱡum ndam, Got nga wamp tʉpa mumuk rui uⱡ ila nuim moⱡmba. ");
INSERT INTO med_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Wamp nam ti ndi, na nga mbi ila wamp ti, ya kangambuⱡa ei mel, rawe etpa rukʉr tʉm ndam, ei na kʉn etmba. ");
INSERT INTO med_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Wote, wamp ti ndi, na mondʉk pilip moⱡum ndam, wamp kel mbʉ nga ti ndi, kunt kan itangga, uⱡ kit em ndam, kunt kan em wamp ei nga nuim kan ila, ku ou ti tʉk romʉndʉk, mek puk, nu moimbʉⱡ tila rok mana ndangina, nu wanggʉⱡ nga ndam pʉp. ");
INSERT INTO med_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Enim ya mʉi kona ila, kunt kan etmin wamp mat ndi itangina, mondpa pili wamp mat uⱡ kit eng ndam, kunt kan wamp mbʉ nga kont enim! Kunt kan uⱡ ei, pepa mint mba. Ei wote, wamp kʉn kunt kan puⱡ pendpa etʉm wamp ei nga kont enim. ");
INSERT INTO med_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nim nga kʉmp muna, ki ei ndi itangga, nim uⱡ kit in ndam, uⱡ kit em mel ei, koⱡmung etʉk mundʉk kili! Nim ki tenda kep, kʉmp tenda muⱡangga, uⱡ nga kʉnt nga kont uⱡ tin ei kai. Nim nga kʉmp ki raⱡ pikʉ muⱡangga, nim rok, ndip kona ila munding ei kit. ");
INSERT INTO med_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nim nga mong tenda ei ndi itangga, nim uⱡ kit in ndam, nim nga mong ei, akʉk ekit tʉkʉn, rok mundʉk kili! Nim nga mong tenda ei tek molkʉn, uⱡ nga kʉnt nga kona tin ei kai. Nim nga mong raⱡ pikʉ ʉnggʉlangga, nim rok ndip kona ila rok munding, ei kit,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Enim ya wamp kel mbʉ nga ti, tʉk pei mundi nʉmʉndʉi! Enim kundʉp namp, ya wamp kel mbʉ rʉp etmin anggelo mbʉ ndi, na nga Wuta Got nga kuimp keta ila molk kandʉk mormin,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na Muⱡʉl Muⱡʉl Wu Kupa ei ndi, wamp tiki polk mormin mbʉ, etʉp timp nʉmp mana ur. ");
INSERT INTO med_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Enim etʉk pʉnmin mel nant? Wu ti kng sipsip 100 tepa muⱡangga, tenda ti mba tiki poⱡum ndam, kng sipsip 99 kʉⱡ muⱡeing nimba, mondpa kelpa, tenda tiki poⱡum ei mba, kuri nakʉrmba ye? ");
INSERT INTO med_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Enim ik kupa ei, kundʉp nʉnt, kng sipsip tenda mba, tiki poⱡum kandpa tʉm ni nga, numan mam ti etmba ei, kng sipsip 99 tiki puⱡi napʉⱡʉng kʉⱡ, numan etmba ei mel mon. ");
INSERT INTO med_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ei mel ku, nim nga muⱡ ila Wu Tipanʉm ei ndi, ya wamp kel mbʉ nga ti, puk tiki puⱡi nʉpʉⱡeing nimba pʉtʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nim nga wu ʉngʉnʉl ei ndi, nim kʉn uⱡ ⱡawa ti em ndam, pukʉⱡ tila ndenga ni kʉⱡ molkʉⱡ, ⱡawa em ei mel nʉkʉn mot ndui. Nʉkʉn mot ndana ⱡawa em ei mel tʉm ndam, ang ndi, etʉp tʉnt nʉkʉn pili. ");
INSERT INTO med_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Muna ⱡawa em uⱡ ei, pilpa tʉpa pei mondum ndam, pukʉn wu tenda muna, raⱡ ei mel puk molk, nʉk tʉk kun itʉi! Buk Wingti ila nimba kʉn, ⱡawa em wamp ei, nʉk tʉk kun munding uⱡ ei, wamp raⱡ muna, raldika ei mel rʉk ila molk, mint nʉk tʉk kun munding. ");
INSERT INTO med_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Muna wu kʉⱡ nga ik ei, kum tʉi natʉm ndam, ⱡawa em ei mek, Got nga rapa tenda wamp mam ei kʉn oⱡa pʉi. Muna rʉp wamp mam ei nga ik ei, kum tʉi natʉpa, tʉpa mondum ndam, wu ei tʉk mbo wu mel kep, ku muna takis tʉtmʉn wu na mbʉ mel rundʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Enim ik kupa ei kundʉp nʉnt, enim ya mʉi kona ila mi rong uⱡ mbʉ, Got ndi, oⱡa muⱡ ila mi ku romba. Muna ya mʉi kona ila mi go nduk teng ndam, oⱡa muⱡ ila mi go ku ndumba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Wote, na ik kupa ti, aldpa kundʉp namp, ya mʉi kona ila wamp ralt ndi, ik nʉk tenda mʉn kʉⱡ. Na nga muⱡ ila Wuta ei kʉn, mawa etkʉⱡ nʉnggil mel ei ngumba. ");
INSERT INTO med_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ei nambuⱡ emel, wamp raⱡ kep, raldika kep, na nga mbi tʉk angʉndʉk, mʉk rok mormin rʉk ting ila nanim moⱡʉp ku et,” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wote, Pita ei ndi, oⱡa omba Jisas waldpa nimba mel, “Nuim ei, na nga ʉngʉn wu ei ndi, rʉk rʉk na kʉn ⱡawa etpa mint pum ndam, nit mbʉ pendʉp kelip pamba mba, namba iti itangga? Nit pendʉp kilamba mba, 7 em kʉn kapⱡa etmba ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas ndi, punt ropa nimba mel, “Pendʉk kilana mba 7 mint mon, pendkʉn kelkʉn mint pana mba 70 pendpa 7 pora itangga. ");
INSERT INTO med_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ik ei mel kundʉp nʉnt. Ei nambuⱡ emel, Got nga wamp tʉpa mumuk rui uⱡ ei, Wu Nuim ti ndi, elim nga kongun wu mbʉ, kʉng mel punt mundrum mbʉ, nimba tʉpa kun mundʉmba ei mel. ");
INSERT INTO med_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wote, mel punt mundrum wu mbʉ ndi, punt rok ngeing nimba pitim ni kʉn, elim nga kongun wu mbʉ ndi, ku moni punt 10 miliyon ei mel punt mundrum wu ti, elim kʉn mek orung. ");
INSERT INTO med_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mel punt pʉtʉm wu ni, ku punt romba ei pilpa rundʉⱡnga, wu king ni ndi, ‘Wu ei kep, amp kangambuⱡa na, kng mel na mbʉ tʉk wu mat kʉn rarʉp rangina, na nga ku mbʉ mel puⱡ ila timp!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","I nilinga, kongun wu ni, wu nuim mumuk ei nga kʉmp puⱡ ila, mura ropa mondpa, ‘Nuim ye! Na kont kulkʉn ui mat, roⱡ etkʉn ngana moⱡʉp nim nga ku punt, na kʉn petʉm mbʉ, andʉp kandʉp tʉp punt rop ngeimp!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wu peng ei ndi, kongun wu ni nga kont kuⱡpa, ku punt nimbʉ, punt rok ngʉngi. ");
INSERT INTO med_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wote, kongun wu tenda ni ndi, ku pena omba kʉndrʉm mel, elim kʉn kongun rʉⱡaip tenda ila wu ti, elim ndi, ku kum raⱡ ngurum wu ni urum. Kandpa kʉn, wu ni nga nuim kan ni, ambuⱡpa kint ngumba nimba mel, ‘Na nga ku moni ei tʉkʉr kʉn punt rokʉn ngui!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Wote, kongun rʉⱡaip tenda wu ni ndi, kʉmp puⱡ ila, mura ropa mondpa, ‘Nim ndi, na kont kulkʉn wak rana, nim nga ku punt na kʉn petʉm mbʉ, pikʉ punt rop ngeimp,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wote ik ni, pili nʉpilimp nimba, ku kʉⱡ punt rokʉn ngʉn kʉn mint, wak rop mundimp nimba, tʉpa kan ngurum. ");
INSERT INTO med_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“I itim uⱡ ni, kongun wu mat ndi, kandʉk munt mindil tʉk, pok wu nuim ni kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","Wu Nuim ei ndi, kongun wu ei wi ropa tʉpa, ‘Nim kongun wu kit! Na kʉn kont it ik rʉngʉn ni pilip, na nga ku punt nin ila nim kʉn petʉm mbʉ, wak runt ni ka! Na ndi, nim kont kuⱡʉp, mel punt mbʉ, wak runt ni mel ku, nim nga kongun tenda wu ei nga ku punt kʉⱡ wak ku roⱡina ka!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I nimba, wu nuim ni, popʉⱡ kuⱡpa, kongun wu ni tʉpa, kan manga ila wu kʉⱡ ngumba, etʉk elik rundangina, na ku kʉⱡ punt rangga mint wak rʉi!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ei mel ku, enim wu ʉngʉn ti kʉn, popʉⱡ em ei, numan wang nduk, wak rui narʉng ndam, na nga muⱡ ila Wuta ei ndi, i ku etpa, enim nga uⱡ kit mbʉ wak rui narʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas ndi, ik mbʉ pora nimba mel, Galili kona ila wak ropa, nu Joran noi orunga, Juriya kona tetʉm mbila purum. ");
INSERT INTO med_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wamp minal ndi, Jisas kandʉk purum ila, akil tek orung nimba, mat kui peng itim wamp mbʉ, etpa weing titim. ");
INSERT INTO med_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ei kʉn, Perisi wu mat ndi, Jisas oⱡa tʉk kʉning pilik ik ei mel, waldʉtʉng nʉk mel, “Wu ti nga amp ei, uⱡ ei muna ei, enim nimba ndenggʉⱡa ndupa, mundpa kilmba ei, kapⱡa etmba muna mon?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wote Jisas ndi, ik int ndupa nimba mel, “Enim Buk Wingti ila wamp weng ndupa itim ei ndi, wu amp nimba mim itim mon ei, kʉmp rok kandʉrmin muna mon? ");
INSERT INTO med_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wote Got ndi, nimba mel, ‘Wu amp raⱡ nʉmp mim ent uⱡ ei ndi, wu ei, elim nga mam tipam raⱡ wak ropa mba, amp ei kʉn kup itangga, wamp tenda ralk muⱡʉnggil.’ ");
INSERT INTO med_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ei kʉn, wamp raⱡ, wote raⱡ mel mon. Wote, wamp tenda ralk muⱡʉnggil. Got ndi, tʉpa tenda itim uⱡ ei, mana mʉi kona ila wamp ti ndi, nimba ndenggʉⱡa ndumba mel kapⱡa mon,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wote, Perisi wu ni kʉⱡ ndi, waldʉk nʉk mel, “Wote nambuⱡ emel, Moses ndi, mi ik ti ngumba kʉn, wu ei ndi, elim nga amp ei, amp ndenggʉⱡa ndui mon ti ngumba wak rangga?” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas ndi, nimba mel, “Moses ndi, enim nga ambʉnʉmʉl mbʉ, ndenggʉⱡa ndʉi nitim ei, nambuⱡ emel, wu amp raⱡ mim itim ei nga puⱡ ei, enim ndi, pilik kʉn, tʉk roi ndurum. Uⱡ ei mel, wu amp raⱡ mim itim ei kʉn, uⱡ ei pi nʉpʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Enim pilʉiya! Wu ti ndi, elim nga ambʉm ei wapra rui uⱡ ti iti nʉtangga, mʉn kan amp ei, mundpa kelpa, amp kont nga tʉm ndam, wu ei wapra rui uⱡ ⱡawa ei etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wote, kitip kʉni wu ni kʉⱡ ndi, Jisas kundʉk nʉk mel, “Nim ndi nʉkʉn kʉn, wu amp wapra rui uⱡ ei ndi mendpʉⱡ, wu amp ndenggʉⱡa nitmin nin ndam, wu amp ti natʉk, wangʉn pelingina ndam, kapⱡa elinga,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ni kʉn, Jisas ndi, ik punt ropa nimba mel, “Wu amp wangʉn petmin uⱡ ei, wamp pora nga uⱡ ti mon. Got elim ndi, pʉtʉm wamp kʉⱡ mendpʉⱡ, wangʉn petmin. ");
INSERT INTO med_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wu amp ti natʉtmʉn uⱡ ei nga puⱡ minal ei, mat mamʉl nga oⱡ rukʉr ila pek ormʉn ei kʉn, wu puk amp tʉk iting mel mon. Wote, wamp mat ndi elingina, pot petmin mat muⱡ ila tʉpa, mumuk rui uⱡ ei nga nʉndʉk, wangʉn pek etmin. Ei kʉn, ik ei pilpa tʉmba wamp ti, elim pilpa tangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wote, wamp mat ndi, kangambuⱡa mbʉ, Jisas ndi, peng mbila ki oⱡa ndupa ambuⱡpa, memp pindangga nʉk mek orung. Ni kʉn, kitip kʉni wu nimbʉ ndi, uⱡ ei kandʉk, wamp mbʉ ik ngorung. ");
INSERT INTO med_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ni kʉn, Jisas ndi, nimba mel, “Kangambuⱡa mbʉ, na kʉn weing, enim ndi, mon ni nʉnʉi! Muⱡ ila tʉpa mumuk rui uⱡ ei, wamp mat kangambuⱡa kel mbʉ mel, ralk moⱡʉng mbʉ nga” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","I nimba kʉn, kangambuⱡa nimbʉ nga peng ila ambuⱡpa, memp pendpa kʉn, wote kona tila purum. ");
INSERT INTO med_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ui ti kʉn, wu ti rʉk omba Jisas waldpa nimba mel, “Ik mbo wu ye! Na uⱡ kai namba uⱡ mbʉ etʉp, uⱡ nga kʉnt nga kont mul uⱡ ei timp?” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas ndi, punt ropa nimba mel, “Uⱡ kai ei, nant nʉkʉn na kʉn waldʉn ei, ⱡawa etkʉn nin ei ka! Got mint wu kai tenda ei morum. Uⱡ nga kʉnt nga kont mul uⱡ ei, timp nʉkʉn pin ndam, Got nga mi ik kʉⱡ pep rui,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Ni kʉn, wu ni ndi, nimba mel, “Ei mi ik nant mbʉ nga nʉn?” nimba wuldʉtʉm. Wote Jisas ndi, punt ropa nimba mel, “Wamp ti rok kundi nʉkʉndi, wu amp wapra rui uⱡ mbʉ iti nʉti, kindʉp nui nʉni! Nim wamp ti kʉn, ik kol rok ni nʉni, manʉm tipanʉm raⱡ tʉkʉn ou ndui, nim ninim numan ngorun ei mel ku, nim nga manga keta kup wamp mbʉ i ku etkʉn, numan ngui!” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wote, kang wu ni ndi, punt ropa nimba mel, “Ya nʉn mi ik mbʉ, na pep rop pilip ket ent. Na nambuⱡ ei nga kapⱡa iti natʉnʉm?” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas ndi, wu ni kundpa nimba mel, “Nim wu kun pi kai ti muⱡimp nʉkʉn, pin ndam, int pukʉn nim nga kng mel tekʉn morʉn mbʉ, rarʉp rokʉn, ku moni tʉkʉn ku mbʉ ndi, mek pukʉn, wamp kurpa mbʉ ngui! Wote yant okʉn, na nga kitip kʉni wamp ralkʉn mʉn ndam, nim muⱡ kona ila mel pemba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kang wu ni ndi, Jisas ik nitim ni pilinga, numan ei mbun elinga, kelpa purum. Ei nambuⱡ emel, elim kng mel ou ndupa tepa murum. ");
INSERT INTO med_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Enim ik kupa ei, kundʉp nʉnt, kng mel mbʉ pei wamp ti ndi, muⱡ ila tʉpa mumuk rui uⱡ ila rukrʉng mba, ei nga mbun ndi koⱡmba. ");
INSERT INTO med_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ik ei nga, wote aldpa nʉnt, kng kamel ou ei ndi, gal ruri nombuⱡa ila rukrʉng mba ei nga mbun etpa tetʉm. Wote, wamp kng mel pi ti, Got nga tʉpa mumuk rui uⱡ ila rukrʉng mba ei nga, ama minal mbun etpa tetʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kitip kʉni wu ni kʉⱡ ik ei pilik, min ngʉn mundʉk, nʉk mel, “I ndam, nam uⱡ nga kʉnt nga moⱡpa mint mba?” waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wu ni kʉⱡ kʉn, kundpa nimba mel, “Wamp ti ndi, elim peng kont ti natʉmba. Ei wote, Got ndi, nambuⱡ mbʉ, kapⱡa etmba mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wote Pita ndi, ik akpa nimba mel, “Kana! Tʉn nga mel mbʉ, tʉp mbuldung ndupʉn, nim pep rumʉn ei nga, tʉn Got ndi, namba mel ei ngumba?” nitim. ");
INSERT INTO med_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wote Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Enim pilik nduimp rok muⱡʉi! Na Muⱡʉl Wu Kupa ei, mon pangga, rʉpndi pol ila munt kʉn, enim na nga kitip kʉni wu 12 kʉⱡ, i ku etʉk, rʉpndi pol ila molk, Isrel nga wu rʉⱡaip 12 kʉⱡ kʉmp ting. ");
INSERT INTO med_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wote, wamp nam ti, na pep ruimp nimba kʉn, elim nga mam tipamʉl, kimʉnʉl, ʉngʉnʉl, kangambuⱡa, na pana kongun kona mbʉ, wak rom ndam, mel minal pendpa pʉⱡ ila tʉpa pangga 100 etmba. Wote, uⱡ nga kʉnt nga kont mul ei, Got ndi ngumba. ");
INSERT INTO med_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wote wamp mat akup kuimbal mormin mbʉ ok, akil ting. Wote, akup ila wamp mat, akil tenmin mbʉ ok, kuimbal ping. ");
INSERT INTO med_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Muⱡ ila tʉpa mumuk rui uⱡ ei, ya uⱡ ei mel. Wu Nuim ti, elim nga wain pana ei, kongun indeing nimba, ipri unt ekit mba, wu mat kurpa purum. ");
INSERT INTO med_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mba kandpa titim wu mbʉ, ku moni ruri tenda ei mel, ant tenda ila nguimp nitim ila, kapⱡa nilingina, tʉpa wain pana ila kongun itʉi nimba tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Wote ant omba, 9 kilok ei oⱡa elinga kʉn, wu nuim mba aldpa mba mel rop kona ila wu kat kai kandʉk morung ila kandpa nimba mel, ‘Enim puk na nga wain pana ila kongun indeing pʉi! Enim ku moni mat, kongun eng ei mel kapⱡa kapⱡa etʉp nguimp,’ nitim. Ni kʉn, wain pana ila puk kongun endʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wote, rʉnggilmʉ 12 kilok elinga kʉn, wu mat i ku etpa kandpa tʉpa, kongun ila tʉpa mundrum. Wote ant ei mana mba, 3 kilok elinga, wu mat ku kandpa tʉpa, kongun ila tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wote akil tepa, ant ei mana mba, 5 kilok elinga kʉn, wu kai kandʉk morung kat kʉⱡ, kundpa nimba mel, ‘Enim nambuⱡ emel, kai kandʉk moⱡina, kona rumbʉⱡ romba enim?’ nimba wuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wote, wu ni kʉⱡ ndi, nʉk mel, ‘Tʉn wamp ti ndi, kongun iteing wʉi ni nanim,’ nʉtʉng, ‘I ndam, enim puk, na nga wain pana ila kongun iteing pʉi ku!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kona rumbʉⱡ romba itim ni kʉn, wain pana puⱡ wu ni ndi, kongun rʉp wu ni, kundpa nimba mel, ‘Kongun wu mbʉ, wi rokʉn moni ngui! Akil tek ok, kongun eng wu mbʉ, moni kuimp tekʉn ngukʉn, wote kongun kuimp tek ok eng mbʉ, moni akil tekʉn ngui!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ni kʉn, mel ant ei mana puⱡnga, kongun etʉng wu nimbʉ, ku moni ruri tenda nʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wote, kongun ipri unt ok etʉng nimbʉ, en enim moni minal mel timin nda nʉk pilik morung. Ni wote, ku moni ruri tenda nimba ngurum. ");
INSERT INTO med_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Ku moni ni kʉⱡ tʉk, wain pana puⱡ wu ni kʉn, numan rukʉr ik mura etʉk nʉk mel, ‘Wu akil tek kongun rung tilinga ong kʉⱡ, ant mong tenda mendpʉⱡ kongun eng. Wote, tʉn ipri unt ombun etʉp moⱡmina, wote ant ndi, tʉn nom uⱡ ei, kandkʉn kelkʉn, wote ku moni ruri tenda nʉkʉn ei, ngun ei ka?’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pana puⱡ wu ni ndi, wu ti ni, kundpa nimba mel, “Ang ye! Na ndi, nim tʉp wʉlʉ mundʉp uⱡ ti iti nʉtʉnt. Nim ant tenda ila, ku ruri tenda nguimp nʉnt ei, kapⱡa nʉkʉn nim ok, kongun in ni ka! ");
INSERT INTO med_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nim nga ku tin ei mel, tin ei kʉn, mekʉn mang kona pi! Ya wu ant ei, mana pʉng omba, kongun em wu ni, nim ngont ku peng ni mel ku nguimp. ");
INSERT INTO med_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ku nanim nga mbʉ ndi, nanim kʉmp tʉp, itimp nʉmp pint mbʉ mel, iti nʉtʉmp ye? Muna, nim wu kʉⱡ kʉn, ku moni kapⱡa etʉp ngont ei nga wʉlʉk ron ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wote Jisas ndi, ik ek kʉⱡ ropa pora ndupa nimba mel, “Akil teng wamp mbʉ ok, kuimbal ping, wote kuimbal moⱡʉng wamp mbʉ ok, akil ting,” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","19","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, wi Jerusalem mbin nʉk puk, nombuⱡa rʉk tʉngʉn ila, Jisas ndi, wu kʉⱡ ekit tʉpa ndenga nimba, kundpa nimba mel, “Pilik kun tʉi! Tʉn wi Jerusalem punmʉn ila, Muⱡʉl Muⱡʉl Wu Kupa ei, imp molk tʉk, pris wu kuimbal kʉⱡ kʉn, mi ik mbo wu kʉⱡ kʉn nguing. Wu kʉⱡ ndi, wu ei punt wu nʉk, rok kundʉi nʉk, tʉk mek puk wu rʉⱡaip elpa kat ngangina, kan ngʉk tʉk ik kuldʉk, tʉmbʉⱡ rok tʉk, nde peta ila nil rok pindangina, pepa koⱡmba. Wote, rumbʉⱡ raldika omba pangga, ⱡoporpa tʉpa oⱡa mondʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wu Sepeti ambʉm ni, elim nga kangʉm raⱡ mepa omba, Jisas murum nila, mura ropa mondpa mel ti, mawa etmba itim. ");
INSERT INTO med_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wote Jisas ndi, “Nim namba mel ei, numan ngun?” nimba wuldʉtʉm. Amp ni ndi, punt ropa nimba mel, “Nim nga tʉpa mumuk rui kona ila nim wu nuim mʉn ei kʉn, na nga kang wu raⱡ nga ti tʉkʉn, ki mbo orunga mondkʉn, ti tʉkʉn, ki rar orunga mundimp nʉn nʉmp ont,” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas ndi, punt ropa nimba mel, “Nim mawa etkʉn nʉn ik ei, pilkʉn kun iti natʉk ninmin. Na mindil nu nuimp ent nu ming tenda ila, kapⱡa enim kapⱡa nuing ei?” nimba wuldʉtʉm. Wote, punt rokʉⱡ nʉkʉⱡ mel, “Tʉl kapⱡa nuimbil,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wote Jisas ndi, kundpa nimba mel, “Enmbil na nʉnt nu ming tenda ila kapⱡa nuinggil mint. Wote nam ti, na nga ki mbo orunga muna, rar orunga moⱡmba ei na ndi, nimp mel kapⱡa mon. Kona raⱡ na nga Wuta ei ndi, to ropa titim wamp mbʉ nga kona tetʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wote, wu raⱡ nga ik nʉtʉnggil ni, kitip kʉni wu 10 kat ndi, pilik popʉⱡ kurung. ");
INSERT INTO med_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wu kʉⱡ popʉⱡ kurung uⱡ ei, Jisas ndi, kandpa, wu ni kʉⱡ pʉkʉ, wi ropa rukʉr tʉpa, nimba mel, “Enim pilik mormin ei, mbo wu nuim mbo wamp mbʉ, ou kel mbʉ ambulk, oⱡa mana etʉk, wote en enim oⱡa mel puk wamp mbʉ ndi, en enim nga ik mbʉ teng ndeing nʉtmin. ");
INSERT INTO med_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Uⱡ ei mel, enim kʉn pi nʉpangga! Enim nga ruⱡ ila wu ti, nuim muⱡimp nimba pilim ndam, enim nga kindmant wamp mel muⱡangga! ");
INSERT INTO med_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ei kʉn, enim kʉn kuimbal muⱡimp nimba pilim wu ei, enim nga kindmant wamp kurpa raⱡpa muⱡangga! ");
INSERT INTO med_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ei nambuⱡ emel, Muⱡʉl Muⱡʉl Wu Kupa ei ndi, enim tʉpa kindmant wamp rundi nandʉmba mon. Enim nga kindmant endpa, elim nga kont mba mul uⱡ ei, wak ropa, wamp minal etpa tʉmba, pilpa mana urum ei mel, enim i ku itʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, Jeriko wak rok kelik ping oⱡina, wamp minal Jisas pep rok, akil tek orung. ");
INSERT INTO med_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wu mong ti raⱡ, nombuⱡa ʉldʉ ila molkʉⱡ pʉtʉnggil mel, Jisas ni omba punum nʉtʉng ila, wi rokʉⱡ nʉkʉⱡ mel, “Wu Nuim ye! Depit nga kangʉm. Tʉl kont kun ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wote, wamp nimbʉ ndi, ik ngʉk, raka ni kʉⱡ moⱡʉnggil ka nʉtʉng ni, pilik kelkʉⱡ wi oⱡa ndukʉⱡ, rokʉⱡ nʉkʉⱡ mel, “Depit nga kangʉm wu Nuim ye! Tʉl kont kun ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas ndi, nombuⱡa ila anggilpa, wu raⱡ waldpa nimba mel, “Na ndi, enmbil etʉp iteimp nʉk, nʉnmbil mel nant?” nitim. ");
INSERT INTO med_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wote, wu raⱡ ndi, punt rokʉⱡ nʉkʉⱡ mel, “Nuim ye! Tʉl nga mong raⱡ etkʉn, piral ndun nʉmp nʉnmbʉⱡ ei ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ni kʉn, Jisas ndi, wu raⱡ kandpa kont elinga, wu raⱡ nga mong ila ambuⱡnga, tʉngʉnda mint piral nilinga, kona kandkʉⱡ, Jisas purum mel, pep rokʉⱡ purʉnggil. ");
INSERT INTO med_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jisas ni, elim nga kitip kʉni wu kʉⱡ kʉn, Jerusalem kona nondpa ok, Olip komnga mana orunga Betpeis manga rʉⱡaip ila ok, elim nga kitip kʉni wu raⱡ tʉpa, kuimp tepa mundpa nimba mel, “Noi manga rʉⱡaip ila pukʉⱡ, kng donggi mam ti, waⱡ ei kʉn, kan kulk tenda ila pendʉng ei, kan potkʉⱡ mek, na kʉn wʉl! ");
INSERT INTO med_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wamp na ti ndi, kandpa nim ndam, enmbil ndi, ni kʉⱡ mel, ‘Nuim ei ndi, uⱡ ti itimp nim ila, timbil onmbʉⱡ nʉl. Wote ei kʉn, kng donggi raⱡ mek pʉl nimba wak romba,’” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","“Uⱡ i itim ei ndi, painui wu ti nga nitim ik ei, omba kupa itim, ");
INSERT INTO med_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Saiyon mbuⱡam ei kundʉk, enim nga wu Nuim ei enim kʉn onum. Wu ei koma pou raⱡ tepa, kng donggi kokila ei nga mbuⱡ ming ila moⱡpa onum.’” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wote, kitip kʉni wu ni raⱡ ndi pukʉⱡ, Jisas nitim ni mel etʉnggil. ");
INSERT INTO med_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kng donggi waⱡ mam raⱡ mek okʉⱡ, en enmbil nga wal pʉki mbʉ, potkʉⱡ donggi kokila mbuⱡ ila oⱡa nduk tilinggila, Jisas ni oⱡa mbʉ pol ila murum. ");
INSERT INTO med_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wamp minal morung nimbʉ nga mat ndi, en enim nga wal pʉki na mbʉ, potʉk nombuⱡa mam ila kumbʉlʉk tetʉng, mat ndi, nde omung na yaⱡa ongum na mbʉ ranggʉk, tʉk nombuⱡa omba ila kumbʉlʉk tetʉng. ");
INSERT INTO med_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jisas urum ila wamp minal ok, kuimp akil tek, ʉⱡi rok kei nʉk, “Depit nga kangʉm ei mbi pangga! Oⱡa Nuim ei nga mbi ila tʉpa angʉndpa onum ei, Got ndi, memp pindangga! Got nga mbi ei paka rʉndamin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas wi Jerusalem rukʉr puⱡnga, kona puⱡ wamp nimbʉ ndi, rot nʉk mel, “Wu ei nam?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wote, wamp num ila mat ndi, nʉk mel, “Wu ei, Galili kona orunga, Nasaret nga painui wu Jisas ni onum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Jisas manga wingti ou ila murʉk mba wamp mel mbʉ tek rarʉp rok, etʉk morung nimbʉ, makrʉpa tʉpa pena ndurum. Wote ku moni na, kʉi na, yoⱡ etʉk morung wu mbʉ nga rat pol nimbʉ, ropa kungʉndrʉm. Jisas ndi, wu nimbʉ morung kundpa nimba mel, “Buk Wingti ila, Got ndi, ik ti nitim, ‘Na nga manga wingti ei, mbi tek atinga manga nʉi,’ nʉtʉm. Ni nga wote, enim ndi tʉk, kindʉp wamp nga mi manga randʉnmin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas ni mba, manga wingti ou ila moⱡnga, kʉmp ki rumbrʉm wamp na, mong tʉtʉm wamp mbʉ kʉn, mek oⱡina, etpa titim. ");
INSERT INTO med_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jisas oⱡina ndi, uⱡ ronduⱡ mat itim nimbʉ kʉn molk kandrung. Wote, kangambuⱡa mbʉ ndi, manga wingti ou ila ke nʉk mel, “Wu Depit nga kangʉm ei, mbi paka rʉndamin!” nʉtʉng. Ni kʉn, wu pris peng mumuk kʉⱡ kʉn, mi ik mbo wu kʉⱡ kʉn, uⱡ mbʉ kandʉk popʉⱡ mondrung. ");
INSERT INTO med_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kangambuⱡa mbʉ i nilingina, wu ni kʉⱡ ndi, Jisas waldʉk nʉk mel, “Nim ik nʉnmʉn ei pʉnmin?” niting. “Na pʉnt ei ka,” nimba punt ropa wu kʉⱡ, wote waldpa nimba mel, “Enim Buk Wingti ila petʉm ik kʉⱡ, kʉmp rok kandʉrmin muna mon? ‘Oⱡa Got ndi, kangambuⱡa kel na, waⱡ nana na mbʉ nga keta ila, mbi paka rundi uⱡ mbʉ nga mbo endʉtʉm?’” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wote Jisas ndi, wu ni kʉⱡ wak ropa, kona peng ila kelpa ekit mba, Betani kona ila mba rumbʉⱡ tenda mel murum. ");
INSERT INTO med_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ipri unt Jisas ni, Jerusalem kona peng ila yant uimp nimba oⱡnga, kun kurum. ");
INSERT INTO med_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wote kʉndrʉm mel, nde ui kat nombuⱡa mam ʉldʉ ila murum ila, mong ropa petʉm muna mon nda? Nimba ruk purum mel, mong ti ropa pi nʉpʉtʉm, wei ongum etpa murum. Jisas ndi, nde ui kʉⱡ kundpa nimba mel, “Nim wote, ui mbila mong ti rui nʉrʉn!” nitim. I nilinga, tʉngʉnda mint, nde ui ni kʉⱡ kurum. ");
INSERT INTO med_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kitip kʉni wu ni kʉⱡ uⱡ ei kandʉk, min ngʉn mundʉk nʉk mel, “Nde ui kʉⱡ tʉngʉnda mint konum ei, etpa enim mel nant?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas ndi, ik nʉtʉng ni, punt ropa nimba mel, “Na enim ik kupa ei, kundʉp nʉnt. Enim Got kʉn mondʉk pilik, numan ʉkpʉk ti natʉk eng ndam, ya nde ui kʉⱡ kʉn, ent uⱡ ni mel kapⱡa iting. Wote, ei mint mon, ya komnga ei kundkʉn, ninim akʉkʉn, oⱡa tʉkʉn, num kuta ila mana pi nin ndam, kupa omba mba mint. ");
INSERT INTO med_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Enim Got kʉn mondʉk piling ndam, namba mel mat atinga rok, ngangga nʉk, waldʉng mbʉ ngumba mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas manga wingti ou ila yant omba, ik puⱡ mondpa mbo inditim ni kʉn, wu pris na, manga wingti rʉp wu na nimbʉ ndi waldʉk nʉk mel, “Tʉn ndi, nim kongun ngui ngʉngmin ni, nim ronduⱡ ei nam ndi, nguⱡnga en?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Wote Jisas ndi, wu kʉⱡ nga ik nʉtʉng ni punt ropa nimba mel, “Na ndi, enim ik ti wuldimp ent ei, punt rong ndam, na nam ndi, ronduⱡ nguⱡnga ent uⱡ mbʉ mel, enim kundʉp nimp. Jon wamp nu tʉndʉtʉm ni, nam ndi kongun ngurum, Oⱡa Got ndi, ngurum muna, mana wamp ti ndi, ngurung?” nitim. Nitim ila, en enim rʉk ik palk nʉk mel, “Etʉp nimʉn mel nant? Tʉn pʉnt ropʉn nimbun mel, ‘Oⱡa Got ndi ngurum,’ nimʉn ndam, ‘Tʉn kundpa ei ndam, wote enim Jon nitim ik ei, nambuⱡ emel, mondʉk pili napʉtʉng?’ ");
INSERT INTO med_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wote tʉn ndi, ‘Mana wamp,’ ti ndi, nimʉn ndam, wamp mbʉ ndi, tʉn kʉn ik mura ting ei nga mundmong itmin. Ei nambuⱡ emel, Jon ei painui wu ti nʉk pilik mormin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jisas nga ik ni punt rok nʉk mel, “Tʉn pili napʉn mon,” nʉtʉng. Jisas ndi, wu kʉⱡ kundpa nimba mel, “Enim pili napʉlʉng ndam, wote na uⱡ ent kʉⱡ nga ronduⱡ ei, nam ndi, ngurum ei, enim kundʉp ni nʉnimp mon ku,” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ei kʉn, enim namba nʉk pʉnmin? Wu ti kang wu raⱡ etpa mitim. Wu ni ndi, kangʉm kang wu kumna ei kundpa, ‘Nim akup pukʉn wain pana ila kongun tʉn pi!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nitim ni, kang wu ei ndi, punt ropa nimba mel, ‘Na iti nʉtimp!’ nimba, wote moⱡpa numan wang ndupa mba itim. ");
INSERT INTO med_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Wote, wu ni ndi, mba kangʉm akil ni, ik tenda ei ku kundpa nitim ni, kang wu ndi, ‘Kapⱡa nʉn kongun ei itimp,’ nitim. Wote, kongun ei mba iti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ei kun, kang wu nant ei ndi, tipam nga nitim ik ei teng ndurum?” nimba wuldʉtʉm. Wu ni kʉⱡ ndi, “Wu komun ei,” nʉtʉng. Wote Jisas ndi, wu kʉⱡ kundpa nimba mel, “Enim ik kupa ei kundʉp nʉnt. Ku moni takis ti wu mbʉ kʉn, amp wapra rui mbʉ kʉn, Got nga tʉpa mumuk rui uⱡ ila, kuimp tek pangina enim, akil ting. ");
INSERT INTO med_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ei nambuⱡ emel, Jon ndi omba, enim nombuⱡa kun kai ei, tʉpa orunga ndurum ei, enim tʉk pei mundrʉng. Wote, ku moni takis ti wu mbʉ kʉn, amp wapra rui mbʉ kʉn, Jon nitim ik ei, mondʉk pʉtʉng. Wamp kʉⱡ i etʉng uⱡ ei, enim kandrung ku. Wote, enim molk akil tek, numan ropʉl rok, Jon nitim ik ei kep, mondʉk pili napʉtʉng ku,” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas ndi, wu pris na, manga wingti rup wu nimbʉ, kundpa nimba mel, “Ik ek ti ku, kum tek pilʉi! Ui ti kʉn, wu nuim ti, wain pana ti raⱡpa, wote paⱡa etpa rʉk ndupa, wain mong ropa ngurmba kona ti, wʉng ila kut akpa tepa, wote rup manga roⱡ ti raⱡpa, mepa oⱡa mba itim. I etpa tepa kona roⱡ tila mba pilpa, wain pana ei wu mat ndi, rʉp indeing nimba ngumba pendpa purum. ");
INSERT INTO med_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wote, wain rʉnging ui ei, nondpa urum ni kʉn, elim nga kindmant wu, tʉpa wain pana rʉp etʉng wu nimbʉ, morung kona ila, elim nga wain mat ranggʉk, teing nimba tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wain pana rʉp etʉng wu ni kʉⱡ ndi, kindmant wu ni kʉⱡ imp molk, ti tem poⱡ ndi rok, ti rok kondʉk, ti ku ndi rok etʉng. ");
INSERT INTO med_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wote, kindmant wu mat minal i ku etpa pilpa, kelpa tʉpa nga mundrum nimbʉ, wain pana rʉp etʉng wu nimbʉ ndi, unt wu raldika kʉⱡ etʉng ni mel ku etʉng. ");
INSERT INTO med_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wote akil tepa, elim nga kangʉm kʉnt ei tʉpa mundpa, ‘Na nga mit kang ei, kandʉk mbi nduk rui nʉring,’ nimba pitim. ");
INSERT INTO med_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","39","Wote, pana rʉp wu kʉⱡ ndi kandʉk, en enim ol tek nʉk mel, ‘Ya pana puⱡ puⱡ raⱡpa tʉmba wu ei onum. Ei kʉn, kang wu ei, rop kondpʉn, ya pana ei tʉn tamin,’ nʉk, kang wu ni imp molk mel, wain pana ʉldʉ ila etʉk puk rok kondʉk tetʉng. ");
INSERT INTO med_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ei kʉn wote, pana puⱡ wu ei, elim yant om ei kʉn, wain pana rʉp etʉng wu kʉⱡ, nambuⱡ ti etmba nda?” nitim. Nimba kʉn, Jisas ndi wuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wu nimbʉ ndi, “Uⱡ minʉpi etʉng wu kʉⱡ, ropa mbo nomundpa, wain pana ei tʉpa, wu kat ku rʉpʉtang nimba ngumba. Ngum wu kʉⱡ ndi, wain rupa rom ei kʉn, tʉk elim nguk ku iteing,” nimba itim. ");
INSERT INTO med_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas ndi, wu nimbʉ kundpa, nimba mel, “Buk Wingti nga ik mong ti, ya ei mel petʉm ndi, kʉmp rok kandʉrmin mon? ‘Manga rʉki wu mbʉ ndi, nde ti kit nʉk mundʉk ketʉng ni, omba runga nde mel petʉm. Ei Oⱡa Nuim ei ndi elinga, tʉn ndi, uⱡ numan iti nʉmp kandʉrmin,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ei kʉn, akup enim ik ti kundʉp namp, Got nga wamp tʉpa mumuk rui uⱡ enim kʉn petʉm ei, ekit tʉpa etʉk muⱡ pinding wamp mat ngumba. ");
INSERT INTO med_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wamp nam ti, runga nde pol ila mba pem ti, rangga gurpa elpa elpa mba, wote runga nde ei, omba wamp ti nga kʉng ila pem ndam, wamp ei ropa, nim nim ndupa pendʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Wu pris kuimbal na, mi ik pep rui wu na nimbʉ ndi, Jisas ik ek rʉrʉm nimbʉ, en enim kʉn ninim nʉk pʉtʉng. I nʉk pilik, Jisas ni tʉp kan nguimin nʉk nombuⱡa mam mat kururum. Ei kʉn wote, wamp mbʉ nga mundmong etʉng. Ei nambuⱡ emel, wamp mbʉ ndi, Jisas ei, painui wu ti nʉk pʉtʉng ei nga. ");
INSERT INTO med_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Wote Jisas ndi, aldpa wamp mbʉ kʉn, ik ek ti ropa nimba mel, “Muⱡ ila tʉpa mumuk rui uⱡ ei, wu nuim ti ndi, elim nga kangʉm ei nga, amp kuima ngumba ant ei kʉn, rʉng mam ti kuitʉm. ");
INSERT INTO med_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wote, elim nga kindmant wu kʉⱡ tʉpa wamp tʉma mat rung mundrum mbʉ, pok tʉk mek, ‘Wei!’ nitim. Wote wamp nimbʉ, ‘Ui nawʉmin,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wote, kindmant wu mat ku tʉpa mundpa, wamp tʉma rung mundunt mbʉ puk nʉi, ‘Na mbo kng kai men pi kai nimbʉ mint koip mondʉp, amp kokila tint ei nga tʉng mel mbʉ, tʉp kun etʉp pora ndunt, kʉn wʉi!’” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Wote, rʉng mundrum wamp tʉma mbʉ ndi, rʉng kʉnt nitim ik ni, tʉk pei mundʉk, en enim ik elpa nʉk purung. Wu ti kongun kona nila purum, wote wu ti mel rarʉp romba purum. ");
INSERT INTO med_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wote, runt mundrum wamp mat ndi, kindmant wu nimbʉ imp molk, tʉmbʉⱡ ndi rok kondrung. ");
INSERT INTO med_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","I etʉng uⱡ ila, wu nuim ei popʉⱡ kuⱡpa, elim nga el wu rʉⱡaip mbʉ tʉpa munduⱡnga, kongun wu rok kondrung wu nimbʉ, rok kondʉk, puk kona peng ei rok ndip kalk etʉng. ");
INSERT INTO med_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Wote, wu nuim ei ndi, enim mba kindmant wu mbʉ kundpa nimba mel, ‘Amp tʉp rʉng kuip itim mel mbʉ etʉp pora ndunt. Wote rʉng neing nimp kanggʉp ambʉⱡʉp ngur wamp nimbʉ, ui nawʉng kant. Ei kʉn akup, puk nombuⱡa mam mbila wamp roldʉnga mbʉ kandʉk nangina, amp tʉp rʉng kunt mbʉ ok neing!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ni kʉn, kindmant wu mbʉ ndi, puk nombuⱡa mam mbila, wamp kit kai mbʉ roldʉnga tʉk mek oⱡina, wu num ei ni nga manga ni moⱡina, ti nitim. ");
INSERT INTO med_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","12","“Wote, wu nuim ni ndi, wamp ponʉng ong mbʉ mel kʉnimp nimba omba, kʉndrʉm mel, wu ti muⱡ ping kai ti rʉⱡi naⱡʉpa, muⱡ mbal ping ti, raⱡpa omba murum. Kandpa kʉn, ei mel nitim, ‘Wu ang ye! Nim muⱡ mbal kai ei, rʉⱡi nʉⱡʉn kant ei. Wote, ya ila etʉk mukʉr un mel nant?’ nitim. Nimba wuldʉtʉm ni kʉn, ik ti punt ropa ni nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wote, wu nuim ni ndi, kindmant wu ni kʉⱡ, kundpa nimba mel, ‘Wu ei kʉmp ki raⱡ kan ngʉk rok mundangina mba, pena kona rumbʉⱡ mul ila muⱡangga! Kona ila ka rom ropa, gu konggilpa, gʉkʉr tʉpa muⱡangga!’ ");
INSERT INTO med_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Wote, Jisas ndi, nimba mel, “Got ndi, wamp ou ndupa rung mundrum. Wote, wamp onunga kʉralt, kʉmp tʉpa, rukʉr tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wote, Perisi wu ni kʉⱡ, en enim int puk ol tek, Jisas ik mat nangga nʉk, oⱡa tʉk kʉning ei nga kaip rok nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I nʉk pendʉk, Perisi wu mbʉ nga kitip kʉni wu mat kʉn, king Erot nga wu kat kʉn, tʉk Jisas murum kona ila tʉk mundrʉng. Wu ni kʉⱡ ndi, nʉk mel, “Ik mbo wu ye! Nim ik kupa nʉkʉn, Got nga uⱡ mbʉ wamp mbʉ kʉn, iteing nimba petʉm ei mel, kupa mbo endkʉn, wote wamp nga numan pilik etmin uⱡ mbʉ nga mundmong iti natkʉn, wamp nga kʉng orung kandkʉn ei, kit kai ni nandʉtʉn uⱡ ei, tʉn pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Akup, nim etʉk pʉn mel nant ei, tʉn kundʉk na? Moses nga mi ik ei ndi, tʉn Rom Gapman ei kʉn, ku moni takis ngormʉn uⱡ ei, kapⱡa muna mon?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wote Jisas ndi, wu kʉⱡ ik ol tek pendʉk ok, waldʉtʉng ik ni, tʉpa mendpa nimba mel, “Enim wamp kun kai mul kump rʉⱡi wu mbʉ ye! Enim na nambuⱡ emel, na oⱡa tʉp kʉnmin nʉk pilik waldʉnmʉn? ");
INSERT INTO med_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","Ku moni takis ngormʉn ei nga ti mek ok, na tʉk ora ndʉiya!” nitim. Ni kʉn nilinga, ku moni ti mek ok ngoⱡina, wote Jisas ndi, ei mel etpa waldpa nimba mel, “Ku ila mbi ei kʉn, kuimp keta ei kʉn, nam nga morum?” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wote, wu ni kʉⱡ ndi, nʉk mel, “Kuimp keta kʉn, mbi kʉn, wu peng mumuk Sisa ei nga,” nʉtʉng. Ni kʉn, Jisas ndi, pʉnt ropa nimba mel, “Wu peng mumuk Sisa nga mel ei, elim ngʉk, wote Got nga mel ei, Got elim ngʉk itʉi!” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ik i nitim ni pilik, min ngʉn mundʉk, wote Jisas ni wak rok kelik purung. ");
INSERT INTO med_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Wamp kolk, wote kont muⱡi nʉmbʉⱡing nʉtmin Sarusi wu kʉⱡ ndi, ant tenda ei kʉn ok, Jisas ik ti waldʉk nʉk mel, “Ik mbo wu ye! Moses nga mi ik ei ndi, nimba mel, ‘Wu ti kangambuⱡa mi nambʉpa, koⱡum ndam, amp wiya ei, elim nga ʉngʉn ei tʉpa, wote kangambuⱡa mem mbʉ, elim nga ʉngʉn kurum ei nga koⱡ ila muⱡeing,’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ei kʉn, akup wu ʉngʉn ʉngʉn uⱡ 7 kat ya kona ila morung. Wu ʉngʉn komun ei, amp tʉpa mondpa kangambuⱡa mi nambʉpa elim kurum. Wote, ʉngʉn rʉkʉnʉ ei ndi, amp wiya ei titim. ");
INSERT INTO med_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wu rʉkʉnʉ ei, i ku etpa wangʉn pepa kurum. Wote, ʉngʉnʉl merʉng ni ndi, i ku etpa, amp wiya ei, tʉpa ambuⱡpa wangʉn pepa kurum ku. I etpa mba, wu 7 ni kʉⱡ kʉn ekit purum. ");
INSERT INTO med_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ama akil tepa amp ni kurum. ");
INSERT INTO med_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wu 7 kʉⱡ ndi, amp tenda ei, etʉk tʉk pora ndurʉng. Wote, wamp kui mbʉ, ⱡoprʉk oⱡa moⱡʉng ui ei kʉn, amp kupa ei wu nam nga nda?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas ndi, ik ni, punt ropa nimba mel, “Enim ⱡawa enmin ei ka! Nambuⱡ emel, Got nga ik mong ei kep, Got nga ronduⱡ ei, enim pilik kun iti natʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ni kʉn, wamp kui mbʉ, ⱡoprʉk ok pung ui ei kʉn, aldpa wu amp nʉk, iti nʉting. Oⱡa muⱡ ila anggelo mbʉ, wu amp ni nandʉtmʉn ei mel ku, wamp mbʉ i ku iting ");
INSERT INTO med_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wamp koⱡpa kont mul uⱡ ei nga ik ti, Got nga Buk Wingti ila petʉm ei, enim kʉmp rok kandʉrmin mon? ");
INSERT INTO med_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ik ei ndi, nimba mel, ‘Na wu Aparam nga Got, na wu Aisak nga Got, na wu Jekop nga Got,’ nitim. Wu ei, wamp kui mbʉ nga Got ti mon, wamp kont mbʉ nga,” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wamp num morung nimbʉ ndi, Jisas ik mbo inditim nimbʉ pilik, min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Perisi wu ni kʉⱡ ndi, pʉtʉng mel, Jisas ndi, Sarusi wu kʉⱡ ik ning nombuⱡa kumba pendnim nʉtʉng ik ni pilik, en enim nʉk mo rorung. ");
INSERT INTO med_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Wote, mi ik mbo wu ti ndi omba, Jisas kʉn ⱡawa ti kandʉp timp nimba ik ti, wʉldpa nimba mel, “Ik mbo wu ye! Mi ik mbʉ nga mi ik peng ei nant?” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas ndi, punt ropa nimba mel, “Nim nga Nuim Got ei, nim nga mundmong ei kʉn, nim nga min ei kʉn, nim nga numan ei kʉn numan ngui! ");
INSERT INTO med_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mi ik nʉnt ei, mi ik kʉⱡ nga mi ik peng mumuk ei. ");
INSERT INTO med_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","‘Mi ik peng merʉng orunga ei, nim nga manga keta kup wamp mbʉ, nim ninim numan ngorum ei mel ku, wamp mbʉ numan ngui!’ ");
INSERT INTO med_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mi ik peng raⱡ ndi, painui wu mbʉ nga ik mbo endʉtʉng mbʉ kʉn, Moses nga mi ik mbʉ nga peng petʉmbil,” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Perisi wu kat tʉk mou rok morung ni kʉⱡ, Jisas ndi waldpa nimba mel, “Kraist ei nam nga pundʉn ei nga kangʉm ei nda?” nitim. I nilinga, wu ni kʉⱡ ndi, punt rok nʉk mel, “Depit nga pundʉn ei,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Jisas ndi, waldpa nimba mel, “Wu Depit ni, Got nga Muⱡnga ei ndi, kundpa nilinga, ‘Kraist ei, na nga Nuim ei,’ nitim ei, etpa nitim mel nant? Depit ndi, nimba mel, ‘Oⱡa Nuim ndi, na nga Nuim ei kundpa, “Nim na nga ki mbo orunga muⱡana, Na ndi, nim nga el rui wamp mbʉ tʉp nde pol mel pindamba kamblik muⱡʉn,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Unt Depit ndi, Kraist kundpa nimba mel, ‘Nuim,’ nitim. Ei kʉn, Kraist ei, Depit nga pundʉn etpa pimba mel nant?” nitim. ");
INSERT INTO med_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas i nitim ila, wu ti ndi, ik punt rui narʉrʉng. Wote, ui ei kʉn, wamp ti ndi, Jisas ik mat waldʉk iting ei nga mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Ei kʉn, Jisas ndi, wamp minal morung nimba kʉn, elim nga kitip kʉni wu nimbʉ kʉn, kundpa nimba mel, “Mi Ik mbo wu mbʉ kʉn, Perisi wu na mbʉ, Moses nga koⱡ ila molk mi ik mbo endʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wote, enim ik kundʉk, nʉng mbʉ, kum tek pilʉi! Wote, uⱡ eing mel, iti nʉtʉi! Ei nambuⱡ emel, en enim, wote uⱡ etmin ei mel iti natʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Perisi na, mi ik mbo wu mbʉ ndi, mel mbun itmbʉⱡ tʉk, wamp mi ui nʉk, wote en enim ndi, tʉk rʉpndi napʉndʉrmʉn. ");
INSERT INTO med_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","En enim nga uⱡ etmin mbʉ, wamp mbʉ ndi, kandʉk neing nʉk etmin. Got nga ik mong mbʉ, mon rok, mʉi ombil ila pendʉk, ki oⱡa mondʉk, wote muⱡ roⱡ mbʉ nuim kan ila rumbʉⱡ nga mba, met kʉmp puⱡ ila purum mbʉ, kandʉk neing nʉk etmin. ");
INSERT INTO med_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","7","Wote, rʉng ou mat karmin ei kʉn muna, manga wingti mbila puk, rat pol kuimbal mint muⱡing ei nga kai pilik, wote rʉng rarʉp kona na, wamp molk etmin mbila, en enim, ‘Ik Mbo Wu,’ mbʉ, nʉk tʉk ou nduk, rawe iteing nʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ei kʉn, enim kundʉk, ‘Ik Mbo Wu,’ ni nʉneing. Ei nambuⱡ emel, enim wu ʉngʉn ʉngʉn kʉⱡ, enim nga ik mbo wu tenda ei morum. ");
INSERT INTO med_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ya mʉi kona ila enim ndi, wu ti kundʉk, ‘Wuta,’ ni nʉnʉi! Ei nambuⱡ emel, enim nga tipanʉm wu tenda ei, oⱡa muⱡ ila morum. ");
INSERT INTO med_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Muna nim, ‘Ik Mbo Wu,’ ei, ni nʉnʉi! Ei nambuⱡ emel, nim nga ik mbo wu tenda ei, oⱡa muⱡ ila morum ei Kraist. ");
INSERT INTO med_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ei kʉn, enim nga rʉk ting ila wu nuim kuimbal ti moⱡum ndam, elim mepa mana omba, kongun wu raⱡpa muⱡangga! ");
INSERT INTO med_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wamp nam ti ndi, elim nuim muⱡimp nimba pilpa, em wamp ti, Got ndi, mepa mana omba. Wote wamp ti, elim nga orunga mepa mana omba moⱡum wamp ei, Got ndi, etpa wamp nuim mondʉmba. ");
INSERT INTO med_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Enim kun kai rʉl wu Perisi wu na, mi ik mbo wu na mbʉ, mbun mindil nuing an! Enim ndi, wamp mbʉ, Got nga wamp tʉpa mumuk rui uⱡ ila rukrʉng ping ormʉn mbʉ, mi pendʉtmʉn. Wote, en enim kep, ila rukʉr pi nʉping ei nga, mbin nʉk ormʉn wamp mbʉ, mon ku nʉtmin.  ");
INSERT INTO med_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Enim kun kai rʉl wu Perisi na, mi ik mbo wu na mbʉ mindil nuing an! Ei nambuⱡ emel, enim amp wiya na mbʉ nga manga mbʉ, kʉndʉp nok tʉk, wote uⱡ etmin mbʉ kamblik pendʉk, atinga roⱡ mbʉ rok etmin. I etmin uⱡ ila, Got ndi, enim mindil mam ti ngumba. ");
INSERT INTO med_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Enim kun kai rʉl Perisi wu na, mi ik mbo wu na mbʉ nga mindil nuing an! Ei nambuⱡ emel, ik mbo wu tenda ti endʉk, enim nga kitip kʉni wu runding ei nga nu komnga mbʉ, puⱡa rok kurʉk angʉndʉrmʉn. Wote, ti kandʉk tilingina omba, enim nga kitip kʉni wu rarum. Wote, enim etmin uⱡ mbʉ etpa, wote wu ei, ndip kona ila mba mindil nomba. Wote, enim nuing ei mel mon, mindil mam ti nomba. ");
INSERT INTO med_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Enim mong ti wu mat ndi, mat ki amʉnmʉn ei nga, na kont enim ei ka! Enim ndi, ‘Wamp ik mbo ei mel endʉtmin. Wamp ti ndi, mi tepa, Got kʉn mel ti nguimp nimba, manga wingti ou ei, mbi tem ndam, mi tepa nʉtʉm ik ei nga muⱡ ti mon. Muna manga wingti ila ku gol morum ei nga ti, mbi tepa angʉndpa, elim nga mi ik ei, ronduⱡ pangga nim ndam, elim itimp nim mi ik ei mel etpa muⱡ indangga,’ nʉtmin. ");
INSERT INTO med_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Enim mong ti, wu kekilip mbʉ ye! Mel nant ei mel muⱡ? Gol ei mel muⱡ muna, manga wingti ei ndi, ku gol ei etpa Wingti randrum uⱡ ei muⱡ? ");
INSERT INTO med_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Enim ik ti mbo endʉk, ‘Wamp ti ndi, elim nga nʉnt ik ei, ronduⱡ pangga nimba rat pol wingti ei, mbi tem ndam, elim nga mi tem ik ei nga ronduⱡ ti mon. Muna rat pol wingti ila gem ngui mel ti, tem ei nga mbi tepa, elim nga ik ei, ronduⱡ pangga nimba nim ndam, elim itimp nimba mi tepa nim ik ei, etpa muⱡ indangga!’ nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Enim mong ti wu mbʉ ye! Uⱡ nant ei uⱡ muⱡ? Rat pol Wingti ila gem ngui mel ei telmina, wingti rarum uⱡ ei ronduⱡ muna, gem ngormʉn ei ronduⱡ? ");
INSERT INTO med_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","21","Ei kʉn, wamp nam ti ndi, rat pol wingti ila mi tepa ik ti nim ndam, rat pol wingti ei kʉn, oⱡa pol ila mel gem mbʉ kʉn, pʉkʉ mi tetʉm. Wote, wamp nam ti ndi, manga wingti ei kʉn, mi tepa ik ti nim ndam, manga wingti ila mukʉr tetʉm mel mbʉ kʉn, wote Got manga Puⱡ Wu ila morum ei kʉn, mi tepa nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wote, wamp nam ti ndi, oⱡa muⱡ kona ei kʉn, mi tepa ik ti, nʉmp ronduⱡ mundimp nimba mbi tem ndam, wamp ei, Got nga rʉpndi pol morum kona ei kʉn, wote Got elim kʉn kunda mi tetʉm. ");
INSERT INTO med_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Enim kun kai rʉl Perisi wu na, mi ik mbo wu na mbʉ nga, na kont enim ei ka! Nambuⱡ emel, pana enim kim mbʉ nga kʉmp tʉk ki ti, gu nduk, Got kʉn gem nguimin nʉk ekit tʉk tʉndʉtmin. Wote, ya mi ik peng mbʉ, tʉk pei mundʉrmʉn. Ik mbʉ, wamp kʉn ik kupa ni uⱡ na, mʉn kan mundi uⱡ na, mondpa pili uⱡ na, kʉⱡ pep rui narʉrmin. Ya mi ik peng kʉⱡ pep rokʉn mel, wote mi ik kat wak rui nʉri. ");
INSERT INTO med_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Enim mong ti, rʉp wu mbʉ ye! Enim nga nu ming ila oⱡma ei petʉm nʉk tʉk mundʉrmʉn. Wote, kng kamel ei, pendʉk normin uⱡ ei pili napʉtmin. ");
INSERT INTO med_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Enim kun kai rʉl Perisi wu na, ik mbo wu na mbʉ nga, na kont enim ei ka! Nambuⱡ emel, enim nga ming kap mbʉ ekit orunga, ⱡumʉi rok kai etmin. Wote, ming rukʉr orunga na mbʉ, punt mong kandʉk tʉk etmin uⱡ mbʉ nga ⱡar minal morum. ");
INSERT INTO med_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Enim mong ti Perisi wu mbʉ ye! Enim ming rukʉr orunga, unt kuimp tek ⱡumʉi rangina kʉn, wote ekit orunga mbʉ, kunda eng numba! ");
INSERT INTO med_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Enim kun kai rʉl Perisi wu na, mi ik mbo wu na mbʉ nga, na kont enim ei ka! Nambuⱡ emel, nim wamp on kona ti, ou nduk, kai etʉk tetmin ni mel kapⱡa. Oⱡa mʉi pol ei, etʉk mon mundʉk tetmin. Wote wamp on kona rukʉr orunga mbʉ, wamp ombʉl kʉn, mel puri na mbʉ, peka ropa tetʉm ni mel kapⱡa. ");
INSERT INTO med_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ei mel ku, enim nga kʉng ekit orunga wamp ndi, kʉning ei nga etʉk kai mondʉrmʉn. Wote, enim nga numan ei ik kep kʉn, uⱡ kit etmin mbʉ nga peka ropa petʉm. ");
INSERT INTO med_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Enim kun kai rʉl Perisi wu na, mi ik mbo wu na mbʉ nga, na kont enim ei ka! Nambuⱡ emel, enim Painui wu mbʉ nga wamp on kona mbʉ, etʉk kai mondʉrmʉn. Wote, wamp kai mat molk korung mbʉ nga on kona mbʉ, ou ndurmʉn. ");
INSERT INTO med_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wote enim ndi, nʉk mel, ‘Tʉn nga anda kouwʉ kʉⱡ, unt morung ui ila, tʉn moⱡmina ndam, uⱡ ⱡawa etʉk, wote painui wu kʉⱡ, rok kondʉk etʉng uⱡ mbila, tʉn nga ki ti ila rʉk pi napʉⱡnga,’ nʉtmin. ");
INSERT INTO med_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","I nʉnmʉn ik ei ndi, nʉk mot nduk, unt wu kit kat molk, painui wu mbʉ, rok mema oi ndurʉng wu kʉⱡ nga mema tenda kʉⱡ, en enim namin. ");
INSERT INTO med_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ei kapⱡa kʉn, anda tʉpanʉmʉl kʉⱡ, puⱡ mondrung uⱡ nit ment ei, enim etʉk pora ndʉi! ");
INSERT INTO med_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Enim wimbʉ kit mbʉ ye! Enim Got ndi, tʉpa ndip mam ila rukʉr ndumba ei kʉn, enim nʉng nʉk ok ping ei? ");
INSERT INTO med_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ei kʉn, akup kum tʉi! Na ndi, painui wu mat kʉn, wu pilpa kungʉndi mat kʉn, ik mbo wu mat kʉn, tʉp enim kʉn mundimp. Wu mbʉ nga mat enim ndi, rok kunding. Mat nde peta ila ruing. Mat imp molk mek puk, atinga manga kel mbila mondʉk, tʉmbʉⱡ ndi ruing. Mat pep rok mek puk, kona peng mbila puk, mbila puk iting. ");
INSERT INTO med_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","I etʉk, wu nit mul nʉmbil mbʉ, rok kunding ei nga puⱡ ei omba, enim kʉn pemba. Wu nit mul nʉmbil, Eipel rok kondrung ui ei kʉn omba, wote wu Berakaiya kangʉm Sakaraiya ni, manga wingti ei kʉn, rat pol wingti ei nga rʉk ila, rok kondʉk tetʉng ei nga uⱡ mbun ei, pʉi enim ting. ");
INSERT INTO med_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Enim ik kupa ei, kundʉp nʉnt. Uⱡ i etʉng kʉⱡ nga mbun ei, akup ui ila wamp kalk tʉnmʉn mbʉ kandʉk ting. ");
INSERT INTO med_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Nim Got ndi, painui wu tʉpa mundrum mbʉ, rok kondkʉn, nombuⱡa rung wu na mbʉ, ku ndi rokʉn ku etʉn. Kʉi kulda mam ei ndi, elim nga waⱡ mbʉ, pou mana orunga mondrung ei mel, na nga ki raⱡ ndi, nim nga wamp mbʉ ambʉⱡʉp rʉk timp nʉmp ent. Ei wote, nim ei ndi, mon ku nʉtʉn ei ka! ");
INSERT INTO med_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","I etʉn uⱡ ei ndi, nim nga manga wingti ei, pi muⱡangga, kona ei wapra temba. ");
INSERT INTO med_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Enim ik ti kundʉp namp, akup ui ila kʉn, yant nduk molk, ping ila na kʉni nakʉndʉk, wote molk puk, ui tila, ‘Nuim ei nga mbi ila onum ei, Got ndi, memp pindangga,’ nʉng ei kʉn, mint na kʉning,’” nitim. ");
INSERT INTO med_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ni, manga wingti ou ei, wak rop kelip mbi nimba puⱡnga, elim nga kitip kʉni wu ni kʉⱡ ndi ok, elim wi rok manga wingti ei kʉn, wʉng ila manga morum mbʉ, tʉk ora ndurʉng. ");
INSERT INTO med_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisas ndi, wu kʉⱡ ik punt ropa nimba mel, “Enim manga mbʉ kupa kanmin. Ei nga, na enim ik ti kundʉp namp, manga kanmin ei nga ku mbʉ, rok gu ndangina, manga ei ʉtkil ropa mba pemba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wote, Jisas Olip komnga nila oⱡa mba murum ni kʉn, elim nga kitip kʉni wu kʉⱡ ndi, raka nʉk rʉk ok, elim waldʉk nʉk mel, “Nim nʉn uⱡ mbʉ, nant kʉn etmba ei, tʉn kundʉk nana pilamin! Wote, ui pora nangga, nim yant uin ei nga namba uⱡ mbʉ, itangga kandpʉn pilip muⱡmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas ndi, punt ropa nimba mel, “Enim wamp ti ndi, tʉpa tiki pundʉmba ei nga, tʉk mendʉk muⱡʉi! ");
INSERT INTO med_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ei nambuⱡ emel, wamp minal, na nga mbi ila onmʉn nʉk ei mel ning, ‘Na wu Kraist,’ nangina, wamp minal nʉk tiki punding. ");
INSERT INTO med_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kona nondpa mbila, el etʉk, el nung rok eing ik ei piling, wote kona elpa mbila, el enmin nangina, rʉnang ik ei piling ku. Wote, ik mbʉ pilʉng ei kʉn, mundmong iti nʉtʉi! Ei nambuⱡ emel, uⱡ mbʉ mel etmba mint, wote ui pora nimba ei kokila. ");
INSERT INTO med_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ei kʉn, mʉi kona mat kʉn, mat kʉn el iting. Wote, wu rʉⱡaip mat, en enim rʉk el itangina, kump kun kan tepa, kilimbʉmp kona mat ila ambuⱡpa, oⱡa tʉpa etmba. ");
INSERT INTO med_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Uⱡ kʉⱡ mel kuimp tepa etmba. Ei amp kangambuⱡa ming pilik, kuimp tek mindil normin ni mel etmba. ");
INSERT INTO med_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Wote ei kʉn, enim imp molk, uⱡ mbun mindil nui mbʉ ngok, rok kondʉk iting. Ei nambuⱡ emel, enim na nga nʉndʉk kongun endʉtmin uⱡ ila kandʉk, mʉi kona wamp mbʉ ndi, enim numan ngui ngʉnging. ");
INSERT INTO med_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ui ei kʉn, wamp minal ndi, en enim nga mondpa pili ei, wak ruing. Wote, mondpa pili wamp mat ndi, mat kʉn oi kan pendʉk rʉk muⱡangina, numan ropa pemba. ");
INSERT INTO med_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ei kʉn, wu mat kep, nok ok, en enim painui wu mbʉ onmʉn nʉk, wamp minal nʉk tiki punding. ");
INSERT INTO med_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ei kʉn, uⱡ kit mbʉ nga roldʉnga pangga, wamp numan ngui uⱡ ei, wak ruing. ");
INSERT INTO med_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wote, wamp ti ui ei kʉn, elim nga mondpa pili wak rui narʉpa, pewa aiwa nimba pangga, ui ei pora nim ndam, wamp ei Got ndi, etpa peng kont tʉmba. ");
INSERT INTO med_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wote, Got nga wamp tʉpa mumuk rui uⱡ ei nga rʉnang ik kai ei, nʉk pora ndangina, mba muⱡ uⱡ mbila, pilik kapⱡa endʉng ei kʉn, pora nimba ui ei omba. ");
INSERT INTO med_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Painui wu Daniyel ndi, nitim ni mel, uⱡ kit ti kona wingti ila anggilpa moⱡum kanʉng ndam, enim Juriya kona ila moⱡʉng wamp mbʉ nʉng nʉk, wi komnga mbila pʉi! ");
INSERT INTO med_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wote, wamp ti manga ʉi oⱡa orunga moⱡum ti mana omba, elim nga mel wal mbʉ, timp nimbʉ ui nʉwangga, mon nʉng nimba pangga! ");
INSERT INTO med_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kongun kuimbal pum ti ndi, mang kona yant omba, elim nga wal pʉki kʉⱡ timp nimba ui nʉwangga! ");
INSERT INTO med_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ui ei kʉn, amp kangambuⱡa mundi na, wote amp kangambuⱡa nana aim ngʉk moⱡʉng mbʉ, etʉk iting mel nant ndam, kont enim. ");
INSERT INTO med_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kongʉndʉp mbin ui ei, kona tipan poⱡum ei kʉn kep, kona mowi kor ei kʉn, ekit ui nʉwangga nʉk, Got kʉn atinga rok muⱡʉi! ");
INSERT INTO med_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nambuⱡ emel, ui ei kʉn, uⱡ mbun iti ekit omba mbʉ, muⱡ mʉi raⱡ mim itim ei kʉn, omba akup ui ila iti nʉtʉtʉm uⱡ mat omba. Omba wote, ui mbʉ kʉn, uⱡ kit ei mel ti pi napʉmba. ");
INSERT INTO med_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Got elim nga kʉmp ropa titim wamp mbʉ nga nindpa, ui kit ekit om ei, nondpa pora nangga, ni nandʉⱡnga ndam, wamp mat kont molk, ruⱡ pi napʉⱡʉngina. ");
INSERT INTO med_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ui ei kʉn, wamp ti ndi, nim kundpa nimba mel, ‘Kraist ei ya onum kana!’ nimba. Muna, ‘Int onum kana!’ nʉm ndam, ik ei, enim mondʉk pili nʉpilʉi! ");
INSERT INTO med_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ui ei kʉn, wu mat Kraist ralk, wote mat, Painui wu ralk, uⱡ min ngʉn pi mbʉ nga ou nduk iting. Nambuⱡ emel, uⱡ ei mel itangina, Got nga kʉmp ropa tʉtʉm wamp mbʉ, Got wak reing nʉk kongun mindil nok iting. ");
INSERT INTO med_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Uⱡ wote, etmba ei nga, enim unt nʉmp ndoimp rondʉnt ei pilik muⱡʉi! ");
INSERT INTO med_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ei kʉn, enim wamp ti ndi, kundpa nimba mel, ‘Kraist ni omba, kona kui waka ila morum kʉnʉiya!’ Nʉng ndam, kona ila pi nʉpʉi! Muna nʉk mel, ‘Ya manga ila mo ropa morum kʉnʉiya!’ Nʉng ndam, nʉng ik ei, mondʉk pili nʉpilʉi! ");
INSERT INTO med_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kona kiraipa etʉm ei kʉn, rʉⱡang ei, al orunga etpa mba, wʉl orunga kapⱡa enduⱡnga, kapⱡa endʉtmin. Ni mel ku, Muⱡʉl Wu Kupa ei, muⱡ kona ei, wak ropa om ei kʉn, kandʉk wamp ndi, kandʉk kapⱡa inding. ");
INSERT INTO med_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kng, na mel mat purpa tetʉm ila, kʉi tap ok, rung tʉtmʉn,” nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mindil nok moⱡʉng ui mbʉ, pora nim ei kʉn nondpa, ant ei rumbʉⱡ moⱡmba, wote kona kalimp nga rʉⱡang ei kumbʉⱡpa, oⱡa muⱡ ila mipil rangʉnt mbʉ, ndanda nʉk mana uing. Wote, oⱡa muⱡ ei, ambuⱡpa gi ndurum mel mbʉ nga ronduⱡ ei, rowa ndumba. ");
INSERT INTO med_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ei kʉn, na Muⱡʉl Wu Kupa ei, uimp ei nga tip timal ti, wi muⱡ ila ekit wangga kʉn, mʉi kona wamp mbʉ kandʉk, ka itangina, na Muⱡʉl Wu Kupa ei, oⱡa kopa pol ila, ronduⱡ ei kun, rʉpndi nga rʉⱡang pol ila tʉmʉm tep wamba, mon pangga kʉning. ");
INSERT INTO med_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wote, Got nga kowa pela ik ei, ronduⱡ nangga, elim nga anggelo mbʉ tʉpa mundangga, puk muⱡ uⱡ tepa mba, punt rorum kona mbila, elim nga kʉmp ropa tʉtʉm wamp mbʉ, tʉpa tenda etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nde ui mun etʉm uⱡ ei ndi, enim etpa ora ndumba. Nde ui ongum kʉⱡ mun etpa, oⱡa orum ei kʉn kandʉk, kona ant mba enim nʉtmin. ");
INSERT INTO med_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ei mel, ya nʉnt uⱡ mbʉ mel em kandʉk, Muⱡʉl Wu Kupa ei, yant uimp nitim ui ndi, nondpa enim kant ei, ka nʉk pilik muⱡʉi! ");
INSERT INTO med_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Enim ik kupa ei, kundʉp nʉnt. Akup kalk tʉnmʉn wamp mbʉ, kolk pora ndui nʉndangina, ya nʉnt uⱡ mbʉ mel, ekit wangga kʉning. ");
INSERT INTO med_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Muⱡ mʉi raⱡ pora ninggil. Ei wote, na nga ik ei, ama pora ni nanʉmba. ");
INSERT INTO med_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Muⱡʉl Wu Kupa ei omba ui ei, rumbʉⱡ tila, muna rʉnggilmʉ, muna ant mong nant tila omba ei, wamp ti ndi, pili napʉtʉm. Muⱡʉl Wu Kupa ei, elim kep, oⱡa muⱡ ila anggelo mbʉ kep, pili napʉtmʉn. Wuta elim mint pilpa morum. ");
INSERT INTO med_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ui ni kʉn, unt wu Nowa murum ui ila wamp mbʉ, uⱡ etʉng ei mel ku, Muⱡʉl Muⱡʉl Wu Kupa ei, yant omba ui ei kʉn, ei mel ku etʉk muⱡing. ");
INSERT INTO med_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nu kui ui nʉwi kʉn, kng rʉng mel mbʉ nok, wu amp tʉk, amp wu puk etʉk moⱡina, wu Nowa ni omba, nu okak manga ila murʉk purum. ");
INSERT INTO med_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nowa itim uⱡ ei kandrung. Ei wote, tʉk mindi namʉndʉk moⱡina, nu kui omba wamp nimbʉ, tʉpa mepa purum. Muⱡʉl Wu Kupa ei omba ei kʉn, mana wamp mbʉ ndi, ei mel ku etʉk muⱡing. ");
INSERT INTO med_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ui ei kʉn, wu raⱡ pana kongun etʉk muⱡʉnggil, ti tʉpa mepa mba, ti mondpa kelpa mba. ");
INSERT INTO med_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ei mel ku, amp raⱡ oka pek rok muⱡanggila, ti tʉpa mepa pangga, ti moⱡmba. ");
INSERT INTO med_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nim tʉk mendʉk muⱡi! Ei nambuⱡ emel, nim nga Wu Nuim ei omba ui ei, nim pili napilkʉn morʉn. ");
INSERT INTO med_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","44","Ik kʉⱡ pilʉi! Wamp ti ndi, elim nga manga ei, kindʉp wamp ti ndi, akpa kindʉp nomba ant mong ei, pilinga ndam, rʉp etpa kandpa muⱡangga, kindʉp wamp ei ndi, ʉki nakʉⱡnga. Ei kʉn, enim rʉk rʉk tʉk kun etʉk muⱡʉi! Nambuⱡ emel, Muⱡʉl Wu Kupa ei, enim tʉk mindi namʉndʉk moⱡʉng, ant ni kʉn omba. ");
INSERT INTO med_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wu nuim ti mba etpa kʉn, elim nga kindmant wu ti, kongun teng ndupa pilpa kongʉndpa etʉm? Wu ei, elim nga manga ei rup itangga nimba, mbi ropa tʉpa mondpa, wamp mbʉ rʉng nuing ant ei kʉn, rʉng mbʉ kaⱡpa ngumba itangga nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kindmant wu ei, elim nga nuim ei ndi, nʉtʉm ei mel kongun mbʉ etpa moⱡnga, wu nuim ou ei omba, kandpa kai pilinga, kongun wu ei elim kai pʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Enim ik kupa ei, kundʉp nʉnt, wu nuim ei ndi, kindmant wu ei tʉpa, elim nga pana kongun na, kng mel na mbʉ pʉkʉ rʉp itangga nimba. ");
INSERT INTO med_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Wote, kindmant wu ei, wu kit ti ndam, elim ndi, nimba mel, ‘Na nga wu nuim ei tʉkrʉpa yant ui nawʉmba,’ nimba. Wote elim nga kindmant kongun kup wamp mbʉ, tʉmbʉⱡ ndi ropa, nu ronduⱡ normin wamp mbʉ kʉn, rʉng nomba, nu ronduⱡ nomba etpa moⱡmba. ");
INSERT INTO med_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ei kʉn, kindmant wu ei nga, elim nga nuim ei, elim tʉpa mindi namʉndpa moⱡum ant mong ei kʉn omba. ");
INSERT INTO med_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wote ei kʉn, wu nuim ei ndi, kindmant wu ei, tʉmbʉⱡ ndi ropa tʉpa, ik kol wamp mbʉ kʉn, mindil nok mormin kona ila kup indangga muⱡing. Kona ila mindil kolk, ka etʉk gu konggilik muⱡing. ");
INSERT INTO med_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ui ei kʉn, muⱡ kona tʉpa mumuk rui uⱡ ei, amp wendʉp 10 kʉⱡ mel kapⱡa. Amp wendʉp kʉⱡ, rumbuldi en enim nga lam kiya mbʉ kandʉk mek, amp tʉmba wu ei, nombuⱡa rʉk ting tila kandʉp timin nʉk purung. ");
INSERT INTO med_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Amp wendʉp 10 kʉⱡ nga, amp 5 kat rundi kʉⱡ, wote amp 5 kat mong rui kʉⱡ. ");
INSERT INTO med_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Amp rundi kʉⱡ lam kiya kandʉk mek purung. Wote, lam kiya norum kopung ei nga, mat pendʉk kulk mek pi naprʉng. ");
INSERT INTO med_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wote, amp mong rui ni kʉⱡ, lam kiya norum kopung ei nga, mat pendʉk kulk mek purung. ");
INSERT INTO med_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Amp tʉmba wu ni, nondpa ui nawʉⱡnga, amp wendʉp ni kʉⱡ, nokundʉk molk, kui nʉk ur petʉng. ");
INSERT INTO med_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ni kʉn, ou rumbuldi wi ti omba, ‘Amp tʉmba wu ei, onum o! Nombuⱡa ila ok, kandʉk teing wʉiyo!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Wote, amp wendʉp 10 ni kʉⱡ, ur petʉng ei mel rut nʉk, lam kiya kandʉk mondrung nimbʉ, mek ping ei nga tʉk kun etʉng. ");
INSERT INTO med_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ei kʉn, amp rundi ni kʉⱡ ndi, mong rui ni kʉⱡ kundʉk nʉk mel, ‘Angmʉn kʉⱡ, tʉn nga lam kiya kʉⱡ kumʉnʉm ei ka! Enim nga kopung mat tʉn oi nduk ngʉng ka!’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Amp wendʉp mong rui ni kʉⱡ ndi, ‘Angmʉn kʉⱡ, enim kopung mat oi ndupʉn ngʉmʉn ndam, enim kep, tʉn kep pʉkʉ, kopung ei nga kapⱡa iti natʉmba. Ei kʉn, enim mel rarʉp manga tila puk, kopung mat rarʉp rok teing pʉi,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Amp rundi ni kʉⱡ, kokila kopung rarʉp ruing puⱡina mel, amp tʉmba wu ni, omba ekit urʉm. Amp wendʉp mong rui kʉⱡ, tʉk kun etʉk morung ni mel, amp tʉmba wu ni nga kng rʉng raⱡ koindʉk tʉk, kun etʉk morung manga nila kunda murʉk puⱡnga, manga kumba ni angʉndpa gi ndurum. ");
INSERT INTO med_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wote, amp wendʉp rundi ni kʉⱡ, akil tek ok nʉk mel, ‘Nuim ei! Nuim ei! Tʉn kumba tana, murʉk imʉn ka!’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ni kʉn, amp tʉmba wu ei ndi, ik punt ropa nimba mel, ‘Na ik kupa ei nʉnt. Enim amp namin kʉⱡ, enim na pili napʉt ei ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas ndi, ik kʉⱡ nimba pora ndumba, etpa ei mel nitim, “Na yant uimp ei, rumbʉⱡ ila muna, rʉnggilmʉ muna, ant mong nant tila uimp. Ei nambuⱡ emel, enim pili nʉpiling ei nga, tʉk mendʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Wote, ui ei kʉn, Got nga muⱡ ila wamp tʉpa mumuk romba uⱡ ei, ya ei mel, wu ti kona ruⱡ tila mba pilpa, elim nga kongun wu mbʉ tʉpa, elim nga kng mel tetʉm mbʉ, elpa elpa rʉp etʉk muⱡʉi nitim. ");
INSERT INTO med_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wu mbʉ nga ronduⱡ ei mel ku pilpa, ku moni kʉmp tʉpa, elpa elpa ngurum. Wu ti, ku moni K5000 ngumba, wu ti ku moni K2000 ngumba, wu ti ku moni K1000 ngurum. Ngumba pendpa, elim kona roⱡ nila purum. ");
INSERT INTO med_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ku moni K5000 tʉtʉm wu ni ndi, mepa int mba kongun etpa, ropa oⱡa mana etpa, ku K5000 pendpa yant tʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wote, ku moni K2000 tʉtʉm wu ni ndi, ei mel ku etpa, moni K2000 oⱡa ndupa pendpa tʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wote, ku moni K1000 tʉtʉm kongun wu ni ndi, elim nga nuim ei nga ku moni kʉⱡ mepa mba, mʉi ila kut akpa oⱡʉm ropa pinditim. ");
INSERT INTO med_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wote, ui mat ruⱡ etpa kongun wu kʉⱡ nga, wu nuim ei yant omba, elim nga ku ngur nimbʉ, etʉk tek mormin mel kʉnimp nitim. ");
INSERT INTO med_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ku moni K5000 tʉtʉm wu ni ndi, yant omba kont nga K5000 pendpa ngurum. Ngumba nimba mel, ‘Nuim ye! Nim na ku K5000 ngurun ni, wote na ndi, rop oⱡa mana etʉp mep andʉp, K5000 kʉⱡ pendʉp ngont,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Wote, wu nuim ni ndi, punt ropa nimba mel, ‘Pʉp nʉn, nim kongun wu koip pi ye! Nim ku moni onunga kuraⱡ ila, ronduⱡ pukʉn etkʉn ou ndun kant ei kʉn, na nga ku moni ou ndupa tetʉm mbʉ rʉp indʉn. Na nim nga nuim ei, akup kai pʉnt ei kʉn, nim murʉk wana ambʉⱡʉp paⱡʉp muⱡʉmbil ui!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ei kʉn, ku K2000 tʉtʉm wu ni ndi, omba nimba mel, ‘Nuim ei! Nim na ku K2000 ngurun ni, wote na ndi, kongun etʉp mep andʉp, K2000 kʉⱡ ya pendʉp ngont,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Wote, wu nuim ni ndi, punt ropa nimba mel, ‘Pup nʉn, nim wu koip pi ye! Nim ku moni onunga kuraⱡ ila, ronduⱡ pukʉn, etkʉn ou ndun in kant ei kʉn, na nga ku moni ou ndupa etpa tetʉm mbʉ rʉp itʉn. Na nim nga Nuim ei, akup kai pʉnt ei kʉn, nim murʉk wana, ambʉⱡʉp paⱡʉp muⱡʉmbil ui!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Wote, akil tepa ku moni K1000 tʉtʉm wu ni ndi, omba nimba mel, ‘Nuim ei, nim wu ik pili napilikʉn, rʉng rʉⱡi nakʉrʉn pana ila kun polkʉn tʉkʉn, rʉng mong mundi nʉmʉndrʉn mbʉ, kun mekʉn etʉn. ");
INSERT INTO med_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ni nga, na pilip mundmong etʉp, nim nga ku moni ngurun ni kʉⱡ, mep mbo mʉi ila mo rop pindʉt. Ei mel, akup nim nga ku moni kʉⱡ, ninim mep omp ngont,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","“Wote, wu nuim ni ndi, nimba int ndupa, ‘Nim kongun wu kit, enʉmp mundi ye! Na rʉng rʉⱡi narʉr pana ila kun poⱡʉp tʉp, wote rʉng mong mundi namʉndʉr mbʉ, kun mep et ni kʉn pitim ndam, wote na nga ku moni kʉⱡ mek pukʉn, ku manga ila tiyana, akup nanim yant unt ei kʉn, ku moni kat mbʉⱡ ila tindangina, pendʉp tilmba,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Wote, wu nuim ei ndi, kongun wu kat kundpa nimba mel, ‘Ku moni kʉⱡ tʉk wu ti, moni K10000 ngum wu ni ngʉi! ");
INSERT INTO med_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nambuⱡ emel, wamp nam ti ndi, mel ou ndupa tepa moⱡum ila mbʉⱡ ila mel ou ndupa ngangga, ama minal tʉmba. Wote wamp nam ti, mel onunga etpa tepa moⱡum ni kʉⱡ, yant tʉpa mel ou ndupa tepa moⱡum wamp ni ngumba. Wote, wamp nam ti, mel onunga etpa tepa moⱡum kʉⱡ, kelpa ekit tʉmba. ");
INSERT INTO med_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wote, ya kongun wu enʉmp mundi ei, kona rumbʉⱡ mul ila rok pena ndʉi, kona ila ka etpa, gu konggilpa, gʉkʉr tʉpa moⱡmba!’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wote, Muⱡʉl Wu Kupa ei, Wu Nuim Mumuk moⱡpa om ei kʉn, muⱡ ila anggelo mbʉ kunda uing. Wote, ui ei kʉn, elim king rʉpndi pol ila moⱡmba. ");
INSERT INTO med_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wote, ei kʉn, mana mʉi kona wamp mbʉ pora, elim nga kuimp keta ila tʉk tenda iting. Ei kʉn, wamp mbʉ, kng sipsip rʉp wu ti ndi, kng sipsip mbʉ, tʉpa tila mondpa, meme mbʉ, tʉpa tila mondpa etʉm ni mel etmba. ");
INSERT INTO med_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Elim ndi, kng sipsip mbʉ tʉpa, elim nga ki mbo orunga mondpa, wote kng meme mbʉ tʉpa, ki rar orunga mondʉmba. ");
INSERT INTO med_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Wote, Wu Nuim Mumuk ei ndi, elim nga ki mbo orunga moⱡʉng wamp mbʉ kundpa nimba mel, ‘Enim na nga wuta ndi, memp pinditim wamp mbʉ, enim nga tʉpa mumuk rui kona ei muⱡ mʉi raⱡ wengʉndupa itim ei kʉn, koⱡ nondpa tʉndʉtʉm kona ila ok, muⱡʉi nimba. ");
INSERT INTO med_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","36","Nambuⱡ emel, na kun ndi, koⱡmba kandʉk, rʉng ngurung. Nu waka ndi, koⱡmba kandʉk, nu kolk ngorung. Manga tʉma oⱡʉmba, rawe etʉk tʉtʉng, giyu gou andʉⱡʉmba kandʉk, wal pʉki na mat tʉk randrʉng. Na kui roⱡnga pilmba ok, kuimp keta minal etʉng, kan manga ila pilmba ok kandrung,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","“Wote, wamp kun kai mbʉ ndi, nʉk int nduk, ‘Nuim ei, nim ni ui nant kʉn, kun ndi koⱡnga kandpʉn, rʉng ngurmin? Muna nant kʉn, nu waka koⱡnga kandpʉn, nu kuⱡʉp ngurmin? Muna nant kʉn manga tʉma oⱡina kandpʉn, rawe etʉp tʉtmʉn? Muna nant kʉn, giyu gou andilnga kandpʉn, wal pʉki mat tʉp rundʉrmʉn? Nim ni nant kʉn, kui rʉrʉm, muna kan manga ila pelinga kʉn, omp kʉndʉrmʉn ei nga nʉn?’ ning. ");
INSERT INTO med_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ei kʉn, Wu Nuim Mumuk ei ndi, punt ropa nimba mel, ‘Enim ik kupa ei, kundʉp nʉnt. Ya nʉnt uⱡ mbʉ mel wamp mbi mul nʉmbil, na nga ʉngʉnʉl mbʉ kʉn, etʉng uⱡ nimbʉ, na kʉn etʉng!’ ");
INSERT INTO med_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wote, ki rar orunga moⱡʉng wamp mbʉ kundpa nimba mel, ‘Enim Got nga mbun kit ei ndi, nomba wamp mbʉ, na nga kuimp keta ila kun etʉk muⱡʉi! Enim Seitan kʉn, elim nga anggelo mbʉ kʉn, ndip nomba mint pi kona tʉpa, kun endpa tʉtʉm kona ila pʉi! ");
INSERT INTO med_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","Na kun ndi, kur ei kandʉk, wote rʉng ngui nganggʉrʉng. Na nu waka kuⱡʉp mur ei kʉn, wote nu kolk ngui nganggʉrʉng. Na manga tʉma ur ei kʉn, wote rawe etʉk ti natʉtʉng. Na giyu gou ʉndʉr ei kandʉk, wote wal pʉki na ti, tʉk rundi nandrʉng. Na kui mang ila, muna kan mang ila pit ei kʉn ok, wote kʉni nakʉndrʉng,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wote, wamp mbʉ ndi, nʉk int nduk mel, ‘Nuim ye! Nim ni nant kʉn, kun ndi kolkʉn, nu waka kulkʉn, muna giyu gou molkʉn, kui manga ila kep, kan manga ila kep, pekʉn itin mbʉ kʉn, tʉp rʉpndi nʉpʉndʉrmʉn,’ ning. ");
INSERT INTO med_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Wote, Wu Nuim Mumuk ei ndi, punt ropa nimba mel, ‘Enim ik kupa ei, kundʉp nʉnt. Ya nʉnt uⱡ mbʉ mel, wamp mbi mul nʉmbil mbʉ kʉn, etʉng uⱡ nimbʉ, na kʉn etʉng,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ei kʉn, wamp mbʉ tʉpa ndip kona ila mundʉmba, wote wamp kun kai mbʉ tʉpa uⱡ nga kʉnt nga kont uⱡ ei ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Wote, Jisas ndi, ik mbʉ mel mbo endpa pora ndupa kʉn, elim nga kitip kʉni wu mbʉ kundpa nimba mel, “Enim pilik mormin rumbʉⱡ raⱡ omba pangga! Pasopa rʉng normin ui ei om kʉn, na Muⱡʉl Muⱡʉl Wu Kupa ei tʉk mek puk, el rui wu mbʉ ngangina, nde peta ila rok kunding,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","“Ui ei kʉn, wu pris kuimbal na, manga wingti rʉp wu na mbʉ ndi puk, wu Pris kʉⱡ nga peng mumuk wu Kaiyapas nga manga ila, tʉk tenda etʉk morung. ");
INSERT INTO med_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ni kʉn, wamp nimbʉ tʉp kum ngui randpʉn, Jisas ni, rop kundmin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ni wote, en enmin ndi, nʉk mel, “Pasopa rʉng nuing ui ei kʉn, pendʉp kilʉmin. Ei mel, imʉn ndam, ui mam ila wamp mbʉ, el pundung ei mon,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jisas ni, noi Betani kona ila pombuⱡma rorum wu Saimon ni nga manga ila murʉk mba moⱡnga, amp ti ndi, Jisas murum nila, kopung mura rui ti mepa omba, Jisas nga peng ila, kopung oi ndurum. ");
INSERT INTO med_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wote, elim nga kitip kʉni wu ni kʉⱡ ndi, amp ei, itim uⱡ ni kandʉk, popʉⱡ kulk nʉk mel, “Kopung mura rui kai ei, nambuⱡ emel etpa ge ndonʉm nda? ");
INSERT INTO med_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kopung kai ei, rarʉp ropʉn ku moni tʉpʉn, wamp kurpa mbʉ ngoⱡum, muna ant ko!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas ndi, wu kʉⱡ nʉtʉng ik ni pilpa, int ndupa nimba mel, “Nambuⱡ emel, amp ei, ik ngonmin? Amp ei ndi, na kʉn uⱡ kai ti enim. ");
INSERT INTO med_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ei nambuⱡ emel, wamp kurpa mbʉ, pila kana ui mbila, enim kʉn rʉk rʉk muⱡing. Wote, na enim kʉn rʉk rʉk muⱡi nʉmbʉⱡimp. ");
INSERT INTO med_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Amp ei ndi, enim uⱡ ni, na nga kʉng kʉⱡ tʉk mek puk on iting ei nga, tʉpa kun endpa, kopung kandnim. ");
INSERT INTO med_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Enim ik kupa ei, kundʉp nʉnt. Kona nant mbila, Rʉnang Ik Kai mbʉ nʉk ngʉng ila, amp ei ya na kʉn, uⱡ enim ei nga timan rok nguing ku,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Ei kʉn, kitip kʉni wu 12 ni kʉⱡ nga, Juras Iskariyot wu ni ndi, mba wu pris kʉⱡ nga wu kuimbal ni, waldpa nimba mel, “Na ndi, Jisas ni wu ei, rʉk moⱡʉp mep omp enim ngʉnt ndam, na namba mel ei nguing?” nitim. Wote, wu ni kʉⱡ ndi, ku moni kum raldika, Juras ngorung. ");
INSERT INTO med_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ku moni kʉⱡ, tʉpa pendpa kʉn, Jisas ruk moⱡmba ei nga ui kai ti nokʉndrʉm. ");
INSERT INTO med_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret yis mundi namʉndʉk normin ui ei nga ui, puⱡ mondpa ila, Jisas elim nga kitip kʉni wu kʉⱡ ndi ok, Jisas waldʉk nʉk mel, “Pasopa ui ei nga rʉng mbʉ, nant ila tʉp kun etpʉn muⱡamina, ok nuin?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wote Jisas ndi, punt ropa nimba mel, “Kona peng ila puk, wu ti ni nga manga ila puk, i nʉi, ‘Ik mbo wu ei ndi, ei mel nʉnʉm. Na nga ui ei omba, nondpa enim, Pasopa ui ei nga rʉng ei, nim nga manga ila, na nga kitip kʉni wu mbʉ kʉn omp nuimʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ei kʉn, kitip kʉni wu ni kʉⱡ ndi, Jisas nitim ni mel, puk manga ila, rʉng mbʉ kalk tʉk kun etʉk morung. ");
INSERT INTO med_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kona rumbʉⱡ puⱡnga, Jisas kʉn elim nga kitip kʉni wu nimbʉ kʉn molk, Pasopa rʉng norung. ");
INSERT INTO med_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Rʉng nok moⱡina, Jisas ndi, nimba mel, “Enim ik kupa ei kundʉp nʉnt. Enim mormin wu kʉⱡ nga ti ndi, na ruk moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kitip kʉni wu ni kʉⱡ, ik ni pilik, munt mindil tʉk, elpa elpa Jisas waldʉk nʉk mel, “Nuim ye! Ei nam nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas ndi, punt ropa nimba mel, “Na kʉn tʉngʉnda nu ming ila, bret nu mondpʉⱡ numbʉⱡ wu ei ndi, na ruk moⱡmba. ");
INSERT INTO med_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Muⱡʉl Wu Kupa ei, rʉnang ik ila, koⱡmba nʉk, mon rok pendʉtʉng ei mel ku koⱡmba. Wote, wu nam ti, Muⱡʉl Wu Kupa ei, rʉk moⱡmba ei nga, na kont mam ti enim! Wu ei mam ndi, mei nambil nga ndam, kapⱡa elinga!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juras ruk murum wu ni ndi kundpa nimba mel, “Ik mbo wu ye! Ei na nanim nʉmp pʉnt ei?” nitim. I nilinga, Jisas ndi, punt ropa nimba mel, “Int ninim nʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Rʉng nok moⱡina, Jisas ndi, bret ti tʉpa, Got kʉn angge nimba kʉn, pok ropa, kitip kʉni wu ni kʉⱡ ngumba nimba mel, “Tʉk nʉi! Ya ei, na nga kʉng elim ei,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Wote, nu wain ming ni, i ku etpa tʉpa, Got kʉn angge nimba, wu kʉⱡ ngumba nimba mel, “Nu ei, kump kʉm tʉk nʉi! Ya ei, na nga mema oi ndont ei ndi, wamp minal nga uⱡ kit mbʉ pendpa kilmba. Wote, Got nga wamp tʉpa, tenda iti uⱡ kont ei, etpa ronduⱡ mundʉmba. ");
INSERT INTO med_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Enim ik ti kundʉp namp, na ya nonmʉn nu wain ei, wote aldpa nui nʉnimp. Wote, ui tila, enim kʉn pʉkʉ nuimʉn ei, na nga Wuta nga muⱡ ila, tʉpa mumuk rui kona ila, tʉp tenda imʉn ui ei kʉn, wain kont paka nuimin,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wote, kinan kat nʉk pendʉk pena ok, Olip Komnga ila purung. ");
INSERT INTO med_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wote Jisas ndi, wu kʉⱡ kundpa nimba mel, “Akup rumbuldi, enim pʉkʉ, na wak rok mondʉk, kelik nung nʉk ping. Ei, Got nga ik ti petʉm ei ndi, nimba mel, ‘Na ndi, sipsip rʉp wu ei, rop kundamba, kng sipsip mbʉ, mbuⱡ mbaⱡ ning,’ nʉtʉm ");
INSERT INTO med_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wote, na ropa rut ndangga, kont munt ei kʉn, enim Galili pi nʉpi, na unt mbo muⱡimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ni kʉn, Pita ndi, Jisas kundpa nimba mel, “Wu wei mbʉ ndi, nim wak rok kelik pung ndam, na nim wak rui nʉrimp!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas ndi, Pita kundpa nimba mel, “Nim ik kupa ei, kundʉp nʉnt. Akup rumbuldi mendpʉⱡ, kʉi kulda rui nʉri, na pili napʉt nʉkʉn, raldika indin,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita ndi, punt ropa nimba mel, “Na nim kʉn pendʉk, rok kondung ndam kep, nim pili napʉt, ni nʉnimp,” nitim. Wote, kitip kʉni wu mat ndi, i ku etʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wote, Jisas kʉn elim nga kitip kʉni wu kʉⱡ kʉn, kona ti mbi tek Getsemani nʉtmin kona ila purung. Jisas wu kʉⱡ kundpa nimba mel, “Enim ila muⱡʉi! Na merʉng ila mbo atinga ramp,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Elim mba etpa, wu Pita kʉn, anda Sepeti kangʉm Jeims, Jon raⱡ tʉpa mepa purum. Ni kʉn, elim ni, munt mindil tʉpa mbun ndi kurʉm. ");
INSERT INTO med_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wote, wu ni kʉⱡ, kundpa nimba mel, “Na nga mundmong ei, ama mbun ndi konum. Ei kʉn, enim ur pi napʉk, nokundʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I nimba pendpa, onunga kot wuldʉng mba, mura ropa, mʉi ila rumaⱡi pepa, atinga ropa nimba mel, “Na nga Wuta ye! Nim ndi, kapⱡa nʉkʉn pin ndam, ya nu ming mel, mindil nuimp ming nu morum ei, tʉkʉn mundi! Ei na nga pint ei mel mon. Ninim pin ei mel itiyo!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wote, yant omba kʉndrʉm mel, kitip kʉni wu raldika ni kʉⱡ, ur pi napilik petʉng. Wote Jisas ndi, Pita kundpa nimba mel, “Enim wu raldika kʉⱡ ndi, ant mong na tenda kot kep, na nga nʉndʉk rut nʉk muⱡi nambʉⱡʉng ei ka! Etpa em mel nant? ");
INSERT INTO med_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Enim oⱡa tʉpa, kʉni uⱡ mbila, ropa mana ndumba ei nga, tʉk mendʉk atinga rok muⱡʉi! Muⱡnga ei ndi, numan ngonum. Ei wote, kʉng kʉⱡ ndi, enʉmp monum,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nimba pendpa, aldpa mba atinga ropa nimba mel, “Na nga Wuta ye! Nu ming mel ya, mindil nuimp ming ei, tʉk mundi nʉmʉndʉn! Na nʉnt ei kʉn mint, nim nga numan pʉtʉn uⱡ ei, peng pemba,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wote, yant omba kundrum mel, kitip kʉni wu ni kʉⱡ, ur petʉng. Ei nambuⱡ emel, wu kʉⱡ nga mong mbʉ, ur ndi titim. ");
INSERT INTO med_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aldpa wu ni kʉⱡ, mondpa kelpa int mba, unt nitim ik ni kʉⱡ ku nimba, atinga roⱡnga raldika itim. ");
INSERT INTO med_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wote yant omba, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Enim muⱡ tʉk, ur ku pek mormʉn ei? Kʉnʉiya! Muⱡʉl Muⱡʉl Wu Kupa ei, tʉk pok punt uⱡ kit etmin wu mbʉ nga ki ila tʉnding. Ei nga, ui ei nondpa enim. ");
INSERT INTO med_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Oⱡa muⱡangina, kelip pamin! Na ruk moⱡmba wu ei, unt ya onum ei kanmin mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas ik nimba moⱡnga, kitip kʉni wu kʉⱡ nga Juras ni, wu ei urum. Wote urum ila, wamp minal wu peng mumuk na, manga wingti rʉp wu na mbʉ kʉn, rʉp rok, tʉmbʉⱡ na, koiya na mat, kapⱡa etʉk ambulk mek orung. ");
INSERT INTO med_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ruk murum wu ni ndi, wamp orung nimbʉ nimba, ndoimp rondpa, “Na mbo keta nu rop nunt wu ei kandʉk, wu aⱡʉm ei, nʉk puk imp muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nitim ni mel, Juras kun mba Jisas keta nu ropa nomba ei mel nitim, “Ik mbo wu ye! Nim ila morʉn kant ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas ndi, punt ropa nimba mel, “Nim itʉn pilkʉn un uⱡ ei mel, tʉkʉrkʉn eta!” nitim. Wote, wu nimbʉ ok, Jisas ni tʉk imp morung. ");
INSERT INTO med_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ni kʉn, Jisas kunda morung wu ni kʉⱡ nga ti ndi, elim nga koiya ni, ekit tʉpa, wu pris peng mumuk ei nga kindmant wu ti, urum ni nga kum ei, ropa puⱡa rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wote Jisas ndi, wu ni kundpa nimba mel, “Nim nga koiya ei, elim nga petʉm kona ila, int nduk pindi! Wamp nam ti, koiya ambʉⱡʉm wamp ei, koiya ei ndi ku, elim nomba. ");
INSERT INTO med_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na nga Wuta ei ndi, na tʉpa rʉpʉndangga nʉmp, mawa el mba ndam, tʉngʉnda mint anggelo wu ei, kum 12 mel tʉpa munduⱡnga, ei pʉn muna mon? ");
INSERT INTO med_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wote Got ndi, na tʉpa rʉpʉndangga nilmba ndam, Got nga ik mong ti ndi, uⱡ enim ei mel itangga, nʉtʉm ik ei omba, ik kupa tʉmba mel nant?” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","I nimba kʉn, wote wamp morung nimbʉ, kundpa nimba mel, “Enim wu kʉⱡ ndi, na punt mong wu na ni mel, na imp muⱡmʉn nʉk, koiya na, tʉmbʉⱡ mel mbʉ mek onmʉn ei? Na manga wingti ila, Got nga ik ei, rʉk rʉk wamp mbʉ mbo endʉp mor ei kʉn, tʉk imp muⱡi nambʉrmʉn ni ka? ");
INSERT INTO med_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wote, uⱡ pʉnʉm kʉⱡ ndi, Got nga ik ti, painui wu kʉⱡ ndi, unt mon rorung ik ei, etpa kupa pendʉm,” nitim. Ni kʉn, kitip kʉni wu nimbʉ, elim wak rok, mundmong etʉk, nung nʉk purung. ");
INSERT INTO med_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisas puk imp morung wu nimbʉ ndi, Jisas mek puk, pris kuimbal murum wu Kaiyapas kʉn, mi ik mbo wu na, manga wingti rʉp wu na mbʉ, tʉk tenda etʉk, morung manga ila mek purung. ");
INSERT INTO med_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita ni, wu kʉⱡ purung ni mel, ruⱡ etpa pep ropa mba, wu pris kuimbal ei nga mang keta ila purum. Kona ila moⱡpa, Jisas ni etʉk enmin mel nant nimba, el nde wu kat, kona rʉp etmin ni kʉⱡ kʉn, mba murum. ");
INSERT INTO med_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ni kʉn, wu pris kuimbal na, wote manga wingti rʉp wu na nimbʉ ndi pʉkʉ, uⱡ ⱡawa nant ila, nʉmp oⱡa ndupʉn, Jisas ruimin nda nʉk, ol tek nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Wote, ⱡawa ti kandʉk ti natʉtʉng. Wote, wamp minal ok, ik kep nok nʉtʉng ik nimbʉ, kupa iti nʉtʉtʉm. Ei kʉn, wu ralt okʉⱡ, ei mel nʉtʉnggil, “Ya wu ei ndi, nimba mel, ‘Got nga manga wingti ou ei, rok tʉp mana tʉp, wote rumbʉⱡ raldika ila, rʉkimp nʉm,’” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wu pris kuimbal ni anggilpa, Jisas kundpa nimba mel, “Nim kʉn ik ninmin ei nga ik na ti kep, punt ruin muna mon ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wote, Jisas ni, ik ti ni nandpa, pilpa kui itim. Aldpa, wu pris kuimbal ni ndi, ronduⱡ mundpa, Jisas waldpa nimba mel, “Got kont morum ei nga mbi ila, mi ambʉⱡʉp nʉnt. Ei kʉn, nim wu Kraist, Got nga kangʉm ei kupa muna mon?” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wote, Jisas ndi, punt ropa nimba mel, “Ik ei int nim nʉn ei ka! Wote, ik ti enim wamp pora kundʉp namp. Akup mormʉn ui ei nga mba, wote ui tila, na Muⱡʉl Wu Kupa ei, Got wu ronduⱡ pi ei nga, ki mbo orunga moⱡʉp, muⱡ kona kopa pol ila wamba, kʉning!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ei mel nilinga, wu pris kuimbal ni ndi, elim nga wal pʉki ni kʉⱡ ambuⱡpa, rung ndupa, nimba mel, “Got kʉn ik nimba kit mondnʉm! Aldpa ik mat, kombʉⱡʉp ni nʉnamin! Got kʉn ik nimba, kit mondnʉm ik ei, enim pora pʉnmin ni ka! ");
INSERT INTO med_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ei kʉn, akup enim namba nʉk pʉnmin?” nitim. Wote, wu kat ndi, ik punt rok nʉk mel, “Elim nga ⱡawa ila, elim kuⱡangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","I nʉk kʉn, Jisas nga kuimp keta ila ol rok, wote ki kum ndi rorung ku. Wu mat ndi, ki ⱡurwa ndi rok, kundʉk nʉk mel, “Kraist ni, nim painui wu ti ndam, wamp nam ndi, nim ronum ei mbi tekʉn ni,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ni, wu pris kuimbal ei nga mang keta ila murum. Ei kʉn, wu pris kuimbal ei nga kongun amp ti ndi omba, Pita kundpa nimba mel, “Nim Galili wu, Jisas ei kʉn kunda andʉrmʉn, kandʉr ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wote Pita ndi, wamp kona ila morung nimbʉ mondpa, kulkʉⱡ ropa nimba mel, “Nim nʉn ik ei, na pili napʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wote, i nimba pendpa, mang keta nila omba ekit purum. Wote ila, kongun amp ti ndi, kandpa mbi ndupa nimba mel, “Wu ei, Nasaret wu Jisas kʉn, kunda andrʉnggil ndi ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wote, aldpa Pita ndi, kulkʉⱡ ropa nimba mel, “Wu ninmin ei, na pili napʉnt ei ka,” nitim. ");
INSERT INTO med_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ei kʉn, nondpa mel ku, wu kat ila morung kʉⱡ ndi ok, Pita kandʉk nʉk mel, “Nim wu kʉⱡ nga ti ku kanmin ei, nim nga ik nʉn, nuim kan ei, pilip ninmin ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","75","Wote Pita ndi, nimba mel, “Na mi tep, ik kupa ei nʉnt! Na wu ei, pi napʉnt nʉnt. Muna na wu ei, etʉp pʉt ndam, Got ndi, na mbun ti ngangga!” nitim. Ei kʉn mint, kʉi kulda ti, wi roⱡnga, Jisas ndi, unt Pita kundpa nitim ik ni kʉⱡ, omba rundrum, “Kʉi kulda wi ropa, raldika indi nʉndi kʉn, nim ndi, na pili napʉt nʉkʉn kulkʉⱡ rokʉn, raldika indin,” nitim. Ni kʉn, manga keta ni, wak ropa ekit mba, ka rom kʉk kʉk nimba rurum. ");
INSERT INTO med_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Ipri unt, wu pris kuimbal na, manga wingti rʉp wu na mbʉ ndi, Jisas rok kunding ei mel kanggʉp ambrung. Wote, ki raⱡ tʉk, kan ngʉk mek puk, Rom Gapman ei nga wu kuimbal murum Pailot wu ei, nguing pilik, mek purung. ");
INSERT INTO med_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisas ruk murum wu Juras ndi, moⱡpa kʉndrʉm mel, Jisas ni, tʉk mong ngurung. Uⱡ ni kandpa, elim numan ropʉl ropa, ku moni silpa K30 ni kʉⱡ mepa mba, wu pris kuimbal kʉⱡ kʉn, manga wingti rʉp etmin wu mbʉ kʉn, int ndupa ngurum. ");
INSERT INTO med_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ngumba nimba mel, “Na ndi, etʉp ⱡawa mundʉp, mong ti natʉm wu ti nga, ruk moⱡmba, akup rok kunding pilik nʉnmʉn kant ei ka!” nitim. Wote, wu ni kʉⱡ ndi, punt rok nʉk mel, “Uⱡ ei nga puⱡ ti, tʉn kʉn pi napʉtʉm ei, nim nga uⱡ ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wote Juras ni, ku moni ni kʉⱡ tʉpa, manga wingti ila ropa murʉk ndupa, elim ni mba, nuim nga nurum. ");
INSERT INTO med_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wu pris kuimbal ni kʉⱡ ndi, ku moni ni kʉⱡ, aprʉk oⱡa tʉk, nʉk mel, “Wamp mema oi nim ku moni kʉⱡ tʉpʉn, manga wingti ei nga, moni tetmin kona ila, timin mel kapⱡa mon. Moses nga mi ik ei ndi, mon nʉtʉm uⱡ ei mel pep ruimin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wote ol tek, ik nʉk tenda mundʉk, ku moni kʉⱡ ndi, mek puk, mʉi ming mim etʉm wu ti nga kona kuta ti, ei rarʉp rorung. Kona ila wamp tʉma mat ok, Jura kona ila koⱡung mbʉ, ʉngʉndmin nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ui ila, yant ndupa omba, akup ui ei kʉn, kona ei akup mbi tek, “Wamp mema kona,” nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ei kʉn, painui wu Jerimaiya nga ik ei mel nitim ei, omba kupa itim, “Ku moni K30 silpa kʉⱡ, Isrel wamp mbʉ ndi, wu ei rarʉp rʉmin nʉtʉng ei mel, ku moni kʉⱡ ndi, mek puk mʉi ming mim etʉm wu ei nga, kona keta ei, rarʉp rorung. Ei na, Oⱡa Nuim ei ndi, na kundpa nitim ei mel nʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas ni mek puk, wu nuim Pailot nga kuimp keta ila monduⱡnga, wu ei ndi waldpa nimba mel, “Nim Jura wamp mbʉ nga Wu Nuim Mumuk ei?” nitim. Wote Jisas ndi, punt ropa nimba mel, “Int nim nun ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wote, wu pris kʉⱡ nga wu kuimbal na, manga wingti rup wu na mbʉ ndi, kai kandʉk, elim kʉn ik nʉtʉng mbila ik na ti kep, punt ropa ni nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ei kʉn, wu Pailot ei ndi, elim kundpa nimba mel, “Nim kʉn kai kandʉk, ik nʉnmʉn mbʉ, pʉn muna mon?” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wote Jisas ndi, ik na ti, punt ropa ni nʉndʉtʉm ila, Rom Gapman nga wu nuim ni ndi, kandpa min ngʉn mundrum. ");
INSERT INTO med_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jura kangambuⱡa kumna mbʉ, Got ndi, poⱡ titim ui ekit orum ei kʉn, Rom gapman nga wu nuim ei ndi, wu mat kan manga ila petʉng mbʉ nga ti, ku nimba, wamp mbʉ numan ngurung ei mel, wak ropa mundrum. ");
INSERT INTO med_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ui ei kʉn, punt mong wu ti, mbi tek Barapas ni, ei kan manga ila pitim. ");
INSERT INTO med_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wamp minal ok, tʉk tenda etʉng ni kʉn, Pailot ndi, waldpa nimba mel, “Enim ndi, wu nant ei, wak ramp nʉk pʉnmin? Barapas muna, Jisas ni, wu mbi tek, Kraist nʉtmin ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ik ei mel nitim ei, nambuⱡ emel, Jura wamp kʉⱡ en enmin ndi, wu ei nga nitim uⱡ mbila, wʉlʉk rok kʉn, Jisas mek ok, elim ngurung ei, pilpa kelpa wuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailot ni, elim nga nde pol kot pʉtʉm kona nila, moⱡnga mel, ambʉm ndi, rung mundpa, “Wu nit mul nʉmbil ei kʉn, uⱡ ti itimp nʉkʉn, iti nʉti! Ei nambuⱡ emel, na wu ei nga ur kump kat etʉp, kunt ila mindil mam ti, nunt ndi ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ni kʉn, wu pris mbʉ nga wu kuimbal mbʉ kʉn, manga wingti rʉp wu na mbʉ ndi, wamp mbʉ kunt rok, Pailot wuldangina, “Barapas wak ropa mundpa, Jisas ropa kundangga, nʉi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wote Pailot ndi, wamp mbʉ waldpa nimba mel, “Ya wu raⱡ nga wu nant ei, wak rop mundamp, nʉk pʉnmin?” nitim. Ni kʉn, wamp mbʉ ndi, waldʉk nʉk mel, “Barapas,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wote Pailot ndi, wamp mbʉ, waldpa nimba mel, “Wote Jisas ni, wu Mesaiya nʉtmin ei, nambuⱡ ti etamp nʉk pʉnmin?” nitim. Ni kʉn, wamp mbʉ ndi, wi rok nʉk mel, “Nde peta ila pendkʉn rui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wote Pailot ndi, wamp mbʉ, waldpa nimba mel, “Wu ei, namba ⱡawa ti em?” nitim. Ni kʉn, wamp mbʉ ndi, kei nʉk, “Nde peta ila rui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wote Pailot ndi, ik merʉng ti, nʉmp mep punt ndam, kona mong pemba kant ei ka nimba. Wamp mbʉ morung kuimp keta ila, elim nga ki ni raⱡ, nu ila ⱡumʉiya ropa, nimba mel, “Wu ruing ei nga nit ei, na kʉn pi napʉmba mon. Ei enim nga uⱡ ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wamp nimbʉ ndi, ik punt rok nʉk mel, “Wu ei nga mema ei ndi, tʉn kʉn, tʉn nga kangambuⱡa mep timin mbʉ kʉn, ⱡang etpa tangga,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ei kʉn, Pailot ndi, Barapas ni, wak ropa mundpa, wote Jisas ni, kan puⱡa ndi rok, mek puk, nde peta ila rʉi nimba, wamp nimbʉ ngurum. ");
INSERT INTO med_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wote, wu Pailot nga el nde wu nimbʉ ndi, Jisas ni mek puk, Pailot elim moⱡpa, kongun etʉm manga mam ila murʉk puⱡnga, el nde wu mbʉ ndi, Jisas ni tʉk paⱡa etʉng. ");
INSERT INTO med_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kona ila moⱡnga, Jisas nga rʉrʉm mel nimbʉ, ambulk rung nduk mundʉk, el nde wu kʉⱡ nga wal pʉki kunt, roⱡ kat pakʉrmin kʉⱡ nga pakʉndrʉng. ");
INSERT INTO med_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wote, kan goimbun rong kat mʉkʉp rok, Jisas nga peng ila mondʉk, tʉmbʉⱡ ti tʉk, ki ila amʉndrʉng. I etʉk mondʉk, Jisas tʉk ik kuldʉk, kuimp keta ila, mura koptʉm rok, rumaⱡi pek nʉk mel, “Jura wamp nga wu king ei moⱡpa, ruⱡ pangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wote, kuimp keta na mbila, ol rok kandʉk, tʉmbʉⱡ mbʉ ndi, oⱡa tʉk, Jisas nga peng ila rorung. ");
INSERT INTO med_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wote, Jisas ni tʉk, ik kuldʉk uⱡ mbʉ mel etʉk pendʉk kʉn, wal pʉki kunt, ruⱡ kat pakʉndrʉng ni kʉⱡ, potʉk mundʉk, el elim nga rʉrʉm mel nimbʉ, randʉk pendʉk mek puk, nde peta ila ruing pilik mek purung. ");
INSERT INTO med_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kona peng ni, wak rok, ekit ping pilik purung ila, Sairin kona peng ila wu ti, mbi tek, Saimon nʉtmʉn ni urum. Ei kʉn, el nde wu kʉⱡ ndi, Jisas nga nde peta ei, tʉk mindi nilingina, mindʉtʉm. ");
INSERT INTO med_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wote ok, kona ti mbi tek, Golgata nʉtmin nila orung. Kona mbi ei nga puⱡ ei, “Wamp peng ombil kona.” ");
INSERT INTO med_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kona ila, el nde wu mbʉ ndi, nu wain kʉn, nu kombila iti mat, nu wain ila mundʉk, Jisas nangga nʉk, ngurung ni nomba pitim ei, kombila elinga, nui nʉndrʉm. ");
INSERT INTO med_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wote, Jisas ni tʉk, nde peta ila rok pendʉk, rʉrʉm mel nimbʉ, ambulk rung nduk, nam tʉmba nda, nʉk kat rorung. ");
INSERT INTO med_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wote, i etʉk molk kʉn, Jisas nde peta ila pitim ei, rʉp etʉk morung. ");
INSERT INTO med_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nde peta ei nga peng ila, Jisas tʉk, ik kuldʉk nʉtʉng ik ni kʉⱡ, mbi rok pendʉtʉng. Ik ei mel nimba murum, “YA WU EI JISAS, JURA WAMP MBɄ NGA WU NUIM MUMUK EI.” ");
INSERT INTO med_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wote ei kʉn ku, kindʉp wu ralt, Jisas nde peta ila rorung kona ila, i ku etʉk, ki mbo orunga wu ti rok, ti ki rar orunga rok pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Wamp nombuⱡa mam ila ok, purung mbʉ ndi, peng walinga rok Jisas ik mura nguk nʉk mel, “Nim manga wingti ei rokʉrkʉn, wote rumbʉⱡ raldika omba pangga, wote rʉk imp nitin wu ni ka! Akup ninim etkʉn, peng kont ta! Nim Got nga kangʉm ndam, nde peta ei, wak rokʉn, mana ui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","I nʉtʉng ei mel ku, wu pris kuimbal na, mi ik mbo wu na, manga wingti rʉp wu na mbʉ ndi, i ku etʉk tʉk, ik kuldʉk nʉk mel, “Wu ei, wamp wei mbʉ etpa, peng kont tʉm ni! Wote, el elim etpa, peng kont ti natʉnʉm ei, kanmin mon! Elim Isrel wamp mbʉ nga wu nuim mumuk ni muna? Elim akup nde peta ei, wak ropa mana om ndam, elim mondʉp pilimin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Elim Got nga kangʉm mor. Wote elim Got mondʉp pilip mor nitim ndi, akup Got ndi, elim etpa, peng kont tʉmba ei nga kinamin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wote, kindʉp wu ralt pendʉk rorung ni raⱡ ndi, wamp nʉtʉng ik tenda ni mel ku nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kona ou rʉnggilmʉ ni kʉn, kona ni rumbʉⱡ moⱡpa pelinga, ant mong raldika omba purum. ");
INSERT INTO med_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wote, ant ni mba, keng orunga mba, ant mong raldika elinga, Jisas ndi, ama oⱡa ndupa, ronduⱡ kei nimba, “Eli, Eli Lama Sabaktani,” nitim. Ik ei nga puⱡ ei, “Na nga Got, na nga Got, nambuⱡ emel na wak ron?” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wamp mat ila nondpa anggilik morung nimbʉ ndi nʉk mel, “Wu ei ndi, Ilaija ni wi ronum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wamp morung nimbʉ nga ti ndi, tʉkrʉpa mba, muⱡ ti tʉpa, nu kombila iti tila mana ndupa, ekit tʉpa, ndila ropa, Jisas ni nangga nimba, oⱡa ndupa ngurum. ");
INSERT INTO med_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wote, wamp mat ndi, nʉk mel, “Unt raka nimbun moⱡamin, Ilaija ndi, elim omba, peng kont tʉmba, muna mon nda, moⱡpʉn kʉnʉmin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas ndi, aldpa ke ronduⱡ nimba kʉn, elim nga muⱡnga ei wak ropa, nuim kan ʉkrʉm. ");
INSERT INTO med_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ei kʉn mint, wi Jerusalem manga wingti ou ila, muⱡ mbal ruⱡ ti, manga kʉkaⱡ wingti raⱡ oi ndupa morum ni, rʉk ting ila paⱡpa mba met ekit purum. Wote kona kilimbʉmp mam ti elinga, ku mam mbʉ puk rurum ");
INSERT INTO med_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wamp on kona mbila mʉi rok rak nilinga, Got kʉn mondʉk pʉtʉng wamp mat korung nimbʉ, tʉpa oⱡa monduⱡnga kont morung. ");
INSERT INTO med_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wote, Jisas koⱡpa ⱡoporpa oⱡa murum ni kʉn, wamp mbʉ, en enim nga petʉng on kona mbʉ wak rok, wi Jerusalem kona peng wingti ila puⱡʉngina, wamp minal ndi kandrung. ");
INSERT INTO med_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wote, el nde wu mbʉ nga wu kuimbal ei kʉn, el nde wu mat kʉn, Jisas rʉp etʉk morung nimbʉ ndi, kona kilimbʉmp elinga, uⱡ itim nimbʉ kandʉk, ama mundmong etʉk nʉk mel, “Wu ni, kupa Got nga kangʉm,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ni kʉn ku, amp mat ruⱡ etʉk kandʉk morung ei, met Galili kona ila, Jisas tʉk rapʉndʉk etʉng amp kʉⱡ, Jisas pep rok orung. ");
INSERT INTO med_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Amp kʉⱡ morung rʉk ting ila amp Mariya Makndelin kʉn, wu Jeims kʉn, Josep raⱡ nga mam amp Mariya kʉn, wu Sepeti ambʉm kʉn kunda morung. ");
INSERT INTO med_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kona ni rumbʉⱡ roⱡnga, Arametiya kona ila wu nuim ti urum. Wu ei, Jisas nga kitip kʉni wu ti ku, wote wu ei nga mbi ei Josep. ");
INSERT INTO med_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wu ni ndi, wu Pailot ei, murum kona nila mba, Jisas nga on ei, timp nimba wuldʉtʉm. Ni kʉn, Pailot ei ndi, elim nga el nde wu kuimbal ei kundpa, wu on ninim ei, tʉkʉn ngui nitim. ");
INSERT INTO med_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Wote Josep ndi, wu on ni tʉpa, muⱡ mbal kurʉmʉⱡa kai tila kum ropa, mepa mba, el elim nga on kona ti, ku mam tila rorpa titim nila titim. Wote, ku mam ti ndi, mberʉk ndupa, on kona ku manga keta puⱡ puⱡ ni, aka ngumba pendpa purum. ");
INSERT INTO med_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Amp Mariya Makndelin kʉn, amp Mariya ti ni kʉn, ila nondpa, Jisas nga on ei, tetʉng kona ni, tʉk nont nduk kandʉk morunggil. ");
INSERT INTO med_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Jisas rorung ui ei nga utʉma orunga ei, Jura wamp nga mowi kor muⱡing ei nga tʉk kun etmin. Ui ei kʉn, wu pris kuimbal mbʉ kʉn, wote Perisi wu na mbʉ ndi ok, Pailot kʉn mou rorung. Wote, wamp nimbʉ ndi, nʉk mel, “Nuim ye! Ik kol wu rok kondung ni, kont murum ei kʉn, ik ei mel nitim ik tʉn pilpʉn mormin ei, ‘Rumbʉⱡ raldika omba pangga, na ⱡoporpa oⱡa mondʉmba,’ nitim. ");
INSERT INTO med_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ei kʉn, akup nim ndi, nim nga el nde wu mat tʉk mundana puk, on kona ila rʉp itangina, rumbʉⱡ raldika omba pangga kʉn, wak reing. I etʉk itangina kʉn, elim nga kitip kʉni wu kʉⱡ ndi ok, wu on ei kundʉp nok tʉk, wote wamp mbʉ ik kol rok kundʉk nʉk mel, ‘Jisas ni ⱡoporpa omba pum,’ ning. Akil tepa ik kol rok eng uⱡ ei ndi, kuimp tepa ik kol rorung uⱡ ni, tʉpa mana ndupa, ama kit moⱡmba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailot ni ndi, wu ni kʉⱡ kundpa nimba mel, “El nde wu ti mek puk, on kona ei nga keta puⱡ puⱡ ei, ronduⱡ puk rup itʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","I nitim ni kʉn, puk on kona keta puⱡ puⱡ ni, ku mam ti ndi, mberʉk nduk, peta rok pendʉtʉng. Wote pena orunga, el nde wu mat ila, rʉp iteing nʉk, tʉk mondrung. ");
INSERT INTO med_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mowi kor mormin ui ni, pora nilinga, mʉkʉlmʉ kor ou ei kʉn, rangʉmba pilpa, ⱡant gu nilinga, amp Mariya Makndelin kʉn, amp Mariya ti ni kʉn, Jisas nga on ei, on etʉng kona nila, kunʉnggil pilkʉⱡ purʉnggil. ");
INSERT INTO med_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ei kʉn, tʉngʉnda mint, kona ni kilimbʉmp mam ti elinga, oⱡa muⱡ ila, Got nga Anggelo ti mana urum. Wote, ku mam ti, Jisas tetʉng on kona ei, kumba angʉndʉk pendʉtʉng ni, mberʉk ndupa mundpa, elim pol nila murum. ");
INSERT INTO med_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Elim nga kʉng ei, kona kiraipa na ei mel, rʉⱡang mba eng nurum. Wote, elim nga muⱡ mbal rʉrʉm mel mbʉ, kona kup mong mel kurʉmʉⱡa itim. ");
INSERT INTO med_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","El nde wu ila, rʉp etʉk morung ni kʉⱡ, uⱡ ei kandʉk, en enim nga min mbʉ raka nilinga, min ngʉn mundʉk, wamp kormin ei mel kapⱡa puk petʉng. ");
INSERT INTO med_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ei kʉn, anggelo ni ndi, amp ni raⱡ, kundpa nimba mel, “Enmbil mundmong iti nʉtʉl! Enmbil wu Jisas, nde peta ila rong wu ni, kurʉk onmbil ei, na pʉnt. ");
INSERT INTO med_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wu ni, ya on kona ila pi napʉtʉm. Elim unt kont moⱡpa, nitim ni mel, elim ni ⱡoporpa omba pum. Ya okʉⱡ on kona koⱡ ei, kunʉnggil wʉl! ");
INSERT INTO med_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Akup tʉkrʉk pukʉⱡ, elim nga kitip kʉni wu nimbʉ kundkʉⱡ, ‘Jisas koⱡum ni, wote ⱡoporpa omba pum. Akup wi Galili mba pilpa, kuimp tepa pum. Wote, enim ila puk, Jisas elim kʉning!’ Enmbil kundʉp nʉnt ik kʉⱡ, pilkʉⱡ pʉl!” nitim. ");
INSERT INTO med_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ei kʉn ku, mundmong etkʉⱡ, wote numan mam ti elinga, wu on ei, tetʉng kona ni wak rokʉⱡ, elim nga kitip kʉni wu ni kʉⱡ kondʉk, ninggil pilkʉⱡ pukʉⱡ nʉkʉⱡ purʉnggil. ");
INSERT INTO med_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ei kʉn mint, Jisas ni, elim yant omba, amp ni raⱡ kandpa nimba mel, “Enmbil numan wang ndʉl!” nitim. Ni kʉn, amp ni raⱡ ndi, rʉk pukʉⱡ, Jisas nga kʉmp raⱡ ambulk, rumaⱡi pekʉⱡ, Jisas nga mbi paka rondrʉnggil. ");
INSERT INTO med_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas ndi nimba mel, “Enmbil mundmong iti nʉtʉl! Na nga wu ʉngʉnʉl kʉⱡ, pukʉⱡ kundkʉⱡ nanggila, wi Galili puk ila, na ok kʉning nʉl!” nitim. ");
INSERT INTO med_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amp ni raⱡ puⱡʉnggila mel, el nde wu ila morung ni kʉⱡ ndi, int puk kona peng nila, wu pris kuimbal nimbʉ, uⱡ itim kandrung nimbʉ mel, kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Wu pris kuimbal nimbʉ kʉn, manga wingti rʉp wu nimbʉ kʉn, ol tek, ku moni minal kum rok, el nde wu nimbʉ nguk, nʉk mel, “Enim ndi, wamp mbʉ kundʉk nʉk mel, ‘Tʉn ur pimʉn ndi kʉn, elim nga kitip kʉni wu kʉⱡ ndi, rumbuldi ok, wu on ei kundʉp nok, tʉk mek pung nʉi!’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wote, wu Pailot ei ndi, ik ei pilim ndam, tʉn ndi, enim mong ti nʉteing nimbun ik mat, tʉp rapundpʉn nindmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wote, el nde wu ni kʉⱡ ndi, ku moni ni kʉⱡ tʉk, wu pris kuimbal ei ndi, ik nʉi nitim ik ni mel nʉtʉng. Ei kʉn, ik timan kep nok, rorung ni, Jura wamp mbʉ kʉn, nʉk mek int yant etʉng ei mel, akup ik kep norung timan ei ku, tepa yant yant orum. ");
INSERT INTO med_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wote, kitip kʉni wu 11 ni kʉⱡ, Jisas ndi, wi Galili komnga ila pʉi nitim ni mel purung. ");
INSERT INTO med_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wote, Jisas ni oⱡnga kandʉk, Jisas nga mbi paka rondrʉng. Wote, wu mat ndi, Jisas wu waⱡʉm ei nda nʉk, ʉk puk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas ndi, wu ni kʉⱡ morung ila, nondpa omba, kundpa nimba mel, “Muⱡ mʉi raⱡ nga mel tetʉm mbʉ na ndi, rʉp iteimp nimba, Got ndi, na ronduⱡ ei, na ngurum. ");
INSERT INTO med_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ei kʉn, akup enim ndi, puk muⱡ uⱡ kona mbila, wamp mormin mbʉ, etʉk tʉk, na nga kitip kʉni wamp rundʉi! Wuta kʉn, kangʉm kʉn, Muⱡnga Wingti kʉn, mbi tek angʉndʉk, wamp mbʉ nu tindʉi! ");
INSERT INTO med_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wote na ndi, enim man ngur ik nimbʉ mek puk, wamp mbʉ mbo indangina, pilik teing. Ei kʉn, na enim kʉn pʉla kana ui moⱡʉng mbila, kunda moⱡʉp mint pamba mba, muⱡ mʉi raⱡ pora nimba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Puⱡ mundrum rʉnang ik kai ei, Jisas Kraist Got nga kangʉm ei morum. ");
INSERT INTO med_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ik kʉⱡ unt kuimp tepa, painui wu Aiseiya ndi, mon ropa pinditim ei mel, “Got ndi, nimba mel, ‘Na ndi, wu ti tʉp mundimp, ei na nga nombuⱡa rʉng wu ei, kuimp tepa nim nga nombuⱡa mam ei, tʉpa kun endʉmba.’ ");
INSERT INTO med_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wamp ti ndi, kona kui waka ila, wi ropa nimba mel, ‘Wu Nuim ei nga, nombuⱡa mam ti, rop tʉpʉn kun indamina, nombuⱡa mam ropʉn kun etpʉn timʉn ila elim wangga!’” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon elim mendpʉⱡ omba, kona kui waka nila moⱡpa, wamp nu tindpa, Got nga ik puⱡ nimbʉ, nimba ngumba. Wote, wamp mbʉ kundpa nimba mel, “Enim nga uⱡ kit mbʉ, wak rok nu tangina kʉn, Got ndi, enim nga uⱡ kit mbʉ, wak rondʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wamp minal ya Juriya kona ou ei kʉn, wote ya Jerusalem kona peng ou raⱡ nga wamp mbʉ ndi ok, Jon nga ik ei pʉtʉng. Wamp mbʉ ndi, en enim nga uⱡ kit mbʉ nʉk para nduⱡungina, Jon ndi, nu Joran ila wamp mbʉ nu tinditim. ");
INSERT INTO med_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon nga muⱡ mbal paⱡpa kan raⱡpa itim mel kʉⱡ, kng kamel kʉng mbila mim etʉng. Rʉng nurum mbʉ, pilma muⱡ na, uipʉ goimba na mbʉ nurum. ");
INSERT INTO med_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wote Jon ndi, wamp nimbʉ ik puⱡ mbʉ nimba ngumba mel, “Wu ti na nga mbuldung orunga omba ei, na mel kapⱡa mon. Wu ei ama oⱡa orunga. Ei nga, na ndi, wu ei kʉn, mura rop mondʉp, elim nga kʉmp rʉk kan ei pilinga, nduimp mel kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na ndi, enim nu ila mendpʉⱡ nu tʉndʉnt. Wote, wu ei ndi, enim Muⱡnga Wingti ei kʉn pendpa, nu tʉndʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wote, ui ei kʉn ku, nu ou ndupa, Jisas Nasaret kona moⱡpa kʉn, Galili kona ou ila oⱡnga, Jon ndi, Jisas nu Joran ila nu tinditim. ");
INSERT INTO med_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wote, Jisas nu ni, wak ropa ekit omba kʉndrʉm mel, wi muⱡ ni kumba tilinga, Got nga Muⱡnga Wingti ni, kʉi imil mel, elim kʉn mana urum. ");
INSERT INTO med_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wote, wi muⱡ ila ik ti ekit omba nimba mel, “Nim na nga numan ngur kan tenda ei, na nim kʉn numan mam ti enim,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wote, Muⱡnga Wingti ei ndi, Jisas etpa mepa mba kona kui waka ila purum. ");
INSERT INTO med_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kona kui waka ila moⱡnga, rumbʉⱡ 40 omba puⱡnga Seitan ndi, Jisas uⱡ kit mat tangga nimba, oⱡa tʉpa kʉndrʉm. Kng na mel rakra mbʉ ila morung ku. Ei wote, anggelo mbʉ ndi ok, Jisas tʉk rapʉndrʉng. ");
INSERT INTO med_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Wote, Jon ni tʉk kan ngʉk pendilingina kʉn, Jisas ni Galili kona nila mba, Got nga rʉnang ik kai nimbʉ tʉpa, wamp mbʉ ik puⱡ nimbʉ, kundpa nimba mel, “Ui ni akup om. Got nga wamp tʉpa mumuk rui uⱡ ei nondpa onum. Enim nga uⱡ kit mbʉ wak rok, ya Got nga rʉnang ik kai kʉⱡ mondʉk pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wote, Jisas ni, num Galili ʉldʉ nila omba kʉndrʉm mel, oma rorumbil wu raⱡ, Saimon Pita kʉn, ʉngʉn Andru raⱡ, oma wal mundkʉⱡ morunggil. ");
INSERT INTO med_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas ndi, wu ni raⱡ kundpa nimba mel, “Enmbil na kʉn wʉl! Na ndi, enmbil wamp mbʉ oma mel wal mundkʉⱡ tʉnggil ei mel mbo indimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ik ei mel pilkʉⱡ kʉn, tʉngʉnda mint, en enmbil nga oma wal na mbʉ wak rokʉⱡ, Jisas pep rok purʉnggil. ");
INSERT INTO med_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisas onunga wei kot wuldʉng mba kʉn, wu ʉngʉn ʉngʉn ralt kʉndrʉm. Wu raⱡ Jeims kʉn Jon raⱡ, wu Sepeti nga kangʉm raⱡ. Wu ni raⱡ, nu kanu ila, rukʉr molkʉⱡ, oma wal ni kʉⱡ, tʉkʉⱡ kun etʉnggil. ");
INSERT INTO med_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas ndi, wu ni raⱡ kandpa kʉn, wi roⱡnga kʉn, wu ni raⱡ ndi, en enmbil nga tipam wu Sepeti ni kʉn, kongun tʉk rapʉndrʉng wu nimbʉ kʉn, wak rokʉⱡ Jisas kʉn purʉnggil. ");
INSERT INTO med_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, Kaperniyum kona ou ila orung. Orung orunga Jura wamp nga mowi kor mormin ui ei kʉn, Jisas manga wingti kel ila mba kʉn, puⱡ mondpa wamp ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jisas nga ik ei pʉtʉng wamp mbʉ ndi, Jisas nga ik mbo rundrum uⱡ ila, pilik min ngʉn mundrʉng. Jisas ya Jura wamp mbʉ nga mi ik ila ik mbo rondurmʉn ei mel mon. Elim ndi, ik mbo rundrum ei ik ronduⱡ. ");
INSERT INTO med_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Ni kʉn, kur kit murum wu ti manga wingti ila omba kʉn, wi ropa nimba mel, “Nim tʉn kʉn namba uⱡ itin pilkʉn un, Nasaret kona ila wu Jisas? Nim ya un ei, tʉn rokʉn ndip kʉⱡin ei nga un ei? Nim nam, ei na nim pilip mor. Nim Got nga nombuⱡa rung Wu Wingti ei!” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas ndi, muⱡnga kit ni kʉn ronduⱡ mundpa nimba mel, “Raka nʉkʉn moⱡa! Wu ei, wak rokʉn kelkʉn ekit pa!” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kur kit nga muⱡnga ni ndi, wu ni ama ronduⱡ ambuⱡpa pur pur ndupa, kei ronduⱡ nimba, wu ni wak ropa kelpa ekit urum. ");
INSERT INTO med_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wamp nimbʉ ndi, min ngʉn mundʉk, en enim wamp mat ndi, mat waldʉk nʉk mel, “Ei namba uⱡ? Uⱡ kont ti ik mbo rondnum nda? Wu ei nga ronduⱡ ila muⱡnga kit mbʉ kundpa nilinga, ik ei teng ndʉnmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wote ni kʉn, Jisas nga uⱡ itim nimbʉ, Galili kona nimbila puⱡnga, pilik pora ndurʉng. ");
INSERT INTO med_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas kʉn elim nga kitip kʉni wu ni kʉⱡ kʉn, Jeims kʉn Jon raⱡ kunda, manga wingti kel ei wak rok puk, Saimon kʉn Andru raⱡ nga mang kona purung. ");
INSERT INTO med_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon nga kulpam ni, kui roⱡnga, ruⱡmina ila pitim. Wote, Jisas mang kona purum ni kʉn, Jisas kundʉk nʉk ei mel, amp ei kui roⱡnga petʉm nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Amp ni, kui noⱡnga pitim ruⱡmina nila, Jisas rukʉr mba amp ni, ki mbo orunga ambuⱡpa, tʉpa rapundpa oⱡa tʉpa mundrum. I itim ni kʉn, kui ni pora nilinga, amp ni ndi, wamp orung nimbʉ nga rʉng nimbʉ, kandpa tʉpa kun itim. ");
INSERT INTO med_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wote, ant ni mana mba rumbʉⱡ romba elinga kʉn, wamp mat ndi, Jisas murum nila kui rʉrʉm wamp na, kur kit murum wamp nimbʉ mek orung. ");
INSERT INTO med_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kona peng kel ila, wamp nimbʉ ok, manga keta ila mʉk rok morung. ");
INSERT INTO med_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisas ndi, wamp kui elpa elpa pitim wamp puⱡi etpa tʉpa mundpa, kur kit rukʉr murum mbʉ, tʉpa mundpa itim. Jisas ndi, kur kit mbʉ, ik neing nimba kandpa kont iti nʉtʉtʉm. Nambuⱡ emel, kur kit mbʉ ndi wu ei, Jisas nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Utʉma orunga ipri unt, rangʉmba min titim kʉn, Jisas ni rut nimba manga ni wak ropa kona peng kel ila ekit mba, kona waka tila elim atinga rurum. ");
INSERT INTO med_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wote, Saimon kʉn elim nga rup rok andʉrmʉn wu mbʉ kʉn, Jisas ni andʉk kurʉrʉng. ");
INSERT INTO med_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wote, wu ni kʉⱡ ndi, Jisas ni kandʉk tʉkʉn, kundʉk nʉk mel, “Wamp minal nim andʉk kurʉnmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisas ndi, punt ropa nimba mel, “Tʉn kona kel kel mbila elpa elpa pamin! Na kona mbila, Got nga ik puⱡ mbʉ nʉmp nguimp ku. Ei nambuⱡ emel, na uⱡ ei nga ur,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jisas ndi, Galili kona rʉk nila pora andpa manga wingti kel nimbʉ ila, Got nga ik puⱡ nimba ngumba, kur kit mbʉ tʉpa mundpa titim. ");
INSERT INTO med_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kint pombuⱡma rurum wu ti Jisas ndi, tʉpa rʉpʉndangga nimba mura koptʉm ropa mondpa, Jisas waldpa, “Nim ndi na nga kʉng ei etʉp kai mundimp nʉkʉn pin ndam, kapⱡa indi,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas wu ni nga kont kuⱡpa, ki ni run ndupa, wu ni minda ndurum. Minda ndupa nimba mel, “Na numan ngʉnt. Nim kai muⱡʉn!” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","I nilinga, wu ni nga kʉng ila kint pombuⱡma rurum ni kʉⱡ pora nilinga, kʉng kai ni, ekit urum. ");
INSERT INTO med_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jisas ndi, wu ni kelpa pangga nimba, ronduⱡ mundpa nimba mel, “Uⱡ ei nga wamp ti, kundkʉn ni nʉni! Kuimp tekʉn Pris ei kʉn pana, kanim uⱡ ei ndi, kai itangga! Wote, wamp mbʉ ndi, nim nga kʉng kai em uⱡ ei kandʉk, pilik iteing. Angge mel ti, Got nga mbi ila nguin ei, Moses ndi nitim uⱡ ei mel itʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wote, wu ni ndi, mba Jisas ndi, itim uⱡ ni nga wamp nimbʉ, timan ropa ngurum. Ik ni kona nimbila pora pʉtʉng. I etpa wu ei, ik nitim ei mba ou nduⱡnga, Jisas wamp morung kona peng kel mbila rʉk pi nʉpʉrʉm. Ei nga, Jisas ekit orung kona waka nimbila moⱡnga, wamp pora kona elpa elpa nimba ila molk, Jisas murum nila orung. ");
INSERT INTO med_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rumbʉⱡ kat omba puⱡnga, wote Jisas kelpa Kaperniyum kona yant urum. Wote, wamp nimbʉ ndi, pʉtʉng mel, Jisas ni omba mang kona morum nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wamp ama puⱡi oⱡʉngina, manga ni ti nimba murum. Wote pena orunga, manga keta kona nimbʉ pʉkʉ, ti nitim ku. Wote Jisas ndi, Got nga ik mong nimbʉ, wamp mbʉ nimba ngurum. ");
INSERT INTO med_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ni kʉn, wu tʉmbʉkak kat ndi, wu kʉmp ki kit murum ti rupⱡaima kulk mek, Jisas murum nila orung. ");
INSERT INTO med_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wu ni kʉⱡ ndi, wu ni kapⱡa mek, Jisas murum ila nondpa pi naprʉng. Ei nambuⱡ emel, wamp minal ei ndi, kona ti nitim. Wu ni kʉⱡ ndi, wu ni mek, manga im ila oⱡa puk, Jisas murum kona nila kun rok tʉk oⱡa nduk, wu rupⱡaima ila pitim ni, kunda tʉk, Jisas murum kona nila mana ndurʉng. ");
INSERT INTO med_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas ndi, wu tʉmbʉkak kʉⱡ nga mondpa pili uⱡ ila kandpa kʉn, on por murum wu ni, kundpa nimba mel, “Na nga kang ye! Nim nga uⱡ kit mbʉ wak rondʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Ui ei kʉn, Moses nga mi ik mbo wu mat morung nimbʉ ndi, en enim numan tʉk mundʉk, i nʉk pʉtʉng, “Nambuⱡ emel, wu ei ndi, ik i etpa ninim? Wu ei, Got nga ik mbuldung orunga nindinim. Wamp ti ndi, kapⱡa uⱡ kit mbʉ, wak rondʉmba mel mon. Got wu tenda ei ndi, kapⱡa etmba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wu kʉⱡ nga numan rukʉr orunga pʉtʉng uⱡ kʉⱡ, Jisas ndi, kandpa pilpa kʉn, wu kʉⱡ kundpa nimba mel, “Nambuⱡ emel, enim uⱡ kʉⱡ nga numan ou nduk pʉnmin? ");
INSERT INTO med_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","On por mul wu ei kundʉp nump mel, ‘Nim nga uⱡ kit mbʉ, wak rondʉnt nʉnt,’ muna, ‘Oⱡa molkʉn, nim nga rupⱡaima kʉⱡ tʉkʉn mekʉn okʉn, pi nʉnt ik mong ei, ik mong nant ei mbun enim?’ ");
INSERT INTO med_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Na ndi etamba enim kʉning ei, na Muⱡʉl Wu Kupa ei ndi, mana mʉi kona ila uⱡ kit mbʉ, wak rui uⱡ ei nga ronduⱡ ei tep mor,” nitim. Wote Jisas ndi, on por murum wu ni kundpa nimba mel, “Na ndi, nim kundʉp nʉnt, oⱡa molkʉn, nim nga rupⱡaima kʉⱡ, tʉkʉn mekʉn okʉn, mang kona pi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wamp nimbʉ pora kandʉk moⱡʉnggina, wu ni oⱡa moⱡpa, elim nga rupⱡaima kʉⱡ, tʉpa mepa tʉkrʉpa omba purum. Wamp nimbʉ min ngʉn minal mundʉk, Got kʉn ambulk palk nʉk mel, “Tʉn uⱡ i etpa ti, unt kʉni nakʉndʉrmʉn, mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas ni, num Galili ʉldʉ ila aldpa int purum. Wamp ama puⱡi murung kona nila oⱡnga, Jisas ndi puⱡ mondpa wamp nimbʉ, ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wote Jisas ni, mba kʉndrʉm mel, ku takis ti, wu Lipai ni, wu Alpiyas nga kangʉm ni, elim nga kongun etʉm manga nila murum. Jisas ndi, wu ni, kundpa nimba mel, “Nim na punt ila pep, rokʉn ui!” nitim. Lipai ni, oⱡa anggilpa, Jisas pep ropa purum. ");
INSERT INTO med_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wote, Jisas ni epindama mba, wu Lipai nga manga nila rʉng nurum. Rʉng norung kona nila, ku takis titmin wu puⱡi kʉn, uⱡ kit mbʉ nga etmin wu mat ou ndupa kʉn, Jisas elim nga kitip kʉni wu mbʉ kʉn, wote wamp puⱡi, Jisas pep rorung nimbʉ, kunda mou rok morung. ");
INSERT INTO med_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Perisi wu kʉⱡ kʉn, mi ik mbo wu kat molk kandrung mel, Jisas ni, uⱡ kit etmin wu nimbʉ kʉn, ku takis tʉtʉng wu nimbʉ kʉn, moⱡpa rʉng noⱡnga, kandʉk kʉn, Jisas nga kitip kʉni wu nimbʉ, waldʉk nʉk mel, “Nambuⱡ emel, Jisas wamp i etpa mbʉ kʉn, moⱡpa rʉng tenda ila nonum nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas ndi, ik kʉⱡ pilpa kʉn, punt ropa nimba mel, “Wamp ti kui rui narʉrʉm ei, dokta morum ila, pi napʉrʉm. Wote, kui rorum wamp mbʉ mint purmin. Na ya ur ei, wamp kai mbʉ, etʉp timp nʉmp ui nʉwʉr mon! Wote, wamp kit mbʉ etʉp timp pilip ur,” nitim. ");
INSERT INTO med_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ui ti kʉn, wamp nu tindi wu Jon nga kitip kʉni wu kʉⱡ kʉn, Perisi wu kʉⱡ kʉn, rʉng mowi petʉng. Wamp mat ndi ok, Jisas waldʉk nʉk mel, “Nambuⱡ emel, wamp nu tindi wu Jon nga kitip kʉni wu kʉⱡ kʉn, Perisi wu mbʉ nga kitip kʉni wu kʉⱡ, rʉng mowi pelingina, wote nim nga wu kʉⱡ rʉng mowi pi napʉtmin ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas ndi, punt ropa nimba mel, “Wote, enim etʉk pinmin mel nant? Amp tʉmba wu ei nga rʉng koim ila wamp tʉma ong mbʉ, rʉng nui nʉning ye? Mon ei ka! Wote, amp tʉmba wu ei, wamp mbʉ kʉn, kunda molk kʉn, wamp mbʉ, kai pilik kapⱡa rʉng nuing. ");
INSERT INTO med_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wote, ui ti om kʉn, wamp mbʉ mondʉk kelik, amp tʉm wu ei mek pung ei kʉn, wamp mbʉ, wu ei nga kont itangga rʉng mowi ping. ");
INSERT INTO med_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wamp ti ndi, muⱡ ni kont ti tʉpa, wal pʉki unt nga kat mbila, nʉtʉm ila pendpa ropa rumbʉⱡi nambrʉm. Wote, i en ndam, muⱡ ni kont pendpa ropa rambrum ei, ronduⱡ mba wal pʉki unt nga kʉⱡ, mepa rʉk omba ondpa ou ndurum. ");
INSERT INTO med_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wamp ti ndi, nu wain kont ei tʉpa kng meme kʉng ming unt nga ila oi ndupa mundi namʉndrʉm. Ei nambuⱡ emel, oi ndum ndam, nu wain kont ei ndi moⱡpa, kng meme kʉng unt nga kʉⱡ nomba mbila ndumba? Ei kʉn, mel raⱡ kunda kunda etpa, kit moⱡmba. Ei mon! Nu wain kont ei, kng meme kʉng ming kont ila oi ndurmin,” nitim. ");
INSERT INTO med_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mowi kor mormin wi ei kʉn, Jisas ni, rʉk wit pana tila omba purum. Elim nga kitip kʉni wu ni kʉⱡ, kunda orung ei ndi, wit mong mat oldʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wote, mi ik pep rui wu Perisi ni kʉⱡ ndi, Jisas kundʉk nʉk mel, “Tʉn nga mi ik ei ndi, nimba mel, mowi kor kʉn kongun iti nʉtʉi, mon nimba petʉm. Wote, nim nga wu kʉⱡ ndi, kongun enmin ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jisas ndi, punt ropa nimba mel, “Enim King Depit nga itim timan kʉⱡ, kʉmp rok kandʉrmin muna mon? Elim kʉn, elim nga kunda rup rok andrʉng wu kʉⱡ kʉn, kunda kump kun kurung ei kʉn, King Depit ndi, Got nga manga wingti ila mukʉr mba, Got nga bret angge nʉk ngurung mbʉ tʉpa nurum. I itim ei, Apitar ni wu ei, pris kʉⱡ nga kuimbal murum ei kʉn itim. Tʉn nga mi ik ngurum ei ndi, bret ei pris kʉⱡ mint tʉk ning nʉtʉm. Ni wote, Depit tʉpa numba, elim nga wu mbʉ nguⱡnga norung ku,” nitim. ");
INSERT INTO med_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wote Jisas ndi, nimba mel, “Mowi Kor ei, wamp nga molk kai munding ei nga nindpa inditim. Wamp ei, Mowi Kor ei nga nindpa indi nʉndʉtʉm mon! ");
INSERT INTO med_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ei nga, Muⱡʉⱡ Wu Kupa ei, mowi kor mormin ui ei nga Wu Nuim ei,” nitim. ");
INSERT INTO med_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wote Jisas ni, mbi paka manga kel nila int purum mel, wu ti ki kukupa kel etʉm ti ila murum. ");
INSERT INTO med_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wamp mat ila morung nimbʉ ndi, ik nombuⱡa mam mat kurʉk, Jisas mong nguimin nʉk pilik, Jisas rʉp ambulk pilik etʉk nokundʉk. Wote Jisas ndi, Mowi Kor ei kʉn, wu ei etpa kai enim ndam, kʉnmin nʉk morung. ");
INSERT INTO med_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ni kʉn, Jisas ndi, ki kukupa kel etʉm wu ni, kundpa nimba mel, “Nim ya ekit okʉn, wamp nga kump keta ila ʉnggʉli!” nitim. ");
INSERT INTO med_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wote Jisas ndi, wamp nimbʉ waldpa nimba mel, “Mi ik ndi, Mowi Kor ei kʉn, tʉn uⱡ nant ei itmin nimba petʉm? Wamp tʉpa rʉpndi uⱡ ei muna, wamp etpa mbun ngui uⱡ ei ya muna, wamp etpa peng kont ti uⱡ ei muna, wamp ropa kundi uⱡ ei?” nitim. Ni kʉn, wamp nimbʉ ik ti, ni nandʉk raka nʉk morung. ");
INSERT INTO med_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas ni, popʉⱡ kuⱡpa, wamp nimbʉ kandpa andpa pok etpa, wote aldpa wamp nimbʉ nga kont kurum. Ei nambuⱡ emel, wamp nimbʉ, numan ⱡawa kʉⱡ ronduⱡ pʉtʉng ei nga itim. Wote Jisas ndi, wu ni kundpa nimba mel, “Nim nga ki ei runga ndui!” nitim. Wu ni nga ki ni, runga nduⱡnga kʉn, omba kun purum. ");
INSERT INTO med_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wote, Perisi wu nimbʉ, manga wingti kel ni, wak rok kun puk, Erot nga wamp rʉⱡaip kʉⱡ kandʉk tʉk, Jisas rumʉn nʉk pilik, nombuⱡa mam mat kurʉrʉng. ");
INSERT INTO med_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas kʉn elim nga kitip kʉni wu kʉⱡ kʉn, kelik num Galili ila purung ni, wamp ama puⱡi ndi, elim pep rok orung. Wamp mbʉ, ya Galili kona ou na, Juriya kona ou na, Jerusalem kona peng ou na, Irumiya kona ou na, nu Joran al orunga kʉn, Taiya na, Sairon kona peng ou mbila pora orung. Wamp kona mbila nga pʉkʉ, Jisas nga itim uⱡ timan kʉⱡ pilik kʉn, Jisas kʉn orung. ");
INSERT INTO med_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wamp ama puⱡi orung ila, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ kundpa nimba mel, “Nu kanu kat elim nga tʉk kun indʉi!” nitim. Kona ila, oⱡa mbo moⱡamba, wamp mbʉ ndi, elim tʉk kum rui nʉreing, nitim. ");
INSERT INTO med_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas ndi, kui pitim wamp puⱡi etpa, kai mundrum ei nga, kui pitim wamp mbʉ ndi, elim pint ngʉk, elim kʉn ok minda ndʉmin nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kur kit rukʉr orunga murum wamp nimbʉ ndi, Jisas kandʉk kʉn, ropa munduⱡnga mana puk pek, ka etʉk, nʉk mel, “Nim Got nga kangʉm kupa ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wote Jisas ndi, ronduⱡ mundpa kur kit kʉⱡ kundpa nimba mel, “Elim wu nam ei wamp ti kundʉk ni nʉnʉi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wote Jisas ni, komnga mong tila, oⱡa mba moⱡpa kʉn, elim nga numan ngurum kitip kʉni wu ni kʉⱡ wi ropa, elim kʉn, “Wʉi!” nitim. Wu ni kʉⱡ, elim murum nila orung. ");
INSERT INTO med_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Jisas ndi, wu 12 kandpa tʉpa, mbi tepa elim nga nombuⱡa rung wu kʉⱡ, “Na ndi, enim na kʉn kunda rup rop ʉndmin nʉmp tʉnt,” nitim. Jisas ndi, kundpa nimba mel, “Na ndi, enim tʉp ekit ndamba wamp mbʉ kʉn, puk Got nga ik mbʉ man ngok, wote enim ronduⱡ ei tʉk tek molk, kur kit moⱡum wamp mbʉ, tʉk munding,” nitim. ");
INSERT INTO med_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Elim nga kitip kʉni wu 12 kandpa titim kʉⱡ nga ti, Saimon (Jisas ndi, mbi tepa ‘Pita’, nitim). ");
INSERT INTO med_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","19","Jeims kʉn, elim nga ʉngʉn Jon raⱡ, wu Sepeti nga kangʉm raⱡ. (Jisas ndi, wu raⱡ mbi tepa, Bowanerges nga puⱡ ei, ‘Ya muⱡ gaⱡa nga kangʉm,’ nitim.) Andru, Pilip, Bartolomiyu, Matyu, Tomas, Jeims ei wu Alpiyas nga kangʉm, Tatiyas, Saimon Selot, Juras Iskariyot ei, Jisas ruing ei nga rʉk murum wu ei. ");
INSERT INTO med_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wote Jisas ni, mang kona purum. Wote, aldpa wamp ama puⱡi orung ila Jisas kʉn elim nga kitip kʉni wu ni kʉⱡ kʉn, molk rʉng nuing ui ti, ti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisas elim nga wamp mbo nimbʉ ndi, molk pʉtʉng mel, wamp mbʉ ndi, nʉk mel, “Jisas elim nga wamp mbo nimbʉ ndi, molk pʉtʉng mel wamp mbʉ ndi, nʉk mel, ‘Jisas ni kur kupʉr ronum,’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wote mi ik mbo wu mat, wi Jerusalem kona peng ou ila orung nimbʉ ndi, nʉk mel, “Wu ei kur Biyelsipul elim nga rukʉr orunga morum,” nʉtʉng. Wote, wamp mat ndi, nʉk mel, “Ei kur kit mbʉ nga kur nuim ei. Ei ndi moⱡpa, ronduⱡ ei nguⱡnga, kur kit mbʉ tʉpa mundnum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wote Jisas ndi, wamp nimbʉ kundpa elim kʉn wei nimba ik ek mat ropa nimba mel, “Seitan ndi, Seitan nambuⱡ etpa tʉpa mundʉmba nda? ");
INSERT INTO med_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Muna mʉi kona ou tila wamp palk raⱡ etʉk orung orung etʉk el eng ndam, mʉi kona mam ei pora nimba. ");
INSERT INTO med_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wote, wamp mbo kʉⱡ palk raⱡ etʉk orung orung etʉk en enim el eng ndam, wamp mbo kʉⱡ pora nimba. ");
INSERT INTO med_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ei mel ku, Seitan nga wamp rʉⱡaip mbʉ, palk raⱡ etʉk elpa elpa pum ndam, Seitan nga ronduⱡ ti, ti natʉmba. Ei pora nimba. ");
INSERT INTO med_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Wamp nam ti ndi, wu ronduⱡ purmʉn ti nga manga ila mukʉr mba mel mbʉ, kapⱡa ti natʉmba. Pum wu ei ndi, kuimp tepa wu ronduⱡ purum ei, tʉpa kan ngumba tepa, wote wu ei nga manga ila mel mbʉ tʉmba. ");
INSERT INTO med_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Na enim kupa kundʉp nint, Got ndi, wamp mbʉ nga uⱡ kit etmin mbʉ, wak rondʉmba. Wote, wamp mbʉ ndi, ik kit mat nʉng ndam, wak rondʉmba ku. ");
INSERT INTO med_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","“Wote, wamp nam ti ndi, Muⱡnga Wingti nga, ik mbuldung orunga nindim ndam, elim nga uⱡ kit em ei wak rundi nandʉmba. Nambuⱡ emel, elim nga uⱡ kit etʉm mbʉ pemba mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas ik kʉⱡ nitim ei, nambuⱡ emel, wamp mat ndi, nʉk mel, “Wu ei rukʉr orunga kur kit morum nʉtʉng ei nga,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wote, Jisas nga mam kʉn ʉngʉnʉl kʉⱡ kʉn orung. Ok manga pena orunga anggilik kʉn, Jisas waldʉk pena wangga nʉk mundrʉng. ");
INSERT INTO med_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wamp puⱡi molk andʉk pok etʉng ila, Jisas rʉk ting ila murum ni, kundʉk nʉk mel, “Pʉn ei! Nim nga manʉm kʉn ʉngʉnʉl kʉⱡ kʉn, pena nim kʉnmin nʉk nokundʉk mormin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisas ndi, wamp nimbʉ kʉn, punt ropa nimba mel, “Na nga mam ei nam? Na nga ʉngʉnʉl kʉⱡ wu namin?” nitim. ");
INSERT INTO med_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jisas ndi, wamp elim murum ila molk andʉk pok etʉng nimbʉ, kundpa nimba mel, “Ya kʉnʉiya! Ya wamp mormin mbʉ, na nga mamʉl kʉn, na nga ʉngʉnʉl mbʉ mormin. ");
INSERT INTO med_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wamp nam ti ndi, Got nga numan pʉtʉm uⱡ ei mel, em wamp ei, na nga ma, na nga ana, na nga aiya, nʉmp pʉt,” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wote tʉnggʉt kʉn, Jisas ndi, num Galili nga ʉldʉ ila wamp mbʉ kʉn puⱡ mondpa, ik mbo inditim. Jisas murum ila wamp orung nimbʉ ama minal elinga, Jisas aldpa kelpa omba, nu kanu nila, oⱡa mba rukʉr nila mana murum. Nu kanu ni kʉⱡ num nila, noi rukʉr mba telinga, wamp ama puⱡi num ʉldʉ nila anggilik morung. ");
INSERT INTO med_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Jisas ndi, ik ek puⱡi ropa wamp mbʉ, ik mbo endpa, nimba mel, “Ya pilʉiya! Ui ti kʉn, wu ti rʉng mbo mundʉmba purum. ");
INSERT INTO med_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wu ni, rʉng mbo nimbʉ, mepa andpa rʉk kongun kona nila mundrum. Ni kʉn rʉng mbo mat nombuⱡa mam ila mana purum. Nimbʉ kʉi ndi, tʉk norung. ");
INSERT INTO med_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Rʉng mbo mat mba mana ku titim pol ila mʉi onunga etpa titim nila mana purum. Ni kʉⱡ tʉkrʉpa mʉlʉ rurum. Nambuⱡ emel, mʉi ei mandpa ti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wote, ant ei oⱡa omba rurum ei kʉn, rʉng mʉlʉ rurum ni kʉⱡ, ant ei ndi, nomba kundrum. Ei nga, rʉng pilkan kʉⱡ mʉi ila mana mba, kapⱡa iti nʉtʉtʉm. Ei nga, rʉng kʉⱡ mʉlʉ ropa oⱡa omba, wote nondpa kurum. ");
INSERT INTO med_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wote, rʉng mbo mat mana mba, kumbʉⱡ nde ⱡembʉⱡ na nila mana purum. Nimbʉ, kumbʉⱡ nde ⱡembʉⱡ mbʉ ndi, omba mam etpa, rʉng mbo nimbʉ, ropa mana nduⱡnga, rʉng mbʉ oⱡa omba ropa muⱡ pi nʉpʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wote rʉng mbo mat, mba mʉi kona kai ila mana purum. Rʉng mong mbʉ, mʉlʉ rok kai mondʉk, oⱡa ok rʉng mong puⱡi rurung. Rʉng mong mat 30 nimba mong rurum, mat ndi 60 nimba rurum, mat ndi 100 nimba rurum,” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wote, Jisas ndi nimba mel, “Kum nombuⱡa tem wamp ti ndi, na ik nʉnt ei, kum tepa pilangga!” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wote, Jisas ni elim kou murum ila, elim nga kitip kʉni wu 12 ni kʉⱡ kʉn, Jisas ik nitim ila kum tek morung wamp nimbʉ kʉn ok, Jisas ik ek rurum ni nga, ik puⱡ mbʉ, kundpa nangga nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisas ndi, wamp nimbʉ kundpa nimba mel, “Got nga wamp tʉpa mumuk rui uⱡ ei enim ngurum. Wote, wamp namin ya ekit orunga mormin kʉⱡ, ik ek ila mint molk piling. ");
INSERT INTO med_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ei nga wote, ‘Wamp mbʉ ndi, kʉni nʉkʉning. Wote, kandʉk mbi ndui nʉnding. Wote, wamp mbʉ ndi, ik ei unt pʉtʉng, wote pilik kun iti nʉtʉng. Wote, wamp mbʉ ndi, uⱡ kit mbʉ etʉk, wote numan ropʉl rui naruⱡʉngina kʉn, Got ndi, en enim nga uⱡ kit mbʉ, wak rundi nandrʉm,’” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wote Jisas ndi wamp nimbʉ waldpa, “Enim ik ek kʉⱡ pili napʉnmʉn ye? Wote, nambuⱡ etʉk enim ndi ik ek ei nga puⱡ ei piling nda? ");
INSERT INTO med_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wu rʉng mbo mundrum ei, Got nga ik mong ei mbo mundrum. ");
INSERT INTO med_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wamp mat, rʉng mbo ya nombuⱡa mam ila mana purum ei mel kapⱡa. Got nga ik mong kʉⱡ pilik moⱡʉngina kʉn, Seitan ei ndi, rʉk omba, Got nga ik mong kʉⱡ tʉpa mepa purum. ");
INSERT INTO med_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wote wamp mat, rʉng mong kʉⱡ ropa munduⱡnga, mba ku murum mʉi pol ila mba titim ni mel kapⱡa. Wamp mat, Got nga ik mong ei tʉngʉnda mint pilik kʉn, numan ei ndi kormin. ");
INSERT INTO med_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wote, Got nga ik ei numan ila mana mba pepa pilkan ngui nganggʉrʉm. Ei nambuⱡ emel, Got nga ik ila uⱡ mbun mindil pi mat, oⱡnga kandʉk kʉn, Got nga ik ei tʉngʉnda wak rormin. ");
INSERT INTO med_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wote wamp mat, ya kumbʉⱡ nde ⱡembʉⱡ kona ila mana purum ei mel. Wamp kʉⱡ ndi, Got nga ik mong ei piling. ");
INSERT INTO med_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Wote, wamp kʉⱡ ndi, en enim nga kʉng orunga kont puk muⱡing ei nga numan ou nduk pilik, en enim wamp nuim muⱡing ei nga numan ou nduk pilik kʉn, mel mbʉ nga mint numan tʉk mundʉk, wote Got nga ik mong ei pili nʉpiling. Wote, ik mong piling kai kʉⱡ ropa muⱡ pi napʉmba. ");
INSERT INTO med_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wote wamp mat, rʉng mong mat mʉi kai ila mana purum ei mel, wamp mbʉ ik ei pilik, tʉk numan mbo ila pendʉk, mek int puk wamp mat, mbo ronduⱡʉngina kʉn, wamp mbʉ rʉng mong kai rorum ni mel mat, ropa 30 itim, mat ropa 60 itim, wote mat, ropa 100 itim,” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas ndi, ik kat kundpa nimba mel, “Wamp nam ti ndi, lam kandpa mepa mukʉr omba ming na rat pol mana orunga na mbila mondrum nda? Ei mon, lam kandʉk mondʉrmʉn kona ila mondʉrmʉn ni ka! ");
INSERT INTO med_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mel namba mel mat, mo ropa tetʉm mbʉ, omba pena ila temba. Wote, ekit wangga wamp mbʉ ndi kʉning. Mel mat, panda ropa tetʉm mbʉ, ekit omba pena ila temba. ");
INSERT INTO med_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wote, wamp nam ti ndi, kum nombuⱡa tem ndam, ik ei pilangga!” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisas ndi, wamp kʉⱡ ik mong kat, kundpa nimba mel, “Numan tʉk mundʉk pilik kai itʉi! Ya ik enim pilmin kʉⱡ, uⱡ namba uⱡ ti nim ndi, ya mana mʉi kona ila wamp ti kʉn, kʉmp tʉkʉn ngʉn ei mel ku, Got ndi, i ku etpa, nim kʉn minal kʉmp tʉmba. ");
INSERT INTO med_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wamp nam ti, mel ou ndupa tepa moⱡum wamp ei, wote mel ou ndupa ngumba. Wote, wamp nam ti, mel ou ndupa tepa muⱡi nambuⱡ mel, onunga kʉralt tepa moⱡum ndam, kʉⱡ elim kelpa int tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wote Jisas ndi, ik ek kat ropa nimba mel, “Got nga wamp tʉpa mumuk rui uⱡ ei mel, wu ti elim nga kongun kona ila rʉng mbo mundrum ni mel. ");
INSERT INTO med_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rumbuldi muna rʉnggilmʉ mbila wu ei, elim ur petʉm muna morum ei kʉn, rʉng mong mbʉ mʉlʉ ropa, ou etpa etʉm uⱡ ei, nambuⱡ uⱡ etpa etʉm, wu ei pili napʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mʉi ei elim ndi, kongun elinga, rʉng mong ei mʉlʉ ropa oⱡa omba omung ropa rʉng ei ropa muⱡ petʉm. ");
INSERT INTO med_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wote, rʉng mong ei rupa ropa etʉm ei kʉn, wu ei ndi rʉng mbʉ puⱡ mondpa tʉtʉm. Nambuⱡ emel, ui ila rʉng mbʉ pora rupa ropa pelinga, tʉk normʉn ui ei,” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wote Jisas ndi, waldpa nimba mel, “Tʉn ndi, Got nga muⱡ kona ei, namba mel ei kʉn, kapⱡa nimin? Ik ek nant kʉⱡ ropʉn namina ik ei, pilik poⱡ nduing? ");
INSERT INTO med_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uⱡ ei mel, wu ti ndi, rʉng mastat nga mong ei, muⱡ uⱡ kona mbila pora, rʉng mong mel wei kʉⱡ, tʉpa kongun kona ila mbo mundrum. ");
INSERT INTO med_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Rumbʉⱡ mat, omba puⱡnga kʉn, nde mong ni, mʉlʉ ropa oⱡa omba, kongun kona elinga, nde mastat ou kʉⱡ anggʉtʉm. Nde mastat kʉⱡ nga puⱡa mbila, kʉi mbʉ ndi ok, mastat puⱡa po nʉtʉm mbila, mi manga rormin,” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas ndi, Got nga ik puⱡ mbʉ wamp mbʉ kʉn, i etpa nimba ngurum. I ku etpa, ik ek ou ndupa ropa wamp mbʉ, pilik teing nimba ngurum. ");
INSERT INTO med_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jisas ndi, wamp mbʉ kʉn, ik kun etpa kundpa ni nʉndʉtʉm. Ik ek mint ropa kundpa nitim. Ei kʉn wote, Jisas elim nga kitip kʉni wu kʉⱡ, mint molk kʉn, Jisas ndi, ik ek rurum nimbʉ nga puⱡ mbʉ kundpa nitim. ");
INSERT INTO med_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ant tenda ila epindama Jisas ndi, elim nga kitip kʉni wu kʉⱡ kundpa nimba mel, “Tʉn ya num ei puⱡa ropʉn noi ʉldʉ orunga pamin!” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wote, wamp minal nimbʉ, wak rok kʉn, kitip kʉni wu ni kʉⱡ, Jisas mba rukʉr murum nu kanu ila rukʉr puk, Jisas ni tʉk mek en enim kʉn, rup rok purung. Nu kanu mat ila, kunda titim ku. ");
INSERT INTO med_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wote, ama kona kʉpkʉ mam ti ropa, num ni pʉnʉn nimba omba, num ni kildpa ropa omba, nu kanu ila rukʉr mba. Nu kanu ni kʉⱡ, nu ndi, peka romba itim. ");
INSERT INTO med_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ni, nu kanu ni kʉⱡ nga met tip nila, peng kilanda mundpa ur pitim. Kitip kʉni wu ni kʉⱡ ndi, Jisas ni, rok rut nduk nʉk mel, “Ik mbo wu ye! Nim tʉn nga nʉkʉn, pili napʉn ye! Tʉn nu wanggʉpʉn kuⱡmin enmin ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas ni, rut nimba oⱡa anggilpa kona kʉpkʉ ni kundpa nimba mel, “Raka nʉkʉn muⱡi!” nitim. Wote num ni kundpa nimba mel, “Raka nʉkʉn muⱡi!” nitim. I nilinga kʉn, kona kʉpkʉ ni rui narʉⱡnga, num ndi, rurum ni mana purum. ");
INSERT INTO med_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wote Jisas ndi, elim nga kitip kʉni wu kʉⱡ, kundpa nimba mel, “Nambuⱡ emel enim mundmong enmin? Akup enim nga mondpa pili uⱡ ei, tek muⱡi nambʉrmʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wu ni kʉⱡ mundmong minal etʉk kʉn, en enim ti ndi, ti waldʉk nʉk mel, “Wu ei nam? Kona kʉpkʉ na, nu ndi na, mel raⱡ ndi, wu ei nga ik teing ndunmbʉⱡ ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas kʉn elim nga kitip kʉni wu ni kʉⱡ kʉn, num Galili noi orunga ekit puk, Gerasin kona ou ila ekit purung. ");
INSERT INTO med_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas nu kanu ei, wak ropa ekit omba moⱡnga, wu ti. Wamp on kona ila pepa ʉndrʉm wu ni, Jisas murum kona ila urum. ");
INSERT INTO med_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wu kur kit murum ei, wamp on kona mbila pepa ʉndrʉm. Wamp na ti ndi, kapⱡa tʉk imp molk, kan ronduⱡ ngʉk iting mel kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wu ei nga kʉmp ki mbʉ, tʉk kan ngʉk puⱡi endʉtʉng ku. Ei wote, ombil minal pitim kan ronduⱡ mbʉ, ropa puⱡa mint rurum. Ei nga wote, wamp ti ndi, kapⱡa imp molk iti natʉtʉng ");
INSERT INTO med_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rumbuldi rʉnggilmʉ mbʉ kʉn, kei nimba wamp on kona mbila anduⱡnga, ku na mbun ndi, kʉng mbʉ, ropa nit minal pinditim. ");
INSERT INTO med_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wu ni, ruⱡ etpa moⱡpa, Jisas urum ni kandpa, tʉkrʉpa mba. Jisas nga kʉmp puⱡ ila mba pepa, mura kopʉtʉm ropa mundrʉm. ");
INSERT INTO med_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ronduⱡ kei nimba mel, “Jisas, nim Got Ama Oⱡa orunga nga kangʉm! Nim ndi, na kʉn nambuⱡ ti itin? Got nga mbi ila nim waldʉnt, ‘Nim ndi, na mindil ngui ngʉngi!’” ");
INSERT INTO med_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wu ei ndi, ik nitim, ei nambuⱡ emel, Jisas ndi, kundpa nimba mel, “Kur kit nim wu ei, wak rokʉn ekit pi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ei nga, Jisas ndi, wu ni waldpa nimba mel, “Nim nga mbi ei nam?” nitim. Wote, wu ni ndi, nimba mel, “Tʉn minal mormin mel ku, na nga mbi ei wamp puⱡi,” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I nimba, ronduⱡ kei nimba muⱡnga kit ei ndi, Jisas waldpa nimba mel, “Elim ekit tʉkʉn mʉi ila wak rui nʉri mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kona ila nondpa, kng minal wʉr ramba ila rʉng nok morung. ");
INSERT INTO med_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wote, kur kit ni kʉⱡ ndi, Jisas waldʉk nʉk mel, “Tʉn tʉkʉn kng kʉⱡ nga kitim ila mundana! Wote tʉn rukʉr pamin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas ndi, nʉtʉng ei mel kapⱡa nilinga, kur kit mbʉ wu ni, wak rok ekit ok puk kng kʉⱡ nga kitim ila rukʉr purung. Kng 2000 mel, ila morung ni kʉⱡ, tʉkrʉk puk, num ʉldʉ kop peng titim ila, mana puk nu wanggʉrʉng. ");
INSERT INTO med_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wu kng rʉp etʉk morung ni kʉⱡ, kelik tʉkrʉk puk, kona peng na, kongun kona titim nimbila, uⱡ itim nimbʉ mel, timan roⱡʉngina, wamp mbʉ pilik kʉn, uⱡ itim ei mel kʉnmin nʉk purung. ");
INSERT INTO med_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wote, wamp nimbʉ ok, Jisas murum nila kandrung mel, wu ti unt kur kit mundrum ni, numan mbo pilpa, muⱡ raⱡpa etpa murum ila kandʉk, mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Uⱡ itim ila, wamp molk kandrung nimbʉ ndi, orung wamp nimbʉ kundʉk, wu kur kit murum wi ei nga uⱡ itim mbʉ kʉn, kng mbʉ nga etʉng uⱡ mbʉ kʉn, wamp mbʉ kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pilik kʉn, Jisas waldʉk,’ en enim nga kona wak rangga nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nilingina, Jisas ni, nu kanu ni kʉⱡ ila rukʉr puⱡnga, wu kur kit murum ni ndi, Jisas waldpa nimba mel, “Na nim kʉn mbi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ni kʉn, Jisas ndi, mon nimba, wote wu ni, kundpa nimba mel, “Kelkʉn nim nga wamp mbʉ kʉn mang kona pukʉn, nim nga wamp mbʉ kundkʉn, ya Wu Nuim Got ndi, nim kʉn em uⱡ mbʉ kʉn, wote nim kʉn uⱡ kai em ei nga kundkʉn nʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wote wu ni, kelpa mba kona peng 10 kat ila andpa, Jisas ndi, elim nga inditim uⱡ nimbʉ mel, timan roⱡnga, wamp nimbʉ ndi, pilik min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas ni, aldpa nu kanu ni kʉⱡ ila, num ni puⱡa ropa, nu ʉldʉ ronggʉt purum. Noi num ʉldʉ nila, wamp ama puⱡi ok, Jisas murum nila molk, andʉk pok etʉng. ");
INSERT INTO med_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Jairus ni wu ei, Got nga atinga manga kel, nokundrum wu ei omba, Jisas kandpa kʉn, Jisas nga kʉmp puⱡ ila mura koptʉm ropa mondpa, Jisas kʉn mindil tʉpa, waldpa nimba mel, “Na nga ambuⱡa kel kui ropa koⱡmba elinga, wote nim okʉn, nim nga ki ei ndi, ambulkʉn kʉng ila minda ndana, ambuⱡa ei nga kui ei, wang nangga!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wote, Jisas kʉn kunda purʉnggil, wamp ama puⱡi ndi, Jisas purum ni mel, pep rok purung. ");
INSERT INTO med_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ni kʉn, amp ti ku pok ropa, mema omba mba mint moⱡnga, pana 12 omba purum. ");
INSERT INTO med_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kui ei nga amp ei, wu dokta puⱡi ndi kandʉk, marasin ngurung ei, kui ei pora ni nʉndʉtʉm. Amp ei, ku moni ama puⱡi wak ropa, elim nga kui ei etʉp pora nduimp nimba pilpa itim. Wote, kui ni pora ni nandilinga, ama kui ni mba mam itim. ");
INSERT INTO med_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Amp ei, Jisas nga kongun itim timan ei pitim. Wote amp ei, wamp puⱡi orung rʉk ting ila, Jisas pep ropa mbuldung orunga omba, wal pʉki ni kʉⱡ minda ndurum. ");
INSERT INTO med_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Amp ei, elim nga numan ei ndi pilpa nimba mel, “Na ndi, Jisas nga wal pʉki kʉⱡ minda ndunt ndam, na nga kui ei, pora nimba,” nimba pitim. ");
INSERT INTO med_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amp ni ndi, Jisas nga wal pʉki ni kʉⱡ, minda nduⱡnga kʉn, mema rurum uⱡ ni, tʉngʉnda kʉr nitim. Wote amp ni, elim nga numan orunga pitim mel, elim kui roⱡnga, mbun titim ni pora nitim. ");
INSERT INTO med_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","I elinga, Jisas pitim mel, elim nga ronduⱡ ei, omba ekit puⱡnga pilpa, tʉpa ropʉl ropa, wamp minal morung nimbʉ waldpa nimba mel, “Wamp nam ndi, na nga wal pʉki kʉⱡ minda ndunum?” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Elim nga kitip kʉni wu kʉⱡ ndi, nʉk mel, “Wamp minal ndi, nim tʉk kum ronmʉn ei kʉni nakʉn ye! Nambuⱡ emel, nim ndi waldʉkʉn, ‘Wamp nam ndi, na minda ndonum nʉn?’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wote Jisas ndi, kandpa moⱡpa, wamp nam ti ndi em ei, kʉnimp nimba mong titim. ");
INSERT INTO med_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wote amp ni, elim nga itim uⱡ ni pilpa kʉn, amp ni mundmong etpa, purpur ropa omba, Jisas nga kʉmp puⱡ nila mura koptʉm ropa mondpa, Jisas kundpa uⱡ itim nimbʉ mel, kupa mendpʉⱡ nitim. ");
INSERT INTO med_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas ndi, amp ni, kundpa nimba mel, “Na nga ambuⱡa! Nim nga mondpa pili uⱡ ei ndi, nim nga kui ei wang ninim. Nim numan wang ndukʉn pi, nim nga mbun tʉtʉn uⱡ nimbʉ, akup pora ninim,” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas ni, ik ni kʉⱡ nimba moⱡnga kʉn, atinga manga rʉp wu Jairus nga mang kona ila nombuⱡa rung wu mat ndi, akil tek ok, Jairus kundʉk nʉk mel, “Nim nga mbuⱡanʉm ni, koⱡum ei ka. Nambuⱡ emel, nim ndi, ik mbo wu ei kʉn, ik ou ndukʉn nʉkʉn morun?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas ndi wu kʉⱡ nʉtʉng ik ni, kum ti natʉpa, Jairus ni, kundpa nimba mel, “Mundmong iti natkʉn, mondkʉn pili!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wote wamp nimbʉ, wak ropa muⱡʉi nimba, Pita kʉn Jeims kʉn, Jeims ʉngʉn Jon kʉⱡ mint, tʉpa mepa purum. ");
INSERT INTO med_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wu ni kʉⱡ puk, Jairus nga mang kona purung ni kʉn, Jisas ndi, kʉndrʉm mel, wamp nimbʉ, peng ambuⱡ kei nʉk, ka etʉk morung. ");
INSERT INTO med_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisas ni mukʉr mba wamp nimbʉ, kundpa nimba mel, “Nambuⱡ emel enim wamp mbʉ, ka kei nʉk enmin? Kangambuⱡa ei, kuⱡi naⱡʉm. Ambuⱡa ei, ur petʉm ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wamp nimbʉ ndi, Jisas nga nitim ik ni nga oi endilingina kʉn, wamp nimbʉ pora, tʉpa pena ndurum. Ambuⱡa ei nga tipam mam raⱡ kʉn, elim nga kitip kʉni wu raldika ni kʉⱡ kʉn, tʉpa mepa ambuⱡa ei, titim ruⱡmina nila rukʉr purung. ");
INSERT INTO med_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisas ndi, ambuⱡa ni nga ki ei ambuⱡpa, ambuⱡa ni kundpa nimba mel, “Talita kum!” ik ei nga puⱡ ei mel, “Ambuⱡa kel ye! Na ndi, nim kundʉp nʉnt, oⱡa muⱡi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tʉngʉnda mint, ambuⱡa ni oⱡa moⱡpa, nombuⱡa mam ʉndrʉm. (Ambuⱡa ni pana 12). Jisas uⱡ kʉⱡ itim ei kandʉk, numan mam ti ngorung. ");
INSERT INTO med_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wote Jisas ndi, ronduⱡ mundpa, wamp nimbʉ kundpa, uⱡ ent ei, wamp ti kundʉk ni nʉnʉi, mon! Wote nimba mel, “Ambuⱡa ei rʉng mat ngangina nangga!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas murum kona ni wak ropa, elim nga mʉi mang kona ila purum. Wote, elim nga kitip kʉni wu ni kʉⱡ, pep rok purung. ");
INSERT INTO med_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mowi kor ni kʉn, Jisas ndi, wamp mbʉ manga wingti kel ila, puⱡ mondpa, Got nga ik mbo inditim. Wamp puⱡi ila molk, Jisas nitim ik mbʉ pilik, min ngʉn mundʉk, waldʉk nʉk mel, “Wu ei, ik mbʉ nʉl mba titim? Wu ei nga pilpa kungʉndi kai ei, wamp nam ndi, mbo rundrum? Wote, uⱡ rʉpndi mbʉ, wu ei nambuⱡ etpa enim? ");
INSERT INTO med_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wu ei kamnda ni, amp Mariya kangʉm ei ni wote, wu Jeims, Josep, Juras kʉn Saimon wu kʉⱡ nga ʉngʉn ei. Wote, elim nga kimʉnʉl amp kʉⱡ, ya kona ila mormun ei ka!” Ei nʉk, wamp nimbʉ ndi, Jisas nga ik nitim nimbʉ, tʉk mbuⱡ ngurung. ");
INSERT INTO med_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Painui wu ei, kona elpa mbila wamp mbʉ ndi pora, tʉk ou ndurmin. Wote, elim nga mʉi mang kona ila wamp mbo mbʉ kʉn, elim nga tipam mamʉl mbʉ kʉn, ʉngʉnʉl kimʉnʉl na mbʉ ndi, tʉk ou ndui nandʉrmin mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jisas ni, uⱡ rʉpndi mat ila, iti natʉpa kʉn, kui rurum wamp mat, elim nga ki ei ndi, wamp nimbʉ ambuⱡnga kui nimbʉ pora nitim. ");
INSERT INTO med_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wamp mbʉ mondʉk pili napilingina, Jisas ni kandpa, min ngʉn mundrum. Wote, Jisas kona nimbila andpa, wamp nimbʉ ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","8","Jisas ndi, elim nga kitip kʉni wu 12 ni kʉⱡ, wi ropa rukʉr tʉpa, wu nimbʉ, raⱡ raⱡ nimba kʉmp tʉpa mundrum. Jisas ndi, wu ni kʉⱡ, ronduⱡ ti ngurum ei, kur kit mbʉ, tʉk munding ei nga ronduⱡ ngumba nimba mel, “Enim ping ila, enim nga mel ti, tʉk mek pi mon. Nombuⱡa mam puk ʉmbʉⱡing tʉmbʉⱡ ei mint. Rʉng nuing ti mek pi mon ku. Wal kumbana kep mon ku. Wote, ku moni na ti, mek pi nʉpʉi mon ku! ");
INSERT INTO med_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kʉmp rʉk kʉⱡ mondʉk kʉn, wote wal pʉki elpa kat pendʉk, mek pi nʉpʉi mon ku!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wote, ik ti kundpa nimba mel, “Wamp nam ti ndi, enim rawe etpa tʉm wamp ei nga manga ila mint pek molk kʉn, wote kona ei wak rʉi! ");
INSERT INTO med_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wote, enim kona peng mat ila wangina, wamp mat ndi, enim numan nganggʉk, rawe etʉk rʉk ti natʉk, enim nga ik kai ei, kum ti natʉng ndam, kona ei wak rok, enim nga kʉmp kʉnggʉpʉn mbʉ, ndanda nduk, tek kelik pʉi! Uⱡ ei ndi wamp mbʉ ora nduk, enim nga uⱡ kit mbʉ, en enim kʉn petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kitip kʉni wu ni kʉⱡ ekit puk, wamp mbʉ, ik mbo endʉk, enim nga uⱡ kit mbʉ, wak rʉi! nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wu kʉⱡ ndi, kur kit murum wamp puⱡi nga kor kit murum mbʉ, nʉk tʉk mundʉk, kui rurum wamp puⱡi kopung ndi kandʉⱡngina, wamp mbʉ nga kui mbʉ, wang nitim. ");
INSERT INTO med_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wu nuim mumuk Erot ni, uⱡ nimbʉ pora pitim. Ei Jisas nga mbi ni, ya uⱡ itim mbʉ nga kona nimbʉ ila, pora pilik kapⱡa endʉtʉng. Wote, wamp mat ndi, nʉk mel, “Jon wamp nu tindi wu ni koⱡpa, rut nim nʉtʉng. Ei nambuⱡ emel, wu ei ronduⱡ tʉpa kʉn, uⱡ min ngʉn pi mbʉ enim,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wote, wamp mat ndi, ko tʉk nʉk mel, “Wu ei Ilaija,” nʉtʉng. Wamp we mbʉ ndi, nʉk mel, “Wu ei painui wu, ya unt painui wu mat morung mbʉ nga ti,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","17","Wote, king Erot ni, ik nʉtʉng nimbʉ, pilpa nimba mel, “Wu ei Jon wamp nu tindi wu ni, nʉmp pʉnt ei ka! Ya na ndi rop peng ei puⱡa rur wu ni, aldpa koⱡpa yant omba kont morum,” nitim. Erot elim ndi nilinga, Jon imp morung. Wote Erot ndi, Jon kan ropa tʉpa kan manga ila kan ngurum. Erot uⱡ kʉⱡ itim, ei nambuⱡ emel, amp Erotiyas ei elim nga ʉngʉn wu Pilip nga ambʉm ei manggʉpa titim. Wote, amp ei ndi, Jon numan ngui ngʉnggʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Uⱡ ila, Jon ndi rʉk rʉk Erot kundpa nimba mel, “Nim ndi, nim nga ʉngʉn nga amp ei tʉk, ropʉl rokʉn tin uⱡ ei nga, kapⱡa mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wote, Erotiyas nga numan orunga, Jon ei numan ngui nganggʉpa, rop kundimp nimba pitim. Ei nga wote, rui narʉrʉm uⱡ ei, nambuⱡ emel, king Erot ndi, wu ei numan minal ngurum ei nga kandpa itim. ");
INSERT INTO med_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erot ni, Jon nga mundmong inditim. Ei nambuⱡ emel, Erot elim pitim ei, Jon ei wu kai, uⱡ kun kai mbʉ mint itim ila, elim ndi, Jon tʉpa rʉpʉndrʉm. Erot ndi, Jon nga ik ei, kum timp mint nimba pitim. Ik kʉⱡ ndi, Erot etpa numan minal nguⱡnga, wote pilpa kelpa, numan kai pilpa, rʉk rʉk Jon nga ik ei, kum mint titim. ");
INSERT INTO med_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wote, amp Erotiyas ni, Jon romba pilpa nombuⱡa mam ti kandpa titim. Ei king Erot nga metʉng ui ei, ekit urum ei kʉn, Erot ndi, rʉng mam ti kaⱡpa, elim nga gapman wu ou mbʉ kʉn, elim nga el wu mbʉ kʉn, wote Galili kona ila nga wu ou mbʉ, rʉng mundpa, “Wʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wote, amp Erotiyas nga mbuⱡam omba wʉlt ropa itim ila, Erot nga wamp orung nimbʉ pʉkʉ kandʉk, numan ndi korung. Wote, wu nuim Erot ni ndi, ambuⱡa ni kundpa nimba mel, “Nim namba mel ti numan mondʉp timp nʉkʉn pʉn? Na ndi, nim numan mondkʉn nin mel ei, nim nguimp mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ik mong ronduⱡ mbʉ nga ou ndupa, Erot ndi, mi tepa ambuⱡa ei, kundpa nitim, “Na mi tent ei, nim namba mel ti, nim numan mondkʉn wuldʉn ei nguimp mint. Wote, ya na nga tʉpa mumuk rui kona ei, rʉk ila oi ndup orunga nim nguimp ku!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wote, ambuⱡa ni pena mba, elim nga mam ni, waldpa kʉn, “Na namba mel ti ngangga namp?” nitim. Mam ndi, kundpa nimba mel, “Jon wamp nu tindi wu ei nga peng,” ei nitim. ");
INSERT INTO med_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ambuⱡa ni, tʉkrʉpa yant omba kʉn, king ni, waldpa nimba mel, “Na Jon wamp nu tindi wu ei nga peng ei, numan mondunt. Nim ndi, akup ant ila mendpʉⱡ, plet tila rʉk ndukʉn, mek okʉn ngui!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ik ei ndi, etpa wu mumuk ni, ama mbun ngurum. Ei wote, elim ndi, wamp rʉng ruing ok, morung wamp mbʉ, mi tepa nitim uⱡ ei ndi, ambuⱡa ei, kundpa mon nimba ei nga, nombuⱡa mam ti, ti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wote, king ni ndi, elim nga el wu ti tʉpa mundpa, nimba mel, Jon nga peng ei, mekʉn ui nitim. El wu ni, kan manga nila mba kʉn, Jon nga peng ni, ropa koⱡmung itim. ");
INSERT INTO med_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wote, el wu ni ndi, Jon nga peng ni, plet ila mepa omba ambuⱡa ni nguⱡnga. Wote, ambuⱡa ni ndi, tʉpa mam ni ngurum. ");
INSERT INTO med_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wote, Jon nga kitip kʉni wu ni kʉⱡ ndi, Jon rorung ik ei pilik kʉn, wu kʉⱡ ok, Jon nga on ei, tʉk mek puk, wamp on kona tila on etʉng. ");
INSERT INTO med_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas elim nga kitip kʉni wu ni kʉⱡ, andʉk yant ok, en enim uⱡ etʉng mbʉ kʉn, wamp ik mbo rondʉk etʉng nimbʉ mel, Jisas kondʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kona ila wamp ama puⱡi ok, puk mint etʉng ila, Jisas kʉn elim nga kitip kʉni wu kʉⱡ kʉn, muⱡ tʉk rʉng nok i iti natʉtʉng. Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Tʉn akup kona waka tila, tʉn tʉn mbun kʉn, en enim muⱡ teing,” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wote, wu ni kʉⱡ, nu kanu ni kʉⱡ ila, en enim mint kona waka nila purung. ");
INSERT INTO med_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wamp minal ndi, wu purung kʉⱡ, wu namin nʉk, kandʉk poⱡ ndʉmin nʉk, kona peng elpa elpa mbila wamp ok. Jisas kʉn elim nga kitip kʉni wu kʉⱡ kʉn, uing kona ila elpa elpa kuimp tek puk, nokundʉk morung. ");
INSERT INTO med_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wote Jisas ni, nu kanu ila ekit omba kʉndrʉm mel, wamp minal ok morung. Wamp nimbʉ kanduⱡnga mel, elim nga mundmong orunga kont minal itim. Nambuⱡ emel, wamp kʉⱡ ya kng sipsip na ti, rʉp wu mon etʉm ni mel, etʉk mormin kant ei ka, nimba pitim. Wote, ila moⱡpa kʉn, wamp mbʉ ik puⱡi mbo inditim. ");
INSERT INTO med_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Wote, kona ant ei mana puⱡnga, elim nga kitip kʉni wu ni kʉⱡ ndi ok, Jisas kundʉk nʉk mel, “Kona ant ei mana pum ei ka. Wote kona ila, wamp kat kep, pi napʉtmin kona kui waka ei nga, wamp mbʉ pʉi nʉkʉn mundi. Wamp mbʉ pʉi nana puk, kongun kona na, wamp pek eng kona nondpa tem mat ila, puk rʉng na mat, rarʉp rok kandʉk tʉk neing,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisas ndi, punt ropa nimba mel, “En enim ndi, wamp mbʉ rʉng mat ngʉi!” nitim. Wote, wu nimbʉ ndi, int nduk waldʉk nʉk mel, “Nim ndi, tʉn kapⱡa ku moni 200 kina mel wak ropʉn, bret tʉpʉn, wamp mbʉ ngamina, nuing nʉkʉn pilkʉn nʉn ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wote Jisas ndi, wu kʉⱡ waldpa nimba mel, “Enim bret namba iti tek mormun? Puk kʉnʉi!” Wote, wu ni kʉⱡ ndi, kandʉk kʉn, Jisas kundʉk nʉk mel, “Bret tʉmbʉkak pʉmp ti pip, omba oma raⱡ tetʉm ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ kundpa nimba mel, “Wamp mbʉ tʉk mou elpa elpa rondʉk, mana numa pana ila mana muⱡʉi nʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wote, wamp nimbʉ 100 nʉk, 50 nʉk, mou rok elpa elpa morung. ");
INSERT INTO med_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wote Jisas ndi, bret ni kʉⱡ kʉn, oma ni raⱡ kʉn, ambuⱡpa moⱡpa tʉpa oⱡa ndupa, muⱡ ei kandpa, Got kʉn angge nimba atinga rurum. Wote elim ndi, bret nimbʉ, puk ropa tʉpa, elim nga kitip kʉni wu ni kʉⱡ ngurum. Wu ni kʉⱡ ndi, mek andʉk, wamp mbʉ ngurung. Wote Jisas ndi, oma ni raⱡ i ku etpa, puk ropa pendpa, wamp nimbʉ ngurum. ");
INSERT INTO med_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wamp nimbʉ pora, rʉng nok kapⱡa endilingina, pʉlʉng uⱡ itim. ");
INSERT INTO med_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wote, kitip kʉni wu ni kʉⱡ ndi, bret na, oma na noⱡina, mana titim nimbʉ, tʉk kowʉ wal 12 mel rok peka rondrung. ");
INSERT INTO med_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Rʉng ila molk norung ei, wu 5000 ei mel molk norung. ");
INSERT INTO med_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wote, rʉng nok pora nduⱡungina, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, tʉpa nu kanu ni kʉⱡ ila, rukʉr ndupa kuimp tek Betseita kona num noi orunga ila, pʉi nimba mundrum. Wote, elim moⱡpa, wamp nimbʉ ndi, pʉi nimba mundrum. ");
INSERT INTO med_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wu nimbʉ pʉi nimba mundpa kʉn, Jisas ni, komnga tila oⱡa mba atinga rurum. ");
INSERT INTO med_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wote kona ni, epindama elinga, nu kanu ni kʉⱡ, num rʉk mil ila, kun purum ni kʉn, Jisas ni, elim mendpʉⱡ ya orunga mʉi nila murum. ");
INSERT INTO med_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Jisas ni, kʉndrʉm mel, elim nga kitip kʉni wu ni kʉⱡ morung. Nu kanu ni kʉⱡ kʉpkʉ ndi, ropa noi ya elinga, tʉp kun mundmin nʉk etʉng. Wote, kona rangimba pilpa, min titim ei kʉn, Jisas ni, wu ni kʉⱡ morung nila, nu ndi, pol ila oⱡa urum. Jisas ni nondpa omba, wuldʉng mba elinga, wu ni kʉⱡ ndi, kandʉk nʉk mel, “Kur ti!” nʉtʉng. Nʉk pilik, kei nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wote, wu nimbʉ pora, Jisas kandʉk mundmong etʉng. Ni kʉn, Jisas ndi, kundpa nimba mel, “Mundmong iti nʉtʉi! Na ont ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","I nimba kʉn, Jisas ni, elim nga kitip kʉni wu kʉⱡ, nu kanu morung ni kʉⱡ ila, omba oⱡa puⱡnga, kʉpkʉ ni, tʉngʉnda mint kʉr nitim. Ni kʉn, kitip kʉni wu ni kʉⱡ ndi, Jisas kandʉk kʉn, rut nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nambuⱡ emel, wu kʉⱡ ndi, Jisas ukʉ orunga, bret kʉmp tʉpa ngurum uⱡ ni, tʉk mindi namindʉtʉng. Ei nambuⱡ emel, wu kʉⱡ nga en enim nga numan orunga piral ni nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wu ni kʉⱡ num ni puⱡa rok, ya Genesaret kona orunga ok, nu kanu ni kʉⱡ nu ila, kan kolk pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wote, wu ni kʉⱡ, nu kanu ni kʉⱡ, wak rok ekit orung ni kʉn, wamp nimbʉ ndi, Jisas ni unt kandʉk poⱡ ndurʉng. ");
INSERT INTO med_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wote wamp nimbʉ, tʉkrʉk kona nimbila pora puk, en enim nga rupⱡaima ila, kui wamp nimbʉ mek, Jisas kona nant ila murum pʉtʉng kona nila orung. ");
INSERT INTO med_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas wamp manga rʉⱡaip anggʉtʉm kona mbila muna, kona peng kel mbila muna, pana kongun kona mbila muna, en enim nga kui wamp mbʉ mek, mel rarʉp kona mbila elpa elpa tek molk, Jisas waldʉk, kui wamp kʉⱡ ndi, Jisas elim nga muⱡ punt kʉⱡ minda angina, ndʉng ndam, wamp mbʉ, nga kui mbʉ wang nimba nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Perisi wu mat kʉn, mi ik mbo wu mat kʉn, Jerusalem kona molk ok, Jisas murum nila ok, tʉk polk etʉk morung. ");
INSERT INTO med_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wu nimbʉ kandrung mel, Jisas nga kitip kʉni wu nimbʉ ndi, en enim nga rʉng nimbʉ, ki ⱡar pʉkʉ norung, ki mbʉ ⱡumʉi rui narʉrʉng. Uⱡ ei, Perisi wu mbʉ ndi, itʉi nʉtmʉn uⱡ ei mel iti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ya wu Perisi na, Jura wamp wei mbʉ pʉkʉ, en enim wu anda kouwʉmin mbʉ ndi, ik mbo endʉk nʉk mel, rʉng nuing etʉk kʉn, kuimp tek ki ⱡumʉi rok kai etʉk kʉn, wote rʉng nʉi nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wote, uⱡ mat etʉng mbʉ, rʉng rarʉp rok tʉtʉng mbʉ, nuing pilik kuimp tek, ki ⱡumʉi mint rorung! Wote, mi ik unt nga mat, pep rorung mbʉ, ya kap na, nu ming na, rʉng nuing pilik morung rat pol na mel mbʉ, ⱡumʉi rok kai mint etʉng. ");
INSERT INTO med_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wote, Perisi wu mbʉ kʉn, mi ik mbo wu na mbʉ ndi, Jisas waldʉk nʉk mel, “Nambuⱡ emel, nim nga kitip kʉni wu kʉⱡ ndi, tʉn nga anda kouwʉmin kʉⱡ nga man ngurung ik mbʉ, pep rui narʉk, rʉng mbʉ ki ⱡar pʉkʉ nonmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas ndi, punt ropa nimba mel, “Painui wu Aiseiya ndi, enim wamp mbʉ, ik kol rormʉn,” nitim. “Ei enim keta kʉng ila, ik nʉtmʉn wu nimbʉ nimba kʉn, mon ropa mundrum, ‘Wamp rʉⱡaip kʉⱡ ndi, enim nga numan ei mek puk, ronggʉt elpa tek na nga mbi ei, keta kʉng ila mint paka rondʉrmʉn. ");
INSERT INTO med_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wote, wamp mbʉ ndi, mʉi kona ila wamp nga mi ik mim etʉng mbʉ pilik, Got nga mi ik kupa ei, nʉk pilik wamp mbʉ, mbo rondurmʉn. Wote, Got nga mbi paka runding uⱡ ei iti natʉk. En enim wamp nga mi ik ei, mint pep rormʉn.’ ");
INSERT INTO med_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Enim Got nga mi ik kʉⱡ wak rok, mʉi kona wamp nga ik mong kʉⱡ pep ronmʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wote Jisas ndi, nimba mel, “Enim pilik kai etʉk, Got nga mi ik mong ei, wak rok, en enim nga anda kouwʉmin mbʉ nga uⱡ etmin mbʉ pep ronmʉn. ");
INSERT INTO med_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses nga mi ik mong ndi, nimba mel, ‘Nim nga tipanʉm manʉm raⱡ tʉkʉn ou ndui. Wamp nam ti ndi, elim nga tipam mam raⱡ nimba kit mondum ndam, wamp ei rok kunding,’ nitim. ");
INSERT INTO med_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Wote, ya enim ndi, ik mbo rondʉrmin ei, wu ti mel mat tepa moⱡum ndam, wu ei ndi, kapⱡa mel mbʉ ndi, elim nga tipam mam raⱡ kep, tʉpa rapʉndʉmba. Wote, wu ei ndi, wamp raⱡ kundpa nimba mel, ‘Mel kʉⱡ oi ndup elpa tent kʉⱡ, Got nga mendpʉⱡ,’ nʉtʉm. Uⱡ ei ndi, tipam mam raⱡ tʉpa rapʉndʉk napʉndʉmba ei nga tʉpa ora ndurum. ");
INSERT INTO med_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ik mong ila, enim ndi, wamp ik mbo ronduⱡina kʉn, Got nga ik mong ei, wak rormʉn. Wote, uⱡ i etpa mat ou ndupa enim etmin ku,” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wote Jisas ndi, wamp minal morung nimbʉ, aldpa wi ropa rukʉr tʉpa kundpa nimba mel, “Na nga ik i, enim wamp pora kum tek, pilik kai itʉi! ");
INSERT INTO med_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tʉn nga rʉng mat normʉn kʉⱡ ndi, tʉn etpa kit mundi namʉndrʉm. Wote rʉng mat, wamp nga numan rukʉr orunga, pepa ekit orum kʉⱡ ndi, wamp ei etpa kit mondrum. ");
INSERT INTO med_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Enim kum nombuⱡa tem ndam, ik ei kum tek pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wote Jisas ni, wamp minal morung nimbʉ, wak ropa omba, manga ila murʉk puⱡnga kʉn, elim nga kitip kʉni wu ni kʉⱡ ndi, Jisas ik ek rurum ei nga puⱡ ei, nimba ngangga, nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisas ndi, wu ni kʉⱡ kundpa nimba mel, “Enim pilik kai iti natʉnmin ei? Ya wamp mat iting ei mel, enim enmin ei ka! Mel mat ekit orunga tepa rukʉr purum mbʉ ndi, wamp etpa kit mundi namʉndrʉm. ");
INSERT INTO med_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nambuⱡ emel, mel kʉⱡ ndi, wamp nga mundmong ila rukʉr pi napʉrʉm. Mel kʉⱡ ndi, wamp nga te pilʉng ila mba, ti raⱡpa omba ekit purum.” (Jisas i nitim uⱡ ei ndi, rʉng mbʉ pora, kapⱡa nuing mint nitim.) ");
INSERT INTO med_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wote Jisas ndi, nimba mel, “Wamp nga numan rukʉr orunga, pepa ekit orum mel kʉⱡ ndi, wamp ei etpa kit mondrum. ");
INSERT INTO med_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Wamp ti nga mundmong rukʉr orunga pepa, ekit orum uⱡ kʉⱡ ndi, numan kit mbʉ mbo ronduⱡnga, uⱡ kit mbʉ mint etmin. Wote kindʉp nombun, wamp rop kondpʉn, wu amp kandpa kum pindi uⱡ ei kʉn, wamp ti nga mel ei, kandʉp kum pindi uⱡ ei etpʉn, uⱡ kit mbʉ etʉk, ik kol ropʉn, kara mbun etmin, wamp mat nga ik mbuldung orunga nʉndʉk, meka rok, numan mbo pi nʉpi wamp mel raⱡpʉn etmin. ");
INSERT INTO med_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Uⱡ kit mbʉ ndi, wamp nga numan rukʉr orunga, tepa ekit omba wamp nga numan etpa kit mondrum.” ");
INSERT INTO med_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wote Jisas ndi, kona ni wak ropa mba, Taiya kona peng ou nila nondpa purum. Jisas manga tila mukʉr mba wamp na ti ndi, elim murum kona ei, pili napʉlʉng nimba pitim. Ei wote, mo ropa moⱡmba mel kapⱡa mon itim. ");
INSERT INTO med_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ni kʉn, amp ti, elim nga mbuⱡam ambuⱡa ei, kur kit rukʉr orunga murum. Ei ndi, Jisas nga timan ik ei pilpa kʉn, omba Jisas nga kʉmp puⱡ nila rumʉⱡi pitim. ");
INSERT INTO med_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Amp ei, Grik amp ei, wote Siriya Ponisiya kona ila metʉng. Amp ei ndi, Jisas waldpa nimba mel, elim nga mbuⱡam ambuⱡa ei nga kur kit morum ei, tʉpa mundangga nitim. ");
INSERT INTO med_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wote Jisas ndi, amp ni, kundpa nimba mel, “Tʉn kangambuⱡa kʉⱡ rʉng unt kuimp tepʉn ngamʉn. Kangambuⱡa kʉⱡ nga rʉng mbʉ, roldʉp tʉpʉn, owa mbʉ nguimin mel kapⱡa mon,” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Amp ni ndi, nimba mel, “Nuim ye! Ei, kupa nʉn ei nga, wote owa mbʉ ndi, kangambuⱡa mbʉ rʉng noⱡina, gurpa nde pol ila mana purum mbʉ, kapⱡa nuing mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wote Jisas ndi, amp ni, kundpa nimba mel, “Nim nga ik mong punt ron ei kʉn, nim mang kona pi! Pukʉn kʉn, kur kit ni, nim nga ambuⱡa ei, wak ropa omba ekit pum!” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Amp ni, mang kona mba kʉndrʉm mel, kur kit ni, ambuⱡa ni, wak ropa, omba ekit puⱡnga, ambuⱡa ni rupⱡaima nila ur pitim. ");
INSERT INTO med_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas ni, Taiya kona ruk ting ni wak ropa, Sairon kona mba, num Galili nila purum. Kona peng 10 tetʉm kona ila purum. ");
INSERT INTO med_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ni kʉn, wamp mat ndi, wu ti kum ngumba, ik mindil ngumba nitim ni mek ok, Jisas waldʉk kʉn, elim nga ki ei ndi, wu ei ʉmbʉⱡangga nʉk mek orung. ");
INSERT INTO med_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wote Jisas ndi, wamp minal morung nimbʉ, muⱡeing nimba mondpa, wu ni mint tʉpa mepa, elim nga ki ruⱡ ni ndi, wu ni nga kum nombuⱡa nila ʉmbrʉm. Wote, ol ropa kʉn, wu ni nga keta anmbil ni minda ndurum. ");
INSERT INTO med_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Wote Jisas ni, tʉpa oⱡa ndupa, wi muⱡ ni kandpa kʉn, muⱡnga tʉpa i etpa, nimba mel, “Epaata!” Ik ei nga puⱡ ei mel, “Kum ei pilaⱡa nangga!” nitim. ");
INSERT INTO med_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tʉngʉnda mint, wu ni ik pilpa wote, elim nga kum ni pilaⱡa nilinga, wote keta anmbil ni pinda nilinga wu ni, ik puⱡ mondpa nitim. ");
INSERT INTO med_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wote Jisas ndi, wamp mbʉ kundpa, “Uⱡ ei nga wamp mat kundʉk ni nʉnʉi mon!” nitim. Ni kʉn, pilik kelik wamp ou ndupa ndi, wamp mat kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wote, wamp mbʉ pilik min ngʉn mundʉk, “Wu ei uⱡ kai kʉⱡ nambuⱡ etpa enim! Wote, uⱡ kʉⱡ elinga, wamp kum ngui mbʉ ik pilik, ik ni nandʉtmʉn wamp mbʉ, ik nʉnmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Rumbʉⱡ mat omba puⱡnga, aldpa wamp minal orung. Wote wamp nimbʉ, rʉng nuing mat mon elinga, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, wi ropa rukʉr tʉpa kundpa nimba mel, “Na wamp kʉⱡ nga kont enim. Ei nambuⱡ emel, wamp kʉⱡ na kʉn rumbʉⱡ raldika muⱡmʉn ni nga, wote rʉng nuing mat ti natʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wote na ndi, rʉng ngui nganggʉp, wamp kʉⱡ wak rop mundunt ndam, wamp mat kona ruⱡ mbila ong mbʉ, nombuⱡa rʉk ting ila pangina, kump kun ndi, kump ambuⱡpa ropa mundʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Elim nga kitip kʉni wu ni kʉⱡ ndi, elim waldʉk nʉk mel, “Kona waka wei ila, wamp nam ti ndi, rʉng kandpa tʉpa, wamp mbʉ ngumba kapⱡa endʉmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas ndi, waldpa nimba mel, “Enim bret namba iti tek mormun?” nitim. Wu ni kʉⱡ ndi, punt rok nʉk mel, “Bret 7 tep mormun,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisas ndi, wamp minal morung nimbʉ, nimba mel, “Mana muⱡʉi!” nitim. Wote, bret 7 ni kʉⱡ tʉpa, Got kʉn angge nimba, ambuⱡpa pok ropa, elim nga kitip kʉni wu nimbʉ ngumba. “Wamp mbʉ tʉk ngʉi!” nitim. Wote, kitip kʉni wu ni kʉⱡ ndi, wamp nimbʉ mok rok ngurung. ");
INSERT INTO med_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wote, wu ni kʉⱡ, oma onunga kʉralt kunda ku tek morung. Ni kʉn, Jisas ndi tʉpa, Got kʉn oma kʉⱡ nga angge nimba, elim nga kitip kʉni wu ni kʉⱡ kundpa nimba mel, “Oma kʉn, kunda ngʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","10","Wamp 4000 mel morung nimbʉ pʉkʉ, rʉng nok kapⱡa endʉtʉng. Wote, kitip kʉni wu ni kʉⱡ ndi, wamp rʉng noⱡina, mana titim nimba, tʉk kowʉ wal 7 mel rok peka rondrung. Jisas ndi, wamp minal nimbʉ pʉi nimba mundpa, elim nu kanu nila omba oⱡa mba, elim nga kitip kʉni wu ni kʉⱡ kʉn, Dalmanuta kona ila purung. ");
INSERT INTO med_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Perisi wu mat ndi, Jisas kʉn ok, puⱡ mondʉk, ik ou nduk nʉtʉng. Wu kʉⱡ ndi, Jisas oⱡa tʉp kʉnmin nʉk pilik, Jisas waldʉk uⱡ rʉpndi mat itangga kandpʉn kʉn, Got elim ndi, tʉpa mundrum wu ti, nimp pilmin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wote Jisas ndi, elim nga numan orunga, mbun tʉpa nimba mel, “Nambuⱡ emel, wamp kʉⱡ ndi, akup ant ila, uⱡ rʉpndi mat nga waldʉnmʉn? Mon! Na enim ik kupa ei kundʉp nʉnt, ‘Na ndi uⱡ rʉpndi ti akup ant ila tʉp ora ndui nʉndimp mon!’” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wote Jisas ndi, wamp nimbʉ, wak ropa kelpa mba, nu kanu nila oⱡa mba, num ni puⱡa ropa mba, nu ʉldʉ noi orunga purum. ");
INSERT INTO med_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kitip kʉni wu ni kʉⱡ ndi, tʉk apra nduk, bret mat wote, nuing ei nga pendʉk, mek ui nawʉrʉng. Bret tenda ti mint, nu kanu nila titim. ");
INSERT INTO med_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wote Jisas ndi, elim nga wu ni kʉⱡ, ronduⱡ mundpa, kundpa nimba mel, “Kandʉk kun etʉk muⱡʉi! Enim ya Perisi wu kʉⱡ nga yis mel, uⱡ etmin kʉⱡ kʉn, wote Erot nga yis mel, enim kʉⱡ kʉn, enim kʉn rukʉr omba ei nga tʉk mendʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wu ni kʉⱡ en enim ndi, ik palk, int yant etʉk nʉk mel, “Jisas ndi, ik i etpa ninim ei, nambuⱡ emel, tʉn bret mat mon. Ei nga ninim nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas ndi wu kʉⱡ nga ik nʉtʉng ni pilpa kʉn, wu kʉⱡ waldpa nimba mel, “Nambuⱡ emel, enim na palk nimin. Enim bret mon ei nga nimin nda? Enim pilik kun iti natʉk, kandʉk kai iti natʉnmʉn ei? Enim numan ti kep, mon ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Enim mong anggʉtʉm ant ko, wote enim kʉni nakʉnmin ei? Wote, enim kum anggʉtʉm ant ko, wote enim pili napʉnmʉn ei? Enim na ndi, bret 5 pok rop tʉp wamp 5000 ngur ni, tʉk mindi namʉndʉnmʉn ei? Wote, rʉng mana titim mbʉ nga kowʉ wal, namba iti enim rakʉlʉngina peka rurum?” nitim. Wote, wu ni kʉⱡ ndi, punt rok nʉk mel, “Kona wal 12,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wote Jisas ndi, nimba mel, “Na ndi bret 7 pok rop tʉp, wamp 4000 ngur ei kʉn, rʉng mana titim mbʉ nga kowʉ wal, namba iti tʉk rakʉtʉng?” nitim. Wu ni kʉⱡ ndi, punt rok nʉk mel, “Wal 7,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wote Jisas ndi, waldpa nimba mel, “Akup ei kʉn, enim pilik kai iti natʉnmʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wu ni kʉⱡ, Betseita kona nila oⱡungina, wamp mat ndi, wu mong titim ti mek, Jisas kʉn orung. Jisas ndi, wu ei ki ei ndi, minda ndangga nʉk, kont it ik ranggʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas ndi, mong ti wu ni, manga rʉⱡaip ei, wak ropa, ki ambuⱡpa mepa ekit purum. Wote, ol ropa tʉpa, wu ni nga mong nila mondpa, elim nga ki ni raⱡ tʉpa, wu ni nga mong raⱡ ila ambuⱡpa, wu ni waldpa nimba mel, “Nim mel mat kan ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wote wu ni, tʉpa oⱡa ndupa kandpa kʉn nimba mel, “Wote, na wamp mbʉ kant ei, nde mel nombuⱡa andʉk, pok pok enmin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas aldpa elim nga ki ni raⱡ tʉpa, wu ei nga mong pol ila oⱡa titim. Wote ei kʉn, wu ni ronduⱡ mondpa, kʉndrʉm ei kʉn, mong ni raⱡ omba kapⱡa elinga, mel nimbʉ, kandpa mbi ndurum. ");
INSERT INTO med_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wote Jisas ndi, wu ni ronduⱡ mundpa, kundpa nimba mel, “Nim mang kona int pi! Wote, manga rʉⱡaip moⱡʉp, onmbʉⱡ kona nila, pi nʉpi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wote, Jisas kʉn elim nga kitip kʉni wu kʉⱡ kʉn puk, Sesariya Pilipai manga rʉⱡaip ila nondpa purung. Nombuⱡa mam rʉk ting ila puⱡʉngina, Jisas ndi, wu ni kʉⱡ waldpa nimba mel, “Wamp mbʉ ndi, na kundʉk, wu nam ei nʉtmʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Elim nga kitip kʉni wu ni kʉⱡ ndi, punt rok nʉk mel, “Wamp mat ndi, nimba nʉk mel, ‘Nim wamp nu tindi wu Jon ei,’ nʉtmʉn. Wamp mat ndi, ‘Nim wu Elaija,’ nʉtmʉn. Wamp mat ndi, ‘Nim painui wu mbʉ nga ti,’ nʉtmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Wote, enim wu kʉⱡ ndi, na nam nʉk pʉnmʉn?” Jisas ndi, wu nimbʉ waldpa. Ni kʉn, Pita ndi, punt ropa nimba mel, “Nim Got nga ngurum wu Kraist ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wote Jisas ndi, wu ni kʉⱡ kundpa nimba mel, “Wamp ti, na Kraist nʉk kundʉk ni nʉnʉi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wote Jisas ndi, puⱡ mondpa, elim nga kitip kʉni wu kʉⱡ ik mbo endpa, nimba mel, “Muⱡʉⱡ Wu Kupa oⱡa mana urum ei, mindil ou ndupa nomba. Wote, manga wingti rʉp wu kʉn, Pris kʉⱡ nga wu kuimbal mbʉ kʉn, mi ik mbo wu mbʉ kʉn, wu ei tʉk mbuⱡ ngangina, rok kundangina koⱡmba. Wote, rumbʉⱡ raldika omba pangga, wu ei, ⱡoporpa kont moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas ndi, ik kʉⱡ nimba piral ndupa, wu kʉⱡ ngurum. Wote Pita ndi, Jisas tʉpa mepa kona ʉldʉ tila mba, ik ronduⱡ mundpa nitim. ");
INSERT INTO med_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wote Jisas ndi, tʉpa ropʉl ropa, elim nga kitip kʉni wu ni kʉⱡ kandpa kʉn, Pita ik ronduⱡ mundpa nimba mel, “Na pa, kur Seitan ye!” nitim. Jisas ndi, nimba mel, “Nim nga numan ei, Got kʉn ui nawʉnʉm mon! Ya mʉi ila wamp mbʉ nga numan ila pilkʉn nʉn!” nitim. ");
INSERT INTO med_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wote Jisas ndi, wi ropa wamp nimbʉ kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, kundpa nimba mel, “Wamp nam ti, na kʉn uimp nimba pilim ndam, elim nga nimba pili napilpa, elim nga nde peta ei, koma ropa mepa, na kʉn pep ropa wangga! ");
INSERT INTO med_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wote, wamp nam ti, elim nga kʉng ei nga mint nimba pilim ndam, wamp ei kont mba muⱡ uⱡ ei, wak romba. Wote, wamp nam ti, elim nga kʉng ei kʉn, na nga rʉnang ik kai kʉⱡ kʉn, na nga nimba wak rom ndam, elim nga kont mba mul uⱡ ei, wak rui narʉmba mon. ");
INSERT INTO med_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wamp nam ti ndi, mʉi kona ila mel mbʉ numan ngumba. Elim nga kont mba mul uⱡ ei, wak rom ndam, mʉi kona mel mbʉ ndi, elim tʉpa rapʉndʉmba mel nant? ");
INSERT INTO med_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wote, namba mel ti ndi, ya wu ei nga kont mba mul uⱡ ei, rop ropa yant tʉmba nda? ");
INSERT INTO med_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wote, wamp nam ti ndi, uⱡ kit mbʉ eng kona mbila kep, Got numan ngui nganggʉrmʉn kona mbila kep, na nga ik mong ei, nimba ngumba ei nga pipil kuⱡum ndam, Muⱡʉⱡ Wu Kupa oⱡa mana urum wu ei, Got nga uⱡ eng nui mbila moⱡpa, anggelo wingti mbʉ kʉn, yant om ei kʉn, wamp ei pipil kuⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wote Jisas ndi, wamp nimbʉ kundpa nimba mel, “Na enim ik kupa ei, kundʉp nʉnt. Ya ila wamp mormin mbʉ nga mat kuⱡi ralk, kont molk kʉnangina, Got nga wamp tʉpa mumuk rui uⱡ ronduⱡ mbʉ, kʉmp kum mepa omba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wote, rumbʉⱡ 6 omba puⱡnga kʉn, Jisas ndi, Pita, Jeims, Jon kʉn tʉpa mepa komnga mong tila oⱡa purum. Wote, en enim kou morung. Wote, wu ni kʉⱡ molk kandrung mel, Jisas ni, kʉng elpa ti mel tʉpa kurum. ");
INSERT INTO med_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wote, Jisas nga muⱡ nimbʉ, eng omba kurʉmʉⱡa itim. Ei ya mana mʉi kona ila wamp na ti ndi, mul mbʉ ⱡumʉi roⱡina, i iti natʉtʉm ei mel itim. ");
INSERT INTO med_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wote, kitip kʉni wu raldika ni kʉⱡ kandrung mel, Elaija kʉn Moses raⱡ Jisas kʉn ik nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ndi, Jisas kundpa nimba mel, “Ik mbo wu ye! Tʉn uⱡ kai ti ni etpʉn ombʉn ya ila moⱡmʉn. Tʉn ndi, muⱡ manga raldika kat rakpʉn, ti nim nga, ti Moses nga, wote ti Elaija nga,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita ndi, ik i nitim, ei nga, wu kʉⱡ ama mundmong etʉk, ik ti ning ei nga pilik rundrʉng. ");
INSERT INTO med_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wote, kupa kat omba kʉn, wu ni kʉⱡ tʉpa kun rurum. Kopa nila, ik mong ti nimba mel, “Ya ei, na nga kangʉm aⱡʉm ei, wu ei nga ik ei, kum tiyʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wote, wu ni kʉⱡ nondpa tʉk ropʉl rok kandrung mel, wamp na ti, kʉni nakʉndrʉng. Jisas mint en enim kʉn murum. ");
INSERT INTO med_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wu ni kʉⱡ, komnga mong nila mana orung ni kʉn, Jisas ndi, wu ni kʉⱡ kundpa nimba mel, “Ya enim kanmin uⱡ ni kʉⱡ wamp na ti kundʉk ni nʉnʉi mon! Pilik muⱡangina, tʉnggʉt Muⱡʉⱡ Wu Kupa ei, koⱡpa tikil rom ei kʉn, ik ei nʉk mot ndʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wu ni kʉⱡ Jisas nga nitim ik ni, kum tek wote, en enim ik nʉk int yant etʉk nʉk mel, “Koⱡpa tikil rui uⱡ ei nga puⱡ ei, namba uⱡ ti nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wote wu ni kʉⱡ ndi, Jisas waldʉk nʉk mel, “Nambuⱡ emel, mi ik mbo wu kʉⱡ ndi, nʉk mel, Elaija ei kuimp tepa omba nʉtmin?” ");
INSERT INTO med_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas ndi, ik ei punt ropa nimba mel, “Elaija ei kupa kuimp tepa omba kʉn, mel mbʉ tʉpa kun etmba. Ei nga nambuⱡ emel, Got nga rʉnang ik kai ei ndi, nimba mel, Muⱡʉl Wu Kupa ei, mindil mam ei nangga, wote tʉk mbuⱡ ngok iting? ");
INSERT INTO med_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na enim kundʉp nʉnt, Buk Wingti ei ndi, wu ei nga nʉndʉtʉm ni mel. Elaija ya unt urum. Wote, wamp mbʉ ndi, namba uⱡ mat etʉng ei nga, en enim ndi itmin nʉk pʉtʉng ei mel ku etʉng,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wote ok, kitip kʉni wu kat kandrung mel, wamp ama puⱡi ndi, wu kʉⱡ morung kona nila tʉk pok etʉng. Wote, ila nga mi ik mbo mat ndi, wu kʉⱡ kʉn, ik mat tek rombulk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wote, wamp nimbʉ ndi, Jisas urum ila, kandʉk, ama rut nʉk, tʉkrʉk puk, rawe etʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, waldpa nimba mel, “Enim nambuⱡ emel, ik mura mel wu kʉⱡ kʉn enim?” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wamp minal morung nimbʉ nga wu ti ndi, punt ropa nimba mel, “Ik mbo wu ye! Na nga kang ei kur kit rukʉr orunga moⱡnga, ik ni nandʉtʉm ei nga, nim kʉn mep ont. ");
INSERT INTO med_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wote, ui mat kʉn, kur kit nga ui ei orum ei kʉn, kang ei ropa munduⱡnga, mʉi ila mba pelinga, keta paip mepa gu mbʉ rʉndʉⱡ mong nomba. Wote kʉng mbʉ, ama ronduⱡ tʉpa ngʉngʉn ndurum. Wote na ndi, nim nga kitip kʉni wu kʉⱡ, kundʉp kur kit ei, tʉk mundʉi nʉnt. Ei kʉn wote, wu kʉⱡ ndi, kapⱡa iti nʉting mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas ndi, ik ei pilpa, wamp nimbʉ kundpa nimba mel, “Enim wamp mbʉ nga mondpa pili mat mon! Na enim kʉn moⱡʉp, ik mbo endʉp, namba iti endʉt. Ui namba iti, na ndi, enim nga mbun koma rundimp? Kang ei, mek ya na kʉn wʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wote, kang ni mek, Jisas kʉn oⱡʉngina, wote kur kit ni, Jisas kandpa kʉn, kang ni tʉngʉnda ropa munduⱡnga, mba mʉi nila pepa purⱡi marⱡi anduⱡnga, keta paip mbʉ, elim omba purum. ");
INSERT INTO med_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Nant kʉn, kang ei uⱡ ei mel itim?” nimba, Jisas ndi, kang ei nga tipam wuldʉtʉm. Wu ni ndi, punt ropa nimba mel, “Ama, kor nga kang kel kʉn itim. ");
INSERT INTO med_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wote, ui mat ou ndupa, kur kit ei ndi, kang ei rop kundimp nimba pilpa kʉn, ropa tʉpa ndip na, nu na mbila, rʉk ndumba itim. Wote nim ndi, kapⱡa nʉkʉn pin ndam, nim ndi, tʉn kont kulkʉn tʉkʉn rupʉndi,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas ndi, nimba mel, “Wote, wamp nam ti ndi, Got kun mondpa pilim ndam, mel mbʉ pora, kapⱡa iting mint,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wote, kang ni nga tipam ndi, ka etpa mindil tʉpa nimba mel, “Na kupa mondʉp pʉt ei nga, wote onunga kot kapⱡa mon. Nim ndi, na tʉkʉn rapundkʉn na nga mondpa pili ei ronduⱡ nga!” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas ndi, kʉndrʉm mel, wamp ama puⱡi ok mʉk rok, en enim tʉk kum ruing elingina, kur kit ni kundpa nimba mel, “Nim keta mum kʉn, kum ngui kur ei, na ndi nim kundʉp nʉnt, ‘Nim kang ei, wak rokʉn kelkʉn ekit ui!’ Wote aldpa okʉn, rukʉr pi nʉpi mon,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kur kit ni, kei nimba kang ni, ronduⱡ ropa monduⱡnga, wote kang ni, wak ropa, elim kelpa ekit urum. Kang ni, koⱡpa mel titim. Wamp mbʉ ndi, kʉmp kʉm nʉk mel, “Kang ni konum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wote Jisas ndi, kang ni, ki ambuⱡpa tʉpa rapundpa, oⱡa tilinga, oⱡa ʉnggʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wote Jisas ni, omba manga tila mukʉr moⱡnga kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn mint molk, elim waldʉk nʉk mel, “Nambuⱡ emel, tʉn ndi, kur kit ni, tʉpʉn ekit ndui nʉndmʉn?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas ndi, punt ropa nimba mel, “Atinga rui uⱡ ila mendpʉⱡ, kapⱡa tʉk munding, wei uⱡ tila kapⱡa mon,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, kona ni, wak rok rʉk, Galili kona ila purung. Wamp na ti ndi, Jisas elim murum kona ei pili nʉpʉleing nimba pitim. ");
INSERT INTO med_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ei nambuⱡ emel, ui ei kʉn, elim nga kitip kʉni wu kʉⱡ, ik mbo inditim. Ik mbo endpa ei nimba mel, “Muⱡʉl Wu Kupa ei, tʉk wu kat ngangina kʉn, rok kunding. Wote, rumbʉⱡ raldika omba pangga, elim ⱡoporpa kont moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wote, wu kʉⱡ ik mbo inditim ei nga puⱡ ei, pilik kun iti natʉtʉng. Wote, elim wuldʉng ei nga mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wu ni kʉⱡ Kaperniyum kona ok kʉn, manga tila mukʉr puk moⱡina, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ waldpa nimba mel, “Enim namba mel ti nga nombuⱡa mam ila, ik ou nduk nʉk onmʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wote, wu ni kʉⱡ ndi, Jisas punt rok ik ti, ni nandʉtʉng. Ei nambuⱡ emel, nombuⱡa mam nila, en enim ndi, ik palk nʉk, en enim nga wu nuim kuimbal ei, nam moⱡmba nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wote Jisas ni, mana moⱡpa, kitip kʉni wu 12 ni kʉⱡ, wi ropa rukʉr tʉpa kundpa nimba mel, “Wote, wu nam ti, kuimbal muⱡimp nimba pilim ndam, wu ei omba, akil tepa wamp mbʉ nga pora, kindmant wamp moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Wote Jisas ndi, kangambuⱡa ti tʉpa kʉn, en enim nga kuimp keta nila oⱡa mondpa. Elim nga ki ni raⱡ ndi, kangambuⱡa ni kanggilpa kʉn, wu ni kʉⱡ kundpa nimba mel, “Wamp nam ti ndi, na nga mbi ila nga nimba, kangambuⱡa kʉⱡ nga ti, rawe etpa tʉm ndam, na rawe etpa tʉmba. Wote, wamp nam ti ndi, na rawe etpa tʉm ndam, ei na mint mon. Ei, wu nam ti, na tʉpa mundrum wu ei, kunda ku rawe etpa tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ndi, Jisas kundpa nimba mel, “Ik mbo wu ye! Tʉn wu ti kʉndʉrmʉn ei ndi, kur kit mbʉ, nim nga mbi ila nga nimba tʉpa mundrum. Ei nga, tʉn ndi wu ei, kundpʉn iti nʉtangga mon! Ei nambuⱡ emel, wu ei tʉn nga rʉⱡaip ila mon,” nitmin. ");
INSERT INTO med_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas ndi, kundpa nimba mel, “Wu ei mon ni nʉnʉi! Wote, wamp na ti ndi, uⱡ rʉpndi mat na nga mbi ila em ndam, wote na kʉn ik kit mat tʉkrʉpa ni nanʉmba. ");
INSERT INTO med_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wamp nam ti ndi, tʉpa pei mundi namʉndʉmba wamp ei, wamp tʉn nga. ");
INSERT INTO med_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ik kupa ei, enim kundʉp nʉnt. Wamp nam ti ndi, enim kandpa kʉn, enim Kraist nga wu kʉⱡ nimba, nu kuⱡpa ngum ndam, wamp ei nga tʉpa rapʉndʉm uⱡ ei, mana pi napʉmba. Got ndi, mel ti punt ropa ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Wote, wamp nam ti ndi, mondʉk pili kangambuⱡa kʉⱡ kʉn, uⱡ kit mat itangina kʉn, na kʉn mondʉk pʉtmʉn uⱡ ei, wak rong ndam, ku mam ti tʉk, wamp ei nga nuim kan ila komnga kulk, rok tʉk num kuta ila mana ndung ndam, kapⱡa. ");
INSERT INTO med_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ei nga, nim nga ki ei ndi, uⱡ kit mat etpa, nim nga mondpa pili ei, etpa kit mondum ndam, ki ei koⱡmung etkʉn mundi! Wote, nim ki tenda mint tekʉn molkʉn, uⱡ nga kona ila kont muⱡʉn ei ndi, kapⱡa etmba. Wote, nim ki raⱡ, kunda tekʉn, mbi paka ndam, nim ndip kumbʉⱡi nambrʉm ndip ila pin. ");
INSERT INTO med_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ya kona ila kora mong kora kel kel mat mormin mbʉ, kuⱡi nakʉrmin. Wote ndip ei, kumbʉⱡi nambrʉm ku. ");
INSERT INTO med_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wote, nim nga kʉmp ei ndi, uⱡ kit mat etangga kʉn, nim nga mondpa pili orunga, etpa kit mondum ndam, kʉmp ei koⱡmung etkʉn mundi! Nim kʉmp tenda mint tekʉn molkʉn, uⱡ nga kona ila kont muⱡʉn ei ndi kapⱡa etmba. Muna, nim kʉmp raⱡ pikʉ tekʉn mbi paka ndam, ndip kumbʉⱡi nambrʉm ndip kona ila pin. ");
INSERT INTO med_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ya kona ila kora mong, kora kel kel mat mormin mbʉ, kuⱡi nakʉrmin. Wote ndip ei kumbʉⱡi nambrʉm ku. ");
INSERT INTO med_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wote, nim nga mong ei ndi, uⱡ kit mat etangga kʉn, nim nga mondpa pili orunga etpa kit mondum ndam, mong ei, akʉkʉn tʉkʉn mundi! Nim mong tenda mint tekʉn molkʉn, Got nga wamp tʉpa mumuk rui kona ila pin. Nim nga mong raⱡ kʉmp kʉm tekʉn, mbi paka ndam, nim ndip kona ila pin. ");
INSERT INTO med_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ya kona ila, ‘Kora mong kora kel kel mat mormin mbʉ, kuⱡi nakʉrmin. Wote ndip ei, kumbʉⱡi nambrʉm ku,’ nitim. ");
INSERT INTO med_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ndip ei ndi, wamp mbʉ kʉn pora mba ei, ip kuta etʉm ei mel ku. ");
INSERT INTO med_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ip kuta ei mel kai. Wote, ip ei nga tʉngʉn ei, nu em ndam, wote nim ndi, ip ei nga tʉngʉn ei, aldpa etkʉn, yant tin mel nant? Nim ndi, wamp na mbʉ kʉn, ip kuta na, ol orum ei mel uⱡ kai, wamp numan wang nduk uⱡ mbʉ mint etʉk, wamp mbʉ kʉn numan wang nduk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wote Jisas ndi, kona ni wak ropa, Juriya kona ila mba, nu Joran puⱡa ropa, noi orunga purum. Kona ila, wamp minal ndi, aldpa Jisas kʉn ok mʉk rorung. Jisas ndi, wamp nimbʉ, ik mbo endʉtʉm ni mel ku inditim. ");
INSERT INTO med_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Perisi wu mat ndi ok, Jisas oⱡa tʉk waldʉk nʉk mel, “Tʉn nga mi ik ei ndi, tʉn kundpa wu ei ndi, amp ei kapⱡa ndenggʉⱡa ndumba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas waldʉtʉng ni, punt ropa nimba mel, “Moses ndi, enim namba mi ik ei, nimba ngurum?” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wote, wu ni kʉⱡ ndi, punt rok nʉk mel, “Moses ndi, kapⱡa nangga, wu ti ndi, mon ropa amp ei, mondkʉn kili nim ndam, wu ei ndi, ambʉm ei, mondpa kilangga pangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas ndi, wu ni kʉⱡ kundpa nimba mel, “Moses ndi, mi ik ei, ropa ngurum. Ei nambuⱡ emel, enim nga numan orunga ronduⱡ puⱡnga, Moses ndi kandpa, mi ik ei mbʉ ropa rurum. ");
INSERT INTO med_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wote, unt kuimp tepa, Got ndi, mel mbʉ itim ei kʉn, ‘Got ndi, wu ei kʉn, amp ei kʉn mint itim. ");
INSERT INTO med_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Uⱡ ei nga, wu ei ndi, tipam mam raⱡ wak ropa, elim nga amp ei kʉn, omba rump nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wote, wamp raⱡ omba, wamp tenda mel etʉm. Wamp raⱡ aldpa wamp raⱡ mel mon, wamp tenda mel mormbil.’ ");
INSERT INTO med_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wote Got ndi, wu amp raⱡ tʉpa tenda itim uⱡ ei, “Wamp ti ndi nimba ndenggʉⱡa ndui nʉndangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, kelik mang kona puk kʉn, elim nga kitip kʉni wu ni kʉⱡ ndi, uⱡ kʉⱡ nga nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wote Jisas ndi, i etpa kundpa nimba mel, “Wu ti ndi, elim nga amp ei ndenggʉⱡa ndupa, amp kont paka ti tʉm ndam, wu ei ndi, amp ei kʉn, wapra rui uⱡ ei nga etmba. ");
INSERT INTO med_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wote, uⱡ ei mel ku, amp ti ndi, elim nga wu ei ndenggʉⱡa ndupa, wu kont paka ti pum ndam, amp ei ndi, wapra rui uⱡ ei nga ku etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wamp mat ndi, en enim nga kangambuⱡa mbʉ, Jisas ndi, memp pindangga nʉk mek orung. Wote, elim nga kitip kʉni wu ni kʉⱡ ndi, wamp nimbʉ kundʉk nʉk mel, “Kelik mek pʉi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wote Jisas ndi, ik ei mel nʉtʉng ila kandpa kʉn, popʉⱡ kuⱡpa, elim nga kitip kʉni wu ni kʉⱡ kundpa nimba mel, “Kangambuⱡa kʉⱡ mon ni nʉnʉi! Enim ndi, wak rok mundangina, na kʉn uing. Nambuⱡ emel, Got nga tʉpa mumuk rui uⱡ ei, wamp i etpa mbʉ nga. ");
INSERT INTO med_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na enim ik kupa ei, kundʉp nʉnt, wote wamp na ti, Got nga tʉpa mumuk rui uⱡ ei, kangambuⱡa kel kʉⱡ mel moⱡpa, ti natʉm ndam, wamp ei, Got nga tʉpa mumuk rui uⱡ ila rukʉr pi napʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wote Jisas ndi, kangambuⱡa nimbʉ, kanggilpa rukʉr tʉpa ambuⱡpa, memp pinditim. ");
INSERT INTO med_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wote, Jisas kelpa mbi nimba puⱡnga kʉn, wu ti tʉkrʉpa omba kʉn, Jisas nga kuimp keta nila, mura ropa mondpa kʉn, Jisas waldpa nimba mel, “Ik mbo wu kai ye! Na wote, namba uⱡ ti, etʉp uⱡ nga kʉnt nga kont mul uⱡ ei timp nda?” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wote Jisas ndi, wu ni waldpa nimba mel, “Nambuⱡ emel, nim ndi, na kundkʉn wu kai nʉn? Wamp ti, ama kai mon! Got wu tenda ei mint kai! ");
INSERT INTO med_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nim mi ik kʉⱡ pʉtʉn ei, ‘Nim wamp ti rokʉn kundi nʉkʉndi, nim wu amp kandpa kum pindi uⱡ ei iti nʉti! Nim kindʉp nui nʉni! Nim ik kol rui nʉri! Nim ik kol rokʉn, wamp ti nga mel na ti, rok ranggʉkʉn iti nʉti! Nim tipanʉm manʉm raⱡ numan ngokʉn tʉkʉn ou ndui!’” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wu ni ndi, nimba mel, “Ik mbo wu ye! Mi ik kʉⱡ na ama kang kel kʉn, moⱡʉp pep rur,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas ndi, wu ni kun kandpa, numan ndi, koⱡpa nimba mel, “Nim mel tenda ti nga mint mon kant ei ka! Pukʉn nim nga mel mbʉ pora, rarʉp rokʉn, ku tʉkʉn wote, ku mbʉ ndi, wamp kit kurpa mbʉ tʉkʉn rʉpndi. I in uⱡ ei ndi, nim muⱡ kona wu nuim muⱡʉn. Nʉnt uⱡ ei mel etkʉn, nim na kʉn, pep rokʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wu ni, ya kng mel mbʉ nga wu nuim murum ei nga, ik ni pilpa kʉn, kuimp keta orunga kit pilpa mang kona purum. Ei nambuⱡ emel, elim wu mel ni ti murum. ");
INSERT INTO med_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wote Jisas ndi, tʉpa ropʉl ropa, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Wamp nuim mel pi mbʉ, Got nga wamp tʉpa mumuk rui kona ila rukʉr ping ei nga mbun etpa petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jisas nitim ik ei nga, kitip kʉni wu ni kʉⱡ pilik, min ngʉn mundrʉng. Wote Jisas ndi, aldpa wu ni kʉⱡ, kundpa nimba mel, “Na nga kangambuⱡa kʉⱡ, wamp ti, Got nga wamp tʉpa mumuk rui kona ila rukʉr mbi nimba pilim ndam, elim mbun mam mbʉ, koma romba. ");
INSERT INTO med_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kng kamel ei, gal ruri nombuⱡa mam ila rukʉr mba uⱡ ei, mbun etpa petʉm. Ei mel ku, mel pi wamp mbʉ, Got nga wamp tʉpa mumuk rui kona ila rukʉr ping ei nga mbun minal etpa petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ik ei nga kitip kʉni wu ni kʉⱡ, ama min ngʉn mundʉk, ik ou nduk ei mel nʉtʉng, “Wote, uⱡ ei mel nda, wamp nam ti, Got ndi, etpa tʉmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas ndi, wu ni kʉⱡ kun kandpa, yant ndupa nimba mel, “Uⱡ ei, tʉn wamp mbʉ kʉn mbun etʉm. Wote Got ndi, uⱡ ti rundi nandrʉm. Uⱡ mbʉ pora, Got ndi, kapⱡa etʉm mint!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wote Pita ndi, nimba mel, “Ya kana! Tʉn nga mel mbʉ pora, wak ropʉn, nim pep ropʉn urmʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Wote Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Ei kupa ei nga, na enim kundʉp nʉnt, wamp nam ti ndi, elim nga mang kona wak ropa, ʉngʉnʉl kimʉnʉl wak ropa, mam tipamʉl wak ropa, kangambuⱡa mbʉ wak ropa, kongun kona mbʉ wak ropa, na nga nindpa, na nga ik kai ronduⱡ kʉⱡ nga nindpa om wamp ei mel kai mat ou ndupa, punt ropa tʉmba wamp ei, punt ropa mel 100 ei mel ngumba. Wote, ou ndupa pendpa ngumba. Mel mbʉ manga na, ʉngʉnʉl kimʉnʉl na, mam tipamʉl na, kangambuⱡa na, kongun kona na, ou ndupa tʉng ei kʉn, uⱡ mbun mindil nui mat kandʉk ting ku. Wote, muⱡ mʉi raⱡ pora nim ei kʉn, wamp ei uⱡ nga kʉnt nga kont mul uⱡ ei tʉmba. ");
INSERT INTO med_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wote, wamp ama puⱡi kuimp tʉnmʉn mbʉ, wote ok akil ting, wote wamp ama puⱡi ok, akil tʉnmʉn mbʉ, wote ok kuimp ting,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Jisas kʉn elim nga kitip kʉni wu ni kʉⱡ kʉn, Jerusalem nombuⱡa mam nila purung. Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ tʉpa akil ndupa, elim omba, kuimp titim ila, elim nga kitip kʉni wu ni kʉⱡ mundmong etʉng. Wote, wamp pep rok, akil tek orung wamp nimbʉ, mundmong etʉng ku. Wote Jisas ndi, elim nga kitip kʉni wu 12 ni kʉⱡ rukʉr tʉpa, elim kʉn omba uⱡ mbʉ mel, “Ya pilʉiya! Akup tʉn wi Jerusalem kona peng mbin onmʉn ila, Muⱡʉl Wu Kupa ei tʉk, pris kʉⱡ nga wu kuimbal mbʉ kʉn, mi ik mbo wu mbʉ kʉn nguing. Wote, wu mbʉ ndi, wu ei kot endʉk wu ei, rok kʉndeing ning. Wote, wu mbʉ ndi, wu ei, tʉk wu rʉⱡaip elpa kat nguing ku. ");
INSERT INTO med_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wote, wamp mbʉ ndi, wu ei tʉk ik kuldʉk, ol rondʉk, kan pilda rok, wote rok kunding. Wote, rumbʉⱡ raldika omba pangga kʉn, wu ei koⱡpa tikil ropa kont moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wu Sepeti nga kangʉm Jeims kʉn Jon raⱡ, Jisas kʉn okʉⱡ, waldkʉⱡ nʉkʉⱡ mel, “Ik mbo wu ye! Nim ndi, tʉl nga uⱡ ti indin, nimbʉⱡ onmbʉⱡ ei ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ei nambuⱡ ti, indeimp ni kʉⱡ onmbʉⱡ?” nimba Jisas ndi waldʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wu ni raⱡ ndi, yant ndukʉⱡ ni kʉⱡ mel, “Wote, nim pukʉn uⱡ eng nui mbʉ nga rʉpndi pol ila, wu nuim mumuk mbi paka ei kʉn, tʉl wu raⱡ nga ti tʉkʉn nim nga ki mbo orunga mondkʉn, wote wu ti tʉkʉn, ki rar orunga mundana muⱡʉmbil,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas ndi, wu ni raⱡ kundpa nimba mel, “Ya na waldʉnmbil uⱡ ei, enmbil pilkʉⱡ kai iti natʉk waldʉnmbil. Wote, enmbil kapⱡa nu ming na, nuimp ent ila enmbil kapⱡa nuinggil ei, wote na nu timp ent nu ila, enmbil kapⱡa nu tinggil ku ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wote, wu ni raⱡ ndi, Jisas kundkʉⱡ nʉkʉⱡ mel, “Tʉl kapⱡa itimbil,” nʉtʉnggil. Wote Jisas ndi, wu raⱡ kundpa nimba mel, “Kupa, enmbil na nu ming nuimp ent nu ming ila, enmbil nu nuinggil ku. Wote, na nu timp ent nu ila, enmbil nu tinggil ku. ");
INSERT INTO med_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wote, wu nam ti, na nga ki mbo orunga muⱡangga, ti ki rar orunga muⱡangga nimp ei, na nga ronduⱡ ti mon. Ei nga, enmbil kundʉp i ni nʉnimp. Wamp nam ti, kona ei tʉmba ei, Got elim ndi, unt tʉpa kun etpa, tinditim ei mel ting. Elim ndi, tʉpa kona ei, wamp kʉⱡ ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wote, kitip kʉni wu 10 ni kʉⱡ ndi, ik ei pilik, Jeims Jon raⱡ kʉn, popʉⱡ mondrʉng. ");
INSERT INTO med_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wote Jisas ndi, wu ni kʉⱡ pora, rukʉr tʉpa, kundpa nimba mel, “Enim pʉtmʉn ni, wu nuim na ti, wamp rʉⱡaip kat nokʉndrʉm ndam, wu nuim ei ndi, wamp kel mbʉ, ambuⱡpa oⱡa mana etʉm ei, pilik mormin ei? ");
INSERT INTO med_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wote, uⱡ ei mel ti, enim nga rʉk ting ila, pi nʉpangga mon! Wu kat enmin wu kʉⱡ nga ti, elim nuim muⱡimp nimba pilim ndam, wu ei, enim wu kat nga kindmant wu mel muⱡangga! ");
INSERT INTO med_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Wu nam ti, enim wu kʉⱡ nga kuimbal muⱡimp nimba pilim ndam, wu ei, wamp mbʉ nga pora kindmant wu mel muⱡangga. ");
INSERT INTO med_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nambuⱡ emel, Muⱡʉl Wu Kupa ei, wamp mbʉ ndi, elim nga kongun etʉk, elim tʉk rʉpʉndʉk inding nimba, ui nʉwʉrʉm mon! Elim urum ei, wamp mbʉ tʉpa rapʉndʉmba ei nga urum. Wote, elim nga kʉng wak ropa, wamp puⱡi etpa, yant tʉmba ei nga urum,” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wu nimbʉ ok, Jeriko orung, Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, wamp puⱡi kʉn, Jeriko kona wak rok purung. Wu Timeiyas nga kangʉm Bartimeiyas mong titim ni, nombuⱡa mam ʉldʉ nila moⱡpa, wamp mbʉ kʉn, ku mong na mel mat mawa etpa, morum ni mel murum. ");
INSERT INTO med_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wote, wu ni pitim mel, Nasaret wu Jisas ni, onum nʉtʉng ila, wu ni kei nimba wi ropa nimba mel, “Jisas! Wu Depit nga kangʉm! Nim na kont kuⱡa!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wamp puⱡi ndi, wu ni kʉn, popʉⱡ kulk nʉk mel, “Nim raka nʉkʉn muⱡi!” nʉtʉng. Wote wu ni, aldpa ronduⱡ kei nimba, wi ropa nimba mel, “Wu Depit kangʉm, nim na kont kun ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas ndi, omba anggilpa nimba mel, “Wu ei, wi rʉi!” nitim. Wamp nimbʉ ndi, mong ti wu ni, wi rok nʉk mel, “Jisas ndi, nim wi ronum kʉn, numan wang ndukʉn, oⱡa anggilkʉn ui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wote, elim nga wal pʉki ni kʉⱡ, ropa mundpa, rut nimba anggilpa, Jisas murum nila purum. ");
INSERT INTO med_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas ndi, wu ni, kundpa nimba mel, “Na ndi, nim nambuⱡ ti indimp nʉkʉn pilkʉn nʉn?” nitim. Mong ti wu ni ndi, int ndupa nimba mel, “Ik mbo wu ye! Na nga mong ei, etkʉn kai indana! Na kona mbʉ aldpa kʉnimp!” nitim. ");
INSERT INTO med_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ndi, wu ni, kundpa nimba mel, “Nim kapⱡa pa! Nim nga mondpa pili ei ndi, nim etpa tʉpa mundnum,” nitim. I nilinga kʉn, tʉngʉnda mint, wu ni nga mong ni raⱡ kai murum ila kona nimbʉ aldpa kʉndrʉm. Wote wu ni, Jisas pep ropa purum nombuⱡa mam ni mel purum. ");
INSERT INTO med_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jisas kʉn wamp puⱡi kʉn, Jerusalem kona peng kel ila nondpa ok mel, unt ok, Betpeis kʉn Betani kona kel raⱡ nga komnga mong Olip nila ruk orung. Ni kʉn, Jisas elim nga kitip kʉni wu ralt unt kuimp tepa nombuⱡa ping orung nila, tʉpa mundpa nimba mel, “Enmbil kuimp tekʉⱡ pukʉⱡ, wamp petmin kona ila pʉl! Pukʉⱡ kona ila ruk pukʉⱡ kʉn, anggilkʉn, kng donggi pela kokila ti, muⱡi nambʉrmʉn ei, kan kulk pending ei. Kan potkʉⱡ mekʉⱡ wʉl!” nitim. ");
INSERT INTO med_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Wote, wamp nam ti ndi, waldpa nimba mel, ‘Nambuⱡ emel, kng ei im nʉng ndam,’ int ndukʉⱡ ei mel nʉl, ‘Wu Nuim ei kongun ti pem ila, tʉp mep mbil onmbʉⱡ. Wote, nondpa ropʉl ropa, yant omba nʉl,’” nitim. ");
INSERT INTO med_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Wote, wu raⱡ pukʉⱡ, kandrʉnggil mel, nombuⱡa mam ʉldʉ tila, kng donggi pela ti, manga keta pupʉⱡ ila, kan kulk pendʉtʉng ila pitim. Kng donggi kan ni potilinggila mel, wamp mat ndi, wu raⱡ waldʉk nʉk mel, “Enmbil kng donggi ei, namba tangga, kan potʉmbil?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wote, wu raⱡ ndi, Jisas nitim ni mel, punt rokʉⱡ nilinggila, wamp nimbʉ ndi, kapⱡa nʉk wak rorung. ");
INSERT INTO med_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kapⱡa ni kʉⱡ, kng donggi ni, mekʉⱡ okʉⱡ, Jisas murum kona ila ruk oⱡunggila kʉn, kitip kʉni wu nimbʉ, en enim nga wal pʉki nimbʉ, potʉk tʉk, kng donggi mbuⱡ ming ila telingina, Jisas oⱡa pol ila, oⱡa mba murum. ");
INSERT INTO med_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ni kʉn, wamp puⱡi, en enim nga wal pʉki nimbʉ potʉk, Jisas omba nombuⱡa mam nila, kumbʉlʉk tetʉng. Wamp mat ndi, yaⱡa omung ranggʉk mek ok, pʉkaimp rok, kumbʉlʉk tetʉng. ");
INSERT INTO med_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kuimp tetʉng wamp na, akil tetʉng wamp na mbʉ ndi, pʉi kei nʉk mel, “Got nga mbi paka rʉndamʉn! Oⱡa Nuim Mumuk ei nga mbi tepa angʉndpa om wu ei, Got ndi, memp pindangga! ");
INSERT INTO med_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tʉn nga anda kouwʉ Depit nga tʉpa mumuk rʉrʉm uⱡ ila nga pundʉn ei onum. Got ndi, wu ei memp pindangga! Got nga mbi paka rundamʉn!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ei kʉn, Jisas ni omba, Jerusalem kona peng nila rukʉr omba, manga wingti ou tila murʉk mba, mukʉr tetʉm mel nimbʉ, kandpa pora ndurum. Ni kʉn, akil tepa, elim kʉn kitip kʉni kang wu 12 ni kʉⱡ kʉn, Betani kona nila purung. ");
INSERT INTO med_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wote, mʉkʉlmʉ orunga, Betani kona ila molk, yant orung ni kʉn, Jisas ni kun kurum. ");
INSERT INTO med_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ruⱡ etpa kʉndrʉm mel, nde pik kat omung etpa ʉnggʉtʉm. Wote, nde pik mong mat rom, muna mon nda, nimba kanmba purum. Rʉk omba kʉndrʉm mel, nde pik ni kʉⱡ, omung mint etpa ʉnggʉtʉm. Nambuⱡ emel, nde pik nga mong rorum ui ti mon. ");
INSERT INTO med_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisas ndi, nde pik ni kʉⱡ kundpa nimba mel, “Nim nde pik ei, kʉmp kʉm pena nga mong rui nʉrein mon!” nitim. I nilinga, elim nga kitip kʉni wu ni kʉⱡ, ik nitim ni pʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wote, Jerusalem kona peng ila rʉk orung ni kʉn, Jisas manga wingti ou ila, wamp mel rarʉp rok, morung nimbʉ, ropa pep ropa mundrum. Ku moni nde pol na, kʉi emel mel kʉi mat nga nde pol nimbʉ, ropa mbʉⱡ mbaⱡ etpa, ropa tʉpa pena pena itim. ");
INSERT INTO med_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jisas ndi, wamp mbʉ mel mat mek, manga wingti ila mek ping nimba, kandpa kui iti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wote ei kʉn, wamp mbʉ ik mbo endpa ei, nimba mel, “Got nga ik ei ndi, nimba mel, ‘Na nga manga ei, wamp mbʉ pora nga atinga manga ei. Wote enim ndi, tʉk kʉndʉp wamp mbʉ nga manga, randʉk mo rok etʉk mormin ei ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jisas itim uⱡ ni kʉⱡ, wu pris kuimbal mbʉ kʉn, mi ik mbo wu na nimbʉ ndi, pilik kʉn, Jisas rop kundmin nʉk, nombuⱡa mam mat an ʉk kurʉrʉng. Ni wote, mundmong etʉng. Nambuⱡ emel, wamp puⱡi, Jisas ik mbo endpa nitim ik ni kʉⱡ, pilik min ngʉn mundʉk morung. ");
INSERT INTO med_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Rumbʉⱡ romba elinga, Jisas kʉn kitip kʉni wu ni kʉⱡ, kona peng ni, wak rok ekit purung. ");
INSERT INTO med_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wote, mʉkʉlmʉ orunga, nombuⱡa mam ila puk kandrung mel, nde pik ni koⱡpa pora ndurum. ");
INSERT INTO med_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ndi, nde ni kandpa pilpa nimba mel, “Ik Mbo Wu ye, ya kana! Ukʉ nga nde pik kuⱡangga, nʉkʉn nin ni, koⱡum ei kana!” nitim. ");
INSERT INTO med_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Jisas ndi, wu kʉⱡ punt ropa nimba mel, “Ya pilʉiya! Enim wu ti, Got kʉn minal mondʉk piling ndam, ya komnga mong ei kundʉk, gʉⱡa nʉkʉn, num kuta ila okʉn, mana pi nana mba mint! Wote, nim numan raⱡ etkʉn pili napilkʉn, mondʉk pilkʉn nʉng uⱡ mbʉ mel, Got ndi, endʉmba mint. ");
INSERT INTO med_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ei nga, na ndi, enim kundʉp nʉnt. Enim Got kʉn mondʉk pilik, mel na ti mawa etʉk, atinga rong ndam, mel mbʉ tep mormin nʉk pilik atinga rʉi! Enim waldʉng mel ei, ngumba mint. ");
INSERT INTO med_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wote, enim anggilik, atinga rong ei kʉn, wamp nam ti, nim kʉn nit moⱡum ndam, nim ndi, wamp ei nga nit ei, pendʉk kilana! Wote, muⱡ kona ila, nim nga Tipanʉm ei ndi, nim nga nit mbʉ, wak rondʉmba ku. ");
INSERT INTO med_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wote enim ndi, wamp ti nga nit mbʉ, wak rundi nandʉng ndam, wote muⱡ kona Tipanʉm ei ndi, enim nga nit mbʉ, wak rundi nandʉmba ku,” nitim. ");
INSERT INTO med_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, kelik Jerusalem yant orung. Jisas ni, manga wingti ou ila rukʉr anduⱡnga mel, wu pris kuimbal mbʉ kʉn, mi ik mbo wu na, manga wingti rʉp wu mbʉ kʉn, Jisas murum ila ok, waldʉk nʉk mel, “Nim namba ronduⱡ ei, tek molkʉn uⱡ mbʉ en? Nim nam ndi, ronduⱡ mbʉ nguⱡnga uⱡ mbʉ en?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas ndi, punt ropa nimba mel, “Na ndi, ik tenda ti, enim kʉn wuldimp ent ik ei, punt rok yant nduk nʉng ndam, na ndi, na nga ronduⱡ ei, nʉl tʉp ent nʉk waldʉnmin ik mbʉ punt rop nguimp. ");
INSERT INTO med_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na kundʉk nʉiya! Jon nga wamp nu tinditim ronduⱡ ei, nʉl tʉpa itim. Got nga ronduⱡ ila tʉpa itim muna, wamp nga ronduⱡ ila tʉpa itim?” nitim. ");
INSERT INTO med_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wote, waldʉtʉng wu ni kʉⱡ, en enim ik palk int yant etʉk, ei mel nʉtʉng, “Tʉn namba ik ti punt ramʉn, ‘Wote punt ropʉn, Got kʉn ronduⱡ ei, tʉpa itim nimin ndam,’ Jisas ndi, ‘Nambuⱡ emel, enim Jon nga nitim ik ei, mondʉk pili napʉtʉng?’ nimba. ");
INSERT INTO med_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Wote, Jon wamp nga ronduⱡ ila ik nitim nimin ndam,’ (Wu ni kʉⱡ, wamp puⱡi Jon painui wu ei nga ik ei ndi, wamp mbʉ titim ila ronduⱡ pʉtmʉn ei nga, en enim nʉk pilik mundmong etʉng.) ");
INSERT INTO med_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jisas nga wuldʉtʉm ik ni punt rok nʉk mel, “Tʉn pili napʉnmʉn ei ka!” nʉtʉng. Wote, Jisas wu kʉⱡ, kundpa nimba mel, “Ei mel ku, na ndi, na nga ronduⱡ ei, nʉl tʉp uⱡ ent mbʉ, enim kundʉp ni nʉnimp, mon ku!” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wote ei kʉn, Jisas ik ek ropa nimba mel, “Wu ti ndi, wain pana ti raⱡpa, paⱡa etpa, wain kʉiya romba ei nga kut tʉpa tepa, wote rʉp iting manga ti rukrʉm. Rakpa mondpa, wu ni, elim kona roⱡ tila manga tʉma mba etpa, wu mat ndi, kona ei rʉp indeing nimba ngumba purum. ");
INSERT INTO med_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wote, wain poⱡ roⱡnga ranggʉrmin ui ei urum kʉn, wu ni ndi, elim nga kindmant wu ti tʉpa mundpa, wain pana rʉp etmin wu mbʉ ndi, wain elim nga mel, mat ranggʉk ngeing pi nitim. ");
INSERT INTO med_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kindmant wu ni, purum mel, kongun rʉp etʉng wu nimbʉ ndi, tʉmbʉⱡ ndi rok, ki wai wai mundʉⱡina, yant urum. ");
INSERT INTO med_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wote, kindmant wu ti, ku tʉpa mundrum ni, i ku etʉk, pana rʉp wu mbʉ, ndi rok peng ei, rok nduk etʉk, pipil kunduⱡngina, yant urum. ");
INSERT INTO med_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wote, aldpa kindmant wu ti, tʉpa mundrum ni, rok kondrung. Wote, wu minal akil tepa tʉpa mundrum nimbʉ, i ku etʉk, tʉmbʉⱡ ndi rok, mat rok kondʉk etʉng. ");
INSERT INTO med_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wote, ama akil tepa, elim nga kangʉm tenda aⱡʉm numan ngurum ni, tʉpa wain pana rʉp etʉng wu nimbʉ kʉn, tʉpa mundʉmba etpa, ‘Na nga met kang tenda ei, tʉk ou nduing pʉnt ei ka!’ nimba tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wote, wain rʉp etʉng wu nimbʉ ndi, en enim nʉk int yant etʉk nʉk mel, ‘Ya onum kang wu ei, kongun kona puⱡ wu ei nga kangʉm ei, wu onum ei, rop kondpʉn kʉn, kona ei, tʉn ndun puⱡ puⱡ raⱡʉp tʉmʉn!’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I nʉk, wu ni imp molk, rok kondʉk, on ni wain pana ʉldʉ ila, rok ekit ndurʉng. ");
INSERT INTO med_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ei kʉn, wain pana puⱡ wu ei, yant omba, nambuⱡ uⱡ ti etmba?” nimba, Jisas ndi wuldʉtʉm. “Wu ei ndi, yant omba, wain pana rʉp wu mbʉ, ropa kondpa, wain pana mbʉ, oi ropa rʉp wu elpa mat ku tʉpa ngumba. ");
INSERT INTO med_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Enim Got nga ik mong ti, ei mel petʉm ni, kʉmp rok kandʉrmin muna mon? ‘Ku ti manga rakpa kʉni wu mbʉ ndi, ku kit nʉk mundʉk ketʉng ni, wote omba ku kai rarum. ");
INSERT INTO med_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Oⱡa nuim ei ndi, uⱡ ei mel elinga, uⱡ ronduⱡ rʉpndi mat nimp kandʉrmʉn!’” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jura rʉp wu nimbʉ ndi, Jisas tʉp imp muⱡmin nʉk etʉng. Ei nambuⱡ emel, wu kʉⱡ pʉtʉng ei, ik ek rurum. Ei nga, en enim nga nindpa rʉrʉm. Ei nga, pilik popʉⱡ kulk, tʉp imp muⱡmin nʉk etʉng. Ei wote, wamp minal morung ei nga mundmong etʉk, Jisas kandʉk kui elingina purum. ");
INSERT INTO med_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wote, Perisi wu mat kʉn, Erot nga rʉⱡaip ila wu mat kʉn, tʉk mundʉk polk Jisas waldʉk ik mat neing, ‘Pʉi,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wote wu nimbʉ, Jisas murum kona nila ok, nʉk mel, “Ik mbo wu ye! Tʉn pitmin ei, nim ik kupa mbʉ nʉkʉn, wamp nuim kurpa mbʉ nga mundmong iti natkʉn wamp ei namba nimba pilmba ei nga mundmong iti natkʉn, wote nim Got nga uⱡ kupa mbʉ petʉm ei mel ku nʉndkʉn etʉn. Ei nga, wu mumuk Sisa kʉn, ku moni takis ngormʉn uⱡ ei, kapⱡa muna mon? Ku moni wu ei ngamʉn, muna mon?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wote, Jisas elim oⱡa tʉk kʉning pilik nʉtʉng ik ni, mot nga pilpa, int ndupa waldpa nimba mel, “Nambuⱡ emel, enim na kui mel, mil kʉⱡmin nʉk enmin? Ku mong ti, mek wangina, na kʉnamp,” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ku mong ti mek oⱡina, waldpa nimba mel, “Ya kuimp keta ei kʉn, mbi ei nam nga?” nitim. Ni kʉn, wamp nimbʉ nʉk mel, “Wu mumuk Sisa nga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wote, Jisas ndi nimba mel, “Wu mumuk Sisa nga mel ei, Sisa elim ngʉi! Wote, Got nga mel ei, Got elim ngʉi!” nitim. Nitim ik ni pilik, wu nimbʉ, ama min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sarusi wu mat, Jisas murum nila orung. (Wu mbʉ ndi, wamp kormin on etmin mbʉ, wote ⱡoprʉk oⱡa muⱡi nʉmbʉⱡing nʉtmin). ");
INSERT INTO med_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Wu nimbʉ ndi, nʉk mel, “Ik mbo wu ye! Tʉn Moses ndi, mi ik ropa ngurum ei ndi, nimba mel, ‘Wu ti amp mi tʉpa, wote kangambuⱡa mi nambʉpa, wangʉn pepa koⱡum ndam, ʉngʉn wu ti ndi, amp wiya ei tʉpa, ʉngʉn wu kurum ei nga kangambuⱡa mindangga,’ nitim. ");
INSERT INTO med_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tʉnggʉt kʉn, wu ʉngʉnʉl 7 kat morung kʉⱡ nga wu ʉngʉn komun ei amp tʉpa kangambuⱡa mi nambʉpa, wangʉn pepa kurum. ");
INSERT INTO med_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wote, wu ʉngʉn merʉng orunga ei ndi, amp wiya i ku etpa tʉpa, wote wangʉn pepa kurum. Wote, wu merʉng orunga ei ndi, i ku etpa, amp wiya ei titim ei, wote wu ei, i ku etpa wangʉn pepa kurum. ");
INSERT INTO med_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wote, wu ʉngʉnʉl 7 kʉⱡ nga wu tʉmbʉkak morung kʉⱡ nga wu ti ndi kep, amp wiya titim ei, tʉpa kangambuⱡa kot kep, mi nambʉⱡʉng. Wu kʉⱡ pʉkʉ wangʉn pek korung. Wote, amp ei, wu kʉⱡ kolk pora nduⱡina, akil tepa kurum. ");
INSERT INTO med_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wu 7 kʉⱡ ndi, amp wiya tenda ei, tʉk ambrung ei ka?” nʉk waldʉtʉng. “Wote, wamp kui mbʉ, ⱡoprʉk ok pung ui ei kʉn, amp ei wu nam nga amp mendpʉⱡ ti ning,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wote, Jisas ndi, punt ropa nimba mel, “Enim uⱡ ⱡawa mam ei etmin ei? Nambuⱡ emel, ‘Buk Wingti ei kʉn, Got nga ronduⱡ uⱡ ei kʉn, pilik kun iti natʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wamp kui mbʉ, ⱡoprʉk oⱡa moⱡʉng ei kʉn, wu amp tʉk, amp wu puk uⱡ ti, iti nʉting mon! Wamp mbʉ, muⱡ kona anggelo mbʉ mel kapⱡa muⱡing. ");
INSERT INTO med_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wote, wamp kui mbʉ, ⱡoprʉk ok ping uⱡ ei, Moses nga timan Buk ila, nde kat ndip nurum ei nga puⱡ ila, Got ndi, Moses kundpa nitim ik ni, enim kʉmp rok kʉni nakʉndʉrmʉn ei? Buk ila ik mong petʉm ei ndi, Got ndi, Moses kundpa nimba mel, ‘Na wu Eiparam nga Got, wote wu Aisak nga Got, omba wu Jekop nga Got!’ nʉtʉm, ");
INSERT INTO med_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ik ei nga puⱡ ei, Got ei wamp kui nga Got ti mon. Got ei, wamp kont molk mint ping ei nga Got ei ka! Enim pilik ⱡawa mundʉnmʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ni kʉn, ik mbo wu ti, ik tek rombulk nʉtʉng ni, omba kum tepa moⱡpa pitim. Pitim ni kʉn, Jisas ndi, Sarusi wu ni kʉⱡ, ik nʉtʉng ei, punt ropa kai mundrum. Ni kʉn, ik mbo wu ni, Jisas waldpa nimba mel, “Mi ik mbʉ nga mi ik ronduⱡ ei, ik nant ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas ndi, punt ropa, “Mi ik ronduⱡ ei ya ei! Kum tʉiya! Enim Isrel wamp mbʉ ye! Tʉn nga Wu Nuim Got ei, wu nuim tenda ei! ");
INSERT INTO med_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Enim nga Wu Nuim Got ei, enim nga mundmong ei kʉn, min ei kʉn, numan ei kʉn, wote enim nga ronduⱡ ei kʉn pora numan ngʉi! ");
INSERT INTO med_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mi ik ronduⱡ merʉng orunga ei ya ei, ‘Enim ndi, en enim numan ngurmʉn ei mel, enim nga manga keta kup wamp mbʉ i ku etʉk, numan ngʉi!’ Mi ik mbʉ nga mi ik raⱡ ama ronduⱡ wei raⱡ,” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mi ik mbo wu ni ndi, Jisas kundpa nimba mel, “Ik mbo wu ye! Ei kun nʉn! Nim nʉn ik ei kupa, Nuim ei, Got tenda ei, mint morum. Got elpa ti, ei mel muⱡi nambrʉm mon! ");
INSERT INTO med_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wote, wamp mbʉ ndi, Nuim Got ei, elim nga mundmong ei kʉn, elim nga numan ei kʉn, elim nga ronduⱡ ei kʉn ndi, pʉkʉ numan ngangga! Wote elim ndi, el elim numan ngorum ei mel ku, elim nga manga keta kup wamp mbʉ, i ku etpa numan ngangga! Kng mel mbʉ, kalk tindiⱡim mundʉrmʉn uⱡ ni nga ronduⱡ ti mon. Ya mi ik raⱡ ama ronduⱡ wei raⱡ!” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas ni, wu ni pilpa kungʉndi uⱡ nga ik ei pilpa, punt ropa nimba mel, “Nim, Got nga wamp tʉpa mumuk rui uⱡ ei nga rukʉr uin. Uⱡ ei nga, roⱡ etʉk muⱡi nambrʉn!” nitim. Wote ei kʉn, wamp ti ndi, Jisas ik mat wulding ei nga mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas ndi, manga wingti ou ila, wamp ik mbo endpa, moⱡpa mel wamp mbʉ, waldpa nimba mel, “Mi ik mbo wu kʉⱡ ndi, Kraist ei, Depit nga pundʉn ei, namba etʉk kandʉk ninmin?” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Muⱡnga Wingti ei ndi, Depit kʉn omba moⱡpa nimba mel, ‘Nuim ei ndi, na nga Nuim ei kundpa, na nga ki mbo orunga okʉn muⱡi! Wote na ndi, nim nga el rui wamp mbʉ tʉp, nim nga kʉmp mana orunga wʉl nduimp,’” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Depit elim ndi, Kraist ei mbi tepa, ‘Nuim ei!’ nitim. Wote ei nga, namba etpa Depit nga pundʉn ila, Kraist omba?” Wamp nimbʉ, Jisas nga nitim ik nimbʉ, pilik kai pʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wote wamp nimbʉ, ik mbo endpa nimba mel, “Enim mi ik mbo wu kʉⱡ nga pilik kongundʉk muⱡʉi! Wu mbʉ ndi, en enim nga kʉng orunga mint paka rok, muⱡ mbal kai ruⱡ mbʉ mint ralk, mel rarʉp kona na mbila, wamp kel mbʉ ndi, en enim rawe etʉk, tʉk ou ndeing nʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wote, manga wingti kel mbila, nde pol kuimbal muⱡmin nʉk pʉtmʉn. Wote, rʉng koik etmin kona mbila, kona kurung orunga kai tetʉm mbila mint mormʉn. ");
INSERT INTO med_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Atinga ruⱡ etʉk rok, wamp ndi, kandʉk neing nʉk, amp wiya mbʉ etʉk rok, mang kona mel mbʉ kindʉp nok etmin. Wu kʉⱡ i etmin uⱡ ei nga, mindil mam ti ting!” nitim. ");
INSERT INTO med_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","42","Wote Jisas ni, manga wingti ou ila, angge ku moni ngormʉn kona nila moⱡpa, wamp ku moni mundrʉng ei mel kʉndrʉm. Mel pi wamp nimbʉ ndi, ku moni ou nduk mundʉⱡina mel, amp wiya ti omba, ku peni kui raⱡ etpa ropa, mana ndurum. Ku peni raⱡ tʉpa rak ndupa, ku peni ku tenda mel. ");
INSERT INTO med_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wote, elim nga kitip kʉni wu ni kʉⱡ, wi ropa rukʉr tʉpa nimba mel, “Na enim ik kupa ei kundʉp nʉnt. Ya amp wiya kurpa ni ndi, ku moni ou ndupa ngum. Wote, wamp mat nimbʉ, tʉpa mana ndupa, ya angge ku moni wal ila mundnum. ");
INSERT INTO med_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wote, wamp mat nimbʉ, en enim nga kng orunga mel, ou ndupa nimbʉ nga nit kakina mbʉ ngʉng. Wote, ya amp ei, elim kurpa norum ei mel ku, elim nga tepa moⱡum mel mbʉ, pʉi ngum. Amp ei, elim nga ngumba pendpa moⱡum mel waⱡʉm ei, pʉi ngum,” nitim. ");
INSERT INTO med_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas manga wingti ou ni, wak ropa mbi nimba puⱡnga, elim nga kitip kʉni wu ti ndi kundpa, “Ik mbo wu ye! Ya kana! Manga ei, ku ou mon pi kai mat ndi, tʉk rukrʉng ei kan mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wote Jisas ndi, wu ni kundpa nimba mel, “Enim ya manga ou kanmin mbʉ nga, na ik ti enim pʉlʉi! Ku ou mon pi kai puⱡ puⱡ moⱡpa punum kan manga kʉⱡ, wote ui ti om ei kʉn, ya manga ou kʉⱡ, i etpa muⱡi nambʉⱡmba. Manga kʉⱡ rok gu ndangina, ku mbʉ ʉⱡmbʉⱡ nimba, mana omba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Wote, Olip komnga ila moⱡpa, manga wingti ou ni tʉpa, yant ndupa kandpa moⱡnga, Pita, Jeims, Jon kʉn, Andru kʉn, mint ok, Jisas elim kou moⱡnga waldʉk nʉk mel, “Manga ou rok gu nduing uⱡ ei nant kʉn etmba? Rok mbʉ nduing ui ei, nondpa om ei kʉn, tʉma ila namba tʉma ila mbʉ itangga, kandpʉn moⱡmina, uⱡ mbʉ mel etmba?” nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wote Jisas ndi, wu ni kʉⱡ kundpa nimba mel, “Enim tʉk tiki punding ei nga, tʉk mendʉk muⱡʉi! ");
INSERT INTO med_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wu minal ndi, na nga mbi ila onmʉn nʉk, ‘Na Kraist aⱡʉm ei ont,’ nʉk, wamp minal tʉk tiki punding. ");
INSERT INTO med_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kona nondpa muna, kona roⱡ mbila, el enmin nʉk, timan rong ndam, numan ʉkpʉk ti nʉtʉi! Uⱡ mbʉ etmba ku. Wote, muⱡ mʉi raⱡ pora ninggil ui ei kokila. ");
INSERT INTO med_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Wu mbo rʉⱡaip kat kʉn, rʉⱡaip kat kʉn el iting. Wote, gapman mat ndi, gapman mat kʉn el ruing. Kilimbʉmp kona mbila, ambuⱡpa oⱡa tʉpa etmba, kump kun kan mam mbʉ temba. Mindil kʉⱡ, amp kangambuⱡa ming pilik, mindil normʉn uⱡ ni mel etmba. ");
INSERT INTO med_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Enim tʉk mendʉk muⱡʉi! Na nga mbi ila, enim tʉk mek puk kot endʉk, enim atinga manga mbila rok, wote wu nuim mumuk mbʉ kʉn, kona rʉp etmin wu mbʉ nga kuimp keta ila tʉk, oⱡa angʉndʉk kanda rok, rʉnang ik kai mat nʉk ngʉi nʉk iting. ");
INSERT INTO med_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ei nga, kuimp tek puk, wamp kona elpa elpa mbila, Got nga rʉnang ik kai mbʉ nʉk ngʉi! ");
INSERT INTO med_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wote, enim imp molk mek, kot manga ila mek pung ndam, enim ndi, namba ik ti nimp nda nʉk, kʉⱡ keⱡ numan ou nduk, pili nʉpʉlʉi! Nambuⱡ emel, nim ant ila, nin ik mbʉ, Muⱡnga Wingti elim ndi omba, keta ila moⱡpa, nimba ngui ngui etmba. ");
INSERT INTO med_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wu ʉngʉn mat ndi, ʉngʉn mat rʉk muⱡangina, rok kunding. Wote tipam ndi, elim nga kangambuⱡa mbʉ, i ku itangga, rok kunding. Wote, kangambuⱡa mbʉ ndi, tʉk ropʉl rok, mam tipamʉl mbʉ nga rʉk muⱡangina, rok kunding. ");
INSERT INTO med_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na nga mbi ei, enim kʉn petʉm uⱡ ei nga, wamp minal ndi, enim numan mbʉⱡ nguing. Wote, wamp nam ti ndi, uⱡ mindil nui mbila, ronduⱡ mba moⱡum ndam, wamp ei, Got ndi, etpa peng kont tʉmba. ");
INSERT INTO med_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Enim kʉnangina, uⱡ kit mindil nui mat, Got nga kona peng Wingti ila ekit ui nawʉmba, kona ila ekit wangga kʉning. Jura kona ila moⱡʉng wamp mbʉ, nʉng nʉk, nde pana komnga mong mbila pʉi! ");
INSERT INTO med_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wamp ti, manga ui ila, oⱡa mba moⱡum ndam, mana omba manga ila mukʉr mba mel ti, tʉpa mepa mbi nimba iti nʉtangga! ");
INSERT INTO med_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wu ti, kongun kona ila moⱡum ndam, mang kona omba wal pʉki ekit orunga kʉⱡ, timp nimba pi nʉpangga! ");
INSERT INTO med_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ui ei kʉn, amp kangambuⱡa mondʉk moⱡʉng mbʉ kep, wote kangambuⱡa aim ngʉk moⱡʉng mbʉ kʉn, mindil kit mat nuing. ");
INSERT INTO med_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Uⱡ nʉnt mbʉ, kona ndamʉng rui narʉmba ui ti kʉn, iti nʉtangga nʉk, Got kʉn atinga rʉi! ");
INSERT INTO med_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nambuⱡ emel, ui ei kʉn, uⱡ mindil nui elpa mat ekit omba. Ei, unt muⱡ mʉi raⱡ puⱡ mondpa itim ui ei kʉn, yant ndupa mindil nui nandrʉng, mindil mat nuing. Omba wote, mindil kʉⱡ mel kat, ama pi napʉmba, mon! ");
INSERT INTO med_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wote, Wu Nuim ei ndi, elim nga wamp mendpʉⱡ kʉⱡ nga nʉndpa, uⱡ mindil nui ui ei, tʉpa nondpa endʉmba. Got nga wamp mendpʉⱡ kʉⱡ, mon elinga ndam, wamp ti moⱡpa ruⱡ, pi napʉⱡnga. ");
INSERT INTO med_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ui ei kʉn, ‘Wamp ti ndi, Kraist ya ila morum kana!’ nimba. Muna, ‘Int ila morum nʉm ndam,’ wamp ei nga nʉm ik ei, mondʉk pili nʉpilʉi! ");
INSERT INTO med_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wu mat Kraist Got nga morung wu ralk, wote wu mat painui wu ralk, uⱡ min ngʉn pi mat etʉk, nʉk itangina mba kapⱡa em ndam etʉk, Got nga wamp mendpʉⱡ mbʉ kapⱡa, rukrʉng tʉng ndam, kapⱡa ting mint. ");
INSERT INTO med_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ei nga uⱡ etmba ei mel, unt enim kundʉp nʉnt ei kʉn, tʉk mendʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Wote, mindil kit nong ui ei pora nangga, akil tepa, ‘Ant ei rumbʉⱡ moⱡpa, kalimp ei rʉⱡang pi napʉmba. Mipil rangʉnt mbʉ, kawa ndupa, mana wangina, wi oⱡa muⱡ kona ei nga ronduⱡ mbʉ, kʉⱡ kʉⱡ nimba roka ropa mana omba.’ ");
INSERT INTO med_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“I em ei kʉn, Muⱡʉl Wu Kupa ei, kopa pol ila, Got nga ronduⱡ ei, rʉpndi rʉⱡang mbʉ, tʉpa mepa, kopa pol ila wangga kʉning. ");
INSERT INTO med_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wote, elim nga anggelo mbʉ, tʉpa mundangga puk, muⱡ uⱡ mbila puk, Got nga kʉmp ropa titim wamp mbʉ, kʉmp kʉm tʉk, tenda etʉk, mek rukʉr uing,” nitim. ");
INSERT INTO med_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nde ui mbi paka etʉm uⱡ ei ndi, enim uⱡ ti mbo indangga. Nde ui mbi paka etʉm ei kʉn, kona ant mba ui ei nondpa enim, nʉk tʉk mendʉtmin. ");
INSERT INTO med_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ei mel ku, uⱡ nʉnt mbʉ mel em kandʉk, yant uimp nitim ui ndi, nondpa enim nʉk pilʉi! ");
INSERT INTO med_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Enim ik kupa ei, kundʉp nʉnt, ya wamp rʉⱡaip akup ila monmʉn kʉⱡ, kolk pora ndui nʉndangina, na nʉnt uⱡ kʉⱡ mel etmba. ");
INSERT INTO med_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Muⱡ mʉi raⱡ tʉnggʉt kʉn, pora ninggil. Wote, na nga ik ei, ama pora ni nanʉmba mon! ");
INSERT INTO med_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Rumbʉⱡ muna ant mong nant tila, uimp ui ei, wamp ti ndi, pili napʉtmin. Wote, oⱡa muⱡ ila anggelo mbʉ ndi kep, wote Got nga kangʉm ei kep, mon ku. Oⱡa Wuta, elim mendpʉⱡ pilpa morum. ");
INSERT INTO med_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ei kʉn, tʉk mendʉk, numan kundil nangga muⱡʉi! Enim tʉk mindi namʉndʉk muⱡangina, ui ei ekit omba. ");
INSERT INTO med_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ui ei to rondpa, wu ti kona ruⱡ tila purum. Ei mel ku, kona ila mba etpa, elim nga kindmant wamp mbʉ, kongun ndoimp rok iting ei mel, kʉmp tʉpa elpa elpa ngurum. Wote, keta puⱡ puⱡ rʉp etʉm wu ei kundpa, elim rumbʉⱡ muna, ant mong nant ila yant uimp ui ei, rʉp etʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Ei kʉn, manga puⱡ wu ei, epindama omba, muna ou ipri omba, muna rangʉmba pilpa, mint tem ei kʉn omba, muna ant oⱡa om ei kʉn omba? Ei nga, rup etʉk muⱡʉi! Wote, wu ei tʉpa tʉndpa om ei kʉn, enim ur piyangina omba, kʉni nʉkʉnangga! ");
INSERT INTO med_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Enim kundʉp nʉnt ik ei, wamp pora, ik ku etʉp kundʉp nʉnt. Ei nga, kandʉk tʉk mendʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jura wamp kʉⱡ nga bret yis mundi namʉndʉk, wei normʉn ui ni kʉn, etpa ti rʉng normʉn ui ei nga rumbʉⱡ raⱡ pelinga, pris kʉⱡ nga wu kuimbal kʉⱡ kʉn, mi ik mbo wu na mbʉ ndi, Jisas ndangga nimbun imp moⱡʉp tʉpʉn, rop kundmin nʉk, uⱡ ⱡawa mat kurʉrʉng. ");
INSERT INTO med_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wote, wu mbʉ ndi, nʉk mel, “Etpa ti rʉng nuing ui ei kʉn, ropʉn kundmin ndam, wamp mbʉ ndi, tʉn kʉn tek rombulk, el rok iting!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas noi Betani ila kint pombuⱡma rʉrʉm wu Saimon nga manga ila, rʉng nomba moⱡnga, amp ti ndi, kopung ronduⱡ mura rui kai ming ti, mepa omba tʉpa ambuⱡpa, Jisas nga peng ila, oi ndupa, kopung kʉndrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wote, wamp mat ila morung nimbʉ ndi, amp ei nga itim uⱡ ni kandʉk, popʉⱡ kolk, en enim nʉk int yant etʉk nʉk mel, “Kopung mura rui kai ei, etpa ge ndonum ei ka? ");
INSERT INTO med_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kopung kai ei tʉpʉn mepʉn, mbun mel rarʉp ropʉn, elimina ndam, ku moni 300 kina na ei mel telmina. Wote ku ei, tʉpʉn wamp kurpa nom mat ngoⱡmina,” nʉtʉng. Wote amp ni, ik mura kit mat ngurung. ");
INSERT INTO med_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ni kʉn, Jisas ndi, nimba mel, “Amp ei ndi, na nga uⱡ kai ti endnʉm ei, tangga kandʉk, kui itʉi! Nambuⱡ emel, amp ei, mbun ngonmin? ");
INSERT INTO med_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wamp kurpa mbʉ, enim kʉn, rʉk rʉk muⱡing wamp mbʉ, ki nguimp nʉkʉn pin ndam, nguin mint. Wote, na enim kʉn, ui mbila nga rʉk rʉk rʉp rop muⱡi nʉmbʉⱡmin. ");
INSERT INTO med_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Amp ei ndi, na nga endʉmba uⱡ ei mel, kapⱡa enim. Na nga on ei, tʉk mek puk, wamp on kona ila kopung kandʉk ʉngʉndeing ei mel, unt kopung kandnʉm. ");
INSERT INTO med_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Enim ik kupa ei, kundʉp nʉnt. Muⱡ uⱡ mbila, Got nga rʉnang ik kai kʉⱡ, wamp nʉk ngʉng ei kʉn, ya amp ei ndi, enim uⱡ kai ei, pendʉk timan rok nguing,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wote, kitip kʉni wu 12 ni kʉⱡ nga ti, Juras Iskariyot wu ni ndi mba, Jisas rʉk moⱡpa, wu Pris kʉⱡ nga wu kuimbal nimbʉ, kundʉp nimp nimba purum. ");
INSERT INTO med_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wu nimbʉ ndi, Juras nimba urum ik ni, pilik kai pilik, ku moni mat nguimin nʉk, nʉk mʉi rorung. Pilpa yant omba, Jisas rʉk moⱡmba ei nga nombuⱡa mam ti kʉrʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Etpa Ti rʉng normʉn ui ei nga kng sipsip rok koik, bret yis mundi namʉndʉk normʉn ui ei, puⱡ mondrung ui ei kʉn, Jisas elim nga kitip kʉni wu kʉⱡ ndi, elim waldʉk nʉk mel, “Nim nga Etpa Ti Rʉng ei, manga nant ila tʉp kun itʉmin pamin?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Wote, elim nga kitip kʉni wu raⱡ tʉpa mundpa, nimba mel, “Kona peng ou ila rukʉr pukʉⱡ kʉnanggila. Wu ti, nu kuⱡpa mepa om wu ei, pep rokʉⱡ, akil tekʉⱡ pukʉⱡ, murʉk pum manga ila, manga puⱡ wu ei kundkʉⱡ, ‘Ik Mbo Wu ei ndi waldpa, na nga kitip kʉni wu kʉⱡ kʉn, nanʉm kʉn, Etpa Ti Rʉng ei, manga nant ila moⱡpʉn nuimin ei nga, tʉpa ora ndangga nʉl!’ nitim. ");
INSERT INTO med_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Waldanggila, manga puⱡ wu ei ndi, enmbil manga kʉkaⱡ oⱡa orunga, etpa kai etpa tem ti, tʉpa ora ndumba, rʉng mbʉ tʉk kun etʉk, muⱡʉnggil pʉl!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kitip kʉni wu ni raⱡ pukʉⱡ, kona peng ou nila, Jisas nitim uⱡ nimbʉ mel, kandkʉⱡ tʉkʉⱡ, wote Etpa Ti Rʉng mbʉ, tʉp kun etʉk morunggil. ");
INSERT INTO med_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wote, kona ant ei mana puⱡnga, Jisas kʉn, elim nga kitip kʉni wu 12 kʉⱡ kʉn orung. ");
INSERT INTO med_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Rʉng nimbʉ nok moⱡina, Jisas ndi, nimba mel, “Enim ik kupa ei kundʉp nʉnt. Enim wu kʉⱡ nga ti ndi, na ring nimba rʉk moⱡmba. Rʉk moⱡmba wu ei, na kʉn rʉng tenda ila nonumbʉⱡ,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wu nimbʉ pora, mundmong mindil tʉk, kʉⱡ kel numan pilik elpa elpa Jisas waldʉk nʉk mel, “Nim nʉn ei, na kundʉk nʉn ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wote Jisas ndi, punt ropa nimba mel, “Ei enim wu 12 kʉⱡ nga wu ti, na kʉn ming tenda ila bret nu mundpa, nom wu ei ndi etmba. ");
INSERT INTO med_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Buk Wingti ei ndi, ik ti nimba mel, “Muⱡʉl Wu Kupa ei, koⱡmba nitim ei mel koⱡmba. Wote, Muⱡʉl Wu Kupa ei, rʉk moⱡum wu ei, mindil mam ti, nomba ei ka! Wu ei mam ndi, mi nambilnga ndam, kai elinga,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Rʉng nok moⱡina, Jisas ndi, bret ti tʉpa, Got kʉn angge nimba, puk ropa wu ni kʉⱡ ngumba nimba mel, “Tʉk nʉi! Ei, na nga kʉng ei,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wote, nu wain ming i ku etpa, Got kʉn angge nimba, wu ni kʉⱡ nguⱡnga nok, kapⱡa endʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wote Jisas ndi, kundpa nimba mel, “Ya ei, na nga mema ei, wamp minal Got kʉn, tʉpa tenda etmba ei nga, nʉndʉp oi ndont. ");
INSERT INTO med_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Enim ik kupa ei, kundʉp nʉnt. Na mbo wain ei, aldpa nui nʉnimp. Nandʉp moⱡʉp, mbo Got nga tʉpa mumuk rui kona ila nu wain kont ti, elpa nuimp,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wote, kinan kat nʉk pendʉk, pena ok, noi Olip komnga ila ping pilik purung. ");
INSERT INTO med_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas ndi, wu kʉⱡ kundpa nimba mel, “Got nga ik mong ti, unt pai nok rok pendʉtʉn ei ndi, nimba mel, ‘Got ndi, kng sipsip rʉp wu ei, ropa kundangga kʉn, kng sipsip mbʉ, mbʉⱡ mbaⱡ nʉk ping,’ nʉtʉm Wote, ik mong petʉm ei mel ku, enim ndi, na wak rok, enim nung nʉk ping. ");
INSERT INTO med_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wote, na ⱡoporop oⱡa munt ei kʉn, enim wʉl Galili orunga pi nʉpi, na kuimp tep mbi,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ndi, punt ropa nimba mel, “Wu wei mbʉ ndi, nim wak rok pung ndam, na ndi, nim wak rui nʉrimp mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas ndi, Pita kundpa nimba mel, “Nim ik kupa ei kundʉp nʉnt. Akup rumbuldi, kʉi kulda ropa raⱡ indi nʉndi, nim ndi, na pili napʉt nʉkʉn, raldika indʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ndi, ik pilkʉⱡ ngumba, nimba mel, “Na ndi, nim pili napʉt ni nʉnimp mon! Nim kʉn ei mel, na kuⱡimp!” nitim. Wote kitip kʉni wu kat ndi, i ku etʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wote puk, Getsemani ni kona tila puk kʉn, Jisas ndi, elim nga kitip kʉni wu kʉⱡ, kundpa nimba mel, “Na atinga ruimp punt ei kʉn, enim ya ila muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I nimba, Pita, Jeims, Jon, nga tʉpa melinga, elim kʉn purung. Ni kʉn, elim nga numan orunga mbun mam ti, elim kʉn urum. ");
INSERT INTO med_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wu raldika orunga ni kʉⱡ, kundpa nimba mel, “Na kuⱡimp ei nga, na nga mundmong orunga mindil etpa, na tʉpa mana ndumba enim. Ei nga, enim ya kona ila nokundʉk, mong tʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wu ni kʉⱡ muⱡeing nimba mondpa, onunga kot merʉng mba, mʉi ila rumʉⱡi pepa, mindil nga ui ei omba, keri mba mel pem ndam, omba keri pangga nimba, atinga rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wote, atinga rʉrʉm, nimba mel, “Wuta! Na nga Wuta ye! Nim uⱡ mbʉ kapⱡa etʉn wu ei ndi, ya uⱡ mbun na kʉn onum mbʉ omba, keri pangga ni. Wote, na nga numan pint ei mel mon! Nim nga numan pin uⱡ ei mel iti!” nitim. Nimba kʉn, atinga rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Atinga ropa pendpa, yant omba kʉndrʉm mel, kitip kʉni wu raldika ni kʉⱡ, ur petʉng. Jisas ndi, Pita kundpa nimba mel, “Saimon ye! Nim ur petʉm ei ka! Ant mong tenda tila nim kapⱡa rʉt nʉkʉn, oⱡa muⱡʉn muna mon?” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Enim ur pi napʉk, atinga rok mint muⱡangina, Seitan ndi, enim oⱡa tʉpa kʉni nʉkʉnangga! Muⱡnga ei ndi, atinga ramp ka nimba pʉnʉm, wote kʉng kʉⱡ ndi enʉmp monum,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nimba pendpa, int mba, unt atinga ropa ik nitim ik kʉⱡ, ku rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wote, yant omba wu ni kʉⱡ, ur ku petʉng ila kundrum. Ur pili pʉla, rʉt nʉk oⱡa molk, elim kundʉk ning ik mbʉ pilik rundrung. ");
INSERT INTO med_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ama wote, int mba atinga ropa, raldika endpa yant omba, wu ni kʉⱡ kundpa nimba mel, “Enim muⱡ tʉk ur ku pek mormʉn ei? Enim ur penmʉn, ei manda. Akup Muⱡʉl Wu Kupa ei tʉpa, wamp uⱡ kit etmin mbʉ nga ki pol ila tendʉmba, ui ei onum ei kanmʉn ye! ");
INSERT INTO med_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oⱡa muⱡʉiya pamin! Kʉnʉiya! Na rʉk moⱡum wu ni, ya onum!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas ik nimba moⱡnga, kitip kʉni wu 12 kʉⱡ nga, Juras nʉtmʉn wu ni ndi, wu el kum kat, wu pris kuimbal na, mi ik mbo wu na, manga wingti rʉp wu na mbʉ ndi, tʉk mundrʉng ila mepa urum. Wu el kum orung nimbʉ, koiya na, tʉmbʉⱡ na mat mek orung. ");
INSERT INTO med_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ei kʉn, rʉk murum wu ni ndi, wu el kum orunga nimbʉ nimba ndoimp rondpa nimba mel, “Na ndi, rʉk mbo keta nu rop nʉnt wu ei, kan ngʉk, rʉp ronduⱡ etʉk, mek pʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ni kʉn, Juras ndi, Jisas murum kona nila kun rʉk mba, “Ik mbo wu ye!” nimba, keta nu ropa nurum. ");
INSERT INTO med_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nʉk pendʉtʉng ni mel, tʉngʉnda rʉk ok, Jisas tʉk imp molk kan ngurung. ");
INSERT INTO med_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ni kʉn, kitip kʉni wu wʉng orunga murum ni ndi, koiya ou ti, kʉp ropa pendʉtʉm ni, kuⱡimp ropa ekit tʉpa, wu Pris kuimbal ei nga kindmant wu ni nga, kum omung ei, ropa puⱡa rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Wote Jisas ndi, nimba mel, “Na punt mong wu ti, nʉk pilik enim tʉmbʉⱡ na, koiya na mel mbʉ, mek ok, na kan nguing onmʉn ei? ");
INSERT INTO med_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na ui mbila rʉk rʉk enim kʉn moⱡʉp, manga wingti mbila, Got nga ik ei mbo endʉp it ei kʉn, na tʉk kan ngui nganggʉrʉng ni? Wote, ya enmin uⱡ ei ndi, Got nga ik mong ti, Buk Wingti ila nimba pinditim ik ei omba, kupa enim,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wote ei kʉn, kitip kʉni wu ni kʉⱡ, Jisas mondʉk kelik nung nʉk purung. ");
INSERT INTO med_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Puⱡnga, muⱡ mbal kurmʉⱡʉ rʉrʉm kang wu ti, Jisas pep ropa akil titim. Kang wu ni, tʉp imp monmʉn nʉk elingina, nʉng nimba puⱡnga, muⱡ mbal rʉrʉm ni potʉk yant tilingina we giyu gou purum. ");
INSERT INTO med_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wote, Jisas tʉk mek puk, wu Pris kuimbal ei nga mang kona ila wu pris kuimbal kʉⱡ kʉn, manga wingti rʉp wu kʉⱡ kʉn, mi ik mbo wu kʉⱡ kʉn, tʉk mou rok morung, kona nila purung. ");
INSERT INTO med_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ni, Jisas mek purung ni mel, akil tepa mba, wu pris peng mumuk ni nga mang keta ila, el wu nimbʉ, pena ndip kalk morung nimbʉ kʉn, mba kup etpa, ndip pilpa murum. ");
INSERT INTO med_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wu pris kuimbal mbʉ kʉn, Jura nga wu nuim nimbʉ kʉn, Jisas namba ik tila nʉmp oⱡa ndupʉn, tepʉn rop kundmin nʉk pʉⱡ ti, kurʉrʉng ei, pʉⱡ mat kandʉk ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wote, wu kat ndi, ik kol rok, Jisas ik mat nilinga, pitmin ku nʉtʉng. Wote, wu mbʉ nga ik nʉtʉng kʉⱡ omba, tenda pi nʉpʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Wote, wu mat ndi, anggilik kol rok, Jisas nga ik mat nʉndʉtʉng, “Wu ei ndi, ik ti nitim pitmin ei, ‘Wamp nga ki ei ndi, manga wingti mam rakrung, ei rok tʉp, mana tʉp, wote rumbʉⱡ raldika mel manga ei, rakʉp timp nitim ei, ya wamp nga ki ei ndi, rakurmʉn uⱡ ni mel mon nitim,’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ik i nʉtʉng ik mbʉ ndi, kupa iti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wote, wu Pris peng mumuk ni ndi, rʉk ila anggilpa, Jisas ni waldpa nimba mel, “Nim kʉn kol rok, ik ndo ngʉk nʉnmʉn ei nga, nʉkʉn int nduin ik ti kep, pilik rundʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wu ei ndi, nitim ik ni, Jisas ndi, pilpa kui itim. Wote, wu Pris peng mumuk ni ndi, aldpa waldpa nimba mel, “Nim Kraist, nim Got wamp memp pendʉtʉm wu ei nga kangʉm ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas ndi, punt ropa nimba mel, “Int nʉn wu ei, na waⱡʉm ei ka!” nitim. “Na Muⱡʉl Wu Kupa ei, enim pora kandʉk muⱡangina, Got ronduⱡ tepa mul wu ei nga ki mbo orunga moⱡʉp, muⱡ kona kopa pol ila, yant wamba kʉning ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wote, wu pris kuimbal ni ndi, elim nga wal pʉki ni kʉⱡ ambuⱡpa ondpa, waldpa nimba mel, “Namba ik ti nga kombuⱡpʉn kandpʉn nimin?” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Elim meka ropa kelpa, ik kit nʉnʉm pʉnmin ei kʉn, enim ndi, namba nʉk pʉnmin?” nitim. Jisas kuⱡangga nʉtʉng ik ei, wu ama ou ndupa mel ndi nʉtʉng. Ei nga, wu ei uⱡ kit etʉm ei nga kuⱡangga nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wu mat ndi, Jisas rumin nʉk wu mat ndi, elim nga kuimp keta ila ol rok, muⱡ ping ti ndi, mong raⱡ ila kan rok, ki kom ndi rok, nʉk mel, “Painui wu ye! Nim ki kom ndi ronum ei, wu nam ndi ronum?” nʉtʉng. Wote, el wu mat ila morung ni kʉⱡ ndi, Jisas i ku etʉk, ambulk int tʉk ki raka ndi rorung. ");
INSERT INTO med_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Wote Pita ni, wu pris kuimbal ni nga mang keta nila ndip pilpa murum. Wote, wu pris kuimbal ei nga kongun amp wendʉp ni kʉⱡ na ti ndi, pena omba, ndip pilpa murum ni kʉn, kandpa nimba mel, “Nim Nasaret wu, Jisas ei kʉn kunda, rup rokʉⱡ morumbil ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wote Pita ndi, ik ni, punt ropa nimba mel, “Nim ik nant ei nga nʉn ei, na pilip kun iti natʉnt ei ka!” nitim. Nimba kʉn, manga tip orunga mbi nimba elinga, kʉi kulda rʉrʉm. ");
INSERT INTO med_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kongun ambuⱡa wendʉp ni ndi, Pita mba murum kona nila aldpa kandpa nimba mel, “Ya wu ei, wu nimbʉ nga wu ti,” nimba, wamp ndip pilik morung wamp nimbʉ, kundpa nitim. ");
INSERT INTO med_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ni kʉn, Pita ndi, elim mon ku nitim. Wote onunga kot moⱡina, wamp morung nimbʉ nga mat ndi, Pita kundʉk nʉk mel, “Nim wu kʉⱡ nga ti nʉmp kanmin ei ka! Nambuⱡ emel, nim Galili kona ila wu ei ku! Wote, wu Jisas ei, Galili kona ila wu ei ku,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wote elim ndi, mon nimba ronduⱡ mundpa, mi tepa nimba mel, “Enim ndi, na kʉn rup rokʉⱡ morunggil ninmʉn ei pilik kun iti natʉk nimin ei ka! Na kep nʉnt ndam, na Got ndi, mbun ngangga,” nitim. ");
INSERT INTO med_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I nilinga, kʉi kulda ropa raⱡ inditim. Ei kʉn, Pita ndi, Jisas nga ik elim kʉn nitim ni, tʉpa mindʉtʉm. “Kʉi kulda ropa raⱡ indi nʉndi kʉn, nim ndi, na pili napʉt nʉkʉn kʉⱡ, rondkʉn raldika indin,” nitim. Ik ni tʉpa mendpa kʉn, ka kʉk nimba itim. ");
INSERT INTO med_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ipri unt, wu pris kʉⱡ nga wu kuimbal kʉⱡ kʉn, manga wingti rʉp wu mbʉ kʉn, mi ik mbo wu na, wote kaunsil wu ou mat, kona ila mormʉn nimbʉ pora, ik tenda ti nʉk pendʉk ok, Jisas ni kan ngʉk mek puk, Pailot nga ki ila ngorung. ");
INSERT INTO med_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Wote, Pailot ni ndi, Jisas waldpa nimba mel, “Nim Jura wamp mbʉ nga wu nuim mumuk ei?” nitim. Wote Jisas ndi, punt ropa nimba mel, “Int nim nʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ei kʉn, wu pris kuimbal mormʉn nimbʉ ndi, Jisas uⱡ ⱡawa mat ou ndupa etʉm nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ni kʉn, Pailot ndi, Jisas aldpa waldpa nimba mel, “Nim ik ti punt ruin muna mon? Nim uⱡ ⱡawa mat ou ndupa in nʉk, ik mura ngonmin ei, pʉn muna mon!” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aldpa, Jisas ik ti punt rui nʉrʉrʉm ila, wu Pailot ni, ama min ngʉn mundrum. ");
INSERT INTO med_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pana ui mbila rʉk rʉk Jura wamp mbʉ nga etpa ti rʉng normʉn ui ei, ekit orum ei kʉn, Pailot ndi, kan manga ila wu tenda ti, wamp mbʉ ndi, en enim numan ngormʉn wu ei tʉpa, ekit ndupa ku etʉm. ");
INSERT INTO med_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ui ei kʉn, kan manga ila wu ti mbi tek, Barapas nʉtmʉn wu ei kʉn, wote wu mat, el etʉk wamp rok kondʉk etʉng wu nimbʉ kʉn, kunda petʉng. ");
INSERT INTO med_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wote, wamp minal ok, mou rok molk, Pailot waldʉk en enim ui ei kʉn, etʉm uⱡ ni mel itangga nʉk morung. ");
INSERT INTO med_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wote Pailot ndi, wamp nimbʉ, waldpa nimba mel, “Na ndi, ya Jura wamp mbʉ nga wu nuim mumuk ei, wak rop mundamp ninmin ei?” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailot ik ei mel nitim ei, nambuⱡ emel, wu pris kuimbal kʉⱡ ndi, Jisas kʉn wʉlʉk rok, Jisas mek ok, elim nga ki ila tʉndʉtʉng uⱡ ei, pilpa pora ndupa nitim. ");
INSERT INTO med_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wote, wu pris kuimbal kʉⱡ ndi, wamp minal morung nimbʉ kʉn, ronduⱡ mondʉk nʉk, Pailot ndi, nimba mel, “Barapas mint wak rangga nʉi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wote, aldpa Pailot ndi, wamp minal morung nimbʉ, kundpa nimba mel, “Jura wamp nga wu nuim mumuk, ninmin ei, na ndi, namba uⱡ ti, tamp nʉk pʉnmin?” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wamp pora, ke nʉk int nduk nʉk mel, “Nde peta ila nil rui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailot ndi, waldpa nimba mel, “Wu ei, namba ⱡawa ti em?” nitim. Pailot ndi wuldʉtʉm. Ni kʉn, wamp pora, ronduⱡ ke nʉk mel, “Nde peta ila nil rui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wote Pailot ndi, wamp pora ronduⱡ mundʉk, Jisas ruimin nʉtʉng ni, kandpa wamp kʉⱡ nga numan orunga, etʉp wang nduimp nimba, Barapas kan ngʉk pendʉtʉng ni, wak ropa mundrum. Jisas ni, kan pilda rok, wote nde peta ila nil rok etʉng nimba, Rom el wu nimbʉ nga ki ila ngumba, rukrung ndurum. ");
INSERT INTO med_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wote Jisas ni, el wu kʉⱡ ndi, mek gapman wu ou ei nga manga kukaⱡ ila mek mukʉr puk, el wu morung nimbʉ pora ok mou rʉi nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wote, el wu nimbʉ ndi, Jisas mul kunt na ti mel pakundʉk, kan goimbun rong mul ti tʉk, mʉkʉp etʉk tʉk wʉna mel pakʉndrʉng. ");
INSERT INTO med_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Uⱡ kʉⱡ etʉk pora nduk, kei nʉk, Jisas kʉn mura rok mondʉk nʉk mel, “Jura wamp nga wu mumuk ei muⱡangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wote, nde puⱡa mat tʉk, Jisas nga peng ila tʉmbʉⱡ rok, rʉk rʉk etʉk, ol rok kandʉk, mura rok mondʉk, wote mbi paka rondʉk etʉng. ");
INSERT INTO med_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wote, Jisas tʉk wʉlʉ mundrʉng uⱡ nimbʉ, etʉk pora nduk, muⱡ mbal kunt ti, pakʉndrʉng ni tʉk mundʉk, Jisas elim nga muⱡ, unt nga ni kʉⱡ tʉk randrʉng. Randʉk kʉn, Jisas nde peta ila nil ruing pilik mek purung. ");
INSERT INTO med_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jerusalem kona peng ni, wak rok ekit puⱡʉngina, Saimon, ya Sairin kona ila wu Aleksanda kʉn, Rupas raⱡ nga tipam ei, kona ekit orunga tila moⱡpa, kona peng ila uimp nimba urum. Wu ni, el wu nimbʉ ndi, ronduⱡ mundʉk nʉk mel, “Jisas nga nde peta ni, tʉpa miyangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","I etʉk mek ok, Jisas ya kona ti mbi tek, “Golgata,” nʉtmʉn kona nila mek rʉk orunga, Golgata mbi ei nga puⱡ ei, “Wamp peng ombʉl kona,” nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kona ila Jisas nu wain kʉn mel kombuⱡa iti ti, mbi tek, mur rok nʉtmʉn ni, rok oⱡa mana etʉk, mek ok ngurung. Ni kʉn, Jisas nui nʉndrʉm. ");
INSERT INTO med_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wote Jisas ni, nde peta ila, nil rok pendʉk, el wu kat ndi, Jisas nga wal pʉki ni kʉⱡ, nam ndi, tʉmba nda nʉk, kat etʉng. ");
INSERT INTO med_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ant mong 9 kilok elinga, Jisas ni, nde peta ila nil rok pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jisas tʉk, ik kuldʉk mon ti, ei mel rok mondrung. Mon ei ndi, nimba mel, “JURA WAMP NGA WU NUIM MUMUK EI,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ei kʉn, kindʉp wu ralt pendʉk, nde peta ila rorung. Ti Jisas nga ki mbo orunga rok, ti ki rar orunga rok pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","I elingina, Painui wu Aiseiya ndi, ik ti unt mon ropa pinditim ik ni, omba kupa itim. Ik ei ndi, nimba mel, “Wu ei kindʉp wu mbʉ kʉn, rak nduk, rok kunding,” nimba petʉm. ");
INSERT INTO med_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Wamp nombuⱡa mam ila ok puk mel, peng mbʉ walinga rok, Jisas tʉk, ik kuldʉk, ei mel nʉtʉng, “Kaiye! Nim manga wingti ou ei, gu ndup, mana tʉp, rumbʉⱡ raldika ila rʉkimp nitin ni ka! Akup nim nde peta ila mana okʉn, ni ninim etkʉn tin ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wamp ik nʉtʉng ni mel ku, wu pris kuimbal mormʉn nimbʉ kʉn, mi ik mbo wu nimbʉ kʉn, Jisas tʉk, ik kuldʉk nʉk, int yant etʉng, “Jisas wamp mat etpa titim ni, wote elim etpa ti natʉnʉm ei ka! ");
INSERT INTO med_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Akup nim Kraist, Jura wamp nga wu nuim mumuk ei ndam, nde peta ei, wak rokʉn, mana wana kandpʉn kʉn, tʉn ndi, nim Got nga kangʉm ei, nimbun mondʉp pilʉmin!” nʉtʉng. Wote, kindʉp wu ralt, Jisas kʉn, nde peta ila pendʉk rorung wu ni raⱡ ndi, kunda ku, Jisas ik ngurʉnggil. ");
INSERT INTO med_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Wote, ui ni kʉn, kona ou rʉnggilmʉ elinga, mʉi kʉmp nimbʉ pora, rumbʉⱡ roⱡnga, ant mong raldika itim. Ant mong raldika elinga, Jisas mindil tʉpa, ronduⱡ wi ropa nimba mel, “Eli, Eli, Lama Sabaktani!” nitim. Ik ei nga puⱡ ei, Ipru ik ila ei mel nʉtʉm, “Na nga Got, na nga Got, nambuⱡ emel nim na wak ron?” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wamp mat kona ila nondpa morung nimbʉ ndi, Jisas ik nitim ni pilik, “Kum tʉiya! Wu ei Elaija wi ronum!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wote, wu ti ndi, muⱡ undi ti tʉpa, nu wain kit murum tila mana ndupa, tʉpa ndilwa punt ila mondpa, Jisas nu ei nangga nimba itim. Oⱡa ndupa Jisas ngumba etpa nimba mel, “Tʉn nokundpʉn moⱡpʉn kinamin! Painui wu Elaija ndi omba, Jisas nde peta ila mana tʉmba muna mon nda?” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wote, Jisas ka ronduⱡ etpa kʉn, wote kurum. ");
INSERT INTO med_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisas ni koⱡnga kʉn, muⱡ mbal ti manga wingti ou ila, rukʉr mondʉrmʉn ni rʉk ting ila paⱡpa omba, met ekit purum. ");
INSERT INTO med_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ni kʉn, el wu ou ti, nde peta ila nondpa murum ni, Jisas ke nimba koⱡpa itim uⱡ nimbʉ, kandpa kʉn nimba mel, “Wu ei ama kupa, Got nga kangʉm ei!” nitim. ");
INSERT INTO med_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kona ila nondpa, amp mat ruⱡ etʉk molk, kandʉk morung. Amp morung ni kʉⱡ nga amp, ti Mariya Maktelin, ti Mariya ei, kang wu Jeims kʉn Josis raⱡ nga mam ei, wote amp ti Salomi. ");
INSERT INTO med_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amp kʉⱡ, Jisas Galili kona ila kont murum ei kʉn, Jisas tʉk rapʉndʉk, Jisas nga ik kum tek etʉng amp kʉⱡ. Wote amp mat, Jisas kʉn rʉp rok, Jerusalem kona ila orunga amp nimbʉ pora, Jisas rorung kona nila morung ku. ");
INSERT INTO med_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ui ni, Jura wamp nga mowi kor utʉmʉ orunga muⱡing ei nga, akup mel Jisas kurum. Ei nga, kona rumbʉⱡ romba elinga, Arimatiya kona ila wu Josep ei, Jura wamp nga moⱡpa kundi orunga, wu nuim kai ti, elim Got nga wamp tʉpa mumuk romba ui ei, nokundpa murum wu ei urum. Wu ei ndi, elim ronduⱡ mundpa, Pailot kʉn mba, Jisas nga on ei ngangga nimba, mawa itim. ");
INSERT INTO med_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wote, wu Pailot ni, Jisas koⱡum nʉtʉng ik ni pilpa, rut nimba, elim nga el wu ou ti, wi ropa rukʉr tʉpa, Jisas koⱡpa pora ndum muna mon, nimba wuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wu Pailot ni, elim nga el wu ou ei nga ik nimba, yant ndurum. Ni pilpa kʉn, Josep kapⱡa, Jisas nga on ei, tangga nitim. ");
INSERT INTO med_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wote, Josep ni mba, muⱡ mbal kurʉmʉⱡa ti, wamp on kum rormʉn mbʉ nga, rarʉp ropa tʉpa, mepa omba. Jisas nga on ni mana tʉpa, muⱡ nila kum ropa tepa, Jura wamp nga wamp on etmin ku manga ila rukrʉng ndupa titim. Wote, ku mam ti ndi, ku manga ni kumba rurum. ");
INSERT INTO med_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Josep ndi, Jisas nga on ei, titim kona ni, amp Mariya Makndelin kʉn, Mariya kang wu Josis nga mam kʉn, kandʉk moⱡʉnggila, Jisas nga on ni titim. ");
INSERT INTO med_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jura wamp nga mowi kor mormin ui ni omba puⱡnga, Mariya Makndelin na, Jeims nga mam, amp Mariya na, amp Salomi na mbʉ ndi, Jisas nga on ni kopung kʉnding pilik, kopung mura rui kai mat rarʉp rok, tʉk tek petʉng. ");
INSERT INTO med_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ipri unt, kongun kor ou kʉn, ant kuimp oⱡnga pena ok, Jisas nga on etʉng kona nila purung. ");
INSERT INTO med_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nombuⱡa mam rʉk ting ila puk mel, en enim ol tek nʉk mel, “On kona keta puⱡ puⱡ ila ku ni, nam ndi, mberʉk ndupa, tʉpa mondʉmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wote, puk kandrung mel, ya ku mam wei ni, mberʉk nduk tʉk mundrʉng. ");
INSERT INTO med_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Rʉk puk kandrung mel, ki mbo orunga, anggelo wu kumʉndʉp ti, wal pʉki kurʉmʉⱡa kat pakʉpa murum ila kandʉk, min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wote, wu ni ndi, kundpa nimba mel, “Enim min ngʉn mundi nʉmʉndʉi! Nasaret wu Jisas, nde peta ila pendʉk rong ni, kurʉk ong ndam, ⱡoporpa omba pum. Ya kona ila, pi napʉtʉm. Kona koⱡ ei, ya kʉnʉi! ");
INSERT INTO med_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Akup kandʉk puk, kitip kʉni wu ni kʉⱡ kʉn, Pita kʉn kondʉk nʉi! ‘Elim Galili orunga kuimp tepa mba moⱡmba. Akil tek puk, kʉning nitim ni mel, kʉning pʉi!’” nitim. ");
INSERT INTO med_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pilik tʉkrʉk ekit ok, min ngʉn mondʉk, numan kai pelinga purung. Wote, wamp ti kep, kundʉk ni nandʉtʉng. Ei nambuⱡ emel, amp kʉⱡ mundmong minal etʉng. ");
INSERT INTO med_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas ni, kor ou kʉn, mʉkʉlmʉ unt, ⱡoporpa oⱡa moⱡpa, amp Mariya Maktelin unt kur kit 7 kat ndi, rok wʉlʉ monduⱡnga, Jisas ndi, tʉpa mundrum. Amp ni kʉn, kuimp tepa urum. ");
INSERT INTO med_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Amp ni ndi, int mba, unt Jisas kʉn rʉp rok andrʉng wamp nimbʉ, munt mindil tʉk, ka rom rok morung ila mba, anggelo ei ndi, nitim ik nimbʉ mel, kundpa nitim. Amp nitim ik ni, kupa nʉk mondʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wote, wu ralt en enmbil nga mbo kona ila pinggil puⱡʉnggila, Jisas ni, kuimp keta elpa ti mel, tʉpa urum. ");
INSERT INTO med_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wote, wu ni raⱡ kelik, yant okʉⱡ, kitip kʉni wu kat kundʉk nʉtʉnggil ik ni, kupa nʉk, mondʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wote, akil tepa wu 11 ni kʉⱡ, rʉng nok morung ila, Jisas omba wu ni kʉⱡ, tʉpa pendpa ik ngurum. Ni kʉn, numan rumʉnt pendʉk, elim ni, ⱡoporpa omba mba, kont murum uⱡ ni kandʉk, yant ok nʉtʉng ik ni, kupa nʉk, mondʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wote, wu ni kʉⱡ kundpa nimba mel, “Enim muⱡ uⱡ mbila puk, rʉnang ik kai ei nʉk, wamp mbʉ nʉk ngeing pʉi! ");
INSERT INTO med_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wamp nam ti ndi, mondpa pilpa nu tʉm wamp ti, etpa tʉmba. Wote, wamp nam ti ndi, mondpa pili napilpa nu tʉm wamp ei, kit moⱡmba. ");
INSERT INTO med_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mondpa pili wamp mbʉ, Got nga ronduⱡ ei tʉk, uⱡ rʉpndi mat etʉk, na nga mbi tek angʉndʉk, kur kit mbʉ rok mundʉk, ik nuim kan elpa elpa mat, tek nʉk iting. ");
INSERT INTO med_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wote, kimbuⱡa wamp rui mat oⱡa tʉk ambulk, kopna na mel mat, nok eng ndam, kolk rok iti nʉtʉng. Kui peng em wamp mbʉ, ki ndi ʉmbʉⱡangina, wang nimba,” nitim. ");
INSERT INTO med_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wote, Nuim Jisas ni, ik nimba pora nduⱡnga, elim ni, tʉpa mepa, muⱡ ila oⱡa purum. Got tipam ei nga ki mbo orunga mundrum. ");
INSERT INTO med_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kitip kʉni wu ni kʉⱡ, muⱡ uⱡ mbila puk, elim nga rʉnang ik kai nimbʉ, mbo endilingina, Nuim elim ndi, wu ni kʉⱡ kʉn moⱡnga, ik nʉk ngʉk, uⱡ rʉpndi mat etʉk, etʉng nimbʉ ndi, ronduⱡ purum. ");
INSERT INTO med_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wu nuim Tiyopilus ye! Tʉn nga ruk ting ila uⱡ itim mbʉ, timan rok, mon ruing pilik, wu mat ou nduk kongun etʉng. ");
INSERT INTO med_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","3","Got nga rʉnang ik kai ekit oⱡnga, kuimp tek nombuⱡa rung wu ni kʉⱡ ndi kandʉk, tʉk wamp mbʉ, timan rok ngorung mbʉ, wote puⱡ ik wunt ment mbʉ, kurʉp mbʉ, pilip tʉp kun it wu ei ndi, nim wu nuim Tiyopilus, timan kun petʉm ei mel ku, mon rop kundʉp nʉnt. ");
INSERT INTO med_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na uⱡ ent mbʉ, kʉmp rokʉn pilkʉn, na rʉnang ik kai ei, mbo endʉtʉng ndi, ama kupa nʉkʉn, pilʉn nʉmp, mon rop ngont. ");
INSERT INTO med_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","King Erot ni, Juriya wamp mbʉ, rʉp itim ui ni kʉn, Apaija nga pris rʉⱡaip ila, wu Sakaraiya pris murum. Ambʉm nga mbi Elisapet, Eron nga pundʉn ei. ");
INSERT INTO med_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Got nga kuimp keta ila, wamp raⱡ mop map ambulk, pilkʉⱡ etʉnggil. Got elim nga man ik ei, teng ndurunggil ei, wamp ti kʉn, kapⱡa mon ku. Ⱡawa ama tenda kot kandʉk ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisapet ni, wangʉn pelinga, wei mint pek molkʉⱡ, wenda anda etʉnggil. ");
INSERT INTO med_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tʉnggʉt kʉn, Sakaraiya ni, Got nga kuimp keta ila, elim pris kongun et ei mel, itimp nimba urum. ");
INSERT INTO med_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kongun elpa elpa mbʉ, kʉmp tʉk iting etʉk, Sakaraiya ni, rat pol wingti ila rukʉr mba, kaⱡpa tindiⱡim mundangga nilingina, Got nga manga wingti ou ila, murʉk mba kurum. ");
INSERT INTO med_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ni kʉn, wamp wei orung nimbʉ, pena orunga, atinga rok morung. ");
INSERT INTO med_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Oⱡa Nuim ei nga anggelo ti ndi omba, rat pol wingti titim ei nga ki mbo orunga ʉnggʉtʉm. Sakaraiya ndi, kandpa rot nimba, min ngʉn mundpa murum. ");
INSERT INTO med_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wote, anggelo ni ndi, Sakaraiya kundpa nimba mel, “Nim mundmong iti nʉti! Nim nga atinga rorun ni, Got ndi, pilpa pora ndurum. Wote, nim nga ambnʉm ndi, kang ti mendʉmba. Mem kandkʉn kʉn, mbi tekʉn, Jon ni nitim. ");
INSERT INTO med_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kang ei, mem ei kʉn, nim numan ama mam ti etmba. Wote, wamp minal i ku etʉk, numan mam ti nguing. ");
INSERT INTO med_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wote kang ei, Oⱡa Nuim ei nga kump keta ila, wu nuim moⱡmba. Kang ei, mam ndi, mepa ekit tangga kʉn, nu wain na, nu ronduⱡ na mat, nui nʉnangga! Muⱡnga Wingti ei ndi, ronduⱡ ngumba. ");
INSERT INTO med_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isrel wamp minal man ik ngangga pilik tʉk, numan ropʉl rok, en enim nga Puⱡ Wu Nuim ei nga, man ik ei, pilik pep ruing. ");
INSERT INTO med_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kang wu ei, Nuim ei nga nombuⱡa rung omba. Unt painui wu Ilaija nga numan ronduⱡ pilpa, kongun etpa ʉndrʉm ei mel etmba. Wu tipamʉl mbʉ kʉn, en enim nga kangambuⱡa mbʉ kʉn, tʉpa tenda etmba. Ik nʉpʉl wamp mbʉ, ik mbo endangga pilik, tʉk kun kai muⱡing. I etpa, wamp mbʉ tʉpa kun endangga, Nuim ei nga nokundʉk muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaraiya ndi, anggelo ni, kundpa nimba mel, “Nim nga ik nʉn ei, na pilip kun itimp mel nant? Tʉl wamp wenda anda raⱡ morumbil ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","20","Wote, anggelo ni ndi, ik punt ropa nimba mel, “Na Gepril, Got nga kuimp keta ila mor wu ei, na tʉpa munduⱡnga, rʉnang ik kai ei, nʉmp nguimp ont. Ik ei pilkʉn, ti nʉtʉn kant. Ei kʉn wote, nim ik ni nandkʉn, keta mum kʉn moⱡana, ik nʉnt ei, omba kupa itangga kʉn, ik nʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wu Sakaraiya ni, manga wingti kʉkaⱡ wingti ila murʉk moⱡmba, ruⱡ purum ila, pena orunga wamp nimbʉ ndi, ko tʉk morung. ");
INSERT INTO med_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pena omba ik nimba ei nga pilpa rundpa, wamp nimbʉ ndi kandʉk, manga wingti ila uⱡ kʉni nakʉndʉrmʉn uⱡ ti kandpa, enim nʉtʉng. Wote, ik nimba pilpa rundpa, ki ei ndi, to ropa keta mum kʉn murum. ");
INSERT INTO med_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wote, Sakaraiya nga kongun itim ui ni pora nilinga kʉn, kelpa mang kona purum. ");
INSERT INTO med_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wote, ui mat omba puⱡnga, Sakaraiya nga ambʉm Elisapet ni, kangambuⱡa manga pelinga, kalimp 5 kʉⱡ, mo ropa mint murum. ");
INSERT INTO med_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wote, Elisapet el elim nimba mel, “Akup Nuim ei ndi, na uⱡ kai ti endnim. Wangʉn pep, wamp mormin mbila, pipil kuⱡʉp andʉr ndi, akup na etpa, numan wang ndunum ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","28","Amp Elisapet ni, kangambuⱡa monduⱡnga, kalimp 6 elinga, Got ndi, anggelo Gepril ni, tʉpa munduⱡnga, Galili nga kona peng Nasaret nila purum ila, amp wendʉp ti kʉn urum. Amp wendʉp ni nga mbi Mariya. Depit nga pundʉn wu Josep nga tangga nʉk, ol ik nʉndʉk mondrung. Anggelo ni omba, amp ni, koma pu raⱡ nim kʉn tiyangga! Oⱡa Wu Nuim ei, nim kʉn morum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","30","Mariya ni pilpa, rot nimba, na ndi, rawe etpa ninim mel nant nimba, pilpa rundpa murum. Wote, anggelo ni ndi, Mariya kundpa nimba mel, “Nim mundmong iti nʉti! Nuim ei ndi, nim kandpa numan ngurum ei kan mon! ");
INSERT INTO med_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nim kang ti mondkʉn min ei, mbi tekʉn Jisas ni. ");
INSERT INTO med_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Elim Wu Nuim muⱡangga, Oⱡa Nuim ei nga kangʉm ei ning. Wu Nuim Got ndi, kang ei tʉpa, wu Nuim Mumuk mondpa, elim nga anda kouwʉ Depit itim ei mel etmba. ");
INSERT INTO med_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jekop nga mema tenda wamp rʉⱡaip mbʉ, tʉpa mumuk ropa, ambuⱡpa moⱡpa, mint mba!” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","35","Wote Mariya ndi, anggelo ni, kundpa nimba mel, “Na amp wendʉp ei, kan mon? Ik nin ei, na pilip rondʉnt,” nitim. I nilinga, anggelo ni ndi, ik punt ropa nimba mel, “Muⱡnga Wingti ei kʉn, Got nga ronduⱡ ei kʉn, nim kʉn omba moⱡmba. Ei nga, kang wingti min ei mbi tek, Got nga Kangʉm ei ning. ");
INSERT INTO med_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nim nga pilpanʉm Elisapet amp wenda ni, akup kangambuⱡa manga pelinga, kalimp 6 enim. ");
INSERT INTO med_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nambuⱡ emel, Got ndi, uⱡ elpa elpa mbʉ, etmba ei nga pilpa rundi nandrʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wote Mariya ndi, nimba mel, “Na Nuim ei nga kindmant amp ei mor. Nim ik nin ei mel, na kʉn etangga!” nitim. Wote, anggelo ni ndi, “Muⱡiyo!” nimba, pendpa purum. ");
INSERT INTO med_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ui ni kʉn, nondpa ku, Mariya ni tʉk tʉpa wi Jura mʉi kona ei nga kona peng ila purum. ");
INSERT INTO med_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wote, amp Mariya ni, Sakaraiya nga mang kona nila rʉk omba, Elisapet ni rawe itim. ");
INSERT INTO med_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Wote Mariya ndi, amp Elisapet rawe itim ik ni pilpa, kangambuⱡa oⱡ rukʉr murum ni, pukʉ ropa oⱡa mana itim. Wote, amp Elisapet ni, Muⱡnga Wingti ndi, peka ropa moⱡnga, Elisapet ni, ik oⱡa ndupa nimba mel, “Amp wei mbʉ mon, nim ama memp ambuⱡpa pilpa pendʉm kant. Wote, kang min pilkʉn morʉn ei, Got ndi, memp pindangga! ");
INSERT INTO med_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na nga Nuim ei nga mam ndi, na nambuⱡ emel, kanmba pilpa om nda? Pʉnt uⱡ ei, ama uⱡ mam ti enim. ");
INSERT INTO med_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nim ndi, na ik rʉngʉndʉlina kʉn, kangambuⱡa rukʉr oⱡ ila moⱡum ei, numan kai pilpa, puⱡa ropa oⱡa mana em pint. ");
INSERT INTO med_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Got nga nitim ik ei, kupa pemba nʉkʉn, mondkʉn pitʉn ik ni, akup etpa kupa endnim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Mariya ndi, nimba mel, “Na nga mundmong ei ndi, Nuim ei nga mbi paka rondʉp, na nga min ei ndi, na nga Etpa Ti Wu Got ei, numan ngʉmp mor. ");
INSERT INTO med_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nambuⱡ emel, na mbi mul nʉmbil kindmant amp mendpʉⱡ ei, kandpa kont kuⱡpa etpa tʉnʉm. Ei nga, wamp mbʉ ndi, na Got ndi, memp pendnim uⱡ ei nga timan rondʉk, mek int int ping. ");
INSERT INTO med_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Got wu ronduⱡ pi ei ndi, na kʉn, uⱡ ou mbʉ enim ei nga, elim nga mbi Wingti ei petʉm. ");
INSERT INTO med_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Elim nga mundmong endʉtmin wamp mbʉ, rʉk rʉk kont kuⱡpa etpa, mepa yant yant orum. ");
INSERT INTO med_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","52","Elim nga ki mbo orunga ronduⱡ ei ndi, ronduⱡ mundpa wamp mat, en enim nga mbi mek oⱡa purmin mbʉ nga numan orunga ropa, mbʉⱡ mbaⱡ etʉm. Wu king mbʉ, tʉpa mana ndupa, wamp mbi mul nʉmbil mbʉ, tʉpa oⱡa ndurum. ");
INSERT INTO med_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","54","Kump kun kormin wamp mbʉ, rʉng ngumba mel pi wamp mbʉ, etpa kurpa munduⱡnga, wei purmin. Elim ndi, tʉn nga anda kouwʉmʉn kʉⱡ kʉn, nimba mʉi rurum ik ei mel pilpa pep ropa, elim nga Isrel kindmant wamp kʉⱡ nga tʉpa rapundpa, kont kul uⱡ mbʉ nga endʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Eiparam kʉn elim nga wamp pundʉn mbʉ kʉn, rʉk rʉk kont kurum ei mel petʉm.” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wote, amp Mariya ni, Elisapet kʉn moⱡpa, kalimp raldika tʉpa mundpa kʉn, kelpa mang kona yant urum. ");
INSERT INTO med_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Amp Elisapet ni, kangambuⱡa memba ui ni oⱡnga, kang ti mitim. ");
INSERT INTO med_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wote, manga keta kup wamp na, wamp mbo na mbʉ ndi kandʉk, Oⱡa Nuim ei ndi, amp ei etpa tʉnʉm nʉk, numan kai pʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Rumbʉⱡ 8 kʉⱡ omba puⱡnga, kang ei nga kʉng ila tip timal indimin nʉk rʉk ok, wote tipam nga mbi ei, tindimin nʉk moⱡʉngina, mam ndi nimba mel, “Mon, mbi tepʉn, Jon namin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","64","Wote, wamp nimbʉ ndi, punt rok nʉk mel, “Nim nga wamp mbo mbʉ nga mbi ei mel ti, pi napʉtʉm,” nʉtʉng. Wote tipam ndi, mbi tiyangga nʉk ki ndi, to tendʉk waldʉk nilingina, mon rui mel ti, ngʉi nimba waldpa tʉpa, “Mbi tepa, Jon,” nimba, mon rurum. Wamp nimbʉ, mbi rurum ei kandʉk, rut nʉk morung! Ni kʉn, Sakaraiya puⱡ mondpa, ik nitim. Ik ei piral nilinga, Got nga mbi paka rʉndrʉm. ");
INSERT INTO med_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","Mang keta kup wamp nimbʉ ndi, pilik min ngʉn mundʉk, kona komnga na, Jura kona mbila, nʉk mek int int purung. Ik ei pʉtʉng wamp nimbʉ ndi, numan tʉk mundʉk, nʉk mel, “Ei, kang ei moⱡpa, ou etpa kʉn, namba uⱡ mat etmba nda?” nʉtʉng. Nuim ei nga ronduⱡ ei, kang ei kʉn omba, tenʉm nʉk kandʉk, mbi ndurʉng. ");
INSERT INTO med_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon nga tipam wu Sakaraiya ni, Muⱡnga Wingti ei ndi, ronduⱡ ngʉⱡnga, Got nga ik ei, painui wu mba nʉtʉng ei mel, nimba mot ndurum. ");
INSERT INTO med_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tʉn Isrel wamp mbʉ nga wu Nuim Got ei kʉn, mbi paka rundamʉn! Elim ndi, tʉn tʉpa rapundpa, etpa rukʉr tʉmba ei nga mana om. ");
INSERT INTO med_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Elim nga kindmant wu Depit nga rʉⱡaip ila, Etpa Ti Wu Ronduⱡ ti om. ");
INSERT INTO med_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Unt kor nga painui wu wingti mbʉ nga keta ila, Got ndi, ei mel nitim. ");
INSERT INTO med_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","75","Unt, nimba mʉi rurum ei mel, akup tʉn nga el puⱡa wamp kʉⱡ nga ki ila, tʉn etpa yant tʉnʉm. Tʉn nga anda kouwʉmin ol ik ngurum ei mel kont kuⱡpa, tepa tenda itim uⱡ, wingti ei nga pilpa, tʉn nga anda kouwʉ Eiparam nʉkʉn, mi ambuⱡpa nimba pinditim ei mel, tʉn nga el puⱡa wu mbʉ nga ki ila ndenggʉⱡa ndupa, tʉmba onum ei kʉn, tʉn mundmong iti natʉpʉn, rʉnang ik ei pilip tʉpʉn, pila kana ui mbila, elim nga kuimp keta ila kʉn, kai muⱡmin. ");
INSERT INTO med_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nim kang ei kondʉk, Got Oⱡa Nuim ei nga painui wu ei ning. Nuim ei nga rʉnang ik nʉndkʉn, nombuⱡa tʉkʉn kun indʉn. ");
INSERT INTO med_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Oⱡa Nuim ei, elim nga wamp mbʉ, nit wak rondʉp etʉp timp nimba, uⱡ ei nga nim ndi, ik mbo endana, pilik kun iteing. ");
INSERT INTO med_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Tʉn nga Got wamp kont kaimp kurum wu ei ndi, etpa ti rʉⱡang ei, tʉn kʉn omba. Wote, muⱡ kona ila rʉⱡang ei, ropa mundangga, rumbʉⱡ ila molk, kuⱡing pilik, mundmong etmin wamp mbʉ kʉn omba. Wote, nombuⱡa mam ei, waka ndangga kʉn, kupʉn puk mul uⱡ ei, kandʉp timin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wote kang ei, min orunga kep, kʉng orunga kep, ou ambuⱡpa pilpa itim. Kang ei, elim kona kui waka ila pepa murum. Isrel wamp mbʉ kʉn moⱡnga, rʉnang ik ei nimba, ui ei urum ei kʉn, kona kui waka ei, wak ropa, kelpa ekit urum. ");
INSERT INTO med_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ui ni kʉn, wu nuim mumuk Agustus ndi, nimba mel, Rom Gapman ndi, wamp nokʉndrʉm kona mbila wamp mbʉ, pʉkʉ mbi ngeing nitim. ");
INSERT INTO med_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wote, wamp mbi ngui uⱡ ei, kuimp tek puⱡ mondʉk tʉtʉng ei kʉn, Kuirinius ni wu ei, Siriya kona ila wu nuim murum. ");
INSERT INTO med_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wamp pʉkʉ, en enim nga mʉi peng mbila, elpa elpa puk, mbi nguing purung. ");
INSERT INTO med_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ni, Galili nga kona peng Nasaret ni, wak ropa, Jura kona peng Betelem ila purum. Kona ei, King Depit nga metʉng uⱡimp kut mʉi ei, Josep mʉi ila purum. Ei nambuⱡ emel, elim King Depit nga pundʉn ei. ");
INSERT INTO med_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep amp Mariya tʉpa mepa, mbi nguimbil ni kʉⱡ purʉnggil. Amp Mariya ni, Josep tangga nʉk, ol ik nʉndʉk mondrung. Ei kʉn, amp ni, kangambuⱡa mundrum. ");
INSERT INTO med_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Wote, wamp raⱡ Betelem kona ila puk moⱡʉnggila, amp ei, elim nga kangambuⱡa memba ui ei nondpa itim. Ni kʉn, amp ni, kang kumina ei mitim. Kang ni, muⱡ ila kum ropa, kng kau rʉng normin kona ila pindʉtʉm. Wamp raⱡ nga pinggil manga ti mon itim. Ei nambuⱡ emel, wamp puk petmin manga mbʉ ti nitim. ");
INSERT INTO med_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kona ila nondpa, kng sipsip rʉp wu kat, rumbuldi pena, kng sipsip rʉp etʉk morung. ");
INSERT INTO med_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wu Nuim Got nga anggelo ti, kng sipsip rʉp wu mbʉ morung ila urum. Wote, Wu Nuim Got nga rʉⱡang kai ei ndi, wu kʉⱡ morung nila, rʉⱡang kai ti nguⱡnga, wu ni kʉⱡ kandʉk, min ngʉn munt rong. ");
INSERT INTO med_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wote, anggelo ni ndi, wu kʉⱡ kundpa nimba mel, “Enim mundmong iti nʉtʉi! Na ya ont ei, rʉnang ik kai ti, enim kundʉp nimp ont. Wamp pora ik ei pilik, kai piling. ");
INSERT INTO med_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Akup ui ila, enim nga Etpa Ti Wu Nuim Kraist ei, Depit nga mʉi mang kona mek tek mormin. ");
INSERT INTO med_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ya ik nʉnt ei, enim puk kanʉng ei kʉn, kupa etmba. Kang nana ei, muⱡ ila kum rok, wote kng kau rʉng normin kona ila pendʉk morum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Ni kʉn, kump kiraipa na ni mel, tʉngʉnda mint, muⱡ ila nga anggelo wu, el kum mbʉ ok, anggelo ʉngʉn ti murum nila, Got nga mbi paka rondʉk, kinan nʉndʉk ei mel nʉtʉng, “Oⱡa muⱡ ila Got nga mbi ei, rom kaip mbʉ, nindamin omba, ya mʉi ila, Got nga numan ngurum wamp mbʉ, kupʉn pangga muⱡeing!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wote anggelo nimbʉ, kng sipsip rʉp wu nimbʉ, wak rok kelik, muⱡ kona int purung. Ni kʉn, kng sipsip rʉp wu nimbʉ ndi, nʉk int yant etʉk nʉk mel, “Tʉn Betelem kona mbun, namba uⱡ em ei? Wu Nuim Got ndi, tʉn kundpa nim ni mel, mbun kʉnamin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wote, kng sipsip rʉp wu ni kʉⱡ, tʉkrʉk puk, amp Mariya kʉn, wu Josep kʉn kandʉk tʉtʉng. Wote kandrʉng ni, kang nana ei, kng kau rʉng normin kona nila ur pitim. ");
INSERT INTO med_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kng sipsip rʉp wu ni kʉⱡ, kang nana ni kandʉk kʉn, anggelo ndi, kang nana ei nga kundpa nitim ik nimbʉ, wamp mbʉ kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","19","Wamp nimbʉ ik ei, pilik min ngʉn mundrʉng. Wote Mariya ndi, ik ni pilpa kʉⱡ pʉkʉ, el elim nga numan ila rukʉr ndupa murum. ");
INSERT INTO med_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kng sipsip rʉp wu ni kʉⱡ, kelik int puk, Got nga ronduⱡ ei pilik, kandʉk etʉng ei nga, kinan kai mbʉ, Got nga mbi rok potʉn nduk nʉtʉng. Uⱡ itim mbʉ, anggelo ei ndi, kundpa nitim ei mel ku itim. ");
INSERT INTO med_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Rumbʉⱡ 8 omba puⱡnga, kang ei nga kʉng ila tip timal etʉk, mbi tek, Jisas nʉtʉng. Mbi tetʉng ei, nambuⱡ emel, mam nga oⱡ ila muⱡi nʉmbʉⱡi kʉn, anggelo ei ndi, mbi ei mel, tʉi nitim ei nga. ");
INSERT INTO med_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses nga mi ik ila petʉm ei mel, kor ou ni omba puⱡnga kʉn, Mariya kʉn Josep raⱡ ndi, Jisas Got nguimbil ni kʉⱡ itinggil, Jerusalem kona peng ila purʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Uⱡ ei, Nuim ei nga mi ik ila rok pendʉtʉng mel, “Kang kumina meng mbʉ, enim ndi, Nuim ei ngʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kang ei nga, nʉndʉk angge nʉk, Got ngurung. Ei Wu Nuim ei nga mi ik ila petʉm ei mel, “Kʉi imil raⱡ muna, kʉi mumi waⱡ raⱡ tʉk, Puⱡ Wu ei nga mbi ila ngʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ui ei kʉn, wu ti Jerusalem kona ila murum. Wu ei nga mbi Simiyon. Wu ei, kun kai moⱡpa, Got nga mundmong etpa, Got nga ik ei, pilpa tʉpa morum Muⱡnga Wingti wu ei kʉn moⱡnga, wu ei ndi, Isrel wamp mbʉ, etpa tʉmba ei nga nokundpa murum. ");
INSERT INTO med_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Muⱡnga Wingti ei ndi, elim unt kuⱡi nʉⱡi kʉn, Got nga ngʉmp mana nduimp nitim. Got nga ngurum wu Kraist ei, molkʉn kandkʉn kuⱡin, nitim. ");
INSERT INTO med_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Muⱡnga Wingti ei ndi, Simiyon ni, Got nga manga wingti ou ila mepa purum. Got nga mi ik kʉⱡ petʉm ei mel teng ndukʉⱡ, kang Jisas ni, tipam mam raⱡ ndi, mekʉl manga wingti ila purʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Ni kʉn, wu Simiyon ndi, kang Jisas ni, tʉpa ki ila kanggʉⱡpa, Got nga mbi paka rondpa angge nimba, i etpa nitim. “Oⱡa Nuim ye! Akup nim ndi, nim nga nitʉn ik ei, omba kupa penim kant. Ei kʉn, akup na nim nga kongun kindmant wu ei etkʉn, numan wang ndana pamp. ");
INSERT INTO med_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na nga mong raⱡ ndi, nim nga wamp Etpa Tʉmba Wu ei kant. ");
INSERT INTO med_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Etpa ti wu ei, ninim ndi, etkʉn mot ndun ei, wamp mbʉ ndi, pʉi kanmin. ");
INSERT INTO med_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ei rʉⱡang ti, nim nga numan ila wamp elpa mbʉ, tʉkʉn ora ndon. Wote, nim nga rʉⱡang ronduⱡ ei tʉkʉn, nim nga Isrel wamp mbʉ ngun,” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyon ndi, kang ei nga ik kai nʉndʉtʉm mbʉ, kang Jisas nga tipam mam raⱡ ndi, pilkʉⱡ min ngʉn mondrʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Wote Simiyon ndi, mam tipam raⱡ kʉn, memp pendpa, mam Mariya kundpa nimba mel, “Kang Jisas ei, Got ndi, mbi ropa tʉpa, mondpa kʉn, Isrel wamp mat etpa rukʉr tangga, mat uⱡ kit mbila, mana ping. Kang ei, Got nga tip timal ronduⱡ ti moⱡangga, wamp puⱡi ndi ik nʉk kit munding. ");
INSERT INTO med_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Itangga kʉn, wamp mbʉ nga numan pʉtmʉn mbʉ, omba pena ila pemba. Koiya nengina ti ndi, norum ni mel, nim nga mundmong ila rukʉr kopʉtʉmba ku,” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ni kʉn, painui amp wenda wiya ti murum. Amp ei nga mbi, Ana. Amp ei nga tipam Panuwel, met Asa rʉⱡaip ila nga wu ei. Amp ei nga pana 84, wam kʉn pana 7 mendpʉⱡ pepa moⱡnga, wam kurum. Amp ei, rumbuldi rʉnggilmʉ mbʉ, Got nga manga wingti ou ei, wak rui nʉrʉrʉm. Got nga mbi paka rondpa, rʉng mowi moⱡpa, atinga rʉk rʉk ropa itim. ");
INSERT INTO med_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Amp wenda wiya ei, ant mong ei kʉn rʉk omba, Got kʉn angge nimba, kaip nindpa. Kang ei, Got ndi, Jerusalem wamp mbʉ, etpa rukʉr tʉmba nʉk, nokundʉk morung kang ei nitim. ");
INSERT INTO med_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wote, Josep Mariya raⱡ, Got nga mi ik ila petʉm uⱡ mbʉ, etʉkʉⱡ pora ndukʉⱡ, Galili nga kona peng Nasaret ila, kelik int purung. ");
INSERT INTO med_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kang Jisas ni, ou etpa ronduⱡ mba, numan kai kun mbʉ nga pilpa pora ndurum. Wote, Got nga memp pendʉtʉm uⱡ mbʉ omba, Jisas kʉn titim. ");
INSERT INTO med_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rʉk rʉk pana mbila, Pasopa ui ambʉrmʉn ei kʉn, Jisas nga tipam mam raⱡ Jerusalem kona ila purʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas ni, pana 12 itim ni kʉn, Pasopa ui ni, ekit oⱡnga, Jisas ni, tipam mam raⱡ kʉn, Jerusalem kona ila rʉk rʉk purmin ni mel ku purung. ");
INSERT INTO med_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Wote, kang Jisas ni, Jerusalem int murum. Murum ni, tipam mam raⱡ pili napʉtʉnggil. Wamp raⱡ pilkʉⱡ mel, wamp mou rup rok orung nila, onum ku nʉk pʉtʉnggil. Ant tenda ei, nombuⱡa mam okʉⱡ pora ndukʉⱡ, aldpa kang ni, wamp mbo mbʉ kʉn, kurkʉⱡ int purʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wote kang ni, kandʉk ti natʉtʉnggil. Aldpa Jerusalem kona nila, kurkʉⱡ int purʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Rumbʉⱡ raⱡ elinga, wote ant tila manga wingti ou ila moⱡnga, kandʉk tʉtʉnggil. Kona nila moⱡpa, Jura ik mbo wu mat, ik nʉtʉng mbʉ kum tepa, mat ila waldpa, int ndupa etpa murum. ");
INSERT INTO med_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kona ila morung wamp nimbʉ, Jisas nga ik ronduⱡ pilpa kungʉndi mbʉ nilinga, pilik min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wote, tipam mam raⱡ ndi, en enmbilinga kang ni, uⱡ ei mel etpa murum ni, kandkʉⱡ min ngʉn mundrʉnggil. Wote mam ndi, kangʉm kundpa, nimba mel, “Na nga kang ye! Nim uⱡ ei mel tʉl kʉn in ei, nambuⱡ emel, tʉl kʉn uⱡ ei mel in? Nim nga tipanʉm kʉn, na kʉn numan mbun ou ndupa pilpʉⱡ, nim kurʉp andʉp mint pimbʉⱡ,” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jisas ndi, punt ropa nimba mel, “Na nambuⱡ emel, andkʉⱡ kurʉnggil? Na, na nga Wuta nga manga ila muⱡimp ni, enmbil ni, pʉtʉmbil muna mon?” nitim. ");
INSERT INTO med_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wote, tipam mam raⱡ ik nitim ni, pilkʉⱡ mbi ndui nandrʉnggil. ");
INSERT INTO med_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wote Jisas ni, wamp raⱡ kʉn rʉp rok, Nasaret int purung. Ila nga tipam mam raⱡ nga ik nʉtʉnggil mbʉ, teng mint ndurum. Wote, ik teng ndupa, uⱡ kai itim mbʉ, mam pilpa rukʉr ndupa, kai pilpa murum. ");
INSERT INTO med_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Wote Jisas ni, elim nga kʉng orunga kʉn, pilpa kungʉndi ei kʉn, ou etpa, kun mba kai mundrum. Wote Got kʉn, wamp mbʉ kʉn pʉiya Jisas kandʉk numan ngorung. ");
INSERT INTO med_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wote, Sisa Taipiriyus ni wu ei, Rom wamp kʉⱡ nga wu nuim mumuk moⱡnga, pana 15 itim. Pontiyus Pailot ni wu ei, Jura kona peng ila gapman kuimbal murum. Ui ei kʉn, Erot ndi, Galili kona ei nokʉndrʉm. Ʉngʉn Pilip ndi, Ituriya kʉn Treikonaitis kona raⱡ nokʉndrʉm. Laisaniyas ni, wu ei ndi, Apilin ei, kona peng ei nokʉndrʉm. ");
INSERT INTO med_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wote, wu Anis kʉn, Kaiyapas raⱡ pris kuimbal morunggil. Ui ei kʉn, wu Sakaraiya kangʉm Jon ni, kona kui waka tila murum ila, Got ndi, ik mat Jon kundpa nitim. ");
INSERT INTO med_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wote, Jon ik ni pilpa mba kʉn, nu Joran ʉldʉ ila petʉng wamp nimbʉ pora, kundpa nimba mel, “Enim numan ropʉl rok, nu tangina kʉn, Got ndi, enim nga uⱡ kit etʉk mormin mbʉ, tinga ndundʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Akup uⱡ etmba kʉⱡ, unt painui wu Aisaiya ndi, ik pai nomba, mon ropa nitim ei mel pimba, “Kona kui waka tila wamp ti nga keta ila wi ti onum ei ndi, nimba mel, ‘Wu Nuim ei nga nombuⱡa mam omba ei, rok kun endʉk, etʉk kai mundʉk itʉi! ");
INSERT INTO med_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kona kut tem mbʉ, mʉi mbo rok. Komnga tem mbʉ, kulda rok ruⱡa nduk, nombuⱡa mam kʉrʉiya em mbʉ, etʉk tʉk kun mundʉk, nombuⱡa kit moⱡum mbʉ, etʉk kai mondʉk itʉi! ");
INSERT INTO med_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya mʉi kona ila wamp mbʉ ndi, Got nga wamp Etpa Ti Uⱡ ei kʉning!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wote wamp puⱡi, Jon ndi, nu tindangga nʉk oⱡungina, Jon ndi, wamp mbʉ kundpa nimba mel, “Enim wimbʉ kit mbʉ ye! Got nga popʉⱡ ei, nondpa omba enim ila, enim nung nʉk ping ei, nam ndi nʉm? ");
INSERT INTO med_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Enim numan ropʉl rok, kupa rong ndam, enim nga uⱡ kai eng mbʉ ndi, ora ndupa mel, enim numan ropʉl rok pora ndurʉng nimba ei ka! Enim nga keta mʉn ei ndi, nʉk mel, ‘Eiparam ei tʉn nga wu tipam anda kouwʉ nʉtmin ik ei, ni nʉnʉi!’ Na ndi, enim ik kat kundʉp nʉnt. Ya ila ku tetʉm kʉⱡ, Got ndi, kapⱡa etpa, Eiparam nga kangambuⱡa pundʉn kʉⱡ, mondʉmba mint. ");
INSERT INTO med_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nde puⱡ ila rui kat nokundpa tetʉm. Nde kit kat mong ropa, kit mondum kʉⱡ, rui rok tʉk ndip kuⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon nga ik nitim ni, wamp mbʉ pilik, min ngʉn mundʉk, Jon waldʉk nʉk mel, “Akup tʉn namba uⱡ itmin nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wote, wamp mbʉ nga nʉtʉng ik ni, Jon ndi, punt ropa nimba mel, “Nim wamp nam ti, wal pʉki raⱡ tekʉn mun ndam, wal pʉki ti tʉkʉn, wal pʉki mon wamp ei ngui. Wote, nim rʉng mat tekʉn mun ndam, rʉng mon wamp ei, mat ngui ku,” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ku moni takis tʉtmʉn wu mat, nu timin nʉk ok morung nimbʉ ndi, Jon waldʉk nʉk mel, “Ik mbo wu ye! Tʉn akup namba uⱡ itmin nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jon ndi, wu kʉⱡ kundpa nimba mel, “Enim gapman ndi, ku moni takis tʉi nʉm, to ila mendpʉⱡ tʉi. Ik kol rok wamp mbʉ nga ku moni mat pendʉk, ti nʉtʉi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wote, el wu mat ndi, Jon waldʉk nʉk mel, “Akup tʉn namba uⱡ itmin nda?” nʉtʉng. Jon ndi, el wu kʉⱡ nga ik, punt ropa nimba mel, “Enim ndi, wamp mat, nʉk kit mondʉk, ku moni na mel mbʉ, kindʉp nok ti nʉtʉi mon! Enim ndi, wamp mat, nga ik kep nok, kot pilik kʉn, ku moni na mel mbʉ, roldʉk ti nʉtʉi mon! Enim nga kongun etmin ila nga ku tʉtmʉn kʉⱡ, numan ngʉk tʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ni kʉn, wamp nimbʉ ndi, Got nga ngurum wu ti omba nʉtmʉn ndi, Jon ni, wu ei aⱡʉm ei, nda nʉk, numan ou nduk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","I nʉk pʉtʉng ni, Jon ndi, ik punt ropa wamp mbʉ, kundpa nimba mel, “Na ndi, enim wamp mbʉ, nu ila mendpʉⱡ nu tʉndʉnt. Wote wu ti, akil tepa omba ei ndi, na nga ronduⱡ ei, mana ndupa omba. Na wu kai ti ndi, kapⱡa wu ei nga kʉmp rʉk mondum raⱡ nga kan ei pilinga, nduimp mel kapⱡa mon. Wu ei ndi, enim wamp mbʉ, Muⱡnga Wingti ei kʉn, ndip ei kʉn, pendpa nu tʉndʉmba. ");
INSERT INTO med_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wu omba ei, wit kongun etmin ti, mepa omba wit rʉlkawa mbʉ, apʉrpa tʉpa, mundpa kelpa, wit mong pemba tʉpa, wit manga ila mʉk romba. Wote, wit kit mbʉ, tʉpa ndip rʉk rʉk nomba, mint morum ila mundʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ndi, ik mat ou ndupa, wamp mbʉ, pilik teing nimba, ronduⱡ mundpa, ik mbo endpa, Rʉnang Ik Kai mbʉ nimba ngurum. ");
INSERT INTO med_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wote Jon ndi, nuim Erot ni, ik mura ngurum. Ei nambuⱡ emel, Erot ni, gapman wu kuimbal moⱡpa kʉn, elim nga ʉngʉn nga amp Erotiyas ni, manggʉpa titim. Wote, uⱡ ⱡawa elpa mat, ou ndupa itim ku. ");
INSERT INTO med_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wote Erot ndi, uⱡ ⱡawa unt itim kʉⱡ, tʉpa pei mundpa kʉn, wote Jon ni, aldpa kan ngurum. ");
INSERT INTO med_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Wamp mbʉ, Jon ndi, nu tindpa pora nduⱡnga kʉn, wote Jisas ni omba, nu titim. Nu tʉpa pora ndupa, wote atinga ropa moⱡnga kʉn, wi muⱡ kona kumba tilinga, Muⱡnga Wingti ni, kʉi imil mel mana omba, Jisas kʉn murum. Ni kʉn, wi muⱡ ila, ik ti omba nimba mel, “Nim na nga kangʉm waⱡʉm ei, na ndi, nim numan minal ngunt,” nitim. ");
INSERT INTO med_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas ni, pana 30 omba puⱡnga kʉn, puⱡ mondpa kongun itim. Wamp mbʉ ndi, pilik mel, Jisas ni, wu Josep nga kangʉm ei nʉk pʉtʉng. Wu Josep nga tipam ei Eli. ");
INSERT INTO med_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Wu Eli nga tipam ei Matat. Matat tipam Lipai. Lipai tipam Melki. Melki tipam Janai. Janai tipam Josep. ");
INSERT INTO med_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep tipam Matatiyas. Matatiyas tipam Eimos. Eimos tipam Neiyum. Neiyum tipam Esli. Esli tipam Nakai. ");
INSERT INTO med_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai tipam Mat. Mat tipam Matatiyas. Matatiyas tipam Semein. Semein tipam Josek. Josek tipam Jora. ");
INSERT INTO med_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jora tipam Jowanan. Jowanan tipam Resa. Resa tipam Serapapel. Serapapel tipam Seldiyel. Seldiyel tipam Neri. ");
INSERT INTO med_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tipam Melki. Melki tipam Ari. Ari tipam Kosam. Kosam tipam Elmatam. Elmatam tipam Er. ");
INSERT INTO med_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tipam Josuwa. Josuwa tipam Eliyeser. Eliyeser tipam Jorim. Jorim tipam Matat. Matat tipam Lipai. ");
INSERT INTO med_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai tipam Simiyon. Simiyon tipam Jura. Jura tipam Josep. Josep tipam Joram. Joram tipam Eliyakim. ");
INSERT INTO med_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim tipam Meleiya. Meleiya tipam Mena. Mena tipam Matata. Matata tipam Neitan. Neitan tipam Depit. ");
INSERT INTO med_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depit tipam Jesi. Jesi tipam Opet. Opet tipam Bowas. Bowas tipam Salmon. Salmon tipam Nason. ");
INSERT INTO med_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason tipam Aminatap. Aminatap tipam Atmin. Atmin tipam Arni. Arni tipam Esron. Esron tipam Peres. Peres tipam Jura. ");
INSERT INTO med_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jura tipam Jekop. Jekop tipam Aisak. Aisak tipam Aparam. Aparam tipam Tera. Tera tipam Neiyor. ");
INSERT INTO med_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neiyor tipam Seruk. Seruk tipam Reyu. Reyu tipam Pelek. Pelek tipam Iper. Iper tipam Sela. ");
INSERT INTO med_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela tipam Keinan. Keinan tipam Arpakat. Arpakat tipam Sem. Sem tipam Nowa. Nowa tipam Lamek. ");
INSERT INTO med_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek tipam Matusela. Matusela tipam Inok. Inok tipam Jeret. Jeret tipam Malalalel. Malalalel tipam Keinan. ");
INSERT INTO med_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinan tipam Enos. Enos tipam Set. Set tipam Andam. Andam ni wu ei, Got nga kangʉm. ");
INSERT INTO med_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Wote Jisas ni, Muⱡnga Wingti ndi, rukʉr orunga peka rurum ila, nu Joran ni, wak ropa kelpa yant urum. Ei kʉn, Muⱡnga Wingti ndi, Jisas tʉpa mepa mba, kona kui waka tila mundrum. ");
INSERT INTO med_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","3","Kona kui waka nila, Jisas ni, Seitan ndi, oⱡa tʉpa kandpa mint moⱡnga, rumbʉⱡ 40 omba purum. Ui ni kʉn, Jisas ni, rʉng ti nui nandpa murum ei nga kump kun ndi kurum. Wote Seitan ndi, Jisas kundpa nimba mel, “Nim kupa Got nga kangʉm ndam, ku ei nana, omba oka rʉⱡ angga!” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wote Jisas ndi, punt ropa Seitan kundpa nimba mel, “Got nga rʉnang ik ei ndi, nimba mel, ‘Oka ndi mendpʉⱡ, wamp kont mul uⱡ ei, ngui nganggʉrʉm mon!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Wote Seitan ndi, Jisas ni tʉpa mepa wi komnga mong ila oⱡa mba mul, uⱡ tepa purum nimbʉ, Jisas ni, tʉkrʉpa mint ora ndurum. Ni kʉn, Seitan ndi, Jisas kundpa nimba mel, “Mʉl kʉmp ila tetʉm mel mbʉ nga ronduⱡ mbʉ pora, nim nguimp. Ya mel mbʉ pora, na ngurum ei nga, na nga mint tetʉm. Ei nga, na ndi, nguimp nʉmp pʉnt, wamp ti nguimp mint. ");
INSERT INTO med_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ei nga, akup ila, nim ndi, mura rokʉn mondkʉn, na nga mbi paka rundʉn ndam, ya mel mbʉ pora, nim nguimp mint,” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas ndi, Seitan nga ik nitim punt ropa nimba mel, “Got nga Rʉnang Ik ila nimba mel, ‘Nim nga Nuim Got tenda ei nga mint, mbi paka rokʉn, kindmant indi, nʉtʉm ni ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wote Seitan ndi, Jisas ni, tʉpa mepa mba, Jerusalem kona peng ni nga manga wingti mam im ila mundpa, Jisas kundpa nimba mel, “Kupa nim Got nga kangʉm ndam, pʉkʉ rokʉn mana pana kʉnamp. ");
INSERT INTO med_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ei nambuⱡ emel, Got nga Rʉnang Ik Kai ei ndi nʉtʉm, ‘Got elim nga anggelo mbʉ kundpa nangga, nim rʉp etmba, nokundʉk kai munding, nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wote, nim ku ndi, ropa kʉmp kit mondpa etmba ei nga, anggelo mbʉ ndi, ki pol ila mondʉk mek ping nʉtʉm ni ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wote Jisas ndi, punt ropa nimba mel, “Got nga rʉnang ik kai ei ndi, nimba mel, ‘Nim nga Nuim Got tenda ei kʉn, oⱡa tʉkʉn kʉni nʉkʉni mon!’ nʉtʉm ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seitan ndi, Jisas ni, uⱡ elpa elpa mbila oⱡa tʉpa kandpa, pora ndupa kʉn, Jisas wak ropa, wote ui mat ila oⱡa tʉp kʉnimp nimba pilpa, kelpa purum. ");
INSERT INTO med_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wote Jisas ni, Muⱡnga Wingti ei ndi, ronduⱡ nguⱡnga, Galili kona ila int purum. Galili kona ila wamp mbʉ molk pʉtʉng ei, Jisas ni, Galili kona ila omba morum nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Rʉk rʉk Jisas ndi, atinga manga kel titim mbila, wamp mbʉ ik mbo enduⱡnga, wamp mbʉ pora, Jisas nga mbi paka rondrung. ");
INSERT INTO med_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas ni, kang kel kʉn mba, Nasaret kona peng ila moⱡpa, ou itim kona ila, mowi kor mbʉ kʉn, rʉk rʉk atinga manga kel mbila, mba itim ei mel ku purum. Kona ila moⱡpa, Got nga rʉnang ik kai mon mat, kʉmp ruimp nimba, oⱡa anggilinga. ");
INSERT INTO med_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wamp mbʉ ndi, Painui wu Aisaiya nga rurum Buk Wingti kʉⱡ tʉk ngurung. Buk ila ik mong kʉⱡ mel murum ila kandpa titim, ");
INSERT INTO med_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Got nga Muⱡnga Wingti ei, na kʉn omba morum. Uⱡ ei, nambuⱡ emel, Got elim ndi, na Wu Nuim muⱡimp nimba, kopung kandpa, memp pinditim ei ndi, elim nga ik mong kai kʉⱡ mek pukʉn, wamp mbʉ kʉn kundkʉn ni nitim. Got elim ndi, na tʉpa mundpa kʉn, kan manga ila petmin wamp mbʉ, kan pilinga ndana kʉn, wamp mbʉ wei muⱡeing nitim. Mong rumbina wamp mbʉ, nana mong makilik kʉneing. Wamp mat mbun mam tʉk mormin mbʉ, etpa piya ndumba. ");
INSERT INTO med_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wote, Got elim nga wamp etpa tʉmba ui ei, nimba mot nduimp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wote Jisas ni, ik nimba pora ndupa kʉn, buk ni kʉⱡ tʉpa rʉp etʉm wu ni, elim ngumba kʉn, Jisas ni mana murum. Atinga manga kel ila morung wamp nimbʉ ndi, Jisas mong rʉk rʉk etʉk kandrʉng. ");
INSERT INTO med_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wote Jisas ndi, wamp mbʉ kundpa nimba mel, “Got nga ik mong kat buk ila, enim kʉmp rop ngʉnt pʉnmin ni kʉⱡ akup omba kupa enim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nitim ila, wamp mbʉ ndi, Jisas nga kaip nʉndʉk ik mong kai mat nitim nimbʉ, pilik min ngʉn mundʉk etʉng. Wote, wamp mbʉ ndi nʉk mel, “Tʉn pʉtmʉn ni, wu ei, Josep nga kangʉm ni ka, ik mong min ngʉi ninim kʉⱡ namba etpa ninim nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisas ndi, wamp mbʉ, kundpa nimba mel, “Kupa, enim ndi, na ik ek ti rok, wu dokta ye! ‘Ninim nga kʉng kʉⱡ etkʉn kai iti!’” ning. Wote enim ndi, nʉk mel, “Jisas nim ndi, Kaperniyum kona ila uⱡ itʉn pitmin ni mel, akup ya nim nga mʉi kona ila uⱡ ei mel ku iti!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wote Jisas ndi, nimba mel, “Enim ik kupa ei, kundʉp nʉnt. Mʉi puⱡ painui wu ti, elim nga mʉi kona ila wamp mbʉ ndi, numan ngui nganggʉrmʉn. ");
INSERT INTO med_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Enim ik kupa kat kundʉp nʉnt, unt wu Ilaija murum ei kʉn, amp wiya mat ou ndupa, wam ila korung mbʉ, Isrel mʉi kona ila morung. Ui ei kʉn, kona ndamʉng rui narʉⱡnga, pana raldika, kalimp tʉmbʉkak pʉmp raⱡ pip omba purum ei kun, Israel nga kona mbila pora, kump kun mam ti titim. ");
INSERT INTO med_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ui ei kʉn, Got ndi, Ilaija tʉpa, Isrel kona ila amp wiya ti kʉn, tʉpa mundi nʉmʉndrʉm mon! Got ndi, Ilaija tʉpa, Sairon ni, mʉi kona ei nga kona peng kel Sarapat ila, amp wiya tenda ti, murum ila tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Uⱡ ei mel ku, painui wu Ilaisa murum ei kʉn, Isrel mʉi kona ila kint pombuⱡma wamp ou ndupa morung. Wamp kʉⱡ nga ti kep, kui pora ni nʉndʉtʉm mon. Wote, Siriya mʉi kona ila wu, Neiman nga kui ei mint kapⱡa itim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas ik nitim ni, atinga manga kel ila morung wamp nimbʉ, pilik popʉⱡ ndi korung. ");
INSERT INTO med_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wamp nimbʉ ndi, Jisas makrʉk tʉpʉn, kona peng ei nga ekit orunga komnga mong kit punt ronggʉt, mondpʉn rop mana nduimin nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","I etʉng ni wote, Jisas pilpa kongundpa kiyang nimba, wamp nimbʉ, tʉpa ruip ndupa purum. ");
INSERT INTO med_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wote Jisas ni, Galili wamp kʉⱡ nga Kaperniyum kona peng nila mba, mowi kor ui ei kʉn, wamp mbʉ ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jisas nga ik mbo inditim mbʉ, ronduⱡ mam ti pendpa nilinga, wamp mbʉ pilik min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Atinga manga kel nila, wu ti kur kit rukʉr orunga murum ti, ila rʉk murum. Wu ni, ronduⱡ wi ropa ke nimba mel, “Nim Nasaret wu Jisas ye! Nim tʉn kʉn, namba uⱡ ti itʉn on? Tʉn etkʉn kit mundun on ei? Nim wu nam ei, na ndi, nim pilip mor. Nim Got nga Wu Wingti ei!” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ni kʉn, Jisas ndi, kur kit ni, ik mura ngumba nimba mel, “Nim ik ni nandkʉn, wu ei, wak rokʉn kelkʉn pi,” nitim. Wote, kur kit rukʉr orunga murum ni ndi, wu ni nga kʉng ombil kʉⱡ purpur ropa, wu ni ropa mundrum ila, mana mba wamp morung kona nila mba pitim. Wote, kur kit ni ndi, wu ni wak rurum. Kur kit ni ndi, wu ni, ropa nit pindi nʉpʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wote, wamp morung nimbʉ ndi, uⱡ ni kandʉk, min ngʉn mundʉk, en enim rʉk nʉk, int yant etʉk nʉk mel, “Ik mong mbo endnim ei, namba ik ti nda? Wu ei, ik ronduⱡ mbʉ ik nilinga, wu ei nga kur kit rukʉr orunga moⱡʉng mbʉ, wak rok ok pʉnmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wamp mbʉ ndi, Jisas nga itim uⱡ ni kandʉk, int puk kona mbila nʉk mek puⱡina, uⱡ itim kʉⱡ, wamp mbʉ pora, pilik kapⱡa endʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wote, Jisas atinga manga kel ila murum ni, wak ropa mba, Saimon nga manga ila mukʉr purum. Saimon ambʉm nga mam amp ei, kʉng muⱡ moⱡpa, kui kat rurum ila, Jisas ndi omba, amp ei nga kui ei, etpa kapⱡa indangga nʉk, Jisas wangga nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ni kʉn, Jisas ni mba, amp ni pitim nila nondpa anggilpa, kui ei, nim amp ei, wak rokʉn kelkʉn pi nitim. Wote kui ni, amp ei, wak roⱡnga, amp ni tʉngʉnda mint oⱡa moⱡpa, mba wamp rʉng nuing mbʉ, kaⱡpa tʉpa kun inditim. ");
INSERT INTO med_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ant ei mana puⱡnga, mba pilpa elinga, wamp mbʉ ndi, en enim nga wamp mat kui elpa elpa pitim nimbʉ, mek Jisas murum kona nila orung. Jisas ndi, ki oⱡa ndupa, wamp tenda tenda nimba, peng ila ambuⱡnga, kui pitim mbʉ, pora nitim. ");
INSERT INTO med_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wamp ou ndupa, kur kit rukʉr orunga murum mbʉ, nimba tʉpa mundrum ila, kur kit mbʉ ndi, wamp mbʉ wak rok ping etʉk kʉn, Jisas wi rok nʉk mel, “Nim Got kangʉm ei ka!” nʉtʉng. Jisas ndi, kur kit mbʉ, ik mura ngumba, “Enim ik ni nʉnʉi mon!” nitim. Uⱡ ei namba elinga, kur kit kʉⱡ pʉtmʉn ei, Kraist ei, Got nga kangʉm wu ei. ");
INSERT INTO med_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mʉkʉlmʉ unt, Jisas pepa murum kona peng ni, wak ropa mba, kona waka tila purum. Wamp mbʉ ndi, Jisas mba murum kona nila, kurʉk kandʉk tʉk kʉn, pi nʉpangga nʉk, imp imp etʉng. ");
INSERT INTO med_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, “Na kona peng mat ila, Got nga wamp tʉpa mumuk rui uⱡ ei nga, rʉnang ik kai mbʉ, wamp mbʉ kundʉp nʉmp ont. Ei nambuⱡ emel, Got ndi, na kongun ei, iteimp nimba tʉpa mundrum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wote, Juriya kona ila wamp mbʉ nga atinga manga kel mbila andpa, wamp ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tʉnggʉt kʉn, Jisas ni, num Genesaret nga ok, pena nila ʉnggʉtʉm. Kona nila wamp mam ti ok, Got nga ik kai mat, Jisas ndi, mbo indangga pilimin nʉk, Jisas murum kona nila nondpa ok, tʉk paⱡa etʉng. ");
INSERT INTO med_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wote Jisas ndi, kʉndrʉm mel, nu kanu raⱡ nu ok, pena ila tetʉng. Nu kanu kʉⱡ, oma wal pendʉtmʉn. Wu kʉⱡ, nu kanu kʉⱡ wak rok, oma wal kʉⱡ ⱡumʉi rok morung. ");
INSERT INTO med_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wote Jisas ni, Saimon nga nu kanu nila puka ropa, omba oⱡa purum. Oⱡa mba moⱡpa, Saimon kundpa nimba mel, “Nim nu kanu kʉⱡ onunga, kot pungaⱡ ndukʉn, na ila rukʉr ndui,” nitim. Jisas nu kanu pol ila moⱡpa, wamp ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jisas ndi, wamp mbʉ ik mbo endpa pora ndupa, wote Saimon kundpa, nimba mel, “Nu kanu kʉⱡ, mek num rʉk ting ila puk, oma wal kʉⱡ rok, num ila mana ndukʉn, mat tin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wote Saimon ndi, Jisas punt ropa nimba mel, “Wu Nuim ye! Tʉn rumbuldi oma ruimin nimbun, kongun mam ti etpʉn, mbun andʉp koinmin rʉngʉndmʉn. Ei wote, oma tenda kot kep, rui nurmin. Akup nim nʉn ei kʉn, teng ndup, oma wal kʉⱡ, rop num ila mana ndamp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wote, oma wal ni, kʉⱡ rok tʉk, num ila mana nduⱡina, oma puⱡi wal kʉⱡ, peka ropa rung nimba itim. ");
INSERT INTO med_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wu ni kʉⱡ ndi, wu kat nu kanu tila morung kʉⱡ, wi rok, tʉn tʉk rʉpʉndeing, “Wʉi!” nʉtʉng. Wote, nu kanu kat, mek oⱡina, oma nimbʉ tʉk, nu kanu raⱡ ila rʉk rʉk elingina, nu kanu raⱡ mbun etpa, num ila mana mba itim. ");
INSERT INTO med_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita ndi, oma puⱡi tʉtʉng uⱡ ni kandpa, mundmong etpa, Jisas kʉn nondpa omba, mura ropa mondpa nimba mel, “Wu Nuim ye! Na uⱡ kit mbʉ nga puⱡ wu ei. Nim ndi, na wak rokʉn kelkʉn pi,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ei kʉn, Saimon Pita kʉn, wu ʉngʉnʉl kat kunda, oma puⱡi tʉtʉng uⱡ ni kandʉk, min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon kʉn kongun tenda ila etʉng wu Jeims kʉn Jon raⱡ, wu raⱡ Sepeti nga kangʉm raⱡ kunda, min ngʉn mundrʉng. Wote Jisas ndi, Saimon Pita kundpa nimba mel, “Nim mundmong iti nʉti! Akup nim oma wal pendkʉn, tʉn ei mel, wote nim ndi, wamp mbʉ i ku etkʉn, tʉkʉn mekʉn, na kʉn uin!” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wote, wu ni kʉⱡ ndi, nu kanu kʉⱡ, mek ekit ok tek, en enim nga mel mbʉ pora, wak rok tek kelik, Jisas pep rok akil tek purung. ");
INSERT INTO med_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tʉnggʉt kʉn, Jisas ni, kona peng tila mba murum. Kona nila, kint pombuⱡma ndi, kʉng mbʉ kum rurum wu ti murum. Wu ni moⱡpa, Jisas ni kandpa omba, Jisas nga kuimp keta ila mura ropa, mondpa nimba mel, “Wu Nuim ye! Nim ndi, kapⱡa nʉkʉn pin ndam, na etkʉn kai mundun ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wote Jisas ndi, elim nga ki ni, oⱡa ndupa, wu ni minda ndupa, nimba mel, “Na kapⱡa nʉmp ei kʉn punt ei, nim nga ku, ei kapⱡa tangga. Ni kʉn, tʉngʉnda mint kui ni ndi, wu ni wak roⱡnga, wu ni eng nui kai ei, murum. ");
INSERT INTO med_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas ndi, ronduⱡ mundpa wu ni, kundpa nimba mel, “Ya uⱡ nim kʉn em kʉⱡ, wamp ti kundkʉn, ni nʉni mon! Nim pukʉn wu pris kʉⱡ kʉn, nim nga kʉng kʉⱡ ora ndukʉn, Moses ndi, nitim uⱡ ei mel, Got kʉn angge mel ti ngui. I in uⱡ ei ndi, wamp ndi, nim kandʉk, nim nga kui ni, pora nim ning,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ni kʉn, Jisas nga itim uⱡ kʉⱡ nga timan ik ei, pi nimba kona mbila purum. Wamp ou ndupa, Jisas nga uⱡ itim ik timan nimbʉ pilik, kui rurum wamp mbʉ, en enim etpa kapⱡa indangga, nʉk orung. ");
INSERT INTO med_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wote, ui ou ndupa, Jisas ndi, wamp mbʉ, wak ropa mondpa, kelpa mba, kona mo ropa mat ila atinga rorum. ");
INSERT INTO med_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ui ti kʉn, Jisas ndi, wamp mat, ik mbo endpa murum. Perisi wu na, mi ik mbo wu mat ila rʉk morung ku. Wu orung mbʉ, Jerusalem kona peng ou ei kʉn, Galili kona na, Juriya kona peng mbila orung. Jisas ndi, Got nga ronduⱡ ei, tepa moⱡpa, kui wamp mbʉ, etpa kapⱡa inditim. ");
INSERT INTO med_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wu mat ndi, kʉmp ki rumbʉⱡi wu ti, rupⱡaima kulk mek, Jisas murum manga nila mukʉr ping pilik orung. ");
INSERT INTO med_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wamp ndi, manga ni ti, nimba murum ila kui wu ni, mek mukʉr ping nombuⱡa mam ti, ti nʉtʉtʉm. Kui wu ni, rupⱡaima pʉkʉ mek, Jisas murum manga nila oⱡa puk, manga im ni, rokʉtʉk tek, kui wu pitim rupⱡaima ni kʉⱡ, kan kulk mana nduⱡmina mba, Jisas murum kuimp keta nila kun titim. ");
INSERT INTO med_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas ndi, wu kʉⱡ nga mondʉk pilik uⱡ etʉng ei, kandpa kui wu ni, kundpa nimba mel, “Wu ang ye! Nim nga, uⱡ kit mbʉ, na ndi, pendʉp kent,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ni kʉn, Perisi wu na, mi ik mbo wu na mbʉ ndi, en enim ik nʉk, int yant etʉk nʉk mel, “Wu ei nam? Got tʉpa wʉlʉ mundnum ei ka! Wamp ti ndi, kapⱡa wamp nga uⱡ kit etmin mbʉ, pendpa kili nakilmba. Uⱡ kit mbʉ, Got tenda ei ndi mint, uⱡ kit pendpa ketʉm,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wu kʉⱡ nga numan pilik ik nʉtʉng ni, Jisas ndi, pilpa pora ndupa, wu kʉⱡ kundpa nimba mel, “Nambuⱡ emel, enim nga numan ila ik kʉⱡ pilik mormin. ");
INSERT INTO med_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Namba ik i wei wei etʉp nimp? Na nim nga uⱡ kit mbʉ, wak rondʉnt, muna rupⱡaima kʉⱡ mekʉn anggilkʉn pi? ");
INSERT INTO med_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na ndi, enim pileing nʉmp nʉnt, ‘Muⱡʉl Wu Kupa ei, ya mʉi kona ila ronduⱡ ei, mepa urum ei ndi, kapⱡa uⱡ kit mbʉ wak romba,’” nitim. Wote Jisas ndi, kʉmp ki rumbrʉm wu ni, kundpa nimba mel, “Nim kundʉp nʉnt. Nim oⱡa molkʉn, nim nga rupⱡaima kʉⱡ tʉkʉn, mekʉn mang kona pi,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tʉngʉnda mint, wu ni run nimba, oⱡa anggilpa, wamp nga kuimp keta nila, elim nga rupⱡaima ni kʉⱡ, tʉpa mepa, Got nga mbi paka rondpa mang kona purum. ");
INSERT INTO med_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wamp mbʉ ndi, Jisas uⱡ itim ni kandʉk, min ngʉn mundʉk. Got nga ronduⱡ mam ti, kongun enim, kanmʉn nʉk, Got nga mbi paka rondʉk nʉk mel, “Akup uⱡ elpa ti mel kanmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wote, Jisas ni mba, kʉndrʉm mel, ku takis tʉtmʉn manga nila wu ti, ku takis tʉpa murum. Wu ei nga mbi ei Lipai. Wote Jisas ndi, wu ni, kundpa nimba mel, “Nim na pep rokʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wote, wu Lipai ni, mel mbʉ pora, wak ropa tepa kelpa, Jisas pep ropa purum. ");
INSERT INTO med_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lipai ndi, rʉng mam ti, Jisas tʉpa tʉma endpa kʉndrʉm. Ku takis tʉtmʉn wu mbʉ kʉn, wote wu elpa mat kunda, wu raⱡ kʉn, rak nduk molk, rʉng norung. ");
INSERT INTO med_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ni kʉn, Perisi wu na, mi ik mbo wu na mbʉ ndi, Jisas nga kitip kʉni wu kʉⱡ kʉn, ik ou nduk nʉk mel, “Nambuⱡ emel, ku takis tʉk, uⱡ kit mbʉ etmin wamp mbʉ kʉn, rak nduk, rʉng nok mormin?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas ndi, wu ik nʉtʉng ni, punt ropa nimba mel, “Wamp ti, kui rui narʉm ni, dokta kʉn pi napʉrʉm ei ka! Kui rorum wamp ei mint, dokta kʉn purum. ");
INSERT INTO med_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Uⱡ ei mel ku, na ur ei, wamp kun kai mbʉ, numan ropʉl reing nʉmp ui nʉwʉr mon. Na ndi, wamp kit mbʉ, wi ramba kʉn, numan ropʉl reing nʉmp ur,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wu mat ndi, Jisas kundʉk nʉk mel, “Ui mat ou ndupa, Jon nga kitip kʉni wu kʉⱡ kʉn, wote Perisi kitip kʉni wu kʉⱡ kʉn, rʉng mowi rʉk rʉk pek, atinga rʉk rʉk rok etʉng. Wote, nim nga kitip kʉni wu kʉⱡ, rʉng na, nu na mbʉ normin ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wote Jisas ndi, wu kʉⱡ kundpa nimba mel, “Wu nam ti, amp kokila tʉmba ei kʉn, enim ndi, wu ei nga wamp mbo mbʉ kʉn, rʉp ropa muⱡangina kʉn, wamp kʉⱡ, rʉng mi rok nandʉk muⱡing nda, ei mon! ");
INSERT INTO med_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wote, amp tʉmba wu ei, wamp mat ndi, tʉk mek pangina kʉn, wu ei nga wamp mbo mbʉ, en enim molk kʉn, rʉng mowi ping,” nitim. ");
INSERT INTO med_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wote Jisas ndi, ik ek ti ropa, wu kʉⱡ kundpa nimba mel, “Wal pʉki ping unt nga kat, rʉr rom ndam, wamp ti ndi, kapⱡa muⱡ kont ti ondpa tʉpa, wal pʉki unt nga kʉⱡ, rumbʉⱡi nambʉⱡʉmba mon. Uⱡ ei em ndam, muⱡ kont ei, etpa kit mondʉmba. Wal pʉki unt nga kʉⱡ kʉn, muⱡ kont ei kʉn, to tenda mel kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kng meme kʉng unt nga kʉⱡ ila kanda, nu wain kont ei kulk, tʉk oi ndʉng mel mon. Uⱡ ei em ndam, kng meme kʉng kʉⱡ, rok nimba, nu wain kont ei, mʉi ting ila, oi nimba moⱡmba. Kng meme kʉng kʉⱡ, kit moⱡmba ku. ");
INSERT INTO med_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nu wain kont ei kolk, tʉk kng meme kʉng kont ila oi ndurmʉn. ");
INSERT INTO med_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wamp nam ti, nu wain unt nga nom ndam, wote nu wain kont ei, numan ngui nganggʉrʉm. Wamp ei, nimba mel, ‘Nu wain unt nga ei ka!’” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mowi kor ui ti kʉn, Jisas kʉn elim nga kitip kʉni wu ni kʉⱡ kʉn, wit pana rʉk ting tila purung. Kitip kʉni wu ni kʉⱡ ndi, puk mel, wit mong nimbʉ, oldʉk tʉk, ambulk mitʉk roⱡina, kʉng mbʉ puⱡnga, mong mbʉ nok purung. ");
INSERT INTO med_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Uⱡ etʉng ni, Perisi wu mbʉ ndi kandʉk, nʉk mel, “Uⱡ kʉⱡ, Mowi Kor ui ei kʉn, tʉn nga mi ik ei ndi, mon nʉtʉm ndi, nambuⱡ emel enmin?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Wote Jisas ndi, Perisi wu kʉⱡ nga nʉtʉng ik ni, punt ropa nimba mel, “Enim ndi, Depit nga timan ropa pinditim kʉⱡ, kʉmp rok kʉni nakʉndʉrmin ei? Unt Depit kʉn, el elim nga wu rʉⱡaip kʉⱡ kʉn, kump kun kurung ei kʉn, Depit ndi, Got nga manga ila mukʉr mba, Got kʉn angge nʉk, bret tetmin mbʉ titim. Bret kʉⱡ, wu pris mbʉ mint normin. Wamp mbʉ, mi rok mon nʉtmin. Wote Depit ndi, bret mbʉ, tʉpa nomba, wote elim nga wu rʉⱡaip mbʉ, mok ropa ngumba itim ku,” nitim. ");
INSERT INTO med_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wote Jisas ndi, ik ti nimba mel, “Muⱡʉl Wu Kupa ei ndi, Mowi Kor ui ei, rʉp etʉm!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mowi kor ui ti kʉn, Jisas ndi mba, atinga manga kel nila mba, wamp ik mbo endpa murum. Manga nila wu ti murum ei nga, ki mbo orunga kit itim. ");
INSERT INTO med_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wote, ik mbo wu mat kʉn, Perisi wu na nimbʉ ndi, Jisas tʉk kongundʉk morung. Ei nambuⱡ emel, Mowi Kor ui ei kʉn, Jisas ndi, kui wamp mbʉ, etpa tʉm ndam, Jisas kot indimin nʉk pilik, nokundʉk morung. ");
INSERT INTO med_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wote, wu kʉⱡ nga pʉtʉng numan ni, Jisas ndi, pilpa pora ndupa kʉn, ki rumbrʉm wu ni, kundpa nimba mel, “Nim ya wamp mbʉ nga kuimp keta ila, oⱡa ʉnggʉli!” nitim. Wote wu ni, oⱡa ʉnggʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisas ndi, wamp mbʉ, kundpa nimba mel, “Na ndi, enim ik ti wuldimp ent. Tʉn nga mi ik ei ndi, tʉn Mowi Kor ui ei kʉn, namba uⱡ mbʉ, itʉmin nʉtʉm? Uⱡ kit mbʉ, itʉmin nʉtʉm, muna uⱡ kai mbʉ itʉmin nʉtʉm nda? Tʉn ndi, wamp mbʉ, tʉpʉn rapundpʉn, etpʉn kai itʉmin nʉtʉm, muna wamp mbʉ, etʉp kit mundmin nʉtʉm nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jisas ndi, wamp morung nimbʉ, kandpa pok etpa kʉn, ki rumbrʉm wu ni, kundpa nimba mel, “Nim nga ki ei tʉkʉn, run ndui!” nitim. I nilinga, wu ni nga ki ni tʉpa, run nduⱡnga, omba kun purum. ");
INSERT INTO med_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wote, mi ik mbo wu nimbʉ kʉn, Perisi wu na nimbʉ, popʉⱡ ndi kolk, en enim nʉk, int yant etʉk nʉk mel, “Tʉn ndi, Jisas ni wu ei, namba uⱡ ti itmin nda,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ui ei kʉn, Jisas ni, elim Got kʉn atinga ruimp nimba, komnga nila purum. Mba, rumbuldi atinga ropa moⱡnga, kona ni rʉnggʉrʉm. ");
INSERT INTO med_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kona ranggʉpa, ant kuimp oⱡnga, Jisas ndi, elim nga kitip kʉni wu nimbʉ, wi ropa rʉk tʉpa mondpa, elim nga kitip kʉni wu 12 kat, nombuⱡa rung wu nimba, mbi tepa ngurum. ");
INSERT INTO med_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Wu ti nga mbi Saimon, wote Jisas ndi, wu ei, mbi tepa, Pita nitim. Ei nga, ʉngʉn Andru kʉn, Jeims, Jon, Pilip, Bartolomiyu, Matyu, Tomas, wu Alpiyas kangʉm Jeims, Saimon ni, wu Selot rʉⱡaip kʉⱡ nga. ");
INSERT INTO med_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jeims kangʉm Juras, Juras Iskariyot ni wu ei, wote Jisas ruk moⱡpa itim wu ei. ");
INSERT INTO med_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, komnga morung ni, wak rok, kelik mana ok, kona kai tila morung. Wamp puⱡi, Jura kona na, Jerusalem kona peng na, Tair kʉn, Sairon kona raⱡ nga nondpa, nu wung ila na, petmin wamp mbʉ pora, ok morung. ");
INSERT INTO med_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wamp orung mbʉ, Jisas nga ik nitim mbʉ, kum tek pilik, kui rurum wamp mbʉ, Jisas ndi, etpa tangga nʉk, wote kur kit rukʉr orunga murum wamp mbʉ, etpa tangga nʉk orung. ");
INSERT INTO med_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wote, wamp mbʉ nga ki mbʉ ndi pora, Jisas ni, minda ndʉmin nʉk pilik etʉng. Ei nambuⱡ emel, kui wamp mbʉ ndi, Jisas minda ndurʉng ei kʉn, Jisas nga ronduⱡ ei ndi, kui rurum wamp mbʉ, etpa titim. ");
INSERT INTO med_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas ndi, elim nga kitip kʉni wu kʉⱡ, kundpa nimba mel, “Enim wamp kurpa mbʉ, numan wang ndʉi, Got nga wamp tʉpa mumuk rui uⱡ ei, enim nga mint. ");
INSERT INTO med_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Enim akup kump kun ndi kormʉn wamp mbʉ, numan wang ndʉi! Wote ei kʉn, enim rʉng nangina, pilʉng etmba. Enim akup ka etʉk mormʉn wamp kʉⱡ, numan wang ndʉi! Wote ei kʉn, enim oi iting. ");
INSERT INTO med_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Enim ndi, Muⱡʉl Wu Kupa ei nga uⱡ mbʉ, pep rok pangina kandʉk kʉn, wamp mbʉ ndi, enim kʉn numan kit piling. Wamp mbʉ ndi, enim makrʉk mundʉk, ik kit nʉk ngʉk iting. Wote, wamp mbʉ ndi, enim nga mbi ei, nʉk kit munding. Uⱡ mbʉ mel, enim kʉn om ndam, enim numan wang nduk muⱡʉi! ");
INSERT INTO med_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wamp mbʉ ndi, enim kʉn uⱡ kit mbʉ eng ndam, enim ambulk palk numan kai pilik muⱡʉi! Enim nga mel mam kai mat, muⱡ kona ila tinditim ei tetʉm. Nambuⱡ emel, wamp mbʉ nga anda kouwʉmin mbʉ ndi, uⱡ ei mel ku, painui wu mbʉ kʉn etʉng. ");
INSERT INTO med_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Enim kng mel pi wamp mbʉ, akup pilik kun etʉk muⱡʉi! Enim wi muⱡ kona ila ting mel ei, ya mʉi kona ila tʉk pora ndurmin. ");
INSERT INTO med_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Akup enim rʉng nok pilʉng kundʉk mormin wamp mbʉ, pilik kun etʉk muⱡʉi! Wote, enim kump kun kuⱡing. Akup enim oi etʉk mormʉn wamp mbʉ, pilik kun etʉk muⱡʉi! Wote, enim ka itangina, ka nu mel omba mba. ");
INSERT INTO med_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wamp mbʉ, ndi, enim nga kʉng orunga mbi paka rok, mek oⱡa pung ndam, pilik kun etʉk muⱡʉi! Nambuⱡ emel, wamp mbʉ nga unt nga anda kouwʉmin mbʉ ndi, i ku etʉk, ik kol rok painui wu mbʉ nga kaip nʉndʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wote Jisas ndi, aldpa nimba mel, “Na nga ik nʉnt ei kum tepa pilim wamp ei ndi, el puⱡa wamp mbʉ, numan ngangga, nim kʉn, ik kit nim wamp ei, uⱡ kai mbʉ etkʉn ngui! ");
INSERT INTO med_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wamp mat ndi, enim ik mura ngʉng ndam, enim ndi, wamp ei, Got ndi, memp pindangga nʉi! Wote, wamp ti ndi, enim rom ndam, wamp ei nga, Got kʉn atinga rundʉi! ");
INSERT INTO med_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wamp ti ndi, nim ki ⱡʉrwʉ ndi rom ndam, wote keng orunga nont ndana pendpa rangga! Wamp ti ndi, nim nga wal pʉki ekit orunga kʉⱡ tʉm ndam, wote wal pʉki rukʉr kʉⱡ kunda tangga, kandkʉn kui iti! ");
INSERT INTO med_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wamp mat ndi, nim mel mat mawa eng ndam, mawa eng mel mbʉ ngui! Wamp ti ndi, nim nga mel mat roldpa tʉm ndam, wote mel mbʉ, nim yant ndupa ngangga nʉkʉn, mawa iti nʉti! ");
INSERT INTO med_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wote, wamp mat ndi, enim nga uⱡ mat, indeing nʉk numan pʉtmʉn ei mel ku, enim ndi, wamp mbʉ nga ei mel ku indʉi! ");
INSERT INTO med_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Wamp mat, enim numan ngʉng mbʉ mint, pep rok numan ngʉng ndam, memp kai ei, etʉk ting mel nant? Uⱡ kit etmin wamp mbʉ ndi, ku etʉk, en enim numan ngurmin wamp mbʉ, pep rok numan ku ngurmin. ");
INSERT INTO med_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wamp mat, enim kʉn uⱡ kai eng wamp mbʉ kʉn, pep rok, uⱡ kai mbʉ mint eng ndam, enim memp kai ei etʉk ting mel nant? Uⱡ kit etmin wamp kʉⱡ, uⱡ to tenda ei mel ku etmin. ");
INSERT INTO med_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Enim ndi, wamp mat mel mbʉ, ngurmin uⱡ ei, enim punt rok, yant ngeing mint nʉk pilik etmin. Wote, enim memp kai ei, etʉk ting mel nant? Uⱡ kit etmin wamp mbʉ ndi, ei mel ku etʉk mel mbʉ, wamp mat, punt mondʉk ngʉk kʉn, wote punt rok, ngeing mint nʉk pilik etmin. ");
INSERT INTO med_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ei mon, enim nga el puⱡa wamp mbʉ, numan minal ngʉk, uⱡ kai mbʉ mint itʉi! Enim ndi, wamp mbʉ, mel mat ngʉk kʉn, punt rok yant ngui ngʉngeing nʉk, pili nʉpʉlʉi mon! Uⱡ mbʉ, pep rok eng ndam, enim nga puⱡ wamp mbʉ, memp kai mat tetʉm mbʉ, wote ting. Wote, enim Got Oⱡa Nuim ei nga kangambuⱡa mel muⱡeing. Wote, uⱡ kit mbʉ etʉk, Got kʉn angge ni nandʉk etmin wamp mbʉ, Got ndi, numan minal ku ngurum. ");
INSERT INTO med_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Enim nga Got Tipam ndi, wamp pora, kont kurum uⱡ ei mel, enim ndi, wamp mbʉ pora, i ku etʉk, kont minal kʉⱡʉi! ");
INSERT INTO med_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wote Jisas ndi, ik ti wamp mbʉ, kundpa nimba mel, “Enim ndi, wamp mat nga uⱡ kit eng mbʉ, kʉmp ti nʉtʉi mon! Wote Got ndi, enim kʉmp tʉmba. Enim ndi, wamp mat nga uⱡ kit mbʉ, wak rundangina kʉn, wote Got ndi, enim nga uⱡ kit mbʉ, wak ku rondʉmba. ");
INSERT INTO med_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Enim ndi, mel mat ou ndupa, wamp mbʉ ngʉng ndam, wote Got ndi, enim mel mat ou ndupa, kʉmp tʉpa mel kai mat ngangga, peka romba. Wote, pi rok mana tangina kʉn, oⱡa oi nimba ei mel kapⱡa. Enim ndi, mel mat wamp ngurmin to ni mel ku, Got ndi enim i ku etpa ngumba. ");
INSERT INTO med_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas ndi, ik ek ti ropa, nimba mel, “Mong ti wamp ti ndi, kapⱡa mong ti wamp ti, nombuⱡa mam ora ndumba, ei mon! Ei mel enggil wamp raⱡ kunda, kut ila mana pinggil. ");
INSERT INTO med_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kangambuⱡa ti ndi, elim nga ik mbo wu ei, kapⱡa tʉpa mana ndui nandʉmba mon! Kuimp tʉpa man ik pilpa tʉpa pora ndupa kʉn, wote ik mbo wu ei mel kapⱡa moⱡmba. ");
INSERT INTO med_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nambuⱡ emel, nim ndi, ʉngʉn nga ʉi moⱡ kel ti, mong waⱡ ila tetʉm ei, kandkʉn nʉkʉn purʉn. Wote, nim nga mong waⱡ ila, nde koⱡmung mam ti, peta ropa petʉm ei, pilkʉn nʉtʉn nda? ");
INSERT INTO med_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nim nga mong waⱡ ila, nde koⱡmung mam ti, peta ropa tetʉm ei, kʉni nakʉndkʉn kʉn, nambuⱡ emel, ʉngʉn nga mong waⱡ ila ʉi moⱡ kel ei, tʉkʉn mundun pilkʉn nʉtʉn nda? Nim wamp kai ti, molkʉn kʉn, wamp ei kondkʉn nʉtʉm nda? Unt, nim nga mong waⱡ ila, nde koⱡmung mam ei, kuimp tekʉn tʉkʉn mundkʉn kʉn, wote ʉngʉn nga mong waⱡ ila, ʉi moⱡ kel ei, kandkʉn tʉkʉn mundun,” nitim. ");
INSERT INTO med_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wote Jisas ndi, ik ti nimba mel, “Nde kai kʉⱡ ndi, nde mong kit mat rui narʉrʉm mon! Wote, nde kit kʉⱡ ndi, nde mong kai mat rui narʉrʉm, mon! ");
INSERT INTO med_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wamp mat ndi, nde ei nga, nde mong rorum ei ndi, kit muna, kai ei unt kandʉk pʉtmʉn. Ei nga, ruwa rʉⱡwa ila neka kai ei, rui narʉrʉm mon! Wote, rakʉm ila ru keningina kai ei, rui narʉrʉm mon ku. ");
INSERT INTO med_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wote, wamp kai mbʉ ndi, numan kai mbʉ nga puⱡi mundmong orunga pendʉk kʉn, uⱡ kai mbʉ mint etmin. Wamp kit mat ndi, numan kit mbʉ nga puⱡi mundmong orunga pendʉk kʉn, uⱡ kit mbʉ etmin kʉⱡ, mundmong rukʉr orunga, tepa oⱡa oⱡnga kʉn, keta ila nʉk ekit ndurmin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Wote Jisas ndi, nimba mel, “Nambuⱡ emel, na ‘Wu Nuim, Nuim’ nʉk, mbi mundʉnmin? Wote enim ndi, na nga ik nʉnt kʉⱡ, pilik pep rui narʉnmin ei ka! ");
INSERT INTO med_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wamp nam ti, na kʉn omba, na nga nʉnt ik mbʉ, kum tepa pilpa, pep ropa em ndam, wamp ei nga puⱡ ei na ndi, enim kʉn nʉmp mot nduimp. ");
INSERT INTO med_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wamp ei, wu ti manga rakʉmba pilpa, unt mʉi ila kut tʉpa mana mba kʉn, ku mam mbʉ, kandpa tʉpa kʉn, pol ila mang rakʉpa mepa oⱡa urum. Wote, kona ndamʉng tʉma ropa, nu kui omba, kʉpkʉ ropa etʉm ei kʉn, manga ei omba, mana pi napʉtʉm, mon! Nambuⱡ emel, wamp ei ndi, manga ronduⱡ ei, ku pol ila rakrʉm ei ndi, gi nimba anggʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wote, wamp nam ti ndi, na nga ik nʉnt mbʉ, kum tepa pilpa, pep rui narʉm ndam, wamp ei wu ti, elim nga manga ei, oⱡa mʉi pol ila mendpʉⱡ, rakpa mondrum ni mel kapⱡa. Wote, kona ndamʉng tʉma ropa, nu kui omba, kʉpkʉ mam mat, ropa etʉm ei kʉn, manga ei, tʉkrʉpa mint ʉⱡmbʉⱡ nimba, mana petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas ni, wamp ik mbo endpa pora ndupa, wote Kaperniyum kona peng ila purum. ");
INSERT INTO med_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kona peng ila Rom el nde wu kuimbal ti, el wu 100 nokʉndrʉm. Ei nga, kongun wu ti, numan minal ngurum ni, kui ropa koⱡmba itim. ");
INSERT INTO med_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","El nde wu kuimbal ni, moⱡpa pitim mel, Jisas ni, onum nʉtʉng. Ni kʉn, Jisas ndi, elim kongun wu ei etpa tangga nimba, Jura wu nuim kat, Jisas kʉn pʉi nimba tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wote, wu ni kʉⱡ, rʉng puk, Jisas murum kona nila, ronduⱡ mundʉk, Jisas kʉn kont kaimp ik ranggʉk, nʉk mel, “Wu kai ti nga elim nga kongun wu koⱡmba enim ei, nim ndi okʉn, wu ei tʉk rʉpʉndʉn nimbun onmʉn. ");
INSERT INTO med_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ei nambuⱡ emel, wu ei ndi, tʉn Jura wamp mbʉ, numan ngumba, tʉn nga atinga manga kel ei, rakʉndpa itim,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wote Jisas ni, wu ni kʉⱡ kʉn, rʉp rok yant ok, manga keta kona nila, nondpa oⱡina kʉn, el nde wu kuimbal ni ndi, wu kat tʉpa munduⱡnga puk, Jisas kundʉk nʉk mel, “Wu Nuim ye! Nim numan ti, pili nʉpili! Na wu kai ti mon! Ei nga, manga ila mukʉr uin mel mon! ");
INSERT INTO med_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wote, na wu kai ti mon ei nga, Jisas omp kʉnimp mel mon ku. Jisas ruⱡ etpa moⱡpa, ik ei nangga kʉn, nangga kongun wu ei nga kui ei, kapⱡa itangga! ");
INSERT INTO med_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na nʉnt wu ei, na nga wu nuim ei ndi, kongun mat ngurum ei kʉn, wu nuim ei nga mana orunga moⱡʉp endʉt. Wote, na nga el wu mbʉ, na nga mana orunga mormʉn. Na ndi, wu ti kundʉp, ‘nim pi,’ nʉt ndam, wu ei purum ku. Wote wu ti, ‘yant wangga,’ nʉt ndam, wu ei yant orum ku. Kongun wu ei kundʉp, ‘kongun tangga’, nʉt ei kʉn, kongun etʉm ku,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wote Jisas ndi, el nde wu kuimbal ni nga, ik nitim ni pilpa, ʉⱡi ropa, tʉpa peling ndupa, wamp rʉⱡaip mam ti, elim pep rok orung nimbʉ, kundpa nimba mel, “Isrel kona ila wamp ti, mondpa pili uⱡ ei nga, na kʉni nakʉndʉr mel, wu ei ndi, ninim kant!” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","El nde wu kuimbal ei ndi, tʉpa mundrum wu ni kʉⱡ, kelik mang kona int puk, kongun wu kui rurum ni, kandrʉng mel kui ni, kapⱡa elinga, wei murum. ");
INSERT INTO med_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wote, ui ti kʉn nondpa ku, Jisas elim nga kitip kʉni wu kʉⱡ kʉn, wamp rʉⱡaip mam ti kunda, Nein kona peng ila, ping pilik purung. ");
INSERT INTO med_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jisas ni mba, kona peng ei nga paⱡa keta puⱡ puⱡ ila nondpa puⱡnga, wu kurum ti nga on ei, ting pilik, rupⱡaima kulk, mek ekit orung. Kang wu kurum ei, amp wiya ei nga kang tenda mitim ei. Kona peng ila wamp puⱡi, amp ei kʉn, koⱡa manga molk kunda rʉp rok orung. ");
INSERT INTO med_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wote Jisas ndi, amp wiya ni, ka etpa urum ni, kandpa kont ndi, koⱡpa amp ni, kundpa nimba mel, “Nim ka iti nʉti!” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jisas ndi, kang wu on rupⱡaima kulk, mek orung nila, nondpa mba anggilpa, ki oⱡa ndupa, nimba mel, “Kang wu kumʉndʉp ye! Nim kundʉp nʉnt rut nʉkʉn oⱡa muⱡi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kang wu kurum ni, rut nimba, oⱡa moⱡpa, ik mat puⱡ mondpa nitim. Wote Jisas ndi, kang wu ni, tʉpa mam ngurum. ");
INSERT INTO med_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Uⱡ itim ni, wamp mbʉ kandʉk, min ngʉn mundʉk, Got nga mbi paka rondʉk, nʉk mel, “Painui wu ou ti, tʉn kʉn om. Wote, Got ni omba, elim nga wamp mbʉ, tʉpa rapʉndʉmba, pilpa om,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wamp nimbʉ ndi, int puk, Jura kona peng na, wote kona mbila elpa elpa puk, Jisas nga itim uⱡ kʉⱡ, timan rok nʉk, mek purung. ");
INSERT INTO med_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Wamp nu tindi wu Jon nga kitip kʉni wu kʉⱡ ndi, Jisas nga uⱡ itim kʉⱡ kandʉk ok, Jon elim kundʉk nʉtʉng. Wote Jon ndi, elim nga kitip kʉni wu raⱡ tʉpa kʉn pukʉⱡ, Jisas waldkʉⱡ ni kʉⱡ mel. “Nim wu ei, Jon ndi, wu ti akil tepa omba nokundmʉn nitim wu ni, muna tʉn wu elpa ti, omba nga nokundmin nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wote, wu ni raⱡ, Jisas murum kona nila rʉk pukʉⱡ, nʉkʉⱡ mel, “Wamp nu tindi wu Jon ndi, tʉl tʉpa mundpa, nimba mel, ‘Nim Got ndi, tʉpa mundʉmba nimba, Jon ndi, nitim wu ei muna tʉn wu elpa ti nokundmin nda?’” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ui ei kʉn, Jisas ndi, wamp kui elpa elpa rurum mbʉ, etpa tʉpa, wote kur kit rukʉr murum wamp mbʉ, nimba tʉpa mundpa, wote mong ti wamp mbʉ nilinga, kona kandrʉng. ");
INSERT INTO med_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wote Jisas ndi, wu raⱡ nga ik ni, punt ropa nimba mel, “Akup enmbil kʉⱡ, enmbil kandkʉⱡ pilkʉⱡ kʉⱡ, enmbil uⱡ kʉⱡ mel pukʉⱡ, Jon kundkʉⱡ nʉl! Mong ti wamp mbʉ, kona kanmin, kʉmp elkʉna rumbʉⱡi wamp mbʉ, nombuⱡa mam andinmin, kint pombuⱡma wamp mbʉ nga kʉng mbʉ, eng nonum, kum ngurum wamp mbʉ, ik pʉnmin wamp korung mbʉ, etpa kont tʉnʉm. Wamp kurpa mbʉ kʉn, Rʉnang Ik Kai mbʉ, kundpa ninim. ");
INSERT INTO med_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wamp ti, na kʉn mondpa pʉtʉm uⱡ ei, wak rui narʉm ndam, kai pilangga!” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wote, Jon nga wu ni raⱡ puⱡʉnggila kʉn, Jisas ndi, Jon nga ik mat, wamp minal morung ila kundpa, nimba mel, “Enim ndi, Jon kona kui waka ila kʉning purung ei kʉn, namba mel ti, kʉnmin nʉk pʉtʉng? Enim ʉi ongum na mel ti, kʉpkʉ ropa roka nitim ila, kʉning purung ei? ");
INSERT INTO med_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Enim namba mel ti, kʉning pilik purung? Wu ti, mʉkʉ etpa murum ila kʉning pilik purung ei? Mʉkʉ etmin wamp mbʉ, rapa keta ila mint molk etmin. ");
INSERT INTO med_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Enim namba mel ti, kʉning pilik purung ei, na kundʉk nʉiya? Enim painui wu ti, kʉning purung. Ei kupa painui wu ei ndi, painui wu ei ndi, wu mat tʉpa mana ndurum. ");
INSERT INTO med_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Buk Wingti ila Got ndi, Jon nga nʉndpa mel, ‘Na nga nombuⱡa rung wu ti, kuimp tʉp mundamba kʉn omba, Got nga omba wu ei nga nombuⱡa mam ei, tʉpa kun etpa rondpa moⱡmba!’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ndi, enim kundʉp nʉnt. Ya mana mʉi kona ila morung, wu mbʉ pora, Jon ndi, tʉpa mana ndurum. Wote, akup wamp nam ti ndi, Got nga tʉpa mumuk rui uⱡ ei, wamp mbi mul nʉmbil wamp mel raⱡpa moⱡum ndam, Jon tʉpa mana ndumba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wote, ku takis tʉtmʉn wu mbʉ kʉn, wamp na morung nimbʉ ndi, Jon nga ik nitim nimbʉ pilik, Got nga uⱡ mbʉ, kapⱡa itmin nilingina, Jon ndi, wamp mbʉ nu tinditim. ");
INSERT INTO med_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wote, Perisi wu na, mi ik mbo wu mbʉ ndi, Jon nga nitim ik nimbun pilik tʉk mbʉⱡ ngʉk, Got nga uⱡ mbʉ, iti nʉtmin nilingina, Jon ndi, wu mbʉ nu tindi nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Wote Jisas ndi, ik nimba mel, “Akup ya ila mormin wamp mbʉ nga enmin uⱡ kʉⱡ, nʉmp mot nduimp uⱡ ei, namba ik ek ti, rop namba kʉn, wamp mbʉ pilik ting nda? ");
INSERT INTO med_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wamp mbʉ, kangambuⱡa kel na mat, rʉng rarʉp rarmin kona mbila molk, kangambuⱡa mat ndi, mat wi rok nʉtmin ei mel, ‘Tʉn kowa pela ik ndʉmʉn ei kʉn, enim kinan ni nanʉng. Wote, kont kaimp kinan nimin ei kʉn, wote enim ka iti natʉnmin ku!’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wamp nu tindi wu Jon urum ei ndi, rung mowi pepa, nu wain nui nandpa itim uⱡ ei, wote enim ndi, wu ei, kundʉk nimba mel, ‘Kur kit rukʉr orunga morum,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Akup Muⱡʉl Wu Kupa ei omba, nu na, rʉng na mbʉ nonum ei, enim ndi, wu ei kundʉk, ‘Wu ei rʉng wal nomba, nu ming nduka nomba, enim ninmin. Wote, ku takis tʉk, uⱡ kit etmin wamp kʉⱡ kʉn, rʉp ronum ei ka!’ ninmin. ");
INSERT INTO med_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wote, Got nga pilpa kungʉndi pilik tʉtmʉn wamp mbʉ ndi, uⱡ mat etʉk, tʉn ora ndurmin, pilpa kungʉndi ei, kupa mint,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wote, Perisi wu ti ndi, Jisas ni, elim nga manga ila, rʉng nangga wangga nitim. Wote Jisas ni, Perisi wu ni nga manga ila mba, rʉng nomba murum. ");
INSERT INTO med_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ni kʉn, amp wapra ti, kona peng ila rʉk murum. Amp ni, moⱡpa pitim mel, Jisas ni omba, Perisi wu ti nga manga ila rʉng nomba morum nʉtʉng. Ik ni pilpa kʉn, kopung ming ronduⱡ mura rui ti tʉpa mepa, Jisas murum manga nila purum. ");
INSERT INTO med_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amp ni mba, Jisas murum kʉmp puⱡ ila nondpa moⱡpa, ka etpa murum. Ni kʉn, ka nu mana omba, Jisas nga kʉmp puⱡ ila urum mbʉ, amp ei ndi, elim nga peng ndi kʉⱡ ndi, kil ngurum. Wote, Jisas nga kʉmp ni, keta nu ropa nomba, kopung ni tʉpa, kopung kandpa itim. ");
INSERT INTO med_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wote, Perisi wu ni, moⱡpa kʉndrʉm mel, amp wapra ni ndi, itim uⱡ ni kandpa, numan ou ndupa pilpa, nimba mel, “Wu ei, kupa painui wu ti ndam, amp ei ndi, elim ambuⱡpa enim ei kʉn, amp ei nga uⱡ kit etʉm mbʉ, pilpa mbi ndumba. Amp ei, uⱡ kit mbʉ etʉm ndi, ka nimba pitim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wote Jisas ndi, Perisi wu ni nga numan pilpa murum ni kʉⱡ, kandpa pora ndupa, nimba mel, “Saimon, na ndi, ik ti nim kundʉp namp,” nitim. Wote Saimon ndi, Jisas kundpa, nimba mel, “Ik mbo wu ye! Nim ni!” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wote Jisas ndi, kundpa nimba mel, “Wu raⱡ ndi, wu ti nga ku moni kat punt mondkʉⱡ tʉtʉnggil. Wu ti, ku moni K500 titim. Wu ti, ku moni K50 mint titim. ");
INSERT INTO med_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wu raⱡ, ku moni punt mondkʉⱡ tʉtʉnggil kʉⱡ, punt rokʉⱡ nguinggil mel, kapⱡa mon itim ila, ku moni puⱡ wu ei ndi, ku punt kʉⱡ, wak rurum. Akup nim pʉn ei, wu raⱡ nga, wu nam ndi, ku moni puⱡ wu ei, numan minal ngurum nʉkʉn pʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wote Saimon ndi, punt ropa nimba mel, “Ku moni ou ndupa, punt mundrum wu ei, nim pʉnt!” nitim. Wote Jisas ndi, Saimon kundpa nimba mel, “Nim numan kun pilkʉn nin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ni kʉn, Jisas ndi, tʉpa ropʉl ropa, amp ni, kandpa kʉn, Saimon kundpa, nimba mel, “Nim ndi, ya amp ei kan ei? Na ya, nim nga manga ila mukʉr unt ei kʉn, nim ndi, na nga kʉmp ⱡumʉi ruimp nʉkʉn, nu kulkʉn mundi nʉmʉndʉn ni ka! Wote, amp ei ndi, elim nga ka em nu ei ndi, na nga kʉmp ⱡumʉi rondpa, elim nga peng ndi kʉⱡ ndi, kil ngumba enim ni ka! ");
INSERT INTO med_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na kor mel mukʉr omp mont ni, wote nim ndi, na keta nu rok nui nʉnʉn. Wote, amp ei ndi, na nga kʉmp raⱡ, keta nu ropa nomba enim. ");
INSERT INTO med_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nim ndi, kopung mat tʉkʉn, na nga peng ila kep, kopung kundi nʉkʉndʉn, ni ka! Wote, amp ei ndi, kopung mura rui kai ti mepa omba, na nga kʉmp raⱡ, kopung kandpa enim. ");
INSERT INTO med_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Uⱡ ei nga, na ndi, nim kundʉp nʉnt. Ya amp ei ndi, na numan minal ngunum. Uⱡ ei ndi, ora ndupa, amp ei nga uⱡ kit minal etʉm mbʉ, Got ndi, wak rondnum. Wote, wamp nam ti, uⱡ kit mel wei kʉralt etʉm ei, Got ndi, wak rondʉⱡnga kʉn, wamp ei, Got kʉn numan onunga etpa ngurum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wote Jisas ndi, amp ni, kundpa nimba mel, “Na ndi, nim nga uⱡ kit etʉn mbʉ pora, wak rondʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wu mat Jisas kʉn, rat pol ila rʉp rok morung nimbʉ ndi, ik nitim ni pilik, en enim puⱡ mondʉk, nʉk int yant etʉk nʉk mel, “Wu ei namba wu ti nda? Amp ei nga uⱡ kit etʉm mbʉ, wak rondʉnt ninim ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wote Jisas ndi, amp ni, kundpa nimba mel, “Nim nga mondpa pili uⱡ ei ndi, akup nim etpa tʉnʉm. Nim numan wang ndukʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wote Jisas ni, kona peng na mbo kona mbila, Got nga wamp tʉpa mumuk rui uⱡ ei nga Rʉnang Ik Kai ei nga, wamp ik mbo indimp nimba purum. Elim nga kitip kʉni wu 12 kʉⱡ kunda ku, rup rok purung. ");
INSERT INTO med_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Amp kat kunda ku, rup rok purung. Amp kʉⱡ, unt kui pepa kur kit rukʉr orunga murum ila, Jisas ndi, nimba tʉpa mundrum. Amp ti nga mbi Mariya Makndelin. Amp nga, rukʉr orunga kur kit 7 kʉⱡ morung ila, Jisas ndi, nimba tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wote amp ti, Jowana, Susana na, amp mat kunda, rup rok purung. Wu Kusa ambʉm Jowana, wu Kusa ni, ei wu nuim Erot nga manga rʉp inditim. Amp kʉⱡ ndi, Jisas na, kitip kʉni wu kʉⱡ, tʉk rapʉndʉk, enim nga mel mbʉ, wu kʉⱡ ngʉk etʉng. ");
INSERT INTO med_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Kona peng elpa elpa mbila wamp rʉⱡaip mam ti ok, Jisas kʉn mʉk rok morung ila, Jisas ndi, wamp kʉⱡ kʉn, ik ek ti ropa, nimba mel, “Wu ti ndi, wit mong mat mepa mba, kongun kona mbila ropa mundrum ila, wit mong mat mba, nombuⱡa mam ila mana purum. Wote wamp mbʉ ndi, andʉk kambʉlʉngina, kʉi mbʉ ndi ok, tʉk norung. ");
INSERT INTO med_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Rʉng mong mat mba, ku pol ila, mʉi wei wei etpa tetʉm mbila, mana purum ila, tʉkrʉpa mint oⱡa mba, wote kurum. Ei nambuⱡ emel, mʉi ei kʉp etʉm. ");
INSERT INTO med_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wote, wit mong mat, goimbun rong pana mbila, mana purum mbʉ, goimbun rong morum mbʉ ndi, tʉpa kom rorum ila, oⱡa ui nawʉrʉm. ");
INSERT INTO med_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wote, wit mong mat, mʉi kai mbila, mana purum mbʉ ndi, mʉlʉ ropa oⱡa omba, ropa kai mondpa, rʉng mong mat, 100 nimba rurum,” nitim. Jisas ndi, ik ek ni, ropa pora ndupa kʉn, wi ropa, wamp mbʉ kundpa, nimba mel, “Wamp ti, kum nombuⱡa tem ndam, ik nʉnt kʉⱡ pilik itʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas elim nga kitip kʉni wu ni kʉⱡ ndi, Jisas nga ik ek rurum puⱡ ei, nimba mot ngangga, nʉk waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wote Jisas ndi, elim nga kitip kʉni wu kʉⱡ, kundpa nimba mel, “Got elim ndi, Got nga wamp tʉpa mumuk rui uⱡ, mo ropa tetʉm ei, enim tʉpa, ora ndupa pora ndurum. Wote, wamp mat ndi, ik ek ila mint piling. Wote, mong ei ndi kʉning ei wote, kandʉk mbi ndui nʉnding. Ik pʉtmʉn ei, wote ik puⱡ ei, pilik mbi ndui nʉnding,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jisas ndi, ik ek ropa nitim kʉⱡ nga puⱡ ei, para ndupa nimba mel, “Wit mong kat nʉnt ni kʉⱡ, Got nga ik mong ei, to rondʉp nʉnt. ");
INSERT INTO med_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit mong mat, nombuⱡa mam ila mana purum ei, to rondpa wamp mat, unt Got nga ik mong ei, pilik moⱡina kʉn, wote Seitan ndi, kandrʉm mel, wamp kʉⱡ, Got kʉn mondʉk piling enmin ei, ka nimba pilpa kʉn, wote rʉk omba ik mong pʉtmʉn kʉⱡ, tʉpa mepa purum. ");
INSERT INTO med_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wote, wit mong kat, ku pol ila mana purum ni, wamp mat, Got nga ik kai mbʉ pilik, numan ngormin ni mel. Wote ik ei, numan ila puⱡ pilkan ngumba pi napʉtʉm, wote ui onunga ila mint pʉtmʉn. Wote, mbun mat orum ei kʉn, mundmong etʉk, Got wak rormin. ");
INSERT INTO med_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Rʉng mong mat, goimbun rong morum kona mbila mana purum. Uⱡ ei, to rondpa wamp mat, Got nga ik ei pilik kʉn, wote kʉng orunga uⱡ mbʉ nga kel rondʉk ku moni numan ngurmin. Uⱡ ei ndi, Got nga ik pʉtmʉn ei, en enim kʉn, mong ropa, muⱡ pi napʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wote, wit mong mat, mʉi kai mbila mana purum ei, wamp mat ndi, Got nga ik mong ei pilik tʉk numan ila pendʉk, numan kun kai mbʉ pilik, ronduⱡ mundʉk, uⱡ kai mbʉ etʉk, mong rok muⱡ petmin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wote Jisas ndi, nimba mel, “Wamp nam ti ndi, lam kiya kandpa, nu ming ila ʉk ropa, rat pol mana orunga ila, mundi namʉndʉrmin mon! Lam kiya kandʉk, mondʉrmin kona ila mondʉⱡmina kʉn, wamp murʉk ormʉn mbʉ ndi, rʉⱡang ei kandʉk ormʉn. ");
INSERT INTO med_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ni kʉn, mel mat, akup mo ropa tetʉm mbʉ, wote pena ila ekit omba. Wote mel mat, panda ropa tetʉm mbʉ, wote rʉⱡang ila ekit wangga, wamp mbʉ ndi kʉning. ");
INSERT INTO med_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Enim wamp kum nombuⱡa tem ndam, ik nʉnt kʉⱡ, kum tek pilik kai itʉi! Wamp nam ti, mel mat, tepa moⱡum ndam, Got ndi, mel mat, aldpa pol ila ngumba. Wote, wamp nam ti, mel mat, tepa muⱡi nambʉⱡʉm ndam, tep mor nimba pʉtʉm mel mbʉ, Got ndi, rukʉr tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wote, Jisas elim nga mam kʉn ʉngʉnʉl na mbʉ, Jisas kʉning pilik orung. Wote, wamp mbʉ ndi, Jisas tʉk pok etʉng ila, Jisas ruk ok, kʉning mel kapⱡa mon itim. ");
INSERT INTO med_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ni kʉn, wamp ti ndi, Jisas kundpa, nimba mel, “Manʉm kʉn, ʉngʉnʉl na mbʉ, nim kʉnmin nʉk, pena orunga ok mormin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wote Jisas ndi, ik nʉtʉng ni, punt ropa nimba mel, “Wamp mat, Got nga ik ei pilik, pep rok eng wamp mbʉ, na nga mamʉl na, ʉngʉnʉl mbʉ ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ui ti kʉn, Jisas elim nga kitip kʉni wu ni kʉⱡ kʉn, nu kanu kat ila ok, oⱡa purung. Puk molk kʉn, Jisas ndi, kitip kʉni wu kʉⱡ, kundpa nimba mel, “Tʉn mbun num ei nga, noi ʉldʉ orunga pamin!” nitim. I nilinga, wote purung. ");
INSERT INTO med_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nu kanu ni kʉⱡ, nu ndi, pol ila puⱡnga mel, Jisas ni, nu kanu nila rukʉr ur pitim. Ni kʉn, kona kʉpkʉ mam ti, roⱡnga mel, num ni, kildpa ropa, rukʉr omba, nu kanu ni kʉⱡ nu ndi, peka romba elinga, wu ni kʉⱡ, nu wanging etʉng. ");
INSERT INTO med_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wote, kitip kʉni wu ni kʉⱡ ndi puk, Jisas rok rut nduk, nʉk mel, “Nuim ye! Nuim ye! Tʉn nu wanggʉpʉn kʉⱡmin enmin ei ka!” nʉtʉng. Ni kʉn, Jisas rut nimba, kona kʉpkʉ kʉn, nu kʉn, tʉpa pendpa ik nguⱡnga kʉn, kona kʉpkʉ ni, kʉr nilinga, nu ndi, rurum ni, tiyu nimba titim. ");
INSERT INTO med_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, waldpa nimba mel, “Enim nga mondpa pili uⱡ ei, nant?” nitim. Wote wu, ni kʉⱡ, uⱡ ni kandʉk, mundmong etʉk, numan ou nduk pilik, nʉk mel, “Wu ei namba wu ti nda? Wu ei ndi, kona kʉpkʉ kʉn, nu ei kʉn nilinga, wu ei nga ik ei, kum tekʉⱡ, tʉngʉnda mint kur nʉnmbil ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wote, Jisas kʉn elim nga kitip kʉni wu ni kʉⱡ kʉn, Gerasin wamp mbʉ nga kona nila puk, rʉk purung. Ni kʉn, Gerasin ni kona ei, num Galili ʉldʉ orunga tetʉm. ");
INSERT INTO med_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisas ni, nu kanu purung ni kʉⱡ, wak ropa ekit puⱡnga, kona peng ila, wu ti omba, Jisas kandpa titim. Wu ni nga rukʉr orunga, kur kit mat morung. Wu ei, kump kor nga kur kit ndi, ropa wʉlʉ munduⱡnga, muⱡ rʉⱡi naⱡʉpa, manga tila mukʉr pi nʉpʉtʉm, mon! Wote, pena wamp on kona mbila pepa ʉndrʉm. ");
INSERT INTO med_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wote, wu ni ndi, Jisas kandpa, ronduⱡ ke nimba omba, Jisas nga kʉmp puⱡ nila omba, mana pitim. Wote, ronduⱡ ke nimba mel, “Jisas, nim Got Oⱡa orunga nga kangʉm ei, na kʉn namba uⱡ ti, itʉn on nda? Nim wu kai ei ndi, na etkʉn kit mundi nʉmʉndi,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ei nambuⱡ emel, Jisas ndi, wu ei, kur kit rukʉr orunga murum ei, kundpa nimba mel, “Nim ndi, wu ei, wak rokʉn kelkʉn ekit pi!” nitim. I nilinga mel, kur kit ni, ronduⱡ ke nitim. Wamp mbʉ ndi, wu ei nga kʉmp ki mbʉ, kan ronduⱡ mat ndi rok, gi nduk pendʉtmʉn mbʉ, ropa puⱡa rorum. Kur kit ei ndi, wu ei, ropa wʉlʉ munduⱡnga, kona waka mbila, pena pepa ʉndrʉm. ");
INSERT INTO med_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wote Jisas ndi, kur kit murum wu ni, waldpa nimba mel, “Nim nga mbi nam?” Kur kit ni ndi, nimba mel, “Na nga mbi ou ndupa ei ka!” nitim. Nambuⱡ emel, kur kit ou ndupa, wu ei kʉn, rukʉr orunga morung ei nga nitim. ");
INSERT INTO med_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wote, kur kit nimbʉ ndi, ronduⱡ ke nʉk, Jisas waldʉk nʉk mel, “Nim ndi, tʉn tʉkʉn ndip kona ila, mundi nʉmʉndi mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ni kʉn, komnga mong ramba tila, kng puⱡi, ʉi ongum nok morung. Kur kit nimbʉ ndi, Jisas kʉn ronduⱡ ke nʉk, waldʉk nʉk mel, “Nim ndi, tʉn kundʉk kui tana kʉn, tʉn ombʉn kng kʉⱡ ila, rʉk pamin,” nʉtʉng. Wote Jisas ndi, kur kit ni kʉⱡ tʉpa, kng ni kʉⱡ kʉn tʉpa, rukʉr ndurum. ");
INSERT INTO med_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wote, kur kit nimbʉ ndi, wu ni, wak rok ok, kng rʉⱡaip mam ni kʉⱡ kʉn, rʉk rʉk etʉng. Kng rʉⱡaip mam nimbʉ, ronduⱡ pʉn nʉk puk, kona kop tila mana puk, num tila nu wanggʉk korung. ");
INSERT INTO med_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kng rʉp etʉng wu nimbʉ ndi, uⱡ ni kandʉk tʉkrʉk puk, kona peng na kona mbila pora, ik nʉk mek int int purung. ");
INSERT INTO med_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wamp mbʉ ndi, namba uⱡ ti, enim nda nʉk, kʉnmin nʉk orung. Ok kandrʉng mel, kur kit ndi, ropa wʉlʉ mundrum wu ni, numan mbo pilpa, muⱡ raⱡpa Jisas nga kʉmp puⱡ nila nondpa murum ila, wamp kandʉk mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wote, wamp mbʉ ndi, Jisas nga uⱡ itim ni, kandʉk min ngʉn mundʉk, timan rok nʉtʉng. Wu ei, unt kur kit ndi, ropa wʉlʉ mundpa itim ni, akup numan mbo pilpa morum, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wote, Gerasin kona ila wu nimbʉ ndi pora, Jisas nga uⱡ ronduⱡ itim ni kʉⱡ, kandʉk min ngʉn mundrʉng. Wote, Jisas waldʉk nʉk mel, “Jisas ndi, wamp kʉⱡ, wak ropa kelpa pangga!” nʉtʉng. Wote Jisas ndi, kona ni, wak ropa, nu kanu kat ila, oⱡa mba kelpa purum. ");
INSERT INTO med_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ni kʉn, kur kit ndi, ropa wʉlʉ mundrum wu ni ndi, Jisas ronduⱡ mundpa, waldpa nimba mel, “Nim ndi, kapⱡa nana, na nim kʉn kunda pumbil,” nitim. Wote Jisas ndi, wu ni, yant ndupa nimba mel, “Nim int pukʉn, Got ndi, nim tʉpa rapundpa endim uⱡ mbʉ mel, wamp mbʉ, kundkʉn nʉn pi!” nitim. Wote wu ni, mang kona kelpa yant omba, kona peng na, kona mbila pora, wamp mbʉ kandpa, Jisas ndi, elim tʉpa rapundpa itim uⱡ mbʉ mel, wamp mbʉ kundpa nitim. ");
INSERT INTO med_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wote Jisas ni, num noi ʉldʉ orunga, rʉk oⱡnga kʉn, nokundʉk morung wamp nimbʉ ndi, ambulk palk, rawe etʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ni kʉn, wu ti mbi tek, Jairus nʉtʉng ei, kuimp tepa urum. Wu ni, atinga manga kel ila nga rup wu murum. Wu ni omba, Jisas nga kʉmp puⱡ nila, mura ropa mondpa, Jisas kʉn kont it ik ranggʉpa, elim nga mang kona pambʉⱡ nitim. ");
INSERT INTO med_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nambuⱡ emel, wu ni nga mbuⱡam ambuⱡa tenda ei, mint metʉm. Ambuⱡa wendʉp ei nga pana 12, ei nondpa koⱡmba itim. Wote Jisas ni, puⱡnga mel, purum nombuⱡa mam nila wamp minal ndi, Jisas tʉk kum rok purung. ");
INSERT INTO med_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ni kʉn, amp ti, kona nila murum. Amp ei, rʉk rʉk ku puk roⱡnga, pana 12 omba purum. Amp ei ndi, elim nga kui ei, etʉp tʉp mundimp nimba, ku moni ou ndupa wak rurum. Wote kui ei, pora ni nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Amp ni, Jisas purum mbuldung orunga nondpa mba, Jisas nga wal pʉki pʉkrʉm ni kʉⱡ, ki ei ndi, minda ndurum. Ni kʉn, elim nga ku puk rurum uⱡ ni, tʉngʉnda mint pora nitim. ");
INSERT INTO med_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wote Jisas ndi, wamp mbʉ, waldpa nimba mel, “Nam ndi, na minda ndunum?” nitim. Wote, wamp nimbʉ pora, en enim mon nilingina, Pita ndi, Jisas kundpa, nimba mel, “Wu Nuim ye! Wamp puⱡi molk, nim tʉk rʉk ndunmin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wote Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Wamp ti ndi, na minda nduⱡnga kʉn, na nga ronduⱡ ei, punum pʉnt ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ni kʉn, amp ni, pitim mel, elim mo romba uⱡ ti, mon itim ila, min ngʉn mundpa omba, Jisas nga kʉmp puⱡ nila mura ropa mondpa mba, mana mʉi ila rumʉⱡi pitim. Wote, wamp morung kuimp keta nila, amp ni, elim nga numan pilpa itim uⱡ nimbʉ, nimba mel, “Na nga kui ti, petʉm ei, tʉngʉnda mint pora ninim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wote Jisas ndi, amp ni, kundpa nimba mel, “Ambuⱡa ye! Nim ndi, na kʉn mondkʉn pʉn uⱡ ei ndi, nim nga kui ei pora ninim. Ei nga, nim numan wang ndukʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wote Jisas ni, wamp ik mbo endpa moⱡnga kʉn, atinga manga rʉp wu, Jairus ni nga wu ti ndi omba, elim kundpa nimba mel, “Nim nga ambuⱡa ni, koⱡum ei nga, nim ndi, ik mbo wu ei, mbun ik ti, ni nʉni mon,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wote Jisas ndi, ik ni pilpa kʉn, atinga manga rʉp wu Jairus ni, kundpa nimba mel, “Nim mundmong iti nʉti! Nim mondkʉn pilkʉn muⱡana kʉn, ambuⱡa ei kapⱡa etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wote Jisas mba, atinga manga rʉp wu ni nga manga ila purum. Ni kʉn, Jisas ndi, wamp mbʉ pora, pena muⱡeing nimba, Pita, Jon, Jeims na, ambuⱡa ei nga tipam mam raⱡ kʉn mendpʉⱡ, tʉpa mepa mukʉr purum. ");
INSERT INTO med_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wamp mat, ambuⱡa kurum on ni tek, ka etʉk morung. Ni kʉn, Jisas ndi, wamp ni kʉⱡ, kundpa nimba mel, “Enim ka iti nʉtʉi! Ambuⱡa ei kuⱡi naⱡʉm, wei ur petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ni kʉn, ka etʉk wamp morung nimbʉ ndi, ambuⱡa ei, kurum pilik pora ndurʉng. Ei nga, Jisas nga ik nitim kʉⱡ pilik oi endʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wote Jisas ndi, ambuⱡa ni nga ki ni, ambuⱡpa oⱡa tʉpa, nimba mel, “Ambuⱡa ye! Nim oⱡa muⱡi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ni kʉn, ambuⱡa ei nga muⱡnga ei, yant omba rukʉr puⱡnga, ambuⱡa ni, tʉngʉnda mint rut nimba, oⱡa murum. Wote Jisas ndi, wamp ni kʉⱡ, kundpa nimba mel, “Ambuⱡa ei, rʉng mat nangga, mek ok ngui!” nitim. ");
INSERT INTO med_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ambuⱡa ni nga tipam mam raⱡ ndi kandkʉⱡ, min ngʉn mundrʉnggil. Wote Jisas ndi, wamp raⱡ, kundpa nimba mel, “Ya uⱡ kanmbil ei, wamp mat kundkʉⱡ, ni nʉnʉl mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wote Jisas ndi, kitip kʉni wu 12 kat wi ropa, rʉk tʉpa mondpa kʉn, elim nga ronduⱡ ei, wu kʉⱡ ngumba, mek andʉk, kui elpa elpa petʉm wamp mbʉ, etʉk tʉk, wote wamp mat, kur kit rukʉr orunga morum mbʉ, tʉk mundeing nimba ronduⱡ ei, ngurum ku. ");
INSERT INTO med_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wote Jisas ndi, kitip kʉni wu ni kʉⱡ, tʉpa mundpa, Got nga wamp tʉpa mumuk rui uⱡ ei nga ik mbo endʉk, kui peng em wamp mbʉ, etʉk tʉk, iteing pʉi nitim. ");
INSERT INTO med_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Enim nde pʉiya ʉpʉⱡ na, wal na, rʉng na, ku moni na, wote wal pʉki na kat, pendʉk mek pi nʉpʉi, mon! ");
INSERT INTO med_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Enim pangina kʉn, rawe etʉk tʉng mang kona ila ik mbo endʉk, pek molk kʉn, wote kona tila ku pʉi! ");
INSERT INTO med_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Enim kona peng tila pangina kʉn, wamp mbʉ ndi, enim numan nguk ti natʉng ndam, kona peng ei, wak rok kelik pʉi! Wote, ping etʉk kʉn, wamp kʉⱡ nga uⱡ kit etmin mbʉ, ora nduk kʉn, enim nga kʉmp mbila, kʉnggʉpʉn moⱡum mbʉ, ndanda nduk, tek pʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wote, kitip kʉni wu nimbʉ, kona elpa elpa ni mbila puk, Rʉnang Ik Kai ei, wamp mbʉ kʉn mbo endʉk, kui peng itim wamp mbʉ, etʉk tʉk etʉng. ");
INSERT INTO med_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ui ni kʉn, Jisas ndi, uⱡ ronduⱡ mat itim nimbʉ nga timan ik ei, wamp kandrʉng mbʉ ndi, wu nuim Erot kundʉk nʉtʉng. Wote, Erot numan ou ndupa pitim. Ei nambuⱡ emel, wamp mat ndi, nʉk mel, “Jon wamp nu tindi wu ni koⱡpa, tikil rom,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wote, wamp mat ndi, nʉk mel, “Elaija kurum wu ni, tikil ropa om,” nʉtʉng. Wamp mat ndi, nʉk mel, “Painui wu unt korung nimbʉ nga ti, tikil ropa yant om,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","I nʉtʉng ila, wote Erot ndi, nimba mel, “Jon wamp nu tindi wu ei, na ndi, nil mba rok, nuim kan puⱡa rorung ni ka! Akup wu ti, kongun ronduⱡ mat, enim ninmin pʉnt ei, wu nam nda?” nitim. Nimba kʉn, Jisas kandʉⱡmba ndam, pʉp nimba pitim. ");
INSERT INTO med_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nombuⱡa rung wu kongun iting purung nimbʉ, yant ok, enim etʉng uⱡ mbʉ mel, Jisas kondʉk nʉtʉng. Wote Jisas ndi, wu nimbʉ, tʉpa mepa wamp morung mbʉ, wak rok enmin mint, kona peng tila purung. Kona peng ei, mbi tek, Betseita nʉtmin. ");
INSERT INTO med_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wote, wamp nimbʉ ndi, pilik kʉn, Jisas ni purum ila, akil tek pep rok puk, Jisas kandʉk tʉtʉng. Jisas ndi, wamp mbʉ kandpa, rawe etpa tʉpa kʉn, kui rurum wamp mbʉ etpa tʉpa, Got nga wamp tʉpa mumuk rui uⱡ ei nga ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Epindama ant mana mba elinga kʉn, kitip kʉni wu 12 ni kʉⱡ ok, Jisas murum ila kundʉk, nʉk mel, “Nim ndi, wamp mbʉ nʉkʉn mundana, ant ei pendʉk puk, rʉng nuing mat kandʉk tʉk, ur pek iting kona mat, kandʉk tʉk iteing. Ya tʉn mormʉn kona ei, kui waka kona ila mormʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wote Jisas ndi, kitip kʉni wu ni kʉⱡ kundpa, nimba mel, “En enim ndi, wamp mbʉ, rʉng mat kandʉk tʉk ngʉi!” nitim. Wote, wu ni kʉⱡ ndi, nʉk mel, “Tʉn rʉng ou ndupa, tep muⱡi nambʉrmʉn mon! Bret tʉmbʉkak pʉmp ti, gul tepa, oma raⱡ tepa etʉm ei ka! Wamp rʉⱡaip mam ei nga rʉng nuing kʉⱡ, tʉn ndi, nil mbun rarʉp rʉmin nʉk nʉn?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wu 5000 mel mormin ei ka! Wote Jisas ndi, kitip kʉni wu ni kʉⱡ kundpa, nimba mel, “Enim ndi, wamp mbʉ, numa pana mbila, 50 nʉk mʉk elpa elpa rok, muⱡeing nʉk kundʉk nʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wote, kitip kʉni wu ni kʉⱡ ndi, Jisas nitim uⱡ ni mel etʉk, wamp mbʉ 50 nʉk mou rok, elpa elpa mondrung. ");
INSERT INTO med_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wote Jisas ndi, bret 5 ni kʉⱡ kʉn, oma ni raⱡ kʉn, tʉpa ambuⱡpa moⱡpa, oⱡa ndupa, muⱡ ila kandpa, Got kʉn angge nimba atinga rurum. Wote Jisas ndi, bret na, oma na nimbʉ, kʉmp tʉpa, elim nga kitip kʉni wu ni kʉⱡ nguⱡnga, wu ni kʉⱡ ndi, mek andʉk, wamp nimbʉ, mok rok ngurung. ");
INSERT INTO med_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wamp nimbʉ pora, rʉng noⱡina, pʉlʉng elinga, mana titim nimbʉ tʉk, kowa wal 12 rakʉlʉk peka rondrung. ");
INSERT INTO med_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wote, ui ti kʉn, Jisas elim mendpʉⱡ atinga ropa moⱡnga kʉn, wote elim nga kitip kʉni wu ni kʉⱡ orung. Jisas ndi, wu ni kʉⱡ waldpa nimba mel, “Wamp mbʉ ndi, na kundʉk wu nam ninmin nda?” nimba wuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wote, kitip kʉni wu ni kʉⱡ ndi, punt rok nʉk mel, “Wamp mat ndi, nim kundʉk, Jon wamp nu tindi wu ei nʉtmin. Wamp mat ndi, nim painui wu Ilaija, nʉtmin. Wamp mat ndi, nim painui wu unt ti kolkʉn, tikil rokʉn, yant okʉn morʉn nʉk, nʉtmʉn!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wote Jisas ndi, wu ni kʉⱡ, waldpa nimba mel, “Wote enim ndi, na kundʉk, wu nam nʉtmin?” nitim. Ei nga, Pita ndi, punt ropa nimba mel, “Nim Kraist, Got elim nga wamp mbʉ, etʉk rukʉr tindin nimba kʉn, tʉpa mundrum wu ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, ronduⱡ mundpa, kundpa nimba mel, “Enim ndi, na Kraist Got nga ngurum wu ei nʉk, wamp mbʉ kundʉk, ni nʉnʉi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wote Jisas ndi, nimba mel, “Muⱡʉl Wu Kupa ei, manga wingti rʉp wu na, wu pris kuimbal na, mi ik mbo wu na mbʉ ndi kandʉk, tʉk mbʉⱡ ngangina, ama mindil ou ndupa nomba, wote koⱡmba. Wote, rumbʉⱡ raldika omba pangga, ⱡoporpa tʉpa, kont mondʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ni kʉn, Jisas ndi, elim nga kitip kʉni wu kʉⱡ kʉn, wamp morung nimbʉ pora, kundpa nimba mel, “Wamp nam ti, na kʉn pep rop uimp nimba, pilim ndam, elim nga numan orunga mana ndupa, ui mbila rʉk rʉk, elim nga nde peta ei, koma ropa mepa, na kʉn wangga! ");
INSERT INTO med_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wote, wamp nam ti ndi, elim nga kʉng orunga nga mint nimba pilim ndam, kont mba mul uⱡ ei, wak romba. Wote, wamp nam ti ndi, na nga nimba pilpa, elim nga kʉng orunga pili napilim ndam, wamp ei kont mba mul uⱡ ei kapⱡa tʉmba. ");
INSERT INTO med_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wote, wamp nam ti ndi, mʉi kona mel mbʉ nga kapⱡa itangga, kont mba mul uⱡ ei, wak rom ndam, mʉi kona mel mbʉ ndi, elim tʉpa rapʉndʉmba mel nant? ");
INSERT INTO med_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wote, wamp nam ti ndi, na kʉn kep, na nga ik mbo endint mbʉ nga pipil kuⱡʉm ndam, Muⱡʉl Wu Kupa ei wakʉt, Got nga uⱡ eng nui pol mbila moⱡpa, kopa pol ila anggelo wingti mbʉ kʉn, yant ong ei kʉn, Muⱡʉl Wu Kupa ei ndi, wamp ei kʉn pipil ku kuⱡmba. ");
INSERT INTO med_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, ‘Enim ik kupa ei kundʉp nʉnt. Ya ila mormʉn wamp mbʉ nga mat, kuⱡi nalk, kont molk kʉnangina, Got nga wamp tʉpa mumuk romba uⱡ ei kʉning,” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas ik kʉⱡ nilinga, wote rumbʉⱡ 8 omba purum. Ni kʉn, Jisas ndi, Pita, Jon, Jeims kʉⱡ tʉpa mepa, wi komnga ila, atinga ruing pilik purung. ");
INSERT INTO med_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wote, Jisas elim atinga ropa murum nila, Jisas nga kuimp keta ei, ti elpa mel titim. Wote, wal pʉki pʉkrʉm nimbʉ, rʉⱡang mba eng minal nurum. ");
INSERT INTO med_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ni kʉn, tʉngʉnda mint, wu raⱡ okʉⱡ, Jisas kʉn ik nʉtʉnggil. Wu raⱡ, Moses kʉn Ilaija raⱡ, Got nga rʉⱡang ila molk okʉⱡ, Jisas kʉn ik nʉtʉnggil. Ik nʉtʉnggil mbʉ, Jisas wi Jerusalem kona peng ou ila moⱡpa, kongun etpa, wote mʉi ei, wak ropa mba etmba, uⱡ mbʉ mel rak nduk molk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wote, kitip kʉni wu Pita, Jon, Jeims ni kʉⱡ, ur petʉng ei mel, rut nʉk kandrʉng mel, Jisas ni, elim nga rʉⱡang ila, wu raⱡ kʉn kunda, anggilik morung. ");
INSERT INTO med_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wu ni raⱡ ndi, Jisas wak rokʉⱡ puⱡʉnggila kʉn, Pita ndi, Jisas kundpa, nimba mel, “Wu Nuim ye! Tʉn ya kona ila ombʉn moⱡmʉn ei, uⱡ kai ti imʉn. Tʉn ndi, muⱡ manga raldika kat rʉkamʉn, ti nim nga, ti Moses nga, ti Ilaija nga,” nitim. Pita nitim ik ni, pilpa kun iti natʉpa, nitim. ");
INSERT INTO med_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ndi, ik nimba moⱡnga mel, kona kopa kat ndi, mana omba, wu kʉⱡ tʉpa kum roⱡnga, wu kʉⱡ mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wote, kona kopa kʉⱡ nga rukʉr ila ik ti, ekit ndupa nimba mel “Ya wu ei, na nga kangʉm ei, na nga kongun indangga nʉmp tʉp mundʉr ei nga ik nim ei, kum tek pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wote, ik nimba pora nduⱡnga, kandrʉng mel, Jisas ni, elim kou murum. Wote, wu ni kʉⱡ ndi, uⱡ itim kandrʉng nimbʉ, wamp na ti kundʉk ni nandʉk, pilik rukʉr nduk morung. ");
INSERT INTO med_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wote mʉkʉlmʉ orunga, Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, komnga mong ni, wak rok oⱡungina, wamp puⱡi ok, Jisas kandʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wamp morung rʉk ting nila wu ti ndi, Jisas kʉn ronduⱡ wi ropa nimba mel, “Ik Mbo Wu ye! Na nga kang tenda waⱡʉm ei, nim kʉnʉn nʉmp nʉnt ei ka! ");
INSERT INTO med_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kur kit ei ndi, omba rorum ei kʉn, tʉkrʉpa mint ronduⱡ ke nimba, kʉng mbʉ purpur ropa, keta paip mepa etʉm. Kur kit ei ndi, kang ei nga rukʉr orunga moⱡpa, kang ei etpa mindil kundpa, wak rui narʉrʉm. ");
INSERT INTO med_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Wote na ndi, nim nga kitip kʉni wu kʉⱡ ndi, kur kit ei, tʉk mundeing nʉmp kundʉp nit ei, wote wu kʉⱡ ndi, nʉk tʉk munding mel kapⱡa mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ik nitim ni, Jisas ndi, pilpa kʉn, wamp nimbʉ, kundpa nimba mel, “Enim wamp mbʉ nga mondpa pili ei, kapⱡa mon. Wote, pilpa kungʉndi kun kai ti mon ku. Na enim kʉn moⱡʉp, ik mbo endʉp namba iti ent. Ui namba iti na ndi, enim nga mbun koma rundimp nda? Nim nga kangnʉm ei, mekʉn na kʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wote, kang ni mepa, Jisas murum nila oⱡina kʉn, kur kit ni ndi, Jisas kandpa kʉn, tʉngʉnda mint kang ni, ropa munduⱡnga, mʉi ila pepa purⱡi marⱡi ʉndrʉm. Wote Jisas ndi, kur kit ni, ik mura ngumba tʉpa mundpa, kang ni etpa tʉpa tipam ni ngurum. ");
INSERT INTO med_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Jisas ndi, Got nga ronduⱡ ila uⱡ itim ei, wamp mbʉ kandʉk, min ngʉn mundrʉng. Wote, wamp nimbʉ ndi, Jisas nga itim uⱡ nimbʉ nga, numan ou nduk pilik moⱡina kʉn, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Na nga nimp ent ik kʉⱡ, kum tek pilik kai itʉi! Wu mat ndi, Muⱡʉl Wu Kupa ei, tʉk wu mat ngangina, rok kunding,” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wote, kitip kʉni wu ni kʉⱡ ndi, Jisas nitim ik ei nga puⱡi ei, pilik kun iti natʉtʉng. Ei nambuⱡ emel, ik puⱡ ei, mo ropa pitim. Wote, wu kʉⱡ ndi, Jisas wuldʉng ei nga mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ui ti kʉn, Jisas nga kitip kʉni ni kʉⱡ, ik rombulk nʉk mel, “Wu kuimbal nam moⱡmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Wote Jisas ndi, kitip kʉni wu kʉⱡ nga numan pendʉk morung nimbʉ, kandpa pora ndupa kʉn, kangambuⱡa kel ti, tʉpa mepa omba, elim murum kona nila mondpa, elim nga kitip kʉni wu kʉⱡ kundpa nimba mel, “Wamp nam ti, na nga mbi ila kangambuⱡa kel ei, numan ngumba, rawe etpa tʉm ndam, na rawe etpa tʉmba. Wote, wamp nam ti, na rawe etpa tʉm ndam, na tʉpa mundrum wu ei, rawe etpa tʉmba ku. Wamp nam ti, kangambuⱡa kei raⱡpa moⱡum wamp ei, nuim moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ni kʉn, Jon ndi, Jisas nga nitim ik nimbʉ, punt ropa nimba mel, “Wu Nuim ye! Tʉn ndi wu ti, kʉndʉrmʉn ei, nim nga mbi ila, kur kit mbʉ, nimba tʉpa mundrum. Wu ei, tʉn nga rʉⱡaip ila mon. Ei nga, uⱡ itim ei, tʉn ndi, kundpʉn iti nʉtangga mon!” nitmin. ");
INSERT INTO med_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wote Jisas ndi, Jon kʉn kitip kʉni wu kat kʉn, kundpa nimba mel, “Wu ei mon ni nʉnʉi! Wamp ti, enim kʉn popʉⱡ kuⱡi naⱡʉm wamp ei, enim nga wamp puⱡ ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wote Got ndi, Jisas muⱡ kona oⱡa tʉmba ui ei, nondpa itim ila, Jisas elim nga numan ei, ronduⱡ pilpa, Jerusalem kona peng ou ila purum. ");
INSERT INTO med_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jisas elim akil tep uimp nimba ei nga wu mat, Sameriya kona ila kuimp tek puk, tʉk kun etʉk muⱡeing nimba, tʉpa mundrʉng. ");
INSERT INTO med_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wote, Sameriya kona ila wamp nimbʉ ndi, Jisas tʉk mek, enim nga kona ila pi nʉpmʉn nʉk pʉtʉng. Ei nambuⱡ emel, Jisas ni, Jerusalem kona peng ou ila mba, purum ei pʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wote ni kʉn, Jisas elim nga kitip kʉni wu Jeims kʉn, Jon raⱡ ndi, Sameriya wamp etʉng uⱡ ni kandkʉⱡ kʉn, wote Jisas waldkʉⱡ nʉkʉⱡ mel, “Wu Nuim ye! Nim pilkʉn kapⱡa nana, tʉn ndi, wi muⱡ ila ndip ti, mana wangga namina omba, uⱡ kit enmin wamp mbʉ, ndip ndi, nomba mi tindangga?” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Wote Jisas ndi, ropʉl ropa wu raⱡ ik mura ngurum ila, en enim ping etʉng kona ei kelik, wu ni kʉⱡ kona tila elpa ping pilik purung. ");
INSERT INTO med_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wote Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, nombuⱡa mam ila puⱡina kʉn, wu ti ndi omba, Jisas kundpa nimba mel, “Kona nant mbila nim pun mel, na nim pep rop uimp mint!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wote, Jisas ndi pilpa, punt ropa nimba mel, “Owa rakra mbʉ, mʉi ila kut akʉk petmin. Kʉi mbʉ mi manga rok petmin. Wote, Muⱡʉl Wu Kupa ei nga peng kilanda mundʉmba, kona ti mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wote Jisas ndi, wu ni, kundpa nimba mel, “Nim na pep rokʉn ui!” nitim. Wote wu ni ndi, Jisas kundpa nimba mel, “Wu Nuim ye! Nim ndi, na wak rokʉn mundana, unt mbo na nga tipam ei, on etʉp pendʉp wamp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wote Jisas ndi, pʉnt ropa nimba mel, “Ei mon! Wamp korung mbʉ ndi, wamp koⱡung mbʉ tʉk on iting. Nim pukʉn kona mbila, Got nga wamp tʉpa mumuk rui uⱡ ei nga wamp mbʉ, ik mbo indʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wote, wu ti ndi, Jisas kundpa nimba mel, “Wu Nuim ye! Na nim pep rop uimp ei nga, wote nim ndi, kapⱡa nana kʉn, na unt mbo, na nga wamp mbʉ, rawe etʉp pendʉp, wote wamp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wote Jisas ndi, wu ni, kundpa nimba mel, “Wamp ti ndi, kongun ru koipa ru kan ei, pep rui narʉpa kona elpa mbʉ, mong tʉm ndam, ru koipa kit mondʉmba. Uⱡ ni mel wamp ei, Got nga wamp tʉpa mumuk rui kongun ei, etmba mel kapⱡa mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wote, Nuim ei ndi, wu 72 kat morung kʉⱡ, wi ropa tʉpa raⱡ raⱡ nimba, kuimp tepa tʉpa mundrum. Wu kʉⱡ, tʉpa kona peng na, mbo kona na mbila, tʉpa mundpa kʉn, elim akil tepa, kona mbila mba pilpa itim. ");
INSERT INTO med_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wote Jisas ndi, wu 72 ni kʉⱡ, kundpa nimba mel, “Pana kona mbila rʉng puⱡi rupa ropa petʉm. Wote, rʉng ting kongun wu mat, ou ndupa mon. Ei nga, enim puk pana puⱡ wu ei kʉn, atinga rangina, kongun wu mat, ou ndupa tʉpa mundangga, puk rʉng mbʉ tʉk, mʉk rok muⱡeing. ");
INSERT INTO med_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Enim pilik pʉi! Na ndi, enim tʉp mundunt ei, kng sipsip waⱡ na mat, owa rakra morum kona ila rʉk purmin ni mel, enim tʉp mundunt pʉi! ");
INSERT INTO med_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Enim puk kʉn, ku moni na, wal na, kʉmp rʉk na mel mat, mek pi nʉpʉi mon! Wote, nombuⱡa mam ila puk, wamp mat kandʉk kʉn, rawe iti nʉtʉi mon ku! ");
INSERT INTO med_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wote, enim puk wamp mat nga manga tila mukʉr pung ndam, kokila puk ei kʉn, wamp mbʉ kundʉk, enim ya manga ila wamp kʉⱡ, numan wang nduk muⱡeing nʉi. ");
INSERT INTO med_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Omba wote, numan kai pili kang wu ti, manga ila moⱡum ndam, enim nga memp ik kai nʉng kʉⱡ pilpa tʉmba. Wote, numan kai pili napʉlʉng kang wu ti, moⱡum ndam, enim nga memp ik kai nʉng mbʉ, en enim kʉn rukʉr tʉi. ");
INSERT INTO med_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Enim puk manga tenda ila mint molk, wamp mbʉ ndi, rʉng na, nu na, ngʉng mbʉ nok muⱡʉi! Manga elpa mat ila andʉk, pi nʉpʉi mon! Ei nambuⱡ emel, kongun etʉm wamp ei, mel ti tʉmba ei nga kongun etʉm. ");
INSERT INTO med_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wote, enim kona peng tila pangina kʉn, wamp mat ndi, enim rawe etʉk tʉk mek puk, en enim nga manga ila pung ndam, rʉng ngʉng mbʉ nok muⱡʉi! ");
INSERT INTO med_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wote, kona ila kui rom wamp mbʉ, etʉk kai mondʉk, Got nga wamp tʉpa mumuk rui uⱡ ei, int enim kʉn nondpa, omba tetʉm ei nga nʉk ik mbo indʉi! ");
INSERT INTO med_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Wote, kona peng tila pangina kʉn, wamp mat ndi, enim rawe etʉk ti natʉng ndam, enim puk kona peng ei nga nombuⱡa mam rʉk ila anggilik nʉk mel, ‘Enim nga kona peng ei nga kʉnggʉpʉn kʉⱡ, tʉn nga kʉmp mbila rʉmp ninim mbʉ, akup ndanda ndʉnmʉn. Enim uⱡ ⱡawa mbʉ, etʉk mormin ei nga tʉpʉn ora ndʉnmʉn. Enim pilik kai itʉi! Got nga wamp tʉpa mumuk rui uⱡ ei, nondpa omba enim.’ ");
INSERT INTO med_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na ndi, enim kundʉp nʉnt. Unt Sorum kona ila wamp mbun ngurum ei, mana ndupa, Got ndi, enim kona peng ila wamp kʉⱡ, elim nga ui ou ila, mbun minal ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wote Jisas ndi, nimba mel, “Korasin kona peng ila wamp kʉⱡ kʉn, kont enim. Wote, Betseita wamp kʉⱡ kʉn, kont enim ku. Unt wu ti ndi, omba ya Taiya kʉn, Sairon kona peng raⱡ ila, uⱡ rʉpʉndi mat, akup na ndi, enim kʉn omp ent ei, mel elinga ndam, wamp nʉnt kʉⱡ numan ropʉl ronmʉn nʉk, muⱡ ping ralk ui kik raⱡ pakʉk elingina. ");
INSERT INTO med_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wote Got ndi, wamp kʉmp tʉmba ui ila, enim Korasin, kʉn Betseita kona raⱡ nga wamp kʉⱡ, tʉpa mana ndupa, Taiya, Sairon kona raⱡ nga wamp kʉⱡ, kont minal kuⱡmba. ");
INSERT INTO med_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Wote, enim Kaperniyum wamp kʉⱡ ye! Enim muⱡ kona mbin nʉk piling kʉn, ei mon. Enim ndip kona ila ping. ");
INSERT INTO med_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wote Jisas ndi, elim nga 72 wu ni kʉⱡ, kundpa nimba mel, “Wamp nam ti ndi, enim nga ik nʉng ei, pilpa tʉm ndam, wamp ei, na nga ik ei pilpa tʉmba. Wote, wamp ti ndi, enim tʉpa mbʉⱡ ngum ndam, na tʉpa mbʉⱡ ngumba. Wote, wamp ti ndi, na tʉpa mbʉⱡ ngum ndam, na tʉpa mundrum wamp ei, tʉpa mbʉⱡ ngumba ku,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wu 72 kat Jisas ndi, kongun teing nimba tʉpa mundrum ni kʉⱡ, wote andʉk yant ok, ambulk palk nʉk mel, “Wu Nuim ye! Nim nga mbi tepʉn angʉndpʉn, muⱡnga kit mbʉ ok, ekit peing nimʉn ei kʉn, tʉn nga ik ei, teing nduk ok, pung ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wote Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Seitan wi muⱡ ila kona kiraipa mel etpa, mana om ei, na kʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Enim pilʉi! Na nga ronduⱡ ei, enim ngur uⱡ ei ndi, wimbʉ kit na kimbuⱡa kelwa na mbʉ, kamblik kondʉk, wote el puⱡa wu Seitan nga ronduⱡ ei, rok mana nduk iting. Mel mat ndi, enim kapⱡa etpa kit mundi namʉndʉmba, mon! ");
INSERT INTO med_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wote enim ndi, ambulk palk, nʉk mel, “Muⱡnga kit mbʉ, tʉn nga ik kum tek ok, pung ni nʉnʉi mon! Enim nga mbi kʉⱡ, Got ndi, wi muⱡ kona ila, mon ropa mana ndupa mundrum ei nga, ambulk palk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wote ui ti kʉn, Muⱡnga Wingti ndi, Jisas numan kai kat mbo rʉndrʉm ila, Tipam Got kʉn atinga ropa nimba mel, “Wuta Nuim ei, nim muⱡ mʉi raⱡ nga Tipam ei. Na nim kʉn angge nʉnt ei, nambuⱡ emel, Nim ndi, wamp pilpa kungʉndi mbʉ kʉn, uⱡ mbʉ mo rokʉn etʉn. Wote, wamp ti kangambuⱡa kel mel raⱡpa morum ei kʉn, uⱡ mbʉ ninim nga numan ei ndi, pilkʉn ora ndurun,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wote Jisas ndi, ik kat nimba mel, “Nanim nga Tipam ei ndi, mel mbʉ pora, na nga ki ila tepa pora ndurum. Wamp ti ndi, Got nga Kangʉm ei, pilpa mbi ndui nandrʉm mon. Elim nga Tipam Got ndi, mint pʉtʉm. Wote, wamp ti ndi, Got Tipam pilpa mbi ndui nandrʉm mon, elim nga Kangʉm ei ndi, mint pʉtʉm. Wote, Kangʉm elim ndi, Tipam wamp mat tʉp ora nduimp nimba, pʉtʉm kʉⱡ mint, ora nduⱡnga, kandʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wote, Jisas elim nga kitip kʉni wu kʉⱡ mendpʉⱡ, elim kʉn rʉp rok morung ila ropʉl ropa, wu kʉⱡ, kundpa nimba mel, “Enim kanmin uⱡ kʉⱡ, wamp mat kandʉk kʉn, enim pora ambulk palk muⱡeing. ");
INSERT INTO med_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Wote, unt nga painui wu mat kʉn, wu nuim mumuk na mat, ou ndupa morung mbʉ ndi, uⱡ akup enim kanmin uⱡ kʉⱡ, kʉnmin nʉk pʉtʉng. Ei wote, kʉni nakʉndrʉng, mon. Wote, akup enim ik pʉnmin kʉⱡ kep, pilamin nʉk pʉtʉng. Ei wote, pili napʉtʉng mon ku,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wote, mi ik mbo wu ti ndi, Jisas oⱡa tʉp kʉnimp nimba, waldpa nimba mel, “Ik mbo wu ye! Na namba uⱡ ti etʉp kʉn, uⱡ nga kʉnt nga kont mul uⱡ ei, kandʉp timp nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wote Jisas ndi, wu ni nga ik punt ropa nimba mel, “Mi ik ila petʉm ik kʉⱡ, nim kʉmp rokʉn pʉtʉn mel nant?” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wote, mi ik mbo wu ni ndi, punt ropa nimba mel, “Enim nga Wu Nuim Got numan nguing uⱡ ei, enim nga mundmong, min, ronduⱡ, numan na mbila pora, numan nguing. En enim numan ngurmin uⱡ ei mel ku, manga keta kup wamp mbʉ, i ku etʉk numan ngeing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas ndi, wu ni, kundpa nimba mel, “Akup nim ndi, na nga ik waldʉnt ni, punt rokʉn nʉn ei mel, uⱡ mbʉ in ndam, uⱡ nga kʉnt nga kont mba mul kona ei tin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wote, mi ik mbo wu ni ndi, Jisas ndi, elim wu kun kai ti, nimba pilangga nimba, waldpa nimba mel, “Mi ik ei ndi, mang keta kup wamp ninim ni, namin kundpa ninim nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wote Jisas ndi, wu ni nga ik nitim ni, punt ropa nimba mel, “Tʉnggʉt kʉn, Jura wu ti, Jerusalem kona peng ei, wak ropa, Jeriko kona peng ila mbi nimba, nombuⱡa mam ila purum. Nombuⱡa ruk ting ila kindʉp wu mat ndi, Jura wu ei, tʉmbʉⱡ ndi rok, mel mepa purum mbʉ, roldʉk tʉk mek purung. Wote, rorung wu ni, nombuⱡa mam ila koⱡmba etpa titim. ");
INSERT INTO med_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wote ei kʉn, wu Pris ti, nombuⱡa mam ila akil tepa omba, kʉndrʉm mel, wu ni, koⱡmba etpa, nombuⱡa mam ila peta ropa titim ila kandpa pendpa, nombuⱡa mam ʉldʉ orunga, kuk tʉpa omba purum. ");
INSERT INTO med_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wote, Lipai wu ti, i ku etpa omba, rorung wu ni, kandpa kʉn, nombuⱡa mam ʉldʉ orunga, kuk tʉpa omba purum. ");
INSERT INTO med_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Wote, Sameriya wu ti, akil tepa urum ni ndi, wu rok tetʉng ni kandpa, kont kuⱡpa munt mindil tʉpa, nondpa omba, ambuⱡpa kandpa, rorung kona nimbʉ, kopung ni kandpa, kng donggi mbuⱡ ila mondpa, mepa mba, wamp tʉma ok, pek puk etmin manga nila pendpa, rʉp itim. ");
INSERT INTO med_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wote utʉma orunga, Sameriya wu ni ndi, manga puⱡ wu ni, ku K2 ngumba kʉn, nimba mel, “Nim ndi, wu ei, rʉp etkʉn kai mondkʉn molkʉn, nim nga ku moni mat ndi, rʉng rarʉp rok, tʉk ngukʉn in mbʉ mel, wote na yant omp kʉn, ninim punt rop nguimp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wote Jisas ndi, mi ik mbo wu ni, waldpa nimba mel, “Wu raldika kʉⱡ nga wu nam ti ndi, wu rorung ei, tʉpa manga keta kup wamp randpa, numan ngurum nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mi ik mbo wu ni ndi, nimba mel, “Sameriya wu ei ndi, kont kuⱡpa etpa titim,” nitim. Wote Jisas ndi, mi ik mbo wu ni, kundpa nimba mel, “Nim akup int pukʉn, Sameriya wu ei itim uⱡ ei mel ku itʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wote tʉnggʉt kʉn, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ kunda, kona tila purung. Kona nila amp Mata ni, ti murum ni ndi omba, Jisas rawe etpa tʉpa mepa, elim nga manga nila purum. ");
INSERT INTO med_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Amp Mata nga ʉngʉn amp ti, murum ei nga mbi Mariya. Amp Mariya ni, Jisas murum kona nila, nondpa wʉng ila moⱡpa, ik nitim ni, kum tepa pilpa murum. ");
INSERT INTO med_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ni kʉn, amp Mata ni, rʉng mbʉ, elim kou tʉpa kun etpa, numan kit pilpa, wote Jisas murum nila omba, kundpa nimba mel, “Wu Nuim ye! Na nga ʉngʉn amp ei, na wak roⱡnga, nanim mendpʉⱡ rʉng mbʉ, tʉp kun etʉp mor ei ka! Nim ndi, amp ei, kundʉk nana omba, na tʉpa rʉpʉndangga!” nitim. ");
INSERT INTO med_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wote Nuim ndi, Mata nga nitim ik ni, punt ropa nimba mel, “Amp Mata, Mata ye! Nim rʉng na mel mbʉ nga mint, numan ou ndukʉn, ngukʉn morʉn ei mon. ");
INSERT INTO med_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nim mel tenda ti mint, nim kʉn mon ndonum. Mel ei, Mariya ndi, pilpa tʉpa morum. Ei, wamp ti ndi, roldpa tʉmba mel mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wote ui ti kʉn, Jisas elim kona tila atinga ropa murum. Wote, atinga ropa pora nduⱡnga kʉn, elim nga kitip kʉni wu ti ndi, Jisas kundpa, nimba mel, “Nuim ye! Unt, Jon wamp nu tindi wu ei ndi, elim nga kitip kʉni wu kʉⱡ, atinga mbo rundrum ei mel ku, nim ndi, tʉn atinga mbo indʉn ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wote Jisas ndi, wu nimbʉ, kundpa nimba mel, “Enim atinga i etʉk rʉi! ‘Tʉn nga Wuta o! Nim nga mbi wingti ei, tʉpʉn ou ndʉmin. Nim nga wamp tʉpa mumuk rʉi uⱡ ei, wangga! ");
INSERT INTO med_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akup rʉk rʉk ui mbila, tʉn nga nuimin rʉng mbʉ nguiyo! ");
INSERT INTO med_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tʉn nga uⱡ kit mbʉ pendkʉn kili! Nambuⱡ emel, wamp mat ndi, tʉn etʉk kit mondʉrmin uⱡ mbʉ, tʉn ndi, i ku etpʉn, uⱡ kit mbʉ, wak ronmʉn. Nim ndi, tʉn kandkʉn, kui tana uⱡ mbun pi mbʉ, tʉn kʉn oⱡa ui nʉwangga, mon!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kandpa nimba mel, “Enim wu mormin kʉⱡ nga ti ndi, ou rumbuldi elim nga wamp puⱡ ti nga manga ila mba, ropa rʉt ndupa nimba mel, ‘Ang, na nga manga ila wu ponʉng ti rumbuldi oⱡnga kʉn, na ndi, wu ei rʉng nguimp mel ti mon elinga, nim ndi, na bret raldika ngʉn nʉmp ont ei ka!’ nimba. ");
INSERT INTO med_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wote, manga ila murʉk moⱡum wamp ei ndi, nim kundpa, ‘Na mbun ngui ngʉngi! Na kʉn kangambuⱡa kʉⱡ kʉn, kor kumba ropʉn pendpʉn, ur pepʉn pora ndumin. Na kapⱡa oⱡa moⱡʉp, nim mel ti nguimp mel mon!’ ");
INSERT INTO med_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ei kʉn, manga puⱡ wu ei ndi, wamp elim nga ʉngʉn ti, wi ronum pʉnt ei ka nimba, rʉng mat nuwa tʉpa ngui ngangʉmba mon! Wote, pipil kuⱡi naⱡʉpa epʉp ropa, wi tʉkrʉk ropa enʉmp kuⱡpa kʉn, rut nimba kʉn, rʉng mawa em mbʉ, kapⱡa ngumba mint. ");
INSERT INTO med_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na ndi, enim ik kupa ti kundʉp namp. Enim Got kʉn waldʉk, atinga rong ndam, mel mat enim ngumba. Enim mel ti kurung ndam, kapⱡa Got ndi, ora ndangga kʉning. Enim ndi, kumba rok gep ndʉng ndam, kapⱡa Got ndi, kumba tʉndʉmba. ");
INSERT INTO med_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wamp pora, Got kʉn atinga rok, waldʉtmin mbʉ, mel mat ngurum. Wamp mat ndi, mel mat kurʉrmin mbʉ, Got ndi, ora nduⱡnga kandʉrmin. Kumba rok, gep ndurmin wamp mbʉ nga Got ndi, kumba tʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Omba, enim nga kangambuⱡa mbʉ ndi, tipamʉl mbʉ kundʉk, oma mat, tʉk ngui nʉng ndam, wote tipamʉl mbʉ ndi, kimbuⱡa mat tʉk nguing ei? Ei mon! ");
INSERT INTO med_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wote, kangambuⱡa ei ndi, tipam kundpa kʉi muⱡ tʉkʉn ngui nangga, wote tipam ndi, kimbuⱡa kelwa ti, tʉpa ngumba ei? ");
INSERT INTO med_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Enim uⱡ kit mbʉ nga puⱡ wamp mbʉ ndi, kangambuⱡa mbʉ, mel kai mat ngurmin. Uⱡ ei mel ku, enim nga Tipam wi muⱡ ila morum ei ndi, numan kai pilpa, waldʉtmin wamp mbo Muⱡnga Wingti ngurum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wote Jisas ndi, wu ti kur kit ndi, ropa kum ngurum ila ik ni nandpa itim wu ni, etpa titim. Wote wu ni, ik nimba elinga, wamp mbʉ ndi kandʉk, min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wote, wamp mat ndi, nʉk mel, “Jisas ndi, kur kit mbʉ nga nuim Biyelsipul ei nga ronduⱡ ei, tʉpa kur kit mbʉ, ropa pep ropa mundnum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wamp mat ndi, Jisas oⱡa tʉk kʉning pilik kʉn, waldʉk nʉk mel, “Wu ei, Got nga ronduⱡ ila kongun mat em ndam, uⱡ rʉpʉndi ti etpa, tʉn ora ndangga kʉnmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wote Jisas ndi, wamp nimbʉ nga numan pʉtʉng ni, kundpa nimba mel, “Kona tenda tila wamp rʉⱡaip kat, rʉk ila oi kan pendʉk, el eng ndam, wamp mbo kʉⱡ molk, ruⱡ pi nʉping. Wote, wamp mema tenda kat palk, rʉⱡaip raⱡ etʉk molk, el eng ndam, wamp kʉⱡ kit muⱡing. ");
INSERT INTO med_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Omba, Seitan nga rʉⱡaip ei, palk raⱡ etʉk, el eng ndam, wote ronduⱡ muⱡing ei? Enim ndi, na kundʉk kur kit nuim Biyelsipul mondʉp kʉn, kur kit mbʉ, makrʉp mundunt ninmin ei nga nʉnt. ");
INSERT INTO med_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na kur kit nuim Biyelsipul ei, mondʉp kur kit mbʉ nʉmp mundunt ninmin. Ei wote, enim nga wamp rʉⱡaip mbʉ, nam nga ronduⱡ ei, tʉk kur kit mbʉ, nʉk tʉk mundʉrmin? Enim nga wamp rʉⱡaip mbʉ, etmin uⱡ ei ndi, ora ndupa, en enim kʉn ⱡawa etmin. ");
INSERT INTO med_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ei mon, Got nga ronduⱡ ei, na nguⱡnga kʉn, na ndi, kur kit mbʉ, nʉmp tʉp mundunt. Uⱡ ei ndi, ora ndupa, Got nga wamp tʉpa mumuk rui uⱡ ei, enim kʉn omba morum. ");
INSERT INTO med_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Omba, wu ronduⱡ purum ti ndi, el kupanda na tepa, elim nga mang keta rʉp etpa morum ndam, elim nga mel mbʉ, etpa poⱡ tʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wote, wu ama ronduⱡ ti ndi, rʉk omba wu ei ropa, pendpa el kupanda na, koiya na mel ronduⱡ nimba pʉtʉm mbʉ, tʉpa elim nga mel ambuⱡpa morum mbʉ, tʉpa wamp mbʉ ngumba etʉm. ");
INSERT INTO med_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wamp nam ti, na kʉn mʉn muⱡi nambrʉm ei, na kʉn el puⱡa wamp morum. Wamp ti, na nga sipsip kʉⱡ, na kʉn tʉpa mʉk rui narʉm ei, na nga wamp mbʉ, ropa mbuⱡ mbaⱡ etʉm. ");
INSERT INTO med_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","26","Wote Jisas ndi, nimba mel, “Omba kur kit ti ndi, wamp ti nga rukʉr orunga moⱡpa, wote wamp ei, wak ropa mba, kona waka ti, kandʉp tʉp muⱡimp nimba purum. Wote, kona kai ti, kandpa ti natʉpa kʉn, nimba mel, ‘Unt na mur manga ila kelip pamp nimba kʉn,’ mba kandrʉm mel, unt murum manga ni, ou nduk, pʉkaimp rok, kai etʉk tetʉng. Ni kandpa kʉn, int mba, kur kit 7 kat kongun kit minal etʉk, elim akʉk oⱡa nduk etmin ni kʉⱡ, el kaⱡpa tʉpa, mepa oⱡnga puk, manga nila mukʉr puk mormʉn. Unt wamp ni, wei etpa moⱡpa, kit mundrum ndam, wote akil tepa wamp ei, ama kit minal morum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ndi, wamp num pitim kona nila, Got nga ik puⱡ mbʉ nimba murum. Ni kʉn, amp ti, rʉk ila murum ni ndi, Jisas wi ropa, kundpa nimba mel, “Amp ti, nim mepa aim ngurum amp ei, ambuⱡpa paⱡʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wote Jisas ndi, nimba mel, “Wamp nam ti, Got nga ik ei, pilpa pep ropa, em wamp ei, numan mam ti, ngumba muⱡangga,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wamp mam ti, Jisas murum kona nila ok, mint morung. Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Akup nga ui ila wamp kit mat mormin kant. Wamp mbʉ ndi, wi rok, Got nga uⱡ rʉpʉndi ti, etʉp ora ndamba, kʉnmin mint ninmin, ei ka! Na ndi, kanda uⱡ ti, etʉp tʉp ora ndui nʉndimp mon! Unt Painui wu Jona nga uⱡ rʉpʉndi tenda ei, mint kʉning. ");
INSERT INTO med_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Unt, Ninipa kona peng ila painui wu Jona ni, Got nga to rondpa moⱡnga, wamp ndi kandrʉng. Uⱡ ei mel ku, akup ui ila Muⱡʉl Wu Kupa ei, Got nga to rondpa ya rʉk ila morum. ");
INSERT INTO med_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wamp mbʉ pora, kot iting ei nga ui ti, Got ndi, to ropa pinditim. Ui ila Sipa kona ila amp kwin ti, murum ei omba, wamp mbʉ, kot iting kona ila anggilpa, wamp mbʉ nga uⱡ kit akup etʉk mormin mbʉ, kot ila nimba. Nambuⱡ emel, amp kwin ei, mʉi punt ronggʉt moⱡpa, wote Solomon nga pilpa kungʉndi ik kai nʉtʉm mbʉ, pilmba pilpa urum. Ei mel, ya enim nga kona ila rʉk wu ti morum. Ei ndi, Solomon tʉpa mana ndupa, oⱡa orunga morum. ");
INSERT INTO med_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wote Got ndi, wamp mbʉ pora, kʉmp tʉmba ui ei kʉn, Ninipa wamp kʉⱡ, kot ila anggilik kʉn, akup ui ila mormin wamp mbʉ nga uⱡ kit etʉk mormin mbʉ, kot inding. Uⱡ ei, nambuⱡ emel, unt painui wu Jona ndi, Ninipa wamp kʉⱡ, ik mbo inditim ei, tʉngʉnda pilik, numan ropʉl rorung. Ei nga, akup ya rʉk ila wu ti morum ei, Jona tʉpa mana ndupa, oⱡa orunga moⱡpa, ik mbo endnim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wote Jisas ndi, ik ti nimba mel, “Wamp ti ndi, lam kiya kandpa, manga mukʉr rat pol mana orunga, mo ropa mundi namʉndrʉm mon. Wamp mat manga ila kandʉk, mukʉr weing nʉk lam kiya kandʉk, rat pol oⱡa orunga mondʉrmin. ");
INSERT INTO med_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Enim nga kʉng ei nga mong ei, kai moⱡum ndam, kʉng kʉⱡ rʉⱡang minal purum. Enim nga mong ei, kit moⱡum ndam, kʉng kʉⱡ pora rumbʉⱡ morum. ");
INSERT INTO med_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Uⱡ ei nga, enim nga rʉⱡang rukʉr orunga morum ei, etʉk kai mundʉi! Tʉpa kawa ndangga, enim nga rʉⱡang rukʉr orunga morum ei kumbʉⱡmba. ");
INSERT INTO med_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wote, enim nga kʉng kʉⱡ pora, rumbʉⱡ ti muⱡi nambʉⱡʉm ndam, lam kiya rʉⱡang purum ni mel, rʉⱡang mint mba moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wote, Jisas ik mbo endpa, pora nduⱡnga kʉn, Perisi wu ti ndi, Jisas elim nga manga ila rʉng nʉn, wi nilinga purum. Jisas mba, manga nila mukʉr rat pol nila murum. ");
INSERT INTO med_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisas ni, ki ⱡumʉi rʉi narʉpa, rʉng nurum ila Perisi wu ni ndi kandpa, numan ou ndupa pitim. ");
INSERT INTO med_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wote Jisas ndi, Perisi wu ni, kundpa nimba mel, “Enim Perisi wamp mbʉ ndi, rʉng normin mel mbʉ, ekit orunga, ⱡumʉi rok, eng nondʉrmʉn. Wote, enim nga numan rukʉr orunga, uⱡ kit mbʉ ndi, peka ropa petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Enim Perisi wamp wʉlʉ mbʉ ye! Got ndi, enim nga kʉng ekit orunga, etpa kai mundrum ndam, wote rukʉr orunga etpa, kai mundi nʉmʉndrʉm nda? ");
INSERT INTO med_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wote, enim nga rʉng normin mbʉ nga rukʉr orunga, tek mormin mel mbʉ, wamp kurpa mat, tʉk rapʉndʉk ngʉi. Uⱡ i eng ei ndi, enim eng nomba. ");
INSERT INTO med_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Enim Perisi kʉⱡ, pilik kai itʉi! Pana kona mbila, kim na, rʉng mat kʉmp tʉk, ki ti gu nduk, Got ngʉi! Enim Got numan ngui uⱡ kun kai kʉⱡ, wak rormin ei kelik, akup ronduⱡ mundʉk, uⱡ kai kʉⱡ etʉk, wamp mat, wak rui narʉk, wote mi ik mbʉ pora, pep rʉi. ");
INSERT INTO med_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Enim Perisi wu mbʉ, pilik kai itʉi! Enim atinga manga kel mbila nga kuimbal mint puk molk, wamp kel mbʉ, mʉk rok mormʉn kona mbila, enim rawe iteing mint nʉk etmin ei ka! ");
INSERT INTO med_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Enim Perisi wu mbʉ, pilik kai itʉi! Enim wamp on kut kona, mʉi ila mo ropa, telinga kʉn, wamp mat ndi, kʉni nakʉndʉk ok, purmʉn uⱡ ni mel etʉk mormʉn. ");
INSERT INTO med_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wote, Jisas nitim ik ni, mi ik mbo wu ti ndi, pilpa moⱡpa, punt ropa, Jisas waldpa, nimba mel, “Ik mbo wu ye! Nim ndi, Perisi wamp mbʉ, ik kundkʉn nʉn kʉⱡ, tʉn kunda ik mura ngʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wote Jisas ndi, punt ropa wu ni, kundpa nimba mel, “Enim mi ik mbo wu mbʉ kunda, pilik kai etʉk muⱡʉi! Enim mi ik mbo wu mbʉ ndi, uⱡ mbun mam mbʉ tʉk, wamp kel mbʉ nguⱡina, mindil nok koma rormin. Wote, enim nga ki kot ila rʉk nduk, tʉk rʉpʉndi napʉndʉrmin ku. ");
INSERT INTO med_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Uⱡ ei, enim pilik kai itʉi! Enim nga anda kouwʉ mbʉ ndi, painui wu mbʉ, rok kondrung ei nga, akup enim ndi, painui wu kʉⱡ nga on kona ei, mim etʉk mormʉn. ");
INSERT INTO med_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Unt nga anda kouwʉmʉn kʉⱡ, etʉng ei mel ku, akup enim ndi, uⱡ mbʉ wamp mbʉ, teing nʉk orunga mint nduk, mormin uⱡ ei, nambuⱡ emel etmʉn. Anda kouwʉ mbʉ ndi, painui wu mbʉ, rok kondrung ei nga on kona mbʉ, enim mim etʉk mormʉn. ");
INSERT INTO med_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nambuⱡ emel, Got nga numan kun kai ei ndi, nimba mel, ‘Na ndi, painui wu na, nombuⱡa rung wu na mat tʉp mundamba. Wote, wamp mbʉ ndi, wu mat etʉk kit mondʉk wu mat rok kunding.’ ");
INSERT INTO med_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Got ndi, mʉi ei puⱡ mondpa itim ui ei kʉn, yant ndupa, painui wu rok kondʉk etʉng ⱡawa ei, akup ui ila wamp mormin mbʉ, ⱡawa ei ting. ");
INSERT INTO med_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Unt, painui wu rok kondrung kʉⱡ nga puⱡ mondʉk, Eipel rok kondrung. Uⱡ ei, tepa mint orum. Wote, Sakaraiya rok kondrung ei, rat pol wingti ei kʉn, manga kʉkaⱡ wingti raⱡ nga rʉk ting ila rok kondrung. Na ik kupa kʉⱡ, enim kundʉp nʉnt. ‘Uⱡ kit etʉng mbʉ, punt romba uⱡ ei, akup ui ila mormin wamp mbʉ ting!’ ");
INSERT INTO med_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Enim mi ik mbo wu mbʉ, pilik kai itʉi! Enim ndi, wamp pilpa kungʉndi ting ei nga kumba ki kʉⱡ, tʉk mo rorung ei ka! Enim kumba tʉk rukʉr pi napʉk, wote wamp mbʉ, pilpa kungʉndi kandʉk ting ei nga nombuⱡa mam kumba angʉndʉtmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Wote, Jisas ik mbo endpa murum kona ni, wak ropa puⱡnga kʉn, mi ik mbo wu na, Perisi wu na mbʉ ndi, Jisas kʉn popʉⱡ kolk, ik elpa elpa mat waldʉtʉng. Wu nimbʉ ndi, Jisas ik mat ⱡawa etʉk waldamina kʉn, Jisas punt ropa, ⱡawa tangga kʉn, imp muⱡmin nʉk pilik nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tʉnggʉt kʉn, wamp ama minal ok moⱡina, kona ti nimba moⱡnga, wamp mat ndi, mat kʉmp pol mbila kambilik anggʉtʉng. Kona nila Jisas ndi, elim nga kitip kʉni wu kʉⱡ, kuimp tepa kundpa nimba mel, “Enim ndi, Perisi wamp mbʉ nga yis mbʉ, pilik tʉk mendʉk muⱡʉi! Yis nʉnt ei, ik kol uⱡ ei, kundʉp nʉnt nitim. ");
INSERT INTO med_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wamp mbʉ ndi, ik nʉk, mo rok uⱡ etʉk, kambilik pendʉk mormin mbʉ, wote pena ila mot nimba. ");
INSERT INTO med_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wote enim ndi, ik mat rumbuⱡ ila molk nʉng ik mbʉ, wote omba ik mat nʉng ndam, pena ila piyangga wamp mbʉ ndi, pilik kapⱡa inding. Manga ila mukʉr, ol tek nʉng ik mbʉ, tʉk peni ila pendʉk, ui rok ning,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wote Jisas ndi, wamp mbʉ kundpa nimba mel, “Enim nga kʉng kʉⱡ, wamp mat ndi, rok kunding ei nga mundmong iti nʉtʉi mon! Enim nga min ei, kunda rok kundi nʉkʉnding ei ka,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jisas ndi, nimba mel, “Enim ndi, nam nga mundmong inding ei nga, na ndi, nʉmp piral ndamp. Got nga mint mundmong indʉi! Nambuⱡ emel, Got nga rondʉⱡ ei ndi, wamp ropa kundpa, wote ndip kona tʉpa mundpa etʉm. Na ndi, enim ik kupa kundʉp nʉnt. Enim ndi, Got nga mint mundmong indʉi! ");
INSERT INTO med_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Enim pʉtmʉn ni ka, wamp mat ndi, ku toea raⱡ rok mundʉk, kʉi waⱡ 5 kat rarʉp rok tʉtmʉn. Ni nga, Got ndi, kʉi waⱡ ti, wak rui narʉrʉm mon ni ka! ");
INSERT INTO med_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Got ndi, enim wamp mbʉ nga peng ndi mbʉ, kʉmp ropa pilpa pora ndurʉm. Ei nga, enim mundmong iti nʉtʉi! Enim wamp mbʉ, Got nga kuimp keta ila wamp ingk mbʉ mormʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Omba Jisas ndi, wamp kʉⱡ ik mat, kundpa nimba mel, “Wamp ti ndi, anggilpa wamp mbʉ kundpa, na nga rʉⱡaip ila mor nim ndam, wote Muⱡʉl Wu Kupa ei ndi, Got nga anggelo mbʉ kʉn, uⱡ tenda ei mel ku etmba. ");
INSERT INTO med_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wote, wamp ti ndi anggilpa, wamp mbʉ kundpa, na nga rʉⱡaip ila rʉk muⱡi nambʉr nim ndam, wote Muⱡʉl Wu Kupa ei ndi, Got nga anggelo mbʉ kʉn, uⱡ tenda ei mel ku etmba. ");
INSERT INTO med_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wamp nam ti, Muⱡʉl Wu Kupa ei, ik mura kit mat ngum ndam, Got ndi, wamp ei nga uⱡ kit mbʉ wak rondʉmba. Wote, wamp nam ti ndi, Muⱡnga Wingti ei ik mura kit mat ngum ndam, wote Got ndi, wamp ei nga uⱡ kit mbʉ, wak rundi nandʉmba mon! ");
INSERT INTO med_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ui mat kʉn, enim wamp mat ndi, mek puk atinga manga kel na, gapman kot kona mbila, muna mi ik mbo wu na mbʉ nga kuimp keta mbil angʉndʉk, enim waldʉk, ik mat nʉng ndam, enim mundmong etʉk kʉn, na namba etʉp ik mat, punt rop nimp nda nʉk, pili nʉpʉlʉi mon! ");
INSERT INTO med_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ant mong ila kʉn, Muⱡnga Wingti ei ndi, ik mong mbʉ, mbo rundangga punt rokʉn nin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wamp ou nduk, mʉk rok morʉng rʉk ting nila wu ti ndi, Jisas kundpa nimba mel, “Ik Mbo Wu ye! Na nga tipam ei, kurʉm ei nga, na nga ʉngʉn wu ei, kundʉk nana kʉn, tʉl nga tipam ei nga moiya mel tepa, purʉm mbʉ nga mat, kʉmp tʉpa, na ngangga ni!” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wote Jisas ndi, wu ni punt ropa, waldpa nimba mel, “Nam ndi, na mak ropa kʉn, enmbil nga mel mbʉ, molkʉn kʉmp tindi,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Enim pilik kandʉk, kun etʉk muⱡʉi! Tʉpa kawa ndangga, enim ndi, mel elpa elpa mbʉ kandʉk, kum pindi uⱡ ila muⱡing. Nambʉⱡ emel, enim mel ou nduk, tek moⱡʉng ndam, mel mbʉ ndi, enim nga kont muⱡing uⱡ ei, kapⱡa mon,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","17","Jisas ndi, ik ek ti ropa, wamp mbʉ, kundpa nimba mel, “Wu ti, ku moni ambrʉm ei nga, kongʉn kona ila rʉng puⱡi, kakʉna tangga kʉn, wote wu ei, elim numan ei ndi pilpa, ‘Akup na namba uⱡ ti itimp nda nimba kʉn, na nga rʉng mbʉ, tʉp timp manga mat, mon pʉnt ei ka! ");
INSERT INTO med_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Akup na pʉnt uⱡ ei mel, itimp nimba kʉn, rʉng tet manga mbʉ, rokʉtʉp kʉn, manga mam mat rakʉp mondʉp mbila, wit na rʉng kai mbʉ, manga ila timp.’ ");
INSERT INTO med_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wote elim ndi, nimba mel, “Na akup mel mbʉ, kapⱡa enim. Na mel kai mbʉ, tʉp tep moⱡʉp pamba mba, pana ou ndupa omba mba. Akup na rʉk rʉk rʉng nomp, nu kai kandʉp, muⱡ tʉp ambuⱡʉp paⱡʉp, wei muⱡimp ei ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wote Got ndi, wu ni, kundpa nimba mel, ‘Nim wu wʉlʉ purʉm ti kant. Akup rumbʉⱡ ila mint nim kun ndam. ‘Wote, nim nga mel tekʉn morʉn mbʉ, wamp nam ti tʉmba nda?’ ");
INSERT INTO med_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wote Jisas ndi, nimba mel, “Wu mat ndi, mel ou ndupa mbʉ, tʉk mʉk rok molk, wote Got nga kuimp keta ila, wamp kurpa ralk muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Na ndi, ik kʉⱡ nʉnt. Enim nga kʉng orunga, namba rʉng mat nombʉn, muⱡ mat raⱡpʉn itmin nda nʉk, kel rondʉk numan ou ndupa, pili nʉpʉlʉi mon! ");
INSERT INTO med_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kont mba mul uⱡ ei uⱡ rondʉⱡ, wote rʉng mbʉ kʉn kapⱡa mon! Wote, kʉng kʉⱡ nga ronduⱡ ei kʉn, muⱡ mbaⱡ mbʉ nga rondʉⱡ ei, kapⱡa mon! ");
INSERT INTO med_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Enim kʉi mbʉ kʉnʉiya! Kongʉn etʉk rʉng mat rʉⱡi nakʉrmin ku. Wote, rʉng manga mat rʉki nakʉrmin ku. Wote kʉi mbʉ, Got ndi, rʉng ngurʉm ila nok andʉrmin. Enim wamp mbʉ, kʉi mbʉ mel kapⱡa mon ei ka! ");
INSERT INTO med_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wote, enim kʉⱡ nga ti ndi, numan rondʉⱡ kat pilpa kʉn, na pana ralt moⱡʉp mint, mbi nimba pʉtʉm uⱡ ei, kapⱡa mon! ");
INSERT INTO med_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Uⱡ kel ei, nim kapⱡa iti nʉtʉn. Ei nga wote, enim mel elpa mat nga nambuⱡ emel, numan ou nduk pʉtmʉn? ");
INSERT INTO med_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Enim ndi, plawa kuk kʉⱡ kandʉrmin ei, etpa oⱡa orʉm mel nant? Wote, plawa kuk mbʉ ndi, kongun iti natʉk muⱡ mbal namba iti natʉtmʉn ni ka! Ei nga, na enim kundʉp nʉnt. Unt king Solomon ndi moⱡpa, elim nga kʉng orunga, muⱡ minal tepa, moke kai mat itim. Wote, plawa kuk ei nga eng norum uⱡ ei ndi, king Solomon nga moke itim uⱡ ei, mana ndurʉm. ");
INSERT INTO med_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Akup nga plawa kʉⱡ, mʉi ila kuk ropa, eng nomba morʉm. Utʉma oⱡa ila, tepa mana pangga, tʉk ndip kʉⱡing. Plawa mel roldʉnga kʉⱡ, Got ndi, ou ndurʉm ndam, wote enim wamp mbʉ, mundpa kel mba nda ei! Enim wamp mbʉ nga mondpa pili mel wei etpa petʉm. ");
INSERT INTO med_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Uⱡ ei nga, enim ndi, kʉⱡ keⱡ numan pilik kʉn, namba rʉng na, nu na mat nuimin ndam, nʉk pili nʉpʉlʉi, mon! ");
INSERT INTO med_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mbo wamp mbʉ, mel mbʉ nga mint pilik keⱡ rondʉrmin. Wote, enim nga Tipam Got ei ndi, enim nga ting mel mbʉ, pilpa pora ndurʉm. ");
INSERT INTO med_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wote enim ndi, Got nga wamp tʉpa mumʉk rui uⱡ ei tʉk, kuimbal mundʉng ndam, Got ndi, mel mbʉ pora, enim ngumba mint,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jisas ndi, wamp mbʉ kundpa nimba mel, “Enim wamp rʉⱡaip kel kʉⱡ, mundmong iti nʉtʉi! Nambuⱡ emel, enim nga Tipam ei ndi, nimba pora ndupa kʉn, Got nga wamp tʉpa mumʉk rui uⱡ ei, enim nguimp nitim. ");
INSERT INTO med_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Enim nga mel tek moⱡʉng mbʉ, rarʉp rok, ku tʉk, wote ku moni mbʉ tʉk, wamp kurpa moⱡʉng mbʉ, tʉk rapʉndʉk ngʉi! Ku moni wal rondʉⱡ kat kit muⱡi nambʉrʉm kʉⱡ ila mel kai mbʉ, tʉk wal rok, wi muⱡ kona ila tiyʉi! Kona ila wu raⱡ rui narʉmba, kindʉp nok ti nʉting, tʉtʉp ropa uⱡ ti, iti natʉmba. ");
INSERT INTO med_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Enim nga mel kai mbʉ, teng kona ila wote, enim nga mundmong ei kunda temba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisas ndi, wamp mbʉ kundpa, nimba mel, “Enim nga muⱡ mbal mbʉ tʉk, gi nduk ralk, lam kiya mbʉ, anmbil nangga. Tʉk kun etʉk muⱡʉi! ");
INSERT INTO med_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Enim nokʉndʉk muⱡing uⱡ ei, wu nuim na ti, kang amp tʉk etmin ila mba, rʉng nomba moⱡpa, wote yant omba, manga kumba roⱡnga kʉn, kongun wu kʉⱡ ndi molk, tʉkrʉk ok, manga kumba tʉtmʉn uⱡ ei mel. ");
INSERT INTO med_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wote, wu nuim ei, omba kandrʉm mel, kongʉn wu kʉⱡ ur pi napʉk mormin kʉⱡ, ambulk palk muⱡeing. Na ndi, enim ik kupa kat kundʉp nʉnt. Wu nuim ei, elim nga muⱡ mbal ei, tʉpa gi ndupa raⱡpa, wamp mbʉ, rat puⱡ ila, muⱡʉi nimba. Wote elim ndi, wamp mbʉ, rʉng ngumba ei nga nu kundpa moⱡmba. ");
INSERT INTO med_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wote, wu nuim ei, rumbʉl rangga omba, muna ou rumbuldi omba, muna wote rang mba tangga omba, kʉnangga kongʉn wamp kat ur pi napʉk, tʉk kun etʉk moⱡʉng wamp kʉⱡ, kapⱡa ambulk palk muⱡeing. ");
INSERT INTO med_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wote, enim uⱡ ti pilʉi! Manga puⱡ wamp ei ndi, kundʉp wamp ti omba, ei nga pilim ndam, elim nokundpa moⱡpa, elim nga mel mbʉ poⱡ tʉmba. ");
INSERT INTO med_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Uⱡ ei mel ku, enim akup tʉk kun etʉk muⱡʉi! Enim ndi, Muⱡʉl Wu Kupa ei, ui nawʉmba, rʉk pilik moⱡʉng ui tila omba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ndi, Jisas ni, waldpa nimba mel, “Wu Nuim ye! Nim ik ek rokʉn nʉn ik kʉⱡ, tʉn mint kundkʉn nʉn, muna wamp mbʉ, kunda kundkʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wote Jisas ndi, nimba mel, “Kongʉn wamp nam ti, elim numan kai pilpa, elim nga kongʉn ei etpa kai mondrʉm. Elim nga wu nuim ei ndi, elim to ropa mondpa kʉn, elim nga kongʉn wamp mbʉ rʉp endpa, rʉng nuing wi ei, pilpa mint, kongʉn wamp mbʉ rʉng ngumba. ");
INSERT INTO med_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wote, wu nuim ei, yant omba kʉnangga kʉn, elim nga kongʉn rʉp endpa, moⱡʉm ndam, kongʉn wu ei, ambuⱡpa paⱡpa moⱡmba. ");
INSERT INTO med_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na ndi, enim ik kupa kat kundʉp nʉnt. Wu nuim ei ndi, elim nga mel mbʉ pora, kongʉn wu ei ndi, rʉp itangga,” nimba. ");
INSERT INTO med_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","“Wote kongʉn wu ei, elim nga numan ila keⱡ rondpa kʉn, elim nimba mel, ‘Wu nuim ei, tʉkrʉpa ui nawʉmba ei ka!’ nimba. Wote, kongʉn wamp mat, tʉmbʉⱡ ndi ropa, rʉng tem mbʉ nomba, nu nomba kupʉr ropa muⱡangga kʉn, wote wu nuim ei omba, kʉnangga kongʉn wu ei, tʉpa kun iti natʉpa moⱡʉm ndam, wu nuim ei ndi, kongʉn wu ei etpa kit mondpa, kongʉn etʉk kit mondʉrmin wamp mbʉ kʉn, tʉpa rʉp rondʉmba. ");
INSERT INTO med_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kongun wu nam ti, elim nga wu nuim ei nga kongʉn endʉmba kʉⱡ, pilpa pora ndupa, wote elim tʉpa kon iti natʉpa moⱡʉm ndam, tʉmbʉⱡ ndi romba. ");
INSERT INTO med_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wote, kongʉn wu nam ti ndi, elim nga wu nuim ei nga endʉmba uⱡ kʉⱡ, pili napilpa, uⱡ kit mat em ndam, elim nga wu nuim ei om ei kʉn, kongʉn wu ei, tʉmbʉⱡ wei wei etpa romba. Mel ou ndupa tʉm wamp ei ndi, mel ou ndupa, punt ropa ngumba. Wote, mel ou ndupa, minal tʉm wamp ei ndi, to ei mel ku, punt ropa ngomba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, “Na omp kʉn, ndip ti, mʉi kona ila rop mundʉr ei, tʉkrʉpa ndip nangga nʉmp pʉnt. ");
INSERT INTO med_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na nu ti, mel ku timp ei, ti natʉp mor ei nga numan ei mbun enim. ");
INSERT INTO med_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Enim ndi, pilik kʉn, na ya mʉi kona ila mana ur ei, wamp nga moⱡpa kundi uⱡ ei, mep ui nʉwʉr! Na ndi, enim kundʉp nʉnt. Na omp wamp rʉⱡaip mbʉ, tʉp elpa elpa mundimp ei nga ur. ");
INSERT INTO med_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Akup ei kʉn, wote kunda ku, wamp mbʉ, paip kat manga tenda ila petmin ndam, raⱡ int tanggila, raldika yant tangina, el puⱡa wamp ralk muⱡing. ");
INSERT INTO med_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wamp oi rok muⱡing ei mel, tipam kangʉm raⱡ, el puⱡa wamp mel muⱡʉnggil. Mam mbuⱡam raⱡ, el puⱡa wamp mel muⱡʉnggil. Apʉm apʉm raⱡ, el puⱡa wamp mel muⱡʉnggil,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wote ni kʉn, Jisas ndi, wamp rʉⱡaip mam ti morʉng ila, kundpa nimba mel, “Enim ndi, wʉl ant ei, mana purʉm orunga, kona kopa kʉⱡ kandʉk kʉn, kona ndamʉng romba nʉtmin ei, kopa kona rorʉm. ");
INSERT INTO med_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wote enim ndi, molk kandʉk pilik kʉn, kona ant ei, al orʉnga rondʉⱡ mundpa oⱡa onʉm ei, ant mba nʉtmin ei, kopa kona ant purʉm. ");
INSERT INTO med_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Enim ndi, uⱡ kandʉk nʉtmin kʉⱡ, enim wamp ik kol rormin ei ka! Enim ndi, muⱡ mʉi raⱡ ila oⱡa orʉm uⱡ kʉⱡ, kandʉk pilik kʉmp tʉtmʉn. Enim nambuⱡ emel, akup ui ila nga uⱡ, enim kʉⱡ pilik kandʉk, kʉmp ti natʉtmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, “Nambuⱡ emel, en enim ndi, uⱡ kun mbʉ kʉmp tʉk, pilik kai etʉk, kʉni nakʉndʉrmin. ");
INSERT INTO med_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","Wamp nam ti ndi, nim kot indimp nim wamp ei kʉn, rʉp rokʉⱡ, nombuⱡa mam ila pukʉⱡ kʉn, mana nʉkʉⱡ kun mundi! Tʉpa kawa ndangga wamp ei ndi, nim mepa mba, kʉmp tʉmba pʉtmʉn wu kʉⱡ ngangga! Wu kʉⱡ ndi, nim mek puk, el wu kʉⱡ ngangina, wote el wu kʉⱡ ndi, nim mek puk, kan ngangina ila pekʉn molkʉn kʉn, nim ku moni mak rong kʉⱡ, ngʉkʉn mint, kan manga ila wak rokʉn uin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ui ni kʉn, Jisas ndi, wamp ik mbo endpa moⱡnga kʉn, wu mat rʉk ila morʉng nimbʉ ndi, Galili wu mbʉ etmin uⱡ mbʉ mel, Jisas timan rok ngok, nʉk mel, “Pailot ndi, elim nga el wu mbʉ, kundpa nimba mel, ‘Enim ndi, wamp rok kondʉrmʉn mema mbʉ, rat pol ila mana tek, kng mema mbʉ kalk oⱡa pol ila tek, Got kʉn oi nduk, angge nʉk ngʉi!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wote Jisas ndi, wu mbʉ, kundpa nimba mel, “Galili wamp uⱡ kit minal etmin mbʉ ndi etʉk, Galili wamp mat rok, mana ndurmin ei! Ei, uⱡ kit mbʉ nga puⱡ ti mon ei ka! ");
INSERT INTO med_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na ndi, enim ik kupa kat kundʉp nʉnt. Enim numan ropʉl rui narʉng ndam, enim i ku etʉk kuⱡing. ");
INSERT INTO med_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Unt, Sailom nga manga ruⱡ ndi, ʉtkil ropa mana omba, wamp 18 ropa kundrʉm. Wamp kʉⱡ nga uⱡ ⱡawa etʉng kʉⱡ ndi, Jerusalem wamp kʉⱡ rok mana ndui nandrʉng ei? ");
INSERT INTO med_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ei mon! Wote na ndi, enim ik kun kat kundʉp nʉnt. Enim numan ropʉl rui narʉng ndam, uⱡ ⱡawa mbʉ mel ku, enim kʉn uⱡ i ku etmba!” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wote Jisas ndi, wamp ik mbo endpa, ik ek kat ropa, nimba mel, “Wu ti ndi, elim nga wain pana ila rʉk nde pik kat, raⱡpa pinditim ila kʉnimp nimba mba kʉn, yant omba kʉndrʉm mel, nde pik kʉⱡ, mong ropa pi nʉptʉm. ");
INSERT INTO med_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Elim nga pana ila rʉp wu ni, kundpa nimba mel, ‘Nde pik kʉⱡ, pana kona ila rʉk anggilinga, pana raldika mong rui narʉm ei ka! Koⱡmung etkʉn, tʉkʉn mundi! Nambuⱡ emel, mʉi kopʉng etpa, pora ndupa anggʉtʉm?’ nitim. ");
INSERT INTO med_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","Kongʉn wu ni ndi, Wu Nuim kundpa, nimba mel, ‘Pana tenda ila mint, nokʉndʉp moⱡʉp kʉnmin. Mʉi rʉk rʉk etʉp, kng kau te maldʉp mundʉp tamba kʉn, wote pana mat ila, mong rui narʉm ndam, nʉn uⱡ ei mel koⱡmung etkʉn mundʉn,’” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jura wamp nga Mowi Kor ui ni kʉn, Jisas ndi, wamp mbʉ, atinga manga kel tila mukʉr ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Rʉk nila amp ti, kur kit ila rukʉr orʉnga murʉm. Kur kit rukʉr orunga moⱡpa, amp ei nga mbʉⱡ ming ei, etpa kʉrʉiya endilinga, pana 18 omba purʉm. ");
INSERT INTO med_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wote Jisas ndi, amp ni kandpa, wi ropa wangga nitim ila oⱡunga, amp ni, kundpa nimba mel, “Na ndi, nim nga kui ei, etʉp pora indamba pʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wote Jisas ndi, ki oⱡa ndupa, amp ni ambuⱡnga, tʉngʉnda mint, kui ei pora nilingga, amp ni oⱡa anggilpa mba, Got nga mbi paka rʉndrʉm. ");
INSERT INTO med_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jisas ndi, Mowi Kor ui ei kʉn, amp kur murʉm ni, etpa titim ni nga, atinga manga kel rʉp wu nuim ni, popʉⱡ kuⱡpa, wamp morʉng nimbʉ, kundpa nimba mel, “Rumbʉⱡ 6 kʉⱡ ila kongʉn etmin ni ka! Enim kui wamp mbʉ, kongʉn ui mbila, kui etʉk kapⱡa inding nʉk wʉi! Mowi Kor ui mbila, kui ei, etʉk kapⱡa inding nʉk, wu mat, wʉldi nʉwʉldʉi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wote, Wu Nuim ndi, ik nitim punt ropa, nimba mel, “Enim ik kol rok rormin wamp mat kant. Enim nga ik nʉk, uⱡ etmin mbʉ, to tenda mon ei ka! Enim wamp mbʉ ndi, enim nga kng kau na, donggi na mbʉ, nu nuing nʉk mek, Mowi Kor ui ei kʉn purmin. ");
INSERT INTO med_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya amp Eiparam nga mbuⱡam ei, Seitan ndi, kan ngurʉm ila pana 18 omba purʉm ei ka! Ya amp ei, kan ngurʉm uⱡ ei, Mowi Kor kʉn etʉp tʉp, mundi nʉmʉndamp, mon ei?” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas ndi, ik nitim ni pilik, el puⱡa wamp mbʉ, pipil minal kurʉng. Wamp mat ndi, Jisas nga uⱡ min ngʉn pi itim ni kandʉk, ambulk palk morʉng. ");
INSERT INTO med_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Wote Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Got nga wamp tʉpa mumʉk rui uⱡ ei namba mel ei nda? Wote, ik ek rop namba namp nda? ");
INSERT INTO med_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nde mong ei, mbi tek mastat nʉtmin. Wu ti, nde mastat mong ei, tʉp mepa mba, elim nga pana ila rʉrʉm. Wote, nde mastat oⱡa omba, omung etpa, puⱡa mam mbʉ etpa eling kʉn, kʉi mbʉ ndi ok, nde puⱡa mbila mi manga rok petmin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wote Jisas ndi, ik ti ku, wamp mbʉ kundpa, nimba mel, “Got nga wamp tʉpa mumʉk rui uⱡ ei, ik ek rop namba namp nda? ");
INSERT INTO med_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kona ei, yis mel kapⱡa. Amp ti ndi, yis oi ndupa, plawa kuⱡpa, ming ila oi ndupa kʉn, ropa oⱡa mana etpa telinga, wote mepa oⱡa orʉm ni mel kapⱡa,” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wote Jisas ni, Jerusalem kona peng ou ila mba pilpa purʉm. Kona peng kel nimbila, wamp ik mbo endpa ku purʉm. ");
INSERT INTO med_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Wu ti ndi, Jisas waldpa, nimba mel, “Wu Nuim ye! Got ndi, wamp tenda tenda etpa, rukʉr titim tʉmba nda?” nitim. Wote Jisas ndi, wamp mbʉ kundpa, nimba mel, “Enim wamp mbʉ, ombil pendʉk, keta puⱡ puⱡ kel mel wei ila mukʉr ping. Na ndi, enim ik kupa kat kundʉp nʉnt ei ka! Wamp puⱡi mbin nʉk etmin ku. Wote, kapⱡa mon! ");
INSERT INTO med_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wote, manga puⱡ wu ei ndi omba, manga kumba ʉngʉndangga kʉn, enim manga keta puⱡ puⱡ pena orʉnga anggilik kumba rok, gep nduk molk, nʉk mel, ‘Wu Nuim ye! Tʉn onmʉn, manga kumba tindʉn ka!’ ning. Wote yant ndupa, enim kundpa, i etpa nimba mel, ‘Na ndi, enim pili napʉt, wamp kʉⱡ ka! Enim kona nant orunga ong wamp mbʉ nda?’ nimba. ");
INSERT INTO med_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wote enim ndi, i ik punt rok, nʉk mel, ‘Tʉn nim kʉn rʉp rok, nu na, rʉng na mbʉ moⱡpʉn nombʉn itmin ni ka! Nim ndi moⱡʉn, tʉn nga kona ila, ik mbo endkʉn itʉn ku ni ka!’ ning. ");
INSERT INTO med_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wote, enim aldpa kundpa, nimba mel, “Enim kona nant orunga wamp kʉⱡ? Na ndi, enim pili napʉt wamp kat ei ka! Enim uⱡ kit mbʉ etmin wamp kʉⱡ, kelik pʉi!” nimba. ");
INSERT INTO med_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wote, enim rop enim ndi, kʉning ei, Eiparam, Aisak, Jekop, na painui wu mbʉ pora, Got nga wamp tʉpa mumʉk rui kona ila rukʉr moⱡangina kʉning. Enim wamp mbʉ ndi, puk manga keta puⱡ puⱡ pena orunga molk, ka etʉk, gu konggʉlʉk, gi nduk muⱡing. ");
INSERT INTO med_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Al ant oⱡa ui orʉnga, wʉl ant mana pi orʉnga, met orʉnga, wi orʉnga, wamp mbʉ ok, Got nga wamp tʉpa mumʉk rui kona ila rukʉr rʉng nok muⱡeing. ");
INSERT INTO med_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Enim pilʉi! Akup nga ui ila wamp mat ok, kuimbal mormin mbʉ, wote ok akil ting. Akup nga ui ila wamp mat ok, akil tek mormin wamp mbʉ, wote ok, kuimbal muⱡeing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ant mong ila mendpʉⱡ, Perisi wu mat ndi ok, Jisas murʉm ni, kundʉk nʉk mel, “Nim ndi, ya kona ei, wak rokʉn, kelkʉn kona ronggʉt elpa tila pi! Nuim Erot ndi, nim ropa kondʉmba ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas ndi, wu nimbʉ, kundpa nimba mel, “Enim ndi puk, owa rakra kit ei, kondʉk nʉk mel, ‘Akup kʉn, utʉma raⱡ ila, na ndi, wamp mbʉ nga kur kit moⱡʉm mbʉ, tʉp mundʉp, kui rorʉm wamp mbʉ, etʉp kapⱡa endʉp muⱡimp. Ui onʉnga kuⱡ ila moⱡʉp, kongʉn ei etʉp mbo pora nduimp, nʉm nʉk kondʉk nʉi!’ ");
INSERT INTO med_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wote akup ei kʉn, utʉma kʉn, kona ila na nanim kelip pamp. Painui wu ei, kona elpa ila muⱡangga, rok kundi nʉkʉnding, mon. Jerusalem kona peng ou ila mint muⱡangga, mint rok kunding. ");
INSERT INTO med_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jisas ndi, ka etpa wi ropa nimba mel, “Enim Jerusalem, Jerusalem wamp mbʉ ye! Enim ndi, painui wu mbʉ, rok kundʉk ku etmin. Got ndi, wamp mat tʉpa enim ngurʉm mbʉ, ku ndi rok kondrʉng ei ka! Wote na ndi, enim wamp mbʉ etʉp, kʉi kulda mam ei ndi, waⱡ mbʉ tʉpa, pou ila ruk ruk etʉm ni mel itimp nʉmp et ku. Ei wote, enim wamp mbʉ ndi, numan ngui nganggʉrmin. ");
INSERT INTO med_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Enim pilʉi! Got ndi, enim wak romba ei kanmin mon. Na ndi, enim ik kun kat kundʉp nʉnt. Enim ndi, na kʉni nakʉndʉk moⱡangina. Wote ui tila nʉk mel, ‘Nuim ei nga ila om wu ei, Got ndi, memp pindangga ning ei ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wote, Jura wamp nga mowi kor ui ni kʉn, Perisi wu nuim ting manga ila, Jisas rʉng nomba pilpa purum. Perisi wu mbʉ ndi, Jisas rʉp etʉk kandʉk morung. ");
INSERT INTO med_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kona ila wu ti nga kʉmp ki orum wu ti, Jisas murum ila nondpa murum. ");
INSERT INTO med_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Wote Jisas ndi, wu ni kandpa kʉn, mi ik mbo wu na, Perisi wu na nimbʉ, waldpa nimba mel, “Mowi kor ui ei kʉn, tʉn ndi kanda, kui wamp mbʉ etʉp, kai mundmin muna mon nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wote wu nimbʉ, ik mat ni nandʉk morung ila, Jisas ndi, kui wu ni, tʉpa mepa mba, kui rurum ni etpa, kapⱡa endʉp pi nilinga, kelpa purum. ");
INSERT INTO med_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wote Jisas ndi, wu nimbʉ, kundpa nimba mel, “Enim nga kangambuⱡa ti kep, muna kng kau ti kep, kut ila mana mba pem ei kʉn, mowi kor ui ila kapⱡa, tʉkrʉk puk, oⱡa ting muna mon nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wote, wu nimbʉ ndi, Jisas nga nitim ik ni, punt rok ik mat ni nandʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","8","Perisi wu ei nga rʉng kurum kona nila, Jisas moⱡpa, kʉndrʉm mel, wu mat en enim raⱡ pol mat kuimbal titim nimbila, muⱡmin mint nʉk pilik orung. I etʉng ila, Jisas ndi, ik ek ropa, wamp nimbʉ, kundpa nimba mel, “Wu ti ndi, kang amp tʉmba ila rʉng koipa, ‘Enim wʉi!’ nitim. Nimba kʉn, wi rom ndam, nim pukʉn, rat pol kuimbal muⱡi nʉmbʉⱡi. Wu ti, elpa mbi moⱡpa etʉm ti nga to rok tʉndʉng tila, nim pili napilikʉn puk muⱡʉn. ");
INSERT INTO med_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nim okʉn, kuimbal muⱡana kʉn, wote rʉng koim puⱡ wu ni ndi, nim mʉn ila omba, nim kundpa, nimba mel, ‘Nim morʉn rat pol kuimbal ei, wu ti elpa ngangga!’ Wote, nim pipil kulkʉn, pukʉn met tʉp orunga, rat pol mbila muⱡʉn. ");
INSERT INTO med_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wote. uⱡ ei nga, wu ti ndi, rʉng koipa nim ui nimba wi rom ndam, nim pukʉn, tip orunga muⱡana. Wu ei ndi, nim mʉn ila omba, nim kundpa, nimba mel, ‘Ana ye! Nim okʉn, rat pol kuimbal muⱡʉn ui nangga kʉn, nim okʉn, rat pol kuimbal moⱡʉn, wamp nga kuimp keta ila mbi ou tʉkʉn, rʉng nokʉn muⱡʉn.’ ");
INSERT INTO med_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wamp nam ti, elim nga kʉng orunga mepa oⱡa mba moⱡum ndam, Got ndi, wamp ei, ropa mana ndumba. Wamp ti elinga, kʉng orunga mepa mana mba moⱡum wamp ei, Got ndi, wamp ei, paka rondʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wote Jisas ndi, rʉng kuitʉm wu ndi, kundpa nimba mel, “Nim ndi, rʉng koikʉn nuin etkʉn kʉn, nim nga wamp rʉⱡaip tenda na, ʉngʉnʉl na, kng mel pi wamp mbʉ, wi rokʉn, weing ni nʉni! Wote, wamp mbʉ ndi, rʉng mat koikʉn, nim wi rangina, pun ndam, nim nga rʉng koikʉn ngurun mbʉ, punt rok yant nguing. ");
INSERT INTO med_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ei mon! Nim ndi, rʉng mam ti kuin ndam, wamp kurpa na, kʉmp ki kit wamp na, mong ti wamp mbʉ, wi rok nana ok rʉng neing. ");
INSERT INTO med_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Got ndi, nim memp pendʉmba. Nambuⱡ emel, wamp kit mbʉ ndi, nim nga rʉng ngʉn mbʉ nok kʉn, punt rui nʉring. Got ndi, nim punt ropa ngumba ui ila, wamp kun kai korung wamp mbʉ, on kona ila ⱡoprʉk yant ong,” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wote, rʉng nok morung mou ila rʉk wu ti, Jisas kʉn murum ni ndi, ik nʉtʉng ni pilpa, Jisas kundpa, nimba mel, “Got nga wamp tʉpa mumuk rui kona ila rʉng nok moⱡʉng mbʉ, kai pilik muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wote Jisas ndi, wu ni, kundpa nimba mel, “Wu ti ndi, rʉng mam ti koipa kʉn, wamp puⱡi rʉng neing wʉi nimba wi rorum. ");
INSERT INTO med_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wote, rʉng koipa ui ei kʉn, elim nga kongun wu ti, tʉpa mundrum ila mba, wamp rʉng neing weing nimba, unt to rurum mbʉ, wi ropa nimba mel, ‘Rʉng mbʉ, tʉpa kun etpa pora ndum, neing wʉi!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wote wamp nimbʉ, pi nʉpʉmʉn nʉtʉng. Wu ti ndi, nimba mel, ‘Na kongun kona ti, rarʉp nop tint ei, mbo kʉnimp mbi ent. Na pi nʉpimp,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wu ti ndi, nimba mel, ‘Na pi nʉpimp, kng kau 10 kat rarʉp rop tint kʉⱡ, kongun iting, muna mon nda? Na mbo kʉnimp ent,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wu ti ndi, nimba mel, ‘Na amp kokila ti, tʉp tep mor ei ka, pi nʉpimp,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Wote, kongun wu ni ndi, wamp ik nʉtʉng nimbʉ, pilpa yant omba, wu nuim ei, kundpa nitim. Wu nuim ni pilpa, popʉⱡ kuⱡpa, elim nga kongun wu ni, kundpa nimba mel, ‘Nim tʉkrʉk mint pukʉn, kona peng ei nga nombuⱡa ou kel tetʉm mbila, wamp kurpa na, kʉmp ki kit wamp na, mong ti wamp na mbʉ, tʉk mekʉn wana, na nga manga ei, mukʉr ti nangga!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kongun wu ni ndi, wu nuim ni nga nitim ni mel, etpa pora ndupa kʉn, wu nuim kundpa, nimba mel, ‘Nim nin ni mel int ei nga, wote manga ni, ti ni nanʉm,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wote, wu nuim ni ndi, kongun wu ndi, kundpa nimba mel, ‘Nim kona peng ei, wak rokʉn, nombuⱡa kel ila pukʉn, kinana wamp mat moⱡʉng ndam, ik ronduⱡ mundkʉn wamp mbʉ kʉn nana, wamp mbʉ, ya na nga rʉng kuimp ila wangina, manga ei ti nangga! ");
INSERT INTO med_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na ndi, enim kondʉp nʉnt. Unt wamp mat, wi rʉr mbʉ ndi, na nga rʉng koint mbʉ nga kot, ama nomba kʉni nakʉndʉmba!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Ni kʉn, akil tepa wamp rʉⱡaip mam ti, Jisas kʉn rʉp rok purung. Wote Jisas ndi, ropʉl ropa, wamp mbʉ kundpa, nimba mel, “Wamp ti, na kʉn pep ropa uimp nimba pilim ndam, elim nga tipam mam raⱡ kep, amp kangambuⱡa mbʉ kep, ʉngʉnʉl kimʉnʉl mbʉ kep, wote elim nga mul uⱡ ei kep, wak ropa om wamp ei, na nga kitip kʉni wamp ti moⱡmba. ");
INSERT INTO med_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wamp ti, elim nga uⱡ mbun mindil mbʉ, nde peta mel, mi namʉmba, na pep rom ndam, wamp ei, na nga kitip kʉni wamp muⱡi nambʉⱡmba. ");
INSERT INTO med_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wote, wu nam ti ndi, manga mam ti, rʉkimp nimba kʉn, ku moni namba iti ndi, manga ei, rakʉp timp nda nimba, numan ila kuimp tepa to rorum. ");
INSERT INTO med_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Kuimp elim tepa, elim nga numan ila pilpa, kun iti natʉpa kʉn, ku ronduⱡ etpa pendʉm ndam, wote mang ei rakpa, pora ndui nʉndangga kʉn, wamp mbʉ ndi kandʉk, ik raka rondʉk nʉk mel, ‘Manga ei rakpa, pora ndui nʉndrʉm ei ka!’ ning. ");
INSERT INTO med_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wu nuim ti mba, wu nuim ti kʉn, el itimp nimba kʉn, kuimp tepa, elim nga numan kuimp tepa pʉtʉm. Elim nga el wu 10,000 tep morum. Wu nuim ti nga el wu 20,000 mepa omba, elim kʉn el pendpa, elim rok munding, muna mon nda nimba, unt pʉtʉn kuimp tepa pʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wu nuim ei ndi, elim kʉn kapⱡa mon nimba, pilpa kʉn, wu nuim ei, ruⱡ etpa moⱡnga kʉn, wu mat tʉpa, nomba uⱡ rung mundpa kʉn, el ei, rop kundimp nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Uⱡ ei mel ku, wamp nam ti ndi, elim nga mel mbʉ, wak rui narʉm ndam, na nga kitip kʉni wamp muⱡi nambʉⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wote Jisas ndi, ik ti, nimba mel, “Ip kuta ei, mel kai. Wote, ip kuta nga tʉngʉn ei, pora nim ndam, namba uⱡ ti etpʉn kʉn, ip kuta nga tʉngʉn ei kai moⱡmba. ");
INSERT INTO med_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ip kuta kit morum ei, tʉpʉn kongun kona na mbila, ropʉn mundi namʉndʉrmʉn. Kng kau te na mbila, tʉp rak ndupʉn, pana kona na mbila, mundi namʉndʉrmʉn ku. Ropʉn mundpʉn ketmin ni ka! Wamp ti, kum nombuⱡa tem ndam, ik mong ei pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wote, ku moni takis tʉk, uⱡ kit mbʉ etʉk etʉng wu nimbʉ, Jisas ni moⱡpa, ik nitim ila kum tek, pilmin nʉk, nondpa orung. ");
INSERT INTO med_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wote, Perisi wu na, mi ik mbo wu na nimbʉ ndi, ik mura etʉk, Jisas kundʉk, nʉk mel, “Wu ei, wamp kit mbʉ kʉn, ki ngumba moⱡpa, rʉng rak ndupa moⱡpa, nomba enim ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Wu kʉⱡi nʉtʉng ila, wote Jisas ndi, ik ek kat ropa, wu kʉⱡ kundpa, nimba mel, “Enim wu mbʉ nga ti ndi, kng sipsip 100, ʉt ropa tepa muⱡangga kʉn, wote kng sipsip tenda ti, andpa mba tiki poⱡpa, pena pem ndam, kng sipsip puⱡ wu ei ndi, kng sipsip 99 wak ropa tila, mondpa kelpa mba, kng sipsip tenda ei, kandʉp timp mint nimba, kurpa purum. ");
INSERT INTO med_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Mba kurpa kandpa tʉpa kʉn, tʉpa pendʉk ombil ila koma ropa mepa, rui mʉi nimba, mepa manga kona omba kʉn, elim nga wamp rʉⱡaip tenda na, wamp puⱡ mbʉ, wi ropa rukʉr tʉpa, nimba mel, ‘Na nga kng sipsip tenda ti, andʉp mba tiki purum ni, kandʉp tʉp mep, ont nitim mel kʉn, wamp mbʉ elim kʉn ambulk palk tʉtʉng,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jisas ndi, nimba mel, “Na ndi, enim ik kupa kat kundʉp nʉnt. Ya mana nʉtmin uⱡ ei mel ku, ambulk palk wamp kit ti, numan ropʉl rorum ei kʉn, wi muⱡ kona ila ambulk palk, ei mel ku nʉtmʉn. Wamp 100 kʉⱡ, numan ropʉl rok, pora nduk mormin nʉk pilik mormʉn. Ei mon! Wamp tenda ei mint, uⱡ kit mbʉ etpa morum ni, numan ropʉl rorum ei kʉn, wamp ama ambulk palk tʉtʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wote Jisas ndi, ik ek ti ropa, wamp mbʉ, kundpa nimba mel, “Amp ti, elim ku silpa mong ruri kat, tepa muⱡangga kʉn, ku mong ruri tenda ti, manga mukʉr etpa, tʉpa mana ndupa etʉm ndam, wote namba uⱡ etmba? Ku meiya kandpa, manga brum mepa, kandʉp timp nimba kʉrʉrʉm. ");
INSERT INTO med_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Amp ni, elim nga ku mong mana purum kandpa tʉpa kʉn, elim nga wamp mbo na, kona tenda wamp na mbʉ, wi ropa rʉk tʉpa, kundpa nimba mel, ‘Na nga ku mong ruri ti, mana purum ni, akup kurʉp kandʉp tint, nitim ila wamp mbʉ kʉn, ku moni puⱡ amp ei kʉn, ambulk palk minal,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, “Na ndi, enim ik kupa kat kundʉp nʉnt. Ya mʉi kona ambulk palk nʉtmin uⱡ, to ei mel ku, wamp kit ti, numan ropʉl rorum ei kʉn, Got nga wi muⱡ kona anggelo mbʉ, uⱡ i etʉk, ambulk palk,” nʉtmin. ");
INSERT INTO med_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wote Jisas ndi, ik kat wamp mbʉ, kundpa nimba mel, “Wu ti nga kangʉm wu raⱡ mitim. ");
INSERT INTO med_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kang wu akil ni ndi, tipam kundpa, nimba mel, ‘Na ndi, numan ti pʉnt ei mel, nim ndi mel mbʉ, kʉmp tʉkʉn mat, kang wu komun ei ngukʉn, na nga nguin mat, akup ngui!’ nitim. Wote tipam ndi, mel nimbʉ, kʉmp tʉpa, kangʉm wu raⱡ ngurum. ");
INSERT INTO med_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kang wu akil ei nga ngurum mel nimbʉ, tʉkrʉpa mint tʉpa, mʉk ropa wamp mbʉ kʉn, ku moni tʉpa mepa, nung nimba, kona ruⱡ ronggʉt muⱡimp nimba purum. Kona nila moⱡpa, ik pili napilpa, ku moni mepa purum mbʉ, etpa pora ndurum. ");
INSERT INTO med_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ku moni na mel nimbʉ, etpa pora nduⱡnga kona nila, kump kun mam ti titim ila, kun kurum. ");
INSERT INTO med_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wote, kang wu ni mba, kona ila wu ti nga kongun indimp nimba purum. Wu ni ndi, kang wu ei tʉpa, elim nga kng makrʉp indangga nimba, tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kang wu ni mba kʉndrʉm mel, kng nimbʉ mbin kʉng mbʉ, norung ni kandpa, ol tʉmʉng nurum. Wote, wamp na ti ndi, elim rʉng na mat, nangga ngʉk iting mel, kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kang wu ni, akup numan kun kat kandpa, tʉpa moⱡpa nimba mel, “Na nga tipam ei nga kongun wamp mbʉ, rʉng puⱡi tek mormin pʉnt ei ka! Na ya ila mʉn ndam, kump kun ndi kuⱡimp. ");
INSERT INTO med_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nanim kelip, wuta kʉn mbo rimp mel, ‘Na ndi, Got kʉn wuta, nim raⱡ etʉp, kit mundʉr ei ka nimp. ");
INSERT INTO med_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Akup, na wu kai ti mon. Ei nga, na nim nga kangʉm ei nin, mel kapⱡa mon. Na tʉkʉn nim nga kindmant kongun wu mel mundʉn,’” nitim. ");
INSERT INTO med_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nimba kʉn, tipam murum kona nila elim purum. Mba nombuⱡa mam ila ruⱡ etpa pelinga, tipam moⱡpa kʉndrʉm mel, kangʉm urum ni kandpa kʉn, tʉkrʉpa omba, kangʉm kanggʉⱡpa, numan minal ngurum. ");
INSERT INTO med_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kangʉm ndi, tipam kundpa, nimba mel, ‘Na ndi, Got kʉn nim kʉn, kit mundʉr. Ei nga, akup na wu kai ti mon. Nim ndi, na nim nga kangʉm nin mel mon ei ka!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wote tipam ndi, elim nga kongun wu nimbʉ, wi ropa nimba mel, ‘Enim ndi, wal pʉki kai ni kʉⱡ, mek ok puk ndʉi! ");
INSERT INTO med_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Puk kʉn, kng kau waⱡ pela kai iti ti, tʉk mek ok, rok kui yangina, tʉn nombun moⱡpʉn, ambuⱡpʉn paⱡpʉn muⱡamʉn!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tipam ndi, nimba mel, ‘Na nga kangʉm wu ei, mba kurum nʉmp pitmin ni mon! Kont moⱡpa, yant om ei nga rʉng mam ti nok molk, ambulk palk muⱡamʉn,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kang wu kumna ni, ant ei kʉn, kongun kona ila murum. Wote, mang kona uimp nimba, manga keta ila nondpa omba, pitim mel, wamp mat gita rok, denis etʉk nʉk, morung ni pitim. ");
INSERT INTO med_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wote, kongun wu ti, wi ropa tʉpa, waldpa nimba mel, ‘Wamp mbʉ, namba elinga nʉk mormin ei?’ nitim. ");
INSERT INTO med_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kongun wu ni ndi, punt ropa nimba mel, ‘Nim nga ʉngʉn wu akil ni, yant om ila tipanʉm ndi, kangʉm om ei nga numan elinga kʉn, kng kau waⱡ pela ti, ropa koim. Ei nambuⱡ emel, kangʉm moⱡpa, kai mondpa, yant om ei nga em ei.’ ");
INSERT INTO med_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kang wu kumina ei ik ni pilpa kʉn, popʉⱡ kuⱡpa, manga ila mukʉr pi napʉpa, pena murum. Wote tipam ni, pena omba, kangʉm ik mat kundʉp namba, numan wang ndangga, nimba nitim. ");
INSERT INTO med_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kang wu ni ndi, tipam kundpa, nimba mel, ‘Nambuⱡ emel, na ndi, nim nga kindmant kongun endʉp puⱡ mba, pana mbʉ ou ndupa omba purum. Na ndi, nim nga ik tʉp, roi ndui nandʉp et, ni ka! Nim ndi, na kng meme waⱡ na ti, ngana kʉn, na nga wamp puⱡ mbʉ kʉn kep, koip nomp, numan kai pilip iti natʉt mon, ni ka! ");
INSERT INTO med_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wote, nim nga kangʉm wu ei ndi, mel mbʉ mepa mba, amp wapra mbʉ kʉn, etpa pora ndupa pendpa, wote aldpa, yant om. Ei nga, kng kau waⱡ pela ti, rok koindkʉn itʉn ye!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wote, tipam wu ni ndi, kangʉm wu kumina ni kundpa, nimba mel, ‘Nim ya na kʉn, rʉk rʉk rʉp rokʉn morʉn, ni ka! Na nga mel tetʉm mbʉ pora mel, nim nga mbʉ mint tetʉm. ");
INSERT INTO med_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wote, kang wu ei mba, kurum nda nimbun pitmin ni, akup kont moⱡpa, yant om. Ei nga, numan kai pilpʉn, ambuⱡpʉn paⱡpʉn nʉmp tamin,’” tipam ndi nitim. ");
INSERT INTO med_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Ku moni ʉmbrʉm wu ti, elim nga wu ti ndi, kongun rʉp inditim. Ei kʉn, wu mat ndi ok, ku moni ʉmbrʉm wu kunt rok, nʉk mel, ‘Nim nga kongun rʉp wu ei ndi, ku moni mbʉ etpa nʉwʉ pora ndunʉm ei ka!’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wote, ku moni ʉmbrʉm wu ni, elim nga kongun rʉp inditim wu wi ropa, kundpa nimba mel, ‘Nambuⱡ emel, nʉkʉn nim uⱡ etʉn mbʉ, na kundʉk nilingina pʉnt. Na nga mel mbʉ pora, nim nga ki ila tetʉm mbʉ nga punt rokʉn, tʉkʉn kun indi. Nim akup kongun wu muⱡi nʉmbʉⱡʉn!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wote, kongun rʉp wu ni, elim nimba mel, ‘Na nga kongun rʉp endʉt wu nuim ei ndi, na makrʉnʉm pʉnt ei nga kindmant kongun mʉi apʉp rop, itimp mel kapⱡa mon. Na ndi, wu mat, ku moni nguing nimp uⱡ ei, pipil enim. ");
INSERT INTO med_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akup na uⱡ ti, itimp ei mel pʉnt. Na nga wu nuim ei ndi, na makrʉm ei kʉn, wu mbʉ ndi, na mek, enim nga manga mbila ping,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nimba pilpa kʉn, wu tenda tenda nimba, elim nga wu nuim ei nga punt mondrung wu mbʉ, wi rurum ila orung. Wote wu ti, kuimp tepa urum ni, waldpa nimba mel, ‘Nim ndi, na nga wu nuim ei nga punt namba iti mundrʉn?’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wote, wu ni ndi, nimba mel, ‘Wel ming 100 tit ei ka!’ nitim. Wote, kongun rʉp wu ni ndi, nimba mel, ‘Nim pepa ongum ngʉnt ei ndi, nim nga punt morum ei nga, tʉkʉrkʉn mana molkʉn, 50 nʉkʉn, mon rokʉn mundi!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wote, wu ti urum ila, kongun rʉp wu ni ndi, waldpa nimba mel, ‘Nim nga punt namba iti norum?’ nitim. Wu ni ndi, nimba mel, ‘1000 ming wit morum,’ nitim. Kongun rʉp wu ni ndi, wu ni, kundpa nimba mel, ‘Nim pepa ongum ngʉnt ei ndi, punt 800 nʉkʉn, mon rokʉn mundi,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Wote, wu nuim ni ndi, kongun wu ni itim uⱡ ni kʉⱡ, kandpa mbi ndupa kʉn, kongun rʉp itim wu ni, kai nitim. Uⱡ ei, nambuⱡ emel, kongun rʉp wu ei ndi, wamp mbʉ mel punt mondrung mbʉ, mepa mana omba mon ngurum. Uⱡ itim ei ndi, elim numan ngeing nimba itim. Wu mat ndi, ya mʉi kona ila uⱡ mbʉ nga minal, peng goiya tʉk, enim nga kongun elpa elpa mbʉ, pip rok etʉk, mek puk kʉn, rʉⱡang ila mormin wamp mbʉ, rok mana ndurmin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na ndi, enim ik kupa kat kundʉp nʉnt. Ya mʉi kona ila ku moni mel kit ei, enim ndi, tʉk ambulk kʉn, wamp mbʉ tʉk rapʉndʉⱡngina, enim numan ngormʉn. Wakʉt ui tila, ku moni ambʉrmin uⱡ ei, pora nim kʉn, uⱡ nga kʉnt nga kona ei, ik tʉk rapʉndrʉng wamp mbʉ ndi, enim rawe etʉk ting. ");
INSERT INTO med_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wote, wamp nam ti ndi, mel kel mbʉ rʉp etpa kai mondum ndam, wote mel ou mbʉ, kapⱡa rʉp kai etmba. Wamp ti ndi, mel kel mbʉ kʉn, uⱡ kun mat iti natʉm ndam, wote mel ou mbʉ kʉn, uⱡ kun mat iti natʉmba ku. ");
INSERT INTO med_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ya mʉi kona ila, ku moni mel kit ei, wamp ti ndi, rʉp etpa kit mondum ndam, wote wamp nam ndi, Got nga kongun uⱡ kupa mbʉ nangga, rʉp etpa kai mondʉmba? ");
INSERT INTO med_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wote enim ndi, wamp mat nga mel mbʉ, rʉp indi nandʉng ndam, wote enim mel mbʉ nam ndi ngumba? ");
INSERT INTO med_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wamp ti ndi, kongun wu raⱡ nga kongun kindmant rak ndi nandʉmba. Kongun wu ti, numan ngum ndam, kongun wu ti numan ngui ngangʉmba. Kongun tila ik kum tem ndam, tila tʉpa mbuⱡ ngumba. Enim Got nga kongun etʉk, wote ku moni ei kʉn, rak nduk kongun iti nʉtʉi mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Perisi wu mbʉ, ku moni mint numan ngurmin uⱡ ei ndi, Jisas nga nitim ik ei, tʉk ik kuldʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wote Jisas ndi, Perisi wu mbʉ, kundpa nimba mel, “Enim numan ei ndi, pitmin uⱡ ei, wamp mbʉ ndi, enim uⱡ kun mbʉ, etmin nʉk, pileing nʉk pʉtmʉn ei ka! Wote Got ndi, enim nga mundmong ila, uⱡ mo ropa petʉm uⱡ kʉⱡ pʉtʉm. Wamp ndi, uⱡ kai mat nʉk pʉtmʉn kʉⱡ, Got nga kuimp keta ila, uⱡ kit kʉⱡ etmin. ");
INSERT INTO med_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mi ik na, painui wu mbʉ nga ik na mbʉ, Jon wamp nu tindi wu ei murum ei kʉn titim. Got nga wamp tʉpa mumuk rui rʉnang kai ik ei, Jon puⱡ mondʉp, kongun itim ei kʉn, mʉi kona mbila pora purum. Got nga wamp tʉpa mumuk rui kona ila wamp mbʉ pora, ronduⱡ mundʉk, rukʉr mbin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Muⱡ mʉi raⱡ pora nimba, wote Got nga mi ik kel kot, ama pora ni nanʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisas ndi, ik ti nimba mel, “Wu nam ti ndi, elim nga amp ei, wak ropa ndupa mundpa kelpa kʉn, amp elpa ti tʉm ndam, wu ei, wapra nga uⱡ etmba. Wu ti nga amp ti, unt wak ropa ndupa mundpa kitim ti, wote wu ti tʉm ndam, wu ei, wapra nga uⱡ ku etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Wote Jisas ndi, ik ti, nimba mel, “Unt wu mel pi ti murum. Rʉk rʉk mel eng nui kai mbʉ mint raⱡpa, wal pʉki kunt mbʉ mint, pakʉpa murum. Ant mbila rʉk rʉk rʉng kai mbʉ mint, nomba murum. ");
INSERT INTO med_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Wu mel pi ei nga manga keta puⱡ puⱡ kumba pena orunga, wu kurpa ti murum. Wu kurpa ei nga mbi ei Lasarus. Wu mel pi ei nga rʉng na mat nomba itim kʉn, rat pol ila mana mba itim mbʉ, aprʉp tʉp nomp elimba, nimba pitim. Kʉng iti etpa mema ropa itim mbʉ, owa mbʉ ndi ok, pen tek nok etʉng. ");
INSERT INTO med_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wote Lasarus ni, kurum ila, anggelo mat ndi ok, tʉk mek, muⱡ kona Eiparam kʉn, rʉp rok mondrung. Wote, wu mel pi ni kurum ila, tʉk anggʉtʉng ku. ");
INSERT INTO med_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wu mel pi ni, koⱡpa mba kʉn, wamp kolk puk, mindil mam mbʉ nok mormin kona ila mba, mindil nomba moⱡpa, tʉpa oⱡa ndupa kʉndrʉm mel, Eiparam ni Lasarus raⱡ, rʉp rokʉⱡ, ruⱡ etkʉⱡ morunggil. ");
INSERT INTO med_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wu mel pi ndi, wi ropa nimba mel, ‘Wuta Eiparam ye! Nim ndi, na kont kulkʉn, Lasarus kundkʉn nana kʉn, ki ila nu kot mondpa, mepa omba, na nga keta anmbil ila, oi ndangga kʉn, keta anmbil ei koma tiyangga! Na ya ndip ila moⱡʉp, mindil mam ti nont ei ka!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wote Eiparam ndi, wu ni, kundpa nimba mel, ‘Kang wu ye! Nim kont murʉn ni kʉn, mel kai mbʉ mint, ʉmbrʉn ni pili. Lasarus mel kit mbʉ mint ʉmbrʉm. Akup ya kona ila, Lasarus numan kai pilpa morum. Wote, nim mindil kit nokʉn morʉn. ");
INSERT INTO med_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wote uⱡ ti, Got ndi itim ei, enim mormʉn kona ei kʉn, ya tʉn mormʉn kona raⱡ nga rʉk ila, ruⱡ mam ti petʉm. Ya orunga mormʉn wamp mbʉ ndi kapⱡa, ru ei puⱡa rok, int orunga uing mel kapⱡa mon. Wote, int orunga mormʉn wamp mbʉ ndi, ru ei puⱡa rok, ya orunga uing mel kapⱡa mon ku.’ ");
INSERT INTO med_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Wote, wu mel pi ni ndi, nimba mel, ‘Wuta Eiparam ye! Nim ndi, kapⱡa Lasarus tʉkʉn mundana, na nga wuta nga mang kona mba, na nga wu ʉngʉnʉl 5 kat mormʉn kʉⱡ, kundpa nangga kʉn, pilik uⱡ ⱡawa etmin mbʉ, tʉk kʉn etʉk muⱡeing. Tʉpa kawa ndangga, wote wu kʉⱡ ok, ya kona ila mindil mam mbʉ, nuing ei mon!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wote Eiparam ndi, punt ropa nimba mel, ‘Moses nga mi ik na, painui wu mbʉ nga mi ik na mbʉ pora, tetʉm ei kapⱡa, wu mbʉ kum tek piling,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wu mel pi ni ndi, punt ropa, Eiparam kundpa, nimba mel, ‘Nim nʉn ik ei kapⱡa mon. Wamp korung ti, on etʉk pendʉtʉng ei, ⱡoporpa mba wu kʉⱡ mormin ila pum ndam, wu kʉⱡ ndi kandʉk, numan ropʉl ruing,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wote Eiparam ndi, wu ni, kundpa nimba mel, ‘Wamp mbʉ ndi, Moses na, painui wu mbʉ nga mi ik mbʉ, pilik pep rui narʉng ndam, wote wamp on etʉk pendʉtʉng ti, on kona ila ⱡoporpa pum ei kandʉk kʉn, mondʉk pili nʉpʉling mon, ei ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ndi, kitip kʉni wu kʉⱡ, kundpa nimba mel, “Uⱡ elpa elpa mat omba, wamp mbʉ tangga kʉn, uⱡ kit mbila mana ping. Wamp nam ti ndi, uⱡ kʉⱡ em wamp ei, mong tʉmba ei ka! ");
INSERT INTO med_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wote, wamp nam ti ndi, na nga kangambuⱡa kel ti, etpa uⱡ kit mur ila mana ndum ndam, wamp ei, ku mam ti, kan kuⱡpa nuim kan ila rumʉndpa tʉpa, num kuta ila ropa mana ndumba an. I etmba uⱡ ei nga, wamp mbʉ, en enim rʉp etʉk, kai mondʉk muⱡʉi! ");
INSERT INTO med_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ʉngʉn uⱡ kit mat, etpa moⱡum ndam, nim ndi, kundkʉn nana kʉn, tʉpa kun etpa numan ropʉl ropa tangga kʉn, nim ndi, uⱡ kit mbʉ wak rundi! ");
INSERT INTO med_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wote, ʉngʉn wamp ei, nim kʉn uⱡ kit 7 ant tenda ila em ndam, ʉngʉn nim kʉn yant omba 7 ila tangga kʉn, elim nga uⱡ kit em mbʉ, kont kuⱡpa tangga! Nim ndi, uⱡ kit em nit mbʉ, wak rundi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nombuⱡa rung wu nimbʉ, Jisas kundʉk nʉk mel, “Nim ndi, tʉn nga mondpa pili uⱡ ei, etkʉn ou indʉn ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wote Jisas ndi, nombuⱡa rung wu ni kʉⱡ, kundpa nimba mel, “Enim nga mondpa pili ei, nde mastat mong kel mel, kapⱡa em ndam, nde kʉⱡ kundʉk, puⱡ pʉkʉ rʉnggʉⱡa, rokʉn pukʉn, num kuta ila ʉnggʉli! Nangina, wote enim nga nʉng ik ei mel, ‘Nde kʉⱡ kapⱡa, pep romba!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wote Jisas ndi, nimba mel, “Wu ti ndi, elim nga kongun wu ti, tʉpa mundangga mba, kongun kona ila mʉi apʉp romba, muna mba, kng sipsip rʉp etpa andpa, mang kona om ei kʉn, elim nga wu nuim ei ndi, nimba mel, ‘Nim tʉkʉrkʉn okʉn, ila molkʉn, rʉng nui!’ nimba ei? Ei mon! ");
INSERT INTO med_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wu nuim ei ndi, kongun wu ei, kundpa nimba mel, ‘Na nga rʉng mbʉ tʉkʉn kun endkʉn, nim nga kan mum ei, tʉk gi tʉkʉn ralkʉn, na nga rʉng mbʉ, ro rokʉn, mek okʉn ngana, na unt rʉng na, nu na mbʉ neimp. Wote, nim nu na, rʉng na mbʉ nʉn.’ ");
INSERT INTO med_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wu nuim ei ndi, elim nga kongun wu elim nitim uⱡ kʉⱡ, pep ropa itim ei nga, wu nuim ei, angge ni nʉndʉtʉm, mon. ");
INSERT INTO med_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Uⱡ to ei mel ku, Got ndi, enim uⱡ mat iteing nimba ngum ndam, kongun mbʉ etʉk, pora ndukʉn, nʉk mel, ‘Tʉn kongun wamp kit kʉⱡ nʉi! Tʉn uⱡ enmin mbʉ, kindmant kongun mint etʉp mormin, nʉi!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wote Jisas ni, Jerusalem nombuⱡa mam nila mba, pilpa purum. Mba Galili kʉn, Sameriya kona raⱡ nga rʉk ting ila purum. ");
INSERT INTO med_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Jisas ni omba, kona tila oⱡnga kʉn, kint pombuⱡma wu 10 kat ndi, Jisas urum nombuⱡa mam nila ok, kandʉk tʉtʉng. Wu ni kʉⱡ ok, ruⱡ etʉk anggilik, Jisas ni, ronduⱡ wi rok nʉk mel, “Wu Nuim ye! Nim ndi, tʉn kont kun ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wote Jisas ndi, wu ni kʉⱡ, kandpa kʉn, kundpa nimba mel, “Enim nga kʉng mbʉ, mek puk, wu pris kʉⱡ, ora ndui!” nitim. Ni kʉn, mbin nʉk, nombuⱡa ruk ting ila puⱡnga, wu ni kʉⱡ nga kʉng mbʉ kai elinga, kelik purung. ");
INSERT INTO med_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wote, wu 10 kʉⱡ nga tenda ti ndi, elim nga kʉng kʉⱡ kʉndrʉm mel, kʉng kʉⱡ kai murum ila, kelpa yant omba, wi ronduⱡ mundpa ropa, Got nga mbi paka rʉndrʉm. ");
INSERT INTO med_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wote, wu ni mba, Jisas ʉnggʉtʉm kona nila, mura ropa mondpa rumʉⱡi pepa, Jisas nga kʉmp puⱡ ila mba pitim. Wu ei, Sameriya kona ila urum. ");
INSERT INTO med_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wote Jisas ndi, wu ni, kundpa nimba mel, “Wu 10 kʉⱡ nga kui ei, kapⱡa em nʉmp pint ni ka! Wote, akup wu 9 kʉⱡ, nʉl mormʉn? ");
INSERT INTO med_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wu mat yant ok, Got nga mbi paka runding ui nawʉng ei ka! Kona elpa ila wu tenda ei mint, yant om kant ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas ndi, wu ni, kundpa nimba mel, “Nim nga mondpa pili uⱡ ei ndi, ninim etpa, kapⱡa endnim. Nim oⱡa anggilkʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wote, Perisi wu nimbʉ ndi, Jisas waldʉk, nʉk mel, “Got nga wamp tʉpa mumuk rui uⱡ ei, nant kʉn omba nda?” nʉtʉng. Jisas ndi, ik nʉtʉng ni, punt ropa nimba mel, “Got nga wamp tʉpa mumuk rui uⱡ ei, wamp na ni mel ti wangga, enim mong raⱡ ndi, kʉni nʉkʉning mon. ");
INSERT INTO med_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wamp ti ndi, nimba mel, ‘Got nga wamp tʉpa mumuk rui uⱡ ei, noi ila tetʉm, muna ya ila morum,’ ni nʉning mon. Nambuⱡ emel, Got nga wamp tʉpa mumuk rui uⱡ ei, enim kʉn ya rʉk ila omba, tepa pora ndurum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Wote, ui ti ekit om ei kʉn, Muⱡʉl Wu Kupa ei nga ui ei, kʉnmin nʉk, numan minal ngʉk muⱡing. Wote enim ndi, ui ei kʉni nʉkʉning. ");
INSERT INTO med_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wote, wamp mat ndi, enim kundʉk, nʉk mel, ‘Wu ei noi ila morum, muna ya ila morum.’ I nʉng ndam, wote wamp mbʉ nga nʉng ik ei, enim pep rok, pi nʉpʉi mon! ");
INSERT INTO med_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Enim kandʉk pʉtmʉn ni ka! Kona kiraipa etʉm ei kʉn, oⱡa muⱡ ei pora rʉⱡang purum ni ka! Uⱡ ni mel ku, Muⱡʉl Wu Kupa ei, om ei kʉn, wamp mbʉ pora, kandʉk pilik iting. ");
INSERT INTO med_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wote Muⱡʉl Wu Kupa ei, unt mindil nomba, mbun koma ropa etmba. Akup ui nga wamp mbʉ ndi, wu ei tʉk mbuⱡ nguing. ");
INSERT INTO med_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Unt wamp mbʉ molk, wu Nowa murum ei kʉn, etʉng uⱡ ei mel ku, akup Muⱡʉl Wu Kupa omba, ei nga, wamp mbʉ ndi, uⱡ ei mel ku iting. ");
INSERT INTO med_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Unt wamp mbʉ, rʉng nok, nu nok, kang amp tʉndʉk etʉk moⱡina, Nowa omba, okak manga ila mukʉr purum. Mʉi ila nu oⱡa omba, wamp mbʉ, ropa nu wʉnggʉrʉm. ");
INSERT INTO med_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Wote akil tepa, Lot murum ei kʉn, wamp mbʉ molk, uⱡ mbo tenda ei mel ku etʉng. Rʉng nok, nu nok, mel mbʉ rarʉp rok, int yant tʉk, pana kongun etʉk, manga rakʉk etʉk moⱡina, Lot ni, Sorum kona ila wak ropa puⱡnga, ant tenda ila, ku kundi na, ndip na mbʉ ndi, wi muⱡ ila kona ndamʉng mel mana omba, wamp mbʉ ndip ndi, nomba pora ndurum. ");
INSERT INTO med_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Muⱡʉl Wu Kupa ei ndi, yant omba ei kʉn, unt uⱡ itim ei mel ku, wote uⱡ i iting. ");
INSERT INTO med_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ant tenda ei kʉn, wu ti mba, manga im oⱡa orunga moⱡpa kʉn, elim nga mel mbʉ, manga mukʉr tem ndam, wote murʉk mba, kapⱡa ti natʉmba. Uⱡ ei mel ku, wamp ti pana kongun kona ila mba, moⱡum ndam, wote mang kona yant ui nawʉmba. ");
INSERT INTO med_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot ambʉm ndi, elim nga mel mbʉ nga tʉpa pendpa yant ndupa kʉndrʉm uⱡ ei, akup enim numan tʉk mundʉk pilʉi! ");
INSERT INTO med_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wote, wamp nam ti ndi, elim nga kʉng orunga mint, nimba pilim ndam, kont mba mul uⱡ ei wak romba. Wote, wamp nam ti ndi, na nga nimbʉ pilpa, elim nga kʉng orunga, pili napilim ndam, wamp ei, kont mba mul uⱡ ei, kapⱡa tʉmba. ");
INSERT INTO med_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na ndi, enim kundʉp nʉnt an! Rumbuldi wamp raⱡ manga rat pol tenda ila ur piyanggila kʉn, wamp ti, tʉpa mepa mba kʉn, wamp ti, wak romba. ");
INSERT INTO med_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Wote amp raⱡ, oka pek rokʉⱡ muⱡanggila kʉn, amp ti, tʉpa mepa mba kʉn, amp ti, wak romba. Wote wu raⱡ, kongun kona ila etkʉⱡ muⱡanggila kʉn, wu ti tʉpa mepa mba kʉn, wu ti wak romba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wote, kitip kʉni wu ni kʉⱡ ndi, Jisas ni, waldʉk nʉk mel, “Wu Nuim ye! Nim nʉn uⱡ kʉⱡ, kona nant ila omba?” nʉtʉng. Jisas ndi, yant ndupa, punt ropa nimba mel, “Kui ti koⱡpa purpa, tetʉm kona ila, kʉi tap mbʉ ok, num petmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ndi, ik ek ropa, kitip kʉni wu ni kʉⱡ kundpa, wamp mbʉ rʉk rʉk atinga reing nimba, mbo inditim. Wote wamp mbʉ, enʉmp kuⱡi nʉⱡʉi nitim. ");
INSERT INTO med_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jisas ndi, nimba mel, “Wu Jas ti, kona peng tila murum ei, Got nga mundmong indi nandpa, wote wamp mbʉ nga nimba numan tʉpa mundi namʉndpa itim. ");
INSERT INTO med_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amp wiya ti, kona peng ila murum. Amp ei, rʉk rʉk wu jas ei, murum kona nila omba, wu jas ei, kundpa nimba mel, ‘Na nga el puⱡa wu ei, na etpa kit mondʉmba enim. Nim ndi, na tʉkʉn rʉpʉndʉn nʉmp ont,’” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Unt, wu jas ei ndi, amp ei, tʉp rʉpʉndi nʉpʉndimp nimba pitim. Wote akʉk tʉpa, wu jas ei, pitim mel, “Na Got kʉn mundmong iti natʉnt ku, wamp mbʉ nga numan tʉp mundi namʉndʉnt ku ei ka! ");
INSERT INTO med_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Wote amp ei, (wam wu ei kurum,) rʉk rʉk na mbun ngumba pʉnt ei, kuimp tep tʉp rʉpʉndamp. Wote rʉk rʉk, na munt ila mint wangga kʉn, elim nga ik ei, na pilip enʉmp kuⱡimp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wu Nuim ei ndi, nimba mel, “Enim wu jas kit ei, na ik ei, kum tek pilʉi! ");
INSERT INTO med_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Akup, Got nga wamp mak ropa, elim titim kʉⱡ, rumbuldi rʉngmʉ raⱡ, Got elim kʉn, ka eng ndam, Got ndi, wamp mbʉ, tʉpa rʉpʉndi napʉndʉmba ye! Wote Got ndi, wengʉndupa wamp mbʉ, tʉpa rapʉndʉmba ei? Ei mon! ");
INSERT INTO med_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na ndi, enim kundʉp nʉnt. Got ndi, enim tʉkrʉpa mint tʉpa rapʉndʉmba. Wote Muⱡʉl Wu Kupa om ei kanʉmba, mʉi kona ila wamp mbʉ, mondʉk pilik mormin, muna mon nda, uⱡ ei kanʉmba?” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Wamp mat ndi, en enim wamp kun kai mbʉ nʉk kʉn, wamp mat kit nʉk pʉtmʉn. Uⱡ ei nga Jisas ndi, ik ek kat ropa, wamp mbʉ nimba mel, “Wu raⱡ manga wingti ila atinga ruinggil, pilkʉⱡ purʉnggil. Wu ti, ku moni takis titim. Wu ti, Perisi wu ei kʉn purʉnggil. ");
INSERT INTO med_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Perisi wu ni, manga wingti ila mukʉr omba anggilpa, numan ila atinga ropa, nimba mel, ‘Na wu mat kʉn kapⱡa mon. Uⱡ ei nga, Got nim kʉn angge nʉnt. Wu mat kindʉp nok, uⱡ kit mbʉ etʉk, wapra rok etmin. Na uⱡ mbʉ, iti natʉt. Ku takis tʉtʉm wu ei mel, na mon. ");
INSERT INTO med_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kor ou mbila pora, ant raⱡ to rop pendʉp kʉn, rʉng mowi mor. Na ndi, mel mbʉ kandʉp tʉp kʉn, rʉk ila kʉmp tʉp 10 mel, Got nim ngur,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wote, ku takis tʉtʉm wu ni, manga wingti ila mukʉr omba, ruⱡ etpa anggilpa, mʉi kandpa moⱡpa, pepil ombil ila ⱡurwa ropa nimba mel, ‘Got ye! Na uⱡ kit mbʉ nga puⱡ wu ei ka! Nim ndi, na kont kuⱡi!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, “Ku takis titim wu ei, atinga ropa pora ndupa, mang kona purum ei, Got nga kuimp keta ila wu kun ei murum. Perisi wu nga mbi kit murum. Uⱡ ei nambuⱡ emel, wamp mat ndi, en enim nga mbi paka rondung ndam, wamp mbʉ Got ndi, ropa mana ndumba. Wamp mat ndi, en enim nga kʉng orunga, mana nduk moⱡʉng ndam, wamp ei nga mbi Got ndi, paka rondʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wamp mat ndi, en enim nga kangambuⱡa nana mbʉ mek, Jisas murum kona nila orung. Wote kangambuⱡa mbʉ, Jisas ndi, ki oⱡa ndupa, peng mbila ambʉⱡangga, nʉk pilik mek orung. Wote, kitip kʉni wu kʉⱡ ndi, wamp mbʉ uⱡ i etʉk orung, ni kandʉk, wamp mbʉ, ik mura ngurung. ");
INSERT INTO med_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wote Jisas ndi, kangambuⱡa mbʉ wi ropa, elim mor ila nondpa, wʉi nimba kʉn, elim nga kitip kʉni wu kʉⱡ, kundpa nimba mel, “Enim ndi, kangambuⱡa mbʉ, wak rangina, ya na mor ila weing, imp muⱡi nʉmbʉⱡʉi! Got nga wamp tʉpa mumuk rui uⱡ ei, ya kangambuⱡa kel mbʉ mel, numan pilʉng uⱡ ei kapⱡa,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wote Jisas ndi, nimba mel, “Na ik kupa kat enim kundʉp nʉnt an. Wamp nam ti ndi, Got nga wamp tʉpa mumuk rui uⱡ ei, kangambuⱡa kel mel ralk molk, ti natʉng ndam, wamp ei, Got nga wamp tʉpa mumuk rui kona ila, rukʉr kapⱡa pi napʉmba, mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wote, Jura wu mel pi ti ndi, Jisas waldpa, nimba mel, “Ik mbo wu kai ye! Na ndi, nambuⱡ etʉp moⱡʉp, uⱡ nga kʉnt nga kont mba mul uⱡ ei, kandʉp timp nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas ndi, wu mel pi ni, kundpa nimba mel, “Nambuⱡ emel, na wu kai nʉn? Got tenda ei mint, kai morum. ");
INSERT INTO med_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nim Moses nga mi ik kʉⱡ, pilkʉn pora ndurun ni ka! Wu ti nga amp ei kʉn, wapra rui uⱡ ei mon. Wamp ti rok kundi uⱡ ei mon. Kindʉp nui uⱡ ei mon. Ik kol rui uⱡ ei mon. Tipanʉm manʉm raⱡ tʉkʉn, ou ndukʉn, ik nʉnggil ei, pilkʉn pep rokʉn iti!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wote, wu mel pi ni ndi, nimba mel, “Na kel kʉn moⱡʉp ur ui ei, on akup ya mor ei kʉn, mi ik mbʉ pora, na pep rop ket,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wu mel pi ni nga ik nitim kʉⱡ, Jisas pilpa kʉn, wu mel pi ni, kundpa nimba mel, “Nim mel tenda ti nga mon ndurum ei ka! Nim nga mel tekʉn morʉn mbʉ, wamp mat kʉn, mel rarʉp rokʉn, ku moni yant tin mbʉ ndi, wamp kurpa mbʉ, kʉmp tʉkʉn ngui! Nim uⱡ i in ei ndi, wi muⱡ kona ila, nim wu nuim muⱡin. Uⱡ i etkʉn kʉni, wote nim ndi, na punt mel kandkʉn, pep rokʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jisas nga nitim ik kʉⱡ, wu mel pi ni pilpa, numan orunga mbun titim. Uⱡ ei, nambuⱡ emel, wu ei kng mel ou ndupa tepa murum ei nga pitim. ");
INSERT INTO med_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas ndi, wu mel pi ni, mbun titim uⱡ ni, kandpa kʉn, nimba mel, “Wamp nam ti, mel puⱡi tepa moⱡum ndam, Got nga wamp tʉpa mumuk rui uⱡ ila rukʉr mba, uⱡ ei nga mbun etpa tetʉm. ");
INSERT INTO med_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kng kamel ei, gal ruri nombuⱡa ila rukʉr mba, uⱡ ei kapⱡa mba. Wamp tʉpa mumuk rui uⱡ ila kng mel mbʉ, tepa moⱡum wamp ei, mindil nomba rukʉr mba.” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jisas ndi, ik nitim kʉⱡ, wamp mbʉ ndi pilik molk, nʉk mel. “Wote, ei mel ndam, Got ndi, wamp nam mel ti, etpa tʉmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wote Jisas ndi, nimba mel, “Wamp ndi, iti nʉtʉng uⱡ mbʉ, Got ndi, kapⱡa etmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wote Pita ndi, Jisas kundpa, nimba mel, “Tʉn nga mʉi mang kona na, mel na mbʉ wak ropʉn, nim pep rop ʉmʉn ei, tʉn namba mel ei timin nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jisas ndi, kitip kʉni wu kʉⱡ kundpa, nimba mel, “Na ndi, enim ik kupa ti, kundʉp nʉnt, wamp mat ndi, Got nga wamp tʉpa mumuk rui uⱡ ei nga pilik kʉn, en enim nga amp kangambuⱡa na, mang kona mel mbʉ kʉn, tipamʉl mamʉl wamp na, ʉngʉnʉl kimʉnʉl mbʉ pora, wak rong ndam, Got ndi, wamp kʉⱡ, ya mormin ui ei kʉn, mel ou ndupa ngumba. Unt mʉi kona ila molk, kng mel kandʉk tʉtmʉn mbʉ, mel mon. Wote, ui mam ei kʉn, wamp rʉk rʉk kont mba mul uⱡ ei ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wote Jisas ndi, elim nga kitip kʉni wu 12 ni kʉⱡ, tʉpa mepa puⱡnga, kona waka tila moⱡina kʉn, wu kʉⱡ kundpa, nimba mel, “Enim pilʉi! Akup tʉn Jerusalem kona peng ou ila mbin. Ila painui wu mbʉ ndi, unt ik pai nok nʉk, rok pendʉtʉng ik ni kʉⱡ, akup Muⱡʉl Wu Kupa ei kʉn, omba kupa etmba. ");
INSERT INTO med_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Muⱡʉl Wu Kupa ei, wu mat ndi, mek puk, mbo wu rʉⱡaip kat ngangina kʉn, wu mbʉ ndi, Muⱡʉl Wu Kupa ei, ik raka rondʉk, nʉk kit mondʉk, kuimp kulwa ila ol rok, kan puⱡa rok, rok kunding. Wote, rumbʉⱡ raldika omba pangga kʉn, ⱡoporpa, wote kont moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wote, kitip kʉni wu ni kʉⱡ, Jisas ik nitim ei nga puⱡ ti, ama pilik kun iti natʉtʉng. Ei nambuⱡ emel, wu ni kʉⱡ nga numan orunga, piral ni nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas ni omba, Jeriko kona peng kel nila nondpa oⱡnga, nombuⱡa mam ʉldʉ ila mong ti, wu ti murum ei ndi, wamp ok purung mbʉ kʉn, mel mat mawa etpa murum. ");
INSERT INTO med_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wamp mam ti, orung ila kum tepa pilpa moⱡpa, wamp mbʉ, waldpa nimba mel, “Wamp mbʉ ye! Namba uⱡ ti enim nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wamp mbʉ ndi, mong ti wu ni, kundʉk nʉk mel, “Nasaret kona ila wu Jisas ni onum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ni kʉn, mong ti wu ni ndi, ronduⱡ ke nimba, wi ropa, nimba mel, “Jisas, Nim Depit nga kangʉm ye! Na kont kun ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wamp kuimp tek nombuⱡa mam ila orung nimbʉ ndi, mong ti wu ni, ik mura ngʉk, raka nimba muⱡangga!” nʉtʉng. Wote, mong ti wu ni, pilpa kelpa, ke ronduⱡ wi ropa nimba mel, “Nim Wu Depit nga kangʉm ye! Nim na kont kun ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Wote, Jisas omba anggilpa, wamp mbʉ kundpa, mong ti wu ei, ki ambulk mek, elim mor ila wʉi nitim. Wote, mong ti wu ni, mek nondpa oⱡina, Jisas ndi, wu ni, waldpa nimba mel, “Na ndi, nim namba uⱡ ti indeimp nʉkʉn nʉn ei?” nitim. Wote mong ti wu ni ndi, Jisas kundpa, nimba mel, “Wu Nuim ye! Na nga mong ei, piral nangga, wamp kʉnimp pilip nʉnt ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wote Jisas ndi, mong ti wu ni, kundpa nimba mel, “Ei kani! Nim nga mondpa pili uⱡ ei ndi, ninim nga mong raⱡ, etpa piral ndonum!” nitim. ");
INSERT INTO med_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ni kʉn, tʉngʉnda mint, wu ni nga mong ni, piral nilinga, wamp kʉndrʉm. Wote ei kʉn, Got nga mbi paka rondpa, Jisas purum ila akil titim. Wamp minal morung nimbʉ ndi, uⱡ ei kandʉk, Got nga mbi ei, paka rondrung ku. ");
INSERT INTO med_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Wote Jisas ni, Jeriko nila rukʉr omba, wote ronggʉt ekit mba, pilpa purum. ");
INSERT INTO med_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wote, kona peng ila ku takis tʉtmʉn wu mbʉ nga wu kuimbal ei, mbi tek, Sakiyas nʉtmʉn. Wu ei, kng mel mbʉ nga kapⱡa etʉm wu ni, ila murum. ");
INSERT INTO med_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wote, wu ei ndi, Jisas ei, wu nam ti nda, nʉmp kʉnimp nimba itim ni, wote kʉni nʉkʉndrʉm. Ei nambuⱡ emel, elim wu etʉmp ei nga, wamp minal morung mbʉ ndi, Jisas rok ngʉk morung. ");
INSERT INTO med_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ei kʉn, kanmba pilpa rundpa kʉn, Jisas wote omba mba, nombuⱡa mam nila, tʉkrʉpa kuimp tepa mba, nde Sikamor ila oⱡa mba, Jisas kʉnimp nimba murum. ");
INSERT INTO med_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wote Jisas ni, int kona nila mba kʉn, tʉpa oⱡa ndupa, Sakiyas kandpa, nimba mel, “Sakiyas, nim tʉkʉrkʉn mana wana! Akup na, nim nga mang kona ila mbuⱡ muⱡʉmbil,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wote, wu Sakiyas ni, tʉkrʉpa mana omba, Jisas ni, rawe etpa, numan mam ti ngumba, tʉpa mepa purum. ");
INSERT INTO med_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wote, wamp ila morung nimbʉ ndi, uⱡ itim ni kandʉk, popʉⱡ kulk, kon kon nʉk mel, “Ya wu ei, uⱡ kit etʉm wu ni nga manga ila, manga tʉma punum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wote, wu Sakiyas ni, oⱡa anggilpa, Nuim ei kundpa, nimba mel, “Nuim ei, nim pʉn ye! Akup ant ila mint, na nga kng mel tep mor mbʉ, rʉk ila kʉmp tʉp wamp kurpa mbʉ nguimp. Wote, wamp mat, tʉp kum ngui randʉp, mel mat, kol rop nʉmp tit mbʉ, wamp mbʉ, punt rop int ndup, tʉmbʉkak mel indimp,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas ndi, int ndupa wu ni, kundpa nimba mel, “Got nga wamp etpa ti uⱡ ni, ya manga ila akup om. Ei nambuⱡ emel, ya wu ei, unt wu Eiparam nga mondpa pilpa uⱡ itim ei mel ku enim. Wu ei, Eiparam nga pundʉn kupa ei. ");
INSERT INTO med_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Muⱡʉl Wu Kupa ei, nombuⱡa tiki purmin wamp mbʉ, kurʉp kandʉp etʉp, rukʉr timp nimba, mana urum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wote wamp nimbʉ, ya ik kʉⱡ pilik moⱡina, Jisas ndi, ik ek kat, aldpa rurum ku. Ei nambuⱡ emel, Jisas Jerusalem kona ila nondpa urum. Ei nga wote, wamp mbʉ ndi pilik, Got nga wamp tʉpa mumuk rui uⱡ ni, akup ila tʉngʉnda mint ekit omba, enim nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ei kʉn, Jisas ndi, nimba mel, “Tʉnggʉt kʉn, wu nuim ti, mʉi kʉmp ronggʉt mba, elim ni etʉk, wu king mundangina, wote yant omp, elim nga mʉi mang kona ila king muⱡimp nimba purum. ");
INSERT INTO med_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ei nga, mba etpa kʉn, elim nga kindmant wu 10 kat, wi ropa tʉpa, ku moni K200 nimba elpa elpa ngumba kʉn, kundpa nimba mel, “Ya ku moni kʉⱡ ndi, kongun etʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ei kʉn, elim nga, mʉi puⱡ wamp nimbʉ ndi, elim numan ngui nganggʉk, nombuⱡa rung wu kat, akil tek tʉk mundʉk, nʉk mel “Wu ei, tʉn nga wu king muⱡi nʉmbʉⱡangga mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ni wote, wu ni, etʉk wu king monduⱡina, wote yant urum. Omba moⱡpa kʉn, elim nga kindmant wu nimbʉ, elim nga ku moni ngurum nimbʉ nga kongun etʉk, mat pendʉk kandʉk tʉtʉng, muna mon nda, nimba kʉnimp nimba orung. ");
INSERT INTO med_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wu kuimp tepa ni ndi, omba nimba mel, “Nuim ye! Nim na ku moni ngurum ni kʉⱡ ndi, kongun etʉp ku K2000 pendʉp ngʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Elim nga wu king ni ndi, int ndupa, nimba mel, “Na nga kindmant wu kai ei, nim mel kel mbʉ nga rup etkʉn, kai mundʉn. Ei nga, akup ya kona peng 10 kat nim rʉp itʉn!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wote, wu merʉng orunga ni ndi omba, nimba mel, “Wu Nuim ye! Nim nga ku moni ni kʉⱡ ndi, kongun etʉp ku moni K1000 kat pendʉp ngont,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wote, elim nga wu ou ni ndi, punt ropa nimba mel, “Nim ya kona peng 5 kat rʉp iti!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wote, kindmant wu ti ndi omba, nimba mel, “Wu nuim ye! Nim nga ku moni ni kʉⱡ na ndi, mep mbʉ muⱡ mbal ila kom rop tit tetʉm. ");
INSERT INTO med_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na nim nga mundmong indʉt. Ei nambuⱡ emel, nim wu pundma rorun ei nga. Nim mel rukʉr ndukʉn, ti natʉtʉn mel mbʉ kʉn, polkʉn tetʉn omba, nim mel rʉⱡi narʉrʉn mbʉ, akʉkʉn tʉkʉn, etʉn ni nga pilip it,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Elim nga wu nuim ni ndi, punt ropa, nimba mel, “Nim nga ik mong nʉn kʉⱡ ndi, ninim kʉmp timp, nim kindmant wu kit ye! Nim pʉtʉn ei, na wu pundma rop, mel na rukʉr ndup, ti natʉt mbʉ, ekit tʉp omba, wote mel na rʉⱡi narʉr mbʉ, akup tʉp et, nim pʉtʉn ei ka! ");
INSERT INTO med_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wote, nambuⱡ emel, na nga ku moni kʉⱡ nim ndi, mek pukʉn, ku moni manga ila ti nʉtʉn? Telina ndam, wote na nanim yant omp ku moni mbuⱡ ila, mat pendʉp tilmba ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wote, wamp mat anggilik morung nimbʉ, kundpa nimba mel, “Ya wu ei nga ku moni mbʉ, tʉk mek puk, ku K2000 pendpa ngum wu ni, ngʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wote, wamp nimbʉ ndi, nʉk mel, “Wu nuim ye! Wu ei, ku moni K2000 unt tepa moⱡum ni ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wote Jisas ndi, wamp morung nimbʉ, kundpa nimba mel, “Wamp ti mel mat tepa moⱡum ndam, na ndi, wamp ei, mel mat ou ndup nguimp. Wote wamp ti, mel mat tepa muⱡi nambʉⱡʉm ndam, mel on nga etpa tepa moⱡum mbʉ, nanʉm rukʉr timp. ");
INSERT INTO med_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wote, na nga el puⱡa wamp mbʉ ndi, na en enim nga wu king muⱡi nʉmbʉⱡeimp nʉk pʉtʉng wamp mbʉ, enim ndi, tʉk mek ok, na nga kuimp keta ila rok kundʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ni, ik nimba pora ndupa kʉn, wote omba kuimp tepa, Jerusalem nombuⱡa mam nila, pep ropa oⱡa purum. ");
INSERT INTO med_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Wote omba, Betpeis kʉn, Betani kona raⱡ nga Olip Komnga ila nondpa omba kʉn, elim nga kitip kʉni wu raⱡ tʉpa, kuimp tepa mundpa, nimba mel, “Enmbil pukʉⱡ, kona ila nga kʉnanggila kʉn, kng donggi pela ti, mbuⱡ ila molk ʉndi nandʉrmin ti, kan kulk pinding ei, ei kan potʉkʉⱡ mekʉⱡ ya wʉl! ");
INSERT INTO med_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kan pʉtanggila kʉn, wamp mat ndi, enmbil waldʉng ndam, enmbil ndi, int ndukʉⱡ, nʉkʉⱡ mel, ‘Wu Nuim ei ndi, kongun mat itimp nilinga, ombʉⱡ tin mbʉⱡ nʉl,’” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wote, wu ni raⱡ pukʉⱡ kandrʉnggil mel, Jisas ndi, nitim uⱡ ni mel itim. ");
INSERT INTO med_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wu ni raⱡ pukʉⱡ, kng donggi ni, kan potʉkʉⱡ moⱡʉnggila kʉn, kng puⱡ wu ni ndi, wu raⱡ, waldpa nimba mel, “Kng donggi ei, nambuⱡ emel, kan potʉnmbil?” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wu raⱡ ndi, int ndukʉⱡ, nʉkʉⱡ mel, “Wu Nuim ei, kongun mat itimp nilinga, ombuⱡ tʉnmbʉⱡ,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kng donggi ni, mek okʉⱡ Jisas ngukʉⱡ kʉn, en enmbilinga wal pʉki mbʉ, potʉkʉⱡ kng donggi mbuⱡ ila tekʉⱡ kʉn, wote Jisas ni, tʉkʉⱡ kng donggi mbuⱡ ila mondrʉnggil. ");
INSERT INTO med_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wote Jisas ni, kng donggi mbuⱡ ila moⱡpa, oⱡnga kʉn, wamp mbʉ ndi, Jisas ni, tʉk Wu Nuim mondʉk, en enim nga wal pʉki mbʉ, potʉk nombuⱡa mam ila kumbʉlʉk tetʉng. ");
INSERT INTO med_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wote Jisas ni, Olip Komnga ei nga nombuⱡa tepa mana ndurum kona nila oⱡnga kʉn, kitip kʉni wamp puⱡi orung nimbʉ ndi, puⱡ mondʉk ambulk palk, Got nga mbi ronduⱡ paka rondrung. Ei nambuⱡ emel, uⱡ rʉpʉndi minal itim kandrʉng ei nga etʉng. ");
INSERT INTO med_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wu Nuim ei nga mbi ila om wu king ei, Got ndi memp pindangga! Muⱡ kona ila moⱡpa kundi uⱡ mbʉ, kupʉn mba tiyangga. Wote, Got nga mbi ou ei, tepa mint pangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ni kʉn, Perisi wu mat ndi, wamp morung nimbila, anggilik molk, Jisas kundʉk nʉk mel, “Ik mbo wu ye! Nim nga kitip kʉni wamp mbʉ, raka nʉk muⱡeing nin ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas ndi, punt ropa, nimba mel, “Na enim kundʉp nʉnt. Wamp mbʉ, raka nʉk moⱡʉng ndam, wote ya ku mbʉ ndi, kapⱡa ke nʉk, na nga mbi paka runding mint,” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wote Jisas ni, Jerusalem nondpa omba kʉn, kona peng ou ni kandpa, kont kuⱡpa ka itim. ");
INSERT INTO med_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Wote Jisas ndi, nimba mel, “Omba nim ndi, ya akup ant ila, moⱡpa kundi uⱡ ei nga puⱡ ei, kanduⱡina ndam, kapⱡa elinga. Wote, akup nim mong ti, wamp mel kapⱡa morʉn ei ka! ");
INSERT INTO med_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wote, ui mat nim kʉn omba. Ei kʉn el rui wamp mbʉ ndi, nim nga ku paⱡa petʉm ila, mʉi mbo rok, mek oⱡa ok ni, tʉk rʉk nduk, el kilanda muⱡangina, nim ekit pukʉn itin, nombuⱡa mam ti, ama ti natʉmba. ");
INSERT INTO med_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wamp mbʉ ndi, nim kʉn nim nga ku paⱡa rukʉr mormin wamp mbʉ, pʉkʉ rok pora nduing. Ku paⱡa ei nga, na mel ni ti, ama muⱡi nambʉⱡʉmba. Ei nambuⱡ emel, Got ndi, nim etpa tʉmba urum ui ni, kandkʉn poⱡ ndui nʉndrʉn!” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Wote Jisas ni, manga wingti ou ila mukʉr mba, mukʉr kng sipsip na mel mbʉ nga rarʉp rok morung wamp mbʉ, ropa makrʉpa, pena ndupa nimba mel, “Buk Wingti ila, Got ndi, nimba mel, ‘Na nga manga ei, atinga manga! Wote enim ndi, kandʉk kelik tʉk mel rarʉp manga randʉnmin ei ka!’” nitim. ");
INSERT INTO med_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ui mbila rʉk rʉk, Jisas manga wingti ou ila moⱡpa, wamp ik mbo inditim. Ni kʉn, wu pris kuimbal morung, mi ik mbo wu na, wu nuim na mat morung nimbʉ ndi, Jisas rop kundmin nʉk pilik, nombuⱡa mat kurʉrʉng. ");
INSERT INTO med_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wote, wamp mbʉ ndi, Jisas nga ik nitim mbʉ nga ti, wak rui narʉpʉn pilmin mint nʉk pʉtʉng. Wote, wu nuim mbʉ ndi, Jisas ruing ei nga ⱡawa mat kandʉk ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wote ui ti kʉn, Jisas ndi, manga wingti ou nila, wamp mbʉ ik mbo endpa, Rʉnang lk Kai mbʉ nga ik puⱡ mbʉ, nimba ngumba murum. Ni kʉn, wu pris kuimbal mat kʉn, mi ik mbo wu na, manga wingti rʉp wu mat kunda, Jisas murum nila orung. ");
INSERT INTO med_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wote, wu mat ndi, Jisas kundʉk, nʉk mel, “Nim ronduⱡ nant ei nga, tek molkʉn uⱡ mbʉ en? Nam ndi, nim ronduⱡ ngʉⱡnga, uⱡ mbʉ en ei, tʉn kundkʉn nin ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Wote Jisas ndi, ik nʉtʉng ni, punt ropa nimba mel, “Na ndi, enim ik ti waldʉp nʉnt ei, na kundʉk nʉi! Unt Jon ndi, wamp nu tinditim uⱡ ei, Got nga muⱡ ila uⱡ ei, muna mʉi kona wamp nga uⱡ ei nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wote, wu nimbʉ ndi, en enim ik palk nʉk mel, “Tʉn ndi, Got nga muⱡ kona uⱡ ei, nimʉn ndam, wote Jisas ndi, tʉn kundpa, nimba mel, ‘Enim nambuⱡ emel, Jon nga ik ei, mondʉk pili napʉtmʉn nimba.’ ");
INSERT INTO med_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wote tʉn ndi, ‘Mʉi kona wamp nga uⱡ ti nimʉn ndam,’ wamp mbʉ ndi pora, ik ei pilik kʉn, tʉn ku ndi ruing. Nambuⱡ emel, wamp mbʉ ndi, Jon ei, painui wu ti nʉk pʉtmʉn,’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Uⱡ ei nga pilik kʉn, Jisas nga nitim ik ni, punt rok nʉk mel, “Jon wamp nu tinditim uⱡ ei, kona nant orunga kandpa titim ei, tʉn pili napʉtmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wote Jisas ndi, wu nimbʉ, kundpa nimba mel, “Enim ninmin uⱡ ei mel ku, na nga ronduⱡ tep moⱡʉp, kongun etʉp et uⱡ mbʉ, enim kundʉp ni nʉnimp mon ku!” nitim. ");
INSERT INTO med_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wote Jisas ndi, ik ek ti ropa, wamp mbʉ, kundpa nimba mel, “Wu ti ndi, nde wain pana ti raⱡpa pendpa kʉn, wu mat ndi, kongun etʉk ku moni tʉk, elim nga mat tʉndʉk, teing nimba ngumba pendpa, mang kona ila wak ropa, kona elpa tila mba, ui ruⱡ etpa murum. ");
INSERT INTO med_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wote, wain mong ranggʉk ting ui ei kʉn, elim nga wain pana ila, elim wain mong mat ranggʉk ngeing nimba kongun wu ti, tʉpa mundrum. Wote, wain pana ila morung wu nimbʉ ndi, kongun wu ni, tʉmbʉⱡ rok, pep rorung ila wu ni, kelpa wei yant urum. ");
INSERT INTO med_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wote, elim nga kongun wu ti, ku tʉpa mundrum ila urum. Wu ni, i ku etʉk rok, kit mondʉk, makrʉk mundrʉng ila, kelpa wei yant urum. ");
INSERT INTO med_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wote, elim nga kongun wu ti, ku tʉpa mundrum ila urum. Wu ni, rok kit mondʉk, tʉk ekit kundrung. ");
INSERT INTO med_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wote, wain pana puⱡ wu ni ndi, elim nimba mel, ‘Akup na nambuⱡ ti, itimp nda? Na nga kang wu numan ngur ei mint, tʉp mundamba kʉn, wu ei nga nim ik ei, tʉk ou nduk, kum tek piling nʉmp pʉnt!’ nitim. ");
INSERT INTO med_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wote, wain pana rʉp etʉng wu nimbʉ ndi, kandrʉng mel, kangʉm wu ni urum ila, en enim ik mat nʉk mel, ‘Wain pana ei, kang wu ei ndi moⱡpa, wote tʉmba uⱡ ei mon. Tʉn ndi, wu ei rop kondpʉn, wain pana ei tʉndʉn ndi, rʉp itʉmin,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","16","Wote, wu nimbʉ ndi, kang wu ni, wain pana nila rok, tʉk ekit nduk, wote rok kondrung. Wote, wain pana puⱡ wu ei ndi, wu mbʉ kʉn, namba uⱡ ti etmba nda, nimba? Jisas ndi, wamp morung mbʉ, waldpa nimba mel, “Puⱡ wu ei ndi, wain pana rʉp wu mbʉ, ropa kondpa kʉn, wote wain pana mbʉ tʉpa, wu mat elpa rʉp iteing nimba ngumba,” nitim. Wamp nimbʉ ndi, Jisas nga nitim ik ni, pilik nʉk mel, “Uⱡ ei mel kapⱡa iti natʉmba!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wote Jisas ndi, wamp nimbʉ, kandpa kʉn, nimba mel, “Enim mon nʉng ndam, wote Got nga Buk Wingti ila ik morum kʉⱡ nga puⱡ ei, etʉk ning mel nant? ‘Manga rʉki wamp mbʉ ndi, nde ti, kit nʉk, wak rok mundʉk, ketʉng nde ni ndi, akup manga ei, ambuⱡpa ronduⱡ mundpa morum,’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wote, wamp nam ti, ku pol ila tʉpa kawa ndupa, rom ndam, wamp ei, ondpa kel kel etmba. Wote ku ei ndi, mana omba wamp ti, rom ndam, wamp ei ropa, nem nem ndupa tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wote, mi ik mbo wu na, wu pris na mbʉ molk pʉtʉng mel, Jisas ndi, ik ek ropa nitim ei, en enim kundpa nitim. Nambuⱡ emel, enim pilik kʉn, Jisas tʉpʉn imp muⱡmin nʉk pʉtʉng. Ni wote, wamp mbʉ nga mundmong endʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ni kʉn, Jisas nga itim uⱡ mbʉ, tʉk kongundʉk rʉp etʉk kʉn, wu mat kandʉk tʉk, Jisas nga itim uⱡ mbʉ, tʉk mundeing nʉk tʉk mundrʉng. Wu kit mbʉ ndi, kun kai ralk molk kʉn, Jisas ik mat nimba ⱡawa tangga, imp moⱡpʉn wu gapman kuimbal ei nga, kot endangga nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wote, wu nimbʉ ndi, Jisas ni, waldʉk nʉk mel, “Ik mbo wu ye! Tʉn ndi, pʉnmʉn ei, nim ndi, wamp mbʉ ik kun kai mat mint kundkʉn ni, kun en. Wote nim ndi, wamp nuim mbʉ nga mundmong indi nandʉn, mon. Nim ndi, Got nga ik kupa petʉm mbʉ mel, wamp ik mbo endʉn. ");
INSERT INTO med_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Akup nim ndi, namba nʉkʉn pʉn? Tʉn ndi, wu nuim mumuk Sisa ku moni takis nguimin uⱡ ei, kapⱡa muna mon, nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Wote, wu mbʉ nga kol rok nʉtʉng ik ni, Jisas ndi, pilpa pora ndupa kʉn, nimba mel, “Ku moni ti na, tʉk ora ndʉi! Wamp kuimp keta ti kʉn, mbi kʉn morum ei, wamp nam nga nda?” nitim. Ni kʉn, wamp mbʉ ndi, ik punt rok, nʉk mel, “Wu nuim mumuk Sisa nga kuimp keta morum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wote Jisas ndi, wamp mbʉ, kundpa nimba mel, “Enim ndi, Sisa nga mel mbʉ kandʉk kʉn, Sisa ngʉk, wote Got nga mel mbʉ kandʉk, Got ngʉk itʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas nga punt ropa nitim ik ni ndi, wu mbʉ nga numan orunga roⱡnga, wamp morung ni kʉⱡ ndi, Jisas imp muⱡing ei nga, uⱡ ⱡawa ti kandʉk, ti natʉk kʉn, ik ti ni nandʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wote, Sarusi wu rʉⱡaip mat, Jisas murum kona nila orung. (Wu mbʉ ndi, wamp korung nimbʉ, ⱡoprʉk yant ui nʉwing, nʉtmʉn.) ");
INSERT INTO med_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wu nimbʉ ndi, Jisas waldʉk, nʉk mel, “Ik mbo wu ye! Moses nga mi ik ila ik ti, mon ropa pinditim ei ndi, nimba mel, ‘Wu ti ndi, amp tʉpa mondpa, kangambuⱡa mi naimbʉpa kuⱡangga kʉn, wote ʉngʉn wu ti ndi, amp wiya ei, tʉpa ʉngʉn nga koⱡ ila kangambuⱡa mendʉmba,’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","31","Kona tilinga, wu ʉngʉnʉl 7 kat morung. Wu komun ei ndi, amp titim. Amp ei, kangambuⱡa mi naimbʉpa, kurum. Wote, wu ʉngʉn ti ndi, amp wiya ei, tʉpa kʉn, kangambuⱡa mi naimbʉpa, kurum. Wote, wu ʉngʉn merʉng orunga ti ndi, i etpa amp ei titim. Wote, wu ʉngʉnʉl 7 kʉⱡ ndi pora, amp ei, tʉk kapⱡa endʉk kʉn, kangambuⱡa mi naimbʉk kolk pora ndurʉng. ");
INSERT INTO med_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wote, akil tepa, amp wiya ni, kurum ku. ");
INSERT INTO med_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wu 7 kʉⱡ ndi, amp ei, tʉk mek andrʉng. Ei nga wote, wamp korung mbʉ, ⱡoprʉk kont moⱡʉng ui ei kʉn, amp ei, wu nam nga moⱡmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wote Jisas ndi, wu nimbʉ, kundpa nimba mel, “Akup nga ui ila wamp kont molk kʉn, wu amp nʉk mormin. ");
INSERT INTO med_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wamp korung mbʉ nga mat, Got ndi, muⱡ kona teing nimba pitim mbʉ, wote ⱡoporpa kont mondum ei kʉn, wu amp mel rʉp rok, muⱡi nʉmbʉⱡing mon. ");
INSERT INTO med_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Got ndi, wamp on kona mbila, ropa rut ndangga kʉn, anggelo ralk, Got nga kangambuⱡa mel mbʉ muⱡing. Wote aldpa, kuⱡi nʉⱡing, mon. ");
INSERT INTO med_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wamp kui mbʉ, ⱡoprʉk kont muⱡing uⱡ ei nga, Moses ndi, tʉn kʉn nimba pora ndurum. Nde waⱡ kat ndip nurum ila, ik timan unt nga kʉⱡ nga, Moses ndi, nimba mel, ‘Wu Nuim ei, Eiparam, Aisak, Jekop na kʉⱡ nga Got ei!’ ");
INSERT INTO med_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wamp mbʉ pora, Got elim nga kuimp keta ila kont mint muⱡing. Uⱡ ei nga, Got ei, wamp kui mbʉ nga Got ti, mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Wote, Jisas nga ik nitim nimbʉ, mi ik mbo wu mat ndi, punt rok, nʉk mel, “Ik mbo wu ye! Nim ik kai mat punt ron ei ka!” nʉtʉng. Wote wu nimbʉ ndi, Jisas murum nila mundmong endʉk, ik mat waldʉk ni nandʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wote Jisas ndi, Perisi wu mbʉ, kundpa nimba mel, “Nambuⱡ emel, wamp mbʉ ndi, Got nga ngurum wu Kraist ei kundʉk, Depit kangʉm nʉtmin nda? ");
INSERT INTO med_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Buk Sam ila, Depit elim ndi, nimba mel, ‘Oⱡa Nuim ei ndi, Na nga Nuim ei kundpa, Na nga ki mbo orunga okʉn muⱡana, ");
INSERT INTO med_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Na ndi, nim nga el puⱡa wamp mbʉ, tʉp nim nga kʉmp mundin ei nga, nde pol mel indimp,’ nitim. ");
INSERT INTO med_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Depit elim ndi, Kraist nga nindpa kʉn, elim nga Wu Nuim ei nitim. Ei nambuⱡ emel, wamp mbʉ ndi, aldpa Kraist kundʉk, Depit kangʉm nʉtmin nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Wamp mbʉ ndi, Jisas ik nitim nimbʉ, pilik moⱡʉngina, Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Enim ndi, mi ik mbo wu mbʉ nga pilik, tʉk mendʉk muⱡʉi! Wu mbʉ ndi, wal pʉki roⱡ mbʉ mint, numan ngʉk pakʉk andʉk kʉn, wamp mou rok molk etmin kona mbila, en enim tʉk ou nduk, rawe etʉk, numan ning ngʉk pilik etmin. Wote, atinga manga kel mbila puk, nde pol kuimbal mbila, wamp kʉnangina mint muⱡmin nʉk pilik numan ngʉk etmin. Wote, wamp rʉng nok etmin mbila puk, nde pol kuimbal molk etmin. ");
INSERT INTO med_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wote, amp wiya mbʉ tʉk, wʉlʉ mundʉk kʉn, kng mel mbʉ kindʉp nok tʉk, atinga ruⱡ wei mat, ik kol rok rormin ku. Got nga wamp kʉmp tʉmba ui ila, wu mbʉ, mbun mindil mam mat ting,” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ui ti kʉn, manga wingti ou nila mba moⱡpa, kʉndrʉm mel, ku moni ou nduk ambʉrmin wamp nimbʉ, nde ket nila angge ku moni ngorung. ");
INSERT INTO med_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ui ni kʉn, amp wiya kurpa ti, ku kuⱡi kel raⱡ mepa omba, nde ket ila mana nduⱡnga kʉndrʉm ku. ");
INSERT INTO med_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Uⱡ ni, Jisas ndi, kandpa moⱡpa, nimba mel, “Na ndi, enim ik kupa ti kundʉp nʉnt. Amp wiya kurpa ei, ku moni ngunum ei ndi, moni minal mundʉnmʉn wamp mbʉ, tʉpa mana ndupa ngunum. ");
INSERT INTO med_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ku moni ou nduk ambʉrmin wamp mbʉ ndi, ku moni mat, mang kona tek, ku moni mat mek ok, Got kʉn angge nʉk ngʉnmʉn. Wote, amp wiya ei, elim rʉng nomba ku ti mon, tepa moⱡum ku moni waⱡum, kuraⱡ pʉi mepa omba ngunum,” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wote, wamp mat ndi, manga wingti ou ni, kandʉk nʉk mel, ku eng nui kai mat kʉn, mel kai mat, Got kʉn angge nʉk ngʉk, manga wingti ou ei, ou nduk etmin ei ka, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Wote Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Akup enim ndi, mel mbʉ, kandʉk ninmin. Wote ui ti om ei kʉn, ku ti natʉmba, mon. Wote, ku mbʉ pora, mana mba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wote, wamp nimbʉ ndi, Jisas waldʉk, nʉk mel, “Ik mbo wu ye! Nim uⱡ nʉn mbʉ, nant kʉn pemba nda? Namba uⱡ ti unt itangga, tʉn kandʉp muⱡamina kʉn, wote uⱡ nʉn mbʉ, ekit omba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wote Jisas ndi, nimba mel, “Enim pilik, tʉk mendʉk muⱡʉi! Wamp mat ndi, ik kol rok, na nga mbi tek, nʉk mel, ‘Na wu Jisas ont. Ui nimbʉ, akup nondpa pora nimba,’ enim ning. I nʉng ndam, enim ik ei, pilik pep rui nʉrʉi mon!’ ");
INSERT INTO med_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ei, enim kʉn, pilangina kʉn, el mam mat enmin nʉng ndam, enim mundmong iti nʉtʉi mon! Uⱡ mbʉ, kuimp tepa ekit omba, wote muⱡ mʉi raⱡ ui ila, tʉkrʉpa pora ni nanʉmba mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wote Jisas ndi, wamp ni kʉⱡ, kundpa nimba mel, “Wu rʉⱡaip kat ndi, wu rʉⱡaip kat kʉn el iting. Wu king ti nga rʉⱡaip kat ndi, wu king ti nga rʉⱡaip ei kʉn, el iting ku. ");
INSERT INTO med_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wote, kona kilimbʉmp mam mat etpa, kump kun mat tiyangga. Wote, kona mat ila kui mam mat, kandʉk ting ku. Wi muⱡ ila uⱡ to elpa elpa mat kandʉk, wote uⱡ elpa elpa mat ndi, tʉn etpa mundmong endʉmba ku. ");
INSERT INTO med_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Wote uⱡ mbʉ, nondpa ui nʉwangga kʉn, enim tʉk imp molk, etʉk kit munding. Wote, enim manga wingti mbila, mek mukʉr puk kot endʉk, kan ngʉk iting. Uⱡ ei, nambuⱡ emel, na nga mbi enim kʉn tetʉm ei nga kandʉk, tʉpʉn mana nduimin nʉk enim, mek wu king na, gapman na mbʉ nga kuimp keta mbila, mek ping. ");
INSERT INTO med_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Uⱡ mbʉ, ekit om ei kʉn, enim ronduⱡ mundʉk molk, Rʉnang Ik Kai mbʉ nʉk ngʉi! ");
INSERT INTO med_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wote enim ndi, namba ik mat, punt ropʉn nimin nda nʉk, numan ou nduk pili nʉpilʉi! ");
INSERT INTO med_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ui ila nanim ndi, enim nga numan ila ik kai mat ning mbʉ, mbo rʉndamba kʉn ning. Wote, enim nga el rui wamp mbʉ ndi, enim nga nʉng ik ei, tʉk roi nduk rok, mana nduk iti nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Enim nga tipamʉl mamʉl na, ʉngʉnʉl na, wamp puⱡ na, mema tenda wamp ni mbʉ ndi, enim wamp mat tʉk, el rui wamp mbʉ ngangina, enim rok kunding. ");
INSERT INTO med_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wote, wamp mat ndi, enim kʉn popʉⱡ mondʉk iting uⱡ ei, nambuⱡ emel, na nga mbi ei, enim kʉn tiyangga kandʉk iting. ");
INSERT INTO med_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wote, enim nga peng ndi tenda ti, ama mana pi napʉmba mon. ");
INSERT INTO med_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uⱡ eng ei ndi, en enim nga wamp kont mul uⱡ ei, etʉk ting, ronduⱡ mundʉk molk, en enim nga kont mba mul uⱡ etʉk, peng kont ting. ");
INSERT INTO med_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Wote, enim molk kʉnangina kʉn, el wu mat ok, Jerusalem kona peng ou ei, tʉk pok eng ndam, kona peng ei, etʉk kit munding ui ei, nondpa tangga iting. ");
INSERT INTO med_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ui ei kʉn, Juriya kona ila wamp mbʉ, nung nʉk, komnga mong mbila oⱡa ping. Wote, Jerusalem kona peng ou ila wamp mbʉ, kona peng ei, wak rok, kona mat ila ekit ping. Kona peng ei nga ekit orunga petmin wamp mbʉ, wote ok, rukʉr pi nʉping. ");
INSERT INTO med_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wamp nga uⱡ kit etmin mbʉ, ui ei kʉn, Got ndi, punt rondʉmba. Ik ei, Got nga Buk Wingti ila petʉm uⱡ ei, wote omba kupa etmba. ");
INSERT INTO med_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Akup ui ila, amp mat kangambuⱡa mondʉk mormin. Wote, amp mat kangambuⱡa aim nguk mormin mbʉ, mbun ting. Mbun mindil mam mat, mʉi kona ila pem ei kʉn, Got nga popʉⱡ ei, wamp mbʉ kʉn punt romba. ");
INSERT INTO med_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ui ei kʉn, el rui wamp mbʉ ndi, wamp mat koiya ndi rok kunding. Wote, wamp mat tʉk mek puk, mʉi kʉmp mat ila kan nguk mundangina ping. Ik nʉpʉl wamp mbʉ ndi, Jerusalem kona peng ei, rok wapra pendʉk muⱡangina, en enim nga ui ni wei pora noimba. ");
INSERT INTO med_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Uⱡ i tangga kʉn, oⱡa muⱡ ila ant, kalimp na, mipil na mbila, uⱡ elpa elpa mat itangga kʉn, mʉi kona ila pora, num kuta rʉk nangga, wamp mbʉ ndi, pilik min ngʉn mundʉk, mundmong etʉk muⱡing. ");
INSERT INTO med_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wamp mbʉ ndi, uⱡ em ei kandʉk, namba uⱡ mat enim nda nʉk, mundmong etʉk muⱡangina kʉn, mil mal tʉpa ropa mundʉmba. Wote ni kʉn, muⱡ ila mipil mbʉ roka nimba. ");
INSERT INTO med_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Uⱡ mbʉ kandʉk muⱡangina, wote Got nga kangʉm Jisas Kraist ni, kopa pol ila rʉpʉndi rʉⱡang mbʉ, tʉpa pakʉpa wangga kʉning. ");
INSERT INTO med_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wote uⱡ mbʉ, puⱡ mondpa tangga kʉn, enim wamp mbʉ ndi, anggilik molk, oⱡa nduk kandʉk muⱡangina kʉn, Got ndi, enim etpa rukʉr tʉmba ui ei, nondpa omba, pora nimba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wote Jisas ndi, ik ek ti ropa, wamp mbʉ, kundpa nimba mel, “Enim nde ui kʉⱡ kandʉk kʉn, nde mat kʉnʉi! ");
INSERT INTO med_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nde ui mʉn etʉm uⱡ ei kandʉk kʉn, akup kona ant mba enim nʉtmin. ");
INSERT INTO med_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Uⱡ ei mel ku, enim ndi, kʉnangina uⱡ mbʉ mel, pem ndam, Got nga wamp tʉpa mumuk rui uⱡ ei, nondpa omba, pora nimba ei nga etmba. ");
INSERT INTO med_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na ndi, ik kupa ti, enim kundʉp nʉnt! Akup nga ui ila mormin wamp mbʉ nga mat, kolk pora ni nʉnangina kʉn, uⱡ mbʉ mel pemba. ");
INSERT INTO med_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wote ui ei kʉn, muⱡ mʉi raⱡ pora nimba. Wote, na nga ik ei, pora ni nanʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Uⱡ ei nga, enim wamp mbʉ pilik, tʉk mendʉk muⱡʉi! Enim rʉng na, nu ronduⱡ na mbʉ, ou nduk nui nandʉk, mʉi kona mel mbʉ nga mint, numan ngui nganggʉk muⱡʉi! Wote, enim uⱡ mbʉ ndi, mana tʉm ndam, Got nga ui ei, tʉngʉnda mint ekit omba, enim kui mil mel, pira tepa romba. ");
INSERT INTO med_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mʉi kona mbila mormin wamp mbʉ pora, Got nga ui ei ndi, kandpa tʉmba. ");
INSERT INTO med_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Enim rʉk rʉk uⱡ mbʉ nga kandʉk, tʉk mendʉk, Got kʉn atinga rʉk rʉk rok, ronduⱡ tʉk itʉi! I eng uⱡ ei ndi, Muⱡʉl Wu Kupa om ei kʉn, elim nga kuimp keta ila ronduⱡ mundʉk, anggilik muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ui mbila rʉk rʉk, Jisas ndi, manga wingti ou ila wamp mbʉ, ik mbo endpa kʉn, rumbʉⱡ rurum ei kʉn, Olip Komnga ila oⱡa mba, moⱡmba purum. ");
INSERT INTO med_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wamp mbʉ ndi, mʉkʉlmʉ unt, manga wingti ou ila ok, Jisas nga ik nitim mbʉ, pilik kun etʉng. ");
INSERT INTO med_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret yis mundi namʉndʉrmin Mowi Kor ui ei, mbi tek, Pasopa rʉng normin. Ui ei nondpa mel pitim. ");
INSERT INTO med_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ni kʉn, mi ik mbo wu na, Perisi wu na mbʉ ndi, wamp mbʉ nga pilik, mundmong etʉk, nʉk mel, “Namba uⱡ ti etpʉn, Jisas imp moⱡpʉn, rop kundmin nda?” nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kitip kʉni wu 12 kʉⱡ nga wu ti nga mbi, Juras, mbi ti tek, Iskariyot nʉtʉng. Wu ni, Seitan ndi, rukʉr orunga moⱡpa, kunt kunt rurum. ");
INSERT INTO med_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Juras ni mba, wu pris kuimbal na, manga wingti ou mbila wu nuim nimbʉ kʉn, rʉk murum. Jisas tʉpa, wu kʉⱡ ngumba ei nga nombuⱡa ti kʉrʉrʉm. ");
INSERT INTO med_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wu nimbʉ, numan mam ti, Juras kʉn nguk, Juras kandʉk, ku moni na mat nguimin nʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wu ni kʉⱡ nga nʉtʉng ik ni, Juras ni, kapⱡa nimba, Juras ndi, Jisas tʉpa, wu kʉⱡ nga ki kaimp ila ngumba. Ei nga, nombuⱡa mam ti, kurpa nokundpa, moⱡpa mba, wote wamp mbʉ, Jisas kʉn rʉp rok, muⱡi nambʉⱡangina kʉn, kiyang nʉmp, Jisas tʉp nguimp nimba pitim. ");
INSERT INTO med_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mowi kor mormʉn ant ila bret yis mundi namʉndʉrmin ui ei urum. Ant ei kʉn, kng sipsip waⱡ mat rok, Pasopa rʉng nuing ei nga tʉk kun etʉng. ");
INSERT INTO med_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Wote Jisas ndi, Pita kʉn Jon raⱡ, kuimp tepa tʉpa mundpa kʉn, kundpa nimba mel, “Enmbil pukʉⱡ, Mowi Kor rumbuⱡ ila rʉng nuimin mat, tʉkʉⱡ kun itinggil pʉl!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wu raⱡ ndi, Jisas kʉn int ndukʉⱡ, waldkʉⱡ nʉkʉⱡ mel, “Tʉn nga rʉng nimin mbʉ, kona nant tila, tʉpʉⱡ kun itimbil, nʉkʉn nʉn ei?” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Jisas ndi, wu raⱡ, kundpa nimba mel, “Enmbil pukʉⱡ, Jerusalem kona peng ila panggila kʉn, wu ti, nu ming mam ti, nu kuⱡpa mepa om wu ei, pep rokʉⱡ pukʉⱡ, wu ei mba, mukʉr pum manga ila, mukʉr pukʉⱡ kʉn, manga puⱡ wu ei, waldkʉⱡ nʉkʉⱡ mel, ‘Ik mbo wu ei ndi, nim waldpa, na nga kitip kʉni wu kʉⱡ kʉn, Pasopa rʉng moⱡpʉn nimin, manga kʉkaⱡ ei nant nda?’ tʉl tʉkʉn, ora ndana kʉn, ");
INSERT INTO med_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","wu ei ndi, enmbil tʉpa ora ndumba ei, manga kʉkaⱡ oⱡa orunga ila, rʉng noⱡʉp nuimin mel mbʉ pora, tetʉm kona ila mel mbʉ, tʉkʉⱡ kun etkʉⱡ muⱡʉl!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wote, wu ni raⱡ, pukʉⱡ kandrʉnggil mel, Jisas ndi, nitim uⱡ nimbʉ mel pitim. Wote, rʉng nuing nimbʉ, tʉkʉⱡ kun etkʉⱡ morunggil. ");
INSERT INTO med_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Rʉng nuing ui ei, nondpa itim ila, Jisas na, elim nga kitip kʉni wu ni kʉⱡ kʉn kunda, rat pol nila morung. ");
INSERT INTO med_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kona ila, Jisas ndi, kitip kʉni wu kʉⱡ, kundpa nimba mel, “Na akup enim kʉn rʉp rop moⱡʉp, Pasopa nimin ei, numan enim. Wote, na mindil nuimp!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Na ndi, enim ik kupa kat kundʉp nʉnt. Na enim kʉn rup ropʉn moⱡpʉn, Pasopa rʉng ti, wote nui nʉnmʉn. Wakʉt, Got nga wamp tʉpa mumuk rui uⱡ kupa ei, ekit om ei kʉn, Pasopa rʉng ei nga puⱡ ei, mot nʉm kʉn, na kʉning,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wote Jisas ndi, nu wain ming n, tʉpa ambuⱡpa oⱡa ndupa, Got kʉn angge nimba, wote kitip kʉni wu kʉⱡ, kundpa nimba mel, “Enim ya nu ming ngʉnt ei, kʉmp tʉk nʉi! ");
INSERT INTO med_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na ndi, enim kundʉp nʉnt. Akup nga ant ila enim kʉn, ming ila nu wain nont ei manda. Wote, na nu wain enim kʉn, moⱡʉp nuimp ei, Got nga wamp tʉpa mumuk rui uⱡ ei, ekit om ei kʉn nuimin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wote Jisas ndi, bret ni tʉpa ambuⱡpa, puk ropa oⱡa ndupa, Got kʉn angge nimba, tʉpa elim nga kitip kʉni wu kʉⱡ ngumba, nimba mel, “Ya ei na nga kʉng ei, ei ndi, enim tʉpa rʉpʉndangga nʉmp ngʉnt. Enim tʉk nok molk, wote na pilik mint muⱡeing nʉmp ent,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Rʉng nok pora nduⱡmina kʉn, wote nu wain ming ni tʉpa, ambuⱡpa oⱡa ndupa, Got kʉn i ku etpa, angge nimba kʉn, kitip kʉni wu kʉⱡ ngumba, nimba mel, “Ya nu wain ming ei, na nga mema ei, enim kʉn nʉmp mʉi ruimp mema ei, oi nimba kʉn, enim tʉpa rapʉndʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Ya kʉnʉi! Na ki ambuⱡpa tʉpa, el puⱡa wu mbʉ nga ki kaimp ila ngumba wu ei, na kʉn nondpa rat pol ila morum wu ei. ");
INSERT INTO med_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wu ei nga Muⱡʉl Wu Kupa ndi, nombuⱡa mam ti unt to ropa tinditim ila pep romba. Wu ti ndi, Muⱡʉl Wu Kupa ei, tʉpa el puⱡa wu kʉⱡ nga ki kaimp ila ngum wu ei, mong mam ti tʉmba!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wote, kitip kʉni wu ni kʉⱡ ndi, en enim int yant etʉk, waldʉk nʉk mel, “Uⱡ ei, nam ti ndi, etmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wote, kitip kʉni wu kʉⱡ, en enim nga rʉk ila, puⱡ mondʉk ik palk, wu nam ti, kuimbal moⱡmba nda waldʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisas ndi, kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Wu king mat, wamp rʉⱡaip mat nga kuimbal molk, wamp mbʉ rʉp etʉk etmin wu kʉⱡ, uⱡ kai mbʉ elingina, mbi moⱡpa etʉm. ");
INSERT INTO med_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wote, enim uⱡ ei mel iti natʉnmʉn, mon ei ka! Wu nam ti, kuimbal muⱡimp nimba pilim wu ei omba, akil tiyangga! Enim nga kuimbal moⱡpa, rʉp itimp nimba pilim wu ei ndi, enim tʉpa rapundpa kindmant kongun endpa tangga! ");
INSERT INTO med_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Enim pilʉi! Nam kuimbal moⱡmba? Wu nam ti, rʉng nomba moⱡum ei, muna kindmant wu ti, rʉng kaⱡpa mepa om ei? Rʉng moⱡpa nom wu ei, kuimbal moⱡmba. Wote, na ya enim nga rʉk ting ila moⱡʉp, enim tʉp rapʉndʉp, kindmant kongun endʉp mor. ");
INSERT INTO med_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Uⱡ mat ndi, na oⱡa tʉpa kanʉmba om ndam, enim na kʉn kunda, rʉp rok muⱡing ei ka! ");
INSERT INTO med_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na nga Tipam ei ndi, Got nga wamp tʉpa mumuk rui uⱡ ei, na ngurum. Na ndi, Got nga wamp tʉpa mumuk rui uⱡ ei, akup enim nguimp. ");
INSERT INTO med_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Got nga wamp tʉpa mumuk rui kona na ndi, enim nguimp kona ila enim rat pol mbila molk, rʉng na, nu na mel mbʉ nuing. Enim rat pol kai mbila molk, wote Isrel wamp rʉⱡaip 12 kʉⱡ, kʉmp tʉk iting,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wote Jisas ndi, nimba mel, “Saimon, Saimon, nim kum tekʉn pili! Seitan ndi, enim nga mondpa pili oⱡa tʉpa, kanmba uⱡ ei, nimba pora ndum. Uⱡ ei, wit mong kʉⱡ ambulk, mʉk tʉk, elim muna kʉn, ⱡawa kʉⱡ purum ni mel, enim kʉn etmba ei ka! ");
INSERT INTO med_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Na ndi, enim nga tʉp rapʉndʉp, atinga rondʉp pora ndʉnt uⱡ ei ndi, nim nga mondpa pili ei, mana pi napʉmba. Nim wote, kelkʉn ropʉl rokʉn, na kʉn yant okʉn, nim nga ʉngʉnʉl kʉⱡ, nʉkʉn ronduⱡ mundi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita ndi, int ndupa, Jisas kundpa nimba mel, “Wu Nuim ye! Nim kan manga ila pun ndam kep, kun ndam kep, na kunda rʉp ropʉⱡ mbil mint,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas ndi, Pita ni, kundpa nimba mel, “Pita, akup rumbʉⱡ ila, kʉi kulda rui nʉri! Nim ndi, na pili napʉt nʉkʉn, raldika indin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas ndi, elim nga kitip kʉni wu kʉⱡ, kundpa nimba mel, “Na ndi, enim unt tʉp mundʉr ni kʉn, ku moni wal na, kʉmp rʉk na mel mat, mek pi naprʉng ni kʉn, enim mel mat nga mon ndurum, muna mon?” nitim. Wu kʉⱡ ndi, “Mon ndi nʉndrʉm!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Ku moni na, wal na mel mbʉ tʉk mek, kur koiya ti natʉm wu ti, elim nga wal pʉki kʉⱡ tʉpa, wamp mat kʉn, kur koiya rarʉp ropa tangga! ");
INSERT INTO med_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Uⱡ ei, nambuⱡ emel, Buk Wingti ila, Muⱡʉl Wu Kupa ei nga, nʉtʉm ni mel, ‘Wu ei, elim wamp mbʉ ndi, etʉk kit munding,’ nʉtʉm. Ni mel, na ndi, enim kundʉp nʉnt. Uⱡ kʉⱡ, na kʉn pemba. Buk Wingti ila uⱡ kat, na kʉn omba nʉtʉm kʉⱡ, akup omba kupa etmba. ");
INSERT INTO med_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kitip kʉni wu kʉⱡ ndi, Jisas kundʉk, nʉk mel, “Wu Nuim ye! Nim ya kʉni! Tʉn koiya raⱡ mint, tepʉn mormʉn,” nʉtʉng. Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Koiya raⱡ manda,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas ni, kona murum ni, wak ropa mba, wi Komnga Olip nila, atinga unt rurum uⱡ ei mel, romba purum. Elim nga kitip kʉni wu kʉⱡ, akil tek pep rok purung. ");
INSERT INTO med_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Komnga ila ruk puk kʉn, Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Enim atinga rok mint muⱡʉi! Ei nga wote, uⱡ mbun mindil mbʉ, enim kʉn ui nʉwangga!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Nimba pendpa, Jisas ndi, wu kʉⱡ, wak ropa mba, ruⱡ etpa mel, mura ropa mondpa, atinga ropa, nimba mel, “Wuta! Nim nga numan ei ndi, na nga mindil nuimp uⱡ ei, timp nin ndam, timp. Nim ndi, na nga numan ei pep rui nʉri, mon! Nim nga numan ei ndi, pin uⱡ mbʉ mel iti!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ni kʉn, muⱡ kona anggelo ti ndi omba, Jisas etpa ronduⱡ mundrum. ");
INSERT INTO med_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas ni pitim ei, mbun itim ila, atinga ronduⱡ mundpa roⱡnga, elim nga kʉng ila kur mema raⱡ nu mel, oi nitim. ");
INSERT INTO med_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wote, atinga ropa pora ndupa, oⱡa anggilpa omba, elim nga kitip kʉni wu kʉⱡ, kʉndrʉm mel, numan mbun minal tʉk, ur pek morung. ");
INSERT INTO med_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Nambuⱡ emel, enim ur mint pek mormʉn? Oⱡa molk, atinga rok mint muⱡʉi! Tʉpa kawa ndangga, uⱡ mbun pi mbʉ, enim kʉn wangga, enim mana ping,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","48","Jisas ni, ik nimba moⱡnga kʉn, wu rʉⱡaip mam ti orung. Kitip kʉni wu 12 kʉⱡ nga wu ti nga mbi, Juras nʉtmin. Wu ei ndi, wu kat nombuⱡa ora ndupa, mepa urum. Juras ni, Jisas kʉn nondpa omba, keta nu ropa nuimp nimba itim. Wote, Jisas ndi, Juras waldpa, nimba mel, “Juras, nim ndi, Muⱡʉl Wu Kupa ei, keta nu rok nokʉn, wote wu ei, tʉkʉn el puⱡa wu kʉⱡ, nguin pilkʉn en ei?” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kitip kʉni wu kʉⱡ, Jisas kʉn rʉp rok molk, kandrʉng mel, uⱡ ni kʉⱡ etʉng ila, wu ni kʉⱡ ndi, nʉk mel, “Wu Nuim ye! Tʉn koiya tep mormʉn ei ndi, wu mbʉ ramin ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","51","Kitip kʉni wu ti ndi, koiya pinditim ni, ekit tʉpa, wu pris kuimbal ei nga kongun wu ni, koiya ndi, kum mbo orunga ropa, puⱡa rurum ila mana urum. Wote Jisas ndi, uⱡ ni kandpa, nimba mel, “Uⱡ ⱡawa en ei, wak rui!” nitim. Nimba kʉn, wu ni nga kum ni, tʉpa aldpa ropa rʉmp ndupa, mundrum ila kapⱡa itim. ");
INSERT INTO med_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wote Jisas ndi, wu pris kuimbal na, manga wingti rʉp wu na, wu nuim na mbʉ, kundpa nimba mel, “Enim kur koiya na, tʉmbʉⱡ na mat, mek onmʉn mbʉ, kindʉp nomba, el ropa ik pili napilim wamp ti, imp muⱡing pilik onmʉn ei? ");
INSERT INTO med_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ui mbila rʉk rʉk, na manga wingti ou ila rukʉr mor ni, wote enim ndi, na imp muⱡi nambʉrmʉn ni ka! Akup nga ui ei, enim nga ti pʉnt. Rumbʉⱡ ei ndi, rʉⱡang ei kapⱡa, ropa mana ndumba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas ni, ik nimba pora nduⱡnga, imp molk mek puk, wu pris kuimbal kʉⱡ nga manga ila mukʉr purung. Pita ni, akil tepa mba, ruⱡ etpa murum. ");
INSERT INTO med_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wu mat, manga ei nga paⱡa rukʉr ndip kalk morung kona nila, Pita kunda rʉp rok morung. ");
INSERT INTO med_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita ni, ndip pilpa murum ila, kongun amp ti ruk omba, Pita ni, nem nʉm kandpa, amp ni ndi, nimba mel, “Wu ei, Jisas kʉn rʉp rokʉⱡ, andrʉmbil ndi ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wote Pita ndi, amp ni, kundpa nimba mel, “Jisas ni wu ei, na pili napʉt,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wote, wu ti ndi omba, Pita murum ni, kandpa mbi ndupa, nimba mel, “Wu ei, Jisas nga rʉⱡaip ila wu ei ka!” nitim. Pita ndi, int ndupa, nimba mel, “Na Jisas nga kitip kʉni wu ti mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wote moⱡnga, ant mong ti omba puⱡnga kʉn, wu ti ndi omba, Pita nem nʉm kandpa, ronduⱡ mundpa, nimba mel, “Kupa mendpʉⱡ, Jisas kʉn Galili kona ila wu raⱡ,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wote Pita ndi, int ndupa, nimba mel, “Nim nga nʉn, ik ei, na pili napʉt ik mat nʉn ei ka!” Pita ik nimba moⱡʉng mel, tʉngʉnda mint, kʉi kulda rurum. ");
INSERT INTO med_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ni kʉn, Nuim ei ndi, tʉpa ropʉl ropa, Pita kanduⱡnga mel, wote elim numan tʉpa mundpa, pitim mel, Wu Nuim ei ndi, ik kat, elim unt kundpa, nitim kʉⱡ pitim. Nimba mel, “Akup rumbʉⱡ ila, kʉi kulda rui nʉri kʉn, nim ndi, na pili napʉt nʉkʉn, raldika indin,” nitim ik kʉⱡ, Pita pitim. ");
INSERT INTO med_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wote Pita ni, mindil tʉpa, ka etpa, pena purum. ");
INSERT INTO med_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Jisas imp morung wu mbʉ nga mat ndi, Jisas nga mong raⱡ muⱡ ti ndi, kum rok pendʉk, tʉmbʉⱡ ndi rok, tʉk ik kuldʉk, waldʉk nʉk mel, “Nim wu nam ndi, ronum ei?” ʉldʉ ndukʉn, ni nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wote, wu mbʉ ndi, ik kit mat, Jisas kundʉk nʉtʉng ku. ");
INSERT INTO med_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","Mʉkʉlmʉ ant ei oⱡa oⱡnga, Jura nga pris kuimbal wu na, manga wingti rʉp wu na, mi ik mbo wu mbʉ kʉn, mou tenda ila rorung. Mou rok morung kona nila, Jisas tʉk mek, kaunsil ei nga kuimp keta ila puk, nʉk mel, “Nim ndi, tʉn kundʉk ni! Nim Got ndi, tʉpa mundpa kʉn, wamp mbʉ etkʉn, rukʉr ti nitim wu ei, muna wu elpa ti nda?” nʉtʉng. Ei mel, nilingina kʉn, Jisas ndi, punt ropa, nimba mel, “Na ndi, enim ik ei kundʉp, nint ndam, enim ndi, kapⱡa pilik poⱡ ndui nʉnding. ");
INSERT INTO med_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wote, enim nam ndi, ik kat waldʉp, nint ndam, enim ndi kapⱡa punt rui nʉring. ");
INSERT INTO med_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ei nga akup, Muⱡʉl Wu Kupa ei, kʉmp kʉm mba, Got Ronduⱡ Purum ei nga ki mbo orunga moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wu nimbʉ ndi, Jisas waldʉk, nʉk mel, “Nim Got Kangʉm ei?” nʉtʉng. Jisas ndi, wu mbʉ kundpa nimba mel, “Enim pilik nʉnmʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wu nimbʉ ndi, nʉk mel, “Namba ik ti, wu mbʉ wi ramina kʉn, ok nangina pilmin? Ya wu ei nga keta mʉn ila, ik nʉnʉm kʉⱡ, tʉn pilpʉn pora ndʉnmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wote, wu nuim nimbʉ ndi pora, Jisas mek, Pailot murum kona ila purung. ");
INSERT INTO med_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jisas ni, puⱡ mondʉk, kot endʉk, nʉk mel, “Tʉn kʉnmin ei, wu ei ndi, tʉn nga wamp mbʉ, tʉpa wʉlʉ mundpa, ‘Wu nuim mumuk Sisa, ku moni takis ngui ngʉngʉi,’ nimba, wote wu ei, el elim kundpa, nimba mel, ‘Wu Kraist wu king ei nga,’” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wote Pailot ndi, Jisas waldpa, nimba mel, “Nim Jura wamp nga wu king ei?” nitim. Wote Jisas ndi, punt ropa, nimba mel, “Nim nʉn ei kupa,” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailot ndi, wu pris kuimbal na, wamp mbʉ kundpa, nimba mel, “Wu ei nga uⱡ ⱡawa ti, kandʉp ti natʉnt mon, ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wamp mbʉ ndi, ronduⱡ ke, nʉk mel, “Wu ei ndi, Jura kona peng na, Galili kona peng na mbila andpa, wamp mbʉ, ik mbo endpa, ropa gi ndupa etʉm. Wote, akup ya ila om,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailot ndi, wamp mbʉ nga nʉtʉng ik mbʉ, pilpa moⱡpa, wamp mbʉ waldpa, nimba mel, “Wu ei, Galili ila wu ei nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailot ndi pilpa mel, Jisas ni wu ei, Erot nga rʉp itim kona ila moⱡpa, om nimba pitim. Ui ei kʉn, Erot ni, Jerusalem kona ila murum ku. Pailot ei ndi, Jisas tʉpa, Erot murum kona nila mundrum. ");
INSERT INTO med_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erot ndi, Jisas urum ni kandpa, numan mam ti ngurum. Jisas nga timan ik ei pitim, wote Jisas kʉni nʉkʉndrʉm eing, uⱡ rʉpʉndi mat itangga, Erot kʉnimp nimba murum. ");
INSERT INTO med_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Uⱡ mbʉ nga, Erot ndi, ik mat ou ndupa, Jisas wuldʉtʉm. Wote Jisas ndi, Erot ik ti, punt ropa, yant ndui nʉndrʉm mon. ");
INSERT INTO med_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wu pris kuimbal na, mi ik mbo wu na mbʉ, Jisas murum nila nondpa ok, Jisas ronduⱡ mundʉk, kot endʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erot kʉn, elim nga el wu ni kʉⱡ kʉn, Jisas tʉk ik kuldʉk, Jisas wal pʉki eng nui kai kat, tʉk pakʉndʉk, Jisas ni, Pailot murum kona nila, nduk yant mundrʉng. ");
INSERT INTO med_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erot ni, unt Pailot kʉn, el puⱡa wamp mel morunggil. Ui ei kʉn mint, wu raⱡ mʉn mondrʉnggil. ");
INSERT INTO med_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wote Pailot ndi, rʉp wu na, wu pris kuimbal na, wamp mbʉ, wi ropa, nimba mel, “Wʉi!” nitim. Kona ila rʉk ok, mʉk rorung. ");
INSERT INTO med_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pailot ndi, wamp mbʉ, kundpa nimba mel, “Enim ndi, wu ei, mek ok, na nguk, enim ndi, wu ei kundʉk, wamp mbʉ tʉpa wʉlʉ mundrum nʉnmʉn. Na ndi, wu ei, enim nga kuimp keta ila kun mondʉp, waldʉp pʉnt ei, wu ei nga uⱡ ⱡawa ti em ila, enim ndi, kot endʉng uⱡ ei, kurʉp kandʉp, ti natʉnt ei ka! ");
INSERT INTO med_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erot ndi, wu ei nga uⱡ ⱡawa ti, kurpa kandpa, ti natʉpa kʉn, wu ei ngumba, ya tʉn kʉn yant ndum. Enim pilʉi! Wu ei nga uⱡ ⱡawa ti mon! Ei nga, tʉn ndi wu ei, rop kundamin mel mon! ");
INSERT INTO med_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na ndi, wu ei kan puⱡa ndi rop, wak rop, mundamba kʉn kelpa pangga!” nitim.  ");
INSERT INTO med_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mowi kor ui mbila pora, Pailot ei ndi, kan manga wu ti, wamp mbʉ kʉn, wak ropa ngurum. ");
INSERT INTO med_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wamp nimbʉ pora, wi rok ke nʉk mel, “Wu ei, rok kondkʉn, Barapas wak rokʉn, tʉn kʉn mundi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barapas ni, wu ei, kona peng ila gapman wu mat kʉn, el ropa wu mat ropa kʉndrʉm ila tʉk kan ngurung.) ");
INSERT INTO med_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wote Pailot ndi, wamp mbʉ waldpa pilpa, Jisas wak rop, mundamba pangga, nitim. ");
INSERT INTO med_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wote aldpa, wamp mbʉ ndi, wi rok, Pailot kundʉk, nʉk mel, “Jisas nde peta ila nil ro! Jisas nde peta ila nil ro!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wote Pailot ndi, raldika endpa kʉn, nimba mel, “Wu ei, namba uⱡ ⱡawa ti em? Wu ei kuⱡangga nimp ei, wu uⱡ ⱡawa ti, na ndi, kandʉp ti natʉnt ei ka! Na ndi, wu ei, kan puⱡa ndi rop kʉn, wote wak rop mundamba pangga!” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wote, wamp mbʉ ndi, ronduⱡ ke nʉk, ronduⱡ mundʉk, Pailot ndi, Jisas nde peta ila nil rangga nʉtʉng. Wamp mbʉ nga ronduⱡ, wi rok nʉtʉng ik ei ndi, Pailot nga ik nitim ei, rok mana mana ndurʉng. ");
INSERT INTO med_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ni kʉn, Pailot ndi, wamp mbʉ nga nʉtʉng ik ni, pep ropa, nimba mel, “Jisas ni kuⱡangga!” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wote, wamp mbʉ ndi, Pailot wi rok kundʉk, nʉk mel, “Barapas ni, gapman kʉn el ropa wamp ropa kʉndrʉm wu ei, wak rokʉn mundana, kelpa wangga!” nʉtʉng. Nʉtʉng ei kʉn, Pailot ndi, wu ei, wak ropa mundpa kʉn, wamp kʉⱡ nga nʉtʉng ik ni, pep ropa, Jisas ni tʉpa, el wu kʉⱡ nga ki kaimp ila ngurum. ");
INSERT INTO med_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wote, el wu nimbʉ ndi, Jisas ni, imp molk mek purung ila, Sairin kona peng ila wu ti, mbi tek, Saimon nʉtmʉn ni, kona peng ila rukʉr uimp nimba urum ni, tʉk imp molk, nde peta ni kʉⱡ ngurung ila, koma ropa mepa, Jisas ni, pep ropa, akil tepa purum. ");
INSERT INTO med_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wamp rʉⱡaip mam ti, Jisas pep rok, akil tek purung. Wote, amp mat ou ndupa, Jisas kont kolk ka etʉk purung. ");
INSERT INTO med_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas ni, ropʉl ropa, amp ka etʉk, orung ni kʉⱡ, kundpa nimba mel, “Enim Jerusalem kona peng ila amp kʉⱡ ye! Enim ndi, na nga nʉndʉk, ka iti nʉtʉi, mon! En enim nga orunga nʉk kʉn, enim nga kangambuⱡa, mbʉ nga nʉndʉk, ka itʉi! ");
INSERT INTO med_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Enim pilʉi! Wote ui ti, ekit wangga kʉn, wamp mat ndi, enim kundʉk, i etʉk ning. ‘Amp mbʉ, kangambuⱡa mi naimbʉk, kangambuⱡa aim ngui nganggʉk eng mbʉ, numan kai pileing,’ ning. ");
INSERT INTO med_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ui ei kʉn, wamp mat ndi, komnga mong mbʉ kundʉk, ‘Tʉn tʉkʉn mo rokʉn, ⱡʉrʉk ndui!’ ning. ");
INSERT INTO med_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ni kʉn, akup wamp mbʉ ndi, nde nu pi kʉⱡ uⱡ ei mel enmin, wote nde kʉⱡ kʉp em ei kʉn, namba uⱡ ti iting nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","El wu mbʉ ndi, uⱡ kit mbʉ, etʉnggil wu raⱡ kunda, Jisas kʉn nde peta ila pendʉk ruing, pilik mek purung. ");
INSERT INTO med_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wote, wu ni kʉⱡ mek puk, kona komnga ti, mbi tek, ‘Wamp Peng Ombil’ kona nʉtmin nila, Jisas nde peta ila nil rok pendʉtʉng. Wu ni raⱡ nga ti, Jisas nga ki mbo orunga, nde peta tila nil rok pendʉk, wu ti, ki rar orunga nde peta ila nil rok pendʉk etʉng. ");
INSERT INTO med_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wote Jisas ndi, nimba mel, “Wuta Got nim ndi, wu kʉⱡ nga uⱡ ⱡawa mbʉ, wak rundi. Wu kʉⱡ uⱡ enmin ei nga puⱡ ti, pili napilik enmin,” nitim. El wu kʉⱡ ndi, Jisas nga wal pʉki na mel nimbʉ, potʉk tek, satu etʉk, wu ti tangga, nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wote wamp nimbʉ, anggilik kandʉk moⱡina, Jura nga rʉp wu nimbʉ ndi, Jisas nga ik kuldʉk nʉk mel, “Wu ei ndi, wamp mbʉ, tʉpa rapundpa etʉm uⱡ ei mel, elim Muⱡʉl Wu Kupa ti, Got ndi, tʉpa mundrum ila, wamp mbʉ, etpa rukʉr tangga nimba itim ndam, elim ndi, elim kapⱡa uⱡ mat, etpa tʉpa mundangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","El wu mbʉ kunda ku, ik raka rondʉk, wote Jisas rok pendʉtʉng nila, nondpa ok, ki runt rok, nʉk mel, “Nim kupa Jura wamp mbʉ nga Wu Nuim Mumuk ei ndam, ninim ndi, uⱡ mat etkʉn olkʉn pi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wu kʉⱡ ndi, mon kat rok, Jisas nga peng oⱡa orunga, nde peta nila mondʉk, nʉk mel, “WU EI, JURA WAMP NGA WU NUIM MUMUK EI!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wu ralt, nde peta ila rorung ni nga ti ndi, Jisas ni tʉpa, ik kuldpa nimba mel, “Nim kupa Got nga tʉpa mundrum wu ti ndam, ninim ndi, uⱡ mat etkʉn, ninim etʉk tʉk mundkʉn, wote tʉl tʉkʉn rapundkʉn iti ku!” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wote, wu ti ndi, nitim ik ni pilpa kʉn, wu ni, ik mura ngumba, nimba mel, “Wu ei, tʉn mindil kapⱡa mint nonmun. Ei nga, nim Got kʉn mundmong iti natʉkʉn nʉn ei?” ");
INSERT INTO med_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tʉl uⱡ kit mbʉ, etmbʉⱡ wu raⱡ, kapⱡa rok kunding enmin. Wu ei nga ⱡawa ti mon. Ei nambuⱡ emel, rok kunding enmin nda?” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wu ni ndi, Jisas kundpa, nimba mel, “Wote, Jisas ni, nim pukʉn, nim nga mumuk rui kona ei mʉn ndam, nim ndi, na piliya!” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wote Jisas ndi, wu ni kundpa, nimba mel, “Na ndi, nim ik kupa ti, kundʉp nʉnt. Nim wote, na kʉn rʉp ropʉⱡ, muⱡ kona muⱡin,” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wote ant ni, ou rʉnggilmʉ elinga, kona rumbʉⱡ ropa pelinga mba, epindama ant mong raldika itim. ");
INSERT INTO med_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ant ei kʉn, kona ant rui narʉⱡnga kʉn, manga wingti ou ila muⱡ mbal mam ti, kuipa rok mondʉrmin ei, rʉk ila paⱡpa, mba raⱡ itim. ");
INSERT INTO med_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Wote Jisas ni, ke ronduⱡ, nimba mel, “Wuta ye! Na nga muⱡnga ei, nim nga ki kaimp ila ngʉnt,” nitim. Nimba kʉn, Jisas ni kurum. ");
INSERT INTO med_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","El wu kʉⱡ nga wu kuimbal ni ndi, uⱡ itim ni kʉⱡ, kandpa kʉn, Got nga mbi paka rondpa, nimba mel, “Wu kun kai ei nga, uⱡ ⱡawa ti mon ei, rok kondʉnmin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wamp mat ndi, uⱡ itim ni, kʉnmin nʉk, orung nimbʉ ndi, uⱡ itim ni kandʉk, min ngʉn mundʉk, pepiⱡ ⱡuwa rok, kelik mang kona purung. ");
INSERT INTO med_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisas nga wamp pundʉn mbʉ kʉn, Galili kona peng ila amp kat, Jisas pep rok orung ni kʉⱡ kʉn, wamp kʉⱡ ruⱡ etʉk mel molk, uⱡ itim ni kandrʉng. ");
INSERT INTO med_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wu ti, kona ila murum ei nga mbi, Josep. Jura wamp kʉⱡ nga Arimatiya kona peng ila wu ei. Wu ei, kaunsil tʉpa etʉm wu kun kai ei. ");
INSERT INTO med_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wu ei ndi, wu kaunsil mat nga numan pilik, uⱡ etmin mbʉ mel iti natʉtʉm. Got nga wamp tʉpa mumuk rui uⱡ ei mint, nokundpa morum. ");
INSERT INTO med_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josep mba, Pailot ni, waldʉp pilamba kʉn, Jisas nga on ei ngangga, nimba mba, pitim mel, Pailot ei ndi, kapⱡa nitim. ");
INSERT INTO med_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wote Josep ndi, Jisas nga on ni, mana tʉpa, muⱡ mbal kurʉmʉⱡa tila kum ropa, mepa mba, ku manga kont ti, wamp on kona mim etʉk tetʉng nila, rʉk ndupa titim. ");
INSERT INTO med_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mowi kor mormin ui ei, ekit oⱡnga kʉn, rʉng molk nuing mbʉ, tʉk kun etʉng. ");
INSERT INTO med_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili kona ila amp kat, Jisas pep rok orung ni kʉⱡ, Josep ndi, Jisas nga on ni, mepa mba, wamp on ku manga nila etpa, tenʉm mel nant nda nʉk, kʉnmin nʉk, akil tek purung. ");
INSERT INTO med_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Amp ni kʉⱡ, kandʉk pendʉk, wote kelik, manga kona yant ok kʉn, kopung mura rui kai na, ronduⱡ mat, tʉk kun etʉk morung. Mi ik ei ndi, nʉtʉm ei mel, mowi kor ei kʉn, muⱡ tʉk kor morung. ");
INSERT INTO med_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kor ou ei nga ant puⱡ mondrung ni nga mʉkʉlmʉ unt, amp ni kʉⱡ ndi, kopung mura rui ronduⱡ na mat, tʉk kun etʉk tetʉng nimbʉ mek, wamp on kona nila purung. ");
INSERT INTO med_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amp ni kʉⱡ puk, anggilik kandrʉng mel, ku manga keta puⱡ puⱡ kumba rormʉn ku kara ni, mberʉk nduk, tʉk ʉldʉ orunga, angʉndʉtʉng ila ʉnggʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ku manga nila mukʉr puk, kandrʉng ei, Nuim Jisas nga on ni, ti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jisas nga on ni, nʉl teng nda nʉk, amp ni kʉⱡ, wote pilik rondʉk, numan ou nduk, pilik molk, kandrʉng mel, wu raⱡ muⱡ kurʉmʉⱡa pakʉkʉⱡ, morunggil ila rʉⱡang ndi, ʉlt nitim. ");
INSERT INTO med_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Amp ni kʉⱡ, mundmong etʉk, mʉi kandʉk morung ila, wu ni raⱡ ndi, amp kʉⱡ kundkʉⱡ, nʉkʉⱡ mel, “Wu koⱡpa tikil rom ei nga, nambuⱡ emel, ok kurʉk, mormʉn ei?” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“Wu ei, Galili kona ila kont moⱡpa kʉn, enim kundpa nitim ni mel pilʉi! Wu ei, ⱡoporpa omba pum. Ya kona ila pi napʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Enim kundpa, nimba mel, ‘Wu mat ndi, Muⱡʉl Wu Kupa ei tʉk, wu kit mat ngangina kʉn, nde peta ila nil rangina, kuⱡangga kʉn, wote wamp on kona ila tʉk puk andangga. Wote, rumbʉⱡ raldika omba, pangga kʉn, ⱡoporpa kont moⱡmba,’” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Jisas kont moⱡpa nitim ik ni pʉtʉng. Uⱡ itim kandrʉng nimbʉ mel puk, kitip kʉni wu 11 ni kʉⱡ kʉn, wamp mbʉ kʉn kundʉk, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Amp Mariya Makndelin, Jowana na, Jeims mam amp Mariya na, amp mat kunda, rʉp rok molk kʉn, nombuⱡa rung wu kʉⱡ kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nombuⱡa rung wu ni kʉⱡ ndi, amp kʉⱡ nga ik nʉtʉng ik ei, mondʉk pili napʉtʉng. Ik nuwa mat nʉnmʉn nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ni kʉn, Pita mint, tʉkrʉpa mba, wamp on kona ila kʉnimp nimba purum. Mba mana pepa, mukʉr ndupa kʉndrʉm mel, muⱡ mbal kurʉmʉⱡa kat mint titim. Wote, mang kona yant omba kʉn, uⱡ kʉⱡ nga numan ou ndupa pitim. ");
INSERT INTO med_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ant tenda ei kʉn, wu ralt, Imeiyus kona ila mbil ni kʉⱡ, nombuⱡa mam ila orʉnggil. Imeiyus ni kona ei, Jerusalem kona peng ou ei nga ruⱡ etpa mel tetʉm. ");
INSERT INTO med_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wu raⱡ, nombuⱡa mam ila okʉⱡ kʉn, Jisas rok etʉng uⱡ mbʉ mel timan rokʉⱡ nʉkʉⱡ orʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wu raⱡ ndi, uⱡ etʉng ni mbʉ nga ik ou ndukʉⱡ, waldkʉⱡ nʉkʉⱡ orʉnggil. Ni kʉn, Jisas elim ni, wu raⱡ kʉn nondpa urum uⱡ ei, pili napʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wu raⱡ nga mong ila mel mat ndi, ⱡʉrʉk ndurum ila, Jisas kandkʉⱡ, mbi ndui nandrʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas ndi, wu raⱡ, waldpa nimba mel, “Enmbil namba uⱡ em mbʉ nga nʉnmbil, wote enmbil nʉl pinggil, onmbil nilinga mel, wu raⱡ nga numan orunga, mbun tʉtʉnggil?” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wu raⱡ nga wu ti nga mbi, Kliopas ni ndi, Jisas nga nitim ik ni, punt ropa, nimba mel, “Kona elpa elpa mbila wu mbʉ ok, Jerusalem kona peng ila mormʉn uⱡ ei, nim wu tenda ei mint, uⱡ em ei, pili nʉpʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wu ni, i nilinga mel, Jisas ndi, wu ni raⱡ, waldpa nimba mel, “Namba uⱡ mat em nda?” nitim. Wu ni ndi, nimba mel, “Nasaret kona peng ila Jisas ni, wu ei ndi, uⱡ rʉpʉndi mat etʉm. Painui wu ei ndi, ik na kongun na, ronduⱡ mat, wamp kʉn, Got nga kuimp keta mbila nimba etʉm. ");
INSERT INTO med_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wu pris kuimbal na, rʉp wu mbʉ ndi, Jisas tʉk gapman nga ki kaimp ila nguⱡina kʉn, gapman ndi, nimba kʉn, Jisas nde peta ila nil rʉi nilinga, nde peta ila nil rorung. ");
INSERT INTO med_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Unt, tʉn pʉtmʉn ei, Got ndi, Jisas tʉpa mundpa kʉn, Isrel wamp mbʉ etpa rukʉr tangga, nimba itim. Wote, wamp kit mbʉ ndi, Jisas nde peta ila nil rok eng. Uⱡ ei nga, rumbʉⱡ raldika omba pum ei nga akup mormʉn. ");
INSERT INTO med_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ei mel pilpʉn moⱡmina, wote akup nga mʉkʉlmʉ unt, tʉn nga amp mat wamp on kona ila puk kandʉk, yant ok nilingina, tʉn rut nimin. ");
INSERT INTO med_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Puk kanʉng ei, Jisas nga on ni, on kona ila ti natʉm. Amp kʉⱡ yant ok, nʉk mel, tun ndi anggelo kʉⱡ kʉnmin ila nʉk mel, Jisas ⱡoporpa kont morum nʉng. ");
INSERT INTO med_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tʉn nga wu mat puk kanʉng ei mel ku, amp kʉⱡ kandʉk yant ok nʉng. Wu kʉⱡ ndi, Jisas nga on ei, kʉⱡ tem kʉni nakʉnʉng,” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wote Jisas ndi, wu raⱡ, kundpa nimba mel, “Enim mbil nga numan ti mon, ei ka! Painui wu mbʉ nga nʉtmin ik mbʉ, enmbil mondkʉⱡ, pili napʉtʉmbil ei ka! ");
INSERT INTO med_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Enmbil pili napʉtʉmbil ye! Jisas ni mbun mam ti, unt koma ropa kʉn, wote uⱡ eng nui ti, Got kʉn tʉm ei?” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jisas ndi, wu raⱡ, ik mat mbo inditim. Moses nga mi ik mat, puⱡ mondpa, mbo endpa, pai nui wu mbʉ nga ik puⱡ mat, nimba ngumba, Got nga Buk Wingti ila mat, elim nga itim uⱡ mbʉ mel nimba, ngumba itim. ");
INSERT INTO med_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wu raⱡ nga numan pinggil, pilkʉⱡ orʉnggil kona ila nondpa oⱡunggila. Jisas ni, kandpa, kelpa kun pi mel itim. ");
INSERT INTO med_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wote, wu raⱡ ndi, Jisas ni imp molkʉⱡ, nʉkʉⱡ mel, “Nim akup tʉl kʉn muⱡmin,” nʉtʉnggil. Kona ant ei, mana mba elinga, nondpa rumbʉⱡ romba itim ila, Jisas ni, manga ila mukʉr puⱡnga kʉn, wu ni raⱡ kʉn, rʉp rok morung. ");
INSERT INTO med_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wote Jisas ni, wu raⱡ kʉn molk, rʉng nuing etʉng ila, Jisas ndi, bret ni, tʉpa oⱡa ndupa, Got kʉn angge nimba, ambuⱡpa puk ropa tʉpa, wu raⱡ ngurum. ");
INSERT INTO med_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jisas ndi, uⱡ ni eling kʉn, wu raⱡ mong makʉlkʉⱡ kandrʉnggil mel, Jisas kandkʉⱡ, mbi ndʉrʉnggil. Tʉngʉnda mint, Jisas purum ila, wu raⱡ ndi, Jisas ni, kʉni nakʉndrʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wote, wu ni raⱡ, ik nʉkʉⱡ int yant etkʉⱡ, nʉkʉⱡ mel, “Tʉl nombuⱡa mam ila ʉmbʉⱡ ei kʉn, Jisas ndi, Got nga Buk Wingti ila ik puⱡ kai mat, tʉl nimba nguⱡnga kʉn, tʉl pilpʉⱡ min ngʉn mundʉmbʉⱡ ni ka!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wu raⱡ ndi, ik nimbʉ, nʉkʉⱡ pendkʉⱡ tʉkʉrkʉⱡ, Jerusalem kona peng nila yant orʉnggil. Okʉⱡ kandrʉnggil mel, kitip kʉni wu 11 kʉⱡ kʉn, wamp mat kunda mʉk rok morung. ");
INSERT INTO med_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wamp mbʉ ndi, wu raⱡ, kundʉk nʉk mel, “Wu Nuim ni, ⱡoporpa kont morum! Saimon ndi, wu ei kanim ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wu raⱡ nga uⱡ mat, nombuⱡa mam ila Jisas ndi, itim kandrʉnggil nimbʉ mel timan rokʉⱡ, wamp mbʉ ngurʉnggil. Jisas ndi, bret tʉp roⱡnga kʉn, wu raⱡ ndi, Jisas kandʉk, mbi ndukʉⱡ, etʉnggil mbʉ mel nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kitip kʉni wu ni kʉⱡ, ik nʉk moⱡina kʉn nila rʉk, Jisas ni, omba anggilpa, wu kʉⱡ kundpa nimba mel, “Enim numan kai mbʉ mint, pilik muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wu ni kʉⱡ, rut nʉk, mundmong etʉk pilik mel, Jisas nga min ei nda nʉk, kandrʉng. ");
INSERT INTO med_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wote Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Nambuⱡ emel, enim rut nʉk, numan ou nduk, pilik mormin ei? ");
INSERT INTO med_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Na nga kʉmp ki ʉrʉⱡa mbʉ, ya ok, ambulk kʉnʉi! Wamp nga min ei, ya na mel ti wangga, kapⱡa kʉni nʉkʉning, mon!” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ni kʉn, Jisas ndi, elim nga kʉmp ki ʉrʉⱡa mbʉ, wu ni kʉⱡ ora ndurum. ");
INSERT INTO med_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wu kʉⱡ, ama numan minal ngurung. Wote, wu kʉⱡ nga mondpa pili ti, kapⱡa mon ei nga, numan ou ndupa pʉtʉng. Uⱡ ila, Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Rʉng mat, enim tek mormin ei?” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Wote, wu ni kʉⱡ ndi, oma karʉng mint ti ngurung ila, Jisas ndi, oma mint ti tʉpa, nurum ila, wu kʉⱡ kandrʉng. ");
INSERT INTO med_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Unt, na enim kʉn moⱡʉp, enim kundʉp nʉmp pora ndʉr ni ka! Unt, ik mong mat, na nga mon rondʉk ngurung ei, Moses nga mi ik na, painui wu kʉⱡ na, ik nʉtʉng. Wote, Buk Wingti ila ik kʉⱡ, akup omba kupa enim,” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jisas ndi, wu kʉⱡ nga pilpa kungʉndi orunga nimba, piral ndurum ila uⱡ puⱡ mbʉ, pilik kai etʉng. ");
INSERT INTO med_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Buk Wingti ei ndi, nimba mel, ‘Kraist ni, wu ei, mbun koma ropa mba koⱡpa, wote ⱡoporpa mba, kont moⱡmba,’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Wu ei nga ronduⱡ ila mbi ei, tek angʉndʉk, wamp mbʉ kundʉk nangina, wamp mbʉ, pilik numan ropʉl rok tangina, Got ndi, wamp mbʉ nga uⱡ kit mbʉ, wak rondʉmba. Enim ndi, kongun ei, Jerusalem kona peng ila puⱡ mondʉk etʉk, ya uⱡ penim kanmin mbʉ mel, wamp kundʉk, nʉk itʉi! ");
INSERT INTO med_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Enim pilʉi! Unt Wuta ndi, nimba mʉi ropa kʉn, Muⱡnga Wingti, enim kʉn nguimp nitim ei, akup nondpa, enim ngumba. Enim akup ya Jerusalem kona peng ou ila molk, Got nga ronduⱡ ei, tʉk kʉn, wote enim kongun etʉk pʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ, tʉpa mepa mba, Betani kona nila puk molk kʉn, Got kʉn atinga ropa, ki oⱡa ndupa, wu kʉⱡ, memp pendpa itim. ");
INSERT INTO med_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wu kʉⱡ, memp pendpa moⱡnga kʉn, Got ndi, tʉpa mepa, muⱡ kona oⱡa purum. ");
INSERT INTO med_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wote, wu ni kʉⱡ, mura rok mondʉk, Jisas nga mbi paka rondʉk, ambulk palk, Jerusalem kona peng ila yant orung. ");
INSERT INTO med_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ui nimbila rʉk rʉk, manga wingti ila mint puk, Got nga mbi paka rondʉk etʉng. ");
INSERT INTO med_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Unt kor nga Got ndi, muⱡ mʉi raⱡ mim iti nʉti kʉn, Ik ei titim. Ik ei, Got kʉn murum. Omba Ik ei, elim Got. ");
INSERT INTO med_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ama unt kor nga puⱡ mondpa, Ik ei, Got kʉn murum. ");
INSERT INTO med_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ik ila mendpʉⱡ, Got ndi, mel mbʉ pora itim. Mel mbʉ nga ti, nombuⱡa mam elpa tila, oⱡa ui nawʉrʉm, mon! ");
INSERT INTO med_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ik ei, el elim kont mba mul uⱡ ei nga Puⱡ Wu ei. Wote, kont mba mul uⱡ ei, tepa omba, tʉn wamp mbʉ rʉⱡang ngurum. ");
INSERT INTO med_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rʉⱡang ei ndi omba, rumbʉⱡ ila rʉⱡang ngurum. Wote, rumbʉⱡ ei nga ronduⱡ ei ndi, rʉⱡang ei, ropa mana ndui nandrʉm. ");
INSERT INTO med_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Got ndi, elim nga nombuⱡa rung wu ti, tʉpa mundrum. Wu ni nga mbi ei, Jon. Wu ni ndi, rʉⱡang ei nga pora ndupa nangga. Wamp mbʉ ndi, ik ei pilik mondʉk, pileing nimba, tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon elim ni, rʉⱡang ei mon. Wote elim ndi, rʉⱡang ei, mat ndumba nimba, mat ndumba ei nga urum. ");
INSERT INTO med_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Rʉⱡang kupa ei, mʉi kona mana omba, wamp mbʉ pora, rʉⱡang ngurum. ");
INSERT INTO med_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Got nga ik ni, mʉi kona ila mana urum. Got elim moⱡpa, muⱡ mʉi mbʉ pora itim. Wote, wamp mbʉ ndi, elim kandʉk, mbi ndui nandrʉng. ");
INSERT INTO med_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Elim nga mʉi ila rukʉr urum. Wote, elim nga wamp nimbʉ ndi, elim rawe etʉk, ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wote, wamp mat ndi, elim rawe etʉk tʉk, elim mondʉk pilik etʉng nimbʉ, ronduⱡ nguⱡnga, Got nga kangambuⱡa rarʉng. ");
INSERT INTO med_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Got nga kangambuⱡa rarʉng mbʉ, wamp mema ei ndi, mon! Wamp nga numan ei ndi, mon ku! Wote, Got elim ndi itim. ");
INSERT INTO med_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ik ei, wamp raⱡpa, tʉn kʉn omba pitim. Elim eng noⱡnga, kʉndʉrmʉn. Elim nga Tipam kʉn moⱡpa, mana urum kangʉm kang ei, eng nurum. Wamp poⱡ ti uⱡ ei kʉn, ik kupa ei kʉn, elim kʉn pitim. ");
INSERT INTO med_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ndi, wu ei nga para ndupa, nimba mel, “Wu ei nga kundʉp nit ni, Wu Nuim akil tepa onum. Ei ndi, na tʉpa mana ndumba. Nambuⱡ emel, na muⱡi nʉmbʉr kʉn, elim ni, unt murum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nambuⱡ emel, elim nga poⱡ ti uⱡ ei nga mur ila, tʉn memp titmin. Wote, pol ila aldpa, memp tʉpʉn ku etmin. ");
INSERT INTO med_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nambuⱡ emel, Got nga mi ik kʉⱡ, Moses kʉn pilpʉn titmin. Wote, wamp poⱡ ti uⱡ ei kʉn, ik kupa ei kʉn, uⱡ raⱡ Jisas Kraist kʉn tʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wamp ti ndi, Got kʉni nakʉndrʉm. Elim nga kangʉm mendpʉⱡ ei ndi, Tipam kʉn nondpa moⱡpa, Tipam nga puⱡ ei nimba, mot ndurum. ");
INSERT INTO med_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem, kona ila Jura wu morung nimbʉ ndi, wu Pris na, Lipai wu kat, tʉk mundʉⱡina ok, Jon waldʉk nʉk mel, “Nim wu nam?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon elim ndi, nimba mot ndupa, “Na Kraist mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ama minal waldʉk nʉk mel, “Nim wu nam? Nim Ilaija muna? Nilingina, “Mon ku!” nitim. “Muna, nim painui wu ei?” Nʉk waldʉlingina, “Mon ku!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Wote nim wu nam? Tʉn kundkʉn ni! Wote, tʉn tʉk mundung wu mbʉ, int mbun kundpʉn nimin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ndi, ik punt ropa nimba mel, “Painui wu Aisaiya nga ik ti, unt nimba pinditim. Ik ei ndi, ei mel nitim, “Kona kui waka ila wamp ti, wi ronum ei, na Nuim ei, omba ei nga nombuⱡa mam ei, rok tʉk kun mundangina, wu Nuim ei wangga!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Perisi wu nimbʉ, tʉk mundrʉng wu ni kʉⱡ ndi, Jon waldʉk nʉk mel, “Nim Kraist ei mon. Ilaija kep, mon ku. Painui wu ti kep, mon ku ndam, wote nambuⱡ emel, wamp nu tʉndʉn?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Ei mel nilingina, Jon ndi, punt ropa nimba mel, “Na ndi, wamp mbʉ, nu ila mint nu tʉndʉnt. Wote, enim nga rʉk ting ila, wu kʉni nʉkʉni ti morum. Wu ei, na nga mbuldung orunga, akil tepa onum. Wu ei nga kʉmp rʉk kan ei, na ndi pilinga, nduimp mel kapⱡa mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Uⱡ etʉng nimbʉ pora nilinga, Betani kona ila, ekit oⱡungina, nu Joran al orunga, Jon wamp nu tinditim kona nila itim. ");
INSERT INTO med_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wote, mʉkʉlmʉ orunga, Jisas ni, Jon murum nila, oⱡnga kandpa, nimba mel, “Got nga kng sipsip waⱡ, mʉi kona ila wamp mbʉ nga uⱡ kit mbʉ, pendpa kelmba ei nga onum kʉnʉi! ");
INSERT INTO med_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Enim wu ei nga kundʉp nit ni, wu akil tepa omba ei, wu oⱡa orunga mel ti, na kʉn kapⱡa mon. Nambuⱡ emel, na mi nʉmi kʉn, elim ni, kump kor nga murum. ");
INSERT INTO med_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na ndi, elim pili nʉpʉt mon. Wote na ndi, Isrel wamp mbʉ, wu ei nga kandʉk, pilik poⱡ ndeing nʉmp kʉn omp, wamp nu tindint,” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wote ni kʉn, Jon ndi, ekit ndupa nimba mel, “Muⱡnga Wingti ei, muⱡ ila, kʉi imil mel raⱡpa, mana omba, elim kʉn moⱡnga, kundung nitim. ");
INSERT INTO med_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na elim pili nʉpʉt, mon ku. Wote Got ndi, na wamp nu tʉndeimp nimba, tʉpa mundrum ei ndi, na ndoimp rondpa, nimba mel, ‘Muⱡnga Wingti ei kinana, mana omba, wu ti kʉn moⱡum ndam, wu ei ndi wamp mbʉ, Muⱡnga Wingti kʉn pendpa, nu tʉndʉmba,’ nitim. ");
INSERT INTO med_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nitim ei mel, na ndi, kʉndʉr ei mel, enim kundʉp namp, “Wu ni, Got nga kangʉm waⱡʉm ei,” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Ni kʉn, mʉkʉlmʉ orunga, Jon elim nga kitip kʉni wu raⱡ kʉn kunda moⱡʉngina, Jisas ni omba puⱡnga, Jon ndi kandpa, nimba mel, “Got nga Sipsip Waⱡ ei kʉnʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kitip kʉni wu ni raⱡ, ik nitim ni pilkʉⱡ, Jisas purum ni mel, akil tekʉⱡ, pep rokʉⱡ purʉnggil. ");
INSERT INTO med_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas ndi, tʉpa ropʉl ropa kundrum ni kʉn, wu ni raⱡ orʉnggil ila, waldpa nimba mel, “Namba mel ei, kurkʉⱡ onmbil?” nitim. Wote wu ni raⱡ ndi, punt rokʉⱡ nʉkʉⱡ mel, “Ik mbo wu ye! Nim kona nant ila pun?” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wote Jisas ndi, nimba mel, “Okʉⱡ kunʉnggil wʉl!” nitim. Ant mong ni, tʉmbʉkak elinga, rʉp rok puk pitim kona ni, kandkʉⱡ elim kʉn rʉp rok, ant ei kʉn morung. ");
INSERT INTO med_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Jon ndi, ik nitim ni pilkʉⱡ, Jisas purum mel, akil tekʉⱡ purʉnggil. Wote, wu ni raⱡ nga ʉngʉn, Saimon Pita nga ʉngʉn wu Andru ni, ant tenda ila mba, ʉngʉn Saimon ni kandpa, tʉpa nimba mel, “Mesaiya, Kraist, nʉtmin wu ni raⱡ ndi, kandʉp tʉmbʉⱡ,” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wote Andru ndi, Saimon tʉpa mepa, Jisas kʉn purum. Jisas ndi kandpa, nimba mel, “Nim Jon kangʉm wu Saimon. Nim mbi tep Sipas, nʉnt ropʉl ropʉn, Pita nimin. ");
INSERT INTO med_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wote mʉkʉlmʉ orunga, Jisas ni, Galili orunga purum. Wote, wu Pilip ni kandpa tʉpa nimba mel, “Na pep rokʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip, Andru kʉn, Pita kʉⱡ nga mʉi mang kona ei nga, kona peng ei, Betseita. ");
INSERT INTO med_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip ni mba, Nataniyel kurpa kandpa, tʉpa kundpa, nimba mel, “Moses ndi, wu ti nga nʉndpa mi ik ila, mon rurum. Wote, painui wu mbʉ ndi, rorung wu ni, tʉn ndi, kandʉp timʉn. Wu ni, Nasaret kona ila wu Jisas, Josep nga kangʉm”, nitim. ");
INSERT INTO med_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wote Nataniyel ndi, waldpa nimba mel, “Nasaret kona ila, namba uⱡ kai ti ekit omba nda?” nitim. Nimba waldilinga, Pilip ndi nimba mel, “Okʉn kʉni!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisas ndi, Nataniyel ni oⱡnga, kandpa nimba mel, “Wu ei, Isrel nga wu kupa ei. Ik kep nui uⱡ ti, wu ei kʉn pi napʉtʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ei mel nilinga, Nataniyel ndi, Jisas waldpa nimba mel, “Nim na nga puⱡi etkʉn, pilkʉn nin mel nant?” nitim. Wote Jisas ndi, int ndupa, nimba mel, “Nim Pilip ndi, wi ropa ti nʉti kʉn, nde ui puⱡ ila moⱡina, kant ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel ndi, ik int ndupa, nimba mel, “Nim ik mbo wu ye! Nim Got nga kangʉm ei, Isrel wamp mbʉ nga Wu Nuim Mumuk ei!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas ndi, nimba mel, “Nim nde ʉi puⱡ ila, mʉn nʉnt ik kʉⱡ nga mendpʉⱡ, mondkʉn pilkʉn nʉn nda? Uⱡ ou mat, wote kʉnin an!” nitim. ");
INSERT INTO med_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wote Jisas ndi, nimba mel, “Na ndi, ik kupa ei, enim kundʉp nʉnt. Muⱡ ei, kumba tʉpa tiyangga kʉn, Got nga anggelo mbʉ ndi, Muⱡʉl Wu Kupa ei kʉn, oⱡa mana etʉk endangina, kʉning!” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wote, rumbʉⱡ raldika omba puⱡnga, Galili kona peng Keina ila, amp ti, wu ngorung nila, Jisas nga mam ni, ila murum ku. ");
INSERT INTO med_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ kʉn, rung munduⱡina, puk morung ku. ");
INSERT INTO med_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wote, nu wain nok pora nduⱡmina, Jisas nga mam ndi, Jisas ni kundpa, nimba mel, “Nu wain ei, pora ninim,” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisas ndi, int ndupa, nimba mel, “Amp ye! Nim ndi, na nga itimp uⱡ ei mel, nʉkʉn ngui ngʉngi! Na nga ui ei, kokila petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wote, Jisas nga mam ndi, kongun wu ni kʉⱡ, kundpa nimba mel, “Elim ndi, enim kundpa nim ik ei mel, pilik itʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ku ming 6 kat titim ni kʉⱡ, Jura wamp mbʉ nga atinga rok uⱡ etmin ei nga, nu kulk, kump ki ⱡumʉi rormin ming mam nimbʉ, wei titim. ");
INSERT INTO med_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas ndi, kongun wu ni kʉⱡ, kundpa nimba mel, “Ming mbila nu kulk mundʉi!” Nilinga, nu kulk peka rondrung. ");
INSERT INTO med_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jisas ndi, kongun wu ni kʉⱡ, kundpa nimba mel, “Akup nu mbʉ kulk, mek puk, rʉng kaⱡʉm rʉp wu ei ngʉi!” nitim. Wote, nitim ni mel etʉng. ");
INSERT INTO med_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Rʉng rup itim wu ni ndi, nomba pitim mel, nu wain mendpʉⱡ itim, “Apa ye! Nil kandʉk tʉng nda?” nimba pitim. Wote, kongun wu nu kulk, mek orung ni kʉⱡ, pilik morung. Amp titim wu ni, wi ropa kundpa, nimba mel, “Wamp pora, nu wain kai mbʉ, kuimp tek nok, wote akil tek, nu wain tʉngʉn iti nʉti ei, etmin ni. Nim nu wain kai mat titʉn ti, wote akup, nonmʉn ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ni kʉn, Galili nga kona peng Keina ila, Jisas ndi, puⱡ mondpa, uⱡ rʉpndi ti itim ila, kitip kʉni wu ni kʉⱡ ndi, elim nga ronduⱡ ei kandʉk, elim ni, mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wote, Jisas elim nga mam kʉn, ʉngʉnʉl kʉn omba, elim nga kitip kʉni wu ni kʉⱡ kʉn, Kaperniyum kona peng ila puk, ui mat morung. ");
INSERT INTO med_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jura wamp nga Pasopa rʉng nuing ui ni, nondpa elinga, Jisas ni, Jerusalem purum. ");
INSERT INTO med_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wote, manga wingti ou ila, wamp minal kng kau na, sipsip na, kʉi na mbʉ, rarʉp rok, ku moni int yant etʉk, rat pol nimbila moⱡina kundrum. ");
INSERT INTO med_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ni kʉn, Jisas ndi, kan puⱡa ti tʉpa, wamp na, kng sipsip na, kng kau na mel nimbʉ, kan puⱡa ndi ropa, makrʉpa mundpa, ku moni int yant etʉng nimbʉ, ropa mbuⱡ mbaⱡ etpa, rat pol nimbʉ, ropa kongundpa itim. ");
INSERT INTO med_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kʉi na mat, tek morung wamp nimbʉ, kundpa nimba mel, “Kelik mek pʉi! Na nga Wuta nga manga ei, tʉk mel rop manga rundi nʉndʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kitip kʉni wu ni kʉⱡ ndi, Buk Wingti ila, ik ti petʉm ei, omba ronduⱡ nga pʉtʉng. “Got nim nga manga ei, na numan ngʉmp kʉn, na nga numan ei, ndip mel nonum,” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wote, Jura wu nuim nimbʉ ndi, yant nduk, Jisas waldʉk nʉk mel, “Nim namba uⱡ rʉpndi ti, etana kandpʉn, nim uⱡ mbʉ nga ronduⱡ tekʉn molkʉn en, ei nana pilamin!” nʉtʉng? ");
INSERT INTO med_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas ndi, punt ropa, nimba mel, “Manga wingti ou ei, rok tʉk tiyangina, na ndi, rumbʉⱡ raldika ila mendpʉⱡ, rakʉp timp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jura wu nimbʉ ndi, ik int nduk nʉk mel, “Ya manga wingti ei rakʉⱡina, pana 46 omba purum. Nim wu ei ndi, rumbʉⱡ raldika ila, manga rakʉp timp nun ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wote Jisas ndi, manga wingti nitim ni, elim nga kʉng kʉⱡ kundpa nitim. ");
INSERT INTO med_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wote Jisas ndi, on kona ila, ⱡoporpa omba purum ni kʉn, kitip kʉni wu ni kʉⱡ ndi, nitim ik ni, pilik tʉk rondʉk, Buk Wingti ila ik petʉm mbʉ kep, Jisas elim nga nitim ik nimbʉ, kʉmp kʉm pilingina, kupa elinga, mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wote Jisas ndi, Jerusalem kona peng ou ila, Pasopa ui ou morung ni kʉn, Jisas uⱡ rʉpndi mat itim ni, wamp minal ndi kandʉk mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wote Jisas ndi, i etʉng uⱡ ni, kandpa tʉpa pei mundpa kʉn, el elim ndi, wamp kʉⱡ nga ki ila, ngui ngʉnggʉrʉm. ");
INSERT INTO med_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nambuⱡ emel, wamp nam ti ndi, wamp nga numan pʉtmʉn uⱡ ei nga, Jisas kundʉk ni nandʉtʉng. Nambuⱡ emel, elim ndi, wamp nga numan rukʉr kandrum. ");
INSERT INTO med_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wote, Jura wamp mbʉ nga Perisi wu nuim, Nikondimas nimba ti murum. ");
INSERT INTO med_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wu ni ndi, rumbuldi Jisas kʉn mba, kundpa nimba mel, “Ik Mbo Wu ye! Nim ik mbo wu Got kʉn molkʉn, mana urʉn ti kant. Ei kʉn, wamp ti ndi, Got elim kʉn muⱡi nambʉⱡʉm ndam, wamp ei, nim uⱡ rʉpndi mat etʉn mbʉ mel, kapⱡa iti natʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas ndi, punt ropa, nimba mel, “Ya ik nʉnt mbʉ, ama kupa nʉnt. Kont nga mi naming wamp ti ndi, Got nga wamp tʉpa mumuk rui uⱡ ila, rukrʉng mba mel mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jisas nga nitim ik ni, Nikondimas ndi, waldpa nimba mel, “Wu anda etpa moⱡum ti, aldpa mam nga oⱡ ila, rukrʉng pangga kʉn, namba etʉk, wote kont nga mondʉk ming ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas ndi, int ndupa nimba mel, “Ik kupa ei nʉnt. Wamp ti, nu ei kʉn, Nuim Got nga Muⱡnga raⱡ ndi, kont nga mi naminggil ndam, Got nga wamp tʉpa mumuk rui uⱡ ila, rukrʉng mba mel mon! ");
INSERT INTO med_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mʉi kona wamp mbʉ ndi, mondʉk metmin wamp mbʉ, mʉi kona wamp rarmin. Wote Muⱡnga ndi, mondpa metʉm wamp mbʉ, tʉpa Muⱡnga elim nga wamp randrum. ");
INSERT INTO med_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wamp kont nga, miyangga nʉnt ik ni nga, nim pilkʉn min ngʉn mundi nʉmʉndi! ");
INSERT INTO med_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kona kʉpkʉ elim pʉtʉm ei mel, ropa omba mba mel mbʉ, roka nduⱡnga, ik nʉtʉm ei pʉtmʉn. Wote, pepa orum kona ei kep, wote omba kona nil purum ei kep, tʉn pili napʉtmʉn. Muⱡnga nga wamp kont nga, metʉm ei nga puⱡi ei, ei mel ku petʉm” nitim. ");
INSERT INTO med_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Wote Nikondimas ndi, nimba mel, “Namba uⱡ ti nga nin ei, na pilip rondʉnt ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aldpa Jisas ndi, Nikondimas kundpa, nimba mel, “Nim Isrel kona ei nga ik mbo wu kuimbal ni, nʉmp kant! Ei wote, na ik nʉnt ei, pilkʉn rundʉn ei ka! ");
INSERT INTO med_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na ndi, ik kupa enim kundʉp nʉnt. Tʉn ik pilip kongundpʉn nimbun, wote mong raⱡ ndi, kandʉrmʉn mel, kun nimbun mot ndupʉn nʉtmʉn. Ei wote, enim ndi, tʉn nga ik ei, pilik ti natʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mʉi kona ila nga, uⱡ petʉm mbʉ mel, oⱡa tʉp nilmba, nim pilkʉn kun iti natʉn. Wote, muⱡ kona ila uⱡ mbʉ nga, nint ndam, namba etkʉn pilkʉn kun itin? ");
INSERT INTO med_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wote, wamp ti mul kona ila, oⱡa pi nʉpʉrʉm. Wote, Muⱡʉl Wu Kupa ei mendpʉⱡ, muⱡ kona ila moⱡpa, mana urum. ");
INSERT INTO med_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Unt, kona kui waka ila, Moses ndi, kimbuⱡa mel ti, mim etpa, kuipa ropa mundrum. Ei mel, Muⱡʉl Wu Kupa ei, i ku etʉk tek, kuipa rok mundangina, na mondpa pilim wamp ti, uⱡ nga kʉnt nga kont mul uⱡ ei, moⱡpa mint mba. ");
INSERT INTO med_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ei kʉn, Nuim Got ndi, tʉn mʉi kona ila wamp mbʉ, kont minal kuⱡpa, elim nga kangʉm mendpʉⱡ ei, tʉn ngurum. Ei nga, elim nga kangʉm ei, mondʉk piling wamp mbʉ, uⱡ nga kʉnt nga kont mul uⱡ ei, molk mint ping. ");
INSERT INTO med_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wote Got ndi, kangʉm Jisas tʉpa mundrum ni, wamp kʉmp tangga nimba, tʉpa mundi nʉmʉndrʉm, mon! Wamp pora etpa tangga nimba, tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wamp ti, Got nga kangʉm ei, mondpa pilim ndam, kʉmp ti natʉmba. Wote, wamp ti mondpa pili napilim ndam, wamp ei kʉmp tʉmba. Nambuⱡ emel, wamp ei, Got nga kangʉm mendpʉⱡ ei, mondpa pili napʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wamp kʉmp tʉmba uⱡ ei mel, Jisas ni, rʉⱡang ei, ya mʉi kona ila mana urum. Ei mʉi kona ila wamp mbʉ ndi, kandʉk kun iti natʉk, rumbʉⱡ ei kandʉk, numan nguk, rʉⱡang ei tʉk mbaⱡ ngorung. Nambuⱡ emel, wamp mbʉ ndi, uⱡ kit mbʉ etʉk morung. ");
INSERT INTO med_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Uⱡ kit etmin wamp mbʉ ndi, rʉⱡang ei kandʉk, kit pilik, tʉn nga uⱡ kit mbʉ, para temba nʉk, rʉⱡang ila rukʉr ui nawʉrmʉn. ");
INSERT INTO med_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wote, uⱡ kupa mbʉ etʉm wamp ti, Got nga ik ei, teng ndupa etʉm uⱡ mbʉ, mot nangga, kʉneing nimba, rʉⱡang ila rukʉr orum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wote Jisas ndi, elim nga kitip kʉni wu ni kʉⱡ kʉn, Juriya kona ila puk moⱡʉngina, kitip kʉni wu ni kʉⱡ ndi, wamp mbʉ nu tinditing. ");
INSERT INTO med_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wote Jon ndi, i ku etpa, met Einon Selim kona ila, nondpa nu minal murum kona nila, wamp ok, mint moⱡina, nu tinditim. ");
INSERT INTO med_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ni kʉn, Erot ndi, Jon ni tʉpa, kan ngui ngʉngi kʉn, uⱡ mbʉ etpa murum. ");
INSERT INTO med_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tʉnggʉt, Jura wu ti ndi omba, en enim nga ki ⱡumʉi rui uⱡ ei nga, oⱡa tʉpa nilinga, Jon nga kitip kʉni wu ni kʉⱡ kʉn, ik porung. ");
INSERT INTO med_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wote, Jon nga kitip kʉni wu ni kʉⱡ, elim kʉn ok, nʉk mel, “Ik mbo wu ye! Unt wu ti, nim kʉn, nu Joran noi orunga oⱡnga, elim nga para ndukʉn nitin. Akup wu ni ndi, wamp mbʉ nu tʉndʉlnga, wamp pora wu ei kʉn punmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wote Jon ndi, ik ni punt ropa, nimba mel, “Got ndi, mel ti mana ndupa, ngui ngangʉm ndam, wamp ti ndi, kun poⱡpa tʉmba mel mon. ");
INSERT INTO med_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Unt nit ni mel, enim akup kundʉp nʉnt, Got nga ngurum wu Kraist ei, na mon! Na nombuⱡa rung wu ei.’ ");
INSERT INTO med_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Amp kiyaka orum ei, amp tʉmba wu ei nga mendpʉⱡ orum. Amp tʉmba wu ei nga, wamp mʉn ti, nondpa moⱡpa, amp tʉmba wu ei nga ik nʉtʉn ei, pilpa numan kai pʉtʉm. Uⱡ ei mel, Got nga ngurum wu Kraist ei, amp tʉmba wu ei mel, wote wamp mʉn ti, nondpa moⱡpa, numan kai pʉtʉm wu ei mel, na moⱡʉp kʉn, enim ndi, wu ei nga ik ninmin ei, pilip kai pʉnt. ");
INSERT INTO med_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Elim nga mbi omba, oⱡa pangga, na, elim nga mana orunga muⱡimp. ");
INSERT INTO med_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wu nam ti, oⱡa mana orum ei, wamp mbʉ tʉpa mana ndupa, oⱡa mel morum. Wote, wamp ti ndi, mʉi kona ila orum wamp ei, mʉi kona mel mbʉ nga nʉtʉm. Wu ti, muⱡ kona moⱡpa, mana urum wu ei, wamp wei mbʉ, tʉpa mana ndupa, elim oⱡa mel morum. ");
INSERT INTO med_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","El elim pilpa kandpa itim uⱡ mbʉ nga, akup omba pora ndupa ninim. Ei wote, wamp ti ndi, ik ninim ei pilpa, ti natʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wamp nam ti ndi, Got nga ik ei pilpa tʉpa, ambʉⱡʉm ei ndi, Got kupa morum nimba. ");
INSERT INTO med_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ei mel, Got nga tʉpa mundrum wamp ei ndi, elim nga keta tʉpa nʉtʉm. Ei nambuⱡ emel, Got nga Muⱡnga ei, elim kʉn peka ropa morum. ");
INSERT INTO med_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Got ndi, kangʉm numan ngumba kʉn, muⱡ mʉi raⱡ nga mel tetʉm mbʉ pora, elim nga kangʉm nga ki ila tinditim. ");
INSERT INTO med_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wote, wamp nam ti ndi, Kangʉm mondpa pilim ndam, uⱡ nga kʉnt nga kont mul uⱡ ei tepa morum. Wote, wamp nam ti ndi, kangʉm tʉpa pei mondum ndam, uⱡ nga kʉnt nga kont mul uⱡ ei, ti natʉmba. Got nga popʉⱡ ei omba, wamp ei kʉn moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ui ni kʉn, Jisas ndi, Jon ni, tʉpa mana ndupa, wamp minal nu tinditim. Uⱡ ei, Perisi wu nimbʉ ndi, molk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wamp minal nu tʉtʉng uⱡ ei, kitip kʉni wu ni kʉⱡ ndi, mendpʉⱡ etʉng. Jisas elim mon. ");
INSERT INTO med_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Jisas elim nga uⱡ itim nimbʉ, Perisi wu nimbʉ ndi, pʉtʉng ila, Juriya kona ni, wak ropa, Galili kona ila int mba pilpa kʉn, Sameriya kona ila unt ekit urum. ");
INSERT INTO med_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ni kʉn, Sameriya kona peng ti, mbi tek, Saikar nʉtmʉn nila urum. Kona ni unt, Jekop ndi, elim nga mʉi ti, kangʉm Josep ngurum ni, nondpa mel titim. ");
INSERT INTO med_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekop nga nu kut kona nila titim. Ant ni omba, peng im ila pelinga, Jisas nombuⱡa ruⱡ urum ei nga, kʉmp ambuⱡnga omba, nu kut ʉldʉ ila murum. ");
INSERT INTO med_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ni kʉn, Sameriya amp ti, nu kuⱡmba pilpa urum ila, Jisas ndi, kundpa nimba mel, “Na nu kot kulkʉn ngui!” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Elim nga kitip kʉni wu ni kʉⱡ, kona peng ila, rʉng rarʉp ruing purung. ");
INSERT INTO med_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wote, Sameriya amp ni ndi, punt ropa nimba mel, “Nim Jura wu, na Sameriya amp ei wote, nu kuⱡʉp ngeimp, nʉn ei ka!” nitim. Ni, Jura wamp mbʉ kʉn, Sameriya wamp mbʉ kʉn, el rui wamp morung ei nga pilpa nitim. ");
INSERT INTO med_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wote Jisas ndi, nimba mel, “Nim Got nga mel gem ngurum uⱡ mbʉ, pilkʉn mbi ndukʉn, wote na nu kulkʉn ngui nʉnt wu ei, akup kandkʉn, mbi nduⱡina ndam, wu ei kʉn, nu kot mawa etana! Wote, kont mba mul nu ei, kuⱡpa nim nguⱡnga,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Amp ei ndi, kundpa nimba mel, “Nuim ye! Nu kut kona ei, ama mandpa tetʉm. Nim nu kuⱡin ming ti kep, mon ku ei ka! Kont mba mul nu nʉn ei, nil moⱡnga kulkʉn, na nguin pilkʉn nʉn nda? ");
INSERT INTO med_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tʉn nga anda tipam Jekop ndi, nu kut kona ei, tʉn ngurum. Unt, elim kʉn, elim nga kangʉmʉl na, wote kng kau na nimbʉ ndi, norung ku. Jekop ni wu mana, nim wu oⱡa mel nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Wote Jisas ndi, punt ropa nimba mel, “Ya nu ei, kuⱡpa nom wamp ei, aldpa nu waka kuⱡmba ku. ");
INSERT INTO med_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wote, wamp nam ti ndi, nu kuⱡʉp ngamba nom wamp ei, aldpa nu waka kuⱡi naⱡʉmba. Nu kuⱡʉp ngʉnt nu ei ndi, wamp ei nga numan rukʉr orunga, nu pit kona mel raⱡpa, pukpa omba mba, mint moⱡmba. Nu ei, pukpa omba mba, mint moⱡmba ei, uⱡ nga kʉnt nga kont mul uⱡ ei, kandpa tʉpa ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amp ni ndi, nimba mel, “Nuim ei! Nu ei na ngui! Na wote, nu waka kuⱡi nʉⱡimp. Wote, na nu kuⱡimp ont uⱡ ei, ui nʉwimp mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wote Jisas ndi, amp ei, kundpa nimba mel, “Pukʉn wanʉm wu ei, ui nana, ya ila wangga!” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Amp ei ndi, nimba mel, “Na wu ti mon ei ka,” nitim. Jisas ndi, amp ni, kundpa nimba mel, “Nim wu ti mon, nʉn ei, kupa nʉn. ");
INSERT INTO med_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nim unt wu 5 kat purʉn, akup wu ti kʉn morumbil ei, wanʉm wu ti mon. Nim nʉn ik ei, kupa nʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Amp ei ndi, nimba mel, “Nuim ei! Nim Painui Wu ti pʉnt ei ka! ");
INSERT INTO med_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tʉn nga Sameriya ila anda tipam ila mbʉ ndi, ya komnga ila molk, Got nga mbi paka rondrung. Wote, enim Jura wamp mbʉ ndi, tʉn Jerusalem kona ila molk, Got nga mbi paka rundeing nʉtmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wote Jisas ndi, amp ni, kundpa nimba mel, “Na ik nʉnt ei, mondkʉn pili! Ui ti, ekit om ei kʉn, Wuta nga mbi paka runding uⱡ ei, ya komnga ila mon. Wote, Jerusalem kona ila mon ku. ");
INSERT INTO med_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Enim Sameriya wamp mbʉ, nam nga mbi paka rondʉrmin uⱡ ei, pili napilik etmin. Tʉn Jura wamp mbʉ pilpʉn, Got nga mbi paka rondʉrmʉn. Ei nambuⱡ emel, Got nga wamp etpa ti uⱡ ei, tʉn Jura wamp mbʉ kʉn ekit orum. ");
INSERT INTO med_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wote ui ti, ekit omba, ni akup ekit onum. Ei nga, Wuta nga mbi paka runding uⱡ ei, wamp mbʉ ndi, Muⱡnga Wingti ei kʉn, wote uⱡ kupa mbʉ kʉn iting. Wuta ei ndi, wamp i iti mbʉ, numan ngurum. ");
INSERT INTO med_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Got elim Muⱡnga ei nga, elim nga mbi paka rondʉk iting wamp mbʉ, Muⱡnga ei kʉn, ik kupa raⱡ nga pol ila mint, molk iteing,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Amp ei ndi, Jisas ni, kundpa nimba mel, “Mesaiya ni, Wu Kraist nʉtmin ni omba ei, na pilip mor. Omba kʉn, uⱡ mbʉ nga pora, tʉn kundpa nimba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Wote Jisas ndi, amp ni, int ndupa, nimba mel, “Nim nʉn wu ei, na akup nim kʉn, ik nimbuⱡ morumbʉⱡ ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wote, Jisas nga kitip kʉni wu ni kʉⱡ, andʉk yant ok, kandrung ei, Jisas ni, amp ti kʉn, ik nimba murum ila kandʉk rot nʉtʉng. Wote, ik nʉtʉnggil ni nga, wu ti ndi kep, waldʉk nʉk mel, “Nim namba mel numan ngʉn, muna nim amp ei kʉn, namba ik ei, nʉn nʉk kep,” waldʉk, pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Wote amp ei, nu ming ei, tepa kelpa, wi kona peng nila mba, wamp nimbʉ, kundpa nimba mel, “Wu ti ndi, na nga et uⱡ mbʉ nga puⱡ ei, pilpa kelpa ninim ei, kʉneing wʉi! Wu ei, Kraist nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wamp nimbʉ, ik ei pilik, kona peng ni, wak rok, Jisas murum kona nila orung. ");
INSERT INTO med_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wote, ant ni kʉn ku, kitip kʉni wu ni kʉⱡ ndi, Jisas kundʉk, nʉk mel, “Ik mbo wu ye! Nim rʉng ti nui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wote Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Na nga nuimp rʉng mbʉ tetʉm ei, enim pili napilik mormin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ei kʉn, kitip kʉni wu ni kʉⱡ ndi, en enim nʉk mel, “Wamp nam ti ndi, rʉng mat ngum ei nga ninim nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Na nga rʉng ei, na tʉpa mundrum wu ei nga numan pʉtʉm uⱡ mbʉ mel, teng ndup kongun ngurum ei, etʉp pora nduimp. ");
INSERT INTO med_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Enim ik ti, ei mel nʉtmin. ‘Rʉng rʉpa romba ei nga kalimp 4 petʉm,’ nʉtmin. Na enim ik ti kundʉp namp, pilik kai itʉi! Rʉng rʉpa ropa kenim ei nga, rʉng ting ui ei, nondpa enim. ");
INSERT INTO med_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Rʉng tʉm wu ei mel kaⱡmba, wote rʉng tepa, uⱡ nga kʉnt nga kont mul uⱡ ei, tʉpa mou romba. Rʉng rarum wu ei kʉn, rʉng tʉm wu ei kʉn, raⱡ kunda numan kai pilinggil. ");
INSERT INTO med_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ik kupa nʉtmin ni mel, wamp ti ndi, rʉng rarum, wote wamp ti ndi, rʉng tʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ni mel, enim kongun iti natʉtʉng. Wote, wamp elpa mat, kongun mindil nok etʉng kona ila, na ndi, enim tʉp mundunt, rʉng tʉk mek, weing pʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sameriya wamp minal ndi, Jisas kʉn mondʉk pʉtʉng. Ei nambuⱡ emel, amp ni ndi, wamp mbʉ, kundpa nimba mel, “Na nga it uⱡ mbʉ pora, pilpa mbi ndupa, ninim ik ei nga etʉng. ");
INSERT INTO med_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wote, Sameriya wamp nimbʉ, Jisas kʉn ok, rʉp ropʉn muⱡamin nʉtʉng ila pilpa, kona nila moⱡpa, rumbʉⱡ raⱡ tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Ik mbo inditim ni, wamp minal mondʉk pilik, wote amp ni kundʉk, nʉk mel, “Nim nga keta ila ik pʉnmin ni mon. Jisas elim nga keta ila ik punmʉn ei, mʉi kona wamp mbʉ nga Etpa Tʉmba Wu waⱡʉm ei, nʉmp pʉnmʉn!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Rumbʉⱡ raⱡ omba puⱡnga, Jisas Galili kona ila purum. ");
INSERT INTO med_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ni kʉn, Jisas elim ndi, nimba mel, “Painui wu ti nga mbi ei, elim nga mʉi mang kona ila, tʉk ou ndui nandʉrmin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wote Jisas ni, Galili kona ila rʉk puⱡnga, wamp morung nimbʉ ndi, rawe etʉk tʉtʉng. Ei nambuⱡ emel, Jerusalem kona ila uⱡ rʉpndi mat, Pasopa Ui ei kʉn, itim kandrung ni nga, pilik etʉng. ");
INSERT INTO med_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wote, Galili nga Keina kona ila, Jisas ndi, mbo nu tʉpa, wain rundrum ila int purum. Wote, gapman el wu ou ti nga kangʉm ei, Kaperniyum kona ila kui roⱡnga pitim. ");
INSERT INTO med_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jisas ndi, Juriya moⱡpa, Galili kona ila onum nʉtʉng ik ei, el wu ou ni pilpa, Jisas kʉn purum. Mba kʉn, kont kaimp ik ranggʉpa, “Na nga kangʉm ei, koⱡmba enim. Nim etkʉn, tʉn nʉmp timp ont,” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wote Jisas ndi, wu ei, kundpa nimba mel, “Enim uⱡ rʉpndi ou ndupa mat, kandʉk kʉn, na nga ik ei, mondʉk piling nʉnmʉn ye!” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ni kʉn, el wu ni ndi, yant ndupa, nimba mel, “Nuim ye! Na nga kang ei, kuⱡi nʉⱡangga, pili nʉkʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas ndi, wu ei, kundpa nimba mel, “Nim pi, nim nga kang ei kont moⱡmba ei ka!” nitim. Wu ni, Jisas nga ik ni, mondpa pilpa kʉn, wote purum. ");
INSERT INTO med_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kokila puⱡnga, elim nga kongun wu nimbʉ ndi, yant ok, nʉk mel, “Nim nga kang ei kont morum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kang ei nga tipam ei ndi, waldpa nimba mel, “Kui nant kʉn, wang nimba?” waldinga. Elim nga kongun wu nimbʉ ndi, nimba mel, “Ukʉ ou runggilmʉ kui ropa wang nim,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kang ei nga tipam ni ndi, ui ei kʉn, Jisas ndi, elim kundpa nimba mel, “Nim nga kangnʉm kont moⱡmba,” nitim. Ik niting ni kʉn, pilpa mbi ndurum. Ni kʉn, elim kʉn, elim nga wamp mbo kʉⱡ pora, Jisas kʉn mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas ni, Juriya kona moⱡpa, Galili kona yant urum ei kʉn, uⱡ rʉpndi raⱡ itim. ");
INSERT INTO med_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Got ndi, Jura wamp etpa titim ei nga, kor muⱡing ui nila, Jisas Jerusalem kona ila purum. ");
INSERT INTO med_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem ku paⱡa petʉm ei nga, sipsip keta puⱡ puⱡ nʉtmin ʉldʉ orunga, nu num ti morum. Ei, Ipru ik ila mbi tek, ‘Betseita,’ nʉtmin. Kona ila, kʉpkʉ tʉk mormʉn manga 5 kat ʉnggʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ni kʉn, kui wamp minal kui ropa, mong tʉpa, on por moⱡpa itim wamp nimbʉ, nu num ei, pʉnin nimba omba nʉk, kʉpkʉ manga nimbila, nokundʉk pek morung. ");
INSERT INTO med_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nu num nila, ui mat kʉn, Got nga anggelo ti ndi, mana omba, nu ni ropa orung orung elinga. Kui wamp ti ndi kandpa, kuimp tepa mana puⱡnga, namba kui ti pitim ndam, kui ei pora nitim. ");
INSERT INTO med_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wote kona nila, kui rurum wu ti, pepa pana 38 tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas ndi, wu ni, pana ui mbʉ nga ou ndupa, tepa mundrum ila kandpa, nimba mel, “Nim nga kui ei, wang nangga nʉkʉn pʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wote, kui wu ni ndi, punt ropa nimba mel, “Wu Nuim ye! Na tʉk mek puk, num ila munding wamp ti mon. Nu pʉnin nimba oⱡnga, mana mbi nimp et ei kʉn, wamp ti ndi ku, kuimp tepa omba, mana purum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wote Jisas ndi, wu ni kundpa nimba mel, “Nim oⱡa anggilkʉn, nim nga rupⱡaima kʉⱡ, tʉkʉn mekʉn, nombuⱡa mam pi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ei mel nilinga, tʉngʉnda mint, wu ni nga kui ni pora nilinga, rupⱡaima ni kʉⱡ, tʉpa mepa purum. Mowi kor kʉn uⱡ ei itim. ");
INSERT INTO med_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ei nga, Jura wamp nimbʉ ndi, kui wang nitim wu ni, kundʉk nʉk mel, “Mowi kor ei kʉn, nim nga rupⱡaima kʉⱡ, men uⱡ ei ndi, tʉn nga Mi Ik petʉm uⱡ ei, nim ndi, rokʉn puⱡa ron ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wote, wu ni ndi, punt ropa, nimba mel, “Na etpa tʉm wu ei ndi, ‘Na nga rupⱡaima kʉⱡ tʉkʉn, mekʉn pi nim wu ei mel’, tʉp mep mbi ont!” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wote, wu ni, waldʉk nʉk mel, “Nim rupⱡaima ei, tʉkʉn mekʉn pi nim wu ei, ei nam?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kui wang nitim wu ni ndi, Jisas pilpa mbi ndui nʉndrʉm. Ei nambuⱡ emel, Jisas ni, wamp minal pitim nila, mo ropa omba, ekit mba purum. ");
INSERT INTO med_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wote, manga wingti ou nila, Jisas murʉk mba, wu ni kandpa, wote nimba mel, “Nim nga kui pora nim ei, kan mon! Nim uⱡ kit mat, aldpa iti nʉti! Muna in ndam, uⱡ kit minal mat, nim kʉn pemba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wote, wu ni ndi, pilpa int mba, Jura wu nimbʉ kundpa nimba mel, “Na etpa tʉm wu ni nga mbi Jisas,” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ni kʉn, Jisas ndi, mowi kor kʉn itim ei nga, Jura wu nimbʉ ndi, ik mura nguimin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wote Jisas ndi, punt ropa nimba mel, “Na nga Wuta kongun rʉk rʉk etpa mint morum. Ei nga, na kongun etʉp ku mor,” nitim. ");
INSERT INTO med_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jura wu nimbʉ ndi, ik ni pilik, kit pilik, wu ei ndi, tʉn nga mowi kor ei nga, mi ik ei, puⱡa ropa, Got kundpa Wuta nimba, elim Got mel ranʉm wu ei, ropʉn kundmun, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Wote Jisas ndi, ik punt ropa, nimba mel, “Enim ik kupa ei kundʉp nʉnt. Got kangʉm ei ndi, elim nga numan ila, uⱡ ti etmba mel kapⱡa mon. Got kangʉm ei, Tipam nga kitip kandpa kongun etʉm. Tipam nga nambuⱡ ti etʉm ei, kangʉm etʉm ku. ");
INSERT INTO med_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Got ndi, kangʉm ei, numan ngumba. Wote, elim nga etʉm uⱡ mbʉ, tʉpa ora ndurum. Akup uⱡ enim kanmin ei mel, uⱡ mbi pi minal mat, kangʉm kʉn etpa ora ndangga. Wote enim kandʉk, min ngʉn munding. ");
INSERT INTO med_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Got ndi, wamp kui mbʉ, ropa rut ndupa, etpa kont mundrum. Ei mel ku, elim nga kangʉm ei ndi, i ku etpa, wamp nam ti, elim nga numan ei ndi, pilim ei mel ku, etpa kont mundʉmba. ");
INSERT INTO med_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Got ndi, wamp uⱡ eng ei mel kandpa, kʉmp ti natʉmba. Wamp kʉmp ti uⱡ ei, kangʉm itangga nimba, ambuⱡpa ngurum. ");
INSERT INTO med_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ei nga, wamp mbʉ ndi, Got tʉk ou ndurmin ei mel, elim nga kangʉm ei, i ku etʉk, tʉk ou ndeing nimba itim. Elim nga kangʉm ei, tʉpa ou ndui nandʉm. Wote wamp ti, kangʉm tʉpa mundrum Tipam ei kep, tʉpa ou ndui nandrʉm ku. ");
INSERT INTO med_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na ndi, ik kupa ei nʉnt! Na nga ik ei, pilpa tʉpa, wote na tʉpa mundrum wu ei, mondpa pilim wamp ei, uⱡ nga kʉnt nga kont mul uⱡ ei, tepa morum. Wamp ei nga uⱡ kit etʉm mbʉ, kʉmp ti natʉmba. Wamp ei ndi, wamp kui nga uⱡ ei, wak ropa, akup uⱡ nga kʉnt nga kont mul uⱡ ei, moⱡmba ei nga morum. ");
INSERT INTO med_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na ndi, ik kupa ei nʉnt. Ui ti omba, ei mel akup onum. Wamp kui mbʉ ndi, Got Kangʉm ei nga, ik ei piling. Wote kum tek piling wamp mbʉ, kont puk muⱡing. ");
INSERT INTO med_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kont mul uⱡ ei, Got elim kʉn puⱡ petʉm. Ei mel ku, elim nga Kangʉm ei, i ku etpa, ronduⱡ nguⱡnga, kont mul uⱡ ei nga puⱡ petʉm ku. ");
INSERT INTO med_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Elim nga Kangʉm ei ndi, wamp mbʉ, kʉmp tʉmba ei nga ronduⱡ ei ngurum. Ei nambuⱡ emel, wu ei elim ndi, Muⱡʉl Wu Kupa ei. ");
INSERT INTO med_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ik nʉnt ei pilik, min ngʉn mundi nʉmundʉi! Nambuⱡ emel, ui ti om ei kʉn, on kona ila petmin wamp mbʉ, elim nga ik ei pilik, wote on kona ei, wak rok ekit uing. Uⱡ kai etʉng wamp mbʉ, kont puk muⱡing. Wote, uⱡ kit etʉng wamp mbʉ, etpa kit mondʉmba. ");
INSERT INTO med_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na ndi, nanim nga ronduⱡ ila, uⱡ ti kapⱡa iti nʉtimp. Wamp kʉmp timp uⱡ ei, Got ndi, nʉtʉm ei mel itimp. Ei nga, na nga wamp kʉmp timp uⱡ ei, kun mba tetʉm. Ei nambuⱡ emel, na nga numan ei ndi, uⱡ ti itimp nʉmp iti natʉnt mon. Na tʉpa mundrum Wu ei nga numan ila, pep rop ent. ");
INSERT INTO med_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na ndi, na nanim nga orunga mint nʉmp mot ndunt ndam, enim ndi pilangina, ik nʉnt ei nga ronduⱡ ti, pi napʉmba. ");
INSERT INTO med_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wamp ti morum ei ndi, na nga nimba mot ndupa, ik kun mint ni nʉndʉtʉm. Wote na pʉnt ei, na nga nimba mot ndurum ik mbʉ, kupa mint. ");
INSERT INTO med_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Enim ndi, nombuⱡa rung wu kat, Jon kʉn tʉk munduⱡngina, ik kupa ei nga, nimba mot ndurum. ");
INSERT INTO med_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mʉi kona wamp ti ndi, na nga ik ei kandʉk, pilik nʉnding mel mon. Na ik nʉnt ei ndi, enim etpa tangga, nʉmp nʉnt. ");
INSERT INTO med_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ni, lam mel, nomba rʉⱡang puⱡnga, ui onunga ni kʉn, enim Jon nga rʉⱡang ila, molk ambulk palk morung. ");
INSERT INTO med_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wote uⱡ ti, Jon ropa mana ndupa, na nga orunga nimba, mot ndupa nʉtʉm. Ei uⱡ elpa ti mel, Wuta ndi, na kongun ngurum et, ei nga kongun nit ei ndi, nimba mot ndupa, Wuta ndi, na tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na tʉpa mundrum Wuta ei ndi, na nga orunga nimba, mot ndurum ku. Wote, elim nga ik ei, enim ndi, pili napʉtmʉn. Elim morum ei kep, kʉni nakʉndʉrmin ku. ");
INSERT INTO med_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wote, elim nga ik ei, enim nga rukʉr orunga ti natʉtʉm. Ei nambuⱡ emel, elim nga tʉpa mundrum wu ei, enim ndi, mondʉk pili napʉtmin. ");
INSERT INTO med_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Enim ndi, uⱡ nga kʉnt nga kont mul uⱡ ei, kandʉk timin nʉk, Buk Wingti kʉⱡ, rʉk rʉk kandʉrmin. Ei wote, Buk Wingti nga nʉtʉm ik puⱡ ei, na kʉn petʉm. ");
INSERT INTO med_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wote, enim uⱡ nga kʉnt nga kont mul uⱡ ei, kandʉk ting ei nga, enim na kʉn ui nawʉrmʉn, ei ka! ");
INSERT INTO med_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na enim wamp mbʉ nga mbi ou ngurmʉn uⱡ ei, ti natʉt mon. ");
INSERT INTO med_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wote, enim nga mundmong ila, Got numan ngui nganggʉk, mormʉn uⱡ ei, na pilip mor. ");
INSERT INTO med_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Wuta nga ronduⱡ ila, omp ik nilmba. Enim ndi, ik ei, pilik ti natʉtmʉn. Wote wamp ti, elim nga ronduⱡ ila, omba ik nilinga ndam, ik ei, pilik tilingina. ");
INSERT INTO med_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Got ndi, kaip nʉndangga, ni nandʉk. Enim wamp mbʉ ndi, kaip nindeing nʉk etmin. Namba etʉk, enim ndi, na mondʉk piling. ");
INSERT INTO med_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na ndi, enim nga puⱡ orunga, Wuta kʉn nimp kit mundimp, nʉk pili nʉpilʉi! Enim Moses ndi, uⱡ ti endʉmba, nʉk pilik mormʉn. Wu ei ndi, enim nga puⱡ orunga nimba, kit mondʉmba. ");
INSERT INTO med_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses nga ik ei, kupa nʉk, pilingina ndam, na nga ik ei, pilik tilingina ku. Wu ei ndi, na nga ik ei, mon ropa pinditim. ");
INSERT INTO med_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wote, ik mon rurum mbʉ, mondʉk pili napʉtʉng. Ei kʉn wote, na nga ik ei, namba etʉk, mondʉk piling?” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wote, Jisas ni, num Galili noi orunga int purum. Num ei nga mbi ti kundʉk, ‘Taipiriyus’, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wamp mam ti, Jisas purum mel, akil tek purung. Nambuⱡ emel, Jisas ndi, uⱡ rʉpndi mat etpa, kui peng itim wamp mbʉ, etpa titim kandrung. ");
INSERT INTO med_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wote, Jisas komnga ila oⱡa mba, elim nga kitip kʉni wu ni kʉⱡ kʉn, rʉp rok morung. ");
INSERT INTO med_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ui ni kʉn, Jura wamp nga Pasopa, Rʉng Ou Nuing ui ei, nondpa itim. ");
INSERT INTO med_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas moⱡpa kʉndrʉm mel, wamp minal, elim pep rok, orung kandpa, wu Pilip kundpa nimba mel, “Rʉng mat nant ila, kandʉp tʉpʉn, ya wamp kʉⱡ, rʉng ruimin nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ik ei, Pilip oⱡa tʉpa, kanʉmba pilpa nitim. Elim uⱡ etmba ei mel, pilpa pora ndupa murum. ");
INSERT INTO med_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Wote Pilip ndi, ik punt ropa nimba mel, “Tʉn ku moni K200 ei mel, rʉng bret timin ndam, wamp mormʉn mbʉ ndi, rʉng mint rok nuing mel, kapⱡa mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Kitip kʉni wu ti, Saimon Pita nga ʉngʉn Andru ndi, nimba mel, “Kang ti, bret 5 kat kʉn, oma raⱡ tepa morum ei ndi, wamp minal kʉⱡ kʉn, kapⱡa etmba nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ni kʉn, Jisas ndi, kitip kʉni wu kʉⱡ, kundpa wamp mbʉ, mana muⱡeing nʉi, nitim. Kona kai titim nila, wamp nimbʉ, mana morung ila, wu 5000 mel morung. ");
INSERT INTO med_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Wote Jisas ndi, bret ni tʉpa ambuⱡpa, Got kʉn angge nimba, puk ropa wamp morung nimbʉ, neing nimba, ngurum. Wote, oma ni raⱡ i ku etpa, oⱡa tʉpa angge nimba, gurpa wamp nimbʉ, neing nimba, ngurum ku. Wamp nimbʉ rʉng noⱡʉngina, pilʉng elinga, mana titim. ");
INSERT INTO med_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rʉng noⱡʉngina, mana titim nimbʉ, Jisas ndi, kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Rʉng nonmʉn mbʉ nga, mana tʉnʉm mbʉ, tʉk rʉkʉlʉi! Rʉng ti etʉk, ge ndui nʉndʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wote, bret 5 kʉⱡ nga wamp mbʉ ndi, noⱡʉngina mana titim mbʉ, tʉk rakilingina, wal 12 peka rurum. ");
INSERT INTO med_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ni kʉn, uⱡ rʉpndi Jisas ndi, itim ni, wamp mbʉ ndi, kandʉk nʉk mel, “Painui wu ti, mʉi kona ila mana omba nʉtmin ni, omba morum kanmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas ni, pitim mel, wamp mbʉ ndi, ronduⱡ mundʉk, elim tʉk, wu nuim mumuk munding, elingina pilpa, komnga nila, elim kou kiyang nimba, int purum. ");
INSERT INTO med_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wote, epindama elinga, Jisas nga kitip kʉni wu nimbʉ, num ʉldʉ nila purung. ");
INSERT INTO med_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Puk, nu kanu nila rukrʉng puk, num ei, puⱡa rok, Kaperniyum kona ila ping purung. Kona ni, rumbʉⱡ roⱡnga, Jisas ni, ama ui nʉwʉrʉm. ");
INSERT INTO med_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ni kʉn, kʉpkʉ ambuⱡpa pilpa roⱡnga, nu ni, ropa mbʉ, nuwa kuⱡpa kara purum. ");
INSERT INTO med_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wote, kitip kʉni wu ni kʉⱡ, num rʉk ting ila puk, kandrung mel, Jisas ni, nu ndi, pol ila kʉmp kambilpa, nondpa oⱡnga kandʉk, mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wote Jisas ndi, kundpa nimba mel, “Mundmong iti nʉtʉi! Na ont ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kandʉk kʉn, numan wang nduk, Jisas ni, nu kanu ila, oⱡa wangga nʉk, pilik moⱡʉngina, wote tʉngʉnda mint, nu kanu ni kʉⱡ, ping orung kona ila, mba rʉk purum. ");
INSERT INTO med_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mʉkʉlmʉ orunga, num noi orunga, morung wamp nimbʉ ndi kandrung. Nu kanu tenda kat titim ni kʉⱡ, ti nʉtʉtʉm. Ni kʉn, tʉk mendʉk pʉtʉng ei, kitip kʉni wu ni kʉⱡ mendpʉⱡ, nu kanu ila purung. Wote Jisas ni, kunda pi naprʉng. ");
INSERT INTO med_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wʉl Taipiriyus kona ila nga nu kanu mat, Jisas ndi, angge nimba, wamp rʉng ngurum kona nila, nondpa orung. ");
INSERT INTO med_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wote wamp nimbʉ kandrung mel, Jisas kʉn, elim nga kitip kʉni wu ni kʉⱡ pora, muⱡi nambʉrʉng. Nu kanu titim nimbila, ok rʉk puk, Kaperniyum kona nila kurʉk purung. ");
INSERT INTO med_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wote, wamp nimbʉ ndi, Jisas nu noi orunga, puk kandʉk tʉk, waldʉk nʉk mel, “Ik Mbo Wu ye! Nim nant kʉn ya ila un?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wote, Jisas ndi, punt ropa, nimba mel, “Na ndi, ik kupa enim kundʉp nʉnt. Enim bret nok, pʉlʉng kundʉk, eng ni nga mendpʉⱡ, na kurʉk onmʉn. Wote, uⱡ rʉpndi mat int nimbʉ nga, enim tʉk mindi namindʉnmʉn. ");
INSERT INTO med_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Rʉng purpa moⱡmba mbʉ nga, kongun iti nʉtʉi! Rʉng kai uⱡ nga muⱡing ei nga, kongun indʉi! Rʉng ei, Muⱡʉl Wu Kupa ei ndi, enim ngumba. Uⱡ ei, Got Tipam ndi, unt tip timal mundpa, Muⱡʉl Wu Kupa ei kʉn, etpa ronduⱡ mundpa pinditim,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wote, wamp mbʉ ndi, Jisas waldʉk, “Tʉn namba uⱡ ti etpʉn kʉn nʉk mel, Got nga kongun indʉmin nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisas ndi, punt ropa, nimba mel, “Enim kongun ti iting ei, Got elim ndi, tʉpa mundrum wu ei, mondʉk pilʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wamp mbʉ ndi, ik punt rok, nʉk mel, “Nim nambuⱡ ti rʉpndi ronduⱡ ti, etana kandpʉn, nim mondʉp pilmin nda? Namba uⱡ ti itin pilkʉn nʉn nda? ");
INSERT INTO med_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unt, tʉn nga anda kouwʉmin mbʉ ndi, kona kui waka ila rʉng ti, mbi tek, ‘mana,’ nʉtmin ei norung. Buk Wingti ila nʉtʉm ei mel, ‘Muⱡ kona bret ei nga nguⱡnga norung,’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wote, Jisas ndi, punt ropa, nimba mel, “Na ndi, enim ik kupa ei kundʉp nʉnt. Moses ndi, enim muⱡ kona bret ei, tʉpa ngui ngʉnggrʉm. Wote na nga Wuta ndi, enim muⱡ kona bret kupa ei, tʉpa ngorum. ");
INSERT INTO med_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Got ndi, muⱡ kona bret ngurum ei ndi, ya mʉi kona ila wamp mbʉ, kont mul uⱡ ei ngorum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wote, wamp nimbʉ ndi, nʉk mel, “Nuim ye! Nim ndi, bret ei nga, tʉn rʉk rʉk ngui!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Kont mul uⱡ ei nga bret, ei na! Wamp ti, na kʉn om ndam, kump kun kuⱡi naⱡʉmba. Na mondpa pilim wamp ei, nu waka kuⱡi naⱡʉmba. ");
INSERT INTO med_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wote na ndi, enim kundʉp nit ni, na kanung, wote mondʉk pili napʉnmʉn. ");
INSERT INTO med_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wuta ndi, na ngurum wamp mbʉ pora, na kʉn uing. Wote, na kʉn ong wamp mbʉ, tʉp mbuⱡ ngui ngʉngimp. ");
INSERT INTO med_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ei nambuⱡ emel, na muⱡ kona wak rop mana ur ei, nanim ndi, ui nʉwʉr. Wuta nga numan pʉtʉm uⱡ ei, pep rop itimp pilip ur. ");
INSERT INTO med_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wuta ndi, numan ei mel pilpa, na tʉpa mundrum. Na ngurum wamp mbʉ nga ti, wak rui narup, wote ui pora nim kʉn, wamp mbʉ rop rut ndup, kont mul uⱡ ei nguimp. ");
INSERT INTO med_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na nga Wuta ndi, uⱡ ti pʉtʉm ei, wamp namin mat ndi, kangʉm ei kandʉk, mondʉk pʉtʉng wamp mbʉ, uⱡ nga kʉnt nga kont mul uⱡ ei ting. Wote, ui pora nim kʉn, na ndi, wamp mbʉ rop rut ndup, kont mul uⱡ ei nguimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ni kʉn, Jura wamp nimbʉ ndi, ik rombulk nʉtʉng. Ei nambuⱡ emel, Jisas ndi, kundpa nimba mel, “Na muⱡ kona nga, bret ei, mana ur,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wamp mbʉ ndi, nʉk mel, “Wu ei Jisas, Josep kangʉm nimbun, kanmin ei? Wote, wu elpa nda? Tʉn ndi, mam tipam raⱡ kandʉrmin. Ni wote, elim muⱡ ila mana ur ninim ei, etpa ninim, mel nant nda,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wote Jisas ndi, punt ropa, nimba mel, “Ik tek rombulk ni nʉnʉi! ");
INSERT INTO med_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wamp ti, na kʉn numa ui nawʉmba. Na tʉpa mundum Wuta ei ndi, tʉpa mundangga, na kʉn omba. Wote na ndi, wamp ei, ui pora nim kʉn, rop rut ndup, kont mundimp ");
INSERT INTO med_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Unt painui wu mbʉ nga, mon ti rorung petʉm ei ndi, nimba mel, ‘Got ndi, wamp mbʉ, elim ndi, ik mbo endʉmba,’ nʉtʉng. Wuta nga ik ei pilik, tʉk pep rong wamp mbʉ, na kʉn uing. ");
INSERT INTO med_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ik nʉnt ei ndi, nʉmp kʉn wamp ti ndi, Got kʉndrʉm ni nanʉnt mon! Got kʉn moⱡpa, mana urum Wu ei ndi mendpʉⱡ, Got kandrum. ");
INSERT INTO med_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Enim ik kupa ei kundʉp nint. Wamp ti, mondpa pilpa moⱡum ti, uⱡ nga kʉnt nga kont mul uⱡ ei, tʉpa tepa morum. ");
INSERT INTO med_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Uⱡ nga kʉnt nga kont mul uⱡ ei nga bret ei, na. ");
INSERT INTO med_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Unt, enim nga anda kouwʉ mbʉ ndi, kona kui waka ila, rʉng mbi tek, ‘mana’ nʉtmin ni, nurung. Ni kʉn wote, kolk ketʉng. ");
INSERT INTO med_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wote, muⱡ kona bret mana urum ei, elpa ti mel, wamp ti nom ndam, kuⱡi naⱡʉmba. ");
INSERT INTO med_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na muⱡ kona kont mba mul bret ei, mana ur. Wamp ti, bret ei, tepa nom ndam, kont moⱡpa mint mba. Na ndi, bret ngʉmp nʉnt ei, na nga kʉng ei. Ei, tʉpa nom wamp ti, uⱡ nga kʉnt nga kont moⱡpa mint mba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wote, Jura wu nimbʉ ndi, ik ni pilik kit pilik, tek rombulk, nʉk mel, “Ya wu ei ndi, elim nga kʉng ei, tʉn ngangga! Wote tʉpʉn nʉmʉn ninim ei, etpa ninim mel nant nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Wote Jisas ndi, kundpa nimba mel, “Enim ik kupa ei, kundʉp nʉnt. Wamp ti ndi, Muⱡʉl Wu Kupa ei nga kʉng ei kʉn, mema ei kʉn, tʉpa nui nanʉm ndam, kont mul uⱡ ei, wamp ei kʉn pi napʉmba. ");
INSERT INTO med_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na nga kʉng ei kʉn, mema ei kʉn, tʉpa nom wamp ei, uⱡ nga kʉnt nga kont mul uⱡ ei tʉpa tepa morum. Wote, ui ei pora nim kʉn, na ndi, wamp ei, rop rut ndup, tʉp oⱡa mundimp. ");
INSERT INTO med_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na nga kʉng ei, rʉng kupa ingk ei. Omba, na nga mema ei, nu kupa ingk ei. ");
INSERT INTO med_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wamp ti ndi, na nga kʉng ei kʉn, mema ei kʉn, tʉpa nom wamp ei, na kʉn moⱡangga! Wote, na wamp ei kʉn muⱡimp. ");
INSERT INTO med_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na tʉpa mundrum Wuta ei, rʉk rʉk kont morum. Ei mel ku, na mor. Uⱡ ei mel ku, na tʉpa nom wamp ei, rʉk rʉk kont moⱡmba. ");
INSERT INTO med_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Muⱡ kona mana urum bret kupa ei, na mor. Unt, enim nga anda kouwʉ kʉⱡ ndi, bret ti norung, wote kolk ketʉng. Wote wamp ti ndi, muⱡ kona mana urum bret kupa ei, nom ndam, kont moⱡpa mint mba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas ndi, Kaperniyum kona ila manga wingti kel ila, wamp ik mbo endpa moⱡpa, ik kʉⱡ nitim. ");
INSERT INTO med_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Elim nga kitip kʉni wu ou ndupa ndi, ik nitim mbʉ, pilik molk nʉk mel, “Ik ronduⱡ mat mbo endnim. Wamp nam ti ndi, ik mbʉ pilpa tʉmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas wamp numan kandrum ei ndi, ik nʉtʉng ni pilpa nimba mel, “Ik ei ndi, enim nga numan orunga, mbun ngunum nda? ");
INSERT INTO med_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","I ndam, Muⱡʉl Wu Kupa ei, elim moⱡpa mana urum kona ila kʉnangina, kelpa int pum ndam, enim etʉk piling mel nant? ");
INSERT INTO med_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Got nga Muⱡnga ei ndi, kont mul uⱡ ei ngorum. Wamp nga ronduⱡ ei ndi, uⱡ ingk ti, iti natʉtʉm. Na nʉnt ik ei ndi, Got nga Muⱡnga enim ngump. Wote, uⱡ nga kʉnt nga kont mul uⱡ ei, kunda ngʉnt. ");
INSERT INTO med_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jisas elim kʉn, mondʉk pili napilik iting,” nitim. Wu mbʉ kʉn, wote wu ti, elim reing nimba, rʉk moⱡmba ei, unt kuimp tepa pitim. Ei nga, Jisas ndi, wu nimbʉ, kundpa nimba mel, ‘Enim wu mat mondʉk pili napʉnmin,’” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wote Jisas ndi nimba mel, “Uⱡ ei nga wamp ti, na kʉn kapⱡa ui nawʉmba. Wuta ndi, etpa kapⱡa endim ti, na kʉn omba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ik nitim ei nga, rup rok andrʉng wamp nimbʉ nga mat ndi, Jisas wak rok, mondʉk kelik purung. Wote aldpa, Jisas murum ila, yant ui nawʉrʉng. ");
INSERT INTO med_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wote Jisas ndi, elim nga kitip kʉni wu 12 ni kʉⱡ, waldpa nimba mel, “Enim i ku etʉk, na wak rok ping ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita ndi, punt ropa, nimba mel, “Wu Nuim ye! Tʉn nam kʉn mbin? Uⱡ nga kʉnt nga kont mul uⱡ ei nga ik ei, nim tekʉn morʉn. ");
INSERT INTO med_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ei nga, akup tʉn pʉnmʉn ei, nim Wu Wingti ti, Got kʉn molkʉn, urʉn nʉmp mondpʉn pʉnmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wote Jisas ndi, punt ropa, nimba mel, “Na ndi, enim wu 12 ni kʉⱡ, kʉmp rop tit. Ei nga, wu tenda ti, kur kit ei mondpa morum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ik nitim ni, Juras, Saimon Iskariyot nga kangʉm kundpa nitim. Juras ei, elim nga kitip kʉni wu 12 ni kʉⱡ nga ti, wote Jisas rʉk murum. ");
INSERT INTO med_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wote Jisas ni, Galili kona orunga andpa kʉn, Juriya kona ila pi naprʉm. Ei nambuⱡ emel, Jura wu mat ndi, elim rok kunding pilik etʉng. ");
INSERT INTO med_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Jura wamp mbʉ nga manga kouwʉ rok, kor mormʉn ui ou ei, nondpa elinga, Jisas nga ʉngʉnʉl mbʉ ndi, elim kundʉk, nʉk mel, “Nim ya kona ei, wak rokʉn, Juriya kona ila pi! Wote, nim pep rormin wamp mbʉ ndi, nim uⱡ rʉpndi mbʉ itana kʉneing. ");
INSERT INTO med_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wamp ti ndi, elim kandʉk, neing nimba pʉtʉm. Wote elim ndi, uⱡ mbʉ tʉpa pena ila, pendpa etʉm. Nim ndi, i etkʉn uⱡ mbʉ in ndam, muⱡ uⱡ mbila, nim nga mbi ei piling,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Wote, elim nga ʉngʉnʉl nimbʉ ndi, i ku etʉk, elim kʉn mondʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas ndi, nimba mel, “Na mbi ei nga ui mendpʉⱡ ei, ekit ui nawʉm. Wote ui nant mbila, enim kapⱡa ping mint. ");
INSERT INTO med_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mʉi kona wamp mbʉ ndi, enim numan nguing, wote na numan ngui ngʉnging. Nambuⱡ emel, na ndi, wamp mbʉ nga uⱡ etmin mbʉ, nʉmp kit mondʉr. ");
INSERT INTO med_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Enim wʉl rʉng nok mormʉn kona ila, muⱡeing pʉi! Wote na pi nʉpimp. Ei nambuⱡ emel, na nga ui ei kokila,” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ik ei mel nimba pendpa, kelpa wʉl Galili kona ila, int murum. ");
INSERT INTO med_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wote, elim nga ʉngʉnʉl mbʉ, kor morung ila puⱡʉngina, Jisas ila purum ku. Mot nga pi nʉprʉm, wote mo ropa purum. ");
INSERT INTO med_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kor morung ui ou ni kʉn, Jura wu nimbʉ ndi, wamp mbʉ waldʉk nʉk mel, “Jisas ni, nil morum?” nʉk, andʉk kurʉrʉng. ");
INSERT INTO med_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ni kʉn, wamp minal ndi, ol wal tek nʉk mel, “Wu ei, wu kai ei,” nʉtʉng. Mat ndi, nʉk mel, “Wu ei ndi, wamp mbʉ tʉpa wʉlʉ mundrum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wamp morung nimbʉ ndi, Jura wu nuim mbʉ nga mundmong etʉk, ik ei, mot nga ni nandʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kor morung ui ni omba, rʉk ting ila pelinga, Jisas ni manga wingti ou nila, murʉk mba wamp mbʉ kʉn, puⱡ mondpa ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jura rʉp wu nimbʉ ndi, min ngʉn mundʉk nʉk mel, “Wu ei ndi, ik wengʉndʉpa, ronduⱡ mat ninim mbʉ, nam ndi, mbo rondum nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wote Jisas ndi, punt ropa, nimba mel, “Na ndi, enim ik mbo endint mbʉ, nanim nga numan ila pilip ni nanʉnt, mon. Wote na tʉpa mundrum Wuta ei ndi, ik mbo endilinga nʉnt. ");
INSERT INTO med_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wamp ti ndi, Got nga numan pʉtʉm ei mel, pep rop itimp nimba, pilim ndam, na ndi, ik mbo endʉnt mbʉ, Got kʉn pepa onum, muna na nga numan ila pilip nʉnt nda? Ei pilpa, mbi ndumba. ");
INSERT INTO med_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wote wamp ti, elim nga numan ila pilpa ik nʉtʉm ni, elim nga mbi paka rundeing nimba etʉm. Wote, wamp ti ndi, elim tʉpa mundrum wamp ei nga mbi, paka rundeing nimba, pʉtʉm wamp ei, kun kai morum. Uⱡ ⱡawa ti mon. ");
INSERT INTO med_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Unt, Moses ndi, enim mi ik nimba ngurum pʉtmʉn. Ni kʉn wote, enim wamp ti ndi, pep rui narʉrmin. Ei nga, nambuⱡ emel, enim ndi, na rok kunding enmin?” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wote, wamp nimbʉ ndi, punt rok nʉk mel, “Nim kur kit ti, mondkʉn morʉn! Nam ndi, nim ropa kondʉmba enim?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ni kʉn, Jisas ndi, nimba mel, “Na ndi unt, uⱡ rʉpndi ou ti elimba, enim kandʉk rut nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ndi, wamp kʉng kupti uⱡ ei nga iteing nitim. Ei Moses ndi, iti nʉtʉtʉm. Uⱡ ei, unt anda kouwʉmʉn mbʉ nga etʉng. Ei nga, enim ndi, mowi kor kʉn, kang mbʉ kʉn, kʉng kupti uⱡ ei etmin. ");
INSERT INTO med_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Enim ndi, Moses nga mi ik ei, ropʉn puⱡa rui nʉrmʉn. Nʉk kʉn, wamp kʉn kʉng kupti uⱡ ei, mowi kor kʉn etmin. Wote na ndi, wu ti nga kʉng ei, mowi kor kʉn, etʉp kai mundunt. Ei nga, nambuⱡ emel, popʉⱡ kʉnmin? ");
INSERT INTO med_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Enim ndi, mong raⱡ ndi mendpʉⱡ, kandʉk kʉmp ti nʉtʉi! Uⱡ kupa mendpʉⱡ ila, kandʉk kʉmp tʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ni kʉn, Jerusalem wamp mat ndi, molk waldʉk nʉk mel, “Wu ei, ruing nʉtmin wu ndi nda? ");
INSERT INTO med_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kʉnʉiya! Wamp nga num ila ik ninim mat ndi, ik punt rui narʉnmin ei ka! Got Nga Ngurum Wu ei, Kraist pilik kun enmin nda? ");
INSERT INTO med_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wote, Got Nga Ngurum Wu ei, om ndam, kona nant ila moⱡpa omba uⱡ ei, wamp ti ndi, pili napilmba. Wu ei moⱡpa, onum kona ei, tʉn pora pʉtmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Jisas ndi, manga wingti ou ila wamp mbʉ, ik mbo endpa, ik ronduⱡ mundpa, nimba mel, “Enim ndi, na kandʉrmin. Wote, na nga mang kona enim pʉtmʉn. Wote, na omp mor uⱡ ei, na nga ronduⱡ ila mon. Wuta, muⱡ ila wu kupa morum ei ndi, na tʉpa mundrum. Wu ei, enim ndi, pili napʉtmʉn. Wote na pilip mor. Ei nambuⱡ emel, na wu ei kʉn moⱡʉp ur. Wote wu ei ndi, na tʉpa munduⱡnga ur,” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wote, tʉp imp muⱡmin nʉk etʉng. Ei nga wote, elim nga ui ei, kokila itim ila, wamp ti ndi, imp muⱡi nʉmbrʉng. ");
INSERT INTO med_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wamp num pitim nila mat ndi, ik nitim ni, pilik tʉk nʉk mel, “Wote Got nga ngurum wu ei, om ndam, ya wu ei, enim ei mel, uⱡ rʉpndi mat minal etmba nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wamp minal nimbʉ, Jisas nga nitim ik nimbʉ wamp ndi, ol wal tek nʉtʉng. Perisi na, wu Pris kuimbal nimbʉ ndi pilik, Jisas tʉk imp muⱡeing nʉk, el wu nimbʉ, tʉk mundrʉng. ");
INSERT INTO med_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas ndi, nimba mel, “Na ui orunga kot, enim kʉn moⱡʉp, wote na tʉpa mundrum wu ei kʉn, kelip mbi. ");
INSERT INTO med_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Enim ndi, na andʉk kurung. Wote, na kandʉk ti nʉtʉng. Na mbi ent kona ila, enim pi nʉping,” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jura wu nimbʉ ndi, en enim nʉk mel, “Wu ei, nant tila pangga, tʉn ndi, kurmin ei nga ninim nda? Tʉn nga Jura wamp mat, wʉl Grik kona ila petmin wamp mbʉ kʉn, mba Grik wamp ik mbo endʉmba, ninim nda? ");
INSERT INTO med_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Elim ndi nimba mel, ‘Tʉn ndi, elim andʉp kurmin, wote kandʉp ti nʉtmin,’ nitim. Wote, ‘Elim mbo munt kona ila, kapⱡa ui nʉwing,’ nitim. Ik ei, etpa ninim mel nant nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kor molk munding etʉng ui ou ila, Jisas oⱡa anggilpa, ik oⱡa mundpa, nimba mel, “Wamp ti, nu waka em ndam, na kʉn omba nu nangga! ");
INSERT INTO med_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Buk Wingti ei ndi, nimba mel, ‘Na mondʉk pʉtmʉn wamp mbʉ nga numan ila, kont mba mul nu ei, rʉk rʉk pukpa omba, mint morum,’” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas ndi, ik nitim ei, elim mondʉk pʉtʉng wamp mbʉ, Muⱡnga Wingti nguimp nimba nitim. Ui ni kʉn, Muⱡnga Wingti ei, ti natʉtʉng. Nambuⱡ emel, Jisas koⱡpa wote, mul kona pi nʉpʉrʉm. ");
INSERT INTO med_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas nitim ik ei, wamp mbʉ ila mat ndi, pilik nʉk mel, “Wu ei kupa, Painui Wu ei,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wamp mat ndi, wu ei, Got Nga Ngurum Wu ei Kraist, nʉtʉng. Wote wamp mat ndi nʉk mel, “Got nga ngurum wu ei, Galili kona orunga ui nawʉmba ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buk Wingti ei ndi, nimba mel, “Got nga ngurum wu ei, King Depit nga pundʉn ei, Betelem kona ila, Depit nga mʉi mang kona ila ming,” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ni kʉn, wamp mindil nila, Jisas nga nʉk oi nduk mu raⱡ rorung. ");
INSERT INTO med_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wamp mat ndi, tʉp kan nguimin nʉtʉng. Wote ambulk ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","El wu ni kʉⱡ, int purung kʉn, Perisi wu na, Pris kuimbal nimbʉ ndi, waldʉk nʉk mel, “Nambuⱡ emel, wu ei, tʉk mek ui nawʉnmʉn?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wote, el wu ni kʉⱡ ndi, punt rok, nʉk mel, “Wamp ti ndi, wu ei, ik nim ei mel ni nanim, ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Perisi wu nimbʉ ndi, nʉk mel, “Enim i ku etpa, tʉpa kum ngi randum ei? ");
INSERT INTO med_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tʉn nga Pris Kuimbal na, Perisi wu mbʉ nga mat ndi, wu ei nga ik ei, pilik tʉtmʉn ei? ");
INSERT INTO med_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wamp nimbʉ ndi, Moses nga mi ik ei, pep rui narʉrmin. Ei kʉn, wamp mbʉ, Got nga kuimp keta ila, kit molk pora ndurung,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Perisi wu kʉⱡ nga wu ti ni, Nikondimas wu ei, unt Jisas mba kʉndrʉm. Ei ndi kat, kundpa nimba mel, “Wu ti nga puⱡ ei, kʉni nakʉndpʉn. Ik ndo ngonmin ei, tʉn nga mi ik ila petʉm nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wote, Perisi wu kat ndi, punt rok, nʉk mel, “Nim Galili wu ei ku? Buk Wingti ila, kʉmp rokʉn pilkʉn, kun iti Galili kona ila, painui wu ti, ui nawʉmba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wote wamp nimbʉ, elpa elpa mang kona purung ");
INSERT INTO med_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wote, Jisas elim Olip Komnga ila purum. ");
INSERT INTO med_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mʉkʉlmʉ unt kelpa, manga wingti ou ila int purum. Wamp nimbʉ ndi, molk pok elingina, elim mana moⱡpa, puⱡ mondpa ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Ni kʉn, mi ik mbo wu na, Perisi wu nimbʉ ndi, amp ti wam wak ropa, wapra rurum ni, mek ok, wamp nga kuimp keta ila, tʉk oⱡa angʉndʉk, Jisas kundʉk, nʉk mel, “Ik mbo wu ye! Amp ei, wam wak ropa, wapra rom ila mep onmʉn. ");
INSERT INTO med_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Amp i iti mbʉ, ku ndi rop kundmin nimba, Moses ndi, mi ik ila rurum. Ei nga, akup nim ndi, namba nin?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wu ni kʉⱡ ndi, Jisas ik ti nimba, ⱡawa mundangga, kʉmp tʉk etʉng nʉk, oⱡa tʉk, kʉning pilik nʉtʉng. Ni kʉn wote, Jisas pilpa moⱡpa, mʉi kandpa, ki ruⱡ ei ndi, mʉi ila mon rurum. ");
INSERT INTO med_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","I etʉk waldʉk morung ila, Jisas rʉn nimba, oⱡa moⱡpa nimba mel, “Nim wamp nam ti ndi, uⱡ kit mat iti natʉtʉn ndam, kuimp tekʉn, amp ei, ku ndi rui!” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wote, aldpa mʉi kandpa moⱡpa, mʉi ila mon rurum. ");
INSERT INTO med_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wamp morung nimbʉ, ik ni pilik, kʉmp kʉm ti raⱡ nʉk, ou kel nimbʉ, kelik purung. Jisas elim kou murum ila, amp ni, anggilpa murum ku. ");
INSERT INTO med_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Wote Jisas ni, oⱡa anggilpa, amp ni, waldpa nimba mel, “Amp ye! Wamp mbʉ nant? Ti ndi moⱡpa, nim kʉmp tʉpa, ni nandʉm ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ni kʉn, amp ni ndi, punt ropa, nimba mel, “Wamp ti, mon ei ka!” nitim. Wote Jisas ndi, nimba mel, “I ndam, na ndi, nim kot indi nʉndimp ku. Nim kelik pukʉn, aldpa uⱡ kit mat iti nʉti mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wote aldpa, Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Ya mʉi kona ei nga rʉⱡang ei na! Wamp ti ndi, na pep rom ndam, rumbʉⱡ ila ʉndi nandʉmba, mon. Wote, kont mba mul rʉⱡang ila andʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ni kʉn, Perisi wu nimbʉ ndi, nʉk mel, “Nim nʉn ik ei, ik kupa ti nʉmp pi napʉnmʉn. Nim nga orunga, paka rokʉn nʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wote Jisas ndi, punt ropa, nimba mel, “Na nga orunga, paka rop nint ndam kep, ik ei, kupa mint. Nambuⱡ emel, na moⱡʉp ur kona ei kep, wote mbi kona ei kep, na nanim pilip mor. Enim uⱡ ei nga pili napʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Enim wamp nga numan, kandʉk tʉk, wamp kʉmp tʉtmʉn ei mel, na i iti natʉt. ");
INSERT INTO med_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wote, na wamp kʉmp tilmba ndam, na nga wamp kʉmp tint uⱡ ei, kupa mint pelinga. Nambuⱡ emel, na nanim kou muⱡi nambʉr. Wote, na tʉpa mundrum Wuta ei, na kʉn morum ei nga, mondʉp pilip nimp. ");
INSERT INTO med_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enim nga mi ik ila, mon rok pendʉtʉng ei ndi ninim. Wamp raⱡ ndi, ik tenda ti natʉmbil ndam, ik ei kupa nʉtmin. ");
INSERT INTO med_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na ndi, nanim nga orunga nʉnt. Wote wamp ti ndi, na nga orunga nʉndʉtʉm ei, na tʉpa mundrum Wuta ei ndi nʉtʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wote, Perisi wu nimbʉ ndi, Jisas waldʉk, nʉk mel, “Nim nga tipanʉm ei, nant ila morum?” nʉtʉng. Wote Jisas ndi, punt ropa, nimba mel, “Enim ndi, na kep, Wuta kep, kandʉk mbi ndui nandʉnmʉn. Na kandʉk mbi nduⱡina ndam, Wuta kandʉk mbi nduⱡina ku,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ik nitim mbʉ, manga wingti ou ila angge moni mbʉ, tʉk tetmin kona ila moⱡpa, wamp ik mbo endpa, ik mbʉ nitim. Ei kʉn, wamp ti ndi, elim tʉk imp muⱡi nʉmbrʉm. Nambuⱡ emel, elim nga ui ei, kokila itim. ");
INSERT INTO med_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aldpa Jisas ndi, nimba mel, “Na kelip mbi, enim ndi, na kʉni nʉkʉning. Wote enim, en enim nga uⱡ kit mbʉ ndi, enim kʉⱡing. Na punt kona ila, enim kapⱡa ui nʉwing,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ni kʉn, Jura wu nimbʉ ndi, waldʉk nʉk mel, “Elim punt kona ila, tʉn kapⱡa pi nʉpʉmʉn” nʉtʉm. “Elim ndi, elim ropa kondʉmba, pilpa nʉnʉm nda,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisas ndi, punt ropa, nimba mel, “Enim ya mana mʉi kona ila wamp kʉⱡ. Na mʉi kona ila mon, Na oⱡa mana ur. ");
INSERT INTO med_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ei nga, enim nga uⱡ kit eng mbila, en enim kuⱡing nʉmp, unt enim kundʉp nit. Wote, Na Ei Wu Nam nʉk, mondʉk pili napʉlʉng ndam, enim nga uⱡ kit eng mbila, en enim kʉⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wote, wamp nimbʉ ndi, Jisas waldʉk, nʉk mel, “Nim nam?” nʉtʉng. Ni kʉn, Jisas ndi, punt ropa, nimba mel, “Na wu nam ei, unt kuimp tep enim kundʉp nit. ");
INSERT INTO med_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na ndi, enim kʉmp tʉp nimp ei nga, ik ou ndupa petʉm. Wote, na tʉpa mundrum Wu ei, kupa morum. Elim ndi, na kundpa nʉtʉm ik mbʉ mint, mʉi kona wamp mbʉ nʉmp ngur,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas ndi, elim nga Tipam nga nitim ik ni, pilik kun iti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wote int ndupa, nimba mel, “Wakʉt Muⱡʉl Wu Kupa ei, ambulk oⱡa tʉng ei kʉn, na wu nam ei, pilik mbi nduing. Ei kʉn ku, na ik nʉt mbʉ, na nga ronduⱡ ila, ni nandʉt, mon. Wuta ndi, na mbo endʉtʉm ik mbʉ mint nʉt. ");
INSERT INTO med_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na tʉpa mundrum wu ei, na wak rui narʉpa, rʉk rʉk na kʉn moⱡnga, elim nga numan ngorum uⱡ mbʉ mint et,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wamp puⱡi, Jisas nga ik nitim ei pilik, elim kʉn mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ni kʉn, Jisas ndi, Jura wamp mat, elim kʉn mondʉk pʉtʉng nimbʉ, kundpa nimba mel, “Na nga ik ei, pilik tʉk teng nduk, moⱡʉng ndam, enim na nga kitip kʉni wamp kupa kʉⱡ muⱡing. ");
INSERT INTO med_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Enim ik kupa ei, pilik ting. Wote ik kupa ei ndi, enim etpa tangga kʉn, aldpa uⱡ kit mbʉ nga kindmant indi nʉnding,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wote, Jura wamp nimbʉ ndi, punt rok, waldʉk nʉk mel, “Tʉn Aparam nga wamp pundʉn mbʉ mormʉn. Tʉn wamp ti nga kindmant wamp kat mon. Ei nga wote, nim ndi, tʉn ik kupa ei ndi, etpa tʉmba nʉn ei, etʉk nʉn mel nant?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ni kʉn, Jisas ndi, punt ropa nimba mel, “Ik kupa ei, enim kundʉp nʉnt. Wamp ti uⱡ kit etʉm ei, uⱡ kit mbʉ nga kindmant wamp ei morum. ");
INSERT INTO med_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wote, wamp mbo tenda kat nga kindmant wamp ti, morum ni, kongun nowu etpa morum. Wote, wamp mbo kʉⱡ nga kangʉm ti, morum ei, wamp mbo kʉⱡ nga wamp mendpʉⱡ ei morum. ");
INSERT INTO med_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Got Kangʉm ei ndi, enim uⱡ kit mbila etpa tʉm ndam, enim aldpa uⱡ kit mbʉ nga kindmant wamp muⱡi nʉmbʉⱡing. ");
INSERT INTO med_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Enim Aparam nga wamp pundʉn kʉⱡ, na pilip mor. Wote, na nga ik mbo endʉnt kʉⱡ, enim pilik ti natʉk, na rok kunding enmin. ");
INSERT INTO med_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na nga Wuta ndi, ora ndurum mel ik mbʉ nʉnt. Wote enim, en enim nga tipam ei ndi, ik man ngorum ei mel ku etmin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wote, wamp nimbʉ ndi, punt rok nʉk mel, “Tʉn nga tipam ei Aparam,” nʉtʉng. Ni kʉn, Jisas ndi, punt ropa nimba mel, “Enim kupa Aparam kangʉmʉl ndam, enim Aparam nga itim uⱡ mbʉ mel elimina. ");
INSERT INTO med_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na ndi, Got nga ik kupa ei, pilip tʉp, enim kundʉp nit. Wote, aldpa enim ndi, na rok kunding pilik enmin. Aparam ndi, uⱡ ei iti nʉtʉtʉm ei ka! ");
INSERT INTO med_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Enim etmin uⱡ mbʉ, enim nga tipam ei, etʉm ei mel etmin,” nitim. Wote, Jura wamp nimbʉ ndi, punt rok nʉk mel, “Tʉn wapra rok, mi nambʉtʉng, mon. Tʉn nga Tipam kupa ei, Got morum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ni kʉn, Jisas ndi, nimba mel, “Got ei, enim nga Tipam kupa ndam, enim ndi, na numan nguⱡina. Nambuⱡ emel, na Got kʉn moⱡʉp ur ei, akup ya omp mor. Na nanim ui nʉwʉr. Elim ndi, na tʉpa munduⱡnga, na ur. ");
INSERT INTO med_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Enim ndi, na nga ik ei, pilik kun iti natʉnmʉn. Ei nambuⱡ emel, enim ndi, na nga ik ei kum tek, piling ei nga numan orunga, piral ni nandʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Enim nga tipam ei, Seitan morum. Ei nga, elim nga etʉm uⱡ mbʉ, enim pep rok etmin. Unt, kuimp tepa, wamp ropa kundi uⱡ ei nga puⱡ ei, Seitan kʉn tepa orum. Uⱡ kupa ti iti natʉtʉm. Ei nambuⱡ emel, ik kupa ti, elim nga rukrʉng orunga ti natʉtʉm. Ik kol ti rorum ndam, ei elim nga uⱡ mendpʉⱡ. Ei nambuⱡ emel, elim ik kol wu, wote ik kol rui uⱡ mbʉ nga tipam ei morum. ");
INSERT INTO med_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wote, na ik kupa nʉt ei, enim ndi mondʉk pili napʉtmʉn ei ka! ");
INSERT INTO med_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na nga uⱡ kit et mbʉ, wamp ti ndi, kandʉk ning muna mon? Wote, ik kupa ei, na nʉt ndam, nambuⱡ emel, enim ndi, na mondʉk pili napʉnmʉn? ");
INSERT INTO med_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Got nga wamp ei, Got nga nʉtʉm ik mbʉ, kum tepa pʉtʉm. Enim Got nga ik ei, pilik ti natʉng ndam, enim Got nga wamp kat mon,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ni kʉn, Jura wamp nimbʉ ndi, punt rok nʉk mel, “Tʉn ndi, nim Sameriya wu ti, kur kit rukʉr orunga, mondkʉn morʉn nʉtmʉn ni, ik kol rurmʉn ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Wote Jisas ndi, punt ropa nimba mel, “Na Wuta nga mbi paka rondʉr. Wote enim ndi, na kur kit mondʉr nʉk, na nga mbi ei tʉk pei mundʉnmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wote na nga orunga, kaip nindeing nʉmp ni nanʉnt. Wu ou ti morum ei ndi, na nga orunga, kʉmp tʉpa kun endpa, kaip nindʉmba. ");
INSERT INTO med_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ik kupa ei, enim kundʉp nʉnt. Wamp ti ndi, na nga ik ei, pilpa tʉm ndam, wamp ei kuⱡi naⱡʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ni kʉn, Jura wamp nimbʉ ndi, punt rok nʉk mel, “Nim kupa kur kit mondkʉn morʉn! Aparam na, painui wu na morung mbʉ, unt korung. Aldpa nim ndi, pilkʉn kelkʉn wamp mbʉ, ik mbo endkʉn, nim nga ik ei pilik tʉng ndam, kuⱡi nʉⱡing nʉn ei ka! ");
INSERT INTO med_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tʉn nga tipam Aparam kʉn, painui wu korung nimbʉ, nim ndi, tʉkʉn pei mundun ku ei? Nim naka wu ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Wote Jisas ndi, punt ropa nimba mel, “Na ndi, na nga mbi ei, paka rop nilmba ndam, na nga mbi ei, kapⱡa mon. Na nga mbi paka rondnum Wuta ei, enim ndi nʉk mel, ‘Enim nga Got,’ nʉnmʉn. ");
INSERT INTO med_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Enim ndi, Got pilik kandʉk iti natʉtmʉn. Na ndi, pilip kandʉp et. Na ndi, nʉmp mel, ‘Na pilip kandʉp, iti natʉt nint ndam, enim ik kol rormʉn ei mel, na ik kol roⱡʉmba. Wote na ndi, pilip kandʉp mbi ndup et ei ndi, elim nga ik ei teng ndʉr. ");
INSERT INTO med_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Enim nga tipam Aparam nga numan ei ndi, na nga ui ei, kʉnimp nimba, ambuⱡpa paⱡpa murum. Ei mel kandpa kʉn, numan wang ndurum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wote, Jura wamp nimbʉ ndi, Jisas kundʉk, nʉk mel, “Nim nga pana 50 omba, pi nʉpi. Nim kokila ei nga, nim Aparam kʉndrʉn nʉn ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ni kʉn, Jisas ndi, nimba mel, “Ik kupa ei, enim kundʉp nʉnt. Aparam ni, mi nʉmi kʉn, na unt kuimp tep mur,” nitim. ");
INSERT INTO med_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jura wamp morung nimbʉ ndi, ku mat tʉk, Jisas ni ruing elingina, wote manga wingti ou ni, wak ropa, mo ropa purum. ");
INSERT INTO med_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas ni, nombuⱡa ila mba kʉndrʉm mel, wu ti metʉng kʉn, mong titim ti murum. ");
INSERT INTO med_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Elim nga kitip kʉni wu ni kʉⱡ ndi, waldʉk nʉk mel, “Ik Mbo Wu ye! Wu ei metʉng kʉn, mong titim uⱡ ei, nam nga ⱡawa tila itim nda? Elim nga, muna mam tipam raⱡ nga nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ni kʉn, Jisas ndi, punt ropa nimba mel, “Wu ei nga mong titim uⱡ ei, elim nga kep, wote mam tipam raⱡ nga kep, ⱡawa tila mon. Mong titim uⱡ ei, Got nga ronduⱡ ei, kongun em ei mel, kʉneing nimba itim. ");
INSERT INTO med_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na tʉpa mundrum wu ei nga kongun, rʉnggilmʉ endamin. Wamp ti ndi, rumbuldi kongun kapⱡa iti natʉtʉmba. ");
INSERT INTO med_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na ya mʉi kona ila mor ei kʉn, mʉi kona wamp mbʉ nga rʉⱡang ei na mor,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Ni kʉn, Jisas i nimba moⱡpa, ol ropa mʉi ila mondpa etpa, ui endpa tʉpa, wu mong titim ni nga mong raⱡ ila kandpa kʉn, nimba mel, “Nim nu Sailom ila pukʉn, nim nga kuimp keta ei ⱡumʉi rui!” nitim. (Sailom mbi ei nga puⱡ ei, ‘Tʉpa Mundrum.’) Wu ni mba kuimp keta ⱡumʉi ropa pendpa, yant oⱡnga, mong raⱡ piral nilinga, kona kʉndrʉm. ");
INSERT INTO med_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ei nga, mang keta kup wamp na, unt rʉng mawa etpa moⱡnga, kandrung wamp na nimbʉ ndi, waldʉk nʉk mel, “Wu ei moⱡpa, wamp mbʉ rʉng mawa etʉm ni nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wamp mat ndi, “Wu waⱡʉm ei,” nʉtʉng. Wamp mat ndi, “Wu ei mel ti morum ei,” nʉtʉng. Wote, mong titim wu ni, elim nimba mel, “Na wu waⱡʉm ei,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ni kʉn, wamp nimbʉ ndi, waldʉk nʉk mel, “Nim nga mong raⱡ etpa, piral nim mel nant?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wu ni ndi, punt ropa nimba mel, “Wu ti mbi tek, Jisas nʉtmin ni ndi, ui mat tʉpa, na nga mong raⱡ ila, kandpa kʉn na kundpa, nimba mel, ‘Nu Sailo ila pukʉn, kuimp keta ⱡumʉi rui nim ila, mbo ⱡumʉi roⱡmba.’ Na nga mong raⱡ piral nilinga, kona mbʉ kʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wote, wamp nimbʉ ndi, wu ni, waldʉk nʉk mel, “Wu ei nant ila morum,” nʉtʉng. Ni kʉn, wu ni ndi, punt ropa nimba mel, “Na kʉni nʉkʉnt!” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mong titim wu ni, mek puk, Perisi wu ni kʉⱡ ngurung. ");
INSERT INTO med_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisas ndi, ui mat tʉpa, wu ni nga mong rat etpa piral ndurum uⱡ ni, mowi kor mormʉn ui ila itim. ");
INSERT INTO med_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ni kʉn, Perisi nimbʉ ndi, aldpa wu ni, waldʉk nʉk mel, “Nim nga mong raⱡ etpa, piral nim mel nant?” nʉtʉng. Wote, wu ni ndi, nimba mel, “Ui mat tʉpa, na nga mong ila kandʉm. Wote, na nga kuimp keta ⱡumʉi roⱡmba, mong raⱡ piral nim,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Perisi wu mat ndi, nʉk mel, “Uⱡ i etpa em wamp ei, Got nga wamp ti mon. Nambuⱡ emel, mowi kor nga mi ik ei, tʉpa roi ndupa em,” nʉtʉng. Wote, wu mat ndi, nʉk mel, “Uⱡ kit etʉm wu ti ndi, uⱡ rʉpndi i etpa, mat etmba ei?” nʉtʉng. Wote, en enim nga rʉk ting ila, oi kan mel pendʉk ik nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ni kʉn, Perisi wu mbʉ ndi, mong titim wu ni, aldpa waldʉk nʉk mel, “Nim nga mong raⱡ etpa piral ndum, wu ei etkʉn, pʉn mel nant?” nʉtʉng. Ni kʉn, wu ni ndi, punt ropa nimba mel, “Ei painui wu ti, nʉmp pʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Jura wu nimbʉ ndi, ko tʉk, wu ei kupa mong titim ila, wote akup kanim nda? Mam tipam raⱡ pilamin nʉk, waldʉk nʉk mel, “Wu ei enmbil nga kangʉm ei? Wote metʉng kʉn mong titim ninggil ndam, wote akup mong raⱡ piral nilinga, kona kandpa andnim ei etpa, em mel nant?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wote, tipam mam raⱡ ndi, punt rokʉⱡ nʉkʉⱡ mel, “Wu ei tʉl nga kangʉm ei pʉtmbʉⱡ. Wote, mong raⱡ titim uⱡ ei, tʉl pʉtmbʉⱡ ku. ");
INSERT INTO med_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wote, mong raⱡ piral nilinga kanim, uⱡ ei, nam ndi, etpa piral ndum nda? Elim wu ou ei, waldʉk pilangina, punt ropa nimba!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mam tipam raⱡ ik i etʉk, nʉtʉnggil ni. Nambuⱡ emel, Jura wu nimbʉ nga mundmong etʉnggil. Jura wu mbʉ nga ik ti unt nʉk ronduⱡ mundrʉng. Ei kʉn, wamp ti ndi, Jisas Got nga ngurum wu ei, nʉng ndam, manga wingti ila makʉrpʉn mundmin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mam tipam raⱡ ndi, ik ei nga pilkʉⱡ mundmong etkʉⱡ, nʉkʉⱡ mel, ‘Elim wu ronduⱡ ei elim waldʉk pilʉi!’ nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aldpa mong titim wu ni, wi rok tʉk kundʉk, nʉk mel, “Nim Got kʉn ik kupa ti, nʉkʉn mʉi rui! Nim nga mong etpa piral ndum wu Jisas ei, tʉn ndi, uⱡ kit etʉm wu ti, nʉmp pʉnmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wote, mong titim wu ni ndi, punt ropa nimba mel, “Wu ei uⱡ kit etʉm, muna mon nda, na pili napʉnt. Uⱡ tenda ti, pilip mor ei, na nga mong raⱡ unt titim. Wote akup piral nilinga, kandʉp mbi ndup mor,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aldpa Jura wu nimbʉ ndi, waldʉk nʉk mel, “Nim nga nambuⱡ ti endim? Wote nim nga mong raⱡ etpa piral ndum mel nant?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aldpa mong ti, wu ni ndi, punt ropa nimba mel, “Enim kundʉp nʉnt, ik ni pili napʉlʉng ei? Aldpa piling pilik nʉnmʉn ei? Enim wu ei nga kitip kʉni wu rʉⱡing pilik nʉnmʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ni kʉn, Jura wu nimbʉ ndi, ik mura nguk, nʉk mel, “Nim mint wu ei nga kitip kʉni wu ei. Wote, tʉn Moses nga kitip kʉni wu kʉⱡ mormun. ");
INSERT INTO med_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Got ndi, Moses ik mbo inditim ei, tʉn pʉtmʉn. Wote, int wu ei, kona nant tila moⱡpa urum ei, tʉn pili napʉnmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wote, mong titim wu ni ndi, punt ropa nimba mel, “Uⱡ elpa ti mel etpa, na nga mong raⱡ etpa kai endim wu ei moⱡpa, om kona ei, enim ndi pili napʉnmin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wote Perisi wu nimbʉ ndi, nimba nʉk mel, “Tʉn pʉtmʉn ei, Got ndi, uⱡ kit etmin wamp mbʉ nga ik kum ti natʉtʉm. Wamp mat, elim tʉk ou nduk, elim nga ik teng nduk etmin wamp mbʉ nga ik kum tetʉm. ");
INSERT INTO med_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Unt kor nga, muⱡ mʉi raⱡ puⱡ mondpa itim ei kʉn, wamp nam ti ndi, wamp ti, mel nga mong raⱡ kit moⱡnga, wote wamp ti ndi, etpa piral ndurum timan ik ti, pepa yant yant oⱡnga, pili napʉtmʉn mon. ");
INSERT INTO med_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ya wu ei, Got kʉn moⱡpa, ui nawʉⱡnga ndam, uⱡ ti mong ropa iti natilinga,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jura wu nimbʉ ndi, punt rok nʉk mel, “Nim uⱡ kit nga mur ila mondʉk metʉng wu ei ndi, wote tʉn ik mbo endʉn ei?” nʉtʉng. I nʉk, popʉⱡ kulk, wu ni, rok pep rorung. ");
INSERT INTO med_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas ndi, wu makrʉk mundrʉng ni nga timan ei pilpa, wu ni, kandpa tʉpa, nimba mel, “Nim Muⱡʉl Wu Kupa ei kʉn, mondkʉn pʉn, muna mon nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ni kʉn, wu ni ndi, punt ropa nimba mel, “Wu Nuim ye! Wamp nam ti, mondʉp pilimp ei, na kundkʉn nana pilamp!” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas ndi, nimba mel, “Nim ndi, wu ei unt kandrum ni. Wote, akup nim kʉn ik nimba morum, ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wote, mong ti wu ni ndi, nimba mel, “Wu Nuim ye! Na akup nim mondʉp pʉnt!” nitim. Nimba Jisas nga kʉmp puⱡ ila rumaⱡi pepa, elim nga mbi paka rundrum. ");
INSERT INTO med_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wote Jisas ndi, nimba mel, “Na mʉi kona ila mana ur ei, wamp kʉmp tʉp mong ti wamp mbʉ, etʉp piral ndup, wote mong piral nʉtʉm wamp mbʉ etʉp, mong ti wamp rundimp pilip ur,” nitim. ");
INSERT INTO med_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ni kʉn, Perisi wu mat, nondpa morung nimbʉ ndi, ik nitim ni pilik, int nduk waldʉk nʉk mel, “Tʉn mong tʉtʉm ku nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wote Jisas ndi, punt ropa nimba mel, “Enim mong tilinga ndam, enim uⱡ kit mat, iti natilingina. Wote, enim nga mong piral nʉtʉm nʉnmʉn uⱡ ei ndi, ora ndupa, enim uⱡ kit mbʉ etʉk, mint mormʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas ndi, nimba mel, “Na ik kupa ei nʉnt. Wu ti ndi, kng sipsip petmin kona ila nga keta puⱡ puⱡ ila rukʉr pi napʉpa, kona elpa tila ku rukʉr pum ndam, ei kʉndʉp wu, ei mba. ");
INSERT INTO med_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wote wu ti, kumba keta puⱡ puⱡ kupa ila kun rukʉr pum ei, kng sip sip rʉp wu mendpʉⱡ ei mba. ");
INSERT INTO med_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wote kumba keta puⱡ puⱡ rʉp wu ei ndi, kumba tʉpa telinga, rʉp wu ei ndi, kng sipsip mbʉ, mbi telinga, ik ei pilik mbi nduk, wote akil tek purmʉn. ");
INSERT INTO med_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wote, mepa pena omba, elim kuimp telinga, kng sipsip mbʉ, elim pep rok akil tetmʉn. Ei nambuⱡ emel, en enim nga rʉp wu ei nga ik ei, pilik mbi ndurmʉn. ");
INSERT INTO med_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wu elpa ti kʉn, pep rok pi napʉk, nung nʉk, elpa elpa ping. Ei nambuⱡ emel, wu ei nga ik ei pilik, mbi ndui nandʉrmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas ndi, ik ek ropa nitim ik ei, pilik kun iti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisas ndi, aldpa nimba mel, “Na ik kupa ei, enim kundʉp nʉnt. Na ei, sipsip nga kumba keta puⱡ puⱡ ei mor. ");
INSERT INTO med_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na tʉk akil nduk, unt kuimp tek orung wu nimbʉ, kʉndʉp wu mbʉ orung. Wote, kng sipsip mbʉ ndi, wu mbʉ nga ik nʉtʉng ei pilik, teng ndui nandrʉng. ");
INSERT INTO med_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kumba keta puⱡ puⱡ ei, na mor. Ei nga, wamp nam ti, keta puⱡ puⱡ ila rukʉr om ndam, etʉp timp. Wote, keta puⱡ puⱡ ila ku, pena manga etpa, rʉng kai mbʉ, kandpa tʉpa nomba. ");
INSERT INTO med_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kʉndʉp wu ei ndi, kng sipsip mbʉ kʉndʉp nomba, ropa kondpa, pora ndumba ei nga mint orum. Wote, na mana ur ei, wamp kont molk mint ping ei nga nʉmp ur. ");
INSERT INTO med_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na kng sipsip rʉp wu kai ei mor. Sipsip rʉp wu kai ei ndi, sipsip mbʉ nga nʉndpa, koⱡmba ei nga morum. ");
INSERT INTO med_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sipsip rʉp itangga nʉk, kandʉk tʉtmʉn wu ei ndi, owa rakra orum kandrum ei kʉn, kng sipsip mbʉ, wak ropa purum. Nambuⱡ emel, kng sipsip mbʉ, elim nga mon. Wote, elim rʉp wu kai ti mon. I elinga, owa rakra ei ndi, omba kng sipsip ti roⱡnga, mat mbʉⱡ mbaⱡ nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kng sipsip rʉp itangga nʉk, kandʉk tʉtmʉn wu ei purum. Ei nambuⱡ emel, elim ku moni nga kongun etʉm ei ndi, sipsip kʉⱡ nga pili napʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Na kng sipsip rʉp wu kai ei mor. Wuta ndi, na pʉtʉm. Ei mel, na ndi, Wuta pʉt ku. Wote, ei mel ku, na ndi, na nga kng sipsip mbʉ pilip moⱡmba, wote na nga kng sipsip mbʉ ndi, na pʉtmʉn. Na sipsip mbʉ nga nʉndʉp kuⱡimp mor. ");
INSERT INTO med_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na nga kng sipsip mormʉn mbʉ nga mat, paⱡa ekit orunga mormʉn. Kng sipsip mbʉ, na ndi, tʉp mep rukʉr wamba. Na nga ik ei, pilik ting. Wote, unt nga mormʉn mbʉ kʉn, paⱡa tenda ila muⱡangina, rʉp wu tenda ei ndi rʉp etmba. ");
INSERT INTO med_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na nga kont mul uⱡ ei, wak rop, wote yant timp. Ei nambuⱡ emel, Wuta ndi, na numan ngorum. ");
INSERT INTO med_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wamp ti ndi, na nga kont mba mul uⱡ ei, tʉpa mundʉmba mel, kapⱡa mon! Na nga ronduⱡ ila, na nga kont mba mul uⱡ ei, wak ruing. Nanim pint mel ku, wak rop, wote nanim pint mel ku, yant timp. Uⱡ ei, Wuta ndi, na man ngumba iteimp nitim ei mel ku itimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ik nitim ni, Jura wamp pilik wamp oi nduk, rʉⱡaip raⱡ etʉk morung. ");
INSERT INTO med_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ni kʉn, wamp ou ndupa ndi, nʉk mel, “Wu ei kur kit mondpa, wote kekilip ropa ninim ik mbʉ, nambuⱡ emel, kum tenmin ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wote, wamp mat ndi, nʉk mel, “Wu ti, kur kit mondpa ik ei mel, kapⱡa ni nanʉmba. Wote, kur kit ei ndi, mong ti wamp ei, nambuⱡ etpa, mong ei, etpa piral ndumba?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kona ⱡapta rurum ni kʉn, Jerusalem kona ila manga wingti ou anggʉtʉm ei nga kumba tʉtʉng ui ni, ekit urum. ");
INSERT INTO med_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ni kʉn, manga wingti ei nga kʉkaⱡ ekit orunga, titim nimbʉ nga ti mbi tek, ‘Solomon nga kʉpkʉ titim muⱡmʉn kona nila, Jisas andpa murum. ");
INSERT INTO med_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kona nila moⱡnga, Jura wamp nimbʉ ndi, Jisas tʉk pok etʉk molk, waldʉk nʉk mel, “Tʉn ndi, nim wu nam ei, etʉp pilmin nimbun elimina, ui mbʉ ruⱡ enim? Nim kupa Kraist Got nga ngurum wu ti ndam, nʉk kʉn, piral ndana pilamin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas ndi, punt ropa nimba mel, “Na uⱡ et mbʉ, enim kundʉp nit ni, wote enim na mondʉk pili napʉtmin. Na Wuta nga mbi ila uⱡ et mbʉ ndi, na nga mbi ei, nimba mot ndurum. ");
INSERT INTO med_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Enim ndi, na mondʉk pili napʉnmin. Ei nambuⱡ emel, enim na nga sipsip mat mon. ");
INSERT INTO med_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na nga sipsip mbʉ ndi, na nga ik ei pilik, mbi ndʉⱡʉngina, na ndi, en enim pʉt. Wote, na pur mel akil tek ormʉn. ");
INSERT INTO med_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na nga sipsip mbʉ, uⱡ nga kʉnt nga kont mba mul uⱡ ei ngur. Ei nga, kuⱡing mel mon. Na nga ki ila ambʉⱡʉp mor mbʉ wamp ti ndi, roldpa tʉmba mel, kapⱡa mon! ");
INSERT INTO med_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wuta ronduⱡ pi wu, oⱡa orunga ei ndi, kng sipsip mbʉ, na ngurum. Ei nga, elim nga ki ila, roldʉk ting mel, kapⱡa mon! ");
INSERT INTO med_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wuta kʉn, na kʉn tʉl, wu tenda raⱡ mormbʉⱡ,” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ni kʉn, aldpa Jura wamp nimbʉ ndi ku aprʉk tʉk, Jisas ku ndi ruing pilik etʉng. ");
INSERT INTO med_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisas ndi, wamp nimbʉ, kundpa nimba mel, “Enim Wuta nga kongun kai mbʉ mint, etʉp tʉp ora ndʉr. Ei nga, uⱡ nant ei nga, pilik, na ku ndi ruing enmin?” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aldpa, Jura wamp mbʉ ndi, punt rok nʉk mel, “Nim uⱡ kai mbʉ etʉn ei nga, nim ku ndi rui nʉrmʉn. Nim mʉi kona wu mendpʉⱡ ni, wote ninim tʉkʉn, Got randʉn ei nga, nim ku ndi ruimin enmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ni kʉn, Jisas ndi, punt ropa nimba mel, “Enim nga mi ik ila mon ti petʉm ei ndi, nimba mel, ‘Enim mʉi kona wamp mbʉ, got ku morum,’” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tʉn pʉnmʉn ei, Buk Wingti ila ik petʉm ei kupa. Uⱡ nga pemba ei nga petʉm. Wote, Got elim nga ik ei, nimba ngurum wamp mbʉ, Got ndi, mbi tepa, ‘got’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wote, na Wuta ndi, mbi ropa tʉpa, mʉi kona ila tʉpa mundrum. Ei nga, na ndi, nanim Got kangʉm nʉnt. Ei nga, nambuⱡ emel, enim ndi, na Got tʉp mana ndont nʉnmʉn. ");
INSERT INTO med_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wuta nga kongun ronduⱡ mat, na ndi iti nʉtʉnt ndam, enim na kʉn mondʉk pili nʉpilʉi! ");
INSERT INTO med_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wote na ndi, Wuta nga kongun ronduⱡ mat elimba. Wote enim ndi, na nga ik ei mondʉk pili nʉpiling ndam, na nga uⱡ rʉpndi et mbʉ, onunga kot tʉk mendʉk, mondʉk pilʉi! Ei etʉk kʉn, Wuta ei, na kʉn morum. Wote na ei, Wuta kʉn mor uⱡ ei pilik kun iting,” nitim. ");
INSERT INTO med_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wote aldpa, tʉp imp muⱡmin nʉk elingina, kiyang nimba omba, ekit purum. ");
INSERT INTO med_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ni kʉn, Jisas nu Joran aldpa puⱡa ropa, noi orunga mba, wu Jon ndi, unt wamp nu tinditim kona nila mba murum. ");
INSERT INTO med_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wamp minal Jisas murum nila, rʉk ok molk, nʉk mel, “Jon ndi, uⱡ rʉpndi mat iti nʉtʉtʉm. Wote, wu ei nga ik mat ninditim mbʉ, akup omba, kupa enim,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wote, wamp minal ila morung nimbʉ ndi, wu ei mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani kona ila Lasarus ni, wu ti murum wu ei, kui rurum. Wote, kona ila amp Mariya kʉn, ʉngʉn amp Mata kʉn pek morunggil. ");
INSERT INTO med_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Amp Mariya ni, Jisas nga kʉmp ila kopung mura rui mat, oi ndupa kandpa, wote elim nga peng ndi kʉⱡ ndi, kil ngurum amp ni nga kimin ni, kui rurum. ");
INSERT INTO med_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Amp ni raⱡ ndi, Jisas kʉn rung mundkʉⱡ nʉkʉⱡ mel, “Nuim ye! Nim nga wu mʉn mondpʉn ni, kui rom,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wote, Jisas ndi, ik ni pilpa nimba mel, “Lasarus kui rom uⱡ ei, wamp kormin ei nga kui ti rui narʉm. Uⱡ ei, Got nga ronduⱡ ei, etpa mot ndangga, Got mbi ou tʉmba ei nga em. Wote, Got kangʉm ei, uⱡ ila ku, mbi ou tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ndi, amp Mata kʉn, ʉngʉn kʉn, Lasarus kʉn numan minal ngurum. ");
INSERT INTO med_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jisas ndi, Lasarus kui rurum ik ei pilpa, wote murum kona ila moⱡnga, rumbʉⱡ raⱡ omba purum. ");
INSERT INTO med_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Wote, elim nga kitip kʉni wu ni kʉⱡ, kundpa nimba mel, “Juriya kona ila kelip int pamin!” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ni kʉn, kitip kʉni wu ni kʉⱡ ndi, punt rok nʉk mel, “Ik mbo wu ye! Jura wamp mbʉ ndi, nim ku ndi ruimin nʉng ni, wote nim kona ila noi pamin nin ye?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas ndi, punt ropa nimba mel, “Rumbʉⱡ tenda ila ant mong 12 petʉm. Ei nga, wamp nam ti, rʉnggilmʉ nombuⱡa andrʉm ei, kʉmp nduma rui narʉrʉm. Ei nambuⱡ emel, wamp ei mʉi kona ei nga rʉⱡang ei, kandpa andrʉm. ");
INSERT INTO med_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wote, wamp nam ti, rumbʉⱡ ila nombuⱡa andrʉm ni, kʉmp nduma rorum. Ei nambuⱡ emel, wamp ei nga rukʉr orunga rʉⱡang ti mon,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas ndi, i nimba kʉn, wote nimba mel, “Tʉn nga wu mʉn Lasarus ni, ur petʉm. Wote na ndi, mbo rop rut nduimp punt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ni kʉn, kitip kʉni wu ni kʉⱡ ndi, punt rok nʉk mel, “Wu Nuim ye! Wu ei, ur pem ndam, wote rut nimba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasarus kurum ni, Jisas ndi, wei ur petʉm nitim. Ni kʉn, kitip kʉni wu ni kʉⱡ ndi, mbo kun ur pelinga, ninim nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Wote, nimba mot ndupa nimba mel, “Lasarus ni koⱡum. Ei nga, na enim nga pilip kʉn, pi napʉⱡʉmba, wu ei koⱡum. Uⱡ ei, na numan enim. Nambuⱡ emel, enim mondʉk piling ei nga, akup pamin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, wu pʉklʉm nʉtʉng ni ndi kundpa nimba mel, “Tʉn nga wu ei koⱡum ei mel, tʉn kʉⱡʉmʉn pamin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ni kʉn, Jisas mba kʉndrʉm ni, Lasarus kurum on etʉng ni, rumbʉⱡ tʉmbʉkak omba purum. ");
INSERT INTO med_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani kona ei, ruⱡ mel puk, Jerusalem ekit purmin mel itim. ");
INSERT INTO med_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jura wamp mam ti ok, Mata kʉn Mariya raⱡ nga kimin kurum ni nga kont kulk, koⱡa manga rʉp rok muⱡing orung. ");
INSERT INTO med_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Molk pʉtʉng mel, Jisas onum nʉtʉng. Mata ndi pilpa, mba nombuⱡa ila kandʉp timp nimba puⱡnga, Mariya ni mang kona murum. ");
INSERT INTO med_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ndi, Jisas kundpa, nimba mel, “Nuim ye! Nim ya moⱡina ndam, na nga kimin wu ei kuⱡi naⱡʉnga. ");
INSERT INTO med_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wote akup na pʉnt ei, nim ndi, Got kʉn mel ti mawa etkʉn nin ndam, nin mel ei ngumba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisas ndi, kundpa nimba mel, “Kemina rut kitip kʉni wu mbʉ nimba, oⱡa moⱡmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ndi, int ndupa, nimba mel, “Ui pora nim ei kʉn, rut nimba oⱡa moⱡmba ei, na pʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas ndi, Mata kundpa nimba mel, “Rut nimba oⱡa mul uⱡ ei kʉn, wote kont mba mul uⱡ raⱡ nga puⱡ ei, na kʉn petʉm. Wamp nam ti, na mondpa pilim ei, koⱡum ndam kep, na kʉn kont moⱡpa mint mba. ");
INSERT INTO med_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wote, wamp nam ti, kont moⱡpa, na mondpa pilim ndam, kuⱡi naⱡʉmba. Ik ei, nim mondkʉn pʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ni kʉn, Mata ndi, punt ropa nimba mel, “Kupa, Nuim ye! Nim Got nga kangʉm ei, ya mʉi kona ila omba, nimbun nokʉndʉrmʉn wu mendpʉⱡ ei, ik nʉn ei, kupa mondʉp pʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wote Mata ndi, int mba ʉngʉn amp Mariya ni, wi ropa ol tepa, kundpa nimba mel, “Ik mbo wu ni, omba moⱡpa, nim kʉnimp nimba, waldpa morum,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ik ni, Mariya pilpa tʉkrʉpa oⱡa moⱡpa, Jisas murum nila purum. ");
INSERT INTO med_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ni, mang kona ila ui nʉwʉrʉm. Mata kandpa titim kona nila murum mint. ");
INSERT INTO med_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ni kʉn, Jura wamp mat, Mariya kʉn koⱡa manga rʉp rok morung nimbʉ ndi, kandrung ei, amp ni oⱡa moⱡpa, tʉkrʉpa pena purum ila kandʉk, akil tek purung. Wamp nimbʉ ndi, wamp on kona ila, ka etmba punum nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wote Mariya ndi, Jisas murum kona nila mba, Jisas kandpa tʉpa kʉn, kʉmp puⱡ ila kopʉtʉm. Ropa mondpa, nimba mel, “Nuim ye! Nim ya ila moⱡina ndam, na nga kimin wu ei, kuⱡi naⱡʉnga,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ni kʉn, Mariya ka elinga, Jura wamp rʉp rok orung nimbʉ, ka ku elingina, Jisas kandpa, kont kurum. ");
INSERT INTO med_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jisas ndi wamp nimbʉ kundpa nimba mel “Wu ei kona nant ila angʉndʉng?” nitim. Wamp nimbʉ ndi, punt rok nʉk mel, “Wu Nuim ye! Ya okʉn kʉni!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ni kʉn, Jisas ka itim. ");
INSERT INTO med_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Uⱡ itim ni, Jura wamp nimbʉ, kandʉk nʉk mel, “Wu ni, numan minal ngorum ei, kanmin mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wote, wamp mat ndi, nʉk mel, “Wu mong titim ti, etpa piral ndurum ni ka! Ei mel ku, wote akup, Lasarus koⱡum ei, unt oⱡnga ndam, etpa ti natilinga ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aldpa, Jisas nga mundmong ni, mi elinga, wu on etʉng kona ila purum. Ku manga ila, on etʉng ei nga keta puⱡ puⱡ ila ku ti ndi, ⱡʉrʉk nduk pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ni kʉn, Jisas ndi, nimba mel, “Ku ei tʉk mundʉi!” nitim. Wote, amp Mata ndi, punt ropa nimba mel, “Nuim ye! Wu on ei, on kona ila telinga, rumbʉⱡ tʉmbʉkak omba pum. Ei nga, elkʉⱡ kit ti, romba ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aldpa Jisas ndi, nimba mel, “Nim mondkʉn pili, Got nga uⱡ rʉpndi mat etmba, kʉnin nit ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wote, ku ni tʉk munduⱡngina, Jisas tʉpa oⱡa ndupa, kandpa nimba mel, “Wuta, na nga rʉk rʉk ik kum tetʉn ei nga, nim kʉn angge nʉnt. ");
INSERT INTO med_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na nga ik ei, nim rʉk rʉk kum tetʉn ei na pʉt. Wote, akup na nʉnt ei, ya wamp mbʉ ndi kandʉk, nim ndi, na tʉk mundrun nʉk, pilik mondʉk pileing nʉmp nʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ik nimba pora ndupa, ronduⱡ wi ropa nimba mel, “Lasarus nim ekit wu!” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wu kurum angʉndʉtʉng ni, muⱡ ndi, kʉmp ki na, kuimp keta kum rorung nimbʉ, pʉi oⱡa moⱡpa, ekit urum. Jisas ndi, nimba mel, “Kan pilinga nduk, mundangina omba pangga!” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jura wamp puⱡi amp Mariya kʉning pilik, orung nimbʉ ndi, Jisas uⱡ itim ni kandʉk, wote mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wote, wamp mat ndi, int puk Jisas itim uⱡ nimbʉ, Perisi wu nimbʉ kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ni kʉn, Perisi wu na, Pris wu kuimbal ni kʉⱡ puk, kaunsil kʉⱡ kʉn mou rok nʉk mel, “Wu ei ndi, uⱡ ronduⱡ mat enim ei ka! Tʉn ndi, namba uⱡ ti itmin nda? ");
INSERT INTO med_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wote, tʉn ndi, wu ei, wak ropʉn mundmin ndam, wamp mbʉ pora, wu ei mondʉk pilik, pep rangina, Rom el wu mbʉ ndi, rʉk ok, tʉn nga manga wingti ei, etʉk kit mondʉk, tʉn Jura wamp mbʉ, rok wapra pinding,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ui ei kʉn, Kaiyapas ni, wu ti, Pris kuimbal murum ei ndi, nimba mel, “Enim uⱡ mbʉ nga ti, pilik kun iti natʉtmin ei ka! ");
INSERT INTO med_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wamp kump kʉm kuⱡing ei mon. Wu tenda ti, wamp mbʉ nga nindpa kuⱡangga,” nitim. ");
INSERT INTO med_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ik nitim ni, elim nga numan ila ni nʉndʉtʉm mon. Ui ei kʉn, elim wu pris kuimbal murum ei nga pai nomba, Jisas ni, Jura wamp mbʉ nga kan endpa, koⱡmba ei nga nitim. ");
INSERT INTO med_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ik nitim ei, Jura wamp kʉⱡ nga mendpʉⱡ mon. Got nga wamp kona elpa elpa mbila mormin mbʉ, kʉmp kʉm tʉpa, tenda etmba ei nga nitim. ");
INSERT INTO med_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ui ni kʉn, Jura wu nuim nimbʉ ndi, Jisas ruimin nʉk mʉi rorung. ");
INSERT INTO med_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ei kʉn, Jisas ndi, Jura wamp mbʉ nga kuimp keta ila, mot nga ʉndi nandpa, kelpa kona kui waka tila, kona peng ti mbi tek ‘Epraim,’ nʉtmin ila, elim nga kitip kʉni wu kʉⱡ kʉn, rʉp ropa murum. ");
INSERT INTO med_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ui ni kʉn, Jura wamp mbʉ nga Pasopa rʉng mormin ui ou ei, nondpa elinga, kona elpa elpa nimbila, wamp puⱡi en enim nga uⱡ ⱡawa mbʉ, wak ropʉn, Got nga kuimp keta ila kai muⱡmin nʉk, Jerusalem kona ila purung. ");
INSERT INTO med_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ni kʉn, Jura wamp nimbʉ, manga wingti ou nila molk, en enim waldʉk nʉk, int yant etʉk, nʉk mel, “Akup nga ui ou ila, Jisas omba muna mon nda, nʉk ko tʉk morung,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wote Perisi na, wote Pris wu kuimbal nimbʉ ndi, ik ti, nʉk mel, “Wamp nam ti ndi, Jisas kona nant tila moⱡangga, kanʉng ndam, tʉkrʉk mint en enmin ok, kundʉk nangina, wu ei tʉp imp muⱡmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasopa rʉng normin ui ou ni nga rumbʉⱡ 6 pelinga, Jisas ni, wʉl Betani kona ila Lasarus wu kurum ti, ropa rot ndurum ni nga kona ila purum. ");
INSERT INTO med_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ni kʉn, Jisas nga rʉng kandrung. Amp Mata ndi, rʉng nimbʉ, mok roⱡnga, Jisas kʉn Lasarus raⱡ, rat pol nila morunggil. ");
INSERT INTO med_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","I etʉk moⱡʉngina, Amp Mariya ndi, kopung mura rui kai ming ti, ku moni minal purum ti, mepa omba, Jisas nga kʉmp pol nila, oi ndupa mondpa, wote elim nga peng ndi ni kʉⱡ ndi, kil ngurum. Manga ni, kopung ei ndi, mura kai ropa murum. ");
INSERT INTO med_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Wote, Jisas nga kitip kʉni wu, rʉk moⱡmba wu, Juras Iskariyot ni ndi, nimba mel, “Kopung ei ndi, ku moni K300 tʉpʉn, wote ku moni mbʉ, wamp kurpa mbʉ, mok ropʉn nguimin. Ei nambuⱡ emel en?” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ik i etpa nitim ei, nambuⱡ emel, elim ku moni nga kum mepa nitim. Wamp kurpa norum mbʉ nga mon. Elim nga mendpʉⱡ pilpa nitim. ");
INSERT INTO med_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisas ndi, nimba mel, “I ni nʉni! Na kuⱡimp ei nga, na nga kʉng kʉⱡ, kopung kandpa tʉpa kun endnim. ");
INSERT INTO med_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na enim kʉn moⱡʉp, mint pi nʉpimp. Wote, wamp kurpa mbʉ, enim kʉn rʉk rʉk muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisas Betani kona ila mba murum ni, Jura wamp rʉⱡaip ou ndupa ndi, pilik akil tek purung. Wamp purung ni, Jisas purum ni nga mendpʉⱡ pilik, pi napʉrʉng. Lasarus on kona ila, Jisas ndi, ropa rut ndurum ni, kʉning pilik purung. ");
INSERT INTO med_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ni kʉn, Pris wu kuimbal nimbʉ ndi, Lasarus ni, kunda rop kundmin nʉtʉng. Ei nambuⱡ emel, Jisas ndi, Lasarus ropa rut ndurum uⱡ ni, Jura wamp mbʉ ndi kandʉk, en enim nga wu nuim nimbʉ, wak rok Jisas mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Utʉma orunga, Jisas ni, Jerusalem yant urum. Ni kʉn, Jura wamp minal, Pasopa rʉng normin ui ou ila orung, wamp nimbʉ ndi pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wamp nimbʉ ndi, yaⱡa omung ranggʉk tʉk, nombuⱡa mam nila pʉkaimp rok, ke nʉk, Got nga mbi paka rondʉk, nʉk mel, “Got nga mbi paka ramin! Got nga mbi ila, tʉpa angʉndpa onum wamp ei, Got ndi, memp pindangga! Isrel wamp mbʉ nga Wu King ei, Got ndi, memp pindangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ui ni kʉn, Jisas ndi, kng donggi mbuⱡ ila moⱡpa urum. ");
INSERT INTO med_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Buk Wingti ila nitim ni mel, “Nim Saiyon kona ye! mundmong iti nʉti! Akup kng donggi kokila ti nga mbuⱡ ila moⱡpa onum ei, nim nga Wu King ei onum,” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Elim nga kitip kʉni wu nimbʉ ndi, uⱡ etʉng nimbʉ, pilik kun iti natʉk morung. Wote, akil tepa, Jisas ⱡoporpa oⱡa moⱡpa, muⱡ kona purum ni kʉn, Buk Wingti ila nʉtʉm ik, wote wamp ndi, etʉng uⱡ nimbʉ, piral nilinga, pilik kun etʉng. ");
INSERT INTO med_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisas ndi, Lasarus ni, on kona ila ropa rʉt nduⱡnga, kandrung wamp nimbʉ ndi, uⱡ itim nimbʉ, wamp mat kundʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wamp minal ndi ok, Jisas rawe etʉk tʉtʉng. Ei nambuⱡ emel, Jisas ndi, uⱡ rʉpndi ti etpa, Lasarus on kona ila ropa rʉt ndurum ei nga etʉng. ");
INSERT INTO med_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Wote, Perisi wu nimbʉ ndi, ol tek, int yant etʉk nʉk mel, “Tʉn namba uⱡ itmin? Mul kʉmp mbila wamp mbʉ pora, wu ei kʉn puk kenmin. Tʉn uⱡ ti kanda iti nʉtmin ei, kanmin mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pasopa rʉng normin ui ou nila, Grik wu mat, Jerusalem kona ila, Got nga mbi paka rundmin nʉk purung. ");
INSERT INTO med_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wote, Galili nga Betseita kona ila wu Pilip murum nila, puk nʉk mel, “Wu nuim ye! Tʉn Jisas kʉnmin onmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip ndi mba, Andru kundpa nilinga, rʉp rokʉⱡ, Jisas kundkʉⱡ, ninggil purʉnggil. ");
INSERT INTO med_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisas ndi, punt ropa nimba mel, “Muⱡʉl Wu Kupa ei, akup mbi ou tʉmba ui ei, nondpa enim. ");
INSERT INTO med_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Enim ik kupa ei, kundʉp nʉnt, wit mong tenda ti, mʉi ila mana mba, kuⱡi naⱡʉⱡʉm ndam, elim tenda ei ku pemba. Wit mong ti, mʉi ila mana mba, koⱡum ndam, wit minal milʉ ropa, oⱡa omba, rʉng mong ou ndupa rorum. ");
INSERT INTO med_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wamp nam ti, elim nga kont mul uⱡ ei, ambuⱡpa gi ndum ndam, kont mba mul uⱡ ei, kandpa ti natmba. Wote, wamp nam ti, elim nga mul uⱡ ei, wamp mat nga nindpa, wak rom ndam, uⱡ nga kʉnt nga kont mul uⱡ ei, kandpa tʉmba. ");
INSERT INTO med_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wamp nam ti, na nga kongun indimp nimba pilim ei, na kʉn pep ropa wangga! Na munt kona ila rʉp ropʉl muⱡʉmbil. Na nga kongun endim ti, Wuta ndi, tʉpa ou ndumba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas ndi, nimba mel, “Akup na nga mundmong ei, mi enim ei nga, akup na namba nimp? Wuta o, na kʉn pemba enim uⱡ ei, tʉkʉn munda, ei mon! Uⱡ pemba enim ei nga na ur. ");
INSERT INTO med_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wuta o, nim nga mbi ei, oⱡa mba piyangga!” nitim. Ni kʉn, muⱡ ila ik ti, mana ndupa nimba mel, “Na nga mbi ei, etʉp tʉp oⱡa mundʉr. Ei mel ku, oⱡa mba piyangga!” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wamp minal morung nimbʉ ndi, muⱡ ila ik nitim ni pilik, nʉk mel, “Kona guⱡ gaⱡa ninim!” nʉtʉng. Mat ndi, nʉk mel, “Anggelo ti, Jisas kʉn ik ninim!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wote, Jisas ndi, nimba mel, “Ik ei ndi, na tʉpa rapʉndʉmba ui nawʉnʉm. Ik ei ndi, enim tʉpa rapʉndʉmba, ei nga onum. ");
INSERT INTO med_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Akup ui ila, Got ndi, mʉi kona wamp mbʉ kʉmp tʉmba. Wote, mʉi kona ila mel mbʉ, nokʉndrʉm wu nuim ei, ropa mana ndumba. ");
INSERT INTO med_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na nanim mʉi kona ila oⱡa tʉng ei kʉn, na ndi, wamp mbʉ pora etʉp rukʉr timp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","I nitim ik ei, elim etpa koⱡmba mel nant ei nga pilpa nitim. ");
INSERT INTO med_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wote, wamp nimbʉ ndi, punt rok nʉk mel, “Tʉn nga mi ik ei ndi, nimba mel, ‘Got nga ngurum wu ei, kuⱡi naⱡʉmba,’ uⱡ nga moⱡmba nʉtʉm. ‘Wote nim ndi, Muⱡʉl Wu Kupa ei, mʉi kona oⱡa ting nʉn ei? Muⱡʉl Wu Kupa ei nam?’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisas ndi, punt ropa nimba mel, “Ui onunga wei kot ila, na nga rʉⱡang ei, enim kʉn temba. Akup rʉⱡang tʉnʉm ei kʉn, ping kona tila pʉi. Wote, rumbʉⱡ ei ndi, enim tʉpa kum rui narangga! Nambuⱡ emel, rumbʉⱡ ila nombuⱡa ila purum wamp ei, elim purum kona ei pili napilpa purum. ");
INSERT INTO med_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Akup rʉⱡang ei, tek mormun ei kʉn, mondʉk pilʉi! I etʉk kʉn, enim rʉⱡang ei nga wamp muⱡing,” nitim. Jisas ndi ik ei, nimba pora ndupa kʉn, wamp nimbʉ, wak ropa, elim kiyang nimba mba, mo rurum. ");
INSERT INTO med_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Wote Jisas ndi, uⱡ rʉpndi minal itim ni, wamp nimbʉ ndi kandʉk, mondʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Wote, Painui wu Aisaiya nga nitim ik ni, omba kupa itim. Aisaiya ndi, nimba mel, “Wu Nuim ye! ik nimʉn ei, wamp namin ndi, pilik ting? Got ndi, wamp namin elim nga ronduⱡ ei, tʉpa ora ndurum?” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mondʉk pili napʉtʉng uⱡ ei nga painui wu Aisaiya ndi, aldpa nimba mel, ");
INSERT INTO med_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Got ndi, wamp mbʉ etpa, numan ku randpa, etpa mong tʉndpa elinga, wote pilik kun iti natʉk, kandʉk mbi ndui nandʉk enmin. Got ndi, nimba mel, na nambuⱡ etʉk numan ropʉl rok, rukrʉng wangina, na ndi, etʉp timp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya ndi, Jisas nga uⱡ eng nui mbʉ, ur kump mel etpa kandpa kʉn, ik ei nitim. ");
INSERT INTO med_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ni kʉn, Jura wu nuim mat ou ndupa, Jisas mondʉk pʉtʉng. Wote, nʉk ekit ndui nandrʉng. Ei nambuⱡ emel, Perisi wu mbʉ ndi, en enim atinga manga mbila, mon ning nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Uⱡ etʉng ei, Got ndi, numan ngangga nʉk, uⱡ ti iti natʉk, wamp mbʉ ndi, numan ngeing nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas ndi, ik oⱡa ndupa nimba mel, “Wamp ti, na mondʉp pilim ti, na mint mon. Wote na tʉpa mundrum wu ei, kunda mondpa pilangga ku.” nitim. ");
INSERT INTO med_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wamp nam ti, na kandpa mbi ndum ndam, na tʉpa mundrun wu ei, kandpa mbi ndurum ku ");
INSERT INTO med_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na ya mʉi kona ila rʉⱡang ei, mana ur. Ei nga, na mondpa pilim wamp ti, aldpa rumbʉⱡ ila muⱡi nambʉⱡmba. ");
INSERT INTO med_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wamp nam ti ndi, na nga ik ei pilpa, pep rui narʉm ndam, wamp ei na ndi, kʉmp ti nʉtimp. Na ya mʉi kona ila wamp kʉmp timp ei nga, ui nʉwʉr. Wamp etʉp timp pilip mana ur. ");
INSERT INTO med_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wamp nam ti na tʉpa mbuⱡ ngumba. Na nga ik ei, tʉpa roi ndum ndam, wamp ti ndi, elim kʉmp tʉmba. Ui pora nim ei kʉn, na nga ik nʉnt ei ndi, el elim kʉmp tʉmba. ");
INSERT INTO med_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ya ik nʉnt mbʉ, nanim ni nanʉnt. Na tʉpa mundrum Wuta ei ndi, man ngumba ni nilinga, nʉnt. ");
INSERT INTO med_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na pʉnt ei, Wuta nga man ik ei ndi, uⱡ nga kʉnt nga kont mul uⱡ ei, tʉpa ngumba. Na nʉnt ik mbʉ, Wuta ndi, na kundpa nilinga nʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasopa rʉng nuing ui ei nondpa elinga, Jisas elim pitim ei, ya mʉi kona wak ropa, Tipam kʉn mba ui ei, nondpa itim. Mʉi kona wamp mat, elim numan ngurum nimbʉ nga kont minal kuⱡpa mba, wote elim kurum. ");
INSERT INTO med_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas kʉn elim kitip kʉni wu ni kʉⱡ kʉn, epindama Pasopa rʉng nok morung. Ni kʉn, Saimon kangʉm Juras nga numan ila, Seitan ndi, kunt ropa Jisas nga rʉk moⱡmba. ");
INSERT INTO med_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas pitim ei, Got ndi, uⱡ ronduⱡ mbʉ pora, elim nga ki ila tinditim. Wote, elim Tipam kʉn moⱡʉp, ur ei mel ku, aldpa rukʉr mbi nimba pitim. ");
INSERT INTO med_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","5","Ei nga, Jisas run nimba anggilpa, wal pʉki oⱡa ni kʉⱡ, potpa tepa, muⱡ kil ngurmin kat tʉpa, elim nga kan rʉⱡi ila, kan ropa pendpa, nu ni tʉpa, nu ming tila oi ndupa mondpa, elim nga kitip kʉni wu ni kʉⱡ nga kʉmp nimbʉ, ⱡumʉi ropa, muⱡ kil ngurmin ni kʉⱡ ndi, kil ngurum. ");
INSERT INTO med_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","I etpa omba, Saimon Pita murum ila oⱡnga, Saimon Pita ndi, nimba mel, “Wu Nuim ye! Na nga kʉmp raⱡ ⱡumʉiya ruin en ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wote Jisas ndi, punt ropa nimba mel, “Na uⱡ ent ei nga, akup nim pili napʉn. Wote nim molkʉn, pilkʉn kun itin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ndi, nimba mel, “Nim ndi, na nga kʉmp raⱡ ⱡumʉiya rundin mel kapⱡa mon!” nitim. Wote Jisas ndi, punt ropa nimba mel, “Nim nga kʉmp raⱡ ⱡumʉiya rui nʉrʉnt ndam, nim na kʉn muⱡi nʉmbʉⱡʉn, mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pita ndi, punt ropa, nimba mel, “Nuim ye! Na nga kʉmp raⱡ mendpʉⱡ mon. Na nga ki raⱡ kʉn, peng kʉn pʉi, ⱡumʉi rundil!” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wote Jisas ndi, nimba mel, “Wamp nam ti, nu tepa kai em ndam, aldpa nu temba mel mon. Wote kʉmp kʉⱡ mint, ⱡumʉi rangga kʉn, kʉng mbʉ pora, eng nomba. Ei mel, enim nga kʉng kʉⱡ, eng nonum. Wote, wu tenda ti, mint mon,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas ndi wu tenda ti, eng nu nanʉnʉm nitim. Ei nambuⱡ emel, elim nga ruk moⱡmba ei nga pilpa nitim. ");
INSERT INTO med_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wote, kʉmp ⱡumʉiya ropa pora ndupa, Jisas elim nga wal pʉki oⱡa ni kʉⱡ, tʉpa pakʉpa, elim murum nde pol nila int mba moⱡpa, nimba mel, “Uⱡ ent ei nga puⱡ ei, enim pilik kun enmin ei? ");
INSERT INTO med_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Na kundʉk, ik mbo wu ei nʉk, wote Wu Nuim ei nʉk enmin, ei kupa! Ei na waⱡʉm ei. ");
INSERT INTO med_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na enim nga Ik Mbo Wu ei, wote enim nga Wu Nuim ei ndi, enim nga kʉmp ⱡumʉiya rondunt. Ei mel, enim ndi, i ku etʉk, en enim rʉk ila ti ndi, ti nga kʉmp ⱡumʉiya rundʉi! ");
INSERT INTO med_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na ndi, uⱡ to rop enim kʉn ent ei mel, enim ndi, na nga kitip kandʉk, i ku etʉk, mek pʉi! ");
INSERT INTO med_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Enim ik kupa ei, kundʉp nʉnt. Kindmant wu ti, elim nga wu nuim ei, tʉpa mana ndumba, mel kapⱡa mon. Omba, nombuⱡa rʉng wu ti ndi, elim tʉpa mundum wu ti, tʉpa mana ndumba mel mon ku. ");
INSERT INTO med_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ik kupa nʉnt ei, enim pilik mormin, pʉnmin ei mel etʉk, mek pung ndam, numan wang ni, uⱡ mbʉ enim kʉn pemba, nitim. ");
INSERT INTO med_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ik nʉnt ei, enim pʉi kundʉp ni nanʉnt. Enim kʉmp rop tit ei, nanim pilip mor. Wote, Buk Wingti ila ik petʉm ei omba, kupa etmba. Enim ei ndi, nimba mel, ‘Wu ti ndi, na nga rʉng tʉpa nom ei ndi, na ruk muⱡʉmba.’ ");
INSERT INTO med_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Uⱡ wote, pemba ei nga, enim kuimp tep kundʉp nʉnt. Wote, uⱡ ei pem kandʉk kʉn, Na Wu Nam Moⱡ, ei enim ndi, mondʉk piling. ");
INSERT INTO med_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Enim ik kupa ei, kundʉp nʉnt. Wamp ti, na ndi, tʉp mundunt ei, nim wamp ti ndi, rawe etkʉn tin ndam, ei na rawe etkʉn tin. Wote, wamp nam ti ndi, na rawe etpa tʉm ndam, na tʉpa mundrum wu ei, rawe etpa tʉmba ku,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas ik nimba pora ndupa, elim mbun tʉpa nimba mel, “Na ik kupa ei, enim kundʉp nʉnt. Enim wu kʉⱡ nga ti ndi, na ruk muⱡing,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ni kʉn, kitip kʉni wu ni kʉⱡ ndi kundʉk nʉk mel, “Nam kundpa ninim nda?” Nʉk pilik, rundʉk ti ndi, ti kandrung. ");
INSERT INTO med_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas ndi, kitip kʉni wu ti, numan minal ngurum ni, elim kʉn nondpa murum. ");
INSERT INTO med_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Wote wu ni, Saimon Pita ndi, peng walinga ropa nimba mel, “Wu nam ti, kundpa ninim nda?” waldʉkʉn pili nitim. ");
INSERT INTO med_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kitip kʉni wu ni ndi, Jisas murum nila nondpa mba moⱡpa, waldpa nimba mel, “Nuim ye! Nim nam kundkʉn nʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas ndi, punt ropa nimba mel, “Bret ti tʉp, kopung kandʉp wu ti, ngamba tʉm wu ei, waⱡʉm ei,” nitim. Wote, bret ti tʉpa, kopung kandpa, Saimon Iskariyot kangʉm wu Juras ngurum. ");
INSERT INTO med_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ni kʉn, Juras ndi, bret ni tʉpa ambuⱡnga, tʉkrʉpa mint, Seitan omba, Juras nga numan ila murum. Wote Jisas ndi, nimba mel, “Uⱡ itin ti, tʉkʉrkʉn iti!” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nde pol ila morung wu nimbʉ ndi, Jisas nga nitim ik ni, tʉk mindi namindʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Juras ku moni wal kʉⱡ, rʉp itim ei nga, kitip kʉni wu ni kʉⱡ ndi pilik, Jisas ndi, ui rʉng ou ila rʉng mat, rarʉp ropa tangga, ninim nʉk pʉtʉng. Wote, mat ndi pilik, mel mbʉ tʉpa, wamp kurpa mbʉ ngangga nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Wote Juras ndi, bret ni tʉpa, mepa, pena purum. Ni kʉn, kona ni rumbʉⱡ ropa pitim. ");
INSERT INTO med_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Juras ni, pena puⱡnga, Jisas ndi, nimba mel, “Akup Muⱡʉl Wu Kupa ei, mbi ou tinim. Got elim Muⱡʉl Wu Kupa ei kʉn, mbi ou tinim. ");
INSERT INTO med_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Got nga mbi ou tʉmba uⱡ ei, Muⱡʉl Wu Kupa ei ndi, etpa mot ndum ndam, wote Muⱡʉl Wu Kupa ei, elim mbi ou tʉmba. Uⱡ ei, Got ndi, wamp mbʉ kʉn, etpa mot ndumba. ");
INSERT INTO med_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na nga kangambuⱡa mbʉ, na enim kʉn ui ruⱡ etʉp muⱡi nʉmbʉⱡimp. Ei kʉn, enim ndi, na andʉk kuring. Wote, na punt kona ila, enim ui nʉwing. Ik ei, Jura wamp mbʉ, kundʉp nit ei mel, enim kʉndʉp nʉnt. ");
INSERT INTO med_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Enim kʉn, mi ik kont ti, nʉmp ngʉnt ei, enim ndi, wamp mat numan ngʉi! Na ndi, enim numan ngur ei mel ku, enim ndi, wamp mat numan ngʉi! ");
INSERT INTO med_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Enim ndi, wamp mat numan ngʉng ndam, wamp elpa mbʉ ndi kandʉk, enim na nga kitip kʉni wu kʉⱡ, nʉk piling,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita ndi, Jisas waldpa nimba mel, “Nuim ye! Nim nant ila pin?” nilinga. Jisas ndi, punt ropa, nimba mel, “Na akup punt kona ila, nim uin mel mon. Wote, ui ti kʉn, na pep rokʉn uin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wote Pita ndi, waldpa nimba mel, “Nuim ye! Akup na nambuⱡ emel, nim pep rop ui nʉwimp. Na nim nga nindʉp kuⱡimp mor ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas ndi, punt ropa, nimba mel, “Nim kupa, na nga nʉndkʉn kuⱡin, ei nga tʉkʉn, kun etkʉn morʉn ei? Na ik kupa ei, nim kʉndʉp nʉnt. Kʉi kulda rui nʉri kʉn, nim ndi, na kʉni nakʉndʉr nʉkʉn, ronduⱡ mundkʉn raldika indin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas ndi, nimba mel, “Enim kit pilik, numan ou ndupa pili nʉpʉlʉi! Got mondʉk pilik, wote na kunda mondʉk pilʉi! ");
INSERT INTO med_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na nga wuta nga manga ila kʉkaⱡ minal tetʉm. Ei mel natilinga ndam, enim unt kundʉp nilmba. Wote, akup mbo enim nga kona ti tʉp kun itimp punt. ");
INSERT INTO med_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na mbo enim nga kona ti, tʉp kun etʉp pora ndup kʉn, yant omp enim tʉp mep pamba, na kʉn rʉp rop muⱡmin. ");
INSERT INTO med_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na mbi kona ei nga nombuⱡa mam ei, enim pilik mormin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ndi, nimba mel, “Nuim ye! Nim pin kona ei, tʉn pili napilip mormʉn. Wote, kona ila mbin ei nga nombuⱡa mam ei, etʉp pilimin mel nant nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas ndi, ik punt ropa, nimba mel, “Nombuⱡa mam ei na. Ik kupa ei na, wote kont mba mul uⱡ ei na. Wamp ti, na tʉpa waka ndupa, Wuta kʉn mba mel mon. ");
INSERT INTO med_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Enim na pilik mbi ndʉng ndam, Wuta i ku etʉk, pilik mbi nduing ku. Wote, akup ei kʉn, enim ndi, wu ei kandʉk pilik enmin,” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Wu Pilip ndi, nimba mel, “Nuim ye! Tipanʉm tʉn tʉkʉn ora ndui! Tʉn kʉnmin uⱡ ei ndi, tʉn nga numan orunga wang nangga!” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas ndi, punt ropa, nimba mel, “Na enim kʉn, ui ruⱡ etʉp mormʉn ni, wote nim na kandkʉn, mbi ndui nandʉn ei? Pilip, wamp nam ti, na kandpa, mbi ndurum ei ndi, Wuta kandrum. Ei kʉn, nambuⱡ emel, ‘Wuta ei, tʉn tʉkʉn ora ndui,’ nʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wu Pilip ye! Nim na mondkʉn pili napʉn ei? Na Wuta kʉn moⱡmba, Wuta ei na kʉn morum. Na ik enim kundʉp nʉnt mbʉ, nanim ndi, ni nandʉt. Wuta na kʉn morum ei ndi, elim nga kongun mbʉ enim. ");
INSERT INTO med_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na Wuta kʉn moⱡmba. Wuta ei, na kʉn morum. Nʉnt ik ei, mondʉk pilʉi! Ei mel mon ndam, na ent uⱡ mbʉ kandʉk kʉn, mondʉk pilʉi! ");
INSERT INTO med_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na ik kupa ei, enim kundʉp nʉnt. Na mondpa pilim wamp ti, na uⱡ ent mbʉ mel etmba. Ama kupa nʉnt, uⱡ ronduⱡ ou mat, na tʉpa mana ndupa etmba. Nambuⱡ emel, na Wuta kʉn punt. ");
INSERT INTO med_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na mbi tek angʉndʉk, mawa eng ei mel pilip indimp. Uⱡ ei ndi, Wuta nga uⱡ ronduⱡ mbʉ, kangʉm kʉn, etpa mot ndumba. ");
INSERT INTO med_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wote enim ndi, na nga mbi tek angʉndʉk mel ti, mawa eng ndam, na ndi indimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Enim ndi, na numan ngʉng ndam, na nga mi ik kʉⱡ pep rʉi! ");
INSERT INTO med_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Na nga Wuta waldʉp namba, Tʉpa Rʉpndi wamp elpa ti, enim ngumba. Ei Ik Kupa nga Muⱡnga ei, enim kʉn omba, uⱡ nga kʉnt nga moⱡpa mint mba. Mʉi kona wamp mbʉ ndi, Ik Kupa nga Muⱡnga ei, kandʉk ting mel mon. Nambuⱡ emel, wamp mbʉ ndi, Muⱡnga ei kandʉk, wote pili napʉtmin. Wote enim ndi, Muⱡnga ei pʉtmʉn. Ei nambuⱡ emel, enim kʉn akup morum, wote moⱡpa mint mba. ");
INSERT INTO med_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Enim kangambuⱡa etpa mel muⱡi nʉmbʉⱡing. Na enim kʉn yant uimp. ");
INSERT INTO med_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ui onunga kot ila, mʉi kona wamp mbʉ ndi, na kʉni nʉkʉning. Wote enim ndi, na kʉning. Nambuⱡ emel, na kont mbo mor ei mel, enim kont puk muⱡing ku. ");
INSERT INTO med_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wote, ui ei om kʉn, na Wuta kʉn mor. Wote, enim na kʉn mormin. Wote, na enim kʉn mor uⱡ ei, pilik kun iting. ");
INSERT INTO med_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Na nga mi ik kʉⱡ pilpa tʉpa, pep rorum wamp ei ndi, na numan ngurum. Wuta ndi, na numan ngorum ei mel ku, wamp ei numan ngumba. Wote na ndi, i ku etʉp, wamp ei numan ngamba. Na nga puⱡ ei, wamp ei kʉn, tʉp ora nduimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Wote, Juras (Iskariyot ei mon) ni ndi, nimba mel, “Nuim ye! Nambuⱡ emel, nim nga puⱡ ei, tʉn kʉn mint, nʉkʉn mot ndukʉn, wote mʉi kona wamp mbʉ, kʉn nʉkʉn, mot ndui nandʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Wote, Jisas ndi, punt ropa, nimba mel, “Wamp nam ti ndi, na numan ngum ndam, na nga ik mbo endʉnt mbʉ, pep romba. Wuta ndi, wamp ei numan ngangga. Wote tʉl ombuⱡ wamp ei kʉn, rʉk rʉk muⱡʉmbil ");
INSERT INTO med_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wamp nam ti ndi, na numan ngui nganggʉrʉm. Ei ndi, na nga ik mbo endʉnt mbʉ, pep rui narʉrʉm. Man ik enim pʉtmʉn ei, na nga mon. Na tʉpa mundrum Wuta ei nga ik, ei pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na enim kʉn kont moⱡʉp, enim ik mbʉ, kundʉp nʉnt. ");
INSERT INTO med_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Enim Tʉpa Rapundpa, ronduⱡ ngumba ei, Muⱡnga Wingti ei ndi, etmba Muⱡnga ei, na nga mbi ila, Wuta ndi, ngumba mundangga uⱡ mbʉ nga pora, mbo endʉmba. Muⱡnga Wingti ei ndi ku, ya enim kundʉp nit ik nimbʉ, enim kʉn etpa piral ndumba. ");
INSERT INTO med_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na nga numan wang ni uⱡ ei, enim kʉn wak ront ei, enim kʉn piyangga! Mʉi kona wamp mbʉ nga numan wang ndui uⱡ etmin ei nga ngui ngangʉnt. Ei kʉn, enim numan ou nduk, pilik mundmong iti nʉtʉi! ");
INSERT INTO med_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Na enim wak rop mbo, wote enim kʉn yant uimp.’ Ei nga, enim unt kundʉp nit. Enim na numan ngʉng ndam, na Wuta kʉn punt ei nga, kai pilik muⱡing. Ei nambuⱡ emel, na nga Wuta ei, na tʉpa mana ndupa oⱡa, orunga morum. ");
INSERT INTO med_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Uⱡ mbʉ, iti nʉti kʉn, na ndi, enim akup unt kundʉp nʉnt. Wote uⱡ mbʉ em ei kʉn, na mondʉk piling. ");
INSERT INTO med_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na enim kʉn, ik minal ni nʉnimp. Nambuⱡ emel, mʉi kona rʉp wu ei onum. Wu ei nga ronduⱡ ti ndi, na tʉpa mana ndumba, mel mon! ");
INSERT INTO med_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wote, mʉi kona wamp mbʉ ndi, na nga Wuta numan ngur uⱡ ei nga kandʉk, poⱡ ndeing. Nambuⱡ emel, na Wuta ndi, iti nʉtʉm uⱡ mbʉ pora, pep rop et. Wʉiya, ya kona ei, wak rop kelip pamin!” nitim. ");
INSERT INTO med_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Na nde wain kupa ei mor. Na nga Wuta nde wain pana rʉp etʉm. ");
INSERT INTO med_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wain puⱡa mat na kʉn mong rui narʉm mbʉ, koⱡmung etpa mundʉmba. Wote puⱡa mat mong ropa pem mbʉ, poⱡ ndupa etpa, kai etangga, mong minal romba. ");
INSERT INTO med_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Enim ik nʉmp ngur ni kʉⱡ ndi, enim kor nga etpa eng nʉndrʉm. ");
INSERT INTO med_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Na kʉn, rʉmp nduk, moⱡung ndam, na enim kʉn rʉmp ndup muⱡimp ku. Wain puⱡa ti, na kʉn rʉmp ni nanim ndam, nambuⱡ etpa mong romba? Wain puⱡa ti, nde mam ei kʉn, rʉmp nimba pem ndam, mong romba. Ei mel ku, enim na kʉn rʉmp nduk, moⱡʉng ndam, wain puⱡa kont mel mong ruing. ");
INSERT INTO med_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Na nde wain mam ei, enim nde wain puⱡa kʉⱡ. Wamp nam ti, na kʉn rʉmp ndupa muⱡangga! Na wamp ei kʉn, munt ndam, wamp ei mong minal romba. Na wak rokʉn nim mendpʉⱡ uⱡ ti, kapⱡa iti nʉtin. ");
INSERT INTO med_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wamp nam ti, na kʉn rʉmp ndup, muⱡi nambʉⱡʉm wamp ei, nde puⱡa mel rok tʉk, ekit ndangina, tepa kuⱡangga! Wote aprʉk tʉk, ndip kʉⱡing. ");
INSERT INTO med_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Enim na kʉn rʉmp nʉk muⱡangina, wote na nga ik mong ei, enim kʉn tem ndam, namba mel ti, numan nguk mawa eng ei, ting mint. ");
INSERT INTO med_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Enim na nga kitip kʉni wamp ralk, mong minal rok peng ndam, Wuta nga uⱡ ronduⱡ eng nui mbʉ, enim kʉn etpa mot ndumba. ");
INSERT INTO med_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Wuta ndi, na numan ngurum ei mel, na ndi, enim numan ngur. Enim na nga wamp numan ngur uⱡ ila muⱡʉi! ");
INSERT INTO med_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na ndi, Wuta nga man ik ei, pilip tʉp, elim nga wamp numan ngui uⱡ ila rukʉr mor. Ei mel, enim ndi, na nga mi ik ei, pilik tʉng ndam, na nga wamp numan ngui uⱡ ila muⱡing. ");
INSERT INTO med_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Enim ik kundʉp nʉnt ei ndi, Na nga numan kai pili uⱡ ei, enim kʉn pemba. Wote, enim nga numan kai piling uⱡ ei, etpa kapⱡa endʉmba. ");
INSERT INTO med_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na nga mi ik ei ndi, nimba mel, “Na ndi, enim numan ngur ei mel, enim ndi, i ku etʉk, ti ndi, ti numan ngʉi! ");
INSERT INTO med_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wamp nam ti ndi, elim nga kont muⱡ uⱡ ei, wamp ti nga nindpa, wak rom ndam, wamp numan ngui uⱡ wei etmin mbʉ, tʉpa mana ndumba. ");
INSERT INTO med_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na ndi, enim kundʉp nʉnt. Ei mel eng ndam, enim na nga wamp mʉn mendpʉⱡ kʉⱡ muⱡing. ");
INSERT INTO med_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na ndi, enim kundʉp, kindmant wamp ni nʉnimp! Nambuⱡ emel, kindmant wamp ei ndi, elim nga wu nuim ei, etʉm uⱡ mbʉ pili napʉtʉm. Na ndi, enim mbi tep, na nga wamp mʉn kʉⱡ nʉnt. Ei nambuⱡ emel, Wuta ndi, na man ik ngurum mbʉ pora, enim kundʉp nʉt. ");
INSERT INTO med_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Enim ndi, na kʉmp rok ti natʉtʉng. Na ndi, enim kʉmp rop tʉp, kongun ila tʉp mundʉr. Ei uⱡ nga kʉnt nga nde mong minal, enim kʉn ropa muⱡ piyangga! Wote enim ndi, na nga mbi tek angʉndʉk, atinga rok, namba mel ti, Wuta kʉn mawa eng ndam, nʉng mel mbʉ pilpa ngumba. ");
INSERT INTO med_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Enim ndi, wamp mat numan ngʉk muⱡʉi! Ei na nga mi ik ei, enim kundʉp nʉnt.” nitim. ");
INSERT INTO med_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mʉi kona wamp mbʉ ndi, enim numan ngui nganggʉrmʉn ndam, kuimp tek ngangʉng, na numan ngui nganggʉrʉng ei mel ku, enim nʉk pilʉi! ");
INSERT INTO med_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Enim ya mʉi kona ila wamp kat ndam, ya mʉi kona wamp mbʉ ndi, enim kʉn mʉn mondʉk, numan nguⱡina. Wote na ndi, enim kʉmp rop tit ei nga, enim mʉi kona wamp ralk, muⱡing mel mon. I it uⱡ ei ndi, mʉi kona wamp mbʉ ndi, enim numan ngui nganggʉrmin. ");
INSERT INTO med_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na ndi, enim kundʉp nit ik ni, pilik muⱡʉi! ‘Kindmant wu ti ndi, elim nga wu nuim ei tʉpa mana ndumba mel mon!’ Na mbun ngorung ndam, enim i ku iting. Na nga ik ei, pilik teng ndʉⱡʉngina ndam, enim nga ik ei, i ku etʉk, pilik teng nduing. ");
INSERT INTO med_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na ndi, enim kʉmp rop tit ei nga uⱡ mbʉ, enim kʉn iting. Nambuⱡ emel, na tʉpa mundrum wu ei, pili napʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na mana omp ik mbʉ, ni nandilimba ndam, wamp mbʉ nga uⱡ kit etmin mbʉ, mot ni nandilinga. Wote akup, en enim nga uⱡ kit mbʉ, mo ruing kona ti, ti natʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wamp nam ti ndi, na numan ngui ngangʉm ndam, Wuta numan ngui nganggʉrʉm ku. ");
INSERT INTO med_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wamp ndi, iti natʉtmʉn uⱡ rʉpndi mat, na ndi it. Uⱡ rʉpndi mbʉ iti natilimba ndam, wamp mbʉ nga uⱡ kit etmin mbʉ, mot ni nandilinga. Wote, uⱡ rʉpndi mbʉ, kandʉk kelik, na kʉn Wuta raⱡ, numan ngui nganggʉrmʉn. ");
INSERT INTO med_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","En enim nga mi ik ila nimba mel, ‘Na kʉn kai kandʉk numan ngui nganggʉrmʉn,’ nʉtʉm. Mi ik ei omba, kupa etmba ei nga uⱡ mbʉ iting mel enmin. ");
INSERT INTO med_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tʉpa Rupʉndi Muⱡnga kupa ei Wuta kʉn morum. Morum ei, enim kʉn tʉpa mundangga, na nga ik mat tʉpa pena ila pendpa nimba. ");
INSERT INTO med_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wote enim ndi, na nga ik ninding ku. Nambuⱡ emel, unt kuimp tepa enim na kʉn kunda murmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Enim nga mondpa pili ei, ropa mbuⱡ mbaⱡ iti nʉtangga nʉmp kʉn, enim ik mbʉ kundʉp nʉt. ");
INSERT INTO med_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Enim atinga manga ila, ui nʉweing nʉk, enim rok pep ruing. Wote, wamp mat ndi, enim rok kondʉk kʉn, Got nga uⱡ kun kai ti, endʉnmʉn nʉk piling, ui ei nondpa onum. ");
INSERT INTO med_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Uⱡ mbʉ enim kʉn iting. Ei nambuⱡ emel, Wuta kep, na kep, pilik mbi ndui nandʉrmʉn. ");
INSERT INTO med_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wote na ndi, enim ik mbʉ, unt kundʉp nit. Wote, uⱡ mbʉ pemba ei nga, ui ei, ekit om kʉn, enim ndi, kundʉp nʉnt ik mbʉ, wote molk piling. Enim ik mbʉ, unt kundʉp ni nʉndʉt. Ei nambuⱡ emel, na enim kʉn kunda murmʉn. ");
INSERT INTO med_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wote akup, na tʉpa mundrum puⱡ wu ei kʉn punt. Wote, enim kʉⱡ nga ti ndi, na waldʉk nʉk mel, ‘Nim nant ila pun?’ nʉk, ni naninmin. ");
INSERT INTO med_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ei nambuⱡ emel, enim ik kundʉp nʉnt nimbʉ nga, enim munt mindil tʉnmʉn. ");
INSERT INTO med_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wote, ik kupa ei, enim kundʉp nʉnt. Na enim nga nindʉp, enim wak rop mbi. Wote, na pi nʉpʉnt ndam, enim Tʉpa Rapʉndʉmba Wamp ei, ui nawʉmba. Wote na punt ndam, enim Tʉpa Rapʉndʉmba Wamp ei, enim kʉn tʉp mundimp. ");
INSERT INTO med_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wote, wamp ei om kʉn, mʉi kona wamp mbʉ nga uⱡ kit etmin mbʉ kʉn, uⱡ kun kai etmin mbʉ kʉn, wote Got nga wamp mbʉ kʉmp tʉmba. ");
INSERT INTO med_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wote akup ei kʉn, uⱡ kit mbʉ etʉk mormʉn. Ei nambuⱡ emel, na mondʉk pili napilik mormʉn. ");
INSERT INTO med_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Uⱡ kun kai mbʉ, tʉpa pena ila pendʉmba. Ei nga, na Wuta kʉn punt. Wote, na kʉni nʉkʉning. ");
INSERT INTO med_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Got nga wamp mbʉ, kʉmp tʉtʉm uⱡ ei, wote tʉpa pena ila pendʉmba. Nambuⱡ emel, mʉi kona uⱡ kit etmin mbʉ nga wu peng ei, tʉpa mana ndurum. ");
INSERT INTO med_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na nimp ik puⱡi petʉm. Ei nga wote, akup enim pilik tʉk, kapⱡa indi nʉnding. ");
INSERT INTO med_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wote, Muⱡnga Kupa ei om kʉn, enim nombuⱡa kupa kun kai ila, tʉpa kun mundʉmba. Elim nga numan ila, ik ti oⱡa tʉpa ni nanʉmba. Uⱡ wote, pemba mbʉ nga pilpa kandpa etʉm ei mel nimba. ");
INSERT INTO med_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na nga ik mbʉ, tʉpa enim kundpa nimba. Nambuⱡ emel, uⱡ ei ndi, na nga mbi ei, tʉpa ou ndupa, paka rondʉmba. ");
INSERT INTO med_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wuta nga mel mbʉ pora, na nga. Ei nga, na ndi, nʉmp kʉn, na nga ik mbʉ, Muⱡnga ei ndi, tʉpa enim kundpa nimba. ");
INSERT INTO med_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ui onunga wei kot ila, na kʉni nʉkʉning. Wote, aldpa ui onunga wei kot ila, na kʉning,” nitim. ");
INSERT INTO med_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kitip kʉni wu ni kʉⱡ ndi, en enim nʉk mel, “Ui onunga wei tila na kʉni nʉkʉning. ‘Wote ui onunga wei kot ila, na aldpa kʉning,’ ninim. Wote, aldpa tʉn kundpa, ‘Na Wuta kʉn mbi,’ ninim. Ei, etpa ninim mel nant nda? ");
INSERT INTO med_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wote, ui onunga wei kot ninim ei, etpa ninim mel nant nda? Ik ninim ei nga puⱡ ei, tʉn pilip rundʉnmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas elim wuldʉng pilik, etʉng ei nga, pilpa nimba mel, “‘Ui onunga wei kot ila, na kʉning. Wote, ui onunga wei kot ila, na aldpa kʉni nʉkʉning’ nʉnt. Ik ei nga, en enim tek rombulk nʉnmin ei? ");
INSERT INTO med_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Enim ik kupa ei, kundʉp nʉnt. Enim ka etʉk, moⱡangina kʉn, wote mʉi kona wamp mbʉ ndi, ambulk palk muⱡing. Enim mindil nok muⱡangina, wote numan kai piling uⱡ ei, ekit omba. ");
INSERT INTO med_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Amp ti, kangambuⱡa memba ui ei, nondpa elinga, kangambuⱡa mbuⱡ rorum. Wote, mepa tʉpa kʉn, mindil norum uⱡ ei, tʉpa apra ndupa, na nga kangambuⱡa ti, mʉi kona ila mint nimba, numan ndi korum. ");
INSERT INTO med_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ei mel ku, akup, enim munt mindil enim. Wote, na enim kʉnt ei kʉn, enim nga numan orunga ambuⱡpa pʉl uⱡ ei pemba. Ambuⱡpa pʉl uⱡ ei, wamp ti ndi, roldpa ti natʉmba. ");
INSERT INTO med_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wote ui ei, ekit om ei kʉn, enim ndi, na kʉn mel ti mawa iti nʉting. Na ik kupa ei, enim kundʉp nʉnt. Na nga mbi tek angʉndʉk, Wuta kʉn mawa eng ei mel pilpa ngumba. ");
INSERT INTO med_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Unt ui ei kʉn, omba akup ui ila, enim ndi, na nga mbi ila, mel ti mawa iti natʉtʉng. Mawa etʉk kʉn, mel ti tʉng ei kʉn, enim nga numan orunga, ambuⱡpa pʉl uⱡ ei, peka ropa pemba. ");
INSERT INTO med_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Na nʉt ik mbʉ, ik ek rop, enim kundʉp nʉt. Wote, ui ti om kʉn, enim ik ek rop, ni nʉnimp mon! Na ndi, Wuta nga ik kun ei, enim kʉn para ndup nimp. ");
INSERT INTO med_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wote ui ei, ekit om kʉn, enim ndi, na nga mbi tek angʉndʉk, Wuta kʉn atinga rong ndam ting. Ei nʉmp kʉn, na ndi, enim nga nindʉp Wuta kʉn atinga rundimp ni nanʉnt. ");
INSERT INTO med_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nambuⱡ emel, Wuta elim ndi, enim numan ngurum. Ei nambuⱡ emel, enim ndi, na numan ngʉk, na Got kʉn moⱡʉp, mana ur nʉk mondʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Got kʉn moⱡʉp, ya mʉi kona ila mana ur. Wote akup, ya mʉi kona wak rop, Wuta kʉn mbi,” nitim. ");
INSERT INTO med_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wote, kitip kʉni wu ni kʉⱡ ndi, nʉk mel, “Akup nim ik ek rui narkʉn, ik kun mint nʉn. ");
INSERT INTO med_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Akup tʉn pʉnmʉn ei, nim uⱡ mbʉ nga pora pilkʉn ketʉn, wamp ti ndi, nim ik mat waldpa, ni nanʉmba. I en uⱡ ei ndi, nim Got kʉn molkʉn urʉn nimbun, nim mondʉp pilip mormʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wote Jisas ndi, punt ropa, nimba mel, “Enim ndi, na akup mondʉk pʉnmʉn ye! ");
INSERT INTO med_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ui ti omba ei, akup kor om. Enim ndi, na wak rok, mbuⱡ mbaⱡ nʉk, elpa elpa mang kona ping. Na mendpʉⱡ mondʉk, kelik ping. Wote, na mendpʉⱡ muⱡi nʉmbʉⱡimp. Nambuⱡ emel, Wuta na kʉn morum. ");
INSERT INTO med_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na enim ik i etʉp kundʉp nʉnt. Ei ndi, enim nga numan ei, na kʉn tiyangina, wang nangga. Enim mʉi kona uⱡ mbʉ ndi, etpa mindil kundʉmba. Wote, enim ronduⱡ mundʉk muⱡʉi! Ya mʉi kona uⱡ kit mbʉ, na ndi, rop mana ndunt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wote, Jisas ndi, ik nimbʉ, nimba pora ndupa, tʉpa oⱡa ndupa, muⱡ kona kandpa, nimba mel, “Wuta ye! Ui ei, nondpa enim, nim nga uⱡ eng nui mbʉ kangnʉm kʉn, etkʉn mot ndui! Wote kangnʉm ndi, nim nga uⱡ eng nui mbʉ, etpa mot ndumba! ");
INSERT INTO med_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nim ndi, kangnʉm ronduⱡ ngurun ei ndi, mʉi kona wamp mormʉn mbʉ pora, rʉp etmba. Ei nga, wamp mat ninim ndi, kangnʉm ngurun nimbʉ, uⱡ nga kʉnt nga kont mul uⱡ ei ngumba. ");
INSERT INTO med_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wote, uⱡ nga kʉnt nga kont mul uⱡ ei, ei mel, nim Got kupa morʉn nʉk pilik, wote Jisas Kraist nim ndi, tʉkʉn mundrun nʉk piling. ");
INSERT INTO med_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na ndi, nim nga uⱡ eng nui mbʉ, ya mʉi kona ila tʉp ora ndur. Nim nga kongun na ngurun nimbʉ, etʉp pora ndont. ");
INSERT INTO med_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wuta, muⱡ mʉi raⱡ pi nʉpi kʉn, na nga uⱡ eng nui mat, nim kʉn kunda tep murumbʉⱡ. Nimbʉ, akup nanim ngui! ");
INSERT INTO med_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nim ndi, mʉi kona ila wu mat, ekit tʉkʉn, na ngurun wu nimbʉ, nim nga mbi ei, pileing nʉmp kundʉp nit. Wu mbʉ, nim nga mbʉ, wote nim ndi, tʉkʉn na ngurun. Wu mbʉ ndi, nim nga ik ei, pilik teng ndurmin. ");
INSERT INTO med_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nim ndi, mel mat, na ngorun mbʉ, akup nim kʉn tepa orum nʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nim nga ik, na nʉkʉn ngurun nimbʉ, kundʉp nilimba, pilik tʉtmʉn. Na nim kʉn moⱡʉp ur. Wote nim ndi, na tʉkʉn mundrun nʉk, ik kupa ei, mondʉk pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na ndi, wu kʉⱡ nga nindʉp atinga ront. Mʉi kona wamp mbʉ nga mon. Nambuⱡ emel, wu kʉⱡ nim nga. ");
INSERT INTO med_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na tep mor mel mbʉ, nim nga. Wote nim tekʉn morʉn mbʉ, na nga. Mel mbʉ ndi, na nga mbi ei, etʉk eng nondʉrmʉn. ");
INSERT INTO med_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Akup na mʉi kona wak rop, nim kʉn uimp. Wote wu kʉⱡ, mʉi kona ila muⱡing. Wuta Wingti ye! Nim nga ronduⱡ, na kʉn tetʉm ila ku, wu kʉⱡ rup etkʉn, kai mundi! Nim kʉn, na kʉn, tenda purum ei mel, wu kʉⱡ i ku etʉk muⱡeing. ");
INSERT INTO med_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na wu kʉⱡ kʉn, murmʉn ei kʉn, nim nga mbi ronduⱡ ei tʉp, wu kʉⱡ rʉp etʉp kai mundʉr. Na ndi, wu kʉⱡ, rʉp etʉp kai mondʉⱡʉmba. Wu ti, tiki puⱡi pi nʉpʉrʉm. Wote, wamp tenda ti, mba tiki purum ei, kit moⱡmba wamp ei, Buk Wingti ila petʉm ik ei omba, kupa etmba ei nga etmba. ");
INSERT INTO med_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ei nga, akup na nim kʉn uimp. Ya mʉi kona ila moⱡʉp, ik nʉnt mbʉ ndi, na nga ambuⱡpa pʉl uⱡ ei, wu kʉⱡ nga numan orunga, peka ropa muⱡangga. ");
INSERT INTO med_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nim nga ik ei, nʉmp nguⱡmba mʉi kona wamp mbʉ ndi, wu kʉⱡ numan ngui nganggʉrmʉn. Ei nambuⱡ emel, na mʉi kona wu ti mon. Ei mel, wu kʉⱡ mʉi kona wu kat mon. ");
INSERT INTO med_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ya mʉi kona ila wu kʉⱡ, ekit tʉn nʉmp waldʉp ni nanʉnt. Wote wu kʉⱡ, wu kit ei ndi, etpa kit mondʉmba ei nga rʉp etkʉn, kai mundun nʉmp nʉnt. ");
INSERT INTO med_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na ya mʉi kona ila wu ti mon. Ei mel ku, wu kʉⱡ, ya mʉi kona ila wu kat mon ku. ");
INSERT INTO med_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nim nga ik kupa ei ndi, wu kʉⱡ mbo endkʉn, etkʉn wingti rundi! Nambuⱡ emel, nim nga ik ei ama kupa. ");
INSERT INTO med_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na mʉi kona ila, nim ndi, tʉkʉn mundrun ei mel, na ndi, wu kʉⱡ mʉi kona ila tʉp mundunt. ");
INSERT INTO med_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na nga mul uⱡ ei, wu kʉⱡ nga nindʉp, nim ngunt. I ent uⱡ ei ndi, wu kʉⱡ etpa, nim nga wu wingti kupa kʉⱡ mundangga! ");
INSERT INTO med_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na ndi wu kʉⱡ nga mendpʉⱡ, atinga rui narʉnt mon. Ya wu kʉⱡ nga ik ei, pilik tʉk, na mondʉk piling wamp mbʉ nga pendʉp atinga rondʉnt. ");
INSERT INTO med_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Wuta, na nim kʉn moⱡmba, nim na kʉn morʉn ei mel nʉnt, Wamp mbʉ i ku etʉk, muⱡeing nʉmp atinga rondʉnt. Wamp tenda mel ralk, moⱡʉng uⱡ ei ndi, mʉi kona wamp mbʉ, ora nduk, nim ndi, na tʉkʉn mundrun nʉk, mondʉk piling. ");
INSERT INTO med_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nim nga mbi ei, tʉp ou ndup, uⱡ ronduⱡ na ngurun nimbʉ, wamp kʉⱡ ngur. Nambuⱡ emel, nim na kʉn numan tenda petʉm ei mel, wamp kʉⱡ numan tenda pangga muⱡeing. ");
INSERT INTO med_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na wamp kʉⱡ kʉn mor. Wote nim na kʉn morʉn. Wote, nim ndi, na numan ngorun ei mel, wamp kʉⱡ i ku etkʉn, numan ngana, numan tenda pangga muⱡeing. Wote mʉi kona wamp mbʉ ndi kandʉk kʉn, nim ndi, na tʉkʉn mundrun nʉk pileing. ");
INSERT INTO med_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Wuta! Nim ndi, wamp kʉⱡ na ngurun ei nga, na mor kona ila rʉp rop muⱡʉmin. Ila molk, na nga uⱡ eng nui nim ndi, ngurun mbʉ kʉneing. Nambuⱡ emel, muⱡ mʉi raⱡ pi nʉpi kʉn, nim ndi, na numan ngurun. ");
INSERT INTO med_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Uⱡ kun kai mbʉ nga Wuta, mʉi kona wamp mbʉ ndi, nim pili napʉtmʉn. Na ndi, nim nga pʉⱡ ei pʉt. Wote nim ndi, na tʉkʉn mundrun uⱡ ei, wamp kʉⱡ ndi pʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na ndi, nim nga mbi ei, wamp kʉⱡ kʉn, etʉp tʉp pena ila mot ndur. I et ei mel, rʉk rʉk etamba. Nim ndi, na numan ngurun uⱡ ei, wamp kʉⱡ kʉn, i ku etpa piyangga! Wote na wamp kʉⱡ kʉn muⱡimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wote Jisas ni, atinga ropa pora ndupa kʉn, kitip kʉni wu ni kʉⱡ, tʉpa mepa, nu Kitron puⱡa ropa, noi orunga pana ti titim nila purung. ");
INSERT INTO med_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kona nila ui mat kʉn, Jisas elim nga kitip kʉni wu kʉⱡ kʉn, puk ku etʉng. Ei nga, Jisas ruk murum wu Juras ni ndi, kona ei tʉpa mindʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ni kʉn, wu Juras ni, wu pris kuimbal na, Perisi na nimbʉ ndi molk, el wu na, manga wingti rʉp wu na mat kʉn tʉk, kup endʉtʉng. Wu nimbʉ, el mel mbʉ tʉk, kiya kandʉk, mek wi pana nila purung. ");
INSERT INTO med_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Uⱡ pemba nimbʉ, Jisas ndi, pilpa pora ndupa, oⱡa moⱡpa nimba mel, “Enim nam kurʉnmʉn ye?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wote, wu nimbʉ ndi, punt rok nʉk mel, “Nasaret wu Jisas,” nʉtʉng. Jisas ndi, punt ropa nimba mel, “Na ya mor ei ka!” nitim. Jisas ruk murum wu Juras ni, kunda ila morung. ");
INSERT INTO med_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wote Jisas ndi, nimba mel, “Na ya mor,” nitim. Ni kʉn, wu nimbʉ int puk, mʉi ila ropa munduⱡnga puk petʉng. ");
INSERT INTO med_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wote aldpa, Jisas ndi waldpa nimba mel, “Enim wu nam andʉk kurʉnmʉn,” nitim. Wote, wu nimbʉ ndi, kundʉk nʉk mel, “Nasaret wu Jisas,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisas ndi, nimba mel, “Na unt enim kundʉp nʉnt ni, enim kurʉk onmʉn wu ei, na mor. Ei nga, ya wu kʉⱡ, wak rok mundʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ik i etpa nitim ni, elim nga ik unt nitim ni, omba kupa etangga, nimba nitim. “Wuta! Nim ndi, na ngurun wamp nimbʉ nga ti, wak rui narʉnt!” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ni kʉn, Saimon Pita koiya ruⱡ ti, tepa murum ni ndi, tʉpa nont ndupa, Pris kuimbal ei nga kindmant wu ni nga kum mbo orunga, ropa puⱡa rurum. Kindmant wu ni nga mbi ei, Malkus. ");
INSERT INTO med_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas ndi, Pita kundpa, nimba mel, “Koiya ei, elim petʉm kona ila mana nduk pindi! Wuta ndi, na mindil mam ngumba ei, ti nʉteimp nʉkʉn en ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wote, el wu nimbʉ kʉn, en enim nga wu kuimbal ni kʉn, wote rʉp wu na orung nimbʉ ndi, Jisas tʉk imp molk, kan ngurung. ");
INSERT INTO med_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jisas ni, kuimp tek, wu Anas ni kʉn, mek purung. Wu ni, Kaiyapas nga kulpam ei, pana ni kʉn, wu ei pris wu kuimbal murum. ");
INSERT INTO med_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyapas ni, wu ei ndi, Jura wamp mbʉ, man ngumba nimba mel, ‘wu tenda ti ndi, wamp mbʉ nga tʉpa rak ndupa, koⱡnga ndam, kapⱡa nitim,’ nitim. ");
INSERT INTO med_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita kʉn, kitip kʉni wu ti kʉn, Jisas mek purung ni mel, akil tekʉⱡ purʉnggil. Pris wu kuimbal ni ndi, kitip kʉni wu ti, kandpa mbi ndurum ni, murʉk ui nilinga purum. ");
INSERT INTO med_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Saimon Pita ni, paⱡa keta puⱡ puⱡ nila, pena orunga murum. Ni kʉn, Pris wu kuimbal ei nga pʉⱡ petʉm kitip kʉni wu ni, yant omba, amp ti, keta puⱡ puⱡ rup itim ni, kundpa Pita murʉk wangga ni nilinga, murʉk urum. ");
INSERT INTO med_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Amp ni ndi, Pita waldpa nimba mel, “Nim ya imp moⱡʉng wu ei nga kitip kʉni wu ti, nʉmp pʉnt ei ka!” nitim. Pita ndi, punt ropa, nimba mel, “Mon, na mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kona ni, ʉt itim ila, kongun wu na, rʉp wu na nimbʉ, ndip kalk pendʉk, ndip pilik morung. Pita ni, el elim ila, ndip pilpa murum ku. ");
INSERT INTO med_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pris wu kuimbal ni ndi, Jisas elim nga ik mbo inditim. Wote, kitip kʉni wu ni kʉⱡ nga waldpa nitim. ");
INSERT INTO med_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Wote Jisas ndi, punt ropa, nimba mel, “Na ndi, rʉk rʉk atinga manga na, manga wingti ou na mbila, Jura wamp ok, mou rok morung ila, wamp pora pileing nʉmp ik mbo indʉt. Ik ti mou rop ni nʉndʉt. ");
INSERT INTO med_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na wote, nambuⱡ emel waldʉn? Na ik nʉmp ngur pʉtʉng wamp mbʉ, waldʉkʉn pila! Na ndi, kundʉp nit ik mbʉ, pilik mormʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wote Jisas ndi, ik i etpa nilinga, manga wingti rʉp itim el wu ti ndi, ki ⱡʉrwʉ ndi ropa, nimba mel, “Pris kʉⱡ nga wu kuimbal morum ei, nambuⱡ emel nʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas ndi, punt ropa, nimba mel, “Na ndi, ik ti nʉmp ⱡawa mundunt ndam, ya wamp mormʉn mbʉ kundkʉn ni! Wote, na ik kun ti, nint ku ndam, na nambuⱡ emel ron?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wote, Jisas nga ki raⱡ kan ngurung ni mel pelinga, Anas ndi, kelpa wu Kaiyapas pris kuimbal murum nila, tʉpa munduⱡnga, mek purung. ");
INSERT INTO med_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita ni, ndip pilpa murum ila, wamp mat ndi, waldʉk nʉk mel, “Nim wu ei nga kitip kʉni wu ti, nʉmp pʉnmʉn ei?” nʉtʉng. Pita ndi, nimba ronduⱡ mundpa, “Na mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wu Pris kuimbal ei nga kindmant wu ti, Pita ndi, ropa kum ei, puⱡa rurum. Wu ni nga rʉⱡaip tenda ila wu ti ndi, nimba mel, “Nim wi pana ila wu ei kʉn, kunda moⱡʉng ni ka!” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aldpa Pita ndi, na mon nilinga, tʉngʉnda mint, kʉi kulda rurum. ");
INSERT INTO med_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jisas ni, Kaiyapas nga manga ila murum ni, tʉk mek, wi gapman kona peng ila purung. Ei kʉn, mʉkʉlmʉ unt, Jura wu nimbʉ, murʉk pi naprʉng. Ei nambuⱡ emel, en enim murʉk mbun ndam, aldpa ⱡar muⱡangga. Wote Pasopa rʉng nui nʉnmin nʉk, pilik etʉng. ");
INSERT INTO med_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ni kʉn, Pailot ndi, pena mba wamp morung mbʉ, waldpa nimbʉ mel, “Enim uⱡ puⱡ, nant ila wu ei, mek onmʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wamp nimbʉ ndi, punt rok nʉk mel, “Wu ei nga ⱡawa ti, pi napilinga ndam, mep ui nawʉⱡʉmina,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ni kʉn, Pailot ndi, nimba mel, “Enim nga mi ik petʉm ei mel, nʉk tʉk kun mundeing mek pʉi!” nitim. Wote, Jura wu nimbʉ ndi, nʉk mel, “Rom gapman ndi, wamp ti, rok kundi ni nandʉtʉm,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Uⱡ ei, Jisas elim ruing ei mel, unt nimba mot ndurum, ni mel wote, kupa itim. ");
INSERT INTO med_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailot ni, elim kot pʉtʉm manga ila murʉk mba, Jisas wi ropa tʉpa mundpa, waldpa nimba mel, “Nim Jura wamp mbʉ nga wu peng mumuk ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas ndi, punt ropa, nimba mel, “Int ik nʉn ei, ninim nʉn, muna wamp mat ndi, nilingina, nʉn ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wote Pailot ndi, punt ropa, nimba mel, “Nim ndi, na Jura wu ti, nʉkʉn pʉn ei? Nim nga wamp na, en enim nga Pris kuimbal na mbʉ ndi, nim tʉk, na nga ki ila tʉndʉng. Ei nga, nim namba uⱡ ⱡawa ei in?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Wote Jisas ndi, punt ropa, nimba mel, “Na nga wamp tʉpa mumuk rui uⱡ ei mʉi kona ila ti natʉtʉm. Na nga wamp tʉpa mumuk rui uⱡ ei, mʉi kona ila telinga ndam, na nga kongun wamp mbʉ ndi, Jura wamp mbʉ kʉn, el pendʉk, na kelip int timin nilingina. Ei nga, na nga wamp tʉpa mumuk rui uⱡ ei ya ila ti natʉtʉm mon!” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Wote Pailot ndi, waldpa nimba mel, “I ndam, nim wu nuim mumuk ti pʉnt ei ka!” nitim. Jisas ndi, punt ropa, nimba mel, “Nim ndi, na wu nuim mumuk nʉn ei ka! Ik kupa ei nga, para ndup nimp ei nga, na mʉi kona ila metʉng. Ik kupa ei nga, wamp ti ndi, na nga ik ei pilpa tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailot ndi, waldpa nimba mel, “Ik kupa nant ei nga nʉn ei?” nitim. Nimba pendpa, pena mba, Jura wu nimbʉ kundpa nimba mel, “Na ya wu ei nga uⱡ ⱡawa ti, kandʉp ti natʉnt mon! ");
INSERT INTO med_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Wote, enim nga Pasopa rʉng normin ui ila, rʉk rʉk kan manga wu ti, tʉp ekit ndup ngur ni mel ngamp, nʉk piling ndam, Jura wamp mbʉ nga king wu ei, ngamp ei?” nitim. ");
INSERT INTO med_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ni kʉn, wamp mbʉ ronduⱡ ke nʉk, “Int wu ei mon! Tʉn nga wu Barapas wangga!” nʉtʉng. (Barapas ni punt wu ei). ");
INSERT INTO med_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wote Pailot ndi, Jisas ni mek, puk komnga pilda ndi, rʉi! nitim. ");
INSERT INTO med_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","El wu nimbʉ ndi, kan goimbun rong mul mat, tʉk mʉkʉp etʉk, King mbʉ nga wʉna mondʉrmʉn, ei mel endʉtʉng. Wote, wal pʉki kunt ruⱡ kat i ku etʉk, tʉk pakʉndrʉng. ");
INSERT INTO med_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wote, el wu nimbʉ ndi, nʉk mel, “Kʉnʉiya! Ya wu ei, Jura wamp mbʉ nga Wu Nuim Mumuk ye!” nʉtʉng. I nʉk kʉn, ki raka ndi rorung. ");
INSERT INTO med_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ni kʉn, Pailot aldpa pena mba, wamp mou morung nimbʉ kundpa nimba mel, “Ya kʉnʉiya! Na ndi, wu ei nga uⱡ ⱡawa ti kandʉp, ti natʉnt. Ei nga akup, mep pena omp, enim tʉp waka nduimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ei kʉn, Jisas ni, kan goimbun wʉna mel ni pakʉpa, muⱡ ruⱡ ni kʉⱡ raⱡpa, pena oⱡnga, Pailot ndi, wamp morung nimbʉ kundpa nimba mel, “Na nʉnt wu ni, ya kʉnʉiya!” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wote, Pris kʉⱡ nga wu kuimbal kʉⱡ kʉn, rʉp wu nimbʉ kʉn, Jisas ni kandʉk, ke nʉk mel, “Nde peta ila nil ro! Nde peta ila nil ro!” nʉtʉng. Pailot ndi, punt ropa, nimba mel, “Na ndi, wu ei nga uⱡ ⱡawa ti kandʉp, ti natʉnt. Ei kʉn, en enim ndi, mek puk, nde peta ila nil rok pindʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ni kʉn, Jura wamp nimbʉ ndi, punt rok, nʉk mel, “Tʉn nga mi ik ti petʉm ei ndi, nimba mel, wu ei, elim Got nga kangʉm nʉtʉm uⱡ ei nga kuⱡangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ik ei mel nʉtʉng ni, Pailot ndi, pilpa mundmong minal itim. ");
INSERT INTO med_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wote, Pailot manga ila int mba, Jisas ni, waldpa nimba mel, “Nim nant ila molkʉn urʉn?” nitim. Wote Jisas ndi, ik ti, punt rui nʉrʉrʉm. ");
INSERT INTO med_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ni kʉn, Pailot ndi, Jisas kundpa nimba mel, “Nim rok kundʉi, nint ndam, rok kunding! Muna wak runt ndam, wak ruimp, ei nga ronduⱡ ei, na tep mor,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas ndi, punt ropa, nimba mel, “Nim Got ndi, ronduⱡ ngui nganggʉⱡnga ndam, na tʉkʉn mana ndui nandʉⱡina. Ei nga, na tʉpa, nim nga ki ila amʉndʉm wu ei nga nit ei, oⱡa mba petʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailot ndi, ik ni pilpa, nombuⱡa ti kandʉp tʉp, Jisas ni, wak rop mundimp nimba pitim. Ni kʉn, Jura wamp nimbʉ ndi, ke nʉk, “Wu ei, tʉkʉn ekit ndun ndam, nim wu nuim mumuk Sisa nga wu mʉn ti mon. Wu ti, elim wu nuim ei, nʉm ndam, nuim mumuk Sisa ei, tʉpa pei mundʉmba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailot ndi, ik ni pilpa, Jisas ni, mepa pena omba, elim ni, kot pʉtmʉn kona ila mana murum. Kona ei mbi tek ku pol nʉtmin. Grik ik ila mbi tek, ‘Gapata,’ nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kona ni, ou rʉnggilmʉ elinga, Jura wamp nga Pasopa rʉng nuing ui ei, utʉma orunga mel pitim. Ni kʉn, Pailot ndi, Jura wamp nimbʉ, kundpa nimba mel, “Enim nga wu nuim mumuk ei ya kʉnʉiya!” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wote ke nʉk, int nduk nʉk mel, “Rok konda! Rok konda! Nde peta ila pendkʉn nil ro!” nʉtʉng. Ni kʉn, Pailot ndi, punt ropa, nimba mel, “Na ndi, enim nga wu nuim mumuk ei, nde peta ila reimp ninmin ei!” nitim. Wote, Pris kʉⱡ nga wu kuimbal kʉⱡ ndi, ik punt rok, nʉk mel, “Tʉn nga wu nuim mumuk tenda e, i Sisa,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wote Pailot ndi, Jisas nde peta ila reing nimba, wu ni kʉⱡ nga ki ila ngurum. ");
INSERT INTO med_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni kʉn, el wu nimbʉ ndi, Jisas tʉk ambʉⱡʉngina, elim nga nde peta ni, koma ropa, kona peng ni, wak ropa, kona ti mbi tek, ‘Wamp peng ombil,’ nʉtmʉn kona ila mepa purum. Ipru ik ila kona ei, mbi tek, ‘Golgata,’ nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kona ila, Jisas ni, nde peta ila pendʉk rorung. Ni kʉn, wu raⱡ pendʉk rorung. Wu ti tʉk ki mbo orunga rok, ti tʉk, ki rar orunga rorung. Jisas ni, rʉk ting ila pendʉk rorung. ");
INSERT INTO med_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Wote Pailot ndi, nde peta ila mon ti, rʉi nilinga rorung ei ndi, nimba mel, “Nasaret Wu Jisas, Jura Wamp Nga Wu Nuim Mumuk Ei,” nimba murum. ");
INSERT INTO med_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ni kʉn, Jura wamp minal ndi, mon kʉⱡ kʉmp rorung. Ei nambuⱡ emel, Jisas rorung kona ei, kona peng ila nondpa, wote, mon kʉⱡ Grik, Latin, Ipru ik ila rurum. ");
INSERT INTO med_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wote Pris kʉⱡ nga wu kuimbal nimbʉ ndi, Pailot kundʉk nʉk mel, “Jura wamp nga wu nuim mumuk nʉkʉn, rui nʉri! Wote wu ei, el elim ndi, nimba mel, ‘Na Jura wamp mbʉ nga wu nuim mumuk ei, nʉtʉm ei mel rui!’” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailot ndi, punt ropa, nimba mel, “Na ndi, mon runt ei mel muⱡangga!” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wote, el wu nimbʉ ndi, Jisas ni, nde peta ila rok pendʉk, elim nga muⱡ rʉrʉm ni kʉⱡ, potʉk tʉk kʉmp tʉk, tʉmbʉkak etʉk tʉtʉng. Wal pʉki ruⱡ ti, rumbʉⱡi nambrʉng ni, pendʉk tʉtʉng ku. ");
INSERT INTO med_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","El wu nimbʉ, en enim nʉk mel, “Wal pʉki ruⱡ ei, ambuⱡpʉn undi nʉndʉmin! El mong poⱡpʉn kʉnamina, ambʉⱡʉm wu ti tangga!” nʉtʉng. Ni kʉn, Buk Wingti ila ik ti petʉm ei, omba kupa itim, “Na nga mel mbʉ, kʉmp tʉk, elpa elpa tʉk, wal pʉki ruⱡi kʉⱡ el mong puⱡing,” nitim. El wu nimbʉ ndi, uⱡ ei kupa etʉng. ");
INSERT INTO med_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas nga nde peta puⱡ ila nondpa, elim nga mam Mariya kʉn, ʉngʉn kʉn, Kliopas ambʉm Mariya kʉn, Makndelin Mariya kʉn morung. ");
INSERT INTO med_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas ndi, elim nga mam kandpa, wote elim nga kitip kʉni wu numan ngorum ni ʉnggʉtʉm. Kandpa kʉn, elim nga mam ni kundpa nimba mel, “Amp ye! Int wu ei, nim nga kangnʉm,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wote Jisas ndi, kitip kʉni wu ni kundpa nimba mel, “Int amp ei, nim nga manʉm,” nitim. Ui ni kʉn, kitip kʉni wu ni ndi, amp ni mepa, mang kona mba rʉp itim. ");
INSERT INTO med_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ni kʉn, Jisas elim nga uⱡ etmba nimbʉ, etʉp pora ndunt nimba pilpa kʉn, Buk Wingti ila ik mbʉ omba, kupa etangga, nimba mel, “Na nu waka enim,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ming tila nu wain kombila iti ni, peka ropa murum ila, muⱡ pang pang iti ti, tʉk nu wain ila mana nduk, wote ndila rok tʉk, oⱡa nduk, keta min ila, kopung kandrung. ");
INSERT INTO med_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wote Jisas ndi, nu wain ni nomba, nimba mel, “Pora ninim!” nitim. Ni kʉn, peng ni, mana puⱡnga, koⱡpa nuim kan ʉkrʉm. ");
INSERT INTO med_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jura wamp nimbʉ ndi, Pailot kundʉk nʉk mel, “Nde petal ila rorung wu kʉⱡ nga kʉmp mbʉ, rop puk rok, nde peta ila mana teing ni!” nʉtʉng. I etʉng ei, kongun pʉmp kʉn, nambuⱡ emel, ui ei, Jura wamp mbʉ nga mowi kor ou ei kʉn, wu kʉⱡ nga kʉng kʉⱡ, nde peta ila pi napʉmba. Ei nga, mowi kor onum ei, Kor Wingti ei. ");
INSERT INTO med_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wote, el wu nimbʉ ndi, kuimp tek puk, wu ti nga kʉmp raⱡ rok, puk rok, wote wu ti nga rok puk rorung. Wu raⱡ, Jisas kʉn pendʉk rorung wu raⱡ. ");
INSERT INTO med_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wote ok, Jisas ni, kandrung mel, koⱡpa pora ndurum. Ni kʉn, Jisas nga kʉmp raⱡ, rok puk, rui narʉrʉng. ");
INSERT INTO med_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ni kʉn, el wu ti ndi, elim nga kupanda ni, tʉpa oⱡa ndupa, Jisas nga wʉnggʉⱡʉp ila poⱡnga, tʉngʉnda mint mema kʉn, nu kʉn oi nitim. ");
INSERT INTO med_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uⱡ itim kʉⱡ, wu ti kʉndrʉm. Ei nga, enim mondʉk pileing nimba kʉn, uⱡ pitim ei mel, mendpʉⱡ kundpa ninim. ");
INSERT INTO med_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Uⱡ ei, Buk Wingti ila petʉm ik ei, omba kupa itim: “Ei kʉn, elim nga ombil ti, rok puk rui, nʉring,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wote, Buk Wingti ila ku, ik ti ndi, nimba mel, “Wamp mbʉ ndi, kupanda ndi, purung wu ei kʉning,” nitim. ");
INSERT INTO med_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ni kʉn, akil tepa, Arimatiya wu Josep ndi, Jisas nga on ei, timp nimba mba, Pailot waldpa pitim. Josep ei, Jisas nga kitip kʉni wu ti ku ei, mo ropa ʉndrʉm. Nambuⱡ emel, Jura wu mbʉ nga mundmong itim. Wote Pailot ndi, kapⱡa nilinga, Josep ndi, Jisas nga on ei, tʉpa mepa purum. ");
INSERT INTO med_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Wote, Nikondimas ni wu ti, Jisas kʉn rumbʉⱡ rui ik nʉtʉnggil wu ni, Josep kʉn mba, etpa kopung mura rui mat ou ndupa, 45 kilo mel mepa purum. ");
INSERT INTO med_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wu ni raⱡ ndi, Jisas nga on ni kopung mura rui mbʉ ndi, kopung kandkʉⱡ, muⱡ kurʉmʉⱡa tila kum rorʉnggil. Uⱡ ei, Jura wamp mbʉ nga wamp on angʉndʉk, etmin ei mel etʉnggil. ");
INSERT INTO med_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas rorung kona ila, nondpa kongun kona ti titim. Kona ila wamp ʉngʉndi nangʉndʉtmin kona ila, ku manga ti titim. ");
INSERT INTO med_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jura wamp nga mowi kor muⱡing ui ei, nondpa itim. Wote, ku manga ei nondpa titim. Ei nga, Jisas nga on ni kona ila tetʉng. ");
INSERT INTO med_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mʉkʉlmʉ unt, Kor Ou kʉn, kona rumbʉⱡ ropa pelinga, Makndelin amp Mariya ni, on kona nila purum. Mba kʉndrʉm mel, on kona ⱡʉrʉk ndurʉng ku ni, tʉk mundrʉng. ");
INSERT INTO med_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kandpa kʉn, tʉkrʉpa yant omba, Saimon Pita kʉn, kitip kʉni wu ti, Jisas ndi, numan ngurum wu ni raⱡ, kundpa nimba mel, “Wu Nuim ni, tʉk mek pung on kona ei, wei tetʉm. Mek puk kona nant ila teng nda? Tʉn pili napʉnmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wote Pita kʉn, kitip kʉni wu ti kʉn, on kona ei kunʉnggil purʉnggil. ");
INSERT INTO med_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wu ni raⱡ, tʉkʉrkʉⱡ purʉnggil ila, wu ti ndi, Pita ropa akil ndupa, elim kuimp tepa on kona nila purum. ");
INSERT INTO med_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wote wu ni, elim murʉk pi napʉpa, kʉp ropa moⱡpa, kʉndrʉm mel, muⱡ kurʉmʉⱡa ni mint titim. ");
INSERT INTO med_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Akil tepa, Pita ni omba, kun rukrʉng mba kʉndrʉm mel, muⱡ kurʉmʉⱡʉ ni, mint titim. ");
INSERT INTO med_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wote, Jisas nga peng ei, kum rorung muⱡ ni, merʉng tila, elpa kawa nduk, ek nduk, kai etʉk tetʉng ei mel titim. ");
INSERT INTO med_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ni kʉn, kitip kʉni wu kuimp titim ni, akil tepa, rukrʉng mba kandpa, mondpa pitim. ");
INSERT INTO med_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jisas koⱡpa, wote ⱡoporpa kont oⱡa moⱡmba ei nga, Buk Wingti ei ndi, nitim ik ei, pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wote, Jisas nga kitip kʉni wu nimbʉ, enim nga mang kona ila yant purung. ");
INSERT INTO med_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Ni kʉn, Mariya ni, on kona ila ekit orunga anggilpa, ka etpa murum. Ka etpa moⱡpa, wote kʉp ropa, on kona ni, tʉpa murʉk ndupa, kʉndrʉm mel, anggelo raⱡ mel kurʉmʉⱡʉ mbʉ ralkʉⱡ, Jisas nga on ei, titim kona ila morʉnggil. Anggelo ti, Jisas nga peng ei, titim ila moⱡnga ti, kʉmp raⱡ titim ila murum. ");
INSERT INTO med_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Anggelo ni raⱡ ndi, amp ni kundkʉⱡ nʉkʉⱡ mel, “Amp ye! Nim nambuⱡ emel, ka en?” nʉtʉnggil. Wote, amp ni ndi, punt ropa, nimba mel, “Na nga wu Nuim ei, tʉk mek puk, nant ila teng nda? Na pili napʉnt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ik nimba pendpa, tʉpa ropʉl ropa, kʉndrʉm mel, Jisas ni, elim nga mbuldung orunga anggilpa murum. Wote, amp ni ndi, Jisas murum ni, tʉpa mindi nʉmʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ni kʉn, Jisas ndi, amp ni, waldpa nimba mel, “Amp ye! Nim nambuⱡ emel, ka en? Wote nim nam andkʉn kurun?” nitim. Wote, amp ni ndi, wu ni kongun kona puⱡ wu ti, omba ninim nimba pilpa, nimba mel, “Wu Nuim ye! Nim ndi, wu on ei, tʉkʉn mekʉn pun ndam, na kundkʉn nana mbo tamp!” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas ndi, amp ni, kundpa nimba mel, “Mariya!” nitim. Wote, amp ni ndi, tʉpa ropʉl ropa, Ipru ik ila, nimba mel, “Raponi!” nitim. Ik ei nga puⱡ ei, ‘Ik mbo wu,’ ei nʉtmʉn. ");
INSERT INTO med_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ni kʉn, Jisas ndi, nimba mel, “Na minda ndui nʉndi! Nambuⱡ emel, na Wuta kʉn, oⱡa pi nʉpʉnt. Ei nga, nim pukʉn, na nga ʉngʉnʉl kʉⱡ kundkʉn, na Wuta kʉn oⱡa mbi ent ei, enim nga Wuta kʉn, Na nga Got, wote enim nga Got,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wote, amp Mariya Makndelin tʉkrʉpa mba, kitip kʉni wu ni kʉⱡ, kundpa, elim Nuim ei kʉnt, wote ik ei mel, kundpa nʉm nitim. ");
INSERT INTO med_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kor ou ni kʉn rumbuldi, kitip kʉni wu ni kʉⱡ, Jura wu nimbʉ nga mundmong endʉk, manga kumba rok, gi nduk, murʉk morung. Ni kʉn, Jisas elim omba, rʉk ting ila anggilpa, nimba mel, “Enim numan wang nduk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I nimba pendpa, elim nga ki na, wʉnggʉⱡʉp na nimbʉ, tʉpa ora ndurum. Ni kʉn, kitip kʉni wu ni kʉⱡ ndi, Nuim ei kandʉk, numan kai pʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wote Jisas ndi, aldpa nimba mel, “Enim numan wang nduk muⱡʉi! Wuta ndi, na tʉpa mundrum ei mel, na ndi, enim tʉp mundunt,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ik i etpa, nimba pendpa, elim nga muⱡnga ei, pop ropa ngumba, nimba mel, “Enim Muⱡnga Wingti ei tʉi! ");
INSERT INTO med_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wote enim ndi, wamp mat nga uⱡ kit etmin mbʉ pendʉk, keling ndam, elim ndi, pendpa kelmba ku. Wote enim ndi, pendʉk moⱡʉng ndam, pendpa moⱡmba ku,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kitip kʉni wu 12 ni kʉⱡ nga ti, Tomas mbi tek, ‘pʉklʉm,’ nʉtʉng wu ni, Jisas urum ni kʉn, muⱡi nʉmbrʉm. ");
INSERT INTO med_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wote, kitip kʉni wu kat ndi, Tomas kundʉk nʉk mel, “Tʉn Wu Nuim ei kʉnmʉn!” nʉtʉng. Ni kʉn, Tomas ndi, wu ni kʉⱡ, kundpa nimba mel, “Na nga mong raⱡ ndi, Jisas nga rorung ki ʉrʉⱡa kʉⱡ, kandʉp minda ndup, wote porung wʉnggʉⱡʉp ei, minda ndup int ndam, na kapⱡa mondʉp pilimp,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wote, rumbʉⱡ 8 omba puⱡnga, Tomas kunda, kitip kʉni wu ni kʉⱡ kʉn, manga nila kumba rok gi nduk, murʉk morung. Ni kʉn, Jisas ni, tʉkrʉpa omba, rʉk ting ila moⱡpa, nimba mel, “Enim numan wang nduk muⱡʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wote, Tomas kundpa nimba mel, “Nim nga ki ruⱡ ei, yant ndukʉn, na nga ki raⱡ ambulkʉn kʉni! Wote ki run ndukʉn, na nga wʉnggʉⱡʉp ila, minda ndui! Nim numan ʉk puk ti nʉti! Nim mondkʉn pili!” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ndi, punt ropa nimba mel, “Na nga Nuim wote, Na nga Got!” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ni kʉn, Jisas ndi, Tomas kundpa nimba mel, “Nim na kandkʉn mondkʉn pʉn ei? Na kʉni nakʉndʉk mondʉk pʉtmʉn wamp mbʉ, numan kai pilik muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas ndi, elim nga kitip kʉni wu kʉⱡ mondpa, uⱡ wengʉndupa mat minal itim mbʉ, ya Buk ila, mon rok pindi napʉndʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wote, ya ik mbʉ rorung ei, Jisas ei, Got nga kangʉm, wote Got nga ngurum wu ei, mondʉk pileing! Wote enim ndi, elim nga mbi ila mondʉk piling ndam, enim uⱡ nga kʉnt nga kont mul uⱡ ei ting. ");
INSERT INTO med_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wote akil tepa, Jisas elim nga kitip kʉni wu ni kʉⱡ, Num Taipiriyus ʉldʉ ila moⱡʉngina, mot nga urum. Wote, i etpa urum. ");
INSERT INTO med_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ni kʉn, wu Saimon Pita kʉn, Tomas mbi tek ‘pʉklʉm,’ nʉtʉng ni kʉn, Galili kona ila nga Keina wu Nataniyel kʉn, wote wu Sepeti kangʉm wu raⱡ kʉn, kitip kʉni wu ralt kunda, kona nila morung. ");
INSERT INTO med_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ni kʉn, Saimon Pita ndi, wu ni kʉⱡ, kundpa nimba mel, “Na oma ruimp punt,” nitim. Wote, wu kat ndi, nʉk mel, “Tʉn nim kʉn uimin,” nʉtʉng. Wote, wu ni kʉⱡ, rʉp rok puk, nu kanu ila rukrʉng purung. Rumbʉⱡ nila, oma tenda kot kep, rok ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mʉkʉlmʉ unt, Jisas omba, nu ʉldʉ ila murum ni, kitip kʉni wu ni kʉⱡ ndi, Jisas tʉk mindi namindʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wote Jisas ndi, wu ni kʉⱡ, kundpa nimba mel, “Kang wu kʉⱡ, enim oma mat rong ei?” nitim. Wu ni kʉⱡ ndi, punt rok, nʉk mel, “Oma tenda kot kep, ropʉn ti nʉtmʉn mon,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ni kʉn, Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Enim nga oma wal kʉⱡ, tʉk nu kanu kʉⱡ nga ki mbo orunga mana nduk kʉn, oma mat ting,” nitim. Nitim ni mel, tʉk mana ndurʉng ila, oma wal ni kʉⱡ, oma ndi, peka roⱡnga, kundʉk oⱡa ting ei, pilik rundrung. ");
INSERT INTO med_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kitip kʉni wu ti, Jisas ndi, numan ngurum wu ni ndi, Pita kundpa, nimba mel, “Nuim ei omba morum!” nitim. Nuim ei, omba morum nitim ik ni, Pita ndi, tʉngʉnda pilpa, elim nga muⱡ ekit orunga rurum ti, potpa titim ni, tʉpa raⱡpa, nu ila puka ropa, mana purum. ");
INSERT INTO med_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ni kʉn, kitip kʉni wu kat ni kʉⱡ, nu kanu ila molk, oma wal ni kʉⱡ, kundʉk mek, nu ʉldʉ ila, nondpa orung. Num ʉldʉ ila rʉk ping ei nga 100 mita mel titim. ");
INSERT INTO med_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wu ni kʉⱡ ok, nu okiya pena ila ekit ok, kandrung mel, ndip karung tila, oma na bret na mat pitim. ");
INSERT INTO med_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wote Jisas ndi, wu ni kʉⱡ kundpa nimba mel, “Oma kokila ronmʉn mbʉ nga mat, mek wʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita ndi, nu kanu ila oⱡa mba moⱡpa, oma wal ni kʉⱡ, kunt kundi, ekit titim. Oma ou 153 pitim. Oma ama minal pitim. Ei nga wote, oma wal ni kʉⱡ, nduip ni nʉndʉtʉm. ");
INSERT INTO med_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Wote Jisas ndi, wu kʉⱡ, kundpa nimba mel, “Rʉng nuing wʉi!” nitim. Kitip kʉni wu ni kʉⱡ nga ti ndi, “Nim nam?” nʉk wuldʉng mel, iti nʉtʉtʉm. Nambuⱡ emel, Nuim ei murum ei, en enim tʉk mendʉtʉng. ");
INSERT INTO med_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas ndi omba, bret ni tʉpa, wu ni kʉⱡ ngumba. Wote, oma ni, i ku etpa pendpa, wu ni kʉⱡ ngurum. ");
INSERT INTO med_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ya uⱡ itim ei, Jisas on kona ila, ⱡoporpa oⱡa moⱡpa, kitip kʉni wu ni kʉⱡ kʉn, mot nga oⱡnga, raldika itim. ");
INSERT INTO med_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wote, rʉng nok pora nduk moⱡʉngina, Jisas ndi, Saimon Pita ni, waldpa nimba mel, “Saimon, wu Jon kangʉm ya, wu kʉⱡ ndi, na numan ngormin uⱡ ei, tʉkʉn mana ndukʉn, nim ndi, na numan ngorun uⱡ ei, ama oⱡa mel nda?” nitim. Wote Saimon Pita ndi, punt ropa, nimba mel, “Kupa, Nuim ye! Na nim numan ngur uⱡ ei, nim pʉtʉn,” nitim. Jisas ndi, Pita kundpa nimba mel, “Na nga sipsip waⱡ mbʉ, rʉp indi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wote Jisas ndi, aldpa Pita kundpa nimba mel, “Jon kangʉm Saimon ye! Na kupa numan ngʉn ei?” nitim. Saimon Pita ndi, punt ropa, nimba mel, “kupa Nuim ye! Na nim numan ngur uⱡ ei, nim pʉtʉn,” nitim. Wote Jisas ndi, Pita kundpa nimba mel, “Na nga sipsip mbʉ rʉp indi!” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ei kʉn, Jisas ndi, Pita waldpa, raldika endpa, nimba mel, “Jon kangʉm wu, Saimon ye! Nim ndi, na numan ngʉn ei?” nitim. “Na numan ngurun nda?’ nitim. Nitim ik ei, waldpa omba raldika endilinga. Pita ndi, munt mindil tʉpa, Jisas kundpa nimba mel, ‘Nuim ye! Nim wamp numan kʉni wu ei, na ndi, nim numan ngʉmp mor ei pʉn mon,” nitim. Wote Jisas ndi, Pita kundpa nimba mel, “Na nga sipsip mbʉ rʉp indi! ");
INSERT INTO med_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nim ik kupa ei kundʉp nʉnt. Unt, nim kang wu kʉn, nim nga kan mum ei, ninim ndi tʉkʉn, gi ndukʉn rʉrʉn. Wote mbi nʉkʉn, pitin kona ila purʉn ku. Wote, anda in ei kʉn, nim nga ki raⱡ, run ndukʉn moⱡana. Wamp ti ndi, nim nga kan mum ei rundangga. Nim pi nʉpimp nʉkʉn pin kona ila, ki ambuⱡpa mepa mba,” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ik i etpa nitim ei, Pita ni koⱡpa, Got nga mbi paka rondʉmba ei nga ik ek ropa nitim. I nimba kʉn, Pita kundpa nimba mel, “Na kʉn pep rokʉn ui,” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ni kʉn, Pita ndi, tʉpa ropʉl ropa, kʉndrʉm mel, kitip kʉni wu ti, Jisas ndi, numan minal ngurum wu ni, akil tepa urum. Wu ni, unt rʉng norung ei kʉn, Jisas kʉn nondpa moⱡpa, Jisas waldpa nimba mel, “Nuim ye! Wu nam ti, nim rʉk moⱡmba?” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wote Pita ndi, wu ni, kandpa kʉn, Jisas kundpa, nimba mel, “Nuim ye! Akil tepa onum wu ei, namba uⱡ ti etmba nda?” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas ndi, punt ropa, nimba mel, “Wu ei kont moⱡangga! Na yant uimp nint ndam, nimp mint, nim nga uⱡ ti mon. Nim na kʉn pep rokʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jisas nga nitim ik ni pilik, nʉk mek int int puk, nʉk mel, “Kitip kʉni wu ei, kuⱡi naⱡʉmba,” nʉtʉng. Wote Jisas ndi, nitim ik ei, wu ei, “Kuⱡi naⱡʉmba nimba ik ti, ni nʉndʉtʉm, mon. Wu ei, kont moⱡangga! Na yant uimp nint ndam, nimp mint, nim nga uⱡ ti mon,” nimba kʉn, nitim. ");
INSERT INTO med_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kitip kʉni wu ei ndi, ik mbʉ nimba, para ndupa, mon ropa pinditim ik mbʉ, kupa mint nʉmp pʉnmin. ");
INSERT INTO med_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas ndi, uⱡ mat minal itim. Uⱡ mbʉ pora, mon roⱡʉngina ndam, muⱡ kʉmp mbʉ pora, Buk mbʉ ndi, tepa ti nimba, kakina moⱡnga. ");
INSERT INTO med_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Wu Tiyopilus ye! Na ik mong kuimp tep mon rur kʉⱡ ila, Jisas ndi, kongun puⱡ mondpa etpa, wote wamp ik mbo endpa kʉn, wote muⱡ kona oⱡa purum ei mel rur. Muⱡ kona oⱡa pi nʉpi kʉn, Muⱡnga Wingti nga ronduⱡ ila, elim nga kitip kʉni wu, unt kʉmp ropa titim. Nimbʉ, kongun iting mbʉ mel, mbo rondpa nimba, ndoimp rundrum. ");
INSERT INTO med_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wote, elim nde peta ila rorung, wote ⱡoporpa omba purum. Ei kʉn, akil tepa, elim nga kitip kʉni wu mbʉ kʉn, elim kont mor ei kandʉk, poⱡ ndeing nimba, tʉpa mot ndurum. I etpa, elim tʉpa mot ndupa, Got nga wamp tʉpa mumuk rui uⱡ ei nga, mbo endpa. I elinga, rumbʉⱡ 40 omba purum. ");
INSERT INTO med_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ui ti kʉn, Jisas elim nga kʉmp ropa titim wu ni kʉⱡ kʉn moⱡpa, nimba mel, “Enim Jerusalem kona wak rui nʉrʉi! Wuta ndi, enim mel ti nguimp nitim nʉmp, na enim kundʉp nit ni mel ngumba, ei nga nokundʉk muⱡʉi! ");
INSERT INTO med_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ndi, wamp mbʉ nu mendpʉⱡ ila, nu tinditim. Wote, enim rumbʉⱡ onunga, ralt omba pangga, Muⱡnga Wingti ei ndi, enim nu tʉndʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ui ti kʉn, Jisas kʉn, elim nga kitip kʉni wu nimbʉ kʉn, ok tʉk tenda etʉk morung ei kʉn, wu nimbʉ ndi, Jisas waldʉk nʉk mel, “Nuim ye! Akup nim ndi, Isrel wamp mbʉ, tʉkʉn tenda etkʉn tʉkʉn, mumuk ruin muna mon nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wote Jisas ndi, nimba mel, “Uⱡ ei, enim nga piling ui ti mon. Wuta ndi, kanggʉp ambuⱡpa pinditim ui ei, elim nga ronduⱡ ila pilpa morum. ");
INSERT INTO med_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wote, Muⱡnga Wingti ei, mana om ei kʉn, enim ronduⱡ ting. Tʉk kʉn, Jerusalem kona ila kʉn, Juriya kona ila kʉn, Sameriya kona na, wote muⱡ uⱡ kona mbila pora, na nga ik ei nʉk, para nduing,” nitim. ");
INSERT INTO med_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ik ei mel nimba moⱡnga, kandrung mel, Jisas ni, tʉpa mepa oⱡa purum. Wote, kopa kat ndi omba, peta rurum ila, elim ni kʉni nakʉndʉng. ");
INSERT INTO med_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Wote, purum ni mel kandʉk, mint morung ei kʉn, wu muⱡ kurʉmʉⱡʉ rʉⱡi ralt okʉⱡ, wu kʉⱡ nga wung ila anggilikʉⱡ wu raⱡ ndi, nʉkʉⱡ mel, “Enim Galili kona wu mbʉ ye! Nambuⱡ emel, enim muⱡ ila, tʉk oⱡa nduk, kandʉk mormʉn? Wu Jisas ndi, enim wak ropa, muⱡ kona oⱡa punum. Wote, i ku etpa, muⱡ kona punum ei mel, wote yant omba!” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wote, Jisas nga kitip kʉni wu ni kʉⱡ, Olip Komnga wak rok, Jerusalem kona ila purung. ");
INSERT INTO med_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem kona ila puk kʉn, wote en enim nga petʉng manga nila, oⱡa orunga purung. Wu Pita, Jon, Jeims, Andru, Pilip, Tomas, Bartolomiyu kʉn, Matyu kʉn, Wu Alpiyas kangʉm Jeims kʉn, omba Saimon Selot kʉn, Jeims kangʉm Juras kʉn. ");
INSERT INTO med_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wu kʉⱡ ila molk, numan tʉk tenda mondʉk, atinga rʉk rʉk rok morung. Wote ila ku, amp mat kʉn, Jisas nga mam, amp Mariya kʉn, wote Jisas nga ʉngʉnʉl nimbʉ kʉn kunda, atinga rok morung. ");
INSERT INTO med_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Wote, rumbʉⱡ mat omba puⱡnga, Nuim ei, mondʉk pʉtʉng wamp nimbʉ, mou ti rurung. Mou ila, wamp 120 mel morung. Ei kʉn, Pita ndi, oⱡa anggilpa, nimba mel, “Angmʉn! Buk Wingti ila ik mong ti petʉm. Unt Muⱡnga Wingti ei ndi, Depit ronduⱡ nguⱡnga nitim ik ei, omba kupa enim. Ik ei, wu Juras ndi, Jisas rʉk moⱡnga, Jisas imp molk, tʉk kan ngorung ni mel nʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wu Juras ni, unt tʉn kʉn murum. Wote, kongun tʉn kunda itʉmʉn nimba, kʉmp ropa titim,” nitim. ");
INSERT INTO med_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Wu Juras ndi, Jisas rʉk murum uⱡ nila, ku mong mat ngorung. Ku nimbʉ ndi, mʉi mam ti, rop ropa titim. Wote mʉi ila, Juras ropa mundrum ila, mba pelinga, kitim nimbʉ, ruⱡʉp ropa, ekit oⱡnga kurum. ");
INSERT INTO med_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem kona ila petʉng wamp nimbʉ ndi, Juras kurum ei mel, pilik pora ndurʉng. Wamp nimbʉ ndi, mʉi ei mbi tek, ‘Akeldama,’ nʉtmʉn. Akeldama nga ik puⱡ ei, “Mema mʉi.”) ");
INSERT INTO med_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wote Pita ndi, nimba mel, “Buk Sam ila, ik mong ti ndi, ei mel nʉtʉm, ‘Wu ei nga kona ei, wapra tiyangga! Wamp ti koⱡ ila, muⱡi nʉmbʉⱡangga! Wote, elim nga koⱡ ila, wamp elpa ti ndi, kongun etangga!’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ei kʉn, akup tʉn ndi, wu ti tou ruimin. Wu ei, tʉn Nuim Jisas kʉn, rʉp ropʉn andʉrmʉn. Wote, wu ti ku, Jon kongun etpa, wamp nu tindpa itim. Wote, Jisas kongun itim ui ei kʉn omba, akup Jisas muⱡ kona purum. Ei mel, wu ei ndi, tʉn kʉn numan tenda pangga, Jisas koⱡpa, ⱡoporpa omba purum ei nga, para ndup nʉmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","I nʉk kʉn, wu raⱡ tou rorung. Wu ti, Josep mbi tek, ‘Barsapas,’ nʉtmʉn ei nga tipam, Jastas. Omba wu ti nga mbi ei, Matiyas. ");
INSERT INTO med_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ei kʉn, wamp nimbʉ, atinga rok nʉk mel, “Nuim ye! Nim wamp nga numan rukʉr orunga, kandrun ei nga, wu raⱡ nga nam ti, nim ndi, tou run ei, tʉk orunga ndana! Wu ei ndi, Juras ni, wu elim nga mbi nimba, pitim kona ila piraim purum. Wu ei nga kok ila tʉpa, kitip kʉni wu raⱡpa, kongun etangga!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ni kʉn, wu kʉⱡ ndi, wu raⱡ nga el mong purung ila, Matiyas kʉn omba tilinga, Matiyas ni omba, kitip kʉni wu ni kʉⱡ kʉn, kup itim. ");
INSERT INTO med_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pendikos ui ni, urum ei kʉn, Jisas nga mondʉk pʉtʉng wamp nimbʉ ok, manga tila tʉk, mʉk rok morung. ");
INSERT INTO med_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","I etʉk moⱡina, tʉngʉnda mint, wi muⱡ ila, kona kʉpkʉ mam mel rom ropa omba, morung manga nila, mukʉr urum. ");
INSERT INTO med_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ei kʉn, kandrung mel, ndip anmbil mel mat, ngʉnt ropa omba, wamp nimbʉ nga peng ombil mbila, elpa elpa ndip mel nomba murum. ");
INSERT INTO med_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wamp ila morung nimbʉ, Muⱡnga Wingti ei ndi, peka roⱡnga, mbo ik nʉm kan elpa elpa mbila nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wote ni kʉn, Jura wamp mat, Got nga ik ei, pilik etmin. Muⱡ kʉmp mbila, petmin wamp mbʉ, Jerusalem kona ila manga poning ok, morung ku. ");
INSERT INTO med_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wamp minal, kona kʉpkʉ rom ropa, ik nitim ni pilik, ok mʉk rok morung. Ei nambuⱡ emel, mondpa pili wamp nimbʉ ndi, muⱡ kʉmp mbila, orung wamp nimbʉ nga ik nuim kan elpa elpa tek nilingina, pilik min ngʉn mondʉk morung. ");
INSERT INTO med_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Min ngʉn mondʉk, wote numan ou nduk pilik, ei mel nʉtʉng, “Ik nimʉn wamp kʉⱡ, Galili wamp kʉⱡ ant ko, wote tʉn nga ik nuim kan tek elpa elpa nilingina, pʉnmʉn ei, etʉk ninmin mel nant nda? ");
INSERT INTO med_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Tʉn ya wamp elpa elpa omp mormʉn mbʉ, kona Partiya, Midiya, Elam, Mesopotemiya, Judiya, Kaparosiya, Pontas, Eisiya kʉn, wote Prigiya, Pampiliya, Isip kʉn, wote Libiya orunga nondpa tetʉm kona Sairin, Rom kona mbila pʉkʉ kʉn, Jura wamp kʉn, wote wamp rʉⱡaip elpa ok, Jura wamp rarʉng mbʉ kʉn, Krit kona kʉn, Areipiya kʉn, kona elpa elpa kʉⱡ ila nga mormʉn wamp mbʉ, wote Galili wamp kʉⱡ ndi, tʉn nga ik nuim kan mendpʉⱡ ila, Got nga uⱡ ronduⱡ itim mbʉ nilingina, pʉnmʉn ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wamp nimbʉ ndi pilik, min ngʉn mundʉk, numan orunga mbun tʉk, wamp mat ndi, mat waldʉk, nʉk mel, “Uⱡ ei etpa, enim mel nant nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wote, wamp mat ndi, mondʉk pʉtʉng wamp nʉkʉⱡ, tʉk ik kuldʉk nʉk mel, “Wamp kʉⱡ, nu wain nok, kekilip ronmin!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ui ni kʉn, Pita kʉn elim nga kongun rʉp rok etmin wu 11 nʉkʉⱡ kʉn, oⱡa anggilik molk, Pita ndi, ik ronduⱡ oⱡa ndupa, wamp minal ok morung nimbʉ, kundpa nimba mel, “Enim Jura wamp, mbʉ kʉn, wote Jerusalem kona ila mormʉn wamp mbʉ kʉn, kum tek muⱡʉi! Na ndi, ya enim uⱡ kanmin ei nga puⱡ ei, kundʉp namp. ");
INSERT INTO med_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Enim ndi pilik, wamp kʉⱡ, nu ronduⱡ nok, kekilip ronmʉn, nʉk pʉnmʉn, ei mon! Akup kona ant mong 9 kilok mʉkʉlmʉ unt ei ka! ");
INSERT INTO med_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Uⱡ ei nga, pai nui wu Joel ndi, pai nomba ei mel nitim, ");
INSERT INTO med_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Got ndi, nimba mel, muⱡ mʉi raⱡ pora nimba ui ila, uⱡ ei mel itimp nitim. Na ndi, na nga Muⱡnga Wingti ei, wamp mbʉ kʉn, oi ndup mundamba. Enim nga kangʉmʉl mbʉ kʉn, mbʉⱡamʉl mbʉ kʉn, na nga ik ei, pai nok ninding. Enim nga kang wu mbʉ, uⱡ wote pemba mbʉ kʉning. Wote, enim nga wu anda mbʉ ndi, ur kump etʉk kʉning. ");
INSERT INTO med_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ui ei kʉn ku, na nga kongun wu na, kindmant amp na mbʉ, na nga Muⱡnga Wingti ei oi ndamba, uⱡ akil tepa etmba mbʉ, pai nok ning. ");
INSERT INTO med_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Na ndi, wi muⱡ ila uⱡ rʉpndi mat itimp. Wote, mana mʉi ila, uⱡ kʉni nʉkʉni mat itimp. Ei kʉn, mema romba ku, wote ndip nangga, ʉkʉl mam mba, kona ant ei tʉpa, rumbʉⱡ mondʉmba. Wote, kona kalimp ei, kunt etpa, mema mel raⱡmba. Uⱡ i etmba ei, kuimp tepa ekit wangga. Wote Nuim ndi, elim nga uⱡ eng nui kai mbila nga, pol ila moⱡpa, yant wangga ui ou ei, ekit omba. ");
INSERT INTO med_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wote ei kʉn, wamp nam ti ndi, elim nga Nuim ei nga mbi ila, wi rom ndam, wamp ei etpa tʉmba,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Enim Isrel wamp kʉⱡ, ik ei kum tek pilʉi! Nasaret kona ila nga Jisas, Got ndi, elim nga ronduⱡ ei ngurum. Elim ndi, kongun ronduⱡ na, uⱡ rʉpʉndi ronduⱡ na, uⱡ kai mbʉ itim ei, enim pilik ketʉng ni ka! ");
INSERT INTO med_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Muⱡ mʉi raⱡ mim iti nʉti kʉn, Got elim nga numan ila, Jisas kʉn uⱡ, wote pimba mbʉ, pilpa pora ndurum. Uⱡ ei tʉp, Jisas enim nga ki ila tendʉmba. Wote, enim uⱡ kit etmin wu mbʉ ndi, Jisas nde peta ila rok kunding, nʉtʉng ei mel etʉng. ");
INSERT INTO med_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wote Jisas ni, Got ndi, wamp kui nga uⱡ ila, ⱡoporpa tʉpa oⱡa mundrum. Wamp kui nga uⱡ ei ndi, imp muⱡi nʉmbrʉm. Ei nambuⱡ emel, wamp kui nga uⱡ ei nga ronduⱡ ti mon. ");
INSERT INTO med_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Uⱡ ei nga, Depit ndi, Nuim ei nga nimba mel,’ Na kʉndʉr ei, Nuim ei, na kʉn rʉk rʉk morum. Nambuⱡ emel, na nga ki mbo orung murum. Ei nga, mbun mat na kʉn ui nawʉmba. ");
INSERT INTO med_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ei kʉn, na nga numan ei kai punt. Wote, na nga ik ei, nimp ei nga kai pilip nʉnt. Wote, na nanim kʉng orunga mel kai ti timp ei nga, na nokundʉp mor. ");
INSERT INTO med_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ei nambuⱡ emel, nim ndi, na nga min ei, wamp kui nga kona ila, wak rui nʉri. Wote nim ndi, nim nga kongun Wu Wingti ei, wamp on kona ila, pepa purangga ni nandʉtʉn mon. ");
INSERT INTO med_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nim ndi, na uⱡ nga kont mbo, muⱡimp nombuⱡa mam ei, tʉk ora ndurun. Wote, nim na kʉn morun uⱡ ei ndi, ambuⱡpa puⱡ uⱡ ei, na kʉn peka ropa morum,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Angmʉn! Na ndi, enim ik mendpʉⱡ ti, kundʉp nimp ent ei, kum tek pilʉi! Tʉn nga anda kouwʉ Depit kurum on kona kut ei, akup tʉn mormʉn ui ila tetʉm ku. ");
INSERT INTO med_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wu ei, painui wu ei nga, Got ndi, elim kʉn, nimba mʉi ropa nitim ik ei pitim. Got ndi, nimba mʉi ropa, mi tepa, Depit elim nuim mumuk murum ei mel ku. Elim nga mepa tem wamp pundun ti tʉp, Depit nga koⱡ ila mundimp. ");
INSERT INTO med_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Depit ndi, Got nga wote etmba uⱡ mbʉ pitim ei ndi, Depit ndi, Kraist koⱡpa, rut nimba moⱡmba ei nga nimba mel, ‘Wu ei, wamp kui kona ila piyangga nimba, wak rui nʉrʉrʉm. Wu ei nga kʉng kʉⱡ, wamp on kona ila, tepa puri nʉpʉrangga!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wu Jisas ei, Got ndi, wamp kui nga kona ila, ⱡoporpa tʉpa, oⱡa mundrum. Wu ei, tʉn kʉnmʉn ei nga, para ndup ninmʉn. ");
INSERT INTO med_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Akup, Jisas wi muⱡ kona, Got nga ki mbo orunga morum. Tipam ndi, Muⱡnga Wingti nguimp nimba mi titim ei mel nguⱡnga, enim akup pilik kandʉk enmin ei, elim nga memp ei, tʉn kʉn oi ndupa ngonum. ");
INSERT INTO med_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Depit elim muⱡ kona pi nʉpʉrʉm. Ei wote, elim ndi, nimba mel, ‘Nuim ei ndi, na nga Nuim ei kundpa, nim okʉn, na nga ki mbo orunga moⱡana! ");
INSERT INTO med_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Wote, na ndi, nim nga el rui wamp mbʉ tʉp, nim nga kump puⱡ ila mana orunga mundim,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ei nga, enim Isrel wamp pilik kai enmin. Wu Jisas ni, enim ndi rok, nde peta ila pendʉtʉng wu ni, Got ndi tʉpa, Kraist Wu Nuim mundrum!” ei nga Pita ndi nitim. ");
INSERT INTO med_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wamp mbʉ, ik ei pilik, min ngʉn mundʉk iting uⱡ ei pilik rundʉk, Pita kʉn, elim nga rʉⱡaip ila wu kʉⱡ, waldʉk nʉk mel, “Angmʉn! Tʉn etʉp itamʉn mel nant?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wote Pita ndi, wamp mbʉ, kundpa nimba mel, “Enim wamp tenda tenda nʉk, numan ropʉl rok, Jisas Kraist nga mbi ila nu tʉi nitim. Enim uⱡ ei mel eng ndam, Got ndi, enim nga uⱡ kit mbʉ, wak ropa, wote enim Got ndi, elim nga Muⱡnga Wingti ei, enim wei gem ngumba. ");
INSERT INTO med_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Got ndi, enim kʉn, enim nga mek teng kangambuⱡa mbʉ kʉn, wote wamp muⱡ uⱡ kona mbila mormin mbʉ kʉn, wote Got elim ndi, nimba mʉi ropa wi ropa, rukʉr tʉm wamp mbʉ, Muⱡnga Wingti ei, nguimp,” nitim. ");
INSERT INTO med_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ndi, ik elpa mat ronduⱡ mundpa, nimba mel, “Uⱡ kit enmin wamp mbʉ kʉn, tʉk rak nduk, ʉndi nʉndʉi! Enim uⱡ kit mbʉ ndi, tʉmba ei nga, pilik kongundʉk muⱡʉi!” nitim. ");
INSERT INTO med_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ei kʉn, Pita nga ik nʉtʉm ik ni, wamp minal pilik tʉk, wote nu tʉtʉng. Ui ei kʉn ku, mondʉp pili wamp 3000 kʉⱡ kʉn ok, tʉk tenda etʉk morung. ");
INSERT INTO med_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wamp nimbʉ ndi, Jisas nga nombuⱡa rung wu kʉⱡ ndi, ik mbo rondrung mel pilik, rup rok molk, atinga rok, Got nga mbi paka rok, bret puk rok nok etʉng. ");
INSERT INTO med_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uⱡ ni kʉn, nombuⱡa rung wu kʉⱡ ndi, uⱡ rʉpʉndi minal mat elingina, wamp nimbʉ ndi kandʉk, min ngʉn mundrʉng. ");
INSERT INTO med_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mondpa pili wamp nimbʉ, en enim nga numan orunga omba, tenda puⱡnga, atinga tʉk tenda etʉk rok, en enim nga mel mbʉ, tʉk tenda etʉk, tʉn nga mint nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wote wamp mbʉ, en enim nga pana rʉng na, kng mel na nimbun, rarʉp rok, ku moni tʉtʉng nimbʉ ndi, wamp kurpa nimbʉ kʉn, mok rok ngʉk etʉng. ");
INSERT INTO med_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Rumbʉⱡ mbila rʉk rʉk ok, tenda puk, manga wingti ou ila atinga rok, wote bret mbʉ, en enim nga manga mbila, rak nduk molk nok, numan kun kai ei pilik molk, Got nga mbi paka rondʉk, wote wamp minal ndi, enim kʉn numan kai pilik etʉng. Rumbʉⱡ ant mbila rʉk rʉk, Nuim ei ndi, wamp kont nga mat etpa, wamp mbʉ kʉn tilinga, mondpa pili wamp nga rʉⱡaip ei, mam itim. ");
INSERT INTO med_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ui ti kʉn, Pita kʉn Jon raⱡ, manga wingti ila, ant 3 kilok atinga rormʉn ui ei elinga, purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Manga wingti keta puⱡ puⱡ ila nondpa, wu ti mam ndi, mitim ei kʉn, kʉmp elkʉna rumbrʉm, wu ni murum. Manga wingti ei nga keta puⱡ ti, mbi tek, ‘Mon Pi,’ nʉtmʉn. Rʉk rʉk mek puk, kai wei keta puⱡ puⱡ ila monduⱡina, wamp manga wingti ila ok, murʉk purmin mbʉ kʉn, ku moni mawa etʉm. ");
INSERT INTO med_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wu ni, Pita Jon raⱡ okʉⱡ, mukʉr pinggil orʉnggil. Ni kʉn kandpa, ku moni na mel mat, ngʉnggil nimba mawa itim. ");
INSERT INTO med_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita, Jon raⱡ ndi, elkʉna rʉmbrʉm wu ni, kandkʉⱡ kʉn, Pita ndi, nimba mel, “Tʉl kʉni!” nitim. ");
INSERT INTO med_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wote, wu ni raⱡ ndi, mel mat nguinggil, nimba pilpa kundrum mel. ");
INSERT INTO med_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita ndi, wu ni kundpa, nimba mel, “Na ku ti mon. Wote, na mel ti, nim nguimp ent ei, Nasaret Wu Jisas Kraist nga mbi ila, nim oⱡa anggilkʉn pi!” nitim. ");
INSERT INTO med_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Wote Pita ndi, wu ni nga ki mbo orunga ambuⱡpa tʉpa, oⱡa munduⱡnga, wu ni nga kʉmp elkʉna ni raⱡ, omba kʉn puⱡnga, wu ni, puka ropa, oⱡa anggilpa, nombuⱡa andpa kʉn, wu raⱡ kʉn rup rok, manga wingti ila purung. Ei kʉn, wu ni puka ropa, oⱡa mana etpa, numan kai pilpa, Got nga mbi paka rundrum. ");
INSERT INTO med_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wamp minal ndi, wu ni puka ropa, oⱡa mana elinga, kandʉk moⱡnga kʉn, numan kai pilpa, Got nga mbi paka rundrum. ");
INSERT INTO med_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wote, wamp nimbʉ ndi, wu ei, manga wingti ei nga keta puⱡ puⱡ, ‘Mon Pi,’ ila mel mbʉ, mawa etpa murum wu ei, kandʉk mbi nduk, uⱡ itim ei nga kandʉk, min ngʉn mundrung. ");
INSERT INTO med_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wu ni ndi, manga wingti ei nga keta puⱡ puⱡ ti, mbi tek, ‘Solomon nga kʉpkʉ titim nʉtmin kona ila,’ Pita kʉn, Jon raⱡ nga ki raⱡ ambuⱡpa moⱡnga, wamp mbʉ ndi kandʉk, min ngʉn mundʉk, tʉkrʉk orung. ");
INSERT INTO med_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ndi, ni uⱡ kandpa, wamp nimbʉ kundpa, nimba mel, “Enim Israel wamp mbʉ ye! Nambuⱡ emel, uⱡ ei nga numan ou nduk pilik, tʉl kʉn mong ronduⱡ kandʉk mormin? Tʉl nga ronduⱡ tila, kang wu ei etʉp, ti natʉmbʉⱡ mon! Tʉl nambuⱡ emel, mong ronduⱡ kandʉk mormin? ");
INSERT INTO med_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Got nga wu Aparam, Aisak, Jekop kʉn, tʉn nga anda kouwʉmʉn kʉⱡ nga Got. Ei ndi, elim nga kongun kindmant wu Jisas ni, mbi ou ti, uⱡ ei ngurum. Wu ei ya, enim ndi, el rui wu kʉⱡ nga ki ila tʉndʉtʉng. Wu Pailot ei ndi, wak rop mundimp nitim ni. Wote enim ndi, tʉk mbuⱡ ngorung. ");
INSERT INTO med_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Wote Wu Wingti Kun Kai ei, tʉk mbuⱡ ngʉk, enim ndi, wu Pailot ni kundʉk, wu ti wamp ropa kundrum wu ni, wak rok mundi nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wamp kont mbun muⱡmin kona ei, tʉpa orunga ndurum wu kai ei Jisas, enim ndi rok kondrung. Wote Got ndi, wu ei, ⱡoporpa tʉpa, oⱡa kont mundrum ei nga, tʉl ndi, nʉmp para ndunmbʉⱡ. ");
INSERT INTO med_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tʉl, Jisas nga mbi ronduⱡ ila mondpa pili uⱡ, Jisas nga mbi ila, nʉtmbʉⱡ. Wu ei, enim kandʉrmin wu ni, etʉp tʉnmbʉⱡ, Jisas elim ndi, tʉl nga mondpa pili ei etpa, ronduⱡ munduⱡnga, mondpa pili uⱡ ei ndi, ronduⱡ nguⱡnga, enim kanmin. ");
INSERT INTO med_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ei kʉn, akup angmʉn! Na pʉnt ei, enim pilik kun iti natʉk, etʉng uⱡ mbʉ ndi, Jisas rok rondrung. Ei mel ku, enim nga rʉp wu mbʉ ndi, uⱡ ei mel ku etʉng. ");
INSERT INTO med_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Unt Got ndi, elim nga kangʉm ei kʉn, etmba uⱡ mbʉ numan ila, pilpa pora ndupa, painui wu kʉⱡ, ronduⱡ nguⱡnga, wu Kraist ei, mindil minal nomba nʉtʉng ei, kupa enim. ");
INSERT INTO med_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Ei kʉn akup, enim nga uⱡ kit mbʉ, wak rok, numan ropʉl rangina, Got ndi, enim nga uⱡ kit etʉng mbʉ, wak rangga! Wote, uⱡ ei mel eng ndam, Got ndi, enim ronduⱡ kont mbʉ rʉk rʉk ngumba. Ei, enim nga unt, Got ndi, mbi ropa ngurum wu ei nga mbi Jisas. ");
INSERT INTO med_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Akup, elim muⱡ kona muⱡangga nitim ei mel morum. Wote Got ndi, to ropa pinditim ui ila, mel kont nga mat ngumba. Uⱡ ei, elim ndi, unt painui wu wingti mbʉ, ronduⱡ nguⱡnga, pai nok nʉtʉng ei mel ngumba. ");
INSERT INTO med_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ei nambuⱡ emel, Moses ndi, nimba mel, ‘Got enim nga Nuim ei ndi, enim painui wu ti ngumba ei, elim enim ngurum ei mel ku. Painui wu ei, enim nga rʉⱡaip tenda ila ku, ti kandpa tʉpa ngumba. Enim wamp mbʉ pora, wu ei nga ik nimbʉ, kum tek pilʉi! ");
INSERT INTO med_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wote, wamp nam ti, painui wu ei nga ik kum ti natʉm wamp ei, Got ndi, wamp ei ropa kondʉmba. Wote wamp mbʉ, Israel wamp rʉⱡaip ila, muⱡi nʉmbʉⱡing ku,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wote, Samuwel kʉn, painui wu mat unt nga mbʉ ndi, pai nok nʉtʉng. Akil tek orung, painui wu mbʉ ndi, akup nga etmba uⱡ mbʉ mel nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Enim painui wu kʉⱡ nga kangambuⱡa mbʉ mormin. Enim nga anda kouwʉmin wu nimbʉ kʉn, Got ndi, tʉp tenda itimp nimba, Aparam ni kundpa, nimba mel, ‘Nim nga mekʉn tin mbʉ ndi, kona mbila wamp mbʉ, memp kai mbʉ ngangga!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Wote Got ndi, elim nga kindmant wu ni, ⱡoporpa tʉpa, oⱡa mondpa, kuimp tepa enim kʉn omba. Wote, enim nga uⱡ kit mbʉ, tʉk mbʉⱡ ngeing nimba itim. Enim tenda tenda nimba, tʉpa yant ndupa, memp pindangga kʉn, uⱡ kit mbʉ, wak reing nimba itim,” nitim. ");
INSERT INTO med_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita kʉn Jon raⱡ wamp mbʉ, ik mbo endʉk moⱡʉnggila, wu pris mat kʉn, manga wingti ou ila rʉp wu kuimbal mbʉ kʉn, wote Sarusi wu mat kunda orung. ");
INSERT INTO med_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wu orung nimbʉ, popʉⱡ kurung. Ei nambuⱡ emel, wu raⱡ ndi, wamp mbʉ ik mbo endʉkʉⱡ, Jisas ⱡoporpa oⱡa murum nʉtʉnggil. Wote, tʉn wamp kui mbʉ, aldpa ⱡoporpʉn, oⱡa muⱡmin, nʉtʉnggil. Ni nga, en enim pilik kit pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Wote ant ei, mana puⱡnga, wu ni raⱡ, imp molk, tʉk kan manga ila pendʉtʉng. Wote, mʉkʉlmʉ orunga nʉmin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wote, wamp minal ndi, wu raⱡ nga ik nʉtʉnggil nimbʉ, kupa nʉk mondʉk pʉtʉng. I etʉng uⱡ ei ndi, wu 5000 mel itim. ");
INSERT INTO med_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ni kʉn, utʉma orunga, Jura wu nuim mbʉ kʉn, manga wingti rʉp wu mat kʉn, mi ik mbo wu nimbʉ kʉn pʉi ok, Jerusalem kona ila mou rorung. ");
INSERT INTO med_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kona ila ku, pris kuimbal murum wu Anas kʉn, Kaiyapas kʉn, wote wu Jon, Aleksanda kʉn, wu pris kuimbal ei nga wamp mbo mbʉ ok, kandʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wu rʉⱡaip nimbʉ ndi, kitip kʉni wu ni raⱡ, tʉk mek ok, oⱡa angʉndʉk, waldʉk nʉk mel, “Enmbil nambuⱡ ti enggil? Wote, namba ronduⱡ ti tek mormbil, muna nam nga mbi ila tek ninimbil?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Ni kʉn, Muⱡnga Wingti ei ndi, Pita kʉn peka ropa moⱡnga, ik ni punt ropa, nimba mel, “Enim wamp nga wu nuim mbʉ kʉn, manga wingti rup wu mbʉ kʉn, tʉl ndi, elkʉna rumbʉⱡ wu ei, tʉp rʉpʉndʉmbʉⱡ ei nga wu ei, etpa kai em mel nant, nʉk waldʉnmʉn? ");
INSERT INTO med_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ei kʉn, enim wamp pora ila mormin kʉⱡ kep, wote Isrel wamp pora, wu anggʉtʉm ei, Nasaret kona wu Jisas Kraist nga mbi ronduⱡ ila, wu ei etpa kai mundum. Ei nga, enim kundʉp nimp ei nga, pilip kai pʉnt. Jisas ni wu ei, enim ndi, nde peta ila roⱡʉngina, wote Got ndi, wamp kui nga kona ila, ⱡoporpa tʉpa, kont mundrum. ");
INSERT INTO med_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Buk Wingti unt nga ila, nimba mel, ‘Ku mam ti, enim manga rakrʉmʉn wu mbʉ ndi, ku kit nʉk mundʉk ketʉng ni, aldpa omba ku wei mbʉ nga rungina nde mel petʉm,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ya mul kump tetʉm kona mbila nga mbi elpa ti ndi, tʉn etpa tʉmba mel mon. Wamp etpa ti uⱡ ei nga Puⱡ Wu ei, Jisas morum,” nitim. ");
INSERT INTO med_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita kʉn Jon raⱡ, skul ti kep mon. Wote mbo wu mendpʉⱡ raⱡ, ik ama ronduⱡ mbʉ nʉtʉnggil ila wu nimbʉ, pilik min ngʉn mondʉk, wu raⱡ Jisas kʉn, unt rʉp rok andrʉng nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ei kʉn, kump elkʉna kai itim wu ni, Pita kʉn Jon raⱡ morung. Ei nga nila, kunda anggilik morunggil ik ti, nʉk int nduk pinding ik ti, pilik rundrung. ");
INSERT INTO med_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wote, wu morung nimba ndi, Pita kʉn Jon raⱡ ok, pena pʉl nʉk, en enim mou rok molk, ik mat nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nʉk mel, “Wu raⱡ kʉn, etʉp itmin mel nant? Ya Jerusalem kona ila, wu raⱡ ndi, elkʉna rumbuⱡ wu ei, etʉk kai monduⱡunggila, wamp nimbʉ kandʉk pora ndung. Ei nga tʉn ndi, uⱡ ei, iti natʉnggil nimbun mel, kapⱡa mon. ");
INSERT INTO med_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wote, wamp mbʉ kʉn, uⱡ ei nʉk mek int int pi nʉpeing nʉmp pilmin ndam, wu raⱡ kʉn ronduⱡ mondpʉn, Jisas nga mbi ila wamp ti kʉn, aldpa uⱡ ti iti nʉtʉnggil nʉmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ei mel nʉk pendʉk, wu raⱡ aldpa wi rok yant tʉk, nʉk mel, “Wote, kʉni nakʉndkʉⱡ aldpa, Jisas nga mbi ila uⱡ ti etkʉⱡ, ik mbo endkʉⱡ, iti nʉtʉl mon!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wote, Pita kʉn Jon raⱡ ndi, ik punt rokʉⱡ, nʉkʉⱡ mel, “En enim kʉmp tʉk pilʉi! Enim nga ik ei, kum tek pep ruing, muna Got nga kuimp keta ila Got elim pep ruing? ");
INSERT INTO med_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ei kʉn, tʉl nga keta ei, rou ruimbil mel, kapⱡa mon! Tʉl uⱡ kandpʉⱡ pilpʉⱡ, itimbʉⱡ mbʉ mel, nimbuⱡ mot nduimbil mint,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Wote, wu nuim morung nimbʉ ndi, ama pilik kelik, ik ronduⱡ mondʉk, wu raⱡ kondʉk, Jisas nga mbi ila uⱡ mat iti nʉtʉl nʉk, wote wu ni raⱡ, wak rok mundrung. Wu raⱡ, kan nguing ei nga uⱡ puⱡ ti kandʉk ti natʉtʉng. Ei nambuⱡ emel, wamp mbʉ ndi, wu ei kʉn, uⱡ itim ni kandʉk, Got nga mbi paka rondrung. ");
INSERT INTO med_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Elkʉna rumbrum wu, etkʉⱡ tʉtʉnggil wu ni, pana 40 omba purum. ");
INSERT INTO med_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wote, Pita kʉn Jon raⱡ, nondpa wak rok mondrung ni kʉn, yant okʉⱡ, en enmbil nga wamp nimbʉ, wu pris kuimbal mbʉ kʉn, wote manga wingti wu ronduⱡ mbʉ ndi, niting ik nimbʉ kondʉk nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wote, mondpa pili wamp nimbʉ, ik ei pʉtʉng ei kʉn, numan ei omba tenda puⱡnga, Got kʉn atinga rok, nʉk mel, “Nuim Got! Nim muⱡ mʉi raⱡ kʉn, num kuta ei kʉn, mel mbʉ mim itʉn Puⱡ Wu ei! ");
INSERT INTO med_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Unt, nim nga Muⱡnga Wingti ei, tʉn nga anda kouwʉ Depit, nim nga kongun wu ei nga keta ila omba moⱡpa, nimba mel, ‘Nambuⱡ emel, wamp rʉⱡaip elpa mbʉ, popʉⱡ mondunmin. Nambuⱡ emel, wamp mbʉ, kanggʉp kai kandʉk ronmin? Muⱡ kump mbila, nga wu nuim mumuk mbʉ kʉn, wote Nuim kuimbal mat kʉn, ik kanggʉp ambulk, Nuim kʉn, Elim Nga Ngurum Wu Kraist raⱡ rop mana nduimin nʉk etʉng,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ni kʉn, ama kupa, Erot kʉn, Pontas Pailot kʉn, wamp rʉⱡaip elpa ekit orunga mbʉ kʉn, wote ya Isrel wamp mbʉ, kʉmp kʉm ya kona peng ou ila, kanggʉp ambulk, Jisas nim nga kongun Wu Wingti nim ndi etkʉn, ya mul kona ila Got nga ngurum wu Kraist muⱡangga nitin ni, kanggʉp ambulk wamp nimbʉ ndi, Jisas nga ik ni tʉk pei mundrum. Jisas kʉn ik pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wamp mbʉ, mou rok etʉng, uⱡ mbʉ pora, nim nga numan ronduⱡ ila, to rokʉn pinditim mel ku, kupa tangga nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nuim ei! Nim akup, wu mbʉ nga numan kit, wote uⱡ kit enmin mbʉ pilkʉn molkʉn, wote tʉn nim nga kongun wu mbʉ, tekʉn rapʉndana, nim nga ik ei, ronduⱡ mondpʉn nimin. ");
INSERT INTO med_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nim nga ki ei, rʉna ndukʉn, wamp kui peng em wamp mbʉ, etkʉn tana uⱡ rʉpʉndi na, kont paka mat itʉi! Nim nga kindmant wu Wingti Jisas ei nga mbi ila itʉmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wote wu kʉⱡ, atinga rok pora nduⱡina, manga morung ni, rowa rowa nitim. Ei mel etpa, wu nimbʉ, Muⱡnga Wingti ndi, peka roⱡnga, Got nga ik puⱡ mondʉk, mundmong iti natʉk nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nuim ei, mondʉk pʉtʉng wamp nimbʉ ndi, numan ei tenda puⱡnga, wamp ti nga mel mbʉ, el elim nga mendpʉⱡ nimba pili nʉpʉtʉm. Wote mel mbʉ, tʉn nga rak ndupa, mint nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jisas nga nombuⱡa rung wu kʉⱡ, ronduⱡ mam ti tʉk, Nuim Jisas ni koⱡpa, ⱡoporpa oⱡa murum wu ni nga ik ni, ronduⱡ mundʉk nʉtʉnggil. Got ndi, memp pinditim ila, ik nilingina, wamp ou nduk, wu kʉⱡ pep rorung. ");
INSERT INTO med_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Wamp mbʉ nga ti, kurpa nui nʉndrʉm mon! Ni kʉn, manga na, mʉi na, mel ou nduk tek morung. Wamp nimbʉ ndi, mel nimbʉ wamp mat kʉn, ku moni tʉtʉng. Wote, ku moni nimbʉ, ku moni tʉk mek ok kʉn, wote nombuⱡa rung wu kʉⱡ ngurung. Wote, wu kʉⱡ ndi, tʉk mok rok, wamp kurpa nurum wamp nimbʉ, mok rok ngurung. ");
INSERT INTO med_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ei kʉn, Lipai wu ti, Saipras kona ila metʉng ei, mbi tek, Josep nʉtʉng. Wote, nombuⱡa rung wu kʉⱡ ndi, Barnapas nʉtʉng. (Mbi Barnapas nga puⱡ ei, ‘Nimba ndoimp rundi wu.’) ");
INSERT INTO med_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wu ei ndi, elim nga mʉi ti, wu mat kʉn, ku moni tʉpa ku mbʉ, mepa omba, nombuⱡa rung wu kʉⱡ nga ki ila tinditim. ");
INSERT INTO med_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wu ti murum, ei nga mbi ei, Ananaiyas, wote ambʉm nga mbi ei, Sapaira nʉtʉng. Wamp raⱡ nga mʉi ti, wu mat ngukʉⱡ, ku moni tʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wote, Ananaiyas ku moni titim nimbʉ nga mat ou ndupa, elim timp nimba tepa ku moni mel wei kʉralt mepa omba, nombuⱡa rung wu ni kʉⱡ ngurum. Uⱡ ei, ambʉm ndi pilpa, kapⱡa nilinga itim. ");
INSERT INTO med_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ni kʉn, Pita ndi, Ananaiyas kundpa, nimba mel, “Ananaiyas, nim Seitan ndi, nim nga numan orunga peka ropa moⱡnga, Muⱡnga Wingti ei, kol rokʉn ngukʉn, ku moni mat, ninim ambulkʉn tekʉn morun. ");
INSERT INTO med_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nim unt, mʉi ila ku ti nʉtʉtʉn ei kʉn, mʉi ei nim nga ku. Wote, mʉi ila ku moni titin ei kʉn, ku moni ei nim nga ku. Ei kʉn, nambuⱡ emel, ku moni mbʉ, Got kʉn mint nguimp nʉkʉn, numan raⱡ etkʉn pitin? Nim wamp ti kʉn, ik kol rokʉn, ngui ngʉnggʉrʉn mon. Nim Got kʉn ik kol rokʉn ngurun,” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wote Ananaiyas ni, ik ni pilpa, tʉngʉnda mint koⱡpa, mboi nitim. Uⱡ itim ni nga pʉtʉng wamp mbʉ, mundmong etʉng. ");
INSERT INTO med_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wote, kang wu mat ndi ok, Ananaiyas nga on ni, tek kom rok, mek puk on etʉng. ");
INSERT INTO med_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wote, ant mong raldika omba puⱡnga, Ananaiyas ambʉm ni, uⱡ itim ni, pili napilpa, manga nila murʉk urum. ");
INSERT INTO med_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wote Pita ndi, amp ni, waldpa nimba mel, “Mʉi ila ku moni tʉnggil ei nga ku moni, ya kuraⱡ mint mendpʉⱡ ei?” nitim. Wote amp ndi, ik punt ropa, nimba mel, “Wote int kʉⱡ mint, ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wote Pita ndi, amp ni kundpa nimba mel, “Nambuⱡ emel, nim kʉn, nim nga wanim raⱡ, Nuim ei nga Muⱡnga ei, oⱡa tʉkʉⱡ kanʉnggil. Nim nga wanʉm mek puk, on eng wu kʉⱡ ndi, yant ok, nim nga on ei, akup mek ping ei nga keta puⱡ puⱡ ila, nokundʉk mormin,” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wote tʉngʉnda mint, amp ni, Pita nga kʉmp puⱡ ila koⱡpa, mboi nitim. Kang wu ni kʉⱡ, ruk ok kandrung ei, amp ni, kurum ila, on ni tʉk mek ekit puk, wam on etʉng wʉng ila angʉndʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wote kona ila, Got nga rapa tenda wamp kʉn, wote wamp wei mat kʉn, uⱡ itim ei nga pʉtʉng wamp mbʉ pora, mundmong minal etʉng. Uⱡ Rʉpndi Elpa Elpa Mat Etʉng ");
INSERT INTO med_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Uⱡ rʉpndi wamp kʉni nakʉndʉmʉn mat, Jisas nga nombuⱡa rung wu nimbʉ ndi, wamp morung nimbila etʉng. Nuim ei, mondʉk pʉtmʉn wamp nimbʉ, numan omba tenda puⱡnga ok, Solomon nga kʉpkʉ titim kona nila mou rorung. ");
INSERT INTO med_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wote, mondpa pili wamp mbʉ nga ekit orunga, wamp rʉⱡaip elpa nimbʉ ndi, kaip minal nʉndʉtʉng. Ei wote, ekit orunga wamp mou morung wamp rʉⱡaip elpa mbʉ nga mat, ruk ui nawʉrʉng. ");
INSERT INTO med_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wote, mondpa pili wamp mou rorung nila wu kep, amp kep, wamp kont nga, minal rukʉr oⱡungina, mondpa pili wamp mou ei mam itim. ");
INSERT INTO med_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nombuⱡa rʉng wu kʉⱡ nga kongun etʉng puⱡ ila kui wamp mbʉ, nombuⱡa mam mbila mek ekit ok, muⱡ kombilik pendʉk, Pita nga min ei ndi, ropa rʉngʉndangga, kui mbʉ pora nangga, nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ei kʉn, wamp ou ndupa, Jerusalem kona peng ila nondpa tetʉm kona peng mbila petmin wamp mbʉ nga, en enim nga kui rurum wamp mbʉ kʉn, wote kur kit rukʉr orunga murum wamp nimbʉ, mek orung. Wamp nimbʉ pora, etpa kai mundrum. ");
INSERT INTO med_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wote, wu pris kuimbal ei kʉn, elim nga rʉp wu mat, Sarusi rʉⱡaip ila mat kunda, nombuⱡa rʉng wu kʉⱡ etʉng uⱡ mbʉ nga wʉlʉk rok, wu kʉⱡ kʉn, uⱡ mat itimin nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nʉk kʉn, wu kʉⱡ imp molk, tek kan manga ila pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Wote rumbuldi ei kʉn, Got nga anggelo ti ndi, kan manga kumba ila, kumba tʉpa tepa, wu ni kʉⱡ, mepa ekit omba, nimba mel, “Enim manga wingti ila puk, wamp kont mul uⱡ ei nga ik ei pora, wamp mbʉ kundʉk nʉi,” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ni kʉn, nombuⱡa rʉng wu ni kʉⱡ, ik ei pilik, kona ranggʉⱡnga unt puk, manga wingti ila wamp mbʉ kʉn, ik mbo puⱡ mondʉk endʉtʉng. Ei kʉn, wu pris kuimbal ei kʉn, elim nga rʉp wu mbʉ kʉn, Jura wu kuimbal mbʉ kʉn, wi rok tʉk mou rok molk, nombuⱡa rung wu kan manga ila petʉng ni kʉⱡ, mek weing nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Wote, el wu nimbʉ, puk kan manga ila kandrung ei, wu ni kʉⱡ muⱡi nambrʉng. Wote, el wu nimbʉ, aldpa int puk, en enim nga wu nuim nimbʉ kundʉk, nʉk mel, “Tʉn kan manga ila ruk mbun kʉnmʉn ei, keta puⱡ puⱡ ei, kumba gi nimba pim. Wote, keta puⱡ puⱡ rʉp etmin el wu nimbʉ, moⱡung ku. Ei wote, kumba tʉpʉn, kan manga ila murʉk mbun ei kʉn, wamp ti muⱡi nambʉⱡʉm,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wote, manga wingti rup wu kuimbal ei kʉn, wu pris kuimbal mbʉ kʉn, ik kʉⱡ pilik, nombuⱡa rung wu ni kʉⱡ etʉk, eng mel nant nda nʉk, numan ou nduk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ei kʉn, wu ti ndi omba, nimba mel, “Enim pinmin ye! Enim nga kan ngʉk pendʉng wu nimbʉ, manga wingti ila wamp ik mbo endʉk mormin ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wote, rʉp wu kuimbal ni kʉn, elim nga el wu nimbʉ kʉn, puk nombuⱡa rung wu nimbʉ, tek mek orung. Puk ting etʉk kʉn, ronduⱡ mundʉk uⱡ ti, iti natʉtʉng. Ei nambuⱡ emel, ronduⱡ mundʉp nimin ndam, wamp mbʉ ndi, en enim ku ndi ruing nʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Wote, nombuⱡa rung wu ni kʉⱡ mek ok, wu nuim nimbʉ nga kuimp keta nila mondrung ila, wu pris kuimbal ni ndi, waldpa nimba mel, “Tʉn ndi, enim kʉn ronduⱡ mondpʉn, enim Jisas nga mbi ila, wamp ik mbo rundi, mon nʉtmʉn! Wote, akup enim nga ik ei, Jerusalem kona ila pilik, kapⱡa endinmin ei ndi, Jisas ni, tʉn ndi, rop kundurmin ninmin,” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita kʉn, nombuⱡa rung wu kat kʉn, punt rok nʉk mel, “Tʉn Got nga ik ei mendpʉⱡ, pep ruimʉn, wote wamp ti nga mon! ");
INSERT INTO med_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Enim ndi, Jisas nde peta ila pendʉk, rok kondrung wu ni, wote tʉn nga anda kouwʉ nimbʉ nga tipam Got elim ndi, ⱡoporpa tʉpa oⱡa mundrum. ");
INSERT INTO med_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wote Got ndi, mepa muⱡ kona ila oⱡa mba, elim nga ki mbo orunga, wamp Etpa Ti Wu Nuim ei mundrum. Nambuⱡ emel, wu ei ndi, Isrel wamp mbʉ numan ropʉl rangina wamp mbʉ, nga uⱡ kit mbʉ pendpa kelmba. ");
INSERT INTO med_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Muⱡnga Wingti tʉn uⱡ kʉndrʉmʉn mbʉ nga pora nimba, mot ndonmun. Tʉn kʉn Got ndi, elim nga ik ei, kum teng wamp mbʉ kʉn, Muⱡnga Wingti ei, wei gem ngurum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wu nimbʉ ndi, nombuⱡa rung wu ni kʉⱡ, ik nʉtʉng nimbʉ, pilik popʉⱡ kulk wu ni kʉⱡ, rop kundmin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mi ik mbo wu ti, mbi tek, Gamaliyel nʉtʉng. Wu ei, Perisi wu ei, Moses nga mi ik kʉⱡ, wamp mbʉ mbo rondrum. Wu ei, wamp minal ndi, tʉk ou ndurʉng. Wu ni ndi, wu nuim morung nimbʉ nga kuimp keta ila oⱡa anggilpa, kundpa nimba mel, “Nombuⱡa rʉng wu mbʉ, tʉk pena ndangina, ant mong ralt pena ila muⱡeing,” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ei mel elingina, wu Gamaliyel ndi, mukʉr morung wu nimbʉ, kundpa nimba mel, “Enim Isrel wu mbʉ ye! Tʉk pena ndunmin wu kʉⱡ kʉn, uⱡ ti itmin nʉk, pʉlʉng ndam, numan tʉk mondʉk, pilik kun etʉk mint itʉi! ");
INSERT INTO med_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ei kʉn, enim pʉtmin ni, kot unt mel, Tatiyas ni, wu ei, elim wu nuim ti mor ku, nimba pilpa, wu 400 elim kʉn pep rorung. Wote wu ni, rok kondrung ei kʉn, pep rok andrʉng wu nimbʉ, mbuⱡ mbaⱡ nilimina, kongun etʉng uⱡ nimbʉ, pora nitim. ");
INSERT INTO med_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wote wu ei, kurum ni kʉn, gapman ndi, wamp mbi titim ei kʉn, Galili kona wu Juras ndi, oⱡa omba, elim wu nuim ti ku nimba, wamp minal rukʉr tʉpa itim. Wote wu ni, rok konduⱡina kʉn, elim nga pep rok orung wamp nimbʉ, kʉni i ku etʉk, mbuⱡ mbaⱡ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Uⱡ ei nga, na akup enim kundʉp nʉnt. Enim wu kʉⱡ kʉn, kʉni nakʉndʉk uⱡ ti iting, ama mon! Wu kʉⱡ, wak rop mundamin peing. Uⱡ enmin kʉⱡ, wamp nga ronduⱡ tila eng ndam, etʉk roⱡ pi nʉping. ");
INSERT INTO med_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wote uⱡ mbʉ, Got nga ronduⱡ ila eng ndam, enim ndi kapⱡa rok, mana ndui nʉnding. Wote, itimin nʉk eng ndam, enim Got kʉn el ruing!” nitim. ");
INSERT INTO med_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wote, wu nuim ila morung nimbʉ, wu Gamaliyel nga ik nitim nila, teng nduk Jisas nga nombuⱡa rung wu nimbʉ, wi rok mukʉr tʉk, tʉmbʉⱡ ndi rok, Jisas nga mbi ila aldpa ik mbo indi, mon nʉk, wak rok mundrung. ");
INSERT INTO med_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ei nga, Jisas nga nombuⱡa rung wu ni kʉⱡ ndi, wu nuim morung nimbʉ nga manga ni, numan kai pilik, wak rok, pena orung. Ei nambuⱡ emel, Got ndi, pilim ila, tʉn kapⱡa enim. Jisas nga mbi ila mindil tʉk, wote pipil kulk etʉk morung. ");
INSERT INTO med_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Uⱡ ei nga, rumbʉⱡ ui mbila rʉk rʉk, manga wingti ou ila kep, wamp mang kona mbila kep, wote kona mbila pora, aldpa puⱡ mondʉk, Jisas Wu Kraist, Got nga ngurum wu ei nga Rʉnang Ik Kai mbʉ, mbo rondrung. ");
INSERT INTO med_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ui mat omba puⱡnga, Jisas nga kitip kʉni wamp rukʉr orung ei nga, ou nduⱡnga, ik mbun mat oⱡa urum. Ei nga, Jura wamp Grik ik tetmin kʉⱡ ndi, Jura wamp mendpʉⱡ kʉⱡ kundʉk, en enim nga amp wiya mbʉ, rʉng na mel mbʉ nga tʉk rapʉndʉk, ngui ngangʉnmʉn, nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ei mel nilingina, Jisas nga nombuⱡa rung wu 12 ni kʉⱡ ndi, kitip kʉni wamp mat kundʉk, nʉk mel, “Tʉn Got nga ik mbo indimin uⱡ ei, wak ropʉn, kʉng orunga mbun ei nga nimin ndam, kapⱡa iti natʉmba. ");
INSERT INTO med_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ei nga angmʉn! Enim ndi, wamp mbʉ kʉn, molk kai mundangina, enim nga ruk ting ila wu 7 kat, Muⱡnga Wingti ndi, ronduⱡ nguⱡnga, pilpa kungʉndi kai tek mormin wu kat, to rop mundamina, wu kʉⱡ ndi, uⱡ mbun penim ei, rʉp etʉk muⱡeing. ");
INSERT INTO med_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wote, tʉn rʉk rʉk atinga ropʉn, wamp mbʉ, Got nga ik ei, mbo rundʉmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wote, wamp nimbʉ pora, Jisas nga kitip kʉni wu ni kʉⱡ nga ik ei, pilik numan ndi kolk, wu mat mbi rok tʉtʉng. Wu kʉⱡ nga ti, Stipen ni, wu ei Nuim ei mondpa pitim. Wote, Muⱡnga Wingti ndi, peka rurum wu ei kʉn, Pilip, Prokoras, Nikanor, Timon kʉn, Parminas, wote Antiyok kona ila wu Nikolas omba, Jura wamp nga wu, Got ei, mondpa pitim wu ei kʉn, kandʉk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wamp mbʉ ndi, wu kʉⱡ tʉk, Jisas nga kitip kʉni wu kʉⱡ kʉn, ngʉk ruk nduⱡina, wote kitip kʉni wu ni kʉⱡ ndi, peng ambulk atinga rondrung. ");
INSERT INTO med_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","I elingina, Got nga ik ei, tepa ekit puⱡnga, Jerusalem kona ila wamp ou ndupa ok, kitip kʉni wamp rarʉng. Wote, wu pris ou ndupa ku, Got nga ik ei pilik tʉk, wote Got kʉn mondʉk pilik wamp mbʉ kʉn ok, tʉk tenda etʉng. ");
INSERT INTO med_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Got ndi, wu Stipen, memp pendilinga, ronduⱡ tʉpa moⱡpa, uⱡ rʉpndi ou ndupa mat wengʉndpa, wamp morung kona nimbila itim. ");
INSERT INTO med_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wote wu mat, Stipen kʉn, ik ou ndupa nʉtʉng. Wu mbʉ nga wu mat, Sairin kona kʉn, Aliksendriya raⱡ nga atinga manga ila ei, mbi tek wamp wei mormʉn mbʉ imp muⱡi nambʉrmun wamp mbʉ nga atinga manga nʉtmin. Wote, wamp mat, Eisiya kʉn, Silisiya kona raⱡ ila ok molk, Stipen kʉn ik ou ndupa nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wote, Got nga Muⱡnga Wingti ei ndi, Stipen ni, pilpa kungʉndi kai mbʉ nguⱡnga, Stipen nga ik ei, wamp mbʉ ndi, kapⱡa rok mana ndui nʉndrʉng. ");
INSERT INTO med_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","I elinga, wu mat ndi, mat kunt rok, ik mat nʉk amundʉk, ya ei mel kʉndʉk nʉk mel, “Tʉn pilmin ei, Stipen ndi, Got kʉn Moses raⱡ nga ik, raka rondpa ninim nʉi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ei mel nilingina, wamp mbʉ kʉn, rʉp wu mbʉ kʉn, wote mi ik mbo wu mbʉ nga numan orunga, etʉp popʉⱡ oⱡa tʉndʉtʉng. Wu mbʉ kʉn, ik rondʉk mundʉk, nʉk mel, Stipen imp molk mek puk, manga wingti ila rup wu nuim mbʉ, morung nila purung. ");
INSERT INTO med_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wote, aldpa wu mat kunt rok, ik kol rok ei mel, kʉndʉk nʉk mel, “Ya wu ei, rʉk rʉk tʉn nga manga wingti ei kʉn, Moses nga mi ik ngurum kʉⱡ kʉn, nimba kit mondrum. ");
INSERT INTO med_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wote, wu ei ndi, ik ti nitim ei, ‘Nasaret wu Jisas ndi, tʉn nga manga wingti ei, ropa ʉtkil ropa, wote Moses ndi, wamp molk kunding ei mel, man ngurum uⱡ mbʉ tʉpa ekit ndumba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Manga wingti ila rup wu nuim morung nimbʉ ndi, ronduⱡ mundʉk, Stipen nem nem kandrung mel, Stipen nga kuimp keta ei, Got nga anggelo mbʉ nga kuimp keta ei mel titim. ");
INSERT INTO med_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wote, wu pris kuimbal ni ndi, Stipen waldpa, nimba mel, “Ik kupa ei?” nitim. ");
INSERT INTO med_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ni kʉn, Stipen ndi, punt ropa, nimba mel, “Wutamʉn, angmʉn! Na nga ik ei, kum tek pilʉiya! Unt tʉn nga anda kouwʉ Aparam ni, Eran kona ila pi nʉpi kʉn, Mesopotemiya kona ila pepa moⱡnga, Got wu eng nui ei ndi, Aparam pepa murum kona ila urum. ");
INSERT INTO med_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Omba kʉn, Aparam kundpa, nimba mel, ‘Nim nga mʉi na, ʉngʉnʉl na mbʉ, wak rokʉn, na ndi, nim kona ti, ora nduimp ila pukʉn, muⱡi!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ei kʉn, elim nga Kaldiya mʉi kona ei, wak ropa mba, Eran ni kona ila mba pitim. Wote, Aparam nga tipam ni koⱡnga kʉn, Got ndi, Aparam tʉpa mepa omba, akup enim pek mormin kona ila pinditim. ");
INSERT INTO med_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Got ndi, mʉi ei, Aparam elim nga mendpʉⱡ, nimba to ropa ngui ngʉnggʉrʉm, mon! Aparam elim nga kangambuⱡa ti, mon ku! Wote Got ndi, mʉi ei elim kʉn, elim nga mepa tem mbʉ kʉn, wote mbʉ nga mek teng mbʉ kʉn, nguimp nimba mʉi ropa nitim. ");
INSERT INTO med_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Got ndi, Aparam ik ei mel kun kundpa nimba mel, ‘Nim nga kangambuⱡa mek tin mbʉ, muⱡ kʉmp elpa ronggʉt ku muⱡing. Wote, kona ila nga wamp mbʉ ndi, tek kan ngʉk, kongun kindmant endʉk iteing nʉk etʉk, mindil kit mbʉ nguing. I etʉk pangina, pana 400 omba mba. ");
INSERT INTO med_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wote na ndi, nim nga kangambuⱡa mbʉ, kongun kindmant ngong wamp mbʉ etʉp, mindil kundamba kʉn, kangambuⱡa mbʉ, kona elpa ei, wak rok, wote yant ok, ya kona ila molk kʉn, na nga mbi paka runding,’ Got ndi nitim. ");
INSERT INTO med_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wote Got ndi, kʉng kupti uⱡ ei nga Aparam itangga nimba kʉn, nimba mʉi ropa pinditim. Ei nga wote, Eiparam ndi, wu Aisak mitim ei kʉn, rumbʉⱡ 8 omba puⱡnga kʉn, Aisak nga kʉng ei kup tʉtʉm. Wote, wu Aisak ni, Jekop nga kʉng ei, kup tʉtʉm ku. Wote Jekop ndi, wu 12 kʉⱡ nga kʉng kʉⱡ, kup tʉtʉm ku. ");
INSERT INTO med_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jekop nga kangʉmʉl wu mat ndi, en enim nga ʉngʉn akil, Josep kʉn, wʉlʉk rok, Isip kona ila, Josep wu mat kʉn, kindmant wamp mel raⱡpa muⱡangga nʉk, rarʉp rok ku moni tʉtʉng. Ni kʉn wote, Got ndi, Josep wak rui nʉrʉrʉm. ");
INSERT INTO med_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wote, Josep nga uⱡ mbun urum mbila, Got ndi, ki kaimp pendpa mepa purum. Wote Josep ni, Got ndi, pilpa kungʉndi kai mbʉ ngumba, Isip kona ila nga wu king kʉndrʉm ei, wu king Pero nga kuimp keta ila uⱡ mbʉ, etpa kai mundrum. Wote Pero ndi, Josep ni tʉpa wu nuim kuimbal ei, monduⱡnga moⱡpa, Isip kona ila mel mbʉ pora, rʉp itim. ");
INSERT INTO med_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wote, ui ti kʉn, Isip kʉn Keinen kona raⱡ ila, kump kun mam ti titim. Wote, tʉn nga anda kouwʉ tipamʉl mbʉ, rʉng kandʉk tʉk nuing kona mbʉ, pilik rundrung. ");
INSERT INTO med_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ni kʉn, Jekop moⱡpa pitim mel, Isip kona ila rʉng minal tetʉm nʉtʉng ei pilpa, elim nga kangʉmʉl ni kʉⱡ, tʉpa mundrung, unt pi napʉrmʉn kona ila purung. ");
INSERT INTO med_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wote, ui mat omba puⱡnga, aldpa pʉi nitim. Purung ui ei kʉn, wu Josep elim nga ʉngʉnʉl kʉⱡ kʉn, elim nga puⱡ ei, nimba mot ndurum. Wote, Isip kona ila wu king Pero ni ndi, Josep nga wamp mema kʉⱡ, pilpa pora ndurum. ");
INSERT INTO med_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ei kʉn, Josep ndi, elim nga tipam Jekop kʉn, elim nga wamp mbʉ, 75 morung ni kʉⱡ pora, Isip kona ila weing nimba, rung mundrum. ");
INSERT INTO med_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Wote Jekop kʉn, tʉn nga anda kouwʉmʉn kʉⱡ kʉn, Isip kona ila puk pek molk, wote korung. ");
INSERT INTO med_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wu korung kʉⱡ nga ombil kʉⱡ, tʉk mek puk, Sekim kona ila angʉndʉtʉng. Kona ei, Aparam ndi, unt Amor kangʉmʉl wu rʉⱡaip kʉⱡ kʉn, ku moni ndi, rop ropa titim. ");
INSERT INTO med_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Unt Got ndi, Aparam kʉn nimba mʉi rurum uⱡ mbʉ mel etmba ei nga nitim ei, etpa nondpa elinga, Isip kona ila Isrel wamp minal kalk tʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wote ei kʉn, Isip kona ila, wu king kont ti oⱡa urum. Wu ei ndi, Josep ni pilpa kun, iti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wu nuim ei ndi, tʉn nga wamp minal kalk tʉtʉng mbʉ, etpa mindil kundpa, wamp kʉⱡ nga kangambuⱡa nana, kokila meng mbʉ, pena tek kilangina, tek puk kuⱡeing nitim. ");
INSERT INTO med_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ui ni kʉn, Moses ni, kang mon wei ei, mam ndi mitim. Wote, mam tipam raⱡ ndi, kang ni, mo rok tek moⱡunggila, kalimp raldika omba purum. ");
INSERT INTO med_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wote, tek pena ndurung ila, wu king Pero nga mbuⱡam ni ndi, Moses kandpa tʉpa, kang ni tʉpa, elim nga kangʉm mel randpa, etpa ou inditim. ");
INSERT INTO med_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Wote Moses ni, Isip wamp nga uⱡ pilpa kungʉndi mbʉ, mbo endʉⱡina, kongun na, ik na, uⱡ mbʉ nga wu nuim murum. ");
INSERT INTO med_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Wote Moses ni, pana 40 elinga, elim nga Isrel wamp mbʉ, mbo kʉnimp nimba pitim. ");
INSERT INTO med_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wote tʉnggʉt kʉn, Moses ni, moⱡpa kʉndrʉm mel, Isip wu ti ndi, Isrel wu ti, etpa kit mundrum ila mba, Isrel wu ni tʉpa rapundpa, Isip wu ni, ropa kundrum. ");
INSERT INTO med_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses ndi pilpa, Got ndi, elim kʉn moⱡpa, Isrel wamp mbʉ, etpa tʉmba nʉk pileing nimba itim. Uⱡ ei, wamp mbʉ ndi, pilik kun iti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wote utʉma orunga, Isrel wu raⱡ el elinggila, Moses ndi kandpa, wu raⱡ nga nʉmp kun mundimp nimba mel, ‘Ik ei kum tiyʉl! Enmbil wu ʉngʉn ʉngʉn raⱡ, nambuⱡ emel, el enmbil?’ nitim. ");
INSERT INTO med_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wote, el ruimp nimba itim wu ni ndi, Moses punt ropa kundpa, nimba mel, ‘Nim nam ndi, tʉpa nuim mondpa uⱡ mbʉ nga tʉk kun iti nitim? ");
INSERT INTO med_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nim ukʉ nga Isip wu ti, rok kundun ni mel, akup na i ku etʉp rop kundimp nʉk pilkʉn nʉn ei?’ nitim. ");
INSERT INTO med_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wote, Moses ik ni pilpa, Isip kona ni, wak ropa, nung nimba mba, Mirian kona ila purum. Kona ila mba moⱡpa kʉn, amp ti tʉpa, kang raⱡ mitim. ");
INSERT INTO med_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wote, pana 40 omba puⱡnga, Moses ni, Sainai komnga ei nga, wur kui waka ila moⱡpa kundrum ei, nde kat ndip nomba pitim kona ila, Got nga anggelo ti moⱡnga kundrum. ");
INSERT INTO med_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Uⱡ itim ni, Moses kandpa min ngʉn mundpa kʉn, kandʉp kai itimp nimba, nondpa purum. Ei kʉn, Got nga ik ei, mel nitim, ‘Na nim nga anda kouwʉ Eiparam, Aisak na, Jekop unt morung kʉⱡ nga Got ei,’ nitim. I nilinga, Moses nga kʉmp ki nimbʉ, pur pur roⱡnga, kona ei kanʉmba ei nga mundmong itim. ");
INSERT INTO med_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wote Got ndi, Moses kundpa, nimba mel, ‘Nim nga kʉmp rʉk mel kʉⱡ potkʉn mundi! Nim int, anggilkʉn morun kona ei, mʉi wingti ila morun. ");
INSERT INTO med_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na kant ei, Isip kona ila, na nga wamp mormin mbʉ, mindil minal nok mormin. Wamp kʉⱡ nga ka enmin ei pilip kʉn, na mana omp, wamp kʉⱡ nga mbun ila etʉp timp ont. Akup nim wana! Na ndi, nim Isip kona ila, tip mundamba pʉn!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses ni, wu ei, Isrel wamp mbʉ ndi, tʉk pei mondʉk nʉk mel, ‘Nim nam ndi, nuim molkʉn, tʉn wamp mbʉ kundi nʉkʉndi?’ nʉtʉng. Got ndi, Moses ni, tʉp wu nuim mondpa, elim nga wamp mbʉ, kan tinga ndupa tangga nitim. Got nga Anggelo unt kona kui waka ila ndip mel noⱡnga, kʉndrʉm ni ndi, Moses ni, tʉpa rapundʉⱡnga uⱡ mbʉ itim. ");
INSERT INTO med_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ndi, Isrel wamp nimbʉ, Isip kona ei, wak ropa, mepa ekit urum ei kep, wote Num Kuta Kunt ei, puⱡa rok, noi orunga ekit purung ei kep, wote kona kui waka ila uⱡ rʉpʉndi ou ndupa, wengʉndupa etpa, mepa puⱡnga, pana 40 omba purum. ");
INSERT INTO med_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses ndi, Isrel wamp nimbʉ, kundpa nimba mel, ‘Got ndi painui wu na, mel ti enim nga ruk ting ila, kandpa tʉpa ngumba. ");
INSERT INTO med_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses ni, unt Isrel wamp mbʉ kʉn, kona kui waka ila rʉp rok purung. Wote wu ei ndi ku, tʉn nga anda kouwʉ mbʉ kʉn, kunda rʉp rok purung. Wote, Sainai komnga ila, Got nga Anggelo ei kʉn, ik ranggʉⱡnga, Got ndi, elim nga kont mba mul uⱡ ei nga ik ei, tʉn kundpa nangga nimba, Moses ni ngurum. ");
INSERT INTO med_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wote, tʉn nga anda kouwʉmʉn nimbʉ ndi, Moses nga nitim ik ni, teng ndui nandrʉng. Moses ni, rok pint panda etʉk, Isip kona ila aldpa kelik, int mbin nʉk, numan ila pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pilik kʉn, Eron ni kundʉk, nʉk mel, ‘Tʉn nga got mat mim itana! Got mbʉ ndi, tʉn rʉp etʉk mek peing,’ nʉtʉng. ‘Moses ni, wu tʉn Isip kona ila mepa ekit urum wu ni, nant ila pum nda, tʉn pili napʉnmʉn,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ei kʉn ku, kng kau pela mel ti, mim etʉk mondʉk, numan minal nguk, kng rung mat kalk tindiⱡim mundʉk ngʉk mel ni kʉn, atinga rorung. ");
INSERT INTO med_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","43","I etʉng ni nga, wote Got ndi, wamp nimbʉ, tʉpa mbuⱡ nguⱡnga, oⱡa muⱡ ila mipil na, mel mbʉ nga atinga rundeing nimba wak rurum. Uⱡ ei, ya unt painui wu morung nimbʉ mbʉ ndi, mon rok pendʉtʉng ni mel, kupa itim, ‘Enim Isrel wamp mbʉ ye! Enim unt pana 40 kona kui waka ila na kʉn, kng rung mel mbʉ kalk tindiⱡim mundʉk etʉng ni, na kʉn iti natʉtʉng mon! Enim ik kol got Molek nga muⱡ manga kʉⱡ mek, omba enim nga got Repan ei nga mipil ei, enim nga got ei nʉk, mim etʉng mel ei mek purung. Ei nga, na ndi, enim akup Bapilon kona ei nga mbuldung orunga tʉp mundamba, kongun kindmant wamp ralk muⱡing,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tʉn nga anda kouwʉmʉn mbʉ, kona kui waka ila morung ei kʉn, Got nga muⱡ manga kʉⱡ, Got ndi, Moses kundpa nimba, ora ndurum ni mel ku, tou ila mim etʉng. ");
INSERT INTO med_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ui mat omba puⱡnga, tʉn nga anda kouwʉmʉn mbʉ, Got nga atinga muⱡ manga ei, en enim nga tipamʉl ndi, ngurung nimbʉ mek, Josuwa kʉn puk, Got ndi, wamp ropa mundrum mʉi nimbila morung. Wote, mul manga kʉⱡ kona ila angindʉk mondʉk moⱡʉngina, wote Depit ni oⱡa urum. ");
INSERT INTO med_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Got ndi, Depit kʉn numan minal ngumba memp pendilinga kʉn, Depit ndi, Got waldpa wu Jekop nga Got ei nga manga wingti ronduⱡ ti rʉkʉndimp, nitim. ");
INSERT INTO med_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wote, manga wingti ni rakʉndimp nitim ni, wote Solomon ndi rukundrum. ");
INSERT INTO med_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Wote, Got Ama Oⱡa Nuim ei, wamp ndi, manga rakurmin ila muⱡi nambʉrʉm. Ik ei, painui wu Eimos ndi, pai nomba nimba mel, ");
INSERT INTO med_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Nuim ndi, nimba mel, ‘Mul kona ei na nga rʉpʉndi pol ei nimba. Wote, mʉi kona ei na nga kʉmp raⱡ tetʉm kona ei nʉtʉm. Enim ndi, na nga namba manga ti rʉkʉndangina, na muⱡ tʉp muⱡimp nda?’ nʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","‘Mel mbʉ pora, na nga ki raⱡ ndi, mim iti nʉtʉt ei?’” nʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Enim ik tʉk roi nduk, Got nga ik ei, kum ti natʉk etmin wamp mbʉ ye! Unt enim nga anda kouwʉ mbʉ mel ku ralk, Muⱡnga Wingti ei nga ik ei, kum ti natʉtmʉn. ");
INSERT INTO med_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Unt painui wu ti tenda na ti, enim nga anda kouwʉ mbʉ ndi, mbun mat tʉk ngui nganggʉrʉng ei? Ei mon! Enim nga anda kouwʉ mbʉ ndi, wu kun kai ei omba, ei nga pai nok nʉtʉng wu mbʉ, rok kondrung ku. Wote, akup enim ndi, wu kun kai ei urum ei kʉn, ruk molk, wote rok kondrung. ");
INSERT INTO med_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Enim ndi, Got nga mi ik ronduⱡ kʉⱡ anggelo kʉⱡ ndi, ambulk nguⱡina tʉtʉng. Ei kʉn, enim ndi, ik kʉⱡ pep rui narʉrmʉn ku,” nitim. ");
INSERT INTO med_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wote, Stipen nga nitim ik nimbʉ, rʉp wu mbʉ ndi, ik ei pilik, ama popʉⱡ ndi kolk, gu mbʉ konggilingina puk rurum. ");
INSERT INTO med_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wote, Muⱡnga Wingti ei ndi, Stipen kʉn peka rurum ila, Stipen muⱡ kona tʉpa oⱡa ndupa, Muⱡʉl Wu Kupa kʉndrʉm mel, Got nga rʉⱡang kai ila, Jisas ni, Got nga ki mbo orunga anggilpa murum. ");
INSERT INTO med_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wote Stipen ndi, wu nimbʉ, kundpa nimba mel, “Kʉnʉiya! Na muⱡ kona ei, kumba tʉpa telinga kant ei, Got nga ki mbo orunga anggilpa morum kant!” nitim. ");
INSERT INTO med_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Wu nimbʉ pora, ronduⱡ ke nʉk, en enim nga kum nombuⱡa mbʉ rou rok, tʉkrʉk ok, Stipen ni imp molk kona nila rok, tʉk pena nduk, ku ndi rorung. Stipen rorung kandrung wu nimbʉ ndi, en enim nga wal pʉki pakrung mbʉ, kang wu Sol ni ti, murum nila potʉk tetʉng. ");
INSERT INTO med_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wu ni kʉⱡ ndi, Stipen ku ndi roⱡina mel, Stipen ndi, atinga ropa nimba mel, “Nuim Jisas ye! Na nga Muⱡnga ei, nim ndi oⱡa tiyo!” nitim. ");
INSERT INTO med_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wote Stipen ndi, mura ropa mondpa, atinga ronduⱡ ropa nimba mel, “Nuim ye! Wu kʉⱡ nga uⱡ kit enmin ei, wak rundi!” nimba kʉn kurum. ");
INSERT INTO med_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stipen rok kondrung uⱡ ei, Sol ndi, kapⱡa nimba pitim. Ui ei kʉn, Jerusalem kona ila Got nga rapa tenda wamp mbʉ kʉn, uⱡ mbun mindil pi mat, ekit urum. Nuim ei, mondʉk pʉtʉng wamp nimbʉ, nung nʉk, kona elpa elpa Juriya kun, Sameriya kʉn, titim kona nimbila purung. Jisas nga nombuⱡa rʉng wu ni kʉⱡ mint, Jerusalem kona ila int morung. ");
INSERT INTO med_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Got tʉk ou ndurmʉn wamp mat ndi, Stipen kurum ei nga koⱡa manga molk, wote on ni, mek puk angʉndʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ni kʉn, Sol ni, wu ei ndi, Got nga rapa tenda wamp mbʉ, ropa etpa kit mundimp nimba, manga elpa elpa mbila mba, mondpa pili wu amp mbʉ pora, imp moⱡpa, tʉpa pena ndupa, kan manga ila mundrum. ");
INSERT INTO med_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mondpa pili wamp nimbʉ, nung nʉk kona mbila elpa elpa purung. Puk kʉn, Got nga Rʉnang Ik kai ei, nʉk mek ekit purung. ");
INSERT INTO med_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Wote, Pilip ni, wu ei ndi, Sameriya orunga mba kona peng tila, Jisas nga Rʉnang Ik Kai ei, wamp mbʉ pileing nimba mbo rundrum. ");
INSERT INTO med_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kona ila wamp minal ndi, Pilip nga uⱡ rʉpndi, Nuim ei nga ronduⱡ ila itim kandʉk, ik nitim nimbʉ pilik, kum tek kai mondʉk morung. ");
INSERT INTO med_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wote, Pilip ndi nilinga, wamp mat, kur kit rukʉr murum nimbʉ, ke nʉk wamp nimbʉ, wak rok ok, ekit purung. Omba ui ei kʉn ku, wamp elkʉna rambuⱡpa, etpa kit murum nimbʉ nilinga, omba kun purum. ");
INSERT INTO med_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Uⱡ ei elinga kʉn, kona peng ila nga wamp mbʉ ndi, numan mam ti ngorung. ");
INSERT INTO med_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sameriya kona peng ila ku, wu ti murum ei, mbi tek, Saimon nʉtʉng. Wu ei ndi, kum kundrum uⱡ mbʉ ndi, wamp mbʉ kandʉk min ngʉn mundʉk elingina, elim wu nuim ti mor, nitim. ");
INSERT INTO med_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wote, kona ila wamp ou kel, nuim kurpa nimbʉ ndi, wu Saimon nga uⱡ itim mbʉ kandʉk pilik, tʉk nʉk mel, “Wu ei, Got nga ronduⱡ ti mbi tek, ‘Ronduⱡ Ou Ti,’ nʉtmʉn ni tepa morum,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Saimon nga kum kundrum uⱡ elpa elpa mbʉ elinga, ui ruⱡ etpa omba purum. Uⱡ mbʉ, wamp mbʉ ndi kandʉk, min ngʉn mondʉk, ik kum tek morung. ");
INSERT INTO med_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wote, wu Pilip ndi, Got nga wamp tʉpa mumuk rui uⱡ ei kʉn, wote Jisas nga mbi ei kʉn, Rʉnang Ik Kai ei, kundpa nitim ni kʉn, wu amp raⱡ ik ei pilik tʉk, wote nu tʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Wote Saimon elim, Pilip nga ik nitim nimbʉ pilpa tʉpa, Got kʉn mondpa pitim. Wote nu tʉpa kʉn, Pilip kʉn moⱡpa, uⱡ rʉpndi mat, Nuim ei nga ronduⱡ ila, itim nimbʉ kandpa, min ngʉn mundrum. ");
INSERT INTO med_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jisas nga nombuⱡa rung wu nimbʉ ndi, Jerusalem kona ila molk pʉtʉng mel, Sameriya wamp nimbʉ, Got nga ik ei, pilik tʉng nʉtʉng. Ni kʉn, Pita kʉn Jon raⱡ kona ila nga pʉl nʉk tʉk mundrung. ");
INSERT INTO med_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wote, wu raⱡ ndi, Sameriya kona ila pukʉⱡ kʉn, mondpa pili wamp nimbʉ, Muⱡnga Wingti ei, teing nʉkʉⱡ, Nuim ei kʉn, atinga rorʉnggil. ");
INSERT INTO med_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","I etʉnggil, ei nambuⱡ emel, wamp mbʉ, Jisas nga mbi ila mint, nu tʉk kʉn, wote Muⱡnga Wingti ti natʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wote ni kʉn, Pita kʉn Jon raⱡ ndi, mondpa pili wamp mbʉ nga peng ila ambuⱡunggila, Muⱡnga Wingti oⱡnga tʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Saimon ndi, moⱡpa kʉndrʉm mel, mondpa pili wamp nimbʉ nga peng ila ambuⱡunggila, Muⱡnga Wingti tʉtʉng uⱡ ni kandpa, Pita kʉn Jon raⱡ nga ronduⱡ ei, elim ngʉnggil nimba, ku moni mat nguimp nimba pilpa, waldpa nimba mel, “Enmbil uⱡ mbʉ nga ronduⱡ ei, na nganggila kʉn, wote na ndi, i ku etʉp, wamp mat nga peng mbila ʉmbuⱡamba, Muⱡnga Wingti teing ku,” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wote Pita ndi, Saimon kʉn, ik punt ropa, nimba mel, “Nim kʉn nim nga ku moni ei kʉn, ndip kona ila pinggil. Nambuⱡ emel, nim pʉn ei, Got nga memp kai ei, nim nga ku moni ei ndi, kapⱡa rop rui nʉrʉn mon! ");
INSERT INTO med_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tʉn Got nga kongun enmin ila, nim ruk ila muⱡʉn mel kapⱡa mon. Ei nambuⱡ emel, nim nga mundmong rukʉr orunga, Got nga numan pʉtʉm ei mel pi napʉtʉm mon. ");
INSERT INTO med_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ei nga, nim numan ropul rokʉn, uⱡ kit ei, wak rokʉn, Nuim ei kʉn, atinga rana, nim nga numan kit pʉn ei, wak rondʉmba. ");
INSERT INTO med_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ei nambuⱡ emel, na ndi, nim kant ei, nim nga numan ei, kng yuwi na ni mel, uⱡ kit mbʉ ndi, ambuⱡpa kum ropa petʉm ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Wote Saimon ndi, Pita kʉn, Jon raⱡ kundpa, nimba mel, “Wu raⱡ ye! Na nga nʉkʉⱡ, Nuim ei kʉn atinga ranggila, Nuim ei ndi, na kont kuⱡpa, na nga uⱡ ninimbil mbʉ, na kʉn pi nʉpangga,” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita kʉn Jon raⱡ ndi, Nuim ei nga ik puⱡ mbʉ, wamp mbʉ kʉn nʉkʉⱡ pendkʉⱡ, wote Jerusalem kona ila, int purʉnggil. Pukʉⱡ kʉn, Sameriya kona kel kel tʉtʉm mbila, wamp ou ndupa, Nuim ei nga Rʉnang Ik Kai mbʉ, nʉkʉⱡ ngorunggil. ");
INSERT INTO med_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ni kʉn, Nuim nga anggelo ti ndi, Pilip kundpa, nimba mel, “Nim tʉkʉn kona etkʉn pukʉn, nombuⱡa mam ti, Jerusalem kona ou ila tepa mba, Gasa kona purum ila pi!” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ei kʉn, Pilip tʉpa kun etpa mba, nombuⱡa ila, Itiyopiya kona wu ti kandrum. Wu ei, wu oⱡa orunga ei, Itiyopiya kona amp Kuin ei nga ku moni rʉp inditim. Wu ei, Jerusalem kona ou ila mba, Got nga mbi paka rondpa pendpa, wote mang kona mbi nimba, elim nga kar mel kng os ndi, kondpa tʉtʉm mel ila urum. Ni kʉn, elim oⱡa moⱡpa, pai nui wu Aiseiya nga mon rurum ik ni, kʉmp ropa purum. ");
INSERT INTO med_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wote ila nga, Muⱡnga Wingti ndi, Pilip kundpa, nimba mel, “Nim kar mel punum mel kʉⱡ ila, nondpa pi,” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip nondpa mba, kum tʉpa pim mel, wu ni, painui wu Aiseiya nga mon rurum ik ni, kʉmp ropa purum. Pilip ndi, wu ni waldpa, nimba mel, “Nim ik mong kʉmp ron kʉⱡ, pilkʉn kun en ei?” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wu ei ndi, nimba mel, “Na pilip kun itimp mel nant? Wamp ti ndi, na ik puⱡ kʉⱡ, ropul ropa nimba ngum ndam, pilimp ei ka!” nitim. Wote, Pilip wu ni ndi, oⱡa tʉpa mepa purum. ");
INSERT INTO med_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Ik mong, Itiyopiya wu ei, kʉmp rurum ei mel, “Wu ei kng sipsip na ti, rok kunding pilik mek purmun ni mel kapⱡa. Wote, kng sipsip waⱡ na ti, elim nga ndi mbʉ, purⱡina rowa ndupa, uⱡ ti iti natʉpa, raka nimba morum. Ei mel ku, wu ei ik ti ni nʉndʉtʉm. Elim tʉk mana nduk, kot itim ik mbʉ, kapⱡa mon nʉtʉng. Wamp ti ndi, kapⱡa wu ei nga wamp rʉⱡaip mbʉ, pilik mbi ndui nʉnding. Ei nambuⱡ emel, wu ei nga mʉi kona ila moⱡpa, urum ui ei pora nitim,” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wote, ku moni rup etʉm wu ni ndi, wu Pilip waldpa, nimba mel, “Painui wu ei ndi, nam kundpa nʉnʉm? Elim nga, muna wamp elpa ti nga pilpa nitim nda? Na kundkʉn nin ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wu Pilip ik puⱡ mondpa nitim ei, wu ni nga ik mong kʉmp rurum nila nimba mba, wote Jisas nga rʉnang ik kai mbʉ kundpa nitim. ");
INSERT INTO med_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ei mel nʉkʉⱡ, nombuⱡa mam ila okʉⱡ, wote nu ti omp purum nila ruk oⱡunggila, wu ni ndi, Pilip waldpa, nimba mel, “Ya ei nu ei ka! Namba mel ti ndi, na imp moⱡangga, nu ti nʉtimp nda?” nitim.  ");
INSERT INTO med_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Wu Pilip ndi, wu ni i kundpa, nimba mel, “Nim nga numan orunga mondkʉn pin ndam, kapⱡa nu tʉn!” nitim. Wote elim ndi, punt ropa, nimba mel, “Na kupa pʉnt, Jisas Kraist ei, Got nga kangʉm ei,” nitim. ");
INSERT INTO med_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wote, Itiyopiya wu ni ndi, kar mel purʉnggil mel, ni kʉⱡ ambuⱡnga, wu raⱡ mana okʉⱡ, nu ila mana pukʉⱡ, Pilip ndi, wu ni, nu tinditim. ");
INSERT INTO med_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wote, wu ni raⱡ, nu ila ekit oⱡunggila, Nuim ei nga Muⱡnga Wingti ei ndi, Pilip ni, kiyang nimba tʉpa, mepa purum. Wu ni, Pilip kʉni nakʉndrʉm ei nga, nimba pi nʉpʉtʉm. Elim numan kai pilpa, mang kona purum. ");
INSERT INTO med_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wu Pilip elim kandrum ei, elim ni, Asotas ni, kona ila murum mel itim. Kona ila moⱡpa, mbi nimba mba mel, nombuⱡa ruk ting kona peng kel kel titim mbila, Jisas nga Rʉnang Ik Kai mbʉ, wamp mbʉ kʉn, nimba ngumba mint mba, Sesariya ekit purum. ");
INSERT INTO med_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Wote, ruk ui nimbila ku, Sol ndi, Nuim ei nga kitip kʉni wamp mbʉ, rop kondʉp mint, wang nduimp nimba pilpa omba, wu pris mbʉ nga wu kuimbal ei, murum kona ila mba, elim waldpa, mon ti ropa, Damaskas kona ila atinga manga mbila pora ndangga, kona mbila wamp mat kʉnamba, Jisas nga ik nʉtʉm ei mel, pep rong ndam, wamp mbʉ imp moⱡʉp, tʉp mep, Jerusalem yant uimp nitim. ");
INSERT INTO med_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ei mel nimba, Damaskas ni kona ila, nondpa puⱡnga, ama tʉngʉnda mint, Sol urum kona ila, rʉⱡang mam ti, muⱡ kona ila ropa mana urum. ");
INSERT INTO med_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Rʉⱡang ei ndi, Sol ropa monduⱡnga mba, mʉi ila pepa pitim mel, ik ti ndi, elim mbi tepa, nimba mel, “Sol, Sol! Nambuⱡ emel, na rok kongundʉn?” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol ndi, punt ropa nimba mel, “Nuim ei nim nam?” nitim. Wote, ik urum ei ndi, punt ropa nimba mel, “Na Jisas nim ndi, rok kongundun wu ei ka! ");
INSERT INTO med_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ei nga, nim oⱡa molkʉn, Damaskas kona peng ila rukʉr pi! Kona ila, nim namba uⱡ itin mbʉ mel, kundʉk ning,” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sol kʉn rup rok purung wu nimbʉ, ik ti ni nandʉk morung ik ei pʉtʉng. Ei wote, wamp ti, kʉni nakʉndrʉng. ");
INSERT INTO med_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Wote, Sol oⱡa moⱡpa, mong raⱡ ndi, kona kʉnimp nimba itim ni, kapⱡa iti nʉtʉtʉm. I elinga, ki ambulk mek, Damaskas kona ila purung. ");
INSERT INTO med_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ui ei kʉn, Sol nga mong raⱡ ropa tilinga, rʉng nu raⱡ, nʉi nandpa pelinga, rumbʉⱡ raldika omba purum. ");
INSERT INTO med_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Got nga kitip kʉni wu ti mbi tek, Ananaiyas nʉtʉng ni, Damaskas ni, kona ila murum. Wu ei ur kump etpa kʉndrʉm ei, Nuim ndi, elim kundpa nimba mel, “Ananaiyas!” nitim. Ik punt ropa nimba mel, “Nuim ye! Na ya mor ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Wote, Nuim ei ndi, kundpa nimba mel, “Nim tʉkʉn kun etkʉn met, Nombuⱡa Kun nʉtmʉn kona ila pukʉn, wu Judas nga manga ila, Tarsas kona ila, wu ti mbi tek, Sol, nʉtmʉn wu ei, omba morum nʉkʉn waldʉkʉn pili! Wu ei atinga ropa morum. Wu ei, ur kump etpa kanum ei, Ananaiyas ni wu ti, mukʉr omba, elim nga mong ei, piral nangga nimba, ki raⱡ ndi, peng ila ambuⱡmba ei, unt ur kump etʉp kanim,” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaiyas ndi, punt ropa nimba mel, “Nuim ye! Wamp mbʉ ndi, na kundʉk wu ei ndi, nim nga mondpa pili wamp met, Jerusalem mormin mbʉ, etpa kit mondrum nʉtʉng, pit. ");
INSERT INTO med_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wote akup, wu pris kuimbal kʉⱡ kʉn, nimba kun mundpa tepa, ya Damaskas kona ila, nim nga mbi paka rondʉrmin wamp mbʉ, tʉpa kan ngumba pilpa om,” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wote, Nuim ei ndi, Ananaiyas kundpa, nimba mel, “Nim pa! Na ndi, wu ei to rop tint wu ei, na nga kongun wu moⱡmba. Wu ei ndi, na nga mbi ei, wamp rʉⱡaip elpa na, wote wu king na, Israel wamp mbʉ kʉn, na nga mbi ei, tʉpa pena ila pendpa nimba. ");
INSERT INTO med_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wote, na nga mbi ila, mindil nomba mbʉ, nanim ndi, tʉp ora nduim,” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wote Ananaiyas mba, manga ila murʉk mba, elim nga ki raⱡ tʉpa, Sol nga peng ila ambuⱡpa, Sol kundpa, nimba mel, “Ana Sol! Nuim Jisas ndi, elim nim ya uimp nʉkʉn urum ila, nim nombuⱡa paka ila kundrum. Wu Nuim ei ndi, na tʉpa mundum. Wu ei ndi, nim aldpa mong raⱡ piral nangga, kʉnʉn nitim. Wote nim, Muⱡnga Wingti ei ndi, peka rangga nimba, na tʉpa munduⱡnga ont,” nitim. ");
INSERT INTO med_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ama tʉngʉnda mint, Sol nga mong raⱡ ila, oma kundun na ni mel mat, ndiⱡimp nimba, mana puⱡnga, wu ei nga mong raⱡ piral nilinga, kona mbʉ aldpa kundrum. Wote oⱡa anggilinga, nu tinditim. ");
INSERT INTO med_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","20","Wote, rʉng nomba elinga, elim nga ronduⱡ ei, yant urum. Sol Ei Ndi, Nuim Ei Nga Ik Ei, Damaskas Wamp Mbʉ, Nimba Ngurum Sol ndi, Damaskas kona ila, mondpa pili wamp mat kʉn, rumbʉⱡ mat moⱡpa kʉn, atinga manga mbila mba, ik pʉⱡ mat nimba, mot ndupa, Jisas ei, Got nga Kangʉm ei nitim. ");
INSERT INTO med_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ni kʉn, ik pʉtʉng wamp mbʉ ndi, min ngʉn mondʉk waldʉk, nʉk mel, “Jerusalem kona ila wu ei ndi, Jisas nga mbi paka rondʉk etʉng wamp mbʉ, ropa kundpa itim wu waⱡʉm ei, nʉmp kanmin ei, muna mon? Wote akup, ya Damaskas kona ila wamp kan ngumba, mepa Pris kuimbal kʉⱡ kʉn, pi napʉmba om nda?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wote, Sol nga ik ei, ama ronduⱡ puⱡnga, Jisas ei, wu Got ngurum wu Kraist nitim. Ei nga, Jura wamp Damaskas moⱡung mbʉ ndi, Sol nga ik ei, punt rok ning mel iti nʉtʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wote, rumbʉⱡ mat ou ndupa omba puⱡnga kʉn, Jura wu nimbʉ, ik nʉk pendʉk, nombuⱡa mam ti kandʉk tʉk, Sol rop kundmin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wote, Sol wu kʉⱡ nga ik nʉk pendʉtʉng ei pitim. Rumbuldi rʉnggilmʉ mbʉ, Sol rop kundmin nʉk, kona ou ei nga, keta puⱡ puⱡ ila nokʉndrʉng. ");
INSERT INTO med_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Wote, i elingina rumbʉⱡ tila, Sol nga ik pep rorung wu nimbʉ ndi, Sol ku paⱡa etʉng nila, kelwa wal kat ila, Sol rukʉr mba moⱡnga, kan kulk, kan punt raⱡ ambulk molk, raka raka nʉk, wak rok paⱡa ekit orunga mundrung. ");
INSERT INTO med_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wote, Sol Jerusalem kona ila mba, kitip kʉni wamp mbʉ kʉn, kup itimp nimba pitim ni, wote wamp nimbʉ, Sol nga mundmong etʉk, wu ei, nuim ei nga kitip kʉni wu kupa ti, nʉk pili napʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Wote i elinga, Barnapas omba, Sol tʉpa rapundpa mepa mba, Jisas nga nombuⱡa rung wu kʉⱡ kʉn purum. Mba Sol, nuim ei nombuⱡa mam ila, Nuim ei kandpa, ik ranggʉpa itim ni mel, ik timan mbʉ ropa, nombuⱡa rʉng wu kʉⱡ ngurum. Wote Sol, Damaskas kona ila, Nuim ei nga ik ei ronduⱡ mondpa nimba itim uⱡ mbʉ, Barnapas ndi, timan rurum ku. ");
INSERT INTO med_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","30","I etpa nilinga, Sol ni, rukʉr tilingina, Jerusalem tetʉm kona mbila pora mba, Nuim ei nga mbi ila, ik puⱡ mbʉ ronduⱡ mundpa, mbo inditim. Sol ik ronduⱡ mundpa, nimba mba kʉn, Grik ik nʉtmʉn Jura wamp mbʉ kʉn, ik mel itim ila, wamp mbʉ ndi, rok kunding pilik etʉng. Ni kʉn, mondpa pili wamp mbʉ, etʉk tʉk mendʉk kʉn, wote Sol ni, Sesariya kona ila mek puk, Tarsus kona ila, tʉk munduⱡina purum. ");
INSERT INTO med_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ei kʉn, Juriya, Galilee, Sameriya mbi paka rormin kona nimbʉ pora, moⱡpa kundi ui kai ti kandʉk tʉtʉng. Ni kʉn, kona ila wamp mbʉ, Muⱡnga Wingti ndi, etpa ronduⱡ munduⱡnga, Nuim ei nga mundmong etʉk, mana orunga moⱡʉngina, wamp puⱡi ruk ok, mbi paka rorung. ");
INSERT INTO med_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ik mbo endpa, kona mbila pora ʉndrʉm. Tʉnggʉt kʉn, Got nga wamp met Lira morung kʉⱡ kanʉmba purum. ");
INSERT INTO med_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kona ila mba kʉn, Einiyas ni, wu ti kʉndrʉm. Wu ei nga kʉng mbʉ, moiya rurum ila, rupⱡaima ila mint pelinga, pana 8 omba purum. ");
INSERT INTO med_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wote Pita ndi, wu ei kundpa, nimba mel, “Einiyas, Jisas Kraist ndi, nim aldpa etpa kai mondnum. Oⱡa molkʉn, nim nga rupⱡaima kʉⱡ tʉkʉn kun iti!” nitim. Tʉngʉnda mint, Einiyas oⱡa murum. ");
INSERT INTO med_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wote Lira, Saron kona raⱡ ila, pʉtmʉn wamp mbʉ, wu ei kandʉk kʉn, numan ropʉl rok, Nuim ei kʉn, rukʉr purung. ");
INSERT INTO med_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wote Jopa ni, kona ila mondpa pili amp ti, mbi tek, Tabita, nʉtʉng ei murum. (Wote, Grik ik ila, mbi tek, Dokas, nʉtʉng). Amp ei, uⱡ kai mbʉ rʉk rʉk etpa, wamp kurpa mbʉ, tʉpa rapundpa itim. ");
INSERT INTO med_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","40","Ui ei kʉn, amp ni kui kandpa, tʉpa kurum. On ei, nu tendʉk mek, manga kʉkaⱡ oⱡa orunga, tila tetʉng. Jopa ni kona ei, Lira kʉn, nondpa mel titim. Wote, Jopa mondpa pili wamp kʉⱡ, Pita omba, Lira ni kona ila murum ei, pilik kʉn, wu raⱡ tʉk nombuⱡa rung mundʉk ei mel waldʉk, nʉk mel, “Pʉt pʉt, ama akilma, ya tʉn mormin ila ui!” nʉtʉng. Pita nombuⱡa rung ik ei, pilpa tʉpa kʉn, elim tʉpa kun etpa, wu raⱡ kʉn purum. Pita kona ila mba, ruk puⱡnga, tʉk mek manga kʉkaⱡ oⱡa orunga ila purung. Ei kʉn, amp wiya ou ndupa, Pita murum nila molk, pok etʉk, ka etʉk mel, amp Dokas kont moⱡpa kʉn, wal pʉki ou kel mim itim nimbʉ, Pita tʉk ora nduk etʉng. Wamp nimbʉ, Pita ndi, tʉpa pena ndupa, elim mura koptʉm ropa mondpa, atinga rurum. Wote, tʉpa ropʉl ropa, amp on ei, kundpa nimba mel, “Tapita, nim oⱡa moⱡa!” nitim. I nilinga, amp ni, mong raⱡ makilpa, wote Pita kandpa kʉn, amp ei oⱡa murum. ");
INSERT INTO med_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","43","Pita ndi, amp ei, ki ambuⱡpa tʉpa, oⱡa mundrum. Wote amp ni, etpa kont mondpa kʉn, mondpa pili wamp na, amp wiya na nimbʉ, wi ropa rukʉr tʉpa, etpa kont titim amp ni, en enim ngurum. Uⱡ itim ni nga, timan ik ei, Jopa kona ila tepa ndaip nitim ila, wamp mbʉ pora, Nuim ei kʉn, mondʉk pʉtʉng. Jopa kona ila, Pita ni, Saimon, nʉtmʉn wu ti, kng kau kʉng mim etʉm wu ni kʉn, pepa moⱡnga, rumbʉⱡ ou ndupa omba purum. ");
INSERT INTO med_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesariya kona ila wu Koniliyas ni, wu ti murum. Wu ei, Rom Gapman ei nga el wu mormin mbʉ nga wu rʉⱡaip kat mbi tek, “Itali Rʉⱡaip” nʉtmʉn kʉⱡ nokundrum. ");
INSERT INTO med_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wu ei kʉn, wote elim nga wamp mbo kʉⱡ pora, Got nga mundmong endʉk, Got nga mbi paka rondʉk etmin. Jura wamp kurpa mbʉ, rʉk rʉk tʉpa rapundpa, Got kʉn rʉk rʉk atinga ropa itim. ");
INSERT INTO med_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ui ti kun, kona ant ei 3 kilok epindama elinga, ur kump mel etpa kʉndrʉm mel, Got nga anggelo ti ndi omba, nimba mel, “Koniliyas!” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wote mundmong etpa, anggelo ni, nem nem kandpa, nimba mel, “Nuim ye! Namba uⱡ em?” Anggelo ndi, punt ropa, nimba mel, “Nim nga atinga rorʉn, wote tʉpa rʉpndi kongun kai etʉn uⱡ nimbʉ, Got ndi, numan ngumba, pilpa kai pilpa morum. ");
INSERT INTO med_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Akup ant ila, met Jopa kona ila, wu Saimon Pita ni, ei morum kona ila, wu mat tʉkʉn mundana, kurʉk pinggil. ");
INSERT INTO med_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wu ei, wu Saimon ni ti, kng kau kʉng mbʉ nga kongun etʉm wu ei nga manga ei, num ʉldʉ ila anggʉtʉm kona ila mba morum,” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Wote Anggelo ni, kelpa puⱡnga kʉn, Koniliyas ndi, elim nga kongun wu ralt kʉn, el wu ti, Got kʉn mondpa pili wu ti kʉn, wi ropa rukʉr tʉpa mondpa, elim kʉn anggelo ei ndi, ik nitim nimbʉ mel, timan ropa ngumba, wote wu Koniliyas ndi, wu kʉⱡ, Jopa kona ila, tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Puk kʉn, nombuⱡa ruk ting ila ting manga petʉng. Pek kona ranggʉⱡnga, Jopa kona peng ila, ekit purung. Purung ui ni kʉn, rʉnggilmʉ Pita ni, manga im ila, oⱡa mba atinga rurum. ");
INSERT INTO med_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Wote, Pita kump kun kuⱡpa, rʉng mat namp nimba pitim ni, rʉng mbʉ kokila kaⱡina mel, Pita ndi, ur kʉmp mel etpa kʉndrʉm. Ni kʉn, muⱡ kona kumba tilinga, muⱡ mbal para na, ni mel ti, muⱡ punt tʉmbʉkak kʉⱡ ila ambuⱡpa, ya mʉi ila mana ndurum. ");
INSERT INTO med_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Muⱡ ei nga rukʉr orunga, kundrum ei, kimbuⱡa na, kng, kui kʉi na, mel rakra mbʉ pitim. ");
INSERT INTO med_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ik ti ndi omba, Pita kundpa nimba mel, “Pita nim oⱡa molkʉn, mel kʉⱡ rok koikʉn nun ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wote Pita ndi, nimba mel, “Nuim ye! Na ndi, ei mel kapⱡa iti nʉtimp. Ei nambuⱡ emel, na ndi, mel ⱡar mul mbʉ kʉn, wote mel eng nui nʉni mbʉ, na nui nandʉr, mon!” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ik nitim ni ndi, aldpa Pita kundpa, nimba mel, “Got ndi, mel ti kai nʉtʉm ei, nim ndi, kit ni nʉni mon!” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uⱡ ei mel etpa, raldika elinga kʉn, wote muⱡ mbal mel ni, muⱡ kona ila oⱡa titim. ");
INSERT INTO med_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita ur kʉmp mel elpa kʉndrʉm ni nga puⱡ ei, pilip mbi nduimp nimba murum. Ni kʉn, Koniliyas ndi, wu tʉpa mundrum ni kʉⱡ, Saimon nga manga ei, kandʉk tʉk ok, paⱡa ekit orunga keta puⱡ puⱡ ila anggilik morung. ");
INSERT INTO med_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kona ila molk, tʉk rukʉr nduk, wi rok waldʉk, nʉk mel, “Wu Saimon Pita, nʉtmʉn wu ei ila morum ei?” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Ni kʉn, ur kʉmp mel etpa kʉndrʉm uⱡ ni nga, Pita ndi, puⱡ ei, pilip mbi nduimp nimba moⱡnga, wote Muⱡnga Wingti ei ndi kundpa, nimba mel, “Nim pʉn ye! Wu raldika kat nim kurʉk onmʉn. Ei nga, nim numan ou ndukʉn, pili napʉlkʉn, tʉkʉrkʉn mana pukʉn, wu kʉⱡ kʉn rup rokʉn pi! Wu kʉⱡ, na ndi, tʉp mundʉⱡmba onmʉn,” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wote Pita ndi, mana mba, wu kʉⱡ, kundpa nimba mel, “Na enim kurʉnmin wu ei na! Enim nambuⱡ emel ong?” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wu kʉⱡ ndi, punt rok, nʉk mel, “Tʉn nga el wu kuimbal Koniliyas ndi, tʉpa munduⱡnga onmʉn. Wu ei, Got nga mundmong etpa, Got nga mbi paka rondpa, uⱡ kun kai mbʉ etʉm. Jura wamp mbʉ ndi, wu ei, tʉk ou nduk etmin. Wote, anggelo ti ndi omba, nim wu ei nga elim nga mang kona ila okʉn, ik mat kundʉk, nʉn nitim ei nga onmʉn,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","I nilingina kʉn, Pita ndi, wu kʉⱡ, rumbʉⱡ ei kʉn mukʉr tʉpa, elim nga manga ila ur pimʉn, nitim. Utʉma orunga, Pita tʉpa kun etpa, wu kʉⱡ kʉn rʉp ropa purum. Wote, Jopa kona ila mondpa pili wamp mat, kunda ku, rʉp rok purung. ");
INSERT INTO med_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wote, puk ting manga pek, utʉma orunga, Sesariya kona ila ruk purung. Ei kʉn, Koniliyas ndi, elim nga wamp mbo tenda na, manga keta kup wamp na mbʉ, ruk tʉpa, mou ropa, Pita nokundpa murum. ");
INSERT INTO med_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","26","Pita manga nila mukʉr mbi nimba elinga, Koniliyas ni, Pita kandpa tʉpa, kump puⱡ ila mura koptʉm ropa mondpa, mbi paka ruimp nimba elinga, wote Pita ndi, Koniliyas etpa, tʉpa oⱡa mondpa, nimba mel, “Oⱡa anggila! Na nim mel ku, ei ka!” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita ndi, Koniliyas kʉn ik nimba moⱡpa, manga nila murʉk mba kʉndrʉm ei, wamp minal mou rok morung. ");
INSERT INTO med_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wote wamp mbʉ, kundpa nimba mel, “Enim pora, pilik ketmin ni, Jura wamp nga mi ik ei ndi, Jura wamp ti, wamp rʉⱡaip elpa kʉⱡ kʉn nondpa, puk kup etʉk, iting ei mon nimba petʉm. Wote Got ndi, na uⱡ ti, ora ndupa, wamp mbʉ nga, wamp ti, ⱡar morum ni nʉni mon! Wote wamp ti, eng norum ni nʉni, mon! ");
INSERT INTO med_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ei nga, enim na rung mundung ei kʉn, na enim nga ik ei, kum tep teng ndup unt. Akup na ndi, enim waldʉp kʉn, enim na nambuⱡ emel, rung mundung nda?” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","31","Wote Koniliyas ndi, punt ropa, nimba mel, “Rumbʉⱡ tʉmbʉkak omba puⱡnga kʉn, epindama ant 3 kilok, na mang kona ila atinga rop moⱡmba, wu ti, muⱡ mbal kurmʉⱡʉ eng nui kat ti raⱡpa, na mur ila urum. Wote, wu ei ndi, na kundpa, nimba mel, ‘Koniliyas! Got ndi, nim nga atinga rokʉn, wote wamp kurpa mbʉ, tʉkʉn rapundkʉn etʉn uⱡ nimbʉ, pilpa kandpa mbi ndurum. ");
INSERT INTO med_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ei kʉn, wamp mat tʉk mundana, met Jopa kona ila wu Saimon ni ti, mbi tek, Pita nʉtmin ei, petʉm kona ila pangga! Wu Saimon ei, kng kau kʉng mim etʉm wu ei nga manga met, num ʉldʉ ila, manga tʉma mba morum,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ik ei pilip kʉn, na nim wun nʉmp rung mundunt ei kʉn, nim teng ndukʉn un ei, uⱡ kai ti in. Akup, tʉn wamp pora, Got nga kuimp keta ila ombun nokundpʉn mormun. Ei nga, Nuim ei ndi, nim namba ik mat mbo rondum mbʉ, tʉn kundkʉn nana pilamin!” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Wote Pita ndi, ik puⱡ mondpa, nimba mel, “Na akup pilip mbi ndunt ei kupa, Got ndi, wamp mbʉ pora, to tenda ila mint kʉmp tʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wote, wamp rʉⱡaip elpa elpa nant mbʉ nga wamp ti, elim Got nga mundmong etpa, uⱡ kun mbʉ mint etpa moⱡum wamp ei, Got ndi, kandpa kapⱡa nimba pʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Enim pilik mormin ei, Got nga nombuⱡa rung ik ei, Isrel wamp kʉⱡ kʉn urum ni ka! Nombuⱡa rung ik ei ndi, Jisas Kraist kʉn moⱡpa kundi uⱡ, rʉnang ik kai kʉⱡ, Got ndi, tʉn kʉn ngumba mundrum. ");
INSERT INTO med_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Enim Jon ndi, wamp nu tindi uⱡ ei nga puⱡ ei, nimba mel ngurum ei, pilik mormin. Ui ei kʉn, Jisas nga rʉnang ik ei, Galili na Jura kona mbila puⱡ mondʉk nilingina, para purum. ");
INSERT INTO med_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ik ei, Nasaret wu Jisas nga ik ei, Got ndi, wu ei to ropa tʉpa, Muⱡnga Wingti ngumba ronduⱡ ngurum. Wote, Got wu ei kʉn murum uⱡ ei ndi, kona elpa mbila mba, uⱡ kai mbʉ etpa, Seitan ndi, tepa murum wamp mbʉ etpa titim. ");
INSERT INTO med_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wote tʉn ndi, wu ei nga itim uⱡ mbʉ nga Jura kona na, Jerusalem kona mbila kundpʉn, nimbun pora ndurmʉn. Wu ei, nde peta ila pendʉk roⱡina, kurum. ");
INSERT INTO med_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wote, rumbʉⱡ raldika omba puⱡnga, Got ndi, Jisas ⱡoporpa tʉpa, oⱡa monduⱡnga, omba pena ila pitim. ");
INSERT INTO med_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Got ndi, elim wamp mbʉ pora, ora ndui nandrʉm mon! Wote elim ndi, tʉn to ropa tʉpa, elim nga ik ei nʉtmʉn wamp mbʉ, ora ndurum. Wote, elim on kona ila rut nimba murum. Ei kʉn, tʉn elim kʉn rʉng na, nu na mbʉ nomp etmin. ");
INSERT INTO med_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wote, Jisas elim ni, Got ndi, wamp kui kont mbʉ, kʉmp tʉmba ei nga tʉpa, kuimbal mundrum. Ei nga, tʉn ndi, wamp mbʉ, ik ei tʉk pena ila pendʉk, mbo indʉi, nitim. ");
INSERT INTO med_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Painui wu mbʉ ndi, unt wu ei nga nʉndʉk mel kʉn, wamp nam ti ndi, Jisas nga mbi ei, mondpa pilim ndam, wu ei nga mbi ronduⱡ ila, elim nga uⱡ kit mbʉ, pendpa kelmba,” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ni, ik mbʉ nimba moⱡnga, ik kum tek morung wamp nimbʉ, Muⱡnga Wingti ei mana omba, wamp mbʉ kʉn murum. ");
INSERT INTO med_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ei kʉn, Jura mondpa pili wamp mat, Pita kʉn Jopa kona ila kunda molk, orung ni kʉⱡ, Got ndi Muⱡnga Wingti ei, wamp rʉⱡaip elpa kʉⱡ kʉn, kun oi ndupa ngurum ni, Jura wamp kʉⱡ, pilik min ngʉn mundrung. ");
INSERT INTO med_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Ei nambuⱡ emel, wamp rʉⱡaip elpa mbʉ, ik nuim kan elpa elpa mbila, tek nʉk, Got nga mbi paka rondrung. Ei nga, Pita ndi, nimba mel, “Wamp kʉⱡ, akup Muⱡnga Wingti tʉnmin ei, tʉn kitip kʉni wu kʉⱡ titmin, ei mel ku tʉnmʉn. Ei kʉn, wamp nam ti ndi, kapⱡa ya wamp kʉⱡ, nu ti nʉteing nʉk, mi pinding?” nitim. ");
INSERT INTO med_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","I nimba kʉn, wamp mbʉ kapⱡa, Jisas nga mbi ila nu teing nitim. Wote, wamp nimbʉ ndi, Pita waldʉk, en enim kʉn muⱡangga, rumbʉⱡ mat omba pangga nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nombuⱡa rung wu na, mondpa pili wamp Jura kona mbila pora petmin nimbʉ ndi, wamp rʉⱡaip elpa minal, Got nga ik ei, pilik tʉnmin nʉtʉng ik timan ni, pilik kapⱡa endʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Ei kʉn, Pita ndi, Jerusalem purum mel, Jura wu mat ndi, mondpa pili rʉⱡaip elpa wamp mbʉ nga kʉng kuptʉmin nʉk pilik morung wu nimbʉ ndi, Pita ik mura nguk nʉk mel, “Nim wamp rʉⱡaip elpa mbʉ nga kʉng kupti nʉpti mbʉ nga mang kona pukʉn, rʉng nokʉn in ei ka!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Ei kʉn, Pita ndi, uⱡ puⱡ mondpa itim ni mel puⱡ mondpa, nimba mel, “Na Jopa kona peng ila atinga rop moⱡʉp, ur kʉmp mel kandʉp kundʉr ei, muⱡ kona kumba tilinga, muⱡ mbal na ni mel ti, muⱡ punt tʉmbʉkak ila moⱡpa, mana nduⱡnga omba, na mur ʉldʉ ila titim. ");
INSERT INTO med_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Muⱡ ei nga rukʉr orunga kʉndʉr ei, kimbuⱡa na, kng na, kui kʉi mel rakra mbʉ, pitim. ");
INSERT INTO med_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Wote, ik ti ndi, nimba mel, ‘Pita, oⱡa molkʉn, mel mbʉ rokʉn, nun ka!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wote na ndi, punt rop, nʉmp mel, ‘Nuim ei na ndi, uⱡ ei mel, kapⱡa iti nʉtimp. Ei nambuⱡ emel, na nga keta ila mel ⱡar muⱡ na, kit mbʉ, nui nandʉr mon, ni ka!’ nit. ");
INSERT INTO med_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wote, muⱡ kona ik pit ni ndi, wote na kundpa, nimba mel, ‘Got ndi, mel mbʉ kai nʉtʉm mbʉ, nim ndi, ⱡar morum ni nʉni mon!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Uⱡ ei mel etpa raldika elinga, wote mel ni, muⱡ kona ila oⱡa titim. ");
INSERT INTO med_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Uⱡ ei, kandʉp pora ndup moⱡmba, Sesariya kona ila wu raldika kat, na kʉn tʉk mundrung wu ni kʉⱡ ok, na pep mur manga nila ruk orung. ");
INSERT INTO med_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wote, Muⱡnga Wingti ei ndi, na kundpa, nimba mel, ‘Nim numan ou ndukʉn, pili napilkʉn, wu kʉⱡ kʉn pi!’ nitim. Ei pilip kʉn, ya Jopa kona ila mondpa pili wu 6 ni kʉⱡ kʉn, Sesariya kona ila rʉp ropʉn, Koniliyas nga mang kona purmun. ");
INSERT INTO med_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wote, puⱡmina, Koniliyas ndi, tʉn kundpa, elim Anggelo ti ndi, na nga mang kona omba, na ku, ndpa nimba mel, ‘Wamp mat tʉkʉn nombuⱡa rung mundana, met Jopa kona peng ila wu ti, mbi tek, Saimon Pita nʉtmin ei wangga ni! ");
INSERT INTO med_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wu ei ndi, ik kai mat, nim kundpa nangga, ‘Nim kʉn nim nga wamp mbo mbʉ kʉn pora, Got ndi, enim etpa peng kont tʉmba!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Wote, na puⱡ mondʉp, Koniliyas nga manga ila ik nilmba kʉn, Muⱡnga Wingti ndi, wamp kʉⱡ kʉn mana urum. Ei kʉn, tʉn kitip kʉni wu kʉⱡ kʉn, kuimp tepa urum uⱡ ni mel ku, akup wamp ni kʉⱡ kun onum. ");
INSERT INTO med_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wote, i elingina mel, Nuim ei nga ik ti nitim ei, tʉp mendʉp pit. Ei na nga numan ila omba rundrum ei ndi, nimba kʉn, ‘Jon wamp nu tinditim ei, nu ila mint titim. Wote, enim Muⱡnga Wingti ila nu ting,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Akup pilip pora ndonmʉn ei, tʉn unt Nuim Jisas Kraist kʉn mondʉp puⱡmina, Got ndi, tʉn elim nga mel ronduⱡ ei, wei gem ngurum. Ei wote, akup mbo wamp mbʉ, mel tenda i ku tʉnmʉn. Ei kʉn, na wu nam ei ndi, Got nga kongun ei mon nimp?” nitim. ");
INSERT INTO med_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wote, wamp mbʉ pora, Pita nga ik ei, pilik kʉn, ik mura etʉng nimbʉ kelik, aldpa Got nga mbi paka ronduⱡ rok ei nʉk mel, “Ei kʉn, akup kanmin ei, wamp rʉⱡaip elpa mbʉ, Got ndi, etpa numan ropʉl rondpa, etpa kont tʉnʉm.” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Unt Stipen ni, rok kondrung ni kʉn, mbun mam ti oⱡnga kʉn, mondpa pili wamp nimbʉ, mbuⱡ mbaⱡ nʉk, elpa elpa purung. Mondpa pili wamp nimbʉ, puk kona elpa elpa, Ponisiya, Saipras kʉn Andiyok ni, kona kʉⱡ ila puk, Got nga rʉnang ik kai ei, Jura wamp kʉⱡ kʉn, mendpʉⱡ nʉk ngurung. ");
INSERT INTO med_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wote, mondpa pili wu mat, Saipras kʉn Sairin ni kona raⱡ, ila nga wu mbo mat nga kat, Andiyok kona ila puk kʉn, Grik wamp mbʉ kʉn, Nuim Jisas nga Rʉnang ik kai mbʉ, nʉk ngurung. ");
INSERT INTO med_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nuim ei nga ronduⱡ ei omba, wu kʉⱡ kʉn telinga, wamp puⱡi numan ropʉl rok, Nuim ei kʉn rukrʉng orung. ");
INSERT INTO med_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Andiyok kona ila, uⱡ pitim mbʉ nga timan ik ei, Jerusalem rapa tenda wamp mbʉ kʉn puⱡnga, Barnapas ni, tʉk Andiyok kona ila mundrung. ");
INSERT INTO med_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ruk mba kʉndrʉm ei, Got ndi, wamp mbʉ, memp minal pinditim ei kandpa, numan ndi koⱡpa wamp mbʉ, nimba ronduⱡ mundpa, Nuim ei, tʉk enim nga mundmong ila mondʉk, Nuim ei, rʉk rʉk ambulk gi nduk muⱡʉi nitim. ");
INSERT INTO med_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnapas ni, wu kai ei nga, Muⱡnga Wingti ei ndi, peka ropa moⱡnga, mondpa pili ronduⱡ puⱡnga, wamp minal Nuim ei kʉn rukrʉng orung. ");
INSERT INTO med_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wote Barnapas ni, Sol kurpa, Tarsus ni kona ila purum. ");
INSERT INTO med_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Barnapas ni, Sol kandpa tʉpa kʉn, mepa Andiyok urum. Wu raⱡ molkʉⱡ, pana ti tʉk mundkʉⱡ, ropa tenda wamp mbʉ, ik mbo endkʉⱡ, wamp minal etʉk rukrʉng tʉtʉnggil. Andiyok kona ila kitip kʉni wu nimbʉ, mbi kont tek, “Kristen” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ui ei kʉn, painui wu mat, Jerusalem molk, Andiyok kona ila purung. ");
INSERT INTO med_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wu kʉⱡ nga ti, mbi tek, Akapas, nʉtʉng wu ni, Muⱡnga Wingti ei ndi, ronduⱡ nguⱡnga, oⱡa anggilpa, nimba mel, “Kump kun kan kit ti, ya Rom nga mʉi kʉmp mbila pora, nondpa ekit omba,” nitim. (Ui ei, Rom kona ila nga wu nuim mumuk Klotiyas ni, nuim murum ei kʉn ekit urum). ");
INSERT INTO med_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kitip kʉni wu nimbʉ elpa elpa, en enim nga ku na, mel tʉtʉng mbʉ, mondpa pili wamp ʉngʉnʉl mat, met Juriya kona ila morung nimbʉ, tʉp rʉpʉndmin nʉk, ik nʉk pilik, tʉk tenda itmin nʉk, pilik tʉk kun etʉng. ");
INSERT INTO med_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","I etʉk kʉn, en enim nga ku moni nimbʉ tʉk, Got nga rapa tenda wamp mbʉ nga rʉp wu mbʉ nguimin nʉk, Barnapas kʉn Sol raⱡ nguⱡngina, mek pukʉⱡ, rup wu mbʉ ngurʉnggil. ");
INSERT INTO med_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ui ei kʉn, king Erot ndi Got nga rapa tenda wamp mbʉ minal, mbun mindil mbʉ tʉpa ngurum. ");
INSERT INTO med_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wu Jon ʉngʉn Jeims ni, Erot ndi, koiya ei ndi ropa, peng ei puⱡa rurum. ");
INSERT INTO med_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Uⱡ itim ei nga, Jura wamp mbʉ ndi kandʉk, numan nguⱡina, Pita imp moⱡpa, tʉpa kan ngurum. I etʉng uⱡ ei, Isrel wamp, bret yis mundi namʉndʉk normin ui ei. ");
INSERT INTO med_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita imp molk tʉk kʉn, kan manga ila tʉk pendʉtʉng ila, el wu mou tʉmbʉkak ei nga wu tʉmbʉkak ku, mou tenda ila mormin kʉⱡ ndi, Pita rʉp etʉng. Erot ndi, Jura wamp Pasopa rʉng normin ui ei pora nangga kʉn, Pita tʉp, wamp nga kuimp keta ila kot indimp nimba pitim. ");
INSERT INTO med_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ei nga, Pita ni, tʉk kan manga ila pendʉtʉng. Nila pepa murum ei kʉn, wote Got nga rapa tenda wamp nimbʉ ndi, Pita ni, Got ndi, tʉpa rʉpʉndangga nʉk, atinga ronduⱡ mundʉk rorung. ");
INSERT INTO med_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Utʉma orunga, Erot ndi, Pita kot endʉmba ei nga, akup rumbuldi ei mel ila, Pita ni, el wu raⱡ nga ruk ting ila pitim. Pita ni, kan sen ronduⱡ ralt ndi, kan ngʉk penduⱡina, kan manga keta puⱡ pʉⱡ rukʉr ui ila, el wu mat rʉp etʉk morung. ");
INSERT INTO med_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tʉngʉnda mint, Nuim ei nga anggelo ti, omba anggilinga, Pita pitim manga nila, rʉⱡang mam ti purum. Anggelo ni ndi, Pita nga pendʉk ila ambuⱡpa, ropa rut ndupa, nimba mel, “Tʉkrʉk oⱡa moⱡa!” nitim. I nilinga, tʉngʉnda mint, kan sen ronduⱡ nimbʉ, kuⱡimp ropa mana purum. ");
INSERT INTO med_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ni kʉn, anggelo ei ndi, kundpa nimba mel, “Nim nga muⱡ kan ei, tʉk gi ndukʉn ralkʉn, kʉmp rʉk kʉⱡ, tʉkʉn mundi!” nitim. Pita uⱡ mbʉ mel teng ndupa elinga, anggelo ni ndi, kundpa nimba mel, “Nim nga wal pʉki ekit orunga kʉⱡ pakʉkʉn, na kʉn ui!” nitim. ");
INSERT INTO med_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ni kʉn, Pita ni, anggelo ei pep ropa, kan manga ila omba, ekit purum. Pita elim anggelo ei ndi, itim uⱡ ei, pilpa kun iti nʉtʉtʉm. Ei nambuⱡ emel, elim ni, uⱡ mbʉ ur kʉmp mel etʉp, kant ku nimba pitim. ");
INSERT INTO med_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wote okʉⱡ, el wu rʉp kerʉng orunga rʉp etmin kona ei, wak rokʉⱡ, wote merʉng orunga rʉp etmin kona ei, wak rokʉⱡ okʉⱡ, kona peng ei nga paⱡa keta puⱡ pʉⱡ ronduⱡ ila, ekit purʉnggil. Kona ila ruk oⱡunggila, keta puⱡ pʉⱡ ei, elim ndi, kumba titim ila ok, ekit purʉnggil. Wote, anggelo ni ndi, Pita mepa, nombuⱡa ila mundpa, elim ni wei ai itim. ");
INSERT INTO med_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ni kʉn, Pita elim kʉn itim uⱡ nimbʉ, tʉpa mondpa, nimba mel, “Nuim ei ndi, elim nga anggelo ei, tʉpa munduⱡnga, King Erot kʉn, Jura wamp na mbʉ ndi, na kʉn uⱡ kit mbʉ itmin nʉk eng ila, na etpa tʉpa ekit ndunum. Ei, na akup pilip kun ent!” nitim. ");
INSERT INTO med_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Uⱡ itim kʉⱡ pilpa kʉn, wote Jon Mak mam, amp Mariya nga mang kona ila purum. Manga ila wamp minal tʉk tenda etʉk, atinga rok morung. ");
INSERT INTO med_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita omba, manga keta puⱡ pʉⱡ ila ropa gep nduⱡnga, kongun ambuⱡa ti mbi tek Rota, nʉtʉng ei ndi, kumba tʉmba urum. ");
INSERT INTO med_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","15","Omba pitim ei, Pita nga ik ei, pilpa mbi ndupa, numan ndi koⱡpa, kumba ti natʉpa, tʉkrʉpa kelpa int mba, wamp morung nimbʉ kundpa nimba mel, “Pita omba manga kumba keta puⱡ puⱡ ila morum!” nitim. Ni kʉn, wamp nimbʉ ndi, ambuⱡa ei kundʉk nʉk mel, “Nim kekilip roⱡnga nʉn ei?” nʉtʉng. Wote, ambuⱡa ni ndi, ronduⱡ mundpa, omba morum nilinga, wote wamp nimbʉ ndi, punt rok, nʉk mel, “Ei, elim nga anggelo ei, omba enim nda,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wote, Pita kumba ropa gep ndupa, moⱡmba ei nga moⱡnga, wote kumba tʉk kandrung mel, Pita murum ila kandʉk, min ngʉn mundrung. ");
INSERT INTO med_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wote, Pita elim nga ki ei, oⱡa ndupa, ik raka nʉk morung, “Elim Nuim ei ndi, kan mang ila tʉpa ekit ndurum uⱡ mbʉ mel, wamp mbʉ nimba ngurum. Ik nʉnt kʉⱡ, Jeims kʉn, tʉn nga mondpa pili wamp ʉngʉnʉl mbʉ pʉi, kundʉk nʉi!” nitim. Ni kʉn, elim wamp nimbʉ, wak ropa pena omba, elpa ronggʉt ku purum. ");
INSERT INTO med_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wote, mʉkʉlmʉ unt kona ranggʉⱡnga, kan manga ila el nde wu nimbʉ, Pita pi nʉpʉtʉm ila kandʉk, rut nʉk etpa, em mel nant nda nʉk, min ngʉn mundʉk morung. ");
INSERT INTO med_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erot ndi, Pita kuruk kandʉk, tʉi nitim. Ei wote, Pita kandʉk ti natʉtʉng. Ei nga, elim nga el wu mbʉ waldʉk pilik, wote rok kundʉi nitim. Ei mel etpa, Juriya kona ei, wak ropa, Sesariya kona ila ui mat muⱡimp nimba purum. ");
INSERT INTO med_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wote Erot ni, Taiya kʉn Sairon kona raⱡ ila nga wamp mbʉ kʉn, popʉⱡ mam ti mundrum ila wamp nimbʉ, tʉk rak nduk, Erot kʉning orung. Kuimp tek, wu mumuk ei, petʉm manga nokundrum wu Blastas kʉn, nʉk tʉk tenda etʉng. Wote, Erot kʉn numan tʉpa tenda mundamin nʉk, waldʉk pʉtʉng. Ei nambuⱡ emel, Taiya kʉn Sairon kona raⱡ nga wamp kʉⱡ ok, wu king ei nga kona ila rʉng tʉtʉng ei nga orung. ");
INSERT INTO med_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erot ndi, ui ti tou ropa pinditim nila, elim nga muⱡ kai mbʉ tʉpa raⱡpa omba, elim nga morum nde pol nila moⱡpa, ik ronduⱡ kai mat, wamp mbʉ kʉn nimba ngurum. ");
INSERT INTO med_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wote, wamp nimbʉ ndi, ke nʉk, “Ei wamp ti nga ik ti mon, got nga! Ik ti nʉmp pʉnmin,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ei kʉn, tʉngʉnda mint, Nuim ei nga anggelo ei ndi, Erot ropa kundrum. Ei nambuⱡ emel, Got tʉpa ou ndui nʉndrʉm ei nga, wu ni kimbuⱡa ⱡant mbʉ ndi, nok kondrung. ");
INSERT INTO med_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Uⱡ mbʉ pitim ku, wote Got nga ik kai ei, kona mbila tepa ndaip nimba purum. ");
INSERT INTO med_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnapas kʉn Sol raⱡ, Got nga kongun mbʉ, etkʉⱡ pora ndukʉⱡ, Jerusalem wak rokʉⱡ yant orʉnggil ila, Jon Mak kunda, tʉk mek orʉnggil. ");
INSERT INTO med_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiyok Got nga rapa tenda wamp mbʉ kʉn, ik mbo wu na, painui wu na mat morung. Wu mbʉ Barnapas kʉn, Simiyon, mbi ti tek ‘pombra’ nʉtmʉn. Ei kʉn, Siriya kona wu Lusiyus kʉn, wu Maniyan gapman nga wu ou Erot ni kʉn etʉk, ou endʉtʉng wu ei kʉn, Sol kʉn. ");
INSERT INTO med_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ei kʉn, wu kʉⱡ Nuim ei nga kongun endʉk, rʉng mowi pek moⱡina, Muⱡnga Wingti ei ndi, wu kʉⱡ kundpa, nimba mel, “Wu Barnapas, Sol raⱡ, mbi rok ekit tangina, na nga kongun itinggil nʉmp, wi rop tit, ei mel itinggil,” nitim. ");
INSERT INTO med_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wote, wu kʉⱡ rʉng mowi pek atinga rok molk, wu raⱡ nga peng ila ambulk pʉl nʉk tʉk, mundʉⱡina purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Muⱡnga Wingti ei ndi, Barnapas Sol raⱡ, Selusiya kona ila tʉpa mundrum. Kona ila pukʉⱡ molkʉⱡ, wote nu sip tʉkʉⱡ, Saipras kona ila purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Wote, Salamis ni kona ila ruk pukʉⱡ kʉn, Jura wamp nga atinga manga kel anggʉtʉm mbila, Got nga ik mbʉ, kundʉk nʉtʉnggil. Ei kʉn, wu Jon Mak ni, tʉpa rʉpʉndpa kongun itangga nʉkʉⱡ, tʉkʉⱡ mekʉⱡ purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wote wu kʉⱡ, Salamis mʉi ila kongun etʉk, andʉk pora nduk kʉn, wote Papos mʉi ila ok, ekit purung. Papos kona ila nga wu ti, kur atinga ropa, elim painui wu ti ku nitim ei, mbi tek, ‘Barapas,’ nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ni kʉn, Barapas ni, kona ila nga gapman nga wu kuimbal ei mbi tek, ‘Sergiyus Paulus,’ nʉtʉng, ei nga wu puⱡ ei murum. Gapman nga wu kuimbal ei ndi, Barnapas Sol raⱡ, elim kʉn wunggil nitim. Ei nambuⱡ emel, Got nga ik kai kʉⱡ, elim pilmba pilpa nitim. ");
INSERT INTO med_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wote, kur atinga rui wu (Grik ik ila ropʉl rok Elimas nʉtmin) ni ndi, wu raⱡ nga ik nʉtʉnggil mbila ropa akpa, itim. Ei nambuⱡ emel, gapman nga wu kuimbal ei, Got nga ik kupa kʉⱡ pilpa, ti nʉtangga nimba itim. ");
INSERT INTO med_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Wote, Sol mbi ti tek, Pol nʉtʉng ni, Muⱡnga Wingti ei ndi, ronduⱡ nguⱡnga, kur Elimas ni, wu ei kandpa, ronduⱡ mundpa, nimba mel, “Nim Seitan nga kangʉm ei! Nim uⱡ kai mbʉ nga pora el rui wu. Nim kʉn uⱡ kit mbʉ, peka ropa petʉm ei nga, rʉk rʉk Nuim ei nga uⱡ kupa mbʉ, nim ndi, etkʉn ge ndurʉn. ");
INSERT INTO med_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ei kʉn akup, Nuim ei nga ki ei ndi, nim rangga, nim mong ei, kit itangga, ant rʉⱡang ei, kʉni nʉkʉnana, rumbʉⱡ mat omba pangga!” nitim. Tʉngʉnda mint, Elimas pitim ei, kupa rumbʉⱡ mul kat omba, elim nga mong raⱡ, panda rurum ila, wamp morung kona mbila runum runaim etpa, wamp ti ndi, elim ki ʉmbʉⱡeing nimba ʉndrʉm. ");
INSERT INTO med_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wote, wu Sergiyus Paulus ni, Gapman nga wu kuimbal ni, uⱡ ei kandpa, Nuim ei nga ik mbo endʉtʉng ni pilpa, min ngʉn mundrum. ");
INSERT INTO med_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol kʉn elim nga rʉp wu kʉⱡ kʉn, Papos kona molk, nu sip tʉk puk, Pampiliya nga kona peng Purga nʉtʉng ila ekit purung. Kona ila, Jon Mak wu kʉⱡ, wak ropa Jerusalem int purum. ");
INSERT INTO med_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wu kʉⱡ, Purga kona ila molk, wote Pisiriya mʉi kona ila purung. Puk mowi kor ei, Andiyok kor kʉn, atinga manga kel ila murʉk puk, mana morung. ");
INSERT INTO med_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wote ila nga, Moses nga mi ik na, wote painui ik na mbʉ nga, kʉmp tʉk pora nduk moⱡʉngina, atinga manga kel nokundurmʉn wu mbʉ ndi, rung mundʉk nʉk mel, “Angmʉn, enim ndi wamp mbʉ, ndoimp rondʉk ik mat nimin nʉk, pilʉng ndam, nʉi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Wote, Pol ndi anggilpa, ki oⱡa ndupa, nimba mel, “Enim Isrel wamp mbʉ kʉn, wote wamp rʉⱡaip elpa mbʉ, Got nga mbi paka rondʉrmin mbʉ kʉn, na nga ik ei kum tʉiya! ");
INSERT INTO med_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tʉn Isrel wamp nga Got ei ndi, tʉn nga anda kouwʉmʉn mbʉ, mbi ropa tʉpa, Isip kona ila, nomba andrʉng wamp mbʉ kʉn, wamp rʉk tʉpa etpa mam inditim. Got nga ronduⱡ mam ei ndi, wamp mbʉ Isip kona ila, mepa ekit urum. ");
INSERT INTO med_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kona kui waka ila wamp mbʉ nga mbun koma ropa mepa oⱡnga, pana 40 itim. ");
INSERT INTO med_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wote, Keinen mʉi ila wamp rʉⱡaip tʉmbʉkak, gul raldika ropa mundpa, elim nga Isrel wamp mbʉ mʉi ei ngurum. ");
INSERT INTO med_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mʉi ila pek muⱡina, pana 450 omba purum. Pana ui kʉⱡ omba puⱡnga, wote Isrel wamp mbʉ, kʉmp ting wu mbʉ tʉpa mundrum. Molk puⱡina, painui wu Samuwel ni oⱡa urum. ");
INSERT INTO med_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Wote, wu king ti, kandʉk tʉk, ngui nʉk mawa elingina, wu Benjamin nga rʉⱡaip ila, wu Kis kangʉm Sol ni, tʉpa king monduⱡnga, moⱡnga pana 40 omba purum. ");
INSERT INTO med_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wote Got ndi, Sol tʉpa ekit ndupa, Depit tʉpa, Isrel wamp mbʉ nga king mundrum. Mondpa kʉn, Depit kʉn, nimba mel ‘Na wu Jesi kangʉm Depit kandʉp tʉnt wu ei, na numan ngur. Wu ei ndi, na nga pʉt uⱡ mbʉ mel, kapⱡa endʉmba,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Wu Depit nga pundun ila, Isrel wamp nga Etpa Ti Wu ei, Jisas oⱡa omba nimba, Got ndi unt, nimba mʉi rurum. ");
INSERT INTO med_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisas ni, kongun iti natilinga kʉn, Jon ndi, Isrel wamp mbʉ pora numan ropʉl rok, nu tʉi nimba ik mbo inditim. ");
INSERT INTO med_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wote, Jon elim kongun etpa pora ndupa ei kʉn, wamp mbʉ waldpa, nimba mel, ‘Enim ndi, na nam nʉk pʉnmʉn? Enim nga nokundʉk mormin wu ei, na mon! Ei kʉn, kum tʉiya! Na nga mbuldung orunga omba wu ei, na ndi, wu ei nga kʉmp rʉk kʉⱡ, na wu kai ti mon! Ei nga, na kapⱡa pʉtimp mel mon,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Na nga Isrel wamp angmʉn mbʉ, wote Aparam nga wamp pundun mbʉ kʉn, wote wamp rʉⱡaip elpa, Got nga mbi paka rondʉnmin mbʉ kʉn pora, etpa ti uⱡ ei nga, rʉnang ik kai ei, tʉn kʉn tʉpa mundrum. ");
INSERT INTO med_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wote, Jerusalem wamp mbʉ kʉn, en enim nga rʉp wu mbʉ kʉn pʉi, Etpa Ti Wu ei, kandʉk mbi ndui nandrʉng. Omba, painui wu mbʉ nga pai nʉk, mon rorung ik mbʉ, mowi kor mbʉ kʉn, rʉk rʉk kʉmp rormin ik mbʉ nga puⱡ mbʉ kep, pilik kun iti natʉtʉng. Wote, Jisas kot endʉk, etʉng uⱡ mbʉ ndi, painui wu mbʉ nga pai nok nʉtʉng ik mbʉ, omba kupa itim. ");
INSERT INTO med_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wu ei, rok kunding ei nga puⱡ ti, kandʉk ti natʉtʉng. Ei wote, Pailot waldʉk, wu ei, rop kundamin nʉkʉn, ni nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Wote, Buk Wingti ila, pai nok mon rorung uⱡ mbʉ mel etʉk, kapⱡa endʉk kʉn, nde peta ila mana tʉk, on kona ila tetʉng. ");
INSERT INTO med_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","31","Wote on kona ila, Got ndi, Jisas ni ⱡoporpa tʉpa kont monduⱡnga, unt rumbʉⱡ mat ou ndupa, elim kʉn rʉp rok, Galili kona ila molk puk, Jerusalem purung wu mbʉ ndi, kandrung. Wu kʉⱡ ndi, akup elim nga ik ei nʉk, tʉk pena ila pendʉtmʉn. ");
INSERT INTO med_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Tʉn ndi, akup Rʉnang Ik Kai ei, enim nimbun nguimin. Ei kʉn, Got ndi, Jisas ⱡoporpa tʉpa mundrum uⱡ ei ndi, tʉn nga anda kouwʉmʉn kʉⱡ kʉn, nimba mʉi rurum uⱡ ei, tʉn wamp pundun kʉⱡ, etpa kupa inditim. Uⱡ ei, Buk Sam 2 ila nimba mel, ‘Nim na nga kangʉm, akup ei kʉn, na nim nga Tipanʉm rundi,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wote Got ndi, kangʉm on kona ila puri nʉpʉrangga nimba, ⱡoporpa tʉpa kont mondʉmba ei nga ik ti, nimba mel, ‘Na ndi, unt Depit kʉn nʉmp, mʉi rop nguimp nit memp ronduⱡ wingti mbʉ, akup nim kʉn nguimp,’ nitim. ");
INSERT INTO med_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ei nga aldpa, Buk Sam ila nimba mel, ‘Nim nga Wu Wingti ei, on kona ila pepa purangga nʉkʉn, wak rui nʉri!’ nitim. ");
INSERT INTO med_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ni kʉn, tʉn pʉtmʉn ni, king Depit ndi, Got nga numan pitim ei mel, wamp mbʉ kʉn, kongun mbʉ pep ropa itim. Wote koⱡnga kʉn, tʉk elim nga anda kouwʉmʉn mbʉ, tetʉng on kona ila telingina, tepa pururum. ");
INSERT INTO med_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wote Got ndi, Jisas ni, on kona ila ⱡoporpa kont mundrum wu ei, on kona ila tepa puri nʉpʉrʉm mon! ");
INSERT INTO med_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ei kʉn, Isrel wamp angmʉn mbʉ, pilik kun itʉi! Jisas nga mbi ila, uⱡ kit pendpa kili uⱡ ei nga Rʉnang Ik Kai ei, enim kʉn mbo endinmʉn. ");
INSERT INTO med_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses nga mi ik kʉⱡ ndi, tʉn etpa tʉpa, wamp kun kai ni nʉndʉtʉm. Wote ya wu ei, mondʉk pʉtmʉn wamp mbʉ, wamp kun kai nʉtʉm. ");
INSERT INTO med_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ei kʉn, enim tʉk mendʉk muⱡʉi! Unt, ik painui wu kʉⱡ nga ik nʉtʉng uⱡ kʉⱡ, enim kʉn omba iti nʉtangga! ");
INSERT INTO med_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Buk Wingti ei ndi, nimba mel, ‘Enim Got nga ik mbʉ nʉk, kit mondurmin wamp mbʉ, enim andʉk kuⱡing! Ei nambuⱡ emel, na ndi, enim nga ui ila, uⱡ ti itimp ei, wamp ti ndi, enim kʉn it mat nin ndam, uⱡ ei nga puⱡ ei, enim ndi, kapⱡa mondʉk pili nʉpiling!’” nitim. ");
INSERT INTO med_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wote, Pol Barnapas raⱡ, ik mbo endkʉⱡ pora ndukʉⱡ, atinga manga kel ni, wak rokʉⱡ pinggil elinggila, wote wamp morung nimbʉ ndi, aldpa mowi kor ti kʉn ok, ik mbʉ nga mat nʉnggil ku nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wamp morung nimbʉ, elpa elpa puⱡʉngina mel, wamp minal kʉn, wamp rʉⱡaip elpa mat, Jura nga uⱡ etmin mbila kʉn ok, Pol kʉn Barnapas raⱡ kʉn, rʉp rorung. Wu raⱡ ndi, wamp mbʉ kʉn, Got nga wamp poⱡ ti uⱡ ila, ronduⱡ mundʉk pek muⱡʉi, nʉk man ngorʉnggil. ");
INSERT INTO med_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wote, merʉng mowi kor ti kʉn, kona peng ila petmin wamp mbʉ pora, Got ei nga ik ei, pilmin nʉk ruk orung. ");
INSERT INTO med_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ui ei kʉn, amp mam ti orung ni, Jura wu mbʉ kandʉk, munt mi telinga, popʉⱡ kulk, Pol nga ik nitim nimbʉ, rok mana nduk, ik mbuldung orunga nʉndʉk etʉng. ");
INSERT INTO med_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Uⱡ ei mel etʉng ila, wote Pol, Barnapas raⱡ, ronduⱡ mundʉk, punt rok, nʉkʉⱡ mel, “Got nga ik mong ei, enim kuimp tep kundʉp nimbuⱡ. Ei nga wote, en enim ndi, uⱡ nga kʉnt nga kont uⱡ ei, mi ronmin kant ei kʉn, enim wak ropʉn wamp kʉⱡ rʉⱡaip elpa ik ei, kundʉp ninimbʉⱡ. ");
INSERT INTO med_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nuim ei ndi, tʉn mi ik ei, Buk Wingti ei ndi, ei mel nimba ngurum, ‘Na ndi, enim wamp rʉⱡaip elpa kʉⱡ nga rʉⱡang ei mondunt, ei mel molkʉn, muⱡ kʉmp mbila, Got nga wamp etpa ti uⱡ ei nga, nʉkʉn mekʉn pi!’” nitim. ");
INSERT INTO med_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wote, wamp rʉⱡaip elpa ok morung nimbʉ, ik kʉⱡ pilik numan ngʉk, Nuim ei nga ik kʉⱡ mbi paka rondrung. Wote, uⱡ nga kʉnt nga kont uⱡ ting wamp mbʉ, kʉmp ropa titim mat ila ok, morung nimbʉ, Got kʉn mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nuim ei nga ik ei, kona mbila, ndaip nimba purum. ");
INSERT INTO med_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wote, Jura wu nimbʉ ndi, kona peng ila nga rʉp wu nimbʉ kʉn, rʉⱡaip elpa amp mbi mul mbʉ, Got nga mbi paka rondurmun wamp nimbʉ, kunt roⱡungina, Pol Barnapas raⱡ kʉn, nʉk kit mondʉk, enim nga mʉi ila muⱡi nʉmbʉⱡʉnggil mon nʉk, rok makrʉk mundrung. ");
INSERT INTO med_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ni kʉn, wu raⱡ en enmbilinga, kʉmp kʉnggʉpʉn nimbʉ, kona ila ndanda ndukʉⱡ, mundkʉⱡ. I etʉk pendkʉⱡ, Andiyok kona ni wak rokʉⱡ, Aikoniyum kona ila purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wote, Andiyok kona ila kitip kʉni wamp nimbʉ, Muⱡnga Wingti ei ndi, peka roⱡnga, numan kai pilik, ambulk palk morung. ");
INSERT INTO med_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aikoniyum kona ila uⱡ tenda ei ku etʉnggil, Pol Barnapas raⱡ, atinga manga kel ila etʉnggil, ni mel mukʉr pukʉⱡ, Got nga ik puⱡ mbʉ nʉk kai monduⱡunggila, Jura wamp na, wamp rʉⱡaip elpa na, Got kʉn mondʉk pʉtʉng. Wamp rʉⱡaip elpa minal ik pilik, tʉk mondʉk pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wote, Jura wamp mat, mondʉk pili napʉtʉng nimbʉ ndi, wamp rʉⱡaip elpa mbʉ kunt roⱡungina, wu ni raⱡ etʉk, numan kit pendʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ni kʉn, Pol kʉn Barnapas raⱡ ila molkʉⱡ, ui roⱡ etʉk tʉk mundkʉⱡ, Nuim ei nga ik ronduⱡ mundkʉⱡ nʉtʉnggil. I elinggila kʉn, Nuim ndi, elim ei nga wamp poⱡ ti uⱡ ei, kupa nimba, wu raⱡ ronduⱡ nguⱡnga, uⱡ rʉpndi min ngʉn pi mbʉ etʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","I elinggila, kona peng ila wamp nimbʉ palk, orung orung etʉk, wamp mat puk, Jura wamp mbʉ kʉn kup etʉng, wote wamp mat, wu raⱡ kʉn kup etʉng. ");
INSERT INTO med_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ni kʉn, wamp rʉⱡaip elpa mbʉ kʉn, wote Jura wamp mbʉ kʉn, enim nga rʉp wu mbʉ kʉn, nʉk pendʉk, wu ni raⱡ, ku ndi rop kundamin nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Wote, wu raⱡ uⱡ ei tʉk mundkʉⱡ, nung nʉkʉⱡ, Laikoniya kona ei nga kona peng ou, Derpi kʉn, Listra raⱡ ila kʉn, wote mʉi kʉmp ila nga nondpa titim mbila purʉnggil. Kona mbila, Rʉnang Ik Kai ei, wamp mbʉ kundʉk nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra kona ila, elkʉna rumbrʉm wu ti murum. Wu ei, mam ndi, mitim ui ei kʉn i elinga, nombuⱡa mam ʉndi nʉndrʉm. ");
INSERT INTO med_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wu ei ndi, kona ila moⱡpa, Pol nga ik nitim ni, kum tepa murum. Pol ndi, wu ei, mong ronduⱡ kandpa kundrum ei, wu ei nga mondpa pili ei, ronduⱡ purum. Uⱡ ei ndi, elim nga kʉmp kit murum ei omba, kai etmba nimba pitim. ");
INSERT INTO med_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Wote Pol ndi, ik oⱡa ndupa, nimba mel, “Nim oⱡa molkʉn kʉmp kambila,” nitim. I nilinga, tʉngʉnda mint wu ni, oⱡa moⱡpa, kʉmp kambilpa purum. ");
INSERT INTO med_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wamp rʉⱡaip mam ti, Pol itim uⱡ ni kandʉk, enim nga Laikoniya ik ila ronduⱡ wi rok, nʉk mel, “Tʉn nga got nʉtmʉn nimbʉ, mʉi kona ila mana ok, akup wamp mel ralk, tʉn kʉn ong,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wamp mbʉ ndi, Barnapas mbi tek, Sus nʉk, wote Pol ik puⱡ pendpa nitim ei nga mbi tek, Ermis nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ei kʉn, Sus got ei nga manga wingti ou ei, kona ila nondpa ʉnggʉtʉm. Ei nga, wu pris kona ila morum ei ndi mba, kng kau pela mat kʉn, plawa kuk mat kʉn ranggʉpa, ot ropa mepa omba, kona peng ou ei nga keta puⱡ puⱡ nila urum. Ei nambuⱡ emel, wamp mbʉ kʉn elim kʉn, nombuⱡa rʉng wu raⱡ got nʉk pilik mel mbʉ, kaⱡʉp tindiⱡim mundmin nʉk etʉng. ");
INSERT INTO med_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Wote, Pol kʉn Barnapas raⱡ, wamp uⱡ iting pilik etʉng ni pilkʉⱡ kʉn, en enmbil nga muⱡ mbal nimbʉ, ambulk ondkʉⱡ, wamp mou morung nila, tʉkrʉk pukʉⱡ, wi rokʉⱡ, nʉkʉⱡ mel, “Enim wu mat ndi, uⱡ ei nambuⱡ emel enmin? Tʉl enim wamp mormin ei mel ku, kapⱡa mormbʉⱡ ei ka! Tʉl enim kʉn, Rʉnang Ik Kai ei, nʉmp nguimbil! Ei ndi, enim etpa rukʉr tangga, uⱡ kurpa enmin mbʉ, tʉk mbuⱡ ngʉk, Got kont morum, muⱡ mʉi na, num kuta kʉn mel kʉⱡ nga, rukrʉng orunga tetʉm mbʉ nga Puⱡ Wu Got, ei kʉn rukʉr peing! ");
INSERT INTO med_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Unt kor nga ei kʉn, Got ndi, wamp mbʉ kandpa kont elinga, en enim nga numan pʉtmʉn mbʉ mel pep rok andʉrmʉn. ");
INSERT INTO med_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wote, Got elim ni, pili nʉpileing nimba mba, mo rui nʉrʉrʉm. Tʉn wamp mbʉ kʉn, uⱡ kai mbʉ etpa, muⱡ kona ila mana nduⱡnga, enim kʉn orung oⱡnga, rʉng kai mbʉ oⱡa orum. Wote rʉng mbʉ, kapⱡa etpa nguⱡnga, enim numan ngʉk ambulk parmin,” nitim. ");
INSERT INTO med_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wu ni raⱡ, ik mbʉ nʉtʉnggil ku. Ei wote, wamp rʉⱡaip mam ni, en enim nga mel mbʉ, kaⱡʉp tindiⱡim mundmin nʉk pek kont etʉng. ");
INSERT INTO med_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wote, Andiyok kʉn Aikoniyum kona raⱡ nga Jura wamp mat ok, wamp morung nimbʉ nga mat nga numan orunga kunt rok nilingina, Pol ku ndi rok, wote konum nʉk pilik, kunt kundi mek, kona peng ei nga, ekit orunga purung. ");
INSERT INTO med_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kurum nʉk pʉtʉng ni, wote, mondpa pili wamp nimbʉ ndi, tʉk pok elingina, Pol ni, oⱡa moⱡpa, kona peng ila aldpa rukʉr purum. Wote utʉma orunga, elim kʉn Barnapas raⱡ, Derpi kona ila purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol, Barnapas raⱡ, Derpi kona ila, Rʉnang Ik Kai ei nilinggila, kitip kʉni wamp minal rukʉr orung. Wote aldpa, Listra, Aikoniyum, Andiyok kona kʉⱡ ila int purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kona kʉⱡ ila pukʉⱡ, mondpa pili wamp mbʉ, nʉkʉⱡ ronduⱡ mundkʉⱡ, man ngukʉⱡ, en enim nga mondpa pili ei, ronduⱡ mundʉk, tek muⱡʉi nʉkʉⱡ mel, “Tʉn mbun mindil mbʉ tʉpʉn, wote Got nga wamp tʉpa mumuk rui uⱡ ila rukʉr mbin,” nʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol Barnapas wu raⱡ ndi, Got nga rapa tenda ila wamp elpa elpa titim mbila, rʉp wu mbʉ tʉk mondkʉⱡ. Wote, en enmbil rʉng mowi pekʉⱡ, atinga rokʉⱡ, Nuim ei kun mondʉk pʉtʉng rʉp wu nimbʉ tʉkʉⱡ, Nuim ei nga ki ila tendʉtʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Wote, Pisiriya kona ila andʉk, uⱡ pora ndukʉⱡ kʉn, Pampiliya kona ila orʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wote, kona ila pukʉⱡ, Purga kona peng ila Rʉnang Ik Kai ei, nʉk ngukʉⱡ, wote Ataliya kona peng ila mana purʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Wote, Ataliya molkʉⱡ kʉn, nu sip tʉkʉⱡ, Andiyok int purʉnggil. Kona ila nga wu raⱡ, Got nga wamp poⱡ ti uⱡ ila, Got ndi, rukʉr tʉpa, kongun itinggil nitim ei mel, akup etʉk pora ndukʉⱡ, rukʉr orʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wu ni raⱡ, Andiyok ruk okʉⱡ kʉn, Got nga rapa tenda wamp nimbʉ tʉk mou rokʉⱡ, Got ndi, en enmbil kongun ila tʉpa rʉpʉndrʉm ei nga puⱡ ei, nʉk mot ndukʉⱡ, wote wamp rʉⱡaip elpa mondʉk pileing nimba, Got ndi, kumba tʉpa titim uⱡ mbʉ mel, timan rok ngorʉnggil. ");
INSERT INTO med_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wote, kona ila nga kitip kʉni wamp mbʉ kʉn, rʉp rok moⱡina, ui minal omba purum. ");
INSERT INTO med_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wote, Juriya kona ila wu mat, Andiyok kona ila mana ok, mondpa pili wamp ʉngʉnʉl nimbʉ, ik mbo endʉk, nʉk mel, “Enim Moses nga mi ik ila, kʉng kuptʉi nʉtʉm ei mel iti natʉng ndam, Got ndi, enim etpa rukʉr ti natʉmba,” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","I nʉtʉng uⱡ ila, Pol kʉn, Barnapas raⱡ, ik ei pilkʉⱡ, popʉⱡ kulkʉⱡ, wu kʉⱡ kʉn ik palk, ik mura mel mam ti etʉng. Ei kʉn, Pol, Barnapas raⱡ kʉn, Andiyok kona ila mondpa pili wamp mat kapⱡa to rok, Jerusalem oⱡa puk, nombuⱡa rung wu kʉⱡ kʉn, rʉp wu mbʉ kʉn, ik ei nga nʉk tʉk, kun iteing pʉi nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Got nga rapa tenda wamp kʉⱡ ndi, wu kʉⱡ tʉk munduⱡina purung. Wote wu kʉⱡ puk, Ponisiya kʉn Sameriya kona mbʉ nga rʉk ila puk, wamp rʉⱡaip elpa numan ropʉl rok, Got kʉn rukʉr orung mbʉ mel, timan rok ngurung. Ik mbʉ timan rok, wamp morung mbʉ nʉk ngʉⱡʉngina, mondpa pili wamp ʉngʉnʉl morung nimbʉ, numan kai pʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem ruk puⱡina, rʉp wu na, nombuⱡa rung wu na, wote Got nga rapa tenda wamp na mbʉ ndi molk, rawe etʉk tʉtʉng. Wote kona ila nga, Got ndi, en enim kʉn kongun itim uⱡ mbʉ mel timan rok, wamp mbʉ ngorʉnggil. ");
INSERT INTO med_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wote, mondpa pili wamp mat, wu Perisi kʉⱡ nga rʉⱡaip ila morung kʉⱡ ndi, oⱡa anggilik nʉk mel, “Enim ndi, wamp rʉⱡaip elpa kʉⱡ, kʉng kuptʉi nʉk, wote Moses nga mi ik kʉⱡ, pep reing mint, nʉk mbo indʉi!” nʉtʉng. ");
INSERT INTO med_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ik ei nga, nombuⱡa rung wu mbʉ kʉn, rʉp wu na mbʉ kʉn, nʉmp tʉp kun mundmin nʉk mou rorung. ");
INSERT INTO med_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ik minal nʉk pora nduk, Pita ndi, oⱡa anggilpa nimba mel, “Wamp angmʉn! Enim pʉnmin ei, unt kor nga Got ndi, enim nga ruk ting ila, na mbi ropa tʉpa, elim nga Rʉnang Ik Kai ei, wamp rʉⱡaip elpa mbʉ, nʉmp nguⱡmba, wamp mbʉ ik ei pilik tʉk, elim kʉn mondʉk pileing nimba, na rukʉr titim. ");
INSERT INTO med_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wote, Got tʉn nga numan mbʉ pora, kandrum wu ei ndi, wamp rʉⱡaip elpa mbʉ, elim nga ku nimba, Muⱡnga Wingti ei, tʉn ngurum ni mel wamp mbʉ ngurum. ");
INSERT INTO med_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Got ndi, tʉn Jura wamp mbʉ kʉn, wote wamp rʉⱡaip elpa mbʉ kʉn, ruk ila oi kan ti, etpa pindi napʉndʉtʉm. Wote, wamp mbʉ nga mondʉk pʉtʉng uⱡ ei ndi, en enim nga numan mbo ei, etpa piral ndurum. ");
INSERT INTO med_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Uⱡ ei ndi, Got oⱡa tʉk kanmin ek ka! Ei nga wote, enim ndi, uⱡ mbun iti ei, Got nga rapa tenda wamp kʉⱡ kʉn koma rondunmʉn. Tʉn kep, tʉn nga anda kouwʉmʉn mbʉ kep, mbun ei mel ti, kapⱡa koma rui nʉrʉmʉn. ");
INSERT INTO med_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ei mon! Tʉn mondʉp pilamina, Nuim Jisas nga wamp poⱡ ti uⱡ ila, tʉn etpa titim ei mel, wamp rʉⱡaip elpa kʉⱡ, Got nga wamp poⱡ ti uⱡ ila, i ku etpa tʉmba,” nitim. ");
INSERT INTO med_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wote, Pol Barnapas raⱡ, kongun etʉk andrʉnggil ruk ting ila, Got ndi, uⱡ rʉpndi mat, wamp rʉⱡaip elpa mbʉ kʉn, itim nimbʉ mel timan rokʉⱡ, wamp mbʉ kundʉk nilinggila, wamp mbʉ pilik raka nʉk morung. ");
INSERT INTO med_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wote wu raⱡ, ik nʉkʉⱡ pora nduⱡunggila, Jeims ndi, oⱡa ndupa, nimba mel, “Angmʉn! Na ik nimp ent ei, kum tek pilʉiya!