﻿USE sofia;
DROP TABLE IF EXISTS sofia.mdyeth_vpl;
CREATE TABLE mdyeth_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mdyeth_vpl WRITE;
INSERT INTO mdyeth_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ቤርታዺ ፆኦሲ ጫሪንቺና ሳዓና ዔኤቢ ባኣያይዳፓ ማዤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ዬኖ ዎዶና ሳዖኮ ሃማኬ ጌዒ ዔርታ ባኣዚ ባኣያ፤ ሃሣ ፔቴታዖ ዒዞይዳ ዓኣ ባኣዚያ ባኣያኬ፥ ሚርጌና ዔቴ ማዔ ዼኤፖ ዒጊቻ ዋኣፆ ዑፆይዳ ሻኔ ዹሚ ዓኣኔ፤ ፆኦሲኮዋ ዓያና ዋኣፆ ዑፆይዳ ሴካ ሃንጋ ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ዬካፓ ፆኦሲ «ፖዒ ፖዖንጎ» ጌዒ ዓይሣዛ ፖዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ፆኦሲ ፖዒ ዛጋዖ ዒ ማዤ ባኮና ዎዛዼኔ፤ ዬካፓ ፆኦሲ ፖዒ ዹሚፓ ዱማሲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ፖዖ «ሮኦሪ» ጌዒ፥ ሃሣ ዹሞዋ «ዋንቴ» ጌዔኔ። ሳዓ ዓሚ ካሬኔ፤ ዬና ፔታሳ ቤርታሲ ኬሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ዬካፓ ፆኦሲ «ዋኣፆ ዋኣፆይዳፓ ፓቂ ቃዛያ ሳዖኮ ዑፆይዳ ሌካ ዼጌ ቤሲ ማዖንጎ» ጌዒ ዓይሣዛ ማዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ፆኦሲ ዬያይዲ ሌካ ዼጌ ዋኣፆኮ ሳዛ ጉሪ ቤሲ ማዤኔ፤ ዬካፓ ፆኦሲ «ዬኖ ጉሮ ቤዞኮ ዴማ ዓኣ ዋኣፆና ዑፃ ዓኣሢና ፓቂንቶንጎ» ጌዔኔ፤ ዒዚ ጌዔሢጉዴያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ፆኦሲ ዬኖ ሳዖኮ ዑፃ ዼጊ ጌዔ ጉሮ ቤዞ «ጫሪንቺ» ጌዔኔ። ሳዓ ዓሚ ካሬኔ፤ ላምዓሳ ኬሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ዬካፓ ፆኦሲ ፃኣዺ ዓጪ ፔጋዺ ጴዻንዳጉዲ ጫሪንጮኮ ዴማ ዓኣ ዋኣፆ «ፔቴ ቤስካ ዴዖም» ጌዔኔ፤ ዒዚ ጌዔሢጉዴያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ፆኦሲ ፃኣዾ ዓጮ «ሳዓ» ጌዒ፥ ሃሣ ፔቴ ቤዛ ዴዒ ዓኣ ዋኣፆ «ዼኤፒ ባዚ» ጌዔኔ፤ ፆኦሲ ዬያ ዛጋዖ ማዤ ባኮና ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ዬካፓ ፆኦሲ «ሳዓ ቱኮ ሚሢንታ ሃኣኮ ዜርሢ ጉቤ፤ ሃሣ ዓኣፒ ዓኣፓ ሚሢ ዱማ ዱማ ባቃልሶንጎ» ጌዒ ዓይሣዛ፥ ዒዚ ጌዔሢጎይፆ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ዬያ ጎይፆና ሳዓ ቢያ ባኮ ባቃልሴም፥ ፆኦሲ ዬያ ዛጋዖ ማዤ ባኮና ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ሳዓ ዓሚ ካሬኔ፤ ሃይሣሳ ኬሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ዬካፓ ፆኦሲ «ሮኦሮ ዋንታፓ ዱማሳኒ ዱማ ዱማ ፖዒ ጫሪንጮይዳ ማዖንጎ፤ ዱማ ዱማ ኬሎንታ፥ ሌዖንታ ሌዖይዳ ዓኣ ዱማ ዱማ ዎዳኣ ዓርቃ ዎዶ ዱማሲ ዔርዛ ማላታ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ሳዖም ፖዓኒ ጫሪንጫ ማዒ ፖዖንጎ» ጌዒ ዓይሣዛ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ዬያይዲ ፆኦሲ ላምዖ ዼኤፒ ፖዒ ዔኤቢ ባኣያይዳፓ ማዤኔ፤ ፑኡፒ ፖዒ ፖዓ ዓቢ ሮኦሪ ፖዓንዳጉዲ፥ ሃሣ ጊንሣ ዻካ ፖዒ ፖዓ ዓጊኒ ዋንታ ፖዓንዳጉዲ ማሃዖ ዬያጉዲ ሃሣ ዦኦጎዋ ማዤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ዬንሢ ፖዖንሢ ጫሪንጫ ዴዓንዳጉዲ ጌሤኔ፤ ዬያ ዒ ማዼሢ ሳዖም ፖዒ ፖዓንዳጉዲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ሮኦሪና ዹሚናይዳ ፖዓንዳጉዲና ዹሚ ፖዒዳፓ ዱማሳንዳጉዴያኬ። ፆኦሲ ዬያ ዛጋዖ ማዤ ባኮና ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ሳዓ ዓሚ ካሬኔ፤ ዖይዳሳ ኬሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ዬካፓ ፆኦሲ «ዋኣሢዳ ዱማ ዱማ ሼምፖና ዓኣ ማዢንቲ ዺቢ ዓኣያ ማዖንጎ፤ ካፒያ ሳዖኮ ዑፃ ጫሪንጮይዳ ባራኖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ዬያይዲ ፆኦሲ ፑኡፒ ፑኡፒ ባዚ ቦዖንታ ሜሌ ዋኣፆይዳ ናንጋያና ዓጊፃ ዱማ ዱማ ማዢንቲ፤ ሃሣ ዱማ ዱማ ካፖዋ ዔኤቢ ባኣያይዳፓ ማዤኔ። ፆኦሲ ዬያ ዛጋዖ ማዤ ባኮና ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ፆኦሲ ዔያቶ «ሾይ ሚርጉዋቴ፤ ዜርፃ ዒንሢኮ ባዞ ዋኣፆ ኩሞንጎ፤ ካፓኣ ሳዖይዳ ሚርጎንጎ» ጌዒ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ሳዓ ዓሚ ካሬኔ፤ ዶንጋሳ ኬሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ዬካፓ ፆኦሲ፦ «ሳዓ ዱማ ዱማ ማዔ ሼምፓ ዓኣ ማዢንቲ ጌይፃ ዱማ ዱማ ቆሎንታ፥ ዻካንታ ዼኤፒንታ ማዔ ካይዚ ቦዖ ማዢንቲያ ጴዺሶንጎ» ጌዒ ዓይሣዛ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ፆኦሲ ዬያይዲ ሼምፓ ዓኣ ማዢንቶ ቢያ ማዤኔ፤ ዒዚ ዬያ ዛጋዖ ማዤ ባኮና ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ዬካፓ ፆኦሲ፦ «ዓሲ ኑኡኒ ኑ ማሎና፥ ኑና ማላያ ዔኤቢ ባኣያይዳፓ ማዦም፤ ዬንሢ ዓሶንሢኮ ባዞይዳ ናንጋ ሞላሢ ዑፃ፥ ጫሪንጮ ካፖ ዑፃ፥ ቆሎንታ ካዮ ቦዖ ዻኮንታ ዼኤፖንታ ዑፃ፤ ሃሣ ዬያጉዲ ሳዖ ቢያይዳ ቢታንቶ ዓኣያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ፆኦሲ ዬያይዲ ዓሲ ማዤኔ፤ ፔ ማሎና ፔና ማላያ፥ ዓቲንቄና ላኣሊና ማሂ ማዤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ፆኦሲያ ዓሲ «ሾይ ሚርጉዋቴ፥ ፃጳ ዒንሢኮ ሳዖ ኩሞንጎ፤ ሳዓኣ ዒንሢ ቢታንቶኮ ዴማ ማዖንጎ፤ ባዞይዳ ናንጋ ሞላሢ ዑፃ፥ ጫሪንጫ ባራና ካፖና ሳዖይዳ ዓጊፂ ሃንታ ሼምፖና ዓኣ ባኮ ቢያ ዑፃ ዒንሢኮ ቢታንቶ ዓኣያ ማዖንጎ» ጌዒ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ፆኦሲ ዔያቶም ኬኤዛዖ፦ «ሙኡዚ ዒንሢም ማዓንዳጉዲ ሳዖይዳ ጴዻ ሃኣኮንታ ዓኣፒ ዓኣፓ ሚሢንታ ታኣኒ ዒንሢም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ሃሣ ዬያጉዲ ቆሎንታ ካዮ ቦዖንታም፥ ጫሪንጫ ባራና ካፖንታ ሳዖይዳ ዓጊፃ ሼምፓ ዓኣ ማዢንቶንታ ዑኡሲ ዔካ ሼምፔና ዓኣ ማዢንቲም ቢያ ሙኡዚ ማዓንዳጉዲ ዓኣዔ ማኣቲና ዒላሺና ታኣኒ ዒንጌኔ» ጌዔኔ፤ ዬይያ ዒዚ ጌዔ ጎይፆ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ፆኦሲ ማዤ ባኮ ቢያ ዛጋዖ፥ ዑሣ ዓኣዼ ዎዛዼኔ። ሳዓ ዓሚ ካሬኔ፤ ላሃሳ ኬሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ጫሪንጮና ሳዖና፤ ሃሣ ዔያቶይዳ ዓኣ ባኮኮ ቢያ ማዢንቲፃ ያዒዲ ጋፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ፆኦሲ ላሃሳ ኬሎና ማዾ ቢያ ጋፒሲ ላንካሳ ኬሎ ማዾ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ፆኦሲ ማዢፆ ማዾ ቢያ ሃሼ ኬላ ዒማና ማዔሢሮ ላንካሳ ኬሎ ዓንጂ ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ዬያሮ ጫሪንጮና ሳዖና ዔኤቢ ባኣያይዳፓ ማዢንቴ ዎዶና ማዢንቶ ሃይሳ ያዺኬ። ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ጫሪንጮና ሳዖና ማዤ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ሳዖይዳ ዒርዚ ዋርቂሲባኣያ ማዔም፤ ሃሣ ሳዖዋ ጎሽካ ዓሲ ባኣሢሮ ሳዖይዳ ፔቴታዖ ባቃሊ ዓኣ ባኣዚ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ያዒ ማዔቶዋ ሳዖይዳፓ ቱሮ ዓልቃ ዋኣሢ ፃኣዾ ሳዖ ቢያ ዑሻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ሳዖ ዓጮይዳፓ ዔኪ ዓሲ ዓጪና ማዤኔ፤ ሲኢዾና ናንጊ ዒንጋ ዑኡሲ ዑኡዜኔ፤ ዓሲያ ሼምፖና ናንጋ ማዢንቲ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዓቦኮ ኬዞ ዛሎና ዔዴኔ ጌይንታ ኮሺ ቤሲ፥ ዱማ ዱማ ባቃላ ሚሢ ዓኣ ቤሲ ማሂ ኮሼኔ፤ ዒዚ ማዤ ዓሢያ ዒኢካ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ዬኖ ቤዜሎይዳ ዛጋዛ ዎዛሳያና ዓሲም ሙኡዚ ማዓንዳ ዱማ ዱማ ሚሢ ባቃላንዳጉዲ ማሄኔ፤ ጊንሣ ዬያ ዱማ ዱማ ባቃሌ ሚፆኮ ባኣኮይዳ ናንጊ ዒንጋ ሚሢ ዓኣኔ፤ ዬያጉዴያ ሃሣ ኮዦ ፑርታይዳፓ ዱማሳንዳጉዲ ማሃ፥ ዔራቶ ዒንጋ ሜሌ ሚሢያ ዒኢካ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ዬኖ ዱማ ዱማ ሚፃ ባቃሌ ቤዜሎ ዑሻ ዼኤፒ ዓልቃ ዎርዚ ዔዴኔ ጌይንታ ቤዛፓ ዎታኔ፤ ዬይ ዎራሢ ዔዴኔይዳፓ ኬስካዖ ዖይዶ ማዒ ፓቂንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ቤርታሳ ዎራሢ ፒሾኔ ጌይንታኔ፤ ዬይያ ዎርቄ ጴዻያ፥ ሃዊላ ጌይንታ ዓጮ ቢያ ሺሪ ዴንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ዬኖ ዓጮ ዎርቃ ጌኤሺኬ፤ ሃሣ ዒዞ ዓጮይዳ ሜሌ ቤስካ ጴዹዋ ሳውቃ ሚሢ ማኣሢንታ ሚርጌ ሚዛጲ ማዔ ዱማ ዱማ ባኣዚ ማይሊ ኮሺም ማዓ ሹቺያ ዒኢካ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ላምዓሳ ዎራሢ ጊዮኔ ጌይንታኔ፤ ዬይያ ዒቶጲያ ዓጮኮ ዙሎና ሺሪ ዓኣዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ሃይሣሳ ዎራሢ ፄግሮሴ ጌይንታኔ፤ ዬይያ ዓሶኦሬ ጌይንታ ዓጮኮ ዓባ ኬስካ ዛሎና ዓኣዻኔ፤ ዖይዳሳ ዎራሢያ ዔፒራፂሴ ጌይንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዓሲ ዔዴኔይዳ ጌሤኔ፤ ዬያ ዒዚ ማዼሢ ዓሲ ዬኖ ዱማ ዱማ ሚፃ ባቃላ ቤዜሎ ጎሽኪ ሚፆዋ ሚዛጲሲ ካፓንዳጉዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ፦ «ዱማ ዱማ ሚፃ ባቃላ ቤዞይዳ ዓኣ ሚፆኮ ዓኣፖ ኔኤኒ ሙዓኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ጋዓንቴ ኮዦ ፑርታፓ ዱማሳንዳጉዲ ማሃ ዔራቶ ዒንጋ ሚፄሎ ዓኣፖይዳፓ ሙዒፖ፤ ዓይጎሮ ጌዔቶ ዬኖ ሚፄሎ ዓኣፖይዳፓ ኔኤኒ ሙዔ ዎዶና ሃይቃንዳሢ ኔና ዔሬ» ጌዒ ዓሢም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ሄሊሳዖ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ፦ «ዓሢ ፔኤሮ ናንጋሢ ኮሺቱዋሴ፤ ዬያሮ ዒዛና ጊኢጋያ፥ ሃሣ ዒዛ ማኣዳንዳያ ላጌ ታኣኒ ማዣንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ሳዖ ዓጮይዳፓ ዔኪ ካዮ ቦዖንታ፥ ቆሎንታ፥ ካፖንታ ቢያ ማዤኔ፤ ዎዚ ጋዓ ሱንሢ ዒዚ ዔያቶም ጌሣንዳቴያ ዛጋኒ ዓሢ ኮራ ዔኪ ዬዔኔ፤ ዓሢ ቶኦካ ቶኦካ ሼምፖና ዓኣ ማዢንቶም ጌሤ ሱንፃ ፔቴ ፔቴሢም ዔኤሊንቶያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ዬያይዲ ዓሢ ቆሎንታ ካፖንታ ቦዖንታም ቢያ ሱንሢ ጌሤኔ። ዓሢም ጋዓንቴ ዒማና ጊኢጋያና ላጌ ማዒ ዒዛ ማኣዳያ ሃጊ ጴዺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዓሢ ሃሃይቄጉዲ ጊንዒሼኔ፤ ዬካፓ ዒዚ ጊንዒ ዓኣንቴ ጎኦቦ ባራንፃፓ ፔቴ ሜጌሢ ዔኪ ቤዞ ዓሽኪና ኩንሢ ፓፂሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዓሢኮ ጎኦባፓ ዔኬ ባራንፆ ሜጌፄሎ ላኣሊ ማሂ ማዢ፥ ዓሢ ኮራ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ዓሢ ዒማና፦ «ሃይሾ ጋፒንፆይዳ ታኣኒ ታና ማላያ ዴንቄኔ፤ ዒዛ ታኣኮ ሜጌፃፓ ጴዼ ሜጌሢኬ፤ ታኣኮ ዓሽኮይዳፓ ጴዼ ዓሽኪኬ፤ ዓቲንቄፓ ጴዼያ ዒዛ ማዔሢሮ ‹ላኣሊ› ጌይንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ዓቲንቄ ዓዶና ዒንዶና ሃሺ ማቾና ዎላ ማዓሢ ዬያሮኬ፤ ላምዖንሢያ ፔቴ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ዓሢና ማቾና ዔያቶኮ ዑፃ ካሎታንቴ ዎሊ ሴልቂ ዒጊጩዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ማዤ ቦዖ ቢያይዳፓ ሾኦሺ ሚርጌ ጪንጫ፤ ሃሣ ጌሻያታሢሮ፦ «ዱማ ዱማ ሚፃ ባቃሊ ዓኣ ቤዜሎይዳ ዓኣ ሚፆኮ ዓኣፖ ዒንሢ ሙዑዋጉዲ ፆኦሲ ዒንሢ ጎኔ ላኣጊያ?» ጌዒ ላኣሌሎ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ላኣሌላ ማሃዖ፦ «ዱማ ዱማ ባቃሌ ሚፃ ዓኣ ቤዞይዳ ዓኣ ሚፆ ዓኣፖይዳፓ ኑ ሙዓኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ጋዓንቴ ፆኦሲ ‹ዱማ ዱማ ባቃሌ ሚፆኮ ባኣኮይዳ ዓኣ ሚፃሢ ዓኣፖ ሙዒፖቴ፤ ኩጮናኣ ካኣሚፖቴ፤ ዬያ ዒንሢ ማዼቶ ሃይቃንዳኔ› ሂዚ ጌዒ ኑም ላቴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ሾኦዣሢ፦ «ፔቴታዖ ዒንሢ ሃይቃዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ፆኦሲ ዬያ ዒንሢ ዓይሤሢ ዬያ ሚፆኮ ዓኣፖ ዒንሢ ሙዔ ዎዶና ፆኦሲጉዲ ዒንሢ ማዓንዳሢና ኮዦ ፑርቶይዳፓ ዱማሲ ዒንሢ ዔራንዳሢ ቤርታዺ ዔራሢሮኬ» ዒዞም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ላኣሌላ ሚፃሢ ኮሺ፥ ዓኣፖ ሙዓኒያ ናሻያና ዔራ ማሃኒ ዳንዳዓያ ማዔሢ ዛጋዖ ዓኣፖይዳፓ ዔኪ ሙዒ ዒዞና ዎላ ዓኣ ዓኒማኣ ዒንጌኔ፤ ዒዚያ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ዬካፓ ላምዖንሢ ቤዞማና ጶቂሥሢ ዔራቶ ዴንቄሢሮ፥ ካሎ ዔያታ ማዔሢ ዔሬኔ፤ ዬያሮ ቤሌሴ ጌይንታ ሚሢኮ ዒላዦ ዎላ ካንሢ ሲካዖ ጊልዲማ ማሂ ዔያቶኮ ካሉሞ ዓኣቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ዬኖ ኬሎ ዋንቶና ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዱማ ዱማ ሚፃ ባቃሊ ዓኣ ቤዜሎይዳ ሃንታንቴ ዑኡዞ ዋይዜሢሮ፥ ዓሢና ማቾና ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዔያቶ ዴንቁዋጉዲ ጌዒ ሚፆ ባኣካ ዓኣሺንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዓሢ ዔኤላዖ፦ «ኔኤኒ ዎካ ዓኣይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ዓሢ፦ «ዱማ ዱማ ሚፃ ባቃሊ ዓኣ ቤዞይዳ ኔኤኮ ዑኡዞ ታ ዋይዛዖ፥ ካሎ ታኣኒ ማዔሢሮ ኔና ታ ዒጊጪ ዓኣሺንቴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ፆኦሲያ ዓሢ ኮራ፦ «ኔኤኒ ካሎ ማዔሢ ዖ ኔኤም ኬኤዜይ? ታ ኔና ‹ሙዒፖ› ጌዔ ሚፆ ዓኣፖ ዔኪ ኔኤኒ ሙዒያ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ዓሢ፦ «ሃና፥ ታኣና ዎላ ናንጋንዳጉዲ ኔ ዒንጌ ላኣሌላ ሚፆ ዓኣፖ ዔኪ ታኣም ዒዛ ዒንጋዛ ታ ሙዔኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ላኣሌሎ፦ «ዓይጎሮ ኔኤኒ ዬያይዴይ?» ጌዒ ዖኦጬኔ። ላኣሌላ ማሃዖ፦ «ሾኦሺ ታና ጌሻዛ ታ ሙዔኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ሾኦዣሢም ሂዚ ጌዔኔ፦ «ዬያ ኔኤኒ ማዼሢሮ ቆልሞና ቦዖ ቢያይዳፓ ዱማዺ ጋዳንቂንቴያ ማዔ፤ ሃናኣፓ ዓርቃዖ ዳዲና፥ ሳዓና ጎቺንቲ ሃንቴ፤ ቢያ ዎዴ ዓጪ ሙዒ ናንጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ኔኤና ላኣሌሎና ዎሊኮ ሞርኬ ታኣኒ ማሃንዳኔ፤ ዒዞ ዜርፆና ኔ ዜርፆና ቢያ ዎዴ፥ ኮሜ ዓሲ ማዒ ናንጋንዳኔ፤ ላኣሌሎ ዜርፃ ኔኤኮ ቶኦኮ ዳኣፃንዳኔ፤ ኔኤኒ ዒዞ ዜርፆኮ ዲንጊርዦ ዻዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ላኣሌሎማኣ፦ «ኔኤኒ ጎጳዼ ዎዶና ሜታሢ ታ ኔኤኮ ኔ ሾዓ ዎዶናኣ ቆፂ ሜታሲፆ ታ ሚርጊሻንዳኔ፤ ጋዓንቴ ኔ ዓኒ ኔ ሱኡካዻንዳኔ፤ ሃሣ ኔ ዓኒማ ኔኤኒ ዓይሢንታያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ዓሢማኣ ሂዚ ጌዔኔ፦ «ኔ ማቾ ጌኤዞ ኔኤኒ ዋይዚ ኔና ታ ‹ሙዒፖ› ጌዔ ሚፆ ዓኣፖ ኔ ዔኪ ሙዔሢሮ ኔ ማዼ ፑርቶ ማዾ ዛሎና ሳዔላ ጋዳንቂንቴያ ማዖም፤ ሳዓ ኔኤም ኮይሳ ሙኡዚ ዒንጋንዳጉዲ ኔ ናንጎ ዎዶ ቢያይዳ ሚርጌ ኔኤኒ ላቢንቲ ማዼ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ሳዓ ኔኤም ዓንጊሢና ጋውዲና ባቃልሶም፤ ኔኤኒያ ሳዖይዳፓ ባቃሌ ባኮ ሙዔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ኔኤኒ ዓጪታሢሮ ኔ ኬስኬ ዓጮ ባንሢ ማዒ ኔ ጌላንዳያ ሄላንዳኣና ሙኡዚ ዴንቃኒ ሚርጌ ጮጋቲ ኔኤኒ ማዻንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ዓሢያ ዒዛኮ ማቻ ሼምፓ ዓኣ፥ ዓሲ ማዢንቲኮ ቢያ ዒንዶ ማዔሢሮ «ሂዋኣኖ» ጋዓ ሱንሢ ዒዞም ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዓዳኣሜና ማቾናም ዒልዒ ዓፒላ ማሂ ኮሺ ማይሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ኬኤዛዖ፦ «ዓካሪ ዓሲ ኮዦ ፑርቶይዳፓ ዱማሲ ዔርዛ ዔራቶ ዔሬሢሮ ኑጊዳፓ ፔቴሢጉዲ ማዔኔ፤ ሃይፓ ሴካ ፔ ኩጮና ሼምፖ ዒንጋ ሚፆይዳፓ ዔኪ ሙዒ ናንጊና ናንጉዋጉዲ ዒዛ ታ ላኣጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ዬያሮ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዔዴኔ ጌይንታ ዱማ ዱማ ሚፃ ባቃሊ ዓኣ ቤዛፓ ዓሢ ማዢንቴ ሳዖ ጎሽኪ ናንጋንዳጉዲ ዒዛ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ፆኦሲ ዓሲ ዔዴኔይዳፓ ኬሴሢኮ ጊንፃ ዬኖ ቤዜሎኮ ዓባ ኬስካ ዛሎና ዼኤፒ ዒጊቻ፥ ዒዛኮ ኪኢታንቾና ቢያ ዛሎ ሺሪ ሺሪ ታሚጉዲ ዔዔኤታ ጬንቻ ዓፓሮና ጌሤኔ፤ ዬያ ዒ ማዼሢ ዖኦኒያ ናንጎ ሚፃሢ ባንሢ ዑኩዋጉዲ ጌዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ዬካፓ ዓሢ ዒዛኮ ማቾ፥ ሂዋኣኖና ላሄም ዒዛ ጎጳዻዖ ዓቲንቄ ናይ ሾዔኔ፤ ዒዛ፦ «ናንጊና ናንጋ ጎዳ ታና ማኣዳዛ ዓቲንቄ ናይ ታ ዴንቄኔ» ጋዓዖ ሱንፆ ዒዛኮ «ቃኣዔኤሌ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ላሚ ሃሣ ቃኣዔኤሌኮ ጌኤዚ ዓኣቤኤሌ ሾዔኔ፤ ዓኣቤኤሌ ዒማና ማራይ ሄንቃያ ማዓዛ፥ ቃኣዔኤሌ ጋዓንቴ ጎሺ ጎሽካያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ሚርጌ ኬሊኮ ጊንፃፓ ቃኣዔኤሌ ጎሽኬ ሃኣኮይዳፓ ዔኪ ናንጊና ናንጋ ጎዳም ዒንጎ ዒንጊሢ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ዓኣቤኤሌያ ማራቶ ባኣካፓ ቤርታ ሾይንቴ ፔቴ ማራናይ ዔኪ ሙኪ ሹካዖ ማሎና ኮዦ ኮዦ ዓሽኮ ቢያ ናንጊና ናንጋ ጎዳም ታሚና ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሻዛ ናንጊና ናንጋ ጎዳ ዓኣቤኤሌንታ ዒዚ ዒንጌ ዒንጊፆዋ ዛጊ ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ቃኣዔኤሌንታ ዒዚ ዒንጌ ዒንጊፆዋ ዛጊ ናንጊና ናንጋ ጎዳ ዎዛዺባኣሢሮ ቃኣዔኤሌ ዓኣፖ ካሮ ቱኪ ሚርጌና ዻጋዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ዒማና ናንጊና ናንጋ ጎዳ ቃኣዔኤሌ ኮራ ሂዚ ጌዔኔ፦ «ኔኤኒ ዻጋዺ ዓኣፖ ካሮ ቱኬሢ ዓይጎሮዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ኮሺ ኔ ማዼያታቴ ዓኣፖ ካራ ኔኤኮ ጌኤሺ ማዓንዳንቴ ሃሢ ኔ ማዼ ባካ ፑርታ ማዔሢሮ ጎማ ኔና ካሮይዳ ካቲ፥ ፔ ዴማ ኔና ማሃኒ ኮዓኔ፤ ጋዓንቴ ኔኤኒ ዬያ ባሻንዳያ ኮይሳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ዬካፓ ቃኣዔኤሌ ፔኤኮ ጌኤዚ ዓኣቤኤሌ፦ «ሃኒ ዬዔ፥ ኑ ዎላ ቦኦሎ ዓኣዾም» ጌዒ ቦኦሎ ዔኪ ዴንዲ ዒኢካ ዓኣዖ ጌኔ ማሊሢና ፔ ጌኤዚ ዓኣቤኤሌ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ናንጊና ናንጋ ጎዳ ቃኣዔኤሌ ኮራ፦ «ኔ ጌኤዚ ዓኣቤኤሌ ዓንካዳይ?» ጌዒ ዖኦጫዛ፥ ቃኣዔኤሌ ፆኦሲም፦ «ዒዚ ዓንካ ዓኣቴያ ታ ዒዛ ዔሩዋሴ፤ ታኣኒ ታ ጌኤዚ ሄንቃያዳ?» ጌዒ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ናንጊና ናንጋ ጎዳሢ ቃኣዔኤሌም ሂዚ ጌዔኔ፦ «ሃይ ኔ ማዼ ባካ ዓይጌንዴዳይ! ላኣሊንቴ፥ ኔ ጌኤዚኮ ሱጉፃ ሳዓፓ ታ ባንሢ ኔጊዳ ፑርታና ዎጊሳኒ ዒላታሢሮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ኔኤኒ ጋዳንቂንቴያ ማዔ፤ ኔ ጌኤዚ ኔኤኒ ዎዻኣና ሱጉሢ ዑሽካኒ ሻማታ ቦዖጉዲ ማዔ ሳዔሎይዳ ኔኤኒ ዲቃቲ ሃንታያ ማዔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ሳዖ ኔኤኒ ጎሽኬ ዎዶና ሃኣካ ኔኤም ካፆፓ፤ ሳዖይዳ ዳኪንቲ ቤሲባኣ ዓሲ ማዔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ቃኣዔኤሌ ናንጊና ናንጋ ጎዳ ኮራ፦ «ሃይ ታ ጎሞሮ ዓጊንቴ ጋዳማ ታኣኒ ኬዳኒ ዳንዳዓሢኮ ዑሣኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ዓካሪ ኔኤኒ ታና ሳዓፓ ዳውሴሢሮ ኔ ቤርታፓ ታኣኒ ዓኣሺንቲ ሳዖይዳ ዳኪንቴያና ሜታዻያና ማዓንዳኔ፤ ዖኦኒያ ታና ዴንቄ ዓሲ ዎዎዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ናንጊና ናንጋ ጎዳሢ ጋዓንቴ፦ «ዖኦኒያ ኔና ካኣማዓኬ፤ ጋዓንቴ ዓሲ ኔና ዎዼቶ ኔና ሄሌ ጋዳሞይዳፓ ላንካይ ጳንጬ ማዓ ባሼ ጋዳማ ዬያ ሄላንዳኔ» ጌዔኔ። ዬያሮ ናንጊና ናንጋ ጎዳ ቃኣዔኤሌ ዖኦኒያ ዴንቄቴ ዎዹዋጉዲ ዔርዛ ዱማ ማላታ ዒዛም ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ዬካፓ ቃኣዔኤሌ ጎዳ ቤርታፓ ሃኪ ዴንዳዖ፥ ዔዴኔኮ ዓባ ኬስካ ዛላ ሴካ ሃንጋ ጌዒ ሜታዺ ሃንቲሢ ቤሲ ጎዖ ዓጫ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ቃኣዔኤሌ ፔ ማቾና ላሃዛ፥ ዒዛ ጎጳዻዖ ዓቲንቄ ናይ ሾዔኔ፤ ሱንፆዋ ዒዛኮ ዔያታ «ሄኖኬ» ጌዒ ጌሤኔ፤ ቃኣዔኤሌ ዬኖ ዎዶና ካታማ ማዣያታዖ ማዢ ጋፒሴሢኮ ጊንፃ ካታሜሎኮ ሱንፆ «ሄኖኬ» ጌይ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ሄኖኬ ዒራዴ ሾዔኔ፤ ዒራዴ ሜሁያዔኤሌ፥ ሜሁያዔኤሌ ሜቱሻዔኤሌ ሜቱሻዔኤሌያ ላሜኬ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ላሜኬ ዓዳና ፂላና ጌይንታ ላምዖ ላኣሊ ዔካዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ዓዳ ጎዖ ላኣሌላ ያቤሌ ጎዖ ናይ ሾዔኔ፤ ያቤሌ ጎዖሢ ቆልሞ ሄንቂ ሄንቂ ቦኦላ ዓፒላና ማዦ ማኣሪዳ ናንጋ ዓሶኮ ዓዶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ዒዛኮ ጌኤዚ ዩባሌ ጎዖሢ ጎኦላና ሹሉንጎና ዋርቃ ዓሶኮ ዓዶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ፂላ ጎዖ ላኣሌላ «ቱባልቃይኔ» ጎዖያ ዓቲንቄ ናይ ሾዔኔ፤ ዒዚያ ዱማ ዱማ ዓንጊ ዹዓያኬ፤ ቱባልቃይኔኮ ናዒማ ጌይንታ ጌራ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ላሜኬ ፔኤኮ ማቾንሢ ዓዳና ፂላና ዔኤላዖ፦ «ላሜኬ ላኣላ ሂንዳ ዋይዙዋቴ፤ ፔቴ ዼጌ ታና ጳርቄሢሮ ታ ዒዛ ዎዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ቃኣዔኤሌ ዎዻሢ ላንካይ ጳንጬ ጋዳማ ሄላንዳኔ ጌይንቴቶ ታና ዎዻያም ላንካይታሚ ላንካይ ጳንጬ ጋዳማ ዒዛ ሄላንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ዓዳኣሜኮ ማቻ ሃሣ ላሚ ጎጳዻዖ ዓቲንቄ ናይ ሾዔኔ፤ ዒዛኣ፦ «ቃኣዔኤሌ ዎዼ፥ ዓኣቤኤሌ ቤዛ ፆኦሲ ታኣም ዓቲንቄ ናይ ዒንጌኔ» ጋዓዖ ዒዛኮ ሱንፆ «ሴኤቴ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ሴኤቴያ «ሄኖሴ» ጌይንታ ዓቲንቄ ናይ ሾዔኔ፤ ዬኖ ዎዶናኬ ዓሳ ናንጊና ናንጋ ጎዳ ካሽኪሢ ዓርቄሢ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ዓዳኣሜ ዜርፆኮ ሱንፃ ሃይፓ ዴማ ፓይዲንታሢ ጉዴያኬ፤ ፆኦሲ ዓሲ ማዤ ዎዶና ፔ ማሎና ማዤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ዓቲንቄና ላኣሊና ማሂ ማዣዖ ዓንጄኔ፤ «ዓሲ» ጌዒያ ሱንሢ ዔያቶም ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ዓዳኣሜኮ ሌዓ ፄኤታና ሃይሢታሚና ሌዔ ማዔ ዎዶና ዒዛ ማላያ ዓቲቄ ናይ ሾዓዖ፥ ሱንፆ «ሴኤቴ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ዬካፓ ዓዳኣሜ ሳሊ ፄኤታ ሌዔ ናንጋዖ ሃሣ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ሌዓ ዒዛኮ ዎሊ ዑፃ ታዞጳ ፄኤታና ሃይሢታሚ ሌዔ ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ሴኤቴ ፄኤታና ዶንጎ ሌዔና ማዓዛ ሄኖሴ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ዬካፓ ሴኤቴ ሳሊ ፄኤታና ላንካይ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ዎሊ ዑፃ ዒዛኮ ሌዓ ታዞጳ ፄኤታና ታጶ ላምዖ ሌዔና ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ሴኤቴ ናኣዚ ሄኖሴኮ ሌዓ ታዞጲታሚ ማዓዛ ቃይናኔ ጎዖሢ ሾዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ዬካፓ ሳሊ ፄኤታና ታጶ ዶንጎ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ዎሊ ዑፃ ዒዛኮ ሌዓ ታዞጳ ፄኤታና ዶንጎ ሌዔና ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ሄኖሴ ናኣዚ ቃይናኔኮ ሌዓ ላንካይታሚ ማዓዛ ሜላሊዔኤሌ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ዬካፓ ሳሊ ፄኤታና ዖይዲታሚ ሌዔ ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ዎሊ ዑፃ ሌዓ ዒዛኮ ታዞጳ ፄኤታና ታጶ ሌዔና ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ቃይናኔ ናኣዚ ሜላሊዔኤሌኮ ሌዓ ላሂታሚ ዶንጎ ማዓዛ ያሬዴ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ዬካፓ ሳሊ ፄኤታና ሃይሢታሚ ሌዔ ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ሌዓ ዒዛኮ ዎሊ ዑፃ ሳሊ ፄኤታና ታዞጲታሚ ዶንጎ ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ያሬዴኮ ሌዓ ፄኤታና ላሂታሚ ላምዖ ማዓዛ ሄኖኬ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ዬካፓ ሳሊ ፄኤታ ሌዔ ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ሌዓ ዒዛኮ ዎሊ ዑፃ ታዞጳ ፄኤታና ላሂታሚ ላምዖ ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ሄኖኬኮ ሌዓ ላሂታሚ ዶንጎ ማዓዛ ማቶሳላ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ዬካፓ ሄኖኬ ፆኦሲና ጊኢጊ ሃንቲሢና ሃይሦ ፄኤታ ሌዔ ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ሄኖኬኮ ሌዓ ሃይሦ ፄኤታና ላሂታሚ ዶንጎ ማዓንዳያ ሄላንዳኣና ናንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ዬያጉዴ ሌዔ ዒዚ ናንጌሢ ፆኦሲና ጊኢጊ ሃንቲሢናኬ፤ ዬካፓ ፆኦሲ ዒዛ ዔኬሢሮ ሃይቁዋዖ ጉሪ ዒ ባባይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ሄኖኬ ናኣዚ ማኣቶሳላኮ ሌዓ ፄኤታና ሳሊታሚ ላንካይ ማዓዛ ላሜኬ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ዬካፓ ላንካይ ፄኤታና ሳሊታሚ ላምዖ ሌዔ ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ሌዓ ዒዛኮ ዎሊ ዑፃ ታዞጳ ፄኤታና ላሂታሚ ታዞጳ ማዓዛ ዒ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ላሜኬኮ ሌዓ ፄኤታና ሳሊታሚ ላምዖ ማዓዛ ዓቲንቄ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","«ዬይ ናዓሢ ናንጊና ናንጋ ጎዳ ጋዳንቄ ሳዔሎይዳ ፑኡፖ፥ ዶዶ ማዻፓ ኑና ሃውሺሳንዳኔ» ጋዓዖ፥ ሱንፆ ዒዛኮ «ኖሄ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ዬካፓ ላሜኬ ዶንጎ ፄኤታና ታዞጲታሚ ዶንጎ ሌዔ ናንጊ፥ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ሌዓ ዒዛኮ ዎሊ ዑፃ ላንካይ ፄኤታና ላንካይታሚ ላንካይ ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ኖሄኮ ሌዓ ዶንጎ ፄኤታ ማዔስካፓ ሃይሦ ዓቲንቄ ናይ ሾዔኔ፤ ዔያቶኮ ሱንፃ ሴኤሜ፥ ካኣሜ፥ ያኣፔቴ ጌይንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ዓሲኮ ዜርፃ ሳዖይዳ ሚርጊ ሚርጊ ዓኣዼ ዎዶና ሚርጌ ዉዱሮ ናይ ሾይንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ዬኖ ዎዶና ፆኦሲ ዓቲንቆ ናኣቶ ማዔዞንሢ ዬያቶ ዉዱሮ ናኣቶኮ ሚዛጱሞ ዛጋዖ ዔያቶም ማዓንዳያ ዶኦሪ ላኣሊ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ናንጊና ናንጋ ጎዳሢ፦ «ዓሲም ሼምፖ ዒንጋ ታኣኮ ዓያና ዓሲና ዎላ ናንጊና ማይ ናንጊንዱዋሴ፤ ዓይጎሮ ጌዔቶ ዓሲ ሃይቃያ ማዔሢሮ ሃካፓ ሴካ ፄኤታና ላማታሚ ሌዔናፓ ዑሣ ዓኣዼ ናንጋዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ዬኖ ዎዶና ዔርቴ ዓሶ ዉዱሮ ናኣቶና ዬንሢ ፆኦሲ ዓቲንቆ ናኣቶ ማዔዞንሢፓ ዎልቄና ዼኤፒ ሚርጌ ዓሲ ሾይንቴኔ፤ ዔያታ ሚናኣ ዎዶና ዒጊቻያ ማዔ፥ ዔርቴ ዎልቄ ዓሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ጉቤ ዎዴና ሳዖይዳ ዓኣ ዓሳ ቢያ ዓይሢንቱዋያና ማሊፃኣ ፑርቱሞ ሌሊ ማዔሢ ናንጊና ናንጋ ጎዳ ዛጋዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ዓሲ ማዢ ሳዖይዳ ናንጋንዳጉዲ ማሂፆና «ዓይጎሮዋ ታ ማዤይ» ጌዒ ሚርጌና ዖዬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ዬያፓ ዔቄያና ፆኦሲ፦ « ‹ዓሲ ታኣኒ ዓይጋ ማዤይ› ጌዒ ዒና ታኣኮ ዖዬኔ፤ ዬያሮ ዬያ ታ ማዤ ዓሶንታ ቦዖ ዻኮንታ ዼኤፖንታ፥ ቆሎንታ፤ ሃሣ ካፖዋ ዓይሱዋዖ ሳዖይዳፓ ታ ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ጋዓንቴ ዒማና ፔቴ ኖሄ ጌይንታ ናንጊና ናንጋ ጎዳ ዎዛሳ ናንጊ ናንጋ ዓሲ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ኖሄኮ ሃይሳ ያዺኬ፤ ኖሄ ፔ ናንጎ ሌዖ ቢያይዳ ፒዜ ማዔያና ፆኦሲና ጊኢጊ ሃንታ ኮሺ ዓሲኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ኖሄ፦ ሴኤሜ፥ ካኣሜና ያኣፔቴ ጌይንታ ሃይሦ ዓቲንቄ ናይ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ዬኖ ዎዶና ሳዖይዳ ዓኣ ዓሳ ቢያ ፆኦሲ ቤርታ ፑርታ ዎቦ ማዔሢሮ ጌኔ ማዾ ዓጮ ቢያይዳ ማዺንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ፆኦሲ ሳዖ ቢያ ዛጋዛ ፑርቴያ ማዔሢና ዒኢካ ናንጋ ዓሳ ቢያ ዎቦታሢ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ዬያሮ ፆኦሲ ኖሄም፦ «ዓሲኮ ዜርፆ ሳዖይዳፓ ቢያ ታኣኒ ባይዛኒ ማሌኔ፤ ዓይጎሮ ጌዔቶ ሳዓ ዓሶኮ ጌኖ ማዾና ኩሜሢሮ ዓሲ ጋዓ ባኣዚ ሳዖይዳፓ ታኣኒ ባይዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ኔኤም ጋዓንቴ ቃራ ሚሢዳፓ ዋኣሢ ካኣሚሌ ማዤ፤ ጋራ ሚርጌ ቆልዓና ዓኣያ ማሂ ማዢጋፓ ጋሮና ዙሎና ሺዲና ሺዴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ዖዶሱማ ሃይሦ ፄኤታ ዋዻ፥ ጋሮ ዳልጉማ ዶንጊታሚ ዋዻ፥ ቱሮ ዔጳ ሃይሢታሚ ዋዻ ማዔያ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ዋኣፆ ካኣሚሎኮ ቶኦካ ማኣሪ ማዤ፤ ኮጮና ሳኮና ካኣማ ካሮኮ ፔቴ ዋዻ ኩሙዋ ቤሲ ሃሼ፤ ዋኣፆ ካኣሚሎኮ ዎሊ ዑፃ ዑፃ ሃይሦ ኩባ ዓኣያ ማሂ ማዣዖ ካሮ ጎኦቦ ዛሎና ማሂ ማዤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ሳዖይዳፓ ሼምፓ ዓኣ ባኣዚ ባይዛኒ ባይሲንታ ዋኣሢ ታ ኬሳዛ፥ ሳዖይዳ ሼምፓ ዓኣ ማዢንታ ቢያ ኩዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ኔና ታ ባይዚንዱዋያ ማዔሢ ታኣኒ ኔኤም ጫኣቃንዳኔ፤ ኔኤና ኔ ማቾና ኔ ናኣቶና ዔያቶኮ ላኣሎና ዋኣፆ ካኣሚሎ ጋሮ ጌሉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","«ኔኤና ዎላ ናንጊ ዓታንዳጉዲ ሼምፓ ዓኣ ማዢንቶኮ ዜርፃፓ ዜርፃፓ ላምዖ ላምዖ ዓዴና ዒንዴና ዔኪ ዔኪ ዋኣፆ ካኣሚሎ ጋሮ ጌልዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ባይሲንታፓ ዓታንዳጉዲ ዱማ ዱማ ካፖ ዜርፃፓ፥ ቆልሞይዳፓ፥ ካዮ ቦዖ ዻኮንታ ዼኤፖንታይዳፓ ላምዖ ላምዖ ማዒ ኔ ኮራ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ዬካፓ ኔናንታ ዬንሢ ማዢንቶም ቢያ ጊዳንዳ ዱማ ዱማ ሙኡዚ ዋኣፆ ካኣሚሎ ጋራ ቡኩሴ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ኖሄያ ፆኦሲ ዒዛ ዓይሤሢ ቢያ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ናንጊና ናንጋ ጎዳ ኖሄም ጋዓዖ፦ «ሃኖ ዎዶ ሾይንቶ ባኣካ ኮሺ ዓሲ ኔና ሌሊ ማዔሢሮ ኔኤኒ ኔ ማኣሮ ዓሶና ዋኣፆ ካኣሚሎ ጋሮ ጌሌ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ፆኦሲም ዒንጊንታኒና ሙዒንታኒ ዳንዳዓ ቆልሞና ቦዖናይዳፓ ቢያ ላንካይ ላንካይ ዓዴና ዒንዴና ኔኤና ዎላ ዋኣፆ ካኣሚሎይዳ ጌልዜ፤ ፆኦሲም ዒንጊንታኑዋያና ሙዒንቱዋ ቆልሞይዳፓ ቢያ ፔቴ ፔቴ ዓዴና ዒንዴና ሌሊ ጌልዜ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ፔቴ ፔቴ ካፖ ዜርፃፓ ላንካይ ላንካይ ዓዴና ዒንዴና ጌልዜ፤ ዬያ ኔ ማዻንዳሢ ፔቴ ፔቴ ቆልሞንታ ካዮ ቦዖንታ ካፖንታ ሳዛና ናንጋንዳጉዲና ሳዖይዳ ዜርሢ ዓታንዳጉዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ታኣኒ ማዤ ሼምፓ ዓኣ ማዢንቶ ቢያ ሳዖ ቢያይዳፓ ባይዛኒ ላንካይ ኬሊኮ ጊንፃፓ ዖይዲታሚ ኬሊ ሮኦሪና ዋንቴና ቢያ ጋፑዋ ዒርዚ ታ ዋርቂሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ኖሄያ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ባኮ ቢያ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ባይሲንቶ ዋኣፃ ሳዓ ማዔ ዎዶና ኖሄኮ ሌዓ ላሆ ፄኤታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ኖሄ፥ ማቻ፥ ናኣቶንታ ዔያቶኮ ላኣላኣ ባይሲንቶ ዋኣፆይዳፓ ዓታኒ ዋኣፆ ካኣሚሎይዳ ጌሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ሙኡዚም ማዓያና ማዑዋ ፔቴ ፔቴ ቆሎንታ ካዮ ቦዖንታ፤ ሃሣ ካፖንታይዳፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ላምዖ ዓዴና ዒንዴና ማዒ ማዒ ኖሄ ኮራ ሙኬኔ፤ ፆኦሲ ዓይሤ ጎይፆና ዋኣፆ ካኣሚሎይዳ ኖሄ ጌልዛዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ላንካይ ኬሊኮ ጊንፃፓ ባይሲንቶ ዋኣፃ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ኖሄኮ ሌዓ ላሆ ፄኤታ ማዔ ዎዶና ላምዓሳ ዓጊኖኮ ታጶ ላንካሳ ኬሎ ሳዖኮ ዴማ ዓኣ ፑኡፖ ዋኣፆኮ ዓልቃ ካራ ቢያ ዔርቱዋንቴ ዳርዓዛ፥ ጫሪንጮይዳ ዓኣ ዋኣፆኮ ካራ ቢያ ቡሊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ዒራ ዖይዲታሚ ሮኦሪና ዖይዲታሚ ዋንቴና ሃሹዋዖ ሳዖይዳ ዋርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ዒራ ዋርቂፆ ዓርቄ ኬሎ ኖሄ፥ ማቻ፤ ዔያቶኮ ናኣታ ሴኤሜ፥ ካኣሜ፥ ያኣፔቴያ ዔያቶኮ ሃይሦ ላኣሎንሢና ዎላ ዋኣፆ ካኣሚሎይዳ ጌሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ቆልሞይዳፓ፥ ካዮ ቦዖ ዻኮንታ ዼኤፖንታይዳፓ፤ ሃሣ ጫሪንጫ ባራና ካፖናይዳፓ ፔቴ ፔቴ ፔኤኮ ዜርፆጉዴያ ዔያቶና ዎላ ዋኣፆ ካኣሚላ ጌሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ያዒዲ ፔቴ ፔቴ ሼምፓ ዓኣ ማዢንታፓ ላምዖ ላምዖ ማዒ ኖሄና ዎላ ዋኣፆ ካኣሚላ ጌሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ማዢንታ ቢያ ዓዴና ዒንዴና ማዒ ዋኣፆ ካኣሚላ ጌሌሢ ፆኦዛሢ ዓይሤ ጎይፆ ጉዴያናኬ፤ ዬካፓ ናንጊና ናንጋ ጎዳ ኖሄኮ ዙሎና ዋኣፆ ካኣሚሎኮ ካሮ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ባይሲንቶ ዋኣፃ ዖይዲታሚ ኬሊ ሄላንዳኣና ኩሚ ኩሚ ዓኣዼኔ፤ ዋኣፃ ቃሲንቲ ቃሲንቲ ዓኣዼሢሮ ዋኣፆ ካኣሚሎ ሳዖይዳፓ ዑፃ ዼግ ዼጊዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ዋኣፆኮ ሳዖይዳፓ ዼጉማ ቃሲንቴ ዎዶና ዋኣፆ ካኣሚላ ዋኣፆ ዑፃ ሴካ ሃንጋ ጌዒ ሃንቲሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ዋኣፃ ጫሪንጮኮ ዴማ ዓኣ ፑኡፖ ዹኮ ባይዛንዳያ ሄላንዳኣና ዼጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ዋኣፃ ዹኮኮ ዑሣ ዓኣዺ ታጶ ዶንጎ ዋዻ ዼጊ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ካፓ፥ ቆልማ፥ ካዮ ቦዖ ዻኮንታ ዼኤፖንታ ዓሶንታ ቢያ ዓቱዋዖ ሃይቃዛ ሳዓ ዓኣ ሼምፓ ዓኣ ማዢንታ ቢያ ባይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ሳዖ ዑፃ ናንጋ ሼምፓ ዓኣ ባኣዚ ቢያ ጋፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ናንጊና ናንጋ ጎዳ ሳዖ ዑፃ ሼምፓ ዓኣ ማዢንቶ ቢያ፥ ዓሶንታ ቆልሞንታ ካፖንታ ካዮ ቦዖ ዻኮንታ ዼኤፖንታ ዓይሱዋዖ ቢያ ባይዛዛ ሃይባፓ ዓቴዞንሢ ኖሄና ዒዛና ዎላ ዋኣፆ ካኣሚሎ ጋራ ዓኣ ባኮንሢ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ባይሲንቶ ዋኣፃ ፄኤታና ዶንጊታሚ ኬሊ ሄላንዳኣና ሚጩዋዖ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ፆኦሲ ኖሄና ዒዛና ዎላ ዋኣፆ ካኣሚሎ ጋራ ዓኣ ካዮ ቦዖንታ ቆልሞንታም ቢያ ማላዖ ሳዖይዳ ዢባሬ ዢባርሺሳዛ ዋኣፃ ኬዲሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ሳዖኮ ዴማፓ ቱሮ ዋኣፃ ዓልቃ ካሮና ጫሪንጫ ዓኣ ዋኣፃኣ ኬዳ ካራ ዎዺንቴኔ፤ ጫሪንጫፓ ዋርቃ ዒራኣ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ዋኣፃ ዻካ ዻካ ሳዓፓ ኬዲሢ ዓርቃዖ ፄኤታና ዶንጊታሚ ኬሊ ሄላንዳኣና ሚጪ ሚጪ ዻኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ባይሲንቶ ዋኣፃ ኩሚፆ ዓርቄሢዳፓ ላንካሳ ዓጊኖኮ ታጶ ላንካሳ ኬሎ ዋኣፆ ካኣሚላ ዓራራቴ ጌይንታ ዹኮኮ ፔቴያ ቶኦካ ሄሊ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ዋኣፃ ታጳሳ ዓጊኖኮ ዓይፆይዳ ታሢ ታሢ ኬዳዛ ዹኮኮ ቶኦካ ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ዖይዲታሚ ኬሊኮ ጊንፃፓ ኖሄ ዋኣፆ ካኣሚሎኮ ፑልቶ ካራፓ ፔቴማ ቡላዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ቁራኬ ኬሲ ዳካዛ ቁራካሢያ ዋኣፃ ሚጫንዳያ ሄላንዳኣና ሴካ ሃንጋ ጌዒ ጌዒ ባራኒ ሌሊ ባራኔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ዬካፓ ኖሄ ሃሣ ዋኣፃ ዓኣ ቤዛፓ ኬዴቶ ዔራኒ ዶኦሌ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ጋዓንቴ ዋኣፃ ሃጊ ሳዖ ባይዚ ዓኣሢሮ ዶኦሌላ ዴዖንዶ ቤሲ ዴንቃኒ ዳንዳዒባኣሢሮ ኖሄ ባንሢ ማዒ ሙካዛ ኖሄ ኩጮ ዋኣፆ ካኣሚላፓ ኬሲ ዶኦሌሎ ፔ ባንሢ ዓርቂ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ላንካይ ኬሊ ዴዔስካፓ ዶኦሌሎ ጊንሣ ማሂ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ዶኦሌላ ዓባ ጌላኣና ዓኣዔ ሪሚቲኮ ዒላሺ ዻንጋ ዔኪ ኖሄ ባንሢ ሙኬሢሮ ኖሄያ ዋኣፃ ዓኣ ቤዛፓ ኬዴሢ ዔሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ሃሣ ላንካይ ኬሊኮ ጊንፃፓ ኖሄ ዶኦሌሎ ኬሲ ዳካዛ ዬማፓ ዶኦሌላ ማዒ ሙኪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ኖሄኮ ላሆ ፄኤታና ፔቴ ሌዔና ማዓዛ ቤርታሳ ዓጊኖኮ ቤርታሳ ኬሎና ዋኣፃ ሳዓፓ ሚጬኔ፤ ኖሄያ ዋኣፆ ካኣሚሎኮ ዑፆ ቡላዖ ኮይሎ ቢያ ዛጊ ዋኣፃ ሚጪ ሳዓ ፃኣዼሢ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ዋኣፃ ሚጮ ዓርቄስካፓ ላምዓሳ ዓጊኖኮ ላማታሚ ላንካሳ ኬሎና ሳዓ ጋፒንሢ ፃኣዺ ሜሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ፆኦሲ ኖሄም፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«ኔኤና ኔ ማቾና ኔ ናኣቶና ዔያቶኮ ላኣሎና ዎላ ዋኣፆ ካኣሚላፓ ኬስኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ዳልጊ ሚርጊ ሳዖ ቢያ ዔያታ ኩማንዳጉዲ ኔኤና ዎላ ዓኣ ሼምፓ ዓኣ ማዢንቶ ቢያ ካፖንታ ቆልሞንታ ሃንጎ ሃሣ ካዮ ቦዖ ዻኮንታ ዼኤፖንታ ቢያ ዔኪ ኬስኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ዬካፓ ኖሄና ማቾና ዒዛኮ ናኣቶንታ ናኣዚ ማቾንሢንታ ዎላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ሃሣ ቆልሞንታ ካፖንታ ካዮ ቦዖ ዻኮንታ ዼኤፖንታ ቢያ ፔኤኮ ፔኤኮ ዜርፃ ዎሊ ጊንፆ ማዒ ዋኣፆ ካኣሚላፓ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ኖሄ ናንጊና ናንጋ ጎዳም ዒንጎ ባኮ ዒንጊ ካኣሽካኒ ሹቺና ቤዞ ኮሻዖ፥ ሙኡዚም ማዓ ቆልሞና ካፖናይዳፓ ፔቴ ፔቴ ዔኪ ናንጊና ናንጋ ጎዳም ዒንጎ ዒንጊሢ ማዓንዳጉዲ ቢያሢ ዒዚ ኮሼ ቤዞይዳ ሚቺ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ዬካፓ ሚቺ ዒንጎና ባኮኮ ሳዋ ናንጊና ናንጋ ጎዳሢ ዎዛሴሢሮ ናንጊና ናንጋ ጎዳ ፔ ማሊፆና ሂዚ ጌዔኔ፦ «ዓሲ ፑርቲሳ ዻቢንቶሮ ቢያ ሃይካፓ ሴካ ታኣኒ ሳዖ ጋዳንቃዓኬ፤ ዓይጎሮ ጌዔቶ ዓሲ ሃጊ ናይ ዓኣላ ዓኣዖ ፑርቱሞ ማዾ ኮዓያ ማዔሢሮ ሃሢ ታኣኒ ማዼሢጉዲ ሼምፓ ዓኣ ማዢንቶ ቢያ ሃይፓ ሴካ ታ ባይዛዓኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ናንጊና ናንጋ ጎዳ ሃሣ ቃሳዖ፦ «ሳዓ ዓኣ ጎይሣ ዓኣንቴ ጎሺ ጎሽኪሢ፥ ሃኣኮ ቡኩሲሢ፥ ጪኢሺ፥ ዖይዺሢ፥ ዖጎሢንታ ባርጊንታ፥ ሮኦሪንታ ዋንቴንታ ቢያ ዎዴ ዓኣያ ማዒ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ፆኦሲ ኖሄና ናኣቶና ዓንጃዖ፦ «ሚርጉዋቴ፤ ዳልጉዋቴ፤ ሳዖዋ ኩሙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ቆልሞንታ ካፖንታ ካዮ ቦዖ ዻኮንታ ዼኤፖንታ፤ ሃሣ ዋኣፃ ናንጋ ሞላሢ ቢያ ዒንሢ ዒጊጪሢና ናንጎንጎ፤ ቢያሢያ ዒንሢ ቢታንቶ ዴማ ዎርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ሃያኮ ቤርታ ዱማ ዱማ ቱኮ ሚፆ ሙኡዚ ማሂ ታ ዒንሢም ዒንጌሢጉዲ ሃሣ ሃያ ሼምፓ ዓኣ ማዢንቶ ቢያ ሙኡዚ ዒንሢም ማዓንዳጉዲ ታ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ጋዓንቴ ሱጉፆ ላኣሉዋዖ ዓሽኮ ሙዒፖቴ፤ ዓይጎሮ ጌዔቶ ሼምፓሢ ሱጉፆይዳ ዓኣያ ማዔሢሮኬ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ዓሲ ዎዻሢ ሃይቃንዳጉዲ ዎጊንታንዳኔ፤ ካይዚ ቦዖ ማዔቴያ ቆልሞታዖ ዓሲ ዎዼቶ ዬያኣ ታ ሃይቃንዳጉዲ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«ዓሲ ማዢንቴሢ ፆኦሲ ማሎናታሢሮ ዓሲ ዎዻ ዓሲ ቢያ ዓሲ ኩሽካ ሃይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ዒንሢ ሚርጉዋቴ፤ ዳልጉዋቴ፤ ዒንሢኮ ዜርፃ ሳዖ ኩሞንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ዬካፓ ፆኦሲ ኖሄና ዒዛኮ ናኣቶናም ሂዚ ጌዔኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","«ዓካሪ ዒንሢና ዒንሢኮ ዜርፆና ሼምፓ ዓኣ ማዢንታ ቢያ ጌይፃ ካፓ፥ ቆልማ፥ ካዮ ቦዓ፤ ዬያጉዲ ኔኤና ዎላ ዋኣፆ ካኣሚላፓ ኬስኬ ማዢንቶንታ ሃሣ ሳዖይዳ ሃጊ ሾይንታንዳ ዜርፆማኣ ቢያም ታ ጫኣቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ዬያ ታ ጫኣቄ ጫኣቁሞ ዛሎና ሃካፓ ሴካ ሼምፓ ዓኣ ማዢንታ ቢያ ባይሲንታ ዋኣሢና ፔቴታዖ ኩዳዓኬ፤ ሳዓ ሃሣ ላሚሣ ባይሲንታ ዋኣሢና ባይቃዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ዒንሢንታ ሼምፓ ዓኣ ማዢንቶ ቢያሢንታ ዎላ ታኣኒ ጫኣቃ፥ ሃያ ናንጊና ናንጋ ጫኣቁሞኮ ማላታ ማዓንዳጉዲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ታኣኮ ዡኡላሢ ጫሪንጮ ሻኣሮይዳ ታኣኒ ዔቂሳንዳኔ፤ ዬይ ዡኡላሢ ታኣኒ ‹ሳዖ ባይዛዓ› ጌዒ ጫኣቄ ጫኣቁሞኮ ማላታ ማዒ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ሻኣሮና ጫሪንጮ ታ ካንቃኣና፥ ሃሣ ዡኡላሢ ሻኣሮይዳ ዔቂ ጴዻ ዎዶና ቢያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ዓካሪ ሃይካፓ ሴካ ‹ባይሲንታ ዋኣሢ፥ ሼምፓ ዓኣ ማዢንቶ ቢያ ባይዛዓኬ› ታኣኒ ጌዒ ዒንሢና ሜሌ ሼምፓ ዓኣ ማዢንቶና ዎላ ጌሌ ጫኣቁሞ ታ ጶቂሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ዡኡላሢ ሻኣሮይዳ ዔቂ ጴዻ ዎዶና ቢያ ታኣና ሳዖይዳ ሼምፓ ዓኣ ማዢንቶና ባኣካ ዓኣ ናንጊና ናንጋ ጫኣቁሞ ታ ጶቂሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ዬይ ዡኡላሢ ሼምፓ ዓኣ ማዢንቶና ዎላ ታኣኒ ጫኣቄ ጫኣቁሞ ዔርዛ ማላታኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ዋኣፆ ካኣሚሎይዳፓ ኬስኬ ኖሄኮ ናኣታ ሴኤሜ፥ ካኣሜ፥ ያኣፔቴ ጎዖዞንሢ ማዓዛ፥ ካኣሜ ጊንፃፓ ካኣናኔ ጎዖ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ሃኖ ሄላንዳኣና ሳዖ ቢያይዳ ዓኣ ዓሳ ቢያ ሾይንቴሢ ዬንሢ ሃይሦ ኖሄኮ ናኣቶንሢዳፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ኖሄ ጎሺ ጎሽካያ ማዓዖ ዎይኔ ጌይንታ ባልጊ ካፃ ሚሢ ቤርታዺ ቱኪሢ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ኖሄ ፔቴ ኬሊ ዒ ቱኬ ዎይኖ ዓኣፖ ጩኡጲ ኮሾና ዑሺ ዑሽኪ ማሢንታዖ ዓፒላ ዑፃ ባኣያ፥ ካሎ ፔ ማኣሮይዳ ላሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ካኣናኔኮ ዓዴ፥ ካኣሜ ዒዛኮ ዓዴ ያኣዼ ካሎ ላሄሢ ዛጌ ዎዶና ካሮ ኬስካዖ ላምዖ ፔኤኮ ጌርሲንሢም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ዬካፓ ጌርሲንሢ ሴኤሜንታ ያኣፔቴንታ ጋኣቤ ዓፒላ ፔኤኮ ጌኤታ ዓርቂ ዓዶኮ ካሉሞ ዛጋዓ ጌዒ ዓዴ ላሂ ዓኣ ኬኤፆ፥ ጊንሢና ሃንቲ ጌሊ ዓዶኮ ካሉሞ ዓኣቼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ኖሄኮ ማሢፃ ዓኣዻዛ ዒዚ ዔቃዖ ናኣቶይዳፓ ዻኮ ጌኤዛሢ ማዼ ባኮ ዔሪጋፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ሂዚ ጌዔኔ፦ «ካኣናኔ ጋዳንቂንቴያ ማዖንጎ! ጌርሲንሢም ዓይሌ ማዒ ማዻያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ሴኤሜኮ ናንጊና ናንጋ ጎዳ ማዔ ፆኦዛሢ ጋላቲንቴያ ማዖም፥ ካኣናኔያ ሴኤሜም ዓይሌ ማዒ ማዻያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ፆኦሲ ያኣፔቴኮ ዓጮ ዳልጊሾንጎ፥ ያኣፔቴ ዜርፃ ሴኤሜ ዜርፆና ዎላ ናንጎንጎ፤ ካኣናኔ ያኣፔቴኮ ዓይሌ ማዒ ማዻያ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ባይሲንቶ ዋኣፆኮ ጊንፃፓ ኖሄ ሃይሦ ፄኤታና ዶንጊታሚ ሌዔና ናንጋዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ዒዛኮ ሌዓ ዎሊ ዑፆይዳ ታዞጳ ፄኤታና ዶንጊታሚ ማዓዛ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ኖሄ ናኣቶ ሴኤሜና ካኣሜና ያኣፔቴና ዜርፃ ሃይማፓ ዴማ ፓይዲንታዞንሢ ማዓዛ፥ ዬንሢ ሃይሦንሢ ባይሲንቶ ዋኣፆኮ ጊንፃፓ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ያኣፔቴ ናኣታ፦ ጎሜሬ፥ ማጎጌ፥ ማዳያ፥ ያዋኔ፥ ቱባሌ፥ ሜሼኬና፥ ቲራሴ ጌይንታዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ያኣፔቴ ናኣዚ ጎሜሬ ናኣታ ሃሣ ዓሽኬናዜ፥ ሪፓቲና ቶጋርማ ጎዖዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ያዋኔ ናኣታ፦ ዔኤሊሻ፥ ቴርሴሴ ፥ ኪቲሚና ሮዳኒሜ ጎዖዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ዬንሢ ጉቤ ባዞ ዓጮና ዋኣፆ ሳዛ ዓኣ ሳዖናይዳ ናንጋ ያኣፔቴ ዜርፆኮ ሚና ማዢንቶ ማዖንሢኬ፤ ዔያታኣ ፔኤኮ ዓጮና ቶኦኮ ቶኦኮና ፓቂንቲ ናንጋ ዴሬኬ፤ ፔቴ ፔቴ ቶኦካ ጌስታያ ዔያቶኮ ማዔ ሃንጎ ዓሶ ዻንጋፓ ዱማዺ ጌስቲንታ ሙኡቺ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ካኣሜ ናኣታ፦ ኩሼ፥ ሚፂራይሜ ፥ ፑፂንታ ካኣናኔንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ኩሼ ናኣታ ሃሣ ሳኣባ፥ ሃዊላ፥ ሳቢታ፥ ራዒማና ሳቢቴካ ጎዖዞንሢ ማዓዛ ራማ ናኣታ ሳኣባና ዴዳኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ኩሼ ሃሣ ቤርታዺ ዓጮይዳ ፑኡፖ ዖሎና ዔርቴሢ፥ ናምሩዴ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ናምሩዴ ፑኡፒ ኬሞ ዓሲ ማዒ ፆኦሲ ቤርታ ዔርቴሢሮ ዓሳ «ኔና ናምሩዴጉዲ ፑኡፒ ኬማያ ማሆንጎ» ጋዓሢ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ቤርታዺ ናምሩዴ ካኣቱማ ሴናዖሬ ጌይንታ ዓጮይዳ ዓኣ ሃይሦ ካታሞንሢ ጌይፃ፦ ባብሎኔ፥ ዔሬኬኔና ዓካዲኔ ጌይንታ ካታሞ ዓርቃያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ዬካፓ ዒዚ ዓሶኦሬ ጌይንታ ቤዞ ዓኣዻዖ ኔኔዌ፥ ራቦቴንታ ካላሂ ጌይንታ ካታሞ ማዤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ዬያጉዲ ሃሣ ኔኔዌና ካላሂ ጌይንታ ካታሞንሢ ሳዛ ሬሴኔ ጌይንታ ኮሺ ዼኤፖ ካታሞንሢ ዒ ማዤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ሚፂራይሜ ጌይንታሢ ካኣሜ ናኣዚ ዜርፃ፦ ሉዴ፥ ዓናሜ፥ ሌሃቤ፥ ናፕቱሄ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ፔቲሮሴ፥ ፒሊስፄኤሜ ጌይንታ ዜርፃ ኬስኬ ካፕቶሬና ካስሉሄ ጌይንታ ዴሮንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ካኣናኔ ናኣቶኮ ቶይዳሢ ፂዶኔ፥ ሄሌሢ ሄቴ ጌይንታያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ሃንጎ ካኣናኔ ዜርፃ ዔቡሳ ዓሶ፥ ዓሜራ ዓሶ፥ ጌርጌሳ ዓሶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ሂዋዌ ዓሶ፥ ዓርቄ ዓሶ፥ ሴና ዓሶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ዓርዋዳ ዓሶ፥ ፃሚራ ዓሶ፥ ሃማቴ ዓሶ ጎዖዞንሢኬ፤ ሃሣ ጊንፃፓ ኔጌዖ ዱማዼ ካኣናኔ ዓሶ ዜርፃ ዱማ ዱማ ቤዞይዳ ላኣሊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ዬያሮ ካኣናኔ ዓሶ ዓጮኮ ዛጳ ሲዶና ጎዖ ዓጫፓ ዓርቃዖ ዾኦሎ ዛሎና ጌሬሬ ዓጮ ኮይሊና ዴንዲ ጋኣዛ ዓጮ ሄላንዳኣና ዓባ ኬስካ ዛሎና ዴንዲ ሶዶሜ፥ ጋሞራ፥ ዓዳኣማና ባላሻዔ ኮይሊና ዴንዲ ፃቦዬ ጌይንታ ዓጮ ሄላያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ዬንሢ ቢያ ካኣሜ ዜርፆንሢ ማዓዛ ዱማ ዱማ ቶኦኪና ዓጪና ፓቂንቲ ናንጋዖ ፔቴ ፔቴ ቶኦኮኮ ሃንጎዋቶይዳፓ ዱማዺ ጌስቲንታ ሙኡቺ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ያኣፔቴኮ ዒሾ ሴኤሜ ጎዖሢ ዔቦሬ ጌይንታ ዜርፆኮ ማዢንቶ ማዓሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ሴኤሜኮ ናኣታ፦ ዔላኣሜ፥ ዓሶኦሬ፥ ዓርፓክሳዴ፥ ሉዴና ዓራሜ ጎዖዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ዓራሜ ናኣታ፦ ዑፄ፥ ሁሌ፥ ጌቴራና ሜሽኬናናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ዓርፓክሳዴ ጎዖሢ ሼላሂኔ ሾዔኔ፤ ሼላሂኔያ ዔቦሬ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ዔቦሬ ጎዖሢያ ላምዖ ናይ ሾዔኔ፤ ፔቴሢ ሾይንቴ ዎዶና ዴራ ዎሊዳፓ ፓቂንቴሢሮ ዒዛኮ ሱንፃ ፔሌጌ ጌይንቴኔ፤ ሃንጎሢ ሱንፃ ሃሣ ዮቅፃኔ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ዮቅፃኔ ናኣታ፦ ዓልሞዳዴ፥ ሼልፒሃፄርማዊቴ፥ ዬራሄ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ሃዶራሜ፥ ዑዛሌ፥ ዲቂላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ዖባሌ፥ ዓቢማዔኤሌ፥ ሳኣባ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ዖፔሬ፥ ሃዊላና ዮባቤ ጌይንታዞንሢ ማዓዛ ዬያታ ቢያ ዮቅፃኔ ዜርፆኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ዔያታ ናንጌ ቤዛ ዓባ ኬስካ ዛሎና ዓኣ ጌሜራዻ ዓጮ ሜሻ ጌይንታ ቤዛፓ ሴፔራይዴ ጌይንታ ቤዞ ሄላንዳኣናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ዬያታ ቢያ ሴኤሜ ዜርፆንሢ ማዓዛ፥ ዔያታ ዱማ ዱማ ቶኦኪና ዓጪናይዳ ፓቂንቲ ናንጋያኬ፤ ፔቴ ፔቴ ቶኦኮኮ ሃንጎዋቶይዳፓ ዱማዺ ጌስቲንታ ሙኡቺ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ዬንሢ ቢያ ፔኤኮ ዜርፆና ዜርፆና ፓቂንቴ ዴሮ ኖሄ ዜርፆንሢኬ፤ ማዓዛ ባይሲንቶ ዋኣፆኮ ጊንፃፓ ዓጮ ዴራ ቢያ ሙኬሢ ዬንሢ ኖሄ ናኣቶንሢዳፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ቤርታዺ ሳዖይዳ ዓኣ ዴሮኮ ጌስቶ ሙኡጫ ፔቴ ሌሊኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ዓባ ኬስካ ባንፆ ዓሳ ዓኣዼ ዎዶና ባብሎኔ ዓጮይዳ ፔቴ ቦኦሊ ዴንቃዖ ዒኢካ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ዬይ ዓሳ ዎሊ ኮራ፦ «ዔዛታ! ሃኒ ሙኩዋቴ፤ ኮጬ ዼጊሲ ማዦንዶ ዓጪ ዺንቂ ዶዳንዳጉዲ ታሚና ሚቺ ኑ ኪላሶም» ጋዓዖ ማዦንዶ ባኮዋ ጊኢጊሺ ዎላ ዓይሣንዳ ሺዲ ጉዴ ባኣዚያኣ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ዬካፓ ዔያታ፦ «ሃኒ ዬዑዋቴ፤ ፔቴ ካታማ ኑኡኒ ማዦም፤ ሃሣ ቶኦካ ጫሪንጮ ሄላንዳ ዼጌ ቤሲ ዺንቂንቴ ዓጮና ኑኡኒ ማዦም፤ ዬያይዲ ሳዖ ቢያይዳ ኑኡኒ ላኣሊንቲ ዴንዱዋዖ ፔቴይዳ ዴዖም፤ ሃሣ ሱንሢያ ኑ ዔኮም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ዬካፓ ናንጊና ናንጋ ጎዳ ዓሳ ማዤ ካታሞንታ ዼጌ ቤዞዋ ዛጋኒ ኬዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ዒዚ ሂዚ ጌዔኔ፦ «ሃይሾ ሃይ ዴራ ፔቴ ፃጲኬ፤ ጌስቶ ዻንጋኣ ዔያቶኮ ፔቴኬ፤ ሃያ ባኮ ዔያታ ማዼያፓዓቴም ሃካፓ ሴካ ዔያታ ማሌ ባኣዚ ቢያ ማዻኒ ዔያቶ ባሹዋያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ዬያሮ ሃኒ ዬዑዋቴ፥ ኑኡኒ ኬዲ ዔያታ ዎሊና ቡኩዋጉዲ ሙኡጮ ዔቶኮ ኑ ሲኢሮም።» ");
INSERT INTO mdyeth_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ዬካፓ ናንጊና ናንጋ ጎዳ ዓጮ ቢያይዳ ዔያቶ ዜርቄሢሮ ካታሜሎ ማዢፆ ዓሳ ሃሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ካታሜሎኮዋ ሱንፃ «ባብሎኔ» ጌይንቴኔ፤ ዓይጎሮ ጌዔቴ ዒኢካ ፆኦሲ ዴሮኮ ሙኡጮ ሲኢሬሢሮና ዔያቶዋ ዓጮ ቢያይዳ ላኣሌሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ሴኤሜ ዜርፃ ሃይፓ ዴማ ፓይዲንታዞንሢኬ፤ ሴኤሜ ባይሲንቶ ዋኣፆኮ ጊንፃ ላምዖ ሌዔ ዴዓዖ ሌዓ ዒዛኮ ፄኤታ ማዔንቴ ዓርፓክሳዴ ጌይንታ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ዓርፓክሳዴ ሾዔስካፓ ጊንፃ ሴኤሜ ዶንጎ ፄኤታ ሌዔ ናንጋዖ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ዓርፓክሳዴያ ሃይሢታሚ ዶንጎ ሌዔ ኩማዛ፥ ሼላሂ ጎዖ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ዬካፓ ዖይዶ ፄኤታና ሃይሦ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ሼላሂ ሃይሢታሚ ሌዔ ማዓዛ ዔቦሬ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ዬካፓ ዖይዶ ፄኤታና ሃይሦ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ዔቦሬ ሃይሢታሚ ዖይዶ ሌዔ ማዓዛ ፔሌጌ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ዬካፓ ዖይዶ ፄኤታና ሃይሢታሚ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ፔሌጌ ሃይሢታሚ ሌዔ ማዓዛ ሬዑ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ዬካፓ ላምዖ ፄኤታና ታዞጳ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ሬዑ ሃይሢታሚ ላምዖ ሌዔ ማዓዛ ሴሩጌ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ዬካፓ ላምዖ ፄኤታና ላንካይ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ሴሩጌ ሃይሢታሚ ሌዔ ማዓዛ ናኮሬ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ዬካፓ ላምዖ ፄኤታ ሌዔ ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ናኮሬ ላማታሚ ታዞጳ ሌዔ ማዓዛ ታኣራ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ዬካፓ ፄኤታና ታጶ ታዞጳ ሌዔና ናንጊ ሜሌ ዓቲንቄና ዉዱሮ ናይና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ታኣራ ላንካይታሚ ሌዔ ማዔስካፓ ጊንፃ ዓብራሜና ናኮሬና ሃራኔና ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ዓብራሜና ናኮሬና ሃራኔናኮ ዓዶ፥ ታኣራኮ ዜርፃ ሃይፓ ዴማ ፓይዲንታዞንሢኬ፤ ሃራኔ ሎኦፄ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ሃራኔ ዒዛኮ ዓዴ ታኣራ ሼምፖና ዓኣንቴ ዒ ሾይንቴ ካታሞ ዑኡሬይዳ ሃይቄኔ፤ ዑኡሬ ጌይንታ ካታማ ካላዳ ዓሶ ዓጫኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ዓብራሜ ሶኦራ ጎዖ ላኣሌሎ ዔካዛ፥ ናኮሬ ሚልካ ጋዓዞ ዔኬኔ፤ ዒዛ ሂስካኔ ጎዖሢ ሾዔ ሃራኔ ናዎኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ሶኦራ ዞኦኮታሢሮ ናይ ሾዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ታኣራ ፔኤኮ ናኣዚ ዓብራሜንታ ሃራኔ ሾዔ ዒዛኮ ናኣዚ ናዖ ሎኦፄንታ ዓብራሜ ማቾ ሶኦራኣ ዔኪ ባብሎኔይዳ ዓኣ ዓካታሞ ዑኡሬ ሃሺ ካኣናኔ ዓጮ ዓኣዻኒ ዔቄኔ፤ ዒዚ ዴንዲ ካኣራኔ ጎዖ ዓጪ ጌሊ ዒኢካ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ታኣራ ላምዖ ፄኤታና ዶንጎ ሌዔና ማዓዛ ካኣራኔይዳ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ናንጊና ናንጋ ጎዳ ዓብራሜም፦ «ኔ ዓጮ ሃሺ፥ ኔኤኮ ዒጊኖና ዓዶ ማኣሮ ዓሶይዳፓኣ ዱማዺ ታ ኔና ዻዋ ዓጮ ዓኣዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ዜርፆ ታ ኔኤኮ ሚርጊሻንዳኔ፤ ዳልጊ ዴሬያ ማዓንዳኔ፤ ታ ኔና ዓንጃንዳኔ፤ ሱንፆ ታ ኔኤኮ ዔርቴያ ማሃንዳኔ፤ ሜሌ ዓሶማኣ ዓንጆ ኔ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ኔና ዓንጃሢ ታ ዓንጃንዳኔ፤ ኔኤም ጋዳንቃዞንሢም ታ ጋዳንቃንዳኔ፤ ኔ ዛሎና ዴራ ቢያ ዓንጂንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ዓብራሜም ናንጊና ናንጋ ጎዳ ኬኤዜሢጉዲ ካኣራኔ ዓጫፓ ዓኣዻኒ ዒ ኬስካኣና ሌዓ ዒዛኮ ላንካይታሚ ዶንጎኬ፤ ዒዛና ዎላ ጌኤዚ ናኣዚ ሎኦፄያ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ዓብራሜ ፔኤኮ ማቾ ሶኦራንታ ጌኤዚ ናኣዚ ሎኦፄንታ ካኣራኔይዳ ዓኣዖ ቆሌ ቆልሞንታ ዒዛም ማዻ ዓሶዋ ቢያ ዔኪ ዓኣዼኔ። ዔያታ ካኣናኔ ዓጮ ሄላዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ሴኬሜይዳ ዓኣ ጌኤዦ ቤዜሎ፥ ሞኦሬ ጌይንታ ካኣዦም ዱማዼ ሚፃሢ ዓኣ ቤዜሎ ሄላንዳኣና ዓኣዼኔ፤ ዬኖ ዎዶና ካኣናኔ ዓሳ ዬኖ ዓጫ ናንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ናንጊና ናንጋ ጎዳ ዓብራሜም ፔጋዺ ጴዺ፦ «ኔኤኮ ዜርፆም ታ ዒንጋንዳ ዓጬላ ሃኖኬ» ጌዔኔ፤ ዬካፓ ዓብራሜ ዒዛም ፔጋዺ ጴዼ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮንዶ ቤሲ ሹቺና ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ሄሊሳዖ ቤኤቴኤሌ ጌይንታ ዓጮኮ ዓባ ኬስካ ዛሎና ዓኣ ጌሜራዻ ዓጮ ኬስካዖ ቤኤቴኤሌ ዓባ ጌላ ዛላ፥ ዓዪ ጎዖዞ ዓባ ኬስካ ዛላ ማሂ ዓፒላና ማዦ ማኣሮ ፔኤኮ ዾቃዖ፥ ዒኢካ ፆኦሲም ዒንጊ ካኣሽኮ ቤዞ ሹጮና ኮሺ ናንጊና ናንጋ ጎዳኮ ሱንፆዋ ዔኤሊ ዚጊ ካሽኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ቤዛፓ ሜሌ ቤሲ ዒዚ ሃንቲ ሃንቲ ኔጌቤ ጌይንታ ቤዞ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ካኣናኔ ዓጮይዳ ናይዚ ጌላዖ ናያ ዶዲ ዶዲ ዓኣዼሢሮ ዓብራሜ ዬያ ናዮ ዎዶ ዓኣሣኒ ዒዚ ናንጋ ዓጮኮ ሃኬ ዾኦሎ ዛሎና ዓኣ ጊብፄ ዓጮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ዓብራሜ ጊብፄ ዓጮ ጌላኒ ዑካዖ ማቾ ሶኦራ ኮራ፦ «ኔኤኒ ሚርጌና ሚዛጲ ማዔሢ ታ ዔራሢሮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ጊብፄ ዓሳ ኔና ዛጌ ዎዶና ‹ሃና ዒዛኮ ማቾኬ› ጌዒ ታና ዎዺ ኔና ሃሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ዬያሮ ‹ታ ዒዛኮ ጌሮኬ› ኔ ዔያቶም ጌዔቶ ኔጋይቴ ጌይ ታና ዔያታ ዎዹዋዖ ሃሺ ኮሺ ዓኣፒና ታና ዔያታ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ጊብፄ ዓጮ ዔያታ ጌሌ ዎዶና ጎኔና ጊብፄ ዓሳ ዓብራሜኮ ማቻ ሚርጌ ሚዛጲታሢ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ሃሣ ፔቴ ፔቴ ካኣቲኮ ዑኬ ማዒ ማዻ ዓሳኣ ዒዞኮ ሚዛጱሞ ካኣቲም ኬኤዜሢሮ ካኣቲ ማኣሪ ዒዛ ዔኤሊንቲ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ዒዞ ጋይቴ ጌይ ካኣቲ ዓብራሜ ናሽካዖ፦ ማራይ፥ ዋኣሪ፥ ባይ፥ ሃሬ፥ ጋኣላ፥ ዒዛም ማዾ ማዻንዳ ዓቲንቄንታ ላኣሊንታ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ጋዓንቴ ዓብራሜኮ ማቾ ሶኣራ ካኣቲ ዔካኒ ማሊ ዔኤሊሲ ፔ ማኣሪ ዔኪ ዓኣዼሢሮ ናንጊና ናንጋ ጎዳ ካኣቲንታ ዒዛኮ ዑኬ ማዒ ማዻ ዓሶ ቢያሢዳ ፑርታ ሜታሳ ዶርዖ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ዬካፓ ካኣቲ ዓብራሜ ዔኤሊሳዖ ሂዚ ጌዒ ዒዛ ዖኦጬኔ፦ «ሃይ ኔ ታኣም ማዼ ባካ ዓይጎዳይ? ሶኦራ ኔኤኮ ማቾ ማዔሢ ኔ ታኣም ዓይጎሮ ኬኤዚባኣይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‹ታኣኮ ጌሮኬ› ኔ ጌዒ ታ ዒዞ ዔካኒ ዔኤሊሳንዳጉዲ ዓይጎሮ ማሄይ? ሃኣዛጌ፥ ኔኤኮ ማቾ! ዔኪ ኬስኬ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ዬያ ጌይ ካኣቲ ዓይሤ ጎይፆና ካኣቲኮ ዑኬ ማዒ ማዻ ቢታንታ ዓኣ ዓሳ ዓብራሜንታ ማቾንታ ዒዛኮ ዓኣ ቆሎ ቢያሢና ዎላ ዓጫፓ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ዓብራሜ ማቾንታ ዒዛኮ ዓኣ ቆሎዋ ቢያ ዔኪ ጊብፄ ዓጫፓ ኔጌቤ ዓጮ ዓኣዻኣና ሎኦፄያ ዒዛና ዎላ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ዓብራሜ ሚርጌ ቆልሞ፥ ሚርጌ ሚኢሼና ዎርቄና ዓኣ ዖርጎቺ ዓሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ኔጌቤይዳፓ ዔቃዖ ቤዛፓ ሜሌ ቤሲ ሃንቲ ሃንቲ ቤኤቴኤሌ ጎዖ ቤዞ ዓኣዺ ቤኤቴኤሌና ዓዪ ጎዖ ዓጮናኮ ባኣካ ዓኣ ቤዞ ሄሌኔ፤ ዬና ቤዜላ ሃያኮ ቤርታ ዒዚ ዴዔ ቤሲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ጊንሣ ሃሣ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮ ቤዞ ሹጮና ኮሼ ቤሲ ማዔሢሮ ዒኢካ ዓብራሜ ናንጊና ናንጋ ጎዳኮ ሱንፆ ዔኤሊ ካሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ዓብራሜና ዎላ ዓኣዻ ጌኤዚ ናኣዚ ሎኦፄያ ፔ ዛሎና ሚርጌ ማራይ፥ ዋኣሪና ባይና፤ ሃሣ ሚርጌ ማኣሪ ዓሲንታ ዒዛኮ ማዻ ዓሲያኣ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","ዬኖ ዎዶና ዬኖ ዓጮይዳ ናንጋ ዓሳ ካኣናኔ ዓሶና ፔርዜ ዓሶናኬ፤ ሃሣ ዓብራሜና ሎኦፄናኮ ሚርጌ ቆልሞ ዓኣያታሢሮ ዎላ ዔያታ ናንጋኒ ዳንዳዒባኣሴ፤ ዓይጎሮ ጌዔቶ ቆልማ ዎሊ ዑፃ ሄንቃ ቤሲ ባኣሢሮኬ፤ ዬያሮ ዓብራሜና ሎኦፄናኮ ቆልሞ ሄንቃ ዓሶ ባኣካ ዑራ ማዢንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ዬካፓ ዓብራሜ ሎኦፄ ኮራ፦ «ኑኡኒ ዎሊ ማኣሪ ዓሲ ማዔሢሮ ታኣና ኔኤና፤ ሃሣ ኑኡኮ ቆልሞ ሄንቃ ዓሶ ባኣኮይዳኣ ማዖም ዑራ ዔቃኒ ኮይሱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ዬያሮ ኑኡኒ ፓቂንቲ ዱማ ዱማ ናንጌቶ ኮሺኬ፤ ዓጮኮ ኔ ናሽኬ ዛሎ ዓኣዻዛ ታኣኒያ ዓቴ ዛሎ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ዬማፓ ሎኦፄ ዮርዳኖሴ ዎሮ ዓጫ ዓኣ ዶኦጮ ዓጮ ዴንዲ ዞዓሬ ጎዖዞ ሄላንዳኣና ዛጋዖ ናንጊና ናንጋ ጎዳ ኮሼ ቤዞና ጊብፄ ዓጮይዳ ዋኣፃ ኩሚ ዓኣ ቤዞ ጉዴያ ማዔሢ ዴንቄኔ፤ ዬያ ዒ ዛጌሢ ናንጊና ናንጋ ጎዳ ሶዶሜና ጋሞራ ጌይንታ ካታሞንሢ ባይዙዋንቴ ቤርታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ዬያሮ ሎኦፄ ዮርዳኖሴ ዎሮ ዓጫ ዓኣ ዶኦጮ ዓጮ ፔኤም ዔካዖ ዓባ ኬስካ ዛሎ ዓኣዼኔ፤ ያኣዒ ማዔሢሮ ላምዓሢ ዬያይዲ ዱማዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ዓብራሜ ቤዛ፥ ካኣናኔይዳ ዓታዛ ሎኦፄ ጋዓንቴ ዒ ዓኣዼ ቤዛ ዓኣ ካታሞንሢኮ ባኣካ ሶዶሜኮ ዑኬ ዓፒሎና ማዦ ማኣሮ ፔኤኮ ዾቂ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ዬኖ ዎዶና ሶዶሜ ዓሳ ሚርጌ ፑርታ፤ ሃሣ ናንጊና ናንጋ ጎዳ ዻጋሳያ፥ ጎሜ ማዻ ዓሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ሎኦፄ ዱማዺ ዓኣዼስካፓ ናንጊና ናንጋ ጎዳ ዓብራሜም፦ «ኔ ዓኣ ቤዛ ዓኣዖ ዓጮ ጉቤ ሺሪ ዛጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ሃያ ኔኤኒ ዛጋ ዓጮ ቢያ ኔኤና ኔ ዜርፆናም ታ ዒንጋንዳኔ፥ ናንጊና ዒንሢሮ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ኔኤኮ ዜርፆ ሳዖይዳ ታ ማኣሻላጉዲ ሚርጊሻንዳኔ፤ ሳዖ ማኣሻላ ፓይዲንታኒ ዳንዳዒንቱዋኣሢጉዲ ኔኤኮ ዜርፃ ያዺ ፓይዲንቱዋያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ዓካሪ ሃሢ ዓኣዺጋፓ ሳዖ ጉቤ ዛጌ፤ ዓይጎሮ ጌዔቶ ዬያ ቢያ ታ ኔኤም ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ዬያሮ ዓብራሜ ዓፒሎና ማዦና ማኣሮ ፔኤኮ ቱጊ ኬብሮኦኔይዳ ሜሚሬ ጌይንታ ቤዛ ካኣሽኮ ፑኡፖ ሻኣባ ዓኣ ቤዞይዳ ናንጋኒ ዓኣዻዖ ዒኢካ ናንጊና ናንጋ ጎዳም ዒንጎ ባኮ ዒንጊ ካኣሽኮ ቤዞ ሹቺና ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ዬኖ ዎዶና ባብሎኔ ካኣቲ ዓምራፔሌ፥ ዔላሳኣሬ ካኣቲ ዓሪዮኬ፥ ዔላኣሜ ካኣቲ ኬዶራላዖሜሬ፥ ጎይሜ ካኣቲ ቲዲዓሌኬ፤ ዬንሢ ዖይዶ ካኣቶንሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ሜሌ ዶንጎ ካኣቶ ዖላኒ ዓኣዼኔ፤ ዔያታ ዖላኒ ዓኣዼ ዶንጎ ካኣቶንሢያ ሴዶሜ ዓጮ ካኣቲ ቤራዔ፥ ጋሞራ ካኣቲ ቢርሻዔ፥ ዓዳማ ካኣቲ ሺንዓቤ፥ ፃቦዬሜ ካኣቲ ሼምቤሬ ጎዖሢንታ ሱንፃ ዞዓሬ ጌይንታ ቤላዔ ዓጬሎኮ ካኣታሢንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ዬንሢ ዶንጎ ካኣቶንሢ ፔቴ ማዒ ሶኦጌ ባዚ ጌዒ ዔኤሊንታ ሲዲሜ ዶኦጮይዳ ዖሎሮ ቡኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ዬንሢ ዶንጎ ካኣቶንሢ ታጶ ላምዖ ሌዔ ኬዶራላዖሜሬ ጎዖ ዓጮ ካኣቲ ዴማ ባሺንቲ ናንጋዖ ታጶ ሃይሣሳ ሌዖና ጋዓንቴ ዬያ ካኣቲ ዑፃ ዒፂ ዻጋዺ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ታጶ ዖይዳሳ ሌዖና ኬዶራላዖሜሬና ዒዛና ዎላ ፔቴ ማዒ ዖላ ካኣቶሢ ዔያቶኮ ዖላ ዓሶና ዎላ ሙካዖ ሬፓ ዓሶ ዓሽቴሮትቃራናይሜ ጌይንታ ቤዛ፥ ዙዛ ዓሶ ሃማ ጌይንታ ቤዛ፥ ዔማ ዓሶ ቤሼዌቂርያቴማ ጌይንታ ቤዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ሆሬ ዓሶዋ ጌሜራዻ ዓጬሎ ሴዒሬኮ ዓሲ ናንጉዋ ዳውሎ ኮይላ ዓኣ ዔልፓኣራኣኔ ሄላንዳኣና ዖሊ ባሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ዬካፓ ማዒ ቃዴሴ ጎዖ ዓጮ ሙኬኔ፤ ዬኖ ዎዶና ዬኖ ቤዜሎኮ ሱንፃ ዔኒሚሽፓፄ ጌይንታኔ፤ ሃሣ ዓማሌቄ ዓሶ ዓጮ ቢያ ዓርቃዖ ሃፄፆንታማሬ ጌይንታ ቤዛ ናንጋ ዓሞራ ዓጮ ዓሶዋ ዔያታ ዖሊ ባሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ዬካፓ ሶዶሜ፥ ጋሞራ፥ ዓዳማ፥ ፃቦዬሜና ቤላዔ ዓጮ ካኣታ ፔኤኮ ዖላ ዓሶ ሲዲሜ ዶኦጮይዳ ቡኩሲ ዖልቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ዔያታ ዖልቲሢ ዔላኣሜ፥ ጎይሜ፥ ባብሎኔና ዔላሳሬ ዓጮ ካኣቶንሢናኬ፤ ዶንጎ ካኣቶንሢ ዖይዶ ካኣቶንሢና ዎላ ዖልቴሢ ዬያይዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ሲዲሜ ጌይንታ ዶኦጬሎይዳ ሺዶ ማላ ዓልቃ ባኮ ዔካኒ ዼኤፒ ቦኦኮና ሚርጌ ዔቴ ዓኣንቴ ሶዶሜና ጋሞራና ካኣቶንሢ ዖሎይዳፓ ዓኣሺንቲ ቶሎሮ ጌዒ ጳሽካዖ ዬያ ዔቶይዳ ሎኦማዛ፥ ዓቴ ሃይሦ ካኣቶንሢ ዹኮ ዓኣሺንቲ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ዖይዶ ካኣቶንሢ ሶዶሜና ጋሞራና ካታሞይዳ ዴንቄ ባኮ ቢያ ሙኡዚያ ሃሹዋዖ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ሎኦፄያ ሶዶሜይዳ ናንጋሢሮ ዒዛንታ ዒዛኮ ቆሎንታ ቢያ ዲዒ ዔኪ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ዒማና ፔቴ ዓሲ ዖላፓ ዓሺንቲ ቶሊ ሙካዖ ማዔ ባኮ ቢያ ዔብሬ ዓሢ ዓብራሜም ኬኤዜኔ፤ ዬኖ ዎዶና ዓብራሜ ናንጋሢ ዓሞራ ዓሢ ሜሚሬሮ ማዔ ካኣሽኮ ሻኣቦኮ ኮይላኬ፤ ዬያ ሜሚሬ ጎዖሢና ዒዛኮ ላምዖ ጌርሲንሢ ማዔ ዓሽኮሌና ዓኔሬና ዓብራሜኮ ዖሎ ዎዶና ዎሊ ሃሻዓ ጌዒ ጫኣቄ ላጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ዓብራሜ ፔኤኮ ጌኤዚ ናኣዚ ሎኦፄ ዲዒንቲ ዔኪንቴሢ ዋይዛዖ ዒዛኮ ማኣራ ሾይንቲ ዖላኒ ዳንዳዓ ሃይሦ ፄኤታና ታጶ ሳሊ ዓሲ ዓንጋሞና ጊኢጊሺ ዬንሢ ጌኤዚ ናኣዚ ዲዒ ዔኪ ዓኣዼያ ዖይዶ ካኣቶንሢ ጊንፆ ዳኣኔ ጎዖ ቤዞ ሄላንዳኣና ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ዒኢካ ዒ ዔኪ ሙኬ ዓሶ ፓቂ ፓቂ ዬንሢ ካኣቶንሢና ዹማ ዖሎ ዓርቃዖ ዔያቶ ባሺ ዴማስቆ ጎዖ ዓጬሎኮ ዓባ ኬስኪ ጌላ ዛሎኮ ኬዶ ዛሎና ዴንዲ ሆባ ጎዖ ቤዞ ሄላንዳኣና ዬያቶ ዳውሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ዲዒንቲ ቤርታ ዔኪ ዓኣዺንቴ ባኮ ቢያ፤ ሃሣ ዒዛኮ ጌኤዚ ናኣዚ ሎኦፄና ዒዛኮ ቆልሞና ዎላ፥ ጊዳ ጊንሣ ዔያቶና ዎላ ላኣሊንታ ሜሌ ቱኡሲ ዓሲንታ ማሂ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ዓብራሜ ዶርላዖሜሬና ዔያቶና ዎላ ዓኣ ካኣቶ ዖሎና ባሺ ማዓዛ ሶዶሜ ዓጮ ካኣቲ «ካኣቲ ዶኦቺ» ጌይንቲ ዔኤሊንታ ሼዌሄ ጎዖ ዶኦጫ ዒዛ ጎይሢና ዔካኒ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ዼኤፖ ፆኦዛሢም ማዻ ቄኤሴ ማዔያ ሳላሜ ዓጮ ካኣቲ ጌይንታ፥ ሜልኬ ፃዲቄ ዓብራሜም ካሣና ዎይኔፓ ኮሾና ዑሺና ዓኪ ሙካዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ዓብራሜ ሂዚ ጌዒ ዓንጄኔ፦ «ጫሪንጮና ሳዖና ማዤ ዼኤፖ ፆኦዛሢ ዓብራሜ ዓንጆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ኔና ዒፃ ኔኤኮ ሞርኮ ዑፆይዳ ባሺፆ ኔኤም ዒንጌ ዼኤፖ ፆኦዛሢ ጋላቲንቴያ ማዖንጎ።» ዒማና ዓብራሜ ዲዒ ዔኪ ሙኬ ባኮ ቢያኮ ታጶይዳፓ ፔቴ ታጶይዳፓ ፔቴ ዔኪ ሜልኬ ፃዲቄም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ሶዶሜ ካኣቲያ ዓብራሜም፦ «ኔ ዲዒ ዔኬ ባኮ ቢያ ኔኤሮ ዔካዖ ታ ዓሶ ታኣም ማሄ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ዓብራሜ ዒዛም ማሃዖ፦ «ጫሪንጮና ሳዖና ማዤ ዼኤፖ ፆኦዛሢ ሱንፆና ታ ኔኤም ጫኣቃኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ኔኤኒ ‹ዓብራሜ ዖርጎቼሢ ታናኬ› ጎዑዋጉዲ ሜሌ ዓታዛ ፔቴ ሼኤሜታቶዋ ዱርዞ ቱኮስካፓታቴያ ፔቴ ሱሲታዖ ታኣኒ ኔጊዳፓ ዔኪንዱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ዬያሮ ታኣሮ ጌዒ ዓይጎ ባኣዚያ ታ ዔካዓኬ፤ ታ ዓሳ ሙዔዞንሢፓ ዓታዛ ሜሌ ታ ኮዑዋሴ፤ ሃሣ ዬያጉዲ ታኣኮ ዖሎ ላጎንሢ ዓኔሬ፥ ዓሽኮሌና ሜሚሬና ዔያቶ ሄላዞንሢ ሌሊ ዔያታ ዔኮንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ዬካፓ ዓብራሜ ፆኦሲ ዒዛ ፔጋሲ ዻዌ ባኣዚ ዛጌኔ፤ ናንጊና ናንጋ ጎዳ ዒዛ ኮይላ፦ «ዓብራሜ! ዒጊጪፖ፥ ታ ኔኤኮ ጊቲማ ማዒ ፑርታ ባኣዚፓ ቢያ ካፓንዳኔ፤ ሚርጌ ኮሺ ባኣዚ ታ ኔኤም ዒንጋንዳኔ» ጋዓንቴ ዒዚ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ዓብራሜ ማሃዖ፦ «ቢያሢኮ ጎዳ ማዔ ታ ጎዳሢዮ! ናይ ታኣኮ ባኣሢሮ ኔ ታኣም ዒንጋ ሚርጌ ኮዦ ባካ ዓይጎ ታኣም ማዻንዳይ? ታና ዻካላንዳሢ ዴማስቆ ዓጮ ዓሢ ዔላዜሬ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ፔቴታዖ ታኣም ኔኤኒ ናይ ዒንጊባኣሢሮ ታና ዻካላንዳሢ ዬያ ታኣኮ ማዾ ማዻ ዓሶይዳፓ ፔቴሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ዬካፓ ጊንሣ ናንጊና ናንጋ ጎዳ ዓብራሜም፦ «ሃይ ዔላዜሬ፥ ኔኤኮ ማዻሢ ኔና ዻካላዓኬ፤ ኔጊዳፓ ሾይንታንዳ ናዓሢ ኔና ዻካላንዳኔ» ጌዒ ኬኤዛንቴ ዒ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ዬካፓ ናንጊና ናንጋ ጎዳ ዓብራሜ ካሮ ባንሢ ዔኤሊ ኬሳዖ፦ «ሂንዳ ሌካ ጫሪንጮ ዛጌ፤ ዦኦጋሢ ፓይዳኒ ኔ ዳንዳዓቴ ሂንዳ ፓይዴ፤ ዓካሪ ኔኤኮ ዜርፃ ዬያጉዲ ሚርጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ናንጊና ናንጋ ጎዳ ዒዛም ዬያ ማዻንዳሢ ዓብራሜ ጉሙርቄኔ፤ ፆኦሲያ ዒዛኮ ጉሙርቂፆና ዎዛዺ ዒዛ ፔ ዓሲ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ዬካፓ ፆኦሲ ዓብራሜም፦ «ሃኖ ዓጬሎ ኔና ዻካልሳኒ ዑሬ ጌይንታ ካላዳ ዓሶ ዓጮይዳፓ ኔና ዔኪ ኬሴ ናንጊና ናንጋ ጎዳሢ ታናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ዓብራሜ ጋዓንቴ ናንጊና ናንጋ ጎዳ ኮራ፦ «ቢያሢኮ ጎዳ ማዔ ታ ጎዳሢዮ! ሃና ዓጬላ ታኣም ማዓንዳሢ ዎዲ ታ ዔራንዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ናንጊና ናንጋ ጎዳሢያ ዒዛም፦ «ሃይሦ ሃይሦ ሌዔ ማዔያ ፔቴ ማሮ፥ ፔቴ ዋኣሪ፥ ፔቴ ማራይና ሃሣ ኪሬንታ ዶኦሌንታ ዔኪ ታኣም ሙኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ዓብራሜያ ፆኦሲ ዒዛ ዓይሤሢ ቢያ ዔኪ ሙካዖ ቆልሞ ሹኪ ፓቂ ፓቂ ፓቂንቴሢያ ዎሊ ቤኤዚ ላምዖ ቤስካ ጌሤኔ፤ ካፖንሢ ጋዓንቴ ቲቃዖ ፓቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ሃምፑራሢ ቲቂንቴ ዓሽኮ ሙዓኒ ሙካኣና ዓብራሜ ዳውሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ዓባ ጌላኒ ዑካኣና ዓብራሜ ሃሃይቄጉዲ ጊንዔኔ፤ ሃሣ ሚርጌ ዒጊቹሞና ዲቃቲሢና ዒዛይዳ ጌሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ናንጊና ናንጋ ጎዳ ዓብራሜም፦ «ኔኤኮ ዜርፃ ዓሲ ዓጪዳ ቤቲ ሙኬ ዓሲ ማዓንዳኔ፤ ዒኢካ ዔያታ ካራሙሞና ሃሣ ሄርቂ ዎይሦ ዎይሥሢና ሜታዺ ዖይዶ ፄኤታ ሌዔ ናንጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ዔያቶ ካራሙሞና ዎይሣ ዓጮ ዓሶይዳ ፑርታ ዎጌ ታኣኒ ዎጋንዳኔ፤ ዬካፓ ኔኤኮ ዜርፃ ሚርጌ ቆሎ ዔኪ ዬኖ ዓጫፓ ኬስካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ኔኤኒ ጋዓንቴ ሚርጌ ሌዔ ናንጊጋፓ ሜታ ባኣያ ሃይቂ ዱኡታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ኔኤኮ ዜርፃ ሃኖ ዓጮ ማዒ ሙካንዳሢ ዖይዶ ሾይንቲኮ ጊንፃፓኬ፤ ዴንዲ ዬያ ሄላንዳኣና ዔያታ ናንጋንዳሢ ሃሢ ሃካ ዓኣ ዓሞራ ዓሶኮ ጎማ ኮሺ ሚርጌም ሜቶና ታ ዔያቶ ጳርቂ ኬሳንዳሢ ሄላንዳኣናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ዓባ ጌሊ ሃባርታኣና ናኣቦይዳፓ ኬስካ ጩቢና ዔኤታ ታሚ ሎስታ ጴዺ፥ ቲቂ ፓቂ ፓቂ ጌሦና ዓሽኮኮ ባኣኪና ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ዬኖ ኬሎና ናንጊና ናንጋ ጎዳ ዓብራሜም፦ «ጊብፄ ዓጮ ዛጳፓ ዴንዲ ዔፕራፂሴ ዎሮ ሄላንዳኣና ዓኣ ዓጮ ቢያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ዬያጉዲ ቄና ዓሶ ዓጮ፥ ቄኔዛ ዓሶ ዓጮ፥ ቃዶሞኔ ዓሶ ዓጮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ሂታ ዓሶ ዓጮ፥ ፔርዛ ዓሶ ዓጮ፥ ሬፓ ዓሶ ዓጮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ዓሞራ ዓሶ ዓጮ፥ ካኣናኔ ዓሶ ዓጮ ጌርጌሳና ዒያቡሳና ዓሶ ዓጮ ቢያ ታ ኔ ዜርፆም ዒንጋንዳኔ» ሂዚ ጌዒ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ዓብራሜኮ ማቻ ሶኦራ ሃጊ ናይ ሾዒባኣያኬ፤ ዒማና ዒዞም ማዻያ ዓጋኣሮ ጌይንታ ጊብፄ ዓጪ ናይስኬና ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ዬያሮ ዓብራሜኮ ማቻ ሶኦራ ዓብራሜ ኮይላ፦ «ሃኣዛጌ፥ ናንጊና ናንጋ ጎዳ ታና ናይ ሾዑዋጉዲ ላኣጌኔ፤ ኔኤኒ ሃኖ ታኣም ማዻዞና ላሄ፤ ታኣኒ ዒዞ ዛሎና ጎዖንቴ ናይ ዴንቃንዳያናንዳኔ» ጋዓዛ፥ ዓብራሜያ ማቻ ጌዔሢ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ዬያሮ ሶኦራ ዒዞኮ ማዻ ጊብፄ ዓጮ ናዔሎ ዓጋኣሮ ዓብራሜ ዔካንዳንጉዲ ዒንጌኔ። ዬይ ያዺ ማዔሢ ዓብራሜ ካኣናኔ ዓጮይዳ ታጶ ሌዔ ናንጌስኬፓ ጊንፃኣኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ዓብራሜ ዓጋኣሮ ዔካዛ ጎጳዼኔ፤ ዒዛ ፔኤኮ ጎጶ ዔሬ ዎዶና ማኣሮ ዒንዶ ሶኦራ ዑፃ ዖቶርቂ ዒዞ ቦሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ዬያሮ ሶኦራ ዓብራሜ ኮራ፦ «ዓጋኣራ ታና ቦሃንዳጉዲ ማዻሢ ኔናቲ፤ ኔኤም ዒዞ ዒንጌሢ ታናኬ፤ ዒዛ ጋዓንቴ ጎጳዼሢዳፓ ዓርቃዖ ታና ቦሃኔ፤ ሃሢ ታኣና ኔኤናናይዳፓ ፒዜማ ዖናታቴያ ናንጊና ናንጋ ጎዳ ዎጎንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ዓብራሜያ ማሃዖ፦ «ኮሺኬ፤ ዒዛ ኔኤም ማዻያ ኔ ዴማ ዓኣያ ማዔሢሮ፥ ኔ ኮዔ ባኣዚ ዒዞ ዑፃ ማዼ» ጌዔኔ። ዬካፓ ሶኦራ ዓጋኣሮ ሚርጌ ሜታሴሢሮ ዓጋኣራ ማኣራፓ ቤቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ናንጊና ናንጋ ጎዳኮ ኪኢታንቻ ዓጋኣሮ ዓሲ ናንጉዋ ዳውሎይዳ ፔቴ ዓልቃ ዋኣሢ ኮርካ ዓኣንቴ ዴንቄኔ፤ ዬና ዓልቃ ዋኣፄላ ሹሬ ጎዖ ዓጮ ባንሢ ዔኪ ዓኣዻ ጎይፆይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ናንጊና ናንጋ ጎዳኮ ኪኢታንቻሢ፦ «ሶኦራም ማዾ ማዻ ዓጋኣሬ! ዎካፓ ኔ ሙኬይ? ዎኒም ኔ ዴንዳይ?» ጌዒ ዖኦጬኔ። ዒዛኣ ማሃዖ፦ «ማኣሮ ዒንዶ ሶኦራ ኮራፓ ታ ቤቲ ዴንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ናንጊና ናንጋ ጎዳኮ ኪኢታንቻሢ፦ «ኔ ዒንዶ ኮራ ማዒ ዴንዲጋፓ ዒዞም ማዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ቃሳዖ ሃሣ፦ «ዖኦኒያ ፓይዳኒ ዳንዳዑዋያ ማሂ ዜርፆ ታ ኔኤኮ ሚርጊሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ኔኤኒ ሃሢ ጎጲናኬ፤ ዓቲንቄ ናይ ኔ ሾዓንዳኔ፤ ናንጊና ናንጋ ጎዳሢ ኔ ዖዪ ዬኤኬሢ ዋይዜሢሮ ሱንፆ ዒዛኮ ዒስማዔኤሌ ጌዒ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ጋዓንቴ ኪርሞሌጉዲ ማዒ ዒዚ ዓሲ ቢያ ዒፃንዳኔ፤ ዓሲያ ዒዛ ዒፃንዳኔ፤ ዬያፓ ዔቄያና ዒዚ ፔኤኮ ዒጊኖ ዒፂ ዱማዺ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ዓጋኣራኣ፦ «ጎኔና ታና ዛጋ ፆኦሲ ታ ዛጊ ዎይቲ ሼምፔና ዓቴይ?» ጌዒ ዒዞና ጌስቴ ናንጊና ናንጋ ጎዳሢኮ ሱንፆ «ዒልሮዒ» ጌዔኔ፤ ዬኖኮ ቡሊፃ «ታና ዛጋ ፆኦሲ ታ ዛጌኔ» ጌይሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ዬያሮ ዓሳ ቃዴሴና ባሬዴ ዓጮናኮ ሳዛ ዓኣ ዔቶ ዋኣፆ «ቢዔርላሃይሮዒ» ጌዒ ሱንሢ ጌሤኔ፤ ዬኖኮ ቡሊፃ «ሃይቁዋያ ማዒ ናንጊና ናንጋ ታና ዛጋ ታ ጎዳሢ ዔቴ ዋኣሢ» ጌይሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ዓጋኣራ ዓብራሜም ዓቲንቄ ናይ ሾዔኔ፤ ዒዛ ሾዔ ናዓሢኮ ሱንፆ ዓብራሜ «ዒስማዔኤሌ» ጌዒ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ዓብራሜኮ ዬኖ ዎዶና ሌዓ ሳሊታሚ ላሆኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ዓብራሜኮ ሌዓ ታዞጲታሚ ታዞጳ ማዔ ዎዶና ናንጊና ናንጋ ጎዳ ዒዛና ካኣማዖ «ታኣኒ ቢያ ባኣዚ ዳንዳዓ ፆኦሲኬ፤ ኔኤኒ ታኣም ዓይሢንቲሢና ቢያ ዎዴ ፒዜ ማዔ ባኣዚ ማዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ታ ኔኤና ዎላ ጫኣቁሞ ጫኣቃንዳኔ፤ ዜርፆዋ ታ ኔኤኮ ኮሺ ሚርጊሻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ዓብራሜ ባሊቶና ሳዖ ሄሊሲ ዚጊ ፆኦሲ ካኣሽካዛ ፆኦሲያ ዒዛም ሂዚ ጌዔኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«ኔኤም ታ ጫኣቃ ጫኣቁማ ሃያኬ፤ ሚርጌ ዴሬኮ ዓዶ ታ ኔና ማሃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ሚርጌ ዴሬኮ ዓዶ ታ ኔና ማሃንዳሢሮ ሃይፓ ሴካ ሱንፃ ኔኤኮ ዓብራሜ ጌይንቲፃ ዓቴም ዓብራሃሜ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ሚርጌ ዴሬ ማዓንዳያ ሄላንዳኣና ዜርፆ ታ ኔኤኮ ሚርጊሻንዳኔ፤ ካኣቶ ማዓያኣ ዔያቶ ባኣካፓ ኬስካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","«ኔኤና ኔኤኮ ዜርፆና፥ ሃሣ ሙካ ሾይንቶና ዎላ ታኣኮ ጫኣቁሞ ታ ናንጊና ዶዲሻንዳኔ፤ ዬያይዲ ኔኤና ኔኤኮ ጊንፃ ሙካ ዜርፆናኮ ታኣኒ ፆኦሲ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ሃሢ ኔ ሾኦቹሞና ናንጋ ሳዔሎ ኔኤና ኔ ዜርፆናም ታ ዒንጋንዳኔ፤ ካኣናኔ ዓጮ ናንጊና ዻካላንዳጉዲ ታ ኔኤኮ ዜርፆም ዒንጋንዳኔ፤ ታኣኒያ ዔያቶኮ ፆኦሲ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ላሚ ሃሣ ዓብራሃሜም ፆኦሲ ሂዚ ጌዔኔ፦ «ኔኤና ኔኤኮ ጊንፃ ሙካንዳ ዜርፆና ኔኤኒ ታኣና ዎላ ጫኣቄ ጫኣቁሞ ሾይንቲዳፓ ሜሌ ሾይንቲ ሄላንዳኣና ካፑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ኔናንታ ኔኤኮ ጊንፃ ሙካንዳ ዜርፆንታ ዒንሢ ካፓንዳ ጫኣቁማ ሃያኬ፤ ዒንሢ ባኣካ ዓኣ ዓቲንቄ ቢያ ዓቲንቶ ቤርቶ ቲቂንታንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ዒንሢኮዋ ዓቲንቶ ቤርቶ ቲቁዋቴ፤ ዬይ ታኣና ዒንሢናኮ ሳዛ ዓኣ ጫኣቁሞኮ ማላቶኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ሙካ ሾይንቶይዳ ዓቲንቄ ናይኮ ቢያ ሾይንቴስካፓ ሳላሳ ኬሎና ዓቲንቶ ቤርታ ቲቂንቶንጎ፤ ዬያጉዲ ማኣራ ዒንሢኮ ሾይንቴሢንታ ዙላፓ ሚኢሼና ሻንቂንቲ ሙኬ ካራማኣ ዓቱዋዖ ቲቂንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","«ታኣኮ ጫኣቁማ ናንጊና ዒንሢና ናንጋያ ማዓሢ ዔርዛኒ ዓሽኮይዳ ማላታ ማዓንዳጉዲ ፔቴ ፔቴ ዓቲንቃ ዓቲንቶ ቤርቶ ቲቂንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ዓቲንቶ ቤርታ ቲቂንቲባኣ ዓቲንቄ ናይ ቢያ ታኣኮ ጫኣቁሞ ቦንቺባኣሢሮ ታኣኮ ዴሮይዳፓ ፔቴያ ማዒ ፓይዲንታዓኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ፆኦሲ ዓብራሃሜም ሂዚ ጌዔኔ፦ «ሃይፓ ሴካ ማቾ ኔኤኮ ሶኦራ ጌዒ ዔኤሊፖ፤ ሃናፓ ዓርቃዖ ዒዞኮ ሱንፆ ሳኣራ ጌዒ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ዒዞዋ ታኣኒ ዓንጃንዳኔ፤ ዒዛ ኔኤም ዓቲንቄ ናይ ሾዓንዳኔ፤ ታ ዒዞ ዓንጃንዳሢሮ ሚርጌ ዴሬኮ ዒዛ ዒንዶ ማዓንዳኔ፤ ዒዞኮ ዜርፆይዳፓ ካኣቶ ማዓያ ኬስካንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ዓብራሃሜ ባሊቶ ሳዖ ሄሊሲ ዚጊ ፆኦሲ ካሽኬኔ፤ ጋዓንቴ «ሌዔ ፄኤታ ማዔ ዓሲ ናይ ሾዓ ባኣዚዳ? ሃሣ ታ ማቾ ሳኣራኮዋ ሌዓ ታዞጲታሚ ማዔሢሮ ሾዓኒ ማይ ዳንዳዓ?» ጌዒ ማሊ ሚኢጫዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ፆኦሲ ኮራ፦ «ዒስማዔኤሌ ኔ ታኣም ዓንጄቶ ታና ዻካላኒ ዳንዳዑዋዓዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ፆኦሲያ ዒዛም ማሃዖ፦ «ያዺ ማዓዓኬ፤ ማቻ ሳኣራ ኔኤኮ ዓቲንቄ ናይ ሾዓንዳኔ፤ ሱንፆዋ ዒዛኮ ኔ ዪሳኣቄ ጌይ ጌሣንዳኔ፤ ታኣኮ ጫኣቁሞ ዒዛና ዒዛኮ ዜርፆና ዎላ ናንጊና ታ ዶዲሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ዒስማዔኤሌ ዛሎ ታና ኔ ሺኢቄሢ ታ ዋይዜኔ፤ ዒዛኣ ታ ዓንጃንዳኔ፤ ሚርጌ ናይ ታ ዒዛም ዒንጋንዳኔ፤ ዜርፆዋ ታ ዒዛኮ ኮሺ ሚርጊሻንዳኔ፤ ዒዛይዳፓ ታጶ ላምዖ ሱኡጌ ኬስካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ጋዓንቴ ሙካ ሌዓ ሃይማ ዎዶና ሳኣራ ኔኤም ሾዓንዳ ናዓሢ፥ ዪሳኣቄና ዎላ ታኣኮ ጫኣቁሞ ታ ዶዲሻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ዬያይዲ ፆኦሲ ዓብራሃሜና ዎላ ጌስታዖ ዱማዺ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ፆኦሲ ዓይሤሢጉዲ ዓብራሃሜ ዬኖ ኬሎና ናዖ ዒስማዔኤሌኮ፤ ሃሣ ማኣሮይዳ ሾይንቴ ማዾ ማዻ ዓይሎ ቢያሢኮ፤ ዬያጉዲ ዙላፓ ሚኢሾና ሻንቆና ዓይላኣ ዓቱዋንቴ ዒዛኮ ማኣራ ዓኣ ዓቲንቆ ቢያሢኮ ዓቲንቶ ቤርቶ ቲቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ዓብራሃሜያ ፔ ዓቲንቶ ቤርቶ ቲቂንታኣና ዒማና ሌዓ ዒዛኮ ታዞጲታሚ ታዞጳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ናኣዚ ዒስማዔኤሌኮ ዓቲንቶ ቤርታ ቲቂንቴ ዎዶና ታጶ ሃይሦ ሌዔ ናይ ማዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ላምዓሢ ቲቂንቴሢ ፔቴ ኬሊዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ዬያጉዲ ዒዛኮ ማኣራ ሾይንቴ ዓይሌ ማዒ ማዻ ዓቲንቆንታ ዙላፓ ሚኢሾና ሻንቆና ዓይሎ ማዔ ዓቲንቃኣ ቢያ ዒዛና ዎላ ቲቂንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ሜሚሬ ጌይንታ ቤዞይዳ ካኣሽኮ ሻኣቦንሢ ዓጫ ናንጊና ናንጋ ጎዳ ዓብራሃሜም ጴዼ ጎይፃ ዬያይዲኬ፤ ፔቴ ኬሊ ዓብራሃሜ ዓቢ ዹኡሲ ዓፒላና ማዢንቴ፥ ዒዚ ናንጋ ማኣሮ ካራ ዴዒ ዓኣዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ዼጊ ጌዒ ዛጋንቴ ሃይሦ ዓሲ ዔቂ ዓኣያ ዒዛም ጴዼኔ፤ ዬካፓ ዑኬና ዔያቶና ጌስታኒ ዔያቶ ባንሢ ጳሽካዖ ባሊታ ሳዖ ሄላንዳኣና ሂርኪ ጌዒ ዚጊ ቦንቾ ዔኤሊሢ ዔያቶ ዔኤሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ዒማና ዒዚ ዔያቶም፦ «ታ ጎዳቲዮቴ! ዒንሢ ታኣኮ ኮይሌና ዓኣዹዋጉዲ ታ ዒንሢ ሺኢቃኔ፤ ሃይሾ ታኣኒ ዒንሢ ሾኦቺንሣኒ ጊኢጊንቲ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ቶኮ ዒንሢ ማስታንዳ ዋኣሢ ታኣኒ ዔኪ ሙካንዳኣና ዒንሢ ሃኖ ሚፄሎ ሺባ ሃውሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ታና ዒንሢኮ ዓይላሢ ኮራ ዒንሢ ሙኬሢ ታና ኮሺ ዎዛሴኔ፤ ዬያሮ ዒንሢ ሃንታ ዎዶና ዎልቄ ዒንሢም ዒንጋንዳጉዲ ዻካ ሙኡዚ ዔኪ ሙኪ ታ ዒንሢም ዒንጋንዳኔ» ጋዓዛ፥ ዔያታ «ኮሺኬ፤ ኔ ጌዔሢጉዴያ ማዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ዓብራሃሜ ዓፒሎና ማዦና ፔኤኮ ማኣሮ ባንሢ ጳሽካዖ ሳኣራም፦ «ሩኡሪና ሃይሦ ሻንባ ዺኢሊ ዔኪጋፓ ላኣዳ ላኣዴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ዬካፓ ዓብራሃሜ ፔኤኮ ቆልሞ ባንሢ ዴንዳዖ ሃጊ ዔቃያ ቃራ ዎፓና ባኣቶ ባኣካፓ ዶኦሪ ዔኪ ዒዛኮ ማዾ ማዻሢም ዒንጋዛ ዬይ ማዾ ማዻሢ ሩኡሪና ሹኪ ዓሽኮ ቲቂ ጊኢጊሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ዓብራሃሜ ዬያ ዓሽኮንታ ዣሺንታ ዲኢቂ ሜጲያ ዔኪ ዓኣዺ ሾኦጮንሢም ሺኢሺ ዒንጌኔ፤ ዬያ ዔያታ ሙዖ ሙዓኣና ዓብራሃሜ ሚፆ ዴማ ዔያቶ ኮራ ዔቂ ዔያቶ ሾኦቺንሣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ዔያታ ዒዛ ኮራ፦ «ኔ ማኣሮ ዒንዳ፥ ሳኣራ ዎካዳይ?» ጌዔኔ። ዒዚያ ማሃዖ፦ «ሃካ ሶ ጋራኣኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ሃይሦ ሾኦጮይዳፓ ፔቴይ ዓብራሃሜ ኮራ፦ «ሶ ሌዖኮ ሃይማ ዎዴ ማዓኣና ታኣኒ ማዒ ሙካንዳኔ፤ ዬኖ ዎዶና ኔኤኮ ማቻ ሳኣራ ዓቲንቄ ናይ ሾዓንዳኔ» ጌዔኔ። ዬይ ዓሢ ሂዚ ጌዒ ኬኤዛኣና ሳኣራ ዓፒላፓ ማዦና ማኣሮ ጌሎ ካራ ዓሢኮ ጊንፆ ዛሊና ዔቂ ዋዋይዛኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ዓብራሃሜና ሳኣራና ሾውዋዖ ሚርጌ ሌዔ ናንጊ ጊምፔያታሢሮ ሳኣራ ሾይቺ ዱጴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ዬያሮ ሳኣራ፦ «ታኣኒ ማይ ሃያይዲ ጋርቺ ላቤስካፓ ዓቲንቄና ሾዓንዳኖ? ሃሣ ታ ጎዳሢ ዓብራሃሜያ ሃያይዲ ጋርቼምሞ?» ጌዒ ማላዖ ሚኢጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ናንጊና ናንጋ ጎዳ ዓብራሃሜ ኮራ፦ «‹ሃኣዒዲ ታ ጋርቼስካፓ ናይ ሾዓኒ ዳንዳዓ?› ጌዒ ሳኣራ ዓይጎሮ ሚኢጬይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ናንጊና ናንጋ ጎዳሢ ባሻ ባኣዚ ናንጊዳ? ታኣኒ ኔኤም ኬኤዜሢጉዴያ ሶ ሌዖ ሃይማ ዎዴ ማዓኣና ማዒ ታ ሙካንዳኔ፤ ዬኖ ዎዶና ሳኣራ ዓቲንቄ ናይ ሾዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ሳኣራ ሚርጌና ዒጊጬያታሢሮ፦ «ታኣኒ ሚኢጪባኣሴ» ጌዔኔ። ዒዚ ጋዓንቴ «ኔ ሚኢጬሢ ጎኔኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ዬካፓ ዓሶንሢ ዓኣዻኒ ዔቄኔ፤ ዴንዲቤቃ ሶዶኦሜ ዓጮ ሊካ ዛጊንታ ፔቴ ቤሲ ሄሌኔ፤ ዬማ ሄላንዳኣና ዓብራሃሜ ዔያቶ ጎይሣ ዓኣሣኒ ዎላ ዓኣዻኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ናንጊና ናንጋ ጎዳ ፔ ማሊሢና፦ «ታኣኒ ማዻንዳ ባኮ ዓብራሃሜም ዓኣቻዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ዓብራሃሜኮ ዜርፃ ሚርጌ ዺቢ ዴሬ ማዓንዳኔ፤ ዒዛ ዛሎና ሳዖይዳ ዓኣ ዴራ ቢያ ዓንጂንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ጌኤሺ ማዒ ሃሣ ፒዙሞና ዎጊ ዎጊ ዒዛኮ ናኣቶና ማኣሮ ዓሶና ናንጊና ናንጋ ጎዳኮ ጎይፆ ካፓንዳጉዲ ዞሪ ዔኪ ዓኣዾም ጌዒ ታኣኒ ዒዛ ዶኦሬኔ፤ ናኣታ ዒዛኮ ዬያ ማዺ ኩንሤቶ ታኣኒ ዓብራያሜም ማዻንዳኔ ጌዒ ጫኣቄ ጫኣቁሞኮ ሃጊ ማዓንዳ ዎዞ ቢያ ታ ኩንሣንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ሄሊሳዖ ናንጊና ናንጋ ጎዳ ዓብራሃሜም ሂዚ ጌዔኔ፦ «ሶዶኦሜና ጋሞኦራና ዓጮ ዴራ ማዻ ፑርቶ ማዾ ታ ዋይዜኔ፤ ጎማኣ ዔያቶኮ ኮሺ ሚርጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ዔያቶ ዛሎ ታኣኒ ዋይዜ ባካ ቢያ ጎኔ ማዒፆ ዔራኒ ዔያቶ ባንሢ ታ ዴንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ዬካፓ ሃይሦ ሾኦጮንሢዳፓ ላምዖንሢ ሶዶኦሜ ዓጮ ባንሢ ዓኣዺፆ ዔቃዛ ናንጊና ናንጋ ጎዳ ዓብራሃሜና ዎላ ዔቂ ዓኣንቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ዓብራሃሜ ናንጊና ናንጋ ጎዳ ባንሢ ዶጪ ሂዚ ጌዔኔ፦ «ጎኔና ፑርታ ማዺባኣ ኮዦ ዓሶ ጎሞ ዓሶና ዎላ ኔ ባባይዛንዳ? ");
INSERT INTO mdyeth_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ካታሜሎይዳ ዶንጊታሚ ኮሺ ዓሲ ዓኣቶ ካታሜሎ ጉቤ ኔኤኒ ባይዛንዳ? ዶንጊታሞ ኮዦ ዓሶ ዛሎሮ ጌዒ ካታሜሎ ባይዚፆ ሃሻዓዳ? ");
INSERT INTO mdyeth_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ፑርቶ ማዺባኣ ኮዦ ዓሶ ጎሞ ዓሶና ዎላ ኔኤኒ ባይዛንዳኔ ጌዒ ታ ማሉዋሴ፤ ያዒ ሃሣ ኔኤኒ ማዺንዱዋኣሢያ ታ ጉሙርቃኔ፤ ዬያ ኔ ማዼቶ ማይ ፑርታ ማዺባኣ ኮዦ ዓሳ ጎሞ ዓሶና ዎላ ፑርታና ዎጊንቴኔ ጌይሢኬ፤ ዬይያ ማሊ ማዒንዱዋሴ! ዓጮ ቢያም ዎጋሢ ፒዜ ዎጋንዳያ ኮይሳያቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ናንጊና ናንጋ ጎዳ ማሃዖ፦ «ሶዶኦሜ ካታሞይዳ ፑርታ ማዺባኣ ዶንጊታሚ ኮሺ ዓሲ ታ ዴንቄቶ ዔያቶሮ ጌዒ ካታሜሎ ታ ጉቤ ባይዛዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ዓብራሃሜ ላሚ ጊንሣ ሃሣ፦ «ታኣኒ ሲላሊና ዲቢንሢናጉዲ ማዔ ፓሡዋ ዓሢ ናንጊና ናንጋ ጎዳሢና ጫርቂ ጌስታሢሮ ታኣም ዓቶንጎ ጌዔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ጎዖንቴ ኮዦ ዓሶኮ ፓይዳ ዶንጊታሚ ማዒፆይዳፓ ዖይዲታሚ ዶንጎ ማዔቶ፥ ዶንጎ ዓሲ ፓጬሢሮ ካታሜሎ ጉቤ ኔ ባይዛንዳ?» ጋዓዛ፥ ናንጊና ናንጋ ጎዳ «ዖይዲታሚ ዶንጎ ኮሺ ዓሲ ታ ዴንቄቶ ካታሜሎ ታኣኒ ባይዛዓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ዓብራሃሜ ጊንሣ ላሚ፦ «ዖይዲታሚ ዓሲ ሌሊ ዒኢካ ጴዼቴሾ?» ጌዒ ዖኦጬኔ። ናንጊና ናንጋ ጎዳሢ ሃሣ፦ «ዖይዲታሚ ዓሲ ጴዼቶ ዔያቶሮ ጌዒ ካታሜሎ ታ ባይዛዓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ዓብራሃሜ ናንጊና ናንጋ ጎዳ ኮራ፦ «ታ ጎዳሢዮ! ሃዳራ ታና ጎሪፖ፤ ታ ኬኤዞም፤ ጎዖንቴ ሃይሢታሚ ዓሲ ሌሊ ጴዼቶሾ?» ጌዔኔ። ናንጊና ናንጋ ጎዳሢ፦ «ሃይሢታሚ ዓሲ ጴዼቶ ዔያቶሮ ጌዒ ካታሜሎ ታኣኒ ባይዛዓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ዓብራሃሜ ጊንሣ፦ «ታ ጎዳሢዮ! ሃሣ ላሚ ታ ኬኤዛሢሮ ታኣም ዓቶም ጌዔ፤ ጎዖንቴ ላማታሚ ዓሲ ጴዼቶሾ?» ጌዔኔ። ናንጊና ናንጋ ጎዳሢያ፦ «ላማታሚ ዓሲ ጴዼቶ ዔያቶሮ ጌዒ ካታሜሎ ታኣኒ ባይዛዓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ዓብራሃሜ ጊንሣ ሃሣ፦ «ታ ጎዳሢዮ! ሃዳራ ታና ጎሪፖ፥ ፔቴና ታ ኬኤዞም፤ ታጶ ዓሲ ሌሊ ጴዼቶሾ?» ጌዔኔ። ናንጊና ናንጋ ጎዳሢ፦ «ታጶ ዓሲ ጴዼቶ ዔያቶሮ ጌዒ ካታሜሎ ታኣኒ ባይዛዓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ናንጊና ናንጋ ጎዳ ዓብራሃሜና ዎላ ጌስቲ ጋፓዖ ዬኖ ቤዜሎይዳፓ ዓኣዼኔ፤ ዓብራሃሜያ ፔ ማኣሪ ማዒ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ዬኖ ዋንቴሎ ፆኦሲኮ ላምዖ ኪታንቻ ሶዶኦሜ ካታሞ ሙካንቴ፥ ሎኦፄ ጎዖሢ ሶዶሜ ካታሞ ጌላ ካራ ዴዒ ዓኣኔ፤ ዒዚያ ዬንሢ ዴንቃዖ ዔያቶና ጌስታኒ ዴዔ ቤዛፓ ዑኬና ዔቂ ዔያቶኮ ቤርታ ጉምዓቲ ቦንቾ ዔኤሊሢ ዔኤላዖ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«ታ ጎዳቲዮቴ! ታ ዒንሢ ሾኦቺንሣኒ ጊኢጊንቴያኬ፤ ታ ማኣሪ ጌሊ፥ ቶኮዋ ዒንሢኮ ማስቲ፥ ዒኢካ ዎርቂጋፓ ዚሮ ጉቴ ጎይፆ ዓኣዹዋቴ» ጌዔኔ። ዔያታ ጋዓንቴ፦ «ዔይዔ! ኑኡኒ ሃካ ዞኦዛ ዎርቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ሎኦፄ ዒዛ ማኣሪ ዔያታ ጌላንዳጉዲ ሺኢቂ ባሼሢሮ፥ ዒዛና ዎላ ማኣሪ ዔያታ ጌሌኔ፤ ዬካፓ ሎኦፄ ፔኤኮ ማዻ ዓሶም ካሣ ካሢ ቃራ ካዎ ጊኢጊሻንዳጉዲ ኬኤዜኔ፤ ካዋሢያ ጊኢጊንቴስካፓ ሾኦጫ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ሾኦጮንሢ ላሃንዳሢኮ ቤርታ ሶዶሜ ካታማፓ ዼጌሢንታ ጋርቾ ዓቲንቆንታ ዓቱዋዖ ሙኪ ሎኦፄ ማኣሮ ማንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ዒማና ዬይ ዓሳ ሎኦፄ ዔኤላዖ፦ «ሃካ ኔ ኮራ ዎርቃኒ ጌሌ ዓሶንሢ ዎካ ዓኣይ? ዔያቶና ኑ ላሃኒ ኮዓሢሮ ኑ ባንሢ ዔያቶ ኬሴ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ሎኦፄ ጋዓንቴ ዔያቶ ባንሢ ኬስካዖ ካሮ ጊንሢና ፔኤኮ ዎዻዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ሂዚ ዔያቶም ጌዔኔ፦ «ታ ላጎንሢዮቴ! ሃዳራቴ ሃያ ጉዴ ፑርታ ባኣዚ ማዺፖቴ! ");
INSERT INTO mdyeth_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ሃይሾ፥ ታኣኮ ላምዖ ሌዒባኣ ዉዱሮ ናይስኬንሢ ዓኣኔ፤ ዔያቶ ታ ዒንሢም ኬሳንዳኔ፤ ዒንሢ ኮዔ ባኣዚ ዔያቶ ማዹዋቴ፤ ሃንሢ ሾኦጮንሢ ጋዓንቴ ዓይጎዋ ማዺፖቴ፤ ዔያታ ታ ሾኦቺታሢሮ ዔያቶ ታ ካፓንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ዓሳ ጋዓንቴ፦ «ሃይ ኔ ቤቲ ሙኬ ዓሢ ሃይ! ኑኡኒ ማዻንዳ ባኮ ኑኡም ኬኤዛኒ ኔ ዖናዳይ? ሴካ ሺኢኬ! ሃንጎ ዔያቶይዳ ኑ ማዻኒ ማሌ ባኮይዳፓ ባሼ ኔ ዑፃ ኑ ማዻንዳኔ» ጌዒ፥ ሎኦፄ ሂዓዖ ካሮ ሜንሣኒ ጊኢጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ዬማና ሎኦፄኮ ጋሮይዳ ዓኣ ላምዖ ሾጮንሢ ኩጮ ፔኤኮ ዙሎ ኬሲ ሎኦፄ ጎቺ ዔኪ ጋሮ ጌልዛዖ ካሮ ማሂ ዎዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ዬካፓ ዙላ ዓኣ ዓሳ ቢያ ካሮ ዴንቁዋጉዲ ዓኣፖ ዔያቶኮ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ላምዖ ሾኦጮንሢ ሎኦፄም፦ «ሃይካ ካታሞይዳ ናንጋ ኔኤኮ ዉዱሮ ናይንታ ዓቲንቄ ናይንታ ናኣቶኮዋ ዖኦጪንቶ ዓሲንታ፤ ሃሣ ሜሌ ዒጊኒ ኔኤኮ ዓኣቶ ዑኬና ኬሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ዓይጎሮ ጌዔቶ ሃኖ ካታሜሎ ኑ ባይዛንዳኔ፤ ሃኖ ካታሞ ዓሶኮ ጎማ ኮሺ ሚርጌሢ ናንጊና ናንጋ ጎዳ ዋይዜሢሮ፥ ሶዶኦሜ ኑ ባይዛንዳጉዲ ኑና ዳኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ዬካፓ ሎኦፄ ዒዛኮ ናኣቶ ዖኦጫ ዓሶ ኮራ ዓኣዻዖ፦ «ዑኬና ሃይፓ ኬስኩዋቴ! ናንጊና ናንጋ ጎዳ ሃያ ቤዞ ባይዛኒኬ» ጋዓዛ፥ ዔያታ ዒዚ ዔያቶና ዓማሊ ጌጌሻኔ ጋዓዖ ዔኤቢ ማሂ ዔኪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ዚሮ ጉቴሎ ዓማ ፆኦሲኮ ኪኢታንቻ ሎኦፄም፦ «ዑካዼ! ካታሜሎና ኔ ዎላ ባይቁዋጉዲ ኔኤኮ ማቾና ላምዖ ዉዱሮ ናኣቶንሢና ዔኪ ሃይፓ ኬስኬ» ጌዒ ጌዒ ዒዛ ሩኡሪሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ሎኦፄ ጋዓንቴ ዎይቶንዶይ ጌዒ ሂርጌኔ፤ ያዺ ማዔቶዋ ናንጊና ናንጋ ጎዳ ዒዛና ዒዛኮ ማኣሮ ዓሶናም ሚጪንቴሢሮ ኪኢታንቻሢ ሎኦፄና ዒዛኮ ማቾና፤ ሃሣ ላምዖ ዉዱሮ ናኣቶንሢኮዋ ኩጮ ዓርቂ ካታማፓ ዔኪ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ዔያቶ ኬሴሢኮ ጊንፃ ኪኢታንቾንሢፓ ፔቴሢ፦ «ዒንሢ ሼምፖ ዓውሱዋቴ! ጊንሢም ሺሪ ዛጊፖቴ! ሃሣ ዶኦጮይዳኣ ናጊፖቴ፤ ዒንሢ ሃይቁዋጉዲ ዹኮ ባንሢ ጳሽኩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ሎኦፄ ጋዓንቴ ሂዚ ዔያቶም ጌዔኔ፦ «ታ ጎዳንሢዮ! ሃዳራቴ ዬካ ኑ ኬስካንዳጉዲ ጌዒፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ታና ኔኤም ዓይሢንቲ ማዻ ዓይላሢ ዛላ ማዒ ኮሺ ባኣዚ ኔ ማዼሢሮ፥ ታኣኮ ሼምፓሢያ ኔ ዓይሳኒ ዼኤፒ ማኣዶ ታኣም ኔ ማዼኔ፤ ጋዓንቴ ሃይ ባይሲንታ ታና ሄሌም ታ ሃይቃንዳኔ ጌዒ ሂርጋሢሮ ዬያ ዹኮ ባንሢ ጳሽካኒ ታ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ታኣኒ ዑኬና ጳሽኪ ቶላኒ ዳንዳዓ ዻካ ካታማስኬማ ዓኣኔ፤ ዒዞ ባንሢ ታኣኒ ሃዳራ ዓኣዾም ጌዔቴራ፤ ዒዛ ኔ ዛጋሢጉዲ ዻካ ካታማኬ፤ ዒዞ ባንሢ ታ ዴንዴቶ፥ ታኣኮ ሼምፓሢ ባይሲንታፓ ዓታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ኪኢታንቻሢ፦ «ዔኤዔ፥ ኔ ጌዔሢ ታ ዋይዜኔ፤ ዬማ ኔ ጋዓ ካታሞማ ታ ባይዛዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ዬኖ ካታሜሎ ኔ ሄላንዳኣና ዓይጎ ባኣዚያ ታ ማዻኒ ዳንዳዑዋኣሢሮ ዑኬና ዒዞ ባንሢ ጳሽኬ» ጌዔኔ። ሎኦፄ ዬኖ ካታሜሎ ዻካ ካታማ ጌዔሢሮ ሱንፃ ዒዞኮ ዞዓሬ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ሎኦፄ ዞዓሬ ካታሜሎ ሄላኣና ዓባ ሃጊ ፆፆርቃኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ናንጊና ናንጋ ጎዳ ሶዶኦሜና ጋሞኦራና ካታሞንሢዳ ታሚና ታሚኮ ፂኢሊና ፔ ኮሮ፥ ጫሪንጫፓ ኬይሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ዬያይዲ ዬንሢ ካታሞንሢና ዒኢካ ዓኣ ዶኦጮ ቤዞ፤ ሃሣ ዒኢካ ናንጋ ዓሶንታ ሳዖይዳ ባቃሌ ባኮንታ ቢያ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ሎኦፄኮ ማቻ ዒማና ጊንሢም ሺሪ ዛጌሢሮ ፒዝ ጌዒ ዔቄ፥ ዓሞሌ ሶኦጌ ማዒ ዓቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ዓብራሃሜ ዚሮ ጉቴሎ ዔቃዖ ጉቴ ዓሚና ቤርታ ዒዚ ናንጊና ናንጋ ጎዳና ዎላ ሶዶኦሜንታ ጋሞኦራንታ ዛሎ ጌስቴ ቤዜሎ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ዬካፓ ሊካ ሶዶኦሜና ጋሞኦራና፤ ሃሣ ዒኢካ ዓኣ ዶኦጮ ባንሢ ዒ ዛጋንቴ ፑኡፒ ዓንሢ ታሚፓ ኬስካ ጩቢጉዴያ ዼኤፒ ጩቢ ዒኢካ ጩባኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ሎኦፄ ናንጋ ዶኦጮ ካታሞንሢ ፆኦሲ ባይዛኒ ማሌ ዎዶና ዓብራሃሜም ማሊ፥ ዬያ ባይሲንታፓ ሎኦፄ ዻቃንዳ ቤሲ ባንሢ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ሎኦፄ ዞዓሬ ካታሜሎይዳ ናንጊፆ ዒጊጬሢሮ ዒዛና ዒዛኮ ላምዖ ዉዱሮ ናኣቶንሢና ሌካ ዹኮ ኬስኪ ዒኢካ ዔቴይዳ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ፔቴ ኬሊ ዒዛኮ ናዎ ቶይዴላ ጌኤዶም ሂዚ ጌዔኔ፦ «ኑ ዓዴ ጋርቺ ጋርቺ ዓኣኔ፤ ኑ ሾዓንዳጉዲ ኑና ዔካ ሜሌ ዓቲንቄ ኑ ኮራ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ዬያሮ ኑ ዓዶይዳፓ ኑ ናይ ሾዓኒ ዑሺ ኑ ዒዛ ማሢሶም» ጋዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ዬኖ ዋንቴሎ ዓዳሢ ዑሺ ማሢሲ ዒዛኮ ቶይዴላ ዒዛና ላሄኔ። ዓዴ ሚርጌና ማሢንቴሢሮ ዒዛ ላሂ ጊንሣ ዔቃኣናኣ ዒዚ ዔሪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ዚሮ ጉቴሎ ሚሼላ ጌኤዶም፦ «ዋንቴ ታኣኒ ዓዶና ዎላ ላሄኔ፤ ሃኖ ዒባኒ ሃሣ ኑ ማሢሳዛ ኔኤኒ ዒዛና ዎላ ላሄ፤ ሂዲ ዒዛይዳፓ ላምዓሢ ናይ ሾዒ ዜርፃ ኑኡኮ ባይቁዋጉዲ ኑ ማዾም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ዬያ ጋዓዖ ዔያቶኮ ዓዳሢ ዔያታ ዑሺ ማሢሲ ጌኤዴላ ዒዛና ላሄኔ፤ ቤርታኣሲጉዲ ኮሺ ዓዴ ማሢንቴሢሮ ዒዛ ላሂ ጊንሣ ዔቃኣና ዔሪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ዬያይዲ ላምዖ ሎኦፄ ናኣታ ዓዶይዳፓ ጎጲ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ቶይዴላ ዓቲንቄ ናይ ሾዓዖ ሱንፆ ሞዓኣቤ ጌዔኔ፤ ዒዚያ ሞዓኣቤ ዓሶ ጌይንቲ ዔኤሊንታ ዓሶኮ ማዢንቶ ዓዳሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ጌኤዴላኣ ዓቲንቄ ናይ ሾዓዖ ሱንፆ ቢኢኒዓኣሜ ጌዔኔ፤ ዒዚያ ሃኖ ዓሞኦኔ ዓሶ ጌይንቲ ዔኤሊንታ ዓሶኮ ማዢንቶ ዓዳሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ዓብራሃሜ ዎንዴ ናንጋ ሜሚሬ ጎዖ ቤዛፓ ቤቲ ኔጌቤ ጌይንታ ዓጮ ዓኣዻዖ ቃዴሴና ሹኡሬ ጌይንታ ዓጮናኮ ባኣካ ዴዔኔ፤ ጌሬራ ዓጮይዳኣ ሾኦቹሞና ዒዚ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ዒማና ዓብራሃሜ ፔኤኮ ማቾ ሳኣራ ታኣኮ ጌሮኬ ጌዔኔ፤ ዬያሮ ጌሬራ ዓጮ ካኣቲ፥ ዓቤሜሌኬ ሳኣራ ዔኪ ሙካንዳጉዲ ዓሲ ዳኪ፥ ዔኪ ፔ ማኣሪ ዬይሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ጋዓንቴ ዬካፓ ፔቴ ዋንቴና ፆኦሲ ካኣቲ ዓቤሜሌኬም ዓውቲና፦ «ሃኖ ላኣሌሎኮ ዓኒ ዓኣሢሮ ዒዞ ኔ ዔካኒ ማሊ ኔ ማኣሪ ዔኪ ዬይፆና ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ጋዓንቴ ካኣቲ ዓቤሜሌኬ ሃጊ ዒዞና ላሂባኣሢሮ ሂዚ ጌዔኔ፦ «ናንጊና ናንጋ ጎዳሢዮ! ታ ዓይጎዋ ፑርታ ባኣዚ ማዺባኣሴ፤ ታናንታ ታ ዴሮንታ ኔ ባባይዛንዳ? ");
INSERT INTO mdyeth_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‹ዒዛ ታኣኮ ጌሮኬ› ጌዔሢ ፔኤሮ ዓብራሃሜኬ፤ ዒዛኣ ታኣኮ ዒዚ ጌርሲኬ ታኣም ጌዔሢሮ፥ ታኣኒ ሃያ ማዼሢ ፂሎና ጌኤሺ ዒኔፓ ማዔሢሮ ፔቴታዖ ታ ዻቢንቴ ባኣዚ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ፆኦሲያ ዓውቲና ዒዛም ሂዚ ጌዔኔ፦ «ጌኤሺ ዒኔና ኔ ማዼሢ ታ ዔሬኔ፤ ዬያሮ ዒዞና ኔኤኒ ላሂ ጎሜ ማዹዋጉዲ ታ ኔና ላኣጌሢ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ሃሢ ጋዓንቴ ላኣሌሎ ዓኒም ማሂ ዒንጌ፤ ዒዚ ታ ማሊሢ ኬኤዛ ዓሲታሢሮ ኔ ሃይቁዋጉዲ ኔኤም ዒ ሺኢቃንዳኔ፤ ዒዞ ኔ ማሂ ዒዛም ዒንጊባኣቶ ኔ ሃይቃንዳሢ ኔና ዔሬ! ኔና ሌሊ ማዒባኣንቴ ኔኤኮ ዴራ ቢያ ኩዳንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ዚሮ ጉቴሎ ጉቴ ዓሚና ካኣቲ ዓቤሜሌኬ ፔኤኮ ዑኬ ማዒ ማዻ ዓሶ ዔኤሊ ማዔ ባኮ ቢያ ዔያቶም ኬኤዜ ዎዶና ዓሳ ዲቃቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ዬካፓ ካኣቲ ዓቤሚሌኬ ዓብራሃሜ ዔኤላዖ፦ «ሃይ ኔ ኑኡም ዓይጎ ማዾ ማዼይ? ታኣና ታ ካኣቱሞናይዳ ሃያጉዴ ባይሲንታ ኔ ዔኤሌሢ ታ ኔኤም ዓይጎ ዻቤምዳይ? ኔ ማዼ ባካ ዓሲ ማዻ ባኣዚያቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ሂንዳ ዋይዜ፥ ሃያ ኔና ዓይጌ ማዺሺሴይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ዓብራሃሜ ማሃዖ፦ «‹ሃያ ዓጮይዳ ፆኦሲ ዒጊጫ ዓሲ ባኣሴ› ጌዒ ማሊሢና ‹ታኣኮ ማቾ ዔካኒ ኮዒ ታና ዎዻንዳኔ› ጌይ ታኣኒ ዒጊጬሢሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ሃሣ ዒዛ ታኣኮ ዓዶ ናይ ማዔሢሮ ጎኔ ታኣኮ ዒዛ ጌሮኬ፤ ጋዓንቴ ታ ዒንዶ ናይ ዒዛ ማዒባኣሢሮ ታ ዒዞ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ዬያሮ ፆኦሲ፥ ታ ዓዶ ማኣራፓ ታ ኬስኪ ሜሌ ዓጪ ዓኣዻንዳጉዲ ታና ዓይሤ ዎዶና፥ ‹ኑ ዴንዴ ቤዞ ቢያይዳ ታ ዒዛኮ ጌሮኬ ኔ ጌዔቶ ኔኤኒ ታኣም ፑኡፒ ባኣዚ ማዼጉዲ ታ ፓይዳንዳኔ› ታ ዒዞም ጌዔያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ዬካፓ ካኣቲ ዓቤሜሌኬ ዒዞኮ ዓኒ ዓብራሃሜም ማሂ ሳኣራ ዒንጌኔ፤ ዬያጉዲ ሃሣ ማራይ፥ ባይንታ ማዻ ዓሲያ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ዓብራሃሜማኣ፦ «ሃይሾ ታኣኮ ዓጫ ኔኤኒ ዛጋሢጉዲኬ፤ ኔ ኮዔ ቤዛ ናንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ሳኣራም ሃሣ፦ «ኔኤኒ ፔቴታዖ ቦርሲሳ ባኣዚ ማዺባኣያ፥ ጌኤሺ ማዔሢ ዔርዛኒ ኔኤና ዎላ ዓኣ ዓሶም ማላታ ማዓንዳጉዲ ኔ ጌርሲ ዓብራሃሜም ፔቴ ሺያ ማዓ ሹቺ ቢራ ታ ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","ዓብራሃሜ ማቾ፥ ሳኣራይዳ ማዺንቴ ባኮ ዛሎና ካኣቲ ዓቤሜሌኬ ማኣራ ናንጋ ላኣሎ ቢያ ናይ ሾዑዋጉዲ ፆኦሲ ዔቂሴኔ፤ ዬያሮ ዓብራሃሜ ካኣቲ ዓቤሜሌኬ ዛሎ ሺኢቄም ፆኦሲ ካኣቲ ዓቤሜሌኬና ዒዛኮ ማኣሮና ፓሤኔ፤ ዬካፓ ዒዛኮ ማቾና ዒዛኮ ማዻ ላኣላ ቢያ ናይ ሾዓኒ ዳንዳዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ናንጊና ናንጋ ጎዳ ጌዔ ጎይፆ፥ ዒዚ ኬኤዜ ሃጊ ማዓንዳ ዎዞጉዴያና ሳኣራ ጋርቼዖ ናይ ሾዓንዳጉዲ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ዬያሮ ሳኣራ ጋርቼዖ ጎጳዺ ዓብራሃሜም ዓቲንቄ ናይ ሾዔኔ፤ ናዓሢ ሾይንቴሢያ «ሃይማ ዎዶና ሾይንታንዳኔ» ጌዒ ፆኦሲ ኬኤዜ ዎዶማናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ዓብራሃሜ ዒዛኮ ማቻ፥ ሳኣራ ዒዛም ሾዔ ናዓሢኮ ሱንፆ «ዪሳኣቄ» ጌዒ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ፆኦሲ ዓብራሃሜ ዓይሤ ጎይፆ ናዓ ሾይንቴሢኮ ሳላሳ ኬሎና ናዖኮ ዓቲንቶ ቤርቶ ዒዚ ቲቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ዪሳኣቄ ሾይንታ ዎዶና ዓብራሃሜኮ ሌዓ ፄኤታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ሳኣራ፦ «ፆኦሲ ታኣም ዎዛና ሚኢቺና ዒንጌኔ፤ ዬያሮ ሃያ ባኮ ዋይዜሢ ቢያ ታኣና ዎላ ሚኢጫንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ሃሣ ዒዛ፦ «‹ሳኣራ ዓብራሃሜም ናይ ሾዒ ዻንሢሣንዳኔ› ጌዒ ማሌ ዓሲ ዖናዳይ? ሃይሾ ዒዚ ጋርቼንቴ ዓቲንቄ ናይ ዒዛም ታ ሾዔኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ናዓሢ ጉኡጴኔ፤ ዒዚ ጉኡጴ ኬሎና ዓዴ፥ ዓብራሃሜ ሚርጌ ሙኡዚንታ ዑሺያ ጊኢጊሺ ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ሳኣራም ማዾ ማዻ፥ ጊብፄ ዓጮ ናዔላ፥ ዓጋኣራ ዓብራሃሜም ሾዔ ናዓሢ ዒስማዔኤሌ ፔቴ ኬሊ ማኣሮ ዒንዶ ሳኣራ ናኣዚ ዪሳኣቄና ዎላ ዓማላኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ዒማና ናኣታ ዓማላሢ ሳኣራ ዛጋዖ ዓብራሃሜ ኮራ፦ «ሃኖ ታኣኮ ማዻዜሎ፥ ናኣዚና ዎላ ኬሲ ዳኬ፤ ዒዞኮ ናኣዚ ታ ናኣዚ ዪሳኣቄና ዎላ ዻካላንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ዒስማዔኤሌያ ዓብራሃሜኮ ናዖታሢሮ ዬይ ዒዛ ኮሺ ሜታሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ፆኦሲ ጋዓንቴ ዓብራሃሜም፦ «ኔኤኮ ናዖና ኔኤኮ ማዻዜሎ ዓጋኣሮ ዛሎናሮ ሜታዺፖ፤ ኔና ዻካላንዳ ዜርፃ ኬስካንዳሢ ዪሳኣቄ ዛሎና ማዔሢሮ ሳኣራ ኔኤም ጋዓሢ ቢያ ማማዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ኔኤም ማዻዜሎኮዋ ናኣዚ፥ ኔ ናይ ማዔሢሮ ዼኤፒ ዴሬ ማዓንዳያ ሄላንዳኣና ዜርፆ ታ ዒዛኮ ዳልጊሻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ዚሮ ጉቴሎ ዓብራሃሜ ጉቴ ዓሚ ዔቃዖ፥ ዻካ ካሣና ዋኣሢያ ጎቻና ዓጋኣሮም ዒንጊ፥ ናዖ ዒስማዔኤሌያ ዙላ ባሲሲ ማኣራፓ ኬሳዛ፥ ዔዛ ዬካፓ ኬስኪ ቤርሳቤ ጌይንታ፥ ዓሲ ናንጉዋ ዳውሎይዳ ሴካ ሃንጋ ጌዒ ሜታዺ ሃንቲሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ጎቾና ዒዛ ዔኬ ዋኣፃ ኩዴ ዎዶና ዒዛ ናዖ ፔቴ ቶሻ ዴንካ ላይሢ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","«ታኣኮ ናዓ ሃይቃሢ ታ ዛጋኒ ኮዑዋሴ» ጌዒ ናዖይዳፓ ዓኣዛ ዱኮዛ ሃኪ ኬዳንዳ ቤሲጉዴያ ሃኪ ዴንዲ ዴዒ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ናዓሢ ሚርጌና ዬኤካሢ ፆኦሲ ዋይዜኔ፤ ፆኦሲኮዋ ኪኢታንቻ ጫሪንጫፓ ዓጋኣሮ ዔኤላዖ፦ «ዓጋኣሬ! ዓይጎሮ ኔ ሜታዻይ? ፆኦሲ ናዓሢኮ ዬኤፖ ዋይዜሢሮ ዒጊጪፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ዔቂ ዴንዲ ናዓሢ ጌሺ ዶዲሼ፤ ዒዛኮዋ ዜርፆ ታ ሚርጊሻንዳኔ፤ ዼኤፒ ዴሬያ ታ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ዒማና ፆኦሲ ዒዞኮ ዓኣፖ ቡላዛ ፔቴ ዴዒ ዓኣ ዔቴ ዋኣሢ ዴንቃዖ ዴንዲ ጉዜሎና ዱዒ ናዖ ዑሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ናዓሢ ዲጫኣና ፆኦሲ ዒዛና ዎላ ዓኣኔ፤ ዒዚያ ፓኣራኔ ጌይንታ ዓሲ ናንጉዋ ዳውሎይዳ ናንጊ ናንጊ ዓኣዛ ዱፒና ዔርቴ ኬሞ ዓሲ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ዒንዴላ ዒዛም ፔቴ ጊብፄ ዓጪ ናይስኬኖ ዔካንዳጉዲ ማዢሲ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ካኣቲ ዓቤሜሌኬ ዬኖ ዎዶና ፔኤኮ ዖሎ ዖላ ዓሶ ዓይሣ ፒኮሌ ጎዖሢና ዎላ ዓኣዺ ዓብራሃሜ ኮራ፦ «ኔኤኒ ማዻ ባኮና ቢያ ፆኦሲ ኔኤና ዎላኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ታኣም ማዔቶዋ ታኣኮ ናኣቶም ሃሣ ታኣኮ ዜርፆም ኔኤኒ ፑርታ ባኣዚ ማዺንዱዋያ ማዒፆ ሃይካ ሃሢ ታኣም ፆኦሲ ሱንሢና ጫኣቄ፤ ታ ኔኤም ፒዜ ማዾ ማዼሢጉዲ ኔኤኒያ ታኣና ሃኖ ኔ ሾኦቹሞና ናንጋ ዓጬሎናም ፒዙሞ ማዾ ማዻንዳኔ ጌዒ ጫኣቄ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ዓብራሃሜ፦ «ዔኤዔ፥ ታ ጫኣቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ዓብራሃሜ ካኣቲ ዓቤሜሌኬም፦ «ኔኤኮ ማዾ ማዻ ዓሳ ታኣኮ ዔኬ ዔቴ ዋኣሢ ዓኣኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ካኣቲ ዓቤሜሌኬ፦ «ዬያ ማዼሢ ዖናታቴያ ታ ዔሩዋሴ፤ ኔኤኒያ ዬያ ታኣም ኬኤዚባኣሴ፤ ሃያ ኔ ጋዓሢ ሃኖ ታ ዋይዛኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ዬካፓ ዓብራሃሜ ማራይና ባይና ዔኪ ካኣቲ ዓቤሜሌኬም ዒንጋዛ ዬኖ ኬሎና ላምዖንሢ «ዎሊ ኑ ፑርቲሳዓ» ጌዒ ፔቴ ማዒ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ዒማና ዓብራሃሜ ላንካይ ዑዞ ማራይ ቆልሞይዳፓ ዱማሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ካኣቲ ዓቤሜሌኬ፦ «ሃንሢ ላንኮ ማራናኣቶንሢ ዱማሲ ኔ ዔቂሴሢ ዓይጎሮዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ዓብራሃሜ ማሃዖ፦ «ሃንሢ ላንኮ ማራቶ ዑዞንሢ ዔኬ፤ ሃንሢ ኔኤኒ ዔኬቶ ሃኖ ዔቶ ዋኣፆ ታ ቦኦኬያ ማዔሢ ኔ ዔራንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ላምዖንሢ ዎሊ ፑርቲሳዓ ጌዒ ጫኣቄ ቤዞ ማዔሢሮ ዬኖ ቤዜሎኮ ሱንፃ ቤርሳቤ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ዬኖ ፔቱሞ ጫኣቁሞ ቤርሳቤይዳ ዔያታ ጫኣቄሢኮ ጊንፃ ካኣቲ ዓቤሜሌኬና ዒዛኮ ዖሎ ዓሶ ዓይሣ ፒኮሌና ፒሊስፄኤሜ ዓጮ ማዒ ዴንዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ዬካፓ ዓብራሃሜ ቤርሳቤይዳ ታማርስኬ ጌይንታ ሚሢ ቱካዖ ናንጊና ባይቁዋዖ ናንጋ ፆኦሲ ማዔ ናንጊና ናንጋ ጎዳሢ ዒኢካ ዚጊ ካሽኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ዓብራሃሜ ዒኢካ ፒሊስፄኤሜ ዓጮይዳ ሚርጌ ዎዴ ሾኦቹሞና ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ዬያ ቢያ ባኮኮ ጊንፃ ፆኦሲ ዓብራሃሜ ዒዛም ዓይሢንታቶዋ ዓይሢንቱዋቴያ ዛጌኔ፤ ዛጎሮ ጋዓዖ «ዓብራሃሜ!» ጌዒ ዔኤላዛ ዓብራሃሜ «ዮ» ጌዒ ዬሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ፆኦሲ ዓብራሃሜም፦ «ኔኤኒ ናሽካ ኔኤኮ ፔቴ ናዓሢ ዪሳኣቄ ዔኪ ሞኦሪያ ጌይንታ ዓጮ ዓኣዺጋፓ፥ ዒኢካ ታ ኔና ፔቴ ዻዋ ጌሜሪዳ ኔኤኮ ናዓሢ ሹኪ ታሚና ሚቺ ዒንጎ ዒንጊሢ ማሂ ታኣም ሺኢሼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ዓብራሃሜ ዚሮ ጉቴሎ ዓሚ ዔቃዖ ታሞ ዔኤሢ ሚቾንዶ ሃንፂሎ ቆፂ ሃሬና ጫኣናዖ፥ ዒዛና ዎላ ፔኤኮ ናዖ ዪሳኣቄና ዒዛኮ ማዻ ዓሶይዳፓ ላምዖ ዓሲ ዔኪ ፆኦሲ ዒዛም ዻዌ ቤዞ ዓኣዻኒ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ዬካፓ ሃይሣሳ ኬሎና ዓብራሃሜ ሃኬና ዛጊ ቤዜሎ ዴንቃዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ዒዛም ማዻዞንሢም፦ «ዒንሢ ሃራሢ ኮራ ሃካ ዴዑዋቴ፤ ታኣና ናዖና ሴኬያ ዓኣዺ ፆኦሲም ዚጊ ካሽኪ ኑ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ዬካፓ ዓብራሃሜ ዒንጎ ባኮ ሚቾንዶ ሃንፂሎ ዔኪ ናዖ ዪሳኣቄ ኬዲሲ፥ ዒዚ ታሞና ዓፓሮና ዔኪ ላምዖንሢ ዎላ ዓኣዻንቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ጎይፆይዳ ዪሳኣቄ፦ «ዓዴ!» ጌዒ ዔኤላዛ፥ ዓዴ፦ «ታ ናዓሦ፥ ዮ!» ጌዒ ዬሄኔ፤ ዪሳኣቄ ጊንሣ፦ «ሃይሾ፥ ታሞንታ ሃንፂሎንታ ኑ ዔኬኔ፤ ማዓዛ ፆኦሲም ዒንጋኒ ሹኮንዶ ማራዓሢ ዓንካዳዖ?» ጌዒ ዓብራሃሜ ኮራ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ዓብራሃሜ፦ «ታ ናዓሢዮ! ሹኮንዶ ማራዓሢ ፆኦሲ ፔኤሮ ጊኢጊሻንዳኔ» ጋዓዖ፥ ላምዖንሢ ዎላ ጎይፆ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ፆኦሲ ዻዌ ቤዞ ዓብራሃሜ ሄሌ ዎዶና ሚቺ ዒንጊ ካኣሽኮንዶ ቤዞ ሹጮና ኮሺ ሃንፂሎዋ ዔኤታንዳጉዲ ዒኢካ ዓጊ ጊኢጊሺ፥ ፔኤኮ ናዖ ዪሳኣቄያ ቱኪ፥ ጊኢጊሾና ሃንፂሎ ዑፃ ላይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ዬካፓ ናዖ ቲቃኒ ዓፓሮ ዔኪ ኩጮ ዼጊዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ጋዓንቴ ናንጊና ናንጋ ጎዳኮ ኪኢታንቻ ጫሪንጫፓ፦ «ዓብራሃሜ! ዓብራሃሜ!» ጌዒ ላሚ ዔኤላዛ፥ ዓብራሃሜ «ዮ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ናንጊና ናንጋ ጎዳኮ ኪኢታንቻሢ ዓብራሃሜም፦ «ናዓሢ ካኣሚፖ፤ ዓይጎዋ ዒዛይዳ ማዺፖ፤ ኔኤኒ ፆኦሲ ዒጊጫያታሢ ታኣኒ ዔሬኔ፤ ዓይጎሮ ጌዔቶ ፔቴ ናዖ ታኣም ዒንጊፓ ኔ ጊንሢም ጌይባኣሢሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ዓብራያሜያ ኮይሎ ሃንጋ ሴካ ዛጌ ዎዶና ፔቴ ማራይ ጉራና ካይዚ ቡኡራና ዓርቂንቲ ዓኣያ ዴንቃዖ፥ ዓኣዺ ማራዓሢ ዔኪ ናዖ ቤዛ ሹኪ ሚቺ ዒንጎ ካኣዦ ካሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ዓብራሃሜ ዬኖ ቤዜሎ፦ «ናንጊና ናንጋ ጎዳ ጊኢጊሻኔ» ጌዒ ሱንፆ ጌሤሢሮ፥ ሃኖ ሄላዖ ዓሳ፦ «ዬኖ ናንጊና ናንጋ ጎዳሢኮ ዹኮይዳ፥ ናንጊና ናንጋ ጎዳ ጊኢጊሻኔ» ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ናንጊና ናንጋ ጎዳኮ ኪኢታንቻሢ ላሚ ዓብራሃሜ ዔኤላዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«ናንጊና ናንጋ ጎዳ ‹ኔኤም ሚርጌ ዓንጆ ዒንጋንዳሢ ታ ታ ሱንፆና ጫኣቃኔ› ጋዓኔ፤ ሃያ ኔ ማዼሢሮ ሃሣ ፔቴ ናዓሢያ ታኣም ዒንጋኒ ኔ ዒፂባኣሢሮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ታ ኔኤኮ ዜርፆ ጫሪንጫ ዦኦጋሢጉዲ፥ ባዞ ዓጫ ማኣሻሎጉዲ ሚርጊሻንዳኔ፤ ኔኤኮ ዜርፃ ዔያቶ ዒፃ ሞርኮ ባሺ ካታሞ ዔያቶሲ ዔካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ታኣኮ ዓይሢፆ ኔ ኩንሤሢሮ ዓጮ ዴራ ቢያ ኔ ዜርፆና ዓንጂንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ዬካፓ ዓብራሃሜ ዒዛም ማዻዞንሢ ኮይላ ማዒ ዴንዳዖ ዔያቶና ዎላ ቤርሳቤ ዓጮ ዓኣዺ፥ ዒኢካ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ዬካፓ ሚልካ ጎዖዜላ ዓብራሃሜኮ ዒሾ ናኮሬም ናይ ሾዔሢ ዓብራሃሜ ዋይዜኔ፤ ዔያታኣ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ቶይዳሢ ዑፄ፥ ጌኤዛሢ ቡዜ፥ ዓራሜኮ ዓዶ ቄሙዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ኬሴዴ፥ ሃዞ፥ ፒልዳሼ፥ ዪዲላፔ ጎዖሢንታ ቤቱዔኤሌንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ቤቱዔኤሌ ጎዖሢ ዒርቢቃ ጎዖዞ ሾዔኔ፤ ሚልካ ዬንሢ ሳሎ ናኣቶንሢ ዓብራሃሜኮ ዒሾ ናኮሬም ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ሬዑማ ጌይንታ ናኮሬኮ ጊንፃ ማቾስኬና ናኮሬም ሃሣ ፄባሂ፥ ጌሃሚ፥ ቴሃሼና ማዒካ ጎዖስኬንሢ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ዓብራሃሜኮ ማቻ ሳኣራ ፄኤታና ላማታሚ ላንካይ ሌዔ ናንጌሢኮ ጊንፃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ካኣናኔ ዓጮይዳ ዓኣ «ዓርባዒ ካታሞ» ጌይንታያታዖ ጊንፃፓ ኬብሮኦኔ ጌይንቴ ካታሞይዳ ሃይቄኔ፤ ዓብራሃሜያ ሳኣራ ሃይቄሢሮ ሚርጌና ዖዪ ዬኤካዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ማቾኮ ሌዛ ዓኣ ቤዛፓ ዔቂ ሂታ ዓሶ ኮራ ዴንዲ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«ታኣኒ ዒንሢ ባኣካ ሙኬ ሾኦቺ ዓሲታሢሮ፥ ሃዳራቴ ዱኡፒ ቤሲ ታኣም ሻንቹዋቴ፤ ታኣኮ ማቾ ታ ዒኢካ ዱኡካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ሄኤቴ ዓሳ ዒዛም ማሃዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«ኑ ጎዳሢዮ፥ ሂንዳ ዋይዜ፤ ኔኤኒ ኑኡኮ ባኣካ ዼኤፒ ካራዚጉዴያ ማዔሢሮ፥ ኑኡኮ ዱኡፖ ቤዛፓ ኮሺ ቤሲ ዶኦሪ ዱኡኬ፤ ኑ ቢያሢ ኔኤኒ ኔ ማቾ ዱኡካንዳ ቤሲ ዒንጋንዳያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ዬካፓ ዓብራሃሜ ሄኤቴ ዓሶ ቤርታ ቶኦኮ ሂርኪዲ ዚጋዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","«ታ ማቾ ሃይካ ታ ዱኡካንዳጉዲ ዒንሢ ታኣም ጌዔቶ ፆሃሬ ናኣዚ ዔፕሮኦኔኮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ጎዦ ዛጳ ዓኣ ማክጴላ ጌይንታ ዴኖ ዔታ ዓኣ ቤዜሎ ታኣም ዒ ሻንቻንዳጉዲ ዒዛ ዖኦጩዋቴ፤ ዬና ቤዜላ ታኣኮ ዱኡፒ ቤሲ ማዓንዳጉዲ ዒንሢ ቤርታ ዒ ጌዔ ሚኢሼና ታና ሻንቂሲሱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ዬኖ ዒ ጋዓ ቤዜሎኮ ዓዳሢ ዔፕሮኦኔ ፔ ቶኦኪና ካታሞ ጌላ ካራ ዓሳ ቡኪንታ ቤዛ ሃንጎ ሄኤቴ ዓሶና ዎላ ዴዒ ዓኣዖ፥ ዒኢካ ዓኣ ዓሳ ቢያ ዋይዛንቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«ጎዳሢዮ ዋይዜ! ጎዤሎና ዬኖ ቤዜሎና ዎላ ታ ኔኤም ዒንጌኔ፤ ኔ ማኣራፓ ሃይቄ ዓሶ ኔ ዱኡካንዳጉዲ ታኣኮ ዜርፆ ማዔ ሄኤቴ ዓሶ ቤርታ ታ ኔኤም ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ዓብራሃሜ ጋዓንቴ ሄኤቴ ዓሶ ቤርቶይዳ ላሚ ቶኦኮ ሂርኪዲ ዚጋዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ቢያሢ ዋይዛንቴ ዔፕሮኔም፦ «ሃዳራ ዋይዜ፤ ቤዞ ታኣኒ ታኣሮ ማሂ ሻሻንቃንዳኔ፤ ቤዞኮ ኮይሳሢ ታጊዳፓ ዔኬ፤ ታኣኒ ታ ማቾ ዒኢካ ዱኡካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","ዔፕሮኔ ዒማና፦ «ጎዳሢዮ ቤዜላ ዖይዶና ዛላና ኪሎ ማዓ ማዓ ሹቺ ቢራ ኬሳንዳያኬ፤ ዬና ኔኤና ታኣናናም ዓይጎ ማዓንዳይ? ኔኤሮ ዓሴሎ ዱኡኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ዓብራሃሜ ዴሮ ቤርታ ዔፕሮኦኔ ጌዔሢ ኮሺኬ ጌዒ ዖይዶና ዛላና ኪሎ ማዔ ሹጮ ቢሮ ዒንጌሢሮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ሜሚሬ ጎዖ ቤዜሎኮ ዓባ ኬስካ ዛሎና ማክጴላ ጌይንታ ዔፕሮኦኔ ቤዜላ ዓብራሃሜ ቤሲ ማዔኔ፤ ዬኖ ቤዜሎይዳ ዓኣ ባካ ጎሺ ቤሲ፥ ዔቴ ዓኣ ዴኔ ቤሲንታ ሚሢያ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ዬማና ዬካ ዓኣ ሄኤቴ ዓሳ ቢያ ዬና ቤዜላ ዓብራሃሜ ቤሲ ማዔሢ ዔሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ዬካፓ ካኣናኔ ዓጫ ዓኣ ዬኖ ቤዜሎይዳ ዓብራሃሜ ፔኤኮ ማቾ ሳኣራ ዱኡኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ሄኤቴ ዓሶሮ ማዔ ጎዣ ጋሮይዳ ዓኣ ዔቶ ቤዞና ዎላ ዓብራሃሜኮ ዱኡፒ ቤሲ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ዓብራሃሜ ሚርጌና ጋርቼኔ፤ ናንጊና ናንጋ ጎዳሢያ ዒዚ ናንጌ ዎዶ ቢያይዳ፥ ቢያ ባኣዚና ዒዛ ዓንጄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ዓብራሃሜ ዒዛኮ ማኣራ ዓኣ ባኮ ቢያ ዎሣያ ማዒ ሚርጌ ሌዔ ናንጌ፥ ዒዛም ማዾ ማዻ ዓሲስኬያ ዔኤላዖ፦ «ኔኤኮ ኩጮ ታ ጉባዞ ባኣካ ጌሢጋፓ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ታኣኒ ሃሢ ዎላ ናንጋ ሃያ ካኣናኔ ዓሶኮ ዉዱሮ ናኣቶይዳፓ ታኣኮ ናዓሢም ላኣሊ ኔኤኒ ማዢሱዋጉዲ ጫሪንጮና ሳዖናኮ ጎዳ ማዔ ፆኦዛሢ ሱንፆና ታኣም ጫኣቄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ጋዓንቴ ታ ሾይንቴ ዓጮ ዓኣዺጋፓ ዬካ ዓኣ ታ ፃጶ ባኣካፓ ታ ናኣዚ ዪሳኣቄም ላኣሊ ማዢሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ማዾ ማዻ ዓሢያ ማሃዖ፦ «ጎዖንቴ ታ ዒዛም ዖኦጫ ናዔላ ታኣና ዎላ ሃያ ዓጮ ሙኮ ዒፄቶሾ? ኔኤኮ ናኣዚ ኔ ሾይንቴ ዓጮ ማዒ ዓኣዼ ጎዖንዶ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ዓብራሃሜ ጋዓንቴ ዒዛም፦ «ዓይጎ ባኣዚ ማዔቶዋ ታኣኮ ናዓሢ ታ ዓዶ ዓጮ ማሂ ኔ ዔኪ ዓኣዹዋጉዲ ኔና ዔሬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ናንጊና ናንጋ ጎዳ ማዔ ጫሪንጮ ፆኦዛሢ ታና ታ ዓዶ ማኣሮና ሾይንቴ ዓጮናይዳፓ ሃይካ ዔኪ ሙኪ ሃያ ዓጮ ታ ዜርፆም ዒንጋንዳኔ ጌዒ ታኣም ጫኣቄሢ፥ ሃሢ ዬያ ዓጮይዳፓ ታ ናዓሢም ላኣሊ ኔ ዴንቃንዳጉዲ ፔኤኮ ኪኢታንቻሢ ኔኤኮ ቤርታ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ናዔላ ኔኤና ዎላ ሙካኒ ናሽኪባኣቶ ሃያ ታ ኔና ጫኣቂሳ ጫኣቁማፓ ኔኤኒ ዙላ ማዓንዳኔ፤ ያዺ ማዔቶዋ ታኣኮ ናዖ ዓይጎ ጎይሢናኣ ማዖም ዔኪ ዓኣዺፖ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ዬካፓ ማዾ ማዻሢ ኩጮ ፔኤሲ ፔ ጎዳ ዓብራሃሜኮ ጉባዞ ባኣካ ጌሢ፥ ዓብራሃሜ ዓይሤ ባኮ ቢያ ኩንሣኒ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ዬካፓ ዓብራሃሜኮ ማኣራ ማዾ ማዻሢ ማኣሮይዳፓ ዓሲም ዒንጋኒ ኮሺ ኮሺ ማዔ ባኣዚ ታጶ ጋኣሎና ጫኣኒ ዓባ ኬስኪ ጌላሢኮ ኬዶ ዛሎና ሜሶፖታሚያይዳ ናኮሬ ጌይንታ ዓሢ ናንጋ ካታሞ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ዒኢካ ካታሞኮ ዙላ ዓኣ ዔቶ ዋኣፆ ሙኪ ዒዚ ሄላዖ ጋኣላሢ ጉምዓቲ ሃውሻንዳጉዲ ዔቂሴኔ፤ ዬያ ዒ ማዼሢ ዓባ ጌሊ ሳዓ ዓማኒ ዑኬም፥ ላኣሊ ዋኣሢ ዱዓኒ ዎርዚ ኬዳ ዎዴይዳኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ማዾ ማዻ ዓሢ ዒማና ሂዚ ጌዒ ሺኢቄኔ፦ «ታ ጎዳሢ ዓብራሃሜኮ ጎዳ ማዔ ፆኦዛሢዮ! ታኣኮ ማሊፆ ኩንሢ ታ ጎዳ ዓብራሃሜም ኔኤኮ ናንጊና ናንጋ ናሹሞ ፔጋሲ ዔርዜ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ሃኣዛጌ፥ ሃሢ ታ ሃያ ዔቶ ዋኣፆ ዓጫ ዔቂ ዓኣኔ፤ ካታሞይዳፓ ዋኣፆ ዱዓኒ ዉዱሮ ናኣታ ሙካዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ዔያቶይዳፓ ፔቴ ዉዱሮ ናይ ኮራ፦ ‹ኔኤኮ ዋኣፆ ጉዛፓ ዋኣሢ ታና ዑሼቴራ› ታ ጋዓዛ፥ ‹ዑሽኩዋይ፤ ኔኤኮ ጋኣላሢያ ዑሽካንዳጉዲ ዋኣፆ ታ ኔኤም ዱዓንዳኔ› ዒዛ ታኣም ጌዔቶ ኔ ዓይላሢ ዪሳኣቄም ላኣሊ ማዓንዳጉዲ ዬና ኔኤኒ ዶኦሬዜሎ ማዖንጎ፤ ዬያይዲ ታ ጎዳ ዓብራሃሜም ኔኤኮ ናንጊና ናንጋ ናሹሞ ኔ ፔጋሲ ዻዌሢ ታኣኒ ዔራንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ሂዚ ጌዒ ሃጊ ሺኢቂ ዒ ጋፑዋንቴ ዒርቢቃ ጎዖዜላ ዋኣሢ ጉሲ ባሲ ሙኬኔ፤ ዒዛኣ ዓብራሃሜኮ ዒሼ፥ ናኮሬ ፔ ማቾ ሚልካይዳፓ ሾዔሢ ባኣቱዔኤሌ ናይኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ዒርቢቃ ኩሙሢ፥ ሃሣ ሚዛጲ ዉዱሮ ናይኬ፤ ዒዛ ዔቶ ዋኣፆ ዱዔሢኮ ጊንፃ ፔ ማኣሮ ባንሢ ማዒ ዴንዶ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ዓብራሃሜም ማዻሢ ሩኡሪና ዒዞ ኮራ ዓኣዻዖ፦ «ኔኤኮ ጉዛፓ ዋኣሢ ታና ዑሼቴራ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ዒዛ፦ «ታ ጎዳ፥ ዓይጌ ዓኣዖ ዑሽኩዋይ» ጌዒ ጉዞ ጌኤታፓ ኬይሲ ዑሽኮም ዛላሲ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ዓሢ ዑሽኪ ዼኤቦ ዛኣሬሢኮ ጊንፃ፦ «ኔኤኮ ጋኣላሢማኣ ታኣኒ ዋኣፆ ዱዓንዳኔ፤ ዔያቶም ጊዳንዳያ ሄላንዳኣና ዑሽኮንጎ» ጌዒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ቤዞማና ጉዛፓ ዋኣፆ ጋኣላሢ ዑሽካ ጎንጎይዳ ቶባዖ ጋኣላሢ ቢያ ዑሽኪ ሚሽካንዳያ ሄላንዳኣና ዔታፓ ዋኣፆ ሩኡሪ ሩኡሪ ዱዒሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ዓሢያ ናንጊና ናንጋ ጎዳ ዒዛኮ ሃንቲፆ ጊኢጊሼያ ማዔቴ ዔራኒ ዒዛ ማዻ ባኮ ቢያ ዚቲዮ ጌዒ ዛዛጋኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ዬካፓ ጋኣላሢ ዑሽኪ ጊዳዛ ዓሢ ዎርቄይዳፓ ዹይንቴ ኮሺ ሚዛጲ፥ ሲኢዺዳ ዓኣሦያ፥ ዶንጎ ጊራኣሜ ማዓ ጉዴቾ ሲኢዻ ዒዞም ዓኣሤኔ፤ ሃሣ ዒዞኮ ላምዖ ኩጮይዳ ላምዖ ዎርቄ ጋዊ ዼኤፒ ዔኪ ዓኣሣዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","«ኔኤኒ ዖ ናይዳይ? ሃዳራ ታኣም ኬኤዜ፤ ታናንታ ታኣና ዎላ ዓኣ ዓሶንታም ዎይሢ ቤሲ ኔ ዓዶ ማኣራ ጴዻንዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ዒዛ ማሃዖ፦ «ታኣኒ ባኣቱዔኤሌ ናይኬ፤ ባኣቱዔኤሌኮ ዓዴ ናኮሬኬ፤ ዒንዳ ዒዛኮ ሚልካ ጌይንታያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ኑ ማኣሮይዳ ሚርጌ ቆልሞ ሙዓ ጎቦንታ ሜልዚ ዖሃንታ ዓሲ ዎርቃ ቤሲያኣ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ዓሢ ዒማና ጉምዓቲ ዚጊ ናንጊና ናንጋ ጎዳ ካኣሽካዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«ታ ጎዳሢም ጫኣቄ ጫኣቁሞና ናንጊና ናንጋ ናሹሞና ካፔ ታ ጎዳሢ ዓብራሃሜኮ ጎዳ ማዔ ፆኦዛሢ ጋላቲንቶንጎ፤ ሴካ ሃንጋ ጌይሲ ዻቢሱዋዖ ታ ጎዳሢኮ ዒሾንሢ ባንሢ ታና ዔኪ ሙኬሢ ዒዛኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ዬማፓ ናዔላ ማኣሪ ጳሽኪ ዓኣዻዖ ማዔ ባኮ ቢያ ዒዞኮ ዒንዶንታ ዒንዶና ዎላ ዓኣ ዓሶንታም ቢያ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ዒርቢቃኮ ዒሾ ላኣባ ጎዖሢ ዓብራሃሜም ማዾ ማዻ ዓሢ ዓኣ ዔቶ ዋኣፆ ባንሢ ጳሽኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ዒርቢቃኮ ዒሼ፥ ላኣባ ዓሢ ባንሢ ዓኣዼሢ ጌኤዴላ ሲኢዻ ዓኣሤ ባኮና ኩጫ ዓኣሤ ጋዎና ዛጌሢሮ፤ ጊንሣ ሃሣ ዓሢ ዒርቢቃም ጌዔ ባኮ ዒዛ ኬኤዜም ዋይዜሢሮኬ። ዓሢ ዔቶ ዋኣፆ ዓጫ ሃጊ ጋኣላሢና ዎላ ዔቂ ዓኣንቴ ዒዚ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ዬያሮ ላኣባ ዓሢ ኮራ፦ «ሃይ ኔ፥ ናንጊና ናንጋ ጎዳ ዓንጄ ዓሢዮ! ሃኒ ሙኬ ማኣሪ ኑ ዓኣዾም፤ ሃካ ዋኣፆ ዓጫ ኔ ዓይጎሮ ዔቄይ? ኑ ማኣራ ኔ ሃውሻንዳ ቤሲ ዓኣኔ፤ ኔኤኮ ጋኣላሢማኣ ዎርቃኒ ጊኢጊንቴ ቤሲ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ዬካፓ ላኣባና ዎላ ዒ ዔያቶ ማኣሪ ዓኣዼኔ፤ ዒርቢቃኮ ዒሼ፥ ላኣባ ጋኣላሢ ዑፆይዳ ዓኣ ጫኣኖ ቡላዖ ጎቦንታ ሜሎ ዖሆንታ ጋኣላሢም ዒንጌኔ፤ ዬካፓ ዓብራሃሜም ማዾ ማዻሢና ዒዛና ዎላ ዓኣ ዓሶናም ቶኮ ዔያታ ማስታንዳ ዋኣሢ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ዬያቶ ሾኦጮም ካሣ ሺኢካዛ ዓብራሃሜም ማዾ ማዻ ዓሢ፦ «ታ ሙኬ ባኮ ዛሎ ኬኤዙዋዖ ካሣ ሙዓዓኬ» ጌዔኔ። ላኣባ ዒማና፦ «ዓይጌ ዓኣዖ፥ ኬኤዙዋይ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ዒዚ፦ «ታኣኒ ዓብራሃሜም ማዾ ማዻያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ናንጊና ናንጋ ጎዳ ሚርጌ ታ ጎዳሢ ዓብራሃሜ ዓንጄኔ፤ ዖርጎቺ ዓሲያ ዒዛ ማሄኔ፤ ሚርጌ ማራይ፥ ዋኣሪንታ ባይንታ፥ ቢራንታ ዎርቄንታ፥ ማዾ ማዻ ዓቲንቄንታ ላኣሊንታ፥ ጋኣሎንታ ሃሬያ ሚርጌ ዒዛም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ታ ጎዳሢኮ ማቻ ሳኣራ ጋርቼዖ ዓቲንቄ ናይ ዒዛም ሾዔኔ፤ ታ ጎዳሢያ ዒዛኮ ዓኣ ቆሎ ቢያ ዬያ ናዓሢም ዻካልሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","ታ ጎዳ፥ ዓብራሃሜ፦ ‹ታኣኒ ዔያቶና ዎላ ናንጋ ካኣናኔ ዓሶ ዉዱሮ ናኣቶ ባኣካፓ ታ ናዓሢም ላኣሊ ኔ ማዢሱዋጉዲ፤ ጋዓንቴ ታ ዓዶ ማኣሮ ዓሶና ታ ዒጊኖና ኮራ ዓኣዺ ታ ናዓሢም ላኣሊ ማዢሴ› ጌዒ ታና ጫኣቂሴኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ታኣኒ ታ ጎዳሢ ኮራ፦ «ናዔላ ታኣና ሙካኒ ናሽኪባኣቶ ዎዶንዶይ?» ጌዒ ዖኦጫዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ዒዚ ሂዚ ታኣም ጌዔኔ፦ «ቢያ ዎዴና ታ ዒዛም ማዻ፥ ናንጊና ናንጋ ጎዳሢ ፔኤኮ ኪታንቻሢ ኔኤና ዎላ ዳካንዳኔ፤ ሃንቲፃኣ ኔኤም ኮሽኬያ ማዓንዳጉዲ ዒ ጊኢጊሻንዳኔ፤ ዬያይዲ ኔኤኒ ታ ዓዶ ማኣሮና ታ ዒጊኖና ባኣካፓ ታ ናኣዚም ላኣሊ ማዢሲ ዒንጋኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ጫኣቁማፓ ዙላ ኔኤኒ ማዓንዳሢ ታ ዒጊኖ ኮራ ኔ ዓኣዻዛ ዔያታ፦ ናዔሎ ኔኤም ኑ ዒንጋዓ ጌዒ ላኣጌቶ ሌሊኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«ዬካፓ ሃኖ ዔቶ ዋኣፆ ዓጮ ሙካዖ ታ ሂዚ ጌዒ ሺኢቄኔ፦ ‹ታ ጎዳሢ ዓብራሃሜኮ ጎዳ ማዔ ፆኦዛሢዮ! ሃዳራ ታ ሙኬ ባኮ ዛሎ ኔኤኒ ታኣም ጊኢጊሻንዳጉዲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ሃኣዛጌ ሃይካ ዔቶ ዋኣፆ ዓጫ ታኣኒ ዔቄኔ፤ ፔቴ ዉዱሮ ናይ ዋኣሢ ዱዓኒ ሙካኣና፥ ሃዳራ ጉዛፓ ዻካ ዋኣሢ ታና ዑሼ› ጌዒ ታኣኒ ዖኦጫንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ዒዛኣ ‹ዓይጌ ዓኣዖ ዑሽኩዋይ፤ ኔኤኮ ጋኣላሢማኣ ታ ዱዓንዳኔ› ጋዓያ ማዔቶ፥ ዬና ታ ጎዳሢ ናኣዚኮ ማቾ ማዓንዳጉዲ ኔኤኒ ዶኦሬዜሎ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ዬማ ጌዒ ዒኖና ሺኢጲፆ ታኣኒ ጋፒሱዋንቴ ዒርቢቃ ዋኣሢ ጉሲ ባሲ ሙካዖ፥ ዔታፓ ዋኣፆ ዱዒ ኬስካዛ፥ ታኣኒ ‹ዔናኣ፥ ሃዳራ ዻካ ዋኣሢ ታና ዑሼቴራ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ዒዛ ጉዞ ጌኤታፓ ዑኬና ኬይሲ ዛላሳዖ፦ ‹ዓይጌ ዓኣዖ፥ ዑሽኩዋይ፤ ታ ኔኤኮ ጋኣላሢያ ዱይ ዑሻንዳኔ› ጌዔኔ፤ ዬያሮ ታናንታ ታኣኮ ጋኣላሢንታ ዋኣፆ ዑሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ታኣኒያ ‹ኔ ዖ ናይዳይ?› ጌዒ ዖኦጬኔ። ዒዛ፦ ‹ታኣኒ ናኮሬ ናኣዚ ባኣቱዔኤሌ ናይኬ፤ ዒንዳ ዒዛኮ ሚልካ ጋዓዜሎኬ› ጌዔኔ። ዬካፓ ሲኢዻ ጉዴቾ፥ ኩጫ ታ ዒዞኮ ጋዊ ዓኣሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ዬካፓ ጉምዓቲ ዚጊ ናንጊና ናንጋ ጎዳ ካኣሽካዖ፥ ታ ጎዳሢ ዓብራሃሜኮ ጎዳ ማዔ ፆኦዛሢ ታኣኒ ጋላቴኔ፤ ዓይጎሮ ጌዔቶ ታ ጎዳሢኮ ናኣዚም ማቾ ማዓንዳ ላኣሊ ታ ዴንቄ ቤዞ፥ ታ ጎዳሢኮ ዒሾ ማኣሪ ፒዜ ማዔ ጎይሢና ዔኪ ሙኬሢ ታና ዒዛኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ዓካሪ ታ ጎዳሢኮ ሃዳሮ ጎኔና ዒንሢ ዔኪ ዒዛ ዎዛሳኒ ናሽካያ ማዔቴ ታኣም ኬኤዙዋቴ፤ ናሽኩዋያ ዒንሢ ማዔቴያ ጎኑሞማ ታኣም ኬኤዙዋቴ፤ ታ ዴንዲ ሜሌ ኮዖም» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ላኣባና ባኣቱዔኤሌና፦ «ሃይ ባካ ናንጊና ናንጋ ጎዳይዳፓ ሙኬያ ማዔሢሮ፥ ኑኡኒ ላኣጋኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ዒርቢቃ ኔ ኮራ ሃናሾ፤ ሃይሾ፥ ዒዞ ዔኪ ዓኣዼ፤ ናንጊና ናንጋ ጎዳ ፔ ቶኦኪና ኬኤዜሢጉዲ ኔ ጎዳኮ ናኣዚ ማቾ ዒዛ ማዖንጎ» ዔያታ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ዓብራሃሜም ማዾ ማዻሢ ዬያ ዋይዜ ዎዶና ጉምዓቲ ዚጊ ናንጊና ናንጋ ጎዳ ካሽኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ዎርቄና ቢራ ዓንጊናይዳፓ ማዢንቴ ፓልሞ፥ ዬያጉዲ ሃሣ ዓፒላኣ ኬሲ ዒርቢቃም ዒንጌኔ፤ ዒዞኮ ዒሾና ዒንዶናም ሚርጌ ሚኢሼም ሻንቺንታያ፥ ናሻ ማኣዖዋ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ዬካፓ ዓብራሜም ማዾ ማዻሢና ዒዛና ዎላ ዓኣዞንሢ፥ ሙዒ ዑሽኪ ዒኢካ ዎርቄኔ፤ ዚሮ ጉቴ ዔቃዖ ዓብራሃሜም ማዾ ማዻሢ፦ «ዓካሪ ታ ጎዳሢ ባንሢ ማዒ ታኣኒ ዴንዶም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ዒርቢቃኮ ዒሾና ዒንዶና ጋዓንቴ፦ «ናዔላ ታጶ ኬሊ ጉዴያ ኑኡና ዎላ ዴዖንጎ፤ ዬካፓ ኔኤና ዎላ ዓኣዻኒ ዒዛ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ዒዚ ጊንሣ፦ «ሃዳራቴ፥ ታና ናጊሲፖቴ፤ ናንጊና ናንጋ ጎዳሢ ታኣኒ ሙኬ ባኮ ዛሎ ኮሼሢሮ ዑኬና ታ ጎዳሢ ባንሢ ታ ማዒ ዴንዶም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ዔያታኣ፦ «ሂዴቶ ናዔሎ ኑ ዔኤሊጋፓ ዒዛ ጋዓ ባኮ ኑ ዋይዞም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ዬያሮ ዒርቢቃ ዔያታ ዔኤላዖ፦ «ሃያ ዓሢና ዎላ ዓኣዻኒ ኔኤኒ ኮዓ?» ጌዒ ዒዞ ዖኦጫዛ ዒዛ፦ «ሂዮ፥ ታ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ዬካፓ ዔያታ ዒርቢቃ ዒዞ ዞሪ ዲቻዜሎ ፔኤና ዔኪ፥ ዓብራሃሜም ማዾ ማዻሢንታ ዒዛና ዎላ ዓኣ ዓሶና ዓኣዻንዳጉዲ ዔልቃማዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","«ኔኤኒ ኑ ጌኤዴላ ሚርጌ ዴሬኮ ዒንዶ ማዔ፤ ኔኤኮ ዜርፃ ኔ ሞርኮኮ ካታሞ ባሺሢና ዔኮንጎ» ጌዒ ዒርቢቃ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ዬካፓ ዒርቢቃንታ ዒዞ ጊንፆ ዓኣዻ ዒዞም ማዾ ማዻ ላኣሎንሢንታ ጋኣላሢ ቶጊ ዓብራሃሜም ማዾ ማዻ ዓሢና ዎላ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ዒማና ዪሳኣቄ «ቢዔርላሃይሮዒ (ታና ዛጋ ናንጊና ናንጋ ፆኦሲ)» ጌዒንታ ዴዔ ቦቆሊ ዋኣሢ ዓኣ ቤሲ፥ ዳውሌ ሙኪ ኔጌቤ ጎዖ ቤዞይዳ ዴዒ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ፔቴ ኬሊ ሳዓ ሃባርታንቴ ቦኦሎ ፔጎይዳ ሴካ ሃንጋ ሃንቲ ሃንቲ ዒዚ ፔ ማሊሢዳ ዓኣዖ ጋኣላ ሃኬና ሙካያ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ዒርቢቃ ዪሳኣቄ ዴንቃዖ ዒዛ ቶጌ ጋኣላሢዳፓ ኬዲ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","«ሃይሴኬ፥ ቦኦሎ ፔጎይዳ ኑ ባንሢ ሙካሢ ዖናዳይ?» ጌዒ ዓብራሃሜም ማዾ ማዻሢ ኮራ ዖኦጫዛ፥ ዒዚ፦ «ታኣኮ ጎዳሢ፥ ዪሳኣቄኬ» ጌዔኔ። ዬያሮ ዑኬና ዒዛ ፔኤኮ ዓኣፖ ካሮ ፔኤኮ ቶኦኮ ዖሾና ባኮና ካንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ዓብራሃሜም ማዾ ማዻሢያ ዒዚ ዴንዲ ማዼ ባኮ ቢያ ዪሳኣቄም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ዬካፓ ዪሳኣቄ ቤርታ ዒንዳ ሳኣራ ናንጋ ዓፒሎና ማዢንቴ ማኣሮ ዒርቢቃ ዔኪ ጌሌኔ፤ ማቾዋ ዒዛኮ ዒዛ ማዔኔ፤ ዪሳኣቄ ዒርቢቃ ናሽኬኔ። ዬያይዲ ዒንዶ ሃይቦ ዛሎና ሄሌ ሲዮይዳፓኣ ዒዚ ዶዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ሳኣራ ሃይቄሢኮ ጊንፃ ዓብራሃሜ ሜሌ ኬፁራ ጌይንታ ላኣሊስኬኖ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ዒዛኣ ዚምራኔ፥ ዮቂሻኔ፥ ሜዳኔ፥ ሚዲያሜ፥ ዩሽባቄኔንታ ሹሃኔ ጎዖስኬንሢ ዓብራሃሜም ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ዮቂሻኔ ጎዖሢ ሳባኔና ዴዳኔ ጎዖዞንሢ ሾዔኔ፤ ዴዳኔ ጎዖሢኮ ዜርፃ ዓሹሬ ዓሶ፥ ሌፁሻ ዓሶና ዔማ ዓሶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ሚዲያሜ ናኣቶንሢ ዔፓ፥ ዔፔሬ፥ ሃኖኬ፥ ዓቢዳዒና ዓልዳዓ ጎዖዞንሢ ማዓዛ ዬንሢ ቢያ ኬፁራ ናኣቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ዓብራሃሜ ፔኤኮ ዓኣ ቆሎ ቢያ ዪሳኣቄ ዻካልሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ሜሌ ላኣሎይዳፓ ዒዛም ሾይንቴ ናኣቶም ጋዓንቴ ዓብራሃሜ ሃይቂባኣዖ ኮይሳ ባኣዚ ዒንጊ፥ ዒዛኮ ናኣዚ ዪሳኣቄይዳፓ ሃኪሲ ሴካ ዓባ ኬስካ ዛሎ ባንሢ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ዓብራሃሜ ናንጌ ሌዓ ፄኤታና ላንካይታሚ ዶንጎኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ዬያይዲ ዓብራሃሜ ጊዳያ ዖዶሲ ሌዔ ናንጊ ጋርቼዖ ሃይቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ናኣታ ዒዛኮ ዪሳኣቄና ዒስማዔኤሌና ማክጴላ ጌይንታ ዴኖ ዔታ ዓኣ ቤዜሎይዳ ዒዛ ዱኡኬኔ፤ ዬይ ዴኖ ዔታ ዓኣ ቤዛ ሜሚሬ ጎዖ ቤዜሎኮ ዓባ ኬስካ ባንፆና ሄኤቴ ዜርፃሢ ፆሃሬ ናኣዚ ዔፕሮኦኔ ጎዦ ጋራ ዓኣዞኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ዬና ቤዜላ ዓብራሃሜ ሄኤቴ ዓሢዳፓ ሻንቄ ዱኡፖ ቤዜሎታሢሮ ዓብራሃሜያ ዒዛኮ ማቻ ሳኣራ ዱኡኪንቴ፥ ዴኖ ዔታ ዓኣ ቤዜሎይዳ ዱኡቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ዓብራሃሜ ሃይቄሢኮ ጊንፃ ፆኦሲ ዒዛኮ ናኣዚ ዪሳኣቄ ዓንጄኔ፤ ዪሳኣቄያ ቢዔርላሃይሮዒ ጌይፃ «ታና ዛጋ ናንጊና ናንጋ ጎዳሢ» ጌይንታ ቦቆሎ ዓጫ ናንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ዓጋኣሮ ጌይንታ ሳኣራኮ ማዾ ማዻ ጊብፄ ዓጮ ላኣሌላ ዓብራሃሜም ሾዔ ናኣዚ ዒስማዔኤሌ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ሃይፓ ዴማ ፔኤኮ ሌዖ ሌዖ ጉዴያ ጌሢንቲ ፓይዲንታ ናኣቶ ሾዔኔ፤ ዔያታኣ፦ ኔባዮቴ፥ ቄዳሬ፥ ዓዲባዔኤሌ፥ ማቢሳሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ሚሽማዔ፥ ዱማ፥ ማሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ሃዳዴ፥ ቴማ፥ ዪፁሬ፥ ናፕሼንታ ቄዳሜ ጎዖዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ዬንሢ ዒስማዔኤሌ ናኣቶንሢ ታጶ ላምዖ ቶይዶኮ ቤርታኣ ማዖንሢኬ፤ ሱንፃ ዔያቶኮ ዔያታ ናንጌ ካታሞና ቤዞና ዔኤሊንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ዒስማዔኤሌያ ሌዓ ዒዛኮ ፄኤታና ሃይሢታሚ ላንካይ ማዓዛ ሃይቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ዒስማዔኤሌ ዜርፃ ጊብፄ ዓጮኮ ዓባ ኬስካ ዛሎና ዓሶኦሬ ዓጮ ዓኣዻ ጎይፃ ሃዊላና ቤሹሬ ጌይንታ ዓጮ ባኣካ ናንጋያ ማዓዛ፥ ናንጋ ዔያቶኮ ሃንጎ ዓብራሃሜ ዜርፆና ዎላ ፑርቲ ዎሊፓ ሃኪኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ዓብራሃሜ ናኣዚ ዪሳኣቄ ዛሎ ሃይሳ ያዺኬ፤ ዓብራሃሜ ዪሳኣቄ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ዪሳኣቄ ባኣቱዔኤሌ ናዎ ዒርቢቃ ዔካኣና ሌዓ ዒዛኮ ዖይዲታሚኬ፤ ዒርቢቃኮ ዓዶ ባኣቱዔኤሌና ዒሾ ላኣባና ሜሶፖታሚያይዳ ናንጋ ዓራሜ ዓጪ ዓሲኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ዒርቢቃ ዞኦኮ ማዔሢሮ ዪሳኣቄ ዒዞ ዛሎ ናንጊና ናንጋ ጎዳ ሺኢቃዛ፥ ጎዳሢ ዒዛኮ ሺኢጲፆ ዋይዜም ዒርቢቃ ጎጳዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ዒዛ ሜንቴ ጎጳዻዛ ናኣታ ጎጶ ጋራ ዎሊና ሂዒንቲሢ ዓርቄሢሮ ዒዛ፦ «ሃያጉዴ ባኣዚ ዎይታዛ ታጊዳ ማዺንታኒ ዳንዳዔይ?» ጌዒ ናንጊና ናንጋ ጎዳ ሺኢቂሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ናንጊና ናንጋ ጎዳሢያ ዒዞም፦ «ኔኤኮ ጎጶ ጋሮይዳ ላምዖ ዴሬ ዓኣኔ፤ ዎሊም ዋይዙዋያ ላምዖ ዜርሢ ኔ ሾዓንዳኔ፤ ፔቴይ ባጋሢዳፓ ባሻያ ማዓንዳኔ፤ ቶይዲ ጌኤዚኮ ዓይሌ ማዓንዳኔ» ሂዚ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ሾይጫ ዓርቄ ዎዶና ሜንቴ ዓቲንቄ ናይ ዒዛ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ቤርታ ሾይንቴሢኮ ማላሢ ዞቄ፥ ዑፃኣ ጋፓኔና ማዔሢሮ «ዔኤሳዎ» ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ላምዓሳሢ ሾይንታኣና ዔኤሳዎኮ ዲንጊርዦ ዓርቂ ሾይንቴሢሮ «ያይቆኦቤ» ጌይንቴኔ። ናኣታ ሾይንታኣና ሌዓ ዪሳኣቄኮ ላሂታሚኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ዪሳኣቄኮ ላምዖ ናኣቶንሢ ዲጬኔ፤ ዔኤሳዎ ካይካ ፔኤቂ ኬሞ ናሽካያ ማዓዛ፥ ያይቆኦቤ ጋዓንቴ ማኣሪዳ ፔኤቃ ዚቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ዪሳኣቄ ዔኤሳዎ ባሼ ናሽካኔ፤ ዓይጎሮ ጌዔቶ ዔኤሳዎ ኬማሢና ቦዖ ዓሽኪ ሙኡዛሢሮኬ። ዒርቢቃ ጋዓንቴ ያይቆኦቤ ናሽካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ፔቴ ኬሊና ዔኤሳዎ ካዮ ኬማሢዳፓ ሚርጌ ናይዺንቲ ሙካንቴ ጌኤዚ ያይቆኦቤ ሲንጊሮና ዞቄ ዎፄ ዎፄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ዔኤሳዎ ያይቆኦቤ ኮራ፦ «ታ ኮሺ ናይዺንቴሢሮ ሃያ ዞቄ ዎፆ ታና ሙኡዜቴራ» ጌዔኔ። ዬያሮኬ ዔኤሳዎ ዔዶኦሜ ጌይንቴሢ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ያይቆኦቤ ዒማና፦ «ቤርታዺ ቶይዱሞ ኔኤኮ ታኣም ሻንቼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ዔኤሳዎ ማሃዖ፦ «ታና ናያ ዎዻኔ፤ ቶይዱማ ታኣም ዓይጎ ዎኦታንዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ያይቆኦቤ ጊንሣ፦ «ያዺታቶ ቶይዱሞ ኔ ታኣም ሻንቻንዳሢ ቤርታዺ ጫኣቄ» ጋዓዛ፥ ዔኤሳዎ ጫኣቂ ቶይዱሞ ያይቆኦቤም ሻንቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ዬካፓ ያይቆኦቤ ሲንጊሮ ዎፆ ካሣና ዔኤሳዎም ዒንጋዛ፥ ዒዚያ ሙዒ ዑሽኬሢኮ ጊንፃኣፓ ዔቂ ዓኣዼኔ፤ ዬያይዲ ዔኤሳዎ ፔኤኮ ቶይዱሞ ቦሂ ሼሌዒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ዓብራሃሜ ዓኣ ዎዶና ኬስኬ ናዮጉዲ ናይዚ ዓጮይዳ ላሚ ኬስኬሢሮ፥ ዪሳኣቄ ፒሊስፄኤሜ ካኣቲ ዓብሜሌኬ ዓኣ ዓጮ ጌሬራ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ናንጊና ናንጋ ጎዳ ዪሳኣቄም ቤርታ ፔጋዺ ጴዺ፦ «ጊብፄ ዓጮ ዓኣዺፖ፤ ኔ ናንጋንዳጉዲ ታ ኬኤዛ፥ ሃኖ ዓጮይዳ ዴዔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ዒኢካ ናንጌ፤ ታኣኒ ኔኤና ዎላ ማዒ፥ ኔና ዓንጃንዳኔ፤ ሃያ ዓጮ ኔኤና ኔ ዜርፆናም ታ ዒንጋንዳኔ፤ ዬያይዲ ኔ ዓዶ ዓብራሃሜም ታ ጫኣቄ ጫኣቁሞ ኩንሣንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ኔኤኮ ዜርፆ ጫሪንጫ ዦኦጋሢጉዲ ታ ሚርጊሻንዳኔ፤ ሃሣ ሃያ ዓጮ ቢያ ታ ዔያቶም ዻካልሳንዳኔ፤ ዓጫ ዓኣ ዴራ ቢያ ኔ ዜርፆና ዓንጂንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ኔና ታ ዓንጃሢ ኔ ዓዴ ዓብራሃሜ ታኣም ዓይሢንታያ ማዒ ታ ዒዛም ዒንጌ ዎጎ ቢያ ዒዚ ካፔሢሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ዬያሮ ዪሳኣቄ ጌሬራ ዓጮይዳ ዴንዲ ናንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ዬኖ ዓጮ ዓሳ ዪሳኣቄ ኮራ፦ «ዒርቢቃ ኔኤኮ ዓይጎዳይ?» ጌዒ ዖኦጫዛ፥ ዒዚ፦ «ታኣኮ ዒዛ ጌሮኬ» ጌዔኔ፤ ዬያ ዒዚ ጌዔሢ ዒርቢቃ ሚዛጲታሢሮ ዬኖ ዓጮ ዓሳ ዒዞ ሚዛጱሞሮ ዒዛ ዎዹዋጉዲ ዒጊጬሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ዬካፓ ዪሳኣቄ ዬኖ ዓጮይዳ ሚርጌ ዎዴ ዴዔሢኮ ጊንፃ ፒሊስፄኤሜ ካኣቲ ዓቤሜሌኬ ፔጋሮይዳ ዓኣዖ ኬኤፆኮ ፑልቶ ካሮና ዛጋንቴ ዪሳኣቄ ዒርቢቃና ማቾጉዲ ዑፆ ዓርቂ ዓማላንቴ ዴንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ዬያሮ ካኣቲ፥ ዓቤሜሌኬ፥ ዪሳኣቄ ዔኤሊሳዖ፦ «ሃይሾ ዒርቢቃ ኔኤኮ ማቾኬ! ሂዳዖ ኔኤኒ ዒዛ ታኣኮ ጌሮኬ ጌዔሢ ዓይጎሮዳይ?» ጌዒ ዖኦጬኔ። ዪሳኣቄያ ማሃዖ፦ «ዒዛ ታኣኮ ማቾኬ ታ ጌዔቶ ዓሳ ታና ዎዻንዳኔ ጌዒ ታ ዒጊጬሢሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ካኣቲ ዓቤሜሌኬ፦ «ሃይ ኔ ኑጊዳ ማዻ ባካ ዓይጌንዴዳይ? ኑ ዓሶይዳፓ ፔቴ ዓሲ ያዺ ኔ ጌዔሢሮ ማቾ ኔኤኮ ዒኢሳኒ ዳዳንዳዓኔ፤ ዬያና ኑና ኔ ጎማሴዖ ዓቴኔ፤» ");
INSERT INTO mdyeth_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ሄሊሳዖ ሃሣ ዓቤሜሌኬ፦ «ሃያ ዓሢና ማቾና ካኣማ ዓሲ ሃይቃንዳኔ» ጌዒ ዴሮም ኮሺ ላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ዪሳኣቄያ ዬኖ ዓጬሎይዳ ጎሺ ጎሽካዛ፥ ናንጊና ናንጋ ጎዳ ዒዛ ዓንጄሢሮ ዬኖ ሌዖይዳ ሚርጌ ሃኣኮ ዒዚ ካሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ቆሎይዳ ቆሎ ቃሲንቲ ቃሲንቲ ዒዛም ዓኣዼሢሮ ሚርጌና ዒ ዖርጎጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ሚርጌ ማራይ፥ ዋኣሪ፥ ባይንታ ዬያጉዲ ሃሣ ሚርጌ ማዻ ዓሲያ ዒዛኮ ዓኣሢሮ ፒሊስፄኤሜ ዓሳ ቂኢሩሞ ዒዛ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ዬያሮ ዪሳኣቄኮ ዓዴ ዓብራሃሜ ሳዛና ዓኣንቴ ዓብራሃሜኮ ማዻ ዓሳ ቦኦኬ ዋኣፆ ዔቶ ቢያ ፒሊስፄኤሜ ዓሳ ሲንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ዬኖ ዎዶና ካኣቲ ዓቤሜሌኬ ዪሳኣቄም፦ «ኔ ኑ ጊዳፓ ዳልጊ፥ ዶዲ ዶዲ ዓኣዼሢሮ፥ ኑ ዓጮ ሃሺ ኬስኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ዬያሮ ዪሳኣቄ ዬኖ ቤዜሎ ሃሺ ጌሬራ ዓጮኮ ዶኦጮይዳ ዱንኪ፥ ዒኢካ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ዓብራሃሜ ሳዛና ዓኣዖ ቦኦኪሴ ዋኣፆ ዔቶ፥ ዓብራሃሜ ሃይቄሢኮ ጊንፃ ፒሊስፄኤሜ ዓሳ ሲንሤሢ፥ ዪሳኣቄ ላሚ ቦኦኪሳዖ ዓዴ ጌሤ ሱንፆና ዬያ ዔቶ ዔኤሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ዪሳኣቄም ማዾ ማዻ ዓሳ ዶኦጮይዳ ዋኣሢ ዔቴ ቦኦካዖ ሚርጌና ዓልቃ ዋኣሢ ዴንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ጌሬራ ዓጮኮ ቆልሞ ሄንቃ ናኣታ ጋዓንቴ «ሃይ ዋኣፃ ኑኡሮኬ» ጌዒ ዪሳኣቄኮ ቆልሞ ሄንቃ ናኣቶና ዣሎ ማዤሢሮ ዪሳኣቄ ዬኖ ዔቴሎ «ዑራ» ጌይ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ሃሣ ዪሳኣቄኮ ማዻ ዓሳ ሜሌ ዋኣሢ ዔቴ ቦኦካዛ፥ ዬኖይዳኣ ሃሣ ዣላ ዔቄሢሮ ዪሳኣቄ ዬኖ ዔቴሎም «ዒፂሢ» ጋዓ ሱንሢ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ዬካፓ ዶጫዖ ሜሌ ዋኣሢ ዔቴ ቦኦካዛ፥ ዬኖ ዔቴሎ ዛሎና ዣላ ዔቂባኣሢሮ «ሃይሾ ዓካሪ ናንጊና ናንጋ ጎዳ ዳልጊ ቤሲ ኑኡም ዒንጌኔ፤ ሳዖይዳ ኑ ሚርጋንዳኔ» ጋዓዖ ዬኖ ቤዜሎ «ዳልጊ ቤሲ» ጌዒ ሱንሢ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ዬካፓ ዪሳኣቄ ሌካ ቤርሳቤ ጌይንታ ዓጮ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ዬኖ ዋንቴሎ ናንጊና ናንጋ ጎዳ ዒዛም ፔጋዺ ጴዻዖ፦ «ታኣኒ ኔኤኮ ዓዶ ዓብራሃሜ ፆኦሲኬ፤ ታ ኔኤና ዎላ ማዔሢሮ ዒጊጪፖ! ታኣም ማዻሢ፥ ዓብራሃሜም ታ ጫኣቄ ጎይፆና ታ ኔና ዓንጃንዳኔ፤ ዜርፆዋ ታ ኔኤኮ ሚርጊሻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ዪሳኣቄ ዬካ ፆኦሲም ዒንጎ ባኮ ዒንጊ ካኣሽኮ ቤሲ ሹቺና ኮሺ፥ ዒኢካ ዚጊ ናንጊና ናንጋ ጎዳ ካኣሽካዖ፥ ናንጎ ቤዞዋ ዒዞይዳ ማሄኔ፤ ዒዛም ማዾ ማዻ ዓሳ ሃሣ ሜሌ ዋኣሢ ዔቴ ቦኦኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ካኣቲ ዓቤሜሌኬ ዒዛ ዞራሢ ዓሁዙቴና ዖሎ ዓሶ ዓይሣ ፒኮሌና ዎላ ዪሳኣቄ ዖኦጫኒ ጌሬራ ዓጮ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ዪሳኣቄ ዒማና፦ «ሃያኮ ቤርታ ታና ዒንሢ ዒፂ ዒንሢ ዓጫፓ ኬሴኔ፤ ሃሢ ሃኖ ታና ዛጋኒ ዓይጋ ዒንሢ ሙኬይ?» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ዔያታ ማሃዖ፦ «ናንጊና ናንጋ ጎዳ ኔኤና ዎላ ዓኣሢ ጎኔና ኑ ዔሬሢሮ፥ ኑ ኔኤና ዎላ ኮሹሞና ናንጋኒ ጫኣቂሢሮ ማሌኔ፤ ኔ ኑኡና ጫኣቃንዳጉዲ ኑ ኮዓሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ኔ ዑፃ ኑ ፑርታ ባኣዚ ማዺባኣሢጉዲ ኔኤኒያ ኑኡም ቢያ ዎዴና ፑርታ ባኣዚ ማዺንዱዋጉዲኬ፤ ዓይጎሮ ጌዔቶ ኔጊዳ ኑ ዓይጎዋ ፑርቱሞ ማዾ ማዺባኣሴ፤ ኑ ዓጮይዳፓ ኔ ኬስኬሢያ ኮሹሞናኬ፤ ናንጊና ናንጋ ጎዳ ኔና ዓንጄሢ ኑና ቢያሢም ዔርቴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ዬካፓ ዪሳኣቄ ዔያቶም ሚርጌ ሙኡዚንታ ዑሺያ ጊኢጊሻዛ፥ ዔያታ ሙዒ ዑሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ዚሮ ጉቴሎ ዓማ ዔቃዖ ዔያታ ዎላ ጫኣቄኔ፤ ዬካፓ ዪሳኣቄ ዔያቶ ዳኬም ኮሺና ዔያታ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ዬኖ ኬሎና ዪሳኣቄም ማዻ ዓሳ ሙኪ ዔያታ ቦኦኬ ዋኣፆ ዔቶ ዛሎ ዒዛም ኬኤዜኔ፤ ዔያታ ኬኤዛዖ፦ «ዋኣሢያ ኑ ዴንቄኔ» ጌዒ ዎዛ ሃይሴ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ዒዚ ዬኖ ዔቴሎኮ ሱንፆ «ጫኣቁሞ» ጌዒ ጌሤሢሮ ካታሜሎኮ ሱንፃ ሃኖ ሄላንዳኣና «ቤርሳቤ» ጌዒ ዔኤሊንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ዔኤሳዎኮ ሌዓ ዖይዲታሚ ማዓዛ ቢዔሬኮ ናዎ ዮዲቶ ጎዖዞና ዔሎኔ ናዎ ባስማቴ ጎዖዞና ዒዚ ዔኬኔ፤ ዬንሢ ላምዖንሢ ሄኤቴ ዓሶ ፃጲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ዬንሢ ላኣሎንሢ፥ ዒዛኮ ዓዶ ዪሳኣቄና ዒንዶ ዒርቢቃናም ቢያ ዎዴ ኮሽኩዋያ ማዒ ማሊሲ ማሊሲ ናንጋያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ዪሳኣቄ ዓኣፒ ባይቂ ጋርቻዖ ፔኤኮ ናኣዚ ቶይዲ፥ ዔኤሳዎ፦ «ታ ናዓሢዮ!» ጌዒ ዔኤላዛ፥ ዒዚያ «ዮ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ዪሳኣቄ ዬካፓ፦ «ኔኤኒ ታና ዛጋሢጉዲ ታ ጋርቼኔ፤ ሃሣ ሃይቃኒያ ታ ዑኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ኔ ኬማሢ ኬማ ዓኣዞ ዔኪ ካዮ ዓኣዺጋፓ ቦዎ ኬሚ ዎዺ ዓሽኮ ታኣም ዔኪ ሙኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ታኣኒ ናሽካ ጎይፆጉዴያ ዓኣፂሲ ካሢ ጊኢጊሼ፤ ታ ሙዔሢኮ ጊንፃ ሃይቃንዳሢኮ ቤርታ ጋፒንሢ ዓንጆ ታ ኔኤም ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ዪሳኣቄያ ፔኤኮ ናኣዚ ዔኤሳዎም ጋዓሢ ቢያ ዒንዴላ ዒርቢቃ ዋይዜኔ፤ ዬካፓ ዔኤሳዎ ኬማሢ ዴንዳዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ፔኤኮ ናኣዚ ያይቆኦቤም፦ «ዓዴ ዔኤሳዎም፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹ቦዖ ኬሚ ዎዺ ዔኪ ሙኪ ታ ናሽካ ጎይፆጉዴያ ዓኣፂሲ ካሤ፤ ታኣኒ ሃይቁዋዖ ናንጊና ናንጋ ጎዳ ቤርታ ኔና ዓንጃንዳኔ› ሂዚ ጋዓንቴ ታ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ዓካሪ ታናዓሢዮ! ታ ኔኤም ጋዓሢ ዋይዚ፥ ታ ዓይሣ ባኮዋ ማዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ኔ ዓዴ ናሽካ ጎይፆጉዴያ ዓኣፂሲ ታ ዒዛም ሙኡዚ ጊኢጊሻንዳጉዲ፥ ቆልሞ ባኣካፓ ዓኣዺ ላምዖ ማሊ ዋናናይ ዔኪ ታኣም ሙኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ኔኤኒ ዬካፓ ታ ጊኢጊሼ ሙዖ ዔኪ ዓዴ ሙዓንዳጉዲ ዒንጌ፤ ኔ ዬያይዴቶ ኔ ዓዴ ሃይቃንዳሢኮ ቤርታ ኔና ዓንጃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ያይቆኦቤ ጋዓንቴ ዒንዶ ኮራ፦ «ታ ቶይዲ፥ ዔኤሳዎኮ ዑፃ ጋፓኔናኬ፤ ታ ዑፃ ጋዓንቴ ጉሪ ጋፓኔ ባኣያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ጎዖንቴ ዓዴ ታና ዓርቂ ዛጊጋፓ ታ ዒዛ ጌሻሢ ዔሬቶ ዓንጆይዳፓ ጋዳማ ታ ዔካንዳሢ ኔ ዔሩዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ዒንዳ ማሃዖ፦ «ታ ናዓሢዮ! ኔ ጋዳማ ታኣም ማዖንጎ፤ ሃሢ ታ ኔኤም ኬኤዛማ ማዼ፤ ዴንዲ ዋናቶንሢ ዔኪ ሙኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ዬያሮ ያይቆኦቤ ዓኣዺ ዋናቶንሢ ዒዞም ዔኪ ሙካዛ፥ ዒዛ ዓዴ ናሽካማ ጉዴያ ዓኣፃ ካሣ ካሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ዒዞኮ ናኣዚ ቶይዲ ዔኤሳዎኮ ዓሶ ባኣካ ኬስካዖ ማይንቶ ቦንቾ ዓፒሎዋ ጌሦና ቤዛፓ ዔኪ ያይቆኦቤ ዒዛ ማይሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ዋናናኣቶኮ ዒልዖዋ ኩጮ ዑፆና ባቃኖ ዙሎና ጋፓና ባኣ ቤዞ ማይሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ዬካፓ ዒዛ ጊኢጊሼ ኮዦ ዓሽኮ ካሦ ዒዞኮ ናኣዚ ያይቆኦቤም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ያይቆኦቤ ዓዶ ኮራ ሙካዖ፦ «ዓዴ!» ጌዔኔ። ዒዚያ «ዮ! ኔኤኒ ታ ናዓሦ ዖናዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ዬካፓ ያይቆኦቤ፦ «ታ ኔኤኮ ናኣዚ ቶይዲ ዔኤሳዎኬ፤ ኔኤኒ ታና ዓይሤሢ ጉዴያ ታ ማዼኔ፤ ሂንዳ ታና ዓንጃኒ፥ ዔቂጋፓ ታ ኬማሢዳፓ ዔኪ ሙኬ ዓሽኮ ሙዔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ዪሳኣቄ፦ «ታ ናዓሢዮ! ዎይቲ ዑኬና ኔ ዴንቃኒ ዳንዳዔይ?» ጋዓዛ፥ ያይቆኦቤ ማሃዖ፦ «ናንጊና ናንጋ ጎዳ፥ ኔኤኮ ፆኦዛሢ ታና ማኣዴሢሮ ዑኬና ታ ዴንቃኒ ዳንዳዔኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ዪሳኣቄ ጊንሣ፦ «ሂንዳ ታባንሢ ሙኬ፥ ታ ኔና ዓርቂ ዛጎም፤ ጎኔ ሃሢ ኔ ዔኤሳዎዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ያይቆኦቤ ዓዶ ባንሢ ሙካዛ፥ ዓዴ ዓርቂ ዛጋዖ፦ «ዑኡዛ ኔኤኮ ያይቆኦቤሲ ማላኔ፤ ኩጮ ቃሳ ጋዓንቴ ዔኤሳዎሲ ማላኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ዒዛኮ ኩጮ ቃሳ ዔኤሳዎሲ ማሌም ዪሳኣቄ ናኣዚ ያይቆኦቤ ዱማሲ ዔራኒ ዳንዳዒባኣሢሮ ዓንጃኒ ጊኢጊንቴስካፓ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","«ጎኔ፥ ኔ ታ ናኣዚ ዔኤሳዎዳ?» ጌዒ ላሚ ዖኦጫዛ፥ ዒዚያ፦ «ሂዮ! ታናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ዬካፓ ዪሳኣቄ፦ «ታ ናዓሢዮ! ሂንዳ ኔ ዔኪ ሙኬ ዓሽኮ ታኣም ሺኢሼ፤ ታ ሙዔሢኮ ጊንፃ ኔና ዓንጃንዳኔ» ጋዓዛ፥ ያይቆኦቤ ሙዖ ሺኢሺ ዎይኔይዳፓ ኮሾና ዑሺያ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ዬካፓ ዓዳሢ፥ ዪሳኣቄ፦ «ታ ናዓሢዮ! ሃኒ ሙኪ ታና ሄርቄ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ያይቆኦቤ ባንሢ ሙኪ ሄርቃዛ፥ ዪሳኣቄ ያይቆኦቤኮ ማኣዓሢ ሲንቃዖ፦ «ታ ናዓሢኮ ሳውማ ናንጊና ናንጋ ጎዳ ዓንጄ ጎሺ ሳውሞ ጉዲኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ፆኦሲ ጫሪንጫፓ ሎጪሳ ዖልኬ ኔኤም ዒንጎንጎ፤ ጎዦ ኔኤሲ ሚርጌና ካፃያ ማሆንጎ፤ ኔኤኮ ሃኣኮና ዎይናፓ ኮሾ ዑዦዋ ኔኤም ዒ ሚርጊሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ዓጫ ኔኤም ዎርቆንጎ፤ ዴራኣ ኔኤም ዓይሢንታያ ማዖንጎ፤ ኔ ዒጊኖኮ ቢያ ዑፃ ማዔ፤ ኔ ዒንዶ ናኣታ ቢያ ኔኤም ሂርኪ ጌዒ ዚጎንጎ፤ ኔኤም ጋዳንቃዞንሢ ፆኦሲ ጋዳንቃንዳኔ፤ ኔና ዓንጃዞንሢ ዒዚ ዓንጃንዳኔ» ጌዒ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ዪሳኣቄ ያይቆኦቤ ዓንጃዛ፥ ያይቆኦቤ ዓዶ ቤርታፓ ኬኬስካኣና ዔኤሳዎ ኬማሢዳፓ ማዒ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ዒዚያ ፔ ዛሎና ዓኣሢ ካሣ ጊኢጊሺ ዓዶም ሺኢሻዖ፦ «ዓዴ! ታና ዓንጃኒ ሂንዳ ዔቂጋፓ ታ ኔኤም ዔኪ ሙኬ ኬማሢ ዓሽኮ ሙዔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ዪሳኣቄ ዒዛ ኮራ፦ «ኔኤኒ ዖናዳይ?» ጋዓዛ፥ ዒዚ፦ «ታ ኔኤኮ ናኣዚ ቶይዲ ዔኤሳዎኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ዪሳኣቄ ዲቃቲ ሚርጌና ጎጋይቂ ጎጋይቂ፦ «ሂዳዖ ቤርታ ታኣም ኬማሢ ዓሽኮ ዔኪ ሙኬሢ ዖናዳዖ? ሃይማ ሃሢ ኔኤኮ ቤርቶማካ ታ ሙዒ፥ ጋፒንሢ ዓንጆ ታ ዒዛ ዓንጄኔ፤ ዓንጃኣ ማይ ዒዛሮ ማዒ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ዔኤሳዎ ዬያ ዋይዜ ዎዶና ዑኡዞ ዼጊዲ ዒናፓ ዬኤካዖ፦ «ዓዴ፥ ታናኣ ዓንጄ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ዪሳኣቄ ማሃዖ፦ «ኔኤኮ ጌኤዚ ሙኪ ታና ጌሺ ኔኤኮ ዓንጆ ዔኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ዔኤሳዎ ጊንሣ፦ «ዒዚ ታ ባኮ ዉኡቃንቴ ሃና ላምዓሶኬ፤ ሱንፃ ዒዛኮ ያይቆኦቤ ጌይንቴሢ ፒዜኬ፤ ሃያኮ ቤርታ ቶይዱሞ ታኣኮ ዔኬኔ፤ ሃሣ ታኣኮ ዓንጆዋ ሳርቲ ዔኬኔ፤ ማዔቶዋ ኔ ታኣም ዓይሴ ዓንጆ ፔቴታዖ ባኣዓዳ?» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ዪሳኣቄ፦ «ታ ዒዛ ኔኤኮ ጎዳቲ ማዓንዳጉዲ፥ ዒዛኮ ዒጊና ቢያ ዒዛም ማዻንዳጉዲ፥ ታ ዓንጄኔ፤ ሃሣ ሃኣኮና ዒዛኮ ዎይናፓ ኮሾ ዑዦና ዒዛም ሚርጋንዳጉዲ ታ ጌዔኔ፤ ዓካሪ ታ ናዓሢዮ! ኔኤም ታ ዓይጎ ማዻኒ ዳንዳዓይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ዔኤሳዎ ጊንሣ፦ «ታ ዓዳሢዮ! ኔኤኮ ዓንጆማ ፔቴ ሌሊዳ? ሃዳራ ታናኣ ዓንጄቴራ» ጌዒ ዬኤኪሢና ዓዶ ሜታሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ዪሳኣቄ ፔኤኮ ናኣዚም ሂዚ ጌዔኔ፦ «ዓንጃ ኩሜ ዓኣዔ ዓጮይዳፓ ሃኪ ኔ ናንጋንዳኔ፤ ጫሪንጫፓ ዖልኬያ ኔ ዴንቃዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ጬንቻ ዓፓሮና ዒጊቺ ቡሪ ሙዒ ሙዒ ኔ ናንጋንዳኔ፤ ኔ ጌኤዚም ኔ ማዻያ ማዓንዳኔ፤ ዒዛ ኔ ዒፂ ማኬ ዎዶና፥ ዒዚ ኔና ሜታሲ ዎይሣሢዳፓ ኔ ኬስካንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ዓዴ ያይቆኦቤ ዓንጄሢሮ ዔኤሳዎ ኮሺ ያይቆኦቤ ዒፃዖ፥ ፔ ዒኔና፦ «ጫክ ጌዔ! ዓዴ ዑኬ ኬሊዳ ሃይቃንዳኔ፤ ሲዪያ ጋፔሢኮ ጊንፃ ታ ጌኤዚ ያይቆኦቤ ታ ዎዻንዳኔ» ጌዒ ዚርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ጋዓንቴ ዒንዳ ዒርቢቃ ዔኤሳዎ ጌዒ ዚርቃሢ ዋይዜሢሮ፥ ያይቆኦቤ ዔኤላዖ፦ «ኔ ዋይዜ፤ ኔ ዒሼ ዔኤሳዎ ኔና ዎዺ ኮሞ ዔካኒ ማላኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ሃሢ ታ ናዓሢዮ፥ ታ ኔኤም ጋዓ ባኮ ማዼ፤ ዔቂጋፓ ካኣራኣኔ ዓጮይዳ ናንጋ ታ ዒሾ ላኣባ ኮራ ቤቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ዒሾኮ ዻጋ ማዓንዳኣና ዒኢካ ዴዔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ዒዛኮ ዻጋ ማዔቶ ኔ ዒዛ ማዼ ባኮ ዒዚ ዋላንዳኔ፤ ዬካፓ ዓሲ ዳኪ ታ ኔና ዔኪ ዬይሲሳንዳኔ፤ ዒንሢ ላምዓሢ ፔቴ ኬሊዳ ሃይቂ ጋፓንዳጉዲ ታ ኮዑዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ዒርቢቃ ዪሳኣቄ ኮራ፦ «ዔኤሳዎ ዔኬ ሄኤቴ ዜርፆ ላኣሎንሢዳፓ ዔቄያና ታ ኑኡናዼኔ፤ ያይቆኦቤያ ሃሣ ሃኖ ሄኤቴ ዓሶ ዜርፃፓ ፔቴ ላኣሊ ዔኬቶ ማይ ታ ሃሃይቃቶ ቃራኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ዪሳኣቄ ፔኤኮ ናኣዚ ያይቆኦቤ ዔኤሊ ጌስታዖ ሂዚ ጌዒ ዓይሤኔ፦ «ካኣናኔ ዓጮ ዉዱሮ ናኣታፓ ኔ ላኣሊ ዔኩዋጉዲ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ሜሶፖታሚያ ዓጮይዳ ዓኣ ኔ ማዖ ባኣቱዔኤሌ ኮይላ ዓኣዺጋፓ ዒኢካ ኔ ዓቦ ላኣባኮ ዉዱሮ ናኣታፓ ፔቴ ዔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ቢያ ባኣዚ ዳንዳዓ ፆኦዛሢ ኔና ዓንጆንጎ፤ ሚርጌ ናይያ ኔኤም ዒንጎንጎ፤ ሚርጌ ዴሬኮዋ ሃሣ ዓዶ ኔና ዒ ማሆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ዒዚ ዓብራሃሜ ዓንጄሢጉዲ ኔኤና ኔ ዜርፆና ዓንጆንጎ፤ ሃኖ ዓብራሃሜም ዒ ዒንጌ፥ ኔኤኒያ ሃሣ ሙኬ ሾኦቺ ማዒ ናንጌ ቤዞ ኔ ዓጪ ማሂ ኔኤም ዒዚ ዒንጎንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ዪሳኣቄ ያይቆኦቤ ሂዚ ጌዒ ዳካዛ ያይቆኦቤያ ሜሶፖታሚያይዳ ናንጋ ዓቦ ላኣባ ኮራ ዓኣዼኔ፤ ላኣባ ያይቆኦቤና ዔኤሳዎናኮ ዒንዶ ዒርቢቃኮ ዒሾኬ፤ ዒዞኮ ዓዴ ሶኦሪያ ዓጪ ዓሲ ባኣቱዔኤሌ ጎዖያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ዪሳኣቄ ያይቆኦቤ ዓንጄሢና ላኣሊ ኮዖም ጌዒ ሜሶፖታሚያ ዓጮ ዳኬሢ ዔኤሳዎ ዔሬኔ፤ ዪሳኣቄ ያይቆኦቤ ዓንጃዖ፦ «ካኣናኔ ዓጮ ዉዱሮ ናኣታፓ ላኣሊ ዔኪፖ» ጌዔሢያ ዒዚ ዋይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ሃሣ ያይቆኦቤ ዓዶና ዒንዶናም ዓይሢንቲ ሜሶፖታሚያ ዓጮ ዓኣዼሢያ ዒ ዔሬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ዬያ ቢያና ዪሳኣቄ ካኣናኔ ዓጮ ዉዱሮ ናኣቶ ናሽኩዋኣሢያ ዔኤሳዎ ዴንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ዬያሮ ዬያኮ ቤርታ ዒ ዔኬ ላኣሎይዳ ቃሲ ዓብራሃሜ ናኣዚ፥ ዒስማዔኤሌ ኮይላ ዓኣዺ ሜሌ ዒስማዔኤሌኮ ናዎ ማሂላቶ ጎዖዞ ዔኬኔ፤ ዒዛኣ ናባዮቴ ጎዖሢኮ ጌሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ያይቆኦቤ ቤርሳቤ ጎዖ ዓጬሎ ሃሺ ካኣራኣኔ ዓኣዻኒ ዔቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ዬካ ጎይፃ ዒ ዓኣንቴ ዓባ ጌላዛ ፔቴ ቤሲ ሄሊ ሃውሻዖ፥ ሹቺ ኬሬ ጌሢ ላሂ ጊንዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ዬካፓ ዒዚ ፔ ዓውቶና ሳዓፓ ጫሪንቺ ሄላ ሳና ዛጌኔ፤ ዒማና ሳኖ ጊዴና ፆኦሲኮ ኪኢታንቻ ሌካ ኬስኪ ሊካ ኬዲ ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ናንጊና ናንጋ ጎዳ ዒዛ ኮራ ዔቃዖ፦ «ታኣኒ ኔኤኮ ማዖ ዓብራሃሜና ዓዶ ኔኤኮ ዪሳኣቄናኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳኬ፤ ኔኤና ኔ ዜርፆናም ማዓንዳጉዲ ሃያ ኔ ላሄ ቤዞ ታ ኔኤም ዒንጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ዜርፆ ታ ኔኤኮ ሳዓ ማኣሻላጉዲ ሚርጊሻንዳኔ፤ ዔያታ ቢያ ዛሎና ፔኤኮ ዓጮ ዳልጊሻንዳኔ፤ ኔናንታ ኔ ዜርፆንታይዳፓ ዔቄያና ሳዖ ዴራ ቢያ ዓንጂንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ዒጊጪፖ! ታ ኔኤና ዎላኬ፤ ኔ ዓኣዻ ቤዞ ቢያይዳ ታ ኔና ካፓንዳኔ፤ ሃንጋ ሃያ ዓጮዋ ሃጊ ታ ኔና ኮሺና ዔኪ ማሃንዳኔ፤ ታ ኔኤም ጫኣቄ ጫኣቁሞ ቢያ ታ ኔኤም ኩንሣንዳኔ፤ ፔቴታዖ ታ ኔና ሃሻዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ያይቆኦቤ ጊንዓስካፓ ጴጫዖ፦ «ናንጊና ናንጋ ጎዳ ጎኔ ሃኖ ቤዛ ዓኣኔ፤ ታኣኒ ጋዓንቴ ዔሪባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ሚርጌና ዒዚ ዒጊጬሢሮ፦ «ሃይ ዎዚ ዒጊቻ ቤሲዳይ? ሃይ ፆኦሲ ማኣሪ ማዓንዳያ ኮይሳኔ፤ ጫሪንጮ ጌልዛ ካሬላኣ ሃኖኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ዒዚ ዚሮ ጉቴሎ ጉቴ ዓሚ ዔቂ፥ ዋንቴ ኬሮ ጌሤ ሹጬሎ ዬና ቤዜላ ጌኤሺ ማዔሢ ዔርዛ ማላታ ማዓንዳጉዲ ዻኣባዖ፥ ሹጬሎ ፆኦሲም ዱማሳኒ ዑፆይዳ ሪሚቶ ዛይቶ ዋሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ሃሣ ዬኖ ቤዜሎ «ቤኤቴኤሌ» ጌዒ ሱንሢ ጌሤኔ፤ ዬኖ ቤዜሎኮ ሱንፃ ዬያኮ ቤርታ ሎኦዛ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ዬካፓ ያይቆኦቤ፦ «ታኣና ዎላ ማዒ፥ ታ ዓኣዻ ጎይፆይዳ ኔ ታና ካፒ፥ ታኣም ኮይሳ ሙኡዚንታ ማኣዖንታ ኔኤኒ ዒንጌቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ታ ዓዶ ማኣሪያ ኔ ታና ኮሺ ማሄቶ፥ ኔኤኒ ታኣኮ ጎዳ፥ ሃሣ ፆኦሲ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ሃይ፥ ታኣኒ ማላታ ማዓንዳጉዲ ዾቄ ሹጫ ሃጊ ሴካ ቤርታ ፆኦሲ ማኣሪ ማዓንዳኔ፤ ኔ ታኣም ዒንጋ ባኮኮ ታጳሢዳፓ ፔቴማ ታ ኔኤም ዒንጋንዳኔ» ጌዒ ናንጊና ናንጋ ጎዳም ናኣቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ያይቆኦቤ ዓኣዼ ጎይሣ ዓባ ኬስካ ዛሎና ዓኣ ዓጮ ሄሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ዬካ ቦኦሎይዳ ዒ ፔቴ ዋኣሢ ዔቴ ዴንቄኔ፤ ዬኖ ዔቶ ዋኣፄሎ ዓጫ ማራይ ሃይሦ ቤሲ ፓቂንቲ ፓቂንቲ ዔቂ ዓኣኔ፤ ዬይ ቆልማ ዋኣፆ ዑሽካሢ ዬኖ ዔቴሎይዳፓ ማዓዛ ዔቴሎ ካሮ ዎዾ ፑኡፒ ሹቺ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ቆልማ ቢያ ቡኬሢኮ ጊንፃ ሄንቃ ናኣታ ዔቶ ካሮ ዎዾና ሹጫሢ ቡምባልሲ ዋኣፆ ዑሻኔ፤ ቆልሞ ዔያታ ዑሼሢኮ ጊንፃ ሹጫሢና ዔቶ ካሮ ጊንሣ ዎዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ያይቆኦቤ ቆልሞ ናኣቶ ኮራ፦ «ዔ ናይዮቴ፥ ዒንሢ ዎካፓ ሙኬይ?» ጌዒ ዖኦጬኔ። ዔያታ ማሃዖ፦ «ኑኡኒ ሙኬሢ ካኣራኣኔ ዓጮይዳፓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ዒዚ፦ «ናኮሬኮ ናኣዚ ናዖ ላኣባ ዒንሢ ዔራ?» ጌዒ ዔያቶ ዖኦጬኔ። ዔያታ፦ «ሂዮ፥ ኑ ዒዛ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ያይቆኦቤ «ዒዚ ዎዚ ኮሺዳ?» ጋዓዛ፥ ዔያታ፦ «ሂዮ፥ ኮሺኬ፤ ሃሢ ዒዛኮ ናኣ ራኣሄላ ሃና ሴካሾ ማራይ ዒሺ ሙካኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ያይቆኦቤ ዔያቶ ኮራ፦ «ቆልሞ ዓርሣኒ ሳዓ ሃጊ ሮኦሪታሢሮ ዓካሪ ቆልሞ ዒንሢ ዓይጎሮ ዋኣፆ ዑሺ ሄንቁዋይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ዔያታ፦ «ቆልሞ ሄንቃ ናኣታ ቢያ ቆልሞ ቡኩሳንዳሢኮ ቤርታ ዓይጎ ባኣዚያ ኑ ማዻኒ ዳንዳዑዋሴ፤ ቢያሢ ሙኬሢኮ ጊንፃ ሹጫሢ ዎሊ ዑፃ ኑ ኮላሲ ሺኢሻዖ ዑሻኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ያይቆኦቤ ዔያቶና ዎላ ጌስታ ጎይሣ ዓኣንቴ ራኣሄላ ዓዶኮ ማራይ ሄንቃያታሢሮ ማራቶ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ያይቆኦቤ ዒዛኮ ዓቦ፥ ላኣባኮ ማራቶ ራኣሄላ ዒሺ ሙካሢ ዛጋዖ ዔቶ ካሮ ባንሢ ዓኣዺ ካሮ ዎዾና ሹጫሢ ቡምባልሳዖ ማራቶ ዑሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ዬካፓ ራኣሄሎ ሄርቄኔ፤ ሚርጌ ዎዞይዳፓ ዔቄያና ዬኤካዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","«ታኣኒ ኔኤኮ ዓዶ ጌሮ ዒርቢቃ ናይኬ» ጋዓዛ፥ ዒዛ ዓዶም ኬኤዛኒ ጳሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ላኣባ ፔኤኮ ጌኤዶ ናኣዚ፥ ያይቆኦቤኮ ሙኪፆ ዋይዚ ጎይሣ ዔካኒ ዑኬና ዓኣዻዖ፥ ኮንቂ ሄርቄሢኮ ጊንፃ ማኣሪ ዔኪ ሙኬኔ፤ ያይቆኦቤያ ማዔ ባኮ ቢያ ላኣባም ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ላኣባ፦ «ጎኔና ኔ ታኣኮ ዑኬ ዓሽኪ ዒጊኒኬ» ዒዛም ጌዔኔ። ያይቆኦቤያ ፔቴ ዓጊኒ ማዓያ ዓቦ ኮራ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ላኣባ ያይቆኦቤ ኮራ፦ «ኔ ታኣኮ ዒጊኒ ማዔሢሮ ጉሪ ኔ ታኣም ማዻንዳያ ኮይሱዋሴ፤ ዓካሪ ኔ ማዻ ማዾኮ ዓይጎ ኔኤም ታ ዒንጎንዶይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ላኣባኮ ላምዖ ዉዱሮ ናይስኬንሢ፥ ሚሼላ ሊያ ጌኤዴላ ራኣሄሎ ጌይንታያ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ሊያኮ ዓኣፓ ሊምፓቴያ ማዓዛ ራኣሄላ ጋዓንቴ ዔጶና ቢያ ሚርጌ ሚዛጲ ናሻያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ያይቆኦቤ ራኣሄሎ ዔካኒ ሚርጌ ናሽኬሢሮ ዓቦ ኮራ፦ «ራኣሄሎ ኔ ታኣም ዒንጌቶ ላንካይ ሌዔ ታ ኔኤም ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ላኣባ፦ «ሂዮ፥ ሜሌ ዓሲም ታ ዒዞ ዒንጋሢፓ ኔኤም ታ ዒንጌቴ ቃራኬ፤ ሜታ ባኣሴ፥ ታ ኮራ ናንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ዬያሮ ያይቆኦቤ ራኣሄሎ ዔካኒ ላንካይ ሌዔ ማዼኔ፤ ያዺ ዒዚ ናንጊ ማዼቶዋ ራኣሄሎ ዒ ኮሺ ናሽኬሢሮ ናንጌ ዎዳ ዒዛም ዻካ ኬሊ ሌሊ ማዒ ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ዬካፓ ያይቆኦቤ ላኣባ ኮራ፦ «ኔ ታኣም ጌዔ ሌዓ ኩሜሢሮ ናዎ ኔኤኮ ታኣም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ዬያሮ ላኣባ ዔፒ ኬሊ ሜንሢ፥ ሙኡዚና ዑሺና ጊኢጊሻዖ ኮይላ ዓኣ ዓሺኖ ቢያ ዔኤሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ጋዓንቴ ሳዓ ዓማዛ ላኣባ ራኣሄሎ ዒንጎ ሃሻዖ ያይቆኦቤም ሊያ ዒንጋዛ ያይቆኦቤ ዒዞ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ላኣባ ዒዛኮ ዚሊፓ ጎዖ ማዾ ማዻ ላኣሌሎ ሊያም ማዻንዳጉዲ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ያይቆኦቤ ዒዞ ዔሩዋዖ ዎላ ዎርቂ ዚሮ ጉቴሎ ሊያ ማዔሢ ዔራዖ ላኣባ ኮራ ዴንዲ፦ «ሃይ ኔ ታኣም ማዼ ባካ ዓይጎዳይ? ታ ኔኤም ማዼሢ ራኣሄሎ ዔካኒቱዋዓዳ? ሂዳዖ ኔ ታና ዓይጋ ጌሼይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ላኣባ ዒማና፦ «ሚሻ ሌዑዋንቴ ጌኤዳ ሌዓኒ ኑ ዓጪ ዳምቤቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ሃሢ ሊያኮ ዔፖ ቦንቻ፥ ላንካዎ ኬላ ጋፓንዳኣና ካፔ፤ ዬካፓ ኔ ላንካይ ሌዔ ታኣም ማዻንዳኔ ጌዔቶ ራኣሄሎ ታ ኔኤም ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ያይቆኦቤ ላኣባ ጌዔሢ ኮሺኬ ጌዒ ሊያና ዎላ ዔፖኮ ቦንቾ ላንካዎ ኬሎ ዑኡቱሞ ዴዔሢኮ ጊንፃ፥ ላኣባ ናዎ ራኣሄሎ ያይቆኦቤም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ዬካፓ ባኣላ ጎዖ ማዾ ማዻ ላኣሊስኬኖ ናዎ ራሄሎም ማዻያ ማዓንዳጉዲ ላኣባ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ያይቆኦቤ ራሄሎ ዔካዖ ሊያይዳፓ ባሼ ናሽኬኔ፤ ዬካፓ ላንካይ ሌዔ ላኣባም ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ሊያ ራኣሄሎጉዲ ናሽኪንቲባኣሢ ናንጊና ናንጋ ጎዳ ዴንቃዖ ናይ ዒዛ ሾዓንዳጉዲ ኮሼኔ፤ ራኣሄላ ጋዓንቴ ዞኦኮ ማዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ሊያ ጎጳዺ ዓቲንቄ ናይ ሾዓዖ፦ «ናንጊና ናንጋ ጎዳ ታኣኮ ሜታሢ ዛጌኔ፤ ዓካሪ ሃይፓ ሴካ ዓኒ ታና ናሽካንዳኔ» ጌዒ ሱንፆ ናዓሢኮ ሮኦቤኤሌ ጌይ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ሃሣ ዒዛ ጎጳዺ ዓቲንቄ ናይ ሾዓዖ፥ «ታኣኒ ናሽኪንቲባኣሢ ጎዳ ዋይዜኔ፤ ሃያ ናዓሢያ ሃሣ ታኣም ዒንጌኔ» ጋዓዖ ሱንፆ ሲሞኦኔ ጌይ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ላሚ ሃሣ ጎጳዻዖ ዓቲንቄ ናይ ሾዒ፥ «ዓካሪ ሃይሦ ዓቲንቄ ናይ ታ ዒዛም ሾዔሢሮ ታ ዓኒ ታኣና ዎላ ናሹሞና ዓርቂንቴያ ማዓንዳኔ» ጋዓዖ ሱንፆ ሌዊ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ሃሣ ዒዛ ጎጳዻዖ ዓቲንቄ ናይ ሾዒ፥ «ዓካሪ ታኣኒ ናንጊና ናንጋ ጎዳ ጋላታንዳኔ» ጋዓዖ ሱንፆ ዪሁዳ ጌይ ጌሤኔ። ዬካፓ ሾይፃ ዒዞኮ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ራሄላ ያይቆኦቤም ፔቴታዖ ናይ ሾዓኒ ዳንዳዒባኣሢ ዔሬ ዎዶና ሚሾ ቂኢሬኔ፤ ዬያሮ ያይቆኦቤ ኮራ፦ «ናይ ታኣም ዒንጌ፤ ሃንጎ ታ ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ያይቆኦቤ ራሄሎ፦ «ናይ ታ ኔኤም ዒንጋኒና ላኣጋኒ ዳንዳዓ ፆኦሲ ታ ኔ ኮራ ማላ?» ጌዒ ጎሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ዒዛ ማሃዖ፦ «ታኣም ማዻዜሎ ባኣላ ሃኣዛጌ፤ ዒዛ ታ ዛሎ ናይ ታኣም ሾዓንዳጉዲ ዒዞ ዔኬ፤ ዬያይዲ ዒዞ ዛሎና ታኣኒ ናይ ዒንዶ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ዒዛ ዬያ ጋዓዖ ባኣላ ያይቆኦቤም ማቾ ማሂ ዒንጋዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ባኣላ ጎጳዺ ያይቆኦቤም ዓቲንቄ ናይ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ዬካፓ ራኣሄላ፦ «ፆኦሲ ታኣም ዎጌኔ፤ ሺኢጲፆ ታኣኮ ዋይዚ ዓቲንቄ ናይ ታኣም ዒንጌኔ» ሂዚ ጋዓዖ ናዖኮ ሱንፆ ዳኣኔ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ሃሣ ራኣሄሎኮ ማዻዜላ ባኣላ ጎጳዻዖ ሜሌ ዓቲንቄ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ራኣሄላ «ታ ሚሾና ሚርጌ ማሹንቦ ዓርቂ ዒዞ ታ ባሼኔ» ጌዒ፥ ናዖኮ ሱንፆ ኒፕታኣሌኤሜ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ሊያ ሃሣ ዒዞኮዋ ሾይፃ ዔቄሢ ዔራዖ ዒዞም ማዻዜሎ ዚሊፓ ያይቆኦቤም ማቾ ማሂ ዒንጋዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ሊያም ማዻዜላ ዚሊፓ ያይቆኦቤም ዓቲንቄ ናይ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ሊያ ዒማና፦ «ታ ዎዚጉዴ ባሊቲና ዓኣያዳይ!» ጋዓዖ ሱንፆ ዒዛኮ ጋኣዴ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ሊያም ማዻዜላ ዚሊፓ ያይቆኦቤም ላሚ ሜሌ ዓቲቄ ናይ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ሊያ ሃሣ፦ «ሚርጌ ታና ዎዛሴኔ፤ ሃይፓ ሴካ ላኣላ ቢያ ታና ‹ዎዛዻ ላኣሌሎ› ጋዓንዳኔ» ጋዓዖ ሱንፆ ናዖኮ ዓሴኤሬ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ዛርጋሢ ጮኦሮ ዎዶና ያይቆኦቤኮ ናኣዚ፥ ሮኦቤኤሌ ካዮ ዓኣዻዖ ማንዳሪክሴ ጌይንታ ሚሢኮ ቡኒ ዴንቂ፥ ዒንዶ ሊያም ዔኪ ሙኬኔ፤ ራኣሄላ ሚሾ ሊያ ኮራ፦ «ሃዳራ ኔ ናዓ ዔኪ ሙኬ ማንዳሪክሶ ቡኖ ታኣም ዒንጌቴራ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ሊያ ማሃዖ፦ «ታኣኮ ዓኒ ኔ ሳርቴሢ ዻካዛ ሃሣ ታኣኮ ናዓ ታኣም ዔኪ ሙኬ ማንዳሪክሶ ቡኖ ኔኤኒ ሳራኒ ኮዓ» ጋዓዛ፥ ራኣሄላ፦ «ኔኤኮ ናዖኮ ማንዳሪክሶ ቡናፓ ታኣም ዒንጌ፤ ሃኖ ዒባኒ ያይቆኦቤ ኔ ኮራ ዎርቆንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ዬኖ ዋንቴሎ ያይቆኦቤ ሶኦፓፓ ማዓኣና ሊያ ጋራፓ ዒዛ ባንሢ ኬስካዖ፦ «ታኣኮ ናዖኮ ማንዳሪክሶ ቡኖና ታ ኔና ሻንቄሢሮ ሃኖ ዒባኒ ኔ ዎርቃንዳሢ ታኣና ዎላኬ» ዒዛም ጌዔኔ፤ ዬያሮ ዒዚ ዬኖ ዋንቴሎ ዒዞና ዎላ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ፆኦሲያ ሊያኮ ሺኢጲፆ ዋይዜሢሮ ሊያ ጎጳዻዖ ያይቆኦቤም ዶንጋሳ ዓቲንቄ ናይ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ሊያ፦ «ታኣም ማዻዜሎ ታ ዓኒም ታ ዒንጊፆና ፆኦሲ ታኣም ታ ማዾ ዛሎ ጪጌኔ» ጋዓዖ ሱንፆ ናዖኮ ዪሳኮኦሬ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ሊያ ሃሣ ላሚ ጎጳዻዖ ያይቆኦቤም ላሃሳ ዓቲንቄ ናይ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ዒዛ፦ «ፆኦሲ ታኣም ኮሺ ዒንጊሢ ዒንጌሢሮ ላሆ ዓቲንቄ ናይ ታ ዒዛም ሾዔኔ፤ ዓካሪ ታ ዓኒ ታና ቦንቻንዳኔ» ጋዓዖ ሱንፆ ናዖኮ ዛብሎኦኔ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ዬካፓ ዉዱሮ ናይ ሾዓዖ፥ ሱንፆ ዒዞኮ ዲኢና ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ፆኦሲ ሃሣ ራኣሄሎም ማሊ፥ ሺኢጲፆዋ ዒዞኮ ዋይዚ ናይ ሾዓንዳጉዲ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ዬካፓ ዒዛ ጎጳዻዖ ዓቲንቄ ናይ ሾዔኔ፤ ሾዓዖ ዒዛ፦ «ፆኦሲ ዓቲንቄ ናይ ታኣም ዒንጌኔ፤ ጫሽኪንቲፆዋ ታኣኮ ዓይሴኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ሃሣ ሜሌ ዓቲንቄ ናይያ ታኣም ዒንጎንጎ» ጋዓዖ፥ ሱንፆ ዒዛኮ ዮሴፔ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ራኣሄላ ዮሴፔ ጎዖ ናዓሢ ሾዔሢኮ ጊንፃ ያይቆኦቤ ላኣባ ኮራ፦ «ታ ሾይንቴ ዓጮ ማዓንዳጉዲ ታና ዳኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ኔኤም ማዺ ታ ዴንቄ ላኣሎንሢና ናኣቶንሢና ታኣም ዒንጌ፤ ዎያይዲ ታ ኔኤም ማዼቴያ ኔ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ላኣባ ዒማና፦ «ኔ ዛሎና ናንጊና ናንጋ ጎዳ ታና ዓንጄሢ ዱማ ጎይሢና ታ ዔሬሢ ታ ኔኤም ኬኤዛኒ ኮዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ኔኤም ኮይሳሢጉዴያ ታኣም ኬኤዜ ታ ኔኤም ጪጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ያይቆኦቤ ዒዛም፦ «ዎያይዲ ታ ኔኤም ማዼቶዋ፥ ሃሣ ቆልማ ኔኤኮ ታ ሄንቂፆና ዋኣዺ ሚርጌቶዋ ኔ ዔራኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ታ ሙኩዋንቴ ቤርታ ኔኤኮ ዓኣ ዻኮ ቆልሞንሢ ሃሢ ኮሺ ሚርጌኔ፥ ታ ሄሌ ቤዞይዳ ቢያ ናንጊና ናንጋ ጎዳ ዓንጆ ኔኤም ዒንጌኔ፤ ማይ ሃይፓ ሴካ ታ ማኣሮ ዓሶም ማዓ ባኣዚ ታ ዴንቃንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ላኣባ፦ «ሂዴቶ ዓይጎ ታ ኔኤም ጪጎንዶይ?» ጌዒ ዒዛ ዖኦጫዛ፥ ያይቆኦቤ ሂዚ ጌዔኔ፦ «ታ ኔኤም ጋዓ ፔቴ ባኣዚስኬማ ሌሊ ኔ ታኣም ማዼቶ ቆልሞ ታ ኔኤኮ ሄንቂፆ ሃሻዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ዬና ዓይጎዳይ ጌዔቶ ሃኖ ታ ኔኤኮ ቆልሞ ባኣኮ ዓኣዻዖ ዖዳሎና ቦርጮ ዋኣሮና ካርፆ ማራቶና ቁሪ ዱማሳንዳኔ፤ ዔያታኣ ታ ኔኤም ማዼሢ ዛሎ ታኣም ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ዬያይዲ ታኣኮ ጎኑሞና ጉሙርቂንቲፆና ሴካ ቤርታ ዔርታንዳኔ፤ ታ ኔኤም ማዼ ዛሎ ኔ ታኣም ዒንጋኒ ሙካ ዎዶና ዖዳላ ማዒባኣያና ቦርጫ ማዒባኣ ዋኣሪ ኔ ዴንቄቴ፥ ዬያጉዲ ሃሣ ካርሢ ማዒባኣ ማራይ ኔ ዴንቄቴ ዉኡቂንቴያታሢ ኔ ዔራኒ ዳንዳዓኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ላኣባ፦ «ዔኤዔ ኔ ጌዔሢ ኮሺኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ጋዓንቴ ዬኖ ኬሎና ላኣባ ጎኦሾ፥ ሃሣ ቦርጫ ማዔ ኮላቶና ቦኦሬ ዖዳላ ማዔ ዋኣሮ ዒንዶ ቢያ ኬሴኔ፤ ዬያጉዲ ሃሣ ካርሢ ማዔ ማራይ ቢያ ዱማሲ ዓቲንቆ ናኣቶና ሄንቂሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ዬካፓ ላኣባ ቆልሞ ዒሺ ሃይሦ ኬሊ ጎይሢ ማዓያ ያይቆኦቤይዳፓ ሃኪ ዓኣዼኔ፤ ያይቆኦቤ ጋዓንቴ ላኣባኮ ዓቴ ቆልሞ ሄንቂፆ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ያይቆኦቤ ዒማና ሊቢኔንታ ሌውዜንታ ዔርሞኔ ጌይንታ ሚሢ ሜሊባኣያ፥ ዓኣዔ ኮኦሎ ዔካዖ ኮኦሎንሢኮ ጋሮይዳ ቦኦሬሢ ጴዻንዳጉዲ ቦርጫሲ ቁኡሮ ጱዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ዬካፓ ቆልማ ዋኣፆ ዑሽካኒ ሙካኣና ቤርታ ቤርታ ዔያቶም ጴዻንዳጉዲ ዋኣፆ ዑሾ ጎንጋሎይዳ ጌሤኔ፤ ዓይጎሮ ጌዔቶ ቆልማ ዋኣፆ ዑሽካኒ ሙካ ዎዶና ቤኤሊንታያ ማዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ዬያሮ ቆልማ ቤኤሊንታኣና ቦርጫሶና ኮኦሎ ዛጋዖ ጎኦሾ፥ ቦርጫ ሃሣ ዖዳላ ማዔ ዋናናይንታ ማራ ናይያ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ያይቆኦቤ ዬንሢ ዋኣሮንሢና ማራቶንሢና ዱማሴኔ፤ ሃንጎ ዓቴ ቆልሞ ላኣባኮ ዖዳሎና ካርፆ ማዔዞንሢናኮ ቤርታ ቤርታ ማሂ ዔቂሴኔ፤ ዬያይዲ ያይቆኦቤ ፔ ቆልሞ ሚርጊሼኔ፥ ሃሣ ላኣባ ቆልሞይዳፓኣ ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ኮሺ ማዔ ቆልሞንሢ ቤኤሊንታ ዎዶና ያይቆኦቤ ቦርጫሲንቴ ኮኦሎንሢ ዔያታ ዑሽካ ባኮኮ ቤርታ ጌሣዛ ቆልማ ዬያ ዛጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ጋዓንቴ ዬንሢ ኮኦሎንሢ ላቤያ ማዔ ፑርቶ ቆልሞ ቤርታ ጌሡዋሴ፤ ዬያይዲ ላቤያ ማዔ ቆልማ ላኣባም ማዓዛ፥ ዶዶ ቆልማ ጋዓንቴ ያይቆኦቤም ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ዬያይዲፆና ያይቆኦቤ ሚርጌ ዖርጎጬኔ፤ ሚርጌ ቆልሞንታ ዒዛም ማዻ ላኣሊንታ ዓቲንቄንታ፥ ሃሣ ሚርጌ ጋኣሎንታ ሃሬንታ ዒዛኮ ዓኣያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ላኣባኮ ዓቲንቆ ናኣታ፦ «ያይቆኦቤ ኑ ዓዶ ቆልሞ ዔኬኔ፤ ሃያ ቆሎ ቢያ ዒ ዴንቄሢ ኑ ዓዶይዳፓኬ» ጌዒ ጌዒ ኬኤዛሢ ያይቆኦቤ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ሃሣ ላኣባ ዒዛ ቤርታኣሲጉዲ ናሽኩዋኣሢያ ዒ ዔሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ዒማና ናንጊና ናንጋ ጎዳ ያይቆኦቤም፦ «ኔ ዓዶንሢና ኔ ዒጊኖና ዓጮ ባንሢ ማዒ ዴንዴ፤ ታኣኒያ ኔኤና ዎላ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ዬያሮ ያይቆኦቤ ቆልማ ሄንቃ ቦኦሎ ባንሢ ሙካንዳጉዲ ዒዛኮ ላኣሎ ራኣሄሎና ሊያና ዔኤሊሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ዔያታ ሙካዛ ዒ ሂዚ ዔያቶም ጌዔኔ፦ «ዒንሢኮ ዓዴ ሚናኣሲጉዲ ታና ናሽኩዋኣሢ ታ ዔሬኔ፤ ጋዓንቴ ታ ዓዶኮ ፆኦዛሢ ታኣና ዎላ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ዎልቆ ታኣሲ ሚጪንቱዋዖ ዒንሢኮ ዓዶም ታ ዶዲ ማዼሢ ዒንሢያ ዔራኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ዒዚ ጋዓንቴ ታ ዒዛም ማዼ ዛሎ ዒንጎ ባኮ ቤዛ ቤዛ ላኣሚ ላኣሚ ታጶ ማይንቲ ታና ጌሼኔ፤ ማዔቶዋ ዒ ታጊዳ ፑርታ ማዻንዳጉዲ ፆኦሲ ዓይሢባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ላኣባ ታኣም ‹ዖዳሎ ቆልማ ቢያ ኔ ማዼሢ ዛሎ፥ ኔኤም ማዖንጎ› ጌዔ ዎዶና፥ ቆልማ ቢያ ዖዳላ ሾዔኔ፤ ሃሣ ጊንሣ ማሊፆ ሺርሺ ‹ጎኦሾ ቆልማ ቢያ ኔ ማዼሢ ዛሎ፥ ኔኤም ማዖንጎ› ጋዓዛ፥ ቆልማ ቢያ ጎኦሾ ሾዔኔ፤ ዬያይዲ ሚርጌና ዒ ላኣሚ ላኣሚ ሺሬቶዋ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ፆኦሲ ዒንሢ ዓዶ፥ ላኣባኮ ቆልሞ ዬያይዲ ዔኪ ታኣም ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ቆልማ ቤኤሊንታኒ ኮዓ ዎዶና ቆልሞኮ ዑፆ ኬስኪ ዑኡጋሢ ጎኦሾ፥ ዖዳላ፥ ሃሣ ቦርጫ ኮላይንታ ዓዴ ማራይንታ ማዔሢ ዓውቲና ታ ዛጌኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","«ዬይያ ዓውቶና ፆኦሲኮ ኪኢታንቻ ታና ‹ያይቆኦቤ!› » ጌዒ ዔኤላዛ ታኣኒያ «ዮ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ዬካፓ ዒዚ ታኣም ኬኤዛዖ፦ «ቆልሞ ዑፃ ኬስኪ ዑኡጋ ኮላቶና ዓዶ ማራቶ ዖዳሎንታ ቦርጮንታ ሃሣ ጎኦሾ ማዔሢ ዛጌ፤ ላኣባ ኔኤም ማዼ ፑርቶ ባኮ ታ ዛጌሢሮ ሃያ ማዼሢ ታናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ሃያኮ ቤርታ ጶቂሥሢ ማዖም ጌዒ ዻኣቦ ኔ ዻኣቢ፥ ዛይቶ ዋሂ ሃሣ ናኣቦዋ ኔ ናኣቤ ቤዜሎ ቤኤቴኤሌይዳ ኔኤና ካኣሜ ናንጊና ናንጋ ጎዳ ማዔ ፆኦዛሢ ታናኬ፤ ሃሢያ ሃያ ዓጮይዳፓ ዑኬና ኬስኪ ኔ ሾይንቴ ዓጮ ማዒ ዴንዴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ራኣሄሎና ሊያና ዔያቶኮ ዓኒ፥ ያይቆኦቤም፦ «ኑ ዓዶይዳፓ ኑ ዻካላንዳ ባኣዚ ዓይጌያ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ዒዚ ኑና ዛጋሢ ፃንጎ ዓኣፒናኬ፤ ቤርታ ዒ ኑና ሻንቼኔ፤ ሃሣ ኑ ዛሎ ኔ ማዺ ዔኬ ባኮዋ ቢያ ባይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ሃሢ ፆኦሲ ኑ ዓዶይዳፓ ዔኪ ኔኤም ዒንጌ ቆላ ቢያ ኑኡና ኑ ናኣቶናም ማዔሢሮ፥ ፆኦሲ ኔና ዓይሤ ባኮ ቢያ ማማዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","ዬያሮ ያይቆኦቤ ካኣናኔይዳ ናንጋ ዓዶ ባንሢ ማዒ ዓኣዻኒ ጊኢጊንቴኔ፤ ናኣቶና ላኣሎና ጋኣላሢ ቶጊሲ ሜሶፖታሚያይዳ ዓኣዖ ዒ ዴንቄ ቆሎንታ ቆልሞዋ ቢያ ዒሺ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ዬማና ላኣባ ማራቶኮ ጋፓኖ ዑፃፓ ታይዚ ዔካኒ ዓኣዼያታሢሮ፥ ዒዚ ባኣ ቤዞይዳ ናኣ ራኣሄላ ዒዛኮ ማኣራ ካኣሽኮ ፆኦዞ ዉኡቂ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ያይቆኦቤ ቤታሢ ላኣባም ኬዙዋዖ ጌሺ ዴንዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ያይቆኦቤ ፔኤኮ ቆልሞንሢ ዔካዖ ሩኡሪና ኬስኪ፥ ዔፕራፂሴ ጎዖ ዎሮና ፒንቂ ጌሜሪ ሚርጌ ዓኣ፥ ጌሌዓዴ ጌይንታ ዓጮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ያይቆኦቤ ዓኣሺንቲ ዓኣዼሢ ላኣባ ሃይሦ ኬሊኮ ጊንፃፓ ዋይዛዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ፔኤኮ ዒጊኖና ዎላ ያይቆኦቤ ጊንፆ ኮዒ ዓኣዼኔ፤ ላንካይ ኬሊ ያይቆኦቤ ሃንቴሢኮ ጊንፃ ጌሌዓዴይዳ ዒዛ ዒ ሄላኒ ዑኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ዬኖ ዋንቴሎ ፆኦሲ ላኣባም ዓውቲና፦ «ያይቆኦቤ ዑፃ ፑርታ ማዔቶዋ ኮሺ ፔቴ ባኣዚታዖ ኔ ጎዑዋጉዲ ኔና ዔሬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ያይቆኦቤ ጌሌዓዴይዳ ዓፒላና ማዦ ማኣሮ ዾቂ ዱንኪ ዴዒ ዓኣንቴ ዒ ሙኪ ሄሌኔ፤ ዬካፓ ላኣባና ዒዛኮ ዒጊኖና ዔያቶኮዋ ዓፒሎ ማኣሮ ዾቂ ዒኢካ ኮይላ ዱንኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ዬካፓ ላኣባ ያይቆኦቤ ኮራ፦ «ዓይጎሮ ኔ ታና ሃያይዲ ጌሼይ? ታ ናኣቶ ዖልዚና ዲዒ ዔኪ ዓኣዾጉዲ ዓይጋ ኔ ዔኪ ዓኣዼይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ታኣም ኬዙዋዖ ዓኣሺንቲ ቤቲፆና ዓይጋ ታና ኔ ጌሼይ? ዎንዴ ኔ ታኣም ኬኤዜቶ ካራቤና ጎኦላና ዔኪ ኮርጊ ኮርጊ ዎዛና ታ ኔና ጎይሣ ዓኣሣንዳንቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ታኣኒ ታኣኮ ናኣቶንታ ናኣቶኮ ናኣቶንታ ሄርቂ ዳኩዋጉዲ ኔ ማዼሢ ሃይ ዻቢንቲኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ፑርታ ባኣዚ ታ ኔጊዳ ማዻኒ ዳንዳዓያታንቴ፥ ዋንቴ ዓውቲና ኔ ዓዶ፥ ፆኦዛሢ፦ ‹ያይቆኦቤ ዑፃ ፑርታ ማዔቶዋ ኮሺ ፔቴ ባኣዚታዖ ኔ ጎዑዋጉዲ› ጌዒ ታኣም ላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ኔ ሾይንቴ ዓጮ ማዒ ዓኣዻኒ ሚርጌና ኮዒ ታጊዳፓ ኔ ፓቂንቴሢ ታ ዔራኔ፤ ማዓዛ ታኣኮ ማኣራ ታ ካኣሽካ ፆኦዞ ኔ ዉኡቄሢ ዓይጌንዴሮዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ያይቆኦቤ ማሃዖ፦ «ኔኤኮ ናኣቶ ታ ዑፃፓ ኔ ዔካንዳያናንዳኔ ጌዒ ታ ዒጊጬሢሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ጋዓንቴ ኑ ባኣካፓ ኔኤኮ ካኣሽኮ ፆኦዞ ዔኪ ጴዼ ዓሲ ዓኣቶ ሃይቆንጎ፤ ሃሢ ሃንሢ ኑኡኮ ዒጊኖንሢ ኔኤኮ ማርካ ማሂጋፓ ኔ ባኣዚ ማዔ ባኮ ቢያ ኮዒ ዔኬ» ጌዔኔ፤ ያይቆኦቤ ዬያ ጌዔሢ ዒዛኮ ማቻ ራኣሄላ ዓዶኮ ካኣሽኮ ፆኦዞ ዉኡቂ ዔኬሢ ዔሪባኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ዬካፓ ላኣባ ያይቆኦቤንታ ሊያንታ ላምዖ ዒዞም ማዻ ላኣሎንሢንታኮ ጋሮ ጌሊ ኮዔስካፓ ፔቴታዖ ዔኤቢ ዴንቂባኣሴ፤ ጋፒንፆይዳ ራኣሄሎ ጋሮ ጌሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ራኣሄላ ጋዓንቴ ዓዶኮ ካኣሽኮ ፆኦዞ ዔኪ ጋኣላሢ ቶጎ ሚኢሾ ዴማ ዓኣቺ ዑፃ ዴዔሢሮ፥ ላኣባ ጋሮይዳ ዓኣ ባኮ ቢያ ኮዓዖ ፔቴታዖ ዴንቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ዬማና ራኣሄላ ዓዶ ኮራ፦ «ኑ ዓዴ! ታኣኮ ዑሢ ፑርቴሢሮ ታ ዔቃኒ ዳንዳዒባኣሴ፤ ታና ቆፂፖ» ጌዔኔ። ዬያሮ ላኣባ ቢያ ቤዞ ኮዒ ዒዛኮ ካኣሽኮ ፆኦዞ ዴንቃኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ዒማና ያይቆኦቤ ላኣባ ኮራ፦ «ዓካሪ ታ ዓይጎ ፑርቲሴይ? ሂንዳ ሃያይዲ ኔ ታና ዳውሳሢ ዓይጎ ታ ዎኦቴምዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ታኣኮ ሜሆ ባኣካፓ ኔ ባኣዚ ኔ ዓይጎ ዴንቄይ? ኔ ዴንቄ ባኣዚ ዓኣያታቶ ኑኡኮ ዒጊኖ ቤርታ ሺኢሼ፤ ዔያታ ኔኤና ታኣናናይዳፓ ፑርታሢ ዖናታቶዋ ኑኡም ዎጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ኔኤና ዎላ ታ ላማታሚ ሌዔ ናንጌ ዎዶይዳ ማራቶና ዋኣሮና ኔኤኮ ቡሌ ዎዴ ባኣሴ፤ ኔኤኮ ቆልሞይዳፓ ፔቴ ማራናይታዖ ታ ሹኪ ሙዒ ቤቂባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ኔኤኮ ማራቶይዳፓ ፔቴ ቦዖ ሙዔቶ ታ ጪጋኣፓዓቴም ታ ዻቢንቲና ሙይንቲባኣሴ ጌዒ ታ ኔኤም ኬኤዛኒ ኔ ቤርቶ ዔኪ ሙኪ ቤቂባኣሴ፤ ዋንታታቶዋ ሮኦራ ዉኡቂንቴ ቆልሞ ዓኣቶ ኔ ታና ጪጪጊሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ሚርጌ ዎዴና ሮኦሪ ሩኡጶና ዋንቶ ጎቃይሳ ጪኢዦና ታ ሚርጌ ሜታዼኔ፤ ቃራ ጊንዖዋ ታ ጊንዔ ዎዴ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ኔኤና ዎላ ታ ዬያይዲኬ፥ ላማታሞ ሌዖ ዓኣሤሢ፤ ዬያ ላማታሞ ሌዖኮ ታጶ ዖይዶ ሌዖ ኔኤኮ ናኣቶ ዔካኒ፥ ዓቴ ላሆ ሌዖንሢ ታ ማዼሢ ኔጊዳፓ ቆልሞ ዔካኒኬ፤ ያዺ ማዔቶዋ ታ ኔኤም ማዼሢ ዛሎ ዒንጎ ባኮ ቤዛ ቤዛ ታጶ ማይንቲ ኔ ላኣሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ታ ዓዴ ዪሳኣቄ ዒጊጫ ዓብራሃሜኮ ፆኦዛሢ ታኣና ዎላ ማዒባኣቶ ኩቺ ጉሪ ኔ ታና ዳካንዳንቴኬ፤ ሃሢ ጋዓንቴ ታኣኮ ሜታሢና ላቢፆና ዛጊ ዋንቴ ፆኦሲ ኔና ዓውቶና ጎሬኔ» ሂዚ ጌዒ ዻጋዺ ጎሪንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ላኣባ ያይቆኦቤም፦ «ሃንሢ ኔኤኮ ላኣሎንሢ ታ ናኣቶኬ፤ ዔያቶኮ ናኣታኣ ታ ናይኬ፤ ሃይ ቆልማ ሃሣ ታኣሮኬ፤ ጎኑሞምታቶ ሃይ ጴዻ ባካ ቢያ ታኣሮኬ፤ ጋዓንቴ ታኣኮ ናኣቶና ዔያቶኮ ናኣቶና ዓይሳኒ ዓይጎ ባኣዚያ ታ ማዻኒ ዳንዳዒባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ዬያሮ ኔኤና ታኣና ዎላ ኑ ፑርቱዋጉዲ ጫኣቁሞ ኑ ጫኣቃንዳኔ፤ ዬያ ጫኣቁሞኮ ማርካ ማዒ ናንጋንዳጉዲ ሹቺ ኑ ቡኩሲ ኩሊ ዻኣቦ ዻኣቦም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ዬያሮ ያይቆኦቤ ፑኡፒ ሹቺ ዔኪ ማላታ ማዓንዳጉዲ ዻኣቦ ዻኣቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ዬካፓ ዒዚ ማኣሮ ዓሶ ቢያ፦ «ሹቺ ቡኩሱዋቴ» ጋዓዛ፥ ዔያታ ሹጮ ቡኩሲ ኩሌሢኮ ጊንፃ ኮይላ ዴዒ ሙኡዚ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ላኣባ ዬኖ ቤዜሎኮ ሱንፆ «ዪጋርሳሃዱታ» ጌዒ ጌሣዛ፥ ያይቆኦቤ ጊንሣ ሃሣ «ጌሌዓዴ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ላኣባ ዒማና፦ «ዓካሪ ሃኖ ሃይ ሹጮ ኬኤላ ኔኤና ታኣናና ባኣካ ማርካኬ» ጌዔኔ፤ ጌሌዓዴ ጌዒ ዔኤሊንቴሢያ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ላኣባ ጊንሣ፦ «ዓካሪ ሃይካፓ ኑ ዱማዻ ዎዶና ፆኦሲ ኔኤና ታኣና ካፖንጎ» ጌይ ዬኖ ቤዜሎኮ ሱንፆ «ሚፂጳ» ጌዒ ላማሲ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ላኣባ ቃሳዖ፦ «ታ ናኣቶ ኔ ሜታሴቴ፥ ሃሣ ሜሌ ላኣሊያ ኔ ዔያቶ ዑፃ ዔኬቶ፥ ታ ዔራኒ ዳንዳዒባኣታቴያ ፆኦሲ ኑኡኮ ማርካታሢ ኔ ዋሊፖ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ኑኡኮ ባኣኮይዳ ታ ቡኩሴ ሹጮና ዔቂሴ ዻኣቦ ሃኣዛጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ታኣኒ ኔና ዖላኒ፥ ኔኤኒያ ሃሣ ታና ዖላኒ ሃያ ሹጮ ኩሎና ዻኣቦና ኮርሳ ዖኦኪ ፔቴያኮ ዓጮ ጌሉዋጉዲ፥ ሃይ ኩሎና ሹጮንታ ጶቂሥሢም ጌዒ ጌሢንቴ ዻኣባ ኑ ባኣካ ማርካኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ዬያ ኑ ካፑዋዖ ሃሼቶ ዓብራሃሜንታ ናኮሬንታኮ ፆኦሲ፥ ዔያቶኮ ዓዳሢ ፆኦሲያ ፑርታ ሜቶ ኑጊዳ ዓጎንጎ!» ጌዔኔ። ዬካፓ ዒዛኮ ዓዴ፥ ዪሳኣቄ ዒጊጫ ፆኦዛሢ ሱንፆና ዬያ ቢያ ካፓኒ ያይቆኦቤ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ዬኖ ዹኮ ዑፆይዳ ያይቆኦቤ ፆኦሲም ሚቺ ዒንጎ ባኮ ዒንጊ ካሽኬኔ፤ ሃሣ ጊንሣ ዓሶ ቢያ ሙኡዚ ሙዓንዳጉዲ ዔኤሌኔ፤ ዓሳ ሙዔሢኮ ጊንፃ ዬኖ ዋንቴሎ ዒኢካ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ዚሮ ጉቴሎ ላኣባ ጉቴ ዓሚ ዔቃዖ ናኣቶና ዒዛኮ ናኣቶኮ ናኣቶና ሄርቂ፥ ዓንጂ ኮሺ ዴዑዋቴ ጌዔስካፓ ፔ ማኣሪ ማዒ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ያይቆኦቤ ጎይፆ ዓኣዺፆይዳ ዓኣንቴ ፆኦሲኮ ኪኢታንቻ ጎይፃ ዒዛና ካኣሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ዒዚ ዔያቶ ዴንቃዖ «ፆኦሲ ዱንኪ ዴዔ ቤሲ» ጌዒ ዬኖ ቤዜሎኮ ሱንፆ ማሂናይሜ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ዬካፓ ያይቆኦቤ ዔዶኦሜ ዓጮይዳ ሴዒሬ ጌይንታ ዓጬሎይዳ ናንጋ ዒዛኮ ቶይዲ ዔኤሳዎ ባንሢ ኪኢታ ዓሲ ቤርታሲ ዳኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ሂዚ ጌዒ ዒዚ ዔያቶ ዓይሤኔ፥ «ታ ጎዳ፥ ዔኤሳዎም ሂዚ ጌዒ ኬኤዙዋቴ፦ ‹ኔ ዓይላሢ፥ ታኣኒ፥ ያይቆኦቤ ሃይማ ሄላንዳኣና ናንጌሢ ላኣባና ዎላ ማዔሢ ታ ኔኤም ኬኤዛኒ ኮዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ሃኣዛጌ፤ ሃሢ ታኣኮ ሚርጌ ባይ፥ ሃሬ፥ ዋኣሪንታ ማራይንታ፤ ሃሣ ዬያጉዲ ታኣም ማዾ ማዻ ዓቲንቄንታ ላኣሊንታ ዓኣኔ፤ ዓካሪ ሃያ ታ ኔኤም ኪኢቶ ዳካሢ ኔኤና ታ ቡካኒ ኮዒኬ።›» ");
INSERT INTO mdyeth_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ኪኢቶ ዓሶንሢያ ዴንዲ ሄሊ ያይቆኦቤ ባንሢ ማዒ ሙካዖ፦ «ኔ ቶይዲ ዔኤሳዎ ኮራ ኑ ዓኣዼንቴ፥ ዒዚ ኔኤና ዎላ ካኣማኒ ሙኪሢዳ ዓኣኔ፤ ዒዛና ዎላ ዖይዶ ፄኤታ ዓሲያ ሙካኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ያይቆኦቤ ዬያ ዋይዜ ዎዶና ሚርጌ ዒጊጪ ሜታዻዖ ዒዛና ዓኣ ዓሶ ላምዖ ቤሲ ፓቂ፥ ሃሣ ዬያጉዲ ማራቶንታ ዋኣሮንታ ጋኣላሢንታ ቢያ ላምዖ ቤሲ ፓቂ ፓቂ ዔቂሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ዬያ ዒ ማዼሢ «ዔኤሳዎ ጎዖንቴ ሙኪ ዛሎ ባይዜቶ፥ ፔቴ ዛላታዖ ቶላኒ ዳንዳዓኔ» ጌዒ ማሊሢናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ዬካፓ ያይቆኦቤ፦ «ታ ዓዶንሢ ዓብራሃሜና ዪሳኣቄና ፆኦዛሢዮ! ታኣኮ ሺኢጲፆ ዋይዜ፤ ናንጊና ናንጋ ጎዳሢዮ! ‹ኔኤኮ ሾይንቶ ዓጮ፥ ኔ ዒጊኖ ባንሢ ማዒ ዴንዴ፤ ዒኢካ ታ ኔኤም ኮሺ ማዓንዳጉዲ ማሃንዳኔ› ኔ ታኣም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ታና ኔኤኮ ዓይላሢም ሃያ ጉዴያ ኮሹሞና ጉሙርቂንሢና ኔ ዻዋኒ ኮይሱዋያታንቴኬ፤ ሃያኮ ቤርታ ዮርዳኖሴ ዎሮና ፒንቂ ታ ሙካኣና ታኣኮ ኮኦላዾ ኮኦሎማፓ ዓታዛ ፔቴታዖ ዓኣ ባኣዚ ባኣሴ፤ ሃሢ ጋዓንቴ ላምዖ ቤሲ ፓቂንቴ ፃጲ ታ ዔኪ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ታናንታ ላኣሎንታ ናኣቶንታ ዓይሱዋዖ ኑና ዔኤሳዎ ባይዛንዳኔ ጌዒ ታ ዒጊጫሢሮ ታ ቶይዲ ዔኤሳዎይዳፓ ኔ ታና ዓውሳንዳጉዲ ታ ኔና ሺኢቃኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","‹ኮሺ ባኣዚ ታ ኔኤም ማዻንዳኔ፤ ዜርፆዋ ኔኤኮ ፓይዲንታኒ ዳንዳዒንቱዋ ባዞ ዓጫ ዓኣ ማኣሻሎጉዲ ታ ሚርጊሻንዳኔ› ኔ ጌዔሢ ጶቂሤ» ሂዚ ጌዒ ሺኢቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ያይቆኦቤ ዬኖ ቤዞይዳ ዎርቂ ጉቴ ዓሚ ዔቃዖ ዓኣ ባኮ ቢያይዳፓ ቶይዲ ዔኤሳዎም ዒንጋኒ ቁሪ ጊኢጊሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ዬያይዲ ላምዖ ፄኤታ ዋኣሪ ዒንዴና ላማታሚ ኮላይ፥ ላምዖ ፄኤታ ዒንዴ ማራይና ላማታሚ ዓዴ ማራይ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ሃይሢታሚ ዻንሢሣ ጋኣሎ ናኣቶና ዎላ፥ ሃሣ ዖይዲታሚ ዒንዴ ባይና ታጶ ዚያ ጌማይ፥ ላማታሚ ዒንዴ ሃሬና ታጶ ዓዴ ሃሬና ማሂ ቁሬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ዬንሢ ቆልሞንሢ ቶኦኪና ቶኦኪና ዱማሳዖ ዬያ ፓቂንቴ ቆልሞ ዒሻንዳጉዲ ሄንቃ ናይ ጌሤኔ፤ ዬንሢ ሄንቃዞንሢም፦ «ታኣኮ ቤርታ ዓኣዹዋቴ፤ ቆልሞኮ ባኣካ ሃኬ ሃኬ ቤሲ ዓኣያ ማዓንዳጉዲ ማሂጋፓ ዒንሢ ጊንፆ ጊንፆ ዓኣዹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ቤርታ ዓኣዻ ሄንቃሢም፦ «ታ ቶይዲ ዔኤሳዎ ጎይፃ ዒንሢና ካኣሚ ‹ኔ ዓንኮ ዓሲዳይ? ዎካ ኔ ዴንዳይ? ሃይ ኔ ዒሻ ቆልማ ዖኦሮዳይ?› ጌዒ ኔና ዖኦጬያ ማዔቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‹ሃይ ቆልማ ኔ ዓይላሢ ያይቆኦቤሮኬ፤ ዒዚ ሃያ ዳኬሢ ታ ጎዳ፥ ዔኤሳዎም ዒንጉዋቴ ጌዒኬ፤ ሃይሾ ዒዚ፥ ያይቆኦቤ ኑኡኮ ጊንፆ ሙካኔ› ጌዒ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ዬካፓ ላምዓሶና ሃይሣሶና ፓቂንቴ ቤዛ ዓኣዞንሢና፥ ሃሣ ዓቴ ቆልሞ ሄንቃዞንሢም፦ «ዒንሢያ ዔኤሳዎ ዴንቄቶ ዒማ ጌይ ኬኤዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‹ባሼ፤ ኔ ዓይላሢ፥ ያይቆኦቤ ጊንፆ ሙኪ ሙኪ ዓኣኔ› ጌዒ ዒዛም ኬኤዙዋቴ» ጌዔኔ። ዬያ ዒዚ ጌዔሢ «ታኣኒ ሄላንዳሢኮ ቤርታ ታ ዒዛም ዳኬ ባኮና ዻጎ ታ ዒዛኮ ሺሚሳንዳያናንዳኔ፤ ጊንፃፓ ዒዚ ታኣና ካኣማኣና ዎዛዺ ታና ጎይሣ ሞኦኪ ዔካንዳኔ» ጌዒ ማሊሢናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ዬያይዲ ዒሾም ዒንጎንዶ ባኮ ያይቆኦቤ ቤርታሲ ዳኬሢኮ ጊንፃ ዱንኪ ዒኢካ ዔያታ ዴዔ ቤዛ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ዬኖ ዋንቴሎ ያይቆኦቤ ዔቃዖ ላምዖ ዒዛኮ ማቾንሢና ጊንፃኣ ማቾንሢ ማዔ ላምዖንሢንታ ዒዛኮ ታጶ ፔቶ ናኣቶዋ ዔኪ ያኣቦቄ ዎሮና ፒንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ዔያቶ ዎሮና ዒዚ ፒንሤሢኮ ጊንፃ ዒዛኮ ዓኣ ሜሆ ቢያ ፒንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ዒዚ ጋዓንቴ ዎሮ ሱካ ፔኤሮ ዓቴኔ፤ ዬካፓ ዬኖ ዋንቴሎ ሳዓ ካራንዳያ ሄላንዳኣና ፔቴ ዓሲ ማሹንቦ ዒዛ ዓርቃኣና ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ዬይ ዓሢ ያይቆኦቤ ዓጋኒ ባሺንታዖ ቶኮኮ ጉባዞ ቃኣቶ ጳርቄኔ፤ ዬማና ያይቆኦቤ ማሹምባሢ ዓርቃኣና ቃኣታ ጉባዞና ካኣማ ካራፓ ቶሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ዬካፓ ዓሢ፦ «ሳዓ ካራኒ ዑኬሢሮ ታና ሃሼ» ጋዓዛ፥ ያይቆኦቤ፦ «ኔ ታና ዓንጂባኣቶ ታ ኔና ሃሻዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ዓሢ ዒማና፦ «ሱንፃ ኔኤኮ ዖናዳይ?» ጋዓዛ፥ ዒዚ «ሱንፃ ታኣኮ ያይቆኦቤኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ዓሢ ጊንሣ፦ «ሃይፓ ሴካ ኔኤኮ ሱንፃ ያይቆኦቤ ጌይንቶፓ፤ ፆኦሲንታ ዓሲንታ ማሹምቦና ኔ ባሼሢሮ ሱንፃ ኔኤኮ ‹ዒስራዔኤሌ› ጌይንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ያይቆኦቤ ዓሢ ኮራ፦ «ኔ ሱንፃ ዖናዳዖ?» ጋዓዛ፥ ዓሢ፦ «ኔ ታኣኮ ሱንፆ ዔራኒ ኮዓሢ ዓይጎሮዳይ?» ጋዓዖ ያይቆኦቤ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ያይቆኦቤ ዒማና፦ «ፆኦሲኮ ቤርታ ዔቂ ዛጊ፥ ሃይሾ ሼምፖና ታ ዓኣኔ» ጌዒ ዬያይዳፓ ዔቄያና ዬኖ ቤዜሎኮ ሱንፆ «ጲኢኒዔኤሌ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ያይቆኦቤ ጲኢኒዔኤሌፓ ዒቂ ዓኣዻኣና ዓባ ፆርቄኔ፤ ዬማና ጉባዛ ዒዛኮ ጳርቂንቴሢሮ ዒዚ ዋካልቃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ዬያሮ ዒስራዔኤሌ ዓሳ ሃኖ ሄላንዳኣና ቆልሞኮ ጉባዛ ካኣማ ካራ ዓኣ ቃኣቶ ዓሽኮ ሙዑዋሴ፤ ዓይጎሮ ጌዔቶ ያይቆኦቤ ዓሢና ዎላ ማሹንባሢ ዓርቃኣና ዓሢ ዒዛኮ ጉባዞ ጳርቄሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ያይቆኦቤ ሃኬና ዔኤሳዎ ዖይዶ ፄኤታ ዓሲና ዎላ ሙካሢ ዴንቃዖ ፔኤኮ ናኣቶ ዛሎ ሊያና ዎላ፥ ዛሎ ራኣሄሎና ዎላ ሃሣ ዓቴዞንሢ ላምዖ ዒዛኮ ማዾ ማዻ ላኣሎንሢና ዎላ ማሂ ፓቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ቤርታሲ ላምዖ ዒዛኮ ጊንፃኣ ማቾንሢና ዔያቶኮ ናኣቶና ዳኬኔ፤ ሄሊሲ ሊያና ዒዞ ናኣቶና ዳኬኔ፤ ሃይሣሲ ራኣሄሎና ናኣዚ ዮሴፔና ቢያፓ ጊንፃ ሙካንዳጉዲ ማሃዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ዒዚ ቢያሢኮ ቤርታ ዓኣዺ ቶይዲ ዔኤሳዎ ኮይላ ዑካዖ፥ ሳዖ ባንሢ ሂርኪ ጌዒ ላንካይ ማይንቲ ዚጊ ቦንቾ ዔኤሊሢ ዔኤሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ዔኤሳዎ ጋዓንቴ ዒዛና ካኣማኒ ዒዛ ባንሢ ጳሽካዖ፥ ባቃኖ ፔ ኩጮና ማሪ ዓርቂ ሄርቂንታዖ ላምዖንሢ ዎዛፓ ዔቄያና ዬኤኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ዔኤሳዎ ያይቆኦቤኮ ጊንፆ ሙካ ላኣሎና ናኣቶና ዴንቄ ዎዶና፦ «ሃንሢ ኔኤና ዎላ ዓኣዞንሢ ዓይጎ ዓሲዳዖ?» ጌዒ ዖኦጫዛ፥ ያይቆኦቤ ማሃዖ፦ «ታ ጎዳሢዮ! ሃንሢ ፆኦሲ ፔ ኮሹሞና ታኣም ዒንጌ ታ ናኣቶኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ዬካፓ ያይቆኦቤኮ ጊንፃኣ ማቾንሢ ዔያቶኮ ናኣቶና ዎላ ሙኪ ዒዛ ቦንቾ ዔኤሊሢ ዔኤሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ሃሣ ሊያና ዒዞኮ ናኣቶና፤ ጋፒንፃ ዮሴፔና ራኣሄሎና ዎላ ሙኪ ቦንቾ ዔኤሊሢ ዔኤሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ዔኤሳዎ ያይቆኦቤ ኮራ፦ «ቤርታ ቤርታ ዒሺንቲ ዓኣዻንቴ ታ ዛጌ ቆልማ ዓይጎዳይ?» ጌዔኔ። ያይቆኦቤ ማሃዖ፦ «ታ ጎዳሢዮ! ዬይ ኔኤና ዎላ ቡካኒ ኔኤም ታ ዳኬያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ዔኤሳዎ ጊንሣ፦ «ታ ጌኤዛሢዮ! ታኣም ጊዳ ቆሎ ዓኣኔ፤ ኔኤሲ ኔኤም ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ያይቆኦቤ ጋዓንቴ፦ «ያዺ ማዖፓ፤ ጎኔና ኔ ታና ናሽካቶ ሃዳራ ታ ኔኤም ዒንጋ ባኮ ዔኬ፤ ኔ ታና ናሹሞና ዛጌሢሮ፥ ኔ ዓኣፖ ካሮ ዛጊፆ ፆኦሲ ዓኣፒ ካራ ዛጋያ ማሂ ታ ፓይዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ዬያሮ ሃዳራ ሃያ ታ ኔኤም ዒንጌሢ ዔኬ፤ ፆኦሲ ፔ ኮሹሞና ታኣም ኮይሳ ባኣዚ ቢያ ዒንጌኔ» ጋዓዖ ያይቆኦቤ ዒዚ ዒንጋ ባኮ ዔኤሳዎ ዔካንዳጉዲ ዒናፓ ሺኢቄሢሮ ዔኤሳዎ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ዔኤሳዎዋ፦ «ዓካሪ፥ ሂንዳ ቢሩዋቴ፤ ጋዓንቴ ታ ኔኤኮ ቤርታ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ዬካፓ ያይቆኦቤ፦ «ናኣታ ላባያታሢ ታ ጎዳሢዮ ኔ ዔራኔ፤ ዻንሢሣ ቆልሞንታ ዋናናኣቶንታ፥ ሃሣ ናኣሪ ናኣቶ ዛሎ ማላንዳያ ታና ኮይሳኔ፤ ፔቴ ኬሊታዖ ሩኡሪና ጉኡዲ ዔያቶ ዒሾናቶ ቆልማ ቢያ ኩዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ዬያሮ ሃዳራ ታ ጎዳሢዮ ኔኤኒ ቤርታዺ ዓኣዼ፤ ታኣኒያ ጊንፆ ኔኤኮ ታሢ ታሢ ሙካንዳኔ፤ ቆልሞና ናኣቶና ዙንሢ ዔኪ ሴዒሬይዳ ኑ ዎላ ካኣማንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ዔኤሳዎ ያይቆኦቤም፦ «ሂዴቶ፥ ታኣና ዎላ ዓኣ ዓሶይዳፓ ዻካ ዓሲ ኔ ኮራ ታ ዓይሳንዳኔ» ጌዔኔ። ያይቆኦቤ ጋዓንቴ፦ «ታ ጎዳሢዮ፥ ኔኤና ዎላ ታ ቡኬያፓዓቴም ሜሌ ዓይጌያ ታኣም ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ዬያሮ ዔኤሳዎ ዬኖ ኬሎና ጎይፆ ኬስኪ ሴዒሬ ማዒ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ያይቆኦቤ ጋዓንቴ ሱኮቴ ጌይንታ ቤሲ ዓኣዻዖ ዒኢካ ፔኤኮ ማኣሪ ማዢ፥ ባኣቶኮዋ ባርታ ዲርቄኔ፤ ዬያሮ ዬኖ ቤዜሎኮ ሱንፃ ሱኮቴ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ሜሶፖታሚያይዳፓ ያይቆኦቤ ካኣናኔ ዓጮ ማዒ ዓኣዻዖ፥ ሴኬሜ ጌይንታ ካታሜሎ ኮሺና ሄሌኔ፤ ዒኢካ ካታሞኮ ቤርቶ ዛሎና ዓኣ ቦኦሎጊዶይዳ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ዒዚ ናንጎሮ ዓፒላፓ ማዦና ማኣሮ ዾቄ ቤዞ ሴኬሜ ዓዶ፥ ሃሞሬ ማኣሮ ዜርፆይዳፓ ፄኤታ ሹቺ ቢራና ዒ ሻንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ዒኢካ ዒዚ ፆኦሲም ዒንጎ ባኣዚ ዒንጎንዶ ቤሲ ሹቺና ኮሻዖ «ዒስራዔኤሌ ፆኦሲ ማዔ ናንጊና ናንጋ ጎዳ» ጌዒ ዬኖኮ ሱንፆ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ፔቴ ኬሊ ሊያ ያይቆኦቤም ሾዔ ዲኢና ጌይንታ ዉዱሮ ናዔላ ዔያታ ናንጋ ካኣናኔ ዓጮይዳ ዓኣ ላኣሎ ዛጋኒ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ዬኖ ዓጮ ሱኡጋሢ፥ ሂዋዌ ዓጮ ዓሢ፥ ሃሞሬ ናኣዚ፥ ሴኬሜ ዒዞ ዴንቃዖ ዎልቄና ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ዒዞኮ ሚዛጱማፓ ዔቄያና ዒዞ ዒ ኮሺ ናሽኬኔ፤ ዬያሮ ናዔላ ዒዛ ናሽካንዳጉዲ ናሹሞ ዑኡሲና ጌሺሢ ሃይሴ ዒ ጌስቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ዬካፓ ዒዚ ፔ ዓዶ ኮራ፦ «ሃኖ ናዔሎ ታ ዔኮም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ያይቆኦቤ ፔኤኮ ናዎ ዲኢና ዓሲ ዎልቄና ዓርቄሢ ዋይዜኔ፤ ጋዓንቴ ዒዞኮ ጌርሲንሢ ቆልሞና ሶኦፔሢሮ ዔያታ ማዓንዳያ ሄላንዳኣና ዚቲዮ ጌዒ ካፔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ዬካፓ ሴኬሜኮ ዓዴ ሃሞሬ ያይቆኦቤና ጌስታኒ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ዒማ ኬሎና ያይቆኦቤኮ ናኣታ ባኣቶ ሄንፃፓ ሙካዖ ማዺንቴ ባኮ ዋይዚ ሚርጌ ዲቃቴኔ፤ ሴኬሜ ያይቆኦቤኮ ናዎ ዓርቂፆና ዒስራዔኤሌ ዴሮ ዻውሲሴሢሮ ሚርጌና ዔያታ ዻጋዼኔ፤ ዓይጎሮ ጌዔቶ ዬያጉዴ ባኣዚ ማዺንታንዳያ ኮይሱዋያታሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ሃሞሬ ጋዓንቴ ዔያቶ ኮራ፦ «ታ ናዓሢ፥ ሴኬሜ ዒንሢኮ ናዔሎ ሚርጌና ናሽኬሢሮ ዒዛም ዒንጉዋቴራ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ጉቤና ኑኡና ዒንሢናኮ ባኣካ ዔፒ ዛላና ጫኣቁሞ ኑ ጫኣቆም፤ ኑኡኒ ዒንሢኮ ዉዱሮ ናኣቶ ዔኬም ዒንሢያ ኑ ዉዱሮ ናኣቶ ዔኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ዬያይዲ ኑ ዓጮይዳ ኑኡና ዎላ ዒንሢ ናንጋኒ ዳንዳዓኔ፤ ዒንሢ ኮዔ ቤሲ ሃንቲ፥ ኮርሞዋ ኮርሚ ኮርሚ ዖርጎጪ ናንጋኒ ዒንሢ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ሴኬሜ ጊንሣ ፔ ዛሎና ዲኢናኮ ዓዶና ጌርሲንሢናም፦ «ታ ማሊፆ ዒንሢ ኩንሤቶ ዒንሢ ኮዔ ባኣዚ ቢያ ታ ዒንሢም ማዻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ዑኡቴሎ ዛሎ ዒንሢ ኮዔሢጉዴያ ማጋጬ ታና ዖኦጩዋቴ፤ ዒዞ ታ ዔካንዳጉዲ ዒንሢ ጌዔቶ ዒንሢ ኮዔ ባኣዚ ቢያ ታ ዒንሢም ዒንጋኒ ጊኢጊንቴያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ሴኬሜ ያይቆኦቤ ናኣቶኮ ጌሮ ዲኢና ዎልቄና ዓርቄሢሮ ዔያታ ሴኬሜና ዒዛኮ ዓዶ ሃሞሬናም ጌሺሢና ሂዚ ጌዒ ማሄኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","«ኑ ጌሮ ዓቲንቴ ቤርቲ ቲቂንቲባኣ ዓሲ ዔካንዳጉዲ ኑ ኮዑዋሴ፤ ያዺ ማዔቶ ዬይ ኑኡም ፑኡፒ ዻውሲንቲኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ዒዞ ኑኡኒ ኔኤም ዒንጋኒ ዳንዳዒሳ ፔቴ ጎይሢ ሌሊ ዓኣኔ፤ ዬና ዓይጎዳይ ጌዔቶ ኔናንታ ኔ ዓጮ ዓቲንቆንታ ቢያ ኑጉዲ ዓቲንቶ ቤርቶ ቲቂንቴያ ማዔቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ያዺ ማዔቶ ዒንሢ ኑ ዉዱሮ ናኣቶ፥ ኑኡኒያ ዒንሢ ዉዱሮ ናኣቶ ዔካንዳኔ፤ ፔቴ ዴሬ ማዒያ ኑ ዎላ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ኑኡኮ ማሊፆ ዒንሢ ዔኪባኣቶ፥ ዓቲንቶ ቤርቶዋ ዒንሢ ቲቂንቲባኣቶ ኑ ጌሬሎ ኑ ዔኪ ዓኣዻንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ዬና ጌኤዞ ዔኤዒፆ ጫኣቁሜላ ሃሞሬና ናኣዚ ሴኬሜናም ኮሺ ማሊ ጴዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ሴኬሜ፥ ያይቆኦቤኮ ናዎ ሚርጌና ናሽኬሢሮ ጌይንቴ ባኮ ቢያ ማዻኒ ፔቴታዖ ኔጊባኣሴ፤ ዒዚ ፔ ዓዶ ማኣራ ሚርጌ ቦንቺንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ዬያሮ ሃሞሬና ናኣዚ ሴኬሜና ካታሞ ጌሎ ካራ ዓኣ ዓሳ ቡካ ቤዞ ዓኣዻዖ፥ ካታሞይዳ ናንጋ ዓሶም፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«ሃንሢ ዓሶንሢ ኑኡና ዎላ ናንጋሢ ኮሹሞናኬ፤ ሃኖ ዓጬሎይዳ ኑኡና ዎላ ዔያታ ናንጎንጎ፤ ሃሣ ዔያታ ኮዔሢጉዲ ሃንቶንጎ፤ ሃይሾ! ዓጬላ ኑኡና ዔያቶናም ጊዳንዳያኬ፤ ዔያቶኮ ዉዱሮ ናኣቶ ኑ ዔኮም፤ ኑ ዉዱሮ ናኣቶዋ ኑኡኒ ዔያቶም ዒንጎም። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ጋዓንቴ ሃንሢ ዓሶንሢ ኑኡና ዎላ ናንጋኒና ኑኡና ዎላ ፔቴ ዴሬ ማዓኒ ኮዓሢ ኑኡኒ ዓቲንቃ ቢያ ዔያቶጉዲ ዓቲንቶ ቤርቶ ቲቂንታኒ ዔኤዔቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ኑ ዬያዴቶ ዔያቶኮ ቆልማ፥ ባኣታ ሜሌ ዓኣ ባካ ቢያ ኑኡም ማዓንዳኔ፤ ዬያሮ ዔያቶና ዎላ ኑ ፔቴ ማዖም፤ ዔያታ ኑኡና ዎላ ናንጎንጎ» ሂዚ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ካታሜሎይዳ ናንጋ ዓሳ ቢያ፤ ሃሞሬንታ ዒዛኮ ናኣዚ ሴኬሜንታ ጌዔ ማሊፆ ዋይዚ ዔካዖ ዓቲንቃ ቢያ ፔኤኮ ዓቲንቶ ቤርቶ ቲቂንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ሃይሣሳ ኬሎና ዓቲንቆኮ ቢያ ዓቲንቶ ቤርቶ ቲቆና ኪፃ ፓፁዋንቴ፥ ያይቆኦቤ ናኣቶይዳፓ ላምዖ፥ ዲኢናኮ ጌርሲንሢ ሲሞኦኔና ሌዊና ፔኤኮ ጬንቻ ዓፓሮ ዓፓሮ ዓርቃዖ ዖኦኒያ ዔያቶ ዔሩዋንቴ ካታሞ ሳዞ ጌሊ ዓቲንቆ ቢያ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ሃሞሬንታ ናኣዚ ሴኬሜያ ዓይሱዋዖ ዓፓሮና ዎዼሢኮ ጊንፃ ጌሮ ዲኢና ሴኬሜ ማኣራፓ ዔያታ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ዓቴ ያይቆኦቤኮ ናኣታ ሃይቄ ዓሶ ማኣሪ ጌሊ ጌሊ ዔያቶ ጌኤዴላ ዎልቄና ዓርቂንቴ ካታሜሎ ጉቤ ቡሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ማራታ፥ ዋኣራ፥ ባኣታ፥ ሃራኣ፤ ዬያጉዲ ካታሞ ጋሮንታ ዙሎንታይዳ ዓሶኮ ዓኣ ባኮ ቢያ ቡሪ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ላኣሎንታ ናኣቶንታ ዔያታ ዲዒ ዔኪ፥ ፔቴ ፔቴ ዓሶ ማኣሮይዳ ዴንቄ ቆሎ ቢያ ቡሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ያይቆኦቤ ፔኤኮ ናኣቶ ሲሞኦኔና ሌዊናም፦ «ታ ዑፃ ዒንሢ ፑኡፒ ሜቶ ዔኪ ሙኬኔ፤ ሃሢ ሃያ ዒንሢ ማዼሢ ዛሎና ሃኖ ዓጫ ናንጋ ካኣናኔ ዓሶንታ ፔርዜ ዓጮ ዓሳኣ ቢያ ታና ዒፃንዳኔ፤ ኑኡኒ ፓይዲና ዻካ ዓሲኬ፤ ዔያታ ፔቴ ማዒ ኑና ዖሌቶ ታኣና ታ ማኣሮ ዓሶና ኑ ጋፔኔ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ዔያታ ጋዓንቴ፦ «ዓይጎ ባኣዚ ማዔቶዋ ኑ ጌኤዴላ ዞኦስካ ኮኦማ ላኣሊጉዲ ዎልቄና ዓርቂንታዛ ዛጊ ኑ ጊባኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ፆኦሲ ያይቆኦቤም፦ «ሃሢ ዔቂ ቤኤቴኤሌ ዓኣዺጋፓ ዒኢካ ናንጌ፤ ሚና ኔ ቶይዲ ዔኤሳዎይዳፓ ዓኣሺንቲ ኔ ዓኣዼያና ኔኤም ጴዼ ፆኦዛሢ፥ ታኣም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮ ቤሲ ሹቺና ዒኢካ ኮሼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ዬያሮ ያይቆኦቤ ዒዛኮ ማኣሮ ዓሶና ዒዛና ዎላ ዓኣ ዓሶናም፦ «ዒንሢ ኮራ ዓኣ ሜሌ ፆኦዞ ቢያ ባይዙዋቴ፤ ዒንሢያ ጌኤሹዋቴ፤ ሃሣ ጌኤሺ ዓፒላ ማይንቱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ሃካፓ ኑ ዔቂ ቤኤቴኤሌ ዓኣዻንዳኔ፤ ሃያኮ ቤርታ ታ ሜታዼ ዎዶና ታና ማኣዴሢና ታ ዓኣዼ ቤዞ ቢያይዳ ታ ኮራፓ ዱማዺባኣ ፆኦሲም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮ ቤሲ ዒኢካ ታ ኮሻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ዬያሮ ዔያቶኮ ካኣሽኮ ሜሌ ፆኦዞ ቢያ ዔኪ ሙኪ ያይቆኦቤም ዔያታ ዒንጌኔ፤ ዬያጉዲ ሃሣ ዔያቶኮ ዋዮይዳ ዓኣሦና ጉዴቻሢያ ቢያ ኬሲ ዒዛም ዒንጋዛ፥ ዒዚ ዬያ ቢያ ዔካዖ ሴኬሜ ዓጮይዳ ዓኣ ሻኣቦ ዴማ ዱኡኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ዬካፓ ያይቆኦቤንታ ናኣቶንታ ዬኖ ቤዞ ሃሺ ዴንዳኒ ዔቄኔ፤ ፆኦሲ ዬኖ ዓጮይዳ ዓኣ ዓሶ ዑፃ ዒጊቹሞና ዲቃቲሢና ጌልዜሢሮ ዖኦኒያ ዔያቶ ዳውሳኒ ጫርቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ያይቆኦቤ ዒዛና ዓኣ ዓሶና ዎላ ሎኦዛ ዴንዲ ሄሌኔ፤ ዬና ቤዜላ ቤኤቴኤሌኬ፤ ዒዛ ዓጬላ ካኣናኔይዳ ዓኣ ቤሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ያይቆኦቤ ዒኢካ ፆኦሲም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮ ቤሲ ኮሻዖ «ዔልቤኤቴኤሌ» ጌዒ ሱንሢ ጌሤኔ፤ ዓይጎሮ ጌዔቶ ቤርታ ዒዚ ዒሾ ኮራፓ ዓኣሺንቲ ዓኣዼያና ፆኦሲ ዒዛና ካኣሜሢ ዬኖ ቤዜሎይዳ ማዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ዒኢካ ዒርቢቃኮ ማዾ ማዻ ዲቦራ ጎዖዛ ሃይቄኔ፤ ዒዛ ቤኤቴኤሌኮ ዓባ ኬስኪ ጌላሢኮ ዾኦሎ ዛሎና ዓኣ ሻኣባሢ ዴማ ዱኡቴሢሮ፥ ዬይ ሚፃሢ ዬኤፒ ሻኣቢ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ያይቆኦቤ ሜሶፖታሚያ ዓጫፓ ማዔ ዎዶና ፆኦሲ ዒዛም ላሚ ጴዺ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ሃሣ ጊንሣ፦ «ሃሢ ሱንፃ ኔኤኮ ያይቆኦቤኬ፤ ሃካፓ ሴካ ጋዓንቴ ሱንፃ ኔኤኮ ዒስራዔኤሌ ጌይንታንዳኔ፥ ያይቆኦቤ ጌይንቲ ኔ ዔኤሊንታዓኬ» ጌዒ፥ ፆኦሲ ያይቆኦቤኮ ሱንፆ «ዒስራዔኤሌ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ላሚ ሃሣ ፆኦሲ ያይቆኦቤም፦ «ቢያ ባኮ ዳንዳዓ ፆኦዛሢ ታናኬ፤ ሚርጌ ናይ ሾዔ፤ ዜርፃኣ ኔኤኮ ሚርጎንጎ፤ ሚርጌ ዴሬኮ ዓዶ ማዔ፤ ካኣታ ኔ ዜርፃፓ ኬስኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ኔ ማዖ ዓብራሃሜና ኔ ዓዶ ዪሳኣቄናም ታ ዒንጌ ዓጮ ኔኤም ታ ዒንጋንዳኔ፤ ሃኖ ዓጬሎ ኔኤኮ ጊንፃፓ ሙካ ዜርፆም ታ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ፆኦሲ ያይቆኦቤና ዎላ ጌስታዖ ዬኖ ቤዛፓ ሌካ ዔቂ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ያይቆኦቤ ፆኦሲና ዎላ ጌስቴ ቤዞይዳ ማላታ ማዓንዳጉዲ ሹቺ ዻኣባዖ ሹጬሎ ፆኦሲም ዱማሳኒ ዎይኔይዳፓ ኮሾና ዑሺንታ ዛይቴያ ሹጮ ዑፆይዳ ዋሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ያይቆኦቤ ፆኦሲ ዒዛና ጌስቴ ቤዜሎኮ ሱንፆ «ቤኤቴኤሌ» ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ያይቆኦቤና ማኣሮ ዓሶና ቤቴዔኤሌ ዓጮ ሃሺ ዓኣዼኔ፤ ዬማና ዔያታ ዔፕራታ ጎዖ ቤዜሎ ሄላኒ ዑካዛ ራኣሄሎ ሾይቺ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ሾይፃ ዒዞ ሚርጌና ሜታሴ ዎዶና ዒዞ ዓርቂ ዓኣ ላኣሌላ «ራኣሄሌ፥ ሜሌ ዓቲንቄ ናይ ኔ ሾዓንዳሢሮ ዒጊጪፖ ዶዴ!» ዒዞም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ዒዛ ጋዓንቴ ሃይቃኒ ሳዛ ጋሽካዖ ሃይቃንዳሢኮ ቤርታ ናዓሢኮ ሱንፆ «ቢኒዖኦኒ» ጋዓዛ፥ ዓዳሢ ጊንሣ «ቢኢኒዓሜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ዬማፓ ቤዞማና ራኣሄላ ሃይቂ፥ ዔፕራታ ዓኣዻ ጎይፆ ዓጫ ዱኡቴኔ፤ ዬና ቤዜላ ሃኖ ቤኤቴሌሄሜ ጌይንታዞኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ያይቆኦቤ ማቾ ራኣሄሎኮ ዱኡፖ ዑፃ ማላታ ማዓንዳጉዲ ሹቺ ዻኣቤኔ። ዬይ ዻኣባ ሃኖ ሄላንዳኣና ዬይ ራኣሄሎ ዱኡፖታሢ ዔርዛኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ዬካፓ ያይቆኦቤ ዓኣዺ ዔዴሬ ጌይንታ ሹጮና ዼጊሲ ኮሾና ቤዞኮ ሶ ሱካ ዓፒላፓ ማዦና ማኣሮ ዾቂ ዒኢካ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ያይቆኦቤ ዬኖ ዓጬሎይዳ ናንጋንቴ፥ ዒዛኮ ናኣዚ ቶይዲ ሮኦቤኤሌ ዒዛኮ ጊንፃኣ ማቾ፥ ባኣላና ዎላ ላሄሢ ዒ ዋይዜኔ። ያይቆኦቤኮ ዓቲንቆ ናኣታ ታጶ ላምዖኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ያይቆኦቤ ማቾ ሊያ ናኣታ፦ ቶይዳሢ ሮኦቤኤሌ ማዓዛ ሃንጎዋታ ሲሞኦኔ፥ ሌዊ፥ ዪሁዳ፥ ዪሳኮኦሬንታ ዛብሎኦኔንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ራኣሄሎ ናኣታ፦ ዮሴፔና ቢኢኒዓሜናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ራኣሄሎም ማዾ ማዻ ባኣላ ናኣታ፦ ዳኣኔና ኒፕታኣሌኤሜናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ሊያም ማዾ ማዻ ዚሊፓ ጎዖዜሎ ናኣታ፦ ጋኣዴና ዓሴኤሬናኬ። ዬንሢ ዓቲንቆ ናኣቶንሢ ያይቆኦቤ ሜሶፖታሚያይዳ ዓኣንቴ ሾይንቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ያይቆኦቤ ኬብሮኦኔ ዓጫ፥ ሜሚሬይዳ ናንጋ ፔ ዓዶ ዪሳኣቄ ኮራ ዓኣዼኔ፤ ዬና ቤዛ ዓብራሃሜና ዪሳኣቄና ናንጌ ቤዞኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ዪሳኣቄ ፄኤታና ሳሊታሚና ሌዔ ናንጋዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ሚርጌ ጋርቺ ሃይቃዛ ዒዛኮ ናኣታ ዔኤሳዎና ያይቆኦቤና ዒዛ ዱኡኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ዔዶኦሜ ጌይንቴ ዔኤሳዎ ዜርፆኮ ሾይንቶ ሃይሳ ሃይማፓ ዴማ ዓኣሢ ጉዴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ዔኤሳዎ ካኣናኔ ዓጮ ላኣሎይዳፓ ላኣሊ ዔኬኔ፤ ዔያታ ሄቴ ዓሢ ዔሎኔ ጌይንታሢኮ ናዎ ዓዳ ጎዖዜሎና ሂዋዌ ዜርፃሢ ፂባዖኔ ናኣዚ ዓና ጎዖሢ ሾዔ ዖሆሊባማ ጌይንታዜሎንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ኔባዮቴ ጌሮ ማዔ ዒስማዔኤሌ ናዎ ባስማቴ ጎዖዞንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ዓዳ ዔኤሳዎም ዔልፓዜ ሾዔኔ፤ ባስማቴ ሬዑዔኤሌ ጎዖሢ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ዖሆሊባማ ሃሣ ዬዑሻኔ፥ ያዒላሜንታ ቆሬንታ ሾዔኔ። ዬንሢ ቢያ ዔኤሳዎኮ ካኣናኔ ዓጮይዳ ሾይንቴ ናኣቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ዬካፓ ዔኤሳዎ ፔኤኮ ላኣሎና ዓቲንቆና ዉዱሮ ናኣቶና፤ ሃሣ ዒዛኮ ማኣሮይዳ ዓኣ ዓሶ ቢያ፥ ባኣቶንታ ዓኣ ቆሎንታ ቢያ፥ ካኣናኔ ዓጮይዳ ዓኣዖ ዒ ቆሌ ባኮ ቢያ ዔኪ ጌኤዚ ያይቆኦቤ ኮራፓ ሃኪ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ዬያ ዒ ሃኪ ዴንዴሢ ዒዛና ጌኤዚናኮ ሚርጌ ቆሎ ዓኣሢሮ፥ ዔያታ ዱንኪ ዴዔ ዓጬላ ዔያቶ ላምዓሢም ጊዲባኣሢሮኬ፤ ላምዖንሢኮ ሚርጌ ቆልሞ ዓኣሢሮ ዎላ ዔያታ ናንጋኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ዬያሮ ዔዶኦሜ ጌይንቴ ዔኤሳዎ ዹኮ ዓጮ ሴዒሬ ጌይንታዞይዳ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ዹኮ ዓጮ ሴዒሬይዳ ናንጋ ዔዶኦሜ ዓሶኮ ቤርታኣ ዓዳሢ ማዔ ዔኤሳዎ ዜርፃ ሃይፓ ዴማ ፓይዲንታዞንሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ዔኤሳዎ ማቾ ዓዳይዳፓ ዔልፓዜ፤ ባስማቶይዳፓ ሬዑዔኤሌ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ዔልፓዜኮ ናኣታ፦ ቴማኔ፥ ዖማሬ፥ ፄፖ፥ ጋዒታሜና ቄናዜንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ዔኤሳዎ ናኣዚ ዔልፓዜኮ ቲዒሚና ጌይንታ ጊንፃኣ ማቾስኬና ዓኣኔ፤ ዒዛ ዔልፓዜም ዓማሌቄ ጎዖሢ ሾዔኔ፤ ዬንሢ ቢያ ዔኤሳዎ ማቾ ዓዳኮ ናኣዚ ናኣቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ሬዑዔኤሌኮ ናኣታ፦ ናሃቴ፥ ዜራሄ፥ ሻማንታ ሚዛንታኬ፤ ዬንሢ ዔኤሳዎ ማቾ ባስማቶኮ ናኣዚ ናኣቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ዓናኮ ናዎ ፂባዖኔኮ ናኣዚ ናዎ ማዔ ዖሆሊባማ ዔኤሳዎም ሾዔ ናኣታ፦ ዬዑሻ፥ ያዒላሜንታ ቆራሄንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ዔኤሳዎኮ ናኣዚ ቶይዲ ዔልፓዜ ማኣሮ ዓሶ ቶይዳ፦ ቴማኔ፥ ዖማሬ፥ ፄፖ፥ ቄናዜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ቆራሄ፥ ጋዒታሚንታ ዓማሌቄንታኬ፤ ዬንሢ ዔዶኦሜ ዓጮይዳ ዔልፓዜ ማኣሮ ዓሶኮ ቶይዶንሢ ማዓዛ፥ ዔያታ ዔኤሳዎ ፔ ማቾ ዓዳይዳፓ ሾዔዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ዔኤሳዎ ናኣዚ ሬዑዔኤሌ ጎዖሢ ማኣሮ ዓሶ ቶይዳ፦ ናሃቴ፥ ዛራሄ፥ ሻማንታ ሚዛንታ ማዓዛ፥ ዬንሢ ዔዶኦሜ ዓጮይዳ ሬዑዔኤሌ ማኣሮ ዓሶኮ ቶይዶንሢኬ፤ ዔያታኣ ዔኤሳዎ ፔ ማቾ ባስማቶይዳፓ ሾዔዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ዔኤሳዎኮ ማቾ ዖሆሊባማፓ ሾይንቴ ቶይዶንሢ፦ ዬዑሼ፥ ያዒላሜንታ ቆራሄንታኬ፤ ዬንሢ ዓና ናዎ ማዔዜሎ ዖሆሊባማፓ ሾይንቴ ዔኤሳዎ ዜርፆኮ ቶይዶንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ዬንሢ ቢያ ዔዶኦሜ ጌይንቴ ዔኤሳዎ ናኣቶና ዒዛ ማኣሮኮ ቶይዶ ማዔዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ዔዶኦሜ ዓጮይዳ ናንጋ ሴዒሬኮ ናኣቶ ማዔ ሆሬ ዓጮ ዓሶኮ ቶይዶንሢ፦ ሎፃኔ፥ ሾባሌ፥ ፂባዖኔ፥ ዓና፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ዲሾኔ፥ ዔፄሬንታ ዲሻኔንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ሎፃኔ ሆሬና ሄማሜ ጎዖ ቶኦኮኮ ቤርታኣ ማዓሢኬ። ሎፃኔኮ ቲሚናዔ ጌይንታ ጌሮስኬና ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ሾባሌኮ ናኣታ፦ ዓሊዋኔ፥ ማናሃቴ፥ ዔባሌ፥ ሲፖና ዖናሜ ጌይንታዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ፂባዖኔ ናኣታ፦ ዓያና ዓናናኬ፤ ዬይ ዓና ጎዖሢ ፔ ዓዶኮ ሃሬ ሄንቂቤቃ ዓሲ ናንጉዋ ዳውሎይዳ ፃባላ ዋኣሢ ዓልቃ ቤሲ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ዓና ናኣዚ ዲሾኔ ጌይንታኔ፤ ዉዱሮ ናዔላ ዖሆሊባማ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ዲሾኔ ናኣታ፦ ሄሚዳኔ፥ ዔሽባኔ፥ ሂቲራኔና ኬራኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ዔፄሬ ናኣታ፦ ቢሊሃኔ፥ ዛዒዋኔና ዓቃኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ዲሻኔ ናኣታ፦ ዑፂና ዓራኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ሆሬ ዓጮ ዓሶኮ ቶይዳ ሃይካፓ ሊካ ፓይዲንታዞንሢኬ፤ ሎፃኔ፥ ሾባሌ፥ ፂባዖኔ፥ ዓና፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ዲሾኔ፥ ዔፄሬንታ ዲሻኔንታኬ፤ ዬንሢ ቢያ ሆሬ ዜርፆ ማዔ ሴዒሬ ዓጮ ቶይዶንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ዒስራዔኤሌ ዓጮይዳ ካኣታ ካኣታዺሢ ዓርቁዋንቴ ቤርታሲ ዔዶኦሜ ዓጮይዳ ካኣታዼ ካኣታ ሃይፓ ዴማ ፓይዲንታዞንሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ቢዖሬ ጎዖሢኮ ናኣዚ ባኣላኣቄ ዔዶኦሜ ዓጮይዳ ካኣታዼኔ፤ ዒዚ ካኣታዼ ካታሜላ ዲኒሃባ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ባኣላኣቄ ሃይቄሢኮ ጊንፃ ቡፂራ ጌይንታ ዓጪ ዓሲ ዜራሄ ጎዖስኬያኮ ናኣዚ፥ ዮባቤ ዒዛ ቤዛ ካኣታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ዮባቤ ሃይቄሢኮ ጊንፃ ቴማኔ ዓጮ ዓሢ ሁሻሜ ዒዛ ቤዛ ካኣታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ሁሻሜ ሃይቃዛ ሚዲያሜ ዓሶ ሞዓኣቤ ቦኦሎይዳ ዖሎና ባሼ ባዳዴ ናኣዚ፥ ሃዳዴ ዒዛ ቤዛ ካኣታዼኔ፤ ዒ ካኣታዼ ካታሜላ ዓዊቴ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ሃዳዴ ሃይቄስካፓ ማስሬቃ ጌይንታ ዓጮ ዓሢ፥ ሳሚላ፥ ዒዛ ቤዛ ካኣታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ሳሚላ ሃይቃዛ ዎሮ ዓጫ ዓኣ ሪሆቦቴ ጌይንታ ቤዜሎይዳ ሾይንቴ ሻዑሌ ዒዛ ቤዛ ካኣታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ሻዑሌ ሃይቄስካፓ ዓኪቦሬ ናኣዚ፥ ቤዓልሃናኔ ጎዖሢ ዒዛ ቤዛ ካኣታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ዓኪቦሬ ናኣዚ ባዓኣሌሃናኔ ሃይቃዛ ሃዳሬ ጎዖሢ ዒዛ ቤዛ ካኣታዼኔ፤ ዬይ ካኣታዼ ካታሜላ ፓዑ ጌይንታያኬ፤ ማቻ ዒዛኮ ሜዛሃቤ ናኣዚ፥ ማፂሬዴ ሾዔያ ሜሄፃቤሎ ጌይንታስሜኖኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ሃንሢ ሃይፓ ዴማ ዓኣ ዔኤሳዎ ዜርፆኮ ቶይዶንሢ፥ ፔኤኮ ዜርፆ ሱንፆና ሃሣ ናንጋ ቤዞ ሱንፆና ዔኤሊንታኔ፤ ዬያታ፦ ቲሚናዔ፥ ዓልዋ፥ ዮቴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ዖሆሊባማ፥ ዔላ፥ ፒኖኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ቄናዜ፥ ቴማኔ፥ ሚቢፃሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ሜግድዔኤሌና ዔራሜናኬ። ፔኤኮ ፔኤኮ ናንጎ ቤዞ ሱንፆና ዔኤሊንታ ዔዶኦሜ ዓሶ ቶይዶንሢ ዬንሢኬ፤ ያዒ ማዓዛ ዔኤሳዎ ዬያቶ ዔዶኦሜ ዓሶኮ ዓዳሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ያይቆኦቤ ዬያኮ ቤርታ ዒዛኮ ዓዴ ናንጌ ካኣናኔ ዓጮይዳ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ያይቆኦቤ ዜርፆኮ ሃይሳ ሃይፓ ዴማ ኬኤዚንታሢ ጉዲኬ፤ ዮሴፔኮ ሌዓ ታጶ ላንካይ ሌዔ ማዔ ዎዶና ዓዶኮ ላኣሎ ባኣላና ዚሊፓና ጌይንታዞንሢፓ ሾይንቴ ዒዛኮ ጌርሲንሢና ዎላ ማራይንታ ዋኣሪንታ ሄንቃኔ፤ ዒማና ጌርሲንሢ ማዻ ፑርቶ ባኮ ቢያ ዓዶም ሙኪ ሙኪ ዒ ኬኤዛኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ዒስራዔኤሌ ሃንጎ ናኣቶይዳፓ ቢያ ባሼ ዮሴፔ ናሽካኔ፤ ዓይጎሮ ጌዔቶ ጋርቼዖ ዒዛ ዒ ሾዔሢሮኬ፤ ዬያሮ ሚዛጲ ኩቺና ሙካ ዓፒላ ዒዛም ሲኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ጌርሲንሢ ዔያቶኮ ዓዴ ዔያቶይዳፓ ዑሣ ዓኣዼ ዮሴፔ ናሽካሢ ዔራዖ ቂኢሪ ዒዛ ዒፄኔ፤ ኮሺ ዑኡሲና ዒዛና ጌስታኒያ ዔያታ ኮዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ፔቴ ዓቢ ዋንቴ ዮሴፔ ዓውቲ ዓውታዻዖ ጌርሲንሢም ኬኤዛዛ፥ ዔያታ ዒዛ ቤርታኣስካፓ ባሼ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ዒዚ ዔያቶም ኬኤዛዖ፦ «ታና ዓውታሴ ዓውቲ ታ ዒንሢም ኬኤዞም፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ኑ ቢያሢ ጎሺ ጋርካ ዔልዓ ናኣራ ናርቃንቴ፥ ታ ናኣራ ፒዝ ጌዒ ዔቃዛ ዒንሢ ናኣራ ጋዓንቴ ታ ናኣሮኮ ዓጮ ጉቤ ማንጊ ዔቃዖ፥ ሂርኪ ጌዒ ዚጋኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ጌርሲንሢ ማሃዖ፦ «ሂዴቶ ኔ ኑኡኮ ካኣቲ ማዒ ኑና ዎይሣኒ ማላኔ ጌይሢዳ?» ጌዒ ዖኦጬኔ። ዮሴፔ ዓውታዼ ዓውቶና ዔያቶኮ ፑርቶ ማዾዋ ዓዶም ኬኤዛሢናሮ ባሼና ዔያታ ዒዛ ዒፂሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ዬካፓ ዮሴፔ ሜሌ ዓውቲ ዓውታዻዖ ጌርሲንሢም፦ «ሃሣ ታ ሜሌ ዓውቲ ዓውታዼኔ፤ ዓውቶና ታ ዛጌሢ ዓቢና ዓጊኒና፥ ሃሣ ታጶ ፔቴ ዦኦጌ ታኣም ሂርኪ ጌዒ ዚጋንቴኬ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ዬያ ጌርሲንሢም ዒ ኬኤዜ ዓውቶ ዓዶም ኬኤዛዛ ዓዴ ዋይዛዖ፦ «ሃይ ዎዚጉዴ ዓውቲዳይ? ታናንታ ኔኤኮ ዒንዶንታ፤ ሃሣ ኔ ጌርሲንሢንታ ሙኪ ኔኤም ሂርኪ ጌዒ ዚጋንዳያ ማላ?» ጌዒ ዒዛ ጎሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ዮሴፔኮ ጌርሲንሢያ ዒዛ ዒናፓ ቂኢሬኔ፤ ዓዴ ጋዓንቴ ፔ ዒኖና ዓይጌ ማዓንዳቴያ ማሊ ማሊ ካፓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ፔቴ ኬሊና ዮሴፔኮ ጌርሲንሢ ዓዶኮ ቆልሞ ዔኪ ሴኬሜይዳ ሄንቃኒ ዓኣዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ዒስራዔኤሌ ዮሴፔም፦ «ኔ ጌርሲንሢ ቆልሞ ሄንቃኒ ሴኬሜ ዔኪ ዓኣዼሢ ኔ ዔራኔ፤ ዬያሮ ሃሢ ታ ኔና ዔያቶ ኮራ ዳካኒ ኮዓኔ» ጋዓዛ፥ ዮሴፔ «ዔኤዔ፥ ታ ዴንዳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ዓዴ ጊንሣ ዒዛም፦ «ዓካሪ ዓኣዺጋፓ ኔ ጌርሲንሢንታ ቆልሞንታ ዓኣ ጎይፆ ዛጊ ሙኪ ታኣም ኬኤዜ» ጋዓዖ፥ ዒስራዔኤሌ ዮሴፔ ኬብሮኦኔ ዶኦጫፓ ዳኬኔ፤ ዬካፓ ዮሴፔ ዓኣዺ ሴኬሜ ሄላዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ዒኢካ ቦኦላ ዣኣሊ ዓኣንቴ ፔቴ ዓሲ ዒዛ ዴንቂ፦ «ሃይካ ኔ ዓይጎ ኮዓይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ዮሴፔ ማሃዖ፦ «ታ ጌርሲንሢ ታኣኒ ኮዓኔ፤ ዔያታ ቆልሞ ዔኪ ዎካ ዓኣዼቴያ ኔ ታኣም ኬኤዛንዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ዓሢ ዒዛም፦ «ዔያታ ሃይፓ ቤቴኔ፤ ‹ኑ ዶኦታኔ ጎዖ ቤዜሎ ዓኣዻንዳኔ› ዔያታ ጋዓንቴ ታ ዋይዜኔ» ጌዔኔ። ዬካፓ ዮሴፔ ጌርሲንሢ ዓኣዼ ጊንፆ ዓኣዻዖ ዶኦታኔይዳ ዔያቶ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ጌርሲንሢ ዒዛ ሃኬና ዓኣንቴ ዴንቃዖ ዒዛ ዎዻኒ ዞርቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ዔያታ ዎሊ ኮራ፦ «ሃኣሶ ዛጉዋቴ፤ ዓውቶ ዓዴ ሙኬኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ሃኒ ሙኩዋቴ፥ ዒዛ ኑ ዎዺጋፓ ሃያ ዋኣፃባኣ ዛሮ ዔቶኮ ፔቴይዳ ኬኤሬስካፓ ‹ፑርታ ቦዖ ዒዛ ሙዔኔ› ጌዒ ቦዖ ዑፃ ኑ ጌሣንዳኔ፤ ዬያይዲ ዓካሪ ዒዛኮ ዓውቶ ጋፒንፆ ኑ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ቶይዲ፥ ሮኦቤኤሌ ዬያ ዔያቶኮ ፑርቶ ሃይሶ ዋይዛዖ ዔያቶይዳፓ ዒዛ ዓይሳኒ ኮዒ፦ «ሃሹዋቴ፤ ያዺ ጌይፖቴ፤ ኑ ዒዛ ዎዺባኣቴ ኮሺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ዒንሢ ዒዛ ዎዻሢዳፓ ሃይካ ቦኦላ ዓኣ ዋኣፃባኣ ዛሮ ዔቶይዳ ጉሪ ዓጉዋቴ» ጌዔኔ። ሮኦቤኤሌ ዬያ ጌዔሢ ዔያታ ዎዻኒ ጋዓሢዳፓ ዓይሲ፥ ዓዶ ባንሢ ዮሴፔ ዳካኒ ማሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ዮሴፔ ጌርሲንሢ ኮራ ሙኪ ሄላዛ ሚዛጶ፥ ኩጮና ሙካ ማኣዔሎ ዒዛ ዑፃፓ ዔያታ ኬሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ዬካፓ ዔያታ ዒዛ ዓርቂ ዔኪ ዋኣፃ ባኣ ፃኣዾ ዛሮ ዔታ ኬኤሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ያዺ ዔያታ ማዼስካፓ ሙዖ ሙዓኒ ዴዔኔ፤ ሙዖ ዔያታ ሙዓ ጎይሣ ዓኣዖ ዒስማዔኤሌ ዓጮኮ ኮርሞ ዓሳ ሃኬና ዬዓንቴ ዴንቄኔ፤ ዬያታ ኮርማሢ ዓሳ ፔኤኮ ጋኣላሢዳ ዱማ ዱማ ሙኡዚም ማዓ ሳውቃ ዼኤሻ፥ ቤላሴ ጌይንታ ቲሺንታ ኬርቤንታ ጫኣኒ ጌሌዓዴ ዓጫፓ ጊብፄ ዓጮ ዓኣዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ዒማና ዮሴፔኮ ዒሼ፥ ዪሁዳ ሃንጎ ጌርሲንሢም፦ «ኑ ጌኤዛሢ ኑ ዎዺ ሃይቦ ዒዛኮ ኑኡኒ ዓኣቼቶ ዓይጎ ኑኡም ዎኦታንዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ዒዛይዳ ኑ ሜቶ ሄሊሳስካፓ ሃንሢ ዒስማዔኤሌ ዓጮ ኮርሞ ዓሶንሢም ኑ ሻንቼቶ ኮሺኬ፤ ዓይጎሮ ጌዔቶ ዒዚ ኑኡኮ ጌኤዚ ማዔሢሮኬ» ጋዓ ማሊሢ ሺኢሻዛ ጌርሲንሢ ኮሺኬ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ሚዲያሜ ዓጫፓ ማዔያ ኮርሞ ኮርማ ዓሳ ዒኢካ ሙኬኔ፤ ዒስማዔኤሌ ዓጮ ዓሶንሢ ዬኖ ቤዞና ዓኣዻኣና ዮሴፔኮ ጌርሲንሢ ዔታፓ ዮሴፔ ጎቺ ኬሳዖ ዬንሢ ዒስማዔኤሌ ዓጮ ዓሶንሢም ላማታሚ ሹቺ ቢራም ሻንቼኔ፤ ኮርሞ ዓሶንሢያ ዒዛ ዔኪ ጊብፄ ዓጮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ዬካፓ ቶይዲ፥ ሮኦቤኤሌ ዔቶ ቤዞ ሙኪ ዮሴፔ ባኣሢ ዛጋዖ ዬኤኪ ዓፒሎ ፔኤኮ ዳርዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ሃንጎ ጌርሲንሢ ኮራ ዒ ሙኪ፦ «ዓካሪሾ፥ ናዓሢ ኑ ዓጌ ቤዛ ባኣሴ! ማይ ታ ዎዚም ዓኣዼቴ ኮሺዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ዬካፓ ፔቴ ዋኣሪ ሹካዖ ዮሴፔኮ ዓፒሎ ሱጉፆይዳ ዔያታ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ዬኖ ሚርጌና ሚዛጶ ዓፒሌሎ ዔኪ ዔያቶኮ ዓዶ ኮራ ዓኣዻዖ፦ «ሃኣዛጌ፥ ሃይማ ኑ ዴንቄኔ፤ ኔ ናዖ ዓፒሎታቴያ ሜሌታቴያ ዛጌ» ዔያታ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ዓዴ ፔኤኮ ናዖ ዓፒሎታሢ ዔራዖ፦ «ጎኔ ሃይ ዒዛ ዓፒሎኬ፤ ፔቴ ፑርታ ቦዖ ዒዛ ዎዼኔ፤ ታ ናዓሢ ዮሴፔ ቦዖ ዳርዚ ሙዔኔ» ጋዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ፔኤኮ ማኣዓሢ ዬኤኪ ዳርዚ፥ ሲዬ ፓቲሌያ ማይንቲ ሚርጌ ኬሊ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ዓቲንቆና ዉዱሮ ናኣቶና ቢያ ዓዶ ዶዲሻኒ ሙኬኔ፤ ዒዚ ጋዓንቴ፦ «ታ ሃይቂ፥ ሃይቄ ዓሳ ዴንዳ ቤዞ ዴንዳንዳያ ሄላንዳኣና ታ ናዓሢ ዛሎ ታ ዬኤካንዳኔ» ጌዒ ዶዲፆ ዒፂ፥ ናዓሢ ዛሎ ዖዪሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ዬማና ሚዲያሜ ዓሶ ማዔዞንሢ ጊብፄ ዓጮይዳ ጲፂፓራም ዮሴፔ ሻንቼኔ፤ ጲፂፓራ ጊብፄ ዓጮ ካኣቲ ዴማ ማዻ ቢታንታ ዓኣ ዓሶይዳፓ ፔቴሢ ማዔያ፥ ካኣቲ ማኣሮ ካፓ ዓሶኮ ሱኡጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ዬኖ ዎዶና ዪሁዳ ጌርሲንሢዳፓ ዱማዺ ሂራ ጌይንታ ዓዱላማ ዓጮ ዓሢ ኮራ ዓኣዺ፥ ዒኢካ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ዒኢካ ዒዚ ካኣናኔ ዓጮ ዓሢ፥ ሹዓኔ ጎዖሢኮ ዉዱሮ ናይስኬኖ ዴንቃዖ ዒዞ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ዒዛ ጎጳዺ ዓቲንቄ ናይ ሾዔኔ፤ ሱንፆዋ ናዖኮ ዔኤሬ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ላሚ ሃሣ ጎጳዺ ዓቲንቄ ናይ ሾዓዖ፥ ሱንፆ ዖናኣኔ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ጊንሣ ሃሣ ዓቲንቄ ናይ ሾዒ፥ ሱንፆ ሼኤላ ጌዒ ጌሤኔ፤ ዬያ ናዓሢ ዒዛ ሾዔሢ ዪሁዳ ዓክዚቤ ጌይንታ ቤዞይዳ ናንጋ ዎዶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ዪሁዳ፥ ፔኤኮ ናኣዚ ቶይዲ ዔኤሬም ቲዒማሮ ጎዖ ዉዱሮ ናይስኬኖ ዴንቃዛ፥ ዔኤሬ ዒዞ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ናንጊና ናንጋ ጎዳ ዔኤሬኮ ዒና ፑርታ ማዔሢሮ ዛጊ ዒዛ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ዪሁዳ ፔኤኮ ናኣዚ፥ ዔኤሬኮ ጌኤዚ ዖናኣኔም «ዴንዲ፥ ኔ ዔሾ ማቾ ዔኬ፤ ዎጎ ጎይፆጉዲ ኔ ዒሾም ፃጲ ማዓ ናይ ሾዔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ሾይንታ ናኣታ ዒዛም ማዑዋኣሢ ዖናኣኔ ዔራዖ ዒሾ ማቾና ላሃ ዎዶና ቢያ ጎጳሳ ዜርፆ ሳዓ ላኣላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ናንጊና ናንጋ ጎዳ ዬይ ፑርታ ማዾ ማዔሢ ዛጌሢሮ ዒዛኣ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ዬካፓ ዪሁዳ ፔኤኮ ናኣዚ ማቾ ቲዒማኣሮም «ታ ናኣዚ ሼኤላ ጶሾርታንዳያ ሄላንዳኣና ኔ ዓዶ ማኣሪ ዓኣዺጋፓ ዓኒ ሃይቄ ላኣሊ ማዒ ናንጌ» ጌዔኔ። ዬያ ዒዚ ጌዔሢ ዒዛኮ ናኣዚ ሃንጎ ጌርሲንሢጉዲ ሃይቃንዳኔ ጌዒ ማሊ ዒጊጬሢሮኬ፤ ዬያሮ ቲዒማኣራ ዓኣዺ ፔኤኮ ዓዶ ማኣራ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ሚርጌ ሌዔ ዴዔሢኮ ጊንፃ ሹዓ ጎዖሢ ናኣ፥ ዪሁዳ ማቻ ሃይቄም ዪሁዳ ሲዮ ጋፒሴሢኮ ጊንፃ ፔኤኮ ላጋሢ ዓዱላኣሜ ዓጮ ዓሢ ሂራና ዎላ ዒዛኮ ማራቶ ዑፃፓ ጋፓኖ ታይዛ ዓሳ ዓኣ ቤዞ ቲሚና ዓጮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ዪሁዳኮ ናኣዚ ማቾ፥ ቲዒማኣሮም ዓሳ፦ «ኔኤኮ ማዔ፥ ዒዛኮ ማራቶ ጋፓኖ ታይዛ ዓሶ ኮራ ቲሚና ዎታኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ዬያሮ ቲዒማኣራ ዓኒ ሃይቄያ ማዒፆ ዔርዛ ዓፒሎ ሃሺ ዓኣፖ ካሮዋ ሻኣሾና ካንቃዖ፥ ቲሚና ዓኣዻ ጎይፆ ዓጫ ዔናይሜ ጎዖ ካታሞ ጌሎ ካራ ዴዔኔ፤ ዬያ ዒዛ ማዼሢ ዪሁዳ ናኣዚ፥ ሼኤላ ጶሾርቴንቴ ዒዞ ዒዛም ዒንጋኒ ዒዞኮ ማዔ ዪሁዳ ናሽኩዋኣሢ ዔሬሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ዒዛ ዓኣፖ ካሮ ፔኤኮ ሻኣሻሢና ካንቂ ዓኣንቴ ዪሁዳ ዴንቃዖ፥ ዓኒባኣ ዞኦስካ ኮኦማ ላኣሊ ዒዛም ማላዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ዒዛኮ ናኣዚ ማቾታሢ ዔሩዋዖ ዒዛ ጎይፆ ዓጫ ዴዒ ዓኣንቴ ዒዞ ባንሢ ሙካዖ፦ «ዔናኣ፥ ታ ኔኤና ላሆም» ጌዒ ዖኦጫዛ፥ ዒዛ፦ «ኔ ጌዔሢ ታ ኩንሤቶ ታኣም ኔ ዓይጎ ዒንጋንዳይ?» ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ዒዚ ዒማና፦ «ቆልሞ ባኣካፓ ዋናናይ ታ ኔኤም ዒንጋንዳኔ» ጋዓዛ፥ ዒዛ «ኮሺኬ፤ ያዺ ማዔቶዋ ዋናናዖ ኔኤኒ ዳካንዳያ ሄላንዳኣና ዓይሢ ማዓ ባኣዚ ታኣም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ዒዚ፦ «ሂዴቶ፥ ዓይሢ ማዓ ባኣዚ ዓይጎ ታ ኔኤም ዒንጎንዶይ?» ጌዔኔ። ዒዛ፦ «ኔ ሱንፆ ዔርዛ፥ ኔ ሱንፆና ዹይንቴ ዢኢራሢ፥ ቱኮ ባኮና ዎላ፤ ሃሣ ጊንሣ ኔኤኮ ኮኦሎዋ ታኣም ዒንጌ» ጌዔኔ። ዬያሮ ዒዚ ዒዛ ዖኦጬ ባኮ ቢያ ዒንጋዖ ዒዞና ላሄም ዒዛ ጎጳዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ዬካፓ ዒዛ ሻኣሻሢ ዓኣፖ ካራፓ ዔኪ፥ ዓኒ ሃይቄሢ ዔርዛ ዓፒሎ ማይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ዪሁዳ ዋናናዖ ዒንጋንዳያ ሄላንዳኣና ጌዒ ዓይሤ ባኮ ማሂሳኒ ዋናናዓሢ ዔኪ ዒዛኮ ላጋሢ ዓዱላሜ ዓጮ ዓሢ ዑፃ ላኣሌሎም ዳኬኔ፤ ዓሢ ጋዓንቴ ላኣሌሎ ዴንቃኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ዓሢ ዒኢካ ናንጋ ዓሶ ኮራ፦ «ዔናይሜ ጌሎ ካራ ዴዓ፥ ዞኦዛ ኮኦማ ላኣሌላ ሃይፓ ዓንኮ ዓኣዼይ?» ጌዒ ዖኦጫዛ፥ ዓሳ ማሃዖ፦ «ሃያ ጉርዶይዳ ዬያጉዴ ዞኦስካ ኮኦማ ላኣሊ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ዬያሮ ዓሢ ዪሁዳ ኮይላ ማዒ ሙካዖ፦ «ዬኖ ላኣሌሎ ታ ዴንቃኒ ዳንዳዒባኣሴ፤ ዒኢካ ናንጋ ዓሳ፦ ‹ዬያጉዴ ዞኦስካ ኮኦማ ላኣሊ ሃይካ ባኣሴ› ታኣም ጌዔኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ዪሁዳ ዒማና፦ «ታ ዒዞም ዋናናይ ዳኬንቴ፥ ኔኤኒ ዒዞ ዴንቃኒ ዳንዳዒባኣሢሮ፥ ዓሲ ኑና ሚኢጩዋጉዲ ዒዛ ዓይፆ ዔኬ ባኮንሢ ፔኤሮ ማሂ ዔዔኮንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ዬካፓ ሃይሦ ዓጊኒ ማዓኣና ዓሳ፦ «ኔኤኮ ናኣዚ ማቻ፥ ቲዒማኣራ ዓሲና ላሂ ጎጳዼኔ» ጌዒ ዪሁዳም ኬኤዜኔ። ዬያሮ ዪሁዳ፦ «ጉርዳፓ ዙሎ ዔኪ ኬሲ ታሚና ሚቺ ዒዞ ዎዹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ዒዛ ዓርቂንቲ ጉርዳፓ ዙሎ ኬስካዖ፦ «ታኣኒ ጎጶ ዔኬሢ ሃንሢ ባኮንሢኮ ዓዶይዳፓኬ፤ ሃኖ ሱንፆ ዔርዛ ዢኢሬሎና ቱኮ ባኮና፥ ሃሣ ሃኖ ኮኦሌሎና ዖኦሮታቴያ ዔሬ» ጌዒ ዒዞኮ ማዖ፥ ዪሁዳም ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ዪሁዳ ዒዛ ዳኬ ባኮንሢ ዖኦሮ ማዔቴያ ዔራዖ፦ «ታ ናኣዚ፥ ሼኤላም ታ ዒዞ ዒንጊባኣሢሮ ዒዛ ታጊዳፓ ባሼ ፒዜ ማዔኔ» ጌዔኔ፤ ዬማፓ ላሚ ዒ ዒዞና ላሂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ሾይፆ ኬላ ዒዞኮ ዑካዛ ጎጶ ጋራ ሜንቴ ናይ ዓኣሢ ዔርቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ሾይፃ ዒዞ ዓርቄም ዒዛ ባናኣና ሜንቶ ናኣቶንሢዳፓ ፔቴሢኮ ኩጫ ቤርታ ኬስኬም ዓርቂ ሾይዣ ላኣሌላ ዞቄ ፓቲሌ ናዖኮ ኩጫ ቱካዖ፦ «ሃይ ቤርታ ኬስኬሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ጋዓንቴ ዬይ ኩጮ ጊንሣ ማሃዛ፥ ጌኤዛሢ ቤርታዺ ሾይንቴኔ፤ ዓርቂ ሾይዣ ላኣሌላ፦ «ዎይቲ ኔ ኮርሳ ኬስኬይ?» ጌዔኔ። ዬያሮ ቤርቶ ናዓሢኮ ሱንፃ፦ «ፓርሴ» ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ዬካፓ ቤርታ ዞቄ ፓቲሎ ኩጫ ቱኮናሢ ሾይንታዛ፥ ሱንፃ ዒዛኮ ዛራሄ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ኮርሞ ኮርማ ዒስማዔኤሌ ዓጮ ዓሳ ዮሴፔ ጊብፄ ዔኪ ዓኣዺ ዒኢካ ጊብፄ ዓጮ ካኣቲኮ ዴማ ማዒ ማዻ ዓሶይዳፓ ፔቴሢ፥ ጲፂፓራም ሻንቼኔ፤ ጲፂፓራ ጊብፄ ዓጮ ካኣቲ ካፓ ዓሶኮ ሱኡጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ናንጊና ናንጋ ጎዳ ዮሴፔና ዎላ ዓኣሢሮ ጊብፄይዳ ዒዛ ዎይሣሢ ማኣራ ዒ ናንጋኣና ቢያ ባካ ዒዛም ኮሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ናንጊና ናንጋ ጎዳ ዮሴፔና ዎላ ዓኣሢና ማዾ ቢያ ዒዛም ኮሼሢ ዛጋዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ዒዛ ዎይሣ ጲፂፓራ ዮሴፔኮ ማዾና ዎዛዼኔ፤ ዬያሮ ፔኤኮ ዴማ ናሽኪንታ ዑኬ ማዒ ማዻያ ማሂ ዒዛ ዶኦሬኔ፤ ፔኤኮ ማኣሮ ዓሶ ዓይሣያ፥ ሃሣ ዓኣ ቆሎ ቢያ ዑፃዺ ዛጋንዳ ቢታንቶ ዒዛም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ያዺ ማዔ ኬላፓ ዓርቃዖ ናንጊና ናንጋ ጎዳ ዮሴፔ ዛሎና ዬያ ጊብፄ ዓሢኮ ማኣሮ፥ ቆሎንታ ጎዦና ዒዛኮ ዓኣ ባኮ ቢያ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ዬያሮ ጲፂፓራ ዓኣ ቆሎ ቢያ ዮሴፔ ቢታንቶ ዴማ ማሄኔ፤ ጲፂፓራ ዒማና ሙዖ ሙዓማፓ ዓታዛ ዓይጎዋ ዔራ ባኣዚ ባኣያ ማዒ፥ ዒዛ ዑፃ ቢያ ባኮ ሃሼኔ። ዮሴፔኮ ዔጶና ማላሢያ ሚርጌ ሚዛጳያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ናንጊቤቃ ማኣሮ ዓዶኮ ማቻ ዮሴፔ ዛጊ ላሃኒ ዓፃዻዖ፦ «ሃኒ ሙኬ፤ ኑ ዎላ ላሆም» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ዮሴፔ ጋዓንቴ ዬያ ማዻኒ ኮይባኣሢሮ ሂዚ ዒዞም ጌዔኔ፦ «ታ ጎዳሢ ቢያ ባኮ ታ ዎይሣንዳጉዲ ታኣም ዒንጌኔ፤ ዒዛኮ ማኣሮይዳ ዓኣ ቆሎ ቢያኮ ዓይጎዋ ዒ ዔራ ባኣዚ ባኣሴ፤ ዓኣ ባኮ ቢያ ዒዛም ታ ዎይሣንዳጉዲ ታኣም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ታ ጎዳሢኮ ሃይካ ማኣራ ዓኣ ቆሎ ቢያይዳ ታጊዳፓ ባሼ፥ ታኣኮ ዑፃ ዓኣይ ባኣሴ፤ ኔ ሌሊ ዓታዛ ዒ ታኣም ዒንጊባኣ ባኣዚ ዓይጌያ ባኣሴ፤ ዬይያ ኔኤኒ ዒዛኮ ማቾ ማዔሢሮኬ፤ ዓካሪ ሃያጉዴ ፑርታ ጎሜ ፆኦሲ ቤርታ ታ ዎዲ ማዻንዳይ?» ");
INSERT INTO mdyeth_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ዒዛ ዬኖ ቢያ ኬሊ ጋዓንቴ ዮሴፔ ዒዞና ላሂፃ ዓቴም ዒዞኮ ዓጮ ሙካኒያ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ፔቴ ኬሊ ዮሴፔ ማዾሮ ጋሮ ጌላንቴ ጋሮይዳ ፔቴታዖ ሜሌ ማዻ ዓሲ ባኣያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ዒማና ዒዛኮ ጎዳሢ ማቻ ዓፒሎ ዒዛኮ ማሪ ዓርቃዖ፦ «ታኣና ዎላ ላሄ» ጋዓዛ፥ ዒዚ ጋዓንቴ ዒዛኮ ዒዛ ዓርቄ ዓፒሎ ዒዞ ኩጫ ሃሺ ጋራፓ ጳሽኪ ዙሎ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ላኣሌላ ዒማና ዓፒሎ ፔኤኮ ዒዚ ዒዞኮ ኩጫ ሃሺ ጳሽኪ ኬስኬሢ ዛጌ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ዒዞኮ ማዻ ዓሶ ዔኤላዖ ዔያቶም፦ «ሃኣዛጉዋቴ፤ ታ ማኣሮ ዓዴ ዔኪ ሙኬ ዔብሬ ዓሢ ኑና ዻውሲሳኒ ታኣኒ ዓኣ ቆልዖ ጌሊ ታና ዓርቃኒ ጋዓዛ፥ ታኣኒ ጋዓንቴ ዑኡዞ ዼጊዲ ዒላቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ታና ዓይሳንዳ ዓሲ ዋይዚሳኒ ታ ዒላቴሢ ዒ ዋይዛዖ ፔኤኮ ዓፒሎ ታ ኮይላ ሃሺ ጳሽኪ ኬስኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ዮሴፔ ዎይሣ፥ ማኣሮ ዓዴ፥ ሙካንዳያ ሄላንዳኣና ዒዛኮ ዓፒሎ ዒዛ ፔ ኮራ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ዬካፓ ማኣሮ ዓዴ ሙካዛ ማዔ ሃይሶ ሂዚ ጌዒ ፓይዲ ፓይዲ ዒዛ ኬኤዜኔ፦ «ኔኤኒ ዔኪ ሙኬ ዔብሬ ዓሢ ታኣና ላሃኒ ታኣኒ ዓኣ ቆልዖ ጋሮ ጌሊ ኑና ዻውሲሳኒ ጌዔንቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ዓሲ ታና ዓውሳንዳጉዲ ዑኡዞ ዼጊዲ ታ ዒላታዛ ፔኤኮ ዓፒሎ ታ ኮራ ሃሺ ጳሽኪ ኬስኬኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ዮሴፔ ዎይሣሢ ዒዛኮ ማቻ «ኔኤኮ ማዻሢ ታና ሂዴኔ» ጌዒ ዒዛም ኬኤዜ ሃይሶ ዋይዛዖ ሚርጌና ዻጋዺ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ዮሴፔ ዔኪ ዴንዲ ካኣቲ ዓሶ ቱኪሳ ቱኡዞ ማኣሪ ጌልዚ ቱኡሴኔ። ጋዓንቴ ዮሴፔ ቱኡዞ ማኣራ ዓኣ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ናንጊና ናንጋ ጎዳ ዒዛና ዎላ ማዒ ዒዛ ዓንጄሢሮ ቱኡዞ ማኣሮኮ ሱኡጋሢ ዒዛ ማዾና ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ዬያሮ ቱኡዞ ዓሶ ቢያና ቱኡዞ ማኣራ ማዺንታ ባኮና ቢያኮ ዑፃ ዒዛ ቢቲ ማሂ ዶኦሬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ናንጊና ናንጋ ጎዳ ዮሴፔና ዎላ ማዒ ማዻ ባካ ቢያ ዒዛም ኮሽካንዳጉዲ ማሄሢሮ ቱኡዞ ማኣሮ ሱኡጋሢ ዮሴፔ ዎይሣ ባኮ ዛሎና ዓይጎ ማዔቶዋ ሂርጉዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ዮሴፔ ቱኡዞ ማኣራ ቱኡቲ ዓኣንቴ ጊብፄ ዓጮ ካኣቲኮ ዑዦ ዑሻ ዓሶና ካሦ ሙኡዛ ዓሶናኮ ዋኣና ማዒ ማዻ ላምዖ ዓሲስኬንሢ ፑርታ ባኣዚ ማዺ ካኣቲ ዻጋሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ካኣቲ ዬንሢ ማዻዞንሢ ዑፃ ኮሺ ዻጋዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ዬያሮ ዮሴፔ ቱኡቲ ዓኣ፥ ካፓ ዓሶኮ ሱኡጋሢ ቱኡዞ ማኣሪ ዳኪ ዔያቶ ዒኢካ ቱኪሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ቱኡዞ ማኣሮ ዎይሣሢ ዬንሢ ዓሶንሢ ዔኪ ዮሴፔም ዒንጋዛ፥ ሃንጎ ቱኡዞ ዓሶና ዎላ ሚርጌ ዎዴ ዔያታ ቱኡቲ ዴዔኔ፤ ዮሴፔያ ዔያቶም ኮይሳ ባኣዚ ዒንጊ ዔያቶ ማኣዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ዬንሢ ካኣቲ ማኣራፓ ቱኡቴ ላምዖንሢ ቱኡዞ ማኣራ ዓኣዖ ፔቴ ዋንቴ ዓውቲ ዓውታዼኔ፤ ዬያቶኮ ዓውታ ዔያታ ዓውታዼሢ ጎይፆ ጉዴያ ዱማ ዱማ ቡሊሢ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ዮሴፔ ዚሮ ጉቴሎ ዔያታ ዓኣ ጋሮ ጌሊ ላምዖንሢ ዖዪ ዴዒ ዓኣንቴ ዛጋዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","«ዒንሢ ሃኖ ዓኣፒ ካራ ቱኬሢ ዓይጎሮዳይ?» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ዔያታ ማሃዖ፦ «ኑኡኒ ቢያሢ ዓውቲ ዓውታዼንቴ፥ ዓውቶ ኑኡም ቡላ ዓሲ ባይቄኔ» ጌዔኔ። ዮሴፔ ዒማና፦ «ዓውቲ ቡላንዳጉዲ ዳንዳዒሳሢ ፆኦሲ ማዔሢሮ ዒንሢኮ ዓውቶ ታኣም ኬኤዙዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ዑዦ ዑሻሢ ፔኤኮ ዓውቶ ሂዚ ጌዒ ኬኤዜኔ፦ «ታኣኒ ዓውቶና ፔቴ ዎይኔ ዴንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ዬኖ ዎይኔሎኮ ሃይሦ ካኣፒ ዓኣኔ፤ ዋላዣኣ ዒዞኮ ዋርቃዖ ዑኬና ቡኔኔ፤ ዬካፓ ዓሚ ካፄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ካኣቲኮ ዑዦ ዑሽኮ ዓንጋ ታ ኩጫ ዓኣንቴ ታኣኒ ዎይኔሎኮ ዓኣፖ ዔኪ ዓንጎ ጋራ ጩኡጲ ካኣቲም ዒንጋያ ታና ዻዌኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ዓሢ ኬኤዜሢ ዮሴፔ ዋይዛዖ ሂዚ ዒዛም ጌዔኔ፦ «ዓውቶኮ ቡሊፃ ያኣዼ ማዓንዳኔ፤ ዎይኔሎኮ ሃይሦ ካኣፖ ኔ ዛጌሢ ሃይሦ ኬሊ ጌይሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ሃይሦ ኬሊኮ ጊንፃ ካኣቲ ኔና ቱኡዛፓ ቡላንዳኔ፤ ኔኤኮ ዻቢንቶ ቢያ ዓቶም ጌዒ ቤርታ ኔ ማዻኣና ዓኣ ኔኤኮ ፑኡፓቶ ማሂ ኔኤም ዒንጋንዳኔ፤ ቤርታ ኔ ዑዦ ዑሻ ዎዶና ማዻሢጉዲ ካኣቲኮ ዑሽኮ ባኮ ዒዛም ኔ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ጋዓንቴ ቢያ ባካ ኔኤም ኮሽኬሢኮ ጊንፃ ታና ማሊ ጶቂሢ፥ ማኣዳዎ፤ ካኣቲም ኬኤዚ ታና ሃይፓ ቱኡዞ ማኣራፓ ቡሊሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ዓይጎሮ ጌዔቶ ታኣኒ ዔብሬ ዓጫፓ ሃይካ ሙኬሢ ናሽኪቱዋንቴ ሻንቺንቲኬ፤ ሃሣ ታ ሃይካ ሙካዖ ቱኡዞ ማኣራ ቱኡቴሢ ዓይጎዋ ፑርቲሱዋዖኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ካሦ ሙኡዛ ዓሶኮ ሱኡጋሢ ዮሴፔ ዑዦ ዒንጋሢኮ ዓውቶ ቡሊፆ ኬኤዜሢ ኮሺ ማዔሢ ዛጋዖ ፔኤኮ ዓውቶ ዮሴፔም ሂዚ ጌዒ ኬኤዜኔ፦ «ታ ዓውታ ያኣዼኬ፤ ‹ሃይሦ ሌኤማቴና ቶኦኮይዳ ካሣ ታ ኬዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ቢያሢኮ ዑፃ ዓኣ ሌኤማቴሎ ጋራ ካኣቲም ጊኢጊሾና ዱማ ዱማ ሙኡዚ ዓኣንቴ፥ ካፒ ካሦ ሌኤማታፓ ሶዺ ሶዺ ሙዓያ ታና ዻዌኔ።›» ");
INSERT INTO mdyeth_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ዮሴፔ ዒዛም፦ «ዓውቶኮ ቡሊፃ ያዺ ማዓንዳኔ፤ ሃይሦ ሌኤማታ ሃይሦ ኬሊኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ሃይሦ ኬሊ ጋርካ ካኣቲ ቱኡዞ ማኣራፓ ኔና ኬሲ ቶኦኮ ኔኤኮ ቲቂሴሢኮ ጊንፃ ሚሢ ዑሢዳ ኔና ሱፄም ካፒ ዓሽኮ ኔኤኮ ሙዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ዮሴፔ ጌዔ ጎይፆማጉዲ ሃይሣሳ ኬሎና ካኣቲኮ ሾይንቶ ኬሎ ማዔሢሮ ዒዛኮ ዴማ ዱማ ዱማ ዎይሣ ዓሶም ቢያ ሙኡዚና ዑሺና ጊኢጊሻዖ፥ ዬኖ ኬሎና ዑዦ ዑሻ ዓሶና ካሦ ሙኡዛ ዓሶናኮ ዋኣኖንሢ ቱኡዞ ማኣራፓ ኬሲ ዬያ ቢታንታ ዓኣ ዓሶኮ ቤርቶ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ዬካፓ ዑዦኮ ሱኡጋሢ ቤርታኣ ማዾ ቤዞ ጌልዜኔ፤ ዬያሮ ካኣቲ ዑዦ ዑሽካ ዓንጎና ዑዦ ዒንጊፆ ዒ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ካሦ ማኣሮ ሱኡጋሢ ጋዓንቴ ሱፂሲሴኔ፤ ቢያ ባካ ዮሴፔ ዔያቶ ፔቴ ፔቴሢኮ ዓውቶ ቡሌሢ ጎይፆ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ዑዦ ዑሻ ሱኡጋሢ ጋዓንቴ ዮሴፔም ማሊባኣሴ፤ ዮሴፔ ዒዛም ሃዳርሲ ኬኤዜ ባኮዋ ቢያ ዒ ዋሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ዮሴፔ ላምዖ ዓሶንሢኮ ዓውቶ ቡሌንቴ ላምዖ ሌዔኮ ጊንፃ ጊብፄ ዓጮ ካኣቲ ዓውቲ ዓውታዼኔ፤ ዒዚ ዓውቶና ዓባዬ ጌይንታ ፑኡፖ ዎራሢ ዓጫ ዔቂ ዓኣዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ላንካይ ዲቺ ዒንዴ ባይ ዎራፓ ኬስኪ ማኣቲ ሄንቃንቴ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ሄሊሳዖ ሃሣ ኮሺ ዖኦፔ ሜሌ ላንካይ ዒንዴ ባይስኬንሢ ዎራፓ ኬስኪ ቤርታ ዎራፓ ኬስኬ ባኣቶንሢ ኮይላ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ዬካፓ ዖኦፔ ባኣቶንሢ ዲጮንሢ ዔኤዻዛ፥ ካኣቲ ጊንዓስካፓ ጴጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ላሚ ሃሣ ዒ ላሃዖ ጊንዓዛ፥ ሜሌ ዓውቲ ዒዛ ዓውታሴኔ፤ ዒዚ ዓውቶና ፔቴ ሜይዳ ላንካይ ዑፔና ቃራ ካፄ ሜይ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ሄሊሳዖ ሃሣ ሚርጌ ሎኦዳዼያና ቦኦላፓ ዔቄ ዓባ ኬስካ ዛሎ ዢባሮና ሄርቂንቲ ሴያናዼ ፔቴ ሜይዳ ላንካይ ዑፔና ፑርቄ ሜይ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ላንካዎ ሎኦዳዼ ዑፖ ሜዖንሢ ላንካዎ ዓንዲሮ ዑፖ ሜዖንሢ ዔኤዻዛ፥ ካኣቲ ጊንዓስካፓ ጴጪ፥ ዓውቲ ዓውታዼሢ ዔሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ዚሮ ጉቶ ላሃፓ ዒ ዔቃኣና ማሊፃ ካኣቲ ሜታሴሢሮ ጊብፄ ዓጫ ማርሾ ማርሻ ዓሶንታ ዔሮ ዓሶንታ ቢያ ዔኤሊ ዓውቶ ዒዛኮ ዒ ኬኤዜኔ፤ ጋዓንቴ ዒዛኮ ዓውቶ ቡሊፆ ዔሪ ኬኤዛኒ ዳንዳዔ ዓሲ ፔቴታዖ ባኣያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ዒማና ዑዦ ዑሻ ዓሶኮ ሱኡጋሢ ካኣቲም ሂዚ ጌዔኔ፦ «ታኣኒ ዻቢ ማዼ ባኣዚ ሃኖ ታ ጶቂሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ካኣቲዮ፥ ኔኤኒ ታኣና ካሦ ሙኡዛ ዓሶኮ ሱኡጋሢና ዑፃ ዻጋዺ ካፓ ዓሶኮ ሱኡጋሢ ማኣራ ኔ ኑና ቱኡሴያና፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ፔቴ ዋንቴ ኑ ላምዓሢ ዱማ ዱማ ዓውቲ ዓውታዼኔ፤ ኑ ዓውቶኮ ቡሊፃኣ ዱማ ዱማኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ቱኡዞ ዓሶኮ ሱኡጋሢም ማዻያ ፔቴ ዼጌ ዔብሬ ዓሲ ኑኡና ዎላ ቱኡዞ ማኣራ ቱኡቲ ዓኣዖ፥ ኑኡኮ ዓውቶ ኑ ዒዛም ኬኤዛዛ ዒዚ ኑኡም ቡሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ቢያ ባካ ዒ ኑኡም ጌዔሢጉዴያ ማዔኔ፤ ታና ኔኤኒ ቤርታ ታ ማዻ ቤዞ ጊንሣ ማሃዖ፥ ካሦ ሙኡዛ ዓሶኮ ሱኡጋሢ ጋዓንቴ ኔ ሱፄኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ዬያሮ ኔጉዋዖ ዓሳ ዮሴፔ ዔኪ ሙካንዳጉዲ ካኣቲ ዓይሣዛ፥ ዔያታ ዒዛኮ ቶኦኮ ሜኤዲ ሜሌ ጌኤሺ ማኣዖዋ ማይሲ ካኣቲ ቤርቶ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ካኣቲያ ዮሴፔ ኮራ፦ «ዓውቲ ታ ዓውታዼንቴ ዖኦኒያ ቡላኒ ዳንዳዒባኣሴ፤ ጋዓንቴ ኔኤኮ ዓውቲ ቡላ ዔራቶ ዓኣሢ ታ ዋይዜኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ዮሴፔ ማሃዖ፦ «ካኣቲዮ! ታኣኮ ዓውቲ ቡላኒ ዔራቶ ባኣሴ፤ ጊኢጋ ቡሊሢ ዒንጋኒ ዳንዳዓሢ ፆኦሲኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ካኣቲ ሂዚ ጌዔኔ፦ «ታኣኒ ዓውቲና ዓባዬ ዎሮ ዓጫ ዔቂ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ላንካይ ዲቺ ዒንዴ ባይ ዎራፓ ኬስኪ ማኣቲ ሄንቃንቴ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ሄሊሳዖ ኮሺ ዖኦፔ ላንካይ ዒንዴ ባይ ዎራፓ ኬስኬኔ፤ ዬንሢ ባኣቶንሢጉዲ ዒሣ ባይ ጊብፄ ዓጮይዳ ዛጊ ታ ቤቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ዖኦፒ ዒሣያ ማዔ ባኣቶንሢ ቤርታ ኬስኬ ዲጮ ባኣቶንሢ ዔኤዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ዬያታ ዔኤዼሢኮ ጊንፃ ቤርታ ዓኣማ ጎይፆ ዖኦፓታሢሮ ዲጮንሢ ዔኤዼያ ማሂ ዔራኒ ዳንዳዒንቱዋያ ማዔኔ፤ ዒማና ጊንዓስካፓ ታ ጴጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ሃሣ ላሚ ዓውቲና ፔቴ ሜይዳ ላንካይ ዓንዲርቂ ቃራ ካፄ ዑፔና ዓኣ ሜይ ታ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ሄሊሳዖ ሚርጌ ሎኦዳዺ፥ ቦኦሊ ዢባሬ ሄርቂ ሲያናሴ፥ ላንካይ ዑፔይዳ ዓኣ ሜይ ታ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ሎኦዳዼ ዑፓ ዓኣ ሜዎንሢ ሚዛጶንሢ ዔኤዼኔ፤ ዬያ ታና ዓውታሴ ዓውቶ ማርሾ ማርሻ ዓሶም ታ ኬኤዜንቴ ፔቴታዖ ዓውቶ ታኣኮ ዔያታ ቡላኒ ዳንዳዒባኣሴ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ዮሴፔ ዒማና ካኣቲም ሂዚ ጌዔኔ፦ «ላምዖ ዓውቶንሢኮ ቡሊፃ ፔቴኬ፤ ፆኦሲ ሃጊ ማዓንዳ ባኮ ቤርታሲ ኔና ዻዌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ላንካዎ ዲጮ ባኣቶንሢና ላንካዎ ኮዦ ዓኣፖ ዓኣፔ ሜዖንሢ ላንካይ ሌዔ ጌይሢኬ፤ ላምዖንሢኮ ቡሊፃ ፔቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ዔያቶኮ ጊንፃፓ ኬስኬ ላንካዎ ዖኦፖ፥ ዒሣ ባኣቶንሢና ላንካዎ ሎኦዳዼ ቦኦሎ ዢባራ ሲያናሴ ሜዖንሢኮ ቡሊፃ ፔቴኬ፤ ዬይ ላንካይ ኪሊንኮ ሉማ ሌዔ ማዓንዳኔ ጌይሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ቤርታ ታ ኔኤም ኬኤዜሢጉዲኬ፤ ፆኦሲ ሃጊ ማዓንዳ ባኮ ቤርታሲ ኔኤም ዔርዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ጊብፄ ዓጮ ቢያይዳ ላንካይ ሌዔ ሚርጌ ሚሺ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ዬካፓ ላንካይ ሌዔ ኪሊንኮ ሉማ ማዓዛ፥ ዓጫ ቢያ ሉማሢና ባይቃንዳሢሮ ዬንሢ ቤርታ ሚዦ ላንካዎ ሌዖንሢ ዋሊንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ሄሊሳ ኪሊንኮ ሉማሢ ዎዳ ሚርጌ ሜታሳያ ማዓንዳሢሮ ሚዦ ዎዳ ፔቴታዖ ጎኔ ማዒባኣያ ማላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ላሚ ላሚ ኔኤኮ ዓውታዺፃ ዔርዛሢ ፆኦሲ ቱኬ ማሊፃ ዓቱዋያ ማዔሢና ዑኬ ኬሊዳ ኩማንዳሢኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ዮሴፔ ኬኤዛዖ፦ «ዓካሪ ዔራቶና ማሊሢና ዓኣ ዓሲ ዓጮ ዎይሣንዳጉዲ ዶኦሬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ላንካዎ ሚዦ ሌዖንሢና ካፄ ሃኣኮኮ ዶንጎ ዖኦራፓ ፔቴ ዔኪ ዔኪ ኮናይዳ ዓርሢሳንዳ ቢቲ ዶኦሪ ዶኦሪ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ዔያታ ዬንሢ ላንካዎ ሚዦ ሌዖንሢዳ ዔካ ሃኣኮ ቢያ ካታማ ካታማ ኮናይዳ ዓርሢ ካፓንዳጉዲ ቢታንቶ ዔያቶም ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ዬይ ቡኬ ሃኣካ ጊብፄ ዓጮይዳ ሴካ ሃጊ ቤርታ ሙካንዳ ላንካዎ ሌዖ ኪሊንኮ ሉማሢና ዓጫ ባይቁዋጉዲ ካፒሢ ማዓንዳኔ፤ ያዺ ማዺንቴቴ ዓጬላ ባይሲንታፓ ዓታንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ዮሴፔኮ ማሊፃ ካኣቲንታ ካኣቲና ዎላ ማዻ ቢቶ ዓሶንታም ቢያ ኮሺ ማዒ ጴዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ካኣቲ ዬያ ዓሶም፦ «ፆኦሲ ዓያና ዮሴፔይዳ ዓኣኔ፤ ዒዛይዳፓ ባሼ ዓሲ ፔቴታዖ ኑ ዴንቃዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ዬያሮ ካኣቲ ዮሴፔም ሂዚ ጌዔኔ፦ «ሃያ ቢያ ኔኤም ፔጋሲ ጌኤሺ ዻዌሢ ፆኦሲኬ፤ ዖ ጊዳፓኣ ባሼ ዒናና ዓኣያና ዔራ ኔ ማዔሢ ዔርቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ዬያሮ ኔና ታ ዓጮይዳ ዎይሣ ዓሲ ማሂ ዶኦሪ ታኣኒ ጌሣንዳኔ፤ ዓሳ ቢያ ኔኤም ዎርቃያ ማዓንዳኔ፤ ታጊዳፓ ዓታዛ ዖኦኒያ ኔኤኮ ዑፃ ማዓንዳይ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ሃኣዛጌ፥ ሃሢ ማይ ታ ኔና ጊብፄ ዓጮ ቢያይዳ ዎይሣያ ማሂ ቢታንቶ ዒንጌኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ዬካፓ ካኣቲ ቢታንቶ ዒዛኮ ዔርዛ ማላታ ዓኣ ዢኢራሢ ፔ ኬኤላፓ ኬሲ ዮሴፔ ኬኤላ ዓኣሤኔ፤ ኮሺ ቦኦሬ ሻሎና ዹይንቴ ዓፒላኣ ማይሴኔ፤ ባቃኖይዳ ሃሣ ዎርቄፓ ኮሺንቴ ዼኤፒ ቂንቴያ ማይሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ሃሣ ጊንሣ ካኣቲ ፔ ዴዓ፥ ሳርጌሎ ዖይቶኮ ላምዓሳዞይዳ ዮሴፔ ዴይሤኔ፤ ካኣቲ ካፓ፥ ቦንቺንታ ዓሢ ዒማና ቤርታ ዓኣዺ ዓኣዺ፦ «ጎይፆ ጌሢጋፓ ሂርኪ ጌዒ ዳዲ ባዑዋቴ!» ዓሶም ጋዓኔ፤ ዮሴፔኮ ጊብፄ ዓጮይዳ ዎይሣያ ማዒፃ ዔርቴሢ ዬያይዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ካኣቲ ኬኤዛዖ፦ «ታኣኒ ካኣቲ ማዔቶዋ ጊብፄ ዓጮ ቢያ ዑፃ ኔ ጌዒባኣንቴ ዓይጎ ዓሲያ ማዖም ፔቴ ባኣዚ ማዻኒ ዳንዳዒንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ካኣቲ ዮሴፔም «ፃፕናት ፓዒና» ጋዓ ሱንሢ ጌሣዖ፥ ዓሲናቴ ጌይንታ ጲፂፓራኮ ናዎ ማቾ ማሂ ዒዛም ዒንጌኔ፤ ጲፂፓራ ዖኦኔ ጌይንታ ካታሜሎኮ ቄኤሶ ሱኡጋሢኬ፤ ዮሴፔ ዒማና ጊብፄ ዓጮ ቢያ ሃንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ዮሴፔ ካኣቲ ማኣራ ማዾ ዓርቃኣና ሌዓ ዒዛኮ ሃይሢታሚኬ፤ ዮሴፔ ካኣቲ ማኣራፓ ኬስኪ ኬስኪ ጊብፄ ዓጮ ቢያ ሃንቲ ዛጋኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ላንካዎ ሚዦ ሌዖንሢዳ ጊብፄ ዓጫ ሚርጌ ሃኣኮ ካፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ጊብፄ ዓጫ ዬንሢ ላንካዎ ሚዦ ሌዖንሢዳ ካታማ ካታማ ቡኩሶና ሃኣካ ዬያ ካታሞ ኮይሎይዳ ጎሽኪንቴ ጎዦይዳፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ዬያይዲ ዮሴፔ ባዞ ዓጫ ዓኣ ማኣሻሎጉዴ፥ ሚርጌ ሃኣኮ ቡኩሴኔ፤ ሃኣኮኮ ሚርጉሞ ማኪ ዔራኒ ዒ ማሌዖ ሃኣካ ፔቶ ሚርጌሢሮ ዬኖ ማሊፄሎ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ላንካዎ ኪሊንኮ ሉማሢ ሌዓ ጌላንዳሢኮ ቤርታ ጲፂፓራ ናኣ ዓሲናታ ላምዖ ዓቲንቄ ናይ ዮሴፔም ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ዮሴፔ ዒማና «ፆኦሲ ታና ሄሌ ሜታሢንታ ታኣኮ ዒጊኖንታ ታና ዋሊሲሴኔ» ጋዓዖ፥ ቤርታ ሾይንቴ ናዓሢኮ ሱንፆ ሚናኣሴ ጌዒ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ዬያጉዲ ሃሣ «ሜታሢ ታና ሄሌ ዓጮይዳ ፆኦሲ ታና ዳልጊሼኔ» ጋዓዖ፥ ላምዓሳ ናዓሢኮ ሱንፆ ዔፕሬኤሜ ጌይ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ዬካፓ ጊብፄ ዓጫ ላንካዎ ሚዦ ሌዓ ጋፔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ዮሴፔ ቤርታ ኬኤዜሢጉዲ ላንካዎ ኪሊንኮ ሉማሢ ሌዓ ጌሊሢ ዓርቃዛ፥ ሜሌ ዓጮይዳ ቢያ ሉማ ማዔቶዋ ጊብፄ ዓጫ ጋዓንቴ ጊዳ ቡኩሶና ሃኣኮ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ዬካፓ ኪሊንኮ ሉማሢ ጊብፄ ዓጮ ቢያ ሄላዛ ዴራ ካኣቲ ኮራ ሙካዖ፦ «ሙኡዚ ኑኡም ዒንጌ» ጌዒ ዒላቴኔ፤ ዬያሮ ካኣቲ፦ «ዮሴፔ ኮይላ ዓኣዺጋፓ ዒዚ ዒንሢም ጋዓ ባኮ ማዹዋቴ» ጌዒ ዔያቶ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ጊብፄ ዓጫ ኪሊንኮ ሉማሢ ዳልጊ ዴንዴሢሮ ዮሴፔ ኮኖ ቢያ ቡሊ ሃኣኮ ጊብፄ ዓሶም ሻንቺሲሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ዓጮ ቢያይዳ ኪሊንኮ ሉማሢ ዶዴሢሮ ዱማ ዱማ ዓጮ ዓሳ ዮሴፔይዳፓ ሃኣኮ ሻንቃኒ ጊብፄ ዓጮ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ያይቆኦቤ ጊብፄ ዓጮይዳ ሃኣኮ ዓኣሢ ዋይዛዖ ናኣቶም፦ «ዎሊ ዛጊ ዴዖይዳፓ ፔቴ ባኣዚ ማዹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ጊብፄ ዓጮይዳ ሃኣኮ ዓኣሢ ታ ዋይዜኔ፤ ኪሊንኮ ሉማሢ ኑና ኩርሱዋንቴ ዒኢካ ዓኣዺ ሃኣኮ ኑኡም ሻንቁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ዬያሮ ታጶ ዮሴፔኮ ጌርሲንሢ ሃኣኮ ሻንቃኒ ጊብፄ ዓጮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ጋዓንቴ ዮሴፔኮ ዒንዳ ሾዔ ናዓሢ፥ ቢኢኒያሜ ጌርሲንሢና ዎላ ጊብፄ ዓጮ ያይቆኦቤ ዳኪባኣሴ፤ ዓይጎሮ ጌዔቶ «ፑርታ ባኣዚ ዒዛ ሄላንዳኔ» ጌዒ ሂርጊ ዒጊጬሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ካኣናኔ ዓጮይዳ ሉማሢ ዶዴሢሮ ያይቆኦቤኮ ናኣታ ሃንጎ ሜሌ ዓሶና ዎላ ሃኣኮ ሻንቃኒ ጊብፄ ዓጮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ዮሴፔ ጊብፄ ዓጫ ካኣቲኮ ዴማ ማዒ ዎይሣያ ማዔሢሮ ኮይላ ዓኣ ዓጮ ቢያይዳፓ ሙካ ዓሶም ሃኣኮ ዒ ሻንቻኔ፤ ዬያሮ ዮሴፔኮ ጌርሲንሢ ዒዛ ቤርታ ሙካዖ ባሊቶ ሳዖ ሄሊሲ ዚጊ ቦንቾ ዔኤሊሢ ዔኤሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ዮሴፔ ፔኤኮ ጌርሲንሢ ዴንቃዖ ዔሬኔ፤ ጋዓንቴ ዔያቶ ዔሩዋያ ማሊ ዻጋና፦ «ዓንካፓ ዒንሢ ሙኬይ?» ጌዒ ዔያቶ ዖኦጬኔ። ዔያታ ማሃዖ፦ «ሃኣኮ ሻንቃኒ ካኣናኔ ዓጫፓ ኑ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ዮሴፔ ፔኤኮ ጌርሲንሢ ዔሬያ ማዔቴያ ዔያታ ዒዛ ዔሪባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ሚና ዔያቶ ዛሎ ዓውታዼ ዓውታ ዒዛም ጶቃዛ፦ «ዒንሢ ኑኡኮ ዓጪ ሙሪ ሙኬ ዓሲኬ፤ ዒንሢ ሙኬሢ ዓጮኮ ኑኡኮ ላቢፃ ዎኖ ዛሎናታቴ ሙራኒ ሙኬ ዓሲኬ» ዔያቶ ኮይላ ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ዔያታ፦ «ኑ ጎዳሢዮ! ኑኡኒ ዓጪ ሙሪ ሙኬ ዓሲቱዋሴ፤ ኑ ኔኤኮ ዓይላ ሃይካ ኑ ሙኬሢ ሃኣኮ ሻንቃኒኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","«ኑኡኒ ቢያሢ ፔቴ ዓሲ ናይኬ፤ ኑኡኒ ሃሣ ጉሙርቂንታያኬ፤ ኑኡኒ ዓጪ ሙሪ ሙኬ ዓሲቱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ዮሴፔ ዔያቶ ኮይላ፦ «ዔይዔ! ዒንሢ ሙኬሢ ዓጮኮ ላቢፃ ዎኖ ዛሎና ማዔቴያ ዛጋኒ ሙሪ ሙኬ ዓሲኬ» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ዔያታ ማሃዖ፦ «ኑኡኒ ኔኤኮ ዓይላ ካኣናኔ ዓጮይዳ ናንጋ፥ ፔቴ ዓሲስኬያ ናይ ማዔያ ኑ ታጶ ላምዖኬ፤ ጋዓንቴ ፔቴ ኑ ጌኤዛሢ ሃይቄኔ፤ ጋፒንፆ ኑኡኮ ጌኤዛሢ ሃሢ ዓዶና ዎላ ማኣራ ዓቴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ዮሴፔ ጊንሣ ሂዚ ዔያቶም ጌዔኔ፦ «ሃይሾ፥ ታ ጌዔሢጉዲ ጎኔ ዒንሢ ዓጪ ሙሪ ሙኬ ዓሲኬ! ");
INSERT INTO mdyeth_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ዓካሪ ዒንሢኮ ጎኑማ ዔርታንዳሢ ያዺኬ፤ ዒንሢኮ ጋፒንፆ ጌኤዛሢ ዒንሢ ዔኪ ሙካንዳያ ሄላንዳኣና ካኣቲ ሃይቆ! ታ ዒንሢ ሃሻዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ሃሢ ዒንሢዳፓ ፔቴ ዓኣዺ ዒንሢኮ ጌኤዛሢ ዔኪ ሙኮንጎ፤ ዒንሢ ኬኤዜ ባኮኮ ጎኑማ ዔርታንዳያ ሄላንዳኣና ሃንጎዋታ ዒንሢ ሃይካ ቱኡሲ ማርካ ዴዓንዳኔ፤ ዒንሢ ጌዔሢጉዴያ ማዒባኣያታቶ ጋዓንቴ ካኣቲ ሃይቆ! ጉቤሢ ዒንሢ ሙሪ ሙኬ ዓሲኬ» ጋዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ዔያቶ ዒ ሃይሦ ኪሊ ቱኪ ዴይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ሃይሣሳ ኬሎና ዮሴፔ ዔያቶም ሂዚ ጌዔኔ፦ «ታኣኒ ፆኦሲ ዒጊጫ ዓሲታሢሮ ፔቴ ጎይሢና ታ ዒንሢኮ ሼምፖ ዓውሳኒ ማሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ዒንሢ ጎኔ ጉሙርቂንታ ዓሲ ማዔታቴ ዒንሢዳፓ ፔቴ ሃይካ ቱኡዞ ማኣራ ዓቶንጎ፤ ሃንጎዋታ ሃኣኮ ዔኪ ዒንሢኮ ናይዺንቴ ዒጊኖም ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ዬካፓ ዒንሢኮ ጌኤዛሢ ዔኪ ታኣም ሙኩዋቴ፤ ያዺ ማዔቶ ዒንሢ ኬኤዜ ባካ ቢያ ጎኔ ማዔሢ ዔርታንዳኔ፤ ሃይቢፓኣ ዒንሢ ዓታንዳኔ» ጋዓዛ፥ ዔያታ ዬይ ጌኤዛ ኮሺኬ ጋዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ዎላ ሂዚ ጌዒ ጌስቴኔ፦ «ጎኔና ሚና ኑ ጌኤዛሢ ዑፆይዳ ኑ ማዼ ፑርቶ ባኮ ዛሎ ኮይሳ ሜቶ ሃሢ ኑ ዔኪዳ ዓኣኔ፤ ዒዚ ‹ታና ሃሹዋቴራ› ጌዒ ሜታዺ ሺኢቄያና ዒዛኮ ሺኢጲፆ ኑ ዋይዚባኣሢጉዲ ሃሢ ኑ ዑፆይዳ ሃይ ሜታሢ ሄላሢ ዬያ ዛሎናኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ሮኦቤኤሌ ዔያቶም፦ «ታ ዒንሢም ‹ናዖ ዑፃ ፑርታ ባኣዚ ሄሊሲፖቴ› ጌዒ ኬኤዛኣና ዒንሢ ጋዓንቴ ታኣም ዋይዚባኣሴ፤ ሃኣዛጉዋይ፥ ሃሢ ኑ ዒዛ ዎዼሢሮ ኮማ ኑኡም ማሂንታሢ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ዮሴፔ ዔያታ ዬያ ጋዓ ባኮ ቢያ ዋዋይዛኔ፤ ዔያታ ጋዓንቴ ዮሴፔና ጌስታሢ ዬኖ ዓጮ ሙኡጮ ዔራ ዓሲና ማዔሢሮ፥ ዔያታ ጋዓ ባኮ ዮሴፔ ዋይዛሢ ዔያታ ዔሪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ዮሴፔ ዒማና ዔያቶይዳፓ ዱማዺ ዴንዲ ዬኤኬኔ፤ ላሚ ሃሣ ዔያቶ ኮይላ ሙኪ ዔያቶና ጌስቴስካፓ ሲሞኦኔ ዔያቶ ባኣካፓ ዔኪ ቱኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ዮሴፔ ዒዛም ማዻ ዓሶ፦ «ሃንሢ ዓሶንሢም ዔያቶኮ ሱርባ ሃኣኮ ኩንሢጋፓ ሚኢሾ ዔያቶኮ ማሂ ሱርቦ ካራ ካራ ዖሺ ጌሢ፥ ጎይፆኮዋ ዔያቶም ጋላ ዒንጉዋቴ» ጌዒ ዓይሤኔ። ዓሳ ዬያ ዓይሢንቴ ጎይፆ ማዼስካፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ዮሴፔኮ ጌርሲንሢ ሻንቄ ሃኣኮ ሃሮና ጫኣኒ ዴንዶ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ጎይፆ ዔያታ ዓኣዺቤቃ ፔቴ ቤስካ ዎርቃኒ ቡኬ ቤዛ ዔያቶይዳፓ ፔቴ ፔኤኮ ሃኣኮይዳፓ ፔ ሃራሢ ሙኡዛኒ ሱርቦ ካሮ ቡላዛ ዒዚ ጪጌ ሚኢሻ ዒኢካ ዖሺንቲ ዓኣያ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ዒዚ ጌርሲንሢም፦ «ታ ሚኢሻ ጊንሣ ማዔኔ፤ ሃኣዛጉዋቴ፥ ሱርባፓ ታ ዴንቄኔ» ጌዒ ኬኤዛዛ፥ ቢያሢ ዒጊጪ ዲቃታዖ፦ «ፆኦሲ ኑጊዳ ዓይጎ ባኣዚ ዔኪ ዬዓኒ ሃያ ማዼይ?» ዎሊ ኮይላ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ዬካፓ ካኣናኔ ዓጮይዳ ዓኣ ዓዶ ያይቆኦቤ ኮራ ዔያታ ሄሊ፥ ዔያቶይዳ ማዔ ባኮ ቢያ ሂዚ ጌዒ ኬኤዜኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«ጊብፄ ዓጮ ዎይሣ ሱኡጋሢ ‹ታኣኮ ዓጮ ዒንሢ ሙራኒ ሙኬ ዓሲኬ› ጌዒ ኑ ዑፃ ጎሪንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ኑኡኒ ማሃዖ፦ ‹ኑ ጉሙርቂንታ ዓሲኬ፥ ዓጪ ሙሪ ሙኬ ዓሲቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ኑኡኒ ፔቴ ዓሲ ናይ ማዔ፥ ታጶ ላምዖ ናይኬ፤ ፔቴሢ ኑኡኮ ሃይቄኔ፤ ጋፒንፆ ጌኤዛሢ ኑኡኮ ሃሢ ዓዶና ዎላ ካኣናኔ ዓጫ ማኣራ ዓቴኔ›» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ዓሢ ኑኡም ሂዚ ጌዔኔ፦ «ዒንሢ ጉሙርቂንታ ዓሲ ማዔሢ ታ ዔራንዳሢ ታ ጋዓ፥ ፔቴ ባኣዚ ዒንሢ ማዼቶኬ፤ ዬናኣ ዒንሢዳፓ ፔቴ ሃይካ ታ ኮራ ዓቶንጎ፤ ዓቴዞንሢ ዒንሢኮ ናይዺንቴ ማኣሮ ዓሶም ሃኣኮ ዔኪ ዓጮ ማዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ዒንሢኮ ጋፒንፆ ጌኤዛሢ ዔኪ ታኣም ሙኩዋቴ፤ ያዺ ዒንሢ ማዼቴ ዒንሢ ጉሙርቂንታ ዓሲና ዓጪ ሙሪ ሙኪባኣ ዓሲታሢ ታ ዔራንዳኔ፤ ሃሢ ዒንሢኮ ሃካ ዓቴ ጌርሲያ ታ ማሂ ዳካንዳኔ፤ ሃያ ዓጮይዳኣ ዒንሢ ኮዔሢጉዲ ኮርማኒ ዳንዳዓኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ዓዶም ዔያታ ዬያ ኬኤዚ ጋፒሴሢኮ ጊንፃ ሃኣኮ ዔያታ ሱርባፓ ማሃኣና ፔቴ ፔቴሢኮ ሱርቦ ጋራ ሚኢሾ ዖሺ ጌሦናሢ ጴዼኔ፤ ዬያሮ ዔያቶንታ ዔያቶኮ ዓዶንታ ማዔ ሚኢሾ ዛጋዖ ሚርጌና ዒጊጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ዬማና ዔያቶኮ ዓዳሢ፦ «ናኣቶ ቢያሢዳፓ ታና ዒንሢ ዓይሳኒ ኮዓ? ዮሴፔ ባኣሴ፤ ሃሢ ሲሞኦኔ ዒንሢ ዓይሴኔ፤ ሃሣ ቃሲ ዒንሢ ቢኢኒያሜ ዔኪ ዓኣዻኒ ኮዓኔ፤ ታ ዓይጎ ሜቶይዳ ኬዴይ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ዬያ ዋይዛዖ ሮኦቤኤሌ ዓዶም ሂዚ ጌዔኔ፦ «ቢኢኒያሜ ማሂ ታ ዔኪ ሙኪባኣቴ ታኣኮ ላምዖ ዓቲንቆ ናኣቶንሢ ዔኪ ዎዼ፤ ታና ዓርቄ፥ ታ ዒዛ ዔኪ ኔኤም ሙካንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ያይቆኦቤ ዒማና፦ «ዓይጎ ማዔቶዋ ዒንሢና ዎላ ታ ዳካዓኬ፤ ዒዛኮ ቶይዲ ቤርታ ሃይቄኔ፤ ዓቴሢ ሃሢ ዒዛ ሌሊኬ፤ ጎይፃ ዒዛ ዑፃ ፔቴ ባኣዚ ሄሌቶ ጋርቻቶና ታና ዒንሢ ኑኡናሲ ዎዺሻንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ካኣናኔ ዓጮይዳ ኪሊንኮ ሉማሢ ሚርጌና ዶዲ ዶዲ ዓኣዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ያይቆኦቤ ማኣሮ ዓሳ ጊብፄይዳፓ ዔኪ ሙኬ ሃኣኮ ሙይ ኩርሳዛ ዔያቶኮ ዓዴ፦ «ሃሣ ጊንሣ ጊብፄ ዓኣዺ፥ ዻካ ሃኣኮ ኑኡም ሻንቁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ዪሁዳ ጋዓንቴ ዓዶም ሂዚ ጌዒ ማሄኔ፦ «ዓሢ ኑኡም ‹ዒንሢኮ ጌኤዛሢ ዒንሢ ዔኪ ሙኪባኣቶ ታ ቤርታ ዒንሢ ጴዹዋጉዲ› ጌዒ ኮሺ ላቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ዬያሮ ኑ ጌኤዚ ኑኡኒ ዔኪ ዓኣዻንዳጉዲ ኔ ጌዔቴ ዓኣዺ ኑ ሃኣኮ ሻንቂ ዓይሢፆዋ ኔኤኮ ኑ ኩንሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ኑ ጌኤዚ ኑኡና ዓኣዾም ኔ ዓይሡዋያ ማዔቶ ኑኡኒያ ዬካ ዓኣዻዓኬ፤ ዓይጎሮ ጌዔቶ ‹ዒንሢኮ ጌኤዚ ዒንሢ ዔኪ ሙኪባኣቶ ታ ቤርታ ዒንሢ ጴዹዋጉዲ› ጎዖናኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ዒስራዔኤሌ ዒማና፦ «‹ሜሌ ኑኡኮ ጌኤዚ ዓኣኔ› ጌዒ ዒንሢ ኬኤዚፆና ሃያጉዴ ሜታሢ ዓይጋ ዒንሢ ታኣም ዔኪ ሙኬይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ዔያታ፦ «ዓሢ ኑናንታ ኑ ማኣሮ ዓሶንታ ዛሎ ኮሺ ዶዲሺ ዖኦጬኔ፤ ‹ዒንሢኮ ዓዴ ሳዛና ዓኣ? ሜሌ ጌርሲ ማዓያ ዒንሢኮ ዓኣ?› ጌዒ ኑና ዖኦጬኔ፤ ኑኡኒያ ዒዛኮ ዖኦጪፆም ኮይሳሢ ማሂ ኬኤዜኔ፤ ዓካሪ ዓሢ ‹ዒንሢኮ ጌኤዛሢ ዒንሢ ዔኪ ሙካንዳጉዲ› ጋዓንዳሢ ዎዲ ኑ ዔራንዳዖ ዓቴይ?» ");
INSERT INTO mdyeth_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ዪሁዳ ዓዶም ሂዚ ጌዔኔ፦ «ናዓሢ ታና ጉሙርቂ ኑኡና ዎላ ዳኬ፤ ዑኮ ሃሢ ኑ ኬስኮም፥ ያዺ ማዔቶ ኑናንታ ኔናንታ ኑኡኮ ናኣቶንታ ኪሊንኮ ሉማሢፓ ኑ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ናዓሢ ታኣም ሃሼ፤ ዒዛይዳ ማዓ ባኣዚና ቢያ ታ ዖኦጪንታንዳኔ፤ ኮሺና ታ ዒዛ ዔኪ ሙኪባኣቴ ታ ናንጎ ዎዶ ቢያይዳ ዻቢንታ ታ ዑፃ ማዖም። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ሄኤዶ ሄሊ ኑ ናጊባኣያታቴ ላምዒ ማይንቲ ኑ ሄሊ ማዔያ ናንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ዬካፓ ዓዳሢ፥ ያይቆኦቤ፦ «ማይ ዒንሢኮ ዓኣዺፃ ዓቱዋያ ማዔቴ ዬኖ ዓጮ ዎይሣ ሱኡጋሢም ኑ ዓጫ ዓኣ ኮዦ ባካፓ ዬይያ፦ ቤሌሴ፥ ዔኤሲ፥ ዱማ ዱማ ሳውቃ ዼኤሻ፥ ኬርቤ፥ ቴሚሬ ሚፆ ዓኣፓ፥ ሌውዜ ጌይንታ ሚፆኮዋ ዓኣፖ ዒንጊ ዎዛሳኒ ዔኪ ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ሃሣ ሃያኮ ቤርታ ዒንሢኮ ሱርቦ ካራ ማዒ ሙኬ ሚኢሻ ዻቢንቲና ማዓንዳሢሮ ዬያንታ ቃሲ ሚኢሼያ ዔኪ ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ማይ ዎይታንዳይ ዒንሢኮ ጌኤዛሢያ ዔኪ ዓሢ ኮራ ዑኬና ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ቢኢኒያሜንታ ሃንጎ ዒንሢኮ ጌርሲያ ማሂ ዒንሢም ዒንጋንዳጉዲ ቢያ ባኣዚ ዳንዳዓ ፆኦሲ ዬያ ዓሢኮ ዒኖ ዒንሢም ሚጪንታያ ማሆንጎ። ታኣኒ ታ ዛሎና ናኣታፓ ዓቴቶዋ ማይ ታ ዎይታንዳይ፤ ታኣም ዓዓጎና ባኣዚዋይ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ዬያሮ ያይቆኦቤኮ ናኣታ ዒንጎንዶ ባኮንታ ሚኢሾዋ ቃሲ ዔኪ ቢኢኒያሜና ዎላ ጊብፄ ዓጮ ዴንዲ ዒኢካ ሄላዖ ዮሴፔ ቤርቶ ሺኢኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ዮሴፔ ዒዛኮ ጌኤዚ፥ ቢኢኒያሜ ሃንጎ ዒዛኮ ጌርሲንሢና ዎላ ዓኣሢ ዴንቃዖ ማኣሮይዳ ዒዛም ማዻ ዓሶ ዓይሢ ማዺሳሢ ዔኤሊ፦ «ሃንሢ ዓሶንሢ ጋሮ ዔኪ ዓኣዼ፤ ዓባ ሳዛ ማዓኣና ታኣና ዎላ ዔያታ ሙዖ ሙዓንዳሢሮ ቆልማፓ ፔቴ ሹኪ፥ ካሢ ጊኢጊሼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ማዾ ዓሶ ማዺሻሢ ዮሴፔ ዒዛም ኬኤዜሢጉዲ ዒዛኮ ጌርሲንሢ ዔኪ ጋሮ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ዮሴፔኮ ጌርሲንሢ ዮሴፔ ማኣሮ ባንሢ ዔያቶ ዔኪ ዓኣዾዋኣና ሚርጌ ዒጊጬኔ፤ ዔያታ ዒማና «ሃይካ ኑና ዔኪ ሙኮሢ ቤርታ ኑኡኮ ሱርቦ ጋሮይዳ ጴዼ ሚኢሾሮ ማዑዋዖ ዓታዓ፥ ዬያሮ ኑ ሜታኣ ኬዴኔ፤ ሃሮዋ ኑኡኮ ዔኪ ኑና ዔያቶኮ ካራሚ ማሃንዳኔ» ጌዒ ሂርጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ዮሴፔኮ ማኣሪ ጌላኒ ዔያታ ዑካዖ ዬያ ማኣሮይዳ ማዻ ዓሶ ዓይሢ ማዺሻሢም ሂዚ ጌዔኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«ኑ ጎዳሢዮ! ሃያኮ ቤርታ ሃኣኮ ሻንቃኒ ኑ ሃይካ ሙኬያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ማኣሪ ኑ ማዓኣና ጎይፃ ዎርቃኒ ኑ ቡኬ ቤስካ ሱርቦ ኑኡኮ ኑ ቡላንቴ ኑና ፔቴ ፔቴሢኮ ሚኢሾ ፓጪሱዋዖ ሱርቦ ካራ ዖሺ ዓጎናያ ኑ ዴንቄሢሮ ሃኣዛጌ፤ ሃሢ ኑ ማሂ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ሃሢያ ሃኣኮ ኑ ሻንቃንዳ ሚኢሾ ቃሲ ኑ ዓርቄኔ፤ ዒማና ኑኡኮ ሚኢሾ ማሂ ሱርቦ ጋራ ዖኦኒ ዓጌቴያ ኑ ዔሩዋሴ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ዬያ ማኣሮይዳ ማዻ ዓሶ ዓይሢ ማዺሻሢ፦ «ዬያ ዛሎና ሜታዺ ዒጊጪፖቴ፤ ዒንሢንታ ዒንሢኮ ዓዶ ፆኦሲ ዬያ ዒንሢኮ ሚኢሾ ዒንሢ ሱርባ ማሂ ዓጌያ ናንዳኔ፤ ዒንሢኮ ሚኢሾ ጋዓንቴ ታኣኒ ዔኪናኣኮኬ» ዔያቶም ጌዔኔ። ዬካፓ ዎንዴ ሃኒ ዓቴ ሲሞኦኔ ዔያቶ ኮራ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ማኣሮይዳ ማዻ ዓሶ ዓይሢ ማዺሻሢ ዮሴፔኮ ጌርሲንሢ ዮሴፔ ማኣሪ ዔኪ ጌልዛዖ ቶኮ ማስታንዳ ዋኣሢያ ዒንጊ፥ ዔያቶኮ ሃሮማኣ ሙዖ ባኣዚ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ዮሴፔና ዎላ ሙዓንዳሢ ዔያቶም ኬኤዚንቴሢሮ ዮሴፔ ሙካንዳያ ሄላንዳኣና ዒዛም ዒንጎንዶ፥ ዳኪንቴ ባኮ ዔያታ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ዮሴፔ ሙኪ ማኣሪ ጌላዛ፥ ጌርሲንሢ ዒዚ ዓኣ ቆልዖ ጌሊ ዔያታ ዒንጋኒ ዔኪ ሙኬ ባኮ ዒዛም ዒንጋዖ ሊካ ሳዖ ባንሢ ሂርኪ ጌዒ ዚጊ ቦንቾ ዔኤሊሢ ዔኤሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ዒዚ ዒማና፦ «ዒንሢ ኮሺ ሙኪያ?» ጌዒ ዖኦጬሢኮ ጊንፃ፦ «ዬይ ዒንሢ ታኣም ኬኤዜ ጋርቾ ዓዳሢ ዎዚዳይ ሃኖ ሄላንዳኣና ሳዛና ዓኣ?» ጌዒ ዔያቶ ዖኦጬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ዔያታ ማሃዖ፦ «ኔ ዓይላሢ፥ ኑ ዓዴ ሃኖ ሄላንዳኣና ሳዛና ዓኣኔ፤ ዒዚ ኮሺ ኮሺኬ» ጋዓዖ፥ ሊካ ሳዖ ባንሢ ሂርኪ ጌዒ ዒዛ ቦንቺ ዚጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ዮሴፔ ፔ ዒንዶ ናዓሢ ማዔ፥ ዒዛኮ ጌኤዚ ቢኢኒያሜ ዴንቃዖ፦ «‹ኑኡኮ ጌኤዚ ዓኣኔ› ጌዒ ዒንሢ ታኣም ኬኤዜሢ ሃይ ዒዛዳ?» ጋዓዖ፥ «ታ ናዓሢዮ፥ ፆኦሲ ኔና ዓንጆም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ዮሴፔ ፔኤኮ ጌኤዚ ዛጋዛ ዎልቃ ዒዛኮ ጌሌሢሮ ዔያቶኮ ቤርታፓ ቆልዖ ጋሮ ማዒ ጌሊ ኮሺ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ዬካፓ ዓቢፆ ማስቲ፥ ፔና ዶዲሻዖ ሙዖ ሺኢሻንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ሙዖ ሂዲ ሺኢሾናኔ፦ ዒዛም ዱማ፥ ጌርሲንሢም ዱማ፥ ዒኢካ ሙዓ ጊብፄ ዓጮ ዓሶማኣ ዱማ ጊኢጊሺንቴኔ፤ ያዺ ዱማሲ ጊኢጊሺንቴሢ ጊብፄ ዓጮ ዓሳ ዔብሬ ዓጮ ዓሶና ዎላ ሙዖ ቦሂሳያ ማሂ ፓይዳሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ዮሴፔኮ ጌርሲንሢ ቶይዲፓ ዴንዲ ጋፖ ጌኤዚ ሄላንዳኣና ዎሊ ቤቂ ዴዔኔ፤ ዔያታ ዎይቲ ዴዒ ዓኣቴያ ዔያታ ዴንቃዖ ዲቃቲ ሄርሺ፥ ዎሊ ሴካና ሃንጋና ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ዮሴፔም ዒንጎና ሙዖይዳፓ ዔኪ ዔኪ ዔያቶም ዒንጊንቴኔ፤ ቢኢኒያሜም ጋዓንቴ ሃንጎዋቶይዳፓ ዑሣ ዓኣዼ ዒንጊንቴኔ፤ ዬያይዲ ዮሴፔና ዎላ ሚሽካንዳያ ሄላንዳኣና ሙይ ዑሽኪ ዔያታ ዎዛዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ዮሴፔ ዒዛኮ ማዾ ዓሶ ዓይሢ ማዺሻ ሱኡጋሢ ሂዚ ጌዒ ዓይሤኔ፦ «ዔያቶኮ ሱርባ ዓርቃሢ ጉዴያ ኩንሤ፤ ፔቴ ፔቴ ዓሶኮ ሚኢሾዋ ሱርቦ ካራ ማሂ ጊንሣ ዓጌ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ታኣኮ ዑዦ ዑሽኮ ቢሮ ዓንጎና ኮሺንቴ ዓንጌሎ ዔኪጋፓ ዻኮ ጌኤዛሢኮ ሱርቦ ካራ ዓጌ።» ዮሴፔ ማኣራ ማዻ ዓሶኮ ሱኡጋሢ ዮሴፔ ጌዔማጉዲ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ጉቴ ዓሚ ዹማ ዓሳ ዮሴፔኮ ጌርሲንሢ ሃሮ ጫኣኒሲ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ካታማፓ ኬስኪ ዻካ ሃጊ ዔያታ ዓኣዻኣና ዮሴፔ፥ ማዾ ዓሶኮ ሱኡጋሢም፦ «ዬንሢ ዓሶንሢ ጊንፆ ዑኬና ዓኣዺ ዔያቶ ዓርቄ፤ ዔያቶ ዴንዲ ሄላዖ፦ ‹ዒንሢም ኮሺ ማዺንቴሢ ዛሎ ፑርታ ዒንሢ ማሄሢ ዓይጎሮዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ታ ጎዳኮ ዑዦ ዑሽኮ ዓንጎ ዒንሢ ዓይጎሮ ዉኡቄይ? ዬና ዓንጌላ ታ ጎዳሢ ዑሺ ዑሽካያና ዓኣሺንቴ ባኣዚ ቢያ ዒዞና ዛጊ ዔራያ ማዔሢ ዒንሢ ዔሩዋዓዳ? ሃይ ዒንሢ ፑርቲሴ ባካ ሚርጌ ዴኤሢ ባኣዚኬ› ዔያቶም ጌዔ» ጌኤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ዬያ ማኣሮይዳ ማዻ ዓሶኮ ሱኡጋሢ ዴንዲ ዮሴፔኮ ጌርሲንሢ ሄላዖ፥ ጌይንቴሢ ጎይፆ ዔያቶም ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ዔያታ ዒዛ ኮይላ፦ «ኑ ጎዳሢዮ! ዎይቲ ኔ ሂዚ ጋዓይ? ኑኡኒ ዬያጉዴ ባኣዚ ማዺባኣሢ ኑ ጫኣቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ሃያኮ ቤርታ ኑኡኮ ሱርቦ ጋራ ጴዼ ሚኢሾታዖ ኑ ኑኡኮ ዓጮ ካኣናኔይዳፓ ማሂ ዔኪ ሙኬሢ ኔ ዔራኔ፤ ሂዳዖ ሃሢ ኔ ጎዳ ማኣራፓ ሚኢሼ ማዔቶ ዎርቄ ኑ ዉኡቃንዳሢ ዓይጌንዴሮዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ኑጊዳፓ ፔቴ ዬኖ ባኬሎ ዔኪ ጴዼቶ ሃይቆንጎ፤ ዓቴዞንሢ ኑኡኒ ኔኤኮ ካራሚ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ዒዚ ዒማና፦ «ኮሺኬ፤ ዒንሢ ጌዔማ ጎይፆ ማዖንጎ፤ ጋዓንቴ ዬኖ ዓንጌሎ ዔኬ ዓሢ ሌሊ ታኣኮ ካራሚ ማዓንዳኔ፤ ዒንሢ፥ ሃንጎዋታ ጋዓንቴ ሜታ ባኣያ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ዬያሮ ዑኬና ጫኣኖ ቡሊ ኬሣዖ ፔቴ ፔቴሢ ፔኤኮ ሱርቦ ቡሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ዮሴፔኮ ማዻሢ ቶይዲስካፓ ዓርቃዖ ዴንዲ ጌኤዚሲ ሄላንዳኣና ቢያሢ ሱርቦ ጋሮ ካኣሺ ካኣሺ ዑዦ ዑሽኮ ዓንጌሎ ኮዓዖ፥ ጋፒፆይዳ ዓንጌሎ ቢኢኒያሜ ሱርቦ ጋራፓ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ዮሴፔኮ ጌርሲንሢ ዬያ ዛጌ ዎዶና ፔኤኮ ዓፒሎ ዳርዚ ዬኤካዖ ሱርቦ ቢያ ጫኣኒ፥ ጊንሣ ካታሞ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ዪሁዳና ጌርሲንሢና ዮሴፔ ባንሢ ሙኪቤቃ ዒዚ ሃጊ ማኣራ ዓኣንቴ ዴንቂ ካኣማዖ፥ ዒዛ ቤርታ ሎኦሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ዮሴፔ ዔያቶ ኮይላ፦ «ሃይ ዒንሢ ማዼ ባካ ዓይጌንዴዳይ? ታጉዴ ቦንቺንቴ ዓሲ ዱማ ዔራቶና ዓኣሺንቴ ባኣዚ ቢያ ማሊ ዛጊ ዔሪንዱዋያ ዒንሢም ማሊያ?» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ዪሁዳ ማሃዖ፦ «ዓካሪ ኑ ጎዳሢም ኑ ዓይጎ ኬኤዛንዳይ? ኑና ጌኤሻንዳ ባኣዚ ኑ ኬኤዛኒ ፔቴታዖ ዳንዳዑዋሴ፤ ዓይጎሮ ጌዔቶ ፆኦሲ ኑ ማዼ ፑርቱሞ ኔኤም ፔጋሴኔ፤ ዓካሪ ዑዦ ዑሽኮ ዓንጌላ ጴዼሢ ሌሊቱዋንቴ ቢያሢ ኑኡኒ ኔኤኮ ካራሚ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ዮሴፔ ዒማና፦ «ዬያ ታ ፔቴታዖ ማዻዓኬ፤ ዑሽኮ ዓንጌላ ጴዼ ዓሢ ሌሊ ታኣኮ ካራሚ ማዓንዳያ ኮይሳኔ፤ ዓቴዞንሢ ኮሺና ዒንሢኮ ዓዳሢ ባንሢ ዴንዳኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ዪሁዳ ዮሴፔ ባንሢ ዑኪጋፓ ሂዚ ጌዔኔ፦ «ታ ጎዳሢዮ! ሃዳራ ፔቴ ባኣዚ ኔ ዋይዛንዳጉዲ ታ ኔና ሺኢቃኔ፤ ዎዚ ኔ ካኣቲጉዲ ቦንቺንታያ ማዔቴያ ሃዳራ ታና ጎሪፖ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ታ ጎዳሢዮ! ሃያኮ ቤርታ ‹ዒንሢኮ ዓዴ ዓኣ? ሜሌ ጌኤዛቲያ ዒንሢኮ ዓኣ?› ጌዒ ኔ ኑና ዖኦጬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ኑኡኒያ ‹ጋርቼ ኑኡኮ ዓዶስኬያ ዓኣኔ፤ ሃሣ ዒዚ ጋርቻቶና ሾዔ ጌኤዛቲያ ኑኡኮ ዓኣኔ፤ ዬያ ናዓሢኮ ዒሻሢ ሃይቄኔ፤ ዒዛ ዒንዶ ናኣቶኮ ዓቴሢ ዒዛ ሌሊታሢሮ ዓዴ ዒዛ ሚርጌና ናሽካኔ› ኔኤም ኑ ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ዬካፓ ኔኤኒ፦ ‹ታ ዛጋንዳጉዲ ዔኪ ሙኩዋቴ› ኑ ኮራ ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ኑኡኒያ፦ ‹ናዓሢ ዓዶ ሃሺ ሙካኒ ዳንዳዑዋሴ፤ ሃሺ ሙኬያ ማዔቴ ዓዴ ሃይቁዋዖ ዓታዓኬ› ሂዚ ኔኤም ኑ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ኔኤኒ፦ ‹ዒንሢኮ ጌኤዛሢ ዒንሢ ዔኪ ሙኪባኣቴ ላሚ ታ ቤርታ ዒንሢ ጴዻዓኬ› ጌዒ ኑኡም ኮሺ ላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","«ዬያሮ ኑኡኒያ ኑ ዓዳሢ ባንሢ ዴንዲ ሄላዖ ኔ ኑኡም ጌዔ ባኮ ቢያ ዒዛም ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ዬካፓ ዒዚ፦ ‹ሃሣ ጊብፄ ዓጮ ዴንዲ ዻካ ሃኣኮ ኑኡም ሻንቁዋቴ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ኑኡኒያ ዒማና፦ ‹ዬካ ኑ ዓኣዻኒ ዳንዳዑዋሴ፤ ዓይጎሮ ጌዔቶ ኑ ጌኤዛሢ ኑኡና ዎላ ዓኣዺባኣቶ ዓሢ ቤርቶ ኑ ሺኢካኒ ዳንዳዑዋሴ፤ ዬካ ኑ ዓኣዻኒ ዳንዳዓሢ ኔኤኒ ኑ ጌኤዛሢ ኑኡና ዎላ ዓኣዻንዳጉዲ ዳኬቴ ሌሊኬ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ኑ ዓዴ ጊንሣ ኑኡም ሂዚ ጌዔኔ፦ ‹ታኣኮ ላኣሌላ፥ ራኣሄላ ላምዖ ዓቲንቄ ናይ ሾዔሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ዔያቶይዳፓ ፔቴሢ ሃያኮ ቤርታ ታጊዳፓ ዱማዺ ባይቄኔ፤ ዒ ባይቄሢዳፓ ሃኖ ሄላንዳኣና ታ ዒዛ ዴንቂባኣሢሮ ፑርታ ቦዖ ሙዔያ ናንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ሃሣ ዒንሢ ሃያ ዔኪ ዓኣዻዛ ፑርታ ባኣዚ ሄሌቶ፥ ታኣኮ ጋርቻቶ ዎዶይዳ ዒንሢ ታና ኑኡናሲ ዎዺሻንዳኔ።›» ");
INSERT INTO mdyeth_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","ሃሣ ዪሁዳ ኬኤዛዖ፦ «ዬያሮ ጎዳሢዮ! ናዓሢ ኑ ዔኩዋዖ ዓዶ ባንሢ ዓኣዼቶ ናዓሢ ኑ ኮራ ባኣሢ ዒ ዴንቃዖ ቤዞና ሃይቃንዳኔ፤ ዓይጎሮ ጌዔቶ ዒዛኮ ሼምፓሢ ናዖ ሼምፓሢና ዎላ ፔቴ ማዔሢሮኬ፤ ሃሣ ሚርጌ ጋርቻታፓ ዔቄያና ዒዛ ኑ ዲቃሢ ዎዺሺሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ሃሣ ጊንሣ ናዓሢ ዛሎ ታኣም ሃሼ፥ ታ ዔኪ ዒዛ ሙካንዳኔ፤ ታ ዒዛ ዔኪ ሙኪባኣቶ ታና ዖኦጬ፥ ጌዒ ታ ሙኬኔ፤ ሃሣ ‹ናዓሢ ኮሺና ታ ዔኪ ሙኪባኣቶ ታ ናንጎ ቢያይዳ ዻቢንታ ታ ዑፃ ማዖም› ጌዒ ታ ዒዛም ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«ዬያሮ ታኣኒ ናዓሢ ዛሎ ኔና፥ ታ ጎዳሢኮ ካራሚ ማዒ ሃይካ ዓታንዳኔ፤ ናዓሢ ጋዓንቴ ጌርሲንሢና ዎላ ዓኣዾንጎ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ናዓሢ ታ ዔኩዋዖ ዎይቲ ዓዶ ባንሢ ማዓንዳይ? ዬያጉዴ ዴኤሢ ሜታ ታ ዓዶ ዑፃ ሄላንቴ ታ ዛጋኒ ኮዑዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ዮሴፔ ፔኤኮ ማዻ ዓሶ ቤርታ ጊባኒ ዳንዳዒባኣሢሮ፥ ማዻ ዓሶ፦ «ቢያሢ ሃካፓ ኬስኩዋቴ!» ጌይ ዙሎ ኬሴኔ፤ ዮሴፔ ፔ ዖኑሞ ጌርሲንሢም ኬኤዛኣና ሜሌ ዓሲ ዒዛ ኮራ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ዒማና ዒዚ ዑኡዞ ፔኤሲ ዼጊዲ ጊብፄ ዓሳ ዋይዛንዳያ ሄላንዳኣና ዒላቲ ዬኤኬኔ፤ ካኣቲ ማኣሮይዳኣ ዬይ ሃይሳ ዋይዚንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ዮሴፔ ጌርሲንሢም፦ «ታኣኒ ዮሴፔኬ፤ ታ ዓዴ ሃኖ ሄላንዳኣና ሼምፔና ናንጊዳ?» ጋዓዛ፥ ጌርሲንሢ ዒ ጌዔሢ ዋይዛዖ ኮሺ ዲቃቲ ማሂ ኬኤዞንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ዮሴፔ ዔያቶ፦ «ሂንዳ ታ ባንሢ ዬዑዋቴ» ጌዔኔ፤ ዔያታ ዒዛ ባንሢ ሙካዛ፥ ሂዚ ጌዔኔ፦ «ዒንሢ ጊብፄ ዓጮም ሻንቼ፥ ታ ዒንሢኮ ጌርሲ ዮሴፔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ሚና ዬያ ዒንሢ ማዼ ባኮሮ ሃሢ፥ ‹ዓይጎሮ ኑ ዬያይዴይ?› ጌዒ ማሊ ሜታዺፖቴ፤ ዎይቲ ጌዔቴ ፆኦሲ ታና ቤርታሲ ሃካ ዳኬሢ ዓሶኮ ሼምፓሢ ታ ዓውሳንዳጉዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ሳዓ ሉማዼንቴ ላምዓሲ ሌዔ ማዔኔ፤ ዓሳ ጎሽኪ ሃኣኮ ቡኩሳኒ ዳንዳዑዋ ዶንጎ ሌዔ ሃጊ ሙካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ፆኦሲ ቤርታሲ ታና ሃይካ ዳኬሢ ዒንሢኮ ሼምፓሢ ሃያጉዴ ዲቃሣ ጎይሢና ዓውሲ፥ ሳዖይዳ ዒንሢኮ ዜርሢ ዓታንዳጉዲ ማሌሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","«ዬያሮ ሃይካ ታና ዳኬሢ ፆኦሲኬ፥ ዒንሢቱዋሴ፤ ፆኦሲ ታና ካኣቲኮ ዞራ ዓዶ፤ ጊንሣ ዒዛኮ ዓኣ ቆሎ ዑፆይዳ ጎዳ ማሂ፥ ሃሣ ጊብፄ ዓጮ ቢያ ዎይሣ ዓሲ ታና ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ሃሢ ዑኬና ታ ዓዶ ኮራ ማዒ ዓኣዺጋፓ ኔኤኮ ናኣዚ፥ ዮሴፔ ኔኤም፦ ‹ፆኦሲ ጊብፄ ዓጮ ቢያ ዎይሣ ዓሲ ታና ማሄኔ፤ ዬያሮ ኔጉዋዖ ታ ኮራ ዑኬ ሙኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ኔኤኮ ናኣቶ፥ ናኣቶኮ ናኣቶ፥ ማራቶ፥ ዋኣሮ፥ ባኣቶንታ ሜሌ ኔኤኮ ዓኣ ባኮ ቢያ ዔኪ ሙኬ፤ ታኣኮ ዑኬ ጌኤሴኤሜ ዓጮይዳ ኔ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ሃጊ ሴካ ቤርታ ዶንጎ ሉማ ሌዔ ዓቴሢሮ ኔኤና ኔ ማኣሮ ዓሶና፥ ሃሣ ቆልሞና ዒንሢ ናይዺንቱዋጉዲ ጌኤሴኤሜ ዓጮይዳ ጌሢ ታ ኔና ሙኡዛንዳኔ›» ሂዚ ጋዓኔ፥ ጎዑውዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ሃሣ ጊንሣ ዮሴፔ ኬኤዛዖ፦ «ታኣኒ ዮሴፔ ማዔሢ ዒንሢ፥ ሃሣ ኔኤኒ ታ ጌኤዚ ቢኢኒያሜያ ዛጊ ጎናሳኒ ዳንዳዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ጊብፄ ዓጮይዳ ታኣኮ ዓኣ ፑኡፖ ቦንቾና ዒንሢ ዛጌ ባኮ ቢያ ታ ዓዶም ኬኤዙዋቴ፤ ሃሣ ዑኬና ዒዛ ሃይካ ዔኪ ዬዑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ዬካፓ ዮሴፔ ፔ ጌኤዚ፥ ቢኢኒያሜኮ ባቃኖ ማሪ ዓርቂ ዬኤካዛ ቢኢኒያሜያ ዒሾ ኮንቂ ዬኤኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ዮሴፔ ጊንሣ ዓቴ ጌርሲንሢ ቢያ ሄርቂ ሄርቂ ዬኤኬኔ፤ ዬካፓ ዒዛኮ ጌርሲንሢ ዒዛና ዎላ ጌስቲሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ዮሴፔ ጌርሲንሢኮ ሙኪፃ ካኣቱሞ ማኣሮይዳ ዋይዚንታዛ፥ ካኣቲንታ ዒዛና ዎላ ማዒ ዎይሣ ዓሳ ዎዛዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ካኣቲ ዮሴፔም፦ «ኔኤኮ ጌርሲንሢ ሃሮ ጫኣኒ ካኣናኔ ማዒ ዓኣዻንዳጉዲ ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ዔያቶኮ ዓዶንታ ማኣሮ ዓሶንታ ዔያታ ዔኪ ሙኮንጎ፤ ታኣኒ ዔያቶም ጊብፄ ዓጮይዳ ኮሺ ማዔ ቤሲ ዶኦሪ ዒንጋንዳኔ፤ ጊዳ ሙኡዚያ ዔያታ ዴንቂ፥ ዎዛና ሃይካ ናንጋኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ዬያጉዲ ሃሣ ዔያታ ፔኤኮ ላኣሎንታ ናኣቶንታ ዓዶንታ ቶጊሲ ዔኪ ሙካንዳ ፓሮንታ ሳርጌላ ዖይታንታ ሃይፓ፥ ጊብፄ ዓጫፓ ዔኪ ዓኣዻንዳጉዲ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ጊብፄ ዓጮይዳ ዓኣ ኮዦ ባካ ቢያ ዔያቶም ማዔሢሮ ማኣራ ዓቴ ቆሎ ሃሺ ሙኪፆና ዖዪ ዔያታ ማሎፓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ያይቆኦቤ ናኣታ ዔያቶም ኬኤዚንቴማ ጎይፆ ማዼኔ፤ ዮሴፔያ ካኣቲ ዓይሤሢ ጎይፆ ፓራሢና ሳርጌሎ ዖይቶና፥ ሃሣ ጎይፆኮዋ ዔያቶም ጋላ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ዮሴፔ ፔቴ ፔቴሢም ላምዖ ላምዖ ላኣሚ ማኣዖንዶ ማኣዖ ዒንጋዖ፥ ቢኢኒያሜም ጋዓንቴ ዶንጎ ላኣሚ ማኣዖንዶ ማኣዖንታ ሃይሦ ፄኤታ ሹቺ ቢራኣ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ፔ ዓዶም ጊብፄ ዓጮይዳ ዓኣ ኮዦ ባኮ ታጶ ሃሬና ጫኣኒሲ ዳኬኔ፤ ሃሣ ጎይፆ ሙካዖ ሙዓንዳ ጋላኣ ሜሌ ታጶ ዒንዴ ሃሬና ሃኣኮንታ ላኣዳንታ ሜሌ ሙኡዚያ ጫኣኒ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ዬያይዲ ዒዚ ጌርሲንሢ ዳኮሮ ጋዓዖ፦ «ጎይፆይዳ ዎላ ዑራዺፖቴ» ጌዒ ዔያቶ ዞሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ዮሴፔኮ ጌርሲንሢ ጊብፄይዳፓ ዔቂ ካኣናኔ ዓጮይዳ ናንጋ ዔያቶኮ ዓዶ፥ ያይቆኦቤ ኮራ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ዒኢካ ዴንዲ ሄላዖ ዓዶም፦ «ዮሴፔ ሼምፖና ዓኣኔ፤ ሼምፔና ዓኣያ ማዒፆ ሌሊቱዋንቴ ጊብፄ ዓጮ ቢያይዳ ዎይሣ ሱኡጌ ዒ ማዔኔ» ሂዚ ጌዒ ኬኤዜኔ። ዓዴ፥ ያይቆኦቤ ጋዓንቴ ኮሺ ዲቃቴሢሮ ዔያታ ጋዓ ባኮ ጎኔኬ ጋዓኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ጋዓንቴ ዮሴፔ ዒዛም ጌዔ ባኮ ቢያ ዔያታ ኬኤዛዛ፥ ሃሣ ዒዛ ጊብፄ ዓጮ ዔኪ ሙካንዳጉዲ ዮሴፔ ዳኬ ፓራሢንታ ሳርጌሎ ዖይቶንታ ዛጋዖ ዒና ዒዛኮ ማዔም ዎዛዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ዬካፓ ያይቆኦቤ፦ «ታ ናዓሢ፥ ዮሴፔ ሼምፖና ዓኣያ ማዔሢ ታ ዔሬሢሮ ታኣኒ ሃይቃንዳሢኮ ቤርታ ዴንዲ ዒዛ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ያይቆኦቤ ፔኤኮ ዓኣ ባኮ ቢያ ዔኪ ጊብፄ ዓጮ ዓኣዺቤቃ ቤርሳቤ ሄሊ ፔ ዓዶ፥ ዪሳኣቄ ፆኦሲም ዒንጎ ባኣዚ ዒንጊ ካኣሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ዬኖ ቤዜሎይዳ ዹሚና ዒስራዔኤሌም ፆኦሲ ፔጋዺ ጴዻዖ፦ «ያይቆኦቤ! ያይቆኦቤ!» ጌዒ ዔኤላዛ፥ ዒዚ፦ «ዮ! ታ ጎዳሢዮ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ፆኦሲ ዒዛም ኬኤዛዖ፦ «ታኣኒ ፆኦሲኬ፤ ኔ ዓዶ ፆኦዛሢኬ፤ ጊብፄ ዓጮ ዓኣዺፆ ዒጊጪፖ፤ ጊብፄ ዓጮይዳ ታ ኔኤኮ ዜርፆ ዼኤፒ ዴሬ ማሃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ሃሣ ጊብፄ ዓጮ ታኣኒ ኔኤና ዎላ ዓኣዻንዳኔ፤ ዜርፆዋ ታ ኔኤኮ ሃያ ዓጮ ጊንሣ ማሂ ዔኪ ሙካንዳኔ፤ ኔኤኒ ሃይቃ ዎዶና ኔ ናኣዚ ዮሴፔ ኔና ሱኡዳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ያይቆኦቤ ቤርሳቤፓ ጊብፄ ዓጮ ዓኣዻኒ ዔቄኔ፤ ያይቆኦቤኮ ናኣታ ዔያቶኮ ዓዶ ያይቆኦቤንታ ዔያቶኮ ዻኮ ናኣቶንታ ላኣሎንታ ጊብፄ ካኣቲ ዳኬ ፓራሢና ሳርጌሎ ዖይቶናይዳ ቶጊሲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ሃሣ ቆልሞንታ ካኣናኔ ዓጮይዳ ዓኣዖ ዔያታ ዴንቄ ቆሎዋ ቢያ ዔኪ ጊብፄ ዓጮ ዓኣዼኔ፤ ዬያይዲ ያይቆኦቤ ማኣሮ ዓሶ ቢያ ዔኪ ዴንዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ዒዛና ዎላ ዓኣዼዞንሢ ዒዛኮ ዓቲንቆ ናኣቶና ዉዱሮ ናኣቶና ናኣቶኮ ናኣቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ጊብፄ ዓጮ ጌሌ ዒስራዔኤሌ ናኣቶ ዜርፆኮ ሱንፃ ሃይፓ ዴማ ፓይዲንታዞንሢኬ፤ ያይቆኦቤኮ ናኣዚ፥ ቶይዲ ሮኦቤኤሌ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ሮኦቤኤሌኮ ናኣታ፦ ሄኖኬ፥ ፓሉ፥ ሄፂሮኔና ካርሚ ጌይንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ሲሞኦኔ ናኣታ፦ ዪሙዔኤሌ፥ ያሚኔ፥ ዖሃዴ፥ ያኪኔ፥ ፆሃሬና ካኣናኔ ዓጮ ላኣሎይዳፓ ሾይንቴ ሻዑሌ ጎዖሢንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ሌዊ ናኣታ፦ ጌርሾኔ፥ ቄሃቴንታ ሜራሪንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ዪሁዳ ናኣታ፦ ዔኤሬ፥ ዖናኣኔ፥ ሼኤላ፥ ፓርሴና ዛራሄናኬ፤ ዔኤሬና ዖናኣኔና ጋዓንቴ ካኣናኔ ዓጮይዳ ዓኣዖ ሃይቄኔ። ፓርሴ ናኣታ፦ ሄፂሮኔና ሃሙሊናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ዪሳኮኦሬ ናኣታ፦ ቶላዒ፥ ፑዋ፥ ያሹቤና ሺምሮኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ዛብሎኦኔ ናኣታ፦ ሴሬዴ፥ ዔሎኔና ያሂሌዔኤሌናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ዬንሢ ዓቲንቆ ናኣቶንሢና ዉዱሮ ናዖ ዲና ጎዖዞንታ ያይቆኦቤኮ ማቻ ሊያ ሜሶፖታሚያይዳ ዓኣዖ ዒዛም ሾዔያኬ፤ ያይቆኦቤ ሊያይዳፓ ሾዔ ናኣቶና ዒዛኮ ናኣቶኮ ናኣቶናኮ ፓይዳ ዎሊ ዑፃ ሃይሢታሚ ሃይሦኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ጋኣዴ ናኣታ፦ ፄፖኔ፥ ሃጌ፥ ሹኔ፥ ዒፂቦኔ፥ ዔሪ፥ ዓሮዴና ዓርዔኤሌናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ዓሴኤሬ ናኣታ፦ ዪሚና፥ ዪሺዋ፥ ዪሺዊንታ ቤራዓንታኬ። ዔያቶኮ ጌሬላ ሴራሆ ጌይንታኔ። ቤራዓ ናኣታ ሃሣ ሄቤርና ማልኪዔኤሌናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ዬንሢ ታጶ ላምዖንሢ ላኣባ ፔኤኮ ናዎ ሊያም ዒዞ ማኣዳንዳጉዲ ዒንጌ፥ ዚሊፓ ያይቆኦቤም ሾዔ ናኣቶና ናኣቶኮ ናኣቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ያይቆኦቤ ራሄሎይዳፓ ሾዔ ናኣቶንሢ ዮሴፔና ቢኢኒያሜናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ዮሴፔ ናኣታ ሚናኣሴና ዔፕሬኤሜናኬ፤ ዬያታ ዮሴፔ ጊብፄ ዓጮይዳ ዖኦኔ ካታሞ ቄኤሶኮ ሱኡጋሢ፥ ጲፂፓራ ናዎ ዓሲናቶዳፓ ሾዔዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ቢኢኒያሜ ናኣታ፦ ቤላዔ፥ ቤኬሬ፥ ዓሽቤሌ፥ ጌራ፥ ናዒማኔ፥ ዔሂ፥ ሮሺ፥ ሙፒሜ፥ ሁፒሜና ዓሬዴናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ዬንሢ ታጶ ዖይዶንሢ ያይቆኦቤ ፔኤኮ ማቾ፥ ራሄሎይዳፓ ሾዔ ናኣቶና ናኣቶኮ ናኣቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ዳኣኔ ናኣዚ፦ ሁሺሜኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ኒፕታኣሌኤሜ ናኣታ፦ ያሂፂዔኤሌ፥ ጉኒ፥ ዬፄሬና ሺሌሜናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ዬንሢ ላንካዎንሢ ራሄሎኮ ዓዴ፥ ላኣባ ዒዞም ማዻንዳጉዲ ዒንጌ ባኣላይዳፓ ሾይንቴ ያይቆኦቤ ናኣቶና ናኣቶኮ ናኣቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ያይቆኦቤና ዎላ ጊብፄ ዓጮ ዓኣዼ ዒዛኮ ዜርፃ ናኣዚንሢ ላኣሎ ሃሾዛ ፓይዳ ላሂታሚ ላሆኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ዮሴፔ ጊብፄ ዓጫ ዓኣዖ ሾዔ ላምዖ ዓቲንቆ ናኣቶንሢ ጊዳ ቃሲ ፓይዶዛ ያይቆኦቤኮ ጊብፄ ጌሌ ዜርፃ ዎሊ ዑፃ ላንካይታሚኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ጌኤሴኤሜይዳ ካኣሚ ዒዛ ጎይሣ ዔካንዳጉዲ ያይቆኦቤ ቤርታሲ ዮሴፔ ኮራ ዪሁዳ ዳኬኔ፤ ሙኪ ዔያታ ጌኤሴኤሜ ሄላዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ዮሴፔ ዓዶና ካኣማኒ ሳርጌሎ ዖይቶ ቶጊ ዒኢካ ሙኬኔ፤ ዮሴፔ ዒኢካ ዓዶና ካኣማዖ ዓዶኮ ባቃኖ ማሪ ዓርቂ ሚርጌ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ዒስራዔኤሌ ዮሴፔም፦ «ኔኤኒ ሼምፖና ዓኣያ ማዔሢ ታኣኒ ታ ዓኣፒና ዛጊ ጎናሴሢሮ ማይ ታ ሃይቄቶዋ ሜታ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ዬካፓ ዮሴፔ ፔኤኮ ጌርሲንሢንታ ሃንጎ ዓዶ ማኣሮ ዓሶንታም ሂዚ ጌዔኔ፦ «ታኣኒ ካኣቲ ኮራ ዓኣዺጋፓ ‹ካኣናኔ ዓጮይዳ ናንጋ ታኣኮ ጌርሲንሢና ታ ዓዶ ማኣሮ ዓሶና ታ ኮራ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ዔያታ ቆልሞ ቆሊ ዔራ ቆልሞ ሄንቃ ዓሲኬ፤ ፔኤኮ ዔያታ ማራታ፥ ዋኣራ፥ ባኣቶንታ ዓኣ ባኮዋ ቢያ ዔኪ ሙኬኔ› ጌዒ ታ ኬኤዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ዒንሢ ካኣቲ ዔኤሊሲ ‹ዒንሢ ማዺ ናንጋ ማዻ ዒንሢኮ ዓይጎዳይ?› ጌዒ ዖኦጬቶ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‹ኑኡኒ ኑኡኮ ቤርታኣ ዓዶንሢ ጎይፆ ናኣቶይዳፓ ዓርቃዖ ኑ ማዺ ናንጋሢ ቆልሞ ቆሊሢኬ› ጌዒ ኬኤዙዋቴ፤ ቆልሞ ቆላ ዓሲ ጊብፄ ዓጮ ዓሶ ማሊፆና ላኣፓ ዓሲታሢሮ ያዺ ጌዒ ኬኤዚፆና ‹ጌኤሴኤሜይዳ ናንጉዋቴ› ጋዓ ዓይሥሢ ዒንሢ ዴንቃንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ዒማና ዮሴፔ ካኣቲ ኮራ ዓኣዻዖ፦ «ታ ዓዶና ታኣኮ ጌርሲንሢና ፔኤኮ ማራቶንታ ዋኣሮንታ ባኣቶንታ፥ ሃሣ ዔያቶኮ ዓኣ ባኮ ቢያ ዔኪ ካኣናኔ ዓጮይዳፓ ሃይካ ሙኬኔ፤ ሃሢ ዔያታ ዓኣሢ ጌኤሴኤሜይዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ሃሣ ዒዚ ዒዛኮ ጌርሲንሢዳፓ ዶንጎ ዶኦሪ ዔኪ ካኣቲ ቤርቶ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ካኣቲ ዮሴፔኮ ጌርሲንሢ ኮራ፦ «ዒንሢ ማዺ ናንጋ ማዻ ዒንሢኮ ዓይጎዳይ?» ጌዒ ዖኦጬኔ። ዔያታ ማሃዖ፦ «ኑኡኒ ኔኤኮ ዓይላ፥ ቆልሞ ቆሊ ናንጋያኬ፤ ሃያኮ ቤርታ ኑኡኮ ዓዶንሢያ ማዺ ናንጋሢ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ካኣናኔ ዓጮይዳ ሉማ ኮሺ ዶዴያታሢሮ ቆልሞኮ ኑኡኮ ማኣቲ ባይቄም ዻካ ዎዴ ሃኖ ዓጬሎይዳ ኑኡኒ ናንጋኒ ሙኬኔ፤ ዬያሮ ኑና ኔኤኮ ዓይሎ ጌኤሴኤሜይዳ ናንጊሼቴራ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ካኣቲ ዒማና ዮሴፔም ሂዚ ጌዔኔ፦ «ኔ ዓዶንታ ኔ ጌርሲንሢንታ ሙኬያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ማይ ዓይጌ ዓኣዖ ጊብፄ ዓጫ ቢያ ኔኤሮኬ፤ ዬያሮ ኔ ዓዶንታ ኔ ጌርሲንሢንታ ኮሺ ማዔ ጌኤሴኤሜ ዓጬሎይዳ ናንጋንዳጉዲ ዴይሤቴራ። ዔያቶ ባኣኮይዳ ዱማ ዔራቶና ዓኣ ዓሲ ዓኣያታቶ፥ ታ ቆልሞኮ ዋኣና ማዒ ዛጋንዳጉዲ ዔያቶም ዒንጌ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ዬካፓ ዮሴፔ ፔኤኮ ዓዶ፥ ያይቆኦቤ ካኣቲ ቤርቶ ሺኢሼኔ፤ ያይቆኦቤ ዒማና ካኣቲ ዓንጄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ካኣቲ ያይቆኦቤ ኮራ፦ «ኔኤኮ ሌዓ ዋኣዼዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ያይቆኦቤ ማሃዖ፦ «ሴካ ሃንጋ ጌዒ ታኣኒ ሾኦቹሞና ናንጌ ሌዓ ፄኤታና ሃይሢታሚናኬ። ዬይ ሌዓ፥ ቤርታ ታኣኮ ዓዶንሢ ሴካ ሃንጋ ጌዒ ሾኦቹሞና ሃንቴ ሌዖይዳፓ ኮሺ ዻካታዖ ሜታ ሚርጌ ሌዔኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ዬካፓ ሃሣ ያይቆኦቤ ካኣቲ ዓንጃዖ ሳራሢ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ዬያይዲ ዮሴፔ ፔኤኮ ዓዶና ጌርሲንሢና ጊብፄ ዓጮይዳ ዴይሤኔ፤ ካኣቲ ዓይሤ ጎይፆ ጊብፄ ዓጮይዳ ኮሺ ማዔ፥ ራምሴ ጌይንታ ካታሞ ኮይላ ዓኣ ቤዜሎ ፔ ዓዶንሢም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ዮሴፔ ዬኖ ዎዶና ዓዶና ጌርሲንሢናም ዔያቶኮ ናኣቶ ሚርጉሞ ጎይፆጉዴያ ዛጊ ጊዳንዳ ሃኣኮ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ሉማሢ ኮሺ ዶዲ ዶዲ ዓኣዼሢሮ ዓንካፓ ማዔቶዋ ሃኣኮ ዴንቃኒ ዳንዳዒንቲባኣሴ፤ ዬያሮ ጊብፄ ዓጮና ካኣናኔ ዓጮናይዳ ዓኣ ዴራ ሉማሢና ኮሺ ላቤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ጊብፄ ዓጮና ካኣናኔ ዓጮና ዴራ ዮሴፔ ኮራፓ ሙኪ ሃኣኮ ሻንቃ ሚኢሾ ዒ ቡኩሲ ካኣቲኮ ሚኢሾ ጌሦ ኬኤፃ ጌሣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ዬያይዲ ጊብፄ ዓጮ ዓሶና ካኣናኔ ዓጮ ዓሶና ሃኣኮ ሻንቂ ሻንቂ ፔኤኮ ሚኢሾ ጋፒሴሢሮ፥ ጊብፄ ዓጮ ዓሳ ቡኪንቲ ዮሴፔ ኮራ ሙካዖ፦ «ኑኡኒ ሙዓንዳ ሙኡዚ ኑኡም ዒንጌ፤ ሚኢሾ ኑኡኮ ኑኡኒ ጋፒሴያታሢሮ ሉማሢና ኑ ኩዴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ዮሴፔ ዔያቶም፦ «ሚኢሻ ዒንሢኮ ጋፔያታቴ ዒንሢኮ ቆልሞ ዒንሢ ዔኪ ሙካዛ፥ ቆልሞ ዛሎ ሃኣኮ ታ ዒንሢም ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ዬያሮ ዔያታ ፔኤኮ ቆልሞ ዮሴፔ ኮራ ዔኪ ሙኬኔ፤ ዒዚ ዔያቶም ፓራሢና ሃሮና ዛሎ፥ ማራቶና ዋኣሮና ባኣቶና ዛሎ ሃኣኮ ዒንጌኔ፤ ዬኖ ሌዖ ቢያ ዔያቶኮ ቆልሞ ዔኪ ዔኪ ሃኣኮ ዒዚ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ሄሊሴ ሌዖ ዒዛ ኮራ ዔያታ ሙካዖ፦ «ኑ ጎዳሢዮ! ኔኤም ኑኡኒ ዓኣቻ ባኣዚ ባኣሴ፤ ሚኢሻ ኑኡኮ ቢያ ጋፔኔ፤ ቆልሞዋ ኑኡኮ ኔኤም ኑ ዒንጌኔ፤ ዓካሪ ኑ ጎዳሢም ኑኡኒ ዒንጋንዳ ባኣዚ ኑ ዑፆና ኑ ሳዖናይዳፓ ዓታዛ ፔቴታዖ ዓኣ ባኣዚ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ፔቴ ባኣዚ ኑኡም ኔ ማዹዋዖ ኑኡኒ ሃይቃንዳያ ሄላንዳኣና ዚቲ ጌይ ኑና ዛጊፖ፤ ጎዣኣ ኑኡኮ ሃሾና ካይዚ ማዓንዳጉዲ ማሂፖ፤ ኑናንታ ኑ ሳዖንታ ሻንቂ ዔኪ ኑኡም ሃኣኮ ዒንጌ፤ ኑኡኒያ ካኣቲኮ ካራሚ ማዓንዳኔ፤ ሳዓ ኑኡሲ ዒዛሮ ማዖም፤ ሙኡዚ ኑ ሙዒ ሼምፖና ናንጋንዳጉዲ ሃኣኮ ኑኡም ዒንጌ፤ ሃሣ ሳዖ ኑ ዜርቂ ጎሽካንዳጉዲ ዜርሢያ ኑኡም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ዮሴፔ ጊብፄይዳ ዓኣ ሳዖ ቢያ ካኣቲም ሻንቄኔ፤ ሉማሢ ኮሺ ዶዴሢሮ ጊብፄ ዓጮ ዓሳ ቢያ ናሽኪባኣዖ ፔ ሳዖ ሻንቻኒ ዳንዳዔኔ፤ ያዺ ማዒፆና ሳዓ ቢያ ካኣቶሮ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ዮሴፔ ጊብፄ ዓጮ ዓሶ ቢያ ካራፓ ዴንዲ ካሮ ሄላንዳኣና ካኣቲኮ ካራሚ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ዮሴፔ ዒማና ቄኤሶ ሳዖ ሌሊ ሻንቂባኣሴ፤ ዓይጎሮ ጌዔቶ ቄኤሳ ዬኖ ዎዶና ካኣቲ ኮራፓ ዔካ ባኣዚ ዓኣያ ማዔሢሮ ፔኤኮ ሳዖ ሻንቺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ዮሴፔ ዴሮም ሂዚ ጌዔኔ፦ «ማይ ዓካሪ ዒንሢና ዒንሢኮ ሳዖና ካኣቲም ታ ሻንቄሢሮ ዜርሢ ዔኪጋፓ ዒንሢኮ ሳዖይዳ ዜርቁዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ጋዓንቴ ሃኣካ ቡኩሲንታ ዎዶና ካፄ ሃኣኮኮ ዶንጎ ዖኦራፓ ፔቴማ ዔኪ ካኣቲም ዒንሢ ዒንጋኒ ኮይሳኔ፤ ዓቴ ዖይዶ ዖኦራ ጋዓንቴ ዒንሢ ሳዖኮ ዜርሢ፤ ሃሣ ዒንሢንታ ዒንሢ ናኣቶንታ ማኣሮ ዓሶ ቢያሢናኮ ሙኡዚ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ዴራ ዒማና፦ «ኑ ጎዳሢዮ! ኮሺ ባኣዚ ኑኡም ኔ ማዺ፥ ሼምፖ ኑኡኮ ኔ ዓውሴሢሮ ቢያሢ ኑኡኒ ካኣቲኮ ካራሚ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ዬያይዲ ዮሴፔ ካፄ ሃኣኮ ቢያይዳፓ ዶንጎ ዖኦራኮ ፔቴማ ካኣቲም ዒንጊንታንዳጉዲ ጊብፄ ዓጮ ሳዖ ዛሎ ዎጌ ኬሴኔ፤ ዬይ ዎጋ ሃኖ ሄላንዳኣና ማዻኔ፤ ካኣቲሮ ማዒባኣ ሳዓ ቄኤሶ ሳዖ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ዒስራዔኤሌ ዓሳ ጊብፄ ዓጫ ጌኤሴኤሜይዳ ናንጌኔ፤ ዒኢካ ዔያታ ሚርጌ ቆሎ ዴንቂ ሚርጌ ናይያ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ያይቆኦቤ ታጶ ላንካይ ሌዔ ጊብፄ ዓጮይዳ ናንጌኔ፤ ሌዓ ዒዛኮ ዒማና ፄኤታና ዖይዲታሚ ላንካይ ሌዔ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ዒስራዔኤሌ ሃይቃንዳ ዎዳ ዑካዛ፥ ፔኤኮ ናኣዚ ዮሴፔ ዔኤሊሳዖ፦ «ታኣኒ ኔኤም ቦንቺንቴ ዓሲ ማዒ ጴዼቶ፥ ታኣኒ ሃይቃዛ ሃካ ጊብፄ ዓጮይዳ ታና ኔ ዱኡኪንዱዋኣያ ማዒፆ ኩጮ ኔኤኮ ታ ጉባዞ ባኣካ ጌሢ ጫኣቄ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ታ ዓዶንሢ ዱኡቴ ቤዛ ታ ዱኡታኒ ኮዓያታሢሮ ታኣኒ ሃይቃዛ ጊብፄ ዓጫፓ ታና ዔኪ ዓኣዺ ዔያታ ዱኡቴ ቤዛ ዱኡኬ» ጌዔኔ። ዮሴፔ ዒማና፦ «ዔኤዔ፥ ኔ ጌዔ ጎይፆ ታ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ዒስራዔኤሌ፦ «ዬያ ኔ ማዻንዳሢ ታኣም ጫኣቄ» ጌዔኔ። ዮሴፔ ጎኔ ማዻንዳያ ማዒፆ ጫኣቂ ዔርዜኔ፤ ዬካፓ ዒስራዔኤሌ ላሄ ቤዛ ዓኣዖ ፆኦሲም ዚጊ ጋላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ዻካ ዎዴ ዴዔስካፓ ዮሴፔም «ዓዴ ኔኤኮ ሃርጊንቴኔ» ጋዓ ኪኢታ ሙኬኔ፤ ዬያሮ ዮሴፔ ፔኤኮ ናኣቶ ሚናኣሴና ዔፕሬኤሜና ዔኪ ዓዶ፥ ያይቆኦቤ ዖኦጫኒ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ዒዛኮ ናኣዚ፥ ዮሴፔ ዒዛ ዖኦጫኒ ሙኬሢ ዒስራዔኤሌ ዋይዛዖ ሻኣላፓ ሻኣሻቲ ዔቂ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ያይቆኦቤ ዮሴፔም «ቢያ ባኮ ዳንዳዓ ፆኦሲ ካኣናኔ ዓጫ ሎኦዛ ጎዖ ቤዛ ታኣም ፔጋዺ ጴዺ ታና ዓንጄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‹ዜርፆ ታ ኔኤኮ ሚርጊሻንዳኔ፤ ዜርፃ ኔኤኮ ሚርጌ ዴሬ ማዓንዳኔ፤ ሃኖ ሳዔሎ ኔ ጊንፃፓ ሙካንዳ፥ ኔኤኮ ዜርፆም ናንጊና ዔያቶሮ ማሂ ታ ዒንጋንዳኔ› ታኣም ጌዔኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","7","ያይቆኦቤ ቃሳዖ ዮሴፔም፦ «ታ ናዓሦ፥ ዮሴፔ! ታኣኒ ሃይካ ጊብፄ ዓጮ ሙኩዋንቴ ኔኤኮ ሾይንቴ ላምዖ ናኣቶንሢ ታኣሮኬ፤ ሮኦቤኤሌና ሲሞኦኔናጉዲ ኔኤኮ ዔፕሬኤሜና ሚናኣሴና ማይ ታ ናይኬ፤ ሃያ ታ ማዻሢ ኔ ዒንዶ ዛሎሮኬ። ሃካፓ ሴካ ሜሌ ናይ ኔኤም ሾይንቴቶ ኔኤሮኬ፤ ማዔቶዋ ዔያታ ዓጪ ዴንቃንዳሢ ዔፕሬኤሜና ሚናኣሴ ሱንፆና ዔኤሊንቲኬ። ሜሶፖታሚያይዳፓ ታኣኒ ማዓዖ ካኣናኔ ዓጫ ዓኣ ዔፕራታ ሃጊ ታ ዑካኣና ኔ ዒንዳ ራኣሄላ ሃይቃዛ፥ ዒዞ ታኣኒ ዔፕራታ ዴንዳ ጎይፆ ዓጫ ዱኡኬኔ» ጌዒ ኬኤዜኔ። ዬና ዔፕራታ ጌይንታዛ ሃኖ ቤኤቴሌሄሜ ጎዖ ቤዜሎኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ዒስራዔኤሌ ዮሴፔኮ ናኣቶ ዴንቃዖ፦ «ሃንሢ ናኣቶንሢ ዖናንሢዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ዮሴፔ፦ «ሃንሢ ሃኖ ዓጫ ታኣኒ ዓኣንቴ ፆኦሲ ታኣም ዒንጌ ናኣቶንሢኬ» ጌዒ ዓዶም ኬኤዜኔ። ዬካፓ ዒስራዔኤሌ፦ «ሂንዳ ታ ዔያቶ ዓንጆም ታ ባንሢ ዔኪ ዬዔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ዒስራዔኤሌ ጋርቺ ሚርጌ ላቤያ ማዔሢሮ ዓኣፓ ዒዛኮ ኮሺ ዴንቁዋሴ፤ ዬያሮ ዮሴፔ ፔኤኮ ናኣቶ ዒዛ ባንሢ ዶጪሴኔ፤ ዒስራዔኤሌ ዔያቶ ኮንቃዖ ሄርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ዬካፓ ዮሴፔ ኮራ፦ «ኔና ታ ላሚ ዛጋንዳኔ ጌዒ ማሊባኣሴ፤ ፆኦሲ ጋዓንቴ ኔና ሌሊቱዋንቴ ናኣቶዋ ኔኤኮ ታና ዻዌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ዮሴፔ ናኣቶ ፔኤኮ ዒስራዔኤሌ ጉኡዦ ኮራፓ ሺኢሺ፥ ሳዖ ባንሢ ሂርኪ ጌዒ ዚጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ዮሴፔ ዒዛኮ ላምዖ ናኣቶ ዔኪ ሙካዖ ዔፕሬኤሜ ፔኤኮ ሚዛቆ ዛላ ዒስራዔኤሌኮ ሻውሎ ዛላ፥ ሚናኣሴ ፔኤኮ ሻውሎ ዛላ ዒስራዔኤሌኮ ጋዓንቴ ሚዛቆ ዛላ ማሂ ዔቂሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ዒስራዔኤሌ ጋዓንቴ ኩጮ ፔኤሲ ሶንጌ ሃንጌ ጋኣዲ ሚዛቆ ኩጮ ጌኤዛሢ ዔፕሬኤሜ ቶኦካ፥ ሻውሎ ኩጮ ቶይዳሢ ሚናኣሴ ቶኦካ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ዬካፓ ዒስራዔኤሌ ሂዚ ጌዒ ዮሴፔ ዓንጄኔ፦ «ታ ዓዶንሢ፥ ዓብራሃሜንታ ዪሳኣቄንታ ጎይፆ ዒዛሲ ሃንቲ ዒዛም ማዼያ፤ ሃሣ ታናኣ ሃኖ ሄላንዳኣና ሼምፔና ዓኣያ ማሂ ሄንቄ ፆኦዛሢ ሃንሢ ናኣቶ ኔኤም ዓንጆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ታና ፑርታ ባኣዚዳፓ ቢያ ካፔ ፆኦሲኮ ኪኢታንቻሢ ዔያቶዋ ካፖንጎ። ታ ሱንፆንታ ታ ዓዶንሢ ዓብራሃሜንታ ዪሳኣቄንታ ሱንፃ ሃንሢ ናኣቶ ዛሎና ዋሊንቱዋያ ማዖም፤ ዜርፃኣ ዔያቶኮ ሳዖይዳ ሚርጎንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ዓዴ ሚዛቆ ኩጮ ዔፕሬኤሜ ቶኦካ ጌሤሢ ዴንቃዖ ዮሴፔ ዒኔ ዱጴኔ፤ ዬያሮ ዔፕሬኤሜ ቶኦካፓ ዓዶኮ ኩጮ ዔኪ ሚናኣሴ ቶኦካ ጌሣኒ ኩጮ ዓዶኮ ዓርቃዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","«ዓዴ! ያዺቱዋሴ፤ ቶይዳሢ ሃያታሢሮ ሚዛቆ ኩጮ ሃያይዳ ጌሤ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ዓዴ ጋዓንቴ፦ «ታ ናዓሢዮ ታ ዔሬኔ፥ ዔሬዖ ታ ዎኦታኔ፤ ሚናኣሴ ዜርፃኣ ዼኤፒ ዴሬ ማዓንዳኔ፤ ማዔቶዋ ዒዛኮ ጌኤዚ ዒዛሲዳፓ ባሼ ማዓንዳኔ፤ ዜርፃኣ ዒዛኮ ዼኤፒ ዼኤፒ ዴሬ ማዓንዳኔ» ጋዓዖ፥ ኩጮ ፔኤሲ ሺኢሾ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ዒዞ ኬሎ ዒስራዔኤሌ ዓንጃዖ፦ «ዒስራዔኤሌ ዓሳ ሃጊ ዓንጆ ዓንጃ ዎዶና ዒንሢ ሱንፆ ጶቂሢ ‹ፆኦሲ ዒንሢ ዔፕሬኤሜና ሚናኣሴናጉዲ ማሆንጎ› ጋዓንዳኔ» ሂዚ ጌዒ ዓንጄኔ። ዒስራዔኤሌ ዬያይዲ ዔፕሬኤሜ ሚናኣሴይዳፓ ቤርታሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ዬካፓ ዒስራዔኤሌ ዮሴፔም፦ «ሃይሾ ታ ሃይቃኒ ዑኬኔ፤ ጋዓንቴ ፆኦሲ ዒንሢና ዎላ ማዔሢሮ ቤርታ ዒንሢኮ ዓዶንሢ ሳዖ ዒንሢ ዒዚ ዔኪ ማሃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ዓሞራ ዓሶይዳፓ ታኣኒ ጬንቾ ዓፓሮና ዓኣዞና ዖሊ ዔኬ ሴኬሜ፥ ኔ ጌርሲንሢና ዎላ ጊሽቲ ኔኤኒ ዴንቃንዳ ዛሎይዳፓ ዑሣ ዓኣዼ ኔኤም ታ ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ያይቆኦቤ ፔኤኮ ናኣቶ ዔኤላዖ ሂዚ ጌዔኔ፦ «ቢያሢ ሙኪ ቡኪንቱዋቴ፥ ታ ዒንሢ ሃጊ ሄላንዳ ባኣዚ ኬኤዛንዳኔ፤» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«ዒንሢ፥ ያይቆኦቤ ናኣታ ፔቱሞና ሃኒ ዋይዙዋቴ፤ ዓዳሢ፥ ዒስራዔኤሌ ዒንሢም ኬኤዛ ባኮ ኮሺ ዋይዙዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«ሮኦቤኤሌ፦ ኔኤኒ ታ ኔና ዼጋቶ ዎልቄና ዓኣዖ ሾዔ ታኣኮ ኔ ናኣዚ ቶይዲኬ። ታኣኮ ናኣቶይዳፓ ቢያ ቦንቺንታያና ዎልቄና ኮሺ ባሼሢ ኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ያኣዼ ማዔቶዋ ኔኤኒ ኩሜ ዲጲጉዲታሢሮ ቢያሢኮ ዑፃ ማዒ ዎይሣያ ማዒሢ ኔኤም ኮይሱዋሴ፤ ዎይቲ ጌዔቴ ታና፥ ዓዶኮ ማዾ ማዻ ላኣሌሎ ኔ ዓርቂ ዓርሶዋ ኔ ታኣኮ ዒኢሴኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«ሲሞኦኔና ሌዊና ዎሊኮ ጌርሲንሢኬ፤ ፑርታ ማዾ ማዻኒ ዔያታ ዖልዚ ዓንጋሞ ዔካያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ዔያታ ፔ ዻጎና ሚርጌ ዓቲንቄ ዎዼኔ፤ ጌማቶ ዔያታ ሚኢጪ ዓማላኒ ቲቂ ዎቢሴኔ፤ ዔያቶ ዞሮይዳ ታኣኒ ጌላዓ፤ ዔያቶኮ ቡኪንቶይዳኣ ታ ጴዻዓ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ዼኤፖ ዔያቶኮ ዒጊቻ ዻጋ ዼኤፖ ጎሪንታ ዔያቶኮ ጋዳንቂንቴያ ማዖንጎ። ታኣኒያ ዔያቶ ዒስራዔኤሌ ዓጮይዳ ቢያ ዜርቃንዳኔ፤ ዴሮ ባኣኮይዳኣ ታ ዔያቶ ላኣላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«ዪሁዳ! ኔና ኔ ጌርሲንሢ ጋላታያ ማዓንዳኔ፤ ኔ ሞርኮ ኔ ባሻያ ማዓንዳኔ፤ ኔኤኮ ጌርሲንሢ ሂርኪ ጌዒ ቦንቾ ዔኤሊሢ ኔና ዔኤላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ዪሁዳ፥ ሃጊ ዲጫ ዓዴ ዞቢኬ፤ ሙዖንዶ ባኮ ኬሚ ጌሊ ዎርቃ ዔቶ ባንሢ ማዓንዳኔ፤ ሃሣ ዒጊጩዋዖ ፔና ሃሺ ላሃንዳኔ፤ ዒዛ ዓጊሢ ጴቻኒ ጫርቃንዳያኣ ጴዻዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ዴራ ቢያ ዒዛም ዓይሢንታያ ማዓንዳኔ፤ ናንጊና ዔያቶይዳ ካኣታዻንዳሢ ሙካንዳያ ሄላንዳኣና ካኣቱሞ ቢታንቶ ዪሁዳ ማኣራፓ ኬስካዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ሃሮ ፔኤኮ ዒ ዎይኖ ሚፆኮ ፃጶይዳ ሃሮ ናዖ ዎይኖኮ ባልጌ ኮዦ ካኣፖይዳ ቱካንዳኔ፤ ዓፒሎዋ ፔኤኮ ዒ ዎይኖ ዑዦና ዒዚ ጊልዲማ ጊልዲሞዋ ሱጉሢጉዲ ዞቃ ዎይኖፓ ጩኡጶና ዑዦና ማስካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ዓኣፓኣ ዒዛኮ ዎይኖ ዑዦይዳፓ ባሼ ዞቃንዳኔ፤ ዓጫ ዒዛኮ ዲኢቂዳፓ ዑሣ ዓኣዼ ቦኦራንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«ዛብሎኦኔ፥ ባዚ ዓቺዳ ናንጋንዳኔ፤ ዒዛኮ ባዞ ዓጮይዳ ዓኣ ቤዛ ዋኣሢ ካኣሚሌ ሙኪ ዔቃ ቤሲ ማዓንዳኔ፤ ዒዚ ናንጋንዳ ዓጮኮ ዛጳ ዴንዲ ሲዶና ሄላንዳኣናኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«ዪሳኮኦሬ፥ ጫኣኖ ባኣካ ላሂ ሺራ ዶዲ ሃሬጉዴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ጋዓንቴ ዒዚ ሃውሻንዳ ቤዞና ሳዖና ኮሺ ዎዛሳያ ማዔሢ ዴንቃዖ ጫኣኖ ዔካኒ ጌኤቶ ፔኤሲ ሂርኪዳንዳኔ፤ ካራሚጉዲ ዶዲ፥ ዎልቄ ማዾዋ ማዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ዳኣኔ፦ ዒስራዔኤሌ ፃጳፓ ፔቴሢ ማዒ ፔ ቶኦኮኮ ጌስቲ ዎጋያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ዳኣኔ ጎይሢ ዓቺዳ ዓኣ ሾኦሺ ማዓንዳኔ፤ ባቁሎ ቶጊ ዓኣዻሢ ባቁሎይዳፓ ሎንሣኒ ጎይሢ ፁኡቤ ካራይዳ ካቲ ባቁሎኮ ሹቁሎ ዻዓ ዶርባ ሾኦሺ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«ናንጊና ናንጋ ጎዳሢዮ! ታ ኔኤኮ ዻቂሺፆ ካፓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«ጋኣዴ፦ ቡራ ዓሲ ኮሺ ሜታሳንዳኔ፤ ዒዚያ ኮጲሲ ዓኣዺ ዔያቶ ዳውሳንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«ዓሴኤሬ፦ ሳዖይዳፓ ሚርጌ ሃኣኮ ዴንቃንዳኔ፤ ካኣቶም ዒንጎንዶጉዴ ቃራ ካሣኣ ካሣንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«ኒፕታኣሌኤሜ፦ ሜታባኣያ ሃንቲ ሃንቲ ናንጋ ሚርጌ ሚዛጲ ናይ ሾዓ ጌንዖጉዴያ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«ዮሴፔ፦ ዓልቃ ዋኣሢ ዓሽካ ቱኮናያ ባልጊ ዴንዳ ካኣፓ ኮጬይዳ ባልጊ ዴንዲ ዓኣፓ ሚሢጉዲ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ዒዛኮ ሞርካ ዒዛ ዳውሲ ዳውሲ ሚርጌና ሜታሳንዳኔ፤ ሂኢሺናኣ ዔያታ ዒዛ ዱካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ጋዓንቴ ሚርጌ ዶዲ ማዔ ያይቆኦቤ ፆኦዛሢ ዎልቆና ዒስራዔኤሌ ሄንቃሢና ካፓሢናኮ ዶዱሞና ዒዛኮ ዓኣዛ ባሼ ዶዲ ማዓንዳኔ፤ ዎልቃኣ ዒዛኮ ዶዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ኔኤኮ ዓዶ ፆኦዛሢ ኔና ማኣዳንዳኔ፤ ቢያ ባኮ ዳንዳዓ ፆኦዛሢ ጫሪንጫፓ ዒርዚ ሳዖኮ ዴማፓ ዋኣሢ ኔኤም ዒንጊ ኔና ዓንጃንዳኔ፤ ሃሣ ሚርጌ ቆልሞና ናይና ኔኤም ዒዚ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ሚናፓ ዶዲ ማዒ ናንጋ ዹኮና ናንጊና ናንጋያ ማዒ ዓኣ ጌሜሮናይዳፓ ጴዻ ዎዛሳ ዓንጆ ቢያሢዳፓ፥ ኔ ዓንጃ ባሻያኬ። ዓካሪ ሃይ ዓንጃ ቢያ ዮሴፔ ቶኦካ ማዖንጎ፤ ጌርሲንሢ ባኣካ ሱኡጌ ማዔ፥ ዮሴፔ ቶኦካ ኬዶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«ቢኢኒያሜ፦ ቡሪ ዔካ ያኣዮጉዲኬ፤ ጉቴ ዓሚ ዒ ኬሚ ዴንቄ ባኮ ፔኤሮ ሙዓንዳኔ፤ ዋንቴ ኬሚ ዴንቄሢ ጋዓንቴ ዒዚ ጊሽካንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ዓካሪ ሃኣታ ታጶ ላምዓሢ ዒስራዔኤሌ ፃጶኬ፤ ዓዴ ዔያቶ ዓንጃዖ ፔቴ ፔቴሢም ኮይሳሢጉዴ ዓንጆ ዒንጌሢ ዬያይዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ዬካፓ ያይቆኦቤ ፔ ናኣቶ፦ «ታኣኒ ሃይቂ ታ ዒጊኖ ኮራ ዓኣዻንዳ ዎዳ ሄሌኔ፤ ዬያሮ ሄቴ ዓሢ ዔፕሮኦኔ ጎዦ ዓጫ ዔታ ዓኣ ቤዛሢዳ፥ ታ ዓዶንሢ ዱኡቴ ቤዛ ታናኣ ዎላ ዒኢካ ዱኡኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ዬይ ዴኖ ዔቶ ቤዛሢ ካኣናኔ ዓጮይዳ ሜሚሬ ጎዖ ቤዞኮ ዓባ ኬስካ ዛሎና ማክጴላይዳ ዓኣሢኬ፤ ዓብራሃሜ ዬያ ዴኖ ዔቶኮ ዓኣ ጎዦ ዱኡፒ ቤሲ ማሂ ሻንቄሢ ሄቴ ዓሢ ዔፕሮኔይዳፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ዓብራሃሜንታ ማቾ ሳኣራንታ ዪሳኣቄንታ ማቾ ዒርቢቃንታ ዱኡቴሢ ቢያ ዒኢካኬ፤ ታኣኒያ ታ ማቾ ሊያ ዒኢካ ዱኡኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ጎዦንታ ዴኖ ዔቶ ቤዞንታ ሻንቂንቴሢ ሄቴ ዓሶይዳፓኬ፤ ዬያሮ ታና ዒኢካ ዱኡኩዋቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ያይቆኦቤ ፔኤኮ ናኣቶ ዓይሢ ጋፔስካፓ፥ ጊንሣ ላሃማና ሼምፓሢ ዒዛኮ ዱጴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ዒማና ዮሴፔ ዓዶኮ ሌዞይዳ ሎኦማዖ ዓኣፖ ካሮ ሄርቂ ሄርቂ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ዬካፓ ዒዛም ማዻያታዖ ዼኤሻ ኮሻ ዓሳ ዓዶኮ ሌዞ ዱኡፖም ጊኢጊሺ፥ ሙርዑዋዖ ሚርጌ ዴይሣ ዼኤሾናኣ ቲሽኮም ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ዼኤሾ ኮሻ ዓሳ ሌዞ ዱኡፖም ጊኢጊሻኒ ዖይዲታሚ ኬሊ ኩርሴኔ፤ ዬኖ ዎዶና ሌሲ ዱኡኪንታኒ ጊኢጊሺንታሢ ያዺ ኬሊዳኬ፤ ጊብፄ ዓጮ ዓሳ ላንካይታሚ ኬሊ ጉቤ ያይቆኦቤ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ዬኤፓ ጋፓዛ ዮሴፔ ካኣቲኮ ዴማ ማዒ ዎይሣ ዓሶ፦ «ሃዳራቴ፥ ዒንሢ ታኣም ዔኤዓያታቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‹ዓዴ ታኣኮ ሃይቃኒ ዑካዖ ካኣናኔ ዓጮይዳ ዒዚ ኮሼ ዱኡፖ ቤዞይዳ ታ ዔኪ ዓኣዺ ዒዛ ዱኡካንዳጉዲ ታና ጫኣቂሴኔ፤ ዬያሮ ታ ዓዶ ታኣኒ ዒኢካ ዔኪ ዓኣዺ ዱኡኪ ማዓንዳኔ ጌዒ ኔና ዖኦጫኔ› ጌይ ካኣቲም ኬኤዙዋቴራ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ካኣቲ ዬያ ዋይዛዖ፦ «ኔኤኒ ጫኣቄ ጎይፆ ዴንዲ ኔ ዓዶ ዱኡኬ» ጌዒ ዮሴፔ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ዬያሮ ዮሴፔ ዓዶ ዱኡካኒ ዓኣዼኔ፤ ዒዛና ዎላ ካኣቲኮ ዴማ ማዒ ዎይሣ ዓሶንታ ካኣቲ ማኣሮይዳ ዓኣ ዼኤፖ ዓሶንታ ሜሌ ሃሣ ጊብፄ ዓጮይዳ ቢታንቶ ዓኣ ዓሲያኣ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ዬያጉዲ ዮሴፔኮ ማኣሮ ዓሳ፥ ጌርሲንሢ፥ ዒዛኮ ዓዶ ማኣሮ ዓሳኣ ቢያ ዮሴፔና ዎላ ዓኣዼኔ፤ ጌኤሴኤሜይዳ ዓቴዞንሢ ዻኮ ናኣቶና ማራቶና ዋኣሮና ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ሳርጌሎ ዖይቶና ዓኣ ዓሶንታ ፓራሢ ቶጊ ዓኣዻ ዓሶንታ ዒዛ ጊንፆ ዓኣዻኒ ኬስኬኔ፤ ዒማና ዒዛና ዎላ ዓኣዼ ዓሶኮ ፓይዳ ኮሺ ዺቢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ዔያታ ዴንዲቤቃ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛሎና «ዓፃዴ» ጌይንታ፥ ሃኣኮ ሺርኮ ቆይዳ ሙኪ ሄሌኔ፤ ዒኢካ ዔያታ ዑኡዞ ፔኤኮ ዼጊዲ ዒላቲ ዬኤኬኔ፤ ዮሴፔ ዒኢካ ላንካይ ኬሊ ቢያ ፔኤቂ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ዒዞ ቤዜሎይዳ ናንጋ ካኣናኔ ዓጮ ዓሳ ዓፃዴ ቆይዶይዳ ዬኤኪንታ ዬኤፖ ዛጋዖ፦ «ሃይ ጊብፄ ዓጮ ዓሳ ዒኔ ሜቂ ዬኤካ ዬኤፓ ዎዚጉዴ ዬኤፒዳይ?» ጌዔኔ። ዬያ ዛሎና ዬኖ ዮርዳኖሴ ቦኦሎይዳ ዓኣ ቤዜሎ ሱንፃ «ዓኣቤኤሌ ሚፂራይሜ» ጌይንቴኔ፤ ዬኖኮ ቡሊፃ ዔብሬ ዓሶ ሙኡጮና «ጊብፄ ዓጮ ዓሶኮ ዬኤፖ» ጌይሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ያይቆኦቤ ናኣታ ዬያይዲ ዓዶኮ ዓይሢፆ ኩንሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ሌዞ ዔያታ ካኣናኔ ዴንዳ ጎይፆ ዓጫ ዓኣ ሜሚሬ ጎዖ ቤዞኮ ዓባ ኬስካ ዛሎና ዔታ ዓኣ ቤዛ ማክጴላይዳ ዱኡኬኔ፤ ዬይ ዴኖ ዔቶ ቤዛሢ ጴዻሢ ዓብራያሜ ዱኡፒ ቤሲ ጌዒ ሄቴ ዓሢ ዔፕሮኔይዳፓ ሻንቄ ጎዦ ዓጫኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ዮሴፔ ዓዶ ዱኡኬስካፓ ፔኤኮ ጌርሲንሢና ሃሣ ዒዛ ጊንፆ ዱኡፖሮ ዓኣዼ ዓሶ ቢያሢና ዎላ ጊብፄ ዓጮ ማዒ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ዓዴ ሃይቄሢኮ ጊንፃ ዮሴፔኮ ጌርሲንሢ ዎሊ ኮራ፦ «ጎዖንቴ ዮሴፔ ኑኡና ዎላ ፑርቲ ዒዛ ዑፃ ኑ ማዼ ጌኖሮ ኑና ኮማኒ ኮዔቶ ኑ ዎይታንዳይ?» ጋዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ዮሴፔም፦ «ኑ ዓዴ ሃይቃንዳሢኮ ቤርታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹ኔ ጌርሲንሢ ኔ ዑፃ ፑርታ ባኣዚ ማዺ ዻቤያታቶ ዔያታ ማዼ ፑርቶ ባኮ ዻቢንቲ ማሂ ፓይዲ ዓርቂፖ› ጌዒ ኑ ኔኤም ኬኤዛንዳጉዲ ዓይሤኔ፤ ዬያሮ ኑኡኒ ኔ ዓዶ ፆኦዛሢኮ ዓይላ ኔ ዑፃ ፑርታ ማዼ ባኮ ቢያ ዓቶም ኔኤኒ ጋዓንዳጉዲ ኑ ሺኢቃኔ» ጋዓ ኪኢታ ኬሲ ዳኬኔ። ዬያ ዔያታ ጌዒ ዳኬሢ ዮሴፔ ዋይዛዖ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ዬካፓ ዒዛኮ ጌርሲንሢ ዒዛ ቤርቶ ፔኤሮ ሺኢካዖ ሂርኪ ጌዒ ቦንቾ ዔኤሊሢ ዔኤሊ «ኑኡኒ ቢያሢ ኔ ካራሚኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ጋዓንቴ ዮሴፔ ዔያቶም፦ «ዒጊጪፖቴ፤ ታና ፆኦሲ ቤዞይዳ ዖኦኒ ጌሤይ? ");
INSERT INTO mdyeth_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ዒንሢ ጎኔና ታጊዳ ፑርታ ማሊሢ ማሌያታንቴ ፆኦሲ ኮሺ ባኣዚ ማሂ ሺርሼኔ፤ ዬያ ዒዚ ማዼሢ ሃሢ ሼምፖና ዓኣ ሚርጌ ዓሶ ዻቂሻኒ ጌዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ሃሢ ዒንሢ ፔቴታዖ ዒጊቻንዳ ባኣዚ ባኣሴ፤ ታኣኒ ዒንሢንታ ዒንሢኮ ናኣቶንታ ሙኡዛንዳኔ» ጌዔኔ። ዮሴፔ ዬያይዲ ኮሺ ዑኡሲና ዒኖ ዔያቶኮ ዶዲሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ዮሴፔ ፔኤኮ ዓዶ ማኣሮ ዓሶና ዎላ ጊብፄ ዓጮይዳ፥ ሌዓ ዒዛኮ ፄኤታና ታጶ ሌዔ ማዓንዳኣና ናንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ዒዛኮ ናኣዚ ዔፕሬኤሜ ናኣቶንታ ናኣቶኮዋ ናኣቶ ዛጋንዳያ ሄላንዳኣና ዴዔኔ፤ ሚናኣሴ ሾዔ፥ ማኪሪኔ ጎዖሢኮዋ ናኣቶ ፔ ናይ ማሂ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ዬካፓ ዮሴፔ ጌርሲንሢም፦ «ሃይሾ፥ ማይ ታ ሃይቃንዳ ዎዳ ዑኬኔ፤ ፆኦሲ ፔኤኮ ማኣዲፆና ዒንሢ ዛጋንዳኔ፤ ሃያ ዓጫፓኣ ዒንሢ ኬሲ ዔኪ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታም ዒንጋኒ ጫኣቄ ዓጮ ማሂ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ፆኦሲ ዬኖ ዓጬሎ ማሂ ዒንሢ ዳካ ዎዶና ታኣኮ ሌዞ ሃይፓ ዔኪ ዓኣዻኒ ታኣም ጫኣቁዋቴ» ጌዒ ዔያቶ ጫኣቂሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ዮሴፔ ሌዓ ዒዛኮ ፄኤታና ታጶ ሌዔ ማዓዛ ጊብፄ ዓጮይዳ ሃይቄኔ፤ ዓሳ ዒዛኮ ሌዞ ሙርዒሱዋዖ ሜልዛ ዼኤሻና ቲሽኪ ዱኡፒም ጊኢጊሼስካፓ ሳኣፂኔ ጋርካ ዓጊ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ፔቴ ፔቴ ፔኤኮ ማኣሮ ዓሶና ዎላ ማዒ ጊብፄ ዓጮ ዴንዴ፥ ዒስራዔኤሌ ጌይንቴ ያይቆኦቤኮ ናኣታ ሃካፓ ሊካ ፓይዲንታ ናኣቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ሮኦቤኤሌ፥ ሲሞኦኔ፥ ሌዊ፥ ዪሁዳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ዪሳኮኦሬ፥ ዛብሎኦኔ፥ ቢኢኒያሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ዳኣኔ፥ ኒፕታኣሌኤሜ፥ ጋኣዴንታ ዓሴኤሬንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ፒዜ ያይቆኦቤ ሾዔ ዜርፃ ዎሊ ዑፃ ላንካይታሚ ማዓዛ፥ ዮሴፔ ቤርታዺ ጊብፄ ዓጮይዳ ናንጋያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ሚርጌ ዎዴ ዴዔስካፓ ዮሴፔንታ ዒዛኮ ጌርሲንሢንታ ዬኖ ሾይንቶኮ ዓዶንሢ ማዔ ዓሳ ቢያ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ያኣዒ ማዔቶዋ ዔያቶኮ ዜርፆ ማዔ ዒስራዔኤሌ ዓሳ ሾይንቲ ሾይንቲ ዴንዴም ፓይዳ ሚርጌሢሮ ጊብፄ ዓጮ ዔያታ ኩሜኔ፤ ሚርጌና ሃሣ ዎልቃዻያኣ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ዬካፓ ዮሴፔ ጊብፄ ዓጮም ማዼ ባኮ ዛሎ ዔሩዋ ዓኪ ካኣቲ ጊብፄ ዓጮይዳ ካኣታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ዒዚ ዴሮም ኬኤዛዖ፦ «ሃኣዛጉዋቴ፤ ሃኣቶ፥ ዒስራዔኤሌ ዓሶኮ ፓይዳ ኑጊዳፓ ዑሣ ዓኣዼ ዺቤኔ፤ ሃሣ ዔያታ ዺቢ ዎልቃዻያኣ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ዬያይዳፓ ዔቄያና ኑ ሞርኮና ዎላ ማንጊ ኑና ዔያታ ዖላኒ፤ ሃሣ ዓጮይዳፓኣ ቶሊ ኬስኪ ዓኣዻኒያኣ ዳንዳዓኔ፤ ዬያሮ ፓይዳ ዔያቶኮ ሚርጊ ሚርጊ ዓኣዹዋጉዲ ሃኒ ዬዑዋቴ፥ ኑ ጎይሢ ኮዖም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ዬካፓ ካኣቲ ዴኤሢ ማዾና ዔያቶ ሜታሳንዳጉዲ ዓሲም ሚጪንቱዋ ፑርታ ማዔ ማዺሻ ዓሲ ዔያቶ ዑፃ ዶኦሪ ጌሤኔ፤ ዬያይዴስካፓ ሚርጌ ባኣዚ ቡኩሲ ጌሦያ ማዔ ፒቶሜና ራምሴ ጌይንታ ካታሞንሢ ካኣቲም ዔያታ ማዤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ጋዓንቴ ዔያታ ዒስራዔኤሌ ዓሶ ሄርቂ ሜታሴ ዎዶና ፓይዳ ዑሣ ዓኣዼ ሚርጊ ሚርጊ ሳዔሎዋ ኩሚ ኩሚ ዓኣዼኔ፤ ያዺ ማዔሢሮ ጊብፄ ዓጮ ዓሳ ዒስራዔኤሌ ዓሶ ዒጊጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ዬያይዳፓ ዔቄያና ሚጪንቲሢባኣ ፑርቱሞና ዓይሌ ማሂ ዔያቶ ማዺሺሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ዔያታ ማዺሻ ጎይፃ፦ ቶርጶ ሄርቂሲሢና ፁኡቤ ጌይንታ ዓጪፓ ዺንቂ ማኣሪ ማዦ ባኣዚ ማዢሲሢና፤ ሃሣ ጎዦይዳኣ ሚጪንቱዋዖ ዼኤፒ ማዾ ማዺሺሢና ናንጎ ዔያቶኮ ሜቶ ናንጊ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ዬካፓ ጊብፄ ዓጮ ካኣቲ ዔብሬ ዓሶ ፃጶ ላኣሎ ሾዋ ዎዶና ማኣዲ ሾይዣ ፂፓራና ፑሃ ጌይንታ ላምዖ ላኣሊስኬንሢ ዔኤላዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«ዔብሬ ዓሶ ፃጶ ላኣሎ ዒንሢ ሾይዣኣና ናዓ ዓቲንቄ ማዔቶ ቤዞና ዎዎዹዋቴ፤ ዉዱሮ ማዔቶ ጋዓንቴ ዎዺፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ሾይዣ ላኣሎንሢ ጋዓንቴ ፆኦሲ ዒጊጬያታሢሮ ጊብፄ ዓጮ ካኣቲ ዔያቶ ዓይሤ ጎይፆ ማዺባኣሴ፤ ጉቤ ዓቲንቆ ናኣቶዋ ዎዹዋዖ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ዬካፓ ጊብፄ ዓጮ ካኣቲ ሾይዣ ላኣሎንሢ ዔኤሊሳዖ፦ «ዓቲንቆ ናኣቶ ዎዹዋዖ ዒንሢ ሃሼሢ ዓይጎሮዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ዔያታ ማሃዖ፦ «ዔብሬ ዓሶ ፃጶ ላኣላ ጊብፄ ዓጮ ላኣሎጉዲቱዋሴ፤ ዔያታ ኮሺ ዶዲ ዓሲ ማዔሢሮ ሾይዣ ዓሳ ሃጊ ዔያቶ ባንሢ ሙኩዋንቴ ቤርታዺ ፔኤሮ ፔቴታዖ ሜታባኣያ ሾዓኔ» ካኣቲም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","ዬያታ ሾይዣ ላኣላ ፆኦሲ ዒጊጬያታሢሮ ፆኦሲ ዔያቶም ኮሺ ባኣዚ ማዼኔ፤ ዔያቶ ፔቴ ፔቴሢ ማኣሪያ ጌቲሴኔ፤ ያዺ ማዒፆና ዒስራዔኤሌ ዴራ ፓይዶና ሚርጊ ሚርጊ ሃሣ ዶዲ ማዒ ማዒያኣ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ዬካፓ ካኣቲ፦ «ዔብሬ ዓሶ ፃጳፓ ሃጊ ሾይንታ ዓቲንቄ ናይ ቢያ ዔኪ ዔኪ ዼኤፖ ዓባዬ ዎሮይዳ ኬኤሩዋቴ፤ ዉዶሮ ናኣታ ጋዓንቴ ዓቶንጎ» ጌዒ ጊብፄ ዴሮ ዶዲ ዓይሥሢ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ዬኖ ዎዶና ሌዊ ዜርፆይዳፓ ማዔ ፔቴ ዓሲስኬይ ሌዊ ዜርሢ ማዔ ላኣሊስኬኖ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ዒዛ ጎጳዺ ዓቲንቄ ናይ ዒዛም ሾዓዖ፥ ናዓሢ ሚርጌና ሚዛጲ ማዔሢ ዛጊ ሃይሦ ዓጊኒ ጉቤ ፔጌይዳ ጴዹዋጉዲ ዓኣቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ያዺ ማዔቶዋ ዬያፓ ዑሣ ዓኣዼ ዒዛ ዓኣቺ ጌሣኒ ዳንዳዒባኣሢ ዔራዖ ኮታ ጎይሢ ዎኦሺጉዴ ባኣዚና ኮሺንቴ ባኣዚ ጊኢጊሺ ዋኣሢ ጌሉዋጉዲ ሺዲና ሜኤቺ ናዓሢ ዒዞ ጋሮ ጌልዜስካፓ ዔኪ ዴንዲ ዎሮ ዓጫ ዓኣ ማጫሮ ባኣካ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ናዓሢኮ ጌሬላ ዒዛይዳ ሄላ ባኮ ዛጋኒ ሃኬ ዔቂ ካፓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ዒማና ካኣታሢኮ ናይስኬና ዑሢ ማስታኒ ዎሮ ኬዳዛ፥ ዒዞም ማዾ ማዻ ላኣላ ዎሮ ዓጮይዳ ሴካ ሃንጋ ሃንታኔ፤ ዒዛ ማጫሮ ባኣኮይዳ ጌሢንቴ ፔቴ ኮታ ማላ ባኣዚ ዴንቂ ዒዞም ማዻ ላኣሎ ዳኪ ዔኪ ዬዒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ዬካፓ ዒዛ ዬኖ ባኬሎ ቡላዖ ፔቴ ናይ ጋሮይዳ ዴንቄኔ፤ ዒማና ናዓሢ ዬኤካያታሢሮ ዒዛ ሚጪንታዖ፦ «ሃይ ዔብሬ ዓሶ ፃጶ ናኣቶይዳፓ ፔቴያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ናዓሢኮ ጌሬላ ካኣቲ ናዎ ኮራ፦ «ሃያ ናዓሢ ኔኤም ዻንሥሢ ዲቻንዳ፥ ዔብሬ ዓሶ ፃጶ ላኣላፓ ፔቴ ላኣሊ ታ ኔኤም ዔኤሎንዶ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ካኣቲ ናኣ ማሃዖ፦ «ሂዮ! ታኣም ዴንዲ ዔኤሌ» ጌዔሢሮ፥ ናዔላ ዴንዲ ናዓሢኮ ዒንዶ ዔኤሊ ዔኪ ዬዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ዬካፓ ካኣቲ ናኣ ላኣሌሎ ኮራ፦ «ሃያ ናዓሢ ታኣም ዔኪ ዻንሥሢ ዲቼ፤ ኔኤም ኮይሳ ባኮ ታ ጪጋንዳኔ» ጌዔኔ፤ ዬያሮ ላኣሌላ ናዓሢ ዔኪ ዴንዲ ዻንሥሢ ዲቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ናዓሢ ዑጋዛ፥ ዒዛ ዔኪ ካኣቲ ናዎ ኮራ ሙኬኔ፤ ናዓሢያ ካኣቲ ናዎ ናይ ማዔኔ። ዬያሮ ዒዛ «ዋኣሢዳፓ ታ ኬሲ ዔኬያታሢሮ ሱንፃ ዒዛኮ ሙሴ ናንጎንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ሙሴ ዑጋዖ ፔቴ ኬሊ ዒዛኮ ፃጶ ማዔ ዔብሬ ዓሶ ዛጋኒ ዓኣዼኔ፤ ዔያታ ናሽኪባኣ፥ ዎልቄና ዴኤሢ ማዾ ዔያቶ ማዺሾንቴ ዒ ዛጌኔ፤ ሃሣ ጊንሣ ፔቴ ጊብፄ ዓጪ ዓሲ ዒዛ ፃጶ ማዔ፥ ዔብሬ ዓሲስኬያ ጳርቃንቴ ዒዚ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ሙሴ ዒማና ኮይሎ ሺሪ ዛጋንቴ ዖኦኒያ ባኣሢ ዔራዖ ጊብፄ ዓጮ ዓሢ ዎዺ ሌዞ ማኣሻላይዳ ዓኣቺ ዱኡኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ዚሮ ጉቴሎ ጊንሣ ዒዞ ቤዞ ዓኣዺ ላምዖ ዔብሬ ዓሲ ማዔይ ዎላ ዑራዻንቴ ዒዚ ዴንቄኔ፤ ጊቴቃይዶ ማዺ ዻቤ ዓሢ ዒዚ ዛጋዖ፦ «ኔኤኮ ፃጳሢ ኔ ዓይጋ ጳርቃዖ?» ጌዒ ዖኦጫዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ዓሢ፦ «ኔና ኑ ዑፆይዳ ዎይሣያና ዎጋ ሱኡጌ ማሂ ዶኦሬሢ ዖናዳይ? ኔኤኒ ጊብፄ ዓጮ ዓሢ ዎዼ ጎይፆ ታና ኔ ዎዻኒ ኮዓ?» ጌዔኔ፤ ዬያሮ ሙሴ ሚርጌና ዒጊጪ «ሃይሾ ታ ማዼ ባኮ ዴራ ዔሬኔ» ጌዒ ፔ ዒኖና ማሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ማዺንቴ ባኮ ቢያ ካኣቲ ዋይዛዖ ሙሴ ዎዺሻኒ ኮዔኔ፤ ሙሴ ጋዓንቴ ካኣቲ ቤርታፓ ሚዲያሜ ዓጪ ቤቲ ዓኣዼኔ። ዒኢካ ዒ ፔቴ ኬሊ ዔቴ ዋኣሢ ዓቺዳ ዴዒ ዓኣንቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ዒዞ ዓጮ ቄኤሴስኬያኮ ላንካይ ዉዱሮ ናይ ዓኣዖ ዔያታ ዬኖ ዔቶ ዋኣፄሎ ቤዞ ሙኪ ፔ ዓዶኮ ማራቶና ዋኣሮና ዑሻኒ ጎንጋላይዳ ዋኣፆ ዱዒ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ዒማና ሃንጎ ቆልሞ ናኣታ ሙኪ ዬያቶ ዉዱሮ ናኣቶ ዳውሳዛ፥ ሙሴ ዴዔ ቤዛፓ ዔቂ ናኣታ ዔያቶ ዳውሳሢ ላኣጊ ቆልሞዋ ዔያቶሲ ዋኣፆ ዑሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ዬያታ ዉዱሮ ናኣታ ዔያቶኮ ዓዶ ራጉዔኤሌ ኮራ ማዒ ሙካዛ «ሃኖ ዒንሢ ዎይቲ ዑኬና ማዒ ሙኬይ?» ጌዒ ዓዴ ዔያቶ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ዔያታ ማሃዖ፦ «ፔቴ ጊብፄ ዓጪ ዓሲስኬያ ቆልሞ ናኣቶይዳፓ ኑና ዓይሲ ሃሣ ዋኣፆዋ ኑኡም ጎንጋሎይዳ ዱዒ ዱዒ ቆልሞ ኑኡም ዑሼኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ዓዳሢ ዔያቶ ኮራ፦ «ሂዳዖ ዬይ ዓሢ ዎካዳይ? ዓይጎሮ ዒንሢ ዒዛ ሃሺ ሙኬይ? ዴንዲ ዒዛ ዔኤሉዋቴ፤ ሙኪ ሙኡዚ ሙዖም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ሙሴያ ዬያ ዓሢና ዎላ ናንጋኒ ኮዔኔ፤ ዬይ ዓሢ ሙሴም ፔኤኮ ናዎ ሲፓራ ጋዓዞ ዔካንዳጉዲ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ዬና ላኣሌላ ሙሴም ዓቲንቄ ናይ ሾዓዛ ሙሴ «ታኣኒ ሃኖ ዓጮይዳ ሙኬ ዓሲኬ» ጌዒ ናዖ ሱንፆ ጌርሾሜ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ሚርጌ ሌዔኮ ጊንፃፓ ጊብፄ ዓጮ ካኣቲ ሃይቄኔ፤ ዒስራዔኤሌ ዓሳ ጋዓንቴ ዬያ ሄላንዳኣና ዓይላቶይዳ ማዒ ኮሺ ሜታዺ ማኣዶ ዴንቃኒ ዒላታንቴ፥ ዔያቶኮ ዬያ ዒላቶ ፆኦሲ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ሚርጌና ዔያታ ሜታዺ ዒላታ ዒላቶ ፆኦሲ ዋይዚ ዓብራሃሜና ዪሳኣቄና ሃሣ ያይቆኦቤና ዎላ ዒ ጫኣቄ ጫኣቁሞ ጶቂሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ሃሣ ዒስራዔኤሌ ዓሶኮ ዬያ ዓይላቶና ሜታዺፆ ዛጊ ዔያቶም ዒዚ ማሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ሙሴ ሚዲያሜ ዓጮኮ ቄኤሳሢ ማዔ፥ ባይሲ፥ ዮቴሬኮ ማራቶና ዋኣሮና ሄንቂቤቃ ቆልሞ ዒሺ ዔኪ ፆኦሲ ዹካ ጌይንታ ሲና ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ዒዞ ቤዞይዳ ናንጊና ናንጋ ጎዳኮ ኪኢታንቻ ካይዚ ባኣካይዳ ዔኤታ ታሚ ሎስቶና ማዒ ዒዛም ጴዼኔ፤ ሙሴያ ካዮ ታሚ ዓርቃዖ ፔቴታዖ ሙዑዋኣሢ ዛጊ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","«ሃይ ዓይጎ ባኣዚዳይ? ካያ ዎዲ ሙይንቱዋይ? ሂንዳ ታ ዑኪ ዛጎም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ሂዚ ጌዒ ሙሴ ዬያ ባኮ ዛጋኒ ሙኪ ዑካዛ ናንጊና ናንጋ ጎዳ ዒዛ ዴንቃዖ ካዮ ባኣኮይዳፓ፦ «ሙሴ! ሙሴ!» ጌዒ ዔኤሌኔ፤ ሙሴያ «ዮ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ፆኦሲ ዒዛም፦ «ሃንጋ ሌዒፖ! ኔ ዔቄ ሳዓ ታኣም ዱማዼያ ማዔሢሮ ዱርዞ ኔኤኮ ኬሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ታኣኒ ኔኤኮ ቤርታኣ ዓዶንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታ ፆኦሲኬ» ጌዔኔ። ዒማና ሙሴ ፆኦሲኮ ዓኣፖ ካሮ ዛጋኒ ዒጊጬሢሮ ፔ ዓኣፖ ካሮ ካንቂ ዓኣቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ሄሊሳዖ ናንጊና ናንጋ ጎዳ ዒዛም፦ «ዴራ ታኣኮ ጊብፄ ዓጮይዳ ዎያጉዴ ዋኣዪሢና ሜቶናይዳ ዓኣቴያ ታ ዛጌኔ፤ ዔያቶ ሜታሳ ዓሶይዳፓ ቶላኒ ዔያታ ኮዒ ዒላታ ዒላቶ ታ ዋይዜኔ፤ ዔያቶይዳ ሄሌ ሜቶዋ ቢያ ታ ዔራኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ዬያሮ ዔያቶ ጊብፄ ዓጮ ዓሶ ኩጫፓ ዓውሳኒ ታ ኬዴኔ፤ ጊብፄ ዓጫፓ ታ ዔያቶ ኬሲ ሃሢ ካኣናኔ ዓሳ፥ ሄቴ ዓሳ፥ ዓሞራ ዓሳ፥ ፔርዜ ዓሳ፥ ሂዋዌና ዒያቡሳና ዓሳ ናንጋ ዔኤዞና ዲኢቆና ኩሜ ኮዦ ቤዞ፤ ዳልጊ ሃሣ ማሊ ማዔ ሳዔሎ ታ ዔያቶም ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ሃሢ ጎኔና ታ ዴሮ ዒስራዔኤሌኮ ዒላቶ ታኣኒ ዋይዜኔ፤ ጊብፄ ዓጮ ዓሳ ዔያቶይዳ ማዻ ሚጪንቲፃባኣ ሜታሲፆዋ ታ ዴንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ዓካሪ ሃሢ ዴሮ ታኣኮ ኔ ጊብፄ ዓጫፓ ኬሳንዳጉዲ ጊብፄ ዓጮ ካኣቲ ኮይላ ታ ኔና ዳካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ሙሴ ጋዓንቴ ፆኦሲ ኮራ፦ «ካኣቲ ኮይላ ዓኣዺ ዒስራዔኤሌ ዓሶ ጊብፄፓ ኬሳኒ ታናንሢ ዓይጎ ዓሲዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ፆኦሲ ዒዛም፦ «ዒጊጪፖ፥ ታ ኔኤና ዎላ ማዓንዳኔ፤ ዴሮ ታኣኮ ኔ ጊብፄፓ ኬሳ ዎዶና ሃኖ ዹኮይዳ ታና ዒንሢ ዚጊ ካኣሽካንዳኔ፤ ታ ኔና ዳካያ ማዔሢኮ ማላታ ማዓንዳሢያ ዬያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ሙሴ፦ «ታኣኒ ዒስራዔኤሌ ዴሮ ኮራ ዓኣዺ ‹ዒንሢኮ ቤርታኣ ዓዶንሢ ፆኦዛሢ ታና ዒንሢ ባንሢ ዳኬኔ› ጋዓ ዎዶና ዔያታ ‹ሱንፃ ዒዛኮ ዖናዳይ?› ጌዒ ዖኦጬቶ ዎዚ ጌዒ ታ ኬኤዛንዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ፆኦሲ ዒዛም፦ «ሱንፃ ታኣኮ ‹ታናኬ›፤ ዬያሮ ‹ሱንፃ ታኣኮ ታናኬ ጌዔ፥ ፆኦሲ ዒንሢ ባንሢ ታና ዳኬኔ› ዔያቶም ጌዔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ዔያቶኮ ቤርታኣ ዓዶንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታኮ ፆኦዛሢ፥ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዔያቶ ባንሢ ኔና ዳካያ ማዔሢ ዒስራዔኤሌ ዴሮም ኬኤዜ፤ ሱንፃ ታኣኮ ናንጊና ዬያኬ፤ ሃጊ ሙካንዳ ሾይንታኣ ቢያ ታና ዔራንዳሢ ዬኖ ሱንፆናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ዓካሪ ዓኣዺጋፓ ዒስራዔኤሌ ዴሮኮ ሱኡጎ ቢያ ፔቴይዳ ቡኩሴ፤ ዔያቶኮ ቤርታኣ ዓዶንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታኮ ፆኦዛሢ፥ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ኔኤም ጴዼያታሢ ዔያቶም ኬኤዜ፤ ዔያቶ ባንሢ ታ ኬዲ ጊብፄ ዓጮ ዓሳ ዔያቶ ሚጪንቱዋዖ ሄርቂ ቆላ ቆሊፆ ታኣኒ ዛጌሢያ ዔያቶም ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ሚጪንቲሢባኣ ሄርቂ ዎይሥሢና ዔያታ ሜታዻ ጊብፄ ዓጬሎይዳፓ ታኣኒ ዔያቶ ኬሲ ሃሢ ካኣናኔ ዓሳ፥ ሄቴ ዓሳ፥ ዓሞራ ዓሳ፥ ፔርዜ ዓሳ፥ ሂዋዌና ዒያቡሳና ዓሳ ናንጋ ኮዦ ቤዞ፤ ዔኤሲና ዲኢቂና ኩሜ ዓጬሎ ታ ዔያቶም ዒንጋኒ ጫኣቄኔ ጌዒ ዔያቶም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ሃሣ፦ «ታኣኮ ዴራ ኔ ኬኤዛ ባኮ ቢያ ዋይዛንዳኔ፤ ዬካፓ ዒስራዔኤሌ ዴሮኮ ሱኡጎና ዎላ ማዒ ጊብፄ ዓጮ ካኣቲ ኮራ ዓኣዻዖ ‹ዔብሬ ዓሶኮ ፆኦሲ፥ ናንጊና ናንጋ ጎዳሢ ኑኡም ጴዼኔ፤ ዬያሮ ኑ ፆኦዛሢ፥ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኣዚ ዒንጊ ካኣሽካኒ ሃይሦ ኬሊ ሃንቲ ዓሲ ናንጉዋ ቦኦሎ ኑ ዓኣዻንዳጉዲ ኑና ዳኬ› ጌዒ ኬኤዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ጎኔኬ፤ ዼኤፒ ዎልቄና ዓርቂ ዒዛ ሜታሲቦኦንቴ ጊብፄ ዓጮ ካኣቲ ዒንሢ ሃሺንዱዋኣሢ ታ ዔራኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ዬያሮ ሚርጌና ዒጊቻያ ማዔ፥ ታ ዎልቄና ማዺንታ ዓኪ ባኣዚ ታ ማዺ ታኣኮ ዼኤፖ ዎልቆዋ ዻዊ ጊብፄ ዓሶ ታ ሜታሳንዳኔ፤ ዬካፓ ዒንሢ ኬስኪ ዓኣዻንዳጉዲ ዒንሢ ዒ ዳካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ጊንሣ ሃሣ ፆኦሲ፦ «ዒንሢ ኬስካ ዎዶና ታ ዴራ ጊብፄ ዓሶ ቤርቶይዳ ዼኤፑሞ ዴንቃንዳጉዲ ታ ማሃንዳሢሮ ኩቺ ጉሪ ዒንሢ ኬስካዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ዔብሬ ዓሶ ዜርፆ ላኣላ ፔቴ ፔቴሢ ዓሺኒ ማዒ ዎላ ናንጋ ጊብፄ ዓጮ ዓሶ ላኣላ ዔያቶም ፔኤኮ ዓፒሎ፥ ዎርቆንታ ቢሮ ዓንጎና ኮሺንታሢንታ ሜሌ ፓልሞ ባኮዋ ዔርጋንዳጉዲ ዖኦጮንጎ፤ ዬያ ቢያ ዔኪጋፓ ዓቲንቆ ናኣቶና ዉዱሮ ናኣቶና ዒንሢኮ ማይሱዋቴ፤ ዬያይዲ ዒንሢ ጊብፄ ዓጮ ዓሶ ቡሪ ኬስካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ዬካፓ ሙሴ ናንጊና ናንጋ ጎዳ ኮራ፦ «ዒስራዔኤሌ ዓሳ ‹ናንጊና ናንጋ ጎዳ ኔኤም ጴዺባኣሴ› ጌዒ ታ ጋዓሢ ጎኔኬ ጎዖ ዒፂ፥ ሃሣ ታ ኬኤዛ ባኮ ዋይዚባኣቶ ታ ዔያቶም ዎዚ ጋዓንዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ናንጊና ናንጋ ጎዳ ማሃዖ፦ «ኔኤኒ ኩጫ ዓርቄ ባካ ዓይጎዳይ?» ጋዓዛ፥ ዒዚ «ኮኦሎኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ናንጊና ናንጋ ጎዳ ዒዛም፦ «ሳዓ ኬኤሬ» ጌዔኔ፤ ሙሴ ሳዓ ኬኤራዛ፥ ኮኦላ ላኣሚንቲ ሾኦሺ ማዔኔ፤ ዬያሮ ሙሴ ኮራፓ ሺኢኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ናንጊና ናንጋ ጎዳ ጋዓንቴ ሙሴም፦ «ኩጮና ዑንኮ ዛሎ ዓርቂ ዔኬ» ጌዒ ዓይሤኔ፤ ሙሴ ፔ ኩጮና ዔካዛ ጊንሣ ኮኦሎ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዔያቶኮ ቤርታኣ ዓዶንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታኮ ፆኦዛሢ፥ ናንጊና ናንጋ ጎዳ ኔኤም ጴዼያ ማዔሢ ዒስራዔኤሌ ዓሳ ጉሙርቃንዳጉዲ ዬኖ ማዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ዬካፓ ሃሣ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኩጮ ኔኤኮ ሾኦጳ ዳኬ» ጋዓዛ፥ ዒዚ ኩጮ ፔኤኮ ሾኦጳ ዳኬኔ፤ ኩጮ ዒ ጊንሣ ኬሳዛ ሻቺጉዲ ቦኦሪ፥ ዑፆይዳ ኬስካ ዶርዓሢና ዓርቂንቴያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ናንጊና ናንጋ ጎዳ፦ «ኩጮ ኔኤኮ ጊንሣ ሾኦጳ ዳኬ» ጋዓዛ፥ ሙሴ ኩጮ ፔኤኮ ሾኦጳ ዳኬኔ፤ ዬካፓ ጊንሣ ኬሳዛ ኩጫ ሃንጎ ዑፆጉዲ ጌኤሺ ዶርዓ ባኣያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ናንጊና ናንጋ ጎዳ ዒዛም ኬኤዛዖ፦ «ዓካሪ፥ ታ ዎልቆና ማዺንቴ ቤርታሳ ባኬሎ ዔያታ ጉሙርቂ ጎኔኬ ጌዒባኣያታቶ፥ ላምዓሲ ማዺንታ ባኮ ዔያታ ጉሙርቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ዬንሢ፥ ላምዖ ታ ዎልቆና ማዺንታ ባኮንሢ ዛጊ ዔያታ ጉሙርቂባኣያ ማዒ፥ ሃሣ ኔ ኬኤዛ ባኮ ዋይዚባኣቶ ዓባዬ ዎራፓ ዻካ ዋኣሢ ዔኪ ፃኣዾ ሳዖይዳ ዋሄ፤ ዓባዬ ዎሮይዳፓ ኔ ዔኬ ዋኣፃ ፃኣዾ ሳዖይዳ ሱጉሢ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ሙሴ ጋዓንቴ፦ «ናንጊና ናንጋ ጎዳሢዮ! ሃዳራ፥ ዬካ ታና ዳኪፖ፤ ቤርታኣ ማዖም ሃሢያ ታኣና ዎላ ኔ ጌስቲፆ ዓርቄማፓ ዓርቃዖዋ ታኣኮ ጌስቲሢ ዔራቶ ባኣሴ፤ ታኣኒ፦ ታኣኮ ዻንጋ ቁንጫልቃያ፥ ሃሣ ፒዚሲ ጌስታኒያ ዳንዳዑዋያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዓሲም ዻንጋ ማዤሢ ዖናዳይ? ዻንጋ ጌስቱዋያና ዋይዚ ዋይዙዋያ፤ ጊንሣ ዓኣፒ ዓኣያና ዓኣፒ ባይቄያና ማሃሢ ዖናዳይ? ዬያ ቢያ ማዻሢ ታና፥ ናንጊና ናንጋ ጎዳቱዋዓዳ? ");
INSERT INTO mdyeth_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ዬያሮ ሃሢ ዓኣዼ! ታኣኒ ኔኤና ዎላ ማዒ ኔ ጌስታንዳጉዲ ማኣዳንዳኔ፤ ኔ ዓይጎ ጌስታኒ ኮይሳቴያ ታ ኔኤም ኬኤዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ሙሴ ዒማና፦ «ናንጊና ናንጋ ጎዳሢዮ! ሃዳራ ሜሌ ዓሲ ዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ናንጊና ናንጋ ጎዳ ሙሴይዳ ዻጋዻዖ፦ «ሌዊ ዓሲ ማዔ፥ ኔ ጌርሲ፥ ዓኣሮኔ ዓኣያቱዋዓዳ? ዒዚ ቃራ ጌስታያ ማዔሢ ታ ዔራኔ፤ ሃሢ ሃይሾ፥ ዒዚ ኔ ኮይላ ሙካኔ፤ ኔና ዒዚ ዴንቃዖ ዒናፓ ኮሺ ዎዛዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ዒዛም ኔኤኒ ኬኤዛንዳኔ፤ ዒዚ ኬኤዛንዳ ባኮዋ ኔ ዒዛም ዒና ዓኣሢ ኬኤዛንዳኔ፤ ላምዓሢ ዒንሢ ዎይቲ ጌስታንዳቴያ ሃሣ ዒንሢ ዓይጎ ማዻኒ ኮይሳቴያ ታ ዒንሢም ዔርዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ዒዚ ኔና ማዒ ዴሮም ኬኤዛንዳኔ፤ ኔኤኒያ ዒዛም ፆኦሲጉዲ ማዒ ኬኤዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ታ ዎልቄና ማዺንታ ዓኮ ባኮ ኔ ማዻንዳ ሃኖ ኮኦሌሎዋ ዔኪ ዓኣዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ሙሴ ፔኤኮ ባይሲ፥ ዮቴሬ ኮራ ዓኣዻዖ፦ «ጊብፄ ዓጮይዳ ናንጋ፥ ታ ፃጶ ባንሢ ማዒ ዴንዲ ሼምፔና ዔያታ ዓኣቴ ታ ዛጎም» ጌዒ ዖኦጫዛ፥ ባይሲ ዒዛ፦ «ኮሺ ዴንዴ» ጌይ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ሙሴ ሃጊ ሚዲያሜይዳ ዓኣንቴ ናንጊና ናንጋ ጎዳ ዒዛም፦ «ኔና ዎዻኒ ኮዓ ዓሳ ቢያ ሃይቄሢሮ ጊብፄ ዓጮ ማዒ ዴንዴ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ዬያሮ ሙሴ ፔኤኮ ማቾንታ ዓቲንቆ ናኣቶንሢንታ ሃሬ ቶጊሲ ጊብፄ ዓጮ ዓኣዺፆ ዔቄኔ፤ ፆኦሲ ዎልቄና ማዺንታ ባኮ ዻዎ ፆኦሲ ኮኦሎዋ ዒማና ዒ ኩጫ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ላሚ ጊንሣ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዓካሪ፥ ሃሢ ኔኤኒ ጊብፄ ዓጮ ማዒ ዓኣዺፆይዳ ማዔሢሮ ኔኤም ታ ዒንጌ ዎልቆና ኔ ማዻንዳ፥ ታ ዎልቆና ማዺንታ ባኮ ካኣቲ ቤርታ ኔ ማዻንዳያ ኮይሳሢ ዋሊፖ፤ ያዺ ማዔቶዋ ካኣቲኮ ዒኖ ታ ዶዲ ማሃንዳሢሮ ዴሮ ሼሌዔና ጉሪ ዒዚ ሃሻዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ዬኖ ዎዶና ታኣኒ፥ ናንጊና ናንጋ ጎዳ ካኣቲም ኬኤዛ ባኮ ሂዚ ጌዒ ኬኤዜ፦ ‹ዒስራዔኤሌ ታኣኮ ቶይዶ ናዓሢኬ፤› ");
INSERT INTO mdyeth_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ታኣኒ፥ ዬይ ናዓሢ ታና ካኣሽካንዳጉዲ ሃሼ ጌዒ ኔኤም ኬኤዜኔ፤ ኔኤኒ ጋዓንቴ ዒ ዴንዱዋጉዲ ላኣጌኔ፤ ዬያሮ ሃሢ ኔኤኮ ናኣዚ ቶይዳሢ ታ ዎዻንዳኔ። » ");
INSERT INTO mdyeth_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ሙሴ ጊብፄ ዓጮ ዓኣዺፆይዳ ዓኣንቴ ዒዚ ሃውሼ ጉርዶይዳ ናንጊና ናንጋ ጎዳ ዒዛ ዴንቂ ዎዻኒ ኮዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ዒዛኮ ማቻ ሲፓራ ጳሽኪ ዴንዲ ቲሊንጊ ዓጬ ዔኪ ፔኤኮ ናዖኮ ዓቲንቶ ቤርቶ ቲቄኔ፤ ሙሴኮ ቶኮዋ ዬኖ ቲቂንቴዞና ካንሣዖ ሙሴ ኮራ፦ «ዓካሪ ኔኤኒ ታኣኮ ሱጉሢ ዑኡታኬ» ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴ ዎዹዋዖ ሃሺ ማኣሬኔ፤ ዒዛ ዒማና፦ «ዓቲንቶ ቤርቶ ቲቂፆ ዛሎና ኔ ታኣኮ ሱጉሢ ዑኡታኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ናንጊና ናንጋ ጎዳ ዓኣሮኔም፦ «ሙሴና ዎላ ካኣማኒ ዓሲ ናንጉዋ ዳውሎ ዓኣዼ» ጌዔኔ። ዒዚ ፆኦሲ ዹኮ ባንሢ ዓኣዺ፥ ዒኢካ ሙሴ ዴንቃዖ ሄርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ሙሴ፥ ናንጊና ናንጋ ጎዳ ዒዛ ጊብፄ ዓጮ ዓኣዾንጎ ጋዓዖ ኬኤዜ ባኮና ዒዚ ማዻንዳጉዲ ዓይሤ ፆኦሲ ዎልቆና ማዺንታ ባኮ ቢያ ዓኣሮኔም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ዬካፓ ሙሴና ዓኣሮኔና ጊብፄ ዓጮ ዓኣዺ ዒስራዔኤሌ ዴሮኮ ሱኡጎ ፔቴይዳ ቡኩሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ዓኣሮኔያ ናንጊና ናንጋ ጎዳ ሙሴም ኬኤዜ ባኮ ቢያ ዔያቶም ኬኤዜኔ፤ ሙሴ ዒማና ፆኦሲ ዎልቄና ማዺንታ ባኮ ዴሮ ቤርታ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ዬያሮ ዴራ ጉሙርቄኔ፤ ናንጊና ናንጋ ጎዳ ዔያቶ ባንሢ ሙኪ ዔያቶ ዛጌያ ማዔሢና ዔያቶይዳ ሄሌ ሚጪንቲፃባኣ ጌኖ ማዾ ዴንቄሢ ዋይዛዖ ጉምዓቲ ዚጊ ፆኦሲ ካኣሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ዬካፓ ሙሴና ዓኣሮኔና ጊብፄ ዓጮ ካኣቲ ቤርቶ ዓኣዺ፦ «ዒስራዔኤሌ ፆኦዛሢ፥ ናንጊና ናንጋ ጎዳ ‹ዴራ ዓሲ ናንጉዋ ዳውሎ ዓኣዺ፥ ቦንቾ ኬሊ ጌሢ ታና ቦንቻንዳጉዲ ዴሮ ታኣኮ ሃሼ› ኔኤም ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ካኣቲ ማሃዖ፦ «ናንጊና ናንጋ ጎዳሢ ዎያዳይ? ዒዚ ታና ዓይሤም ዋይዚ ዒስራዔኤሌ ታ ሃሻሢ ዓይጎሮዳይ? ናንጊና ናንጋ ጎዳ ጎዖሢ ታኣኒ ዔሩዋሴ፥ ዒስራዔኤሌያ ታ ሃሻዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ሙሴና ዓኣሮኔና ዒዛም፦ «ዔብሬ ዓሶኮ ፆኦዛሢ ኑኡም ጴዼኔ፤ ሃይሦ ኬሊ ጎይሢ ዓሲ ናንጉዋ ዳውሎ ዓኣዺ ኑ ፆኦዛሢ፥ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኣዚ ኑ ዒንጊ ካኣሽካንዳጉዲ ኑና ዳኬ ጌይ ኔና ኑ ዖኦጫኔ፤ ኑኡኒ ዬያ ማዺባኣታቶ ናንጊና ናንጋ ጎዳ ኑና ዖልዚና፥ ሃሣ ዶርዖና ጋፒሳንዳኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ካኣቲ ዔያቶ ኮይላ፦ «ዒንሢ፥ ሙሴና ዓኣሮኔና ዋይዙዋቴ! ዴራ ማዾ ቤልፃዻንዳጉዲ ዒንሢ ኮዓሢ ዓይጎሮዳይ? ዴንዲ ዒንሢኮ ማዾ ማዹዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ዒንሢ ጊብፄ ዓጮ ዓሶይዳፓ ፓይዶና ኮሺ ዺቤኔ፤ ዬይ ዒንሢም ዻካዛ ዓሶ ማዾ ላኣጊ ሺራ ዒንሢ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ዬካፓ ዒማ ኬሎና ካኣቲ ፓኣሮኔ፦ ሚጪንቱዋዖ፥ ማዾ ማዺሳ ፑርታ ማዔ ጊብፄ ዓጮ ዓሶንታ ማዾ ማዺሻ ዒስራዔኤሌ ዓሶኮዋ ሱኡጎናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«ፁኡቤ ኮሾንዶ ፑቆ ዴሮም ዎንዳሲ ጎይፆ ዒንጊፖቴ፤ ዔያታ ፔኤሮ ፑቆ ዴንዲ ኮዒ ዔኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ጋዓንቴ ቤርታ ዔያታ ማዣሢዳፓ ፔቴ ፁኡቤታዎ ፓጪሱዋዖ ማዢ ሺኢሻንዳጉዲ ዔያቶይዳ ዎልቃዹዋቴ፤ ‹ኑ ፆኦዛሢም ኑ ዒንጎ ባኣዚ ዓኣዺ ዒንጊ ካኣሽካንዳጉዲ ኑና ሃሼ› ዔያታ ጌዒ ጌዒ ታና ሜታሳሢ ሚርጌ ማዻ ባኣዚ ባኣሢሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ሉኡዚ ሃይሴ ዋይዛ ዎዴ ዔያቶም ጴዹዋጉዲ፤ ሃሣ ቤርታ ዔያታ ማዻሢፓ ባሼ፥ ሃውሾባኣያ፥ ዶዲ ማዾ ዔያቶ ማዺሹዋቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ዬካፓ ሚጪንቱዋዖ ማዾ ማዺሳ ፑርቶ ጊብፄ ዓጮ ዓሶንታ ዒስራዔኤሌ ዓሶኮ ሱኡጎንታ ዓኣዺ ዒስራዔኤሌ ዴሮም፦ «ሃካፓ ሴካ ፑቃ ዒንሢም ዒንጊንቱዋጉዲ ካኣቲ ላኣጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ዓካሪ፥ ዒንሢ ዒንሢሮ ዴንዲ ዓንካፓታቶዋ ኮዒ ዔኪ ዬዓንዳያ ኮይሳኔ፤ ጋዓንቴ ዒንሢ ማዣ ፁኡቦኮ ሚርጉማ ዎንዳስካፓ ፓጫንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ዬያሮ ዴራ ፑቆ ኮዒ ዔኪ ዬዓኒ ጊብፄ ዓጮ ቢያ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ሚጪንቱዋ፥ ማዾ ማዺሳ ዓሳ፦ ቤርታ ፑቆ ዒንጋዛ ዔያታ ማዢ ሺኢሻማ፤ ዒማ ፓይዶ ኩንሢ ሺኢሻንዳጉዲ ዒስራዔኤሌ ዓሶ ሜታሲሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ዬያታ ሚጪንቱዋዖ ማዾ ማዺሺሳ ፑርቶ ጊብፄ ዓጮ ዓሳ ማዾ ማዻ ዒስራዔኤሌ ዓሶኮ ሱኡጎ፦ «ቤርታ ማዢሳሢጉዴያ ፁኡቦ ማዢሲ ዒንሢ ሺኢሹዋኣሢ ዓይጎሮዳይ?» ጌዒ ጌዒ ጳርቃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ማዾ ማዻ ዒስራዔኤሌ ዓሶኮ ሱኡጋ ካኣቲ ቤርቶ ሺኢካዖ፦ «ካኣቲዮ! ኑና ኔ ዓይሎ ዑፆይዳ ዓይጋ ሃያ ቢያ ባኮ ኔ ዴኤፂሴይ? ");
INSERT INTO mdyeth_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ፔቴታዖ ፑቃ ኑኡም ዒንጊንቱዋንቴ ፁኡቦ ኑ ማዣንዳጉዲ ዓይሢንቴኔ፤ ሃሣ ጊንሣ ዬያይዳ ኑ ጳርቂንቲ ጳርቂንቲ ዓኣኔ፤ ዻቢንታ ኑ ጊዳፓቱዋንቴ ኔ ዴሮፓኬ» ጌዒ ሜቶ ፔኤሲ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ካኣቲ ዔያቶም፦ «ዒንሢ ማዾ ናሽኩዋያ ቤልፃ ዓሲኬ፤ ‹ኑኡኒ ዴንዲ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ዒንጊ ካኣሽካንዳኔ፥ ኑና ሃሼ› ጌዒ ዒንሢ ዖኦጫሢያ ዬያሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ሃሢ ዴንዲ ማዾ ማዹዋቴ፤ ፔቴታዖ ዒንሢም ፑቃ ዒንጊንታዓኬ፤ ጋዓንቴ ቤርታ ዒንሢ ማዣ ፁኡቦጉዴያ ማዢ ማዢ ዒንሢ ሺኢሻንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ማዾ ማዻ ዒስራዔኤሌ ዓሶኮ ሱኡጋ ቤርታ ዔያታ ማዣ ጎይፆጉዴያ ፁኡቤ ኬላ ኬላ ማዣንዳያ ኮይሳሢ ዔሬ ዎዶና ሜቶይዳ ዔያታ ኬዴሢ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ካኣቲ ቤርታፓ ዔያታ ኬስካዖ ዔያቶ ካፒ ዓኣ፥ ሙሴና ዓኣሮኔና ዴንቂ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","«ካኣቲ ፓኣሮኔንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሶንታ ቤርታ ኑ ዒፂንቴያ ማዓንዳጉዲ ማሂ፤ ሃሣ ጬንቻ ዓፓሮናኣ ኑና ዔያታ ዎዻንዳጉዲ ማሄሢ ዒንሢታሢሮ ናንጊና ናንጋ ጎዳ ዒንሢ ማዾ ዛጎንጎ! ዒዚ ዎጎንጎ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ሙሴ ጊንሣ ናንጊና ናንጋ ጎዳ ኮራ፦ «ናንጊና ናንጋ ጎዳሢዮ! ሃያ ዴሮ ዑፆይዳ ሃያጉዴ ሜቶ ኔ ሄሊሳሢ ዓይጎሮዳይ? ያዺ ማዔቶ ታና ኔ ሃካ ዓይጎሮ ዳኬይ? ");
INSERT INTO mdyeth_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ኔ ኬኤዛ ባኮ ታኣኒ ኬኤዛኒ ካኣቲ ኮይላ ሙኬማፓ ዓርቃዖ ዒዚ ሃያ ዴሮይዳ ዑሣ ዓኣዼ ሜቶ ዔኪ ዬዔኔ፤ ኔኤኒያ ሃያ ዴሮ ዓውሳኒ ማሊ ኮዒባኣሴ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ካኣቲ ፓኣሮኔይዳ ታ ማዻንዳ ባኮ ሃሢ ኔ ዛጋንዳኔ፤ ዒ ናሽኪባኣንቴ ታኣኮ ዼኤፖ ዎልቆና ዒስራዔኤሌ ዓሶ ታ ዒዛ ሃሺሳንዳኔ፤ ሃሣ ታኣኮ ዼኤፖ ዎልቃፓ ዔቄያና ‹ታ ዓጫፓ ኬስኩዋቴ› ታ ዒዛ ጌይሲሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ፆኦሲ ሙሴም ሂዚ ጌዒ ኬኤዜኔ፦ «ታኣኒ ናንጊና ናንጋ ጎዳኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ታኣኒ ቢያ ባኣዚ ዳንዳዓ ፆኦሲ ማዔሢ ዔርዚ ዓብራሃሜም፥ ዪሳኣቄም ሃሣ ያይቆኦቤም ታ ጴዼኔ፤ ‹ናንጊና ናንጋ ጎዳ› ጌይንታ ታኣኮ ዱማዼ ሱንፆና ጋዓንቴ ታ ዔያቶም ጴዺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ሾኦቺ ማዒ ዔያታ ናንጋ፥ ካኣናኔ ዓጮ ታ ዔያቶ ዻካልሳኒ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ዓካሪ ሃሢ ጊብፄ ዓሳ ዔያቶ ዓይሌ ማሂ ሜታሳ ዒስራዔኤሌ ዓሶኮ ሜታሢ ዒላቶ ታ ዋይዚ፥ ታ ዔያቶም ጫኣቄ ጫኣቁሞዋ ጶቂሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ዬያሮ ዒስራዔኤሌ ዓሶም ታ ጋዓሢ ሂዚ ጌዒ ኬኤዜ፦ ‹ታኣኒ ናንጊና ናንጋ ጎዳኬ፤ ጊብፄ ዓሳ ዒንሢዳ ሄሊሳ ዓይሉሞ ሜታስካፓ ዓውሲ ታ ዒንሢ ኬሳንዳኔ፤ ታኣኮ ዼኤፖ ዎልቆና ሜቶ ዔያቶይዳ ዔኪ ሙኪ ዒንሢ ታ ዓውሳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ታኣኒ ታ ዴሬ ዒንሢ ማሃንዳኔ፤ ፆኦሲያ ታ ዒንሢኮ ማዓንዳኔ፤ ታ ዒንሢ ጊብፄ ዓጮ ዓይሉሞይዳፓ ኬሴ ዓቦና ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲ ማዔሢ ታና ዒንሢ ዔራንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ታኣኒ ናንጊና ናንጋ ጎዳኬ፤ ዓብራሃሜም፥ ዪሳኣቄም፥ ሃሣ ያይቆኦቤማኣ ዻካልሳኒ ታ ጫኣቄ ዓጬሎ ታ ዔያቶ ጌልዛንዳኔ፤ ሃሣ ዔያቶ ዓጪ ማሂ ታ ዔያቶ ዻካልሳንዳኔ።› » ");
INSERT INTO mdyeth_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ሙሴ ዬያ ቢያ ዒስራዔኤሌ ናኣቶም ኬኤዛዛ፥ ዔያታ ዒዛም ዋይዚባኣሴ፤ ዓይጎሮ ጌዔቶ ዔያቶይዳ ሄሌ ዓይሉሞ ሜታሢ ዛሎና ናንጋ ዔያቶም ዴኤፄሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ጊንሣ ሃሣ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«ዴንዴ! ዒስራዔኤሌ ዓሳ ሃኖ ዓጬሎይዳፓ ኬስካንዳጉዲ ሃሾም ጊብፄ ካኣቲም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ሙሴ ጋዓንቴ፦ «ታ ፃጳ ዒስራዔኤሌ ዓሳታዖ ታኣም ዋይዚባኣሴ፤ ካኣቲ ታኣም ዎይቲ ዋይዛኒ ዳንዳዓይ? ኔ ታና ዛጋሢጉዲ ታ ጌኤሲ ዳንዳዑዋያኬ» ጌዒ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ «ዒስራዔኤሌ ዓሶ ጊብፄ ዓጮይዳፓ ዔኪ ዒንሢ ኬሳንዳጉዲ ታኣኒ ዒንሢ ዓይሣያ ማዔሢ ዒስራዔኤሌ ዓሶና ጊብፄ ካኣቲናም ኬኤዙዋቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ዒስራዔኤሌ ማኣሮ ዓሶኮ ቶይዳ ሃካፓ ሊካ ፓይዲንታ ዓሶኬ፦ ያይቆኦቤኮ ቶይዳሢ ሮኦቤኤሌ ናኣታ ሃኖኬ፥ ፓሉ፥ ሄፂሮኔንታ ካርሚ ጌይንታ ዖይዶ ዓቲንቄ ናይኬ፤ ዬንሢ ፔ ሱንፆና ሱንፆና ሮኦቤኤሌ ማኣሮ ዓሶኮ ዓዶንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ሲሞኦኔኮ ካኣናኔ ዓሶ ፃጶ ላኣሌሎይዳፓ ሾይንቴሢ ሻዑሌ ጊዳ ቃሳዖ ዪሙዔኤሌ፥ ያሚኔ፥ ዖሃዴ፥ ያኪኔና ፆሃሬ ጌይንታ ናይ ዓኣኔ፤ ዬንሢያ ፔ ሱንፆና ሱንፆና ሲሞኦኔ ማኣሮ ዓሶ ዓዶንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ሌዊኮ ጌርሾኔ፥ ቄሃቴና ሜራሪ ጌይንታ ናይ ዓኣኔ፤ ዬንሢያ ፔ ሱንፆና ሌዊ ማኣሮ ዓሶ ዓዶንሢ ማዓዛ፥ ሌዊ ናንጌ ሌዓ ፄኤታና ሃይሢታሚ ላንካይ ሌዔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ጌርሾኔኮ ሊቢኒና ሺምዒ ጌይንታ ዓቲንቄ ናይ ዓኣኔ፤ ዔያቶኮዋ ሚርጌ ዜርሢ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ቄሃቴኮ ዓምራሜ፥ ሂፂሃሬ፥ ኬብሮኦኔና ዑዚዔኤሌ ጌይንታ ዓቲንቄ ናይ ዓኣኔ፤ ቄሃቴ ናንጌ ሌዓ ፄኤታና ሃይሢታሚ ሃይሦ ሌዔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ሜራሪኮ ማሂሌና ሙሺ ጌይንታ ዓቲንቄ ናይ ዓኣኔ፤ ዬንሢንታ ዔያቶኮ ዜርፆንታ ቢያ ሌዊ ፃጶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ዓምራሜ ዮኬቤዴ ጌይንታዜሎ ዒዛኮ ዓዶ ጌሮ ዔካዛ፥ ዒዛ ዒዛም ዓኣሮኔና ሙሴና ሾዔኔ። ዓምራሜ ናንጌ ሌዓ ፄኤታና ሃይሢታሚ ላንካይ ሌዔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ዪፅሃሬኮ ቆራሄ፥ ኔፔጌና ዚኪሬ ጌይንታ ሃይሦ ዓቲንቄ ናይ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ዑዚዔኤሌኮ ሚሻዔኤሌ፥ ዔልፃፓኔና ሲቲሬ ጌይንታ ዓቲንቄ ናይ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ዓኣሮኔ ናዖሴ ጎዖሢ ጌሮ ማዔዜሎ ዓሚናኣዳኣቤ ናዎ ዔልሻባ ጋዓዜሎ ዔካዛ ዒዛ ናኣዳኣቤ፥ ዓቢሁ፥ ዓላዜሬና ዒታማሬ ጌይንታ ዓቲንቄ ናይ ዒዛም ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ቆራሄኮ ዓሲሬ፥ ዔልቃና፥ ሃሣ ዓቢያሳፔ ጌይንታ ዓቲንቄ ናይ ዓኣኔ፤ ዬንሢ ቢያ ቆራሄ ዜርፆኮ ማኣሮ ዓሶ ዓዶንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ዓኣሮኔ ናኣዚ ዓላዜሬ ፑቱዔኤሌ ጎዖሢ ናዎ ዔካዛ ዒዛ ፒንሃሴ ጎዖሢ ሾዔኔ፤ ዬያታ ቢያ ሌዊ ማኣሮ ዓሶኮ ዓዶንሢ ማዔ ቶይዶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ዬያቶ ባኣኮይዳፓ ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔና ዶኦሪ፦ «ዒስራዔኤሌ ዴሮ ፔኤኮ ፃጶና ፃጶና ጊብፄ ዓጮይዳፓ ዔኪ ኬሱዋቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","«ዒስራዔኤሌ ዴሮ ሃሼ» ጌዒ ጊብፄ ካኣቲና ጌስቴዞንሢ ዬንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ናንጊና ናንጋ ጎዳ ሙሴም ጊብፄ ዓጮይዳ ኬኤዜ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«ታኣኒ ናንጊና ናንጋ ጎዳኬ፤ ታ ኔኤም ኬኤዛሢ ቢያ ጊብፄ ዓጮ ካኣቲም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ሙሴ ጋዓንቴ፦ «ታኣኮ ጌስቲሢ ዔራቶ ባኣያኬ፤ ካኣቲ ታኣም ዎይቲ ዋይዛኒ ዳንዳዓንዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ናንጊና ናንጋ ጎዳ ሙሴም ሂዚ ጌዔኔ፦ «ዋይዜ፥ ታ ኔና ጊብፄ ካኣቲኮ ፆኦሲጉዲ ማሃንዳኔ፤ ኔ ጌርሲ ዓኣሮኔያ ፆኦሲ ማሊሢ ኬኤዛ ዓሲጉዲ ኔ ዛሎ ጌስታንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ታ ኔና ዓይሣሢ ቢያ ዓኣሮኔም ኬኤዜ፤ ካኣቲ ፔ ዓጮይዳፓ ዔያታ ኬስካንዳጉዲ ዒስራዔኤሌ ዓሶ ሃሾም ጌዒ ካኣቲም ዒዚ ኬኤዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ጋዓንቴ ታኣኒ ካኣቲኮ ዒኖ ዶዲሺ ዒጊጩዋያ ማሃንዳሢሮ ዎዚጉዴ ዒጊቻያ ማዔ ዲቃሢ ሄርሺሳ ባኣዚ ታኣኒ ጊብፄ ዓጮይዳ ማዼቶዋ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ዒንሢም ዒ ዋይዛዓኬ፤ ዬካፓ ጊብፄ ዓጮይዳ ዼኤፒ ሜቶ ታኣኒ ኬይሲ ታኣኮ ዴሮ፥ ዒስራዔኤሌ ዜርፆ ዓጬሎይዳፓ ዔኪ ታ ኬሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ዬያይዲ ታኣኮ ዎልቆ ኩጮ ዔያቶ ዑፃ ታ ዔቂሲ ዒስራዔኤሌ ዓሶ ታ ዔያቶ ኩጫፓ ኬሴ ዎዶና ጊብፄ ዓጮ ዓሳ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔሢ ዔራንዳኔ፤» ");
INSERT INTO mdyeth_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ሙሴና ዓኣሮኔና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ባኮ ቢያ ማዺ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ካኣቲና ዎላ ዔያታ ጌስቴ ዎዶና ሙሴኮ ሌዓ ሳሊታሚ ማዓዛ፥ ዓኣሮኔኮ ሳሊታሚ ሃይሦኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«ጊብፄ ካኣቲ፥ ‹ሂንዳ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ ማዺ ዒንሢኮ ዖኑሞ ታኣም ፔጋሲ ዔርዙዋቴ› ሂዚ ዒንሢ ኮራ ጌዔቶ፥ ዓኣሮኔ ፔኤኮ ኮኦሎ ዔኪ ካኣቲ ቤርታ ኬኤሮንጎ፤ ዒማና ኮኦላ ላኣሚንቲ ሾኦሺ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ዬያሮ ሙሴና ዓኣሮኔና ጊብፄ ካኣቲ ኮይላ ዓኣዺ ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ጎይፆ ማዼኔ፤ ዓኣሮኔ ኮኦሎ ካኣቲንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሶ ቤርታ ኬኤራዛ፥ ኮኦላ ላኣሚንቲ ሾኦሺ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ዬካፓ ካኣቲ ፔ ዓጮይዳ ዔሮ ዓሶንታ ማርሾ ማርሻ ዓሶ ዔኤሊ ዔኪ ሙካዛ፥ ዔያታኣ ፔኤኮ ማርሾና ሃሣ ዒማ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ዔያታ ፔኤኮ ኮኦሎ ኬኤሬም ኮኦላ ላኣሚንቲ ላኣሚንቲ ሚርጌ ሾኦሺ ማዔኔ፤ ጋዓንቴ ዓኣሮኔ ኮኦላ ዔያቶኮ ኮኦሎ ቢያ ማንፂ ዔኤዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ዬይ ቢያ ያዺ ማዔንቴያ ካኣቲ ዒኖ ዶዲሻዖ ማዖ ዒፄኔ፤ ናንጊና ናንጋ ጎዳ ዔያቶም ኬኤዜሢጉዲ ሙሴና ዓኣሮኔናም ዋይዛኒ ዒ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም ሂዚ ጌዔኔ፦ «ካኣቲ ዒኖ ዶዲሺ ‹ዴሮ ታ ሃሻዓ› ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ዬያሮ ዚሮ ጉቴ ዓሚ ካኣቲ ኮይላ ዓኣዼ፤ ዒዚ ዓባዬ ዎሮ ባንሢ ኬዳንቴ ጎይፃ ዒዛና ኔ ካኣማንዳኔ፤ ሾኦዦ ማዒ ላኣሚንቴ ኮኦሌሎ ኩጫ ዓርቂ ዎሮ ዓጫ ዒዛ ካፔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ዒ ሙካዛ ሂዚ ዒዛም ጌዔ፦ ‹ዔብሬ ዓሶኮ ፆኦዛሢ ዓሲ ናንጉዋ ዳውሎይዳ ታኣም ዔያታ ማዻንዳጉዲ ዴሮ ኔ ሃሾም ጌዒ ታ ኬኤዛንዳጉዲ ኔ ባንሢ ታና ዳኬኔ፤ ኔኤኒ ጋዓንቴ ሃኖ ሄላንዳኣና ዋይዞ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ሃሢ ጋዓንቴ ታኣኒ ማዻንዳ ባኮና ናንጊና ናንጋ ጎዳኮ ዖኑሞ ኔ ናሽኩዋዖ ዔራንዳኔ፤ ሃኖ ኮኦሌሎና ዎሮ ዋኣፆ ታኣኒ ጳርቃዛ፥ ዋኣፃ ሱጉሢ ማዓንዳኔ ኮሺ ዛጌ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ዋኣፆ ጊዳ ዓኣ ሞላሢ ቢያ ሃይቃንዳኔ፤ ዎሮ ዋኣፃ ሚርጌ ዛዒፆይዳፓ ዔቄያና ጊብፄ ዓሳ ሃያ ዎራፓ ዋኣሢ ዱዒ ዑሽካኒ ዳንዳዒንዱዋሴ።› » ");
INSERT INTO mdyeth_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዓኣሮኔ ፔኤኮ ኮኦሎ ዔኪ ጊብፄ ዓጮይዳ ዓኣ ዎሮንታ ዻዋሢንታ ቦቆሎ ዋኣፆ ቢያሢ ባንሢ ዞንካንዳጉዲ ኬኤዜ፥ ዋኣፃ ቢያ ላኣሚንቲ ሱጉሢ ማዓንዳኔ፤ ጎንጎና ዖቶና፥ ዬያጉዲ ዋኣፃ ዱይንቲ ጌሢንቴ ባኮይዳ ዓኣ ዋኣፃኣ ዓቱዋዖ ጊብፄ ዓጮይዳ ዓኣ ዋኣሢ ቢያ ሱጉሢ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ሙሴና ዓኣሮኔና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ጎይፆ ማዼኔ፤ ዓኣሮኔያ ካኣቲና ዒዛና ዎላ ማዻ ዼኤፖ ዓሶ ቤርታ ኮኦሎና ዎሮ ዋኣፆ ጳርቃዛ ዋኣፃ ላኣሚንቲ ሱጉሢ ማዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ዎሮይዳ ዓኣ ሞላሢ ቢያ ሃይቄም፥ ዋኣፃ ዛዔሢሮ ጊብፄ ዓጮ ዓሳ ዑሽካኒ ዳንዳዒባኣሴ። ጊብፄ ዓጫ ሱጉሢ ሌሊ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ዬካፓ ካኣቲኮ ማርሾ ዓሳ ፔ ማርሾና ዬያጉዲ ማዻዛ፥ ካኣቲ ቤርታኣሲ ጎይፆ ዒኖ ዶዲሺ ዋይዞ ዒፃያ ማዒፆ ሃሾ ዒፄኔ፤ ናንጊና ናንጋ ጎዳ ጌዔ ጎይፆ ሙሴና ዓኣሮኔናም ዋይዛኒ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ፔቴታዖ ዬያ ማዺንቴ ባኮ ቢያ ዔኤቢኬ ጎዑዋዖ ፔ ካኣቱሞ ማኣሮ ማዒ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ጊብፄ ዓጮ ዓሳ ዎራፓ ዋኣፆ ዑሽካኒ ዳንዳዒባኣሢሮ ዑሽኮ ዋኣሢ ዴንቃኒ ዎሮ ዓጫ ዔቴ ቦኦኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ናንጊና ናንጋ ጎዳ ዎሮ ዋኣፆ ሱጉሢ ማሂ ፑርቲሴስካፓ ዋኣፃ ፑርቴያ ማዒ ላንካይ ኬሊ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ካኣቲ ኮራ ዓኣዺጋፓ ናንጊና ናንጋ ጎዳ ሂዚ ጋዓኔ ጌዒ ዒዛም ኬኤዜ፤ ‹ታኣም ማዻንዳጉዲ ታኣኮ ዴሮ ሃሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ዒፄኔ ኔ ጌዔቶ፥ ኔኤኮ ዓጮይዳ ፓንቆ ታ ሚርጊሺ ሜታሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ዓባዬ ዎራ ፓንቃሢና ኩማንዳሢሮ ዬካፓ ኬስኪ ኬስኪ ኔኤኮ ካኣቱሞ ማኣሮ፥ ኔ ዎርቃ ጋሮ፥ ኔኤኮ ሻኣሎይዳ፥ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶና ኔኤኮ ዴሮና ማኣሮ፤ ዬያጉዲ ሃሣ ናኣቦንታ ሙኑቆ ቆኦሮንታይዳ ዓቱዋንቴ ጌላንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ፓንቃሢ ኮኦሚ ኮኦሚ ኔኤና ኔኤኮ ዴሮና፥ ሃሣ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶ ቢያሢ ዑፆይዳ ሙካንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ፓንቃሢ ኬስኪ ጊብፄ ዓጮ ቢያ ኩማንዳጉዲ ዎሮይዳ፥ ዻዋሢዳ ሃሣ ቦቆሎ ዋኣፆ ቢያይዳ ኮኦሎ ዞንካንዳጉዲ ዓኣሮኔም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ዬያሮ ዓኣሮኔ ጊብፄ ዓጮ ዋኣፆ ቢያ ባንሢ ኮኦሎ ዞንካዛ ፓንቃ ኬስኪ ዓጮ ጉቤ ኩሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ጋዓንቴ ማርሾ ዓሳኣ ዬያጉዲ ፔ ማርሾና ፓንቃሢ ጊብፄ ዓጮይዳ ሻዺሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ካኣቲ ሙሴና ዓኣሮኔና ዔኤላዖ፦ «ታኣና ታ ዴሮናይዳፓ ሃያ ፓንቃሢ ሺኢሻንዳጉዲ ናንጊና ናንጋ ጎዳ ታኣም ሺኢቁዋቴ፤ ናንጊና ናንጋ ጎዳም ዔያታ ዒንጎ ባኮ ዒንጊ ካኣሽካንዳጉዲ ዒንሢኮ ዴሮ ታ ሃሻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ሙሴ ዒዛም ሂዚ ጌዒ ማሄኔ፦ «ዎዛና ታ ሺኢቃንዳኔ፤ ኔናንታ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶንታም ሃሣ ኔኤኮ ዴሮማኣ ሺኢቆንዶ ዎዶማ ሌሊ ኬኤዜ፤ ዬካፓ ፓንቃሢ ኔኤና ኔ ማኣሮናይዳፓ ቢያ ሃኪ ዓባዬ ዎሮይዳ ሌሊ ናንጋንዳጉዲ ታ ማሃንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ካኣቲ ዒማና፦ «ያዺ ማዔቶ ዚሮ ታኣም ሺኢቄ» ጋዓዛ፥ ሙሴ ዒዛም፦ «ኔ ጌዔሢጉዲ ታ ማዻንዳኔ፤ ዬያሮ ኔኤኒያ ኑ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳጉዴያ ሜሌ ፆኦሲ ባኣሢ ዔራንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ፓንቃሢ ኔኤና ኔ ማኣሮናይዳፓ ቢያ፤ ሃሣ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶና ዴሮና ኮራፓ ቢያ ባይቃንዳኔ፤ ዓባዬ ዎራፓ ዓታዛ ሜሌ ቤስካ ጴዻዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ዬካፓ ሙሴና ዓኣሮኔና ካኣቲ ቤርታፓ ኬስኪ ዓኣዺ፥ ካኣቲ ኮራ ዒ ዳኬ ፓንቃሢ ባይዛንዳጉዲ ሙሴ ናንጊና ናንጋ ጎዳ ሺኢቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ሙሴ ሺኢቄ ጎይፆና ናንጊና ናንጋ ጎዳ ዓሶኮ ማኣራ ማኣራ፥ ዲሮ ጋሮና ሃሣ ቢያ ቤዞይዳ ዓኣ ፓንቃሢ ጉቤ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ጊብፄ ዓሳ ፓንቃሢ ቢያ ቤዞይዳ ቡኩሳዛ ዓጫ ፓንቃሢ ዛዖና ኩሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ካኣቲ ፓንቃሢ ሃይቄሢ ዛጌዖዋ ናንጊና ናንጋ ጎዳ ጌዔ ጎይፆ ሙሴና ዓኣሮኔናም ዋይዞ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሳዖ ሲላሎ ኮኦሎና ጳርቃንዳጉዲ ዓኣሮኔም ኬኤዜ፤ ጊብፄ ዓጮይዳ ዓኣ ሲላላ ቢያ ጩጉቺ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ዓኣሮኔ ኩጮ ዔቂሲ ኮኦሎና ሳዖ ሲላሎ ጳርቃዛ፥ ጊብፄ ዓጫ ዓኣ ሲላላ ቢያ ጩጉቺ ማዓዖ፥ ዓሶና ቆልሞናይዳ ቢያ ሻዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ማርሾ ዓሳ ፔኤኮ ማርሾና ጩጉቺ ኬስካንዳጉዲ ማርሼንቴያ ዔያቶም ሃኒባኣሴ፤ ቤርታኣ ጩጉጫ ሌሊ ቢያ ቤዞይዳ ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ማርሾ ዓሳ፦ «ሃያ ፆኦሲ ማዻ ባኣዚኬ» ጌዒ ካኣቲም ኬኤዛዛ፥ ካኣቲ ጋዓንቴ ዒኖ ዶዲሼኔ፤ ናንጊና ናንጋ ጎዳ ቤርታ ኬኤዜሢጉዲ ሙሴና ዓኣሮኔናም ዋይዛኒ ዒ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዚሮ ጉቴ ዓሚ ካኣቲ ኮራ ዓኣዺ ዒዚ ዓባዬ ዎሮ ኬዳኣና ዒዛና ካኣሚጋፓ፥ ናንጊና ናንጋ ጎዳ ኔኤም ሂዚ ጋዓኔ ጌዒ ዒዛም ኬኤዜ፤ ‹ታኣም ማዻንዳጉዲ ታኣኮ ዴሮ ሃሼ! ");
INSERT INTO mdyeth_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ኔ ዒፄቶ ጋዓንቴ ኔኤና ኔ ማኣሮናይዳ ቢያ፤ ሃሣ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶና ኔኤኮ ዴሮ ቢያ ዑፃ ሚርጌ ዻዓ ሶኦፆንቦ ዉፃሌ ዔኪ ሙኪ ታ ኔና ሜታሳንዳሢ ታና ዔሬ፤ ጊብፄ ዓጮ ዓሶኮ ማኣሮንታ ሳዖንታይዳ ቢያ ዉፃሌ ኩማንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ታኣኮ ዴራ ናንጋ፥ ጌኤሴኤሜይዳ ጋዓንቴ ዉፃሌ ፔቴታዖ ጌሉዋጉዲ ታ ዱማሳንዳኔ፤ ዬያ ታ ማዻንዳሢ ታኣኒ ናንጊና ናንጋ ጎዳ ሃኖ ዓጬሎይዳ ማዻያታሢ ኔ ዔራንዳጉዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ኔኤኮ ዴሮና ታ ዴሮና ባኣካ ዱሙሞ ዓኣያ ታ ማሃንዳኔ፤ ዬያ ታ ዎልቆና ማዺንታ ዓኮ ባኮ ዚሮ ታ ማማዻንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ናንጊና ናንጋ ጎዳ ካኣቲኮ ካኣቱሞ ማኣሮንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሶ ማኣራ ቢያ ዉፃሌ ኩንሣዛ፥ ጊብፄ ዓጫ ቢያ ዺቢ ዉፃሌና ፑርቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ዬካፓ ካኣቲ ሙሴና ዓኣሮኔና ዔኤላዖ፦ «ዒንሢ ዴንዲ ሃይካ ዓጮይዳ ዒንጎ ባኮ ዒንጊ፥ ዒንሢኮ ናንጊና ናንጋ ጎዳሢ ካኣሽኩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ሙሴ ማሃዖ፦ «ዬያይዳኒ ኑና ኮይሳያቱዋሴ፤ ዓይጎሮ ጌዔቶ ኑ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኣዚ ማሂ ኑ ዒንጋ ቆልሞ ዛሎና ጊብፄ ዓሳ ኑና ሻኣኪንታንዳኔ፤ ዬያቶ ቆልሞ ኑኡኒ ዔኪ ጊብፄ ዓሶ ቤርታ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ማሂ ዒንጌቶ ጊብፄ ዓሳ ኑና ሻኣኪንቲ ዻጋና ሹቻ ዹዓዓዳ? ");
INSERT INTO mdyeth_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ዬያሮ ኑ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ኑና ዓይሤ ጎይፆ ሃይሦ ኬሊ ጎይሢ ዓሲ ናንጉዋ ዳውሎ ዓኣዺ ዒንጎ ባኮ ዒንጊ ኑ ዒዛ ካኣሽካንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ካኣቲ ዔያቶም፦ «ፔቶ ዒንሢ ሃኪ ዴንዱዋዖ ዓሲ ናንጉዋ ዳውሎይዳ ዒንሢ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኮ ዒንጊ ካኣሽካንዳቴ ታ ዒንሢ ሃሻንዳኔ፤ ታኣማኣ ሺኢቁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ሙሴ ዒማና፦ «ዚራኣ ኬሎ ዉፃላ ኔናንታ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶንታ፥ ሃሣ ኔኤኮ ዴሮንታይዳፓ ባይቃንዳጉዲ ታ ሃሢ ኔጊዳፓ ፓፓቂንታዖ ናንጊና ናንጋ ጎዳ ሺኢቃንዳኔ፤ ጋዓንቴ ዴራ ናንጊና ናንጋ ጎዳም ዒንጎ ባኮ ዒንጊ ካኣሽኮ ካኣዦ ካኣሽካኒ ዴንዱዋጉዲ ላኣጊሢና ላሚ ኔ ታና ጌኤሻንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ሙሴ ካኣቲ ቤርታፓ ኬስካዖ ናንጊና ናንጋ ጎዳ ሺኢቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ናንጊና ናንጋ ጎዳ ሙሴ ጌዔሢጉዲ ቢያ ማዼኔ፤ ዉፃሎ ካኣቲንታ ካኣቲና ዎላ ማዻ ዼኤፖ ዓሶና ሃሣ ዴሮ ቢያሢና ቤርታፓ ፔቴታዖ ዓይሱዋዖ ባይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ማዔቶዋ ካኣቲ ፔኤኮ ዒኖ ዶዲሺፆና ዒስራዔኤሌ ዴሮ ሃሾ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ካኣቲ ኮራ ዓኣዺ ‹ዔብሬ ዓሶ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ሂዚ ኔኤም ጋዓኔ› ጌዔ፤ ‹ታና ካኣሽካንዳጉዲ ታኣኮ ዴሮ ሃሼ! ");
INSERT INTO mdyeth_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ላሚ ኔ ሃሣ ዔያታ ዴንዱዋጉዲ ላኣጌቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ኔኤኮ ቆልሞ ቢያይዳ ፑርታ ዶርዖ ዔኪ ሙኪ ታ ባይዛንዳኔ፤ ዬያሮ ኔኤኮ ፓራሢ፥ ሃራ፥ ጋኣላሢ፥ ባኣታ፥ ማራቶንታ ዋኣሮንታ ጋፓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ዒስራዔኤሌ ዓሶና ጊብፄ ዓሶና ቆልሞ ባኣካ ዱሙሞ ታ ጌሣንዳኔ፤ ዬይያ ዒስራዔኤሌ ዓሶኮ ቆልሞይዳፓ ፔቴታዖ ሃይቃዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዬያ ቢያ ዚሮ ማዻኒ ማሌኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ናንጊና ናንጋ ጎዳ ኬኤዜሢጉዲ ዚሮ ጉቴሎ ዬያ ማዼሢሮ ጊብፄ ዓሶኮ ቆልማ ቢያ ኩዳዛ፥ ዒስራዔኤሌ ዓሶ ቆልሞይዳፓ ፔቴታዖ ሃይቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ካኣቲ ዬያ ባኮ ቢያ ዖኦጬ ዎዶና ዒስራዔኤሌ ዓሶ ቆልሞይዳፓ ፔቴታዖ ሃይቂባኣሢ ዒዛም ኬኤዚንቴኔ፤ ዬይ ያዺ ማዔቶዋ ካኣቲ ዒኖ ፔኤኮ ዶዲሺ ዴሮ ሃሾ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ «ዒንሢ ኩጮና ናኣቦ ጋርካፓ ዻካ ዲቢንሢ ዑጪ ዑጪ ዔኩዋቴ፤ ዬንሢ ሙሴ ካኣቲ ቤርታ ዢባሮይዳ ላኣሎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ዬይ ሲላሊ ማዒ ጊብፄ ዓጮይዳ ቢያ ላኣሊንቴ ዎዶና ዴሮና ቆልሞናይዳ ሚርጌ ሜታሳ ዻርጬ ማላ ኪሢ ኬዳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ዔያታ ዻካ ዲቢንሢ ዔኪ ሙኪ ካኣቲ ቤርታ ዔቄኔ፤ ዒማና ሙሴ ዢባሮይዳ ላኣላዛ ዴሮና ቆልሞና ዼኤፒ ዻርጬ ማላ ኪሢና ሜታዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ዬኖ ዎዶና ማርሾ ማርሻ ዓሳ ሙሴ ቤርቶ ሙካኒ ዳንዳዒባኣሴ፤ ዓይጎሮ ጌዔቶ ዔያታ ሃንጎ ጊብፄ ዓሶጉዲ ቢያ ዻርጮ ማላ ኪፆና ሜታዻሢሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ጋዓንቴ ሃሣ ናንጊና ናንጋ ጎዳ ካኣቲኮ ዒኖ ዶዲሼሢሮ ቤርታ ሙሴም ኬኤዚንቴሢጉዲ ካኣቲ ሙሴና ዓኣሮኔናም ዋይዛኒ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዚሮ ጉቴ ዓሚ ዓኣዺ ካኣቲ ዴንቃዖ ‹ዔብሬ ዓሶኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ኔኤም ሂዚ ጋዓኔ› ጌዒ ዒዛም ኬኤዜ፤ ‹ታና ካኣሽካንዳጉዲ ታኣኮ ዴሮ ሃሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ኔ ዒፄቶ ጋዓንቴ ሳዖይዳ ታናጉዴ ፆኦሲ ባኣያ ማዔሢ ኔ ዔራንዳጉዲ ኔናኣ ዓይሱዋዖ፤ ሃሣ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶንታ ኔኤኮ ዴሮንታ ታኣኮ ዱማ ዱማ ዶርዓሢ ዎልቆ ዳኪ ሃሢ ታኣኒ ሜቶይዳ ዒንሢ ዓጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ኔኤና ኔ ዴሮናይዳ ዶርዖ ዓጋኒ ታኣኮ ዎልቆ ኩጮ ታ ዎንዴ ዔቂሴያታቴ፥ ቢያሢ ዒንሢ ቤሲ ባይቃንዳያታንቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ጋዓንቴ ሱንፃ ታኣኮ ዓጮ ቢያይዳ ዔኤሊንታንዳጉዲ ዎልቆ ታኣሲ ታ ኔና ዻዋኒ ኮዔሢሮ፥ ኔኤኒ ሼምፖና ናንጋንዳጉዲ ታ ኔና ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ኔ ሃማ ሄላንዳኣና ዒኖ ኔኤኮ ዶዲሺ ታኣኮ ዴሮ ሃሾ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ዚሮ ሃይማ ዎዴ ጊብፄ ዓጮይዳ ዛጊንቲ ቤቂባኣ ዼኤፒ ሻቺ ዒርዚ ታ ዋርቂሳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ሃሢ ሄንፆ ቤዞይዳ ዓኣ ቆልሞና ዬካ ዓኣ ባካ ቢያ ማኣሮ ባንሢ ሙካንዳጉዲ ዓይሤ፤ ማኣሪ ጌሊባኣ ዓሲ ማዔቴያ ቆልሞ ሻጮና ጳርቂንቲ ቢያ ጋፓንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ካኣቲና ዎላ ማዻ ፔቴ ፔቴ ሱኡጋ ናንጊና ናንጋ ጎዳ ኬኤዜ ባኮ ሚርጌና ዒጊጬሢሮ ዔያቶኮ ማዻ ዓሶና ቆልሞና ማኣሪ ጌላንዳጉዲ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ዓቴ ዓሳ ጋዓንቴ ናንጊና ናንጋ ጎዳ ኬኤዜ ባኮ ቦሂሢና ፔኤኮ ማዻ ዓሶና ቆልሞና ቦኦላ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔ ኩጮ ሌካ ጫሪንጮ ባንሢ ዔቂሴ፤ ሻቺ ጊብፄ ዓጮ ቢያይዳ ዋርቃንዳኔ፤ ዴሮንታ ቆልሞንታ፥ ጎዦይዳ ዓኣ ባቃሎዋ ጉቤ ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ዬያሮ ሙሴ ኮኦሎ ዔኪ ጫሪንጮ ባንሢ ዞንካዛ፥ ናንጊና ናንጋ ጎዳ ጉጉንሢና ሻቺና ኬይሴም ሳዔላ ጉጉንፆ ዱፖና ጎሽቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ናንጊና ናንጋ ጎዳ ሃይና ዬይና ጋዓ ጉጉንሢና ዜኤሊንሢና ዎላ ዓኣ ዼኤፒ ሻቺ ዒርዚ ዋርቂሼኔ፤ ዬያጉዴያ ሻቺ ዒርዚ ጊብፄ ዓጪዳ ዋርቂ ቤቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ሻጫ ጊብፄ ዓጮይዳ ቢያ ቦኦላ ዓኣ ባኮ፥ ዓሶንታ ቆልሞንታ ዓይጎ ባኣዚያ ዓይሱዋዖ ዎዺ ኩርሴኔ፤ ቦኦሎይዳ ዓኣ ቱኮና ባኮ ቢያ፥ ሃሣ ሚፆዋ ቢያ ሜንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ዒስራዔኤሌ ዓሳ ናንጋ ጌኤሴኤሜይዳ ሌሊ ዬይ ሻጫ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ካኣቲ ሙሴና ዓኣሮኔና ዔኤሊሳዖ፦ «ዓካሪ ታኣኮ ዻቢፃ ታኣም ዔርቴኔ፤ ናንጊና ናንጋ ጎዳ ፒዜኬ፤ ታኣና ታ ዴሮና ጋዓንቴ ኑ ዻቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ሻጮና ጉጉንፆና ፔቶ ኑኡም ሚርጌሢሮ ናንጊና ናንጋ ጎዳ ኑኡም ሺኢቁዋቴ፤ ጎኔ ታ ዒንሢ ሃሻንዳኔ፤ ሃካፓ ሴካ ዒንሢ ሃይካ ናንጋንዳ ዎዴ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ሙሴ ካኣቲም፦ «ታኣኒ ካታማፓ ኬኬስካዖ ኩጮ ታኣሲ ሌካ ጫሪንቺ ባንሢ ዼጊዲ ዔቂሲ ናንጊና ናንጋ ጎዳ ሺኢቃንዳኔ፤ ጉጉንፃ ዔቃንዳኔ፤ ሃሣ ሻጫኣ ሃካፓ ሴካ ኬዳዓኬ፤ ዬያ ጎይፆና ዓጫ ናንጊና ናንጋ ጎዳሮ ማዔሢ ኔ ዔራንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ጋዓንቴ ኔናንታ ኔኤና ዎላ ማዻ ዼኤፖ ዓሶንታ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዒጊጪንዱዋኣሢ ታ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ዬኖ ዎዶና ዔልዓሢ ሃጊ ቲሾ፥ ታልባሢያ ቡኒሢዳ ዓኣሢሮ ፔቴታዖ ዓቱዋዖ ጉቤ ጋፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ዛርጋሢ ጋዓንቴ ኔጊ ካፃሢሮ ፑርቱዋዖ ዓቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ሙሴ ካኣቲ ቤርታፓ ኬስካዖ ካታሞ ዙሎ ዓኣዼኔ፤ ዒማና ዒዚ ኩጮ ሌካ ዔቂሲ ናንጊና ናንጋ ጎዳ ሺኢቃዛ ጉጉንፆና ሻጮ ዒሮና ፔቴና ሻንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ካኣቲ ዬያ ማዺንቴ ባኮ ዛጌዖዋ ጊንሣ ጎሜ ማዼኔ፤ ዒዛንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሶንታ ዒኖ ዶዲሺ ዒፃያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ናንጊና ናንጋ ጎዳ ቤርታዺ ሙሴ ዛሎና ኬኤዜሢጉዲ ካኣቲ ዒስራዔኤሌ ዴሮ ሃሾ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ላሚ ሃሣ ካኣቲ ኮራ ጌሌ፤ ታኣኒ ዒዛንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሶኮ ዒኖ ዶዴያ ማዓንዳጉዲ ማሄሢ ዔያቶ ባኣኮይዳ ሜሌ ሃሣ ታ ዎልቆና ማዺንታ ዓኪ ባኣዚ ማዻኒ ማሊኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ታ ዎልቆና ማዺንታ ዬያ ዓኮ ባኮ ታ ማዻዛ ጊብፄ ዓጮ ዓሶ ዎማይዲ ታ ሜታሴቶዋ ዒንሢ ዒንሢኮ ናኣቶና ናኣቶኮ ናኣቶናም ኬኤዛንዳጉዲኬ፤ ዬያ ጎይፆና ታኣኒ ናንጊና ናንጋ ጎዳ ማዔሢ ዒንሢ ቢያሢ ዔራንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ዬያሮ ሙሴና ዓኣሮኔና ካኣቲ ኮራ ዓኣዻዖ፦ «ዒብሬ ዓሶኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ሂዚ ጋዓኔ፥ ‹ታኣም ኔ ዓይሢንቲፆ ዒፃሢ ዓይዲ ሄላንዳኣናዳይ? ሃሢ ታና ካኣሽካንዳጉዲ ታኣኮ ዴሮ ሃሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ኔ ዒፂፆና ዶዴቶ ጋዓንቴ ዚራኣ ኬሎይዳ ዺቢ ዓቢሢ ኔ ዓጮ ሙካንዳጉዲ ታ ዓይሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ዓቢፆኮ ሚርጌ ዺቡሞይዳፓ ዔቄያና ዓጮ ቢያ ካንቃንዳኔ፤ ሻጮይዳፓ ዓቴ ባኮ ቢያ ሚፆዋ ዓይሱዋዖ ሙይ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ሃሣ ኔኤኮ ካኣቱሞ ማኣሮንታ ኔኤና ማዻ ዼኤፖ ዓሶ ማኣሮንታ ኔኤኮ ዴሮ ማኣሮ ቢያ ዓቢፃ ኩማንዳኔ፤ ዬይ ባካ ቤርታ ኔ ዓዶንሢ ዎዶይዳፓ ሃኖ ሄላንዳኣና ሄሌ ሜታስካፓ ቢያ ባሼ ማዓንዳኔ› » ጌዔኔ። ዬካፓ ሙሴ ጊብፄ ካኣቲ ቤርታፓ ኬስኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ካኣቲና ዎላ ማዻ ዼኤፖ ዓሳ ካኣቲ ኮራ፦ «ሃይ ዓሢ ኑኡም ፒሮ ማዒ ሜታሳሢ ዓይዲ ሄላንዳኣናዳይ? ዔያቶኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ካኣሽካኒ ዒስራዔኤሌ ዓሶኮ ዓቲንቃ ዓኣዾንጎ፤ ኑኡኮ ዓጬላ ባይሲንታይዳ ኬዴሢ ኔኤም ጴዹዋዓዳ?» ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ዬያሮ ሙሴና ዓኣሮኔና ዔኤሊንቲ ካኣቲ ቤርቶ ሺኢካዛ ካኣቲ ዔያቶም፦ «ዒንሢ ዴንዲ ዒንሢኮ ፆኦሲ ማዔ ናንጊና ናንጋ ጎዳ ካኣሽካኒ ዳንዳዓኔ፤ ጋዓንቴ ዴንዳኒ ኮይሳዞንሢ ዎንሢዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ሙሴ ዒማና፦ «ኑኡኮ ናኣቶንታ ጋርቾ ዓሶንታ ዓቱዋዖ ቢያሢ ኑ ዓኣዻንዳኔ፤ ኑኡኮ ዓቲንቆና ዉዱሮ ናኣቶና፥ ኑኡኮ ማራቶና ዋኣሮና፥ ባኣቶዋ ኑኡኮ ኑ ቢያ ዔኪ ዓኣዻንዳኔ፤ ዓይጎሮ ጌዔቶ ኑ ዓኣዻ ቤዞይዳ ናንጊና ናንጋ ጎዳም ቦንቾ ኬሊ ማሂ ኑ ቦንቻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ካኣቲ፦ «ፑርቱሞና ዒፂሢ ማሊሢ ዒንሢ ማሌሢ ዔርታያ ማዔሢሮ ዒንሢኮ ላኣሎና ናኣቶና ዔኪ ዒንሢ ዓኣዻንዳጉዲ ታ ዒንሢ ዳካዓኬ! ሂንዳ ናንጊና ናንጋ ጎዳሢ ዒንሢና ዎላ ማዓ ጎይፆ ታ ዛጎም፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ዒንሢ ናንጊና ናንጋ ጎዳ ካኣሽካኒ ኮዔቶ ዒንሢኮ ዓቲንቃ ሌሊ ዓኣዻኒ ዳንዳዓኔ» ጌዔኔ፤ ዬካፓ ሙሴና ዓኣሮኔና ዳውሲንቲ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዺቦ ዓቢፆ ዔኪ ዬዓኒ ኩጮ ኔኤኮ ጊብፄ ዓጮ ቢያሢ ባንሢ ማሄ፤ ዔያታ ሙኪ ባቃሌ ባኮ ቢያና ሻጮይዳፓ ዓቴ ቱኮና ባኮ ቢያ ሙይ ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ዬያሮ ሙሴ ጊብፄ ዓጮ ቢያ ባንሢ ኩጮ ቤኤዛዛ፥ ናንጊና ናንጋ ጎዳ ዬኖ ዋንቶና ሮኦሮናይዳ ዓባ ኬስካ ባንፃፓ ዢባሬ ዢባርሺሴኔ፤ ሳዓ ካራዛ፥ ዓባ ኬስካ ዛሎና ዔቄ ዬይ ዢባራ ዺቢ ዓቢሢ ዒሺ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ዔያታ ሻዺ ሙካዖ ዓጮ ቢያ ባይዜኔ፤ ዬያጉዴ ሚርጌ ዓቢሢ ዬያኮ ቤርታ ጴዺ ቤቂባኣሴ፤ ሴካ ቤርታኣ ጴዻንዳያቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ዓጬላ ሺቢ ዹሜያ ማላንዳያ ሄላንዳኣና ዺቦ ዓቢፃ ሳዖ ካንቄኔ፤ ፔቴ ባኣዚታዖ ዓቱዋንቴ ዱማ ዱማ ሚፆ ዑፃ ዓኣ ዓኣፖንታ ዬያጉዲ ቱኮና ባኮዋ ቢያ ጋፒሲ ሄንቄኔ፤ ጊብፄ ዓጮይዳ ዓኣ ሚሢንታ ቱኮና ባኮዋ ቢያ ፔቴታዖ ዓይሱዋዖ ዓኣዔ ዒላሺ ቢያ ጉኡሊ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ካኣቲ ሙሴና ዓኣሮኔና ዑኬና ዔኤሊሳዖ፦ «ዒንሢኮ ፆኦሲ ማዔ ናንጊና ናንጋ ጎዳሢና ዒንሢናም ታ ዻቤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ዓካሪ ሃሢ ፔቴና ዻቢንቶ ታኣኮ ዒንሢ ዓቶም ጋዓንዳጉዲ ታ ዒንሢ ሺኢቃኔ፤ ሃያ ፑኡፖ ሜታሢ ታጊዳፓ ሺኢሻንዳጉዲ ዒንሢኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ታኣም ሺኢቁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ሙሴያ ካኣቲ ቤርታፓ ኬስካዖ ናንጊና ናንጋ ጎዳ ሺኢቃዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ናንጊና ናንጋ ጎዳ ዓባ ኬስካ ዛሎና ዔቂሴ ዢባሮ ባሻያ፥ ሃሣ ዓቢፆዋ ፒፂ ዔኪ ዼኤፖ ዞቄ ባዞይዳ ዒሺ ዓርሣያ ዶዲ ዢባሬ ዓባ ጌላ ዛላፓ ዔቂሴኔ፤ ዬያ ጎይፆና ጊብፄ ዓጮ ቢያይዳ ፔቴ ዓቢሢያ ዓይሲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ጋዓንቴ ናንጊና ናንጋ ጎዳ ካኣቲኮ ዒኖ ዶዲሺ ዒፃያ ማሄሢሮ ሃሣ ዒስራዔኤሌ ዴሮ ሃሻኒ ኮይባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኩጮ ኔኤሲ ሌካ ጫሪንጮ ባንሢ ዔቂሴ፤ ዼኤፒ ሻኔ ዹሚ ጊብፄ ዓጫ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ሙሴ ኩጮ ሌካ ጫሪንጮ ባንሢ ዔቂሳዛ፥ ጊብፄ ዓጮይዳ ሃይሦ ኬሊ ጉቤ ሻኔ ዹሚ ዹሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ጊብፄ ዓሳ ሴካና ሃንጋና ዎሊ ዴንቃኒ ዳንዳዒባኣሢሮ ዖኦኒያ ሃይሦ ኬሊ ሄላንዳኣና ፔኤኮ ማኣራፓ ኬስኪባኣሴ፤ ዒስራዔኤሌ ዓሳ ናንጋ ቤዞይዳ ጋዓንቴ ፖዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ካኣቲ ሙሴ ዔኤላዖ፦ «ዴንዲ ዒንሢኮ ናንጊና ናንጋ ጎዳ ካኣሽኩዋቴ፤ ዒንሢኮ ላኣሎና ናኣቶና ዒንሢና ዎላ ዓኣዻኒ ዳንዳዓኔ፤ ጋዓንቴ ዒንሢኮ ማራቶና ዋኣሮና ሃሣ ባኣቶና ሃይካ ዓታንዳያ ኮይሳኔ» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ሙሴ ሂዚ ጌዒ ማሄኔ፦ «ያዺ ማዔያታቴ ኑ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳሢም ሚቺ ዒንጎ ባኮንታ ሜሌ ኑኡኒ ዒንጊ ካኣሽካንዳ ባኮንታ ቆልሞዋ ኔ ኑኡም ዒንጋኔ ጌይሢዳ? ");
INSERT INTO mdyeth_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ዬይ ፔቴታዖ ያዺ ማዓኒ ዳንዳዑዋሴ፤ ኑኡኮ ቆልሞ ቢያ ኑ ዔኪ ዓኣዻንዳኔ፤ ፔቴታዖ ኑ ሃሻዓኬ፤ ኑ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳሢም ዒንጊ ካኣሽኮንዶ ቆልሞ ዶኦሪ ሺኢሻንዳሢ ኑ ኑ ቶኦኪናኬ፤ ዒኢካ ኑ ሄላንዳሢኮ ቤርታ ዒዛም ኑኡኒ ዒንጊ ካኣሽካንዳ ቆልማ ዎዚጉዴያታቴያ ኑ ዔራኒ ዳንዳዑዋሴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ናንጊና ናንጋ ጎዳ ካኣቲኮ ዒኖ ዶዲሺ ዒፃያ ማሄሢሮ ዴሮ ሃሻኒ ዒ ኮዒባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ካኣቲ ሙሴ ኮራ፦ «ላሚ ታ ኔና ዛጉዋጉዲ ታ ዓኣፓፓ ባይቄ! ታ ቤርታ ኔ ጴዼቶ ማይ ኔ ሃይቃንዳሢ ኔና ዔሬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ሙሴ ካኣቲም፦ «ኔ ጌዔሢጉዲ ማዖንጎ፤ ላሚ ታ ኔና ዛጋዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ጊብፄ ካኣቲና ዴሮ ቢያሢና ዑፃ ሜሌ ዶርዖ ታ ዳካንዳኔ፤ ዬካፓ ሃኖ ዓጫፓ ዒንሢ ኬስካንዳጉዲ ዒዚ ዒንሢ ሃሻንዳኔ፤ ፔቴ ዓሲታዎ ዓይሱዋዖ ዒንሢ ቢያሢ ዒ ዳውሲ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ሃሢ ዒስራዔኤሌ ዴራ ዓቲንቆንታ ላኣሎንታ ፔኤኮ ዓሺኖ ቢያ ኮራፓ ዎርቄንታ ቢሮ ዓንጎ ፓልማሢያ ዔርጋንዳጉዲ ዔያቶም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሳ ጊብፄ ዓሶ ቤርቶይዳ ዼኤፑሞ ዴንቃንዳጉዲ ማሄሢሮ ጎኔና ካኣቲና ዎላ ማዻ ዼኤፖ ዓሶና ዴራኣ ቢያ ሙሴ ዼኤፒ ዓሲ ማሂ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ሙሴ ካኣቲም፦ «ናንጊና ናንጋ ጎዳ ሂዚ ጋዓኔ፥ ‹ሳዓ ጊዲሚሺ ማዓዛ ጊብፄ ዓጮይዳ ታ ሃንታንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ካኣቱሞ ዖይቶ ዻካላንዳ ካኣቲ ናኣዚዳፓ ዓርቃዖ ዴንዲ ዎንፆ ዎዻ ካራሞ ላኣላ ሾዔ ናኣቶ ሄላንዳኣና ጊብፄ ዓጮ ቢያይዳ ቶይዲ ማዔ ዓቲንቄ ቢያ ሃይቃንዳኔ፤ ዬያጉዲ ቆልሞኮዋ ቤርታኣ ናኣታ ሃይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ጊብፄ ዓጮይዳ ቢያ ሃይካፓ ቤርታ ባኣያ ሴካ ቤርቲማኣ ማዓኑዋያ ዼኤፒ ዬኤፒ ዬኤኪንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ጋዓንቴ ዒስራዔኤሌ ዓሶይዳ ማዔቶዋ ቆልሞ ባኣካ ካኒታዖ ቦጫዓኬ፤ ዬኖ ዎዶና ታኣኒ ናንጊና ናንጋ ጎዳ ጊብፄ ዓሶና ዒስራዔኤሌ ዓሶናኮ ባኣካ ዱሙሞ ጌሣሢ ዒንሢ ዔራንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ሙሴ ዒማና ካኣቲም፦ «ኔኤና ዎላ ማዻ ዼኤፖ ዓሳ ቢያ ታ ኮይላ ሙኪ ሎኦሚ ዚጋንዳኔ፤ ዴሮ ታኣኮ ታ ዔኪ ኬስካንዳጉዲ ታና ዔያታ ሺኢቃንዳኔ፤ ዬካፓ ታ ዓኣዻንዳኔ» ጌዒ፥ ጌኤዞ ሃሼኔ፤ ያዺ ጌዔስካፓ ኮሺ ዻጋዺ ካኣቲ ቤርታፓ ኬስኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ጊብፄ ዓጮይዳ ሚርጌ ታ ዎልቄና ማዺንታ ዓኪ ባኣዚ ታ ማዻንዳጉዲ ካኣቲ ዒንሢም ዋይዛዓኬ» ቤርታ ጌዔያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ሙሴና ዓኣሮኔና ዬንሢ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮንሢ ካኣቲ ቤርታ ማዼኔ፤ ጋዓንቴ ናንጊና ናንጋ ጎዳ ካኣቲኮ ዒኖ ዶዲሺ ዒፃያ ማሄሢሮ ዒስራዔኤሌ ዓሶ ፔ ዓጫፓ ኬስካንዳጉዲ ዳኪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም ጊብፄ ዓጮይዳ ዓኣንቴ ሂዚ ጌዒ ኬኤዜኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«ሃና ዓጊኔላ ዒንሢም ሌዖኮ ቤርታሳ ዓጊኒ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ዒስራዔኤሌ ዴሮም ቢያ ሃያ ዎጎ ዔርዙዋቴ፤ ሃና ዓጊኔላ ፄኤሬስካፓ ታጳሳ ኬሎና ፔቴ ፔቴ ዓሲ ፔኤኮ ማኣሮ ዓሶም ማራናይታቶዋ ዋናናይ ጊኢጊሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ፔቴ ማኣሪ ዓሲ ዻኪ፥ ሹኮናሢ ሙዒ ኩርሳኒ ዳንዳዒባኣያ ማዔቶ ዑኬ ዓኣ ዓሺኖና ዎላ ፔኤኮ ማኣሮ ዓሳ ሙዓኒ ዳንዳዓማጉዴያ ማሊ ፔቱሞና ዎላ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ዒንሢ ዶኦራንዳ ቆልማ ማራይ ሃሣ ዋኣሪ ማዓኒ ዳንዳዓኔ፤ ጋዓንቴ ቦሂሳ ባኣዚ ባኣያ ፔቴ ሌዔ ኩሜ ማራናይ ዓዴ ሃሣ ኮላናይዳፓ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ዴንዲ ታጶ ዖይዳሳ ኬላ ሄላንዳኣና ካፒ፥ ታጶ ዖይዳሳ ኬሎኮ ዋንቶ ዒስራዔኤሌ ዴራ ቢያ ዬያ ቆልሞ ሹኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ዴራ ሱጉፆይዳፓ ዔኪ ዬያ ቆልሞኮ ዓሽካ ሙይንታ ማኣሮ ፔቴ ፔቴሢ ጌሎ ካሮኮ ዓጫ ዓኣ ሬኤኮና ዑፃ ዓኣ ቦኦኮላሢና ቲሽኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ዓሽኮ ዬማ ዋንቶና ሚቺ ሚቺ፥ ጫንቺ ዒላሺና ላኣዳና ዎላ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ዓሽኮይዳፓ ዓኣዔ ሃሣ ካሦናያ ሙዒፖቴ፤ ጋዓንቴ ቶኦካ፥ ቶካ፥ ጎጶ ባኮዋ ዓይሱዋዖ ቢያ ሚቺ ዓሽኮ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ዓሽኮ ዓይሲ ዎይሢፖቴ፤ ዓቲ ዎርቄ ባኣዚ ዓኣቴ ቢያ ሚጮም ታሚዳ ዓጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ጎይሢ ዓኣዺሢሮ ጊኢጊንቴ ዓሲ ማዒ፥ ማኣዓሢ ማይንቲ ዱርዞዋ ዓኣሢንቲ፤ ሃሣ ኮኦሎዋ ዒንሢኮ ኩጫ ዓርቂ ሩኡሪ ሩኡሪ ሙዑዋቴ፤ ዬና ኬላ ታና፥ ናንጊና ናንጋ ጎዳሢኮ ‹ዑሣ ዓኣዺፆ ቦንቾ ኬሊ› ዒንሢም ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«ሃሣ ዬኖ ዋንቶና ታኣኒ ጊብፄ ዓጮ ቢያይዳ ሃንቲ ሃንቲ ዓሶኮ ማዔቶዋ ቆልሞኮ ቤርቶ ናኣቶ ዎዻንዳኔ፤ ጊብፄ ዓጫ ካኣሽኮ ፆኦዞይዳ ቢያ ፑርታ ባኣዚ ታ ዓጋንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ዒንሢኮ ካሮ ዓጮይዳ ዓኣ ሬኤኮ ዑፃ ጴዻ ሱጉፃ ዒንሢ ናንጋ ማኣሮ ዱማሲ ዔርዛ ማላታ ማዓንዳኔ፤ ታኣኒ ዬያ ሱጉፆ ዴንቃዖ ዒንሢኮ ዑሣ ዖኦኪ ዓኣዻንዳኔ፤ ዬያሮ ጊብፄ ዓሶ ታ ዎዻኣና ዒንሢዳ ፔቴታዖ ሜታ ሄላዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ታኣኒ ናንጊና ናንጋ ጎዳ ዒንሢም ማዼ ባኮ ቢያ ጶቂሳያ፥ ዬና ኬሌላ ዒንሢም ቦንቾ ኬሊ ማዖንጎ፤ ዬያ ሙካ ዎዶ ቢያይዳ ቦንቹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ናንጊና ናንጋ ጎዳ ሃሣ ሂዚ ጌዔኔ፦ «ላንካይ ኬሊ ጉቤ ላኣዳ ሌሊ ዒንሢ ሙዓንዳኔ፤ ቤርታሳ ኬሎ ዒንሢኮ ማኣራፓ ሙኑቆ ፃኣዞ ቢያ ኬሱዋቴ፤ ዓይጎ ዓሲያ ዬንሢ ላንካዎ ኬሎንሢዳ ሙኑቃ ፃኣዛ ጌሌ ካሣ ሙዔቶ ታኣኮ ዴሬ ማዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ዬንሢ ላንካዎ ኬሎንሢኮ ቤርታሳ ኬሎና ላንካሳ ኬሎናይዳ ታኣም ዱማዼ ቡኪንቲ ዒንሢ ቡኪንታንዳኔ፤ ዬንሢ ኬሎንሢዳ ዒንሢኮ ሙኡዚ ሌሊ ጊኢጊሻንዳኣፓዓቴም ዓይጎ ማዾዋ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ዒስራዔኤሌ ዴሮ ቢያ ጊብፄ ዓጮይዳፓ ታ ኬሴሢ ዬኖ ኬሎና ማዔሢሮ ዬኖ ላኣዶ ሙዒ ቦንቾ ኬሎ ዒንሢ ካፒ ቦንቻንዳኔ፤ ሙካ ዎዶ ቢያይዳ ዬኖ ኬሌሎ ዼኤፒ ቦንቾ ኬሊ ማሂ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ቤርታሳ ዓጊኖኮ ታጶ ዖይዳሳ ኬሎ ጌሊፆ ዋንታፓ ዓርቃዖ ላማታሚ ፔታሳ ኬሎ ዋንቶ ሄላንዳኣና ላኣዳ ሌሊ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ዓይጎ ሙኑቃ ፃኣዛታዖ ዒንሢ ማኣራ ጴዻንዳያ ኮይሱዋሴ፤ ዓጪ ሾይንቲታቶዋ ሙኬ ዓሲ ዖና ማዔቶዋ ሙኑቃ ፃኣዛ ጌሌ ካሣ ሙዔቶ ታኣኮ ዴሬ ማዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ዓይጎ ቤስካ ዒንሢ ማዔቶዋ ላኣዳ ሙዓንዳፓዓቴም ሙኑቃ ፃኣዛ ጌሌ ካሣ ሙዒፖቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ሙሴ ዒስራዔኤሌ ዴሮኮ ሱኡጎ ማዔ ዓሶ ቢያ ዔኤላዖ፦ «ዒንሢኮ ማኣሮ ዓሳ ቢያ ዑሣ ዓኣዺፆ ማሊ ቦንቾ ኬሎ ቦንቻንዳጉዲ ዒንሢዳፓ ፔቴ ፔቴሢ ማራናይታቶዋ ዋናናይ ዶኦሪ ዔኪ ሹኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ቂኢፃ ኩማንዳ ሂሶጴ ጌይንታ ባኬሎኮ ዒላዦ ዔኪጋፓ ዓንዶ ጋራ ዓኣ ሱጉፃፓ ዔኪ ዔኪ ማኣሮኮ ካሮ ዓጮይዳ ዓኣ ሬኤኮና ዑፃ ዓኣ ቦኦኮላሢያ ቲሽኩዋቴ፤ ዴንዲ ሳዓ ካራንዳያ ሄላንዳኣና ዖኦኒያ ፔ ማኣራፓ ኬስኮፓ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ናንጊና ናንጋ ጎዳ ጊብፄ ዓሶ ሃይቢና ዎጋኒ ጊብፄ ዓጮ ሃንታንዳኔ፤ ካሮኮ ዑፃ ዓኣ ቦኦኮላሢና ዓጮ ሬኤኮናይዳ ሱጉፆ ዒ ዛጋዖ ዑሣ ዖኦኪ ዓኣዻንዳኔ፤ ዎዻ ኪኢታንቻሢያ ዒንሢኮ ማኣሪ ማኣሪ ጌሊ ዒንሢ ዎዹዋጉዲ ዬይ ላኣጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ዒንሢና ዒንሢኮ ናኣቶና ሃያ ዎጎ ናንጊና ካፑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ናንጊና ናንጋ ጎዳ ዒንሢ ዻካልሳኒ ጉሙርሴ ዓጮ ጌላዖዋ ሃያ ዎጎ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ናኣታ ዒንሢኮ ‹ሃይ ዓይጎ ዎጌዳይ?› ጌዒ ዒንሢ ዖኦጬቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ዒንሢ ‹ሃይ፥ ናንጊና ናንጋ ጎዳ ቦንቻኒ ማዺንታ ዑሣ ዓኣዺሢ ጌዒ ቦንቾ ኬሎና ዒንጊንታ ባኣዚኬ፤ ዓይጎሮ ጌዔቶ ናንጊና ናንጋ ጎዳ ጊብፄ ዓጮይዳ ዒስራዔኤሌ ዓሶ ማኣሮ ሃሺ ዑሣ ዓኣዺ ጊብፄ ዓሶ ዎዻዖ ኑና ሃሼሢሮኬ› ጌዒ ዒንሢ ዔያቶም ኬኤዛንዳኔ» ጌዔኔ። ዒስራዔኤሌ ዓሳ ዬያ ዋይዛዖ ዚጊ ፆኦሲ ካኣሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ዬካፓ ዴንዲ ሙሴና ዓኣሮኔ ዛሎና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ባኮ ቢያ ዔያታ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ሳዓ ጊዲሚሺ ማዓዛ ካኣቲኮ ዓልጎ ዻካላ ናኣዚፓ ዓርቃዖ ዴንዲ ቱኡዞ ማኣራ ዓኣ ዓሶኮ ቶይዶ ናኣቶ ሄላንዳኣና ጊብፄ ዓጮይዳ ቶይዶ ማዔ ዓቲንቆ ናኣቶ ቢያ ናንጊና ናንጋ ጎዳ ዎዼኔ፤ ቆልሞኮዋ ቤርታሳ ናኣቶ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ዬኖ ዋንቶና ካኣቲንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሳ ሃሣ ጊብፄ ዓጮ ዴራ ቢያ ጊንዓስካፓ ጴጫንቴ፥ ዓቲንቄ ናይ ሃይቁዋዖ ዓቴ ማኣሪ ፔቴታዖ ባኣሢሮ ጊብፄ ዓጮይዳ ዼኤፒ ዬኤፒ ዒላቲ ዋይዚንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ዬኖ ዋንቶና ካኣቲ ሙሴና ዓኣሮኔና ዔኤሊሳዖ፥ «ዒንሢንታ ዒንሢኮ ፃጶ ዒስራዔኤሌ ዓሳ ቢያ ሃይካፓ ኬስኩዋቴ! ታ ዓጮ ሃሺ ዓኣዹዋቴ፤ ዒንሢ ዎንዴ ዖኦጬ ጎይፆ ዴንዲ ዒንሢኮ ናንጊና ናንጋ ጎዳ ካኣሽኩዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ማራቶ፥ ዋኣሮንታ ባኣቶንታ ዓኣ ቆልሞ ቢያ ዔኪ ዓኣዹዋቴ! ዒንሢ ፆኦዛሢ ታና ዓንጃንዳጉዲ ታኣም ሺኢቁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ዓጬሎ ዔያቶም ሃሺ ኬስካንዳጉዲ ጊብፄ ዓጮ ዓሳ ፔ ቶኦኪና ዒስራዔኤሌ ዴሮ ሩኡሪሺሢና፦ «ዑኬና ዒንሢ ኬስኪባኣያታቶ ኑ ጋፔኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ዬያሮ ዴራ ካፂባኣ ዲርኮና ዺኢሎ ቆኦሮይዳ ኩንሢ ዓፒላና ማሪ ጌኤታ ኬዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ዒስራዔኤሌ ዓሳ ሙሴ ዓይሤ ጎይፆ ማዼኔ፤ ዔያታ ዎዎዴይ ጌዔቴ ዎርቆንታ ቢሮ ዓንጎ ፓልማሢንታ፤ ዬያጉዲ ዓፒላኣ ዔያቶም ዒንጋንዳጉዲ ዖኦጪ ዔርጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ጊብፄ ዓሶ ቤርታ ዼኤፑሞ ዴንቃንዳጉዲ፤ ሃሣ ዖኦጬ ባኮ ቢያ ዔያታ ዔካንዳጉዲ ማሄኔ፤ ዬያይዲፆና ዒስራዔኤሌ ዓሳ ጊብፄ ዓጮ ቆሎ ቡሪ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ዒስራዔኤሌ ዓሳ ራሚሴ ጎዖ ቤዞይዳፓ ሱኩቴ ዓኣዻኒ ቶኪና ዔቄኔ፤ ዬያ ዓሶኮ ሚርጉማ ላኣሎና ናኣቶና ፓይዲንቱዋንቴ ላሆ ፄኤታ ሺያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ዔያቶና ዎላ ሜሌ ፓይዳ ሚርጌ ዓሲ ሚርጌ ማራይ፥ ሚርጌ ዋኣሪንታ ሃሣ ሚርጌ ባይያኣ ዒሺ ዒሺ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ጊብፄ ዓጫፓ ዔያታ ዔኪ ኬስኬ ዲርኮና ዺኢሎ ላኣዳ ላኣዴኔ፤ ዓይጎሮ ጌዔቶ ጊብፄ ዓጮይዳፓ ዔሩዋዖ ሩኡሪ ዔያታ ኬስኬሢሮና ሙዖ ዔያታ ጊኢጊሻኒ፤ ሃሣ ካፄ ካሣ ካሣኒያ ዎዴ ባኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ዒስራዔኤሌ ዓሳ ጊብፄ ዓጮይዳ ናንጌሢ ዖይዶ ፄኤታና ሃይሢታሚ ሌዔናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ዖይዶ ፄኤታና ሃይሢታሚ ሌዔ ኩሜ ኬሎና ናንጊና ናንጋ ጎዳኮ ዴራ ቢያ ጊብፄ ዓጮ ሃሺ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ናንጊና ናንጋ ጎዳ ዴሮ ካፒ ጊብፄ ዓጬሎይዳፓ ኬሴ ኬሎና ሳዓ ዹሚኬ፤ ዬና ዋንቴላ ዒስራዔኤሌ ዓሳ ኬስካ ዎዶ ቢያይዳ ፆኦሲ ቦንቻኒ ላሁዋዖ ዶዲ ካፒ ዎርቃ ናንጊና ናንጋ ጎዳም ዱማዼ ዓቢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ናንጊና ናንጊና ጎዳ ሙሴና ዓኣሮኔናም፦ «ዑሣ ዓኣዺፆ ቦንቾ ኬሎኮ ቦንቾ ዎጋ ያዺ ማዖንጎ፤ ሜሌ ዓጪፓ ሙኬ ዓሲ ማዔያ ዓይጎ ዓሲያ ማዖም ዑሣ ዓኣዺፆ ቦንቾ ኬሎ ካዎ ሙዖፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ዒንሢም ማዾ ማዻንዳጉዲ ዒንሢ ሻንቄ ዓሲታቶ ጋዓንቴ ቤርታዺ ዓቲንቶ ቤርቶ ዒንሢ ቲቄቴ ሙዓኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ዒማና ዓጮይዳ ናንጋ ሾኦቺ ዓሲ፤ ሃሣ ዑኬ ኬሊዳ ዒንሢ ጪጊ ማዺሳኒ ዔኬ ዓሲ ዓኣቶ ሙዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ሙዓ ቢያ ዬኖ ጊኢጊንቴ ማኣሬሎ ጋራ ሙይንታንዳያ ኮይሳሢሮ ሴካ ካሮ ኬስኮፖ፤ ማራናኣቶኮዋ ማዖም ዋናናኣቶኮ ሜጌፆዋ ሜንሢፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ዒስራዔኤሌ ዓሳ ቢያሢ ሃያ ቦንቾ ኬሎ ቦንቾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ጋዓንቴ ዓቲንቶ ቤርቶ ቲቂንቲባኣ ዓይጎ ዓሲያ ሙዖፖ፤ ሜሌ ዓጪ ዓሲ ዒንሢኮ ባኣካ ዓኣዖ፥ ናንጊና ናንጋ ጎዳኮ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ ቦንቻኒ ኮዔቶ ቤርታዺ ዒዛኮ ማኣሮይዳ ዓኣ ዓቲንቆ ቢያሢኮ ዓቲንቶ ቤርቶ ቲቁዋቴ፤ ዬካፓ ዓጫ ሾይንቴ ዒስራዔኤሌ ዓሲ ማዒ ፓይዲንቲ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ ቦንቻኒ ዒንሢና ዎላ ፔቴ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ዓካሪ ሃይ ዎጋ ዒንሢ ዒስራዔኤሌ ዓሶም ማዔቶዋ ዒንሢኮ ባኣኮይዳ ናንጋ ሙኬ ዓሶም ዬኖ ጎይፆና ማዺንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ዒስራዔኤሌ ዓሳ ዓይሢንታያ ማዒ ሙሴና ዓኣሮኔ ዛሎና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ባኮ ቢያ ኩንሣኒ ጊኢጌያ ማዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ዬኖ ኬሎና ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ጉቤ ጊብፄ ዓጫፓ ዔኪ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ናንጊና ናንጋ ጎዳ ሙሴም ኬኤዛዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«ዒስራዔኤሌ ዴሮይዳፓ ማዖም ቆልሞይዳፓ ቤርቲ ማዒ ሾይንቴያ ቢያ ታኣም ማዓንዳያ ኮይሳኔ፤ ዬያሮ ቤርቲ ማዒ ሾይንቴሢ ቢያ ታኣም ማዓንዳጉዲ ዱማሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ሙሴያ ዴሮም ሂዚ ጌዔኔ፦ «ሃና ኬላ ዓይሌ ማዒ ዒንሢ ዎርቂ ናንጌ ጊብፄ ዓጮ ሃሺ ኬስኬዞ ማዔሢሮ ሃኖ ኬሎ ማሊ ጶቂሡዋቴ፤ ናንጊና ናንጋ ጎዳ ዒንሢ ፔኤኮ ዼኤፖ ዎልቆና ዓውሲ ኬሴሢ ሃናኣ ኬሎናኬ፤ ዬያሮ ሃኖ ኬሎይዳ ሙኑቃ ፃኣዛ ጌሌ ካሣ ሙዒፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ሃኖ ኬሎና፥ ሌዖኮ ዓይፆ ማዔ ዓቢቤ ጌይንታ ዓጊኖና ጊብፄ ዓጮ ዒንሢ ሃሺ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ናንጊና ናንጋ ጎዳ ቤርታ ካኣናኔ ዓሶ ዓጮ፥ ሄኤቴ ዓሶ ዓጮ፥ ዓሞራ ዓሶ ዓጮ፥ ሂዋዌ ዓሶ ዓጮና ዒያቡሳ ዓሶ ዓጮ ዒንሢ ዻካልሳንዳሢ ዒንሢኮ ቤርታኣ ዓዶንሢም ጫኣቄኔ፤ ዔኤሲና ዲኢቂና ኩሜ ዬኖ ማሎ ዓጬሎ ዒንሢ ዒዚ ጌልዛ ዎዶና ሌዖኮ ዓይፆ ዓጊኖይዳ ሃኖ ቦንቾ ኬሌሎ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ዬኖና ላንካይ ኬሊ ጉቤ ላኣዳ ዒንሢ ሙዓንዳኔ፤ ላንካሳ ኬሎና ናንጊና ናንጋ ጎዳም ቦንቾ ኬሊ ማሂ ቦንቹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ካፂ ሶልኬ ካሣ ሙዒፖቴ፤ ሶልኬ ካሣኣ ማዖም ሙኑቃ ፃኣዛ ፔቴታዖ ዒንሢ ዓጫ ጴዾፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ዬና ቦንቾ ኬላ ቦንቺንታ ዎዶና ዬያ ዒንሢ ቢያ ማዻሢ ጊብፄፓ ዒንሢ ኬስኬ ዎዶና ናንጊና ናንጋ ጎዳ ዒንሢም ማዼ ኮዦ ባኮ ቢያ ጶቂሣንዳጉዲ ማዔሢ ዒንሢኮ ናኣቶም ኬኤዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ዬና ቦንቾ ኬላ ዒንሢኮ ኩጮይዳ ቱኡቴያ፥ ሃሣ ባሊቶይዳ ጌሢንቴ ማላታ ባኣዚጉዲ ጶቂሣያ ማዓንዳኔ፤ ናንጊና ናንጋ ጎዳ ፔኤኮ ዼኤፖ ዎልቆና ጊብፄ ዓጫፓ ዒንሢ ኬሴሢሮ ናንጊና ናንጋ ጎዳኮ ዎጋ ቢያ ኬሊ ዒንሢ ዻንጋፓ ሺኢኩዋንቴ ላሚ ላሚ ዒንሢ ዻንጋና ዔኤላንዳጉዲ፤ ሃሣ ማላንዳጉዲ ዒንሢም ጶቂሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ዬያሮ ሃኖ ቦንቾ ኬሎ ሌዓ ሌዓ ጌሢንቴ ኬሎና ቦንቹዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","ሃሣ ዒ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ዒንሢና ዒንሢኮ ቤርታኣ ዓዶንሢናም ዒንጋኒ ጫኣቄ ካኣናኔ ዓሶ ዓጮ ዒንሢ ዔኪ ዬዓንዳኔ፤ ዬኖ ዓጬሎ ዒንሢ ዒ ዻካልሳ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ቶይዲ ማዔ ዓቲንቄ ናይ ቢያ ናንጊና ናንጋ ጎዳም ዒንሢ ዒንጋንዳኔ፤ ዬያጉዲ ዒንሢኮ ቆልሞኮዋ ቤርታኣ ሾይንታ ቢያ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ሃሬይዳፓ ሾይንቴ ቤርቲ ሾይንቲ ጋዓንቴ ዓዴ ማራናይና ላኣሙዋቴ፤ ሃሮማ ዒንሢ ዔካኒ ኮዒባኣቶ ጋዓንቴ ባቃኖ ሜንሡዋቴ፤ ቤርታ ሾይንቲ ማዔያ ዓቲንቄ ናይ ቢያ ዒንሢ ላኣሚ ዔካንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ሃጊ ቤርታ ሙካ ዎዶይዳ ኔኤኮ ዓቲንቆ ናዓ ሃኖ ዎጎኮ ቡሊፆ ዖኦጬቶ ሂዚ ጌዒ ኬኤዜ፥ ‹ዓይላቶና ኑ ዎርቄ ጊብፄ ዓጮይዳፓ ናንጊና ናንጋ ጎዳ ዼኤፒ ዎልቄና ኑና ኬሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ጊብፄ ዓጮ ካኣቲ ፔኤኮ ዒኖ ዶዲሺ ዒፃያ ማዒ ታ ዒንሢ ሃሻዓ ጌዔ ዎዶና ናንጊና ናንጋ ጎዳ ጊብፄ ዓጮይዳ ዓሲንታ ቆልሞንታኮ ቢያ ቤርቶ ሾይንቶ ዎዼኔ፤ ሃሢ ቤርቲ ሾይንቲ ማዒ ሾይንቴ ዓዴ ቆልሞ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ማሂ ኑ ዒንጋሢ ዬያሮኬ፤ ቶይዲ ማዒ ሾይንቴ ኑኡኮ ዓቲንቆ ናኣቶ ጋዓንቴ ኑ ላኣሚ ዔካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ዬይ ዎጋ ኑኡኮ ኩጮይዳ ቱኡቴያ፤ ሃሣ ባሊቶይዳ ጌሦና ማላታ ባኣዚ ማዒ ኑም ጶቂሣኔ፤ ናንጊና ናንጋ ጎዳ ፔኤኮ ዼኤፖ ዎልቆና ጊብፄ ዓጮይዳፓ ኑና ኬሴሢያ ኑም ጶቂሣኔ።› » ");
INSERT INTO mdyeth_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ጊብፄ ዓጮ ካኣቲ ዴሮ ሃሼያና ናንጊና ናንጋ ጎዳ ዑኬ ማዔ ፒሊስፄኤሜ ዓጮ ዓኣዻ ጎይፆይዴና ዓሶ ዔኪ ዓኣዺባኣሴ፤ ዬያ ዒዚ ማዼሢ ዴራ ዔያቶኮ ቤርቶይዳ ዖልዚ ካፒ ዓኣያ ማዔሢ ዴንቄቶ ማሊፆ ሺርሺ ጊብፄ ዓጮ ማዑዋጉዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ዬያሮ ዬኖ ጎይፆ ሃሺ ዞቄ ባዞ ባንሢ ዴንዳ ዓሲ ናንጉዋ ዳውሎና ጌዒ ሺርሻ ጎይሢ ዔኪ ዔያቶ ዓኣዼኔ፤ ዒስራዔኤሌ ዓሳኣ ዖልዚም ጊኢጊንቴ ዓሲ ማዒ ጊብፄ ዓጫፓ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ዮሴፔ ፔኤኮ ሜጌፆ ዔካንዳጉዲ ዒስራዔኤሌ ዓሶ ጫኣቂሴ ጎይፆና ሙሴ ዮሴፔኮ ሜጌፆ ዔኪ ዓኣዼኔ፤ ዓይጎሮ ጌዔቶ ዮሴፔ ዔያቶም፦ «ፆኦሲ ዒንሢ ዓውሴም ዒንሢ ኬስካ ዎዶና ሜጌፆ ታኣኮ ሃኖ ሳዓፓ ዔኪ ዓኣዹዋቴ» ጌዒ ቤርታ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ዒስራዔኤሌ ዓሳ ሱኩቴይዳፓ ዔቂ፥ ዓሲ ናንጉዋ ዳውሎ ዓጫ ዓኣ ዔታሜ ጌይንታ ቤዛ ዱንኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ዔያታ ሮኦሪና ዋንቴና ቢያ ሃንታንዳጉዲ ናንጊና ናንጋ ጎዳ ዔያቶ ሮኦሪ ፒዝ ጌዒ ዔቄ ሻኣሬና፥ ዋንቶ ጊንሣ ፒዝ ጌዒ ዔቄ ፖዓ ታሚና ማኣዲ ዔኪ ዓኣዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ዬይ ፒዝ ጌዒ ዔቄ ሻኣራ ሮኦሮና፤ ፒዝ ጌዒ ዔቄ ታማ ሃሣ ዹሞና ቢያ ኬሊ ዔያቶኮ ቤርታ ቤርታ ማዒ ዓኣዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«ዒስራዔኤሌ ዓሳ ማዒ ሚግዶሌና ዞቄ ባዞናኮ ሳዛ ዓኣ ፒሃሂሮቴ ጌይንታ ቤዞኮ ቤርቶ ዛላ ባዓልፃፖኔ ኮይሎይዳ ዱንኪ ዴዓንዳጉዲ ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ዬያሮ ዒስራዔኤሌ ዓሳ ዓሲ ናንጉዋ ዳውሎይዳ ካራ ባይቂ ዓጬሎኮ ዙሎ ሺሪ ሺሪ ሜታዻያ ጊብፄ ካኣቲም ማላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ታኣኒያ ዒዛኮ ዒኖ ዶዲሺ ዒፃያ ማሃንዳሢሮ ዒንሢ ዒዚ ዳውሳንዳኔ፤ ዒማና ካኣቲና ዒዛኮ ፖኦሊሶና ታኣኒ ባሺ ዴንቃንዳ ባሺፃ ታኣኮ ቦንቾ ማዓንዳኔ፤ ያዺ ማዔስካፓ ጊብፄ ዓጮ ዓሳ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔሢ ዔራንዳኔ» ጋዓዛ፥ ዒስራዔኤሌ ዓሳ ኬኤዚንቴማ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ዴራ ቶሊ ዴንዴሢ ጊብፄ ዓጮ ካኣቲ ዋይዛዖ ዒዛንታ ዒዛና ዎላ ማዻ ዼኤፖ ዓሳ ማሊፆ ፔኤሲ ሺርሺ፦ «ሃይ ኑ ማዼ ባካ ዓይጎዳይ? ዒስራዔኤሌ ዓሳ ዓኣዻንዳጉዲ ኑ ሃሼሢሮ ዔያታ ኑኡም ማዻ ማዻ ፓጬኔ ጌይሢቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ዬካፓ ካኣቲ ሳርጌሎ ዖይቶ ጊኢጊሺ ፖኦሊሶዋ ዔኪ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ቃራ ዶዲ ላሆ ፄኤታ ሳርጌላ ዖይታ ጊዳ ቃሲ ጊብፄ ዓጮይዳ ዓኣ ሳርጌሎ ዖይቶዋ ቢያ ዖሎሮ ዓኣዻንዳጉዲ ኬሲ፥ ዔያቶ ዓይሢ ዖሊሳ ዓሶዋ ጊኢጊሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ናንጊና ናንጋ ጎዳ ካኣቲኮ ዒኖ ዶዲሺ ዒፃያ ማሄሢሮ ጫርቂ ኬዞይዳ ዓኣ ዒስራዔኤሌ ዓሶ ዒዚ ዳውሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ጊብፄ ዓጮኮ ዖሎ ዓሳ ሳርጌሎ ዖይቶንታ ፓራሢንታ ፓራሢ ቶጊ ዔኪ ዓኣዻ ዓሶንታ ዎላ ማዒ ዒስራዔኤሌ ዓሶ ጊንፆ ዓኣዺ፥ ዒስራዔኤሌ ዓሳ ዞቄ ባዞኮ ቤርቶ ዛላ ዓኣ ፒሃሂሮቴና ባዓልፃፖኔ ኮይሎይዳ ዱንኪ ዴዒ ዓኣ ቤዛ ዓኣንቴ ሄሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ዒስራዔኤሌ ዓሳ ካኣቲና ዒዛኮ ዖሎ ዖላ ዓሶና ዔያቶይዳ ፑርታ ባኣዚ ማዻኒ ጊኢጊንቲ ሙካሢ ዛጋዖ ሚርጌና ዒጊጪ፥ ናንጊና ናንጋ ጎዳ ዔያቶ ማኣዳንዳጉዲ ዒዛ ባንሢ ዒላቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ሙሴ ኮራ ዔያታ፦ «ጊብፄ ዓጮይዳ ኑኡኮ ዱኡፒ ቤሲ ባይቂያ? ዔኤዞ፥ ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ኑ ሃይቃንዳጉዲ ዓይጋ ኔ ዔኪ ኑና ዬዔይ? ጊብፄፓ ኔ ኬሴም ኑ ጊዳ ሙኬ ባኮ ሂንዳ ዓካሪ ዛጌ! ");
INSERT INTO mdyeth_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ሃይ ቢያ ማዓንዳሢ ሃጊ ዒኢካፓ ኬስኩዋዖ ኔኤም ኑ ኬኤዚባይ? ዬያ ሌሊቱዋንቴ ‹ሃዳራ ኑና ሃሼ፥ ጊብፄ ዓጮ ዓሶም ዓይሌ ማዒ ማዾ ኑ ማዾም› ኔኤም ኑ ጌዒናኣኮኬ፤ ጎኔና ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ሃይቂፆይዳፓ ዒኢካ ዓይሌ ማዒ ናንጊፃ ቃራታዖ ዓቴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ሙሴያ ዔያቶም ማሃዖ፦ «ዶዱዋቴ፥ ዒጊጪፖቴ! ዒንሢ ዓኣ ጎይፆማና ዶዲ ዚቲ ጎዑዋቴ፤ ናንጊና ናንጋ ጎዳ ዒንሢ ዓውሳኒ ማዻንዳ ባኮ ሃኖ ዒንሢ ዛጋንዳኔ፤ ሃኣቶ፥ ሃኖ ዒንሢ ዛጋ ጊብፄ ዓጮ ዓሶ ላሚ ዒንሢ ዛጋዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ናንጊና ናንጋ ጎዳ ዒንሢ ዛሎ ዖልታንዳኔ፤ ዒንሢ ማዻኒ ኮይሳሢ ዚቲዮ ጌዒ ማዓ ባኮ ዛጊ ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ታ ባንሢ ኔ ዒላታሢ ዓይጎሮዳይ? ዬያይዳፓ ዴራ ቤርቲም ዓኣዻንዳጉዲ ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ኮኦሎ ኔኤኮ ዼጊዲ ባዞ ባንሢ ዞንኬ፤ ዋኣፃ ላምዖ ቤሲ ፓቂንታንዳኔ፤ ዒስራዔኤሌ ዓሳ ፃኣዺ ሳዓና ባዞ ቲቂ ፒንቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ጊብፄ ዓጮ ዓሶኮ ዒኖ ታ ዶዲሺ ዒፃ ዓሲ ማሃንዳሢሮ፥ ዴሮ ዔያታ ዳውሳንዳኔ፤ ካኣቲና ዒዛኮ ፖኦሊሶና ሃሣ ሳርጌሎ ዖይቶና ፓራሢና ታኣኒ ባሺ ቦንቾ ዴንቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ዔያቶ ታ ባሻዛ፥ ጊብፄ ዓጮ ዓሳ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔሢ ዔራንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ዒስራዔኤሌ ፖኦሊሶኮ ቤርታ ቤርታ ማዒ ዔኪ ዓኣዻ ኪኢታንቻሢ ሺሪ ጊንፃ ዔቄኔ፤ ፒዝ ጌዒ ዔቄ ሻኣራኣ ጊንሢም ዓኣዺ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ጊብፄ ዓጮ ዓሶና ዒስራዔኤሌ ዓሶናኮ ባኣካ ዔቄኔ፤ ሻኣራ ጊብፄ ዓጮ ዓሶ ዹሚና ካንቃዛ፥ ዒስራዔኤሌ ዓሶም ጋዓንቴ ፖዒ ፖዓኔ፤ ዬያሮ ጊብፄ ዓጮ ዖሎ ዓሳ ዬኖ ዋንቶ ቢያ ዒስራዔኤሌ ዓሶ ባንሢ ዶጫኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ዬካፓ ሙሴ ኩጮ ዋኣፆ ባንሢ ማሄኔ፤ ዬያሮ ናንጊና ናንጋ ጎዳ ዓባ ኬስካ ዛላፓ ዼኤፒ ዢባሬና ባዞ ፓቂ ጊንሢም ማሄኔ፤ ዢባራ ዬኖ ዋንቴሎ ሃሹዋዖ ዢባርሼሢሮ፥ ዋኣፃ ሺኢኬም ሳዓ ፃኣዼኔ፤ ዋኣፃኣ ላምዖ ፓቂንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ዒስራዔኤሌ ዓሳ ባዞ ፃኣዺ ሳዓና ቲቂ ፒንቃኣና፥ ዋኣፃ ዔያቶኮ ሻውሎና ሚዛቆ ዛሎናይዳ ኮጬ ማዒ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ጊብፄ ዓጮ ዓሳ ሳርጌሎ ዖይቶና፥ ፓራሢና፤ ሃሣ ፓራሢ ቶጊ ዔኪ ዓኣዻ ዓሳ ጉቤ ዒስራዔኤሌ ዓሶ ዳውሲ ጊንፆ ባዞ ሳዞ ጌሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ሃጊ ሳዓኮ ጊንሢ ዞቁዋንቴ ናንጊና ናንጋ ጎዳ ፒዝ ጌዒ ዔቄ ታሞና ሻኣሮና ባኣካፓ ጊብፄኮ ዖሎ ዖላ ዓሶ ሊካ ዛጋዛ፥ ቢያሢ ዒጊጪ ዎኦቶንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ናንጊና ናንጋ ጎዳ ዔያቶኮ ሳርጌሎ ዖይቶኮ ሺራሢ ሳዖና ዎላ ዓይሤሢሮ ዬኖ ዖይቶ ፓራሢና ጎቺሲ ዔኪ ዓኣዻኒ ዔያታ ዳንዳዒባኣሴ፤ ጊብፄ ዓጮ ዓሳ፦ «ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ማኣዲ ኑና ዖዖላኔ፤ ዬያሮ ኑ ዔያቶኮ ቤርታፓ ፑኒንቴቴ ቃራኬ!» ዎሊ ኮይላ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኩጮ ኔኤኮ ባዞ ባንሢ ማሄ፤ ዋኣፃ ጊብፄ ዓጮ ዓሶይዳ፥ ሳርጌሎ ዖይቶና ፓራሢናይዳ ጊንሣ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ዬያሮ ሙሴ ኩጮ ፔኤሲ ባዞ ባንሢ ማሄኔ፤ ሳዖኮ ጊንፃ ዞቃኣና ዋኣፃ ጊንሣ ዎንዳኣ ቤዞ ማዔኔ፤ ጊብፄ ዓጮ ዓሳ ዋኣፃፓ ጳሽኪ ቶላኒ ማሌኔ፤ ናንጊና ናንጋ ጎዳ ጋዓንቴ ባዞይዳ ዔያቶ ዔኪ ዔኪ ኬኤሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ዋኣፃ ዎንዳኣ ቤዞ ጊንሣ ማዒ ዒስራዔኤሌ ዓሶ ጊንፆ ሙካ ሳርጌሎ ዖይቶንታ ፓራሢና ዖላ ዓሶንታ ሃሣ ጊብፄኮ ዖሎ ዓሶ ጉቤ ሙዔኔ፤ ዔያቶይዳፓ ፔቴ ዓሲታዖ ዓቲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ዒስራዔኤሌ ዓሳ ጋዓንቴ ዋኣፃ ሻውሎና ሚዛቆ ዛሎናይዳ ዔያቶኮ ኮጬ ማዒ ዔቄሢሮ ፃኣዺ ሳዓና ፒንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ዬኖ ኬሎና ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ጊብፄ ዓጮ ዓሶ ኩጫፓ ዓይሴኔ፤ ባዞ ዓጮይዳ ዓኣ ጊብፄ ዓሶኮ ሌዞዋ ዒስራዔኤሌ ዓሳ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ናንጊና ናንጋ ጎዳ ዎዚጉዴ ዼኤፒ ዎልቄና ጊብፄ ዓጮ ዓሶ ባሼቴያ ዒስራዔኤሌ ዓሳ ዛጋዖ ናንጊና ናንጋ ጎዳ ዒጊጬኔ፤ ናንጊና ናንጋ ጎዳና ዒዛም ማዻያ ማዔ ሙሴ ዑፆይዳኣ ዔያታ ጉሙርቂሢ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ዬካፓ ሙሴና ዒስራዔኤሌ ዴሮና ሃካፓ ሊካ ዓኣ ዓይኑሞ ናንጊና ናንጋ ጎዳ ቦንቺ ዓይናዼኔ፦ «ፓራሢንታ ፓራሢና ዖላ ዓሶንታ ባዞይዳ ዔኪ ኬኤሪ ዼግ ዼግ ጌዒ ቦንቺንቴሢሮ ናንጊና ናንጋ ጎዳም ታ ዓይናዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ናንጊና ናንጋ ጎዳ ታኣኮ ዎልቃሢኬ፤ ታ ዒዛ ቦንቺ ዓይናዻኔ፤ ታና ዒዚ ዻቂሻያ ማዔኔ፤ ዒዚ ታኣኮ ፆኦዛሢኬ፤ ዬያሮ ታ ዒዛ ጋላታኔ። ታ ዓዶ ፆኦዛሢኬ፥ ታ ዒዛ ዼጊዲ ቦንቻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ናንጊና ናንጋ ጎዳ ዶዲ ዖላያኬ፤ ሱንፃኣ ዒዛኮ ናንጊና ናንጋ ጎዳኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","«ጊብፄ ዓጮኮ ዖሎ ዓሶ ሳርጌሎ ዖይቶና ዎላ ባዞይዳ ኬኤሬኔ፤ ፖኦሊሶ ዓይሣ ዶኦሪንቴ ዓሳኣ ዞቄ ባዞና ሙይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ሚርጌና ዔታዼ ባዛ ዔያቶ ዱኡኪ ባይዜኔ፤ ሹቺጉዲ ዔያታ ኮላዺ ባዞ ዔቶ ኬዴኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«ናንጊና ናንጋ ጎዳሢዮ! ኔኤኮ ሚዛቆ ኩጫ ዎልቄና ቦንቺንቴኔ፤ ሞርኮዋ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ኔኤኮ ዼኤፒ ማዔ ዎልቆና ኔና ዒፃ ሞርኮ ኔ ባሼኔ፤ ኔኤኮ ዻጋ ታሚጉዲ ዔኤቴሢሮ ዲኢሪጉዲ ዔያቶ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ባዞ ኔኤኒ ዑኡዜ ዎዶና ዋኣፃ ኩሊንቴኔ፥ ዓዳ ኮጬጉዲ ፒዝ ጌዒ ዔቄኔ፤ ዼኤፖ ዔቶይዳ ዓኣ ዋኣፃ ቶርጳዺ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ሞርኬ ማላዖ፦ ‹ዳውሲ ታ ዔያቶ ዓርቃንዳኔ፤ ቆሎዋ ታ ዔያቶኮ ጊሽታንዳኔ፤ ታ ሼና ጌዔሢጉዴያ ታ ዔካንዳኔ፤ ታኣኮ ዓፓሮና ታ ዔያቶ ዎዻንዳኔ› ሂዚ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ጋዓንቴ ናንጊና ናንጋ ጎዳሢዮ! ኔ ፔቴና ዑኡዛዛ ባዛ ዔያቶ ዔኤዼኔ፤ ባዞይዳ ዓንጊጉዲ ዔያታ ጌሊ ባይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ናንጊና ናንጋ ጎዳሢዮ! ካኣሽኪንታ ፆኦዞይዳፓ ቢያ ኔናጉዴያ ዖናዳይ? ጌኤሹሞና ሄርሺሳይ ቦንቾናኣ ዒጊቻይ፤ ኔ ዎልቄና ማዺንታ ሄርሺሳ ባኮ ማዻንዳይ ኔጉዴያ ዖናዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ሚዛቆ ኩጮ ኔ ዔቂሴ ዎዶና ሳዓ ኑ ሞርኮ ዔኤዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ናንጊና ናንጋ ናሹሞና ኔ ዓውሴ ዴሮኮ ቤርታ ኔ ዓርና ማዔኔ፤ ኔኤኮ ዶዱሞና ኔኤም ዱማዼ ሳዔሎ ዔያቶ ኔ ጌልዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ሜሌ ዴራ ቢያ ዬያ ዋይዜ ዎዶና ዒጊቹሞና ጎጋይቄኔ፤ ፒሊስፄኤሜ ዓጮ ዓሳ ዲቃቲሢና ጎይሢ ባይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ዔዶኦሜ ዓጮ ሱኡጋ ኮሺ ዑሣ ዓኣዼ ሜታዼኔ፤ ሞዓኣቤ ዓጮኮ ዼኤፖ ዓሳ ዒጊጪ ጎጋይቄኔ፤ ካኣናኔ ዓጮ ዴሮኮዋ ሄርሺንቶ ማሊፃ ባይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ዲቃቲሢና ዒጊቹሞና ዔያቶይዳ ጌሌኔ፤ ናንጊና ናንጋ ጎዳሢዮ! ኔኤኮ ዎልቆ ዔያታ ዛጌሢሮ ዓይላታፓ ኔኤኒ ኬሴ ኔኤኮ ዴራ ዖኦኪ ዓኣዻንዳያ ሄላንዳኣና ዔያታ ዲቃቲሢና ሹቺጉዲ ዚቲ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ናንጊና ናንጋ ጎዳሢዮ! ኔኤኒ ዎርቃኒ ማዤ ቤዞይዳ ኔኤኮ ኩጫ ማዤ ጌኤዦ ማኣሮይዳ ኔ ዴኔ ማዔ ዹኮይዳ ኔ ዴሮ ዔኪ ሙኪ ዒኢካ ኔኤኒ ጌሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ናንጊና ናንጋ ጎዳሢዮ! ኔኤኒ ናንጊና ካኣቲ ማዒ ናንጋንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ዒስራዔኤሌ ዓሳ ፃኣዺ ሳዓና ባዞ ቲቂ ፒንቄኔ፤ ጋዓንቴ ጊብፄ ካኣቲኮ ፓራሢ፥ ሳርጌሎ ዖይታ፥ ፓራሢና ዖላ ዓሳኣ ቢያ ባዞይዳ ጌላዛ ናንጊና ናንጋ ጎዳ ዋኣፆ ጊንሣ ማሄም ዋኣፃ ዔያቶ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ዓኣሮኔኮ ጌሮ፥ ፆኦሲ ማሊሢ ኬኤዛ፥ ማይራሞ ጎዖስኬና ካራቤ ዔኬኔ፤ ሜሌ ላኣላኣ ዬኖ ጎይፆ ፔኤኮ ታምቡሮ ዔኪ ባዒ ኮርጊ ኮርጊ ዒዞ ጊንፆ ዓኣዺሢ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ማይራማ ዓይኑሞ ዔያቶም ዴንሢ፦ «ፓራሢንታ ፓራሢና ዖላ ዓሶ ባዞይዳ ኬኤሪ ዼኤፒ ባሺሢ ዒ ዴንቄሢሮ ናንጊና ናንጋ ጎዳም ዓይናዹዋቴ» ጌይሢና ዓይናዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ሙሴ ዒስራዔኤሌ ዴሮ ዞቄ ባዞ ጊዴና ፒንሢ ሹኡሬ ጌይንታ ዓሲ ናንጉዋ ዳውሎ ዔኪ ዓኣዼኔ፤ ዬኖ ጎይፆ ሃይሦ ኬሊ ጉቤ ዔያታ ሃንቴኔ፤ ጋዓንቴ ፔቴታዖ ዋኣሢ ዔያታ ዴንቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ዬካፓ ማኣራ ጌይንታ ቤሲ ዔያታ ሙኪ ሄሌኔ፤ ጋዓንቴ ዒዞ ቤዞይዳ ዓኣ ዋኣፃ ጫንቺ ማዔሢሮ ዑሽካኒ ዔያታ ዳንዳዒባኣሴ፤ ማኣራ ጌይንቴሢያ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ዒማና ዴራ ሙሴ ዑፆይዳ ጉንዱሚ፦ «ዓካሪ ኑኡኒ ዓይጎ ዑሽካንዳይ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ሙሴያ ዼኤፒ ዒላቲና ናንጊና ናንጋ ጎዳ ሺኢቃዛ፥ ናንጊና ናንጋ ጎዳ ዒዛም ፔቴ ሚሢ ዻዌኔ፤ ዬኖ ሚፆ ዔኪ ዋኣፃ ዒዚ ዓጋዛ ዋኣፃ ዓኣፂ ዑሺም ጊኢጋያ ማዔኔ። ናንጊና ናንጋ ጎዳ ዔያታ ዎርቃንዳ ዎጌ ዬኖ ቤዞይዳ ዔያቶም ዒንጌኔ፤ ሃሣ ዔያታ ዒዛም ዓይሢንታቴያ ዓይሢንቱዋቴያ ዒኖ ዔያቶኮ ሙሪ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ሂዚ ዔያቶም ዒ ጌዔኔ፦ «ታ ቤርታ ኮሺ ማዔ ባኣዚ ማዺሢና ታኣኮ ዓይሢፆዋ ካፒሢና ጉቤ ዒናፓ ታኣም ዒንሢ ዓይሢንቴቴ ጊብፄ ዓጮ ዓሶ ዑፃ ታ ዔኪ ዬዔ ዶርዓሢዳፓ ፔቴናታዖ ታ ዒንሢ ሜታሳዓኬ፤ ዒንሢ ዻቂሻ፥ ናንጊና ናንጋ ጎዳሢያ ታናኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ዬካፓ ዔሊሜ ጌይንታ ቤዞ ዔያታ ሙኬኔ፤ ዒዞ ቤዞይዳ ታጶ ላምዖ ዋኣሢ ዓልቃ ቤሲና ላንካይታሚ ታሚሬ ጌይንታያ፥ ሜኤፄ ማላ ሙዖ ሚሢ ዓኣኔ፤ ዴራ ዒዞ ዋኣፆ ዓጮይዳ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ጉቤ ዒስራዔኤሌ ዓሳ ጊብፄፓ ኬስኬንቴ ላምዓሳ ዓጊኖኮ ታጶ ዶንጋሳ ኬሎና ዔሊሜፓ ዔያታ ዔቂ ሲናና ዔሊሜናኮ ሳዞይዳ ዓኣ «ሲኒ» ጌይንታ ዓሲ ናንጉዋ ዳውሎ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ዬኖ ዓሲ ናንጉዋ ዳውሎይዳ ቢያሢ ዎላ ቡኪንቲ ሙሴና ዓኣሮኔናይዳ ጉንዱሚሢና፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","«ናንጊና ናንጋ ጎዳ ኑና ዎንዴ ጊብፄይዳ ዓኣንቴ ዎዹዋዖ ዓይጎሮ ሃሼይ? ዒኢካ ሜሌ ባካ ዓቴቴ ዓሽኪ ማዔቶዋ ሜሌ ኑ ኮዓሢጉዴያ ሚርጌ ሙኡዚ ኑ ሙዓኒ ዳንዳዓኔ፤ ዒንሢ ጋዓንቴ ኑና ቢያሢ ናይዚና ኑ ኩዳንዳጉዲ ሃያ ዓሲ ናንጉዋ ዳውሎ ዔኪ ኬሴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሃይሾ ታኣኒ ዒንሢ ቢያሢም ጊዳንዳ ሙኡዚ ጫሪንጫፓ ዲኢኒሻኒኬ፤ ዴራ ቢያ ኬሊ ኬስኪ ኬስኪ ዒማ ኬሎም ጊዳንዳ ሙኡዚ ማንፂ ዔኮንጎ፤ ዬያይዲ ታኣኒ ዔያቶም ዒንጋ ዎጎ ዔያታ ካፓቴ ታ ዛጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ላሃሳ ኬሎና ጋዓንቴ ዔያታ ፔቴ ኬሊ ማንፂ ዔካዞይዳ ቃሲ ፔቴ ኬሊሮ ዔኪ ጊኢጊሾንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ሙሴና ዓኣሮኔና ጉቤ ዒስራዔኤሌ ዴሮም፦ «ጊብፄ ዓጫፓ ዒንሢ ዔኪ ኬሴሢ ናንጊና ናንጋ ጎዳታሢ ሃኖ ዒባኒ ዒንሢ ዔራንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ዚሮ ጉቴ ናንጊና ናንጋ ጎዳኮ ቦንቾ ፔጋሲ ዻዋ፥ ዓኣፒዳ ዱካ ፖዒ ዒንሢ ዛጋንዳኔ፤ ዒዛይዳ ዒንሢ ጉንዱሜያ ማዔሢ ናንጊና ናንጋ ጎዳ ዋይዜኔ፤ ዓይጎሮ ጌዔቶ ኑኡኒ ዒዚ ዒንጋ ዎጎ ማዾይዳ ፔኤሻያ ማዔሢሮ ኑጊዳ ዒንሢ ጉንዱሜሢ ዒዛይዳ ጉንዱሜያ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ዬካፓ ሙሴ ኬኤዛዖ፦ «ዒዛይዳ ዒንሢ ጉንዱሜሢ ዒዚ ዋይዜሢሮ ዒባኒ ዒንሢ ሙዓንዳ ዓሽኪንታ ዚሮ ጉቴ ጊንሣ ዒንሢ ኮዔሢጉዴያ ካሣ ዒንሢም ዒንጋንዳሢ ናንጊና ናንጋ ጎዳኬ፤ ኑ ዓይጎዳይ? ኑጊዳ ዒንሢ ጉንዱሜኔ ጌይፃ ናንጊና ናንጋ ጎዳይዳ ዒንሢ ጉንዱሜኔ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ሙሴ ዓኣሮኔም፦ «ናንጊና ናንጋ ጎዳ ዒዛይዳ ዔያታ ጉንዱሜያ ማዔሢ ዋይዜሢሮ፥ ጉቤ ዒስራዔኤሌ ዴራ ሙኪ ዒዛ ቤርታ ዔቃንዳጉዲ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ዓኣሮኔ ጉቤ ዓሶም ኬኤዛዛ፥ ቢያሢ ዓኣፖ ካሮ ዓሲ ናንጉዋ ዳውሎ ባንሢ ሺርሺ ዛጌኔ፤ ዬማና ናንጊና ናንጋ ጎዳኮ ቦንቾ ፔጋሳ ዓኣፒዳ ዱካ ፖዒ ሻኣሬና ዎላ ጴዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ናንጊና ናንጋ ጎዳ ሙሴም ኬኤዛዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«ዒስራዔኤሌ ዓሳ ታጊዳ ጉንዱሜሢ ታ ዋይዜኔ፤ ዬያሮ ሂዚ ጌዒ ዔያቶም ኬኤዜ፥ ‹ሃኖ ዓባ ጌላንዳሢኮ ቤርታ ዒንሢም ሙኡዚ ማዓንዳ ዓሽኪ ዒንሢ ዴንቃንዳኔ፤ ዚሮ ጉቴ ዒንሢ ኮዓሢጉዴያ ካሣ ዴንቃንዳኔ፤ ያዺ ማዔስካፓ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲታሢ ዒንሢ ዔራንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ዬኖ ዋንቶ ሚርጌ ፑሮ ማላ ካፒ ባራኒ ሙኪ ጉርዶ ባይዚ ዴዔኔ፤ ዚሮ ጉቴ ጊንሣ ጉርዶ ዓጫ ዖልካዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ዬይ ዖልካ ፃኣዼስካፓ ዻካ ሺኢቺ ባኣዚ ዓሲ ናንጉዋ ዳውሎይዳ ጴዼኔ፤ ዬና ባካ ሳዖይዳ ኬዲ ላሄያ ቦኦሬ ሻኣዣ ባኣዚኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ዒስራዔኤሌ ዓሳ ዬያ ዛጋዖ ዓይጎታቴያ ዔሪባኣሢሮ፦ «ሃይ ዓይጎ ባኣዚዳይ?» ጌዒ ዎሊ ዖኦጬኔ። ሙሴ ዔያቶም፦ «ሃይ ዒንሢ ሙዓንዳጉዲ ናንጊና ናንጋ ጎዳ ዒንጌ ሙኡዚኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ዒንሢ ፔቴ ፔቴሢ ዒንሢም ኮይሳ ጎይፆጉዴያ ሌሊ ማንፂ ዔካንዳጉዲ ናንጊና ናንጋ ጎዳ ዓይሤኔ፤ ዬያሮ ፔቴ ፔቴ ማኣሮይዳ ዓኣ ዓሳ ቶኦካ ቶኦካ ፔቴ ጎሜሬ ዔኮንጎ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ዒስራዔኤሌ ዓሳ ዬኖ ጎይፆ ማዼኔ፤ ፔቴ ፔቴ ዓሳ ሚርጌ፥ ዛላ ዻካ ቡኩሲ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ዔያታ ዔካዖ ማካዛ፥ ሚርጌ ቡኩሲ ዔኬሢም ዑሣ ዓኣዺ ዺቢባኣሴ፤ ጊንሣ ዻካ ቡኩሲ ዔኬሢም ፓጪባኣሴ፤ ፔቴ ፔቴሢ ቡኩሲ ዔኬሢ ጊዳንዳማ ጉዴያ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ሙሴ ዓሶም፦ «ዖና ማዔቶዋ ሃናኣ ኬሎም ኮይሳማፓ ዑሣ ዓኣሢ ዚራኣሮ ጌሣንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ፔቴ ፔቴ ዓሳ ጋዓንቴ ሙሴ ኬኤዜሢ ዋይዞ ዒፂ ዬኖ ኬሎም ቡኩሴሢዳፓ ፓቂ ዎይሤኔ፤ ዬያሮ ዚሮ ጉቴሎ ዎዒ ዛልቂ ዛዓያ ማዔኔ፤ ሙሴ ዒማና ዔያቶ ኮሺ ጎሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ጉቶ ጉቶ ፔቴ ፔቴሢ ፔኤም ጊዳንዳማ ጉዴያ ቡኩሲ ዔካኔ፤ ዓባ ዖይዼስካፓ ጋዓንቴ ሳዖይዳ ዓቴሢ ቢያ ዓልቂ ዓልቃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ላሃሳ ኬሎና ፔቴ ፔቴሢ ላምዖ ጎሜሬ ማዓንዳያ ቡኩሲ ዔካኔ፤ ዱማ ዱማ ፓቂንቴ ዺቦ ዓሶኮ ሱኡጋ ቢያ ሙኪ ዬኖ ሙዖ ዛሎ ሙሴም ሃይሶ ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ዒዚ ዔያቶም፦ «ዚራኣ ኬላ ዒዛም ዱማዼ ሃውሾ ኬሊ ማዓንዳጉዲ ናንጊና ናንጋ ጎዳ ዓይሤኔ፤ ዬያሮ ሃኖ ዒንሢ ላኣዳ ባኮ ላኣዱዋቴ፤ ካሣ ባኮዋ ካሡዋቴ፤ ዓቴሢ ዚራኣሮ ዓቶንጎ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ዬካፓ ዔያታ ሙሴ ዓይሤ ጎይፆ ዓቴሢ ዚራኣ ኬሎም ጌሤኔ፤ ዬይ ጋዓንቴ ዎዒ ዛልቂ፥ ዛዒያ ዛዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ሙሴ ዔያቶም፦ «ሃያ ሃኖ ሌሊ ሙሙዑዋቴ፤ ሃኖ ናንጊና ናንጋ ጎዳም ዱማዼ ሃውሾ ኬሊኬ፤ ዬያሮ ሃናኣ ኬሎና ሙዖ ቦኦሎይዳ ዒንሢ ዴንቃዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ዬያሮ ላሆ ኬሎ ቢያ ዓቱዋዖ ሙዖ ቡኩሱዋቴ፤ ሃውሾ ኬሎ ማዔ ላንካሳ ኬሎና ጋዓንቴ ፔቴታዖ ሙኡዚ ጴዺንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ላንካሳ ኬሎና ዴሮ ባኣኮይዳፓ ዻካ ዓሲ ሙዎ ባኮ ዔካኒ ኬስኬኔ፤ ጋዓንቴ ፔቴታዖ ዴንቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዒንሢ ታኣኮ ዓይሢፆ ኩንሢፆ ዒፃሢ ዓይዲ ሄላንዳኣናዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ታኣኒ፥ ናንጊና ናንጋ ጎዳ ፔቴ ሃውሾ ኬሊ ዒንሢም ዒንጌሢ ጶቂሡዋቴ፤ ቢያ ኬሊ ላሃሳ ኬሎና ላምዖ ኬሊም ጊዳንዳ ሙኡዚ ታ ዒንሢም ዒንጋሢ ዬያሮኬ፤ ላንካሳ ኬሎና ፔቴ ፔቴሢ ማኣራፓ ኬስኩዋዖ ዓኣ ቤዞይዳ ቢያ ሃውሺ ፔኤቆንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ያዺ ጌይንቴሢሮ ዴራ ላንካሳ ኬሎና ፔቴታዖ ማዾ ማዺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ዒስራዔኤሌ ዴራ ዬኖ ሙዖ «ማና» ጌዔኔ፤ ዬና ባካ ዻካ ቦኦሬ፥ ጋኣሺ ዓኣፒ ማላያኬ፤ ዓኣሡማ ዔኤሲና ዎላ ላኣዲንቴ ላኣዳ ጉዴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ሙሴ፦ «ኑና ዒዚ ጊብፄ ዓጫፓ ዔኪ ኬሴያና ዓሲ ናንጉዋ ዳውሎይዳ ኑ ሙዓንዳጉዲ ዒንጌ ሙዓ ሃያ ማዔሢ ሙካ ሾይንታ ዛጋንዳጉዲ ማና ኑ ጌሦም ናንጊና ናንጋ ጎዳ ኑና ዓይሤኔ» ጋዓዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ዓኣሮኔም፦ «ፔቴ ዖቲ ዔኪጋፓ ፔቴ ጎሜሬ ማዓንዳያ ማና ዔኪ ዒኢካ ሃጊ ሙካ ሾይንቶም ናንጊና ናንጋ ጎዳ ቤርቶይዳ ካፒንቲ ዴዓንዳጉዲ ጌሤ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ዓኣሮኔ ሃጊ ሙካ ሾይንቶም ዒኢካ ጌሢንቲ ዴዓንዳጉዲ ጫኣቁሞ ታኣቦቶ ጌይንታ ሳኣፂኖ ቤርታ ማናሢ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ዒስራዔኤሌ ዓሳ ናንጋንዳ ካኣናኔ ዓጮ ዛጶ ሄላንዳኣና ዖይዲታሚ ሌዔ ጉቤ ዬኖ ማና ጌይንታ ሙዖ ዔያታ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ዬኖ ዎዶና ዔኤቢ ማኮ ዔርቴ ባኮንሢ ዒፔና ጎሜሬናኬ፤ ዒፔ ጌይንታዛ ታጶ ዶንጎ ኪሎ ማዓያ ማዓዛ፥ ጎሜሬ ፔቴ ኪሎና ዛላና ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ጉቤ ዒስራዔኤሌ ዴራ ናንጊና ናንጋ ጎዳ ዓይሢፆና ፔቴ ቤዛፓ ሜሌ ቤሲ ዓኣዺ ዓኣዺ ጋዓኣና «ሲኒ» ጌይንታ ዓሲ ናንጉዋ ዳውሎ ሃሺ ዴንዲ ሬፕዲሜ ጌይንታዞይዳ ዱንኪ ዴዔኔ። ጋዓንቴ ዬኖ ቤዞይዳ ዑሽኮ ዋኣሢ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ዬያሮ፦ «ኑ ዑሽካንዳ ዋኣሢ ኑኡም ዒንጌ!» ጌዒ ሙሴይዳ ዔያታ ዒላቴኔ። ሙሴ ዒማና፦ «ዒንሢ ዓይጎሮ ታና ማኪ ጌስታይ? ሃሣ ዓይጎሮ ናንጊና ናንጋ ጎዳ ዎይታቴያ ኑ ዛጎም ዒንሢ ጋዓይ?» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ዴራ ጋዓንቴ ሚርጌና ዼኤቢንቴያ ማዔሢሮ፦ «ጊብፄ ዓጫፓ ኑና ኔ ዓይጋ ኬሴይ? ኑናንታ ኑ ናኣቶንታ ሃሣ ኑ ቆልሞንታ ዎላ ቢያ ዋኣሢ ዼኤቢና ኩርሲሳኒዳ?» ጌዒ ሙሴ ዑፃ ጉንዱሚፆ ሃሾ ዒፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ሙሴ፦ «ሃያ ዴሮ ዓካሪ ታ ዎዎዴቶ ኮሽካንዳይ? ሃይሾ ሃይ ዓሳ ታና ሹቻ ዹዓኒ ጊኢጌኔ» ጌዒ ናንጊና ናንጋ ጎዳ ባንሢ ዒላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዒስራዔኤሌ ዴሮ ሱኡጎይዳፓ ዛላ ዻካ ዓሲ ዔኪጋፓ ዴሮኮ ቤርታ ዓኣዼ፤ ዓባዬ ዎሮ ኔ ጳርቄ ኮኦሌሎዋ ኩጫ ዓርቄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ታኣኒ ሲና ዹኮይዳ ዓኣ ላሎ ዑፃ ኔ ቤርታ ዔቃንዳኔ፤ ኔኤኒ ላሎ ሹጮ ጳርቄ፤ ዴራ ዑሽካንዳ ዋኣሢ ጋራፓ ዓልቂ ኬስካንዳኔ» ጋዓዛ፥ ሙሴ ዒስራዔኤሌ ዴሮ ሱኡጎ ቤርታ ዬኖ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ዬና ቤዛ ማሳሄ ጊንሣ ሃሣ ሜሪባ ጌይንቴኔ፤ ዓይጎሮ ጌዔቶ ዒስራዔኤሌ ዓሳ «ናንጊና ናንጋ ጎዳ ኑኡና ዎላሞ? ዎላቱዋይ?» ጌዒ ጉንዱሚፆና ሃሣ «ዒ ዎይታቴያ ኑ ዛጋንዳኔ» ጌዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ዒስራዔኤሌ ዓሳ ሬፕዲሜ ጎዖ ቤዛ ዓኣንቴ ዓማሌቄ ዓሳ ሙኪ ዔያቶ ዖሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ሙሴያ ዒያሱም፦ «ዻካ ዓሲ ዶኦሪ ዔኪጋፓ ዚራኣ ኬሎና ዓማሌቄ ዓሶ ዖሌ፤ ታኣኒያ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ ማዻንዳጉዲ ፆኦሲ ታኣም ዒንጌ ኮኦሌሎ ዔኪ ጌሜሮ ዑፆ ኬስኪ ዔቃንዳኔ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ዒያሱ ሙሴኮ ዓይሢፆ ኩንሢ ዓማሌቄ ዓሶ ዖላኒ ዴንዴኔ፤ ሙሴና ዓኣሮኔና ሃሣ ሁኡሬ ጎዖሢና ጌሜሮ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ዬካፓ ሙሴ ፔ ኩጮ ጫሪንጮ ባንሢ ዔቂሳኣና ዒስራዔኤሌ ዓሳ ዖሎና ባባሻኔ፤ ኩጮ ዒዚ ሊካ ኬይሳኣና ጋዓንቴ ዓማሌቄ ዓሳ ጊንሣ ዶዲ ዶዲ ባሻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ዬያሮ ሙሴኮ ኩጫ ዶጫሢሮ ዓኣሮኔና ሁኡሬና ሹቺ ዔኪ ዬዒ ሙሴ ዴዓንዳጉዲ ጌሢ ዴይሤኔ፤ ዬካፓ ሻውሎና ሚዛቆ ዛሎናይዳ ቃሶ ዒዛኮ ኬኤሊንቂ ዓርቂ ዔቂ ዴንዲ ዓባ ጌላንዳያ ሄላንዳኣና ፔኤቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ዬያይዲ ዒያሱ ዓማሌቄ ዓሶ ዖሊ ባሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ቢያ ዎዴና ማሊንቲ ማሊንቲ ናንጋንዳጉዲ ሃኖ ባሺፆ ሃይሶ ፃኣፔ፤ ዒያሱማኣ ጊንሣ ዓማሌቄ ዓሶ ኩርሲ ታ ባይዛንዳያ ማዔሢ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ሙሴ ዒማና ፆኦሲም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮንዶ ቤሲ ሹቺና ኮሺ፦ «ናንጊና ናንጋ ጎዳ ታኣኮ ባሺፆ ዔርዛ ባንዲራሢኬ» ጌዒ ሱንሢ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ዒዚ ሃሣ «ናንጊና ናንጋ ጎዳኮ ባንዲሮ ዼጊዲ ዓርቁዋቴ!፤ ናንጊና ናንጋ ጎዳ ዓማሌቄ ዓሶ ቢያ ዎዴ ዖሌ ጎይሣ ዴዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ፆኦሲ ጊብፄ ዓጫፓ ሙሴና ዒስራዔኤሌ ዴሮና ዔኪ ኬሴያና ዔያቶም ማዼ ባኮ ቢያ ሚዲያሜ ዓጮኮ ቄኤሴ ማዔ፥ ሙሴኮ ባይሲ፥ ዮቴሬ ዋይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ዬያሮ ሙሴ ዒዛ ኮራ ቤርታ ሃሺ ዓኣዼ ዒዛኮ ማቾ ሲፓራንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ላምዖ ዓቲንቆ ናኣቶንሢንታ ዎላ ዔኪ ሙኬኔ፤ ሙሴ፦ «ዓሲ ዓጪዳ ታ ሙኬ ዓሲኬ» ጌዒ ቶይዶ ናዓሢኮ ሱንፆ ጌርሾሜ ጌይ ቤርታ ጌሤያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ዬያጉዲ፦ «ታ ዓዶ ፆኦዛሢ ታና ማኣዴኔ፤ ጊብፄ ዓጮ ካኣቲ ታና ዎዹዋጉዲ ዓውሴኔ» ጌዒ ላምዓሳ ናዓሢኮ ሱንፆ ዔኤሊዔዜሬ ጌዒ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ዮቴሬ ሙሴኮ ማቾና ዒዞኮ ላምዖ ናኣቶንሢና ዎላ ዓሲ ናንጉዋ ዳውሎይዳ ሙሴ ዱንኪ ዴዔ፥ ፆኦሲ ዹኮ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ዔያቶኮ ሙኪፆ ዔርዛኒ ሙሴም ኪኢታ ቤርታ ዳኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ዬያሮ ሙሴ ዒዛ ጎይሣ ዔካኒ ኬስኬኔ፤ ዴንቄ ዎዶናኣ ቶኦኮ ሂርኪዲ ቦንቾ ዔኤሊሢ ዔኤሊ ሄርቄኔ፤ ዔያታ ቢያሢ ኮሺ ማዒፆ ዎሊ ዖኦጬስካፓ ሙሴኮ ማኣሪ ዎላ ጌሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ዓውሳኒ ጊብፄ ዓጮ ካኣቲና ዒዛኮ ዴሮናይዳ ማዼ ዲቃሢ ሄርሺሳ ባኮ ቢያ ሙሴ ዮቴሬም ኬኤዜኔ። ሃሣ ጊንሣ ዴራ ጎይፆይዳ ዓኣንቴ ዎዚጉዴ ዶዲ ሜታ ዔያቶና ካኣሜቶዋ፥ ናንጊና ናንጋ ጎዳኣ ዔያቶ ዎዲ ዓውሴቶዋ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ዮቴሬ ዬያ ቢያ ዋይዛዖ ናንጊና ናንጋ ጎዳ ጊብፄ ዓሶ ኩጫፓ ዒስራዔኤሌ ዓሶ ዓውሳኒ ማዼ ኮዦ ባኮና ዎዛዺ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","«ጊብፄ ዓጮ ካኣቲና ዒዛኮ ዴሮና ኩጫፓ ዒንሢ ዓውሴ፥ ናንጊና ናንጋ ጎዳሢ ጋላቲንቴያ ማዖም፤ ዴሮዋ ዓይላታፓ ኬሴ ናንጊና ናንጋ ጎዳ ጋላቲንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ናንጊና ናንጋ ጎዳ ካኣሽኪንታ ፆኦዞ ቢያይዳፓ ባሻያ ማዔሢ ዓካሪ ታኣኒ ዔሬኔ፤ ዓይጎሮ ጌዔቶ ጊብፄ ዓጮ ዓሳ ዒስራዔኤሌ ዴሮ ዑፆይዳ ዖቶርቂ ዬያጉዴ ቦርሲሳ ባኣዚ ማዼሢሮ ሃያጉዴ ዲቃሢ ሄርሺሳ ባኣዚ ናንጊና ናንጋ ጎዳ ማዼኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ዬካፓ ዮቴሬ ቢያ ሚቺንቲ ዒንጊንታንዳ ባኣዚና ፆኦሲም ዒንጊንታንዳ ሜሌ ዒንጊሢ ዔኪ ሙኬኔ፤ ዓኣሮኔንታ ዒስራዔኤሌ ዴሮኮ ሱኡጎንታ ሙሴ ባይሲና ዎላ ካኣዦም ዱማሶና ሙዖ ሙዓኒ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ዚሮ ጉቴሎ ሙሴ ዴሮ ባኣኮይዳ ዓኣ ዑሮና ማርማሢና ዛሎ ጌስቲ ዎጋኒ ዴዔኔ፤ ዴራ ዒዛኮ ዓጫ ቡኪ ዔቄም፥ ማዻ ዒዛም ዺቤሢሮ ጉቴፓ ዴንዲ ዒባኒ ሄላንዳኣና ዒ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ዮቴሬ ሙሴ ማዻ ባኮ ቢያ ዛጌስካፓ፦ «ኔ ዎዎይታዖ? ዴራ ኔኤና ጌስታኒ ጌዒ ጉቴፓ ዴንዲ ዒባኒ ሄላንዳኣና ኔ ኮሮይዳ ዔቄም፥ ሃያ ባኮ ቢያ ዎይሣ ዓሲ ማዒ ዛጋኒ ዓይጋ ኔ ኔኤሮ ሌሊ ዴዒ ላባይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ሙሴ ማሃዖ፦ «ታኣኒ ሃያ ቢያ ማዻሢ ዴራ ፆኦሲ ማሊፆ ዔራኒ ታ ባንሢ ሙካሢሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ላምዖ ዓሲ ዎላ ዑራዺ ታ ኮራ ሙኬቶ ዎይ ፒዜታቶዋ ታ ዔርዛኒ ፆኦሲኮ ዎጎና ዓይሢፆና ዔያቶም ኬኤዛኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ዬካፓ ዮቴሬ ሂዚ ጌዔኔ፦ «ሃይ ኔ ማዻ ባካ ቢያ ፒዜቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ኔናንታ ዴሮንታ ኔ ጉሪ ላቢሳኔ፤ ኔ ኔኤሮ ሌሊ ማዒ ሃያ ቢያ ማዻኒ ኔኤም ዴኤሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ሂንዳ ታኣኒ ፔቴ ባኣዚ ኔና ዞሮም፤ ፆኦሲያ ኔኤና ዎላ ማዓንዳኔ፤ ዴሮ ዛሎ ፆኦሲ ቤርቶ ኔኤኮ ሺኢኪፆና ዔያቶኮ ዓኣ ባኮ ዒዛ ቤርቶ ሺኢሺፃ ፒዜኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ኔኤኒ ፆኦሲኮ ዓይሢፆ ዔያቶ ዔርዛኒ፥ ሃሣ ዔያታ ዎይቲ ናንጋኒና ማዻኒ ኮይሳቴያ ፔጋሲ ኬኤዛኒ ኔና ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ጋዓንቴ ዬያይዳ ቃሲ ዔራቶ ዓኣ ዓሲ ዶኦሪ ዴሮ ዑፆይዳ ሺያ ዓሲ ዎይሣያ፥ ፄኤታ ዓሲ ዎይሣያ፥ ዶንጊታሚ ዓሲ ዎይሣያና፥ ታጶ ዓሲ ዎይሣያ ማሂ ጌሤ። ዬያታ ፆኦሲ ዒጊጫያ፥ ጉሙርቂንታያና ዴሜና ዒንጎ ባኣዚናኣ ጌሺንቱዋያ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ዔያታ ቢያ ኬሊ ሙኪ ሙኪ ሚርጌ ዴኤሢ ማዒባኣ ባኮ ዛጊ ዎጎንጎ፤ ዔያቶኮ ዑሣ ማዔ ዴኤፃ ባኣዚ ጋዓንቴ ኔ ኮራ ዔኪ ሙኮንጎ፤ ዔያታ ዬያይዲ ኔ ባሶ ፓቂ ዔኬቶ ማዻ ኔኤም ሼሌዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ዬያይዲ ኔ ማዼቶ፥ ሃሣ ዬይያ ፆኦሲ ማሊሢ ማዔቶ ኔና ኔ ጉሪ ላቢሳዓኬ፤ ዴራ ሼሌዔና ሃይሳ ዔያቶኮ ጋፔም ፔ ማኣሪ ማኣሪ ዓኣዻንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ዬያሮ ሙሴ ዒዛኮ ባይሲ፥ ዮቴሬ ዞሬ ዞሮ ቢያ ዔኪ ማዾይዳ ፔኤሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ዒዚ ዒስራዔኤሌ ዓሶ ቢያሢ ባኣካፓ ዔራቶ ዓኣ ዓሲ ዶኦሪ፥ ሺያ ዓሲ ዎይሣያ፥ ፄኤታ ዓሲ ዎይሣያ፥ ዶንጊታሚ ዓሲ ዎይሣያ፥ ታጶ ዓሲ ዎይሣያ ማሂ ዴሮ ዑፃ ቢታንቶ ዓኣያ ማዓንዳጉዲ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ዔያታ ዴኤሢ ማዒባኣ ሃይሶ ዛጊ ዛጊ ዴሮም ቢያ ኬሊ ዎጊሢ ዓርቄኔ፤ ኮሺ ሜታሳያ ማዔ ባኮ ሌሊ ሙሴ ባንሢ ዳካዖ፥ ሼሌዔ ማዔ፥ ዑራና ጎሪንቲና ማዔ ባኮ ቢያ ዔያታ ፔኤሮ ጌስቲ ኩንሣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ዬካፓ ሙሴ ዮቴሬ ሳራሢ ዳኬኔ፤ ዮቴሬያ ፔ ዓጮ ማዒ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ዒስራዔኤሌ ዓሳ ጊብፄ ዓጫፓ ኬስኬንቴ ሃይሣሳ ዓጊኖኮ ቤርታሳ ኬሎና ዓሲ ናንጉዋ ዳውሎ ሲና ሙኪ ሄሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ዔያታ ሬፕዲሜይዳፓ ዔቂ ዓሲ ናንጉዋ ዳውሎ፥ ሲና ባንሢ ዓኣዺ ዹኮኮ ቤርቶ ዛሎይዳ ዓኣ ዳውላ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ዒማና ሙሴ ፆኦሲና ጌስታኒ ዹኮ ኬስካዛ፥ ናንጊና ናንጋ ጎዳ ዹኮ ዑፆይዳ ሙሴም ኬኤዛዖ ያይቆኦቤ ዜርፆ ማዔ ዒስራዔኤሌ ዓሶም ሂዚ ጌዒ ኬኤዛንዳጉዲ ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","« ‹ታኣኒ ጊብፄ ዓጮ ዓሶ ዑፆይዳ ማዼ ባኮንታ ኮኦኬ ፔኤኮ ናኣቶ ጋኣዞና ዔካሢጉዲ ታኣኒያ ዒንሢ ሃማ ቤዞ ሄላንዳኣና ዎዲ ታ ባንሢ ዔኪ ዬዔቶዋ ዒንሢ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ሃሢያ ሃይሾ ዒንሢ ታኣም ዓይሢንቲ፥ ታ ዒንሢና ጫኣቄ ጫኣቁሞዋ ካፔቶ ታኣም ዱማዼ ዴሬ ዒንሢ ማዓንዳኔ፤ ሳዓ ዎዚ ቢያ ታኣሮ ማዔቶዋ ዒንሢ ታኣም ዶኦሪንቴያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ሃሣ ታኣም ሌሊ ዱማዼያ ጌኤሺ ዴሬ ማዓንዳኔ፤ ቄኤሴጉዲ ማዒ ታኣም ዒንሢ ማዻንዳኔ፤› ዒስራዔኤሌ ዴሮም ኔ ኬኤዛንዳሢ ሂዚ ጌዒኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ዬያሮ ሙሴ ዹካፓ ኬዲ ዴሮኮ ሱኡጎ ቢያ ፔቴይዳ ዔኤሊ፥ ናንጊና ናንጋ ጎዳ ዒዛም ዓይሤ ዓይሢፆ ቢያ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ዬካፓ ዴራ ፔቴ ዑኡሲና ዎሊ ዑፃ፦ «ናንጊና ናንጋ ጎዳ ዓይሤሢ ቢያ ኑ ኩንሣንዳኔ» ጋዓዛ፥ ሙሴ ዬያ ጊንሣ ናንጊና ናንጋ ጎዳም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ታኣኒ ዼኤፒ ሻኣሬና ኔ ባንሢ ሙካንዳኔ፤ ዬያሮ ዴራ ታኣኒ ኔኤና ዎላ ጌስታኣና ዋይዚ፥ ሃካፓ ሴካ ኔ ጋዓ ባኮ ቢያ ጉሙርቃንዳኔ» ጌዔኔ። ሙሴ ዒማና ዴራ ማሂ ጌዔ ባኮ ናንጊና ናንጋ ጎዳም ኬኤዛዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ናንጊና ናንጋ ጎዳ ሂዚ ዒዛም ጌዔኔ፦ «ዴሮ ባንሢ ዓኣዼ፤ ናንጊና ናንጋ ጎዳም ዱማዼያ ማሂ ዔያቶ ሺኢሻኒ ሃኖና ዚሮናይዳ ዑፆ ጌኤሻንዳጉዲ፥ ዓፒሎዋ ፔኤኮ ማስካንዳጉዲ ዔያቶም ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ሃይሣሳ ኬሎና ዴሮ ቤርቶይዳ ሲና ዹካ ታ ኬዳንዳሢሮ ቢያሢ ዬኖ ኬሎም ጊኢጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ኔኤኒ ዹኮኮ ዓጮይዳ ዛጲ ጌሤ፤ ዴራ ዬኖ ዛጶ ጊዴና ዓኣዺ ዹኮ ኬስኩዋጉዲ፤ ሃሣ ዹኮ ባንሢ ዑኪያ ዑኩዋጉዲ ኬኤዜ፤ ዓይጎ ዓሲታቶዋ ጌሢንቴ ዛጶ ጊዴና ዓኣዺ ዹኮ ሄሌቶ ዎዺንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ዬይ ዓሢ ዖኦኒያ ሄሉዋንቴ ሹቻ ዹዒንቲ፥ ሃሣ ፓልዔና ዱኪንቲ ሃይቆንጎ፤ ዬኖ ማዼ ዓሲታቶዋ ቆልሞ ዬኖ ጎይፆ ሃይቆንጎ፤ ዴራ ዹኮ ኬስካኒ ኮይሳሢ ዼግ ጌዔ ዑኡሲና ዛያ ዋርቂንታ ዎዶና ሌሊኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ዒማና ሙሴ ዹካፓ ኬዲ ዴራ ፆኦሲ ካኣዦም ጊኢጊንታንዳጉዲ ኬኤዛዛ፥ ዴራ ፔኤኮ ዓፒሎ ማስኪ ጊኢጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ጊንሣ ሙሴ ዴሮም፦ «ሂንታኣ ኬሎማኣ ጊኢጊንቱዋቴ፤ ዬኖ ኬሎና ላኣሊና ላሂፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ሃይሣሳ ኬሎ ጉቴ ጉጉንሢ ዑኡሲ ዋይዚንቴኔ፤ ጊንሣ ዜኤሊንሢና ዲም ጌዔ ሻኣሬና ዹኮ ዑፃ ጴዼኔ፤ ዬያጉዲ ዼኤፒ ዛዬ ዑኡሲያ ዋይዚንቴኔ። ዴራ ዱንኪ ዴዒ ዓኣ ቤዛ ዓኣዖ ዒጊጪ ጎጋይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ዬማና ሙሴ ዔያቶ ጉርዳፓ ዔኪ፥ ፆኦሲ ባንሢ ኬሴኔ፤ ዔያታኣ ዹኮኮ ዴማ ሙኪ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ዬኖ ዓቦ ናንጊና ናንጋ ጎዳ ታሚና ኬዴሢሮ ጉቤ ሲና ዹካ ጩቢና ካንቂንቴኔ። ጩባ ታሚ ናኣቦይዳፓ ኬስካያጉዲ ዢባሮይዳ ጩቢ ኬስኬኔ፤ ዬያሮ ዴራ ኮሺ ዒጊጪ ጎጋይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ዛያሢኮ ዼኤፖ ዑኡዛኣ ጊዳ ቃሲ ቃሲ ዎሊ ጊንፆ ዖኦሊሢ ዓርቄኔ፤ ዒማና ሙሴ ጌስታኣና ፆኦሲ ጉጉንሢና ዒዛም ማሂ ኬኤዛኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ናንጊና ናንጋ ጎዳ ሲና ዹኮ ቶኦኮይዳ ኬዲ፥ ዹኮኮ ቶኦኮ ኬስካንዳጉዲ ሙሴ ዔኤሌኔ፤ ሙሴያ ዬያ ዹኮ ኬስካዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ናንጊና ናንጋ ጎዳ፦ «ታና ዛጋኒ፥ ጌሢንቴ ዛጶ ጊዴና ዓኣዺ ታ ባንሢ ሙኩዋጉዲ ኬዲ ዴሮም ኬኤዜ፤ ያዺ ዔያታ ማዼቶ ዔያቶይዳፓ ሚርጌሢ ሃይቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ማዾሮ ታ ባንሢ ሙካ ቄኤሳታዖ ዓቱዋ ፔና ጌኤሾንጎ፤ ያዺ ማዒባኣቶ ታ ዔያቶይዳ ፑርታ ባኣዚ ዓጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ሙሴያ ናንጊና ናንጋ ጎዳም፦ « ‹ዹኮኮ ዓጮ ቆኦሪ ማሂ ፆኦሲም ዱማሴ› ጌዒ ታና ኔ ዓይሤ ጎይፆና ማዺንቴሢሮ ዴራ ዛጶ ጊዴና ዓኣዺ ዹኮ ኬስካኒ ዳንዳዑዋሴ» ጌዒ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ናንጊና ናንጋ ጎዳ ጊንሣ፦ «ኬዲጋፓ ዓኣሮኔ ዔኪ ሙኬ፤ ቄኤሶ ማዔቶዋ ዴራ ታ ባንሢ ኬስካኒ ዛጶ ጊዴና ዓኣዻንዳያ ኮይሱዋሴ፤ ያዺ ዔያታ ማዼቶ ታ ዔያቶይዳ ፑርታ ባኣዚ ዓጋንዳኣኬ» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ሙሴ ዴሮ ባንሢ ኬዲ ፆኦሲ ዓይሤ ባኮ ቢያ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ፆኦሲ፥ ሃካፓ ሊካ ዓኣ ዓይሢፆ ዴሮም ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","ዒስራዔኤሌ ዴሬዮቴ! ዒንሢ ዓይላቶና ናንጌ ጊብፄ ዓጬሎይዳፓ ዔኪ ኬሴሢ ታና ዒንሢኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ታጊዳፓ ዓታዛ ሜሌ ፆኦዞ ካሽኪፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ጫሪንጮይዳ ማዖም ሳዓ፥ ሃሣ ሳዖኮ ዴማ ዓኣ ዋኣፆይዳ ናንጋ ባኮይዳፓ ዓይጌንዴ ባኣዚኮታዖ ማላታ ኔኤኮ ካኣሽኮ ባኣዚ ማሂ ማዢፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ታኣኒ፥ ኔኤኮ ፆኦሲ፥ ናንጊና ናንጋ ጎዳሢ ሜሌ ፆኦዛ ካኣሽኪንታንዳጉዲ ኮዑዋያ ማዔሢሮ ዓርሲንቲ ኮሺንቴ ዓይጎ ባኣዚታቴያ ካሽኪፖ፤ ሃሣ ዬያም ዚጊፖ፤ ታኣኒ፥ ታና ዒፃ ዓሶ ቢያይዳ ፑርታ ባኣዚ ዓጋያኬ፤ ዜርፆዋ ዔያቶኮ ዴንዲ ሃይሦና ዖይዶ ሾይንቲ ሄላንዳኣና ኮሜ ታ ኮፃ ፆኦሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ታና ናሽካዞንሢና ታኣኮ ዓይሢፆ ካፓዞንሢም ቢያ ጋዓንቴ ዴንዲ ሺያ ሾይንቲ ሄላንዳኣና ታኣኮ ናንጊና ናንጋ ናሹሞ ታ ፔጋሲ ዻዋያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ታና፥ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢኮ ሱንፆ ማዒባኣ ባኣዚና ዔኤሊፖ፤ ታ ሱንፆ ማዒባኣ ባኣዚና ዔኤላሢ ቢያ ዻቢንቴያ ማሂ ታ ፓይዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ሃውሾ ኬሎ ዱማሲ ቦንቼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ኔ ማዾ ኔኤኒ ማዻንዳ ላሆ ኬሊ ኔኤም ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ላንካሳ ኬላ ጋዓንቴ ታኣም ዱማዼ ሃውሾ ኬሊኬ፤ ዬኖ ኬሎና ዓይጎ ዓሲታቶዋ ማዾ ማዾፓ፤ ኔና ማዖም ኔ ናኣታ፥ ኔኤም ማዻ ዓሶዋ ማዖም ቆልማ፥ ኔ ዓጮይዳ ሙኬ ዓሲ ማዒ ናንጋ ዓሲ ማዔቴያ ፔቴታዖ ማዾ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ናንጊና ናንጋ ጎዳ ጫሪንጮንታ ሳዖንታ ዼኤፖ ባዞንታ ዬያይዳ ዓኣ ባኮ ቢያ ላሆ ኬሊዳ ማዤኔ፤ ላንካሳ ኬሎና ጋዓንቴ ሃውሼኔ፤ ናንጊና ናንጋ ጎዳ ሃውሼ ኬሎ ዓንጄሢና ዱማሴሢ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ኔ ዓዶና ኔ ዒንዶና ቦንቼ፤ ኔ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ኔኤም ዒንጋ ሳዖይዳ ዖዶሲ ሌዔ ኔ ናንጋያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ዓሲ ዎዺፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ዓኒ ሃሣ ማቾ ማዒባኣያና ላሂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ዉኡቂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ዓይጌንዴ ዓሲዳታዖ ሉኡዙሞና ማርካዺፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","ሜሌ ዓሲ ማኣሪ ዛጊ «ታኣሮ ማዓኣቢሽ ጌይፖ፤ ዓሲ ማቾታቴያ፥ ማዻ ዓሲታቴያ፥ ባኣቶታቴያ፥ ሃሮታቴያ፥ ዓሲኮ ቆሎ ማዔ ዓይጎ ባኣዚያ ቢያ ዛጊ ታኣሮ ማዓኣቢሽ ጌይፖ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ዴራ ጉጉንፆና ዛያሢናኮ ዑኡዞ ዋይዛዖ፥ ሃሣ ዜኤሊንፃ ዜኤሊንሣሢና ዹካ ጩባሢያ ዛጋዖ ዒጊጪ ጎጋይቂ ጎጋይቂ ሃኪ ዔቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ዬካፓ ሙሴም ዔያታ፦ «ኔኤኒ ኑኡም ኬኤዜ፤ ኔኤሲ ኑ ዋይዛንዳኔ፤ ፆኦሲ ኑኡም ኬኤዜቶ ኑ ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ሙሴያ ዔያቶም፦ «ዶዱዋቴ! ዒጊጪፖቴ፤ ፆኦሲ ሃያይዲ ዒንሢ ባንሢ ሙኬሢ ዒንሢ ዎይታቴያ ዛጋኒና ዒዛ ዒንሢ ዒጊጪ ጎሜ ማዺሢ ሃሻንዳጉዲኬ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ዴራ ሃኪ ዔቄ ቤዛ ዓኣንቴ፥ ሙሴ ፔኤሮ ፆኦሲ ዓኣ ዹሞ ባንሢ ዑኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶም ሂዚ ጌዒ ኬኤዛንዳጉዲ ሙሴ ዓይሤኔ፦ «ታኣኒ ጫሪንጫፓ ዎይቲ ዒንሢም ኬኤዜቶ ዒንሢ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ዬያሮ ታና ሌሊ ካኣሽካንዳኣፓዓቴም ቢራ ዓንጊና፥ ሃሣ ዎርቄና ካኣሽኮ ፆኦዞ ማዢ ካኣሽኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ታኣም ዾቃሌና ማዢንቴ ዒንጊ ካኣሽኮ ቤሲ ኮሹዋቴ፤ ዒዞ ቤዞይዳ ዒንሢኮ ማራቶና ዋኣሮና ባኣቶናይዳፓ ዛጊ ዶኦሪ ሚቺንቲ ዒንጊታያ፥ ዻቂንታም ማዓ ፔቱሞና ዒንጎ ዒንጊሢ ማሂ ዒኢካ ዒንጉዋቴ፤ ታ ሱንፃ ማሊንታንዳጉዲ ጌዒ ታ ጌሤ ቤዞይዳ ቢያ ዒንሢ ኮራ ታ ሙኪ ዒንሢ ዓንጃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ታኣም ሹቺና ኮሾና ዒንጎ ቤሲ ኮሻኒ ዒንሢ ኮዔቶ ዓርሲንቴ ሹቺና ማዦናያ ማዖፖ፤ ዓንጊና ዒንሢ ሄሌያታቶ ዬያ ዒንሢ ዒኢሳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ዒዞ ቤዞይዳ ዑፆ ካሉማ ዒንሢኮ ጴዹዋጉዲ፥ ሳናና ጊዒ ኬስኪ ዒንጎ ቤሲ ታኣም ማዢፖቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ሃሣ፦ «ዒስራዔኤሌ ዓሶም ኔ ኬኤዛንዳ ዎጋ ያዺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ዒብሬ ዓሶ ፃጲ ማዔ፥ ማዻ ዓሲ ኔ ሻንቄቶ ላሆ ሌዔ ዒ ኔኤም ማዾንጎ፤ ላንካሳ ሌዖና ፔቴታዖ ጋሌ ባኣያ ማሂ ዒዛ ኬሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ኔኤም ማዻንዳጉዲ ኔ ሻንቃኣና ዬይ ዓሢ ላኣሊ ዔኪባኣያ ማዔቶ፥ ዒዚ ሃሺ ዴንዳ ዎዶና ፔኤሮ ዴንዶንጎ፤ ዬይ ማዻሢ ኔ ሻንቃኣና ላኣሊ ዔኬያታቶ ፔ ማቾ ዔኪ ኬስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ዒዛ ዎይሣ ዓሢ ዒዛ ላኣሊ ዔኪሴም ዓቲንቄና ዉዱሮ ናይና ሾዔያ ማዔቴ ላኣሌላ ናኣቶና ዎላ ዬያ ዎይሣ ዓሢም ማዖንጎ፤ ማዻ ዓሢ ጋዓንቴ ፔኤሮ ጋሌባኣያ ኬስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ማዻ ዓሢ ‹ታና ዎይሣሢንታ ታ ማቾንታ፤ ሃሣ ታ ናኣቶንታ ታ ናሽካኔ› ጌዒ ዱማዺ ኬስኪፆ ኮዒባኣያታቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ዒዛ ዎይሣ ዓሢ ዎጎ ዎጋ ዓሶ ባንሢ ዔኪ ዓኣዾንጎ፤ ዒኢካ ካሮ ኮራ፥ ሃሣ ካሮ ሬኤኮኮ ኮራ ዔቂሲጋፓ ዋዮ ዒዛኮ ሳኣሚና ዑሮንጎ፤ ዬካፓ ዒዛኮ ናንጎ ሌዖ ቢያይዳ ዓይሌ ማዒ ዎይሣ ዓሢም ማዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«ፔቴ ዓሲ ፔኤኮ ዉዱሮ ናዖ ዓይሌ ማሂ ሻንቼቶ ዓቲንቆ ናኣቶጉዲ ጋሌ ባኣያ ዒዛ ኬስኮፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ዻካ ጌዔስካፓ ማቾ ማሂ ዔካኒ ኮዔ ዓሲም ዒዛ ሻንቺንታዖ ጊንሣ ዬይ ዓሢ ዒዞ ዔኩዋዖ ሃሼቶ ጊንሣ ዒዞኮ ዓዳሢም ዒዛ ሻንቺንቶንጎ፤ ዓይጎሮ ጌዔቶ ዒዞ ዎይሣ ዓሢ ኮይሱዋ ማዾ ዒዞይዳ ማዼሢሮ ሜሌ ዓሲም ዒዞ ሻንቻኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ዬይ ዓሢ ፔኤኮ ናዖም ማቾ ማሂ ዒንጋኒ ኮዔቶ ጋዓንቴ ፔኤኮ ዉዱሮ ናይ ማሂ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ላምዓሲ ሜሌ ላኣሊ ጊዳ ዔኬቶ ፔኤኮ ቤርታኣ ማቾም ሙኡዚና ማኣዖና ዒንጊፆ ሃሾፓ፤ ቤርታ ዓኣ ዎጎዋ ቢያ ዒዞም ፓጪሶፓ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ዬንሢ ሃይሦ ባኮንሢ ዒዞም ኩንሡዋያ ማዔቶ ጋዓንቴ ፔቴታዖ ጋሌ ባኣያ ማሂ ዒዞ ሃሾንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«ዓሲ ጳርቂ ዎዻ ዓሲ ቢያ ሃይቃንዳጉዲ ዎጊንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ጋዓንቴ ዓሢ ዔሪባኣዖ ዎዼያ ማዔቶ ፑኒንቲ ናንጋንዳ ቤሲ ታኣኒ፥ ፆኦሲ ጊኢጊሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ያዺ ማዓንዳኣፓዓቴም ዻጋና ሜሌ ዓሲ ዎዼዖ ሼምፖ ፔኤኮ ዓውሳኒ ታኣም ዓሳ ዒንጊፆ ዒንጋ ቤዞ ፑኒ ዓኣዼቶ ዬይ ዓሢ ሃይቃንዳጉዲ ዎጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«ዓዶዋ ማዖም ዒንዶ ጳርቃሢ ዎዺንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«ሻንቻኒ፥ ሃሣ ዓይሌ ማሂ ቆላኒ ማሊ ዓሲ ሹኡሚ ዔካሢ ቢያ ዎዺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«ዓዶዋ ማዖም ዒንዶ ጫሽካሢ ዎዺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«ላምዖ ዓሲ ዎላ ዑራዻዖ ፔቴሢ ባጋሢ ሹቻ ዹይ ዑሬቶ፥ ሃሣ ኩቺ ሙሊ ዱሊ ኪፃሴቶ ዎዺ ጋዓንቴ ዎዺባኣያ ማዔቶ ዎዺንቶፖ፤ ጋዓንቴ ዬይ ጳርቂንቴ ዓሢ ሃርጊንቲ ሻኣላይዳ ላሄቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ዬካፓ ዔቂ ኮኦሎ ዔኪ ኮኦላዺ ኮኦላዺ ሃንቲሢ ዓርቄቶ ዒዚ ላሂ ማይሢንቴ ዎዶሮ ጳርቄ ዓሢ ዻቦ ሚኢሼ ጪጎንጎ፤ ኮሺ ዓሢ ዻቃንዳያ ሄላንዳኣና ዓሢ ማይሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«ፔቴ ዓሲ ላኣሊታቶዋ ዓቲንቄ ዒዛም ማዻ ዓሲ ኮኦሎና ጳርቄም ኔጉዋዖ ሃይቄቶ ዬይ ዓሢ ሃይቃንዳጉዲ ዎጊንታንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ጋዓንቴ ዒዛም ማዻ ዓሶማ ፔቴ ኬሊና ላምዖ ኬሊናይዳ ሃይቂባኣቶ ዎይሣ ዓሢ ሃይቃንዳጉዲ ዎጊንቶፓ፤ ማዻሢዳፓ ዓቲፃ ሌሊ ዒዛም ዓጎና ሜቶ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«ላምዖ ዓሲ ዎላ ዑራዻዖ ፔቴ ጎጲንዶ ጳርቂ ዑስካፓ ኬይሲሴቶ፥ ሜሌ ጋዓንቴ ፑርታ ባኣዚ ዓሴሎ ሄሊባኣቴ፥ ዬይ ዑፃፓ ኬይሲሴ ዓሢ ላኣሌሎኮ ዓኒ ዒዛ ዖኦጬሢጉዴያ ዻቦ ሚኢሼ ጪጎንጎ፤ ዬይ ጪጋንዳ ዻቦ ሚኢሻ ዎጎ ዎጋ ዓሳ ጌስቲ ዔቂሴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ጋዓንቴ ላኣሌሎይዳ ዼኤፒ ፑርታ ባኣዚ ሄሌያ ማዔቶ ዎጋ፦ ‹ሼምፖ ዛላ ሼምፖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ዓኣፒ ዛላ ዓኣፒ፥ ዓቺ ዛላ ዓቺ፥ ኩቺ ዛላ ኩቺ፥ ቶኦኪ ዛላ ቶኦኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ሚቺሢ ዛላ ሚቺንቲሢ፥ ኪፃሲሢ ዛላ ኪፃሲሢ፥ ጳዺ ዛላ ጳዺ› ጋዓ ጎይፆ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«ፔቴ ዓሲ ዒዛም ማዻ ዓቲንቄያ ማዖም ላኣሊኮ ዓኣፖ ጳርቂ ዎዼቶ፥ ዓኣፖ ዛሎ ዻቦ ሚኢሼ ማዓንዳጉዲ ማዻሢ ሃንጎ ማዻዜሎ ጉሪ ኬሲ ዳኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ዬኖ ጎይፆና ፔቴ ዓቺታዖ ሜንሤቶ ዬማ ዓጮ ዛሎ ዻቦ ሚኢሼ ማዓንዳጉዲ ማዻሢ ሃንጎ ማዻዜሎ ጉሪ ኬሲ ዳኮንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«ጌማይ ዓሲ ዹይ ዎዼቶ ዬይ ጌሜ ሹቺና ዹይንቲ ሃይቆንጎ፤ ዓሽካኣ ዒዛኮ ሙይንቶፖ፤ ጌሜ ዓዶኮ ዻቢንቲ ባኣያ ናንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ጌሜ ቤርታኣፓ ዓርቃዖ ዓሲ ዹዓያ፤ ጊንሣ ሃሣ ባኣሢ ዓዶም ኮሺ ካፔ ጌይንቲ ላቲንቴያታንቴ ዒዚ ሞኦፃ ቃዙዋዖ ሃሼም ጌሜ ዓሲ ዹይ ዎዼያታቴ ሹቻ ዹይንቲ ሃይቆንጎ፤ ባኣሢ ዓዴያ ዒማይዲ ሃይቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ጋዓንቴ ባኣሢ ዓዴ ፔ ሼምፖ ዓውሳኒ ዻቦ ሚኢሼ ጪጋንዳጉዲ ጌይንቴያታቴ ዻቦ ሚኢሾ ቢያ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ጌሜ ዓቲንቄ፥ ሃሣ ዉዱሮ ናይ ዎዼያታቴ ዎጋ ዒማዒ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ጌሜ ዓቲንቄ ማዔቶዋ ላኣሊ ዓሲም ማዻያታንቴ ዹይ ዎዼቶ ጌሜኮ ዓዴ ዓሢ ሃንጎ ዓሴሎ ዎይሣሢም ሃይሢታሚ ሹቺ ቢራ ጪጎንጎ፤ ጌሜያ ሹቻ ዹይንቲ ሃይቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«ፔቴ ዓሲ ዔቴ ካራ ዎዾና ባኣዚ ሺኢሼቶ፥ ሃሣ ዔቴ ቦኦካዖ ካሮ ዎዹዋዖ ሃሼም ጌማይ ማዔቶዋ ሃሬ ዬኖ ዔቴሎ ጌሌቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ዬይ ቦኦኬ ዓሢ ቆልሞማ ዛሎ ጪጎንጎ፤ ሚኢሾ ቆልሞ ዓዶም ጪጌስካፓ ሃይቄ ቆልሞማ ፔኤም ዓይሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ፔቴ ዓሲኮ ጌማይ ሜሌ ዓሲ ጌማይ ዹይ ዎዼቶ ላምዖ ዓሶንሢ ሼምፖና ዓኣ ጌማዖማ ሻንቺ ሚኢሾንሢ ፓቂንቲ ዎላ ዔኮንጎ፤ ሃሣ ጊንሣ ሃይቄ ባኣሢኮዋ ዓሽኮ ዔያታ ዎላ ፓቂንቲ ዔኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ጋዓንቴ ጌሜ ዹዓያ ማዔሢ ዔርታንቴ ባኣሢ ዓዴ ሞኦፃ ቃዙዋዖ ሃሼያ ማዔያታቴ፥ ባኣሢ ሃይቄ ዓሣሢም ዹይ ዎዼ ጌሜ ጪጎንጎ፤ ሃይቄ ጌሜ ጋዓንቴ ፔኤም ዔኮንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ሃሣ፦ «ፔቴ ዓሲ ፔቴ ጌማይ ሃንጎ ማራይ ዉኡቂ ዔኪ ሹኬቶ፥ ሃንጎ ሻንቼቶ ፔቴ ጌማይ ዛላ ዶንጎ ጌማይ፤ ፔቴ ማራይ ዛላ ዖይዶ ማራይ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","ዒዚ ዉኡቄ ባኮ ጪጪጎንጎ፤ ጪጋኒ ዳንዳዑዋያ ማዔቶ ጋዓንቴ ዒዚ ዉኡቄ ቆሎ ዛሎ ዻቦ ሚኢሼ ማዓንዳጉዲ ዓይሌ ማዒ ዓሢም ማዾንጎ፤ ዉኡቂንቴ ቆልማ ባይ ዒንዴ፥ ሃሬ፤ ሃሣ ማራይታዖ ሳዛና ዓኣ ጎይሣ ዓኣንቴ ዒዛ ኮራ ጴዼቶ፥ ፔቴ ቆልሞ ዛላ ላምዖ ጳንጬ ማሂ ጪጎንጎ። ፔቴ ዉሲ ዹሚና ዓሲ ማርካ ሙኪ ሃይቄቶ ዒዛ ዎዼ ዓሢ ሼምፖ ዎዼያ ማዒ ዖኦጪንታንዳያ ኮይሱዋሴ፤ ማዺንቴ ባካ ሮኦሪናታቶ ጋዓንቴ፥ ሼምፖ ዎዼያ ማሂ ዒዛ ዖኦጪሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«ፔቴ ዓሲ ፔኤኮ ቆልሞ ሄንቆ ቤስካ፤ ሃሣ ጎሺ ዓሽካ ማሂ ዓኣንቴ ቆልሞ ዴንዲ ሜሌ ዓሲ ጎሺ ጌሊ ሙዔቶ፥ ፔ ጎዦይዳፓ ሃሣ ጊንሣ ዎይኖ ቱኮ ቤዞይዳፓ ዔካ ባካፓ ዻቦ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«ፔቴ ዓሲ ፔኤኮ ጎዦይዳ ታሚ ዓጋዛ ታማ ካዮ ጊዴና ጌዒ ሜሌ ዓሲ ጎሺ ሄሊ ሃጊ ባባቃላ ሜይታቶዋ ታይዚ ናቲ ጌሦና ሜይ ሙዔቶ፥ ታሞ ዓጌ ዓሢ ዻቦ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«ፔቴ ዓሲ ሜሌ ዓሲኮ ሚኢሼ፤ ሃሣ ቦንቺንቴ ዓንጋሞ ፔ ኮራ ጌሣኒ ዔካዛ፥ ዒዛ ማኣሮይዳፓ ዉሲ ዔኬዖ ዉዛሢ ዓርቂንቲ ጴዼቶ ጳንጬ ማሂ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ዉዛሢ ጴዺባኣቶ ጋዓንቴ ዓንጋሞ ፔ ኮራ ጌሤ ዓሢ ዎጎ ዎጋ ዓሶ ቤርቶ ሺኢኪ ዬያ ዓሢኮ ዓንጋሞ ዉኡቂባኣያ ማዒፆ ጫኣቂ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«ባይ ዛላ፥ ሃሬ ዛላ፥ ማራይ ዛላንታ ማኣዖ ዛላንታ፤ ሃሣ ዬያጉዲ ዓይጌንዴ ባይቄ ባኣዚኮ ቢያ ላምዖ ዓሲ ዎሊ ዎጌና ዓይሢሴቶ፥ ቆሎኮ ዓዶንሢ ማዒ ዎላ ጎሪንቴ ላምዖ ዓሶንሢ ዎጎ ዎጋ ዓሶ ቤርቶ ሺኢኮንጎ፤ ዎጎ ዎጋ ዓሳ ‹ዻቤኔ› ጌዔ ዓሢ ዒ ዻቤ ዓሢም ጳንጬ ማሂ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«ፔቴ ዓሲ ሜሌ ዓሲኮ ሃሬ፥ ባይ ዒንዴ፥ ማራይ፤ ሃሣ ዬያጉዴያ ዓይጌንዴ ቆልሞታቴያ ቁሪሢና ፔ ኮራ ጌሤንቴ ቆልሞ ሃይቄቶ ጊንሣ ሜቄቶ፤ ሃሣ ቡሪንቲ ዔውቴያ ማዔም፥ ማርካ ዒዛኮ ባኣያ ማዔቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ዬይ ዓሢ ዎጎ ዎጋ ዓሶ ቤርቶ ዓኣዾንጎ፤ ዓሢኮ ቆልሞ ፔኤሮ ዉኡቂባኣያ ማዒፆዋ ናንጊና ናንጋ ጎዳ ቤርታ ጫኣቂ ዔርዞንጎ፤ ቆልሞ ዒ ዉኡቂባኣያ ማዔቶ ቆልሞኮ ዓዴ ዻቦ ዒዛ ዖኦጮፖ፤ ቆልማ ባይቄ ዓሢያ ዻቦ ጪጎፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ቆልሞ ዒዚ ዉኡቄያ ማዔቶ ጋዓንቴ ቆልሞኮ ዓዶም ዒንሢ ጉዴያ ማሂ ዒንጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ቆልሞ ቦዖ ሙዔያ ማዔቶ ዓሢ ቦዓ ሙዒ ሃሼ ዶምቦ ማርካሮ ዔኪ ሙኮንጎ፤ ቦዓ ዎዼሢ ዛሎኮ ዻቦ ዒዚ ጪጎፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«ፔቴ ዓሲ ሜሌ ዓሲዳፓ ቆልሞ ቁሪሲ ዔካዛ፥ ቆልሞኮ ዓዴባኣ ቤስካ ቆልሞ ሃይቄቶ፤ ሃሣ ሜቄቶ ዒዚ ቁሪሲ ዔኬ ዓሢም ዻቦ ጪጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ጋዓንቴ ዬይ ማዔሢ ቆልሞኮ ዓዴ ዓኣንቴታቶ ዓሢ ዻቦ ጪጋኒ ኮይሱዋሴ፤ ሚኢሼ ጪጊ ጪጊ ማኣዲንታኒ ዔኬያ ማዔቶ ቤርታ ዒንጊንቴ ሚኢሻ ጪጌያ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","17","ሃሣ፦ «ፔቴ ዓሲ ፔቴ ኩሙሢ ዉዱሮ ናይ ዎልቄና ዓርቄቶ ማጋጬ ጪጊ ዒዞ ዔኮንጎ፤ ናዖኮ ዓዴ ዒዛም ዒንጋኒ ኮዒባኣቶ ጋዓንቴ ፔቴ ኩሙሢ ዉዱሮ ናይም ዒንጊንታ ዻቦ ሚኢሼና ዎላ ሄኮ ማዓ ሚኢሼ ዻቦ ናዓኮ ዓዶም ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«ማርሻ ማርሻ ላኣሊ ዓኣቶ ዎዎዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«ቆልሞ ዒኢሳ ዓሲያ ዎዺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«ታና፥ ናንጊና ናንጋ ጎዳይዳፓ ዓታዛ ሜሌ ዓይጌንዴ ፆኦሲማኣ ማዖም ዒንጎ ባኣዚ ዒንጋ ዓሲ ባይቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«ዒንሢ ዓጮይዳ ሙኬያ ማዒ ናንጋ ዓሲ ካራ ባይዚ ሜታሲፖቴ፤ ኔኤኒያ ጊብፄ ዓጮይዳ ሙኬ ዓሲ ማዒ ናንጌሢ ጶቂሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ዓኒ ሃይቄ ዜኤሮ ዒንዶ፥ ሃሣ ዓዶና ዒንዶና ሃይቄ ዜኤሪ ናይ ሜታሲፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ዒንሢ ዬያይዴም ታኣም ዔያታ ዒላቴቶ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዔያቶኮ ዒላቶ ጎኔና ዋይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ዒንሢ ዑፆይዳ ታ ዻጋዺ ዖልዚና ዒንሢ ኩርሲሳንዳኔ፤ ላኣላ ዒንሢኮ ዓኒ ባኣያ፥ ናኣታ ዒንሢኮ ዓዶና ዒንዶና ባኣያ ማዒ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«ታ ዴሮ ባኣካ ማንቆ ማዒ ናንጋ ፔቴያምታዖ ሚኢሼ ኔ ታልዔቶ ሚኢሼ ታልዒሳ ዓሲጉዲ ሾይቺና ቃሲ ኔኤም ጪጋንዳጉዲ ዒዛ ዖኦጪፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ዓሲ ዔኤቢ ኔኤኮ ዔኬም ዓይሢ ማሂ ዓፒላ ኔ ዔኬ ዓሲ ዓኣቶ፥ ዓባ ጌላንዳሢኮ ቤርታ ዒዛም ማሂ ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ዓይጎሮ ጌዔቶ ጪኢዦሮ ዒዚ ማይንታንዳ ዓፒላ ሜሌ ፔቴታዖ ባኣሢሮ ዒዚ ዓይጎ ማይንቲ ዎርቃኒ ዳንዳዓይ? ታኣኒ ማኣራያ ማዔሢሮ ዒዚ ታ ባንሢ ዒላቴቶ ታ ዒዛም ዋይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«ፆኦሲ ጫሽኪፖ፤ ኔ ዴሮኮ ሱኡጌ ማዔሢማኣ ጋዳንቂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«ኔኤኮ ሃኣኮኮ፥ ዎይኖ ዑዦንታ ሪሚቶ ዛይቶንታኮ ቤርቶ ታኣም ዔኪ ዬዔ፤ ቤርቲ ማዒ ሾይንቴ ዒንሢኮ ዓቲንቆ ናኣቶዋ ታኣም ዔኪ ዬዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ዒንሢኮ ባኣቶና ማራቶናኮ ቤርቲ ሾይንቲ ማዒ ሾይንቴዞንሢ ታኣም ዔኪ ዬዑዋቴ፤ ዬያሮ ቤርቲ ማዒ ሾይንቴ ዓቲንቄ ቢያ ላንካይ ኬሊ ዒንዶና ዎላ ዴዖንጎ፤ ሳላሳ ኬሎና ታኣም ዔኪ ዬዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«ዒንሢ ታ ዴሬ ማዔሢሮ ቦዖ ዎዼ ቆልሞኮ ዓሽኪ ሙዒፖቴ፤ ዬያይዲፆይዳፓ ካኒም ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ሃሣ፦ «ሉኡዚ ሃይሴ ዔኪ ሃንቲፖ፤ ሉኡቂ ማርካዺሢና ዻቢንቴ ዓሢ ጌኤሺ ዓሲ ማሂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ሚርጌ ዓሲ ፑርታ ባኣዚ ማዻኒ፥ ሃሣ ጊንሣ ዎጎ ዎቢሳኒ ዔቃ ዎዶና ዔያቶና ዎላ ፔቴ ማዒፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ማንቆ ዓሲ ዔኤቢ ፑርቲሲ ዎጌ ቤሲ ሺኢኬቶ ዒዛኮ ማንቁሞ ዛጊ ዒዛ ዑፃ ጌስቲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«ኔኤኮ ሞርካሢኮ ባይ፥ ሃሣ ጊንሣ ሃሬ ባይቄም ኔ ዴንቄቶ ዒዛም ማሂ ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ጎዖንቴ ዒዛኮ ሃራ ጫኣናና ዴኤፂንቲ ሎኦሚ ዓኣንቴ ኔ ዴንቄቶ፥ ሃራ ሎኦሜ ቤዛፓ ዒዚ ዔቂሳንዳጉዲ ዒዛ ማማኣዴ ኮርሳ ሃሺ ዓኣዺፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«ዎጎ ዎጎ ቤዞይዳ ዓሲ ዱማሲሢና ማንቃሢኮ ዎጎ ዎቢሲፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ዖና ማዔቴያ ሉኡዙሞና ዎጌና ዓይሢሲፖ፤ ሃሣ ጌኤሺ ዓሲ ሃይቃንዳጉዲ ዎጊፖ፤ ዓይጎሮ ጌዔቶ ዬያጉዴ ፑርታ ባኣዚ ማዻ ዓሢ ታ ጌኤሻዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ዓሳ ጎኔ ባኣዚ ዴንቁዋጉዲ ዓሶኮ ዓኣፒ ዓርቃያታሢሮ፤ ሃሣ ጌኤዦ ዓሶኮ ዎጎ ዎቢሳያ ማዔሢሮ ዴሜና ዒንጎ ሚኢሾ ዔኪፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«ሜሌ ዓጪፓ ዒፂሢና ዳውሲንቴያ ማዒ ሙኬሢ ሜታሲፖ፤ ዓይጎሮ ጌዔቶ ዒንሢ ጊብፄ ዓጮይዳ ዒፂንቴ ዓሲ ማዒ ናንጌያታሢሮ ዒፂንቲ ዳኪንቴ ዓሲኮ ዎዚጉዴ ሜታ ዓኣያታቴያ ዒንሢ ዔራኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«ላሆ ሌዔ ጎዦ ኔኤኮ ዜርቂ ጎሽኪ፥ ሃኣኮ ዔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ላንካሳ ሌዖና ጋዓንቴ ሳዔሎ ሃሼ፤ ኔኤኮ ዴሮ ባኣኮይዳ ዓኣ ማንቆ ዓሳ ሙኡዚ ዴንቃንዳጉዲ ሳዔሎይዳ ባቃሌ ባካፓ ፔቴ ባኣዚታዖ ዔኪፖ፤ ኔ ጎዦይዳ ዓቴ ባኮ ቢያ ሳዖይዳ ዓኣ ካዮ ቦዓ ሙዖንጎ፤ ዎይኖንታ፥ ሃሣ ዛይቶ ሪሚቶ ሚፆዋ ዬያጉዲ ሃሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«ላሆ ኬሊ ኔ ማዾ ቢያ ማዼ፤ ላንካሳ ኬሎና ጋዓንቴ ፔቴታዖ ማዾ ማዺፖ፤ ዬያጉዲ ኔኤኮ ማዻ ዓሶንታ ኔኤም ማዻ ሜሌ ዓጫፓ ሙኬ ዓሶንታ ቆልማኣ ኔኤኮ ቢያ ሃውሺ ፔኤቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዒንሢም ኬኤዛ ባኮ ኮሺ ዋይዙዋቴ፤ ሜሌ ካኣሽኮ ፆኦዞ ካኣሽኪፖቴ፤ ሜሌ ዓታዛ ሱንፆታዖ ዔያቶኮ ዔኤሊፖቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«ሃሣ ታና ዒንሢ ቦንቻንዳጉዲ ሌዔይዳ ሃይሦ ቦንቾ ኬሊ ዒንሢም ዓኣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ጊብፄፓ ዒንሢ ኬስኬ ዎይቤ ዓጊኖና፥ ታ ዒንሢ ዓይሤ ጎይፆ ላኣዳ ሙዒ ቦንቾ ኬሎ ቦንቹዋቴ፤ ዬና ቦንቾ ኬሌላ ቦንቺንታ ላንካዎ ኬሎይዳ ሙኑቃ ፃኣዛ ጌሌ ካሣ ሙዒፖቴ፤ ታኣም ዒንሢ ዚጊ ካኣሽካኒ ሙካኣና ዒንጎ ባኣዚ ዔኩዋዖ ዬዒፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«ሃሣ ዒንሢኮ ማኣሎ ዒንሢ ቡራ ዎዶና ማኣሎ ቡሪፆ ቦንቾ ኬሎ ቦንቹዋቴ፤ ዒንሢኮ ዎይኖንታ ዱማ ዱማ ዓሚ ካፃ ሚፆ ዓኣፖ ዒንሢ ማፃኣና ሌዖኮ ጋፒንፆይዳ ሃኣኮ ዓርሢ ቦንቾ ኬሎ ቦንቹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ሌዖይዳ ሃይሢ ማይንቲ ዬንሢ ቦንቾ ኬሎንሢ ቦንቺንታ ኬሎና ዓቲንቃ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዚጊ ካኣሽካኒ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«ዒንሢ ታኣም ቆልሞ ሹኪ ዒንጋ ዎዶና ሙኑቃ ፃኣዛ ጌሌ ካሣ ታኣም ዒንጎያ ማሂ ሺኢሺፖቴ፤ ዬንሢ ሃውሾ ኬሎንሢና ሹኪ ዒንጊንታ ቆልሞኮ ማሎ ዓይሲ ዎይሢፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«ሌዓ ሌዓ ዒንሢ ጎሽካ ሃኣኮፓ ቤርቶ ታና ዒንሢኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ማኣሪ ዔኪ ዬዑዋቴ። «ማራናይ ማዔቶዋ ዋናናይ ዒንዶ ዲኢቆና ካሢፖ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ሃሣ «ኔ ዓኣዻ ጎይፆይዳ ዒ ኔና ካፓንዳጉዲ፥ ሃሣ ታ ኔኤም ጊኢጊሼ ሳዖ ኮሺና ዒ ኔና ጌልዛንዳጉዲ ኔኤኮ ቤርታ ቤርታ ዓኣዻንዳጉዲ ታኣኮ ኪኢታንቻሢ ታ ዳካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ዒ ኔኤም ኬኤዛ ባኮ ዋይዚ ዒዛም ዓይሢንቴ፤ ዒዛም ዋይዚ ዒፂፖ፤ ታ ዒዛና ዎላ ማዔሢሮ ኔኤኮ ዓይሢንቲፆ ዒፂፆ ዒዚ ዛጊ ዛጊ ኔኤም ዓቶም ጋዓዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ዒዛም ኔ ዓይሢንቴቶ፥ ሃሣ ታ ኔኤም ዓይሤ ባኮዋ ቢያ ኔ ኩንሤቶ ኔኤኮ ሞርኮ ቢያ ታ ዖላንዳኔ፤ ኔና ዒፃሢያ ታ ዒፃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ታኣኮ ኪኢታንቻሢ ኔኤኮ ቤርታ ቤርታ ዓኣዺ ዓሞኦሬ ዓሶ ዓጮ፥ ሄኤቴ ዓሶ ዓጮ፥ ፔርዜ ዓሶ ዓጮ፥ ካኣናኔ ዓሶ ዓጮ፥ ሂዋዌና ዒያቡሳ ዓሶ ዓጮዋ ዔኪ ኔና ዒዚ ጌልዛንዳኔ፤ ታኣኒያ ዔያቶ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ዔያቶኮ ካኣሽኮ ፆኦዞም ጉምዓቲ ዚጊፖ፤ ሃሣ ዔያቶኮ ዔርቴ ካኣዦ ማዾ ጊንፆ ዓኣዺፖ፤ ዔያቶኮ ካኣሽኮ ባኮዋ ባይዜ፤ ዔያቶኮ ዻኣቦጉዲ ዔቂሶና ዱማዼ ሹጮዋ ዶይሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ታና፥ ኔኤኮ ፆኦሲ ማዔ ናንጊና ናንጋ ጎዳሢም ኔ ዚጌቶ ኔኤም ጊዳንዳ ሙኡዚና ዋኣሢያ ዒንጊ ታ ኔና ዓንጃንዳኔ፤ ዶርዖ ቢያ ታ ኔኤኮ ባይዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ኔኤኮ ዓጮይዳ ዑስካፓ ኬይሳ ላኣሊና ሾውዋዖ ዞኦኮ ማዓ ላኣሊ ባኣያ ማዓንዳኔ፤ ኔኤኮ ናንጎ ሌዖዋ ታ ዖዶሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«ኔና ዒፂ ማካ ዓሳ ቢያ ታና ዒጊጫንዳጉዲ ታ ማሃንዳኔ፤ ኔጊዳ ዖልዚ ቡላ ዴሮ ዑፆይዳ ታ ሜቶ ዔኪ ዬዓንዳኔ፤ ኔኤኮ ሞርኮ ዒጊቺ ታኣኒ ጳሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ጊንሣ ሃሣ ዬያ ኔኤኮ ሞርኮይዳ ዒጊቹሞ ታ ጌልዛንዳኔ፤ ኔኤኒ ሴካ ቤርቲም ዓኣዻኣና ሂዋዌ ዓሶ፥ ካኣናኔ ዓሶ፥ ሄኤቴ ዓሶ፥ ኔኤኮ ቤርታፓ ታ ዳውሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ያኣዒ ማዔቴያ ፔቴ ሌዔጊዳ ዔያታ ባይቃንዳጉዲ ታ ማሃዓኬ፤ ያዺ ታ ማዼቶ ሳዔላ ዓሲ ባኣያ ማዓንዳኔ፤ ቦዖዋ ኔጊዳ ዺባንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ዬያሮ ዬያይዲፆና ኔኤኒ ሚርጊ ሳዔሎ ዔካንዳያ ሄላንዳኣና ዻካ ዻካ ኔኤም ታ ዔያቶ ኬሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ዒንሢ ዓጮኮ ዛጶ ዓካባ ጌይንታ ባዞ ዓጮይዳፓ ዴንዲ ዒፕራፂሴ ዎሮና፥ ጊንሣ ሜዲቴራኒያ ባዛፓ ዴንዲ ዓሲ ናንጉዋ ዳውሎ ሄላንዳኣና ታ ዳልጊሻንዳኔ፤ ዓጬሎይዳ ናንጋ ዓሶ ኔኤኒ ባሻንዳጉዲ ዎልቄ ታ ኔኤም ዒንጋንዳሢሮ ቤርቲም ኔ ዓኣዻ ዎዶና ዔያቶ ኔኤኒ ዳዳውሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ዔያቶና ዎላ፤ ጊንሣ ሃሣ ዔያቶኮ ካኣሽኮ ፆኦዞዋ ማዖም ካሽኪ ዎላ ፔቴታዖ ቡኪፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ዬያቶ ዴሮ ዓጮይዳ ኔኤኮ ናንጊሲፖ፤ ኔኤኒ ዔያቶ ናንጊሳያ ማዔቶ ጋዓንቴ ጎሜ ማዺሲሢና ታጊዳፓ ኔና ዔያታ ዻቢሻንዳኔ፤ ዔያቶኮ ካኣሽኮ ፆኦዞም ኔ ዚጌቶ ሃይቢዳ ኔና ጌልዛ ፒሮ ኔኤም ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔኤኒ፥ ዓኣሮኔ፥ ናኣዳኣቤ፥ ዓቢሁንታ ዒስራ ዔኤሌ ዓሶ ሱኡጎይዳ ላንካይታሚ ማዓ ዓሲንታ ዎላ ታኣኒ ዓኣ ዹኮ ኬስኩዋቴ፤ ሃኬ ዓኣዖ ጉምዓቲ ዚጊ ካኣሽኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ጊንሣ ሃሣ ኔኤኒ ሌሊ ሜሌ ዓሶፓ ዱማዺ ታ ባንሢ ዑኬ፤ ዴራ ጋዓንቴ ኔኤና ዎላ ዹኮ ባንሢ ዶጮፓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ዬካፓ ሙሴ ዴንዲ ናንጊና ናንጋ ጎዳ ዓይሤ ባኮና ኬኤዜ ዎጎና ቢያ ዴሮም ኬኤዛዛ፥ ዴራ ፔቱሞና፦ «ናንጊና ናንጋ ጎዳ ኬኤዜ ባኮ ቢያ ኑ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ሙሴያ ናንጊና ናንጋ ጎዳኮ ዓይሢፆ ቢያ ፃኣፔኔ፤ ዚሮ ጉቴሎ ዓሚ ዹኮ ዴሞይዳ ፆኦሲም ዒንጎ ባኣዚ ዒንጊ ካኣሽኮ ቤሲ ሹቺና ኮሼኔ፤ ጊንሣ ፔቴ ፔቴ ዒስራዔኤሌ ዓሶኮ ፃጶ ሱንፆና ታጶ ላምዖ ዻኣቦ ዻኣቤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ሚቺ ዒንጎ ዒንጊፆ ናንጊና ናንጋ ጎዳም ዒንጋንዳ ዼጌ ናይያ ዒዚ ዳኬኔ፤ ዔያታ ሚርጌ ጌማናይ ዔኪ ዓኣዺ ዻቂንታም ማዓንዳ ዺቢ ዓሲ ፔቱሞና ዒንጋ ዒንጊሢ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ሙሴያ ቆልሞኮ ሱጉፆይዳፓ ፓቂ ዔኪ ዓንዳይዳ ጌሤኔ፤ ሄካሢ ጊንሣ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኮ ዒንጎ ቤዞይዳ ፑጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ዬካፓ ፆኦሲኮ ዓይሢፃ ፃኣፒንቴ ጫኣቁሞ ማፃኣፖ ዔኪ ዑኡዞ ፔኤሲ ዼጊዲ ዴሮም ናባባዛ፥ ዴራ፦ «ናንጊና ናንጋ ጎዳሢም ኑ ዓይሢንቲ ዒዚ ዓይሤ ባኮ ቢያ ኑ ኩንሣንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ዴራ ያዺ ጌዔስካፓ ሙሴ ዓንዶና ዓኣ ሱጉፆ ዔኪ ዴሮ ዑፃ ፑጫዖ፦ «ሃይ ዓካሪ፥ ናንጊና ናንጋ ጎዳ ሃንሢ ዓይሢፆ ቢያ ዒንሢም ዒንጋኣና ዒንሢና ዎላ ጫኣቄ ጫኣቁሞ ዒዚ ዶዲሼ ሱጉፆኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ዬካፓ ጊንሣ ሙሴ፥ ዓኣሮኔ፥ ናኣዳኣቤ፥ ዓቢሁንታ ዒስራዔኤሌ ዓሶኮ ሱኡጎ ማዔ ላንካይታሞ ዓሶንታ ዹኮ ኬስኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ዒስራዔኤሌ ፆኦዛሢ ዛጌኔ፤ ዒዛኮ ቶኮ ዴማ ሚዛጲ ሹቺና ኮሺንቴ፥ ሃሣ ፖፖዓ ጫሪንቺ ማላ ባኣዚ ሂኢሢንቲ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ዒስራዔኤሌ ዓሶ ዔኪ ዓኣዻ ዬንሢ ጋርቾንሢዳ ፆኦሲ ፑርታ ባኣዚ ዓጊባኣሴ፤ ፆኦሲ ዔያቶኮ ቤርታ ዓኣንቴ ዔያታ ዛጊ ዛጊ ዒዛ ቤርቶይዳ ሙዒያ ሙዒ ዑሽኪያ ዑሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ታኣኒ ዓኣ ዹኮ ኬስኪ ዒኢካ ዴዔ፤ ታ ኔኤም ላምዖ ዓርሲንቴ ሹቺ ዒንጋንዳኔ፤ ዬንሢዳ ዴሮም ዎርቆንዶ ጎይሢ ታኣኒ ፃኣፔ ዓይሥሢና ዎጌና ዓኣያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ሙሴና ዒዛኮ ዴማ ማኣዳያ ማዒ ማዻ ዒያሱና ዹኮ ኬዞሮ ጊኢጊንቴኔ፤ ዬካፓ ሙሴ ፆኦሲ ዹኮ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ዬማና ሙሴ ዒስራዔኤሌ ዴሮ ዔኪ ዓኣዻ ዓሶም፦ «ጊንሣ ዒንሢ ባንሢ ኑ ማዒ ሙካንዳኣና ሃካ ዴዑዋቴ፤ ሃይሾ፥ ዓኣሮኔንታ ሁሪንታ ዒንሢና ዎላኬ፤ ዬያሮ ዒንሢ ባኣካ ጌኤሲ ዓኣ ዓሲ ዓኣቶ ዔያቶ ባንሢ ዓኣዾንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ሙሴ ሲና ዹኮ ኬስካዛ፥ ዹኮ ሻኣሬ ባይዚ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","ናንጊና ናንጋ ጎዳኮ ቦንቾ ፔጋሲ ዻዋ ዓኣፒዳ ዱካ ፖዓ ዹኮይዳ ፖዔኔ፤ ዒስራዔኤሌ ዓሶም ዬይ ፖዓ ዹኮ ዑፆይዳ ዔዔኤታ ታሚ ማሌኔ፤ ዹካ ላሆ ኬሊ ጉቤ ሻኣሬና ዓርቂንቲ ዴዔኔ፤ ናንጊና ናንጋ ጎዳ ላንካሳ ኬሎና ሻኣሮ ባኣካ ማዒ ሙሴ ዔኤሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ሙሴያ ኬስኪ ዹኮይዳ ዓኣ ሻኣሮ ባኣኮ ጌሊ፥ ዒኢካ ዖይዲታሚ ሮኦሪና ዖይዲታሚ ዋንቴና ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«ታኣም ዔያታ ዒንጎ ባኣዚ ዔኪ ዬዓንዳጉዲ ዒስራዔኤሌ ዓሶም ኬኤዜ፤ ዓይጎ ዓሲታቴያ ፔ ሼኔና ዔኪ ዬዓ ዒንጎ ባኮ ቢያ ዔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ዔያቶይዳፓ ኔ ዔካንዳ ባካ፦ ዎርቄ፥ ቢራ ዓንጊ፥ ሞኦኖ ዓንጋ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ጉኡሢ ሻሎና ዹዎና ማኣዓ፥ ማራይ ጋፓኔና ማዢንቴ ዲንኪ ዓፒላ፥ ጋላፒንታ ዞቄ ዓፒላ፥ ዋኣሪ ጋፓኔና ማዢንቴ ዓፒላኣ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ዞቄ ቃላሜና ቲሽኪንቴ ዓዴ ማራይ ጎሮ፥ ጉላምቤ ዜዺ፥ ሻሪ ሚሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ፖዖ ፖዒሶ ሪሚቶ ዛይታ፥ ቲዦ ዛይታ፥ ዑንጆ ሳውሞ ኮሺ ሳውቂሳ ዱማ ዱማ ዼኤሻ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ሜሬጊዴ ጌይንታ ሚዛጶ ሹጫ፥ ቄኤሶ ሱኡጎኮ ኬርኖይዳ ቱኮ ዔፑዴ ጎዖ ባኮና፥ ዳዶ ቡራሾይዳ ጌሢንታ ፔርፄ ጌይንታ ባኮንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ታ ዔያቶኮ ባኣካ ናንጋንዳጉዲ ዴራ ጌኤሺ ማኣሪ ታኣም ማዦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ዓፒሎና ማዢንታ ማኣሮ፤ ሃሣ ጋሮይዳ ዓኣ ባኮዋ ቢያ ታ ኔና ዻዋ ጎይፆ ጊኢጊሺ ማዡዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«ሻሪ ሚሢፓ ፔቴ ሳኣፂኔ ታኣቦቴ ማሂ ዔያታ ኮሾንጎ፤ ዖዶሱማ ላምዖ ዋዻና ፓልፃና፥ ዓጮ ዳልጉማ ፔቴ ዋዻና ፓልፃና፥ ቱሮ ዔጳኣ ፔቴ ዋዻና ፓልፃና ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ጋሮንታ ዙሎንታ ጌኤሺ ዎርቄና ጳርቂ ኮሼ፤ ዓጮዋ ዎርቄና ካንቄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ዎርቃፓ ኮሺንቴ ዖይዶ ዢኢሮ ማዢ፥ ላምዖንሢ ፔቴ ዛላ፤ ላምዖንሢ ጊንሣ ባጎ ዛላ ማሂ ዖይዶ ቶኪና ዎላ ዓርቂንታንዳጉዲ ጊኢጊሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ታኣቦቶ ኬዶንዶያ ዛጶ ሚሢ ሻሪ ሚሢፓ ኮሺጋፓ ዬያ ዎርቄና ጳርቂ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ዬንሢ ዛጶ ሚፆንሢ ታኣቦቶኮ ዓጮ ዛሎይዳ ዓኣ ዢኢሮንሢዳ ጌልዜ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ዛጶ ሚፆንሢ ታኣቦቶኮ ዢኢራሢዳ ዳኪንቲ ዴዖንጎ፤ ፔቴታዖ ዒኢካፓ ኬስኮፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ዬካፓ ታኣኒ ኔኤም ዒንጋ ዓይሢፃ ፃኣፒንቴ ላምዖ ዓርሲፆ ሹጮንሢ ታኣቦቶ ጋራ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«ዖዶሱማ ላምዖ ዋዻና ፓልፃና፥ ዓጮ ዳልጉማ ፔቴ ዋዻና ፓልፃና ማዔ ጎሞ ጌኤሺፆ ዔርዛ ጉኡፖ ጌኤሺ ዎርቄይዳፓ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ዬኖኮ ዓጫ ዓጫ ዹይንቴ ዎርቄይዳፓ ጋኣሲ ዓኣያ ላምዖ ኪሩቤኤሌ ጌይንታ ኪኢታንቾ ማላታና ዓኣ ባኣዚ ማዤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ጎሞ ጌኤሺፆ ዔርዛ ጉኡፖይዳ ላምዖ ዛሎና ዓጫ ዓጫ ማሂ ዬያቶ ዔቂሴ፤ ዔያታ ዬኖ ጉኡፖና ዎላ ዓይሢ ማዢንቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ዬንሢ፥ ጋኣዛ ዓኣ ኪሩቤኤሎንሢ ጉኡፖኮ ሻውሎና ሚዛቆናይዳ ማዒ ሄኮ ዔቂ ዎሊ ዛዛጋያ ማዖንጎ፤ ዔያቶኮ ፒሺንቴ ጋኣዛ ጉኡፖ ዓኣቻያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ላምዖ ዓርሲንቴ ሹጮንሢ ታኣቦቶ ጋራ ጌሢጋፓ ጎሞ ጌኤሺፆ ዔርዛ ጉኡፖና ካሮ ዎዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ታኣኒ ዬኖ ጫኣቁሞ ሳኣፂኖይዳ ኔኤም ፔጋዺ ጴዻንዳኔ፤ ጉኡፖ ዑፃ ማዢንቴ፥ ጋኣዛ ዓኣ ላምዖ ኪሩቤኤሎንሢ ባኣካ ማዒ ኔኤኒ ዒስራዔኤሌ ዴሮም ዔርዛንዳ ዎጎ ቢያ ኔኤም ታኣኒ ዒንጋንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«ዖዶሱማ ላምዖ ዋዻ፥ ዓጮ ዳልጉማ ፔቴ ዋዻ፥ ሌካ ዔጳ ፔቴ ዋዻና ፓልፃና ማዔ ዼጌ ዖዶሲ ሎኦዤ ሻሪ ሚሢዳፓ ዓርሲ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ጊንሣ ሃሣ ጌኤሺ ዎርቄና ዑፆ ጳርቂ ጊኢጊሼ፤ ዓጮዋ ዎርቄና ካንቄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ሃሣ ዓጮ ዳልጉማ ኬኤላ ዋዻ ማዓያ ኮሺጋፓ ዬኖ ዎርቄና ጳርቂ ጊኢጊሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ዎርቄይዳፓ ኮሺንቴ ዖይዶ ዢኢሮ ዛጶ ሚፆ ዳኪ ኬዶንዶያ ኮሼ፤ ዢኢራሢያ ቶካ ዓኣ ዖይዶ ዛላ ማሂ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ዬያ፥ ዼጌ ሎኦዦ ኬዶንዶ ዛጶ ሚፃ ጌላንዳ ዢኢራሢ ዓጮ ዛላ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ዛጶ ሚፆ ሻሪ ሚሢፓ ኮሺ ዎርቄና ጳርቂ ጊኢጊሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ዓንዳና ሙርሳና፤ ሃሣ ጊንሣ ዑዦ ዱዖንዶ ጉንጉሎዋ ጌኤሺ ዎርቄይዳፓ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ቢያ ዎዴ ዼጌ ሎኦዦ ዖይታ ታ ቤርቶይዳ ጌሢንቶንጎ፤ ታኣም ዒንጊንታ ዱማዼ ካሣ ቢያ ኬሊ ዬያ ዑፃፓ ባይቆፖ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«ጌኤሺ ዎርቄይዳፓ ሻርና ማዤ፤ ዬኖ ሻርኔሎ ፒዝ ጌዒ ዔቃ ቶኪና ዶዲሺ ዔቂሳ ዓንጊ ኮሼ፤ ዑዦ ዑሽኮ ዓንጎ ማላ ቡኒ ሃጊ ቡናያ ማሊሲ ሻርኔሎና ዓይሢ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ጎኦቦ ዛሎና ላሆ ካኣፒ ዓኣያ ማሂ ኮሼ፤ ሃይሣሢ ፔቴ ዛላ፥ ጊንሣ ሃይሣሢ ባጎ ዛላ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ላሆ ካኣፓ ፔቴ ፔቴሢ ፂሊና ዒላሺና ዓኣ ሌውዜ ቡኖ ማላያ ሃይሦ ዑሽኮ ዓንጊ ማላ ቡኒ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ሻርኖኮ ፒዝ ጌዒ ዔቄ ሚፆይዳ ፂሊና ዒላሺና ዓኣያ ሌውዜ ቡኖ ማላ ዖይዶ ዑሽኮ ዓንጊ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ሃይሦ ዋኣፂንቴ ካኣፖኮ ፔቴ ፔቴ ዋኣፆ ዴማ ፔቴ ፔቴ ፂሊ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ፂሎንታ ካኣፖንታ ሻርኖንታ ፔቴ ማዒ ጌኤሺ ዎርቄይዳፓ ዓርሲንቲ ማዢንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ሻርኖኮ ላንካይ ፖዒ ማዢ ቤርቶ ቤርቶ ዛላ ፖዓንዳጉዲ ዼጊዲ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ጋውጮና ጋውጮ ጌሦ ዓንዶና ጌኤሺ ዎርቄይዳፓ ማዤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ፖዖ ጌሦ ሻርኖና ዬያ ሜሆ ቢያ ኔ ማዣንዳ ሃይሢታሚ ዶንጎ ኪሎ ማዓ ጌኤሺ ዎርቄ ጊኢጊሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ዹኮ ዑፆይዳ ታ ኔና ዻዌ ጎይፆ ማዣኒ ኮሺ ማሊ ዒና ዔኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ሃሣ፦ «ታኣኒ ካኣሽኪንታንዳ፥ ዓፒላና ማዢንቴ ታኣም ዱማዼ ማኣሮኮ ጋሮይዳ ዲንኪ፥ ጋላፒ፤ ሃሣ ዞቄ ሱኡፖናይዳፓ ሱኪንቲያ ዱማሲሢሮ ጎኦቦንዶ ታጶ ዓፒላኣ ኮሼ፤ ዬያቶ ጊዶይዳ ኪሩቤኤሎ ሼኤሜና ማይሊ ሲኪ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ፔቴ ፔቴ ጎኦቦ ዓፒሎኮ ዖዶሱማ ላማታሚ ዖይዶ ዋዻ፥ ዓጮ ዳልጉማ ዖይዶ ዋዻ ማዒ ቢያሢ ሄኮ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ጎኦቦ ዓፒሎ ዶንጋሢ ዎላ ካንሢ ሲኬ፤ ሃሣ ሃንጎ ዶንጋሢያ ዒማይዴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ዎላ ካኣሚ ኮሺንቴ ላምዖ ጎኦቦ ዓፒሎኮ ዓጮይዳ ዓጮይዳ ዲንኪ ዓፒላና ኮሺንቴ ሱሢ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ጎኦቦ ዓፒሎ ቤርታሳዞኮ ቤርቶ ዛሎይዳ ዶንጊታሚ ሱሢ፥ ጎኦቦ ዓፒሎ ላምዓሳዞኮ ጋፒንፆ ዛሎይዳ ቤርታሳዞ ሱፆኮ ቤርታ ቤርታ ዶንጊታሚ ሱሢ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ዬንሢ ላምዖ ዛሎንሢ ዎላ ካንሣያ ማዓንዳጉዲ ዶንጊታሚ ዎርቄፓ ኮሺንቴ ዓይሣ ባኣዚ ጊኢጊሼ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«ዋኣሪ ጋፓኔና ማዢንቴ ታጶ ፔቴ ጎኦቦ ዓፒላ ዬያ ማኣሮኮ ካራ ማሂ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ዬንሢ ጎኦቦ ዓፒሎ ፔቴ ፔቴዞንሢኮ ዖዶሱማ ላማታሚ ላሆ ዋዻ፥ ዓጮ ዳልጉማ ዖይዶ ዋዻ ማዒ ቢያሢ ሄኮ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ዶንጋሢ ፔቴ ዛላ፥ ላሃሢ ባጎ ዛላ ማሂ ዎላ ካንሢጋፓ ሲኬ፤ ጎኦቦ ዓፒሎ ላሃሳዛ ጳንጪንቲ ቤርቶ ዛሎና ዓፒላፓ ማዢንቴ ማኣሮይዳ ጌሢንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ፔቴ ዛላ ዓኣ ጎኦቦ ዓፒሎኮ ጋፒንፆ ዛሎ ዓጮይዳ ዶንጊታሚ ሱሢ ኮሺ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ሱፆ ጋሮይዳ ዶንጊታሚ ሞኦኖ ዓንጎና ኮሺንቴ ዓይሦ ባኣዚ ጌልዜ፤ ዬያይዲ ላምዖ ዛሎ ዎላ ካንሢ ፔቴ ካራ ማዓንዳጉዲ ጊኢጊሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ዑሣ ዓኣዺ ዓቴያ ማዔ ዛሎ ጎኦቦ ዓፒሎ ዔኪ ዓፒሎና ማዢንቴ ማኣሮኮ ዙሎ ዛሎይዳ ሱፄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ዬያታ ዓፒላ ዖዶሱሞና ጎኦቦ ዓፒሎ ቢያይዳፓ ዑሣ ማዒ ፔቴ ፔቴ ዋዻ ሶንጌና ሃንጌና ዓፒላፓ ማዢንቴ ማኣሮ ኬስኪ ካንቃያ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«ዓፒላፓ ማዦና ማኣሮኮ ካራ ማዓንዳጉዲ፥ ፔቴ ዞቄ ቃላሜና ቲሽኪንቴ ዓዴ ማራይ ዒልዒ፤ ሜሌ ሃሣ ሺርኪንቴ ሻኣዣ ዒልዒዳፓ ላምዖ ካራ ቃሲ ማዤ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«ዓፒሎና ማዢንቴ ማኣሮ ሬኤኪ ዓርቃንዳጉዲ ዓርሲንቴ ላሾ ሚሢ ሻሪ ሚሢዳፓ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ፔቴ ፔቴ ላሾ ሚፆኮ ዖዶሱማ ሳሊ ዋዻ፥ ዳልጉማ ፔቴ ዋዻና ፓልፃና ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ላሾ ሚፃ ፔቴይዳ ዎላ ካኣሚ ዎሊ ዓርቃንዳጉዲ ፔቴ ፔቴ ላሾ ሚፆም ዎሊጉዲ ማዔ ላምዖ ላምዖ ዻንኬ ዓኣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ዓፒሎና ማዢንቴ ማኣሮኮ ዾኦሎ ዛሎና ላማታሚ ላሾ ሚሢ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ዬያቶኮ ዖይዲታሚ ቢራ ዓንጊና ኮሺንቴ ቶኪ ጊኢጊሼ፤ ላምዖ ኪሮ ዎላ ዓይሣንዳጉዲ ፔቴ ፔቴ ላሾ ሚፆኮ ላምዖ ላምዖ ቶኪ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ዓፒላፓ ማዢንቴ ማኣሮኮ ኬዶ ዛሎና ላማታሚ ላሾ ሚሢ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ፔቴ ፔቴ ላሾ ሚፆ ዴማ ላምዖ ላምዖ ቶኪ ኮሺ ዖይዲታሚ ቢራ ዓንጊ ቶኪ ዓኣያ ማሂ ጊኢጊሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ዓፒሎና ማዢንቴ ማኣሮኮ ዙሎ ዛላ፥ ጌይፃ ዓባ ጌላ ዛሎይዳ ላሆ ዓርሲንቴ ላሾ ሚሢ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ኮጫ ዎላ ካኣማ ካሮይዳ ላምዖ ላሾ ሚሢ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ዬንሢ ኮጫ ዎላ ካኣማ ካራ ዓኣ ላሾ ሚፆንሢ ሉኡፓ ዓርቂንቲ ቶኦኮ ሄላንዳኣና ካኣሜያ ማዓንዳያ ኮይሳኔ፤ ሃሣ ዓቴ ኮጫ ዎላ ካኣማ ካሮ ካንሣ ላምዖ ላሾ ሚፆንሢያ ዒዞ ጎይፆ ኮሺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ዬኖ ጎይፆና ፔቴ ፔቴ ላሾ ሚፆ ዴማ ላምዖ ቶኪ ዓኣያ ማዒ ታጶ ላሆ ቢራ ዓንጊና ኮሺንቴ ቶኪ ዓኣ ሳሊ ላሾ ሚሢ ዓኣያ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«ታጶ ዶንጎ ጋጋርሲ ሻሪ ሚሢዳፓ ኮሼ፤ ዔያቶይዳፓ ዶንጋሢ ዓፒላፓ ማዢንቴ ማኣሮኮ ፔቴ ዛላ ዓኣ ላሻሢ ሚፆም፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ሃሣ ዶንጋሢ ፔቴ ዛሎይዳ ዓኣ ላሻሢ ሚፆም፥ ዓቴ ዶንጋሢ ዓባ ጌላ ዛሎና ጌይፃ ጊንፆ ዛሎና ዓኣ ላሻሢ ሚፆም ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ሳዛኣ ዓኣ ጋጋርዛሢ ላሻሢ ሚፆኮ ዓጫፓ ዴንዲ ዓጮ ሄላንዳኣና ጌሢንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ላሻሢ ሚፆ ዎርቄና ጳርቂ ኮሼ፤ ጋጋርዞ ሚፆኮ ዓርቆያ ማዓንዳጉዲ ዎርቄና ኮሺንቴ ሱሢ ጊኢጊሼ፤ ጋጋርዛ ዎርቄና ጳርቂ ኮሺንቴያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ዓፒሎና ማዢንታ ማኣሮ ዹኮይዳ ታ ኔኤም ዻዌ ጎይፆማ ዾቄ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«ዲንኪ፥ ጋላፒ ሃሣ ዞቄ ዓፒላ ሱኪንቴ ሱኡፔፓ ጎኦቦ ዓፒላ ኮሼ፤ ዔያቶይዳ ኪሩቤኤሌ ሼኤሜና ማይሊ ሲኪ ኮሼ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ዬያ ሻሮ ሚፆፓ ኮሺንቲ ዎርቆና ጳርቂ ኮሺንቴ፥ ኪሮና ቢሮ ዓንጋ ቶካ ዓኣ ዖይዶ ቱርቱሮናይዳ ሱፄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ጎኦቦ ዓፒሎ ዓፒላና ማዢንቴ ማኣሮኮ ሳኮይዳ ዎሊ ሄሊ ጌሢንቴ ዓይሦ ባኮይዳ ሱፄ፤ ዬካፓ ላምዖ ዓርሲንቴ ሹጫ ዓኣ ጫኣቁሞ ሳኣፂኖ ጎኦቦ ዓፒሎኮ ጊንፆ ዛሊና ጌሤ፤ ዬያይዲ ጎኦቦ ዓፒላ ጌኤሺ ጌይንቴ ቤዞ ዑሣ ዓኣዼ ጌኤዦ ቤዛፓ ዱማሳያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ዬያይዴስካፓ ጫኣቁሞ ሳኣፂኖኮ ካሮ ዎዼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ዼጊ ጌዔ ሎኦዦ ዖይቶ ዑሣ ዓኣዼ ጌኤዦ ቤዞኮ ዙላ ዓፒላፓ ማዦና ማኣሮኮ ኬዶ ዛሎይዳ ጌሤ፤ ጊንሣ ፖዖ ጌሦ ሻርኖ ማኣሮኮ ዾኦሎ ዛሊና ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«ዓፒላፓ ማዢንቴ ማኣሮም ካራ ማዓንዳጉዲ ዲንኪ፥ ጋላፒ፤ ሃሣ ዞቄ ሱኡፖይዳፓ ሱኪንቴ ቃራ ዓፒላ ሼኤሜና ማይሊ ሲኪ ሚዛጲሶናያ ጎኦቦ ዓፒላ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ጎኦቦ ዓፒሎም ዶንጎ ቱርቱሪ ሻሪ ሚሢፓ ኮሺ ዎርቄና ዑፆ ጳርቂ ጊኢጊሼ፤ ዬያቶ ጊዶይዳ ጌሢንታ ኪራ ዎርቄና ኮሺንቴያ ማዖንጎ፤ ዬያቶ ቱርቱሮም ሞኦኖ ዓንጋፓ ማዢንቴ ዶንጎ ቶኪ ኮሼ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ሃሣ፦ «ሻሪ ሚሢዳፓ ታኣም ዒንጎ ባኮ ዒንጎ ቤሲ ጊኢጊሼ፤ ዬያኮ ዖዶሱማ ዖይዶ ዋዻና ፓልፃና፥ ዓጮ ዳልጉማ ዖይዶ ዋዻና ፓልፃና ማዔያ፤ ሃሣ ዼጉማ ላምዖ ዋዻና ፓልፃና ማዔያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ዎላ ካኣማ ዖይዶ ዛሎ ቢያሢዳ ዻንኬ ኮሼ፤ ዬይ ዻንካ ዒንጎ ባኮ ዒንጎ ቤዞና ዎላ ማዢንቴያ ማዖንጎ፤ ዬያ ቢያሢኮ ዑፃ ሞኦኖ ዓንጎና ጳርቂንቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ዲቢንፆ ዋሆንዶ ኩንዔ፥ ታሚ ካኣሾንዶ ቦኦቆ፥ ጋውቺና ሃሣ ታሚ ጌሢ ዔኤሦንዶ ባኮዋ ጊኢጊሼ፤ ዬይ ባካ ቢያ ሞኦኖ ዓንጎና ኮሺንቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ዒንጎ ባኮ ዒንጎ ቤዞ ዲርቃያ ማሂ ሮኦጬ ጋሶናጉዴያ ሞኦና ዓንጊና ኮሼ፤ ዬያ ባኮም ዖይዶ ሞኦና ዓንጊና ኮሺንቴ ሱሢ ዎላ ካኣማ ዖይዶ ካራ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ዬና ባኬላ ዒንጎ ባኮ ዒንጎ ቤዞኮ ጊዲሚዦ ሄላንዳጉዲ ዒንጎ ቤዞኮ ዳኣሮ ዴማ ማሂ ጊኢጊሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ታሚና ሚቺ ዒንጎ ባኮ ዒንጎሢ ኬዶንዶ ዛጶ ሚሢ ኮሺ ሞኦኖ ዓንጎና ዑፆ ጳርቄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ዒንጎ ባኮ ዒንጎሢ ኬዳኒ ኮይሳ ዎዶና ዛጳሢ ሚፆ ዒንጎ ባኮ ዒንጎሢኮ ፔቴ ፔቴ ዓጮና ዓኣ ሱፆ ጋሮ ጌልዜ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ዹኮይዳ ታ ኔኤም ዻዌ ጎይፆና ዒንጎ ባኮ ዒንጎ ቤዞ ላሾ ሚሢና ኮሺጋፓ ጋሮ ጉሪ ማሂ ጊኢጊሼ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«ዓፒላፓ ማዢንቴ ማኣሮኮ ዲሮ ጋራ ማዓ ካሮ ጉኡሢ፥ ዶዲ ፓቲሌና ኮሼ፤ ጎኦቦ ዓፒሎኮ ዖዶሱማ ዾኦሎ ዛሊና ፄኤታ ዋዻ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ዬና ዶዲ ዔቃንዳጉዲ ላማታሚ ሞኦና ዓንጊ ቶኪ ዓኣ ላማታሚ ቱርቱሪ ኮሼ፤ ዔያቶይዳ ቢራ ዓንጊና ኮሺንቴ ፒዝ ጌዔ ዓንጊና ኪሬና ዓኣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ኬዶ ዛሎና ዓኣ ዲሮ ጋራ ዓዳ ዒማ ጎይፆ ማዺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ዓባ ጌላ ዛሎና ዲሮ ጋሮም ታጶ ቶኪ ዓኣ ታጶ ቱርቱሪና ዎላ ዖዶሱማ ዶንጊታሚ ዋዻ ማዓ ጎኦቦ ዓፒላ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ጌሎ ካሮ ዛላ ዓኣ፥ ዓባ ኬስካ ዛሎና ዓኣ ዲሮ ጋሮኮ ዳልጉማ ዶንጊታሚ ዋዻ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","ጌሎ ካሮኮ ሻውሎና ሚዛቆና ዛሎይዳ ዖዶሱማ ታጶ ዶንጎ ዋዻና ፓልፃና ማዔ ጎኦቦ ዓፒላ ዓኣያ ማዖንጎ፤ ሃይሦ ቶኪ ዓኣ ሃይሦ ቱርቱሪ ዔያቶ ሬኤኪ ዓርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ፔ ቶኦኪና ጌሎ ካሮኮ ሌሊ ዖዶሱማ ላማታሚ ዋዻ ማዔ ዲንኪ፥ ጋላፒ ሃሣ ዞቄ ሱኡፔይዳፓ ሱኪንቲ ሚዛጲ ሼኤሜና ዑፆ ማይሊ ሲኮና ጎኦቦ ዓፒላ ዓኣያ ማዖንጎ፤ ዬኖ ዓፒሎ ሬኤኪ ዓርቃያ ዖይዶ ቶኪ ዓኣ ዖይዶ ቱርቱሪ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ዲሮ ካሮኮ ዙሎይዳ ዙሎይዳ ዓኣ ቱርቱራ ቢያ ፒዝ ጌዔ ቢሮ ዓንጎና ዓርቂንቴያ ማዖንጎ፤ ዬያቶይዳ ዓኣ ኪራኣ ቢራ ዓንጊና፥ ቶካ ጊንሣ ሞኦና ዓንጊና ኮሺንቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ዓፒሎና ማዢንቴ ማኣሮ ዲሮ ጋሮኮ ዖዶሱማ ፄኤታ ዋዻ፥ ዳልጉማ ዶንጊታሚ ዋዻ፥ ዼጉማ ዶንጎ ዋዻ ማዖንጎ፤ ጎኦቦ ዓፒላ ጉኡሢ ሻሎይዳፓ ኮሺንቴያ ማዒ ቶካ ሞኦና ዓንጊና ኮሾናያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ዓፒሎና ማዢንቴ ማኣሮኮ ጋሮይዳ ማዺንቶ ሜሃ፤ ሃሣ ዬያ ማኣሮንታ ጎኦቦ ዓፒሎ ፃውናኣ ቢያ ሞኦኖ ዓንጎና ኮሺንቴያ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«ፖዓ ዹሞና ቢያ ፖዔ ጎይሣ ዴዓንዳጉዲ ፖዖም ኮይሳ ቃራ ሪሚቲ ዛይቴ ኔኤም ዔኪ ዬዓንዳጉዲ ዒስራዔኤሌ ዴሮ ዓይሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ዓኣሮኔና ዒዛኮ ናኣቶና ዓፒሎና ማዦና፥ ታኣኒ ዒንሢና ካኣማ ማኣሮይዳ ፖዖ ጊኢጊሾንጎ፤ ታ ቤርቶይዳ ዹሜማፓ ካራንዳያ ሄላንዳኣና ፖዓንዳጉዲ ጫኣቁሞ ታኣቦቶ ሳኣፂኖኮ ቤርቶ ዛላ ዓኣ ጎኦቦ ዓፒሎኮ ዙላ ጌሦንጎ፤ ዬይ ዎጋ ዒስራዔኤሌ ዴሮና ሃጊ ሙካንዳ ሾይንቶናም ናንጊና ካፒ ማዺንታያ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ናንጊና ናንጋ ጎዳ ሃሣ ሙሴም፦ «ኔኤኮ ጌርሲ ዓኣሮኔና ዒዛኮ ናኣቶ ናኣዳኣቤ፥ ዓቢሁ፥ ዓላዜሬንታ ዒታማሬንታ ኔ ባንሢ ዔኤሌ፤ ዔያታ ቄኤሴ ማዒ ታኣም ማዻንዳጉዲ ዒስራዔኤሌ ዴሮ ባኣካፓ ዱማሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ዒዛም ቦንቾና ሚዛጱሞናኮ ማዓንዳጉዲ ኔ ጌርሲ ዓኣሮኔም ቄኤሴም ኮይሳ ዓፒላ ጊኢጊሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ታኣኒ ዱማ ዔራቶ ዒንጌ ፔ ኩጮ ዔራቶና ማዻ ዔሮ ዓሶ ዔኤሊጋፓ ዓኣሮኔም ዔያታ ዓፒላ ማዣንዳጉዲ ኬኤዜ፤ ያኣዒዳዛ ዓኣሮኔ ቄኤሴ ማዒ ታኣም ማዻኒ ዱማዼያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ዱማ ዱማ ኮሺንታንዳ ማኣዓሢ ሃካፓ ሊካ ፓይዲንታሢ ጎይፆ ማዖም፦ ዳዳ ጌሢንታ ቡራሻ፥ ዔፑዴ ጌይንታ ኬርና ቱኮ ዓፒላ፥ ቃሚሻ፥ ሼኤሜና ሲኪ ማይሊ ኮሾና ሹራቤ፥ ቶኦካ ማሮያንታ ኬርና ቱኮ ዓፒላንታኬ፤ ኔኤኮ ጌርሲ ዓኣሮኔንታ ዒዛኮ ናኣቶንታ ቄኤሴ ማዒ ታኣም ማዻንዳጉዲ ዬንሢ ዓፒሎንሢ ዔሮ ዓሳ ኮሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ዔያታ ዬንሢ ዓፒሎ፦ ዲንኪ፥ ጋላፒ፥ ሃሣ ዞቄ ሱኡፖ ዓፒላይዳፓ ጊንሣ ዎርቄና ቃራ ሚዛጲ ዓፒላናይዳፓ ሼኤሜና ማይሊ ጊኢጊሺ ኮሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«ዔፑዶ ዲንኪ፥ ጋላፒ፥ ዞቄ ሱኡፖ፤ ጊንሣ ሃሣ ዎርቄና ቃራ ሚዛጲ ዓፒላናይዳፓ ሼኤሜና ማይሊ ሲኪ ጊኢጊሺ ዔያታ ኮሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ላምዖ ዛላ ዎላ ካንሢንታንዳጉዲ ላምዖ ጌኤታ ካኣማ ካሮይዳ ዎጋሮጉዴ ሱሢ ኮሺንቲ ዓኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ዔፑዳ ማዢንቴ ባኮንሢዳፓ ዔራቶና ቃውሪ ኮሾና ኬርና ቱኮ ባካ ፔቴይዳ ዎላ ማዦናያ ማዒ ዔፑዶና ዎላ ዓይሢ ማዦናያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ሃሣ ላምዖ ዶዲ ሚዛጲ ሹቺ ዔኪ ታጶ ላምዖ ያይቆኦቤ ናኣቶኮ ሱንፆ ዒኢካ ቆኦቂ ቆኦቂ ፃኣፔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ዬያ ኔ ማዻንዳሢ ዔያቶኮ ሾይንቶ ዎዶ ዣኣሊሱዋዖ ዎሊ ሄሊሲ ሄሊሲ፥ ላሃሢ ፔቴዞይዳ ላሃሢ ጊንሣ ሜሌዞይዳ ቆኦቂ ፃኣፔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ላምዖ ሹጮይዳ ታጶ ላምዖ ያይቆኦቤ ናኣቶኮ ሱንፆ ቆኦቂ ፃኣፓንዳ ዔራቶ ዓኣ ጎኦባ ዓሲ ዴንቄ፤ ሹጮኮ ዎርቄና ዓጮ ማሂ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ታጶ ላምዖ ዒስራዔኤሌ ፃጶ ጶቂሣያ ማዓንዳጉዲ ላምዖ ሚዛጶ ባኮንሢ ጌኤቶ ዔፑዶ ዓፒሎኮ ሱፆይዳ ሮኦኬ። ዬያይዲ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ቢያ ኬሊ ታ ዴሮ ጶቂሣንዳጉዲ ዓኣሮኔ ዔያቶኮ ሱንፆ ፔ ጌኤቶይዳ ዔኪ ሃንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ዎርቄይዳፓ ላምዖ ፓልሞ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ጌኤሺ ዎርቄይዳፓ ሱሲጉዲ ዎላ ማርቴ ዣሎ ጉዴ ባኣዚ ላምዖ ኮሺ፥ ላምዖ ፓልሞንሢ ዎላ ዓይሤ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«ፆኦሲኮ ማሊፆ ዔራኒ ዖኦጮ ዳዶ ቡራሾ ቄኤሶ ቢያኮ ሱኡጋሢም ኮሼ፤ ማዢንቲፃ ዔፑዳ ማዢንቴ ጎይፆ ዒንሢ ባኮንሢና ማዢንቴያ ማዖንጎ፤ ሃሣ ዔፑዶ ሼኤሞና ማይሊ ሲኪ ሚዛጲሶናሢ ጎይፆ ሲኪንቲ ጊኢጌያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ዖዶሱማ ኬኤላ ዋዻ፤ ጊንሣ ዓጮ ዳልጉማኣ ኬኤላ ዋዻ ማዒ ጳንጪንቴያ ዖይዶ ዛላ ሄኮ ማዓያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ዖይዶ ዎሊጊንፆ ጌሦናያ፥ ሚዛጲ ሹቺ ፓልሞ ዒኢካ ኮሼ፤ ቤርታ ዎሊጊንፆ ጌሦዞይዳ ሴርዲዮኔ፥ ቶጳዚዮኔና ዊልጭ ዊልጭ ጋዓ ሚዛጲ ባኣዚ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ላምዓሳዞይዳ ቤሉሬ፥ ሴንፔሬና ዓልማዞ ጌይንታ ባኮ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ሃይሣሳ ቤዞይዳ ያኪንቴ፥ ኬልቄዶኔና ዓሜቴስፂኖሴ ጌይንታ ባኮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ዖይዳሳዞይዳ ቢሪሌ፥ ሜሬጌዴና ዒያስጲዴ ጌይንታ ባካ ዎርቄና ኮሺንቴ ባኮይዳ ጌሢንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ዒስራዔኤሌ ፃጶ ጶቂሣያ ማዓንዳጉዲ ሃንሢ ታጶ ላምዖ ሚዛጶ ሹጮ ፔቴ ፔቴዞንሢዳ ያይቆኦቤ ናኣቶ ፔቴ ፔቴሢኮ ሱንፃ ቆኦቂ ፃኣፒንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ዳዶ ቡራሾም ሱሲጉዲ ዎላ ማርቴ፥ ዣላሢጉዴ ባኣዚ ጌኤሺ ዎርቄይዳፓ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ላምዖ ዎርቄ ዢኢሮ ኮሺ ዳዶ ቡራሾኮ ኬዶ ዛሎና ዎላ ካኣማ ካሮይዳ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ዎርቆይዳፓ ኮሺንቴ ዣላሢ ማላ ላምዖ ባኮ ላምዖ ዢኢራሢና ዎላ ካንሢ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ባጎ ዛሎና ዓኣ ላምዖ ዣላሢ ማላ ባኮኮ ካሮንሢ ላምዖ ፓልሞንሢና ዎላ ካንሤ፤ ዬያይዲ ቤርቶ ዛሎና ጌኤቶይዳ ዓጊንታ ዔፑዶ ዓፒሎኮ ሱፆና ካንሢ ዓይሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ጊንሣ ላምዖ ዎርቄ ዢኢሮ ኮሺ ጋሮ ዛሎና ዔፑዶይዳፓ ሄሊሲ ዓኣ ዳዶ ቡራሾኮ ዾኦሎ ዛሎና ዎላ ካኣማ ካሮና ካንሢ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ዬንሢዳፓ ሜሌ ቃሲ ላምዖ ዎርቄ ዢኢሮ ኮሺ ቤርቶ ዛሎና ጌኤቶይዳ ዓጊንታ ዔፑዶ ዓፒሎኮ ሱፆና ዎላ ዾኦሎ ዛሎና ዓይሤ፤ ዎላ ዓይሣኒ ኮይሳሢያ ሲፓ ዎላ ካኣማ ካሮይዳ፥ ጊንሣ ሃሣ ዔራቶና ቃውሪ ኮሾና ኬርኖ ቱኮ ባኮኮ ኬዴኖይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ዳዶ ቡራሾይዳ ዓኣ ዢኢራሢ ዔፑዶይዳ ዓኣ ዢራሢና ዎላ ዲንኮ ዣላሢጉዴ ባኮና ቱኬ፤ ያዺ ማዔቴ ዳዶ ቡራሻ ኬርና ቱኮ ባኮኮ ኬዴ ማዔሢሮ ኮሪንዱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«ዓኣሮኔ ታኣም ዱማዼ ቤዞ ጌላ ዎዶና ዒስራዔኤሌኮ ፃጶ ሱንፃ ቆኦቂ ፃኣፒንቴ ዬኖ ቡራሾ ማኣዖንጎ፤ ዬያይዲ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ቢያ ዎዴና ዴሮ ታኣኮ ጶቂሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ታ ማሊፆ ዱማሲ ዔርዛ ባኮንሢ ኔ ዒዛም ዒዛኮ ዳዶ ቡራሾይዳ ዓጌ፤ ዓኣሮኔያ ዓፒሎና ማዢንቴ ጌኤዦ ማኣሮ ጌላ ዎዶና ዳዶ ቡራሾይዳ ዬያ ዔኪ ጌሎንጎ፤ ታኣኮ ማሊፆ ዒስራዔኤሌ ዴሮም ፔጋሲ ኬኤዛኒ ዳንዳዓንዳጉዲ ታ ቤርቶ ሺኢኪ ማዻኒ ዒ ጌላ ዎዶና ቢያ ዳዶ ቡራሾይዳ ዬንሢ ጌሦንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«ዔፑዶ ቃሚሻ ቢያ ዲንኪ ሱኡፖ ዓፒላፓ ኮሺንቴያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ቶኦኪና ጌልዚ ሆላ ማይንታኒ ጊኢጊሶናያ ማዖንጎ፤ ዬና ባኬላ ቡሊንቱዋጉዲ ጋርሲም ጳንጪንቲ ኩቻ ሲኮናያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","ዾኦሎ ዛሎ ዓጮና ዲንኪ፥ ጋላፒ፤ ሃሣ ዞቄ ሱኡፖይዳፓ ማዢንቴ ሮኦማኣኔ ሚፆ ዓኣፖ ማላ ባኣዚ ጌሤ፤ ዬኖ ዓኣፖኮ ባኣኮይዳ ጌላንዳ ዎርቄይዳፓ ማዢንቴ ዻካ ዻካ ሂቾ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ዓኣሮኔ ቄኤሴ ማዒ ታኣም ማዻኣና ዬያ ቃሚሾ ማኣዖንጎ፤ ታኣም ዱማዼ ቤዞይዳ ታ ቤርታ ዒ ጴዻ ዎዶና ማዖም ዒኢካፓ ኬስካ ዎዶና ሂቻሢኮ ዑኡዛ ዋይዚንታንዳሢሮ ሃይቢፓ ዒዚ ዻቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«ጌኤሺ ዎርቄይዳፓ ፔቴ ፓልሞ ማዢጋፓ ዑፆይዳ ‹ናንጊና ናንጋ ጎዳም ዱማዼያ› ጌይ ቆኦቂ ፃኣፔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ዬያይዴስካፓ ቶኦካ ማሪ ጌሦሢዳ ዲንኮ ዣሎ ማላ ባኮ ሱፄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ዓኣሮኔያ ዬኖ ፔ ባሊቶይዳ ጌሦንጎ፤ ዬያሮ ታኣም ዔኪ ሺኢኮ ባኮ ሺኢሺፆይዳ ዔያታ ዻቤታቴያ ዒስራዔኤሌ ዓሳ ታኣም ዒንጋ ዒንጊፆ ቢያ ታኣኒ ናንጊና ናንጋ ጎዳ ዔካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«ዓኣሮኔኮ ሹራቦንታ ቶኦካ ማሮ ባኮንታ ቃራ ሱኡፖ ዓፒላና ኮሼ፤ ዒዚ ኬርና ቱካ ባካ ቃራ ሱኡፖ ዓፒላና ኮሺንቲ ሼኤሜና ማይሊ ሲኪ ጊኢጊሾናያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«ዓኣሮኔኮ ዓቲንቆ ናኣቶም ቦንቾና ሚዛጱሞናኮ ማዓንዳጉዲ ሹራቦ፥ ኬርና ቱኮ ባኮንታ ቶኦካ ዓጎ ቆኦቦዋ ኮሺ ጊኢጊሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ዬያይዲጋፓ ዓካሪ ዬንሢ ዓፒሎንሢ ኔ ጌርሲ ዓኣሮኔና ዒዛኮ ናኣቶና ማይሴ፤ ታኣም ዔያታ ቄኤሴ ማዒ ማዻንዳጉዲ ሪሚቶ ዛይቶና ኔ ዔያቶ ቲሽኪ ቄኤሴ ማሂ ታኣም ዱማሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ካሉማ ዔያቶኮ ፔጋዹዋጉዲ ቃራ ሱኡፖ ዓፒላና፥ ዔያቶኮ ኬርናፓ ዴንዲ ሙርታሢ ሄላንዳ ቆንፄ ዔያቶም ጊኢጊሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ዓኣሮኔና ናኣቶና ቢያ ኬሊ ዓፒላፓ ማዢንቴ ጌኤዦ ማኣሮ ጌላ ዎዶና፥ ሃሣ ጊንሣ ጌኤዦ ቤዞይዳ ቄኤሴ ማዒ ማዻኒ ዒንጎ ባኮ ዒንጎ ቤዞ ባንሢ ሙካዖ ዬያ ማይንቶንጎ፤ ዬያይዲፆና ዔያቶኮ ካሉማ ጴዺንዱዋሢሮ ሃይቢፓ ዔያታ ቶላንዳኔ፤ ዬይ ዓካሪ ዓኣሮኔና ዒዛኮ ዜርፆናም ቢያ ዶዲ ናንጋንዳ ዎጌ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ናንጊና ናንጋ ጎዳ ሃሣ ሙሴም፦ «ዓኣሮኔንታ ናኣቶንታ ታ ቤርታ ታኣም ማዻንዳጉዲ ኔ ዔያቶ ዱማሳኒ ማዻንዳ ባካ ያዺኬ፤ ዔኤቢ ቦሂሳ ባኣዚ ባኣያ ፔቴ ዎፓናና ላምዖ ዓዴ ማራናይ ዔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ዛርጌ ዺኢሊ ዔኪ ዛይቶ ቲዦ ዋሂ ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ ላኣዴ፤ ሃሣ ዬያጉዲ ዛይቴ ጌሊባኣ ሜሌ ላኣዳ ላኣዴ፤ ጊንሣ ሃሣ ሻኣዣ ላኣዳ ላኣዲጋፓ ዛይቶ ቲዦና ቲሽኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ቢያሢ ሌኤማቴይዳ ጌሢጋፓ ዎፓናሢና ላምዖ ዓዶ ማራቶንሢ ሹኪ፥ ታኣም ኔ ዒንጋ ዎዶና ዒንጎ ባኣዚ ማሂ ዎላ ሺኢሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«ዓኣሮኔና ዒዛኮ ናኣቶና ታ ካኣሽኪንታ፥ ዓፒላፓ ማዢንቴ ማኣሮ ካሮ ዔኪ ሙኪጋፓ ዔያታ ፔኤኮ ዑፆ ማስታንዳጉዲ ዔያቶም ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ዬካፓ ዓኣሮኔም ቄኤሶ ማኣዓሢ ማይሴ፤ ዒዚ ፔኤኮ ሹራቦ፥ ዔፑዶ፥ ዔፑዶይዳ ቃሲ ማኣዒንታ ቃሚሾ፥ ዳዶ ቡራሾንታ ኬርና ቱኮ ባኮ ቢያ ማኣዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ዒዛኮ ቶኦኮይዳ ማሮ ዓፒሎ ማሪ ‹ናንጊና ናንጋ ጎዳም ዱማዼያ› ጌይንቲ ቆኦቂ ፃኣፒንቴ ፓልማሢ ፓልሚሴ፤ ዬይ ፆኦሲም ዒዚ ዱማዼያ ማዔሢ ዔርዛ ማላታ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ቲሽኮ ዛይቶ ዔኪ ቶኦካ ዒዛኮ ዋሂ ቲሽኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","«ዓቲንቆ ናኣቶዋ ዒዛኮ ዔኪ ሙኪ ሹራቦ ማይሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ኬርና ዔያቶኮ ቱኮ ባኮ ቱኬ፤ ቶኦካ ዔያቶኮ ቆኦቦ ዓጌ፤ ዓኣሮኔና ዒዛኮ ናኣቶና ኔኤኒ ቄኤሴ ማሃንዳሢ ዬያይዲኬ፤ ዔያቶና ዔያቶኮ ዜርፃ ቢያ ቄኤሴ ማዒ ናንጊና ታኣም ማዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«ዓፒሎና ማዦና ታኣኒ ካኣሽኪንታ ማኣሮ ካሮ ዎፓናሢ ኔኤኒ ዔኪ ሙካዛ ዓኣሮኔና ዒዛኮ ናኣቶና ኩጮ ዔያቶሲ ጌሜ ቶኦካ ጌሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ዬካፓ ዎፓናሢ ዓፒሎና ማዢንቴ ማኣሮ ካራ ታ ቤርቶይዳ ሹኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ዎፓኖንሢኮ ሱጉፆ ኬኤላና ዔኪ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞይዳ ዓኣ ቃጶንሢ ቲሽኬ፤ ዓቴ ሱጉፆ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዴማ ዋሄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ጎጶ ባኮ ካንቄ ሃኣቦና ማዮኮ ሻኣዣዻ ቤዞ፥ ላምዖ ጳላሢና ዬያቶ ካንቄ ሃኣቦ ዔኪ ታኣም ዒንጊንታ ዒንጊሢ ማሂ ሚቺ ዒንጎ ቤዞይዳ ሚቼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ዎፓናሢኮ ዓሽኮ፥ ዜዾ፥ ሩቁንቶንታ ቢያ ዔኪ ማኣሮኮ ካራፓ ሃኬ ኬሲ ሚቼ፤ ዬይ ቄኤሶኮ ጎሞ ጌኤሻኒ ዒንጊንታ ዒንጊሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«ላምዖ ዓዶ ማራቶንሢዳፓ ፔቴሢ ኔ ዔኪ ሙካዛ ዓኣሮኔንታ ዒዛኮ ናኣቶንታ ፔኤኮ ኩጮ ዬያ ማራዓሢ ቶኦካ ጌሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ማራዓሢያ ሹኪጋፓ ሱጉፆ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዖይዶ ዛሎ ፑጬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ዓሽኮ ሜኤሎና ሜኤሎና ቲቄ፤ ጎጶ ባኮና ጊንፆ ቶኮ ዋኣሢና ማስኪጋፓ ቶኦኮንታ ሜሌ ሜኤሎ ዓሽኮናኮ ዑፃ ጌሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ዬካፓ ዓዶ ማራዓሢኮ ዓሽኮ ጉቤ ሙኡዚ ዒንጊሢ ማሂ ሚቼ፤ ዬያ ዒንጊፆኮ ሳውማ ታኣም ኮሽካያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«ቄኤሶ ማሂፆ ዎጎም ጌሢንቴ ባጎ ማራዖ ዓዳሢ ኔኤኒ ዔኪ ሙካዛ፥ ዓኣሮኔና ዒዛኮ ናኣቶና ኩጮ ማራዓሢኮ ቶኦካ ጌሦንጎ ጌዒ ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ማራዓሢያ ሹኪጋፓ ሱጉፃፓ ዻካ ዔኪ ዓኣሮኔና ዒዛኮ ናኣቶናኮ ሚዛቆ ዋዮኮ ቤርቶ፥ ሚዛቆ ኩጮና ሚዛቆ ቶኮናኮ ዶኦሞ ኬኤሎ ቲሽኬ፤ ዓቴ ሱጉፆ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዖይዶ ዛሎ ጎኦባ ፑጬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞይዳ ዓኣ ሱጉፆይዳፓ ዻካ፥ ቲዦ ዛይቶይዳፓ ዻካ ዔኪ ዓኣሮኔና ዒዛኮ ማኣዓሢናይዳ፤ ጊንሣ ዓኣሮኔኮ ናኣቶና ዔያቶኮ ማኣዓሢና ዑፃ ፑጬ፤ ዬያይዲ ዒዛንታ ዒዛኮ ናኣቶንታ ዔያቶኮ ማኣዓሢያኣ ታኣም ዱማዼያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«ዓዶ ማራዓሢኮ ማሎ፥ ካሾ፥ ጎጶ ባኮ ካንቄ ሃኣቦ፥ ማዮኮ ሻኣዣዻ ቤዞ፥ ላምዖ ጳላሢ፤ ጊንሣ ዔያቶ ካንቄ ሃኣቦንታ ሚዛቆ ዛሎና ዓኣ ጊንፆ ቶኮ ዓሽኮ ቢያ ሙሬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ሌኤማቶይዳ ታኣም ሺኢሾና ዱማ ዱማ ላኣዶይዳፓ ፔቴ ሙሊሢ ዔኬ፤ ኔ ዔካንዳሢያ ዛይቶ ቲዦ ዋሂ ካሦናሢዳፓ ፔቴ፥ ዛይቶ ቲዣ ዋሂንቲባኣሢዳፓ ፔቴ፤ ዬያጉዲ ሻኣዦ ላኣዶይዳፓ ፔቴ ቃሲ ዔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ዬያ ሙዖ ቢያ ዓኣሮኔና ናኣቶና ኩጮይዳ ዓይሤ፤ ዬያ ሌካ ሊካ ዡጊ ጪራሺ ዒንጊንታ ዱማ ዒንጊሢ ማሂ ታኣም ዔያታ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ዔያቶይዳፓ ዔኪ ታኣም ሙኡዚ ዒንጊሢ ማሂ ዒንጋኒ ሚቺንቲ ዒንጊንታ ዒንጊፆኮ ቤርቶይዳ ጌሢ ሚቺ ዒንጎ ቤዛ ሚቼ፤ ዬያ ዒንጊፆኮ ሳውማ ታና ዎዛሳያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«ዓኣሮኔኮ ቄኤሱሞ ዎጎም ሹኪንቴ ዓዶ ማራዓሢኮ ዚኢሮ ዔኪ ታኣም ሌካ ሊካ ዡጊ ጪራሺ ዒንጊንታ ዒንጊሢ ማሂ ዒንጌ፤ ዬይ ዒንሢ ዛላ ማዓያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«ፔቴ ቄኤሴ ቄኤሱሞ ማዻ ጌላኣና ቄኤሱሞ ዎጎም ሹኪንታ ዓዶ ማራዓሢኮ ዚኢሮና ሚዛቆ ዛሎና ዓኣ ጊንፆ ቶኮ ታኣም ሌካ ሊካ ዡጊ ጪራሺ ዒንጊንታ ዒንጊሢ ማዒ ዒንጊንቶንጎ፤ ዬይ ጊንሣ ቄኤሶ ዛላ ማዓያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ታኣኮ ዴራ ዻቂንቶም ማዓ ፔቱሞና ዒንጎ ባኮ ዒንጋ ዎዶና ቆልሞኮ ዚኢሮና ሚዛቆ ዛሎና ዓኣ ጊንፆ ቶካ ቄኤሶ ዛላ ማዓንዳጉዲ ታ ጌዔኔ፤ ሃይ ታ ጌዔ ባካ ላኣሚንታዓኬ፤ ዬይ፥ ዒንጎ ባካ ዴራ ታና፥ ናንጊና ናንጋ ጎዳም ዒንጋያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«ዓኣሮኔ ሃይቃዛ ዒዛኮ ማኣዓሢ ዒዛ ናኣቶም ማዖንጎ፤ ዔያታ ቲሽቲ ቄኤሶ ማዔ ዎዶና ዬያ ማኣዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ቄኤሶ ማዒፆ ዻካላዖ ጌኤዦ ቤዞይዳ ታኣም ማዻኒ ቄኤሴ ማዒ ዓፒሎና ማዢንቴ፥ ታኣኮ ጌኤዦ ማኣሮ ጌላ ዓኣሮኔ ናዓሢ ዬንሢ ማኣዖንሢ ላንካይ ኬሊ ማይንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«ዓኣሮኔና ናኣቶና ቄኤሶ ማዓ ዎዶና ሹኪንታ ዓዶ ማራዓሢ ዓሽኮ ዔኪ ጌኤዦ ቤዞይዳ ካሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ዬያ ዓሽኮ ሌኤማቴይዳ ዔኪ ዓቴ ላኣዶና ዎላ ዓፒሎና ማዢንቴ፥ ታኣኒ ዒንሢና ካኣማ ማኣሮ ካራ ዔያታ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ቄኤሶ ዔያታ ማዓኣና ጎሞ ጌኤሺፆም ዒንጊንቴሢ ሙዖንጎ፤ ዬይ ሙዓ ታኣም ዱማዼያ ማዔሢሮ ቄኤሳ ሌሊ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ዓሽካፓ ማዔቶዋ ላኣዳፓ ሙይንቱዋዖ ዓቲ ዎርቄይ ዓኣቶ ታሚና ሚቺንቶንጎ፤ ታኣም ዱማዼያ ማዔሢሮ ሙይንታኒ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«ዓኣሮኔና ናኣቶና ቄኤሱሞ ዔካ ዎጎ ታኣኒ ዓይሤማ ጎይፆ ላንካይ ኬሊዳ ማዺ ኩንሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ጎሜ ጌኤሺሢም ፔቴ ፔቴ ኬሎና ፔቴ ዎፓና ዒንጎ ባኣዚ ማሂ ሺኢሼ፤ ዬይ፥ ዬያ ዒንጎ ቤዞ ታኣም ዱማሳያኬ፤ ታኣም ዱማዼያ ማዓንዳጉዲ ሪሚቶ ዛይቶ ቲዦና ቲሽኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ዬያ ላንካይ ኬሊዳ ቢያ ማዼ፤ ዬያይዲፆና ዒንጎ ቤዛ ታኣም ዱማዼያ ማዓንዳኔ፤ ዓሲ ማዔቴያ ሜሌ ባኣዚ ዬያ ቤዞ ካኣሜቴ ታኣም ዱማዼያ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«ቢያ ኬሊ ፔቴ ሌዔ ማዔ ላምዖ ዓዴ ማራናይ ዒንጎ ባኣዚ ማሂ ዒንጎ ቤዛ ሚቺ ዒንጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ማራናኣቶይዳፓ ፔቴማ ጉቴ፥ ባጎማ ዒባናኣና ሹኪ ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ቤርታኣ ማራናዖና ዎላ ፔቴ ላኣዳ ኬስካንዳ ቃራ ዛርጌ ዺኢሊ ፔቴ ዶሎዜ ማዓ ሪሚቶ ዛይቶ ቲዦና ዲርኪ ዒንጌ፤ ሃሣ ፔቴ ዶሎዜ ዎይኖ ዓኣፖ ዑዦ ዒንጎ ባኣዚ ማሂያኣ ሺኢሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ላምዓሳ ማራናዓሢ ሳዓ ዒባናኣና ሹኪ ዒንጎ ባኣዚ ማሂ ሺኢሼ፤ ጉቴሎ ኔ ዒንጌ ጎይፆ ዺኢላ፥ ዛይቶ ቲዣ፥ ዑዦዋ ዒንጌ፤ ዬይ ታና፥ ናንጊና ናንጋ ጎዳም ዒንጊንታ ሙኡዚ ዒንጊሢኬ፤ ሳውማኣ ታና ዎዛሳያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ቢያ ዎዴ ሃይ ሚቺ ዒንጊንታ ዒንጊፃ ታኣኒ ዒንሢና ካኣማ፥ ዓፒላፓ ማዢንቴ ማኣሮ ካራ ዒንጊንታንዳያ ኮይሳኔ፤ ታኣኒ ታኣኮ ዴሮና ካኣማንዳሢና ኔኤናኣ ታ ጌስታንዳሢ ዒኢካኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ዬያይዲ ታ ዴሮ፥ ዒስራዔኤሌና ታኣኒ ካኣማንዳኔ፤ ታኣኮ ቦንቻኣ ዬያ ቤዞ ታኣም ዱማዼያ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ታኣኒ ዒንጎ ባኮ ዒንጎ ቤዞንታ ዓፒሎና ማዢንቴ ማኣሮ ታኣም ዱማሳንዳኔ፤ ታኣም ዔያታ ቄኤሴ ማዒ ማዻንዳጉዲ ዓኣሮኔንታ ዒዛኮ ናኣቶንታ ታኣኒ ዱማሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ታኣኮ ዴሮ፥ ዒስራዔኤሌ ባኣካ ታኣኒ ናንጋንዳኔ፤ ታ ዔያቶኮ ፆኦዛሢ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ታ ዔያቶኮ ባኣካ ናንጋኒ ጊብፄ ዓጮይዳፓ ታ ዔያቶ ዔኪ ኬሴ፥ ናንጊና ናንጋ ጎዳ ማዔ ዔያቶኮ ፆኦዛሢታሢ ዔያታ ዔራንዳኔ፤ ጎኔና ታ ዔያቶኮ ፆኦሲ፥ ናንጊና ናንጋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ናንጊና ናንጋ ጎዳ ሃሣ ኬኤዛዖ፦ «ጩቢሶንዶ ዑንጆም ማዓንዳ ቤሲ ሻሪ ሚሢዳፓ ኮሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ዖዶሱማ ፔቴ ዋዻ፥ ዓጮ ዳልጉማ ፔቴ ዋዻ፥ ሌካ ዼጉማ ጊንሣ ላምዖ ዋዻ ማዒ ጊኢጊንቲ ዖይዶ ዛላ ዎላ ካኣማያ ማዖንጎ። ዖይዶ ዛሎና ካኣማ ካሮይዳ ዓኣ ዻንኮንሢ ቢያ ዒዞና ዎላ ፔቴ ማዒ ኮሺንቴያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ዒንጎ ቤዞኮ ቤርቶ፥ ዖይዶ ዛሎንታ ዻንኮንሢያ ቢያ ጌኤሺ ዎርቄና ጳርቂ ዓጮዋ ዎርቄና ማሂ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ላምዖ ዎርቄ ዢኢሮ ኮሺ ዒንጎ ቤዜሎ ኬዶንዶ ዛጳሢ ሚፃ ጌላንዳ፥ ዎርቆና ኮሺንቴ ዳኣሮ ዴማ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ዛጶ ሚፆዋ ሻሪ ሚሢዳፓ ኮሺ ዎርቄና ጳርቄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ዬያ ዒንጎ ቤዞ ጎኦቦ ዓፒሎና ጫኣቁሞ ታኣቦቶናኮ ቤርቶ ዛላ፤ ሃሣ ታኣኒ ኔኤና ዎላ ካኣማ ታኣቦቶ ዑፃ ዓኣ ጎሞ ጌኤሺፆ ዔርዛ ጉኡፖኮ ቤርቶ ዛላ ጌሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ዓኣሮኔ፥ ጉቶ ጉቶ ፖዖ ጊኢጊሻኒ ሙካኣና ቃራ ሳውቃ ዑንጄ ዒንጎ ቤዞይዳ ጩቢሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ሃሣ ዋንቶ ዋንቶዋ ፖዖ ፖዒሳኣና ዬያጉዲ ማዾንጎ፤ ሃይ ዑንጆ ዒንጎ ዒንጊፃ ሙካ ሾይንቶ ቢያና ጋፑዋዖ ማዺንታያ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ዬኖ ዒንጎ ባኮ ዒንጎ ቤዞይዳ ላኣጊንቴ ዑንጄ፥ ቆልሞ ሹኪ ዒንጎ ዒንጊሢ፤ ሃሣ ሃኣኮይዳፓ ዒንጎ ባኣዚ ዒንጊፖ፤ ዎይኖ ዑዦዋ ዒኢካ ዋሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ዓኣሮኔ ሌዓ ሌዓ ፔቴና ጎሞ ጌኤሺፆም ሹኪንቴ ቆልሞ ሱጉፃፓ ዔኪ ዖይዶ ዻንኮንሢ ዑፆይዳ ጌሢ ዒንጎ ቤዜሎ ጌኤሾ ዎጎ ኩንሦንጎ፤ ዬይ ዎጋ ሙካ ሾይንቶ ቢያና ሌዓ ሌዓ ማዺንቶንጎ፤ ዬያይዲ ሃይ ዒንጎ ቤዛ ናንጊና ናንጋ ጎዳሢም ፔቶ ዱማዼያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«ዒስራዔኤሌ ዴሮ ኔ ፓይዳ ዎዶና ዱማ ዱማ ዶርዓ ዔያቶ ዓርቁዋጉዲ ዴራ ፔኤኮ ሼምፖ ዛሎም ማዓ ባኣዚ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ዴሮ ባኣካ ፓይዲንታ ፔቴ ፔቴ ዓሳ ዓፒሎና ማዢንቴ፥ ታኣኮ ማኣሮይዳ ዒንጎም ዔርቴ ጎይፆ ላሆ ጊራኣሜ ማዓ ሹቺ ቢራ ታና፥ ናንጊና ናንጋ ጎዳሢም ዔኪ ሺኢሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ዴሮ ፓይዶይዳ ጌላኒ ዳንዳዓሢ፥ ጌይፃ፦ ሌዓ ላማታሚ ኩሜሢና ዬያፓ ዑሣ ማዔሢ ቢያ ዬኖ ዒንጊፆ ዒንጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ዔያታ ፔኤኮ ሼምፓሢ ዛሎ ዬኖ ዒንጎ ባኮ ዒንጋ ዎዶና ዖርጎጫሢታቴያ ማንቃሢ ሄኮ ጪጋንዳኣፓዓቴም ዖርጎጫሢኮ ጪጋ ሚርጌ፥ ማንቃሢሲ ዻካ ማዖፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ዬያ ዒንጊፆ ዒስራዔኤሌ ዴሮይዳፓ ቡኩሲ ዔኪ ዓፒሎና ማዢንቴ፥ ታኣኮ ማኣሮ ማዾም ፔኤሼ፤ ዬይ ዒንጊፃ ዔያቶኮ ሼምፓሢ ዛሎ ማዓንዳኔ፤ ታኣኒያ ዔያቶ ጶቂሢ ካፓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ናንጊና ናንጋ ጎዳ ሃሣ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«ዋኣሢ ማስቶ ሳኣኔ ሞኦኖ ዓንጎና ኮሺ፥ ቶኪ ዓኣ ሞኦኖ ዓንጎና ማዢንቴ ሳኣኖ ጌሦ ቤዞይዳ ጌሤ፤ ዬኖ ናንጊና ናንጋ ጎዳም ዒንጎ ባኮ ዒንጎ ቤዞና ዓፒሎና ማዢንቴ ማኣሮናኮ ሳዛ ጌሢ ዋኣሢ ዋሄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ዓኣሮኔንታ ዒዛኮ ናኣቶንታ ዬያ ዋኣፆና ፔኤኮ ኩጮና ቶኮና ማስቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ዬያ ዔያታ ማዻኒ ኮይሳሢ ዓፒሎና ማዢንቴ ማኣሮ ጌላንዳሢና ሙዖ ዒንጊፆ ዒንጎ ቤዞ ሺኢካንዳሢኮ ቤርታኬ፤ ያዺ ዔያታ ማዼቶ ሃይቢዳፓ ቶላንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ዬያሮ ዔያታ ሃይቁዋጉዲ ዔያቶኮ ቶኮና ኩጮና ዔያታ ማስቶንጎ፤ ዬይ፦ ዔያቶና ዔያቶኮ ጊንፃፓ ኬስካንዳ ዜርፃ ናንጊና ካፓንዳ ዎጌኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«ቃራ ሳውቃ ዼኤሻ፥ ላሆ ዶሎዜ ማዓንዳ ኬርቤ፥ ፔቴ ኮኦማ ማዓንዳ ቄሬፓ ጌይንታ ሚፆ ቁኡሮ፥ ፔቴ ኮኦማ ማዓንዳ ቃራ ሳውቃ ማኣቲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ላሆ ሙሊሢ ቤርጉዴ ጎዖ ዑንጆ ዔኬ፤ ዬይ ቢያሢ ዓፒሎና ማዢንቴ፥ ታኣኮ ማኣሮይዳ ዒንጊንቲ ዔርታሢጉዴያ ማዖንጎ፤ ዬያይዳ ዖይዶ ዶሎዜ ዛይቴ ዋሂጋፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ሳውቃ ቲሺጉዲ ዱማዼ ዛይቴ ቲሺ ኮሼ፤ ዬይ ዱማዼ ዛይቴ ቲሺ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ዓፒሎና ማዢንቴ፥ ታኣኒ ዒንሢና ካኣማ ማኣሮ፥ ጫኣቁሞ ታኣቦቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ዼጌ ሎኦዦንታ ዬያ ዑፃ ዓኣ ባኮ ቢያ፥ ፖዖ ጌሦ ሻርኖንታ ዬያይዳ ጊኢጊሾ ባኮ፥ ዑንጆ ጩቢሳኒ ጊኢጊሾ ቤዞ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ሚቺ ዒንጊንታ ባኮ ዒንጎ ቤዞንታ ዒኢካ ዓኣ ባኮ ቢያ፤ ዬያጉዲ ዋኣፆ ማስቶ ሳኣኖንታ ጌሦ ቤዞዋ ዬያና ቲሽኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ዬያይዲ ሃንሢ ቢያ ኔ ዱማሲሢና ፔቶ ዱማዼያ ማሃንዳኔ፤ ዔያቶ ካኣማ ዓሲ ማዔቴያ ሜሌ ባኣዚ ቢያ ታኣም ዱማዼያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ዓኣሮኔና ናኣቶና ቄኤሴ ማዒ ታኣም ማዻንዳጉዲ ዔያቶ ቲሽኪ ቄኤሴ ማሄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ዒስራዔኤሌ ዴሮማኣ ሂዚ ጌዒ ኬኤዜ ‹ሃይ ታኣም ዱማዼ ቲዦ ዛይታ ሙካ ሾይንቶና ቢያ ታ ማዾም ማዓያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ጉሪ ዓይጎ ዓሲ ዑሢዳኣ ማዖም ቲሽኪንቶፖ፤ ዬያ ማላያ ሜሌ ቲሺ ኮሺፖቴ፤ ዬይ ዱማዼያ ማዔሢሮ ዒንሢና ኮሺ ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ዬያ ማላ ቲሺ ኮሻሢ፤ ሃሣ ዬያ ቲዦይዳፓ ዔኪ ቄኤሴ ማዒባኣ ዓሲ ቲሽካሢ ታኣኮ ዴሮይዳፓ ፔቴሢ ማዒ ፓይዲንታዓኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ፔቴ ፔቴሢኮ ዴኤሡማ ሄኮ ማዔያ ኮዦ ሳውቃ ዼኤሾ፤ ዬይያ፦ ፆዻያ ማዔ ማኣሢ፥ ኪቤይዳፓ ዔውታ ሳውቃ ቲሺ፥ ሳውቃ ማኣሢንታ ቃራ ሳውሞ ዓኣ ዑንጆዋ ዔኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ሳውቃ ዼኤሾ ኮሻ ዓሳ ኮሻሢጉዲ ቃራ ሳውሞ ዓኣ ዑንጄ ጊኢጊሼ። ጌኤሺ ሃሣ ዱማዼያ ማዓንዳጉዲ ሶኦጌ ጊዳ ዋሄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ዬያይዳፓ ዻካ ዔኪ ዑዲ ሺኢቼስካፓ ታኣኒ ኔኤና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮ ዔኪ ዓኣዺ ጫኣቁሞ ታኣቦቶኮ ቤርታ ጌሤ፤ ዬይ ዑንጃ ኮሺ ዑሣ ዓኣዼ ጌኤሺ ዱማዼያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ዬያይዲ ዒንሢም ማዓ ሜሌ ዑንጄ ኮሺሢዳፓ ዒንሢና ካፑዋቴ፤ ታኣም ዱማዼያ ማዔሢሮ ዒንሢ ዬያ ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ዬያጉዴ ባኣዚ ማዺ ሳውሞና ዎዛዻኒ ማላ ዓሲ ዓኣቴ ታኣኮ ዴሮይዳፓ ፔቴሢ ማዒ ፓይዲንታዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«ሃይሾ ታኣኒ ዪሁዳ ማኣራፓ ሁኡሬ ጎዖሢኮ ናኣዚ ናዖ ማዔሢ፥ ዑኡሬ ናኣዚ፥ ባስሊዔኤሌ ዶኦሬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ዓይጎ ባኣዚያ ማዖም ኩቺ ማዾ ሃኣማቶ ዔራንዳጉዲ ጶቂሥሢና ጪንጩሞና፤ ሃሣ ዔራ ማዓንዳጉዲ ታኣኮ ዓያኖንታ ዎልቄያ ታ ዒዛም ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ዬያሮ ጪንጩሞና ማዾንዶ ጎይሢ ማሊ ኬሲ ዎርቄይዳፓ፥ ቢራና ሞኦኖ ዓንጎናይዳፓ ዱማ ዱማ ባኣዚ ዒ ኮሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ዬያጉዲ ፓልሞም ማዓ ሚዛጶ ሹጮ ቆኦቂ ኮሻኒ፥ ሚሢያ ዓርሳኒ፥ ሜሌ ማዾ ቢያ ዔራቶና ማዻኒ ዒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ዒዛና ዎላ ሃሣ ማዻንዳጉዲ ዳኣኔ ማኣሮይዳፓ ዓይሳማኬ ናኣዚ ዔኤሊያቤ ታ ዶኦሬኔ፤ ታ ኔና ዓይሤ ባኮ ቢያ ዔያታ ማዻንዳጉዲ ኩቺ ሃኣማቶ ዓኣ ሜሌ ዓሶማኣ ቢያ ዼኤፒ ዔራቶ ታኣኒ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ማዺንታንዳጉዲ ታ ዓይሤ ባካ ያዺኬ፦ ታኣኒ ዒንሢና ካኣማ ዓፒሎና ማዢንታ ማኣሮ፥ ጫኣቁሞ ታኣቦቶንታ ዎዾ ካሮንታ፥ ዓፒሎና ማዢንታ ማኣሮ ጋራ ማዾ ባኮ ቢያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ዼጌ ዳልጎ ሎኦዦንታ ዬያም ኮይሳ ባኮ፥ ጌኤዦ ዎርቃፓ ኮሺንታ ፖዖ ጌሦ ሻርኖና ዬያም ኮይሳ ባኮ ቢያ፥ ዑንጆ ዒንጊፃ ዒንጊንታ ቤዞ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ሚቺ ዒንጎ ዒንጊፆም ማዓ ቤዞና ዬያም ኮይሳ ባኮ ቢያ፥ ዋኣፆ ማስቶ ሳኣኖንታ ጌሦ ቤዞንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ዓኣሮኔና ዒዛኮ ናኣቶና ቄኤሴ ማዒ ማዻኣና ዔያታ ማኣዓንዳ ሚዛጶ ዱማዼ ማኣዓሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ቲዦ ዛይቶና ታኣም ዱማዼ ቤዞም ማዓ ኮዦ ሳውማ ዓኣ ዑንጆ፥ ዬያ ቢያ ባኮ ዔያታ ማዻንዳሢ ታ ኔና ዓይሤ ጎይፆማኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሣዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«ዒስራዔኤሌ ናኣቶም ሂዚ ጌዒ ኬኤዜ፦ ሃውሾ ኬሊ ማሂ ታ ዶኦሬ ቦንቾ ኬሎ ካፑዋቴ፤ ዓይጎሮ ጌዔቶ ዬይ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ታኣም ዱማዼ ዴሬ ማሂ ዒንሢ ዶኦሬያ ማዒፆ ዔርዛያ ማዒ ሙካ ሾይንቶ ቢያይዳ ታኣና ዒንሢናኮ ባኣካ ዶዲ ናንጋንዳ ማላታ ማዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ታኣም ዱማዼያ ማዔሢሮ ሃውሾ ኬሎ ቦንቾ ኬሊ ማሂ ቦንቹዋቴ፤ ዬያ ቦንቾ ኬሎ ካፑዋዖ ማዾ ኬሊ ማሃ ዓሲ ቢያ ዎዎዺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ዒንሢ ዒንሢኮ ማዾ ማዻንዳ ላሆ ኬሊ ዒንሢም ዓኣኔ፤ ላንካሳ ኬላ ጋዓንቴ ታኣም ዱማዼ ሃውሺሢ ኬሊኬ፤ ዬኖ ኬሎና ማዾ ማዻሢ ቢያ ዎዎዺንቶጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ዒስራዔኤሌ ዴራ ዬኖ ኬሎ ዶዲ ናንጋ ጫኣቁሞ ማላታ ማሂ ካፖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ዬይ ታኣና ዒስራዔኤሌ ዴሮናኮ ባኣካ ናንጊና ዶዲ ናንጋ ማላታ ማዖንጎ፤ ዓይጎሮ ጌዔቶ ታኣኒ ናንጊና ናንጋ ጎዳ ጫሪንጮና ሳዖና ላሆ ኬሊዳ ማዢ ኩርሴስካፓ ላንካሳ ኬሌሎ ማዾ ታኣኒ ሃሼ ኬሎታሢሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ናንጊና ናንጋ ጎዳ ሙሴና ሲና ዹኮይዳ ጌስቴስካፓ ፆኦሲ ፔኤሮ ፔ ዓይሢፆ ፃኣፔ ላምዖ ዓርሲንቴ፥ ማርኮ ማዓ ሹጮንሢ ሙሴም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ሙሴ ዹኮይዳፓ ኬዱዋዖ ዒኢካ ሚርጌ ኔጌሢ ዴራ ዛጊ ፔቱሞና ዓኣሮኔ ኮራ ቡኪንታዖ፦ «ጊብፄ ዓጮይዳፓ ኑና ዔኪ ኬሴ፥ ሙሴ ጎዖሢ ዎዎይቴቴያ ኑ ዔሩዋሴ፤ ዬያሮ ኑኡኮ ቤርታ ቤርታ ዓኣዺ ኑና ዔኪ ዓኣዻንዳ ፆኦዞ ኑኡም ኮሼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ዓኣሮኔያ፦ «ዒንሢኮ ላኣሎንታ ዓቲንቆንታ ዉዱሮ ናኣታኣ ፓልማ ዋዮ ዎርቆ ቢያ ቡኩሲ ታኣም ዔኪ ዬዑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ዬያሮ ዴራ ቢያ ዔያቶኮ ዓኣ ዎርቆ ዱንዶ ቢያ ኬሲ ዓኣሮኔም ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ዒዚ ዬያ ዎርቆ ዱንዳሢ ቢያ ዔኪ ታሚዳ ዓጌኔ፤ ዬይ ዎርቃ ዓልቃዛ፥ ዎርቆ ዔኪ ዔኤቢኮ ጋርካ ዋሄስካፓ ናኣሪ ማሂ ማዢ ኬሴኔ። ዴራ፦ «ዒስራዔኤሌ ዓሲዮቴ! ጊብፄ ዓጮይዳፓ ኑና ዔኪ ኬሴ፥ ኑ ፆኦዛሢ ሃያኬ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ዓኣሮኔ ዬያ ዛጋዖ ዎርቆና ማዢንቴ ናኣራሢኮ ቤርታ ዬያ ፆኦዞም ዒንጎ ቤሲ ኮሺ፦ «ዚሮ ናንጊና ናንጋ ጎዳ ቦንቾ ኬሊ ማዓንዳኔ» ጌዒ ዴሮም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ዚሮ ጉቴሎ ጉቴ ዓሚ ቆልሞ ዔኪ ሙኪ ሚቺ ዒንጎ ዒንጊፆንታ ዻቂንታም ማዓ ፔቱሞና ሹኪ ዒንጎ ዒንጊፆዋ ሺኢሼኔ፤ ዒማና ዴራ ዴዒ ሙዒ ዑሽኬስካፓ ኮርጋኒ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ዬያሮ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ጊብፄ ዓጮይዳፓ ኔኤኒ ዔኪ ኬሴ ኔኤኮ ዴራ ፔና ዒኢሲ፥ ታናኣ ሃሼሢሮ ዑኬና ዔያቶ ባንሢ ኬዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ዴራ ታ ዔያቶ ዓኣዻንዳጉዲ ዓይሤ ጎይፆይዳፓ ኔጉዋዖ ዻቢንቴኔ፤ ዎርቄ ሼኤሺ ማዦና ናኣሪ ማላታ ካኣሽኮ ፆኦዞ ማሂ ኮሺ ዔያታ ካኣሽኬኔ፤ ሚቺ ዒንጎ ባኣዚያ ዬያም ዒንጊ ‹ጊብፄ ዓጮይዳፓ ኑና ኬሴ፥ ኑኡኮ ፆኦዛ ሃያኬ› ዔያታ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ዴራ ዎዚጉዴ ዋይዚ ዒፃያታቶ ታ ዔያቶ ዔሬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ሃሢ ሃይሾ ታ ዔያቶ ዑፃ ሚርጌና ዻጋዺ ባይዛኒ ታ ዔያቶ ጊኢጌሢሮ ታኣኮ ዻጎ ማሃኒ ማሊፖ፤ ኔና ታኣኒ ጋዓንቴ ዳልጊ ዴሬ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ሙሴ ጋዓንቴ ፔ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ሺኢቃዖ፦ «ናንጊና ናንጋ ጎዳሢዮ! ኔኤኮ ዼኤፖ ቢታንቶና ዎልቆና ዓውሲ፥ ጊብፄ ዓጮይዳፓ ኔ ኬሴ ኔኤኮ ዴሮይዳ ሃያይዲ ኔ ዓይጋ ዻጋዻይ? ");
INSERT INTO mdyeth_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ጊብፄ ዓሳ ‹ሃያ ዓሶ ዔያቶኮ ፆኦሲ ጊብፄ ዓጮይዳፓ ዔኪ ኬሴሢ ዹኮይዳ ዔያቶ ዎዻኒና ፔቶ ባባይዛኒኬ› ጌዒ ኑና ሚኢጫንዳጉዲ ኔ ዓይጎሮ ማሌይ? ሃሢ ዻጎይዳፓ ዓቶም ጌይሢባንሢ ማዔ፤ ሃያ ቢያ ባይሲንቶ ኔኤኮ ዴሮ ዑፃ ሄሊሲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ኔኤኮ ዓይሎ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤማኣ ማሌ፤ ዜርፆ ዔያቶኮ ጫሪንጫ ዉጫሢጉዲ ኔ ሚርጊሻኒና ኔ ዔያቶም ዒንጋኒ ጉሙርሴ ዓጬሎዋ ናንጊና ዔያቶ ዓጪ ማሂ ኔ ዔያቶም ዒንጋኒ ጫኣቄ ጫኣቁሞ ማሊ ጶቂሤ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ዬያሮ ናንጊና ናንጋ ጎዳ ዻጎይዳፓ ዓቶም ጌይሢባንሢ ማዒ፥ ዔያቶ ዑፃ ዓጋኒ ማሌ ፑርቶ ዱማ ዱማ ዶርዓሢ ኬይሱዋዖ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ዬካፓ ሙሴ ላምዖ ዛሎና ታጶ ዓይሢፃ ፃኣፒንቴ ላምዖ ዓርሲንቴ ሹጮንሢ ዔኪ ዹካፓ ኬዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ዬንሢ ዓርሲፆ ሹጮንሢ ኮሼሢና ጊዳ ዓኣ ዓይሢፆ ቆኦቂ ፃኣፔሢ ፆኦሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ዴራ ዣላሢ ዒያሱ ዋይዛዖ ሙሴ ኮራ፦ «ጉርዶይዳ ዖልዚ ጌሌጉዲ ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ሙሴ ጋዓንቴ፦ «ሃይ ዋይዚንታሢ ኮሢ ዑኡሲ ማዓንዳኣፓዓቴም ዖልዚና ባሼ ዓሲኮ ሄርሺንቲ ዑኡሲ፤ ሃሣ ባሺንቴ ዴሬኮ ዒላቲ ዑኡሲያቱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ሙሴ ጉርዶ ሙኪ ሄላዖ ፆኦዞ ማሂ ኮሾና ናኣሮማንታ ዴሮኮዋ ኮፆ ዛጋዖ ዒናፓ ዻጋዺ ዒ ዔኪ ሙኬ ዓርሲንቴ ሹጮንሢ ዹኮ ዴማ ዢቢ ሜንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ሃሣ ዔያታ ፆኦዞ ማሂ ኮሼ ናኣሮማ ዔኪ ታሚዳ ዓጊ ዓልቂሲ ሊኢቃዻንዳያ ሄላንዳኣና ጊኢጪ ዋኣሢና ሞሮራዖ ዒስራዔኤሌ ዴሮ ዑሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ዒማና ዒዚ ዓኣሮኔ ኮራ፦ «ፔቶ ሃይ ዴራ ኔና ዎዎዴምዳይ፤ ሃያጉዴ ፑርታ ጎሜይዳ ዔኪ ኔ ዔያቶ ጌልዜሢ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ዓኣሮኔ ማሃዖ፦ «ታ ጎዳሢዮ! ታ ዑፃ ዻጋዺፖ፤ ዴራ ፑርታ ባኣዚ ማዻኒ ዎያጉዴ ባቃና ዴንሤ ዓሲታቴያ ኔኤኒ ዔዔራኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ዔያታ ‹ጊብፄ ዓጮይዳፓ ኑና ዔኪ ኬሴ፥ ሙሴ ዎዎይቴቴያ ኑ ዔሩዋሴ፤ ዬያሮ ኑኡኮ ቤርታ ቤርታ ኑና ዔኪ ዓኣዻንዳ ፆኦዞ ኑኡም ኮሼ› ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ታኣኒያ ዔያቶኮ ዎርቆ ፓልማሢ ኬሲ ዔኪ ሙካንዳጉዲ ዓይሤም፥ ዔያታ ፔኤኮ ፓልማሢ ቢያ ዔኪ ሙኬኔ፤ ዬያ ፓልማሢ ቡኩሲ ዔኪ ታሚዳ ታኣኒ ዓጋዛ፥ ሃይ ናኣሮ ማላሢ ማዢንቲ ኬስኬኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ዓኣሮኔ ዴሮ ዳኪ ሃሺሢና ዔያቶኮ ሞርካ ዔያቶ ሚኢጫንዳጉዲ ማሄሢያ ሙሴ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ዬያሮ ሙሴ ጉርዶ ጌሎ ካራ ዔቃዖ፦ «ናንጊና ናንጋ ጎዳ ዛላ ማዔዞንሢ ቢያ ሃኒ ታ ባንሢ ሙኩዋቴ!» ጌዒ ዑኡዞ ዼጊዲ ኬኤዛዛ፥ ሌዊ ዓሳ ቢያ ዒዛ ኮራ ቡኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ዒዚ ዔያቶም፦ «ዒንሢ ፔቴ ፔቴሢ ዒንሢኮ ጬንቾ ዓፓሮ ዔኪ ካራፓ ካሮ ሄላንዳኣና ጉርዶ ሃንቲ ዒንሢኮ ጌርሲንሢ፥ ዒንሢኮ ዒጊኖንታ ዒንሢኮ ዓሺኖዋ ዎዻንዳጉዲ ዒስራዔኤሌኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ዒንሢ ዓይሤኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ሌዊ ዓሳ ዬያ ጌይንቴሢ ዋይዚ ዬኖ ኬሎ ሃይሦ ሺያ ዓሲ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ሙሴያ ሌዊ ዓሶም፦ «ሃኖ ዒንሢ፥ ዒንሢኮ ዓቲንቆ ናኣቶንታ ዒንሢኮ ጌርሲንሢያ ዎዺፆና ናንጊና ናንጋ ጎዳም ማዻ ቄኤሴ ማዒ ዒንሢና ዒንሢ ዱማሴሢሮ ናንጊና ናንጋ ጎዳ ዒንሢም ዓንጆ ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ዚሮ ጉቴሎ ሙሴ ዴሮም፦ «ፑርታ ዼኤፒ ዻቢንቲ ዒንሢ ዻቤኔ፤ ያዺ ማዔቴያ ናንጊና ናንጋ ጎዳ ጴዻ ዹኮ ሃሣ ላሚ ታኣኒ ኬስካንዳኔ፤ ጎዖንቴ ዒንሢኮ ጎሞ ዓቶም ጌይሳኒ ታ ዳንዳዓንዳኣናንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ሙሴ ናንጊና ናንጋ ጎዳ ባንሢ ማዒ ዴንዲ፦ «ሃይ ዴራ ፑርታ ዻቢንቲ ዻቤኔ፥ ዎርቄና ኮሺንቴ ባኣዚ ፆኦዞ ማሂ ካኣሽኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ሃዳራ ዔያቶኮ ጎሞ ዓቶም ጌዔ፤ ኔ ዔያቶኮ ጎሞ ዓቶንጎ ጌይንዱዋያ ማዔቴ ኔኤኒ ፃኣፔ ማፃኣፓፓ ታ ሱንፆ ዑጪ ባይዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ናንጊና ናንጋ ጎዳ ዒዛም፦ «ሱንፆ ታኣኒ ባይዛንዳሢ ጎሜ ማዼ ዓሶና ታና ዖዪሴ ዓሶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ሃሢ ዓኣዺጋፓ ታ ኔኤም ኬኤዛ ቤዞ ዴሮ ዔኪ ዓኣዼ፤ ታኣኮ ኪኢታንቻሢ ኔኤኮ ቤርታ ቤርታ ኔና ዔኪ ዓኣዻንዳሢ ዔሬ፤ ጋዓንቴ ዎዳ ሄላዛ ሃያ ዴሮይዳ ዔያታ ማዼ ጎሞሮ ሜቶ ዓጊ ታኣኒ ዓታዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ዎርቆና ማዢንቴ ናኣሮ ፆኦዞ ዔያቶም ኮሻንዳጉዲ ዓኣሮኔ ዔያታ ሜታሴሢሮ ናንጊና ናንጋ ጎዳ ዴሮይዳ ፑርታ ዶርዖ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔኤና ጊብፄ ዓጫፓ ኔ ዔኪ ኬሴ ዴራ ቢያ ሃኖ ቤዛፓ ዔቂ፥ ዓብራሃሜም፥ ዪሳኣቄም፥ ያይቆኦቤና ዔያቶኮ ዜርፆናም ቢያ ታ ዒንጋኒ ጫኣቄ ዓጮ ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ዒንሢኮ ቤርታ ቤርታ ዒንሢ ዔኪ ዓኣዻንዳያ ታኣኮ ኪኢታንቻሢ ታ ዳካንዳኔ፤ ካኣናኔ ዓሶ፥ ዓሞራ ዓሶ፥ ሄኤቴ ዓሶ፥ ፔርዜ ዓሶ፥ ሂዋዌና ዒያቡሳ ዓሶ ታ ዒንሢኮ ቤርታፓ ኬሲ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ዒንሢ ዓኣዻ ቤዛ ዔኤሲና ዲኢቂና ኩሜ ማሊ ዓጪኬ፤ ጋዓንቴ ዒንሢ ዋይዚ ዒፃ ዓሲ ማዔሢሮ ታ ዒንሢ ጎይፃ ዎዺ ባይዙዋጉዲ ታ ዒንሢና ዓኣዻዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ዴራ ቢያ ዬያ ዖዪሳ ሃይሶ ዋይዛዖ ዒናፓ ዬኤኬኔ፤ ዒማፓ ዓርቃዖ ዓይጎዋ ፓልሞ ባኣዚ ፓልማኒ ዔያታ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ናንጊና ናንጋ ጎዳ ዴሮም ሂዚ ጌዒ ኬኤዛንዳጉዲ ሙሴ ዓይሤኔ፦ «ዒንሢ ዋይዚ ዒፃ ዓሲኬ፤ ፔቴናታዖ ታ ዒንሢና ዎላ ዓኣዼቶ ጋፒሲ ታ ዒንሢ ባይዛንዳኔ፤ ሃሢ ዒንሢኮ ፓልሞ ባኮ ዒንሢ ዑፃፓ ጉሱዋቴ፤ ታ ዒንሢ ዎዎዳንዳታቴያ ሃጊ ታኣኒ ፔጋሳንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ዬያሮ ዒስራዔኤሌ ዴራ ሲና ዹኮ ሃሺ ዴንዴስካፓ ፓልሞ ባኮ ቢያ ጉሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ዒስራዔኤሌ ዴራ ዱንኪ ዴዓ ቤዞ ቢያይዳ፥ ሙሴ ዓፒሎና ማዢንቴ ማኣሮ ጉርዶይዳፓ ሃኪሲ ዾቃኔ፤ ዬይ ማኣራ፦ «ናንጊና ናንጋ ጎዳ ዴሮና ካኣማ ማኣሮ» ጌይንቴኔ፤ ናንጊና ናንጋ ጎዳሢና ጌስታኒ ኮዔሢ ቢያ ዒኢካ ዓኣዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ሙሴ ዒኢካ ዓኣዻ ዎዶና ቢያ ዴራ ፔኤኮ ማኣሮ ካራ ኬስኪ ዔቂ ሙሴ ዬያ ዓፒሎና ማዢንቴ ማኣሮ ጌላንዳኣና ዒዛ ዛዛጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ሙሴ ዒኢካ ጌሌስካፓ ፒዝ ጌዒ ዔቃ ሻኣራ ኬዲ ዓፒሎና ማዢንቴ ማኣሮ ካራ ዔቃኔ፤ ናንጊና ናንጋ ጎዳሢያ ሻኣሮ ባኣካ ማዒ ሙሴና ጌስታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ፒዝ ጌዒ ዔቄ ሻኣራ ዓፒሎና ማዦና ጌኤዦ ማኣሮ ካራ ጴዻዛ ዴራ ዴንቃዖ ፔኤኮ ማኣሮ ካራ ጉምዓቲ ዚጊ ዚጊ ፆኦሲ ካኣሽካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ዓሲ ፔኤኮ ላጌና ዎላ ጌስታጉዲ ናንጊና ናንጋ ጎዳ ሙሴና ዎላ ዒማና ፔጌና ጌስታኔ፤ ዬካፓ ሙሴ ጉርዶ ባንሢ ማዓኔ። ዒዛ ማኣዲ ማዻ ዼጌሢ፥ ኔዊ ናኣዚ፥ ዒያሱ ጋዓንቴ ዓፒሎና ማዦና ጌኤዦ ማኣሮ ሃሺ ሜሌ ቤሲ ዴንዱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ሙሴ ናንጊና ናንጋ ጎዳም፦ «ሃያ ዴሮ ዬኖ ዓጬሎ ታ ዔኪ ዓኣዻንዳጉዲ ኔኤኒ ታና ዓይሤኔ፤ ጋዓንቴ ታኣና ዎላ ዖና ኔ ዳካንዳቴያ ኔ ታኣም ኬኤዚባኣሴ፤ ታና ኔ ዔራያ፥ ሃሣ ቦንቻያ ማዔሢ ኔ ታኣም ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ዬይ ያዺ ማዔቶ ኔኤም ታ ማዻንዳሢና ኔና ታ ዎዛሲ ናንጋንዳጉዲ ኔኤኮ ማሊፆ ታኣም ፔጋሲ ኬኤዜ፤ ሃያ ዴሮ ኔ ፃጲ ማሂ ኔ ዶኦሬሢ ማሌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ናንጊና ናንጋ ጎዳ፦ «ታኣኒ ታ ቶኦኪና ኔኤና ዎላ ዓኣዻንዳኔ፤ ኮሹሞ ታ ኔኤም ዒንጊ ኔና ሃውሺሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ሙሴ ማሃዖ፦ «ኔ ኑኡና ዎላ ኬስኩዋያ ማዔቶ ኑና ሃያ ቤዛፓ ኬሲፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ኑኡና ዎላ ኔ ኬስኩዋያ ማዔቶ ኔኤኮ ዴሮናኣ ማዖም ታ ዛሎና ኔ ዎዛዻያ ማዔሢ ዓሲ ቢያ ዎይቲ ዔራኒ ዳንዳዓንዳይ? ሳዖይዳ ዓኣ ሜሌ ዴሮይዳፓ ቢያ ኑና ዱማ ማሃሢ ኔኤኮ ኑኡና ዎላ ማዒፆቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔና ታ ኮሺ ጎናሲ ዔራያ ማዔሢሮና ኔ ዛሎና ታ ዎዛዻሢሮ ኔ ጋዓ ባኮ ቢያ ታ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ሙሴ ዒማና፦ «ሂዴቶ ኔኤኮ ቦንቾ ታና ፔጋሲ ዻዌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ናንጊና ናንጋ ጎዳ ዒዛም፦ «ታኣኮ ኮሹሞ ቢያ ታ ኔኤም ቤኤዛንዳኔ፤ ታኣኮ ጌኤዦ ሱንፆዋ ታ ኔኤም ኬኤዛንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ፤ ዻቤሢም ታ ዓቶም ጋዓንዳዞንሢም ዓቶም ጋዓንዳኔ፤ ሚጪንታንዳዞንሢማኣ ታ ሚጪንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ዓሲ ታና ዛጊ ሃይቁዋዖ ዓቲ ናንጉዋኣሢሮ ታኣኮ ዓኣፖ ካሮ ኔኤኒ ዛጋኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ጋዓንቴ ሃይካ ታኣኮ ዑኬ ላሎ ዑፃ ኔ ዔቃንዳ ቤሲ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ታኣኮ ቦንቾ ጴዺፆኮ ማላታ ማዔ ዓኣፓ ዱካ ፖዓ ፖዒ ዓኣዻኣና ላሎኮ ፃሄ ዛኣዚንፆ ባኣኮ ታ ኔና ጌልዛንዳኔ፤ ታኣኒ ዖኦኪ ዓኣዻንዳያ ሄላንዳኣና ታ ኩጮና ታ ኔና ካንቂ ዓኣቻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ዬካፓ ኩጮ ታ ሺኢሻንዳኔ፤ ኔኤኒ ዒማና ታኣኮ ዓኣፖ ካሮቱዋንቴ ዙሎ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ቤርታኣሮንሢ ማላያ ላምዖ ሹቺ ዓርሲ ኮሼ፤ ታኣኒያ ኔኤኒ ቤርታ ሜንሤዞንሢዳ ዓኣ ባኮ ፃኣፓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ዚሮ ጉቴ ታኣና ዎላ ካኣማኒ ጊኢጊንቲ ሲና ዹኮ ቶኦኮ ኬስኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ኔኤና ዎላ ዓይጎ ዓሲያ ሙኮፖ፤ ዹኮኮ ዎኖ ዛሎና ማዔቶዋ ዓይጎ ዓሲያ ጴዾፖ፤ ማራይ ማዔቶ ባይ ዓይጎ ቆልሞዋ ዹኮ ዴማ ሄንቆፓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ዬያሮ ሙሴ ላምዖ ሹቺ ቤርታኣሮንሢጉዴያ ዓርሳዖ፥ ዚሮ ጉቴሎ ጉቴ ዓሚና ዔቂ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ዓርሲንቴ ሹጮ ዔኪ ሲና ዹኮ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ዒማና ናንጊና ናንጋ ጎዳ ሻኣሬና ኬዲ ዒዛና ዎላ ዒኢካ ዔቂ፦ «ታኣኒ ናንጊና ናንጋ ጎዳኬ» ጌዒ ፔኤኮ ዱማዼ ሱንፆዋ ዔርዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ናንጊና ናንጋ ጎዳ ዒዛኮ ቤርቶና ዓኣዻዖ ሂዚ ጌዒ ኬኤዜኔ፦ «ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲኬ፤ ታኣኒ ማኣራያ ሃሣ ዓቶም ጋዓያኬ፤ ታኣኒ ዻጋም ኔጋያ፥ ናንጊና ናንጋ ናሹሞና ጉሙርቂንቲፃኣ ታኣኮ ሚርጌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ታኣኮ ናንጊና ናንጋ ናሹሞ ባይዙዋዖ ዴንዲ ሺያ ሾይንቲ ሄላንዳኣና ታ ካፓያኬ፤ ጎሜና ዻቢንቲና ቢያ ታ ዓቶም ጋዓያኬ፤ ጋዓንቴ ጊንሣ ሃሣ ዴንዲ ሃይሣሶና ዖይዳሶ ሾይንቶ ሄላንዳኣና ዓዶንሢ ዛሎ ጎሞሮ ናኣቶይዳ ታ ሜቶ ዓጉዋ ሃሻያቱዋሴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ሙሴ ቤዞማና ሳዖ ባንሢ ጉምዓቲ ዚጊ ካኣሽካዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ሂዚ ጌዔኔ፦ «ናንጊና ናንጋ ጎዳሢዮ! ጎኔና ኔ ታኣና ዎዛዻያ ማዔቶ ኔ ኑኡና ዎላ ኬስካንዳጉዲ ታ ኔና ሺኢቃኔ፤ ሃይ ዴራ ዋይዚ ዒፃያኬ፤ ጋዓንቴ ኑኡኮ ጎሞና ፑርቶ ማዾና ቢያ ዓቶም ጌዔ፤ ሃሣ ኔ ዴሬ ማሂያ ዔኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሃይሾ ዓካሪ ታኣኒ ዒስራዔኤሌ ዴሮና ጫኣቁሞ ጫኣቃንዳኔ፤ ሃያኮ ቤርታ ሳዖይዳ ዓይጎ ዴሬ ኮራ ማዺንቲ ዔርቲባኣ ፑኡፒ ባኣዚ ታ ዔያቶኮ ቤርታ ማዻንዳኔ፤ ታ ኔጋቴ ጌዒ ዒጊቻያ ማዔ ዼኤፒ ባኣዚ ማዻንዳሢሮ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዬንሢ ማዻንዳ ዼኤፖ ባኮንሢ ዔያቶ ባኣካ ናንጋ ዴራ ቢያ ዛጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ሃኖ ታ ዒንሢም ዒንጋ ዎጎ ካፑዋቴ፤ ታኣኒያ ዓሞራ ዓሶ፥ ካኣናኔ ዓሶ፥ ሂኢታ ዓሶ፥ ፔርዜ ዓሶ፥ ሂዋዌና ዒያቡሳ ዓሶ ዒንሢኮ ቤርታፓ ኬሲ ዳካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ዔያታ ዒንሢ ባይዛንዳ ፒሮ ዒንሢም ማዓንዳሢሮ ዒንሢ ዴንዳ ቤዛ ዓኣ ዴሮና ዎላ ጫኣቁሞ ጫኣቂፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ዔያቶኮ ፆኦዞም ዒንጎ ባኮ ዒንጎ ቤዞ ዶይሲ ባይዙዋቴ፤ ካኣዦ ባዖዋ ሻሁዋቴ፤ ዓሼራ ጌይንታ ዔያቶኮ ካኣሽኮ ፆኦዜሎ ማላቶዋ ሜንሢ ኬኤሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","«ታኣኒ፥ ናንጊና ናንጋ ጎዳ ታጊዳፓ ሜሌ ፆኦሲ ካኣሽኪንታንዳጉዲ ኮዑዋ ፆኦሲታሢሮ ታ ጊዳፓ ዓታዛ ሜሌ ፆኦዞ ካኣሽኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ዒዞ ዓጮይዳ ናንጋ ዓሶና ዎላ ጫኣቁሞ ጫኣቂፖቴ፤ ዓይጎሮ ጌዔቶ ፓሡዋ ዔያቶኮ ፆኦዞም ዚጊ ዔያታ ካኣሽካኣና፥ ዒንጎ ባኣዚ ዔያታ ዒንጋኣና ዒንሢ ዔያቶና ዎላ ፔቴ ማዓንዳጉዲ ዒንሢ ዔያታ ዖኦጫንዳኔ፤ ዒንሢያ ዔያታ ፔኤኮ ፆኦዞም ዒንጋ ሙዖ ሙዓኒ ጋዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ዒንሢኮ ዓቲንቆ ናኣቶም ዔያቶኮ ዉዱሮ ናኣቶ ዒንሢ ዖኦጬም ናኣታ ዔያቶ ዔካዛ፥ ዬንሢ ዉዱሮ ናኣቶንሢ ፔኤኮ ካኣሽኮ ፆኦዞ ካኣሽኪፆና ዒንሢኮ ዓቲንቆ ናኣቶ ዻቢሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«ዓንጊ ዓልቂሲ ካኣሽኮ ፆኦሲ ሜሌ ኮሺፖቴ፥ ካኣሽኪያ ካኣሽኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«ላኣዶ ሙዒ ቦንቾ ኬሎ ካፒ ሌዓ ሌዓ ቦንቹዋቴ፤ ዎይቤ ዓጊኖኮ ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ላኣዳ ሙዑዋቴ፤ ዓይጎሮ ጌዔቶ ጊብፄይዳፓ ዒንሢ ኬስኬሢ ዬኖ ዓጊኖይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«ቶይዶ ማዒ ሾይንታ ዓቲንቆ ናኣታ ቢያ ታኣሮኬ፤ ቤርታ ሾይንቴ ዓይጎ ቆልሞኮዋ ቢያ ጌማይ ማዔቶዋ ዓዴ ማራይ ታኣሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ጋዓንቴ ሃሮኮ ቤርቶ ናኣቶ ዛሎ ማራናይ ዒንጋኒ ዒንሢ ዳንዳዓኔ፤ ዬያ ዛሎ ዒንሢ ዒንጋኒ ዳንዳዒባኣቴ ጋዓንቴ ሃሮ ናዖኮ ባቃኖ ሜንሡዋቴ፤ ዓሲኮዋ ቶይዲ ናይ ዓቲንቄ ዛላ ማራናይ ዒንጋኒ ዒንሢ ዳንዳዓኔ። «ዒንጎ ባኣዚ ዓርቁዋዖ ዖናታቴያ ታ ቤርቶ ኩቺ ጉሪ ሙኮፓ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ማዾ ዒንሢኮ ቢያ ዒንሢ ማዻኒ ላሆ ኬሊ ዒንሢም ዓኣኔ፤ ዬያሮ ጎሽካኣናታቶዋ ሃኣኮ ቡኩሶ ዎዶኮ ላንካሳ ኬሎና ፔቴታዖ ማዾ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«ቤርታ ካፄ ሃኣኮ ዒንሢ ቡኩሳ ዎዶና ሃኣኮ ካፂፆ ቦንቾ ኬሊ ቦንቹዋቴ፤ ሌዖኮ ጋፒንፃ ዒንሢ ቱኬ ሚፆ ዓኣፖ ቡኩሳ ዎዶናኣ ዉልሾ ዴማ ዒንሢ ናንጌ ዎዶ ማሊ ቦንቺንታ ቦንቾ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«ሌዔይዳ ሃይሢ ማይንቲ ዓቲንቃ ቢያ ዒስራዔኤሌ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ዚጊ ካኣሽካኒ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ሜሌ ዴሮ ቢያ ዳውሲ ባይዚ ዒንሢኮ ዓጮ ታኣኒ ዳልጊሻንዳኔ፤ ዬያሮ ዬንሢ ሃይሦ ቦንቾ ዎዶንሢዳ ታ ኮይላ ዒንሢ ሙካኣና ዒንሢኮ ዓጮ ዖሊ ዔካኒ ዖኦኒያ ዒንሢ ኮራ ሙካዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«ታኣም ዒንሢ ቆልሞ ሹኪ ዒንጋ ዎዶና ሙኑቃ ፃኣዛ ጌሌ ካሣና ዎላ ታኣም ዒንጊፖቴ፤ ዑሣ ዓኣዺፆ ቦንቾ ኬሎም ሹኪንቴ ቆልሞ ዓሽካፓ ዚሮ ጉቴ ሄላንዳኣና ዓይሲ ጌሢፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«ሌዓ ሌዓ ዒንሢኮ ሃኣኮኮ ቤርቶ ናንጊና ናንጋ ጎዳ ማዔ ፆኦዛሢ ማኣሪ ዔኪ ሙኩዋቴ። «ማራናይ ማዔቶ ዋናናይ ዒንዶ ዲኢቆና ዎላ ካሢፖቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔኤና ማዔቶዋ ዒስራዔኤሌ ዴሮና ታ ጫኣቃንዳ ጫኣቁማ ሃኖ ቃኣሎ ጎይፆና ማዔሢሮ ሃያ ቃኣሎ ማፃኣፔይዳ ፃኣፔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ሙሴ ዓይጎዋ ሙዒ ዑሽኩዋዖ ናንጊና ናንጋ ጎዳና ዎላ ዖይዲታሚ ኬሊና ዖይዲታሚ ዋንቴና ዴዔኔ፤ ናንጊና ናንጋ ጎዳ ዒማና ዓርሲንቴ ሹጮንሢዳ ጫኣቁሞ ዔርዛያ ማዔ ታጶ ዓይሢፆንሢ ፃኣፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ሙሴ ናንጊና ናንጋ ጎዳና ዎላ ጌስቲ ዴዔሢሮ ታጶ ዓይሢፆንሢ ዔኪ ሲና ዹኮይዳፓ ኬዳኣና ዓኣፖ ካራ ዒዛኮ ፖፖዓኔ፤ ዒዛም ጋዓንቴ ዬይ ቢያ ዔርቱዋያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ዓኣሮኔንታ ዴሮ ቢያሢንታ ሙሴ ዛጋኣና ዓኣፖ ካራ ዒዛኮ ፖዓሢ ዴንቃዖ ዒዛ ባንሢ ዑካኒ ዒጊጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ሙሴ ጋዓንቴ ዔያቶ ዔኤላዛ፥ ዓኣሮኔና ዴሮኮ ሱኡጎና ዒዛ ባንሢ ሙኬም ዒዚ ዔያቶና ጌስቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ዬካፓ ዒስራዔኤሌ ዴራ ጉቤ ዒዛ ኮራ ቡኪንታዛ፥ ሙሴያ ሲና ዹኮይዳ ናንጊና ናንጋ ጎዳ ዒዛም ዒንጌ ዎጎ ቢያ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ሙሴ ዔያቶና ዎላ ጌስቲ ጋፔስካፓ ዓኣፖ ካሮ ፔኤኮ ሻኣሾና ካንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ሙሴ ናንጊና ናንጋ ጎዳና ዎላ ጌስታኒ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጌላ ዎዶና ሻኣሻሢ ዓኣፖ ካራፓ ዔካኔ፤ ዬካፓ ጊንሣ ኬስካኣና ዒዛም ዓይሢ ኬኤዞና ባኮ ቢያ ዒስራዔኤሌ ዴሮም ዒ ኬኤዛኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ዔያታ ዓኣፖ ካራ ዒዛኮ ፖዓንቴ ዛጋኔ፤ ዬያሮ ናንጊና ናንጋ ጎዳና ዎላ ጌስታኒ ዒ ዓኣዻንዳ ዎዶ ሄላንዳኣና ዓኣፖ ካሮ ፔኤኮ ሻኣሻሢና ዒ ካንቃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ሙሴ ዒስራዔኤሌ ዴሮ ፔቴይዳ ዔኤላዖ፦ «ዒንሢ ኩንሣንዳጉዲ ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጌ ዎጋ ያዺኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ዒንሢ ዒንሢኮ ማዾ ማዻንዳጉዲ ላሆ ኬሊ ዒንሢም ዓኣኔ፤ ላንካሳ ኬላ ጋዓንቴ ዒንሢ ሃውሻንዳጉዲ ታና፥ ናንጊና ናንጋ ጎዳም ዱማዼ ኬሊታሢሮ ዬኖ ኬሎ ማዾ ማዻ ዓይጎ ዓሲያ ማዖም ዎዺንታንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ዬያሮ ሃውሾ ኬሎና ዒንሢኮ ማኣሮይዳ ታሚታዖ ዔኤሢፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ሙሴ ዒስራዔኤሌ ዴሮም ቢያ፦ «ናንጊና ናንጋ ጎዳ ዓይሤ ባካ ያዺ ጋዓያኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ዒንጉዋቴ፤ ዒንጎ ባኣዚ ዒንጋኒ ኮዔሢ ቢያ ዒና ናሽኬሢጉዲ ዎርቄ፥ ቢራ ዓንጊ፥ ሞኦኖ ዓንጋ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ሚዛጲ ሱኡፖ ዓፒላ፥ ጮልዔ፤ ሃሣ ዲንኪንታ ዞቄ ቃላሜና ዑሺንቴ ማራይ ጋፓኔ፥ ዋኣሪ ጋፓኔና ኮሺንቴ ዓፒላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ዞቄ ቃላሜ ዑሺንቴ ዓዴ ማራይ ጎሮ፥ ሺርኪንቴ ጉላምቤ፥ ሻሪ ሚሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ፖዖ ፖዒሶ ላምባሢ፥ ቲሽኮ ዛይቶ ቲዦና ዑንጆ ሳውቂሳ ዱማ ዱማ ባኮ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ቄኤሶኮ ሱኡጋ ማኣዓ ዱማዼ ዔፑዶ ማኣዓሢንታ ዳዶ ቡራሾይዳ ጌሢንታ ማሬጌዶንታ ሜሌ ፓልሞ ባኮ ዔኪ ሙኮንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«ዒንሢ ባኣኮይዳ ዓኣ ኩቺ ሃኣሚ ዓሲ ቢያ ናንጊና ናንጋ ጎዳ ዓይሤ፥ ዓይጎ ባኣዚያ ማዻኒ ሙኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ዬይ ማዢንታንዳ ባካ፦ ዓፒሎና ማዢንቴ ማኣሮኮ ጋሮና ዙሎናይዳ ቃሲ ሱፆ ዓፒሎ፥ ዓርቆ ባኮንታ ላሾ ሚፆንታ፥ ጋጋርዞንታ ቱርቱሮንታ፥ ቶኮንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ጫኣቁሞ ታኣቦቶንታ፥ ዛጶ ሚፆንታ፥ ጎሞ ዓቶም ጌይፆ ዔርዛ ታኣቦቶ ካሮ ካንቆ ጉኡፖንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ዼጌ ሎኦዦንታ ዛጶ ሚፆንታ ዱማ ዱማ ሜሆ፤ ዬያጉዲ ሃሣ ፆኦሲም ዒንጊንታ ዱማዼ ካሦ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ፖዖ ጌሦ ሻርኖና ዬያም ኮይሳ ዱማ ዱማ ሜሆ፥ ፖዖ ፖዒሶ ላምባሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ዑንጆ ጩቢሶ ቤዞና ዛጳሢ ሚፆ፥ ቲዦ ዛይቶ፥ ሳውቃ ዑንጆ፥ ዓፒላፓ ማዦና ማኣሮኮ ካሮ ዎዾ ዓፒሎ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ሚቺ ዒንጊንታ ባኮ ሚቾ ቤዞ፥ ታሞ ካኣሾ ሞኦኖ ዓንጎ፥ ዛጳሢ ሚፆንታ ዬያኮ ሜሆ፥ ማስቶ ሳኣኖንታ ጌሦ ባኮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ቆልዖ ጋሮ ጎኦቦ ዓፒሎ፥ ቱርቱሮና ቶኮና፥ ቆልዖ ጋሮኮ ካሮ ጎኦቦ ዓፒሎ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ፃውኖ፥ ዓፒሎና ማዢንቴ ማኣሮኮ ቱኮ ሱዞ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ቄኤሳ ዱማዼ ቤዞይዳ ማዻ ዎዶና ማኣዓ ሚዛጲሶና ማኣዓሢ፤ ዬይያኣ፦ ቄኤሳሢ ዓኣሮኔና ዒዛኮ ናኣቶናም ኮሺንታ ፆኦሲም ዱማዼ ዓፒሎዋ ቢያ ኮሾንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ዬካፓ ዒስራዔኤሌ ዴራ ቢያ ሙሴ ቤርታፓ ኬስኪ ዴንዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ዓፒሎና ማዢንቴ፥ ናንጊና ናንጋ ጎዳ ዴሮና ካኣማ ማኣሮ ማዣኒ ፔቴ ፔቴሢ ዒንጋኒ ዒና ናሽኬሢጉዴያ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ዔኪ ሙኬኔ፤ ዬያይዲ ፆኦሲ ካኣሽኪፆ ማዾም ማዓ፥ ቄኤሶ ማኣዓሢም ኮይሳ ባኣዚ ቢያ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ዒንጎ ባኣዚ ዒንጋኒ ኮዔ ላኣላ፥ ዓቲንቃ፥ ፔቴ ፔቴሢ፦ ዳዶ ፓልማሢ፥ ዋዮ ዎርቃ፥ ኩጮ ዢኢራሢ፥ ሆላ ማኣዖ ቂንቶንታ ዎርቆ ፓልማሢንታ ዔኪ ሙኪ ናንጊና ናንጋ ጎዳሮ ማዓንዳጉዲ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ሚዛጶ ሱኡፖ ዓፒላ፥ ጮልዔ፤ ሃሣ ዲንኪና ዞቄ ዓፒላ፥ ዋኣሪ ጋፓኔና ኮሺንቴ ዓፒላ፥ ዞቄ ቃላሜና ዑሺንቴ ዓዴ ማራይ ጎሮ፤ ዬያጉዲ ሺርኪንቴ ጉላምቤ ዓኣሢያ ቢያ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ቢራታቴያ ሞኦና ዓንጊ ዒንጋኒ ዳንዳዓሢ ቢያ ዒንጎ ባኮ ናንጊና ናንጋ ጎዳም ዔኪ ሙኬኔ፤ ዓይጎ ባኣዚማኣ ማዓ ሻሪ ሚሢ ዓኣሢያ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ሱኪ ዔራ ላኣላ ፔ ኩጮና ዔያታ ማዼ ባኮ ቃራ ሱኡፖ ማኣዖንታ ጮልዔ፤ ሃሣ ዲንኪ ዞቄ ዓፒላኣ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ዬያጉዲ ሃሣ ዒንጋኒ ኮዔ ላኣላ ዋኣሪ ጋፓኔና ሱኪንቴ ፓቲሌ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ዔያቶኮ ሱኡጋ ጌኤዦ ዔፑዶ ዓፒሎና ዳዶ ቡራሻ ጌሢንታ ሜሬጊዶና ሜሌ ዱማ ዱማ ፓልሞ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ፖዖና ቲዦናም፤ ዬያጉዲ ዑንጆ ሳውቂሳያ ማዔ ዱማ ዱማ ሳውቂሳ ባኮንታ ዛይቴያ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ዓቲንቆንታ ላኣሎንታ ማዔ ዒስራዔኤሌ ዴራ ቢያ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ማዾም ኮይሳ ባኮ ዔያቶኮ ዒና ናሽኬ ጎይፆ ናንጊና ናንጋ ጎዳም ዔኪ ሙኪ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ሙሴ ዒስራዔኤሌ ዓሶም ሂዚ ጌዔኔ፦ «ናንጊና ናንጋ ጎዳ ዪሁዳ ዜርፆይዳፓ ሁኡሬኮ ናኣዚ ናዖ፥ ዑኡሬ ናኣዚ ባስሊዔኤሌ ዶኦሬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ፆኦሲ ዒዛ ፔኤኮ ዓያኖ ዎልቆና ኩሜያ ማሂ ዓይጎ ባኣዚያ ማዖም ሃኣሚ ማዒ ማዺንታ ማዾ ማዻኒ ዳንዳዓንዳጉዲ ሃኣማቶንታ ዔራቶንታ ጶቂሥሢያ ዒዛም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ዔራቶና ማዾንዶ ማዾኮ ጎይፆ ጊኢጊሺሢንታ ዬያ ማሊንቴ ባኮ ዎርቄና ቢራ ዓንጊና ሞኦኖ ዓንጎናኣ ጳርቂ ኮሻኒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ሹቺንታ ሚሢንታ ዓርሲ ኮሻኒ፤ ዬያጉዴያ ሜሌ ዔራቶና ማዾ ባኮ ማዻኒ ዔራቶ ዒዛም ዒንጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ዒዛንታ ዳኣኔ ዜርፆይዳፓ ማዔ ዓይሳማኬ ናኣዚ ዔኤሊያቤንታም ዔያቶኮ ኩጮ ሃኣማቶ ሜሌ ዓሶ ዔያታ ዔርዛንዳጉዲ ዔራቶ ዒንጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ዓንጊ ዓልቂሲሢ፥ ማዾንዶ ማዾኮ ጎይሢ ጊኢጊሺሢ፥ ቃራ ሱኡፔ ዓፒላ፥ ጮልዔ ዓፒላ፥ ዲንኪንታ ዞቄ ቃላሜና ዑሺንቴ ሚዛጲ ዓፒላ፤ ዬያጉዲ ዓፒሎ ዹዓ ሜሌ ዶርዛ ኮሼ ባኮ ቢያ ሚዛጲሳኒ ዳንዳዓ ሃኣማቶ ዔያቶም ዒንጊንቴኔ፤ ዔያታ ዓይጎዋ ማዖም ዔራቶና ማዺንታ ማዾና ሃኣማቶና ማዺንታ ባኮኮ ቢያ ጎይሢ ጊኢጊሻያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ሙሴ፦ «ናንጊና ናንጋ ጎዳ ዔራቶና ጶቂሥሢና ዒንጌዞንሢ፥ ዓፒሎና ማዢንቴ ማኣሮ ማዣኒ ኮይሳ ባኮ ቢያ ጊኢጊሻኒ ዔራቶ ዓኣዞንሢ፥ ባስሊዔኤሌና ዔኤሊያቤና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ጎይፆ ቢያ ባኮ ዔያታ ማዾንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ሙሴ ባስሊዔኤሌና ዔኤሊያቤና፤ ዬያጉዲ ናንጊና ናንጋ ጎዳ ዱማ ዔራቶ ዒንጌ ዓሶና ዔያቶ ማኣዳኒ ናሽኬ ሜሌ ዔሮ ዓሶ ቢያ ዔኤሊ ማዾ ዔያታ ዓርቃንዳጉዲ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ዒስራዔኤሌ ዓሳ ዓፒሎና ማዢንታ ጌኤዦ ማኣሮ ማዦም ጌዒ ዔኪ ሙኬ ባኮ ሙሴ ኮራፓ ዔያታ ዔኬኔ፤ ዒስራዔኤሌ ዴራ ጋዓንቴ ጉቶ ጉቶ ዔያቶኮ ዒንጎ ባኮ ሙሴም ዔኪ ሙኮ ሃሺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ዬካፓ ማዾ ጊኢጊሺ ማዻ ዔሮ ዓሳ ቢያ ፔኤኮ ማዾ ሃሺ፥ ሙሴ ኮይላ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ዔያታ ሙሴም፦ «ናንጊና ናንጋ ጎዳ ዓይሤ ማዾም ኮይሳሢኮ ዑሣ ሚርጌ ዒንጎ ባኣዚ ዴራ ዔኪ ሙኪሢዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ዬያሮ ሙሴ ዓፒሎና ማዢንታ ጌኤዦ ማኣሮም ኮይሳ ባኮ ዔኪ ሙኩዋጉዲ ጉርዶም ቢያ ኬኤዜኔ፤ ዬካፓ ዴራ ዔኪ ሙኪፆ ሃሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ዬይ ዒንጊንቴ ባካ ማዾ ቢያ ኩንሢ ጊዲ ዓዓቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ማዾ ጊኢጊሺ ማዻ ዓሶ ባኣካፓ ሚርጌ ዔራቶ ዓኣዞንሢ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንታ ማኣሮ ማዤኔ፤ ዔያታ ዓፒሎና ማዢንቴ ማኣሮም ጮልዔ፤ ሃሣ ዲንኪና ዞቄ ሱኡፖ ሱኮናያና ኪሩቤኤሌ ጊዳ ሲኪንቲ ኮሺንቴ ታጶ ጎኦቦ ዓፒላኣ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ፔቴ ፔቴ ጎኦቦ ዓፒሎኮ ጎጳ ዎሊጉዴያ ማዓዖ ዖዶሱማ ላማታሚ ሳሊ ዋዻ፥ ጎጶ ዳልጉማ ዖይዶ ዋዻኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ዬንሢ ዶንጎንሢ ፔቴይዳ ዎላ ካንሢ፤ ሃንጎ ዶንጎንሢያኣ ዒማይዲ ዎላ ካንሢ ዔያታ ሲኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ዎላ ካኣሚ ሲኪንቴ ጎኦቦ ዓፒሎይዳፓ ፔቴ ዛሎ ዓጮይዳ ጮልዔ ሱኡፔ ዓፒላና ኮሺንቴ ሱሢ ኮሼኔ፤ ሜሌ ዛሎይዳ ካንሢ ሲኪንቴ ጎኦቦ ዓፒሎንሢዳፓ ፔቴ ዛሎና ዬኖጉዲ ማዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ፔቴ ቤርታሳ ጎኦቦ ዓፒሎ ዑፃ ዶንጊታሚ ሱሢ፥ ዬያጉዲ ሃሣ ላምዓሳ ጎኦቦ ዓፒሎኮ ጋፒንፆሮይዳ ሃንጎ ሱፆኮ ቤርታ ቤርታ ማዓንዳ ዶንጊታሚ ሱሢ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ላምዖ ዛሎና ዓኣ ጎኦቦ ዓፒሎ ካንሢ ፔቴ ማሃኒ ዶንጊታሚ ዎርቄና ኮሺንቴ ዓይሦ ባኣዚ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ዓፒሎና ማዢንቴ ማኣሮ ዎዾ ካራ ማዓንዳ ታጶ ፔቴ ጎኦቦ ዓፒላ ዋኣሪ ጋፓኔ ሱኪ ኮሾና ዓፒላ ዔያታ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ቢያሢኮ ጎጳ ሄኮ ማዒ ፔቴ ፔቴ ጎኦቦ ዓፒሎኮ ዖዶሱማ ሃይሢታሚ ዋዻ፥ ጎጶ ዳልጉማ ዖይዶ ዋዻኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ዶንጋሢ ፔቴ ዛሎና፥ ላሃሢ ባጎ ዛሎና ማሂ ዎላ ካንሢ ዔያታ ሲኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ፔቴ ዛሎ ጋፒንፆ ጎኦቦ ዓፒሌሎኮ ዓጫ ዶንጊታሚ ሱሢ፥ ላምዓሳ ዛሎኮ ጋፒንፆ ጎኦቦ ዓፒሌሎኮ ዓጮ ዛሎይዳ ዶንጊታሚ ሱሢ ዔያታ ዓኣሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ላምዖ ዛላ ዓኣ ጎኦቦ ዓፒሎ ካንሢ ፔቴ ዎዾ ካራ ማሃኒ ሞኦና ዓንጊና ዶንጊታሚ ዓይሦ ባኣዚ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ዙሎ ዛሎና ዎዾ ካራ ማዓንዳጉዲ፥ ፔቴዞ ዞቄ ቃላሜ ዑሾና ዓዴ ማራይ ጎሮና ባጎዞ ሺርኪንቴ ጉላምቤ ዜዺና ላምዖ ጎኦቦ ዓፒላ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ዓፒሎና ማዦና ማኣሮ ሬኤካንዳያ ፒዜ ላሾ ሚሢ ሻሪ ሚሢዳፓ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ፔቴ ፔቴ ላሻሢ ሚፆኮ ዖዶሱማ ታጶ ዋዻ፥ ዳልጉማ ፔቴ ዋዻና ፓልፃና ማዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ዎላ ካንሣኒ ሄኮ ማዔያ ላምዖ ዻንኬስኬንሢ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ዓፒሎና ማዢንቴ ማኣሮኮ ዾኦሎ ዛሎና ላማታሚ ላሾ ሚሢ ዔያታ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ላማታሞ ዓርሲፆ ሚፆኮ ዴማ ላምዖ ላምዖ ቶኪ ጌሢ ዖይዲታሚ ቢራ ዓንጊ ቶኪ ዓኣያ ማሂ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ዓፒሎና ማዦና ማኣሮኮ ኬዶ ዛሎና ላማታሚ ላሾ ሚሢ ዔያታ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ፔቴ ፔቴ ዓርሲፆ ሚፆ ላሻሢኮ ዴማ ላምዖ ላምዖ ቶኪ ጌሢ ዖይዲታሚ ቢራ ዓንጊ ቶኪ ዓኣያ ማሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ዓፒሎና ማዢንቴ ማኣሮኮ ዙሎይዳ፥ ዓባ ጌላ ዛሎና ላሾ ሚሢ ዔያታ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ጊንፆ ዛሎና ኬኤፃ ዎላ ካኣማ ካሮይዳኣ ላምዖ ላምዖ ላሾ ሚሢ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ዬንሢ ካኣማ ካራ ዓኣ ላሾ ሚፆንሢ ዴሞ ዛሎና ዎላ ካኣሚ ዴንዲ ፔቴ ዛሎ ሙስኩሎ ሄላንዳኣና ዓርቂንቴያኬ፤ ላምዖ ካኣማ ካሮይዳ ኮሺንቴ ላሾ ሚፆንሢያ ዒማይዲ ኮሺንቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ዬያሮ ፔቴ ፔቴ ላሾ ሚፆ ፃጳ ላምዖ ቶኪ ዓኣያ ማዓንዳጉዲ ማሂ ሳሊ ላሾ ሚሢ ቢራ ዓንጊዳፓ ኮሺንቴ ታጶ ላሆ ቶኪ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ታጶ ዶንጎ ጋጋርሲ ሻሪ ሚሢዳፓ ኮሼኔ፤ ዬያሮ ዶንጎንሢ ዓፒሎና ማዢንቴ ማኣሮኮ ፔቴ ዛሎና ዓኣ ላሾ ሚፆንሢም ማዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ዶንጎንሢ ሃሣ ባጎ ዛሎና ዓኣ ላሾ ሚፆንሢም ማዔኔ፤ ዬያጉዲ ሃሣ ዶንጎንሢ ዓፒሎና ማዢንቴ ማኣሮኮ ዙሊና ዓባ ጌላ ዛሎይዳ ማሂ ኮሺንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ላሾ ሚፆኮ ጎኦቦ ዛሎና ሳዛ ዓኣ ጋጋርዞ ሚፃ ዓፒሎና ማዢንቴ ማኣሮኮ ፔቴ ዛሎ ዓጫፓ ዴንዲ ባጎ ዛሎ ዓጮ ጋፒንፆ ሄላንዳኣናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ላሻሢ ሚፆ ዎርቄና ጳርቂ ኮሼኔ፤ ጋጋርዞ ዳኮንዶ ካራ ማዓንዳጉዲ ዎርቄና ዢኢሮ ኮሼኔ፤ ጋጋርዛኣ ዎርቄና ጳርቂንቲ ኮሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ጎኦቦ ዓፒሎዋ ሚዛጲ ዓፒላይዳፓ ኮሼኔ፤ ዬይያ ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሼኤሜና ሱኮናያ ማዓዛ፥ ኪኢታንቻሢ ኪሩቤኤሌ ማላታ ማይሊ ሲኪንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ጎኦቦ ዓፒሎ ዎላ ዓይሣ ዖይዶ ቱርቱሪ ሻሪ ሚሢዳፓ ዎርቄና ጳርቂ ዔያታ ኮሼኔ፤ ዬያቶይዳ ዓኣ ኪሮዋ ዎርቄና ኮሼኔ፤ ቱርቱራ ዔቃንዳ ዖይዶ ቶኪ ቢራ ዓንጊና ማዤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ዓፒሎና ማዢንቴ ማኣሮኮ ካሮ ጮልዔ፥ ዲንኪና ዞቄ ሱኡፔ ሼኤሜና ማይሊ ሲኪ ሚዛጲሶና ጎኦቦ ዓፒላ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ዬኖ ጎኦቦ ዓፒሎም ኪሬ ዓኣ ዶንጎ ቱርቱሪ ኮሼኔ፤ ዬያቶኮ ታኣቦቶ ሬኤኮንታ ፒዝ ጌዔ ዓንጎዋ ዎርቄና ጳርቂ ዔያታ ኮሼኔ፤ ቱርቱሮንሢያ ዔቃንዳ ዶንጎ ሞኦና ዓንጊ ቶኪ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ሻሪ ሚሢና ጫኣቁሞ ጌሎና ታኣቦቶ ጌይንታ ሳኣፂኖ ባስሊዔኤሌ ኮሼኔ፤ ዬያኮ ዖዶሱማ ላምዖ ዋዻና ፓልፃና፥ ጎጶ ዳልጉማ ፔቴ ዋዻና ፓልፃና፥ ሌካ ዼጉማ ፔቴ ዋዻና ፓልፃናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ጋሮንታ ዙሎንታ ጌኤሺ ዎርቄና ጳርቂ ዒ ኮሼኔ፤ ዳኣሮ ዓጮ ጉቤ ዎርቄና ጳርቂ ጊኢጊሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ኬዲሢም ማዓንዳ ሱሢ ዖይዶ ዎርቄ ዢኢሮ ማሂ ኮሼኔ፤ ዬንሢያ ፔቴ ዛሎና ላምዖ ዢኢሮ፥ ባጎ ዛሎና ላምዖ ዢኢሮ ዖይዶ ቶኮይዳ ኮሺ ዎላ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ዛጳሢ ሚፆዋ ሻሪ ሚሢ ዓርሲ ኮሺ ዎርቄና ዒዚ ጳርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ታኣቦቶኮ ዓጫኣ ዓጫ ዓኣ ዢኢራሢዳ ጌልዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ዖዶሱማ ላምዖ ዋዻና ፓልፃና፥ ጎጶ ዳልጉማ ፔቴ ዋዻና ፓልፃና ማዔ ጎሞ ዓቶም ጌይፆ ዔርዛ ጉኡፖ ጌኤሺ ዎርቄና ዒዚ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ጋኣሲ ዓኣያ ላምዖ ኪሩቤኤሌ ዹይንቴ ዎርቄና ኮሺ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ጎሞ ዓቶም ጌይፆ ዔርዛ ጉኡፖይዳ ፔቴዞ ፔቴ ዛሎና፤ ላምዓሳዞ ባጎ ዛሎና ማሂ ካሮና ዎላ ፔቴ ማሂ ዒዚ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ኪሩቤኤላ ጋኣዞ ፔኤሲ ሌካ ዼጊዲ ፒሺ፥ ዬኖ ጉኡፔሎ ካንቃያ፤ ሃሣ ዎሊ ዛዛጋያ ማሂ ዒዚ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ዖዶሱማ ላምዖ ዋዻ፥ ጎጶ ዳልጉማ ፔቴ ዋዻ፥ ሌካ ዼጉማኣ ፔቴ ዋዻና ፓልፃና ማዔ ዼጌ ሎኦዤ ሻሪ ሚሢና ዒዚ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ዬያ ጌኤሺ ዎርቄና ጳርቂ፥ ዓጮዋ ዎርቄና ጳርቂ ዳኣራ ማሂ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ሃሣ ዓጮ ጉቤ ፔቴ ኬኤላ ዋዻ ማዓ ዎርቄና ጳርቂ ማሂ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ኬዲም ማዓንዳ ሱሢ ዖይዶ ዎርቄ ዢኢሮና ኮሺ ዖይዶ ቶኮንሢ ዾቂንቴ ዖይዶ ዛሎይዳ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ዼጌ ሎኦዦ ኬዶንዶ ዛጳሢ ሚፆ ጌልዞ ዢራሢ ዓጮ ዛሎይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ዛጳሢ ሚፆዋ ሻሪ ሚሢና ኮሺ ዎርቄና ዒ ጳርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ዼጌ ሎኦዦይዳ ጌሢንታ ዱማ ዱማ ማዺንቶ ሜሆ ዎርቄና ዒዚ ኮሼኔ፤ ዬይያ፦ ዑዦ ዱዖ ጉንጉላሢና ሳኣኖናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ፖዖ ጌሦ ሻርኖ ጌኤሺ ዎርቄና ዒዚ ኮሼኔ፤ ሃሣ ቶኮንታ ፒዝ ጌዔ ዓንጎዋ ዎርቄ ዹይ ኮሼኔ፤ ፓልሞም ማዓ ቡኖ ማላቶ ፂሊና ዋላሺና ዓኣያ ማሂ ዒዚ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ፔቴ ዛሎና ሃይሦ፤ ባጎ ዛሎና ሃይሦ ማዒ ጎኦባፓ ዬያቶኮ ላሆ ካኣፒ ኬስካንዳጉዲ ማሂ ዒዚ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ላሆ ካኣፖ ፔቴ ፔቴዞንሢኮ ፂሊና ዒላሺና ዓኣ ሌውዜ ሚፄሎ ቡኖ ማላ ሃይሦ ሃይሦ ዑሽኮ ዓንጎ ማላ ቡኒ ዒኢካ ጊዳ ማዢንቲ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ፖዖ ጌሦ ሻርኖኮ ፒዝ ጌዒ ዔቄ ዓንጋ ፂሊና ዒላሺና ዓኣ ሌውዜ ሚፆ ቡኖ ማላያ፤ ሃሣ ዖይዶ ዑሽኮ ዓንጎ ፓልሞ ማላ ማላታ ጊዳ ኮሺንቲ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ሃይሦ ዋኣፃ ማዔ ካኣፖንሢኮ ፔቴ ፔቴ ዋኣፆኮ ዴማ ፔቴ ፂሊ ኮሺንቲ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ፂሎንታ ካኣፖንታ ፖዖ ጌሦ ሻርናኣ ዎርቄ ዹይ ፔቴ ማሂ ኮሾናያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ፖዖ ጌሦ ሻርኖኮ ላንካይ ፖዒ፥ ጋውቺንታ ጋውጮ ጌሦ ቤዞንታ ጌኤሺ ዎርቄና ዒዚ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ፖዖ ጌሦ ሻርኖና ማዾ ሜሆ ቢያ ኮሻኒ ኩርሴሢ ሃይሢታሚ ዶንጎ ኪሎ ጊራሜ ማዓ ጌኤሺ ዎርቄኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ዖዶሱማ ፔቴ ዋዻ፥ ጎጶ ዳልጉማ ፔቴ ዋዻ፥ ሌካ ዼጉማ ላምዖ ዋዻ ማዒ ዖይዶ ዛላ ሄኮ ማዔያ ዑንጆ ጩቢሶ ቤሲ ሻሪ ሚሢና ዒዚ ኮሼኔ፤ ካኣማ ካሮ ዖይዳሢዳ ዓኣ ዻንኮንሢ ዬያና ዎላ ፔቴ ማዒ ኮሺንቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ቤርቶንታ ዎላ ካኣማ ዖይዶ ካሮንታ ዻንኮንታ ቢያ ጌኤሺ ዎርቄና ጳርቂ፥ ዓጮዋ ዎርቄና ዳኣራ ማሂ ዒዚ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ዓጮ ዳኣራ ማሂ ኮሾና ባኮኮ ዴማ ላምዖ ዎርቄ ዢኢሮ ኮሺ ላምዖ ዛሎይዳ ሻውሎና ሚዛቆናይዳ ዓይሢ ጊኢጊሼኔ፤ ዬንሢ፥ ዬያ ዑንጆ ጩቢሾሢ ኬዶንዶ ዛጶ ሚፃ ጌላንዳጉዲ ኮሺንቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ዛጶ ሚፆንሢ ሻሪ ሚሢና ዒዚ ኮሺ ዎርቄና ጳርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ፆኦሲም ዱማዼ ቲዦ ዛይቶንታ ቃራ ሳውሞ ዓኣ ሳዊ ዑንጄ ሳዎ ባኮ ኮሻ ዓሳ ኮሻሢ ጎይፆ ጊኢጊሺ ዒዚ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ሚቺ ዒንጎ ባኮ ዒንጎንዶ ቤዞ ሻሪ ሚሢና ዒዚ ኮሼኔ፤ ዬይያ፦ ዖይዶ ዛላ ዎላ ካኣማያ ዖዶሱማ ዶንጎ ዋዻ፥ ጎጶ ዳልጉማ ዶንጎ ዋዻ፥ ሌካ ዼጉማ ሃይሦ ዋዻ ማዓያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ዒንጎ ባኮ ዒንጎ ቤዞና ዎላ ፔቴ ማዒ ኮሺንቴ ዻንኮንሢ ዖይዶ ዛሎና ጌሢ ቢያሢ ሞኦና ዓንጎና ዒ ጳርቂ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ዒንጎ ባኮ ዒንጎ ቤዞይዳ ዓኣ ማዺንቶ ሜሆ፥ ዖቶ፥ ታሞ ካኣሾ ቦኦቆ፥ ዻኮ ሺልዖ፥ ኪሮ፥ ታሞ ጌሢ ዔኤሦ ቤዞዋ ሞኦኖ ዓንጎና ዒ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ሮኦጬ ማላ ሞኦና ዓንጊ ኮጬ ዒዚ ኮሼኔ፤ ዬይ ዓንጎ ኮጫ ዒንጎ ባኮ ዒንጎ ቤዞኮ ሄካሢ ሄላያ፥ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዴሞ ዛላ ማሂ ዒዚ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ኬዶንዶ ዛጳሢ ጌላንዳ ካራ ማሂ ዖይዶ ዢኢሮ ኮሺ፥ ዖይዶ ዛሎና ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ዛጳሢ ሚፆዋ ሻሪ ሚሢና ኮሺ ሞኦኖ ዓንጎና ጳርቂ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ሚቺ ዒንጎ ቤዞኮ ጎኦቦና ጎኦቦና ዓኣ ዢኢራሢዳ ጌልዜኔ፤ ዬና ሚቺ ዒንጎ ቤዜላ ኮሺንቴሢ ላሾ ሚሢና ኮሺንቴያ ማዓዖ ጋራ ጉሪኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ዋኣፆ ማስቶ ሳኣኖ ጌሦ ቤዞዋ ሞኦና ዓንጊና ዒዚ ኮሼኔ፤ ዬያ ሞኦኖ ዓንጎ ዒዚ ዔኬሢ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮይዳ ማዻ ላኣላ ዔኪ ሙኬ ሞኦኖ ዓንጎ ሌማሌኤሻሢዳፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ዓፒሎና ማዢንቴ፥ ፆኦሲም ዱማዼ ማኣሮኮ ቃምዖ ጋሮ ጎኦቦ ዓፒላ ሚዛጲ ሱኡፖ ዓፒላና ዒዚ ኮሼኔ፤ ጎኦቦ ዓፒሎኮ ዖዶሱማ ዾኦሎ ዛሎና ፄኤታ ዋዻኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ጎኦቦ ዓፒሎ ዓርቃ ላማታሚ ቱርቱሪና ላማታሚ ቶኪያኣ ሞኦና ዓንጊና ዒ ኮሼኔ፤ ቱርቱሮኮ ዓኣ ኪሮና ፒዝ ጌዔ ዓንጎ ቢራ ዓንጊና ዒዚ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ኬዶ ዛሎ ቃምዖ ጋሮኮዋ ኮሺፃ ዬኖ ጎይፆኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ዓባ ጌላ ዛሎና ዶንጊታሚ ዋዻ ዖዶሱሞ ዓኣ ጎኦቦ ዓፒላ ዓኣኔ፤ ዬንሢኮዋ ታጶ ቶኪ ዓኣ ታጶ ቱርቱሪ ዓኣኔ፤ ቱርቱሮንሢኮዋ ቢራ ዓንጊና ኮሺንቴ ኪሬና ዖዶሲ ዓንጊና ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ጌሎ ካሮይዳ ዓባ ኬስካ ዛሎና ዓኣ ቃምዖ ጋሮኮ ዳልጉማ ዶንጊታሚ ዋዻኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","ዓፒሎና ማዢንቴ ማኣሮ ጌሎ ካሮኮ ፔቴ ፔቴ ዛሎና ታጶ ዶንጎ ዋዻ ማዔ ዖዶሱሞ ዓኣ ጎኦቦ ዓፒላ ዓኣኔ፤ ዬንሢ ዔቂሳ ቶኪ ዓኣ ሃይሦ ቱርቱሪ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ዬኖ ቃምዖ ጋሬሎኮ ዙሎይዳ ዓኣ ጎኦቦ ዓፒላ ቢያ ሚዛጲ ሱኡፖ ዓፒላና ኮሺንቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ቱርቱሮንሢኮ ቶካ ኮሺንቴሢ ሞኦና ዓንጊናኬ፤ ኪሮና ፒዜ ዓንጎና፥ ሃሣ ቱርቱሮኮ ቶኦኮ ካንቆሢያ ቢራ ዓንጊና ኮሺንቴያኬ፤ ዬኖ ቃምዖኮ ዙላ ዓኣ ቱርቱራ ቢያ ፒዝ ጌዔ ቢራ ዓንጊና ዓርቂንቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ቃምዖ ጋሮ ጌሎ ካሮ ጎኦቦ ዓፒላ ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሱኡፔይዳፓ ሱኪንቴ፥ ሼኤሜና ኩቻ ማይሊ ሲኮና ሚዛጲ ጉኡሢ ዶዲ ሻሎና ኮሺንቴያኬ፤ ዬይያ ቃምዖ ጋሮኮ ጎኦቦ ዓፒሎጉዲ ዖዶሱማ ላማታሚ ዋዻ፥ ሌካ ዼጉማ ዶንጎ ዋዻኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ዖይዶ ሞኦና ዓንጊ ቶኪ ዓኣ ዖይዶ ቱርቱሪና ዬይ ሬኤኪንቴኔ፤ ዬያቶይዳ ዓኣ ኪራ፥ ሬኤካ፥ ፒዝ ጌዔ ዓንጋ፥ ቢራ ዓንጊና ኮሺንቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ዓፒሎና ማዢንቴ ማኣሮና ዙሎ ቃምዖ ዲሮኮ ጎኦቦ ዓፒሎም ማዓ ፃውና ቢያ ኮሺንቴሢ ሞኦና ዓንጊናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ታጶ ዓይሢፃ ፃኣፒንቴ ላምዖ ዓርሲፆ ሹጮንሢ ጌሢንቲ ናንጋ ቤዛ፥ ዓፒሎና ማዢንቴ ፆኦሲም ዱማዼ ማኣሮ ማዾም ኮይሳ ዱማ ዱማ ዓንጋ ያዺኬ፤ ዬንሢ ዱማ ዱማ ዓንጎንሢኮ ፓይዶ ሺኢሼሢ ሙሴ ማዓዛ፥ ኮሺንቴሢ ጋዓንቴ ቄኤሳሢ ዓኣሮኔ ናኣዚ ዒታማሬ ሱኡጌ ማዔም ሌዊ ዓሶ ዛሎናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ዪሁዳ ዜርፆይዳፓ ሁኡሬኮ ናኣዚ ናይ ማዔሢ፥ ዑኡሬ ናኣዚ ባስሊዔኤሌ፥ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ቢያ ባኮ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ዳኣኔ ዜርፆይዳፓ ማዔ ዓይሳማኬ ናኣዚ ዔኤሊያቤ ዒዛ ማኣዲ ዓንጊ ሼኤሻያ፤ ሃሣ ማዾኮ ማዾንዶ ጎይፆ ኬሳ ዔራቶ ዓኣያ፤ ዬያጉዲ ሃሣ ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሱኡፔፓ ሱኪ ሚዛጲ ዓፒላ ዹዓ ዶርዜኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ዓፒሎና ማዢንቴ ጌኤዦ ማኣሮ ማዦም ማዓንዳጉዲ ፆኦሲም ዱማዺ ዒንጊንቴ ዎርቆ ቢያኮ ዴኤሡማ ፔቴ ሺያ ኪሎ ጊራሜ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ቢያ ዴሮይዳፓ ቡኬ ቢሮ ዓንጎ ዴኤሡማ ሃይሦ ሺያና ዖይዶ ፄኤታና ሃይሢታሚ ኪሎ ጊራሜ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ዬይያ፥ ዴራ ፓይዲንቴ ዎዶና ፃኣፒንቴ ዓሳ ፔቴ ፔቴሢ ዒንጋኒ ኮይሳማ ጉዴያ ጪጌሢ ቢያ ማዓያኬ፤ ዴሮ ፓይዶይዳ ጌሌዞንሢ ላማታሚ ሌዔ ኩሜያና ዬካፓ ዑሣ ማዔያ ላሆ ፄኤታና ሃይሦ ሺያና ዶንጎ ፄኤታና ዶንጊታሚ ዓቲንቄኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ሃይሦ ሺያና ዖይዶ ፄኤታ ኪሎ ጊራሜ ማዓ ቢሮ ዓንጋ ዓፒሎና ማዢንቴ፥ ፆኦሲም ዱማዼ ማኣሮንታ ጎኦቦ ዓፒሎ ዾቂ ዔቂሶም ማዓ ፔቴ ፄኤታ ቶኪንታ ኮሺፆም ማዔኔ፤ ዬይ ፔቴ ፔቴ ቶካ ሃይሢታሚ ዖይዶ ኪሎ ጊራሜ ቢራ ዓንጊ ማዓያና ማዺንታንዳጉዲ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ሃንጎ ዓቴ ሃይሢታሚ ኪሎ ጊራሜ ማዓ ቢሮ ዓንጎና ባስሊዔኤሌ ቱርቱሮኮ ባኣሎንታ ፒዜ ዓንጎንታ ሙስኩሎዋ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ፆኦሲም ዱማዺ ዒንጊንቴ ሞኦኖ ዓንጎኮ ዴኤሡማ ላምዖ ሺያና ዖይዶ ፄኤታና ላማታሚ ዶንጎ ኪሎ ጊራሜ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጌሎ ካሮኮ ማርሾ ካሮ ዔቂሶ ቶኮንታ፥ ሞኦኖ ዓንጎ ኮጬሎንታ፥ ሞኦኖ ዓንጎና ኮሺንቴ ዒንጎ ባኮ ዒንጎ ቤዞንታ፥ ዒንጎ ቤዞይዳ ማዾ ማዺንቶ ሜሆ ቢያሢንታ ሞኦና ዓንጊና ዒዚ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ዙሎይዳ ዓኣ ቃምዖ ጋሮ ዲሮንታ ቃምዖ ጋሮ ጌሎ ማርሾ ካሮ ዔቂሳ ቶኮንታ፤ ዬያጉዲ ሃሣ ዓፒሎና ማዢንቴ ማኣሮና ዙላ ዓኣ ቃምዖ ዲሮና ፃውኖዋ ቢያ ዒ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ቄኤሳ ፆኦሲም ዱማዼ ቤዞይዳ ማዻ ዎዶና ማኣዓንዳ ሚርጌ ሚዛጲ ማኣዖ ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሱኡፖ ዔያታ ኮሼኔ፤ ዓኣሮኔኮዋ ቄኤሱሞ ማኣዓሢ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤሢ ጎይፆ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ዔፑዶዋ ዎርቄ ፓቲሌና፥ ጮልዔና ዲንኪ ሃሣ ዞቄ ሱኡፖና ኮሺንቴ ሚዛጲ ዓፒላ ዔያታ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ዎርቆዋ ዹዒ ጉኡፂሲ ፓቲሌጉዲ ማሂጋፓ ቲቂ ቲቂ ጊኢጊሼኔ፤ ዬያ ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሱኡፖና ሲኪንቴ ሚዛጶ ዓፒሎይዳ ኩቻ ማይሊ ሲኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ጌኤቶይዳ ዓጊንታ ላምዖ ሱሢ ኮሺ ዔፑዶ ዓርቃንዳጉዲ ዓጮና ዓጮና ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤሢጉዲ ዎርቄ ፓቲሌና፤ ጮልዔ፥ ዲንኪ ሃሣ ዞቄ ሱኡፖና ኮሺንቴ ሚዛጲ ዓፒላ ዔራቶና ማይሊ ሲኪንቴ ቃልሾ ፔቴ ማሂ ዔፑዶና ዎላ ዓይሢ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ሜሬጊዴ ጌይንታ ሚዛጶ ሹጮዋ ጊኢጊሺ ዎርቆ ፓልማሢና ዎላ ዔያታ ዓይሤኔ፤ ዬያቶይዳ ታጶ ላምዖ ያይቆኦቤ ናኣቶኮ ሱንፃ ሃኣማቶና ቆኦቂ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ዬያታኣ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ታጶ ላምዖ ዒስራዔኤሌ ዓሶ ማኣሮ ፃጶ ቤዞ ዔቃያ ማዒ ማሊንታንዳጉዲ ጌኤቶይዳ ዓጊንታ ዔፑዶኮ ሱፆይዳ ዔያታ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ዳዳ ማኣዒንታ ቡራሻ ዔፑዳ ኮሺንቴ ባኮ ማላ ባኣዚና ሃኣማቲ ኮሺንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ዬይያ ላምዖ ጳንጪንቴያ ዖይዶ ዛሎና ዎላ ካኣማያ ዖዶሱማ ፔቴ ኬኤላ ዋዻ፥ ጎጶ ዳልጉማ ዒማጉዲ ማዔያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ሚዛጶ ሹጮዋ ዖይዶ ቤሲ ፓቂ ዔያታ ጌሤኔ፤ ዬይያ፦ ቤርታሳ ቤዞይዳ ሴርዲዮኔ፥ ቶጳዚዮኔንታ ዊልጭ ዊልጭ ጋዓ ሚዛጶ ሹጮ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ላምዓሳ ቤዛ ቤሉሬ፥ ሴንፔሬና ዓልማዞ ጌይንታ ሹጮ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ሃይሣሳ ቤዛ ያኪንቴ፥ ኬልቄዶኔና ዓሜቴስፂኖሴ ጌይንታ ሹጮ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ዖይዳሳ ቤዛ ቢሪሌ፥ ሜሬጊዴና ዒያስጲዴ ጌይንታ ሹጮ፤ ዬያታ ቢያ ዎርቆና ኮሾና ባኮ ዑፃ ጌሢንቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ሚዛጶ ሹጮንሢ ታጶ ላምዖ ዒስራዔኤሌ ዓሶ ፃጶ ዛላ ማዒ ማሊንታንዳጉዲ ፔቴ ፔቴ ሹጮ ዑፃ ታጶ ላምዖ ያይቆኦቤ ናኣቶ ፔቴ ፔቴሢኮ ሱንፃ ቆኦቂ ፃኣፒንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ዳዶ ቡራሾም ሱሲጉዲ ማርቴ ሱፆ ባኣዚ ዎርቄና ዔያታ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ላምዖ ዎርቄ ፓልሞ፤ ጊንሣ ሃሣ ላምዖ ዎርቄ ዢኢሮ ኮሺ፥ ላምዖ ዢኢሮንሢ ዳዳ ዓኣ ቡራሾኮ ኬዴ ዎላ ካኣማ ካሮይዳ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ላምዖ ዎርቆ ፓቲሎንሢ ዢኢሮንሢና ዎላ ዔያታ ዓይሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ሜሌ ላምዖ ዎርቆ ፓቲሎንሢኮ ቶኦኮ ላምዖ ፓልሞንሢና ዎላ ካንሤኔ፤ ዬያጉዲ ጌኤቶና ሊካ ኬዳ ዔፑዶ ሱፆኮ ቤርቶና ዎላ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ቃሲ ላምዖ ዎርቄ ዢኢሮ ኮሺ ዔፑዶኮ ቤርቶ ዛሎና ዓኣ ዳዶ ቡራሾኮ ላምዖ ጋሮ ዛሎ ቶኦኮና ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ሄሊሳዖ ላምዖ ዎርቄ ዢኢሮ ኮሺ ጌኤቶና ሊካ ኬዳ ቤርቶ ዛሎና ላምዖ ዔፑዶ ሱፆንሢዳ ዴሞ ዛሎና ዓይሤኔ፤ ዬንሢ ዎላ ዓርቂንቴዞንሢ ዔራቶና ማይሊ ሲኪንቴ ቃልሾኮ ኬዶ ዛላ ካኣማ ካሮ ዓጫኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆና ዳዶ ኪኢሶይዳ ዓኣ ዢኢሮንሢ ዔፑዶ ዢኢራሢና ዎላ ጮልዔ ፓቲሌና ዔያታ ቱኬኔ፤ ዬያ ጎይፆና ዳዶ ቡራሾኮ ቃልሻ ዑፃ ማዔሢሮ ዑኬና ቡሊንቱዋያ ዶዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ዔፑዶ ዑፃ ቃሲ ማይንቲንታ ቃሚሻ ኮሺንቴሢ ጉቤ ጮልዔ ሱኡፔ ዓፒላናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ቃሚሾኮ ቶኦካ ጌላ ካሮ ዓጫ ቡሊንቱዋጉዲ ጳንጪ ሲኪንቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","ቃሚሾኮ ዴሞ ዛሎ ዓጫ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆና ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሱኡፔና ሲኪንቴ ሚዛጲ ዓፒላና ኮሺንቴ ሮኦማኣኔ ሚፆ ዓኣፖ ማላ ዓኣፒ ሼኤሜና ማይሊ ሲኪንቲ ዓኣኔ፤ ዬንሢ ዓኣፖንሢኮ ባኣካ ዓኣዺ ዓኣዺ ጌኤሺ ዎርቄና ኮሺንቴ ሂቻ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ዓኣሮኔና ዒዛኮ ናኣቶናም ዶርዜ ዹዔ ሚዛጲ ዓፒላና ኮሺንቴ ሹራቤ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ቶኦኪ ዖሾያ፥ ቆኦቤ፤ ሃሣ ቆንፄያ ዔያታ ጊኢጊሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ኬርና ቱኮ ቃልሾ፦ ጮልዔ፥ ዲንኪ፤ ሃሣ ዞቄ ሱኡፔና ሱኪ ኮሺንቴ ሚዛጲ ዓፒላ ጊኢጊሺ፥ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤሢጉዲ ሼኤሜና ሃኣማቲ ማይሊ ዔያታ ኮሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ካኣታ ቶኦካ ዓጋ ቦንቾ ባኮ ማላያ፥ ፆኦሲም ዱማዼ ቆኦቤ ጌኤሺ ዎርቄና ኮሺ፥ «ናንጊና ናንጋ ጎዳም ዱማዼያ» ጋዓያ ጊዳ ቆኦቂ ፃኣፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤሢ ጎይፆ ቶኦኮ ዖሾሢኮ ቤርቶ ዛሎይዳ ዬያ ዔያታ ጮልዔ ፓቲሌና ቱኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ማዻ ጉቤ ዬያይዲ ጋፔኔ፤ ዒስራዔኤሌ ዓሳ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆ ማዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ዓፒሎና ማዢንቴ ማኣሮንታ ጋራ ማዺንቶ ሜሆዋ ቢያ ሙሴ ኮራ ዔያታ ዔኪ ሙኬኔ፤ ዬይ ሜሃ ሃካፓ ሊካ ፓይዲንታሢጉዲኬ፦ ኪራ፥ ላሻሢ ሚፃ፥ ጋጋርዛ፥ ቱርቱሮንታ ዔቂሶ ቶካ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ዓዶ ማራዖ ጎሮና ኮሺንቲ ዞቄ ቃላሞና ዑሾና ካንቆ ጉፓሎንታ ሺርኪንቴ ጉላምቦ ዜዾና ኮሺንቴ ካንቆሢ፥ ዱማሲፆሮ ጎኦቦ ዓፒላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ዓርሲንቴ ሹጫ ጋራ ዓኣ ዎጋ ፃኣፒንቴ ጫኣቁሞ ታኣቦታ፥ ዛጶ ሚፆንታ ጎሞ ዓቶም ጌይፆ ዔርዛ ጉኡፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ዼጌ ሎኦዦንታ ዒኢካ ማዾ ማዺንቶ ሜሆንታ ጉቤ፤ ፆኦሲም ዒንጎ ባኣዚ ማሂ ዒንጊንታ ሙዓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ጌኤሺ ዎርቄና ኮሺንቴ ፖዖ ጌሦ ሻርና፥ ጌሢንታ ፖዖንታ ማዺንቶ ሜሃ፥ ፖዖም ኮይሳ ላምባሢ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ዎርቆና ኮሺንቴ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዛ፥ ቲዦ ዛይታ፥ ቃራ ሳውሞ ዓኣ ዑንጃ፥ ዓፒሎና ማዢንቴ ማኣሮኮ ማርሾ ካሮም ኮሺንቴ ጎኦቦ ዓፒላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ሞኦኖ ዓንጎና ኮሺንቴ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዛ፥ ሞኦኖ ዓንጎና ኮሺንቴ ኮጮንታ ዛጶ ሚፆንታ ዬያ ባኮኮ ሜሆ ቢያ፤ ዋኣፆ ማስቶ ሳኣኖንታ ጌሦ ቤዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ዓፒሎና ማዢንቴ ማኣሮኮ ቃምዖ ጋሮም ማዓ ጎኦቦ ዓፒላ፥ ቱርቱሮና ዬያታ ዔቃ ቶካ፥ ቃምዖ ጋሮ ጌሎ ማርሾ ካሮም ኮሺንቴ ጎኦቦ ዓፒሎንታ ቱኮ ሱዛ፥ ዓፒሎና ማዢንቴ ማኣራ ዾቂንታ ፃውና፥ ዓፒሎና ማዢንቴ ማኣራ ማዺንቶ ሜሃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ቄኤሳሢ ዓኣሮኔንታ ናኣቶንታ ጌኤዦ ማኣሮይዳ ቄኤሴ ማዒ ማዻኣና ማኣዓ፥ ፆኦሲም ዱማዼ ሚዛጶ ማኣዓሢንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ዒስራዔኤሌ ዓሳ ማዾ ቢያ ማዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ሙሴያ ቢያ ባኮ ዛጊ ናንጊና ናንጋ ጎዳ ጌዔማ ጎይፆ ማዺንቴሢ ዴንቄኔ፤ ዬያሮ ሙሴ ዔያቶ ዓንጄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ናንጊና ናንጋ ጎዳ ሙሴም ሂዚ ጌዔኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«ቤርታሳ ዓጊኖ ፄኤሮኮ ቤርታሳ ኬሎና ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮ ዾቄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ታጶ ዓይሢፃ ፃኣፒንቴ ጫኣቁሞ ታኣቦቶ ዬኖ ኬኤፆኮ ጋራ ጌሢ፥ ዱማሲፆሮ ኮሺንቴ ጎኦቦ ዓፒሎ ቤርቶ ዛሎና ሱፄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ዼጌ ሎኦዦዋ ጋሮ ጌልዚ ዒኢካ ማዺንቶ ሜሆ ቢያ ዬያ ዑፃ ጌሤ፤ ፖዖ ጌሦ ሻርኖዋ ጌልዚ ፖዖ ዒኢካ ጌሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ዎርቆና ኮሺንቴ፥ ዑንጆ ጩቢሾሢ ጫኣቁሞ ታኣቦቶኮ ቤርታ ጌሤ፤ ዓፒሎና ማዢንቴ ማኣሮኮ ጌሎ ካራ ጎኦቦ ዓፒሎ ሱፄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ሚቺ ዒንጎ ባካ ዒንጊንታ ቤዞ ዓፒሎና ማዢንቴ ማኣሮ ጌሎ ካሮኮ ሆታ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ዓፒሎና ማዢንቴ ማኣሮና ሚቺ ዒንጎ ቤዞናኮ ባኣካ ዋኣፆ ማስቶ ሳኣኖ ጌሢ ዋኣሢ ኩንሤ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ቃምዖ ጋራ ማዓ ካሮ ማሂ ዲርቄ፤ ጎኦቦ ዓፒሎ ማርሾ ካራ ሱፄ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«ዬካፓ ዓፒሎና ማዢንቴ ማኣሮንታ ዒኢካ ማዺንቶ ሜሆንታ ጌኤዦ ዛይቶና ቲሽኪ፥ ታኣም ዱማሴ፤ ዱማዺ ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ሄሊሳዖ ዒንጎ ባኮ ዒንጎ ቤዞንታ ዒኢካ ማዾ ሜሆዋ ጌኤዦ ዛይቶና ቲሽኪ ታኣም ዱማሴ፤ ዬይ ፔቶ ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ዋኣፆ ማስቶ ሳኣኖና ጌሦ ቤዞና ዒዞ ጎይፆ ቲሽኪ ታኣም ዱማሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«ዓኣሮኔንታ ናኣቶንታ ዒኢካ ካራ ዔኪ ሙኪ ዎጎ ጎይፆና ማስታንዳጉዲ ዔያቶም ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ቄኤሶ ማኣዓሢ ማይሲ ዛይቶና ዓኣሮኔ ቲሽኬ፤ ዬያይዲ ቄኤሴ ማዒ ታኣም ማዻንዳጉዲ ታኣም ዱማሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ናኣቶዋ ዒዛኮ ዔኪ ሙኪ ሹራቦ ዔያቶ ማይሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ዔያታኣ ታኣም ቄኤሴ ማዒ ማዻንዳጉዲ ዔያቶኮ ዓዶ ኔ ቲሽኬሢጉዲ ዔያቶዋ ቲሽኬ፤ ዔያቶ ኔ ቲሽኬሢሮ ሙካ ዎዶ ቢያይዳ ቄኤሴ ማዒ ታኣም ዔያታ ማዻንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ሙሴያ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤማ ጎይፆ ቢያ ባኮ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ዬያሮ ጊብፄ ዓጫፓ ዔያታ ኬስኬ ላምዓሳ ሌዖኮ ቤርታሳ ዓጊና ፄኤሬ ቤርታሳ ኬሎና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣራ ዾቂንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ዓፒላፓ ማዢንቴ ማኣሮኮ ቶኮ ዔቂሲ፥ ላሻሢ ሚፆንታ ቱርቱሮዋ ዔቂሲ ጋጋርዞዋ ሙሴ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ዓፒሎና ማዢንቴ ማኣሮ ካንቆ ባኮና ካንቄኔ፤ ዙሎ ጊንሣ ዑፃ ቃሲ ካንቆሢና ካንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ላምዖ ዓርሲንቴ ሹጮ ዔኪ ጫኣቁሞ ታኣቦቶ ጋራ ጌሢ፥ ዛጳሢ ሚፆዋ ታኣቦቶኮ ዢኢራሢዳ ጌልዚ፥ ጎሞ ዓቶም ጌይፆ ዔርዛ ጉኡፖና ታኣቦቶ ካሮ ዎዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ጫኣቁሞ ታኣቦቶ ዓፒሎና ማዢንቴ ማኣሮ ጌልዚ፥ ዱማሳ ጎኦቦ ዓፒሎ ሱፄኔ፤ ዬያይዲፆና ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ታኣቦቶ ጴዹዋጉዲ ዒዚ ዓኣቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ዓፒሎና ማዢንቴ ማኣሮ ጋራ ዼጌ ሎኦዦ ጌልዚ፥ ዱማሳ ጎኦቦ ዓፒሎኮ ዙሊና ኬዶ ዛላ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ናንጊና ናንጋ ጎዳ ዓይሤሢጉዲ ዒዛም ዒንጎያ ማዒ ዒንጊንታ ካፆ ዬኖ ዼጌ ሎኦዤሎ ዑፃ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ፖዖ ጌሦ ሻርኖ ዓፒሎና ማዢንቴ ማኣሮ ጋሮ ጌልዚ፥ ዼጌ ሎኦዦኮ ቤርቶይዳ ዾኦሎ ዛሊና ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ዬያጉዲ ሃሣ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ዒኢካ ናንጊና ናንጋ ጎዳ ቤርታ ፖዖ ፖዒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ዎርቆና ኮሺንቴ ዒንጎ ባኮ ዒንጎ ቤዞዋ ዓፒሎና ማዢንቴ ማኣሮ ጌልዚ፥ ዱማሳ ጎኦቦ ዓፒሎኮ ቤርቶ ዛላ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ቃራ ሳውሞ ዓኣ ዑንጆ ዒኢካ ዒዚ ጩቢሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ዱማሳ ጎኦቦ ዓፒሎዋ ዓፒሎና ማዢንቴ ማኣሮኮ ጌሎ ማርሾ ካራ ሱፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ዒኢካ ጌሎ ካሮኮ ቤርቶ ዛላ ሚቺ ዒንጎ ባካ ዒንጊንታ ቤሲ ኮሺ፥ ሚቺ ዒንጎ ባኮንታ ሃኣኮኮዋ ዒንጎ ዒንጊፆ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ዒኢካ ሺኢሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ዋኣፆ ማስቶ ሳኣኖዋ ዓፒሎና ማዢንቴ ማኣሮና ሚቺ ዒንጎ ቤዞናኮ ባኣካ ጌሢ፥ ዋኣሢ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ሙሴ፥ ዓኣሮኔ፥ ዓኣሮኔኮ ናኣታኣ ፔኤኮ ኩጮና ቶኮና ዒኢካ ማስቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ዔያታ ዓፒሎና ማዢንቴ ማኣሮ ጌላ ዎዶና፤ ሃሣ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞ ባንሢ ዑካ ዎዶና ቢያ ናንጊና ናንጋ ጎዳ ዓይሤሢጉዲ ዬያ ዔያታ ማዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ሙሴ፥ ዓፒሎና ማዢንቴ ማኣሮና ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞናኮ ቃምዒ ጋርሲ ዱማሴኔ፤ ቃምዖ ጋሮ ጌልዛ ማርሾ ካሮይዳ ዱማሳ ጎኦቦ ዓፒላ ሱፂ ዬያይዲ ማዾ ቢያ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ዬካፓ ዓፒሎና ማዢንቴ ማኣራ ሻኣሬና ካንቂንቴም ናንጊና ናንጋ ጎዳኮ ቦንቾ ፔጋሲ ዻዋ ዓኣፓ ዱካ ፖዓ ዬያ ኬኤፆ ኩሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ዬያይዳፓ ዔቄያና ሙሴ ዓፒሎና ማዢንቴ ማኣሮ ጌላኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ዒስራዔኤሌ ዓሳ ዱንኪ ዴዔ ቤዞ ሃሺ ዓጊፃኒ ዳንዳዓሢ ሻኣራ ዓፒሎና ማዢንቴ ማኣሮ ዑፃፓ ዔቃኣና ሌሊኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ሻኣራ ዒኢካ ዓኣ ጎይሣ ዓኣንቴ ዔያታ ዓኣ ቤዛፓ ሃሺ ዓኣዹዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ዔያታ ሃንታ ዎዶና ቢያ ሮኦሪ ናንጊና ናንጋ ጎዳኮ ቦንቾ ፔጋሲ ዻዋ ሻኣራ ዓፒሎና ማዢንቴ ማኣሮ ካንቃንቴ፥ ዋንቶ ሃሣ ዬያ ማኣሮ ዑፆይዳ ታሚ ዔኤታንቴ ዒስራዔኤሌ ዓሳ ዛጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳፓ ናንጊና ናንጋ ጎዳ ሙሴ ዔኤላዖ ሂዚ ጌይ ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","ዒስራዔኤሌ ዴራ ታኣም ዒንጋ ባኮ ዒንጋ ዎዶና ዔያታ ካፓኒ ኮይሳ ዎጋ ያዺኬ፦ ፔቴ ፔቴ ዓሳ ዒንጎ ባኮ ታኣም ዒንጋ ዎዶና ፔኤኮ ባኣቶፓ፥ ማራቶፓ፥ ዋኣሮፓ ማዔቴያ ዒንጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ዬይ ዓሢ ባኣቶ ባኣካፓ ፔቴ ሚቺ ዒንጎ ዒንጊሢ ዒንጋኒ ኮዔቴ ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ዚያ ጌማይ ዶኦሪ ዔኪ ሙኮንጎ፤ ዬይያ፦ ናንጊና ናንጋ ጎዳ ናሽኪ ዔካ፥ ሚቺ ዒንጎ ዒንጊሢ ማዓንዳጉዲ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ጌሎ ካሮ ዛሎና ዔኪ ሙኪ ዔቂሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ዬካፓ ዬይ ዓሢ ሚቺ ዒንጋኒ ዔኪ ሙኬ ባኮኮ ቶኦካ ፔ ኩጮ ጌሦንጎ፤ ዬይ ዒዛኮ ጎሞ ጌኤሻኒ ዳንዳዓ ሚቺ ዒንጎ ዒንጊሢ ዒዛም ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ዬይ ዓሢ ጌሜ ዒኢካ ሹኮንጎ፤ ዬካፓ ዓኣሮኔ ፃጳፓ ማዔ፥ ቄኤሳ ሱጉፆ ናንጊና ናንጋ ጎዳ ቤርቶ ዔኪ ሙካዖ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጌሎ ካራ ዓኣ፥ ሚቺ ዒንጎ ባኮኮ ጎኦቦ ዛሎ ቢያ ፑጮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ዬካፓ ዬይ ዓሢ ዒልዖ ሹኪ ዱማሲ፥ ዓሽኮዋ ሜኤሎና ሜኤሎና ቲቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ቄኤሳሢ፥ ዓኣሮኔ ፃጶ ማዔ ቄኤሳ ሚቺ ዒንጎ ቤዞይዳ ሃንፂሎ ጊኢጊሺ ታሚ ዔኤሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ዬያይዴስካፓ ቲቂንቴ ዓሽኮኮ ሜኤሎንታ ቶኦኮንታ፥ ሃሣ ማሎዋ ዔኤታ ታሞ ዑፃ ጌሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ዬይ ዓሢ ጎጶ ባኮና ጊንፆ ቶኮና ዔኪ ዋኣሢና ማስካዛ ዬኖ ዓቦ ማዻ ቄኤሳሢ ፆኦሲም ዒንጎ ቤዞይዳ ጉቤና ሚቾንጎ፤ ዬያይዲ ሚቺ ዒንጎ ባኮኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ሚቺ ዒንጎ ባካ ማራይ፥ ሃሣ ዋኣሪ ማዔቴ፦ ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ዓዴ ማራናይ ሃንጎ ኮላይናይ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ዬያ ዒንጎ ባኮ ዒንጎ ቤዞኮ ኬዶ ዛላ ፆኦሲ ቤርታ ሹኮንጎ፤ ዬካፓ ቄኤሳ ሱጉፆ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ዛሎ ቢያ ፑጮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ዬይ ዒንጋ ዓሢ ሹኪንቴ ባኮ ሜኤሎና ሜኤሎና ቲቄሢኮ ጊንፃ ዬኖ ዓቦ ማዻ ቄኤሳሢ ሜኤሎ ዓሽኮንታ ቶኦኮንታ ማሎንታ ቢያ ፆኦሲም ዒንጎ ቤዞይዳ ጊኢጊሺንቲ ዔኤታ ታሞ ዑፆይዳ ጌሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ዬካፓ ዓሢ ጎጶ ባኮንታ ጊንፆ ቶኮንታ ዋኣሢና ማስካዛ፥ ቄኤሳሢ ዬያ ዒንጎ ባኮ ቢያ ፆኦሲም ሚቺ ዒንጎ ባኣዚ ማሂ ሺኢሺ ሚቺ ዒንጎ ቤዞይዳ ሚቾንጎ፤ ዬያይዲ ታሚና ሚቺ ዒንጎ ባኮኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ዒንጋ ዓሢ ሚቺ ዒንጎ ባኮ ካፖ ዜርፃፓ ዒንጋኒ ኮዔቴ ዶኦሌ ናይ ማዒባኣቴ ኪሬ ናይ ዔኪ ሺኢሻኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ቄኤሳሢ ዬያ ካፖ ዔኪ ሚቺ ዒንጎ ቤዞ ሺኢሼስካፓ ባቃኖ ዺዺ ዱኡዚ፥ ሚቺ ዒንጎ ቤዛ ዔኤታ ታሞይዳ ዓጊ ሚቾንጎ፤ ሱጉፃኣ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ዛላ ፆዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ጎጶ ባኮና ጋፓኖና ዱማሲ፥ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞኮ ዓባ ኬስካ ዛሎና ቢዲንፆ ላኣሎ ቤዞይዳ ኬኤሮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ዬካፓ ጋኣዞንሢ ዓርቂ፥ ሄኮ ሾኦሎንጎ፤ ጋዓንቴ ሾኦሊ ዱማሲ ኬኬሶፓ። ቄኤሳሢ ሚቺ ዒንጎ ቤዞይዳ ዓኣ፥ ታማኣ ዓጊ ቢያ ሚቾንጎ፤ ዬያይዲ ሚቺ ዒንጎ ባኮኮ ሳውማ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ዓይጎ ዓሲታቴያ ናንጊና ናንጋ ጎዳም ሃኣኮ ዒንጋ ዎዶና ሺኢቺ ዎዾና ዺኢሊ ማዓኒ ኮይሳኔ፤ ዬያይዳ ሪሚቶ ዛይቶና ጩቢሾ ዑንጆዋ ዋሆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ዬካፓ ዓኣሮኔ ዜርፆ ማዔ፥ ቄኤሶ ኮይላ ዔኪ ሙኮንጎ፤ ዬኖ ኬሎና ማዻ ቄኤሳሢ ዬያ ዺኢሎና ዛይቶናይዳፓ ሾኦፓ ኩሙሢ፥ ሃሣ ዑንጆ ቢያ ዔኪጋፓ ዬይ ቢያ ናንጊና ናንጋ ጎዳም ዒንጊንቴያ ማዔሢ ዔርዛኒ ሚቺ ዒንጎ ቤዞ ዑፃ ዓኣ፥ ታሞይዳ ሚቾንጎ፤ ዬያይዲ ዒንጎ ሙዖኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ዬካፓ ዓቴ ሃኣኮኮ ዺኢላ ዓኣሮኔ ፃጶ ማዔ፥ ቄኤሶም ዒንጊንቶንጎ፤ ዬይ፥ ናንጊና ናንጋ ጎዳም ዒንጊንቴሢዳፓ ፓቂ ዔኪንቴያ ማዔሢሮ ፆኦሲም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","ዬይ ዒንጊንታሢ ቦኦቆይዳ ጉኡፒ ላኣዲንቴያ ማዔቴ ሙኑቃ ፃኣዛ ጌሊባኣያ፥ ሪሚቶ ዛይቶና ዲርኪንቴ፥ ሺኢቺ ዺኢሊና ላኣዲንቴ ሻኣዣ ላኣዳ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ዒንጊንታ ባካ ቦኦቆይዳ ላኣዲንቴ ላኣዳ ማዔቴ ሙኑቃ ፃኣዛ ጌሊባኣ፥ ሪሚቶ ዛይቶና ዲርኪንቴ ሺኢቺ ዺኢሊና ላኣዲንቴያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ዬያ ቡንፂጋፓ ጊዳ ሪሚቶ ዛይቶ ዋሂ፥ ፆኦሲም ዒንጊንታ ሃኣኮ ማሂ ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ዬና ዒንጊንታ ባካ ታሚ ቦኦቆይዳ ላኣዲንቴ ላኣዳ ማዔቴ ሪሚቶ ዛይቶና ዲርኪንቴ፥ ሺኢጮ ዺኢሎ ላኣዶናያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ዬኖ ሃኣኮ ናንጊና ናንጋ ጎዳም ዒንጎ ዒንጊሢ ማሂ፥ ቄኤሳሢም ዒንጌ፤ ቄኤሳሢያ ፆኦሲም ዒንጎ ቤዛ ሺኢሺ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ቄኤሳሢ ዬያ ዒንጊንቴ ባኮይዳፓ ዛሎ ዔኪ፥ ቢያሢ ናንጊና ናንጋ ጎዳም ዒንጊንቴያ ማዒፆ ዔርዛኒ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞይዳ ዓኣ፥ ታማኣ ሚቾንጎ። ዬያይዲ ታሚና ሚቺንቲ ዒንጊንታ ዒንጊፆኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ዓቴ ሃኣኮ ዺኢላ ጋዓንቴ ቄኤሶም ዒንጊንቶንጎ፤ ዬይ፦ ናንጊና ናንጋ ጎዳም ዒንጊንቴሢዳፓ ፓቂ ዔኪንቴያ ማዔሢሮ ሚርጌና ፆኦሲም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","ሚቺ ዒንጎ ዒንጊሢ ማዒ፥ ናንጊና ናንጋ ጎዳም ዒንጊንታ ባኮና ዎላ ሙኑቃ ፃኣዛታቴያ ዔኤሲ ታማ ሚቺንታኒ ኮይሱዋኣሢሮ ኔኤኒ ፆኦሲም ዒንጋ ሃኣካ ቢያ ፔቴታዖ ሙኑቃ ፃኣዛ ጌሊባኣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ሌዓ ሌዓ ካፄ ሃኣኮኮ ቤርቲ ማሂ ዒንሢ ዒንጋ ባኮ ናንጊና ናንጋ ጎዳም ዔኪ ሙኩዋቴ፤ ዬይ ጋዓንቴ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዛ ሳውማ ናንጊና ናንጋ ጎዳ ዎዛሳንዳጉዲ ጌይ ሚቺንቶፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ፆኦሲም ዒንጋ ሃኣኮይዳ ቢያ ሶኦጌ ዓኣያ ማዖንጎ፤ ኔ ፆኦዛሢ ኔኤና ዎላ ጫኣቄ ጫኣቁሞ ሶኦጌ ባኣያ ጉሪ ዔኪ ሺኢሺፖ፤ ኔ ዒንጋ ሃኣኮ ዒንጊፆ ቢያ ሶኦጌና ጊኢጊሺ ዔኪ ሺኢሼ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ሌዖ ሃኣኮኮ ቤርቶ ኔ ዒንጋ ዎዶና ሚቺ ቶርሾናያ ሃንጎ ሺርኮና ቲሾ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ዬያይዳ ሪሚቶ ዛይቶንታ ዑንጆንታ ዋሄ፤ ዬይ ፆኦሲም ዒንጊንቴ ሃኣኮ ዒንጊሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ቄኤሳሢ፥ ዬያኮ ዛሎ ዔኪ ናንጊና ናንጋ ጎዳም ዒንጊንቴያ ማዒፆ ዔርዛኒ ዛይቶንታ ዑንጆንታ ቢያ ሃኣኮና ዎላ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","ዓይጎ ዓሲያ ፔኤኮ ባኣቶይዳፓ ፔቱሞና ፆኦሲም ዒንጊንታ ዒንጊፆ ዒንጋ ዎዶና ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ፔቴ ጌማይታቴያ ዒንዴ ባይ ዶኦሪ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ዬይ ዒንጋ ዓሢ ፆኦሲም ዒንጎ ባኣዚ ማሂ ዒንጋ ባኮኮ ቶኦኮይዳ ፔ ኩጮ ጌሢ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ካሮይዳ ሹኮንጎ፤ ዬካፓ ዓኣሮኔ ዜርፆ ማዔ፥ ቄኤሳ ሱጉፆ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ዛሎ ቢያ ፑጮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ዬያ ዓሽኮኮ ሃካፓ ሊካ ፓይዲንታ ቤዞንሢ ሙኡዚ ዒንጊሢ ማሂ ናንጊና ናንጋ ጎዳም ዒንጊንቶንጎ፤ ዬንሢያ፦ ጎጶ ባኮ ካንቄ ሃኣቦንታ ዒኢካ ዓኣ ማሎ ጉቤ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ጳላሢና ዒኢካ ዓኣ ማሎ፤ ዬያጉዲ ሃሣ ማዮኮ ሻኣዣዻ ቤዞዋ ዔኪ ሺኢኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ዬካፓ ቄኤሳ ዬያ ቢያ ሚቺ ዒንጎ ባኮና ዎላ ማሂ ሚቺ ዒንጎ ቤዞይዳ ሚቾንጎ፤ ዬያ ዒንጎ ባኮኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ፔቱሞና ፆኦሲም ዒንጎ ዒንጊሢ ማዒ ዒንጊንታ ባካ ማራይ ሃሣ ዋኣሪ ማዔቴ፦ ቦሂሳ ባኣዚባኣ ዓዴ ማራይ፥ ኮላይ፤ ጊንሣ ሃሣ ዒንዴ ማራይታቴያ ዋኣሪ ዒማዺ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ፔቴ ዓሲ ፆኦሲም ዒንጎ ባኣዚ ማሂ ዒንጋ ባካ ማራናይ ማዔቴያ ናንጊና ናንጋ ጎዳ ቤርቶ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ዬካፓ ኩጮ ማራናዖኮ ቶኦካ ጌሢ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ጌሎ ካራ፥ ቤርቶ ዛላ ሹኮንጎ፤ ቄኤሳ ዬያኮ ሱጉፆ ዔኪ፥ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ዛሎ ቢያ ፑጮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ዬያይዴስካፓ ዓሽኮኮ ሃካፓ ሊካ ፓይዲንታ ቤዞንሢ ሙኡዚ ዒንጊሢ ማሂ ናንጊና ናንጋ ጎዳም ዒንጎንጎ፤ ዬንሢያ፦ ማሎንታ ጉይኖ ሜጌፆ ሄሊሲ ቲቂንቴ ዑንኮ ማላኣ፥ ጎጶ ባኮኮ ዑፃ ዓኣ ሃኣቦንታ ዒኢካ ዓኣ ማሎ ቢያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ጳላሢንታ ዒኢካ ዓኣ ማሎ፤ ዬያጉዲ ሃሣ ማዮኮ ሻኣዣዻ ቤዞ ዔኪ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ዬካፓ ቄኤሳሢ ዬያ ቢያ ናንጊና ናንጋ ጎዳም ሙኡዚ ዒንጊሢ ማሂ ዒንጊ፥ ሚቺ ዒንጎ ቤዛ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ፔቴ ዓሲ ፆኦሲም ዒንጎ ባኣዚ ማሂ ዒንጋሢ ዋኣሪ ማዔቴያ ናንጊና ናንጋ ጎዳ ቤርቶ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ዬካፓ ዒዚ ፔኤኮ ኩጮ ዋኣራሢ ቶኦካ ጌሢጋፓ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቤርቶ ዛላ ሹኮንጎ፤ ቄኤሳ ዬያ ሱጉፆ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ዛሎ ቢያ ፑጮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ዬያ ዓሽኮኮ ሃካፓ ሊካ ፓይዲንታ ቤዞንሢ ሙኡዚ ዒንጊሢ ማሂ ፆኦሲም ዔኪ ሺኢሾንጎ፤ ዬንሢያ፦ ጎጶ ባኮ ካንቄ ሃኣቦንታ ዒኢካ ዓኣ ማሎ ጉቤ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ጳላሢንታ ዔያቶ ካንቂ ዓኣ ማሎ ቢያ፤ ዬያጉዲ ሃሣ ማዮኮ ሻኣዣዻ ቤዞዋ ዔኪ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ዬካፓ ቄኤሳሢ ዬያኮ ሳዋ ናንጊና ናንጋ ጎዳሢ ዎዛሳ ዒንጊሢ ማዓንዳጉዲ ሚቺ ዒንጎ ቤዛ ሚቾንጎ፤ ማሊ ቢያ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ዒስራዔኤሌ ዜርሢ ማዔ ዓሳ ጉቤ ማሊ ማዔ ዓሽኪ፤ ሃሣ ሱጉሢያ ሙዖፓ፤ ዬይ ዒስራዔኤሌ ዓሳ ናንጋ ቤዞና ናንጋ ዎዶይዳኣ ቢያ ናንጊና ካፒ ናንጋ ዎጌ ማዖም። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ናንጊና ናንጋ ጎዳ ሙሴም ሂዚ ጌይ ኬኤዜኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ዓይጎ ዓሲያ ዔሪባኣዖ ጎሜ ማዼቴ፥ ሃሣ ጊንሣ ናንጊና ናንጋ ጎዳ ዓይሤ ዓይሢፆይዳፓኣ ፔቴ ዻቤያ ማዔቴ ሃካፓ ሊካ ፓይዲንታ ዳምቦ ኩንሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«ቄኤሶ ቢያኮ ሱኡጌ ማዒ ዶኦሪንቴሢ ጎሜ ማዺ ዓሶዋ ዻቢሼያ ማዔቴ ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ፔቴ ዚያ ጌማይ ናንጊና ናንጋ ጎዳ ቤርቶ ዔኪ ሙኮንጎ፤ ዬካፓ ፔ ጎሞ ዛሎ ፆኦሲም ዒንጎ ባኣዚ ማሂ ሹኪ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ካሮ ጌሜ ዔኪ ሙኪ ኩጮ ጌሜ ቶኦካ ጌሢጋፓ ናንጊና ናንጋ ጎዳ ቤርታ ሹኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ዬካፓ ቄኤሶ ቢያኮ ሱኡጋሢ ሱጉፃፓ ዻካ ዔኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጌሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ፔ ኬኤሎና ሱጉፃፓ ዔኪ ዔኪ ጌኤዦ ማኣሮኮ ጋራ ጎኦቢንቲ ዓኣ ዓፒሎኮ ቤርቶ ዛሎና ናንጊና ናንጋ ጎዳ ቤርታ ላንካይ ማይንቲ ዉፁርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ዬካፓ ሃሣ ዻካ ሱጉሢ ዔኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ጋራ ዑንጆ ጩቢሶ ቤዞኮ ዖይዶ ዛሎይዳ ዓኣ ዻንኮንሢ ቲሽኮንጎ፤ ዓቴ ሱጉፆ ማኣሮኮ ጌሎ ካራ ዓኣ፥ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞ ዴማ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ዬያ ጌሜኮ ማሎ ቢያ ዔኮንጎ፤ ዬይያ፦ ጎጶ ባኮ ካንቂ ዓኣ ሃኣቦንታ ዒኢካ ዓኣ ማሎ ቢያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ጳላሢና ዒኢካ ዓኣ ማሎ፤ ዬያጉዲ ሃሣ ማዮኮ ሻኣዣዻ ቤዞዋ ዔኪ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ቄኤሶኮ ሱኡጋሢ ዬያ ማሎ ቢያ ዔኪ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞይዳ ሚቾንጎ፤ ማሎ ኬሲፆ ጎይፃ ፔቱሞና ዒንጎ ባኮኮ ማዺንቴ ጎይፆ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ጋዓንቴ ዒልዓ፥ ዓሽካ፥ ቶኦኮንታ ቶኮንታ፥ ሩቁንታኣ፥ ጎጶ ባካ፥ ሶኦኮዋ ቢያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ጉርዳፓ ዙላ ኬሲ ቢዲንፆ ላኣሎ፥ ካኣዦ ዳምቦና ጌኤሺ ማዔ ቤዞ ዔኪ ዓኣዺ ኩሊንቴ ዲቢንፆ ዑፃ ታሚ ዔኤሢ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«ጉቤ ዒስራዔኤሌ ዴራ ዔሩዋዖ ዻቢንቲ ጎሜ ማዼቴ፤ ሃሣ ናንጊና ናንጋ ጎዳ ዓይሤ ዓይሢፃፓ ፔቴ ፓጪሴቴ፥ ዬያ ዴሮም ዻቢንታ ዔርቲባኣያ ማዔቴያ ዔያታ ዻቢንቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ዴራ ዬያ ዻቢንቶ ዔሬ ዎዶና ኔጉዋዖ ጎሜ ዛላ ዒንጊንታ ዒንጊሢ ማዓ፥ ፔቴ ዚያ ጌማይ ዔኪ ሙኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቤርቶ ዛላ ዔቂሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ዬካፓ ዴሮኮ ዶንዛ ፔኤኮ ኩጮ ጌሜ ቶኦካ ጌሤም ናንጊና ናንጋ ጎዳ ቤርቶይዳ ዬይ ባኣሢ ሹኪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ቄኤሶ ቢያኮ ሱኡጋሢ ጌሜ ሱጉፃፓ ዻካ ዔኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጌሎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ጋራ ጎኦቦና ዓፒሎኮ ቤርቶ ዛላ ዔቂ ፔ ኬኤሎና ሱጉፃፓ ዔኪ ዔኪ ላንካይ ማይንቲ ናንጊና ናንጋ ጎዳ ቤርታ ዉፁርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ሃሣ ዻካ ሱጉሢ ዔኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዑንጆ ጩቢሶሢኮ ዖይዶ ዛሎይዳ ዓኣ ዻንኮንሢ ናንጊና ናንጋ ጎዳ ቤርታ ቲሽኮንጎ፤ ዬካፓ ዓቴ ሱጉፆ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቤርቶ ዛላ ዓኣ ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞ ዴማ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ዬካፓ ዬያ ጌሜኮ ማሎ ቢያ ዔኪ ሚቺ ዒንጎ ቤዞይዳ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ጎሞ ዛሎ ቤርታ ዒንጊንቴ ጌሜይዳ ማዺንቴ ጎይፆማ ዬያ ጌሜያ ዒማይዶንጎ፤ ዬያይዲ ቄኤሳሢ ዴሮኮ ጎሞ ዛሎ ዒንጌም ዴሮኮ ጎማ ጌኤሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ዬካፓ ጌሜ ጉርዶኮ ዙሎ ኬሲ፥ ቤርታኣ ጌሜ ሚቼ ጎይፆማ ዬያኣ ሚቾንጎ፤ ዬይ ዴሮኮ ጎሞ ጌኤሻያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«ዴሬኮ ዓርና ማዒ ዔኪ ዓኣዻ ፔቴ ዓሲ ዔሩዋዖ ዻቢንቲ ጎሜ ማዼቴ፥ ናንጊና ናንጋ ጎዳ ዓይሤ ባኮይዳፓኣ ፔቴ ባኣዚ ፓጪሲ ጴዼቴ ዒዚ ዻቤያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ዒዚ ዻቢንቶ ፔኤሲ ዔሬቴ ኔጉዋዖ ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ኮላይ ፔኤኮ ጎሞ ጌኤሻንዳ ዒንጎ ዒንጊሢ ማሂ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ዬካፓ ፔኤኮ ኩጮ ኮሌኮ ቶኦካ ጌሢ፥ ሚቺ ዒንጎ ቤዞኮ ኬዶ ዛላ ሚቺ ዒንጎ ቆልማ ሹኪንታ ቤዛ ናንጊና ናንጋ ጎዳ ቤርታ ሹኮንጎ፤ ዬይ ጎሞ ጌኤሻ ዒንጊሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ቄኤሳሢ ኮሌኮ ሱጉፆይዳፓ ኬኤላና ዻካ ዔኪ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛሎይዳ ዓኣ፥ ዻንኮ ቲሽኮንጎ፤ ዬካፓ ዓቴ ሱጉፆ ሚቺ ዒንጎ ቤዞኮ ዴማ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ፔቱሞና ዒንጊንታ ዒንጊፆ ሚቼ ጎይፆ ማሎ ጉቤ ሚቺ ዒንጎ ቤዛ ሚቾንጎ፤ ቄኤሳሢ ዬያይዲ፥ ዬያ ዓሢኮ ጎሞ ዛሎ ዒንጎንጎ፤ ዓሢኮዋ ጎማ ጌኤሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«ዴሮ ባኣካፓ ፔቴ ዓሲ ዔሩዋዖ ዻቢንቲ ጎሜ ማዼቴ፤ ሃሣ ናንጊና ናንጋ ጎዳኮዋ ዓይሢፆይዳፓ ፔቴ ፓጪሴያ ማዔቴ ዬይ ዓሢ ዻቢንቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ዒዚ ዻቢንቴያ ማዔሢ ዔዔራዖ ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ዒንዴ ዋኣሪ ጎሞ ዛሎ ዒንጎ ባኣዚ ማሂ ዔኪ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ዬካፓ ፔኤኮ ኩጮ ዒ ዔኪ ሙኬ ዋኣሬሎ ቶኦካ ጌሢ፥ ሚቺ ዒንጎ ቤዞኮ ኬዶ ዛላ ሚቺ ዒንጎ ቆልማ ሹኪንታ ቤዛ ሹኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ዬያይዴስካፓ ቄኤሳሢ ዋኣሬሎኮ ሱጉፃፓ ዻካ ኬኤላና ዔኪ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛላ ዓኣ፥ ዻንኮ ቲሽኮንጎ፤ ዬካፓ ዓቴ ሱጉፆ ሚቺ ዒንጎ ቤዞኮ ዴማ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ፔቱሞና ዒንጎ ቆልሞይዳፓ ዔኪንቴ ጎይፆ ዋኣሬሎ ማሎዋ ዒማይዲ ኬሶንጎ፤ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳንዳጉዲ ቄኤሳሢ ሚቺ ዒንጎ ቤዛ ሚቾንጎ፤ ዬያይዲ ዬያ ዓሢኮ ጎሞ ዛሎ ዒንጊንታ ዒንጊፆ ዒንጎንጎ፤ ዬያ ዓሢኮዋ ጎማ ዓቶም ጌይንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«ፔቴ ዓሲ ጎሞ ዛሎ ማራናይ ዒንጋያ ማዔቴ ቦሂሳ ባኣዚባኣ፥ ዒንዴ ማራይ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ዬይ ዓሢ ዬኖ ማራዔሎኮ ቶኦካ ኩጮ ጌሢ፥ ሚቺ ዒንጎ ቤዞኮ ኬዶ ዛላ ሚቺ ዒንጎ ቆልሞ ሹኮ ቤዛ ሹኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ቄኤሳሢ ማራዖ ሱጉፃፓ ኬኤላና ዻካ ዔኪ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛላ ዓኣ ዻንኮ ቲሽኮንጎ፤ ዬካፓ ዓቴ ሱጉፆ ቢያ ሚቺ ዒንጎ ቤዞኮ ዴማ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ዓሳ ፔቱሞና ዒንጌ ማራዖኮ ማሎ ኬሴ ጎይፆ ማሎ ቢያ ኬሶንጎ፤ ዬካፓ ቄኤሳሢ ሚቺ ዒንጎ ቤዞይዳ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓንዳጉዲ ሚቾንጎ፤ ዬያይዲ ዓሢኮ ጎሞ ዛሎ ዒንጎ ባኮ ዒንጎንጎ፤ ዬያ ዓሢኮ ጎማ ጌኤሽካንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ናንጊና ናንጋ ጎዳ ሃሣ ኬኤዛዖ፦ «ፔቴ ዓሲ ዎጌ ዎጊንታ ቤሲዳ ማርካቶ ማርካዻንዳጉዲ ዔኤሊፃ ሄሌንቴ ዒ ዛጌ ባኮና ዔራ ባኮ ዛሎ ማርካዺፆ ዒፂ ሃሼቴ ዻቢንቴያ ማዒ ዖኦጪንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«ፔቴ ዓሲ ዔሩዋዖ ዓይጎ ባኣዚያ ማዖም ዳምቦ ጎይፆና ቄፄ ማዔ ባኣዚ ጌይፃ፦ ካይዚ ቦዖታቴያ ዓሲ ቆሌ ቆሎኮ ሃሣ ሳዓና ጎቺንቲ ሃንታ ቦዖኮ ሃይቄ ሌሲ ካኣሜቴ ዬይ ዓሢ ዒኢቲ፥ ዻቤያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«ፔቴ ዓሲ ዔሩዋዖ ዓሲ ዑስካፓ ሾኦታ ዓይጎ ባኣዚያ ማዖም ዒኢሳ ባኣዚ ሄሌቴ፥ ዒዚ ዻቤያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«ፔቴ ዓሲ ፑርቱሞም ማዔቴያ ኮሹሞም፥ ዓይጎ ባኣዚሮዋ ማዖም ማሊ ዔኩዋዖ ናኣቢ ናኣቤቴ ዒ ማዼ ማዻ ዻቢንቲ ዒዛም ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«ፔቴ ዓሲ ዬንሢዳፓ ፔቴማ ማዺ ዻቢንቴቴ ዎማ ማዺ ዻቤቴያ ኬኤዚ ቡኡፃንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ዒ ዻቤ ዻቢንቶ ዛሎሮ ዴንዲ ዒንዴ ማራይታቴያ ዋኣሪ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ማሂ ዔኪ ሙኮንጎ፤ ዬካፓ ቄኤሳሢ ዬያ ዓሢኮ ጎሞ ዛሎ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሹኪ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«ፔቴ ዓሲ ማራይ ማዔቴያ ዋኣሪ ዒንጋኒ ዳንዳዒባኣቴ ላምዖ ዶኦሌ ሃንጎ ላምዖ ኪሬ፤ ፔቴማ ጎሞ ዛሎ ዒንጊንታያ ማሂ፥ ላምዓሳማ ሚቺ ዒንጎ ዒንጊሢ ማሂ ናንጊና ናንጋ ጎዳም ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ዒዚ ዬንሢ ዔኪ ሙኪ ቄኤሳሢም ዒንጎንጎ፤ ዬካፓ ቄኤሳሢ ላምዖ ካፖንሢ ፔቴማኮ ቶኦኮ ቲቁዋዖ ዺዺ ሜንሢ ዻቢንቲኮ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ዬያ ሱጉፆይዳፓ ዻካ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ዛላ ፑጮንጎ፤ ዓቴ ሱጉፆ ሚቺ ዒንጎ ቤዞኮ ዴማ ዋሆንጎ፤ ዬይ ጎሞ ዛሎ ዒንጊንታ ዒንጊሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ቄኤሳሢ፥ ሃንጎ ካፖማ ዎጋ ዓይሣ ጎይፆ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ዬያይዲ ዓሢኮ ጎሞ ዛሎ ዒንጊንታ ዒንጊፆ ዒንጎንጎ፤ ዻቤ ዓሢኮዋ ጎማ ጌኤሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«ዬይ ዓሢ ላምዖ ዶኦሎንሢና ላምዖ ኪሮንሢ ዔኪ ዒንጋኒ ዳንዳዒባኣያታቴ ፔቴ ኪሎ ማዓንዳ ሺኢቺ ዺኢሊ ዒ ማዼ ጎሞ ዛሎ ዒንጊንታያ ማሂ ዔኪ ሙኮንጎ፤ ዬይ ጎሜ ዛላ ዒንጊንቴያ ማዔሢሮ ዛይቴታቴያ ዑንጄ ጊዳ ዋሆፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ዬካፓ ዔኪ ሙኪ ቄኤሳሢም ዒንጎንጎ፤ ቄኤሳሢ ዺኢሎይዳፓ ሾኦፓና ዔኪ ቢያሢ ናንጊና ናንጋ ጎዳም ዒንጊንቴያ ማዒፆ ዔርዛኒ ሙኡዚ ዒንጊሢ ማዒ ዒንጊንታ ዒንጊፆና ዎላ ሚቺ ዒንጎ ቤዞይዳ ናንጊና ናንጋ ጎዳም ታሚና ሚቾንጎ፤ ዬይ ጎሞ ዛሎ ዒንጊንቴ ዒንጊሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ዓሢ ዬንሢዳፓ ፔቴማ ዻቢ ጎሜ ማዼቴ ቄኤሳሢ ዬያይዲ ጎሞ ዛሎ ዒንጊንታ ዒንጊፆ ዒንጌም፥ ጎማ ዓሢኮ ዓቶም ጌይንታንዳኔ፤ ዓቴ ዺኢላ ሃኣኮ ዒንጊፃ ማዺንታ ጎይፆ ቄኤሳሢሮ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ናንጊና ናንጋ ጎዳ ሙሴም ሃካፓ ሊካ ዓኣ ዳምቦ ኬኤዜኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«ዓይጎ ዓሲያ ማዖም ናንጊና ናንጋ ጎዳም ዱማዼ ዒንጊሢ ዒንጎንዶንቴ ዔሩዋዖ ሃሺ ጎሜ ማዼቴ ዻቤ ዻቢንቶ ዛሎ ጪጊንታ ጋሌ ማሂ፥ ቆልሞ ባኣካፓ ዓዴ ማራይ ናንጊና ናንጋ ጎዳም ሺኢሾንጎ፤ ሃንጎ ዬማ ቆልሞማ ቄኤሳ ‹ያዺ ኬሳንዳኔ› ጌዔ ጎይፆና ሚኢሼ ዒዚ ጪጎንጎ፤ ዬይ ዻቢንቶኮ ዒንጊንቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ፆኦሲም ዱማዼ ባኮኮ ዒዚ ዒንጋንዳዖ ፓጪሴ ቤዞ ኩንሦንጎ፤ ጌይፃ፦ ዎንዴ ዒንጊንታንዳሢዳ ዶንጎ ኩቺፓ ፔቴ ማዓያ ቃሲ ዔኪ ሙኪ ቄኤሳሢም ዒንጎንጎ፤ ቄኤሳሢ ዬያ ባኮ ማራዓሢና ዎላ ዻቢንቶ ዛሎ ዒንጊንታ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ዓሢኮዋ ጎማ ጌኤሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«ፔቴ ዓሲ ዔሩዋዖ ናንጊና ናንጋ ጎዳ ዓይሤ ዓይሢፆይዳፓ ፔቴ ፓጪሴቴ ዬይ ዓሢ ዻቢንቴያ ማዒ ዖኦጪንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ዒዚ ፔኤኮ ቆልሞ ባኣካፓ ቦሂሳ ባኣዚባኣ ዓዴ ማራይ ዻቢንቶ ዛሎ ጪጎ ዒንጊሢ ማሂ ቄኤሳሢም ዔኪ ሙኮንጎ፤ ዬይ ሻንቺንቲ ኬሳንዳ ሚኢሻ ‹ያዺ ኬሳንዳኔ› ጌይንቴ ጎይፆ ሚኢሼ ማዖም፤ ዬይ ዓሢ ዔሩዋኣዖ ዻቤ ዻቢንቶ ዛሎ ቄኤሳሢ፥ ዬያ ዒንጊንቴ ባኮ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሾንጎ፤ ዬያ ዓሢኮዋ ጎማ ጌኤሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ዓሢ ናንጊና ናንጋ ጎዳም ዋይዞ ዒፂ ዻቤ ዻቢንቶ ጌኤሻ ዒንጊሢ ዬይ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ናንጊና ናንጋ ጎዳ ሃሣ ሙሴም ሃካፓ ሊካ ዓኣ ዳምቦ ኬኤዜኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«ዓይጎ ዓሲያ ማዖም ዓሲ ኮርካፓ ታልዔ ባኣዚ፤ ሃሣ ጊንሣ ዒዛ ኮራ ጌሦና ባኣዚ ‹ታ ዔሩዋሴ› ጌይ ማሂ ዒንጎ ዒፂ፥ ጎሜ ማዺ ናንጊና ናንጋ ጎዳም ጉሙርቱዋያ ማዔቴ፥ ሃሣ ዓሲ ባኣዚ ጌሺ ቡሪ ዔኬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ዬያጉዲ ሃሣ ባይቄ ባኣዚ ዴንቂ ዔካዖ ‹ታ ዴንቂባኣሴ› ጌይ ሉኡዙሞና ጫኣቂ፤ ዓሲ ማዻ ዬያጉዴ ጎሞፓ ፔቴ ማዺ ዻቢንቴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ዓይጎ ዓሲታቴያ ዬያይዴቴ ዒዚ ዉኡቄ ባኮ፥ ጌሺ ቡሪ ዔኬ ባኮ፥ ማዒባኣ ካራና ዓሲሮ ዔኬ ባኮ፥ ዒዛ ኮራ ጌሦና ባኮ ዒ ዔኬሢ፥ ዓሲኮ ባይቄያታንቴ ዒ ዴንቂ ዔኬ ባኮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ሉኡዙሞና ዒ ጫኣቂ ዔኬ ባኮ ቢያ ማሆንጎ፤ ሃሣ ዒ ዻቢንቶ ዛሎ ናንጊና ናንጋ ጎዳም ዒንጋ ዎዶና ዒ ዔኬ ባኮኮ ዶንጎይዳፓ ፔቴ ኩቺ ማዓያ ቃሲ ዔቦ ዓዶም ማሂ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ዒ ዻቤ ዻቢንቶኮ ጋሎ ጪጎ ማዓንዳጉዲ ቆልማፓ ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ዓዴ ማራይ ዒንጎ ባኣዚ ማሂ ናንጊና ናንጋ ጎዳም ዔኪ ሙኮንጎ፤ ዬያ ዔኪ ሙኪ ቄኤሳሢም ዒንጎንጎ፤ ዬይ ሻንቺንቲ ኬሳንዳ ሚኢሻ ‹ያዺ ኬሳንዳኔ› ጌይንታ ጎይፆ ሚኢሼ ማዖም። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ቄኤሳሢ ዬያ ዓሢኮ ጎሞ ዛሎ ዒንጎ ባኣዚ ማሂ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሾንጎ፤ ዒዛ ዻቢንቴያ ማሄ ጎማኣ ጌኤሽካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ናንጊና ናንጋ ጎዳ ሃሣ ሂዚ ጌይ ሙሴ ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«ዓኣሮኔና ዒዛኮ ናኣቶናም ሚቺ ዒንጎ ዒንጊፆ ዳምቦ ዛሎ ኔ ኬኤዛንዳሢ ያዺኬ፤ ሚቺ ዒንጎ ባካ ዋንቶ ጉቤ ሚቺ ዒንጎ ቤዞይዳ ማዔም ታማ ዔኤቴ ጎይሣ ዎርቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ቄኤሳሢ ሚዛጶ ሱኡፖና ኮሺንቴ ቃሚሾንታ ቆንፆዋ ማይንቲ ቱኡቴስካፓ ሚቺ ዒንጎ ቤዞይዳ ሚቺንቴ ቢዲንፆ ዓኣሢ ዔኪ ሚቺ ዒንጎ ቤዞኮ ኮይላ ላኣሎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ዬካፓ ዓፒሎ ኬሲ፥ ሜሌ ማኣዖ ማይንቲጋፓ ዬያ ዲቢንፆ ዔኪ ጉርዶኮ ዙላ ዓኣ ካኣዦ ዳምቦና ጌኤሺ ማዔ ቤዛ ላኣሎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ሚቺ ዒንጎ ቤዛ ዓኣ ታማ ቢያ ዎዴ ሃይቁዋዖ ዔኤቲ ዴዖንጎ፤ ቄኤሳሢ ጉቴ ጉቴ ሃንፂሎ ታማ ዓጎንጎ፤ ዬያ ታሞይዳ ሚቺ ዒንጎ ባኮ ጊኢጊሺ ጌሢ፥ ፔቱሞና ዒንጎ ባኮኮ ማሎ ዒኢካ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ዬይ ታማ ቢያ ዎዴ ሃይቁዋዖ ሚቺ ዒንጎ ቤዞይዳ ዔኤቶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«ሃኣኮ ዒንጊሢ ዛላ ኬሲንቴ ዳምቦ ጎይፃ ያዺኬ፦ ዓኣሮኔ ፃጳፓ ማዔ ቄኤሳ ሃኣኮ ዒንጊፆ ሚቺ ዒንጎ ቤዞኮ ቤርቶ ዛላ ዔኪ ሙኪ ናንጊና ናንጋ ጎዳ ቤርታ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ዬካፓ ቄኤሳሢ ዛይቶና ዲርኪንቴ ዺኢላፓ ፔቴ ሾኦፓ ዔኪ፤ ሃሣ ዬያ ሃኣኮ ዒንጊፆይዳ ዓኣ ዑንጆ ጉቤ ዔኪ ፆኦሲም ዒንጊንቴያ ማዒፆ ዔርዛኒ ሚቺ ዒንጎ ቤዞይዳ ሚቾንጎ፤ ዬያኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳ ዒንጊሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","ዓቴ ባኮ ቄኤሳሢ ሙዖንጎ፤ ዬያ ሙኑቃ ፃኣዛ ጊዳ ጌልዚባኣዖ ላኣዳ ላኣዲ ዓፒሎና ማዢንቴ፥ ታኣም ዱማዼ ማኣሮኮ ቤርቶ ዛላ ቃምዖ ጋራ ሙዖንጎ፤ ዓይጎሮ ጌዔቴ ዬያ ሙዖ ዒንጊፆ ሚቺ ዒንጎ ዒንጊፆና ዎላ ቄኤሶሮ ማዓንዳጉዲ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዓይሤኔ፤ ዬይ ጎሞ ዛሎ ዒንጎ ባኮንታ ዻቢንቶ ዛሎ ጪጎ ባኮጉዲ ሚርጌና ታኣም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ሙካ ዎዶ ቢያይዳ ዓኣሮኔ ዜርፃፓ ሾይንቴ ዓቲንቄ ቢያ ታኣም ዒንጊንታ ባኮይዳፓ ዓቴሢ ዒዛሮታሢሮ ሙዓኒ ዳንዳዓኔ፤ ዓይጎዋ ማዖም ዬያ ባኮ ካኣማ ባኣዚ ቢያ ፆኦሲም ዱማዼያ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ናንጊና ናንጋ ጎዳ ሃሣ ሂዚ ጌይ ሙሴ ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«ቄኤሳ ዶኦሪንታ ኬሎና ቢያ ዎዴ ሃኣኮ ዒንጊፃ ዒንጊንታሢና ዎላ ሄኮ ማዔ ፔቴ ኪሎ ጊራኣሜ ማዓ ሺኢቺ ዺኢሊ ዔኪ ሙኮንጎ፤ ዬያኮ ዛላ ጉቴ፥ ዛላ ዒባኒ ታኣም ዒንጎያ ማዒ ሺኢኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ጊኢጊሺ ዛይቴና ዲርኪ ቦኦቆይዳ ላኣዲንቶንጎ፤ ዬካፓ ዬያ ሃኣኮ ዒንጊፆ ቡንፂ ሳዋ ታና ዎዛሳያ ማዓንዳጉዲ ሃኣኮ ዒንጊሢ ማሂ ዒንጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ሙካ ዎዶ ቢያይዳ ቄኤሴ ማዒ ማዻ፥ ዓኣሮኔ ዜርፃ ቢያ ዬያ ዳምቦ ኩንሦንጎ፤ ዬይ ታኣም ዒንጊንታ ሚቺ ዒንጎ ዒንጊሢ ማዒ ጉቤ ሚቺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ቄኤሳሢ ዒንጋ ሃኣኮ ዒንጊፆይዳፓ ሙይንታይ ባኣያ ማዒ ቢያ ሚቺንታንዳያ ኮይሳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ናንጊና ናንጋ ጎዳ ሂዚ ጌይ ሙሴ ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«ጎሞ ዛሎ ሚቺ ዒንጎ ዒንጊፆ ዛሎኮ ዓኣሮኔ ናኣቶም ኔ ኬኤዛንዳ ዳምባ ያዺኬ፤ ሚቺ ዒንጎ ቆልማ ሹኪንታ፥ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞኮ ኬዶ ዛላ ጎሞ ዛሎ ዒንጊንታ ቆልማ ናንጊና ናንጋ ጎዳ ቤርታ ሹኪንቶንጎ፤ ዬይ ሚርጌና ታኣም ዱማዼያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ቆልሞ ሺኢሺ ዒንጋ ቄኤሳሢ ዬያ ዓሽኮ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቃምዖ ጋራ ታኣም ዱማዼ ቤዞይዳ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ዓሲታቴያ ዓይጎ ባኣዚያ ማዖም ዬያ ዓሽኮ ካኣሜቴ ዬይ ታኣም ዱማዼያ ማዓንዳኔ፤ ሃሣ ዓይጎ ዓፒላኣ ማዖም ዬይ ሱጉፃ ካኣሜቴ ታኣም ዱማዼ ቤዞይዳ ማስኪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ዓሽካ ካሢንቴሢ ዓይጎ ዖቲዳታቴያ ዬኖ ዖቶ ዎዻንዳያ ኮይሳኔ፤ ጋዓንቴ ዓሽካ ካሢንቴሢ ዓንጊ ዖቲዳ ማዔቴ ኮሺ ዶርቺ ዋኣሢና ማስኪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ቄኤሶ ማኣሮይዳፓ ማዔ፥ ዓቲንቄ ቢያ ዬያ ሙዓኒ ዳንዳዓኔ፤ ዬይ ሚርጌና ታኣም ዱማዼ ዒንጊሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ጋዓንቴ ሱጉፃ ጎሞ ጌኤሺፆ ዳምቦሮ ዓፒሎና ማዢንቴ፥ ታኣም ዱማዼ ማኣሮ ዔኪ ጌሊንቴያ ማዔቴ ዬይ ዓሽካ ሙይንቱዋዖ ቢያ ታሚና ሚቺንቶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ናንጊና ናንጋ ጎዳ ሃሣ ኬኤዛዖ፦ «ሚርጌና ታኣም ዱማዼያ ማዔሢሮ ዻቢንቶ ዛሎ ጪጋ ማሂ ዒንጎ ዒንጊፆ ጎይፃ ያዺ ማዖንጎ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ዻቢንቶ ዛሎ ዒንጊንታ ቆልማ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞኮ ኬዶ ዛላ ዓኣ ቤዞይዳ ሹኪንቶንጎ፤ ሱጉፃ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛሎ ጎኦቦይዳ ፑጪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ዬያኮ ማላ ቢያ ሹኪንቲ ዔውቲ ሺኢኮንጎ፤ ዬይያኣ፦ ዑንኮ ማላ፥ ጎጶ ባኮ ካንቄ ሃኣቦ ማላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ጳላሢና ዒኢካ ዓኣ ማላ፤ ዬያጉዲ ሃሣ ማዮኮ ሻኣዣዻ ቤዛኣ ሺኢሺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ቄኤሳሢ ናንጊና ናንጋ ጎዳም ሚቺ ዒንጎ ዒንጊሢ ማዓንዳጉዲ ሚቺ ዒንጎ ቤዞይዳ ጌሢ ዬያ ሚቾንጎ፤ ዬይ ዻቢንቲ ዛላ ዒንጊንታ ዒንጊሢ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ቄኤሶ ፃጳፓ ማዔ ዓቲንቃ ቢያ ዬያ ዓሽኮ ሙዓኒ ዳንዳዓኔ፤ ዬይ ሚርጌና ታኣም ዱማዼያታሢሮ ታኣም ዱማዼ ቤዛ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«ጎሞ ዛሎ ዒንጊንታ ዒንጊፆና ዻቢንቶ ዛሎ ጪጋ ማሂ ዒንጎ ዒንጊፆኮ ዳምባ ፔቴኬ፤ ዬይያ፦ ዒንጊንቴ ባካ ዒንጎ ዳምቦ ኩንሤ ቄኤሳሢም ዒንጊንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ዓይጎ ዓሲማኣ ማዖም ሚቺ ዒንጎ ዒንጊሢ ማዒ ዒንጊንቴ ቆልሞኮ ዒልዓ ሹኪንቲ ዬኖ ዒንጊፆ ፆኦሲም ዒንጌ ቄኤሳሢም ዒንጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ቦኦቆይዳ ጉኡፒ ላኣዲንቴ ላኣዳ፥ ዖቲዳ ካሢንቴያ፥ ቦኦቆይዳ ጉሪ ላኣዶናያኣ ቢያ ዒንጎ ባኮ ፆኦሲም ዔኪ ሺኢሼ ቄኤሳሢም ዒንጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ዛይቶና ዲርኪ ጊኢጊሾናሢ ማዔቴያ ሜሌ ጉሪ ዒንጊንቴ ሃኣኮ ዒንጊፃ ዓኣሮኔ ፃጶ ማዔ፥ ቄኤሶም ቢያ ዒንጊንቴም ዔያታ ሄኮ ጊሽቲ ዔኮንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«ናንጊና ናንጋ ጎዳም ዒንጊንታ ፔቱሞና ዒንጎ ዒንጊፆኮ ዳምባ ያዺ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ፔቴ ዓሲ ፆኦሲም ጋላታሮ ዒንጋ ዒንጊሢ ማዔቴ ዒዚ ዒንጋ ቆልሞና ዎላ ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ፥ ዛይቴና ዲርኪ ሻኣዣሲ ላኣዶና ላኣዳ፥ ዛይቴና ዲርኮና ሺኢቺ ዺኢሊያ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ጋላቶሮ ዒንጊንታ ፔቱሞ ዒንጊፆና ዎላ ሙኑቃ ፃኣዛ ዋሂ ላኣዲንቴ ካሣ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ዱማ ዱማ ካሦኮ ቶኦካፓ ቶኦካፓ ፔቴ ፔቴ ዔኪ ናንጊና ናንጋ ጎዳም ዱማዼ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ዬይ ባካ ቆልሞ ሱጉፆ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ፑጬ፥ ቄኤሳሢም ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ዬይ ዒንጊንቴ ዓሽካ ዒዞ ኬሎ ሙይንቲ ጋጋፖንጎ፤ ዓቲ ዎርቆፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«ፔቴ ዓሲ ናኣቤ ናኣባ ኩሜሢሮ ጌይ፤ ሃሣ ፔ ማሊሢና ዔኪ ዒንጋያ ማዔቴ ዒንጊንቴ ኬሎ ሙይንቶንጎ፤ ዓቴሢ ዚሮ ጉቴ ቢያ ሙይንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ዬካፓ ዓቲ ሃይሣሳ ኬሎ ሄላንዳኣና ዴዔቴ ዓሽካ ታሚና ሚቺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ዓቴ ዓሽካ ሃይሣሳ ኬሎ ዎማይዲ ማዔቴያ ሙይንቴቴ ዬያ ዓሢኮ ዒንጊፆ ፆኦሲ ዔካያቱዋሴ፤ ዬይ ዒንጊፃኣ ዒንጊንቴያ ማዓዓኬ፤ ዬይ ዒኢቴ ባኣዚ ማዓንዳኔ፤ ዬያ ሙዔ ዓሢ ሜቶ ዔካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ዒኢቴ ባኣዚና ካኣሜ ዓሽካ ሚሚቺንቶንጎ፥ ሙይንቶፓ። «ሜሌ ዓሽኮ ጋዓንቴ ካኣዦ ዳምቦ ጎይፆና ጌኤሺ ማዔ ዓይጎ ዓሲያ ሙሙዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ጋዓንቴ ፔቴ ዓሲ ዳምቦ ጎይፆና ጌኤሺቱዋዖ ዬያ ሙዔቴ ፆኦሲ ዴሮ ባኣኮይዳ፥ ፆኦሲ ዓሲ ማዒ ፔቴታዖ ፓይዲንቶፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ዳምቦ ጎይፆና ጌኤሺ ማዒባኣ፥ ዓሲፓ ማዖም ቆልሞፓ ኬስካ ዒኢሳ ባኣዚ፤ ሃሣ ዓይጎዋ ዒኢሳ ባኣዚ ሄሌዖ ናንጊና ናንጋ ጎዳም ዒንጊንቴ፥ ፔቱሞና ዒንጎና ዒንጊፆኮ ዓሽኮ ሙዔቴ ዬይ ዓሢ ፆኦሲ ዴራፓ ዱማዺ ባባይቆንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ባይና ማራይና ዋኣሪናኮ ማሊ ሙይፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ጉሪ ሃይቄ ቆልሞንታ ቦዖ ዎዼ ቆልሞንታኮ ማላ ሜሌ ባኣዚ ማዺንቶንጎ፤ ዓሲ ሙሙዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ፆኦሲም ሚቺ ዒንጎያ ማሂ ዒንጊንቴ ቆልሞኮ ማሎ ሙዓ ዓይጎ ዓሲያ ፆኦሲ ዴሮ ባኣካፓ ባይቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ዒስራዔኤሌ ዓሳ ዓንኮ ቤስካኣ ማዖም ናንጋ ቤዞ ቢያይዳ ካፒሮታቴያ ቆልሞ ሱጉሢ ሙዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ዓይጎ ዓሲያ ማዖም ሱጉሢ ሙዓ ዓሲ ፆኦሲ ዴሮ ባኣካፓ ባይቆንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ናንጊና ናንጋ ጎዳ ሃሣ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ዓይጎ ዓሲያ ማዖም ፔቱሞና ዒንጎ ዒንጊፆ ፆኦሲም ዒንጋቴ ዬያይዳፓ ፓቂ ፔ ዛሎ ዒንጎ ባኣዚ ማሂ ናንጊና ናንጋ ጎዳም ዔኪ ሺኢኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ዬያ ሚቺ ዒንጎ ዒንጊሢ ማሂ ፆኦሲም ፔ ኩቻ ዒንጎንጎ፤ ማሎ ዚኢሮና ዎላ ሺኢሺ፥ ዚኢሮዋ ዡጊ ናንጊና ናንጋ ጎዳም ዒንጊሢ ማሂ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ቄኤሳሢ ዬያ ማሎ ሚቺ ዒንጎ ቤዛ ሚቾንጎ፤ ዚኢሮ ጋዓንቴ ቄኤሶም ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ዬኖ ዒንጊፆኮ ሚዛቆ ዛሎ ላባዎ ዬያ ቄኤሳሢም ዒንጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ሚዛቆ ዛሎ ላባኣ ሱጉፆንታ ማሎንታ ዔኪ ፔቱሞ ዒንጊፆ ማሂ ፆኦሲም ሺኢሼ ቄኤሳሢ ዛላ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ዡጊንቴ ዚኢሮና ዔኪ ሺኢሾና ላባዎ ዒስራዔኤሌ ዴራ ዒንጌ ዒንጊፆፓ ዔኪ፥ ቄኤሳሢ ዓኣሮኔና ዒዛኮ ናኣቶናም ናንጊና ዔያቶሮ ማዓንዳጉዲ ታ ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","«ዓኣሮኔና ናኣቶና ቄኤሴ ማዓንዳጉዲ ፆኦሲ ዶኦሬ ኬሎና ፆኦሲም ዒንጊንታ ሚቺ ዒንጎ ዒንጊፆኮ ቄኤሶ ዛሎ ማዓንዳጉዲ ዱማሶናሢ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ዬኖ ኬሎና ዬያ ዒንጊፆይዳፓ ቄኤሶ ሄላ ዛላ ዔያቶም ዒንጊንታንዳጉዲ ናንጊና ናንጋ ጎዳ ዓይሤኔ፤ ዬይ፦ ኬስካ ዎዶ ቢያይዳ ዒስራዔኤሌ ዓሳ ኩንሣኒ ኮይሳ ዳምቤኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ዓካሪ፦ ሚቺ ዒንጎ ዒንጊፆ ዳምባ፥ ሃኣኮ ዒንጎሢሲ፥ ጎሞ ጌኤሻኒ ዒንጎ ዒንጊፆሲ፥ ዻቢንቶ ዛሎ ዒንጎ ዒንጊፆሲ፥ ቄኤሶ ዶኦሪፆም ጌይ ዒንጎ ዒንጊፆሲንታ ፔቱሞና ዒንጎ ዒንጊፆኮ ዳምባ ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ዒስራዔኤሌ ዴራ ፆኦሲም ዒንጎ ባኮ ዒንጋንዳጉዲ ዓሲ ናንጉዋ ዳውሎኮ ሲና ዹኮ ኮይላ ዔያቶም ኬኤዚንቴያና ናንጊና ናንጋ ጎዳ ሙሴም ዬያ ዳምቦ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«ዓኣሮኔንታ ዒዛኮ ዓቲንቆ ናኣቶንታ ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮ ካሮ ዔኪ ዓኣዼ፤ ዒማና ቄኤሳ ማይንታ ዓፒላ፥ ቲዦ ዛይታ፥ ጎሜ ጌኤሻኒ ዒንጎ ጌሜ፥ ላምዖ ዓዶ ማራታ፥ ሙኑቆ ፃኣዛ ጌሊባኣ ላኣዳ ዓኣ ሌኤማቶዋ ዔኪ ሺኢሼ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ሃሣ ዒስራዔኤሌ ዴሮ ቢያ ፔቴይዳ ዔኤሊ ዒኢካ ቡኩሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ሙሴ ማዼኔ፤ ዴራኣ ሙኪ ቡካዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ዒዚ ዔያቶም፦ «ሃሢ ታ ዒንሢኮ ቤርታ ማዻንቴ ዒንሢ ዛጋንዳሢ ናንጊና ናንጋ ጎዳ ታና ዓይሤ ባኮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ሙሴ ዓኣሮኔንታ ዒዛኮ ዓቲንቆ ናኣቶንታ ዓሶ ቤርቶ ሺኢሺ፥ ዋኣፆና ማስቲፆ ዳምቦ ኩንሣኒ ማስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ዬያይዴስካፓ ቄኤሳ ማኣዓ ዖዶዞ ቃሚሾ ዓኣሮኔ ማይሲ፥ ዼኤፒ ኮኦቴያ ማይሲ፥ ኬርና ቱኮ ባኮዋ ቱኡሲ፥ ዔፑዴ ጌይንታ ባቃና ዓጎ ባኮዋ ዓጊ፥ ዱማ ጎይሢና ሚዛጲሲ ኮሾና ቃልሾና ዬያ ዔፑዶ ዓይሢ ኬርና ቱኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ዔፑዶኮ ጊዳ፦ ዳዶ ቡራሾ ሲኪ፥ ዑሪሜና ቱሚሜ ጌይንታ ባኮንሢ ጋራ ዓጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ሃሣ ቶኦኮይዳ ዓፒላ ማሬኔ፤ ዬያኮ ባሊቶ ዛሎይዳ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆና ዎርቄና ኮሺንቴ ፆኦሲም ዱማዼያ ማዒፆ ዔርዛ ማላታ ማዔ፥ ቦንቺሳ ቆኦቦ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ዬካፓ ሙሴ ቲዦ ዛይቶ ዔኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮንታ ጋራ ዓኣ ባኮዋ ቲሽኬኔ፤ ዬያይዲ ቢያ ባኮ ፆኦሲ ማዾም ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ቲዦ ዛይቶይዳፓ ዻካ ዔኪ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞ ዑፃ ላንካይ ማይንቲ ፑጬኔ፤ ዬኖ ጎይፆ ፆኦሲ ማዾም ዱማዼያ ማዓንዳጉዲ ሚቺ ዒንጎ ቤዞና ዒኢካ ዓኣ፥ ማዺንቶ ሜሆ ቢያሢ፤ ሃሣ ዋኣፆ ማስቶ ሳኣኖንታ ጌሦ ቤዞዋ ቢያ ፑጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ቲዦ ዛይቶ ዓኣሮኔ ቶኦካ ዋሂ፥ ዒዚ ፆኦሲ ማዾም ዱማዻንዳጉዲ ቲሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ዬካፓ ሙሴ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆና ዓኣሮኔኮ ዓቲንቆ ናኣቶ ዓሶ ቤርቶ ሺኢሺ፥ ቄኤሳ ማይንታ ዖዶዞ ቃሚሾ ማይሲ፥ ኬርኖ ቱኮ ቃልሾ ቱኪ፥ ቶኦኮይዳኣ ዔያቶም ቆኦቦ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ዬካፓ ሙሴ ጎሞ ጌኤሻኒ ዒንጊንቴ ጌሜ ዔኪ ሙካዛ፥ ዓኣሮኔና ናኣቶና ጌሜኮ ቶኦኮይዳ ኩጮ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ዬያይዴስካፓ ሙሴ ጌሜ ሹካዖ ሱጉፆይዳፓ ኬኤላና ዔኪ ፆኦሲም ዱማዼያ ማዓንዳጉዲ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዖይዶ ዛላ ዓኣ ዻንኮ ቲሽኪ ጌኤሺ፥ ዓቴ ሱጉፆ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዴማ ዋሄኔ፤ ዬያይዲ ዒንጎ ባኮ ዒንጎ ቤዞ ፆኦሲም ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ሃሣ ዒዚ ጌሜኮ ጎጶ ባኮ ዑፃ ዓኣ ማሎ ቢያ፥ ማዮኮ ሻኣዣዻ ቤዞንታ ጳላሢያኣ ዒኢካ ዎላ ዓኣ ማሎና ቢያ ዔኪ ሚቺ ዒንጎ ቤዛ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ጌሜኮ ዒልዖ፥ ሃንጎ ዓሽኮ፥ ሩቁንቶንታ ሶኦኮዋ ዔኪ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ጉርዶኮ ዙላ ኬሲ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ዬካፓ ሙሴ ሚቺ ዒንጎም ጊኢጊሺንቴ ማራዓሢ ዔኪ ሙካዛ፥ ዓኣሮኔና ናኣቶና ማራዓሢኮ ቶኦካ ኩጮ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ዬያይዴስካፓ ሙሴ ማራዓሢ ሹኪ ሱጉፆ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛሎ ፑጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","ማራዓሢኮ ዓሽኮ ሜኤሎና ሜኤሎና ቲቂ፥ ጎጶ ባኮንታ ጊንፆ ቶኮንታ ዋኣሣ ማስኬኔ፤ ዬካፓ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ቶኦኮንታ ማሎንታ ማራዓሢኮ ዓቴ ዓሽኮዋ ቢያ ሚቺ ዒንጎ ቤዛ ሚቼኔ፤ ዬያ ሚቺ ዒንጎናሢኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳ ሙኡዚ ዒንጊሢ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ቄኤሶ ዶኦሪፆ ዛሎ ላሚ ዒንጊንታ ማራዓሢ ዔኪ ሙካዛ፥ ዓኣሮኔና ናኣቶና ኩጮ ማራዓሢኮ ቶኦካ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ዬካፓ ሙሴ ማራዓሢ ሹኪ ሱጉፃፓ ዻካ ዔኪ ዓኣሮኔኮ ሚዛቆ ዋዮ ቤርቶ፥ ሚዛቆ ኩጮና ቶኮናኮ ዶኦሞ ኬኤሎ ቲሽኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ሃሣ ዓኣሮኔኮ ናኣቶ ዓሶኮ ቤርቶ ዔኪ ሺኢሻዖ ሚዛቆ ዋዮ ቤርቶ፥ ሚዛቆ ኩጮና ቶኮናኮ ዶኦሞ ኬኤሎ ዔያቶኮ ቲሽኬኔ፤ ዬያይዲ ዓቴ ሱጉፆ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞኮ ዖይዶ ዛሎ ጎኦቦ ፑጬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ዬያይዴስካፓ ማላኣ፥ ዑንኮ ማላ፥ ጎጶ ባኮ ካንቂ ዓኣ ማሎ ቢያ፥ ማዮኮዋ ሻኣዣዻ ቤዞ፤ ጳላሢንታ ዒኢካ ዓኣ ማሎንታ ሚዛቆ ዛሎ ላባዎዋ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ፆኦሲም ዱማዼያ ማዔ፥ ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዶ ጌሦ ሌማቶይዳፓ ፔቴ ላኣዳ ዔኪ፤ ዬያጉዲ ሃሣ ዛይቶና ዲርኪ ላኣዶና ላኣዳ፥ ሻኣዣ ላኣዳኣ ዔኪ ማሎና ላባዎ ዓሽኮናኮ ዑፃ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ዬያ ሙዖ ቢያ ዔኪ ዓኣሮኔና ናኣቶናም ዒንጋዛ ዔያታ ዬያ ዡጊ፥ ናንጊና ናንጋ ጎዳም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ዬካፓ ሙሴ ካሦ ዔያቶ ኩጫፓ ዔኪ፥ ቄኤሶ ዶኦሪፆሮ ሚቺ ዒንጎ ባኮይዳ ቃሲ ጌሢ ሚቺ ዒንጎ ቤዛ ሚቼኔ፤ ዬያኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳ ሙኡዚ ዒንጊሢ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ዬያይዴስካፓ ሙሴ ዚኢሮ ዔኪ ዡጊ፥ ናንጊና ናንጋ ጎዳም ዒንጌኔ፤ ዬይ ቄኤሶ ዶኦሪፆሮ ዒንጎ ማራዖኮ ሙሴ ሄላ ቤዞኬ፤ ሙሴያ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ቢያ ባኮ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ሃሣ ሙሴ ቲዦ ዛይቶና ዒንጎ ባኮ ዒንጎ ቤዛ ዓኣ ሱጉፃፓኣ ዻካ ዔኪ ዓኣሮኔና ናኣቶናኮ ዑፃ፤ ጊንሣ ሃሣ ዔያቶኮዋ ዓፒሎይዳኣ ቢያ ፑጬኔ፤ ዬያይዲ ዒዚ ዔያቶንታ ዔያቶኮ ዓፒሎንታ ናንጊና ናንጋ ጎዳም ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ዬካፓ ሙሴ ዓኣሮኔና ናኣቶናም «ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ዓሽኮ ካሡዋቴ፤ ናንጊና ናንጋ ጎዳ ታኣም ዓይሢ ኬኤዜ ጎይፆ ቄኤሶ ዶኦሪፆሮ ዒንጎ ካሦ ጌሦ፥ ሌኤማቶ ጋራ ዓኣ ካሦና ዎላ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ዓቴ ዓሽኮ ማዔቴያ ላኣዶ ታሚና ሚቹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ዒንሢኮ ቄኤሶ ማሂ ዶኦሪፆ ዳምባ ማዺንቲ ኩማንዳሢ ላንካይ ኬሊዳታሢሮ ዬይ ማዺንቲ ጋፓንዳ፥ ላንካዎ ኬሎ ሄላንዳኣና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራፓ ዓኣዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ጎሞ ዒንሢኮ ጌኤሻኒ፥ ሃያ ኑ ሃኖ ማዼ ባኮ ኩንሣንዳጉዲ ናንጊና ናንጋ ጎዳ ኑና ዓይሤያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ዬያሮ ናንጊና ናንጋ ጎዳ ዓይሤ ባኮ ቢያ ማዺ ኩንሡዋቴ፤ ላንካዎ ኬሎዋ ጉቤ ዋንቴና ሮኦሪና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ዴዑዋቴ፤ ዬያ ዒንሢ ማዺባኣቴ ጋዓንቴ ሃይቃንዳኣኬ፤ ዬይ ቢያ ናንጊና ናንጋ ጎዳ ታና ዓይሤ ዎጌኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ዓኣሮኔንታ ናኣቶንታ ናንጊና ናንጋ ጎዳ ሙሴ ዛሎና ዔያቶ ዓይሤ ባኮ ቢያ ማዺ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ላንካይ ኬሊዳ ቄኤሶ ዶኦሪፆ ዳምባ ማዺንቲ ጋፔ ኬሎኮ ዚሮ ጉቴሎ ሙሴ ዓኣሮኔንታ ናኣቶንታ፤ ዬያጉዲ ሃሣ ዒስራዔኤሌ ዴሮኮዋ ሱኡጎ ዔኤሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ዒማና ዒዚ ዓኣሮኔም፦ «ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ፔቴ ዎፓናና ፔቴ ማራይ ዓዴና ዔኪ፤ ዎፓናሢ ጎሞ ጌኤሻኒ ዒንጊንታ ዒንጊሢ፥ ማራዓሢ ሚቺ ዒንጎ ዒንጊሢ ማሂ ናንጊና ናንጋ ጎዳም ሺኢሼ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ዒስራዔኤሌ ዴራ ጎሜ ጌኤሺሢም ዒንጎ ዒንጊሢ ማዓ ፔቴ ኮላይ፤ ሃሣ ዓይጌያ ቦሂሳ ባኣዚባኣ፥ ፔቴ ሌዔ ማዔ ጌማናይ፥ ፔቴ ሌዔ ማዔ ዓዴ ማራናይ ሚቺ ዒንጎ ዒንጊፆም ዔኪ ሙካንዳጉዲ ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ዬያጉዲ ሃሣ ፔቴ ዚያ ጌማናይ፥ ዓዴ ማራናይ፤ ፔቱሞና ዒንጎ ዒንጊፆም ዔኪ ሙኮንጎ፤ ዬንሢ ዛይቴና ዲርኪንቴ ሃኣኮ ዒንጊፆና ዎላ ማሂ ናንጊና ናንጋ ጎዳም ዔያታ ሺኢሾንጎ፤ ዬያ ቢያ ማዾንጎ፤ ዓይጎሮ ጌዔቴ ሃኖ ናንጊና ናንጋ ጎዳ ዒንሢም ፔጋዺ ጴዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ዔያታ ሙሴ ዓይሤ ባኮ ቢያ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዔኪ ሙኬኔ፤ ዴራ ቢያ ዒማና ናንጊና ናንጋ ጎዳ ዚጊ ካኣሽካኒ ዒኢካ ቡኪ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ዬካፓ ሙሴ ዔያቶም፦ «ዓኣፓ ዱካ፥ ናንጊና ናንጋ ጎዳኮ ቦንቾ ፖዓ፥ ዒንሢም ፔጋዺ ጴዻንዳሢሮ ዬያ ቢያ ማዻንዳጉዲ ዒዚ ዒንሢ ዓይሤኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ሃሣ ሙሴ ዓኣሮኔም፦ «ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞ ባንሢ ዶጪ፥ ኔ ጎሞንታ ዴሮ ጎሞዋ ጌኤሻኒ ጎሞ ዛሎ ዒንጎ ባኮንታ ሚቺ ዒንጎ ዒንጊፆዋ ፆኦሲም ሺኢሼ፤ ዬያ ዒንጊንታ ባኮ ዴሮኮ ጎሞ ጌኤሺሳኒ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ዒንጌ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ዬካፓ ዓኣሮኔ ፆኦሲም ዒንጎ ቤዞ ዓኣዻዖ ቤርታሲ ፔ ጎሞ ጌኤሻኒ ዒንጊንታ ዎፓናሢ ሹኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ዒዛኮ ናኣታ ሱጉፆ ዒዛም ዔኪ ሙካዛ፥ ዒዚ ሱጉፆ ኬኤሎና ዔኪ ዔኪ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞኮ ዖይዶ ዛላ ዓኣ፥ ዻንኮ ቲሽካዖ ዓቴ ሱጉፆ ዒንጎ ባኮ ዒንጎ ቤዞኮ ዴማ ዋሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ዬካፓ ማሎንታ ጳላሢንታ ማዮኮዋ ሻኣዣዻ ቤዞ ዔኪ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞይዳ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ዓሽኮና ዒልዖና ጋዓንቴ ጉርዶኮ ዙላ ኬሲ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ዬያይዴስካፓ ዓኣሮኔ ሚቺ ዒንጎ ዒንጊፆም ዔኪ ሺኢሾናሢ ሹካዛ፥ ዒዛኮ ናኣታ ሱጉፆ ዒዛም ዔኪ ሙኬም ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞኮ ዖይዶ ዛሎ ዒ ፑጬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ሃሣ ዒዛኮ ናኣታ ቶኦኮንታ ዓቴ ዓሽኮኮ ሜኤሎ ሜኤሎ ኬሲ ዔኪ ሙካዛ፥ ዓኣሮኔ ዬያ ቢያ ሚቺ ዒንጎ ቤዛ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ዬካፓ ሃሣ ጎጶ ባኮና ጊንፆ ቶኮ ዋኣሢና ማስካዖ፥ ሚቺ ዒንጎ ባኮኮ ዑፃ ጌሢ ዎላ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ዬያይዴስካፓ ዒዚ ዴሮ ዛሎ ዒንጎ ባኮ ሺኢሺ፥ ዓሶኮ ጎሞ ዛሎ ዒንጊንታ ኮሌ ቲቄኔ፤ ዬያኣ ቤርታ ዒ ፔ ጎሞ ዛሎሮ ማዼ ጎይፆ ማዺ ፆኦሲም ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ሃሣ ሚቺ ዒንጎ ዒንጊፆም ማዓ ቆልሞ ዳምቦ ጎይፆና ዔኪ ሙኪ ሹኪ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ሃኣኮ ዒንጊፆዋ ዔኪ ሙኪ፤ ዺኢሎይዳፓ ሾኦፓ ኩሙሢ ዑጪ ዔኪ፤ ጉቴ ጉቴ ዒንጊንታ ሚቺ ዒንጎ ዒንጊፆይዳ ቃሲ ሚቺ ዒንጎ ቤዛ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ጌሜና ዓዶ ማራዓሢና ሹኪ፥ ዴራ ፔቱሞና ዒንጋ ዒንጊሢ ማሂ ዒንጌም ዒዛኮ ናኣታ ሱጉፆ ዒዛም ዔኪ ሙኬኔ፤ ዬያ ሱጉፆ ዒዚ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛሎይዳ ፑጬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ዬካፓ ዒዚ ጌሜና ማራዓሢናኮ ማሎ ቢያ፤ ጌይፃ፦ ዑንኮ ማላ፥ ጎጶ ባኮ ካንቂ ዓኣ ሃኣባ፥ ጳላሢንታ ማዮኮዋ ሻኣዣዻ ቤዞዋ ቢያ ዔኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ላምዖ ቆልሞንሢኮ ዚኢሮይዳ ጌሤስካፓ ሚቺ ዒንጎ ቤዞይዳ ማሎ ሚቼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ዚኢሮንሢንታ ሚዛቆ ዛሎይዳ ዓኣ ጊንፆ ቶኮንሢ ሙሴ ጌዔ ጎይፆና ቄኤሶ ዛላ ማዓንዳጉዲ ዡጊ፥ ናንጊና ናንጋ ጎዳም ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ዓኣሮኔ ዬያ ባኮ ቢያ ዒንጊ ጋፒሴስካፓ ኩጮ ዴሮ ባንሢ ማሂ ዓንጃዖ፥ ሚቺ ዒንጎ ቤዛፓ ኬዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ዬካፓ ሙሴና ዓኣሮኔና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጌሊ ዒኢካፓ ኬስካዖ ዴሮ ዓንጄኔ፤ ዒማና ናንጊና ናንጋ ጎዳኮ ቦንቻ ፔጋዺ ጴዻ፥ ዓኣፓ ዱካ ፖዓ ዴሮ ቢያሢም ፖዒ ጴዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ናንጊና ናንጋ ጎዳ ኮሮ፥ ጫሪንጫፓ ታሚ ሙኪ ሚቺ ዒንጎ ቤዞይዳ ዓኣ፥ ዒንጎና ባኮንታ ማሎዋ ቢያ ሙዔኔ፤ ያኣዒ ማዓኣና ዴራ ቢያ ዬያ ዛጋዖ ዒላሺሢና ባሊቶ ሳዖ ሄሊሲ ዚጊ ፆኦሲ ካሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ናኣዳኣቤና ዓቢሁና ጌይንታ ላምዖ ዓኣሮኔ ናኣቶንሢ ፔኤኮ ታሞ ጩቢሾ ኩንዖይዳ ታሚ ቄንሢ ካኣሺ ዔኪ፥ ጊዳ ዑንጄ ዓጊ፤ ናንጊና ናንጋ ጎዳ ዓይሢባኣ ታሚ ዔኪ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ዬያሮ ዔርቲባኣንቴ ናንጊና ናንጋ ጎዳ ኮራፓ ታሚ ኬዲ ዔያቶ ሙዔሢሮ ዔያታ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ዬካፓ ሙሴ ዓኣሮኔ ኮራ፦ «ናንጊና ናንጋ ጎዳ ‹ታ ቤርቶ ሺኢኪ፥ ታኣም ማዻሢ ቢያ ታኣኮ ዱማዼያ ማዒፆ ጌኤሹሞ ቦንቾንጎ፤ ታኣኒ ታ ዴሮ ቢያሢ ቤርታ ቦንቺንቴያ ማዓንዳኔ› ጌይ ኬኤዜሢ ዬያቱዋዓዳ?» ጋዓዛ፥ ዓኣሮኔ ዔኤቢ ጎዑዋዖ ዚቲዮ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ዬካፓ ሙሴ ዓኣሮኔኮ ዓዶ ዒሾ፥ ዑዚዔኤሌ ጎዖስኬያኮ ናይ ሚሻዔኤሌና ዔልፃፓኔና ዔኤላዖ፦ «ሃኒ ዬይጋፓ ሃንሢ ዒንሢ ጌርሲንሢኮ ሌዞ ዓፒሎና ማዢንቴ፥ ፆኦሲም ዱማዼ ማኣራፓ ዔኪ ጉርዶ ዙሎ ኬሱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ዔያታ ሙኪ ሙሴ ዔያቶ ዓይሤ ጎይፆ ሃይቄዞንሢኮ ቄኤሱሞ ማኣዓሢ ኬሱዋዖ ዎላ ኬዲ ዔኪ ጉርዶፓ ዙሎ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ዬካፓ ሙሴ ዓኣሮኔና ዒዛኮ ናኣቶ ዓላዜሬንታ ዒታማሬንታም፦ «ሲዪ፥ ቶኦኮ ዒንሢኮ ጉኡሊፖቴ፤ ማኣዓሢያ ዳርዚፖቴ፤ ዬያ ዒንሢ ማዼቴ ሃይቃንዳኣኬ፤ ናንጊና ናንጋ ጎዳ ዴሮ ዑፃ ዻጋዻንዳኔ፤ ጋዓንቴ ናንጊና ናንጋ ጎዳ ታሞና ባይዜ፥ ዒንሢኮ ዓሽኮ ማዔዞንሢ ዒስራዔኤሌ ዓሳ ዬኤካኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ሃሺ ዒንሢ ኬስኪፖቴ፤ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ዛይቴና ቲሽኪንቲ ዒዛም ዒንሢ ዱማዼያታሢሮ ዒንሢ ያፓ ኬስኬቴ ሃይቃንዳኣኬ» ጋዓዛ፥ ዔያታ ሙሴ ዓይሤ ጎይፆማ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ናንጊና ናንጋ ጎዳ ዓኣሮኔም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«ኔኤና ኔ ናኣቶና ዎይኖ ዑዦታቴያ ሜሌ ማሣ ዑሺ ዑሽኪ ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮ ዒንሢ ጌሉዋጉዲ ዒንሢና ዔሩዋቴ፤ ዒንሢ ዬያይዴቴ ሃይቃንዳኣኬ፤ ዬይ ዒንሢንታ ዒንሢኮ ጊንፃፓ ሙካ ሾይንታ ካፓንዳ ዳምቤ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ታኣም ዱማዼ ባኮንታ ዱማዺባኣ ባኮ፥ ዒኢቴ ባኮንታ ጌኤዦ ባኮንታኮ ባኣካ ዓኣ ዱሙሞ ዔሪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ሙሴ ዛሎና ታ ዒንሢም ዒንጌ ዳምቦ ቢያ ዒስራዔኤሌ ዓሶ ዔርዙዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ዬካፓ ሙሴ ዓኣሮኔና ዒዛኮ ላምዖ ናኣቶ ዓላዜሬንታ ዒታማሬንታም፦ «ናንጊና ናንጋ ጎዳም ዒንጊንቴ ሃኣኮ ዒንጊፆይዳፓ ዓቴ ዺኢሎ ዔኪ ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ ላኣዱዋቴ፤ ዬይ ዑሣ ዓኣዼ ፆኦሲም ዱማዼ ዒንጊሢ ማዔሢሮ ታኣም ዒንጎ ባካ ዒንጊንታ ቤዞ ኮይላ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ዬይ ናንጊና ናንጋ ጎዳም ዒንጊንታ ሃኣኮ ዒንጊፆይዳፓ ፓቂንቲ ኔኤና ኔ ናኣቶና ዛላ ማዔሢሮ ፆኦሲም ዱማዼ ቤዛ ሙዑዋቴ፤ ያኣዼ ዒንሢ ማዻንዳጉዲ ናንጊና ናንጋ ጎዳ ታና ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ዒስራዔኤሌ ዓሳ ፔቱሞና ዒንጋ ዒንጊፆይዳፓ ዒንሢ ዛሎ ማዒ ዒንጊንቴሢሮ ዡጎና ዚኢሮንታ ላባዎንታ ኔናንታ ኔኤኮ ዓቲንቆ ናኣቶንታ ዉዱሮ ናኣታኣ ቢያ ካኣዦ ዳምቦ ጎይፆና ጌኤሺ ማዔ ቤዛ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ማላ ናንጊና ናንጋ ጎዳም ሙኡዚ ዒንጊሢ ማዒ ዒንጊንታ ዎዶና ላባዎንታ ዚኢሮንታ ዔያታ ዔኪ ሺኢሾንጎ፤ ዬይ ቢያ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ኔኤና ኔ ናኣቶናም ናንጊና ዒንሢ ዛላ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ሙሴ ጎሞ ጌኤሺፆሮ ዒንጊንቴ ዋኣራሢ ዎዎዲንቴቴያ ዖኦጪ ታማኣ ሚቾናያ ማዔሢ ዔራዖ ዓኣሮኔ ናኣቶ፥ ዓላዜሬና ዒታማሬና ዑፃ ዻጋዺ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«ጎሞ ጌኤሾሮ ዒንጊንቴ ዒንጊፆ ዓይጎሮ ፆኦሲም ዱማዼ ቤዛ ዒንሢ ሙዑዋዖ ሃሼይ? ዬይ ዑሣ ዓኣዼ ፆኦሲም ዱማዼያኬ፤ ዬይ ዴሮኮ ጎሞ ጌኤሻያ ማዓንዳጉዲ ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጌያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ዬያኮ ሱጉፃ ዓፒሎና ማዢንቴ፥ ፆኦሲም ዱማዼ ማኣሮ ጌሊባኣሢሮ ታ ዒንሢም ዓይሤ ጎይፆና ፆኦሲም ዱማዼ ቤዛ ዒንሢ ዬያ ዓሽኮ ሙሙዓንዳዖ ዓቴኔ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ዒማና ዓኣሮኔ ሙሴም፦ «ጎሞ ጌኤሻኒ ዒንጊንቴ ዒንጊፆ ሃኖ ታ ሙዔያ ማዔቴ ናንጊና ናንጋ ጎዳ ዎዛሳንዳያ ናንዳ? ዴራ ጎሞ ጌኤሺፆ ዛሎንታ ሚቺ ዒንጎ ዒንጊፆ ዛሎናሮ ዒንጎ ባኮ ሃኖ ዔኪ ዬዔኔ፤ ጋዓንቴ ያኣዼ ያኣዼ ባኣዚ ታና ሄሌኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ሙሴ ዬያ ዋይዛዖ ዒ ጌዔ ባኮ ጎኔኬ ጌይ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«ዒስራዔኤሌ ዴሮም ሂዚ ጎዑዋቴ፤ ሳዖይዳ ናንጋ ባኮይዳፓ ዓሽኪ ዒንሢ ሙዓንዳዞንሢ ሃንሢኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ሹቁላ ላምዖ ፓቂንቲ ዓኣ፥ ዓሌ ዻዓ ባኮንሢኮ ዓሽኮ ሙዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","ጋዓንቴ ጋኣሎንታ ሾኦኖንታ ዋሪሌንታ ዓሌ ዻዓያ ማዔቴያ ዔያቶኮ ቶኮ ሹቁላ ላምዖ ፓቂንቲባኣያ ማዔሢሮ ሙዒፖቴ፤ ዒንሢኮ ቄፄ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ሃሣ ጉዱንሢያ ሙይፖቴ፤ ዔያቶኮ ሹቁላ ላምዖ ፓቂንቴያ ማዔቴያ ዓሌ ዔያታ ዻዑዋሢሮ ዒንሢኮ ቄፄ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ዬይ ባካ ቄፄ ማዔሢሮ ዬያቶ ሙይፖቴ፤ ሃይቄ ሌዞዋ ዔያቶኮ ካኣሚፖቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«ጋኣሲንታ ቁኡሪ ማላ ዒልዒንታ ዓኣ፥ ዼኤፖ ባዞና ዎሮናይዳ ናንጋ ሞላሢ ዜርፆ ዒንሢ ሙዓኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ጋዓንቴ ዋኣፆይዳ ናንጋ፥ ጋኣሲና ዒልዒናባኣ ሜሌ ማዢንታ ቢያ ሙይንታንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ዬያጉዴ ባካ ዒንሢኮ ቄፄ ማዓኒ ኮይሳኔ፤ ዬያቶ ሙይፃ ዓታዛ ሃይቄ ሌዞታዖ ዔያቶኮ ዒንሢ ካኣማንዳያ ኮይሱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ዬያሮ ዋኣፆይዳ ናንጋ ጋኣሲና ቁኡሪ ማላ ዒልዒናባኣ ማዢንታ ቢያ ዒንሢ ሻሻኣካ ባኣዚ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","«ካፖ ዜርፆይዳፓ ዒንሢም ቄፄ ማዒ፥ ሙይንታኒ ሻኣካንዳያ ኮይሳ ባኮንሢ ሃንሢኬ፦ ዚኢጊላ፥ ሃምፑራ፥ ኮኦኬ፥ ኪላንቄ፥ ዱማ ዱማ ዜኤጌ፥ ዱማ ዱማ ቁራኬ፥ ቱኡቴ፥ ሃንጋ ሃንጎ፥ ጫሬ ካፒ፥ ዱማ ዱማ ጋርማ ዜርሢ፥ ኩኩቴ፥ ሶኦሦ ሃምፑራ፥ ሙኡታሌ፥ ባዚ ካፒ፥ ቶኮ ኬኤላ ዎላ ካኣሜ ባዞ ካፓ፥ ጫውራ፥ ቦኦካ፥ ቆልሞና ሃንታ ቦኦሬ ካፓ፥ ማኣሎንታ ፓቃቴንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«ጋኣሲ ዓኣያታዖ ዖይዶ ቶኪና ሃንታኒ ዳንዳዓ፥ ዻካ ባኣዚ ቢያ ዒንሢም ቄፄ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ጋዓንቴ ዔያቶይዳፓ ሳዖይዳ ኮኦማ ጪጊቺ ዓኣ፥ ዻኮ ባካ ሙይንታኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ዬያታ ዓቢሢንታ ጎምቦንታ ማኮንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ጋዓንቴ ጋኣሲ ዓኣያታዖ ዖይዶ ቶኪና ሃንታ፥ ዻኮ ባካ ጉቤ ዒንሢም ቄፄ ሃሣ ሻኣካያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«ዬንሢ ባኮ ዒንሢ ካኣሜቴ ዒኢታንዳኣኬ፤ ዬንሢ ባኮኮ ሃይቄ ሌዞ ካኣሜ ዓሲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ዬያ ባኮኮ ሌዞ ዔኪ ሺኢሻ ዓሲ ቢያ ፔኤኮ ማኣዓሢ ማስኮንጎ፤ ያዺ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ቶኪ ሹቁሊ ዓኣያታዖ ሹቁላ ላምዖ ፓቂንቲ ባኣያ፥ ሃሣ ዓሌ ዻዑዋ ባኣዚ ቢያ ዒንሢኮ ቄፄ ማዖንጎ፤ ዬያ ባኮኮ ሌዞ ካኣሜ ዓሲ ቢያ ዒኢቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ዖይዶ ቶኪና ሃንታ ባኮይዳፓ ቢያ ፔ ቃኣቆና ሄርቂ ሃንታ ባካ ቢያ ዒንሢኮ ቄፄ ማዖንጎ፤ ዬያ ባኮኮ ሃይቄ ሌዞ ካኣማ ዓሲ ቢያ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ዬያ ባኮኮ ሃይቄ ሌዞ ካኣማ ዓሲ ፔኤኮ ማኣዓሢ ማስኮንጎ፤ ያዺ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ፤ ዬይ ባካ ዒንሢኮ ቄፄ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","«ዖኦቻ፥ ሂኢፂ፥ ሂኢፂ ሶይና፥ ሞዻ፥ ጎርሻ፥ ጌኤጌ፥ ጉርጉራ፥ ጋኣሹንቾ፥ ጎኦሺ ጎጳ፤ ያኣቶንታ ያኣቶጉዴ ማዢንታ ቢያ ዒንሢኮ ቄፄ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ያኣቶ ባኮኮ ዑፆታቴያ ሃይቄ ሌዞ ካኣማ ዓሲ ቢያ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ዬያቶ ባኮኮ ሌዞ ካኣሜ ሜሄያኣ ቢያ ዒኢቴያ ማዖንጎ፤ ዬይ ሜሃ ሚሢፓ ኮሾና ባኣዚ፥ ማኣዓ፥ ዜዺ፥ ሱርባ፤ ያኣቶንታ ዬያጉዴ ባኮ ቢያ ማዓኒ ዳንዳዓኔ፤ ዬይ ሜሃ ዋኣሢዳ ዓጊንቲ ዴዖንጎ፤ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ሌዛ ዔያቶኮ ዓጪፓ ማዦና ሜሄ ሄሌቴ ዬያ ባኮኮ ጋራ ዓኣ ባካ ዒኢቴያ ማዓሢሮ ዬያ ባኮ ዎዎዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ዓይጎጉዴ ሙኡዚ ማዖም ዬያጉዴ ሜሃፓ ዋኣሢ ፆዺ ሄሌቴ ዬይ ሙዓ ዒኢቴያ ማዖንጎ፤ ዬያ ሜሆይዳ ዑሽኮ ዑሺ ዓኣቴያ ዒኢቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ዬያ ሃይቄ ባኮኮ ሌዞ ካኣሜ ባኣዚ ቢያ ዒኢቴያ ማዓሢሮ ቄፄ ማሂ ሻኣኪንቱዋቴ፤ ናኣቦ ማዔቴያ ዖቲታቴያ ዎዺ ኬኤሩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ዬንሢ ባኮኮ ሌዛ ካኣሜ ባኣዚ ቢያ ዒኢታያ ማዔቴያ ዋኣሢ ዓልቃ ቤሲና ዋኣሢ ዔቴና ዒኢታዓኬ፤ ጋዓንቴ ሌዞ ካኣማ ዓሲ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ዬንሢ ባኮኮ ሌዛ ዜርቃኒ ጊኢጊሾና ዜርሢ ካኣሜቴ ዜርፃ ዒኢታዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ጋዓንቴ ዜርፆይዳ ዋኣሢ ዋሂንቴስካፓ ዬያ ባኮኮ ሌዛ ካኣሜቴ ዒንሢኮ ዬይ ዜርፃ ዒኢቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«ዒንሢ ዓሽኮ ሙዓ ቆልማ ሃይቄም ሌዞ ካኣማ ዓሲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ዓይጎ ዓሲያ ማዖም ዬያ ቆልሞኮ ዓሽኮይዳፓ ሙዔያ ማዔቴ ማኣዓሢ ፔኤኮ ማስኮንጎ፤ ያዺ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዬይ ዓሢ ዒኢቴያ ማዓንዳኔ፤ ሃሣ ዓይጎ ዓሲያ ማዖም ዬያ ባኮኮ ሌዞ ካኣሚ ኬዴቴ ማኣዓሢ ፔኤኮ ማስኮንጎ፤ ዬይ ዓሢያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«ሳዖይዳ ዳዶና ጎቺንቲ ሃንታ፥ ዻኮ ማዢንታ ቢያ ዒንሢኮ ቄፄ ማዒ፥ ሻኣካያ ማዖንጎ፤ ሙይፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ሳዖይዳ ዳዶና ጎቺንቲ ሃንታ ባካ፥ ዖይዶ ቶኪናታዖ ጎቺንቲ ሃንታ ባኮንታ ሚርጌ ቶኪ ዓኣ ባኮንታ ቢያ ቄፄ ማሂ ሻኣኪንቱዋቴ፤ ሙይፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ዬንሢ ባኮይዳፓ ዓይጎ ባኣዚያ ማዖም ሙዒ ዒንሢ ቶኦኮ ዒኢሲፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ፤ ታኣኒ ዱማዼያታሢሮ ዒንሢያ ዒንሢ ታኣም ዱማዼያ ማሁዋቴ፤ ሳዖይዳ ዳዶና ጎቺንቲ ሃንታ ዻኮ ማዢንቶ ሙዒ ዒንሢ ዒኢሲፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ዒንሢኮ ፆኦሲ ማዓኒ ጊብፄ ዓጮይዳፓ ዒንሢ ዔኪ ኬሴ ናንጊና ናንጋ ጎዳሢ ታናኬ፤ ዬያሮ ታኣኒ ዱማዼያ ማዔሢሮ ዒንሢያ ታኣም ዱማዼያ ማዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«ዓካሪ ሃይ፥ ዋኣሢዳ ናንጋ ባኮንታ ሳዖይዳ ናንጋ ዻኮ ማዢንቶንታ፤ ሃሣ ካፖ ዛሎዋ ዒንሢም ኬሲንቴ ዎጌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ዎጎ ጎይፆና ቄፄ ማዔሢና ሻቲ ማዔ ባኮናኮ ባኣኮይዳ ዓኣ ዱሙሞ ዔራኒ ሙዖ ባኮና ሙዑዎ ባኮናኮ ባኣካ ዓኣ ዱሙሞ ኮሺ ዔሩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","« ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ፔቴ ላኣሊ ጎጳዺ ዓቲንቄ ናይ ሾዔያ ማዔቴ ላኣሊኮ ሻቱሞ ጴዻዛ ማዺንታ ጎይፆ ላንካይ ኬሊ ሄላንዳኣና ዒዛ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ሳላሳ ኬሎና ናዖኮ ዓቲንቶ ቤርቶ ቲቃንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ዬካፓ ዑፃ ዒዞኮ ፃኣዻንዳ፥ ሃይሢታሚ ሃይሦ ኬሊ ሄላንዳኣና ፆኦሲም ዱማዼ ዓይጎ ባኣዚያ ዒዛ ካኣማኒ ኮይሱዋሴ፤ ሃሣ ዒዞኮ ማስቲፆ ኬላ ጋፓንዳያ ሄላንዳኣና ታኣም ዱማዼ ማኣሮ ጌሎፓ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«ዬያጉዲ ሃሣ ፔቴ ላኣሊ ዉዱሮ ናይ ሾዔቴ ላኣሊኮ ሻቱማ ጴዻኣና ማዺንታ ጎይፆ ታጶ ዖይዶ ኬሊ ሄላንዳኣና ዒዛ ዒኢቴያ ማዖንጎ፤ ዬካፓ ዑፃ ዒዞኮ ፃኣዺ፥ ማስቲፃ ጋፓንዳኣና ላሂታሚ ላሆ ኬሊ ዴዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«ዒዞኮ ማስቲፆ ኬላ ጋፔስካፓ ዓቲንቄ ናይ ማዔቴያ ዉዱሮ ናይ ዛላ ሚቺ ዒንጎ ዒንጊሢ ማዓንዳ፥ ፔቴ ሌዔ ማዔ ማራናይና ጎሞ ጌኤሺፆ ዛሎ ማዓ ፔቴ ዶኦሌ ማዔቴያ ፔቴ ኪሬ ናይ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዔኪ ሙኪ ዒኢካ ማዻ ቄኤሳሢም ዒዛ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ቄኤሳሢያ ዒዛ ዒንጌ ባኮ ዔኪ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሾንጎ፤ ዬካፓ ዒዞኮ ሱጉፃ ሾኦቴሢሮ ዒዛ ዒኢቴ ዒኢቲፃ ጋፔም ዒዞ ሻቲንቂሲፆ ዳምባ ያዺዲ ኩማንዳኔ፤ ዒዛ ጌኤሽኬያ ማዓንዳኔ፤ ዬይ፦ ላኣሊ ሾዔስካፓ ማዺ ኩንሣ ዳምቤ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","«ላኣሌላ ማራናይ ዔኪ ሙካኒ ዳንዳዒባኣያ ማዔቴ ላምዖ ዶኦሌታቴያ ኪሬ ዔኪ ሙኮንጎ፤ ዔያቶይዳፓ ፔቴማ ሚቺ ዒንጎ ዒንጊሢ ማሂ ጊንሣ ዓቴማ ጎሜ ጌኤሻኒ ዒንጎ ዒንጊሢ ማሂ ዒንጎንጎ፤ ዬያይዲ ቄኤሳሢ ዒዞኮ ዒኢቲፆ ጋፒሲ፥ ዒዛ ሻቲንቃንዳ ዳምቦ ኩንሦንጎ፤ ዬካፓ ዒዛ ዎጎ ጎይፆና ዳምቦ ካፒ ኩንሢ ጌኤሽኬያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«ዓይጎ ዓሲያ ማዖም ፔኤኮ ዑፃ ዱንጫ ኬስኬቴ፥ ቃፃ ዓርቄቴ፤ ሃሣ ዑስካ ኬስካ ዶርዖ ማዒ ማዒ ዴንዳ ዒላንታ ጴዼቴ ዓኣሮኔ ፃጲ ማዔ፥ ቄኤሶ ኮራ ዓሳ ዒዛ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ዬካፓ ቄኤሳሢ ዬያ ዓሢኮ ዑፃ ዓኣ ኪፆ ዛጊ፥ ዬያ ኪፆይዳ ዓኣ ጋፓና ቦኦራያ ማዔቴ፤ ሃሣ ኪፆኮ ኮይሎይዳ ዓኣ ዑፃ ሃንጎ ዑፃፓ ቁልፒ ዔታዻያ ማዔቴ፥ ዬይ ዓሲዳፓ ዓሲ ዓርቃኒ ዳንዳዓ ዑስካ ኬስካ ዶርዖ ማዔሢሮ ዓሢ ካኣዦ ዳምቦና ዒኢቴያ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ጋዓንቴ ኪፃ ኮይላ ዓኣ ዑፆይዳፓ ቁልፒ ዔታዺ ጴዹዋያ ማዔቴ፤ ሃሣ ጋፓናኣ ቦኦሩዋያ ማዔቴ ቄኤሳሢ ዬያ ዓሢ ላንካይ ኬሊ ሄላንዳኣና ፔቴ ጋርሲዳ ዱማሲ ጌሢ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ዬካፓ ቄኤሳሢ ላንካሳ ኬሎና ዓሢ ላሚ ዛጎንጎ፤ ዒ ዛጋ ዎዶና ኪፃ ዱማዼ ባኣዚ ባኣያ ማዔቴ፥ ሃሣ ላንካይ ኬሊ ዱማሲ ዴይሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ሃሣ ቄኤሳሢ ላንካሳ ኬሎና ዓሢ ዛጎንጎ፤ ዒዚ ዛጋ ዎዶና ኪፃ ዳልጊፆይዳፓ ሹሊ ጴዼቴ ኪፃ ቃፃ ማዔሢ ኬኤዚ ዬይ ዓሢ ዳምቦ ጎይፆና ጌኤሺ ማዔሢ ዔርዞንጎ፤ ዬይ ዓሢ ዎጎ ጎይፆና ጌኤሽኪፆ ዔርዛኒ ማኣዓሢ ፔኤኮ ማስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ጋዓንቴ ቄኤሳሢ ዬያ ዓሢ ዛጊ ጌኤሺኬ ጌዔስካፓ ኪፃ ዳልጊ ዳልጊ ዴንዳያ ማዔቴ ዓሢ ላሚ ቄኤሳሢ ቤርቶ ሺኢኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ዬካፓ ቄኤሳሢ ዒዛ ላሚ ዛጎንጎ፤ ዒ ዛጋንቴ ኪፃ ዳልጊ ዴንዳያ ማዔቴ ዬይ ዑፃኣ ኬስካ ዶርዓሢ ማዔሢሮ ዳምቦና ዒኢቴያ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«ዓይጎ ዓሲያ ማዖም ዓሲፓ ዓሲ ዓርቃኒ ዳንዳዓ፥ ዑስካ ኬስካ ዶርዓ ዓርቄቴ ዬያ ዓዺንቴ ዓሢ ዓሳ ቄኤሳሢ ኮራ ዔኪ ዬዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ዬካፓ ቄኤሳሢ ዬያ ዓሢ ዛጎንጎ፤ ዑፃ ኬስኬ ባካ ዑርታንዳ ባኣዚጉዲ ዴዒ፥ ጊዳ ዓኣ ጋፓኖ ቦኦሪሻ ኪሢ ማዒ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ዬይ ዑስካ ኬስካ ዶዲ ዶርዖ ማዔሢሮ ቄኤሳሢ ዬይ ሃርጌ ዓሢ ዒኢቴያ ማዔሢ ዔርዞንጎ፤ ዬያኮ ዒኢቲፃ ፔጌና ዔርቴሢሮ ዬያጉዴ ዓሲ ጋርሲዳ ዱማሲ ዛጎንዶያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ዑፃ ኬስካ ዶርዓሢ ዓሢኮ ቶኮ ፁንጋፓ ዴንዲ ቶኦኮ ሄላንዳኣና ባይዚ ኬስኬያ ማዔሢ ዔሬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ቄኤሳሢ ላሚ ዒዛ ዛጎንጎ፤ ዓሢኮ ዑፆ ቢያይዳ ኬስኪ ዓኣያ ማዒ ጴዼቴ ዬይ ዓሢ ዎጎ ጎይፆና ጌኤሽኬያ ማዔሢ ዔርዞንጎ፤ ዑፃ ዒዛኮ ጉቤና ቦኦሬሢሮ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ጋዓንቴ ላሚ ሃሣ ኔጉዋዖ ኪፃ ጊኢሺጉዲ ዴይ ጴዼያ ማዔቴ ዳምቦ ጎይፆና ዒ ዒኢቴያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ዬያሮ ቄኤሳሢ ጊንሣ ዛጊ፥ ጊኢሺጉዲ ዴዒ ዓኣ ኪሢ ዴንቄቴ ዬይ ዓሢ ዳምቦ ጎይፆና ዒኢቴያ ማዔሢ ዔርዞንጎ፤ ዓይጎሮ ጌዔቴ ዬይ ኪፃ ዑፃ ኬስካ ዶርዓሢ ማዔሢሮ ዬይ ዓሢ ዒኢቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ኪፃ ፖዓዖ ላሚ ጊንሣ ቦኦሪ ናኬቴ ቄኤሳሢ ኮይላ ዓኣዾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ቄኤሳሢ ላሚ ዒዛ ዛጊ ኪፃ ሹሊ ቦኦራያ ማዒ ጴዼቴ ዬይ ዓሢ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓሢሮ ዓሢ ጌኤሺ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«ፔቴ ዓሲኮ ዱንጫ ኪሢ ዓኣዖ ፓፂ ዲኢዳዼ ቤሲ ዓኣቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ዻካ ጌዔስካፓ ዲኢዶ ቤዞይዳ ጊኢሺጉዴ ባኣዚ ዴዒ፤ ሃሣ ዑርታኒ ጋዓ ኪሢ ኬስኪ ጴዼቴ ዬይ ዓሢ ቄኤሳሢ ኮራ ዓኣዾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ቄኤሳሢ ዒዛ ዛጊ ኪፃ ዓኣ ቤዛ ሜሌ ዑፆይዳፓ ቁልፒ ዔታዺ ጴዼቴ፤ ሃሣ ጊዳ ዓኣ ጋፓናኣ ቦኦራያ ማዔቴ፥ ዓሢ ዒኢቴያ ማዔሢ ዔርዞንጎ፤ ዓይጎሮ ጌዔቴ ዬይ ዱንጮ ኪፆና ማዒ ዓርቄ ዑስካ ኬስካ ዶርዖ ማዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ቄኤሳሢ ዛጋንቴ ዒኢካ ዓኣ ጋፓና ቦኦሩዋያ፤ ሃሣ ሜሌ ዑፆይዳፓ ዱማዺ ቁልፒ ዔታዹዋያ፥ ሹላኒ ጋዓያ ማዔቴ ዓሢ ላንካይ ኬሊ ዱማሲ ጌሢ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ኪፃ ዓኣ ቤዛፓ ዳልጊ ዳልጊ ዓኣዻያ ማዔቴ ዬይ ዓሢ ዑፃ ኬስካ ዶርዓሢና ዓዺንቴያ ማዔሢሮ ዒኢቴያታሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ጋዓንቴ ዱማዺ ዔርቱዋያ፤ ሃሣ ዑፆይዳ ዳልጊ ዳልጊ ዴንዱዋያ ማዔቴ ዱንጮ ኪፆኮ ዲኢዲ ማዔሢሮ ዎጎ ጎይፆና ጌኤሺ ማዒፆ ዓሢኮ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«ፔቴ ዓሲኮ ዑሢ ታሚ ሙዔም ታማ ሙዔ ቤዛ ቦኦሪ፤ ሃሣ ጊንሣ ዖዳልቃያ ማዒ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ቄኤሳሢ ዬያ ዛጎንጎ፤ ኪፃ ዓኣ ቤዞይዳ ዓኣ ጋፓና ቦኦራያ ማዔቴ፥ ሃሣ ሃንጎ ዑፆይዳፓ ቁልፒ ዔታዻያ ማዔቴ ታማ ሙዔሢና ማዒ ዓርቄ፥ ዑፃ ኬስካ ዶርዓሢ ማዔሢሮ ዬይ ዓሢ ዒኢቴያ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ጋዓንቴ ዬያ ቤዞይዳ ኬስካ ጋፓና ቦኦሩዋያ ማዔቴ ሃሣ ዑፃ ሜሌ ዑፆይዳፓ ቁልፒ ዔታዹዋያ ጉሪ ዑፃ ላኣሚንቴያታቴ ቄኤሳሢ ዬያ ዓሢ ላንካይ ኬሊ ጋሮይዳ ዱማሲ ጌሢ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ዬካፓ ላንካሳ ኬሎና ቄኤሳሢ ላሚ ዓሢ ዛጎንጎ፤ ዒዛ ዛጋንቴ ኪፃ ዳልጊ ዴንዳያ ማዒ ጴዼቴ ዑፃ ኬስካ ዶርዓሢ ማዔሢሮ ዬይ ዓሢ ዒኢቴያ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ጋዓንቴ ኪፃ ዓኣ ቤዛፓ ዱማዹዋያ ማዒ፥ ጉሪ ዑፃ ላኣሚንቴያታቴ ዑፃ ኬስካ ዶርዓሢቱዋንቴ ታማ ሚቼ ዲኢዶ ማዔሢሮ ዬይ ዓሢ ዳምቦ ጎይፆና ጌኤሺ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«ፔቴ ዓቲንቄኮ ማዔቴያ ላኣሊኮ ቶኦካ ማዖም ጋጋጫ ኪሢ ኬስኬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ቄኤሳሢ ዬያ ኪፆ ዛጎንጎ፤ ዬይ ቤዛ ኮይላ ዓኣ ዑፆይዳፓ ቁልፒ ዔታዻያ ማዔቴ፥ ሃሣ ዒኢካ ዓኣ ጋፓና ጉኡፃያ ማዒ ጋላፔቴ ዑፃ ኬስካ ዶርዓሢ ማዔሢሮ ዬይ ዓሢ ዒኢቴያ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ጋዓንቴ ቄኤሳሢ ዛጋ ዎዶና ኪፃ ኮይላ ዓኣ ዑፆይዳፓ ቁልፒ ዔታዹዋያ ማዔቴ፤ ሃሣ ዒኢካ ዓኣ ጋፓና ፒዜ ጋፓኔ ማዒባኣቴ ዬያ ዓሢ ላንካይ ኬሊ ዱማሲ ጌሢ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ዬካፓ ላንካሳ ኬሎና ላሚ ቄኤሳሢ ዛጋንቴ ኪፃ ዳልጉዋያ ማዒ፥ ጋፓናኣ ጋላፑዋያ ማዔቴ፤ ሃሣ ሜሌ ዑፆይዳፓ ቁልፒ ዔታዹዋያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ኪፃ ዓኣ ቤዞ ሃሻዖ ሃንጎ ጋፓኖ ቢያ ሜኤዳዛ፥ ቄኤሳሢ ሃሣ ላንካይ ኬሊ ሄላንዳኣና ዒዛ ዱማሲ ጌሢ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ላንካሳ ኬሎና ላሚ ሃሣ ቄኤሳሢ ዬያ ኪፆ ዛጎንጎ፤ ዒ ዛጋንቴ ኪፃ ዳልጉዋያ ማዔቴ፥ ሃሣ ኪፃ ዓኣ ቤዛ ሜሌ ቤዛፓ ቁልፒ ዔታዺባኣያ ማዔቴ ዬይ ዓሢ ዳምቦ ጎይፆና ጌኤሺ ማዔሢ ዔርዞንጎ፤ ዬካፓ ዓሢ ፔኤኮ ዓፒሎ ማስኪ ጌኤሺ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ጋዓንቴ ጌኤሺ ማዒፃ ኬኤዚንቴስካፓ ኪፃ ዳልጊ ዳልጊ ዓኣዻያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ቄኤሳሢ ላሚ ዒዛ ዛጎንጎ፤ ዒዛ ዛጋንቴ ኪፃ ጎኔ ዳልጋያ ማዔቴ ጋላፒ ጋፓኔ ዓኣቴያ ባኣቴያ ዓሢ ዒኢቴያ ማዔሢ ዔርቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ጋዓንቴ ቄኤሳሢ ዛጌ ጎይፆና ኪፃ ሙይ ዳልጉዋያ፤ ሃሣ ቃራ ጋፓኔያ ኬስኪ ጴዼያ ማዔቴ ኪፃ ፓፄያ ማዔሢሮ ዳምቦ ጎይፆና ዓሢ ጌኤሺ ማዔሢ ዔርዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«ፔቴ ዓቲንቄ ማዔቴያ ላኣሊኮ ዑፆይዳ ዒላንታ ኬስኬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ቄኤሳሢ ዬያ ዛጎንጎ፤ ዬይ ኬስካ ባካ ሼኤማዼያ ማዒ ጴዼቴ ሚርጌ ሜታሱዋ ዑሢዳ ኬስካ ዒላንቶታሢሮ ዬይ ዓሢ ዳምቦ ጎይፆና ጌኤሺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","ፔቴ ዓሲኮ ቶኦኪ ዼንካፓታቴያ ባሊታፓ ባሌያ ማዔቴ ዬይ ባሊፃ ዓሢ ዒኢቴያ ማሃኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ጋዓንቴ ባሎይዳ ዑርታንዳጉዴ ጊኢሺ ዓኣ ኪሢ ጴዼቶ ዬይ ዑፃ ኬስካ ዶርዓሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ቄኤሳሢ ዬያ ዛጌም ዑፃ ኬስካ ዶርዓሢ ማላ፥ ዑርታንዳጉዴ ጊኢሺ ዓኣ ኪሢ ማዒ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ዬይ ዓሢ ዒኢቴያ ማዔሢ ዔርዞንጎ፤ ዬያ ባሎና ማዒ ዓርቄ ዓሲፓ ዓሲ ዓርቃኒ ዳንዳዓ ዑፃ ኬስካ ዶርዓሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«ዬያጉዴ ዑፃ ኬስካ ዶርዓሢ ዓርቄ ዓሲ ቱርጫዼ ማኣዖ ማይንቶንጎ፤ ቶኦኮዋ ፒፆፓ፤ ሃሣ ሙሱሮ ካንቂ ዓኣቺ ‹ታኣኒ ዒኢቴያኬ! ዒኢቴያኬ!› ጌይ ጌይ ዒላቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ዬይ ዓሢ ዶርዓሢ ፖዓንዳያ ሄላንዳኣና ዒኢቴያ ማዓሢሮ ዓሲዳፓ ዱማዺ፥ ዓሲ ናንጉዋ ቤስካ ፔኤኮ ዴዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«ቡኡዔ ባኣዚ ማራይ ጋፓኔና ማዔቴያ ሱኡፔና ኮሺንቴ ዓፒላይዳ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ዶርዜ ዹዔ ማኣዖይዳታቴያ ኩቻ ማዦና ማኣዖኮ ሻላሢዳ ማዔቴያ ቃጪኖይዳ፤ ዬያጉዲ ሃሣ ሱኡፔናኣ ማዖም ዒልዒና ኮሺንቴ ማኣዖይዳ ቡኡዒፃ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ማኣዓሢኮ ዑፃ ጴዼ ቡኡዒፃ ጮልዔ፤ ሃንጎ ዞቃያ ማዔቴ ሜሌ ዓፒላ ዓርቃኒ ዳንዳዓያታሢሮ ቄኤሳሢ ዛጌቴ ቃራኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ቄኤሳሢ ዛጊ፥ ዬንሢ ዓፒሎንሢ ላንካይ ኬሊ ሄላንዳኣና ፔቴ ቤስካ ዱማሲ ጌሢ ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ላንካሳ ኬሎና ጊንሣ ዒ ዛጋ ዎዶና ቡኡዒፃ ዳልጊ ዳልጊ ዴንዳያ ማዔቴ ዬያጉዴ ማኣዓሢ ቢያ ዒኢቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ዬያጉዴ ማኣዓሢ ታሚና ሚቺንቶንጎ፤ ዬይ ቡኡዒፃ ዳልጊ ዳልጊ ዴንዳ ቡኡዒሢ ማዔሢሮ ቄኤሳሢ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«ጋዓንቴ ቄኤሳሢ ዛጋ ዎዶና ቡኡዒፃ ዳልጊ ዳልጊ ዓኣዻያ ማዒ ጴዺባኣቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ዬይ ዓፒላ ማስኪንቲ ላንካይ ኬሊ ሄላንዳኣና ዱማዺ ጌሢንቴም ዛጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ዬካፓ ሃሣ ላሚ ዛጎንጎ፤ ዒ ላሚ ዛጋንቴ ቡኡዒፃ ዳልጊ ዴንዲባኣያ ማዔቴያ ማላሢ ቤዞማካ ዓኣቴ ዬይ ዒኢቴያ ማዔሢሮ ጋሮይዳ ማዖም ዙሎይዳ ቡኡዒሢ ጴዻ ማኣዓ ሚቺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ጋዓንቴ ቄኤሳሢ ላሚ ዛጋ ዎዶና ቡኡዒፃ ባይቃንዳ ጎይሢ ዻኪ ጴዼቴ ቡኡዒፃ ዓኣ ቤዞማ ሌሊ ዓፒሎይዳፓታቴያ ዒልዒ ማኣዖፓ ዳርዚ ኬሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ቡኡዒፃ ላሚ ጴዼቶ ጋዓንቴ ዬይ ዳልጊ ዳልጊ ዓኣዻንዳሢሮ ዔቦኮ ዓዴ ዬኖ ታሚዳ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ማኣዓሢ ማስኪንታ ዎዶና ቡኡዒፃ ባይቄቴ ላሚ ሃሣ ማስኮንጎ፤ ዬካፓ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ዬይ ዓካሪ ኮሺ ሱኡፖና ማዔቴያ ማራይ ጋፓኔና፤ ሃሣ ዒልዒና ኮሾና ዓፒላኮ ቃጪኖይዳ ማዔቴ፥ ሻላሢዳ ጴዻ ቡኡዒሢ ዛላ ዒኢቴያ ሃሣ ሻቲ ማዒፆ ዔሮ ዎጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«ፔቴ ዓሲ ዑፃ ኬስካ ዶርዓሢዳፓ ፖዔያ ማዔቴ ጌኤሽኪፆ ዛሎ ዒንጊንቴ ዳምባ ያዺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ቄኤሳሢ ዬያ ዓሢ ጉርዶኮ ዙላ ኬሲ ዛጎንጎ፤ ዓሢ ዶርዓስካፓ ፖዔያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ዳምቦ ጎይፆና ሙይንታኒ ዳንዳዓ ላምዖ ካፒና ዴኤሊ ዚቢቂ ዻካ ሜንሢ ዔኪ፤ ሃሣ ዞቄ ሚዛጲ ፓቲሌና ሂሶጴ ጌይንታ ባኬሎኮ ዒላሺና ዎላ ዔኪ ዬዓንዳጉዲ ዓይሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ዬካፓ ዓሢ ካፖንሢዳፓ ፔቴማ ጊኢሲ ዓልቃ ዋኣሢ ዱይ ጌሢንቲ ዓኣ ታሚ ቦኦቆይዳ ሹካንዳጉዲ ቄኤሳሢ ዓይሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ዓቴ ካፖማ ዴኤሎ ዚቢቆ ሚፆ ሜቂፆማና ዞቄ ሚዛጶ ፓቲሌሎና ሂሶጴ ዒላዦና ዎላ ዔኪ ቤርታ ሹኪንቴ ሱጉፆይዳ ዓጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ዬያ ሱጉፆ፥ ዑፃ ኬስካ ዶርዓሢዳፓ ጌኤሽካ ዓሢ ዑፃ ላንካይ ማይንቲ ፑጮንጎ፤ ዬካፓ ዒ ጌኤሽኬያ ማዒፆ ዔርዞንጎ፤ ሃሣ ሼምፖና ዓኣ ካፖማ ባራኒ ዴንዳንዳጉዲ ዙላ ኬሲ ሃሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ዑፃ ኬስካ ዶርዓስካፓ ጌኤሽካ ዓሢ ማኣዓሢ ፔኤኮ ማስኮንጎ፤ ቶኦኮዋ ጉኡሎንጎ፥ ዑፆዋ ዋኣሢና ማስቶንጎ፤ ዬካፓ ዳምቦ ጎይፆና ዒ ጌኤሽኬያ ማዔሢሮ ጉርዶ ጌላኒ ዳንዳዓኔ፤ ጋዓንቴ ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ፔ ኬኤፆ ጌሉዋዖ ዙላ ዴዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ላንካሳ ኬሎና ቶኦካኣ፥ ቡኡጫ፥ ሂኢፖ ጋፓና፤ ዬያጉዲ ዑፃ ዓኣ ጋፓኖ ቢያ ሜኤዲ ማኣዓሢያ ፔኤኮ ዋኣሢና ማስኪ ዑፆዋ ፔኤኮ ማስቶንጎ፤ ዬካፓ ዒ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«ሳላሳ ኬሎና ዔኤቢ ቦሂሳ ባኣዚባኣ፥ ላምዖ ዓዴ ማራናይና ፔቴ ሌዔ ማዔ ዑዞ ማራናይ ዔኪ ሙኮንጎ፤ ዬያና ዎላ ሪሚቶ ዛይቶና ዲርኪንቴ ሃይሦ ኪሎ ማዓንዳ ሺኢቺ ዺኢሊና ዶሎዜኮ ጊዲሚሺ ማዒባኣ ዛይቴና ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ቄኤሳሢ፥ ዬይ ዓሢ ዔኪ ሙኬ ባኮንታ ዓሢንታ ዎላ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ናንጊና ናንጋ ጎዳ ቤርቶ ዔኪ ሺኢሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ዬካፓ ቄኤሳሢ፥ ላምዖ ዓዶ ማራቶ ናኣቶንሢፓ ፔቴማና ዶሎዞኮ ጊዲሚዦ ማዒባኣ ዛይቶና ዔኪ ዻቢንቶኮ ጪጋ ማሂ ዒንጎ ዒንጊፆ ማዓንዳጉዲ ሺኢሾንጎ፤ ሃሣ ዬይ ቄኤሳሢ ዛላ ማዓንዳጉዲ ዡጊ ናንጊና ናንጋ ጎዳም ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ጎሞ ጌኤሻኒ ሹኪ ዒንጊንታ ቆልማ ሹኪንታ፥ ፆኦሲም ዱማዼ ቤዛ ማራዓሢ ሹኮንጎ፤ ዬያ ዒ ማዻሢ ዻቢንቶ ዛሎ ጪጋ ማሂ ዒንጎ ባካ ጎሞ ጌኤሻ ዒንጊፆጉዲ ቄኤሳሢሮ ማዒ ዒንጊንታሢሮኬ፤ ዬይ ሚርጌና ፆኦሲም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ቄኤሳሢ ማራናዓሢኮ ሱጉፃፓ ዻካ ዔኪ ጌኤሽኪፆይዳ ዓኣ ዓሢኮ ሚዛቆ ዋዮ ቤርቶ፥ ሚዛቆ ኩጮና ቶኮናኮ ዶኦሞ ኬኤሎ ቲሽኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ሃሣ ቄኤሳሢ ዛይቶይዳፓ ዻካ ዔኪ ፔኤኮ ሻውሎ ኩጮ ቃኣቆይዳ ዋሆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ዬካፓ ሻውሎ ቃኣቃ ዓኣ፥ ዛይቶይዳ ፔኤኮ ሚዛቆ ኩጮ ኬኤሎ ዳኪ ዳኪ ናንጊና ናንጋ ጎዳ ቤርታ ላንካይ ማይንቲ ዉፁርቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ቃሲ ሃሣ ቃኣቆይዳ ዓኣ ዛይቶፓ ዻካ ዔኪ ጌኤሽኪፆይዳ ዓኣ ዓሢኮ ሚዛቆ ዋዮ ቤርቶና ሚዛቆ ኩጮና ቶኮናኮ ዶኦሞ ኬኤሎንሢ ዎንዴ ዻቢንቶ ዛሎ ጪጋ ማሂ ቲሽኮና ሱጉፆኮ ጊዳ ቲሽኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ዬካፓ ዒዛኮ ቃኣቃ ዓቲ ዓኣ ዛይቶንሢ ጌኤሽኪፆይዳ ዓኣ ዓሢኮ ቶኦካ ዋሆንጎ፤ ዬያይዲ ዓሢ ጌኤሺፆ ዳምቦ ናንጊና ናንጋ ጎዳ ቤርታ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«ዬያይዴስካፓ ቄኤሳሢ ዓሢኮ ጎሞ ጌኤሺፆሮ ዒንጎ ዒንጊፆ ዒንጊ ጎሞ ጌኤሺፆ ዳምቦ ኩንሦንጎ፤ ሄሊሳዖ ሃሣ ሚቺ ዒንጎ ዒንጊፆ ማዒ ዒንጊንቴ ቆልሞ ሹኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ዬያ ሃኣኮ ዒንጊፆ ማዔ ዒንጊፆና ዎላ ሚቺ ዒንጎ ቤዛ ጌሢ ሚቾንጎ፤ ዬያይዲ ጌኤሺፆ ዳምቦ ኩንሤም ዬይ ዓሢያ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«ዓሢ ዬያ ባኮ ቢያ ዔኪ ሙካኑዋ፥ ማንቆ ማዔቴ ፔኤኮ ጌኤሽኪፆ ዛሎ ማዓ ፔቴ ዓዴ ማራናይ ሌሊ ዔኪ ሙኮንጎ፤ ዬይ ዻቢንቶ ዛሎ ጪጋ ማሂ ዒንጊንታ ዒንጊሢ ማዒ ዡጊ ዒንጎ ዒንጊሢ ማዓንዳኔ፤ ሃሣ ዛይቴና ዲርኪንቴ ፔቴ ኪሎ ማዓንዳ ሺኢቺ ዺኢሊ ሃኣኮ ዒንጊሢ ማሂ ዔኪ ሙኮንጎ፤ ዬያጉዲ ሃሣ ዶሎዞኮ ጊዲሚሺ ማዑዋ ዛይቶዋ ዔኪ ሺኢሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ሃሣ ዒዛም ዳንዳዒንታ ጎይፆ ላምዖ ዶኦሌ፥ ሃንጎ ላምዖ ኪሬ፤ ፔቴማ ጎሞ ጌኤሻ ዒንጊሢ ማሂ ፔቴማ ጊንሣ ሚቺ ዒንጎ ዒንጊሢ ማሂ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ጌኤሺፆ ዳምቦ ኩንሦ ሳላሳ ኬሎና ዬንሢ ቢያ ዔኪ ሙኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ናንጊና ናንጋ ጎዳ ቤርታ ቄኤሳሢም ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ዬካፓ ቄኤሳሢ ዻቢንቶ ዛሎ ጪጋ ማሂ ዒንጊንታ ማራናዖና ዛይቶና ዔኪ ዡጊ ናንጊና ናንጋ ጎዳም ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ዬካፓ ዻቢንቶ ዛሎ ጪጋ ማሂ ዒ ዒንጌ ማራዓሢ ሹኮንጎ፤ ዬያ ሱጉፆ ዻካ ዔኪ ጌኤሽኪፆይዳ ዓኣ ዓሢኮ ሚዛቆ ዛሎ ዋዮ ቤርቶ፥ ሚዛቆ ኩጮና ቶኮናኮ ዶኦሞ ኬኤሎ ቲሽኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ዬያይዴስካፓ ቄኤሳሢ ዛይቶይዳፓ ዻካ ፔኤኮ ሻውሎ ኩጮ ቃኣቆይዳ ዋሂ ዔኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ዔኬስካፓ ሚዛቆ ኩጮ ኬኤሎና ዬያ ዛይቶፓ ዔኪ ዔኪ ላንካይ ማይንቲ ናንጊና ናንጋ ጎዳ ቤርታ ዉፁርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ሃሣ ዬያ ዛይቶፓ ዻካ ዔኪ ቤርታ ዒ ሱጉፆ ቲሽኬ ቤዞ፤ ጌይፃ፦ ዓሢኮ ሚዛቆ ዋዮ ቤርቶና ሚዛቆ ኩጮና ቶኮናኮ ዶኦሞ ኬኤሎንሢ ቲሽኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ዬካፓ ቄኤሳሢ ፔ ኩጮይዳ ዓቴ ዛይቶ ዓሢኮ ቶኦካ ዋሆንጎ፤ ዬያይዲ ዓሢኮ ጎሞ ጌኤሺፆ ዳምቦ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ዬያይዴስካፓ ዶኦሎንሢፓታቴያ ኪሮንሢፓ ፔቴማ ጎሜ ጌኤሺሢ ዛላ ማሂ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ዓቴማ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሃኣኮ ዒንጊፆና ዎላ ሺኢሾንጎ፤ ዬያይዲ ዓሢኮ ጎሞ ጌኤሺፆ ዳምቦ ኩንሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ዑፆይዳ ኬስካ ዶርዓ ዓኣ ዓሲ ዳምቦ ጎይፆና ጌኤሽኪፆሮ ዓይሢንታ ባኮ ማንቆ ማዒ ባሺንታያታቴ ማዺንታንዳ ዎጋ ያዺኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«ዒንሢሮ ማሂ ታ ዒንሢም ዒንጋንዳ፥ ካኣናኔ ዓጮ ዒንሢ ጌሌ ዎዶና ፔቴ ዓሲኮ ዎርቆ ማኣሮ ታኣኒ ቡኡዒሴያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ማኣሮ ዓዴ ቄኤሳሢ ኮይላ ዓኣዺ ‹ታ ማኣሮይዳ ቡኡዒሢጉዴ ባኣዚ ታ ዴንቄኔ› ጌይ ኬኤዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ዬካፓ ቄኤሳሢ ዴንዲ ቡኡዒፆ ዛጊ ዔራንዳሢኮ ቤርታዺ ማኣራ ዓኣ ሜሆ ቢያ ዓሢ ኬሳንዳጉዲ ኬኤዞንጎ፤ ያዺ ማዒባኣያታቴ ጋራ ዓኣ ሜሃ ቢያ ዒኢታንዳኔ፤ ዬያይዴስካፓ ጋሮ ጌሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ቡኡዒፃ ዓይጎታቴያ ዛጎንጎ፤ ዒዚ ዛጋንቴ ኮጮ ዶይሳኒ ጋዓ፥ ጮልዔ፤ ሃሣ ጊንሣ ዞቃንዳጉዴ ቡኡዒሢ ዓርቂ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ዬኖ ኬኤፄሎፓ ኬስኪ ላንካይ ኬሊ ሄላንዳኣና ዬይ ዎዺንቲ ዴዓንዳጉዲ ማሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ላንካሳ ኬሎና ቄኤሳሢ ጊንሣ ዛጎንጎ፤ ዒ ዛጋንቴ ቡኡዒፃ ኮጮይዳ ዳልጊ ዳልጊ ዓኣዻያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ቡኡዒፆና ዓዺንቴ ሹጮንሢ ቦኦኪንቲ ዔውቲ ጉርዶኮ ዙላ፥ ካንቶይዳ ኬኤሪንታንዳጉዲ ዓይሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ዬካፓ ኮጮኮ ጋሮ ዛላ ቢያ ዓርሲንቴም ዓርሲንቴ ባካ ቢያ ጉርዶ ዙላ ዒኢቴ ቤዛ ኬኤሪንታንዳጉዲ ማሆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ዬያይዴስካፓ ቦኦኪንቲ ዔውቴ ሹጮንሢ ቤዛ ሜሌ ሹቺ ጌሢንቲ ሜሌ ዾቃሌና ዹይ ዓይሢንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«ሹጫ ኬስኪ፥ ኮጫኣ ሜሌ ዾቃሌና ዹይንቴስካፓ ቡኡዒፆ ማላቴላ ላሚ ጴዼያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ቄኤሳሢ ዴንዲ ዛጋንዳያ ኮይሳኔ፤ ዒ ዛጋንቴ ቡኡዒፃ ጋሮይዳ ዳልጊ ዳልጊ ዴዴንዳ ማዒ ጴዼቴ ዬና ማኣሬላ ዒኢቴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ዬያሮ ዬና ማኣራ ሻሂንታንዳያ ኮይሳኔ፤ ሹጮንታ ሚፆንታ ሜኤቾና ባካኣ ቢያ ጉርዶኮ ዙላ ዒኢቴ ቤዛ ኬኤሪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ዬና ማኣሬላ ዎዺንቲ ዓኣንቴ ዓይጎ ዓሲያ ማዖም ዒኢካ ጌሌቴ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ዬኖ ማኣሬሎይዳ ጌሊ ላሄ ዓሲ ዓኣቴ፥ ሃሣ ሙኡዚ ዴዒ ሙዔ ዓሲ ዓኣቴ ማኣዓሢ ፔኤኮ ማስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«ጋዓንቴ ማኣራ ዹይንቲ ኮሽኬስካፓ ቄኤሳሢ ሙኪ ዛጋ ዎዶና ቡኡዒፃ ዳልጊ ዴንዳያ ማዒባኣቴ ዬኖ ማኣሬሎ ቡኡዒፃ ሃሼም ዳምቦ ጎይፆና ጌኤሺ ማዔሢ ዔርዞንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ዬኖ ማኣሮ ጌኤሻኒ ላምዖ ካፒ፥ ዻካ ዴኤሊ ዚቢቂ ሜንሥሢ፥ ዞቄ ሚዛጶ ፓቲሎና ሂሶጴ ዒላሺያኣ ዔኪ ሺኢኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ካፖይዳፓ ፔቴማ ጊኢሲ ዋኣሢ ዓልቃ ቤስካፓ ዱዖና ዋኣሢ ዓኣ ታሚ ቦኦቆይዳ ሹኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ዬካፓ ዴኤሎ ዚቢቆ ሚፆና ሂሶጶ ዒላዦና ሃሣ ሚዛጶ ዞቄ ፓቲሎና ሼምፖና ዓኣ ካፖማንታ ዋኣፆና ሱጉፆናይዳ ዓጊጋፓ ማኣሮ ላንካይ ማይንቲ ፑጮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ዬያይዲ ቄኤሳሢ ዬኖ ማኣሮ ካፖ ሱጉፆና ጌኤዦ ዋኣፆና ሼምፖና ዓኣ ካፖማና፤ ሃሣ ዴኤሎ ዚቢቆ ሚፆና ሂሶጴ ዒላዦና ዞቄ ሚዛጶ ፓቲሎናኣ ጌኤሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ዬካፓ ሼምፖና ዓኣ ካፖማ ጉርዶኮ ዙሎ ኬሲ ባራኒ ዴንዳንዳጉዲ ሃሾንጎ፤ ዬያይዲ ቡኡዒፃ ጴዼ ማኣሬሎ ጌኤሺፆ ዳምባ ኩማኔ፤ ማኣራኣ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","«ዬይ ቢያ ዑስካ ኬስካ ዶርዓ፥ ቃፃ፥ ዑስካ ኪፃ ባኣዚ፥ ዒላንታ፤ ዬያጉዲ ሃሣ ማኣዖና ማኣሪናይዳ ኬስኪ ጴዻ ቡኡዒሢ ዓርቄ ዎዶና ጌኤሺፆሮ ማዺ ኩንሦ ዎጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ፔቴ ባኣዚ ጌኤሺ፤ ሃሣ ዒኢቴያ ማዒፃ ዬያ ዎጎና ዱማዺ ዔርታኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ዓይጎ ዓሲኮዋ ማዖም ሃርጌ ዛላና ዓቲንቴይዳፓ ዓልቃ ባኣዚ ኬስኬቴ ዬይ ዓሢ ዒኢቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ዓሢኮ ዑፃፓ ዓልቃ ባካ ዓልቃ ጎይሣታቴያ ሃሼቴያ ዬይ ዓሢ ዒኢቴያኬ፤ ዬይ ዓልቃ ባካ ዒኢሳያ ማዓሢ ያዺዲኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ዬይ ዓሢ ላሄ ቤዛ ቢያ ዒኢቴያ ማዓንዳኔ፤ ሃሣ ዴዔ ባካኣ ቢያ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ዒዚ ላሃ ሻኣሎ ካኣሜ ዓሲ ዓኣቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ሃሣ ዒ ዴዔ ባኣዚ ቢያይዳ ዴዓ ዓሲ ቢያ ማኣዓሢ ፔኤኮ ማስኪ ዑፆዋ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ዬኖ ዓልቃ ባኮና ዓኣ ዓሢ ካኣማ ዓሲ ቢያ ማኣዓሢ ፔኤኮ ማስኪ ዑፆዋ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ዬይ ሃርጋ ዓሢ ጌኤሺ ማዔ ዓሲ ዑስካ ጩቺ ጩቴያ ማዔቴ ጩቲንቴ ዓሢ ማኣዓሢ ፔኤኮ ማስኪ፥ ዑፆዋ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ዬይ ሃርጋ ዓሢ፦ ቶጋኣና ዴዔ ኮኦራሢና ዖይቶና ቢያ ዒኢቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ሃሣ ዒ ዴዔ ባኮ ቢያ ካኣማ ዓሲ፤ ዬያጉዲ ሃሣ ዬያ ባኮ ዔኪ ሺኢሻ ዓሲ ማኣዓሢ ፔኤኮ ማስኪ ዑፆዋ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ዒ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ዬይ ሃርጋ ዓሢ ኩቺ ማስቱዋዖ ፔቴ ዓሲ ካኣሜቴ ዬይ ካኣሚንቴ ዓሢ ማኣዓሢ ፔኤኮ ማስኪ ዑፆዋ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ዬይ ሃርጎና ዓኣ ዓሢ ካኣሜ ዓይጎ ባኣዚያ ማዖም ዓጪና ማዦና ሜሄ ቢያ ሃሃይቆንጎ፤ ሚሢና ኮሺንቴ ሜሄ ማዔቴ ጋዓንቴ ዋኣሢና ማስኪንቶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«ዬይ ሃርጋ ዓሢ ዬኖ ዓልቂሳ ሃርጌሎይዳፓ ዻቄ ዎዶና ዎጎ ጎይፆ ጌኤሽኬያ ማዓኒ ላንካይ ኬሊ ሄላንዳኣና ዴዖንጎ፤ ሃሣ ማኣዓሢያ ፔኤኮ ማስኪ ዑፆዋ ጌኤሺ ዋኣሢና ማስኮንጎ፤ ዬካፓ ዒ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ሳላሳ ኬሎና ላምዖ ዶኦሌ ሃንጎ ላምዖ ኪሬ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዔኪ ሙኪ ናንጊና ናንጋ ጎዳ ቤርታ ቄኤሳሢም ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ዬያይዴስካፓ ቄኤሳሢ፥ ፔቴማ ጎሜ ጌኤሻኒ ዒንጎ ዒንጊሢ ማሂ ዓቴማ ጊንሣ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ዬያይዲ ቄኤሳሢ ዓሢ ጌኤሺፆ ዳምቦ ናንጊና ናንጋ ጎዳ ቤርታ ኩንሦንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«ዓይጎ ዓሲኮዋ ማዖም ዓሲ ሾይዣ ዜርፃ ዑፃፓ ኬስኪ ላኣሊንቴያ ማዔቴ ዬይ ዓሢ ዑፆ ቢያ ዋኣሢና ማስቶንጎ፤ ማዔቴያ ዒ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ዬይ ዜርፃ ሄሌ፥ ዓይጎ ማኣዖዋ ማዖም ዜዺ ዋኣሢና ማስኪንቶንጎ፤ ማዔቴያ ዬይ ባካ ሳዓ ዴንዲ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ፔቴ ዓሲ ላኣሊና ላሄቴ ላምዖንሢ ቢያ ዑፆ ዋኣሢና ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳኣና ዒኢቴያ ዔያታ ማዒ ዴዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«ላኣሊኮ ሻቱሞ ሙኪ ጴዼ ዎዶና ላንካይ ኬሊ ሄላንዳኣና ዒዛ ዒኢቴያ ማዖንጎ፤ ዬኖ ዓሴሎ ካኣማ ዓይጎ ዓሲያ ዴንዲ ሳዓ ዓማንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ዒዞኮ ሻቱሙማ ጴዼ ዎዶና ዒዛ ዴዓ ባኮና ላሃ ባኮና ቢያ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","ዒዛ ላሃ ሻኣሎ ማዔቴያ ዒዛ ዴዓ ባኮ ካኣሜ ዓሲ ቢያ ማኣዓሢ ፔኤኮ ማስኪ ዑፆዋ ፔኤኮ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ዒዛ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ሻቱማ ዒዞኮ ሙኪ ዓኣንቴ ዒዞና ዎላ ላሄ ዓቲንቄ ዓኣቴ ዬይ ዓሢ ላንካይ ኬሊ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ፤ ዒዚ ላሃ ሻኣላኣ ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«ፔቴ ላኣሊኮ ሻቱሞ ማዒ ሾኦታ ኬላፓ ዑሣ ዓኣዺ ሾኦታ ሱጉሢ ጴዼቴ ዬይ ጋፓንዳያ ሄላንዳኣና ሻቱማ ጴዻኣና ማዓሢጉዲ ዒኢቴያ ዒዛ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ዬማና ዒዛ ላሃ ሻኣሎ ማዔታቴያ ዴዓ ባካ ቢያ ዒኢቴያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ዬንሢ ባኮንሢያ ካኣማ ዓሲ ቢያ ዒኢቴያ ማዓሢሮ ፔኤኮ ማኣዓሢ ማስኪ ዑፆዋ ማስቶንጎ፤ ማዔቴያ ዴንዲ ሳዓ ዓማንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ሻቱማ ዒዞኮ ሙኪፆ ሃሼስካፓ ላንካይ ኬሊ ሄላንዳኣና ዒዛ ዴዖንጎ፤ ዬካፓ ዎጎ ዳምቦ ጎይፆና ዒዛ ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ሳላሳ ኬሎና ዒዛ ላምዖ ዶኦሌታቴያ ላምዖ ኪሬ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዔኪ ሙኪ ቄኤሳሢም ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ዬካፓ ቄኤሳሢ ፔቴማ ጎሜ ጌኤሻ ዒንጊሢ ማሂ፥ ዓቴማ ሚቺ ዒንጎ ዒንጊሢ ማሂ ዒንጎንጎ፤ ዬያይዲ ላኣሌሎኮ ጌኤሽኪፆ ዳምቦ ናንጊና ናንጋ ጎዳ ቤርታ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«ጉርዶ ባኣካ ዔያቶኮ ዓኣ፥ ዓፒሎና ማዢንቴ ፆኦሲ ዴሮና ካኣማ ማኣሮ ዔያታ ዒኢሱዋጉዲ፤ ሃሣ ዬያ ዒኢሲ ዔያታ ሃይቁዋጉዲ ዒስራዔኤሌ ዓሶ ዒኢሳ ባኣዚፓ ዱማሱዋቴ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ሃርጌ ዛላና ዓቲንቴይዳፓ ዓልቃ ባኣዚ ኬስካ ዓሲ፤ ሃሣ ጊንሣ ዓሲ ሾይዣ ዜርፃ ላኣሊንቴም ዒኢቴያ ማዔ ዓሲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ሻቱሞ ሙኬ ላኣሊ ዛላ፥ ዑስካፓ ሾኦታ ባኣዚ ኬስካ ዓቲንቄ ዛላኣ ማዖም ላኣሊ ዛላ፤ ዬያጉዲ ሻቱሞ ዛላና ዒኢቴ ላኣሊና ላሃ ዓሲም ቢያ ማዺንታ ዎጋ ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ዓኣሮኔኮ ላምዖ ዓቲንቆ ናኣቶንሢ ፆኦሲም ዱማዺባኣ ታሞ ናንጊና ናንጋ ጎዳም ሺኢሻኔ ጌይ ሃይቄስካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«ጫኣቁሞ ሳኣፂኖኮ ጎሞ ጌኤሽኪፆ ዔርዛ ጉኡፖ ዑፃ ሻኣሬና ታኣኒ ፔጋዺ ጴዻንዳሢሮ ጎኦቦ ዓፒሎ ጊዴና ዖኦኪ ዓኣዺ ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዞ ቢያ ኬሊቱዋንቴ ፔቴ ዔርቴ ኬሊና ጌላኒ ኮይሳያታሢ ኔ ጌርሲ ዓኣሮኔም ኬኤዜ፤ ዬያ ዒ ማዺባኣቴ ሃይቃንዳኣኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌላኒ ዒ ዳንዳዓሢ ጎሞ ጌኤሺፆም ማዓ ፔቴ ዚያ ጌማይ፤ ሚቺ ዒንጎ ዒንጊፆም ፔቴ ማራይ ዓዴ ዔኪ ሙኪኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","«ዒዚ ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌላንዳሢኮ ቤርታ ዑፆ ፔኤኮ ማስቲ፥ ሚዛጶ ሱኡፓሢና ኮሺንቴ ቃሚሾ ማኣዒ፥ ቆንፃሢያ ቱኡቶንጎ፤ ሃሣ ሚዛጶ ሱኡፓሢና ኮሺንቴ ቃልሾዋ ቱኪ፤ ጊንሣ ሱኡፓሢና ኮሺንቴ ቶኦካ ማሮ ባኮዋ ማሮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","«ዬያይዴስካፓ ዒስራዔኤሌ ዴራ ጎሞ ጌኤሺፆ ዛሎ ላምዖ ኮላይ፤ ሚቺ ዒንጎ ዒንጊሢም ማዓ ፔቴ ዓዴ ማራይ ዔኪ ዒዛም ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ዬካፓ ዒዚ ፔ ጎሞና ፔ ማኣሮ ዓሶ ጎሞ ጌኤሻኒ ፔቴ ዚያ ጌማይ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ዬያይዴስካፓ ላምዖ ዋኣሮንሢ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዔኪ ዓኣዺ ናንጊና ናንጋ ጎዳ ቤርታ ዒ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ዬካፓ ፔቴማ ናንጊና ናንጋ ጎዳም፤ ዓቴማ ጊንሣ ዓዛዜሌም ማዓሢ ዔራኒ ላምዖ ሹቺ ዔኪ ዒፃ ዓጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ዬያይዲ ዔሬስካፓ ናንጊና ናንጋ ጎዳም ማዔ ዋኣራሢ ጎሞ ጌኤሻኒ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ዓዛዜሌም ማዔ ዋኣራሢ ሳዛና ዓኣንቴ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሺ፥ ዴሮኮ ጎሞ ዔኪ ዓኣዻንዳጉዲ ዓሲ ናንጉዋ ዳውሎ ዳኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«ዬካፓ ፔ ጎሞና ፔ ማኣሮ ዓሶ ጎሞ ጌኤሻያ ማሂ ጌሜ ዔኪ ሙኪ ሹኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ናንጊና ናንጋ ጎዳም ሚቺ ዒንጎ ቤዞይዳፓ ታሚ ቄንሢ ዑንጆ ጩቢሶ ቦኦቆይዳ ኩንሢ፥ ካኣሺ ዔኪ፤ ሃሣ ዑዲንቲ ሺኢቴ ዑንጆ ፔቴ ሾኦፓና ዔኪ ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌልዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ዒኢካ ናንጊና ናንጋ ጎዳ ቤርታ ታሞይዳ ዑንጆ ዋሆንጎ፤ ዒዚ ጎሞ ጌኤሺፆ ዔርዛ ጉኡፖ ዛጊ ሃይቁዋጉዲ ዑንጆኮ ጩባ ዬያ ጉኡፖ ባይዛያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ሃሣ ጌሜኮ ሱጉፃፓ ዻካ ዔኪ ጎሞ ጌኤሽኪፆ ዔርዛ ጉኡፖይዳ ዓባ ኬስካ ባንፆና ኬኤላና ዉፁርቆንጎ፤ ሃሣ ጫኣቁሞ ሳኣፂኖ ቤርታኣ ላንካይ ማይንቲ ዒማ ዛሎና ዉፁርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«ዬካፓ ዴሮኮ ጎሞ ጌኤሻኒ ዒንጊንቴ ዋኣራሢ ሹኪ፥ ሱጉፆዋ ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌልዚ፥ ጌሜ ሱጉፆና ማዼ ጎይፆ ጎሞ ጌኤሽኪፆ ዔርዛ ጉኡፖ ዑፆይዳ፤ ጊንሣ ሃሣ ጫኣቁሞ ሳኣፂኖ ቤርቶይዳ ዉፁርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ዬያይዲ ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዛ ዒስራዔኤሌ ዴሮኮ ዻቢንቶና ጎሞናይዳፓ ቢያ ዱማዺ ጌኤሽኬያ ማዓንዳጉዲ ጌኤሺፆ ዳምቦ ኩንሦንጎ፤ ዎጎ ጎይፆ ዳምቤና ጌኤሺ ማዒባኣ ጉርዳ ሳዛይዳ ዓኣ፥ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ዛሎዋ ዒዞ ጎይፆ ማዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ዓኣሮኔ ጌኤሺፆ ዳምቦ ኩንሢፆሮ ፔ ጎሞና ፔ ማኣሮ ዓሶ ጎሞና፤ ሃሣ ዒስራዔኤሌ ዓሶ ጎሞዋ ጌኤሻኒ ታኣም ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌሌማፓ ዴንዲ ዒ ኬስካንዳያ ሄላንዳኣና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዖኦኒያ ጴዾፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ዬካፓ ዒ ኬስካዖ ናንጊና ናንጋ ጎዳ ቤርታ ዓኣ፥ ሚቺ ዒንጎ ቤዞ ሙኪ ዬኖ ቤዞዋ ጌኤሾንጎ፤ ዒማና ጌሜና ዋኣራሢናኮ ሱጉፃፓ ዻካ ዻካ ዔኪ ሚቺ ዒንጎ ቤዞኮ ዖይዶ ዛላ ዓኣ፥ ዻንኮ ቲሽኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ዒስራዔኤሌ ዴሮኮ ዻቢንቶና ጎሞናይዳፓ ታኣም ዒንጎ ባኮ ሺኢሾ ቤዞ ጌኤሺ፥ ዱማሳኒ ሱጉፆይዳፓ ኬኤላና ዔኪ ዔኪ ላንካይ ማይንቲ ዒኢካ ዉፁርቆንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«ዬካፓ ዓኣሮኔ ዑሣ ዓኣዼ ዱማዼ ቤዞ፥ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮንታ ፆኦሲም ዒንጎ ባኮ ሺኢሾ ቤዞ ጌኤሺፆ ዳምቦ ኩንሤስካፓ ዓሲ ናንጉዋ ዳውሎ ዳኪንታኒ ዶኦሪንቴ ዋኣራሢ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ዬያይዴስካፓ ፔኤኮ ላምዖ ኩጮ ዋኣራሢ ቶኦካ ጌሢ ዒስራዔኤሌ ዴሮኮ ዻቢንታ፥ ጎማ፥ ፑርቱሞንታ ቢያ ዬያ ዋኣራሢ ዑፃ ማዓንዳጉዲ ቡኡፂ፤ ዬያ ዋኣራሢ ዬኖ ማዾ ማዻንዳጉዲ ጌይንቴ ዓሢ ዓሲ ናንጉዋ ዳውሎ ዔኪ ዓኣዻንዳጉዲ ዳኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ዬይ ዋኣራሢ ዔያቶኮ ጎሞ ቢያ ዔኪ ዓሲ ናንጉዋ ዳውሎ ጉሮ ቦኦላ ዳኪንታኔ ጌይሢኬ፤ ዬይ ዓሢ ዋኣራሢ ዔኪ ዴንዲ ቦኦሎ ጉራ ዳኪ ሃሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«ዬካፓ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ዓኣሮኔ ጌሊ ዎንዴ ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌላኒ ጋዓዖ ማኣዔ ማኣዓሢ ኬሲ ዒኢካ ሃሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ታኣም ዱማዼ ቤዞይዳ ዑፆ ፔኤኮ ማስቲ፥ ቢያ ዎዴ ዒ ማኣዓ ማኣዓሢያ ማይንቶንጎ፤ ዬካፓ ኬስኪ ፔ ጎሞና ዴሮ ጎሞ ጌኤሻኒ ሚቺ ዒንጎ ዒንጊፆ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ጎሞ ጌኤሻኒ ዒንጊንቴ ቆልሞኮ ማሎ ሚቺ ዒንጎ ቤዞይዳ ሚቾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ቦኦሎ ዳኪንቴ ዋኣራሢ ዔኪ ዓኣዼ ዓሢ ጉርዶ ጌላንዳሢኮ ቤርታ ማኣዓሢ ፔኤኮ ማስኪ፥ ዑፆዋ ፔኤኮ ማስቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ጎሞ ጌኤሻኒ ቲቂ ሱጉፆ ዔኮና ቆልሞንሢ ጉርዳፓ ዙሎ ኬሲ ታሚና ሚቺንቶንጎ፤ ዔያቶኮ ዒልዓ፥ ዓሽካ፥ ጎጶ ባኮንታ ሶኦካኣ ቢያ ዓቱዋዖ ሚቺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ዬያ ሚቼ ዓሢ ማዒ ጉርዶ ጌላንዳሢኮ ቤርታ ፔኤኮ ማኣዓሢ ማስኪ ዑፆዋ ማስቶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«ሃካፓ ሊካ ኬኤዚንታ ዳምቦንሢ ኬስካ ዎዶ ቢያይዳ ማዺ ኩንሢ ካፑዋቴ፤ ላንካሳ ዓጊኖኮ ታጳሳ ኬሎና ዒስራዔኤሌ ዓሶንታ ዔያቶና ዎላ ናንጋ ሜሌ ዓጮ ዓሳ ሙኡዚ ሃሺ ሺኢቃንዳያ ኮይሳኔ፤ ዬኖ ኬሎና ዓይጎ ማዾዋ ማዾፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ዬኖ ኬሎ ዎጎ ጎይፆና ጌኤሺፆ ዳምባ ዔያቶም ማዺንታንዳሢሮ ዎጎ ጎይፆና ናንጊና ናንጋ ጎዳ ቤርታ ዔያታ ዳምቦና ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ዬና ሙዖ ሃሺንታዞና ማዾ ማዺንቱዋ ኬሌላ ታኣም ዱማዼያ ማዓንዳኔ፤ ዬንሢ ዳምቦንሢ ሙካ ዎዶ ቢያይዳ ካፒንቲ ናንጋያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ዓዶ ቤዞይዳ ቄኤሶ ቢያኮ ሱኡጋሢ ማዒ ዶኦሪንቴ ቄኤሳሢ፥ ዬያ ጌኤሺፆ ዳምቦ ኩንሦንጎ፤ ዒዚያ ሱኡፓሢና ኮሺንቴ ቄኤሶ ማኣዓሢ ማኣዒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ዑሣ ዓኣዼ ዱማዼ ቤዞ፥ ዓፒሎና ማዢንቴ ፆኦሲ ዴሮና ካኣማ ማኣሮ፥ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞንታ ቄኤሶንታ ዴሮዋ ቢያ ጌኤሺፆ ዳምቦ ማዺ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ዬንሢ ዳምባ ሙካ ዎዶ ቢያይዳ ካፒንቲ ናንጋያ ማዖም፤ ዬይ ጌኤሺፆ ዳምባ ዴሮ ጎማፓ ቢያ ጌኤሻኒ ሌዔይዳ ፔቴና ማዺንታያ ማዖንጎ» ጌዔኔ። ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆማ ሙሴ ዔቦ ማዺ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","2","«ዓኣሮኔና ናኣቶናም፤ ሃሣ ዒስራዔኤሌ ዴሮ ጉቤሢም ሃካፓ ሊካ ዓኣ ዳምቦ ኬኤዛንዳጉዲ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","ዒስራዔኤሌ ዓሲ ማዔ ዓይጎ ዓሲያ ማዖም ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ማዒባኣንቴ ሜሌ ቤስካ ባይ፥ ማራይ፤ ሃሣ ዋኣሪ ማዔቴያ ሹኪ ታኣም ዒንጎ ዒንጊሢ ማሂ ዒንጌቴ ዬይ ዎጎ ዻቤያ ማዓንዳኔ፤ ሱጉሢ ጉሪ ላኣሌያ ማዔሢሮ ታ ዴሮ ባኣካ ማዒ ዒ ፓይዲንታንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","«ዬያሮ ዒስራዔኤሌ ዴራ ዓይጎ ቆልሞዋ ማዖም ቦኦሊዳ ጉሪ ሹኪሢ ሃሺ ታ ቤርቶ ዔኪ ሺኢሻንዳያ ኮይሳኔ፤ ዬያ ዒንጎ ባኮ ዔያታ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ቄኤሳሢ ኮራ ዔኪ ሙኪ ፔቱሞና ዒንጎ ዒንጊሢ ማሂ ሹኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ዬካፓ ቄኤሳሢ ሱጉፆ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮይዳ ዓኣ፥ ሚቺ ዒንጎ ቤዞኮ ጎኦቦ ቢያ ፑጮንጎ፤ ሃሣ ታና ዎዛሳ ሳውሞ ዓኣያ ማዓንዳጉዲ ማሎ ሚቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ዒስራዔኤሌ ዴራ ታና ዔያታ ጉሙርቃ ጉሙርቂፆፓ ዻቢሻያ ማዔ ፑርቶ ዓያኖም ቆልሞ ፔኤኮ ሹኪ፥ ታና ናንጊና ናንጋ ጎዳሢም ዓይሢንቲሢ ዒፃንዳያ ኮይሱዋሴ፤ ዬያ ዒስራዔኤሌ ዴራ ማዾንዶ ዳምቤ ማሂ ሙካ ዎዶ ቢያይዳ ካፖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","«ዒስራዔኤሌ ዓሶ ባኣካፓ ዓይጎ ዓሲያ ማዖም ዔያቶ ባኣካ ናንጋ ሜሌ ዓጪ ዓሲያኣ ማዖም ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራቱዋንቴ ሜሌ ቤስካ ታኣም ሚቺ ዒንጎ ባኣዚ ማዔቴያ ሜሌ ዒንጊሢ ዒንጊ ጴዼቴ ዬይ ታ ዴሮ ባኣካ ማዒ ፓይዲንታንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«ዒስራዔኤሌ ዓሶይዳፓ ዓይጎ ዓሲያ ማዖም ዔያቶ ባኣካ ናንጋ ዓሲታቴያ ሱጉሢ ሙዓያ ማዔቴ ታኣኒ ሚርጌና ዒዛ ዒፃ ዓሲ ዒ ማዓንዳኔ፤ ታ ዴሮ ባኣካ ማሂ ታ ዒዛ ፓይዳዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ዓይጎዋ ማዖም ሼምፓ ዓኣ ማዢንቶኮ ቢያ ሼምፓሢ ዓኣሢ ሱጉሢዳኬ፤ ዴሮኮ ጎሞ ጌኤሻንዳጉዲ ዒንጎ ባኮ ዒንጎ ቤዞኮ ጎኦቦይዳ ሱጉፃ ዋሂንቶም ታኣኒ ጌዔሢ ዬያሮኬ፤ ሼምፓ ዓኣ ሱጉሢ ጎሜ ጌኤሻኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ዒስራዔኤሌ ዴሮ ማዔቴያ ዔያቶኮ ባኣካ ናንጋ ሜሌ ዓጮ ዓሳ ሱጉሢ ሙዑዋጉዲ ታኣኒ ላኣጌሢ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«ዒስራዔኤሌ ዓሲ ማዔቴያ ዔያቶ ባኣካ ናንጋ ሜሌ ዓጪ ዓሲ ዎጎ ጎይፆና ሙይንታኒ ዳንዳዓ ቦዖታቴያ ካፒ ኬሚ ዎዼቴ ሹኪ ሱጉፆ ሳዓ ላኣላዖ ዓጪና ሱጉፆ ሲንሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ፔቴ ፔቴ ሼምፓ ዓኣ ማዢንቶኮ ሼምፓሢ ዓኣሢ ሱጉፆይዳታሢሮ ዒስራዔኤሌ ዴራ ሱጉሢ ሙዑዋጉዲ ታ ላኣጌሢ ዬያሮኬ፤ ዬያ ሙዔ ዓይጎ ዓሲያ ታ ዓሶ ባኣካ ማዒ ፓይዲንታዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«ዒስራዔኤሌ ዓሲ ማዔቴያ ዔያቶ ባኣካ ናንጋ ሜሌ ዓጪ ዓሲያኣ ማዖም ሃይቄ ቆልሞታቴያ ቦዖ ዎዼ ቆልሞኮ ዓሽኪ ሙዔቶ ማኣዓሢ ፔኤኮ ማስኪ ዑፆዋ ማስቲ ዴንዲ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዖንጎ፤ ዬካፓ ዒ ዳምቦ ጎይፆና ጌኤሽኬያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ዒዚ ዬያይዲባኣያታቴ ጎሜ ማዼሢሮ ዒዛይዳ ሄላ ሜቶ ዒ ዔካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ‹ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ቤርታ ዒንሢ ናንጌ፥ ጊብፄ ዓጮ ዓሳ ማዻ ጎይፆ ማዺፖቴ፤ ሃሣ ታ ዒንሢ ጌልዛኒ ዔኪ ዓኣዻ፥ ካኣናኔ ዓጮ ዓሳ ማዻ ጎይፆ ጊኢጉዋ ማዾ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ታኣኮ ዎጎ ቢያ ካፑዋቴ፤ ታ ዓይሢፆዋ ኩንሡዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ታኣኒ ዒንሢም ዒንጋ ዳምቦና ዎጎና ጎይፆ ማዹዋቴ፤ ዬያይዴቴ ዒንሢ ሼምፓሢ ዒንሢኮ ዓውሳንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ዒንሢዳፓ ዖና ማዔቴያ ዒጊኒና ላሃንዳያ ኮይሱዋሴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ኔ ዒንዶና ላሂ ኔ ዓዶ ቦርሲሲፖ፤ ኔ ዒንዶዋ ዻውሲሲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ኔኤኮ ዒንዶ ሌጎንሢናኣ ላሂ ኔ ዓዶ ቦርሲሲፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ኔ ጌሮናኣ ላሂፖ፤ ሃሣ ኔኤና ዎላ ዲጬ፥ ኔ ዒንዳ ሜሌ ዓሲፓ ሾዔያ ማዔቴያ ኔ ዓዴ ሜሌ ዓሲፓ ሾዔያ ማዔ ኔ ጌሮና ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ዻውሲንቲ ኔኤኮ ማዑዋጉዲ ኔኤኮ ናኣዚ ናዎና ላሂፖ፤ ሃሣ ኔ ናዎኮ ናዖና ማዔቴያ ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ኔ ዒንዶ ሌጋ ሾዔ ዉዱሮ ናይ ኔኤኮ ጌሮታሢሮ ዒዞና ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","ኔኤኮ ዓዶ ጌሮና ዒንዶ ጌሮና ኔ ዓዶና ኔ ዒንዶናኮ ዑኬ ዒጊኒ ማዔሢሮ ዬያቶናኣ ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ኔ ዓዶ ዒሾ ማቾናታቴያ ኔ ዓዶ ጌኤዚ ማቻ ኔኤኮ ዒንዶ ማዔያታሢሮ ዔያቶና ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ኔኤኮ ናኣዚ ማቾናኣ ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ሃሣ ጌርሲ ማቾ ማዔ፥ ዎይሞናኣ ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ኔ ዞኦስካ ዎላ ኮኦማ ላኣሊኮ ናዎ ማዔቴያ ዒዞኮ ናኣዚ ናኣ ኔኤና ዒጊንቴያታሢሮ ዔያቶና ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ማቻ ኔኤኮ ሳዛና ዓኣንቴ ኔኤኮ ማቾኮ ጌሮ ጊንፃኣ ማቾ ማሂ ዔኪፖ፤ ዒዞና ላሂያ ላሂፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«ሻቱሞ ሙኪ ዓኣ፥ ላኣሊና ላሂፖ፤ ዓይጎሮ ጌዔቴ ዎጎ ጎይፆና ዒዛ ዒኢቴያታሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ሜሌ ዓሲኮ ላኣሊና ላሂ ኔና ዒኢሲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ናኣቶይዳፓ ኔኤኮ ዓይጎ ናይያ ማዖም ሞሎኬ ጌይንታ ፆኦዞም ሚቺ ዒንጎ ባኣዚ ማሂ ዒንጊ ኔ ፆኦሲኮ ሱንፆ ዒኢሲፖ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","ፆኦሲ ዒፃ ባኣዚታሢሮ ላኣሊና ላሃ ጎይፆ ዓቲንቄና ላሂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ዓይጎ ዓሲ ዓቲንቄታቴያ ላኣሊ ቆልሞና ላሆፓ፤ ዬያጉዴ ዻውሲሳ ባኣዚ ማዺፃ ዳምቦ ጎይፆና ዒኢቴያ ማሃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«ዔያቶኮ ዓጮ ዔኪ ኔና ጌልዛኒ ታኣኒ ዳውሴ፥ ሜሌ ዴራ ፔና ዬያ ባኮና ዒኢሴያታሢሮ ኔኤኒ ዬያ ባካፓ ፔቴማታዎ ማዺ ኔና ዒኢሲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ዔያቶኮ ማዻ ሳዖ ዒኢቴያ ማሄሢሮ ታኣኒ ዬኖ ሳዖም ሜቶ ዓጌኔ፤ ዬያሮ ዬና ሳዓ ዒኢካ ናንጋ ዓሶ ፔ ዻንጋፓ ጩቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","27","ዔያታ ዬያ ፑርቶ ባኮ ቢያ ማዺፆና ሳዖ ዒኢሴኔ፤ ዒንሢ ጋዓንቴ ዬያ ባኮ ቢያ ማዺፖቴ፤ ዒስራዔኤሌ ዓሶዋ ማዖም ዒኢካ ናንጋ ሜሌ ዓሲ ማዔቴያ ቢያሢ ዬያ ዎጎና ዳምቦና ዒንሢ ካፓንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ዒንሢያ ዔያቶ ጎይፆ ሳዖ ዒኢሴያ ማዔቴ ዒንሢኮ ቤርታ ዓኣ ዓይሁዴ ማዒባኣ ዓሶ ሳዓ ፔ ዻንጋፓ ጩቴ ጎይፆ ዒንሢያ ጩታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ዬንሢ ቦርሲሳ ባኮይዳፓ ፔቴማታዖ ማዻሢ ታኣኮ ዴሮ ባኣካ ማዒ ፓይዲንታኒ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","«ታኣኮ ዓይሢፆ ቢያ ኩንሡዋቴ፤ ዬያኮ ቤርታ ሳዔሎይዳ ናንጋ ዓሳ ማዻ ፑርቶ ማዾ ፔቴታዖ ማዺፖቴ፤ ዬያ ማዺሢና ዒንሢ ዒኢሲፖቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ‹ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዱማዼያታሢሮ ዒንሢያ ታኣም ዱማዼያ ማዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","ዒንሢ ፔቴ ፔቴሢ ዒንሢኮ ዓዶና ዒንዶና ቦንቹዋቴ፤ ታኣኒ ሃውሾንጎ ጌዔ ኬሎ ካፒ ቦንቹዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ።› ");
INSERT INTO mdyeth_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«ታና ሃሺ ሜሌ ፆኦዞ ካኣሽኪፖቴ፤ ዓንጊና ኮሾና ካኣሽኮ ባኣዚያ ማዢ ካኣሽኪፖቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«ፔቱሞና ዒንጊንታ ዒንጊፆ ታኣም ዒንሢ ዒንጋ ዎዶና ዒንሢኮ ዒንጊፆ ታ ዔካያ ማዓንዳጉዲ ማሂ ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ሹኪንቴ ዓሽካ ሹኪንቴ ዓቦ፥ ሃንጎ ዚሮ ጉቴ ሙይንታንዳያ ኮይሳኔ፤ ሃይሣሳ ኬሊ ሄላንዳኣና ዓቲ ዴዔቴ ዓሽካ ታሚና ሚቺንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ሃይሣሳ ኬሎና ሙይንቴቴ ዬይ ዒኢቴያኬ፤ ዬያ ታ ዔካ ዒንጊሢቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ዬያ ሙዔ ዓሢ ታኣም ዱማዼ ባኮ ሼሌዔ ባኣዚ ማሂ ዛጌሢሮ ዻቢንቲ ዒዛኮ ማዓንዳኔ፤ ዬይ ዓሢ ታ ዴሮ ባኣካ ማዒ ፓይዲንታዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«ዒንሢ ዒንሢኮ ማኣሎ ቡራ ዎዶና ጎዦኮ ዓጮ ዛሎይዳ ዓኣ ሃኣኮ ዔኪፖቴ፤ ቶሊ ዓቴ ሃኣኮዋ ጊንሣ ማዒ ዚንጊፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ዎይና ካፄም ኔ ማንፃ ዎዶና ዓቴ ዓኣፖንታ ሳዓ ዲኢኔሢንታ ላሚ ጊንሣ ሺሪ ማንፂፖ፤ ዬያ ቢያ ማንቆ ዓሶና ሜሌ ዓጪፓ ሙኬ ዓሶናም ሃሼ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«ዉኡቂፖቴ፤ ዓሲ ጌሺፖቴ፤ ሉኡቂፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ኔኤኒ ማዻኑዋ ባኣዚ ታ ሱንፆና ጫኣቂፖቴ፤ ዒንሢ ዬያይዳያ ማዔቴ ዒንሢኮ ፆኦዛሢ ሱንፆ ዒንሢ ዒኢሳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«ኔ ላጋሢም ፑርታ ማዺፖ፤ ሃሣ ዒዛኮ ዓኣ ባኣዚያ ቡሪ ዔኪፖ፤ ዬያጉዲ ሚኢሼ ዒንጊ ኔ ማዺሻ ዓሢኮ ሚኢሾ ፔቴ ዓቢያ ኔ ኮይላ ዎይሡዋዖ ቤዞና ዒዛም ጪጌ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ዋይዚ ባይቄ ዓሲ ጫሽኪፖ፤ ዓኣፒ ባይቄ ዓሲኮ ቤርታ ዹቃንዳ ባኣዚ ጌሢፖ፤ ኔኤኮ ፆኦዛሢ ዒጊጬ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«ዓሲም ጌስቲ ኔ ዎጋ ዎዶና ጉሙርቂንታያ ሃሣ ፒዜ ማዔ፤ ቢያሢም ሄኮ ዎጌ፤ ማንቃሢም ማንቃቶሮ ጌይ ዖርጎጫሢ ዖርጎቹሞሮ ጌይ ዱማሲ ዎጊፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ዓሲ ባኣካ ሃንቲ ሃንቲ ዓሲ ዾንኪ ሺሪፖ፤ ሃሣ ዓሲኮ ሼምፖ ባይዛኒ ዳንዳዓ ባኣዚያ ማዺ ሺሪፖ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«ኔኤኮ ጌርሲ ዒኔና ዒፂፖ፤ ዒ ዻቤ ባኣዚ ዓኣቴ ኔኤኮዋ ዬይ ዻቢንቲ ማዑዋጉዲ ፔጌና ጎሪ ዒዛ ዞሬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ኔ ዓሶ ዓዳ ኔና ማሂ ናሽኬ፤ ኮሜ ኮፂፖ፤ ሃሣ ኮሜ ዓርቂያኣ ዴዒፖ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«ታኣኮ ዳምቦ ካፑዋቴ፥ ዱማ ዱማ ቶኦኪ ማዔ ቆልሞ ሾዓንዳጉዲ ዎላ ካንሢ ቤኤሊሲ፥ ሃሣ ዓኪሲሲፖ፤ ጎሺዳ ላምዖ ቶኦኪ ማዓ ሃኣኮ ዜርቂፖ፤ ሃሣ ላምዖ ባኣዚ ዎላ ካንሢ ሱኪ ዹይሶና ማኣዖዋ ማይንቲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«ፔቴ ዓሲ ፔኤም ማዻ ዉዱሮ ናይ ሜሌ ዓሲም ጊኢጊሼስካፓ ናዔሎ ዔካሢ ሚኢሾ ጪጊ ዱኡዙዋንቴ ዒንጋ ዓሢ ዉዱሮ ናዔሎና ላሄቴ ላምዖንሢ ዎጎ ዻቤያ ማዒ ዖኦጪንታንዳኔ፤ ጋዓንቴ ዒዛ ዓሢ ማኣራፓ ጋፒ ኬስኪባኣሢሮ ዎዺ ዔያቶ ዎዻኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ዬይ ዓሢ ዻቢንቲ ዛላ ዒንጊንታ ዒንጊሢ ማዓ፥ ፔቴ ዓዴ ማራይ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ታ ቤርቶ ዔኪ ሙኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ዬካፓ ቄኤሳሢ ዬያ ዓሢኮ ጎሞ ጌኤሻኒ ዒንጎ ዒንጊፆ ዳምቦ ጎይፆና ዒንጊ ጌኤሺፆ ዳምቦ ኩንሦንጎ፤ ጎማኣ ዒዛኮ ዓቶም ጌይንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«ካኣናኔ ዓጮ ጌላዖ ዓይጎዋ ማዖም ዓኣፒ ዓኣፓ ሚሢ ዒንሢ ቱኬ ዎዶና ሚፆኮ ዓኣፓ ዴንዲ ሃይሦ ሌዔ ሄላንዳኣና ሙይንቱዋጉዲ ላኣጊንቴሢሮ ሙይፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ዖይዳሳ ሌዖና ዓኣፔ ዓኣፖ ታና ዒንሢ ጋላታንዳ፥ ታኣም ዒንጊንታ ዱማዼ ዒንጊሢ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ዶንጋሳ ሌዖና ጋዓንቴ ሚፆኮ ዓኣፖ ሙዑዋቴ፤ ዒንሢ ዬያይዴቴ ሚፃ ዒንሢኮ ቢያ ዎዴ ዓኣፓንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«ሱጉሢ ዓኣ ዓሽኪ ሙይፖቴ፤ ዦዋቶታቴያ ማርሻኣ ማርሺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ቶኦኮ ጋፓኖኮ ዴሞ ታይዚ ዛኣሪፖቴ፤ ቡኡጮዋ ዒንሢኮ ቃሚሢ ታይዚፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ዑፃኣ ዒንሢኮ ኮንኮ ጫርጊፖቴ፤ ሃሣ ሃይቄ ዓሶሮዋ ዑፆ ዒንሢኮ ቲቂ ኪፃሲፖቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«ዓይሁዴ ማዒባኣ ዓሶኮ ካኣዦ ማኣራ ማዺንታሢጉዲ ዉዱሮ ናዖ ኔኤኮ ዬያ ማዺሺ ዒኢሲፖ፤ ኔኤኒ ዬያይዴቴ ሜሌ ካኣሺ ኔ ካኣሽካኔ ጌይሢኬ፤ ሳዓኣ ዒኢቴ ማዾና ኩሜያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ታኣኒ ሃውሾንጎ ጌዔ ኬሎ ካፒ ቦንቹዋቴ፤ ታኣም ዱማዼ ማኣሮዋ ቦንቹዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«ኔኤኒ ዒኢቱዋጉዲ ሶይናሢና ዦዎና ኮራ ዓኣዺፖ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«ጋርቼ ዓሲም ዴዔ ቤዛፓ ዔቂ፥ ቦንቼ፤ ታናኣ ዒጊጪ ቦንቼ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«ዒንሢ ኮይላ ናንጋ፥ ሜሌ ዓጪፓ ሙኬ ዓሲም ጌኔ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ዒንሢ ዓሶም ዒንሢ ማዻማጉዲ ኮሺ ባኣዚ ማዹዋቴ፤ ዓዳ ዒንሢ ማሂ ዔያቶ ናሽኩዋቴ፤ ሃያኮ ቤርታ ዒንሢ ጊብፄ ዓጮይዳ ሙኬ ዓሲ ማዒ ናንጌሢ ማሉዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«ዒንሢ ማካ ባኮና ማዖም ዒንሢ ሚፃ ባኮና ዓሲ ጌሺ ማዾ ባኣዚ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ዒንሢ ማካ ባኮና ሚፃ ባካ ጉሙርቂንታያ ሃሣ ጎኔ ባኣዚ ማዖንጎ፤ ጊብፄ ዓጫፓ ዒንሢ ዔኪ ኬሴሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ዒንሢም ታኣኒ ዒንጌ ዳምቦንታ ዎጎንታ ማዺ ኩንሣያ ማዑዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«ዒስራዔኤሌ ዴሮም ሂዚ ጌይ ኬኤዜ፤ ዒንሢ ባኣካፓ ማዔቴያ ዒንሢና ዎላ ናንጋ ሜሌ ዓይጎ ዓሲያ ማዖም ሞሎኬ ጌይንታ ፆኦዞም ፔኤኮ ናኣቶይዳፓ ፔቴ ሚቺ ዒንጎ ዒንጊሢ ማሂ ዒንጋ ዓሢ ዴራ ሹቻ ዹይ ዎዾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ፔኤኮ ናዖ ሞሎኬም ዒንጊፆና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ጌኤዦ ማኣሮ ዒኢሳያ ማዔቴ ሃሣ ታኣኮ ሱንፆዋ ጫሽኪሳያ ማዔቴ ዬያ ዓሢኮ ታኣኒ ሞርኬ ማዓንዳኔ፤ ታ ዴሮ ባኣካፓ ታ ዒዛ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ጋዓንቴ ዬይ ዓሢ ማዼ ባኮ ቢያ ዴራ ዻኪሲ ዛጊ ዎዹዋዖ ሃሼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ታኣኒ ታኣሮ ዬያ ዓሢና ዒዛኮ ማኣሮ ዓሶ ጉቤ፥ ሃሣ ታኣም ጉሙርቂንቱዋያ ማዒ ሞሎኬ ካሽኪ፥ ዒዛና ዎላ ፔቴ ማዓ ዓሶይዳ ቢያ፤ ዼኤፒ ሜቶ ታ ዔኪ ዬዓንዳኔ፤ ታ ዓሶ ባኣካፓኣ ታ ዔያቶ ባይዛንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«ዓይጎ ዓሲያ ማዖም ዓሶ ሙዓ ዓሶና ዦኦና ኮይላ ዔኤቢ ዖኦጫኒ ዓኣዼቴ ዼኤፒ ሜቶ ታ ዒዛይዳ ዔኪ ዬዓንዳኔ፤ ታኣኮ ዴሮ ባኣካፓኣ ታ ዒዛ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ዒንሢኮ ዑፆ ጉቤ ታኣም ዱማዼያ ማሁዋቴ፤ ዓይጎሮ ጌዔቴ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢታሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ታኣኮ ዓይሢፆ ካፒ ማዻያ ማዑዋቴ፤ ዓይጎሮ ጌዔቴ ታኣኒ ዒንሢ ታኣም ዱማሳ፥ ናንጊና ናንጋ ጎዳኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«ፔ ዓዶና ፔ ዒንዶናም ጋዳንቃ ዓሲ ሹቻ ዹይንቲ ሃይቆም፤ ዬያ ሃይቦይዳ ዒ ጌላሢ ፔ ዻቢንቶናኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«ፔቴ ዓሲ ዓሲ ማቾና ላሄቴ ዒዛንታ ዒዞንታ ሹቻ ዹይንቲ ሃይቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ፔቴ ዓሲ ፔኤኮ ዒንዶ ሌጎና (ዒንዶና) ላሄቴ ዒዛንታ ዒዞንታ ሹጮና ዹይንቲ ሃይቆንጎ፤ ዬያይዲ ዔያታ ሃይቃሢ ዔያቶ ዻቢንቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ፔቴ ዓሲ ናኣዚ ማቾና ላሄቴ ላምዖንሢ ሹጮና ዹይንቲ ሃይቆንጎ፤ ዬያይዲፆና ዔያታ ፔኤኮ ዒጊንቶ ዒኢሴሢሮ ዔያታ ሃይቃሢ ፔ ዻቢንቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ፔቴ ዓሲ ዓቲንቄና ላሄቴ ላምዖንሢ ቦርሲሳ ባኣዚ ማዼሢሮ ላምዓሢ ሹጮና ዹይንቲ ሃይቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ዬያይዲ ዔያታ ሃይቃሢ ዔያቶ ዻቢንቶናኬ። ፔቴ ዓሲ ዒንዶንታ ናዎንታ ዎላ ዔኬያ ማዔቴ ዬያ ዒ ማዼ ዻውሲሳ ማዾሮ ሃይሣሢ ታሚና ሚቺንቲ ሃይቆንጎ፤ ዬያጉዴ ማዾ ዒንሢ ባኣካ ማዺንታኒ ኮይሳያቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ፔቴ ዓሲ ቆልሞ ዒኢሴቴ ዬያ ዓሢንታ ቆልሞማንታ ዎላ ሹጮና ዹይንቲ ሃይቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ፔቴ ላኣሊ ቆልሞና ዒኢቴያ ማዔቴ ዒዞንታ ቆልሞማንታ ዎላ ቢያ ሹጮና ዹይንቲ ሃይቆንጎ፤ ዔያታ ሃይቃሢያ ፔ ዻቢንቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«ፔቴ ዓሲ ፔ ዓዶ ናይ፤ ጊንሣ ሃሣ ዒንዳ ሜሌ ቤስካፓ ሾዔ ጌሮ ዔኬያ ማዔቴ ዴሮ ቤርቶ ሺኢኪ፥ ዻውሲሳ ማዻ ዒዛኮ ዔርቴም ዴሮ ባኣካፓ ዴንዲ ባይቆም፤ ፔ ጌሮና ላሂ፥ ዻውሲንቴ ዻውሲንቶ ዒ ፔኤኮ ዳንዳዖም። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ፔቴ ዓሲ ሻቱሞ ሙኪ ዓኣ ላኣሊና ላሄቴ ላምዖንሢ ዴሮ ባኣካፓ ዱማዺ ባይቆንጎ፤ ዓይጎሮ ጌዔቴ ዒኢቲፆ ዔርዛ ዎጎኮ ዔያታ ዑሣ ዓኣዼሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«ፔቴ ዓሲ ዓዶ ጌሮና ማዖም ዒንዶ ጌሮና ላሄቴ ላምዖንሢ ዒጊኒታዖ ዬያ ማዼሢሮ ዬያ ዛሎ ዓጊንታ ሜቶ ዔያታ ዔካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ፔቴ ዓሲ ዓዶ ዒሾ ማቾና ማዖም ዓዶ ጌኤዚ ማቾና፤ ሃሣ ዓቦ ማቾና ላሄያ ማዔቴ ዬያ ማዺፆና ዬኖ ዓሶ ዻውሲሴያ ማዔሢሮ ዬያ ዛሎ ዒጊንታ ሜቶ ዔያታ ዔካንዳኔ፤ ናይ ሾውዋዖዋ ዔያታ ሃይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ፔቴ ዓሲ ፔኤኮ ጌርሲ ማቾ ጌርሲ ሃይቁዋንቴ ዔኬቴ ዬይ ዓሢ ዒኢቴያ ማዓኔ፤ ሃሣ ጌርሲያ ዒ ዻውሲሴሢሮ ናይ ባኣያ ማዒ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«ዒንሢ ናንጋንዳጉዲ ታኣኒ ዒንሢ ጌልዛንዳ፥ ካኣናኔ ዓጫ ፔ ዻንጋፓ ዒንሢ ጩቱዋጉዲ ታኣኮ ዳምቦና ዎጎና ካፒ ማዻያ ማዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ዒንሢኮ ቤርታፓ ታ ዳውሳንዳ፥ ዒኢካ ናንጋ ዓሳ ማዻ ባኮ ማዺፖቴ፤ ዔያታ ዬያ ባኮ ቢያ ማዻሢሮ ታ ዔያቶ ሻኣኪንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ዔኤዞና ዲኢቆና ኩሜ፥ ማሎ ዓጬሎ ዒንሢ ዻካልሳኒ ታኣኒ ጫኣቄኔ፤ ዒንሢ ዓጪያ ማሂ ታ ዒንሢም ዒንጋንዳኔ፤ ሜሌ ዴሮይዳፓ ዒንሢ ዱማሴሢ ታና፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ዬያሮ ሙይንታንዳ፥ ሻቲ ማዔሢንታ ማዒባኣ ቆልሞና ቦዖና ካፖዋ ዱማሲ ዔሩዋቴ፤ ሙይንታኑዋ ቄፄ ማዔ ቆልሞ፥ ካዮ ቦዖንታ ካፖንታ ሙይፖቴ፤ ዒኢቴ ባኣዚ ማዔሢ ታ ዒንሢም ኬኤዜሢሮ ዔያቶ ሙዔቴ ዒንሢ ዒኢታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ዒንሢ ታኣም ዱማዼያ ማዑዋቴ፤ ዓይጎሮ ጌዔቴ ታኣኒ ዱማዼያኬ፤ ዒንሢ ታ ዴሬ ማዓንዳጉዲ ሜሌ ዴሮ ባኣካፓ ታ ዒንሢ ዶኦሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«ዓሶ ሙዓ ዓሶና ዦኦና ኮራ ዔኤቢ ዖኦጫኒ ዓኣዼ፥ ዓቲንቄ ማዔቴያ ላኣሊ ሹጮና ዹይንቲ ሃይቆንጎ፤ ዬይ ዓሳ ዬያይዲ ሃይቃሢ ፔ ዻቢንቶናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","4","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዓኣሮኔ ፃጳፓ ማዔ ቄኤሶም ሂዚ ጌዔ፤ ቄኤሴ ማዔ ዓይጎ ዓሲያ ዒጊኒ ሃይቄ ዎዶና ዒንዶ፥ ዓዶ፥ ዓቲንቆ ናዖ፥ ዉዱሮ ናዖ፥ ጌርሲንታ ሌዒ ባኣዖ ጋራ ዓኣ ጌሮንታኮ ሌሲ ማዒባኣንቴ ዔፒ ዛላና ዒጊንቴ ዒጊኒኮ ሌሲ ካኣሚ ፔና ዒኢሶፓ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«ዓይጎ ቄኤሴ ማዔቴያ ሃይቄ ዓሲ ዛላ ሲዪ፥ ፔኤኮ ቶኦኮ ጉኡሎፓ፤ ቡኡጮዋ ቲቂ ቃሚሢ፥ ዑፆዋ ፔኤኮ ሙርቶፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ቄኤሴ ቢያ ታኣም ዱማዼያ ማዒ ሱንፆ ታኣኮ ጫሽኪሱዋያ ማዖንጎ፤ ሃሣ ዒዚ ታኣም ሙዖ ዒንጊፆ ዒንጋያ ማዔሢሮ ታኣም ዱማዼያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ቄኤሴ ማዔ ዓሲ ካኣዦ ማኣሮይዳ ናንጋ ላኣሎ ማዔቴያ ዞኦዛ ኮኦማ ላኣሊ ማዔቴያ ሃሣ ዓንጂንቲ ኬስኬ ላኣሊ ዔኮፓ፤ ዓይጎሮ ጌዔቴ ቄኤሴ ቢያ ታኣም ዱማዼያ ማዓኒ ኮይሳሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ቄኤሴ ታኣም ሙኡዚ ዒንጊሢ ዒንጋያታሢሮ ዴራ ታኣም ዱማዼያ ማሂ ዔያቶ ዛጎንጎ፤ ታኣኒ ዒንሢ ታኣም ዱማሳ፥ ናንጊና ናንጋ ጎዳሢ ዱማዼያታሢሮ ዔያታ ዒንሢ ቤርታ ታኣም ዱማዼያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ቄኤሴኮ ዉዱሮ ናይ ካኣዦ ማኣራ ናንጊ ዞኦስካ ኮኦማያ ማዔቴ ዓዶ ዒዛ ዻውሲሳሢሮ ታሚና ሚቺንቲ ሃይቆንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«ቄኤሶ ቢያኮ ሱኡጋሢ ዛይቶ ቲዦና ቲሽኪንቴያ፤ ቄኤሶ ማኣዓሢያኣ ማይንታንዳጉዲ ታኣም ዱማዼያ ማዔሢሮ ዓሲ ሃይቄ ዎዶና ሲዬ ዔርዛኒ ቶኦኮ ፔኤኮ ጉኡሊንቲ ማኣዓሢያ ዳርዞፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","ዒዚ ታኣም ዱማዼያታሢሮ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣራፓ ኬስኪ ዴንዲ፥ ሃሣ ዓዶኮ ማዔቴያ ዒንዶኮ ሌሲ ዓኣ ቤሲታቴያ ሜሌ ዓሲ ሌሲ ዓኣ ቤሲ ጌሊ ፔና ዒኢሶፓ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ዬይ ቄኤሳሢ ኩሙሢ ዉዱሮ ናይ ዔኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ዓኒ ሃይቄ ላኣሊ፥ ዓንጂንቲ ኬስኬ ላኣሊታቴያ፤ ሃሣ ካኣዦ ማኣራ ናንጋ፥ ዞኦዛ ኮኦማ ላኣሊያ ዔኮፓ፤ ጋዓንቴ ፔ ዴሮ ባኣኮይዳፓ ኩሙሢ ዉዱሮ ናይ ዔኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ዬይ ያዺ ማዒባኣያታቴ ታኣም ዱማዼያ ማዓኒ ኮይሳ፥ ዒዛኮ ናኣታ ዳምቦ ጎይፆና ዒኢቴያ ማዓንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ፤ ዒዛ ታኣም ዱማሳሢ ታናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«ዓኣሮኔም ሂዚ ጌይ ኬኤዜ፤ ‹ኔ ፃጶይዳፓ ጉንዖ ማዔ ዓሲ ታኣም ሙኡዚ ዒንጊሢ ሺኢሺ ዒንጋኒ ኮይሱዋሴ፤ ዬይ ዳምባ ሙካ ዎዶ ቢያይዳ ካፒንቲ ናንጋያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ጉንዖ ማዔ ዓይጎ ዓሲያ ጌይፃ፦ ዓኣፒ ባይቄ ዓሲ፥ ዎቦ ማዔቴያ ሚዛጱዋ ዓሲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ኩቺ ማዔቴያ ቶኪ ዎቦ ዓሲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ጊኢሬ ዎቤ ዓሲታቴያ ቃሚሢ ዓሲ፥ ዓኣፒ ሃርጌ ዓኣ ዓሲ፥ ዱማ ዱማ ዑሢዳ ኬስካ ዶርዓ ዓርቄ ዓሲ፤ ሃሣ ዓሽቲሚ ሙኡዚ ዒንጊሢ ታኣም ሺኢሺ ዒንጋንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ቄኤሳሢ ዓኣሮኔ ፃጳፓ ጉንዖ ማዔ፥ ዓይጎ ዓሲያ ሙኡዚ ዒንጊሢ ታኣም ሺኢሺ ዒንጋኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ዬያጉዴ ዓሢ ታኣም ዱማዼ ሙዖና ዑሣ ዓኣዼ ታኣም ዱማዼያ ማዔ፥ ታኣም ሺኢሺንቴ ሙዖ ሙዓኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ጋዓንቴ ዒዛኮ ጉንዖ ማዔ ዑሢ ዓኣሢሮ ታኣም ዱማዼ ማኣሮ ዒኢሱዋጉዲ ታኣም ዱማዼ፥ ጎኦቦና ዓፒሎና ሚቺ ዒንጎ ቤዞና ባንሢ ዑኮፓ፤ ቄኤሶ ታኣም ዱማሴሢ ታና ናንጊና ናንጋ ጎዳኬ› » ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ዬያ ባኮ ቢያ ዓኣሮኔና ናኣቶናም፤ ሃሣ ዒስራዔኤሌ ዴሮማኣ ቢያ ሙሴ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«ዓኣሮኔና ዒዛኮ ናኣቶናም ሂዚ ጌዔ፤ ታኣኮ ዱማዼ ሱንፆ ዒንሢ ጫሽኪሱዋጉዲ ዒስራዔኤሌ ዴራ ታኣም ዒንጋ ባኮ ቢያ ቦንቺ ዔኪጋፓ ታኣም ዱማዼያ ማሂ ካፑዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ዒንሢ ፃጳፓታዖ ዒኢቴ ዓሲ ዒስራዔኤሌ ዴራ ታኣም ዱማሲ ዒንጌ ዒንጊፆ ባንሢ ጫርቂ ዑኬቴ፥ ታ ቤርታፓ ዬይ ባይቆንጎ፤ ዬይ ዳምባ ሙካ ዎዶ ቢያይዳ ካፒንቲ ናንጋያ ማዖንጎ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«ዓኣሮኔ ፃጳፓ ማዔ ዓይጎ ዓሲታቴያ ዑስካ ኬስካ ዶርዓ ዓኣያ ማዔቴ፤ ሃሣ ሃርጌ ዛላና ዑስካፓ ዓልቃ ባኣዚ ዓኣ ዓሲ ዳምቦ ጎይፆና ጌኤሽካንዳያ ሄላንዳኣና ታኣም ዱማዼ ሙዖ ሙዖፓ፤ ዬያጉዲ ሃሣ ሌሲ ካኣሚ ዒኢቴ ባኣዚታቴያ ሾይዣ ዜርፃ ሾኦቴ ዓሲ ካኣሜቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ዒኢሳያ ማዔ፥ ሳዓና ጎቺንቲ ሃንታ ባኮታቴያ ዒኢቴያ ማዔ ዓሲ ካኣሜቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ዬያጉዴ ባኮ ቢያ ካኣሜ ቄኤሳሢ ዴንዲ ዒባኒ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ፤ ዑፆ ዋኣሢና ማስቲባኣቴ፥ ታኣም ዱማዼ ዒንጊፆ ዒ ሙዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ዓባ ጌሌስካፓ ዒ ጌኤሺ ማዓንዳሢሮ ታኣም ዱማዼ፥ ሃኣኮ ዒንጊፆ ዒዛሲ ዒ ሙዓኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ሃይቄያ፥ ሃሣ ቦዖ ዎዼ ባኣዚኮ ዓሽኪ ሙዖፓ፤ ዬያ ሙዔቴ ዒዛ ዒኢሳንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«ቄኤሳ ቢያ ታኣኒ ዔያቶም ዒንጌ ዳምቦ ካፖንጎ፤ ዬያ ዔያታ ካፒባኣቴ ጋዓንቴ ዓይሢንቲፆ ዒፂፃ ዻቢንቲ ዔያቶኮ ማዔም ዔያታ ሃይቃንዳኔ፤ ታኣኒ ዔያቶ ታኣም ዱማሳ፥ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«ታኣም ዱማዼ፥ ዒንጊንቴ ባኮ ሙዓኒ ዳንዳዓሢ ቄኤሳሢ ማኣሮ ዓሶ ሌሊኬ፤ ቄኤሳሢኮ ሾኦቺ ማዔቴያ ሚኢሼ ጪጊንቴም ዒዛም ማዻ ዓሲያ ሙዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ጋዓንቴ ቄኤሳሢ ፔኤኮ ሚኢሼና ሻንቂ ዔኬያና ዒዛኮ ማኣራ ሾይንቴያ ማዔ፥ ዒዛም ማዻ ዓሳ ቄኤሳሢሮ ማዔ ሙዖ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ቄኤሴ ማዒባኣ ዓሲም ሌዔ፥ ቄኤሳሢኮ ናይ ታኣም ዱማዼ ሙዖ ሙዎፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ጋዓንቴ ዬና ናዔላ ናይ ሾዑዋንቴ ዓኒ ሃይቄያ ማዔም ዓኒ ማኣራፓ ዓንጂንቲ ኬስኪ ዓዶ ኮይላ ሙኪ ናንጋ ቄኤሴ ናይታቴ ቤርታ ናይ ዓኣዖ ዒዛ ማዻሢጉዲ ዓዶ ዛሎ ማዔ፥ ታኣም ዱማዼ ሙዖ ሙዎንጎ፤ ዬያ ጎይፆና ታኣም ዱማዼ ባኮ ሙዓኒ ዳንዳዓ ዓሳ ቄኤሳሢ ማኣሮ ዓሶ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«ቄኤሴ ማኣሪ ዓሲ ማዒባኣ ዓይጎ ዓሲያ ማዖም ዔሩዋዖ ታኣም ዱማዼ ሙዖ ሙይ ጴዼቴ ዒንጊንቴ ባኮኮ ዶንጎ ኩቺፓ ፔቴ ማዓያ ጊዳ ቃሲ ቄኤሳሢም ማሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ዒስራዔኤሌ ዴራ ታኣም ዒንጋ፥ ዱማዼ ዒንጊፆ ቄኤሳ ዒኢሳንዳያ ኮይሱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ጌይፃ፦ ታኣም ዱማዼ ዒንጊፆ ሙዓኒ ኮይሱዋ ዓሲም ዒንጊ ዓሢ ሜቶይዳ ጌልዙዋጉዲኬ፤ ዒንጊፆ ቢያ ታኣም ዱማሳሢ ታና፥ ናንጊና ናንጋ ጎዳሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«ዓኣሮኔና ዒዛኮ ናኣቶና፤ ሃሣ ዒስራዔኤሌ ዴሮም ቢያ ሃይፓ ዴማ ዓኣ ዳምቦ ኬኤዜ፤ ዒስራዔኤሌ ዓሲ ማዔቴያ ዔያቶ ባኣካ ናንጋ ሜሌ ዓጪ ዓሲ ፆኦሲም ናኣቤ ናኣቢ ኩሜም፥ ሃሣ ፔ ሼኔና ታኣም ሚቺ ዒንጎንዶ ባኣዚ ዔኪ ሺኢሻያ ማዔቴ ዒንጊንታ ባካ ዓይጌያ ቦሂሳ ባኣዚ ባኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ዒዛኮ ዒንጊፆ ታ ዔካያ ማዓንዳጉዲ ዔኤቢ ቦሂሳ ባኣዚባኣያ ባይ፥ ማራይ፥ ዋኣሪ ማዔቴ ጌማይ ሃንጎ ዓዴ ዔኪ ሺኢሾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ዔኤቢ ቦሂሳ ባኣዚ ዓኣ፥ ዓይጎ ቆልሞዋ ዒንሢ ታኣም ዒንጌቴ ዬያ ታ ዔካዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ዓይጎ ዓሲኮዋ ናኣቤ ናኣባ ኩሜም፤ ሃሣ ፔ ሼኔና ዒንጎ ባኣዚ ፔቱሞና ዒንጎ ዒንጊሢ ማሂ ዒንጋቴ ታኣኒ ዬያ ዔካያ ማዓንዳጉዲ ቦሂሳ ባኣዚባኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ዓኣፒ ባይቄያ፥ ሜቄያ፥ ቶኪ ዱጴያ፤ ዬያጉዲ ሃሣ ጊኢሽካ ኪሢ ዓኣያ፥ ቃፃ ዓርቄያንታ ዑፃ ሜሌ ኪሢ ዓኣ ቆልሞ ታኣም ዒንጎ ዒንጊሢ ማሂ ዔኪ ሺኢሾፓ፤ ዬንሢጉዴ ቆልሞ ሚቺ ዒንጎ ቤዞይዳ ሙኡዚ ዒንጊሢ ማሂ ዒንጊፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ባይታቴያ ማራይ ዎቦ ማዔ ቆልሞ ዓሲ ፔ ሼኔና ዒንጋ ዒንጊሢ ማሂ ዒንጋኒ ዳንዳዓኔ፤ ጋዓንቴ ናኣቢ ኩንሥሢ ማሂ ዬይ ዒንጊንታኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ፂኢቄ ዹይንቴ ቆልሞንታ ጌኒንቴ ቆልሞ ማዔቴያ ታኣም ዒንጎ ባኣዚ ማሂ ዔኪ ሺኢሺፖቴ፤ ዬያጉዴ ባኣዚ ዒንሢ ዓጫ ታኣም ሺኢሺ ዒንጊፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","«ዬያጉዴ ቆልሞ ሜሌ ዓጪ ዓሲዳፓ ዔኪ ታኣም ሙኡዚ ዒንጊሢ ማሂ ዒንጊፖቴ፤ ዬያ ቆልሞኮ ቦሂሳ ባኣዚ ዓኣያታሢሮ ታኣኒ ዬያ ዒንጊፆ ዔካያቱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«ናኣሪታቴያ ማራናይ፤ ሃሣ ዋናናይ ሾይንቴ ዎዶና ላንካይ ኬሊ ሄላንዳኣና ዒንዶና ዎላ ዴዖንጎ፤ ጋዓንቴ ሳላሳ ኬላፓ ዓርቃዖ ሙኡዚ ዒንጊሢ ማዒ ታኣም ዒንጊንታኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","«ሾዔ ባይ ናኣሮማና ዎላ፥ ማራይታቴያ ዋኣሪ ናዖና ዎላ ሚቺ ዒንጎ ዒንጊሢ ማሂ ፔቴ ኬሊዳ ሹኪፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ጋላታ ዒንጊሢ ታኣም ዒንሢ ዒንጋ ዎዶና ዒንጊፆ ታ ዔካያ ማዓንዳ ጎይሢ ማሂ ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ዚሮ ሄላንዳኣና ዓይሱዋዖ ዒንጊንቴ ኬሎና ዓሽኮ ጋፒሲ ሙዑዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«ታኣኮ ዓይሢፆ ካፒ ማዻያ ማዑዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ታኣኮ ዱማዼ ሱንፆ ጫሽኪሲፖቴ፤ ዒስራዔኤሌ ዴራ ቢያ ታኣኒ ዱማዼያታሢ ዔሪ ታና ቦንቾንጎ፤ ዒንሢ ታኣም ዱማሳሢ፥ ታና ናንጊና ናንጋ ጎዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ታ ዒንሢኮ ፆኦሲ ማዓኒ ጊብፄ ዓጫፓ ዒንሢ ዔኪ ኬሴኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ‹ፆኦሲ ካኣሽካኒ ቡኪንቶ ቦንቾ ኬሊ› ጌይ ዒንሢ ዱማሲ ቦንቻንዳ ኬላ ሃኣቶኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ላሆ ኬሊ ማዾ ዒንሢኮ ማዹዋቴ፤ ላንካሳ ኬላ ጋዓንቴ ሃውሺ ቦንቾ ኬሊታሢ ዔሩዋቴ፤ ዬማ ኬሎ ታና ካኣሽካኒ ሌሊ ቡኪንቱዋቴ፥ ሜሌ ማዾ ማዺፖቴ፤ ዒንሢ ናንጋ ቤዞ ቢያይዳ ሃውሾ ኬላ ታኣም ዱማዼያኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«ፔቴ ፔቴ ቦንቾ ኬላ ዔርቴም፤ ናንጊና ናንጋ ጎዳ ቤርታ ዒንሢ ቡኪ ቡኪ ቦንቻንዳ ዼኤፖ ዼኤፖ ኬሎንሢ ሃኣቶኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ናንጊና ናንጋ ጎዳ ቦንቺንታንዳ፥ ዑሣ ዓኣዺፆ ኬላ ቦንቺንቶ ዓርቃሢ ቤርታሳ ዓጊኖኮ ታጶ ዖይዳሳ ኬሎ ዓባ ጌሊ ሳዓ ሃባርታዛኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ታጶ ዶንጋሳ ኬሎ ላኣዶ ሙዒ ቦንቾ ኬላ ቦንቺንቶ ዓርቃኔ፤ ዬማፓ ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ዬያቶ ኬሎኮ ቤርታሳ ኬሎ ታና ካኣሽካኒ ቡኪንቱዋቴ፤ ዒንሢ ማዾ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ላንካይ ኬሊ ሄላንዳኣና ሙዖ ዒንጊፆ ታኣም ሺኢሹዋቴ፤ ሳላሳ ኬሎና ዒንሢ ማዾ ሃሺ ታና ካኣሽካኒ ቡኩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ታኣኒ ዒንሢም ዒንጋ ሳዔሎ ጌላዖ ጎሽኪ ማኣሎ ዒንሢ ቡራ ዎዶና ቤርታሳ ናኣሮ ቄኤሳሢም ዔኪ ዬይ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ዬካፓ ዬያ ታ ዔኬያ ማዓንዳጉዲ ቄኤሳሢ ናኣሮ ዡጊ ታኣም ዱማዼ ዒንጊሢ ማሂ ዒንጎንጎ፤ ዬያ ዒዚ ዒንጋኒ ኮይሳሢ ሃውሾ ኬሎኮ ዚሮ ጉቴ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ዒንሢ ሃኣኮ ዒንጊፆ ዒንጋ ኬሎና ቦሂሳ ባኣዚባኣ፥ ፔቴ ሌዔ ማዔ ዓዴ ማራናይ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሃኣኮና ዎላ ዔኪ ናንጊና ናንጋ ጎዳም ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ሃሣ ዬያና ዎላ ሪሚቶ ዛይቶና ዲርኪንቴ፥ ላምዖ ኪሎ ማዓ ሺኢቺ ዺኢሊ ሙኡዚ ዒንጊሢ ማሂ ዔኪ ሺኢሹዋቴ፤ ዬያኮ ሳዋ ታና ዎዛሳ ሚቺ ዒንጎ ዒንጊሢ ማዖንጎ፤ ሃሣ ፔቴ ዶሎዜ ማዓንዳ ዎይኔ ዑሺያ ዔኪ ሙኪ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ዬያ ዒንሢ ታኣም ዒንጋንዳሢኮ ቤርታ ዓኮ ሃኣኮኮ ቲሻሢ ዓኣዔ ማዔቴያ ሻኣቂ፤ ሃሣ ዎዺ ላኣዲያ ሙይፖቴ፤ ዬይ ዒንሢ ናንጋ ቤዞ ቢያይዳ ሙካ ሾይንታ ካፒ ናንጋ ዳምቤ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«ዡጊ ዒንጊንታ ዒንጊፃ ዒንጊንቴ ኬላፓ ሴካ ላንካይ ቃልሾ ኬሊ ፓይዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ላንካሳ ቃልሾኮ ዶንጊታሚ ኬሊ ማዓ ዓቦና ላሚ ዬኖ ዓኮ ሃኣኮይዳፓ ሙኡዚ ዒንጊሢ ታኣም ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ዒዞ ኬሎና ፔቴ ፔቴ ዓሳ ፔ ማኣራፓ ላምዖ ኪሎ ማዓ ዛይቴና ዲርኪንቴ ዺኢሊ፥ ሙኑቃ ፃኣዛ ዋሂ ላምዖ ኪሎ ማዓ ሺኢቺ ዺኢሊና ላኣዶና ላኣዳ ዡጊ ዒንጊንታ ዒንጊሢ ማሂ ዒንጎንጎ፤ ዬያ ሃኣኮኮ ቤርቶ ዒንጊፆ ማሂ ታኣም ዔኪ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ዬያ ካሦና ዎላ ቦሂሳ ባኣዚባኣ፥ ፔቴ ሌዔ ኩሜ ላንካይ ዓዴ ማራናይ፥ ፔቴ ጌማናይና ላምዖ ዓዴ ማራይ ዒስራዔኤሌ ዴራ ዔኪ ሺኢሾንጎ፤ ዬያታ ሃኣኮ ዒንጊፆና ዎይኖ ዑዦና ዎላ ሚቺ ዒንጎ ዒንጊሢ ማዒ ታኣም ዒንጊንቶንጎ፤ ዬያኮ ሳዋ ታና ዎዛሳያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ዬያጉዲ ሃሣ ጎሜ ጌኤሻ ዒንጊሢ ማዓ ፔቴ ኮላይ፥ ፔቴ ሌዔ ማዔ ላምዖ ዓዴ ማራናይ፤ ፔቱሞና ዒንጎ ዒንጊሢ ማሂ ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ዬካፓ ቄኤሳሢ ካሦንሢና ላምዖ ማራናኣቶንሢና ዎላ ዡጊ፥ ታኣም ዱማዼ ዒንጊሢ ማሂ ዒንጎንጎ፤ ዬይ ቄኤሳሢ ዛላ ማዓያ ማዓንዳኔ፤ ዬንሢያ ታኣም ዱማዼ ዒንጊሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ዬኖ ኬሎ ታና ካኣሽካኒ ቡኪንቱዋቴ፤ ሜሌ ማዾ ማዺፖቴ፤ ዬይ ዒንሢ ናንጋ ቤዞ ቢያይዳ ሙካ ሾይንታ ካፓ ዳምቤ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«ዒንሢ ማኣሎ ቡራ ዎዶና ጎዦኮ ዓጮይዳ ዓጮይዳ ዓኣ ሃኣኮ ዔኪፖቴ፤ ሃሣ ቶሊ ዓቴሢ ጊንሣ ዚንጊፖቴ፤ ዬያ ማንቆ ዓሶና ሜሌ ዓጫፓ ሙኬ ዓሶናም ሃሹዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶም ሙሴ ሂዚ ጌዒ ኬኤዛንዳጉዲ ዓይሤኔ፦ «ላንካሳ ዓጊኖኮ ቤርታሳ ኬሎ ዱማ ቦንቾ ኬሊ ማሂ ቦንቹዋቴ፤ ዛዬ ዋርቂንቴ ዎዶና ታና ካኣሽካኒ ዒዞ ኬሎ ቡኪንቱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ዬኖ ኬሎ ታኣም ሙኡዚ ዒንጊሢ ዒንጉዋቴ፤ ሜሌ ዒንሢኮ ማዾ ማዺፖቴ» ");
INSERT INTO mdyeth_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«ላንካሳ ዓጊኖኮ ታጳሳ ኬሎና ዴሮኮ ጎሞ ጌኤሾ ኬሊ ማዖንጎ፤ ታና ካኣሽካኒ ቡኪንቲ፥ ፔቴታዖ ዔኤቢ ሙዑዋዖ ፔኤቁዋቴ፤ ታኣም ሙኡዚ ዒንጊሢያ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ዬና ኬሌላ ዴሮኮ ጎሞ ጌኤሾ ዳምባ ኩንሢንታ ኬሎታሢሮ ዬኖ ኬሎ ዓይጎ ማዾዋ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ዬኖ ኬሎና ሙኡዚ ሙዔ ዓሲ ታ ዓሶ ባኣካፓ ባይቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ዬያጉዲ ዓይጎ ማዾዋ ማዖም ማዼ ዓሲ ታኣኒ ታ ዴሮ ባኣካፓ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ዬያሮ ፔቴታዖ ዒዞ ኬሎና ማዾ ማዺፖቴ፤ ዬይ ዒንሢ ናንጋ ቤዞ ቢያይዳ ሙካ ሾይንታ ካፓ ዳምቤ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ዬኖ ዓጊኖኮ ታዞጳሳ ኬሎ ዓባ ጌሌማፓ ዴንዲ ዚሮ ዓባ ጌላንዳኣና ዓይጎ ባኣዚያ ሙዑዋዖ ዬኖ ኬሌሎ ዱማ ሃውሺሢ ኬሊ ማሂ ቦንቹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ላንካሳ ዓጊኖኮ ታጶ ዶንጋሳ ኬላፓ ዓርቂ ላንካይ ኬሊ ሄላንዳኣና ዉልሾ ዴማ ዴዒ ቦንቺንታ፥ ታ ኬሎ ቦንቹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ዬንሢ ኬሎይዳፓ ቤርታሳ ኬሎ ቡኪ ታና ካሽኩዋቴ፤ ሜሌ ዓይጎ ማዾዋ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ዬንሢ ላንካዎ ኬሎንሢ ቢያይዳ ሙዖ ዒንጊፆ ታኣም ሺኢሹዋቴ፤ ሳላሳ ኬሎና ታና ካኣሽካኒ ቡኪንቱዋቴ፥ ሙዖ ዒንጊፆዋ ታኣም ዒንጉዋቴ፤ ዬና ጋፒንሢ ቡኪንቲ ኬሊ ማዔሢሮ ሜሌ ማዾ ዒንሢኮ ማዺፖቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«ሚቺ ዒንጎ ዒንጊፆ፥ ሙዖ ዒንጊፆ፥ ዑዦ ዒንጊፆንታ ሜሌ ሜሌ ዒንጊፆዋ ታኣም ኮይሳሢ ጎይፆ ቢያ ኬሊ ዒንጊ ታና ዒንሢ ካኣሽካንዳ ታኣኮ ቦንቾ ኬሎንሢ ዬንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ዬንሢ ባኮ፥ ታኣኮ ቦንቾ ኬሎና ዒንሢ ዒንጋ ዒንጊፆይዳ፥ ናኣቦ ዒንሢ ዒንጋ ዒንጊፆይዳ፤ ሃሣ ዒንሢ ሼኔና ዒንሢ ዒንጋ ዒንጊፆይዳ ቃሲ ዒንሢ ዒንጋንዳ ባኣዚኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«ማኣሎ ዒንሢ ቡሬስካፓ ላንካሳ ዓጊኖኮ ታጶ ዶንጋሳ ኬላፓ ዓርቃዖ ላንካይ ኬሊ ሄላንዳኣና ዎዛ ቦንቾ ታ ቤርታ ቦንቹዋቴ፤ ዬያቶይዳፓ ቤርታሳ ኬሎማና ሳላሳ ኬሎና ዱማ ሃውሺሢ ኬሊ ዒንሢም ማዖም። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ዬኖ ቤርታሳ ኬሎይዳ ዒንሢ ቱኬ ኮዦ ሚፆ ዓኣፖንታ ሜኤፄ ዒላሺንታ ሃሣ ዓኣዔ ሚሢ ዋላሺ ሜንሢ ዔኪ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ላንካይ ኬሊ ሄላንዳኣና ዎዛዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ዬኖ ቦንቾ ሌዓ ሌዓ ናንጊና ናንጋ ጎዳ ቤርታ ላንካይ ኬሊ ሄላንዳኣና ቦንቹዋቴ፤ ዬይ ዒንሢኮ ናኣቶኮ ናኣቶና ናንጋ ዳምቤ ማዖንጎ፤ ላንካሳ ዓጊኖና ዓጊኖና ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ዒስራዔኤሌ ዴራ ጉቤ ላንካይ ኬሊ ሄላንዳኣና ዉልሻ ዴንካ ዴዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ዬያይዲፆና ታኣኒ ዒስራዔኤሌ ዴሮ ጊብፄ ዓጫፓ ኬሳኣና፥ ዴራ ዋዦ ዴንካ ናንጋንዳጉዲ ማሄሢ ዒንሢኮ ናኣታ ዔራንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ናንጊና ናንጋ ጎዳ ዔያታ ካኣሽኪ ቦንቻንዳ ኬሎ ዒስራዔኤሌ ዓሶም ሙሴ ዬያይዲ ዔርዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ጋራ ዓኣ ፖዓ ቢያ ዎዴ ፖዒ ዴዓንዳጉዲ ሪሚቶ ዓኣፖ ጩኡጲ ጊሶና ዛይቶ ኔኤም ዔኪ ዬዓንዳጉዲ ዒስራዔኤሌ ዴሮም ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ዬካፓ ዓኣሮኔ ዋንቶ ዋንቶ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ጋራ ዓኣ ታኣቦቶኮ ቤርቶ ዛላ፥ ጎኦቦና ዓፒሎኮ ዙላ ታ ቤርቶይዳ ሳዓ ካራንዳያ ሄላንዳኣና ዔኤሤ ጎይሣ ዎይሦንጎ፤ ዬይ ዳምባ ሙካ ሾይንታ ቢያ ካፒ ማዻያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ዓኣሮኔ ዬንሢ ፖዖንሢ ጌኤሺ ዎርቄና ኮሺንቴ ሻርኖይዳ ጊኢጊሺ ጌሦንጎ፤ ዬንሢ ፖዓ ታ ቤርቶይዳ ቢያ ዎዴ ዔኤቲ ዴዓያ ማዓሢ ዛጎንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«ዬያጉዲ ሃሣ ታጶ ላምዖ ኪሎ ማዓንዳ ሺኢቺ ዺኢሊ ዔኪ፥ ታጶ ላምዖ ዻካ ዻካ ላኣዳ ላኣዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ዬንሢ ላኣዶንሢ ታ ቤርቶይዳ ዓኣ፥ ጌኤዦ ዎርቆና ጳርቆና ዼጌ ሎኦዦ ዖይቶይዳ ላሆንሢ ፔቴ ዛላ፥ ዓቴ ላሆንሢያ ባጎ ዛላ ዎሊ ቤኤዚ ጌሤ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ታኣም ሚቺ ዒንጎ ዒንጊፆ ማሊሳ ላኣዳ ዒንጊሢ ማዔሢ ዔርዛኒ ጌኤሺ ዑንጄ ላምዖ ዎሊ ቤኤዚ ጌሦና ላኣዶኮ ኮራ ኮራ ጌሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ዬይ ሙካ ዎዶይዳ ሃውሾ ኬሎ ኬሎ ናንጊና ናንጋ ጎዳ ቤርታ ጌሢንቲ ዴዖንጎ፤ ዬይ ዒስራዔኤሌ ዓሳ ቢያ ዎዴ ማዺ ኩንሣኒ ኮይሳ ጫኣቁሞ ዳምቤኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ዬይ ካሣ ዓኣሮኔና ዒዛኮ ናኣቶናም ማዓያኬ፤ ዔያታ ታኣም ዱማዼ ቤዞይዳ ሙዖንጎ፤ ዬይ ሚቺ ዒንጎያ ማሂ ሺኢሾና ዒንጊፃ ታኣም ዱማዼያ፥ ዔያቶ ዛላ ማዓያኬ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","ዒንዳ ዒስራዔኤሌ ዓሲ ዓዴ ጊብፄ ዓሲ ማዔ፥ ፔቴ ዓሲ ዓኣኔ፤ ዒዛኮ ዒንዶ ሱንፃ ሴሎሚቶኬ፤ ዒዛ ዳኣኔ ዜርፃፓ ማዔያ ዲብሪ ጎዖሢኮ ናይ ማዔ ዒስራዔኤሌ ዓሲኬ፤ ዬይ ዓሢ ጉርዶይዳ ፔቴ ዒስራዔኤሌ ዓሲና ዎላ ዑራዺ፥ ዑሮይዳፓ ዔቄያና ናንጊና ናንጋ ጎዳኮ ሱንፆ ጫሽኬሢሮ ሙሴ ቤርቶ ዓሳ ዒዛ ዔኪ ዬዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ዒዛ ዎዻኒ ኮይሳቴ ናንጊና ናንጋ ጎዳ ዔያቶም ኬኤዛንዳያ ሄላንዳኣና ቱኡሲ ማርካ ጌሢ ካፓ ዓሲና ዒዛ ዔያታ ካፒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«ታና ጫሽኬ ዓሢ ጉርዳፓ ዙሎ ኬሴ፤ ዒዚ ጫሽካኣና ዋይዜ ዓሳ ቢያ ዬይ ዓሢ ዻቢንቴያ ማዔሢ ማርካዻኒ ቢያ ዓሳ ፔቴና ኩጮ ዒዛ ቶኦካ ጌሦንጎ፤ ዬካፓ ዴራ ቢያ ዒዛ ሹቻ ዹይ ዎዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ዓይጎ ዓሲያ ፔኤኮ ፆኦሲ ጫሽኬሢ ጎሜ ማዼሢሮ ዬያ ዛሎ ዒዛይዳ ዓጊንታ ባኮ ዒ ዔካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ታኣኮ ሱንፆ ጫሽካ ዓሲ ዎዎዺንቶንጎ፤ ዒስራዔኤሌ ዓሲ ማዔቴያ ሜሌ ዓጪ ዓሲ ማዔ ዓሲ ቢያ ታ ሱንፆ ጫሽኬቴ ዒስራዔኤሌ ዴራ ዬያ ዓሢ ሹቻ ዹይ ዎዾንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«ዓሲ ዎዻ ዓሲ ዖና ማዔቴያ ሃይቃንዳጉዲ ዎጊንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ሜሌ ዓሲኮ ቆልሞ ዎዼ ዓሲ ዒማጉዴ ቆልሞ ማሂ ጪጎንጎ፤ ዬይ ዎጋ ሼምፖ ዛሎ ሼምፖ ጪጎም ጌይሢኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«ዓይጎ ዓሲያ ማዖም ፔቴ ዓሲዳ ፑርታ ባኣዚ ማዼያ ማዔቴ ዒማጉዴ ባኣዚ ዬያ ዓሢዳ ማዺንቶንጎ፤ ጌይፃ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ዬይ ዓሢ ዓሲኮ ሜጌሢ ሜንሤያ ማዔቴ ዒዛኮዋ ሜጌፃ ሜንሢንቶም፤ ሜሌ ዓሲኮ ዓኣፒ ዎዼያ ዒ ማዔቴ ዓኣፓ ዎዺንቶም፤ ሃሣ ዓቺ ሜንሤያታቴ ዓጫ ዒዛኮ ሜቆም፤ ዬያጉዲ ሜሌ ዓሲ ዑሢዳ ዓይጎ ባኣዚያ ዒ ማዼ ባካ ዒዛይዳኣ ማዺንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ቆልሞ ዎዼሢ ቤዛ ሜሌ ጪጎንጎ፤ ጋዓንቴ ዓሲ ዎዼሢ ሃይቃንዳጉዲ ዎጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ሃይ ዎጋ ዒንሢ ዒስራዔኤሌ ዓሶንታ ዒንሢኮ ባኣካ ናንጋ ሜሌ ዓሶንታም ቢያ ሄኮ ማዻያ ማዖንጎ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ሙሴ ዬያ ቢያ ዴሮም ኬኤዚ ጋፒሳዛ ዔያታ ዬያ ዓሢ ጉርዳፓ ዙሎ ኬሲ፥ ሹቻ ዹይ ዎዼኔ፤ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ዒስራዔኤሌ ዴራ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ናንጊና ናንጋ ጎዳ ሙሴም ሲና ዹኮይዳ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጋንዳ ዓጮ ዒንሢ ጌሌ ዎዶና ላንካሳ ሌዖይዳ ፔቴታዖ ጎሺ ጎሽኩዋዖ ሃሺ ናንጊና ናንጋ ጎዳ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ላሆ ሌዔ ሄላንዳኣና ጎዦ ዒንሢኮ ጎሽኩዋቴ፤ ዎይኖኮዋ ፑርቴ ካኣፖ ካሪ ኮሹዋቴ፤ ካፄ ሃኣኮዋ ማኣላፓ ቡሪ ዔኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ላንካሳ ሌዓ ጋዓንቴ ታኣም ዱማዼያ ማዖንጎ፤ ዬኖ ሌዖይዳ ጎዦ ዒንሢሲ ጎሽኪፖቴ፤ ሃሣ ዎይኖኮዋ ፑርቴ ካኣፖ ካሪ ካሪ ኮሺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ማኣሎይዳ ጉሪ ባቃሊ ካፄ ሃኣኮ ዔኪፖቴ፤ ሃሣ ፑርቴ ካኣፖ ካሪ ኮሺንቲባኣ ዎይኖይዳፓ ዓኣፖ ዔኪፖቴ። ዬና ሌዓ ጎዣ ዒንሢኮ ጎሽኪንቱዋ ሌዔ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ዬኖ ሌዖይዳ ዒንሢ ጎዦ ጎሽኩዋያ ማዔቴያ ዒንሢኮ ማኣሎይዳ ጉሪ ካፄ ባካ ዒንሢንታ ዒንሢም ማዻ ዓሶንታም፥ ሃሣ ዒንሢ ሚኢሼ ጪጊ ማዺሻ ዓሶንታም፤ ዬያጉዲ ዒንሢና ዎላ ናንጋ ሜሌ ዓጮ ዓሶም፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ዒንሢኮ ቆልሞና ካዮ ቦዖናም ሙኡዚ ማዖንጎ። » ");
INSERT INTO mdyeth_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«ላንካይ ሃውሾ ሌዔ ላንካይ ማይንቲ ፓይዴ፤ ዬያ ኔ ፓይዳዛ ሌዓ ዎሊ ዑፃ ዖይዲታሚ ታዞጳ ሌዔ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ዬካፓ ላንካሳ ዓጊኖኮ ታጳሳ ኬሎና ቦንቺንታ ጎሞ ጌኤሺፆ ኬሎ ዒንሢ ዓጮ ቢያይዳ ዛዬ ዋርቃንዳ ዓሲ ዳኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ዬያይዲ ዶንጊታማሳ ሌዖ ታኣም ዱማሲ፥ ዓጮይዳ ቢያ ናንጋ ዓሶም ዓይሌ ማዒ ሻንቺንቴሢ ዓይሉማፓ ኬስኪ ፔ ዒጊኖ ባንሢ ዴንዳንዳጉዲ፥ ሃሣ ሻንቺንቴ ጎሺያኣ ሻንቼ ዓሢም ማዓንዳጉዲ ኬኤዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ዬኖ ሌዖና ጎዦ ዒንሢኮ ጎሽኪፖቴ፤ ሃሣ ዒንሢ ጎሽኪባኣንቴ ማኣሎይዳ ጉሪ ባቃሊ ካፄ ሃኣኮ ዔኪፖቴ፤ ዬያጉዲ ፑርቴ ካኣፓ ካሪ ጊኢጊሺንቲባኣ ዎይኖ ዓኣፖዋ ማንፂ ዔኪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ዬና ሌዓ ጉቤ ታኣም ዱማዼያ ማዖንጎ፤ ዒንሢ ጎሽኪባኣንቴ ማኣሎይዳ ጉሪ ባቃሊ ካፄ ሃኣኮ ዒኢካ ማኣላፓ ዔኪ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«ዬያኮ ቤርታ ሻንቺንቴ ጎሺ ዬኖ ሌዖይዳ ሻንቼ ጎዦ ዓዳሢም ማሂ ዒንጊንታያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ዒንሢኮ ፃጲ ማዔ ዓሲም ሳዓ ዒንሢ ሻንቼቴ፤ ሃሣ ጊንሣ ሻንቄያ ዒንሢ ማዔቴ ፔቴይ ባጋሢም ጌኔ ማዾ ማዾፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ሻንቺንቴ ሳዓ ማዓ ሌዓ ሄላንዳኣና ዓኣ ሌዖኮ ፓይዶ ዔሪ፥ ኔ ፃጳሢፓ ሻንቄ፤ ዒዚያ ዬኖ ሌዖ ጋራ ዓኣ፥ ሃኣካ ካፃንዳ ሌዖኮ ፓይዶ ዔሪ ሻንቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ዬኖ ሌዖኮ ፓይዳ ሚርጌቴ ሚርጌ ሚኢሼ ዒንጌ፤ ሌዖኮ ፓይዳ ዻካ ማዔቴ ዻካ ሚኢሼ ዒንጌ፤ ዓይጎሮ ጌዔቴ ዒ ሳዖ ሻንቻሢ ጎዣ ካፂሳንዳ ሃኣኮ ጎይፆታሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ፔቴ ዒስራዔኤሌ ዓሲ ፔ ባጋሢም ጌኔ ማዾ ማዾፓ፤ ዒንሢኮ ፆኦዛሢ ዒጊጩዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«ዒንሢ ናንጋ ዓጮይዳ ኮሺ ናንጋኒ ታኣኮ ዎጎና ዓይሢፆና ካፒ ኩንሣያ ማዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ዒንሢኮ ሳዓ ዒንሢም ጊዳ ሃኣኮ ካሣንዳሢሮ ሙዓንዳ ባኣዚ ዴንቂ ሜታባኣያ ዒንሢ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","«ጋዓንቴ ዒንሢ፥ ኑኡኒ ጎሺ ጎሽኪ ሃኣኮ ዓርሢባኣቴ ዬኖ ላንካሳ ሌዖ ዓይጎ ሙዓንዳይ?» ጌይ ዖኦጫያናንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ላሃሳ ሌዖና ታኣኒ ዒንሢኮ ሳዖ ሚርጌና ዓንጃንዳሢሮ ሃይሦ ሌዔም ጊዳንዳ ሃኣኮ ካፃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ሳላሳ ሌዖይዳ ማዔቴያ ጎዦ ዒንሢ ጎሽካ ዎዶና ዒንሢ ሙዓንዳሢ ቤርታኣ ሃኣኮኬ፤ ዬያ ሃኣኮ ታዞጳሳ ሌዖ ሃኣኮ ዓርሣንዳያ ሄላንዳኣና ሙዒ ሙዒ ዒንሢ ዴዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«ሳዖ ዒንሢኮ ማሂንቱዋ ጎይሢ ፔቶ ሻንቺፖቴ፤ ዓይጎሮ ጌዔቴ ሳዓ ዒንሢሮቱዋንቴ ታኣሮታሢሮኬ፤ ዒንሢ ሙኬ ዓሲጉዲ ማዒ ዒኢካፓ ጴዻ ባኮ ሙዓንዳጉዲ ታ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","«ሳኣ ዒንሢ ሻንቃ ዎዶና ዬይ ሻንቼ ዓሢ ሳዖ ጊንሣ ማሂ ሻንቂ ዔካኒ ላኣጋ ባኣዚ ባኣያ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ፔቴ ዒስራዔኤሌ ፃጲ ማዔያ ማንቂ፥ ሳዖ ፔኤኮ ሻንቻያ ማዔቴ ዒዛኮ ዑኬ ማዔ ዒጊኒ ዒዛኮ ሳዖ ዒዛም ጪጊ ማሂሳኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ዬያ ማዻንዳ ዑኬ ዒጊኒ ባይቄቴ ዒዚ ናንጊቤቃ ቆሎ ዴንቃዖ ጪጊ ፔኤኮ ሳዖ ማሂሳኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ዬያ ዒ ማዻኒ ዳንዳዔ ዎዶና ሻንቺንቴ ባኮ ማሂፆ ሌዓ ሄላንዳኣና ጋራ ዓኣ ሌዖ ፓይዲ ዔሬስካፓ ዓቴ ሌዖ ሚኢሾ ዓሢም ማሂ ፔ ሳዖ ዔኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ጋዓንቴ ዒዚ ጪጊ ማሂሲ ዔካንዳ ሚኢሼ ዴንቂባኣያ ማዔቴ ሳዓ ዒዛሲ ሻንቂንቴ ባኮ ማሂፆ ሌዓ ሄላንዳኣና ዬያ ሻንቄ ዓሢሮ ማዒ ዴዖንጎ፤ ዬና ሌዓ ሄሌስካፓ ሳዓ ዒዛሮ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«ፔቴ ዓሲ ሹቺና ኬልቂ ዲርቆና ካታማይዳ ማኣሪ ሻንቼቴ፥ ሻንቺንቴ ኬላፓ ዴንዲ ፔቴ ሌዔ ማዓ ጋርሲዳ ጪጊ ማሂ ዔካኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ጋዓንቴ ዒ ፔቴ ሌዔ ጋርካ ጪጊ ማሂ ዔካኒ ዳንዳዒባኣቴ ጪጊ ማሂ ዔካኒ ዳንዳዑዋያ ማዔም ዬና ማኣራ ናንጊና ዬያ ሻንቄ ዓሢና ናኣቶናሮ ማዒ ዓታንዳኔ፤ ሻንቂንቴ ባኮ ማሂፆ ሌዖናታዖ ማሂ ዒ ዔካኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ሹቺና ኬልቂ ዲርቂንቲባኣ፥ ጉርዳ ባኣካ ዓኣ ማኣሪ ሻንቻሢ ጋዓንቴ ጎሺ ሻንቼያጉዲ ማሂ ጪጊ ዔካኒ ዳንዳዓኔ፤ ሃሣ ሻንቺንቴ ባኮ ማሂፆ ሌዖይዳ ዒ ማሂ ዔካኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ዬይ ያዺ ማዔቴያ ሌዊ ፃጶ ማዔ ዓሳ ዔያቶ ካታሞይዳ ዓኣ ማኣሮ ፔኤኮ ዓይጎ ዎዴናኣ ማዖም ጪጊ ማሂ ዔካኒ ላኣጋ ባኣዚ ባኣያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ፔቴ ሌዊ ፃጲ ማዔ ዓሲ ካታማይዳ ማኣሪ ሻንቻዖ ማሂ ጪጊ ዔካኒ ዳንዳዒባኣያ ማዔቴ ሻንቺንቴ ባኮ ማሂፆ ሌዖይዳ ዒዛም ማዓኒ ዳንዳዓኔ፤ ዓይጎሮ ጌዔቴ ሌዊ ፃጶ ማዔ ዓሳ ዔያቶ ካታሞይዳ ማዣ ማኣራ ቢያ ዎዴ ዔያቶሮ ማዒ ናንጋሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ዔያቶኮ ካታሞ ዓጮይዳ ዓኣ ቆልማ ሄንቃ ቤዛ ፔቴታዖ ሻንቺንቱዋሴ፤ ዬይ ናንጊና ዔያቶሮ ማዒ ናንጋያኬ። » ");
INSERT INTO mdyeth_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«ዒንሢ ባኣካ ናንጋ፥ ዒንሢ ፃጲ ማዔ ዒስራዔኤሌ ዓሲ ማንቂ ፔና ማኣዳኒ ዳንዳዒባኣቴ ዒንሢ ባኣካ ናንጋኒ ሜሌ ዓጪፓ ሙኬ ዓሲም ዒንሢ ማዻ ጎይፆ ዒዛም ኮይሳ ባኮ ናሹሞና ማዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ዒንሢኮ ፃጲ ማዔ ዓሢ ዒንሢና ዎላ ናንጊሹዋቴ፤ ሃሣ ዓይጎ ባኣዚያ ዑሣ ዓኣሢ ሾይቺና ዒንሢም ዒንጋንዳጉዲ ዔኤቢ ማዺፖቴ፤ ዒንሢኮ ፆኦዛሢ ዒጊጩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ዒንሢ ታልዓ ሚኢሾ ሾይቺና ማሃንዳጉዲ ጌይ ታልዒፖቴ፤ ሙኡዚ ዒዛም ዒንሢ ሻንቻ ዎዶና ዑሣ ዓኣሢ ዺቢ ሚኢሼም ሻንቺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ካኣናኔ ዓጮ ዒንሢም ዒንጋኒ፥ ዒንሢኮ ፆኦሲ ማዓኒ ጊብፄ ዓጫፓ ዒንሢ ዔኪ ኬሴሢ ታና ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«ዒንሢ ባኣካ ናንጋ፥ ዒንሢ ፃጲ ማዔ ዒስራዔኤሌ ዓሶይዳፓ ፔቴ ዓሲ ማንቆ ማዒ ኔኤም ዓይሌ ማሂ ፔና ሻንቼቴ ዓይሌ ማሂ ዒዛ ማዺሺፖ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ሻንቺንቴ ባኮ ማሂፆ ሌዓ ሄላንዳኣና ሚኢሼ ጪጊንቴም ማዻ ዓሲጉዲ ኔኤም ማዺ ማዺ ናንጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ዬና ሌዓ ሄላዛ ዒዛንታ ናኣቶንታ ዓይላታፓ ኬስኪ ፔ ማኣሮ ዓሶና ዒዛኮ ዓኣ ባኮና ባንሢ ዓኣዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ዒስራዔኤሌ ዴሮ ጊብፄ ዓጫፓ ታኣኒ ዔኪ ኬሴያ፥ ታኣም ማዻያታሢሮ ዔያታ ዓይሌ ማዒ ሻንቺንታንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ዔያቶ ዎልቄና ሄርቂ ዎይሢፖቴ፤ ታና ዒንሢኮ ፆኦዛሢ ዒጊጪ ታኣም ዓይሢንታያ ማዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ዒንሢም ማዻ ዓሲ ዒንሢ ኮዔያ ማዔቴ ዒንሢ ኮይላ ዓኣ፥ ሜሌ ዴሮፓ ሻንቂ ዔኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ሃሣ ዬያጉዲ ዒንሢ ባኣካ ናንጋ ሜሌ ዓጪፓ ሙኬ ዓሶና ዔያቶኮ ናኣቶናይዳፓ ማዻ ዓሲ ሻንቃኒ ዒንሢ ዳንዳዓኔ፤ ዔያታኣ ዒንሢሮ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ዒንሢኮ ናኣቶም ዔያቶ ዒንሢ ዻካልሳኒያ ዳንዳዓኔ፤ ዔያታ ናንጋ ዎዶ ቢያይዳ ዒንሢ ናኣቶም ማዻያ ማዖንጎ፤ ዒንሢኮ ፃጶ ማዔ፥ ዒስራዔኤሌ ዓሶ ባኣካፓ ዓይጎ ዓሲያ ማዖም ዎልቄና ሄርቂ ዎይሢፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«ዒንሢ ባኣካ ናንጋ፥ ሜሌ ዓጪፓ ሙኬ ዓሲታዖ ዖርጎቺ ማዔም ዒንሢ ባኣካፓ ፔቴ ዓሲ ማንቂ ዬያ ዓሢም ማዔቴያ ዒዛ ፃጲ ማዔያም ዓይሌ ማዒ ሻንቺንቴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ዒዚ ሻንቺንቴስካፓ ሚኢሻ ጪጊንቲ ማዔም ዓይላታፓ ኬስካኒ ዒ ዳንዳዓኔ፤ ዬያሮ ዬያ ዓሢኮ ፃጶ ማዔ ዓሶፓ ፔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ጌይፃ፦ ዒዛኮ ዓዶ ዒሾታቴያ ዓዶ ጌኤዚ፤ ሃሣ ዬያቶኮ ናኣታ፤ ሃንጎ ሃሣ ዒዛኮ ዑኬ ዒጊኒ ማዔያ ሚኢሾ ማሂ ጪጊ ዒዛ ዓይሉማፓ ኬሳኒ ዳንዳዓኔ፤ ሃንጎታቴ ዒዚ ቆሎ ዴንቄስካፓ ሚኢሾ ማሂ ጪጊ ኬስካኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ያዺ ማሃኒ ዒ ኮዓ ዎዶና ሻንቄ ዓሢና ዎላ ዞርቶንጎ፤ ዒዚ ፔና ሻንቼ ሌዓፓ ዓርቃዖ ዴንዲ ሻንቺንቴ ባኮ ማሂፆ ሌዖ ሄላንዳኣና ዓኣ ሌዖ ፓይዶንጎ፤ ዒዛ ዓይላታፓ ኬሳኒ ዳንዳዓ ሚኢሾ ዬንሢ ሌዖንሢዳ ፔቴ ዓሲ ሌዔና ሌዔና ማዼም ጪጎ ሚኢሼጉዴያ ማሊንቲ ዓርቂንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","52","ሃጊ ቤርታ ማዻንዳዖ ዓቴ ሌዖኮ ሚኢሾይዳፓ ዛላ ሚኢሼ ማሂ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ዬይ ያዺ ማዓኒ ኮይሳሢ ሌዔይዳ ሚኢሼ ጪጊንቴም ማዻ ዓሲ ማሊንቲኬ፤ ዒዛ ዎይሣ ዓሢ ዒዛ ዎልቄና ሄርቂ ዎይሦፓ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ዬያይዲ ዓይላታፓ ዒ ኬስካኒ ዳንዳዒባኣቴ ሻንቺንቴ ባኮ ማሂፆ ሌዓ ሄላዛ ዒዛና ዒዛኮ ናኣቶና ዓይላታፓ ኬስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ዒስራዔኤሌ ዓሳ ታኣም ማዻያ ማዔሢሮ ዒስራዔኤሌ ዓሲ ማዔ ዓይጎ ዓሲያ ማዖም ናንጊና ዓይሌ ማዒ ሻንቂንቲ ናንጋንዳያ ኮይሱዋሴ፤ ዓይጎሮ ጌዔቴ ዒስራዔኤሌ ዓሳ ጊብፄ ዓጫፓ ታኣኒ ኬሴ ዓሲኬ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ዚጊ ካኣሽካኒ ዓይጎ ባኣዚያ ማዖም ፆኦዞ ማሂ ማዢፖቴ፤ ዔኤቢ ማሊሲ ኮሾና ባኣዚያ ማዖም ሹቺና ዻኣቦዋ ካኣሽካኒ ዻኣቢፖቴ፤ ሹቺ ዓርሲያኣ ካኣሽኮ ባኣዚ ማሂ ጌሢፖቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ታኣኒ ቦንቺንቶንጎ ጌዔ ኬሎ ካፒ ቦንቹዋቴ፤ ታኣም ዱማዼ ማኣሮዋ ቦንቹዋቴ፤ ታኣኒ ናንጊና ናንጋ ጎዳሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«ታ ዎጎ ኩንሢ ዒንሢ ናንጋያ፤ ሃሣ ታ ዓይሢፆዋ ካፓያ ማዔቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ሳዓ ዒንሢኮ ሃኣኮ ካፂሳንዳጉዲ ዒንሢ ቱካ ሚፃኣ ዓኣፓያ ማዓንዳጉዲ ዒሮ ኮይሳ ዎዶና ዒንሢም ታ ዋርቂሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ሃኣካ ዒንሢኮ ሚርጌና ካፃንዳሢሮ ሃኣኮ ዒንሢ ማኣላፓ ቡሪ ጋፑዋንቴ ዎይና ካፃ ዎዳ ሄላንዳኔ፤ ዎይኖኮ ዓኣፖ ዒንሢ ዔኪ ጋፑዋንቴ ጎዦ ጎሽኮ ዎዳ ሄላንዳኔ፤ ዒንሢ ሙዓንዳ ባኣዚያ ዴንቂ፥ ሳዖይዳ ኮሺ ናንጊ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","«ዒንሢ ዓጮም ኮሹሞ ታ ዒንጋንዳኔ፤ ዖናኣ ዒጊጩዋዖ ሂርጋባኣያ ዒንሢ ጊንዓንዳኔ፤ ፑርታ ማዔ ቦዖ ዒንሢ ዓጫፓ ታ ባይዛንዳኔ፤ ዒንሢ ዖላ ዓሲያኣ ባኣያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ዒንሢኮ ሞርኮ ዒንሢ ባሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ዒንሢዳፓ ዶንጎ ዓሲ ሞርኮኮ ፄኤታ ዓሲ ዖሊ ባሻንዳኔ፤ ጊንሣ ሃሣ ሞርኮኮ ታጶ ሺያ ዓሲ ዒንሢኮ ፄኤታ ዓሲ ዖሊ ባባሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ታ ዒንሢ ዓንጃንዳኔ፤ ሚርጌ ናይያ ታ ዒንሢም ዒንጋንዳኔ፤ ታ ዒንሢና ዎላ ጫኣቄ ጫኣቁሞዋ ዋሉዋዖ ካፓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ሌዓፓ ሌዖ ሄላ፥ ሴሚ ሃኣኮ ዒንሢኮ ዓኣያ ማዓንዳኔ፤ ዬያሮ ዓኮ ሃኣኮ ዓርሣኒ ሴሞ ሃኣኮ ኮናፓ ኬሲ ዒንሢ ላኣላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ዓፒሎና ማዢንቴ፥ ታ ማኣሮይዳ ዴዒ ዒንሢ ባኣካ ታኣኒ ናንጋንዳኔ፤ ፔቴታዖ ታ ዒንሢ ዒፂ ሻኣኪንታዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ዒንሢ ባኣካ ታኣኒ ሃንታንዳኔ፤ ዒንሢኮ ታ ፆኦዛሢ ማዓንዳኔ፤ ዒንሢያ ታ ዴሬ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ጊብፄ ዓጫ ዓይሌ ማዒ ዒንሢ ናንጉዋጉዲ ታ ዒንሢ ኬሴ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ታኣኒ ፆኦዛሢኬ፤ ባቃናኣ ዒንሢኮ ዓጎና ዓይሉሞ ቃምባሮ ሜንሢ፥ ዼግ ጌይሲ ታ ዒንሢ ሃንቲሴኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ናንጊና ናንጋ ጎዳ ኬኤዛዖ «ዒንሢ ታኣም ዋይዞ ዒፂ ታኣኮ ዓይሢፆዋ ካፒ ኩንሡዋያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ታኣኮ ዎጎና ዓይሢፆና ካፖ ዒፂ፥ ታ ዒንሢና ዎላ ጫኣቄ ጫኣቁሞ ዒንሢ ሃሼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ታ ዒንሢ ሂዲ ሜታሳንዳኔ፤ ዬይያ፦ ዓኣፖ ዒንሢኮ ባይዛንዳያ፥ ዑፆ ዒንሢኮ ዖኦፒሳንዳያ፥ ጋፑዋ ቆሢ ዶርዖ ታ ዒንሢም ዳካንዳኔ፤ ዒጊቹሞ ሂርጋኣ ታ ዒንሢዳ ጌልዛንዳኔ፤ ዒንሢ ጎሽኬ ሃኣኮ ሞርካ ሙዓንዳሢሮ ጉሪ ዒንሢ ጎሽኪ ላባያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ታ ዒንሢም ዋይዞ ዒፃንዳሢሮ ዒንሢኮ ሞርካ ዒንሢ ባሻያ ማዓንዳኔ፥ ዔያታ ዒንሢ ዎይሣንዳኔ፤ ሚርጌና ዲቃታያ ዒንሢ ማዓንዳሢሮ ዒንሢ ዳውሳ ዓሲ ባኣንቴ ጉሪ ዒንሢ ጳሽካያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«ዬይ ያዺ ማዔንቴያ ዒንሢ ታኣም ዓይሢንቱዋያ ማዔቴ ዬያጉዴ ሜቶ ላንካይ ጳንጬ ማሂ ታ ዒንሢዳ ሄሊሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ዒንሢኮ ዖቶርሙሞ ታ ባይዛንዳኔ፤ ዒርዚ ዒንሢም ዋርቂንዱዋኣሢሮ ሳዓ ዒንሢኮ ሜሊ ዓንጊ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ላቢ ዒንሢ ማዻ ባካ ቢያ ዒንሢ ማኣዱዋያ ማዓንዳኔ፤ ዓይጎሮ ጌዔቴ ሳዓኣ ዒንሢኮ ሃኣኮ ካሢንዱዋኣሢሮ፤ ሃሣ ዒንሢ ቱካ ሚፃኣ ዓኣፒንዱዋኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«ዬይ ቢያ ማዔንቴ፥ ታኣም ዓይሢንቲፆ ዒፂፆ ሃሹዋያ ዒንሢ ማዔቴ ዒንሢ ማዻ ጎሞ ሚርጉሞ ጎይፆ ሜታሢ ላንካይ ጳንጬ ማሂ ዒንሢም ታ ቃሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ዒንሢ ባኣኮ ፑርታ ቦዖ ታ ዳካንዳኔ፤ ዬይ ቦዓ ናኣቶ ዒንሢኮ ሙዓንዳኔ፤ ባኣቶዋ ዒንሢኮ ሙይ ባይዛንዳኔ፤ ዻካ ዓሲ ሌሊ ዒንሢፓ ዓታንዳሢሮ ጎይፃ ዒንሢኮ ሴማንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«ያዺ ማዔንቴያ ዒንሢ ታኣም ዋይዞ ዒፄቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ታ ዒንሢዳ ዻጋዺ ዎንዳስካፓ ዑሣ ዓኣዼ ላንካይ ጳንጬ ማዔ ሜቶ ዒንሢዳ ታ ሄሊሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ታኣና ዎላ ጫኣቄ ጫኣቁሞ ዒንሢ ሃሼሢሮ ዒንሢ ሜታሳኒ ዖልዚ ታ ዔኪ ዬይሳንዳኔ፤ ሜታ ባኣያ ኮሺ ናንጋንዳኔ ጌይ ካታሞይዳ ዒንሢ ቡኪንቴቴያ ሃሹዋ ዶርዖ ታ ዒንሢም ዳካንዳኔ፤ ዒንሢ ሞርኮም ባሺንቲ ኩቺ ዒንሢ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ዒንሢ ሙዓንዳ ባኣዚ ታ ባይዛንዳሢሮ ታጶ ላኣሊ ፔቴ ቦኦቆይዳ ሌሊ ላኣዳንዳኔ፤ ዬይ ካሣ ጊዳንዳቴያ ጊዲንዱዋቴያ ዓርቂ ዛጊ ዔያታ ጊሽካንዳኔ፤ ዬያ ዒንሢ ሙዓንዳኔ ጋዓንቴ ሚሽካዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«ዬይ ቢያ ያዺ ማዔንቴያ ታና ዒፂ፤ ሃሣ ታኣም ዓይሢንቶዋ ዒንሢ ዒፃያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ታኣኒ ዒንሢዳ ዻጋዺ፥ ቤርታ ሄሊሴ ሜታሢዳፓ ዑሣ ዓኣዼ ሜቶ ላንካይ ጳንጬ ማዓያ ዒንሢዳ ዔኪ ዬዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ናያ ዒንሢ ሚርጌና ባሻንዳሢሮ ናኣቶ ዒንሢኮ ዒንሢ ሙዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ጌሜራ ጌሜራ ዒንሢኮ ዚጊ ካኣሽኮ ቤዞ ታ ሻሃንዳኔ፤ ዑንጆ ጩቢሶ ቤዞዋ ዒንሢኮ ታ ዶይሲ ባይዛንዳኔ፤ ሌዞ ዒንሢኮ ታኣኒ ዒንሢ ካኣሽካ ባኮኮ ሻሂ ኬኤሮናሢዳ ኬኤራንዳኔ፤ ሃሣ ዒናፓ ታ ዒፂ ሻኣኪንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ዒንሢ ናንጋ ካታሞ ታኣኒ ዶይሳንዳኔ፤ ዒንሢ ካኣሽካ ቤዞዋ ዒንሢኮ ታ ባይዛንዳኔ፤ ዒንሢ ታኣም ሚቺ ዒንጋ ባኮዋ ታ ዔካዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ዓጮ ታ ዒንሢኮ ጉቤና ባይዛንዳኔ፤ ዒኢካ ናንጋ ዒንሢኮ ሞርካ ዬያና ዲቃቲ ሄርሻንዳጉዲ ታ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ዖልዚ ታ ዒንሢዳ ዔቂሲ ሜሌ ዴሮ ባኣካ ዒንሢ ታ ዜርቃንዳኔ፤ ዬያሮ ዓጫ ዒንሢኮ ዓሲ ናንጉዋያ፥ ካታማኣ ዒንሢኮ ዶዔያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ሳዔላ ጉሪ ማዓ ዎዶና፤ ዒንሢኮ ሞርኮ ዓጮ ዒንሢ ዓኣዼ ዎዶና ሳዓ ጎሽኪንቱዋያ ሌዖይዳ ሃውሼሢሮ ዎዛዻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ዒንሢ ዒዞይዳ ናንጋኣና ሃውሾ ኬሎናታዖ ዒዛ ሃውሺባኣሴ፤ ጉሪ ዒዛ ማዔ ዎዶና ጋዓንቴ ዬያ ቢያ ዒዛ ዴንቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«ዒንሢዳፓ ሼምፔና ዓቴ ዓሶ፤ ሃሣ ሞርኮ ዓጫ ዴንዲ ዓኣ ዓሶይዳ ዒጊቹሞ ታ ጌልዛንዳኔ፤ ዢባራ ዓጊሣ ቡኡሮ ዑኡዛ ዔያቶ ዲቃሣያ ማዓንዳኔ፤ ዔያቶ ዳውሳ ዓሲ ባኣንቴ ዖልዚሮ ዓኣሺንታ ዓሲጉዲ ጳሽኪ ሎኦሚ ዔያታ ሜቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ዔያቶ ዳውሳ ዓሲ ባኣንቴ ዖልዚፓ ቶላኒ ጳሽካ ዓሲጉዲ ጳሽኪ ፔቴይ ባጋሢዳ ዹቂንቲ ሎኦማንዳኔ፤ ዒንሢኮ ሞርኮ ቤርታ ዒንሢ ዶዲ ዔቃኒ ዳንዳዓዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ሜሌ ዴሮ ባኣካ ዒንሢ ሃይቂ ጋፓንዳኔ፤ ዒንሢኮ ሞርኮ ዓጮይዳኣ ዒንሢ ዓኣዺ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ዒንሢኮ ሞርኮ ዓጮይዳ ሃይቁዋዖ ዓታንዳ ዻኮ ዓሶንሢ ዔያቶ ጎሞና ዔያቶኮ ቤርታኣ ዓዶንሢ ጎማፓ ዔቄያና ዖኦፒ፥ ዻቁዋያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«ጋዓንቴ ዒንሢ ፃጶ ማዔ ዓሳ ፔ ጎሞና ዔያቶኮ ዓዶንሢ ጎሞ ቡኡፄቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ዬይያ፦ ታኣኒ ዔያቶ ዑፃ ዻጋዻንዳጉዲና ዔያቶኮ ሞርኮ ዓጮ ዔያቶ ታ ዳካንዳጉዲ ማሄ ጎሞ ዔያታ ቡኡፄቴ፥ ዋይዞ ዒፂ ዶዳ ዒና ዔያቶኮ ሺኢቴቴ፤ ሃሣ ዔያታ ማዼ ጎሞ ዛሎ ዒንጊንታ ሜቶ ዔካያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ታኣኒ ያይቆኦቤና ዪሳኣቄና ሃሣ ዓብራሃሜና ዎላ ጫኣቄ ጫኣቁሞ ጶቂሣንዳኔ፤ ዓጮማኣ ዔያቶኮ ታ ማላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ሳዔላ ዔያታ ሃሺ ዓኣዼሢሮ ጉሪ ማዒ ዓታንዳኔ፤ ዔያታ ባኣያ ማዔሢሮ ጉሪ ማዒ ናንጋሢሮና ሃውሺ ዴዔሢናሮ ዎዛዻንዳኔ፤ ታኣኮ ዎጎ ዔያታ ሼሌዒሲ ዛጊ፥ ሃሣ ታኣኮ ዓይሢፆዋ ቦሂፆና ዔያቶኮ ጎሞ ዛሎ ዒንጊንታ ሜቶ ዔያታ ዔካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ዬይ ያዺ ማዔቴያ ዔያቶና ዎላ ታ ጫኣቄ ጫኣቁሞ ሃሺ ዔያታ ፔኤኮ ሞርኮ ዓጫ ዓኣቴያ ፔቶ ዔያታ ባይቃንዳያ ሄላንዳኣና ታ ዒፂ ሃሻዓኬ፤ ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዔያቶኮ ፆኦዛሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ታኣኒ ዔያቶኮ ፆኦዛሢ ማዓኒ ሜሌ ዴራ ዛጋንቴ ጊብፄ ዓጮይዳፓ ታኣኒ ኬሴ፥ ዔያቶኮ ዓዶንሢና ዎላ ጫኣቄ ጫኣቁሞ ዔያቶሮ ጌይ ታ ጶቂሣንዳኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ሙሴ ሲና ዹኮይዳ ዓኣንቴ ዒዚ ዒስራዔኤሌ ዴሮም ኬኤዛንዳጉዲ ናንጊና ናንጋ ጎዳ ዒዛም ዔርዜ ዎጎንታ ዳምቦንታ ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«ዒስራዔኤሌ ዴሮም ሂዚ ጌዔ፤ ዓይጎ ዓሲያ ማዖም ናንጊና ናንጋ ጎዳም ዓሲ ዒንጋኒ ናኣቤያ ማዔቴ ሃካፓ ሊካ ዓኣ ሚኢሾ ዓሢ ዛሎ ጪጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","ሌዓ ላማታሚፓ ዴንዲ ላሂታሚ ሄላ ጋራ ዓኣ ዓሲ ማዔቴ ጌኤዦ ማኣሮይዳ ሹጮ ቢሮኮ ዴኤሡሞ ዔሮ ባኮና ላሆ ፄኤታ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ዬኖ ሌዖ ጋራ ዓኣ ላኣሊም ሃይሦ ፄኤታ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ሌዓ ዶንጊታሚፓ ዴንዲ ላሂታሚ ሄላ ጋራ ዓኣ ዓቲንቄ ናይም ላምዖ ፄኤታ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ሃሣ ዬኖ ሌዖ ጋራ ዓኣ ዉዱሮ ናይም ፄኤታና ታጶ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ሌዓ ሃሣ ፔቴ ዓጊኒዳፓ ዴንዲ ዶንጎ ሌዔ ማዔ ዓቲንቄ ናይም ዶንጊታሚ ዶንጎ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ዬኖ ሌዖ ጋራ ዓኣ ዉዱሮ ናይም ሃይሢታሚ ዶንጎ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ሌዓ ላሂታሚፓ ዑሣ ዓኣዼ ማዔ ዓቲንቄም ፄኤታና ላንካይታሚ ጊራኣሜ ማዓ ሹቺ ቢራ፤ ዬኖ ሌዖ ጋራ ዓኣ ላኣሊም ፄኤታና ታጶ ጊራኣሜ ማዓ ሹቺ ቢራ ጪጎንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","«ጋዓንቴ ናኣቦ ናኣቤ ዓሢ ዬያ ጌይንቴ ሚኢሾ ጪጋኒ ዳንዳዑዋያ ማዔቴ ዒዚ ዒንጌ ዓሶማ ቄኤሳሢ ኮይላ ዔኪ ዒ ሙካዛ፥ ቄኤሳሢ ዒዚ ጪጋኒ ዳንዳዓሢጉዴያ ዓርቂ ዻካ ጪጊሶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«ናኣቦና ናኣባ ፆኦሲም ዒንጎ ዒንጊሢ ማዓኒ ኮይሳ ቆልሞ ማዔቴ ዒንጊንቴ ዒንጊፃ ቢያ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ዬይ ዓሢ ዒንጊንቴ ኮሺ ቆልሞ ሜሌ ፑርታ ዔኪ ሙኪ ላኣሚ ዒንጋኒ ኮይሱዋሴ፤ ሃሣ ፑርታ ዒንጌዖዋ ኮሺና ላኣማኒ ኮይሱዋሴ፤ ዬያይዳኒ ዔኪ ሙኪንቴቴ ላምዖ ቆልሞንሢ ቢያ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ዒንጊንቴሢ ዳምቦ ጎይፆና ናንጊና ናንጋ ጎዳም ዒንጊንታኒ ኮይሱዋ ቆልሞ ማዔቴ ዓሢ ዬያ ዒንጊንቴ ባኮ ዔኪ ቄኤሳሢ ኮይላ ሙኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ዬካፓ ቄኤሳሢ ዒንጊንቴ ቆልማ ኮሺታቴያ ፑርታታቴያ ዛጊ ዔካንዳ ሚኢሾ ዓርቂ ኬኤዞንጎ፤ ዬይ ሚኢሻ ቄኤሳሢ ጌዔሢጉዲ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ቆልሞ ዒንጌ ዓሢ ፔኤሮ ሻንቃኒ ኮዔቴ ዒንጎንጎ ጌይንቴ ሚኢሾ ዑፃ ዶንጎፓ ፔቴ ኩቺ ቃሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«ፔቴ ዓሲ ፔኤኮ ማኣሮ ናንጊና ናንጋ ጎዳም ዱማዼያ ማሂ ዒንጌቴ ቄኤሳሢ ዬና ማኣሬላ ኮሺታቴያ ፑርታ ማዒፆኮ ጊቶ ዛጊ ኬሳንዳ ሚኢሾ ዓርቆንጎ፤ ቄኤሳሢ ጌዔ ጎይፆ ዬይ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ዬኖ ማኣሬሎኮ ዓዳሢ ማሂ ሻንቃኒ ኮዔቴ ዒንጎንጎ ጌይንቴ ሚኢሾይዳ ዶንጎፓ ፔቴ ኩቺ ቃሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«ፔቴ ዓሲ ፔኤኮ ሳዖይዳፓ ፓቂ ናንጊና ናንጋ ጎዳም ዱማዼ ዒንጊሢ ማሂ ዒንጌቴ ሳዔላ ዒኢካ ዜርቂንታኒ ዳንዳዓ ዜርፆ ጎይፆ ሚኢሻ ዓርቂንቶንጎ፤ ላማታሚ ኪሎ ማዓ ዔልዓ ዜርቂንታንዳ ሳዓኮ ዶንጊታሚ ሹቺ ቢራ ጪጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ዬይ ዓሢ ሳዖ ፔኤኮ ሻንቂንቴ ባኮ ማሂፆ ሌዓ ዒንጌያ ማዔቴ ጌይንቴ ሚኢሾ ቢያ ጪጋንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ጋዓንቴ ዒ ዒንጌሢ ሻንቂንቴ ባኮ ማሂሲፆ ሌዓ ዓኣዼንቴ ኔጌዖ ዒንጌያ ማዔቴ ቄኤሳሢ ሻንቂንቴ ባኮ ማሂፆ ሌዓ ሄላንዳሢኮ ጋራ ዓኣ ዓቴ ሌዖ ሌሊ ማሊ ሚኢሾ ዓርቆንጎ፤ ዬያሮ ሚኢሻ ፓጬ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ሳዖ ዒንጌ ዓሢ ፔኤሮ ሻንቃኒ ኮዔቴ ዒንጎንጎ ጌይንቴሢዳ ዶንጎፓ ፔቴ ኩቺ ቃሶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ዬይ ዓሢ ሳዔሎ ሚኢሼ ጪጊ ማሂሲ ዔኩዋዖ ዓሲም ሻንቼያ ማዔቴ ዬኖ ዒ ማሂ ዔካኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ሳዔላ ሻንቺንቴ ባኮ ማሂፆ ሌዖይዳ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዒ ዓታ ቤሲ ማዔም ቄኤሳ ዔካ ቤሲ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«ፔቴ ዓሲ ባጋሢዳፓ ሻንቂ ዔኬ ሳዓ ናንጊና ናንጋ ጎዳም ዱማዼ ዒንጊሢ ማሂ ዒንጌቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ቄኤሳሢ ሳዔሎ ዛጋዖ ሻንቂንቴ ባኮ ማሂፆ ሌዖ ሄላንዳኣና ጋራ ዓኣ ሌዖ ማሊ ኬሳንዳ ሚኢሾ ኬኤዛዛ ዓሢ ጌይንቴ ሚኢሾ ናንጊና ናንጋ ጎዳም ዒንጋያ ማሂ ዬኖ ኬሎ ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ሻንቂንቴ ባኮ ማሂፆ ሌዖና ሳዔላ ቤርታ ሻንቼ ዓሢም ማዔቴያ ዒዛኮ ዜርፆም ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«ፔቴ ፔቴ ባካ ‹ያዺ ዔካንዳኔ› ጌይንቲ ዔርታሢ ጌኤዦ ማኣሮይዳ ሚኢሾኮ ዴኤሡሞ ዔሮ ባኮና ዛጊንቲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«ቆልሞኮ ቤርታ ሾይንቴ ናይ ናንጊና ናንጋ ጎዳሮ ማዔሢሮ ዖናታቴያ ፔ ማሊሢና ናሽኪ ዒንጋ ዒንጊሢ ማሂ ዒንጋኒ ዳንዳዑዋሴ፤ ናኣሪታቴያ ማራናይ፤ ዬያጉዲ ሃሣ ዋናናይያኣ ቤርታዺ ናንጊና ናንጋ ጎዳም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ዎጎ ጎይፆና ናንጊና ናንጋ ጎዳም ዒንጊንታኒ ዳንዳዑዋ ቆልሞኮ ቤርቲ ናይ ማዔቴ ዒንጌ ዓሢ ‹ያዺ ኬሳንዳኔ› ጌይንቴ ሚኢሾ ዑፃ ዶንጎፓ ፔቴ ኩቺ ቃሲ ጪጊ ማሂ ዔካኒ ዳንዳዓኔ፤ ዔቦኮ ዓዴ ማሂ ዔካኒ ኮይባኣቴ ጋዓንቴ ‹ያዺ ኬሳንዳኔ› ጌይንቴ ሚኢሾና ሜሌ ዓሲ ሻንቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«ፔቴ ዓሲ ዓሲ ማዔቴያ ቆልሞ፤ ጊንሣ ሃሣ ሳዓ ጉቤና ናንጊና ናንጋ ጎዳም ዱማዻንዳጉዲ ማሄስካፓ ሻንቻኒያ ማሂ ሻንቃኒያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ዓሲ ማዔቴያ ሃይቃንዳጉዲ ዎጊንቴስካፓ ላሚ ጊንሣ ማሂ ሻንቃኒ ኮይሱዋሴ፤ ያዺ ጌይንቴ ዓሢ ዎዎዺንታንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«ጎዣፓ ጴዼ ሃኣኮ ማዔቴያ ቱኪ ዓኣፒሶና ሚፆ ዓኣፖኮ ታጶይዳፓ ፔቴማ ናንጊና ናንጋ ጎዳሮ ማዒ ዒዛም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ዬያ ዒንጊንቴ ባኮ ዓይጎዋ ማዖም ማሂ ሻንቂ ዔካኒ ኮዓ ዓሲ ‹ያዺ ኬሳንዳኔ› ጌይንቴ ሚኢሾይዳ ዶንጎፓ ፔቴ ኩቺ ቃሳንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ቆልሞ ዒንሢኮ ዒንሢ ፓይዳንዳቴ ታጶ ኩሜቴ ፔቴማ ናንጊና ናንጋ ጎዳሮኬ፤ ዬማ ቆልሞማ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ቆልሞ ዒንጌ ዓሣሢ ዒንጊንታ ቆልሞ ኮዦ ፑርቶፓ ፑርቶዋ ኮዦፓ ዱማሶፓ፤ ጊንሣ ማሂ ሃሣ ቤዛ ሜሌ ቆልሞ ዒንጎፓ፤ ዬያይዲ ላኣማኒ ዔኪ ሺኢሼቴ ላምዖንሢ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዖንጎ፤ ማሂ ጊንሣ ዬይ ዓሢ ሻንቂ ዔካኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ዒስራዔኤሌ ዴሮም ኬኤዚንታንዳጉዲ ሙሴ ሲና ዹኮይዳ ዓኣንቴ ናንጊና ናንጋ ጎዳ ዒዛ ዔርዜ ዎጎና ዳምቦና ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ዒስራዔኤሌ ዴራ ጊብፄ ዓጫፓ ኬስኬንቴ ላምዓሳ ሌዖና ላምዓሳ ዓጊኖኮ ቤርታሳ ኬሎ ሲና ጌይንታ ዓሲ ናንጉዋ ዳውሎይዳ ዓኣንቴ ዓፒሎና ማዢንቴ ፆኦሲ ዴሮና ካኣማ ማኣሮፓ ናንጊና ናንጋ ጎዳ ሙሴም ኬኤዛዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","«ዒስራዔኤሌ ዴሮ ፃጶና ፃጶና፥ ሃሣ ማኣሮ ዓሶና ዓሶና ማሂ ፓቂ ኔናንታ ዓኣሮኔንታ ዓቲንቆ ፓይዱዋቴ፤ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ ሃሣ ዖልዚና ዓጪ ካፓኒ ዳንዳዓ ዓቲንቆ ቢያ ዱማ ዱማ ዖላ ዓሲ ማሂ ፓቂ ፓቂ ፃኣፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ፔቴ ፔቴ ፃጶይዳፓ ዬኖ ማኣሮኮ ሱኡጌ ማዒ ዒንሢ ማኣዳንዳ ፔቴ ፔቴ ዓሲ ዶኦሩዋቴ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ዒንሢ ማኣዳንዳ ዓሳ ሃካፓ ሊካ ፓይዲንታዞንሢኬ፦ ሮኦቤኤሌ ዓሶፓ ሼዴዑሬ ናኣዚ ዔኤሊፁሬ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ሲሞኦኔ ዓሶፓ ፁሪሻዳዬ ናኣዚ ሼሉሚዔኤሌ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ዪሁዳ ዓሶፓ ዓምናኣዳኣቤ ናኣዚ ናዓሶኔ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ዪሳኮኦሬ ዓሶፓ ፁዓሬ ናኣዚ ናቲናዔኤሌ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ዛብሎኦኔ ዓሶፓ ሄሎኔ ናኣዚ ዔኤሊዓቤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ዮሴፔ ናኣቶኮ ዔፕሬኤሜ ዓሶፓ ዓሚሁዴ ናኣዚ ዔልሻማዔ ሚናኣሴ ዓሶፓ ፔዳፁሬ ናኣዚ ጌማሊዔኤሌ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ቢኢኒያሜ ዓሶፓ ጊዲዮኔ ናኣዚ ዓብዳኣኔ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ዳኣኔ ዓሶፓ ዓምሻዳዬ ናኣዚ ዓሂዔዜሬ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ዓሴኤሬ ዓሶፓ ዖክራኔ ናኣዚ ፓግዔኤሌ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ጋኣዴ ዓሶፓ ዴዑዔኤሌ ናኣዚ ዔኤሊያሳፔ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ኒፕታኣሌኤሜ ዓሶፓ ዔናኔ ናኣዚ ዓሂራዔ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ዴሮ ባኣኮይዳፓ ፔቴ ፔቴ ዒስራዔኤሌ ማኣሮኮ ሱኡጎ ማዒ ዶኦሪንቴዞንሢ ዬንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ሙሴና ዓኣሮኔና ዬንሢ ታጶ ላምዖ ዓሶንሢና ማኣዲንቲ ማኣዲንቲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ላምዓሳ ዓጊኖኮ ቤርታሳ ኬሎና ዴሮ ቢያ ፔቴይዳ ቡኩሲ ፃጶና ማኣሮ ዓሶና ዓሶና ማሂ ፓቄስካፓ ዴራ ፓይዲንታንዳጉዲ ማዼኔ፤ ዓሶይዳፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ዓኣዼ ዓቲንቆኮ ቢያ፦ ፆኦሲ ዓይሤ ጎይፆና ሱንፃ ፃኣፒንቲ ፃኣፒንቲ ፓይዲንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ሙሴ ዬያይዲ ሲና ቦኦሎይዳ ዴሮ ፓይዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ዖልዚና ዓጪ ካፓኒ ዳንዳዓያ፤ ሃሣ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዓ ዓቲንቃ፥ ያይቆኦቤ ናኣቶኮ ቶይዳሢ ማዔ ሮኦቤኤሌ ማኣራፓ ቢያሢ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ሮኦቤኤሌ ማኣራፓ ፓይዲንቴ ዓሳ ዖይዲታሚ ላሆ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ሲሞኦኔ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ሲሞኦኔ ማኣራፓ ፓይዲንቴ ዓሳ ዶንጊታሚ ታዞጳ ሺያና ሃይሦ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ጋኣዴ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ጋኣዴ ማኣራፓ ፓይዲንቴ ዓሳ ዖይዲታሚ ዶንጎ ሺያና ላሆ ፄኤታና ዶንጊታሚናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ዪሁዳ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ዪሁዳ ማኣራፓ ፓይዲንቴ ዓሳ ላንካይታሚ ዖይዶ ሺያና ላሆ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ዪሳኮኦሬ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ዪሳኮኦሬ ማኣራፓ ፓይዲንቴ ዓሳ ዶንጊታሚ ዖይዶ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ዛብሎኦኔ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ዛብሎኦኔ ማኣራፓ ፓይዲንቴ ዓሳ ዶንጊታሚ ላንካይ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ዮሴፔ ናኣቶኮ ዔፕሬኤሜ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ዔፕሬኤሜ ማኣራፓ ፓይዲንቴ ዓሳ ዖይዲታሚ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ሚናኣሴ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ሚናኣሴ ማኣራፓ ፓይዲንቴ ዓሳ ሃይሢታሚ ላምዖ ሺያና ላምዖ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ቢኢኒያሜ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ቢኢኒያሜ ማኣራፓ ፓይዲንቴ ዓሳ ሃይሢታሚ ዶንጎ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ዳኣኔ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ዳኣኔ ማኣራፓ ፓይዲንቴ ዓሳ ላሂታሚ ላምዖ ሺያና ላንካይ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ዓሴኤሬ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፔኤኮ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ዓሴኤሬ ማኣራፓ ፓይዲንቴ ዓሳ ዖይዲታሚ ፔቴ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ኒፕታኣሌኤሜ ማኣራፓ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ፃጶና ፃጶና፤ ሃሣ ማኣሮና ማኣሮና ማዒ ፓቂንቲ ሱንፃ ፃኣፒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ኒፕታኣሌኤሜ ማኣራፓ ፓይዲንቴ ዓሳ ዶንጊታሚ ሃይሦ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ሙሴንታ ዓኣሮኔንታ ፔቴ ፔቴ ዒስራዔኤሌ ማኣሮ ዛሎ ኬስኬ፥ ታጶ ላምዖ ፃጶኮ ሱኡጎንታ ፓይዴ ዓሳ ዬያቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ዒስራዔኤሌ ዓሶኮ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ማኣሮና ማኣሮና ፓቂንቲ ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ዬያ ፓይዴንቴ ዓሶኮ ሚርጉማ ላሆ ፄኤታና ሃይሦ ሺያና ዶንጎ ፄኤታና ዶንጊታሚናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ሌዊ ዓሳ ጋዓንቴ ሃንጎ፥ ዬኖ ፃጶ ማኣሮና ፓይዲንቲባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ዓይጎሮ ጌዔቴ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«ዖልዚና ዓጪ ካፓኒ ዳንዳዓ ዓቲንቆ ኔ ፓይዳ ዎዶና ሌዊ ዓሶ ጊዳ ቃሲ ፓይዲፖ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ዬያ ዛሎ ሌዊ ዓሶ፦ ታኣኒ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮና ጋሮይዳ ዓኣ ማዺንቶ ባኮ ዑፃ ቢታንቶ ዓኣ ዓሲ ማሂ ጌሤ፤ ዔያታ ዓፒሎና ማዢንቴ ማኣሮና ጋሮናይዳ ዓኣ ባኮ ቢያ ኬዲ ሃንታያ ማዓንዳኔ፤ ሃሣ ዒኢካ ዔያታ ማዻያ ማዓንዳኔ፤ ዬያ ማኣሮኮ ኮይሎይዳ ዔያታ ዱንኪ ዴዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ዒንሢ ዴዓ ቤዛፓ ሃሺ ዴንዳ ዎዶና ሌዊ ዓሳ ሌሊ ታኣኒ ዴሮና ካኣማ ማኣሮ ዾቆና ቤዛፓ ቱጋያ፥ ሃሣ ዒንሢ ዴንዲ ዱንካ ቤዞይዳኣ ዔያታ ዾቃያ ማዖንጎ፤ ዔያቶይዳፓ ዓታዛ ዬኖ ማኣሮ ባንሢ ዖኦኒያ ዑኬቴ ሃይቃንዳጉዲ ዎጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ሃንጎ ዒስራዔኤሌ ዓሳ ዔያቶ ፓቆና ጎይፆ ጎይፆ፤ ጊንሣ ፔኤኮ ፔኤኮ ባንዲሮ ዾቂ ዱንኪ ዴዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ጋዓንቴ ዓይጎ ዓሲያ ማዖም ዬኖ፥ ታኣኒ ዴሮና ካኣማ ማኣሬሎ ባንሢ ዑኪ፥ ዻጎ ታኣኮ ዔቂሲ ዒስራዔኤሌ ዓሶ ኩርሲሱዋጉዲ ሌዊ ዓሳ ዬኖ ዓፒሎና ማዢንቴ ማኣሬሎኮ ኮይሎይዳ ዱንኪ ዴዒ ካፖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ዬያሮ ዒስራዔኤሌ ዴራ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ቢያ ባኮ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«ዒስራዔኤሌ ዓሳ ናንጋ ጉርዶ ቢያይዳ ፔቴ ፔቴ ዓሳ ዔያታ ናንጋ ቤዞም ዒንጊንቴ ባንዲራ ዓኣ ቤዛ ቤዛ ዱንኪ ዴዖንጎ፤ ዔያታ ዴዓንዳሢ ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮ ኮይላ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ዓባ ኬስካ ዛላ ዪሁዳ ዓሲ ማሂ ፓቂንቴ ፃጳ ዔያቶም ዒንጊንቴ ባንዲራ ዓኣ ቤዛ ዱንኪ ዴዖንጎ፤ ዪሁዳ ዓሶኮ ሱኡጋሢ ዓምናኣዳኣቤ ናኣዚ ናዓሶኔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ላንካይታሚ ዖይዶ ሺያና ላሆ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ዬያቶይዳፓ ሄሊሳዖ ዪሳኮኦሬ ማኣሮ ዓሳ ዱንኪ ዴዖንጎ፤ ዪሳኮኦሬ ማኣሮኮ ሱኡጋሢ ሶጌሬ ናኣዚ ናትናዔሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ዶንጊታሚ ዖይዶ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ዬካፓ ሃሣ ዛብሎኦኔ ማኣሮ ዓሳ ዴዓንዳኔ፤ ዛብሎኦኔ ማኣሮኮ ሱኡጋሢ ኬሎኔ ናኣዚ ዔኤሊያቤኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ዶንጊታሚ ላንካይ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ዱማ ዱማ ዖላ ዓሲ ማዒ ዪሁዳና ፓይዲንቴ ዓሶኮ ሚርጉማ ፔቴ ፄኤታና ሳሊታሚ ላሆ ሺያና ዖይዶ ፄኤታናኬ። ቤርታ ዓኣዻንዳ ዓሳ ዬኖ ዓሶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ዾኦሎ ዛሎና ሮኦቤኤሌ ዓሲ ማሂ ፓቂንቴ ፃጳ ዔያቶም ዒንጊንቴ ባንዲራ ዓኣ ቤዛ ዱንኪ ዴዖንጎ፤ ዔያቶኮ ሱኡጎ ማዓንዳሢ ሳዲዮሬ ናኣዚ ዔልሱሬኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ዖይዲታሚ ላሆ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ዔያቶይዳፓ ሄሊሲ ሲሞኦኔ ማኣሮ ዓሳ ዱንኪ ዴዖንጎ፤ ዔያቶኮ ሱኡጎ ማዓንዳሢ ሱሪሳይዴ ናኣዚ ሴሌሚዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ዶንጊታሚ ታዞጳ ሺያና ሃይሦ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ዬካፓ ጋኣዴ ማኣሮ ዓሳ ዴዖንጎ፤ ዬያቶኮ ሱኡጎ ማዓንዳሢ ራጉዔኤሌ ናኣዚ ዔልሳፔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ዖይዲታሚ ዶንጎ ሺያና ላሆ ፄኤታና ዶንጊታሚናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ዱማ ዱማ ዖላ ዓሲ ማዒ ሮኦቤኤሌና ፓይዲንቴ ዓቲንቃ ቢያ ፔቴ ፄኤታና ዶንጊታሚ ፔቴ ሺያና ዖይዶ ፄኤታና ዶንጊታሚናኬ። ዬያይዲ ሮኦቤኤሌ ዓሳ ሄሊሲ ዴንዳኒ ኬስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ቤርታሳ፥ ላምዖ ፓቆና ዓሶና ጋፒንፆይዳ ዓኣ ላምዖ ፓቆና ዓሶናኮ ባኣካ ሌዊ ዓሳ ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮ ኬዲ ዓኣዾንጎ፤ ፔቴ ፔቴ ፓቂንቴ ዓሳ ዱማሳኒ ዒንጊንቴ ባንዲራ ዓኣ ቤዛ ቤዛ ማዒ ዎሊ ሄሊ ሄሊ ኬስኮም ጎዖና ጎይፆማ ዓኣዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ዓባ ጌላ ዛሎና ዔፕሬኤሜ ዓሲ ማሂ ፓቂንቴ ፃጳ ዔያቶም ዒንጊንቴ ማላታ ዓኣ ቤዛ ቤዛ ዱንኪ ዴዖንጎ፤ ዔያቶኮ ሱኡጎ ማዓንዳሢ ዓሚሁዴ ናኣዚ ዔኤሊሳሜኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ዔያቶኮ ፓይዲንቴ፥ ዖላ ዓሶ ሚርጉማ ዖይዲታሚ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ዬካፓ ሄሊሲ ሚናኣሴ ማኣሮ ዓሳ ዴዓንዳኔ፤ ዔያቶኮ ሱኡጎ ማዓንዳሢ ፒዳሱሬ ናኣዚ ጌማሊዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ዔያቶኮ ፓይዲንቴ፥ ፖኦሊሶ ሚርጉማ ሃይሢታሚ ላምዖ ሺያና ላምዖ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ዬካፓ ሃሣ ቢኢኒያሜ ማኣሮ ዓሳ ሄሊሲ ዴንዳንዳኔ፤ ዬያቶኮ ሱኡጌ ማዓንዳሢ ጊዲዮኔ ናኣዚ ዓብዳኣኔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ዔያቶኮ ፓይዲንቴ፥ ፖኦሊሶ ሚርጉማ ሃይሢታሚ ላምዖ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ዱማ ዱማ ዖላ ዓሲ ማዒ ዔፕሬኤሜና ዎላ ፓይዲንቴ ዓቲንቃ ቢያ ፄኤታና ሳሊ ሺያና ፔቴ ፄኤታናኬ፤ ዬያይዲ ዔፕሬኤሜ ዓሳ ሃይሣሲ ዴንዳኒ ኬስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ኬዶ ዛሎና ዳኣኔ ዓሲ ማሂ ፓቂንቴ ፃጳ ዔያቶም ዒንጊንቴ ባንዲራ ዓኣ ቤዛ ቤዛ ዱንኪ ዴዖንጎ፤ ዬያቶኮ ሱኡጌ ማዓንዳሢ ዓምሳዳዬ ናኣዚ ዓክዔዜሬኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ዔያቶኮ ፓይዲንቴ፥ ፖኦሊሶ ሚርጉማ ላሂታሚ ላምዖ ሺያና ላንካይ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ዬያቶ ሄሊሲ ዓሴኤሬ ማኣሮ ዓሳ ዱንኪ ዴዖንጎ፤ ዬያቶኮ ሱኡጌ ማዓንዳሢ ዓክራኔ ናኣዚ ፓግዒዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ዔያቶኮ ፓይዲንቴ፥ ፖኦሊሶ ሚርጉማ ዖይዲታሚ ፔቴ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ዬካፓ ኒፕታኣሌኤሜ ዓሳ ዱንኪ ዴዓንዳኔ፤ ዬያቶኮ ሱኡጌ ማዓንዳሢ ዔናኔ ናኣዚ ዓኪሬኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ዔያቶኮ ፓይዲንቴ፥ ፖኦሊሶ ሚርጉማ ዶንጊታሚ ሃይሦ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ዱማ ዱማ ዖላ ዓሲ ማዒ ዳኣኔና ዎላ ፓይዲንቴ ዓቲንቃ ቢያ ፔቴ ፄኤታና ዶንጊታሚ ላንካይ ሺያና ላሆ ፄኤታናኬ። ዬያይዲ ዳኣኔ ዓሳ ዖይዳሲ ዴንዳኒ ኬስኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ፔቴ ፔቴ ቤዛ ፓቂንቲ፥ ሱንፃ ፃኣፒንቴ ዒስራዔኤሌ ዴሮኮ ሚርጉማ ዎሊ ዑፃ ላሆ ፄኤታና ሃይሦ ሺያና ዶንጎ ፄኤታና ዶንጊታሚ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ሌዊ ዓሳ ጋዓንቴ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ሃንጎ ዒስራዔኤሌ ዓሶና ዎላ ፃኣፒንቲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ዬያይዲ ዒስራዔኤሌ ዴራ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ቢያ ባኮ ኩንሤኔ፤ ፔቴ ፔቴ ፃጳ ፔኤም ዒንጊንቴ ባንዲራ ዓኣ ቤዛ ቤዛ ዴዔኔ፤ ሃሣ ፔቴ ፔቴ ዓሳኣ ፔ ዜርፆና ፔ ማኣሮ ዓሶና ማዒ ማዒ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዎላ ሲና ዹኮይዳ ጌስቴ ዎዶና ዓኣሮኔንታ ሙሴንታኮ ሾይንቴ ናኣታ ሃካፓ ሊካ ፓይዲንታዞንሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ዓኣሮኔኮ ዖይዶ ዓቲንቄ ናይ ዓኣኔ፤ ቶይዳሢ ናኣዳቤኬ፤ ጌኤዛታ ዓቢሁና ዓላዜሬና ዒታማሬናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ዔያታ ቢያ ቄኤሴ ማዓንዳጉዲ ዛይቴና ቲሽኪንቲ ዶኦሚንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ጋዓንቴ ዔያቶይዳፓ ናኣዳቤና ዓቢሁና ሲና ቦኦሎይዳ ፆኦሲም ዱማዺባኣ ታሞ ናንጊና ናንጋ ጎዳም ሺኢሼሢሮ ፆኦሲ ዔያቶ ዎዼኔ፤ ናይያ ዔያቶኮ ባኣሴ፤ ዬያሮ ዓላዜሬና ዒታማሬና ዔያቶኮ ዓዳሢ፥ ዓኣሮኔ ሼምፔና ናንጌ ዎዶይዳ ቢያ ቄኤሴ ማዒ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«ሌዊ ማኣሮ ዓሶ ዔኪ ሙኪጋፓ ዔያታ ዓኣሮኔ ማኣዲ ማዻንዳጉዲ ማሄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ዔያታ ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮይዳ ዓኣሮኔና ዴሮናም ማዺ ማዺ ዓይሢንቴ ባኮ ቢያ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ታኣኒ ዒንሢና ካኣማ ዓፒሎና ማዦ ማኣሮ ጋሮይዳ ማዺንቶ ሜሆ ቢያ ቆላያ ማዖንጎ፤ ዒስራዔኤሌ ዴሮ ዛሎ ማዺንታ ማዾ ማዺ ዓይሢንቴ ባኮ ቢያ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ዬያሮ ዒስራዔኤሌ ዓሶይዳፓ ዔያታ ዱማዺ፥ ዓኣሮኔና ናኣቶና ማኣዲ ማዻንዳጉዲ ማሄ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ቄኤሴ ማዒ ዔያታ ማዻንዳጉዲ ዓኣሮኔና ናኣቶና ዶኦሬ፤ ዔያቶይዳፓ ዓታዛ ሜሌ ዓሲ ዬያ ማዾ ማዻኒ ማሌቴ ዎዎዺንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ሃሣ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","«ዓካሪ ሌዊ ዓሳ ታኣም ማዻ ዓሲኬ፤ ጊብፄ ዓሶኮ ቶይዶ ናኣቶ ቢያ ታ ዎዼያና ዒስራዔኤሌ ዓሲ ማዒ ሾይንታ ቶይዲ ናይና ቆልሞኮዋ ቤርቶ ናኣቶ ታኣም ታኣኒ ዱማሴኔ፤ ሃሢ ጋዓንቴ ቶይዶ ማዒ ሾይንታ ዓቲንቆ ናኣቶ ታኣም ዱማሲፆ ቤዞ ሌዊ ዓሶ ታ ዶኦሬኔ፤ ዔያታ ታኣም ማዻያ ማዖንጎ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ናንጊና ናንጋ ጎዳ ሙሴም ሲና ዹኮይዳ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«ሌዊ ዓሶ ፔ ዜርፆና ፔ ማኣሮ ዓሶና ማሂ ፓይዴ፤ ሾይንቴንቴ ዓጊኒ ማዔያና ዬካፓ ዑሣ ማዔ ዓቲንቄ ቢያ ፓይዴ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ሙሴያ ጌይንቴ ጎይፆ ማዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","20","ሌዊኮ ሃይሦ ዓቲንቄ ናይ ዓኣኔ፤ ዔያታኣ፦ ጌርሾኔ፥ ቄዓቴና ሜራሪ ጌይንታያኬ። ዔያቶኮዋ ናይ ዓኣኔ። ጌርሾኔኮ ሊቢኒና ሺምዒ ጌይንታ ላምዖ ዓቲንቄ ናይ ዓኣኔ፤ ቄዓቴኮ ዓምራሜ፥ ዪፅሃሬ፥ ኬብሮኦኔና ዑዚዔኤሌ ጌይንታ ዖይዶ ዓቲንቄ ናይ ዓኣኔ። ሜራሪኮ ማሂሊና ሙሺ ጌይንታ ላምዖ ዓቲንቄ ናይ ዓኣኔ። ሌዊ ዓሶ ማዒ ፔ ማኣሮ ዓሶና ፓይዲንቴዞንሢ ዬያቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ሊቢኒና ሺምዒ ማኣሮ ዓሳ፦ ጌርሾኔ ፃጶይዳ ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ዔያቶኮ ሾይንቴንቴ ዓጊኒ ማዔ ናይዳፓ ዓርቃዖ ፃኣፒንቴ ዓቲንቃ ላንካይ ሺያና ዶንጎ ፄኤታ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ዬና ዓሳ ዓፒሎና ማዦና ማኣሮኮ ጊንፃ፥ ዓባ ጌላ ዛላ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ዬኖ ዜርፆኮ ሱኡጋሢ ላዔኤሌ ናኣዚ፥ ዔኤሊያሳፔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ዔያታ፦ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮንታ ዬያ ማኣሮኮ ዙሎና ጋሮና ካንቆ ባኮ፥ ጌሎ ካሮ ጎኦቦ ዓፒሎ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ቃምዖ ጋሮ ጎኦቦና ዓፒሎ፥ ዓፒሎና ማዢንቴ ማኣሮንታ ፆኦሲም ሚቺ ዒንጎ ቤዞ ጌሎ ካሮ ጎኦቦ ዓፒሎንታ ዱማ ዱማ ሱዞንታ፤ ዬያጉዲ ዬይ ባካ ቢያ ማዺንታ ሜሆ ቢያ ካፒ ቆላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ዓምራሜ፥ ዪፅሃሬ፥ ኬብሮኦኔንታ ዑዚዔኤሌንታኮ ማኣሮ ዓሳ ቄዓቴ ዓሶ ባኣካ ፓይዲንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ዔያቶኮ ሾይንቴንቴ ዓጊኒ ማዔ ናኣቶይዳፓ ዓርቃዖ ፃኣፒንቴ ዓቲንቃ ሳሊ ሺያና ላሆ ፄኤታናኬ፤ ዔያታኣ፦ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካፓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ዒማና ቄዓቴ ዓሳ ዱንኪ ዴዓሢ ዓፒሎና ማዢንቴ ማኣሮኮ ዾኦሎ ዛሎይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ዔያቶኮ ሱኡጋሢ ዑዚዔኤሌ ናኣዚ፥ ዔኤሊፃፓኔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ዔያታ፦ ጫኣቁሞ ሳኣፂኖ፥ ዼጌ ሎኦዦ ዖይቶ፥ ፓዖ ጌሦ ሻርኖ፥ ፆኦሲም ሚቺ ዒንጎ ቤዞ፥ ቄኤሳ ጌኤዦ ቤዞይዳ ማዾ ማዻ ፆኦሲም ዱማዼ ባኮ፥ ፆኦሲም ዑሣ ዓኣዼ ዱማዼ ቤዞ ጌሎ ካሮ ጎኦቦ ዓፒሎንታ ዬያ ባኮ ቢያ ካፒ ቆላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ሌዊ ዓሶኮ ቢያ ሱኡጋሢ ቄኤሳሢ ዓኣሮኔ ናኣዚ፥ ዓላዜሬኬ፤ ዒዚ ጌኤዦ ቤዞይዳ ማዻ ዓሶኮ ቢያ ዑፃሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ማሂሊና ሙሺናኮ ማኣሮ ዓሳ ሜራሪ ዓሶና ፓይዲንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ሾይንቴንቴ ፔቴ ዓጊኒ ማዔ ናኣቶይዳፓ ዓርቃዖ ዔያቶኮ ፃኣፒንቴ ዓቲንቃ ላሆ ሺያና ላምዖ ፄኤታ ማዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ዬና ዓሳ ዒማና ዱንኪ ዴዔሢ ዓፒሎና ማዢንቴ ማኣሮኮ ኬዶ ዛላኬ፤ ዔያቶኮ ሱኡጋሢ ዓቢዔኤሌ ናኣዚ፥ ፁሪዔኤሌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ዔያታ ዓፒሎና ማዢንቴ ማኣሮኮ ላሻሢ ሚፆና ጋጋርዞና፥ ቱርቶሮና ቱርቱራ ዔቃ ቶኮና፤ ዬያጉዲ ሃንጎ ማዺንቶ ባኮ ካፒ ቆላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ሃሣ ጌኤዦ ቤዞኮ ዲፆ ዓጫ ዾቆ ሚፆንታ ዬያ ዔቂሶ ቶካ፥ ዓንጎ ፃውኖንታ ሱዞንታ ካፒ ቆላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ዒማና ሙሴና ዓኣሮኔና ዓኣሮኔኮ ናኣቶና ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ዓባ ኬስካ ዛላ ዱንኪ ዴዓኔ፤ ዬኖ ጌኤዦ ማኣሮይዳ ዒስራዔኤሌ ዴሮ ዛሎ ማዺንታ ዳምቦ ኩንሢሳ ዓሳ ዔያቶኬ፤ ሜሌ ዓይጎ ዓሲያ ዬያ ጌኤዦ ማኣሮ ባንሢ ዑኬቴ ዎዎዺንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ፔቴ ዓጊኒ ማዔ ናይዳፓ ዓርቃዖ ፃኣፒንቴ ሌዊ ዓሶኮ ዓቲንቃ ጉቤ ላማታሚ ላምዖ ሺያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ቶይዶ ማዒ ሾይንቴ፥ ዒስራዔኤሌ ዓሶኮ ዓቲንቆ ናኣቶ፤ ሾይንቴንቴ ዓጊኒ ማዔሢንታ ዬያፓ ዑሣ ሌዓ ዓኣዼ ዓቲንቆ ቢያ ፓይዲ ፃኣፔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ታኣኒ ዔያቶ ቤዛ ሌዊ ዓሶ ታኣም ዶኦሬኔ፤ ሃሣ ዒስራዔኤሌ ዓሶ ቆልሞኮ ቤርታ ሾይንቴ ናኣቶ ቤዛ ሌዊ ዓሶ ቆልሞ ታኣም ታ ዶኦሬኔ፤ ታኣኒ ናንጊና ናንጋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ሙሴያ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆና ዒስራዔኤሌ ዓሶ ባኣካፓ ቶይዶ ቶይዶ ማዒ ሾይንቴ ዓቲንቆ ቢያ ፓይዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ፔቴ ዓጊኒና ዬካፓ ዑሣ ሌዓ ማዔም ሱንፆና ሱንፆና ፃኣፒንቴ ቶይዶ ማዔ ዓቲንቆኮ ሚርጉማ ላማታሚ ላምዖ ሺያና ላምዖ ፄኤታና ላንካይታሚ ሃይሦ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«ዓካሪ፥ ዒስራዔኤሌ ዓሶኮ ቶይዶ ናኣቶ ማዒ ሾይንቴ ዓቲንቆ ቤዛ ሌዊ ዓሶ ታኣም ዱማሴ፤ ዬያጉዲ ዒስራዔኤሌ ዓሶ ቆልሞኮ ቤርቲ ማዒ ሾይንቴ ናኣቶ ቤዛ ሌዊ ዓሶ ቆልሞ ታኣም ዱማሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ዒስራዔኤሌ ዓሶኮ ቶይዶ ናኣቶ ማዒ ሾይንታ ዓቲንቆ ሚርጉማ ሌዊ ዓሶይዳፓ ላምዖ ፄኤታና ላንካይታሚ ሃይሦ ዓሲና ባሼሢሮ ዬያቶ ዑሣ ዓኣዼ ዓቲንቆ ዛሎ ሚኢሼ ዔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ፔቴ ፔቴሢ ዛሎ ኔ ዔካንዳ ሚኢሻ ጌኤዦ ማኣሮይዳ ሚኢሾ ዴኤሡሞ ዔሮ ባኮና ዶንጊታሚ ዶንጎ ጊራኣሜ ማዓ ሹቺ ቢራ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ዬኖ ዓሶ ዛሎ ኔ ዔኬ ሚኢሾ ዓኣሮኔና ዒዛኮ ናኣቶናም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","51","ሙሴ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ሌዊ ዓሶይዳፓ ዺቢ ዑሣ ዓኣዼ፥ ዒስራዔኤሌ ዓሶኮ ዓቲንቆ ዛሎ ታጶ ዶንጎና ዛላ ኪሎ ማዓ ሹቺ ቢራ ዔኪ ዓኣሮኔና ዒዛኮ ናኣቶናም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«ቄዓቴ ዜርፆ ማዔ፥ ሌዊ ዓሶ ዔያቶኮ ማኣሮና ማኣሮና፤ ጊንሣ ቶኦኮና ቶኦኮና ማሂ ፓይዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒ ዳንዳዓያ፤ ሌዓ ሃይሢታሚፓ ዶንጊታሚ ሄላንዳኣና ዓኣ ዓቲንቆ ቢያ ፓይዴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ዔያቶኮ ማዻ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ታኣም ዱማዼ ባኮ ካፒሢ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ዴራ ዱንኪ ዴዔ ቤዛፓ ዔቂ ዴንዳኣና ዓኣሮኔና ዒዛኮ ናኣቶና ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮ ጋሮ ጌሊ ጫኣቁሞ ሳኣፂኖኮ ቤርቶ ዛላ ዓኣ ጎኦቦና ዓፒሎ ኬይሲ ጫኣቁሞ ሳኣፂኖ ዬያና ማሮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ዬካፓ ሺርኪንቴ ጉላንቦ ዜዾ ጎኦቦ ዓፒሎይዳ ቃሲ ዓጊ፤ ጊንሣ ሃሣ ጮልዔ ሼኤሜና ሌሊ ኮሺንቴ ዓፒሎ ዑፃ ካንቂ፥ ዛጳሢ ሚፆዋ ዓኣሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ዬያጉዲ ሃሣ ፆኦሲም ዒንጎ ሙዖ ዒንጊፆ ጌሦ ዼጌ ሎኦዦ ዖይቶዋ ጮልዔ ሼኤሜና ሌሊ ኮሾና ዓፒሎና ካንቆንጎ፤ ዬያ ዖይቶ ዑፃ ሳኣኔ፥ ዱዎ ሙርሳ፥ ዑዦ ዑሽኮ ዓንጋ፥ ዎይኖ ዑዦ ዱዖ ጉንጉላሢያ ጌሦንጎ፤ ካሣኣ ቢያ ዎዴ ዒኢካ ጌሢንቲ ዴዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ዬያ ቢያ ዞቄ ዓፒላና ካንቂ፥ ዑፃ ሺርኪንቴ ጉላንቦ ዜዾ ካንቂ፥ ዛጳሢ ሚፆዋ ዬያ ዼጌ ዖይቶይዳ ዓኣሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ዬካፓ ጮልዔ ሼኤሜና ኮሾና ዓፒላ ዔኪ ፖዖ ጌሦ ሻርኖንታ ፖዒሶ ባኮንታ ታሞ ቆንቾ ጋውጮንታ፤ ዬያጉዲ ሃሣ ዲቢንፆ ጌሦ ቦኦቆንታ ዛይቶ ጌሦ ባኮንታ ቢያ ካንቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ፖዖ ጌሦ ሻርኖና ዒኢካ ማዺንቶ ባኮ ቢያ ጉላንቦ ዜዾና ማሪ ኬዲ ዴንዶ ላሻሢ ሚፆይዳ ጌሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ዬያይዴስካፓ ፆኦሲም ዒንጎ ባኮ ዒንጎ ዎርቆና ኮሺንቴ ቤዞ ጮልዔ ሼኤሞና ኮሺንቴ ዓፒሎና ካንቂ ሺርኪንቴ ጉላንቦ ዜዾ ዑፃ ቃሲ ካንቂ፥ ዛጳሢ ሚፆዋ ዓኣሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ጌኤዦ ማኣሮይዳ ማዺንቶ ባኮ ቢያ ዔኪ ጮልዔ ሼኤሞና ኮሺንቴ ዓፒሎና ካንቂ፥ ሺርኪንቴ ጉላንቦ ዜዾናኣ ቃሲ ካንቂ፥ ኬዲ ዴንዶ ላሻሢ ሚፆይዳ ጌሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ፆኦሲም ሚቺ ዒንጎ ቤዛፓ ዲቢንፆ ዓኣሤስካፓ ጋላፒ ዓፒላና ካንቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ዬኖ ዒንጎ ቤዞይዳ ማዺንቶ ባኮ ጌይፃ፦ ታሞ ዔኤሦ ባካ፥ ዓሽኮ ኪራ፥ ታሞ ካኣሾ ቦኦቆንታ ዔቴ ማዔ ሳኣኖንታ ዒኢካ ጌሦንጎ፤ ዬያይዴስካፓ ሺርኪንቴ፥ ጉላንቦ ዜዾ ዑፃ ቃሲ ካንቂ ዛጳሢ ሚፆዋ ዓኣሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ዓሳ ዱንኪ ዴዔ ቤዛፓ ዔቂ ዴንዳ ዎዶና ዓኣሮኔና ናኣቶና ታኣም ዱማዼ ቤዛ ማዾ ማዺንቶ ባኮ ቢያ ካንቂ ጊኢጊሺ ጋፒሳዛ ቄዓቴ ዓሳ ሙኪ ኬዶንጎ፤ ጋዓንቴ ዔያታ ሃይቁዋጉዲ ታኣም ዱማዼ ባኮ ቢያ ሄላንዳያ ኮይሱዋሴ፤ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣራ ዔቂ ዴንዳ ዎዶና ቄዓቴ ዓሶኮ ማዻ ዬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ቄኤሳሢ ዓኣሮኔ ናኣዚ ዓላዜሬ፦ ፖዖ ፖዒሶ ዛይቶንታ ኮዦ ሳውማ ዓኣ ዑንጆንታ፤ ጊንሣ ሃሣ ቢያ ኬሊ ዒንጊንቲ ዴዓ ሙዖ ዒንጊፆና ቲዦና ካፒ ቆላያ ማዖንጎ፤ ዬያጉዲ ፆኦሲ ዴሮ ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮንታ ጋራ ዓኣ ታኣም ዱማዼ ባኮንታ ቢያ ካፖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«ቄዓቴ ዓሳ ታኣም ዱማዼ፥ ማዾ ማዺንቶ ባኮ ባንሢ ዑኬቴ ሃይቃንዳኔ፤ ሌዊ ዓሲ ማዒፃኣ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ዬይ ያዺ ማዑዋጉዲ ዓኣሮኔና ናኣቶና ዬያ ጌኤዦ ማኣሮ ጌሊ ፔቴ ፔቴሢ ማዻንዳ ባኮ ፓቂ፥ ዔያታ ማዻንዳ ባኮ ባኮዋ ኬኤዞንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ቄዓቴ ዓሳ ጋዓንቴ ዬያ ታኣም ዱማዼ ባኮ ፔቴናታዖ ዛጋኒ ኮዒ ጋሮ ጌሎፓ፤ ጌሌቴ፦ ዔያታ ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«ጌርሾኔ ቶኦኮ ማዔ፥ ሌዊ ዓሶ ፔኤኮ ዜርፆና ማኣሮ ዓሶና ዓሶና ፓቂ ፓይዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒ ዳንዳዓያ፤ ሌዓ ሃይሢታሚፓ ዴንዲ ዶንጊታሚ ጋራ ዓኣ ዓቲንቆ ቢያ ፓይዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ዬያታ ማዻንዳ ማዻ ሃካፓ ሊካ ኬኤዚንታ ጎይፆ ማዓንዳኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮኮ ጋሮና ዙሎና ካንቆ ባኮ፥ ዑፆይዳ ቃሲ ካንቆ ጉላንቦ ዜዾ፥ ጌሎ ካሮ ጎኦቦ ዓፒሎ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮና ፆኦሲም ሚቺ ዒንጎ ቤዞኮ ኮይላ ዓኣ ጶኦኮ ጎኦቦ ዓፒሎና ቱኮ ሱዞ፥ ጶኦኮ ጌላ ካሮ ካሮ ጎኦቦ ዓፒሎና ዬያ ማዾ ማዺንቶ ሜሆ ቢያ ኬዶንጎ፤ ዬያ ባኮም ቢያ ኮይሳ ባኣዚ ዔያታ ማዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ጌርሾኔ ዓሳ ኬዳ ባኮና ማዻ ማዾና ዓኣሮኔና ዒዛኮ ናኣቶና ዛጊ ዛጊ ማዺሻያ ማዖንጎ፤ ዔያታ ኬዳንዳ ባኮዋ ቢያ ዔያቶም ዱማሲ ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ጌርሾኔ ዜርፆ ማዔ፥ ሌዊ ዓሳ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻንዳ ባካ ዬያኬ፤ ዔያታ ማዻ ማዾ ቄኤሳሢ ዓኣሮኔ ናኣዚ፥ ዒታማሬ ማዺሻያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሜራሪ ዜርፆ ማዔ፥ ሌዊ ዓሶ ዔያቶኮ ዜርፆና ማኣሮና ማኣሮና ፓቂ ፓይዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒ ዳንዳዓያ፤ ሌዓ ሃይሢታሚፓ ዶንጊታሚ ጋራ ዓኣ ዓቲንቆ ቢያ ፓይዴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ዔያታ ኬዳንዳሢ ላሾ ሚፃ፥ ጋጋርዛ፥ ቱርቱራ፥ ፆኦሲ ዴሮና ካኣማ ዓፒሎና ማዢንቴ ማኣሮ ዔቂሶ ቶካኣ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ዬያጉዲ ሃሣ ዓፒላፓ ማዢንቴ ማኣሮ ኮይላ ዓኣ ጶኦኮ ቱርቱራ፥ ዔቂሶ ቶካ፥ ዓንጎ ኪሮንታ ሱዞንታ፤ ዬይ ባካ ቢያ ማዺንታ ሜሆንታኬ፤ ፔቴ ፔቴ ዓሳ ኬዳንዳ ባኮ ዱማሲ ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ቄኤሳሢ ዓኣሮኔ ናኣዚ፥ ዒታማሬ ዓይሤም ሜራሪ ዓሳ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻንዳ ባካ ዬያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ሙሴንታ ዓኣሮኔንታ ዴሮኮ ሱኡጎንታ፥ ሃይሦ ቶኦኪ ማዒ ፓቂንቴ ሌዊ ዓሶ፤ ጌይፃ፦ ቄዓቴ ዓሶና ጌርሾኔ ዓሶና ሜራሪ ዓሶዋ ዱማሲ ፓይዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ሃይሢታሚፓ ዴንዲ ዶንጊታሚ ሌዔ ኩሜያ፤ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒ ሙኬ ዓቲንቃ ቢያ ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ዬያታ ፔ ማኣሮና ማኣሮና ማዒ ፓይዲንቴ ዓሳ ላምዖ ሺያና ላንካይ ፄኤታና ዶንጊታሚናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ቄዓቴ ማኣሮይዳፓ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዼ ዓሳ ዬያቶኬ፤ ሙሴና ዓኣሮኔና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ጎይፆና ዬያቶ ፓይዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ጌርሾኔ ማኣሮ ዓሳኣ ፔ ማኣሮ ዓሶና ፔ ፃጶና ፃጶና ማዒ ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒ ሙኬያ ሌዓ ሃይሢታሚፓ ዴንዲ ዶንጊታሚ ማዔ ዓቲንቃ ቢያ ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ዬያታ ፔ ማኣሮ ዓሶና ፔ ፃጶና ፃጶና ማዒ ፓይዲንቴ ዓሳ ላምዖ ሺያና ላሆ ፄኤታና ሃይሢታሚናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ጌርሾኔ ማኣሮይዳፓ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣራ ማዼ ዓሳ ዬያቶኬ፤ ሙሴና ዓኣሮኔና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ጎይፆና ዬያቶ ፓይዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ሜራሪ ማኣሮ ዓሳ ፔ ማኣሮ ዓሶና ፔ ፃጶና ፃጶና ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒ ሙኬያ ሌዓ ሃይሢታሚፓ ዴንዲ ዶንጊታሚ ማዔ ዓቲንቃ ቢያ ፓይዲንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ዬያታ ፔ ማኣሮ ዓሶና ፔ ፃጶና ፃጶና ፓይዲንቴ ዓሳ ሃይሦ ሺያና ላምዖ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ሜራሪ ማኣሮይዳፓ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዼ ዓሳ ዬያቶኬ፤ ሙሴና ዓኣሮኔና ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ጎይፆና ዬያቶ ፓይዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ሙሴንታ ዓኣሮኔንታ ዒስራዔኤሌ ዓሶኮ ሱኡጎንታ ዓሶ ፔ ማኣሮና ፔ ፃጶና ፃጶና ፓቂ ፓይዴ ሌዊ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ሌዓ ሃይሢታሚፓ ዶንጊታሚ ሄላንዳኣና ማዔያ፤ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮይዳ ማዻኒና ዱማ ዱማ ሜሆ ኬዳኒ ሙኬ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ጉቤ ዎሊ ዑፃ ሳሊ ሺያና ዶንጎ ፄኤታና ሳሊታሚ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ዬያይዲ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ፔቴ ፔቴ ዓሶኮ ሱንፃ ፃኣፒንቴኔ፤ ዬያጉዲ ሃሣ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆና ፔቴ ፔቴ ዓሳ ማዾንዶ ባኮና ኬዶንዶ ባኮ ፔኤሲ ዔሪ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«ዑስካ ኬስካ ዶርዓ ዓርቄ ዓሲ፤ ሃሣ ዑስካፓ ዓልቃ ባኣዚ ዓኣ ዓሲና ሌሲ ካኣሚ ዒኢቴ ዓሲ ቢያ ጉርዶ ባኣካፓ ዒስራዔኤሌ ዓሳ ኬሳንዳጉዲ ዓይሤ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ታኣኒ ዔያቶ ባኣካ ናንጋ፥ ጉርዶ ዔያታ ዒኢሱዋጉዲ ዬያቶ ዒኢቴ ዓቲንቆ ማዔቴያ ላኣሎ ዒንሢ ባኣካፓ ኬሲ ዳኩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ዒስራዔኤሌ ዓሳ ዬኖ ዓሶ ጉርዳፓ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፦ ዓቲንቃፓ ማዔቴያ ላኣሎፓ፤ ዓይጎ ዓሲያ ማዖም ፆኦሲም ጉሙርቂንቱዋያ ማዒ ዓይጎ ዓሲም ማዔቴያ ፑርታ ማዼቴ ዬይ ዓሢ ዻቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ዬያ ጎሞ ቡኡፆንጎ፤ ሃሣ ዻቢንቶ ዛሎ ጪጋኒ ኮይሳ ባኮይዳ ዶንጎ ኩቺ ቃሲ ዒ ፑርቲሴ ዓሢም ጪጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ዬይ ዓሢ ሃይቄም ጪጊንታ ባኮ ዔካ፥ ዑኬ ዒጊኒ ባይቄቴ ዒ ዒንጋ ባካ ቄኤሳሢ ዛሎና ፆኦሲም ዒንጊንቶንጎ፤ ዬያ ዒ ዒንጋንዳሢ ጎሜ ማዼ ዓሲ ጎሞ ጌኤሺፆሮ ዒንጋ ዓዶ ማራዖና ዎላኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ዬያይዲ ዒስራዔኤሌ ዓሳ ፆኦሲም ዒንጋ ዱማ ዒንጊፃ ቢያ ዬያ ዒንጊፆ ዔካ ቄኤሳሢም ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ፔቴ ፔቴ ዓሳ ፆኦሲም ዒንጋ፥ ዱማ ዒንጊፃ ዬያ ዒንጋ ዓሢሮኬ፤ ቄኤሳሢም ዒንጌስካፓ ጋዓንቴ ቄኤሳሢሮ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«ዒሲራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ፔቴ ዓሲኮ ማቻ ዓኒም ጉሙርቂንቱዋያ ማዒ፥ ሜሌ ዓሲና ላሂ ዒኢቴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ዬያ ዒዛ ላሄሢ ዓሲ ዴንቂባኣያ ማዔም ዓኒ ዔራኒ ዳንዳዒባኣቴ፤ ሃሣ ማርካዻ ዓሲያ ባይቄም ዒኢቲፃ ዔርቲባኣያ ማዔንቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ዒዞ ዒ ዒናፓ ናሽካያ ማዒፆና ቆፄያ ማዔም ጎኔ ዒዛ ዒኢቴያ ማዒ ጴዼቴ፤ ሃሣ ዒኢቲባኣያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ቄኤሳሢ ኮይላ ዔኪ ዓኣዾንጎ፤ ዒንጎ ባኣዚ ማሂ ፔቴ ኪሎ ማዓ ዔልዓ ዺኢሊያ ዎላ ዔኪ ዓኣዾንጎ፥ ዬያ ጊዳ ዛይቴያ ማዖም ዑንጄያ ዋሆፓ፤ ዓይጎሮ ጌዔቴ ዬይ ዒንጊፃ ቆፂንሤ ባኣዚ ፔጋዻንዳጉዲ ላኣሊ ቆፄ ዓሲ ዒንጋ ዒንጊሢ ማዔሢሮኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«ቄኤሳሢ ላኣሌሎ ናንጊና ናንጋ ጎዳ ቤርታ ዔቂሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ዬካፓ ፆኦሲም ዱማዼ ዋኣሢ ፔቴ ዖቲዳ ዱይ ዔኬስካፓ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮኮ ጋራፓ ዻካ ዓጪ ዑጪ ዔኪ ዋኣፆ ጫንቂሳኒ ጊዳ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ዬያይዴስካፓ ላኣሌሎኮ ቶኦካፓ ሻኣሻሢ ቡሊ፥ ዒንጊፆሮ ዔኪ ሙኮና ዺኢሎ ዒዞ ኩጫ ዋሃዖ ጋዳሞ ሄሊሶም ጫንቂሶና ዋኣፆ ዖቶ ፔ ኩጫ ዒ ዔኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ዬካፓ ዒዚ ሂዚ ጌዒ ዒዞ ጫኣቂሶንጎ፤ ኔኤኮ ዓኒ ዓኣንቴ ሜሌ ዓሲና ኔ ላሂ፥ ዒኢቲባኣያ ማዔቴ፦ ሃይ ጋዳሞ ሄሊሳ ጫንጮ ዋኣፃ ኔና ዔኤቢ ዎኦቶፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ጋዓንቴ ኔኤኒ ዓኒ ዓኣንቴ ሜሌ ዓሲና ላሂ፥ ዒኢቴያ ማዔቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","‹ፆኦሲ ዞኦኮ ኔና ማሂ፥ ጎጶዋ ኔኤኮ ጋኣቢሺ፥ ኔ ዴሮ ባኣካ ጋዳንቂንቴያ ኔና ማሆም፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ሃያ ዋኣፆ ኔ ዑሽካዛ ጎጶ ኔኤኮ ኪፂሲ፥ ሾይፆዋ ኔኤኮ ባይዞንጎ› ጋዓዛ፥ ላኣሌላኣ ‹ሂዮ፤ ፆኦሲ ታና ዬያይዶንጎ›» ጎዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«ቄኤሳሢ ዬካፓ ዬያ ጋዳሞ ዔኤቢዳ ፃኣፒ፤ ጊንሣ ዬያ ዋኣሢና ማስኪ ጫንጮ ዋኣፃ ዓኣ ዖቶይዳ ዋሆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ላኣሌሎ ዬያ ፑርቶ ሃርጎ ዋኣፆ ዑሻንዳሢኮ ቤርታ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ዒንጊፆ ማሂ ዔኪ ሙኮና ዺኢሎ ላኣሌሎ ኩጫፓ ዔኪ ፆኦሲም ሊካ ሌካ ዡጊ ዒንጎ ዱማ ዒንጊሢ ማሂ ሚቺ ዒንጎ ቤዛ ጌሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ዬያይዴስካፓ ዬያ ሃኣኮ ዒንጊፆይዳፓ ዻካ ዑጪ ዔኪ ዒንጎ ዒንጊሢ ማሂ ታኣም ሚቺ ዒንጎ ቤዛ ሚቾንጎ፤ ዬካፓ ዓካሪ ላኣሌሎ ዑሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ዬና ላኣሌላ ፔና ዒኢሲ፥ ዓኒም ጉሙርቂንቱዋያ ማዒ ጴዼቴ ዬይ ዋኣፃ ዒዞ ሚርጌና ሜታሳንዳኔ፤ ጌይፃ፦ ጎጶ ዒዞኮ ጋኣቢሻንዳኔ፥ ሾይፃኣ ዒዞኮ ዱጳንዳኔ፤ ሱንፃኣ ዒዞኮ ዒዞ ዴሮ ባኣካ ጋዳንቂንቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ፔቴታዖ ዒዛ ዻቢንቲባኣያ ጌኤሺ ማዔቴ ዬይ ጌይንቴ ባካ ዒዞ ሄላዓኬ፤ ናይ ሾዓኒያ ዒዛ ዳንዳዓኔ። ፔቴ ዓሲ ፔ ማቾ ናሽኪፃፓ ዔቄያና ማዻንዳ ዳምባ ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«ዓሢኮ ማቻ ሜሌ ዓሲና ላሂ ዒኢቴቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ሃሣ ፔቴ ዓሲ ናሹማፓ ዔቄያና ሌሊ ፔ ማቻ ‹ዓሲና ላሄያ ናንዳኔ› ጌይ ቆፄቴ ፆኦሲ ቤርታ ዒዞ ዔቂሶንጎ፤ ቄኤሳሢያ ዬያ ዎጎ ቢያ ዒዞይዳ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ዓሢ ፂሎ ማዓንዳኔ፤ ላኣሌላ ጎኔ ዒኢቴያ ማዔቴ ዒዞ ዻቢንቶም ዒንጊንታ ባኮ ዒዛ ዔካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ዓቲንቄታቴያ ላኣሊ ፔና ታኣም ዱማሲ ናዝራ ዓሲ ማዓኒ ጫኣቄቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ዎይኔፓ ኮሾና ዑሺታቴያ ዓይጎዋ ማሣ ዑሺ ዑሽኮፓ፤ ሃሣ ዎይኔይዳፓ ማዖም ሜሌ ባኣዚፓ ኮሺንቴ ሶልኬያንታ ማሣ ዑሺ ዑሽኮፓ፤ ዬያጉዲ ዎይኖ ዓኣፖንታ ዜቢቤ ጌይንታ ሚፆ ዓኣፖዋ ሙዖፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ዒ ያዺ ማዒ ናንጋ ዎዶና ዎይኖ ዓኣፖኮ ጎቦ ማዔቴያ ጋራ ዓኣ ዓኣፖ ሙዖፓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ናንጊና ናንጋ ጎዳ ሃሣ «ዒ ናዝራ ዓሲ ማዒ ናንጋ ዎዶና ቶኦኮ ፔኤኮ ሜኤዶፓ፤ ሃሣ ታይዞፓ፤ ዬይ ዎዳ ጋፓንዳያ ሄላንዳኣና ፆኦሲም ዒ ዱማዼያ ማዔሢሮ ቶኦኮ ጋፓኖ ፔኤኮ ዲቾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ዒ ፔና ፆኦሲም ዱማሲ ዓኣ ዎዶና ቢያ ሃይቄ ዓሲኮ ሌሲ ባንሢ ዑኮፓ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ፆኦሲም ዒ ፔና ጫኣቂ ዱማሴ፥ ጋፓና ቶኦካ ዒዛኮ ዓኣሢሮ ዓዴ፥ ዒንዳ፥ ጌርሲ፤ ሃሣ ጌራ ሃይቄቴታዖ ሌዞ ዔያቶኮ ካኣሚ ፔና ዒኢሶፓ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ናዝራ ዓሲ ዒ ማዔሢሮ ፆኦሲም ዒ ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ፔቴ ናዝራ ዓሲኮ ዔርቲባኣንቴ ኮይላ ዓሲ ሃይቂ፥ ፆኦሲም ዱማዼ ጋፓኖ ዒኢሴያ ማዔቴ ላንካሳ ኬሎና ቶኦኮ ጋፓኖ ፔኤኮ ሜኤዶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ሳላሳ ኬሎና ላምዖ ኪሬ ሃንጎ ላምዖ ዶኦሌ፤ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ዓኣ፥ ቄኤሳሢ ኮይላ ዔኪ ዬዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ዬካፓ ቄኤሳሢ ፔቴማ ጎሜ ጌኤሺሢ፥ ዓቴማ ሚቺ ዒንጎ ዒንጊሢ ማሂ ዒንጊ፤ ዬይ ናዝራ ዓሢ ሌዞ ካኣሚ ዒኢቴሢሮ ዒዛ ጌኤሾንጎ፤ ዬኖ ኬሎና ናዝራ ዓሢ ፔኤኮ ቶኦኮ ጋፓኖ ላሚ ፆኦሲም ዱማሴያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ናዝራ ዓሲ ማዒ ማዻኒ ፔና ላሚ ፆኦሲም ዱማዼያ ማሆንጎ፤ ቤርታ ዒ ፆኦሲም ዱማሴ ጋፓና ዒኢቴያ ማዔሢሮ ፔና ዱማሲ ናንጌ ዎዳ ዓቴያ ማዓኔ፤ ዬያሮ ዻቢንቲ ዛላ ጪጎ፥ ፔቴ ሌዔ ማዔ፥ ዓዴ ማራናይ ዔኪ ሙኮንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","ናንጊና ናንጋ ጎዳ ኬኤዛዖ «ፔቴ ናዝራ ዓሲ ዒ ፔና ዱማሲ ናንጋ ዎዶ ጋፒሳኣና ኩንሣንዳ ዎጋ ያዺኬ፦ ፆኦሲ ዴሮና ካኣማ፥ ዓፒሎና ማዢንቴ ማኣሮ ካሮ ዴንዶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ዬካፓ ፆኦሲም ዒንጎ ዒንጊሢ ዒንጎንጎ፤ ዬይያ፦ ሚቺ ዒንጎ ዒንጊሢ ማዔ፥ ፔቴ ሌዔ ኩሜ ዓዴ ማራናይ፤ ጎሜ ጌኤሻኒ ዒንጎ፦ ፔቴ ሌዔ ኩሜ ዑዞ ማራናይ፤ ዬያጉዲ ሃሣ ፔቱሞና ዒንጊንታ ዒንጊሢ ማዓ፦ ፔቴ ዓዴ ማራናይ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ሃሣ ሙኑቃ ፃኣዛ ዋሂንቲባኣንቴ ላኣዲንቴ ፔቴ ሌኤማቴ ላኣዳ፤ ሪሚቲ ዛይቴና ዲርኪ ላኣዶና ዓንዲሪ ላኣዳ፥ ሻኣዣ ላኣዳ፥ ሪሚቶ ዛይቶና ቲሽኮና ላኣዳና ቃሲ ዒንጊንታ ሃኣኮ ዒንጊፆና ዑዦ ዒንጊፆና ዎላ ማሂ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ዬካፓ ቄኤሳሢ ዬያ ቢያ ጎሜ ጌኤሻ ዒንጊሢ፤ ሃሣ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ዓዶ ማራዓሢ ፔቱሞና ፆኦሲም ዒንጎ ዒንጊሢ ማሂ ዒንጎንጎ፤ ዬያ ዒ ዒንጋ ዎዶና ሌኤማቶይዳ ዓኣ ላኣዶና ዎላ ሺኢሾንጎ። ሄሊሲ ሃኣኮ ዒንጊፆና ዑዦና ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ጌሎ ካራ፦ ናዝራ ዓሢ ፔኤኮ ቶኦኮ ጋፓኖ ሜኤዲ ፔቱሞና ዒንጊንታ ዒንጊፃ ሚቺንታ ታሞይዳ ዓጎንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ናንጊና ናንጋ ጎዳ ሃሣ «ዒ ፆኦሲም ዱማዼ፥ ቶኦኮ ሜኤዴስካፓ ቄኤሳሢ ዓዶ ማራዓሢኮ ካሢንቴ ላባዎ፤ ሃሣ ሌኤማቶ ጋራ ዓኣ ካሦፓ ፔቴ ሻኣዣሲ ላኣዶና ካሦፓኣ ፔቴ ዔኪ ናዝራ ዓሲ ማዔሢኮ ኩጫ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ዬካፓ ቄኤሳሢ ዬያ ቢያ ዔኪ ፆኦሲም ዡጊ ዒንጎ፥ ዱማ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ዬይ ቢያ ማራዓሢኮ ዚኢሮና ላባዎና ዎላ ቄኤሳሢም ዱማዼያ ማዖንጎ፤ ናዝራ ዓሢ ዎይናፓ ኮሾና ዑዦ ዑሽካኒ ዳንዳዓሢ ዬካፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","ዓካሪ ዬይ፦ ናዝራ ዓሲ ማዒሢ ዛላ ኩንሢንታ ዳምቤኬ፤ ጋዓንቴ ፔቴ ናዝራ ዓሲ ዒንጋኒ ናኣባንዳያ ኮይሳሢኮ ዑሣ ዓኣሢ ናኣቤቴ ዒ ናኣቤ ጎይፆማ ኩንሣንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«ዓኣሮኔና ናኣቶና ዒስራዔኤሌ ዴሮ ዓንጃ ዎዶና ");
INSERT INTO mdyeth_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹ናንጊና ናንጋ ጎዳ ኔና ዓንጆንጎ፥ ካፖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ናንጊና ናንጋ ጎዳ ኔና ፔኤኮ ላጌ ማሂ ዛጎንጎ፤ ኔና ሚጪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ናንጊና ናንጋ ጎዳ ኮሹሞ ዓኣፒና ኔና ዛጎንጎ፤ ኮሹሞዋ ኔኤም ዒንጎንጎ› ሂዚ ጎዖንጎ ጌይ ዔያቶም ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ዬያይዲ ታ ሱንፆ ዔኤሊ፦ ዒስራዔኤሌ ዜርፆ ዔያታ ዓንጄቴ ታኣኒ ዔያቶ ዓንጃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ሙሴ ዾቂ ጋፔ ኬሎና ዬያ ማኣሮና ጋሮናይዳ ማዺንቶ ባኮ ዛይቴና ቲሽኪ ፆኦሲም ዱማሴኔ፤ ሃሣ ፆኦሲም ሚቺ ዒንጎ ቤዞና ዒኢካ ዓኣ ማዺንቶ ሜሆዋ ቲሽኪ ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ዬካፓ ዒስራዔኤሌ ዓሶኮ ሱኡጎ ማሆና ፃጶ ፃጶ ማኣሮኮ ቢታ ቢታ ዒንጎ ባኣዚ ፆኦሲም ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ዔያታ ዔኪ ሺኢሼሢ ማኣሪ ጎይሢ ማሂ ኮሾና ላሆ ሳርጌላ ዖይታና ታጶ ላምዖ ጌማይናኬ፤ ዬይያ፦ ፔቴ ፔቴ ሱኡጋ ፔቴ ፔቴ ጌማይ፥ ላምዖ ሱኡጋ ዎላ ማዒ ፔቴ ሳርጌላ ዖይታ ሺኢሼኔ ጌይሢኬ። ዔያታ ዬያ ሺኢሻዛ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ናንጊና ናንጋ ጎዳ ሙሴም፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዬይ ባካ ማዻንዳጉዲ ዔያቶይዳፓ ዔኬ፤ ዬይ ባካ ማዻኒ ኮይሳ ባኮ ማዻንዳጉዲ ሌዊ ዓሶም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ዬያሮ ሙሴ ሳርጌሎ ዖይቶና ጌማቶና ዔኪ ሌዊ ዓሶም ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ጌርሾኔ ዓሶም ዔያታ ማዻ ማዾኮ ኮይሳያ ማዔ ላምዖ ሳርጌላ ዖይታና ዖይዶ ጌማይና፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ሜራሪ ዓሶም ኮይሳ ማዾኮዋ ዖይዶ ሳርጌላ ዖይታና ሳሊ ጌማይና ዒንጌኔ። ዬያ ማዾ ማዺሻሢ ዓኣሮኔ ናኣዚ ዒታማሬኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ቄዓቴ ዓሶም ጋዓንቴ ፆኦሲ ማዾም ዱማዼ ባኮ ዔያታ ፔ ጌኤታ ኬዳሢሮ ሳርጌሎ ዖይቶና ጌማቶና ዒንጊንቲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ዒስራዔኤሌ ዓሶኮ ሱኡጋ ፆኦሲም ሚቺ ዒንጎ ቤዛ ቲዦና ቲሽኪንቲ ፆኦሲም ዱማዻ ኬሎ ቦንቻኒ ዒንጎ ባኣዚ ዔኪ ዬዒ፥ ሚቺ ዒንጎ ቤዛ ሺኢሺ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ፔቴ ፔቴ ሱኡጋ ፔ ኬሎና ኬሎና ዒንጎ ባኮ ዒንጋንዳጉዲ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ቤርታሳ ኬሎና ዒንጎ ባኮ ሺኢሼሢ ዪሁዳ ማኣራፓ ዓምናኣዳኣቤ ናኣዚ ኔዓሶኔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ዒ ዒንጌ ባካ ሃኣኮ ዒንጊሢ ማዓንዳ ዛይቴና ዲርኪንቴ ሺኢቺ ዺኢሊ ጌኤዦ ማኣራ ዴኤሡሞ ዔሮ ባኮና ፔቴና ዛላና ኪሎ ማዓ ቢራ ዓንጊና ኮሾና ሳኣኔንታ፤ ሃሣ ቢራ ዓንጊና ኮሾና ዔቴ ሳኣኔ ዴኤሡማ ፔቴ ኪሎ ማዓኒ ዻካ ፓጫያንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ዴኤሡማ ፄኤታና ታጶ ጊራኣሜ ማዓ ፔቴ ዎርቄና ኮሺንቴ ሙርሳ ዑንጄ ኩንሦናያ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ሚቺ ዒንጎ ዒንጊፆም ማዓ ፔቴ ዎፓናና ፔቴ ዓዴ ማራይና ፔቴ ሌዔ ማዔ ዓዴ ማራናይናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ጎሜ ጌኤሻኒ ዒንጊንታ ፔቴ ኮላይ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ፔቱሞና ዒንጎ ዒንጊፆም ላምዖ ጌማይ፥ ዶንጎ ዓዴ ማራይ፥ ዶንጎ ኮላይና ፔቴ ሌዔ ማዔ ዶንጎ ዓዴ ማራናይናኬ፤ ዬይ ቢያ ዓምናኣዳኣቤ ናኣዚ ኔዓሶኔ ዒንጌ ባኮኬ። ሃካፓ ሊካ ዓኣ ዓሳ ዓምናኣዳኣቤ ናኣዚ ኔዓሶኔ ዒንጌ ባኮንሢ ጉቤ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","23","ላምዓሳ ኬሎና ዒንጊፆ ዒንጌሢ ዪሳኮኦሬ ማኣራፓ ፁዓሬ ናኣዚ ናቲናዔኤሌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","29","ሃይሣሳ ኬሎና ዒንጊፆ ዒንጌሢ ዛብሎኦኔ ማኣራፓ ሄሎኔ ናኣዚ ዔኤሊያቤኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","35","ዖይዳሳ ኬሎና ዒንጊፆ ዒንጌሢ ሮኦቤኤሌ ማኣራፓ ሴዲዮሬ ናኣዚ ዔልፁሬኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","40","ዶንጋሳ ኬሎና ዒንጊፆ ዒንጌሢ ሲሞኦኔ ማኣራፓ ፁሪሻዳዬ ናኣዚ ሼሉሚዔኤሌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","47","ላሃሳ ኬሎና ዒንጊፆ ዒንጌሢ ጋኣዴ ማኣራፓ ራጉዔኤሌ ናኣዚ ዔኤሊያሳፔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","53","ላንካሳ ኬሎና ዒንጊፆ ዒንጌሢ ዔፕሬኤሜ ማኣራፓ ዓምሁዴ ናኣዚ ዔኤሊሻማዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","59","ሳላሳ ኬሎና ዒንጊፆ ዒንጌሢ ሚናኣሴ ማኣራፓ ፒዳፁሬ ናኣዚ ጌማሊዔኤሌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","65","ታዞጳሳ ኬሎና ዒንጊፆ ዒንጌሢ ቢኢኒያሜ ማኣራፓ ጊዳዖኔ ናኣዚ ዓቢዳኔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","71","ታጳሳ ኬሎና ዒንጊፆ ዒንጌሢ ዳኣኔ ማኣራፓ ዓምሻዳዬ ናኣዚ ዓክዔዜሬኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","77","ታጶ ፔታሳ ኬሎና ዒንጊፆ ዒንጌሢ ዓሴኤሬ ማኣራፓ ዔክራኔ ናኣዚ ፓግዒዔኤሌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","83","ታጶ ላምዓሳ ኬሎና ዒንጊፆ ዒንጌሢ ኒፕታኣሌኤሜ ማኣራፓ ዔናኔ ናኣዚ ዓሂራዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ሚቺ ዒንጎ ቤዞ ፆኦሲም ዱማሶና ኬሎና ዒንጊንቴ ባካ ቢራ ዓንጊና ኮሾና ታጶ ላምዖ ሳኣኔና ቢራ ዓንጊና ኮሺንቴ ታጶ ላምዖ ዔቴ ሳኣኔ፤ ሃሣ ቢራ ዓንጊና ኮሺንቴ፥ ዑንጄ ጌሦ ታጶ ላምዖ ዎርቄና ኮሾና ሙርሳ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ጌኤዦ ማኣራ ዴኤሡሞ ዔሮ ባኮና ፔቴ ፔቴ ቢሮ ዓንጎና ኮሾና ሳኣና ሃይሢታሚ ሳቂሌ፤ ጊንሣ ሃሣ ፔቴ ፔቴ ቢሮ ዓንጎና ኮሺንቴ ዔቶ ሳኣና ላንካይታሚ ሳቂሌ ማዓዛ፥ ዬይ ቢሮ ዓንጎና ማዦና ባካ ጌኤዦ ማኣሮይዳ ዴኤሡሞ ዔሮ ባኮና ላማታሚ ሳሊ ኪሎ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ዎርቆ ዓንጎና ኮሾና፥ ዑንጆ ጌሦ ታጶ ላምዖ ሙርሳ ፔቴ ፔቴሢ ታጶ ሳቂሌ ማዓያታሢሮ ዎሊ ዑፃ ፔቴና ኔፂቤ ዖይዶ ኪሎ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ሚቺ ዒንጎ ዒንጊፆም ሺኢሾና ቆልማ ታጶ ላምዖ ጌማይ፥ ታጶ ላምዖ ዓዴ ማራይ፥ ታጶ ላምዖ ፔቴ ሌዔ ማዔ ዓዴ ማራናይናኬ፤ ዬይ ዒንጊንታሢ ሃኣኮ ዒንጊፆና ዎላኬ። ጎሞ ጌኤሺፆም ታጶ ላምዖ ኮላይ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ፔቱሞና ዒንጎ ዒንጊፆም ሺኢኬ ባኣታ፦ ላማታሚ ዖይዶ ጌማይ፥ ላሂታሚ ዓዴ ማራይ፥ ላሂታሚ ኮላይና ፔቴ ሌዔ ማዔ ላሂታሚ ዓዴ ማራናይናኬ፤ ፆኦሲም ሚቺ ዒንጎ ቤዛ ቲሽኪንቲ ፆኦሲም ዱማዼስካፓ ጌኤዦ ማኣሮም ዒንጊንቴ ባካ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ናንጊና ናንጋ ጎዳና ጌስታኒ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ሙሴ ጌላዖ ጎሞ ጌኤሽኪፆ ዔርዛ፥ ጉኡፖ ዑፃ ዓኣ ላምዖ ኪሩቤኤሎንሢ ባኣካ ማዒ ናንጊና ናንጋ ጎዳ ኬኤዛንቴ ዒ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«ዓኣሮኔ ላንካዎ ፖዖ ሻርኖይዳ ጌሢ ፖዒሳ ዎዶና ፖዓ ቤርቲም ፖዓንዳጉዲ ማሂ ጌሦም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ዓኣሮኔ ማዼኔ፤ ፖዖ ጌሦ ሻርኖይዳ ፖዓ ቤርቲም ፖዓንዳጉዲ ማሂ ዒዚ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ፖዖ ጌሦ ሻርና ናንጊና ናንጋ ጎዳ ሙሴም ዻዌ ጎይፆ፥ ዹይንቴ ዎርቄና ሚፆንታ ካኣፖይዳ ዓኣ ቡኖንታ ኮሺንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«ሃንጎ ዒስራዔኤሌ ዓሶ ባኣካፓ ሌዊ ዓሶ ዱማሲ ሃካፓ ሊካ ኬኤዚንታ ጎይፆና ዑፆ ዔያቶኮ ጌኤሼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ጌኤሺፆ ዳምቦም ጊኢጊሾዋና ዋኣፆ ዔያቶ ዑፃ ፑጬ፤ ዔያቶኮ ዑፆይዳ ዓኣ ጋፓኖ ቢያ ሜኤዲሲ ማኣዓሢያ ፔኤኮ ዔያቶ ማስኪሲ ዔያቶ ጌኤሼ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ሄሊሳዖ ሃሣ ፔቴ ዎፓናና ሃኣኮ ዒንጊፆ ማሂ ጌሦና ዛይቶና ዲርኪንቴ ዺኢሎ ዔያታ ዔኮንጎ፤ ኔኤኒያ ጎሞ ጌኤሺፆም ዒንጊንቴ ፔቴ ዎፓና ዔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ዬካፓ ዒስራዔኤሌ ናኣቶ ቡኩሳዖ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቤርቶ ዛላ ሌዊ ዓሶ ዔቂሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ዒማና ዒስራዔኤሌ ዴራ ኩጮ ፔኤኮ ሌዊ ዓሶ ቶኦካ ጌሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ሌዊ ዓሳ ዒስራዔኤሌ ዴሮ ባኣካፓ ታኣም ዱማ ዒንጊሢ ማዒ ዒንጊንቲ ታኣም ማዻንዳጉዲ ዓኣሮኔ ዔያቶ ታኣም ዱማሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ዬካፓ ሌዊ ዓሳ ኩጮ ፔኤኮ ላምዖ ዎፓኖንሢ ቶኦካ ጌሦንጎ፤ ዬካፓ ፔቴሢ ጎሞ ጌኤሺፆም ዒንጊንታ ዒንጊሢ፤ ባጋሢ ታኣም ሚቺ ዒንጎ ዒንጊሢ ማዓንዳኔ፤ ሌዊ ዓሶ ጌኤሾ ዳምባ ያዺዲ ኩማያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሌዊ ዓሶ ታኣም ዱማ ዒንጊሢ ማሂ ዱማሲ፥ ዓኣሮኔና ናኣቶና ዔያቶኮ ሱኡጌ ማሂ ዶኦሬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ዬያይዲ ሌዊ ዓሳ ታኣሮ ማዓንዳጉዲ ሃንጎ ዒስራዔኤሌ ዴሮ ባኣካፓ ዱማሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ኔኤኒ ዔያቶ ጌኤሺ፤ ሃሣ ታኣም ዱማሴስካፓ ሌዊ ዓሳ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዻኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ታኣኒ ዔያቶ ዒስራዔኤሌ ዓሶኮ ዓቲንቆ ናኣቶ ቶይዶ ቤዛ ማሂ ዶኦሬሢሮ ታኣሮ ሌሊ ዔያታ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ጊብፄ ዓሶኮ ቶይዶ ማዒ ሾይንቴ ዓቲንቆ ናኣቶ ታ ዎዼያና ፔቴ ፔቴ ዒስራዔኤሌ ዓሶኮ ቶይዶ ናኣቶንታ ዔያቶ ቆልሞኮ ቤርታ ሾይንታ ናኣቶዋ ታኣም ታ ዱማሴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ሃሢ ጋዓንቴ ታኣኒ ዒስራዔኤሌ ዓሶኮ ቶይዶ ናኣቶ ቤዛ ሌዊ ዓሶ ታኣም ታ ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዒስራዔኤሌ ዓሳ ታኣም ማዻንዳ ቤዛ ዔያታ ማዻንዳጉዲ፤ ሃሣ ዒስራዔኤሌ ዓሳ ጌኤዦ ቤዞ ባንሢ ዑኪ ሃርጌ ዔኪ ሜቶ ዛጉዋጉዲ ካፓ ዓሲ ማሂ ዔያቶ ታ ዒስራዔኤሌ ዓሶይዳፓ ዒንጎ ባኣዚጉዲ ዔኪ ዓኣሮኔና ናኣቶናም ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ዬያሮ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ሙሴንታ ዓኣሮኔንታ፤ ዒስራዔኤሌ ዴራኣ ቢያ ሌዊ ዓሶ ፆኦሲም ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ሌዊ ዓሳ ፔና ጌኤሼኔ፤ ማኣዓሢያ ፔኤኮ ማስኬኔ፤ ዓኣሮኔ ናንጊና ናንጋ ጎዳም ዱማዼ ዒንጊሢ ማሂ ፆኦሲም ዔያቶ ዱማሲ፥ ጌኤሺፆ ዳምቦዋ ዔያቶም ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ናንጊና ናንጋ ጎዳ ሙሴም ሌዊ ዓሶ ዛሎ ኬኤዜ ጎይፆና ዴራ ቢያ ባኮ ማዼኔ፤ ዬያይዴም ሌዊ ዓሳ ዓኣሮኔና ናኣቶና ዔያቶኮ ሱኡጌ ማዔም ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዻኒ ጊኢጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«ላማታሚ ዶንጎ ሌዔ ማዔያና ዬካፓ ዑሣ ማዔ ሌዊ ዓሶፓ ዓቲንቄ ቢያ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዻኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ዶንጊታሚ ሌዔ ማዔስካፓ ጋዓንቴ ማዾ ሃሾንጎ፤ ላሚ ዬያ ማዾ ማዾፓ። ");
INSERT INTO mdyeth_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ዔያታ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዔያቶኮ ጌርሲንሢ ማዔ ሌዊ ዓሳ ማዻ ዎዶና ዬያቶ ማኣዳያ ማዒ ማዾንጎ፤ ጋዓንቴ ዔያታ ፔኤሮ ፔቴታዖ ማዾ ማዾፓ። ሌዊ ዓሳ ማዻንዳ ዳምቦ ዬያይዲ ዓይሤ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ዒስራዔኤሌ ዴራ ጊብፄ ዓጫፓ ኬስኬንቴ ላምዓሳ ሌዖኮ ቤርታሳ ዓጊኖና ናንጊና ናንጋ ጎዳ ሙሴም ሲና ቦኦሎይዳ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«ዒስራዔኤሌ ዓሳ ዑሣ ዓኣዺፆ ቦንቻ ቦንቺንታንዳጉዲ ጌይንቴ ዎዶማና ቦንቾንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ዬኖ ዓጊኖኮ ታጶ ዖይዳሳ ኬሎኮ ዓባ ጌሌማፓ ዓርቂ ዎጎና ዳምቦ ጎይፆና ማዺ ኩንሦንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ዬያሮ ሙሴ ዴራ ዑሣ ዓኣዺፆ ቦንቾ ቦንቻንዳጉዲ ዔያቶም ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ዔያታ ቤርታሳ ዓጊና ፄኤሬም ታጶ ዖይዳሳ ኬላ ዓሜማፓ ዓርቃዖ ሲና ቦኦሎይዳ ዬኖ ቦንቾ ቦንቼኔ፤ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆ ቢያ ባኮ ዔያታ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ጋዓንቴ ሌሲ ካኣሚ ዳምቦ ጎይፆና ዒኢቴ ዻካ ዓሲ ዓኣዖ ዬኖ ኬሎና ዑሣ ዓኣዺፆ ቦንቾ ቦንቻኒ ዳንዳዒባኣሢሮ ሙሴና ዓኣሮኔና ኮይላ ሙኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","«ኑኡኒ ሌሲ ካኣሚ ዒኢቴያ ማዔቴያ ማዺንታ ዎዶማና ፆኦሲም ዒንጎ ባኮ ኑ ዒንጉዋጉዲ ዒስራዔኤሌ ዓሶይዳፓ ዱማሲ ኑና ዓይጎሮ ላኣጎናይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ሙሴ ዔያቶም «ዒንሢ ዎዳንዳቴያ ናንጊና ናንጋ ጎዳ ታኣም ኬኤዛንዳያ ሄላንዳኣና ካፑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ዒማና ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ‹ዒንሢዳፓኣ ማዖም ዒንሢኮ ዜርፃፓ ዓሲ ሌሲ ካኣሚ ዒኢቴቴ፥ ሃሣ ሃኬ ቤሲ ዓኣዺ ጎይሢዳ ዓኣቴ ዑሣ ዓኣዺፆ ቦንቾ ሂዲ ቦንቻኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ላምዓሳ ዓጊና ፄኤራዛ ታጶ ዖይዳሳ ኬላ ዓሜማፓ ዓርቃዖ ቦንቹዋቴ፤ ዒንሢ ቦንቻ ዎዶና ሙኑቃ ፃኣዛ ዋሂንቲባኣ ላኣዳ ጫንቺ ዒላሺና ዎላ ሙዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ዬያ ሙዖ ዴንዲ ዚሮ ጉቴ ሄላንዳኣና ዓይሲ ዎይሢፖቴ፤ ሹኪንቴ ቆልሞማኮ ፔቴ ሜጌሢታዖ ሜንሢፖቴ፤ ዒንሢ ቦንቻንዳጉዲ ዓይሢንቴ ዳምቦ ጎይፆማ ቦንቾ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ዳምቦ ጎይፆና ዒኢቲባኣያ፤ ሃሣ ሃኬ ጎይሢያ ዓኣዺባኣ ዓሲ ቢያ ዑሣ ዓኣዺፆ ቦንቾ ዎዶማና ቦንቺባኣቴ ታ ዴሮ ባኣካ ማዓኒ ኮይሱዋሴ፤ ዒንጎ ባኮ ዒንጊንቶም ጌይንቴ ዎዶማና ዒንጊባኣሢሮ ዒዛኮ ጎሞ ዛሎ ዒንጊንታ ባኮ ዒ ዔካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ዒንሢ ባኣኮይዳ ዓኣ ሙኬ ዓሲ ዑሣ ዓኣዺፆ ቦንቾ ቦንቻኒ ኮዔቴ ዓይሢንቴ ዳምቦና ዎጎ ጎይፆማ ቦንቻኒ ኮይሳኔ፤ ዓጪ ዓሲ ማዔቴያ ሜሌፓ ሙኬ ዓሲ ዬያ ዳምቦ ዒማ ጎይፆማ ኩንሦንጎ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣራ ዾቂንቴ ኬሎና ሻኣሬ ሙኪ ዬኖ ማኣሮ ካንቄኔ፤ ዬይ ሻኣራ ሳዓ ዓሜማፓ ዴንዲ ካራንዳኣና ዓፒሎና ማዢንቴ ማኣሮይዳ ታሚጉዲ ፖዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ሮኦሮ ሻኣራ ዬኖ ማኣሮ ካንቃኔ፤ ዋንቶ ዬይ ሻኣራ ታሚጉዲ ሼኤሪ ፖዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ሻኣራ ዓፒሎና ማዢንቴ ማኣሮይዳፓ ዔቂ ዓኣዻኣና ቢያ ዎዴ ዒስራዔኤሌ ዓሳ ዔያታ ዱንኪ ዴዔ ቤዞ ሃሺ ዓኣዻኔ፤ ሻኣራ ዴንዲ ላሄ ቤዞማይዳ ዒስራዔኤሌ ዓሳ ዱንኪ ዴዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ዒስራዔኤሌ ዓሳ ዴዔ ቤዞ ሃሺ ዓኣዻሢንታ ሜሌ ቤስካ ዱንኪ ዴዓሢ ናንጊና ናንጋ ጎዳ ዓይሣ ዓይሥሢናኬ፤ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ሻኣራ ላሂ ዚቲ ጌዔቴ ዔያታኣ ዒማ ቤዛ ዴዒ ዚቲዮ ጋዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ዬይ ሻኣራ ዓፒሎና ማዢንቴ ማኣሮ ዑፃ ሚርጌ ዎዴ ዴዔያ ማዔቴያ ዔያታ ናንጊና ናንጋ ጎዳም ዓይሢንቲ ዒማካ ዴዴዓኔ፤ ሜሌ ቤሲ ዓኣዹዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ፔቴ ፔቴና ሻኣራ ዬኖ ማኣሮ ዑፃ ዴዓሢ ዻካ ኬሊ ሌሊኬ፤ ያዺ ማዔቴያ ዔያታ ዴዓሢንታ ቤርቲም ዓኣዻሢያ ፆኦሲ ዔያቶ ዓይሣ ጎይፆናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ፔቴ ፔቴና ሻኣራ ዴዓሢ ሳዓ ዓሜማፓ ዴንዲ ካራንዳያ ሄላንዳኣና ሌሊኬ፤ ዬያሮ ሻኣራ ዔዔቃማና ዔያታኣ ሃንቲፆ ዓርቃኔ፤ ሻኣራ ዋንቶና ሮኦሮና ጉቤ ዔቆ ዒፂ ዴዔቴያ ሻኣራ ዔቃማና ዔያታ ዓኣዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ላምዖ ኬሊ ማዔቴያ ፔቴ ዓጊኒ፤ ሃሣ ፔቴ ሌዔ ማዔቴያ ዬካፓ ዑሣ ሻኣራ ዔቆ ዒፂ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዴዒ ናጌቴ ዔያታ ዓኣዹዋሴ፤ ሻኣራ ዔቃማና ጋዓንቴ ሃንቲፆ ዔያታ ዓርቃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ዔያታ ፔኤኮ ዎርቆ ማኣሮ ዾቃሢንታ ዬኖ ቤዞ ሃሺ ዴንዳሢ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«ዴሮ ፔቴይዳ ቡኩሳኒ፤ ሃሣ ዱንኪ ዴዔ ቤዛፓ ዴንዶም ዔቂሳኒ ዋርቂንታንዳ ላምዖ ዛዬ ቢራ ዓንጊና ዹይ ኮሼ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ላምዖ ዛዮንሢ ዋርቂንታኣና ዴራ ዓኣ ቤዛፓ ቢያ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ኔ ኮይላ ቡኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ፔቴ ዛዮማ ሌሊ ዋርቂንቴቴ ዒስራዔኤሌኮ ፃጶ ፃጶ ሱኡጋ ሌሊ ኔ ኮይላ ቡኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ሃሣ ፔቴ ዛዬ ዼጊዲ ዖዶቂ ዴይ ዋርቂንቴቴ ዓባ ኬስካ ዛሎና ዱንኪ ዴዔ ፃጶ ማኣሮ ዓሳ ዴንዲፆ ዓርቆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ላሚ ዬኖ ጎይፆ ዋርቂንታዛ ዾኦሎ ዛሎና ዱንኪ ዴዔ ፃጶ ማኣሮ ዓሳ ዴንዶንጎ፤ ዴራ ዴዔ ቤዞ ሃሺ ዓኣዻ ዎዶና ዬኖ ጎይፆ ዛያሢ ዋርቂንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ዴሮ ፔቴይዳ ቡኩሳኒ ዛያሢ ዋርቂንቶንጎ፤ ጋዓንቴ ዼጊዲ ዋርቂንቶፓ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ቄኤሳሢ፥ ዓኣሮኔ ናኣታ ዛያሢ ዋርቆንጎ፤ ዬይ ዒንሢኮ ናኣቶኮ ናኣቶ ሄላንዳኣና ማዺንቲ ዴዓ ዳምቤ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ዒንሢ ዖላኒ ሙካ ሞርኮ ዒንሢ ዖሊ ማሃኒ ዴንዳ ዎዶና ዒላቲ ማሂ ዛያሢ ዋርቁዋቴ፤ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ማኣዳንዳኔ፤ ሞርኮይዳፓኣ ታ ዒንሢ ዓውሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ዬያጉዲ ዎዛዺ ዒንሢ ቦንቾ ቦንቻ ኬሊና፤ ጌይፃ፦ ዓጊኒ ፄኤራኣና፥ ጊንሣ ካኣዦ ዛሎና ዒንሢ ቦንቾ ቦንቻኣና ሚቺ ዒንጎ ዒንጊፆንታ ፔቱሞና ዒንሢ ዒንጋ ዒንጊፆ ታኣም ዒንጋ ኬሎና ዛያሢ ዋርቁዋቴ፤ ዬይ፦ ዒንሢ ዒንሢ ዛሎ ታኣም ጶቂሢ ኬኤዛያ ማዓንዳኔ። ታኣኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ዒስራዔኤሌ ዴራ ጊብፄ ዓጫፓ ኬስኬንቴ ላምዓሳ ሌዖኮ ላምዓሳ ዓጊና ፄኤሪ ላማታሚ ኬሊ ማዓዛ ማርኮ ማዓ ባካ ዓኣ፥ ዓፒሎና ማዢንቴ ማኣሮ ካንቂ ዓኣ ሻኣራ ዔቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ዒማና ዒስራዔኤሌ ዓሳ ሲና ቦኦላፓ ኬስኪ ዓኣዼኔ፤ ሻኣራኣ ዴንዲ ፓኣራኔ ቦኦሎይዳ ላሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆ ዴራ ዓኣዺፆ ዓርቄኔ፤ ዬና ዔያቶኮ ቤርታሳ ሃንቲፆኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ዒማና ዪሁዳ ዓሶም ዒንጎና ባንዲሮ ዴማ ዓኣ፥ ዓሚናኣዳኣቤ ናኣዚ ኔዓሶኔ ዔኪ ዓኣዻ ዓሳ ዎሊ ሄሊ ዓኣዾም ጎኦና ጎይፆና ቤርታዺ ዓሶ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ዪሳኮኦሬ ዓሶ ዔኪ ዓኣዻሢ ፁዓሬ ናኣዚ ናቲናዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ዛብሎኦኔ ዓሶዋ ዔኪ ዓኣዻሢ ሄሎኔ ናኣዚ ዔኤሊዓቤኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ዬካፓ ዓፒሎና ማዢንቴ ማኣራ ቱጊንታዛ ዬያ ኬዴ ጌርሾኔና ሜራሪ ዓሳ ሄሊሲ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ሃሣ ሄሊሲ ሮኦቤኤሌ ዓሶም ዒንጎና ባንዲሮ ዴማ ዓኣ፥ ሼዴፁሬ ናኣዚ ዔኤሊፁሬ ዔኪ ዓኣዻ ዓሳ ዎሊ ሄሊ ዓኣዾም ጎኦና ጎይፆና ዓሶ ዔኪ ዓኣዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ሲሞኦኔ ዓሶ ዔኪ ዓኣዻሢ ፁሪሻዳዬ ናኣዚ ሼሉሜዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ጋኣዴ ዓሶ ዔኪ ዓኣዻሢ ዴዑዔኤሌ ናኣዚ ዔኤሊያሳፔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ዬካፓ ሌዊ ዓሲ ማዔ፥ ቄዓቴ ዓሳ ፆኦሲም ዱማዼ ባኮ ኬዲ ዓኣዼኔ፤ ዔያታ ዓሳ ዱንኪ ዴዔ ቤዞ ሄላንዳሢኮ ቤርታ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣራ ዾቂንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ሃሣ ሄሊሲ ዔፕሬኤሜ ዓሶም ዒንጎና ባንዲሮ ዴማ ዓኣ፥ ዓሚሁዴ ናኣዚ ዔኤሊሻማዔ ዔኪ ዓኣዻ ዓሳ ዎሊ ሄሊ ዓኣዾም ጎኦና ጎይፆ ዓሶ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ዒማና ሚናኣሴ ዓሶ ዔኪ ዓኣዼሢ ፔዳፁሬ ናኣዚ ጌማሊዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ቢኢኒያሜ ዓሶ ዔኪ ዓኣዼሢ ጊዲዖኔ ናኣዚ ዓቢዳኔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ጋፒንፃ ዳኣኔ ዓሶም ዒንጎና ባንዲሮ ዴማ ዓኣያ፤ ሃሣ ሃንጎ ዓሶ ቢያኮ ጊቲማ ማዒ ካፓ፥ ዓሚሻዳዬ ናኣዚ ዓሂዔዜሬ ዔኪ ዓኣዻ ዓሳ ዎሊ ሄሊ ዓኣዾም ጎኦና ጎይፆ ዓሶ ዔኪ ዓኣዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ዓሴኤሬ ዓሶ ዔኪ ዓኣዼሢ ዖክራኔ ናኣዚ ፓግዒዔኤሌኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ኒፕታኣሌኤሜ ዓሶ ዔኪ ዓኣዼሢ ዔናኔ ናኣዚ ዓሂራዔኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ዒስራዔኤሌ ዓሳ ዱንኪ ዴዔ ቤዛፓ ዔቂ ዓኣዻ ዎዶና ዴንዳ ጎይፃ ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ሙሴ ሚዲያሜ ዓጮ ዓሢ ራጉዔኤሌ ናኣዚ፥ ዒዛኮ ቦሊ ሆባቤ ኮራ፦ «ናንጊና ናንጋ ጎዳ ኑም ዒንጋኒ ጫኣቄ ዓጮ ዓኣዺፆሮ ኑ ዔቄኔ፤ ሃሣ ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ዖርጎቻንዳሢያ ኑም ጫኣቄኔ፤ ዬያሮ ኔኤኒያ ኑኡና ዎላ ዓኣዼ፤ ሜታ ባኣያ ኔና ኑ ናንጊሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ሆባቤ ጋዓንቴ፦ «ዔይዔ፤ ታኣኒ ታ ዓጮ፥ ታ ዒጊኖ ባንሢ ማዒ ዴንዳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ሙሴ ዒዛ ኮራ፦ «ሃዳራ፥ ኑና ሃሺ ዓኣዺፖ፤ ቦኦሎይዳ ኑ ሃንቲ ዓኣዻ ዎዶና ዎካ ኑ ዱንኪ ዴዓንዳቴያ ዔራንዳሢ ኔናታሢሮ ኔ ኑና ዻዋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ኔ ኑኡና ዎላ ዓኣዼቴ ፆኦሲ ኑም ዒንጋ ኮዦ ባኮይዳፓ ኔኤም ኑ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ዒስራዔኤሌ ዴራ ፆኦሲ ዹካ ዓኣ፥ ሲና ቦኦሎ ሃሺ ሃይሦ ኬሊ ጎይሢ ዓኣዼኔ፤ ዒማና ፆኦሲ ማዾም ዱማዼ ባኮ ኬዴ ሌዊ ዓሳ ቤርታ ቤርታ ዓኣዻዛ ናንጊና ናንጋ ጎዳ ዔያታ ዱንኪ ዴዓንዳ ቤዞ ዻዌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ዔያታ ዱንኪ ዴዔ ቤዛፓ ቤዛፓ ዔቂ ዓኣዻኣና ናንጊና ናንጋ ጎዳኮ ሻኣራ ሮኦሮና ዔያቶኮ ዑፃ ዑፃ ዓኣዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ቄኤሳ ጫኣቁሞ ሳኣፂኖ ጌይንታ ታኣቦቶ ኬዲ ዔቃ ዎዶና ቢያ ሙሴ፦ «ናንጊና ናንጋ ጎዳ! ዔቄ፤ ኔኤኮ ሞርካ ዣኣሊ ዣኣሊ ባይቆንጎ፤ ኔና ዒፃሢ ቢያ ኔ ቤርታፓ ጳሽኮንጎ» ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ሃሣ ጫኣቁሞ ሳኣፂና ዴንዲፆ ሃሺ ዔቃኣና፦ «ናንጊና ናንጋ ጎዳሢዮ! ዑሣ ዓኣዼ ሚርጌ ማዔ፥ ዒስራዔኤሌ ዓሶ ባንሢ ማዔ» ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ዒስራዔኤሌ ዓሳ ዔያቶ ሄላ ሜታሢሮ ቢያ ናንጊና ናንጋ ጎዳ ዑፃ ጉንዱሚሢ ዓርቄሢሮ ዒዚ ዬያ ጉንዱማሢ ዔያቶኮ ዋይዚ፥ ሚርጌና ዻጋዻዖ ሙዓ ታሚ ዔያቶይዳ ኬይሴኔ፤ ዬይ ታማ ዔያታ ዱንኪ ዴዔ ቤዞኮ ኮይላ ዓኣ፥ ዻካ ዛላ ጉርዳ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ዴራ፤ ሙሴ ዔያቶ ዛሎ ሺኢቃንዳጉዲ ዒላታዛ ሙሴ ናንጊና ናንጋ ጎዳ ሺኢቄም ታማ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ናንጊና ናንጋ ጎዳኮ ዬይ ታማ ዬኖ ቤዛ ዔኤቴሢሮ ዬና ቤዜላ «ታብዔራ» ጌይንቴኔ፤ (ታብዔራ ጌይፃ «ዔኤቲሢ» ጌይሢኬ።) ");
INSERT INTO mdyeth_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ዒስራዔኤሌ ዓሶና ዎላ ዓኣዼ ሜሌ ዓጪ ዓሲያ ዓኣኔ፤ ዔያታ ዒማና ዓሽኪ ሙዓኒ ሚርጌና ዓፃዼኔ፤ ዒስራዔኤሌ ዓሳኣ ሂዚ ጌይሢ ዓርቄኔ፦ «ኑኡኒ ሙዓንዳ ዓሽኪ ዓንካፓ ኑ ዴንቃንዳይ! ");
INSERT INTO mdyeth_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ጊብፄ ዓጫ ኑ ዓኣ ዎዶና ጪጎ ባኣዚ ባኣያ፥ ሞላሢ ጉሪ ኑ ሙዓኔ፤ ዒኢካ ኑ ዓኣ ዎዶና ሙዓ ባካ፦ ቦታ፥ ቤፂሄ፥ ኩራቴ፥ ዞቄ ሹንኩርቶንታ ቦኦሬሢንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ሃሢ ጋዓንቴ ዑፃ ኑኡኮ ፃኣዺ ሜሊ፥ ዎልቃኣ ኑኡኮ ላቤኔ፤ ኑ ሙዓ ባኣዚ ፔቴታዖ ባኣሴ፤ ቢያ ኬሊ ሃኖ ማኔሎይዳፓ ዓታዛ ሜሌ ጴዻ ባኣዚያ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ማና ጌይንታዛ፦ ዴኤቤ ቡኒጉዴያ ዻካታዖ ማኣሢጉዲ ጋላፒ ቦኦራያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","ዬይ፦ ዋንቶ ጉርዶ ባኣካ ዖልካ ኬዳዛ ዎላ ኬዳያኬ፤ ዬያሮ ጉቴ ዴራ ሃንቲ ሃንቲ ማንፂ ዔካዖ ዑዳይዳ ዑዲ ሃንጎ ዎንሢዳ ዎዺ ዺኢሊ ማሂ ሺኢቼስካፓ ዖቲዳ ካሢ፥ ሃንጎ ላኣዲ ላኣዳኔ፤ ዬይ ዛይቴና ዲርኪ ካሦናያጉዲ ዓኣፃያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ዴራ ቢያ ፔኤኮ ማኣሮ ማኣሮ ካራ ቡኪ ዔቂ ዔቂ ጉንዱማንቴ ሙሴ ዋይዜኔ፤ ናንጊና ናንጋ ጎዳ ዔያቶይዳ ዻጋዼሢሮ ሙሴ ሚርጌና ማሊ ሜታዻዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ናንጊና ናንጋ ጎዳ ኮይላ «ሃያጉዴ ዴኤሢ ባኣዚ ታና፥ ኔ ዓይላሢ ዑፃ ዓይጋ ኔ ዔኪ ዬዔይ? ዓይጋ ኔ ታና ዓሲኬ ጌይባኣይ? ሃያ ዓሶ ቢያሢ ዛሎ ታ ሜታዻንዳጉዲ ታ ዑፃ ኔ ዓይጋ ዴኤፂሴይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ሃያ ዓሶ ጎጲዳ ዔኪ ሃንቲ ታኣኒ ሾዔያቱዋሴ፤ ሂዳዖ፦ ዔያቶኮ ዓዶንሢም ኔ ‹ዒንጋንዳኔ› ጌይ ጫኣቄ ዓጮ ዔያታ ጌላንዳያ ሄላንዳኣና ዻንቃ ናይ ዲቻ ዓሲ ማዒ ዔያቶ ኬዲ ታ ዓኣዻንዳጉዲ ዓይጎ ማዾ ኔ ማዼይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ሃሢ ዔያታ ዓሽኪ ሙዓኒ ሚርጌና ዓፃዼኔ፤ ዓካሪ፦ ሃያ ዓሶም ቢያ ጊዳ ዓሽኪ ዓንካፓ ታ ዴንቃንዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ታ ሃያ ዓሶ ታኣሮ ሌሊ ዔኪ ዓኣዻኒ ዳንዳዑዋሴ፤ ሃይ ታኣም ሚርጌ ዴኤፃ ማዾኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ሃያይዲ ኔ ታና ሜታሳስካፓ፥ ታ ሃያ ሜቶ ዛጉዋጉዲ ታኣም ኔ ሚጪንቲ ሃሢ ኔ ታና ዎዼቴ ኮሺኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ናንጊና ናንጋ ጎዳ ሙሴም «ዴራ ማዻንዳ ጎይሢ ዻዊሢና ዔርቴ ላንካይታሚ ዓሲ ዶኦሪጋፓ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ቡኩሲ ዔቂሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ታኣኒያ ዒኢካ ኬዲ ኔኤና ዎላ ጌስታንዳኔ፤ ዒማና ኔኤም ታ ዒንጌ ዓያኖይዳፓ ዔያቶማኣ ታ ዒንጋንዳኔ፤ ዬካፓ ሃያ ዴሮ ኔ ዎይሢ ዴኤፂንታ ባሶ ኔና ዔያታ ማኣዳንዳኔ፤ ዬያሮ ዬያ ማዾ ኔኤሮ ዴኤፂንቲ ኔ ማዻዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ዓካሪ፦ ዴሮም ‹ዚራኣ ኬሎም ዒንሢ ዑፆ ጌኤሹዋቴ፤ ዓሽኪ ዒንሢ ሙዓንዳኔ፤ ዓሽኪ ኑም ዓይጌ ዒንጋንዳይ? ጊብፄይዳ ናንጊፃ ኑም ኮሺታዖ ዓቴኔ ጌይ ዒንሢ ጉንዱሚ ጌስቴ ጌኤዞ ናንጊና ናንጋ ጎዳ ዋይዜኔ፤ ዬያሮ ሃሢ ናንጊና ናንጋ ጎዳ ዒንሢም ዓሽኪ ዒንጌም ዒንሢ ሙዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ዒንሢ ሙዓንዳሢ ፔቴ ኬሊ፥ ላምዖ ኬሊ፥ ዶንጎ ኬሊ፥ ታጶ ኬሊንታ ላማታሚንታ ኬሊ ሌሊ ጉዴያቱዋንቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ዒንሢ ዛኣዓዻንዳያ ሄላንዳኣና፤ ሃሣ ቆርጮ ዓይሣንዳያ ሄላንዳኣና ዓጊኒ ጉቤ ሙዓንዳኔ። ዬይ ያዺ ማዓንዳሢ ሃካ ዒንሢ ባኣካ ዓኣ ፆኦሲ ዒንሢ ቦሂ፥ ጊብፄ ዓጫፓ ኑ ኬስኪባኣቴ ኮሺታዖ ዓቴኔ ጌይ ዒንሢ ጉንዱሜሢሮኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ሙሴ ናንጊና ናንጋ ጎዳ ኮይላ፦ «ሃኣዛጌ፤ ሃሢ ታኣኒ ላሆ ፄኤታ ሺያ ዓሲ ዔኪ ዓኣዻኔ፤ ኔኤኒ ዔያቶም ‹ፔቴ ዓጊኒሮ ማዓ ዓሽኪ ዒንጋንዳኔ› ጌይ ጫኣቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ሂንዳ፥ ዋኣዼ ባይና ማራይና ሹኪንቴቴ ዔያቶ ሚሻንዳይ? ባዞይዳ ዓኣ ሞላሢ ቢያ ቡኩሶናቴያ ዔያቶም ጊዳንዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ታና፥ ናንጊና ናንጋ ጎዳሢኮ ዎልቃ ዬማዺ ዻካያዳ? ታኣኒ ጌዔ ባካ ማዓቴያ ማዑዋቴያ ሃሢ ኔ ዛጋንዳኔ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ዬያሮ ሙሴ ናንጊና ናንጋ ጎዳ ጌዔ ባኮ ቢያ ኬስኪ ዴሮም ኬኤዜኔ፤ ሃሣ ዴሮይዳፓ ዶኦሪንቴ ላንካይታሞ ዓሶዋ ቡኩሲ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ኮይሎ ጎንጂሲ ዔቂሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ዒማና ናንጊና ናንጋ ጎዳ ሻኣሬና ኬዲ ሙሴና ጌስቴኔ፤ ሃሣ ሙሴም ዒዚ ዒንጌ ዓያኖይዳፓ ላንካይታሞ ዶኦሪንቴ ዓሶም ዒንጌም ዓያኖ ጌኤዣ ዔያቶ ዑፃ ኬዳዛ ፆኦሲ ማሊሢ ኬኤዛ ዓሲጉዲ ዑኡዞ ፔኤሲ ዼጊዲ ፆኦሲ ባኣዚ ኬኤዚሢ ዓርቄኔ፤ ዬያ ዔያታ ኬኤዜሢ ዻካ ዎዴም ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ዬማና ፃኣፒንቴ ላንካይታሞ ዓሶይዳፓ ላምዖ፥ ዔልዳዴና ሜዳዴ ጌይንታስኬንሢ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዴንዱዋዖ ጉርዳ ዓቴኔ፤ ዔያታ ዒኢካ ዓኣ ቤዛ ዓኣንቴ ዓያና ዔያቶይዳ ኬዴም ዔያታኣ ዑኡዞ ዼጊዲ ፆኦሲ ማሊሢ ኬኤዛ ዓሲጉዲ ፆኦሲ ባኣዚ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ዒማና ፔቴ ዼጌስኬይ ሙሴ ኮይላ ጳሽኪ ዴንዳዖ፦ «ዔልዳዴና ሜዳዴና ጉርዶ ባኣካ ዓኣዖ ፆኦሲ ማሊሢ ኬኤዛኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ዼጌ ዓኣዖ ሙሴ ማኣዳያ ማዒ ማዻ፥ ኔዊ ናኣዚ ዒያሱ፦ «ታ ጎዳሦ፥ ሙሴ! ዔያቶ ላኣጌ!» ጋዓዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ሙሴ፦ «ኔ ታ ጋይቴ ሚጪንቲ ዬያ ጋዓ? ናንጊና ናንጋ ጎዳ ዴሮ ቢያሢ ዑፃ ፔኤኮ ዓያኖ ኬይሴም ቢያሢ ዑኡዞ ዼጊዲ ፆኦሲ ማሊሢ ኬኤዛቴ ታና ዎዎዛሳንዳኔ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ዬካፓ ሙሴና ላንካይታሞ ዒስራዔኤሌ ዓሶ ሱኡጎንሢና ጉርዶ ማዒ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ዔርቲባኣንቴ ናንጊና ናንጋ ጎዳ ባዞይዳፓ ፑሮ ማላ ካፒ ዒሺ ዔኪ ዬዓንዳ ዢባሬ ዔኪ ዳካዛ፥ ፑራሢ ማላ ካፓ ሳዓፓ ላምዖ ዋዻ ማዓያ ሌሊ ዼግ ጌይ ባራኒ ሙኪ ጉርዶና ጉርዶኮ ኮይሎ ጉቤ ዛሎና ፔቴ ኬሊ ሃንቲንታንዳ ጎይሢጉዴያ ዳልጊሺ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ዬያሮ ዬኖ ኬሎ ሮኦሮና ዋንቶና፤ ሃሣ ጉቶዋ ቢያ ዬያ ካፖ ዳውሲ ዓርቂፆና ዓሳ ላቤኔ፤ ዒማና ታጶ ኪሎ ጊራኣሜይዳፓ ሃቶ ዓርቄ ዓሲ ባኣሴ፤ ዔያታ ዓርቂ ቡኩሴ ካፖ ሹኪ ሹኪ ሚጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ዔያታ ዓሽኮ ሙዓ ጎይሣ ዓኣንቴ ናንጊና ናንጋ ጎዳ ዴሮይዳ ሚርጌና ዻጋዺ ዼኤፒ ፑርታ ሃርጌ ዔኪ ዬዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ዬያሮ ዬኖ ቤዜሎኮ ሱንፃ፦ «ቂብሮትሃታዓባ» ጌይንቴኔ፤ ዬና ጌይፃ፦ «ዓፃዺሢ ዱኡፒ» ጌይሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ዬኖ ቤዛፓ ዴራ ሃፂሮቴ ጌይንታ ቤሲ ዴንዲ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ሙሴ ዒቶጲያ ዓጫፓ ኩሼ ፃጲ ማዔስኬኖ ዔኬሢሮ ማይራሞና ዓኣሮኔና ዒዛ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","«ናንጊና ናንጋ ጎዳ ኬኤዜሢ ሙሴ ዛሎና ሌሊዳ? ኑ ዛሎና ኬኤዚባኣዓዳ?» ጌይ ዾንኪ ጌስቴኔ፤ ናንጊና ናንጋ ጎዳኣ ዬያ ዔያታ ጌዔሢ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ዓጮይዳ ዓኣ ዓሶይዳፓ ቢያ ባሼ ሙሴ ሼሌዔ ዓሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ዒማና ኔጉዋዖ ናንጊና ናንጋ ጎዳ ሙሴንታ ዓኣሮኔንታ ማይራሞንታም፦ «ዒንሢ ሃይሣሢ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ዬዑዋቴ» ጋዓዛ፥ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ዬካፓ ናንጊና ናንጋ ጎዳ ሻኣሬና ኬዲ ዓፒሎና ማዢንቴ ማኣሮ ካራ ዔቃዖ፦ «ዓኣሮኔ! ማይራሜ!» ጌይ ዔያቶ ዔኤላዛ፥ ላምዖንሢ ዒዛ ቤርቶ ሺኢኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ናንጊና ናንጋ ጎዳ ዔያቶ ኮራ፦ «ታ ዒንሢም ኬኤዛሢ ዋይዙዋቴ! ዒንሢ ባኣኮይዳ ታ ማሊሢ ኬኤዛ ዓሲ ዓኣያ ማዔቴ ታ ዔያቶም ታና ፔጋሲ ዻዋሢ ዱማ ጎይሢና ታኑሞ ዻዊ ዔርዚ፤ ጊንሣ ሃሣ ዓውቲናኣ ኬኤዚኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ታ ዓይላሢ፥ ሙሴና ታ ጌስታሢ ጋዓንቴ ያዺዲቱዋሴ፤ ዒዚ ታ ማኣሮይዳ ጉሙርቂንታ ዓሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ዬያሮ ታ ዒዛና ፔጌና ጌጌስታኣፓዓቴም ዓኣሺንቴ ጎይሢና ታ ዒዛም ኬኤዙዋሴ፤ ዒ ታና፥ ናንጊና ናንጋ ጎዳሢኮ ዓውካሮ ዛዛጋኔ፤ ሂዳዖ ዒንሢ ታ ዓይላሢ፥ ሙሴ ዎይቲ ጫርቂ ዾንካኒ ዳንዳዔይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ናንጊና ናንጋ ጎዳ ዻጋዺ ዔያቶ ጎሬስካፓ ዓኣዻዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ዓፒሎና ማዢንቴ ማኣራፓ ሻኣራ ዔቂ ዴንዴኔ፤ ዒማና ዑፃ ኬስካ ዶርዓሢ ማይራሞ ዓርቄኔ፤ ዑፃ ዒዞኮ ቢያ ቲልቢ ሻቺጉዲ ቦኦሬኔ፤ ዒዛ ያዺ ማዔሢ ዓኣሮኔ ዛጋዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ሙሴ ኮይላ፦ «ታ ጎዳ፥ ኑ ዔኤዪ ማዼ ጎሞ ሃያ ዔኤቢኬ ጌይ ዓርቂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ማይራማ ዒንዶ ጎጶይዳ ዓኣዖ ሃይቂ፥ ዛሎ ዑፃ ሙልጌያ ማዒ ሾይንቴ፥ ቡሊሢ ማሊ ሃኣዺዲ ዓታንዳጉዲ ዛጊ ዚቲ ጌይፖ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ዬያሮ ሙሴ፦ «ናንጊና ናንጋ ጎዳሢዮ! ሃዳራ ዒዞ ፓሤ» ጌይ ፆኦሲ ባንሢ ዒላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ናንጊና ናንጋ ጎዳ ዒዛም፦ «ዒዞኮ ዓዴ ዻጋዺ ዓኣፖ ካራ ጩቴያ ማዔቴ ዒዛ ቦርሲንቴያ ማዒ ላንካይ ኬሊ ዴዓንዳያቱዋዓዳ? ዬያሮ ዒዛ ጉርዳፓ ኬስኪ ላንካይ ኬሊ ሄላንዳኣና ዓሲባኣ ቤስካ ዴዖንጎ፤ ዬካፓ ጉርዶ ዒዛ ጌላኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ዬያሮ ማይራማ ጉርዳፓ ኬስኪ፥ ዓሲባኣ ቤስካ ፔኤሮ ዱማዺ ዴዔኔ፤ ዒዛ ዓሶ ባኣኮ ማዒ ሙካንዳያ ሄላንዳኣና ዓሳ ዬኖ ጉርዶ ሃሺ ዓኣዺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ዬካፓ ሄፂሮቴይዳፓ ዔቂ ፓኣራኔ ቦኦሎይዳ ዓሳ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«ዒስራዔኤሌ ዓሶኮ ታጶ ላምዖ ፃጳፓ ሱኡጌ ማዓንዳ ፔቴ ፔቴ ዓሲ ዶኦሪ ዔኪ ታኣኒ ዔያቶም ዒንጋንዳ ካኣናኔ ዓጮ ዓኣዺ ዓጬላ ዓኣ ጎይፆ ሙሪ ማዓንዳጉዲ ዳኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ሱኡጌ ማዓ ታጶ ላምዖ ዓሲ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ፓኣራኣኔ ቦኦላፓ ዳኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ዬያቶ ዴንዴ ዓሶኮ ሱንፃ ሃካፓ ሊካ ኬኤዚንታ ጎይፆኬ፦ ሮኦቤኤሌ ማኣራፓ ዛኩሬ ናኣዚ ሳሙዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ሲሞኦኔ ማኣራፓ ሱሬ ናኣዚ ሴፔፄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ዪሁዳ ማኣራፓ ዪፑኔ ናኣዚ ካኣሌቤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ዪሳኮኦሬ ማኣራፓ ዮሴፔ ናኣዚ ዪግዓሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ዔፕሬኤሜ ማኣራፓ ኔዊ ናኣዚ ሆሼዓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ቢኢኒያሜ ማኣራፓ ራፑ ናኣዚ ፔሊፄ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ዛብሎኦኔ ማኣራፓ ሶዲ ናኣዚ ጉዲዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ዮሴፔ ናኣዚ ሚናኣሴ ማኣራፓ ሱሲ ናኣዚ ጋዲ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ዳኣኔ ማኣራፓ ጌማሌ ናኣዚ ዓሚዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ዓሴኤሬ ማኣራፓ ሚካዔኤሌ ናኣዚ ሴቱሬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ኒፕታኣሌኤሜ ማኣራፓ ያቤ ናኣዚ ናቢ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ጋኣዴ ማኣራፓ ማኣኪ ናኣዚ ጉዲዔኤሌ ጌይንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ዓጬሎ ሙሪ ሙካንዳጉዲ ሙሴ ዳኬ ዓሳ ዬንሢኬ፤ ኔዊ ናኣዚ ሆሼዓኮ ሱንፆ «ዒያሱ» ጌይ ዒዚ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ሙሴ ዔያቶ ዳካ ዎዶና፦ «ኔጌቤ ዓጮይዴና ጌዒ ጌሜራዻ ዓጮ ኬስኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ዓጫ ዎዚጉዲታቴያ፥ ዋኣዼ ዓሲ ዒኢካ ናንጋቴያ፤ ሃሣ ዶዱማ ዔያቶኮ ዎዚታቴያ ዛጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ሳዔላ ኮሺታቴያ፥ ሃሣ ፑርታቴያ፤ ዴራ ናንጋሢ ፔጌ ማዔ ጉርዳይዳሞ? ዙሎ ዲርቆና ካታማይዳሞ? ዬያ ዛጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ሳዖ ዓጫ ማሊታቴያ፥ ሃሣ ዼኤፒ ካይዚ ሚርጌ ዓኣቴያ ዛጉዋቴ፤ ዬኖ ዓጮይዳ ዓኣ ሙዖ ሚፆ ዓኣፖይዳፓ ዋሉዋዖ ዔኪ ዬዑዋቴ» ጌዔኔ። ዬና ዎዳ ዎይኔ ካፃ ዎዴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ዬያሮ ዔያታ ዓጮኮ ኬዶ ዛሎ ዴንዲ፥ ዬኖ ዓጬሎይዳ ዓኣ ፂኢኔ ቦኦላፓ ዓርቂ ሃማቴ ካታሞ ዴንዶ ቶኦሎ ካሮና ጌይ ሬሆቤ ዓጮ ሄሊ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ቤርታዺ ዔያታ ኔጌቤ ዓኣዺ፥ ጊዴና ኬብሮኦኔ ካታሞ ሄሌኔ፤ ዬና «ዓናቂሜ» ጌይንታ ዼኤፖ ዓሶ ዜርፆ ማዔ፥ ዓሂማኔና ሼሻዬና ታልማዬ ጌይንታ ቶኦካ ናንጋ ቤሲኬ፤ ኬብሮኦኔ ካታማ ማዢንቴሢ ጊብፄ ዓጮይዳ ፆዓኔ ጌይንታ ካታማ ማዢንታንዳሢኮ ላንካይታሚ ሌዔና ቤርታዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ዔያታ ዒዞ ጊዴና ጌዒ ዓሽኮሌ ዶኦጮ ሄሌኔ፤ ዒኢካ ዎይኔ ዓሚ ካፂ ዓኣንቴ ዔያታ ቲቂ ዔኬኔ፤ ዬይ ፔቴ ዓሲ ኬዳኒ ዳንዳዑዋያ፥ ዴኤሢ ማዔሢሮ ላምዖ ዓሲ ዛጶና ኬዴኔ፤ ዬያ ዎይኖ ዓኣፖና ዎላ ሮኦማኣኔ ጌይንታ ሚፆ ዓኣፖንታ ቤሌሴ ሚፆ ዓኣፖዋ ዔያታ ዔኪ ዬዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ዬና ቤዛ፦ «ዔሽኮሌ ዶኦጮ» ጌይንቴኔ፤ (ዔሽኮሌ ጌይፃ ዔብሬ ዓሶ ሙኡጮና ዎይኖ ዓኣፖ ሱፆ ጌይሢኬ።) ዬያ ጌይንቴሢ ዒስራዔኤሌ ዓሳ ዎይኖ ሚፆ ዓኣፖ ዒኢካፓ ቲቂ ዔኪ ሙኬሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ዬና ዓሳ ዖይዲታሚ ኬሊ ዓጬሎ ሙሪ ዛጌስካፓ ማዒ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ፓኣራኔ ቦኦሎይዳ ቃዴሴ ጌይንታ ቤዛ ዓኣ ሙሴና ዓኣሮኔና፥ ሃሣ ዒስራዔኤሌ ዴሮ ጉቤሢ ኮይላ ሙኬኔ፤ ዔያታ ዛጌ ባኮ ቢያ ኬኤዜኔ፤ ዔኪ ሙኬ ሚፆ ዓኣፖዋ ዔያቶም ዻዌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ሙሴም ዔያታ፦ «ጎኔ፥ ዓጬላ ዔኤሲና ዲኢቂና ኩሜ ማሊ ዓጪ ማዔሢ ኑ ዛጌኔ፤ ዒዞ ዓጫፓ ኑ ዔኪ ዬዔ ሚፆ ዓኣፖ ሃኣዛጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ጋዓንቴ ዬኖ ዓጮይዳ ናንጋ ዴራ ሚርጌና ዶዲ ዓሲኬ፤ ዔያታ ናንጋ ካታማ ዼኤፒ ዼኤፒ፥ ሃሣ ዓጮዋ ዶዲሺ ዲርቆናያኬ፤ ሃሣ ዒኢካ ዎልቄና ዼኤፒ ማዔ፥ ዔናኣቄ ዓሶ ዜርፆዋ ኑ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ዓማሌቄ ዓሳ ኔጌቤ ዓጮይዳ ናንጋያ ማዓዛ ሂኢታ ዓሶንታ ዒያቡሳ ዓሶንታ ዓሞራ ዓሶንታ ጌሜራዻ ዓጮይዳ ናንጋኔ፤ ካኣናኔ ዓሳኣ ሃሣ ዮርዳኖሴ ዎሮ ኮይሎና ሜዲቴራኒያ ባዞ ኮይሎናይዳ ናንጋኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ካኣሌቤ ጋዓንቴ ሙሴ ኮይላ ቡኪንቲ ዓኣ ዴሮ ዚቲ ጌይሴስካፓ፦ «ዔያቶ ኑ ባሻንዳ ዎልቄ ኑኡኮ ዓኣሢሮ ዓጬሎ ሃሢ ኑ ዴንዲ ዓርቆም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ካኣሌቤና ዎላ ዓኣዼ ዓሳ ጋዓንቴ፦ «ኑ ዔያቶ ባሻንዳ ዎልቄ ፔቴታዖ ኑኡኮ ባኣሴ፤ ዒኢካ ናንጋ ዓሳ ኑጊዳፓ ዶዲ ዎልቄና ዓኣያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ዔያታ ዛጊ ሙኬ ዓጬሎ ዛሎ ዒስራዔኤሌ ዓሶም ኬኤዜሢ ዓሶ ዒጊቻንዳ ጎይሢኬ፤ ዔያታ ኬኤዛዖ፦ «ኑኡኒ ዛጋኒ ዴንዴ ዓጬላ ዒዞይዳ ናንጋኒ ሙካ ዓሲ ሙሙዓንዳያኬ፤ ዒኢካ ኑ ዛጌ ዓሳ ዖዶሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ዒኢካ ኑ ዼኤፒ ዼኤፒ ማዔ ዓናቂሜ ዜርፆ ዛጌኔ፤ ኑኡኒ ዔያቶ ቤርቶይዳ ፃቆ ማዒ ጴዼኔ፤ ዔያታኣ ኑና ዒማዒ ማሂ ዛጉዋዖ ዓቴያናንጋዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ዴራ ዬኖ ዋንቶ ቢያ ሜታዺ ዒላቴ ጎይሣ ዎርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ሙሴና ዓኣሮኔና ዑፃ ዔያታ፦ «ጊብፄ ዓጮይዳ፤ ሃሣ ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ኑ ሃሃይቄቴ ዓይጌ ዓኣይ! ");
INSERT INTO mdyeth_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ናንጊና ናንጋ ጎዳ ኑና ዬኖ ዓጬሎ ዔኪ ዓኣዻሢ ዓይጎሮዳይ? ኑኡኒ ቢያሢ ዖልዚና ኩዳንዳኔ፤ ናኣቶና ላኣሎና ኑኡኮ ዲዒንቲ ዔውታንዳኔ፤ ጊብፄ ዓጮ ማዒ ኑ ዴንዴቴ ቃራ ማዓዓዳ?» ጌዒ ጌዒ ጉንዱሚ ጌስቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ዬያሮ ዎሊ ኮይላ ዔያታ፦ «ሃኒ ሙኩዋቴ! ኑና ዔኪ ዓኣዻንዳ ዓሲ ኑ ዶኦሪ፥ ጊብፄ ዓጮ ማዒ ኑ ዴንዶም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ዒማና ሙሴና ዓኣሮኔና ዴሮኮ ቤርታ ጎጲና ላሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ዓጮ ሙሪፆ ዓኣዼዞንሢፓ ላምዖንሢ፦ ኔዊ ናኣዚ ዒያሱና ዪፑኔ ናኣዚ ካኣሌቤና ዖዪ ፔኤኮ ዓፒሎ ዳርዛዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ዴሮም፦ «ኑኡኒ ዛጊ ሙኬ ዓጬላ ሚርጌና ሚዛጳ ዓጪኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ናንጊና ናንጋ ጎዳ ኑ ዛሎና ዎዛዼያ ማዔቴ ዬኖ ዓጮ ኑና ዔኪ ዓኣዺ ዔኤዞና ዲኢቆና ኩሜ፥ ማሎ ዓጬሎ ኑም ዒንጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ዬያሮ ናንጊና ናንጋ ጎዳም ዓይሢንቲፆ ዒፂፖቴ፤ ዒኢካ ናንጋ ዴሮዋ ዒጊጪፖቴ፤ ኑ ዔያቶ ሜታዹዋዖ ዖሊ ባሻንዳኔ፤ ናንጊና ናንጋ ጎዳ ኑኡና ዎላኬ፤ ዔያቶ ካፓኔ ጌይ ዔያታ ጉሙርቃ ፆኦዛ ዔያቶኮ ላቤኔ፤ ዬያሮ ዔያቶ ፔቴታዖ ዒጊጪፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ዒማና ዴራ ዔያቶ ሹቻ ዹይ ዎዻኒ ዞርቴኔ፤ ጋዓንቴ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ዑፆይዳ ናንጊና ናንጋ ጎዳኮ ቦንቾ ፖዓ ፖዒ ዒስራዔኤሌ ዓሶም ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሃይ ዴራ ታና ቦሃሢ ዓይዲ ሄላንዳኣናዳይ? ታ ዎልቄና ማዺንታ ሚርጌ ባኣዚ ማዺ ታ ዔያቶ ዻዌኔ፤ ሂዳዖ ታና ዔያታ ጉሙርቁዋኣሢ ዎማ ሄላንዳኣናዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ታ ዔያቶይዳ ሃርጌ ዔኪ ዬዒ ዔያቶ ባይዛንዳኔ፤ ኔና ጋዓንቴ ታ ዔያቶይዳፓ ባሼ ዺቢ፥ ሃሣ ዶዲ ማዔ ዴሬኮ ዓዶ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ሙሴ ናንጊና ናንጋ ጎዳ ኮይላ፦ «ሃያ ዴሮ ኔ ዎልቆና ጊብፄ ዓጫፓ ኔ ኬሴኔ፤ ኔ ዴሮ ዑፃ ኔ ማዼ ባኮ ጊብፄ ዓሳ ዋይዜቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ዬያ ባኮ ቢያ ሃያ ዓጮይዳ ናንጋ ዓሶም ኬኤዛንዳኔ፤ ሃይ ዴራ ኔኤኒ፥ ናንጊና ናንጋ ጎዳ ኑኡና ዎላ ዓኣሢና ኔኤኮ ሻኣራ ኑ ዑፃ ላሃ ዎዶና ፔጋዺ ኔ ጴዻሢና፤ ዬያጉዲ ሃሣ ሮኦሪ ዡኡሎጉዲ ዔቄ ሻኣሮና፥ ዒባኒ ሃሣ ዡኡሎጉዲ ዔቄ ታሞና ዔኪ ኑና ኔ ዓኣዻሢ ዔያታ ዎዳ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ዓካሪ ሃሢ ኔኤኒ ዴሮ ኔኤኮ ፔቴና ዎዺ ኩርሴቴ፥ ኔ ማዼ ባኮ ቤርታ ዋይዜ ሜሌ ዓሳ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹ናንጊና ናንጋ ጎዳ ሃያ ዴሮም ዒንጋንዳኔ ጌይ ጫኣቄ ዓጮ ጌልዛኒ ባሺንቴሢሮ ዓሲ ናንጉዋ ዳውሎይዳ ዔያቶ ዎዺ ባይዜኔ› ኔና ጋዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ዬያሮ ናንጊና ናንጋ ጎዳሢዮ! ኔ ኬኤዜ ጎይፆ ዎልቆ ኔኤሲ ዻዌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ኔኤኒ ኬኤዜሢ፦ ‹ታኣኒ፥ ናንጊና ናንጋ ጎዳሢ ዑኬ ዻጋዻያቱዋሴ፤ ታኣኮ ማኣሪፆና ናሹሞና ሚርጌኬ፤ ጎሜ ማዼያና ዓይሢንቲሢ ዒፄ ዓሲ ዻቢንቶ ዔሪ ማዔቴ ዓቶም ታ ጋዓንዳኔ፤ ዻቢንቴሢም ኮይሳ ሜቶ ዒንጉዋዖ ታ ሃሹዋያኬ፤ ዓዶንሢ ማዼ ጎሞሮ ናኣቶኮ ናኣቶ ሄላንዳኣና ሜቶ ታ ሄሊሱዋዖ ሃሹዋሴ› ጌዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ዬያሮ ሃሢያ፥ ናንጊና ናንጋ ጎዳሢዮ! ዔያታ ጊብፄ ዓጫፓ ኬስኬማፓ ዓርቃዖ ኔኤኮ ዼኤፖ ናሹሞና ኔ ዔያቶም ዓቶም ጌዒ ጌዒ ዓኣሢጉዲ ሃያ ዓሶኮ ጎሞ ዓቶም ኔ ጋዓንዳጉዲ ታ ኔና ሺኢቃኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ናንጊና ናንጋ ጎዳ ዒዛም ማሃዖ፦ «ኔኤኒ ታና ዖኦጬ ጎይፆና ታኣኒ ዔያቶም ዓቶንጎ ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ጋዓንቴ ታኣኒ ናንጊና ናንጋያ ማዔሢሮ፤ ሃሣ ቦንቻ ታኣኮ ዓጮ ቢያ ኩሜያ ማዔሢሮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ታኣኮ ቦንቾ፤ ሃሣ ጊብፄ ዓጮና ዓሲ ናንጉዋ ዳውሎናይዳ ታ ማዼ ታ ዎልቆና ማዺንቴ ዼኤፖ ማዾ ዛጌዖ ታኣም ዒፄዞንሢና ታጶ ማይንቲ ታ ዎይታቴያ ዛጋኒ ማዺ ሺሬ ዓሶይዳፓ ፔቴ ዓሲታዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ዔያቶኮ ዓዶንሢም ‹ታ ዒንጋንዳኔ› ጌዒ ጫኣቄ ዓጮ ጌላዓኬ። ታና ቶኦቼ ዓሶይዳፓ ፔቴ ዓሲታዎ ዬኖ ዓጬሎ ዔያታ ጌላዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ታ ዓይላሢ፥ ካኣሌቤ ጋዓንቴ ዱማ ማሊሢ ዒዛይዳ ዓኣሢሮ፤ ሃሣ ታና ዒ ዒናፓ ጉሙርቃያ ማዔሢሮ ዴንዲ ዒ ዛጊ ሙኬ ዓጬሎ ታ ዒዛ ጌልዛንዳኔ። ዜርፃኣ ዒዛኮ ዬኖ ዓጮ ዻካላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ዬና ዓጬላ ሃሢ ዓማሌቄ ዓሶና ካኣናኔ ዓሶና ናንጋ ዓጮኬ፤ ዬያሮ ዚሮ ጊንሢም ማዒጋፓ ዞቄ ባዞ ባንሢ ዓኣዻ ጎይፆና ጌዒ ዓሲ ናንጉዋ ዳውሎ ዴንዱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«ሃይ ፑርቶ ዴራ ታጊዳ ጉንዱማሢ ዓይዲ ሄላንዳኣናዳይ? ዬያ ዔያቶኮ ዒሣ ጉንዱማሢ ታ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ዬያሮ ሃሢ ዔያቶም፦ ‹ናንጊና ናንጋ ጎዳ ሂዚ ጋዓኔ፤ ታኣኒ ናንጊና ናንጋያኬ፥ ዒንሢ ጋኣንቴ ታ ዋይዜ ባኮ ጎኔ ዒንሢዳ ታ ማዻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ዒንሢ ቢያሢ ሃይቃንዳኔ፤ ሌዛ ዒንሢኮ ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ኬኤሪንቲ ዓታንዳኔ፤ ዒንሢ ታጊዳ ጉንዱሜሢሮ ቤርታ ዒንሢ ፓይዶናኣና ሌዓ ላማታሚ ማዔሢና ዬካፓ ዑሣ ማዔ ዓሳ ቢያ ሃይካ ኩኩዳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ዒንሢ ናንጋንዳጉዲ ዒናፓ ታ ዒንሢም ጫኣቂ ዒንጌ ዓጬሎ ዪፑኔ ናኣዚ ካኣሌቤና ኔዊ ናኣዚ ዒያሱናይዳፓ ዓታዛ ዒንሢዳፓ ፔቴ ዓሲታዖ ጌላዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ዒንሢ ኑኡኮ ዲዒንቲ ዔውታንዳኔ ጌዔ ናኣቶ ዒንሢ ቦሄ ዓጬሎ ጌልዚ ዔያቶ ዓጪ ታ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ዒንሢ ጋዓንቴ ሃያ ቦኦሎይዳ ሃይቂ ኬኤሪንቲ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ዒንሢ ታና ጉሙርቆ ዒፄሢሮ ዒንሢዳፓ ጋፒንፃ ሃይቃንዳሢ ሃይቂ ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ኬኤሪንታንዳያ ሄላንዳኣና ዒንሢኮ ናኣታ ሃያ ቦኦሎይዳ ዖይዲታሚ ሌዔ ሚርጌ ሜታዺ ሴካ ሃንጋ ሃንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ዒንሢ ማዼ ጎሞ ዛሎሮ ዖይዲታሚ ሌዔ ጉቤ ዒንሢ ዬያይዲ ሜታዻንዳኔ፤ ዬይያ ዓጬሎ ዒንሢ ሙሪፆሮ ዴንዳዖ ኔጌ ዖይዲታሞ ኬላ ፔቴ ፔቴ ሌዔ ዒንሢም ማዓንዳኔ ጌይሢኬ፤ ዬካፓ ዓካሪ ዒንሢ ታኣም ዋይዚ ዒፂሢ ዎዚጉዴ ሜቶ ሄሊሳቴያ ዔራንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ታጊዳ ፑርቱሞና ዞርቲ ዔቄ፥ ሃያ ዴሮይዳ ዬያ ባኮ ቢያ ታ ማዻንዳኔ፤ ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ዒንሢ ቢያሢ ሃይቂ ኩዳንዳኔ፤ ዬያ ጌዔሢ ታና፥ ናንጊና ናንጋ ጎዳኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","ዓጬሎ ሙራንዳጉዲ ሙሴ ዳኬ ዓሶይዳፓ ዴራ ናንጊና ናንጋ ጎዳ ዑፃ ጉንዱማንዳጉዲ ሉኡዙሞ ሃይሶ ዴሮም ኬኤዜ ዓሶይዳ ናንጊና ናንጋ ጎዳ ፑርታ ዶርዖ ዓጌም ዔያታ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ዓጬሎ ሙሪ ማዒ ሙኬ ዓሶይዳፓ ሃይቁዋዖ ዓቴዞንሢ ኔዊ ናኣዚ ዒያሱና ዪፑኔ ናኣዚ ካኣሌቤና ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ናንጊና ናንጋ ጎዳ ጌዔ ባኮ ቢያ ዒስራዔኤሌ ዴሮም ሙሴ ኬኤዛዛ፥ ዓሳ ዒናፓ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ዬካፓ ዚሮ ጉቴሎ ጉቴ ዓማ ጌሜራዻ ዓጮ ዖሊ ዓርቃኒ ዔያታ ዔቄኔ፤ ዒማና ዔያታ፦ «ሃይሾ ዓካሪ ናንጊና ናንጋ ጎዳ ኑም ዒንጋንዳኔ ጌይ ጫኣቄ ቤዞ ኑ ዓኣዻንዳኔ፤ ቤርታ ኑ ጎሜ ማዼሢ ኑ ዔሬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ሙሴ ጋዓንቴ፦ «ናንጊና ናንጋ ጎዳ ዓይሤ ባኮ ዓይጎሮ ዒንሢ ኩንሦ ዒፃይ? ዒንሢ ሃሢ ማላ ማሊፃ ዒንሢም ጊኢጋዓኬ! ");
INSERT INTO mdyeth_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ናንጊና ናንጋ ጎዳ ዒንሢና ዎላቱዋኣሢሮ ዬካ ዓኣዺፖቴ፤ ዒንሢኮ ሞርካ ዒንሢ ባሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ዓማሌቄ ዓሶና ካኣናኔ ዓሶና ዒንሢ ዴዴንቃዖ ዖሎ ዓርቃንዳኔ፤ ናንጊና ናንጋ ጎዳ ሃሺ ዒንሢ ዓኣዼሢሮ፥ ሃሣ ዒዚ ዒንሢና ዎላ ማዒንዱዋኣሢሮ ዖሎና ዒንሢ ባሺንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ሙሴንታ ፆኦሲኮ ጫኣቁሞ ታኣቦቶንታ ጉርዳፓ ዓጊፂ ዓኣዹዋንቴ ፔ ማሊሢና ሌሊ ዔያታ ዖይዺሺ ዹኮ ዓጮ ዖላኒ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ዬካፓ ዒኢካ ናንጋ ዓማሌቄ ዓሶና ካኣናኔ ዓሶና ሎኦፓ ኬዲ ዖሎ ዔያቶና ዓርቃዖ ሆርማ ጎዖ ቤዞ ሄላንዳኣና ባሺ ዔያቶ ዳውሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ‹ዒንሢ ናንጋንዳጉዲ ታ ዒንሢም ዒንጋኒ ማሌ ዓጬሎ ዒንሢ ጌላ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ሚቺ ዒንጎ ዒንጊሢም፥ ናኣቢ ኩንሣኒ ዒንጊንታ ዒንጊሢም፤ ሃሣ ፔ ማሊሢና ናሽኪ ዒንጎ ዒንጊሢያ ማዖም ካኣዦ ዛሎንታ ዔርቴ ቦንቾ ኬሎንታይዳ ዒንጊንታ ዒንጊፆም ማዓንዳጉዲ ጌማይ፥ ዓዴ ማራይ ሺኢሺ ዒንጉዋቴ፤ ዬያጉዴ ሙዖ ዒንጊፆ ማዔ ዒንጊፃ ናንጊና ናንጋ ጎዳ ዎዛሳያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ዬያጉዴ ዒንጊፆ ዒንጋ ዓሢ ዶሎዜኮ ጊዲሚሺፓ ኬዳያ ማዔ ዛይቴና ዲርኪንቴ፥ ፔቴ ኪሎ ማዓንዳ ሺኢቺ ዺኢሊ፤ ሃኣኮ ዒንጊሢ ማሂ ዒንጋንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ዬያጉዲ ሃሣ ፔቴ ፔቴ ዓዶ ማራቶና ዎላ ዑሺ ዒንጊሢ ማዓንዳጉዲ ዶሎዜኮ ጊዲሚሺፓ ኬዳያ ማዔ ዎይኔ ዑሺ ሚቺ ዒንጎ ዒንጊፆና ዎላ ዔኪ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ዓዴ ማራይ ፆኦሲም ዒንጊንታ ዒንጊሢ ማዒ ዒንጊንታ ዎዶናኣ ዶሎዜ ኩሙሢና ሃሣ ጊዲሚሺ ማዓ ሪሚቲ ዛይቴና ዲርኪንቴ ፔቴ ኪሎ ማዓ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ዑሺ ዒንጊሢ ማዓንዳጉዲ ዶሎዜኮ ጊዲሚሺፓ ኮሺ ኬዳያ ማዔ ዎይኔ ዑሺ ዔኪ ሺኢሹዋቴ፤ ዬያ ቢያ ዒንጎ ባኮኮ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ናኣቢ ኩንሥሢሮ ማዖም ፔቱሞና ሚቺ ዒንጎ ዒንጊሢ ማሂ፤ ዬያጉዲ ጊንሣ ፆኦሲም ሹኪ ዒንጎያ ማሂ ፔቴ ዎፓና ዒንጊንታ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ዬያ ዎፓናሢና ዎላ ዶሎዜኮ ጊዲሚሺ ማዓ ዛይቴና ዲርኪንቴ፥ ሃይሦ ኪሎ ማዓንዳ ሺኢቺ ዺኢሊ ሃኣኮ ዒንጊሢ ማሂ ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ዬያጉዲ ሃሣ ዶሎዜኮ ጊዲሚሺ ማዓ ዎይኔ ዑሺ ፆኦሲም ዒንጊንታ ዑሺ ዒንጊሢ ማሂ ሺኢሹዋቴ፤ ዬይ፦ ናንጊና ናንጋ ጎዳ ዎዛሳያ ማዔ፥ ሚቺ ዒንጎ ዒንጊሢ ማዓንዳኔ›» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ፔቴ ፔቴ ዎፓኖና ዓዶ ማራዖና፤ ሃሣ ማራናኣቶና ዋናናኣቶና ዎላ ዒንጊንታንዳ ዒንጊፃ ያዺ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ፔቴ ቆልሞፓ ዑሣ ዓኣዼ ማዔ ዒንጊሢ ዒንጊንታ ዎዶና ዎላ ዒንጊንታ ሃኣኮ ዒንጊፃ ዬኖ ጎይፆ ቃሲንቲ ቃሲንቲ ዴንዳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ዓጫ ሾይንቴ ፔቴ ፔቴ ዒስራዔኤሌ ዓሳ፦ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳ ዒንጊሢ ማሂ ሃኣኮ ዒንጊሢ ዒንጋ ዎዶና ዬያ ቢያ ማዻንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ሚርጌ ዎዴያ ማዖም ዻካ ዎዴ ዒንሢ ባኣካ ሙኬ ዓሲ ማዒ ናንጋ ሜሌ ዓጪ ዓሲ ሳዋ ናንጊና ናንጋ ጎዳ ዎዛሳ፥ ሙኡዚ ዒንጊሢ ዒንጋኒ ኮዔቴ ዬያ ዳምቦ ጎይፆ ማዻንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ዒንሢ ማዔቴያ ዒንሢ ባኣካ ናንጋ ሜሌ ዓጮ ዓሳ ሙካ ዎዶይዳ ቢያ ዬንሢ ዳምቦንሢ ሄኮ ካፒ ኩንሣንዳያ ኮይሳኔ፤ ዒንሢንታ ዔያቶንታ ናንጊና ናንጋ ጎዳ ቤርታ ፔቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ዓይጌንዴ ዎጌያ ማዖም ዳምቤ ዒንሢ ቢያሢም ሄኮ ማዻያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ‹ታ ዒንሢ ዔኪ ዓኣዻ ዓጮ ዒንሢ ጌሌ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ሳዔሎይዳፓ ጎሽኪ ዒንሢ ዴንቃ ባኮ ቢያ ዔኪ ዒንሢ ሙዓ ዎዶና ዬያይዳፓ ዔኪ ታኣም ዱማ ዒንጊሢ ማሂ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ዬይያ፦ ዓኮ ሃኣኮይዳፓ ላኣዲንታ ቤርታሳ ላኣዳ ታኣም ዒንጊንታያ ማዒ ሺኢኮንጎ፤ ዒንሢ ሺርካ ሃኣኮይዳፓ ዔኪ ሺኢሻ ዒንጊፆጉዴያ ዱማ ዒንጊሢ ማሂ ዬያ ሺኢሹዋቴ፤› ");
INSERT INTO mdyeth_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ሃጊ ሙካ ዎዶ ቢያይዳ ዓኮ ሃኣኮይዳፓ ዒንሢ ላኣዳ ዎዶና ቢያ ላኣዶይዳፓ ዔኪንቲ ዔኪንቲ ታኣም ዱማ ዒንጊሢ ማዒ ዒንጊንታንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«ጎዖንቴ ፔቴ ዓሲ ዔሩዋዖ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ዓይሢፆይዳፓ ፔቴ ፓጪሳያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ሃሣ ሴካ ቤርታ ዒንሢኮ ዜርፃ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ዓይሢፆ ቢያ ኩንሡዋያ ማዒ ፓጪሴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ዬያጉዴ ዻቢንቶ ዓሳ ዔሩዋዖ ማዼቴ ፔቴ ዎፓና ዔኪ ሙኪ ሳዋ ታና ዎዛሳ ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሾንጎ፤ ዬያና ዎላ ኮይሳያ ማዔ ሃኣኮ ዒንጊፆና ዎይኖ ዑዦ ዒንጊፆዋ ሺኢሾንጎ፤ ቃሲ ሃሣ ፔቴ ኮላይ ጎሞ ጌኤሻ ዒንጊሢ ማሂ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ዬያይዲ ቄኤሳሢ ዒስራዔኤሌ ዓሶኮ ጉቤ ጎሞ ጌኤሾንጎ፤ ዔያታ ዬያ ዻቤሢ ዔሩዋዖታሢሮ፥ ሃሣ ጎሞ ጌኤሺፆም ማዓንዳ ዒንጊፆና ሃኣኮ ዒንጊፆናም ማዓ ዒንጊፆ ናንጊና ናንጋ ጎዳም ዔያታ ዒንጌሢሮ ጎማ ዔያቶኮ ዓቶም ጌይንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ቢያሢ ፔቱሞና ዔሩዋዖ ዻቤያታሢሮ ጉቤ ዒስራዔኤሌ ዓሶና ዔያቶ ባኣካ ናንጋያ ማዔ ሙኬ ዓሶኮዋ ጎማ ዓቶም ጌይንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ፔቴ ዓሲ ዔሩዋ ጎሜ ማዼቴ ፔቴ ሌዔ ማዔ ማርማሪ ጎሞ ጌኤሻ ዒንጊሢ ማሂ ሺኢሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ዬካፓ ቄኤሳሢ ዻቢንቲ ማዼ ጎሞ ዓሢኮ ናንጊና ናንጋ ጎዳ ቤርቶ ሺኢሾንጎ፤ ጎማ ዒዛኮ ዓቶም ጌይንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ዓጫ ሾይንቴ ዒስራዔኤሌ ዓሲ ማዔቴያ ዔያቶ ባኣካ ናንጋ ሙኬ ዓሲ ዔሩዋዖ ጎሜ ማዼ ዓሲ ቢያ ኩንሣኒ ኮይሳ ዎጋ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","ጋዓንቴ ዓጫ ሾይንቴ ዒስራዔኤሌ ዓሲያ ማዖም ሙኬ ዓሲያ ቢያ ዔሬዖ ጎሜ ማዼቴ፥ ዬይ ማዻ ናንጊና ናንጋ ጎዳ ቦሂ ማዺንቴ ማዾታሢሮ ዴሮ ባኣካፓ ባይቆም፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ዬይ ባካ ዒዛ ሄላሢ፥ ናንጊና ናንጋ ጎዳ ኬኤዜ ባኮ ዒ ቦሄሢሮና ዓይሢንቴ ዓይሢፆፓ ዔሬዖ ፓጪሴሢሮኬ፤ ዬያሮ ዬይ ዓሢ ማሊ ባባይቆንጎ፤ ዬያ ዒ ፔጊዳ ዔኪ ዬዔያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ዒስራዔኤሌ ዓሳ ዓሲ ናንጉዋ ዳውሎይዳ ዓኣንቴ፥ ፔቴ ኬሊ ፔቴ ዓሲስኬይ ሃውሾ ኬሎና ሃንፂሌ ሃኣኪ ዓርቂንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ዒዛ ዓርቄ ዓሳ ዒዛ ዔኪ ዒስራዔኤሌ ዓሶንታ ሙሴንታ ዓኣሮኔያ ዓኣ ቤዞ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ዒዛ ዎዶንዶቴያ ጎይፃ ዔርቲባኣሢሮ ዻካ ዎዴ ዓሲ ዒዛ ካፓንዳጉዲ ዓይሢንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዓሢ ዎዺንታንዳያ ኮይሳኔ፤ ዒስራዔኤሌ ዴራ ቢያ ጉርዳፓ ዙሎ ኬሲ ሹቻ ዹይ ዒዛ ዎዾንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ዬያሮ ዓሳ ቢያ ዓሢ ጉርዳፓ ዙሎ ኬሲ፥ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ሹቻ ዹይ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«ዒስራዔኤሌ ዓሶም ሂዚ ጌዔ፤ ‹ዒንሢኮ ዓፒሎ ዓጮይዳ ዓጮይዳ ቢያ ሼኤሜ ዓጉዋቴ፤ ፔቴ ፔቴ ዓጮይዳ ዓጊንታሢ ጮልዔ ሼኤሜና ኮሾናያ ማዖንጎ፤ ዬያ ሙካ ዎዶ ቢያይዳ ካፒ ማዹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ዬይ ዓፒሎኮ ዓጫ ዹይንቴ ሼኤማ ጶቂሣ ባኣዚ ማዓንዳሢሮ ዬያ ዛጋ ዎዶና ቢያ ዒንሢ ታኣኮ ዓይሢፆ ማዺ ኩንሣያ ማዓንዳኔ፤ ታጊዳፓ ሃኪ፥ ዒንሢ ሼኔና ዒንሢ ሱኡኮ ዒንሢ ኩንሣያ ማዓዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ዒንሢኮ ዓፒሎ ዓጮይዳ ዒንሢ ዴንቃንዳ ሼኤማ ታኣኮ ዓይሢፆ ዒንሢ ኩንሣንዳጉዲ ዒንሢም ጶቂሣንዳኔ፤ ዒንሢያ ጉቤና ታኣም ዓይሢንቲ ዎርቃያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲኬ፤ ታ ዒንሢኮ ፆኦሲ ማዓኒ ጊብፄ ዓጫፓ ኬሴ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ሌዊ ማኣራፓ፥ ቄዓቴ ቶኦኪ ማዔ፥ ዪፅሃሬ ናኣዚ ቆራሄና ሮኦቤኤሌ ማኣራፓ ዔኤሊያቤ ናኣዚ ዳኣታኔና ዓብሮኔና፤ ሃሣ ፓሊቴ ናኣዚ ዖኔንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ዒስራዔኤሌ ዓሶ ባኣካ ዔርቴያ ዴሮ ዔኪ ዓኣዻንዳጉዲ ዶኦሪንቴ ላምዖ ፄኤታና ዶንጊንታሚ ዓሲንታ ዎላ ሙሴም ዋይዞ ዒፂ ማካያ ማዒ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ዔያታ ሙሴና ዓኣሮኔና ቤርቶ ሺኢኪ፦ «ዒንሢ ፔቶ ዑሣ ዓኣሤኔ! ሃይ ቡኬ ዓሳ ፔቴ ፔቴሢ ናንጊና ናንጋ ጎዳም ዱማዼያኬ፤ ናንጊና ናንጋ ጎዳ ኑኡና ዎላኣ ዓኣኔ፤ ሂዳዖ፥ ናንጊና ናንጋ ጎዳሮ ማዔ ዓሶ ዑፃ ዒንሢ ሌሊ ዒንሢ ዓይጎሮ ፑኡፒሳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ሙሴ ዬያ ዋይዛዖ ባሊቶና ሳዓ ሎኦሚ ሺኢቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ቆራሄና ዒዛና ዎላ ፔቴ ማዒ ዓኣ ዓሶም፦ «ዚሮ ጉቴ ናንጊና ናንጋ ጎዳ ዒዛም ዱማዼሢ ዖናታቴያ ዱማሲ ኑና ዻዋንዳኔ፤ ዒ ዎዎዳንዳይ ጌዔቴ ዒዛሮ ማዔሢና ዒዚ ዶኦሬ ዓሢ ዒዛም ሚቺ ዒንጎ ቤዞይዳ ዒዛ ኮይላ ሙኪ ማዻንዳጉዲ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ዚሮ ጉቴ ኔናንታ ኔኤና ዎላ ፔቴ ማዔ ዓሳ ቢያ ታሞ ጩቢሶ ዓንጎ ዔኪ ዬዑዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ዬያ ዓንጎይዳ ታሚ ቄንሢ ካኣሺ፥ ዑንጆጊዳ ዓጊ ሚቺ ዒንጎ ቤዞ ዔኪ ሺኢሹዋቴ፤ ዬካፓ ናንጊና ናንጋ ጎዳ ዖና ፔኤም ዱማሲ ዶኦሬቴያ ኑ ዛጋንዳኔ፤ ፔቶ ዑሣ ዓኣሤያ ማዔ ዓሳ ዒንሢ ሌዊ ዓሶኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ሙሴ ሃሣ ቆራሄ ኮይላ፦ «ዒንሢ ሌዊ ዓሳ ዋይዙዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ዒንሢ ዒዛ ቤርቶ ሺኢኪ ዒዚ ዴሮና ካኣማ ማኣሮይዳ ማዾ ማዻንዳጉዲ፤ ሃሣ ዒስራዔኤሌ ዴሮኮ ቤርታ ዔቂ ዒንሢ ማዻንዳጉዲ ሃንጎ ዒስራዔኤሌ ዓሶ ባኣካፓ ዒስራዔኤሌ ፆኦዛሢ ዒንሢ ዶኦሪ ዱማ ማሄሢ ዻካ ባኣዚ ማሂ ዒንሢ ዛጋ? ");
INSERT INTO mdyeth_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ዒዚ ዒንሢንታ ሜሌ ሌዊ ዓሶንታኮ ዬይ ቦንቻ ዓኣያ ማዓንዳጉዲ ማሄኔ፤ ሃሢ ዒንሢ ጋዓንቴ ቄኤሶ ቤዞዋ ዓርቃኒ ኮዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ዒንሢንታ ዒንሢና ዎላ ፔቴ ማዔ ዓሶንታ ዓኣሮኔ ዑፃ ጉንዱማ ባካ ናንጊና ናንጋ ጎዳ ዓይሣ ባኮ ዒፂ ዒዛ ዑፃ ጉንዱሚሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ዬካፓ ሙሴ ዔኤሊያቤ ናኣቶ ዳኣታኔና ዓቤሮኔና ኮይላ ዓሲ ዳኪ ዔያቶ ዔኤሊሳዛ፥ ዔያታ ጋዓንቴ፦ «ኑኡኒ ሙካዓ! ");
INSERT INTO mdyeth_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ሃይካ ዓሲ ናንጉዋ ዳውሎይዳ ኑ ሃይቃንዳጉዲ ኮዦ ዓጮ ጊብፄይዳፓ ኔ ኑና ኬሴሢ ዻካዛ፥ ሃሣ ጊንሣ ኑ ዑፃ ኔ ዋኣናዻኒ ኮዓ? ");
INSERT INTO mdyeth_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ማሊ ማዔ ዓጬሎ ኔ ኑና ዔኪ ዬይባኣሴ፤ ሃሣ ኑ ጎሺ ጎሽካንዳ ቤሲና ዔኤቢ ኑ ቱካንዳ ቤሲያ ኔ ኑም ዒንጊባኣሢ ዔርቴያኬ፤ ሃሣ ኔ ኑና ጌሻኒ ኮዓ? ኑ ኔ ኮይላ ሙኪያ ሙካዓኬ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ዬያሮ ሙሴ ሚርጌና ዻጋዻዖ ናንጊና ናንጋ ጎዳ ኮይላ፦ «ሃይ ዓሳ ኔኤም ዒንጋ ዒንጊፆ ዔኪፖ፤ ታኣኒ ዔያቶይዳፓ ፔቴ ዓሲምታዖ ፑርታ ማዺባኣሴ፤ ሜሌ ዓቴም ዔያቶኮ ሃሮይዳፓታዖ ታ ዔኪባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ዒማና ሙሴ ቆራሄም፦ «ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዚሮ ኔናንታ ላምዖ ፄኤታና ዶንጊታሚና ማዔ ኔ ዓሳ ዬዑዋቴ፤ ዓኣሮኔያ ዒኢካ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ዒንሢ ፔቴ ፔቴሢ ዒንሢኮ ታሞ ጩቢሶ ዓንጎ ዔኪ ዬይጋፓ ጊዳ ዑንጆ ዓጉዋቴ፤ ዬያይዴስካፓ ላምዖ ፄኤታና ዶንጊታሚና ማዓ ታሞ ጩቢሾ ዓንጎ ፆኦሲ ቤርቶ ዔኪ ሺኢሹዋቴ፤ ኔናንታ ዓኣሮኔንታ ጩቢሶ ዑንጆ ፆኦሲ ቤርቶ ሺኢሹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ዬያሮ ፔቴ ፔቴሢ፦ ታሞ ጩቢሾ ዓንጎይዳ ታሚ ቄንሢና ዑንጄና ዔኪ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ዔቄኔ፤ ሙሴና ዓኣሮኔናኣ ዔያቶና ዎላ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ዒማና ቆራሄ ዒዛና ዎላ ዓኣ ዓሶ ፔቴይዳ ቡኩሲ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ሙካዖ ሙሴና ዓኣሮኔናኮ ቤርቶ ዛላ ዔቄኔ፤ ናንጊና ናንጋ ጎዳኮ ቦንቾ ፖዓኣ ዴሮ ቢያሢም ፔጋዺ ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«ሃያ ዴሮ ኮይላፓ ዶጪ፥ ሃኪ ዔቁዋቴ፤ ታኣኒ ዔያቶ ፔቴና ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ዬያሮ ሙሴንታ ዓኣሮኔንታ ባሊቶና ሳዓ ላሃዖ፦ «ዔ ፆኦሲዮ! ዓሲም ቢያ ሼምፔ ዒንጋሢ ኔናኬ፤ ፔቴ ዓሲ ጎሜ ማዼሢሮ ጉቤ ዴሮይዳ ኔ ዻጋዻ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«ቆራሄና ዳኣታኔና ዓቤሮኔና ማኣሮ ኮይላፓ ዴራ ሺኢካንዳጉዲ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ዬካፓ ሙሴ ዒስራዔኤሌ ዓሶኮ ሱኡጎ ፔኤና ዔኪ ዳኣታኔና ዓቤሮኔና ኮይላ ዓኣዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ዴሮማኣ ዒ፦ «ሃያ ዓይሢንቶ ዒፃ ዓሶ ማኣሮ ኮይላፓ ዶጪ፥ ሃኪ ዔቁዋቴ፤ ዔያቶ ባኣዚ ማዔ ዓይጎ ሜሄያ ካኣሚፖቴ፤ ዒንሢ ካኣሜቴ ዔያታ ማዼ ጎሞ ዛሎና ዒንሢያ ቢያሢ ዔያቶና ዎላ ጋፓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ዬያሮ ዴራ ቆራሄና ዳኣታኔና ዓቤሮኔናኮ ማኣሮ ኮይላፓ ሺኢኬም፥ ዳኣታኔና ዓቤሮኔና ፔኤኮ ናኣቶንታ ላኣሎንታ ዎላ ፔ ማኣሮ ካራ ኬስኪ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ዒማና ሙሴ ዴሮም፦ «ሃያ ማዾ ቢያ ታ ማዻንዳጉዲ ፆኦሲ ታና ዳኬያ ማዔሢ ዒንሢ ዔራንዳሢ፤ ሃሣ ታኣኒ ሃያ ማዻሢ ታ ሼኔናቱዋታሢያ ዒንሢ ዔራንዳሢ ሃያ ዛጊኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ሃይ ዓሳ ፆኦሲዳፓ ማዔ ፑርታ ባኣዚ ዔያቶ ሄሊባኣንቴ ዓሲ ሃይቃ ጎይሢ ሃይቄቴ ታና ናንጊና ናንጋ ጎዳ ዳኬያቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ጋዓንቴ ናንጊና ናንጋ ጎዳ ዋይዚንቲ ቤቂባኣ፥ ዓኪ ባኣዚ ማዺ ሼምፔና ዔያታ ዓኣ ጎይሣ ዓኣዖ ሃይቄ ዓሲ ጎይሢ ዱኡኪንታንዳጉዲ ሳዓ ዳርዒ ዔያቶንታ ዔያቶሮ ማዔ ባኮ ቢያ ዔኤዼቶ፥ ሃይ ዓሳ ናንጊና ናንጋ ጎዳም ዓይሢንቶ ዒፄያ ማዔሢ ዒንሢ ዔራንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ሙሴ ዬማ ጌዒ ጋጋፓማና ዳኣታኔና ዓቤሮኔና ዔቂ ዓኣ ሳዓ ዳርዒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ዔያቶንታ ዔያቶኮ ማኣሮ ዓሶንታ፤ ሃሣ ቆራሄና ፔቴ ማዔ ዓሶንታ ዔያቶኮ ዓኣ ባኮዋ ቢያ ዔኤዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ዬያሮ ዔያታ ሼምፔና ዓኣ ጎይሣ ዓኣዖ ዔያቶኮ ዓኣ ባኮና ዎላ ሃይቄ ዓሲጉዲ ዱኡቴኔ፤ ሳዓ ጊንሣ ዎላ ካኣሜም ዔያታ ዱኡኪንቲ ባይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ዒማና ዒኢካ ዓኣ ዒስራዔኤሌ ዓሳ ቢያ ዬያ ዴሮኮ ዒላቶ ዋይዛዖ ጳሽኬኔ፤ «ሳዓ ኑናኣ ዔኤዻኒ ዳንዳዓሢሮ ኑ ጳሽኮም!» ጌይ ጌይ ዔያታኣ ዒላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ዬካፓ ናንጊና ናንጋ ጎዳ ፔ ኮይላፓ ታሚ ኬይሴም ዑንጆ ጩቢሳ፥ ላምዖ ፄኤታና ዶንጊታሞ ዓሶ ሙዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ያዺ ማዔስካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«ዓኣሮኔ ናኣዚ ዓላዜሬ ሞኦኖ ዓንጎ ዹይ ኮሺንቴ፥ ታሞ ጩቢሶ ባኮ ታሞና ሙይንቴ ዓሶፓ ዔኪ ታሞ ጩቢሶ ዓንጋ ታኣም ዱማዼያታሢሮ ጊዳ ዓኣ ዲቢንፆ ሜሌ ቤስካ ላኣላንዳጉዲ ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ዬይ ታሞ ጩቢሶ ዓንጋ ታኣም ዱማዼሢ ሚቺ ዒንጎ ቤዞ ሺኢኬ ዎዶናኬ፤ ዬያሮ ዔያታ ማዼ ጎሞ ዛሎና ሃይቄ ዬኖ ዓሶኮ ታሞ ጩቢሶ ዓንጎ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጉኡፓ ማዓንዳጉዲ ዹይ ሻኣዣሴ፤ ዬይ ዒስራዔኤሌ ዴሮ ሜታ ሄሉዋጉዲ ‹ዒንሢና ዔሩዋቴ› ጌይሢም ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ዬያሮ ዓላዜሬ ታሞ ጩቢሶ ዓንጎ ዔኪ ሚቺ ዒንጎ ቤዞኮ ጉኡፓ ማዓንዳጉዲ ሻኣዣሲ ዹዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ዬያ ዒ ማዺ ጋፒሴሢ ፆኦሲ ሙሴ ዛሎና ዒዛ ዓይሤ ጎይፆኬ፤ ዬይ ማዺንቴ ባካ ዓኣሮኔ ፃጲ ማዒባኣ፥ ዓይጎ ዓሲያ ናንጊና ናንጋ ጎዳም ዑንጆ ጩቢሳኒ ሚቺ ዒንጎ ቤዞ ባንሢ ዑካኒ ኮይሱዋያታሢ ዒስራዔኤሌ ዓሶም ቢያ ዒንሢና ዔሩዋቴ ጌይሢም ማዓንዳኔ፤ ዬያ ዓሳ ዔሪባኣያታቴ ዬያጉዴ ማዾ ማዻ ዓሲ ቢያ ቆራሄና ዒዛና ፔቴ ማዔ ዓሶጉዲ ባይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ዚሮ ጉቴሎ ዒስራዔኤሌ ዴራ ጉቤ፦ «ናንጊና ናንጋ ጎዳ ዴሬ ማዔ ዓሶ ዒንሢ ዎዼኔ» ጌዒ ሙሴና ዓኣሮኔና ዑፃ ጉንዱሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ሙሴና ዓኣሮኔና ማዼ ባኮ ማኪ ጌስታኒ ቢያሢ ፔቱሞና ቡኪንቴስካፓ ፆኦሲ ዴሮና ካኣማ ማኣሮ ባንሢ ሺሪ ዛጋንቴ ናንጊና ናንጋ ጎዳኮ ሻኣራ ዒዚ ዴሮና ካኣማ ማኣሮ ካንቄም ናንጊና ናንጋ ጎዳኮ ቦንቻ ዔያቶም ፔጋዺ ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ዬካፓ ሙሴንታ ዓኣሮኔንታ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቤርቶ ዛላ ሙኪ ዔቃዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«ሃያ ዴሮ ኮይላፓ ሺኢኪ ዔቁዋቴ፤ ታኣኒ ዔያቶ ፔቴና ባይዛንዳኔ!» ጌዔኔ፤ ዒማና ዬያታ ላምዓሢ ባሊቶና ሳዓ ላሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ሙሴ ዓኣሮኔ ኮይላ፦ «ኔኤኮ ታሞ ጩቢሶ ዓንጎ ዔኪ ሚቺ ዒንጎ ቤዛፓ ታሚ ቄንሢ ካኣሺ፥ ጊዳ ዑንጄ ዓጌ፤ ዬያይዴስካፓ ዴሮ ባንሢ ዑኬና ዓኣዺ ዓሶኮ ጎሞ ፆኦሲ ዓቶም ጋዓንዳጉዲ ጩቢሼ፤ ሩኡሬ! ሃይሾ ናንጊና ናንጋ ጎዳኮ ዻጋ ዓሶይዳ ሙኬም ዴሮ ኩርሳንዳ ፑርታ ሃርጌ ጌሌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ዓኣሮኔ ዬያ ዋይዚ ታሞ ጩቢሾ ዓንጎ ዔካዖ ቡኪ ዓኣ ዴሮኮ ባኣኮ ሩኡሪ ዓኣዺ፥ ፑርቶ ሃርጋ ጌሌሢ ዛጌ ዎዶና ታሞ ቄንፆይዳ ዑንጆ ዓጊ ዴሮኮ ጎሞ ፆኦሲ ዓቶም ጋዓንዳጉዲ ጩቢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ዬያይዲ ፑርቶ ሃርጋ ዴሮ ኩርሱዋንቴ ሃሺሴኔ፤ ዓኣሮኔ ዒማና ሃይቄ ዓሶና ሼምፖና ዓኣ ዓሶናኮ ባኣካ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ዒማና ሃይቄ ዓሶኮ ፓይዳ ቆራሄና ዎላ ዓይሢንቶ ዒፂ ኩዴ ዓሶ ቃሱዎንቴ ታጶ ዖይዶ ሺያና ላንካይ ፄኤታ ዓሲ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ዬይ ፑርቶ ሃርጋ ዔቄስካፓ ዓኣሮኔ ሙሴ ኮይላ ማዒ ዓኣዼኔ፤ ዒማና ሙሴ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«ዒስራዔኤሌ ዓሳ ፔቴ ፔቴ ቶይዶ ማኣራፓ ኮኦሎ ኮኦሎ ዔኪ ታጶ ላምዖ ኮኦሎ ኔኤም ዒንጋንዳጉዲ ዖኦጬ፤ ዬያ ኮኦሎ ዑፃ ፔቴ ፔቴሢኮ ሱንፆ ፃኣፔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ሌዊ ማኣሮ ዛሎና ዒንጊንቴ ኮኦሎ ዑፃ ዓኣሮኔ ሱንፆ ፃኣፔ፤ ፔቴ ፔቴ ቶይዶ ማኣሮኮ ሱኡጎ ዛሎና ፔቴ ፔቴ ኮኦሎ ሺኢኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ዬያ ኮኦሎ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሪ ዔኪ ዓኣዺ ታ ኔኤና ጌስታ ጫኣቁሞ ሳኣፂኖኮ ቤርቶ ዛላ ጌሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ዬካፓ ታኣኒ ቄኤሴ ማዓንዳጉዲ ዶኦሬ ዓሢኮ ኮኦላ ቶሺ ዋርቃንዳኔ፤ ዬያይዲ ሃይ ዒስራዔኤሌ ዴራ ቢያ ዎዴ ኔጊዳ ጉንዱማ ጉንዱማሢ ዔያቶ ታ ሃሺሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ዬያሮ ሙሴ ዬያ ዒስራዔኤሌ ዓሶም ኬኤዜም ፔቴ ፔቴ ሱኡጋ ፔኤኮ ኮኦሎ ዔኪ ሙኪ ዒዛም ዒንጌኔ፤ ፔቴ ፔቴ ቶይዶ ማኣራፓ ሱኡጎ ዛሎና ዒንጊንቴ ኮኦላ ዎሊ ዑፃ ታጶ ላምዖ ማዔኔ፤ ዬያ ኮኦሎ ባኣካ ዓኣሮኔ ኮኦላ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ሙሴ ዬያ ኮኦሎ ዔኪ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ጫኣቁሞ ሳኣፂኖኮ ቤርቶ ዛላ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ዚሮ ጉቴሎ ፆኦሲ ዴሮና ካኣማ ማኣሮ ሙሴ ጌላዖ ሌዊ ማኣሮ ዛሎና ዒንጊንቴ ኮኦሌላ ቶሺ ዓኣንቴ ዴንቄኔ፤ ዬያ ሌሊቱዋንቴ ፂሊ ኬሲ ቡናዖ ሌውዜ ዓኣፒ ዓኣፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ዒማና ሙሴ ኮኦሎ ቢያ ዔኪ ሙኪ ዒስራዔኤሌ ዓሶም ዻዋዛ፥ ዬያ ማዔ ባኮ ቢያ ዛጌስካፓ ፔቴ ፔቴ ሱኡጋ ፔ ኮኦሎ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ጫኣቁሞ ሳኣፂኖኮ ቤርቶ ዛላ ዓኣሮኔ ኮኦሎ ጊንሣ ጌሤ፤ ዋይዞ ዒፃ ዒስራዔኤሌ ዓሳ ታጊዳ ጉንዱሚፆ ሃሺባኣያታቴ ሃይቃንዳሢ ዬይ ዔርዛያ ማዒ ዴዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ሙሴ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ዬካፓ ዒስራዔኤሌ ዴራ ሙሴ ኮይላ፦ «ያዺ ማዔቴ ኑ ቢያሢ ኩዴኔ ጌይሢኬ! ");
INSERT INTO mdyeth_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ባንሢ ዑኬሢ ሃይቃያ ማዔቴ ኑኡኒ ቢያሢ ጋፓንዳኔ ጌይሢዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ናንጊና ናንጋ ጎዳ ዓኣሮኔም፦ «ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዺንታ ማዾ ዛሎና ዻቢንታ ባኣዚኮ ዖኦጪንታንዳሢ ኔናንታ ኔ ናኣቶንታ ሌዊ ዓሶንታኬ፤ ቄኤሳ ማዻ ማዾ ዛሎና ዻቢንታ ባኣዚኮ ባሼ ዖኦጪንታንዳሢ ኔኤና ኔ ናኣቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ኔናንታ ኔ ናኣቶንታ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዻ ዎዶና ዒንሢ ማዺ ማኣዳንዳጉዲ ሌዊ ዓሶ ማዔ፥ ኔ ፃጳፓ ዓሲ ዔኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ዔያታ ዒንሢ ማኣዲ ማኣዲ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዓኣ ባኮ ዛጊ ካፓያ ማዖንጎ፤ ያዺ ማዔቴያ ታኣም ዱማዼ ቤዞና ሚቺ ዒንጎ ቤዞናይዳ ዓኣ ጌኤዦ ባኮ ዔያታ ካኣማንዳያ ኮይሱዋሴ፤ ዔያታ ካኣሜቴ፦ ዔያቶንታ ዒንሢንታ ቢያ ሃይቃንዳኣኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ዔያታ ቢያ ዎዴ ዒንሢና ዎላ ማዺ ማዺ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዻንዳጉዲ ጌይንቴ ባኮ ቢያ ማዺ ኩንሣንዳያ ኮይሳኔ፤ ጋዓንቴ ሌዊ ዓሲ ማዒባኣ፥ ዓይጎ ዓሲያ ማዖም ዒንሢና ዎላ ማዻኒ ሙካንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ታኣኮ ዻጋ ዒስራዔኤሌ ዓሶይዳ ላሚ ሙኩዋጉዲ ታኣም ዱማዼ ቤዞና ሚቺ ዒንጎ ቤዞናይዳ ማዺንታ ማዾኮ ዋኣናዺ ማዻንዳ ዓሳ ኔኤና ኔ ናኣቶና ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ዒንሢ ፃጶ ማዔ ሌዊ ዓሶ ዒስራዔኤሌ ዓሶ ባኣካፓ ዶኦሪ ዒንሢም ዒንጌሢ ታናኬ፤ ዔያታ ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ማዻንዳጉዲ ጌይንቴ ማዾ ማዻኒ ታኣም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ጋዓንቴ ሚቺ ዒንጎ ቤዞና ጎኦቦ ዓፒሎኮ ጋሮ ዛሎና ዓኣ ዑሣ ዓኣዼ ዱማዼ ቤዛ ቄኤሳ ማዻ ማዾ ማዻንዳሢ ኔኤና ኔ ናኣቶና ሌሊኬ፤ ቄኤሴ ማዒ ማዾ ማዾ ዒንሢ ዛላ ማሂ ታ ዒንሢም ዒንጌሢሮ ዬይ ማዻ ዒንሢሮኬ፤ ቄኤሴ ማዒባኣ ዓይጎ ዓሲያ ማዖም ዬኖ ቤዞ ባንሢ ዑኬቴ ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ዬካፓ ናንጊና ናንጋ ጎዳ ዓኣሮኔም፦ «ታኣም ዒንጊንታ፥ ሚቺንቱዋ ዱማ ዒንጊፆ ቢያ ኔኤም ታ ዒንጌያ ማዔሢ ዔሬ፤ ዬይ፦ ናንጊና ኔኤና ኔ ዜርፆና ዛላ ማዓንዳጉዲ ታ ዒንሢም ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ታኣም ዒንጊንታ ሚርጌና ዱማዼ ዒንጊፃፓ ቢያ፥ ሃኣኮ ዒንጊፃፓ፥ ጎሜ ጌኤሻኒ ዒንጎ ዒንጊፆንታ ዻቢንቲ ዛላ ጪጋ ማሂ ዒንጎ ዒንጊፃፓኣ ቢያ ታሚና ሚቺንቱዋ ባካ ቢያ ኔኤና ኔ ናኣቶና ዛላኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ታኣም ዱማዼ ቤዛ ማዒ ዬያ ቢያ ሙዑዋቴ፤ ዬይ ታኣም ዱማዼያኬ፤ ዓቲንቃ ሌሊ ሙዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ሃሣ ዒስራዔኤሌ ዓሳ ታ ቤርቶይዳ ሌካ ሊካ ዡጊ ዒንጋ፥ ዱማ ዒንጊፃ ቢያ ዒንሢሮኬ፤ ዬያ ባኮ፦ ኔናንታ ኔኤኮ ዓቲንቆ ናኣቶንታ ዉዱሮ ናኣቶንታም ሙካ ዎዶ ቢያይዳ ዒንሢሮ ማሂ ታ ዒንጌኔ፤ ዳምቦ ጎይፆና ጌኤሺ ማዔ፥ ዓይጎ ዓሲታቴያ ኔ ማኣሪ ዓሲ ማዔይ ዬያ ሙዓኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ዒስራዔኤሌ ዓሳ ታኣም ዒንጋ ኮዦ ኮዦ ባኮኮ ቤርቶ ጌይፃ፦ ሪሚቶ ዛይቶንታ ዎይኖ ዑዦንታ ሃኣኮንታ ታ ዒንሢም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ሳዓ ዔያቶም ዒንጌ ዓንጆይዳፓ ታኣም ዔያታ ዔኪ ሙካ ቤርታ ቢያ ኔ ዛላ ማዓንዳሢሮ ዳምቦ ጎይፆና ጌኤሺ ማዔ፥ ኔ ማኣሪ ዓሲ ቢያ ሙዓኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ዒስራዔኤሌ ዓሳ ታኣም ጉቤና ዱማሲ ዒንጌ ባኣዚ ቢያ ኔኤሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ዒስራዔኤሌ ዓሳ ታኣም ዒንጋ፥ ዓሲኮዋ ማዖም ቆልሞኮዋ ቤርቲ ሾይንቲ ቢያ ኔኤሮኬ፤ ጋዓንቴ ዓሲኮ ቶይዲ ናይ ዛላ ሚኢሼ ዔኩዋቴ፤ ዬያጉዲ ዳምቦ ጎይፆና ሙይንታኒ ዳንዳዑዋ ቆልሞ ናኣቶ ዛሎዋ ሚኢሼ ዔካኒ ዒንሢ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ሾይንቴንቴ ፔቴ ዓጊኒ ኩሜ ናይ ዛላ ዒንጊንቶም ጌይንቴ ጎይፆጉዴያ ጌኤዦ ማኣራ ሚኢሾ ዴኤሡሞ ዔሮ ባኮና ዶንጊታሚ ጊራኣሜ ማዓ ሹቺ ቢራ ዔካኒ ኔ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ባይኮ፥ ማራይኮ፥ ዋኣሪኮዋ ቤርቲ ናይ ሚኢሼና ሻንቂ ማሂ ዔኪንቶፓ፤ ዬያታ ጉቤና ታኣሮ ማዔሢሮ ታኣም ሚቺ ዒንጎያ ማዓኒ ኮይሳኔ፤ ዬያቶኮ ሱጉፆ ሚቺ ዒንጎ ቤዞኮ ዴማ ላኣሉዋቴ፤ ሳዋ ታና ዎዛሳያ ማዓንዳጉዲ ማሎ ታሚና ሚቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ዬያቶኮ ዓሽካ ዡጊ ታኣም ዒንጎ ዱማ ዒንጊሢ ማዒ ዒንጊንታ፥ ዚኢሮና ሚዛቆ ላባዎናጉዲ ዒንሢም ዒንጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ዒስራዔኤሌ ዓሳ ታኣም ዒንጋ ዱማ ዒንጊፆ ቢያ ዒንሢም፤ ሃሣ ዒንሢኮ ዓቲንቆና ዉዱሮ ናኣቶናም ሙካ ዎዶ ቢያይዳ ዒንሢሮ ማሂ ታ ዒንጌኔ፤ ዬይ ዒንሢና ዒንሢኮ ዜርፆና ዎላ ታ ጫኣቃ፥ ላኣሚንቱዋ ሶኦጌ ጫኣቁሞኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ናንጊና ናንጋ ጎዳ ዓኣሮኔም፦ «ኔ ዜርፆ ኔ ዻካልሳ ባኣዚ ፔቴታዖ ዔኪፖ፤ ዒስራዔኤሌይዳ ዓኣ ሳዖይዳፓ ኔኤም ማዓ ሳዓ ባኣያ ናንጎም፤ ዬይ ቢያ ኔኤኮ ታናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ናንጊና ናንጋ ጎዳ ዓኣሮኔም፦ «ዒስራዔኤሌ ዴራ ዔያቶኮ ዓኣ ታጶ ባኣዚፓ ፔቴማ ታኣም ዔኪ ሙካሢ ቢያ ሌዊ ዓሶ ዛላ ማዓንዳጉዲ ታ ዒንጌኔ፤ ዬይ፦ ታኣኒ ዒንሢና ካኣማ ማኣሮይዳ ዔያታ ማዻ ማዾ ዛሎ ዒንጊንታያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ሃንጎ ዒስራዔኤሌ ዓሳ ፔጊዳ ሃይቢ ዔኪ ዬዑዋጉዲ ሃካፓ ሴካ ታኣኒ ዒንሢና ካኣማ ማኣሮ ባንሢ ዑኮፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ፆኦሲ ዴሮና ካኣማ ማኣሮ ሃካፓ ሴካ ዛጊ ካፓንዳሢንታ ዬያ ባኮኮ ዋኣና ማዒ ቆላንዳሢ ሌዊ ዓሶ ሌሊኬ፤ ዬይ ዒንሢኮ ዜርፆም ማዺ ማዺ ናንጋያ ላኣሚንቱዋ ዎጌ ማዓንዳኔ፤ ሌዊ ዓሶኮ ዔያቶሮ ማዒ ናንጋንዳ ባኣዚ ዒስራዔኤሌ ዓጮይዳ ባኣያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ዒስራዔኤሌ ዓሳ ዱማ ዒንጊሢ ማሂ ፔኤኮ ዓኣ ታጶ ባኣዚፓ ፔቴማ ዔኪ ሙካሢ ዔያቶሮ ማዓንዳጉዲ ታ ዓይሤኔ፤ ዒስራዔኤሌ ዓጮይዳ ዔያቶሮ ማዒ ናንጋንዳ ባኣዚ ባኣያ ማዓንዳሢ ሌዊ ዓሶም ታኣኒ ኬኤዜኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«ሌዊ ዓሶም ሂዚ ጌዔ፤ ‹ናንጊና ናንጋ ጎዳ ዒንሢሮ ማሂ ዒንጋ፥ ታጶ ባኣዚፓ ፔቴማ ዒስራዔኤሌ ዓሶፓ ዒንሢ ዔካ ዎዶና ዒንሢያ ዬያ ዔኬ ባኮይዳፓ ታጳፓ ፔቴማ ኬሲ ታኣም ዱማ ዒንጊሢ ማሂ ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ዬይ ዒንሢ ዒንጋ ዒንጊፃ ፔቴ ጎሺ ጎሽካ ዓሲ ካፄ ሃኣኮይዳፓ ዔኪ፤ ጊንሣ ሃሣ ዎይኖ ዑዦኮዋ ታጳፓ ፔቴማ ኬሲ ዒንጋሢጉዴያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ዒስራዔኤሌ ዓሳ ታጳፓ ፔቴማ ኬሲ ዒንጋሢፓ ዒንሢያ ታኣም ማዓ ዱማ ዒንጊሢ ዬያይዲ ዒንጉዋቴ፤ ታኣም ዒንሢ ዔኪ ሙካ፥ ዬያ ዱማ ዒንጊፆ ቄኤሳሢ ዓኣሮኔም ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ታኣም ዒንሢ ዒንጋንዳሢ ዒንሢ ዔካ ባኮይዳፓ ቢያ ቃራ ማዔ ባኣዚ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ዬያ ቃራ ማዔ ባኮ ዒንሢ ዒንጋ ዎዶና ፔቴ ጎሺ ጎሽካ ዓሲ ታኣም ዒንጎ ባኮ ዒንጋዖ ዓቴሢ ፔኤም ማሃሢጉዲ ዒንሢያ ዒንሢም ዓይሱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዒንሢ ማዻ ማዾኮ ላቢፆ ዛሎ ዬይ ማዓያታሢሮ ዓቴ ባኮ ዒንሢና ዒንሢኮ ማኣሮ ዓሶና ዓይጎ ቤሲዳኣ ማዖም ሙዓኒ ዒንሢ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ቃራ ቃራ ማዔ ባኮ ዒንሢ ታኣም ዒንጌስካፓ ዬያ ዓቴሢ ሙዒፃ ዒንሢኮ ዻቢንቲ ማዑዋሴ፤ ጋዓንቴ ቃሮ ባኮ ጊዳፓ ዱማሲ ዒንጉዋዖ ዬያ ዒንጊንቴ ባካፓ ዔኪ ሙዒ፥ ዒስራዔኤሌ ዓሳ ታኣም ዱማሲ ዒንጌ ዒንጊፆ ዒንሢ ዒኢሱዋጉዲ ዒንሢና ዔሩዋቴ፤ ዬያ ዒንሢ ማዼቴ ሃይቃንዳኣኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«ሃይ ታኣኒ ዓይሤ ዳምቤኬ፤ ቦሂሳ ባኣዚ ባኣያ፥ ባቃኖይዳ ቃምባራ ጌሢ ዛጊቦኦ ፔቴ ዞቄ ማሮ ዔኪ ዬዓንዳጉዲ ዒስራዔኤሌ ዓሶም ኬኤዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ማሬሎ ዔኪ ሙካዖ ቄኤሳሢ ዓላዜሬም ዒንጉዋቴ፤ ዬና ማሬላ ጉርዳፓ ዙሎ ኬስኪ ዓላዜሬ ዓኣ ቤስካ ሹኪንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ዓላዜሬ ዬያ ሱጉፆፓ ዻካ ዔኪ፥ ፔ ኬኤሎ ጊዳ ዳኪ ዳኪ ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ቤርቶ ዛሎና ላንካይ ማይንቲ ዉፁርቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ማሬላ ጉቤ፤ ጌይፃ፦ ዜዻ፥ ዓሽካ፥ ሱጉፃ፥ ጎጶ ባካኣ ቢያ ቄኤሳሢ ዓኣ ቤዞይዳ ታሚና ሚቺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ዒማና ቄኤሳሢ ዴኤሊ ዚቢቂ ሜሌያንታ ሂሶጴ ጌይንታ ባኬሎኮ ካኣፒንታ ዞቄ ፓቲሌያኣ ዔኪ ማሬሎ ሚቾ ታሞይዳ ዓጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ዬካፓ ዒ ዓፒሎ ፔኤኮ ማስኪ፥ ዑፆዋ ማስቲ ጉርዶ ማዒ ጌሎንጎ፤ ጋዓንቴ ሳዓ ዓማንዳያ ሄላንዳኣና ዳምቦ ጎይፆና ዒዚ ዒኢቴያ ማዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ማሬሎ ታሞና ሚቼ ዓሢ ፔኤኮ ዓፒሎንታ ዑፆንታ ዋኣሢና ማስኮንጎ፤ ዒዚያ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዒ ዴዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ዬካፓ ዳምቦ ጎይፆና ጌኤሺ ማዔ፥ ሜሌ ዓሲ ማሬሎኮ ዲቢንፆ ቡኩሲ ዔኪ ጉርዶኮ ዙላ ካኣዦ ዳምቦ ጎይፆና ጌኤሺ ማዔ ቤዞይዳ ፔቴ ቤስካ ዋሆንጎ፤ ዬይ ዲቢንፃ ዒስራዔኤሌ ዴሮኮ ጎሜ ጌኤሻያ ማዔ፥ ዋኣፆ ጊኢጊሻኒ ዔኪንታያ ማዓንዳኔ፤ ዬይ ዳምባ ጎሞ ጌኤሻኒ ማዺንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ዬኖ ዲቢንፆ ቡኩሴ ዓሢ ዓፒሎ ፔኤኮ ማስኮንጎ፤ ጋዓንቴ ሳዓ ዓማንዳያ ሄላንዳኣና ዒ ዒኢቴያ ማዒ ዴዓንዳኔ፤ ዬይ ዳምባ ዒስራዔኤሌ ዓሶና ዔያቶ ባኣካ ሙኬያ ማዒ ናንጋ ዓሶም ሙካ ዎዶ ቢያይዳ ማዻያ ማዒ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ዓይጎ ዓሲኮዋ ማዖም ሌሲ ካኣሜሢ ዳምቦ ጎይፆና ላንካይ ኬሊ ሄላንዳኣና ዒኢቴያ ማዒ ዴዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ሃይሣሳ ኬሎና ላንካሳ ኬሎናይዳ ጎሞ ጌኤሺፆሮ ጌሢንቴ ዋኣፆና ፔና ዒ ጌኤሾንጎ፤ ዬካፓ ዒ ጌኤሺ ማዓንዳኔ፤ ሃይሣሳ ኬሎና ላንካሳ ኬሎናይዳ ፔና ዒ ጌኤሺባኣያ ማዔቴ ጌኤሺ ማዓኒ ዒዚ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ጎሞ ጌኤሺፆ ዋኣፃ ዑፆይዳ ዋሂንቲባኣሢሮ ሌሲ ካኣሚ ዒኢቴ ዓሲ ዒኢቴያ ማዒ ዴዴዓንዳኔ፤ ዬያጉዴ ዓሲ ፆኦሲ ዴሮ ካኣማ ማኣሮ ዒኢሳኔ፤ ዬያሮ ዒስራዔኤሌ ዴሮ ባኣካ ማዒ ፓይዲንታኒ ዒዛም ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«ፔቴ ዓሲ ፔኤኮ ናንጋ ማኣሮይዳ ሃይቄቴ ማዺንታንዳ ዳምባ ያዺኬ፦ ዬይ ዓሢ ሃይቃኣና ዬኖ ማኣሮይዳ ዓኣ ዓሲ፤ ሃሣ ዬኖ ማኣሮ ዒማና ጌሌ ዓሲ ላንካይ ኬሊ ሄላንዳኣና ዒኢቴያ ማዒ ዴዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ዬኖ ማኣሬሎይዳ ዓኣ፥ ካራ ዎዺንቲባኣ ሜሄ፤ ጌይፃ፦ ዖቲታቴያ ጉሲ ዒኢቴያ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ዓሲ ዎዼ ዓሲኮ ሌሲያኣ ማዖም ሃርጊ ሃይቄ ዓሲኮ ሌሲ ዞኦስካ ካኣማ ዓሲ፤ ጊንሣ ሃሣ ዓሲኮ ሜጌሢታቴያ ዱኡፒ ካኣሜ ዓሲ ላንካይ ኬሊ ሄላንዳኣና ዒኢቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«ዬያ ጎሞ ጌኤሻኒ ጎሞ ጌኤሺፆሮ ማዓንዳጉዲ ሚቺንቴ ማሬሎ ዲቢንፃፓ ዻካ ዔኪ ዖቲዳ ዋሂጋፓ ጊዳ ዓልቃ ቤሲዳፓ ዱይንቴ ጌኤሺ ዋኣሢ ዋሂንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ዬካፓ ዳምቦ ጎይፆና ጌኤሺ ማዔ ዓሲ ሂሶጴኮ ካኣፒ ዔኪ ዋኣፆይዳ ዳኪ ዳኪ ፆኦሲ ዴሮና ካኣማ ማኣሮይዳ ዓኣ ሜሆ ዑፆይዳ ቢያ፤ ጊንሣ ሃሣ ዬያ ማኣሮይዳ ዓኣ ዓሶ ዑፃኣ ዉፁርቆንጎ፤ ዬይ ዓሢ ዓሲ ሜጌሢንታ ሌሲንታ ዱኡፒያኣ ካኣሚ ዒኢቴ ዓሶ ዑፃ ዉፁርቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ሃይሣሳ ኬሎና ላንካሳ ኬሎናይዳ ፔና ዳምቦ ጎይፆ ጌኤሼ ዓሢ ሜሌ ጌኤሽኪባኣሢ ዉፁርቆንጎ፤ ላንካሳ ኬሎና ዬያ ዓሢ ጌኤሾንጎ፤ ዬይ ጌኤሽካ ዓሢያ ፔኤኮ ዑፆንታ ማኣዓሢንታ ማስኬስካፓ ዓባ ጌላዛ ዒ ጌኤሽኬያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«ዳምቦ ጎይፆና ፔና ጌኤሺባኣ ዒኢቴ ዓሢ ጎሞ ጌኤሻ ዋኣፃ ዒዛኮ ዑፃ ዋሂንቲባኣሢሮ ዒኢቴያ ማዒ ዴዓንዳኔ፤ ዬያጉዴ ዓሲ ፆኦሲኮ ማኣሮ ዒኢሳያ ማዔሢሮ ዴሮ ባኣካፓ ዱማዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ሃያ ዎጎ ኬስካ ዎዶ ቢያይዳ ዒንሢ ካፓንዳያ ኮይሳኔ፤ ጎሞ ጌኤሺፆሮ ዋሆ ዋኣፆ ዓሶ ዑፆይዳ ዋሃሢ ፔኤኮ ማኣዓሢ ማስካንዳያ ኮይሳኔ፤ ዬያ ዋኣፆ ካኣማ ዓሲ ቢያ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዒ ዴዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ዬይ ዒኢቴ ዓሢ ካኣማ ባኣዚ ቢያ ዒኢቴያ ማዓንዳኔ፤ ዬያ ባኮ ካኣሜ ዓሲያ ሳዓ ዓማንዳያ ሄላንዳኣና ዒኢቴያ ማዒ ዴዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ቤርታሳ ዓጊኖና ዒስራዔኤሌ ዴራ ጉቤ ዓሲ ናንጉዋ ፂኔ ዳውሎ ሙኪ ቃዴሴ ጌይንታ ቤዛ ዱንኪ ዴዔኔ፤ ዒማና ማይራማ ዒኢካ ሃይቂ ዱኡቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ዔያታ ዴዔ ቤዞይዳ ዋኣሢ ባኣያታሢሮ ዴራ ሙሴና ዓኣሮኔና ዒፂ ማካያ ማዒ ቡካዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","«ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ሃንጎ ኑ ዒጊኖ ዒስራዔኤሌ ዓሶና ዎላ ኑ ሃሃይቄቴ ዎንዴ ቃራታዖ ዓቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ሃያ ዓሲ ናንጉዋ ዳውሎ ኑና፥ ፆኦሲ ዴሮ ዓይጋ ዒንሢ ዔኪ ሙኬይ? ኑናንታ ኑ ቆልሞንታ ኩዳንዳጉዲዳ? ");
INSERT INTO mdyeth_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ጊብፄይዳፓ ኑና ዒንሢ ኬሲ፥ ፔቴታዖ ዔኤቢ ባቃሉዋ ሃያ ፑርቶ ዓጮ ዓይጋ ዔኪ ዬዔይ? ሃይካ፦ ሃኣኮ፥ ቤሌሴ፥ ዎይኔንታ ሮኦማኣኔ ጎዖ ሙዎ ሚፃኣ ባኣሴ፤ ሜሌ ዓታዛ ዑሽኮ ዋኣሢታዖ ሃካ ባኣሴ!» ጌዒ ሙሴ ዑፃ ዻጋና ዒላቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ዬያሮ ሙሴና ዓኣሮኔና ዴሮ ኮይላፓ ዴንዲ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ባሊቶና ሳዓ ላሂ ዓኣንቴ ናንጊና ናንጋ ጎዳኮ ቦንቾ ፖዓ ፔጋዺ ዔያቶም ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ዬካፓ ናንጊና ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«ጫኣቁሞ ሳኣፂኖኮ ቤርቶ ዛላ ዓኣ ኮኦሌሎ ዔኪጋፓ ኔኤና ዓኣሮኔና ዒስራዔኤሌ ዴሮ ፔቴይዳ ቡኩሱዋቴ፤ ዬያይዴስካፓ ዒኢካ ዔያቶ ቤርቶይዳ ዔቂ፥ ዬይ ላላሢ ዋኣፆ ዔያቶም ኬሳንዳጉዲ ዓይሤ፤ ዬያይዲ ላላፓ ዋኣሢ ኔ ኬሴም ዴሮንታ ዔያቶኮ ቆልሞንታ ዑሽካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣራፓ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ሙሴ ፔኤኮ ኮኦሎ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ዒዛንታ ዓኣሮኔንታ ላሎኮ ቤርቶ ዛሎይዳ ዒስራዔኤሌ ዓሶ ቢያ ቡኩሴኔ፤ ዒማና ሙሴ ዴሮ ኮይላ፦ «ዒንሢ ዋይዞ ዒፃ ዓሳ! ሃያ ላሎይዳፓ ዋኣሢ ኑ ዒንሢም ኬሶንዶ?» ጌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ዬካፓ ፔኤኮ ኮኦሎ ዔኪ ላሎ ላምዒ ማይንቲ ጳርቃዛ ሚርጌ ዋኣሢ ዹኡቂ ኬስኬም ዴሮንታ ዔያቶኮ ቆልማኣ ቢያ ዑሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ጋዓንቴ ናንጊና ናንጋ ጎዳ ሙሴና ዓኣሮኔናም፦ «ዒስራዔኤሌ ዴሮ ቤርታ ታና ዱማዼያ ማሂ ቦንቺሳኒ ታና ዒንሢ ጉሙርቂባኣሢሮ ታ ዔያቶም ዒንጋኒ ጫኣቄ ዓጮ ሃያ ዴሮ ዔኪ ዒንሢ ጌላዓኬ» ጌዒ ዔያቶ ጎሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ዒስራዔኤሌ ዓሳ ናንጊና ናንጋ ጎዳና ዎላ ጎሪንቴሢና ዒዚያ ፔኤኮ ዱማዼያ ማዒፆ ዔርዛ ቦንቾ ፔጋሲ ዻዌ ዬና ቤዛ ሜሪባ ጌይንቴሢሮ ዋኣፄላኣ ሜሪባ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ሙሴ ዔዶኦሜ ካኣቲም ሂዚ ጌይ ኬኤዛንዳጉዲ ቃዴሴፓ ኪኢታ ዓሲ ዳኬኔ፦ «ሃይ ኪኢታ፥ ኔኤኮ ዒጊኖ፥ ዒስራዔኤሌ ዓሶፓኬ፤ ኑና ሄሌ ሜታሢ ቢያ ኔ ዋይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ኑኡኮ ቤርታኣ ዓዶንሢ ጊብፄ ዓጮ ዎይቲ ዴንዴቴያ፤ ሃሣ ጊብፄይዳ ኑ ሚርጌ ሌዔ ዎዲ ናንጌቴያ ኔ ዔራኔ፤ ጊብፄ ዓጮ ዓሳ ኑ ዓዶንሢንታ ኑናንታ ሚርጌና ሜታሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ዒማና ናንጊና ናንጋ ጎዳ ኑና ማኣዳንዳጉዲ ኑ ዒላቴሢሮ ዒዚ ኑ ዒላቶ ዋይዚ፥ ዬካፓ ኑና ኬሳንዳ ፔኤኮ ኪኢታንቻሢ ኑኡም ዳኬኔ፤ ሃኣዛጌ፦ ሃሢ ኑኡኒ ኔ ዓጮኮ ዛጶይዳ ዓኣ፥ ቃዴሴይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ዬያሮ ሃዳራ ኔ ዓጮይዴና ኑ ዓኣዾም ኑናታቴያ ኑኡኮ ቆልማ ጎይፆማፓ ኑ ኬስካዓኬ፤ ዒንሢኮ ጎዦ ጋሮ ማዔቴያ ቱኪንቴ ዎይኖ ባኣኮዋ ኑ ጌላዓኬ፤ ኔኤኮ ዋኣፆ ዔታፓኣ ኑ ዱይ ዑሽካዓኬ፤ ኔ ዓጮ ቲቂ ኑ ዴንዳንዳኣና ዚጊሮ ጎይፆማፓ ኑ ኬስካዓኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ዔዶኦሜ ዓሳ ጋዓንቴ፦ «ኑ ዓጮይዴና ዒንሢ ዓኣዻንዳጉዲ ኑ ኮዑዋሴ! ዎልቄና ዒንሢ ጌላኒ ኮዔቴ ጋዓንቴ ኬስኪ ኑ ዒንሢ ዖላንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ዒስራዔኤሌ ዓሳ ማሃዖ፦ «ኑኡኒ ዚጊሮ ጎይፃፓ ኬስካዓኬ፤ ኑና ማዔቴያ ኑኡኮ ቆልማ ዋኣፆ ዒንሢኮ ዑሽኬቴ ኑ ዒንሢም ጪጋንዳኔ፤ ኑኡኒ ኮዓሢ ዒንሢ ዓጮ ጊዴና ዓኣዺፆማ ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ዔዶኦሜ ዓሳ ጋዓንቴ፦ «ዔይዔ! ኑ ዒንሢ ዳካዓኬ!» ጋዓዖ ሚርጌ፤ ሃሣ ጊንሣ ዎልቄና ዖላንዳ ዓሲ ዔኪ ዒስራዔኤሌ ዓሶ ዖላኒ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ዔዶኦሜ ዓሳ ዒስራዔኤሌ ዓሶ ፔ ዓጮና ዓኣዹዋጉዲ ላኣጌሢሮ ዔያታ ሜሌ ጎይሢና ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ዒስራዔኤሌ ዓሳ ቢያ ቃዴሴፓ ዔቂ ሆኦሬ ዹኮ ሄሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ዬና ቤዛ ዔዶኦሜ ዓጮኮ ዛጳ ዓኣ ቤሲኬ፤ ናንጊና ናንጋ ጎዳ ዒኢካ ሙሴና ዓኣሮኔናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«ዒስራዔኤሌ ዓሶም ታ ዒንጋኒ ጫኣቄ ዓጮ ዓኣሮኔ ጌላዓኬ፤ ዒንሢ ላምዓሢ ሜሪባ ዋኣፆ ካራ ታ ዓይሤ ዓይሢፆ ዒፄሢሮ ዓኣሮኔ ሃይቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ዬያሮ ዓኣሮኔና ዒዛኮ ናኣዚ ዓላዜሬና ዔኪ ሆኦሬ ዹኮ ኬስኪጋፓ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ዓኣሮኔኮ ቄኤሶ ማኣዓሢ ኬሲ ዓላዜሬ ማይሴ፤ ዓኣሮኔ ዒኢካ ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ቢያ ባኮ ሙሴ ማዼኔ፤ ዒስራዔኤሌ ዴራ ቢያ ዒዛ ዛጋንቴ ሆኦሬ ዹኮ ዔያታ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ዒማና ሙሴ ዓኣሮኔኮ ቄኤሶ ማኣዓሢ ኬሲ፥ ዓላዜሬ ማይሴኔ፤ ዒኢካ ዹኮይዳ ዓኣሮኔ ሃይቄኔ፤ ዬካፓ ሙሴና ዓላዜሬና ጊንሣ ማዒ ዹካፓ ኬዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ዬካፓ ዴራ ጉቤ ዓኣሮኔ ሃይቄሢ ዋይዚ ሃይሢታሚ ኬሊ ሄላንዳኣና ዖዪ ዒዛ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ካኣናኔ ዓጮኮ ዾኦሎ ዛሎይዳ ናንጋ፥ ካኣናኔ ዓሶኮ ካኣቲ ዓራዴ ዒስራዔኤሌ ዓሳ ዓታሪሜ ባንፆና ሙካሢ ዋይዛዖ ዔያቶይዳ ዖልዚ ቡሊ ዻካ ዓሲ ዲዒ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ዬያሮ ዒስራዔኤሌ ዓሳ፦ «ሃያ ዓሶ ኑ ባሻንዳጉዲ ኔ ኑና ማኣዴቴ ዔያቶንታ ዔያቶኮ ካታሞንታ ጉቤና ኑ ባይዚ ኔኤም ማዔያ ማሃንዳኔ» ጌይ ናንጊና ናንጋ ጎዳም ናኣቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ናንጊና ናንጋ ጎዳኣ ዔያቶኮ ሺኢጲፆ ዋይዚ፦ ዔያቶ ማኣዴሢሮ ካኣናኔ ዓሶ ዖሊ ባሺ ዓርቂ፥ ካኣናኔ ዓሶንታ ካታሞንታ ጋፒሲ ባይዜኔ፤ ጋፒ ባይቄያ ማዔሢ ዔርዛኒ ዬኖ ቤዜሎኮ ሱንፆ፦ «ሆርማ» ጌዒ ዔያታ ጌሤኔ፤ (ሆርማ ጌይፃ፦ ዔብሬ ዓሶ ሙኡጮና «ባይዚሢ» ጌይሢኬ።) ");
INSERT INTO mdyeth_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ዒስራዔኤሌ ዓሳ ዔዶኦሜ ዓጮኮ ዙሌና ሺሪ ዓኣዻኒ ማሊ ሆኦሬ ዹካፓ ዔቂ ዞቄ ባዞ ባንሢ ዓኣዻ ጎይፆና ዴንዴኔ፤ ዴራ ጎይፆይዳ ዓኣንቴ ጊቢ ዳንዳዒፃ ዔያቶ ባሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ዬያሮ ዔያታ ፆኦሲና ሙሴናይዳ፦ «ሙኡዚንታ ዋኣሢንታ ባኣ፥ ሃያ ዓሲ ናንጉዋ ዳውላ ኑ ሃይቃንዳጉዲ ጊብፄ ዓጫፓ ዒንሢ ኑና ዓይጋ ዔኪ ኬሴይ? ሃኖ ዒሣ ሙዔሎ ዑፃ ኑኡኮ ሼናዼኔ!» ጌይ ፑርታ ዑኡሲ ኬሲ ጉንዱሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ዬካፓ ናንጊና ናንጋ ጎዳ ፑርታ፥ ዻይ ዎዎዻ ሾኦሺ ዴሮ ባኣኮ ዳኬሢሮ ሚርጌ ዒስራዔኤሌ ዓሲ ዻይንቲ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ዬያሮ ዴራ ሙሴ ኮይላ ሙኪ፦ «ናንጊና ናንጋ ጎዳ ዑፃ፤ ጊንሣ ሃሣ ኔ ዑፃ ፑርታ ባኣዚ ኑ ጌስቲፆና ዻቤኔ፤ ሃሢ ሃይ ዻዓ ሾኦዣ ባይቃንዳጉዲ ናንጊና ናንጋ ጎዳ ኑም ሺኢቄ» ጋዓዛ፥ ሙሴ ዴሮ ዛሎ ሺኢቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ዒማና ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሞኦና ዓንጊና ፔቴ ሾኦሺ ኮሺ፥ ሚሢዳ ኬሲ ሱፄ፤ ሾኦዦና ዻይንታ ዓሳ ቢያ ዬያ ዛጋዖ ዻቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ዬያሮ ሙሴ ሞኦኖ ዓንጎና ሾኦሺ ኮሺ፥ ሚሢዳ ሱፃዛ ሾኦዦና ዻይንቴ ዓሳ ቢያ ዬያ ሞኦኖ ዓንጎ ሾኦዣሢ ዛጋዖ ዻቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ዒስራዔኤሌ ዓሳ ዴንዴ ጎይሣ ዓቦቴ ጌይንታ ቤዞ ሄሊ ዒኢካ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ዬኖ ቤዞ ጊንሣ ሃሺ ዴንዳዖ ሞዓኣቤ ዶኦጮኮ ዓባ ኬስካ ዛሎና ዓኣ ዓሲ ናንጉዋ ዳውሎ «ዓባሪሜ» ጌይንታዞይዳ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ዬካፓ ሃሣ ዓኣዺ ዜሬዴ ዶኦጮይዳ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ሃሣ ዬኖ ቤዛፓ ዔቂ፥ ዓሞራ ዓጮ ዴንዲ ሄላ ዓሲ ናንጉዋ ዳውሌስኬኖ፥ ዓርኖኦኔ ዎሮ ሱካ ዓኣስኬኖይዳ ዱንኪ ዴዔኔ፤ ዓርኖኦኔ ዎራ ሞዓኣቤ ዓጮና ዓሞኦኔ ዓጮናኮ ዛጶይዳ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ዬያይዳፓ ዔቄያና ናንጊና ናንጋ ጎዳ ዖሊሴ ዖሎ ዛሎ ኬኤዛ ማፃኣፖይዳ፦ «ሱኡፓ ዓጮና ዶኦጮ ዶኦጮናይዳ ዓኣ ዋሄቤ፥ ዓርኖኦኔ ዎራ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ዴንዲ ዓኣሬ ካታሞና ሞዓኣቤ ዛጶ ሄላ ዶኦጮ ዛሮ» ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ዬካፓ ዔያታ ዔቂ፦ «ዋኣፆ ዔቶ» ጌይንታ ቤሲ ዓኣዼኔ፤ ዒኢካ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዴሮ ፔቴይዳ ቡኩሴ፤ ዋኣሢ ታ ዔያቶም ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ዒማና ዒስራዔኤሌ ዴራ፦ «ዋኣፆ ዔታሢዮ ዋኣፆ ኬሴ፤ ዒዛም ዓይናዹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ሃኖ ዋኣፆ ዔቶ ቦኦኬሢ ዴሮኮ ጪሞና ሱኡጎናኬ፤ ዔያታ ዋኣፆ ዔቶ ቦኦኬሢ ፔኤኮ ካኣቱሞና ሃሣ ሲፓሢ ኮኦሎናኬ» ሂዚ ጌዒ ዓይናዼኔ። ዬኖ ዓሲ ናንጉዋ ዳውላፓ ዔያታ ዔቂ ማታና ጌይንታ ቤሲ ዴንዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ማታናፓ ናህሊዔኤሌ፥ ናህሊዔኤሌፓ ጊንሣ ባሞቴ ጌይንታ ቤሲ ሄሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ባሞቴይዳፓ ዔቂ ሞዓኣቤ ዓጮይዳ ዓኣ ዶኦቺ ቤሲ ዔያታ ዓኣዼኔ፤ ዬይ ዶኦጫሢ ፒሲጋ ዹኮ ዴማ፥ ዳውላዻ ቦኦሎኮ ሆታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ዬካፓ ዒስራዔኤሌ ዓሳ ዓሞራ ዓጮ ካኣቲ፥ ሲሆኔም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«ኔ ዓጮ ጊዴና ኑና ዳኬ፤ ኑናንታ ኑ ቆልሞንታ ጎይፆማፓ ኑ ኬስካዓኬ፤ ዒንሢኮ ጎዦ ጋሮ ማዔቴያ ቱኪንቴ ዎይኖ ሚፆ ባኣኮዋ ኑ ጌላዓኬ፤ ዒንሢኮ ዋኣፆ ዔታፓኣ ኑ ዑሽካዓኬ፤ ኔ ዓጮ ቲቂ ኑ ዴንዳኣና ዚጊሮ ጎይፆማፓ ኑ ኬስካዓኬ» ጌይ ኬኤዛንዳ ኪኢታ ዓሲ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ካኣቲ ሲሆኔ ጋዓንቴ ዒስራዔኤሌ ዓሳ ዒዛ ዓጮና ዓኣዻንዳጉዲ ኮይባኣሴ፤ ዒዚ ዎይቴይ ጌዔቴ ዒዛኮ ዖሎ ዖላ ዓሶ ቢያ ቡኩሲ ዓሲ ናንጉዋ ዳውሎይዳ ዓኣ፥ ያሃፄ ጌይንታ ቤዞ ዓኣዺ ዒስራዔኤሌ ዓሶ ዒኢካ ዖሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ዒስራዔኤሌ ዓሳ ጋዓንቴ ዖሎና ዔያቶ ባሺ፥ ዓርኖኦኔ ዎራፓ ዴንዲ ኬዶ ዛሎና ዓሞኦኔ ዓጮኮ ዛጶ ሄላንዳኣና፤ ጌይፃ፦ ያኣቦቄ ዎሮ ሄላንዳኣና ዓኣ ዓጮ ዓርቄኔ፤ ያዺ ማዔቴያ ዓሞኦኔ ዓጮኮ ዛጳ ሚርጌ ዖላ ዓሲ ዎልቄና ካፒንቲ ዓኣሢሮ ዬኖ ዛጶና ዔያታ ፒንቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ዬያይዲ፥ ዒስራዔኤሌ ዴራ ዓሞራ ዓጮኮ ካታሞ ሃሴቦኦኔና ኮይላ ዓኣ ዻኮ ዻኮ ካታሞዋ ዓርቂ ዒኢካ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ሃሴቦኦኔ ዓሞኦኔ ዓጮ ካኣቲ፥ ሲሆኔ ናንጋ ካታማኬ፤ ዒዚ ሞዓኣቤ ዓጮኮ ቤርታሳ ካኣታሢና ዖልቲ ዓርኖኦኔ ዎሮ ሄላንዳኣና ዓኣ ዓጮ ባሺ ዔኬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ዬያይዳፓ ዔቄያና ዓይኑሞ ዓሳ፦ «ካኣታሢ ሲሆኔ ካታሞ ሃሴቦኦኔ ሙኩዋቴ! ዬና ካታሜላ ማዢንቶንጎ፥ ጊንሣ ዔቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ሃሴቦኦኔይዳፓ ታሚ ኬስኪ ሲሆኔ ካታሞይዳፓ ታሚ ሎስታ ዔቂ ሞዓኣቤ ዓጮይዳ ዓኣ ዓኣሬ ካታሞ ባይዜኔ፤ ዓርኖኦኔ ዎሮ ኮይሎይዳ ዓኣ ዼጌ ቤዞ ዶይሲ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ሞዓኣቤ ዓሲዮቴ ዒንሢና ባዴዔ! ዒንሢ ኬሞሼ ጌይንታ ባኮ ካኣሽካ ዓሳ ዒንሢ ባይቃንዳኔ፤ ዬይ ዒንሢኮ ፆኦዛሢ ዓቲንቆ ዒንሢኮ ሜሌ ዓጪ ዳኪሴኔ፤ ዒንሢ ላኣሎዋ ካኣቲ ሲሆኔና ዲዒ ዔኪሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ኑኡኒ ጋዓንቴ ዒንሢኮ ዜርፆ ባይዜኔ፤ ሃሴቦኦኔፓ ዲቦኔ ሄላንዳኣና ዴንዲ ሃሣ ኖፓ ሄላንዳኣና ዓኣ ካታሞ ዬያጉዲ ሜዴባ ሄላንዳኣና ዓኣ ካታሞ ዶይሲ ኑ ባይዜኔ» ጌዒ ዓይናዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ዬያሮ ዒስራዔኤሌ ዴራ ዬኖ ዓሞራ ዓሶ ዓጮይዳ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ሙሴ ዒማና ያዕዜሬ ካታሞ ዓርቃኒ ሙሪ ዓሲ ዳኬኔ፤ ዬካፓ ዬኖ ካታሜሎና ኮይላ ዓኣ ዻካ ዻካ ካታማ ዓርቄኔ፤ ዒኢካ ናንጋ ዓሞራ ዓሶዋ ዳውሲ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ዬካፓ ዒስራዔኤሌ ዓሳ ማዒ ባኣሳኣኔ ባንሢ ዓኣዻ ጎይፆ ዓርቂ ዴንዴኔ፤ ዒማና ባኣሳኣኔ ካኣቲ ዖጌ ዔድሬዒ ጌይንታ ቤዛ ዒስራዔኤሌ ዓሶ ዖላኒ ፖኦሊሶ ዔኪ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሃያ ዓሢ ዒጊጪፖ፤ ዒዛንታ ዒዛኮ ዴሮንታ ባሺሲ፥ ዓጮይዳ ባሺሢ ዒንሢም ታ ዒንጋንዳኔ፤ ሃሴቦኦኔ ካታሞይዳ ዴዒ ዓሞራ ዓጮ ዎይሣ ካኣቲ ሲሆኔይዳ ዒንሢ ማዼ ባኮ ቢያ ሃያ ዓሢዳኣ ማዹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ዬያሮ ዒስራዔኤሌ ዴራ ዖጌንታ ናኣቶንታ ዒዛኮ ዴሮዋ ቢያ ፔቴታዖ ዓይሱዋ ዎዺ ባይዚ ዓጬሎ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ዒስራዔኤሌ ዓሳ ዴንዴ ጎይሣ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ባንፆይዳ፥ ዒያርኮኮ ሆታ ዓኣ፥ ሞዓኣቤ ቦኦሎይዳ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ዒማና ሞዓኣቤ ዓጮ ካኣቲ፥ ባኣላኣቄ፦ ዒስራዔኤሌ ዓሳ ዓሞራ ዓሶይዳ ማዼ ፑርቶ ባኮ ዛጌኔ፤ ባኣላኣቄኮ ዓዴ ፂፖሬ ጌይንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ዒስራዔኤሌ ዓሶኮ ሚርጉሞ ዋይዛዖ ዬያ ካኣታሢንታ ዴሮንታ ዒጊጪ ዎኦቶንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ዬያሮ ሞዓኣቤ ዓሳ ሚዲያሜ ዓሶኮ ዓጮ ጪሞም፦ «ሃይ ዒንሢ ዛጋ ዴሮኮ ሚርጉማ፥ ጌማይ ሄንቃ ቤዞይዳ ዓኣ ማኣቶ ቢያ ጋፒሲ ሙዓሢጉዲ ኑ ኮይላ ዓኣ ባኮ ቢያ ፒፂ ባይዛንዳያኬ» ጌዔኔ። ዒማና ካኣቲ ባኣላኣቄ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ዓማው ዓጮይዳ፥ ዔፕራፂሴ ዎሮ ኮይሎይዳ፥ ፔቶሬ ካታማ ናንጋ ቢዖሬ ናኣዚ ባኣላኣሜ ዔኤላንዳጉዲ ኪኢታ ዓሲ ዳኬኔ፤ ዔያታ፦ «ጊብፄ ዓጫፓ ሙኬ ዴሬ ዓጮ ቢያ ኩሚ ዴዔኔ፤ ዔያታ ኑ ዓጮ ኮይላኬ ዱንኪ ዴዔሢ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ዬያ ዴሮኮ ፓይዳ ኑ ዓሶይዳፓ ሚርጌና ባሻያኬ፤ ዬያሮ ኑ ኮይላ ሙኪ ዔያቶ ታኣም ጋዳንቄ፤ ዬያይዲ ጎዖንቴ ዔያቶ ኑ ባሺ ኑ ዓጫፓ ኬሳንዳያናንዳኔ፤ ኔኤኒ ዓንጃሢ ዓንጂንቴያ፥ ኔኤኒ ጋዳንቄሢ ጋዳንቂንቴያ ማዓሢ ታ ዔራኔ» ጋዓ ኪኢታ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ዬያሮ ሞዓኣቤ ዓሶና ሚዲያሜ ዓሶናኮ ጪማ ጋዳንቆሢሮ ጪጎ ሚኢሾ ዔኪ፥ ባኣላኣሜ ኮይላ ዓኣዺ ባኣላኣቄ ጌዔ ባኮ ኬኤዛዛ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ባኣላኣሜ ዔያቶም፦ «ሃይካ ዎርቁዋቴ፤ ናንጊና ናንጋ ጎዳ ታኣም ጋዓ ባኮ ዚሮ ጉቴ ታ ዒንሢም ኬኤዛንዳኔ» ጌዔኔ፤ ዬያሮ ሞዓኣቤ ዓሶኮ ጪማ ባኣላኣሜ ማኣራ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ፆኦሲ ባኣላኣሜ ኮይላ ሙካዖ፦ «ሃይካ ኔ ኮራ ዓኣ ዓሳ ዓይጎ ዓሲዳይ?» ጌይ ዖኦጫዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ዒዚ ሂዚ ጌይ ማሄኔ፦ «ሞዓኣቤ ካኣቲ ባኣላኣቄ ታ ኮይላ ዳኬ ዓሲኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ዔያታ፦ ‹ጊብፄ ዓጫፓ ሙኬ ዴሬ ዓጮ ባይዚ ዴዔኔ፤ ኔኤኒ ሙኪ ዔያቶ ጋዳንቄያ ማዔቴ ጎዖንቴ ዔያቶ ታኣኒ ዖሊ ባሻንዳያናንዳኔ› » ጋዓ ኪኢታ ዔኪ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ፆኦሲ ባኣላኣሜም፦ «ዬንሢ ዓሶና ዎላ ዓኣዺፖ፤ ታኣኒ ዔያቶ ዓንጄያ ማዔሢሮ ዒስራዔኤሌ ዴሮ ጋዳንቂፖ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ባኣላኣሜ ዚሮ ጉቴ ሳዓ ካራዛ ዔቃዖ ባኣላኣቄ ኮይላፓ ሙኬ ዓሶም፦ «ዓካሪ፥ ዒንሢ ዒንሢ ማኣሪ ማዒ ዓኣዹዋቴ፤ ታኣኒ ዒንሢና ዎላ ዴንዱዋጉዲ ናንጊና ናንጋ ጎዳ ታና ላኣጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ዬያሮ ሞዓኣቤ ዓጫፓ ሙኬ ቢታንታ ዓኣ ዓሳ ባኣላኣቄ ኮይላ ማዒ ዓኣዻዖ ባኣላኣሜ ዔያቶና ዎላ ሙኮ ዒፄሢ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ዬካፓ ሃሣ ባኣላኣቄ፦ ቤርታኣ ዓሶፓ ባሼ ቦንቺንታያና ዺቢ ማዔ ጪሚ ባኣላኣሜ ኮይላ ዳኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ዔያታ ባኣላኣሜ ኮይላ ዓኣዺ ባኣላኣቄ ጌዔ ባኮ፦ «ታ ኮይላ ሙኮ ኔና ላኣጋ ባኣዚ ባኣያ ናንጎም! ");
INSERT INTO mdyeth_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ኔ ማዼ ባኮኮ ሚርጌ ባኣዚ ታ ጪጋንዳኔ፤ ኔ ዖኦጬ ባኣዚ ቢያ ታ ማዻንዳኔ፤ ዬያሮ ሃዳራ ሙኪ ሃያ ዴሮ ታኣም ጋዳንቄ ጌዔኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ባኣላኣሜ ጋዓንቴ ዬኖ ኪኢቶ ዓሶም፦ «ባኣላኣቄ ዒዛኮ ካኣቱሞ ማኣሮይዳ ዓኣ ቢሮንታ ዎርቆንታ ቢያ ታኣም ዒንጌቴያ፥ ሃሣ ዻካ ባኣዚና ማዖም ዼኤፒ ባኣዚ ዛላና ታ ፆኦዛሢ ዓይሢፆኮ ዑሣ ዓኣዻኒ ታ ዳንዳዑዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ፆኦሲ ታኣም ኬኤዛ፥ ሜሌ ባኣዚ ዓኣቴ ዒዛይዳፓ ታ ዔራንዳጉዲ ሂንዳ ዒንሢያ ቤርታኣ ዓሶጉዲ ዒባኒ ሃይካ ዎርቁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ዬኖ ዋንቴሎ ፆኦሲ ባኣላኣሜ ኮይላ ሙኪ፦ «ሃንሢ ዓሶንሢ ኔ ኮይላ ሙኬሢ ኔና ዔኪ ዓኣዻኒ ማዔቴ ዔያቶና ዎላ ዓኣዼ፤ ጋዓንቴ ታ ኔኤም ኬኤዛ ባኮማ ሌሊ ማዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ዬያሮ ዚሮ ጉቴሎ ባኣላኣሜ ዔቃዖ ፔኤኮ ሃሬሎ ኮኦሪ፥ ሞዓኣቤፓ ሙኬ ዼኤፖ ዓሶና ዎላ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ባኣላኣሜ ዓኣዼሢሮ ፆኦሲ ዻጋዼኔ፤ ዒማና ባኣላኣሜ ፔኤኮ ላምዖ ካራሚ ዔኪ ሃሬሎዋ ቶጊ ዓኣዻንቴ ናንጊና ናንጋ ጎዳኮ ኪኢታንቻ ዒዛኮ ቤርታ ዔቂ ጎይፆ ባይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ኪኢታንቻሢ ጬንቻ ዓፓሮ ቱኪ ጎይፃ ዔቄሢ ሃሬላ ዴንቃዖ ጎይፆ ሃሺ ጎሺ ጋርሲ ጌሌኔ፤ ጋዓንቴ ባኣላኣሜ ሃሬሎ ጳርቂ ጎይፆ ጊንሣ ኬሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ዬካፓ ሃሣ ላምዖ ዎይኔ ጎሺኮ ባኣኪና ኩንዒንቲ ዓኣዾ ጎይሢና ዒ ዴንዳንቴ ላምዖ ዛሎይዳ ኬልቂንቴ ሹቺ ዓኣ ቤሲዳ ኪኢታንቻሢ ሙኪ ቤርታ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ዒማና ሃሣ ሃሬላ ኪኢታንቻሢ ዴንቃዖ፦ ዬያ ሹጮ ባንሢ ዶጪ፥ ባኣላኣሜኮ ቶኮ ሹጮና ዎላ ዓይሤሢሮ ባኣላኣሜ ሃሬሎ ጳርቂሢ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ሃሣ ጊንሣ ኪኢታንቻሢ ቤርታ ዴንዲ ሻውሎ ዛሎና ማዖም ሚዛቆ ዛሎና ዓኣዺንታኒ ዳንዳዑዋ፥ ኩንዔ ካራይዳ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ዒዞ ጎይፆ ሃሣ ሃሬላ ኪኢታንቻሢ ዴንቃዖ፦ ሳዓ ላሃዛ፥ ባኣላኣሜ ሚርጌና ዻጋዺ ሃሬሎ ኮኦሎና ጳዺ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ዒማና ፆኦሲ ሃሬላ ጌስታንዳ ዔራቶ ዒንጋዛ ዒዛ ባኣላኣሜ ኮራ፦ «ታ ኔኤኮ ዓይጎ ዎዴይ? ሃይሢ ማይንቲ ኔ ታና ጳርቄሢ ዓይጎሮዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ባኣላኣሜ ዒዞ ኮይላ፦ «ሚርጌ ኔ ታኣና ዓማሌሢሮሾ! ዎንዴ ጬንቻ ዓፓሮ ታ ኮይላ ዓኣቴ ታ ኔና ዎዎዻንዳኔ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ሃሬላ ጊንሣ ዒዛም፦ «ኔኤኒ ቢያ ዎዴ ታና ቶጊ ሃንታ፥ ታኣኒ፥ ኔ ሃሬሎቱዋዓዳ? ሂዳዖ፤ ሃያኮ ቤርታ ሃናኣሲጉዲ ታ ሂዲ ቤቂያ?» ጋዓዛ፥ ባኣላኣሜ፦ «ፔቴታዖ ኔ ሂዲ ቤቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ዒማና ናንጊና ናንጋ ጎዳ ጬንቾ ዓርቂ ዔቂ ዓኣ ኪኢታንቻሢ ዴንቃንዳጉዲ ባኣላኣሜ ዻዋዛ፥ ዒዚ ባሊቶና ሳዓ ሎኦሚ ላሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ኪኢታንቻሢ ዒዛም፦ «ሃሬሎ ኔ ሃይሢማይንቲ ኮኦሎና ጳርቄሢ ዓይጎሮዳይ? ታኣኒ ሙኪ ጎይፆ ኔኤኮ ባይዜሢ ባይሲንቶ ጎይፆ ኔ ዓኣዹዋጉዲ ላኣጋኒ ጌይኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ኔኤኮ ሃሬላ ጋዓንቴ ታና ዴንቄሢሮ ሃይሢ ማይንቲ ታ ቤርታፓ ሺኢኬኔ፤ ሃሬላ ዎንዴ ዬያይዲባኣያታቴ ኔና ታ ዎዺ፥ ዒዞ ሃሼያናንዳንቴኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ባኣላኣሜ ማሃዖ፦ «ጎኔኬ፥ ጎሜ ታ ማዼኔ፤ ኔኤኒ ታና ላኣጋኒ ጎይፃ ዔቄሢ ታ ዔሪባኣሴ፤ ሃሢያ ታኣኮ ዒኢካ ዓኣዺፃ ዻቢንቲ ማሊ ኔኤም ጴዼቴ ታ ማኣሪ ማዒ ታ ዴንዳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ኪኢታንቻሢ ጋዓንቴ፦ «ሃንሢ ዓሶንሢና ዓኣዾ ኔኤሮ ዓኣዼ፤ ጋዓንቴ ታ ኔኤም ኬኤዛማ ሌሊ ኬኤዜ» ጌዔኔ፤ ባኣላኣቄ ዳኬ፥ ቢታንታ ዓኣ ዓሶና ዎላ ባኣላኣሜ ዬያይዲ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ባኣላኣሜ ሙኬሢሮ ባኣላኣቄ ዋይዛዖ ሾቺ ዒዛ ዔካኒ ሞዓኣቤ ዓጮ ዛጳ፥ ዓርኖኦኔ ዎሮ ዓጫ ዓኣ፥ ዓኣሬ ካታሞ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ባኣላኣቄ ባኣላኣሜ ኮራ፦ «ቤርታ ኪኢቶ ዓሶ ታ ኔኤም ዳኬያና ኔ ዓይጋ ዓቴይ? ኔ ማዼ ባኮኮ ጊዳ ሚኢሼ ታ ጪጊንዱዋጉዲ ኔኤም ጌዒያ?» ጌይ ዖኦጫዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ባኣላኣሜ ማሃዖ፦ «ሂዴያ ማዔቴያ ታ ማይ ሙኪባይ? ጋዓንቴ ታኣኮ ዓይጎ ዎልቄ ዓኣይ? ታ ጌስታኒ ዳንዳዓሢ ፆኦሲ ታኣም ኬኤዜማ ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ዬካፓ ባኣላኣሜ ባኣላኣቄና ዎላ ሁፆቴ ጌይንታ ካታሞ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ዒኢካ ባኣላኣቄ፦ ባይንታ ማራይንታ ፆኦሲም ሹኪሲ ዓሽኮይዳፓ ዻካ ዔኪ ዒዛና ዎላ ዓኣ ቢታንታ ዓኣ ዓሶና ባኣላኣሜናም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ዚሮ ጉቴሎ ባኣላኣቄ ባኣላኣሜ ዔኪ ዒስራዔኤሌ ዓሶኮ ሄካሢ ዛጋኒ ዳንዳዓ፥ ባሞትባዓኣሌ ጌይንታ ቤሲ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ባኣላኣሜ ባኣላኣቄ ኮይላ፦ «ሃይካ ፆኦሲም ሚቺ ዒንጎ ላንካይ ቤሲ ኮሺ፥ ላንካይ ዚያ ጌማይና ላንካይ ዓዴ ማራይና ታኣም ዔኪ ሙኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ዒማና ባኣላኣቄ ጌይንቴ ጎይፆ ማዼኔ፤ ዒዛንታ ባኣላኣሜንታ ፆኦሲም ዒንጎ ባኮ ሺኢሾ ፔቴ ፔቴ ቤዞይዳ ፔቴ ዚያ ጌማይና ፔቴ ዓዴ ማራይና ሹኪ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ዬካፓ ባኣላኣሜ ባኣላኣቄ ኮይላ፦ «ናንጊና ናንጋ ጎዳ ታ ኮይላ ሙካንዳቴያ ሙኪንዱዋቴያ ዔራኒ ሃሴኬያ ዴንዲ ታ ዛጋንዳያ ሄላንዳኣና ሃይካ ፆኦሲም ኔ ሚቺ ዒንጌ ቤዞኮ ኮይላ ዔቄ፤ ናንጊና ናንጋ ጎዳ ታኣም ኬኤዜ ባኮ ቢያ ታ ኔኤም ኬኤዛንዳኔ» ጌይ፥ ዬኖ ቤዛፓ ፔቴ ጌሜሪ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ዒማና ፆኦሲ ዒዛና ካኣማዛ፥ ባኣላኣሜ ፆኦሲ ኮይላ፦ «ላንካዎ ሚቺ ዒንጎ ቤዞ ታ ጊኢጊሺ፥ ፔቴ ፔቴ ቤዞይዳ ፔቴ ዚያ ጌማይና ፔቴ ዓዴ ማራይ ሹኪ ታ ኔኤም ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ባኣላኣሜ ባኣላኣቄም ኬኤዛኒ ኮይሳ ኪኢቶ ናንጊና ናንጋ ጎዳ ኬኤዜስካፓ ዬኖ ዒ ሙኬ ቤዞ ባንሢ ማዒ ዓኣዻንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ዒዚ ማዒ ሙካንቴ ባኣላኣቄ ሞዓኣቤ ዓጮፓ ሙኬ ቢታንታ ዓኣ ዓሶና ዎላ ዬኖ ሚቺ ዒንጎ ቤዜሎ ኮይላ ዔቂ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ዒማና ባኣላኣሜ ፆኦሲ ማሊሢ፦ «ሞዓኣቤ ካኣቲ ባኣላኣቄ ዓባ ኬስካ ዛሎ ዹካ ዓኣ፥ ሶኦሪያ ዓጫፓ ዔኤሊ ታና ዔኪ ሙኬኔ። ዒዚያ ታና ‹ሃኒ ሙኪ፥ ያይቆኦቤ ታኣም ጫሽኬ፤ ዒስራዔኤሌ ዓሳ ባይቃንዳጉዲ ታኣም ጋዳንቄ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ዓካሪ ታኣኒ፦ ፆኦሲ ጋዳንቂባኣ ባኣዚ፥ ዎዲ ጋዳንቃንዳይ? ፆኦሲ ጫሽኪባኣ ባኣዚ፥ ዎዲ ታ ጫሽካንዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ታኣኒ ዔያቶ ሃያ ዼጌ ላሎይዳ ዔቂ ዛጋኔ፤ ጌሜሮ ዑፆይዳ ዔቂያ ታ ዔያቶ ዛጋኔ፤ ዔያታ ፔና ዳንዳዒ ፔኤሮ ናንጋ ዴሬኬ፤ ሜሌ ዓሶይዳፓ ባሼ ዱማዼያ ማዔሢ፥ ዔያታ ዔራያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ያይቆኦቤኮ ዜርፃ ዓጪጉዴያኬ፤ ዒስራሌ ዓሳ ኮሺ ዺባሢሮ ዛሎኮ ዛላታዖ ዖኦኒ ፓይዳኒ ዳንዳዓይ? ታ ሃይቦ ፂሎ ዓሳ ሃይቃሢጉዲ ማሄ፤ ጋፒንፆዋ ታኣኮ ዔያቶሲጉዲ ማሄ» ሂዚ ጌይ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ባኣላኣቄ ባኣላኣሜ ኮይላ፦ «ሃይ ኔ ታኣም ማዼ ባካ ዓይጌንዴዳይ? ታ ኔና ሃይካ ዔኪ ዬዔሢ ታኣኮ ሞርኮ ኔ ጋዳንቃንዳጉዲቱዋዓዳ? ኔኤኒ ጋዓንቴ ዔያቶ ዓዓንጄያፓዓቴም ሜሌ ዎኦቴ ባኣዚ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ባኣላኣሜ ማሃዖ፦ «ታኣኒ ጌስታኒ ዳንዳዓሢ ናንጊና ናንጋ ጎዳ ታኣም ኬኤዜማ ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ባኣላኣቄ ባኣላኣሜ ኮይላ፦ «ዒስራዔኤሌ ዓሶ ጉቤቱዋንቴ ዻካ ሌሊ ኔ ዴንቃንዳ፥ ሜሌ ቤሲ ኑ ዎላ ዓኣዾም፤ ዒኢካ ዔቂ ዔያቶ ታኣም ጋዳንቄ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ዬካፓ ፒሲጋ ዹኮይዳ ዓኣ፥ ፆፒሜ ዔኪ ዓኣዼኔ፤ ዒኢካ ፆኦሲም ዒንጎ ባኣዚ ዒንጎ ላንካይ ቤሲ ኮሺ፤ ፔቴ ፔቴ ቤዞይዳ ፔቴ ዚያ ጌማይና ፔቴ ዓዴ ማራይያ ሹኪ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ባኣላኣሜ ባኣላኣቄ ኮራ፦ «ኔኤኒ ሃይካ ፆኦሲም ሚቺ ዒንጌ ቤዞ ኮይላ ዔቄ፤ ታኣኒ ፆኦሲና ካኣማኒ ሃሴኬያ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ዒማና ናንጊና ናንጋ ጎዳ ባኣላኣሜና ዎላ ካኣሚ፦ ዒዚ ኬኤዛንዳ ኪኢቶ ኬኤዚ ባኣላኣቄ ባንሢ ማሂ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ዒዚ ሙካንቴ ባኣላኣቄ ሞዓኣቤ ዓጮኮ ዼኤፖ ዓሶና ዎላ ዔቂ ዓኣኔ፤ ዬካፓ ናንጊና ናንጋ ጎዳ ዒዛም ዓይጎ ባኣዚ ኬኤዜቴያ ባኣላኣቄ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ባኣላኣሜ ሂዚ ጌይ ፆኦሲ ማሊሢ ኬኤዜኔ፦ «ፂፖሬ ናዓሦ፥ ባኣላኣቄ! ሃኒ ሙኪ ታ ኔኤም ጋዓ ባኮ ቢያ ዋይዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ፆኦሲ ዓሲጉዲ ሉኡቁዋሴ፥ ዓሲጉዲ ማሊፆዋ ፔኤኮ ላኣሙዋሴ፤ ዒ ጫኣቄ ባኮ ኩንሣኔ፤ ጌዔ ባኮዋ ቢያ ማዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ታኣም ኬኤዚንቴሢ ታ ዓንጃንዳጉዲኬ፤ ፆኦሲ ዓንጃዛ ታ ዒዛ ቃኣሎ ላኣማኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ያይቆኦቤይዳ ዔርቲባኣ ፑርታ ባኣዚታቴያ ሜታ ሄሊንዱዋኣሢ ጴዻኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ዔያቶኮ ፆኦዛሢ ዒስራዔኤሌ ዓሶና ዎላኬ፤ ፆኦሲ ዔያቶኮ ካኣቲ ማዔሢያ ዎዛና ዔያታ ኬኤዛኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ጊብፄ ዓጫፓ ዔያቶ ኬሴ ፆኦዛሢ፥ ዔያቶኮ ሜኤኒ ካኣሪጉዲ ማዒ ሙካ ባኮ ዔያቶም ዹዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ያይቆኦቤም ማርሾናቴያ ዒስራዔኤሌ ዓሶ ጫኣቆናቴያ ፔቴታዖ ማዻ ባኣዚ ባኣሴ፤ ዓካሪ፥ ሃይሾ ያይቆኦቤ ዓሶና ዒስራዔኤሌ ዓሶናም ‹ፆኦሲ ማዼ ባኮ ዛጉዋቴ!› ጌይንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ዒስራዔኤሌ ዴራ ዒንዴ ዞቢጉዲ ማዓንዳኔ፤ ኬሚ ዎዼሢ ሙዓንዳያ ሄላንዳኣና ሱጉፆዋ ዑሽካንዳያ ሄላንዳኣና ዚቲ ጌይ ላሁዋ ዞቢጉዲ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ዬካፓ ባኣላኣቄ ባኣላኣሜ ኮራ፦ «ዒስራዔኤሌ ዴሮ ጋዳንቂፆ ማሊ ኔ ዒፄቴ ጋዳንቂያ ጋዳንቂፖ፤ ዓንጂያ ዓንጂፖ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ባኣላኣሜ ማሃዖ፦ «ታኣኒ፥ ናንጊና ናንጋ ጎዳ ታኣም ኬኤዜማ ሌሊ ጌስታንዳኔ ጌዒ ቤርታ ኔኤም ኬኤዚባይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ባኣላኣቄ ዒማና፦ «ሃኒ ሙኬ፥ ሜሌ ቤሲ ኑ ዓኣዾም፤ ጎዖንቴ ዒኢካ ኔ ማዔም ሃያ ዴሮ ጋዳንቃንዳጉዲ ፆኦሲ ኔና ዓይሣንዳያ ናንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ዬያሮ ባኣላኣቄ ባኣላኣሜ ዔኪ ዳውሎ ቦኦሎኮ ሆታ ዓኣ፥ ፔዖሬ ዹኮ ዑፆ ዔኪ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ባኣላኣሜ ዬካፓ፦ «ሃኖ ቤዞይዳ ሃሣ ፆኦሲም ዒንጎ ባኮ ዒንጎ ላንካይ ቤሲ ኮሺ፥ ላንካይ ዚያ ጌማይና ላንካይ ዓዴ ማራይ ታኣም ዔኪ ሙኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ባኣላኣቄ ዒማና ባኣላኣሜ ጌዔ ጎይፆ ማዼኔ፤ ፔቴ ፔቴ ሚቺ ዒንጎ ቤዞይዳ ፔቴ ፔቴ ዚያ ጌማይና ዓዴ ማራይ ሹኪ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ዒ ዓንጃንዳጉዲ ኮዔሢ ባኣላኣሜ ዔራዖ፥ ቤርታ ዒ ማዻ ጎይፆ ማርሾ ማርሻኒ ዳንዳዒባኣሴ፤ ጋዓንቴ ዓሲ ናንጉዋ ዳውሎ ባንሢ ሺሪ ዔቃዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ዒስራዔኤሌ ዴራ፥ ፔኤኮ ፃጶና ፃጶና ዎሊ ሄሊ ዱንኪ ዴዔሢ ዴንቄኔ፤ ዒማና ፆኦሲ ዓያና ዒዛይዳ ሙኬም፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ፆኦሲ ማሊሢ ሂዚ ጌይ ኬኤዚሢ ዓርቄኔ፦ «ዓኣፓ ቡሊንቴም ዛጌ ቢዖሬ ናኣዚ ባኣላኣሜ ኬኤዛ ባካ ያዺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ፆኦሲ ቃኣሎ ዋይዛሢ ቢያ ባኣዚ ዳንዳዓ ፆኦዛሢዳፓ ማዔ ጊንዑዋንቴ ጴዼ ዓውቶ ዛጋሢ ጊንዒ ዓኣንቴ ዓኣፓ ቡሊንቴሢ ሂዚ ጋዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ያይቆኦቤ! ኔኤኮ ዓፒሎና ማዢንቴ ማኣራ ዒስራዔኤሌ! ኔ ዎርቃ ቤዛ ዎዚ ሚዛጳይ! ");
INSERT INTO mdyeth_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ዬይ ማኣራ ፑኡሲንቴያ ማላ ዛሮጉዲ ዎሮ ዓጫ ዓኣ ዱማ ዱማ ሚፃ ባቃሌ ቤዞጉዲ ጌሢንቲ ዴዒ ዓኣኔ፤ ናንጊና ናንጋ ጎዳ ቱኬ ዋላንጎጉዲ ሃሣ ዋኣሢ ዓቺዳ ባቃሊ ዓኣ ዴኤሊ ዚቢቂጉዲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ሚርጌ ዒርዚ ዔያቶም ዋርቄኔ፤ ዔያታ ዜርቄ ባካ ጊዳንዳ ዋኣሢ ዴንቄኔ፤ ዔያቶኮ ካኣቲ ዓጋጌይዳፓ ባሼ ማዓንዳኔ፥ ዓጫ ዒዛኮ ሚርጌና ዳልጊ ዳልጊ ዓኣዻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ጊብፄ ዓጫፓ ዔያቶ ኬሴ ፆኦዛሢ ዔያቶኮ ሜኤኒ ካኣሪጉዲ ማዒ ሙካ ባኮ ዔያቶም ዹዓንዳኔ፤ ዔያቶኮ ሞርኮ ዔያታ ዞቢጉዲ ሾኦሊ ሙዓንዳኔ፤ ሜጌፆዋ ዔያቶኮ ጋኣጫንዳኔ፤ ሂዦዋ ዔያቶኮ ሜንሢ ባይዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ዬይ ዓሳ ዒጊቻ ዞቢጉዲ ላሂ ዓኣኔ፤ ዔያቶ ጴቺ ዔቂሳንዳ፥ ጫርሺ ዖናዳይ? ዒስራዔኤሌ ዓንጃሢ ዓንጂንቴያ ጋዳንቃሢያ ሃሣ ጋዳንቂንቴያ ማዖንጎ!» ");
INSERT INTO mdyeth_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ዬካፓ ባኣላኣቄ ሚርጌና ዻጋዺ፥ ፔ ኬኤሎ ዉፁርቃዖ ባኣላኣሜ ኮይላ፦ «ታኣኮ ሞርኮ ኔ ጋዳንቃንዳጉዲ ታ ኔና ዔኤላዛ፥ ኔ ጋዓንቴ ሃይሢ ማይንቲ ዓንጄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ዓካሪ፥ ኔ ማኣሪ ዑኬ ዓኣዼ፤ ኔ ማዼ ባኮ ዛሎኮ ኮይሳሢጉዴያ ታ ጪጋኒ ማሌንቴ ናንጊና ናንጋ ጎዳ ኔና ዬያ ኔ ዴንቁዋጉዲ ላኣጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ባኣላኣሜ ባኣላኣቄም፦ «ኔኤኒ ታ ኮይላ ዳኬ ዓሶም፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹ኔ ማኣሮይዳ ዓኣ ዎርቆና ቢሮና ቢያ ኔ ታኣም ዒንጌቴታዖ ፆኦሲ ጌዔማ ኬኤዚሢዳፓዓቴም ሜሌ ታ ማሊሢና ኮሺ ባኣዚያ ማዖም ፑርታ ባኣዚ ታ ማዻኒ ዳንዳዑዋሴ› ጌይ ታ ኬኤዚባይ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ጋፒንፆይዳ ባኣላኣሜ ባኣላኣቄም፦ «ዓካሪ፥ ታኣኒ ታ ዓሶ ባንሢ ማዒ ዴንዳኔ፤ ጋዓንቴ ዬያኮ ቤርታ ዒስራዔኤሌ ዴራ ሃጊ ኔ ዓሶ ማዻንዳ ባኮ ታ ኔኤም ኬኤዛንዳኔ» ጌዔስካፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ፆኦሲ ማሊሢ ሂዚ ጌይ ኬኤዚሢ ዓርቄኔ፦ «ቢዖሬ ናኣዚ፥ ባኣላኣሜ ኬኤዛ ባካ ዓኣፓ ቡሊንቴም ዛጌሢ ሂዚ ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ፆኦሲ ኬኤዜ ባኮ ዋይዛሢ ዼኤፖ ፆኦዛሢዳፓ ዔራቶ ዴንቄሢ ቢያ ባኮ ዳንዳዓሢ ፔጋሲ ዻዋ ባኮ ዛጋሢ ጊንዒ ዓኣንቴ ዓኣፓ ቡሊንቲ ዛጋሢ ሂዚ ጋዓኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ታ ዛጋኔ፤ ጋዓንቴ ሃሢቱዋሴ። ታኣም ጴዻኔ፥ ጋዓንቴ ዑኬቱዋሴ፤ ዦኦጌ ያይቆኦቤይዳፓ ኬስካንዳኔ፤ ዎልቄና ዓኣ ካኣቲ ዒስራዔኤሌፓ ኬስካንዳኔ፤ ሞዓኣቤ ዓሶኮ ሱኡጎ ጳርቃንዳኔ፤ ሞዓኣቤ ዒጊኒ ማዔ ሴኤቴ ዜርፆ ማዔ ዓቲንቆኮ ቶኦኮ ዳኣፃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ዔዶኦሜ ዓሶ ባሻንዳኔ፤ ዒዛኮ ሞርኮ ማዔ ሴኤሬ ዓሶዋ ባሻንዳኔ፤ ዬያይዲ ዒስራዔኤሌ ዓሳ ባባሻያ ማዒ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ዎይሣያ ያይቆኦቤይዳፓ ኬስካንዳኔ፤ ዬካ ካታማ ዓቴ ዓሶ ቢያ ዒ ባይዛንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ዬካፓ ሃሣ ባኣላኣሜ ዓማሌቄ ዓጮ ባንሢ ዛጊ ዛጊ፦ «ዓማሌቄ ዴሮ ቢያይዳፓ ባሻ ካኣቶኬ፤ ጋፒንፆይዳ ጋዓንቴ ዒ ባይቃንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ቄና ዓሶዋ ዛጋዖ ሃሣ፦ «ዒንሢ ናንጋ ቤዛ ጉሙርሳያኬ፤ ዒንሢ ማዤ ማኣራኣ ዔኤቢ ሄሉዋ ዼጌ ቤሲዳኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ዬይ ያዺ ማዔቴያ ዒንሢ ቄና ዓሳ ዓሶኦሬ ዒንሢ ባሺ ዲዒ ዔኬ ዎዶና ዒንሢ ባይቃንዳኔ» ጌይሢ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ሃሣ ዒ ኬኤዛዖ፦ «ካኣ! ፆኦሲ ዬያይዳዛ ዓይጎ ዓሲ ዓታንዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ኪቲሜ ኮይላፓ ዋኣሢ ካኣሚሌ ሙካንዳኔ፤ ዬያታ ሙኪ ዓሶኦሬንታ ዔቦኦሬያ ዓርቃንዳኔ፤ ጋዓንቴ ዔያታኣ ባይቃንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ዬካፓ ባኣላኣሜ ፔ ማኣሪ ማዒ ዓኣዻዛ፥ ባኣላኣቄያ ፔ ቤዞ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ዒስራዔኤሌ ዴራ ሺፂሜ ዶኦጮይዳ ዱንኪ ዴዔ ዎዶና ዔያቶኮ ዓቲንቃ ዒኢካ ዓኣ ሞዓኣቤ ላኣሎና ዎላ ዞኦስካ ኮኦሚሢ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ዬይ ላኣላ፦ ሞዓኣቤ ዓሳ ካኣሽካ ፆኦዞም ዒንጎና ሙዖ ሙዎም ዔያቶ ዔኤላዛ፥ ዔያታ ዬያ ሙዒ ፔዖሬ ዹኮይዳ ዓኣ ቤዓኣሌ ጌይንታ ካኣሽኮ ባኮም ዚጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ዬያሮ ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶ ዑፃ ዻጋዺ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ሙሴም፥ «ዒስራዔኤሌ ዓሶ ዑፃ ጎጳፓ ታ ዻጋዼ ዻጋ ሺማንዳጉዲ ዒስራዔኤሌ ዓሶኮ ሱኡጎ ቢያ ዔኪ ዓቦ ዹኡዞይዳ ዴሮ ቤርታ ኬሲ ዎዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ሙሴ ዒማና ዒስራዔኤሌ ዓሶኮ ሱኡጎ፦ «ዒንሢ ፔቴ ፔቴሢ ዒንሢኮ ፃጳፓ ፃጳፓ ቤዓኣሌ ጌይንታ ፔዖሬ ፆኦዞም ዚጌ ዓሶ ቢያ ዎዹዋቴ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ዬያሮ ሙሴንታ ዴሮ ቢያሢንታ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካራ ቡኪ ዖዪ ዬኤካንቴ ፔቴ ዒስራዔኤሌ ዓሲስኬይ ፔቴ ዔዶኦሜ ዓጪ ላኣሊስኬኖ ዔያቶ ኮይሊና ዔኪ ፔ ማኣሪ ጌሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ቄኤሳሢ ዓኣሮኔኮ ናኣዚ ናይ ማዔ፥ ፒንሃሴ ጎዖሢ ዬያ ዴንቃዖ ዴሮ ባኣካ ዴዔ ቤዛፓ ዔቂ ዴንዲ ዎርሢ ዔኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ዬያ ዓሢና ላኣሌሎና ዓኣ ማኣሮ ጌሊ፥ ላምዓሢ ፔቴና ዎርሣ ዶርቢ ጫርጊ ዎዼኔ፤ ዬያይዳፓ ዔቄያና ዒስራዔኤሌ ዓሶ ኩርሳ ዶርዓሢ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ጋዓንቴ ዬማ ሄላንዳኣና ዬይ ዶርዓሢ ዴሮይዳፓ ላማታሚ ዖይዶ ሺያ ዓሲ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«ቄኤሳሢ ዓኣሮኔኮ ናኣዚ ዓላዜሬ ናይ ማዔ፥ ፒንሃሴ ማዼ ባኮ ዛሎና ዒስራዔኤሌ ዓሶ ዑፃ ታኣኮ ዔቄ ዻጋ ሺሜኔ፤ ታና ሃሺ ሜሌ ፆኦዞም ዚጋ ዓሶ ፒንሃሴ ዚቲ ጌይ ዛጋኒ ኮዒባኣሴ፤ ታኣኒያ ዒስራዔኤሌ ዓሶ ባይዚባኣሢ ዒዚ ታ ጋቴ ሚጪንቲ ማዼ ማዾ ዛሎሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ዬያሮ ታ ዒዛና ዎላ ናንጊና ዶዲ ናንጋ፥ ኮሹሞ ጫኣቁሞ ጫኣቃንዳሢ ዒዛም ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ዒዚ ታጊዳፓ ዓቴም ሜሌ ፆኦሲ ካኣሽኪንታንዳጉዲ ኮዒባኣሢሮ፤ ሃሣ ዒስራዔኤሌ ዓሶኮዋ ጎሞ ጌኤሼሢሮ ዒዛና ዒዛኮ ዜርፆና ጉቤ ናንጊና ቄኤሴ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ሚዲያሜ ዓጮ ላኣሌሎና ዎላ ዎዺንቴ፥ ዒስራዔኤሌ ዓሢኮ ሱንፃ ሳሉ ናኣዚ ዚምሪ ጌይንታያ ማዓዛ ዒዚ ሲሞኦኔ ማኣሮይዳ ፔቴ ቶኦኪኮ ሱኡጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ላኣሌሎ ሱንፃ ኮዚቤ ጌይንታኔ፤ ዒዞኮ ዓዶ «ሱኡሪ» ጎዖሢ ፔቴይዳ ናንጋ ዻካ ሚዲያሜ ዓሲኮ ሱኡጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«ሚዲያሜ ዓሶይዳ ዖልዚ ቡሊ ዔያቶ ባይዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ዬያ ዒንሢ ማዻንዳሢ ፔዖሬ ካኣሽካንዳጉዲ ዒንሢ ዔያታ ጌሺ፥ ማዼ ጌኖ ማዾ ዛሎሮ ሃሣ ዒንሢ ፔዖሬ ካሽኬሢሮ ዴሮይዳ ኬዴ ሃርጎ ዛሎና ዎዺንቴ ዔያቶኮ ሱኡጋሢ ናዎ ኮዚቤ ዛሎና ዔያታ ጌሼ ጌሺፆሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ዬይ ዎዻ ዶርዓሢ ዔቄስካፓ ናንጊና ናንጋ ጎዳ ሙሴና ቄኤሳሢ ዓኣሮኔ ናኣዚ ዓላዜሬናም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«ዒስራዔኤሌ ዴሮ ቢያሢኮ ማኣሮይዳ ማኣሮይዳ ሌዓ ላማታሚ ኩሜያና ዬካፓ ዑሣ ማዔያ፥ ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቆ ቢያ ፓይዱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ሙሴና ቄኤሳሢ ዓላዜሬና ዮርዳኖሴ ዎሮ ዓጫ፥ ዒያርኮኮ ሆታ ዓኣ ሞዓኣቤ ቦኦሎይዳ ዴሮ ቡኩሳዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ላማታሚ ሌዔና ዬካፓ ዑሣ ዓኣዼ ሌዔ ማዔ ዓቲንቆ ቢያ ፓይዱዋቴ» ጌዔኔ። ጊብፄ ዓጫፓ ኬስኬ፥ ዒስራዔኤሌ ዓሳ ሃካፓ ሊካ ፓይዲንታ ዓሶኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ያይቆኦቤኮ ናኣዚ ቶይዲ፥ ሮኦቤኤሌ ማኣራፓ ፓይዲንቴ ቶኦካ ሃኖኬ ዓሳ፥ ፓሉ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ሄፂሮኔ ዓሶንታ ኬርሚ ዓሶንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ዖይዲታሚ ሃይሦ ሺያና ላንካይ ፄኤታና ሃይሢታሚናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ፓሉ ዜርፃ ዔኤሊያቤና ");
INSERT INTO mdyeth_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ዔኤሊያቤኮ ናኣቶናኬ፤ ዬያታ ኔሙዔኤሌንታ ዳኣታኔንታ ዓቤሮሜንታኬ፤ ዳኣታኔና ዓቤሮሜና ሃያኮ ቤርታ ዴራ ዶኦሬዞንሢ ማዓዛ ዔያታ ቆራሄና ዒዛና ዎላ ፔቴ ማዔ ዓሶና ባኣኮ ጌሊ ፆኦሲም ዋይዞ ዒፄ ዎዶና ሙሴና ዓኣሮኔና ዔያታ ሜታሴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ዒማና ዔያቶ ሳዓ ዳርዒ፥ ቆራሄንታ ዎላ ዔኤዼኔ፤ ዔያታ ሃይቃማና ታሚ ኬዲ ላምዖ ፄኤታና ዶንጊንታሚ ዓሲ ሙዔኔ፤ ዬያይዲፆና ዔያታ ዴሮም ዒንሢና ዔሩዋቴ ጋዓ ማላታ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ቆራሄ ናኣታ ጋዓንቴ ዒማና ሃይቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ሲሞኦኔ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ኔሙዔኤሌ ዓሳ፥ ያሚኔ ዓሳ፥ ያኪኔ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ዛራሄ ዓሶንታ ሻዑሌ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ላማታሚ ላምዖ ሺያና ላምዖ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ጋኣዴ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ፂፖኔ ዓሳ፥ ሃጊ ዓሳ፥ ሹኒ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ዖዚኒ ዓሳ፥ ዔሪ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ዓሮዴ ዓሶንታ ዓርዔኤሌ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ዖይዲታሚ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ዪሁዳ ማኣራፓ ዔኤሬና ዓውናኔና ካኣናኔ ዓጮይዳ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ሃንጎ ዪሁዳ ናኣታ፦ ሼላ ዓሶንታ ፓሬሴ ዓሶንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ፓሬሴ ናኣታ፦ ሄፂሮኔና ሃሙሊ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ላንካይታሚ ላሆ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ዪሳኮኦሬ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ቶላዒ ዓሳ፥ ፑዋ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ያሹቤና ሼምሮኔ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ላሂታሚ ዖይዶ ሺያና ሃይሦ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ዛብሎኦኔ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ሴሬዴ ዓሳ፥ ዔሎኔና ያህሊዔኤሌ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ላሂታሚ ሺያና ዶንጎ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ዮሴፔ ዜርፃፓ ማዔ ሚናኣሴና ዔፕሬኤሜ ዛሎና ሾይንቴ ቶኦካ ሃካፓ ሊካ ዓኣዞንሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ሚናኣሴ ማኣራፓ፦ ሚናኣሴ ናኣዚ ማኪሬ ጌሌዓዴ ሾዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ጌሌዓዴ ናኣታ፦ ዒዔዜሬ ዓሳ፥ ሄሌቄ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ዓስሪዔሌ ዓሳ፥ ሼኬሜ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ሼሚዳ ዓሶንታ ሄፔሬ ዓሶንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ሄፔሬ ናኣዚ ፄሎፒሃዴኮ ዉዱሮ ናይ ሌሊኬ፥ ዓቲንቄ ናይ ባኣሴ፤ ዬያታ፦ ማሂላ፥ ኖዓ፥ ሆግላ፥ ሚልካንታ ቲርፃ ጎዖዞንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዶንጊታሚ ላምዖ ሺያና ላንካይ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ዔፕሬኤሜ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ሹቱላሄ ዓሳ፥ ቤኬርኔ ዓሶንታ ታሃኔ ዓሶንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ሹቱላሄ ዓሳ፦ ዔራኔና ናኣቶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ሃይሢታሚ ላምዖ ሺያና ዶንጎ ፄኤታናኬ፤ ዬያታ ቢያ ዮሴፔ ዜርፆኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ቢኢኒያሜ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ቤላዔ ዓሳ፥ ዓሽቤሌ ዓሳ፥ ዓሂራሜ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ሹፓሜ ዓሶና ሁፓሜ ዓሶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ቤላዔ ዜርፃ፦ ዓርዲና ናዕማኔ ዓሶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ዬኖ ቶኦካፓ ቶኦካፓ ፓይዲንቴ ዓቲንቆኮ ፓይዳ ዖይዲታሚ ዶንጎ ሺያና ላሆ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ዳኣኔ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ሹሃሜና ዒዛኮ ናኣቶናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ዬያቶይዳፓ ፓይዲንቴ ዓቲንቃ ላሂታሚ ዖይዶ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ዓሴኤሬ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ዪሞና ዓሳ፥ ዪሺዊ ዓሶንታ ቤሪዓ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ቤሪዓ ዜርፃ፦ ሄቤሪ ዓሶና ማልኪዔኤሌ ዓሶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ዓሴሪሜኮ ሴራሂ ጌይንታ ዉዱሮ ናይ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ዬኖ ዓሶኮ ዓቲንቆ ፓይዳ ዎሊ ዑፃ ዶንጊታሚ ሃይሦ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ኒፕታሌሜ ማኣራፓ ፓይዲንቴ ቶኦካ፦ ያህፂዔኤሌ ዓሳ፥ ጉኒ ዓሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ዬፅሬ ዓሶና ሺሌሜ ዓሶናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ዬኖ ዓሶኮ ዓቲንቃ ዎሊ ዑፃ ዖይዲታሚ ዶንጎ ሺያና ዖይዶ ፄኤታናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ዬያይዲ ፓይዲንቴ ዒስራዔኤሌ ዓሶኮ ዓቲንቆ ፓይዳ ላሆ ፄኤታና ፔቴ ሺያና ላንካይ ፄኤታና ሃይሢታሚናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«ሳዔሎ ዔያቶኮ ሱንፃ ፃኣፒንቴ ጎይፆና ፔቴ ፔቴ ማኣሮም ዔያቶ ሳዓ ማሂ ማሂ ጊሽኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ሚርጌ ዓሳ ዓኣ ማኣሮም ዳልጊ ሳዓ፥ ዻካ ዓሲ ዓኣ ማኣሮም ዻካ ሳዓ ዒንጌ፤ ዔያቶም ኔ ሳዖ ጊሽካንዳሢ ዴራ ፓይዲንቲ ዔርቴ ፓይዶ ጎይፆናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ጋዓንቴ ኔኤኒ ጊዦ ጊሽካንዳሢ ዒፃ ዓጊኬ፤ ዬይ ዓጊንታንዳሢ ፔቴ ፔቴ ማኣሮ ሱንፆናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ዒፃሢ ዓጊንታኣና ዻኮ ዴሮም ዻኮ ጎይፆና ዺቦ ዴሮም ዺቦ ጎይፆና ዓጊንቶም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ሌዊ ማኣራፓ ፓይዲንቴ ዓሳ፦ ጌርሾኔ ዓሳ፥ ቄዓቴ ዓሶና ሜራሪ ዓሶናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ዬያቶኮ ዜርፃ፦ ሊቢኒ ዓሳ፥ ኬብሮ ዓሳ፥ ማሂሊ ዓሳ፥ ሙሺ ዓሶና ቆራሄ ዓሶናኬ፤ ቄዓቴ ዓምራሜ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ዓምራሜ ጊብፄ ዓጮይዳ ሾይንቴ ሌዊ ናዎ ዮኬቤዴ ጎዖዞ ዔኬም ዒዛ ሙሴና ዓኣሮኔና ጌይንታ ላምዖ ዓቲንቄ ናይንታ ማይራሞ ጌይንታ ፔቴ ዉዱሮ ናይስኬኖዋ ሾዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ዓኣሮኔኮ ናኣዳኣቤ፥ ዓቢሁ፥ ዓላዜሬና ዒታማሬ ጌይንታ ዖይዶ ዓቲንቄ ናይ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ናኣዳኣቤና ዓቢሁና ፆኦሲም ዱማዺባኣ ታሞ ናንጊና ናንጋ ጎዳም ሺኢሺፆና ዶርዖ ዔኪ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ሌዓ ፔቴ ዓጊኒና ዬካፓ ዑሣ ማዔ፥ ሌዊ ዓሶ ዓቲንቆኮ ፓይዳ ዎሊ ዑፃ ላማታሚ ሃይሦ ሺያኬ፤ ዔያታ ሃንጎ ዒስራዔኤሌ ዓሶይዳፓ ዱማሲ ፃኣፒንቴኔ፤ ዬይ ያዺ ማዔሢ ዒስራዔኤሌ ዓጮይዳ ፔቴታዖ ዔያቶሮ ማዔ ሳዓ ዒንጊንቲባኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ሙሴና ዓላዜሬና ዒያርኮኮ ሆታ፥ ዮርዳኖሴ ዎሮኮ ኮይላ ዓኣ ሞዓኣቤ ቦኦሎይዳ ዒስራዔኤሌ ዓሶ ፓይዴ ዎዶና ዔያታ ፃኣፔ ፔቴ ፔቴ ቶኦኮኮ ሱኡጋ ዬያቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ሲና ቦኦሎይዳ ባራሪ ዴራ ፓይዲንቴ ዎዶና ሙሴና ዓኣሮኔና ፃኣፔ ዓቲንቆይዳፓ ፔቴታዖ ዓሲ ዓቲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ዬይ ያዺ ማዔሢ «ቢያሢ ዓሲ ናንጉዋ ዳውሎይዳ ሃይቃንዳኔ» ጌይ ቤርታ ፆኦሲ ኬኤዜሢሮኬ፤ ዬያሮ ዬፑኔ ናኣዚ ካኣሌቤና ኔዊ ናኣዚ ዒያሱናፓ ዓታዛ ቢያሢ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ሚናኣሴ ናይ፥ ማኪሬ ናይ፥ ጌሌዓዴ ናይ፥ ሄፔሬ ናይ ማዔ ፄሎፒሃዴኮ ዉዱሮ ናኣቶንሢ፦ ማሂላ፥ ኖዓ፥ ሆግላ፥ ሚልካንታ ቲርፃ ጌይንታያኬ፤ ዬያታ ዮሴፔ ናኣዚ ሚናኣሴ ቶኦኪ ማዔያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ዓፒሎና ማዢንቴ፥ ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ዔያታ ሙኪ ዴሮ ጉቤሢና ዴሮኮ ሱኡጎና፤ ሃሣ ሙሴና ዓላዜሬና ቤርቶ ሺኢኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«ኑ ዓዳሢ ፔቴታዖ ዓቲንቄ ናይ ሹውዋዖ ዓሲ ናንጉዋ ዳውሎይዳ ሃይቄኔ፤ ዒዚ ፆኦሲም ዓይሢንቲፆ ዒፄ፥ ቆራሄ ዓሶና ዎላ ፔቴ ማዔያቱዋሴ፤ ዒዚ ሃይቄሢ ፔ ጎሜናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ዓካሪ፤ ዒዚ ዓቲንቄ ናይ ሾዒባኣሢሮ ሌሊ ዒስራዔኤሌ ዓሶ ባኣካፓ ሱንፃ ዒዛኮ ባይቃንዳያ ኮይሳ? ዬያሮ ኑ ዓዶ ፃጶ ባኣካ ኑም ማዓ ሳዓ ዒንጊንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ሙሴ ዬያ ዔያቶኮ ዖኦጪፆ ናንጊና ናንጋ ጎዳም ሺኢሻዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«ፄሎፒሃዴ ናኣታ ዖኦጬ ዖኦጪፃ ፒዜኬ፤ ዬያሮ ዔያቶ ዓዶ ፃጶ ባኣካፓ ዔያቶ ሄላ ዛሎ ዔያቶም ዻካልሳኒ ኮይሳሢሮ ዔያቶኮ ዓዶ ሄላንዳ ባኮ ዔያቶም ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ዓቲንቄ ናይ ሹውዋዖ ሃይቄ ዓሲ ዓኣቶ ዉዱሮ ናይ ዓዶኮ ዓኣ ባኮ ዻካላኒ ኮይሳያታሢ ዒስራዔኤሌ ዴሮም ዔርዜ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ዉዱሮ ናይ ባኣቴ ሃይቄሢኮ ጌርሲንሢ፥ ዒዛኮ ዓኣ ባኮ ዻካሎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ጌርሲንሢያ ዒዛኮ ባኣቴ ዒዛኮ ዓዶ ጌኤዚታቴያ ዓዶ ዒሼ ዻካሎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ዓዶ ጌኤዛቲታቴያ ዓዶ ዒሾ ማዓይ ባኣቴ ዑኬ ዒጊኒ ማዔ ዓሲ ዒዛ ባኮ ዻካላኒ ዳንዳዓኔ። ታኣኒ፥ ናንጊና ናንጋ ጎዳ ኔና ዓይሤ ጎይፆ ዒስራዔኤሌ ዴራ ዬያ ዎጎ ማዺ ማዺ ናንጋያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ሌካ ዓባሪሜ ዹኮ ኬስኪ፥ ዒስራዔኤሌም ታ ዒንጋ ዓጮ ቢያ ዛጌ! ");
INSERT INTO mdyeth_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ዬያ ኔ ዛጌስካፓ ኔ ዒሼ ዓኣሮኔ ሃይቄሢጉዲ ኔኤኒያ ሃይቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ዓይጎሮ ጌዔቴ ዒንሢ ላምዖንሢ ፂኢኔ ቦኦሎይዳ ሜሪባ ጎዖ ቤዛ ዴራ ታኣም ዓይሢንቶ ዒፄ ዎዶና ታኣኮ ዱማዼያ ማዔ ዎልቆ ፔጋሲ ዻዎ ዒፄሢሮኬ» ጌዔኔ። (ሜሪባ ፂኢኔ ቦኦላ፥ ቃዴሴይዳ ዓኣ ዋኣሢ ዓልቃ ቤሲኬ።) ");
INSERT INTO mdyeth_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ሙሴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«ዓሲ ማዢንቲም ቢያ ሼምፖ ዒንጋ ናንጊና ናንጋ ጎዳ ማዔ ፆኦዛሢዮ! ሃያ ዴሮ ዔኪ ዓኣዻንዳያና፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ዖልዚ ሙኬቴያ ዖሊሳኒ ዳንዳዓ፥ ፔቴ ዓሲ ዶኦሬ፤ ኔ ዬያይዴቴ ኔኤኮ ዴራ ሄንቃ ዓሲባኣ ማራይጉዲ ማዓዓኬ» ጌይ ናንጊና ናንጋ ጎዳ ሺኢቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ዬያሮ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዓያና ጌኤሺ ዎልቄ ዒዛና ዓኣ፥ ኔዊ ናዓሢ ዒያሱ ዔኪጋፓ ኔ ኩጮ ዒዛ ቶኦካ ጌሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ቄኤሳሢ ዓላዜሬንታ ዴሮ ቢያሢ ቤርታ ዒዛ ዔቂሲ፥ ኔ ቤዛ ዒ ዶኦሪንቴያ ማዔሢ ዔርዜ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ዒስራዔኤሌ ዴራ ቢያ ዒዛም ዓይሢንታንዳጉዲ ኔ ቢታንቶጉዴ ቢታንቶ ዒዛም ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ቄኤሳሢ ዓላዜሬ ታ ማሊፆ ዱማሲ ዔርዛ ባኮና ታ ማሊፆ ዔራያታሢሮ ዒዚ ዒያሱ ማኣዳንዳኔ፤ ዬያይዲ ዓላዜሬ ዒያሱንታ ዒስራዔኤሌ ዴሮ ቢያሢ ዔያታ ማዻ ባኮ ቢያ ዻዋያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ሙሴ ማዼኔ፤ ዒያሱዋ ዔኪ ሙኪ ቄኤሳሢ ዓላዜሬንታ ዴሮ ቢያሢንታ ቤርታ ዔቂሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ዬካፓ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ፔኤኮ ኩጮ ዒያሱ ቶኦካ ጌሢ ዒዛ ቤዛ ዶኦሪንቴያ ማዔሢ ዴሮም ዔርዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ናንጊና ናንጋ ጎዳ ሙሴም ኬኤዛዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«ዒስራዔኤሌ ዴሮም ኔ ዓይሣንዳ ዓይሢፃ ያዺኬ፤ ሳዋ ታና ዎዛሳያ፥ ታሚና ሚቺ ዒንጊንታ ሙኡዚ ዒንጊሢ ታኣም ዒንጋንዳጉዲ ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«ታኣም ዒንጊሢ ማዒ ታሚና ሚቺንቲ ዒንጊንታንዳ ባካ ሃካፓ ሊካ ኬኤዚንታሢኬ፦ ቢያ ኬሊ ዒንጊንታንዳ፥ ሚቺ ዒንጎ ዒንጊፆም ፔቴ ሌዔ ማዔ ቦሂሳ ባኣዚባኣ ላምዖ ዓዴ ማራናይ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ፔቴ ማራናዓሢ ጉቴ፤ ባጋሢ ዒባናኣና ዒንጊንታዳጉዲ ማሁዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ፔቴ ፔቴ ማራናኣቶና ዎላ ፔቴ ዶሎዜ ማዓ ቃራ ሪሚቲ ዛይቴና ዲርኪንቴ ፔቴ ኪሎ ኩሙሢ ሺኢቺ ዺኢሊ ዒንጊንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ዬይ፦ ጉቤና ሚቺንታ፥ ቢያ ኬሊ ዒንጎ ዒንጊሢኬ፤ ዬያጉዴ ዒንጊፆኮ ሳዋ ታና፥ ናንጊና ናንጋ ጎዳሢ ዎዛሳ ሙኡዚ ዒንጊሢ ማሂ ቤርታዺ ዒንጊንቴሢ ሲና ዹኮይዳኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ቤርታ ዒንጊንታ ማራናዖና ዎላ ዑሺ ዒንጊሢ ማዒ ዒንጊንታዳጉዲ ፔቴ ዶሎዜ ማዓ ዎይኔ ዑሺ ሚቺ ዒንጎ ቤዛ ዋሁዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ሳዓ ዒባናኣና ላምዓሳ ማራናዓሢ ቤርታኣሲ ማዼማ ጎይፆ ዎይኖ ዑዦዋ ጊዳ ዋሂ ዒንጉዋቴ፤ ዬያኮ ሳዋ ታና ዎዛሳ ሙኡዚ ዒንጊሢ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«ሃውሾ ኬሎና ፔቴ ሌዔ ማዔ፥ ቦሂሳ ባኣዚባኣ ላምዖ ማራናይ ዔኪ ሺኢሹዋቴ፤ ሪሚቶ ዛይቶና ዲርኪንቴ ላምዖ ኪሎ ዺኢሊያ ሃኣኮ ዒንጊሢ ማሂ ዔኪ ሺኢሹዋቴ፤ ዬያጉዲ ዑዦ ዒንጊፆዋ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ዑዦ ዒንጊፆና ዎላ ቢያ ኬሊ ዒንጊንታ ዒንጊፆይዳ ቃሲሢ ማዒ ዬይ ሚቺ ዒንጎ ዒንጊፃ ሃውሾ ኬሎና ኬሎና ዒንጊንታያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«ፔቴ ፔቴ ዓጊኖኮ ቤርታሳ ኬሎና ሚቺ ዒንጎ ዒንጊፆ ታኣም ዒንጉዋቴ፤ ዬይያ፦ ቦሂሳ ባኣዚባኣ ላምዖ ዎፓና፥ ፔቴ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ላንካይ ዓዴ ማራናይ ዔኪ ሺኢሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ሃኣኮ ዒንጊፆም ማዓንዳጉዲ ሪሚቲ ዛይቴና ዲርኪንቴ ሺኢቺ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ዬይያ፦ ፔቴ ፔቴ ዎፓኖና ዎላ ሃይሦ ኪሎ ዺኢሊ፥ ዓዶ ማራዓሢና ዎላ ላምዖ ኪሎ ዲኢሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ፔቴ ፔቴ ዓዶ ማራናኣቶና ዎላ ዛይቴና ዲርኪንቴ ፔቴ ኪሎ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ዬይ ሚቺ ዒንጎ ዒንጊፃ ቢያ ሳዋ ታና ዎዛሳ ሙኡዚ ዒንጊሢ ማዒ ዒንጊንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ኮይሳያ ማዔ ዎይኔ ዑሺ ዒንጊሢ ማሂ ፔቴ ፔቴ ዎፓኖና ዎላ ላምዖ ዶሎዜ ዎይኔ ዑሺ፥ ዓዶ ማራዓሢና ዎላ ፔቴ ዶሎዜና ዛላና ማዓ ዎይኔ ዑሺ፥ ፔቴ ፔቴ ማራናኣቶና ዎላ ፔቴ ዶሎዜ ዎይኔ ዑሺ ዒንጉዋቴ፤ ሌዖ ጉቤይዳ ፄኤራ ዓጊኖኮ ቤርታሳ ኬሎማይዳ ዒንጊንታ ሚቺ ዒንጊፆ ዛሎ ዓይሢንቴ ዳምባ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ዎይኖ ዑዦ ዒንጊፆና ዎላ ቢያ ኬሊ ዒንጊንታ ሚቺ ዒንጊፆኮ ጊዳ ቃሲ ፔቴ ኮላይ ጎሜ ጌኤሻያ ማሂ ዒንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«ናንጊና ናንጋ ጎዳኮ ዑሣ ዓኣዺፆ ቦንቾ ኬላ ቦንቺንታንዳሢ ቤርታሳ ዓጊና ፄኤሬስካፓ ታጶ ዖይዳሳ ኬሎና ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ታጶ ዶንጋሳ ኬላ ቦንቾ ኬሊ ማዔሢሮ ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ ሌሊ ሙይንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ቦንቾ ኬሎኮ ቤርታኣ ዓቦ ታና ካኣሽካኒ ቡኩዋቴ፤ ዬኖ ኬሎይዳ ዓይጎ ማዾዋ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ሳዋ ታና ዎዛሳ፥ ሚቺ ዒንጎ ሙኡዚ ዒንጊሢ ዒንጉዋቴ፤ ዬይያ፦ ቦሂሳ ባኣዚባኣ ላምዖ ዎፓና፥ ፔቴ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ላንካይ ዓዴ ማራናይ ዔኪ ሺኢሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ኮይሳያ ማዔ ሃኣኮ ዒንጊፆ ማዓንዳጉዲ፦ ሪሚቲ ዛይቴና ዲርኪንቴ ሺኢቺ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ዬይያ፦ ፔቴ ፔቴ ዎፓኖና ዎላ ሃይሦ ኪሎ ዺኢሊ፥ ዓዶ ማራዓሢና ዎላ ላምዖ ኪሎ ዺኢሊ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ፔቴ ፔቴ ማራናኣቶና ዎላ ፔቴ ኪሎ ዺኢሊ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ጎሜ ጌኤሺሢ ዛላ ማዓንዳ ፔቴ ኮላይ ዒንጉዋቴ፤ ዬይ ጎሜ ጌኤሻ ዒንጊሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ዬንሢ ዒንጊፃ ዒንጊንታዳሢ ቢያ ኬሊ ጉቴ ጉቴ ዒንጊንታ ሚቺ ዒንጎ ዒንጊፆይዳ ቃሲሢ ማዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ሳዋ ታና ዎዛሳ ሙዖ ዒንጊፆ ዒማ ጎይፆ ላንካዎ ኬሎይዳ ቢያ ዒንጉዋቴ፤ ዬያ ዒንሢ ዒንጋንዳሢ ቢያ ኬሊ ዒንጊንታ ሚቺ ዒንጎ ዒንጊፆና ዎይኖ ዑዦ ዒንጊፆናይዳ ቃሲሢ ማሂኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ላንካሳ ኬሎና ታና ካኣሽካኒ ቡኩዋቴ፤ ዬኖ ኬሎ ዓይጎ ማዾዋ ማዺፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«ማኣሎ ቡሪፆ ቦንቾኮ ቤርታሳ ኬሎና ዓኮ ሃኣኮ ታኣም ዒንሢ ዒንጋ ዎዶና ታና ካኣሽካኒ ቡኩዋቴ፥ ማዾዋ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ዒዞና ላምዖ ዎፓና፥ ፔቴ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ላንካይ ዓዴ ማራይ ሳዋ ታና ዎዛሳ ሚቺ ዒንጎ ዒንጊሢ ማሂ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ኮይሳያ ማዔ ሃኣኮ ዒንጊፆ ማዓንዳጉዲ ሪሚቲ ዛይቴና ዲርኪንቴ ሺኢቺ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ዬይያ፦ ፔቴ ፔቴ ዎፓኖና ዎላ ሃይሦ ኪሎ ዺኢሊ፥ ዓዶ ማራዓሢና ዎላ ላምዖ ኪሎ ዺኢሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ፔቴ ፔቴ ማራናኣቶና ዎላ ፔቴ ሙርሳ ዺኢሊ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ጎሜ ጌኤሺሢም ማዓንዳ ፔቴ ኮላይ ዒንጉዋቴ፤ ዬያይዲ ዴሮኮ ጎሞ ጌኤሺፆ ዳምቦ ኩንሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ዬያ ቢያ ዒንጎ ዒንጊፆና ዑዦ ዒንጊፆ፦ ቢያ ኬሊ ዒንጊንታ ሚቺ ዒንጎሢንታ ሃኣኮ ዒንጊፆንታይዳ ቃሲሢ ማሂ ዒንጉዋቴ፤ ዬና ቆልማ ቦሂሳ ባኣዚ ባኣያ ማዒፆ ኮሺ ዛጊ ዔሩዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«ላንካሳ ዓጊና ፄኤራዛ ቤርታሳ ኬሎ ታና ካኣሽካኒ ቡኩዋቴ፤ ዓይጎዋ ማዾ ማዺፖቴ፤ ዬኖ ኬሎ ዛዬ ዋርቂንቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ቦሂሳ ባኣዚባኣ ፔቴ ዎፓና፥ ፔቴ ዓዴ ማራይ፥ ፔቴ ሌዔ ኩሜ ላንካይ ዓዴ ማራናይ፤ ሳዋ ታና ዎዛሳ፥ ሚቺ ዒንጎ ዒንጊሢ ማሂ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ኮይሳያ ማዔ ሃኣኮ ዒንጊሢ ማዓንዳጉዲ ሪሚቲ ዛይቴና ዲርኪንቴ ሺኢቺ ዺኢሊ ዒንጉዋቴ፤ ዬይያ፦ ዎፓናሢና ዎላ ሃይሦ ኪሎ ዺኢሊ፥ ዓዶ ማራዓሢና ዎላ ላምዖ ኪሎ ዺኢሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ፔቴ ፔቴ ማራናኣቶና ዎላ ፔቴ ፔቴ ሙርሳ ዺኢሊ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ጎሜ ጌኤሺሢ ዛላ ማዓ ፔቴ ኮላይ ዒንጉዋቴ፤ ዬያይዲ ዴሮኮ ጎሞ ጌኤሺፆ ዳምቦ ኩንሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ዬያ ቢያ ዒንጊፆ፦ ዓጊና ዓጊና ቤርታሳ ኬሎይዳ ዒንጊንታ ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታይዳ፤ ሃሣ ቢያ ኬሊ ዒንጊንታ ሳዋ ታና ዎዛሳ ሚቺ ዒንጎ ዒንጊፆንታ ዑዦ ዒንጊፆንታይዳ ቃሲሢ ማሂ ዒንጉዋቴ፤ ዬይ ሳዋ ታና ዎዛሳ ሙኡዚ ዒንጊሢ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«ላንካሳ ዓጊና ፄኤሬስካፓ ታጳሳ ኬሎና ታና ካኣሽካኒ ቡኩዋቴ፤ ዬኖ ኬሎ ሙኡዚ ሙዒፖቴ፤ ማዾዋ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ቦሂሳ ባኣዚባኣ ፔቴ ዎፓና፥ ፔቴ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ላንካይ ዓዴ ማራናይ፤ ሳዋ ታና ዎዛሳ ሚቺ ዒንጎያ ማሂ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ኮይሳያ ማዔ ሃኣኮ ዒንጊፆ ማዓንዳጉዲ ሪሚቲ ዛይቴና ዲርኪንቴ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ዬይያ፦ ዎፓናሢና ዎላ ሃይሦ ኪሎ ዺኢሊ፥ ማራዓሢና ዎላ ላምዖ ኪሎ ዺኢሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ፔቴ ፔቴ ማራናኣቶና ዎላ ፔቴ ሙርሳ ዺኢሊ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ጎሜ ጌኤሺሢሮ ማዓንዳጉዲ ፔቴ ኮላይ ዒንጉዋቴ፤ ዬይ ዴሮኮ ጎሞ ጌኤሺፆ ዳምባ ኩንሢንታኣና ዒንጊንታ ኮሌና ሃኣኮ ዒንጊፆና ዑዦ ዒንጊፆናይዳ፤ ሃሣ ቢያ ኬሊ ዒንጊንታ ሚቺ ዒንጎሢዳ ቃሲ ዒንጊንታንዳያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«ላንካሳ ዓጊና ፄኤራዛ ታጶ ዶንጋሳ ኬሎና ፔቴይዳ ታና ካኣሽካኒ ቡኪንቱዋቴ፤ ዬኖ ቦንቾ ታና ቦንቺሢና ላንካይ ኬሊ ቦንቹዋቴ፤ ዬኖ ኬሎ ፔቴታዖ ማዾ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ዬያ ቦንቾኮ ቤርታሳ ኬሎና ቦሂሳ ባኣዚባኣ ታጶ ሃይሦ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ታጶ ዖይዶ ዓዴ ማራናይ፤ ሳዋ ታና ዎዛሳያ ማዓ ሙኡዚ ዒንጊሢ ማሂ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ኮይሳያ ማዔ ሃኣኮ ዒንጊፆ ማዓንዳጉዲ ሪሚቶ ዛይቶና ዲርኪንቴ ሺኢቺ ዺኢሊ ዔኪ ሺኢሹዋቴ፤ ዬይያ፦ ፔቴ ፔቴ ዎፓኖና ዎላ ሃይሦ ኪሎ ዺኢሊ፥ ፔቴ ፔቴ ዓዶ ማራቶና ዎላ ላምዖ ኪሎ ዺኢሊ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ፔቴ ፔቴ ዓዶ ማራናኣቶና ዎላ ፔቴ ሙርሳ ዺኢሊ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ጎሜ ጌኤሺሢሮ ማዓንዳ ፔቴ ኮላይ ዒንጉዋቴ፤ ዬያ ዒንጊፆ ቢያ ዒንሢ ዒንጋንዳሢ ቢያ ኬሊ ሚቺ ዒንጊንታ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲሢ ማሂኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«ላምዓሳ ኬሎና ዓይጌያ ቦሂሳ ባኣዚባኣ ታጶ ላምዖ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ኩሜ ታጶ ዖይዶ ዓዴ ማራናይ ዔኪ ሺኢሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ሃኣኮ ዒንጊፆና ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ዓዶ ማራናኣቶና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«ሃይሣሳ ኬሎና ቦሂሳ ባኣዚባኣ ታጶ ፔቴ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ታጶ ዖይዶ ዓዴ ማራናይ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ሃኣኮ ዒንጊፆንታ ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ዓዶ ማራናኣቶና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ፤» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«ዖይዳሳ ኬሎና ቦሂሳ ባኣዚባኣ ታጶ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ታጶ ዖይዶ ዓዴ ማራናይ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ሃኣኮ ዒንጊፆንታ ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ማራናኣቶ ዻኮና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«ዶንጋሳ ኬሎና ቦሂሳ ባኣዚባኣ ታዞጳ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ታጶ ዖይዶ ዓዴ ማራናይ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ሃኣኮ ዒንጊፆንታ ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ዓዶ ማራናኣቶና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«ላሃሳ ኬሎና ቦሂሳ ባኣዚባኣ ሳሊ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ታጶ ዖይዶ ዓዴ ማራናይ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ሃኣኮ ዒንጊፆንታ ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ዓዶ ማራናኣቶና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«ላንካሳ ኬሎና ቦሂሳ ባኣዚባኣ ላንካይ ዎፓና፥ ላምዖ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ታጶ ዖይዶ ዓዴ ማራናይ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ሃኣኮ ዒንጊፆንታ ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ዓዶ ማራናኣቶና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«ሳላሳ ኬሎና ፔቴይዳ ታና ካኣሽካኒ ቡኩዋቴ፤ ዬኖ ኬሎና ዓይጎ ማዾዋ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ዒዞ ዓቦ ቦሂሳ ባኣዚባኣ ፔቴ ዎፓና፥ ፔቴ ዓዴ ማራይ፥ ፔቴ ሌዔ ማዔ ላንካይ ዓዴ ማራናይ፤ ሳዋ ታና ዎዛሳያ ማዓ ሙኡዚ ዒንጊሢ ማሂ ሚቺ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ሃኣኮ ዒንጊፆንታ ዑዦ ዒንጊፆ፦ ዎፓኖና ዎላ፥ ዓዶ ማራቶና ዎላ፥ ዓዶ ማራናኣቶና ዎላ ዒንጊንቶም ጌይንቴ ጎይፆ ጎይፆ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ሚቺ ዒንጎ ዒንጊፆንታ ሃኣኮ ዒንጊፆንታ፤ ሃሣ ዑዦ ዒንጊፆንታይዳ ቃሲ ጎሜ ጌኤሺሢሮ ማዓ ፔቴ ኮላይ ዒንጉዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«ናኣቢ ኩንሥሢንታ ዒንሢ ሼኔና ዒንሢ ዒንጋ ዒንጊፆንታይዳ ቃሲ ሚቺ ዒንጎ ዒንጊፆ፥ ሃኣኮ ዒንጊፆ፥ ዑዦ ዒንጊፆና ፔቱሞና ዒንሢ ዒንጋ ዒንጊፆ ቦንቻንዳጉዲ ጌይንቴ ቦንቾ ኬሎና ታኣም ዔኪ ሺኢሹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ባኮ ቢያ ሙሴ ዒስራዔኤሌ ዴሮም ዬያይዲ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ሙሴ ዒስራዔኤሌ ፃጶኮ ሱኡጎም፦ «ናንጊና ናንጋ ጎዳ ዓይሤ ዓይሢፃ ያዺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ፔቴ ዓሲ ናንጊና ናንጋ ጎዳም ፔቴ ባኣዚ ዒንጋኒ ናኣቤቴ፥ ሃሣ ፔቴ ባኣዚ ማዻኒ ጫኣቄቴ ማዻንዳኔ ጌዔ ባኮ ኩኩንሦንጎ፤ ‹ያዺዳንዳኔ› ጌዔ ባኮ ሃሾፓ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","ሎይባኣያ፥ ዓዶ ማኣራ ዓኣ ዉዱሮ ናይ ናንጊና ናንጋ ጎዳም ፔቴ ባኣዚ ዒንጋንዳኔ ጌይ ናኣቤቴ፤ ሃሣ ፔቴ ባኣዚ ማዻንዳኔ ጌይ ጫኣቄቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ዓዴ ዬያ ዋይዛዖ ላኣጊባኣያ ማዔቴ ጫኣቄ ባኮዋ ማዖም ናኣቤ ናኣቦ ኩንሣንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ጋዓንቴ ዓዴ ዬያ ባኮ ዋይዛዖ ዒዛ ናኣቤ ባኮ ኩንሡዋጉዲ ላኣጋያ ማዔቴ ናኣቦ ኩኩንሦንጎ ጌይሳ ባኣዚ ባኣሴ፤ ዒዛ ዬያ ናኣቦ ኩንሣኒ ዳንዳዒባኣሢ ዓዴ ዒዞ ላኣጌም ማዔሢሮ ናንጊና ናንጋ ጎዳ ዒዞም ዓቶም ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«ሌዒባኣ ላኣሊ ዔሬዖ ማዔቴያ ማሊባኣዖ ዻቢንቲ ናኣቤያ ማዔቴ፥ ሃሣ ዔኤቢ ማዻኒ ጫኣቄስካፓ ሌዔያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ዓኒ ዬያ ባኮ ዋይዛዖ ላኣጊባኣያ ማዔቴ ናኣቦ ማዔቴያ ዒዛ ጫኣቄ ባኮ ኩንሣኒ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ዓኒ ዬያ ዋይዛዖ ዒዞ ላኣጌቴ ጋዓንቴ ዒዛ ኩኩንሣንዳያ ኮይሳኔ ጌይሳ ባኣዚ ባኣሴ፤ ዒዛ ናኣቦ ኩንሣኒ ዳንዳዒባኣሢ ዓኒ ዒዞ ላኣጌም ማዔሢሮ ናንጊና ናንጋ ጎዳ ዒዞም ዓቶም ጋዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","ዓኒ ሃይቄ ላኣሊታቴያ ዓንጂንቲ ኬስኬ ላኣሊ ዓይጎጉዴ ናኣቢ ማዖም ማዻንዳኔ ጌይ ጫኣቄ ባኣዚ ኩንሣንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","ሌዔ ላኣሊ ናኣቢ ናኣቤቴ፥ ሃሣ ዔኤቢ ማዻንዳኔ ጌይ ጫኣቄቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ዓኒ ዬያ ዋይዚ ዒዞ ላኣጊባኣያ ማዔቴ ዒዛ ናኣቤ ባኮ፥ ሃሣ ማዻንዳኔ ጌዔ ባኮ ኩንሣንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ዓኒ ዬያ ባኮ ዋይዛዖ ዒዛ ናኣቤ ባኮ ኩንሡዋጉዲ ላኣጌቴ ኩኩንሦንጎ ጌይሳ ባኣዚ ባኣሴ፤ ዒዛ ዬያ ናኣቦ ኩንሣኒ ዳንዳዒባኣሢ ዓኒ ዒዞ ላኣጌም ማዔሢሮ ናንጊና ናንጋ ጎዳ ዒዞም ዓቶንጎ ጋዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ዒዞኮ ዓኒ ዒዛ ናኣቤ ናኣቦ ቃራኬ ጋዓኒ፤ ሃሣ ዒፃኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ጋዓንቴ ዒዞኮ ዓኒ ዬያ ዋይዜ ኬላፓ ዓርቃዖ ዒፂ ጌስቲባኣያ ማዔቴ ዒዛ ናኣቤ ባኮና ማዻኒ ጫኣቄ ባኮ ኩንሣኒ ኮይሳኔ፤ ዓይጎሮ ጌዔቴ ዒዚ ዬያ ዋዋይዛዖ ዒፂ ጌስቲባኣሢ ‹ቃራኬ ጌዔኔ› ጌይፆ ዔርዛሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ጋዓንቴ ዒ ዋይዜስካፓ ሚርጌ ዴዔዖ ዒፂ ጌስቲ ላኣጋያ ማዔቴ ዬይ ናኣባ ኩሙዋዖ ዓቴሢሮ ዖኦጪንታንዳሢ ዒዛኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ሌውዋዖ ዓዶ ማኣራ ዓኣ ዉዱሮ ናይ ማዔቴያ ሌዔ ላኣሊ ናኣቢ ናኣቤቴ፤ ሃሣ ዔኤቢ ማዻንዳኔ ጌይ ጫኣቄቴ ዓዶና ዓኒና ማዻኒ ዳንዳዓ ባኮ ዛሎ ናንጊና ናንጋ ጎዳ ሙሴም ዒንጌ ዳምባ ያዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«ዒስራዔኤሌ ዓሶ ዑፃ ዔያታ ማዼ ጌኖ ማዾ ዛሎሮ ሚዲያሜ ዓሶ ኮሜ ኮፄ፤ ኔ ዬያይዴስካፓ ሃይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ዬያሮ ሙሴ ዴሮም፦ «ሚዲያሜ ዓሳ ናንጊና ናንጋ ጎዳም ፑርታ ማዼ ማዾ ዛሎ ዔያቶይዳ ዖልዚ ቡሊ፥ ኮሜ ኮፃኒ ዖልዚም ጊኢጊንቱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ፔቴ ፔቴ ዒስራዔኤሌ ፃጶ ማኣራፓ ፔቴ ፔቴ ሺያ ዖላንዳ ዓቲንቄ ዶኦሪ፥ ዖሎም ዳኩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ዬያሮ ፔቴ ፔቴ ፃጳፓ ፔቴ ሺያ ሺያ ዓሲ፤ ዎሊ ዑፃ ታጶ ላምዖ ሺያ ዓሲ ዖሎም ጊኢጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ቄኤሳሢ ዓላዜሬ ናኣዚ፥ ፒንሃሴ ዬያ ዓሶ ዔኪ ዖሎሮ ዓኣዻንዳጉዲ ሙሴ ዳኬኔ፤ ፒንሃሴ ዒማና ጌኤዦ ማኣሮይዳ ዓኣ ፆኦሲም ዱማዼ ባኮንታ ዖሎም ዓሶ ዔኤሊ ጊኢጊሻ ዛያሢንታ ኩጫ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆና ሚዲያሜ ዓሶይዳ ዔያታ ዖልዚ ቡሊ ዓቲንቆ ቢያ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ዒማና ሚዲያሜኮ ዶንጎ ካኣታ ሃይቄኔ፤ ዬያታ፦ ዔዊ፥ ሬቄሜ፥ ፁሪ፥ ሁሪንታ ሬባዒ ጌይንታያኬ፤ ቃሲ ዔያታ ቢዖሬ ናኣዚ ባኣላኣሜያ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ዒስራዔኤሌ ዴራ ሚዲያሜ ዓጮ ላኣሎንታ ናኣቶዋ ዲዒ ዔኬኔ፤ ባኣቶንታ ማራቶንታ ዋኣሮንታኣ ዔኬኔ፤ ዔያቶኮ ቆሎዋ ቢያ ቡሪ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ዔያቶኮ ካታሞና ጉርዶዋ ቢያ ሚቼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ዔያታ ዲዒ ዔኬ ዓሶንታ ቆልሞንታ ሃንጎ ባኮዋ ቢያ ቡኩሲ ዔኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ዮርዳኖሴ ዎሮ ሱካ፥ ዒያርኮኮ ሆታ ዓኣ፥ ሞዓኣቤ ቦኦሎይዳ ዱንኪ ዴዒ ዓኣ ሙሴና ዓላዜሬና፤ ዬያጉዲ ዴራ ቢያሢ ዓኣ ቤዞ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ሙሴንታ ዓላዜሬንታ ሃንጎ ዴሮኮዋ ሱኡጋ ዖሎ ዓሶ ጎይሣ ዔካኒ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ዒማና ሙሴ ዖላፓ ማዔ፥ ፖኦሊሶኮ ሱኡጎ ዑፃ፤ ጌይፃ፦ ሺዮ ዓሶ ዓይሣ ዓሶና ፄኤቶ ዓሶ ዓይሣ ዓሶናይዳ ዻጋዻዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","«ላኣሎ ቢያ ዎዹዋዖ ዒንሢ ዓይጎሮ ሃሼይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ቤርታ ፔዖሬይዳ ኑ ዓኣንቴ ባኣላኣሜ ዞሮ ዋይዚ ዴራ ፆኦሲ ጉሙርቂፆ ሃሻንዳጉዲ ማሄሢ ላኣሎታሢ ዒንሢ ዋሊያ? ፆኦሲ ዴሮ ዑፃኣ ዎዻ ዶርዓሢ ዔኪ ዬይሲሴሢ ዬያ ዻቢንቶኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ዬያሮ ሃሢ ዓቲንቆ ናኣቶ ቢያ፤ ሃሣ ዓቲንቆና ኮኦሜ ላኣሎዋ ቢያ ዎዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ጋዓንቴ ኩሙፆ ዉዱሮ ናኣቶ ዎዹዋዖ ዒንሢሮ ማሂ ሃሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ዒንሢ ባኣካፓ ዓሲ ዎዼ ዓሲ ማዔቴያ ሌሲ ካኣሜ ዓሲ ቢያ ላንካይ ኬሊ ሄላንዳኣና ጉርዳፓ ዙላ ዴዖንጎ፤ ሃይሣሳ ኬሎና ላንካሳ ኬሎናይዳ ዒንሢንታ ዒንሢ ዲዒ ዔኪ ሙኬ ላኣሎ ጌኤሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ዬያጉዲ ዓይጎ ማኣዖዋ ማዖም ዒልዒና፥ ዋኣሪ ጋፓኔና፤ ሃሣ ጊንሣ ሚሢና ኮሺንቴ ባኣዚ ቢያ ጌኤሹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ቄኤሳሢ፥ ዓላዜሬ ዖላፓ ማዔ ዓቲንቆም ሂዚ ጌዔኔ፦ «ናንጊና ናንጋ ጎዳ ሙሴም ዒንጌ ዎጎኮ ዳምባ ያዺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","ዎርቄ፥ ቢራ ዓንጊ፥ ሞኦና ዓንጊ፥ ዓንጊ፥ ቆርቆሬ፤ ሃሣ ጊንሣ ዒርሳሴ ጌይንታ ዓንጎንታ ዬያጉዴያ ታሚ ሚቺ ዔኤቢ ዎኦቱዋ ባኣዚ ቢያ ታሚና ሚቺንቲ ጌኤሽካንዳያ ኮይሳኔ፤ ታሚ ሙዓ ባኮ ጋዓንቴ ቢያ ጌኤሺፆ ዳምቦም ጌሢንቴ ዋኣፆና ማስኪ ጌኤሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ላንካሳ ኬሎና ዓፒሎ ዒንሢኮ ማስኩዋቴ፤ ዬካፓ ዳምቦ ጎይፆና ጌኤሽኬያ ዒንሢ ማዓሢሮ ጉርዶ ጌላኒ ዒንሢ ዳንዳዓኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«ኔናንታ ዓላዜሬንታ ዓሶኮ ሱኡጎ ማዔ ሃንጎ ዓሶንታ ዎላ ማዒጋፓ ዲዒ ዔኪ ሙኮና ዓሶንታ ቆልሞንታ፤ ዬያጉዲ ዔኪ ሙኮና ባኮ ቢያ ፓይዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ዬያ ላምዖ ቤሲ ፓቂጋፓ ፔቴዞይዳ ፓቂንቴዞ ዖሎ ዓኣዺ ሙኬ ዓሶም፤ ላምዓሳዞ ሃንጎ ዓሶም ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ፖኦሊሶም ጌይንቴሢዳፓ ዲዒንቴ ዓሶኮ ዶንጎ ፄኤታፓ ፔቴማ፤ ዬያጉዲ ባኣቶይዳፓ፥ ሃሮይዳፓ፥ ማራቶና ዋኣሮናይዳፓ ዶንጎ ፄኤታኮ ፔቴ ኩቺ ማዓማ ዔኪ ታና፥ ናንጊና ናንጋ ጎዳሢም ዒንጎ ባኣዚ ማሂ ዱማሲ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ታና፥ ናንጊና ናንጋ ጎዳሢም ዱማ ዒንጊሢ ማሂ ቄኤሳሢ ዓላዜሬም ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ሃንጎ ዴሮም ዒንጊንቴሢዳፓ ዲዒንቴ ዓሶኮ ዶንጊታሚ ዓሲፓ ፔቴማ፤ ዬያጉዲ ባኣቶፓ፥ ሃሮይዳፓ፥ ማራቶንታ ዋኣሮንታይዳፓ ዱማሲ ታኣም ዱማዼያ ማዔ ታኣኒ ዒንሢና ካኣማ ማኣሮኮ ሱኡጎ ማዔ ሌዊ ዓሶም ዒንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ሙሴንታ ዓላዜሬንታ ናንጊና ናንጋ ጎዳ ዔያቶ ዓይሤ ባኮ ቢያ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","ዔያታ ፔኤም ማሂ ዔኬ ባኮዋ ጊዳ ቃሳዛ ዔያታ ዲዒ ዔኪ ሙኬ ባካ ያዺኬ፦ ላሆ ፄኤታና ላንካይታሚ ዶንጎ ሺያ ማራይና ዋኣሪና፥ ላንካይታሚ ላምዖ ሺያ ባይ፥ ላሂታሚ ፔቴ ሃሬና ሃይሢታሚ ላምዖ ሺያ ኩሙሢ ዉዱሮ ናይናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ዲዒንቲ ዔኪ ሙኮና ባካፓ ዛላ ዖሎ ዖሊ ሙኬ ዓሶም ዒንጊንቴያ ማዓዛ ዬይ ባካ ሃይሦ ፄኤታና ሃይሢታሚ ላንካይ ሺያና ዶንጎ ፄኤታ ዋኣሪና ማራይናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ዬያቶይዳፓ ላሆ ፄኤታና ላንካይታሚ ዶንጎንሢ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ማዒ ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ዖሎ ዖሊ ሙኬ ዓሶም ዒንጊንቴ ባኣቶኮ ፓይዳ፦ ሃይሢታሚ ሺያ ማዓዛ ዬያቶይዳፓ ላንካይታሚ ላምዖንሢ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ማዒ ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ሃሣ ፖኦሊሶም ዒንጊንቴ ሃራ ሃይሢታሚ ሺያና ዶንጎ ፄኤታና ማዓዛ ዬያቶይዳፓ ላሂታሚ ፔቴ ናንጊና ናንጋ ጎዳም ዒንጎ ባኣዚ ማዒ ዒንጊንቴያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ሃሣ ፖኦሊሶም ዒንጊንቴ ኩሙፆ ዉዱሮ ናኣቶኮ ፓይዳ ታጶ ላሆ ሺያ ማዓዛ ዬያቶይዳፓ ሃይሢታሚ ላምዖንሢ ናንጊና ናንጋ ጎዳ ማዾም ዱማዼያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ዬያሮ ሙሴ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆ ዒንጎ ባኮ ናንጊና ናንጋ ጎዳም ዱማ ዒንጊሢ ማሂ ዓላዜሬም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ሃንጎ ዴሮም ዒንጊንቴሢ ዖሎ ዖሌ ዓሶም ዒንጊንቴሢና ዎላ ሄኮ ማዔ ባኣዚኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ዬይያ፦ ሃይሦ ፄኤታና ሃይሢታሚ ላንካይ ሺያና ዶንጎ ፄኤታ ማራይና ዋኣሪና፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ሃይሢታሚ ላሆ ሺያ ባይ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ሃይሢታሚ ሺያና ዶንጎ ፄኤታ ሃሬንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ታጶ ላሆ ሺያ ኩሙሢ ዉዱሮ ናይንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ዬያ ባኮይዳፓ ሙሴ ዶንጊታሞ ዓሶፓ ፔቴማ፤ ዬያጉዲ ሃሣ ዶንጊታሞ ቆልማፓ ፔቴማ ዔኪ ዔኪ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ፆኦሲ ዴሮና ካኣማ ማኣሮኮ ሱኡጎ ማዔ ሌዊ ዓሶም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ዬካፓ ፖኦሊሶኮ ሺዮ ሺዮና ፄኤቶ ፄኤቶና ዓይሣ ዓሳ ሙሴ ኮይላ ሙኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","«ጎዳሢዮ! ኑኡኒ ዓይሢ ዎይሣ ፖኦሊሶ ቢያ ኑ ፓይዴኔ፤ ዔያቶይዳፓ ፔቴታዖ ፓጬያ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ዬያሮ ኑኡኒ ፔቴ ፔቴሢ ዔኬ ዎርቆ ፓልማሢ፤ ጌይፃ፦ ቶካ ዓኣሦ ጋዋ፥ ኩጮ ጋዋ፥ ኬኤሎ ዢኢራሢ፥ ዋያ ዓኣሦ ባኮንታ ሆላ ማኣዖሢንታ ቢያ ጎሞ ኑኡኮ ጌኤሻንዳጉዲ ጎዳም ዒንጎ ዒንጊሢ ማሂ ኑ ዔኪ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ሙሴና ዓላዜሬና ፓልሞ ማሂ ማዢንቴ ዎርቆ ቢያ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ዖሎ ዖላ ሺዮ ዓሶ ዓይሣዞንሢና ፄኤቶ ዓሶ ዓይሣዞንሢናይዳፓ ናንጊና ናንጋ ጎዳም ዒንጊሢ ማዒ ዒንጊንቴ ዎርቆኮ ዴኤሡማ ላምዖ ፄኤታ ኪሎ ማዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ፖኦሊሶኮ ሱኡጎ ማዒባኣ ዖሎ ዓሳ ጋዓንቴ ዲዒ ዔኪ ሙኬ ባኮ ፔኤሮ ማሂ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ዬያሮ ሙሴና ቄኤሳሢ፥ ዓላዜሬና ጎዳ ዒስራዔኤሌ ዓሶ ጶቂሢ ማኣዳንዳጉዲ ዖሎ ዖላ ሺዮ ዓሶና ፄኤቶ ዓሶና ዓይሣ ዓሶፓ ዎርቆ ዔኪ ፆኦሲ ዴሮና ካኣማ ዓፒላፓ ማዦና ማኣሮ ጌልዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ሮኦቤኤሌና ጋኣዴ ማኣሮ ዓሶናኮ ሚርጌ ቆልሞ ዓኣሢሮ ያዕዜሬና ጌሌዓዴና ዓጫ ቆልሞም ጊኢጋያ ማዔሢ ዛጋዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ሙሴንታ ዓላዜሬንታ ዴሮኮ ሱኡጎ ማዔ ሃንጎ ዓሶ ኮይላ ዴንዲ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","«ሃይ ዒስራዔኤሌ ዓሳ ዔካንዳጉዲ ናንጊና ናንጋ ጎዳ ማኣዴ፦ ዓፃሮቴ፥ ዲቦኔ፥ ያዕዜሬ፥ ኒሚራ፥ ሃሴቦኦኔ፥ ዔልዓሌ፥ ሲቢማ፥ ኔቦንታ ቤዖኔንታ ካታሞኮ ዓኣ ሳዓ ቆልሞም ጊኢጋያኬ፤ ኑኡኮ ሚርጌ ቆልሞ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ዒንሢ ኑና ቦንቼያ ማዔያታቴ ዬኖ ሳዖ ኑና ዒንሢኮ ዓይሎም ኑ ዓጪ ማሂ ዒንጉዋቴ፤ ዮርዳኖሴ ዎሮ ሱኮ ኑ ፒንቂ ዒኢካ ዴዓንዳጉዲ ኑና ዳኪፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ሙሴ ዔያቶም ማሃዖ፦ «ዒንሢ ዒጊኖ ማዔ፥ ዒስራዔኤሌ ዓሳ ዖሎይዳ ዓኣዻዛ ዒንሢ ሃይካ ዓታኒ ኮዓ? ");
INSERT INTO mdyeth_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ዒስራዔኤሌ ዴራ ዮርዳኖሴና ፒንቂ፥ ናንጊና ናንጋ ጎዳ ዔያቶም ዒንጋ ዓጮ ጌሉዋጉዲ ዓይጋ ዒንሢ ጎጶ ዔያቶኮ ዋኣፂሳይ? ");
INSERT INTO mdyeth_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ሃያኮ ቤርታ ዬኖ ዓጬሎ ዴንዲ ሙራንዳጉዲ ቃዴሴባርኔይዳፓ ታ ዔያቶ ዳኬ ዎዶና ዒንሢኮ ዓዶንሢ ዒማይዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ዒማና ዔያታ ዴንዲ ዔሽኮሌ ዶኦጮ ሄላንዳኣና ዓጬሎ ዛጌኔ፤ ጋዓንቴ ዒኢካፓ ዔያታ ማዓዖ ዴራ፦ ናንጊና ናንጋ ጎዳ ዒንጋ ሳዔሎ ጌሉዋጉዲ ዓሶኮ ጎጲ ዋኣፂሳ ባኣዚ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","11","ዬኖ ኬሎና ናንጊና ናንጋ ጎዳ ሚርጌና ዻጋዻዖ፦ ‹ታና ዔያታ ጉሙርቂ ዶዲ ዴዒባኣሢሮ ጊብፄ ዓጫፓ ኬስኬ፥ ሌዓ ላማታሚና ዬካፓ ዑሣ ማዔ ዓሲ ቢያ ታኣኒ ዓብራሃሜም ዪሳኣቄም ሃሣ ያይቆኦቤም ዒንጋንዳኔ ጌዔ ዓጮ ፔቴታዖ ጌሊንዱዋኣሢ ታ ጫኣቄኔ።› ");
INSERT INTO mdyeth_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ዬይ ጫኣቁማ፦ ፆኦሲም ጉቤ ዒናፓ ዓይሢንታያ ማዔ፥ ቄኔዛ ዓጮ ዓሢ ዪፑኔ ናኣዚ ካኣሌቤና ኔዊ ናኣዚ ዒያሱናፓ ዓታዛ ሃንጎ ዓሶ ቢያሢዳ ማዺንቲ ኩማንዳያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ናንጊና ናንጋ ጎዳ ዴሮ ዑፃ ሚርጌና ዻጋዺ ዔቄሢሮ ዬና ፆኦሲ ዖዪሴ ሾይንታ ቢያ ኩዳንዳያ ሄላንዳኣና ዖይዲታሚ ሌዔ ጉቤ ዓሲ ናንጉዋ ዳውሎይዳ ሜታዺ ዔያታ ሃንታንዳጉዲ ማሄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ሃሣ ዒንሢያ ዒንሢኮ ዓዶንሢ ቤዛ ኬስኪ፥ ናንጊና ናንጋ ጎዳኮ ዻጎ ዒስራዔኤሌ ዓሶ ዑፃ ዔኪ ሙካኒ ጊኢጊንቴ ጎሜ ማዻ ሾይንቲ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ዒንሢ ሮኦቤኤሌና ጋኣዴና ዓሳ ናንጊና ናንጋ ጎዳ ሃሢ ጋዓ ጊንፆ ዓኣዺፆ ዒንሢ ዒፄቴ ዒዚ ሃሣ ሃያ ዴሮ ዓሲ ናንጉዋ ዳውሎይዳ ሃሻንዳኔ፤ ዬያሮ ዔያቶይዳ ሄላ ባይሲንቶ ዛሎ ዒንሢ ዖኦጪንታያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ዬካፓ ሃሣ ዔያታ ሙሴ ኮይላ ሙኪ፦ «ቤርታዺ ሃካ ኑኡኮ ቆልሞም ሞኦሢ፤ ሃሣ ኑኡኮ ናኣቶማኣ ኑኡኒ ካታማ ማዦም፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ዬያይዴስካፓ ኑኡኮ ዒጊኖ፥ ዒስራዔኤሌ ዓሶና ዎላ ዖሎሮ ዓኣዻኒና ዔያቶሮ ማዔ ሳዔሎ ጌሊ ዔያታ ዴዓንዳያ ሄላንዳኣና ቤርታ ኬስኪ ዖልታኒ ኑ ጊኢጊንታንዳኔ፤ ኑኡኒ ዬያይዲ ማዒ ሙካንዳያ ሄላንዳኣና ኑኡኮ ናኣታ ሂዲ ኑ ዶዲሺ ዲርቂ ማዤ ካታሞይዳ ዴዓንዳኔ፤ ሃኖ ዓጮይዳ ናንጋ ዓሳ ሙኪ ዔያቶይዳ ፑርታ ባኣዚ ሄሊሳኒ ዳንዳዒንዱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ሃንጎ ዒስራዔኤሌ ዓሳ ቢያ ዔያቶም ዒንጊንቴ ሳዖ ዴንቃንዳያ ሄላንዳኣና ኑኡኒ ኑ ማኣሪ ማዓዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ኑኡኒ ኑም ማዓንዳ ቤሲ ሃካ፥ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ባንፃ ዔኬሢሮ ሱካ ዔያቶም ዒንጊንታ ሳዓፓ ፔቴታዖ ቤሲ ኑ ዔካዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ሙሴ ዔያቶም፦ «ዬይ ዒንሢ ጌዔ ባካ ጎኔታቴ ናንጊና ናንጋ ጎዳ ዖሎ ዖላኒ ዴንዲሮ ሃይካ ጊኢጊንቱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","22","ዒንሢዳፓ ዖሎ ዖላንዳ ዓሳ ቢያ ዮርዳኖሴ ዎሮና ፒንቂ ናንጊና ናንጋ ጎዳ ዓይሣ ጎይፆና ኑኡኮ ሞርኮይዳ ዖልዚ ቡሊ፥ ናንጊና ናንጋ ጎዳ ዔያቶ ባሺ ዔያቶኮ ሳዖ ዔካንዳያ ሄላንዳኣና ዖልታንዳያ ኮይሳኔ፤ ዬያ ዒንሢ ማዼስካፓ ማዓኒ ዳንዳዓኔ፤ ዬያይዴቴ ፆኦሲንታ ዒንሢኮ ዒጊኖ ዒስራዔኤሌ ዓሶንታም ማዻኒ ኮይሳ ባኮ ዒንሢ ማዼኔ ጌይሢኬ፤ ዬካፓ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ባንፃ ዓኣ ሳዓ ዒንሢሮ ማዔሢ ናንጊና ናንጋ ጎዳ ዒንሢም ጎናሲ ዔርዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ዒንሢ ጌዔ ባኮ ማዺ ኩንሢባኣቴ ናንጊና ናንጋ ጎዳም ዒንሢ ዓይሢንቶ ዒፂ ዻቢንቴያ ማዓንዳሢ ላቲ ታ ዒንሢም ኬኤዛኔ፤ ዬያ ዻቢንቶ ዛሎና ሜታ ዒንሢ ሄላንዳሢያ ዔሪ ዴዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ዬያሮ ዒንሢኮ ካታሞና ዒንሢኮ ቆልሞማኣ ሞኦሢ ዲርቁዋቴ፤ ጋዓንቴ ዒንሢ ማዻንዳኔ ጌዔ ባኮ ማዺ ኩንሡዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ጋኣዴና ሮኦቤኤሌና ዓሳ፦ «ኑ ጎዳሢዮ! ኔ ኑና ዓይሤ ጎይፆ ቢያ ኑ ማዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ኑኡኮ ላኣላ፥ ናኣታ፥ ባኣቶንታ ማራቶንታ ሃይካ ጌሌዓዴይዳ ዴዓንዳኔ ጌይሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ኑኡኒ ቢያሢ ጋዓንቴ ኔ ዓይሤ ጎይፆና ዖሎሮ ጊኢጊንቲ ናንጊና ናንጋ ጎዳ ዻዋ ጎይፆ ዖልታኒ ሱኮ ኑ ፒንቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ዬያሮ ሙሴ ቄኤሳሢ፥ ዓላዜሬና ኔዊ ናኣዚ ዒያሱና ሃንጎ ዒስራዔኤሌ ዴሮኮ ፃጶ ፃጶ ሱኡጎም ዬያ ዓሶም ማዓ ዓይሥሢ ሂዚ ጌይ ዓይሤኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«ጋኣዴና ሮኦቤኤሌና ዓሳ ዮርዳኖሴ ዎሮና ፒንቂ ናንጊና ናንጋ ጎዳ ዖሊሳ ዖሎም ጊኢጊንታያ ማዒ፥ ዔያቶ ማኣዶና ዓጬሎ ጌሊ ዒንሢ ዔካያ ማዔቴ ጌሌዓዴ ዓጮ ዔያቶ ዓጪ ማሂ ዔያቶም ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ዮርዳኖሴና ፒንቂ፥ ዒንሢና ዎላ ዖሎይዳ ዓኣዹዋያ ዔያታ ማዔቴ ጋዓንቴ ዓዳ ዒንሢጉዲ ካኣናኔ ዓጮይዳ ዔያቶሮ ማዓ ሳዓ ዔያቶም ዒንጊንቶንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ጋኣዴና ሮኦቤኤሌና ዓሳ፦ «ኑ ጎዳሢዮ! ናንጊና ናንጋ ጎዳ ኑና ዓይሤ ባኮ ቢያ ኑ ማዻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ዒዚ ኑና ዔኪ ዓኣዻ ጎይፆና ካኣናኔ ዓጮ ኑ ፒንቃንዳኔ፤ ሃካ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ባንፃ ዓኣ ሳዖ ኑም ማሃኒ ዖሎይዳ ኑ ዴንዳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ዬያሮ ሙሴ ዓሞራ ዓጮ ካኣቲ ሲሆኔና ባኣሳኣኔ ዓጮ ካኣቲ ዖጌናኮ ዓጮ፤ ሃሣ ዔያቶ ዓጮኮ ኮይላ ዓኣ ካታሞንታ ዓጮዋ ጊዳ ቃሲ፤ ጋኣዴና ሮኦቤኤሌ ዓሶናም፥ ዬያጉዲ ሚናኣሴ ዓሶማኣ ዛሎ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ጋኣዴ ዓሳ፦ ዙሎ ቢያ ዲርቆና ዲቦኔ፥ ዓፃሮቴ፥ ዓሮዔኤሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ያፅሮትሾፓኔ፥ ያዕዜሬ፥ ዮግቤሃኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ቤትኒምራኔንታ ቢትሃራኔ ጌይንታ ካታሞ ጊንሣ ኮሺ ማዢ ባኣቶማኣ ባርታ ዲርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ሮኦቤኤሌ ዓሳ፦ ሃሴቦኦኔ፥ ዔልዓሌ፥ ቂሪያታይሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ኔቦኔ፥ ጊንፃፓ ሱንፃ ላኣሚንቴ ባዓልሜዖኔና ሲቢማ ካታሞ ጊንሣ ኮሺ ማዤኔ፤ ዔያታ ዬያ ጊንሣ ኮሺ ማዤ ካታሞም ዓኪ ሱንሢ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ሚናኣሴ ናኣዚ ማኪሬ ማኣሮ ዓሳ፦ ጌሌዓዴ ዓጮ ዖሊ ዔኬኔ፤ ዒኢካ ናንጋ ዓሞራ ዓሶዋ ዳውሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ዬያሮ ሙሴ ጌሌዓዴ ዓጮ ማኪሬ ማኣሮ ዓሶም ዒንጌም፥ ዔያታ ዒኢካ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ሚናኣሴ ማኣሮ ዓሶፓ ያዒሬ ጎዖሢ ፔቴ ፔቴ ጉርዳይዳ ዖልዚ ቡሊ ዬኖ ጉርዶ ዔካዖ፦ «ያዒሬ ጉርዶ» ጌይ ሱንሢ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ኖባሄ ጎዖሢ ሃሣ ቄናቴ ጌይንታ ካታማና ኮይላ ዓኣ ጉርዶናይዳ ዖልዚ ቡሊ ባሺ ዔኬኔ፤ ዬያ ቤዞኮ ሱንፆ «ኖባሄ» ጌይ ፔ ሱንፃ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ዒስራዔኤሌ ዓሳ ፔኤኮ ፃጶና ፃጶና ፓቂንቲ ሙሴና ዓኣሮኔና ዔያቶ ዔኪ ዓኣዼም ጊብፄፓ ኬስካዖ ዴንዲ ዴንዲ ዴዔ ቤዞ ዔርዛ ሃይሳ ያዺኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ዒማና ዔያታ ዱንኪ ዱንኪ ዴዔ ቤዞኮ ሱንፆ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ሙሴ ፃኣፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ዒስራዔኤሌ ዴራ ጊብፄ ዓጫፓ ኬስኬሢ ሌዖኮ ቤርታሳ ዓጊና ፄኤሬንቴ ታጶ ዶንጋሳ ኬሎና ጌይፃ ዑሣ ዓኣዺፆ ቦንቾ ኬሎኮ ጉቶኬ፤ ጊብፄ ዓሳ ቢያ ሆታ ዔያቶ ዛጋንቴ ናንጊና ናንጋ ጎዳ ዔያቶ ካፔም ራምሴ ካታማፓ ዔያታ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ጊብፄ ዓሳ ዒማና ናንጊና ናንጋ ጎዳ ዔያቶኮ ዎዼ፥ ቶይዶ ናኣቶ ዱኡካኔ፤ ናንጊና ናንጋ ጎዳ ዬያይዲ ዎጊ ጊብፄ ዓጫ ካኣሽኪንታ ፆኦዛ ፓሡዋያ ማዔሢ ዔርዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ዒስራዔኤሌ ዓሳ ራምሴይዳፓ ዔቂ ዴንዲ ሱኮቴይዳ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ዬካፓ ዔቂ ዓሲ ናንጉዋ ዳውሎኮ ጋፒንፆይዳ ዓኣ ዔታሜ ጎዖ ቤዛ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ጊንሣ ሃሣ ባዓልፃፖኔኮ ዓባ ኬስካ ባንፃ ዓኣ ፒሃሂሮቴ ባንሢ ማዒ ሚግዶሌ ዓጮኮ ሆታ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ዬኖ ቤዛፓ ዔቂ ዞቄ ባዞና ፒንቃዖ ሹሬ ቦኦሎ ሙኬኔ፤ ዬኖይዳፓ ሃይሦ ኬሊ ሃንታዖ ማኣራ ጎዖ ቤዛ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ማኣራይዳፓ ዔቂ ታጶ ላምዖ ዋኣሢ ዓልቃ ቤሲና ላንካይታሚ ቴምሬ ሚሢ ዓኣ፥ ዔሊሜ ዴንዲ ዒኢካ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ዬኖ ቤዛፓ ሃሣ ዔቂ ዞቄ ባዞ ኮይላ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ዞቄ ባዞ ኮይላፓ ዔቂ ዓሲ ናንጉዋ ሲና ዳውሎይዳ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ሲና ቦኦላፓ ዔቃዖ ዳፒቃ ጎዖ ቤዛ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ዳፒቃፓ ጊንሣ ዔቂ ዓሉሼይዳ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ሃሣ ዓሉሼይዳፓ ዔቃዖ ዑሽኮ ዋኣሢባኣ፥ ሬፕዲሜይዳ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","37","ሬፕዲሜይዳፓ ዔቂ ዴንዲ ሆኦሬ ዹኮ ሄላንዳኣና ዔያታ ዱንኪ ዴዔ ቤዛ ሃካፓ ሊካ ፓይዲንታ ቤዞኬ፦ ዓሲ ናንጉዋ ሲና ዳውላ፥ ቂብሮት ሃትዓዋ ፥ ሃፄሮቴ፥ ሪቲማ፥ ሪሞንፔሬዜ፥ ሊቢና፥ ሪሳ፥ ቄሄላታ፥ ሼፔሬ ዹኮ ኮይላ፥ ሃራዳ፥ ማቅህሎቴ፥ ታሃቴ፥ ታና ሚትቃ፥ ሃሾሞና፥ ሞሴሮቴ፥ ቤኔያዕቃ፥ ሆርሃጊድጋኣዴ፥ ዮፅባታ፥ ዓብሪና፥ ዔፂዮንጋብሬ፥ ፂኔ ቦኦሎይዳ፤ ጌይፃ፦ ቃዴሴይዳ፥ ዔዶኦሜ ዓጮኮ ዛጳ ዓኣ ሆኦሬ ዹኮ ኮይላ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","ቄኤሳሢ ዓኣሮኔ ናንጊና ናንጋ ጎዳ ዓይሤም ሆኦሬ ዹኮ ኬስኪ፥ ዒስራዔኤሌ ዓሳ ጊብፄ ዓጫፓ ኬስኬንቴ ዖይዲታማሳ ሌዖኮ ዶንጋሳ ዓጊና ፄኤሮ ፄኤሬ ዓቦና ሌዓ ዒዛኮ ፄኤታና ላማታሚ ሃይሦ ማዔንቴ ዒኢካ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ዒማና ካኣናኔ ዓጫ፥ ዾኦሎ ዛሊና ዓኣ ዓራዴ ዓጮይዳ ናንጋ፥ ካኣናኔ ዓሲ ማዔያታዖ ዓራዴ ዓጮኮ ካኣቲስኬይ ዒስራዔኤሌ ዓሳ ሙኬሢ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","49","ሆኦሬ ዹኮ ኮይላፓ ዴንዲ ሞዓኣቤ ቦኦሎ ሄላንዳኣና ዒስራዔኤሌ ዓሳ ዱንኪ ዴዔ ቤዛ ሃካፓ ሊካ ፓይዲንታ ቤዞኬ፦ ፄልሞና፥ ፑኖኔ፥ ዖቦቴ፥ ሞዓኣቤ ዓጮ ዛጳ ዓኣ ዓባሪሜ፥ ዲቦንጋኣዴ፥ ዓልሞንዲብላታይሜ፥ ናባው ዹኮኮ ሆታ ዓኣ ዓብሪሜ ዹኮ ኮይላ፥ ዒያርኮኮ ሆታ ዓኣ ሞዓኣቤ ቦኦሎይዳ፤ ጌይፃ፦ ሻሮ ካሮ ጌይንታ ቤዞፓ ዴንዲ ሻሮ ዶኦጮ ጌይንታ ቤዞ ሄላንዳኣና ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ዒያርኮኮ ሆታ፥ ዮርዳኖሴ ዎሮ ሱካ፥ ሞዓኣቤ ቦኦሎይዳ ዔያታ ዓኣንቴ ዒስራዔኤሌ ዴሮም ኬኤዛንዳጉዲ ናንጊና ናንጋ ጎዳ ሙሴም ዒንጌ ዳምባ ሃካፓ ሊካ ኬኤዚንታሢኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«ዮርዳኖሴና ፒንቂ ካኣናኔ ዓጮ ዒንሢ ጌሌ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ዬኖ ዓጮይዳ ናንጋ ዓሶ ቢያ ዒንሢ ቤርታፓ ዳውሲ ኬሱዋቴ፤ ዔያቶኮ ሹጮና ዓንጎናይዳፓ ኮሺንቴ ካኣሽኮ ፆኦዞ ሜንሢ ባይዙዋቴ፤ ጌሜሮይዳ ዔያቶኮ ማዢንቲ ማዢንቲ ዓኣ ዚጎ ቤዞዋ ሻሂ ባይዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ታ ዒንሢም ዒዞ ዒንጌያታሢሮ ዓጬሎ ዔኪ ዒዞይዳ ናንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ሳዔሎዋ ዱማ ዱማ ፃጶና ቶኦኮና ቶኦኮና ማዒጋፓ ዒፃ ዓጊ ጊሽቲ ዔኩዋቴ፤ ዓሳ ዺቤ ቶኦኮም ዳልጊ ሳዓ፥ ዓሳ ዻካ ማዔ ቶኦኮም ዻካ ሳዓ ዒንጊንቶንጎ። ፔቴ ፔቴሢም ዒፃሢ ኬዴ ቤዛ ዔያቶሮ ማዓንዳኔ፤ ዔያታ ፔኤኮ ዓዶንሢ ሱንፆና ሱንፆና ፔ ሳዓ ማሂ ዔኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ዓጬሎይዳ ናንጋ ዓሶ ቢያ ዒንሢ ዳኪ ባይዚባኣያታቴ ጋዓንቴ ዓኣፖይዳ ዒንሢኮ ቡኡራጉዲ፥ ጎኦቦይዳ ዒንሢኮ ጫርጋ ዓንጊሢጉዲ ማዒ ዒንሢ ሜታሳንዳኔ፤ ዒንሢ ዴዔ ዓጮይዳ ቢያ ኬሊ ዖልዚና ዔያታ ዒንሢ ሜታሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ዒንሢ ዔያቶ ዳኪ ባይዚባኣያታቴ ዔያቶ ባይዛኒ ማሌ ጎይፆ ዒንሢ ታ ባይዛንዳኔ» ጋዓያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«ዒስራዔኤሌ ዓሶም ሂዚ ጌይ ዓይሤ፤ ‹ታኣኒ ዒንሢም ዒንጋ ካኣናኔ ዓጬሎ ዒንሢ ጌሌ ዎዶና ዒንሢ ዓጮኮ ዛጳ ሃካፓ ሊካ ኬኤዚንታ ጎይፆ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ዓጮኮ ዾኦሎ ዛሎ ዛጳ ዓሲ ናንጉዋ ፂኢኔ ዳውላፓ ዔቃዖ ዔዶኦሜ ዓጮኮ ዛጶማ ዓርቂ ዓኣዻያ ማዓንዳኔ፤ ዬይ ዓርቃንዳሢ ዓባ ኬስካ ዛሎና ሶኦጌ ባዚኮ ዾኦሎ ዛላፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ዬይና ጌዒ ኮርናሢ ቶኦሎ ባንሢ ሊካ ዓኣዺ፥ ፂኢኔይዴና ዴንዲ ቃዴሴ ባርኔ ሄላኔ፤ ዬካፓ ሃሣ ሃዳርዓዳሬ ጌይንታ ቤዞኮ ኬዶ ዛላ ዓባ ጌላ ባንፆና ጌዒ ያፂሞኔ ሄላንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ጊንሣ ሃሣ ጊብፄ ዓጮይዳ ዓኣ ዛሮና ሺሪ፥ ሜዲቴራኒያ ባዞ ሄሊ ጋፓያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ዓባ ጌላ ዛሎ ዛጳ ሜዲቴራኒያ ባዞ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ኬዶ ዛሎ ዛጳ ሜዲቴራኒያ ባዞ ዓጮ ዓርቂ ዴንዲ ሆኦሬ ዹኮ ጊዴና ጌዒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ሃማቴ ባንሢ ዴንዳ ጎይፆ ሄላንዳኣና ማላታ ማዓ ባኣዚ ጌሡዋቴ፤ ዬካፓ ዛጳ ፄዳዴ ሄላንዳኣና ዓኣዻዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ዚፒሮኔና ፒንቂ ጋፒንፃ ሃፃርዔናኔይዳ ማዓንዳኔ፤ ዬይ ዒንሢኮ ኬዴኖ ዛጶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ዓባ ኬስካ ዛሎ ዛጶኮዋ ሃፃርዔናኔይዳፓ ዴንዲ ሼፓሜ ሄላንዳኣና ማላታ ማዓ ባኣዚ ጌሡዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ዬካፓ ዓይኔ ጌይንታ ቤዞኮ ዓባ ኬስካ ባንፆና ሪብላ ሄላንዳኣና ዓኣዺ ጌሊላ ባዞኮ ዓባ ኬስካ ዛሎና ዓኣ ጌሜሮ ሄላንዳኣና ዓኣዻዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ዮርዳኖሴ ዎሮ ሄሊ፤ ጋፒንፃ ሶኦጌ ባዚ ማዓንዳኔ። ዬይ ዒንሢ ዛጶ ማዓንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ዬያሮ ሙሴ ዒስራዔኤሌ ዓሶም፦ «ታዞጳና ዛላና ማዔ ፃጶ ማኣሮም ዒፃ ዓጊ ዒንጊንታንዳጉዲ ናንጊና ናንጋ ጎዳ ዓይሤ ሳዓ ያዺኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ሮኦቤኤሌና ጋኣዴና ዓሳ፥ ሃሣ ሚናኣሴ ዓሶኮዋ ዛላ ፔ ማኣሮ ዓሶና፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ዮርዳኖሴ ዎሮኮ ሶ ሱካ፥ ዒያርኮኮ ሆታ፥ ዓባ ኬስካ ባንፆይዳ ዓኣ ሳዖ ጊሽቲ ዔኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«ቄኤሳሢ ዓላዜሬና ኔዊ ናኣዚ ዒያሱና ዓጬሎ ዴሮም ጊሽኪ ዒንጎንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ዔያቶ ማኣዳንዳጉዲ ፔቴ ፔቴ ፃጳፓ ፔቴ ፔቴ ሱኡጌ ዔኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ዬና ዓሳ ሃካፓ ሊካ ፓይዲንታ ዓሶኬ፦ ዪሁዳ ማኣራፓ ዪፑኔ ናኣዚ ካኣሌቤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ሲሞኦኔ ፃጳፓ ዓምሁዴ ናኣዚ ሴላሚዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ቢኢኒያሜ ፃጳፓ ኪስሎኔ ናኣዚ ዔልዳዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ዳኣኔ ፃጳፓ ዩግሊ ናኣዚ ቡቂ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ዮሴፔ ናኣዚ ሚናኣሴ ፃጳፓ ሱፒዴ ናኣዚ ዓንዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ዮሴፔ ናኣዚ ዔፕሬኤሜ ፃጳፓ ሺፕፃኔ ናኣዚ ቄሙዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ዛብሎኦኔ ፃጳፓ ፔርናኬ ናኣዚ ዔልሳፒኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ዪሳኮኦሬ ፃጳፓ ሆዛ ናኣዚ ፔፂዔኤሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ዓሴኤሬ ፃጳፓ ሴሌሜ ናኣዚ ዓሂሁዴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ኒፕታኣሌኤሜ ፃጳፓ ዓምሁዴ ናኣዚ ፒዳሄሌ ጌይንታዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ዬና ዓሳ ዒስራዔኤሌ ዴሮም ካኣናኔ ዓጮይዳ ማዓ ሳዖ ሳዖ ጊሽኪ ዒንጋንዳጉዲ ናንጊና ናንጋ ጎዳ ዓይሤ ዓሶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ዒያርኮኮ ሆታ፥ ዮርዳኖሴ ዎሮኮ ሱካ፥ ሞዓኣቤ ቦኦሎይዳ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«ዒስራዔኤሌ ዓሳ ዔያቶም ዒንጊንቴ ሳዖይዳፓ ሌዊ ዓሳ ናንጋንዳ ካታማና ካታሞኮ ኮይሎይዳ ቆልሞ ሄንቃንዳ ቤሲያ ዒንጋንዳጉዲ ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ዬንሢ ካታሞንሢ ሌዊ ዓሶ ቤሲ ማዔም ዔያታ ዒኢካ ናንጋንዳኔ፤ ቆልማ ሄንቃ ቤዛኣ ዔያቶኮ ባኣቶና ሜሌ ቆልሞናም ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ቆልማ ሄንቃ ቤዛ ካታሞኮ ዙሎና ዲርቆና ዲፃፓ ቢያ ዛሎና ዶንጎ ፄኤታ ማዓ ታኣኪሢ ዳልጊ ዴንዳያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ያዺ ማዓዛ ካታሜላ ሳዛ ማዔም ዖይዶ ዛሎና ካኣማ ካኣማ ካሮ ሄላንዳኣና ዓኣ ሃኩማ ፔቴ ሺያ ታኣኪሢ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ዓይጎ ዓሲያ ማዖም ዻቢንቲ ዓሲ ዎዼቴ ጌሊ፥ ቶሊ ዓታንዳ ላሆ ካታማ ሌዊ ዓሶም ዒንጉዋቴ፤ ቃሲ ሃሣ ዖይዲታሚ ላምዖ ካታማ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ቆልሞ ሄንቃ ቤሲና ዎላ ዒንጉዋቴ፤ ያዺ ማዓዛ ካታማ ዎሊ ዑፃ ዖይዲታሚ ሳሊ ዔያቶኮ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ዒስራዔኤሌ ዓሶኮ ዓኣ ሳዖይዳፓ ሌዊ ዓሶም ዒንሢ ዒንጋንዳሢ ዔያቶኮ ካታማ ዓኣ ጎይፆ ጉዴያኬ፤ ጌይፃ፦ ሚርጌ ፃጳ ዓኣ ቶኦኮይዳፓ ሚርጌ ካታማ፤ ዻካ ፃጲ ዓኣ ቶኦኮይዳፓ ዻካ ካታማ ዔኪ ሌዊ ዓሶም ዒንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«ዒስራዔኤሌ ዓሶም ሂዚ ጌይ ኬኤዜ፤ ‹ዮርዳኖሴ ዎሮና ፒንቂ ካኣናኔ ዒንሢ ጌሌ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ፔቴ ዓሲ ዔሩዋዖ ዻቢንቲ ዓሲ ዎዼቴ ዓኣሺንቲ ቶሊ ዓታንዳ ካታማ ዶኦሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ዓሲ ዎዼ ዓሲ ሃይቄ ዓሢኮ ዒጊና ኮሚ ዒዛ ዎዹዋጉዲ ዬንሢ ካታሞይዳ ዓኣሺንቲ ጌሊ ዓታኒ ዳንዳዓኔ፤ ዓሲ ዎዼያ ማዔም ዎጌና ዓርቂንቴ ዓሲ ዎጊንቲባኣያታንቴ ዎዺንታኒ ኮይሱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ዬያሮ ላሆ ካታማ ዶኦሩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ዔያቶይዳፓ ሃይሦንሢ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ባንፃ፥ ሃይሦንሢ ሃሣ ካኣናኔ ዓጮይዳ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ዬንሢ ካታሞንሢ ዒስራዔኤሌ ዓሶንታ ዔያቶ ባኣካ ዻካ ዎዴያ ማዖም ሚርጌ ዎዴሮ ናንጋ፥ ሜሌ ዓጪ ዓሲንታም ዓኣሺንቲ ጌሊ ቶሎ ቤሲ ማዓንዳኔ፤ ዻቢንቲና ዓሲ ዎዼ ዓይጎ ዓሲያ ማዖም ዬንሢ ካታማፓ ፔቴማይዳ ዓኣሺንቲ ጌላኒ ዳንዳዓኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","ናንጊና ናንጋ ጎዳ ኬኤዛዖ፦ «ፔቴ ዓሲ ዔሬዖ ዓንጊና ማዔቴያ ሹቺና፥ ሃሣ ሚሢፓ ኮሺንቴ ዓንጋሞና ዓሲ ዎዼቴ ዬይ ዓሢ ዓሲ ዎዼያ ማዔሢሮ ዎዺንታንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ሃይቄ ዓሢኮ ዑኬ ማዔ ዒጊኒ ዬያ ዎዼ ዓሢ ዎዻኒ ዳንዳዓያታሢሮ ዴንቄቴ ዎዎዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","«ፔቴ ዓሲ ሜሌ ዓሲ ዒፂሢና ሂዒ ሎንሤም፤ ዬያጉዲ ሃሣ ጎይሢዳ ካቲ ዹዔያ፥ ዶርቤያ፤ ሃሣ ዢቤያ ማዔም፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ዬያጉዲ ጊንሣ ኩቺ ሙሊ ዱሌም ዓሢ ሃይቄያ ማዔቴ ዒዚ ዓሲ ዎዼያ ማዔሢሮ ዎዺንታንዳያ ኮይሳኔ፤ ዬያሮ ሃይቄ ዓሢኮ ዑኬ ዒጊኒ ዬያ ዓሢ ዎዻኒ ዳንዳዓሢሮ ዴንቄቴ ዎዎዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«ጋዓንቴ ፔቴ ዓሲ ዔሪባኣዖ ሜሌ ዓሲ ሂዒ ኬኤሪ፤ ሃሣ ዹይ፥ ዶርቢ፥ ዢቢ ዎዼያ ማዔቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ዬያጉዲ ሃሣ ሞርኬ ማዒባኣያ፥ ሃሣ ዓሲ ዎዻኒያ ማሊባኣዖ ሹቻ ዹይ ዎዼያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ዬያጉዴ ባኣዚ ማዔ ዎዶና ዓሳ ዎዼ ዓሢና ኮሞ ዔካኒ ጋዓ ዒጊኖም ሃካፓ ሊካ ዓይሢንቴ ዳምቦ ጎይፆ ዎጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ዓሲ ዎዺ ዎጌና ዓርቂንቴ ዓሢ ሃይቄ ዓሢኮ ዒጊኖይዳፓ ቶሊሲ ዓይሲ፥ ዒ ዓኣሺንቲ ጌሌ ካታሜሎ ጊንሣ ዔኪ ዴራ ጌልዞንጎ፤ ዬኖ ዎዶና ቄኤሶ ቢያሢኮ ሱኡጌ ማሆና ዓሢ ሃይቃንዳያ ሄላንዳኣና ዒኢካ ናንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ዓሶ ዎዼሢሮ ዎጎና ዓርቂንቴ ዓሢ ቶሊ ዓኣሺንቲ ዴዔ ካታሞ ሃሺ ዴንዴም፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ሃይቄ ዓሢኮ ዒጊና ዒዛ ዴንቂ ዎዼቴ ዬያጉዴ ኮሜ ዔኪፃ ዓሲ ዎዼያ ማሂ ዖኦጪሳያቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ዓይጎሮ ጌዔቴ ዬይ ዓሶ ዎዼ ዓሢ ቄኤሶ ቢያኮ ሱኡጋሢ ሃይቃንዳያ ሄላንዳኣና ዬኖ ዓኣሺንቶ ካታሜሎይዳ ናንጋንዳያ ኮይሳሢሮኬ፤ ቄኤሳሢ ሃይቄያ ማዔቴ ዬይ ዓሢ ፔ ማኣሪ ማዒ ዴንዳኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ሃይ ዎጎና ዳምቦና ዒንሢ ናንጋ ዓጮ ቢያይዳ ዒንሢንታ ዒንሢ ናኣቶንታም ማዺ ማዺ ናንጋያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","«ዓሲ ዎዺ ዎጌና ዓርቂንቴ ዓይጎ ዓሲያ ማዖም ሃይቃንዳጉዲ ዎጊንታኒ ዳንዳዓሢ ላምዖ ሃንጎ ላምዖይዳፓ ዑሣ ዓኣዼ ዓሲ ማርካዼቴኬ፤ ፔቴ ዓሲ ማርካዼ ማርካቶ ጋዓንቴ ዓሲ ዎዼ ዓሢ ዖኦጪሳኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ዓይጎ ዓሲያ ማዖም ዓሲ ዎዼቴ ሃይቃንዳጉዲ ዎጊንቶንጎ፤ ሚኢሼ ጪጊሢና ዬያ ዎጊንቴ ዎጎይዳፓ ቶላኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ፔቴ ዓሲ ዓኣሺንቲ ቶሎ ካታሞ ጌሊ ዓኣዖ ቄኤሶ ቢያኮ ሱኡጋሢ ሃይቁዋንቴ ሚኢሼ ጪጊ ፔ ማኣሪ ኬስኪ ዴንዳንዳጉዲ ዳኪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ዬያ ዒንሢ ማዼቴ ዒንሢ ናንጋ ዓጬሎ ዒንሢ ዒኢሳንዳኔ፤ ዓሲ ዎዺሢ ዓጪ ዒዒኢሳኔ፤ ዬያሮ ዓሲ ዎዼ ዓሢኮ ሱጉፃ ላኣሊንቲባኣንቴ ሳዖ ዬያ ሱጉፃፓ ጌኤሻኒ ማዺንታ ሜሌ ዳምቤ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ታኣኒ ናንጊና ናንጋ ጎዳ ማዔሢሮ፤ ሃሣ ዒንሢ፥ ዒስራዔኤሌ ዓሶ ባኣካ ታ ናንጋያታሢሮ ታኣኒ ናንጋ ሳዔሎ ዒኢሲፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ዮሴፔ ናኣዚ ሚናኣሴ ሾዔ፥ ማኪሬ ናኣዚ ጌሌዓዴ ቶኦኮኮ ማኣሮ ማኣሮ ሱኡጋ ሙሴና ሃንጎ ዒስራዔኤሌ ዴሮ ሱኡጎ ኮይላ ሙኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","«ዒፃ ዓጊ፥ ዓጬሎ ዒስራዔኤሌ ዴሮም ኔ ፓቃንዳጉዲ ናንጊና ናንጋ ጎዳ ኔና ዓይሤኔ፤ ዬያጉዲ ሃሣ ኑ ዒጊናሢ ፄሎፒሃዴ ሄላ ዛሎዋ ዒዛኮ ዉዱሮ ናኣቶም ዒንጋንዳጉዲ ኔና ዓይሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ጋዓንቴ ዔያታ ሜሌ ፃጳፓ ማዔ ዓቲንቄም ሌዔቴ ዔያቶኮ ዓጫ ዬኖ ፃጶ ማኣሮ ዓሶም ማዓዛ፥ ኑም ማዓሢ ዻካንዳያታሢ ዔሬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ሻንቺንቴ ባካ ማዓ ሌዖና ዔያቶኮ ዓኣ ባካ ዔያቶኮ ዓኒንሢ ፃጶም ማዓኔ፤ ዬይ ኑ ፃጶኮ ዓኣ ሳዖይዳፓ ዔኪ ዻኪሳያ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ሙሴ ዒማና ናንጊና ናንጋ ዒዛ ጎዳ ዓይሤ ጎይፆ ዒስራዔኤሌ ዴሮም፦ «ሚናኣሴ ማኣሮ ዓሳ ጌዔሢ ፒዜኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ዬያሮ ናንጊና ናንጋ ጎዳ ‹ፄሎፒሃዴኮ ዉዱሮ ናኣታ ዔያቶ ፃጶ ማዔ ዓሲ ማዔቴ ዔያታ ናሽኬ ዓሲም ሌዓኒ ዳንዳዓኔ› ጋዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ዬያይዳዛ ዓይጎ ዓሲኮዋ ማዖም ዒስራዔኤሌ ዓሶኮ ዓኣ ሳዓ ሜሌ ፃጶም ዒንጊንታዓኬ፤ ዬኖ ፃጶ ማኣሮሮ ማዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ዒስራዔኤሌ ፃጶ ማኣሮይዳ ሳዓ ዔኬ ዉዱሮ ናይ (ላኣሊ) ዬኖ ፃጶ ማኣራፓ ማዔ ዓቲንቄም ሎዓንዳያ ኮይሳኔ፤ ዬያይዲ ፔቴ ፔቴ ዒስራዔኤሌ ዓሳ ቤርታ ዓዶንሢ ቤዞ ዔያቶሮ ማሂ ዓርቃኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ዬይ ሳዓ ፔቴ ፃጶ ማኣራፓ ሜሌ ፃጶ ማኣሮም ዓኣዻኒ ዳንዳዓዑዋሴ፤ ፔቴ ፔቴ ፃጶ ማኣራ ማኣራ ፔኤኮ ዓኣ ሳዖ ዓርቂ ዴዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","ዬያሮ ፄሎፒሃዴኮ ዉዱሮ ናኣታ፦ ማሂላ፥ ቲርፃ፥ ሆግላ፥ ሚልካንታ ኖዓንታ ናንጊና ናንጋ ጎዳ ሙሴም ዓይሤ ጎይፆና ዓዶኮ ጌርሲንሢ ናኣቶም ሌዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ዔያታ ሌዔሢ ዮሴፔ ናኣዚ ሚናኣሴ ፃጶ ቶኦኮምኬ፤ ዬያይዲፆና ዔያቶኮ ሳዓ ዔያቶኮ ዓዶ ማኣሮ ፃጶም ማዒ ዓቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ዒስራዔኤሌ ዓሳ ዒያርኮኮ ሆታ፥ ዮርዳኖሴኮ ሱካ፥ ሞዓኣቤ ቦኦሎይዳ ዓኣንቴ ናንጊና ናንጋ ጎዳ ሙሴ ዛሎና ዔያቶም ዒንጌ ዓይሢፆንታ ዳምባኣ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ዒስራዔኤሌ ዴራ ዮርዳኖሴ ዎሮኮ ሱካ፥ ሱፔ ጎዖ ዓጮኮ ቤርቶ ዛላ ፔቴ ዛሎና ፓኣራኣኔ ካታማ ባጎ ዛሎና ቶፔሌ፥ ላባኔ፥ ሃፄሮቴና ዲዛሃባ ጌይንታ ካታማ ዓኣ ዓራባ ጌይንታ ዓሲ ናንጉዋ ዳውሎይዳ ዓኣንቴ ሙሴ ዔያቶም ሂዚ ጌይ ኬኤዜኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ዔዶኦሜ ጌሜሮ ጎይፆ ዴንዴቴ ሲና ዹኮይዳፓ ዴንዲ ቃዴሴ ባርኔ ሄላኒ ታጶ ፔቴ ኬሊ ሃንቲንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ጊብፄ ዓጫፓ ዔያታ ኬስኬንቴ ዖይዲታማሳ ሌዖኮ ታጶ ፔታሳ ዓጊና ፔቴ ጌዒ ዓርቃ ኬሎና ናንጊና ናንጋ ጎዳ ዒዛ ዒስራዔኤሌ ዴሮም ኬኤዞንጎ ጌዔ ባኮ ቢያ ሙሴ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ዬያ ዒ ኬኤዜሢ ሃሴቦኔ ካታሞይዳ ዴዒ ካኣታዺ ዎይሣ ዓሞራ ዓሶ ካኣቲ ሲሆኔንታ ዓስታሮቴና ዔድሬዒ ካታሞ ዎይሣ ባኣሳኣኔ ካኣቲ ዖጌንታ ዖሊ ባሼሢኮ ጊንፃፓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ዒስራዔኤሌ ዴራ ዮርዳኖሴኮ ዓባ ኬስካ ዛሎና ዓኣ ሞዓኣቤ ዓጮይዳ ዓኣንቴ ፆኦሲ ዒንጌ ዎጎ ሂዚ ጌይ ሙሴ ፔጋሲ ኬኤዚፆ ዓርቄኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«ሲና ዹኮ ኮይላ ኑ ዓኣ ዎዶና ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑም ሂዚ ጌዔኔ፤ ‹ሃኖ ዹኮ ኮይላ ሚርጌ ዒንሢ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ዬያሮ ሃኖ ቤዞ ሃሺ ሚርጌ ጌሜራ ዓኣ፥ ዓሞራ ዓጮና ኮይሎይዳ ዓኣ ዓጮ ዴንዱዋቴ፤ ዬይያ፦ ዓራባ ዓጮኮ ዓሎ ዓጮና ዳውሎ ዓጮ፥ ዾኦሎ ዛሎ ዓጮ፥ ሜዲቴራኒያ ባዞ ኮይሎ ዓጮ፥ ካኣናኔ ዓሶ ዓጮና ሊባኖኦሴ ዹኮይዴና ጌዒ ዴንዲ ዔፕራፂሴ ዎሮ ሄላንዳኣና ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ታኣኒ፥ ናንጊና ናንጋ ጎዳ ዬያ ዓጮ ዒንሢኮ ቤርታኣ ዓዶንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታም ዔያቶኮ ዜርፆማኣ ዻካልሳኒ ሃጊ ማዓንዳ ዎዛ ዒንጊ ጫኣቄሢሮ ዬኖ ዓጮ ዴንዲ ዻካሉዋቴ።› » ");
INSERT INTO mdyeth_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ሙሴ ዒማና ዴሮም፦ «ሃጊ ኑኡኒ ሲና ዹኮ ኮይላ ዓኣንቴ ታ ዒንሢም ‹ዒንሢ ዎይሢፃ ታኣም ዴኤፄኔ፤ ዬያ ቢያ ታኣሮ ማዻኒ ታ ዳንዳዑዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ሚርጊሼኔ፤ ዒንሢኮ ፓይዳኣ ጫሪንጮ ዉጫሢጉዲ ዺቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ቤርታኣ ዓዶንሢኮ ፆኦዛሢ ሃሢያ ዒንሢም ሃጊ ማዓንዳ ዎዞ ዒንጌ ጎይፆና ሚርጌ ሺያ ጳንጬ ማሂ ፓይዶ ዒንሢኮ ሚርጊሺ ዒንሢ ዓንጆንጎ! ");
INSERT INTO mdyeth_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ጋዓንቴ ዒንሢኮ ባኣካ ማዢንታ ፑርቱሞንታ ማርሚሢንታ ባይዛኒ ዬያ ዴኤፆ ማዾ ታኣሮ ታ ዎዲ ማዻንዳይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ፔቴ ፔቴ ፃጶይዳፓ ዔራ ማዔ ዓሲ፥ ሃሣ ዬያጉዴ ማዾ ማዺ ዔሬ ዓሲ ዶኦሩዋቴ፤ ታኣኒያ ዔያቶ ዒንሢ ዑፃ ሱኡጌ ማሂ ጌሣንዳኔ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ዒንሢያ ዬያ ማሊፆ ‹ቃራኬ› ጌዒ ዔኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ዬያሮ ፔቴ ፔቴ ፃጳፓ ዒንሢ ዶኦሬ፥ ቤርታ ዬኖ ጉዴ ማዾ ማዺ ዔሬ ዓሶ ዔኪ ዒንሢ ዑፃ ሱኡጌ ማሂ ታ ጌሤኔ። ዔያቶይዳፓ ዛሎ ሺያ ዓሲ ዎይሣያ፥ ዛሎ ፄኤታ ዓሲ ዎይሣያ፥ ሃንጎ ዓሶ ሃሣ ዶንጊታሚ ዓሲ ዎይሣያና ታጶ ዓሲ ዎይሣያ ማሂ ታ ዶኦሬኔ። ፔቴ ፔቴ ፃጶ ማኣሮዋ ዎይሣንዳ ዓሲ ታ ዶኦሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","«ዒማና ዔያቶም ታ፦ ‹ዒንሢኮ ዴሮ ባኣካ ማዢንታ ፑርቶ ባኮንታ ማርማሢ ጌኤዞዋ ዋይዙዋቴ፤ ዒንሢ ዴሮ ባኣካ ማዖም ሜሌ ዓጫፓ ሙኪ ዒንሢ ባኣካ ናንጋ ዓሶኮ ማዢንታ ፑርቶ ባኮንታ ሞኦቶ ቢያ ዛጊ ፒዜ ዎጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ዒንሢ ጌስቲ ዎጋ ዎዶና ዓሲ ዱማሲ ዎጊፖቴ፤ ዓይጎ ባኣዚያ ማዖም ዼኤፒ ዓሲ ማዔቴያ ዻካ ዓሲም ሄኮ ጌስቲ ዎጉዋቴ። ዒንሢ ዎጋሢ ፆኦሲ ዒንሢም ዻዋ ጎይፆና ማዓያታሢሮ ዖናኣ ዒጊጪፖቴ፤ ዒንሢም ዴኤፃ ባኣዚ ዓኣቴ ታ ኮይላ ዔኪ ዬዑዋቴ፤ ታ ጌስቲ ኩንሣንዳኔ› ");
INSERT INTO mdyeth_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ዒንሢ ማዻኒ ኮይሳ ባኮ ቢያ ዒማና ታ ዒንሢም ኬኤዜኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«ዬካፓ፦ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑና ዓይሤ ጎይፆና ሲና ዹኮ ኮይላፓ ዔቂ ሚርጌ ጌሜራ ዓኣ ዓሞራ ዓሶ ዓጮ ዔኪ ዓኣዻ፥ ዒንሢ ዛጌሢጉዲ ሚርጌ ሜታሳ ዓሲ ናንጉዋ ዳውሎ ጎይፆና ጌዒ ቃዴሴ ባርኔ ኑ ሄሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ዒኢካ ታ ዒንሢም፦ ‹ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑና ዻካልሳኒ ሃጊ ማዓንዳ ዎዞ ዒንጌ ሚርጌ ጌሜራ ዓኣ ዓሞራ ዓሶ ዓጮ ዓካሪ ዒንሢ ሄሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጌ ሳዔላ ሃኖኬ፤ ዛጉዋቴ፤ ኑኡኮ ቤርታኣ ዓዶንሢኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ጌሊ ዻካሉዋቴ፤ ዓልቲ ዒጊጪፖቴ።› ");
INSERT INTO mdyeth_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","«ጋዓንቴ ዒንሢ ታ ኮይላ ሙኪ፦ ‹ዓጬሎ ሙራንዳ ዓሲ ኑ ዳኮም፤ ዔያታ ዬኖ ዓጮ ሄሊሳንዳ ፒዜ ጎይፃ ዎይና ማዓንዳቴያ ዎዚጉዴ ካታማ ዓኣቴያ ዛጊ ኑም ኬኤዛኒ ዳንዳዓኔ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","«ታኣማኣ ዬያይዲፃ ኮሺ ማዒ ጴዼሢሮ ፔቴ ፔቴ ፃጳፓ ፔቴ ፔቴ ዓሲ ዶኦሪ ታጶ ላምዖ ዓሲ ታኣኒ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ዬካፓ ዔያታ ዬኖ ጌሜራ ሚርጌ ዓኣ ዓጬሎኮ ዴንዲ ዔሽኮሌ ዶኦጮ ሄላንዳኣና ሃንቲ ሃንቲ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ዒማና ዔያታ ዒኢካፓ ሙዎ ሚሢ ዓኣፒ ዻካ ኑም ዔኪ ሙኬኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑም ዒንጋኒ ማሌ ዓጬላ ሚርጌና ማሊ ማዔሢያ ዔያታ ኑም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","«ዒንሢ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሤ ባኮ ዋይዞ ዒፂ ዬኖ ዓጬሎ ጌላኒ ኮይባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ዒማና ዒንሢ ዒንሢኮ ማኣራ ዴዒ ‹ናንጊና ናንጋ ጎዳ ኑና ዒፄኔ፤ ጊብፄ ዓጫፓ ኑና ዒ ኬሴሢ ሃኣታ ዓሞራ ዓጮ ዓሳ ኑና ዎዻንዳጉዲ ዓኣሢ ዔያቶም ዒንጋኒ ኮዒኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ዓካሪ ኑ ዒኢካ ዓኣዻሢ ዓይጎሮዳይ? ዒኢካ ናንጋ ዓሳ ቢያ ዎልቄና ዓኣያ፤ ሃሣ ዔጳኣ ኑ ጊዳፓ ሚርጌና ዖዶሲ ማዔሢ ዬያጉዲ ሃሣ ዖዶሱማ ጫሪንቺ ዴንዴ ኬልቆና ዲሢና ኬልቂንቴ ካታማይዳ ዔያታ ናንጋያታሢ ኑኡኒ ዳኬ ዓሳ ኑም ኬኤዜኔ፤ ሚርጌና ዼኤፖ ዼኤፖ፥ ዔናኣቄ ናኣቶዋ ዔያታ ዴንቄኔ› ጌዒ ጉንዱሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","«ታኣኒ ጋዓንቴ ዒንሢም፦ ‹ዬያ ዴሮ ዒጊጪፖቴ፤ ሃሣ ዲቃቲፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ዒንሢ ዛጋንቴ ጊብፄይዳ ዒንሢም ዒ ማዼ ጎይፆ ዒንሢ ዛሎ ዖልታንዳሢ ዒንሢኮ ቤርታ ቤርታ ዓኣዻ ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ዓዴ ፔኤኮ ናዖ ኬዳሢጉዲ ናንጊና ናንጋ ጎዳ ማዔ ፆኦዛሢ ዒንሢ ዓኣዻ ቤዞ ቢያይዳ ዒንሢም ኮይሳ ባኮ ማዺ ማዺ ሃይካ ዒንሢ ሄሊሴሢ ዒንሢ ዛጌኔ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","ያዺ ማዔቴያ ዒንሢ ዱንኪ ዴዓንዳ ቤዞና ዒንሢ ዓኣዻንዳ ጎይፆ ዻዋኒ ሮኦሪ ሻኣሬና ዋንታኣና ታሚና ዒንሢኮ ቤርታ ቤርታ ማዒ ዒንሢ ዔኪ ዓኣዼ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ጉሙርቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","«ናንጊና ናንጋ ጎዳ ዒንሢ ጌዒ ሺራ ባኮ ዋይዚ ዻጋዼኔ፤ ዬያሮ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‹ታኣኒ ዒንሢኮ ቤርታኣ ዓዶንሢም ዻካልሳንዳኔ ጌዒ ሃጊ ማዓንዳ ዎዞ ዒንጌ፥ ዬኖ ማሎ ዓጬሎ ሃያ ፑርቶ ሾይንቶ ዓሶይዳፓ ፔቴ ዓሲታዖ ጌላዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ዬኖ ዓጬሎ ጌላኒ ዳንዳዓሢ ዪፑኔ ናኣዚ ካኣሌቤ ሌሊኬ፤ ዒዚ ጉቤ ዒናፓ ታኣም ጉሙርቂንታያ ማዔሢሮ ዬኖ ዒ ዴንዲ ዛጌ ዓጬሎ ዒዛና ዒዛኮ ዜርፆናም ታ ዒንጋንዳኔ› ጌዒ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ዒንሢ ፑርቲሴ ዛሎና ናንጊና ናንጋ ጎዳ ታ ጊዳታዖ ዻጋዺ፦ ‹ሙሴ! ኔኤኒያ ዬኖ ዓጬሎ ጌላዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ጋዓንቴ ኔና ማኣዲ ማዻ፥ ኔዊ ናኣዚ ዒያሱ ዬኖ ዓጬሎ ጌላንዳኔ፤ ዓጬሎ ዔያታ ዻካላንዳጉዲ ዒስራዔኤሌ ዴሮ ዔኪ ዓኣዻንዳሢ ዒዛታሢሮ ዒዛ ዶዲሼ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","«ዬካፓ፦ ናንጊና ናንጋ ጎዳ ኑና ቢያሢም ‹ኑኡኮ ሞርካ ዔያቶ ዲዒ ዔካንዳኔ ዒንሢ ጌዔ ናኣቶንታ ፑርቶና ኮዦና ዱማሲ ዔሪባኣ ዻኮ ናኣታ ሌሊ ዓጬሎ ዴንዲ ጌላንዳኔ፤ ዓጬሎ ታ ዔያቶም ዒንጌም ዔያታ ዻካላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ዒንሢ ጋዓንቴ ዞቄ ባዞ ባንሢ ዔኪ ዓኣዻ ጎይፆና ዓሲ ናንጉዋ ዳውሎ ማዒ ዴንዱዋቴ› ሂዚ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","«ዒማና ዒንሢ ‹ሙሴ! ኑኡኒ ናንጊና ናንጋ ጎዳም ዋይዞ ዒፂ ዻቤኔ፤ ሃሢ ዓካሪ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ዓይሤ ጎይፆና ኬስኪ ኑ ዖልታንዳኔ› ጌዒ ማሄኔ፤ ዬኖ ሚርጌ ጌሜራ ዓኣ ዓጬሎ ዓርቃኒ ሼሌዔ ዒንሢም ማሌሢሮ ዒንሢ ፔቴ ፔቴሢ ዖልዚ ዓንጋሞ ዔኪ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","«ናንጊና ናንጋ ጎዳ ጋዓንቴ ‹ታኣኒ ዔያቶና ዎላ ማዒንዱዋኣሢሮ ዖሎሮ ዔያታ ኬስኩዋጉዲ ዔያቶም ኬኤዜ፤ ዬያ ዔያታ ዋይዞ ዒፄቴ ሞርካ ዔያቶ ባሻንዳኔ ጌዒ ኬኤዜ› ታኣም ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ዬያ፥ ናንጊና ናንጋ ጎዳ ታኣም ጌዔ ባኮ ዒንሢም ታ ኬኤዜኔ፤ ዒንሢ ጋዓንቴ ዋይዞ ዒፄኔ፤ ዒዛም ዋይዞ ዒፂ ዖቶርሙሞና ጌሜራ ሚርጌ ዓኣ ዓጬሎ ዒንሢ ዖላኒ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ዬኖ ዓጮኮ ጌሜራ ጌሜራ ናንጋ ዓሞራ ዓሳ ኬስኪ ዒንሢ ዖሌኔ፤ ዔያታ ማሢጉዲ ዹኡቂ ዴንዲ ሆርማ ሄላንዳኣና ዳውሲ ዒንሢ ዳኬኔ፤ ጌሜራ ሚርጌ ዓኣ ዔዶኦሜ ዓጮይዳኣ ዖሎና ዒንሢ ዔያታ ባሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ዬያሮ ናንጊና ናንጋ ጎዳ ዒንሢ ማኣዳንዳጉዲ ዒላቲ ዒንሢ ዬኤኬኔ፤ ጋዓንቴ ዒዚ ዒላቶ ዒንሢኮ ዋይዛኒ ሃሣ ማኣዳኒያ ኮዒባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ያዺ ማዔሢሮ ቃዴሴይዳ ሚርጌ ዖዶሲ ዎዴ ዒንሢ ዴዔኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ሙሴ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ኑና ዓይሤ ጎይፆ ዓሲ ናንጉዋ ዳውሎ ባንፆና ዞቄ ባዞ ባንሢ ዔኪ ዴንዳ ጎይፆይዴና ጌይ ዔዶኦሜ ዓጮ ጌሜሮ ሚርጌ ኬሊ ኑ ሺሪ ሃንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ዬካፓ ናንጊና ናንጋ ጎዳ ታኣም፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‹ሃያ ጌሜራ ሚርጌ ዓጮይዳ ሚርጌ ኬሊ ሴካ ሃንጋ ጌዒ ሜታዺ ዒንሢ ሃንቴኔ፤ ሃሢ ጋዓንቴ ኬዶ ዛሎና ዴንዱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ዴሮም ሂዚ ጌዒ ዓይሤ፦ ዒንሢኮ ዒጊኖ ማዔ፥ ዔኤሳዎ ዜርፃ ናንጋ ጌሜራ ሚርጌ ዓኣ ዔዶኦሜ ዓጮይዴና ዴንዱዋቴ፤ ዔያታ ዒንሢ ዒጊጫንዳኔ፤ ጋዓንቴ ዒንሢና ኮሺ ዔሩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ዔያታ ዒንሢ ዖላንዳጉዲ ዔያቶና ፑርቲ ዖልቲፖቴ፤ ዓይጎሮ ጌዔቴ ዔያታ ዴዒ ዓኣ ዓጮይዳፓ ቶኪ ሄርቃንዳጉዴ ቤሲታዖ ታ ዒንሢም ዒንጊንዱዋሴ፤ ዔዶኦሜ ዓጮኮ ጌሜራ ሚርጌ ዓኣ ዓጮ ዔኤሳዎ ዜርፆሮ ማሂ ታ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ዒንሢም ኮይሳ ሙዖና ዋኣፆና ሚኢሼና ሻንቂ ዔኩዋቴ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ማዻ ማዾና ቢያ ሚርጌ ዓንጆ ዒንሢም ዒንጌኔ፤ ሃያ ሜታሳ ዓሲ ናንጉዋ ዳውሎይዳኣ ሜታዺ ዒንሢ ሃንቴ ዎዶና ዒንሢም ኮይሳ ባኮ ኩንሢ ዒንሢ ዒ ካፔኔ፤ ሃሣ ዖይዲታሚ ሌዖ ቢያ ናንጊና ናንጋ ጎዳ ዒንሢና ማዔሢሮ ፔቴታዖ ዒንሢም ፓጬ ባኣዚ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","«ዬያሮ ኑኡኮ ዒጊና፥ ዔኤሳዎ ዜርፃ ናንጋ ዔዶኦሜ ዓጮ ጊዴና ጌዒ ዔላቴና ዔፂዮንጋብሬ ካታሞናይዳፓ ሙካ ጎይፆና ዓራባ ባንፆና ጌዒ ዓሲ ናንጉዋ ሞዓኣቤ ዳውሎ ባንሢ ማዒ ኑ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ናንጊና ናንጋ ጎዳ ሃሣ ታኣም፦ ‹ሎኦፄ ዜርፆ ማዔ፥ ሞዓኣቤ ዓሶ ሜታሲፖቴ፤ ዔያቶና ዎላ ፑርቲ ዖልቲፖቴ፤ ዔኤሬ ካታሞ ዔያታ ናንጋንዳጉዲ ታ ዒንጌኔ፤ ዬያሮ ዔያቶ ዓጫፓ ታ ዒንሢም ዻካ ቤሲታዖ ዒንጋዓኬ› ጌዔኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ናንጊና ናንጋ ጎዳ ሞዓኣቤ ዓሶም ዒንጋንዳሢኮ ቤርታ ዔሚሜ ጌይንታያ ዎልቄና ዓኣ፥ ዺቢ ዴሬ ዔኤሬይዳ ናንጋኔ፤ ዔያታ ዼኤፒ ማዔያ ዔናኣቄ ዓሶጉዲ ዖዶሲ ዓሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ዔናኣቄ ዓሶጉዲ ዔያታኣ ሬፓ ዓሶ ጌይንታያኬ። ሞዓኣቤ ዓሳ ጋዓንቴ ዔያቶ ዔሚሜ ዓሶ ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ሆኦሬ ዓሳኣ ዔዶኦሜይዳ ናንጋንቴ ዔኤሳዎ ዜርፃ ዔያቶ ዳውሲ ባይዚ ቤዛ ዴዔኔ፤ ዬኖ ጎይፆ ዒስራዔኤሌ ዓሳ ናንጊቤቃ ናንጊና ናንጋ ጎዳ ዔያቶም ዒንጌ ዓጬሎይዳፓ ካኣናኔ ዓሶ ዳውሲ ኬሲ ቤዛ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","«ዬካፓ ናንጊና ናንጋ ጎዳ ኑና ዓይሤ ጎይፆ ዜሬዴ ዎሮና ኑ ፒንቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ዬይ ባካ ማዺንቴሢ ቃዴሴባርኔይዳፓ ኑ ዴንዴንቴ ሃይሢታሚ ሳሊ ሌዔኮ ጊንፃፓኬ፤ ናንጊና ናንጋ ጎዳ ዔያቶ ዛሎ ቤርታ ጫኣቄ ጎይፆና ዖልዚ ዖላኒ ዳንዳዓ ዓቲንቃ ቢያ ዒማና ጋጋፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ናንጊና ናንጋ ጎዳ ጉቤ ዔያቶ ባይዛንዳያ ሄላንዳኣና ዔያቶ ዒፂ ማኪፆ ዒ ሃሺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","«ዔያታ ጉቤ ጋፔስካፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ናንጊና ናንጋ ጎዳ ታኣም ሂዚ ጌዔኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‹ዔኤሬ ካታሞ ባንሢ ዔኪ ዓኣዻ ጎይፆና ሞዓኣቤ ዓጮኮ ጊዴና ሃኖ ዒንሢ ዓዓኣዻንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ዬካፓ ሎኦፄ ዜርፃ ናንጋ፥ ዓሞኦኔ ዓሶ ዓጮ ሙኪ ዑካዖ ዔያቶዋ ሜታሲፖቴ፤ ዔያታ ዒንሢ ዖላንዳጉዲ ፑርቲ ዔያቶና ዖልቲፖቴ፤ ዔያቶም ታ ዒንጌ ሳዓፓ ዻካታዖ ታ ዒንሢም ዒንጋዓኬ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ዬና ቤዛ ዒኢካ ናንጋ ዴራ ዔኤላ ጎይፆና ሬፓ ዓሶ ዓጮ ጌይንታኔ፤ ዓሞራ ዓሳ ጋዓንቴ ዛምዙሚሜ ዓሶ ዔያቶ ጋዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ዔያታ ዔናኣቄ ዓሶጉዲ ዔጶና ዖዶሲ፥ ሃሣ ዎልቄና ዓኣያ ዺቢያ ዺቢ ዴሬኬ፤ ጋዓንቴ ዓሞኦኔ ዓሳ ፆኦሲ ዎልቄና ዔያቶ ባይዚ ሳዖ ዔያቶሲ ዔኪ ዒኢካ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ናንጊና ናንጋ ጎዳ ጌሜራ ሚርጌ ዓኣ ዓጬሎ ዔዶኦሜይዳ ናንጋ ዔኤሳዎ ዜርፆም ዬኖጉዴ ባኣዚ ማዼኔ፤ ዎዎዴይ ጌዔቴ ቤርታ ዬኖ ዓጮይዳ ናንጋ ሆኦሬ ዓሶ ባይዚ ሃኖ ሄላኒ ዔያታ ናንጋ ዓጬሎ ዔዶኦሜ ዓሳ ፔ ዓጪ ማሂ ዔኪ ናንጋንዳጉዲ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ቄርፄሴ ጌይንታ ዋኣፆ ሳዛ ዓኣ ዓጬሎፓ ሙኬ ዴራ ጋኣዛ ካታሞ ኮይላ ናንጋ ዔዋዌ ዓሶ ጌይንታ፥ ዒኢካ ናንጋ ዓሶ ባይዚ ዔያቶ ቤዛ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","«ዒማና ሞዓኣቤ ዓጮ ጊዴና ኑ ዓኣዼስካፓ ናንጊና ናንጋ ጎዳ ኑም ሂዚ ጌዔኔ፦ ‹ሃሢ ዔቂ ዓርኖኦኔ ዎሮና ፒንቁዋቴ፤ ሃሴቦኦኔ ካታሞ ዎይሣ ዓሞራ ዓጮ ካኣቲ ሲሆኔ ዒዛኮ ዓጮና ዎላ ታ ዒንሢም ዓኣሢ ዒንጌኔ፤ ዔያቶ ዖሊ ዓጮ ዔያቶኮ ዔኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ሃይማፓ ዓርቃዖ ዓንኮይዳኣ ማዖም ናንጋ ዴራ ዒንሢ ዒጊጫንዳጉዲ ታ ማሃንዳኔ፤ ዒንሢ ዛሎ ዋይዛዖ ቢያሢ ዒጊጪ ጎጋይቃንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","«ዬካፓ ዓሲ ናንጉዋ ቄዴሞቴ ዳውላፓ ሃሴቦኦኔ ካኣቲ ሲሆኔም ኮሹሞ ኪኢታ ዓሲ ሂዚ ጌይ ታኣኒ ዳኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‹ዒንሢ ዓጮ ጊዴና ኑና ዳኩዋቴራ፤ ጎይፃፓ ኑ ኬስኪ ሚዛቂ ሻውላ ጎዑዋዖ ፒዜ ኑ ዴንዳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ኑ ሙዓንዳ ሙዖና ዑሽካንዳ ዋኣፆና ኑ ሻሻንቃንዳኔ፤ ኑኡኒ ኮዓሢ ኔ ዓጮይዴና ዓኣዺፆማ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ዔዶኦሜይዳ ናንጋ ዔኤሳዎ ዜርፆና ዔሬይዳ ናንጋ ሞዓኣቤ ዜርፃ ዔያቶ ዓጮ ጊዴና ኑና ዳኬሢጉዲ ዮርዳኖሴ ዎሮ ኑኡኒ ፒንቂ፥ ናንጊና ናንጋ ኑ ጎዳሢ ኑና ዻካልሳ ዓጮ ኑ ጌላንዳያ ሄላንዳኣና ዒኢና ኑ ዓኣዾም ዳኬቴራ።› ");
INSERT INTO mdyeth_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","«ሃሴቦኦኔ ካኣቲ ሲሆኔ ጋዓንቴ ዒዛ ዓጮ ጊዴና ኑ ዓኣዹዋጉዲ ላኣጌኔ፤ ሃሢ ማዼ ጎይፆ ዒንሢኮ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛ ዓኣሢ ዒንሢም ዒንጋኒ ኮዔሢሮ ዒዛኮ ዒኖ ዶዲሺ ዒፃያ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","«ዬካፓ ናንጊና ናንጋ ጎዳ ሂዚ ታኣም ጌዔኔ፤ ‹ሃኣዛጌ፤ ታኣኒ ካኣቲ ሲሆኔንታ ዒዛኮ ዓጮንታ ኔኤም ዓኣሢ ዒንጌኔ፤ ሃሢ ዓካሪ ዒዛ ዖሊ ባሺ ዓጮ ዔኪጋፓ ዒኢካ ዴዔ።› ");
INSERT INTO mdyeth_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ዒማና ካኣቲ ሲሆኔ ዒዛኮ ዓሶ ቢያ ዔኪ ያሃፄ ካታሞ ኮይላ ኑና ዖላኒ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑም ዒዛ ዓኣሢ ዒንጌሢሮ ዒዛንታ ዒዛኮ ናኣቶንታ ዓኣ ባኮዋ ቢያ ኑ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ኑኡኒ ኔጉዋዖ ፔቴ ፔቴ ካታሞ ጉቤ ዓርቂ ሚቼኔ፤ ዬኖ ካታሞይዳ ቢያ ዓኣ ዓሶ ዓቲንቃ፥ ላኣላ ናኣቶዋ ፔቴታዖ ዓይሱዋዖ ጉቤ ጋፒሲ ኑ ዎዺ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ቆልሞዋ ኑ ዔኬኔ፤ ካታሞዋ ቡሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ጉቤ ካታሞ ኑም ዓኣሢ ዒንጌሢሮ ዓርኖኦኔ ዶኦጮኮ ዛጶይዳ ዓኣ ዓሮዔኤሬና ዶኦጮናይዳ ዓኣ ካታሞይዳፓ ዓርቃዖ ዴንዲ ጌሌዓዴ ሄላንዳኣና ኑና ቃዛኒ ዳንዳዔ ካታማ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑ ሄሉዋጉዲ ላኣጌ ዓጮ ጌይፃ፦ ዓሞኦኔ ዓሶ ዓጮ ኮይሎ፤ ያኣቦቄ ዎሮ ኮይሎ፤ ጌሜራ ሚርጌ ዓኣ ካታሞንታኮ ፔቴ ካታማ ባንሢታዖ ኑ ዑኪባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ሙሴ ኬኤዛዖ፦ «ዬካፓ ሃሣ ኑ ኬዶ ዛሎና ጌዒ ባኣሳኣኔ ካኣቲ ዓጮ ዴንዴኔ፤ ዒማና ካኣቲ ዖኦጌ ፔኤኮ ዴሮ ቢያ ዔኪ ዔድሬዒ ካታሞይዳ ኑኡና ዖልታኒ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ናንጊና ናንጋ ጎዳ ጋዓንቴ ታኣም ሂዚ ጌዔኔ፤ ‹ዒዛ ዒጊጪፖ፤ ዒዛንታ ዒዛኮ ዴሮንታ ዓጮዋ ቢያ ታ ኔኤም ዓኣሢ ዒንጋንዳኔ፤ ሃኣሴቦኔይዳ ዴዒ ዎይሣ፥ ዓሞራ ዓጮ ካኣቲ ሲሆኔ ኔ ማዼ ጎይፆ ሃያኣ ዒማይዴ።› ");
INSERT INTO mdyeth_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","«ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ባኣሳኣኔ ዓጮ ካኣቲ ዖኦጌንታ ዴሮንታ ዬያይዲ ኑም ዓኣሢ ዒንጌኔ፤ ኑኡኒ ዔያቶይዳፓ ፔቴታዖ ዓይሱዋዖ ቢያሢ ዎዺ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ዬማና ካታሞዋ ቢያ ኑ ዓርቄኔ፤ ኑ ዓርቂባኣ ካታማ ፔቴታዖ ባኣሴ፤ ባኣሳኣኔ ካኣቲ ዖኦጌ ዓርጎባ ዓጮ ዴማ ማሂ ዎይሣ ላሂታሚ ካታማ ዬያይዲ ኑ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ዬይ ካታማ ቢያ ዼጌ፥ ዖዶሲ፥ ኬኤላ ዲሢና ዲርቂንቴያኬ፤ ኬኤሎ ዲሮኮ ካራ ጋጋርቂ ዎዾናያኬ፤ ሃሣ ዙላ ኬልቂ ዲርቂንቲባኣ ጉርዳ ዒማና ሚርጌ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ቤርታ ሃሴቦኦኔ ካኣቲ ሲሆኔፓ ኑ ዔኬ ካታሞ ማዼ ጎይፆ ዬኖ ካታሞዋ ቢያ ኑ ባይዜኔ፤ ዓቲንቆንታ ላኣሎንታ ናኣቶዋ ዓይሱዋዖ ኑ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ቆልሞ ቢያ ኑ ዲዒ ዔኬኔ፤ ካታሞዋ ኑ ቡሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","«ዒማና ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛላ ዓኣ ቤዞ፤ ሃሣ ዓርኖኦኔ ዶኦጮይዳፓ ዴንዲ ሄርሞኔ ዹኮ ሄላንዳኣና ዓኣ ዔያቶሮ ማዔ ዓጮ ዬንሢ ላምዖ ዓሞራ ዓጮ ካኣቶንሢዳፓ ባሺ ኑ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","ሄርሞኔ ዹኮኮ ሱንፆ ሲዶና ዓሳ ሲሪዮኔ ጋዓዛ፥ ዓሞራ ዓሳ ጋዓንቴ ሴኒሬ ጌይ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ዬያይዲ ባኣሳኣኔ ካኣቲ ዖኦጌ ዎይሣ ዓጮ ጌይፃ፦ ዓሎ ዓጮይዳ ዓኣ ሳላካና ዓባ ኬስካ ዛላ ዓኣ ዔድሬዒ ጌይንታ ካታሞንሢንታ ጌሌዓዴንታ ባኣሳኣኔ ዴማ ዓኣ ዓጮ ቢያሢ ኑ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ሬኤፓ ዓሶ ፃጳፓ ዓቴሢ ባኣሳኣኔ ካኣቲ ዖኦጌ ሌሊኬ፤ ዒዛኮ ዓልጋ ዓንጊና ኮሺንቴያ ማዓዛ ዔርቴ ዋዾና ዋርቂንታዛ ዖዶሱማ ሳሊ ዋዻ፤ ዳልጉማ ዖይዶ ዋዻ ማዓያኬ። ዬይ ዓልጋ ራኣባ ጌይንታ ዓሞኦኔ ዓሶ ካታሞይዳ ሃኖ ሄላንዳኣና ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","«ዓጬሎ ጌሊ ኑ ዔኬስካፓ ዓርኖኦኔ ዎሮ ኮይሎይዳ ዓኣ ዓሮዔኤሬ ካታማፓ ዴንዲ ኬዶ ዛሊና ዓኣ ዓጮንታ ጌሜራ ሚርጌ ዓኣ ጌሌዓዴ ዓጮኮ ዛሎንታ ካታሞና ዎላ ሮኦቤኤሌና ጋኣዴ ማኣሮ ዓሶናም ታ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ሚናኣሴ ማኣሮ ዓሶኮ ሄካሢም ጌሌዓዴ ዓጮኮ ዓቴ ቤዞና ካኣቲ ዖኦጌ ዎይሣ ባኣሳኣኔ ዓጮ ጉቤ ታ ዒንጌኔ፤ ዬና ዓጫ ዓርጎቤ ዓጮ ጋራ ዓኣያኬ።» ባኣሳኣኔ ሬኤፓ ዓሶ ዓጪ ጌይንታያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ሚናኣሴ ማኣሪ ዓሲ ማዔ፥ ያዒሬ ጎዖሢ ዓርጎባ ዓጮ ጉቤ ዔኬኔ፤ ዬይ ዓጫ ዴንዲ ጌሹሬና ማዕካ ዓጮ ዛጶ ሄሊ ዓኣ ባኣሳኣኔ ዓጮኬ፤ ዬኖ ዓጮይዳ ዓኣ ጉርዶ ፔ ሱንፆና ሱንፆና ዒ ጌሢሲሴኔ፤ ዬያሮ ዬይ ጉርዳ ሃኖ ሄላኒ ያዒሬ ጉርዶ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","«ጌሌዓዴ ዓጮ፦ ሚናኣሴ ማኣሪ ዓሲ ማዔ፥ ማኪሬ ጎዖሢም ታኣኒ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ሃሣ ሮኦቤኤሌና ጋኣዴ ማኣሮ ዓሶናም ጌሌዓዴይዳፓ ዴንዲ ዓርኖኦኔ ዎሮ ኮይላ ዓኣ ዓጮ ጉቤ ታ ዒንጌኔ፤ ዔያቶኮ ዾኦሎ ዛሎ ዛጳ ዓርኖኦኔ ዎሮኮ ሳዞማና ማዓዛ፥ ኬዶ ዛሎ ዛጳ ዓሞኦኔ ዓሶ ዓጮኮዋ ዛጶ ማዔ ያኣቦቄ ዎሮናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ዔያቶኮ ዓባ ጌላ ዛሎይዳ ዓኣ ዓጫ፦ ዓራባና ዮርዳኖሴና ሃሣ ኮይሎይዳ ዓኣ ዓጮ ቢያኬ፤ ዓባ ኬስካ ዛሎና ዔያቶኮ ዓኣ ዓጫ፦ ጌሊላ ባዛፓ ዓርቃዖ ዴንዲ ፒሲጋ ዹኮ ዴማ ዓኣ ሶኦጌ ባዚ ሄላንዳኣናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","«ዒማና ታ ዔያቶም፦ ‹ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛሎና ዓኣ ሃያ ዓጮ ዒንሢ ዻካላንዳጉዲ ዒንሢም ዒንጌኔ፤ ዓካሪ ዒንሢኮ ዖላኒ ዳንዳዓ ዓሶም ዓንጋሞ ዒንጊጋፓ ሃንጎ ዒስራዔኤሌ ዓሳ ፔ ዓጮ ዔካንዳያ ሄላንዳኣና ዔያቶ ማኣዲ ቤርታ ኬስኪ ዖላንዳጉዲ ዳኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ዒንሢኮ ሚርጌ ቆልሞ ዓኣሢ ታ ዔራኔ፤ ዬያሮ ዒንሢኮ ላኣሎንታ ናኣቶንታ ቆልሞንታ ሌሊ ሃይካ ዓቶንጎ፤ ዔያቶ ሃይካ ታ ዒንሢም ዒንጌ ካታማ ሃሺ ዴንዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ዒንሢኮ ፆኦሲ ዒንሢም ሃይካ ማዼ ጎይፆ ዔያቶማኣ ዒዚ ዻካልሳንዳ፥ ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛላ ዓኣ ዓጮ ዒንጊ ኮሺና ሃውሺሲ ዴይሣንዳያ ሄላንዳኣና ዒንሢኮ ዒጊኖ ማዔ ዒስራዔኤሌ ዓሶ ማኣዱዋቴ፤ ዬካፓ ታ ዒንሢም ዒንጌ ሃኖ ዓጮ ማዒ ሙካኒ ዒንሢ ዳንዳዓኔ› ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","«ሃሣ ዒያሱ ታኣኒ ሂዚ ጌይ ዞሬኔ፦ ‹ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሲሆኔና ዖኦጌና ጌይንታ ላምዖ ካኣቶንሢ ማዼ ባኮ ዒንሢ ዓኣፒና ዒንሢ ዛጌኔ፤ ዒንሢ ዻካላንዳ ዓጮ ጉቤይዳ ዓኣ ዴሮ ዒማ ጎይፆ ዒ ማዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ዒንሢ ዛሎ ዖልታንዳሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ማዔሢሮ ዬያቶ ዒጊጪፖቴ።› » ");
INSERT INTO mdyeth_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","«ዒማና ታኣኒ ሂዚ ጌይ ዒናፓ ሺኢቄኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‹ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲዮ! ሃጊ ኔ ማዻንዳ ዼኤፖ ዼኤፖ ባኮና ዲቃሢ ሄርሺሳ ባኮ ጉቤሢናይዳፓ ኔ ታኣም ዻዌሢ ዓይፆ ካሮ ሌሊ ማዔሢ ታ ዔራኔ፤ ኔኤኒ ማዻ ዼኤፖ ዼኤፖ ባኮ ማዻንዳ ሜሌ ፆኦሲ ጫሪንጮይዳ ማዔቴ ሳዓ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ናንጊና ናንጋ ጎዳሢዮ! ዮርዳኖሴ ዎሮና ታኣኒ ፒንቂ ዎሮኮ ሶ ሱካ ዓኣ ኮዦ ዓጬሎ፤ ሃሣ ሚርጌ ጌሜራ ዓኣ ማሎ ዓጬሎንታ ሊባኖኦሴ ዹኮንታ ታና ዛጊሴቴራ።› ");
INSERT INTO mdyeth_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","«ጋዓንቴ ዒንሢ ማዼ ባኮ ዛሎና ናንጊና ናንጋ ጎዳ ታጊዳ ዻጋዺ፥ ሺኢጲፆ ታኣኮ ዋይዞ ዒፂ፦ ‹ማይ ጊዳንዳኔ! ላሚ ዬኖ ባኮ ታና ዖኦጪፖ! ");
INSERT INTO mdyeth_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ሃሢ ዔቂጋፓ ፒሲጋ ዹኮ ኬስኬ፤ ኔኤኒ ዮርዳኖሴ ዎሮና ፒንቂ ዴንዲንዱዋኣሢሮ ዒኢካ ዔቂ ዓኣፓ ኔኤም ጴዻ ቤዞ ዓጬሎኮ ኬዶ ዛሎንታ ዾኦሎ ዛሎንታ፤ ዓባ ኬስካ ባንፆንታ ጌላ ባንፆንታ ቢያ ዛጌ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ዬያ ጌይፆይዳፓ፦ ዒያሱ ማዻንዳ ባኮ ኬኤዜ፤ ዞሪ ዒዛ ዶዲሼ፤ ዴራ ፒንቂ ኔ ዛጋንዳ ዓጬሎ ዻካላንዳጉዲ ዔያቶ ዔኪ ዓኣዻንዳሢ ዒዛኬ› ታ ኮይላ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","«ዬያሮ ኑኡኒ ቤትፔዖሬ ጌይንታ ካታሞኮ ቤርቶ ዛላ ዓኣ ዶኦጮይዳ ዴዔኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ዬካፓ ሙሴ ዴሮም፦ «ዒስራዔኤሌ ዓሲዮቴ! ዓካሪ ታ ዒንሢም ኬኤዛ ዎጎና ዳምቦና ቢያ ማዺ ኩንሣያ ማዑዋቴ፤ ዬያ ዒንሢ ማዼቴ ሼምፔና ናንጋንዳኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ቤርታኣ ዓዶንሢ ፆኦዛሢ ዒንሢም ዒንጋንዳ ዓጮ ጌሊ ዒንሢ ዻካላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ታ ዒንሢም ኬኤዛ ዎጎይዳ ዓይጎ ባኣዚያ ቃሲፖቴ፤ ሃሣ ዓይጎ ባኣዚያ ፓጪሲፖቴ፤ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሣ ዓይሢፆ፥ ታኣኒ ዒንሢም ኬኤዛሢ ማዺ ኩንሣያ ማዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ፔዖሬ ዹኮይዳ ማዼ ባኮ ቢያ ዒንሢ ዓኣፒና ዒንሢ ዛጌኔ፤ ዬይያ፦ ዬኖ ዹኮይዳ ባዓኣሌ ጌይንታ ካኣሽኮ ፆኦዞም ዚጊ ካኣሽኬ ዓሶ ቢያ ባይዜሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ዒንሢ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ጉሙርቂንታያ ማዔሢሮ ሃኖ ሄላንዳኣና ሼምፔና ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","«ናንጊና ናንጋ ጎዳ ማዔ ታ ፆኦዛሢ ዒንሢም ኬኤዛንዳጉዲ ታና ዓይሤ ዎጎና ዳምቦና ቢያ ታ ዒንሢም ዔርዜኔ፤ ዒንሢ ጌሊ ዻካላንዳ ዓጬሎ ጌሊ ናንጋ ዎዶና ሃንሢ ዓይሢፆንሢ ቦንቺ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ዬያ ዓይሢፆ ዛጊ ካፑዋቴ፤ ዬያ ዒንሢ ማዼቴ ሚርጌና ዒንሢ ዔራ፥ ሃሣ ጪንጫ ማዔሢ ሜሌ ዴራ ዛጋንዳኔ፤ ዬይ ዴራ ዬያ ዓይሢፆ ዛሎ ዋይዛዖ ‹ሃያ ዺቦ ዴሮም ዎዚጉዴ ዔራቶና ጪንጩሞና ዒንጊንቴይ!› ጌይ ዲቃቲ ሄርሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","«ኑኡኒ ሺኢቃ ዎዶና ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑኡኮ ዑኬ ማዓሢጉዲ ሜሌ ዓይጎ ዺቢ ዴሬ ዓኣይ፥ ፔ ፆኦዛ ዑኬ ማዔይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ዎዚ ዺቢ ዴሬ ማዔቴያ ሃኖ ታኣኒ ዒንሢ ቤርታ ዔቂ ዔርዛ፥ ፒዜ፤ ሃሣ ዻቢንቲባኣ ሃያ ዎጎና ዳምቦናጉዲ ዓኣ ዴሬ ዓንካ ዓኣይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","ዓካሪ፥ ዒንሢ ናንጋ ዎዶይዳ ቢያ ሃያ ዓኣፖና ዒንሢ ዛጌ ባኮ ቢያ ዋሉዋጉዲ፤ ሃሣ ዒንሢኮ ዒናፓኣ ባይቁዋጉዲ ኮሺ ዔሩዋቴ። ዒንሢኮ ናኣቶና ናኣቶኮ ናኣቶናም ኬኤዚ ዔርዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ታኣም፦ ‹ታኣኒ ኬኤዛሢ ዔያታ ዋይዞም ታ ኮዓሢሮ ዴሮ ቡኩሴ› ጌዔ ዎዶና ሲና ዹኮ ኮይላ ዒዛ ቤርታ ዒንሢ ዔቄ ኬሎና ‹ዔያታ ናንጋ ዎዶይዳ ቢያ ታኣም ዔያታ ዓይሢንታንዳጉዲና ዔያቶኮ ናኣታ ታና ዒጊጪሢ ዔራንዳጉዲ ዔያታ ፔ ናኣቶም ኬኤዚ ዔርዞንጎ› ጌዔሢ ጶቂሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","«ጫሪማኣሪ ዓኣዺ ዼግ ጌዔ ታሞ ሎስታሢና ዲም ጌዔ ጩቦ ሻኣሮና ባይዜ ዹኮኮ ዴማ ሙኪ ዒንሢ ዔቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ዒማና ታሞ ሎስታሢ ባኣካ ማዒ ናንጊና ናንጋ ጎዳ ዒንሢም ኬኤዜኔ፤ ዒ ጌዔ ባኮዋ ዒንሢ ዋይዜኔ፤ ዑኡዞ ሌሊ ዒንሢ ዋይዜያፓዓቴም ዑፆ ዒዛኮ ዒንሢ ጋዓንቴ ዴንቂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ዒዚ ዒንሢና ዎላ ጫኣቄ ጫኣቁሞ፤ ጌይፃ፦ ዒንሢ ካፓንዳጉዲ ዒንሢ ዒ ዓይሤ ታጶ ዓይሢፆንሢ ዒንሢም ኬኤዜኔ፤ ሃሣ ዬያ ዓይሢፆ ላምዖ ዓርሲንቴ ሹቺዳ ዒ ፃኣፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ዒንሢ ዖሊ ባሺ ዻካሊ ናንጋንዳ ዓጬሎይዳ ዒንሢ ናንጋ ዎዶና ማዺ ኩንሣንዳ ዎጎና ዳምቦና ታ ዒንሢም ኬኤዚ ዔርዛንዳጉዲ ናንጊና ናንጋ ጎዳ ታና ዓይሤኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","16","ሙሴ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ሲና ዹኮይዳ ዔኤታ ታሞ ሎስታሢ ባኣካ ማዒ ዒንሢም ኬኤዜ ዎዶና ፔቴታዖ ዑፆ ዒዛኮ ዒንሢ ዴንቂባኣሴ፤ ዬያሮ ዓቲንቄ ማሎና ማዖም ላኣሊ ማሎና ካኣሽኮ ባኣዚ ማዢ ዒንሢ ዒኢቱዋጉዲ ዒንሢና ኮሺ ዔሩዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ቆልሞንታ ካይዚ ቦዖንታ ካፒንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ሃሣ ጊንሣ ዳዲና ጎቺንቲ ሃንታ ባኮና ሳዖኮ ዴማ ዋኣፆ ሳዛ ናንጋ ሞላሢ ማሎዋ ማዖም ዓይጎ ባኣዚኮዋ ማሎ ካኣሽኮ ባኣዚ ማሂ ማዢፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ጫሪንጮይዳ ዒንሢ ዛጋ ዓቦንታ ዓጊኖንታ፥ ሃሣ ዦኦጋሢያ ማዖም ጫሪንጫ ዓኣ ማዢንቶ ቢያ ፆኦሲ ማሂ ዚጊ ካኣሽካኒ ዒንሢ ኮዑዋጉዲ ዒንሢና ዔሩዋቴ፤ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ዬያ ባኮ ቢያ ዒንሢ ዜርፆ ማዒባኣ ሜሌ ዴራ ካኣሽካንዳጉዲ ዔያቶም ማሂ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ጋዓንቴ ናንጊና ናንጋ ጎዳ ዓንጎ ጊልፖ ዶኦጮ ጉዴያ ማዔ፥ ጊብፄ ዓጫፓ ዒንሢ ዔኪ ኬሴሢ ሃኖ ዒንሢ ማዒ ዓኣ ጎይፆ ዒዛም ዱማዼ ዓሲ ማዓንዳጉዲ ኮዒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","ዒንሢ ማዼ ባኮ ዛሎና ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ታጊዳ ዻጋዺ ታኣኒ ዮርዳኖሴ ዎሮና ፒንቂ ዴንዲንዱዋኣሢ፤ ሃሣ ዒዚ ዒንሢም ዒንጋንዳ ዬኖ ማሎ ዓጬሎ ታ ጌሊንዱዋኣሢ ታኣም ጫኣቂ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ዬያሮ ታኣኒ ዮርዳኖሴ ዎሮና ፒንቁዋዖ ሃኖ ዓጮይዳ ሃይቃንዳኔ፤ ዒንሢ ጋዓንቴ ፒንቂ ዬኖ ማሎ ዓጬሎ ዻካላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ዬያሮ ናንጊና ናንጋ ጎዳ ዒንሢና ዎላ ጫኣቄ ጫኣቁሞ ዒንሢ ዋሉዋጉዲ ዒንሢና ዔሩዋቴ፤ ዓይጎ ባኣዚያ ማዖም ካኣሽኮ ባኣዚ ማሂ ካኣሽኪፖቴ፤ ዒዚ ዒንሢም ዓይሤ ባኮ ማዺ ኩንሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ዓይጎሮ ጌዔቴ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ሚቻ ታሚኬ፤ ሃሣ ሜሌ ፆኦሲ ጌይንታይ ካኣሽኪንታዳጉዲ ኮዑዋኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","«ናይ ሾይ ሃሣ ናኣቶኮ ናኣቶ ሄላንዳኣና ዓጬሎይዳ ኮሺና ዒንሢ ናንጋኣና ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦሲ ዒሣያ ማዔ ኩቻ ማዢንቴ ባኣዚ ዓይጎዋ ማዖም ሜሌ ፆኦሲ ማሂ ማዢ ዒዛ ዒንሢ ዻጋሱዋጉዲ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ታ ጋዓ ባኮ ዋይዞ ዒንሢ ዒፄቶ ዮርዳኖሴ ዎሮና ፒንቂ ዒንሢ ዻካላንዳ ዓጬሎይዳፓ ኔጉዋዖ ጋፒ ዒንሢ ባይቃንዳሢ ታ ዒንሢ ዔርዛኒ ሃኖ ዒንሢ ዑፃ ጫሪንጮና ሳዖና ማርካ ማሂ ሃያ ታ ኬኤዛኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","ናንጊና ናንጋ ጎዳ ዒንሢ ሜሌ ዴሮ ባኣካ ዜርቃንዳኔ፤ ዬያ ዒንሢ ዒ ዜሬ ቤዞይዳ ዻካ ዓሲ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ዬኖ ቤዞይዳ ዛጋኒ፥ ዋይዛኒ፥ ሙዓኒ፥ ሲንቂ ዱማሲ ዔራኒ ዳንዳዑዋያ ሚሢና ሹቺናይዳፓ ዓሲ ፔ ኩቻ ማዤ ሜሌ ፆኦዞ ዒንሢ ካኣሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ጋዓንቴ ዒኢካ ዒንሢ ናንጋ ዎዶና ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ዒንሢ ጶቂሢ ኮዓንዳኔ፤ ዒዛ ዒንሢ ጉቤ ዒናፓ ኮዔቴ ዴንቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ሃጊ ዬይ ባካ ቢያ ዒንሢ ሄሌም ሜቶይዳ ዒንሢ ጌሌ ዎዶና ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ባንሢ ማዒ ዒዛም ዒንሢ ዓይሢንታያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ዒዚ ዓቶም ጋዓ ፆኦሲታሢሮ ዒንሢ ዒ ሃሻዓኬ፤ ፔቶዋ ዒንሢ ጋፒ ባይቃንዳጉዲ ዒ ማሃዓኬ፤ ዒንሢኮ ቤርታኣ ዓዶንሢና ዎላ ዒ ጫኣቄ ጫኣቁሞ ፔቴታዖ ዋላያቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","«ፆኦሲ ሳዖይዳ ዓሲ ማዤማፓ ዓርቃዖ ጫሪንጮኮ ካራፓ ጋፖ ሄላንዳኣና ሂንዳ ዬያጉዴ ዼኤፒ ባኣዚ ማዺንቴያታቴ፤ ሃሣ ዬያጉዴ ባኣዚ ዋይዜ ዓሲ ዓኣቴ ዒንሢኮ ቤርታ ዓኣዼ ዎዶ ዛላ ዖኦጩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ዒንሢ ዋይዜ ጎይፆ ፆኦሲ ዔኤታ ታሞ ሎስታሢ ባኣካ ማዒ ኬኤዜም ሼምፔና ናንጋኒ ዳንዳዔ ዴሬ ዎካ ዓኣይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ዒንሢ ዛጌ ጎይፆ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ጊብፄ ዓጮይዳ ማዼ ጎይፆ ዒ ናሽኬ ዓሶ ዛላ ዔቂ ሜሌ ዓሶይዳ ሜቶ ዔኪ ዬዒ፥ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚና ዱማ ዱማ ማላታ ዻዊ፥ ዔያቶ ዛሎ ዖልቲ፥ ፔኤኮ ዎልቆና ዶዱሞና ዻዊ ፔቴ ዴሬ ባኣካፓ ፔኤም ማዔ ዴሬ ዱማሲ ዔካኒ ዳንዳዔ ሜሌ ፆኦሲ ዎካ ዓኣይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","ናንጊና ናንጋ ጎዳ ማዔ ፆኦሲ ዒዛ ሌሊ ማዔሢና ዒዛይዳፓ ዓቴም ሜሌ ፆኦሲ ባኣያ ማዔሢ ዔርዛኒ ዒዚ ዬያ ቢያ ዒንሢም ዻዌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","ዒንሢ ዒ ዔርዛኒ ኮዔሢሮ ጫሪንጫፓ ዑኡዞ ፔኤሲ ዋይዚሴኔ፤ ሳዖይዳ ዒዛም ዱማዼ ታሞ ዒንሢ ዒ ዻዌኔ፤ ዬያ ታሞ ባኣኮይዳ ማዒያ ዒንሢና ዒ ጌስቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","ዒንሢኮ ቤርታኣ ዓዶንሢ ዒ ናሽኪ ዒንሢ ዔያቶኮ ናኣቶ ዒ ዶኦሬሢሮ ፔኤኮ ዼኤፖ ዎልቆና ፔኤሮ ጊብፄፓ ዒንሢ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ዒንሢም ዒ ዒንጋ ዓጬሎኮ ዒንሢ ዑካዛ ዒንሢዳፓ ባሼ ዎልቄና ማዔ ዴሮ ቤርታፓ ዒንሢኮ ዳኪ ባይዜኔ፤ ዬያ ዒ ማዼሢ ዒንሢ ዛጋሢጉዲ ዒንሢ ዒ ዔኪ ሙኪ ዔያቶሮ ማዔ፥ ዔያቶ ዓጮ ዻካልሳኒ ኮዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","ዬያሮ ሌካ ጫሪንጮይዳ፤ ሊካ ሳዖይዳ ናንጊና ናንጋ ጎዳ ዒዚ ሌሊ ፆኦሲ ማዔሢ፥ ሃሣ ዒዛይዳፓ ሜሌ ፆኦሲ ባኣሢያ ዔሩዋቴ፤ ዒኖይዳኣ ዒንሢኮ ኮሺ ዓርቁዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ሃኖ ታ ዒንሢም ኬኤዛ ሃያ ዓይሢፆ ማዺ ዒንሢ ኩንሤቴ ዒንሢና ዒንሢኮ ናኣቶናም ኮሺ ማዓንዳኔ፤ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ዒኢካ ዒንሢ ናኣናና ናንጋንዳጉዲ ዻካልሳ ዓጮይዳ ዖዶሲ ሌዔ ዒንሢ ናንጋንዳኔ» ");
INSERT INTO mdyeth_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ዬካፓ ሙሴ ዮርዳኖሴ ዎሮኮ ሶ ሱካ፥ ዓባ ኬስካ ባንፆይዳ ሃይሦ ካታማ ዱማሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ዬያ ዒ ማዼሢ ቤርታ ሞርኬ ማዒባኣያታንቴ ዻቢንቲና ዓሲ ዎዼ ዓሲ ፔ ሼምፓሢ ዓውሳኒ ዒዞ ካታሞ ጌሊ ዓታንዳጉዲ ጌይኬ፤ ዬይ ዓሢ ቶሊ ዬንሢ ካታሞ ጌሌቴ ዓሲ ዒዛ ዎዻኒ ዳንዳዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ዬያሮ ሮኦቤኤሌ ማኣሮ ዓሶም ዓሲ ናንጉዋ ዳውሎይዳ ዼጌ ቤዛ ዓኣ ቤፄሬ ካታሞ፤ ጋኣዴ ማኣሮ ዓሶም ጌሌዓዴ ዓጮ ጋራ ዓኣ ራሞቴ ካታሞ፤ ሚናኣሴ ማኣሮ ዓሶም ባኣሳኣኔ ዓጮ ጋራ ዓኣ ጎላኔ ካታሞ ዱማሲ ዒዚ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ሙሴ ዒስራዔኤሌ ዓሶም ኬኤዜ ፆኦሲ ዎጋ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ዒስራዔኤሌ ዴራ ጊብፄ ዓጫፓ ኬስካዛ ሙሴ ዔያቶም ዓይሤ ዳምቦና ዎጎና ኬዴና ኬኤዚንቴ ባኮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ዬያ ዒ ኬኤዜሢ ዮርዳኖሴ ዎሮኮ ሱካ ፔትልፔዖሬ ዶኦጮኮ ቤርቶ ዛላ ዓሞራ ዓጮ ካኣቲ ሃሴቦኦኔ ካኣታዺ ዎይሣያ፤ ሃሣ ሙሴና ዒስራዔኤሌ ዴሮና ጊብፄፓ ኬስካዖ ዖሊ ባሼ፥ ሲሆኔ ዓጮይዳ ዓኣዖኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ዒማና ዔያታ ዒዛኮ ዓጮና ዬያጉዲ ሃሣ ዮርዳኖሴፓ ዓባ ኬስካ ዛሎይዳ ዓኣ ባኣሳኣኔ ዓጮ ዎይሣ፥ ዖጌ ዓጮዋ ዔኬኔ፤ ዬና ላምዖ ካኣታ ዓሞራ ዓሶ ዎይሣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ዬይ ዓጫ ዓሮዔኤሬ ካታማፓ ዓርቃዖ ዓርኖኦኔ ዎሮኮ ዓጮማ ዓርቂ ኬዶ ዛሊና ዴንዲ ሲሪዮኔ ዹኮ ሄላኔ፤ ዬይ ሲሪዮኔ ዹኮ ጌይንታሢ ሄርሞኔ ዹኮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ዬይ ዓጫ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛሎና ዓኣ ዓራባ ዓጮ ዔካዖ ዾኦሎ ዛሊና ዴንዲ ሶኦጌ ባዚ ሄላኔ፤ ዬያጉዲ ሃሣ ዓባ ኬስካ ዛሎና ፒሲጋ ዹኮ ዴሞ ሄላንዳኣና ዓኣዻያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ሙሴ ዒስራዔኤሌ ዴሮ ቢያ ዔኤላዖ፦ «ዒስራዔኤሌ ዓሲዮቴ! ታኣኒ ሃኖ ዒንሢም ኬኤዛ ዎጎና ዳምቦና ዋይዚ፥ ኮሺ ዛጊ ዔሪ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ሲና ዹኮ ኮይላ ኑኡና ዎላ ጫኣቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ዒዚ ጫኣቄሢ ኑ ዓዶንሢና ሌሊቱዋንቴ ሃሢ ሼምፔና ዓኣ ኑና ጉቤሢናኣ ዎላኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ዬኖ ዹኮይዳ ዔኤቴ ታሞ ባኣካ ማዒ ዒንሢኮ ቤርታ ዔቂ ዒንሢና ዒ ጌስቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ታኣኒ ዒማና ዒ ጋዓ ባኮ ቢያ ዒንሢም ኬኤዛኒ ዒንሢና ዒዛናኮ ባኣካ ዔቄኔ፤ ዓይጎሮ ጌዔቴ ዒንሢ ታሞ ዒጊጪ ዹኮ ኬስካኒ ኮዒባኣሢሮኬ፤» «ዒማና ዒዚ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","ዓይሌ ማዒ ሻንቂንቲ ናንጌ ጊብፄ ዓጫፓ ኔና ኬሴሢ ታና፥ ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢኬ፤» ");
INSERT INTO mdyeth_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","«ታ ጊዳፓዓቴም ሜሌ ፆኦዞ ካኣሽኪፖ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","«ጫሪንጫኣ ማዖም ሳዓ፤ ሳዖኮዋ ዴማ ዋኣፆ ሳዛ ናንጋ ባኣዚያ ማሊሲ ኮሺ ዔኪ ካኣሽኪፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ታና ሃሺ ሜሌ ፆኦዞ ካኣሽካ ዓሶ ዓዶንሢ ጎሞ ናኣቶይዳ ማሂ ዴንዲ ሃይሦ ሾይንቲ ሄላንዳኣና ኮሜ ኮፃያኬ፤ ሃሣ ታጊዳፓ ሜሌ ፆኦሲ ካኣሽኪንታንዳጉዲ ታኣኒ ኮዑዋ ፆኦሲ ማዔሢሮ ዬያ ዓሲ ኩቻ ማዢንቴ ባኮም ዚጊፖ፤ ሃሣ ካኣሽኪፖ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ታና ናሽካዞንሢና ታ ዓይሢፆ ካፓዞንሢም ጋዓንቴ ዴንዲ ሺያ ሾይንቲ ሄላንዳኣና ታኣኮ ናንጊና ናንጋ ሚጪንቶ ታኣኒ ፔጋሲ ዻዋያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","«ታና፥ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢኮ ሱንፆ ማዒባኣ ባኣዚና ዔኤሊፖ፤ ታ ሱንፆ ማዒባኣ ባኣዚና ዔኤላ ዓሲዳ ሜቶ ሄሊሱዋዖ ታ ሃሹዋያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","«ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ኔና ዓይሤ ጎይፆና ሃውሾ ኬሎ ታኣም ዱማዼያ ማሂ ቦንቼ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ማዾ ቢያ ኔ ማዻንዳ ላሆ ኬሊ ኔኤም ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ላንካሳ ኬላ ጋዓንቴ ታና፥ ፆኦሲ፥ ኔ ጎዳሢም ዱማዼ ሃውሾ ኬሊኬ፤ ዬኖ ኬሎና ዓይጎ ማዾዋ ማዺፖ፤ ኔናታቴያ ኔኤኮ ናኣታ፥ ኔኤም ማዻ ዓሶ ማዔቴያ ቆልማ፤ ሃሣ ኔኤና ዎላ ናንጋያ ሜሌ ዓጪፓ ሙኬ ዓሲ ማዔቴያ ዓይጎ ማዾዋ ማዖም ማዺፖቴ፤ ኔኤም ማዻዞንሢ ኔ ሃውሼ ጎይፆ ሃውሾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ጊብፄ ዓጮይዳ ካራሚ ማዒ ኔ ናንጌሢንታ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢ ፔኤኮ ዼኤፖ ዎልቆና ፔ ቢታንቶና ዬካፓ ኔና ኬሴሢ ጶቂሤ፤ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢ ሃውሾ ኬሎ ኔ ቦንቻንዳጉዲ ዓይሤሢ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","«ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢ ዓይሤ ጎይፆና ኔ ዓዶንታ ኔ ዒንዶንታ ቦንቼ፤ ዬያ ኔኤኒ ማዼቴ ቢያ ባኣዚ ኔኤም ጊኢጋንዳኔ፤ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ኔ ፆኦዛሢ ኔኤም ዒንጋ ዓጬሎይዳ ሚርጌ ሌዔ ኔ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","«ዓሲ ዎዺፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","«ማቾ ሃሣ ዓኒ ማዒባኣ ዓሲና ላሂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","«ዉኡቂፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","«ዓይጎ ዓሲ ዑስካኣ ማዖም ሉኡቂ ማርካዺፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","« ‹ሜሌ ዓሲኮ ማቻ፥ ማኣራ፥ ጎዣ፥ ማዻ ዓሳ፥ ባኣቶንታ ሃሮንታ፤ ዓሢኮ ዓኣ ባኣዚ ቢያ ዛጊ ኔኤሮ ማዓኣቢሽ ጌይ ማሊፖ›» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","«ዹኮ ኮይላ ዒንሢ ቡኬ ዎዶና ናንጊና ናንጋ ጎዳ ዒንሢ ቢያሢም ዹኮይዳ ዔቂ ኬኤዜ ዓይሢፃ ዬያኬ፤ ዒዚ ዒማና ዔኤታ ታሞና ሻኣሮና ሻኔ ዹሞናይዳ ማዒ ዼኤፒ ዑኡሲና ኬኤዛዖ ዒንሢ ዓይሤ ዓይሢፃ ዬንሢ ሌሊኬ፤ ዬንሢ ዒዚ ላምዖ ዓርሲንቴ ሹቺዳ ፃኣፒ ታኣም ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ሙሴ ኬኤዛዖ፦ «ዹኮይዳ ታማ ዔኤታሢና ዹሞይዳ ዑኡዛ ዒንሢም ዋይዚንቴ ዎዶና ፔቴ ፔቴ ፃጶ ማኣሮኮ ሱኡጎና ዓጮ ጪሞና ቢያ ታ ኮይላ ሙኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","‹ዒዚ ታሞ ባኣካ ማዒ ጌስታሢ ኑ ዋይዜ ዎዶና ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢኮ ዼኤፑሞና ዒ ቦንቺንቴያ ማዔሢ ኑና ዒ ዻዌኔ፤ ፆኦሲ ዓሲና ጌስቴም ዓሲ ሼምፔና ዓቲ ናንጋያታሢ ሃኖ ኑ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ዬይ ዼኤፖ ታማ ኑና ሙይ ባይዛንዳኔ፤ ኑ ዓይጎሮ ሃይቃኒ ኮዓይ? ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ላሚ ኑኡና ጌስቴቴ ኑ ሃይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ናንጊና ናንጋ ፆኦዛሢ ታሚ ባኣካ ማዒ ኬኤዜም ሼምፔና ዓቲ ናንጋይ ዓሲ ዜርሢዳ ፔቴታዖ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ዬያሮ ሙሴ! ኔኤኒ ዒዛ ባንሢ ዑኪ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ጋዓ ባኮ ቢያ ዋይዜ፤ ዬካፓ ሙኪ ዒዚ ጌዔ ባኮ ቢያ ኑኡም ኬኤዜ፤ ኑኡኒ ዬያ ዋይዚ ዓይሢንታያ ማዓንዳኔ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","«ዒንሢ ዬያ ጋዓሢ ናንጊና ናንጋ ጎዳ ዋይዛዖ፦ ‹ሃይ ዴራ ቢያ ኔኤም ኬኤዛ ባኮ ቢያ ታ ዋይዜኔ፤ ዔያታ ጌዔ ባካ ፒዜኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ቢያ ዎዴ ዬያይዲ ዔያታ ማላያታቴ ዎዚ ኮሺታዖ ዓቴይ! ቢያ ዎዴ ታና ዔያታ ቦንቺ ታ ዓይሣ ዓይሢፆዋ ኩንሣቶ ቢያ ባኣዚ ዔያቶና ዔያቶኮ ዜርፆናም ናንጊጊና ኮሺ ማዓንዳያታንቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","ሃሢ ኔኤኒ ዴንዲ ዔያታ ፔኤኮ ዓፒሎና ማዢንቴ ማኣሮ ጌላንዳጉዲ ኬኤዜ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ታኣኒ ኔኤም ታኣኮ ዎጎና ዓይሢፆና ዳምቦና ቢያ ኬኤዛንዳሢሮ ኔኤኒ ጊንሣ ማዒ ታ ኮይላ ሙኬ፤ ታኣኒ ዔያቶም ዒንጋ ዓጮይዳ ዬንሢ ዎጎንሢንታ ዓይሢፆንታ ዳምቦንታ ካፒ ዔያታ ናንጋንዳጉዲ ዴሮ ኔኤኒ ዔርዜ› ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","«ዬያሮ ዒስራዔኤሌ ዴሬዮቴ! ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዓይሣ ባኮ ቢያ ኩንሣኒ ጊኢጌያ ማዑዋቴ፤ ዎጎይዳፓ ፔቴ ባኣዚታዖ ማዺ ኩንሡዋዖ ፓጪሲፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ቢያ ባኣዚ ዒንሢም ጊኢጋንዳጉዲ፥ ዒንሢ ዻካላ ዓጬሎይዳኣ ሚርጌ ሌዔ ናንጋኒ ናንጊና ናንጋ ጎዳ ዒንሢ ዓይሤ ባኮ ቢያ ማዺ ኩንሡዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","ሙሴ ሃሣ ኬኤዛዖ፦ «ዮርዳኖሴ ዎሮና ፒንቂ ዒንሢ ዻካላንዳ ዓጬሎ ጌላዖ ዒንሢ ካፓንዳጉዲ ታ ዒንሢ ዔርዞም ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ታኣም ኬኤዜ ዓይሢፆና ዎጎና ዳምቦና ሃንሢኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ዬኖ ዓጬሎይዳ ሚርጌ ሌዔ ናንጋኒ ዒንሢንታ ዒንሢ ናኣቶንታ ናኣቶኮ ናኣቶንታ ዒንሢ ናንጋ ዎዶና ቢያ ፆኦሲ ቦንቺ፤ ሃሣ ታ ዒንሢም ዓይሤ ዳምቦና ዎጎና ማዺ ኩንሣንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ዒስራዔኤሌ ዓሲዮቴ! ሃንሢ ዎጎንሢ ዋይዙዋቴ! ሃሣ ዓይሢንቲ ማዺ ኩንሣያ ማዑዋቴ! ያኣዼ ዒንሢ ማዼቴ ዒንሢኮ ቤርታኣ ዓዶንሢም ናንጊና ናንጋ ጎዳ ዒንጌ ሃጊ ማዓንዳ ዎዞ ጎይፆና ዔኤዞና ዲኢቆና ኩሜ ዓጬሎይዳ ቢያ ባኣዚ ዒንሢም ጊኢጋንዳኔ፤ ሃሣ ዒንሢ ሾይንቲያ ሚርጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","«ዒስራዔኤሌ ዓሲዮ ዋይዙዋቴ! ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ፔቴ ጎዳኬ፤ ዒዛፓዓቴም ሜሌ ጎዳቲ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ጉቤ ዒናፓ፥ ጉቤ ሼምፓፓ፥ ጉቤ ዎልቃፓ ናሽኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ሃኖ ታ ኔኤም ዓይሢ ኬኤዛ ሃንሢ ዓይሢፆ ዋሊፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ዬንሢ ዓይሢፆንሢ ኔኤኮ ናኣቶ ላሚ ላሚ ዔርዜ፤ ማኣራ ኔ ዴዓኣና፥ ጎይሢ ኔ ዴንዳኣና፥ ጎይሢዳ ኔ ሃውሻ ቤዞይዳ ማዔቶዋ ማዾ ኔ ማዻኣና ቢያ ዬንሢ ዓይሢፆንሢ ቢያ ኬሊ ማሌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ኔኤም ጶቂሣ ማላታ ማዓንዳጉዲ ኩጫ ኔኤኮ ቱኬ፤ ባሊቶይዳኣ ማላታ ማሂ ዓይሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ኔኤኮ ማኣሮ ካሮ ቦኦኮላሢና ማርሾ ካሮናይዳ ፃኣፔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","«ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ኔኤኮ ቤርታኣ ዓዶንሢም ጌይፃ ዓብራሃሜና ዪሳኣቄና ያይቆኦቤናም ዒንጌ ሃጊ ማዓንዳ ዎዞ ጎይፆና ኔኤኒ ማዢባኣ ዼኤፒ ዼኤፒ፤ ሃሣ ሚዛጲ ሚዛጲ ካታማ ኔኤም ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ኔኤኒ ዻካላንዳ ማኣሮይዳ ኔኤኒ ጌሢባኣ ኮሺ ባኣዚ ኩሜያ፥ ኔኤኒ ቦኦኪባኣ ዋኣሢ ዔቴ ዓኣያ፤ ዬያጉዲ ሃሣ ኔ ቱኪባኣ ዎይኔ ሚሢንታ ዛይቶ ሪሚቶንታ ዒኢካ ዓኣያ ማዓንዳኔ፤ ፆኦሲ ኔና ዬኖ ዓጬሎ ጌልዜም ሙይ ኔኤኒ ሚሽኬ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ጊብፄ ዓጮይዳ ካራሚ ማዒ ናንጋንቴ ኔና ኬሴ ናንጊና ናንጋ ጎዳሢ ኔኤኒ ዋሉዋጉዲ ኮሺ ዔሬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ዒጊጪ ቦንቼ፤ ዒዛ ሌሊ ካኣሽኬ፤ ሃሣ ዒዛ ሱንፆና ሌሊ ጫኣቄ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ኔኤኮ ኮይላ ዓኣ፥ ሜሌ ዓሳ ካኣሽካ ፆኦዞ ካኣሽኪፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ሜሌ ፆኦዞ ኔኤኒ ካኣሽኬቴ ዒንሢ ባኣካ ዓኣ፥ ናንጊና ናንጋ ጎዳካ ዻጎ ኔኤኒ ዔቂሳንዳኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ዒዛይዳፓዓቴም ሜሌ ፆኦሲ ጌይንታይ ካኣሽኪንታንዳጉዲ ኮዑዋያታሢሮ ሳዖይዳፓ ዒንሢ ፒፂ ዒ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","«ማሳሄ ጌይንታ ቤዜሎይዳ ዒንሢ ማዼ ጎይፆ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዎይታያታቴያ ኑ ዛጎም ጌይ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ዒዚ ዒንሢ ዓይሤ ዓይሢፆና ዎጎና ዳምቦና ቢያ ሂርጊ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ናንጊና ናንጋ ጎዳ ቤርታ ፒዜ፥ ሃሣ ኮሺ ማዔ ባኣዚ ቢያ ማዼ፤ ዬያ ኔ ማዼቴ ቢያ ባኣዚ ኔኤም ጊኢጋንዳኔ፤ ናንጊና ናንጋ ጎዳ ኔኤኮ ቤርታኣ ዓዶንሢም ዒንጋኒ ጫኣቄ ጎይፆና ኮዦ ዓጬሎ ኔ ዻካላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ዒዚ ኔኤም ዒንጌ ሃጊ ማዓንዳ ዎዞ ጎይፆና ኔኤኮ ሞርኮ ዒ ኔ ቤርታፓ ዳውሲ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","«ሃጋ ኔኤኮ ናኣታ ‹ናንጊና ናንጋ ጎዳ ሃያ ዎጎንታ ዳምቦንታ ዓይሢፆንታ ዓይሤሢ ዎዚ ጌይሢናዳይ?› ጌይ ዖኦጬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ሂዚ ጌይ ዔያቶም ኬኤዜ፦ ‹ሚና ኑኡኒ ጊብፄ ዓጮ ካኣቲኮ ዓይሌኬ፤ ናንጊና ናንጋ ጎዳ ጋዓንቴ ፔኤኮ ዼኤፖ ዎልቆና ዬካፓ ኑና ኬሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ዒዚ ዒማና ጊብፄ ዓሶንታ ካኣቲንታ ዼኤፖ ዼኤፖ ዓሶዋ ሜታሴያ ዒዛ ዎልቄና ማዺንታ ዓኪ ባኣዚ ማዼሢ ኑ ዓኣፒና ኑ ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ዒዚ ዻካልሳኒ ኑኡኮ ቤርታኣ ዓዶንሢም ጫኣቄ ጎይፆና ሃኖ ዓጬሎ ኑና ዔኪ ሙኪ ኑም ዒንጋኒ ጊብፄ ዓጮ ዓይሉማፓ ኑና ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ሃንሢ ዳምቦንሢ ማዺ ኑ ኩንሣንዳጉዲ፤ ሃሣ ዒዛኣ ኑ ዒጊጪ ቦንቻንዳጉዲ ኑና ዓይሤኔ። ኑኡኒ ዬያይዲ ማዼቴ ዒዚ ቢያ ዎዴ ቢያ ባኣዚ ኑም ጊኢጋንዳጉዲ ማሃንዳኔ፤ ሃሢያ ዒ ማዻ ጎይፆ ሼምፔና ኑና ናንጊሳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ዓይሤ ጎይፆ ዒዛኮ ዓይሢፆ ካፒ ኑ ማዺ ኩንሤያታቴ ዒዛ ኑ ዎዛሳያ ማዓንዳኔ› » ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","ሙሴ ሃሣ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዻካላኒ ዴንዳ ዓጬሎ ዒንሢ ጌልዛንዳኔ፤ ዬኖ ዓጮ ጌላኒ ዒንሢ ዑካኣና ዒንሢኮ ቤርታፓ ዒንሢዳፓ ባሼ ዎልቄና ዓኣ ዱማ ዱማ ላንካይ ቶኦኪ ዴሬ ዳውሲ ዒ ኬሳንዳኔ፤ ዬያታ፦ ሄቴ ዓሶ፥ ጌርጌሳ ዓሶ፥ ዓሞራ ዓሶ፥ ካናኔ ዓሶ፥ ፔርዜ ዓሶ፥ ሂዋዌ ዓሶንታ ዒያቡሳ ዓሶ ጌይንታዞንሢኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲ ዬያ ዴሮ ቢያ ዒንሢ ኩጫ ዒንጌም ዒንሢ ዖሊ ዔያቶ ባሼ ዎዶና ቢያሢ ዎዺ ባባይዛንዳያ ኮይሳኔ፤ ዔያቶና ዎላ ዓይጎ ጫኣቁሞዋ ማዖም ጫኣቂፖቴ፤ ሃሣ ዔያቶም ሚጪንቲፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ዒንሢኮ ዓቲንቆ ናኣታ ዔያቶ ናኣቶ ዔካንዳጉዲ፥ ሃሣ ዒንሢኮ ዉዱሮ ናኣታ ዔያቶኮ ዓቲንቆ ናኣቶም ሌዑዋጉዲ ላኣጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ዒንሢ ዬያ ማዺባኣቴ ዒንሢኮ ናኣቶ ፆኦሲዳፓ ዒንሢ ዱማሲ ሜሌ ፆኦሲ ካኣሽካንዳጉዲ ማሃንዳኣኬ፤ ያዺ ዒንሢ ማዔቴ ናንጊና ናንጋ ጎዳ ዒንሢ ዑፃ ዻጋዺ ኔጉዋዖ ዒንሢ ባይዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ዬያሮ ዒንሢ ዔያቶ ሂዱዋቴ፦ ዔያታ ፔ ፆኦዞም ሚቺ ዒንጊ ካኣሽካ ቤዞ ዶይሱዋቴ፤ ሹጮታንቴ ዓርሲ ኮሾና ካኣሽኮ ፆኦዞ ዔያቶኮ ሜንሢ ኬኤሩዋቴ፤ ዓሼራ ጌይንታያ ላኣሎ ማላቶና ማዦና ፆኦዜሎ ዔያቶኮ ሜንሡዋቴ፤ ዔያታ ካኣሽካ ባኮ ታሚና ሚቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ፔ ዓሲ ማሂ ዒንሢ ዶኦሬያ ዒዛም ዒንሢ ዱማዼ ዴሬኬ፤ ሳዖይዳ ዓኣ ዓሶ ባኣኮይዳፓ ቢያ ዒዛም ዒንሢ ዱማዼያ ማዓንዳጉዲ ዒዚ ዒንሢ ዶኦሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","«ናንጊና ናንጋ ጎዳ ሃንጎ ዴሮይዳፓ ዱማሲ ዒንሢ ናሽኬሢና ዶኦሬሢ ዔያቶይዳፓ ዑሣ ዓኣዼ ዒንሢ ዺቤምቱዋሴ፤ ሳዖይዳ ዓኣ ዓሶይዳፓ ዒንሢ ላኣፓ ዴሬኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ጋዓንቴ ናንጊና ናንጋ ጎዳ ዒንሢ ናሽኬሢሮ ዒንሢኮ ቤርታኣ ዓዶንሢም ማዻኒ ጫኣቄ ጫኣቁሞ ማዺ ኩንሣኒ ኮዔኔ፤ ዒዚ ፔኤኮ ዼኤፖ ዎልቆና ዒንሢ ዓውሲ ጊብፄ ዓጮ ካኣቲኮ ዓይሉማፓ ኬሴሢ ዬያሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጎኔና ጉሙርቂንታ ፆኦሲ ማዔሢ ዬያና ዔሩዋቴ፤ ዒዚ ጫኣቄ ጫኣቁሞ ካፓያ፥ ዒዛ ናሽካዞንሢና ዒዛኮ ዓይሢፆ ማዺ ኩንሣዞንሢም ቢያ ዴንዲ ሺያ ሾይንቲ ሄላንዳኣና ፔኤኮ ናንጊና ናንጋ ሚጪንቲፆ ፔጋሲ ዒ ዻዋያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ጋዓንቴ ዒዛ ዒፃ ዓሶ ኮሜ ኮፂ ባባይዛኔ፤ ዔያቶ ኮሜ ኮፂፓ ጊንሢም ጎዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ዬያሮ ሃኖ ታ ዒንሢም ዓይሣ ዓይሢፆንታ ዎጎንታ ዳምቦንታ ዛጊ ማዺ ኩንሡዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","«ሃንሢ ዓይሢፆንሢ ዋይዚ ጉሙርቂንቲ ማዺ ዒንሢ ኩንሤቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢኮ ቤርታኣ ዓዶንሢም ማዻኒ ጫኣቄ ጫኣቁሞንታ ናንጊና ናንጋ ሚጪንቲፆንታ ዒንሢም ማዺ ኩንሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ዒዚ ዒንሢ ናሽካንዳኔ፤ ሃሣ ዓንጃንዳኔ፤ ዬያሮ ፓይዳ ዒንሢኮ ሚርጋንዳኔ፤ ዒንሢ ሾዓ ናኣታ፥ ዒንሢ ጎሽካ ጎዣኣ ዓንጂንታንዳኔ፤ ሚርጌ ሃኣኮንታ ዎይኖ ዓኣፖንታ ሪሚቶ ሚፆ ዛይቶዋ ዺቢ ዒንሢ ዴንቃንዳኔ፤ ሃሣ ዒንሢኮ ባኣቶንታ ማራቶንታ ሾይንቲ ሚርጋንዳኔ፤ ዒንሢም ዒንጋኒ ዒንሢኮ ቤርታኣ ዓዶንሢም ዒዚ ጫኣቄ ዓጬሎይዳ ዬያ ቢያ ዓንጆ ዒንሢም ዒ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ዒንሢጉዴ ዓንጂንቴ ዴሬ ሳዖይዳ ባኣያ ማዓንዳኔ፤ ዒንሢ ባኣኮይዳ ዓቲንቄ ማዔቴያ ላኣሊ፤ ሃሣ ዒንሢ ቆልሞ ባኣኮይዳኣ ማዖም ሾዑዋያ ባኣያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","ናንጊና ናንጋ ጎዳ ዶርዖ ቢያይዳፓ ዒንሢ ካፓንዳኔ፤ ሚና ጊብፄ ዓጮይዳ ዒንሢ ዓኣዖ ዛጌ ፑርቶ ዶርዓሢ ቢያይዳፓ ዓይጎ ዶርዓኣ ዒንሢ ሄላዓኬ፤ ጋዓንቴ ዬያ ጉዴ ዶርዓሢ ዒንሢኮ ሞርኮ ማዓ ዓሶም ዒ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","ናንጊና ናንጋ ጎዳ ዒንሢኮ ኩጫ ዓኣሢ ዒንጌ ዴሮ ቢያ ፔቴታዖ ሚጪንቱዋ ዎዺ ባይዙዋቴ፤ ዔያታ ካኣሽካ ፆኦዞ ካኣሽካኒ ኮዒ ሜቶይዳ ጌሊፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","« ‹ሃይ ዴራ ኑጊዳፓ ባሼኬ፤ ዎዲ ኑ ዔያቶ ዳውሲ ባይዛንዳይ› ጌዒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ፔቴታዖ ዔያቶ ዒጊጪፖቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጊብፄ ዓጮ ካኣቲና ዴሮናይዳ ቢያ ማዼ ባኮ ማሊ ጶቂሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ዒንሢ ዓኣፒና ዒንሢ ዛጌ ዼኤፖ ዼኤፖ ሜታሢንታ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ማዾንታ ዲቃሣ ባኮንታ፤ ዬያጉዲ ሃሣ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጊብፄ ዓጫፓ ኬሴ ዒዛኮ ዼኤፖ ዎልቆና ቢታንቶና ማሊ ጶቂሡዋቴ፤ ዬያይዲ ጊብፄ ዓሶ ዒ ባይዜ ጎይፆ ሃኖ ዒንሢ ዒጊጫ ሃያ ዴሮዋ ቢያ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዔያቶ ባኣኮ ዼኤፒ ዒጊቹሞ ጌልዛንዳኔ፤ ዒንሢዳፓ ዓኣሺንቲ ቶሌ ዓሳኣ ዓቱዋዖ ሃይቂ ባይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ዬያሮ ዬያ ዴሮ ዒጊጪፖቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢና ዎላኬ፤ ዒዚ ዼኤፒ፥ ሃሣ ዒጊጫኒያ ኮይሳ ፆኦሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬኖ ዴሮ ዒንሢኮ ቤርታፓ ዻካ ዻካ ባይዚ ባይዚ ሺኢሻንዳኔ፤ ዔያቶ ዒንሢ ፔቴና ባይዛንዳጉዲ ዒ ኮዑዋሴ፤ ዒንሢ ዬያይዴቴ ዓጬሎይዳ ቦዖ ሚርጊ ዒንሢ ሜታሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ናንጊና ናንጋ ጎዳ ዒንሢኮ ሞርኮ ዒንሢ ኩጫ ዓኣሢ ዒንጋንዳኔ፤ ዔያታ ጋፒ ባይቃንዳያ ሄላንዳኣና ካራ ዔያቶም ዒ ባይዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ዔያቶኮ ካኣቶዋ ዒንሢ ኩጫ ዒ ዒንጋንዳኔ፤ ዔያቶ ዒንሢ ዎዺ ሱንሢ ባይዛንዳኔ፤ ዒንሢ ቃዛንዳ ዓይጎ ዓሲያ ባኣሴ፤ ዬያቶ ቢያ ዒንሢ ዎዺ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","ዔያቶኮ ካኣሽኮ ፆኦዞ ታሚና ሚቹዋቴ፤ ዬያ ካኣሽኮ ባኮኮ ዑፃ ጳርቆና ቢሮ ዓንጎታቴያ ዎርቆ ዒንሢ ቆሎ ማሂ ዔካኒ ዒኔና ዒንሢ ሱኡካዹዋጉዲ፤ ዬያ ዒንሢ ማዼቴ ፒሮ ዒንሢኮ ማዓንዳኔ፤ ናንጊና ናንጋ ጎዳ ሜሌ ፆኦሲ ጌይ ካኣሽኮ ባኮ ዒፃያታሢሮ ዼኤፒ ሜቶ ዒንሢዳ ዔኪ ዬዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ዬንሢ ጋዳንቂንቴያ ማዔ፥ ካኣሽኮ ባኮንሢ ዔኪ ዒንሢኮ ማኣሪ ጌልዚፖቴ፤ ዔኪ ዒንሢ ጌሌያ ማዔቴ ዬያቶጉዲ ዒንሢያ ባይቃንዳኔ፤ ዔያታ ባይሲንታም ጊኢጌያታሢሮ ዒናፓ ዒንሢ ዔያቶ ዒፂ ሻኣኪንታዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","ሙሴ ሃሣ ኬኤዛዖ፦ «ሼምፔና ዒንሢ ናንጋንዳጉዲ፥ ፓይዳ ዒንሢኮ ዺባንዳጉዲ፥ ናንጊና ናንጋ ጎዳ ዒንሢኮ ቤርታኣ ዓዶንሢም ዒንጋኒ ጫኣቄ ዓጬሎ ዻካላኒ ሃኖ ታኣኒ ዒንሢም ኬኤዛ ዓይሢፆ ቢያ ጉሙርቂንቲ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዓይሤ ዓይሢፆ ዒንሢ ካፓቴያ ዒኖይዳ ዒንሢኮ ዓኣ ማሊፆ ዔራኒና ዖቶርቁዋኣያ ሼሌዔ ዒንሢ ማሃኒ ሃያ ዓሲ ናንጉዋ ዳውሎይዳ ዖይዲታሚ ሌዔ ጉቤ ዔኪ ዓኣዼሢ ማሊ ጶቂሡዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","ዒዚ ናይዚና ዒንሢ ሜታሴኔ፤ ዬያይዴስካፓ ዒንሢንታ ዒንሢኮ ቤርታኣ ዓዶንሢንታ ዔሩዋኣያ፥ ማና ጎኦ ሙዖ ዒንሢ ዒ ሙኡዜኔ፤ ዬያ ዒ ማዼሢ ዓሲ ሼምፔና ዓኣያ ማዒ ናንጋኒ ዳንዳዓሢ ናንጊና ናንጋ ጎዳ ኬኤዛ ቃኣሎና ማዓንዳፓዓቴም ካሣ ሙዒ ሌሊቱዋኣሢ ዒንሢ ዔርዛኒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ዬያ ዖይዲታሞ ሌዖይዳ ማኣዓሢ ዒንሢኮ ጪንቂ ዳርዒባኣሴ፤ ሃሣ ሚርጌ ዒንሢ ሃንቴሢሮ ቶካ ዒንሢኮ ኪፂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","ዓዴ ፔኤኮ ናዖ ጎሪ ጎሪ ዞራሢጉዲ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ጎሪ ዞራሢ ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","ዒዛ ቦንቺ ዒጊጪ፤ ሃሣ ዒዛ ጊንፆ ሃንቲ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሣ ባኮ ቢያ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","ሃይሾ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ኮሺ፥ ሃሣ ማሎ ዓጬሎ ዒንሢ ጌልዛኒ ዔኪ ሙኬኔ። ዬኖ ዓጬሎይዳ ዶኦጮና ጌሜሮናይዳፓ ዓልቂ ዴንዳ ዎርዚንታ ዴዔ ዋኣሢንታ ዓልቃ ዋኣሢ ዓኣ ዛሬንታ ዓኣያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ዒዞይዳ ዛርጎንታ ዔልዓንታ ዎይኖ ሚፆ ዓኣፖንታ ቤሌሴ ሚፆ ዓኣፖንታ ሮኦማኣኔ ጎዖ ሚፆ ዓኣፖንታ ዛይቶ ሪሚቶ ዓኣፖንታ ዔኤሲያ ኩሜያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ዬኖ ዓጬሎይዳ ባይቃንዳ ባኣዚ ባኣሢሮ ናይዚ ዒንሢ ናይዻዓኬ፤ ዒኢካ ዓኣ ሹጮይዳፓ ዓንጊ፥ ጌሜሮ ጎኦቦይዳፓኣ ሞኦና ዓንጊ ጴዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ሙይ ዒንሢ ሚሽኪ ዬኖ ማሎ ዓጬሎ ዒንሢም ዒንጌ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ጋላታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","«ሃኖ ታ ዒንሢም ኬኤዛ ዓይሢፆና ዳምቦና ዎጎና ማዺ ኩንሡዋዖ ሃሺ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዋሉዋጉዲ ዒንሢና ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ሙይ ዒንሢ ሚሽካኣና፤ ሃሣ ኮሺ ማኣሪ ማዢ ናንጋኣና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ባኣቶንታ ማራቶንታ ሃሣ ቢሮንታ ዎርቆንታ፤ ዬያጉዲ ጊንሣ ሜሌ ቆላኣ ዒንሢኮ ዺባኣና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ዒና ዒንሢኮ ዖቶርቁዋጉዲ፤ ሃሣ ዓይሌ ማዒ ዒንሢ ናንጌ ጊብፄ ዓጮይዳፓ ኬሴ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዋሉዋጉዲ ዒንሢና ኮሺ ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","ዻይ ዎዻ ሾኦዦና ኮርናሢና ኩሚ ዓኣ ዬያ ዒጊቻ፥ ዳልጎ ዓሲ ናንጉዋ ዳውሎይዴና ዒንሢ ዒ ዔኪ ዓኣዼኔ፤ ፔቴታዖ ዋኣሢባኣ፥ ዬያ ዓሲ ናንጉዋ ዳውሎይዳ ዶዶ ላላፓ ዋኣሢ ዒንሢም ዒ ኬሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ዒንሢኮ ቤርታኣ ዓዶንሢ ሙዒ ቤቂባኣ ‹ማና› ጌይንታ ሙዖ ዒንሢ ዎይታቴያ ዛጋኒና ዖቶርቁዋያ ሼሌዔ ዒንሢ ማሃኒ ዬያ ዓሲ ናንጉዋ ዳውሎይዳ ዒንሢም ዒ ዒንጌኔ፤ ዬያ ዒ ማዼሢ ጋፒንፆይዳ ኮሺ ባኣዚና ዒንሢ ዒ ዓንጃኒ ኮዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ዬያሮ ‹ታ ዖርጎጬሢ ታ ዎልቄና ሃሣ ታ ዶዱሞናኬ› ጌዒ ዒንሢ ፔቴታዖ ማሉዋጉዲ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","ዒንሢ ዖርጎጫንዳጉዲ ዎልቄና ዶዱሞና ዒንሢም ዒንጌሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢታሢ ማሊ ጶቂሡዋቴ፤ ዒዚ ዬያ ማዻሢ ሃሢ ዒ ማዻ ጎይፆ ዒንሢኮ ቤርታኣ ዓዶንሢም ጫኣቄ ጫኣቁሞ ማዺ ኩንሢሳኒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዋሊ ሜሌ ፆኦሲም ዚጊ ካኣሽካኒና ማዻኒ ዬያ ባንሢ ዒንሢ ሺሬቴ ጎኔና ዒንሢ ባይቃንዳያታሢ ሃኖ ታ ዒንሢም ላቲ ኬኤዛኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ዓይሢንቶ ዒፄቴ ዒንሢ ቤርታፓ ዒዚ ባይዛንዳ ዴሮ ባይዛሢጉዲ ዒንሢያ ዒማይዲ ባይዚ ኩርሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ሙሴ ሃሣ ኬኤዛዖ፦ «ዒስራዔኤሌ ዴሬዮቴ! ዋይዙዋቴ፤ ዒንሢዳፓ ባሼ ሃሣ ዎልቄና ዓኣ፥ ሜሌ ዴሮኮ ሳዖንታ ጫሪንቺ ኬስኬ ኬኤሎ ዲፆና ዲርቂንቴ ዼኤፖ ዼኤፖ ካታሞንታ ጌሊ ዻካላኒ ሃኖ ዒንሢ ዮርዳኖሴ ዎሮና ፒንቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ዒኢካ ናንጋ ዴራ ዼኤፒ ዼኤፒ ሃሣ ዔጳኣ ዖዶሲ ዶዲ ዓሲኬ፤ ዒንሢ ዔራሢጉዲ ዔያታ ‹ዖኦኒያ ዔያቶ ዳንዳዑዋ ዔናኣቄ ዜርፆኬ› ጌይንታሢ ዒንሢ ዋይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ጋዓንቴ ሙዓ ታሚጉዲ ማዔ፥ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ዒንሢኮ ቤርታ ኬስካንዳያታሢ ሃኖ ዒንሢ ዛጋንዳኔ፤ ዒንሢ ቤርቲም ዴንዳኣና ዒዚ ዔያቶ ባሻንዳኔ፤ ዬያሮ ዒዚ ዒንሢም ማዻኒ ጫኣቄ ጎይፆና ዔያቶ ቤዛፓ ዳውሲ ኔጉዋዖ ዒንሢ ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዔያቶ ዒንሢኮ ቤርታፓ ዳውሴስካፓ ‹ናንጊና ናንጋ ጎዳ ኑና ሃኖ ዓጮ ዔኪ ሙኬሢ ኑ ኮሺ ማዼያታሢሮኬ› ጌይ ማሊፖቴ፤ ናንጊና ናንጋ ጎዳ ዬኖ ዴሮ ቤዛፓ ዒንሢም ዳውሲ ኬሳሢ ዔያታ ፑርታ ማዔሢሮ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","ዔያቶኮ ዓጮ ዒንሢ ዻካላንዳጉዲ ናንጊና ናንጋ ጎዳ ኮዔሢ ዒንሢ ኮሺ ማዔሢሮ፥ ሃሣ ፒዜ ባኣዚ ማዼሢሮቱዋሴ፤ ዒዚ ዔያቶ ዔያቶኮ ቤዛፓ ኬሲ ዳውሲ ዳካሢ ዔያታ ፑርታ ማዔሢሮ፤ ሃሣ ዒንሢኮ ቤርታኣ ዓዶንሢ፥ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታም ማዻኒ ጫኣቄ ጫኣቁሞ ካፒ ኩንሣኒ ጌይኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","ዬያሮ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሃኖ ማሎ ዓጬሎ ዒንሢም ዒንጋሢ ዒንሢ ዒዞ ዻካላንዳያ ኮይሳያ ማዔምቱዋኣሢ ዔሩዋቴ፤ ዓይጎሮ ጌዔቴ ዒንሢ ዋይዚ ዒፃ ዓሲታሢሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓሲ ናንጉዋ ዳውሎይዳ ዎያይዲ ዒንሢ ዻጋሴቶዋ ፔቴታዖ ዋሊፖቴ፤ ጊብፄ ዓጮ ሃሺ ዒንሢ ኬስኬ ኬላፓ ዓርቃዖ ሃይካ ሄላንዳኣና ዒዛም ዒንሢ ዋይዞ ዒፃ ጎይሣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ሲና ቦኦሎይዳ ዒንሢ ዓኣዖ ዒንሢ ዒ ባይዛኒ ጋዓንዳያ ሄላንዳኣና ናንጊና ናንጋ ጎዳ ዒንሢ ሚርጌና ዻጋሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","ዒማና ናንጊና ናንጋ ጎዳ ዒንሢና ዎላ ጫኣቄ ጫኣቁማ ፃኣፒንቴያ፥ ዓርሲንቴ ሹጮንሢ ዔካኒ ዹኮ ታኣኒ ኬስኬኔ፤ ዒኢካ ታኣኒ ፔቴታዖ ሙኡዚ ሙዑዋዖ፥ ሃሣ ዑሽኮ ባኣዚያ ዑሽኩዋዖ ዖይዲታሚ ኬሊ ዋንቴና ሮኦሪና ጉቤ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ዬካፓ ዒንሢ ዹኮ ዴማ ቡኬ ዎዶና ናንጊና ናንጋ ጎዳ ታሞ ባኣካ ማዒ ኬኤዛንቴ ዒንሢ ዋይዜ ቃኣሎ ፔ ኩቻ ጊዳ ዒ ፃኣፔ ላምዖ ዓርሲንቴ ሹቺ ታኣም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","ዖይዲታሚ ኬሊ ዋንቴና ሮኦሪና ኩሜስካፓ ናንጊና ናንጋ ጎዳ ዒዚ ጫኣቄ ጫኣቁሞ ፃኣፔ ላምዖ ዓርሲንቴ ሹጮንሢ ታኣም ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","«ዬካፓ ናንጊና ናንጋ ጎዳ ታኣም ‹ሩኡሪና ዹካፓ ኬዴ፤ ጊብፄ ዓጫፓ ኔኤኒ ዔኪ ኬሴ ኔ ዴራ፥ ፑርታ ባኣዚ ማዺ ዒኢቴኔ፤ ታኣኒ ዔያቶ ዓይሤ ዓይሢፆዋ ኔጉዋዖ ዔያታ ሃሺ ፔኤኮ ካኣሽኮንዶ ፆኦዞ ኮሼኔ› ጌይ ኬኤዜኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","«ጊንሣ ሃሣ ናንጊና ናንጋ ጎዳ ታኣም፦ ‹ሃኣዛጌ፤ ሃይ ዴራ ዋይዚ ዒፃያ ማዔሢ ታ ዔራኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","ዓካሪ ማይ ታና ላኣጊፖ፤ ሃካፓ ሴካ ሳዖይዳ ሱንሢ ዔያቶኮ ባኣያ ማሂ ታ ዔያቶ ባይዛንዳኔ፤ ዬካፓ ኔና ታኣኒ ዔያቶይዳፓ ባሼ ዎልቄ ዓኣያና ዺቢ ማዔ ዴሬኮ ዓዶ ማሃንዳኔ› ጌይ ኬኤዜኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","«ዬያሮ ዒዚ ጫኣቄ ጫኣቁማ ፃኣፒንቲ ዓኣ ላምዖ ዓርሲንቴ ሹጮንሢ ላምዖ ኩጮይዳ ዔኪ ዹካፓ ማዒ ታ ኬዴኔ፤ ዒማና ዹኮ ታሚ ዓርቂ ዔኤታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሤ ዓይሢፆ ኔጉዋዖ ዒንሢ ሃሺ ዎርቆ ዓንጎ ሼኤሺ ናኣሪ ማሎና ዓኣ ካኣሽኮ ባኣዚ ማዢ ፆኦሲም ዓይሢንቶ ዒፄሢ ታ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ዬያሮ ናንጊና ናንጋ ጎዳኮ ዓይሢፃ ፃኣፒንቲ ዓኣ፥ ዓርሲንቴ ሹጮንሢ ዒንሢኮ ቤርታ ዢቢ ታ ሜንሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","ዬካፓ ላሚ ሃሣ ዖይዲታሚ ኬሊ ዋንቴና ሮኦሪና ጉቤ ዔኤቢ ሙይ ዑሽኩዋዖ ናንጊና ናንጋ ጎዳ ቤርታ ባሊቶ ሂርኪዲ ጉምዓቲ ታ ዒዛ ሺኢቄኔ። ዬያ ታ ማዼሢ ናንጊና ናንጋ ጎዳ ዖዪሳ ጎሜ ማዺ ዒዛ ዒንሢ ዻጋሴሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ዒዚ ሚርጌና ዻጋዺ ዒንሢ ባይዛኒ ማሌሢሮ ዒዛኮ ዼኤፖ ዻጋ ታና ዒማና ዒጊቼኔ፤ ጋዓንቴ ናንጊና ናንጋ ጎዳ ታኣኮ ሺኢጲፆ ላሚ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ዒማና ናንጊና ናንጋ ጎዳ ዓኣሮኔያ ዎዻኒ ሚርጌና ዻጋዼኔ፤ ዬያሮ ዓኣሮኔማኣ ታ ሺኢቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","ዬኖ ዎርቆ ዓንጎ ሼኤሺ ናኣሮ ማላሢና ዒንሢ ኮሼም ጎሜ ዒንሢኮ ማዔ ሻኣካ ባካሢ ዔኪ ታሚዳ ታኣኒ ዓጌኔ፤ ዬያ ታ ቡርሺ ቡርሺ ሲላሊ ማሂያ ጋኣጪ ሲላሎ ዹኮይዳፓ ዓልቂ ዎታ ዋኣፆይዳ ላኣሌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","«ሃሣ ጊንሣ ዒንሢ ታብዔራይዳ፥ ማሳሄንታ ቂብሮቴሃታዋንታይዳ ናንጊና ናንጋ ጎዳ ዻጋሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ናንጊና ናንጋ ጎዳ፦ ‹ዴንዱዋቴ፤ ታ ዒንሢም ዒንጋንዳኔ ጌዒ ጫኣቄ ዓጬሎ ዻካሉዋቴ› ጌዒ ቃዴሴ ባርኔይዳፓ ዳኬ ዎዶና ዒዛም ዒንሢ ዋይዞ ዒዒፄያፓዓቴም ዒዛ ዒንሢ ጉሙርቂባኣሴ፤ ሃሣ ዒ ጋዓ ባኮዋ ዓይሢንቲ ዒንሢ ማዺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","ታ ዒንሢ ዔሬማፓ ዓርቃዖ ናንጊና ናንጋ ጎዳም ዒንሢ ዓይሢንቱዋያ ማዒ ዓይ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","«ዬያ ባኮ ዛሎሮ ናንጊና ናንጋ ጎዳ ቤርታ ታኣኒ ባሊቶ ሂርኪዲ ጉምዓቲ ዖይዲታሚ ኬሊ ዋንቴና ሮኦሪና ጉቤ ሺኢቂ ዴዔኔ፤ ዬያ ታኣኒ ማዼሢ ዒዚ ‹ታ ዒንሢ ባይዛንዳኔ› ጌዔሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","ዒማና ታኣኒ ‹ቢያ ባኮ ማዤ ናንጊና ናንጋ ጎዳሢዮ! ኔኤኮ ዼኤፖ ዎልቆና ዶዱሞና ዓውሲ ጊብፄ ዓጮይዳፓ ኔኤኒ ኬሴ፥ ኔ ዴሮ ባይዚፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","ኔኤም ማዻዞንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታም ማሌ፤ ሃያ ዴሮኮ ዋይዞ ዒፂፆና ፑርቱሞና፤ ሃሣ ጎሞዋ ቢያ ፓይዲ ዓርቂፖ፤› ");
INSERT INTO mdyeth_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ኔ ዬያይዲባኣቴ፦ ‹ዒ ዒንጋንዳኔ ጌይ ጫኣቄ ጎይፆና ዴሮ ዬኖ ዓጬሎ ጌልዛኒ ዳንዳዒባኣሴ› ጌዒ ጊብፄ ዓሳ ሚኢጫንዳኔ፤ ዬያ ሌሊቱዋንቴ ‹ዴሮ ፔኤኮ ዒ ዒፄሢሮ ዎዻኒ ኮዒ ዓሲ ናንጉዋ ዳውሎ ኬሴኔ› ኔና ጋዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","‹ዬያ ቢያይዳፓ ባሼ ሃይ ዴራ ኔኤኒ ኔ ዓሲ ማዓንዳጉዲ ዶኦሬያ፤ ሃሣ ኔኤኮ ዼኤፖ ዎልቆና ዶዱሞና ጊብፄ ዓጫፓ ኬሴ ዓሶኬ› ጌይ ታ ሺኢቄኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","ሙሴ ኬኤዛዖ፦ «ዬካፓ ሃሣ ናንጊና ናንጋ ጎዳ ታና ‹ቤርታ ዓርሲንቴ ሹጮንሢጉዴያ ላምዖ ዓርሴ፤ ሃሣ ዬያቶ ጌሦንዶ ሳኣፂኔ ሚሢና ኮሼ፤ ታኣኒ ዓኣ ዹኮዋ ታ ኮይላ ኬስኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ቤርታ ኔኤኒ ሜንሤ፥ ዓርሲንቴ ሹጮንሢዳ ፃኣፒንቴ ዓይሢፆንሢ ላሚ ታ ፃኣፓንዳኔ፤ ኔኤኒ ዬንሢ ሳኣፂኖ ጋራ ጌሣንዳኔ› ሂዚ ጌይ ዓይሤኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","«ዬያሮ ታኣኒ ሻሪ ሚሢ ዓርሲ ሳኣፂኔ (ታኣቦቴ) ማዤኔ፤ ቤርታኣሮንሢጉዴያ ላምዖ ሹጮንሢያ ዓርሲ ታ ኮሼኔ፤ ዬንሢያ ኩጫ ዔኪ ዹኮ ታኣኒ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ዹኮ ዴሞይዳ ዒንሢ ቡኪንቴ ኬሎና ታሞ ባኣካ ማዒ ናንጊና ናንጋ ጎዳ ዒንሢም ኬኤዜ፥ ታጶ ዓይሢፆ ቤርታኣሮማ ጎይፆ ሹጮንሢዳ ፃኣፒ ዬንሢ ሹጮንሢ ታኣም ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ታኣኒያ ዹካፓ ማዒ ኬዲ፥ ናንጊና ናንጋ ጎዳ ታና ዓይሤ ጎይፆና ዓይሢፃ ፃኣፒንቲ ዓኣ ሹጮንሢ ታኣኒ ኮሼ ሳኣፂኖ ጋራ ጌሤኔ፤ ዬካፓ ዓርቃዖ ሃኖ ሄላንዳኣና ዬንሢ ሳኣፂኖ ጋራ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(ዒስራዔኤሌ ዓሳ ያዕቃኔ ዴራ ቦኦኬ ዔቶ ዋኣፃ ዓኣ ቤዛፓ ዔቂ ሞሴራ ጌይንታ ቤሲ ዴንዴኔ፤ ዒማና ዓኣሮኔ ዒኢካ ሃይቂ ዱኡቴኔ፤ ዒዛ ቤዞይዳ ናኣዚ ዓላዜሬ ቄኤሴ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","ዬካፓ ሃሣ ዔያታ ጉድጎዳ ጌይንታ ቤሲ ዴንዴኔ፤ ዬካፓ ጊንሣ ዓልቃ ዋኣሢ ሚርጌ ዓኣያ፥ ዮፂባታ ጎዖ ቤሲ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ዒማና ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ጌሦና ሳኣፂኖ ኬዳንዳጉዲ፤ ሃሣ ዒዛ ቤርታ ዔቂ ማዻንዳጉዲ ዴሮዋ ናንጊና ናንጋ ጎዳ ሱንፆና ዔያታ ዓንጃንዳጉዲ ሌዊ ማኣሮ ዓሶ ናንጊና ናንጋ ጎዳ ዱማሲ ዶኦሬኔ፤ ሃኖ ሄላንዳኣና ሌዊ ማኣሮ ዓሶኮ ማዻ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ሌዊ ማኣሮ ዓሳ ሃንጎ ዔያቶ ዓሶጉዲ ዓጪ ዓኣያ ማዒባኣሢ ዬያሮኬ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ኬኤዜ ጎይፆ ዔያታ ፔ ናንጎም ማዓ ባኣዚ ዴንቃሢ ናንጊና ናንጋ ጎዳም ዔያታ ማዻ ማዻፓኬ።) ");
INSERT INTO mdyeth_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","«ታኣኒ ቤርታ ማዼ ጎይፆ ላሚ ሃሣ ዹኮይዳ ዖይዲታሚ ኬሊ ሮኦሪና ዋንቴና ጉቤ ሺኢቂ ዴዔኔ፤ ናንጊና ናንጋ ጎዳ ጊንሣ ሃሣ ሺኢጲፆ ታኣኮ ዋይዚ፥ ዒንሢ ባይዚፆ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ዬካፓ ‹ዓካሪ ዴንዴ፤ ዔያቶኮ ቤርታኣ ዓዶንሢም ዒንጋኒ ታ ጫኣቄ ጎይፆና ዓጬሎ ዔያታ ዻካላንዳጉዲ ዴሮ ዔኪ ዓኣዼ› ታኣም ጌዔኔ» ጌኤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","13","«ዒስራዔኤሌ ዴሬዮቴ! ናንጊና ናንጋ ጎዳ ዒንሢዳፓ ኮዓ ባካ ዓይጎዳይ ጌዔቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዒጊጫንዳጉዲ፤ ዒዚ ዓይሣ ጎይፆ ዒንሢ ዴንዳንዳጉዲ፤ ዒዛ ዒንሢ ናሽካንዳጉዲ፤ ጉቤ ዒናፓ ሃሣ ጉቤ ሼምፓፓ ዒዛም ዒንሢ ማዻንዳጉዲኬ፤ ኮሹሞ ዒንሢም ማዓንዳጉዲ ሃኖ ታ ዒንሢ ዓይሣ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ዓይሢፆንታ ዳምቦንታ ዒንሢ ካፓንዳጉዲ ማዓንዳኣፓዓቴም ዒዚ ሜሌ ዒንሢዳፓ ዓይጌንዴ ኮዓይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","ጫሪንጮና ጫሪንጮኮ ዑፃ ዓኣ ጫሪንጫ፤ ዬያጉዲ ሃሣ ሳዖንታ ዬያይዳ ዓኣ ባካኣ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","ናንጊና ናንጋ ጎዳ ዒንሢኮ ቤርታኣ ዓዶንሢ ሚርጌና ናሽካያ ማዔሢሮ ሃኖዋ ዒንሢ ዒዚ ሜሌ ዴሮ ሚርጌሢ ባኣካፓ ዶኦሬኔ፤ ሃሣ ዒንሢ ሃኖ ሄላንዳኣና ዒዛኮ ዶኦሪንቴ ዴሬ ማዒ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ዬያሮ ሃካፓ ሴካ ዋይዞ ዒፃ ፑርቶ ዒኖ ዒንሢዳፓ ቲቂ ኬሲ ናንጊና ናንጋ ጎዳም ዓይሢንታያ ማዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሜሌ ፆኦዞ ቢያሢዳፓ፥ ሃሣ ዎልቄና ዓኣ ባኮይዳፓ ቢያ ዼኤፒ ጊንሣ ሃሣ ዶዲ ማዔሢሮ ዒጊጪ ቦንቺንታኒ ኮይሳኔ። ዒዚ ዓሲ ዱማሲ ዛጊ ዎጉዋሴ፤ ዴሜና ሚኢሼ ዔኪ ዎጊፆ ዎቢሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","ዒዚ ዓዶንታ ዒንዶንታባኣ ዜኤሮ ናኣቶና ዜኤሮይንዶንሢናም ፒዜ ዎጋኔ፤ ሃሣ ዒዚ ኑ ዓሶ ባኣካ ናንጋ፥ ሜሌ ዓጮ ዓሶዋ ቢያ ናሽካሢሮ ሙኡዚና ማኣዖና ዔያቶም ዒንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","ዬያሮ ዒንሢያ ጊብፄ ዓጮይዳ ሙኬ ዓሲ ማዒ ሃያኮ ቤርታ ናንጌሢሮ ዬያቶ ሜሌ ዓጫፓ ሙኬዞንሢ ናሽካንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒጊቹሞና ዓይሢንቱዋቴ፤ ዒዛ ሌሊ ካኣሽኩዋቴ፤ ዒዛም ጉሙርቂንታያ ማዒ ዒዛ ሱንፆ ሌሊ ዔኤሊ ጫኣቁዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ዒዚ ዒንሢኮ ፆኦዛሢኬ፤ ዒዚ ዒንሢም ማዼ ዼኤፖ ዼኤፖ ባኮና ዲቃሣ ባኮ ዒንሢ ዓኣፒና ዒንሢ ዛጌሢሮ ቢያ ኬሊ ዒዛ ጋላቱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","ዒንሢኮ ቤርታኣ ዓዶንሢ ጊብፄ ዓጮ ዴንዳኣና ፓይዳ ዔያቶኮ ላንካይታሚ ሌሊኬ፤ ሃሢ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ፓይዶ ዒንሢኮ ጫሪንጮ ዦኦጋሢጉዲ ሚርጊሼኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","ሙሴ ሃሣ ኬኤዛዖ፦ «ዓካሪ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ናሽኩዋቴ፤ ዒንሢ ማዺ ኩንሣንዳጉዲ ዒ ኮዓ ዎጎና ዳምቦና ዓይሢፆዋ ማዺ ኩንሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ጎሬ ጎሪፆ፥ ዒዛኮ ዼኤፑሞንታ ዶዶ ዎልቆንታ ዛጊ ዔሬ ዓሳ ዒንሢኮ ናኣቶቱዋንቴ ዒንሢታሢ ሃኖ ማሊ ጶቂሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ዒዛ ዎልቆና ዒ ማዼ ዓኮ ባኮንታ ጊብፄ ዓጮ ካኣቲና ዒዛኮ ዓጮ ቢያሢዳ ዒ ማዼ ዲቃሣ ማዾ ዒንሢ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ጊብፄ ዓጮኮ ዖሎ ዓሳ ዒንሢ ዳውሲ ኬስኬ ዎዶና ዔያቶኮ ፓራሢና ሳርጌሎ ዖይቶና ዞቄ ባዞይዳ ጌልዚ ሙኡዚ፥ ናጊና ናንጋ ጎዳ ዎማይዲ ዔያቶ ባይዜቴያ ዒንሢ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ሃይካ ዒንሢ ሄላንዳሢኮ ቤርታ ናንጊና ናንጋ ጎዳ ዬያ ዓሲ ናንጉዋ ዳውሎይዳ ዓይጎ ማዼቴያ ዒንሢ ዔራኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ሮኦቤኤሌ ማኣሪ ዓሲ ማዔ ዔሊያቤኮ ናኣቶ ዳታኔና ዓቤሮኔናይዳ ማዺንቴ ባኮ ማሊ ጶቂሡዋቴ፤ ዒስራዔኤሌ ዴራ ቢያ ፔ ዓኣፒና ዛጋንቴ ሳዓ ዳርዒ ዔያቶንታ ዔያቶኮ ማኣሮ ዓሶንታ ዓፒሎና ማዦና ማኣሮንታ ቆልሞንታ ዬያጉዲ ዔያቶሮ ማዔ ባኮ ቢያ ዔኤዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ናንጊና ናንጋ ጎዳ ማዼ፥ ዬያ ዼኤፖ ዼኤፖ ባኮ ቢያ ዓኣፒና ዛጌ ዓሳ ዒንሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","«ዒንሢ ዮርዳኖሴ ዎሮና ፒንቂ ዻካላንዳ ዓጬሎ ጌሊ ዓርቃንዳ ዎልቄ ዴንቃኒ ታኣኒ ሃኖ ዒንሢም ዓይሣ ዓይሢፆ ቢያ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ዓይሢፆ ዒንሢ ካፒ ኩንሣያ ማዔቴ ናንጊና ናንጋ ጎዳ ዒንሢኮ ቤርታኣ ዓዶንሢና ዔያቶኮ ዜርፆናም ዒንጋኒ ጫኣቄ፥ ዔኤዞና ዲኢቆና ኩሜ ዓጬሎይዳ ዖዶሲ ሌዔ ዒንሢ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ዬና ጌሊ ዒንሢ ዻካላንዳ ዓጬላ ቤርታ ዒንሢ ናንጌ ጊብፄ ዓጮጉዲቱዋሴ። ጊብፄ ዓጮይዳ ጎዦ ዒንሢ ጎሽካዖ ዜርቂንቴ ሃኣኮ ማኣሪ ካርካ ዒንሢ ቱኬ ባኣዚጉዲ ዻዎ ዋኣሢ ዑሺ ዒንሢ ሜታዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ጋዓንቴ ዮርዳኖሴ ዎሮና ፒንቂ ዒንሢ ዻካላንዳ ዓጬላ ዹካንታ ዶኦቺ ቤሲንታ ዓኣያ ዒርዚ ዋርቃ ቤሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ዬኖ ዓጬሎም ኮይሳ ባኮ ዛጊ ዒንጋሢና ሌዖ ጉቤ ዛጊ ካፓሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","«ዬያሮ ሃኖ ታ ዒንሢ ዓይሣ ዎጎ ቢያ ካፒ ኩንሡዋቴ፤ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ናሽኩዋቴ፤ ጉቤ ዒናፓ ዒዛም ማዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ያኣዼ ዒንሢ ማዼቴ ናንጊና ናንጋ ጎዳ ዒንሢም ሌዖ ዒሮና ሲሎ ዒሮና ኮይሳ ዎዶማና ዋርቂሻንዳኔ፤ ዬያሮ ዒንሢም ጊዳንዳ ሃኣኮንታ ዎይኖ ዑዦንታ ሪሚቶ ዛይቶንታ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ቆልማ ዒንሢኮ ሄንቃንዳ ማኣቲንታ ሚርጋንዳኔ፤ ዒንሢም ኮይሳ ሙኡዚያ ቢያ ዒንሢ ዴንቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","ናንጊና ናንጋ ጎዳ ዒንሢ ሃሺ ሜሌ ፆኦሲ ካኣሽኪሢዳ ጌሉዋጉዲ ዒንሢና ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ዒንሢ ዬያይዴቴ ናንጊና ናንጋ ጎዳ ዒንሢዳ ዻጋዻንዳኔ፤ ጫሪንጫፓ ዒርዚ ዋርቁዋጉዲ ካሮ ዎዺ፥ ሳዖይዳ ዒንሢኮ ዒርዚ ዋርቄም ሃኣኮ ካፁዋጉዲ ላኣጋንዳኔ፤ ዒንሢያ ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጋ ማሎ ዓጬሎይዳፓ ኔጉዋዖ ባይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","«ዬንሢ ዓይሢፆ ቢያ ዎዴ ዒንሢኮ ዒኖይዳይፓ ባይዙዋዖ ማሉዋቴ፤ ዒንሢም ዋሊንቱዋ ማላታ ማዓንዳጉዲ ዬያቶ ዒንሢኮ ኩጮይዳ ቱኩዋቴ፤ ዒንሢኮ ባሊቶይዳኣ ጌሡዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","ዒንሢኮ ናኣቶም ኬኤዚ ዔርዙዋቴ፤ ማኣራ ዒንሢ ዴዓ ዎዶና፥ ዒንሢ ጎይሢ ኬስኬ ዎዶና፥ ዒንሢ ሃውሻ ዎዶማናኣ ማዖም ማዾ ማዻኣና ቢያ ዬያ ዛሎ ጌስቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","ማኣሮ ካሮኮ ቦኦኮላሢና ማርሾ ካሮናይዳ ፃኣፑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ያኣዼ ዒንሢ ማዼቴ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋኒ ጫኣቄ ዓጮይዳ ዒንሢንታ ዒንሢኮ ናኣቶንታ ሳዖ ዑፃ ሌካ ዓኣ ጫሪንጫ ናንጋ ሌዖጉዲ ዖዶሲ ዎዴ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","«ዬያሮ ታ ዒንሢም ዓይሤ ዓይሢፆ ዛጊ ማዺ ኩንሡዋቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ናሽኩዋቴ፤ ዒዚ ዓይሣ ጎይፆ ሃንቲ ዒዛም ጉሙርቂንታያ ማዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ያኣዼ ዒንሢ ማዼቴ ናንጊና ናንጋ ጎዳ ዒንሢኮ ሃያ ቤርታ ዓኣ ዴሮ ቢያ ቤዛፓ ዳኪ ባይዛንዳኔ፤ ሚርጌ ሃሣ ዎልቄና ዒንሢፓ ኮሺ ባሻያ ማዔ፥ ሜሌ ዴሮኮ ዓጮ ዒንሢ ዻካላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","ዒንሢ ዴንዳዖ ቶኮና ሄርቃ ቤዛ ቢያ ዒንሢ ዓጪ ማዓንዳኔ፤ ዒንሢኮ ዛጳ ዾኦሎ ዛሎይዳ ዓኣ ዓሲ ናንጉዋ ዳውሎይዳፓ ዓርቃዖ ኬዶ ዛሎና ዓኣ ሊባኖኦሴ ዹኮ፤ ዬያጉዲ ሃሣ ዓባ ኬስካ ዛሎና ዓኣ ዔፕራፂሴ ዎራፓ ዓርቂ ዓባ ጌላ ዛሎይዳ ዓኣ ሜዲቴራኒያ ጌይንታ ዼኤፖ ባዞ ሄላንዳኣና ዳልጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","ዬኖ ዓጮይዳ ዒንሢ ዴንዴ ቤዞ ቢያይዳ ናንጊና ናንጋ ጎዳ ዒንሢም ማዻኒ ጫኣቄ ጎይፆና ዴራ ቢያ ዒንሢ ዒጊጫያ ማዓንዳኔ፤ ዒንሢ ቃዛንዳ ዓይጎ ዓሲያ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","«ሃይሾ፤ ታኣኒ ሃኖ ዒንሢ ዓንጆና ጋዳማናይዳፓ ፔቴማ ዶኦሩዋቴ ጋዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ዓይሢፆ፥ ሃኖ ታ ዒንሢም ኬኤዛሢ ቢያ ዒንሢ ማዺ ኩንሣያ ማዔቴ ዓንጆ ዒንሢ ዴንቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ሃያኮ ቤርታ ዒንሢ ዔሩዋያ፥ ሜሌ ፆኦሲ ካኣሽኪሢዳ ጌሊ ዬያ ዓይሢፆ ካፒ ኩንሢባኣያ ማዔቴ ጋዳማ ዒንሢ ሄላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","ዒንሢ ዻካላንዳ ዓጬሎ ናንጊና ናንጋ ጎዳ ዒንሢ ጌልዜ ዎዶና ዓንጆ ጌሪዛኔ ዹኮይዳ፤ ጋዳሞ ቤዔባኣሌ ዹኮይዳ ኬስኪ ዔቂ ዼጊዲ ዒላቲ ኬኤዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","ዬንሢ ላምዖ ዹኮንሢ ዮርዳኖሴ ዎሮ ሱካ ዓባ ጌላ ዛላ ዓኣ ዓራባይዳ ናንጋ ካኣናኔ ዓሶ ዓጮይዳ ጌልጌላ ጌይንታ ካታሞኮ ቤርቶ ዛላ ሞኦሬ ጌይንታ ቤዛ ዓኣ ዼኤፖ ሚፆ ኮይላ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ናንጋንዳጉዲ ዒንጋ ዓጬሎ ጌሊ ዻካላኒ ሃሢ ዒንሢ ዑኬሢሮ ዮርዳኖሴ ዎሮና ፒንቂ ዬኖ ዓጬሎ ዔኪ ዒንሢ ናንጋ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ታኣኒ ዒንሢም ሃኖ ኬኤዛ ዎጎና ዳምቦና ቢያ ዛጊ ካፒ ኩንሣያ ማዑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ሙሴ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ቤርታኣ ዓዶንሢ ፆኦዛሢ ዒንሢም ዒንጋ ዓጬሎይዳ ዒንሢ ናንጋ ዎዶና ቢያ ዒንሢ ዛጊ ካፓንዳ ዎጎና ዳምቦና ያዺኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","ዒንሢ ጌሊ ዻካላ ዓጬሎይዳ ናንጋ ዴራ ዹኮና ጌሜሮና፥ ሃሣ ዓኣዔ ዒላዣ ዋርቃ ሚፆ ዴማ ፔ ፆኦዞም ዚጊ ካኣሽካ ቤዞ ቢያ ሻሂ ባይዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","ዔያታ ፔ ፆኦዞም ሚቺ ዒንጋ ቤዞዋ ዶይሱዋቴ፤ ሜሌ ፆኦዞ ካኣሽኮ ዻኣቦዋ ሜንሢ ጊኢጩዋቴ፤ ዓሼራ ጌይንታ ዔያቶኮ ላኣሎ ፆኦዜሎ ማላቶ ቢያ ታሚና ሚቹዋቴ፤ ዔያቶኮ ካኣሽኮ ባኮ ቢያ ቆፂ ሜንሢ ሜንሢ ኬኤሩዋቴ፤ ሱንፃ ዬያቶ ባኮኮ ላሚ ማሊንቱዋጉዲ ዬኖ ቤዛፓ ጋፒሲ ባይዙዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ዚጋሢ ሃኣታ፥ ሜሌ ዴራ ፔ ፆኦዞም ዚጊ ካኣሽካ ጎይፆ ካኣሽካንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","ዒንሢ ፃጳ ናንጋ ቤዞይዳፓ ዒንሢ ዒዛ ካኣሽካንዳ ቤሲ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዶኦራንዳኔ፤ ዬኖ ቤዞ ኮዒ ዒኢካ ዴንዱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ዒኢካ ናንጊና ናንጋ ጎዳም ሚቺ ዒንጎ ዒንጊፆና ሜሌ ዒንሢ ዒንጋ ባኮ ቢያ ታጳፓ ፔቴ ዔኪ ዒንጎ ዒንጊፆንታ ዒዛም ዒንሢ ናኣቤ ናኣቦንታ ዒንሢ ዒናና ዒንሢ ናሽኪ ዒንጋ ዒንጊፆንታ ባኣቶና ማራቶንታኮ ቤርታ ሾይንቴ ናኣቶ ዒንጎሢንታ ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ዒንሢ ዓንጄ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ዒንሢንታ ዒንሢኮ ማኣሮ ዓሶንታ ቡኪ ዬኖ ቤዞይዳ ሙዑዋቴ፤ ዒንሢ ማዺ ዴንቄ ኮዦ ባኮና ቢያ ዬያይዲ ዎዛዹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","«ዬና ዎዳ ሄላዛ ሃኖ ሄላንዳኣና ዒንሢ ኮዔ ጎይፆ ማዻሢጉዲ ማዺፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","ዓይጎሮ ጌዔቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ቤዞይዳ ኮሺና ዒንሢ ሃውሺ ናንጋንዳ ዓጮ ሃጊ ዒንሢ ጌሊባኣሢሮኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጌ ዓጬሎይዳ ናንጋኒ ዮርዳኖሴ ዎሮና ዒንሢ ፒንቃንዳኔ፤ ኮሺና ዒንሢ ናንጋንዳጉዲ ዒንሢ ኮይላ ዓኣ ሞርካ ቢያ ዒንሢ ሜታሱዋጉዲ ዒንሢ ዒ ሃውሺሳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ናንጊና ናንጋ ጎዳ ዚጊ ዒንሢ ካኣሽካንዳ ፔቴ ቤሲ ዒ ፔኤሮ ዒንሢም ዶኦራንዳኔ፤ ታኣኒ ዒንሢ ዓይሤ ባኮ ቢያ ዒኢካ ዒንሢ ዔኪ ሙካንዳኔ፤ ዬይያ፦ ሚቺ ዒንጎ ዒንጊፆንታ ሜሌ ዒንጊፆ ቢያ፥ ታጳፓ ፔቴ ኬሲ ዒንጎ ዒንጊፆንታ ሜሌ ዒንሢ ዒንጋ ዒንጊፆ ቢያ፤ ናንጊና ናንጋ ጎዳም ዒንሢ ናኣባ ናኣቦንታ ቢያ ዒኢካ ዒዛም ዔኪ ሙኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ናንጊና ናንጋ ጎዳ ቤርቶይዳ ዒንሢኮ ዓቲንቆ ናኣቶና ዉዱሮ ናኣቶና ሃሣ ዒንሢም ማዾ ማዻ ዓቲንቆንታ ላኣሎንታ፤ ዬያጉዲ ዒንሢኮ ካታሞይዳ ናንጋ ሌዊ ዓሶንታ ዎላ ዒኢካ ዎዛዹዋቴ፤ ዓይጎሮ ጌዔቴ ሌዊ ዓሳ ዒንሢና ዎላ ጊሽቲ ዔኬ ዓጪ ባኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ናንጊና ናንጋ ጎዳም ሚቺ ዒንጎ ዒንጊፆ ጉቤ ቤሲዳ ዚቲ ጋዓዖ ሚቺ ዒንሢ ዒንጉዋጉዲ ኮሺ ዒንሢና ዔሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ሚቺ ዒንጎ ዒንጊፆ ዒንሢ ዒንጋኒ ኮይሳሢ ዒንሢ ፃጳ ናንጋ፥ ዔያቶሮ ማዔ ቤሲዳ፤ ሃሣ ናንጊና ናንጋ ጎዳ ፔኤም ዒንጊንታንዳጉዲ ዶኦሬ ፔቴ ቤሲዳ ሌሊኬ። ሚቺ ዒንጎ ዒንጊፆ ማዔቴያ ሜሌ ታኣኒ ዒንሢ ዓይሤ ባኮ ቢያ ዒዞ ቤዞይዳ ሌሊ ማዺ ኩንሡዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","«ያዺ ማዔቴያ ዒንሢ ዓሽኪ ሙዓኒ ኮዔ ዎዶና ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጌ ዓንጆ ጎይፆ ጉዴያና ዒንሢ ናንጋ ካታሞኮ ዎኖ ቤዛ ማዔቴያ ሹኪ ዒንሢ ሙዓኒ ዳንዳዓኔ፤ ዒንሢ ባኣካ ዳምቦ ጎይፆና ጌኤሺ ማዔሢንታ ማዒባኣሢንታ ቢያ ሮኦቶንታ ጌንዖንታ ሙዓሢ ጎይፆ ዬያ ሹኪንቴ ዓሽኮ ሙዓኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","ጋዓንቴ ዬያ ሱጉፆ ዑሽኪፖቴ፤ ሱጉፆ ዋኣሢጉዲ ሳዓ ላኣሉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","ናንጊና ናንጋ ጎዳም ዒንሢ ሹኪ ዒንጋ ዒንጊፆ ቢያ ዒንሢ ዒንጋ ቤዞ ቢያይዳ ዓይጎ ቤስካኣ ዚቲ ጋዓዖ ሙይንታንዳያ ኮይሱዋሴ፤ ዬይ ዒንጊፃ ሃኣኮንታ ዎይኖ ዑዦንታ ሪሚቶ ዛይቶንታኮ ታጳፓ ፔቴ ዒንጎ ዒንጊፆንታ ዒንሢኮ ባኣቶና ማራቶናኮ ቤርቶ ናኣቶንታ ናንጊና ናንጋ ጎዳም ዒንሢ ናኣቤ ናኣቦንታ ዒንሢ ሼኔና ዒንሢ ዒንጋ ዒንጊፆንታ ቢያ ዚቲ ጋዓዖ ዒንሢ ናንጋ ቤዞይዳ ቢያ ሙይንቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዶኦሬ ቤዞይዳ ዒንሢኮ ዓቲንቆ ናኣቶንታ ዉዱሮ ናኣቶንታ ማዾ ማዻ ዓቲንቆንታ ላኣሎንታ፤ ዬያጉዲ ዒንሢኮ ካታሞይዳ ናንጋ ሌዊ ዓሶንታ ዎላ ዬያ ሙዑዋቴ፤ ዒዞ ቤዞይዳ ላቢ ዒንሢ ዴንቄ ኮዦ ባኮና ቢያ ዬያይዲ ዎዛዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","ዒንሢ ሳዖይዳ ዒንሢ ናንጋ ዎዶና ቢያ ሌዊ ዓሶ ዒንሢ ዋሉዋጉዲ ዒንሢና ዔሩዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ማዻንዳኔ ጌዒ ጫኣቄ ጎይፆና ዒንሢ ዓጮኮ ዛጶ ዒ ዳልጊሼ ዎዶና ዓሽኪ ዒንሢ ሱኡኬቴ ኮዔ ጎይሢ ሙዓኒ ዒንሢ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ዒንሢ ሹኪ ዒንጋንዳጉዲ ናንጊና ናንጋ ጎዳ ዶኦሬ ቤዜላ ዒንሢም ሃካያ ማዔቴ ዓሽኪ ዒንሢ ሱኡኬ ዎዶና ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጌ ባኣቶንታ ማራቶንታይዳፓ ታ ዒንሢ ዓይሤ ጎይፆና ዒንሢ ኮዔ ጎይሢ ሹካኒ ዳንዳዓኔ፤ ዬያ ዓሽኮ ዒንሢኮ ማኣራ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ዳምቦ ጎይፆና ጌኤሺ ዓሲ ማዔቴያ ጌኤሺ ማዒባኣያታቴያ ሮኦቶ ዓሽኪንታ ጌንዖ ዓሽኪንታ ሙዓሢ ጎይፆ ዬያ ዓሽኮ ሙዓኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","ጋዓንቴ ሱጉሢ ላኣሊንቲባኣ ዓሽኪ ዒንሢ ሙዑዋጉዲ ዒንሢና ዔሩዋቴ፤ ዓይጎሮ ጌዔቴ ሼምፓ ሱጉፆይዳ ዓኣሢሮ ሼምፖ ዓሽኮና ዎላ ሙይፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","ሱጉሢ ዑሽኪፖቴ፤ ጋዓንቴ ዋኣሢጉዲ ሳዖይዳ ላኣሉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","ዬያ ዒንሢ ካፒንቲ ኩንሤቴ ፆኦሲ ዎዛዻኔ፤ ዒንሢንታ ዒንሢኮ ናኣቶንታም ኮሺ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","ዬያሮ ፆኦሲም ዱማዼ ዒንጊፆና ዒዛም ዒንሢ ናኣቤ ናኣቦ ዒንጊፆ ዒዚ ዶኦሬ ቤዞማ ሌሊ ዔኪ ዓኣዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ናንጊና ናንጋ ጎዳም ዒንሢ ሚቺ ዒንጋ ዒንጊፆ ጌይፃ ዓሽኮና ሱጉፆና ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ቤዛ ሚቺ ዒንጉዋቴ። ሜሌ ዒንጊፆ ማሂ ዒንጋ ባኮኮ ሱጉፃ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ቤዞ ኮይላ ላኣሊንቶንጎ፤ ዓሽኮ ጋዓንቴ ዒንሢ ሙዓኒ ዳንዳዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","ታኣኒ ዒንሢ ዓይሣ ዎጎ ቢያ ጉሙርቂንቲ ካፑዋቴ፤ ዒንሢ ዬያይዴቴ ዒንሢንታ ዒንሢኮ ናኣቶንታም ቢያ ባኣዚ ናንጊና ጊኢጋያ ማዓንዳኔ፤ ያዺ ዒንሢ ማዼ ዎዶና ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ፒዜ ባኣዚ ዒንሢ ማዼኔ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","«ዒንሢ ናንጋ ዓጮይዳ ሜሌ ዴሮና ዒንሢ ዖልታ ዎዶና ናንጊና ናንጋ ጎዳ ዔያቶ ባይዛንዳኔ፤ ዔያቶኮ ዓጮ ዔኪ ዒንሢ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","ናንጊና ናንጋ ጎዳ ዬያ ዴሮ ባይዜስካፓ ዔያታ ማዻ ባኮ ዒንሢ ማዺሢዳ ጌሉዋጉዲ ዒንሢና ዔሩዋቴ፤ ኑኡኒያ ዔያቶ ጎይፆ ማዻንዳኔ ጌዒ ዬይ ሜሌ ዴራ ፔ ፆኦዞ ዎይቲ ካኣሽካቴ ጌይ ዖኦጪ ሺሪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዚጊ ዒንሢ ካኣሽካ ጎይፃ ዬይ ሜሌ ዴራ ፔ ፆኦዞም ዚጋሢ ጎይፆጉዲ ማዓኒ ኮይሱዋሴ፤ ዔያታ ፔ ፆኦዞም ዚጊ ካኣሽካ ዎዶና ማዻ ባካ ቢያ ሚርጌና ሻኣካያ፥ ናንጊና ናንጋ ጎዳኣ ዒሣያኬ፤ ዔያታ ሜሌ ዓታዛ ፔኤኮ ሾዔ ናኣቶዋ ሚቺ ዒንጎ ቤዞይዳ ፔ ፆኦዞም ሚቺ ዒንጋኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","«ዓካሪ ታ ዒንሢ ዓይሤ ባኮ ቢያ ማዹዋቴ፤ ዬያ ባኮይዳ ፔቴታዖ ዔኤቢ ቃሲፖቴ፤ ፔቴታዖዋ ሃሣ ዔኤቢ ዓይሲፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","ሃሣ ሙሴ ኬኤዛዖ፦ «ዒንሢ ባኣካፓ ሎንሦ ኬኤዛ ዓሲ፤ ጊንሣ ሃሣ ዓውቲና ዔኤቢ ኬኤዛ ዓሲ ዔቂጋፓ፥ ‹ፆኦሲ ዎልቄና ማዺንታ ባኣዚ፥ ሃሣ ዓኪ ዲቃሣ ባኣዚ ታ ማዻንዳኔ› ጌዔም፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ዬይ ዒ ጌዔ ዓኮ ዲቃሣ ባካ ማዺንቲ ኩሜያ ማዔቴያ ዬይ ዓሢ ‹ዒንሢ ቤርታ ዔሩዋ ሜሌ ፆኦሲ ኑ ካኣሽኮም› ጌዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲ ዒዛ ጎኔ ዒናፓ ዒንሢ ናሽኬቴያ ዔራኒ ኮዒ ዬያ ዓሢ ዳኬያናንዳሢሮ ዬያ ሎንሦ ኬኤዛ ዓሣሢሲና ዓውቶና ዴንቃሢሲያ ዋይዚፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጋዓ ጎይፆ ሃንቱዋቴ፤ ዒዛ ሌሊ ዒጊጩዋቴ፤ ዓይሢፆዋ ካፒ፥ ዒ ጋዓ ባኮዋ ዋይዙዋቴ፤ ዒዛ ካኣሽኩዋቴ፤ ዒዛና ዒንሢናኮ ፔቱማ ዶዲ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ዓይሌ ማዒ ዒንሢ ናንጌ፥ ጊብፄ ዓጫፓ ኬሲ ዒንሢ ዓውሴ ናንጊና ናንጋ ጎዳሢም ዋይዞ ዒንሢ ዒፃንዳጉዲ ማዻ ዓውቶና ዴንቃኔ ሃሣ ሎንሦ ባኮ ኬኤዛኔ ጋዓ ዓሲ ቢያ ዎዎዹዋቴ፤ ዬይ ዓሢ ዶዲሺ ዓርቂ ዒንሢ ናንጋንዳጉዲ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሤ ጎይፆይዳፓ ሺኢሻኒ ዒንሢ ማሌያኬ፤ ዬያሮ ዬያ ፑርታሢ ዒንሢ ባኣካፓ ባይዙዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","«ሜሌ ዓቴም ዒንሢኮ ዒሾታቴያ ጌኤዚ፥ ዒንሢኮ ዓቲንቆ ናዖ ማዔቴያ ዉዱሮ ናዓ ሃሣ ዒንሢ ናሽካያ ዒንሢኮ ማቾ ማዔቴያ ዒንሢኮ ጉሙርቂንታ ላጌ ማዔይ ዒንሢኮ ቤርታኣ ዓዶንሢንታ ዒንሢንታ ዚጊ ካኣሽኪ ቤቂባኣ ሜሌ ፆኦሲም ዚጊ ካኣሽካንዳጉዲ ዴሚና ዒንሢ ጌሻያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","‹ዑኬ ማዔቴያ ሃኬ፤ ሳዖኮ ፔቴ ዛላፓ ዴንዲ ባጎ ዛሎኮ ጋፖ ሄላንዳኣና ዒንሢ ኮይሎይዳ ዓኣ ሜሌ ዴራ ካኣሽካ ፆኦዞ ኑ ካኣሽኮም› ዒንሢ ኮራ ጌዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ዒዚ ጋዓ ባኮ ዔኤዒፖቴ፤ ዋይዚፖቴ፤ ዬያም ሚጪንቲፖቴ፤ ዒዛ ማኣሪፖቴ፤ ዒዛኮ ሼምፖ ዓይሳኒያ ማሊፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","ማኣሙዋዖ ዒዛ ዎዎዹዋቴ፤ ሹጮና ዒዛ ቤርታዺ ኔ ዹዔ፤ ሜሌ ዓሳ ቢያ ሃሣ ማንጊ ዒዛ ዹይ ዎዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","ዓይሌ ማዒ ዒንሢ ናንጌ ጊብፄ ዓጮይዳፓ ኬሴ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢዳፓ ዒንሢ ሃኪሳኒ ዬይ ማሌሢሮ ሹቻ ዹይ ዒዛ ዎዎዹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ዬካፓ ዒስራዔኤሌ ዴራ ቢያ ዬያ ማዺንቴ ባኮ ዋይዚ ዒጊጫንዳኔ፤ ዬያሮ ዬያጉዴ ፑርታ ባኣዚ ላሚ ማዻንዳ ዓሲ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ካታሞንሢዳ ዒንሢ ናንጋ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ዒንሢ ዓሶ ባኣካፓ ፔቴ ፔቴ ፑርታ ዓሲ ዔቂ ዒንሢ ናንጋ ካታሞይዳ ዓኣ ዓሶ ዻቢሺ ‹ኑ ዴንዲ ሜሌ ፆኦሲ ካኣሽኮም› ጌዒ ባይሲንታ ባንሢ ዔኪ ዓኣዻያ ማዔም ዒንሢ ዋይዜቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ያዺ ጌይ ካኣሽኪንታ ባኣዚ ዒንሢ ዋይዜ ዎዶና ዬኖ ዛሎ ኮሺ ዖኦጪ ዔሩዋቴ፤ ዬይ ፑርቶ ባካ ዒንሢ ባኣካ ጎኔ ማዺንቴያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ዬኖ ካታሞይዳ ናንጋ ዴሮ ዔያቶኮ ቆልሞንታ ቢያ ዎዹዋቴ፤ ዬኖ ካታሜሎ ጋፒሲ ባባይዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","ዬኖ ካታሞይዳ ናንጋ ዓሶኮ ዓኣ ባኮ ቢያ ማንፂ ዔኪ ካታሞኮ ዓሳ ቡካ ጶኦካ ቡኩሱዋቴ፤ ዬካፓ ዬኖ ካታሜሎና ዒዞይዳ ዓኣ ባኮ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ዒንጊሢ ማሂ ታሚና ሚቹዋቴ፤ ላሚ ማዢንቱዋያ ናንጊና ዶዔ ካታማ ማዒ ዓዓቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","ባይዞንጎ ጌይንቴ ባኮይዳፓ ዓይጎ ባኣዚያ ዒንሢሮ ማሂ ዓይሲ ዔኪፖቴ፤ ዒንሢ ዬያይዲ ዔኩዋዖ ሃሼቴ ናንጊና ናንጋ ጎዳ ዒዛኮ ዼኤፖ ዒጊቻ ዻጎና ዒንሢዳ ዔቂፆ ሃሺ ዓቶም ጋዓንዳኔ፤ ዒንሢኮ ቤርታኣ ዓዶንሢም ዒ ጫኣቄ ጎይፆና ፓይዶዋ ዒንሢኮ ሚርጊሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","ሃኖ ታ ዒንሢም ኬኤዛ ዓይሢፆ ዒንሢ ካፒ፥ ዒዚ ዒንሢዳፓ ኮዓ ባኮ ቢያ ማዻያ ዒንሢ ማዔቴ ዬይ ጫኣቁማ ዒንሢም ማዺንቲ ኩማንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","ሙሴ ሃሣ ኬኤዛዖ፦ «ዒንሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ናይኬ፤ ዬያሮ ዓሲ ሃይቄም ዒንሢ ዬኤካ ዎዶና ዑፆ ዋኣጪንቲ ቶኦኮዋ ዒንሢኮ ጉኡሊንቲፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ዱማዼ ዴሬኬ፤ ሳዖይዳ ናንጋ፥ ሃንጎ ዓሶይዳፓ ቢያ ዒዛም ዱማዼ ዴሬ ዒንሢ ማዓንዳጉዲ ፔኤም ዒንሢ ዒ ዶኦሬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","«ቄፄ ማዔ ዓይጎ ባኣዚኮዋ ዓሽኮ ሙይፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","ዒንሢ ዓሽኮ ሙዓንዳጉዲ ኮይሳ ባካ፦ ባይ፥ ማራይ፥ ዋኣሪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ሮኦቶ፥ ጌንዓ፥ ሞይሌ፥ ሚርዳ፥ ጋፒሪንታ ዎሾንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","ቶኮ ሹቁላ ላምዖ ፓቂንቴያ፤ ሃሣ ዓሌ ዻዓ ባኮ ሙዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ጋዓንቴ ቶኮ ሹቁላ ላምዖ ፓቂንቲባኣያ፥ ጊንሣ ዓሌ ዻዑዋ ባኣዚ ሙይፖቴ፤ ዬያሮ ጋኣሎንታ ዋሪሌንታ ሾኦኖንታ ዬያጉዴ ባኮ ሙይፖቴ፤ ዬያጉዴ ባካ ዓሌ ዻዓያ ማዔታቴያ ቶኮ ሹቁላ ላምዖ ፓቂንቲባኣያ ማዔሢሮ ዒንሢኮ ቄፄኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ጉዱንሢያ ሙይፖቴ፤ ዔያቶኮ ቶኮ ሹቁላ ላምዖ ፓቂንቴያ ማዔቴያ ዓሌ ዻዑዋያታሢሮ ቄፄ ማዓኔ፤ ዬያጉዴ ባኮ ሙይፃ ዓታዛ ሃይቄም ዑፆ ዑፆ ካኣሚፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","«ሞላሢ ዜርፆይዳፓ ጋኣሲና ዒልዖይዳ ቁኡሪ ማላ ባኣዚ ዓኣ ባኮ ሙዓኒ ዒንሢ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","ጋዓንቴ ዋኣሢዳ ናንጋያ ጋኣሲና ቁኡሪ ማላ ዒልዒባኣ ባካ ቢያ ሙይንቱዋሴ፤ ዬያጉዴ ባካ ዒንሢኮ ቄፄ ማዓንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","«ካፖይዳፓኣ ዓሽኪ ሙይንታኒ ኮይሳዞንሢ ሙዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","18","ዓሽኪ ሙይንታኒ ኮይሱዋ ካፓ ሃካፓ ሊካ ፓይዲንታዞንሢኬ፤ ዬያታ፦ ዚኢጊላ፥ ሃምፑራ፥ ኮኦኬ፥ ኪላንቄ፥ ዱማ ዱማ ዜኤጌ፥ ዱማ ዱማ ቁራኬ፥ ቱኡቴ፥ ሃንጋሃንጋ፥ ጫሬ ካፒ፥ ዱማ ዱማ ጋርማ ዜርሢ፥ ኩኩቴ፥ ሶኦሦ ሃምፑራ፥ ሙኡታሌ፥ ባዚ ካፒ፥ ቶኮ ኬኤላ ዎላ ካኣሜ ባዞ ካፓ፥ ጫውራ፥ ቦኦካ፥ ቆልሞና ሃንታ ቦኦሬ ካፓ፥ ማኣሎንታ ፓቃቴንታኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","«ጋኣሲና ባራና ዻኮ ዻኮ ባካ ቢያ ዒንሢኮ ቄፄኬ፤ ዬያጉዴ ባካ ሙይንቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","ጋዓንቴ ዔያቶ ባኣካፓ ዱማና ሙይንታኒ ኮይሳ ባኮንሢ ዒንሢ ሙዓኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","«ሃይቄ ባኣዚኮ ዓሽኮ ሙይፖቴ፤ ዒንሢ ባኣካ ናንጋ፥ ሜሌ ዓጮ ዓሳ ዬያ ሙዓንዳጉዲ ዒንጉዋቴ፤ ሃንጎ ሜሌ ዓጮ ዓሶም ዓሽኮ ዒንሢ ሻንቻኒ ዳንዳዓኔ፤ ዒንሢ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዱማዼ ዴሬኬ። ዋናናይ ዒንዶ ዲኢቆና ካሢፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","«ሌዓ ሌዓ ጎሽኪ ዒንሢ ዴንቃ ሃኣኮ ቢያሢዳፓ ታጶይዳፓ ፔቴ ኩቺ ዔኪ ዔኪ ዱማሲ ጌሡዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዶኦሬ ቤዞ ዔኪ ዓኣዺ ናንጊና ናንጋ ጎዳ ቤርታ ቡኪንቲ ዒንሢኮ ሃኣካፓ፥ ዎይኖ ዑዦና ሪሚቶ ዛይቶናይዳፓ ታጳፓ ፔቴ ኩቺ ዔኪ ዒንሢ ዱማሴሢንታ ዒንሢ ዔኪ ሙኬ፥ ባኣቶና ዋኣሮናኮ ቤርታ ሾይንቴ ቆልሞ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጴዻ ቤዛ ሙዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዓንጄያ ማዔም ሃሣ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዒ ዶኦሬ ቤዛ ዒንሢኮ ሃኬ ማዒ ዒንሢ ዱማሲ ኬሴ ባኮ ዔኪ ዒኢካ ሄሊሳኒ ዳንዳዒንቲባኣቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ታጳፓ ፔቴ ኩቺ ዒንሢ ዱማሲ ኬሴ ባኮ ሚኢሼም ሻንቺ ሚኢሾ ዔኪ ናንጊና ናንጋ ጎዳ ካኣሽኪንታ ቤዞ ዴንዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጴዻ ቤዛ ቡኪንቲ ዒንሢ ኮዔ ጎይፆ ባይ፥ ማራይ፥ ዎይኔ ዑሺንታ ሜሌ ካፄ ዑሺያ ሻንቂ ዒኢካ ሙይ ዑሽኩዋቴ፤ ዬያይዲ ዒንሢንታ ዒንሢኮ ማኣሮ ዓሶንታ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጴዻ ቤዛ ዎዛዹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","«ዒንሢ ዬያይዳ ዎዶና ዒንሢ ባኣካ ናንጋ፥ ሌዊ ዓሶ ዋሊፖቴ፤ ዓይጎሮ ጌዔቴ ዒንሢና ዎላ ዔያታ ጊሽቲ ዔኬ ዓጪ ባኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","ሃይሣሳ ሃይሣሳ ሌዖኮ ጋፒንፃ ዒንሢ ጎሽኬ ሃኣኮይዳፓ ቢያ ታጶይዳፓ ፔቴ ኩቺ ኬሲ ኬሲ ዒንሢኮ ካታማ ካታማ ቡኩሱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ዬያ ሃኣኮ ዒንሢ ባኣካ ናንጋያ፥ ዒንሢና ዎላ ዓጮ ጊሽቲ ዔኪባኣ ሌዊ ዓሶንታ ሜሌ ዓጫፓ ቤሲ ባይቂ ሙኬ ዓሶንታ ዜኤሮ ናኣቶንታ ዜኤሮይዶንሢንታ ሙዖንጎ፤ ዬያ ዒንሢ ማዼቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ማዻ ባኮና ቢያ ዒንሢ ዓንጃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","ሙሴ ኬኤዛዖ፦ «ዒንሢ ሚኢሼ ታልዔ ዓሲም ቢያ ላንካሳ ላንካሳ ሌዖኮ ጋፒንፆይዳ ጋሎ ሃሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","ዒንሢ ማዻንዳ ጎይፃ ሃካፓ ሊካ ኬኤዚንታ ጎይፆኬ፤ ዒንሢ ፃጲ ማዔ፥ ዒስራዔኤሌ ዓሲም ሚኢሼ ታልዔ ዓሲ ጋሎ ሃሻንዳያ ኮይሳኔ፤ ዬያ ጋሎ ሃሺፆ ሌዖ ጌሤሢ ናንጊና ናንጋ ጎዳ ፔኤሮታሢሮ ዒንሢ ፃጲ ማዔ፥ ዒስራዔኤሌ ዓሲ ታልዔ ሚኢሾ ማሂ ዔካኒ ጌይፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","ሜሌ ዓጪ ዓሲታንቴ ዒንሢ ታልዔ ሚኢሾ ጋዓንቴ ዖኦጪ ዔካኒ ዳንዳዓኔ፤ ዒንሢ ፃጲ ማዔ፥ ዒስራዔኤሌ ዓሲም ዒንሢ ታልዔ ሚኢሼ ዖኦጪ ዔኪፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","«ታኣኒ ሃኖ ዒንሢም ዓይሣ ዓይሢፆ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዓይሢንቲ ዒንሢ ማዻያ ማዔቴ ናንጊና ናንጋ ጎዳ ዒንሢ ሚርጌና ዓንጃንዳሢሮ ዒዚ ዒንሢም ዒንሢሮ ማሂ ዒንጋ ዓጮይዳ ዒንሢ ባኣካ ማንቆ ዓሲ ባኣያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","ናንጊና ናንጋ ጎዳ ዒንሢም ጫኣቄ ጎይፆና ዒንሢ ዓንጃንዳኔ፤ ዒንሢ ሜሌ ሚርጌ ዴሬም ታልዓንዳኔ፤ ጋዓንቴ ዔያቶ ፃጳፓ ማዔ፥ ዓይጎ ዓሲፓኣ ዒንሢ ታልዓዓኬ፤ ዒንሢ ሜሌ ሚርጌ ዴሮኮ ዑፃ ማዒ ዎይሣያ ማዓንዳኔ፤ ዒንሢኮ ዑፃ ማዓንዳ ዓይጎ ዓሲያ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ሳዓ ዒንሢ ናንጋ ካታሞይዳ ቢያ ፔቴ ዒስራዔኤሌ ዓሲ ሜታዻያ ማዒ ጴዼቴ ዬይ ዒንሢኮ ዒጊኒ ማዔሢሮ ዛጊ ዚቲ ጌይፖቴ፤ ሚኢሼ ዒዛም ዒንጋኒ ዱኡዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","ጋዓንቴ ኩጮ ዒንሢኮ ቡሊ ኮይሳ ባኮ ቢያ ዒዛም ታልዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","‹ጋላ ሃሺንታ ላንካሳ ሌዓ ሄላኒ ዑኬኔ› ጌዒ ሜታዼ፥ ዒንሢኮ ፃጳሢ ታልዖ ላኣጊፖቴ፤ ዬያጉዴ ፑርታ ማሊሢ ዒንሢኮ ዒና ጌሎፓ፤ ዒንሢ ታልዓዓ ጌዔቴ ዬይ ሜታዼ፥ ዒንሢኮ ዒጊናሢ ናንጊና ናንጋ ጎዳ ባንሢ ዒላታንዳኔ፤ ዬያሮ ዬይ ዒንሢኮ ዻቢንቲ ማዒ ዓርቂንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","ጋዓንቴ ኮሹሞና ዚቲ ጋዓዖ ዒዒንጉዋቴ፤ ዒንጋዖ ‹ዓይጋ ታ ዒንጌይ?› ጌዒ ዒኖና ማሊፖቴ፤ ያዺ ጉውዋዖ ዒንሢ ዒንጌያ ማዔቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ማዻ ማዾና ቢያ ዓንጃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","ዎይቴቴያ ዒንሢ ናንጋ ሳዖይዳ ሜታዻያ ማዔ፥ ማንቆ ዓሲ ባይቂንዱዋኣሢሮ ዒንሢ ዓጫ ናንጋ ሜታዼ ዓሶና ማንቆ ማዔያ ዓሶም ኩጮ ቡሊ ዒንሢ ዒንጋንዳጉዲ ታ ዓይሣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","«ዓቲንቄታቴያ ላኣሊ፥ ዒስራዔኤሌ ፃጳፓ ማዔ ዓሲ ፔና ዓይሌ ማሂ ዒንሢ ፔቴ ፔቴሢም ሻንቼያ ማዔቴ ላሆ ሌዔ ዬይ ዓሢ ማዼስካፓ ላንካሳ ሌዖና ዓይላታፓ ጋሌ ባኣያ ዒዛ ኬኬሱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","ዓይላታፓ ዒንሢ ዒዛ ኬሳ ዎዶና ኩቺ ጉሪ ኬሲ ዳኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንጌ ዓንጆይዳፓ ጌይፃ፦ ማራቶይዳፓ፥ ሃኣኮይዳፓ፥ ዎይኖ ዑዦይዳፓ ኮሹሞና ዒዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","ዒንሢ ሃያኮ ቤርታ ጊብፄ ዓጮይዳ ካራሚ ማዒ ናንጌሢንታ ናንጊና ናንጋ ጎዳ ዬካፓ ዒንሢ ጋሌባኣያ ኬሴሢ ማሊ ጶቂሡዋቴ፤ ታኣኒ ሃኖ ዒንሢ ሃያ ዓይሣሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","«ጋዓንቴ ዓይሌ ማዒ ማዻሢ ዒንሢንታ ዒንሢኮ ማኣሮ ዓሶንታ ናሽኪ፤ ሃሣ ዒንሢና ዎላ ጊኢጊ ናንጋሢሮ ዴንዳኒ ኮዑዋያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ዒንሢኮ ማኣሮ ካራ ኬሲጋፓ ዋዮ ዬያኮ ዎሳፒቼና ዑሩዋቴ፤ ዬካፓ ዒ ሃይቃንዳያ ሄላንዳኣና ዒኢካ ዴዒ ዒንሢም ማዻያ ማዓንዳኔ፤ ዓይሌ ማዒ ማዻ ላኣሊታቴያ ዒማይዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","ዬያጉዲ ማዻ ዓሲ ኬሲ ዒንሢ ዳካ ዎዶና ዬይ ዓሢ ሚኢሼ ጪጊ ዒንሢ ማዺሻ ፔቴ ዓሲ ላሆ ሌዔ ማዻስካፓ ጳንጬ ማዾ ዒንሢም ማዼያታሢሮ ዒኔና ማሊ ዖዪፖቴ፤ ኬሲ ዳዳኩዋቴ፤ ናንጊና ናንጋ ጎዳ ማዻ ማዾና ቢያ ዒንሢ ዓንጃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","«ዒንሢኮ ባኣቶዋ ማዖም ማራታ ቤርታ ሾዔ ጌማይ ማዔቴያ ዓዴ ማዔያ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዱማዼያ ማሁዋቴ፤ ቤርታ ማዒ ሾይንቴ ጌማይና ዓይጎ ባኣዚያ ማዺፖቴ፤ ዬያጉዲ ማራቶኮዋ ቤርታ ሾይንቴ ዓዶኮ ዑፃፓ ጋፓኖ ታይዚ ዔኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ናንጊና ናንጋ ጎዳ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ፔኤም ዶኦሬ ቤዞይዳ ሌዓ ሌዓ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጴዻ ቤዛ ዒንሢ ማኣሮ ዓሶና ዎላ ዬያቶ ሹኪ ሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","ጋዓንቴ ዬያ ቆልሞኮ ቦሂሳ ባኣዚ ዓኣያ ማዔቴ ጌይፃ፦ ዎቦ፥ ዓኣፒ ባይቄያ፤ ሃሣ ዬያፓ ዑሣ ዓኣዼ ባኣዚ ዓኣያ ማዔቴ ዬያጉዴ ቆልሞ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ዬያጉዴ ቆልሞ ዒንሢኮ ማኣራ ዒንሢ ሙዓኒ ዳንዳዓኔ፤ ዳምቦ ጎይፆና ጌኤሽኬያ፥ ሃሣ ጌኤሽኪባኣያ ማዔቴያ ሮኦቶንታ ጋፒሪንታ ዒንሢ ሙዓሢጉዲ ቢያሢ ሙሙዑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","ጋዓንቴ ሱጉፆ ዔያቶኮ ሙኡዚ ማሂ ሙይፖቴ፤ ዋኣሢጉዲ ሳዓ ላላኣሉዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","ሙሴ ኬኤዛዖ፦ «ፆኦሲ ጊብፄ ዓጮ ዓይላቶይዳፓ ዒንሢ ኬሴሢ ዓቢቤ ዓጊኖኮ ፔቴ ኬሊ ዋንቴና ማዔሢሮ ዬኖ ዓጊኖና ዑሣ ዓኣዺፆ ቦንቾ ሜንሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛ ሱንፃ ካኣሽኪንታዳጉዲ ዶኦሬ ቤዞ ዓኣዺ ዒኢካ ዒዛ ቦንቻኒ ዒንሢኮ ማራቶይዳፓ ማዔቴያ ባኣቶይዳፓ ዶኦሪ ፔቴ ፔቴ ሹኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","ዬያ ካዋሢ ዒንሢ ሙዓኣና ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ ሙዑዋቴ፤ ጊብፄ ዓጫፓ ሩኡሪ ዒንሢ ኬስካዖ ማዼ ጎይፆ ላንካይ ኬሊ ጉቤ ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳ ሙዑዋቴ፤ ዬይ ሜቶ ካሣ ጌይንታንዳኔ፤ ዬያሮ ዒንሢ ናንጋ ዎዶ ቢያይዳ ሚርጌ ሜቶ ዒንሢ ዔኬ፥ ጊብፄ ዓጫፓ ኬስኬ ኬሎ ዬያና ጶቂሣንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","ዴንዲ ላንካይ ኬሊ ሄላንዳኣና ዒንሢ ዓጮይዳ ዓይጎ ዓሲ ማርካኣ ማዖም ሙኑቃ ፃኣዛ ባኣያ ማዖንጎ፤ ቤርታሳ ኬሎኮ ዋንቶ ዒንሢ ፆኦሲም ጌይ ሹኬ ቆልሞኮ ዓሽካ ቢያ ዒማ ዋንቶ ሙይንቲ ጋጋፓንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","«ዑሣ ዓኣዺፆ ቦንቾሮ ጌዒ ሹኮ ቆልሞ ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጌ ዓጮ ካታሞ ቢያሢዳ ዒንሢ ሹካንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","ጋዓንቴ ሹኪንታኒ ኮይሳሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዶኦሬ ቤዞማካ ሌሊኬ። ዬይያ፦ ዓባ ጌላኣና ጊብፄ ዓጫፓ ዒንሢ ኬስኬ ኬሎና ኬስኬ ዎዶማ ካፒ ማዻንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","ዬያ ዓሽኮ ካሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዶኦሬ ቤዛ ሙዒጋፓ ዚሮ ጉቴ ዒንሢ ማኣሪ ማኣሪ ማዒ ዴንዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","ዬማፓ ዴንዲ ላሆ ኬሊ ሄላንዳኣና ላኣዳ ሙዑዋቴ፤ ላንካሳ ኬሎና ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዚጊ ካኣሽካኒ ቡኪንቱዋቴ፤ ዬኖ ኬሎ ማዾ ማዺፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","«ማኣሎ ቡሪፆ ዒንሢ ዓርቄማፓ ቃልሾ ኬሊ ኬሊ ላንካይ ፓይዱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ዬካፓ፥ ናንጊና ናንጋ ጎዳ ዒንሢ ዓንጄ ጎይፆጉዴያ ዒንሢ ሼኔና ዒንሢ ዒንጋ ዒንጊሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንጊ ማኣሎ ቡሪፆና ቦንቾ ቦንቾ ኬሊ ጌሢ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","ዒንሢኮ ዓቲንቆ ናኣቶንታ ዉዱሮ ናኣቶንታ ዒንሢም ማዾ ማዻ ዓቲንቆንታ ላኣሎንታ ዒንሢኮ ካታሞይዳ ናንጋ ሌዊ ዓሶንታ ሜሌ ዓጮይዳፓ ሙኪ ናንጋ ዓሶንታ ዜኤሮ ናኣቶና ዜኤሮ ዒንዶንሢንታ ዎላ ዒዞ ኬሎ ቡኪ፥ ናንጊና ናንጋ ጎዳ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዶኦሬ ቤዞይዳ ዎዛዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","ዬንሢ ዳምቦንሢ ዛጊ ካፑዋቴ፤ ሃሣ ዒንሢ ጊብፄ ዓጫ ዓይሌ ማዒ ናንጌሢያ ጶቂሡዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","«ዒንሢ ማኣሎ ቡሪ፥ ሃሣ ዎይኖዋ ማንፂ ጩኡጲ ጋፒሴስካፓ ላንካይ ኬሊ ሄላንዳኣና ዉልሾ ዴማ ቦንቾ ኬሊ ጌሢ ቦንቹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","ዬያ ቦንቾ ዒንሢኮ ዓቲንቆ ናኣታ፥ ዉዱሮ ናኣታ፥ ማዾ ማዻ ዓቲንቆንታ ላኣሎንታ፥ ዒንሢኮ ካታሞይዳ ናንጋ ሌዊ ዓሶንታ፥ ሜሌ ዓጮይዳፓ ሙኪ ናንጋ ዓሶንታ፥ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢታ ዎላ ቡኪ ዎዛዺ ቦንቹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዶኦሬ ቤዞይዳ ላንካይ ኬሊ ሄላንዳኣና ዴዒ ዒዛ ቦንቹዋቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ጎሽኬ ሃኣኮና ዒንሢ ማዼ ባኮና ቢያ ዓንጃንዳሢሮ ዬኖ ቦንቾ ዎዛዺ ቦንቹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","«ዒንሢኮ ዓቲንቃ ቢያ ሌዖይዳ ሃይሢ ማይንቲ ዑሣ ዓኣዺፆ ቦንቾንታ፥ ማኣሎ ቡሪፆ ቦንቾንታ፥ ዉልሾ ዴማ ቦንቺንታ ቦንቾ ቦንቻኒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዶኦሬ ቤዞይዳ ቡኪንቶንጎ፤ ቦንቾሮ ዔያታ ሙካ ዎዶና ኩቺ ጉሪ ሙኮፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","ዔያታ ዒንጋኒ ዔኪ ሙካንዳ ባካ ናንጊና ናንጋ ጎዳ ዔያቶም ዒንጌ ጎይፆ፤ ሃሣ ዓንጄ ጎይፆጉዴያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ፔቴ ፔቴ ፃጶም ዒንጋ ዓጮኮ ካታሞይዳ ካታሞይዳ ዎጌ ዎጋንዳ ዓሲና ዎይሣንዳ ሱኡጌና ዶኦሩዋቴ፤ ዬንሢ ዓሶንሢ ዓሲ ዱማሲ ዛጉዋዖ ዎጋንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","ዎጎ ዎጊፆ ዎቢሲፖቴ፤ ዓሲ ዱማሲ ዛጊ ዎጊፖቴ፤ ዓሲ ጌሺፖቴ፤ ዴሚና ዔኮ ሚኢሼ ዔኪፖቴ፤ ዬያጉዴ ሚኢሻ ዔሮ ዓሶኮ ዓኣፖ ባይዚ ዎቦ ዎጌ ዎጊሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጋ ዓጮ ዻካሊ ሼምፔና ናንጋኒ ፔዜ ዎጌ ሌሊ ዎጉዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ቤዞ ዒንሢ ኮሻሢኮ ኮይላ ዓሼራ ጌይንታ ፆኦዜሎኮ ማላታ ማዓ ሚሢ ዾቂፖቴ፤ ሃሣ ቱኪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒፃያ ማዔ ካኣሽኮ ዻኣቦዋ ዒኢካ ዻኣቢፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","ሙሴ ኬኤዛዖ፦ «ዒንሢኮ ባኣቶይዳፓ ማዔቴያ ማራቶይዳፓ ፔቴ ዔኤቢ ቦሂሳ ባኣዚ ዓኣ ቆልሞ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ዒንጊሢ ማሂ ሺኢሺፖቴ፤ ዬያ ናንጊና ናንጋ ጎዳ ዒፃያኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","3","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ካታሞኮ ፔቴ ካታማይዳ ዓኣ ዓቲንቄ ማዔቴያ ላኣሊ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርቶይዳ ፑርታ ባኣዚ ማዺ ዒዛና ዎላ ጫኣቄ ጫኣቁሞ ሃሻያ ማዔቴ፤ ጌይፃ፦ ሜሌ ካኣሽኮ ባኣዚም፥ ዓቢንታ ዓጊኒንታ ዦኦጌንታም ዚጊ ካኣሽኬያ ማዔቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","ዬያጉዴ ባኣዚ ዒንሢ ዋይዜ ዎዶና ኮሺ ዛጊ ዖኦጪ ዔሩዋቴ፤ ዬያጉዴ ፑርቶ ባካ ዒስራዔኤሌ ዓሶ ባኣካ ማዺንቴሢ ጎኔ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","ዬያ ዓሢታቴያ ዬኖ ዓሴሎ ካታማፓ ዙሎ ኬሲ ሹቻ ዹይ ዎዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ጋዓንቴ ዬያይዲ ዎዺንታንዳሢኮ ቤርታ ላምዖ፥ ሃንጎ ሃይሦ ዓሲ ማርካዻንዳያ ኮይሳኔ፤ ማርካ ፔቴ ሌሊ ማዔቴ ዬኖጉዴ ዓሲ ዎዺንቶፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","ዎዺንታ ዎዶና ማርኮንሢ ቤርታዺ ሹጮና ዹዖንጎ፤ ዬካፓ ዴራ ዹዖንጎ፤ ዬያይዲ ዬያጉዴ ፑርቶ ባኮ ዒንሢ ባኣካፓ ዒንሢ ባይዛኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","«ጳርቂያ ማዖም ጫርጊ ዓሲኮ ሱጉሢ ላኣሊሢ ዛላ፥ ፔቴይ ባጋሢኮ ዔኤቢ ፑርቲሴ ዛላና ሞኦቲንቲ፤ ሃሣ ፔቴ ዓሲ ዓሲ ዎዺ፤ ዬያጉዴ ባኣዚና ዓሳ ዎሊ ሞኦታ ዎዶና ዎጋኒ ሜታሳያ ማዔቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዚ ካኣሽኪንታንዳጉዲ ዶኦሬ ቤዞ ዴንዱዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","ዬያ ጌኤዞ ሌዊ ፃጳፓ ቄኤሶ ማዔዞንሢና ዎጎ ዎጋ ሱኡጋሢናም ሺኢሹዋቴ፤ ዬያ ዔያታ ጌስቲ ኩንሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","ዔያታ ዒንሢም ፆኦሲ ዶኦሬ ቤዞይዳ ጌስቲ ኩንሣዖ ዒንሢ ማዾንጎ ጌይ ዓይሤ ባኮ ማዺ ኩንሡዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","ዔያታ ዒንሢም ኬኤዛ ዳምቦ ጎይፆ ቢያ ባኮ ማዹዋቴ፤ ፔቴታዖ ዬያ ማዺፆ ሃሺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","ሱኡጋሢም ማዔቴያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ማዻ ቄኤሳሢም ዓይሢንቲፆ ዒፂ ጌኤታዻሢ ሃይቃንዳያ ኮይሳኔ፤ ዬያይዲ ዬያጉዴ ፑርቶ ባኮ ቢያ ዒስራዔኤሌ ዓሶ ባኣካፓ ባይዙዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","ዬካፓ ዓሲ ቢያ ዬያ ዋይዛዖ ዒጊጫንዳኔ፤ ዬያጉዴ ፑርታ ባኣዚ ማዻኒ ጫርቃንዳ ዓሲ ባኣያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ዓጮ ጌሊ፥ ሳዖዋ ዻካሊ፥ ጊኢጊ ዒንሢ ናንጌስካፓ ዒንሢ ኮይላ ዓኣ ዴሮጉዲ ካኣቲ ካኣታሣኒ ዒንሢ ኮዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዶኦሬ ዓሲ ዒንሢ ካኣታሳንዳያ ኮይሳኔ፤ ዒንሢ ዑፃ ዒንሢ ካኣታሳ ዓሢ ዒንሢ ባኣካፓ ዒንሢ ዓሲ ማዖንጎ፤ ሜሌ ዓጪ ዓሲ ዒንሢ ዑፃ ዒንሢ ካኣታሳንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","ዬያ ካኣታሢኮ ዖላ ዓሶም ሚርጌ ፓራ ዓኣያ ማዓኒ ኮይሱዋሴ፤ ፓራሢ ሻንቃኒ ጊብፄ ዓጮ ዓሲ ዳካኒያ ዒዛም ኮይሱዋሴ፤ ዓይጎሮ ጌዔቴ ናንጊና ናንጋ ጎዳ ፔኤኮ ዴራ ጊብፄ ዓጮ ማዒ ዴንዱዋጉዲ ላኣጌሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","ሃሣ ዬይ ካኣታሢ ሚርጌ ላኣሊ ዔካንዳያኣ ኮይሱዋሴ፤ ያዺ ማዔቴ ፆኦሲ ዒ ካኣሽኩዋጉዲ ዒዛ ባሻንዳኔ፤ ዬያጉዲ ጊንሣ ዎርቄና ቢራና ሚርጊሻኒ ዒ ኮዓያ ማዖፓ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","ዬያይዳፓ ዒዚ ካኣታዻ ዎዶና ሌዊ ዓሶ ማዔ፥ ቄኤሳ ካፒ ናንጋ ፆኦሲኮ ዎጋ ፃኣፒንቴ ማፃኣፖይዳፓ ፃኣፒ ዔኮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","ዬያ ማፃኣፖ ፔ ኮይላ ጌሢ ዒ ናንጋ ዎዶ ቢያይዳ ናባቦንጎ፤ ዬያ ዒ ማዼቴ ናንጊና ናንጋ ጎዳ ቦንቺሢና ዬኖ ማፃኣፖይዳኣ ፃኣፒንቴ ዎጎንታ ዳምቦንታ ዛጊ ጉሙርቂንቲ ማዺ ኩንሥሢ ዒ ዔራንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","ዬይ ፔና ዒ ፔ ፃጶ ዒስራዔኤሌ ዓሶይዳፓ ‹ታ ባሼኬ› ጌዒ ዖቶርቁዋጉዲ፤ ሃሣ ናንጊና ናንጋ ጎዳ ዓይሤ ዓይሢፆዋ ዒዚ ሃሹዋጉዲ ዒዛ ላኣጋያ ማዓንዳኔ፤ ዬያ ዒ ማዼቴ ሚርጌ ዎዴ ዒ ካኣታዺ ዴዓንዳኔ፤ ዒዛኮ ናኣታኣ ዒስራዔኤሌ ዓሶ ዑፆይዳ ሚርጌ ዎዴ ካኣታዺ ናንጋዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","ሙሴ ኬኤዛዖ፦ «ቄኤሴ ማዒ ማዻንዳጉዲ ዶኦሪንቴ ሌዊ ዓሶንታ ሌዊ ዓሶ ፃጳ ቢያሢ ሃንጎ ዒስራዔኤሌ ዓሶና ዎላ ጊሽቲ ዔካ ሳዓ ባኣሴ፤ ዬያ ዛሎ ናንጊና ናንጋ ጎዳም ዒንጋኒ ዔኪ ሙኮ ዒንጊፆና ሜሌ ዒንጎ ባኮ ሙይ ዔያታ ናንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","ዔያቶ ፃጶ ዒስራዔኤሌ ዓሶ ባኣካ ዔያቶሮ ማዔ ዓጪ ዔያቶኮ ባኣያ ማዓንዳኔ፤ ናንጊና ናንጋ ጎዳ ዔያቶም ጫኣቄ ጎይፆና ዔያታ ፔኤም ማዓ ባኮ ዴንቃሢ ቄኤሴ ማዒ ናንጊና ናንጋ ጎዳም ማዻ ማዾፓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","«ባይ ማዔቴያ ማራይ ናንጊና ናንጋ ጎዳም ሹኪንታ ዎዶና ቄኤሳ ላባዎንታ ባንጋሎንታ ጋንጮንታ ዔካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","ሃኣኮንታ ዎይኖ ዑዦንታ ሪሚቶ ዛይታ ማራቶኮ ታይዞና ጋፓኖዋ ዓይሱዋዖ ቤርቶ ቄኤሶም ዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","ናኣናና ቄኤሴ ማዒ ማዻንዳጉዲ ናንጊና ናንጋ ጎዳ ዒንሢ ፃጶ ባኣካፓ ሌዊ ዓሶ ዶኦሬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","«ፔቴ ሌዊ ዓሲ ናንጋ ዎኖ ዛላፓኣ ማዖም ዒስራዔኤሌ ዓሶ ካታማፓ ናንጊና ናንጋ ጎዳ ዒዛ ዓሳ ካኣሽካንዳጉዲ ዶኦሬ ቤዞ ሙካኒ ሚርጌና ናሽኪ ዔቄያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","ዒኢካ ማዻ ዒዛ ፃጳ ሌዊ ዓሳ ማዻሢጉዲ ናንጊና ናንጋ ጎዳ ማዔ ፔ ፆኦዛሢም ቄኤሴ ማዒ ማዾንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","ሜሌ ቄኤሳ ዔካ ሙዖይዳፓ ዒዛ ሄላማ ዒዚ ዔካንዳኔ፤ ሃሣ ዒዛኮ ማኣሮ ዓሳ ዔኤቢ ሻንቼያይዳፓ ዳኬቴያ ዒ ዔካኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ዓጮ ዒንሢ ጌላ ዎዶና ዒዞ ዓጮይዳ ናንጋ ዓሳ ማዻ ሻኣካ ማዾ ማዺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","ዒንሢ ባኣኮይዳ ፆኦሲም ጌዒ ፔኤኮ ዓቲንቆ ናዖታቴያ ዉዱሮ ናዖ ሹኪ ሚቺ ዒንጎ ቤዞይዳ ዒንጋ ዓሲ ባኣያ ናንጎንጎ፤ ዬያጉዲ ሃሣ ማርሻ ማርሻ ዓሲ፥ ጫኣቃ ዓሲ፥ ዦዋቶ ዦኦቃ ዓሲንታ ሩቁንቲ ዋርቃ ዓሲያ ባኣያ ናንጎም። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ሃሣ ዓማቶ ማዒ ማዻ ዓሲ፥ ፑርታ ዓያናና ጌስታ ዓሲ፥ ጎርሞይቴ ማዓ ዓሲያ ዒንሢ ባኣካ ባኣያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","ዬያ ማዻ ዓሲ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒናፓ ዒፃያኬ፤ ዒንሢ ቤርቲም ዴንዴ ዎዶና ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሜሌ ዴሮ ዒንሢ ቤርታፓ ኬሲ ኬሲ ዳውሲ ዳካሢ ዬያጉዴ ዒኢቴ ባኣዚ ዔያታ ማዻሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","ዒንሢ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ጉቤና ጉሙርቂንታያ ማዓኒ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","ዬካፓ ሃሣ ሙሴ፦ «ዒንሢ ዴንዲ ዓጮ ዔያቶ ሃሺሲ ዻካላንዳ ዓጮይዳ ዓኣ ዴራ ማርሻ ማርሻያና ዦዋቶ ናሽካያኬ፤ ዒንሢ ጋዓንቴ ዬያ ማዻንዳጉዲ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ኮዑዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","ናንጊና ናንጋ ጎዳ ዒንሢ ፃጶ ባኣካፓ ታጉዴያ ፆኦሲ ማሊሢ ኬኤዛያ ዒንሢም ዶኦሪ ኬሳንዳኔ፤ ዒዚ ጋዓ ባኮ ቢያ ዋይዚ ዓይሢንታያ ማዑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","«ሲና ዹኮ ኮይላ ዒንሢ ቡኪንቴያና ‹ኑ ሃይቃንዳኔ› ጌዒ ዒጊጪ፥ ናንጊና ናንጋ ጎዳ ዒንሢም ላሚ ኬኤዙዋጉዲ፤ ሃሣ ዒዛኮ ፔጋዺ ጴዺፆ ዔርዛ ዒጊቻ ታማ ‹ላሚ ጴዾፓ› ጌይ ዒንሢ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","ዬያሮ፥ ናንጊና ናንጋ ጎዳ ታኣም ‹ዔያታ ዖኦጬሢ ፒዜኬ›፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","ኔ ጉዴያ፥ ሜሌ ታ ማሊሢ ኬኤዛ ዓሲ ዔያቶ ፃጶ ባኣካፓ ታ ዔያቶም ዔቂሳንዳኔ፤ ዒዚ ኬኤዛንዳ ባኮ ዒዛም ታ ኬኤዛንዳኔ፤ ታኣኒ ዒዛ ዓይሣ ባኮ ቢያ ዒዚ ዴሮም ኬኤዛንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","ታ ሱንፆና ዬያ ኬኤዛ፥ ታ ማሊፆ ኬኤዛሢ ጋዓ ባኮ ዋይዙዋ ዓሲ ቢያይዳ ሜቶ ታ ዓጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","ጋዓንቴ ታኣኒ ዓይሢባኣ ዓይጎ ባኣዚያ ታ ሱንፆና ጫርቂ ኬኤዛ ዓሢ፤ ዬያጉዲ ሃሣ ሜሌ ፆኦዞ ሱንሢና ሎንሦ ኬኤዛ ዓሲ ቢያ ዎዺንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","« ‹ፔቴ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ኬኤዛሢ ጎዳይዳፓ ማዒባኣያ ማዔቴ ዓይጎና ኑ ዱማሲ ዔራንዳይ› ዒንሢ ጌዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","ፔቴ ዓሲ ፆኦሲ ሱንሢና ሎንሦ ኬኤዜንቴ ዬይ ዒ ጌዔ ባካ ኩሚባኣያ ማዔቴ ዬይ ዓሢ ፔጊዳፓ ዔኪ ኬኤዜያፓዓቴም ናንጊና ናንጋ ጎዳ ኬኤዜምቱዋኣሢሮ ዒንሢ ዬያ ዒጊጫንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","ሙሴ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጋ ሳዖይዳ ናንጋ ሜሌ ዓሶ ዒዚ ባይዜም ዔያቶኮ ካታሞና ማኣሮና ዻካሊ ዒኢካ ዒንሢ ናንጎ ዓርቄ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","3","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንጌ ዓጬሎ ሃይሦ ቤሲ ፓቂ ፔቴ ፔቴ ቤዞይዳ ፔቴ ፔቴ ካታማ ዱማሱዋቴ፤ ዓሲ ዎዼ ዓሲ ፑኒንቲ ዴንዳንዳጉዲ ዬኖ ካታሞ ዔኪ ዓኣዻ ጎይሢ ጌሡዋቴ፤ ዬካፓ ዓሲ ዎዼ ዓሲ ፔ ሼምፓሢ ዓይሳኒ ዬንሢ ካታሞንሢፓ ፔቴማ ዓኣሺንቲ ዴንዶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","ፔቴ ዓሲ ቤርታ ሞርኬ ማዒባኣያታንቴ፤ ሃሣ ዎዻኒ ማሊባኣዖ ዻቢንቲ ዎዼያ ማዔቴ ዬይ ዓሢ ዬንሢ ካታሞንሢፓ ፔቴማ ጌሊ ፔ ሼምፓሢ ዓይሶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","ዬይ ያዺ ማዓኒ ዳንዳዓሢ ኮኦኪንሢና ላምዖ ዓሲ ሚሢ ቆፂ ዔካኒ ካይዚ ዓኣዼም ፔቴሢ ሚፆ ቆፃንቴ ሄርጋ ኪሪ ዴንዲ ባጋሢ ዎዼቴ፤ ዬኖ ጉዴ ዓሲ ዬንሢ ሃይሦ ካታሞንሢፓ ፔቴማ ጌሊ ቶሊ ዓቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","ያዺ ማዒባኣያታቴ ዎዻኒ ማሊባኣያታዖ ዻቢንቲና ፔቴ ዓሲ ዓሲ ዎዼያ ማዔም፥ ዓኣሺንቲ ቶሎ ካታማኣ ሃኬ ማዔም፥ ዬያ ሃይቄሢኮ ዒጊና ሱጉፆ ማሃኒ ጎይሢ ቲቂ ዎዾንዶያ ኮይሱዋ ዓሲታንቴ ዻጋና ዎዻኒ ዳንዳዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","ሃይሦ ካታሞንሢ ዒንሢ ዱማሳንዳጉዲ ታ ዓይሣሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢኮ ቤርታኣ ዓዶንሢም ጫኣቄ ጎይፆና ዓጮ ዒንሢኮ ዒ ዳልጊሼ ዎዶና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ዬንሢ ሃይሦ ካታሞንሢዳ ሜሌ ሃይሦ ዓኣሺንቲ ቶሎ ካታማ ቃሲ ማዡዋቴ፤ ሃኖ ታኣኒ ዒንሢ ዓይሣ ዓይሢፆ ቢያ ማዺ ዒንሢ ኩንሢ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ናሽኪ፥ ሃሣ ዒዚ ጋዓ ጎይፆ ዒንሢ ሃንቴቴ ሃኖ ዓጬሎ ዒንሢም ዒዚ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","ዬያ ዒንሢ ማዼቴ ፒዜ ዓሲ ሃይቃዓኬ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ዓጮይዳ ፒዜ ዓሲ ሃይቃንዳጉዲ ዎጊ ዻቢንቴ ዓሲ ዒንሢ ማዓዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","«ጋዓንቴ ፔቴ ዓሲ ዓሲ ዒፂ ዎዻኒ፥ ካቲ፥ ዓሲ ሚጪንቱዋያ ማዒ ዎዻዖ ፔ ሼምፓሢ ዓይሳኒ ዬንሢ ካታሞንሢዳፓ ፔቴማ ፑኒ ጌሌቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","ዬይ ዓሢ ናንጋ ካታሞይዳ ዓኣ ሱኡጋ ዓሲ ዳኪ ዒዛ ዔኪ ሙኪ ሃይቄ ዓሢኮ ሱጉፆ ማሃኒ ዳንዳዓ ዑኬ ዒጊኖም ዓኣሢ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","ዬያ ፔቴታዖ ሚጪንቲፖቴ፤ ቢያ ባኣዚና ኮሺ ዒንሢም ማዓንዳጉዲ ዓሲ ዎዼ ዓሲ ዒስራዔኤሌይዳፓ ባይዙዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢሮ ማሂ ዒንጋ ዓጮኮ ኔኤም ዒንጊንቴ ቤዞና ኔ ዓሺናሢናኮ ሚናፓ ዓኣያ፥ ዛጲ ማሂ ጌሦና ማላቶኮ ዑሣ ዓኣዺፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","«ፔቴ ዓሲ ዻቢንቴያ ማዔሢ ዔራኒ ፔቴ ማርካ ሌሊ ጊዱዋሴ፤ ፔቴ ዓሲ ዻቤያ ማዔሢ ዔራኒ ላምዖ ሃንጎ ሃይሦ ማርካ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","ፔቴ ዓሲ ሉኡዙሞና ሜሌ ዓሲ ሜቶ ሄሊሳኒ ዎጌና ዓይሢሴቶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ላምዖንሢ ፆኦሲ ካኣሽኮ ቤዞይዳ ዬኖና ቄኤሴ ማዒ ማዻ ዓሶንታ ዎጎ ዎጋ ዓሶንታ ቤርቶ ሺኢኮንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","ዬካፓ ዎጎ ዎጋ ዓሳ ጌኤዞ ኮሺ ዛጎንጎ፤ ጎዖንቴ ዬይ ዓሢ ዒዛ ፃጶ ማዔ፥ ዒስራዔኤሌ ዓሲዳ ሉኡዙሞ ሃይሴ ሺኢሺ ጴዼቴ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ዎጎና ዓይሢንቴ ዓሢም ዓጋኒ ማሎና ባካ ዬያም ማዖንጎ፤ ዬያጉዴ ፑርታ ባኣዚ ቢያ ዬያይዲ ዒንሢ ባኣካፓ ዒንሢ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","ዓሲ ቢያ ዬያ ዋይዛንዳሢሮ ላሚ ዬያጉዴ ፑርታ ማዾ ማዺሢ ዒጊጫንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","ዬያጉዴ ፑርታ ባኣዚዳ ቢያ ሚጪንቲሢ ዒንሢኮ ባኣያ ማዖንጎ፤ ዒንሢ ማዻንዳ ጎይፃ፦ ዓሲ ዎዼሢ ዎዺ፤ ዓኣፒ ዎዼሢኮ ዓኣፖ ዎዺ፤ ዓቺ ሜንሤሢኮ ዓጮ ሜንሢ፤ ኩቺ ቲቄሢኮ ኩጮ ቲቂ፤ ቶኪ ሜንሤሢኮ ቶኮ ሜንሢ፤ ያዺዱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","ሙሴ ኬኤዛዖ፦ «ዒንሢኮ ሞርኮ ዖላኒ ዒንሢ ኬስካኣና ሳርጌሎ ዖይቶና ፓራሢና ዒንሢፓ ባሻያ ማዔ፥ ዖላ ዓሲያ ዒንሢ ዴንቄያ ማዔቴ ዔያቶ ዒጊጪፖቴ፤ ጊብፄ ዓጮ ዓይላታፓ ዒንሢ ኬሴ፥ ናንጊና ናንጋ ጎዳ ዒንሢና ዎላ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","ዖሎ ዒንሢ ኬስካንዳሢኮ ቤርታ ቄኤሳሢ ፖኦሊሶ ኮይላ ሙኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","‹ዒስራዔኤሌ ዓሲዮቴ! ዋይዙዋቴ! ሃኖ ዒንሢ ዖልዚ ዖላኒ ዴንዳኔ፤ ዒንሢኮ ሞርኮ ዒጊጪፖቴ! ጎጳ ዒንሢኮ ዋኣፆፓ፤ ካራ ባይዚ ሴካ ሃንጋ ጌይፖቴ! ");
INSERT INTO mdyeth_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢና ዎላ ዓኣዻንዳሢሮ ዖሎና ዒንሢ ዒ ባሺሲሳንዳኔ› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","«ዬካፓ ፖኦሊሶ ዓይሣ ዓሳ ፖኦሊሶም ‹ዓኪ ማኣሪ ማዢ ማኣሪ ማሂ ጌሊባኣይ ዒንሢ ባኣካ ዓኣ? ዬያ ጉዴ ዓሲ ዓኣቶ ፔ ማኣሪ ማዖንጎ፤ ዓይጎሮ ጌዔቴ ዒዚ ዖሎይዳ ሃይቄም ሜሌ ዓሲ ዒዛ ማኣራ ታሚ ዔኤሢሲ ጌላንዳሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ሃሣ ሃጊ ዎይኔ ሚሢ ቱካዖ ቤርቶ ዓኣፖ ላዒሲባኣ ዓሲ ዒንሢ ባኣካ ዓኣ? ዬያጉዴ ዓሲ ዓኣቶ ፔ ማኣሪ ማዖንጎ፤ ዓይጎሮ ጌዔቴ ዒዚ ዖሎይዳ ሃይቄም ዬያ ዎይኖ ዓኣፖ ሜሌ ዓሲ ሙዓንዳሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ዬያጉዲ ላኣሊ ዔካኒ ዉዱሮ ዖኦጬ ዓሲ ዓኣቴ ፔ ማኣሪ ማዒ ዴንዶንጎ፤ ዓይጎሮ ጌዔቴ ዒዚ ዖሎይዳ ሃይቄም ዒዚ ዖኦጫዛ ሜሌ ዓሲም ሎዓንዳሢሮኬ› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","«ፖኦሊሶ ዓይሣ ዓሳ ሃሣ ‹ጎጲ ዋኣፂ ዒጊጬ ዓሲ ዒንሢ ባኣካ ዓኣ? ዬያጉዴ ዓሲ ፔ ማኣሪ ማዒ ዴንዶንጎ፤ ዬያጉዴ ዓሢ ሜሌ ዓሶኮ ጎጶ ዋኣፂሳንዳኔ› ጎዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","ፖኦሊሶ ዓይሣ ዓሳ ፖኦሊሶም ዬያ ኬኤዚ ጋፔስካፓ ዓሶ ፓቂ ፓቂ ዬያቶ ዓይሣንዳ ዓሲያ ዶኦሪ ጌሦንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","«ዒንሢ ፔቴ ካታማ ዖሊ ዓርቃኒ ኬስካ ዎዶና ቤርታዺ ዬኖ ካታሞ ዓሳ ኩቺ ዒንጋንዳጉዲ ዖኦጩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","ዔያታ ፔኤኮ ጌሎ ካሮ ቡሊ ኩጮ ዒንሢም ዒንጌቴ ዒንሢም ዴኤሢ ማዓ ማዾ ዔያታ ማዻያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ጋዓንቴ ዬኖ ካታሞ ዴራ ኩጮ ዒንጊፆ ዒፂ ዒንሢና ዖልታኒ ኮዔቴ ካታሜሎ ማማንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ካታማ ዓኣሢ ዒንጋ ዎዶና ዒኢካ ዓኣ ዓቲንቆ ጉቤ ዎዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","ጋዓንቴ ላኣሎንታ ናኣቶ ዻኮንታ ቆልሞንታ ካታሞ ጋራ ዓኣ ቆሎ ቢያ ዒንሢሮ ማሂ ዲዒ ዔኩዋቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬያ ዒንሢም ዓኣሢ ዒንጌሢሮ ዒንሢኮ ሞርኮ ባኮ ቢያ ዒንሢ ባኣዚ ማሁዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","ዒንሢ ናንጋ ዓጮይዳፓ ሃኬ ዓኣሢንታ ዒንሢኮ ዑኬ ዓኣ፥ ሜሌ ዴሮሮ ማዒባኣ ካታሞ ዎልቄና ዒንሢ ዓርቃ ዎዶና ዬያይዱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንሢሮ ማሂ ዒንጋ ዓጮይዳ ዓኣ ካታሞ ዖሊ ዒንሢ ዓርቃ ዎዶና ጋዓንቴ ካታሞይዳ ዓኣ ባኣዚ ቢያ ዎዎዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","ናንጊና ናንጋ ጎዳ ዒንሢ ዓይሤ ጎይፆና ሂታ ዓሶ፥ ዓሞራ ዓሶ፥ ካኣናኔ ዓሶ፥ ፔሪዛ ዓሶ፥ ሂዋዌ ዓሶንታ ዒያቡሳ ዓሶንታኮ ዴሮ ጉቤ ዎዺ ባይዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","ዬያ ዒንሢ ማዻንዳያ ኮይሳሢ ሜሌ ፆኦዞም ካኣሽኪሢ ዛላንታ ዔኤቢ ሻኣካያ ማዔ ባኣዚ ቢያ ዒንሢ ዔያታ ዔርዜም ናንጊና ናንጋ ጎዳ ዒፃያ፥ ጎሜ ማዓ ባኣዚ ዒንሢ ማዹዋጉዲ ጌይኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","«ፔቴ ካታማ ዲዒ ዔካኒ ዒንሢ ጊኢጊንታዛ ካታሜሎ ማንጊ ሚርጌ ኬሊ ዴይንቴያ ማዔቴያ ዓኣፓ ሙይንታኒ ዳንዳዓ ሚፆ ቲቂፖቴ፤ ዓይጎሮ ጌዔቴ ሚፃ ዒንሢኮ ሞርኮቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","ዓኣፓ ሙይንቱዋ፥ ሜሌ ሚፆ ጋዓንቴ ቲቂ ቲቂ ዔኪ ካታሜላ ዲዒንታንዳያ ሄላንዳኣና ዋርዲዮ ዴዎ ቤዞ ዒንሢ ኮሻኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","ሙሴ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዻካላንዳጉዲ ዒንጋ ዓጫ ዞኦዜይዳ ዖኦኒ ዎዼቴያ ዔርቲባኣ ዓሲ ሃይቂ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ዒማና ሱኡጎ ማዔ ዓሶንታ ዎጎ ዎጋ ዓሶንታ ሌዛ ዓኣ ቤዛፓ ዓርቃዖ ዑኬ ዑኬ ዓኣ ካታሞ ሄላንዳኣና ዓኣ ሃኩሞ ዋርቂ ዔሮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","ዬካፓ ሌዛ ዓኣ ቤዞኮ ዑኬ ማዔ ካታሜሎኮ ሱኡጋ ጎሺ ጎሽካኒ ቃምባራ ዓጊንቲ ቤቂባኣ ፔቴ ማሮ ዶኦሮንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","ዬኖ ማሬሎ ጎሺ ጎሽኪንቲባኣያ፥ ቱኮ ባኣዚያ ቱኪንቲባኣያ፤ ሃሣ ሚጩዋ ዋኣሢ ዓኣ ዛሬ ዔኪ ዴንዲ ዒኢካ ባቃኖ ዺዺ ሜንሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","ሌዊ ዓሳ ቄኤሴ ማዒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ማዻንዳጉዲ፥ ዒዛ ሱንፆና ዴሮ ዓንጃንዳጉዲ፥ ሃሣ ዱማ ዱማ ሞኦቶና ሼምፔ ሃይቄ ዛላኣ ዔያታ ጌስቲ ኩንሣንዳጉዲ ዒዚ ዔያቶ ዶኦሬሢሮ ዒኢካ ዴንዶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","ዬካፓ ሃይቄ ዓሢኮ ሌዛ ዓኣ ቤዜሎኮ ዑኬ ማዔ ካታሜሎ ሱኡጋ ሃይቄ ማሬሎ ዑፃ ኩጮ ማስቶንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","ሃሣ ዔያታ፦ ‹ኑኡኒ ሃያ ዓሢ ዎዺባኣሴ፤ ዖኦኒ ዒዛ ዎዼቴያ ኑ ዴንቂባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","ናንጊና ናንጋ ጎዳሢዮ! ጊብፄ ዓጫፓ ኔኤኒ ዓውሲ ኬሴ ዴሮ፥ ዒስራዔኤሌ ዓሶም ዓቶንጎ ጌዔ፤ ኑናኣ ማኣሬ፤ ሃያ፥ ሃይቄ ዓሢኮ ሱጉፆ ኑ ዑፃ ማሂፖ› ጎዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","ናንጊና ናንጋ ጎዳ ዒንሢ ዓይሤ ጎይፆ ዬያይዲ ዒንሢ ማዼቴ ዬያ ፒዜ ዓሢ ዎዺንቴ ዛሎ ዒንሢ ዖኦጪንታያ ማዓዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","«ዒንሢኮ ሞርኮና ዒንሢ ዖልታኒ ኬስኬም ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬያቶ ዒንሢም ዓኣሢ ዒንጊ ዲዒ ዔኪሳዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ዔያቶ ባኣካፓ ዔካኒ ዒንሢም ሚዛጲ ላኣሊ ጴዼቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","ዬኖጉዴ ላኣሎ ዒንሢ ማኣሪ ማኣሪ ዔኪ ዓኣዹዋቴ፤ ዬካፓ ዒዛ ቶኦኮ ጉኡሊንቲ፥ ፁንጎዋ ፔኤኮ ቆኦሪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","ዓፒሎዋ ላኣሚ ሜሌ ማኣዒ፥ ዒንሢ ማኣሮይዳ ፔቴ ዓጊኒ ዴዒ ዖሎና ዒዞኮ ሃይቄ ዓዶንታ ዒንዶንታ ዛሎ ሲዮንጎ፤ ዬያይዴስካፓ ዬኖጉዴ ላኣሎ ዔኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","ናንጊቤቃ ጎዖንቴ ዒንሢ ዔያቶ ኮዑዋያ ማዔቴ ዒንሢ ዔያቶ ሃሼም ዬኖጉዴ ላኣላ ናሽኬ ቤሲ ዓኣዻኒ ዳንዳዓኔ፤ ዎልቄና ዒንሢ ዔያቶ ዔኬያ ማዔሢሮ ዓይሌ ማሂ ሜሌ ዓሲም ዒንሢ ሻንቻንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","«ፔቴ ዓሲ ላምዖ ላኣሊ ዔኪ፥ ፔቴዞ ናሽኪ ባጎ ዒፃያ ማዔያታንቴ ላምዖ ላኣላ ዓቲንቄ ናይ ዒዛም ሾዓዛ ጎዖንቴ ቶይዶ ናዓሢ ዒዚ ዒፃ ላኣሌሎይዳፓ ሾይንቴያ ማዔም፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ዬይ ዓሢ ፔኤኮ ቆሎ ናኣቶም ጊሽካ ዎዶና ዒዛኮ ቶይዶ ናዓሢም ዒንጊንታንዳ ዛሎ ዔኪ ባሼ ዒ ናሽካ ላኣሌላ ሾዔ ናዖም ዒንጊ ዱማሳንዳያ ኮይሱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","ዒዚ ናሽኩዋ ላኣሌሎይዳፓ ሾይንቴያ ማዔቴያ ቶይዶ ናዖም ዒንጊንታ ባካ ሃንጎ ዔያቶ ፔቴ ፔቴሢም ዒዚ ዒንጋሢዳፓ ጳንጬና ባሻያ ማዓኒ ኮይሳኔ፤ ዬያሮ ዬይ ዓሢ ናዓ ቤርታ ሾይንቴያ ቶይዲ ናይ ማዔሢ ዔሪ ቶይዶ ናዖም ኮይሳሢ ዒንጋንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","«ፔቴ ዓሲኮ ጳርቄቴያ ዋይዞ ዒፃ ዦኦሮ ናይ ዓኣያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","ሾዔ ዓሳ ዔያታ ናንጋ ካታሞ ጌሎ ካሮይዳ ዓኣ ሱኡጎ ኮይላ ዎጊሳኒ ዔኪ ዬዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","ዔያታ ዎጊሳ ዎዶና፦ ‹ሃይ ኑኡኮ ናዓሢ ዋይዚ ዒፃ ዦኦሮ ናይኬ፤ ሃሣ ዒዚ ዑሽኪ ማሢንታያ ሚኢሼያ ጉሪ ባይዛያኬ› ጎዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ዬካፓ ካታሞ ዓሳ ሹቻ ዹይ ዒዛ ዎዾንጎ፤ ዬያይዲ ዬያጉዴ ፑርታ ባኣዚ ቢያ ዒንሢ ባኣካፓ ዒንሢ ባይዛንዳኔ፤ ዒስራዔኤሌ ዓጮይዳ ናንጋ ዓሲ ቢያ ዬያ ዋይዚ ዒጊጫንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","«ፔቴ ዓሲ ማዼ ዼኤፒ ዻቢንቲና ሚሢዳ ሱፂንቲ ሃይቃንዳጉዲ ዎጊንቴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","ሚሢዳ ሱፂንቲ ሃይቄ ዓሲ ፆኦሲ ጋዳማ ሳዖይዳ ዔኪ ዬዓሢሮ ሌዛ ሚፆ ዑፃ ሱፂንቲ ዎርቆፓ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢሮ ማሂ ዒንጋ ዓጮ ዒንሢ ዒኢሱዋጉዲ ሌዛ ዒማ ኬላ ዱኡኪንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","ሙሴ ኬኤዛዖ፦ «ዒንሢ ፃጲ፥ ዒስራዔኤሌ ዓሲሮ ማዔ ባይታቴያ ማራይ ዣኣሊ ባይቄያ ዴንቃዖ ኮርሳ ዚቲ ጌይ ዴንዲፖቴ፤ ዓዶም ማሂ ዔኪ ዓኣዹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ጋዓንቴ ዬያ ቆልሞኮ ዓዴ ናንጋ ቤዛ ሃኬ ማዔቴ፥ ሃሣ ዖ ቆልሞ ማዔታቴያ ዒንሢ ዔሪባኣቴ ዒንሢ ማኣሪ ዔኪ ዓኣዹዋቴ፤ ዬካፓ ዒዚ ኮይ ሙካዛ ዒዒንጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","ዬያጉዲ ሃሬታቴያ ማኣዓ፤ ሜሌ ባኣዚያ ቢያ ዒንሢ ፃጶ ዒስራዔኤሌ ዓሶሮ ማዔያ ባይቄም ዒንሢ ዴንቄቴ ማሂ ዒዒንጉዋቴ፤ ዚቲ ጌይፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","«ዒንሢ ፃጶ፥ ዒስራዔኤሌ ዓሲሮ ማዔ ሃሬታቴያ ባይ ጎይሢዳ ሎኦሚ ዓኣንቴ ዒንሢ ዴንቄቴ ኮርሳ ዚቲ ጌይ ዓኣዺፖቴ፤ ሎኦሜ ቤዛፓ ዔቂሲ ዬያ ዓሢ ማኣዱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬያጉዲ ማዻ ዓሶ ዒፃያታሢሮ ላኣሊ ዓቲንቄ ማኣዖ፤ ዓቲንቄ ላኣሊ ማኣዖ ማይንታንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","«ፔቴ ካፒ ሚሢዳታቴያ ሳዓይዳ ጱኡላ ጱኡሊ፥ ሃሣ ናይ ቃንቂ ፔ ማኣሪዳ ዓኣንቴ ዒንሢ ዴንቄቴ ዒንዴሎና ናኣቶና ዎላ ዓርቂ ዔኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","ዒዞኮ ናኣቶ ዒንሢ ዔካኒ ዳንዳዓኔ፤ ጋዓንቴ ዒንዴላ ባራኒ ዴንዳንዳጉዲ ሃሹዋቴ፤ ዒንሢ ዬያይዴቴ ዖርጎጪ ሚርጌ ሌዔ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","«ዓኪ ማኣሪ ዒንሢ ማዣ ዎዶና ማኣሮ ዑፃ ዓኣ ቤዛፓ ዓሲ ኬዲ ሎኦሚ ሃይቁዋጉዲ ዓጮ ጎንጃንዳያ ኮይሳኔ፤ ዬያይዲባኣያ ማዔም ዓሲ ኬዲ ሃይቄቴ ዒንሢ ዖኦጪንታያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","«ዒንሢ ዎይኖ ቱካ ጎዦይዳ ሜሌ ዜርሢ ዜርቂፖቴ፤ ዒንሢ ዬያይዴቴ ዎይኖ ሚፆ ዓኣፖታቴያ ሃንጎ ዒንሢ ዜርቄ ባኮ ዔኪ ሙዓኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","«ጌማይና ሃሬና ዎላ ዋኣፂ ጎሽኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","«ማራይ ጋፓኔና ሜሌ ሼኤሜና ዎላ ዹዖና ማኣዖ ማይንቲፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","«ዓፒሎኮ ዒንሢኮ ዖይዶ ዛሎ ጉቤሢዳ ማጫሬ ዋሁዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","«ፔቴ ዓሲ ላኣሊ ዔካዖ ዒዞ ዒፂ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","‹ሃኖ ላኣሌሎ ታ ዔኬንቴ ዒዛ ኩሙሢቱዋሴ› ጌዒ ሉኡቂ ዎጌና ዓይሢሲ ሱንፆ ዒዞኮ ፑርቲሴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","ናዔሎኮ ዓዶንሢ ናዔላ ኩሙሢ ማዔሢ ዔርዛ፥ ማርካ ማዓ ባኣዚ ካታሞኮ ዎጎ ዎጋ ዓሶም ዔኪ ሙኪ ዻዎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","ዬካፓ ናዔሎኮ ዓዴ፦ ‹ታኣኒ ሃኖ ታ ናዔሎ ሃያ ዓሢም ዔፒና ዒንጌንቴ ሃሢ ዒዚ ዒዞ ዒፃያ ማዔሢ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","ናዔላ ኔኤኮ ኩሙሢቱዋሴ ጌዒ ሱንፆ ዒዛኮ ፑርቲሴኔ፤ ጋዓንቴ ታ ናዔላ ኩሙሢ ማዔሢ ዔርዛ ማርኮ ማላቶ ሃኣዛጉዋቴ!› ጌዒ ሱጉፃ ሄሌ ዓፒሎ ሱኡጎ ቤርታ ሂኢሦንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","ዒማና ካታሜሎኮ ሱኡጋ ዬያ ዓናሢ ዔኪ ጳርቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","ሃሣ ቃሲ ፔቴ ኪሎ ማዓ ዓንጊ ቢራ ማጋጬ ጪጊሺ ናዔሎኮ ዓዶም ዒንጎንጎ፤ ዓይጎሮ ጌዔቴ ዬይ ዓሢ ፔቴ ዒስራዔኤሌ ዓሲ ማዔ ኩሙፆ ዉዱሮ ናዔሎኮ ሱንፆ ፑርቲሴሢሮኬ፤ ዬካፓ ዒዛ ዒዛኮ ማቾ ማዒ ናንጎንጎ፤ ሃይቃንዳያ ሄላንዳኣና ዒዞ ዒ ዓንጃንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","«ጋዓንቴ ዓሢ ኬኤዜ ባካ ጎኔ ማዒ፥ ዒዛኣ ኩሙሢ ማዔሢኮ ማርካ ባኣያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","ዒዛ ዓዶ ማኣራ ዓኣዖ ዓቲንቄና ዞኦስካ ኮኦሚ፥ ዬያጉዴ ዻውሲንቲ ማዾ ዒስራዔኤሌ ዓሶ ባኣካ ማዼሢሮ ዓሳ ዒዞ ዔኪ ዒዞኮ ዓዶ ማኣሪ ዴንዴም፥ ዒኢካ ዒዛ ናንጋ ካታሞይዳ ዓኣ ዓሳ ሹቻ ዹይ ዒዞ ዎዾንጎ፤ ዬያይዲ ዬያጉዴ ፑርቶ ማዾ ዒንሢ ባኣካፓ ዒንሢ ባይዛኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","«ፔቴ ዓሲ ሜሌ ዓሲኮ ላኣሊ ዒኢሴቶ ዬያ ዓሢንታ ላኣሌሎንታ ቢያ ዎዺንቶንጎ፤ ዬያይዲ ዬያጉዴ ፑርቶ ማዾ ዒንሢ ባኣካፓ ዒንሢ ባይዛኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","«ፔቴ ዓሲ ፔቴ ካታማይዳ ሜሌ ዓሲና ዖኦጪንቲ ዓኣ፥ ኩሙሢ ዉዱሮ ናይ ዓርቄያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","ላምዖንሢ ካታሞኮ ዙሎ ዔኪ ኬስኪ ሹቻ ዹይ ዎዹዋቴ፤ ናዔላ ሃይቃኒ ኮይሳሢ ካታሞ ሳዛ፥ ዓሲ ዋይዛኒ ዳንዳዓ ቤሲዳ ዓኣዖ ዒላቲባኣሢሮኬ፤ ዓሢ ሃይቃኒ ኮይሳሢ ሜሌ ዓሲና ዖኦጪንቲ ዓኣ ኩሙፆ ዉዱሮ ናዔሎ ዓርቄሢሮኬ፤ ዬያይዲ ዬያጉዴ ፑርቶ ማዾ ዒንሢ ባኣካፓ ዒንሢ ባይዛኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","«ፔቴ ዓሲ ሜሌ ዓሲና ዖኦጪንቲ ዓኣ፥ ኩሙሢ ዉዱሮ ናይ ካይካ ዴንቂ ዓርቄቴ ዓሢ ሌሊ ዎዺንቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","ዬና ናዔላ ዒዞ ዎዺሻንዳ ዻቢንቲ ማዺባኣሢሮ ዒዞይዳ ፔቴ ባኣዚታዖ ማዻንዳያ ኮይሱዋሴ፤ ዬያጉዴ ማዾ ማዻ ዓሢ ዓሲ ዎዼ ዓሲጉዲ ዛጊንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","ዬይ ያዺ ማዺንታሢ፦ ዬይ ዓሢ ዬና ሜሌ ዓሲና ዖኦጪንቲ ዓኣ ዉዱሮ ናዔላ ሶኦፔ ቤዛ፥ ካዮ ባኣካ ዓኣንቴ ዓርቄሢሮ ዒዛ ዒላቴቴያ ዒዞ ማኣዳንዳ ዓሲ ባኣሢሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","«ፔቴ ዓሲ ዓሲና ዖኦጪንቲባኣ፥ ኩሙሢ ዉዱሮ ናይ ዓርቄያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ናዔሎኮ ዓዶም ዶንጊታሚ ማዓ ዓንጊ ቢራ ጪጎንጎ፤ ዬካፓ ዒዛ ዒዛኮ ማቾ ማዒ ናንጎንጎ፤ ዒዚ ዒዞ ዎልቄና ዓርቂ ዒዞና ላሄሢሮ ዒዚ ሃይቃንዳያ ሄላንዳኣና ዒዞ ዒ ዓንጃኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","«ዓይጎ ዓሲያ ማዖም ዒንዶ ሌጎና ላሂ ዓዶ ዻውሲሶፓ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","ሙሴ ኬኤዛዖ፦ «ፂኢቄ ዹይንቴያ ሃሣ ጌኒንቴ ዓሲ ናንጊና ናንጋ ጎዳ ዴሮ ባኣካ ፓይዲንታንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","«ዻኣሪ ናይ ማዒ ሾይንቴ ዓሲና ዒዛኮ ዜርፆና ዴንዲ ታጶ ሾይንቲ ሄላንዳኣናታዖ ናንጊና ናንጋ ጎዳ ዴሮ ባኣኮ ጌሊ ፓይዲንታንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","«ዓሞኦኔ ዓሲ ማዔቴያ ሞዓኣቤ ዓሲ፤ ሃሣ ዔያቶ ዜርሢ ማዔ ዓሲ ቢያ ዴንዲ ታጶ ሾይንቲ ሄላንዳኣናታዖ ናንጊና ናንጋ ጎዳ ዴሮ ባኣካ ፓይዲንታንዳያ ኮይሱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","ዒንሢ ጊብፄ ዓጫፓ ኬስኪ ጎይፆይዳ ዓኣንቴ ዔያታ ሙኡዚንታ ዋኣሢንታ ዒንሢም ‹ዒንጋዓ› ጌዒ ላኣጌያታሢ ዋሊንታያቱዋሴ፤ ዬያ ሌሊቱዋንቴ ሜሶፖታሚያይዳ ፔቶሬ ጌይንታ ካታሞይዳ ናንጋ ቢዖሬ ጎዖሢ ናኣዚ ባላዓሜ ዒንሢ ጋዳንቃንዳጉዲ ሚኢሼ ዔያታ ዒዛም ጪጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛም ዋይዛኒ ኮይባኣሴ፤ ናንጊና ናንጋ ጎዳ ዒንሢ ናሽኬሢሮ ጋዳሞ ዓንጆ ባንሢ ሺርሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","ዒንሢ ናንጋ ዎዶ ቢያይዳ ዬይ ዴራ ዖርጎጪ ኮሺ ናንጊ ናንጋንዳጉዲ ዔያቶ ማኣዲፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","«ዔዶኦሜ ዓሳ ዒንሢኮ ዒጊኖ ማዔሢሮ ዔያቶ ዒፂፖቴ፤ ጊብፄ ዓጫ ሙኬ ዓሲ ማዒ ዒንሢ ናንጌሢሮ ጊብፄ ዓጮ ዓሶዋ ዒፂፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","ዔያቶኮ ዜርፃ ሃይሦ ሾይንቲ ሄላዛ ናንጊና ናንጋ ጎዳ ዴሮ ባኣካ ማዒ ፓይዲንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","«ዒንሢ ዖልዚ ዖላኒ ዖሎሮ ዱንኪ ዴዓ ቤዞይዳ ዓኣ ዎዶና ዒንሢ ዒኢሳ ባኣዚዳፓ ካፒንቱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","ፔቴ ዓሲ ዹሚና ዓውታዺ ሾይዣ ዜርፆ ፔ ዑፃ ላኣሌያ ማዔቴ ዬይ ዓሢ ጉርዳፓ ዙሎ ኬስኪ ዒኢካ ዴዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","ዬካፓ ዓባ ኬዳዛ ዑፆ ማስቲ፥ ዓባ ጌላኣና ጉርዶ ማዒ ጌሎንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","«ዒንሢ ሼኤሺ ሼኤቃንዳ ቤሲ ጉርዶኮ ዙላ ጊኢጊሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","ዒንሢ ሼኤቃ ዎዶና ሺዖ ቦኦኪ ዱኡካኒ ዖሎ ዓንጋሞና ዎላ ሲፖ ዔኪ ሃንቱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","ዒንሢ ዱንኪ ዴዔ ጉርዶ ዎጋ ጋዓ ጎይፆጉዴያ ጌኤሺ ማሂ ካፑዋቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ካፓኒ፤ ሃሣ ዖሎናኣ ሞርኮ ዒንሢ ባሺሳኒ ዒንሢኮ ጉርዶ ባኣካ ዓኣኔ፤ ናንጊና ናንጋ ጎዳ ዒንሢዳፓ ፔ ዓኣፖ ካሮ ሺርሻንዳጉዲ ማሃ ሻኣካ ባኣዚ ቢያ ማዺፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","«ፔቴ ዓይሌ ማዒ ማዻ ዓሲ ዒ ማዻ ዓሢ ኮይላፓ ቤቲ ዒንሢ ኮይላ ሙኬያ ማዔቴ ቤርታ ዒዛ ቆላሢም ማሂ ዳኪፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","ዒንሢኮ ካታሞይዳ ዒ ናሽኬ ቤዛ ናንጎንጎ፤ ዒዛ ሜታሲፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","«ዒስራዔኤሌ ዓሲ ማዔ፥ ዓቲንቄታቴያ ላኣሊ ሜሌ ፆኦዞ ካኣሽካ ዓሳ ማዻሢጉዲ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሆፓ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","ማቾ ሃሣ ዓኒ ማዒባኣያና ላሃ ዓሲ ናንጊና ናንጋ ጎዳ ዒፃያታሢሮ ዬያ ማዺ ዔኮና ሚኢሻ ናኣቢ ኩንሥሢ ማዒ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ማኣሪ ጌሎፓ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","«ዒንሢ ፃጶ ማዔ፥ ዒስራዔኤሌ ዓሲም ሚኢሼ ዒንሢ ታልዔቴ ሃሣ ሙሙዖንዶ ባኣዚያ ዒንሢ ዒንጌቴ ሾይቺና ማሃንዳጉዲ ዖኦጪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","ሾይቺና ዒንሢም ዒንጋኒ ኮይሳሢ ሜሌ ዓጪፓ ሙኬ ዓሲ ማዖንጎ፤ ዒንሢ ፃጶ ማዔ፥ ዒስራዔኤሌ ዓሲፓ ማዓኒ ኮይሱዋሴ፤ ዬያ ዎጎ ዒንሢ ማዺ ኩንሤቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዴንዲ ዒንሢ ዻካላ ዓጮይዳ ማዻ ማዾና ቢያ ዒንሢ ዓንጃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ፔቴ ባኣዚ ዒንሢ ዒንጋኒ ናኣቤ ዎዶና ‹ዒንጋንዳኔ› ጌዒ ጫኣቂ ናኣቤ ባኮ ኔጊሺፖቴ፤ ዒንሢ ዒንጋኒ ናኣቤ ባኮ ዒንጋንዳጉዲ ናንጊና ናንጋ ጎዳ ኮዓኔ፤ ናኣቦ ዒንሢ ኩንሢባኣቴ ጎሜ ዒንሢኮ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","ናንጊና ናንጋ ጎዳም ናኣቡዋዖ ሃሺሢ ፔኤሮ ጎሜ ማዑዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","ጋዓንቴ ዒንሢ ዒንሢኮ ናሽኪ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ናኣቤቴ ዒንሢ ጌዔ ባኮማ ዛጊ ካፒ ኩንሣንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","«ፔቴ ዓሲኮ ቱኮና ዎይኖ ባኣኮና ዒንሢ ዴንዳ ዎዶና ካፄ ዓኣፖ ኮዔሢጉዲ ሙዓኒ ዒንሢ ዳንዳዓኔ፤ ጋዓንቴ ዔኤቢዳ ማንፂ ዔኪ ዴንዲፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","ሃሣ ፔቴ ዓሲኮ ጎሺ ጋርሲና ዒንሢ ዴንዳ ዎዶና ቲሻሢ ኩቻ ሾኦሊ ዔኪ ዔኪ ዻዓኒ ዒንሢ ዳንዳዓኔ፤ ጋዓንቴ ጲሺ ዔኪ ዒንሢ ማኣሪ ዴንዲፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","ሙሴ ኬኤዛዖ፦ «ፔቴ ዓሲ ላኣሊ ዔካዖ ናንጊቤቃ ዒዛ ዒሣ ባኣዚ ዒ ዴንቂ ዓንጂፆ ዔርዛያ ማርካ ማዓ ዋርቃታ ፃኣፒ ዒንጊ፥ ፔ ማኣራፓ ዒዞ ዳኬያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","ሃሣ ዒዛ ዴንዲ ሜሌ ዓሲም ሌዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ዬይ ላምዓሳ ዓናሢያ ዒዞ ዒፃያ ማዒ ዓንጂንቲፆ ዔርዛ፥ ማርካ ማዓ፥ ዋርቃታ ፃኣፒ ዒንጊ ፔ ማኣራፓ ኬሲ ዳኬቴ፤ ሃሣ ዬይ ዓናሢ ሃይቄያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","ዬንሢ ላምዖ ካሮንሢና ማዔቴያ ዬይ ቤርታኣ ዓናሢ ዒዞ ላሚ ዔካንዳያ ኮይሱዋሴ፤ ዒዞ ዒኢቴያ ማሂ ዒ ዛጎንጎ፤ ዒዞ ዒ ላሚ ዔኬቴ ዬያጉዴ ማዾ ናንጊና ናንጋ ጎዳ ዒፃያኬ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ዓጮይዳ ዒንሢ ናንጋ ዎዶና ዬያጉዴ ፑርታ ጎሜ ማዻንዳያ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","«ዑኬ ላኣሊ ዔኬ ዓሲ ዖልዚ ዖላንዳጉዲ ዎልቄና ዳካንዳያ ኮይሱዋሴ፤ ሃሣ ሜሌ ማዾዋ ዎልቄና ማዻንዳያ ኮይሱዋሴ፤ ዒዚ ፔቴ ሌዔ ዓይጎ ባኣዚያ ዎልቃዺ ዓይሢንቱዋዖ ሜታ ባኣያ ማዒ ፔ ማኣራ ማቾ ዎዛሶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","«ፔቴ ዓሲም ፔቴ ባኣዚ ዒንሢ ታልዓ ዎዶና ዎንፆታቴያ ማዶ ዓይሢ ባኣዚ ማሂ ዔኪ ዓርቂፖቴ፤ ዬያ ዒንሢ ማዼቴ ዬያ ዓሢኮ ማኣሮ ዓሳ ሙዖንዶ ባኣዚ ጊኢጊሾ ባሺንቲ ሃይቃንዳጉዲ ማዺሢጉዲ ዬይ ፓይዲንታኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","«ፔ ፃጲ ማዔ፥ ዒስራዔኤሌ ዓሲ ዓርቂ ዔኪ ፔኤኮ ካራሚ ማሂ ማዺሻ ዓሲ፤ ሃሣ ሜሌም ሻንቻ ዓሲ ሃይቃንዳጉዲ ዎጊንቶንጎ፤ ዬያይዲ ዬያጉዴ ፑርቶ ማዾ ዒንሢ ባኣካፓ ዒንሢ ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","«ዑሢዳ ኬስካ ዶርዓሢ ዒንሢ ዓርቄ ዎዶና ታ ዒንሢም ኬኤዛ ዳምቦ ጎይፆና ሌዊ ዓሶ ማዔ ቄኤሳ ዒንሢም ኬኤዛ ዳምቦ ዛጊ ማዺ ኩንሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","ጊብፄ ዓጫፓ ዒንሢ ኬስኪ ጎይፆይዳ ዓኣንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ማይራሞይዳ ማዼ ባኮ ማሊ ጶቂሡዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","«ዒንሢ ፔቴ ዓሲም ዔኤቢ ታልዓ ዎዶና ዓይሢ ማዓ ባኣዚ ዔካኒ ዒንሢሮ ዓሢኮ ጋሮ ጌሊፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","ዒንሢ ዙላ ዔቄም ዓሢ ፔኤሮ ዓይፆ ማዓ ባኮ ዔኪ ዒንጎንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","ዓሢ ማንቆ ማዔቴ ዓሢ ማኣዓ ዓፒሎ ዒንሢ ማኣራ ዔኪ ዎይሢፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","ዒዚ ማኣዒ ዎርቃንዳጉዲ ዓባ ጌሉዋንቴ ዒዛም ማማሁዋቴ፤ ዒዚ ዒንሢም ‹ፆኦሲ ዒንጎም› ጋዓንዳኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦሲያ ዒንሢኮ ዬያ ማዾና ዎዛዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","«ዒንሢ ፃጶ ዒስራዔኤሌ ዓሲ ማዔቴያ ዒንሢ ዓጮ ካታሞኮ ፔቴዞይዳ ናንጋ ሜሌ ዓጪ ዓሲ ማዔ ማንቆ፥ ሃሣ ሜታዻ ዓሲ ዒንሢ ሚኢሼ ጪጌም ማዾ ማዻኒ ጌሌ ዎዶና ኮይሳሢ ጪጉዋዖ ጌሺ ጌሺ ማዺሺፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","ዒዚ ማንቆ ማዔሢሮ ኬላ ኬላ ዒ ማዼሢ ዛሎ ዒንሢ ዒንጋ ሚኢሾ ዔካኒ ዒማ ካፒ ዓኣሢሮ ሚኢሾ ዓባ ጌሉዋንቴ ዒንጉዋቴ፤ ዒንሢ ጪጊባኣቴ ናንጊና ናንጋ ጎዳ ባንሢ ዒዚ ዒላቴም ጎሜ ዒንሢኮ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","«ናይ ማዼ ዻቢንቲና ሾዓ ዓሳ ሃይቃንዳጉዲ ዎጊንታንዳያ ኮይሱዋሴ፤ ሃሣ ሾዔ ዓሳ ማዼ ዻቢንቲና ናኣታ ሃይቃንዳጉዲ ዎጊንታንዳያ ኮይሱዋሴ፤ ፔቴ ፔቴ ዓሳ ፔ ማዼ ዻቢንቶና ሌሊ ሃይቃንዳጉዲ ዎጊንታንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","«ሜሌ ዓጪፓ ሙኬያ፥ ሃሣ ዜኤሪ ናይም ፒዜ ዎጌ ዎጊፆ ሃሺፖቴ፤ ዜኤሪንዳ ታልዔ ባኣዚ ዛላሮ ዓፒላ ዓይሢ ባኣዚ ማሂ ዔኪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","ዒንሢ ጊብፄ ዓጮይዳ ዓይሌ ማዒ ናንጌሢንታ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬያይዳፓ ዓውሲ ዒንሢ ኬሴሢ ጶቂሡዋቴ፤ ታኣኒያ ሃያ ዓይሢፆ ዒንሢ ዓይሣሢ ዬያ ዛሎናኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","«ሃኣኮ ዒንሢ ጮኦራ ዎዶና ዒንሢ ጎዦ ጋራ ዋሌ ናኣራ ዓኣቴ ጊንሣ ማዒ ሙኪ ዔኪፖቴ፤ ዬይ ሜሌ ዓጫፓ ሙኬ ዓሶንታ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢንታም ዓቶንጎ፤ ዬያ ዒንሢ ማዼቴ ዒንሢ ማዻ ማዾና ቢያ ናንጊና ናንጋ ጎዳ ዒንሢ ዓንጃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","ዛይቶ ጩኡጲ ኮሾ ሪሚቶ ዓኣፖ ዒንሢ ማንፄስካፓ ሚፆ ካኣፓ ካኣፓ ዓቴ ቃኣሉሞ ጊንሣ ሙኪ ማንፂ ዔኪፖቴ፤ ዬይ ሜሌ ዓጫፓ ሙኬ ዓሶንታ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢንታም ዓቶንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","ዎይኖኮዋ ዓኣፖ ሱፃፓ ቲቂ ቲቂ ዒንሢ ዔካንቴ ዓቴሢ ጊንሣ ሙኪ ቲቂ ዔኪፖቴ፤ ዬያ ሜሌ ዓጫፓ ሙኬ ዓሶንታ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢንታም ሃሹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","ዒንሢ ጊብፄ ዓጮይዳ ዓይሌ ማዒ ናንጌሢ ዋሊፖቴ፤ ታኣኒያ ሃያ ዓይሢፆ ዒንሢ ዓይሣሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","ሙሴ ኬኤዛዖ፦ «ላምዖ ዓሲ ዎላ ፑርታዖ ሞኦቶ ዓርቂ ዎጎ ዎጎ ቤዞ ሙኬቴ ዎጎ ዎጋ ዓሳ ፒዜሢም ‹ሜታ ኔኤኮ ባኣሴ›፤ ዻቤሢም ‹ኔ ዻቢንቴያኬ› ጌይ ዎጋኒ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","ዻቢንቴ ዓሢ ዢራፓና ጳርቂንታንዳያ ኮይሳያ ማዔቴ ዒዚ ጳርቂንታንዳሢ ዎጎ ዎጋ ዓሢ ዓኣ ቤዛ፤ ሃሣ ዒ ዋኣዼ ጳርቂንታንዳቴያ ዎጊንታሢ ዒዚ ዻቢንቴ ዻቢንቶ ጎይፆ ጉዴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","ዖይዲታሚ ማዓንዳ ዢራፓና ጳርቂንታኒ ዳንዳዓኔ፤ ጋዓንቴ ዖይዲታሚፓ ዑሣ ዓኣሣንዳያ ኮይሱዋሴ፤ ዬካፓ ዑሣ ዓኣሢ ጳዺንቴያ ማዔቴ ዒንሢ ዒንሢኮ ፃጳሢ ዓሲ ቤርቲዳ ቦርሲሳያ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","«ሃኣኮ ሺርካ ጌማይኮ ሺርካ ዎዶና ሙሱሮ ቱኪፖቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","«ዎሊኮ ጌርሲንሢ ማዓ ዓሲ ፔቴ ቤሲዳ ናንጋያታዖ ፔቴሢ ናይ ሾዑዋዖ ሃይቄቴ ሃይቄሢኮ ማቻ ማኣሮ ዓሶፓ ሜሌ ዓሲም ሌዓንዳያ ኮይሱዋሴ፤ ዒዞ ዓኒኮ ጌርሲ ዒዞ ዔካንዳያ ኮይሳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","ዬይ ሂዲንታ ዎዶና ቤርታ ሾይንቴ ዓቲንቆ ናዓ ሃይቄሢ ሱንፆና ዔኤሊንቶንጎ፤ ዬያይዲፆና ዒስራዔኤሌ ዓሶይዳፓ ዓሲ ሃይቄቴ ዾንሢ ባይቃይ ባኣያ ማዒ ዜርፃ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","ጋዓንቴ ሃይቄሢኮ ጌርሲ ዬኖ ላኣሌሎ ዔካኒ ኮዒባኣቴ፥ ዒዛ ካታሞ ሱኡጎ ኮይላ ዴንዲ ‹ታኣኮ ዓኒኮ ጌርሲ ታና ዔካንዳያ ኮይሳያታንቴ ዔካኒ ኮይባኣሴ፤ ዒዛኮ ሃይቄ ጌርሲም ዒስራዔኤሌ ዓሶ ባኣካ ዜርሢ ጌሣኒያ ኮይባኣሴ› ጎዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","ዬካፓ ካታሜሎኮ ሱኡጋ ዓሢ ዔኤሊ ዖኦጮንጎ፤ ሃሣ ዒዚ ዒዞ ዔኪፆ ዒፃያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ዬና ላኣሌላ ካታሞ ሱኡጎ ቤርቶ ዒዛ ኮይላ ሙኪጋፓ ቶካፓ ዒዛኮ ፔቴ ዱርዞ ኬሲ ዓኣፖ ካራ ጩታዖ፦ ‹ፔ ጌርሲም ዜርሢ ጌሣኒ ዒፃ ዓሲዳ ዬያጉዴ ቦርሲሳ ማዾ ማዺንታንዳያ ኮይሳኔ› ጎዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","ዬያ ዓሢኮ ማኣሮ ዓሳ ዒስራዔኤሌ ዴሮ ባኣካ ‹ዱርዛ ኬሲንቴ ዓሢ ማኣሮ ዓሶ› ጌይንቲ ቦሂንታያ ማዒ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","«ላምዖ ዓሲ ዎላ ፑርቲ፥ ዎሊ ዓርቂ ዑራዻንቴ ፔቴሢኮ ማቻ ሙኪ ዓኒ ማኣዳኒ ሃንጎ ዓሢኮ ፂኢቆ ዺዺ ዓርቄቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","ሚጪንቲሢባኣያና ኩጫ ዒዞኮ ቲቲቂንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","14","«ዔኤቢ ማኮ ዼኤፒ ባኣዚና ዻካ ባኣዚና ዔኪ ዓሲ ጌሺ ሺሪፖቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ዓጮይዳ ሚርጌ ሌዔ ናንጋኒ ፒዜ ሃሣ ጉሙርቂንታያ ማዔ ማኮ ባኣዚ ዒንሢኮ ዓኣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬያይዲ ጌሺሢና ጌኔ ማዾ ማዻ ዓሲ ጉቤ ዒዒፃኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","«ዒንሢ ጊብፄ ዓጫፓ ኬስኬ ዎዶና ዓማሌቄ ዓሳ ዒንሢዳ ማዼ ጌኖ ማዾ ዋሊፖቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","ዔያታ ፆኦሲ ዒጊጩዋዖ ዒንሢ ጎይፆይዳ ላቢ ዓኣንቴ ጊንሢና ሙኪ ዖልዚ ቡሊ ላቢንቲ ጊንፃ ታሢ ታሢ ሙካ ዓሶ ዒንሢኮ ቢያ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","ዬያሮ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓጬሎ ዒንሢ ዻካልሲ ዒንሢኮ ኮይላ ዓኣ ሞርኮይዳፓ ቢያ ሃውሺሲ ዴይሤ ዎዶና ሳዖይዳ ዔያቶ ዓይጎ ዓሲያ ጶቂሣይ ባኣያ ማሂ ዓማሌቄ ዓሶ ቢያ ዎዺ ባይዙዋቴ! ዬያ ፔቴታዖ ዋሊፖቴ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","ሙሴ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዻካልሳ ሳዔሎ ጌሊ፥ ጊኢጊ ዒንሢ ዴዔ ዎዶና፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ዒንሢ ፔቴ ፔቴሢ ጎሽኪ ካፂሴ ሃኣኮይዳፓ ቤርቶ ዖኦራና ዔኪ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዶኦሬ ቤዞ ዴንዲጋፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ዒማና ቄኤሴ ማዒ ማዻሢ ኮይላ ‹ሚና ኑ ዓዶንሢም ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ኑና ዔያቶኮ ናኣቶም ዒንጋኒ ጫኣቄ ዓጬሎ ታ ጌሌሢ ሃኖ ታኣኒ ማርካዻኔ› ጎዑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","«ቄኤሳሢ ዖኦሮና ዓኣ ሃኣኮ ዔኪ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ሚቺ ዒንጎ ቤዞኮ ቤርቶ ዛላ ጌሦንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","ዬካፓ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ፦ ‹ኑ ዓዳሢ ፔቴ ቤዛፓ ሜሌ ቤሲ ቤቲ ቤቲ ናንጋ ሶኦሪያ ዓጪ ዓሲኬ፤ ዒዛኮ ዻካ ማኣሪ ዓሲ ዓኣንቴ ዬንሢ ዔኪ ጊብፄ ዓጮ ዒ ዴንዳዖ ሙኬ ዓሲ ማዒ ዒኢካ ናንጌኔ፤ ዬንሢ ዻኮ ዓሶንሢ ዺቢ፤ ሃሣ ዎልቄና ዓኣ ዴሬ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","ጊብፄ ዓጮ ዓሳ ጋዓንቴ ኑና ሚርጌ ሜታሴኔ፤ ቶኦኪያ ኑኡኮ ባይዚ፥ ዓይሌ ማዒያ ዔያቶም ኑ ማዻንዳጉዲ ኑጊዳ ዎልቃዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ዬካፓ ኑኡኒ፦ ናንጊና ናንጋ ጎዳ ማዔ ኑ ዓዶንሢኮ ፆኦዛሢ ባንሢ ዒላቴኔ፤ ናንጊና ናንጋ ጎዳሢያ ኑኡኮ ዒላቶ ዋይዚ ኑኡኮ ሜቶ፥ ኑ ላቤ ላቢፆ፤ ሃሣ ኑ ሄርቂንቲ ዎርቃ ዎይፆዋ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","ዬያሮ ናንጊና ናንጋ ጎዳ ፔኤኮ ዼኤፖ ዎልቆና ቢታንቶና ጊብፄ ዓሶይዳ ዒጊቹሞ ጌልዚ፥ ዒዛ ዎልቄና ማዺንታ ዓኪ ባኣዚ ማዺ ጊብፄ ዓጫፓ ኑና ዒ ኬሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","ሃሣ ሃይካ ኑና ዔኪ ሙኪ ሃኖ ማሎ ዓጬሎ ኑና ዻካልሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","ዬያሮ ሃይሾ፦ ታኣኒ ዒዚ ታኣም ዒንጌሢኮ ቤርቶ ዔኪ ዬዔኔ› ጌይ ኬኤዞንጎ» ጌዔኔ። «ዬካፓ ዖኦሮና ዓኣ ሃኣኮ ናንጊና ናንጋ ጎዳ ቤርታ ጌሢ ዒዛም ዚጉዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","ዒንሢና ዒንሢኮ ማኣሮ ዓሶናም ናንጊና ናንጋ ጎዳ ማዼ ኮዦ ባኮና ቢያ ዎዛዺ ጋላቱዋቴ፤ ሌዊ ዓሶንታ ዒንሢና ዎላ ናንጋ ሜሌ ዓጮ ዓሳ ዬያ ጋላቶ ኬሎይዳ ዒንሢና ዎላ ዓኣያ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","«ሃይሣሳ ሃይሣሳ ሌዖና ጌይፃ፦ ቤርቶ ዔኪ ዒንሢ ዱማሳ ሌዖና ቤርቶ ማዓ ሃኣኮ ዔኪ ሙኪ ቡኩሲ ጋፔስካፓ ዒንሢ ካታሞይዳ ናንጋ ሌዊ ዓሳ፥ ሜሌ ዓጫፓ ሙኬ ዓሳ፥ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢንታም ዔያታ ሙይ ሚሽካንዳጉዲ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","ዬያይዴስካፓ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ‹ኔኤም ዱማዼያ፥ ታጳሢዳፓ ፔቴ ዔኪ ዒንጎ ዒንጊፆ ኔ ኑና ዓይሤ ጎይፆና ታኣኒ ዔኪ ሌዊ ዓሶም፤ ሜሌ ዓጫፓ ሙኬ ዓሶም፤ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢንታም ማኣዶ ማዓንዳጉዲ ዒንጌኔ፤ ኔ ዓይሤሢዳፓ ታ ሃሼ ባኣዚ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","ፑርታ ታ ማኣራ ኬስኬም ዬኤፒዳ ማዔቴያ ዬያይዳፓ ታ ዔኪ ሙዒባኣሴ፤ ዎጎ ጎይፆና ጌኤሺ ታ ማዒባኣ ዎዶናኣ ዬያይዳፓ ፔቴታዖ ታ ዔኪ ዔኤቢ ዎኦቲባኣሴ፤ ሃይቄ ዓሲ ዛላ ዒንጎ ዒንጊሢ ማሂያ ዬያፓ ዔኪ ፔቴታዖ ታ ዒንጊባኣሴ፤ ኔ ኑና ዓይሤ ጎይፆና ኔና፥ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢኮ ዓይሢፆ ኑ ኩንሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","ጫሪንጮይዳ ዓኣ ኔኤም ዱማዼያ፥ ኔ ናንጋ ቤዞይዳ ዴዒ ኑና ዛጌ፤ ኔኤኮ ዴሮ ዒስራዔኤሌ ዓሶ ዓንጄ፤ ቤርታ ኑኡኮ ዓዶንሢም ኔ ጫኣቂ ኑኡም ዒንጌ ማሎ ዓጬሎዋ ዓንጄ› ጌዒ ኬኤዙዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","«ዎጎንታ ዳምቦንታ ዒንሢ ካፒ ኩንሣንዳጉዲ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሃኖ ዒንሢ ዓይሣኔ፤ ዬያሮ ዬንሢ ጉቤ ዒናፓ ሃሣ ጉቤ ሼምፓፓ ካፑዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ማዔሢ፤ ሃሣ ጊንሣ ዒ ዓይሤ ዎጎ ጎይፆዋ ዒንሢ ማዻያ ማዔሢ ሃኖ ዒንሢ ዔርዜኔ። ዒዛኮ ዎጎንታ ዓይሢፆንታ ዳምቦንታ ማዺ ኩንሣኒ ኔ ጫኣቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","ዬያሮ ናንጊና ናንጋ ጎዳ ዒንሢም ማዻኒ ጫኣቄ ጎይፆና ሃይሾ ሃኖ ዒዛም ዱማዼያ ሃሣ ዒዚ ናሽካ ዴሬ ማሂ ዒንሢ ዒ ዔኬኔ፤ ዒ ዓይሣ ዓይሢፆዋ ቢያ ዒንሢ ካፒ ኩንሣንዳጉዲ ዒንሢ ዒ ዓይሣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","ዬያ ዒንሢ ማዼቴ ዒዚ ማዤ ሃንጎ ዴሮይዳፓ ቢያ ባሼ ጋላቲንታንዳጉዲ፥ ሱንሢ ዓኣያ ማዓንዳጉዲ ቦንቺሲ ዒንሢ ዼጊዳኒ ዒ ጫኣቄ ጎይፆና ዒዛም ዱማዼ ዴሬ ማሃንዳሢ ዒንሢም ዒ ኬኤዜኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","ዬካፓ ሙሴ ዒስራዔኤሌ ዓሶኮ ሱኡጎና ዎላ ማዒ ዴሮም፦ «ሃኖ ታኣኒ ዒንሢም ኬኤዛ ዓይሢፆ ካፑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","ዒንሢ ዮርዳኖሴ ዎሮና ፒንቂ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንጋ ዓጮ ጌሌ ዎዶና ዼኤፒ ዼኤፒ ሹቺ ዻካ ዔኪጋፓ ዻኣቦ ዻኣቢ ቦኦሪንቶና ዑፆ ቲሽኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ማሎ ዓጬሎ ዒንጋኒ ዒንሢም ጫኣቄ ጎይፆና ዓጬሎ ዒንሢ ዻካላኒ ዎሮና ፒንቄ ዎዶና ሃንሢ ዎጎንሢ ሹዎ ዑፃ ፃኣፑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","ዮርዳኖሴ ዎሮና ፒንቃዖ ሃኖ ታኣኒ ዒንሢ ዓይሤ ጎይፆ ዬንሢ ሹጮንሢ ዔባኣሌ ዹኮይዳ ዻኣቢ ቦኦሪንቶና ቲሽኩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","ዓንጊና ዓርሲንቲባኣ ሹቺ ዔኪ ፆኦሲም ሚቺ ዒንጎ ቤሲ ኮሹዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ኮሻ ዒንጎ ባኮ ዒንጎ ቤዛ ቢያ ዓርሲንቲባኣ ሹቺና ኮሺንቴያ ማዓኒ ኮይሳኔ፤ ዒኢካ ሚቺ ዒንጎ ባኮ ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","ፔቱሞና ዒንጎ ዒንጊፆ ዒንጊ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓኣ ቤዞይዳ ሙይ ሙይ ዎዛዹዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","ዬንሢ ቦኦሪንታሢና ቲሽኪንቴ ሹጮንሢዳ ናንጊና ናንጋ ጎዳኮ ዎጎ ቢያ ዔርቲ ናባቢንታንዳጉዲ ማሂ ፃኣፑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","ሃሣ ሙሴ ሌዊ ዓሶ ማዔ ቄኤሶና ዎላ ማዒ ዒስራዔኤሌ ዴሮም ቢያ፦ «ዒስራዔኤሌ ዓሲዮቴ! ታ ጋዓሢ ዒናፓ ዋይዙዋቴ፤ ሃይሾ ሃኖ ዒንሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዴሬ ማዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ኬኤዜ ባኮ ዋይዚ ዓይሢንታያ ማዑዋቴ፤ ታኣኒያ ሃኖ ዒንሢም ዓይሣ ዓይሢፆንታ ዳምቦንታ ካፑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","ዬኖ ኬሎና ሙሴ ዒስራዔኤሌ ዴሮም፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","«ዮርዳኖሴ ዎሮና ዒንሢ ፒንቄስካፓ ዴራ ዓንጆ ዓንጂንታ ዎዶና ጌሪዛኔ ዹኮይዳ ኬስኪ ዔቂ ዓንጃንዳዞንሢ፦ ሲሞኦኔ፥ ሌዊ፥ ዪሁዳ፥ ዪሳኮኦሬ፥ ዮሴፔንታ ቢኢኒያሜ ማኣሮ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","ጋዳማ ጋዳንቂንታ ዎዶና ዔባኣሌ ዹካ ጋዳንቃንዳዞንሢ፦ ሮኦቤኤሌ፥ ጋኣዴ፥ ዓሴኤሬ፥ ዛብሎኦኔ፥ ዳኔንታ ኒፕታኣሌኤሜ ማኣሮ ዓሶንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","ዒማና ሌዊ ዓሳ ዑኡዞ ፔኤኮ ዼጊዲ ሃካፓ ሊካ ኬኤዚንቴ ባኮ ጎዖንጎ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","« ‹ዓሲ ፔ ኩቻ ማዤ ባኣዚ፥ ፆኦሲ ዒፃያ ማዔ ካኣሽኮ ባኣዚ ማዢ ዓኣቺ ዴሚና ካኣሽካ ዓሲ ጋዳቂንቴያ ማዖንጎ!› ጋዓዛ ዴራ ቢያሢ ዒማና ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","« ‹ዓዶና ዒንዶና ቦሃ ዓሲ ጋዳንቂንቴያ ማዖም!› ጋዓዛ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","« ‹ፔ ዓሺናሢኮ ዛጳ ዾቂንቲ ዓኣ ሹጮ ሺኢሻ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","« ‹ዓኣፒ ባይቄ ዓሲ ጎይሢ ዣኣሊሲሲ ዳካ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","« ‹ዓሲኬ ጎዑዋዖ ሜሌ ዓጪፓ ሙኬ ዓሶንታ ዜኤሮ ናኣቶንታ ዜኤሮ ዒንዶንሢንታ ሜታሳ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","« ‹ዒንዶ ሌጎ ማዓያና ላሂ ዓዶ ዻውሲሳ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","« ‹ዓይጎ ዓሲያ ማዖም ቆልሞ ዒኢሳ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","« ‹ፔኤኮ ጌሮና፤ ሃሣ ዓዶታቴያ ዒንዳ ሜሌፓ ሾዔ ጌሮና ላሃ ዓቲንቄ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","« ‹ባይሶና ዎላ ላሃ ዓቲንቄ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","« ‹ዓሲ ካቲ ዴዒ ዎዻ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","« ‹ሚኢሼና ሻንቂንቲ ፒዜ ዓሲ ጉሪ ዎዻ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","« ‹ናንጊና ናንጋ ጎዳኮ ዎጋ ጋዓ ሃያ ባኮ ቢያ ማዺ ኩንሡዋ ዓሲ ቢያ ጋዳንቂንቴያ ማዖም!› ጋዓዛ፥ ዴራ ቢያሢ ‹ማዓንታኣ!› ጎዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","ሙሴ ዒስራዔኤሌ ዓሶም ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ዓይሢንቴቴ፥ ሃሣ ሃኖ ታኣኒ ዒንሢም ዓይሣ ዓይሢፆ ቢያ ጉሙርቂንታያ ማዒ ዒንሢ ካፔቴ ዓጮይዳ ናንጋ ሃንጎ ዴሮይዳፓ ቢያ ዑሣ ማሂ ዒንሢ ዒዚ ዼግ ዼጊዳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ዓይሢንቴቴ ሃካፓ ሊካ ኬኤዚንታ ዓንጃ ዒንሢሮ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","«ናንጊና ናንጋ ጎዳ ዒንሢኮ ካታሞንታ ጎዦንታ ቢያ ዓንጃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","«ናንጊና ናንጋ ጎዳ ዒንሢም ናይ፥ ጎሽካ ጎዣፓ ሃኣኮ፥ ባይ፥ ማራይንታ ዋኣሪንታ ዒንጊ ዒንሢ ዓንጃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","«ናንጊና ናንጋ ጎዳ ዒንሢ ጎሽካ ሃኣኮንታ ዒኢፓ ዔኪ ዲርካ ዺኢሎንታ ዓንጃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","«ማኣራ ዒንሢ ዓኣቴያ ኬስኪ ማዻ ቤዞይዳኣ ቢያ ናንጊና ናንጋ ጎዳ ዒንሢ ዓንጃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","«ሞርካ ሙኪ ዒንሢ ዖላኣና ናንጊና ናንጋ ጎዳ ዔያቶ ባሺንቲሳንዳኔ፤ ዔያታ ፔቴ ዛላና ሙካንዳኔ፤ ጋዓንቴ ቢያ ካራና ጳሽኪ ጳሽኪ ዴንዲ ባይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","«ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦዛሢ ዒንሢ ማዼ ማዾና ዓንጄም ኮና ቢያ ሃኣኮና ኩማንዳኔ፤ ሃሣ ዒንሢ ናንጋ ዓጮይዳኣ ዒንሢ ዒ ዓንጃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዓይሢንቲ ዒዚ ዓይሤ ባኮ ቢያ ማዺ ዒንሢ ኩንሤቴ ዒዚ ቤርታ ጫኣቄ ጎይፆና ፔኤም ዱማዼ ዴሬ ዒንሢ ዒ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","ዬካፓ ሳዖይዳ ናንጋ ዴራ ቢያ ዒንሢ ናንጊና ናንጋ ጎዳ ዴሬ ማዔሢ ዛጊ ዒጊጫንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጋኒ ዒንሢኮ ቤርታኣ ዓዶንሢም ጫኣቄ ዓጮይዳ ሚርጌ ናይ፥ ሚርጌ ባይንታ ዑሣ ዓኣዼ ሚርጋ ሃኣኮዋ ዒንሢም ዒንጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","ጫሪንጮይዳ ዒዚ ቃዚ ጌሤ ቤዛፓ ዒሮ ኮይሳ ዎዶና ዒንሢም ዋርቂሲ ዒንሢ ማዻ ባኮና ዒንሢ ዓንጃንዳኔ፤ ዬያሮ ዒንሢ ሃንጎ ሚርጌ ዴሮም ታልዓንዳኔ፤ ጋዓንቴ ዒንሢ ዖ ጊዳፓኣ ታልዒ ዔካዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሃንጎ ሚርጌ ዴሮ ባኣኮይዳ ቶኦኪ ዒንሢ ማሃንዳኣፓዓቴም ዑንኪ ማዒ ጊንፃ ዓታንዳጉዲ ማሃዓኬ፤ ሃኖ ታ ዒንሢም ዓይሣ፥ ናንጊና ናንጋ ጎዳኮ ዓይሢፆ ጉሙርቂንቲሢና ማዺ ዒንሢ ኩንሤቴ ፔቴታዖ ሜታ ዒንሢ ሄሉዋንቴ ቤርቲም ዒንሢ ዴንዳንዳኔ፤ ጊንሢም ዓታዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","ጋዓንቴ ዓይጎዋ ማዖም ሃንሢ ዓይሢፆ ሃሺ ሜሌ ፆኦዞም ዚጋንዳያና ዬያም ማዻንዳያ ዒንሢ ኮይሱዋሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","«ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዒንሢ ዓይሢንቲባኣቴ፤ ሃሣ ታኣኒ ሃኖ ዒንሢ ዓይሣ ዓይሢፆንታ ዎጎንታ ጉሙርቂንቲ ማዺ ዒንሢ ኩንሢባኣቴ ሃካፓ ሊካ ኬኤዚንቴ ጋዳማ ዒንሢ ሄላንዳኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","«ዒንሢኮ ካታሞንታ ጎዦንታ ጋዳንቂንቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","«ዒንሢ ጎሽካ ሃኣኮንታ ዒኢፓ ዔኪ ዒንሢ ዲርካ ዺኢሎንታ ጋዳንቂንቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","«ዒንሢኮ ናኣታኣ፥ ጎሽካ ጎዣ፥ ባኣታ፥ ማራቶንታ ዋኣሮንታ ጋዳንቂንቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","«ማኣራ ዒንሢ ዓኣቴያ ኬስኪ ማዻቴያ ጋዳንቂንቴያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","«ፑርታ ባኣዚ ዒንሢ ማዺ፥ ናንጊና ናንጋ ጎዳ ዒንሢ ሃሼሢሮ ኔጉዋዖ ጋፒ ዒንሢ ባይቃንዳጉዲ ዒንሢ ማዻ ባኮ ቢያ ዒንሢኮ ዒ ጋዳንቃንዳኔ፥ ማሊፆ ዒንሢኮ ዣኣሊሳንዳኔ፥ ዒንሢ ዒ ቦርሲሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ዒንሢ ዻካላኒ ጌላ ዓጬሎይዳፓ ጋፒሲ ዒንሢ ዒ ባይዛንዳያ ሄላንዳኣና ሃሹዋ ፑርታ ዶርዖ ናንጊና ናንጋ ጎዳ ዒንሢዳ ዓጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","ናንጊና ናንጋ ጎዳ ዒንሢዳ ዖኦፒሳ ዶርዖ፥ ቆሢ፥ ኪሢ፥ ዖይዺ ሚሚቻ ዓቢንታ ሉማንታ ዳካንዳኔ፤ ሃኣኮ ዒንሢኮ ባይዛኒ ቃኣዮና ዬያጉዴያ ሃኣኮ ዎዻ ባኮ ዒ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ሌካ ጫሪንጫ ዒንሢም ዒሮ ዋርቂሱዋጉዲ ሞኦና ዓንጊ ማሂ ዒ ዶዲሻንዳኔ፤ ሳዖዋ ሜልዚ፥ ዓንጊ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","ናንጊና ናንጋ ጎዳ ዒራ ዋርቃንዳ ቤዞ ዒንሢዳ ዼኤፒ ዢባሬ ዔኪ ሙካ ሲላሊና ማኣሻላና ዳካንዳኔ፤ ዬያ ዒ ማዻሢ ዒንሢ ባይዛኒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","«ናንጊና ናንጋ ጎዳ ዒንሢኮ ሞርካ ዒንሢ ባሻንዳጉዲ ማሃንዳኔ፤ ፔቴ ዛላና ዒንሢ ዔያቶይዳ ዖሎ ቡላዖ ዔያቶይዳፓ ቶላኒ ቢያ ዛሎና ጳሽኪ ጳሽኪ ዒንሢ ዴንዳንዳኔ፤ ሳዖይዳ ናንጋ ሃንጎ ዴራ ቢያ ዒንሢዳ ማዺንታ ባኮ ዛጊ ዒጊጪ ዲቃታንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","ዒንሢ ሃይቃዛ ሌዞ ዒንሢኮ ካዮ ቦዖና ካፖና ሙዓንዳኔ፤ ዬያ ባኮ ላኣጋንዳ ዓሲያ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","ናንጊና ናንጋ ጎዳ ጊብፄ ዓሶይዳ ማዼሢጉዲ ዻርጬ ዶርዖንታ ፖዑዋ ኪሢንታ ዑፆይዳ ዋኣጪሳ ዶርዖ፥ ሃሣ ዒላንቶዋ ዒንሢዳ ዓጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","ናንጊና ናንጋ ጎዳ ማሊሢ ባይዛ ዣኣሹሞና ዓኣፒ ዒንሢኮ ባይዛ ባኣዚ ዒንሢዳ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","ዓቦ ዹኡዞይዳ ዓኣፒ ባይቄ ዓሲጉዲ ዒንሢ ዹቂንታንዳኔ፤ ዒንሢ ዴንዳ ጎይፆዋ ዒንሢ ዴንቃዓኬ፤ ዒንሢ ማዻ ባካ ቢያ ዒንሢም ጊኢጋዓኬ፤ ቢያ ዎዴ ሄርቂንቲ ዎርቂሢና ዓሲ ዒንሢ ባኣዚ ሙዓያ ዒንሢ ማዓንዳኔ፤ ዒንሢ ዓውሳንዳ ዓሲ ዒንሢ ዴንቃዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","«ዔካኒ ዒንሢ ዖኦጫ ዉዱሬሎ ሜሌ ዓሲ ላሂ ዒኢሳንዳኔ፤ ማኣሪ ዒንሢ ማዣንዳኔ፤ ጋዓንቴ ዒኢካ ዒንሢ ናንጋዓኬ፤ ዎይኖዋ ዒንሢ ቱካንዳኔ፤ ጋዓንቴ ዓኣፖ ዒንሢ ሙዓዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","ዒንሢኮ ባኣታ ዒንሢኮ ቤርታ ዒንሢ ዛጋንቴ ሹኪንታንዳኔ፤ ጋዓንቴ ዓሽኮ ዒንሢ ኩኡሊታዖ ዛጋዓኬ፤ ሃራ ዒንሢኮ ዒንሢ ዛጋንቴ ጎቺንቲ ዔውታንዳኔ፤ ጋዓንቴ ማሂ ዒንሢም ዒንጊንታዓኬ፤ ዒንሢኮ ማራታ ሞርኮም ዒንሢኮ ዓኣሢንቲ ዒንጊንታንዳኔ፤ ዬያቶ ማሃኒ ዒንሢ ማኣዳንዳ ዓሲ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","ዒንሢ ዛጋንቴ ዒንሢኮ ዓቲንቆ ናኣቶንታ ዉዱሮ ናኣቶንታ ሜሌ ዓጪ ዓሲም ዒንጊንታንዳኔ፤ ዒንሢ ጋዓንቴ ናኣታ ኑኡኮ ‹ማዓንዳኣ ናንዳኔ› ጌዒ ጉሪ ጎይሢ ዛጊ ላባንዳኔ፤ ፔቴታዖ ዒንሢ ዎኦታንዳ ባኣዚ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","ሚርጌ ዒንሢ ላቢንቲ ጎሽኬ ሃኣኮ ዒንሢ ዔሩዋ ሜሌ ዓጪ ዓሲ ዔኪ ሙዓንዳኔ፤ ዒንሢኮ ጋዓንቴ ዒንሢ ናንጋ ዎዶይዳ ቢያ ጌኔ ማዾና ሄርቂንቲ ዎርቂሢናይዳፓ ዓታዛ ሜሌ ባኣዚ ባኣያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","ዬይ ዒንሢ ዛጋ ባካ ቢያ ዒንሢ ዣዣኣሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","ናንጊና ናንጋ ጎዳ ዞኦሎና ጉባዞናይዳ ፖዑዋ ኪሢ ባይዚ ኬስካንዳጉዲ ማሃንዳኔ፤ ፑርታ ኪሢንታ ኪኪፃ ባኣዚንታ ቶኦኮ ጋፓናፓ ዴንዲ ቶኮ ፁንጎ ሄላንዳኣና ዒንሢኮ ባይዚ ኬስካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","«ናንጊና ናንጋ ጎዳ ዒንሢንታ ዒንሢኮ ካኣታሢንታ ሃያኮ ቤርታ ዒንሢኮ ቤርታኣ ዓዶንሢ ማዔቴያ ዒንሢያ ናንጊ ቤቂባኣ ሜሌ ዓጪ ቤቲሲ ዳካንዳኔ፤ ዒኢካ ሚሢና ሃሣ ሹቻ ኮሾና ሜሌ ፆኦሲ ዒንሢ ካኣሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","ናንጊና ናንጋ ጎዳ ዒንሢ ዜርቂ ዳካ ዓጮይዳ ናንጋ ዴራ ቢያ ዒንሢዳ ማዺንቴ ባኮ ዛጊ ዲቃታንዳኔ፤ ዔያታ ዒንሢ ሚኢጪ ዓማሎ ባኣዚ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","«ዒንሢ ጎሽኬ ሃኣኮ ዓቢሢ ሙዓንዳሢሮ ሚርጌ ሃኣኮ ዒንሢ ዜርቄዖ ዻካ ሃኣኮ ዒንሢ ዔካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","ዎይኖዋ ዒንሢ ቱኪ ዓጮ ኮሺ ኮሺ ዛጋንዳኔ፤ ጋዓንቴ ዬያ ዛኣሌ ሙዓንዳሢሮ ዎይኖ ዓኣፖ ሱፆና ዎላ ቲቂ ዒንሢ ዔኪ ሙዓዓኬ፤ ሃሣ ዑሺ ኮሺያ ዒንሢ ዑሽካዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","ዛይቶ ሪሚቶ ሚፃ ዒንሢኮ ሳዖ ቢያይዳ ባቃላንዳኔ፤ ጋዓንቴ ዓሜ ዓማ ዎዳ ሄሉዋንቴ ዲኢኒ ጋፓንዳሢሮ ሪሚቲ ዛይቴ ዒንሢ ዴንቃዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","ዓቲንቄንታ ዉዱሮ ናይንታ ዒንሢ ሾዓንዳኔ፤ ጋዓንቴ ዖልዚና ዲዒንቲ ዔያታ ዔውታንዳሢሮ ዒንሢና ዎላ ናንጋዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ዒንሢኮ ሚፆንታ ጎዦይዳ ዓኣ ሃኣኮንታ ቢያ ዓቢፆ ማካሢ ሙዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","«ዒንሢኮ ዎልቃ ላቢ ላቢ ዴንዳዛ፥ ዒንሢ ዓጮይዳ ናንጋ ሜሌ ዓጮ ዓሶ ዎልቃ ጋዓንቴ ዶዲ ዶዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","ሜሌ ዓጫፓ ሙኬ ዓሳ ዒንሢም ሚኢሼ ታልዓያ ማዓንዳኔ፤ ጋዓንቴ ዒንሢ ዔያቶም ታልዓንዳ ሚኢሼ ዒንሢኮ ባይቃንዳኔ፤ ጋፒንፆይዳ ዔያታ ዒንሢኮ ቤርታዻ ቶኦኪ ማዓንዳኔ፤ ዒንሢ ጋዓንቴ ዑንኪ ማዒ ጊንፃ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","«ዒንሢ ዒንሢኮ ፆኦዛሢም ዓይሢንታያ ማዒባኣሢሮ፤ ሃሣ ዒዚ ዓይሤ ዳምቦና ዓይሢፆና ዒንሢ ካፒባኣሢሮ ዬይ ቢያ ዶርዓሢ ዒንሢዳ ሙካንዳኔ፤ ዒንሢ ጋፒ ባይቃንዳያ ሄላንዳኣና ዒንሢፓ ሺኢካዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","ዬይ ቢያ ዒንሢንታ ዒንሢኮ ዜርፆናይዳ ዒንሢ ዻቢንቴሢሮ ናንጊና ናንጋ ጎዳ ዔኪ ሙኬ ሜቶ ማዒ ናንጊና ጶቂ ጶቂ ናንጋ ማላታ ዒንሢም ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","ናንጊና ናንጋ ጎዳ ዒንሢ ሚርጌ ካራና ዓንጄያታንቴ ዒንሢ ዒናፓ ዎዛዺ ዒዛም ማዺባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ዬያሮ ሃካፓ ሴካ ናንጊና ናንጋ ጎዳ ዒንሢዳ ዳካ ሞርኮኮ ዒንሢ ዓይሌ ማዓንዳኔ፤ ቢያ ባኣዚና ሜታዺ ዒንሢ ናይዺንታዳኔ፤ ዼኤቢንታንዳኔ፤ ሃሣ ካላዻንዳኔ። ጋፒ ዒንሢ ባይቃንዳያ ሄላንዳኣና ዴኤፃ ዓንጊ ቃምባራ ባቃናይዳ ዓጎናጉዲ ዒንሢኮ ሞርካ ዒንሢ ዎይሣ ዎይሢፆና ሄርቂ ዒንሢ ዎይሣንዳጉዲ ናንጊና ናንጋ ጎዳ ዒንሢ ሃሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","ናንጊና ናንጋ ጎዳ ዒንሢዳ ሙኡቺ ዒንሢ ዔሩዋያ ሚርጌ ዖላ ዴሬ ሃኬ ዓጪፓ ዔኪ ሙካንዳኔ፤ ዔያታ ዒንሢዳ ኮኦኬጉዲ ኬዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","ዔያታ ጋርቾ ቦንቹዋያ፥ ናኣቶዋ ሚጪንቱዋ ፑርታ ዓሲ ማዒ ዒንሢዳ ዔቃንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","ዔያታ ዒንሢኮ ባኣቶንታ ሃኣኮንታ ቢያ ፒፂ ሙዓንዳሢሮ ዒንሢ ሃይቃንዳያ ሄላንዳኣና ናይዚና ሜታዻንዳኔ፤ ዔያታ ሃኣኮይዳፓ ፔቴ ዓኣፒታዖ፤ ሃሣ ዎይኖንታ ዛይቶ ሪሚቶ ሚፆ ዓኣፖይዳፓ ፔቴ ዓኣፒታዎ ዓይሳዓኬ። ዬያጉዲ ባኣቶንታ ማራቶንታ ጋፒሲ ዒንሢኮ ሙዓንዳሢሮ ዒንሢ ካፓማ ሃይቢ ሌሊ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጋ ዓጮይዳ ዒንሢ ናንጋ ዒንሢኮ ካታሞ ዔያታ ዖሊ፤ ዒንሢ ጉሙርቃ ዼጌ ኬኤሎ ዲፆ ዒንሢኮ ዔያታ ዶይሲ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","«ዒንሢኮ ሞርካ ካታሞ ዒንሢኮ ማንጊ ዒንሢ ሜታሴም ሙዖንዶ ባኣዚ ዒንሢ ባይዚ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢም ዒንጌ ዒንሢኮ ዓቲንቆ ናኣቶና ዉዱሮ ናኣቶ ዒንሢ ሙዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","ዒንሢ ባኣካ ኮሺ፥ ሃሣ ዓሲ ሚጪንታያ ማዔ ዓሲታዖ ፔኤኮ ጌርሲም፥ ፔ ማቾም ሃሣ ሃይባፓ ዓቴ ናኣቶም ማዔቴያ ዬያ ዒ ሙዓሢ ዒንጎ ዒፂ ዱኡዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","ዓሲም ካራ ባይዚ፥ ካታሞ ቢያሢ ሞርካ ዒንሢኮ ማንጋ ዎዶና ሜሌ ሙዖ ባኣዚ ባኣያ ማዓንዳሢሮ ናዖ ሙዓ ዓሢ ሙዓ ዓሽኮይዳፓ ሜሌ ዓይጎ ዓሲማኣ ዒንጊንዱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","ዒንሢ ባኣኮይዳ ሜታ ባኣዚ ባኣያ ማዔም ዖቶርቂ ናንጋያ፤ ሃሣ ቶኪና ሳዓ ሄርቁዋ ላኣሌላ ዒዞኮ ዓኒንታ ናኣቶንታም ዱኡዻያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","ዓሲም ካራ ባይዚ፥ ካታሞ ቢያሢ ሞርካ ዒንሢኮ ማንጋ ዎዶና ሜሌ ሙዖ ባኣዚ ፔቴታዖ ባኣያ ማዓንዳሢሮ ዒዛ ዓኣቺ ሙዓ ፔኤኮ ናዖና ቢኢዞና ሜሌ ዓይጎ ዓሲማኣ ዒንጋዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","«ሃያ ማፃኣፖይዳ ፃኣፒንቴ፥ ናንጊና ናንጋ ጎዳኮ ዓይሢፆ ጉሙርቂንቲ ማዺ ዒንሢ ኩንሢባኣቴ፤ ሃሣ ዲቃሢ ሄርሺሳያና ዒጊቻያ ማዔ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢኮ ሱንፆ ዒንሢ ቦንቺባኣቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","ናንጊና ናንጋ ጎዳ ዒንሢንታ ዒንሢኮ ናኣቶንታይዳ ዒጊቻያ፥ ሚርጌ ዎዴ ዒንሢ ሜታሲ ዴዓንዳ ፑርታ ዶርዖ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","ጊብፄ ዓጮ ዓሶይዳ ኬዴም ዒንሢ ዛጊ ዒጊጬ፥ ዬያ ፑርቶ ዶርዓሢ ቢያ ናንጊና ናንጋ ጎዳ ዒንሢዳ ጊንሣ ሃሣ ዳካንዳኔ፤ ዬያ ዶርዓሢዳፓ ዒንሢ ፖዒያ ፖዓዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","ዬያ ሌሊቱዋንቴ ናንጊና ናንጋ ጎዳኮ ዎጋ ፃኣፒንቴ፥ ሃያ ማፃኣፖይዳ ኬኤዚንቲባኣ ዶርዖና ዱማ ዱማ ዎዻ ዶርዖ ቢያ ዒንሢ ባይዛኒ ዒዚ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢም ዓይሢንታያ ዒንሢ ማዒባኣሢሮ ሚርጉማ ዒንሢኮ ጫሪንጮ ዉጫሢጉዲ ማዔቴያ ዒንሢዳፓ ዻካ ዓሲ ሌሊ ዓታንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","ናንጊና ናንጋ ጎዳ ዒንሢ ዓርጎጪሳኣና፥ ሃሣ ዒንሢ ሚርጊሻ ዎዶናኣ ዎዛዼሢጉዲ ዒንሢ ዒ ባይዛ ዎዶናኣ ዒማዺ ዒ ዎዛዻንዳኔ፤ ዬኖ ዒንሢ ዻካላንዳ ዓጬሎይዳፓ ጋፒ ዒንሢ ባይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","«ናንጊና ናንጋ ጎዳ ዒንሢ ሳዖኮ ዓይፃፓ ዴንዲ ጋፖ ሄላንዳኣና ሃንጎ ዴሮ ባኣካ ዜርቃንዳኔ፤ ዒኢካ ዒንሢ ናንጋ ዎዶና ዒንሢንታ ዒንሢኮ ቤርታኣ ዓዶንሢንታ ዚጊ ካኣሽኪ ቤቂባኣ ሚሢና ሹቺና ዓርሲ ኮሾና ሜሌ ፆኦሲ ዒንሢ ካኣሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","ዬያ ዴሮ ባኣኮይዳ ሃውሾ ዒንሢኮ ባኣያ፥ ሃሣ ቶኪ ሄርቃንዳጉዴ ቤሲታዖ ዒንሢኮ ባኣያ ማዓንዳኔ፤ ናንጊና ናንጋ ጎዳ ዒንሢም ዒጊጫ ዒና፥ ‹ዔኤቢ ዴንቃንዳኔ› ጌይ ጎይሢ ዛጊ ላባ ዓኣፒ፥ ሃጊ ማዓንዳ ዎዛባኣ ዓሲ ማሃ ማሊሢ ዒንጋዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","ናንጋ ዒንሢኮ ቢያ ዎዴ ሜታዺ ማሊሢና ማዓንዳኔ፤ ዒንሢኮ ሼምፓሢ ‹ሃይቃንዳኔ› ጌይ ዓልቲ ዓልቲ ዒንሢ ናንጋንዳሢሮ ዋንቶና ሮኦሮና ቢያ ዒንሢ ዒጊቹሞና ናንጋዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","ዒንሢ ዛጋ ባካ ቢያ ዒንሢ ዲቃሣያ ማዓንዳሢሮ ካራዛ ‹ዓይዴ ዓማንዳይ?›፥ ሃሣ ዓማዛ ‹ዓይዲ ካራንዳይ?› ዒንሢ ጋዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","ናንጊና ናንጋ ጎዳ ዒንሢም፦ ‹ላሚ ዒንሢ ጊንሣ ዬካ ዴንዲንዱዋሴ› ጌይ ኬኤዜያ ማዔቴያ ዋኣፆ ካኣሚሎ ቶጊ ጊብፄ ዓጮ ዒንሢ ዴንዳንዳጉዲ ዒ ማሃንዳኔ፤ ዒኢካ ዒንሢ ዒንሢ ዓይሌ ማሂ ሻንቻኒ ኮዓንዳኔ፤ ጋዓንቴ ዓይሌ ማሂ ዒንሢ ሻንቃንዳ ዓሲ ዒንሢ ዴንቃዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","ናንጊና ናንጋ ጎዳ ሲና ዹኮ ኮይላ ዒስራዔኤሌ ዓሶም ማዻኒ ጫኣቄ ጫኣቁሞይዳ ቃሲ፥ ሞዓኣቤ ዓጮይዳ ሙሴ ዒስራዔኤሌ ዓሶም ጫኣቃንዳጉዲ ዓይሤ ጫኣቁማ ሃካፓ ሊካ ኬኤዚንታሢኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","ሙሴ ዒስራዔኤሌ ዴሮ ዔኤሊ ፔቴይዳ ቡኩሳዖ፦ «ናንጊና ናንጋ ጎዳ ጊብፄ ዓጮ ካኣቲንታ ሱኡጎ ማዒ ማዻ፥ ዼኤፖ ዼኤፖ ዓሶንታ ዓጮ ቢያሢንታይዳ ማዼ ባኮ ቢያ ዒንሢ ዒንሢ ዓኣፒና ዛጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","ናንጊና ናንጋ ጎዳ ዔያቶይዳ ዓጌ፥ ፑርቶ ዎዻ ዶርዓሢንታ ዒዚ ማዼ ፔ ዎልቆና ማዺንታ ዓኮ ባኮንታ ዲቃሢ ሄርሺሳ ባኮዋ ቢያ ዒንሢ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ናንጊና ናንጋ ጎዳ ጋዓንቴ ሃሢ ሃኖ ሃይማ ሄላንዳኣና ዒንሢ ሃንቲ ሙኬ ጎይፆ ዛጋ ዓኣፒ፥ ዬያ ዛሎ ዋይዛንዳ ዋይዚና ማላ ዒኔና ዒንሢም ዒንጊባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","ዖይዲታሚ ሌዔ ጉቤ ዓሲ ናንጉዋ ዳውሎይዴና ናንጊና ናንጋ ጎዳ ዒንሢ ዔኪ ዴንዳኣና ማኣዓሢያ ዒንሢኮ ጪንቂ ዳርዒባኣሴ፤ ዱርዛኣ ዒንሢኮ ጪንቂ ዱጲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","ዒንሢ ጎይፆይዳ ካሣ ዴንቂ ሙዒባኣሴ፥ ዑሽኮ ዑሺንታ ማሣ ዑሺያ ዑሽኪባኣሴ፤ ናንጊና ናንጋ ጎዳ ዒንሢኮ ፆኦሲ ማዔሢ ዔርዛኒ ኮይሳ ባኮ ቢያ ዒንሢም ዒ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","ሃይካ ኑኡኒ ሄላዛ ሃሴቦኦኔ ካኣቲ ሲሆኔና ባኣሳኣኔ ካኣቲ ዖኦጌና ኑና ዖላኒ ኬስኬኔ፤ ጋዓንቴ ዖሎና ኑ ዔያቶ ባሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","ዓጮ ዔያቶኮ ኑ ዔኪ፥ ሮኦቤኤሌና ጋኣዴ ማኣሮ ዓሶናም፤ ሃሣ ዬያጉዲ ሚናኣሴ ማኣሮ ዓሶኮዋ ዛሎም ዔያቶ ዓጪ ማዓንዳጉዲ ጊሽኪ ኑ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","ዬያሮ ዒንሢ ማዻ ባካ ቢያ ዒንሢም ጊኢጋንዳጉዲ ሃያ ጫኣቆና ጫኣቁሞ ጋራ ዓኣ ዓይሢፆ ቢያ ዛጊ ማዺ ኩንሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","11","«ሃይሾ፥ ዒንሢ ፔቴ ፔቴ ማኣሮ ዓሶኮ ሱኡጎና ዴሮኮ ጪማ፥ ዱማ ዱማ ሱኡጋ፥ ሃንጎ ዓቴ ዓሶንታ ዒንሢኮ ናኣቶንታ ዒንሢ ናንጋ ጉርዶይዳ ናንጊ ናንጊ ዒንሢም ሃንፂሎ ሃኣኪ፥ ዋኣፆ ዱዓያ ሜሌ ዓጫፓ ሙኬ ዓሶንታ፤ ዒንሢ ቢያሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ሃኖ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","ዒንሢ ሃይካ ዔቄሢ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢና ዎላ ጫኣቁሞ ጫኣቃኒኬ፤ ሃሣ ዒዛና ዎላ ዒንሢ ጫኣቃ ባኮ ማዺ ኩንሣኒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","ናንጊና ናንጋ ጎዳ ዬያ ማዼሢ ዒንሢም ዒዚ ‹ማዻንዳኔ› ጌይ ጫኣቄ ጎይፆና ሃሣ ዒንሢኮ ዓዶንሢ፥ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታ ዎላ ጫኣቄ ጎይፆና ዒንሢ ዒ ፔ ዴሬ ማሂ ዶኦሬሢ ዔርዛኒኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","ዒዚ ዬያ ቢያ ጫኣቁሞ ጫኣቃሢ ዒንሢና ዎላ ሌሊቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","ዒዚ ዬያ ጫኣቃሢ ሃኖ ሃይካ ዒዛና ዎላ ዔቂ ዓኣ ኑና ቢያሢንታ ሃጊ ኑጊዳፓ ሾይንታንዳ ዜርፆ ቢያሢንታም ዎላኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","«ጊብፄ ዓጮይዳ ዎዚጉዴ ናንጊ ዒንሢ ናንጌቴያ፤ ሃሣ ሜሌ ዓሶ ዓጮይዴና ቲቂ ዴንዲፃ ዎማዒ ዒንሢም ሜቴቴያ ዒንሢ ዔራኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","ዔያቶኮ ሻኣካያ ማዔያ ጌይፃ፦ ሚሢ፥ ሹቺ፥ ቢራ ዓንጊንታ ዎርቄንታይዳፓ ኮሾና ሜሌ ፆኦዞ ዒንሢ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","ሃይካ ሃሢ ዒንሢ ዔቂ ዓኣ ዓሶይዳፓ ዓቲንቄ ማዔቴያ ላኣሊ፤ ፔቴ ማኣሪ ዓሲ ማዔቴያ ፔቴ ቶኦኪ፤ ናንጊና ናንጋ ጎዳ ኑ ፆኦዛሢ ሃሺ ሜሌ ዴራ ካኣሽካ ፆኦዞ ካኣሽኩዋጉዲ ዒንሢና ዔሩዋቴ፤ ዒንሢ ባኣካ ዬያጉዴያ ዎዻ ባኣዚ፥ ጊንሣ ሃሣ ጫጫንቃያ ማዔ ማዾ ማዻ ዓሲ ባኣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","ዬያጉዴ ዓሲ ሃያ ጋዳሞ ዑኡዞ ዋይዜያታዖ፦ ‹ዓይጎዋ ማዖም ታ ኮዔ ጎይፆ ናንጌቴ ዻቃንዳኔ› ጌዒ ፔ ዒኖና ማሌቴ ኮዦ ዓሶንታ ፑርቶ ዓሶንታይዳ ባይሲንታ ዒ ዔኪ ሙካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","ናንጊና ናንጋ ጎዳ ዬያጉዴ ዓሲም ዓቶም ጎዑዋሴ፤ ዒዛኮ ዻጋ፥ ሃሣ ዒዛ ሃሺ ሜሌ ካኣሽኪሢ ኮዑዋያ ማዔ ማሊፃ ታሚጉዲ ዬያ ዓሢዳ ዔኤታንዳኔ፤ ናንጊና ናንጋ ጎዳ ዬያጉዴ ዓሢ ጋፒ ባይቃንዳጉዲ ሃያ ማፃኣፖይዳ ፃኣፒንቴ ዱማ ዱማ ዎዻ ዶርዓሢ ቢያ ዒዛይዳ ዓጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","ናንጊና ናንጋ ጎዳ ዬያጉዴ ዓሢ ሃያ ዎጎ ማፃኣፖይዳ ፃኣፒንቴ ጋዳሞ ጫኣቁሞ ጎይፆጉዴያና ዒስራዔኤሌ ዓሶ ባኣካፓ ኬሲ ባይዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","«ሃጊ ዒንሢኮ ሙካንዳ ዜርፆንታ ሜሌ ዓጫፓ ሙኬ ዓሳ ናንጊና ናንጋ ጎዳ ዒንሢ ዓጮይዳ ዓጌ ባይሲንቶና ዎዻ ዶርዓሢና ዛጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","ዒንሢኮ ሳዓ ጋፒ ሚጬያ፥ ሃሣ ሶኦጌ ኬስኪ ላሃያ ማዓንዳኔ፤ ፔቴታዖ ዒኢካ ዔኤቢ ቱኪንታዓኬ፤ ባቃላንዳ ባኣዚያ ባኣሴ፤ ዒንሢኮ ዬይ ሳዓ ናንጊና ናንጋ ጎዳ ፔኤኮ ዼኤፖ ዻጎና ባይዜ፥ ሴዶሜንታ ጋሞራንታ ዓዳኣማንታ ፂባዮንታጉዲ ማዒ ዓታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","ዬይ ያዺ ማዔ ዎዶና ሳዖይዳ ዓኣ ሃንጎ ዴራ ቢያ፦ ‹ናንጊና ናንጋ ጎዳ ሃኖ ዓጮይዳ ሃያ ቢያ ዓይጎሮ ማዼይ? ዒዛ ሃያይዲ ዒናፓ ዻጋሴሢ ዓይጎዳይ?› ጌይ ዖኦጫንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","ዬያ ዖኦጪፆኮ ማሂፃ፦ ‹ዔያቶኮ ቤርታኣ ዓዶንሢ ፆኦዛሢ ጊብፄ ዓጫፓ ዔያቶ ኬሳኣና ዔያቶና ዎላ ጫኣቄ ጫኣቁሞ ዔያታ ሃሼሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","ዔያታ ሃያኮ ቤርታ ዚጊ ካኣሽኪ ቤቂባኣያ፤ ናንጊና ናንጋ ጎዳ ዔያቶ ዚጊ ካኣሽኩዋጉዲ ላኣጌ፥ ሜሌ ፆኦዞ ዔያታ ካኣሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","ዬያሮ ናንጊና ናንጋ ጎዳ ፔኤኮ ዴሮይዳ ዻጋዺ ሃያ ማፃኣፖይዳ ፃኣፒንቴ ዎዻ ዶርዓሢ ቢያ ዔያቶ ዓጫ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","ናንጊና ናንጋ ጎዳ ዒናፓ ዔያቶ ዑፃ ዻጋዼኔ፤ ዒዛኮ ዬያ ዻጋፓ ዔቄያና ዔያቶኮ ዓጫፓ ዔያቶ ቱጊ ዔኪ ሜሌ ዓጪዳ ኬኤሬኔ። ዬያሮ ሃሢ ሄላንዳኣና ዔያታ ዒኢካ ዓኣኔ› ጋዓያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","«ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢ ፔጋሱዋዖ ዓኣቼ ባኣዚ ሚርጌ ዓኣኔ፤ ጋዓንቴ ፔጋዺ ዔርቴ ባካ ኑናታ ኑ ናኣቶንታ ማዺ ኑ ኩንሣንዳጉዲ ኮይሳ ዒዛኮ ዎጎ ቃኣሎኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","ሙሴ ዒስራዔኤሌ ዓሶም፦ «ዓንጆና ጋዳማናይዳፓ ፔቴማ ዒንሢ ዶኦራንዳጉዲ ታኣኒ ኮዓኔ፤ ናንጊና ናንጋ ጎዳ ዒንሢ ሜሌ ዴሮ ባኣኮ ዜርቄም ዒንሢ ዒኢካ ዓኣዖ ዒዚ ዒንሢዳ ማዼ ባኮ ማሊ ጶቂሤቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ሃሣ ዒንሢንታ ዒንሢኮ ዜርፆንታ ናንጊና ናንጋ ጎዳ ባንሢ ማዒ ሃኖ ታኣኒ ዒንሢም ዓይሣ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሢፆ ዒናፓ ዒንሢ ዓይሢንታያ ማዔቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ማኣራንዳኔ፤ ሃንጎ ዴሮ ባኣኮይዳ ዒንሢ ዒ ዜርቄ ቤዞይዳፓ ማሂ ዔኪ ሙኪ ጊንሣ ዒንሢ ዒ ዖርጎጪሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","ሳዖኮ ጋፒንፆ ሄላንዳኣና ዒንሢ ዜርቂንቲ ዓኣያ ማዔቴያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ፔቴይዳ ቡኩሲ ዒንሢ ዔኪ ሙካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ዬያይዲ ዒንሢኮ ቤርታኣ ዓዶንሢ ናንጋ ዓጮ ዒንሢ ዻካልሳንዳኔ፤ ናንጊና ናንጋ ጎዳ ቤርታኣ ዓዶንሢፓ ባሼ ዒንሢ ዖርጪሲ ፓይዶዋ ዒንሢኮ ዒማዺ ሚርጊሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢንታ ዒንሢኮ ናኣቶንታ ዒዛም ዓይሢንታንዳ ዒኔ ዒንጋንዳኔ፤ ዬያሮ ጉቤ ዒናፓ ዒንሢ ዒዛ ናሽካንዳኔ፤ ዬኖ ዓጬሎይዳ ሼምፔና ዒንሢ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","ናንጊና ናንጋ ጎዳ ሃያ ጋዳሞ ቢያ ዒንሢዳፓ ዒንሢ ዒፃ ዓሶና ዒንሢ ሄርቂ ዎይሣ፥ ዒንሢኮ ሞርኮ ባንሢ ሺርሻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","ዒንሢ ዒዛም ጊንሣ ዓይሢንታያ ማዓንዳኔ፤ ታኣኒ ሃኖ ዒንሢም ዓይሣ ዒዛኮ ዓይሢፆዋ ዒንሢ ካፓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","ዒንሢ ማዻ ባኮና ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዖርጎጪሳንዳኔ፤ ሚርጌ ናይ፥ ሚርጌ ቆልሞንታ ሚርጌ ሃኣኮንታ ዒንሢም ዒ ዺቢሻንዳኔ፤ ዒንሢኮ ቤርታኣ ዓዶንሢ ዒ ዖርጎጪሳዖ ዎዛዼሢጉዲ ዒንሢ ዖርጎጪሳዖዋ ዒማዺ ዎዛዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","ዬያ ዒዚ ማዻንዳሢ ሃያ ዎጎ ማፃኣፖይዳ ፃኣፒንቴ ዓይሢፆና ዎጎና ካፒ ጉቤ ዒናፓ፥ ጉቤ ሼምፓፓ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ባንሢ ዒንሢ ማዔቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","«ታኣኒ ሃኖ ዒንሢ ዓይሣ ዓይሢፃ ፔቶ ዴኤፃያ፥ ሃሣ ዒንሢፓ ሃካያቱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","‹ዬያ ዋይዚ ኑ ዓይሢንታንዳጉዲ ዖኦኒ ሎኦፓ ኬይሲ ኑም ዔኪ ዬዓንዳይ?› ጌይ ዒንሢ ዖኦጩዋጉዲ ዬይ ዎጋ ዓኣሢ ሌካ ጫሪንጫቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","ሃሣ ‹ዬያ ዋይዚ ኑ ዓይሢንታንዳጉዲ ባዞ ሱካፓ ዖ ኑም ፒንቂ ዔኪ ዬዓንዳይ?› ጌይ ዒንሢ ዖኦጩዋጉዲ ዬይ ጴዻሢ ባዞ ሱካቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","ዬይ ዓይሢፃ ዒንሢኮ ዑኬ ጊዳኬ፤ ዒንሢ ካፓንዳጉዲ ዒንሢኮ ዻንጋ፥ ሃሣ ዒናኣ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","«ሃኖ ታኣኒ ናንጊና ሃይቢና፤ ጊንሣ ሃሣ ኮሹሞና ፑርቱሞናፓ ዒንሢ ዶኦራንዳጉዲ ኮዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","ታኣኒ ሃኖ ዒንሢ ዓይሣ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዓይሢፆ ማዺ ዒንሢ ኩንሣያ ማዔቴ ዎጎ ጎይፆ ዒንሢ ዎርቄቴ ዒዛኮ ዓይሢፆና ዳምቦና ዒንሢ ካፔቴ ሼምፔና ዒንሢ ናንጋንዳኔ፤ ዒንሢኮ ፓይዳኣ ሚርጋንዳኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ጌላ ዓጮይዳ ዒንሢ ዓንጃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","ጋዓንቴ ‹ዒዛም ኑ ዓይሢንታዓ፤ ዒዚ ኬኤዛ ባኮዋ ኑ ዋይዛዓ› ጌዒ ሜሌ ፆኦዞም ዚጊ ካኣሽካኒ ናንጊና ናንጋ ጎዳይዳፓ ዒንሢ ዱማዺ ዴንዴቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","ጋፒ ዒንሢ ባይቃንዳያታሢ ሃይሾ፥ ሃኖ ታ ዒንሢም ኬኤዛኔ፤ ዮርዳኖሴና ፒንቂ፥ ዒንሢ ዻካላንዳ ዓጬሎይዳ ሚርጌ ዎዴ ዒንሢ ናንጋዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","ሃይሾ ታኣኒ ናንጊና ሃይቢናይዳፓ፤ ናንጊና ናንጋ ጎዳ ጋዳንቃ ጋዳሞና ዒ ዓንጃ ዓንጆናይዳፓ ፔቴ ዒንሢ ዶኦራንዳጉዲ ታ ኮዓኔ። ዬያ ዒንሢ ዶኦራ ዶኦሪፆኮ ጫሪንጮና ሳዖና ዒንሢዳ ታ ማርካሳንዳኔ፤ ዬያሮ ዒንሢንታ ዒንሢኮ ዜርፆንታ ሼምፔና ናንጋኒ ናንጊ ዶኦሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ናሽኩዋቴ፤ ዒዛም ዓይሢንታያና ዒዛም ጉሙርቂንታያ ማዑዋቴ፤ ዒንሢ ዬያይዴቴ ናንጊ ዴንቃንዳኔ፤ ሃሣ ዒንሢኮ ቤርታኣ ዓዶንሢ፥ ዓብራሃሜንታ ዪሳኣቄንታ ያይቄቤንታም ዒንጋኒ ናንጊና ናንጋ ጎዳ ጫኣቄ ዓጬሎ ጌላዖ ሚርጌ ዎዴ ዒንሢ ዒኢካ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","ዬካፓ ሙሴ ዒስራዔኤሌ ዴሮ ቢያሢም፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","«ታኣኮ ሌዓ ፄኤታና ላማታሚና ማዔሢሮ ማይ ታኣም ዒንሢ ዔኪ ዓኣዺፃ ዳንዳዒንታዓኬ፤ ሃሣ ታኣኒ ዮርዳኖሴ ዎሮና ፒንቂንዱዋኣሢያ ናንጊና ናንጋ ጎዳ ታኣም ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርታ ቤርታ ማዒ ዒንሢ ዔኪ ዴንዳንዳኔ፤ ዒንሢ ዴንዳ ዓጮይዳ ዓኣ ዴሮ ዒዚ ባይዜም ዒንሢ ዬኖ ዓጮ ዻካላንዳኔ፤ ናንጊና ናንጋ ጎዳ ኬኤዜ ጎይፆጉዴያ ዒያሱ ዒንሢኮ ሱኡጌ ማዒ ዔኪ ዓኣዻሢ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","ሃያኮ ቤርታ ናንጊና ናንጋ ጎዳ ዓሞራ ዓሶ ካኣቶንሢ ሲሆኔና ዖኦጌና ዖሊ ባሺ ዓጮ ዔያቶኮ ባይዜሢጉዲ ዒንሢኮ ሞርኮ ማዔ ዴሮ ዒዚ ዒማይዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","ናንጊና ናንጋ ጎዳ ዖሎና ዒንሢ ዔያቶ ባሻንዳጉዲ ማሃንዳኔ፤ ዬያሮ ሃሢ ታኣኒ ዒንሢ ዓይሣ ጎይፆማ ዒንሢ ዔያቶ ማዻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","ጫርቂ ዶዳያ ማዑዋቴ፤ ዔያቶ ፔቴታዖ ዒጊጪፖቴ፤ ሃሣ ዲቃቲፖቴ። ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢና ዎላኬ፤ ዒንሢ ዒ ኬኤራዓኬ፤ ሃሻዓኬ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ዬካፓ ሙሴ ዒያሱ ዔኤላዖ ዒስራዔኤሌ ዴሮ ቢያሢኮ ቤርታ፦ «ጫርቂ ዶዳያ ማዔ፤ ናንጊና ናንጋ ጎዳ ዔያቶኮ ቤርታኣ ዓዶንሢም ዒንጋኒ ጫኣቄ ጎይፆና ዓጬሎ ዔያታ ዻካላንዳጉዲ ሃያ ዴሮ ዔኪ ጌልዛንዳሢ ኔናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","ናንጊና ናንጋ ጎዳ ፔ ቶኦኪና ኔኤና ዎላ ማዒ ኔ ማዻንዳ ባኮ ዻዋንዳኔ፤ ዒ ኔና ኬኤራዓኬ፤ ፔቴታዖ ሃሻዓኬ፤ ዬያሮ ዒጊጪፖ፥ ዲቃቲፖ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","ዬካፓ ሙሴ ፆኦሲኮ ዎጎ ፃኣፒ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዲ ኬዲ ማዻ ሌዊ ዓሶ ቄኤሶንታ ዒስራዔኤሌ ዓሶኮ ሱኡጎንታም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ዔያቶ ዒ፦ «ጋሌ ቢያ ሃሺንታ፥ ላንካሳ ላንካሳ ሌዖኮ ጋፒንፆይዳ ቦንቺንታ ዉልሾ ዴማ ቦንቾ ቦንቾና፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ዒስራዔኤሌ ዴራ ቢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ቤርቶይዳ ዒዛ ዒንሢ ካኣሽካንዳጉዲ ዶኦሬ ቤዞይዳ ቡካ ዎዶና ሃያ ዎጎ ናባቡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","ቢያሢ ዋይዚ፥ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒጊጪሢ ዔራንዳጉዲ፤ ሃሣ ሃያ ዎጎይዳኣ ኬኤዚንቴ ባኮ ቢያ ዛጊ ካፒ ኩንሣንዳጉዲ ዓቲንቆንታ ላኣሎንታ ናኣቶንታ ዒንሢኮ ካታሞይዳ ካታሞይዳ ናንጋ ሜሌ ዓጫፓ ሙኬ ዓሶዋ ቡኩሱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","ዒንሢ ያዺዴቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ዎጎ ዋይዚ ቤቂባኣ ዜርፃ ቢያ ዋይዛኒ ዳንዳዓኔ፤ ዬያሮ ዮርዳኖሴ ዎሮና ፒንቂ ዒንሢ ዻካላንዳ ዓጬሎይዳ ዔያታ ናንጋ ዎዶይዳ ቢያ ናንጊና ናንጋ ጎዳም ዓይሢንቲሢ ዔራንዳኔ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ዬካፓ ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔ ሃይቃንዳ ዎዳ ሄሌኔ፤ ታ ዒዛ ዓይሣንዳ ባኣዚ ዓኣሢሮ ዒያሱ ዔኤሊ ዔኪ ዓፒሎና ማዢንቴ፥ ታኣኒ ዴሮና ካኣማ ማኣሮ ካሮ ሙኩዋቴ» ጋዓዛ ሙሴና ዒያሱና ፆኦሲ ዴሮና ካኣማ ማኣሮ ካሮ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","ዒማና ናንጊና ናንጋ ጎዳ ዓፒሎና ማዢንቴ ማኣሮ ካራ ፒዝ ጌይ ዔቄ ሻኣሬና ማዒ ዔያቶም ጴዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ኔኤኒ ሃሢ ዑኬ ኬሊዳ ኔኤኮ ቤርታኣ ዓዶንሢጉዲ ሃይቃንዳኔ፤ ዬካፓ ሃይ ዴራ ታ ዔያቶና ዎላ ጫኣቄ ጫኣቁሞ ሃሻንዳኔ፤ ዔያታ ዻካላንዳ ዓጬሎይዳ ዓኣ ዴራ ካኣሽካ ፆኦዞ ካኣሽካንዳኔ፤ ታና ዔያታ ሃሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","ዔያታ ያዺዴ ዎዶና ታ ዔያቶ ዑፃ ዻጋዺ ዔያቶፓ ዱማዻንዳኔ፤ ዓኣፖዋ ታ ዔያቶይዳፓ ሺርሻንዳኔ፤ ዔያታ ባይቃንዳኔ፤ ዔያቶይዳ ሚርጌ ዎዻ ዶርዓ ኬዳንዳኔ፤ ዬካፓ ዬይ ባካ ቢያ ዔያቶ ሄሌሢ ታኣኒ፥ ዔያቶኮ ፆኦዛሢ ዔያቶይዳፓ ዱማዼሢሮታሢ ዔያታ ዔራንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","ሜሌ ፆኦዞ ካኣሽኪ ዔያታ ማዼ ጎሞሮ ዒማና ፔቴታዖ ታ ዔያቶ ማኣዳዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","«ሃያ ዓይኑሞ ፃኣፒ ዒስራዔኤሌ ዴሮ ዔርዜ፤ ዬይ ዓይኑማ ዔያታ ዬያ ማዼ ባኮኮ ታኣም ማርካ ማዓንዳሢሮ ዔያታ ዓይናዻንዳጉዲ ማሄ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","ዔያቶኮ ቤርታኣ ዓዶንሢም ታ ጫኣቄ ጎይፆ ዔኤዞና ዲኢቆና ኩሜ ዓጬሎ ታ ዔያቶ ጌልዛንዳኔ፤ ዒኢካ ዔያታ ሙይ ዑሽኪ ሚሽኬስካፓ ታና ዔያታ ሃሻንዳኔ፤ ታኣና ዎላ ጫኣቄ ጫኣቁሞዋ ሃሺ ሜሌ ፆኦዞ ዔያታ ካኣሽካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","ሚርጌ ባይሲንታና ዴኤሢ ሜታ ዔያቶ ሄሌ ዎዶና ዬይ ዓይኑማ ማርካ ማዓንዳኔ፤ ዔያቶኮ ናኣቶናኣ ዋሊንቱዋያ ማዓንዳኔ፤ ታ ዔያቶም ዒንጋኒ ጫኣቄ ዓጬሎ ጌልዛንዳሢኮ ቤርታ ሃጊ ዔያታ ዓይጎ ማዻንዳቴያ ታ ዔዔራኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ዬኖ ዓቦ ሙሴ ዬያ ዓይኑሞ ፃኣፒ ዒስራዔኤሌ ዴሮ ዔርዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ዬካፓ ናንጊና ናንጋ ጎዳ ኔዊ ናኣዚ ዒያሱም፦ «ጫርቂ ዶዳያ ማዔ፤ ታኣኒ ዔያቶም ዒንጋኒ ጫኣቄ ዓጬሎ ዒስራዔኤሌ ዴሮ ዔኪ ኔ ጌልዛንዳኔ፤ ታኣኒያ ኔኤና ዎላ ማዓንዳኔ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","ሙሴ ሃያ ዎጎይዳ ኬኤዚንቴ ባኮ ፔቴታዖ ዓይሱዋዖ ማፃኣፖይዳ ፃኣፒ ጋፒሴስካፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዳ፥ ሌዊ ዓሶ ማዔ ቄኤሶም፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","«ፆኦሲኮ ዎጋ ፃኣፒንቴ ሃያ ማፃኣፖ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ጫኣቁሞ ሳኣፂኖ ኮይላ ዔኪ ዴንዲ ጌሡዋቴ፤ ዒንሢ ዬያይዳዛ ዬይ ዴሮም ማርካ ማዒ ዴዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","ዒስራዔኤሌ ዴራ ዋይዙዋያ፥ ባቃና ዴይሤ ዓሲታሢ ታ ዔራኔ፤ ታ ዔያቶና ዎላ ዓኣ ዎዶናታዖ ናንጊና ናንጋ ጎዳም ዋይዞ ዒፂ ዔያታ ናንጋያኬ፤ ታ ሃይቄስካፓ ዑሣ ዓኣዼ ዔያታ ዒፃያ ማዓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","ዬያሮ ዬያ ቢያ ታ ዔያቶም ኬኤዛንዳጉዲ ፔቴ ፔቴ ፃጶኮ ቶይዶና ዴሮኮ ሱኡጎና ታኣም ቡኩሱዋቴ፤ ታኣኒ ጫሪንጮና ሳዖና ዔያቶይዳ ማርካሲ ሃሻንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","ታኣኒ ሃይቄስካፓ ዴራ ዓይሢንቱዋያ ማዒ ፑርታ ማዾ ማዻንዳሢ ታ ዔራኔ፤ ናንጊና ናንጋ ጎዳ ዔያቶ ላኣጌ ባኮ ማዺ ዒዛ ዔያታ ዻጋሳንዳሢሮ ዱማ ዱማ ዎዻ ዶርዖ ዒ ዳካንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","ዬካፓ ሙሴ ዒስራዔኤሌ ዓሳ ቢያ ዋይዛንቴ ዓይፃፓ ጋፖ ሄላንዳኣና ሂዚ ጌይ ዓይናዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","«ጫሪንጮንታ ሳዖንታ ታ ጋዓ ባኮ ዋይዙዋቴ፤ ታ ጋዓ ባኮ ኮሺ ዋይዙዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","ታ ዔርዛ ባካ ዒርዚጉዲ ዋርቆንጎ፤ ሃይሳኣ ታኣኮ ዖልኬጉዲ ፆዾንጎ፤ ማኣቲዳ ፁባ ዒርዚጉዲ፥ ባቃሊ ዑጋ ባቃሊዳኣ ዋርቃያጉዲ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","ታኣኒ ናንጊና ናንጋ ጎዳኮ ሱንፆ ዼጊዲ ኬኤዛንዳኔ፤ ኑ ፆኦዛሢኮ ዼኤፑሞ ሄርሹዋቴ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","«ዒዚ ኑኡኮ ዋርዲዮ ሹጫሢኬ፤ ማዻ ዒዛኮ ጌኤሺ ጎይፃኣ ዒዛኮ ፒዜኬ፤ ዒዚ ዻቢንቱዋያ ጉሙርቂንታ ፆኦሲ፥ ናንጊና ናንጋ ጎዳ ፒዜ፤ ሃሣ ኮሺ ማዔ ባኣዚ ማዻያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","ዒንሢ ጉሙርቂንቱዋያ፥ ማኣዳ ባኣዚያባኣ ጎሜ ማዻያና ጌሻ ዓሲና ማዔሢሮ ዒዛ ዓሲ ማዓኒ ዒንሢ ዳንዳዓያቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","ዒንሢ ሃይ ዔኤያ፥ ሃሣ ማሊ ጶቂሡዋ ዴራ! ናንጊና ናንጋ ጎዳም ዒ ማዼ ባኮ ዛሎ ዒንሢ ማሃሢ ዬያዳ? ዒዚ ዒንሢ ማዤያ፥ ዒንሢኮ ዓዳሢቱዋዓዳ? ዒንሢ ዶዲሺ ዺቢ ዴሬ ማሄሢ ዒዛቱዋዓዳ?» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","«ሚና ሚርጌ ሌዔኮ ቤርታ ማዺንቴ ባኮ ማሊ ጶቂሡዋቴ፤ ዬያ ዛሎ ዒንሢኮ ዓዶንሢ ዖኦጩዋቴ፥ ዒንሢም ኬኤዛንዳኔ፤ ጋርቾ ዓሶዋ ዖኦጩዋቴ ዔያታ ዒንሢም ኬኤዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","ዼኤፖ ፆኦዛሢ ሳዖ ዴሮ ቢያም ዓጮ ጊሽኬ ዎዶና ዱማ ዱማ ዜርፃ ናንጋንዳ ቤዞ ዱማሴ ዎዶና ዒስራዔኤሌ ዓሳ ሚርጌ ጎይፆጉዴያ ፔ ዴሮ ዓጮኮ ዛጶ ዱማሲ ቆኦሬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","ያይቆኦቤ ዜርፆ ዒ ፔ ዓሲ ማሂ ዶኦሬያኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","«ዼኤፖ ዢባራ ዢባርሻ ዳውሎ ቦኦሎይዳ ዔኤቢያባኣ ጉሮ ቦኦሎይዳ ዓኣንቴ ዒ ዴንቂ ዔያቶኮ ጊቲማ ማዔኔ፤ ፑርታፓኣ ካፔኔ፤ ዓኣፖኮ ካርፆማጉዲ ማሂ ዔያቶ ዒ ዛጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","ኮኦኬ ናኣቶ ባራንሢ ዔርዛኒ ማኣራፓ ኬሲ ዢባራ ሃሻዖ ዴማ ባራኒ ፔኤኮ ጋኣዞና ዓርቂ ዔካሢጉዲ ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዬያይዲ ባይሲንታፓ ካፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","ናንጊና ናንጋ ጎዳ ሜሌ ዓይጎ ፆኦሲኮዋ ማኣዶ ኮዑዋዖ ዴሮ ፔኤሮ ዔኪ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","«ሳዖኮ ዼጌ ቤዞይዳ ዴዒ ዎይሣንዳጉዲ ጎዣ ካፄም ሃኣኮ ዒንሢ ዒ ሙኡዜኔ፤ ዼኤፖ ዼኤፖ ሹጮይዳ ዔኤሴ ዑታሢ ዒንሢም ዒንጌኔ፤ ቃንፆ ሌሊ ማዔ ሳዖይዳ ባቃሌ ሪሚቶዋ ዒ ዓኣፒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","ዒንሢኮ ባኣቶንታ ዋኣሮንታ ቢያ ሚርጌ ማኣፃያ ዒ ማሄኔ፤ ኮሺ ኮሺ ማዔ ባይንታ ማራይንታ ዋኣሪንታ ቆላኒ ዬያጉዲ ሃሣ ቃራ ማዔ ዛርጎና ሱጉሢጉዲ ዞቄ ማዔ ቃሮ ዎይኖ ዑዦዋ ዒንሢ ዑሽኬኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","«ናንጊና ናንጋ ጎዳኮ ዴራ ሚርጌና ዖርጎጬኔ፤ ዖርጎጬ ጎይፆጉዴያ ዋይዚ ዒፃያ ማዔኔ፤ ዑፃ ዒንሢኮ ማሌኔ፤ ሚርጌ ዒንሢ ሙዓሢሮዋ ዲጬኔ፤ ዒንሢ ማዤ፥ ናንጊና ናንጋ ጎዳሢያ ዒንሢ ሃሼኔ፤ ዋርዲዮ ሹጮ ማዒ ዒንሢ ማኣዳሢያ ዒንሢ ቦሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","ዒንሢ ሜሌ ፆኦዞ ካኣሽኪፆና ናንጊና ናንጋ ጎዳ ዻጋሳኒ ጌኤሲ ማዤኔ፤ ዒንሢ ማዻ ፑርቶ ማዾና ቢያ ዒዛ ዒንሢ ዻጋሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","ሃያኮ ቤርታ ዒንሢ ዔሩዋያ፥ ሃሢ ዑኬ ሙኬያ፥ ፆኦሲቱዋያ ማዔ ፑርቶ ዓያኖም ቤርታኣ ዓዶንሢ ዒንሢኮ ካኣሽኪባኣ ፆኦዞም ሚቺ ዒንጎ ዒንጊሢ ዒንሢ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","ዒንሢኮ ዓዶ ማዔ ፆኦዛሢ ‹ዔሩዋሴ› ዒንሢ ጌዔኔ፤ ዒንሢ ማዤ፥ ፆኦዛሢ ዒንሢ ዋሌኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","«ናንጊና ናንጋ ጎዳ ዬያ ዛጋዖ ዻጋዼኔ፤ ዒዛኮ ዓቲንቆና ዉዱሮ ናኣቶ ማዔዞንሢ ዒዚ ዒፂ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","ናንጊና ናንጋ ጎዳ፦ ‹ሃካፓ ሴካ ታ ዒንሢ ማኣዳዓኬ፤ ዒንሢ ጋፒንፆ ሄላንዳኣና ዎዎይታቴያ ታ ዛጋንዳኔ፤ ዒንሢ ዎቦ ሾይንቲኬ፤ ጉሙርቂንታ ዓሲያቱዋሴ።› ");
INSERT INTO mdyeth_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","ሜሌ ፆኦዞ ዒንሢ ካኣሽኪ ታና ዻጋሳኒ ጌኤሲ ማዤኔ፤ ማኣዱዋ ፆኦዞ ካኣሽኪ ታና ዒንሢ ዻጋሴኔ፤ ታኣኒያ ዒንሢ ቦሂንቴ ዴሬ ዛላና ‹ዎይቲ ዔያታ ያኣዼ ማዔይ?› ጌይሲሳንዳኔ፤ ማሊሢባኣ ዴሬ ዛላና ታ ዒንሢ ዻጋሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","ታኣኮ ዻጋ ታሚጉዲ ዔኤቲ ሳዖንታ ሳዓ ካፂሳ ሃኣኮንታ ቢያ ሚቻንዳኔ፤ ዬይ ሚቺፃ ሳዖኮ ዴሞ ኬዲ ሄላንዳኔ፤ ዹኮኮዋ ፃጶ ሄላንዳኣና ሚቻንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","«ዒንሢዳ ዎዻ ዶርዖ ቃሲ ቃሲ ታ ዳካንዳኔ፤ ታኣኮ ሂኢዦ ዒንሢ ዱኪ ታ ኩርሳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","ዎዺ ኩርሳንዳ ናይዚ ታ ዳካንዳኔ፤ ዱማ ዱማ ዎዻ ዶርዖና ዒንሢ ኩዳንዳኔ፤ ዱማ ዱማ ዻዓ ቦዖንታ ዻይ ዎዎዻ ሾኦሺያ ታ ዒንሢዳ ዳካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","ናኣታ ዒንሢኮ ኬስኬ ቤዞይዳ ቢያ ዖልዚ ዔያቶ ኩርሳንዳኔ፤ ጋሮይዳ ዒንሢ ዓኣቴያ ዒጊቹሞ ዒንሢዳ ጌላንዳኔ፤ ዼጌ ዓቲንቆንታ ዉዱራሢንታ ዻኮ ናኣቶታቴያ ጋርቻኣ ዓቱዋዖ ኩዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","ታኣኒ ጋፒሲ ዒንሢ ባይዛንዳኔ፤ ዬካፓ ዒንሢ ጶቂሣንዳ ዓሲያ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","ጋዓንቴ ዒንሢኮ ሞርካ ‹ኑ ባሼያፓዓቴም ናንጊና ናንጋ ጎዳቱዋሴ ባሼሢ› ጌዒ ዖቶርቂ ጌስታንዳኔ ጌዒ ታ ዓልታኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","«ዒንሢ ዒስራዔኤሌ ዓሳ ዒናባኣ ዓሲኬ፤ ዒንሢ ማሊ ጶቂሣ ዓሲቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","ማሊ ጶቂሣ ዓሲ ዒንሢ ዎንዴ ማዔቴ ዬያ ዒንሢ ጶቂሤያ ናንዳኔ፤ ጋፒንፃ ዒንሢኮ ዓይጎ ማዓንዳቴያ ዒንሢ ዔራንዳያታንቴኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","ዒንሢ ማዤሢ ዓኣሢ ዒንጊባኣያታንቴ ዒንሢኮ ፆኦሲ ዒንሢ ሃሺባኣያታንቴ ዎይቲ ፔቴ ዓሲ ሺያ ዓሲ ዳውሳይ? ላምዓ ዎይቲ ታጶ ሺያ ዓሲ ዳውሳይ? ");
INSERT INTO mdyeth_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","ኑ ሞርካኣ ‹ጎኔኬ› ጋዓሢጉዲ ዔያቶ ፆኦሲ ኑ ፆኦሲጉዲቱዋሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","ኑኡኮ ሞርካ ሶዶሜና ጋሞራ ዓሶናጉዲ ዒኢቴያኬ፤ ዬያሮ ዔያታ ጫንቃያ ሃሣ ዓሲ ዎዎዻ ዎይኔ ዓኣፒጉዴያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","ዔያቶኮ ዎይና ዻይ ዎዎዻ ሾኦሺ ፑርታ ዶርባ ጉዴያኬ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","«ኑኡኮ ሞርካ ማዼ ዻቢንቶ፥ ናንጊና ናንጋ ጎዳ ዔሪ ፃኣፒ ዓርቂ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","ናንጊና ናንጋ ጎዳ ዬያ ኮሞ ዔኪሮ ዔያቶይዳ ሜቶ ዓጋንዳኔ፤ ዔያቶኮ ባይሲንቶ ኬላ ሄሌሢሮ ዹቂንቲ ኔጉዋዖ ዔያታ ባይቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","ዒዛኮ ዓይላ ዎልቄ ባይቄሢ ዛጋዖ ናንጊና ናንጋ ጎዳ ዔያቶ ሚጪንታንዳኔ፤ ካራሚቱዋኣሢንታ ካራማሢንታ ዱማሱዋዖ ናንጊና ናንጋ ጎዳ ፔ ዴሮም ዎጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","ናንጊና ናንጋ ጎዳ ፔ ዴሮ ‹ዒንሢ ጉሙርቃ ፆኦዛ ዒንሢኮ ዎካ ዓኣይ? ዒንሢኮ ዋርዲዮ ሹጮ ማሂ ዒንሢ ጉሙርቄ ፆኦዛ ዒንሢኮ ዓንካዳይ?› ");
INSERT INTO mdyeth_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","‹ዒንሢ ሚቺ ዒንጌ ባኮኮ ማሎ ሙዔ ዎይኖ ዑዦ ዒንሢኮ ዑሽኬ ፆኦዛ ሂንዳ ሙኪ ዒንሢ ዔያታ ማኣዶንጎ፤ ዔያታ ዒንሢኮ ዋርዲዮ ሹጮ ማዖንጎ!› » ");
INSERT INTO mdyeth_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","«ፆኦሲ ታና ሌሊታሢ ዔሩዋቴ፤ ታ ጊዳፓዓቴም ሜሌ ፆኦሲ ባኣሴ፤ ዎዻይያ፥ ሼምፖ ዒንጋያኣ ታናኬ፤ ታ ሜንሢ ኪፃሳኔ፤ ጊንሣ ታ ፓሣኔ፤ ዬያ ታና ላኣጋይ ዖኦኒያ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","ኩጮ ታኣኮ ታ ሌካ ዔቂሲ ሂዚ ጌይ ታ ጫኣቃንዳኔ፦ ‹ታኣኒ ናንጊና ታናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ፖፖዓ ጬንቾ ዓፓሮ ታኣኮ ታ ዋርቃንዳኔ፤ ፒዜ ዎጌ ዎጋኒ ዬያ ታ ዳካንዳኔ፤ ታኣኮ ሞርኮ ኮሜ ታ ኮፃንዳኔ፤ ታና ዒፃ ዓሶም ኮይሳ ባኮ ታ ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","ዎዺንቴሢንታ ዲዒንቴ ሞርኮንታኮ ሱኡጎ ቶኦኮ ሱጉፆ ታ ዓኣዞ ታ ዑሺ ማሢሳንዳኔ፤ ጬንቾ ዓፓራ ታኣኮ ሞርኮ ዓሽኮ ቲቃንዳኔ።›» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","«ዓሲዮቴ! ናንጊና ናንጋ ጎዳ ዒዛም ማዻ ዓሶኮ ሱጉፆ ኮሞ ማሃንዳኔ፤ ፔኤኮ ሞርኮ ኮማንዳኔ፤ ዒዛ ዒፃ ዓሶይዳ ሜቶ ዓጊ ፔ ዴሮኮ ጎሞ ጌኤሻንዳኔ፤ ሳዖኮ ዒኢቲፆዋ ሻቲንሣንዳኔ፤ ዬያሮ ዒዛ ዴሮና ዎላ ዎዛዹዋቴ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","ሙሴና ኔዊ ናኣዚ ዒያሱና ዴራ ዋይዛንዳጉዲ ዬያ ዓይኑሞ ናባቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","ሙሴ ዬያ ባኮ ቢያ ዴሮ ዋይዚሲ ጋፒሴስካፓ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","«ሃያ ዎጎይዳ ኬኤዚንቴ ባኮ ቢያ ዛጊ ካፓንዳጉዲ ናኣቶም ዒንሢኮ ዒንሢ ዔርዛኒ ሃኖ ታኣኒ ዒንሢም ኬኤዜ ባኮ ቢያ ዒና ዔኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","ሃይ ዎላ ካንሢ ጉሪ ጌጌስቶና ባኣዚቱዋሴ፤ ዬይ ዒንሢ ናንጎኮ ፃጲ ማዓ ባኣዚታሢሮ ዬያ ጌይንቴ ባኮ ዓይሢንቲ ማዻያ ማዑዋቴ፤ ዒንሢ ዬያይዴቴ ዮርዳኖሴ ዎሮና ፒንቂ ዒንሢ ዻካላንዳ ዓጬሎይዳ ሚርጌ ዎዴ ናንጋዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","ዬኖ ዓቦ ናንጊና ናንጋ ጎዳ ሙሴም፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","«ሞዓኣቤ ዓጮይዳ ዒያርኮ ካታሞኮ ቤርቶ ዛላ ዓኣ ዓባሪሜ ዹኮ ጌይንታዞንሢዳፓ ፔቴ ኔቦ ጌይንታ ዹካሢ ኬስኬ፤ ዒኢካ ዔቂ ዒስራዔኤሌ ዴሮም ታ ዻካልሳንዳ ካኣናኔ ዓጮ ሃኬና ዛጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","ኔ ጌርሲ ዓኣሮኔ ሆኦሬ ዹኮይዳ ሃይቂ ፔ ዒጊኖ ባንሢ ዴንዴሢጉዲ ኔኤኒ ዬኖ ኔቦ ዹኬሎይዳ ሃይቂ ኔ ዒጊኖ ባንሢ ዴንዳንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","ዓይጎሮ ጌዔቴ ዒንሢ ላምዓሢ ዒስራዔኤሌ ዴሮ ቤርታ ታኣም ጉሙርቂንታያ ማዒባኣሢሮ፤ ሃሣ ዓሲ ናንጉዋ ፂኢኔ ዳውሎይዳ ቃዴሴ ካታሞ ኮይላ ዓኣ ሜሪባ ጌይንታ ዋኣፃ ዓልቃ ቤዞ ኮይላ ዒስራዔኤሌ ዴሮ ቤርታ ታና ዒንሢ ቦንቺሲባኣሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","ኔኤኒ ሃኬ ዔቂ ዓጬሎ ዛጋንዳኔ፤ ጋዓንቴ ዒስራዔኤሌ ናኣቶ ታኣኒ ዻካልሳ ዬኖ ዓጬሎ ኔ ጌላዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","ሙሴ ሃይቃንዳሢኮ ቤርታ ዒስራዔኤሌ ዴሮም ሃጊ ማዓንዳ ባኮ ኬኤዚ ሂዚ ጌይ ዓንጄኔ፦ ");
INSERT INTO mdyeth_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","«ናንጊና ናንጋ ጎዳ ሲና ዹካፓ ሙኬኔ፤ ዔዶኦሜይዳፓ ዓቢጉዲ ፆርቄኔ፤ ፓኣራኣኔ ዹኮይዳኣ ፖዔኔ፤ ሚርጌ ዺቢ ኪኢታንቻ ዒዛና ዎላ ዓኣኔ፤ ዒዛኮ ሚዛቆ ዛላ ዔኤታ ታሚ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","ናንጊና ናንጋ ጎዳ ፔኤኮ ዴሮ ጎኔ ናሽካኔ፤ ዒዛም ዱማዼ ዴሮዋ ዒ ካፓኔ፤ ዬያሮ ዒዛኮ ቶኮ ዴማ ጉምዓቲ ኑ ዚጋንዳኔ፤ ዎጎ ዒዛሲ ኑ ካፓንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","ዒስራዔኤሌ ዴሮም ዔያቶሮ ማሂ ዒንጊንቴ ሙሴ ኑም ኬኤዜ ቦንቺንቴያ ማዔ ዎጎ ኑ ካፓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","ዒስራዔኤሌ ዓሶ ፃጶና ዴሮኮ ሱኡጎና ቡኩንቴ ዎዶና ናንጊና ናንጋ ጎዳ ዒስራዔኤሌይዳ ካኣታዼኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","ሙሴ ሃሣ ሮኦቤኤሌ ማኣሮ ዓሶ ዛሎ «ፓይዳ ዔያቶኮ ዻካ ማዔቴያ ናንጊና ናንጋ ጎዳሢዮ! ሮኦቤኤሌ ዴራ ናናንጎንጎ፤ ባይቆፓ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","ሃሣ ዒዚ ዪሁዳ ማኣሮ ዓሶ ዛሎ «ናንጊና ናንጋ ጎዳሢዮ! ኔ ባንሢ ዔያታ ዒላታ ዒላቶ ዋይዜ፤ ሃንጎ ፃጶ ዓሶና ዎላ ፔቱሞ ዓኣያ ዔያቶ ማሄ፤ ዶዲ ዎልቄ ዔያቶም ዒንጌ፤ ዔያታ ፔ ሞርኮና ዖልታ ዎዶና ዔያቶ ማኣዴ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","ዒዚ ሃሣ ሌዊ ማኣሮ ዓሶ ዛሎ «ናንጊና ናንጋ ጎዳሢዮ! ኔ ማሊፆ ዱማሲ ዔርዛ ኔኤም ዱማዼ ባኮንሢና ማሳሄና ሜሪባ ዋኣፆ ዓጮናይዳ ዔያቶና ማርሚ ዔያቶኮ ጎኑሞ ኔ ዛጌ ኔኤም ማዻ ሌዊ ዓሶም ማሊፆ ኔኤኮ ፔጋሲ ዻዌ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","ዔያታ ኔ ጋቴ ጌዒ ሾዔ ዓሶ ዋሌኔ፤ ፔ ዒጊኖይዳፓኣ ዱማዼኔ፤ ናኣቶዋ ፔኤኮ ዔያታ ሃሼኔ፤ ኔ ኬኤዛ ባኮዋ ዔያታ ቦንቼኔ፤ ኔ ዔያቶና ዎላ ጫኣቄ ጫኣቁሞዋ ዔያታ ካፔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","ኔኤኮ ዳምቦ ያይቆኦቤም ዎጎዋ ኔኤኮ ዒስራዔኤሌ ዓሶ ዔርዛኔ፤ ኔ ቤርታ ዔያታ ዑንጆ ጩቢሻኔ፤ ኔኤም ሚቺ ዒንጎ ባኮ ዒንጎ ቤዞይዳ ሚቺ ዒንጎ ባኮ ዒንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","ናንጊና ናንጋ ጎዳሢዮ! ዔያቶኮ ዓኣ ባኮ ዓንጄ፤ ዔያታ ማዻ ማዾዋ ኮሺ ማሂ ዔኬ፤ ዔያቶ ሞርኮኮ ዎልቆ ላቢሴ፤ ዔያቶ ዒፃ ዓሳ ላሚ ዔቁዋጉዲ ዎልቄ ባይዜ!» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","ሃሣ ሙሴ ቢኢኒያሜ ማኣሮ ዓሶ ዛሎ «ናንጊና ናንጋ ጎዳ ዔያቶ ናሽካ ዓሳ ሂርጋ ባኣያ ናንጎንጎ፤ ዼኤፖ ፆኦዛሢ ሮኦሮ ቢያ ዔያቶ ካፓኔ። ዒንዳ ፔኤኮ ናዖ ኮንቃሢጉዲ ዒዚ ኮንቄም ዔያታ ናንጋንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","ዒዚ ዮሴፔ ማኣሮ ዓሶ ዛሎ፦ «ናንጊና ናንጋ ጎዳ ሎ ጫሪንጫፓ ዒሮ ዋርቂሲ ሉ ዴማ ዓኣ ዋኣፆዋ ዓልቂሲ ሳዖ ዔያቶኮ ዓንጆንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","ዬያጉዲ ዓባ ቃራ ዓቤም ካፃ ሃኣኮ ሌዖና ሌዖና ሳዓ ዔያቶኮ ሚርጌ ካሣያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","ዔያቶኮ ሚናፓ ዓኣ ዹኮንታ ጌሜሮንታ ሙዎ ባኣዚ ቃራ ቃራ ካፂሳያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","ዓጫ ዔያቶኮ ኮሺ ማዔ ባኣዚና ቢያ ኩሜያ ማዖንጎ፤ ካዮ ባኣካ ዔኤታ ታሞና ጴዼ ፆኦዛሢ ዓንጃ ዓንጆና ዒዛ ሳዓ ዓንጂንቴያ ማዖንጎ፤ ዒዚ ፔኤኮ ጌርሲንሢ ባኣካ ሱኡጌ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","ዮሴፔ ዚያ ጌማይጉዲ ዶዲኬ፤ ካኣራ ዒዛኮ ሜኤኒ ካኣሪጉዲ ዶዳያኬ፤ ዬያና ዒ ዴሮ ዹዓንዳኔ፤ ዓጮኮ ጋፒንፆ ሄላንዳኣና ዒ ዳውሳንዳኔ፤ ዔፕሬኤሜኮ ታጶ ላምዖ ሺዮንታ ሚናኣሴኮ ሺዮንታ ያኣዼ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","ሃሣ ሙሴ ዛብሎኦኔና ዪሳኮኦሬ ማኣሮ ዛሎ፦ «ዛብሎኦኔ ዜርፃ ባዞይዳ ኮርማ ኮርሞና ዖርጎጪ ዎዛዾንጎ፤ ዪሳኮኦሬያ ማኣራ ዓኣዖ ዎዛዻያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","ዔያታ ሃንጎ ዴሮ ዹኮ ዔኤሊ ኬሲ ፒዜ ማዔያ፥ ፆኦሲም ዒንጎ ባኮ ዒኢካ ሺኢሻንዳኔ፤ ዔያቶ ዖርጎጪሳንዳ ቆሎ ዔያታ ባዞና ባዞ ዓጫ ዓኣ ማኣሻሎናይዳፓ ዴንቃንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","ዒዚ ሃሣ ጋኣዴ ማኣሮ ዓሶ ዛሎ፦ «ጋኣዴ ዓጮ ዳልጊሼ፥ ናንጊና ናንጋ ጎዳሢ ጋላቲንቶንጎ! ጋኣዴ ዓሳ ሞርኮኮ ኩጮ ሜንሣኒና ባሊቶዋ ጳርቂ ዑራኒ ዞቢጉዲ ካታያ ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","ዒዚ ሱኡጌ ማዒ ዶኦሪንቴሢሮ ፔኤም ቃራ ማዔ ሳዖ ዶኦሪ ዔኬኔ፤ ዴሮኮ ሱኡጋ ቡኬ ዎዶና ናንጊና ናንጋ ጎዳኮ ማሊፆንታ ዳምቦንታ ዒስራዔኤሌ ዓሶም ማዺ ዒ ኩንሤኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","ሃሣ ዒ ዳኣኔ ማኣሮ ዓሶ ዛሎ፦ «ዳኣኔ ሃጊ ዔቃ ዓዴ ዞቢጉዲኬ፤ ዒዚ ባኣሳኣኔይዳፓ ኮኦሚ ኬስካያ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","ዒዚ ሃሣ ኒፕታኣሌኤሜ ማኣሮ ዓሶ ዛሎ፦ «ናንጊና ናንጋ ጎዳ ኒፕታኣሌኤሜ ኮሺ ናሽካያኬ፤ ፆኦሲ ሚርጌና ዔያቶ ዓንጄያኬ፤ ዔያቶኮ ዓጫ ጌሊላ ባዛፓ ዴንዲ ዾኦሎ ዛሎ ዓጮ ሄላያ ማዓንዳኔ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","ሃሣ ዒ ዓሴኤሬ ማኣሮ ዓሶ ዛሎ፦ «ዓሴኤሬ ማኣራ ሃንጎ ማኣሮይዳፓ ባሼ ዓንጂንቴያኬ፤ ዒዛ ጌርሲንሢ ናሽካያ ማዖንጎ፤ ሳዓ ዒዛኮ ዛይቶ ሪሚቶ ሚፆ ሚርጌ ባቃልሳያ ማዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","ካታሞ ጌሎ ካራ ዒዛኮ ዓንጊና ዎዺንቲ ካፒንታያ ማዖንጎ፤ ዒ ናንጋ ዎዶ ቢያይዳ ዎልቄ ዓኣያ ማዖንጎ።» ");
INSERT INTO mdyeth_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","«ዒስራዔኤሌ ዓሲዮቴ! ዼኤፒ ዒጊቻ ቦንቾና ጫሪንጮ ቲቂ ዴንዳያ ዒንሢ ማኣዳኒ ሻኣሮ ዑፃ ዴዒ ሙካ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢጉዴያ ዖኦኒያ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","ናንጊና ናንጋ ጎዳ ቢያ ዎዴ ዒንሢኮ ዋርዲዮ ሹጫሢኬ፤ ናንጊና ናንጋ ዎልቃ ዒዛኮ ዒንሢ ማኣዳንዳኔ፤ ሞርኮ ዒንሢኮ ቤርታፓ ዒ ዳውሳንዳኔ፤ ዒንሢ ዔያቶ ዎዺ ባይዛንዳጉዲ ዒ ማሃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","ዬያሮ ያይቆኦቤ ዜርፃ ጫሪንጫፓ ዖልኬ ፆዻያ ሃኣኮና ዎይኖ ዑዦና ኩሜ ዓጬሎይዳ ፔ ሼምፓሢኮ ሂርጉዋዖ ኮሺ ናንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","ዒስራዔኤሌ ዓሲዮቴ! ዒንሢ ዎዚ ባሊቲናዳይ! ናንጊና ናንጋ ጎዳ ዓውሴ ዴሬ ዒንሢጉዴያ ፔቴታዖ ባኣሴ፤ ናንጊና ናንጋ ጎዳ ፔ ቶኦኪና ዒንሢኮ ጊቲማሢ፤ ሃሣ ዖሎ ዒንሢ ዖሊ ባሻ ጬንቾ ዓፓራሢኬ፤ ዒንሢኮ ሞርካ ዒንሢ ሺኢቂ ሺኢቂ ዒንሢ ኮይላ ሙካዛ፥ ጊኢሮ ዒንሢ ዔያቶኮ ሄርቂ ሜንሣንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ሙሴ ሞዓኣቤ ቦኦላፓ ዔቂ ኔቦ ዹኮ ዴንዲ፥ ዒያርኮኮ ዓባ ኬስካ ዛሎና ዓኣ ፒሲጋ ዹኮ ቶኦኮ ኬስኬኔ፤ ዬካፓ ናንጊና ናንጋ ጎዳ ዓጬሎ ዒዛ ሃኬና ዻዌኔ፤ ዬይ ዒ ዻዌሢ፦ ጌሌዓዴ ዓጫፓ ዓርቃዖ ዴንዲ ኬዶ ዛሎና ዳኣኔ ካታሞ ሄላንዳኣና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ኒፕታኣሌኤሜ ዓጮ ጉቤ፤ ዔፕሬኤሜንታ ሚናኣሴንታ ዓጮ፤ ዾኦሎ ዛሎና ዴንዲ ሜድቴራኒያ ባዞ ኮይላ ዓኣ ዪሁዳ ዓጮ ሄላንዳኣና፥ ");
INSERT INTO mdyeth_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ዪሁዳ ዓጮኮ ዾኦሎ ዛሎና ዓኣ ቦኦሎ፤ ዒያርኮ ዓጮ ዶኦጮይዳ ሜኤፆ ካታሞ ጌይንታ ዒያርኮ፤ ሃሣ ዴንዲ ፆዓሬ ሄላንዳኣናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ናንጊና ናንጋ ጎዳ ሙሴም፦ «ዔያቶኮ ዜርፆ ዻካልሳኒ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታም ታ ጫኣቄ ዓጬላ ሃኖኬ፤ ሃይሾ ዓኣፖና ታ ኔና ዛጊሴኔ፤ ጋዓንቴ ዒዞ ኔ ጌላዓኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","ዬያሮ ናንጊና ናንጋ ጎዳ ዓይላሢ፥ ሙሴ ሞዓኣቤ ዓጫ ዓኣዖ ናንጊና ናንጋ ጎዳ ዒዛም ኬኤዜ ጎይፆና ዒኢካ ሃይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","ናንጊና ናንጋ ጎዳ ዒዛ ፔትፔዖሬ ካታሞኮ ቤርቶ ዛላ ሞዓኣቤ ዓጮይዳ ዓኣ ዶኦጫ ዱኡኬኔ፤ ጋዓንቴ ሃኖ ሄላንዳኣና ፒዜ ዒ ዱኡቴ ቤዞ ዱማሲ ዔራ ዓሲ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ሙሴ ሃይቃኣና ሌዓ ዒዛኮ ፄኤታና ላማታሚናኬ፤ ጋዓንቴ ዓኣፓ ዒዛኮ ባይቂባኣሴ፤ ዎልቃ ሃጊ ዶዲ ዓኣዖኬ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","ሲያ ጋፓንዳያ ሄላንዳኣና ዒስራዔኤሌ ዴራ ዒዛ ዛሎ ዖዪ ሃይሢታሚ ኬሊ ሞዓኣቤ ቦኦሎይዳ ዬኤኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ሙሴ ፔ ቤዛ ማዻያ ማዓንዳጉዲ ኩጮ ዒያሱ ዑፃ ጌሢ ዶኦሬሢሮ ኔዊ ናኣዚ ዒያሱ ዔራቶና ዓኣ ዓሲ ማዔኔ፤ ዒስራዔኤሌ ዴራኣ ዒዛም ዓይሢንቴኔ፤ ናንጊና ናንጋ ጎዳ ሙሴ ዛሎና ዔያቶም ዒንጌ ዓይሢፆዋ ዔያታ ካፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","ናንጊና ናንጋ ጎዳ ቤርታ ዔቂ ዎላ ጌስቴያ፥ ሙሴጉዴያ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ፔቴታዖ ዒስራዔኤሌይዳ ኬስኪባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","ናንጊና ናንጋ ጎዳ ሙሴ ጊብፄ ዓጮ ካኣቲና ሱኡጎ ማዒ ማዻ ዼኤፖ ዼኤፖ ዓሶ ኮይላ፤ ሃሣ ዓጮ ቢያሢም ዳካዛ ዒዛ ዛሎና ማዺንቴ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮና ዲቃሣ ባኮ ማዼይ ሜሌ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ፔቴታዖ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","ሙሴ ዒስራዔኤሌ ዓሶ ቢያሢ ቤርታ ማዼ ዼኤፖ ባኮና ዒጊቻ ባኮ ቢያሢጉዴያ ማዼ ሜሌ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ፔቴታዖ ባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ሃይቄስካፓ ሙሴ ማኣዲ ማኣዲ ማዻ ኔዊ ናኣዚ ዒያሱም ናንጊና ናንጋ ጎዳ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","«ኔ ዔራሢጉዲ ታ ዓይላሢ ሙሴ ሃይቄኔ፤ ዓካሪ ኔናንታ ዒስራዔኤሌ ዴሮንታ ቢያ ጊኢጊንቲ፥ ታኣኒ ዒስራዔኤሌ ዓሶ ዻካልሳንዳ ዓጬሎ ጌላኒ ዮርዳኖሴ ዎሮና ፒንቁዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","ሙሴም ታ ኬኤዜ ጎይፆና ዒንሢ ዴንዲ ሄላ ዓጮ ቢያ ታ ዒንሢም ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","ዒንሢ ዓጮኮ ዛጳ፦ ዾኦሎ ዛሎና ዓኣ ዓሲ ናንጉዋ ቦኦላፓ ዓርቃዖ ኬዶ ዛላ ዓኣ ሊባኖኦሴ ዹኮ ሄላንዳኣና፤ ሃሣ ዓባ ኬስካ ዛሎና ዼኤፖ ዔፕራፂሴ ዎሮና ጋዓዖ ሂኢታ ዓሶ ዓጮ ቢያ ዔኪ ዓባ ጌላ ዛሎና ዓኣ ሜዲቴራኒያ ባዞና ማዓንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","ዒያሱ፤ ኔ ናንጋ ዎዶ ቢያይዳ ኔና ዖሊ ባሻንዳ ዓይጎ ዓሲያ ባኣሴ፥ ታኣኒ ሙሴና ዎላ ማዔሢጉዲ ኔኤና ዎላኣ ታ ማዓንዳኔ፥ ቢያ ዎዴ ታ ኔኤና ዎላኬ፤ ፔቴታዖ ታ ኔና ሃሻዓኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","ዒጊጪፖ፥ ዶዴ፤ ታኣኒ ዔያቶኮ ቤርታኣ ዓዶንሢም ዒንጋኒ ጫኣቄ ዓጬሎ ዻካልሳኒ ሃያ ዴሮ ዔኪ ዓኣዻንዳሢ ኔናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","ኔኤሮ ዒጊጪፖ፥ ዶዴ፤ ታ ዓይላሢ፥ ሙሴ ኔኤም ኬኤዜ ዎጎ ቢያ ጉሙርቂንቲ ዓይሢንታያ ማዔ፤ ኔ ዴንዳ ቤዞይዳ ቢያ ጉቤ ባኣዚ ኔኤም ጊኢጋንዳጉዲ ሃያ ዎጎ ሃሺ ሴካ ሃንጋ ጌይፖ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","ሃያ ዎጎ ማፃኣፖ ቢያ ዎዴ ናባቤ፤ ዬያይዳ ፃኣፒንቴ ባኮ ቢያ ማዺ ኩንሣኒ ዋንቶና ሮኦሮና ቢያ ማሌ፤ ኔ ዬያይዴቴ ቢያ ባኣዚ ኔኤም ጊኢጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","ኔ ዴንዳ ቤዛ ቢያ፦ ታኣኒ፥ ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ኔኤና ዎላታሢሮ ዒጊጪፖ! ዶዴ ታ ኔኤም ጌይባኣዓዳ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ዬካፓ ዒያሱ ዴሮኮ ሱኡጎ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","«ጉርዶ ዴንዲጋፓ ዴሮም ‹ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒንሢ ዻካላንዳጉዲ ዒንጋ ዓጬሎ ዔካኒ ሃይሦ ኬሊኮ ጊንፃፓ ዮርዳኖሴ ዎሮና ዒንሢ ፒንቃንዳሢሮ ጋላ ጊኢጊሹዋቴ› ጌይ ኬኤዙዋቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","ዒያሱ ሃሣ ሮኦቤኤሌንታ ጋኣዴ ዓሶንታም፤ ሃሣ ጊንሣ ሚናኣሴ ዓሶኮ ዛሎም፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","« ‹ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዬኖ ዓጬሎ ዒንሢም ዒንጊ ዒንሢ ሃውሺሲ ዴይሣንዳኔ› ጌዒ ናንጊና ናንጋ ጎዳኮ ዓይላሢ ሙሴ ኬኤዜሢ ማሊ ጶቂሡዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","ዒንሢኮ ላኣሎንታ ናኣቶንታ ቆልሞንታ ሙሴ ዮርዳኖሴ ሱካ ዒንሢም ዒንጌ ሃኖ ዓጬሎይዳ ዴዖንጎ፤ ጋዓንቴ ዒንሢኮ ዖሎ ዖላ ዓሳ ዖሎ ዓንጋሞ ዔኪ ዔያቶኮ ፃጶ ዒስራዔኤሌ ዓሶ ማኣዳኒ ቤርታ ዮርዳኖሴ ዎሮና ፒንቆንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ናንጊና ናንጋ ጎዳ ማዔ ዔያቶኮ ፆኦዛሢ ዔያቶም ዒንጌ ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛሎይዳ ዓኣ ዓጮ ዔያታ ዻካላንዳያ ሄላንዳኣና ዔያቶና ዎላ ዖሎንጎ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒስራዔኤሌ ማኣሮ ማኣሮ ዓሶም ቢያ ኮሹሞ ሃውሾ ዒንጋዛ ዒንሢ ማዒ ሙኪ ዓባ ኬስካ ዛላ ዮርዳኖሴ ዎሮኮ ሱካ ናንጊና ናንጋ ጎዳ ዓይላሢ ሙሴ ዒንሢም ዒንጌ ዓጮይዳ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","ዔያታ ዒያሱም ማሃዖ፦ «ኔ ኑም ኬኤዜ ባኮ ቢያ ማዺ ኑ ኩንሣንዳኔ፤ ሃሣ ኔ ኑና ዳካ ቤዞዋ ቢያ ኑ ዴንዳንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ዎንዴ ሙሴም ኑ ዓይሢንታሢጉዲ ኔኤማኣ ኑ ዓይሢንታንዳኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ኔኤኮ ፆኦዛሢ ሙሴና ዎላ ማዔሢጉዲ ኔኤና ዎላኣ ማዖንጎ! ");
INSERT INTO mdyeth_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ኔ ቢታንቶ ማኪ ዒፃያና ኔ ዓይሣ ባኮ ቢያ ማዺ ኩንሡዋያ ዓኣቶ ዎዎዺንቶንጎ፤ ኔኤኒ ጋዓንቴ ዶዴ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ዬካፓ ኔዊ ናኣዚ፥ ዒያሱ ሻሮ ዶኦጫፓ ላምዖ ሙሪ ዓሲ ዳኬኔ፤ ዔያታ ካኣናኔ ዓጮ፤ ባሼ ዒያርኮ ዓጮ ዔርቲባኣ ጎይሢና ሙሪ ማዒ ሙካንዳጉዲ ዓይሤኔ፤ ዔያታ ካታሜሎ ሙካዖ፦ «ሬዓባ» ጌይንታያ ፔቴ ዞኦስካ ኮኦማ ላኣሊስኬኖ ማኣሪ ጌሊ ዒኢካ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","ዒማና ዒያርኮ ካኣቲም፦ «ዒስራዔኤሌ ዓሶይዳፓ ሙሪ ዳኮና ዓሲ ሃሢ ዓሜንቴ ሃካ ሙኬኔ» ጌይ ዓሲ ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","ዬያሮ ዒያርኮ ካኣቲ ሬዓባ ኮይላ፦ «ዓጮ ሙሮ ሙኪ ኔ ማኣሪ ጌሌ ዓሶ ኬሲ ዒንጌ» ጌዒ ዓሲ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","5","ዒዛ ማሃዖ፦ «ጎኔኬ፥ ታ ማኣሪ ሙኬ ዓሲ ዓኣኔ፤ ጋዓንቴ ዔያታ ዓንካፓ ሙኬቴያ ታኣኒ ዔሩዋሴ፤ ዓባ ጌላማና ካታሞ ጌሎ ካራ ዎዺንቱዋንቴ ዔያታ ኬስኪ ዴንዴኔ፤ ዔያታ ዎኒ ዓኣዼቴያ ታኣኒ ዔሪባኣሴ፤ ሃሢ ዒንሢ ዑኬና ጊንፆ ጳሽኬቴ ዔያቶ ዓርቃኒ ዳንዳዓኔ» ጌዔኔ፤ ዒዛ ዒማና ዬንሢ ላምዖ ዓሶንሢ ዔኪ ዓኣቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","ዒዛ ጋዓንቴ ማኣሮኮ ኩቦ ዑፆ ዔያቶ ዔኪ ኬሲ፥ ታልቦ ቶኪ ጌይንታ ባኣዚ ሜሎም ቱጊ ሚጮናያኮ ዴሞ ጌልዚ ዓኣቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","ካኣቲ ኮራፓ ሙኬ ዓሶንሢ ካታማፓ ኬስኪ ዴንዳዛ ካታሞ ጌሎ ካራ ዎዺንቴኔ፤ ዬንሢ ዓሳ ዬኖ ሙሮ ሙኬ ዓሶ ኮዒ ዮርዳኖሴ ዎሮና ፒንቆ ካሮ ዔኪ ዴንዳ ጎይፆና ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","ሬዓባ ዒማና ሙሮ ሙኬ ዓሳ ላሁዋንቴ ዔያታ ዓኣ ኩቦ ዑፆ ኬስኪ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","«ናንጊና ናንጋ ጎዳ ሃኖ ዓጬሎ ዒንሢም ዒንጌሢ ታ ዔራኔ፤ ሃኖ ዓጮይዳ ናንጋ ዓሳ ዒንሢ ዒጊጪ ጎጲ ዋኣፄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","ጊብፄ ዓጮ ሃሺ ዒንሢ ኬስካኣና ናንጊና ናንጋ ጎዳ ዞቄ ባዞ ቤርታፓ ዒንሢኮ ዎይቲ ሚጪሴቴያ ኑ ዋይዜኔ፤ ሃሣ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛላ ዓኣ ዓሞራ ዓጮ ካኣቶ ላምዖንሢ፥ ሲሆኔና ዖኦጌና ዎማይዲ ዒንሢ ዎዼቴያ ኑ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ዬያሮ ዬያ ባኮ ዋይዛዖ ዒጊጪ ጎጲ ኑ ዋኣፄኔ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጎኔና ጫሪንጮንታ ሳዖንታኮ ፆኦሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","ሃሢ ታ ዒንሢም ኮሺ ባኣዚ ማዼሢጉዲ ታ ማኣሮ ዓሶ ባይሲንቶፓ ዓይሲ ኮሺ ባኣዚ ዒንሢ ታኣም ማዻኒ ናንጊና ናንጋ ጎዳ ሱንፆና ጫኣቁዋቴ፤ ዬያኮ ማርካ ማዓ ማላታ ታኣም ዒንጉዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ታኣኮ ዓዶንታ ዒንዶንታ፥ ታኣኮ ጌርሲንሢንታ ጌሮንሢንታ ዬያቶኮ ማኣሮ ዓሶንታ ቢያ ሃይቢፓ ዓውሳኒ ታኣም ጫኣቁዋቴ!» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","ዬካፓ ዓሶንሢ ዒዞም፦ «ኑኡኒ ማዻኒ ጫኣቄ ጎይፆ ማዺ ኩንሢባኣቴ ፆኦሲ ኑና ባይዞም! ኑ ማዼ ባኮ ቢያ ዖኦማኣ ኔ ኬኤዚባኣቴ፥ ናንጊና ናንጋ ጎዳ ሃኖ ዓጬሎ ኑም ዓኣሢ ዒንጋ ዎዶና ኔኤም ኑ ኮሺ ባኣዚ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ሬዓባ ናንጋ ማኣራ ካታሞ ዙሎ ኬልቂ ዲርቆና ዲፆኮ ጊዳ ማዢንቲ ዓኣያኬ፤ ዬያሮ ዓሶ ዒዛ ማኣሮኮ ፑልቶ ካሮና ሊካ ዎዳራና ካታሞ ዙላ ኬይሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","ዒዛ ዔያቶ፦ «ሌካ ጌሜሮ ኬስኩዋቴ፤ ዒንሢ ዬያይዲባኣቴ ካኣቲ ዳኬ ዓሳ ዒንሢ ዓርቃንዳኔ፤ ዬና ዓሳ ማዓንዳያ ሄላንዳኣና ሃይሦ ኬሊ ዒኢካ ፑኒ ዴዑዋቴ፤ ዬካፓ ጎይፆ ዒንሢ ዓኣዻኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","ዓሶንሢያ ዒዞም፦ «ኔ ኑና ጫኣቂሴ ባኮ ቢያ ኑ ማዻንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","ኔ ማዻንዳያ ኮይሳሢ ኑኡኒ ዒንሢ ዓጮ ዖሊ ዓርቃ ዎዶና ሃይማ ዞቄ ፓቲሎና ሱኪንቴ ሼኤሞማ ኑና ኔ ኬይሴ ኔ ማኣሮኮ ፑልቶ ካሮማካ ቱኬ፤ ኔ ዓዶንታ ኔ ዒንዶንታ፥ ኔ ጌርሲንሢንታ ኔ ማኣሮ ዓሶ ቢያሢ ኔ ማኣራ ቡኩሲ ዴይሤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ዬንሢ ዓሶፓ ዓይጎ ዓሲያ ዙላ ኬስኪ ሃይቄያ ማዔቴ ዻቢንታ ዬማሮ ማዓንዳኔ፤ ኑ ዬያኮ ዖኦጪንቱዋሴ፤ ኔኤና ዎላ ጋራ ዓኣንቴ ዬንሢ ዓሶይዳ ፔቴ ባኣዚ ሄሌያ ማዔቴ ዬያ ዛሎ ኑ ዖኦጪንታንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ጋዓንቴ ሃያ ኑ ማዼ ባኮ ዓሲም ኔ ኬኤዜቴ ኔኤም ኑ ጫኣቄ ጫኣቁሞ ኩንሢሳ ባኣዚ ኑና ባኣኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","ዒዛ ዬያ «ኮሺኬ» ጌይ ዔያቶ ዳኬስካፓ ሱኪንቴ ዞቄ ሼኤሜሎ ኬኤፆኮ ፑልቶ ካራ ቱኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","ዔያቶ ኮጲሲ ዴንዴ ዓሳ ጎይፆ ቢያሢ ኮዒ ባሺንቲ ማዓንዳያ ሄላንዳኣና ዔያታ ጌሜሮ ኬስኪ ሃይሦ ኬሊ ፑኒንቲ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","ዬካፓ ዔያታ ጌሜራፓ ኬዴኔ፤ ዮርዳኖሴ ዎሮናኣ ፒንቃዖ ዒያሱ ኮይላ ሙኪ ዔያቶ ሄሌ ባኮ ቢያ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ዒያሱም ዔያታ፦ «ናንጊና ናንጋ ጎዳ ዓጬሎ ጉቤ ኑም ዒንጌሢ ዔርቴያኬ፤ ዎይቲ ጌዔቴ ዬኖ ዓጬሎይዳ ናንጋ ዓሳ ቢያ ኑ ጋቴ ዒጊጪ ጎጲ ዋኣፄኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","ዚሬሎ ጉቴ ዓማ ዒያሱንታ ዒስራዔኤሌ ዴሮንታ ቢያ ሚኢሪ ዔቂ፥ ሻሮ ዶኦጫ ዱንኪ ዴዔ ቤዛፓ ዮርዳኖሴ ዎሮ ሙካዖ ፒንቃንዳሢኮ ቤርታ ዒኢካ ዱንኪ ዴዔኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ሃይሦ ኬሊኮ ጊንፃፓ ዴሮኮ ሱኡጋ ጉርዶ ዴንዲ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ጫኣቁሞ ሳኣፂኖ ሌዊ ፃጶ ማዔ ቄኤሳ ኬዲ ዔቃዛ ዛጋዖ ዱንኪ ዴዔ ቤዞ ሃሺ ዔያቶ ጊንፆ ዴንዱዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","ሃያኮ ቤርታ ዬያ ቤዞ ዒንሢ ዔሩዋያታሢሮ ዒንሢ ዓኣዻንዳ ጎይፆ ዔያታ ዒንሢ ዻዋንዳኔ፤ ጋዓንቴ ጫኣቁሞ ሳኣፂኖ ባንሢ ዑኪፖቴ፤ ዒንሢና ጫኣቁሞ ሳኣፂኖናኮ ባኣካ ዓኣ ሃኩማ ሺያ ታኣኪሢ ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","ዒያሱ ዴሮም ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ዚሮ ዒንሢ ባኣካ ፔ ዎልቄና ማዺንታ ዓኪ ባኣዚ ማዻንዳሢሮ ዒንሢ ጌኤሹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","ጫኣቁሞ ሳኣፂኖ ኬዲ ዴሮኮ ቤርታ ቤርታ ዴንዳንዳጉዲ ቄኤሶም ዒ ኬኤዛዛ ዔያታ ዒ ዓይሤ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ናንጊና ናንጋ ጎዳ ዒያሱም፦ «ሙሴና ዎላ ማዔሢጉዲ ኔኤና ዎላ ታ ዓኣያታሢ ዔያታ ዔራንዳጉዲ ዒስራዔኤሌ ዴሮ ቢያሢ ቤርታ ኔና ቦንቺሲ ዼጊዲፆ ሃኖ ታ ዓርቃንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ጫኣቁሞ ሳኣፂኖ ኬዴ ቄኤሶም፦ ‹ዒንሢ ዮርዳኖሴ ዎሮ ዓጮ ሙካዖ ዎሮኮ ሳዛ ጌሊ ዔቁዋቴ› ጌዒ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","ዬካፓ ዒያሱ ዒስራዔኤሌ ዴሮም፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጋዓ ባኮ ሃኒ ሙኪ ዋይዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","ዒንሢ ሴካ ቤርቲም ሂዒ ዴንዳ ዎዶና ዒዚ ካኣናኔ ዓሶ፥ ሂኢታ ዓሶ፥ ሂዋዌ ዓሶ፥ ፔሪዛ ዓሶ፥ ጌርጌሳ ዓሶ፥ ዓሞራ ዓሶንታ ዒያቡሳ ዓሶንታ ዒንሢኮ ቤርታፓ ኬሳንዳኔ፤ ናንጊና ባይቁዋ ፆኦዛሢ ዒንሢ ባኣካ ማዔሢ ዒንሢ ዔራንዳሢ ዬያናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","ዓጮ ቢያኮ ጎዳ ማዔ ፆኦዛሢኮ ጫኣቁሞ ሳኣፂና ዒንሢኮ ቤርታ ዮርዳኖሴ ዎሮ ጌላንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ሃሢ ፔቴ ፔቴ ዒስራዔኤሌ ቶይዶ ማኣራፓ ፔቴ ፔቴ ዓሲ፥ ዎሊ ዑፃ ታጶ ላምዖ ዓሲ ዶኦሩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","ዓጮ ቢያኮ ጎዳ ማዔ ፆኦዛሢኮ ጫኣቁሞ ሳኣፂኖ ኬዴ ቄኤሶኮ ቶካ ዋኣፆ ሄሄርቃኣና ዮርዳኖሴ ዎሮ ዋኣፃ ቃዚንታንዳኔ፤ ሎኦፓ ጎዒ ሙካ ዲጶ ዋኣፃ ፔቴይዳ ቡኪ ኩሊንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","ዬይ ዎዳ ባርጊ ዎዴታሢሮ ዎራ ዒማና ኩሚ ዓኣኔ። ዴራ ዮርዳኖሴ ዎሮና ፒንቃኒ ዱንኪ ዴዔ ቤዛፓ ዔቃዛ ጫኣቁሞ ሳኣፂኖ ኬዴ ቄኤሳ ዓሶኮ ቤርታ ቤርታ ዴንዴኔ፤ ቄኤሳ ዋኣፆይዳ ሄሄርቃዛ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ዋኣፃ ጎዒፆ ሃሺ ቃዚንቴኔ፤ ፃርታኔ ኮይላ ዓኣ ዓዳኣሜ ጌይንታ ካታሞ ሄላንዳኣና ዋኣፃ ቃዚንቲ ዴዔኔ፤ ሶኦጌ ባዚ ባንሢ ዴንዳ ዲጳ ጋፒ ቃዚንቴሢሮ ዴራ ዒያርኮ ሱኮ ፒንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","ዴራ ፃኣዾ ጎይፆይዴና ሃንቲ ፒንቃኣና ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዴ ቄኤሳ ዴራ ፒንቂ ጋፓንዳያ ሄላንዳኣና ዮርዳኖሴ ዎሮኮ ሳዛ ፃኣዾ ሳዓ ዔዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","ዒስራዔኤሌ ዴራ ጉቤ ዮርዳኖሴ ዎሮና ፒንቄስካፓ ናንጊና ናንጋ ጎዳ ዒያሱም፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","«ዒስራዔኤሌ ፃጶ ፔቴ ፔቴሢ ማኣራፓ ፔቴ ፔቴ ዓሲ ዔኪ፥ ዎሊ ዑፃ ታጶ ላምዖ ዓሲ ዶኦሬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ዮርዳኖሴ ዎሮኮ ሳዛ፥ ቄኤሳ ዔቄ ቤዞይዳፓ ታጶ ላምዖ ሹቺ ዔያታ ዔኪ ኬስካንዳጉዲ ዓይሤ፤ ዬያ ሹጮ ዔኪ ዴንዲ ዒንሢ ዒባኒ ዎርቃንዳ ቤዛ ዔያታ ዻኣባንዳጉዲ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ዒያሱ ዬንሢ ዒ ዶኦሬ፥ ታጶ ላምዖ ዓሶንሢ ዔኤላዖ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","«ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ጫኣቁሞ ሳኣፂና ዓኣ ቤዞ ኬዲ ፔቴ ፔቴ ዒስራዔኤሌ ፃጶ ማኣሮ ዓሶ ሱንፆና ፔቴ ፔቴ ሹቺ ዔኩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ዬንሢ ሹጫ ናንጊና ናንጋ ጎዳ ማዼ ባኮ ቢያ ዒስራዔኤሌ ዴሮም ጶቂሣያ ማዓንዳኔ፤ ሙካ ዎዶይዳ ቢያ ዒንሢኮ ናኣታ ‹ሃይ ዓይጎ ሹቺዳይ?› ጌይ ዒንሢ ዖኦጬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ዒንሢ ዔያቶም፦ ‹ናንጊና ናንጋ ጎዳ ማዔ ዒንሢ ፆኦዛሢኮ ጫኣቁሞ ሳኣፂና ዮርዳኖሴ ዎሮና ፒንቃኣና ዎታ ዋኣፃ ቃዚንቴኔ፤ ዬያሮ ሃንሢ ሹጮንሢ ሃኖ ቤዞይዳ ማዺንቴ ባኮ ቢያ ቢያ ዎዴ ዒስራዔኤሌ ዴሮም ጶቂሣ ማላታኬ› ጎዑዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ዒያሱ ዔያቶም ኬኤዜ ጎይፆ ዓሳ ማዼኔ፤ ናንጊና ናንጋ ጎዳ ዒያሱም ዓይሤ ጎይፆጉዴያ ዒስራዔኤሌ ፃጶ ማኣሮ ፓይዶ ጉዴያና ዮርዳኖሴ ዎሮ ሳዛፓ ታጶ ላምዖ ሹቺ ዔኪ ዔያታ ዱንኪ ዴዔ ቤዛ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","ዒያሱ ሃሣ ዒማና ቄኤሳ ጫኣቁሞ ሳኣፂኖ ኬዲ ዔቄ፥ ዮርዳኖሴ ዎሮኮ ሳዛ ታጶ ላምዖ ሹቺ ማላታ ማዓንዳጉዲ ዻኣቤኔ፤ ዬንሢ ሹጫ ሃኖ ሄላንዳኣና ዒኢካ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","ዒያሱ ዴሮም ኬኤዛንዳጉዲ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆ ቢያ ባካ ማዺንቲ ጋፓንዳያ ሄላንዳኣና ቄኤሳ ዮርዳኖሴ ዎሮ ሳዛ ዔቂ ዚቲዮ ጌዔኔ፤ ሙሴያ ዒያሱ ዓይሤሢ ዒማዺኬ፤ ዴራ ዒማና ዎሮ ጊዴና ዑኬ ፒንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","ቢያሢ ፒንቂ ጋፔስካፓ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዴ ቄኤሳኣ ፒንቃዖ ዎንዴ ዴንዳ ጎይፆ ዴሮኮ ቤርታ ዴሮ ዔኪ ዓኣዺፆ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","ዒማና ሮኦቤኤሌና ጋኣዴና ሃሣ ሚናኣሴኮ ዛሎ ማኣሮ ዓሶና ዖሎም ዔያታ ጊኢጊንቴያታሢሮ ሙሴ ዔያቶ ዓይሤ ጎይፆና ዴሮኮ ቤርታ ዎሮና ፒንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","ዔያቶ ባኣካፓ ዶኦሪንቴያ ዖይዲታሚ ሺያ ዖልዚ ዖላኒ ጊኢጌ ዓሲ ናንጊና ናንጋ ጎዳ ቤርታ ማዒ ዒያርኮ ኮይላ ዓኣ ቦኦሎ ፒንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ናንጊና ናንጋ ጎዳ ዬኖ ኬሎ ዒስራዔኤሌ ዴሮ ቤርታ ቢያ ዒያሱ ቦንቺሲ ዼግ ዼጊዴኔ፤ ቤርታ ዔያታ ሙሴ ቦንቼሢጉዲ ዒያሱዋ ዒ ናንጌ ዎዶ ቢያይዳ ቦንቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","16","ዬካፓ ናንጊና ናንጋ ጎዳ ዒያሱም፦ «ጫኣቁሞ ሳኣፂኖ ኬዴ ቄኤሳ ዮርዳኖሴ ዎራፓ ኬስካንዳጉዲ ኬኤዜ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ቄኤሳ ኬስካንዳጉዲ ዒያሱ ዔያቶ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ዒማና ቄኤሳ ዎሮ ሳዛፓ ኬስኪ፥ ቶካ ዔያቶኮ ፃኣዾ ሳዖ ሄሄርቃኣና ዎሮ ዋኣፃ ቤርታ ኩሚ ዴንዳሢ ጎይፆ ዴንዲፆ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","ቤርታሳ ዓጊኖኮ ታጳሳ ኬሎ ዮርዳኖሴ ዎሮና ዴራ ፒንቂ ዒያርኮኮ ዓባ ኬስካ ዛላ ዓኣ ጌልጌላይዳ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","ዒኢካ ዒያሱ ዮርዳኖሴ ዎራፓ ዔኬ፥ ታጶ ላምዖ ሹጮንሢ ዻኣባዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","ዒስራዔኤሌ ዴሮም፦ «ሃጊ ሙካንዳ ዎዶይዳ ዒንሢኮ ናኣታ ‹ሃይ ዓይጎ ሹቺዳይ?› ጌዒ ፔኤኮ ዓዶንሢ ዖኦጬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","ዒስራዔኤሌ ዓሳ ዮርዳኖሴ ዎሮና ፃኣዺ ሳዓይዳ ሄርቂ ፒንቄያ ማዔሢ ዒንሢ ዔያቶም ኬኤዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","ናንጊና ናንጋ ጎዳ ማዔ ኑኡኮ ፆኦዛሢ ሚና ኑም ኑ ፒንቃንዳጉዲ ዞቄ ባዞ ሚጪሴሢጉዲ ዒንሢማኣ ዮርዳኖሴ ዎሮ ዋኣፆ ዒንሢ ፒንቃንዳጉዲ ሚጪሴሢ ኬኤዙዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","ዬያሮ ሳዓይዳ ናንጋ ዴሬ ቢያ ናንጊና ናንጋ ጎዳኮ ዎልቃ ዎማዒ ዼኤፒታቴያ ዔራንዳኔ፤ ዒንሢያ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዒጊጪ ቦንቺ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛሎና ዓኣ ዓሞራ ዓጮ ካኣቶንታ ሜድቴራኒያ ባዞ ኮይሎ ኮይሎ ዓርቂ ናንጋ ካኣናኔ ዓጮ ካኣታ ቢያ ዒስራዔኤሌ ዴራ ዎሮና ፒንቃንዳጉዲ ናንጊና ናንጋ ጎዳ ዮርዳኖሴ ዎሮ ዋኣፆ ዎማይዲ ሚጪሴቴያ ዋይዜኔ፤ ዬያሮ ዔያታ ዒስራዔኤሌ ዓሶ ዒጊጪ ጎጲ ዋኣፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ናንጊና ናንጋ ጎዳ ዒማና ዒያሱም፦ «ቲሊንጊ ጊኢጊሺ ዒስራዔኤሌ ዓሶኮ ዓቲንቶ ቤርቶ ቲቄ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","ዒያሱዋ ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆና፦ «ዓቲንቶ ቤርቶ ቲቆና ጌሜሮ» ጌይንታ ቤዛ ዒስራዔኤሌ ዓሶኮ ዓቲንቶ ቤርቶ ቲቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","ዒያሱ ዔያቶኮ ዓቲንቶ ቤርቶ ቲቄሢ ዖሎ ዖላኒ ዳንዳዓ ዓቲንቃ፥ ጊብፄ ዓጫፓ ኬስኬ ዓሳ ቢያ ዓሲ ናንጉዋ ዳውሎይዳ ጎይፃ ሃይቄሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ቤርታ ጊብፄ ዓጫፓ ኬስኬ ዓቲንቃ ቢያ ዓቲንቶ ቤርቶ ቲቂንቴያ ማዔቴያ ዓሲ ናንጉዋ ዳውሎይዳ ጎይፃ ዓኣዖ ሾይንቴ ዓቲንቆ ናኣቶኮ ዓቲንቶ ቤርታ ቲቂንቲባኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","ጊብፄ ዓጫፓ ኬስኬ፥ ዖሎ ዖላኒ ዳንዳዓ ዓቲንቃ ናንጊና ናንጋ ጎዳ ጋዓ ባኮ ዋይዞ ዒፄሢሮ ቢያሢ ጋፓንዳያ ሄላንዳኣና ዒስራዔኤሌ ዓሳ ቦኦሎ ጉራ ሴካ ሃንጋ ሜታዺ ሃንቴኔ። ዔያቶኮ ናኣቶኮ ናኣቶም ዒንጋኒ ቤርታ ዔያቶኮ ዓዶንሢም ጫኣቄ፥ ዔኤዞና ዲኢቆና ኩሜ ዓጬሎ ዔያቶኮ ዓሲ ናንጉዋ ዳውሎይዳ ሃይቄ ናኣታ ዛጊንዱዋያታሢ ናንጊና ናንጋ ጎዳ ቤርታ ኬኤዚናኣኮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ዒያሱ ዓቲንቶ ቤርቶ ቲቄ ዓሳ ናንጊና ናንጋ ጎዳ ዔያቶ ቤዛ ኬሴ ናኣቶኬ፤ ዔያታ ጎይፆይዳ ዓኣዖ ዓቲንቶ ቤርቶ ቲቂንቲባኣያታሢሮ ቲቂንቱዋዖ ዎላ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","ዓሳ ቢያ ዓቲንቶ ቤርቶ ቲቂንቴስካፓ ኪፃ ፓፃንዳያ ሄላንዳኣና ጉርዳ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ናንጊና ናንጋ ጎዳ ዒያሱ ኮይላ፦ «ጊብፄይዳ ዒንሢ ዓይሌ ማዒ ናንጌ ናንጎ ዻውሲንቶ ታ ዒንሢዳፓ ሃይሾ ሃኖ ሺኢሼኔ» ጌዔኔ፤ ዬና ቤዜላ ሃኖ ሄላንዳኣና ጌልጌላ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","ዒስራዔኤሌ ዓሳ ዒያርኮኮ ኮይላ ዓኣ ቦኦላ ጌልጌላይዳ ዱንኪ ዴዒ ዓኣዖ ዬኖ ዓጊኖኮ ታጶ ዖይዳሳ ኬሎኮ ዒባኖ ዑሣ ዓኣዺፆ ቦንቾ ቦንቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","ዔያታ ዒማና ካኣናኔ ዓጮ ሃኣኮ ሙይፆ ዓርቄሢ ዒማ ጉቶኬ፤ ዔያታ ሙዔሢ ሚቾና ቲሾንታ ሙኑቃ ፃኣዛ ጌሊባኣ ላኣዳንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","ዬኖ ዓጮይዳፓ ጴዻ ሙዖ ዔያታ ሙይፆ ዓርቄ ኬላፓ ዓርቃዖ ማና ጌይንታ ሙዓ ጫሪንጫፓ ኬዲፆ ሃሼኔ፤ ዒስራዔኤሌ ዓሳ ዬካፓ ዬኖ ማኔሎ ዴንቃኒ ዳንዳዒባኣሴ። ዬማፓ ዓርቃዖ ካኣናኔይዳ ባቃሊ ካፄ ሜዎ ሙይሢ ዔያታ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","ዒያሱ ዒያርኮ ኮይላ ዓኣንቴ ጬንቻ ዓፓሮ ዓርቄ፥ ፔቴ ዼጌ ዒዚ ዔሪባኣንቴ ቤርታ ዔቂ ጴዼኔ፤ ዒማና ዒያሱ ዒዛ ባንሢ ዶጫዖ፦ «ኔኤኒ ኑ ዓሲሞ ኑ ሞርኮ ዓሲዳይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","ዼጌሢ ማሃዖ፦ «ታኣኒ ዒንሢ ዓሲያቱዋሴ፥ ሞርኮ ዓሲያቱዋሴ፤ ጋዓንቴ ናንጊና ናንጋ ጎዳኮ ዖሎ ዓሶ ዓይሣያታሢሮ ሃይሾ ታ ሙኬኔ» ጌዔኔ። ዒማና ዒያሱ ባሊቶ ሳዖ ሄሊሲ ዚጋዖ፦ «ናንጊና ናንጋ ጎዳሢዮ! ታኣኒ፥ ኔኤኮ ዓይላሢ ዓይጎ ማዾም ኔ ጋዓይ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ናንጊና ናንጋ ጎዳኮ ዖሎ ዓሶ ዓይሣሢ፦ «ኔ ዔቄ ሳዓ ታኣም ዱማዼያታሢሮ ቶካፓ ዱርዞ ኔኤኮ ኬሴ» ጋዓዛ ዒያሱ ዒዚ ዓይሤ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","ዒስራዔኤሌ ዓሶ ዒጊጪሢና ዒያርኮ ካታሞኮ ጌሎ ጌሎ ካራ ዎዺንቲ ካፒንታኔ፤ ዬያሮ ካታሞ ጌላኒና ኬስካኒ ዳንዳዓ ዓይጎ ዓሲያ ባኣሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ናንጊና ናንጋ ጎዳ ዒያሱም፦ «ዒያርኮንታ ካኣቲንታ ሃሣ ፖኦሊሶዋ ኔኤም ታ ዓኣሢ ዒንጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","ኔናንታ ኔኤኮ ፖኦሊሶንታ ላሆ ኬሊ ጉቤ ካታሞኮ ኬኤሎ ዲፆ ዙሎ ዎሊ ጊንፆ ፔቴ ማይንቲ ማይንቲ ሺሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ዒማና ዛዬ ኩጫ ኩጫ ዓርቄ ላንካይ ቄኤሴ ጫኣቁሞ ሳኣፂኖኮ ቤርታ ቤርታ ዴንዶንጎ፤ ላንካሳ ኬሎና ቄኤሶንሢ ዛያሢ ዋርቃዛ ኔናንታ ዖሎ ዖላ ዓሶንታ ዎላ ካታሜሎ ላንካይ ማይንቲ ሺሩዋቴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","ላንካሶ ሺሪፆይዳ ቄኤሳ ዛያሢኮ ዑኡዞ ዼጊዲ ዋርቆንጎ፤ ዬያ ዋዋይዛዖ ዓሳ ቢያ ዑኡዞ ዼጊዲ ዒላቶንጎ፤ ዬማና ካታሜሎኮ ኬኤሎ ዲፃ ዶዓንዳኔ፤ ዬያሮ ዖሎ ዓሳ ጉቤ ካታሜሎ ዔያታ ዓኣ ዛሎና ጉቤ ጌጌሎንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ዒያሱዋ ቄኤሶ ዔኤሊ፦ «ጫኣቁሞ ሳኣፂኖ ኬዱዋቴ፤ ዒንሢዳፓ ላንካይ ዓሲ ዛዬ ዔኪ ሳኣፂኖኮ ቤርታ ቤርታ ዓኣዾንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","ሃሣ ዒያሱ ዴሮ፦ «ዴንዱዋቴ፤ ካታሜሎ ሺሩዋቴ፤ ዖሎ ዖላ ዓሳ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ቤርታ ዴንዶንጎ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ዒያሱ ዴሮ ዓይሤ ጎይፆ ናንጊና ናንጋ ጎዳ ቤርቶይዳ ዛያሢ ዋርቃ ላንካይ ቄኤሴ ኬስኬኔ፤ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዴ ዓሳ ዬካፓ ሄሊሲ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ዖሎ ዖላ ዓሳ ዛያሢ ዋርቃ ዓሶኮዋ ቤርታ ዴንዴኔ፤ ቄኤሳ ዛያሢ ሃሹዋዖ ዋርቂ ዋርቂ ዴንዳዛ ዴራ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ጊንፆ ዴንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","ዒያሱ ጋዓንቴ፦ « ‹ዒላቱዋቴ› ታ ጋዓንዳ ኬሎ ሄላንዳኣና ዒንሢ ዒላቱዋጉዲ፤ ዑኡሲ ዒንሢ ዋይዙሱዋጉዲ፤ ፔቴታዖ ዒንሢ ዔኤቢ ጎዑዋጉዲ፤ ‹ዒላቱዋቴ› ታ ጋዓ ኬሎማና ዒላቱዋቴ» ጌይ ዴሮ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ዬያይዲ ዒዚ ዓሶ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖና ዎላ ፔቴ ማይንቲ ካታሞ ሺርሼኔ፤ ዬካፓ ዴራ ዔያታ ዱንኪ ዴዔ ቤዞ ማዒ ሙኪ ዒኢካ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","ዚሮ ጉቴሎ ዒያሱ ጉቴ ዓሚ ዔቄኔ፤ ቄኤሳኣ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ላንካዎ ዛያሢ ዓርቄ፥ ላንካዎ ቄኤሳ ዛያሢ ሃሹዋዖ ዋርቂ ዋርቂ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ቤርታ ዴንዳኔ፤ ዒማና ዖሎ ዓሳ ቄኤሶኮ ቤርታ ዴንዳዛ ሃንጎ ዴራ ጫኣቁሞ ሳኣፂኖ ሄሊ ዴንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ዬያይዲ ላምዓሳ ኬሎናኣ ካታሜሎ ፔቴና ሺሬስካፓ ዴራ ጊንሣ ጉርዶ ሙኬኔ፤ ዴንዲ ላሆ ኬሊ ሄላንዳኣና ዒማ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ላንካሳ ዓቦ ሳዖኮ ዲጊጫ ዞቃኣና ሚኢሪ ዔቂ ዬኖ ጎይፆ ካታሜሎኮ ዙሎ ላንካይ ማይንቲ ዔያታ ሺሬኔ፤ ዔያታ ላንካይ ሺሬሢ ዒዞ ኬሎ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ላንካሶ ዔያታ ሺራኣና ቄኤሳ ዛያሢ ዋርቃኒ ጊኢጋዛ ዒያሱ ዴሮ፦ «ናንጊና ናንጋ ጎዳ ካታሜሎ ዒንሢም ዒንጌሢሮ ዒላቱዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","ካታሜሎና ዒዞይዳ ዓኣ ባኮና ቢያ ናንጊና ናንጋ ጎዳም ዱማዼያታሢሮ ጋፒሲ ባባይዙዋቴ፤ ጋዓንቴ ዞኦዛ ኮኦማ ላኣሌላ ኑ ዳኬ ሙሮ ዓሶ ዓኣቺ ዓይሴሢሮ ዓታንዳያ ኮይሳሢ ዒዞና ዒዞ ማኣራ ዓኣዞንሢ ሌሊኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","ዒንሢ ዒስራዔኤሌ ዓሶ ጉርዶይዳ ሜቶና ባይሲንታና ዔኪ ዬዑዋጉዲ ጋፒሲ ባይዞንዳያ ኮይሳ ባኮይዳፓ ዓይጎዋ ዓፃዺ ዔኩዋጉዲ ዒንሢና ዔሩዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","ቢራ ዓንጊንታ ዎርቄንታ ሞኦኖ ዓንጎንታ ሃንጎ ዓንጎና ማዢንቴ ባኣዚ ቢያ ናንጊና ናንጋ ጎዳም ዱማዼያ ማዖንጎ፤ ዬይ ባካ ናንጊና ናንጋ ጎዳኮ ሜሆ ጌሦ ኬኤፃ ጌሢንታኒ ኮይሳኔ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ዬያሮ ዛያሢ ዋርቂንቴኔ፤ ዴራ ዬያ ዛያሢ ዑኡዞ ዋይዛዖ ዼጊዲ ዒላታዛ ካታሜሎኮ ኬኤሎ ዲፃ ዶዔኔ፤ ዬካፓ ዖላ ዓሳ ዓኣ ዛሎና ጉቤ ካታሜሎ ጌሊ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ዔያታ ፔኤኮ ጬንቾ ዓፓሮ ቱጊ ካታሞይዳ ዔያታ ዴንቄ፦ ዓቲንቃ፥ ላኣላ፥ ዼጌሢንታ ጋርቾንታ ቢያ ዎዼኔ፤ ዬያጉዲ ባኣቶንታ ማራቶንታ ሃሮዋ ቢያ ዎዺ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","ቤርታ ሙሮ ዳኪንቴ ላምዖ ዓሶንሢም ዒያሱ፦ «ዞኦዛ ኮኦማ፥ ሬዓባ ማኣሪ ዴንዲጋፓ ዒንሢ ዒዞም ጫኣቄ ጎይፆና ዒዞና ዒዞኮ ማኣራ ዓኣ ዓሶና ኬሱዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ዔያታ ዒማና ዴንዲ ሬዓባ ዒዞኮ ዓዶንታ ዒንዶንታ ጌርሲንሢንታ፥ ሃሣ ሃንጎ ዒዞኮ ዒጊኖንታ ቢያ ዎላ ኬሲ ዒስራዔኤሌ ዓሳ ዱንኪ ዴዔ ጉርዶኮ ዙላ ዴይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","ዬካፓ ካታሜሎ ዒዞኮ ጋራ ዓኣ ባኮ ቢያ ዓይሱዋዖ ሚቼኔ፤ ጋዓንቴ ቢሮ ዓንጎና ዎርቆና ዬያጉዲ ሞኦኖ ዓንጎና ሃንጎ ዓንጎና ኮሺንቴ ባካ ዓታዛ ቢያ ባኮ ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","ጋዓንቴ ዞኦዛ ኮኦማ፥ ሬዓባ ጎዖዛ ዒያርኮ ዓጮ ሙሮ ዳኮና ላምዖ ዓሶንሢ ዓኣቺ ሃይባፓ ዓይሴሢሮ ዒያሱ ዒዞ ዒዞኮ ማኣሮ ዓሶና ዒዞና ዎላ ዓኣ ሃንጎ ዓሶዋ ቢያ ሃይባፓ ዓይሴኔ፤ ዒዞኮ ዜርፃ ሃኖ ሄላንዳኣና ዒስራዔኤሌ ዓጮይዳ ናንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","ዒማና ዒያሱ፦ «ሃኖ ዒያርኮ ካታሜሎ ማዣኒ ዓርቃ ዓሲ ጋዳንቂንቴያ ማዖም፤ ዒዚ ቤዞ ዓርቂ ቦኦኮልቃኣና ቶይዶ ናዓ ዒዛኮ ባይቆም፤ ካታሜሎ ጌሎ ካሮ ዒ ዾቃኣና ጋፒንፆ ናዓ ባይቆም» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ዬያይዲ ናንጊና ናንጋ ጎዳ ዒያሱና ዎላ ማዔሢሮ ዒያሱኮ ሱንፃ ዓጮ ቢያይዳ ዋይዚንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","ባይዛኒ ኮይሳ ባካ ቢያ ባይቃንዳጉዲ ሃሣ ፆኦሲም ዱማዼ ባኮይዳፓ ዔያታ ፔቴታዖ ዔኩዋጉዲ ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶም ኬኤዜሢ ዓሳ ቦንቺባኣሴ፤ ዬያ ዓይሢፆ ሃሼሢ ዓካኔ ጎዖሢኬ፤ ዬያሮ ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶይዳ ሚርጌና ዻጋዼኔ፤ ዓካኔ ዪሁዳ ማኣሮ ዓሳፓ ካርሚ ናይ፥ ዜብዲኮ ናኣዚ ናይ ማዓያ ዛራሄ ናይኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","ዒያሱ ዒያርኮይዳ ዓኣዖ ቤቴዓዋኔ ኮይላ ቤኤቴኤሌኮ ዓባ ኬስካ ዛላ ዓኣ ዓይ ጌይንታ ካታሜላ ዎዚጉዴ ቤሲዳ ዓኣቴያ ሙሪ ሙካንዳጉዲ ዻካ ዓሲ ዳኬኔ፤ ዬያ ዔያታ ዓይሢንቴ ጎይፆ ማዺ ማዔስካፓ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","ዒያሱም፦ «ዓይ ካታሞ ዖሊ ዓርቃኒ ዓሳ ጉቤ ዴንዳንዳያ ኮይሱዋሴ፤ ላምዖ ሃንጎ ሃይሦ ሺያ ዓሲ ሌሊ ዳኬ፤ ዔያታ ዻካ ዓሲታሢሮ ዬኖ ዖላኒ ዖላ ዓሶ ቢያ ዳኪ ጉሪ ላቢሲፖ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ዬያሮ ሃይሦ ሺያ ዓሲ ዒስራዔኤሌ ዓሶፓ ዴንዲ ዒዞ ዖሌኔ፤ ጋዓንቴ ዬይ ዖሎ ዓሳ ዓይኮ ዖሎ ዖላ ዓሶ ቤርታፓ ባሺንቲ ጳሽኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ዓይ ዓሳ ካታሞኮ ጌሎ ካራፓ ዓርቃዖ ዒስራዔኤሌ ዓሶ ዳውሲ ዴንዲ ሹጮ ጳሎ ጎኦቦ ሄላንዳኣና ቲፓሢዳ ሃይሢታሚ ላሆ ዓሲ ዎዼኔ፤ ዬያሮ ዒስራዔኤሌ ዓሳ ዒጊጪ ጎጲ ዋኣፄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","ዒያሱንታ ዒስራዔኤሌ ዓሶኮ ሱኡጎንታ ዖዪ፥ ማኣዓሢ ፔኤኮ ዳርዚ፥ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖኮ ቤርታ ዓባ ጌላንዳያ ሄላንዳኣና ባሊቲና ሎኦሚ ላሄኔ፤ ዖዪፆዋ ዔርዛኒ ቶኦካ ፔኤኮ ሲላሊ ዋሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ዒማና ዒያሱ፦ «ዔኤዔ! ቢያ ባኮ ማዤ ናንጊና ናንጋ ጎዳሢዮ! ኑና ዮርዳኖሴ ዎሮና ፒንሢ ኔ ዓይጋ ዔኪ ዬዔይ? ዓሞራ ዓሳ ኑና ኩርሳንዳጉዲ ዔያቶ ኩጫ ዓኣሢ ዒንጋኒዳ? ዮርዳኖሴ ሱካ ኑ ዴዔቴ ዓይጌ ዓኣይ! ");
INSERT INTO mdyeth_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","ቢያ ባኮ ማዤ ጎዳሢዮ! ዒስራዔኤሌ ፔ ሞርኮ ቤርታፓ ባሺንቲ ጳሽካዛ ታኣም ጎዖንዶ ጎይፃ ዔርቶ ዒፄንቴሞ? ");
INSERT INTO mdyeth_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","ማይ ካኣናኔ ዓሶንታ ሃኖ ዓጮይዳ ዓኣ ሃንጎ ዓሳ ቢያ ዬያ ዋይዛንዳኔ፤ ዬያሮ ዔያታ ኑና ማንጊ ቢያ ጋፒሳንዳኔ፤ ዓካሪ ኔ ሱንፃ ቦንቺንታንዳጉዲ ኔ ዓይጎ ማዻንዳይ?» ጌይ ሺኢቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ናንጊና ናንጋ ጎዳ ዒያሱም፦ «ዔቄ! ዓይጎሮ ኔ ሃያይዲ ባሊቶና ሳዓ ሎኦሚ ላሄይ? ");
INSERT INTO mdyeth_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","ዒስራዔኤሌ ዓሳ ዻቤኔ፤ ዔያታ ካፓንዳጉዲ ታ ዔያቶ ዓይሤ ጫኣቁሞዋ ዔያታ ሃሼኔ፤ ላኣጊንቴ ባኮይዳፓ ዉኡቂ ዔያታ ዔኬኔ፤ ፔ ባኮና ዎላ ሲኢራዖ ሉኡቃያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ዔያታ ፔኤኮ ሞርኮ ባሻኒ ዳንዳዒባኣሢ ዬያሮኬ፤ ዔያታ ጋዳንቂንቴያ ማዔሢሮ ፔ ሞርኮም ዙሌ ዒንጊ ዔያታ ጳሽኬኔ፤ ባይዛንዳጉዲ ዓይሢንቴ ባኮ ዒንሢ ባኣካፓ ዒንሢ ባይዚባኣያታቴ ታ ዒንሢና ዎላ ማዓዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","ሃሢ ዴንዴ! ዴሮዋ ጌኤሼ! ዔያቶም፦ ‹ዒንሢ ባኣካ ላኣጊንቴ ባኣዚ ዓኣሢሮ ናንጊና ናንጋ ጎዳ፥ ዒስራዔኤሌ ፆኦዛሢ ዚራኣ ኬሎም ዒንሢ ጌኤሹዋቴ› ጋዓኔ ጌይ ኬኤዜ። ዒስራዔኤሌ ዓሲዮቴ! ዬያ ላኣጊንቴ ባኮ ዒንሢ ባኣካፓ ዒንሢ ኬሲባኣቴ ዒንሢ ሞርኮ ቤርታ ዒንሢ ዔቃዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","ዬያሮ ዚሮ ጉቴ ፔቴ ፔቴ ፃጳ ማኣሮና ማኣሮና ፓቂንቲ ታ ቤርቶ ሺኢኩዋቴ፤ ታኣኒ ዱማሳ ፃጳ ፔ ቶኦኮ ቶኦኮ ጊንፆ ዱማዺ ሺኢኮንጎ፤ ሃሣ ታ ዱማሴ ቶኦካ ፔ ማኣሮ ዓሶና ዱማዺ ሺኢኮንጎ፤ ማኣሮ ታ ዱማሳዛ ዓሢ ፔኤሮ ሺኢኮም፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ዬካፓ ባይዛኒ ኮይሳያ ማዔ፥ ላኣጊንቴ ባኮ ዔኬ ዓሢ ናንጊና ናንጋ ጎዳ ጫኣቄ ጫኣቁሞ ዳኣቄሢሮ ሃሣ ዒስራዔኤሌ ዓሶይዳኣ ዻቢንቲ ዔኪ ሙኬሢሮ ዒዛንታ ዒዛሮ ማዔ ባካ ቢያ ታሚና ሚቺንቶንጎ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","ዚሮ ጉቴሎ ጉቴ ዓማ ዒያሱ ዒስራዔኤሌ ዓሶ ፃጶ ፃጶ ማኣሮና ዔኪ ሺኢሼኔ፤ ዬካፓ ዪሁዳ ማኣራ ዱማዺ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","ዬያሮ ዒያሱ ዪሁዳ ማኣሮ ዓሶ ፔ ቶኦኮና ቶኦኮና ፓቂ ሺኢሼኔ፤ ዬካፓ ዛራሄ ቶኦካ ዱማዺ ኬስኬኔ፤ ሃሣ ዒ ዛራሄ ቶኦኮዋ ፔ ማኣሮ ዓሶና ዓሶና ዱማሲ ሺኢሼኔ፤ ዬያይዴም ዛብዲ ማኣሮ ዓሳ ዱማዺ ኬስኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","ዛብዲ ማኣሮ ዓሶኮ ጊንሣ ፔቴ ፔቴ ዓሶ ዱማሲ ሺኢሼኔ፤ ጋፒንፆይዳ ዛብዲኮ ናኣዚ ናይ ማዔ፥ ካርሚ ናኣዚ፥ ዓካኣኔ ዱማዺ ኬስኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ዬካፓ ዒያሱ ዓካኣኔ ኮይላ፦ «ታ ናዓሢዮ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢ ቦንቺ ቡኡፄ፤ ኔ ማዼ ባኮዋ ታኣም ዓኣቹዋዖ ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","ዓካኣኔ ዒማና፦ «ጎኔኬ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢም ዋይዞ ዒፂ ታ ዻቤኔ፤ ታ ማዼ ባካ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","ዲዒ ኑ ዔኬ ባኮይዳ ባብሎኔ ዓሶኮ ሚዛጲ ዼኤፒ ኮኦቴ፥ ላምዖ ኪሎ ማዓ ቢራ ዓንጊ፤ ዛላ ኪሎ ማዓ ዻካ ዻካ ዎርቄ ዴንቃዖ ታና ሚርጌና ናሻዛ ታ ዔኬኔ፤ ቢሮ ዓንጎ ዴማ፥ ሃንጎ ባኮ ዑፃ ጌሢ ታ ዱኡኬም ታ ማኣሮይዳ ዬይ ባካ ሃሢ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","ዒማና ዒያሱ ዓሲ ዳካዛ ዔያታ ዓካኣኔ ማኣሪ ጳሽኪ ዴንዳዖ ዴማ ዓንጎ ቢሮ ጌሢ ዱኡኮና ባኮ ዴንቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ዔያታ ዬያ ባኮ ዒዛ ማኣራፓ ኬሲ ዔኪ፥ ዒያሱና ዒስራዔኤሌ ዓሶና ኮይላ ሙካዖ ናንጊና ናንጋ ጎዳ ቤርታ ጌሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ዬያሮ ዒያሱ ዒስራዔኤሌ ዴሮ ጉቤሢና ዎላ ዓካኣኔ ዔኪ ቢሮ ዓንጎንታ፥ ዼኤፖ ኮኦቶንታ፥ ዎርቆንታ፥ ዒዛኮ ዓቲንቆ ናኣቶንታ ዉዱራሢንታ፤ ዬያጉዲ ሃሣ ሃሮንታ ባኣቶንታ ማራቶንታ ዒዛኮ ማኣሮንታ፤ ዒዛኮ ዓኣ ባኮ ቢያ ሜቶ ዶኦቺ ጌይንታ ቤዞ ዔኪ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","ዬካፓ ዒያሱ፦ «ሃያ ቢያ ሜቶ ኑጊዳ ኔ ዓይጋ ዔኪ ሙኬይ? ሃይሾ! ሃኖ ናንጊና ናንጋ ጎዳ ኔጊዳ ሜቶ ዔኪ ዬዔኔ!» ጋዓዛ፥ ዴራ ቢያሢ ዓካኣኔ ሹቻ ዹይ ዎዼኔ፤ ማኣሮ ዓሶንታ ዒዛሮ ማዔ ባኮዋ ቢያ ታሚና ሚቼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ዒማና ዴራ ዒዛ ዑፃ ሃኖ ሄላንዳኣና ጴዻያ ሚርጌ ሹቺ ኩላ ኩሌኔ፤ ናንጊና ናንጋ ጎዳኣ ፔኤኮ ዻጎ ሃሼኔ፤ ዬያሮ ዬና ቤዛ ሜቶ ዶኦቺ ጌይንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ናንጊና ናንጋ ጎዳ ዬካፓ ዒያሱም፦ «ኔኤኮ ፖኦሊሶ ቢያ ዔኪ ዓይ ካታሞ ዖላኒ ኬስኬ፤ ፔቴታዖ ዒጊጪፖ፤ ጫርቃያ ማዔ፤ ታኣኒ ዓይ ካኣቲ ኔና ባሺሳንዳኔ፤ ዒዛኮ ዴሮንታ ካታሞንታ ሳዖዋ ኔ ኩጮ ጋሮ ታ ጌልዛንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","ሃያኮ ቤርታ ዒያርኮንታ ካኣቲንታ ኔ ዎዺ ባይዜሢጉዲ ዓይንታ ካኣቲንታ ዒማይዴ፤ ጋዓንቴ ዒኢካ ዓኣ ባኮና ባኣቶና ዲዒ ዒንሢሮ ማሂ ዔኩዋቴ፤ ዬያ ማዻኒ ካታሜሎኮ ጊንፆ ዛሊና ሙኪ ዔሪባኣንቴ ዖልዚ ቡላኒ ጊኢጌ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","ዬያሮ ዒያሱ ፔኤኮ ፖኦሊሶ ቢያሢና ዎላ ዓይ ዖላኒ ጊኢጊንቴኔ፤ ፖኦሊሶኮ ባኣካፓ ጎኦባ ጎኦባ ማዔያ ሃይሢታሚ ሺያ ዓሲ ዶኦሪ ዹማ ዳካኒ ጋዓዖ ዔያቶም፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","«ካታሞኮ ጊንፆ ዛላ ዓኣሺንቲ ካቲ ዴዑዋቴ፤ ጋዓንቴ ካታሜሎይዳፓ ሚርጌ ሃኩዋዖ ዖላኒ ጊኢጊ ዴዑዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","ታናንታ ታኣና ዎላ ኬስካንዳ ዖላ ዓሶንታ ካታሜሎ ባንሢ ኑ ሙካንዳኔ፤ ዒማና ዓይ ካታሞኮ ዖሎ ዓሳ ኑና ዖላኒ ኬስካዛ ቤርታ ኑ ማዼ ጎይፆማ ባሺንቴጉዲ ኑ ጳሽካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","ዬያይዲ ካታማፓ ዔያቶ ኑ ሃኪሳንዳያ ሄላንዳኣና ‹ቤርታኣሲጉዲ ኑ ዔያቶ ዳውሴያዋይ› ጌዒ ኑ ጊንፆ ዔያታ ሙካንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ዒማና ዒንሢ ዓኣሺንቴ ቤዛፓ ኬስኪ ካታሜሎ ዓርቁዋቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ካታሜሎ ዓኣሢ ዒንሢም ዒንጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","ካታሜሎ ዓርቃዖ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ታሚና ሚቹዋቴ፤ ታ ዒንሢ ዓይሣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ዬካፓ ዒያሱ ፖኦሊሶ ዳካዛ ዔያታ ዓይኮ ዓባ ጌላ ዛላ ዓይና ቤኤቴኤሌናኮ ሳዛ ዔርቲባኣያ ዓኣሺንቴ ዖልዚ ዓሲ ማዒ ዴዔኔ፤ ዒያሱ ጋዓንቴ ዒዛ ዓሶና ዎላ ቤዛ ዎርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","ዚሮ ጉቴሎ ዒያሱ ቤርታዺ ዔቂ፥ ፖኦሊሶ ዔኤሊ ዒዛንታ ዒስራዔኤሌ ዓሶኮ ሱኡጎንታ ቢያ ፖኦሊሶ ዔኪ ዓይ ባንሢ ዴንዶ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","ዒዛና ዎላ ዓኣ ዖሎ ዓሳ ቤርቲም ዴንዲ ካታሜሎኮ ቤርቶ ዛሎና ሙኪ ዑካዖ ካታሜሎኮ ኬዶ ዛላ ዱንኪ ዴዔኔ፤ ዔያቶና ዓይናኮ ሳዛ ዶኦቺ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","ዒያሱ ዬያኮ ቤርታ ዶንጎ ሺያ ዖልዚ ዓሲ ዶኦሪ ካታሜሎኮ ዓባ ጌላ ዛሎይዳ ዓይና ቤኤቴኤሌናኮ ባኣካ ዓኣሺንቲ ካቲሲ ዴይሢናኣኮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","ዔያታ ዒማና ቤርታ ዖላንዳ ዓሶ ካታሜሎኮ ኬዶ ዛሎና፥ ጊንሣ ሃሣ ሄሊ ሙኪ ዖላንዳ ዓሶ ዓባ ኬስካ ዛሎይዳ ዔቂሴኔ፤ ዒያሱ ጋዓንቴ ዬኖ ዋንቶ ዶኦጮ ባንሢ ዓኣዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","ዓይ ካኣታሢ ዬያ ዴንቃዖ ካታሞ ዴሮና ዎላ ዒስራዔኤሌ ዓሶ ዖላኒ ዮርዳኖሴ ዶኦጮ ባንሢ ሌዔኔ፤ ጋዓንቴ ዔያታ ካታሞኮ ጊንፆ ዛላ ካቲሲ ዴይሦና ዖልዚ ዓሲ ዓኣሢ ዔሪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","ዒማና ዒያሱንታ ዒዛና ዎላ ዓኣ ፖኦሊሶ ቢያሢንታ ባሺንቴያ ማሊ ጊንሢም ዓሲ ናንጉዋ ዳውሎ ባንሢ ጳሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ዬያሮ ካታሞ ዓሳ ዎሊ ዔኤሊ ዔኤሊ ኬስካዖ ዔያቶ ዳውሲሢ ዓርቄኔ፤ ዒያሱ ዔያታ ዳውሴጎይሣ ካታማፓ ሃኪ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ዓይና ቤኤቴኤሌናይዳ ዓኣ ዓሳ ዒስራዔኤሌ ዓሶ ዳውሳኒ ቢያ ኬስካዛ ካታሞኮ ካራ ቡሊንቲ ጉሪ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ናንጊና ናንጋ ጎዳ ዬካፓ ዒያሱም፦ «ዓይ ካታሞ ታ ኔኤም ዓኣሢ ዒንጋንዳሢሮ ኔ ኩጫ ዓኣ ዎርፆ ካታሜሎ ባንሢ ሺርሺ ዼጊዲ ዞንኪ ዓርቄ» ጋዓዛ፥ ዒያሱ ጌይንቴ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","ዒዚ ዬያይዳዛ ዓኣሺንቲ፥ ካቲ ዴዔ ዖሎ ዓሳ ዓኣ ቤዛፓ ኬስኪ ቤርቲም ሩኡሪ ዴንዳዖ ካታሜሎ ጌሊ ዓርቄስካፓ ኔጉዋዖ ታሚ ዓጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ዓይ ካታሞ ዓሳ ጊንሢም ሺሪ ዛጋዖ ካታማፓ ጩቢ ዔቃንቴ ዴንቄኔ፤ ዒማና ዓሲ ናንጉዋ ዳውሎ ባንሢ ጳሽኪ ዴንዴ፥ ዒስራዔኤሌ ዓሳ ዬያቶ ጊንፆ ዳኪ ሙካ ዓሶይዳ ሺሬሢሮ ቶላንዳ ካራ ዔያቶም ባይቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","ዒያሱንታ ዒዛና ዎላ ዓኣ ዖሎ ዓሳ ዔያታ ቤርታ ካቲሲ ጌሤ ዖሎ ዓሳ ካታሜሎ ዓርቄሢ፥ ሃሣ ታሞዋ ዓጌሢ ዴንቃዖ ጊንሣ ማዒ ዓይ ካታማፓ ዖሎሮ ሙኬ ዓሶ ዖሊ ዎዺሢ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ካታሞ ጌሌ ዒስራዔኤሌ ዓሳኣ ዔያቶ ባንሢ ኬዲ ዬኖ ዓሶ ዖሌኔ፤ ዒስራዔኤሌ ዓሳ ዓይ ካታሞ ዴሮኮ ኮይሎ ቢያ ማንጌሢሮ ዔያታ ቶላኒ ዳንዳዒባኣሴ፤ ዔያቶፓ ፔቴ ዓሲታዖ ቶሊ ዓቱዋጉዲ ዒስራዔኤሌ ዓሳ ዔያቶ ጋፒሲ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ዓይኮ ካኣታሢ ጋዓንቴ ዓርቂንቲ ዒያሱ ቤርቶ ሺኢኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","ዒስራዔኤሌ ዓሳ ጉሮ ቦኦሎይዳ፥ ቤርታ ዓይ ዓሳ ዔያቶ ዳውሴ ቤዞይዳ ዔያቶ ቢያ ዎዼስካፓ ካታሞ ጌሊ ዒኢካ ዓቲ ዓኣ ዓሶዋ ዎዺ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ዬኖ ኬሎ ዓይ ዓሶኮ ሃይቄ ዓቲንቆንታ ላኣሎንታ ዎሊ ዑፃ ታጶ ላምዖ ሺያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","ዒያሱ ዒማና ዓይዳ ናንጋ ዓሳ ጋፒ ኩዳንዳያ ሄላንዳኣና ዎርፆ ዒ ዞንኪ ዓርቄ ኩጮ ማሂባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","ናንጊና ናንጋ ጎዳ ዒያሱም ኬኤዜ ጎይፆ ዒስራዔኤሌ ዓሳ ዬኖ ካታሞይዳ ዔያታ ዴንቄ ባኣቶንታ ሜሌ ባኮዋ ቢያ ፔኤም ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","ዒያሱ ዓይ ካታሞ ሚቺ ሃኖ ሄላንዳኣና ዓኣ ጎይፆ ዲቢንሢ ኩሊንቴያ፥ ጉሪ ቤሲ ማሂ ሃሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","ዒዚ ሃሣ ዓይ ካታሞ ካኣታሢ ሚሢዳ ሱፂ ሌዞ ዓባ ጌላንዳያ ሄላንዳኣና ዒኢካ ሱፂንቲ ዴዓንዳጉዲ ሃሼኔ፤ ዓባ ጌላዛ ሌዛ ሚፃፓ ኬዲ ካታሜሎኮ ጌሎ ካራ ኬኤሪንታንዳጉዲ ዓይሤኔ፤ ዒማና ዔያታ ዒዛ ዑፃ ዺቢ ሹቺ ኩሌኔ፤ ዬይ ሹጮ ኩላ ሃኖ ሄላንዳኣና ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","ዬካፓ ዒያሱ ዔባኣሌ ዹኮይዳ ናንጊና ናንንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢም ዒንጎ ባኣዚ ዒንጎንዶ ቤሲ ኮሼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","ዒዚ ዬያ ኮሼሢ ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ዒስራዔኤሌ ዓሶ ዓይሤ ጎይፆና ማዓዛ ዬይያ ሙሴኮ ዓሶ ዎይሦ ዎጎ ማፃኣፖይዳ ፃኣፒንቴ ጎይፆጉዴያ ዓርሲንቲባኣያና ዓንጊ ካኣሚባኣ ሹቺናኬ፤ ዬኖይዳ ሚቺ ዒንጎ ዒንጊሢንታ ፔቱሞና ዒንጎ ዒንጊሢያ ዔያታ ሺኢሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","ዒስራዔኤሌ ዓሳ ዛጋንቴ ሙሴ ፃኣፔ ዎጎ ዒያሱ ሹቺዳ ቆኦቂ ፃኣፔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","ዒስራዔኤሌ ዴራ ዓንጆ ዓንጃንዳጉዲ ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ቤርታ ዓይሤ ጎይፆና ዒስራዔኤሌ ዓሶ ቢያሢንታ ሜሌ ቤዛፓ ሙኬ ዓሶ ጋርቾንታ ዔያቶኮ ሱኡጎንታ ዎጎ ዎጋ ዓሶንታ ናንጊና ናንጋ ጎዳኮ ጫኣቁሞ ሳኣፂኖ ኬዴ፥ ሌዊ ዓሶ ማዔ ቄኤሶኮ ቤርቶ ዛላ ሻውሎና ሚዛቆናይዳ ጌሪዚሜ ዹኮ ሆታ፤ ዛላ ጊንሣ ዔባኣሌ ዹኮኮ ሆታ ዔቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ዬካፓ ዒያሱ ዑኡዞ ዼጊዲ ዎጎ ማፃኣፖይዳ ፃኣፒንቴ ጎይፆ ዓንጆንታ ጋዳሞንታ ዓይሱዋዖ ቢያ ናባቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","ዒያሱ ዒስራዔኤሌ ዴሮ ጉቤሢም ላኣሎንታ ናኣቶንታ ሜሌ ዓጫፓ ሙኬ ዓሶንታ ቢያ ዋይዛንቴ ሙሴ ዓይሤ ዎጎይዳፓ ፔቴ ባኣዚታዎ ዓይሱዋዖ ናባቤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","2","ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ባንፃ ዓኣ ጌሜሮ ዓጮና ዳውሎ ዓጮናይዳ፥ ሜዲቴራኒያ ባዞ ኮይላፓ ዴንዲ ሊባኖኦሴ ሄላንዳኣና ናንጋ ሂኢታ ዓሳ፥ ዓሞራ ዓሳ፥ ካኣናኔ ዓሳ፥ ፔሪዛ ዓሳ፥ ዔዋዌ ዓሶንታ ዒያቡሳ ዓሶንታኮ ካኣታ ዬያ ዋይዛዖ ዎላ ፔቱሞና ዞርቲ ዒያሱንታ ዒስራዔኤሌ ዓሶዋ ዖላኒ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","ጌባዖኦኔ ዓጮ ዓሳ ጋዓንቴ ዒያሱ ዒያርኮና ዓይ ካታሞናይዳ ማዼ ባኮ ቢያ ዋይዜሢሮ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","ዒዛ ጌሻኒ ማሌኔ፤ ዬያሮ ዔያታ ጋላ ጊኢጊሺ፥ ጪንቄ ሱርባንታ ዳርዒፆ ዓጊ ዓጊ ሲኮና ዎይኖ ዑዦ ዓርሦና ሉካኣ ሃሬና ጫኣኒ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ዳርዒ ቱርጫዼ ዓፒላ ማይንቲ፥ ጪንቂ ዱጳንቴ ዓጊ ዓጊ ሲኮና ዱርሲያ ዓኣሢ ዴንዴኔ፤ ዔያታ ዔኪ ዓኣ ካሣ ሜሌያ ሃሣ ሴሜያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","ዬያይዲ ጌልጌላይዳ ዒስራዔኤሌ ዓሳ ዱንኪ ዴዔ ቤዞ ሙካዖ ዒስራዔኤሌ ዓሶ ኮይላ፦ «ኑ ሙኬሢ ሃኬ ዓጪዳፓኬ፤ ኑ ሙካኒ ዳንዳዔሢያ ዒንሢና ዎላ ኮሹሞና ናንጋኒ ጫኣቁሞ ጫኣቃኒኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","ዒስራዔኤሌ ዓሳ ዔያቶ ኮይላ፦ «ዒንሢና ዎላ ኑ ዎዲ ጫኣቃንዳይ? ጎዖንቴ ዒንሢ ኑኡኮ ዑኬ ናንጋ ዓሲታቴሽ?» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","ጌባዖኦኔ ዓሳ ማሃዖ ዒያሱም፦ «ኑ ኔኤኮ ዓይሌ ማዓንዳኔ» ጋዓዛ፥ ዒያሱ ዔያቶ፦ «ዒንሢ ዓይጎ ዓሲዳይ? ዓንካፓ ዒንሢ ሙኬይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","ዔያታ ሃይሶ ኬኤዛዖ፦ «ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ጊብፄ ዓጮይዳ ማዼ ባኮ ቢያ ኑ ዋይዜሢሮ ኑኡኒ ኮሺ ሃኬ ዓጪዳፓ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ዬያጉዲ ሃሣ ዮርዳኖሴ ዎሮኮ ሱካ ዓባ ኬስካ ዛሎና ዓኣ ላምዖ ዓሞራ ዓጮ ካኣቶንሢዳ ዒዚ ማዼ ባኮ ኑ ዋይዜኔ፤ ዬንሢ ላምዖ ካኣቶንሢ ዓስታሮቴይዳ ናንጋ ሃሴቦኦኔ ዓጮ ካኣቲ ሲሆኔና ባኣሳኣኔ ዓጮ ካኣቲ ዖጌናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ኑኡኮ ሱኡጎና ኑ ዓጮይዳ ናንጋ ዴራ ቢያ ጎይፆም ጋላ ኑም ጊኢጊሺ ዴንዲ ዒንሢና ኑ ካኣማንዳጉዲ ዳኬኔ፤ ኑኡኒ ዒንሢም ዓይሌ ማዓንዳጉዲ፥ ሃሣ ዒንሢ ኑኡና ዎላ ኮሺ ናንጋኒ ጫኣቁሞ ጫኣቃንዳጉዲ ኑና ዖኦጮም ዔያታ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","ጋሎ ኑኡኮ ሃኣዛጉዋቴ! ኑኡኒ ኑ ማኣራፓ ዒንሢና ካኣማኒ ኬስካኣና ካሣ ዖይዺታዖ ሃሢ ጎይፃ ሌሊ ሜሊ ሴሜሢ ዛጉዋቴ! ");
INSERT INTO mdyeth_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ሃኣታ ዎይኖ ዑዦ ዓርሦ ሉካኣ ዎይኖ ኑ ዓርሣኣና ዓኪኬ፤ ሃሢ ጋዓንቴ ዳርዔያታሢ ዛጉዋቴ! ሳዓ ሚርጌ ሃኬያታሢሮ ኑኡኮ ማኣዓሢንታ ዱርዞንታ ዳርዒ ጋፔኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ዒስራዔኤሌ ዓሳ ዬኖ ዓሶኮ ጋሎ ዔኪ ዛጋዖ፦ «ጎኔኬ» ጌዔኔ፤ ጋዓንቴ ዬያ ዛሎ ናንጊና ናንጋ ጎዳ ዎዚ ጋዓቴያ ዔያታ ዖኦጪባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ዬያሮ ዒያሱ ዔያቶና ዎላ ኮሺ ናንጋኒ ጫኣቄኔ፤ ሃሣ ዒስራዔኤሌ ዓሶኮ ሱኡጋኣ ዬያ ካፓኒ ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ዬማ ዔያታ ዎላ ጫኣቄ ኬላፓ ሃይሣሳ ኬሎና ዬና ዓሳ ዔያቶኮ ዓሺኒ ማዒ ናንጋያታሢ ዒስራዔኤሌ ዓሳ ዋይዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","ዬካፓ ዒስራዔኤሌ ዓሳ ሃይሦ ኬሊ ሃንታዖ ዬና ዓሳ ናንጋ ካታሞ ሙኪ ሄሌኔ፤ ዔያቶኮ ካታማ፦ ጌባዖኦኔ፥ ኬፒራ፥ ቤዔሮቴና ቂርያት ዓሪሜ ጌይንታያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","ዒስራዔኤሌ ዓሶኮ ሱኡጋ ናንጊና ናንጋ ጎዳ ማዔ ፆኦዛሢ ሱንፆና ዔያቶም ጫኣቄሢሮ ዔያቶ ዎዺባኣሴ። ዬያሮ ዒስራዔኤሌ ዓሳ ጉቤ ፔ ሱኡጎ ዑፃ ጉንዱሜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ዒስራዔኤሌ ዓሶኮ ሱኡጋ ማሃዖ፦ «ጎኔኬ፤ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢ ሱንፆና ኑ ዔያቶም ጫኣቄኔ፤ ዬያሮ ሃሢ ኑ ዔያቶ ዎዻኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","ኑ ዔያቶ ሂዳንዳኔ፦ ዔያቶም ኑ ጫኣቄሢሮ ናንጊና ናንጋ ጎዳኮ ጎሪንታ ኑጊዳ ሙኩዋጉዲ ኑ ዔያቶ ዎዻዓኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ዔያታ ኑ ባኣካ ናንጎንጎ፤ ጋዓንቴ ኑም ሃንፂሌ ሃኣካያ፥ ዋኣሢ ዱዓያ ዔያታ ማዖንጎ» ጋዓዛ፥ ሱኡጋ ጌዔ ጎይፆ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","ዬካፓ ዒያሱ ጌባዖኦኔ ዴሮ ፔ ቤርቶ ዔኤሊ ሺኢሺ፦ «ሃይካ ዒንሢ ዑኬ ናንጋያታዖ ‹ኑኡኒ ሙኬሢ ኮሺ ሃኬ ዓጪዳፓኬ› ጌይ ዓይጋ ኑና ዒንሢ ጌሼይ? ");
INSERT INTO mdyeth_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","ዬያ ዒንሢ ማዼሢሮ ናንጊና ናንጋ ጎዳ ዒንሢ ጋዳንቄኔ፤ ዬያሮ ዒንሢኮ ዴራ ሃንፂሌ ሃኣኪ ሃኣኪ ዋኣሢያ ዱይ ዱይ ናንጊና ናንጋ ጎዳ ማዔ ታ ፆኦዛሢኮ ጌኤዦ ማኣሮይዳ ማዻ ዓይሌ ማዒ ዓታንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","ዔያታ ማሃዖ፦ «ኑ ጎዳ! ጎኔ ዬያ ኑ ማዼኔ፤ ዓይጎሮ ጌዔቴ ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ሴካ ቤርቲም ዒንሢ ዴንዳ ዎዶና ዬያ ዓጮይዳ ናንጋ ዴሮ ዎዺ ዓጮዋ ዒንሢ ዒ ዻካልሳንዳጉዲ ፔ ዓይላሢ ሙሴም ዒ ዓይሤሢ ኑ ዋይዜኔ፤ ኑኡኒ ዬያ ማዼሢ ዒንሢ ኑ ዒጊጬሢሮ ኑ ሼምፓሢ ዓይሳኒ ጌይኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ሃይሾ፥ ማይ ኑ ዒንሢ ኩጮ ጋራኬ፤ ኔኤም ኮሺ ማሊ ጴዼ ባኮ ቢያ ማማዼ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","ዬያሮ ዒያሱ ዒስራዔኤሌ ዓሶይዳፓ ዓይጎ ዓሲያ ዔያቶ ዎዹዋጉዲ ላኣጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","ጋዓንቴ ዒማ ኬሎ ዔያታ ሃንፂሎ ሃኣኪ ዋኣሢያ ዱዒ ዒስራዔኤሌ ዴሮንታ ናንጊና ናንጋ ጎዳም ዒንጎ ባኮ ዒንጎ ቤዞንታይዳ ማዻያ ማዓንዳጉዲ ዒ ዓይሤኔ። ዬያሮ ዔያታ ሃኖ ሄላንዳኣና ናንጊና ናንጋ ጎዳ ካኣሽኪንታንዳጉዲ ዒ ዶኦሬ ቤዛ ዬያ ማዾ ማዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","ዒያሱ ዓይ ካታሞ ዖሊ ዓርቄስካፓ ዒያርኮና ካኣታሢናይዳ ማዼ ጎይፆ ጋፒሲ ባይዜያ ማዔሢ፥ ሃሣ ካኣታሢያ ዎዼሢ ዬሩሳላሜ ካኣቲ ዓዶኒፄዴቄ ዋይዜኔ፤ ዬያጉዲ ሃሣ ጌባዖኦኔ ዓሳ ዒስራዔኤሌ ዓሶና ዎላ ኮሹሞና ናንጋኒ ጫኣቂ፥ ጊኢጊ ዎላ ናንጋሢያ ዒ ዋይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","ዬያሮ ዬሩሳላሜ ዴሮንታ ካኣቲንታ ሚርጌና ዲቃቴኔ፤ ዓይጎሮ ጌዔቴ ጌባዖኦኔ ካኣታ ዎይሣ ካታሞይዳፓ ፔቴዞ ማዔያ፥ ሃሣ ዒኢካ ዓኣ ዓሳ ዖልዚና ዔርቴያ፤ ዓይ ካታሞይዳፓኣ ባሼ ካታማታሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","ዬያሮ ዬሩሳላሜ ካኣቲ ዓዶኒፄዴቄ ሆሃሜ ጌይንታ ኬብሮኦኔ ካኣቲም፥ ያርሙቴ ካኣቲ ፒራሜም፥ ላኪሼ ካኣቲ ያፒዓሜም፥ ዔግሎኔ ካኣቲ ዴቢሬም፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","«ጌባዖኦኔ ዓጮ ዓሳ ዒስራዔኤሌ ዓሶና ዎላ ኮሺ ናንጋኒ ጫኣቄሢሮ ጌባዖኦኔ ዖላኒ ሙኪ ታና ማኣዱዋቴ» ጌይ ኪኢታ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ዬሩሳላሜ፥ ኬብሮኦኔ፥ ያርሙቴ፥ ላኪሼንታ ዔግሎኔንታ ዎይሣያ ማዔ ዶንጎ ዓሞራ ካኣቶንሢ ዔያቶኮ ፖኦሊሶ ዎላ ፔቴ ማሂ ጌባዖኦኔ ማንጊ ዖልዚ ቡሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","ዒማና ጌባዖኦኔ ዓሳ ጌልጌላይዳ ዱንኪ ዴዒ ዓኣ፥ ዒያሱም፦ «ኑ ጎዳ፤ ጌሜራዻ ዓጮይዳ ናንጋ ዓሞራ ዓጮ ካኣታ ቢያ ኑና ዖላኒ ፔቴ ማዒ ሙኬሢሮ ኑና ኔኤኮ ዓይሎ ቶኦዛዺ ሃሺፖ! ዑኬ ሙኪ ማኣዲ ኑና ዓይሴ» ጌይ ኪኢታ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ዬያሮ ዒያሱና ዒዛኮ ዖላ ዓሳ ጉቤ፥ ጎኦባ ጎኦባ ዖላ ዓሳኣ ዓቱዋዖ ጌልጌላፓ ዴንዴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","ዒማና ናንጊና ናንጋ ጎዳ ዒያሱም፦ «ያኣቶ ዒጊጪፖ፤ ታኣኒ ኔ ዔያቶ ዖሊ ባሻንዳጉዲ ማኣዳንዳኔ፤ ዔያቶይዳፓ ፔቴታዖ ኔና ቃዛንዳይ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","ዬኖ ዋንቶ ዒያሱንታ ፖኦሊሶንታ ጌልጌላይዳፓ ጌባዖኦኔ ሄላኒ ሃንቴ ጎይሣ ዎርቃዖ ዓሞራ ዓሶይዳ ዔርቲባኣንቴ ዖልዚ ቡሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","ዒስራዔኤሌ ዓሶኮ ዖላ ዓሶ ዴንቃዖ ዓሞራ ዓሳ ዲቃታንዳጉዲ ናንጊና ናንጋ ጎዳ ዔያቶኮ ዒኖ ዋኣፂሴኔ፤ ዬያሮ ዒስራዔኤሌ ዓሳ ጌባዖኦኔይዳ ዔያቶ ቲቂ ኩርሴኔ፤ ዓቴ ዓሶ ቤቴሆሬና ጌይ ዹኮ ኬስካ ጎይፃ ካኣማ ካሮይዳ ዓኣ ቲፓሢዳ ዴንዲ ዓዜቃና ማቄዳ ሄላንዳ ጋሮይዳ ዳኪ ዳኪ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ዓሞራ ዓሳ ጎይፃ ዎላ ካኣማ ካሮኮ ዓኣ ቲፓሢዳ ዒስራዔኤሌ ዓሶይዳፓ ቶላኒ ጳሽካኣና ዴንዲ ዔያታ ዓዜቃ ሄላንዳኣና ዓኣ ጋሮይዳ ናንጊና ናንጋ ጎዳ ጫሪንጫፓ ዼኤፒ ሹቺጉዴ ሻቺ ኬይሴኔ፤ ዬያሮ ዒስራዔኤሌ ዓሳ ዎዼ ዓሶይዳፓ ሻጫ ዎዼ ዓሳ ሚርጌና ባሻያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","ዒስራዔኤሌ ዓሳ ዓሞራ ዓሶ ዖሊ ባሻንዳጉዲ ናንጊና ናንጋ ጎዳ ዓኣሢ ዒንጌ ኬሎና ዒያሱ ዒዛና ዎላ ዒስራዔኤሌ ዓሳ ዋይዛንቴ፦ «ጌባዖኦኔይዳ ዓባ ጌሉዋዖ ዴዖንጎ፤ ሃሣ ዓጊናኣ ዔሎኦኔ ዶኦጮይዳ ዔቆንጎ» ጌይ ጌስቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","ዬያሮ ዒስራዔኤሌ ዓሳ ፔኤኮ ሞርኮ ባሻንዳያ ሄላንዳኣና ዓባ ዔቄኔ፤ ዓጊናኣ ዓኣ ቤዛፓ ዓጊፂባኣሴ፤ ዬይ ያሻሬ ማፃኣፖይዳ ፃኣፒንቲ ዓኣኔ። ዓባ ሳዛፓ ዓጊፁዋዖ ጌሊያ ጌሉዋዖ ዬኖ ኬሎ ፔኤቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","ናንጊና ናንጋ ጎዳ ዓሲ ጌዔ ባኣዚ ዋይዜያ፥ ዬኖጉዴ ኬሊ ዬያኮ ቤርታ ማዔቴያ ጊንፃ ዓሲ ዛጊ ቤቂባኣሴ፤ ናንጊና ናንጋ ጎዳ ጎኔ ዒስራዔኤሌ ዓሶ ዛላ ዔቂ ዖልቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ዬካፓ ዒያሱና ዒዛኮ ፖኦሊሶና ዔያታ ቤርታ ዱንኪ ዴዔ ቤዞ፥ ጌልጌላ ማዒ ዴንዴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","ዶንጎ ዓሞራ ዓጮ ካኣቶንሢ ቶሊ ማቄዳ ዓጫ ዴኔ ዔቴይዳ ጌሊ ፑኒንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","ዬንሢ ዶንጎ ካኣቶንሢ ማቄዳይዳ ዴኖ ዔታ ዓኣሺንቲ ዓኣሢ ፖኦሊሶይዳፓ ፔቴ ዓሲ ዒያሱም ኬኤዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","ዬያሮ ዒያሱ፦ «ዼኤፒ ዼኤፒ ሹቺ ቡምባልሲ ዔቶ ካሮ ዎዺጋፓ ዒኢካ ካፓ ዓሲ ጌሡዋቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","ዒንሢ ጋዓንቴ ዒኢካ ዴዒፖቴ፤ ሞርኮ ዳውሲ ዳውሲ ጊንሢና ሙኪ ዔያቶ ዎዺፆ ሃሺፖቴ፤ ቶሊ ዔያታ ፔኤኮ ካታሞ ጌላንዳጉዲ ካራ ጌሢፖቴ! ናንጊና ናንጋ ጎዳ ማዔ ዒንሢኮ ፆኦዛሢ ዔያቶ ዒንሢ ኩጫ ዓኣሢ ዒንጊናኣኮኬ» ጌይ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ዻካ ዓሲ ቶሊ ዔያቶኮ ኬኤሎ ዲፆና ዲርቆና ካታሞ ጌሊ ዓቴቴያ ዒያሱንታ ዒስራዔኤሌ ዓሶንታ ዔያቶ ቲቂ ቲቂ ጋፒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ዬካፓ ዒያሱኮ ዖሎ ዓሳ ቢያ ኮሺና ማዒ ዒዚ ዱንኪ ዴዔ ቤዞ፥ ማቄዳ ሙኬኔ። ዬያሮ ዒስራዔኤሌ ዓሶ ፑርታ ማሂ ፔቴታዖ ጌስታ ዓሲ ባኣያ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ዬካፓ ዒያሱ፦ «ዴኖ ዔቶ ካሮ ቡሊ፥ ዬንሢ ዶንጎ ካኣቶንሢ ታኣም ዔኪ ዬዑዋቴ» ጌይ ዒዛኮ ፖኦሊሶ ዓይሤኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","ዬያሮ ዔያታ ዔቶ ካሮ ቡሊ ዬንሢ ዶንጎ ዬሩሳላሜንታ ኬብሮኦኔንታ ያርሙቴንታ ላኪሼንታ ዔግሎኔ ካኣታሢንታ ኬሲ ዔኪ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ዒያሱ ኮይላ ሙኬኔ፤ ዒማና ዒያሱ ዒስራዔኤሌ ዓሶ ቢያሢ ፔ ባንሢ ዔኤሊ፥ ካኣቶንሢያ ሳዓ ላይሣዖ ዒዛና ዎላ ዖሎሮ ኬስኬ ፖኦሊሶ ዓይሣዞንሢ ዬንሢ ካኣቶንሢኮ ባቃኖ ሳዓ ሄርቂ ዓርቃንዳጉዲ ዓይሣዛ ዔያታ ሄርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","ዒያሱ ፖኦሊሶ ዓይሣዞንሢም፦ «ፔቴታዖ ዒጊጪፖቴ፤ ዶዱዋቴ፥ ጫርቃያ ማዑዋቴ፤ ዓይጎሮ ጌዔቴ ናንጊና ናንጋ ጎዳ ዒንሢኮ ሞርኮይዳ ቢያ ሃይማ ጎይፆ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ዬካፓ ዒያሱ ዶንጎ ካኣቶንሢ ዎዺ፥ ሚሢዳ ሱፄኔ፤ ሌዛ ዔያቶኮ ዓባ ጌላንዳያ ሄላንዳኣና ዒኢካ ፔኤቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","ዓባ ጌላዛ ዬንሢ ካኣቶንሢኮ ሌዞ ሚፃፓ ኬይሲ ቤርታ ዔያታ ፑኒንቴ ዴኖ ዔቴሎይዳ ዓጋንዳጉዲ ዒያሱ ዓሶ ዓይሤኔ፤ ዒማና ዓሳ ዼኤፒ ዼኤፒ ሹቺ ቡምባሊ ዴኖ ዔቶ ካሮ ዎዼኔ፤ ዬይ ሹጫ ሃኖ ሄላንዳኣና ዒኢካ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","ዒዞ ኬሎና ዒያሱ ማቄዳ ዖሊ ዓርቂ፥ ካኣቲያ ጬንቾ ዓፓሮና ዎዼኔ፤ ካታሞይዳ ዓኣ ዓሶ ቢያ ዓይሱዋዖ ኩርሴኔ፤ ማቄዳ ካኣቲዳ ዒ ማዼሢ ቤርታ ዒዚ ዒያርኮ ካኣቲዳ ማዼ ጎይፆኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ዬካፓ ዒያሱና ዒዛኮ ፖኦሊሶና ማቄዳፓ ዴንዲ ሊቢና ካታሞ ዖሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","ናንጊና ናንጋ ጎዳ ሃሣ ዬኖ ካታሜሎንታ ካኣታሢንታ ዒስራዔኤሌ ዓሳ ባሻንዳጉዲ ማኣዴሢሮ ዒያሱ ካታሜሎና ዒዞይዳ ዓኣ ዓሶዋ ቢያ ባይዜኔ፤ ካኣታሢያ ዒዚ ቤርታ ዒያርኮ ካኣታሢ ማዼ ጎይፆ ማዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","ሃሣ ጊንሣ ዒያሱና ዒዛኮ ፖኦሊሶና ሊቢና ካታማፓ ዴንዲ ላኪሼ ካታሞ ማንጊ ዖሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","ዖሎ ዔያታ ዓርቄንቴ ላምዓሳ ኬሎና ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሳ ላኪሼ ካታሞ ዓሶ ባሻንዳጉዲ ማሄም ዔያታ ሊቢና ካታሞይዳ ዓኣ ዓሶ ባይዜ ጎይፆ ጬንቾ ዓፓሮና ዎዺ ኩርሴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ጌዜሬ ካኣቲ፥ ሆራሜ ላኪሼ ዓሶ ማኣዳኒ ዒማና ሙኬኔ፤ ጋዓንቴ ዒያሱ ዒዛንታ ዒዛኮ ፖኦሊሶንታ ባሼኔ፤ ዒዛ ዓሶይዳፓ ፔቴ ዓሲታዖ ቶሊ ዓቲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ዬካፓ ሃሣ ዒያሱና ዒዛኮ ፖኦሊሶና ላኪሼይዳፓ ዔግሎኔ ዴንዳዖ ካታሞ ማንጊ ዖሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","ዒማ ኬሎይዳ ካታሜሎ ዓርቃዖ ጬንቾ ዓፓሮና ዓሶ ዎዼኔ፤ ዔያታ ቤርታ ላኪሼይዳ ማዼ ጎይፆማ ዴንቄ ዓሶ ቢያ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ጊንሣ ሃሣ ዒያሱንታ ዒዛኮ ፖኦሊሶንታ ዔግሎኔፓ ኬስኪ ኬብሮኦኔ ካታሞ ዖሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","ዬኖ ካታሜሎዋ ዓርቂ ካኣቲንታ ዒዛኮ ኮይሎይዳ ኮይሎይዳ ዓኣ ካታማ ዴንቄ ዓሶ ቢያ ዒ ዎዼኔ፤ ዒያሱ ዔግሎኔይዳ ማዼ ጎይፆማ ካታሜሎ ባይዜኔ፤ ዒዞይዳ ፔቴታዖ ቶሊ ዓቴ ዓሲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ዬካፓ ዒያሱና ዒዛኮ ፖኦሊሶና ዴቢሬ ካታሞ ጊንሣ ማዒ ዖሌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","ዬኖ ካታሞኮ ካኣታሢንታ ካታሞዋ ቢያ ዓርቂ ዓሶ ጬንቾ ዓፓሮና ዎዺ ኩርሴኔ። ዔያታ ቤርታ ኬብሮኦኔና ሊቢና ካታሞና ዬያቶኮዋ ካኣቶናይዳ ማዼ ጎይፆማ ዴቢሬይዳ ፔቴ ዓሲታዎ ዓይሱዋዖ ዒኢካ ዓኣ ዓሶ ጉቤ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ዬያይዲ ዒያሱ ዓጬሎ ጉቤ ዓርቄኔ፤ ጌይፃ፦ ጌሜሮ ዓጫ፥ ዾኦሎ ዛሎ ዓጫ፥ ዓባ ጌላ ዛሎኮ ዳውሎና ጌሜሮ ጎኦባ ጎኦባ ዓኣ ዓጮንታ ካኣቶዋ ዓይሱዋዖ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌኮ ፆኦዛሢ ዓይሤ ጎይፆና ፔቴ ዓሲታዎ ዓይሱዋዖ ቢያ ዎዺ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","ዒያሱ ቃዴሴባርኔይዳፓ ዴንዲ ጋኣዛንታ ጌኤሴኤሜ ጌይንታ ዓጮ ጉቤሢንታ ዴንዲ ጌባዖኦኔ ሄላንዳኣና ዖሊ ባሺ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","ዒያሱ ዬያ ካኣቶንታ ዔያቶኮ ዓጮንታ ቢያ ፔቴና ዖሎሮ ኬስኬማና ሌሊ ባሻኒ ዳንዳዔሢ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢ ዒስራዔኤሌ ዓሶ ዛላ ዔቂ ዖልቴሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ዬካፓ ዒያሱና ፖኦሊሶና ዔያታ ዱንኪ ዴዔ ቤዞ፥ ጌልጌላ ማዒ ሙኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ሃፆሬ ዓጮ ካኣቲ ያቢኔ ዒስራዔኤሌ ዓሳ ባሻያ ማዔሢ ዋይዛዖ ማዶኔ ካኣቲ ዮባቤም፥ ሼምሮኔና ዓክሻፔ ዓጮ ካኣቶም፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ኬዶ ዛሎኮ ጌሜራዻ ዓጮና ጌሊላ ባዞኮ ዾኦሎ ዛላ ዓኣ ካኣቶም፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ዮርዳኖሴ ዶኦጮና ጌሜሮኮ ዴማ ዓባ ጌላ ዛሎይዳ ዓኣ ዶኦሬ ጌይንታ ዓጮ ካኣቶም፤ ዬያጉዲ ሃሣ ዮርዳኖሴኮ ዓባ ኬስካ ዛሎና ጌላ ዛሎናይዳ ዓኣ ካኣናኔ ዓሶ፥ ዓሞራ ዓሶ፥ ሂኢታ ዓሶ፥ ፔርዛ ዓሶ፥ ጌሜሮ ዓጮይዳ ዓኣ ዒያቡሳ ዓሶንታ፤ ሚፂጳ ዓጮይዳ ሄርሞኔ ዹኮኮ ዴማ ዓኣ ሂዋዌ ዓሶንታኮ ካኣቶም ኪኢታ ዳኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","ዬያታ ፔኤኮ ፖኦሊሶና ዎላ ሙኬሢሮ ፖኦሊሶኮ ሚርጉማ ባዚ ዓቺ ማኣሻላጉዲ ማዔኔ፤ ሃሣ ዬያይዳ ሚርጌ ፓሮንታ ሳርጌላ ዖይታንታ ዎላ ዔያታ ዔኪ ዬዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ዬያሮ ዬይ ካኣታ ቢያ ዖላ ዓሶ ዎላ ፔቴ ማሂ ዒስራዔኤሌ ዓሶ ዖላኒ ሜርሜ ጌይንታ፥ ዓልቃ ዋኣፃ ዓኣ ቤዛ ዱንኪ ዴዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ዒማና ናንጊና ናንጋ ጎዳ ዒያሱም፦ «ዔያቶ ዒጊጪፖ፤ ዚሮ ሃይማ ዎዴ ዒስራዔኤሌ ዓሶ ዛሎ ታኣኒ ዖልቲ ዔያቶ ቢያሢ ዎዺ ባይዛንዳኔ፤ ኔኤኒ ዔያቶ ፓራሢኮ ቃዎ ቲቂ፥ ሳርጌሎ ዖይቶዋ ታሚና ሚቻንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","ዬያሮ ዒያሱና ዒዛኮ ዖላ ዓሶ ጉቤሢና ዴንዲ ሜሮሜይዳ ዔርቲባኣ ዖልዚ ቡሌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ናንጊና ናንጋ ጎዳ ዒስራዔኤሌ ዓሶም ባሺሢ ዒንጌም፥ ዔያቶ ዖሊ ኬዶ ዛሎና ሚስሬፓትማይሜና ዼኤፖ ሲዶና ጌይንታዞ ሄላንዳኣና፤ ሃሣ ዓባ ኬስካ ዛሎይዳ ዓኣ ሚፂጳ ዶኦጮ ሄላንዳኣና ዔያቶ ዳውሴኔ፤ ዒማና ዔያቶይዳፓ ፔቴ ዓሲታዖ ዓይሱዋዖ ቢያ ዎዺ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","ናንጊና ናንጋ ጎዳ ዒያሱ ዓይሤ ጎይፆ ዔያቶ ዒ ማዼኔ፤ ዎዎዴይ ጌዔቴ ዔያቶ ፓራሢኮ ቃዎ ቲቂ፥ ሳርጌሎ ዖይቶዋ ታሚና ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ዬካፓ ዒያሱ ጊንሢም ማዒ ሃፆሬ ዓጮ ዖሊ ባሺ ዓርቂ ካኣታሢያ ጬንቾ ዓፓሮና ዎዼኔ፤ ሃፆሬ ዬኖ ዎዶና ዬያ ዒስራዔኤሌ ዓሶና ዎላ ዖልታ ካኣቶ ቢያፓ ባሼ ማዒ ሃንጎዋቶ ዎይሣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","ዒማና ዒስራዔኤሌ ዓሳ ሃፆሬ ካታማ ዓኣ ዓሶ ቢያ ዎዼሢሮ ፔቴታዖ ዓቴ ዓሲባኣሴ፤ ካታሜሎዋ ዔያታ ታሚና ሚቼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ዓይሤ ጎይፆ ዒያሱ ዬያ ካታሞንታ ካኣቶንታ ቢያ ዓርቂ ጬንቾ ዓፓሮና ዎዺ ባይዚ ኩርሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","ዬኖ፥ ዒያሱ ሚቼ፥ ሃፆሬ ካታማፓ ዓታዛ ዒስራዔኤሌ ዓሳ ጌሜራ ጌሜራ ማዢንቲ ዓኣ ሜሌ ካታሞ ሚቺባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","ዒስራዔኤሌ ዓሳ ዔኮንዶያ ኮይሳ ባኮና ቆልሞና ቢያ ዬያ ካታሞይዳፓ ፔ ቆሎ ማሂ ዔኬኔ፤ ጋዓንቴ ዓሲ ጋኣ ባኣዚ ዓይሱዋዖ ጬንቾ ዓፓሮና ጋፒሲ ዎዼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","ናንጊና ናንጋ ጎዳ ዬያኮ ቤርታ ዔያታ ዬያይዳንዳጉዲ ፔ ዓይላሢ፥ ሙሴ ዓይሤኔ፤ ሙሴያ ዒያሱ ዓይሤኔ፤ ዬያሮ ዒያሱ ዓይሢፆ ቢያ ማዺ ኩንሤኔ፤ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ዒያሱ ቢያ ባኮ ማዼኔ፤ ፔቴ ባኣዚታዎ ዓይሲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","ዒያሱ ሃካፓ ሊካ ኬኤዚንታ ዓጮ ጌይፃ፦ ጌሜሮ ዓጮ፥ ዾኦሎ ዛሎ ዓጮ፥ ጌኤሴኤሜ ዓጮ፥ ዳውላዻ ዓጮ፥ ዮርዳኖሴ ዎሮ ዶኦጮ፥ ዒስራዔኤሌ ዓጮኮ ዳውላዻ ዓጮና ዓሎ ዓጮ ቢያ ዓርቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ዒዚ ዔዶኦሜ ኮይላ ዓኣ ባኣላኣቄ ዹካፓ ዴንዲ ሄርሞኔ ዹኮ ዴማ ዓኣ ሊባኖኦሴ ዶኦጮ፤ ሃሣ ዴንዲ ባልጋኣዴ ዓጮ ሄላንዳኣና ዓኣ ካኣቶ ቢያ ዖሊ ዓርቂ ዎዼኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","ዬያቶ ካኣቶና ዎላ ዒ ሚርጌ ዎዴ ዖልቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","ዒስራዔኤሌ ዓሶና ዎላ ኮሹሞና ናንጋኒ ጫኣቂ ኮሺ ናንጌ፥ ሂዋዌ ዓሶ ፃጳ ናንጋ ጌባዖኦኔ ካታሞፓ ዓታዛ ሃንጎዋታ ቢያ ዖልዚና ዓርቆናያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","ዬያታ ቢያ ዒስራዔኤሌ ዓሶና ዎላ ዖልታንዳጉዲ ናንጊና ናንጋ ጎዳ ዔያቶኮ ዒኖ ዶዲሺ ዋይዞ ዒፃያ ማሄኔ። ዬያሮ ዔያታ ቢያሢ ባይቃንዳጉዲ ጌይንቴም ማኣሚቃይዶ ዔያታ ዎዺንቴኔ፤ ናንጊና ናንጋ ጎዳ ቤርታዺ ሙሴ ዓይሤሢ ያዺዶምኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ዒማና ዒያሱ ዴንዲ ዔጶና ዖዶሲ ማዔ፥ ዔናኣቄ ዜርፆ ዎዺ ጋፒሴኔ፤ ዔያታ ናንጋሢ፦ ጌሜሮ ዓጮ ኬብሮኦኔይዳ፥ ዴቢሬይዳ፥ ዓናቤይዳ፥ ዪሁዳንታ ዒስራዔኤሌንታኮ ጌሜሮ ዓጮናይዳኬ። ዒዚ ዬያ ዓሶንታ ዔያቶኮ ካታሞንታ ቢያ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","ዔናኣቄ ዜርፆይዳፓ ዒስራዔኤሌ ዓጮይዳ ዓቴ ዓሲ ባኣሴ፤ ጋዓንቴ ዻካ ዓሲ ሌሊ ጋኣዛና ጋኣቴና ዓሽዶዴናይዳ ዓቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆ ዒያሱ ዓጬሎ ቢያ ፔ ኩጮ ጋሮ ጌልዜኔ፤ ፔቴ ፔቴ ዒስራዔኤሌ ዓሶኮ ፃጶ ማኣሮም ዔያቶ ዓጪ ማሂ ዒንጊ ዒስራዔኤሌ ዓሶ ቢያሢም ጊሽኬኔ። ዬያሮ ዓጬላ ዖልዚዳፓ ሃውሼኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","ዓርኖኦኔ ዶኦጫፓ ዴንዲ ሄርሞኔ ዹኮ ሄላንዳኣና፤ ዓባ ኬስካ ዛሎና ዓራባ ሄላንዳኣና ቢያ፤ ሃሣ ዮርዳኖሴ ሱካ ዓባ ኬስካ ዛሎና ዓኣ ዓጮ ባሺ ሳዖ ዔያቶኮ ዒስራዔኤሌ ዓሳ ዔኬ ካኣታ ሃካፓ ሊካ ፓይዲንታዞንሢኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","ሃሴቦኦኔይዳ ዴዒ ዎይሣ ዓሞራ ዓጮ ካኣቲ ሲሆኔ፤ ዒዚ ዎይሣ ዓጫ፦ ጌሌዓዴ ዓጮኮ ሄካሢ ዔካዖ ዓርኖኦኔ ዶኦጮ ኮይላ ዓኣ ዓሮዔኤሬፓ ዓርቂ ዬያ ዶኦጮኮ ሳዛ ዓኣ ዓሞኦኔ ዓሶኮ ዛጶ ማዔ፥ ያኣቦቄ ዎሮ ሄላንዳኣናኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","ሃሣ ዒዚ ዎይሣሢ ዓባ ኬስካ ዛሎና ዮርዳኖሴ ዶኦጫፓ ዴንዲ ጌሊላ ባዞ ሄላንዳኣና፤ ቤትሺሞቴ ዛሎና ዴንዲ ሶኦጌ ባዚ ሄላንዳኣና፤ ጊንሣ ሃሣ ሶኦጌ ባዚኮ ዾኦሎ ዛሎና ፒሲጋ ዹኮ ዴሞ ሄላንዳኣናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","ዬያጉዲ ጊንሣ ሬፓ ዓሶ ፃጶይዳፓ ዓቴያ ዓስታሮቴና ዔድሬዒናይዳ ዴዒ ዎይሣ ባኣሳኔ ዓጮ ካኣቲ ዖኦጌ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","ዒዚ ፔ ዴማ ማሂ ዎይሣሢ፦ ሄርሞኔ ዹኮ ዓጫ፥ ሳላካ ዓጫ፥ ዴንዲ ጌሹሬና ማዕካ ጌይንታ ዓጮኮ ዛጶ ሄላንዳኣና ዓኣ ባኣሳኔ ዓጮ ቢያ ዔኪ ሃሴቦኦኔ ዓጮ ካኣቲ ሲሆኔ ዎይሣ ዓጮ ማዔያ ጌሌዓዴኮዋ ዛሎ ቃሲ ዔካያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","ዬያኮ ቤርታ ናንጊና ናንጋ ጎዳኮ ዓይላሢ ሙሴንታ ዒስራዔኤሌ ዴሮንታ ዬንሢ ላምዖ ካኣቶንሢ ዖሊ ባሼያኬ፤ ዬያሮ ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ዬያ ዓጮ ሮኦቤኤሌና ጋኣዴ ማኣሮ ዓሶናም፤ ሃሣ ሚናኣሴ ማኣሮ ዓሶኮዋ ዛሎም ዔያቶ ዓጪ ማሂ ጊሽኪ ጊሽኪ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ዒያሱና ዒስራዔኤሌ ዴሮና ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛሎይዳ ዓኣ ካኣቶ ቢያ ዖሊ ባሼኔ፤ ዬይ ዓጫ ሊባኖኦሴ ዶኦጮይዳ ዓኣ ባዓልጋኣዴይዳፓ ዓርቃዖ ዾኦሎ ዛሎና ዔዶኦሜ ኮይላ ዓኣ ሃላቄ ዹኮ ሄላኔ፤ ዒያሱ ዬያ ዓጮ ጊሽኪ ጊሽኪ ፔቴ ፔቴ ዒስራዔኤሌ ማኣሮ ማኣሮ ቶይዶም ፔ ዓጪ ማሂ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","ዬይ ዒንጊንቴ ዓጫ፦ ጌሜራዻ ዓጫ፥ ዓባ ኬስካ ዛሎና ዓኣ ጌሜሮ ዴማ ዓኣ ዓጫ፥ ዮርዳኖሴ ዶኦጮና ዬያ ዓጮኮ ጌሜሮ ዴማ ዓኣያ ዓባ ኬስካ ዛላ ዓኣ ቦኦላዻ ቤዞና ዾኦሎ ዛሎይዳ ዓኣ ዳውላዻ ዓጮ ቢያ ዓርቃያኬ፤ ዬይ ዓጫ፦ ቤርታ ሂኢታ ዓሳ፥ ዓሞራ ዓሳ፥ ካኣናኔ ዓሳ፥ ፔሪዛ ዓሳ፥ ሂዋዌ ዓሶንታ ዒያቡሳ ዓሶንታ ናንጋ ቤዞኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","ዒስራዔኤሌ ዴራ ካኣቶ ዖሊ ዖሊ ባሺ ዓርቄ ካታማ ሃካፓ ሊካ ፓይዲንታ ካታሞኬ፦ ዒያርኮ፥ ቤኤቴኤሌ ኮይላ ዓኣ ዓይ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ዬሩሳላሜ፥ ኬብሮኦኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ያርሙቴ፥ ላኪሼ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ዔግሎኔ፥ ጌዜሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ዴቢሬ፥ ጌዴሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ሆርማ፥ ዓራዴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ሊቢና፥ ዓዱላሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ማቄዳ፥ ቤኤቴኤሌ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ታፑሃ፥ ሄፔሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ዓፔቄ፥ ሻሮኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ማዶኔ፥ ሃፆሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ሺምሮንሜሮኔ፥ ዓክሻፔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ታዕናኬ፥ ሜጊዶ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ቄዴሼ፥ ቄርሜሎሴይዳ ዓኣ ዮቅኒዓሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ባዞ ኮይላ ዓኣ ዶኦሬ፥ ጌልጌላ ኮይላ ዓኣ ጎይሜንታ ");
INSERT INTO mdyeth_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ቲርፃ ካታሞንታ ማዓዛ ዬያታ ካኣታ ዎሊ ዑፃ ሃይሢታሚ ፔቴኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","ዒያሱ ሚርጌ ናንጊ ጋርቼሢሮ ናንጊና ናንጋ ጎዳ ዒዛም፦ «ኔኤኒ ማይ ሃሢ ጋርቼኔ፤ ሚርጌ ዖዶሲ ዎዴያ ኔ ናንጌኔ፤ ጋዓንቴ ሃጊ ዓርቂንቲ ዔውቲባኣ ሚርጌ ዓጪ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ዬይ ዓጫ ፒሊስፄኤሜና ጌሹሬ ዓሶ ዓጮ ጉቤ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ጌይፃ፦ ጊብፄ ዓጮኮ ዓባ ኬስካ ዛሎና ዓኣ ሺሆኔ ዎራፓ ዓርቃዖ ኬዶ ዛሎና ዔቅሮኔ ዛጶ ሄላንዳኣና ዓኣሢኬ። ዬይ ጉቤ ካኣናኔ ዓጮ ጌይንታኔ። ዬያታ ዶንጎ፥ ፒሊስፄኤሜ ዓጪ ካኣቲኬ፤ ዬያታ፦ ጋኣዛ፥ ዓሽዶዴ፥ ዓስቄሎና፥ ጋኣቴንታ ዔቅሮኔንታ ካኣቶኬ። ሜሌ ሃሣ ዓርቂንቲባኣ ዓጫ ዾኦሎ ዛሎና ዓኣ ዓቢቤ ዓጮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","ዬያጉዲ ዾኦሎ ዛሎና ካናዔኔ ዓሶ ዓጮ ቢያ፤ ጊንሣ ሃሣ ሲዶና ዓሶ ዓጮ ማዔ ማዓራ ካታማፓ ዓርቃዖ ዴንዲ ዓፔቄ ሄላንዳኣና ዓኣ ዓሞራ ዓሶ ዓጮ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","ጊንሣ ሃሣ ጌባላ ዓሶ ዓጮንታ ዓባ ኬስካ ዛሎና ዓርሞኒዔሜ ዹኮኮ ዾኦሎይዳ ዓኣ ባዓልጋኣዴይዳፓ ዓርቃዖ ዴንዲ ሃማቴ ዴንዳ ጎይፆ ሄላንዳኣና ዓኣ ሊባኖኦሴ ዓጫ ጉቤ ዓርቂንቲባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","ሊባኖኦሴይዳፓ ዴንዲ ሚስሬፖትማይሜ ሄላንዳኣና ዹኮ ዓጮይዳ ናንጋ ዓሶ፤ ጌይፃ፦ ሲዶና ዓጮ ዓሶ ቢያ ታኣኒ ታኣሮ ዒስራዔኤሌ ዓሶ ቤርታፓ ዳውሲ ባይዛንዳኔ፤ ኔኤኒ ጋዓንቴ ታ ኔና ዓይሣ ጎይፆና ዓጬሎ ዒስራዔኤሌ ዓሶም ዔያቶ ዓጪ ማሂ ጊሽኪ ጊሽኪ ዒንጌ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ዬያ ዓጮ ዔያቶ ዓጪ ማሂ ኔ ጊሽካንዳሢ ዒስራዔኤሌ ፃጶኮ ታዞጶና ሚናኣሴ ማኣሮ ዓሶኮ ዛሎናምኬ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","ሮኦቤኤሌና ጋኣዴ ፃጶናም፤ ዬያጉዲ ሚናኣሴ ዓሶኮዋ ዛሎም ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ቤርታዺ ዔያቶ ዓጪ ማሂ ዒንጌ ዓጮ ዔያታ ዔኬኔ። ዬይ ዔያታ ዔኬ ዓጫ፦ ዓባ ኬስካ ዛሎና ዮርዳኖሴ ዎሮኮ ሱካ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","ዔያቶኮ ዓጫ ዓርኖኦኔ ዶኦጮ ኮይላ ዓኣ ዓሮዔኤሬይዳፓ ዓርቃዖ ዴንዲ ዶኦጮ ሳዛ ዓኣ ሜዴባ ካታሞኮ ቦኦሎና ጌይ ዲቦኔ ዓጮ ቢያ ፔ ጋራ ማሃያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","ጊንሣ ሃሣ ሃሴቦኦኔይዳ ዴዒ ዓሞኦኔ ዓሶ ዓጮ ዛጶ ሄላንዳኣና ዎይሣ ዓሞራ ዓጮ ካኣቲ ሲሆኔ ካታሞ ቢያ ዓርቃያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","ዬይ፦ ጌሌዓዴ፥ ጌሹራንታ ማዕካኔንታ ዓጮ ዴማ ዎርቃ ዓጮና ዓርሞኒዔሜ ዹኮ ጉቤ፤ ዬያጉዲ ዴንዲ ሳላካ ሄላንዳኣና ዓኣ ባኣሳኣኔ ዓጮዋ ዓርቃያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","ሬፓ ዓሶይዳፓ ፒኢጫዺ ዓቴያ፥ ዓስታሮቴና ዔድራዒ ዓጮናይዳ ዴዒ ዎይሣ ባኣሳኣኔ ዓጮ ካኣቲ፥ ዖኦጌ ዓጮዋ ቢያ ጋራ ማሂ ዔካያኬ። ሙሴ ዬያቶ ቢያ ዖሊ ባሺ ዳውሲ ዳኪናኣኮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ያዺ ማዔቴያ ዒስራዔኤሌ ዓሳ ጌሹሬንታ ማዕካኔንታ ዴሮ ኬሲ ዳኪባኣሴ፤ ዬያሮ ዔያታ ሃኖ ሄላንዳኣና ዒስራዔኤሌ ዓሶ ባኣካ ናንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","ሙሴ ሌዊ ፃጶም ዔያቶሮ ማሂ ዒንጌ ዓጪ ባኣሴ፤ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢም ሚቺ ዒንጎ ባኮይዳፓ ዔያቶም ሄላ ዛላ ዔያቶኮ ዴኖ ማዒ ፓይዲንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ሙሴ ሮኦቤኤሌኮ ፔቴ ፔቴ ቶኦኮም ዓጬሎይዳፓ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ዬያቶኮ ዓጫ፦ ዓርኖኦኔ ዶኦጮ ኮይላ ዓኣ ዓሮዔኤሬና ዬያ ዶኦጮ ሳዛ ዓኣ ካታሜሎይዴና ጌይ ሜዴባኮ ኮይላ ዓኣ ቦኦሎ ዓጮ ጉቤ ዓርቃያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ዬያጉዲ ሃሴቦኦኔ ዓጮኮ ኮይሎይዳ ዓኣ ካታማ ዲቦኔ፥ ባሞትባዓኣሌ፥ ቤትቤዓልሜዖኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ያሃፄ፥ ቄዴሞቴ፥ ሜፓዓቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ቂርያታይሜ፥ ሲቤማ፥ ጌሜራዻ ዶኦጮይዳ ዓኣ ፄሬትሻሃሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ቤትፔዖሬ፥ ፒሲጋ ዹኮ ዴማ ዓኣ ቦኦሎ ዓጮንታ ቤትዬሺሞቴ ጌይንታ ዓጮ ቢያ ጋራ ማሂ ዔካያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ዬይያ፦ ዓላዻ ዓጮይዳ ዓኣ ካታሞንታ ሃሴቦኦኔይዳ ዴዒ ዎይሣ ዓሞራ ዓጮ ካኣቲ ሲሆኔ ዓጮ ቢያ ዓርቃያኬ። ሙሴ ካኣቲ ሲሆኔና ሚዲያሜ ዓጮኮ ሱኡጎንሢ ጌይፃ፦ ዔዊ፥ ሬቄሜ፥ ፁሬ፥ ሁሬኔና ሬባዔና ዖሊ ባሼኔ፤ ዬያታ ቢያ ዓጮ ዎይሣሢ ካኣቲ ሲሆኔም ጊኢሪሺ ጊኢሪሺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","ዒስራዔኤሌ ዓሳ ዎዼ ዓሶ ባኣካፓ ፔቴሢ ዓማቲ ጌይንታስኬያ ቢዖሬ ናኣዚ ባኣላኣሜኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","ዮርዳኖሴ ዎራ ዓባ ጌላ ዛሎና ሮኦቤኤሌ ፃጶኮ ዛጶኬ፤ ሮኦቤኤሌ ፃጶም ዔያቶ ዓጪ ማሂ ዒንጎና ካታሞንታ ጉርዶንታ ዬያቶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","ሙሴ ዓጬሎኮ ዛሎ ጋኣዴ ዓሶም ዔያቶ ዓጪ ማሂ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ዔያቶኮ ዓጫ ያዕዜሬና ጌሌዓዴናይዳ ዓኣ ካታሞ ቢያ፤ ዓሞኦኔ ዓጮኮ ሄካሢ ዔካዖ ራኣባኮ ዓባ ኬስካ ዛሎና ዓኣ ዓሮዔኤሬ ዴንዲ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","ዔያቶኮ ዓጮ ዳልጉማ ሃሴቦኦኔይዳፓ ዓርቃዖ ራሞቴና ሚፂጳና ጌዒ ቤፆኒሜ ሄላንዳኣና፤ ዬያጉዲ ማሂናይሜፓ ዓርቃዖ ዴንዲ ሎዴባሬ ዛጶ ሄላንዳኣናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ዮርዳኖሴ ዶኦጮ ባሼና ሃሴቦኦኔ ዓጮ ካኣቲ ሲሆኔ ዓሶይዳፓ ዓቴ ቤትሃራሜ፥ ቤትኒሚራ፥ ሱኮቴና ፃፖኔ ጌይንታ ዓጮ ቢያ ዓርቃያኬ፤ ዓባ ጌላ ዛሎ ዛጳ ዔያቶኮ ዮርዳኖሴ ዎሮ ማዓዛ ኬዶ ዛሎና ዴንዲ ጌሊላ ባዞ ሄላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","ጋኣዴ ፃጶም ዔያቶ ዓጪ ማሂ ዒንጎና ካታሞንታ ጉርዶንታ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","ሙሴ ዓጬሎፓ ሚናኣሴ ዓሶኮ ዛሎም ዔያቶ ዓጪ ማሂ ዒንጌኔ፤ ዔያቶም ዒዚ ዒንጌሢ፦ ፔቴ ፔቴ ቶኦኮም ጊሽኪ ጊሽኪኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ዔያቶኮ ዓጫ ማሂናይሜና ባኣሳኣኔ ዓጮ ቢያ ፔ ጋራ ማሃያኬ፤ ዬይያ፦ ባኣሳኣኔይዳ ዓኣ ላሂታሞ ያዒሬ ካታሞ ቢያ ዔኪ ባኣሳኣኔ ዓጮ ካኣቲ ዖኦጌ ዎይሣ ዓጮ ቢያ ዓርቃያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ዬያጉዲ ጌሌዓዴኮ ዛሎ ዔካዖ ባኣሳኣኔ ካኣቲ ዖኦጌ ካታሞ ማዔ፥ ዓታሮቴና ዔዲሬዒ ሄላኔ፤ ዬይ ቢያ ሚናኣሴ ማኣራፓ ሾይንቴ ማኪሬ ዜርፆም ዒንጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ሙሴ ዒያርኮኮ ዓባ ኬስካ ዛሎና፥ ዮርዳኖሴ ዎሮኮ ሱካ ሞዓኣቤ ቦኦሎይዳ ዓኣዖ ዔያቶም ዒንጌ ዓጫ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ዬይ ያዺ ማዓዛ ሙሴ ሌዊ ዓሶም ዒንጌ ዓጪ ባኣሴ፤ ዔያቶኮ ዴኖ ማዓሢ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢታሢሮ ዔያታ ዔያቶ ሄላ ዛሎ ባኮ ዔካንዳሢ ናንጊና ናንጋ ጎዳም ዒንጎ ባኮይዳፓታሢ ዔያቶም ኬኤዚንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ሃካፓ ሊካ ኬኤዚንታ ሃይሳ ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛላ ዓኣ ካኣናኔ ዓጮ ዒስራዔኤሌ ዓሶም ዎይቲ ጊሽኪ ዒንጎናቴያ ኬኤዛያኬ፤ ዬያ ጊሽኬሢ ቄኤሳሢ፥ ዓላዜሬንታ ኔዊ ናኣዚ ዒያሱንታ ዒስራዔኤሌ ዓሶኮ ፔቴ ፔቴ ፃጶኮ ሱኡጎንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ዮርዳኖሴኮ ዓባ ጌላ ዛላ ዓኣ ዓጮ ጉቤ ታዞጳና ዛላና ማዔ ፃጶም ዒፃ ዓጊ ዓጊ ዔያታ ጊሽኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","ሙሴ ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛላ ዓኣ ዓጬሎ ላምዖና ዛላና ማዓ ዜርፆም ዔያቶ ዴኔ ማሂ ዒንጊናኣኮኬ፤ ዒማና ሌዊ ዓሶም ጋዓንቴ ዬያቶ ባኣኮይዳ ዔያቶም ማዓ ዴኔ ዒዚ ዒንጊባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","ዮሴፔ ናኣታ ሚናኣሴና ዔፕራሜና ጌይንታያ ላምዖ ዜርሢና ዓኣያኬ፤ ሌዊ ዓሶም ዒዚ ዬኖ ዓጬሎይዳ ዔያታ ናንጋንዳ ካታሞማና ቆልማ ሄንቃ ቤዞማፓ ዓታዛ ዔያቶሮ ማዓ ዓጪ ዒንጊባኣሴ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤ ጎይፆና ዒስራዔኤሌ ዓሳ ዓጬሎ ጊሽቲ ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","ፔቴ ኬሊ ዪሁዳ ፃጳፓ ዻካ ዓሲ ዒያሱ ኮይላ ጌልጌላ ሙኬኔ፤ ዔያቶይዳፓ ፔቴሢ ቄኔዛ ዓሲ ማዔያ፥ ዪፑኔ ናኣዚ ካኣሌቤታዖ ዒያሱ ኮይላ፦ «ቤርታ ኑ ቃዴሴባርኔይዳ ዓኣንቴ ናንጊና ናንጋ ጎዳ ዒዛኮ ዓይላሢ፥ ሙሴም ኔ ዛላንታ ታ ዛሎዋ ኬኤዜ ባኣዚ ዓኣሢ ኔ ዔራኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","ናንጊና ናንጋ ጎዳኮ ዓይላሢ፥ ሙሴ ሃኖ ዓጬሎ ዛሎ ዔራኒ ሙሮም ቃዴሴባርኔይዳፓ ታና ዳኬያና ሌዓ ታኣኮ ዖይዲታሚኬ፤ ዒዛም ታ ጉሙርሳ ባኣዚ ዔኪ ሙኪ ኬኤዜኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ዒማና ታኣና ዎላ ዴንዴ ዓሳ ዴሮ ዒጊጪሲ ጎጲ ዋኣፂሴኔ፤ ታኣኒ ጋዓንቴ ናንጊና ናንጋ ጎዳ ማዔ ታ ፆኦዛሢም ጉሙርቂንታያ ማዒ ዓይሢንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","ዬያሮ ሙሴ፦ ‹ናንጊና ናንጋ ጎዳ ማዔ ታ ፆኦዛሢም ጉቤ ዒናፓ ጉሙርቂንቲ ኔኤኒ ዓይሢንቴሢሮ ኔ ዴንዲ ሄሌ ዓጬላ ኔኤና ኔ ናኣቶናም ናንጊና ዒንሢ ዴኔ ማዓንዳኔ› » ጌዒ ዬኖ ዓቦ ታኣም ጫኣቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","ሂንዳ ኮሺ ማሌ፤ ናንጊና ናንጋ ጎዳ ሙሴም ዬያ ጌይ ኬኤዜንቴ ዖይዲታሚ ዶንጎ ሌዔ ኩሚ ዓኣዼኔ፤ ዬይ ዎዳ ዒስራዔኤሌ ዓሳ ዓሲ ናንጉዋ ዳውሎይዳ ሴካ ሃንጋ ሜታዺ ሃንታ ዎዶናኬ፤ ናንጊና ናንጋ ጎዳ ዒማና ታኣም ጫኣቄ ጎይፆና ሃይሾ ሼምፔና ታና ካፒ ጌሢ ዓኣኔ፤ ሂንዳ ታና ዛጌ፤ ታኣኮ ሌዓ ሃሢ ሳሊታሚ ዶንጎኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","ያዺ ማዔቴያ ሙሴ ታና ዳካኣና ታ ዓኣ ጎይፆ ሃሢያ ታ ዶዲኬ፤ ዒማና ኬስኪ ዖሊ ማዓኒ ታኣኮ ዓኣ ዎልቃ ሃሢያ ዒማዺኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ናንጊና ናንጋ ጎዳ ዬያ ታኣም ጫኣቄ ጎይፆና ጌሜራዻ ዓጬሎ ሃሢ ታኣም ዒንጌ፤ ዔናኣቄ ዓሳ ዒኢካ ዓኣሢንታ ሃሣ ዔያቶኮ ካታማኣ ዼኤፒ ዼኤፒ ዙላ ኬኤሌና ዲርቂንቴያታሢ ዒዞና ኔያ ዋይዜኔ፤ ጋዓንቴ ናንጊና ናንጋ ጎዳ ጌዔ ጎይፆና ዒዚ ታና ማኣዴም ታኣኒ ዔያቶ ዬካፓ ዳውሲ ኬሳንዳኔ ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","ዒያሱ ዒማና ዪፑኔ ናኣዚ ካኣሌቤ ዓንጃዖ ኬብሮኦኔ ዒዛ ዴኔ ማሂ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","ዬያሮ ኬብሮኦኔ ሃኖ ሄላንዳኣና ቄኔዛ ዓሢ ዪፑኔ ናኣዚ ካኣሌቤ ዜርፆ ዓጪ ማዒ ዓኣኔ፤ ዬይ ያዺ ማዔሢ ዒዚ ናንጊና ናንጋ ጎዳ ማዔ ዒስራዔኤሌ ፆኦዛሢም ጉሙርቂንቲ ዓይሢንቴሢሮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ዬያኮ ቤርታ ኬብሮኦኔ ካታማ ዓርባዒ ጌይንቴያኬ፤ ዬይ ዓርባዒ ጌይንታሢ ዔናኣቄ ዓሶ ባኣካ ዼኤፒ ዓሲ ማዔያኬ። ዬካፓ ዓጬላ ዖልዚባኣያ ማዒ ኮሺ ናንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ዪሁዳ ፃጶም ዓጬሎይዳፓ ሃካፓ ሊካ ኬኤዚንቴ ቤዛ ዒንጊንቴኔ፤ ዔያቶ ዓጮኮ ዛጳ፦ ዔዶኦሜ ዓጮ ሄላዖ ዾኦሎ ዛሎና ዴንዲ ዓሲ ናንጉዋ ፂኢኔ ዳውሎኮ ጋፖ ሄላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ዬይ ዾኦሎ ዛሎ ዛጳ፦ ሶኦጎ ባዞኮ ዾኦሎ ዛላ ዓኣ ባዞ ሳዞ ሶርቶሚ ጌሌ ዓጮይዳፓ ዓርቃዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","ዓቅራቢሜ ጌይንታ ቶኦሎ ካሮ ጊዴና ጌይ ፂኢኔ ዛሎና ዴንዲ ቃዴሴባርኔኮ ዾኦሎ ዛሎ ሄላኔ፤ ሃሣ ሃፂሮኔ ጊዴና ዓዳሬ ባንሢ ኬስኪ ቃርቃ ባንሢ ጳንጪንታንቴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ዓፅሞኔ ዛሎና ጌዒ ጊብፄ ዓጮኮ ዋኣፃባኣ ዎራሢ ጌላዖ ጋፓ ሜድቴራኒያ ባዞና ማዓኔ፤ ዬያሮ ዾኦሎ ዛሎና ዪሁዳኮ ዛጳ ዬይናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","ዓባ ኬስካ ዛሎና ዔያቶኮ ዛጳ፦ ሶኦጌ ባዚ ማዓዛ ዬይያ ዮርዳኖሴ ዎራ ዴንዲ ጋፓ ካሮ ሄላንዳኣናኬ፤ ኬዶ ዛሎና ዓኣ ዛጳ ዮርዳኖሴ ዎራ ጋፓ ካራ ዓኣ፥ ባዞ ሳዞ ሶርቶሚ ጌሌ ካራፓ ዓርቃዖ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ሊካ ቤትሆጊላ ባንሢ ዴንዳኔ፤ ዬካፓ ኬዶ ዛሎና ቤትዓሬባና ጌዒ ሮኦቤኤሌ ናኣዚ ቦሃኔ ዻኣቤ ሹጫሢ ዓኣ ቤዞ ሄላያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ዬይ ዛጳ፦ ሜቶ ዶኦቺ ጌይንታዞይዳፓ ዴቢሬ ባንሢ ኬስካዖ ዎሮኮ ዾኦሎ ዛሎና ዓኣ ዓዱሚሜ ባንሢ ዴንዳ ጎይፆኮ ቤርቶ ዛሎና ጌዒ ኬዶ ዛሎና ጌልጌላ ባንሢ ጳንጪንታኔ፤ ሃሣ ዓይንሳሚሴ ጌይንታ ዓልቃ ዋኣፃ ዓኣ ቤዞና ጌዒ ዓይንሮጌሌ ኬስካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ዬካፓ ሄኖሜ ዶኦጮ ዓርቃዖ ዒያቡሳ ዓሶ ካታሞ ማዔ፥ ዬሩሳላሜይዳ ዓኣ ጌሜሮኮ ዾኦሎ ዛሎ ሄላኔ፤ ዬይ ዛጳ፦ ራፓይሜ ዶኦጮኮ ኬዶ ዛሎና ጌይ ሄኖሜ ዶኦጫፓ ዓባ ጌላ ዛሎና ዓኣ ጌሜሮ ቶኦኮ ኬስካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ሃሣ ጊንሣ ዬፓ ዓርቂ ዋኣፃ ዓልቃ ቤዞ ኔፕቶሃይዴና ጌዒ ዔፕሮኔ ዹኮ ኮይላ ዓኣ ካታሞ ሄሊ ዬይና ባዓላ ጌይንታ ቂሪያትይዓሪሜ ባንሢ ጳንጪንቲ ዴንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ዬይና ጌይ ሃሣ ባዓላኔኮ ዓባ ጌላ ዛሎና ጌዒ ሴይሬ ጌሜሮኮ ኬዶ ዛላ ዓኣ ጎኦቦና ጌዒ ቤትሳሚሳ ኬዳዖ ቲሚና ፒንቃኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","ዬይ ዛጳ፦ ዔቅሮኔኮ ኬዶ ዛላ ዓኣ ጌሜሮና ጌዒ ሼክሮኔ ባንሢ ጳንጪንቲ ዴንዳዖ ባዓላኔ ጌሜሮና፤ ዬያጉዲ ያብኒዔኤሌ ጊዴና ዓኣዻኔ፤ ጋፒንፃ ሜዲቴራኒያ ባዞ ማዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","ዓባ ጌላ ዛሎ ዛጳ ሜድቴራኒያ ባዞናኬ፤ ዬያሮ ፔ ቶኦኪና ቶኦኪና ፓቂንቴ ዪሁዳ ዓሶኮ ዓጮ ዛጳ ሺራሢ ዬይናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","ናንጊና ናንጋ ጎዳ ዒያሱ ዓይሤ ጎይፆና ዪሁዳ ዓጮይዳፓ ፓቂ ኬብሮኦኔ ጌይንታ ዓርባዒ ካታሞ ዪፑኔ ናኣዚ፥ ካኣሌቤም ዒንጌኔ። (ዓርባዒ ዔናኣቄኮ ዓዶኬ) ");
INSERT INTO mdyeth_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","ካኣሌቤ ሼሻዬንታ ዓሂማኔንታ ታልማዬ ጌይንታ ቶኦኮ ማዔ ዔናኣቄ ዜርፆ ዳኪ ባይዜኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","ዬካፓ ሃሣ ዒ ዴቢሬይዳ ናንጋ ዴሮ ዖላኒ ዴንዴኔ፤ ዬና ካታሜላ ቤርታ ቂርያትሴፔሬ ጌይንታኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ካኣሌቤ ዒማና «ቂርያትሴፔሬ ዖሊ ባሺ ዓርቄ ዓሢም ታ ናዎ ዓክሳኣኖ ታ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","ዬያሮ ካኣሌቤኮ ጌርሲ ማዔ ቄናዜ ናኣዚ፥ ዖቲኒዔኤሌ ዬኖ ካታሜሎ ዖሊ ዓርቄም ካኣሌቤ ፔኤኮ ናዎ ዓክሳኣኖ ዒዛም ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","ዔያቶኮ ዔፖ ኬሎና ዓክሳኣና ፔ ዓዶ ኮይላፓ ጎሺ ሺኢቃንዳጉዲ ዖቲኒዔኤሌ ዒዞ ዞሬኔ፤ ዒዛ ባቁሎይዳፓ ኬዳዛ ካኣሌቤ ዒዞ ኮይሎይዳ፦ «ዓይጎ ኔ ኮዓይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","ዒዛ ዓዶ ኮይላ፦ «ኔ ታኣም ዒንጌ ዓጫ ዋኣሢ ባኣያ ዳውላዻያታሢሮ ዻካ ዋኣሢ ዔቴ ታኣም ኔ ዒንጋንዳጉዲ ታ ኮዓኔ» ጋዓዛ፥ ካኣሌቤ ዒማና ኬዶ ዛሎና ዾኦሎ ዛሎናይዳ ዓኣ ዋኣሢ ዓልቃ ቤሲ ላምዖ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","ዪሁዳ ዓሳ ፔ ቶኦኮና ቶኦኮና ዔያቶ ዓጪ ማሂ ዔኬ ካታማ ሃካፓ ሊካ ፓይዲንታሢኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ዾኦሎ ዛሎና ዔዶኦሜ ዓጮ ኮይላ ዓኣ ዪሁዳ ፃጶ ካታማ ቃብፂዔኤሌ፥ ዔዴሬ፥ ያጉሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ቂና፥ ዲሞና፥ ዓድዓዳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ቃዴሴ፥ ሃፆሬ፥ ሂትናኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ዚፔ፥ ፄሌሜ፥ ቤዓሎቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ሃፆርሃዳታ፥ ቂርዮት ሄፂሮኔ (ሃፆሬ)፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","ዓማሜ፥ ሼማዒ፥ ሞላዳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ሃፃርጋዳ፥ ሄሽሞኔ፥ ቤትጳላፄ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ሃፃርሹዓሌ፥ ቤርሳቤ፥ ቢዝዮትያ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ቤዓላ፥ ዒዩሜ፥ ዔፄሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ዔልቶላዴ፥ ኬሲሌ፥ ሆርማ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ፂቅላጌ፥ ማድማና፥ ሳንሳና፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ሊባዎቴ፥ ሺልሂሜ፥ ዓይኔንታ ሪሞኔ ጌይንታያ ዎሊ ዑፃ ላማታሚ ታዞጳ ካታማ ማዓዛ ዔያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ጌሜሮ ጌሜሮ ዴሞይዳ ዓኣ ካታማ ዔሽታዖሌ፥ ፆርዓ፥ ዓሽና፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ዛኖሃ፥ ዔንጋኒሜ፥ ታፑሃ፥ ዔናሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ያርሙቴ፥ ዓዱላሜ፥ ሶኮሄ፥ ዓዜቃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ሻዕራይሜ፥ ዓዲታይሜ፥ ጌዴራና ጌዴሮታይሜ ጌይንታያ ዎሊ ዑፃ ታጶ ዖይዶ ካታማ ማዓዛ ዔያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ዬያጉዲ ሃሣ ፂናኔ፥ ሃዳሻ፥ ሚግዳልጋኣዴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ዲልዓኔ፥ ሚፂጳ፥ ዮቅፅዔሌ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ላኪሼ፥ ቦፅቃቴ፥ ዔግሎኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ካቦኔ፥ ላህማሴ፥ ኬትልሼ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ጌዴሮቴ፥ ቤትዳጎኔ፥ ናዕማና ማቄዳ ጌይንታያ ዎሊ ዑፃ ታጶ ላሆ ካታማ ማዓዛ ዔያቶኮ ኮይላ ዓኣ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","ዬያቶ ካታሞ ቢያሢና ዎላ ሊቢና፥ ዔቴሬ፥ ዓሻኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ዪፕታሄ፥ ዓሻና፥ ኔፂቤ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ቄዒላ፥ ዓክዚቤና ማሬሻ ጌይንታያ ዎሊ ዑፃ ታዞጳ ካታማ ማዓዛ ዔያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","ዒኢካ ኮይሎይዳ ዻካ ዻካ ካታማንታ ጉርዳንታ ዓኣያ ዔቅሮኔ ጌይንታ ካታማ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","ዓሽዶዴ ኮይሎይዳኣ ዔቅሮኔፓ ዴንዲ ሜዲቴራኒያ ባዞ ሄላንዳኣና ማዢንቴ ካታማና ዱማ ዱማ ጉርዳና ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","ዬያጉዲ ጊብፄ ዓጮ ዛጳ ዓኣ ዎሮና ጌይ ዴንዲ ሜዲቴራኒያ ባዞ ዓጮ ሄላንዳኣና ዓኣ ዻካ ዻካ ካታማና ጉርዳና ዓኣ ዓሽዶዴና ጋኣዛ ጌይንታ ካታማ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ሃሣ ጌሜሮ ዓጮይዳ፦ ሻሚሬ፥ ያቲሬ፥ ሶኮሄ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ዳና፥ ቂርያትሴፔሬ (ዴቢሬ)፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ዓናቤ፥ ዔሽቴሞዓ፥ ዓኒሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ጌኤሴኤሜ፥ ሆሎኔና ጊሎ ጌይንታያ ዎሊ ዑፃ ታጶ ፔቴ ካታማ ዓኣያ ማዓዛ ኮይላ ዔያቶኮ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","ዬያጉዲ ጊንሣ፦ ዓራቤ፥ ዱማ፥ ዔሽዓኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ያኒሜ፥ ቤትታፑሃ፥ ዓፔቃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ሁምፃ፥ ኬብሮኦኔና ፂዖሬ ጌይንታያ ዎሊ ዑፃ ታዞጳ ካታማ ዓኣያ ማዓዛ ዔያቶ ኮይላ ዓኣ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","ዬያቶይዳፓ ሜሌ ሃሣ ማዖኔ፥ ቄርሜሎሴ፥ ዚፔ፥ ዩፃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ዒይዝራዔኤሌ፥ ዮቅድዓሜ፥ ዛሆሃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ቃይኔ፥ ጊቢዓና ቲሚና ጌይንታያ ዎሊ ዑፃ ታጶ ካታማ ዓኣያ ማዓዛ ዔያቶኮ ኮይላ ዓኣ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","ዬያጉዲ ሃሣ ሃልሁሌ፥ ቤትፁሬ፥ ጌዶሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ማዕራቴ፥ ቤትዓኖቴና ዔልትቆኔ ጌይንታያ ዎሊ ዑፃ ላሆ ካታማ ማዓዛ ዔያቶ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","ጊንሣ ሃሣ፦ ቂርያባዓኣሌ ባጎ ሱንፃ ቂርያትይዓሪሜ ጌይንታዞና ራኣባ ጌይንታያ ላምዖ ካታማ ዓኣያ ማዓዛ ዔያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","ዬያቶ ካታሞ ቢያሢና ዎላ ዳውላዻ ዓጮይዳ ቤትዓራባ፥ ሚዲኔ፥ ሴካካ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ኒብሻኔ፥ ሶኦጌ ካታማና ዔንጌዴ ጌይንታያ ዎሊ ዑፃ ላሆ ካታማ ማዓዛ ዔያቶ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ጋዓንቴ ዒዞና ዪሁዳ ዴራ ዬሩሳላሜይዳ ናንጋ ዒያቡሳ ዓሶ ዳውሲ ዳካኒ ዳንዳዒባኣሴ፤ ዬያሮ ዒያቡሳ ዓሳ ሃኖ ሄላንዳኣና ዬሩሳላሜይዳ ዪሁዳ ዴሮና ዎላ ናንጋኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ዮሴፔ ዜርፆም ዒንጊንቴ ዓጫ፦ ዒያርኮኮ ኮይላ፥ ዓባ ኬስካ ዛሎይዳ ዓኣ ዮርዳኖሴ ዎራፓ ዓርቃዖ ዓሲ ናንጉዋ ዳውሎይዴና ጌዒ ጌሜሮ ዛሎና ዒያርኮፓ ቤኤቴኤሌ ኬስካኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","ጊንሣ ቤኤቴኤሌይዳፓ ዓርካ ዓሳ ናንጋ ዓፃሮትዓዳሬና ጌዒ ሎኦዛ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","ዬካፓ ዓባ ጌላ ዛሎና ዓኣ ያፒላፄ ዓሶ ዓጮይዴና ጌዒ ዾኦሎ ዛላ ዓኣ ቤትሆሮኔ ሄላኔ፤ ዬይና ሃሣ ጌዜሬና ጌዒ ጋፒንፃ ሜድቴራኒያ ባዞ ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","ዮሴፔ ዜርፆ ማዔ፥ ሚናኣሴና ዔፕሬኤሜና ፔ ዓጮ ሃካፓ ሊካ ኬኤዚንቴ ጎይፆ ጉዴያና ዔኬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ዔፕሬኤሜ ፃጳ ፔ ዓጪ ማሂ ፔ ቶኦኮና ቶኦኮና ዔኬ ዓጫ ያዺኬ፤ ዔያቶኮ ዛጳ ዓፃሮትዓዳሬይዳፓ ዓባ ኬስካ ዛሎና ኬዶ ዛላ ዓኣ ቤትሆርኔ ኬስካኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ዬይና ጌዒ ሜድቴራኒያ ባዞ ሄላኔ፤ ዔያቶኮ ኬዶ ዛሎ ዛጳ ሚክሜታቴናኬ። ዬካፓ ዓርቃዖ ታዓናቴሺሎ ባንሢ ጳንጪንቲ ዓባ ኬስካ ዛሎና ጋዓዖ ያኖሃ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","ዬካፓ ዓርቃዖ ዓፃሮቴና ናዓቴና ባንሢ ኬዲ፥ ዒያርኮ ሄሊ፥ ጋፒንፃ ዮርዳኖሴ ዎሮና ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","ዬይ ዛጳ ዓባ ጌላ ዛሎና ታፑሃይዳፓ ዓርቂ ዴንዲ ቃና ዎሮ ሄላዖ ጋፒንፃ ሜድቴራኒያ ባዞ ማዓኔ፤ ዔፕሬኤሜ ዓሶም ዔያቶ ዓጪ ማሂ ዒንጊንቴ ዓጫ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","ዬይ ዓጫ፦ ሚናኣሴ ዓጮ ጋሮይዳ ዓኣ ካታሞና ዔፕሬኤሜ ዓሶም ዒንጊንቴ ካታሞና ጉርዶና ፔ ጋራ ማሂ ዔካኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","ዬና ዔፕሬኤሜ ዓሳ ጋዓንቴ ጌዜሬይዳ ናንጋ ካኣናኔ ዓሶ ዒኢፓ ኬሲባኣሴ፤ ዬያሮ ካኣናኔ ዓሳ ሃኖ ሄላንዳኣና ዔፕሬኤሜ ዓሶ ባኣካ ናንጋኔ፤ ያዺ ማዔቴያ ዔያታ ዔፕሬኤሜ ዓሶም ዎልቄና ማዾ ባኣዚ ናሽኪባኣዖ ማዻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ዮሴፔኮ ቶይዶ ናዓሢ፥ ሚናኣሴ ዓሶም ዔያቶ ዴኔ ማሂ ዒንጎና ዓጫ ሃካፓ ሊካ ኬኤዚንታ ቤዞኬ፤ ሚናኣሴኮ ቶይዶ ናዓሢ፥ ጌሌዓዴኮ ዓዴ፥ ማኪሬ ዖልዚና ዔርቴ ዓሲታሢሮ ጌልዓዴና ባኣሳኣኔና ዒዛም ዒንጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛሎና ዓኣ ዓጫ ሃንጎ ሚናኣሴ ዓሶም ዒንጊንቴኔ፤ ዔያታኣ፦ ዓቢዔዜሬ፥ ሄሌቄ፥ ዓስሪዔኤሌ፥ ሼኬሜ፥ ሄፔሬና ሼሚዳዒ ጌይንታዞንሢኬ፤ ዮሴፔ ናኣዚ፥ ሚናኣሴ ዜርፆኮ ዓቲንቆንሢ ዬንሢ ማዓዛ ዔያታ ፔቴ ፔቴ ማኣሮኮ ሱኡጌኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","ፄሌጴሃዴ ያፔሬ ናይ፥ ያፔሬ ጌሌዓዴ ናይ፥ ጌሌዓዴ ማኪሬ ናይ፥ ማኪሬ ሚናኣሴ ናይኬ፤ ፄሌጴሃዴኮ ጋዓንቴ ዉዱሮ ናይፓ ዓታዛ ዓቲንቄ ናይ ባኣሴ፤ ዒዛኮ ዶንጎ ዉዱሮ ናይ ዓኣኔ፤ ዬያታ፦ ማሂላ፥ ኖዓ፥ ሆግላ፥ ሚልካና ቲርፃ ጌይንታያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","ዬንሢ ቄኤሳሢ ዓላዜሬንታ ኔዊ ናኣዚ ዒያሱንታ ዴሮኮዋ ሱኡጎ ኮይላ ሙካዖ፦ «ኑኡኮ ዓቲንቆ ዒጊኖጉዲ ኑኡማኣ ዓጪ ዒንጊንታንዳጉዲ ናንጊና ናንጋ ጎዳ ሙሴ ዓይሤኔ» ጌዔኔ፤ ዬያሮ ናንጊና ናንጋ ጎዳ ዓይሤ ጎይፆና ዔያቶም ዔያቶኮ ዓቲንቆ ዒጊኖ ባኣካ ዔያቶሮ ማዔ ዓጪ ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","ሚናኣሴም ዮርዳኖሴ ዎሮኮ ዓባ ኬስካ ዛላ ዓኣ ጌሌዓዴና ባኣሳኣኔይዳ ቃሲ ታጶ ቤሲ ዒንጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ዒዛኮ ዜርፆይዳ ዉዱሮ ናኣቶ ማዔዞንሢማኣ ዓቲንቆጉዲ ዓጪ ዒንጊንቴሢሮ ጌሌዓዴ ዓጫ ሃንጎ ሚናኣሴ ዜርፆም ዒንጊንቴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","ሚናኣሴኮ ዓጫ ዓሴኤሬይዳፓ ዓርቃዖ ሴኬሜፓ ዓባ ኬስካ ዛሎና ዓኣ ሚክሜታቴ ሄላኔ፤ ዒዛ ዓጮኮ ዛጳ፦ ዓጮኮ ዾኦሎ ዛሎና ጌዒ ዔንታፑዓሃ ዴሮዋ ፔ ጋራ ማሂ ዔካኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","ታፑሃ ኮይሎይዳ ዓኣ ዓጫ ሚናኣሴ ዓሶም ዒንጊንቴኔ፤ ዒዛኮ ዛጶይዳ ዓኣ ዻኮ ታፑሃ ካታሜላ ጋዓንቴ ዔፕሬኤሜ ዜርፆ ቤሲኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ዬካፓ ዓርቃዖ ሃሣ ሚናኣሴ ዓጮኮ ዛጳ፦ ቃና ዎሮ ሄላኔ፤ ዎሮኮ ዾኦሎ ዛሎና ዓኣ ካታማ ሚናኣሴ ዓጮ ጋራ ማዔቴያ ዔፕሬኤሜ ዓጪኬ፤ ሚናኣሴኮ ኬዶ ዛሎና ዛጳ፦ ዎሮኮ ዓጮማ ዓርቂ ጋፒንፃ ሜድቴራኒያ ባዞ ማዓኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","ዬያሮ ዔያቶ ላምዓሢኮ ዓባ ጌላ ዛሎና ዛጳ፦ ሜዲቴራኒያ ባዞ ማዔም ዔፕሬኤሜ ዾኦሎ ዛሎይዳ፤ ሚናኣሴ ፔ ዓሶና ዓሶና ኬዶ ዛላ ዴዓንዳጉዲ ዒንጊንቴኔ። ዒዛኮ ኬዶ ዛሎ ዛጳ፦ ዓሴኤሬና ማዓዛ ዓባ ኬስካ ዛላ ዓኣ ዛጳ ዪሳኮኦሬናኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ዪሳኮኦሬና ዓሴኤሬ ዓጮናኮ ጋራ ቤትሳኔንታ ኮይላ ዓኣ ጉርዶንታ፥ ዪብሊዓሜና ጉርዶንታ፥ ዶሬንታ ኮይሎ ጉርዶይዳ ናንጋ ዓሶንታ፥ ዓይንዶሬንታ ኮይሎ ጉርዳ ናንጋ ዓሶንታ፥ ታዕናኬንታ ኮይሎ ጉርዳ ናንጋ ዓሶንታ፥ ሜጊዶንታ ኮይሎ ጉርዳ ናንጋ ዓሶንታ፥ ጌሜራዻ ዓጮ ማዔ ሃይሦ ዓጪ ሚናኣሴሮ ማዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ጋዓንቴ ሚናኣሴ ዓሳ ዒኢካ ናንጋ ዴሮ ዳውሲ ካታሞ ዓርቃኒ ዳንዳዒባኣሴ፤ ዬያሮ ካኣናኔ ዓሳ ዒኢካ ናንጊሢ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","ዒስራዔኤሌ ዓሳ ዎልቃዺ ዶዲ ዶዲ ዴንዴቴያ ካኣናኔ ዓሶ ቢያ ዳውሲ ዳኪባኣሴ፤ ጋዓንቴ ዎልቄና ማዾ ባኣዚ ናሽኪባኣንቴ ዔያቶ ማዺሻኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ዮሴፔ ፃጳ ዒያሱ ኮይላ ሙኪ፦ «ኑኡኮ ፓይዳ ሚርጌኬ፤ ናንጊና ናንጋ ጎዳ ኑና ሚርጊሺ ዓንጄኔ፤ ሂዳዖ ዎይቲ ኔ ኑም ዒንጋ ዓጮማ ፔቴ ሌሊ ማዔይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","ዒያሱ ዔያቶም፦ «ዒንሢ ሚርጌም ዔፕሬኤሜኮ ጌሜራዻ ዓጬላ ዒንሢም ዻካያ ማዔቴ ፔሪዛ ዓሶና ሬፓ ዓሶና ናንጋ ዓጮ ዴንዲጋፓ ካዮ ጲሹዋቴ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ዔያታ ዒዛ ኮይላ፦ «ጌሜራዻ ዓጬላ ኑም ጊዳያቱዋሴ፤ ሃሣ ሊካ ኑ ኬዱዋጉዲ ዒዝራዔኤሌ ዶኦጫ ቤትሻኔና ኮይሎናይዳ ዓኣ ዻኮ ዻኮ ካታሞና ቦኦሎናይዳ ናንጋ ካኣናኔ ዓሶኮ ሳርጌላ ዖይታ ዓንጊ ሌሊ ማዔያ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","ዒያሱዋ ዔፕሬኤሜና ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛላ ዴዔ ሚናኣሴ ፃጶም፦ «ጎኔ ዒንሢ ሚርጌኬ፤ ዎልቄናኣ ዒንሢ ዶዲኬ፤ ፔቴ ቤሲ ሌሊ ዒንሢም ማዓኒ ኮይሱዋሴ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","ዬያሮ ካይዚ ማዔ ጌሜራዻ ዓጬላ ዒንሢሮ ማዓንዳኔ፤ ካይዚ ማዔቴያ ካራፓ ዴንዲ ጋፖ ሄላንዳኣና ጲሺ ዒንሢ ዓጪ ማሁዋቴ፤ ካኣናኔ ዓሶ ዛሎ ጋዓንቴ ዎዚ ዔያቶኮ ሳርጌሎ ዖይታ ዓንጊ ማዔቴያ፤ ዎልቄና ዔያታ ዶዲታቴያ ዳኪ ዒንሢ ዔያቶ ባይዛኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ዖሎና ባሺ ዓጬሎ ዔያታ ዓርቄስካፓ ዒስራዔኤሌ ዴራ ጉቤሢ ሴኤሎይዳ ቡኪንቲ፥ ናንጊና ናንጋ ጎዳ ዴሮና ካኣማ ማኣሮ ዾቄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ዒስራዔኤሌ ዴሮ ባኣካፓ ዒማና ፔ ዓጪ ዔኪባኣ ላንካይ ፃጲ ዓቲ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ዬያሮ ዒያሱ ዒስራዔኤሌ ዴሮ ኮይላ፦ «ዒንሢኮ ቤርታኣ ዓዶንሢኮ ፆኦዛሢ ማዔ ናንጊና ናንጋ ጎዳ ዒንሢም ዒንጌ ዓጬሎ ጌሊ ዻካሉዋዖ ዓይዲ ሄላንዳኣና ዒንሢ ዴዓይ? ");
INSERT INTO mdyeth_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","ሃሢ ፔቴ ፔቴ ፃጳፓ ሃይሦ ሃይሦ ዓሲ ታኣም ዶኦሩዋቴ፤ ፔቴ ፔቴ ፃጳ ዔካኒ ኮይሳ ዓጮ ዔራኒ ዓጬሎኮ ጎይፆ ዛጊ ፃኣፒ ዔኪ ዬዓንዳጉዲ ዓጬሎ ጋሮ ጉቤ ታ ዔያቶ ዳካንዳኔ፤ ዬካፓ ማዒ ዔያታ ታ ኮይላ ሙካንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","ዔያታ ዴንዲ ዛጋንዳ ዓጫ፦ ላንካዎ ፃጶም ጊሽኪንታንዳኔ፤ ዪሁዳ ዾኦሎ ዛሎይዳ፥ ዮሴፔ ኬዶ ዛሎይዳ ዔያቶም ዒንጊንቴ ዓጮ ዔኪ ናንጋንዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","ዓጬሎ ላንካይ ቤሲ ፓቂ ፃኣፒጋፓ ታኣም ዔኪ ዬዑዋቴ፤ ናንጊና ናንጋ ጎዳ ማዔ ኑ ፆኦዛሢኮ ማሊፆ ዔራኒ ዒፃ ታኣኒ ዒንሢም ዓጋንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","ያዺ ማዔቴያ ሌዊ ዓሶሮ ማዔ ባካ፦ ቄኤሴ ማዒ ናንጊና ናንጋ ጎዳም ማዺሢታሢሮ ሃንጎ ዓሶና ዎላ ዔያታ ዔካ ዓጪ ባኣሴ፤ ሃሣ ሮኦቤኤሌንታ ጋኣዴንታ ሚናኣሴኮዋ ዛሎ ዓሳ ዮርዳኖሴኮ ዓባ ኬስካ ዛሎይዳ ናንጊና ናንጋ ጎዳ ዓይላሢ፥ ሙሴ ዔያቶም ዒንጌ ዓጮ ቤርታ ዔኪ ዻካሌኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","ዓሶንሢ ዓጬሎኮ ጎይፆ ዛጋኒ ዴንዳንዳሢኮ ቤርታ ዒያሱ፦ «ዓጬሎኮ ጋሮ ቢያ ዴንዲ ዒዛ ዎዚጉዴ ቤስካ ዓኣቴያ ዛጊ ፃኣፒጋፓ ታ ኮይላ ማዒ ሙኩዋቴ፤ ታኣኒ ሃካ ሴኤሎይዳ ዒንሢ ዛሎ ናንጊና ናንጋ ጎዳ ዖኦጫኒ ዒፃ ዓጋንዳኔ» ጌይ ኬኤዚ ዳኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","ዬካፓ ዓሶንሢ ዓጬሎ ጉቤ ሺሪ፥ ካታሞዋ ቢያ ፃኣፒ ፃኣፒ ዓጬላ ዎዲ ላንካዎ ፃጶም ጊሽኪንታንዳቴያ ቢራናይዳ ፃኣፒ ዓርቄኔ፤ ዒያሱ ዓኣ ቤዞ ሴኤሎ ማዒ ዔያታ ሙኬኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","ዬያሮ ዒያሱ ናንጊና ናንጋ ጎዳኮ ማሊፆ ዔራኒ ዒፃ ዓጌኔ፤ ዬያይዲ ዒዚ ዒስራዔኤሌኮ ዓቴ ፃጶ ፔቴ ፔቴሢም ፓቂ ፓቂ ዒንጌኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","ቤርታዺ ቢኢኒያሜ ፃጶኮ ፔቴ ፔቴ ቶኦኮም ዒፃሢ ኬዴኔ፤ ዒፃሢ ኬዴ ጎይፆና ዔያቶ ዓጪ ማዔ ዓጫ ዪሁዳና ዮሴፔ ፃጶ ዓጮናኮ ባኣካ ማዓዛ ዬይ ሃካፓ ሊካ ኬኤዚንታ ቤዞኬ፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","ኬዶ ዛሎና ዔያቶኮ ዛጳ ዮርዳኖሴ ዎራፓ ዓርቃዖ ዒያርኮኮ ኬዶ ዛሎና ሌካ ኬስኪ ዓባ ጌላ ዛሎይዳ ዓኣ ጌሜሮ ዓጮይዴና ጌዒ ዴንዲ ዓሲ ናንጉዋ ዳውሎ ቤትዓዌኔ ሄላኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ዬይ ዛጳ፦ ዾኦሎ ዛሎና ቤርታ ሎኦዛ ጌይንታ ቤኤቴኤሌ ኬስካዖ ዾኦሌና ቤትሆሬ ዹኮና ጌይ ዓፃሮትዓዳሬ ኬዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ሃሣ ዬይ ዛጳ፦ ዬኖ ዹኮኮ ዓባ ጌላ ዛሎና ሊካ ጳንጪንቲ ዪሁዳ ፃጶ ዓጮ ማዔ፥ ቂርያትባዓኣሌ (ቂርያትይዓሪሜ) ባንሢ ዴንዳኔ፤ ዬይ ዓባ ኬስካ ዛሎና ዓኣ ዛጶኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ዾኦሎ ዛሎና ዛጳ፦ ዓባ ጌላ ዛላ ቂርያትይዓሪሜኮ ጋፒንፃፓ ዓርቃዖ ኔፕቶሃ ጌይንታያ ዋኣፃ ዓልቃ ቤዞ ባንሢ ዴንዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ዬካፓ ራፓይሜ ዶኦጮኮ ኬዶ ዛሎ ጋፒንፃ ዓኣ ሄኖሜ ዶኦጮኮ ሆቶና ጌዒ ዹኮኮ ዴሞ ኬዳኔ፤ ሃሣ ጊንሣ ዒያቡሳ ዓጮ ጎኦቦኮ ዾኦሎ ዛሎይዳ ዓኣ ሄኖሜ ዶኦጮ ባንፆና ጌዒ ዔንሮጌሌ ሄላኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ዬካፓ ኬዶ ዛሎና ጳንጪንቲ ዒንሺሚሼ ባንሢ ዴንዳኔ፤ ዬይና ጌዒ ጌሊሎቴ ዴንዳኔ፤ ጌሊሎቴ ዓዱሚሜ ቲፓሢኮ ሆታ ዓኣያኬ፤ ሃሣ ዬይና ጌዒ ሮኦቤኤሌ ናኣዚ ዻኣቤ ቦሄኔ ሹጮ ባንሢ ኬዳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ኬዶ ዛሎና ዮርዳኖሴ ዶኦጮኮ ሆታ ዓኣ ጎኦቦ ዛሎና ጌዒ ሊካ ኬዳኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ዬይ ዛጳ፦ ቤትሆጊላ ኮይሊና ጋዓዖ ሶኦጌ ባዚኮ ኬዶ ዛሎ፤ ዮርዳኖሴ ዎሮኮዋ ዾኦሎ ዛሎ ሄላኔ፤ ዬይ ዾኦሎ ዛሎ ዛጶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","ዓባ ኬስካ ዛሎ ዛጳ ዮርዳኖሴ ዎሮናኬ፤ ዬይ ዓካሪ ቢኢኒያሜ ፃጳ ፔ ዓጪ ማሂ ዔኬ ዓጮኮ ዛጶኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","ቢኢኒያሜ ፃጳ ፔ ቶኦኮና ቶኦኮና ዔኬ ካታማ ሃካፓ ሊካ ፓይዲንታሢኬ፦ ዒያርኮ፥ ቤትሆጊላ፥ ዔሜቄፂፄ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ቤትዓሬባ፥ ዬማራይሜ፥ ቤኤቴኤሌ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ዓዊሜ፥ ፓራ፥ ዖፒራ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ኬፓርዓሞናዬ፥ ዖፒናና ጌባዓ ጌይንታያ ዎሊ ዑፃ ታጶ ላምዖ ካታማ ማዓዛ ዬያቶ ኮይላ ዻካ ዻካ ካታማና ጉርዳና ዓኣኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","ዬያጉዲ ሃሣ ጌባዖኦኔ፥ ሪማ፥ ቤዔሮቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ሚፂጳ፥ ኬፕራ፥ ሞፃ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ሬቄሜ፥ ዪርጳዔኤሌ፥ ታራላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ፄላዔ፥ ዔሌፔ፥ ዒያቡሳ (ዬሩሳላሜ)፥ ጊቢዓንታ ቂርያትይዓሪሜ ጌይንታያ ዎሊ ዑፃ ታጶ ዖይዶ ካታማ ዔያታ ዔኬያ ማዓዛ ዬኖ ካታሞኮ ኮይላ ዻካ ዻካ ካታማና ጉርዳና ዓኣኔ። ቢኢኒያሜ ዓሳ ፔ ቶኦኮና ቶኦኮና ዔኬ ዓጫ ዬያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","ላምዓሶና ሲሞኦኔ ፃጶም ዓጫ ዒንጊንቴኔ፤ ዔያቶኮ ዓጫ፦ ዪሁዳ ፃጶም ዒንጊንቴ ዓጮ ሳዞ ጌሌያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ዬይ ካታማ፦ ቤርሳቤ፥ ሼባዒ፥ ሞላዳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ሃፃርሹዓሌ፥ ባላ፥ ዔፄሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ዔልቶላዴ፥ ቤቱሌ፥ ሆርማ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ፂቅላጌ፥ ቤትማርካቦቴ፥ ሃፃርሱሳ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ቤትሌባዖቴንታ ሻሩሄኔ ጌይንታያ ዎሊ ዑፃ ታጶ ሃይሦ ካታማና ዬያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","ዬያይዳ ሃሣ፦ ዓይኔ፥ ሪሞኔ፥ ዔቴሬና ዓሻና ጌይንታ ዖይዶ ካታማንታ ዔያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ዾኦሎ ዛሎና ዓኣ ባዕላትቤዔሬ (ራማ) ሄላንዳኣና ዬያ ካታሞ ኮይላ ዓኣ ዻኮ ዻኮ ካታማኣ ዔያቶሮኬ፤ ሲሞኦኔ ፃጳ ፔ ቶኦኮና ቶኦኮና ዬያ ዓጮ ዓርቄኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","ዪሁዳ ፃጶም ዒንጊንቴ ዓጫ ሚርጌ ዳልጊ ዓጪታሢሮ ዪሁዳ ሳዖይዳፓ ፓቂ ሲሞኦኔ ፃጶም ዒንጊንቴኔ፤ ዬያሮ ሲሞኦኔ ፃጳ ዪሁዳ ዓሶ ዴናፓ ቤሲ ዔካኒ ዳንዳዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","ሃይሣሶና ዛብሎኦኔ ፃጶም ዓጫ ዒንጊንቴኔ፤ ዔያታ ዔኬ ዓጫ ዴንዲ ሳሪዴ ሄላያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","ዔያቶኮ ዛጳ ዬካፓ ዓርቃዖ ዳባሼቴና ዮቅኔዓሜናኮ ዓባ ጌላ ዛላ ዓኣ ዎሮ ዓርቂ ዓባ ኬስካ ዛሎና ዴንዲ ማርዒላ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ሳሪዴኮ ሱኮና ጌይፃ፦ ዓባ ኬስካ ዛሎና ኪስሎቴታቦሬ ጊዴና ጌዒ ዳብራቴና ዴንዲ ያፒዓኔ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ዬይና ዓባ ኬስካ ዛሎና ሪሞኔ ባንሢ ዔኪ ዴንዳ ጎይፆና ኔዓ ባንሢ ጳንጪንቲ ዴንዳዖ ጋቴሬና ጌዒ ዒትቃፂኔ ሄላያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ኬዶ ዛሎና ጊንሣ፦ ሃናቶኔ ባንሢ ጳንጪንቲ ዴንዳዖ ጋፒንፃ ሂፕታህዔኤሌ ዶኦጮና ማዓኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","ዬይካ ዓኣ ካታማ፦ ቃፃቴ፥ ናህላሌ፥ ሺምሮኔ፥ ዪዳላንታ ቤኤቴሌሄሜ ጌይንታ ታጶ ላምዖ ካታማና ዬያቶኮ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","ዬይ፦ ዼኤፖ ዼኤፖ ካታሞንታ ዻኮንታ ዛብሎኦኔ ፃጶም ፔ ቶኦኮና ቶኦኮና ዔያቶ ዓጪ ማሂ ዒንጎና ዓጮኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","ዖይዳሶና ዪሳኮኦሬ ፃጶም ዓጫ ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ዔያቶኮ ዓጫ ሃካፓ ሊካ ፓይዲንታ ካታሞ ፔ ጋራ ዔካያኬ፦ ዒዝራዔኤሌ፥ ኬሱሎቴ፥ ሹኔሜ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ሃፓራይሜ፥ ሺዖኔ፥ ዓናሃራቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ራቢቴ፥ ቂሺዮኔ፥ ዓቤፅኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ሬሜቴ፥ ዔንጋኒሜ፥ ዔንሃዳኔና ቤትጳፅፄንታኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","ዔያቶኮ ዛጳ ዮርዳኖሴ ዎሮና ማዓዛ ዔያታ ታኣቦሬና ሻሃፁማና ቤትሼሜሼኔናኮ ዓሺኒ ማዒ ካኣማኔ፤ ዬይ ካታማ ቢያ ታጶ ላሆ ማዓዛ ዔያቶ ኮይላ ዻካ ዻካ ካታማ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","ዬያሮ ዬያታ ዼኤፖ ዼኤፖ ካታሞንታ ዻኮንታ ዪሳኮኦሬ ፃጶም ፔ ቶኦኮና ቶኦኮና ዒንጎና ዓጮ ጋራ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","ዶንጋሶና ዓሴኤሬ ፃጶም ዓጫ ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ዔያቶኮ ዓጫ ሃካፓ ሊካ ፓይዲንታ ካታሞ ፔ ጋራ ዔካያኬ፦ ሄልቃቴ፥ ሃሊ፥ ቤፄኔ፥ ዓክሻፔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ዓላሜሌኬ፥ ዓምዓዴንታ ሚሾዓሌንታኬ፤ ዓባ ጌላ ዛሎና ቄርሜሎሴና ሺሆርሊብናቴ ካታሞና ዓሺኒ ማዒ ካኣማኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ዬይና ዓባ ኬስካ ባንሢ ጳንጪንቲ ዛጳ ቤትዔሜቄና ጌዒ ኔዒዔኤሌ ዴንዳ ጎይፆና ዛብሎኦኔና ሂፕታህዔኤሌ ዶኦጮ ዛጶና ካኣሚ ካኣሚ ዴንዲ ቤትዳጊኔ ሄላኔ። ኬዶ ዛሎና ካቡሌ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","ዔብሮኔ፥ ሬሆቤ፥ ሃሞኔንታ ቃናይንታይዴና ጌዒ ዼኤፖ ሲዶና ጎዖዞ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ዬይ ዛጳ፦ ኬኤሎ ዲፆና ኮይላ ዲርቂንቴ ፂሮሴ ካታሞ ሄላዖ ራማ ባንሢ ጳንጪንቲ ዴንዳኔ፤ ዬካፓ ሃሣ ጋፒንፃ ሜድቴራኒያ ባዞ ማዓዛ ጊንሣ ሆሳ ባንሢ ጳንጪንቲ ዴንዳኔ፤ ዬያ ዓጮ ጋራ ዓኣ ካታማ፦ ማሃላቤ፥ ዓክዚቤ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ዑማ፥ ዓፒቄና ሬሆቤ ጌይንታያ ላማታሚ ላምዖ ካታማና ዬያቶ ኮይሎይዳ ዻካ ዻካ ካታማኣ ዓኣያኬ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","ዓካሪ ዬይ ዼኤፖ ዼኤፖ ካታሞንታ ዻኮንታ ዓሴኤሬ ፃጶም ፔ ቶኦኮና ቶኦኮና ዔያቶ ዓጪ ማሂ ዒንጎና ዓጮ ጋራ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","ላሃሶና ኒፕታኣሌኤሜ ፃጶም ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ዔያቶ ዓጮኮ ዛጳ፦ ሄሌፔይዳፓ ዓርቃዖ ዓዳሚንቄቤና ያሚኔ ባንፆና ጌዒ ሺራ ካራ ዮርዳኖሴ ዎሮ ማዓዛ ዴንዲ ላቁሜና ጌዒ ዳዕናኒሜ ሻኣቦ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ዬካፓ ዛጳ፦ ዓባ ኬስካ ዛሎና ዓዝኖትታቦሬ ባንሢ ጳንጪንቲ ዴንዳኔ፤ ዬይና ጌይ ሁቆቄ ሄሊ፥ ዾኦሎ ዛሎና ዛብሎኦኔ፤ ዓባ ጌላ ዛሎና ዓሴኤሬ፤ ዓባ ኬስካ ዛሎና ዮርዳኖሴ ሄላኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","ሃሣ ዔያቶኮ ኬኤሎ ዲፆና ዲርቂንቴ ካታማ፦ ፂዲሜ፥ ፄሬ፥ ሃማቴ፥ ራቃቴ፥ ኬናሬቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ዓዳማ፥ ራማ፥ ሃፆሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ቄዴሼ፥ ዔድሬዒ፥ ዔንሃፆሬ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ዪርዖኔ፥ ሚግዳልዔኤሌ፥ ሆሬሜ፥ ቤትዓናቴና ቤትሼሜሼ ጌይንታያ ታጶ ታዞጳ ካታማ ማዓዛ ዬያቶ ኮይላ ዻካ ዻካ ካታማኣ ዓኣኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","ዓካሪ ዬይ ዼኤፖ ዼኤፖ ካታሞንታ ዻኮንታ ኒፕታኣሌኤሜ ፃጶም ፔ ቶኦኮና ቶኦኮና ዔያቶ ዓጪ ማሂ ዒንጎና ዓጮ ጋራ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","ላንካሶና ዳኣኔ ፃጶም ዓጫ ዒንጊንቴኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ዔያቶኮ ዓጫ ሃካፓ ሊካ ፓይዲንታ ካታሞ ፔ ጋራ ዔካያኬ፦ ፆርዓ፥ ዔሽታዖሌ፥ ዒርሼሜሼ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ሻዓልቢሜ፥ ዓያሎኔ፥ ዪታላ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ዔሎኔ፥ ቲሚና፥ ዔቅሮኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ዔልቴቄኔ፥ ጊብቶኔ፥ ባዕላቴ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ዓይሁዴ፥ ቤኔቤራቄ፥ ጋትሪሞኔ፥ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ሜያርቆኔ፥ ራቆኔና ዬያጉዲ ሃሣ ዒዮጴ ኮይሎይዳ ዓኣ ዓጮንታኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","ዳኣኔ ዴራ ዬያ ዓጮ ዻካላኒ ዳንዳዒንቱዋኣሢ ዛጌ ዎዶና ዔያታ ላዪሼ ዴንዲ ዖሊ ካታሜሎ ዓርቄኔ፤ ዒኢካ ዓኣ ዓሶ ዎዺ ጋፒሲ ፔ ዓጪ ማሂ ዔካዖ ዱንኪ ዒዞይዳ ዴዔኔ፤ ዬኖ ካታሜሎኮ ሱንፆ ዔያታ ላኣሚ ዔያቶኮ ቤርታኣ ዓዳሢ ሱንፆና ዳኣኔ ጌይ ጌሤኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","ዬያሮ ዬይ ዼኤፖ ዼኤፖ ካታሞንታ ዻኮንታ ዳኣኔ ፃጶም ፔ ቶኦኮና ቶኦኮና ዔያቶ ዓጪ ማሂ ዒንጎና ዓጮኮ ጋራ ዓኣያኬ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","ዒስራዔኤሌ ዓሳ ዓጬሎ ጊሽቲ ጋፔስካፓ ኔዊ ናኣዚ፥ ዒያሱም ሳዔሎይዳፓ ፓቂ ዒዛ ዓጪ ማሂ ዔያታ ዒንጌኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ናንጊና ናንጋ ጎዳ ዒዛ ዓይሤ ጎይፆና ጌሜራ ሚርጌ ዓኣ ዔፕሬኤሜ ዓጮይዳ ዒዛም ዒንጋንዳጉዲ ዒ ዖኦጬ፥ ቲምናትሴራሄ ጌይንታ ካታሜሎ ዒዛም ዔያታ ዒንጌኔ፤ ዬኖ ካታሜሎ ጊኢጊሺ ማዢ ዒ ናንጋ ቤሲ ማሄኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","ቄኤሳሢ ዓላዜሬንታ ኔዊ ናኣዚ ዒያሱንታ ዒስራዔኤሌ ዓሶኮ ዱማ ዱማ ፃጶ ሱኡጎንታ ዓፒሎና ማዢንቴ ናንጊና ናንጋ ጎዳ ዴሮና ካኣማ ማኣሮ ካራ፥ ሴኤሎይዳ፥ ናንጊና ናንጋ ጎዳ ዓኣ ቤዞይዳ ዒስራዔኤሌ ዓሶም ዒፃ ዓጊ ዓጊ ዬያ ዓጮ ቢያ ዒንጌኔ። ዬያይዲ ሳዔሎ ዔያታ ጊሽኪ ጋፒሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ዬካፓ ናንጊና ናንጋ ጎዳ ዒያሱም፦ ");
INSERT INTO mdyeth_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","«ሙሴ ዒንሢም ኬኤዛንዳጉዲ ታ ዓይሤ ጎይፆና ዓሲ ዎዼ ዓሲ ዓኣሺንቲ ቶላ ካታማ ዔያታ ዱማሳንዳጉዲ ዒስራዔኤሌ ዓሶም ኬኤዜ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ዓይጎ ዓሲያ ማሊባኣዖ ዓሲ ዎዼቴ፥ ዬኖ ካታሜሎ ዴንዲ ኮሞ ዔካኒ ጋዓ ዓሶፓ ቶላያ ማዖንጎ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","ዬይ ዓሢ ዬንሢ ካታሞንሢፓ ፔቴማ ሩኡሪ ዴንዲ ካታሜሎ ጌሎ ካሮይዳ ዓኣ ዎጎ ዎጋ ዓሶም ማዺንቴ ባኮ ቢያ ኬኤዞንጎ፤ ዬካፓ ዔያታ ዒዛ ካታሞ ጌልዚ፥ ዒ ናንጋንዳ ቤሲ ዒንጋዛ ዒኢካ ዒ ዴዖንጎ። ");
INSERT INTO mdyeth_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ዒዛ ዎዺ ኮሜ ማሃኒ ኮዓ ዓሲ ዒዛ ጊንፆ ኮዒ ሙኬቴ፥ ካታሞ ዓሳ ዬያ ዓሢ ዒዛም ኬሲ ዒንጋንዳያ ኮይሱዋሴ፤ ዒ ዓሢ ዎዼሢ ኮሜ ዔካኒ ማሊቱዋንቴ ኩቺ ዻቢንቲና ማዔሢሮ ዒዛ ዔያታ ዓውሳንዳያ ኮይሳኔ፤ ");
INSERT INTO mdyeth_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ዬይ ዓሢ ዎጎ ዎጋ ዓሶ ቤርቶ ሺኢኪ ዎጊንታንዳያ ሄላንዳኣና፥ ሃሣ ዬኖ ዎዶና ቄኤሶ ቢያሢኮ ሱኡጌ ማዒ ማዻሢ ሃይቃንዳያ ሄላንዳኣና ዬኖ ካታሞይዳ ዒ ናንጋኒ ዳንዳዓኔ፤ ዬካፓ ቤርታ ዒ ዓኣሺንቲ ሙኬ ካታሞይዳ ዓኣ ፔ ማኣሪ ዴንዳኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ዬያሮ ዮርዳኖሴ ዎሮኮ ዓባ ጌላ ዛላ ጌሜራ ሚርጌ ዓኣ ኒፕታኣሌኤሜ ዓጮኮ ጌሊላይዳ ዓኣ፥ ቄዴሼ ጌይንታዞ፤ ሃሣ ጌሜራ ሚርጌ ዓኣ ዔፕሬኤሜ ዓጮይዳ ዓኣ ሴኬሜና ጌሜራ ሚርጌ ዓኣ ዓጮ ዪሁዳይዳ ኬብሮኦኔ (ዓርባዒ ካታሞ) ጌይንታዞ ዔያታ ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ዬያጉዲ ሃሣ ዮርዳኖሴ ሱካ፥ ዒያርኮኮ ዓባ ኬስካ ዛሎና ሮኦቤኤሌ ፃጶ ዓጮይዳ ዼጌ ቤሲ ማዔ ዓሲ ናንጉዋ ዳውሎይዳ ዓኣ ቤፄሬ፤ ጋኣዴ ፃጶ ዓጫ ጌሌዓዴይዳ ዓኣ ራሞቴና ሃሣ ሚናኣሴ ፃጶ ዓጫ፥ ባኣሳኔይዳ ዓኣ ጎላኔ ካታሞዋ ዶኦሪ ዔያታ ዱማሴኔ። ");
INSERT INTO mdyeth_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","ዬንሢ ካታማ ዒ