﻿USE sofia;
DROP TABLE IF EXISTS sofia.mdybse_vpl;
CREATE TABLE mdybse_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mdybse_vpl WRITE;
INSERT INTO mdybse_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ዓብራሃሜና ዳውቴናኮ ፃጳሢ ማዔ ዬሱስ ኪሪስቶሴኮ ሾይንቶ ዜርፃ ሂዚኬ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ዓብራሃሜ ዪሳኣቄ፤ ዪሳኣቄ ያይቆኦቤ፤ ያይቆኦቤ ዪሁዳና ጌርሲንሢና ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ዪሁዳ ቲዒማሮ ጎዖ ላኣሌሎይዳፓ ፓርሴና ዛራሄና ሾዔኔ፤ ፓርሴ ሄፂሮኔ፤ ሄፂሮኔያ ራማ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ራማ ዓምናኣዳኣቤ፤ ዓምናኣዳኣቤያ ናዖሴ፤ ናዖሴ ሴልሞኔ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሴልሞኔ ራባ ጎዖ ላኣሌሎይዳፓ ቦዔዜ ሾዔኔ፤ ቦዔዜያ ሩኡቴ ጎዖ ላኣሌሎይዳፓ ዒዮቤዴ፤ ዒዮቤዴያ ዒሴዬ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ዒሴዬ ካኣቲ ዳውቴ ሾዔኔ። ካኣቲ ዳውቴያ ዖሪዮ ማቾይዳፓ ሴሎሞኔ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሴሎሞኔ ሮቢዓሜ፤ ሮቢዓሜ ዓቢያ፤ ዓቢያ ዓሳኣፔ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ዓሳኣፔ ዒዮሳፒፄ፤ ዒዮሳፒፄ ዒዮራሜ፤ ዒዮራሜ ዖዚያ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ዖዚያ ዒዮዓታሜ፤ ዒዮዓታሜ ዓካኣዜ፤ ዓካኣዜ ሂዚቂያሴ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ሂዚቂያሴ ሚናኣሴ፤ ሚናኣሴ ዓሞኦኔ፤ ዓሞኦኔ ዒዮሲያሴ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ዒዮሲያሴ ዒስራዔኤሌ ዴራ'' ባብሎኔ ዓጮ'' ዲዒንቲ ዔውቴ ዎዶ''ና ዮዓኬና ጌርሲንሢና ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባብሎኔ ዓጮ'' ዲዒንቶኮ ጊንፃፓ ዮዓኬ ሳላቲያሌ፤ ሳላቲያሌ ዜሬባቡሌ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዜሬባቡሌ ዓብዲዮዴ፤ ዓብዲዮዴ ዔኤሊያቄሜ፤ ዔኤሊያቄሜ ዓዞሬ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ዓዞሬ ሳዶቄ፤ ሳዶቄ ዓኪሜ፤ ዓኪሜ ዔኤሊዩዴ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ዔኤሊዩዴ ዓላዜሬ፤ ዓላዜሬ ማኣታኣኔ፤ ማኣታኣኔ ያይቆኦቤ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያይቆኦቤ ዮሴፔ ሾዔኔ፤ ዬይ ዮሴፔ ሜሲሄ ጌይንቴ፥ ዬሱሴኮ ዒንዶ ማይራሞ ዔኬሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ዓካሪ ዓብራሃሜይዳፓ ዳውቴ ሄላ''ንዳኣና ታጶ ዖይዶ ሾይንቲ፤ ዳውቴይዳፓ ባብሎኔ ዓጮ'' ዲዒንቶ ሄላ''ንዳኣና ታጶ ዖይዶ ሾይንቲ፤ ባብሎኔ ዓጮ'' ዲዒንቶይዳፓ ሜሲሔ ሄላ''ንዳኣና ታጶ ዖይዶ ሾይንቲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ዬሱስ ኪሪስቶሴኮ ሾይንቶ ጎይፃ ያዺኬ፤ ዒዛኮ ዒንዳ፥ ማይራማ ዮሴፔና ዖኦጪንቲ ዔያታ ዎሊ ዔኩዋንቴ ዓያና ጌኤሺዳፓ ዒዛ ጎጲ ዔኪ ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ዒዞ ዖኦጫሢ ዮሴፔ ጋዓንቴ ኮሺ ዓሲ ማዔሢሮ ዓሲ ቤርቲዳ ዒዞ ዻውሲሳኒ ኮዒባኣሢሮ ዴሜና ሃሻ''ኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ዬኖ ማሊፆና ዒ ዓኣንቴ፥ ፆኦሲኮ ኪኢታንቾ ዓ'ውቲና ዒዛም ጴዻዖ፦ «ዳውቴ ናዓሦ፥ ዮሴፔ! ኔኤኒ ዖኦጫዛ፥ ማይራማ ጎጳዼሢ ዓያና ጌኤሺዳፓ ማዔሢሮ ማሊ ሂርጉዋዖ ዒዞ ዔዔኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ዒዛ ዓቲንቄ ናይ ሾዓንዳኔ፤ ዒዚ ዴሮ'' ጎሞይዳፓ ዻቂሻንዳሢሮ ሱንፆ ዒዛኮ ኔ ‹ዬሱሴ› ጌይ ጌሤ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ዬይ ቢያ ያዺ ማዔሢ ፆኦሲ፥ ፔ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፦ ");
INSERT INTO mdybse_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ሓይሾ ዓቲንቄ ዔሩዋ ኩሙሢ ዉዱሮ ናይ ጎጲ ዔኪ፥ ዓቲንቄ ናይ ሾዓንዳኔ፤ ሱንፃ ዒዛኮ ‹ዓማኑዔኤሌ› ጌይንቲ ጌሢንታንዳኔ» ጌዒ ኬኤዜሢ ኩማንዳጉዲኬ። (ዓማኑዔኤሌ ጌይፃ፦ ፆኦሲ ኑኡና ዎላ''ኬ ጌይሢኬ።) ");
INSERT INTO mdybse_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሴፔ ዒማ''ና ጊንዓስካፓ ጴጫዖ ፆኦዛሢኮ ኪኢታንቻሢ ዒዛ ዓይሤ ጎይፆ ዒ ዖኦጫ፥ ማይራሞ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ማዔቶዋ ናዖ ዒዛ ሾዓንዳያ ሄላ''ንዳኣና ዒዞና ዒ ላሂባኣሴ፤ ዬካፓ ዮሴፔ ሾይንቴ ናዓሢኮ ሱንፆ «ዬሱሴ» ጌዒ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ካኣቲ ሄሮዲሴ ዎዶ''ና ዬሱሴ ዪሁዳ ዓጫ''፥ ቤኤቴሌሄሜ ካታሞይዳ ሾይንቴኔ፤ ዬካፓ ዓባ'' ኬስካ ዛላ''ፓ ዦኦጋሢ ዛጊ ዔራ ዔሮ''ንሢ ዬሩሳላሜ ሙኪ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«ሾይንቴ፥ ዓይሁዴ ዓሶ ካኣቲ ዓንካዳይ? ዓባ'' ኬስካ ዛሎ''ይዳ ዦኦጋሢ ዴንቂ ዒዛም ኑ ዚጋኒ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ካኣቲ ሄሮዲሴ ዬያ ዋይዜ ዎዶ''ና ዲቃቴኔ፤ ዲቃቴሢ ዒዛ ሌሊቱዋንቴ ዬሩሳላሜ ዓጮ'' ዓሶ ቢያሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ዒዚያ ቄኤሶኮ ሱኡጎና ዓይሁዶ ዓሶኮ ዎጎ ዔርዛ ዓሶ ቢያ ዔኤሊ''፦ «ሜሲሔ ሾይንታንዳሢ ዎካዳይ?» ጌይ ዔያቶ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ዔያታ ማሃዖ፦ «ሜሲሔ ሾይንታንዳሢ ዪሁዳ ዓጮ''ይዳ ቤኤቴሌሄሜ ካታማ''ኬ፤ ዓይጎሮ ጌዔቶ ፆኦሲ ማሊፆ ኬኤዛሢ ዛሎ''ና፥ ");
INSERT INTO mdybse_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹ዪሁዳ ዓጮ''ይዳ ዓኣ ቤኤቴሌሄሜ ካታሜሌ! ዪሁዳ ዓጫ'' ዓኣ ዼኤፖ ዼኤፖ ካታማ''ፓ ኔ ዻካዓኬ። ዓይጎሮ ጌዔቶ ታኣኮ ዴሮ''፥ ዒስራዔኤሌ ሄንቃንዳያና ዎይሣንዳይ ኔጊዳፓ ኬስካንዳኔ› » ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ዬካፓ ሄሮዲሴ ዬንሢ ዔሮ'' ዓሶንሢ ዴሜና ዔኤሊ''ሲ ዦኦጋሢ ዔያቶም ጴዼ ዎዶ'' ኮሺ'' ዖኦጪ ዔሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ዬካፓ፦ «ሃሢ ዴንዲጋፓ ናዓሢ ዛጊ ኮዑዋቴ፤ ታኣኒያ ሃሣ ዴንዲ ዒዛም ዚጋንዳጉዲ፥ ዒንሢ ዒዛ ዴዴንቃዖ ታ ባንሢ ሙኪ ዒዚ ዎካ ዓኣቴያ ታኣም ኬኤዙዋቴ» ጌይ ቤኤቴሌሄሜ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ዔያታ ካኣቲ ጌዔሢ ዋይዜሢኮ ጊንፃ ኬስኪ ዓኣዻ ዎዶ''ና ዓባ'' ኬስካ ዛላ'' ዔያታ ዴንቄ ዦኦጋሢ ዔያቶኮ ቤርታ ቤርታ ማዒ ዔያቶ ዔኪ ዓኣዻሢ ላሚ ዔያታ ዴንቄኔ፤ ዬይ ዦኦጋሢያ ናዓሢ ዓኣ ቤዞ ሄላ''ዖ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ዔያታ ዦኦጋሢ ዛጌ ዎዶ''ና ሚርጌና ዎዛዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ናዓ ዓኣ ኬኤፆ ዔያታ ጌላዖ፥ ናዖና ዒንዶ ማይራሞና ዴንቄኔ፤ ዬካፓ ጉምዓቲ ዒዛም ዚጋዖ ሳኣፂኖ ዔያቶኮ ቡሊ'' ዎርቄ፥ ዑንጄ፥ ካርቤ ጎዖ ሳውዎ ባኮዋ ዒንጊ ዒኢሼኔ፤ ዬይ ባካ ሚርጌ ሚኢሼ ኬሳ''ያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ዬካፓ ፆኦሲ ዔያቶ ሄሮዲሴ ባንሢ፥ ሙኬ ጎይፆና ማዑዋጉዲ ዓ'ውቲና ላኣጌሢሮ፥ ዔያታ ሜሌ'' ጎይሢና ፔ ዓጮ'' ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ዔሮ'' ዓሶንሢ ዓኣዼስካፓ ጎዳኮ ኪኢታንቻ ዮሴፔም ዓውቲና ጴዻዖ፦ «ሃካፓ ዔቄ! ኔኤኒ ማዒ ሙካንዳ ዎዶ'' ታ ኔኤም ኬኤዛንዳያ ሄላ''ንዳኣና ናዓሢና ዒንዶና ዔኪ ጊብፄ ዓጮ'' ቤቲ ዒኢካ ዴዔ፤ ዓይጎሮ ጌዔቶ ካኣቲ ሄሮዲሴ ናዓሢ ዎዻኒ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ዬያሮ ዮሴፔ ዔቃዖ ናዓሢና ዒንዴሎና ዔኪ ዹሞና ጊብፄ ዓጮ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ዒኢካ ካኣቲ ሄሮዲሴ ሃይቃንዳያ ሄላ''ንዳኣና ናንጌኔ፤ ዬይ ያዺ ማዔሢ' ፆኦሲ ፔ ማሊፆ ኬኤዛሢ ዛሎ''ና፦ «ታኣኮ ናዓሢ ጊብፄይዳፓ ታ ዔኤሌ''ኔ» ጌዔ ቃኣላ'' ኩማ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ዔሮ'' ዓሶንሢ ዒዛ ጌሼሢ ሄሮዲሴ ዔሬ ዎዶ''ና ሚርጌና ዻጋዺ፥ ቤኤቴሌሄሜ ካታሞና ኮይሎ''ይዳ ዓኣ ጉርዶ ቢያ ዒዛኮ ፖኦሊሶ ዳኪ፥ ላምዖ ሌዔና ያፓ ዴማ'' ማዔ ዓቲንቆ ናኣቶ'' ቢያ ዎዺሼኔ፤ ዬያ ዒ ሂዴሢ ዦኦጋሢ ጴዼ ዎዶ'' ዔሮ''ንሢዳፓ ዖኦጪ ዋይዜ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ያዺ ማዒፆና ፆኦሲ ማሊፆ ኬኤዛ ዔርሚያሴ ዛሎ''ና፦ ");
INSERT INTO mdybse_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«ዬኤፒና ሚርጌ ዒላቲ ዑኡሲና ራማ ዓጮ''ይዳ ዋይዚንቴኔ፤ ራሄላኣ ፔ ናኣቶ'' ዛሎ''ሮ ዬኤኬኔ፤ ናኣታ'' ዒዞኮ ኩዴሢሮ ዶዲፆ ባሺንቴኔ» ጌዒ ኬኤዜሢ ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮዲሴ ሃይቄሢኮ ጊንፃ ጎዳኮ ኪኢታንቻሢ ዮሴፔም ዓ'ውቲና ጴዻዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ሃይካፓ ዔቄ! ናዓሢና ዒንዶና ዔኪ ጊንሣ ዒስራዔኤሌ ዓጮ'' ማዔ፤ ዓይጎሮ ጌዔቶ ናዓሢ ዎዻኒ ኮዓ ዓሳ ቢያ ሃይቄኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ዬካፓ ዮሴፔ ዔቂ ናዓሢና ዒንዶና ዔኪ ዒስራዔኤሌ ዓጮ'' ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ጋዓንቴ ዓርኬሌዎሴ ፔ ዓዶ ሄሮዲሴ ቤዛ፥ ዪሁዳ ዓጮ''ይዳ ካኣታዼሢ ዋይዜሢሮ ዬካ ዓኣዻኒ ዮሴፔ ዒጊጬኔ። ዬካፓ ዓ'ውቲ ዒዛም ኬኤዜሢሮ ጌሊላ ዓጮ'' ዓኣዺ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ናዝሬቴ ጌይንታ ካታሞይዳ ናንጌኔ፤ ዬይ ያዺ ማዔሢ' ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና «ናዝራ ዓሲ» ጌይንታንዳኔ ጌይንቴሢ ኩማ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ዬኖ ዎዶ''ና ማስካ ዮሓኒሴ ዪሁዳ ዓጫ'' ዓሲ ናንጉዋ ዳውሎ''ይዳ ዓሶም ኮዦ ሃይሶ ኬኤዚ ኬኤዚ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ዒዚ ኬኤዜሢ፦ «ፆኦሲ ካኣቱማ ዑኬኔ፤ ጎሞ ቡኡፁዋቴ» ሂዚ ጌዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","« ‹ጎዳኮ ጎይፆ ጊኢጊሹዋቴ፥ ሉኡጎ ጎይፆዋ ፒዚሱዋቴ› ጌዒ ጌዒ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዒላታ ዓሲ ዑኡሲ» ጌዒ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ኬኤዜሢ ዬያ ዮሓኒሴ ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ዮሓኒሴኮ ማኣዓሢ ጋኣሎ ጋፓኔፓ ኮሾ''ናያኬ፤ ኬርኖይዳ ዒ ቃልሾ ቱካ''ኔ፥ ሙዓ ሃሣ ዒዛኮ ዓቢሢና ዑቶ ዔኤሲ''ናኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ዬኖ ዎዶ''ና ዪሁዳ ዓጮ'' ዬሩሳላሜ ካታማ''ፓ፥ ዮርዳኖሴ ዎሮ ኮይላ'' ዓኣ ዓጫ''ፓ ዓሳ ቢያ ዮሓኒሴ ኮይላ'' ሙኪ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ጎሞ ፔኤኮ ቡኡፂ ቡኡፂ ዒዛ ኮይላ'' ዮርዳኖሴ ዎራ ዋኣፆ ማስታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ዮሓኒሴ ሚርጌ ፔርሴ ዓሲንታ ሶዶቄ ዓሲንታ ዋኣፆና ማስታኒ ዒዛ ኮራ ሙካሢ ዛጋዖ፦ «ሃይ ዒንሢ ሾኦዣ! ሙካ ፆኦሲኮ ጎሪ''ንቶይዳፓ ዒንሢ ቶላ''ንዳ ጎይፆ ዖኦኒ ዒንሢም ኬኤዜይ? ");
INSERT INTO mdybse_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ዓካሪ ሃሢ ዒንሢኮ ጎሞ ቡኡፂፆ ዔርዛ ማላታ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‹ኑኡኒ ዓብራሃሜ ናኣቶ''ኬ› ጌዒ ጌዒ ሄርሺንቲፖቴ፤ ፆኦሲ ሃያ ሹጮይዳፓ ዓብራሃሜ ናይ ማሃኒ ዳንዳዓኔ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ሃሢ ዓካሪ ሚፆ ፃጳፓ ቲቃኒ ሄርጋ ጊኢጊንቴኔ፤ ቃራ ዓኣፒ ዓኣፑዋ ሚሢ ቢያ ቲቂንቲ ታሚዳ ዓጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ሓሢ ታ ዒንሢ ጎሞ ቡኡፂፆ ዔርዛያ ማሂ ዋኣሢና ማስካኔ፤ ጋዓንቴ ታኣኮ ጊንፆ ሙካሢ ዓያና ጌኤሺና ሃሣ ታሚና ዒንሢ ማስካንዳኔ፤ ዒ ታጊዳፓ ሚርጌና ባሼታሢሮ ታ ዒዛኮ ቶኮ'' ዱርዞታዖ ኬዳኒ ኮይሳ ዓሲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ዒዛኮ ሃኣኮ ሶኦሪ ጌኤሾ ዓንዳ ዓኣሢሮ፥ ጌኤሼሢኮ ጊንፃ ዓኣፖንሢ ኮና ዋሂ ዲኢሮ ባይቁዋ ታሚዳ ሚቻንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ዬኖ ዎዶ''ና ዬሱሴ ዮሓኒሴ ኮራ ዋኣፆ ማስታኒ ጌሊላ ዓጮ''ይዳፓ ዮርዳኖሴ ዎሮ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ዮሓኒሴ ጋዓንቴ፦ «ዬይ ማዓዓኬ፤ ታ ኔ ኮራ ማስታኒ ኮይሳንቴ፥ ኔ ታ ባንሢ ሙካ?» ጌዒ ላኣጊሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ዬሱሴ፦ «ፆኦሲ ኮዓ ባኮ ቢያ ሂዲ ኑ ኩንሣንዳያ ኮይሳሢሮ ሃሢ ላኣጊፖ፤ ያዒ ማማዖንጎ» ጌዒ ማሃዛ፥ ዮሓኒሴ ዒ ጌዔሢ ዋይዛዖ ዬሱሴ ዋኣፆና ማስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ዬሱሴ ዋኣፃፓ ማስቲ ኬኬስካኣና ጫሪንጫ ቡሊ''ንቲ፥ ፆኦሲኮ ዓያና'' ዶኦሌ'' ማሊ ኬዲ'' ዒዛ ዑፃ ዴዓንቴ ዒ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ዬማና፦ «ታና ዎዛሳ፥ ታ ዒዛ ናሽካ ናዓሢ ታኣኮ ሃያኬ» ጋዓ ዑኡሲ ጫሪንጫፓ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ዬካፓ ጌኤዦ ዓያና'' ፃላሄ ዒዛ ዛጋኒ ጌሻንዳጉዲ ዓሲ ናንጉዋ ዳውሎ'' ዬሱሴ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ዒኢካ ዒ ዖይዲታሚ'' ሮኦሪና ዋንቴና ሙኡዚ'' ሙዑዋዖ ዴዔስካፓ ናይዺንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ዬማ''ና ጌሻ ፃላሄ ዬሱሴ ኮራ ሙካዖ፦ «ሂንዳ ኔ ፆኦሲ ናይ ማዔቴ፥ ሃንሢ ሹጮንሢ ካሣ ማሄ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ዬሱሴ ማሃዖ፦ « ‹ዓሲ ናንጋሢ ፆኦሲ ኬኤዛ ቃኣሎ''ና ማዓንዳፓዓቴም ካሣ ሙዒ ሌሊቱዋሴ› ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ዬካፓ ሃሣ ፃላሄ ዬሱሴ ፆኦሲም ዱማዼ ካታሞ፥ ዬሩሳላሜ ዔኪ ዓኣዻዖ ጌኤዦ ማኣሮኮ ሄላስካ ኬሲ'' ዔቂሲ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","« ‹ኔና ካፓንዳጉዲ ፆኦሲ ፔ ኪኢታንቾ ኔኤም ዓይሣንዳኔ፤ ቶካ'' ኔኤኮ ሹጮይዳ ዹይንቱዋጉዲ፥ ዔያታ ፔ ኩጮና ዓርቂ ኔና ቃዛንዳኔ› ጌይንቲ ፃኣፒንቴኔ፤ ዬያሮ ኔ ፆኦሲ ናይ ማዔቶ፥ ሂንዳ ሃይፓ ሊካ ጱሌ''» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ዬሱሴ ማሃዖ፦ « ‹ኔ ጎዳ፥ ፆኦዛሢም ፒራኒ ማሊፖ› ጌይንቲ ሃሣ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ዬካፓ ጊንሣ ፃላሄ ዬሱሴ ኮሺ'' ዖዶሲ ዹካ ኬሲ'' ዓጮ'' ካኣቶ'' ቢያሢና ዔያቶኮ ቦንቾዋ ዻዋዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«ጉምዓቲ ኔ ታኣም ዚጊ ካኣሽኬቴ፥ ሃያ ታ ኔኤም ቢያ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ዬሱሴ ማሃዖ፦ «ኔኤኒ ሓይ ፃላሄ፥ ሴካ ሺኢኬ! ‹ኔ ጎዳ ፆኦዛሢም ዚጌ፤ ሃሣ ዒዛ ሌሊ ካኣሽኬ› ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ዬካፓ ፃላሄ ዬሱሴ ሃሺ'' ዓኣዻዛ፥ ፆኦሲኮ ኪኢታንቻ ሙኪ ዒዛ ማኣዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ዮሓኒሴ ቱኡቴሢ ዬሱሴ ዋይዜ ዎዶ''ና ጌሊላ ዓጮ'' ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ዒኢካፓ ናዚሬቴ ካታሞ ሃሺ''፥ ቂፒርናሆሜ ካታሞ ዴንዴኔ። ቂፒርናሆሜ' ዛብሎኦኔና ኒፕታኣሌኤሜ ዓጮ''ና ኮይላ'' ዓኣ ባዚ'' ዓቺ ካታማኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ዬይ ያዺ ማዔሢ' ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፦ ");
INSERT INTO mdybse_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ባዞ'' ባንሢ ዓኣዻ ጎይፆና ዮርዳኖሴ ዎሮ ሱኮናይዳ ዓኣ ዛብሎኦኔንታ ኒፕታኣሌኤሜንታ ዓጫ'' ዓይሁዴ ማዒባኣ ጌሊላ ዓሶ ዓጫ''፤ ");
INSERT INTO mdybse_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ዬያጉዲ ዹሞይዳ ናንጋ ዴራ'' ዼኤፒ ፖዒ ዴንቃንዳኔ፤ ባይሲንታም ጊኢጌ ዓጫ'' ዓኣ ዓሶም ፖዒ ፖዓንዳኔ» ጌይንቴሢ ኩማ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ዬካፓ ዓርቃዖ ዬሱሴ፦ «ፆኦሲ ካኣቱማ ዑኬሢሮ ጎሞ ቡኡፁዋቴ» ጌዒ ጌዒ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ዬሱሴ ጌሊላ ባዞ'' ኮይሊ''ና ዓኣዻዖ፥ ላምዖ ዎሊኮ ጌርሲ ማዔስኬንሢ ዴንቄኔ፤ ዔያታ ጴፂሮሴ ጌይንታ ሲሞኦኔና ጌርሲ ዒንዲራሴና ማዓዛ ዔያታ ሞሎ ዓርቃያታሢሮ ሞላሢ ዓርቆ ሮኦጮጉዴ ሱዞ ባዞ''ይዳ ዓጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ዬሱሴ ዔያቶም፦ «ሃኒ ታ ጊንፆ ሙኩዋቴ፤ ታ ዒንሢ፥ ዓሲ ፒሪ ዓርቃያ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ዔያታ ቤዞማና ሞላሢ ዓርቆ ሱዞ ሃሺ''፥ ዒዛ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ዬማፓ ዻካ'' ዶጫዖ ሃሣ ላምዖ ዎሊኮ ጌርሲንሢ ማዓያ፥ ዜብዲዮሴ ናይ፥ ያይቆኦቤና ዮሓኒሴና ዴንቄኔ። ዔያታ ፔኤኮ ዓዶ ዜብዲዮሴና ዎላ'' ዋኣፆና ፒንቆ ጎንጎይዳ ሞላሢ ዓርቆ ሱዞ ኮሻ''ንቴ ዬሱሴ ዔያቶ ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ዔያታኣ ቤዞማና ዋኣፆና ፒንቆ ጎንጎንታ ዓዶንታ ሃሺ''፥ ዒዛ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ዬሱሴ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳ ዔርዚ ዔርዚ ሃሣ ፆኦሲ ካኣቱሞ ዛሎ'' ኮዦ ሃይሶዋ ኬኤዚ ኬኤዚ ጌሊላ ዓጮ'' ቢያይዳ ሃንታዖ፥ ዱማ ዱማ ዶርዖና ሃርጊንቴ ዓሶ ፖዒሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ዬያይዳፓ ዔቄያና ዒዛኮ ሱ'ንፃ ሶኦሪያ ዓጮ''ይዳ ቢያ ዋይዚንቴሢሮ ዓሳ ዱማ ዱማ ዶርዖና ሃርጊንቲ ሜታዻ ዓሶ ቢያ ዒዛ ኮይላ'' ዔኪ ሙኬኔ፤ ዬያ ሃርጌ ዓሶ ባኣኮ''ይዳ ፑርታ ዓያና ዓርቄ ዓሲ፥ ዴንሣ ዶርዓ ዓኣ ዓሲና ዎቦ ዓሲያኣ ዓኣኔ። ዬሱሴ ጋዓንቴ ቢያሢ ፓሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ጌሊላና ታጶ ካታሞንሢ ጌይንታ ቤዞንሢናይዳፓ ሃሣ ዬሩሳላሜና ዪሁዳ ዓጮ''ይዳፓ፥ ዮርዳኖሴ ዎሮ ሱኮይዳፓ ሙኬ ሚርጌ ዓሲ ዬሱሴ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ዬሱሴ ሚርጌ ዴሮ'' ዛጌ ዎዶ''ና ዹኮ'' ኬስኪ ዴዓዛ፥ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ኮይላ'' ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ዬካፓ ሂዚ ጌዒ ዔርዚሢ ዓርቄኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«ፆኦሲዳ ጉሙርቂፆ ጌሢ ፔና ሂርኪዳዞንሢ ፆኦሲ ካኣቱማ ዔያቶም ማዔሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ዖያዞንሢ ፆኦሲ ዔያቶም ዶዱሞ ዒንጋንዳሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ዒኖ'' ሼሌዔዞንሢ ዓጮ'' ዔያታ ዔካንዳሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ፂሉ''ሞ ካሣጉዲ ናይዺንታዞንሢና ዋኣሢጉዲ ዼኤቢንታዞንሢ ፂሉ''ሞ ዴንቂ ዔያታ ሃውሻንዳሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ዻቤ ዓሲም ዓቶም ጋዓዞንሢ ፆኦሲዳፓ ማኣሪሢ ዔያታ ዴንቃንዳሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ዒኖ'' ጌኤዦንሢ ፆኦሲ ዔያታ ዛጋንዳሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ፑርቴ ዓሲ ዎላ'' ቡኩሳዞንሢና ካንሣዞንሢ ፆኦሲ ናይ ዔያታ ጌይንታሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ፂሉ''ሞሮ ጌዒ ዒፂንቲ ዳኪንታዞንሢና ሜቶ ዔካዞንሢ ፆኦሲ ካኣቱማ ዔያቶም ማዔሢሮ ዎዛዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«ዓሳ ዒንሢ ታ ዛሎ''ሮ ጫሽኪ፥ ዒፂ ዳካያ ማዔቴ ሃሣ ፑርታ ሉኡዙሞ ዒንሢዳ ጌስቴቴ ዎዎዛዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ጫሪንጮይዳ ዒንሢ ዬያ ዛሎ''ሮ ዔካንዳ ባካ ዼኤፒታሢሮ ኮሺ'' ዎዛዹዋቴ፤ ሃያኮ ቤርታ ፆኦሲ ማሊፆ ኬኤዛዞንሢያ ዬያይዲ ዒፂ ዳኮናኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ዬካፓ ሃሣ ዬሱሴ፦ «ዒንሢ ዓጮ''ኮ ሶኦጌኬ፤ ጋዓንቴ ሶኦጌ ዓኣፆ ዒፄቴ ዎይቲ ጊንሣ ዓኣፃያ ማዓኒ ዳንዳዓይ? ሴካ ካራይዳ ኬኤሪንቲ ዓሲ ቶኪና ሄ'ርቃንዳኔ፤ ዓይጎማኣ ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ዒንሢ ሃሣ ዓጮ''ኮ ፖዔኬ፤ ዹኬይዳ ዓኣ ካታማ ዓኣሺንታኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ዓሲ ፖዒ ፖዒሳዖ ዔኤቢና ጉኡፒ ጌሣ? ጌሣሢ ፖዓ ጋሮይዳ ዓኣ ዓሶም ቢያ ፖዓንዳጉዲ ዼ'ጌ ቤሲዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ዬያጉዲ ዓሳ ዒንሢኮ ኮዦ ማዾ'' ዛጊ ዒንሢኮ ጫሪንጮ ዓዳሢ ጋላታንዳጉዲ ፖዓ ዒንሢኮ ዓሲ ቢያም ፖዖንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ሃሣ ዬሱሴ፦ «ሙሴ ዎጎና ፆኦሲ ማሊፆ ኬኤዛ ዓሶና ዔርዛ ባኮ ላኣማ''ኒ ታ ዒንሢም ሙኬያ ማሎፓ፤ ታ ሙኬሢ' ጌይንቴ ጎይፆ ኩኩንሣኒ ሙካንዳኣፓዓቴም ላኣማ''ኒ ሙኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ጎኔ ታ ዒንሢም ጋዓኔ፡ ጫሪንጮና ሳዖና ላኣሚ''ንታንዳያ ሄላ''ንዳኣና ሙሴ ዎጎይዳፓ ፔቴ''፥ ዻካ'' ባኣዚ''ታዖ ላኣሚ''ንታዓኬ፤ ሙሴ ዎጎይዳ ፃኣፒንቴ ባካ ቢያ ኩማ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ዬያሮ ዬንሢ ዓይሢፆንሢዳፓ ዻኮ''ማታዖ ኩንሡዋዖ ሃሼ'' ዓሢ፥ ሃንጎ ዓሶዋ ዻቢሻያ ማዒ ዔርዜቶ ፆኦሲ ካኣቱሞይዳ ቦሂንቴ ዓሲ ማዓንዳኔ፤ ጋዓንቴ ዓይሢፆንሢ ማዺ ኩንሣሢና ሃንጎ ዓቴ'' ዓሶዋ ኩንሣንዳጉዲ ዔርዛሢ ፆኦሲ ካኣቱሞይዳ ቦንቺንቴያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","«ዒንሢኮ ፂሉ''ማ ፔርሴ ዓሶና ሙሴ ዎጎ ዔርዛዞንሢ ፂሉ''ማፓ ባሺባኣቴ ፆኦሲ ካኣቱሞይዳ ማሊ ዒንሢ ጌላኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«ቤርታ ዓሶም ጌይንቴሢ ዒንሢ ዋይዜኔ፤ ዬይያ ‹ዎዺፖቴ፥ ዓሲ ዎዻሢ ፑርታና ዎጊንታንዳኔ› ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ታ ዒንሢም ሂዚ ጋዓኔ፦ ዓሲዳ ጎሪ''ንታሢ ቢያ ፑርታና ዎጊንታንዳኔ፤ ሃሣ ዓይጎ ዓሲታቶዋ ‹ኔኤኒ ፓሡዋኣሢ ሃይ› ጌዒ ጫሽኬቶ ዎጋ ዓሶ ቤርታ ፑርታና ዎጊንታንዳኔ፤ ሃሣ ‹ኔ ዒና ባይቄሢ ሃይ› ጌዒ ጫሽካሢ ቢያ ባይቁዋ ታሞ ዎጎም ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ዬያሮ ፆኦሲም ኔ ዒንጋ ባኮ ዒንጎ ቤዞይዳ ዒንጋ ዎዶ''ና ኔ ዒሻሢም ኔ ዻቤ ባኣዚ''ና ኔ ዒሻሢ ዖዬ ባኣዚ'' ኔኤም ጶቄቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ኔ ዒንጋ ባኮ፥ ዒንጎ ቤዞ ኮይላ'' ጌሢጋፓ ዴንዲ ዬያ ዓሢና ዎላ'' ቡኬ፤ ዬካፓ ሙኪ ኔ ዒንጋ ባኮ ዒንጌ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«ኔ ሞርካሢ ኔና ዎጌና ዓይሢሴም፥ ኔ ዒዛና ዎላ'' ዎጎ ዎጎ ቤዞ ዓኣዺፆይዳ ዓኣቴ፥ ዑኬና ኔ ሞርካሢና ዎላ'' ጊኢጌ። ያዺ ማዒባኣታቶ ኔ ሞርካሢ ኔና ዎጎ ዎጋሢም ዓኣሢ ዒንጋንዳኔ፤ ዎጋ ዓሢያ ሃሣ ፖኦሊሳሢም ዒንጋዛ ቱኡዞ ማኣራ ኔ ቱኡታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ጎኔ ታ ኔኤም ጋዓኔ፤ ጪጎንጎ ጎዖና ባኮ ጋፒሲ ኔ ጪጉዋዖ ዬካፓ ኬስካዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ዬሱሴ ሃሣ፦ « ‹ዓኒ ሃሣ ማቾ ማዒባኣ ዓሲና ላሂፖ› ጌይንቴሢ ዒንሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ታኣኒ ዒንሢም ጋዓንቴ ‹ላኣሊ ዛጊ ላሃኒ ማሌ ዓሲ ቢያ፥ ዬማና ፔ ዒኖና ዒዞና ላሄያ ማዓኔ› ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ዬያሮ ኔኤኮ ሚዛቆ ዓኣፓ ኔና ዻቢሻያ ማዔቴ ኔጊዳፓ ኬሲ'' ኬኤሬ፤ ጉቤ ዑፃ ኔኤኮ ባይቁዋ ታሞይዳ ኬኤሪንታስካፓ ዑፆኮ ኔኤኮ ፔቴ'' ቤሲ ፓጬቶ ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ሚዛቆ ኩጫ ኔና ዻቢሻያ ማዔቴ ኔጊዳፓ ቲቂ ኬኤሬ፤ ጉቤ ዑፃ ኔኤኮ ባይቁዋ ታሞይዳ ኬኤሪንታሢዳፓ ዑፆኮ ኔኤኮ ፔቴ'' ቤሲ ፓጬቴ ኮሺኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ዬሱሴ ሃሣ፦ «ዬያጉዲ ‹ፔኤኮ ማቾ ዓንጃሢ ቢያ ዒዞ ዓይጎሮ ዓንጄቶዋ ዔርዛ ባኣዚ'' ፃኣፒ ዒንጎንጎ› ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ታ ጋዓንቴ ዒንሢም ሂዚ ጋዓኔ፦ ሜሌ'' ዓሲና ዒኢቲሢ ዛላና ማዒባኣንቴ ፔ ማቾ ዓንጃሢ ቢያ ዒ'ዛ ዞኦስካ ኮኦማንዳጉዲ ማሃኔ፤ ዬኖ ዓንጂንቴዞ ዔካሢያ ዒዞና ዞኦስካ ኮኦማያ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ዬካፓ ሓሣ ዬሱሴ፦ «ሓያኮ ቤርታ ሚናኣ ዓሶም ‹ኔኤኒ ፆኦሲም ጫኣቄ ባኣዚ'' ኩኩንሤ፤ ኔ ጫኣቄ ባኮ ሃሺ''ፖ› ጌይንቴሢ ዒንሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ታኣኒ ጋዓንቴ ዒንሢም ሂዚ ጋዓኔ፦ ፔቴ''ታዖ ጫኣቂፖቴ፤ ጫሪንቺ ዔኤሊ'' ጫኣቂፖቴ፥ ዓይጎሮ ጌዔቶ ጫሪንጫ ፆኦሲ ዴዓ ቤዞኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ሳዓ ዔኤሊ'' ጫኣቂፖቴ፤ ዓይጎሮ ጌዔቶ ሳዓ ፆኦሲ ቶኮ'' ጌሣ ቤዞኬ። ዬሩሳላሜ ካታሞ ዔኤሊ''ያ ጫኣቂፖቴ፤ ዓይጎሮ ጌዔቶ ዬሩሳላሜ ዼኤፖ ካኣታሢኮ ካታሞኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ኔ ቶኦኮ'' ጋፓኖ ዔኤሊ''ያ ጫኣቂፖ፤ ዓይጎሮ ጌዔቶ ኔኤኮ ቶኦኮ'' ጋፓናፓ ፔቴ''ማ ቡኡቂሳኒ ሃሣ ካርሣኒ ኔ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ዬያሮ ዒንሢኮ ጌኤዛ ‹ሂዮ› ማዔቶ ‹ሂዮ› ‹ዔይዔ› ማዔቶ ዔይዔ ማዖንጎ። ዬማፓ ዑሣ ዓኣዼ ጌኤዞማ ፃላሄይዳፓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ሃሣ ዬሱሴ፦ « ‹ዓኣፒ ዛላሮ ዓኣፒ፥ ዓቺ ዛላሮ ዓቺ› ጌይንቴሢ ዒንሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ታ ጋዓንቴ ዒንሢም ሂዚ ጋዓኔ፤ ፑርታ ዒንሢም ማዻ ዓሶም ኮሜ ማሂፖቴ፤ ጋዓንቴ ሚዛቆ ጋንጋሮ ባዓሢም ሻውሎ'' ጋንጋሮ ሺርሺ ቤኤዜ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ፔቴ'' ዓሲ ኔኤኮ ዴማ'' ማይንቶና ዓፒሎ ዔካኒ ኔና ዎጌና ዓይሢሴቶ ዑፃ ኔ ማይንቴ ዓፒሎ ቃሲ'' ዔካንዳጉዲ ዒዛም ሃሼ''። ");
INSERT INTO mdybse_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ፔቴ'' ዓሲ ‹ታኣኮ ባሶ'' ዔኪ ዻካ'' ታኣና ዎላ'' ጎይፆ ዓኣዼ› ጌዒ ዎልቃዼቶ ዒ ኮዔሢዳፓ ዑሣ ዒዛና ዎላ'' ዓኣዼ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ኔና ሺኢቃሢም ዒንጌ፤ ኔጊዳፓ ታልዓኒ ኮዓሢ ላኣጊፖ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ዬሱሴ ሃሣ፦ «‹ኔ ላጋሢ ናሽኬ፤ ኔ ሞርካሢ ዒፄ› ጌይንቴሢ ዒንሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ታ ዒንሢም ጋዓንቴ ሂዚ ጋዓኔ፦ ዒንሢ ሞርኮ ናሽኩዋቴ፤ ዒፂ ዳካዞንሢና ዒንሢ ሜታሳዞንሢናም ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ያኣዼ ዒንሢ ማዼቶ ጫሪንጮይዳ ዓኣ ዒንሢ ዓዳሢኮ ናይ ዒንሢ ማዓንዳኔ። ዒዚ ፑርቶና ኮዦናም ዓቦ'' ኬሳ''ኔ። ዬያጉዲ ፑርቶ ዓሶና ኮዦ ዓሶናም ዒሮ ዒ ዋርቂሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ዒንሢ፥ ናሽካ ዓሶ ሌሊ ዒ'ንሢ ናሽኬቶ ዓይጎ ማዓንዳይ? ጎሞ ዓሳ ዬያይዱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ዒንሢ ላጎንሢ ሌሊ ዒ'ንሢ ዔኤሌ''ቶ ዓይጎ ባሼ ባኣዚ'' ዒንሢ ማዼይ? ዓይሁዴ ማዒባኣ ዓሳ ዬያ ማዻያቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ዒንሢኮ ጫሪንጮ ዓዳሢ ፔቴ''ታዖ ዻቢንቲባኣያ ማዔሢጉዲ ዒንሢያ ዒማዺ ማዑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ዬሱሴ ጌኤዞ ጌስታዖ፦ «ዓሲ ዒንሢኮ ዛጋንዳጉዲ ጌዒ ዒንሢ ማዻ ኮዦ ባኮ ዓሲ ቤርታ ፔጌና ማዺሢዳፓ ዒንሢና ካፑዋቴ፤ ያዺ ዒንሢ ማዼቶ ጫሪንጮ ዓዳሢ ኮይላ''ፓ ዒንሢ ዔኤቢ ዴንቃዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ዓሲ ዛጎም ጌዒ ጎይፆ ዓጮና ቡኪንቶ ቤዞናይዳ ሄርሺንቲም ኬኤዚ ኬኤዚ ሺራ ዓሶጉዲ፥ ማንቆ ዓሶም ዒንሢ ዔኤቢ ዒንጋ ዎዶ''ና ዓሲ ዛጎም ጌዒ ማዺፖቴ፤ ዬያይዲ ማዻዞንሢ ዒማ''ና ዔያታ ፔኤሲ'' ዴንቂ ጋጋፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ዒንሢ ጋዓንቴ ማንቆ ዓሶም ዒንጋ ዎዶ''ና ዒንሢ ዒንጋ ባኮ ዓሲ ዔሮፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ዒንሢ ዒንጋ ባኮ ዴሜና ዒንጉዋቴ፤ ዴሜና ዒንጊንታ ባኮ ዒንሢኮ ዴንቃ ዓዳሢ ዬያ ዛሎ'' ማሂ ዒንሢም ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ዬሱሴ ሃሣ፦ «ዒንሢ ሺኢቃ ዎዶ''ና ጉሪ ሄርሺንቶሮ ሺኢቃ ዓሶጉዲ ማዒፖቴ፤ ዔያታ ዓሲ ኑና ዛጎም ጌዒ ዓሳ ቡካ ቤዞና ጎይሢ ዓቺናይዳ ዔቂ ሺኢቃኒ ኮዓኔ። ጎኔ ታ ዒንሢም ጋዓኔ፦ ዔያታ ኮዓ ባኮ ቢያ ዬማና ዔኪ ጋጋፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ኔኤኒ ጋዓንቴ ሺኢቃኣና ቆልዖ ጋሮ ጌሊ፥ ካሮ'' ዎዺጋፓ ጴዹዋ ቤዞይዳ ዓኣ ዓዳሢ ሺኢቄ፤ ዓሲ ዔሩዋንቴ ኔ ሺኢቄ ባኮ ዴንቃ ኔ ዓዳሢ ኔኤም ኮይሳሢ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«ዒንሢ ሺኢቃ ዎዶ''ና ፓሡዋ ማሊሢ ላሚ ላሚ ጌይሢና ሺኢጲፃ ዔያቶሲ ዋይዚንታያ ማላ፥ ዓይሁዴ ማዒባኣ ዓሶጉዲ ዒንሢኮ ሺኢጲፆ ጉሪ ዖዶሲፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ሃሣ ዔያቶ ጉዲያኣ ማዒፖቴ፤ ዒንሢኮ ዓዳሢ ዒንሢ ሺኢቃንዳሢኮ ቤርታ ዓይጌ ዒንሢም ኮይሳቴያ ዔዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ዬሱሴ ሃሣ፦ «ዒንሢ ጋዓንቴ ሂዚ ጌዒ ሺኢቁዋቴ፦ ‹ጫሪንጫ ናንጋ ኑ ዓዳሢዮ! ሱንፃ ኔኤኮ ቦንቺንቶም፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ኔ ካኣቱማ ሙኮም፤ ኔ ናሽካ ባካ ጫሪንጫ ማዔሢጉዲ ሳዖይዳኣ ማዖም። ");
INSERT INTO mdybse_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ሓናኣ ዓቢ ሙኡዚ'' ኑም ዒንጌ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ኑም ዻቤሢም ኑ ዓቶም ጋዓሢጉዲ ኑ ዻቢንቶ ዓቶም ጌዔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ፑርታይዳፓ ኑና ካፔ፤ ዻቢሻኒ ጌሾያይዳኣ ኑና ጌልዚፖ፤ ካኣቱሞንታ ዎልቆንታ ቦንቾንታ ናንጊና ኔኤሮኬ ዓኣሜን› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ሃሣ ዬሱሴ ኬኤዛዖ፦ «ዓሳ ዒንሢም ዻባ ዻቢንቶ ዒንሢ ዓቶም ጌዔቶ ዒንሢሲያ ጫሪንጮ ዓዳሢ ዓቶም ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ዓሳ ዒንሢም ዻቤ ባኮ ዓቶም ዒንሢ ጌዒባኣቶ ዒንሢ ዻቢንቶዋ ጫሪንጮ ዓዳሢ ዓቶም ጋዓዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ዬሱሴ ሃሣ፦ «ዒንሢ ሙዖ ሃሺ'' ሺኢቆ ሺኢጲፆ ሺኢቃ ዎዶ''ና ሄርሺንቶሮ ማዻ ዓሳ ማዻሢጉዲ ማዺፖቴ፤ ዔያታ ሙዖ ሃሾ'' ዳምቦ ማዻ ዎዶ''ና ሙኡዚ'' ሃሻ''ያ ማዔሢ ዔርታንዳጉዲ ሲዬ ዓሲጉዲ ማዓኔ። ጎኔ ታ ዒንሢም ጋዓኔ፦ ዔያታ ዬያይዲፆና ዔያቶም ኮይሳ ባኮ ቢያ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ኔኤኒ ጋዓንቴ ሙዖ ሃሺ'' ሺኢቃ ዎዶ''ና ዓኣፖ ካሮ'' ማስቲ ቶኦኮ''ዋ ቲሽቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ኔኤኒ ዬያይዴቴ ሙዖ ሃሺ'' ሺኢቃያታሢ ጴዹዋ ቤዛ ዓኣ ኔ ዓዳሢዳፓ ዓታዛ ሜሌ'' ዖኦኒያ ዔሪንዱዋሴ። ዓኣሺንቴ ቤዛ ኔ ሺኢቄ ባኮ ዛጋ ኔ ዓዳሢ ኔኤም ኮይሳ ባኮ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ቁንቁና ሙዓኒ፥ ሳልፒ ፑርታኒ ሃሣ ዉሲያ ቦኦኪ ዉኡቃኒ ዳንዳዓ፥ ሃያ ዓጮ''ይዳ ዒንሢም ማዓ ቆሎ ቡኩሲፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ጋዓንቴ ቁንቁና ሙዓኒ፥ ሳልፒ ፑርታኒ ሃሣ ዉሲያ ቦኦኪ ዉኡቃኒ ዳንዳዑዋ፥ ሎ ጫሪንጮ ማኣሮይዳ ዒንሢኮ ቆሎ'' ቡኩሱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ዒንሢኮ ቆላ'' ዓኣ ቤዞይዳ ማሊፃኣ ዒንሢኮ ዒኢካ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«ኔኤኮ ዓኣፓ ዑፆኮ ፆንፔኬ፤ ዬያሮ ዓኣፓ ኔኤኮ ኮሺ ማዔቶ ጉቤ ዑፃ ኔኤኮ ፖዓያ ማዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ዓኣፓ ኔኤኮ ሃርጌያ ማዔቶ ጋዓንቴ ጉቤ ዑፃ ኔኤኮ ዹሚ'' ማዓኔ፤ ዓካሪ ኔጊዳ ዓኣ ፖዓ ዹሚ'' ማዔቶ ዬይ ዹማ'' ዎማጉዲ ሻኔ ዹሚ'' ማዓንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«ፔቴ'' ዓሲ ላምዖ ጎዳቲም ማዻኒ ዳንዳዑዋሴ፤ ማዻቴ ፔቴ''ሢ ዒፂ ባጋሢ ናሽካንዳኔ፥ ማዒባኣቶ ፔቴ''ሢ ቦንቺ ፔቴ''ሢ ቦሃንዳኔ፤ ዬያጉዲ ፆኦሲና ሚኢሼናም ፔቴ''ና ማዻኒ ዳንዳዒንቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ዒንሢ ናንጎ ዛሎ'' ዓይጎ ኑ ሙዓንዳይ? ዓይጎ ኑ ዑሽካንዳይ? ሃሣ ዓይጎ ኑ ማይንታንዳይ? ጌዒ ማሊ ሜታዺፖቴ። ሼምፓ ሙኡዚ''ዳፓ፥ ዑሢ ማኣዖይዳፓ ባሼቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ሂንዳ ካፖ ዛጉዋቴ፤ ጎሽኩዋሴ፥ ሃኣኮ ታይዚ ኮናይዳ ዋሁዋሴ፤ ማዔቶዋ ዒንሢኮ ጫሪንጮ ዓዳሢ ዔያቶ ሙኡዛኔ። ሂዳዖ ዒንሢ ዔያቶይዳፓ ባሹዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ጎዖንቴ ዒንሢ ባኣካ''ፓ ሜታዺ ናንጎ ሌዖይዳ ዻካ'' ዎዴ ቃሳ''ኒ ዳንዳዓይ ዓኣ? ");
INSERT INTO mdybse_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«ሃሣ ማኣዖ ዛላኣ ዓይጎሮ ዒንሢ ሜታዺ ማላይ? ሂንዳ ካዮ ቡኖ ዛጉዋቴ፥ ዔያታ ሜታዺ ሱኩዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ጋዓንቴ ካኣቲ ሴሎሞኔ ቦንቺንቴታቴያ ዬያ ቡኖይዳፓ ፔቴ''ማጉዲታዖ ማይንቲ ሚዛጲባኣሴ፤ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ዓካሪ ዒንሢ ጉሙርቂፃ ዻኬ'' ዓሳ! ሃኖ'' ኮሽካዖ ዚሮ ታሚዳ ዓጊንታ፥ ካዮ ማኣቶ ዬያይዲ ፆኦሲ ፓልሚሴቶ ዒንሢም ዎይቲ ባሼና ዒ ማሊንዱዋይ? ");
INSERT INTO mdybse_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ዬያሮ ዓይጎ ኑ ሙዒ፥ ዑሽካንዳይ? ሃሣ ኑ ዓይጎ ማይንታንዳይ? ጌዒ ማሊ ሜታዺፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ዓይሁዴ ማዒባኣ ዓሳ ዬንሢ ባኮንሢ ዴንቆሮ ማሊ ሜታዻኔ፤ ዒንሢኮ ጫሪንጮ ዓዳሢ ዬይ ቢያ ዒንሢም ኮይሳሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ቢያይዳፓ ቤርታዺ ጋዓንቴ ፆኦሲኮ ካኣቱሞና ፂሉ''ሞና ኮዑዋቴ፤ ዬይ ዒንሢ ማላ ባካኣ ቢያ ዒንሢም ዒንጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ዬያሮ ዚራ ባኣዚ''ሮ ማሊ ሜታዺፖቴ፤ ዚሮ ማሊሳ ባካ ዚራሮ ማዖንጎ፤ ፔቴ'' ፔቴ'' ኬላ'' ፔኤኮ ጊዳ ሜቶና ዓኣያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ፆኦሲ ዒንሢዳ ዎጉዋጉዲ ዖናኣ ‹ዒ ፑርታኬ› ጌይ ዎጊፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ዒንሢ ዎጌ ጎይፆማ ዒንሢም ዎጊንታንዳኔ፤ ዒንሢ ማኬ''ማና ዒንሢም ማኪ''ንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ኔ ዓኣፖይዳ ዓኣ ዼኤፖ ቡኡሮ ዴንቁዋዖ ኔ ላጋሢኮ ዓኣፖይዳ ዓኣ ዻኮ'' ቡኡሮማ ዓይጋ ኔ ዛጋይ? ");
INSERT INTO mdybse_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ኔ ዓኣፖይዳ ዼኤፒ ቡኡራ ዓኣንቴ፥ ‹ኔኤኮ ዓኣፓፓ ዻኮ'' ቡኡሮማ ታ ኬሶ''ም› ዎይቲ ኔ ጋዓኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ሃይ ኔ ሄርሺንታሢ ሃይ! ቤርታዺ ኔኤኮ ዓኣፓ ዓኣ ዼኤፖ ቡኡሮ ኬሴ''፤ ዬካፓ ኔ ላጋሢኮ ዓኣፓ ዓኣ ዻኮ'' ቡኡሮማ ኔ ዴንቂ ኬሳ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ፆኦሲም ዱማዼ፥ ጌኤዦ ባኮ ካናቶም ዓጊፖቴ፤ ሃሣ ሚዛጶ ሹጮ ጉዱንፆ ቤርታ ኬኤሪፖቴ፤ ዓይጎሮ ጌዔቶ ጉዱንፃ ዬያ ሚዛጶ ሹጮ ቶኪና ሄ'ርቃንዳኔ፤ ካናታ ሃሣ ጊንሣ ሺሪ ዒንሢ ዻዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ዬሱሴ ሃሣ ኬኤዛዖ፦ «‹ሺኢቁዋቴ ዒንሢም ዒንጊንታንዳኔ፤ ኮዑዋቴ ዒንሢ ዴንቃንዳኔ፤ ካራ'' ዔቂ ዔኤሉ''ዋቴ ካራ'' ዒንሢም ቡሊ''ንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ሺኢቃሢም ቢያ ዒንጊንታንዳኔ፤ ኮዓሢያ ዴንቃንዳኔ፤ ካራ'' ዔቂ ዔኤላ''ሢማኣ ካራ'' ቡሊ''ንታንዳኔ።› ");
INSERT INTO mdybse_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‹ዒንሢ ባኣካ''ፓ ናዓ ካሣ ሺኢቃዛ ሹቺ ዒንጋ ዓዴ ዓኣ? ");
INSERT INTO mdybse_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ሃሣ ጊንሣ ዓሽኪ ሺኢቃዛ ሾኦሺ ዒንጋይ ዓኣ? ");
INSERT INTO mdybse_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ዓካሪ ዒንሢ ፑርታታዖ ዒንሢ ናኣቶ''ም ኮሺ ባኣዚ'' ዒንጊ ዔራቶ፥ ዒንሢኮ ጫሪንጮይዳ ዓኣ ዓዳሢ ዒዛ ሺኢቃዞንሢም ኮሺ ባኣዚ'' ዒንጋንዳሢ ባሼና ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ሜሌ'' ዓሳ ዒንሢም ማዻንዳጉዲ ዒንሢ ኮዓ ባኮ ዒንሢያ ዔያቶም ማዹዋቴ፤ ሙሴ ዎጎና ፆኦሲ ማሊፆ ኬኤዛ ዓሶናኮ ዔርዚፃ ያዺ ጋዓኔ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ኩንዖ ካሬ''ሎና ጌሉዋቴ፤ ዓይጎሮ ጌዔቶ ባይሲንቶ ባንሢ ጌልዛ ካራ'' ዳልጊ፥ ዔኪ ዓኣዻ ጎይፃኣ ዳልጊኬ። ዬኖ ባንሢ ጌላንዳ ዓሳ ሚርጌኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ናንጊ ባንሢ ጌልዛ ካራ'' ጋዓንቴ ኩንዔ፥ ጎይፃኣ ሜታሳያኬ፤ ዬያሮ ዬኖ ጎይፄሎና ጌላንዳ ዓሳ ዻካ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ጋሮና ሙዓ ያኣዮታዖ፥ ማራይ ጉፓሌ ማይንቲ ዒንሢ ባኣኮ'' ጌሊ ዒንሢ ባይዛኒ ማላ ሉኡቂ ‹ፆኦሲ ማሊፆ ኬኤዛኔ› ጋዓዞንሢዳፓ ካፒንቱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ዒንሢ ዔያቶኮ ማዾ'' ዓኣፖይዳፓ ዔራንዳኔ፤ ጋውዲዳፓ ኩሩንቱሼ፤ ሓሣ ጋኣላንሣይዳፓ ሻኣቢ ማንፂንታ? ");
INSERT INTO mdybse_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ዬያጉዲ ኮሺ ሚሢ ቢያ ኮሺ ዓኣፒ፥ ፑርታ ሚሢ ሃሣ ፑርታ ዓኣፒ ዓኣፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ኮሺ ሚሢ ፑርታ ዓኣፒ፥ ፑርታ ሚሢ ኮሺ ዓኣፒ ዓኣፓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ኮሺ ዓኣፒ ዓኣፑዋ ሚሢ ቢያ ቲቂንቲ ታሚዳ ዓጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ዬያሮ ሉኡቂ ፆኦሲ ማሊፆ ኬኤዛኔ ጋዓ ዓሶኮ ማዾ'' ዓኣፖይዳፓ ዒንሢ ዔራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ጫሪንጫ ዓኣ ታ ዓዶ ማሊፆ ኩንሡዋዖ ‹ጎዳሢዮ፥ ጎዳሢዮ› ጋዓሢ ቢያ ጫሪንጮ ካኣቱሞይዳ ጌላዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ዓጮ''ይዳ ፆኦሲ ዎጋ ኬሎ'' ሚርጌሢ ‹ጎዳሢዮ! ጎዳሢዮ! ኔ ሱ'ንፆና ፆኦሲ ማሊሢ ኑ ኬኤዚባኣዓዳ? ኔ ሱ'ንፆና ፑርታ ዓያና ዓሶይዳፓ ኑ ኬሲ''ባኣዓዳ? ኔ ሱ'ንፆና ማዺንታ ሚርጌ ዓኪ ባኣዚ'' ኑ ማዺባኣዓዳ?› ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ዬኖ ዎዶ''ና ‹ፔቴ''ታዖ ታ ዒንሢ ዔሩዋሴ፥ ዒንሢ ፑርቶ ዓሳ ታ ኮይላ''ፓ ሺኢኩዋቴ!› ጌዒ ፔጌና ታ ዔያቶም ኬኤዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ዓካሪ ሃያ ታኣኮ ቃኣሎ'' ዋይዚ ማዻ ዓሢ ማኣሮ ዶዲ ቤስካ ዶዲሺ ማዤ ጪንጫ ዓሲ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ዼኤፒ ዒርዚ ዋርቄም ዲጳ ኩሚ''፥ ዢባሬያ ዢባርሼኔ፤ ጋዓንቴ ዬይ ማኣራሢ ዶዲ ቤሲዳ ማዢንቴሢሮ ዶዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","«ሓያ ታኣኮ ቃኣሎ'' ዋይዚ ማዹዋኣሢ ጋዓንቴ ማኣሮ ማኣሻላይዳ ማዤ ቦኦዛ ዓሲ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ዼኤፒ ዒርዚ ዋርቄም፥ ዲጳ ኩሚ'' ዢባሬያ ዢባርሻዛ ዬና ማኣሬላ ቤዞና ጋፒ ዶዔኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ዬሱሴ ዬያ ባኮ ኬኤዚ ጋፒሳዛ ዴራ'' ዒዛኮ ዔርዚፆና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ዓይጎሮ ጌዔቶ ዒዚ ዔያቶኮ ዎጎ ዔርዛ ዓሶጉዲቱዋንቴ ዼኤፒ ቢታንቶና ዔርዛሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ዬሱሴ ዹካ''ፓ ኬዴ'' ዎዶ''ና ሚርጌ ዴሬ ዒዛ ጊንፆ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ዬኖና ፔቴ'' ዑስካ ኬስካ ዶርዓ ዓርቄ ዓሲስኬይ ዬሱሴ ኮይላ'' ሙኪ ባሊቲና ሳዓ ሎኦማዖ፦ «ጎዳሢዮ! ኔ ኮዔቴ ታና ጌኤሻ''ኒ ዳንዳዓኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ዬሱሴ ዒዛኮ ዑፆ ዓርቃዖ፦ «ጌኤሽኬ! ኔ ጌኤሽካንዳጉዲ ታ ኮዔኔ» ጋዓዛ ዬይ ዓሢ ቤዞና ዶርዓሢዳፓ ዻቂ ጌኤሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ዬካፓ ዬሱሴ፥ ዬኖ ዶርዔሎይዳፓ ዻቂ ጌኤሽኬ ዓሢም፦ «ሃያ ባኮ ዖኦማኣ ኬኤዚፖ፤ ጋዓንቴ ሃሢ ዓኣዺጋፓ ኔኤኒ ጌኤሽኬሢ ቄኤሳሢም ዻዌ፤ ሃሣ ቢያሢም ማርካ ማዓንዳጉዲ ኔኤኮ ዶርዓሢዳፓ ፖዒፆ ዛሎ'' ሙሴ ዓይሤ ዒንጎ ባኮ ፆኦሲም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ዬካፓ ዬሱሴ ቂፒርናሆሜ ካታሞ ጌላዛ ፄኤታ ፖኦሊሴ ዓይሣ፥ ፔቴ'' ሮሜ ዓጪ ዓሲስኬይ ዒዛ ኮይላ'' ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ጎዳሢዮ! ታኣኮ ማዻሢ ሓርጊንቲ ዎቢ፥ ሚርጌ ሜታዺ ጋራ ላሂ ዓኣኔ፤ ታና ማኣዴ''» ጌዒ ሺኢቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ዬሱሴ ማሃዖ፦ «ታ ዒዛ ሙኪ ፓሣንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ፖኦሊሶ ዓይሣሢ ጋዓንቴ፦ «ጎዳሢዮ! ታ ማኣሪ ኔ ጌላኒ ታ ጊኢጋ ዓሲቱዋሴ፤ ዬያሮ ሃካ ዓኣዖ ፔቴ'' ባኣዚ'' ጌዔ፤ ታኣኮ ማዻሢ ፖዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ታኣኒ ታ ቶኦኪና ዎይሣ ዓሲም ዓይሢንታያ ሓሣ ታ ዴማ''፥ ታኣም ዓይሢንታ ፖኦሊሴ ዓኣኔ፤ ዔያቶይዳፓ ፔቴ''ሢ ‹ዴንዴ!› ታ ጋዓዛ ዴዴንዳኔ፤ ባጋሢ ሃሣ ‹ሃኒ ዬዔ!› ታ ጋዓዛ ሙካኔ፤ ታኣም ማዻሢ ‹ሃያ ታኣም ማዼ!› ታ ጋዓዛ ዒ ማማዻኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ዬሱሴ ዬያ ዋይዜ ዎዶ''ና ዲቃቲ ሄርሻዖ ዒዛና ዎላ'' ዓኣዻ ዓሶ ኮይላ''፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃያጉዴ ዼኤፒ ጉሙርቂሢ ዓኣ ዓሲ ፔቴ''ታዖ፥ ዒስራዔኤሌይዳኣ ማዖም ታ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ዔሩዋቴ፤ ሚርጌ ዓሲ ዓባ'' ኬስካ ዛሎ''ና ጌላ ዛሎ''ናይዳፓ ሙኪ ዓብራሃሜና ዪሳኣቄና ሃሣ ያይቆኦቤና ዎላ'' ጫሪንጮ ካኣቱሞይዳ ሙዓኒ ዴዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ጫሪንጮ ካኣቱሞም ጊኢጊንቴያታዖ ዙሎ'' ዹሞ ቤዛ ኬኤሪንታንዳይ ዓኣኔ። ዬካ ዬና ዓሳ ዬኤኪ ዓቺ ዻዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ዬካፓ ዬሱሴ ፄኤቶ ፖኦሊሶ ዓይሣሢም፦ «ዴንዴ፥ ኔ ጉሙርቄሢጉዲ ማዖንጎ» ጌዔኔ። ዬያ ዓሢኮ ማዻሢ ዬማ''ና ፖፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ዒማ''ና ዬሱሴ ጲፂሮሴ ማኣሪ ጌላዖ፥ ጲፂሮሴኮ ባይሳ ቆፂንቲ ላሂ ዓኣንቴ ዴንቂ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ዒዞኮ ኩጮ ዒ ካኣማዛ ቤዞና ቆሣ ዒዞኮ ሃይቄም ዔቂ ዒዛ ሾኦቺንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ዬካፓ ሳዓ ዓማዛ፥ ዓሳ ፑርታ ዓያና ዓርቄ ሚርጌ ሃርጌ ዓሲ ዬሱሴ ኮይላ'' ዔኪ ሙካዛ «ኬስኬ» ጌይሢና ሌሊ ፑርቶ ዓያኖ ኬሴ''ም ሃርጊንቴ ዓሳ ቢያ ፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ዬያይዲፆና ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፦ «ዒዚ ኑኡኮ ዶርዓሢ ዔኪ ኑጊዳፓ ዳኬኔ» ጌይንቴሢ ኩሜ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ዬሱሴ ሚርጌ ዓሲ ዒዛ ኮይላ'' ቡኪ ዓኣሢ ዛጋዖ ዒዛኮ ጊንፆ ሃንታዞንሢ ባዞ''ኮ ሶ ሱኮ ፒንቃንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ዒማ''ና ፔቴ'' ሙሴ ዎጎ ዔርዛ ዓሲ ዒዛ ባንሢ ሙካዖ፦ «ዔርዛሢዮ! ኔ ዓኣዻ ቤዞ ቢያ ታ ኔኤና ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ዬሱሴ ማሃዖ፦ «ዉኡካሢኮ ዎርቆ ዔቴ፤ ካፖኮ ሃሣ ማኣሪ ዓኣኔ። ዓሲ ናዓሢ ጋዓንቴ ላሂ ሃውሻንዳ ቤሲታዖ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ''ይ፦ «ጎዳሢዮ! ቤርታዺ ታ ዴንዲ ታ ዓዴ ሃይቄም ዱኡኪ ሙኮም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ዬሱሴ ማሃዖ፦ «ኔኤኒ ታ ጊንፆ ሙኬ፤ ሃይቄ ዓሳ ሃይቄ ዓሶ ዱኡካንዳጉዲ ሃሼ''» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዋኣፆና ፒንቆ ጎንጎ ቶጊ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ዬማና ዔርቲባኣ ዼኤፒ ባዚ'' ጉዳ ዔቂ፥ ዋኣፆና ፒንቆ ጎንጌሎ ዋኣፆ ኩንሢ፥ ዔኤዺሳኒ ዑኪ ሜታሴኔ፤ ዬሱሴ ጋዓንቴ ዒማ''ና ጊንዒ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዒዛ ጴቻዖ፦ «ጎዳሢዮ! ኑ ኩዴኔ፥ ኑና ዓውሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ዬሱሴ ዒማ''ና፦ «ሓይ ዒንሢ ጉሙርቂፃ ፓጬ ዓሳ፥ ዓይጎሮ ዒንሢ ሃያይዲ ዒጊጬይ!» ጋዓዖ፥ ዔቂ ዢባሮና ዼኤፖ ጉዳሢና ጎሬም ቤዞና ቢያ ባካ ዚቲዮ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ዓሳ ጋዓንቴ ሚርጌና ዲቃቲ ሄርሻዖ፦ «ሃይ ዢባሮንታ ባዞ''ንታ ቢያ ዓይሢንታሢ ዎዚጉዴ ዓሲዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ዬሱሴ ጌሊላ ባዞ''ና ፒንቂ ጌርሴኖኔ ዓጮ'' ሙካዛ ዒኢካ ፑርታ ዓያና ዓርቄ ላምዖ ዓሲ ዱኡፒ ካይዚዳፓ ኬስኪ ዒዛና ካኣሜኔ፤ ዬንሢ ሚርጌና ፑርታ ዓሲ ማዔሢሮ ዓይጎ ዓሲያ ዬኖ ጎይፆና ዓኣዻኒ ዳንዳዑዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ዔያታ፦ «ፆኦሲ ናዓሢዮ! ኑኡና ዎላ'' ኔኤኮ ዓይጌ ዓኣይ? ዎዳ'' ሄሉ''ዋንቴ ኔ ኑና ሜታሳኒ ሙኪያ?» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ዔያታ ዓኣ ቤዛፓ ዻካ'' ሃኬ ቤሲዳ ቆሎ ጉዱንሢ ዺቢ ሄንቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ፑርቶ ዓያኖንሢ ዬሱሴ ኮራ፦ «ኔ ኑና ኬሳ''ያ ማዔቴ፥ ሃሴኬ ጉዱንፆይዳ ኑ ጌላንዳጉዲ ኑና ዓይሤ» ጌዒ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ዬሱሴያ፦ «ዴንዱዋቴ!» ጋዓዛ፥ ፑርቶ ዓያኖንሢ ዓሶንሢዳፓ ኬስኪ ጉዱንፆይዳ ጌላዛ፥ ጉዱንፃ ቢያ ዔያታ ሄንቃ ማጎ ዓጮይዳፓ ዲርጊ ባዞ''ይዳ ጌሊ ሙይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ጉዱንፆ ሄንቃ ናኣታ'' ጳሽኪ ካታሞ ዴንዳዖ፥ ማዔ ባኮ ቢያ ሃሣ ፑርቶ ዓያኖና ዓርቂንቴ ዓሶንሢዳኣ ማዺንቴ ባኮ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ዬካፓ ካታሞ ዓሳ ጉቤ ዬሱሴ ዛጋኒ ካታማፓ ሙኪ ዒዛ ዴንቃዖ ዔያቶኮ ዓጫ''ፓ ዒ ኬስኪ ዓኣዻንዳጉዲ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ዬካፓ ዬሱሴ ዋኣፆና ፒንቆ ጎንጎ ቶጊ ባዞ'' ጊዴና ፒንቂ ፔ ካታሞ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ዒኢካ ዓሳ ፔቴ'' ዎቦ ዓሲ ሃሎና ኬዲ ዔኪ ሙኬኔ። ዬሱሴ ዔያቶኮ ጉሙርቂፆ ዛጋዖ ዎቦ ዓሢም፦ «ታ ናዓሦ ማሊፖ! ጎማ ኔኤኮ ዓቶም ጌይንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ዒማ''ና ሙሴ ዎጎ ዔርዛ ፔቴ'' ፔቴ'' ዓሳ፦ «ሃይ ፆኦሲ ጫሺኬ» ጌዒ ፔ ዒኖና ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ዬሱሴ ዔያቶኮ ማሊፆ ዔሪጋፓ፦ «ዓይጎሮ ዒንሢ ሃያጉዴ ፑርታ ባኣዚ'' ዒኖና ማላይ? ");
INSERT INTO mdybse_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‹ጎማ ኔኤኮ ዓቶም ጌይንቴኔ› ጌይሢና ‹ዔቂ ዴንዴ› ጌይሢናይዳፓ ሂንዳ ዎና ሼሌዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ጋዓንቴ ዓሲኮ ናዓሢ ሳዖይዳ ዓሲኮ ጎሜ ዓቶም ጋዓኒ ቢታንቶ ዓኣሢ ዒንሢ ዔራንዳያ ኮይሳኔ» ጋዓዖ፥ ዎቦ ዓሢም፦ «ዔቂ ሃላሢ ኔኤኮ ኬዲ ኔ ማኣሪ ዓኣዼ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ዬማ''ና ዎቦ ዓሢ ዔቂ ፔ ማኣሪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ዴራ'' ዬያ ዛጋዖ ዲቃቲ ሄርሺ፥ ዒጊጪሢና ዬያጉዴ ቢታንቶ ዓሲም ዒንጌ ፆኦዛሢ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ዬሱሴ ዴንዲቤቃ ማቲዎሴ ጎዖስኬይ ኮርሞ ዓሶፓ ሚኢሾ ቡኩሳ ቤዛ ዴዒ ዓኣንቴ ዴንቂ፦ «ሃኒ ታ ጊንፆ ሙኬ!» ጋዓዛ፥ ዒዚያ ዔቂ ዒዛ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ዬካፓ ዬሱሴ ማቲዎሴ ማኣሮይዳ ሙዓኒ ዴዓዛ ሚኢሾ ቡኩሳ ዓሶንታ ጎሞ ዓሶንታ ሚርጌ ዓሲ ሙኪ ዒዛና ሓሣ ዒዛኮ ጊንጸ ሃንታዞንሢና ዎላ'' ሙዓኒ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ፔርሴ ዓሳ ዬያ ዛጋዖ ዬሱሴኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ዒንሢኮ ዔርዛሢ ሃያ ሚኢሾ ቡኩሳ ዓሶና ጎሞ ዓሶና ዎላ'' ዴዒ ዎይቲ ሙዓይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ዬሱሴ ዔያታ ጌዔሢ ዋይዛዖ፦ «ዼኤሻ ዔራ ዓሲ ኮይሳሢ ሃርጊንቴ ዓሲም ማዓንዳፓዓቴም ዋሊ'' ዓሲምቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ዴንዲ፦ ‹ዒንጎ ባኣዚ'' ዒንጋያይዳፓ ባሼ ዓሲ ሚጪንታ ዓሲ ታ ናሽካኔ› ጋዓ ቃኣላ'' ዎይዚ ጌይሢታቴያ ማሊ ጶቂሢ ዔሩዋቴ፤ ጎሞ'' ዓሶ ዔኤላ''ኒ ማዓንዳኣፓዓቴም ፂሎ'' ዓሶ ዔኤላ''ኒ ታ ሙኪባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ዒማና ማስካ ዮሓኒሴኮ ጊንፆ ሃንታ ናኣታ'' ዬሱሴ ኮራ ሙካዖ፦ «ኑኡና ፔርሴ ዓሶና ሙዖ ሃሺ''ፆ ዳምቦ ካፓንቴ፥ ኔ ጊንፆ ሃንታ ናኣታ'' ዓይጎሮ ዬያይዲ ካፑዋይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ዬሱሴ ማሃዖ፦ «ዑኡታሢ ዔያቶና ዎላ'' ዓኣንቴ ዔፖ ዓሳ ዎይቲ ሙይ ዑሽኪ ዎዛዹዋዖ ሃሻ''ንዳይ? ዑኡታሢ ዔያቶይዳፓ ዔውታንዳ ዎዴ ሙካንዳኔ፤ ዬኖ ዎዶ''ና ዔያታ ሙዖ ሃሺ''ፆ ዳምቦ ካፓንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«ዓኪ ዓፒላይዳፓ ዔኪ ጪሚ ዓፒላይዳ ዓጊ ሲካይ ባኣሴ፤ ያዺ ማዔቶ ዓኮ ዓጊፃ ጉርሚ ጪሞ ዓፒሎ ዳዳርዛንዳኔ፤ ዳርዒፃኣ ፔቶ ዳልጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ዬያጉዲ ሶልኪ ዑሺ ዋሆ ጪንቄ ዖቲዳ ሺሜ ዋሂንቱዋሴ፤ ዋሂንቴቴ ጋዓንቴ ሺሜ ዑዣ ቡርቂ ዖቶ ዹኡሴም ዑዣ ላኣሊንታንዳኔ፤ ዖታኣ ጉሪ ዓታንዳኔ። ዬያሮ ሺሜ ዑሺም ዓኪ ጌኤሺ ዖቲ ኮይሳኔ፤ ዬያይዴቴ ዑዣ ዖቶይዳ ዔኤቢ ዎኦቱዋዖ ዴዓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ዬሱሴ ዬያ ዓሶም ኬኤዚፆይዳ ዓኣንቴ ፔቴ'' ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጌስኬይ ሙኪ ባሊቲና ዒዛ ቤርታ ሎኦማዖ፦ «ታኣኮ ናይስኬና ሃርጊ፥ ሃሢ ሃይቄኔ፤ ሃዳራ፥ ኔኤኒ ሙኪ ዒዞ ዑፃ ኩጮ ጌሤቶ ዒዛ ዻቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ዬያሮ ዬሱሴ ዔቂ ዓሢ ጊንፆ ዓኣዻዛ ዒዛ ጊንፆ ሃንታዞንሢያ ዎላ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ዬካፓ ታጶ ላምዖ ሌዔ ጉቤ ላኣሎ ናይ ዶርዖና ሜታዻ ፔቴ'' ላኣሊስኬና ዬሱሴኮ ጊንፆ ዛሎ''ና ሙኪ ዓፒሎኮ ዓጮ ካኣሜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ዬያ ዒዛ ማዼሢ፦ «ዒዛኮ ዓፒሎታዖ ኩጮና ታ ካኣሜቶ ዻቃንዳኔ» ጌዒ ፔ ዒኖና ማሌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ዬሱሴ ዒማና ጊንሢም ሺሪ ላኣሌሎ ዛጋዖ፦ «ታ ናዔሌ ማሊፖ፥ ኔ ጉሙርቂፃ ኔና ዻቂሼኔ» ጋዓዛ፥ ላኣሌላ ቤዞማና ዻቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ዬካፓ ዬሱሴ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጋሢ ማኣሪ ሄላ''ዖ ዲንካሢ ዋርቂ ሃሣ ጳሽኪ ዒላቲ ዒላቲ ዬኤካ ዓሶ ዛጊ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ዓሶ፦ «ሺኢኩዋቴ! ናዔላ ጊጊንዔያፓዓቴም ሃሃይቂባኣሴ!» ጋዓዛ፥ ዔያታ ዒዛ ቦሂ ሚኢጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ዴራ'' ኬስኬሢኮ ጊንፃ ዒዚ ጋሮ ጌላዖ ናዔሎኮ ኩጮ ዓርቃዛ ዒዛ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ዬይ ሃይሳ ዬኖ ዓጮ'' ቢያይዳ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ዬሱሴ ዬኖ ቤዛፓ ዴንዳንቴ ላምዖ ዓኣፒ ባይቄ ዓሲስኬንሢ፦ «ዳውቴ ናዓሢዮ! ሃዳራ ኑና ማኣዴ''» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ዬካፓ ዬሱሴ ኬኤፆ ጌላዛ ዓኣፖ ባይቄዞንሢ ዒዛ ጊንፆ ሙኬም፥ ዬሱሴ ዔያቶ ኮራ፦ «ዒንሢኮ ዓኣፖ ታ ቡላ''ንዳሢ ዒንሢ ጉሙርቃ?» ጌዒ ዖኦጬኔ። ዔያታ ማሃዖ፦ «ሂዮ፥ ጎዳሢዮ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ዬካፓ ዬሱሴ ዔያቶኮ ዓኣፖ ኩቻ ካኣማዖ፦ «ዒንሢ ጉሙርቄሢጉዲ ዒንሢም ማዖንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ዓኣፓ ዔያቶኮ ቡሊ''ንታዛ ዬሱሴ ዔያቶም፦ «ሃያ ዖኦማኣ ዒንሢ ኬኤዙዋጉዲ!» ጌዒ ዶዲሺ ላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ዔያታ ጋዓንቴ ኬስካዖ ዒኢካ ጉርዶ ቢያይዳ ዬሱሴ ዛሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ዓኣፓ ባይቄ ዓሶንሢ ኬስኪ ዓኣዻዛ ሜሌ'' ዓሲ ፑርታ ዓያና ዓርቄም፥ ዻንጋ ባይቄስኬያ ዬሱሴ ኮይላ'' ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ፑርቶ ዓያኖ ዬሱሴ ኬሴስካፓ ዻንጎ ባይቄ ዓሢ ጌስቲሢ ዓርቄኔ፤ ዬያሮ ዴራ'' ዲቃቲ ሄርሻዖ፦ «ሃያጉዴ ባኣዚ'' ዒስራዔኤሌ ዓጮ''ይዳ ኑ ዛጊ ቤቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ፔርሴ ዓሳ ጋዓንቴ፦ «ዒዚ ፑርቶ ዓያኖ ዓሶፓ ኬሳ''ሢ ፑርቶ ዓያኖ ሱኡጋሢ ዎልቆናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ዬሱሴ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳ ዔርዚ ዔርዚ፥ ፆኦሲ ካኣቱሞ ዛሎ'' ኮዦ ሃይሶዋ ኬኤዚ ኬኤዚ ዬያጉዲ ሃሣ ዶርዓሢያ ቢያ ፖዒሲ ፖዒሲ ካታሞና ጉርዶናይዳ ሃንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ዒማና ዴራ'' ሄንቃ ዓሲባኣ ማራይጉዲ ሜታዻያ ሃሣ ማኣዳ''ያ ዔያቶ ባኣያ ማዔሢ ዛጌ ዎዶ''ና ዒ ዔያቶ ሚጪንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ዬያሮ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ቡኩሶንዶ ሃኣካ ሚርጌኬ፤ ሃኣኮ ቡኩሳዞንሢ ጋዓንቴ ዻካ''ታሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ሃኣኮ ቡኩሳ ዓሶይዳ ቃሲ'' ዓሲ ዳካንዳጉዲ ሃኣኮ ዓዶ ሺኢቁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ዬሱሴ ታጶ ላምዖ ዒዛ ጊንፆ ሃንታዞንሢ ፔ ባንሢ ዔኤላ''ዖ ፑርቶ ዓያኖ ኬሳ''ንዳጉዲ ሃሣ ዶርዖ ቢያ ፖዒሳንዳጉዲ ቢታንቶ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ታጶ ላምዖ ዒዛ ጊንፆ ሃንታዞንሢኮ ሱ'ንፃ፦ ቤርታ ሲሞኦኔ ጌይንታ ጲፂሮሴንታ ዒዛኮ ጌርሲ ዒንዲራሴ፥ ዜብዲዮሴ ናኣቶ''ንሢ፦ ያይቆኦቤ፥ ዮሓኒሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፒልጶሴ፥ ቤርቴሌሞሴ፥ ቶኦማኣሴ፥ ሚኢሾ ቡኩሳ ማቲዎሴ፥ ዒልፒዮሴ ናኣዚ'' ያይቆኦቤ፥ ታዲዮሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ፔ ዓጮ'' ናሽካ ሲሞኦኔንታ ዬሱሴ ዓኣሢ ዒንጌ፥ ዓስቆሮንቶ ዓጮ'' ዓሢ ዪሁዳንታኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ዬሱሴ ዬንሢ ታጶ ላምዖ ዒዛኮ ጊንፆ ሃንታዞንሢም፦ «ዓይሁዴ ማዒባኣ ዓሶ ባንሢ ዴንዲፖቴ፤ ሃሣ ሳማሪያ ካታሞዋ ጌሊፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ጋዓንቴ ማራቶጉዲ ዣኣሌ፥ ዒስራዔኤሌ ዓሶ ባንሢ ዓኣዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ዴንዲጋፓ ‹ጫሪንጮ ካኣቱማ ዑኬኔ› ጌዒ ጌዒ ኬኤዙዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ዶርዓሢና ዓኣ ዓሶ ፖዒሱዋቴ፤ ሃይቄ ዓሶዋ ሃይባ''ፓ ዔቂሱዋቴ፤ ዑፃ ኬስካ ዶርዓሢና ዓኣ ዓሶ ዻቂሹዋቴ፤ ፑርቶ ዓያኖዋ ዓሶይዳፓ ኬሱ''ዋቴ፤ ዒንሢ ጉሪ ዔኬ ባኮ ዬያ ዓሶም ጉሪ ዒንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ዎርቄታቴያ ቢራ ሃሣ ሞኦኖ ዓንጎዋ ቡራሻይዳ ዓጊ ዔኪፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ጋላ ዓርቆ ሉካንታ ቃሲ'' ማይንቶ ዓፒላንታ ቃሲ'' ዓኣሦ ዱርሲ ሃሣ ኮኦሎ''ዋ ጎይፆሮ ዔኪፖቴ፤ ዓይጎሮ ጌዔቶ ማዻ ዓሲም ኮይሳ ሙኡዚ'' ዒንጊንታኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«ዒንሢ ጌላ ካታሞ ማዔቶዋ ጉርዶይዳ ዒ'ንሢ ሾኦቺንሢ ዎይሣኒ ጋዓ ዓሲ ዓኣቶ ዛጉዋቴ፤ ጴዼቶ ዬኖ ቤዞ ሃሺ'' ዒንሢ ኬስካንዳያ ሄላ''ንዳኣና ዒማካ ዴዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ዓሲ ማኣሪ ዒንሢ ጌላ ዎዶ''ና ‹ዓሲ ሙኬኔ፤ ኮሹሞ ሃኖ ማኣሮም ማዖም› ጎዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ማኣሮ ዓዴ ‹ኮሺዋይ› ጌዒ ዒንሢ ዔኬቴ፦ ‹ፆኦሲ ኮሹሞ ዒንሢም ማዖንጎ› ጎዑዋቴ፤ ዔኪባኣያ ማዔቶ ጋዓንቴ ዓቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ዒንሢ ሾኦቺንሢ ዔኪባኣቶ፥ ዒንሢ ጌዔ ባኮዋ ዋይዚባኣቶ ዬኖ ማኣሬሎና ካታሜሎናይዳፓ ኬስካዖ ቶኮ ሲላሎ ፒፂ'' ዓኣዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ጎኔ ታ ዒንሢም ጋዓኔ፦ ዓጮ''ይዳ ፆኦሲ ዎጋ ኬሎ''ና ዬኖ ካታሜሎም ሶዶሜና ጋሞራናም ዒንጊንቴ ሜታሢዳፓ ባሼ ሜታ ሄላ''ንዳኔ» ጌዒ ዓይሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ዬካፓ ዬሱሴ፦ «ዓካሪ ታ ዒንሢ ማራይጉዲ ያኣያሢ ባኣካ'' ዳካንዳሢሮ ሾኦሺጉዲ ጪንጫ፥ ዶኦሌ''ጉዲ ሼሌዔ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ዓሳ ዒንሢ ዎጌም ዓኣሢ ዒንጋንዳኔ፤ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ዒንሢ ጳርቆንዶኔ፤ ዬያሮ ኮሺ'' ዒንሢና ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ታ ዛሎ'' ማርካዻኒ ዎይሣ ዓሶና ካኣቶ''ና ቤርቶ ፑርታ ዎጌም ዒንሢ ሺኢካንዳኔ፤ ዔያቶና ዓይሁዴ ማዒባኣ ዓሶና ቤርታ ማርካ ዒንሢ ታኣኮ ማዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ዓሳ ዒንሢ ዎጌም ሺኢሻኣና ዒንሢ ኬኤዛንዳ ባካ ዬማ ዎዶ''ና ዒንሢም ኬኤዚንታንዳሢሮ ‹ዓይጎ ሃሣ ዎዚ ጌዒ ኑ ኬኤዛንዳይ?› ጌዒ ማሊ ሜታዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ዓይጎሮ ጌዔቶ ዒንሢ ዛሎ''ና ኬኤዛንዳሢ ዒንሢኮ ጫሪንጮ ዓዳሢ ዓያኖኬ፤ ዒንሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«ዓሲ ፔ ዓዶ ናዖ ሃይቃንዳጉዲ ዓኣሢ ዒንጋንዳኔ፤ ዬያጉዲ ዓዴያ ፔኤኮ ናዓ ሃይቃንዳጉዲ ዓኣሢ ዒንጋንዳኔ፤ ናኣታ'' ሾዔ ዓሶ ዑፃ ሞርኬ ማዒ ዔቂ ዎዺሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ዒንሢ ታ ዛሎ''ሮ ዓሲ ቢያና ዒፂንቴያ ማዓንዳኔ፤ ጋዓንቴ ዴንዲ ጋፒንፆ ሄላ''ንዳኣና ዶዴሢ ዻቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ፔቴ'' ቤዞይዳፓ ዒንሢ ዒፂ ዳውሶዋና ሜሌ'' ቤሲ ዓኣዹዋቴ፤ ጎኔ ታ ጋዓኔ፤ ዓሲኮ ናዓሢ ማዒ ሙካንዳያ ሄላ''ንዳኣና ዒስራዔኤሌ ካታሞም ዒንሢ ኬኤዚ ጋፒሳዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«ዔርዞሢ ዔርዛሢዳፓ ባሼቱዋሴ፤ ማዻሢያ ማዺሻሢዳፓ ባሼቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ዬያሮ ዔርዞሢ ዔርዛሢጉዲ፥ ማዻሢ ማዺሻሢጉዲ ማዔቴ ጊዳንዳኔ። ማኣሮ ዓዶም ‹ፑርቶ ዓያኖ ሱኡጋሢ› ጌዒ ሱ'ንሢ ዔያታ ጌሤቶ ማኣሮ ዓሶም ዬያፓ ዑሣ ፑርታ ሱ'ንሢ ጌሣዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ሃሣ ዬሱሴ፦ «ዓካሪ ዓሲ ዒጊጪፖቴ፤ ዓይጎሮ ጌዔቶ ዓኣቾና ባኣዚ'' ፔጋዹዋዖ፥ ዓኣሺንቴ ባኣዚ'' ዔርቱዋዖ ዓታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ዬያሮ ዹማ'' ዒንሢም ታ ኬኤዛሢ ፖዖይዳ ኬኤዙዋቴ፤ ካሽካሺ ዒንሢም ኬኤዚንቴሢ ዼ'ጌ ቤስካ ዔቂ ፔጌና ኬኤዙዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ዓሽኮ ዎዺ፥ ጊዴና ሼምፖ ዎዻኒ ዳንዳዑዋ ዓሶ ዒጊጪፖቴ፤ ዬያይዳፓ ሼምፓሢንታ ዓሽኮንታ ባይቁዋ ታሞይዳ ጌልዚ ባይዛኒ ዳንዳዓ ፆኦሲ ዒጊጩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ላምዖ ሱኡታ ባካናም ሻንቺንታኔ፤ ያዺ ማዔቶዋ ዒንሢኮ ጫሪንጮ ዓዳሢ ጌዒባኣንቴ ፔቴ'' ሱኡቶ''ማታዖ ጉሪ ዓቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ዒንሢኮ ጋዓንቴ ቶኦኮ'' ጋማኣ ፓይዲንቴያታሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ዒንሢ ዒጊጪፖቴ፤ ዓይጎሮ ጌዔቶ ሚርጌ ሱኡታይዳፓ ዒንሢ ባሼኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ዬሱሴ ሃሣ፦ «ዓሲ ቤርቲዳ ታ ዛሎ'' ማርካዻሢም ቢያ ታኣኒ ጫሪንጮይዳ ዓኣ ታ ዓዶ ቤርታ ዒዛ ዛሎ'' ማርካዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ዓሲ ቤርቲዳ ‹ታ ዒዛ ዔሩዋሴ› ጋዓሢ ታኣኒያ ጫሪንጮይዳ ታ ዓዶ ቤርታ ዒዛ ‹ዔሩዋሴ› ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«ታ ሃያ ዓጮ'' ዖልዚ ዔኪ ሙካንዳኣፓዓቴም ኮሹሞ ዔኪ ሙኬያ ዒንሢም ማሎፖ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ታኣኒ ሙኬሢ ዓቲንቆ ናዓሢ ዓዶ፥ ዉዱሮ ናዔላ ዒንዶ፥ ናኣዚ'' ማቻ ዓሆ ዒፃንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ዬያሮ ማኣሮ ዓሳ ዎሊኮ ሞርኬ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«ታጊዳፓ ባሼ ፔኤኮ ዓዶ፥ ዒንዶ ናሽካ ዓሲ ታኣም ማዓዓኬ፤ ታጊዳፓ ባሼ ፔኤኮ ዓቲንቆ ናዖ ሃሣ ዉዶሮ ናዖ ናሽካሢ ታኣም ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ታጋቴ ሃይቃኒ ማሊ ታ ጊንፆ ሃንቱዋ ዓሲ ታኣም ማዓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ፔ ናንጎ ዓይሳኒ ኮዓ ዓሲ ቢያ ፔኤኮ ናንጎ ባባይዛንዳኔ፤ ታ ዛሎ''ሮ ጌዒ ፔ ናንጎ ባይዛሢ ጋዓንቴ ቢያ ፔኤኮ ናንጎ ዓዓይሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«ዒንሢ ሾኦቺንሢ ዔካሢ ታና ዔካኔ፤ ታና ዔካሢያ ታና ዳኬ ታ ዓዶ ዔካኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ፆኦሲ ማሊፆ ኬኤዛሢ፡ ዬያ ሱ'ንፆና ሾኦቺንሢ ዔካሢ ዬያም ዒንጎ ባኮ ዴንቃንዳኔ። ፂላ''ሢ፡ ፂሉ''ሞ ሱ'ንፆና ሾኦቺንሢ ዔካሢ ፂላ''ሢም ዒንጎ ባኮ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ጎኔ ታ ዒንሢም ጋዓኔ፤ ታኣኮ ጊንፆ ሃንታያ ማዔ፥ ሃንሢ ዻኮ''ንሢዳፓ ፔቴ''ማ ዋኣሢ ሺሜ ዑሻ''ሢ ዔኤቢ ዴንቁዋዖ ዓታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ዬሱሴ ዬያ ባኮ ታጶ ላምዖ ዒዛኮ ጊንፆ ሃንታዞንሢም ኬኤዜሢኮ ጊንፃ ዬኖ ቤዞ ሃሺ'' ኮይሎ''ይዳ ዓኣ ካታሞንሢዳ ቃኣሎ'' ኬኤዛኒና ዔርዛኒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ማስካ ዮሓኒሴ ቱኡዞ ማኣራ ቱኡቲ ዓኣዖ ኪሪስቶሴ ማዻ ባኮ ዋይዜኔ፤ ዬያሮ ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ዬሱሴ ኮራ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«ሙካንዳኔ ጌይንታ ሜሲሔ ኔናሞ ሜሌ'' ኑ ካፖንዶይ?» ጌዒ ዖኦጫንዳጉዲ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ዬሱሴ ዔያቶም፦ «ዴንዲጋፓ ዒንሢ ዛጌ ባኮና ዋይዜ ባኮና ቢያ ዮሓኒሴም፦ ");
INSERT INTO mdybse_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ዓኣፓ ባይቄ ዓሳ ዛጋኔ፥ ሃንቶ ባሺንታ ዎቦ ዓሳ ሃንታኔ፥ ዑፃ ኬስካ ዶርዓሢ ዓኣ ዓሳ ፖዓኔ፥ ዋዮ ባይቄ ዓሳ ዋይዛኔ፥ ሃይቄ ዓሳ ሃይባ''ፓ ዔቃኔ፥ ማንቆ ዓሶማኣ ኮዦ ሃይሳ ኬኤዚንታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ታና ‹ዒዛ ናንጋዓ› ጌዒ ዻቢንቱዋኣሢ ጋላቲንቴያኬ ጌዒ ኬኤዙዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ዮሓኒሴ ኮራፓ ሙኬ ኪኢቶ'' ዓሶንሢ ማዒ ዴንዳዛ ዬሱሴ ዮሓኒሴ ዛሎ'' ዴሮ''ም፦ «ዒንሢ ሃሢ ዓይጎ ዛጋኒ ዓሲ ናንጉዋ ዳውሎ'' ሙኬይ? ዢባራ ዓጊሣ ፒሎ'' ዛጋኒዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ሜሌ'' ዒንሢ ዓይጎ ዛጋኒ ሙኬይ? ሚዛጶ ቦኦሬ ዓፒሎ ማይንቴ ዓሶ ዛጋኒዳ? ሚዛጶ ቦኦሬ ዓፒሎ ማኣዔ ዓሳ ካኣቶ'' ማኣራ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ሂዳዖ ዒንሢ ዓይጎሮ ሙኬይ? ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ዛጋኒዳ? ሂዮ! ዬያ ፆኦሲ ማሊፆ ኬኤዛሢዳፓ ባሼሢ ዛጋኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ዒዚ ‹ኔኤኮ ቤርታ ቤርታ ዓኣዺ ጎይፆ ኔኤኮ ጊኢጊሻንዳ ታኣኮ ኪኢቶ'' ናዓሢ ኔኤኮ ቤርታ ታ ዳካንዳኔ› ጌይንቲ ፃኣፒንቴሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓጮ''ይዳ ሾይንቴ ዓሶይዳ ቢያ ማስካ ዮሓኒሴይዳፓ ባሼ ባኣሴ። ጋዓንቴ ፆኦሲ ካኣቱሞይዳ ቢያይዳፓ ሂርኬ ማዔሢ ዒዛይዳፓ ባሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ማስካ ዮሓኒሴ ዎዶ''ይዳፓ ሃኖ'' ሄላ''ንዳኣና ፆኦሲ ካኣቱማ ዎልቄና ዳልጊ ዳልጊ ዓኣኔ፤ ዓካሪ ሚርጌና ዒዞሮ ሜታዻዞንሢ ዒዞ ዴንቃንዳኔ» ጌዒ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ሓሣ ዬሱሴ፦ «ፆኦሲ ማሊፆ ኬኤዛ ዓሶና ሙሴ ዎጎና ሙኪ ማስካ ዮሓኒሴ ሄላ''ንዳኣና ፆኦሲ ካኣቱሞ ዛሎ'' ኬኤዚ ኬኤዚ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ዓካሪ ዔያታ ኬኤዜ ባኮ ዒንሢ ዋይዛኒ ኮዔያታቶ ዬይ ሙካንዳኔ ጌይንቴ ዔኤሊያሴ፥ ሃይሾ ሃያ ዮሓኒሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ዋይዛ ዋይዚ ዓኣሢ ዋይዞንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ሃሣ ቃሳ''ዖ፦ «ሃያ ዎዶ'' ዓሳ ዓይጎ ማላኔ ታ ጋዓንዳይ? ዞኦዛ ቡኪንቲ ዴዒ ናኣታ'' ፔኤኮ ላጎ ዔኤሊ'' ዔኤሊ''፥ ");
INSERT INTO mdybse_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹ዎዛሳ ኮሢ ዒንሢም ኑ ኮርጌኔ፤ ዒንሢ ጋዓንቴ ሶኦሪባኣሴ፤ ሃሣ ቃዮ ዒንሢም ኑ ቃዬማኣ ዒንሢ ዬኤኪባኣሴ› ጋዓሢ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ማስካ ዮሓኒሴ ሙኡዚ'' ሙዑዋዖ ሃሣ ዑሽኩዋዖ ሙካዛ ‹ሃያይዳ ፑርታ ዓያና ዓኣኔ!› ዔያታ ጌዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ዓሲኮ ናዓሢ ሓሣ ሙዒ ዑሽኪ ዑሽኪ ሙካዛ፥ ‹ሓሣ ሃይ ሙኡዚ''ና ዑሺና ናሽካያኬ፤ ሚኢሾ ቡኩሳ ዓሶና ጎሞ ዓሶናኮ ላጌኬ!› ዔያታ ጌዔኔ። ያዺ ማዔቴያ ዔራቶኮ ጎኑማ ፔ ማዾ''ና ፔጋዺ ዔርታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ዬካፓ ሃሣ ዬሱሴ ሃንጎ ካታሞይዳፓ ባሼና ሚርጌ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዺንቴ ካታሞንሢ' ጎሞ ፔኤሲ'' ቡኡፂባኣሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«ኮራዚኔ ኔና ባዴዔ! ሃሣ ቤቴሳይዳ ኔና ባዴዔ! ዒንሢዳ ማዺንቴ ፆኦሲ ዎልቆና ማዺንታ ዓኮ ባካ ፂሮሴና ሲዶና ካታሞናይዳ ማዺንቴቴ ሄኤዶ ዔያታ ሲዬ ፓቲሌ ቱኪ'' ቶኦካ'' ቢዲንሢ ዋሂንቲ ጎሞ ፔኤኮ ቡኡፄያ ናንዳንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ዬያሮ ዓጮ''ይዳ ፆኦሲ ዎጋ ኬሎ''ና ዒንሢዳፓ ፂሮሴና ሲዶናናም ሄላ''ንዳ ሜታሢ ሼሌዔ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ሓና ኔ ቂፒርናሆሜ! ጫሪንቺ ሄላ''ኒ ኔ ኮይባይ? ጋዓንቴ ፆኦሲ ኔና ጋኣናኣሜ ታሞ''ይዳ ጌልዛንዳኔ፤ ኔጊዳ ማዺንቴ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባካ ዎንዴ ሶዶሜይዳ ማዺንቴያታቴ ዬና ካታሜላ ሃኖ'' ሄላ''ንዳኣና ዓኣያ ናንዳንዳቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ዬያሮ ጎኔ ታ ኔኤም ጋዓኔ፤ ጋፒንፆ ዎጎ ኬሎ''ና ኔጊዳፓ ሶዶሜ ካታሞም ዒንጊንታንዳ ሜታሢ ሼሌዓንዳኔ» ጌዒ ቦሂሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ዒማና ዬሱሴ፦ «ጫሪንጮና ሳዖናኮ ጎዳ ማዔ፥ ታ ዓዳሢዮ! ሃያ ባኮ ዔሮ'' ዓሶይዳፓ ዓኣቺ ዔኤቢ ዔሩዋ ዓሶም ኔ ፔጋሲ ዔርዜሢሮ ታ ኔና ጋላታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ሂዮ! ታ ዓዳሢዮ! ኔ ዬያይዳኒ ኔ ማሊፆጉዴያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ታ ዓዴ ቢያ ባኮ ታኣም ዒንጌኔ፤ ዓዶይዳፓ ዓታዛ ናዓሢ ዔራይ ዖኦኒያ ባኣሴ። ዬያጉዲ ሃሣ ናዓሢዳፓ ዓታዛ ዓዶ ዔራያ ባኣሴ፤ ናዓ ዔርዛኒ ኮዒባኣያታቶ ዖኦኒያ ዓዶ ዔራኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ሃሣ ዬሱሴ፦ «ዒንሢ ኬዳ'' ዴኤፄም ላቢንቴዞንሢ ቢያ ሃኒ ታ ባንሢ ሙኩዋቴ! ታ ዒንሢ ሃውሺሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ታ ቃንባሮ ኬዱዋቴ፥ ታ ማዻ ባኮ ታጊዳፓ ዛጊ ማዹዋቴ፤ ታኣኒ ሼሌዔ ሃሣ ሚጪንታያኬ፤ ዒንሢ ሃውሾ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ታ ቃንባራ ባቃኖ'' ዔኩዋያ፤ ኬዳ''ኣ ሃሣ ታኣኮ ሼሌዔኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ዬያኮ ጊንፃፓ ዬሱሴ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ፔቴ'' ዛርጎ ጎሺ ጊዴና ዓኣዻንቴ ዒዛኮ ጊንፆ ሃንታዞንሢ ናይዺንቴሢሮ ዛርጎ ቲሻሢ ዱኡዚ ዱኡዚ ዔኪ ዻዒሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ፔርሴ ዓሳ ዬያ ዛጋዖ ዬሱሴ ኮራ፦ «ሃኣዛጌ፤ ኔኤኮ ጊንፆ ሃንታዞንሢ ሃውሾ ኬሎ''ና ዓይሢንቲባኣ ባኣዚ'' ማዻኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ዬሱሴ ማሃዖ፦ «ዳውቴና ዒዛና ዎላ'' ዓኣ ዓሳ ናይዺንቴ ዎዶ''ና ዳውቴ ማዼ ባኮ ፔቴ''ታዖ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ዒዚ ዒማ''ና ጌኤዦ ማኣሪ ጌሊ፥ ቄኤሶይዳፓ ዓታዛ ዒዛንታ ዒዛና ዎላ'' ዓኣ ዓሶንታ ሙዓኒ ዳንዳዑዋ ፆኦሲም ዱማዼ ካሦ ሙዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ሃሣ ቄኤሳ ሃውሾ ኬሎ''ና ጌኤዦ ማኣሮይዳ ሃውሾ ኬሎ'' ሻቲ ማሂ ማዼቶ ዻቢንቲ ማዒ ፓይዲንቱዋሴ ጌይንቲ ሙሴ ዎጎይዳ ፃኣፒንቴሢ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ጋዓንቴ ጌኤዦ ማኣሮይዳፓ ባሻይ ሃይካ ዓኣኔ፤ ታ ዒንሢም ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ሃሣ ‹ታኣኒ ኮዓሢ ዓሲ ሚጪንቲሢ ማዓንዳኣፓዓቴም ታኣም ሹኪ ዒንጎ ባኣዚ''ቱዋሴ› ጋዓ ማፃኣፖ ቃኣላ'' ዎዚ ጌይሢታቶዋ ዒንሢ ዔራያታቶ ዻቢንቲባኣ ዓሶ ዑፃ ‹ዔያታ ዻቤኔ› ጌይ ዎጋዓታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ዓይጎሮ ጌዔቶ ዓሲኮ ናዓሢ ሃውሾ ኬሎ''ኮዋ ጎዳኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ዬሱሴ ዬኖ ቤዞይዳፓ ዔቂ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ጌሌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ዒኢካ ፔቴ''፥ ኩቺ ዎቦ ዓሲ ዓኣኔ፤ ዒማ''ና ዬሱሴ ዎጎና ዓይሢሳኒ ኮዓ ፔቴ'' ፔቴ'' ዓሳ፦ «ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ሃርጊንቴ ዓሶ ፓሣኒ ዓይሢንቴያዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ዬሱሴያ ማሃዖ፦ «ዒንሢ ባኣካ''ፓ ፔቴ'' ማራይ ዓኣ ዓሲ ማራዓሢ ሃውሾ ኬሎ''ና ዔቴይዳ ሎኦሜቶ ጎቺ ኬሱ''ዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ዓካሪ ያዺ ማዔቶ ዓሲ ማራይዳፓ ዎይቲ ባሹዋይ? ዬያሮ ሃውሾ ኬሎ''ና ኮሺ ማዾ ማዺሢ ዓይሢንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ዬካፓ ዬሱሴ ኩጮ ዎቦ ዓሢም፦ «ኩጮ ኔኤኮ ፒሼ!» ጌዔም ዒዚ ፒሻዛ ኩጫ ኮሽኪ ባጎ ኩጮጉዲ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ፔርሴ ዓሳ ጋዓንቴ ዬካፓ ኬስካዖ ዬሱሴ ዎማይዲ ዔያታ ዎዻንዳቴያ ዎላ'' ዞርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ዬማ''ና ዬሱሴ ዔያቶኮ ማሊፆ ዔራዖ ዒኢካፓ ዴንዳዛ፥ ሚርጌ ዴሬ ዒዛ ጊንፆ ዓኣዼኔ፤ ዬያ ዓሶፓ ሃርጊንቴ ዓሶ ቢያ ዒ ፓሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ዒዛኮ ዖኑሞ ዖኦማኣ ዔያታ ኬኤዙዋጉዲ ዔያቶ ላኣጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ዬይ ያዺ ማዔሢ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፦ ");
INSERT INTO mdybse_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«ሃይሾ ታ ዶኦሬ፥ ታ ዒዛ ናሽካያ ሃሣ ታና ዎዛሳ ታኣም ማዻሢዳ ታ ዓያኖ ዒዛ ዑፃ ታ ማሃንዳኔ፤ ዒዚ ዓሲ ዜርሢም ቢያ ታኣኮ ፒዜ ዎጊፆ ዔርዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ዒዚ ማርሚ ዒላታዓኬ፤ ጎይፆይዳኣ ዑኡዞ ዋይዚሳዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ቱቄ ፒሎ''ዋ ዒ ሜንሣዓኬ፤ ዜኤሮ ታሞዋ ዎዻዓኬ። ጎኑሞ ባሻንዳያ ሄላ''ንዳኣና ዬያ ዒ ማዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ዓሲ ዜርሢያ ዒዛይዳ ሃጊ ማዓንዳ ዎዛ ጌሣንዳኔ» ጌይንቴሢ ኩማ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ዬካፓ ፑርታ ዓያና ዓርቄም ዛጋኒና ጌስታኒያ ዳንዳዑዋ ፔቴ'' ዓሲ ዓሳ ዬሱሴ ባንሢ ዔኪ ሙኬኔ። ዬሱሴያ ዒዛ ፖዒሳዛ ዓሢ ዛጋኒና ጌስታኒያ ዳንዳዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ዒማ''ና ዴራ'' ቢያ ዲቃቲ ሄርሻዖ፦ «ሓይ ዳውቴ ናዓሢ ማዓንዳሞ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ጋዓንቴ ፔርሴ ዓሳ ዬያ ዛጌ ዎዶ''ና፦ «ሃይ ዓሢ ፑርቶ ዓያኖ ኬሳ''ሢ ፑርቶ ዓያኖ ሱኡጋሢ ቢዔልዛቡሌ ዎልቆና ማዓንዳኣፓዓቴም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ዬሱሴ ዔያቶኮ ማሊፆ ዔራዖ፦ «ፔቴ'' ማዒባኣ ካኣቶ'' ዓጪ ቢያ ላባ''ኔ፤ ዎላ'' ፔቴ'' ማዒባኣ ካታማታቶዋ ማኣሪ ዶዱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ፃላሄ ፃላሄ ኬሳ''ያ ማዔቶ ዎሊፓ ዱማዼኔ ጌይሢኬ፤ ያዺ ማዔቶ ካኣቱማ ዎይቲ ዶዳኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ታኣኒ ፑርቶ ዓያኖ ኬሳ''ሢ ዔያቶኮ ሱኡጋሢ ቢዔልዛቡሌና ማዔቶ ዒንሢኮ ናኣታ'' ዓይጎና ፑርቶ ዓያኖ ኬሳ''ይ? ዬያሮ ዒንሢ ናኣታ'' ዒንሢዳ ዎጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ጋዓንቴ ፑርቶ ዓያኖ ታ ኬሳ''ሢ ፆኦሲ ዓያኖና ማዔቶ ፆኦሲ ካኣቱማ ዒንሢ ኮራ ሙኬኔ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ዬሱሴ ሃሣ፦ «ፔቴ'' ዓሲ ፔቴ'' ዎልቄና ዓኣ ዓሲ ቤርታዺ ቱኩ''ዋዖ ዎልቆና ዓኣ ዓሢ ማኣሪ ጌሊ ዓኣ ባኮ ቡራኒ ዎይቲ ዳንዳዓንዳይ? ዎልቆሲ ቱኬ''ሢኮ ጊንፃ ዒዛኮ ዓኣ ባኮ ቡራኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«ታ ዓሲ ማዒባኣሢ ቢያ ታና ዒፃኔ፤ ታኣና ዎላ'' ማዒ ዔኤቢ ቡኩሲባኣ ዓሲ ላኣላያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ዬያሮ ዓሲ ማዻ ዓይጎ ዻቢንቲ ማዔቶዋ፥ ጫሺ ቢያ ዒዛም ዓቶም ጌይንታንዳኔ፤ ታ ዒንሢም ጋዓኔ። ዓያና ጌኤሺ ጫሽካ ዓሲም ጋዓንቴ ዻቢንታ ዓቶም ጌይንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ዓሲ ናዓሢ ጫሽካሢም ቢያ ዻቢንታ ዓቶም ጌይንታንዳኔ፤ ዓያና ጌኤሺ ጫሽካሢም ቢያ ጋዓንቴ ሃያ ዓጮ''ይዳ ማዔቶዋ ሃጋኣ ዓጮ''ይዳ ዻቢንታ ዓቶም ጌይንቲንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ዬሱሴ ሃሣ፦ «ሚሢ ቢያ ዓኣፓፓ ዔርታሢሮ ዒንሢኮ ኮሺ ሚሢ ዓኣቶ ኮሺ ዓኣፒ ዒንሢ ዴንቃንዳኔ፤ ፑርታ ሚሢ ዒንሢኮ ዓኣቶ ጋዓንቴ ፑርታ ዓኣፒ ዒንሢ ዴንቃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ዒንሢ ሃይ ሾኦዦ ናኣታ''! ዒንሢ ፑርታታዖ ኮሺ ባኣዚ'' ኬኤዛኒ ዎይቲ ዳንዳዓይ? ዓይጎሮ ጌዔቶ ዓሲ ኬኤዛ ባካ ዓሢኮ ዒኖይዳፓ ኩሚ'' ኬስኬሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","«ኮሺ ዓሲ ዒና'' ዓኣ ኮሹሞይዳፓ ኮሺ ባኣዚ'' ጌስታኔ፤ ፑርታ ዓሲ ፔኤኮ ዒና'' ዓኣ ፑርቱሞይዳፓ ፑርታ ባኣዚ'' ጌስታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ጋዓንቴ ታ ዒንሢም ጋዓኔ፤ ዓሳ ኮይሱዋ ባኮ ጌስቴሢ ዛሎ'' ቢያ ዓጮ''ይዳ ፆኦሲ ዎጋ ኬሎ''ና ዖኦጪንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ዬይ ያዺ ማዓዛ ኔ ኮሺ ጌስቴቴ ኮሺ ባኣዚ'' ኔኤም ዎጊንታንዳኔ፤ ኔኤኒ ፑርታ ጌስቴቴ ፑርታ ኔጊዳ ዎጊንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ዒማ''ና ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶና ዬሱሴ ኮራ፦ «ዔርዛሢዮ፤ ኔኤኒ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዻንቴ ኑ ዛጋኒ ኮዓኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ዒዚ ጋዓንቴ ዔያቶም፦ «ፑርታ ሃሣ ጉሙርቂንቱዋ ሃያ ዎዶ'' ዓሳ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ዛጋኒ ኮዓኔ፤ ጋዓንቴ ፆኦሲ ማሊፆ ኬኤዛሢ፥ ዮናኣሴይዳ ማዺንቴ ዓኮ ባካፓ ዓታዛ ሜሌ'' ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ዔያቶም ማዺንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናኣሴ ዼኤፖ ሞላሢ ጎጳ ሃይሦ ኬሊ'' ዋንቴና ሮኦሪና ዴዔሢጉዲ ዓሲኮ ናዓሢ ዱኡፒዳ ሃይሦ ኬሊ'' ሮኦሪና ዋንቴና ዴዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ኔኔዌ ካታሞ ዓሳ ዓጮ''ይዳ ፆኦሲ ዎጋ ኬሎ''ና ሃያ ዎዶ'' ዓሶይዳ ዎጋያ ማዓንዳኔ፤ ዓይጎሮ ጌዔቶ ኔኔዌ ዓሳ ዮናኣሴ ኬኤዜሢ ዋይዜ ዎዶ''ና ዻቢንቶ ዔሪ፥ ጎሞዋ ቡኡፄሢሮኬ። ያዺ ማዔቶዋ ሃሢ ዮናኣሴይዳፓ ባሼ ሃይካ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ዓጮ''ይዳ ፆኦሲ ዎጋ ኬሎ''ና ሳኣባ ዓጮ'' ካኣቴላ ሃያ ዓሶ ዑፃ ዎጋንዳኔ፤ ዓይጎሮ ጌዔቶ ዒዛ ካኣቲ ሴሎሞኔኮ ዔራቶ ዋይዚ ዓጪ ዙልካፓ ሙኬያታሢሮኬ፤ ያዺ ማዔቶዋ ሴሎሞኔይዳፓ ባሼ ሃይካ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ዬሱሴ ሃሣ፦ «ፑርታ ዓያና ዓሲዳፓ ኬስኬ ዎዶ''ና ጌላንዳ ቤሲ ኮይ ኮይ ዋኣሢባኣ፥ ዓሲ ናንጉዋ ዳውሎ''ይዳ ሃንታኔ። ጋዓንቴ ጌሎንዶ ቤሲ ዴንቁዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ዬያሮ ‹ታ ኬስኬ ማኣሮ ማዒ ዓኣዻንዳኔ› ጋዓኔ። ማዒ ዒ ሙካ ዎዶ''ና ኬኤፃ ጉሪ ማዒ፥ ጌኤሽኪ፥ ጊኢጊ ዓኣንቴ ዴንቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ዬካፓ ፑርቶ ዓያና''ሢ ዓኣዺ ዒዛይዳፓ ባሼ ፑርታ ሜሌ'' ላንካይ ፑርታ ዓያና ቡኩሲ ዔኪ ሙኪ ዒዚ ቤርታ ዓኣ ዓሢዳ ጌሊ ዎላ'' ናንጋኔ፤ ዬያሮ ዬያ ዓሢኮ ጋፒንፆ ናንጋ ቤርታኣስካፓ ባሼ ፑርታ ማዓኔ። ሃያ ዎዶ'' ፑርቶ ዓሶ ዑፃ ማዓንዳ ባካ ዬያ ማላ ባኣዚ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ዬሱሴ ዴሮ''ም ኬኤዛ ጎይሣ ዓኣንቴ ዒዛኮ ዒንዶና ጌርሲንሢና ዒዛና ጌስታኒ ኮዒ ካራ'' ሙኪ ዔቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ዒማ''ና ዒኢካ ዓኣ ዓሶይዳፓ ፔቴ''ስኬይ ዬሱሴ ኮሮይዳ፦ «ሃይሾ ኔኤኮ ዒንዶና ጌርሲንሢና ኔና ኮዒ ካራ'' ዔቂ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ዬሱሴ ጋዓንቴ፦ «ዒንዳ ታኣኮ ዖናዳይ? ጌርሲንሢያ ዖናንሢዳይ?» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ዬያ ጌዔስካፓ ኩጮና ዒዛኮ ጊንፆ ሃንታ ናኣቶ'' ባንሢ ዻዊ ዻዊ፦ «ታኣኮ ዒንዶና ጌርሲንሢና ሃይሾ ሃኣቶኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ጫሪንጮይዳ ዓኣ፥ ታ ዓዳሢ ዓይሢፆ ኩንሣዞንሢ ቢያ ታኣኮ ጌርሲንታ ጌሮንታ ዒንዶንታ ዬያቶኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ዬኖ ኬሎ'' ዬሱሴ ጋራፓ ኬስኪ ባዞ'' ዓጫ ዴዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ሚርጌ ዴሬያ ዒዛ ኮይላ'' ሙኪ ቡኬሢሮ ዋኣፆና ፒንቆ ጎንጎይዳ ኬስኪ ዴዔኔ፤ ዴራ'' ጋዓንቴ ቢያ ባዞ'' ዓጫ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ዬካ ዒ ሚርጌ ባኣዚ'' ኮኦኪንሢና ኬኤዛዖ፦ «ፔቴ'' ዓሲ ጎሺዳ ዜርሢ ዜርቃኒ ኬስኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ዒዚ ዜርቃንቴ ፔቴ'' ፔቴ'' ዜርፃ ጎይፆ ዓጫ ኬዳ''ዛ ካፓ ሙኪ ሙዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ዓቴ'' ዜርፃ ሚርጌ ዓጪባኣ፥ ሃኣሻ ቤሲዳ ኬዴ''ኔ፤ ዬኖ ቤዛ ሚርጌ ዓጪ ባኣሢሮ ዜርፃ ዑኬና ባቃሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ማዔቶዋ ሳዓ ዓባዛ ሹሌ''ኔ፤ ፃጲ ሚርጌ ዳኪባኣሢሮዋ ሜሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ዓቴ'' ዜርፃ ሃሣ ዓንጊሢ ቶሻ ባኣካ ኬዴ''ኔ፤ ዓንጊፆ ቶሻ'' ዑጋዖ ባቃሎ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ሃሣ ዓቴ'' ዜርፃ ኮሺ ቤስካ ኬዲ'' ባቃሌ ዎዶ''ና ሚርጌ ካፄኔ፤ ፔቴ''ዛ ፄኤታ ባጌላ ላሂ''ታሚ'' ዓቴ''ዛ ሃይሢታሚ'' ዓኣፒ ዓኣፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ዬያ ዋይዛ ዋይዚ ዓኣሢ ዋይዞንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ዬካፓ ዒዛኮ ጊንፆ ሃንታዞንሢ ዬሱሴ ኮራ ሙካዖ፦ «ዓይጎሮ ዴሮ''ም ኔ ኮኦኪንሢና ኬኤዛይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ዒዚ ዔያቶም፦ «ዒንሢም ጫሪንጮ ካኣቱሞ ዛሎ'' ዓኣሺንቴ ባኮ ዛላ ዔራኒ ዔራቶ ፆኦሲዳፓ ዒንጊንቴኔ፤ ዔያቶም ጋዓንቴ ዒንጊንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ዔኤቢ ዓኣሢም ቃሲ'' ዒንጊንቴም ሚርጋንዳኔ፤ ዻካ'' ዓኣሢዳፓ ጋዓንቴ ዒማ'' ዻኮ'' ዓኣማታዖ ዔኪንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ዛጋዖ ዴንቁዋያ፥ ዋይዛዖ ዒና ዔኩዋያ ሃሣ ጶቂሱዋያ ማዔሢሮ ዔያቶም ታ ኮኦኪንሢና ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ዬይያ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፦ ‹ዋይዚ ዒንሢ ዋይዛኔ ጋዓንቴ ዒንሢ ጶቂሡዋሴ፤ ዛጊያ ዒንሢ ዛጋኔ ጋዓንቴ ዒንሢ ዒና ዔኩዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ዓይጎሮ ጌዔቶ ሃይ ዴራ'' ዒኖ ፔኤሲ'' ዶጪሴኔ፤ ዋዮዋ ዔያታ ዓርቄኔ፤ ዓኣፖዋ ዱኡሜኔ። ያዺ ማዒባኣያታቴ ዓኣፖና ዔያታ ዛጊ ዋዮና ዋይዚ ዒኖና ማሊ ታ ባንሢ ዔያታ ማዔም ሄኤዶ ታ ዔያቶ ዻቂሼያ ናንዳንቴኬ› » ጌይንቲ ኬኤዚንቴሢ ዔያቶይዳ ኩማ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ዬሱሴ ሃሣ፦ «ዒንሢ ጋዓንቴ ዓኣፓ ዒንሢኮ ዛጋሢሮ፥ ዋያኣ ዒንሢኮ ዋይዛሢሮ ዒንሢ ባሊቲና ዓኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ጎኔ ታ ዒንሢም ጋዓኔ፤ ሚርጌ ፆኦሲ ማሊፆ ኬኤዛዞንሢና ፂሎ''ንሢና ዒንሢ ሃሢ ዛጋሢ ዛጋኒ ኮዔያታዖ ዛጊባኣሴ። ዒንሢ ዋይዛሢ ዔያታ ዋይዛኒ ኮዔያታዖ ዋይዛኒ ዳንዳዒባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ዬካፓ ዬሱሴ፦ «ዓካሪ፥ ዒንሢ ዜርፆኮ ኮኦኪንሦ ቡሊ''ፆ ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ጎይፆ ዓጫ ኬዴ'' ዜርፃ ዻዋሢ፦ ፆኦሲ ካኣቱሞ ቃኣሎ'' ዋይዚ ዒና ዔኩዋ ዓሶኬ፤ ቤዞና ፃላሄ ሙኪ ዒና'' ዜርቂንታ ቃኣሎ'' ዔካኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ሃኣቾ ሳዖይዳ ዜርቂንቴ ዜርፄላ ዻዋሢ፦ ቃኣሎ'' ዋይዛዖ ዎዛና ጉሙርቂ ዔካ ዓሶኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ማዔቶዋ ዻካ'' ዎዴሮ ማዓንዳፓዓቴም ፃጲ ዔያቶኮ ባኣሴ፤ ዬያሮ ቃኣሎ'' ዛሎ''ና ሜቶና ዒፂንቲ ዳኪንቲሢ ሄሌ'' ዎዶ''ና ዑኬና ዔያታ ዻቢንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ዓንጊፆ ቶሾ'' ባኣካ'' ዜርቂንቴዛ ዻዋሢ፦ ቃኣሎ'' ዻካ'' ዎዴሮ ዋይዛ ዓሶኬ፤ ያዺ ማዔቶዋ ሃያ ዓጮ'' ዛሎ'' ማሊ ሜታዺሢና ቆሎ'' ናሹሞና ዒና'' ጌሊ ቃኣሎ'' ዋሊ''ሳሢሮ ዓኣፑዋዖ ዓታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ኮዦ ሳዖይዳ ዜርቂንቴዛ ዻዋሢ፦ ቃኣሎ'' ዋይዚ ዒና ዔካ ዓሶኬ፤ ዬያታ ዓኣፒ ዓኣፓኔ፤ ፔቴ''ዛ ፄኤታ፥ ባጌላ ላሂ''ታሚ'' ዓቴ''ዛ ሃይሢታሚ'' ዓኣፓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ዬያጉዲ ሃሣ ዬሱሴ ሜሌ'' ኮኦኪንሢ፦ «ጫሪንጮ ካኣቱማ ጎሺዳ ጌኤሺ ዜርሢ ዜርቄ ዓሲ ማላኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ዓሳ ቢያ ላሄ ዎዶ''ና ሞርኬ ሙካዖ ባርቾ ባኣካ'' ዓዦ ዜርቂ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ባርቻ ባቃሊ ፑርቃዛ ዓዣሢ ባኣካ'' ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ዬያሮ ጎዦ ዓዶኮ ማዻ ዓሳ ዒዛ ኮይላ'' ሙካዖ ‹ጎዳሢዮ! ኔ ጎዦይዳ ጌኤሺ ዜርሢ ኔ ዜርቂባኣዓዳ? ሂዳዖ ዓዣሢ ዓንካፓ ኬስኬይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ዒዚ ማሃዖ ‹ሃያ ማዼሢ ሞርካሢዋይ!› ዔያቶም ጋዓዛ፥ ማዻ ዓሳ ‹ሂዴቴ ዴንዲ ኑ ዓዣሢ ሃርማንዳጉዲ ኔ ኮዓ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ዒዚ ጋዓንቴ ‹ዔይዔ! ዓይጎሮ ጌዔቶ ዓዣሢ ዒንሢ ሃርማ ዎዶ''ና ባርቾ ዎላ'' ቱጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ዬያሮ ሃሹ''ዋቴ፤ ባርቻ ማንፂንታ ዎዶ'' ሄላ''ንዳኣና ባርቾንታ ዓዣሢንታ ዎላ'' ዑጎንጎ፤ ማንፂንታ ዎዶ''ና ጋዓንቴ ማንፃ ዓሶም ዓዣሢ ቤርታዺ ቱጊ ታሚና ሚቺንታንዳጉዲ ናኣራ ናኣራ ቱኩ''ዋቴ፤ ባርቾ ጋዓንቴ ማንፂ ታኣኮ ኮኖይዳ ዋሁዋቴ› ሂዚ ታ ጋዓንዳኔ» ጌዒ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ዬሱሴ ሃሣ ሜሌ'' ኮኦኪንሢ፦ «ጫሪንጮ ካኣቱማ ፔቴ'' ዓሲ ጎሺዳ ዜርቄ፥ ሴናፒጬ ጌይንታ ዻኮ'' ዜርፄሎ ማላኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ዒዛ ዜርሢዳፓ ቢያ ዻካ''ኬ፤ ባቃሊ ዑጌ ዎዶ''ና ጋዓንቴ ቱኮ''ና ሚፆይዳፓ ቢያ ባሼ፥ ዼኤፒ ሚሢ ማዓኔ፤ ሃሣ ካፓኣ ዒዞኮ ካኣፖይዳ ማኣሪ ማዢ ዴዓኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ሃሣ ዔያቶም ዬሱሴ፦ «ጫሪንጮ ካኣቱማ ፔቴ'' ላኣሊ ሃይሦ ሻምባ ዲርኮና ዺኢሊዳ ዋሃ ሙኑቃ ፃኣዛ ማላኔ፤ ዬና ሙኑቆ ፃኣዛ ሙኑቆ ቢያሢ ዔቂሳኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ዬሱሴ ዬያ ባኮ ቢያ ኮኦኪንሢና ዴሮ''ም ኬኤዜኔ፤ ኮኦኪንሢ ባኣያ ዓይጎ ባኣዚ''ያ ዔያቶም ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ዬይ ያዺ ማዔሢ፦ «ሃይሶ ታኣኮ ታ ኮኦኪንሢና ኬኤዛንዳኔ፤ ዓጫ'' ማዢንቴሢዳፓ ዓርቃዖ ዓኣሺንቴ ባኣዚ'' ታ ኬኤዛንዳኔ» ጌይንቲ ፆኦሲ ማሊፆ ኬኤዛሢ ዛሎ''ና ፃኣፒንቴሢ ኩማ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ዬካፓ ዬሱሴ ዴሮ'' ሃሺ'' ኬኤፆ ጌሌኔ፤ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ኮራ ሙኪ፦ «ጎዦኮ ዓዣሢ ኮኦኪንሦ ቡሊ''ፆ ኑም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ዬሱሴ ማሃዖ፦ «ጌኤዦ ዜርፆ ዜርቄሢ ዓሲ ናዓሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ጎዣ ሃያ ዓጮ''ኬ፤ ጌኤዦ ዜርፃ ፆኦሲ ናኣቶ''ኬ፤ ዓዣሢ ጋዓንቴ ፃላሄ ናኣቶ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ዓዣሢ ዜርቄሢ ሞርካሢ ፃላሄኬ፤ ባርቾ ማንፂፃ ዓጮ''ኮ ጋፒንፆኬ፤ ማንፃ ዓሳ ፆኦሲ ኪኢታንቾኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ዓዣሢ ቱጊ ቡኩሲ ታሞይዳ ሚቾሢጉዲ ዓጮ''ኮ ጋፒንፆና ያዺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ዓጮ''ኮ ጋፒንፆ ዎዶ''ና ዓሲኮ ናዓሢ ፔ ኪኢታንቾ ዳካንዳኔ፤ ዔያታኣ ዓሶ ዻቢሻዞንሢና ፑርቶ ማዻዞንሢ ቢያ ዒዛ ካኣቱሞይዳፓ ቡኩሲ ኬሳ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ዬካፓ ዼኤፖ ታሞይዳ ዓጋንዳኔ፤ ዒኢካ ዬኤፒና ዓቺ ዻይሢና ዔያቶም ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ፂሎ''ንሢ ጋዓንቴ ፔ ዓዳሢ ካኣቱሞይዳ ዓቢጉዲ ፖዓንዳኔ፤ ዋይዛ ዋይዚ ዓኣሢ ዋይዞንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ሄሊ''ሳዖ ዬሱሴ፦ «ጫሪንጮ ካኣቱማ ጎሺ ሳዛይዳ ዓኣቾና ባኣዚ'' ማላኔ፤ ፔቴ'' ዓሲ ዬኖ ባኬሎ ዴንቃዖ ማሂ ጊንሣ ዓኣቼኔ፤ ሚርጌ ዎዛዼሢሮ ዴንዲ ዓኣ ባኮ ቢያ ሻንቺ ዬኖ ጎዤሎ ሻንቄኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ላሚ ሃሣ ዬሱሴ፦ «ጫሪንጮ ካኣቱማ ኮሺ'' ሚዛጶ፥ ሹጮ ሻንቃኒ ኮዓ ኮርሞ ዓሢ ማላኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ዬይ ኮርማ ዓሢ ሚርጌ ቦንቺንታ ኮሺ'' ሚዛጲ ሹቺ ዴንቄ ዎዶ''ና ዴንዲ ዓኣ ባኮ ቢያ ሻንቺ ዬኖ ሹጬሎ ሻንቄኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ሃሣ ዬሱሴ፦ «ጫሪንጮ ካኣቱማ ባዞ''ይዳ ዓጊንቴ ሞላሢ ዓርቆ ሮኦጮ ማላ ሱዞ ማላኔ፤ ዬና ዱማ ዱማ ሞላሢ ቢያ ዓርቃያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ሞላሢ ጌሊ ዓርቂንቲ ኩሜ'' ዎዶ''ና ሞላሢ ዓርቃ ዓሳ ዬኖ ሱዜሎ ባዛ''ፓ ጎቺ ዓጮ ኬሲ''ጋፓ ዴዒ ኮዦ ኮዦ ቁሪ ዔካዖ፥ ፑርቶ ጋዓንቴ ዒኢካ ኬኤሪ ሃሻ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ዓጮ''ኮ ጋፒንፆ ዎጎ ኬሎ''ና ያዺ ማዓንዳኔ፤ ፆኦሲኮ ኪኢታንቻ ሙኪ ጎሞ ዓሶ ጌኤዦይዳፓ ቁሪ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ባይቁዋ ታሞይዳ ዓጋንዳኔ፤ ዒኢካ ዬኤፒና ዓቺ ዻይሢና ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ላሚ ሃሣ ዬሱሴ፦ «ዬይ ኮኦኪንሣ ቢያ ዒንሢም ዔርቲያ?» ጋዓዛ፥ ዔያታኣ «ሂዮ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ዒዚያ፦ «ጫሪንጮ ካኣቱሞኮ ዓኣሺንቴ ባኮ ኮሺ'' ዔራ ዓሲ' ፃኣፒ ዓርቆና ዓኮና ጪሞ ባኮናፓ ዔሪ ዔሪ ኬሳ''፥ ሙሴ ዎጎ ዔርዛ ዓሲጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ዬሱሴ ዬንሢ ኮኦኪንሦንሢ ኬኤዚ ኩርሴስካፓ ዬኖ ቤዛፓ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ፔ ዓጮ'' ናዚሬቴ ካታሞዋ ሙኪ፥ ዒኢካ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ዔርዛንቴ ዒዛሲ ዋይዛ ዓሳ ቢያ ዲቃቲ ሄርሻዖ፦ «ሃይ ዓሢ ሃያጉዴ ዔራቶና ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮና ዓንካፓ ዔሬይ? ");
INSERT INTO mdybse_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ሃይ ሚፆ ዓርሳ ሃኣማ''ሢ ናኣዚ''ቱዋዓዳ? ዒንዳ ዒዛኮ ማይራሞቱዋዓዳ? ሃሣ ጌርሲንሢያ ዒዛኮ ያይቆኦቤንታ ዮሴፔንታ ሓሣ ሲሞኦኔንታ ዪሁዳንታቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ጌሮንሢ ዒዛኮ ቢያ ኑኡና ዎላ''ቱዋዓዳ? ዓካሪ ሃይ ዓሢ ሃያ ቢያ ዓንካፓ ዔሬይ?» ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ዒዛ ጎናሲ ጉሙርቁዋዖ ሃሼ''ኔ። ዬሱሴ ጋዓንቴ፦ «ፆኦሲ ማሊሢ ኬኤዛሢ ፔ ዓጮ''ና ፔ ማኣሮ ዓሶና ባኣካ'' ቦሂንታኔ፤ ጋዓንቴ ሜሌ'' ቤሲዳ ቦቦንቺንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ዔያታ ጉሙርቂ ጎናሲ ዔኪባኣሢሮ ዬሱሴ ዒኢካ ሚርጌ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ዬኖ ዎዶ''ና ጌሊላ ዓጮ'' ዎይሣ ሄሮዲሴ ዬሱሴ ማዻ ባኮ ዛሎ'' ዋይዚ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ዒዛኮ ዶንዞ ኮራ፦ «ያኣዼ ማዔቶ ማስካ ዮሓኒሴ ሃይባ''ፓ ዔቂ ሙኬኔ ጌይሢኬ፤ ሃይ ቢያ ማዺንታ ዓኮ ባካ ማዺንታሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ዬያኮ ቤርታ ሄሮዲሴ ዒዛኮ ጌርሲ ፒልጶሴ ማቾ፥ ሄሮዲያዳ ዔኬ ዛሎ''ና ዮሓኒሴ ዓይሢ ቱኡዞ ማኣራ ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ዮሓኒሴ ዒ ቱኪ''ሴሢ፦ «ኔኤኒ ዒዞ ዔካንዳያ ዎጋ ዓይሱዋሴ» ጌዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ዬያሮ ሄሮዲሴ ዮሓኒሴ ዎዻኒ ኮዔኔ፤ ጋዓንቴ ዓይሁዶ ዓሳ ዮሓኒሴ ፆኦሲ ማሊሢ ኬኤዛያ ማሂ ዛጋሢሮ ዒ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ፔቴ'' ኬሊ'' ሄሮዲሴ ፔኤኮ ሾይንቴ ኬሎ'' ቦንቻንቴ ሄሮዲያዳ ናኣ ሙዖም ዔኤሊ''ንቴ ዓሶ ቤርታ ሙኪ ኮርጋዖ ሄሮዲሴ ዎዛሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ዬያሮ ሄሮዲሴ ናዔሎም፦ «ኔ ኮዓ ባኣዚ'' ታና ዖኦጬ፤ ታ ኔኤም ዒንጋንዳኔ» ጌዒ ዒዞም ጫኣቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ዬካፓ ዒዛ ዒንዳ ዒዞ ዞሬም፦ «ማስካ ዮሓኒሴኮ ቶኦኮ ሃሢ ታኣም ጎንጊዳ ዓጊ ዒንጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ዬያ ዋይዛዖ ካኣቲ ኮሺ'' ዖዬኔ፤ ማዔቶዋ ዒ ዓሶ ቤርታ ዒዞም ጫኣቄሢሮ ዮሓኒሴኮ ቶኦካ'' ዒዞም ዒንጊንታንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ዬያሮ ዓሲ ዳኪ ማስካ ዮሓኒሴኮ ቶኦኮ'' ቱኡዞ ማኣራ ቲቂሲ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ቲቂንቴ ቶኦኮ'' ጎንጊዳ ዓጊ ዔኪ ሙኪ፥ ናዔሎም ዒንጌም ዒዛ ዔኪ ዒንዶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ዬካፓ ዮሓኒሴኮ ጊንፆ ሃንታ ናኣታ'' ሙኪ ዒዛኮ ሌዞ ዔኪ ዱኡካዖ ዴንዲ ዬያ ባኮ ዬሱሴም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ዬሱሴ ዮሓኒሴኮ ሃይቦ'' ዋይዜ ዎዶ''ና ዋኣፆና ፒንቆ ጎንጎ ቶጊ፥ ዓሲባኣ ዔዌ ቤሲ ፔኤሮ ሌሊ ዴዓኒ ዓኣዼኔ፤ ዴራ'' ጋዓንቴ ዬያ ዋይዛዖ ዔያታ ዓኣ ካታማ''ፓ ኬስኪ ኬስኪ ቶኪና ዒዛ ጊንፆ ዒ ዓኣ ቤዞ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ዬሱሴ ዋኣፆና ፒንቆ ጎንጋፓ ኬዴ'' ዎዶ''ና ሚርጌ ዴሬ ዛጋዖ ዔያቶ ሚጪንቴኔ፤ ዔያቶ ባኣካ''ፓ ሃርጌ ዓሶዋ ፖዒሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ሳዓ ዓማ''ዛ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዒዛ ኮይላ'' ሙካዖ፦ «ሃይ ቤዛ ዓሲ ናንጉዋ ዳውሎ''ኬ፤ ሳዓ ሃሢ ዓሜሢሮ ዴራ'' ሃያ ኮይሎ''ይዳ ዓኣ ጉርዶ ዴንዲ ፔኤኮ ሙዖንዶ ባኣዚ'' ሻንቃንዳጉዲ ዔያቶ ዳኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ዬሱሴ ጋዓንቴ፦ «ዒንሢ ዔያታ ሙዓንዳ ባኣዚ'' ዒንጉዋቴ፤ ዔያታ ዴንዶፓ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ዬሱሴኮ ጊንፆ ሃንታ ናኣታ''፦ «ኑኡኮ ሃሢ ሃካ ዓኣዞንሢ ዶንጎ ካሣና ላምዖ ሞሎና ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ዬሱሴያ፦ «ሂንዳ ዓኣዞንሢ ታኣም ዔኪ ዬዑዋቴ» ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ዴራ'' ቡጫ'' ዴዓንዳጉዲ ዓይሤኔ፤ ዬካፓ ዶንጎ ካሦንሢና ላምዖ ሞሎንሢና ዔኪ ሌካ ጫሪንጮ ባንሢ ዛጊ ፆኦሲ ሺኢቃዖ ካሦ ቡንፂ ዒዛኮ ጊንፆ ሃንታዞንሢም ዒንጋዛ ዔያታኣ ዴሮ''ም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ዬካፓ ቢያሢ ሙዒ ሚሽኬኔ፤ ዓቴ'' ዶምቦ ዒዛኮ ጊንፆ ሃንታዞንሢ ታጶ ላምዖ ዼኤፒ ሌማቴ ኩሙሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ዬያ ካሦ ሙዔ ዓሳ ላኣሎና ናኣቶ''ና ፓይዲንቲባኣንቴ ዓቲንቃ ሌሊ ዶንጎ ሺያ ዓሲ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ዬካፓ ዬሱሴ ጊንፆ ሃንታዞንሢም፦ «ታኣኒ ዓሶ ሳራሢ ዳካንዳኣና ዋኣፆና ፒንቆ ጎንጎ ቶጊ፥ ቤርታ ባዞ'' ሱኮ ፒንቁዋቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ዴሮ'' ዒ ዳኬሢኮ ጊንፃ ፔኤሮ ሺኢቃኒ ዹኮ'' ኬስካዖ ሳዓ ዓሜንቴያ ዒ ዒኢካ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ዬማና ናኣታ'' ዓኣ ዋኣፆና ፒንቆ ጎንጌላ ሳዓፓ ባዞ'' ሳዞ'' ጌሊ ዓኣንቴ ዼኤፒ ዋኣሢ ጉዳ ቤርቶ ዛሎ''ና ዢባርሻሢሮ ጎንጌላ ሴካ ሃንጋ ጌዒ ሚርጌ ዓጊፃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ዹሞኮ ባራሪ ኮይዳ ቂኢቃ ዎዴ ማዓኣና ዬሱሴ ባዞ'' ዑፃ ቶኪና ሃንቲ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ባዞ'' ዑፃ ዒ ሃንቲ ሙካሢ ዛጊ ሚርጌና ዲቃቲ ዒጊጫዖ፦ «ሃይ ዔኤዤኬ!» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ዬሱሴ ዒማ''ና፦ «ዒንሢ ዎይታይ ዒጊጪፖቴ፤ ታናኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ጴፂሮሴ ጋዓንቴ፦ «ጎዳሢዮ! ኔናታቶ ዋኣፆ ዑፃ ሃንቲ ኔ ባንሢ ታ ሙኮም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ዒዚያ፦ «ሃኒ ሙኬ!» ጌዔኔ። ዬካፓ ጴፂሮሴ ዋኣፆና ፒንቆ ጎንጎይዳፓ ኬዲ'' ዋኣፆ ዑፃ ዬሱሴ ባንሢ ዓኣዺሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ጋዓንቴ ዼኤፖ ዢባሮ ዒ ዛጌ ዎዶ''ና ዒጊጬኔ፤ ዬካፓ ዋኣፆይዳ ዔኤዺንቲሢ ዓርቃዖ፦ «ጎዳሢዮ፥ ታና ዓውሴ!» ጌይ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ዬሱሴ ዬማና ኩጮና ዒዛ ዓርቃዖ፦ «ኔኤኒ ጉሙርቂፃ ፓጬሢ ሃይ፥ ዓይጋ ኔ ሂርጌይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ዬካፓ ዬሱሴና ጲፂሮሴና ጎንጎ ጋሮ ጌሌ ዎዶ''ና ዢባራ ዢባርሺፆ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ዒማ''ና ዋኣፆና ፒንቆ ጎንጎ ጋራ ዓኣዞንሢ ቢያ፦ «ጎኔ ኔ ፆኦሲ ናይኬ!» ጌይ ዬሱሴም ዚጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ባዞ'' ፒንቂ ጌንሴሬፄ ዓጮ'' ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ዬኖ ዓጮ''ይዳ ዓኣ ዓሳ ዒ ዬሱሴ ማዔሢ ዔሬ ዎዶ''ና ኮይላ'' ዓኣ ዓጮ'' ዓሲ ዳኪ ሃርጊንቴ ዓሶ ዒዛ ባንሢ ዔኪ ሙኡሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ሃርጊንቴ ዓሳ ዒዛኮ ዓፒሎ ዓጮ ዔያቶ ዓርቂሳንዳጉዲ ዒዛ ሺኢቃዖ፥ ካኣሜዞንሢ ቢያ ዔያቶኮ ዓኣ ዶርዓስካፓ ፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ዬካፓ ዬሩሳላሜይዳፓ ሙኬ ፔርሴ ዓሶና ሙሴ ዎጎ ዔርዛዞንሢና ዬሱሴ ኮራ ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ኔኤኮ ጊንፆ ሃንታዞንሢ ኑ ዓዶንሢ ዎጎ ዓይጎሮ ካፑዋይ? ሃሣ ዔያታ ሙዖ ሙዓሢያ ኩጮ ማስቱዋዖኬ» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ዬሱሴ ዔያቶም ማሃዖ፦ «ዒንሢ ዒንሢኮ ዎጎ ካፓኒ፥ ፆኦሲ ዓይሢፆ ዓይጎሮ ዒንሢ ሃሻ''ይ? ");
INSERT INTO mdybse_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ዬይ ዓይሢፃ ፆኦሲ ‹ኔኤኮ ዓዶና ዒንዶና ቦንቼ፤ ዓዶ ሃሣ ዒንዶ ጫሽካሢ ቢያ ሃይቢና ዎጊንታንዳኔ› ጋዓሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ዒንሢ ጋዓንቴ ፔቴ'' ዓሲ ዓዶታቴያ ዒንዶ ‹ታጊዳፓ ዒንሢ ዴንቃንዳ ማኣዳሢ ታኣኒ ፆኦሲም ዒንጎ ባኣዚ'' ማሂ ዒንጌኔ› ጌዔቶ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ዬይ ዓሢ ዓዶታቶዋ ዒንዶ ቦንቻኒ ዒዛ ኮይሱዋሴ ዒንሢ ጋዓኔ፤ ዬያሮ ዒንሢኮ ዳምቦ ዶዲሻኒ ጌዒ ፆኦሲ ቃኣሎ'' ዒንሢ ሃሻ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ሃይ ዒንሢ፥ ፂሎ''ቱዋታዖ ፔና ‹ፂሎ''ኬ› ጋዓ ዓሳ! ዒሲያሴ ዒንሢ ዛሎ''፦ ");
INSERT INTO mdybse_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹ሓይ ዴራ'' ዻንጎና ታና ቦንቻኔ፥ ዒና'' ጋዓንቴ ታጊዳፓ ሃኬያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ዓሲ ኬሴ'' ዎጌና ዳምቤና ፆኦሲ ዎጌ ማሂ ዔርዚ ዔርዚ ጉሪ ታና ዔያታ ካኣሽካያ ማላኔ› » ጌዒ ኬኤዜሢ ፒዜኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ዬካፓ ዬሱሴ ዴሮ'' ፔ ባንሢ ዔኤላ''ዖ፦ «ዒና ዔኪ ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ዓሲ ጌኤሺቱዋያ ማሃሢ ዓሲዳፓ ኬስካ ባኣዚ'' ማሃንዳፓዓቴም ዙልካፓ ዻንጋና ጌላ ባኣዚ''ቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ዬካፓ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዒዛ ባንሢ ሙካዖ፦ «ፔርሴ ዓሳ ዬያ ኔ ጌዔ ባኮ ዋይዚ ዒኔ ዱጴሢ ኔ ዔሪያ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ዒዚ ጋዓንቴ፦ «ታኣኮ ጫሪንጮ ዓዳሢ ቱኪ''ባኣ ሚሢ ቢያ ቱጊንታንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ዔያታ ዓኣፒ ባይቄያ ሃሣ ዓኣፓ ባይቄ ዓሶኮ ዓርና ማዔሢሮ ዔያቶ ባኣዚ'' ሃሹ''ዋቴ፤ ዓኣፒ ባይቄ ዓሲ ዓኣፒ ባይቄያ ዔኪ ዓኣዻያ ማዔቶ ላምዖንሢ ዎሊ ዔኪ ዔቴይዳ ሎኦማንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴፂሮሴ ዬሱሴ ኮራ፦ «ዬኖ ኮኦኪንሦኮ ቡሊ''ፆ ኑም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ዬሱሴ ዔያቶም፦ «ዒንሢያ ሃኖ'' ሄላ''ንዳኣና ማሊ ጶቂሡዋያዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ዻንጋና ሊካ ጌላ ባኣዚ'' ቢያ ጎጶ ኬዳ''ዖ ጊንሣ ዙሎ'' ኬስካሢ ዒንሢ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ዻንጋና ኬስካ ባኣዚ'' ጋዓንቴ ዒናይዳፓ ኬስካኔ፤ ዓሲ ጌኤሺቱዋያ ማሃሢ ዬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ፑርታ ማሊሢ፥ ዓሲ ዎዺሢ፥ ዓኒ ሃሣ ማቾ ማዒ ባኣያና ላሂሢ፥ ኮይሱዋ ጎይሢና ዞኦስካ ኮኦሚሢ፥ ዉሱሞ፥ ሉኡዙሞ፥ ዓሲ ፑሽኪሢ፤ ዬይ ቢያ ዓሲ ዒናይዳፓ ኬስካኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ዓሲ ጌኤሺቱዋያ ማሃሢ ዬያጉዴ ባኮ ማዓንዳፓዓቴም ማስቲባኣ ኩቺና ሙዒሢቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ዬሱሴ ዬካፓ ፂሮሴና ሲዶና ጎዖ ዓጮ'' ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ዬኖ ዓጮ''ይዳ ፔቴ'' ካኣናኔ ዓጪ ላኣሊስኬና ዬሱሴ ኮራ ሙካዖ፦ «ዳውቴ ናዓሢዮ፥ ታ ጎዳ! ሃዳራ ታና ማኣዴቴራ፤ ታኣኮ ናይስኬኖ ፑርታ ዓያና ዓርቄም ሚርጌ ሜታዻኔ» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ዬሱሴ ጋዓንቴ ፔቴ''ታዖ ዔኤቢ ጎዑዋዖ ዚቲ ጋዓዛ፥ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዒዛ ኮይላ'' ሙካዖ፦ «ሃና ላኣሌላ ኑ ጊንፆ ዒላቲ ዒላቲ ሃንታሢሮ ሃዳራ ዒዞ ዳኬ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ዒዚ ማሃዖ፦ «ታኣኒ ዳኪንቴሢ ፆኦሲኮ ዣኣሊ ባይቄ ማራቶ፥ ዒስራዔኤሌ ዓሶም ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ላኣሌላ ጋዓንቴ ዑኪ ሙኪ ዒዛኮ ቶኮ ዴማ'' ጉምዓታዖ፦ «ታ ጎዳሢዮ! ሃዳራ ታና ማኣዴ''!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ዬሱሴ ማሃዖ፦ «ናኣቶ'' ካሦ ዔኪ ካናቶም ዓጊሢ ኮይሳያቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ላኣሌላ፦ «ጎዳሢዮ ጎኔኬ! ጋዓንቴ ካናታ ዔያቶኮ ዓዶንሢ ሙዓፓ ዲኢኔሢ ሙሙዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ዬሱሴ፦ «ዔና! ኔኤኮ ጉሙርቂፃ ዼኤፒኬ፤ ኔ ኮዔሢጉዲ ኔኤም ማዖንጎ» ጌዔኔ። ላኣሌሎኮ ናዔላ ዒማ'' ዒ ጋጋዓማና ዻቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ዬሱሴ ዬካፓ ዔቂ ጌሊላ ባዞ'' ዓጮ ሙካዖ ሌካ ዹኮ'' ኬስኪ ዒኢካ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ሚርጌ ዓሳ ሃንታኒ ዳንዳዑዋ ዎቦ ዓሶ፥ ዓኣፓ ባይቄ ዓሶ፥ ዎቦ ዓሶ፥ ዻንጎ ባይቄ ዓሶ፤ ዬያጉዲ ሜሌ'' ሃርጌ ዓሶዋ ዬሱሴ ባንሢ ዔኪ ሙኪ ዒዛኮ ቶኮ ዴማ'' ጌሤም ዔያቶ ዒ ፖዒሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ዬያሮ ዴራ'' ዻንጎ ባይቄ ዓሳ ጌስቴሢሮ፥ ሃንታኒ ዳንዳዑዋ ዎቦ ዓሳ ዻቄሢሮ፥ ዎቦ ዓሳ ፒኪ ሃንቴሢሮ፥ ዓኣፖ ባይቄ ዓሳ ዛጌሢሮ ዲቃቲ ሄርሺ ዒስራዔኤሌ ፆኦዛሢ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ዔኤላ''ዖ፦ «ዓሳ ታኣና ዎላ'' ሃይሦ ኬሊ'' ዴዔሢሮ ሙዓ ባኣዚ''ያ ዔያቶኮ ባኣሢ ታና ሚቻኔ፤ ሃሢ ዔያታ ዴንዳዖ ጎይፃ ላቢ'' ዓቱዋጉዲ ዔኤቢ ሙኡዙዋዖ ታ ዔያቶ ዳካኒ ኮዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ማሃዖ፦ «ሂዴቶ ሃያ ቢያ ዓሶም ጊዳ ሙኡዚ'' ሃይካ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዓይጋፓ ኑ ዴንቃንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ዬሱሴ ዔያቶ ኮራ፦ «ዓኣፒኒ ካሣ ዒንሢኮ ዓኣይ?» ጌዒ ዖኦጬኔ፤ ዔያታ፦ «ላንካይ ካሣና ዻካ'' ሞሎና ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ዬካፓ ዬሱሴ ዴራ'' ሳዖይዳ ዴዓንዳጉዲ ዓይሣዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ላንካዎ ካሦንሢና ሞሎንሢና ዔኪ ፆኦሲ ሺኢቂ፥ ቡንፂ ጊንፆ ሃንታዞንሢም ዒንጋዛ ዔያታኣ ዴሮ''ም ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ቢያሢ ሙዒ ሚሽኬም ዓቴ'' ዶምቦ ጊንፆ ሃንታዞንሢ ቡኩሲ ላንካይ ዼኤፒ ሌማቴ ኩሙሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ሙዔ ዓሳ ላኣሎና ናኣቶ''ና ዓታዛ ዓቲንቃ ሌሊ ዖይዶ ሺያ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ዬካፓ ዬሱሴ ዴሮ'' ሳራሢ ዳካዖ፥ ዋኣፆና ፒንቆ ጎንጎ ቶጊ፥ ሜጌዶኔ ዓጮ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፔርሴ ዓሶና ሶዶቄ ዓሶና ዬሱሴ ኮይላ'' ሙኪ፥ ዒ ዎዚ ጋዓቴያ ኑ ዛጎም ጌዒ፦ «ጫሪንቺዳፓ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዺ ኑና ዻዌ» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ዒዚ ጋዓንቴ ማሃዖ፦ «ዓማ''ዛ ‹ጫሪንጫ ጌኤሺታሢሮ፥ ሃኖ'' ዒርዚ ዋርቃዓ› ዒንሢ ጋዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ጉቶ ሃሣ ‹ሃኖ'' ሳዓ ሻኣሬናኬ፤ ዒርዚ ዋርቃንዳኔ› ዒንሢ ጋዓኔ፤ ዬያይዲ ጫሪንጮ ዛጊ ዒንሢ ዔሪ ዔራኔ፤ ጋዓንቴ ሓሢ ማዺንቲ ማዺንቲ ዓኣ ባኮ ዛሎ'' ዒንሢ ዔራኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ፑርታ ሓሣ ጉሙርቂሢ ባኣያ ማዔ፥ ሃያ ዎዶ'' ዓሳ ማላታ ዛጋኒ ኮዓኔ፤ ጋዓንቴ ፆኦሲ ማሊፆ ኬኤዛ ዮናሴ ማላቶ''ይዳፓ ዓታዛ ሜሌ'' ማላታ ዔያቶም ዻዊንታዓኬ» ጋዓዖ፥ ዬሱሴ ዔያቶ ሃሺ'' ሜሌ ቤሲ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ጋላ ዔኩዋዖ ዋሊ'' ባዞ'' ሱኮ ፒንቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ኮሺ'' ዔሩዋቴ! ፔርሴ ዓሶና ሶዶቄ ዓሶናኮ ዓሶ ዻቢሻ ሙኑቆ ፃኣዞፓ ዒንሢና ካፑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ዔያታ፦ «ዒዛኮ ዬያ ጌይፃ ጎዖንቴ ጋሎ'' ኑ ዋሌ''ሢሮ ናንዳኔ» ጌዒ ዎላ'' ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ዬሱሴ ጋዓንቴ ማሊፆ ዔያቶኮ ዔራዖ፦ «ዒንሢ ጉሙርቂፃ ፓጬ ዓሳ! ‹ካሦ ኑ ዋሌ''ሢሮኬ› ጌይ ዓይጎሮ ዎላ'' ዒንሢ ጌስታይ? ");
INSERT INTO mdybse_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ሄኤዶ ሄላ''ዖ ዒንሢ ጶቂሡዋዓዳ? ዶንጎ ካሦ፥ ዶንጎ ሺያ ዓሲ ሚሽኬም ዓቴ'' ዶምቦ ዋኣዺ ዼኤፒ ሌማቴ ኩሙሢ ዒንሢ ዔኬቶዋ ዒንሢ ጶቂሡዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ዬያጉዲ ሃሣ ላንካይ ካሣ ዖይዶ ሺያ ዓሲ ሚሼም ዓቴ'' ዶምቦ ዋኣዺ ዼኤፒ ሌማቴ ኩሙሢ ዒንሢ ዔኬቶዋ ዒንሢ ጶቂሡዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ዓካሪ ‹ፔርሴ ዓሶና ሶዶቄ ዓሶናኮ ዓሶ ዻቢሻ ሙኑቆ ፃኣዞፓ ዒንሢና ካፑዋቴ› ጌዒ ታ ዒንሢም ኬኤዛኣና ካሣ ዛላቱዋኣሢ ዎይቲ ዒንሢ ጶቂሡዋይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ዒዛኮ ጊንፆ ሃንታዞንሢ ዬሱሴ ዒንሢና ካፒንቱዋቴ ዔያቶም ጌዔሢ ፔርሴ ዓሶና ሶዶቄ ዓሶናኮ ዔርዚፆይዳፓ ማዓንዳኣፓዓቴም ካሣ ዛላቱዋኣሢ ዔያታ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ዬሱሴ ፒልጶሴ ቂሳሪያ ጎዖ ዓጮ'' ሄላ''ዖ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ዓሳ ዓሲኮ ናዓሢ ዖናኬ ጋዓይ?» ጌዒ ዔያቶ ዖኦጬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ዔያታ፦ «ፔቴ'' ፔቴ'' ዓሳ ‹ማስካ ዮሓኒሴኬ› ጋዓኔ፤ ዛላ'' ሃሣ ‹ዔኤሊያሴኬ› ጋዓኔ፤ ዓቴ'' ዓሳ ሃሣ ‹ዔርሚያሴኬ፤ ሃንጎ ፆኦሲ ማሊፆ ኬኤዛዞንሢዳፓ ፔቴ''ሢኬ› ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ዬሱሴያ፦ «ዒንሢ ታና ዖናኬ ጋዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ዬማ''ና ሲሞኦኔ ጌይንታ ጴፂሮሴ፦ «ኔኤኒ ናንጊና ናንጋ ፆኦዛሢ ናኣዚ''፥ ሜሲሔኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ዬሱሴ ማሃዖ፦ «ዮና ናዓሦ ሲሞኦኔ! ኔኤኒ ዓንጂንቴያኬ፤ ዓይጎሮ ጌዔቶ ዬያ ኔና ዔርዜሢ ጫሪንጫ ዓኣ ታ ዓዳሢ ማዓንዳፓዓቴም ዓሲቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ታ ኔኤም ሂዚ ጋዓኔ፦ ጴፂሮሴ፥ ኔኤኒ ላሌኬ፤ ሃያ ቦኦኮላሢ ማዔ ሹጫሢዳ ታኣኮ ሺኢጲፆ ማኣሮ ዓሶ ታ ዶዲሺ ዔቂሳንዳኔ፤ ዬኖ ሺኢጲፆ ማኣሮ ዓሶ ሃይቢ ዎልቄታዖ ባይዛዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ሃይሾ ታ ኔኤም ጫሪንጮ ማኣሮ ካኣቱሞኮ ካሮ'' ቡሎ'' ቁልፖ ዒንጋንዳኔ፤ ሳዓ ኔ ‹ማዖንጎ› ጌዔ ባካ ጫሪንጫ ዒማዺ ማዓንዳኔ፤ ሳዓ ኔ ‹ማዖፓ› ጌዔ ባካ ጫሪንጫኣ ማዓዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ ዒዚ ኪሪስቶሴ ማዔሢ ዖኦማኣ ዔያታ ኬኤዙዋጉዲ ላቲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ዬማፓ ዓርቃዖ ዬሱሴ ዒዛኮ ጊንፆ ሃንታ ናኣቶ'' ኮራ፦ «ሃሢ ዬሩሳላሜ ታ ዓኣዻንዳያ ኮይሳኔ፤ ዒኢካ ጪሞና ቄኤሶኮ ሱኡጎና ሃሣ ሙሴ ዎጎ ዔርዛ ዓሶና ታ ጊዳ'' ፑርታ ሜቶ ዔኪ ዬዔም፥ ሃይቄስካፓ ሃይሣሳ ኬሎ''ና ሃይባ''ፓ ታ ዔቃንዳኔ» ጌዒ ጌዒ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጴፂሮሴ ጋዓንቴ ዬሱሴ ዱማሳዖ፦ «ጎዳሢዮ! ፔቴ''ታዖ ዬይ ማዓዓኬ! ዬይ ባካ ኔና ሄሎ''ፓ!» ጌዒ ዞሪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ዬሱሴ ጋዓንቴ ጴፂሮሴ ባንሢ ሺራዖ፦ «ፃላሄ፥ ኔ ታ ኮራፓ ሃኬ! ኔኤኒ ዓሲ ባኣዚ''ዳፓ ዓታዛ ፆኦሲ ባኣዚ'' ማሉዋኣሢሮ ታኣኮ ኔ ዹቆ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታ ናኣቶ'' ኮራ፦ «ታ ጊንፆ ሃንታኒ ኮዓሢ ፔና ኬኤሪ ሃሾ''ንጎ፤ ሃሣ ሃይቢማኣ ጊኢጊ ታ ጊንፆ ሃንቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ፔ ናንጎ ዓይሳኒ ኮዓሢ ቢያ ናንጎ ባይዛንዳኔ፤ ፔ ናንጎ ታ ጋይቴ ጌዒ ባይዛሢ ጋዓንቴ ዓይሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ፔቴ'' ዓሲ፡ ዓጫ'' ዓኣ ባካ ቢያ ዒዛም ማዔም ፔ ናንጎ ጋዓንቴ ባይዜቶ ዓይጎ ዒዛ ማኣዳ''ንዳይ? ሃሣ ዓሲ ፔኤኮ ባይቄ ናንጎ ማሂ ዴንቃኒ ዓይጎና ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ዓሲኮ ናዓሢ ዓዶኮ ቦንቾና ፆኦሲ ኪኢታንቾና ዎላ'' ሙካንዳኔ፤ ዒማ''ና ፔቴ'' ፔቴ''ሢም ፔኤኮ ማዾ''ጉዲ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓሲኮ ናዓሢ ጫሪንጮ ካኣቱሞ ቦንቾና ሙካኣና ዛጋንዳያ ሄላ''ንዳኣና ሃይካ ዔቄ ዓሶ ባኣካ''ፓ ሃይቂንዱዋ ዓሲ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ላሆ'' ኬሊ''ኮ ጊንፃፓ ዬሱሴ ጴፂሮሴና ያይቆኦቤና ሃሣ ያይቆኦቤኮ ጌርሲ ዮሓኒሴና ሌሊ ዔኪ ዼኤፒ ዹካ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ዬካ ዔያቶኮ ቤርታ ዒ ላኣሚንታዖ ዓኣፖ ካራ'' ዒዛኮ ዓቢጉዲ ፖዔኔ፤ ሃሣ ዒዛኮ ማኣዓሢያ ዓኣፓ ዱካያ ማዒ ቦኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ዬማ''ና ሙሴንታ ዔኤሊያሴንታ ዬሱሴና ዎላ'' ጌስታንቴ ዔያታ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ጴፂሮሴ ዬሱሴ ኮራ፦ «ጎዳሢዮ! ሃይካ ኑ ናንጌቴ ኮሺኬ፤ ኔ ናሽኬቶ ፔቴ'' ኔኤም፥ ፔቴ'' ሙሴም፥ ፔቴ'' ሃሣ ዔኤሊያሴም ሃይሦ ዉዲ ታ ማዦም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ዒ ኬኤዛ ጎይሣ ዓኣንቴ ቦኦሬ ሻኣሬ ሙኪ ዔያቶ ባይዜኔ፤ ዬያ ሻኣሮ ባኣካ''ፓ፦ «ታ ዒዛና ዎዛዻ፥ ታ ናሽካ ናዓሢ ሃያኬ፤ ዒዛሲ ዋይዙዋቴ» ጋዓ ዑኡሲ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ዒማ''ና ዒዛና ዎላ'' ዓኣ ዬሱሴኮ ጊንፆ ሃንታዞንሢ ዬያ ዋይዜ ዎዶ''ና ዲቃቲ ሳዖይዳ ባሊቲና ሎኦሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ዬሱሴ ሙኪ ዔያቶ ኩጮና ዓርቃዖ፦ «ዒጊጪፖቴ፥ ዔቁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ዬካፓ ዔያታ ዼ'ግ ጌዒ ዛጋንቴ ዬሱሴይዳፓ ዓታዛ ሜሌ'' ዖኦኒያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ዹካ''ፓ ዔያታ ኬዲፆይዳ ዓኣንቴ ዬሱሴ ዔያቶም፦ «ዓሲኮ ናዓሢ ሃይቂ ሃይባ''ፓ ዔቃንዳያ ሄላ''ንዳኣና ዒንሢ ዛጌ ባኮ ዖኦማኣ ኬኤዚፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ዒዛኮ ጊንፆ ሃንታዞንሢ፦ «ዓካሪ፥ ሙሴ ዎጎ ዔርዛዞንሢ ዔኤሊያሴ ቤርታዺ ሙካንዳያ ኮይሳኔ ጋዓሢ ዓይጎሮዳዖ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ዒዚ ዔያቶም ማሃዖ፦ «ዔኤሊያሴ ጎኔ ሙኪ ቢያ ባኣዚ'' ጊኢጊሻንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ጋዓንቴ ታ ዒንሢም ሂዚ ጋዓኔ፦ ዔኤሊያሴ ሙኪናኣኮኬ፤ ማዔቶዋ ዔያታ ኮዔ ባኣዚ'' ዒዛይዳ ማዼያፓዓቴም ዒዛ ዔሪባኣሴ። ዬያጉዲ ሃሣ ዓሲኮ ናዓሢ ዔያታ ሜታሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ዬማ''ና ዒዛና ዓኣ ጊንፆ ሃንታዞንሢ ዬሱሴ ዔያቶም ኬኤዜሢ' ማስካ ዮሓኒሴ ዛሎ'' ማዔሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ዬሱሴና ሃይሦ ዒዛኮ ጊንፆ ሃንታዞንሢና ዴሮ'' ባንሢ ማዒ ሙካዛ ፔቴ'' ዓሲ ዬሱሴኮ ቤርታ ሙኪ ጉምዓታዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«ታ ጎዳሢዮ! ታኣኮ ናዓሢ ዓውሴ፤ ዴንሣ ፑርታ ዓያና ዶርዓ ዒዛ ሜታሳኔ፤ ሚርጌ ዎዴ ታሚዳ ሎኦማኔ፤ ሃሣ ዋኣሢዳኣ ጌላኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ኔኤኮ ጊንፆ ሃንታዞንሢ ኮራ ታ ዔኪ ሙኬንቴ ዔያታ ዒዛ ዓውሳኒ ዳንዳዒባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ዬሱሴ፦ «ሓይ ዒንሢ ጉሙርቁዋ ዎቦ ዓሳ! ዓይዴ ሄላ''ንዳኣና ታ ዒንሢና ናንጋንዳይ? ሃሣ ዓይዲ ሄላ''ንዳኣና ታ ዒንሢ ጊቢ'' ዳንዳዓንዳይ? ሂንዳ ናዓሢ ታኣም ዔኪ ዬዑዋቴ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ዬካፓ ዬሱሴ ፑርቶ ዓያናሢ ጎራ''ዛ፥ ፑርቶ ዓያናሢ ናዓሢዳፓ ኬስኬም ናዓሢ ዬማፓ ዓርቃዖ ዻቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ዬካፓ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ፔኤሮ ዬሱሴ ኮይላ'' ሙካዖ፦ «ኑኡኒ ፑርቶ ዓያኖ ኬሳ''ኒ ዳንዳዒባኣሢ ዓይጎሮዳይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ዬሱሴ ማሃዖ፦ «ጉሙርቂፃ ዒንሢኮ ዻኬሢሮኬ፤ ጎኔ ታ ዒንሢም ጋዓኔ፤ ሴናፒጬ ጌይንታ ባኮማ ዓኣፖ ጉዴያታዖ ጉሙርቂሢ ዒንሢኮ ዓኣቶ ሃያ ዹኮ'' ‹ሃካፓ ሺኢኬ› ጌዔቶ ዒንሢም ዓኣዻንዳኔ፤ ዒንሢ ባሻንዳ ባኣዚ'' ፔቴ''ታዖ ባኣሴ።  ");
INSERT INTO mdybse_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ሓያ ጉዴሢ ሙኡዚ'' ሃሺ'' ሺኢቆ ሺኢጲሢና ማዒባኣቶ ኬስኩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ጌሊላይዳ ዒዛኮ ጊንፆ ሃንታዞንሢ ቡኪንቲ ዓኣንቴ ዬሱሴ ዔያቶም፦ «ዓሲኮ ናዓሢ ዓሶም ዓኣሢንቲ ዒንጊንታንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ዔያታኣ ዒዛ ዎዻንዳኔ፤ ዒዚያ ሃይባ''ፓ ሃይሣሳ ኬሎ''ና ዔቃንዳኔ» ጌዔሢሮ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ሚርጌና ዖዬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ቂፒርናሆሜ ጎዖ ዓጮ'' ሄላ''ዛ ጌኤዦ ማኣሮኮ ጊኢሮ ጪጊሳ ዓሳ ጴፂሮሴ ኮይላ'' ሙካዖ፦ «ዒንሢኮ ዔርዛሢ ጌኤዦ ማኣሮም ጪጎ ሚኢሾ ጪጋ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጴፂሮሴ፦ «ሂዮ፤ ጪጋኔ» ጌዔኔ። ዬካፓ ጴፂሮሴ ጋሮ ጌላዛ ዬሱሴ ቤርታዺ ሲሞኦኔ ኮራ፦ «ዓጮ'' ካኣታ'' ጊኢሮ ሚኢሾንታ ኮርሞ ዓሶፓ ዔኮ ሚኢሾ ዔካሢ ዓጮ'' ዓሶይዳፓሞ? ዙሎ'' ዓሶይዳፓዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴፂሮሴ ማሃዖ፦ «ዙሎ'' ዓሶይዳፓኬ» ጌዔኔ። ዬያሮ ዬሱሴ፦ «ሂዴቶ ዓጮ'' ዓሳ ጊኢራ ጪጉዋሴ ጌይሢኬ! ");
INSERT INTO mdybse_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ዓካሪ ኑና ዔያታ ቆፁዋጉዲ ዴንዲ ሞላሢ ዓርቆ ዓንጎ ኪሮ ባዛ'' ዓጌ፤ ዬካፓ ቤርታዺ ኔ ዓርቄ ሞሎማ ሹካዖ ዻንጋፓ ኔ ዔካንዳ ሹጮ ቢሮ'' ታኣና ኔኤናና ዛሎ'' ጪጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ዬኖና ዬሱሴኮ ጊንፆ ሃንታዞንሢ ዬሱሴ ኮራ ሙካዖ፦ «ጫሪንጮ ካኣቱሞይዳ ቢያፓ ባሼሢ ዖናዳይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ዬሱሴ ፔቴ'' ዻካ'' ናይ ዔኤሊ'' ዔያቶኮ ባኣካ'' ዔቂሳዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒና'' ዒንሢኮ ላኣሚንቲባኣቶ ሃሣ ዻካ'' ናይጉዲ ዒንሢ ማዒባኣቶ ጫሪንጮ ካኣቱሞይዳ ፔቴ''ታዖ ዒንሢ ጌላዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ሓይማ ናዖጉዲ ፔና ሂርኪዳሢ ጫሪንጮ ካኣቱሞይዳ ዼኤፒ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ሃይማጉዴ ናዖ ታ ሱንፆና ቦንቺ ዔካሢ ታናኣ ዔካኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ታና ጉሙርቃዞንሢ፥ ሃንሢ ዻኮ''ንሢዳፓ ፔቴ''ማ ዻቢሻ ዓሲ ዼኤፒ ዎንሢ ሹቺ ባቃና'' ቱኪ'' ባዞ'' ቁልባ ኬኤሪንቲ ሃይቄቶ ቃራ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ሃሣ ዬሱሴ ኬኤዛዖ፦ «ዓሲ ጌሺ፥ ጎሜ ማዺሻኒ ዳንዳዓ ባኣዚ''ና ኩሜ'' ሃኖ'' ዓጬ''ሎም ባዴዔ! ዎይቴቴያ ጌሺ ዻቢሻ ባኣዚ'' ሙኩዋዖ ዓታዓኬ፤ ጋዓንቴ ጌሺ ዻቢሻኒ ማዻ ዬያ ዓሢም ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ዬያሮ ኔኤኮ ኩጫ ሃሣ ቶካ ዻቢሺ ጎሜ ማዺሳያ ማዔቴ ቲቂ ኔጊዳፓ ኬኤሬ፤ ላምዖ ኩቺና ሃሣ ላምዖ ቶኪና ዓኣዖ ናንጊና ባይቁዋ ታሞይዳ ኔ ኬኤሪንታስካፓ ጉንዖ ሃሣ ዎቦ ዓሲ ማዒ ናንጊና ናንጎይዳ ጌሊፃ ኔኤም ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ዓኣፓ ኔኤኮ ኔና ዻቢሺ ጎሞ ማዺሻዞ ማዔቶ ኬሲ'' ኔጊዳፓ ኬኤሬ፤ ላምዖ ዓኣፒ ኔኤኮ ዓኣንቴ ጋኣናኣሜ ታሞይዳ ኔ ኬኤሪንታስካፓ ፔቴ'' ዓኣፒና ማዒ ናንጊና ናንጎይዳ ጌሊፃ ኔኤም ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«ሃንሢ፥ ዻኮ''ንሢዳፓ ፔቴ''ማታዖ ዒንሢ ቦሁዋጉዲ ዒንሢና ዔሩዋቴ፤ ጫሪንጮይዳ ዓኣ ዔያቶም ጊኢጊንቴ ኪኢታንቻ ጫሪንጫ ዓኣ፥ ታ ዓዳሢ ቤርታ ቢያ ኬሊ'' ዓኣኔ።  ");
INSERT INTO mdybse_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ዓሲኮ ናዓሢ ሙኬሢ ባይቄሢ ዴንቂ ዻቂሻኒኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ሓሣ ዬሱሴ ኬኤዛዖ፦ «ዒንሢም ዓይጎ ማላይ? ፔቴ'' ዓሲኮ ፄኤታ ማራይ ዓኣዖ ዔያቶይዳፓ ፔቴ'' ባይቄቴ ታዞጲታሞ ታዞጶ ሄንቃ ዹኮ''ይዳ ሃሺ'' ባይቄ ማራዓሢ ኮዓኒ ዓኣዹዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዬያ ማራዓሢ ዴንቄ ዎዶ''ና ባይቂባኣ ታዞጲታሚ'' ታዞጶንሢዳፓ ባሼ ባይቂ ጴዼሢሮ ሚርጌና ዒ ዎዛዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ዬያጉዲ ጫሪንጮይዳ ዓኣ፥ ዒንሢኮ ዓዳሢ ሃንሢ ዻኮ''ንሢዳፓ ፔቴ''ማታዖ ባይቃንዳጉዲ ኮዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ዬካፓ ዬሱሴ፦ «ታና ጉሙርቃዞንሢዳፓ ፔቴ''፥ ኔኤኮ ዒሾ ማዓይ ኔኤም ዻቤቶ ኔኤና ዒዛና ሌሊ ማዒጋፓ ዒ ዻቤ ጎይፆ ኬኤዜ፤ ኔ ጋዓሢ ዒ ዋይዜቶ ጊንሣ ዒንሢኮ ፔቱሞ ዎንዳሲጉዲ ኔ ማሄኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ኔኤም ዒ ዋይዚባኣቶ ጌኤሲ ላምዖ፤ ሃሣ ሃይሦ ዓሲ ማርካቶና ጎናዻሢሮ ላምዖ ሓንጎ ሃይሦ ዓሲ ዔኪ ዒዛ ኮይላ'' ዴንዴ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ዔያታ ጋዓሢያ ዒ ዋይዛዓ ጌዔቶ ሺኢጲፆ ማኣሮ ዓሶም ኬኤዜ፤ ሃሣ ሺኢጲፆ ማኣሮሲያ ዋይዞ ዒፄቶ ኪሪስቶሴ ጉሙርቁዋ ዓሲ ሃሣ ጎሜ ዓሲ ማሂ ዒዛ ዛጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ሓሣ ዒ ኬኤዛዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ሳዖይዳ ዒንሢ ‹ያዺ ማዖም› ጌዔ ባካ ጫሪንጫ ዒማዺ ማዓንዳኔ፤ ሳዖይዳ ዒንሢ ‹ማዖፓ› ጌዔ ባካ ጫሪንጮይዳኣ ማዑዋያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«ሃሣ ታ ዒንሢም ጋዓኔ፦ ዒንሢ ላምዖ ማዒ ሳዖይዳ ፔቱሞና ዓይጎ ባኣዚ''ያ ሺኢቄቶ ጫሪንጫ ዓኣ ታ ዓዳሢ ዒንሢም ኩንሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ዓይጎሮ ጌዔቶ ላምዖ ሃሣ ሃይሦ ማዒ ታ ሱንፆና ዒንሢ ቡኪንታ ቤዛ ቢያ ታ ዒንሢኮ ባኣካ'' ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ዬማ''ና ጴፂሮሴ ዬሱሴ ባንሢ ሙካዖ፦ «ጎዳሢዮ! ኔና ጉሙርቃ፥ ፔቴ'' ታ ዒሻሢ ታኣም ዻቤቶ ዓኣፒኒ ማይንቲ ታ ዒዛም ዓቶም ጎዖንዶይ? ላንካይ ሄላ''ንዳኣና ጎዖንዶሞ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ዬሱሴ ማሃዖ፦ «ላንካይታሚ'' ማይንቲ ላንካይ ሄላ''ንዳኣና ማዓንዳኣፓዓቴም ላንካይ ማይንቲ ሌሊ ‹ዓቶም› ጌዔ ታ ኔና ጎዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ዬያሮ ጫሪንጮ ካኣቱማ ፔኤኮ ማዻ ዓሶ ኮራ ዓኣ ሚኢሾ ዛጋኒ ኮዔ ካኣቲስኬያ ማላኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ዬይ ካኣታ''ሢ ሚኢሾ ዛጎ'' ዓርቄ ዎዶ''ና ሺያ ዓሲ ፔቴ'' ሌዔ ማዾ ማዼም ዒንጎ ሚኢሼ ጉዴያ ባይዜ፥ ጋሌና ዓኣ፥ ዒዛኮ ማዻ ዓሲ ዓርቂንቲ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ዬይ ማዻ ዓሢ ጋሎ'' ጪጋኒ ዳንዳዒባኣሢሮ ካኣታ''ሢ ዒዛንታ ዒዛኮ ማቾንታ ናኣቶ''ንታ ዓኣ ባካኣ ቢያ ሻንቺንቴም ጋላ'' ጪጊንታንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ማዻሢ ጋዓንቴ ካኣታሢኮ ቶካ ሎኦማዖ፦ ‹ታ ጎዳሢዮ! ሃዳራ፥ ታ ኔኤም ጋሎ'' ቢያ ጪጋንዳኔ፤ ዻካ'' ኬሊ'' ታኣም ማሌ› ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ጎዳሢ ዒዛ ሚጪንታዖ ዒዛኮ ዓኣ ጋሎ'' ሃሺ''፥ ማሂ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«ጋዓንቴ ዬይ ዓሢ ዬካፓ ኬስኪ ዓኣዻንቴ ፄኤታ ሹቺ ቢራ ዒዛይዳፓ ታልዔ፥ ዒዛና ዎላ'' ማዻ ዓሲስኬያ ዴንቃዖ ፖኦሪንዶ ዓሢኮ ጩኡሊ'' ዓርቂ ‹ኔ ታኣኮ ታልዔ ቢሮ'' ታኣም ጪጌ!› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ዬይ ዒዛኮ ላጋሢ ቶካ ዒዛኮ ሎኦማዖ ‹ሃዳራ፥ ታ ኔኤም ጋሎ'' ጪጋንዳኔ፤ ዻካ'' ኬሊ'' ታኣም ማሌ› ጌዒ ሺኢቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ታልዔሢ ጋዓንቴ ዬያ ዋይዞ ዒፃዖ ጋሎ'' ጪጋንዳያ ሄላ''ንዳኣና ዔኪ ዓኣዺ ቱኡሲ'' ማርካ ቱኪ''ሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ሜሌ'' ዬያ ዓሢና ማዻ ላጎንሢ ዬያ ዛጌ ዎዶ''ና ሚርጌና ዖያዖ ዴንዲ ማዺንቴ ባኮ ቢያ ዔያቶኮ ካኣታ''ሢም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ዔያቶኮ ካኣታ''ሢ ዬያ ማዻ ዓሢ ዔኤሊ''ሳዖ፦ ‹ኔኤኒ ሃይ ፑርታሢ! ኔ ታና ሺኢቄሢሮ ኔኤኮ ዓኣ ጋሎ'' ቢያ ታ ኔኤም ሃሼ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ዓካሪ ታኣኒ ኔኤኮ ጋሎ'' ኔኤም ሃሼ''ሢጉዲ ኔኤኒ ኔ ላጋሢ ማዔ፥ ማዻሢም ጋሎ'' ሃሻ''ንዳያ ኮይሱዋዓዳ?› ");
INSERT INTO mdybse_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ጋዓዖ፥ ጎዳሢ ዒዛይዳ ጎሪ''ንቴስካፓ ቤርታ ሃሼ'' ጋሎ'' ቢያ ጪጋንዳኣና ቱኪ'' ዒዛ ሜታሳንዳጉዲ ቱካ'' ዓሶም ዓኣሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«ዓካሪ ዒንሢ ፔቴ'' ፔቴ''ሢ ታና ጉሙርቃ፥ ዒንሢኮ ዒጊኖንሢም ዒናፓ ዓቶም ጌዒባኣቶ ጫሪንጮይዳ ዓኣ ታ ዓዳሢ ዒንሢም ዓቶም ጋዓዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ዬሱሴ ዬያ ባኮ ኬኤዚ ጋፒሴሢኮ ጊንፃ ጌሊላ ዓጮ'' ሃሺ'' ዮርዳኖሴ ዎሮ ሱካ'' ዓኣ፥ ዪሁዳ ዓጮ'' ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ዬማና ሚርጌ ዓሲ ዒዛ ጊንፆ ዓኣዻዛ ዔያቶይዳፓ ሃርጊንቴ ዓሶዋ ዒኢካ ዒ ፓሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ፔርሴ ዓሳ ዒ ዎዚ ጋዓቴያ ዋይዛኒ ዒዛ ኮይላ'' ሙካዖ፦ «ማዔ ባኣዚ'' ቢያና ዓሲ ፔኤኮ ማቾ ዓንጃንዳጉዲ ዎጋ'' ዓይሣ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ዬሱሴ ማሃዖ፦ «ፆኦሲ ቤርታዺ ዓቲንቄና ላኣሊና ማሂ ዓሲ ማዤሢ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ሃሣ ‹ዬያ ዛሎ''ና ዓሲ ዓዶና ዒንዶና ሃሺ'' ማቾና ዎላ'' ፔቴ'' ማዓኔ፤ ላምዖንሢያ ፔቴ'' ዓሲ ማዓኔ› ፆኦሲ ጌዔሢ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ዬያሮ ዔያታ ፔቴ''ኬ፤ ላምዖቱዋሴ፤ ፆኦሲ ዎላ'' ዋኣፄዞንሢ ዓሲ ቡሎ''ፓ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ፔርሴ ዓሳ ጊንሣ፦ «ሂዴቶ ሙሴ ዓይጎሮ ‹ፔቴ'' ዓሲ ላኣሌሎ ዓንጄያ ማዔሢ ዔርዛ፥ ማርካ ማዔ፥ ፃኣፒንቴ ባኣዚ'' ዒንጊ ማቾ ዓንጆንጎ› ጌዒ ዓይሤይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ዬሱሴ ማሃዖ፦ «ሙሴ ዒንሢኮ ዒኖ'' ዶዱሞ ዛጊ ላኣሊ ዒንሢ ዓንጃንዳጉዲ ዓይሣንዳኣፓዓቴም ማዢንታፓ ዓርቃዖ ዓኣ ዎጋ'' ያዺቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","«ታ ዒንሢም ሃሢ ጋዓሢ' ማቻ ፔኤኮ ሜሌ''ና ዒኢቲባኣንቴ ማቾ ዓንጂ ሜሌ'' ላኣሊ ዔካሢ ቢያ ዞኦስካ ኮኦማያ ማዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ዒዛኮ ጊንፆ ሃንታዞንሢ ዬያ ዋይዛዖ፦ «ዓኒና ማቾና ዛላ ባኣዚ'' ያዺ ማዔቴ ዔኪቦኦቴ ሃሣ ሎዒቦኦቴ ቃራኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ዬሱሴ ጋዓንቴ፦ «ፆኦሲ ዱማ ዳንዳዒሢ ዒንጌ ዓሲዳፓ ዓታዛ ዬይ ባካ ዖኦማኣ ዳንዳዒንቱዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ጋዓንቴ ዓሲ ላኣሊ ዔኩዋዖ ሃሣ ሌውዋዖ ዓታሢ፦ ፔቴ'' ፔቴ''ሢ ዓሽቲሚ ማዒ ሾይንታኔ፤ ዛላ'' ሃሣ ዓሲ ኩቺና ዓሽቲንቃኔ፤ ዓቴ''ሢ ሃሣ ጫሪንጮ ካኣቱሞ ማዾ''ሮ ‹ሾዓዓ› ጌዒ ፔና ዓሽቲሚጉዲ ማሃኔ፤ ዬያ ታ ጌዔ ባኮ ዔካኒ ዳንዳዓሢ ያዺ ማዾንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ዒማ''ና ናኣቶ''ኮ ዑፆይዳ ኩጮ ጌሢ ሺኢቃንዳጉዲ ዓሳ ዻኮ'' ናኣቶ'' ዒዛ ባንሢ ዔኪ ሙካዛ ዒዛኮ ጊንፆ ሃንታዞንሢ ጋዓንቴ ዓሶ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ዬሱሴ፦ «ናኣታ'' ታ ባንሢ ሙኮንጎ፥ ላኣጊፖቴ፤ ጫሪንጮ ካኣቱማ ዔያቶ ጉዴዞንሢምኬ» ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ኩጮ ናኣቶ'' ዑፃ ጌሢ ዓንጄሢኮ ጊንፃፓ ዬኖ ቤዛፓ ዔቂ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ዬካፓ ፔቴ'' ዓሲ ዬሱሴ ኮራ ሙካዖ፦ «ዔርዛሢዮ፥ ናንጊና ናንጊ ዴንቃኒ ዓይጎ ኮሺ ባኣዚ'' ታ ማዾንዶይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ዬሱሴ ማሃዖ፦ «ኮሺ ማዾ ዛላ ኔ ታና ዓይጋ ዖኦጫይ? ኮሺ ማዓይ ፔቴ'' ፆኦዛሢ ሌሊኬ፤ ናንጊና ናንጊ ኔ ዴንቃኒ ኮዔቴ ዓይሢፆንሢ ኩንሤ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ዓሢያ፦ «ዎንሢ ዓይሢፆንሢ?» ጌዔኔ። ዬሱሴ ማሃዖ፦ «ዓሲ ዎዺፖ፥ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂፖ፥ ዉኡቂፖ፥ ሉኡዙሞና ማርካዺፖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ኔ ዓዶና ኔ ዒንዶና ቦንቼ፥ ዓሲ ኔናጉዲ ማሂ ናሽኬ ጋዓ ዓይሢፆንሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ዼጌሢያ፦ «ዬንሢ ታ ቢያ ካፔያኬ፤ ሜሌ'' ዓቴ'' ባኣዚ'' ዓይጌ ዓኣይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ዬሱሴ ማሃዖ፦ «ፔቶ ኔ ፂሎ'' ማዓኒ ኮዔቶ ኔኤኮ ዓኣ ባኮ ቢያ ሻንቺ ሚኢሾ ማንቆ ዓሶም ዒንጌ፤ ጫሪንጮይዳ ቆሎ ኔ ዴንቃንዳኔ። ዓካሪ ዬካፓ ታ ጊንፆ ሙኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ዼጌሢ ዬያ ዋይዛዖ፥ ሚርጌ ቆሎ ዒዛኮ ዓኣሢሮ ኮሺ'' ዖዪ ዖዪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታ ናኣቶ'' ኮራ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዖርጎቺም ፆኦሲ ካኣቱሞይዳ ጌሊሢ ሚርጌ ሜቶኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ላሚ ታ ሃሣ ዒንሢም ጋዓኔ፦ ዖርጎቺ ፆኦሲ ካኣቱሞይዳ ጌላሢዳፓ ጋኣላ ናርፔ ፂኢናና ጌላኒ ሼሌዔ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬያ ዋይዜ ዎዶ''ና ኮሺ'' ዲቃቲ ሄርሻዖ፦ «ዓካሪ ሂዴቴ ዖኦኒ ዻቃኒ ዳንዳዓንዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ዬማና ዬሱሴ ዔያቶ ባንሢ ዛጋዖ፦ «ዬይ ዓሲም ዳንዳዒንቱዋ ባኣዚ''ኬ፤ ፆኦሲም ጋዓንቴ ቢያ ባኣዚ'' ዳንዳዒንታያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ጴፂሮሴ፦ «ሃይሾ ቢያ ባኣዚ'' ኑ ሃሺ'' ኔ ጊንፆ ሃንታንቴሞ? ዓካሪ፥ ኑ ዴንቃንዳ ባካ ዓይጌንዴ ናንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ዬሱሴ ማሃዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ሙካንዳ ዓኮ ዓጮ''ይዳ ዓሲኮ ናዓሢ ቦንቺንቴ፥ ካኣቱሞ ዖይቶይዳ ዴዔ ዎዶ''ና ዒንሢያ ታ ጊንፆ ሃንታዞንሢ ታጶ ላምዖ ካኣቱሞ ዖይቶይዳ ዴዒ፥ ታጶ ላምዖ ዒስራዔኤሌ ፃጶይዳ ዎጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ታ ሱ'ንፆሮ ጌዒ፦ ፔ ማኣሮ፥ ፔ ጌርሲንሢ፥ ጌሮንሢ፥ ዓዶ፥ ዒንዶ፥ ናኣቶ'' ማዔቶዋ ጎዦ ሃሻ''ሢ ቢያ ፄኤታ ጳንጬ ማሂ ዔካንዳኔ፤ ሃሣ ናንጊና ናንጎዋ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ጋዓንቴ ቤርታ ማዔ፥ ጎኦቦ'' ማላ ሚርጌ ዓሳ ጊንሢም፤ ጊንፃ ዓቴ'' ላቤያ ማላ ሚርጌ ዓሳ ቤርቲም ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ዬካፓ ዬሱሴ፦ «ጫሪንጮ ካኣቱማ ፔኤኮ ዎይኖ ጎዦ ጎሽኪሳኒ ጎሽካ ዓሶ ኮዒ ጉቴ'' ዓሚ'' ኬስኬ ዓሲ ማላኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ዒዚ ፔቴ'' ፔቴ'' ዓሶም ፔቴ'' ፔኤሺኮ ፔቴ'' ኬሊ'' ማዻዛ ዒንጎ ሚኢሾ ጪጋኒ ዓሶና ጌስቲ ጊኢጊ ጎዦ ቤዞ ዓሶ ዳኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ዬሱሴ ኬኤዛዖ፦ «ዬይ ዓሢ ጉቴ'' ሶኦፓ ዎዴኮ ቤርታ ቦኦኮ'' ቤዞ ኬስኪ ማዾ ባይቄም ዔቂ ዓኣ ዓሲ ዴንቂ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‹ዒንሢ ታኣኮ ዎይኖ ጎዦይዳ ዴንዲ ማዹዋቴ፤ ታ ዒንሢም ኮይሳሢጉዲ ጪጋንዳኔ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ዔያታ ዓኣዼኔ። ሃሣ ዓባ'' ሳዛ ሄላ''ኣና ጊንሣ ማሢ ዶምቦልሳ ዎዴ ማዓኣና ኬስኪ ሜሌ'' ማዻንዳ ዓሲ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ዬካፓ ዓባ'' ዒባናኣና ኬስኪ ማዾ ባይቄም ዔቂ ዓኣ ሜሌ'' ዓሲ ዴንቃዖ፥ ‹ማዾ ባኣያ ሃይካ ዒንሢ ዓይጋ ዔቂ ፔኤቃይ?› ጌዒ ዖኦጫዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ዔያታ ማሃዖ ‹ኑና ማዺሻኒ ጋዓ ዓሲ ባይቄሢሮኬ› ጌዔኔ፤ ዓሢ ዬያ ዋይዛዖ ‹ዒንሢያ ዓኣዺ ታኣኮ ዎይኖ ጎዦይዳ ማዹዋቴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«ዬካፓ ሳዓ ዓማዛ ጎዦ ዓዳሢ ማዻ ዓሶኮ ሱኡጋሢም ‹ጋፒንፃ ሙኬዞንሢዳፓ ዓርቃዖ ቤርታ ሙኬ ዓሶ ሄላ''ንዳኣና ማዾ'' ዓሶ ቢያ ዔኤሊ'' ዔያታ ማዼሢ ዛሎ'' ዔያቶም ጪጌ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ዒማ''ና ዓባ'' ዒባናኣና ማዻኒ ሙኬ ዓሶንሢ ሚኢሾ ጪጋሢ ኮይላ''ፓ ፔቴ'' ኬሊ'' ማዼም ዒንጎ ሚኢሾ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ቤርታ ማዾ'' ዓርቄዞንሢ ዒማ''ና ባሼ ኑም ጪጎንዶኔ ጌዒ ማሌኔ፤ ጋዓንቴ ዔያቶማኣ ፔቴ'' ኬሊ'' ማዼም ዒንጎ ሚኢሻ ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ጪጎና ሚኢሾ ዔያታ ዔካዖ ጉንዱሚሢና ጎዦ ዓዶ ኮራ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹ሃንሢ ዓባ'' ዒባናንቴ ማዾ''ሮ ሙኬዞንሢ ዻካ'' ሌሊ ማዻዛ ሮኦሪ ማዾ''ና ላቢ''ንቲ ዓቦ'' ሩኡጳ ሜታዺ ፔኤቄ ዓሶ፥ ኑኡና ዎላ'' ሄኮ ዎይቲ ኔ ዔያቶም ጪጋይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«ጎዦ ዓዴ ዬያ ማዻሢ ኮራ ‹ታ ዒሻሢዮ፥ ታ ፑርታ ኔኤም ማዺባኣሴ፤ ፔቴ'' ኬሊ'' ማዼም ጪጎ ሚኢሾም ማዻኒ ኔ ታኣና ዎላ'' ጌስቲ ጊኢጊባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ሃኣዛጌ፤ ኔኤሮማ ዔኪ ዓኣዼ፤ ኔኤም ታ ዒንጌሢጉዴያ ጋፒንፃ ሙኬ ዓሢማኣ ታ ዒንጋኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ታኣኒ ታ ሚኢሾና ኮዔ ባኣዚ'' ማዻኒ ዳንዳዑዋዓዳ? ጊንሣ ሃሣ ሚጪንታያ ታ ማዔሢሮ ኔና ቂኢሪሻ?› ");
INSERT INTO mdybse_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«ዬያሮ ቤርታ ማዔ፥ ጎኦቦ'' ማላ ሚርጌ ዓሳ ጊንሢም፤ ጊንፃ ዓቴ'' ላቤ''ያ ማላ ሚርጌ ዓሳ ቤርቲም ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ዬሱሴ ዬሩሳላሜ ዓኣዺፆይዳ ዓኣዖ፦ ታጶ ላምዖ ዒዛኮ ጊንፆ ሃንታዞንሢ ሌሊ ዱማሲ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ሃኣዛጉዋቴ፥ ሃሢ ኑ ዬሩሳላሜ ዓኣዻኔ፤ ዓሲኮ ናዓሢ ቄኤሶኮ ሱኡጎና ሙሴ ዎጎ ዔርዛ ዓሶናም ዓኣሢንቲ ዒንጊንቴም ዔያታ ዒዛ ሃይቃንዳጉዲ ጌዒ ጌስቲ ዎጋንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ዔያታ ቦሃንዳጉዲና ዢራፓና ጳርቃንዳጉዲ ሃሣ ሱፃንዳጉዲ ዓይሁዴ ማዒባኣ ዓሶም ዓኣሢ ዒንጎንዶኔ፤ ዬካፓ ሃይቂ፥ ሃይባ''ፓ ሃይሣሳ ኬሎ''ና ዒ ዔቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ዬካፓ ዜብዲዮሴ ማቻ ፔ ናኣቶ''ና ዎላ'' ዬሱሴ ኮይላ'' ሙኪ ዒዛም ጉምዓቲ ዚጋዖ ፔቴ'' ባኣዚ'' ዒዞም ማዺንታንዳጉዲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ዬሱሴ፦ «ዓይጌንዴ ኔ ኮዓይ?» ጌዔኔ። ዒዛ፦ «ኔ ካኣቱሞ ቤዛ ሃንሢ ታኣኮ ላምዖ ናኣቶ''ንሢ፦ ፔቴ''ሢ ኔኤኮ ሚዛቃ፥ ፔቴ''ሢ ኔኤኮ ሻውሎ'' ዛላ'' ኔኤና ዎላ'' ዎይሣያ ማዓንዳዳጉዲ ማሂ ዴይሤ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ዬሱሴ ጋዓንቴ፦ «ዓይጎ ሺኢቆንዶቴያ ዒንሢ ዔሩዋሴ፤ ታኣኒ ሃሢ ዑኬ ዔካንዳ ሜታሢ ዒንሢ ዔካኒ ዳንዳዓ? ሃሣ ታ ጌላንዳ ሜታስካ ዒንሢ ጌላኒ ዳንዳዓንዳ?» ጋዓዛ፥ ዔያታኣ፦ «ሂዮ፤ ኑ ዳንዳዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ዬካፓ ዬሱሴ፦ «ጎኔ ዒንሢ ታ ዔካንዳ ሜታሢ ዔካንዳኔ፤ ጋዓንቴ ታኣኮ ሚዛቆና ሻውሎ''ናይዳ ዴዒ ታኣና ዎላ'' ዎይሣንዳጉዲ ማሃሢ ታናቱዋሴ፤ ዬይ ቤዛ ዒንጊንታሢ ታ ዓዴ ጊኢጊሼዞንሢምኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ዬማ''ና ዓቴ'' ታጶ ዒዛኮ ጊንፆ ሃንታዞንሢ ዬያ ዋይዜ ዎዶ''ና ላምዖንሢ ዑፃ ጎሪ''ንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ዬሱሴ ጋዓንቴ ቢያሢ ፔ ባንሢ ዔኤላ''ዖ፦ «ዓይሁዴ ማዒባኣ ዓሶኮ ሱኡጎንሢ ዴሮ'' ዎይሣዞንሢኬ፤ ዬያጉዲ ዴሮ'' ሱኡጎንሢኮ ዴሮ'' ዑፃ ቢታንቶ ዓኣሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ዒንሢ ባኣካ'' ጋዓንቴ ያዺ ማዓንዳያ ኮይሱዋሴ፤ ዒንሢዳፓ ባሼ ማዓኒ ኮዓሢ ዒንሢኮ ዴማ'' ማዻያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ዒንሢዳፓ ዑፃ ማዓኒ ኮዓሢ ዒንሢኮ ዴማ'' ዓይሌ'' ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ዓሲኮ ናዓሢ ዓሲ ዒዛም ማዻንዳጉዲቱዋንቴ፥ ዓሲም ማዻኒና ሼምፓሢ ፔኤሲ'' ሚርጌ ዓሶ ዛሎ'' ባይዛኒ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ዒያርኮይዳፓ ኬስኪ ዓኣዻኣና ሚርጌ ዴሬ ዒዛና ዎላ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ዒኢካ ላምዖ ዓኣፒ ባይቄ ዓሲ ጎይፆ ዓጫ ዴዒ ዓኣዖ፥ ዬሱሴ ዒኢና ዓኣዻሢ ዋይዚ፦ «ዳውቴ ናዓሢዮ፥ ጎዳ! ኑና ማኣዴ''!» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ዴራ'' ዒማ''ና ዚቲ ጋዓንዳጉዲ ዔያቶ ጎራ''ዛ፥ ዔያታ ጋዓንቴ ኮሺ'' ዼ'ጊዲ፦ «ዳውቴ ናዓሢዮ፥ ጎዳ፥ ኑና ማኣዴ''!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ዒማ''ና ዬሱሴ ዴንዲቤቃ ዔቃዖ፥ ዔያቶ ዔኤሊ''፦ «ዓይጎ ታ ዒንሢም ማዻንዳጉዲ ዒንሢ ኮዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ዔያታ ማሃዖ፦ «ዓኣፓ ኑኡኮ ዛጋንዳጉዲ ኑ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ዬሱሴ ዔያቶ ሚጪንታዖ፥ ዓኣፖ ዔያቶኮ ፔ ኩጮና ካኣማዛ ቤዞማና ዛጊ ዒዛ ጊንፆ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ዬሩሳላሜ ሄላ''ኒ ዑካዖ፥ ዛይቶ ሪሚቶ ዹኮ'''' ኮይላ'' ዓኣ ቤቴፓጌ ጌይንታ ጉርዶ ሄሌ''ኔ። ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ላምዖንሢ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«ሓኖ'' ሴኮ ቤርታ ዓኣ ጉርዴሎ ዓኣዹዋቴ፤ ዒኢካ ዒንሢ ሄሄላ''ዖ ፔቴ'' ቱኡቲ ዓኣ ሃሬ ናዖና ዎላ'' ዴንቃንዳኔ፤ ዬያሮ ዬማ ሃሮ''ማ ቡሊ'' ዔኪ ታኣም ዬዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ዖኦኒያ ዒንሢ ኮራ ዔኤቢ ጌዔቶ ‹ጎዳ ዔያቶ ኮዓኔ› ዒንሢ ጋዓዛ ቤዞማና ዔያታ ዳካንዳኔ» ጌዒ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ዬይ ያዺ ማዓኒ ዳንዳዔሢ' ፆኦሲ ማሊፆ ኬኤዛሢ ዛሎ''ና፦ ");
INSERT INTO mdybse_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ሚዛጲ ዉዱሮ ናይ ማላ ዬሩሳላሜ ካታሜ''ሎም ‹ሓይሾ ኔኤኮ ካኣታ''ሢ ሚጪንታያ ማዒ ሓሬ''ሎ ሃሣ ሓሬ''ሎኮ ናዖ ቶጊ ኔ ባንሢ ሙካኔ› ጎዑዋቴ» ጌይንቴሢ ኩማ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ዬያሮ ዒዛኮ ጊንፆ ሃንታዞንሢ ዬሱሴ ዓይሤ ጎይፆ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ሓሬ''ሎዋ ናዖማና ዎላ'' ዔኪ ሙካዖ ፔኤኮ ዓፒሎ ዔያታ ሃሮ''ንሢ ዑፃ ጌሣዛ ዬሱሴ ቶጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ዬማና ዴሮ''ይዳፓ ሚርጌሢ ዓፒሎ ፔኤኮ ጎይፃ ሂኢሣዛ፥ ዛላ'' ሃሣ ዋላሺ ሜንሢ ሜንሢ ጎይፃ ሂኢሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ዒዛኮ ቤርታ ቤርታ ዓኣዻ ዓሶና ጊንፆ ሙካ ዓሳ፦ «ዳውቴ ናዓሢም ጋላታ ማዖንጎ! ጎዳ ሱንፆና ሙካሢ ፆኦሲ ዓንጆንጎ! ጋላታ ጫሪንጮይዳ ፆኦሲም ማዖንጎ» ጌዒ ጌዒ ዒላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ዬሱሴ ዬሩሳላሜ ካታሞ ጌሌ ዎዶ''ና ዓሳ ጉቤ፦ «ሃይ ዖናዳይ?» ጌይሢና ዎኦቶንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ዒዛና ዎላ'' ሙካ ዓሳ፦ «ሓይ ጌሊላይዳ ዓኣ፥ ናዚሬቴ ካታሜ''ሎይዳፓ ሙኬያ፥ ፆኦሲ ማሊፆ ኬኤዛ ዬሱሴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ዬካፓ ዬሱሴ ጌኤዦ ማኣሪ ጌሊ፥ ጌኤዦ ማኣሮ ጋሮይዳ ሻንቻ ዓሶና ሻንቃ ዓሶና ዳውሲ ኬሴ''ኔ፤ ሃሣ ሚኢሾ ላኣማ ዓሶኮ ዼ'ጌ ሎኦዦ ዖይቶና ዶኦሎ'' ሻንቻ ዓሶኮ ዴዖ ዖይቶዋ ሂዒ ዶይሳዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","« ‹ማኣራ ታኣኮ ሺኢጲሢ ማኣሪ ጌይንታንዳኔ› ጌይንቲ ፃኣፒንቴኔ፤ ዒንሢ ጋዓንቴ ‹ዉሲ ዓኣሺንታ ቤሲ› ማሄኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ዒማ''ና ጌኤዦ ማኣሮይዳ ዓኣፓ ባይቄ ዓሶንታ ዎቦ ዓሶንታ ዒዛ ኮራ ሙካዛ ዒዚ ዔያቶ ፓሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ጋዓንቴ ቄኤሶኮ ሱኡጎና ሙሴ ዎጎ ዔርዛዞንሢና ዬሱሴ ማዻ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮ ዛጌሢሮ ሃሣ «ዳውቴ ናዓሢም ጋላታ!» ጌዒ ጌዒ ዒላታ ናኣቶ'' ዋይዜሢሮ ሚርጌና ዻጋዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ዔያታ ዬሱሴ ኮራ፦ «ሓይ ናኣታ'' ጋዓ ባኮ ኔ ዋይዙዋዓዳ» ጌዔኔ። ዬሱሴ ማሃዖ፦ «ሂዮ፥ ታ ዋይዛኔ፤ ጌኤዦ ማፃኣፖይዳ ‹ዻኮ'' ናኣቶ''ንታ ዻንቃ ናኣቶ''ንታ ኔና ጋላታንዳጉዲ ኔ ማሄኔ› ጋዓሢ ዒንሢ ፔቴ''ታዖ ናባቢባኣዓዳ?» ጌዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ዬካፓ ዬሱሴ ዔያቶ ሃሺ'' ካታማ''ፓ ኬስካዖ፥ ቢታኒያ ጌይንታ ጉርዶ ዴንዲ ዒኢካ ዎርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ዚሮ ጉቴ''ሎ ዬሱሴ ጉቴ'' ዓማ'' ሓንጋ ካታሞ ማዒ ሙኪቤቃ ናይዺንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ዒማ''ና ጎይፆ ዓጮይዳ ፔቴ'' ቤሌሴ ሚሢ ዴንቃዖ ዒዞ ባንሢ ዴንዲ፥ ዒላሺዳፓ ዓታዛ ፔቴ''ታዖ ዓኣፒ ዴንቂባኣሢሮ፦ «ሃይፓ ሴካ ዓኣፒ ዓኣፒፖ!» ጋዓዛ፥ ቤሌሶ ሚፄላ ዬካፓ ኔጉዋዖ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ዒዛኮ ጊንፆ ሃንታዞንሢ ማዔ ባኮ ዛጋዖ ዲቃቲ ሄርሺሢና፦ «ቤሌሶ ሚፄላ ዎይቲ ዑኬና ሃይቃኒ ዳንዳዔይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ዬሱሴ ማሃዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒንሢኮ ጉሙርቂሢ ዓኣቶ ሃሣ ‹ማዓንዳሞ ማዒንዱዋይ› ዒንሢ ጌይባኣቶ ቤሌሶ ሚፄሎይዳ ማዔ ባኮ ማዻኒ ሌሊቱዋንቴ ሃያ ዹኮ'' ‹ሃይካፓ ዔቂ ባዞ'' ጌሌ› ዒንሢ ጌዔቴታዖ ማዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ዒንሢኮ ጉሙርቂሢ ዓኣቶ ዒንሢ ሺኢቃ ባኮ ቢያ ዒንሢ ዴንቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ዬሱሴ ጌኤዦ ማኣሮ ጌሊ ዔርዚፆይዳ ዓኣንቴ ቄኤሶኮ ሱኡጎና ዴሮ''ኮ ጪሞና ሙካዖ፦ «ሓያ ቢያ ኔ ማዻ ባኮ ማዻሢ ዓይጎ ቢታንቶናዳይ? ሓያ ቢታንቶ ኔኤም ዒንጌሢያ ዖናዳይ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ዬሱሴ ማሃዖ፦ «ታኣኒያ ፔቴ'' ባኣዚ'' ዒንሢ ዖኦጫንዳኔ፤ ዬኖ ዒንሢ ታኣም ማሄቶ ታኣኒ ሃያ ባኮ ዓይጎ ቢታንቶና ማዻቴ ዒንሢም ኬኤዛንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ማስካ ዮሓኒሴኮ ዋኣፆና ማስኪፃ ዓንካፓዳይ? ፆኦሲዳፓሞ ዓሲዳፓዳይ?» ጌዔኔ። ዬያሮ ዔያታ ዎላ'' ጌስታዖ፦ «‹ፆኦሲዳፓኬ› ኑ ጌዔቶ ‹ሂዳዖ ዒንሢ ዓይጎሮ ዒዛሲ ጉሙርቂባኣይ?› ዒ ጋዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‹ዓሲዳፓኬ› ኑ ጌዔቶ ሃሣ ማስካ ዮሓኒሴ ዓሳ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ማሂ ዛጋሢሮ ዴራ'' ኑና ዒጊቻኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ዬካፓ ዔያታ ዬሱሴም፦ «ኑኡኒ ዔሩዋሴ» ጌዒ ማሃዛ፥ ዒዚያ፦ «ታኣኒያ ሂዴቶ ዓይጎ ቢታንቶና ሃያ ቢያ ማዻቶ ዒንሢም ኬኤዛዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ዬካፓ ዬሱሴ፦ «ሂንዳ ዒንሢም ዓይጎ ማላቶዋ? ፔቴ'' ባኣዚ'' ታ ዒንሢም ኬኤዞም፤ ፔቴ'' ዓሲኮ ላምዖ ናይ ዓኣኔ፤ ዔያቶይዳፓ ፔቴ''ሢ ኮራ ዓዳሢ ሙካዖ ‹ታ ናዓሢዮ! ሓኖ'' ጎዦ ዴንዲ ማዾ ማዼ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ናዓሢ ‹ዴንዳዓ፥ ዒፄኔ› ጌዔኔ፤ ያዺ ዒ ጌዔዖ ጊንፃፓ ዻቢንቲ ማዔሢ ዔሪ፥ ማዾ'' ማዻኒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ሓሣ ዓዳሢ ባጎ ናዓሢ ኮራ ዴንዳዖ፥ ዒዚያ ዴንዲ ማዻንዳጉዲ ዓይሣዛ ናዓሢ ‹ዔኤዔ፥ ታ ዓኣዻንዳኔ› ጌዔኔ፤ ጋዓንቴ ማዻኒ ዴንዲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ዓካሪ ዬንሢ ላምዖ ናኣቶ''ንሢዳፓ ዓዶኮ ዓይሢፆ ኩንሤሢ ዎያዳይ?» ጋዓዛ፥ ዔያታ፦ «ቤርታኣ ናዓሢሾ!» ጌዔኔ። ዬሱሴያ ማሃዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ኮርሞ ዓሶፓ ሚኢሾ ቡኩሳ ዓሶና ዓኒ ሃሣ ማቾ ማዒባኣ ዓሶና ላሃ ዓሳ ፆኦሲ ካኣቱሞይዳ ዒንሢ ቢሪ ጌላንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ማስካ ዮሓኒሴ ጌኤሹሞ ጎይሢ ዒንሢ ዻዋኒ ዒንሢ ኮራ ሙካዛ ዒንሢ ዒዛሲ ጉሙርቂ ዔኪባኣሴ፤ ሚኢሾ ቡኩሳ ዓሶና ዓኒ ሃሣ ማቾ ማዒባኣ ዓሶና ላሃ ዓሳ ጋዓንቴ ጉሙርቂ ዒዛሲ ዔኬኔ። ዒንሢ ዬያ ዛጌሢኮ ጊንፃኣታዖ ጎሞ ዒንሢኮ ቡኡፂ ጎናሲ ዒዛሲ ዔኪባኣሴ።» ");
INSERT INTO mdybse_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ሓሣ ዬሱሴ ሜሌ'' ማሊሢ ኮኦኪንሢና፦ «ፔቴ'' ዎይኔ ጎሺ ዓኣ ዓሲ ጎዦኮ ቲኢፆ ዲርቂ፥ ዎይኖ ጩኡጶንዶ ዔቴያ ላሌ ሹቺዳ ቦኦኪ ኮሼ''ኔ፤ ሃሣ ካፒፆም ማዓ ሴኤላኣ ሴኤሊ''፥ ዬካፓ ጎዦ ዒዛማኣ ጎሽካንዳ ዓሲም ዒንጊ ሜሌ'' ዓጪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ዎይና ካፄ ዎዶ''ና ዒዛ ሄላ'' ዛሎ'' ዓሶ ኮይላ''ፓ ዔኪ ዬዓንዳጉዲ ዒዛኮ ማዻ ዓሶ ጎሽካ ዓሶ ኮራ ዒ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ጎሽካ ዓሳ ጋዓንቴ ዓሢኮ ማዻ ዓሶ ዓርቃዖ ፔቴ''ሢ ጳርቂ፥ ባጋሢ ዎዺ ሃሣ ዓቴ''ሢያ ሹቻ ዹይ ዑሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ዬይ፥ ጎዦኮ ዓዳሢ ላሚ ሃሣ ቤርታኣሲዳፓ ሚርጌ ዒዛኮ ማዻ ዓሲ ዳካዛ፥ ጎሽካ ዓሳ ሃሣ ቤርታ ማዼ ጎይፆ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ጋፒንፆይዳ ጎዦኮ ዓዳሢ ‹ታኣኮ ናዓሢ ዔያታ ቦንቹዋዖ ዓታዓ!› ጋዓዖ፥ ናዓሢ ፔኤኮ ጎሽካ ዓሶ ኮራ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ጎሽካ ዓሳ ጋዓንቴ ናዓሢ ዴንቄ ዎዶ''ና ‹ሃይ ዒዛ ዻካላሢኬ፤ ሃኒ ሙኩዋቴ ዒዛ ኑ ዎዺ ዒዛኮ ዓኣ ባኮ ዻካሎም› ዎሊ ኮይላ'' ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ናዓሢ ዓርቂ ጎዦኮ ዙላ'' ዔኪ ዴንዲ ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«ዓካሪ ዬኖ ጎዤሎኮ ዓዳሢ ሙካዖ ዬንሢ ጎሽካ ዓሶንሢ ዎዳ''ንዳያ ዒንሢም ማላይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ዔያታ ማሃዖ፦ «ዬንሢ ፑርቶ ዓሶንሢ ሚጪንቱዋዖ ዒ ዎዎዻንዳኔ፤ ዎይና ካፄ ዎዶ''ና ቢያ ዒዛም ዒንጋንዳ፥ ሜሌ'' ጎሽካ ዓሲም ጎዦ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ዬካፓ ዬሱሴ፦ « ‹ማኣሮ ማዣ ዓሳ ቦሂ ሃሼ'' ሹጫሢ ማኣሮኮ ሄላሢ ማዔኔ። ዬይያ ፆኦሲ ማዾኬ፤ ኑ ዛጋዛ ዓኪ ባኣዚ''ኬ› ጌይንቲ ፃኣፒንቴሢ ዒንሢ ፔቴ''ታዖ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ዬያሮ ታ ዒንሢም ሂዚ ጋዓኔ፤ ፆኦሲ ካኣቱማ ዒንሢዳፓ ዔውቲ ዓኣፒ ዓኣፓ ዴሬም ዒንጊንታንዳኔ።  ");
INSERT INTO mdybse_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ዬያ ሹጫሢዳ ሎኦማሢ ሜቃንዳኔ፤ ሃሣ ዬይ ሹጫሢ ዒዛ ዑፃ ዶዔ ዓሢያ ዳኣፂንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ዒማ''ና ቄኤሶኮ ሱኡጎና ፔርሴ ዓሶና ዬንሢ ኮኦኪንሦንሢ ዋይዜ ዎዶ''ና ዬሱሴ ዔያቶም ጫርጌሢ ዔሪ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ዒዛ ዓርቂ ቱካ''ኒ ኮዔኔ፤ ጋዓንቴ ዴራ'' ዬሱሴ ፆኦሲ ማሊሢ ኬኤዛያ ማሂ ዛጋሢሮ ዔያታ ዒጊጪ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ዬሱሴ ሃሣ ሜሌ'' ኮኦኪንሢ ኬኤዛዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ጫሪንጮ ካኣቱማ ናዓ ላኣሊ ዔካኣ ጌዔም፥ ሙኡዚ'' ጊኢጊሼ ካኣቲስኬያ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ዬይ ካኣታ''ሢ ዔኤሊ''ንቴ ዓሶም ኬኤዛንዳጉዲ ዒዛኮ ማዻ ዓሶ ዳኬኔ፤ ጋዓንቴ ዓሳ ዒኢካ ሙካኒ ኮይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ዬካፓ ካኣቲ ላሚ ሃሣ ሜሌ'' ማዻ ዓሲ ዔኤሊ''ንቴ ዓሶም፦ ‹ቡዋ ጌማይንታ ሃሣ ማሌ'' ባይያ ታ ሹኪ ሙዖ ጊኢጊሼኔ፤ ቢያ ባካ ጊኢጌያ ማዔሢሮ ዔፖ ቤዞ፥ ታ ማኣሪ ሙኩዋቴ ጎዑዋቴ› ጌይ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ዔኤሊ''ንቴ ዓሳ ጋዓንቴ ዔኤሊ''ፆ ቦሂ ዛላ'' ጎሺዳ፤ ዓቴ'' ዓሳ ሃሣ ኮርሞይዳ ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ሃንጎዋታ ሃሣ ኪኢቶ''ና ሙኬ ዓሶንሢ ዓርቃዖ ጳርቂ ቦርሲሲ ሃሣ ሜታሲ ዎዺያ ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ዬያሮ ካኣታ''ሢ ዻጋዻዖ ፔኤኮ ፖኦሊሶ ዳኪ ዬንሢ ኪኢቶ'' ዓሶንሢ ዎዼዞንሢ ዎዺ ባይዚ ካታሞዋ ዔያቶኮ ታሚና ሚቼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ዬካፓ ካኣቲ ማዻ ዓሶም፦ ‹ዔፖ ሙዓ ጊኢጊንቴኔ፤ ዔኤሊ''ንቴ ዓሳ ጋዓንቴ ኮይሱዋ ዓሲ ማዒ ጴዼሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ጎይፆ ኬስኪጋፓ ዴንቄ ዓሲ ቢያ ዔፖ ሙዖ ቤዞ ዔኤሉ''ዋቴ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ማዻ ዓሳ ጎይፆ ኬስኪ ዴንቄ ዓሶ ኮዦንታ ፑርቶንታ ቢያሢ ቡኩሲ ዔፖ ማኣሮ ሾኦጮና ኩንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«ዬካፓ ካኣቲ ዔኤሊ''ንቴ ሾኦጮ ዛጋኒ ጌሌ ዎዶ''ና ፔቴ'' ዔፒ ማኣዖ ማይንቲባኣ ዓሲ ዴንቃዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‹ታ ቤኤሊ''! ዔፒ ማኣዖ ኔ ማይንቱዋዖ ሃይካ ጌላኒ ዎይቲ ዳንዳዔይ?› ጋዓዛ፥ ዓሢ ጋዓንቴ ዚቲዮ ጌዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ካኣቲ ማዻዞንሢም ‹ሃያኮ ኩጮና ቶኮና ቱኪ''፥ ኬሲ'' ካሮ''ይዳ ዹሞ ቤዛ ኬኤሩዋቴ፤ ዒኢካ ዒ ዬኤኪ፥ ሜታዺ ዓቺ ዻዓንዳኔ።› ");
INSERT INTO mdybse_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«ሚርጌ ዓሲ ዔኤሊ''ንቴኔ፤ ዶኦሪንቴ ዓሳ ጋዓንቴ ዻካ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ዬካፓ ፔርሴ ዓሳ ኬስኪ ዴንዲ፥ ዬሱሴ ጌስታ ጌኤዞና ዎዲ'' ዔያታ ፒሪ ዓርቃንዳቴያ ዎላ'' ዞርታዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ዔያቶኮ ጊንፆ ሃንታ ናኣቶ''ና ሄሮዲሴ ዛላ''ፓ ማዔ ዓሶና ዬሱሴ ባንሢ ዳኪ፦ «ዔርዛሢዮ! ኔኤኒ ጎኔ ዓሲ ሃሣ ፆኦሲ ጎይፆዋ ጎኑሞና ዔርዛሢ ዬያጉዲ ሃሣ ዖናኣ ኔ ዱማሱዋዖ፥ ቢያሢ ሄኮ ኔ ዛጋሢ ኑ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ኑም ሂንዳ ኬኤዜ፤ ዓይጎ ኔኤም ማላይ? ሮሜ ዓጮ'' ካኣቲም ጊኢራ ጪጎንዶሞ ሃሾ''ንዶይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ዬማና ዬሱሴ ዔያቶኮ ጌኖ ማሊፆ ዔራዖ፦ «ዒንሢ ፂሎ''ቱዋዖ ፔና ፂሎ''ኬ ጋዓ ዓሳ! ዓይጎሮ ጌኤሲና ታና ዒንሢ ፒራኒ ኮዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ጊኢሮ ጪጎ ሚኢሾ ሂንዳ ታና ዻውዋቴ» ጋዓዛ፥ ዔያታ ፔቴ'' ሹቺ ቢራ ዒዛም ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ዬማና ዒዚ፦ «ሃኖ'' ሚኢሼሎይዳ ዓኣ ዓውካሮና ፃኣፒንቴ ሱ'ንፆና ዖኦሮዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ዔያታ፦ «ሮሜ ዓጮ'' ካኣቲሲኬ» ጌዔኔ። ዬካፓ ዒዚ ማሃዖ፦ «ሂዴቶ ሮሜ ዓጮ'' ካኣቲሲ ካኣቲም፤ ፆኦሲሲ ፆኦሲም ዒንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ዔያታ ዬያ ዋይዛዖ ዲቃቲ ሄርሺ፥ ዒዛ ሃሺ'' ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ዬኖ ኬሎ''ና፦ «ሃይቄ ዓሲ ዔቁዋሴ» ጋዓ ሶዶቄ ዓሳ ዬሱሴ ኮይላ'' ሙኪ ሂዚ ጌዒ ዖኦጬኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«ዔርዛሢዮ! ሙሴ ‹ፔቴ'' ዓሲ ላኣሊ ዔካዖ ሾውዋዖ ሃይቄቶ፥ ጌኤዚ ሃይቄሢ ማቾ ዔኪ ዒዛ ዻካላ ናይ ሾዖንጎ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ኑ ኮይሎ''ይዳ ዎሊኮ ጌርሲንሢ ማዓ ላንካይ ዓሲ ዓኣኔ፤ ዬያቶኮ ቶይዳሢ ላኣሊ ዔካዖ ሾውዋዖ ሃይቄም ሄሌ ጌኤዛሢ ማቾ ዒዛኮ ዔኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ዬይ ዔኬሢ ቶይዲም ናይ ሾውዋዖ ሃይቄኔ፤ ዬያይዴ ጎይሣ ላኣሌላ ላንካሳሢም ሄላ''ዛ ዒዚያ ሾውዋዖ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ዬካፓ ጋፒንፆይዳ ላኣሌላ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ዓካሪ ቢያሢ ዒዞ ዔኬሢሮ ጋፒንፆና ሃይባ''ፓ ዓሳ ዔቃኣና ዬና ዎያኮ ማቾ ማዓንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ዬሱሴ ማሃዖ፦ «ዒንሢ ጌኤዦ ማፃኣፖና ፆኦሲኮ ዎልቆና ዔሩዋኣሢሮ ዻቢንታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ሃይቢዳፓ ዓሲ ዔቄሢኮ ጊንፃ ጫሪንጮይዳ ዓኣ ፆኦሲ ኪኢታንቾጉዲ ማዓኔ፤ ዔኩዋሴ ሃሣ ሎዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ሃይቦ''ይዳፓ ዔቃ ዓሶ ዛሎ'' ፆኦሲ ዒንሢም ኬኤዜሢ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ዒዚ ‹ታኣኒ ዓብራሃሜ ፆኦሲ፥ ዪሳኣቄ ፆኦሲ ሃሣ ያይቆኦቤ ፆኦሲኬ› ጌዔኔ፤ ዬያሮ ፆኦሲ ሼምፖና ናንጋ ዓሶ ፆኦሲ፤ ሓይቄቶዋ ናንጊና ናንጋ ዓሶ ፆኦሲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ዴራ'' ዬያ ዋይዛዖ ዒዛኮ ዔርዚፆና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ዬሱሴ ሶዶቄ ዓሶ ጎዖንዶ ጎይሢ ባይዚሴሢ ዋይዛዖ ፔርሴ ዓሳ ፔቴ''ይዳ ሙኪ ቡኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ዔያቶይዳፓ ፔቴ'' ሙሴ ዎጎ ዔርዛስኬይ ዬሱሴ ዎዚ ጋዓቴያ ዋይዛኒ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«ዔርዛሢዮ! ቢያፓ ባሼ ዓይሢፄላ ዎኖዳይ?» ጌዒ ዖኦጬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ዬሱሴ ዒማ''ና፦ « ‹ፆኦሲ ኔኤኮ ጎዳ ጉቤ ዒናፓ፥ ጉቤ ሼምፓፓ፥ ጉቤ ማሊፃፓ ናሽኬ› ");
INSERT INTO mdybse_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ቢያፓ ባሼ ማዔ ቤርታኣ ዓይሢፃ ዬኖኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ሃሣ ዬኖ ማላ ላምዓሳ ዓይሢፃ ‹ዓሲ ቢያ ዓዳ'' ኔና ማሂ ናሽኬ› ጋዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ሙሴ ዎጎና ፆኦሲ ማሊፆ ኬኤዛዞንሢኮ ዔርዚፃ ዬንሢ ዓይሢፆ ጋራ ዓኣያኬ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፔርሴ ዓሳ ቡኪንቲ ዓኣንቴ ዬሱሴ ዔያቶ ሂዚ ጌዒ ዖኦጬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«ሜሲሔ ዛሎ'' ዒንሢ ዎዚ ጋዓይ? ዒ ዖ ናይ ዒንሢም ማላይ?» ጋዓዛ፥ ዔያታ ማሃዖ፦ «ዒ ዳውቴ ናይኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ዬሱሴ ዔያቶም፦ «ሂዴቶ ዳውቴ ዓያና ጌኤሺ ዒዛ ማሊሴም፥ ‹ታኣኮ ጎዳ› ጌዒ ዎይቲ ዒዛ ዔኤሌ''ይ? ");
INSERT INTO mdybse_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ዳውቴ፡ ‹ናንጊና ናንጋ ጎዳ ታ ጎዳሢም፥ ኔኤኮ ሞርኮ ታ ኔና ባሺሳንዳያ ሄላ''ንዳኣና ታኣኮ ሚዛቆ ዛላ'' ዴዔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ዬያሮ ዳውቴ ‹ታ ጎዳሢ› ጌዒ ዒዛ ዔኤሌ''ቶ ዎይቲ ዳውቴኮ ናይ ማዓኒ ዒ ዳንዳዓይ?» ዬሱሴ ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ዒማ''ና ፔቴ''ታዖ ዔኤቢ ማሂ ኬኤዛኒ ዳንዳዔ ዓሲ ባኣሴ። ዬኖ ኬሎ''ይዳፓ ዓርቃዖ ጫርቂ ዒዛ ዔኤቢ ዖኦጬ ዓሲያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ዬካፓ ዬሱሴ ዴሮ''ና ዒዛኮ ጊንፆ ሃንታዞንሢናም፦ ");
INSERT INTO mdybse_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶናኮ ሙሴጉዲ ዎጎ ዔርዛኒ ቢታንቶ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ዬያሮ ዒንሢም ዔያታ ጋዓ ባኮ ማዹዋቴ፥ ሃሣ ካፑዋቴ፤ ጋዓንቴ ዔያታ ጋዓሢጉዲ ፔኤሮ ማዹዋኣሢሮ ዔያቶጉዲ ማዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ዔያታ ሚርጌ ዴኤሢ ሃሣ ሜታሳ ኬዲ ዓሲ ኬዲሳኔ፤ ዔያታ ፔኤሮ ጋዓንቴ ኩቻ ካኣማኒያ ኮዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ዔያታ ማዻ ማዻ'' ቢያ ዓሲ ዛጎም ጌዒኬ፤ ዬያሮ ካኣዦ ዛሎ'' ባኮ ፃኣፒ ቶኦካ'' ሓሣ ቃሳ'' ቱኮ'' ዓፒሎዋ ዔያታ ኮሺ'' ዳልጊሻኔ፤ ሃሣ ዓፒሎኮ ማጫሮዋ ዖዶሳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ሙዖ ቤዞይዳ ቦንቺንታ ቤሲ፥ ዓሳ ቡኪንታ ቤዞይዳኣ ቤርቶ ዛላ'' ዴዓኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ዬያጉዲ ሃሣ ቦኦኮ'' ባኣኮ''ይዳ ኮሺ ዔኤሊ''ሢ ዔኤሊ''ንታኒና ‹ዔርዛሢ› ጌይንቲ ዔኤሊ''ንታኒያ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ዒንሢ ጋዓንቴ ሄርሺንቲሮ ‹ዔርዛሢ› ጌይንቲ ዔኤሊ''ንቲፖቴ፤ ዒንሢኮ ዔርዛሢ ፔቴ'' ሌሊ ማዓዛ ዒንሢ ቢያሢ ዎሊኮ ጌርሲንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ጫሪንጮይዳ ዒንሢኮ ፔቴ'' ዓዴ ሌሊ ዓኣሢሮ ሳዖይዳ ዖና ማዔቶዋ ፆኦሲፓ ባሼ ማሂ ‹ዓዴ› ጌይ ዔኤሊ''ፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ዒንሢኮ ባሼ ዔራሢያ ኪሪስቶሴ ሌሊ ማዔሢሮ ‹ባሼ ዔራሢ› ጌዒ ዔኤሊ''ንቲፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ዒንሢ ባኣካ'' ቢያፓ ዑሣ ዓኣዼ፥ ሱኡጌ ማዔሢ ዒንሢኮ ዴማ'' ማዒ ማዻያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ፔና ዼ'ጊዳሢ ዻውሲንታንዳኔ፤ ፔና ሂርኪዳሢ ጋዓንቴ ዼ'ግ ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ሃሣ ዬሱሴ፦ «ዒንሢ፥ ፂሎ''ቱዋዖ ፔና ‹ፂሎ''ኬ› ጋዓ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ! ዓሳ ጫሪንጮ ካኣቱሞይዳ ጌሉዋጉዲ ዓሶኮ ካሮ'' ዒንሢ ዎዻሢሮ ዒንሢና ባዴዔ! ዒንሢ ዒንሢሮ ጌሉዋሴ፤ ሃሣ ጌላኒ ኮዓ ዓሶዋ ዒንሢ ጌልዙዋሴ።»  ");
INSERT INTO mdybse_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ዒንሢ ፂሎ''ቱዋዖ ፔና ‹ፂሎ''ኬ› ጋዓ፥ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ ዒንሢ ባዴዔ! ዓኒንሢ ሓይቄ ላኣሎኮ ማኣሮ ዒንሢ ቡራያታዖ ዓሲ ‹ፆኦሲ ሺኢቃኔ› ዒንሢ ጎዖንጎ ጌዒ ዖዶሲ ሺኢጲሢ ዒንሢ ሺኢቃኔ፤ ዬያሮ ፑርታ ዎጌ ዒንሢዳ ዎጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«ዒንሢ ፂሎ''ቱዋዖ ፔና ፂሎ''ኬ ጋዓ፥ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ! ፔቴ'' ዓሲ ዓይሁዴ ካኣዦ ካኣሽኪሳኒ ባዞ'' ዋኣፆና ሳዖናይዳ ዒንሢ ሃንቲ፥ ካኣዣኣ ጌልዜሢኮ ጊንፃ ዒንሢዳፓ ባሼና ጋፒንፆ ኬላ'' ፑርታና ዬይ ዎጊንታንዳጉዲ ዒንሢ ማሃሢሮ ዒንሢ ባዴዔቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«ሃይ፥ ዒንሢ ዓኣፖ ባይቄ ዓርኖ ማዔ ዓሳ! ዒንሢና ባዴዔ! ‹ዓሲ ጌኤዦ ማኣሮ ዔኤሊ'' ጫኣቄቴ ዔኤቢባኣሴ፤ ጋዓንቴ ጌኤዦ ማኣሮኮ ዎርቆ ዔኤሊ'' ጫኣቄቴ ቶላ'' ካራ ባኣሴ› ዒንሢ ጋዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ዒንሢ ዔኤያ ሃሣ ዓኣፖ ባይቄ፥ ዓርኖ ማዔ ዓሳ! ዎርቆና ዎርቃ ፆኦሲም ዱማዼያ ማዓንዳጉዲ ማሃ ጌኤዦ ማኣሮናይዳፓ ዎና ባሼዳይ? ");
INSERT INTO mdybse_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ዬያጉዲ ሃሣ ‹ዓሲ ፆኦሲም ሚቺ ዒንጊ ካኣሽኮ ቤዞ ዔኤሊ'' ጫኣቄቴ ዔኤቢባኣሴ፤ ጋዓንቴ ፆኦሲም ሚቺ ዒንጎ ቤዞይዳ ዓኣ ዒንጎና ባኮ ዔኤሊ'' ጫኣቄቶ ቶላ'' ካራ ባኣሴ› ዒንሢ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ሃይ ዒንሢ ዓኣፖ ባይቄ ዓሳ! ፆኦሲም ዒንጎ ባኮና ዒንጎ ባኮ ዱማዼያ ማሃ ሚቺ ዒንጎ ቤዞናይዳፓ ዎና ባሼዳይ? ");
INSERT INTO mdybse_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ዬያሮ ፆኦሲም ዒንጎ ባኮ ዒንጎ ቤዞ ዔኤሊ'' ጫኣቃሢ ዒንጎ ቤዞና ዒዞ ዑፃ ዓኣ ዒንጊንቴ ባኮ ቢያሢ ዔኤሊ'' ጫኣቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ጌኤዦ ማኣሮ ዔኤሊ'' ጫኣቃሢ ጌኤዦ ማኣሮና ጋሮይዳ ናንጋ ፆኦዛሢና ዔኤሊ'' ጫኣቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ጫሪንጮ ዔኤሊ'' ጫኣቃሢ ፆኦሲ ዴዔ፥ ካኣቱሞ ዖይቶንታ ዒኢካ ዴዔሢንታ ዎላ'' ዔኤሊ'' ጫኣቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«ዒንሢ ፂሎ''ቱዋዖ ፔና ፂሎ''ኬ ጋዓ፥ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ፥ ዒንሢ ባዴዔቴ! ዻኮ'' ዱማ ዱማ ሳዉቃ ዼኤሾይዳፓ ቢያ ታጶይዳፓ ፔቴ''ማ ዒንጎ ዎጎና ዒንሢ ዒንጋኔ፤ ጋዓንቴ ዓይሢንቴ ዎጎ ጊዳ'' ዓኣ ዼኤፖ ባኮ ዒንሢ ሃሻ''ኔ፤ ዬይ፦ ፒዜ ዎጊሢ፥ ዻቤሢም ዓቶም ጌይሢና ጉሙርቂንቲሢናኬ፤ ዬያቶ ዒንሢ ቦሄኔ። ዬንሢ ዻኮ'' ባኮንሢ ዒንሢ ሃሺ''ባኣዖ ዬያ ባኮዋ ዒንሢ ማዻንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ዒንሢ ዓኣፖ ባይቄ፥ ዓርኖ ማዔ ዓሳ! ዑሽካ ባኮይዳፓ ዉኖጉዴ ዻኮ'' ባኮ ዒንሢ ኬሲ'' ኬኤራኔ፤ ጋኣላሢጉዴ ዼኤፖ ባኮ ጋዓንቴ ዒንሢ ዔኤዺ ዔኤዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«ዒንሢ ፂሎ''ቱዋዖ ፔና ፂሎ''ኬ ጋዓ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ፥ ዒንሢና ባዴዔ! ዋኣፆ ዑሽኮ ዓንዶና ካሦ ሙዖ ዓንዶናኮ ዙሎ'' ዒንሢ ማስኪ ጌኤሻኔ፤ ጋራ ጋዓንቴ ቡሪሢና ዱኡዹሞና ዒንሢኮ ኩሜ''ያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ሃይ ኔ ዓኣፖ ባይቄ ፔርሴ ዓሢ! ቤርታዺ ዋኣፆ ዑሽኮ ዓንዶና ካሦ ሙዖ ዓንዶናኮ ጋሮ ማስኪ ጌኤሼ፤ ዬያይዴቶ ዓካሪ ዙሎ'' ዛላ''ኣ ጌኤሺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«ዒንሢ ሃይ ፂሎ''ቱዋዖ ፔና ፂሎ''ኬ ጋዓ፥ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ! ዙሎ'' ዛላ'' ቦኦሪንቶና ሜኤቺ ሚዛጲሶናያ ጋራ ጋዓንቴ ሃይቄ ዓሲ ሜጌሢና ሌሲ''ና ኩሜ''ያ፥ ዱኡፒ ዒንሢ ማላሢሮ ዒንሢና ባዴዔቴ! ");
INSERT INTO mdybse_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ዒንሢ ዙሌ''ና ዓሶም ጌኤሺ ማላኔ፤ ጋራ ዒንሢኮ ጋዓንቴ ሄርሺንቲና ፑርቱሞና ኩሜ''ያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«ዒንሢ ፂሎ''ቱዋዖ ፔና ፂሎ''ኬ ጋዓ፥ ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሳ ዒንሢና ባዴዔ! ፆኦሲ ማሊፆ ኬኤዛ ዓሶኮ ዱኡፖ ኬልቂ ኮሺ'' ኮሺ''፥ ሃሣ ጌኤዦ ዓሶኮ ዱኡፖዋ ፓልሚሲ ኮሺ'' ኮሺ''፥ ");
INSERT INTO mdybse_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‹ኑ ዓዶንሢ ዎዶ''ናታቴ፥ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዎዺፆይዳ ኑ ጌላዓኬ› ዒንሢ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ሃይሾ ሃሢ ዒንሢ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዎዼ ዓሶኮ ናኣቶ'' ማዒፆ ዒንሢሮ ዒንሢ ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ዬያሮ ዓዶንሢ ዒንሢኮ ዓርቄ ዛኣሮ ዒንሢ ዑዑሩዋቴ! ");
INSERT INTO mdybse_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ሃይ ዒንሢ ሾኦዣ፥ ሾኦዦኮ ናኣታ'' ዒንሢ ሃይ! ጋፒንፆ ታሞ ዎጎይዳፓ ዎይቲ ዒንሢ ቶላ''ንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ዬያሮ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ፥ ዔሮ'' ዓሶንታ ዔርዛ ዓሶ ዒንሢ ባንሢ ታ ዳካንዳኔ፤ ዔያቶይዳፓ ፔቴ'' ፔቴ''ሢ ዒንሢ ዎዻንዳኔ፤ ሃሣ ፔቴ'' ፔቴ''ዞንሢ ዒንሢ ሱፃንዳኔ፤ ዓቴ''ዞንሢ ሃሣ ዒንሢኮ ቡኪንቶ ቤዞይዳ ዢራፓና ዒንሢ ጳርቃንዳኔ፤ ዔያቶ ዒፂ ፔቴ'' ካታማ''ፓ ሜሌ'' ካታማ ዒንሢ ዳውሲ ዳካንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ዬያ ዛሎ''ና ጌኤዣሢ ዓኣቤኤሌ ሃይቦ''ይዳፓ ዓርቃዖ ጌኤዦ ማኣሮና ፆኦሲም ዒንጎ ባኮ ሺኢሾ ቤዞናኮ ባኣካ'' ዒንሢ ዎዼ፥ ባራኪዮ ናኣዚ'' ዛካሪያሴ ሃይቦ'' ሄላ''ንዳኣና ሳዖይዳ ሃይቄ ጌኤዦ ዓሶኮ ሱጉፆ ዛሎ'' ዒንጊንታ ሜቶ'' ዒንሢ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዬይ ሜታ'' ሃኖ'' ዎዶ'' ዓሶ ሄላ''ንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ዬካፓ ዬሱሴ፦ «ዬሩሳላሜ! ኔኤኒ ፆኦሲ ማሊፆ ኬኤዛዞንሢ ዎዻዜሌ፥ ሃሣ ኔ ባንሢ ፆኦሲ ዳካ ኪኢቶ'' ዓሶ ሹጮና ዹዓዜሌ! ኮይዳ ፔኤኮ ጋኣዞ ዴማ'' ናኣቶ'' ቡኩሲ ዓርቃሢጉዲ ታኣኒ ኔ ናኣቶ'' ፔቴ''ይዳ ቡኩሳኒ ሚርጌና ኮዔንቴ! ኔ ዬያ ዒፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ዓካሪ ሃኣዛጉዋቴ፥ ፆኦሲ ሃሼ''ም ዒንሢኮ ጌኤዦ ማኣራ ባዓ ማዒ ዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ታ ዒንሢም ጋዓኔ፦ ‹ጎዳ ሱንፆና ሙካሢ ዓንጂንቴያኬ› ዒንሢ ጋዓንዳያ ሄላ''ንዳኣና ላሚ ዒንሢ ታና ዴንቃዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ዬሱሴ ጌኤዦ ማኣራፓ ኬስኪ ዴንዳኣና ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ጌኤዦ ማኣራ ማዢንቴ ጎይፆ ዻዋኒ ዒዛ ኮራ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ዒዚ ጋዓንቴ፦ «ሓያ ዒንሢ ቢያ ዛጋ? ጎኔ ታ ዒንሢም ጋዓኔ፤ ሓይ ሹጮና ኬልቂንቲ ማዢንቴ ማኣራ ፔቴ'' ሹቺታዖ ዓቱዋንቴ ዶዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ዬሱሴ ዛይቶ ሪሚቶ ዹኮ''ይዳ ዴዒ ዓኣንቴ ዒዛኮ ጊንፆ ሃንታዞንሢ ሌሊ ዒዛ ኮይላ'' ሙካዖ፦ «ሂንዳ ኑም ኬኤዜ፤ ኔ ሃይ ጋዓ ባካ ቢያ ዓይዲ ማዓንዳይ? ኔኤኮ ማዒ ሙኪፆና ዓጮ''ኮ ጋፒፆናኮ ማላታ ማዓንዳ ባካ ዓይጎዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ዬሱሴ ማሃዖ፦ «ዖኦኒያ ዒንሢ ዻቢሹዋጉዲ ዒንሢና ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ሚርጌሢ፦ ‹ታኣኒ ሜሲሔኬ!› ጌይሢና ታ ሱንፆ ዔኪ ሙኪ፥ ሚርጌሢ ዻቢሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ዒንሢኮ ዑኬ ዖሊንታ ዖልዚ ዒንሢ ዋይዛንዳኔ፤ ሃሣ ዖልዚኮ ሃይሴያ ዒንሢ ዋይዛንዳኔ፤ ዬይ ቢያ ማዓኒ ኮይሳያታሢሮ ዲቃቲፖቴ፤ ጋፒንፃ ጋዓንቴ ሃጊኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ዴራ'' ዴሮ''፥ ካኣታ'' ካኣቶ'' ዖላንዳኔ፤ ዱማ ዱማ ዓጮ''ይዳ ናይዚና ሳዓ ዓጊፂሢና ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ጋዓንቴ ዬይ ቢያ ሾይቺኮ ቤርታ ቆፂ''ፆ ጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«ዬኖ ዎዶ''ና ሜቶም ዓኣሢ ዒንሢ ዒንጎንዶኔ፤ ዎዺያ ዎዾንዶኔ፤ ታ ሱ'ንፆሮ ዓሲ ቢያና ዒፂንቴያ ዒንሢ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ዬያሮ ሚርጌ ዓሳ ዻቢንታንዳኔ፤ ሃሣ ፔቴ''ይ ባጋሢ ዓኣሢ ዒንጋንዳኔ፤ ዎሊ ዒፂያ ዒፃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ሚርጌ ሉኡቂ ፆኦሲ ማሊሢ ኬኤዛያ ማላ ዓሲ ዔቂ ሚርጌ ዓሶ ዻቢሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ፑርቱሞ ሚርጋንዳሢሮ ሚርጌ ዓሶኮ ናሹማ ባይቃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ዴንዲ ጋፒንፆ ሄላ''ንዳኣና ዶዴሢ ጋዓንቴ ዻቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ዴሮ'' ቢያም ማርካ ማዓንዳጉዲ ሃይ ፆኦሲ ካኣቱሞ ኮዦ ሃይሳ ዓጮ'' ቢያይዳ ኬኤዚንታንዳኔ፤ ዬካፓ ዓጮ''ኮ ጋፒንፃ ሙካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ዬካፓ ዬሱሴ፦ «ፆኦሲ ማሊፆ ኬኤዛ ዳኣኔኤሌ ኬኤዜ ጎይፆና ካኣዦ ዒኢሳ፥ ሻኣካ'' ባኣዚ'' ጌኤዦ ቤዞይዳ ማዺንታንቴ ዒንሢ ዛጋንዳኔ፤ ዬያ ናባባሢ ጶቂሦንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ዬኖ ዎዶ''ና ዪሁዳይዳ ናንጋ ዓሳ ዹኮ'' ባንሢ ቤቱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ሹጮና ማዦና ማኣሮኮ ዑፆይዳ ዓኣ ዓሲ ኬኤፃፓ ዔኤቢ ዔካኒ ኬዶ''ፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ጎዦ ቤዛ ዓኣሢያ ዓፒሎ ፔኤኮ ዔካኒ ማኣሪ ዓኣዾፖ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ዬኖ ዎዶ''ና ጎጶ ዒንዳሢና ዻንሢሣ ላኣሎናም ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ዒንሢኮ ቤቲፃ ባርጊና ሃሣ ዓይሁዶኮ ሃውሾ ኬሎ''ና ማዑዋጉዲ ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ዬኖና ዓጫ'' ማዢንቴሢዳፓ ዬኖ ኬሎ'' ሄላ''ንዳኣና ማዒ ቤቂባኣ ባኣዚ'' ሃሣ ዬካፓ ጊንፆይዳኣ ቤቃያባኣ ሚርጌ ዼኤፒ ሜታ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ዬንሢ ኬሎ''ንሢ ቃሚቂባኣያ ማዔቶ ዓሲ ቢያ ዓቲንዱዋያታንቴኬ፤ ዶኦሪንቴዞንሢ ዛሎ''ሮ ዬንሢ ኬሎ''ንሢ ቃሚቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«ዬኖና ዖኦኒያ ‹ሃይሾ፥ ሜሲሔ ሃካ ዓኣኔ!› ሃሣ ‹ዬካ ሶ ዓኣኔ!› ዒንሢም ጌዔቶ ጎኔኬ ጌይፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ዓይጎሮ ጌዔቴ ኪሪስቶሴቱዋዖ ፔና ‹ኪሪስቶሴኬ› ጋዓ ዓሲና ሉኡዙሞና ፆኦሲ ማሊሢ ኬኤዛያ ማላ ዓሲ ኬስካንዳኔ፤ ዔያቶም ዳንዳዒንቴቶ ፆኦሲም ታናኬ ጋዓ ዓሶ ዻቢሻኒ ዼኤፒ ዓኪ ባኣዚ'' ሃሣ ዱማ ዱማ ማላታኣ ማዺ ዻዋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ዬያሮ ሃያ ቢያ ቤርታሲ ታ ዒንሢም ኬኤዛኣኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«ሃሣ ጊንሣ ‹ሃኣዛጉዋቴ፥ ኪሪስቶሴ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዓኣኔ!› ዒንሢም ጎዖናቴ ዒኢካ ዴንዲፖቴ፤ ‹ሃይሾ፥ ዓኣሺንቴ ቤስካ ዓኣኔ!› ዒንሢም ጎዖናቴያ ጎኔኬ ጌይፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ዓይጎሮ ጌዔቶ ዜኤሊንሢ ጫሪንቺዳ ዜኤሊንሣዖ ዓባ'' ኬስካ ካራ''ፓ ዴንዲ ጌላ ካራ'' ጴዻሢጉዲ ዓሲ ናዓሢኮ ሙኪፃ ያዺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ዔኤቢ ሃይቄ ቤስካ ቢያ ሃምፑራ ቡኪንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ሃሣ ዬሱሴ ኬኤዛዖ፦ «ዬንሢ ሜታሢ ኬሎ''ንሢኮ ጊንፃ ቤዞማና ዓባ'' ዹማንዳኔ፥ ዓጊናኣ ፖዓዓኬ፥ ዦኦጋሢያ ጫሪንጫፓ ዲኢናንዳኔ፥ ጫሪንጮ ማዢንታ ቢያ ዓጊፃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ዬኖ ዎዶ''ና ዓሲ ናዓሢኮ ማላታ ጫሪንጮይዳ ጴዻንዳኔ፤ ዓጮ''ይዳ ዓኣ ዓሳ ቢያ ዬኤካንዳኔ፤ ዓሲኮ ናዓሢያ ጫሪንጮ ሻኣሮና ማዒ፥ ዼኤፒ ቦንቾና ሙካንቴ ዔያታ ዒዛ ዛጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ዒማ''ና ዒዛኮ ኪኢታንቾ ዼኤፒ ዛዬና ዓጮ''ኮ ቢያ ዛሎ'' ዒ ዳኬም ዔያታ ዴንዲ ዒዛም ዶኦሪንቴዞንሢ ዓጫ'' ማዔ ካራ''ፓ ቢያ ቡኩሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ሄሊ''ሳዖ ዬሱሴ፦ «ቤሌሶ ሚፄላ ማላታ ማዒ ዒንሢም ዔርዛያ ማዖንጎ፤ ዒዞኮ ካኣፓ ፂሊ፥ ዒላሺ ኬሳ'' ዎዶ''ና ዖጎሢ ዑኬሢ ዒንሢ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ዬያጉዲ ዬያ ባኮ ቢያ ዒንሢ ዛጋ ዎዶ''ና ዒዛኮ ሙካ ኮሺ'' ዑኬሢ ዒንሢ ዔራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዬይ ጉቤ ማዓንዳያ ሄላ''ንዳኣና ሃይ ሾይንታ ዓኣዻዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ጫሪንጮና ሳዖና ዓኣዻንዳኔ፤ ታኣኮ ቃኣላ'' ጋዓንቴ ፔቴ''ታዖ ዓኣዻዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ዬሱሴ ሃሣ፦ «ዬኖ ኬሎ''ና ዎዶ''ና ጋዓንቴ ዓዶይዳፓ ዓታዛ ጫሪንጮ ኪኢታንቾ ማዔቶዋ ናዓሢያ ዔሩዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ዓዳ'' ኖሄ ዎዶ''ና ማዔሢጉዲ ዓሲ ናዓሢኮ ሙኪፃ ዒማዺ ማዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ዬኖ ዎዶ''ና ባይሲንቶ ዋኣፆኮ ቤርታ ኖሄ ዋኣፆ ካኣሚላ ጌላንዳ ኬሎ'' ሄላ''ንዳኣና ዓሳ ሙዒያ ሙዒ ዑሽኪያ ዑሽኪ ሃሣ ሎዒያ ሎዒ ዔኪያ ዔኪ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ባይሲንቶ ዋኣፃ ሙኪ ጉቤሢ ሙዒ ጋፒሳንዳያ ሄላ''ንዳኣና ዔያታ ዔሪባኣሢጉዲ ዓሲ ናዓሢኮ ሙካ ያዺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ዬኖ ዎዶ''ና ላምዖ ዓሲ ጎሺዳ ዎላ'' ጎሽካያ ማዓንዳኔ፤ ፔቴ''ሢ ዔውቴም ባጋሢ ዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ላምዖ ላኣሊ ዎንሢ ዎላ'' ዎዻንዳኔ፤ ፔቴ''ዛ ዔውቴም ባጌላ ዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«ዓካሪ ዒንሢኮ ጎዳሢ ሙካ ኬሎ'' ዒንሢ ዔሩዋኣሢሮ ጴጪ ካፑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ኮሺ'' ዔሩዋቴ፤ ፔቴ'' ማኣሪኮ ዓዴ ዹሚና ዉሲ ዎማ ዎዴ ሙካንዳቴያ ዔራያ ማዔቶ ጊንዑዋዖ ካፒ፥ ዉዞና ማኣሮ ቦኦኪሲንዱዋያታንቴ ዔሩዋ ዓቲፆና ዉዛ ማኣሪ ጌላሢጉዲ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ዓሲኮ ናዓሢ ዒንሢ ማሊባኣ ዎዴና ሙካንዳሢሮ ጊኢጊንቲ ናንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ፔኤኮ ማኣሮ ዓሶም ኮይሳ ዎዶ''ና ሙዖ ዒንጋንዳጉዲ ማኣሮ ዓዳሢ ፔኤኮ ማኣሮ ዓሶ ዑፆይዳ ሱኡጋሲ ጌሣ፥ ጉሙርቂንታያና ጪንጮ ማዔ ማዻሢ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ዬማይዲ ማዻንቴ ማኣሮ ዓዴ ሙኪ ዴንቄቶ፥ ዬይ ማዻሢ ጋላቲንታያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዬያ ማዻሢ ማኣሮ ዓዴ፥ ቢያ ባኮኮ ዑፆይዳ ሱኡጋሲ ጌሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ጋዓንቴ ዬይ ማዻሢ ፑርታ ማዒ፥ ፔ ዒኖና ‹ታ ጎዳሢ ኔጊ ሙካንዳኔ› ጌዒ ማላዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ዒዛና ዎላ'' ማዻ ዓሶ ጳዺ ዓርቄቶ ሃሣ ማሢንታ ዓሶና ዎላ'' ሙዒ ዑሽካያ ማዔቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ዬያ ማዻሢኮ ዓዳሢ ዒ ዔሪባኣ ዎዴና ኬሊ''ናይዳ ሙኪ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ዬያ ማዻሢ ቲቂ ቲቂ ኬኤራንዳኔ፤ ዒዛኮ ናንጎ ቤዞዋ ጌኤሺቱዋዖ ፔና ጌኤሺ ማሊሳ ዓሶና ዎላ'' ማሓንዳኔ፤ ዒኢካ ዬኤኪ ሃሣ ሜታዺ ዓቺ ዒ ዻዓንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ዬካፓ ዬሱሴ፦ «ዬኖ ዎዶ''ና ጫሪንጮ ካኣቱማ ጌሊፆ ጎይፃ' ዑኡታ ጎይሣ ዔካኒ ፖዒ ዔኪ፥ ኬስኪ ካፔ ታጶ ዉዱሮ ናይስኬንሢ ሓይሴጉዲ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ዬንሢዳፓ ዶንጎ ዉዱሮ ናኣቶ''ንሢ ቦኦዛ፥ ዓቴ'' ዶንጎንሢ ጪንጫኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ቦኦዞንሢ ፖዖ ፖዒሶሢ ዔካዖ፥ ጋዓንቴ ጋፓዛ ዋሃኒ ኮይላ'' ላምባሢ ዔኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ጪንጮንሢ ጋዓንቴ ፖዖ ፖዒሶሢንታ ሃሣ ጋፓዛ ዋሆንዶ ላምባሢያ ኮይላ'' ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ዑኡታሢ ኔጌም ቢያሢ ጊንዓ ባሼም ጊንዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«ዬካፓ ሳዓ ጊዲሚሺ ማዓዛ ‹ዑኡታሢ ሙኬኔ፥ ዔካኒ ኬስኩዋቴ!› ጋዓ ዔኤሊ''ሢ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ዬማና ዉዱሮ ናኣቶ''ንሢ ቢያ ዔቃዖ፥ ፖዒሶ ባኮ ጊኢጊሼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ዒማ''ና ቦኦዞንሢ ጪንጮንሢ ኮራ ‹ኑ ፖዓ ሃይቃኒ ዎኦታሢሮ፥ ዒንሢኮ ላምባስካፓ ኑም ዒንጉዋቴራ!› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ጪንጮ ዉዱሮ ናኣቶ''ንሢ ማሃዖ ‹ኑኡኮ ዓኣ ላምባሢ ኑኡና ዒንሢናም ጊዲንዱዋኣሢሮ፥ ዴንዲ ሻንቻ ዓሶይዳፓ ዒንሢ ሻሻንቁዋቴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ዬማና ዔያታ ላምባሢ ሻንቃኒ ዴንዳዛ ዑኡታሢ ሙኬም ጊኢጊ ዓኣ ዉዱሮ ናኣቶ''ንሢ ዔፖ ሙዖ ቤዞ ዒዛና ዎላ'' ጌላዛ ካራ'' ዎዺንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«ዓቴ'' ዉዱሮ ናኣቶ''ንሢ ሃሣ ዻካ'' ኔጊ ሙካዖ፥ ‹ጎዳሢዮ! ካሮ'' ኑም ቡሌ''› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ዒዚ ማሃዖ ‹ጎኔ ታ ዒንሢም ጋዓኔ፤ ታ ዒንሢ ዔሩዋሴ› ጌዔኔ» ጌኤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ዬካፓ ሃሣ ዬሱሴ፦ «ዬይ ማዓንዳ ዎዶ''ና ኬሎ''ና ዒንሢ ዔሩዋኣሢሮ ጊኢጊንቲ ካፑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ሃሣ ዬሱሴ፦ «ፆኦሲ ካኣቱማ ማዻ ዓሶ ዔኤሊ''፥ ዓኣ ባኮ ‹ዛጉዋቴ› ጌይ ሜሌ'' ዓጪ ዓኣዼ ፔቴ'' ዓሲ ማላኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ዒዚ ዓኣዻኒ ዔቃዖ ፔቴ'' ፔቴ''ሢም ዳንዳዓሢጉዲ ፔቴ''ሢም ዶንጎ ሺያ ሹቺ ቢራ፤ ባጋሢም ላምዖ ሺያ ሹቺ ቢራ፤ ዓቴ''ሢም ሃሣ ፔቴ'' ሺያ ሹቺ ቢራ ዒንጊ ጎይፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ዶንጎ ሺዮ ሹጮ ቢሮ'' ዔኬ ዓሢ ሚኢሾ ኮርሚ ጊዳ'' ዶንጎ ሺያ ሹቺ ቢራ ሾይዤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ዬያጉዲ ሃሣ ላምዖ ሺዮ ዔኬ ዓሢያ ጊዳ'' ላምዖ ሺያ ሾይዤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ዓቴ''፥ ፔቴ'' ሺዮ ሹጮ ቢሮ'' ዔኬሢ ጋዓንቴ ማኣሮ ዓዶኮ ሚኢሾ ዔካዖ ዔቴ ቦኦኪ ዱኡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ሚርጌ ዎዴ ዴዓዖ፥ ዬንሢ ማዻ ዓሶንሢኮ ማኣሮ ዓዳሢ ሙኪ፥ ማዻዞንሢም ዒንጌ ባኮ ዛጊሢ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ዶንጎ ሺዮ ሹጮ ቢሮ'' ዔኬሢ ጊዳ'' ዶንጎ ሺያ ሹቺ ቢራ ቃሲ'' ዔኪ ሙኪ ዒንጋዖ፥ ‹ጎዳሢዮ! ዶንጎ ሺያ ቢራ ታኣም ኔ ዓርቄ ጌዒ ዒንጌንቴ ሃኣዛጌ ሃሢ ዶንጎ ሺያ ሹቺ ቢራ ጊዳ'' ታ ሾይዤኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ማኣሮ ዓዴያ ‹ቃራ ኔ ማዼኔ፤ ኔኤኒ ኮዦ፥ ጉሙርቂንታ ማዻሢዮ! ዻካ'' ባኣዚ''ዳ ኔ ጉሙርቂንቴያ ማዔሢሮ ሚርጌ ባኣዚ'' ኔ ዎይሣንዳጉዲ ታ ኔና ማሃንዳኔ፤ ሃኒ ሙኪ ታኣና ዎዛዼ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«ዬያጉዲ ሃሣ ላምዖ ሺዮ ሹጮ ቢሮ'' ዔኬ ማዻሢ ሙካዖ፥ ‹ጎዳሢዮ! ላምዖ ሺያ ሹቺ ቢራ ኔ ታኣም ዒንጌያታንቴ፥ ሃሢ ሃኣዛጌ ጊዳ'' ታ ላምዖ ሺያ ሾይዤኔ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ማኣሮ ዓዴያ ‹ቃራ ኔ ማዼኔ፤ ኔኤኒ ኮዦ፥ ጉሙርቂንታ ማዻሢዮ! ኔ ዻካ'' ባኣዚ''ና ጉሙርቂንቴያ ማዔሢሮ ሚርጌ ባኣዚ'' ኔ ዎይሣንዳጉዲ ታ ኔና ማሃንዳኔ፤ ሃኒ ሙኪ ታኣና ዎዛዼ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«ጋፒንፃ ፔቴ'' ሺዮ ሹጮ ቢሮ'' ዔኬ፥ ማዻሢ ሙካዖ ‹ጎዳሢዮ! ኔኤኒ ዜርቂባኣ ቤሲዳፓ ጮኦራያ ሃሣ ዜርቂባኣዖ ታይዛያ ሜታሳ ዓሲ ኔ ማዔሢ ታ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ዬያሮ ታ ዒጊጪ ኔ ዒንጌ ሹጮ ቢሮ'' ዔኪ ዓኣዺ ሳዖይዳ ዱኡኪ ካፔሢሮ ሃሢ ሃኣዛጌ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«ማኣሮ ዓዳሢ ማሃዖ ‹ሃይ ኔ ፑርታ፥ ሃሣ ቤልፃ ማዔሢ ሃይ! ታ ዜርቂባኣዖ ጮኦራያና ሃሣ ዜርቂባኣዖ ታይዛሢ ኔ ዔራያ ማዔቶ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ሚኢሾ ታኣኮ ኮርሚ ሾይዣ ዓሶም ሄኤዶ ኔ ዒንጌም፥ ታ ሾይቺና ዔካንዳያታንቴኬ› ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‹ዒዛይዳፓ ሚኢሾ ዔኪጋፓ ታጶ ሺዮ ዓንጎ ቢራ'' ዓኣሢም ዒንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ዓይጎሮ ጌዔቶ ዓኣ ዓሶም ጊዳ'' ቃሲ''ንቴም ሚርጋንዳኔ፤ ባኣሢዳፓ ጋዓንቴ ዻካ'' ዓኣማታዖ ዓቱዋ ዔውታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ሃያ ፓሡዋ ማዻሢ ጋዓንቴ ዙላ'' ዹማ'' ኬሲ'' ኬኤሩዋቴ፤ ዒኢካ ዒ ዬኤኪ ሃሣ ሜታዺ ዓቺ ዻዓንዳኔ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ዬካፓ ዬሱሴ፦ «ዓሲኮ ናዓሢ ፔኤኮ ኪኢታንቾ ቢያሢና ዎላ'' ቦንቺንቲ ሙኪ፥ ቦንቾ ካኣቱሞ ዖይቶይዳ ዴዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ዴራ'' ቢያ ዬማና ዒዛ ቤርታ ቡኪንታንዳኔ፤ ዒዚያ ሄንቃ ዓሲ ማራቶ ዋኣሮይዳፓ ቁራሢጉዲ ዴሮ ቁሪ ዱማሳንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ዬካፓ ማራቶ ሚዛቆ ዛላ''፥ ዋኣሮ ሻዉሎ'' ዛላ'' ዔቂሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ዬኖ ዎዶ''ና ካኣታ''ሢ ዒዛኮ ሚዛቆ ዛላ'' ዓኣዞንሢም፦ ‹ዒንሢ ታ ዓዴ ዓንጄ ዓሳ፥ ሃኒ ሙኩዋቴ፤ ሳዓ ማዢንቴሢዳፓ ዓርቃዖ ዒንሢም ጊኢጌ ካኣቱሞይዳ ጌሉዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ዓይጎሮ ጌዔቶ ታኣኒ ናይዼም ታና ዒንሢ ሙኡዜኔ፥ ዼኤቢንቴም ታና ዒንሢ ዑሼኔ፤ ሃሣ ሾኦቺንሢያ ታና ዒንሢ ዔኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ታ ካላ''ዼም ታና ዒንሢ ማይሴኔ፥ ሃርጊንቴም ታና ዒንሢ ማይሤኔ፥ ቱኡቴማኣ ታና ዒንሢ ዖኦጬኔ።› ");
INSERT INTO mdybse_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«ጌኤዦንሢያ ማሃዖ ‹ጎዳሢዮ! ኔኤኒ ናይዺንቴም ኔና ኑ ዛጊ ዓይዴ ሙኡዜይ? ሃሣ ዼኤቢንቴም ዛጊ ዓይዴ ኔና ኑ ዑሼይ? ");
INSERT INTO mdybse_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ጊንሣ ሾኦቹሞ ኔ ሙኬም ዓይዴ ዛጊ ኔና ኑ ሾኦቺንሤይ? ካላዼማኣ ዓይዴ ዛጊ ኔና ኑ ማይሴይ? ");
INSERT INTO mdybse_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ዬያጉዲ ሃሣ ሃርጊያ ሃርጊንቲ፥ ቱኡቲያ ኔ ቱኡቴም ዓይዲ ኔና ኑ ዖኦጬይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ካኣታ''ሢ ማሃዖ፦ ‹ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃንሢ፥ ታ ዓሶንሢዳፓ ፔቴ'' ላኣፓሢም ዒንሢ ማዼሢ ታኣም ዒንሢ ማዼሢጉዲኬ› ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«ዬካፓ ዒዛኮ ሻዉሎ'' ዛሎ''ና ዓኣዞንሢም ሃሣ ‹ዒንሢ ጋዳንቂንቴዞንሢዮ! ፃላሄና ዒዛኮ ኪኢታንቾናም ጊኢጊንቴ፥ ናንጊና ባይቁዋ ታሞይዳ ታ ኮራፓ ዓኣዹዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ዓይጎሮ ጌዔቶ ናይዼም ታና ዒንሢ ሙኡዚባኣሴ፥ ዼኤቤም ታና ዒንሢ ዑሺባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ሾኦቺንቂ ታ ሙኬም ዒንሢ ታና ሾኦቺንሢባኣሴ፤ ካላ''ዼማኣ ታና ዒንሢ ማይሲባኣሴ፤ ሃርጊያ ሃርጊ፥ ቱኡቲያ ታ ቱኡቴንቴ ታና ዒንሢ ዖኦጪባኣሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«ዔያታ ማሃዖ ‹ጎዳሢዮ! ናይዺንቲ ሃሣ ዼኤቢንቲ፥ ሾኦቺያ ማዒ፤ ጊንሣ ካላ''ዺ፥ ሃርጊያ ሃርጊ፥ ቱኡቲያ ኔ ቱኡቴም ዛጊ ዓይዴ ኔና ኑ ዖኦጩዋዖ ሃሼይ?› ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ዒማ''ና ‹ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃንሢ ታ ዓሶንሢዳፓ ፔቴ''ሢም ዒንሢ ማዺባኣሢ ታኣም ዒንሢ ማዺባኣያኬ› ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ዬንሢ ሂዚ ጋዓዞንሢ ናንጊና ጋፑዋ ሜቶይዳ፤ ፂሎ''ንሢ ጋዓንቴ ናንጎና ናንጎይዳ ጌላንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ዬሱሴ ዬንሢ ባኮ ኬኤዚ ጋፔሢኮ ጊንፃ፥ ዒዛኮ ጊንፆ ሃንታ ናኣቶ''ም፦ ");
INSERT INTO mdybse_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ላምዖ ኬሊ''ኮ ጊንፃፓ ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ኬላ'' ቦንቺንታያ ማዔሢ ዒንሢ ዔራኔ፤ ዓሲኮ ናዓሢ ሱፂንታንዳጉዲ ዓኣሢ ዒንጊንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ዬካፓ ቄኤሶኮ ሱኡጎና ዴሮ''ኮ ጪማ''፥ ቄኤሶ ቢያሢኮ ሱኡጋሢ ቃያፓ ማኣሮ ካሮ''ይዳ ቡኪንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ዒኢካ ዔያታ ዔርቱዋ ጎይሢና ዓርቂ ዬሱሴ ዎዻኒ ዎላ'' ዞርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ጋዓንቴ ዔያታ፦ «ዴሮ''ኮ ባኣካ'' ዣላ ዔቁዋጉዲ ቦንቾ ኬሎ''ና ማዖፓ» ጌዒ ዎላ'' ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ዒኢካ ዬሱሴ ቢታኒያይዳ ዑፃ ኬስካ ዶርዓሢ ዓርቄንቴ ፖዔ፥ ሲሞኦኔ ማኣራ ዓኣንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ፔቴ'' ላኣሊስኬና ሹቺፓ ኮሾ''ና ቢልቃፄይዳ ሻንቾናቴ ሚርጌ ሚኢሼ ዔካንዳ ሳውቃ ቲሺ ኩንሢ ዔኪ ሙካዖ፥ ዬሱሴ ሙዖሮ ዴዒ ዓኣንቴ ዒዛኮ ቶኦካ'' ዋሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬያ ዛጌ ዎዶ''ና ጎሪ''ንታዖ፦ «ሓያ ሳውቃ ቲዦ ጉሪ ላኣሎሢ ዓይጎሮዳይ! ");
INSERT INTO mdybse_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ሃይ ሳውቃ ቲዣ ሚርጌ ሚኢሼም ሻንቺንቲ፥ ሚኢሻ ማንቆ ዓሶም ዒንጊንታንዳንቴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ዬሱሴ ዬያ ዔያታ ጋዓሢ ዔራዖ፦ «ሃኖ'' ላኣሌሎ ዒንሢ ዓይጎሮ ሜታሳይ? ዒዛ ኮሺ ባኣዚ'' ታኣም ማዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ማንቆ ዓሳ ቢያ ዎዴ ዒንሢና ዎላ''ኬ፤ ታኣኒ ጋዓንቴ ቢያ ዎዴ ዒንሢና ዎላ'' ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ሳውቃ ቲዦ ታ ዑፃ ዒዛ ዋሄሢ ታና ዱኡፖም ጊኢጊሻኒኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃይ ኮዦ ሃይሳ ኬኤዚንታ ዓጮ'' ቢያይዳ ዓንካ ማዔቶዋ ዒዛ ማዼ ባካ ‹ዒዛ ዬያይዴኔ› ጌይንቲ ኬኤዚንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ዬካፓ ታጶ ላምዖንሢዳፓ ፔቴ''ሢ ማዔ፥ ዓስቆሮንቶ ዪሁዳ ጌይንታሢ ቄኤሶኮ ሱኡጎ ኮራ ዓኣዻዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«ታኣኒ ዒዛ ዓኣሢ ዒንሢም ዒንጌቶ ዒንሢ ታኣም ዓይጎ ዒንጋንዳይ?» ጋዓዛ፥ ዔያታ ዒዛም ሃይሢታሚ'' ሹቺ ቢራ ፓይዲ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ዬማፓ ዓርቃዖ ዪሁዳ ዬሱሴ ዓኣሢ ዒንጋኒ ጊኢጋ ኬሊ'' ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ዓይሁዶኮ ላኣዶ'' ሙዒ ቦንቾሢኮ ቤርታሳ ኬሎ''፥ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬሱሴ ኮራ ሙካዖ፦ «ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዋሢ፥ ዎካ ኔኤም ኑ ጊኢጊሻንዳጉዲ ኔ ኮዓይ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ዒዚ ማሃዖ፦ «ካታሞይዳ ናንጋ፥ ሃያ ማኣሪ ዴንዲጋፓ ‹ዔርዛሢ፥ ታኣኮ ዎዳ'' ዑኬሢሮ ታኣኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዋሢ ኔ ማኣራ ታ ሙዒ ቦንቻንዳኔ› ጋዓኔ፥ ጎዑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ዒዛኮ ጊንፆ ሃንታዞንሢያ ዒዚ ዓይሤሢጉዲ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዋሢ ጊኢጊሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ዬካፓ ሳዓ ዓማዛ ዬሱሴ ታጶ ላምዖንሢና ዎላ'' ሙዖሮ ዴዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ዒኢካ ዔያታ ሙዒፆይዳ ዓኣንቴ ዬሱሴ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒንሢዳፓ ፔቴ''፥ ታና ዓኣሢ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ዬያሮ ዔያታ ሚርጌና ዖያዖ ፔቴ'' ፔቴ''ሢ፦ «ጎዳሢዮ፥ ታናቱዋሴ፤ ታናኬ ኔ ጋዓ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ዒዚ ዔያቶም፦ «ዒንሢዳፓ ዓኣሢ ታና ዒንጋንዳሢ ሃሢ ታኣና ዎላ'' ጎንጋ ኩጮ ዳካሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ዓሲኮ ናዓሢ ዒዛ ዛሎ'' ፃኣፒንቴ ጎይፆና ሃይቃንዳኔ፤ ጋዓንቴ ዓሲኮ ናዓሢ ዓኣሢ ዒንጋ ዓሢም ባዴዔ! ዬይ ዓሢ ሾይንቲባኣያታቴ ኮሺታዖ ዓቴ''ኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ዓኣሢ ዒዛ ዒንጋንዳ፥ ዪሁዳ ሃሣ፦ «ዔርዛሢዮ! ታናቱዋሴ፤ ታናኬ ኔ ጋዓ?» ጋዓዛ፥ ዬሱሴ ዒዛም፦ «ሂዮ፥ ኔ ጌዔሢጉዴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ዔያታ ካዋሢ ሙዓኣና ዬሱሴ ካሣ ዔኪ ጋላታ ሺኢጲሢ ሺኢቃዖ፥ ቡንፂ ዒዛኮ ጊንፆ ሃንታዞንሢም፦ «ሃቦቴ ሙዑዋቴ፤ ሃይ ታናኬ» ጌይ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ዬያጉዲ ሃሣ ዑሽኮ ባኮዋ ዔኪ ጋላታ ሺኢጲሢ ሺኢቃዖ፦ «ቢያሢ ሃያይዳፓ ዑሽኩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ሃይ ሚርጌ ዓሶኮ ጎሞ ጌኤሻኒ ላኣሊንታንዳ ታኣኮ ዓኮ ጫኣቁሞ ሱጉፆኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ታ ዓዶ ካኣቱሞይዳ ዎይናፓ ኮሾ''ና ዓኮ ዑዦ ዒንሢና ዎላ'' ታ ዑሽካንዳያ ሄላ''ንዳኣና ሃይካፓ ሴካ ሃኖ' ዎይናፓ ኮሾ''ና ዑዤሎ ላሚ ታ ዑሽካዓኬ ታ ዒንሢም ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ዬካፓ ዔያታ ፆኦሲ ቦንቾም ማዓ ዓይኑሞ ዓይናዻዖ፥ ዛይቶ ሪሚቶ ዹኮ'' ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢም፦ « ‹ሄንቃሢ ታ ዎዻንዳኔ፤ ማራታኣ ዣኣላንዳኔ› ጌይንቲ ፃኣፒንቴሢሮ ሃኖ'' ዒባኒ ታ ዒንሢኮ ዹቆ ማዔም ዒንሢ ቢያሢ ታና ሃሺ'' ዓኣዻንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ጋዓንቴ ሃይባ''ፓ ታ ዔቄሢኮ ጊንፃ፥ ጌሊላ ዒንሢ ቢሪ ታ ዓኣዻንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ዒዞና ጴፂሮሴ ማሃዖ፦ «ሃንጎዋታ ቢያ ኔ ዛሎ''ና ዹቂንቲ፥ ሃሺ'' ኔና ዓኣዼቶዋ ታኣኒ ፔቴ''ታዖ ኔና ሃሺ'' ዓኣዻዓኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ዬሱሴ፦ «ጎኔ ታ ኔኤም ጋዓኔ፤ ሃኖ'' ዒባኒ ኮይዳ ቂኢቃንዳሢኮ ቤርታ ሃይሢ ማይንቲ ኔ ‹ታ ዒዛ ዔሩዋሴ› ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ጴፂሮሴ ጋዓንቴ፦ «ኔኤና ዎላ'' ሃሃይቆቴያ ፔቴ''ታዖ ታ ኔና ‹ታ ዒዛ ዔሩዋሴ› ጋዓዓ» ጋዓዛ፥ ሃንጎ ዒዛኮ ጊንፆ ሃንታዞንሢ ቢያ ዒማዺ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ጌኤቴሴማኔ ጌይንታ ቤሲ ዓኣዻዖ፥ ዔያቶም፦ «ታኣኒ ሴኬያ ዴንዲ ሺኢቃንዳኣና ዒንሢ ሃካ ዴዑዋቴ» ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ዒዛና ዎላ'' ጴፂሮሴና ላምዖ ዜብዲዮሴ ናኣቶ''ንሢ ዔኪ ዴንዳዖ ዖዪ ማሊሢ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ዬካፓ ዔያቶም፦ «ሼምፓሢ ታኣኮ ሚርጌ ዖዪ ሃይቃኒ ዑኬኔ፤ ዒንሢ ታኣና ዎላ'' ሃካ ዶዲ ዴዑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ዒማ''ና ዔያቶይዳፓ ዻካ'' ዶጫዖ፥ ባሊቲና ሳዓ ሎኦሚ፦ «ታ ዓዳሢዮ! ኔኤም ዳንዳዒንታያ ማዔቴ ሃይ ሜታሢ ታና ዖኦኮንጎ! ጋዓንቴ ኔ ጌዔሢጉዲ ማዓንዳኣፓዓቴም ታ ማሊፆጉዲ ማዖፓ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ዬካፓ ዒ ማዒ ሃይሦ ዒዛኮ ጊንፆ ሃንታዞንሢ ባንሢ ሙኪ፥ ዔያታ ጊንዒ ዓኣንቴ ዴንቃዖ ጴፂሮሴ ኮይላ''፦ «ታኣና ዎላ'' ዻካ'' ዎዴታዖ ዶዲ ዒንሢ ዴዓኒ ዳንዳዒባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ዻቢሻኒ ጌሾ ጌሺሢዳ ዒንሢ ጌሉዋጉዲ ዶዲ ሺኢቁዋቴ፤ ዓሲኮ ዓያና ቢያ ዎዴ ጊኢጌያኬ፤ ዓሽኪ ጋዓንቴ ላቤያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ላሚ ሃሣ ዴንዳዖ፦ «ታ ዓዳሢዮ፥ ሃያ ታ ዔኩዋዖ ዓቱዋ ሜቶ ማዔቶ ኔ ማሊፃ ኩሞንጎ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ላሚ ማዒ ሙካንቴ ጊንዓሢ ዔያቶ ኮሺ'' ባሼሢሮ ጊንዒ ዓኣንቴ ዴንቃዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ሃሣ ዔያቶ ሃሺ'' ዴንዲ፥ ቤርታ ሺኢቄማ ጎይፆ ሃይሣሲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ዬካፓ ጊንፆ ሃንታዞንሢ ኮይላ'' ማዒ ሙካዖ፦ «ሃሢ ሄላ''ዖ ዒንሢ ጊንዓሢዳዳ? ዓሲኮ ናዓሢ ጎሞ ዓሶም ዓኣሢ ዒንጊንታንዳ ዎዳ'' ዑኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ዓካሪ ዔቁዋቴ፥ ኑ ዓኣዾም፤ ሃይሾ ዓኣሢ ታና ዒንጋሢ ሙኬኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ዬሱሴ ዬያ ኬኤዛ ጎይሣ ዓኣንቴ ታጶ ላምዖንሢዳፓ ፔቴ''ሢ፥ ዪሁዳ ሙኬኔ፤ ዒዛና ዎላ'' ጬንቻ ዓፓሮና ኮኦሎ''ና ዓርቄ ሚርጌ ዓሲ ሙኬኔ፤ ዔያታ ዳኪንቲ ሙኬሢ፦ ቄኤሶኮ ሱኡጎና ዴሮ''ኮ ጪሞናይዳፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ዬሱሴ ዓኣሢ ዒንጋ፥ ዪሁዳ ዓሶም፦ «ዒንሢ ኮዓሢ፥ ታኣኒ ዒዛ ሄርቃንዳሢ ማዔሢሮ ዒዛ ዓርቁዋቴ» ጌዒ ቤርታ ኬኤዜያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ዒማ''ና ዪሁዳ ዑኬና ዬሱሴ ባንሢ ሙካዖ፦ «ዔርዛሢዮ! ኔ ኮሺዳ?» ጌዒ ሄርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ዬሱሴያ፦ «ታ ዒጊናሢዮ! ዓካሪ ኔ ሙኬ ማሊፆ ኩኩንሤ» ጋዓዛ ዓሳ ዬሱሴ ባንሢ ሙኪ ዓርቃዖ ሱሲና ዒዛ ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ዬማና ዬሱሴና ዎላ'' ዓኣዞንሢዳፓ ፔቴ''ሢ ዓፓሮ ቱጋዖ፥ ቄኤሶ ቢያኮ ሱኡጋሢም ማዻሢኮ ዋዮ ቆፂ'' ቲቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ዬሱሴ ጋዓንቴ፦ «ዔዛ ሃይ፥ ጬንቾ ዓፓሮ ጎንጎና ዳኬ፤ ዓፓሮ ቱጋዞንሢ ቢያ ዓፓሮና ሃይቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ዎንዴ ያዺ ማዓኒ ኮይሳያ ማዔቴ ታ ዓዶ ታ ዖኦጬም ታጶ ላምዖ ቤሲ ፓቂንታ ፖኦሊሶይዳፓ ባሼ፥ ኬኢታንቾ ታኣም ዳኪንዱዋያ ኔኤም ማላ? ");
INSERT INTO mdybse_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ዬይ ያዺ ማዔቶ ሃሣ ጌኤዦ ማፃኣፓ ‹ማዓንዳኔ› ጌዔ ባካ ዎይቲ ኩማንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ዒማ''ና ዬሱሴ ዴሮ''ም፦ «ሱላ ዓርቃ ዓሲጉዲ ጬንቻ ዓፓሮና ኮኦሎ''ና ዒንሢ ዔኪ ታና ዓርቃኒ ሙኪያ? ቢያ ዎዴና ጌኤዦ ማኣሮይዳ ዴዒ ታ ዔርዛኣና ዒንሢ ታና ዓርቂባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ጋዓንቴ ሃይ ቢያ ማዔሢ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፖይዳ ኬኤዚንቴ ባካ ኩማንዳጉዲኬ» ጋዓዛ፥ ዒዛኮ ጊንፆ ሃንታዞንሢ ቢያ ዒዛ ሌሊ ሃሺ'' ፑኒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ዬማ''ና ዬሱሴ ዓርቄ ዓሳ' ሙሴ ዎጎ ዔርዛ ዓሶንታ ዴሮ''ኮ ጪሞንታ ቡኪንቲ ዓኣ ቤዞ፥ ቄኤሶ ቢያኮ ሱኡጋሢ፥ ቃያፓ ማኣሪ ዒዛ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ጋዓንቴ ጴፂሮሴ ዒዛኮ ጊንፆ ሃኬ ሃኬ፥ ቄኤሶ ቢያኮ ሱኡጋሢ ማኣሪ ሄላ''ንዳኣና ዓኣዻኔ፤ ዒኢካ ጋሮ ጌሊ ማዺንታ ባኮ ቢያ፥ ጋፒንፆ ሄላ''ንዳኣና ዛጋኒ ካፓ ዓሶና ዎላ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ዬማና ቄኤሶኮ ሱኡጎና ዓይሁዶ ዓሶኮ ዎጎ ዎጋ ዓሳ ቢያ ዬሱሴ ዎዺሻንዳ ሉኡዙሞ ማርካ ኮዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ሚርጌ ሉኡዙሞና ማርካዻ ማርካ ሺኢኬቶዋ፥ ሃይቃንዳጉዲ ዎጊሳ ማርካ ዔያታ ዴንቂባኣሴ፤ ጊንፃፓ ላምዖ ዓሲ ሙኪ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«ሃይ ዓሢ ‹ጌኤዦ ማኣሮ ሻሂ ሃይሦ ኬሊ''ዳ ጊንሣ ታ ማዣኒ ዳንዳዓኔ› ጌዔኔ» ጌይ ማርካዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ዬኖና ቄኤሶ ቢያኮ ሱኡጋሢ ዔቃዖ፦ «ሃንሢ ዓሳ ኔ ጊዳ'' ማርካዻ ባኮኮ ቢያ ማሂ ኔ ኬኤዛ ባኣዚ'' ባኣዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ዬሱሴ ጋዓንቴ ዚቲዮ ጋዓዛ፥ ቄኤሶ ቢያኮ ሱኡጋሢ፦ «ኔ ሜሲሔ ሃሣ ፆኦሲ ናይ ማዒፆ፥ ናንጊና ናንጋ ፆኦዛሢ ሱንፆና ጫኣቂ ታኣም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ዬሱሴ ማሃዖ፦ «ኔ ጌዔሢጉዲኬ፤ ጋዓንቴ ሃይካፓ ሴካ ዓሲኮ ናዓሢ ዼኤፖ ፆኦዛሢኮ ሚዛቆ ዛላ'' ዴዒ ዓኣንቴ ዒንሢ ዛጋንዳኔ፤ ዬያጉዲ ሃሣ ጫሪንጮ ሻኣሮና ማዒ ሙካንቴያ ዒዛ ዒንሢ ዛጋንዳኔ፤ ታ ዒንሢም ጋዓኣኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ዬማና ቄኤሶ ቢያሢኮ ሱኡጋሢ ዓፒሎ ፔኤኮ ዻጋና ዳርዛዖ፦ «ሃይሾ ዒ ፆኦሲ ጫሽኬኔ! ዒንሢያ ዬያ ጫዦ ዋይዜኔ፤ ሃይካፓ ሴካ ማይ ዓይጎ ማርካ ኮይሳይ? ");
INSERT INTO mdybse_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ዓካሪ ዒንሢም ዓይጎ ማላይ?» ጋዓዛ፥ ዔያታ፦ «ዒ ሃይቃንዳያ ኮይሳኔ!» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ዒማ''ና ዒዛኮ ዔያታ ዓኣፖ ካራ'' ጩቲ''ያ ጩቲ''፥ ኩቺ ሙሊያ ዱላ''ዛ፥ ዛላ'' ሃሣ ዒዛ ባዒ ባዒ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«ሜሲሔ! ዖናዳይ ኔና ጳርቄሢ? ሂንዳ ፆኦሲ ማሊሢ ኑም ኬኤዜ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ዬካፓ ጴፂሮሴ ቄኤሶኮ ቢያ ሱኡጋሢ ዲሮ ጋራ ዴዒ ዓኣንቴ ፔቴ'' ዉዱሮ ናይ ዒኢካ ማኣራ ማዻስኬና ዒዛ ኮይላ'' ሙካዖ፦ «ኔኤኒያ ጌሊላ ዓጮ'' ዓሢ፥ ዬሱሴና ዎላ'' ዓኣያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ዒዚ ጋዓንቴ፦ «ኔኤኒ ዓይጎ ጋዓቴያ ታኣም ዔርቱዋሴ» ቢያሢ ቤርታ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ዒዚ ኬስካኒ ማርሾ ካሮ'' ባንሢ ዓኣዻንቴ ሃሣ ሜሌ'' ማዻስኬና ዒዛ ዴንቃዖ ዒኢካ ዓኣ ዓሶም፦ «ሃይ፡ ናዚሬቶ ዓሢ፥ ዬሱሴና ዎላ'' ዓኣያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ዒዚያ ጫኣቂ ጫኣቂ፥ ቢያሢኮ ቤርታ፦ «ታ ዒዛ ዓሢ ዔሩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ዬካፓ ዻካ'' ሃሣ ኔጋዖ ዒኢካ ዔቂ ዓኣ ዓሳ ጴፂሮሴ ኮራ ሙኪ፦ «ኔኤኮ ጌኤዛፓ ዔርታሢሮ ጎኔና ኔኤኒ ዔያቶይዳፓ ፔቴ''ሢኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ዒማ''ና ጴፂሮሴ፦ «ታና ባይዞም» ጌዒ ጫኣቃዖ «ታ ዬያ ዓሢ ዔሩዋሴ!» ጌዔኔ። ዬማና ኮይዳ ቂኢቃዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ጴፂሮሴ «ኮይዳ ቂኢቁዋንቴ ሃይሢ ማይንቲ ኔ ታና ‹ዔሩዋሴ› ጋዓንዳኔ» ዬሱሴ ጌዔሢ ጶቂሣዖ ካሮ'' ኬስኪ ዒናፓ ጎጋይቂ ዬኤኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ዚሮ ጉቴሎ ጉቴ'' ዓማ''፥ ቄኤሶኮ ሱኡጎና ዴሮ''ኮ ጪማኣ ቢያ ዬሱሴ ዎዾንዶ ጎይፆ ዞርቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ዬካፓ ዬሱሴ ዔያታ ቱኪ'' ዔኪ ሮሜ ዓጮ'' ዎይሣ ጲላፆሴም ዓኣሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ዬሱሴ ዓኣሢ ዒንጌ ዪሁዳ፥ ዬሱሴ ሃይቃንዳጉዲ ጌይንቲ ዎጊንቴሢ ዛጌ ዎዶ''ና ዻቢንቲ ማዔሢ ዔሪ ሃይሢታሞ ሹጮ ቢሮ'' ቄኤሶኮ ሱኡጎና ጪሞናም ዔኪ ሙኪ ማሂ ዒንጊ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«ታኣኒ ጌኤሺ ዓሲ፥ ሃይቢም ዓኣሢ ዒንጊሢና ዻቤኔ» ጋዓዛ፥ ዔያታ፦ «ኑና ዓይጌ ሜቴይ? ኔ ዔራ ባኣዚ'' ዎኦቴ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ዬያሮ ዪሁዳ ቢሮ''ንሢ ጌኤዦ ማኣራ ላኣሊ ኬስኪ፥ ዴንዲ ሱፂንቲ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ቄኤሶኮ ሱኡጋ ዬንሢ ቢሮ''ንሢ ዔካዖ፦ «ሃይ ሚኢሻ ሱጉሢ ሻንቾናያ ማዔሢሮ፥ ጌኤዦ ማኣሮም ዒንጎ ሚኢሾና ዎላ'' ሲኢራኒ ኑም ኮይሱዋሴ» ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ዔያታ ዎላ'' ዞርቲ፥ ሾኦቺም ዱኡፒ ቤሲ ማዓንዳጉዲ ፔቴ'' ማኒስኬያኮ ጎሺ ሻንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ዬያሮ ዬና ቤዛ ሃኖ'' ሄላ''ንዳኣና «ሱጉሢ ሳዓ» ጌይንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ዬያይዲፆና ፆኦሲ ማሊፆ ኬኤዛ ዔርሚያሴ ዛሎ''ና፦ «ዒስራዔኤሌ ናኣታ'' ‹ዒዚ ሻንቺንታንዳማኬ› ጌዒ፥ ዓርቄ ሃይሢታሞ ሹጮ ቢሮ'' ዔያታ ዔኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ፆኦዛሢ ታና ዓይሤ ጎይፆ ማናሢ ጎዦ ዛሎ'' ዔያታ ጪጌኔ» ጌይንቲ ኬኤዚንቴሢ ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ዒማ''ና ዬሱሴ ሮሜ ዓጮ'' ዎይሣ ጲላፆሴ ቤርቶ ሺኢካዛ፥ ጲላፆሴ፦ «ኔኤኒ ዓይሁዴ ካኣቲዳ?» ጌይ ዖኦጬኔ። ዬሱሴ ማሃዖ፦ «ኔ ታና ጌዔሢ ጉዴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ጋዓንቴ፥ ቄኤሶኮ ሱኡጎና ጪሞና «ዻቢንቲ ዓኣኔ» ጌዒ ዱማ ዱማ ባኣዚ'' ኬኤዛኣና ዬሱሴ ዓይጎዋ ጌዒ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ዬማ''ና ጲላፆሴ፦ «ኔና ዔያታ ዎጎና ዓይሢሳኒ፥ ዓኣፒኒ ባኣዚ'' ፓይዳቴያ ኔ ዋይዙዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ዬሱሴ ጋዓንቴ ዬይ፥ ዎይሣሢ ዲቃቲ ሄርሻንዳያ ሄላ''ንዳኣና ፔቴ'' ባኣዚ''ታዖ ማሂ ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ሮሜ ዓጮ'' ዎይሣሢ ሌዓ ሌዓ ዓይሁዶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ና ዴራ'' ዔያቶም ቡሊ''ንታንዳጉዲ ኮዓ፥ ቱቴ ዓሲ ቡላ''ሢ ዔርቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ዬኖና ፑርቱሞና ዔርቴ፥ ባርባኔ ጌይንታ ዓሲ ቱቲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ዴራ'' ቡኪንታዛ ጲላፆሴ፦ «ባርባኔና ሜሲሔ ጌይንታ ዬሱሴናይዳፓ ዖና ታ ዒንሢም ቡላ''ንዳጉዲ ዒንሢ ኮዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ጲላፆሴ ዬያ ጌዔሢ ዔያታ ዒዛ ቂኢሩሞና ዓኣሢ ዒንጌሢ ዔራያታዖኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ጲላፆሴ ዎጎ ቤዞይዳ ዴዒ ዎጋንቴ፥ ዒዛኮ ማቻ፦ «ዬያ ዓሢ ዛሎ'' ዋንቴ ታ ዓውቲና ሚርጌ ሜታዼኔ፤ ዬያ ጌኤዦ ዓሢ ዑፃ ዓይጎ ባኣዚ''ያ ኔ ማዹዋጉዲ» ጋዓ ኪኢታ ዒዛም ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ጋዓንቴ፥ ቄኤሶኮ ሱኡጎና ጪሞና ባርባኔ ዔያቶም ቡሊ''ንቴም ዬሱሴ ሃይቃንዳጉዲ ዓሳ ዖኦጮም ዴሮ'' ዴሚና ጌሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ዓጮ'' ዎይሣሢያ፦ «ላምዖንሢዳፓ ዖኦኒ ዒንሢም ቡሊ''ንታንዳጉዲ ዒንሢ ኮዓይ?» ጋዓዛ፥ ዔያታ «ባርባኔ ቡሊ''ንቶንጎ!» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጲላፆሴያ፦ «ሂዳዖ ኪሪስቶሴ ጌይንታ ዬሱሴ ታ ዎዶ''ንዶይ?» ጋዓዛ፥ ቢያሢ «ሱፂንቶንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ጲላፆሴያ፦ «ዓይጎሮ? ዓይጎ ዒ ፑርታ ባኣዚ'' ማዼይ?» ጌዒ ዖኦጫዛ፥ ዔያታ ጋዓንቴ «ሱፂንቶንጎ!» ጌዒ ሃቺም ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ዒዚ ማዻ ባካ ዣሎ ዔቂሲሢ ማዓንዳኣፓዓቴም ማኣዳ''ንዳ ባኣዚ'' ባኣሢ ጲላፆሴ ዔራዖ፦ «ታኣኒ ሃያ ዓሢ ሱጉፃፓ ጌኤሺኬ፤ ሃይፓ ሴካ ማዾንዶ ባኮ ዒንሢ ዔራኔ» ጌዒ፥ ዋኣሢ ዓይሢ ዴሮ'' ቢያ ቤርታ ኩጮ ፔኤኮ ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ዴራ'' ቢያ ዬማና፦ «ዒዛኮ ሱጉፃ ኑኡና ኑ ናኣቶ''ና ዑፃ ማዖንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ዬማና ጲላፆሴ ባርባኔ ዔያቶም ቡሊ''፥ ዬሱሴ ጋዓንቴ ዢራፓና ጳርቂሴሢኮ ጊንፃ ሱፃንዳጉዲ ዓኣሢ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ሮሜ ዓጮ'' ፖኦሊሳኣ ዬሱሴ ዔኪ ሮሜ ዓጮ'' ዎይሣ ጲላፆሴ ማኣሪ ዓኣዺ ማርሾ ጋሮ ጌልዛዖ ፖኦሊሶ ቢያ ዒኢካ ቡኩሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ዒኢካ ዔያታ ማኣዓሢ ዒዛኮ ጉሲ፥ ዲንኪ ዞቄ ዓፒላ ዒዛ ማይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ሃሣ ዓንጊሢ ማሪ ካኣቶ'' ቶኦካ ዓጎ ባኣዚ'' ማሊሲ ቶኦካ ዒዛኮ ዓጋዖ ዎኦሺጉዴ ሚሢ ኩጫ ዒዛኮ ዓይሢ፥ ቤርታ ዒዛኮ ጉምዓቲ ጉምዓቲ፦ «ዓይሁዴ ካኣቲዮ! ኮሺ ኔኤም ማዖንጎ!» ጌዒ ጌዒ ዒዛ ቦሄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ጩቲ''ያ ጩቴ''ኔ፤ ሃሣ ዎኦዦጉዴ ኮኦሌሎዋ ዒዛ ኩጫፓ ዔኪ ዒዛኮ ቶኦካ'' ላሚ ላሚ ጳርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ዬያይዲ ዔያታኣ ዒዛ ቦሄሢኮ ጊንፃ ዲንኮ ዞቄ ዓፒሎ ኬሲ'' ዒዛ ዓፒሎ ጊንሣ ማይሲ ሱፃኒ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ዔያታ ኬስኪ ዴንዲቤቃ ጎይፆይዳ ዓኣዖ ሲሞኦኔ ጌይንታ ቄሬና ዓጪ ዓሲ ዴንቂ ፑርቲሴ ዓሶ ሱፆ ሚፆ ዓሢ ዎልቄና ኬዲሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ዬካፓ ዔያታ፦ «ቶኦኪ ሜጌሢ» ጌይንታ ጎልጎታ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ዓንጎና ጳርቂ ኪፃሶና ቤዛ ሃርጋሢ ማኣዳ''ንዳጉዲ ዎይኔይዳፓ ኮሾ''ና፥ ጪሼና ዎላ'' ሲኢሪንቴ ዑሺ ዑሽካንዳጉዲ ዬሱሴም ዒንጋዛ፥ ዒ ጋዓንቴ ዑኡቂ ዛጋዖ ዑሽካኒ ኮዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ዬሱሴ ዔያታ ሱፃዖ ዒፃ ዓጊ ዓፒሎ ዒዛኮ ጊሽቲ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ዒኢካ ሃሣ ዴዒ ዒዛ ዔያታ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ዻቢንቶ ዒዛኮ ዔርዛንዳጉዲ ጌዒ «ሃይ፥ ዓይሁዴ ካኣቲ፥ ዬሱሴኬ» ጋዓ ፃኣፖና ባኣዚ'' ዬሱሴ ሱፂንቴ ፑርቶ ዓሶ ሱፆ ሚፆ ዑፃ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ዒዛና ዎላ'' ላምዖ ሱላ ፔቴ''ሢ ዬሱሴኮ ሚዛቆ ዛላ''፥ ባጋሢ ሻውሎ'' ዛላ'' ማሂ ዔያታ ሱፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ዒኢና ጎይፆ ዓኣዻ ዓሳ ሚርጌና ጫሽኪ ጫሽኪ ሃሣ ቦሂሢና ቶኦኮ'' ፔኤኮ ዓጊሢ ዓጊሢ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«ጌኤዦ ማኣሮ ሻሂ፥ ሃይሦ ኬሊ''ዳ ማዣሦ! ሂንዳ ኔና ዻቂሼ! ሂዮ ሂንዳ ፆኦሲ ናይ ኔ ማዔቶ ፑርቶ ዓሶ ሱፆ ሚፃፓ ኬዴ''!» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ዬያጉዲ ቄኤሶኮ ሱኡጎንታ ሙሴ ዎጎ ዔርዛ ዓሶንታ ጪሞንታ ቢያ ቦሂ ቦሂ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ሜሌ'' ዓሶ ዒ ዻቂሼኔ፤ ፔና ጋዓንቴ ዒ ዻቂሻኒ ዳንዳዑዋሴ፤ ሂንዳ ዒ ዒስራዔኤሌ ካኣቲ ማዔቶ ሃሢ ፑርቶ ዓሶ ሱፆ ሚፃፓ ኬዶ''ንጎ፤ ኑኡኒ ዒዛ ጎኔኬ ጌዒ ጉሙርቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ዒ ፆኦሲና ጉሙርቃኔ፤ ሃሣ ‹ፆኦሲ ናይኬ› ፔና ዒ ጋዓኔ፤ ሂንዳ ፆኦሲ ዒዛ ናሽካቶ ዻቂሾንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ዬያጉዲ ዒዛና ዎላ'' ሱፂንቴ ሱሎ''ንሢያ ዒዛ ጫሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ዓባ'' ሳዛ ማዓ ዎዳ''ፓ ዴንዲ ማሢ ዶምቦልሳ ዎዴ ሄላ''ንዳኣና ሳዓ ቢያ ዹሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ዬማፓ ማሢ ዶምቦልሳኣና ዬሱሴ፦ «ዔሎሄ! ዔሎሄ! ላማ ሳባቂታኒ» ጌዒ ዼ'ጊዲ ዒላቴኔ። ዬኖኮ ቡሊ''ፃ «ታ ፆኦዛሢዮ! ፆኦዛሢዮ! ዓይጎሮ ኔ ታና ሃሼይ?» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ዒኢካ ዔቂ ዓኣ ፔቴ'' ፔቴ'' ዓሳ፦ «ሃይ ዒ ዔኤሊያሴ ዔኤላ''ኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ዬማና ዔያቶይዳፓ ፔቴ''ስኬይ ጳሽኪ ዴንዲ ዓፒላ ቱርጫጉዴ ባኣዚ'' ዎይኔይዳፓ ኮሾ''ና ሶልኪ፥ ኮሽኩዋ ዑሺዳ ዓጊ ዎኦሺጉዴ ሚሢና ዬሱሴ ዑሽካንዳጉዲ ዔኪ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ሃንጎ ዓሳ ጋዓንቴ፦ «ሃሹዋቴ፤ ሂንዳ ዔኤሊያሴ ሙኪ ዒዛ ዻቂሻቴ ኑ ዛጎም!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ዬሱሴ ላሚ ሃሣ ዼ'ጊዲ ዒላቴስካፓ ሼምፓሢ ዒዛኮ ዱጴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ዬኖና ጌኤዦ ማኣሮኮ ዱማሲፆሮ ጎኦቦና ዓፒላ'' ሎፓ ሉ ሄሊ'' ዳርዒ፥ ላምዖ ፓቂንቴኔ፤ ሓሣ ሳዓኣ ዓጊፄም ላላ ፃሄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ዬማና ሚርጌ ዱኡፒ ቡሊ''ንቴም ፆኦሲም ዱማዼያ ማዔ ሓይቄ ዓሲያ ሃይባ''ፓ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ዬና ዓሳ ዱኡፓፓ ኬስኪ፥ ዬሱሴ ሃይባ''ፓ ዔቄሢኮ ጊንፃ ፆኦሲም ዱማዼ ካታሞ ጌሊ ሚርጌ ዓሲም ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ፄኤቶ ፖኦሊሶ ዓይሣሢና ዒዛና ዎላ'' ዬሱሴ ካፓዞንሢ ሳዖኮ ዓጊፂፆና ሃንጎ ማዔ ባኮዋ ቢያ ዛጋዖ፥ ሚርጌና ዒጊጪ፦ «ጎኔና ሃይ ፆኦሲ ናይታዖኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ዒማ''ና ጌሊላይዳፓ ሙኬዞንሢና ዬሱሴ ኮይሳ ባኣዚ''ና ቢያ ማኣዲ'' ማዺ፥ ዒዛ ጊንፆ ሃንታ ሚርጌ ላኣሊ ዬያ ባኮ ሃኬ ዔቂ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ዔያቶ ባኣካ'' ሜግዴላ ዓጮ'' ማይራማ፥ ያይቆኦቤና ዮሴፔናኮ ዒንዳ፥ ማይራማ፤ ሃሣ ዜብዲዮሴ ናኣቶ''ኮ ዒንዳኣ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ሳዓ ዓማ''ዛ ዓርማቲያሴ ዓጪ ዓሲ ማዔ፥ ዮሴፔ ጌይንታ ፔቴ'' ዖርጎቺ ዓሲስኬያ ሙኬኔ፤ ዒዚያ ዬሱሴ ጉሙርቂ፥ ዒዛ ዓሲ ማዔያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ዬይ ዓሢ ጲላፆሴ ኮይላ'' ዓኣዻዖ ዬሱሴኮ ሌዞ ሺኢቃዛ፥ ጲላፆሴያ ሌዛ ዒዛም ዒንጊንታንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ዬያሮ ዮሴፔ ሌዞ ኬይሲ ሱኡዲ፥ ");
INSERT INTO mdybse_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ፔኤም ጌዒ ዶዶ ሹጮ ጳሊ''፥ ቦኦኪ ኮሾ''ና ቆኦፖይዳ ዱኡካዖ ዼኤፒ ሹቺ ቡምባልሲ ዔቶ'' ካሮ'' ዎዺ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ዬማና ሜግዴላ ዓጮ'' ማይራሞና ባጎ ማይራሞና ዱኡፖኮ ቤርቶ ዛላ'' ዴዒ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ዚሮ ጉቴ''ሎ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ቄኤሶኮ ሱኡጎና ፔርሴ ዓሶና ፔቱሞና ጲላፆሴ ኮራ ዓኣዺ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«ጎዳሢዮ! ዬይ ሉኡቃሢ ቤርታ ሳዛና ዓኣዖ ‹ሃይሦ ኬሊ''ኮ ጊንፃፓ ሃይባ''ፓ ታ ዔቃንዳኔ› ጌዔሢ ኑም ጶቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ዬያሮ ዒዛኮ ጊንፆ ሃንታዞንሢ ዴንዲ ዉኡቂ፥ ዴሮ''ም ሃሣ ‹ሃይሾ ዒ ሃይባ''ፓ ዔቄኔ› ዔያታ ጎዑዋጉዲ፥ ዱኡፓ ሃይሦ ኬሊ'' ሄላ''ንዳኣና ካፒንቶም ዓይሤ፤ ያዺ ማዒባኣያታቴ ጋፒንፆይዳ ዓሶ ዻቢሺፃ ቤርታኣስካፓ ባሼ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጲላፆሴ፦ «ዒንሢኮ ፖኦሊሶ ዔኪ ዓኣዺ ካፒሱዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ዬካፓ ዔያታ ዴንዲ ዱኡፖ ካሮ'' ሹጮይዳ ዖኑሞ ዔርዛ ማላቶ ጳርቂ፥ ፖኦሊሶና ካፒሲ ሃሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ዓይሁዶ ዓሶኮ ሃውሾ ኬላ'' ጋፓዛ ዚሮ ጉቴሎ ጉቴ ዓማ'' ሜግዴላ ዓጮ'' ማይራሞና ሓሣ ሃንጎ ማይራሞና ዎላ'' ዬሱሴኮ ዱኡፖ ዛጋኒ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ዔያታ ሙኩዋንቴ ቤርታ ዔርቲባኣንቴ ሳዓ ዓጊፃዛ፥ ጎዳኮ ኪኢታንቻ ጫሪንጫፓ ኬዲ''፥ ዱኡፖ ዔቶ'' ካሮ'' ዎዾና ሹጫሢ ቡምባልሲ ዑፃ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ዬያ ኪኢታንቻሢኮ ዓኣፖ ካራ'' ዜኤሊንሢጉዲ ፖዓያ፤ ሃሣ ዓፒላ''ኣ ሻቺጉዲ ቦኦራያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ዱኡፖ ዔቶ'' ካፓዞንሢ ኪኢታንቻሢ ዒጊጪፆይዳፓ ዔቄያና ዲቃታዖ ሃይቄ ሌሲ''ጉዲ ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ኪኢታንቻሢ ላኣሎንሢ ኮራ፦ «ዒንሢ ዒጊጪፖቴ፤ ሱፂንቴ ዬሱሴ ዒንሢ ኮዓሢ ታ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ዒዚ ሃይካ ባኣሴ፥ ዒ ኬኤዜሢጉዲ ሃይባ''ፓ ዔቄኔ፤ ሃኒ ሙኪ ዒ ላሄ ቤዞ ዛጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ሃሢ ሩኡሪ ዓኣዺጋፓ ዒዛኮ ጊንፆ ሃንታ ናኣቶ''ም ‹ሃይባ''ፓ ዒ ዔቄኔ፥ ጌሊላ ዒንሢ ዒ ቢሪ ዓኣዻንዳኔ፤ ዒኢካ ዒንሢ ዒዛ ዛጋንዳኔ› ጌዒ ኬኤዙዋቴ፤ ዬያ ታ ዒንሢም ኬኤዜያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ዬካፓ ላኣሎንሢ ኮሺ'' ዒጊጪሢና ሃሣ ዎዛና ዱኡፖ ቤዛፓ ዑኬና ዒዛኮ ጊንፆ ሃንታዞንሢም ኬኤዛኒ ጳሽኪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ዒኢካ ቤዞማና ዬሱሴ ዔያቶ ዴንቃዖ፦ «ዒንሢ ኮሺዳ?» ጋዓዛ ዔያታ ዬሱሴ ባንሢ ሙካዖ ሂርኪ ጌይ ቶኮ'' ዒዛኮ ዓርቂ ዒዛም ዚጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ዬሱሴ፦ «ዒንሢ ዒጊጪፖቴ፤ ዴንዲጋፓ ታ ዒሾንሢ ጌሊላ ዓኣዻንዳጉዲ ዔያቶም ኬኤዙዋቴ፤ ዒኢካ ታና ዔያታ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ላኣሎንሢ ካታሞ ዓኣዺፆይዳ ዓኣንቴ ዱኡፖ ካፓ ፖኦሊሶንሢዳፓ ፔቴ'' ፔቴ''ዞንሢ ካታሞ ዴንዳዖ ማዔ ባኮ ቢያ ቄኤሶኮ ሱኡጎም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ዬካፓ ቄኤሶኮ ሱኡጎና ጪሞና ዎላ'' ቡኪንቲ ዞርቴሢኮ ጊንፃ ፖኦሊሶንሢም ሚርጌ ሚኢሼ ዒንጋዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","« ‹ኑኡኒ ጊንዒ ዓኣንቴ ዬሱሴኮ ጊንፆ ሃንታዞንሢ ሙኪ ዒዛኮ ሌዞ ዉኡቄኔ› ጌዒ ዴሮ''ም ኬኤዙዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ዓጮ'' ዎይሣሢ ዬያ ዋይዜያ ማዔቶ ዒንሢዳ ሜቶ ዒ ሄሊ''ሱዋጉዲ ኑኡኒ ዒዛም ኬኤዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ዬያሮ ፖኦሊሶንሢ ዔያቶም ዒንጎና ሚኢሾ ዔካዖ ዔያቶም ኬኤዚንቴሢጉዲ ማዼኔ፤ ዬያ ሃኖ'' ሄላ''ንዳኣና ዓይሁዶ ዓሳ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ዬካፓ ዬሱሴኮ ጊንፆ ሃንታ፥ ታጶ ፔቴ''ዞንሢ ዒዚ ዔያቶም ዓኣዻንዳጉዲ ኬኤዜ ጌሊላይዳ ዓኣ ዹኮ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ዒኢካ ዒዛ ዔያታ ዴንቃዖ ዒዛም ሂርኪ ጌዒ ዚጌኔ፤ ዛላ'' ጋዓንቴ «ዒዛ ናንጋንዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ዬማና ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ ሙካዖ፦ «ቢታንቶ ቢያ ጫሪንጮና ሳዖናይዳ ታኣም ዒንጊንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ዬያሮ ዓኣዺጋፓ ዴሮ'' ቢያ ዓዶ፥ ናዖ፥ ዓያኖ ጌኤዦናሮ ማዓንዳጉዲ ዋኣፆና ማስኪ ማስኪ ታ ዓሲ ማሁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ታ ዒንሢም ዓይሤ ባኮ ቢያ ዓሳ ካፓንዳጉዲ ዔያቶ ዔርዙዋቴ፤ ታኣኒያ ዓጮ''ኮ ጋፒንፆ ሄላ''ንዳኣና ቢያ ዎዴ ዒንሢና ዎላ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ሓይ ፆኦሲ ናዓሢ ዬሱስ ኪሪስቶሴኮ ኮዦ ሓይሶ ቤርቶኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፥ «ፆኦሲ ኔኤኮ ቤርታ ጎይፆ ጲሻንዳያ ታኣኮ ኪኢቶ'' ናዓሢ ታ ዳካንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ዬይያ፦ ‹ዒንሢ ጎዳኮ ጎይፆ ጊኢጊሹዋቴ፤ ሉኡጎ ጎይፆዋ ፒዚሱዋቴ› ጌዒ ጌዒ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዒላታ ዓሲ ዑኡሲ» ጌይንቲ ፃኣፒንቴሢ ጉዲ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ማስካ ዮሓኒሴ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዓሶም፦ «ፆኦሲ ዒንሢም ጎሞ ዓቶም ጋዓንዳጉዲ ጎሞ ቡኡፂ ቡኡፂ ዋኣሢና ማስቱዋቴ» ጌዒ ኬኤዚ ኬኤዚ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ዒማ''ና ዪሁዳ ዓጮ'' ዓሶንታ ዬሩሳላሜ ዓጮ'' ዓሳ ቢያ ዒዛ ኮራ ሙኪ ጎሞ ቡኡፂ ቡኡፂ ዮርዳኖሴ ጎዖ ዎራ ማስታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ዮሓኒሴ ጋኣሎ ጌይንታ ቆሎኮ ጋፓኔፓ ኮሾ''ና ማኣዖ ማይንቲ፥ ኬርኖይዳ ቃልሾ ቱካ''ኔ፤ ዒዛኮ ሙዓ ዓቢሢና ዑቶ ዔኤሲ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ዒዚ ዓሶም ኬኤዛዖ፦ «ታ ሂርኪ ጌዒ ዒዛኮ ዱርዞ ቱኮ'' ሱዞ ቡላ''ኒ ዒጊቻያ ታ ጊዳ''ፓ ባሼ ታኣኮ ጊንፆ ሙካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","«ታኣኒ ዒንሢ ዋኣሢና ማስካኔ፤ ዒዚ ጋዓንቴ ዒንሢ ዓያና ጌኤሺና ማስካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ዬኖ ዎዶ''ና ዬሱሴ ጌሊላ ዓጫ'' ዓኣ ናዚሬቴ ካታማፓ ሙኪ ዮርዳኖሴ ጎዖ ዎራ ዮሓኒሴ ኮራ ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ዬሱሴ ዋኣፆፓ ኬኬስካኣና ጫሪንጫ ቡሊ''ንቲ ጌኤዦ ዓያና'' ዒዛይዳ ዶኦሌ'' ማሊ ኬዳ''ንቴ ዒ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ዬማ''ና፦ «ኔኤኒ ታኣኮ ናሽኪንታ ናዓሢኬ፤ ታና ኔ ኮሺ'' ዎዛሳኔ» ጋዓ ዑኡሲ ጫሪንጫፓ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ዬማፓ ኔጉዋዖ ጌኤዦ ዓያና'' ዓሲ ናንጉዋ ዳውሎ'' ዒዚ ዓኣዻንዳጉዲ ዔቂሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ዬሱሴ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዖይዲታሚ'' ኬሊ'' ፃላሄ ዒዛ ዛጋኒ ጌሻንቴ ዴዔኔ፤ ዒዚያ ዓኣሢ ካዮ ቦዖ ባኣካ''ኬ፤ ጋዓንቴ ፆኦሲኮ ኪኢታንቻ ሙኪ ዒዛ ማኣዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ዮሓኒሴ ቱኡዞ ማኣራ ቱኡቴስካፓ ዬሱሴ ፆኦሲኮ ኮዦ ሓይሶ ኬኤዚ ኬኤዚ ጌሊላ ዓጮ'' ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ዒዚ ኬኤዛዖ፦ «ፒዙሞ ዎዳ'' ሙኬኔ፤ ሓሣ ፆኦሲኮ ካኣቱማ ዑኬኔ፤ ጎሞይዳፓ ማዑዋቴ፤ ሓያ ኮዦ ሓይሶዋ ጉሙርቁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ዬካፓ ዬሱሴ ጌሊላ ባዞ''ኮ ዓጮና ዓኣዺቤቃ ሲሞኦኔና ዒዛኮ ጌርሲ ዒንዲራሴ ጎዖሢና ሞሎ ፒሪ ዓርቃያታሢሮ ሞላሢ ዓርቆ ሮኦጬ ሱሲጉዲ ጋሶና ሱዞ ባዞ'' ዋኣፆይዳ ዓጋንቴ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ዬሱሴያ ዔያቶም፦ «ሓኒ ታ ጊንፆ ሙኩዋቴ፤ ታኣኒ ዒንሢ ዓካሪ ዓሲ ፒሪ ዓርቃያ ማሓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ዔያታ ቤዞና ፔኤኮ ሞላሢ ዓርቆ ሮኦጮጉዴ ሱዞ ሓሺ'' ዒዛ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ዬካፓ ዒዚ ዻካ'' ሓኬስካፓ ሓሣ ሜሌ'' ዒሾና ጌኤዚና ማዔያ ዴንቄኔ፤ ዔያታኣ ዜብዲዮሴ ናኣቶ''ንሢ ያይቆኦቤና ዮሓኒሴናኬ፤ ዬንሢያ ዋኣፆና ፒንቆ ጎንጎይዳ ፔኤኮ ሞላሢ ዓርቆ ሮኦጮጉዴ ሱዞ ኮሻ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ዬሱሴ ዔያቶ ዛዛጋዖ ዔኤሌ''ኔ፤ ዔያታኣ ዬሱሴ ጊንፆ ዓኣዺፆሮ ዔያቶኮ ዓዳሢ ዜብዲዮሴና ዒዛኮ ማዻ ዓሶ ዋኣፆና ፒንቆ ጎንጎይዳ ሓሺ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ዬማፓ ዬሱሴ ዒዛና ዓኣዞንሢና ዎላ'' ቂፒርናሆሜ ጎዖ ካታሞ ጌሌኔ፤ ሔሊ''ሣ ዓይሁዶ ዓሶኮ ሓውሺፆ ኬሎ''ና ዔያቶኮ ሺኢጲፆ ማኣሮ ጌሊ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ዬሱሴኮ ዔርዚፃ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ዔርዛሢጉዲቱዋንቴ ፔኤኮ ዼኤፒ ቢታንቶና ዔርዛኔ፤ ዬያሮ ዋይዜ ዓሳ ቢያ ዒዛኮ ዔርዚፆና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ዒማ''ና ዓይሁዶ ዓሶኮ ሺኢጲፆ ማኣራ ፑርታ ዓያናና ዓኣ ዓሲ ዓኣኔ፤ ዒዚያ ሂዚ ጌዒ ዼ'ጊዲ ዒላቴኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«ናዚሬቶ ዬሱሴ! ኔኤና ኑኡና ዎላ'' ዓይጎ ፔቱሞ ዓኣይ? ኔ ኑና ባይዛኒ ሙኪያ? ታኣኒ ኔኤኮ ዖኑሞ ዔራኔ፤ ኔኤኒ ጌኤሺ ፆኦሲ ናይኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ዬሱሴያ ፑርቶ ዓያናሢ፦ «ዚቲ ጌዔ፤ ዓሢዳፓ ኬስኬ!» ጌዒ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ፑርቶ ዓያናሢያ ዓሢ ሚርጌና ጎቃይሴሢኮ ጊንፃ፥ ፑኡፒ ዑኡሲና ዒላቲ ዒዛይዳፓ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ዓሳ ቢያ ዲቃቲሢና ሄርሺ ዎሊ ኮራ፦ «ሓይ ዓይጎ ባኣዚ''ዳይ? ፑርቶ ዓያኖ ፔ ቢታንቶና ዒዚ ዓይሣኔ፤ ዔያታኣ ዒዛም ዓዓይሢንታኔ፤ ሓይ ዓኪ ዔራቶቱዋይ?» ጌዒ ጌዒ ሴካና ሓንጋና ዎሊ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ዬያሮ ቤዞማና ዬሱሴኮ ሱ'ንፃ ጌሊላና ኮይሎ''ይዳ ዓኣ ዓጮ'' ቢያይዳ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ዬማ''ና ዬሱሴ ዓይሁዶኮ ሺኢጲፆ ማኣራፓ ኬስኪ ያይቆኦቤና ዮሓኒሴና ዎላ'' ሲሞኦኔና ዒንዲራሴና ማኣሪ ጌላንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ጋሮይዳ ሲሞኦኔኮ ባይሳ ቆፂንቲ ላሂ ዓኣኔ፤ ዒዞኮ ቆፂንቲፆዋ ዓሳ ዒዛም ቤዞና ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ዬሱሴ ዒዞ ባንሢ ዑካዖ ኩጮ ዒዞኮ ዓርቂ ዔቂሴኔ፤ ቆሣኣ ዒዞ ሓሼኔ፤ ዒዛ ዔቂ ዔያቶ ሾኦቺንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ዓባ'' ጌሊ ሳዓ ዓሜሢኮ ጊንፃፓ ዓሳ ሓርጊንቴ ዓሶንታ ፑርቶ ዓያና'' ዓርቄ ዓሶ ቢያ ዬሱሴ ባንሢ ዔኪ ዔኪ ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ካታሞ ዓሳ ቢያ ማኣሮ ጋሮይዳ ቡኪንቲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ዬሱሴ ሚርጌ ዱማ ዱማ ዶርዖና ሜታዻ ዓሶ ፖዒሴኔ፤ ፑርቶ ዓያኖዋ ዓሶፓ ኬሴኔ፤ ፑርቶ ዓያና'' ዬሱሴ ዖናታቴያ ዔራኔ፤ ማዔቶዋ ዔያታ ፔቴ'' ባኣዚ'' ጋዓንዳጉዲ ዬሱሴ ዔያቶ ዓይሢባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ካሪፆ ዑፃ፥ ሳዓ ዹሚ ዓኣንቴ ዬሱሴ ጴጪ ኬስካዖ ሺኢቃኒ ዓሲባኣ ቤሲ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ሲሞኦኔና ዒዛኮ ላጎንሢ ዬሱሴ ኮዒ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ዔያታ ዒዛ ዴንቃዖ፦ «ዓሳ ቢያ ኔና ኮዓንቴቱዋይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ዬሱሴ ማሓዖ፦ «ታ ሙኬሢ ዔርዛኒ ማዔያታሢሮ ዔርዛኒ ሓያ ዑኬ ዓኣ ጉርዶ ኑ ዓኣዾም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ዬያሮ ዓይሁዶ ዓሶኮ ሺኢጲፆ ማኣራ ዔርዚ ዔርዚ ሓሣ ፑርቶ ዓያኖዋ ዓሶፓ ኬሲ'' ኬሲ'' ጌሊላ ዓጮ'' ቢያ ሓንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ዑፆይዳ ኬስካ ፑርቶ ዶርዓሢና ዓርቂንቴ ፔቴ'' ዓሲ ዬሱሴ ኮራ ሙኪ ዒዛኮ ቶኮ'' ዴማ'' ጉምዓታዖ፦ «ኔ ኮዔቴ ታና ጌኤሻ''ኒ ዳንዳዓኔ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ዬሱሴያ ሚጪንታዖ ኩጮና ዒዛ ካኣሚ፦ «ጌኤሽኬ! ኔ ጌኤሽካንዳጉዲ ታ ኮዔኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ዑፆይዳ ኬስካ ፑርቶ ዶርዓሢ ዓሢ ሓሻዛ ቤዞማና ዒዚ ጌኤሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ዬሱሴ ዓሢ ዳካኣና ሂዚ ጌዒ ኮሺ'' ላቲ'' ዓይሤኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«ሓያ ባኮ ዖኦማኣ ኔ ኬኤዙዋጉዲ ኔና ዔሬ፤ ጋዓንቴ ዓኣዺጋፓ ኔና ቄኤሳሢም ዻዌ፤ ዴሮ''ማኣ ኔኤኮ ጌኤሽኪፃ ማርካ ማዓንዳጉዲ ዬያጉዴ ዶርዓስካፓ ዻቄ ዓሳ ዒንጎም ጌዒ ሙሴ ዓይሤ ዒንጊፆ ፆኦሲም ዒንጌ።» ");
INSERT INTO mdybse_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ያዒ ማዔቶዋ ዓሢ ዒኢካፓ ኬስካዖ ዓሲም ቢያ ቤዞይዳ ኬኤዚሢ ዓርቄኔ። ዬያይዳፓ ዔቄያና ዬሱሴ ዎኖ ካታሞ ማዔቶዋ ፔጌና ጌላኒ ዳንዳዒባኣሴ። ጋዓንቴ ካታሞኮ ዙላ'' ዓሲባኣ ዔዌ ቤስካ ናንጋኔ፤ ዓሳ ቢያ ቤዛፓ ዒዛ ባንሢ ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ዬሱሴ ዻካ'' ዓቢኮ ጊንፃፓ ቂፒርናሆሜ ጌይንታ ካታሜሎ ማዒ ሙኬኔ፤ ዒዚ ዒኢካ፥ ናንጋ ማኣራ ዓኣሢ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ሚርጌ ዓሲ ሙኪ ጋሮና ዙሎ''ና ቤሲባይዚ ኩሚ'' ቡኪንቴኔ፤ ዬሱሴያ ዔያቶም ቃኣሎ'' ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ዬማና ዖይዶ ዓሲ ፔቴ'' ሓንታኒ ዳንዳዑዋ ዎቦ ዓሲስኬያ ኬዲ ዬሱሴ ባንሢ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ዴሮ''ኮ ዺቡሞፓ ዔቄያና ዓሢ ዔያታ ዬሱሴ ሔሊ''ሳኒ ዳንዳዒባኣሢሮ ዬሱሴ ዓኣ ዛሎ''ና ሳኮ ሻሂ ዬሱሴኮ ቤርታ ዒዛ ኬዶና ሓላሢና ዎላ'' ኬይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ዬሱሴ ዔያቶኮ ዎማዒ ጉሙርቂሢ ዓኣቴያ ዛጋዖ፥ ሓንታኒ ዳንዳዑዋ ዎቦ ዓሢም፦ «ታ ናዓሢዮ ጎማ ኔኤኮ ዓቶም ጌዒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢዳፓ ፔቴ'' ፔቴ''ዞንሢ ዒኢካ ዴዒ ዓኣዖ ፔ ዒኖና፦ ");
INSERT INTO mdybse_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ዎዲ'' ሓይ ዓሢ ሓያ ጌዒ ጌስታይ? ሓይ ፆኦሲ ጫሽኪሢኬ፤ ፔቴ'' ፆኦሲዳፓ ዓታዛ ጎሜ ዓቶም ጋዓኒ ዳንዳዓሢ ዖናዳይ?» ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ዬማዒ ጌዒ ዔያታ ማላኣና ዬሱሴ ቤዞማና ዔያቶኮ ዒኖ ማሊፆ ፔ ዓያኖና ዔራዖ ሂዚ ዔያቶም ጌዔኔ፦ «ዒንሢ ዒኖና ዓይጎሮ ሓያ ጌይ ማላይ? ");
INSERT INTO mdybse_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ሓያ ሃንታኒ ዳንዳዑዋ ዎቦ ዓሢም ‹ጎማ ኔኤኮ ዓቶም ጌዒንቴኔ› ጌዒሢና ‹ዔቂ ኔኤኮ ኔና ዔኪሙኮና ሓላሢ ኬዲ ዓኣዼ› ጌዒሢዳፓ ዎና ሼሌዓይ? ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ዓሲ ናዓሢኮ ሳዖይዳ ጎሜ ዓቶም ጋዓኒ ዎልቄና ዓኣ ቢታንቶ ዓኣያ ማዔሢ ዒንሢ ዔራንዳጉዲ» ጌዔስካፓ ሓንታኒ ዳንዳዑዋ ዎባሢም፦ ");
INSERT INTO mdybse_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ታ ኔኤም ጋዓኔ፤ ዔቂ ኔና ኬዲ ሙኮና ሓላሢ ኬዲ ኔ ማኣሪ ዴንዴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ሓንታኒ ዳንዳዑዋ ዎባሢያ ቤዞማና ዔቃዖ ፔና ኬዲ ዔኪ ሙኮና ሓላሢ ኬዲ ቢያ ዓሳ ዛጋንቴ ኬስኬኔ። ዬያሮ ዓሳ ቢያ ዲቃቲ ሄርሻዖ፦ «ሓያ ጉዴ ባኣዚ'' ኑ ዛጊ ቤቂ ባኣሴ» ሂዚ ጌዒ ጌዒ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ዬማፓ ዬሱሴ ጌሊላ ባዞ'' ዓጮ ላሚ ዓኣዼኔ፤ ዴራ'' ቢያ ዒዛ ባንሢ ሙካዛ፥ ዒዚ ዔያቶ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ዬካፓ ዒዚ ዴንዳኣና ዒልፒዮሴ ናኣዚ'' ሌዊ ጎዖሢ ኮርሞም ማዓ ባኣዚ''ፓ ቢያ ሚኢሼ ቡኩሳያታሢሮ ዒዚ ፔኤኮ ማዾ'' ቤዛ ዓኣንቴ ዛጋዖ፦ «ሓኒ ዬዔ» ጌዔኔ፤ ዒዚያ ዔቂ ዒዛ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ዬካፓ ዬሱሴ ሌዊ ማኣራ ሙኡዚሮ ጊኢጋዛ ሚርጌ ዓሲ ዒዛ ጊንፆ ሓንታሢሮ ዔያቶይዳፓ ሚርጌሢ ኮርሞም ማዓ ባኮይዳፓ ሚኢሾ ቡኩሳዞንሢና ጎሞ ዓሶናታዖ ዬሱሴና ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ና ዎላ'' ሙዓኒ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ፔርሴ ዓሶ ዜርፃፓ ማዔ፥ ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢ ዬሱሴ ሚኢሾ ቡኩሳ ዓሶና ጎሞ ዓሶና ዎላ'' ሙዓሢ ዛጋዖ፦ «ዓይጎሮ ዒዚ ዬያጉዴ ዓሶና ዎላ'' ሙዓይ?» ጌዒ ዬሱሴኮ ጊንፆ ሓንታዞንሢ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ዬሱሴ ዔያታ ዬያ ጋዓሢ ዋይዛዖ፦ «ዼኤሻ ዔራ ዓሲ ሓርጊንቴ ዓሲም ኮይሳንዳኣፓዓቴም ዋሊ'' ዓሲም ኮይሱዋሴ፤ ታኣኒ ሙኬሢ ጎሞ ዓሶ ዔኤላ''ኒ ማዓንዳኣፓዓቴም ጌኤዦ ዓሶ ዔኤላ''ኒ ሙኪባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ማስካ ዮሓኒሴኮ ጊንፆ ሓንታዞንሢና ፔርሴ ዓሶና ሙዖ ሓሺ''ፆ ዳምቦ ካፓኔ፤ ዬያሮ ዓሳ ዬሱሴ ባንሢ ሙካዖ፦ «ማስካ ዮሓኒሴ ጊንፆ ሓንታዞንሢና ፔርሴ ዓሶና ሙዖ ሓሾ'' ዳምቦ ካካፓንቴ፥ ኔ ጊንፆ ሓንታዞንሢ ዬያጉዲ ካፑዋኣሢ ዓይጎሮዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ዬሱሴ ዔያቶም ማሓዖ፦ «ዑኡታ''ሢ ዔያቶና ዎላ'' ዓኣንቴ ዔፖ ዓሳ ሙዖ ሓሺ''ፆ ዳምቦ ካፓኒ ዳንዳዓ? ዑኡታ''ሢ ዔያቶና ዎላ'' ዓኣንቴ ዔያታ ሙዖ ሓሺ''ፆ ዳምቦ ካፓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ጋዓንቴ ዑኡታ''ሢ ዔያቶይዳፓ ዱማዻንዳ ዎዴ ሙካንዳኔ፤ ዬኖ ዎዶ''ና ዔያታ ሙዖ ሓሺ''ፆ ዳምቦ ካፓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ዖናታቴያ ዓኪ ዓፒላይዳፓ ዔኪ ጪሚ ዓፒላይዳ ዓጊ ሲኩዋሴ፤ ዓጊ ሲኬቶ ዓኮ ዓጊፃ ጉርሚ ጪሞ ዓፒሎ ዳዳርዛንዳኔ፤ ዳርዒፃኣ ቤርታኣስካፓ ፔቶ ዳልጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ዬያጉዲ ሶልኪ ዑሺ ዋሆ ጪንቄ ዖቲዳ ሺሜ ዋሂንቱዋሴ፤ ዋሂንቴቴ ጋዓንቴ ሺሜ ዑዣ ቡርቂ ዖቶ ዹኡሳንዳኔ። ዑዣኣ ላኣሊንታንዳኔ። ዬያሮ ሺሜ ዑሺም ዓኪ ጌኤሺ ዖቲ» ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ዬሱሴ ዒዛኮ ጊንፆ ሓንታዞንሢና ዎላ'' ዓይሁዶኮ ሓውሾ'' ኬሎ''ና ፔቴ'' ዛርጌ ጎሺ ጊዴና ዓኣዻንቴ ዒዛኮ ጊንፆ ሓንታዞንሢ ዛርጎ ቲሻሢ ዱኡዚ ዱኡዚ ዔኪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ዬያሮ ፔርሴ ዓሳ ዛጋዖ፦ «ሓኣዛጌ፥ ኔኤኮ ጊንፆ ሓንታዞንሢ ዓይሁዶኮ ሓውሾ'' ኬሎ''ና ማዺንቱዋ ባኣዚ'' ዓይጎሮ ማዻይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ዬሱሴ ማሓዖ፦ «ዳውቴ ፔኤኮ ዓሶና ናይዺንቲ ሜታዼ ዎዶ''ና ዒዚ ዓይጎ ማዼቶዋ ዒንሢ ማሊ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ዓቢያታሬ ጎዖሢ ቄኤሶኮ ቢያ ዑሢ ማዒ ማዻ ዎዶ''ና ዒዚ ፆኦሲ ማኣሪ ጌሊ ቄኤሶይዳፓዓቴም ዖኦማኣ ላኣጊንቴያ ማዔ፥ ፆኦሲም ዒንጎና ካፆ ሙዔኔ፤ ዒዛና ዎላ'' ዓኣ ዓሶማኣ ዒንጌኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ሓሣ ዬሱሴ ሂዚ ጌዔኔ፦ «ዓይሁዶኮ ሓውሺፆ ኬላ'' ዓሲም ማዢንታንዳኣፓዓቴም ዓሲ ዬኖ ሓውሾ ኬሌሎም ማዢንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ዬያጉዲ ዓሲኮ ናዓሢ ዬኖ ሓውሾ ዓቤሎኮዋ ጎዳኬ።» ");
INSERT INTO mdybse_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ዬካፓ ዬሱሴ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ማዒ ጌሌኔ፤ ዒኢካ ፔቴ'' ኩቺ ዎቦ ዓሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳፓ ፔቴ'' ፔቴ'' ዓሳ ዬሱሴ ዎጎና ዓይሢሳኒ ኮዓዖ፦ «ሂንዳ ሓኖ'' ዒዚ ሓውሾ ዓቦና ሓያ ዎቦ ዓሢ ፓሣቴ ኑ ዛጎም» ጌዒ ዒዛ ካፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ዬሱሴ ኩጮ ዎቦ ዓሢም፦ «ሓይካ ሙኪ ባኣካ'' ዔቄ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ዬካፓ ዒዚ ዔያቶ ዖኦጫዖ፦ «ዓይሁዶኮ ሓውሾ ኬሎ''ና ዓይሢንቴሢ ኮሺ ማዻንዳጉዲሞ ፑርታ ማዻንዳጉዲዳይ? ሼምፖ ዻዻቂሾምሞ ባባይዞምዳይ?» ጋዓዛ፥ ዔያታ ጋዓንቴ ዚቲዮ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ዬሱሴ ዔያቶኮ ዒና'' ዔኩዋያ ማዒ ዶጬሢሮ ዖዪጋፓ ዒኢካ ዓኣ ዓሶ ዻጋዺ ዛጋዖ ዎቦ ዓሢም፦ «ኩጮ ኔኤኮ ፒሼ» ጌዔኔ። ዒዚያ ፒሼ ዎዶ''ና ኩጫ ዻቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ዬያሮ ፔርሴ ዓሳ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛፓ ኬስካዖ ዑኬና ዎማይዲ ዬሱሴ ዔያታ ባይዛንዳቴያ ካኣታ''ሢ ሄሮዲሴ ዓሶና ዎላ'' ዞርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","ዬሱሴ ዒዛኮ ጊንፆ ሓንታዞንሢና ዎላ'' ጌሊላ ባዞ'' ባንሢ ዴንዴኔ። ዒማ''ና ዒዚ ማዻ ባኮ ዋይዜ ዓሳ ሚርጌሢ ዒዛ ባንሢ ሙኬኔ፤ ዔያታ ሙኬሢ፦ ጌሊላይዳፓ፥ ዪሁዳይዳፓ፥ ዬሩሳላሜይዳፓ፥ ዔዶሚያሴይዳፓ፥ ዮርዳኖሴ ዎሮኮ ሱካ ዓኣ ዓጫ''ፓ ሓሣ ፂሮሴና ሲዶና ጌይንታ ካታማፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ዴሮ''ኮ ኮሺ'' ዺቢፆይዳፓ ዔቄያና ዓሳ ዒዛ ቱቺ ሜታሱዋጉዲ ዋኣፆና ፒንቆ ጎንጎ ዒዛም ጊኢጊሻንዳጉዲ ዒዛኮ ጊንፆ ሓንታዞንሢ ዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ሚርጌ ዓሶ ዒዚ ቤርታ ዓውሴሢሮ ሓርጌና ሜታዻ ዓሳ ቢያ ዒዛኮ ዑፆ ካኣማኒ ኮዒ ሒዒንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ፑርቶ ዓያና'' ዬሱሴ ዛጌ ዎዶ''ና ቢያ ዒዛኮ ቤርታ ሎኦሚ ሎኦሚ፦ «ኔኤኒ ፆኦሲ ናዓሢኬ» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ዬሱሴ ፑርቶ ዓያኖም ዒዛኮ ዖኑሞ ኬኤዙዋጉዲ ዶዲሺ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ዬሱሴ ጌሜሮ ኬስካዖ ዒዚ ኮዔዞንሢ ፔ ባንሢ ዔኤሌ''ኔ፤ ዔያታኣ ዒዛ ባንሢ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ዔያታ ዒዛና ዎላ'' ማዓንዳጉዲ፥ ዔርዛንዳጉዲ ዔያቶ ዳካኒ ታጶ ላምዖንሢ ዶኦሪ፦ «ዳኪንቴዞንሢ» ጋዓ ሱ'ንሢ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ሓሣ ፑርታ ዓያና ኬሳንዳጉዲ ዎልቄና ዓኣ ቢታንቶ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ታጶ ላምዖ ዳኪንቴዞንሢ ማዒ ዶኦሪንቴዞንሢ ሓንሢኬ፦ ጴፂሮሴ ጌዒ ሱ'ንፆ ጌሦና ሲሞኦኔ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ቦዖኔርጌሴ ጌይፃ ጉጉንሢጉዲ ማዔ ዓሶንሢ ጌዒ ሱ'ንፃ ጌሢንቴ ዜብዲዮሴ ናኣቶ'' ያይቆኦቤና ዒዛኮ ጌርሲ ዮሓኒሴ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ዒንዲራሴ፥ ፒሊጶሴ፥ ቤርቴሌሞሴ፥ ማቲዮሴ፥ ቶኦማኣሴ፥ ዒልፒዮሴ ናኣዚ'' ያይቆኦቤ፥ ታዲዮሴ፥ ፔ ዓጮ'' ሚጪንታ ሲሞኦኔ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ዬሱሴ ዓኣሢ ዒንጌ ዓስቆሮንቶ ዪሁዳንታኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ዬካፓ ዬሱሴ ማኣሪ ጌላዛ ሚርጌ ዓሲያ ሙኪ ቡኬሢሮ ዒዛና ዒዛኮ ጊንፆ ሓንታዞንሢናም ዴዒ ሙዓኒ ማጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ዬሱሴኮ ማኣሮ ዓሳ፦ «ዒዚ ዣኣሽካኔ» ዓሳ ጋዓሢ ዋይዚ ዒዛ ዓርቂ ዔካኒ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ዬሩሳላሜፓ ሙኬ ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢ፦ «ዒዛይዳ ቢዔልዛቡሌ ዓኣኔ፥ ዒዚ ፑርቶ ዓያኖ ኬሳ''ሢ ሓያ ፑርቶ ዓያኖኮ ሱኡጋሢ ማዔ ቤዔልዛቡሌናኬ» ጌዒ ጌዒ ጌስታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ዬሱሴ ዔያቶ ፔ ባንሢ ዔኤሊ'' ኮኦኪንሢና ሂዚ ዔያቶም ጌዔኔ፦ «ፃላሄ ፃላሄ ዎዲ'' ኬሳ''ኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ፔቴ'' ካኣቲ ዓጪ ዎሊና ፓቂንቲ ዖልቴቶ ዬኖ ዓጮ'' ካኣቱማ ዶዲ ናንጋኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ሓሣ ፔቴ'' ማኣሪ ዓሲ ዎሊና ዣሊ ፓቂንቴቴ ዬና ማኣሬላ ማኣሪ ማዓኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ዬያጉዲ ፃላሄ ዎሊና ፓቂንቴቶ ጋፒንሢ ማዓንዳኣፓዓቴም ዔቃኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«ሓሣ ፔቴ'' ዎልቄና ዓኣ ዓሲ ማኣሪ ጌላኒ ዒዛ ዎልቆሲ ቤርታዺ ቱኪ''ባኣዖ ዒዛኮ ዓኣ ባኮ ቡሪ ዔካኒ ዳንዳዒንቱዋሴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓሳ ማዻ ጎሞና ሓሣ ፆኦሲ ጫሽካ ጫዣታዖ ዓቶም ጌዒንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ጋዓንቴ ዓያና ጌኤሺ ጫሽካሢም ቢያ ናንጊና ጋሌ ማዓንዳኣፓዓቴም ጎማ ዓቶም ጌዒንታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ዬሱሴ ዬኖ ጌዔሢ ዓሳ፦ «ዒዛይዳ ፑርታ ዓያና ዓኣኔ» ጌዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ዬሱሴኮ ዒንዶና ጌርሲንሢና ዒዚ ዓኣ ቤዞ ሙኪ ካራ'' ዔቃዖ ዓሲ ዳኪ ዒዛ ዔኤሊ''ሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ዒዛኮ ዓጫ ዴዒ ዓኣ ዓሳ ዒዛም፦ «ኔኤኮ ዒንዳኣ፥ ጌርሲንሢ፥ ጌሮንሢ ካራ'' ኔና ኮዓኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ዬሱሴ ዔያቶም፦ «ዒንዳ ታኣኮ ዖናዳይ? ጌርሲንሢያ ዖናንሢዳይ?» ጌዒ ማሓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ዒዛኮ ዓጫ ዴዔ ዓሶ ባንሢ ዛጊ ዛጊ፦ «ሓኣቶ ዛጉዋቴ፥ ታኣኮ ዒንዶና ጌርሲንሢና ሓኣቶኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ዖናታቴያ ፆኦሲ ዓይሢፆ ኩንሣዞንሢ ቢያ ታኣኮ ዒሾ ሚሾንታ ዒንዶንታኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ዬሱሴ ጌሊላ ባዞ'' ዓጫ ላሚ ዔርዚሢ ዓርቄኔ። ኮሺ'' ሚርጌ ዓሲ ዒዛ ባንሢ ሙኪ ቡኪንቴያ ማዔሢሮ፥ ዒዚ ዋኣፆና ፒንቆ ጎንጎ ጋሮ ጌሊ ዴዔኔ፤ ዴራ'' ጋዓንቴ ቢያ ባዞ'' ዓጫ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ዒዚ ዔያቶም ኮኦኪንሢና ሚርጌ ባኣዚ'' ዔርዜኔ፤ ዔርዚፆዋ ሒዚ ጌዒ ዓርቄኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ዋይዙዋቴ! ፔቴ'' ዓሲ ዜርሢ ዜርቃኒ ኬስኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ዒዚ ጎዦይዳ ዜርቃኣና ፔቴ'' ፔቴ'' ዜርፃ ጎይፆ ዓጫ ኬዳ''ዛ ካፓ ሙኪ ሙዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ዛሎ'' ዜርፃ ዻካ'' ዓጪ ዓኣ፥ ሓኣሻ ሳዓይዳ ኬዳ''ዖ ሚርጌ ዓጪ ባኣሢሮ ዑኬና ባቃሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ማዔቶዋ ዓባ'' ኬስኬ ዎዶ''ና ሹሌ''ኔ፤ ፃጲ ባኣሢሮዋ ሜሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ዛሎ'' ዜርፃ ዓንጊሢ ቶሻ ባኣካ ኬዴ''ም ዓንጊፃ ዑጊ ባይዜሢሮ ዓኣፑዋዖ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ዓቴ'' ዜርፃ ሓሣ ቃራ ሳዓይዳ ኬዴ''ሢሮ ባቃሌኔ፤ ባቃላ''ኣ ዑጊ ካፄኔ፤ ፔቴ''ዛ ሃይሢታሚ'' ዓኣፒ፥ ባጌላ ላሂ''ታሚ'' ዓቴ''ዛኣ ፄኤታ ዓኣፔኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ዬሱሴ፦ «ሓያ ዋይዛሢ ኮሺ'' ዋይዞንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ዬሱሴ ፔኤሮ ማዔ ዎዶ''ና ዒዛ ኮራ ዋይዞሮ ሙኬ ዓሶንታ ዒዛኮ ጊንፆ ሓንታ ታጶ ላምዖ ናኣቶ''ንታ ኮኦኪንሦና ዒዚ ኬኤዜሢኮ ቡሊ''ፆ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ዒዚ ዔያቶም ሂዚ ጌዔኔ፦ «ዒንሢም ፆኦሲኮ ካኣቱሞ ማኣሮኮ ዓኣሺንቴ ዔራቶ ዒንጊንቴኔ፤ ሓንጎዋቶ ዙላ'' ዓኣዞንሢም ጋዓንቴ ቢያ ባኣዚ'' ኮኦኪንሢና ኬኤዚንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ያዺ ማዔሢ፦ ‹ዔያታ ፆኦሲ ባንሢ ማዒ ጎማ ዔያቶም ዓቶም ጌዒንቱዋጉዲ ዛጎ ዛጋያታዖ ዴንቁዋሴ ዋይዞ ዋይዛያታዖ ዒና ዔኩዋሴ› » ጌይንቴ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ዬሱሴ ዔያቶም ሂዚ ጌዔኔ፦ «ዒንሢማኣ ሓይ ኮኦኪንሣ ዔርቱዋዓዳ? ሂዳዖ ሓንጎ ኮኦኪንሦ ቢያ ዎዲ'' ዒንሢ ዔራኒ ዳንዳዔይ? ");
INSERT INTO mdybse_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ዜርቃሢ ፆኦሲ ቃኣሎ'' ዜርቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ቃኣላ'' ዜርቂንታ ዎዶ''ና ጎይፆ ዓጫ ኬዴ'' ዜርፄላ ዻዋሢ፦ ቃኣሎ'' ዋይዛኣና ቤዞማና ዔያቶኮ ዒኖይዳ ዜርቂንቴ ቃኣሎ'' ፃላሄ ዔካ ዓሶኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ዬያጉዲ ሓኣቾ ሳዖይዳ ዜርቂንቴሢ ዻዋሢ፦ ቃኣሎ'' ዋይዛዖ ዑኬና ዎዛዺ ዔካዞንሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ጋዓንቴ ዔያታ ዻካ'' ዎዴሮ ማዓንዳኣፓዓቴም ዖዶሲ ፃጲ ባኣሢሮ ዻካ'' ዎዴኮ ጊንፃፓ ፆኦሲ ቃኣሎ'' ዛሎና ሜቶና ዳውሲሢና ሙኬቶ ዻቢንቲ ኔጉዋዖ ሓሻ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ዓንጊፆ ቶሾ'' ባኣካ'' ዜርቂንቴ ዜርፄላ ዻዋሢ፦ ቃኣሎ'' ዋይዛ ዓሶንሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ጋዓንቴ ሓያ ዓጮ'' ናንጎሮ ሜታዺፆና ቆሎ ናሹሞና ሜሌ'' ፓሡዋ ባኣዚ'' ሱኡካዺሢ ዔያቶኮ ዒኖይዳ ጌላዖ ፆኦሲኮ ቃኣሎ'' ዋሊ''ሲ ዓኣፑዋያ ማሓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ቃሮ'' ዓጮ''ይዳ ዜርቂንቴ ዜርፃ ዻዋሢ፦ ጋዓንቴ ቃኣሎ'' ዋይዚ ዔካ ዓሶኬ። ዬያጉዴ ዓሳ፦ ፔቴ''ይ ሓይሢታሚ''፥ ባጋሢ ላሒ''ታሚ''፥ ዓቴ''ሢ ፄኤታ ዓኣፒ ዓኣፓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ሄሊ''ሳዖ ዬሱሴ ዔያቶም፦ «ዓሲ ፖዒ ፖዒሳዖ ዔኤቢና ጉኡፒ ጌሣ? ጌሣሢ ፖዓ ጴዻያ ዼ'ጌ ቤሲዳቱዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ዎይቴቶዋ ዓኣሺንቴ ባኣዚ'' ፔጋዹዋዖ ዓኣቾና ባኣዚ'' ዔርቱዋዖ ዓታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ዬያሮ ዋይዛ ዋይዚ ዓኣሢ ዋይዞንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ዬሱሴ ላሚ ዔያቶም፦ «ዋይዛ ባኮሮ ዒንሢ ኮሺ'' ዔሩዋቴ፤ ዒንሢ ማካ'' ባኮማና ዒንሢም ማኪንታንዳኔ፤ ዬያፓ ዑሣ ዒንሢም ቃሲ''ንታንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ዔኤቢ ዓኣሢም ጊዳ'' ቃሲ''ንታንዳኔ፤ ዔኤቢባኣ ዓሢዳፓ ዻካ''ታዖ ዓኣቶ ዒማ ዔኪንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ሄሊ''ሳዖ ዬሱሴ ዔያቶም ሂዚ ጌዔኔ፦ «ፆኦሲኮ ካኣቱማ ሳዓ ዜርሢ ዜርቃ ዓሲ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ዓሢያ ዋንቶና ጊንዓኔ፤ ካራዛ ዒዚ ጴጫኔ፤ ዎማይዲታቴያ ዒዚ ዔሩዋንቴ ዜርፃ ባቃሊ ዑጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ሳዓ ፔኤሮ ቤርታዺ ባቃልሲ፥ ሔሊ''ሳዖ ጉኡሽኪሲ ዻዋኔ፤ ጊንፃፓ ጉኡዦ ዑፆይዳ ዓኣፒ ጴዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ሓኣካ ካፂ ሜሌም ቡሮ ዎዳ'' ሄላ''ዛ ዓሢ ዑኬና ሓኣኮ ቡኩሳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ዬሱሴ ሂዚ ጌዔኔ፦ «ፆኦሲኮ ካኣቱማ ዓይጎ ማላኔ ኑ ጋዓንዳይ? ዓይጌንዴ ኮኦኪንሢና ኑ ዒዞ ኮሺ'' ኬኤዛንዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","«ዒዛ ሴናፒጬ ጌዒንታ ዻኮ'' ዜርፄሎ ማላኔ፤ ዒዛ ዜርቂንታ ዎዶ''ና ሳዓ ዜርቂንታ ዜርፆይዳፓ ቢያ ኮሺ'' ዻካ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ዜርቂንቲ ባቃሌሢኮ ጊንፃ ጋዓንቴ ዑጊፆና ቱኮ'' ባኮ ቢያይዳፓ ባሻኔ። ጫሪንጮ ካፓ ዴዓንዳያ ሄላ''ንዳኣና ዼኤፒ ካኣፒ ጌታኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ዬሱሴ ዴራ'' ጶቂሣኒ ዳንዳዓያ ዬንሢና ዬንሢ ማላ ሚርጌ ኮኦኪንሢና ፆኦሲኮ ቃኣሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ዒዚ ዔያቶም ኮኦኪንሥሢባኣያ ኬኤዙዋሴ፤ ጋዓንቴ ዒዚ ፔኤኮ ጊንፆ ሃንታዞንሢና ሌሊ ዓኣ ዎዶ''ና ቢያ ባኣዚ'' ዔያቶም ኮሺ'' ፔጋሲ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ዬኖ ዓቦ'' ዋንቶ ዬሱሴ ፔኤኮ ጊንፆ ሓንታዞንሢ፦ «ኑኡኒ ባዞ''ኮ ሶንጌኖ ሱኮ ፒንቆም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ዔያታ ዴሮ''ይዳፓ ዱማዺ ዴዒ ዓኣ፥ ዋኣፆና ፒንቆ ጎንጎና ዬሱሴ ዔኪ ዴንዳኣና ሜሌ'' ዋኣፆና ፒንቆ ጎንጊያ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ማዓዛ ዶዲ ዓልጋ ዋኣፆይዳ ዔቂ ዋኣፃ ጎንጋ ኩማንዳያ ሄላ''ንዳኣና ጉዳሢ ዋኣፆ ሂዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ዬማና ዬሱሴ ዋኣፆና ፒንቆ ጎንጎኮ ጊንፆ ዛላ'' ኬሬ ጌሢ ላሂ ዓኣንቴ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ጴቻዖ፦ «ኑና ዔርዛሢዮ! ኑኡኒ ኩዴንቴሞ ኔኤኒ ዚቲዮ ጋዓ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ዒዚ ጴጫዖ ዢባሮ ጎሬኔ፤ ባዞ''ዋ፦ «ዓጊፂፖ! ዚቲ ጌዔ!» ጌኤኔ፤ ዢባራኣ ዓጊሦ ሓሻ''ዛ ቢያ ባካ'' ዚቲዮ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ዬያሮ ዬሱሴ ዒዛኮ ጊንፆ ሓንታዞንሢም ጋዓዖ፦ «ዓይጎሮ ዒንሢ ሂዲ ዒጊጫይ? ጉሙርቂሢ ዎይቲ ዒንሢኮ ባይቄይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ዔያታ ኮሺ'' ዒጊጪ፦ «ዓህ! ሓይ ጉዳሢንታ ባዞ''ንታ ዓይሢንታሢ ዖናዳይ?» ዎሊ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ዬሱሴና ዒዛኮ ጊንፆ ሓንታዞንሢና ዋኣፆና ፒንቆ ጎንጎ ቶጊ ጌሊላ ባዞ'' ፒንቃዖ ጌርሴኖኔ ዓጮ'' ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ዒማና ዬሱሴ ዋኣፆና ፒንቆ ጎንጎይዳፓ ኬኬዳኣና ፑርታ ዓያናና ዓርቂንቴ ዓሲ ዱኡፒ ቤሲፓ ኬስኪ ካኣሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ዬያ ዓሢኮ ናንጋ ዱኡፒ ቤሲዳኬ፤ ዖኦኒያ ዒዛ ካኒቢራቴና ቱኪ'' ቃዛኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ዒዛኮ ቶኮና ኩጮና ሚርጌ ኬሊ'' ዓንጊ ዱፄና ካኒ ቢራታና ቱኡታኔ፤ ጋዓንቴ ዒ ቢያ ዎዴና ካኖቢራቶዋ ዱኡዚ ዱኡዚ ቶኮ'' ዓንጎዋ ሜንሢ ሜንሢ ኬኤራኔ፤ ዬያሮ ዒዛ ዓርቂ ቃዛኒ ዳንዳዓ ዓይጎ ዓሲያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ቢያ ኬሊ'' ዓሞና ሮኦሮና ዱኡፖ ባኣኮ''ይዳ፥ ዹኮ'' ዑፆይዳ ዒላቲ ዒላቲ ሓንታዖ፥ ዑፆዋ ፔኤኮ ቲሊንጊና ቲቂ ቲቂ ኪፃሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ዒዚ ዬሱሴ ዻካ'' ሓኬ ዓኣንቴ ዴንቃዖ ባንሢ ጳሽኪ ሙኪ ጉምዓቲ ዚጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ዬካፓ ፑኡፒ ዑኡሲና፦ «ኔኤኒ፥ ፑኡፖ ፆኦሲ ናዓሢዮ ዬሱሴ! ኔኤና ታኣና ዓይጎ ፔቱሞ ዓኣይ? ፆኦሲ ሱ'ንፆና ታ ኔና ሺኢቃኔ ሃዳራ ታና ሜታሲፖ» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ዬያ ዒዚ ጌዔሢ፦ «ሓይ ኔ ፑርቶ ዓያና''ሢ፥ ሓያ ዓሢ ሓሺ'' ኬስኬ!» ጌዒ ዬሱሴ ዓይሤሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ዬሱሴ ዒዛ፦ «ሱ'ንፃ ኔኤኮ ዖናዳይ?» ጌዒ ዖኦጬኔ፤ ዒዚያ፦ «ኑኡኒ ሚርጌታሢሮ ሱ'ንፃ ታኣኮ ዴሬኬ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ፑርቶ ዓያኖና ዓኣ ዓሢ ዬኖ ዓጫ''ፓ ዬሱሴ ዔያቶ ዳውሱዋጉዲ ዶዲሺ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ዬኖ ቤዞይዳ ሚርጌ ዓሲኮ ቆሎ ጉዱንሢ ዉዴ ጌሜሮ ጎኦባ'' ሄንቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ዬያሮ ፑርቶ ዓያና'' ዬሱሴ ኮራ፦ «ሓዳራ ኑና ሓሴኬ ጉዱንፆ ባንሢ ዳኬ፤ ኑኡኒ ዔያቶይዳ ዓኣዺ ጌሎም» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ዒዚ ዔያታ ጌላንዳጉዲ ዓይሣዛ፥ ፑርቶ ዓያና'' ዓሢዳፓ ኬስኪ ጉዱንፆይዳ ጌሌኔ፤ ጉቤ ዉዳ'' ሴካ ላምዖ ሺያ ማዔ ጉዱንሢ ማጎ ዋኣፆ ባንሢ ዲርጊ ባዞ''ይዳ ጌሊ ዔኤዺንቲ ሓይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ጉዱንፆ ሄንቃዞንሢ ጳሽኪ ዴንዲ ካታሞና ኮይሎ'' ጉርዶ ቢያይዳ ሓይሶ ሚርጌና ዳልጊሼኔ፤ ዓሳ ማዔ ባኮ ዛጋኒ ፔኤኮ ማኣራፓ ማኣራፓ ኬስኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ዔያታ ዬሱሴ ባንሢ ሙካዖ ዬይ ቤርታ ሚርጌ ፑርቶ ዓያኖና ዓርቂንቴ ዓሢ ዣኣዣሢዳፓ ዻቂ፥ ዓፒሎ ፔኤኮ ማይንቲ፥ ዴዒ ዓኣንቴ ዔያታ ዛጊ ዲቃቲ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ዬያ ቤርታዺ ዛጌ ዓሳ ፑርቶ ዓያና'' ዓርቄ ዓሢና ጉዱንፆናይዳ ማዺንቴ ባኮ ቢያ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ዬያሮ ዬኖ ዓጮ'' ዓሳ ዬሱሴ' ዔያቶኮ ዓጫ''ፓ ኬስኪ ዓኣዻንዳጉዲ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ዬሱሴ ዋኣፆና ፒንቆ ጎንጎ ጌላኣና ፑርቶ ዓያና'' ዓርቄንቴ ፖዔ ዓሢ፦ «ሓዳራ ታ ኔኤና ዎላ'' ዓኣዾም» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ዬሱሴ ጋዓንቴ ዒዛ ላኣጌኔ፤ ዬሱሴ ዒማ''ና ዒዛም፦ «ኔ ማኣሪ ዓኣዺጋፓ ጎዳ ኔኤም ዎዚጉዴ ፑኡፒ ባኣዚ'' ማዼቶዋ ሓሣ ዎዲ'' ኔና ማኣሬቶዋ ኔ ማኣሮ ዓሶም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ዓሢ ዬሱሴ ዒዛም ማዼ ባኮ «ታጶ ካታሞንሢ» ጌይንታ ዓጫ'' ኬኤዛዛ፥ ዋይዜ ዓሳ ቢያ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ዬሱሴ ዋኣፆና ፒንቆ ጎንጎና ባዞ'' ሱኮ ጊንሣ ማዒ ፒንቃዛ ሚርጌ ዴሬ ዒዛ ኮራ ቡኬኔ፤ ዒማ''ና ዒዚ ባዞ'' ዓጫኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ዒኢካ ዒያዒሮሴ ጌይንታ፥ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጎይዳፓ ፔቴ''ስኬይ ሙኪ ዬሱሴ ዴንቃዖ ዒዛኮ ቶኮ'' ዴማ'' ሎኦሚ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«ታኣኮ ዻካ'' ዉዱሮ ናይስኬማ ሃርጊንቲ ባኣሴ ሃይቃኒ ዑኬኔ! ዬያሮ ሙኪ ዒዛ ዻቃንዳጉዲ ሓሣ ሼምፔና ዒዛ ናንጋንዳጉዲ ሓዳራ ኔኤኮ ኩጮ ዒዞ ዑፃ ጌሤቴራ» ጌዒ ዶዲሺ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ዬያሮ ዬሱሴ ዒዛና ዎላ'' ዓኣዻኒ ዔቄኔ፤ ዒማ''ና ሚርጌ ዓሲ ዬሱሴና ዎላ'' ጎይፆ ዒዛ ቱቺ ዴንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ዒኢካ ታጶ ላምዖ ሌዔ ጉቤ ሱጉሢ ሾኦቲ ሚርጌ ሜታሳ ላኣሊስኬና ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ዒዛ ሚርጌ ዼኤሻ ዔራ ዓሶ ኮራ ዓኣዼቶዋ ፔኤኮ ሚኢሾ ቢያ ጉሪ ጋፕሴኔ፤ ጋዓንቴ ዻቆንዶ ዎዳ'' ሴካ ባሻንዳኣፓዓቴም ፖዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ዒዛ ዬሱሴ ዛሎ'' ዋይዜያታሢሮ ዴሮ''ኮ ባኣኪና ዒዛኮ ጊንፆ ዛሎ''ና ሙኪ ዓፒሎ ካኣሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ዬያ ዒዛ ማዼሢ፦ «ታ ዒዛኮ ዓፒሎ''ታዖ ካኣሜቶ ዻቃንዳኔ» ጌዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ዬማ ዒዛ ዓፒሎ'' ሄሄላዛ ዒዞኮ ሾኦታ'' ሱጉፃ ዔቄኔ፤ ሓርጋስካፓ ዻቄሢ ዒዞም ዑፆይዳ ዔርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ቤዞማና ዬሱሴይዳፓ ዎልቄ ኬስኬሢ ዒዚ ዔራዖ ዴሮ'' ባንሢ ሺሪ፦ «ታኣኮ ዓፒሎ ሔሌ''ሢ ዖናዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ዒዛኮ ጊንፆ ሓንታ ናኣታ''፦ «ዓሳ ሓያይዲ ቱቺንቲ ዓኣዻሢ ኔ ዛጋያታዖ ‹ዖኦኒ ታና ካኣሜይ› ኔኤኒ ዎዲ'' ጋዓይ?» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ዬሱሴ ጋዓንቴ ዬኖ ዖኦኒ ማዼቶዋ ዔራኒ ኮሮ ሺሪ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ዓሴላ ዒዞም ዓይጌ ማዺንቴቶዋ ዔሬሢሮ ዒጊቹሞና ጎጋይቂ ጎጋይቂ ዒዛኮ ቶኮ'' ዴማ'' ሎኦሚ ጎኑሞ ቢያ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ዬሱሴ ዒዞም፦ «ታ ናዔሌ፥ ኔና ኔኤኮ ጉሙርቂፃ ፓሤኔ፤ ኮሺና ዓኣዼ፥ ሜታ''ፓኣ ዻቄ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ዬሱሴ ዬኖ ኬኤዛ ጎይሣ ዓኣንቴ ዒያዒሮሴ ማኣራፓ ኪኢታ ዓሲ ሙኪ፦ «ናዔላ ኔኤኮ ሓይቄሢሮ ማይ ኔኤኒ ዔርዛሢ ዓይጎሮ ላቢ''ሳይ?» ጌዒ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ዬሱሴ ጋዓንቴ ዬያ ዔያታ ጋዓሢ ዋይዛዖ ዒዛም፦ «ፔቴ''ታዖ ዒጊጪፖ ጉሙርቂሢ ሌሊ ጉሙርቄ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ማዓዛ ዬሱሴ ጴፂሮሴና ያይቆኦቤና ያይቆኦቤኮ ጌርሲ ዮሓኒሴናይዳፓ ዓታዛ ዖኦኒያ ዒዛና ዓኣዻንዳጉዲ ኮይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ዔያታ ዒያዒሮሴ ማኣሪ ሔላ''ዛ ዓሳ ዒኢካ ዲርጊ ዒላቲ ዒላቲ ዬኤካንቴ ዬሱሴ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ዒማ''ና ዒዚ ጋሮ ጌላዖ፦ «ሓይ ዲርጋሢና ዬኤፖና ዓይጎሮዳይ? ናዔላ ጊጊንዓንዳፓዓቴም ሓሓይቂባኣሴ» ጌዒ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ዓሳ ዒዛኮ ሃይሶ ቦሃዖ ሚኢጬኔ፤ ዬሱሴ ጋዓንቴ ጉቤሢ ዙሎ'' ኬሲ''፥ ናዔሎኮ ዓዶና ዒንዶና ሓሣ ዒዛኮ ሓይሦ ጊንፆ ሓንታ ናኣቶ''ንሢና ዎላ'' ናዔላ ዓኣ ቤዞ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ዒዚ ዒዞኮ ኩጮ ዓርቃዖ፦ «ፃሊታ ኩሚ!» ጌዔኔ። ጌይፃ «ዓንቆ፥ ታኣኒ ኔና ዔቄ! ጋዓኔ» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ዬና ናዔላ ታጶ ላምዖ ሌዔ ናይኬ፤ ቤዞማና ዒዛ ዔቃዖ ሴካ ሓንጋ ጌዒ ሓንቲሢ ዓርቄኔ፤ ዬይ ያዺ ማዔ ዎዶ''ና ዓሳ ዛጋዖ ሚርጌና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ጋዓንቴ ዬሱሴ ዔያቶም ዖኦማኣ ኬኤዙዋጉዲ ዶዲሺ ላታዖ፦ «ዒዞም ሙዖንዶ ባኣዚ'' ዒንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ዬሱሴ ያፓ ቤዞ ሓሺ'' ፔኤኮ ዓጮ'' ካታሞ ሙኬኔ፤ ዒዛኮ ጊንፆ ሓንታዞንሢያ ዒዛ ጊንፆ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ዓይሁዶኮ ሓውሾ ዓቦ''ና ዔያቶኮ ቡኪንቶ ቤዛ ዒዚ ዔርዚሢ ዓርቄኔ፤ ሚርጌ ዓሲ ዒኢካ ዓኣኔ፤ ዒዚ ኬኤዛሢ ዔያታ ዋይዛዖ፦ «ዓንካፓ ዒዚ ሓያ ቢያ ዴንቄይ? ዎዚጉዴ ዔራቶዳይ ዒዛም ዒንጊንቴሢ? ሓያ ዲቃሣ ዓኮ ባኮ ዎዲ'' ዒዚ ማዻይ?» ጌዒ ጌዒ ዒዛ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ጊንሣ ሓሣ ዔያታ ጋዓዖ፦ «ማዔቶዋ ሃይ ሚፆ ዓርሳ ሓኣማሢቱዓዳ? ዒንዴላ ዒዛኮ ማይራሞ ሓሣ ጌርሲንሢ ዒዛኮ ያይቆኦቤ፥ ዮሳ፥ ዪሁዳ፥ ሲሞኦኔንታ ጌሮንሢያ ዒዛኮ ሓይካ ኑኡና ዓኣዞንሢቱዓዳ?» ጌዒ ዒዚ ኬኤዛ ባኮ ዔኩዋዖ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ዬሱሴ ዔያቶም ኬኤዛዖ፦ «ፆኦሲ ማሊሢ ኬኤዛይ ሜሌ'' ዓሲ ኮራ ቦቦንቺንታኔ፤ ፔኤኮ ዓጮ''ይዳ፥ ፔኤኮ ዒጊኖ ባኣኮ''ና ፔኤኮ ማኣሮ ዓሶና ባኣካ'' ቦቦሂንታኔ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ዒዚ ዒኢካ ዻካ'' ሓርጊንቴ ዓሲኮ ሌሊ ዑፃ ኩጮ ጌሢ ፓሤያፓዓቴም ሜሌ'' ዓኪ ዲቃሣ ባኣዚ'' ማዺኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ዓሶኮ ጉሙርቂሢ ባኣሢሮ ዒዚ ዲቃቴኔ፤ ዬካፓ ዬሱሴ ጉርዶ ባኣኮ'' ሓንቲ ሓንቲ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ዒዚ ታጶ ላምዖ ዒዛኮ ጊንፆ ሓንታ ናኣቶ'' ፔ ባንሢ ዔኤሊ'' ላምዖ ላምዖ ማሂ ዔያቶ ዳኬኔ፤ ዒዚ ዔያቶም ፑርቶ ዓያኖ ዑፆይዳ ዎልቄና ዓኣ ቢታንቶ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ዬሱሴ ዔያቶም ኪኢታዖ፦ «ዒንሢ ጎይፆኮ ኮኦሎ''ፓ ዓታዛ ጋላ፥ ጋላ ዓርቆ ሉካ''፥ ሚኢሼታቶዋ ቡራሻይዳ ዓጊ ዔኪፖቴ» ጌዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ዒ ኬኤዛዖ፦ «ቶካ'' ዒንሢኮ ዱርሲ ዓኣሣንዳፓዓቴም ቃሲ'' ላምዖ ማኣዖ ማኣዒፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ዓንካኣ ማዖም ዒንሢ ዓሲ ማኣሪ ጌሌቶ ዒኢካፓ ኬስካንዳያ ሄላ''ንዳኣና ዒማካ ዴዑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ዎካ ማዔቶዋ ዓሳ ዒንሢሲ ዔኩዋያና ዋይዙዋ ቤዛ ቢያ ዒንሢኮ ቶኮ'' ሲላሎ ፒፂ''ጋፓ ኬስኪ ዓኣዹዋቴ። ዬይ፦ ዔያቶም ‹ዒንሢና ዔሩዋቴ› ጋዓ ማርካ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ዬያሮ ዔያታ ኬስኪ ዓሳ ፔኤኮ ጎሞ ቡኡፃንዳጉዲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ዔያታ ሚርጌ ፑርታ ዓያናኣ ኬሴ''ኔ፤ ሓሣ ሚርጌ ሓርጊንቴ ዓሲ ዛይቴ ቲሺና ቲሽኪ ዓውሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ዬሱሴኮ ማዻ'' ቢያ ቤዞይዳ ዋይዚንቴሢሮ ካኣቲ ሄሮዲሴያ ዒዛ ዛሎ'' ዋይዜኔ። ፔቴ'' ፔቴ'' ዓሳ፦ «ማስካ ዮሓኒሴ ሃይባ''ፓ ዔቄኔ፤ ዬያሮ ሃይ ጉቤ ዋይዚንታ ባካ ዒዛና ማዺንታያኬ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ዓሳ ዛላ''፦ «ዒዚ ዔኤሊያሴኬ» ጋዓኔ፤ ዛላ'' ሃሣ፦ «ሚናኣ ፆኦሲ ማሊፆ ኬኤዛዞንሢዳፓ ፔቴ''ያኬ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ዬያ ካኣቲ ሄሮዲሴ ዋይዛዖ፦ «ዬይ ታኣኒ ቶኦኮ'' ቲቂሴ ማስካ ዮሓኒሴታዖ ሓይባ''ፓ ዔቄያዋይ ሜሌ''ቱዋዋይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ሄሮዲሴ ፔኤኮ ጌርሲ ፒልጶሴ ማቾ ሄሮዲያዳ ዔኬም፥ ");
INSERT INTO mdybse_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ዬያ ዛሎ''ና ማስካ ዮሓኒሴ፦ «ጌርሲ ማቾ ዔኮና ኔኤኒ ዻቤኔ» ጌዒ ጎሬሢሮ ካኣቲ ዒዛ ዓይሢ ቱኡሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ዬያሮ ሄሮዲያዳ ዮሓኒሴ ኮሚ ዎዺሳኒ ኮዔቶዋ ዒዛ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ዓይጎሮ ጌዔቶ ካኣቲ ሄሮዲሴ ማስካ ዮሓኒሴ ጌኤሺ ሓሣ ፂሎ'' ዓሲ ማዔሢ ዔሪ ዒጊጪ ካፓሢሮኬ። ማስካ ዮሓኒሴ ኬኤዛ ዎዶ''ና ካኣቲ ዲቃታቶዋ ዎዛና ዒዛሲ ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ማዓዛ ካኣቲ ሄሮዲሴ ፔኤኮ ሾይንቴ ኬሎ'' ቦንቻያ ማዔሢሮ ዓጮ'' ዎይሣ ዓሶና ፖኦሊሶኮ ሱኡጎና ፔቴ'' ፔቴ'' ጌሊላ ዓጮ''ይዳ ዔርቴ ዓሶናም ዼኤፒ ሙኡዚ'' ጊኢጊሼኔ፤ ዬና ሄሮዲያዳም ዒዞ ማሊፆና ካኣማያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ዒማ''ና ሄሮዲያዳኮ ናኣ ሙዖ ቤዞ ጌሊ ኮፆና ካኣቲንታ ዒዛና ዎላ'' ዓኣ ዓሶዋ ዎዛሴሢሮ ካኣቲ ናዔሎም፦ «ኔኤኒ ኮዓ ባካ ዓይጌንዴ ማዔታቶዋ ዖኦጬ፥ ታኣኒ ዒንጋንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ታኣኮ ካኣቱሞኮ ዛሎ'' ማዔቶዋ ኔኤኒ ዖኦጬ ባኣዚ'' ቢያ ዒንጋንዳኔ» ጌዒ ጫኣቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ዒዛ ዒንዶ ኮይላ'' ኬስኪ ዓኣዺ፦ «ዓይጎ ታ ዒዛ ዖኦጬቶ ቃራዳይ?» ጌዒ ዖኦጬኔ። ዒንዳ፦ «ማስካ ዮሓኒሴኮ ቶኦኮ'' ታኣም ዒንጌ ጌዒ ዖኦጬ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ናዔላ ዑኬና ሩኡሪ ካኣቲ ባንሢ ማዒ ሙካዖ፦ «ማስካ ዮሓኒሴኮ ቶኦኮ'' ሃሢ ሓይማካ ጎንጊዳ ታኣም ኔ ዒንጋንዳጉዲ ታ ኮዓኔ» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ሂዚ ጌዒ ዒዛ ዖኦጬሢሮ ካኣቲ ኮሺ'' ዖዬኔ፤ ጋዓንቴ ዒዛ ዖኦጬ ባኣዚ'' ኩንሣኒ ዒዛኮ ሾኦጮ ጉቤሢኮ ቤርታ ዒዚ ጫኣቄሢሮ ዒዚ ላኣጋኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ዬያሮ ካኣቲ ዑኬና ፖኦሊሶይዳፓ ፔቴ''ስኬያ ማስካ ዮሓኒሴኮ ቶኦኮ'' ቲቂ ዔኪ ዬዓንዳጉዲ ዳኬኔ፤ ፖኦሊሳሢ ቱኡዞ ማኣሪ ዴንዲ ማስካ ዮሓኒሴኮ ቶኦኮ'' ቲቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ቲቂንቴ ቶኦኮ'' ጎንጊዳ ዓጊ ዔኪ ናዔሎም ዒንጌኔ፤ ናዔላ ዔኪ ዒንዴሎም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ማስካ ዮሓኒሴኮ ጊንፆ ሓንታዞንሢ ዬያ ዋይዜ ዎዶ''ና ሙካዖ ሌዞ ዒዛኮ ዔኪ ዱኡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ዳኪንቴዞንሢ ዳኪንቴ ቤዞይዳፓ ማዒ ዬሱሴ ኮራ ቡኬኔ፤ ዔያታ ማዼ ባኮና ዔርዜሢ ቢያ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ዒዚ ዔያቶም፦ «ዒንሢሮ ሌሊ ታኣና ዎላ'' ዓሲባኣ ቤሲ ሙኪ ዻካ'' ሓውሹዋቴ» ጌዔኔ። ዬያ ዒ ጌዔሢ ዔያቶ ኮይላ'' ሙካ ዓሶና ዓኣዻ ዓሶና ሚርጋዛ፥ ሙዓኒያ ዔያቶም ማጌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ዬያሮ ዓሳባኣ ቤዞይዳ ዔያታ ሌሊ ማዓኒ ዋኣፆና ፒንቆ ጎንጎ ቶጊ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ማዔቶዋ ዔያታ ዓኣዻኣና ሚርጌ ዓሲ ዔያቶ ዛጊ ዔሪ ፔኤኮ ካታማፓ ኬስኪ ቶኪና ጳሽኪ ጳሽኪ ዔያቶ ቢራዖ ዔያቶ ኮራ ቡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ዬሱሴ ዋኣፆና ፒንቆ ጎንጎይዳፓ ኬዳ''ኣና ሚርጌ ቡኬ ዴሮ'' ዛጋዖ ዔያታ ሄንቃ ዓሲባኣ ማራይጉዴያ ማዔሢሮ ዒዛኮ ዒና'' ዔያቶ ሚጪንቴኔ፤ ዬያሮ ዒዚ ሚርጌ ባኣዚ'' ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ሳዓ ዓማኣ ጋዓዛ ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ዒዛ ባንሢ ሙኪ፦ «ሳዓ ዓሜኔ፤ ቤዛ ሓይ ዔኤቢባኣ ዓሲ ናንጉዋ ዳውሎ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ሙዖ ባኣዚ'' ዓሶኮ ባኣሢሮ ሃይካ ጉርዶይዳፓ ዴንዲ ፔኤኮ ሙዖ ባኣዚ'' ሻንቃንዳጉዲ ዓሶ ዳኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ዬሱሴ ጋዓንቴ፦ «ዔያታ ሙዓንዳ ባኣዚ'' ዒንሢ ዔያቶም ዒንጉዋቴ» ጌዒ ማሄኔ። ዔያታ፦ «ሂዴቶ ዓሳ ሙዓንዳ ካሣ ፔቴ'' ዓሲ ላምዖ ፄኤታ ኬሊ'' ማዼም ዒንጊንታንዳ ሚኢሼና ሻንቂ ኑ ዒንጎንዶሞ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ዬያሮ ዬሱሴ ዔያቶ ዖኦጫዖ፦ «ዓኣፒኒ ካሣ ዓኣቴ ሂንዳ ዴንዲ ዛጉዋቴ» ጌዔኔ። ዔያታ ዛጋዖ፦ «ዶንጎ ካሣና ላምዖ ሞሎስኬንሢና ዓኣኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ዬሱሴ ፔ ጊንፆ ሓንታዞንሢም ዓሶ ፓቂ ፓቂ ቡጮይዳ ዴይሡዋቴ ጌዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ዬያሮ ዓሳ ዎሊ ጊንፆ ዛላ'' ፄኤታ ዛላ'' ዶንጊታሚ'' ማዒ ፓቂንቲ ፓቂንቲ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ዬካፓ ዬሱሴ ዶንጎ ካፆንሢና ላምዖ ሞሎንሢያ ዔኪ ጫሪንጮ ባንሢ ዛጊ ፆኦሲ ጋላታዖ ቡንፂ ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ዓሶም ጊሽካንዳጉዲ ዒንጌኔ፤ ሓሣ ላምዖ ሞሎንሢያ ቢያሢም ጊሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ቢያሢ ሙዒ ሚሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ዓሳ ሙዒ ሚሽካዛ ዓቴ'' ካሦና ሞላሢናኮ ዶንቦ ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ታጶ ላምዖ ዳልጊ ሌማቴ ኩሙሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ካሦ ሙዔ ዓሶይዳፓ ዓቲንቆ ፓይዳ'' ሌሊ ዶንጎ ሺያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ዬሱሴ ዓሶ ዳካኣና ዒዛኮ ጊንፆ ሓንታዞንሢ ዑኬና ዋኣፆና ፒንቆ ጎንጎና ሱኮ ቤቴሳይዳ ጌይንታ ቤዞ ቢሪ ዒዛ ፒንቃንዳጉዲ ዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ዒዚ ዓሶ ኮሺ ዓኣዹዋቴ ጌዔሢኮ ጊንፃፓ ሺኢቃኒ ጌሜሪ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ሳዓ ዓማኣና ዋኣፆና ፒንቆ ጎንጋ ዋኣፆ ሳዛ'' ዓኣንቴ ዬሱሴ ፔኤሮ ሌሊ ሳዖይዳ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ዒዛኮ ጊንፆ ሓንታዞንሢ ዔያቶኮ ቤርታ ዢባርሻ ዢባሮይዳፓ ዔቄያና ዋኣፆና ፒንቆ ጎንጎ ዒሾ ባሺንቲ ሚርጌ ሜታዻንቴ ዒዚ ዛጌኔ፤ ዬይ ያዺ ማዔሢ፦ ዹሞኮ ሴካ ባራሪ ኮይዳ ቂኢቃኣና ጉዴያናኬ፤ ዬሱሴ ባዞ'' ዑፃ ቶኪና ሓንቲ ሙካዖ ኮርሳ ዔያቶኮ ቢሪ ዓኣዻኒ ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ጋዓንቴ ዔያታ ዒዚ ዋኣፆ ዑፃ ሓንታንቴ ዛጋዖ ዓልጎ ዔኤዤ ዔያቶም ማላዛ ዒጊጪ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ቢያሢ ዒዛ ዛጋዖ ዲቃቴኔ። ዒዚ ጋዓንቴ ቤዞማና፦ «ሓይ ዒንሢ ዎይታይ፤ ታናኬ ዒጊጪፖቴ» ጌዒ ዔያቶ ዶዲሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ዬካፓ ዒዚ ዔያቶ ኮራ ዋኣፆና ፒንቆ ጎንጎ ጋሮ ጌላዛ ዢባራ ዢባርሺፆ ሓሼ''ኔ። ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ጉቤ ሓያጉዴ ባኣዚ'' ጌዒ ኮሺ'' ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ዓይጎሮ ጌዔቶ ዒና'' ዔያቶኮ ዶንጎ ካሦና ማዺንቴ ባኮ ጶቂሡዋያ ማዒ ዶጬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ዔያታ ባዞ''ና ፒንቂ ጌንሴሬፄ ካታሞ ሄሌ''ኔ፤ ዋኣፆና ፒንቆ ጎንጎ ዔያታ ባዞ'' ዓጫ ዓኣ ሳዖ ባንሢ ዶጪሲ ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ዔያታ ዋኣፆና ፒንቆ ጎንጎይዳፓ ኬኬዳ''ኣና ዓሳ ዬሱሴ ቤዞና ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ዬያሮ ዬሱሴ ዓኣዼ ቤዞይዳ ቢያ ዒዚ ዓኣ ቤዞ ዋይዜ ዓሳ ጉርዶ ባኣኮ'' ጳሽኪ ሓርጊንቴ ዓሶ ሓሎና ኬዲ ኬዲ ዒዛ ባንሢ ዔኪ ሙኪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ዬሱሴ ዓኣዼ ቤዞይዳ ቢያ፦ ጉርዶ ባኣካ''፥ ካታሞይዳ፥ ካታሞ ዙላ'' ሓርጊንቴ ዓሶ ዒዛ ቤርቶ ዓሳ ቡኪንታ ቤዞ ዔኪ ዔኪ ሙካኔ፤ ዒዛኮ ዓፒሎ ዓጮ ዓርቃኒያ ዔያታ ሺኢቃኔ። ዓፒሎኮ ዓጮ ዓርቃሢያ ቢያ ዻቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ፔርሴ ዓሶና ዬሩሳላሜፓ ሙኬ ፔቴ'' ፔቴ'' ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ዬሱሴ ኮራ ቡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ዬሱሴኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ'' ፔቴ''ዞንሢ ሙሴ ዎጋ'' ዓይሣ ጎይፆ ጌኤሽኪባኣ ኩቺና ሙዓንቴ ዔያታ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፔርሴ ዓሶንታ ሓሣ ዓቴ'' ዓይሁዶ ዓሳ' ጪማ ዔያቶኮ ኬሴ'' ዎጎ ካፒፆና ኩጮ ፔኤኮ ኮሺ'' ማስቲባኣዖ ሙኡዚ'' ሙዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ዬያጉዲ ቦኦካፓ ማዓዖዋ ማስቱዋዖ ሙዑዋሴ፤ ሓሣ ዑሺ ዑሽኮ ሜሄ፥ ዖቲ፥ ጎንጊ፥ ሻኣላ''፤ ዬያ ቢያ ማስኮ ባኣዚ''ና ዬያ ማላ ሜሌ'' ሚርጌ ዎጌ ዔያታ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ዬያሮ ፔርሴ ዓሶና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና፦ «ኔኤኮ ጊንፆ ሓንታዞንሢ ዓይጎሮ ጪማ ኬሴ'' ዎጎኮ ዑሣ ዓኣዻይ? ዓይጎሮ ዔያታ ኩጮ ማስቱዋዖ ሙዓይ?» ሂዚ ጌዒ ዬሱሴ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ዒዚ ዔያቶም ማሓዖ፦ «ዒንሢ ዓሲ ዓኣፒም ሄርሺንቲሮ ማዻ ዓሳ! ዒሲያሴ ጎዖ ፆኦሲ ማሊፆ ኬኤዛሢ ዒንሢ ዛሎ'' ኬኤዛዖ፦ ‹ሓይ ዴራ'' ዻንጎና ታና ቦንቻኔ ዒና'' ዔያቶኮ ታጊዳፓ ሚርጌ ሓኬያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ዔያታ ዓሲ ዎጌ ዔርዚ ዔርዚ ታና ጉሪ ሉኡዙሞና ካኣሽካያ ማላኔ› ጌዒ ኬኤዜሢ ጎኔኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«ዬያሮ ዒንሢ ፆኦሲ ዓይሢፆ ሓሺ'' ዓሲ ዎጌ ካፓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ላሚ ዬሱሴ ዔያቶም ሂዚ ጌዔኔ፦ «ዒንሢኮ ዎጎ ዒንሢ ካፓኒ ጌዒ ፆኦሲ ዓይሢፆ ዒንሢ ሚርጌና ቦሂ ሓሻ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሴ ‹ዓዶና ዒንዶና ቦንቼ፤ ዓዶና ዒንዶና ጫሽኬሢ ዎዎዺንቶንጎ› ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ጋዓንቴ ፔቴ'' ዓሲ ዓዶና ዒንዶና ማኣዶንዶሢ ሃሺ'' ዒንሢም፦ ‹ዓዶና ዒንዶናም ማዾንዶ ባኮ ዛሎ'' ቢያ ፆኦሲም ታ ዒንጎ ባኣዚ'' ዒንጌኔ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ዬይ ዓሢ ዓዶና ዒንዶና ማኣዱዋጉዲ ዒንሢ ዓይሣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ሂዲፆና ዒንሢ ዒንሢኮ ዔርዚፆ ካፓኒ ጌዒ ፆኦሲኮ ቃኣሎ'' ሓሻ''ኔ፤ ሓሣ ዬያጉዴ ባኣዚ'' ሚርጌ ዒንሢ ማዻኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ዬሱሴ ዴሮ'' ፔ ባንሢ ላሚ ዔኤሊ'' ሂዚ ጌዔኔ፦ «ቢያሢ ዒንሢ ኮሺ'' ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ዓሲ ኪንሢና ዓኣያ ማሃ ባኣዚ'' ዓሲዳፓ ኬስካ ባኣዚ'' ማዓንዳኣፓዓቴም ዙልካፓ ጌላ ባኣዚ'' ዓሲ ኪንሢና ዓኣያ ማሁዋሴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ዬካፓ ዬሱሴ ዴሮ'' ሃሺ'' ኬኤፆ ጌላዛ ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ዬኖ ጌይፄሎኮ ቡሊ''ፆ ኬኤዛንዳጉዲ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ዒዚያ ዔያቶም ሂዚ ጌዒ ማሄኔ፦ «ዒንሢያ ሃሣ ዬያ ዔሩዋዓዳ? ዙልካፓ ዓሲኮ ዻንጋና ጎጲ ጌላ ባኣዚ'' ዓሲ ኪንሢና ዓኣያ ማሁዋኣሢ ዒንሢም ዔርቱዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ዓይጎሮ ጌዔቶ ዻንጎና ጎጶ ጌሌዜላ ዙሎ'' ጊንሣ ኬስካኣፓዓቴም ዒና ባንሢ ጌሉዋሴ።» ዬያሮ ዬሱሴ ሙኡዚ'' ቢያ ሙዒንታኒ ዳንዳዓያ ማዔሢ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ዬሱሴ ላሚ ሂዚ ጌዔኔ፦ «ዓሲ ኪንሢና ዓኣያ ማሃ ባኣዚ'' ዓሲዳፓ ኬስካ ባኣዚ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ዓሲኮ ጋርሲ ዒናፓ ኬስካ ፑርታ ባኣዚ''፦ ኮይሱዋ ጎይሢና ዞኦስካ ኮኦሚሢ፥ ዉሱሞ፥ ዓሲ ዎዺሢ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ዓኒ ሃሣ ማቾ ማዒባኣያና ላሂሢ፥ ታዻቆ ጌዒሢ፥ ፑርቱሞ፥ ጌሺሢ፥ ፔ ሼኔና ሓንቲሢ፥ ቂኢሩሞ፥ ፑሽኪሢ፥ ዖቶርሞ፥ ማሊሢ ባይሱሞኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ዓካሪ፡ ዬይ ፑርቶ ባካ ጉቤ ዓሲ ዒኔፓ ኬስኪ ዓሲ ጎማሳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ዬካፓ ዬሱሴ ዔቂ ፂሮሴ ካታሞ ኮይሎይዳ ዓኣ ጉርዳ ዴንዲ ፔቴ'' ዓሲ ማኣሪ ጌላዖ ዒኢካ ዒ ዓኣሢ ዖኦኒያ ዔሩዋጉዲ ኮዔኔ፤ ጋዓንቴ ዒ ዓኣሺንታኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ናይስኬና ዒዞኮ ፑርታ ዓያናና ዓርቂንቴ ላኣሊስኬና ዬሱሴ ዒኢካ ዓኣሢ ዋይዚ ዑኬና ሙካዖ ቶካ'' ዒዛኮ ሎኦሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ላኣሌላ ሶኦሪያ ዓጪዳ ፖኖቄ ጌይንታ ቤስካ ሾይንቴ ጊሪኬ ዜርፃፓ ማዔያኬ፤ ዒዛ ዒዞኮ ናዔሎይዳፓ ፑርቶ ዓያኖ ዬሱሴ ኬሳ''ንዳጉዲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ዬሱሴ ጋዓንቴ፦ «ናኣቶ ሙዖ ዔኪ ካናቶም ዒንጊሢ ኮይሱዋሴ፤ ሂንዳ ቤርታዺ ናኣታ'' ሙዒ ሚሽኮንጎ» ዒዞም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ዒዛ፦ «ጎኔኬ ጎዳሢዮ፤ ያዺ ማዔቶዋ ካናታ ጎንጎ ዴማ'' ናኣቶይዳፓ ዲኢኔሢ ሙሙዓያቱዓዳ» ጌዒ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ዬያሮ ዬሱሴ፦ «ዬያ ኔ ጌይፆና ፑርቶ ዓያና'' ኔኤኮ ናዔሎይዳፓ ኬስኬኔ፤ ማኣሪ ማዒ ዓኣዼ» ዒዞም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ዒዛ ማኣሪ ማዒ ሙካንቴ ፑርቶ ዓያና'' ናዔሎይዳፓ ኬስኬሢሮ ናዔላ ኮሺ ሻኣሎ''ይዳ ላሂ ዓኣንቴ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ዬሱሴ ፂሮሴ ዓጫ''ፓ ኬስካዖ ሲዶና ጌይንታ ዓጮ''ና ታጶ ካታሞ ጌይንታ ዓጮ''ይዴና ጌዒ ጌሊላ ባዞ'' ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ዒማ''ና ዒኢካ ዒዛ ባንሢ ዋይዚና ዻንጋና ባይቄ ዓሲ ዓሳ ዔኪ ሙካዖ ዬሱሴ ዒዛ ዑፃ ኩጮ ጌሣንዳጉዲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ዬሱሴ ዓሶ ባኣካ''ፓ ዓሢ ዱማሲ ኬሳ''ዖ ዓሢኮ ዋዮይዳ ኬኤሎ'' ዳኬኔ፤ ሓሣ ጩቺያ ጩቲ'' ዒዛኮ ዒንዲርዞ ካኣሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ዬማፓ ዬሱሴ ሌካ ጫሪንጮ ባንሢ ዛጊ፥ ሚጪንቲ «ዪይያ!» ጋዓዖ፦ «ዔፓታ» ጌዔኔ። ዬኖ ጌይፃ «ቡሊ''ንቴ» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ዬማ ጋዓኣና ዓሢኮ ዋዮና ዒንዲርዞና ቡሊ''ንቴም ሜታባኣያ ጌኤሺ'' ጌስቲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ዬሱሴ ዬያ ዖኦማኣ ኬኤዙዋጉዲ ዓሶ ዓይሤኔ፤ ጋዓንቴ ዔያቶም ኬኤዙዋጉዲ ዓይሤሢዳፓ ባሼ ዔያታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ዬያ ዋይዜሢ ቢያ ሚርጌና «ሃያጉዴ ባኣዚ''» ጌዒ ዲቃቲ ሄርሺሢና፦ «ጉቤ ባኣዚ'' ኮሺ ማዻኔ፥ ዋያ ባይቄሢ ዋይዛንዳጉዲ፤ ዻንጋ ባይቄሢያ ጌስታንዳጉዲ ማሃኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ዬማና ላሚ ሓሣ ሚርጌ ዴሬ ቡኬኔ። ዬያ ቡኬ ዓሶኮ ሙዖንዶ ባኣዚ'' ባኣሢሮ ዬሱሴ ዒዛኮ ጊንፆ ሓንታ ናኣቶ'' ፔ ባንሢ ዔኤላ''ዖ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«ሓይ ዓሳ ሃኣዛጉዋቴ ሃይሦ ኬሊ'' ሄላ''ንዳኣና ታኣና ዎላ''ኬ፤ ሓሣ ሙዖንዶ ባኣዚ'' ዔያቶኮ ባኣሢሮ ታና ሚቻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ዛላ'' ዔያቶኮ ሃኬይዳፓ ሙኬያኬ፤ ሓያ ናዮና ታኣኒ ዔያቶ ዳኬቶ ጎይፃ ዔያታ ላባ''ንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ዒዛኮ ጊንፆ ሓንታ ናኣታ''፦ «ሂዴቶ ሓያ ዳውሎ'' ቦኦሎ''ይዳ ሓያ ዓሶም ቢያ ጊዳ ሙኡዚ'' ዴንቃኒ ዳንዳዓይ ዖናዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ዬሱሴ ዔያቶም፦ «ዓኣፒኒ ካሣ ዒንሢኮ ዓኣይ?» ጌዒ ዔያቶ ዖኦጬኔ፤ ዔያታ፦ «ላንካይ ካሣ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ዒዚ ዓሳ ሳዓ ዴዓንዳጉዲ ዓይሣዖ ላንካዎ ካሦንሢ ዔኪ ፆኦሲ ጋላታዖ ቡንፂ ዴሮ''ም ጊሽካንዳጉዲ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ም ዒንጋዛ፥ ናኣታ'' ዓሶም ጊሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ዔያቶኮ ሓሣ ዻካ'' ሞላ ዓኣንቴ ዬንሢሮዋ ጋላታዖ ዴሮ''ም ዒንጋንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ዓሳ ቢያ ሙዒ ሚሽካዛ ዓቴ'' ዶንቦ ዔያታ ላንካይ ዳልጊ ሌማቴ ኩንሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ዬያ ሙዔ ዓሶኮ ፓይዳ'' ዖይዶ ሺያ ኩማንዳያኬ፤ ዬሱሴ ዔያቶ ዳኬሢኮ ጊንፃ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ና ዎላ'' ዋኣፆና ፒንቆ ጎንጎ ጋሮ ጌሊ ዳልማኑታ ጌይንታ ዓጮ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፔርሴ ዓሳ ዬሱሴ ባንሢ ሙኪ ዒዛና ዎላ'' ማርሞ ዓርቄኔ፤ ዔያታ ዒዛ ጌኤሲና ፒራኒ ኮዓዖ ፆኦሲዳፓ ማዔያ ዓኪ ዲቃሣ ባኣዚ'' ዻዋንዳጉዲ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ዬሱሴ ዒማ''ና ፔ ዒና ጋርሲም ጌስታዖ፦ «ሃኖ'' ዎዶ'' ዓሳ ዲቃሣ ዓኪ ባኣዚ'' ማዺንታንዳጉዲ ዓይጎሮ ኮዓይ? ጎኔ ታ ዒንሢም ጋዓኔ፤ ፔቴ''ታዖ ዔያቶም ጎኑሞ ዔርዛ ባኣዚ'' ማዺንታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ዒዚ ዔያቶ ሃሻ''ዖ ላሚ ዋኣፆና ፒንቆ ጎንጎና ባዞ''ኮ ሶንጌኖ ሱኮ ፒንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ጋላ ዔካንዳዖ ዋላ''ዛ ዋኣፆና ፒንቆ ጎንጎይዳ ዓኣ ዓሶኮ ፔቴ'' ካሣይዳፓ ዓታዛ ዓኣ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ዬሱሴ፦ «ፔርሴ ዓሶና ሄሮዲሴናኮ ሙኑቆ ፃኣዞይዳፓ ካፒንቱዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ዔያታ ዎሊ ኮይላ''፦ «ዒዚ ዬያ ጌዔሢ ኑኡኮ ጋላ ባኣሢሮ ናንዳኔ» ጌዒ ዞርቲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ዬሱሴ ዬያ ማሊፆ ዔያቶኮ ዔራዖ ሂዚ ዔያቶም ጌዔኔ፦ « ‹ካሣ ኑኡኮ ባኣሢሮኬ› ጌይ ዒንሢ ዓይጎሮ ማላይ? ሓማ ሄላ''ንዳኣና ዒንሢ ማሊ ጶቂሡዋያ ሓሣ ዒንሢም ዔርቱዋያዳ? ዒና'' ዒንሢኮ ዔኩዋያ ማዒ ሃጊ ዶጬ ጎይሣዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ዓኣፓ ዒንሢኮ ዛጉዋዓዳ? ዋያ ዒንሢኮ ዋይዙዋዓዳ? ዎዲ'' ዒንሢ ኮይላ'' ማሊንቱዋይ! ");
INSERT INTO mdybse_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ሃያኮ ቤርታ ዶንጎ ካሦንሢ ዶንጎ ሺዮ ዓሶም ታኣኒ ቡንፂ ዒንጌ ዎዶ''ና ዶንቦ ዒንሢ ዓኣፒኒ ሌማቴ ኩሙሢ ዔቂሴይ» ጋዓዛ፥ ዔያታ፦ «ታጶ ላምዖ ሌማቴ ኩሙሢ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ሓሣ ዒዚ፦ «ታኣኒ ላንካዎ ካሦ ዖይዶ ሺዮ ዓሶም ቡንፂ ዒንጌ ዎዶ''ና ዓኣፒኒ ሌማቴ ኩሙሢ ሃሾና ዶንባ ዒንሢ ዔኬይ?» ጌዒ ዔያቶ ዖኦጬኔ። ዔያታኣ፦ «ላንካይ ዳልጊ ሌማቴ ኩሙሢ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ዒዚ ዒማ''ና «ሂዳዖ ሓማ ሔላንዳኣና ዒንሢ ጶቂሡዋያዳ?» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ዔያታ ቤቴሳይዳ ሄላ''ዛ ዓሳ ፔቴ'' ዓኣፒ ባይቄ ዓሲ ዬሱሴ ኮራ ዔኪ ሙካዖ ዒዚ ፔ ኩጮና ካኣማንዳጉዲ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ዬሱሴ ዓኣፓ ባይቄ ዓሢኮ ኩጮ ዓርቂ ጎቺ ጉርዶ ባኣካ''ፓ ኬሳ''ዖ ዓሢኮ ዓኣፖይዳ ጩቴሢኮ ጊንፃፓ ዓኣፖ ዒዛኮ ካኣማዖ «ዻካ'' ኔኤም ዔኤቢ ጴዻ» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ዓኣፓ ባይቄሢ ዼ'ግ ጌዒ ዛጋዖ፦ «ሂዮ ታኣኒ ዓሲ ዴንቃኔ፤ ጋዓንቴ ዔያታ ዓጊፃ ሚሢ ማላኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ዬሱሴ ዓሢኮ ዓኣፖይዳ ኩጮ ላሚ ጌሤኔ፤ ዬማና ዓሢ ጌኤሺ'' ዛጌኔ፤ ዓኣፓኣ ዻቄኔ፥ ቢያ ባኣዚ'' ጌኤሺ'' ዛጊሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ዬካፓ ዬሱሴ ዒዛም፦ «ጉርዶ ባኣኮ'' ዓኣዺፖ» ጌዒ ዓይሢ ማኣሪ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ዬካፓ ዬሱሴና ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ና ፒልጶሴ ቂሳሪያ ጌይንታ ካታሞኮ ኮይላ'' ዓኣ ጉርዶ ባንሢ ዴንዲ ዴንዲ ጎይፃ ዓኣዖ፦ «ዓሳ ታና ዖናኬ ጋዓይ?» ጌዒ ዒዛኮ ጊንፆ ሓንታዞንሢ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ዔያታ ማሓዖ፦ «ዛላ'' ኔና ማስካ ዮሓኒሴኬ ጋዓኔ፤ ሓንጎዋታ ኔና ዔኤሊያሴኬ ጋዓኔ፤ ዓቴ'' ዓሳ ሓሣ ዖሲ ማሊፆ ኬኤዛዞንሢዳፓ ፔቴ''ያኬ ኔና ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«ዒንሢ ታና ዖናኬ ጋዓይ?» ጌዒ ዒዚ ዔያቶ ዖኦጬኔ። ጴፂሮሴ ማሓዖ፦ «ኔኤኒ ሜሲሔኬ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ዬሱሴ ዔያቶ፦ «ታ ዛሎ'' ዖኦማኣ ኬኤዚፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ዬሱሴ ፔኤኮ ጊንፆ ሓንታ ናኣቶ'' ሂዚ ጌዒ ዔርዚሢ ዓርቄኔ፦ «ዓሲኮ ናዓሢ ሚርጌ ሜቶ ዔካንዳያ ኮይሳኔ፤ ዓይሁዶ ጪሞና ቄኤሶኮ ሱኡጎና ሃሣ ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢና ቤርታ ቦሂንታንዳኔ፤ ሓይቂያ ሓይቃንዳኔ። ማዔቶዋ ሓይሦ ዓቢኮ ጊንፃፓ ሓይባ''ፓ ዔቃንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ዒዚ ዬያ ዔያቶም ጋፕዲ ፔጋሲ ኬኤዛዛ ጴፂሮሴ ዒዛ ዱማሲጋፓ፦ «ያዺ ጌዒፖ» ጌዒ ዒዛ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ጋዓንቴ ዬሱሴ ዒዛኮ ጊንፆ ሓንታ ናኣቶ'' ባንሢ ሺሪ ዛጋዖ፦ «ኔኤኒ ፃላሄ ታ ኮራፓ ሺኢኬ፤ ኔኤኮ ማሊፃ ፆኦሲዳፓቱዋሴ፥ ዓሲዳፓኬ» ጌዒ ጴፂሮሴ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ዬካፓ ዬሱሴ ዴሮ''ንታ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ንታ ፔ ባንሢ ዔኤላ''ዖ ሂዚ ጌዔኔ፦ «ዖናታቶዋ ታኣና ዎላ'' ሃንታኒ ናሽካሢ ፔና ሓሺ''፥ ሃይቢም ጊኢጌያ ማዒ ታ ጊንፆ ሓንቶንጎ።» ");
INSERT INTO mdybse_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ዖናታቶዋ ፔ ናንጎ ዓይሳኒ ናሽካሢ ዒዞ ባይዛንዳኔ፤ ጋዓንቴ ታናንታ ታኣኮ ኮዦ ሓይሶ ዛሎ''ሮ ፔኤኮ ናንጎ ዓኣሢ ዒንጋሢ ጋዓንቴ ናንጎ ፔኤሲ'' ባይዛዓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ዓሲ ሳዖይዳ ዓኣ ባኮ ቢያ ዴንቃዖ ፔኤኮ ናንጎ ባይዜቶ ዓይጎ ማኣዳ''ይ? ");
INSERT INTO mdybse_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ሓሣ ዓሲ ፔ ናንጎ ቤዞ ዓይጎ ጪጋኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ፆኦሲ ቦንቹዋ፥ ጎሞ ዓሶ ሾይንቶ ሓያ ቤርታ ታ ዛሎ''ንታ ታኣኒ ዔርዜ ባኮ ዛሎ''ዋ ኬኤዛኒ ቦርሲንታ ዓሲዳ ቢያ ዓሲኮ ናዓሢያ ፔ ዓዶኮ ቦንቾና ሃሣ ጌኤዦ ኪኢታንቾናኣ ዎላ'' ሙካዖ ዬያ ዓሢዳ ቦርሲንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ሓሣ ዬሱሴ ዔያቶም ሂዚ ጌዔኔ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ሓሢ ሃይካ ዓኣ ዓሶ ባኣካ'' ፆኦሲ ካኣቱማ ዎልቄና ዬዓኣና ዛጋንዳያ ሄላ''ንዳኣና ፔቴ'' ፔቴ'' ሓይቂንዱዋ ዓሲ ዓኣኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ላሆ'' ዓቢኮ ጊንፃፓ ዬሱሴ ጴፂሮሴንታ ያይቆኦቤንታ ዮሓኒሴንታ ሌሊ ፔኤና ዎላ'' ዔኪ ፑኡፒ ዹካ ኬስካዛ ዔያቶኮ ቤርታ ዒዛኮ ዓውካራ ላኣሚ''ንቲ ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ዓፒላ'' ዒዛኮ ኮሺ'' ቦኦሬኔ፤ ዓጪዳ ዖኦኒያ ማስኪ ጌኤሺ'' ቦኦሪሳያይዳፓ ዑሣ ዓኣዼ ቦኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ዬማና ዔኤሊያሴና ሙሴና ጴዺ ዬሱሴና ዎላ'' ጌስታንቴ ዔያታ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴፂሮሴ ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ሓይካ ኑ ናንጋቴ ኮሺኬ፤ ዬያሮ ፔቴ'' ኔኤም፥ ፔቴ'' ሙሴም፥ ፔቴ'' ዔኤሊያሴም ማዓያ ሓይሦ ዉዲ ኑኡኒ ማዦም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ዔያታ ሓይሣሢ ኮሺ'' ዲቃቲ ዓኣሢሮ ጴፂሮሴ ፔኤሮ ዓይጎ ጋዓቴያ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ሻኣሬ ዔያቶ ሙኪ ባይዜኔ፤ ባይዜ ሻኣሮይዳፓ፦ «ሓይ ታኣኮ ታኣኒ ናሽካ ናዓሢኬ፤ ዒዚ ጋዓሢ ዋይዙዋቴ» ጋዓ ዑኡሲ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ቤዞማና ሺሪ ዔያታ ዛጋዖ ዬሱሴፓ ዓታዛ ሜሌ'' ዖናኣ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ዹካ''ፓ ዔያታ ኬዳ''ኣና ዬሱሴ፦ «ዒንሢ ዛጌ ባኮ ዓሲኮ ናዓሢ ሓይቂ ሓይባ''ፓ ዔቃንዳያ ሄላ''ንዳኣና ዖኦማኣ ኬኤዚፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ዬያ ዒ ጌዔ ባኮ ዔያታ ዋይዚ ዔኬኔ፤ ጋዓንቴ፦ «ሃይቢፓ ዔቂሢ ጌይሢ ዎዚ ጌይሢዳይ?» ጌዒ ዎላ'' ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","«ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ዔኤሊያሴ ቤርታ ሙካኒ ኮይሳኔ ዓይጎሮ ጋዓይ?» ጌዒ ዔያታ ዬሱሴ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ዒዚ ዔያቶም፦ «ጎኔኬ፤ ዔኤሊያሴ ቤርታዺ ሙካኒና ጉቤ ባኮ ጊኢጊሻኒ ኮይሳኔ፤ ማዔቶዋ ዓሲ ናይ ሜቶ ዔካንዳሢና ቦሂንታንዳሢያ ፃኣፒንቲ ባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ታኣኒ ዒንሢም ኬኤዛኔ፦ ዔኤሊያሴ ቤርታዺ ሙኬኔ፤ ቤርታዺ ዒዛ ዛሎ'' ፃኣፒንቴሢጉዴያ ዓሳ ኮዓ ባኮ ቢያ ዒዛይዳ ማዼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ዬሱሴንታ ዒዛና ዎላ'' ዹኮ'' ኬስኬ፥ ዒዛ ጊንፆ ሓንታ ሓይሦንሢንታ ሓንጎ ዓቴ'' ጊንፆ ሓንታዞንሢ ኮይላ'' ሙካንቴ ሚርጌ ዴሬ ዔያቶ ኮራ ቡኪ፤ ሓሣ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳኣ ዔያቶና ዎላ'' ማርማኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ዒኢካ ዓኣ ዴራ'' ዬሱሴ ዛጌ ዎዶ''ና ሚርጌ ዲቃቲ ሄርሻዖ ዒዛ ባንሢ ጳሽኪ፦ «ኮሺዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ዬሱሴ ዒዛኮ ጊንፆ ሓንታ ናኣቶ'' ኮራ፦ «ዔያቶና ዎላ'' ዒንሢ ማርማሢ ዓይጎዛላዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ዴሮ'' ባኣካ''ፓ ፔቴ'' ዓሲ ሂዚ ጌዔኔ፦ «ዔርዛሢዮ! ጌስቲሱዋ ፑርታ ዓያና ዓርቄ ናይ ታ ኔ ኮራ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ዔቄ ዎዶ''ና ሳዓ ዒዛ ጳዺሳኔ፤ ዻንጎና ዱባሲ ዓቺ ዻይሲሳኔ፤ ዑፆዋ ዒዛኮ ሜልዚ ሌሲ''ጉዲ ማሃኔ፤ ዬያ ፑርቶ ዓያኖ ዒዛይዳፓ ኬሳ''ንዳጉዲ ኔኤኮ ጊንፆ ሓንታ ናኣቶ'' ታ ዖኦጬያታንቴ ዔያታ ኬሳ''ኒ ዳንዳዒባኣሴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ዬሱሴ ዔያቶም ሂዚ ጌዔኔ፦ «ዒንሢ ጉሙርቁዋ ዓሳ ዓይዴ ሄላ''ንዳኣና ታ ዒንሢና ዎላ'' ናንጋንዳይ? ዓይዴ ሄላ''ንዳኣና ታኣኒ ጊባንዳይ? ሂንዳ ናዖ ታ ባንሢ ዔኪ ሙኩዋቴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ዔያታ ናዓሢ ዬሱሴ ባንሢ ዔኪ ሙኬኔ፤ ፑርቶ ዓያና'' ዬሱሴ ዴዴንቃዖ ናዖ ሳዓ ጳዺሳዛ ናዓሢያ ሳዓ ኮላዺ ዻንጎና ዱባ ዬይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ዬሱሴ ናዖኮ ዓዶ ኮራ፦ «ዓይዳፓ ዓርቂ ሃይ ናዓሢ ሃያይዳይ?» ጌዒ ዖኦጬኔ። ናዖኮ ዓዴ ማሓዖ፦ «ዓኣላ'' ዓኣንቴ ዓርቃዖኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ፑርቶ ዓያና'' ዒዛ ዎዻኒያ ሚርጌ ዎዴና ታሚዳ፥ ዋኣሢዳ ኬኤራሢሮ ኔኤም ዳንዳዒንታቴ ሃዳራ ኑና ሚጪንቲ ማኣዴ''» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ዬሱሴ፦ «ኔኤም ዳንዳዒንታቶ ኔኤኒ ዎይቲ ጋዓይ? ጉሙርቃሢም ቢያ ባኣዚ'' ዳዳንዳዒንታኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ቤዞና ናዖኮ ዓዴ፦ «ጉሙርቂፆ ታ ጉሙርቃኔ፤ ጋዓንቴ ጉሙርቂሢ ፓጪሢፓ ታና ማኣዴ''» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ዓሳ ዲርጊ ዬዓሢ ዬሱሴ ዛጋዖ ፑርቶ ዓያናሢም፦ «ሓይ ኔኤኒ ናዖኮ ዋዮና ዻንጎና ባይቄያ ማሄ ዓያናሢዮ ናዓሢዳፓ ኔኤኒ ኬስካንዳጉዲ፥ ላሚ ጊንሣ ኔኤኒ ዒዛይዳ ጌሉዋጉዲ ታ ኔና ዓይሣኔ!» ጌዒ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ፑርቶ ዓያናሢ ዼኤፒ ዑኡሲና ዒላታዖ ናዓሢያ ሚርጌና ባርዲሴሢኮ ጊንፃ ኬስካዛ ናዓሢ ሓይቄ ሌሲ''ጉዲ ማሌሢሮ ሚርጌ ዓሳ ሓይቄኔ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ጋዓንቴ ዬሱሴ ናዓሢኮ ኩጮ ዓርቂ ዔቂሴኔ፥ ናዓሢያ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ዬካፓ ዬሱሴ ማኣሪ ጌሌሢኮ ጊንፃ ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ዒዛ ዱማሲ፦ «ዓይጎሮ ኑኡኒ ፑርቶ ዓያኖ ኬሳ''ኒ ዳንዳዒባኣይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ዬሱሴ ኬኤዛዖ፦ «ሓያ ጉዴሢ ሺኢጲሢና ሃሣ ሙኡዚ'' ሓሺ'' ሺኢቂሢና ማዒባኣታቶ ሜሌ'' ዓይጎና ኬስኩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ዬሱሴና ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ና ዬኖ ቤዞ ሓሺ'' ጌሊላ ዓጮና ቲቂ ዴንዴኔ፤ ዬሱሴ ዒዚ ዓኣ ቤዞ ዖኦኒያ ዔራንዳጉዲ ኮዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ዓይጎሮ ጌዔቶ ዒማ''ና ዒዚ ፔኤኮ ጊንፆ ሓንታ ናኣቶ''፦ «ዓሲኮ ናዓሢ ዓሲ ኩሽካ ዓኣሢ ዒንጊንታንዳኔ፤ ዔያታኣ ዒዛ ዎዻንዳኔ፤ ሓይቄሢኮ ጊንፃ ሓይባ''ፓ ሓይሣሳ ኬሎ''ና ዔቃንዳኔ» ጌዒ ዔርዚሢዳ ዓኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ዒዛኮ ጊንፆ ሓንታዞንሢም ዬይ ዒ ጌዔ ባካ ዔርቲባኣሴ፤ ማዔቶዋ ማሂ ዒዛ ዖኦጫኒ ዔያታ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ዬሱሴና ዒዛኮ ጊንፆ ሓንታዞንሢና ቂፒርናሆሜ ዓጮ'' ሙኪ ማኣሪ ጌሌስካፓ ዬሱሴ ዒዛኮ ጊንፆ ሓንታዞንሢ ኮራ፦ «ዒንሢ ዎንዴ ጎይፆይዳ ዓኣዖ ዎላ'' ማርማሢ ዓይጌንዴዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ዔያታ ጋዓንቴ ዚቲዮ ጌዔኔ። ዓይጎሮ ጌዔቶ ዔያታ ጎይፃ፦ «ኑ ጊዳ''ፓ ቢያ ባሼሢ ዖናዳይ?» ጌዒ ማርሜሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ዬሱሴ ዴዔሢኮ ጊንፃ ታጶ ላምዖንሢ ዔኤላ''ዖ፦ «ቢያፓ ቤርታ ማዓኒ ኮዓይ ዖናታቶዋ ቢያፓ ጋፒንሢና ሓሣ ቢያም ማዻያ ማዓንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ዬካፓ ፔቴ'' ዻካ'' ናይ ዔያቶ ቤርታ ዔቂሲ ናዖ ኮንቂጋፓ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«ሓያጉዴ ናኣቶ''ይዳፓ ፔቴ''ታዖ ታ ሱ'ንፆና ቦንቺ ዔካሢ ታና ዔካኔ፤ ታና ዔካሢ ታና ሌሊቱዋንቴ ታና ዳኬሢያ ዔካኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዮሓኒሴ ዬሱሴም፦ «ዔርዛሢዮ! ፔቴ'' ዓሲ ኔ ሱ'ንፆና ፑርታ ዓያና ኬሳ''ንቴ ኑ ዛጋዖ ዒዚ ኑኡና ዎላ''ቱዋኣሢሮ ዒዛ ኑኡኒ ላኣጌኔ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ዬሱሴ ማሓዖ፦ «ታ ሱ'ንፆና ዓኪ ዲቃሣ ባኣዚ'' ማዺ ማዺ ቤዞና ታ ዑፃ ፑርታ ጌስታንዳይ ባኣሢሮ ሓሹ''ዋቴ ላኣጊፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ዓይጎሮ ጌዔቶ ‹ኑና ዒፁዋኣሢ ቢያ ኑኡና ዎላ''ኬ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒንሢ ታኣሮ ማዔሢሮ ፔቴ'' ሙርሳና ዋኣሢ ዒንሢ ዑሻ ዓሢም ዋኣፆ ዑሼሢ ዛሎ''ሮ ዒንጊንታንዳ ባኣዚ'' ባይቃዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ዬሱሴ ኬኤዛዖ፦ «ታና ጉሙርቃ፥ ሓንሢ ዻኮ''ንሢፓ ፔቴ''ማ ዻቢሳያ ዖና ማዔቶዋ ፑኡፒ ዎንሢ ሆላ'' ቱኪ'' ባዞ''ይዳ ኬኤሪንቴቶ ቃራኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ዬያሮ ኩጫ ኔና ዻቢሳቴ ቲቂ ኔኤፓ ኬኤሬ፤ ላምዖ ኩቺ ዓኣንቴ ጋኣናኣሜይዳ፥ ታሞ ባይቁዋኣሢዳ ኬኤሪንቲፃፓ ኩቺ ዱጴያ ማዒ ናንጎ ማኣሪ ጌሊፃ ቃራኬ።  ");
INSERT INTO mdybse_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ጋኣናኣሜ ጌይንታ ቤዛ ዒኢካ ዓኣ ዛኣላ'' ሓይቁዋያ፥ ታማኣ ባይቁዋ ቤሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ቶካ'' ኔና ዻቢሳቴ ኔኤፓ ቲቂ ኬኤሬ፤ ላምዖ ቶኪ ቢያ ዓኣንቴ ጋኣናኣሜ ጌሊፃፓ ፔቴ'' ቶኪና ማዒ ናንጎ ማኣሪ ጌሊፃ ቃራኬ።  ");
INSERT INTO mdybse_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ጋኣናኣሜ ጌይንታ ቤዛ ዒኢካ ዓኣ ዛኣላ'' ሓይቁዋያ፥ ታማኣ ባይቁዋ ቤሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ዓኣፓ ኔና ዻቢሳቴ ኔኤፓ ኬሲ'' ኬኤሬ፤ ላምዖ ዓኣፒ ዓኣንቴ ጋኣናኣሜ ጌሊፃፓ ፔቴ'' ዓኣፒና ናንጎ ማኣሪ ጌሊፃ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ጋኣናኣሜ ጌይንታ ቤዛ ዒኢካ ዓኣ ዛኣላ'' ሓይቁዋያ፥ ታማኣ ባይቁዋ ቤሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ፆኦሲም ዒንጎ ባኣዚ'' ሶኦጌ ዋሂ ጌኤሾ''ሢጉዲ ዓሲ ቢያ ታሚዳ ጌሊ ጌኤሽኪ ኬስካንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«ሶኦጌ ኮሺኬ፤ ጋዓንቴ ሶኦጌኮ ጌኤሻ''ኒ ዎልቄ ባኣያ ማዔቶ ዓይጎና ዒንሢ ጌኤሻ''ንዳይ? «ዒንሢኮዋ ሶኦጌጉዲ ጌኤሻ'' ዎልቄ ዓኣያ ማዖንጎ፤ ሴካና ሓንጋና ዎላ'' ጊኢጊ ኮሺ ናንጉዋቴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ዬሱሴ ዬኖ ዓጮ''ይዳፓ ዔቂ ዪሁዳ ዓጮ''ና ጌዒ ዮርዳኖሴ ዎሮ ሱኮ ፒንቄኔ፤ ሚርጌ ዴሬ ዒዛ ባንሢ ሙኬሢሮ ዒዚ ሚናኣፓ ዔርዛሢጉዲ ሓሣ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ፔቴ'' ፔቴ'' ፔርሴ ዓሳ ዬሱሴ ባንሢ ሙካዖ ጌኤሲና ዒዛ ፒራኒ ኮዓሢሮ፦ «ዓሲ ፔ ማቾ ዓንጃንዳጉዲ ዎጋ'' ዓይሣ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ዬሱሴ፦ «ሙሴ ዒንሢ ዬያ ዛሎ'' ዎዚ ጌይ ዓይሣዖ?» ጌዒ ዖኦጪሢና ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ዔያታ፦ «ሙሴ ዎጋ'' ዓንጂንቶ ዔርዛያ ፃኣፖና ዋርቃታ ዒንጊጋፓ ዓንጃንዳጉዲ ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ዬሱሴ ዔያቶም ሂዚ ጌዒ ማሄኔ፦ «ሙሴ ያዒ ጌይ ዓይሤሢ ዒንሢኮ ዒና'' ዋይዞ ዒፂ ዶዳሢ ዛጊኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ጋዓንቴ ማዢንቶኮ ዓይፃፓ ጌኤዦ ማፃኣፓ ጋዓ ጎይፆ ‹ፆኦሲ ዓቲንቄና ላኣሊና ማሂ ማዤኔ፤› ");
INSERT INTO mdybse_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹ዬያሮ ዓሲ ዓዶና ዒንዶና ሓሺ'' ማቾና ዎላ'' ፔቴ'' ማዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ላምዖንሢያ ፔቴ'' ዑሢ ማዓኔ› ዬካፓ ሴካ ላምዖ ማዒፃ ዓቴ''ም ፔቴ'' ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ዬያሮ ፆኦሲ ዋኣፄሢ ዖኦኒያ ቡሎ''ፓ።» ");
INSERT INTO mdybse_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ዬሱሴኮ ጊንፆ ሓንታ ናኣታ'' ማኣሮ ባንሢ ማዔ ዎዶ''ና ላሚ ዒዞ ዛላ ዬሱሴ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ዬሱሴ ዔያቶም ማሓዖ፦ «ዖና ማዔቶዋ ፔ ማቾ ዓንጂ ሜሌ'' ላኣሊ ዔካሢ ፔኤኮ ቤርታኣ ማቾ ዒኢሳ''ኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ዬያጉዲ ሓሣ ዖናታቴያ ፔ ዓኒፓ ዓንጂንቲ ሜሌ''ም ሎዓ ላኣሌላ ዒኢታያ ማዓኔ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ፔቴ'' ፔቴ'' ዓሳ ፔኤኮ ናኣቶ''ኮ ዬሱሴ ኩጮና ዑፆ ካኣማንዳጉዲ ዔኪ ሙካዛ ዬሱሴኮ ጊንፆ ሓንታ ናኣታ'' ዬኖ ዓሶ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ዬሱሴ ዬያ ዛጊጋፓ ጎሪ''ንቲ ፔኤኮ ጊንፆ ሓንታ ናኣቶ''ም ሂዚ ጌዔኔ፦ «ፆኦሲ ካኣቱማ ሃንሢ ዔያቶ ጉዴዞንሢም ማዔሢሮ ናኣታ'' ታ ኮራ ሙኮንጎ፤ ሓሹ''ዋቴ፥ ላኣጊፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ጎኔ ታ ዒንሢም ጋዓኔ፤ ፆኦሲኮ ካኣቱሞ ናይ ማዒ ዔኩዋ ዓሲ ፔቴ''ታዖ ዒኢካ ጌሊንዱዋሴ!» ");
INSERT INTO mdybse_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ዬሱሴ ዬካፓ ናኣቶ'' ኮንቂ፥ ኩጮ ዑፃ ጌሢ ዓንጄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ዬሱሴ ዬካፓ ኬስኪ ጊንሣ ዓኣዻኣና ፔቴ'' ዓሲስኬያ ጳሽኪ ሙኪ ቤርታ ጉምዓታዖ፦ «ኮዦ ዔርዛሢዮ! ናንጊና ናንጊ ዴንቃኒ ዓይጎ ማዻንዳያ ታና ኮይሳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ዬሱሴ ማሓዖ፦ «ዓይጎሮ ኮዣሢዮ ኔኤኒ ታና ጋዓይ? ፔቴ'' ፆኦሲዳፓ ዓቴም ሜሌ'' ኮሺ ዖኦኒያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ኔኤኒ ዓይሢፆንሢ ዔራኔ፤ ዬንሢያ፦ ‹ዓሲ ዎዺፖ፥ ላኣሊ ዒኢሲ''ፖ፥ ዉኡቂፖ፥ ሉኡዙሞና ማርካቲፖ፥ ጌሺፖ፥ ዓዶና ዒንዶና ቦንቼ› ጋዓዞንሢኬ።» ");
INSERT INTO mdybse_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ዓሢያ፦ «ዔርዛሢዮ! ዬያ ዓይሢፆ ቢያ ናኣቶፓ ዓርቃዖ ታኣኒ ካፓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ዬሱሴ ናሹሞና ዒዛ ዛጋዖ፦ «ፔቴ'' ባኣዚ'' ሌሊ ዓቴ''ኔ፤ ዴንዲ ኔኤኮ ዓኣ ባኮ ቢያ ሻንቺ ማንቆ ዓሶም ጊሽኪ ዒንጌ፤ ዬካፓ ታ ጊንፆ ሙኪ ሓንቴ፤ ጫሪንጮ ማኣራ ቡኪንቴ ቆሎ ኔኤኮ ዓኣያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ዓሢ ዬያ ዋይዛዖ ዓኣፖ ካሮ'' ቱኬ''ኔ፤ ኮሺ'' ዒ ዖርጎቺታሢሮ ዖዪ ዖዪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ዬሱሴ ጊንፆ ሓንታ ናኣቶ'' ባንሢ ሺራዖ፦ «ዖርጎቺ ዓሲም ፆኦሲ ካኣቱሞይዳ ጌሊሢ ዎዚጉዲ ሜታንዳይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ጊንፆ ሓንታ ናኣታ'' ዬኖ ዬሱሴ ጌዔዞ ዋይዚ፦ «ሓያጉዴ ባኣዚ''» ጌዒ ዲቃቴኔ፤ ጋዓንቴ ዬሱሴ ላሚ፦ «ናይዮቴ! ፆኦሲ ካኣቱሞይዳ ጌሊሢ ዎዚ ሜታንዳይ! ");
INSERT INTO mdybse_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ዖርጎቺ ዓሲ ፆኦሲ ካኣቱሞይዳ ጌላንዳስካፓ ጋኣላ ናርፔ ፂኢናና ጌላኒ ሼሌዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ጊንፆ ሓንታ ናኣታ'' ዬሱሴ ጌዔሢና ኮሺ'' ዲቃቲ ሄርሻዖ፦ «ያዒ ማዔቶ ማይ ዖኦኒ ዻቃኒ ዳንዳዓይ!» ዎሊ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ዬሱሴ ዔያቶ ባንሢ ዛጋዖ፦ «ጎኔና ዬይ ዓሲም ዳንዳዒንቱዋሴ፤ ጋዓንቴ ፆኦሲም ዳዳንዳዒንታያኬ፤ ቢያ ባኣዚ'' ፆኦሲም ዳንዳዒንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴፂሮሴ ዒማ''ና፦ «ሃይሾ ኑኡኒ ቢያ ባኣዚ'' ሃሺ'' ኔ ጊንፆ ሓንታንቴሞ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ዬሱሴ ሂዚ ጌይ ማሄኔ፦ «ጎኔ ታኣኒ ጋዓኔ፤ ታናንታ ታኣኮ ኮዦ ሓይሶንታሮ ጌዒ ፔኤኮ ማኣሮ፥ ጌርሲንሢ፥ ጌሮንሢ፥ ዒንዳ፥ ዓዴ፥ ናኣቶ''ንታ ጎዦንታ ሓሻ''ሢ ባሼና ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ሓያ ዎዶ''ይዳታቴያ ዒፂንቲ ዳኪንቲፆና ፔኤኮ ማኣሮ፥ ጌርሲንሢ፥ ጌሮንሢ፥ ዒንዶንሢ፥ ናኣቶ''ንታ ጎዦንታ ሓሼ''ቶ ሚርጌ ፄኤታ ጳንጬ ማሂ ዔካንዳኔ፤ ሙካ ዓጮ''ይዳ ናንጊና ናንጊ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ዬይ ያዺ ማዔቶዋ ቤርቲ ማዔ ጎኦቦ'' ማላ ሜርጌ ዓሳ ጊንሢም፤ ጊንፃ ዓቴ''፥ ላቤያ ማላ ሜርጌ ዓሳ ቤርቲም ማዓንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ዬሩሳላሜ ዴንዳ ጎይፆይዳ ዔያታ ዓኣንቴ ዬሱሴ ዔያቶኮ ቤርታ ቤርታ ዴንዳኔ፤ ጊንፆ ሓንታ ናኣታ''፦ «ሓያጉዴ ባኣዚ''» ጌዒ ዬኖ ሓይሶ ዲቃቲ ሄርሼኔ፤ ሓንጎ ዒዛና ዓኣ ዓሳ ዒጊጬኔ። ዒዚ ጊንሣ ላሚ ዒዛ ሄላ''ንዳ ባኮ ኬኤዛኒ ታጶ ላምዖንሢ ፔ ባንሢ ዔኤላ''ዖ ሂዚ ጌዒ ኬኤዜኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«ሓይሾ ኑኡኒ ዬሩሳላሜ ዴንዲፆይዳኬ፤ ዓሲኮ ናዓሢ ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢናም ዓኣሢ ዒንጊንታንዳኔ፤ ዔያታኣ ዒዚ ሓይቃንዳጉዲ ጌዒ ጌስቲ ኩንሣንዳኔ፤ ዓይሁዴ ማዒባኣ ዓሶም ዒዛ ዓኣሢ ዒንጎንዶኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ዓይሁዴ ማዒባኣ ዴራ'' ዒዛ ቦሃንዳኔ፥ ጩታንዳኔ፥ ዢራፓና ጳርቃንዳኔ፤ ሓሣ ዎዻንዳኔ። ጋዓንቴ ሓይሦ ዓቢኮ ጊንፃ ሓይባ''ፓ ዔቃንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ዜብዲዮሴኮ ናኣታ'' ያይቆኦቤና ዮሓኒሴና ዬሱሴ ኮራ ሙካዖ፦ «ኑና ዔርዛሢዮ! ኑኡኒ ዖኦጫ ባኮ ኔኤኒ ማዻንዳጉዲ ኑ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ዬሱሴ፦ «ዓይጎ ታኣኒ ማዻንዳጉዲ ዒንሢ ኮዓይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ዔያታ ማሓዖ፦ «ኔኤኮ ቦንቺንቴ ካኣቱሞይዳ ዓኣ ቦንቾ ቤዛ፡ ኑጊዳፓ ፔቴ''ሢ ኔኤኮ ሚዛቃ፤ ፔቴ''ሢ ሻውሎ ዛላ'' ኑና ማሂ ዴይሤ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ዬሱሴ ጋዓንቴ፦ «ዒንሢ ዖኦጮ ባኮ ዔሩዋሴ፤ ታኣኒ ዔካ ሜታሢ ዒንሢ ዔካኒ ዳንዳዓ? ታኣኒ ጌላንዳ ሜታስካ ዒንሢ ጌላኒ ዳንዳዓ?» ጌዒ ዔያቶ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ያይቆኦቤና ዮሓኒሴና ማሓዖ፦ «ሂዮ ኑኡኒ ዳንዳዓንዳኔ» ጌዔኔ። ዬሱሴያ፦ «ጎኔኬ፤ ዒንሢ ታኣኒ ዔካ ሜቶ'' ዔካኒ፥ ታኣኒ ጌላ ሜታስካኣ ጌላኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ጋዓንቴ ታኣኮ ሚዛቆና ሻውሎ''ናይዳ ዴዓንዳጉዲ ዓይሣሢ ታናቱዋሴ፤ ዬይ ቤዛ ዒንጊንታሢ ዒዞ ቤዞም ፆኦሲ ጊኢጊሼ ዓሶምኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ዓቴ'' ታጶንሢ ዬያ ዋይዛዖ ያይቆኦቤና ዮሓኒሴናይዳ ዻጋዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ዬሱሴ ቢያሢ ፔ ባንሢ ዔኤላ''ዖ ሂዚ ጌዔኔ፦ «ዓይሁዴ ማዒባኣ ዓሶኮ ሱኡጋ ዴሮ''ኮ ዎይሣዞንሢ ጌይንቲ ዔኤሊ''ንታያ ማዔሢና ሓሣ ዔያቶኮ ቢቶ'' ማዔዞንሢኮ ዔያቶ ዑፃ ቢታንቶ ዓኣያ ማዔሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ጋዓንቴ ዒንሢ ባኣካ'' ያዒ ማዓኒ ኮይሱዋሴ፤ ዒንሢፓ ፔቴ'' ዓሲ ፑኡፒ ማዓኒ ኮዔቶ ቢያሢም ማዻያ ማዖም፤ ");
INSERT INTO mdybse_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ዒንሢ ባኣካ''ፓ ዼ'ጌ ማዓኒ ኮዓሢ ቢያሢም ዓይሌ'' ማዖም፤ ");
INSERT INTO mdybse_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ዓሲኮ ናዓሢታዖ ቢያሢኮ ዴማ'' ማዒ ማዻኒና ፔኤኮ ሼምፓሢ ሚርጌዞንሢ ዛሎ'' ዒንጊ ዻቂሻኒ ሙካንዳኣፓዓቴም ዓሲ ዒዛም ማዻንዳጉዲ ሙኪባኣሴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ዬካፓ ዬሱሴና ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ና ዎላ'' ዒያርኮ ጌይንታ ካታሞ ሙኬኔ፤ ዔያቶና ዎላ'' ሚርጌ ዴሬ ዒያርኮ ካታማፓ ኬስካንቴ ፔቴ'' ፂሞሴ ናይ፥ ዓኣፒ ባይቄያ ቤርፄሞሴ ጎዖስኬይ ጎይፆ ዓጫ ዴዒ ዔኤቢ ዒንጎም ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ዒዛኮ ኮርሲና ዴንዳሢ ናዚሬቶ ዬሱሴ ማዔሢ ዒ ዋይዛዖ፦ «ዳውቴ ናዓሢዮ! ዬሱሴ ሓዳራ ታና ሚጪንቲ ማኣዴቴራ» ጌዒ ዒላቲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ሚርጌ ዓሳ፦ «ዚቲዮ ጌዔ!» ጌይ ጎሬኔ፤ ዒዚ ጋዓንቴ «ዳውቴ ናዓሢዮ ታና ማኣሬ!» ጌዒ ሓቺም ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ዬሱሴ ዔቃዖ፦ «ዒዛ ዔኤሉ''ዋቴ» ጌዔኔ፤ ዔያታ ዓኣፓ ባይቄሢ ዔኤላ''ዖ፦ «ዔኤዛይ ዒጊጪፖ፥ ዔቄ! ዬሱሴ ኔና ዔኤላ''ኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ዒዚ ፔኤኮ ቃሲ'' ዑፃ ማኣዔ ዓፒሎ ኬኤሪ፥ ጱሊ'' ዔቃዖ ዬሱሴ ባንሢ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ዬሱሴ፦ «ታኣኒ ዓይጎ ዎኦቶም ኔኤኒ ኮዓይ?» ጌዒ ዖኦጬኔ። ዒዚ፦ «ዔርዛሢዮ! ሓዳራ ታኣኒ ዛጋንዳጉዲ ዓኣፖ ታኣም ፖዒሴ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ዬሱሴ፦ «ሂዴቶ ዴንዴ፤ ኔ ጉሙርቂፃ ኔና ዓውሴኔ» ጌዔኔ። ዓሢያ ቤዞማና ዛጌኔ፤ ጎይፆናኣ ዬሱሴ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ዬሱሴና ዒዛኮ ጊንፆ ሓንታዞንሢና ዬሩሳላሜ ሙኪ ዑካዖ ዛይቶ ሪሚቶ ዹኮ'' ኮይላ'' ዓኣ ቤቴፓጌና ቢታኒያ ጌይንታ ካታሞንሢ ሙኬኔ፤ ዬሱሴ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ይዳፓ ላምዖስኬንሢ ቤርታ ሂዚ ጌዒ ዳኬኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«ሃኖ'' ሴኮ ጉርዴሎ ዒንሢ ቤርታዺ ዓኣዹዋቴ፤ ዒኢካ ዒንሢ ሄሄላ''ዖ ዖኦኒያ ቶጊባኣ ሓሬ ናይ ቱኡቲ ዓኣንቴ ዴንቃንዳኔ፤ ቡሊ'' ሃኒ ዔኪ ዬዑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ዖኦኒያ ዒንሢ ዓይጎሮ ቡላ''ይ ጌዒ ዖኦጬቶ ‹ጎዳም ኮይሳሢሮኬ፤ ዑኬና ዒዚ ማሂ ዳካንዳኔ› ጌዒ ኬኤዙዋቴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ዔያታኣ ዴንዳዖ ሓሮ'' ናዖማ ጎይፆ ዓጫ፥ ማኣሪ ካርካ ቱኡቲ ዓኣንቴ ዴንቂ ቡሌ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ዒማ''ና ዒኢካ ዔቂ ዓኣ ዓሶፓ ፔቴ'' ፔቴ'' ዓሲ፦ «ሃሮ'' ናዖ ዎዳ''ኒ ቡላ''ይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ዔያታኣ ዬሱሴ ጌዔሢ ዖኦጫ ዓሶም ማሂ ኬኤዛዛ ዓሳ ዔያቶ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ላምዖ ጊንፆ ሓንታ ናኣቶ''ንሢ ሃሮ'' ናዖ ዔኪ ዬሱሴ ኮራ ሙካዖ፥ ዔያታ ፔኤኮ ዓፒሎ ሓሮ'' ናዖ ዙላ'' ጌሣዛ ዬሱሴ ቶጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ሚርጌ ዓሳ ፔኤኮ ዓፒሎ ጎይፃ ሒኢሣዛ ዛሎ'' ዓሳ ካያፓ ዋላሺ ሜንሢ ሜንሢ ጎይፃ ሂኢሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ዬሱሴኮ ቤርቶና ጊንፆናይዳ ዓኣ ዴራ'' ቢያ፦ «ፆኦሲ ጋላቲንቶም! ጎዳ ሱ'ንፆና ሙካሢ ፆኦሲ ዓንጆንጎ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ሓጊ ሙካ፥ ኑኡኮ ዓዳሢ፥ ዳውቴ ካኣቱማ ዓንጂንቴያኬ! ጋላታ ጫሪንጮይዳ ፆኦሲም ማዖንጎ!» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ዬሱሴ ዬሩሳላሜ ሄሊ'' ፆኦሲኮ ጌኤዦ ማኣሪ ጌላዖ ዓጫ ዓኣ ባኮ ቢያ ዛጌኔ፤ ሳዓ ዓሜሢሮ ታጶ ላምዖንሢና ዎላ'' ዬሩሳላሜፓ ኬስኪ ቢታኒያ ጎዖ ቤዞ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ጉቴ'' ቢታኒያፓ ዔያታ ማዓኣና ዬሱሴ ናይዺንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ፔቴ'' ዋርቂ ዓኣያ ቤሌሴ ጌይንታ ሚሢ ሃኬ ዴንቃዖ ጎዖንቴ ዒዞይዳ ዓኣፒ ናንጋንዳኔ ጌዒ ሚፄሎ ባንሢ ዓኣዼኔ። ጋዓንቴ ሚፄላ ዓኣፑዋ ዎዴ ማዔሢሮ ዒላሺፓ ዓታዛ ፔቴ''ታዖ ዓኣፒ ዒዚ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ዬያሮ ዬሱሴ ሚፄሎ፦ «ሃይፓ ሴካ ዖኦኒያ ኔጊዳፓ ዓኣፒ ሙዖፓ» ጌዔኔ። ዬያ ዒዚ ጋዓኣና ጊንፆ ሓንታ ናኣታ'' ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ዬሱሴ ዬሩሳላሜ ሙካዖ ጌኤዦ ማኣሮ ጌሊ ዒኢካ ሻንቻ ዓሶና ሻንቃ ዓሶና ዳውሲሢ ዓርቄኔ። ሚኢሾ ላኣማ ዓሶኮ ሚኢሾ ጌሦሢና ዶኦሎ'' ሻንቻ ዓሶኮ ዖይቶና ሂዒ ዶይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ዖኦኒያ ዓይጎ ባኣዚ'' ኬዲ ጌኤዦ ማኣሮኮ ዲሮ ጋሮና ዓኣዻንዳጉዲ ዒ ኮዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ዬሱሴ ዴሮ'' ሂዚ ጌዒ ዔርዜኔ፦ « ‹ታኣኮ ማኣራ ዓሲ ዜርሢ ቢያኮ ሺኢጲሢ ማኣሪኬ› ጌዒንቲ ፃኣፒንቲባኣዓዳ? ዒንሢ ጋዓንቴ ዉሲ'' ዓኣሺንታ ቤሲ ማሔኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ቄኤሶኮ ሱኡጎና ሙሴኮ ዓሶ ዎይሣ ዎጎ ዔርዛዞንሢና ዬሱሴ ዬያ ኬኤዛኣና ዋይዜኔ፤ ዒዚ ኬኤዛሢ ዴራ'' ቢያ ዲቃቲ ሄርሻሢሮ ዔያታ ዒጊጫዖ ዎዲ'' ዓርቂ ዒዛ ባይዛንዳቴያ ካራ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ዬሱሴና ጊንፆ ሓንታ ናኣቶ''ና ሳዓ ዓማዛ ካታማፓ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ዚሮ ጉቴ''ሎ ጉቴ'' ዓሚ'' ጎይፆና ዔያታ ዴንዳዖ ቤሌሶ ሚፄላ ፃጲና ሜሊ ዓኣንቴ ዴንቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴፂሮሴ ዚጊኖ ዬሱሴ ጌዔሢ ጶቂሣዖ፦ «ዔርዛሢዮ! ኔኤኒ ጋዳንቄ ሚፄላ ሓይሾ ሜሌኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ዬሱሴ ዔያቶም ማሓዖ፦ «ፆኦሲ ጉሙርቁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዖኦኒያ ላምዖ ዒኔና ማይባኣዖ ‹ታኣኒ ኮዓ ባካ ማዓንዳኔ› ጌዒ ጉሙርቂሢና ሓያ ዹኮ'' ‹ሓይፓ ዔቂ ባዞ''ይዳ ኬኤሪንቴ› ጌዔቶ ኬኤሪንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ዬያሮ ሺኢጲሢና ዓይጎ ባኣዚ''ታቶዋ ዒንሢ ሺኢቄቶ ዒንሢም ማዔያጉዲ ጉሙርቁዋቴ፤ ዒንሢ ሺኢቃ ባካ ቢያ ዒንሢም ዒንጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ጫሪንጫ ዓኣ ዓዳሢ ዒንሢ ጎሞ ዓቶም ጋዓንዳጉዲ ዒንሢ ሺኢቃኒ ዔቃ ዎዶ''ና ዓሲዳ ዒንሢ ዓርቄ ኮሜ ዓኣቶ ሃሹ''ዋቴ።  ");
INSERT INTO mdybse_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ዒንሢ ሜሌ'' ዓሶኮ ዻቢንቶ ዓቶም ጌዒባኣቶ ጫሪንጫ ዓኣ ዓዳሢ ዒንሢ ጎሞ ዓቶም ጌዒንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ዔያታ ላሚ ዬሩሳላሜ ማዒ ሙኬኔ፤ ዬሱሴ ጌኤዦ ማኣሮ ጌሊ ሓንታንቴ ቄኤሶኮ ሱኡጋ፥ ሙሴ ዎጎ ዔርዛዞንሢ ሓሣ ጪማኣ ዒዛ ኮይላ'' ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«ሓያ ባኮ ቢያ ኔኤኒ ማዻሢ ዓይጎ ቢታንቶናዳይ? ሓሣ ሓያ ባኮ ማዻንዳጉዲ ቢታንቶ ኔኤም ዒንጌሢ ዖናዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ዬሱሴ ማሓዖ፦ «ታኣኒያ ዒንሢ ፔቴ'' ባኣዚ'' ዖኦጫንዳኔ፤ ዒንሢ ታኣም ማሄቶ ታኣኒ ዓይጎ ቢታንቶና ሓያ ባኮ ማዻቴያ ዒንሢም ኬኤዛንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ዮሓኒሴኮ ማስኪፃ ፆኦሲፓሞ ዓሲፓዳይ? ሒንዳ ታኣም ኬኤዙዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ዔያታ፦ « ‹ዓካሪ ኑ ዎዚ ጋዓንዳይ?› ጌዒ ዎላ'' ዞርታዖ፥ ‹ፆኦሲፓኬ› ጌዒ ኑኡኒ ማሄቶ ‹ሂዳዖ ዒንሢ ዓይጎሮ ዮሓኒሴ ኬኤዛሢ ጉሙርቂባኣይ?› ዒዚ ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹ዓሲፓኬ› ኑኡኒ ጌዔቶሽ?» ዓሲፓኬ ዔያታ ጎዑዋጉዲ ዴራ'' ቢያ ማስካ ዮሓኒሴ «ጎኔና ፆኦሲ ማሊሢ ኬኤዛ ዓሲኬ» ጋዓሢሮ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ዬያሮ፦ «ኑኡኒ ዔሩዋሴ» ጌዒ ማሄኔ። ዬሱሴያ፦ «ያዒታቶ ታኣኒያ ዓይጎ ቢታንቶና ሃያ ባኮ ማዻቶ ዒንሢም ኬኤዛዓ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ሄሊ''ሳዖ ዬሱሴ ዬኖ ኮኦኪንሢና ሂዚ ጌዒ ኬኤዚሢ ዓርቄኔ፦ «ፔቴ'' ዓሲ ዎይኔ ጌይንታ ሙዖ ዓኣፒ ዓኣፓ ሚሢዳ ባልጋ ባኣዚ'' ቱኬኔ፤ ዓጮዋ ኮሺ'' ዲርቂ ዬኖ ካፃዛ ሄ'ርቂ ጩኡጲ ዑሺ ኮሾ''ንዶ ዔቴያ ላሌ ሹቺዳ ቆኦቂ ቦኦኪ ጊኢጊሼኔ፤ ሓሣ ዎይኔሎ ካፓ ዓሶም ዼ'ግ ጌዔ ሴኤላ'' ሴኤሊ''፥ ዬካፓ ዬኖ ቤዞ ጎሽኪ ጎሽኪ ታኣም ካፑዋቴ ጌዒ ጎሽካ ዓሲም ዒንጊ ሓኬ ዓጪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ዎይኖ ማንፆ ዎዶ''ና ዒዛ ሄላ'' ዛሎ'' ዔኪ ሙካንዳጉዲ ዒዛኮ ዓይሢንቲ ማዻ ዓሲ ጎሽካ ዓሶ ኮራ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ጎሽካ ዓሳ ዒዛ ዬያ ዓይሢንቲ ማዻሢ ዓርቂ ጳርቄስካፓ ኩቺ ጉሪ ማሂ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ጊንሣ ሓሣ ጎዦ ዓዴ ሜሌ'' ዓይሢንቲ ማዻያ ዳካዛ ጎሽካዞንሢ ዬያኮዋ ቶኦኮ'' ዹይ ዑሪ፥ ቦርሲሲ ዳኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ሄሊ''ሲ ሓሣ ሜሌ'' ዳካዛ ዬያኣ ዎዼኔ፤ ዬያጉዴያ ሚርጌ ዓሲ ዳካዛ ዛሎ'' ጳርቂ ዛሎ'' ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ዓካሪ ጎዦ ዓዴ ማዻኒ ዓቴ'' ባኣዚ'' ፔኤኮ ናሽካ ናዓሢ ዳኪሢ ሌሊኬ፤ ዬያሮ ‹ጎዖንቴ ታኣኮ ናዓሢ ዔያታ ቦንቻንዳኣናንዳኔ› ሂዚ ጌዒ ማላዖ ቢያሢኮ ጋፒንፆይዳ ፔቴ'' ናዓሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ጋዓንቴ ጎሽካዞንሢ ዎሊ ኮራ ‹ሓይ ዒዛ ዻካላንዳሢታሢሮ ሃኒ ዬዑዋቴ፤ ኑ ዒዛ ዎዼቶ ዒዛኮ ዓዶኮ ዓኣ ባካ ቢያ ኑም ማዓንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ዬያሮ ናዓሢ ዔያታ ዓርቂ ዎዺ ዬኖ ጎሽኮ ቤዜሎኮ ቲኢፆ ዙላ'' ዔኪ ዓኣዺ ኬኤሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ዓካሪ ዬኖ ጎዤሎኮ ዓዳሢ ዓይጎ ዎኦታንዳይ? ጌዔቶ ዒዚ ፔኤሮ ሙኪጋፓ ጎሽካ ዓሶ ዎዻንዳኔ፤ ዬኖ ጎዦ ቤዜሎ ሜሌ'' ጎሽካ ዓሲም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ጌኤዦ ማፃኣፖይዳ፦ ‹ማኣሮ ማዣ ዓሳ ቦሂ ሃሼ'' ሹጫሢ ማኣሮኮ ሄሎ ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ዬይ ሓሣ ፆኦሲ ማዾኬ፤ ኑኡኒ ዛጋዛ ዲቃሢ ሔርሺሳያኬ።› » ጌይንቲ ፃኣፒንቴሢ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ዓይሁዶኮ ሱኡጎ ማዔ ዓሳ ዬሱሴ ዬያ ኮኦኪንሦና ዔያቶ ዛላ ኬኤዜያ ማዔሢ ዔራዖ ዒዛ ዓርቃኒ ኮዔኔ፤ ጋዓንቴ ሚርጌ ዴሬ ዓኣያታሢሮ ዒጊጪ ዔያታ ዒዛ ሓሺ'' ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ፔርሴ ዓሶና ሄሮዲሴ ዓሶና ዛላ''ፓ ማዔ ፔቴ'' ፔቴ'' ዓሲ ዬሱሴ ጌስታ ጌኤዞና ዻቢንታቶ ቡኡዲ ዓርቃንዳጉዲ ዒዛ ኮራ ዳኪንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ዬንሢያ ዒዛ ኮራ ሙካዖ፦ «ዔርዛሢዮ! ኔኤኒ ጎኔ ኬኤዛያ ማዔሢ ኑኡኒ ዔራኔ፤ ዓሲ ዒጊጪሢና ዓሲ ታና ዎዚ ጋዓንዳይ? ጌዒ ኔ ማዻ ባኣዚ'' ባኣሢሮ ፆኦሲኮ ጎይፆ ጎኑሞና ኔኤኒ ዔርዛኔ፤ ያዒ ማዓዛ ሮሜ ዓጮ'' ካኣቲም ጊኢራ ጪጊሢ ዎጋ'' ዓይሣሞ? ዓይሡዋይ? ኑኡኒ ጊኢሮንዶሞ? ሓሾ''ንዶይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ዬሱሴ ዔያቶኮ ጌኖ ማሊፆ ዔራዖ፦ «ዒንሢ ታና ዓይጎሮ ጌኤሲና ቡኡዳኒ ኮዓይ? ሂንዳ ሮሜ ዓጮ'' ሚኢሾ ታና ዻውዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ዔያታ ሚኢሾ ዔኪ ሙካዛ ዒዚ፦ «ሓኖ ሮሜ ዓጮ'' ሚኢሼሎይዳ ዓኣሢኮ ዓውካሮና ፃኣፒንቴ ሱ'ንፆና ዖኦሮዳይ?» ጌዒ ዖኦጬኔ። ዔያታ ማሓዖ፦ «ሮሜ ዓጮ'' ካኣቲሲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ዬሱሴ፦ «ያዒ ማዔቶ ካኣቲሲ ካኣቲም፥ ፆኦሲሲ ፆኦሲም ዒንጉዋቴ» ጌዔኔ። ዔያታ ዒዛኮ ማሂፆና ኮሺ'' ዲቃቲ ሔርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","«ሓይቄ ዓሲ ሓይባ''ፓ ዔቂንዱዋሴ» ጋዓ ሶዶቄ ዓሳ ዬሱሴ ኮራ ሙካዖ ሂዚ ጌዒ ዒዛ ዖኦጬኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«ዔርዛሢዮ! ሙሴ ዓሶ ዎይሦ ዎጎይዳ ኑም ፔቴ'' ዎጌ ፃኣፒ ዒንጌኔ፤ ዬና ‹ፔቴ'' ዓሲ ላኣሊ ዔካዖ ሾውዋዖ ሓይቄቶ ዒዛኮ ጌርሲ ላኣሌሎ ዔኪ ሓይቄሢም ፃጲ ጌሣኒ ናይ ሾዖንጎ› ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ዓካሪ ሂንዳ ፔቴ'' ዓሲኮ ላንካይ ዓቲንቄ ናይ ዓኣኔ ኑ ጎዖም፤ ዔያቶኮ ቶይዳሢ ላኣሊ ዔካዖ ሾውዋ ሓይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ሄሊ''ሴ ጌኤዚ ሓይቄሢኮ ዬኖ ላኣሌሎ ዔካዖ ሓሣ ሾውዋ ሓይቄኔ፤ ሓይሣሳሢያ ሓሣ ዬያጉዲ ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ዬያይዴ ጎይሣ ላንኮ ጌርሲንሢ ቢያ ላኣሌሎ ዔካዖ ዻካላንዳ ናይ ሾውዋ ሓይቃዛ ቢያሢኮ ጋፒንፃ ላኣሌላ ሓይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ላንኮ ጌርሲንሢ ቢያ ዒዞ ዔኬያታሢሮ ጋፒንፃ ሓይቄ ዓሳ ዔቃ ዎዶ''ና ዬና ላኣሌላ ዎያኮ ማቾ ማዓንዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ዬሱሴ ዔያቶም ማሓዖ፦ «ዒንሢ ሓኣዒዲ ዻቢንታሢ ፃኣፒንቴሢና ፆኦሲኮ ዎልቆና ዔሩዋኣሢሮቱዋይ? ");
INSERT INTO mdybse_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ሓይቄ ዓሳ ዔቃዖ ጫሪንጫ ዓኣ ፆኦሲኮ ኪኢታንቾጉዲ ማዓንዳፓ ዓቴም ዔኩዋሴ፤ ሎዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ሓይቄ ዓሶ ዔቂፆ ዛሎ'' ማዔቶ ጋዓንቴ ፆኦሲ ሙሴም ካዮ ባኣካ'' ታሞና ጴዺ ኬኤዜ ዎዶ''ና ዓይጎ ኬኤዜቶዋ ሙሴ ማፃኣፖይዳ ዒንሢ ናባቢባኣዓዳ? ዬና ዓይጎዳይ ጌዔቶ፦ ‹ፆኦሲ፤ ታኣኒ ዓብራሃሜ ፆኦሲ፥ ዪሳኣቄ ፆኦሲ፥ ያይቆኦቤ ፆኦሲኬ› ጌዔሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ፆኦሲ ሼምፖና ናንጋ ዓሶ ፆኦሲ፥ ሓይቄቶዋ ናንጊና ናንጋ ዓሶ ፆኦሲኬ። ዒንሢ ጋዓንቴ ኮሺ'' ዻቢንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶይዳፓ ፔቴ''ስኬያ ማርማሢ ዔያቶኮ ዋይዜኔ፤ ዬሱሴ ፔ ኮራ ዖኦጫ ዓሶም ቃራ ማሂሢ ማሔሢ ዋይዚ ዒና ዔኬኔ፤ ዬይ ዓሢ ዬሱሴ ባንሢ ሙካዖ፦ «ፆኦሲ ዓይሤ ዓይሢፆይዳፓ ቢያ ባሼ ማዔ ዓይሢፃ ዎኖዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ዬሱሴ ዒዛም ማሓዖ፦ «ቢያፓ ባሼ ማዔ ዓይሢፃ ‹ዒስራዔኤሌ ዋይዜ! ፆኦሲ ኑኡኮ ፔቴ'' ፆኦሲ ሌሊኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ኔኤኒያ ኔኤኮ ፆኦሲ ጉቤ ዒናፓ፥ ጉቤ ሼምፓፓ፥ ጉቤ ማሊፃፓ፥ ጉቤ ዎልቃፓ ናሽኬ› ጋዓያኬ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ሓሣ ዬያ ማላያ ላምዓሳ ዓይሢፃ ‹ሜሌ'' ዓሲ ኔናጉዲ ማሂ ናሽኬ› ጋዓያኬ። ዬንሢ ላምዖ ዓይሢፆንሢዳፓ ሜሌ'' ባሻያ ባኣሴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ሙሴ ዔርዜ ዎጎ ዔርዛሢ ዬሱሴ ኮራ፦ «ሂዮ ፔኤሮ ኮሺኬ ዔርዛሢዮ! ‹ፆኦሲ ፔቴ''ኬ፤ ዒዛይዳፓ ዓቴም ሜሌ'' ፆኦሲ ባኣሴ› ኔኤኒ ጌዔሢ ጎኔኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ዬያሮ ዓሲ ጉቤ ዒናፓ፥ ጉቤ ሼምፓፓ፥ ጉቤ ማሊፃፓ፥ ጉቤ ዎልቃፓ ፆኦሲ ናሽካኒ ኮይሳኔ፤ ሓሣ ሜሌ'' ዓሲያ ፔና ማሂ ናሽካኒ ኮይሳኔ፤ ታሚና ሚቺ ፆኦሲም ዒንጎ ባኮ ዒንጊፆና ዬያ ጉዴያ ሜሌ'' ዒንጎ ካኣዦይዳፓ ዬንሢ ላምዖ ዓይሢፆንሢ ካፒፃ ባሻያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ዬይ ዎጎ ዔርዛሢ ዔራቶና ጶቂሢ ማሄሢ ዬሱሴ ዛጋዖ፦ «ኔኤኒ ፆኦሲኮ ካኣቱማፓ ሓኬያቱዋሴ» ጌዔኔ። ዬካፓ ዬሱሴ ኮራ ጫርቂ ዖኦጬ ዓሲ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ዬሱሴ ፆኦሲኮ ጌኤዦ ማኣሮይዳ ዔርዚቤቃ ሂዚ ጌዒ ዖኦጬኔ፦ «ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ‹ኪሪስቶሴ ዳውቴ ናይኬ› ዓይጎሮ ጋዓይ? ");
INSERT INTO mdybse_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳውቴ ፔ ቶኦኪና ዓያና ጌኤሺ ዒዛ ዒና'' ማሊሢ ጌሣዛ፦ ‹ፆኦሲ፥ ታ ጎዳሢም (ሜሲሔም) ኔኤኮ ሞርኮ ኔ ቢታንቶ ዴማ'' ታኣኒ ማሓንዳያ ሄላ''ንዳኣና ታኣኮ ሚዛቆ ዛላ'' ዴዔ› ጌዔኔ፤ ጌኤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«ዓካሪ ዳውቴ ፔ ቶኦኪና ‹ጎዳ› ጌዒ ዔኤሌቶ ሜሲሔ ዳውቴኮ ዎይቲ ናይ ማዓይ?» ዬያ ዒዚ ጋዓኣና ሚርጌ ዓሲ ዒዛሲ ዎዛና ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ዬሱሴ ዔርዚቤቃ ሂዚ ጌዔኔ፦ «ዖዶሲ ዓፒላ ማኣዒ ሴካ ሓንጋ ሓንቲሢና ሓሣ ቦኦኮ''ይዳ ኮሺ ዔኤሊ''ሢ ዔካኒ ናሽካ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶይዳፓ ካፒንቱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ዔያታ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳ ቦንቾ ዖይታ፥ ሙኡዚም ዔኤሎ'' ቤስካ ቦንቾ ቤሲ ዴንቂ ዴዓኒ ሩኡራኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ዓሲ ዛጎም ጌዒ ዖዶሲ ሺኢቆ ሺኢጲሢና ዓኒንሢባኣ ላኣሎኮ ማኣሮ ጌሺ ጌሺ ማንቂሳኔ፤ ዬያሮ ዔያቶይዳ ዴኤሢ ዎጌ ዎጊንታንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ፆኦሲም ጌዒ ዓሳ ሚኢሾ ዒንጋ ሳኣፂኖኮ ዬሱሴ ቤርቶ ዛላ'' ዴዒ ዓኣዖ ዴራ'' ሳኣፂኖ ጋራ ሚኢሾ ዓጋንቴ ዛጌኔ፤ ዒማ''ና ዖርጎጮ ዓሳ ሚርጌ ሚኢሼ ዓጋዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ፔቴ'' ዜኤሪንዶስኬና ሙካዖ ዬኖ ዎዶ'' ሚኢሾና ላምዖ ሲኪና ማዓ ኮሺ'' ዻካ'' ሚኢሼ ዓጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ዬሱሴ ፔኤኮ ጊንፆ ሓንታ ናኣቶ'' ዔኤላ''ዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ሳኣፂኖይዳ ሚኢሾ ዓጌ ዓሶይዳፓ ባሼ ዓጌዛ ሓኖ ዓኒ ሃይቄ፥ ማንቆ ላኣሌሎኬ ጌዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ዓይጎሮ ጌዔቶ ሜሌ'' ዓሳ ቢያ ዒንጌሢ ዓኣ ቆሎ''ይዳፓ ዺቢ ዑሣ ዓኣዼሢኬ፤ ዒዛ ጋዓንቴ ማንቆታዖ ፔኤኮ ዓኣማ ዓይሱዋዖ ዓጌኔ፤ ፔና ዎይሣንዳ ባኮንሢ ቢያ ዒንጌኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ዬሱሴ ጌኤዦ ማኣራፓ ኬስካንቴ ዒዛኮ ጊንፆ ሓንታዞንሢዳፓ ፔቴ''ስኬይ፦ «ዔርዛሢዮ! ሓያ ማኣሮ ማዦሮ ጊኢጊሾና ሹጮና ማዢንቴ ማኣራ ዎዚጉዲ ኮሽካቴያ ሂንዳ ዛጌ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ዬሱሴ ማሓዖ፦ «ሓያ ዼኤፖ ማኣሮ፥ ሹጮና ማዦናሢ ኔኤኒ ዛጋ? ሃይ ማኣራ ዶዓንዳኔ፤ ሹቺ ሹቺዳ ሃኣዒዲ ኬልቂንቲ ፔቴ''ታዖ ዓታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ዬሱሴ ጌኤዦ ማኣሮኮ ቤርቶ ዛሎ''ና ሪሚቲ ዹካ ጎዖ ዹኮ''ይዳ ኬስኪ ዴዒ ዓኣንቴ ጴፂሮሴ፥ ያይቆኦቤ፥ ዮሓኒሴንታ ዒንዲራሴንታ ሌሊ ዒዛ ኮራ ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ዬይ ኔኤኒ ጌዔ ባካ ማዓንዳሢ ዓይዲዳይ? ዬይ ቢያ ማዓኒ ዑካኣና ዔርታሢ ዓይጎናዳይ? ሂንዳ ኑም ኬኤዜ» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ዬሱሴ ዔያቶም ማሓዖ፦ «ዖኦኒያ ዒንሢ ዻቢሱዋጉዲ ዒንሢና ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ሚርጌሢ፦ ‹ታኣኒ ሜሲሔኬ› ጌዒ ጌዒ ታ ሱ'ንፆና ሙኪ ሚርጌ ዓሲ ዻቢሳንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ዒንሢኮ ዑኬ ዖልዚ ዔቄቶዋ ሓሣ ሓኬ ቤስካ ዓኣ ዖልዚ ሓይሴ ዋይዛዖ ዲቃቲፖቴ፤ ዬይ ማዑዋዖ ዓታዓኬ፤ ጋዓንቴ ጋፒንፃ ሃጊኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ፔቴ'' ዜርፃ ሜሌ'' ዜርፆይዳ፥ ካኣታ'' ካኣቶ''ይዳ ዖልዚ ዔቂሳንዳኔ፤ ዱማ ዱማ ቤስካ ሳዓ ዓጊፂሢና ናይዚና ማዓንዳኔ፤ ዬይ ቢያ ሾይቺ ዓርቂሢ ቆፂ'' ሜታሳሢጉዲ ሜቶ''ኮ ቢያ ቤርቶኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«ዒንሢያ ዒንሢ ዛሎ'' ኮሺ'' ዔሩዋቴ፤ ዓይጎሮ ጌዔቶ ዓሳ ዒንሢ ዎጌም ዓኣሢ ዒንጋንዳኔ፤ ዓይሁዴ ዓሶኮ ቡኪንቶ ቤዞይዳ ጳርቂንቲ ታኣኮ ዒንሢ ማርካ ማዓንዳጉዲ ታ ዛሎ''ና ዎይሣ ዓሶና ካኣቶ''ና ቤርታ ዒንሢ ዎጌም ሺኢካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ጋፒንፃ ሙካንዳሢኮ ቤርታ ጋዓንቴ ኮዦ ሓይሳ ዱማ ዱማ ዜርፆም ቢያ ሄላ''ኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ዓሳ ዒንሢ ዓርቂ ዎጌም ሺኢሻኣና ‹ኑኡኒ ዓይጎ ኬኤዛንዳ ናንዳይ?› ጌዒ ቤርታዺ ሜታዺፖቴ፤ ዒንሢ ሺኢኬ ዎዶ''ና ዒንሢኮ ዒና'' ሙኬሢ ኬኤዙዋቴ፤ ዓይጎሮ ጌዔቶ ዒማ''ና ኬኤዛሢ ዓያና ጌኤሺ ማዓንዳፓ ዓቴም ዒንሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ጌርሲ ፔኤኮ ጌርሲ፥ ዓዴ ፔኤኮ ናዖ ሓይቢም ዓኣሢ ዒንጋንዳኔ፤ ናኣታ'' ሾዔ ዓሶ ዒፂ ዓኣሢ ዒንጊሢና ዎዺሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ታ ዛሎሮ ዒንሢ ዓሲና ቢያ ዒፂንቴያ ማዓንዳኔ፤ ጋፒንፆ ሄላ''ንዳኣና ጊቢ'' ዶዳሢ ጋዓንቴ ዻቃንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ሓሣ ዓሲ ዒኢሳ ፑርታ ባኣዚ''ና ሻኣካ'' ባኣዚ'' ጴዻኒ ኮይሱዋ ቤስካ ማዺንታንቴ ዒንሢ ዛጋንዳኔ፤ ዬያ ናባባሢ ዒና ዔኮንጎ፤ ዬኖ ዎዶ''ና ዪሁዳ ዓጮ''ይዳ ዓኣ ዓሳ ቢያ ዹኮ'' ባንሢ ቤቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ሹጮና ማዦና ማኣሮኮ ዑፆይዳ ዓኣ ዓሲ ኬኤፃፓ ኬዲ'' ፔቴ'' ባኣዚ'' ዔካንዳኔ ጌዒ ኔጎፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ጎሺዳ ዓኣዺ ዓኣ ዓሲ ዓፒሎ ፔኤኮ ዔካኒ ጊንሣ ማዖፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ዬኖ ዎዶ''ና ጎጶይንዳሢና ናኣቶ'' ዓኣሎ'' ዒንዶንሢናም ባዴዔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ዬይ ቢያ ባርጊ ዎዴና ማዑዋጉዲ ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ዬኖ ዎዶ''ና ፆኦሲ ሳዖ ማዤማፓ ዓርቃዖ ሙኪ ዬኖ ኬሎ'' ሄላ''ንዳኣና ዛጊቤቂቦ ሜቶና ዋኣዮና ማዓንዳኔ፤ ሴካ ቤርቲም ማዔቶዋ ዬያጉዴ ሜቶና ዋኣዮና ማሊ ሄላ''ዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ፆኦሲ ዬያ ኬሎ''ኮ ፓይዶ'' ዻኪሲባኣያታቴ ዻቃኒ ዖኦኒያ ዳንዳዒንዱዋንቴኬ፤ ጋዓንቴ ዶኦሪንቴዞንሢሮ ጌዒ ዬይ ኬላ'' ቢያ ቃሚቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«ዬያሮ ዖና ማዔቶዋ ‹ሜሲሔ ሓይሾ ሓካኬ›፤ ‹ዬይሾ ያሶኬ› ጌዔቶ ጉሙርቂፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ዎይቴይ ጌዔቶ ሉኡዚ ሜሲሔንሢና ሉኡዚ ፆኦሲ ማሊሢ ኬኤዛያ ማላ ዓሲ ሙካንዳኔ፤ ዔያቶም ዳንዳዒንቴቶ ፆኦሲኮ ዔርቲ ጉሙርቂንታ ዓሶታዖ ዻቢሳኒ ዓኪ ዲቃሣ ባኣዚ''ና ማላታና ዔያታ ማዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ዒንሢና ኮሺ'' ዔሩዋቴ! ሃያ ባኮ ቢያ ዬይ ዎዳ'' ሄላ''ንዳሢኮ ቤርታሲ ታ ዒንሢም ኬኤዛኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ዬኖ ዎዶ''ና ዬያ ሜቶ''ኮ ቢያ ጊንፃ ዓባ'' ዹማንዳኔ፥ ዓጊናኣ ፖዒንዱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ዦኦጋሢያ ጫሪንጫፓ ኬዳ''ዛ ጫሪንጮይዳ ዎልቄና ዓኣ ባካ ቢያ ዓጊፃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ዬካፓ ዓሲኮ ናዓሢ ዼኤፒ ዎልቄና ቦንቺንቲ ሻኣሬና ሙኪ ጴዻንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ፔኤኮ ኪኢታንቾ ዒዚ ዳካዛ ዔያታ ዖይዶ ዛሎ'' ቢያ ዴንዲ ዓጮ''ኮ ጋፓፓ ጫሪንጮ ጋፖ ሄላ''ንዳኣና ዓኣ ዒዛኮ ዶኦሪንቴዞንሢ ቡኩሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ዬሱሴ ኬኤዛዖ፦ «ቤሌሶ ሚፄሎኮ ኮኦኪንሣ ዒንሢም ዔርዛያ ማዓንዳጉዲ፤ ዒዞኮ ካኣፓ ፂሊ፥ ዒላሺ ኬሳ'' ዎዶ''ና ዖጎሢ ዑኬሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ዬያጉዲ ዒንሢያ ዬይ ባካ ቢያ ማዓዛ ዛጋዖ ዓሲኮ ናዓሢ ሙካ ዎዳ'' ዑኬሢና ሙኪ ካራ'' ዓኣሢ ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ጎኔ ታኣኒ ዒንሢም ጋዓኔ፤ ሓይ ሾይንታ ዓኣዻንዳሢኮ ቤርታ ዬይ ቢያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ጫሪንጮና ሳዖና ዓኣዻንዳኔ፤ ታኣኮ ቃኣላ'' ጋዓንቴ ናንጊና ዶዲ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ዬሱሴ ሃሣ፦ «ጋዓንቴ ዬኖ ኬሌሎና ዎዴሎና ዛላ ዓዳሢፓ ዓቴም ዖኦኒያ ዔራያ ባኣሴ፤ ጫሪንጮይዳ ዓኣ ኪኢታንቾታቶዋ ሓሣ ናዓሢያ ዔሩዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ዬና ዎዳ'' ዓይዲ ሙካንዳቴያ ዒንሢ ዔሩዋኣሢሮ ኮሺ'' ዶዱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ዬና ዎዳ'' ማኣሮ ፔኤኮ ሃሺ'' ሓኬ ዓጪ ዓኣዼ ዓሲስኬያ ማላኔ፤ ዒዚ ፔቴ'' ፔቴ'' ዒዛም ማዻ ዓሶም ዱማ ዱማ ማዾ ዒንጋዖ ካፓ ዓሢም ኮሺ'' ዶዲ ካፓንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ዬያሮ ማኣሮኮ ዓዳሢ ሙካንዳ ዎዶ'' ዒንሢ ዔሩዋያታሢሮ ዒንሢና ኮሺ'' ዔሩዋቴ፤ ጎዖንቴ ዒዚ ሴካ ዒባኒ፥ ዓቴቶ ሳዖኮ ጊዲሚሺ፥ ማዒባኣቶ ኮይዳ ቂኢቃኣና፥ ዔይዔ ጌዔቶ ጉቴ'' ዹቡርታ ሙካንዳኣናንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ዔሩዋዖ ዒንሢ ጊንዒ ዓኣንቴ ዒዚ ሙኪ ዒንሢ ዴንቁዋጉዲ ዶዱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","«ዒንሢም ታኣኒ ኬኤዛሢጉዲ ሓንጎ ዓሶማኣ ዶዱዋቴ ታ ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ዓይሁዴ ዓሳ ዑሣ ዓኣዺፆንታ ላኣዳ ሙዒ ቦንቾ ኬሎ''ንታ ማሊ ቦንቻኒ ላምዖ ዓቢ ዓታዛ ቄኤሶኮ ሱኡጎና ዎጎ ኮሺ'' ዔራ ዓሳ ጌኔ ማሊሢና ዬሱሴ ዓርቂ ዎዾንዶ ጎይሢ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ጋዓንቴ ዴራ'' ዑራ ዔቂሳንዳኔ ጌዒ፦ «ኑኡኒ ቦንቾ ኬሎ''ና ዬያ ማዻዓ» ዔያታ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ዬሱሴ ቢታኒያ ጎዖ ጉርዶይዳ ዑፃ ኬስካ ፑርቶ ዶርዓሢና ዓርቂንቴዖ ፖዔ፥ ሲሞኦኔ ጎዖሢ ማኣራ ዓኣዖ ካሣ ሙዓኒ ጊኢጊ ዴዒ ዓኣንቴ ፔቴ'' ላኣሊስኬና ሹቺ ቢልቃፄይዳ ናርዶሴ ጎዖያ ቦንቺንቴያ ሓሣ ሻንቾዛ ሚርጌ ሚኢሼ ዔካ፥ ሳውቃያ ዋኣሢ ማዔ ቲሺ ኩንሢ ዔኪ ሙካዖ ዬኖ ቢልቃፄሎ ዎዺ ሳውቃ ቲዤሎ ዬሱሴኮ ቶኦካ'' ዋሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ዬያ ዒዛ ማዻኣና ዒኢካ ዓኣ ዓሶይዳፓ ፔቴ'' ፔቴ'' ዓሳ ጎሪ''ንታዖ፦ «ሓይ ሳውቃ ቲዣ ጉሪ ዓታሢ ዓይጎሮዳይ? ");
INSERT INTO mdybse_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ሓያ ሳውቃ ቲዦ ፔቴ'' ዓሲ ፔቴ'' ሌዔ ማዾ ማዼም ዒንጎንዶ ሚኢሼይዳፓ ዑሣ ሻንቺ ዔኤቢ ባኣ፥ ዓሶ ማንቆም ዒንጎናቴ ዓይጌ ዓኣይ?» ጌዒ ላኣሌሎዋ ዔያታ ፓሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ዬሱሴ ማሓዖ፦ «ሓሹ''ዋቴ፤ ዒዞ ዒንሢ ዓይጎሮ ሜታሳይ? ዒዛ ታኣም ኮሺ ባኣዚ'' ማዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ማንቆ ዓሳ ቢያ ኬሊ'' ዒንሢና ዎላ'' ዓኣሢሮ ኮዔ ዎዴና ዔያቶ ዒንሢ ማኣዳ''ኒ ዳዳንዳዓኔ፤ ጋዓንቴ ታኣኒ ቢያ ኬሊ'' ዒንሢና ዎላ'' ሓይካቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ሓና ላኣሌላ ፔኤም ዳንዳዒንቴሢ ጉዴያ ማዼኔ፤ ዓሽካ ታኣኮ ዱኡኪንቱዋንቴ ቤርታሲ ሳውቃ ቲሺና ዒዛ ታኣኮ ዑፆ ቲሽኪ ዱኡፖም ጊኢጊሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓጮ'' ቢያይዳ ሓይ ኮዦ ሓይሳ ኬኤዚንታ ዎዶ''ና ዓንካ ማዔቶዋ ሓይ ዒዛ ማዼ ባካ ዒዞ ጶቂሥሢ ማዒ ኬኤዚንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ታጶ ላምዓሢዳፓ ፔቴ'' ዓስቆሮንቶ ዪሁዳ ጎዖሢ ዬሱሴ ጌሺሢና ዓኣሢ ዒንጋኒ ቄኤሶኮ ሱኡጎ ኮራ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ዔያታ ዒዛኮ ጎዳ ሻንቾሮ ሙኪፆ ዔራዖ ኮሺ'' ዎዛዺ ሚኢሼ ዒዛም ዒንጋኒ ዎላ'' ጌስቲ ጊኢጌኔ። ዬካፓ ዒዚ ዬሱሴ ዓኣሢ ዒንጋኒ ዒዛም ጊኢጋንዳ ጎይሢ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ዬሱሴኮ ጊንፆ ሓንታዞንሢ ዓይሁዴ ዓሳ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ማራቶ ሹኪ ላኣዶዋ ሙዒ ቦንቻ ኬሎ''ኮ ዓይፆይዳ ዒዛ ኮራ ሙካዖ፦ «ዑሣ ዓኣዺፆ ኬሎ'' ማሊ ሙዎ ካዋሢ ሙዓኒ ዎካ ዓኣዺ ጊኢጊሻንዳጉዲ ኔኤኒ ኮዓይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ዒዚያ ዒዛኮ ጊንፆ ሓንታዞንሢዳፓ ላምዖንሢም ሂዚ ጌዒ ዳኬኔ፦ «ሴኬ ካታሞ ዴንዱዋቴ፤ ዒኢካ ዒንሢ ዋኣሢ ጉሲ ኬዴ ዓሲ ዴንቃንዳኔ፤ ዬያ ዓሢኮ ጊንፆ ዓኣዹዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ዒዚ ዴንዲ ጌላ ኬኤፆማ ጌሊጋፓ ማኣሮኮ ዓዳሢ ኮራ ‹ዔርዛሢ፡ ታኣኮ ጊንፆ ሓንታዞንሢና ዎላ'' ታኣኒ ዑሣ ዓኣዺፆ ኬሎ'' ሙዖ ሙዓንዳ ኬኤፃ ዎካዳይ?› ጋዓኔ፥ ጎዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ዒዚያ ኩቦ ጋራ ዓኣ ሂኢሢ ጊኢጊንቴ ዳልጎ ቤዞ ዒንሢም ዻውዋንዳኔ፤ ዒኢካ ኑም ጊኢጊሹዋቴ።» ");
INSERT INTO mdybse_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ላምዖ ጊንፆ ሓንታዞንሢ ኬስኪ ካታሞ ዴንዲ ዬሱሴ ጌዔማጉዲ ቤዞዋ ዴንቂ ዑሣ ዓኣዺፆ ኬሎ'' ካዋሢ ሙዓኒ ዒኢካ ጊኢጊሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ሳዓ ዓማዛ ዬሱሴ ታጶ ላምዖንሢና ዎላ'' ሙኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ካሦ ሺኢሺ ዔያታ ሙዓኣና ዬሱሴ፦ «ጎኔ ታኣኒ ዒንሢም ጋዓኔ፤ ሓሢ ታኣና ዎላ'' ካሦ ሙዓያ ዒንሢዳፓ ፔቴ''ይ፥ ታና ዓኣሢ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ዔያታ ዬኖ ጌኤዞና ዖያዖ፦ «ጎኔ ታናቱዋሴ፤ ኔ ታናኬ ጋዓ?» ጌዒ ጌዒ ፔቴ'' ፔቴ''ሢ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ዬሱሴ ማሓዖ፦ «ዬይ ዓሢ ሓሢ ታኣና ዎላ'' ሃኖ ጎንጋ ኩጮ ዳካያ፥ ዒንሢ ታጶ ላምዓሢዳፓ ፔቴ''ሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ዓሲኮ ናዓሢ ቤርታዺ ዒዛ ዛሎ'' ፃኣፒንቴ ጎይፆና ሓይቂሢ ዓታዓኬ፤ ጋዓንቴ ዓሲኮ ናዓሢ ጌሺሢና ዓኣሢ ዒንጋ ዬያ ዓሢም ባዴዔ፤ ዬይ ዓሢ ቤርታዺ ሾይንቲባኣቴ ቃራታዖኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ዔያታ ሙዖይዳ ዓኣንቴ ዬሱሴ ካሣ ዔካዖ ጋላቲ ቡንፂጋፓ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ም፦ «ሓኣዛጉዋቴ፥ ሓይ ታናኬ» ጌዒ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ሓሣ ዑሽኮ ባኮዋ ዔካዖ ጋላቲ ዔያቶም ዒንጌኔ፤ ቢያሢ ዑሽኮ ባኮይዳፓ ዑሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ዒማ''ና ዒዚ ዔያቶም፦ «ሓይ ታኣኮ ሚርጌ ዓሶም ላኣሊንታንዳ ጫኣቁሞ ሱጉፆኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ጎኔ ታ ዒንሢም ጋዓኔ፤ ፆኦሲ ካኣቱሞይዳ ዓኮ ታኣኒ ዑሽካንዳያ ሄላ''ንዳኣና ሓኖ ዎይኖ ዑዦ ላሚ ታኣኒ ዑሽካዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ዬካፓ ዔያታ ፆኦሲ ቦንቾም ማዓ ዓይኑሞ ዓይናዻዖ ሪሚቲ ዹካ ዓኣዻኒ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ዬሱሴ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ም፦ « ‹ሄንቃሢ ታኣኒ ዎዻንዳኔ፤ ማራታኣ ዣኣላንዳኔ› ጌይንቲ ፃኣፒንቴሢጉዲ ታ ዒንሢኮ ዹቆ ማዔም ዒንሢ ቢያ ታና ሓሻ''ንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ጋዓንቴ ሓይባ''ፓ ታኣኒ ዔቄስካፓ ጌሊላ ጎዖ ዓጮ'' ቢሪ ታ ዒንሢ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ጴፂሮሴ፦ «ሜሌ'' ዓሳ ኔ ዛሎ''ና ዹቂንቴታቶዋ ታኣኒ ማሊ ዹቂንታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ዬሱሴ፦ «ታኣኒ ኔኤም ጎኔ ጋዓኔ፤ ሓኖ'' ዒባኒ ኮይዳ ላሚ ቂኢቁዋንቴ ኔኤኒ ታና ሓይሢ ማይንቲ ‹ታ ዒዛ ዔሩዋሴ› ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ጴፂሮሴ ጋዓንቴ፦ «ሓይቂ ሓይቆቴያ ታኣኒ ኔኤና ሓይቃንዳኣፓዓቴም ማሊ ‹ታ ኔና ዔሩዋሴ› ጋዓዓኬ» ጌዒ ጌዒ ዶዲሺ ኬኤዛኣና ሓንጎ ዓቴ'' ጊንፆ ሓንታዞንሢያ ያዒ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ዬማፓ ጌኤቴሴማኔ ጎዖያ፥ ቱኮ''ና ሚሢ ሚርጌ ዓኣ ቤሲ ዔያታ ዓኣዻዖ ዬሱሴ ፔኤኮ ጊንፆ ሓንታ ናኣቶ''ም፦ «ታኣኒ ሺኢቃኣና ዒንሢ ሃካ ዴዑዋቴ» ጌዔስካፓ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ዒዛና ዎላ'' ጴፂሮሴንታ ያይቆኦቤንታ ሓሣ ዮሓኒሴንታ ዔኪ ዓኣዻዖ ዒኢካ ዒዚ ኮሺ'' ማሊ ዖዪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ዔያቶ ኮራ ዒዚ፦ «ሼምፓሢ ታኣኮ ሚርጌ ዖዪ ሓይቃኒ ዑኬኔ፤ ዒንሢ ሓይማካ ዴዒ ዶዲ ካፑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ዒዚ ዔያቶይዳፓ ዻካ'' ሓኪ ዓኣዻዖ ባሊቶና ሳዓ ሎኦሚ ዳንዳዒንታያ ማዔቶ ዬና ፑርቶ ሜቶ ዎዴላ ዒዛ ሄሉ''ዋጉዲ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ሂዚ ጌዒ ሺኢቄኔ፦ «ዓዳሢዮ! ቢያ ባኣዚ'' ኔኤም ዳንዳዒንታያታሢሮ ሃኖ'' ታኣኒ ዔካኒ ጊኢጌ ሜቶ'' ታጊዳፓ ሓኪሴ፤ ጋዓንቴ ኔ ማሊፆጉዲ ማዓንዳኣፓዓቴም ታ ማሊፆጉዲ ማዖፓ።» ");
INSERT INTO mdybse_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ዬካፓ ሓይሦ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ ማዒ ሙካዖ ዔያታ ጊንዒ ዓኣንቴ ዴንቂ ጴፂሮሴ ኮራ፦ «ሲሞኦኔ! ኔኤኒ ጊንዒዳ? ዻካ'' ዎዴታዖ ጴጪ ዶዲ ዴዓኒ ኔኤኒ ዳንዳዒባኣዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ሄሊ''ሳዖ ቢያሢም፦ «ዒንሢ ዻቢሳኒ ጌሾ ባኣዚ''ዳ ዒንሢ ጌሉዋጉዲ ጴጪ ሺኢቁዋቴ፤ ዓሲኮ ዓያና ጊኢጌያኬ፤ ጋዓንቴ ዓሽኪ ላቤያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ሓሣ ጊንሣ ዓኣዺ ቤርታ ዒዚ ሺኢቄሢ ጎይፆ ላሚ ዒማ ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ዬካፓ ዒዚ ማዒ ሙካንቴ ጊንዓሢ ዔያቶ ሚርጌና ባሼሢሮ ጊንዒ ዓኣንቴ ዴንቄኔ፤ ዔያታ ዒዛም ማሂ ኬኤዛኒያ ዳንዳዓባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ሓይሣሲ ዔያቶ ኮራ ማዒ ሙካዖ ሂዚ ጌዔኔ፦ «ሓሢ ሄላ''ንዳኣና ዒንሢ ላሂ ሓውሺሢዳዳ? ማይ ዓካሪ ጊዴኔ፤ ዎዳ''ኣ ሄሌ''ኔ፤ ሓይሾ ዓሲኮ ናዓሢ ጎሞ ዓሶ ኩጫ ጌሺሢና ዓኣሢ ዒንጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ሂዮ ማይ ዔቁዋቴ ኑኡኒ ዓኣዾም! ታና ጌሺሢና ዓኣሢ ዒንጋሢ ሓይሾ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ዬሱሴ ሂዚ ጌዒ ኬኤዛ ጎይሣ ዓኣንቴ ዒዛኮ ጊንፆ ሓንታ ታጶ ላምዓሢዳፓ ፔቴ'' ዪሁዳ ጎዖሢ ሙኬኔ፤ ዒዛና ዎላ'' ዓፓሮና ኮኦሎ''ና ዓርቄ ሚርጌ ዓሲ ዓኣኔ፤ ዬያታ ዳኪንቴሢ ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶንታ ጪሞንታይዳፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ጌሺፆና ዓኣሢ ዒንጋ ዪሁዳ ዓሶም፦ «ዒንሢ ዓርቃንዳሢ ዎያዳይ ጌዔቶ ‹ኮሺዳ?› ጌዒ ታኣኒ ሄርቃንዳሢኬ፤ ዒዛ ዛጊ ዓርቂ ዔኪ ዓኣዹዋቴ» ጌዒ ዔያታ ዔራንዳጉዲ ቤርታዺ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ዪሁዳ ሙሙካዖ ዬሱሴ ኮራ ዶጪ፦ «ዔርዛሢዮ!» ጌዒ ሄርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ዬማፓ ዓሳ ዬሱሴ ቶሊ''ንዱዋ ጎይሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ዬማና ዒኢካ ዔቂ ዓኣ ዬሱሴኮ ጊንፆ ሓንታዞንሢዳፓ ፔቴ''ስኬይ ጬንቻ ቱጊ ቄኤሶ ሱኡጋሢ ዓይላ''ሢኮ ዋዮ ቆፂ'' ቲቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ዬሱሴያ ዔያቶም ሂዚ ጌዔኔ፦ «ጬንቻና ኮኦሎ''ና ዒንሢ ዔኪ ሙኬሢ ሱላጉዲ ታና ዓርቃኒዳ? ");
INSERT INTO mdybse_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ቢያ ኬሊ'' ጌኤዦ ማኣሮይዳ ታኣኒ ዔርዚ ዔርዚ ናንጋኣና ዒንሢ ታና ዓርቂባኣሴ፤ ጋዓንቴ ሓይ ማዔሢ ፃኣፒንቴሢ ኩማንዳጉዲኬ።» ");
INSERT INTO mdybse_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ዬማፓ ዒዛኮ ጊንፆ ሓንታ ናኣታ'' ቢያ ዒዛ ሃሺ'' ፑኒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ዒማ''ና ሜሌ'' ባኣዚ'' ዑፃ ባኣያ ፓሎ ዓፒላ ማኣዔ ዼጌስኬይ ሌሊ ዬሱሴኮ ጊንፆ ጊንፆ ዓኣዻንቴ ዓሳ ዬያ ዼጌሢ ዓርቃዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ዬኖ ፓሎ ዓፒሌሎ ኬኤሪ፥ ዑሢ ጉሪ ጳሽኪ ቶሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ዬሱሴ ዔያታ ቄኤሶኮ ቢያ ዑፃሢ ማኣሪ ዔኪ ዓኣዼኔ፤ ዒኢካ ቄኤሶኮ ሱኡጎና ጪሞና ሓሣ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ቢያ ቡኪንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴፂሮሴያ ቄኤሶኮ ቢያ ዑፃሢ ዲሮ ጋሮ ሄላ''ንዳኣና ሓኬ ሓኬ ዬሱሴኮ ጊንፆ ዓኣዻዖ ዒኢካ ዲሮ ጋሮ ካፓ ዓሶና ዎላ'' ዴዒ ታሚ ካሽታኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ቄኤሶኮ ሱኡጎና ዓይሁዶኮ ቡኪንቶ ቢታ'' ቢያ ዬሱሴ ሓይቃንዳጉዲ ዎጊሳንዳ ማርካ ኮዔኔ፤ ጋዓንቴ ዔያታ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ሚርጌሢ ሉኡቂ ማርካቴንቴ ዔያታ ኬኤዜ ጌኤዛ ፔቴ'' ማዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ፔቴ'' ፔቴ'' ዓሳ ዔቃዖ ሂዚ ጌዒ ሉኡቂ ማርካቴኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","« ‹ታኣኒ ሓያ ዓሲ ኩቻ ማዦና ጌኤዦ ማኣሮ ሻሂ፥ ሓይሦ ኬሊ''ዳ ሜሌ'' ዓሲ ኩቻ ማዢንቲባኣያ ማዣንዳኔ› ዒ ጋዓንቴ ኑኡኒ ዋይዜኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ያዒ ዔያታ ጌዔንቴያ ማርካታ ዔያቶኮ ዎላ'' ካኣሚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ቄኤሶኮ ቢያ ዑፃሢ ዔያቶ ባኣካ'' ዔቃዖ ዬሱሴ ኮራ፦ «ፔቴ'' ባኣዚ''ታዖ ማሂ ኔ ኬኤዙዋዓዳ? ሓይ ዓሳ ኔጊዳ ጋዓ ባካ ዓይጎዳዖ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ዬሱሴ ጋዓንቴ ዚቲ ጌዔያፓዓቴም ፔቴ'' ባኣዚ''ታዖ ማሂ ኬኤዚባኣያ ማዓዛ ቄኤሶኮ ቢያ ዑፃሢ ዬሱሴ ኮራ ላሚ፦ «ዓንጂንቴ ፆኦሲኮ ናኣዚ'' ሜሲሔ ኔናዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ዬሱሴያ ማሓዖ፦ «ሂዮ ታናኬ፤ ዓሲኮ ናዓሢ ዼኤፖ ፆኦሲኮ ሚዛቆ ዛላ'' ዴዒ ዓኣንቴ ሓሣ ጫሪንጮ ሻኣሮና ማዒ ሙካንቴ ዒንሢ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ዒማ''ና ቄኤሶኮ ቢያ ዑፃሢ ዻጋዺ ፔኤኮ ዓፒሎ ዳርዛዖ፦ «ሜሌ'' ማርካ ኑም ማይ ዓይጎ ኮይሳይ? ");
INSERT INTO mdybse_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ሓያ ዋይዙዋቴ፤ ፆኦሲ ዒዚ ጫሽካንቴ ዒንሢ ዋይዜኔ፤ ዓካሪ ሓይ ዒንሢም ዓይጎ ማላይ?» ጋዓዛ፥ ቢያሢ ፔቴ'' ዑኡሲና፦ «ሓይቢ ዒዛም ኮይሳኔ!» ጌዒ ዎጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ፔቴ'' ፔቴ'' ዓሳ ዒዛይዳ ጩቲ'' ጩቲ'' ዓኣፓ ዒዛኮ ዛጉዋጉዲ ቱርጫና ቱኪ''፦ «ሂንዳ ኔኤኒ ፆኦሲ ማሊሢ ኬኤዛያታቴ ኔና ዖኦኒ ዱሌ''ቶዋ ዔሬ» ጌዒ ጌዒ ዔያታ ዒዛ ኩቺ ሙሊ ዱሌ''ኔ። ሓንጎ ዲሮ ጋሮ ካፓ ዓሳ ሓሣ ዒዛ ባዒ ባዒ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴፂሮሴ ቄኤሶኮ ቢያ ዑፃሢ ማኣሮኮ ዾኦሌ'' ዲሮ ጋራ ዓኣንቴ ቄኤሶኮ ቢያ ዑፃሢም ዓይሢንቲ ማዻ ፔቴ'' ዉዱሮ ናይስኬና ሙካዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ጴፂሮሴ ዒኢካ ታሚ ካሽታንቴ ዴንቂ ኮሺ'' ዛጋዖ፦ «ኔኤኒያ ናዚሬቶ ዓሢ ዬሱሴና ዎላ'' ዓኣያቲ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ዒዚ ጋዓንቴ፦ «ታኣኒ ዔሩዋሴ፤ ኔኤኒ ጋዓ ባካ ታኣም ዔርቱዋሴ» ጌዔኔ። ዬማ ዒዚ ጌዒ ካሮ'' ባንሢ ኬኬስካኣና ኮይዳ ቂኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ዉዱሮ ናዔላ ጴፂሮሴ ዛጋዖ ዒኢካ ዔቂ ዓኣ ዓሶም፦ «ሓይያ ዔያቶ ባኣካ'' ዓኣያኬ» ጌዒ ላሚ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ዒዚ ጋዓንቴ ሓሣ ጊንሣ «ታ ዒዛ ዔሩዋሴ» ጌዔኔ። ዻካ'' ናጋጉዲ ጋዓዖ ዒኢካ ዔቂ ዓኣ ዓሳ ጴፂሮሴ ኮራ፦ «ኔኤኒ ጌሊላ ዓሲታሢሮ ጎኔ ኔ ዔያቶ ባኣካ'' ዓኣያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ዒዚ ጋዓንቴ፦ «ዒንሢ ዬያ ጋዓ ዓሢ ታኣኒ ዔሩዋሴ፤ ታና ባይዞም» ጌዒ ፔና ጋዳንቂ ጫኣቂሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ዬማፓ ኔጉዋዖ ኮይዳ ላሚሣ ቂኢቃዛ ጴፂሮሴም፦ «ኮይዳ ላሚ ቂኢቁዋንቴ ሓይሢ ማይንቲ ኔኤኒ ታና ‹ዔሩዋሴ› ጋዓንዳኔ» ጌዒ ዬሱሴ ኬኤዜ ቃኣላ'' ጶቃዛ ዒናፓ ዖዪ ዬኤኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ጉቴ'' ዎንፃ ቤዞና ቄኤሶኮ ሱኡጋ ጪሞንታ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶንታ ሓሣ ዓይሁዶኮ ቡኪንቶ ቤዞ ሱኡጎንታ ዎላ'' ካኣሚ ዞርቴስካፓ ዬሱሴ ዔያታ ቱኪ'' ዔኪ ጲላፆሴም ዓኣሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጲላፆሴ ዬሱሴ ኮራ፦ «ኔኤኒ ዓይሁዶኮ ካኣቲዳ?» ጌዒ ዖኦጬኔ። ዒዚ፦ «ኔኤኒ ጌዔሢ ጉዴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ቄኤሶኮ ሱኡጋ ጋዓንቴ «ሚርጌ ዻቦ ዓኣኔ» ጌዒ ፓይዲ ፓይዲ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ዬያሮ ጲላፆሴ፦ «ዋኣዒ ባኣዚ'' ዔያታ ኬኤዛቴያ ሂንዳ ኮሺ'' ዛጌ፤ ኔኤኒ ፔቴ''ታዖ ማሂ ኬኤዛ ባኣዚ'' ማሊ ባኣዓዳ?» ጌዒ ላሚ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ጲላፆሴ «ሃያጉዴ ዓሲ» ጌዒ ዲቃቲ ማላንዳያ ሄላ''ንዳኣና ዬሱሴ ሓሣ ፔቴ'' ባኣዚ'' ማሂ ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጲላፆሴ ሌዓ ሌዓ ዓይሁዶኮ ዑሣ ዓኣዺፆ ማሊ ቦንቾ ዎዶ''ና ዓሳ ቡሊ''ንቶንጎ ጌዒ ዖኦጬ ዓሲ ፔቴ'' ሌሊ ቱኡዞ ዓሶይዳፓ ቡላ''ያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ዒማ''ና ዑራ ዔቂሲ ዓሲ ዎዼ ዓሲና ዓይሢንቲ ዒፃ ዓሲ ቱኡሲ ማኣሪ ጌሌያ ዓኣኔ፤ ዬኖ ዓሶይዳፓ ፔቴ''ሢ ባርባኔ ጎዖስኬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ዓሳ ጲላፆሴ ኮራ ሙካዖ ዎንዴ ዔያቶኮ ሌዓ ዔርቴ ጎይፆ ቱኡዞ ዓሶም ማዺንታንዳጉዲ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ዒዚያ ዔያቶ ኮራ፦ «ዓይሁዶ ካኣቲ ታኣኒ ዒንሢም ቡላ''ንዳጉዲ ዒንሢ ኮዓ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ዬያ ዒ ጌዔሢ ቄኤሶኮ ሱኡጋ ዬሱሴ ዓኣሢ ዒንጌሢ ቂኢሩሞና ማዔሢ ዔራያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ቄኤሶኮ ሱኡጋ ጋዓንቴ ዓሳ ጲላፆሴ ኮራ፦ «ባርባኔ ኑም ቡሊ''ንቶንጎ፤ ዬሱሴ ቡሊ''ንቶፓ» ጋዓንዳጉዲ ዓሶ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጲላፆሴያ፦ «ሂዴቶ ሓያ ዓይሁዶ ካኣቲ ዒንሢ ጋዓሢ ታኣኒ ዎዶ''ንዶይ?» ጌዒ ዓሶ ላሚ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ዔያታ፦ «ዒዛ ሱሱፄ!» ጌዒ ጌዒ ጊንሣ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጲላፆሴ ዓሶ ኮራ፦ «ዒዚ ፑርቲሴ ባካ'' ዓይጎዳይ?» ጌዔኔ። ዔያታ ጋዓንቴ፦ «ዒዛ ሱፄ! ሱሱፄ!» ጌዒ ሃቺም ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጲላፆሴ ዓሶ ዎዛሳኒ ባርባኔ ቡላ''ዖ ዬሱሴ ዓሶና ጳርቂሲ ሱፃንዳጉዲ ዓኣሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ፖኦሊሳ ዬሱሴ ዔኪ ዓጮ'' ዎይሣ ጲላፆሴ ማኣሪ ዓኣዺ ማርሾ ጋሮ ጌልዛዖ ዓቴ'' ሜሌ'' ፖኦሊሶዋ ቢያ ዔኤሌ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ዒማ''ና ዲንኪ ዞቄ ዖዶሲ ዓፒላ ዔያታ ዒዛ ማይሲ ሓሣ ካኣቶ''ኮ ቶኦካ ዓጎያ ዓክሊሌ ጎዖ ባኮ ማሊሲ ዓንጊሢ ጉኡሪ ማሂ ቶኦካ'' ዓጊጋፓ፦ ");
INSERT INTO mdybse_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","«ዓይሁዶ ካኣቲዮ! ኮሺ ኔኤም ማዖንጎ» ጌዒ ጌዒ ቦሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ዎኦሺጉዴ ሚሢናኣ ቶኦካ'' ዒዛኮ ጳርቂ ጳርቂ ጩቺያ ዑፃ ዒዛኮ ጩቲ'' ጩቲ'' ሓሣ ዒዛኮ ቤርታ ጎኔ ጉምዓታያ ማሊ ጌሺሢ ጎምዓቶ ጉምዓቲ ጉምዓቲ ዚጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ዬያይዲ ዒዛ ዔያታ ቦሂ ሺሬስካፓ ዲንኮ ዞቄ ዓፒሎ ዒዛ ዑፃፓ ኬሲ'' ዒዛኮ ቤርታ ማኣዖ ዓፒሎ ማይሲ ሱፃኒ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ዔያታ ዓኣዻ ጎይሣ ዓኣዖ ቄሬና ጎዖ ዓጪ ዓሲ ማዔያ ዒስኪንዲሬና ሩፖሴ ጎዖስኬንሢኮ ዓዶ ሲሞኦኔ ጎዖሢ ካታሞኮ ዙላ''ፓ ካታሞ ጌላንቴ ካኣማዖ ዬሱሴ ሱፂንታንዳ ፑርቲሴ ዓሶ ሱፆ ሚፆ ዓሢ ዎልቄና ኬዲሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ዬካፓ ዬሱሴ ዔያታ «ቶኦኪ ሜጌሢ» ጌይንታ፥ ጎልጎታ ጎዖ ቤዞ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ዒኢካ ዒዚ ሄሌ''ስካፓ ፔቴ'' ካርቤ ጎዖ ጫንቺ ባኣዚ''ና ሲኢሪንቴ ዑሺ ዎይኔፓ ኮሾ''ናያ ዑሽካንዳጉዲ ዔያታ ዒንጋዛ ዒዚ ዑሽኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ዬካፓ ዔያታ ዒዛ ሱፃዖ ዓፒሎ ዒዛኮ ዱማሲ ዔራኒ ዓጎ ባኣዚ'' ዎሊም ዓጊ ፓቂንቲ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ዬሱሴ ዔያታ ሱፄ ዎዳ'' ጉቶኮ ሶኦፓ ዎዴ ማዓኣናኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ዬሱሴኮ ዻቢንቶ ዔርዛንዳጉዲ «ዓይሁዴ ካኣቲ» ጌይንቲ ፃኣፒንቴ ባኣዚ'' ፑርቲሴ ዓሶ ሱፆ ሚፆ ዑፃ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ዒማ''ና ላምዖ ሱላ ዬሱሴና ዎላ'' ዔኪ ሙኪ ፔቴ''ሢ ዬሱሴኮ ሚዛቆ ዛላ''፥ ፔቴ''ሢ ሻውሎ'' ዛላ'' ሱፄኔ።  ");
INSERT INTO mdybse_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ያዒ ማዒፆና «ዋይዞ ዒፃ ዓሶና ዎላ'' ፓይዲንቴኔ» ጌይንቲ ቤርታ ኬኤዞና ፆኦሲ ማሊፃ ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ኮይሌና ዓኣዻ ዓሳ ቶኦኮ'' ቦሂሢና ዓጊሢ ዓጊሢ፦ «ዓኣህ! ኔኤኒ ጌኤዦ ማኣሮ ሻሂ ሓይሦ ኬሊ''ዳ ማዣሦ! ");
INSERT INTO mdybse_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ሂንዳ ሓሢ ፑርቲሴ ዓሶ ሱፆ ሚፃፓ ኬዲ'' ኔና ዻቂሼ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ዬያጉዲ ሓሣ ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ዎሊ ኮራ፦ «ሜሌ'' ዓሶ ዒ ዻቂሼኔ፤ ፔና ጋዓንቴ ዻቂሻኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ዒዚ ጎኔ ሜሲሔ፥ ዒስራዔኤሌ ካኣቲታቶ ሂንዳ ሓሢ ዒዛ ሱፆና ሚፃፓ ኬዶ''ንጎ፤ ኑኡኒ ዛጊጋፓ ጉሙርቆም!» ሂዚ ጌዒ ጌዒ ዒዛ ቦሃኣና ዬኖ ጎይፆ ዒዛና ዎላ'' ሱፂንቴ ሱላ ማዔ ዓሳኣ ዒዛ ቦሂ ቦሂ ጫሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ዒማ''ና ሮኦሮኮ ዓባ'' ሳዛ ማዔማፓ ዓርቃዖ ዴንዲ ማሢ ዶንቦልሳ ዎዴ ሄላ''ንዳኣና ሳዓ ቢያ ዹሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ማሢ ዶንቦልሳ ዎዴ ማዓዛ ዬሱሴ፦ «ዔሎሄ! ዔሎሄ! ላማሳባቂታኒ!» ጌዒ ዼኤፒ ዑኡሲና ዒላቴኔ። ዬኖኮ ቡሊ''ፃ፦ «ፆኦሲዮ! ፆኦሲዮ! ኔኤኒ ታና ዓይጎሮ ሓሼ''ይ?» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ዒኢካ ዔቂ ዓኣ ዓሶይዳፓ ፔቴ'' ፔቴ'' ዓሳ ዒዛኮ ዒላቶ ዋይዛዖ፦ «ሓይሾ ዒዚ ዔኤሊያሴ ዔኤላ''ኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ዔያቶይዳፓ ፔቴ''ስኬይ ጳሽኪ ዴንዲ ዎይኔይዳፓ ኮሾ''ና ሶልኪ ኮሽኩዋ ዑሺዳ ዓፒላ ቱርጫጉዴ ባኣዚ'' ዓጊ ዎኦሺ ሚሢና ዬሱሴ ዑሽካንዳጉዲ ዒንጋዖ፦ «ጫክ ዔኤሊያሴ ሂንዳ ሙኪ ዒዛ ኬሣቴ ኑኡኒ ዛጎም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ዬካፓ ሓሣ ዬሱሴ ዼኤፒ ዑኡሲና ዒላቴኔ፤ ሼምፓሢያ ዒዛኮ ዱጴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ዒማ''ና ጌኤዦ ማኣሮኮ ጋሮይዳ ዱማሲሢ ማሂ ጎኦቢ ጌሦና ዓፒላ'' ሎፓ ሉ ሄላ''ንዳኣና ዳርዒ ላምዖ ፓቂንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ፑርቲሴ ዓሶ ሱፆ ሚፆኮ ቤርቶ ዛላ'' ዔቂ ዓኣ፥ ፔቴ'' ፖኦሊሶ ዓይሣስኬይ ዬሱሴ ዬያይዲ ዒላቲ ሓይቄሢ ዛጋዖ፦ «ሓይ ዓሢ ጎኔና ፆኦሲ ናይታዖኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ዒማ''ና ሓኬ ዔቂ ዛጋ ፔቴ'' ፔቴ'' ላኣሊ ዓኣኔ። ዬያቶይዳፓ ሜግዴላ ዓጮ'' ማይራማ፥ ዻኮ'' ያይቆኦቤና ዮሳ ጎዖዞንሢኮ ዒንዶ ማይራሞ ጌይንታዞንታ ሴሎሜ ጎዖዞንታ ቢያ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ዬሱሴ ጌሊላ ዓጮ''ይዳ ዓኣ ዎዶ''ና ዔያታ ዒዛኮ ጊንፆ ሓንታያ ሓሣ ዒዛ ማኣዳ''ያኬ። ዔያቶጉዴያ ዬሱሴና ዎላ'' ዬሩሳላሜ ሙኬ ሚርጌ ሜሌ'' ላኣሊ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ሳዓ ዓሜያታሢሮ ዓይሁዶኮ ሓውሾ ኬላ'' ዑኬም ዓሶኮ ጊኢጊንቲ ጊኢጊንቶያ ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ዒማ''ና ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጎይዳፓ ፔቴ'' ዮሴፔ ጌይንታያ ቦንቺንታ ዓሲ ዓርማቲያሴ ጎዖ ዓጪዳፓ ሙኬኔ። ዒዚያ ፆኦሲኮ ካኣቱሞ ዎዛና ካፓ ዓሲኬ። ዒዚ ዒጊጩዋዖ ጲላፆሴ ቤርቶ ሙኪ ዬሱሴኮ ሌዞ ዒንጋንዳጉዲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጲላፆሴያ፦ «ዎይቲ ዬያይዲ ዑኬና ዒ ሓይቄይ» ጌዒ ዲቃቲ ማላዖ ፖኦሊሶ ዓይሣሢ ፔ ባንሢ ዔኤሊ''፦ «ጎኔ ዒዚ ሓይቄንቴ ናጊያ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ዬሱሴኮ ሓይቂፆ ፖኦሊሶ ዓይሣሢ ኮራፓ ዋይዛዖ ዮሴፔ ሌዞ ዔካንዳጉዲ ዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዮሴፔ ዓኪ ኮይዚንታንዳ ዓፒላ ሻንቃዖ ዬሱሴኮ ሌዞ ፑርቲሴ ዓሶ ሱፆ ሚፃፓ ኬሢ ሱኡዲ፥ ሹጮ ዶዶ ጳሊ'' ቦኦኪ ኮሾ''ና ቆኦፖይዳ ዱኡኬስካፓ ዼኤፒ ሹቺ ኮላሲ ዱኡፖ ዔቶ ካሮ'' ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ሜግዴላ ዓጮ'' ማይራሞና ዮሳ ዒንዶ ማይራሞና ዬሱሴ ዓሳ ዎካ ዱኡኬቴያ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ዓይሁዶኮ ሓውሾ ኬላ'' ጋፔስካፓ ሜግዴላ ዓጮ'' ማይራማ፥ ያይቆኦቤ ዒንዳ ማይራማ፥ ሴሎሜንታ ዎላ'' ዬሱሴኮ ሌዞ ቲሽካኒ ሳውቃ ቲሺ ሻንቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ዉዴ ጉቴ'' ዓባ'' ፆፆርቃኣና ዱኡፖ ዔቶ ቤዞ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ዔያታ ዎሊ ኮራ፦ «ሹጫሢ ዱኡፖ ዔቶ ካራ''ፓ ዖኦኒ ኑም ኮላሲ ሺኢሻንዳይ?» ጌዒ ዎላ'' ጌስቲ ጌስቲ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ዔያቶ ዬያ ጌይሴሢ ዱኡፖ ዔቶ ካሮ'' ዎዾና ሹጫሢ ኮሺ'' ዼኤፒታሢሮኬ። ዬካፓ ዔያታ ዼ'ግ ጌዒ ዛጋዖ ሹጫሢ ኮላዺ ዓኣንቴ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ዱኡፖ ዔቶ ዔያታ ጌላዛ ቦኦሬ ዖዶሲ ዓፒላ ማኣዔ ዼጌ ሚዛቆ ዛላ'' ዴዒ ዓኣንቴ ዴንቃዖ ዲቃቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ዒዚ ጋዓንቴ ዔያቶም ሂዚ ጌዔኔ፦ «ዶዱዋቴ፥ ዲቃቲፖቴ፤ ዒንሢ ኮዓሢ ሱፂንቴ ናዚሬቶ ዬሱሴ ማዔሢ ታኣኒ ዔራኔ፤ ዒዚ ዔቄኔ፥ ሓይካ ባኣሴ፤ ዱኡኪንቴ ቤዞ ሓይሾ ሓኣዛጉዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ሓሢ ዓኣዺጋፓ ጴፂሮሴንታ ሓንጎ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ንታም ሓያኮ ቤርታ ዒዚ ዒንሢም ኬኤዜሢጉዲ ጌሊላ ዒንሢ ቢሪ ዓኣዻንዳኔ፤ ዒኢካ ዒዛ ዒንሢ ዛጋንዳኔ ጌዒ ኬኤዙዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ላኣሎንሢያ ዒጊቹሞና ጎጋይቂ ጎጋይቂ ዱኡፖ ዔታፓ ኬስኪ ጳሽኬኔ፤ ዔያታ ኮሺ'' ዒጊጬያታሢሮ ፔቴ''ታዖ ዖኦማኣ ኬኤዚባኣሴ።  ");
INSERT INTO mdybse_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ዬሱሴ ዉዴ ጉቴ'' ሓይባ''ፓ ዔቄስካፓ ቤርታዺ ላንካይ ፑርታ ዓያና ዒዚ ኬሴ'' ሜግዴላ ዓጮ'' ማይራሞም ጴዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ዒዛኣ ዴንዲ ዖዪሢና ዬኤፒናይዳ ዓኣ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ም ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ዒዛ ዔያቶም፦ «ዬሱሴ ሓይባ''ፓ ዔቂ ሓሢ ሳዛና ዓኣንቴ ታኣኒ ታ ዓኣፒና ዛጌኔ» ጌዒ ኬኤዛዛ፥ ዔያታ ጋዓንቴ ዒዞሲ ጎኔኬ ጌይ ጉሙርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ዬካፓ ሓሣ ላሚ ካታማፓ ዙሎ'' ዓኣዻያ ላምዖ ዒዛኮ ጊንፆ ሓንታስኬንሢም ዬሱሴ ዱማ ጎይሢና ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ዔያታ ሓሣ ዴንዲ ዓቴ'' ዬሱሴኮ ጊንፆ ሓንታ ናኣቶ''ም ኬኤዛዛ፥ ጊንፆ ሓንታ ናኣታ'' ጋዓንቴ ዬንሢሲያ ጉሙርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ዬካፓ ታጶ ፔቴ''ዞንሢ ካሣ ሺኢሺ ዴዒ ሙዓንቴ ዬሱሴ ዔያቶም ጴዻዖ ዔያቶኮ ጉሙርቂፆ ዓቲፆና ሓሣ «ዬሱሴ ሓይባ''ፓ ዔቂ ሳዛና ዓኣንቴ ኑኡኒ ኑ ዓኣፒና ዛጌኔ» ጌዒ ዔያቶም ኬኤዜ ዓሶኮ ሓይሶ ዔኪባኣሢሮ ዒና''ኣ ዔያቶኮ ዒፂ ዶዴሢሮ ዔያቶ ቦሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ሂዚያ ዔያቶም ጌዔኔ፦ «ዓጮ'' ቢያ ዴንዱዋቴ፤ ዓሶ ቢያሢም ሓያ ኮዦ ሓይሶ ዔርዙዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ጉሙርቂ ጎናሲ ፆኦሲ ዔኬሢና ዋኣሢና ማስቴሢ ዻቃንዳኔ፤ ፆኦሲ ጉሙርቂ ጎናሲ ዔኩዋኣሢ ጋዓንቴ ፑርታና ዎጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ታና ጉሙርቂ ጎናሲ ዔካዞንሢም ቢያ ሓንሢ ዲቃሣ ማዾ''ንሢ ማዻንዳ ቢታንቶ ዒንጊንታንዳኔ፤ ታ ሱ'ንፆና ፑርቶ ዓያኖ'' ዔያታ ኬሳ''ንዳኔ፤ ዓኪ ሙኡቺና ጌስታንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ሾኦዦ ዔያታ ኩቻ ዓርቄቶዋ ሓሣ ዓሲም ዶርዖ ማዒ ዎዻ ባኣዚ''ታዖ ዔያታ ዑሽኬቶ ዔያቶም ዶርዖ ማዓዓኬ፤ ኩጮ ዔያታ ሓርጊንቴ ዓሶ ዑፃ ጌሣዛ ሓርጊንቴ ዓሳ ዻቃንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ጎዳ ዬሱሴ ዬያ ቢያ ኬኤዜሢኮ ጊንፃፓ ጫሪንጮ ዓኣዺ ፆኦሲኮዋ ሚዛቆ ዛላ'' ዴዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ዬሱሴኮ ጊንፆ ሓንታ ናኣታ'' ቢያ ቤዛ ዓኣዺ ዓኣዺ ዔርዜኔ፤ ጎዳሢያ ዔያቶና ዎላ'' ማዼኔ። ዲቃሣ ማዾ ማዻንዳጉዲ ቢታንቶ ዔያቶም ዒንጊ ዔርዚፆዋ ዔያቶኮ ዒ ዶዲሼኔ።");
INSERT INTO mdybse_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ቦንቺንታ ቴዎፒሎሴ! ኑ ባኣካ'' ማዺንቴ ባኮ ዔርዛ ሃይሴ ሃያኮ ቤርታ ሚርጌ ዓሳ ፃኣፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ዬያ ኮዦ ሃይሶ ኑም ሄሊ''ሴዞንሢ፦ ቤርታፓ ዓርቃዖ ዔያታ ፔ ዓኣፒና ዛጌ ማርኮንሢና ኮዦ ሃይሶ ቃኣሎ'' ማዾ'' ማዼዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ዬያጉዲ ሃሣ ታኣኒ ዔቦኮ ዓይፃፓ ዓርቂ ቢያ ባኮ ኮሺ'' ዛጌሢኮ ጊንፃ ሓይሶ ዎሊ ሄሊ''ሲ ኔኤም ፃኣፓንዳጉዲ ኮሺ ማዒ ታኣም ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ዬያ ታ ማዼሢ፦ ኔኤኒ ዔሬ ዔራቶኮ ጎኑሞ ኮሺ'' ኔ ዔራንዳጉዲ ጌዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ሄሮዲሴ ጎዖሢ ዪሁዳ ዓጮ''ይዳ ካኣታዼ ዎዶ''ና ቄኤሳሢ ዓቢያ ዓሶፓ ማዔ፥ ዛካሪያሴ ጌይንታ ቄኤሴ ዓኣኔ፤ ዒዛኮ ማቻ ዓኣሮኔ ዜርፃፓ ሾይንቴያ ዔልሳቤፆ ጎዖስኬኖኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ዔያታ ላምዓሢ ፆኦሲ ዎዛሳ ናንጊ ናንጋ ዓሲኬ፤ ጎዳኮዋ ዓይሢፆና ዎጎና ቦሂሳ ባኣዚ'' ባኣያና ካፓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ዔልሳቤፃ ዞኦኮታሢሮ ናይ ዔያቶኮ ባኣሴ፤ ሃሣ ላምዖንሢያ ሚርጌና ጋርቼያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ፔቴ'' ኬሊ'' ዛካሪያሴ ጌኤዦ ማኣሮይዳ ማዾ'' ማዻኒ ዒዛ ኬሎ'' ማዓዛ፥ ዒዚ ፆኦሲም ቄኤሴ ማዒ ማዾ'' ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ቄኤሶ ማዾ'' ዎጎ ጎይፆና ፆኦሲኮ ጌኤዦ ማኣሮ ጌሊ ዑንጆ ጩቢሲ ካኣሽኮ ካኣዦ ካኣሽካንዳጉዲ ዒፃሢ ዒዛ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ዒዚ ጌኤዦ ማኣሮ ጋሮይዳ ዑንጆ ጩቢሳኣና ዴራ'' ቢያ ዙላ'' ዔቂ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ዒማ''ና ፆኦሲኮ ኪኢታንቻሢ ዑንጆ ጩቢሶ ቤዞኮ ሚዛቆ ዛላ'' ዔቂ ዛካሪያሴም ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዛካሪያሴያ ኪኢታንቻሢ ዴንቃዖ ዲቃቲ ሚርጌና ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ኪኢታንቻሢ ጋዓንቴ፦ «ዛካሪያሴ! ዒጊጪፖ፥ ኔኤኮ ሺኢጲፃ ዋይዚንቴኔ፥ ኔኤኮ ማቻ ዔልሳቤፃ ዓቲንቄ ናይ ኔኤም ሾዓንዳኔ፤ ሱንፆዋ ዒዛኮ ኔ ዮሓኒሴ ጌዒ ጌሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ዒዛኮ ሾይንታ ኔኤም ኮሹሞና ዎዛና ማዓንዳኔ፤ ሚርጌሢያ ዒዛኮ ሾይንቶና ዬያጉዲ ዎዛዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ዒዚ ፆኦሲ ቤርታ ዼኤፒ ማዓንዳኔ፤ ሃሣ ዳጋሢና ሜሌ'' ማሣ ዑሺያ ዑሽካዓኬ፤ ሃጊ ዒዚ ዒንዶ ጎጳ ዓኣዖ ዓያኖ ጌኤዦ ዎልቆ ጋሮ ጌላንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ዒዚያ ዒስራዔኤሌ ዴሮ''ይዳፓ ሚርጌሢ ፆኦሲ፥ ዔያቶኮ ጎዳሢ ባንሢ ማሃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ዒዚ ጎዳኮ ቤርታ ሙኪ ዓያና ዎልቄና ፆኦሲ ማሊፆ ኬኤዛ ዔኤሊያሴጉዲ ማዒ ዴሮ'' ጎዳም ጊኢጊሻንዳኔ፤ ዒዚ ዓዶንሢና ናኣቶ''ናኮ ዒኖ'' ፔቴ'' ማሃንዳኔ፤ ዓይሢንቱዋ ዓሶኮዋ ዒኖ'' ፆኦሲ ዎዛሳ ናንጊ ናንጋ ዓሶ ባንሢ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዛካሪያሴ ጋዓንቴ ኪኢታንቻሢ ኮራ፦ «ዬይ ባካ ጎኔ ማዓንዳሢ ዓይጎና ታ ዔራንዳይ? ታኣኒ ጋርቼኔ፤ ሃሣ ታ ማቾኮዋ ሌዓ ኮሺ'' ዓኣዼያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ኪኢታንቻሢ ማሃዖ፦ «ታኣኒ ፆኦሲም ማዻ፥ ጌብሬኤሌኬ፤ ሃያ ኮዦ ሃይሶ ታ ኔኤም ኬኤዛንዳጉዲ ፆኦሲ ታና ዳኬም ታ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ኔኤኒ ጋዓንቴ ዎዳ'' ሄላ''ዛ ኩማንዳ ታኣኮ ጌኤዞ ጉሙርቂባኣሢሮ ሃይ ታ ኔኤም ኬኤዜ ባካ ቢያ ኩማንዳ ዎዶ'' ሄላ''ንዳኣና ዻንጋ ባይቂ፥ ጌስቱዋያ ኔ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ዬማና ዓሳ ዛካሪያሴ ካፓንቴ፥ ዒዚ ጌኤዦ ማኣራ ኔጌሢሮ ዓሳ፦ «ዎይቲ ዒዚ ሄኤዶ ሄሊ'' ኔጌይ?» ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ዛካሪያሴ ጌኤዦ ማኣራፓ ኬስካዖ ዓሶና ጌስታኒ ዳንዳዒባኣሴ፤ ዬያሮ ዔያታ ዒዛም ጌኤዦ ማኣሮ ጋሮይዳ ፔቴ'' ባኣዚ'' ጴዼያታሢ ዔሬኔ፤ ዒዚያ ዔያቶም ኩቻ ዻዊ ዻዊ ኬኤዛኔ። ዬያይዲ ዒዚ ጌስቱዋያ ማዒ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ዒዚ ማዻ ዎዳ'' ጋፓዛ ፔ ማኣሪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ዻካ'' ዎዴኮ ጊንፃፓ ዒዛኮ ማቻ ዔልሳቤፃ ጎጳዻዖ ዶንጎ ዓጊኒ ፔ ኬኤፃፓ ኬስኩዋዖ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ዒዛ፦ «ፆኦሲ ፔኤኮ ሚጪንቶና ዛጊ ሃያ ኮዦ ባኮ ታኣም ማዼኔ፤ ዓሶ ባኣካ'' ታኣኮ ዓኣ ዻውሲንቶዋ ባይዜኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ዔልሳቤፃ ጎጳዼንቴ ላሃ''ሳ ዓጊኖና ኪኢታንቻሢ ጌብሬኤሌ ፆኦሲ ኮራፓ ናዚሬቴ ካታሞ ዳኪንቴኔ። ናዚሬቴያ ጌሊላ ዓጮ''ይዳ ዓኣ ካታማኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ኪኢታንቻሢ ዳኪንቴሢ ማይራሞ ጌይንታ ፔቴ'' ኩሙሢ ዉዱሮ ናይስኬኖ ኮራኬ። ዒዛ ዳውቴ ዜርፃፓ ማዔ፥ ዮሴፔ ጎዖ ፔቴ'' ዓሲስኬያና ዖኦጪንታያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ኪኢታንቻሢያ ዒዞ ኮራ ሙካዖ፦ «ኔኤኒ ፆኦሲ ኔና ሚርጌና ቦንቼዜሌ! ኔ ኮሺዳ? ፆኦሲ ኔኤና ዎላ''ኬ፤ ኔኤኒ ላኣሎ ባኣካ''ፓ ዓንጂንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ዒዛኣ ኪኢታንቻሢ ሃይሶና ሚርጌ ዲቃታዖ፦ «ሃይ ዎዚጉዴ ዔኤሊ''ሢዳይ?» ጌይ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ኪኢታንቻሢ ዒዞም፦ «ማይራሜ! ፆኦሲ ኔና ሚርጌና ቦንቼሢሮ ዒጊጪፖ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ኔ ጎጳዺ ዓቲንቄ ናይ ሾዓንዳኔ፤ ሱ'ንፆዋ ኔ ዒዛኮ ‹ዬሱሴ› ጌይ ጌሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ዒዚያ ዼኤፒ ማዓንዳኔ፤ ፑኡፖ ፆኦዛሢ ናይያ ጌይንታንዳኔ፤ ጎዳ ማዔ ፆኦዛሢ ዒዛኮ ዓዶ ዳውቴ ካኣቱሞ ዖይቶ ዒዛም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ዒስራዔኤሌ ማኣሮይዳ ናንጊና ዒ ካኣታዻንዳኔ፤ ዒዛ ካኣቱሞኮዋ ጋፒንሢ ባኣያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማይራማ ኪኢታንቻሢ ኮራ፦ «ታኣኒ ኩሙሢ ዉዱሮ ናይኬ፤ ዓካሪ ዬይ ባካ ዎይቲ ማዓኒ ዳንዳዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ኪኢታንቻሢያ ማሃዖ፦ «ዓያና ጌኤሺ ኔ ዑፆይዳ ሙኬም፥ ፑኡፖ ፆኦዛሢኮዋ ዎልቃ ኔጊዳ ማዒ ኔ ጎጳዻንዳጉዲ ማሃንዳኔ፤ ዬያሮ ኔጊዳፓ ሾይንታንዳ ናዓሢ ዱማዼያኬ፤ ፆኦሲ ናይያ ጌይንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ኔኤኮ ዒጊኔላ ዔልሳቤፃ፥ ዞኦኬሎ ጌይ ናንጎዛ ሃሢ ጋርቼዖ ዓቲንቄ ናይ ጎጳዼኔ፤ ዒዛ ጎጳዼንቴ ሃና'' ዒዞኮ ላሃ''ሳ ዓጊኖኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ፆኦሲ ባሻ ባኣዚ'' ፔቴ''ታዖ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ዬካፓ ማይራማ ማሃዖ፦ «ያዺታቴ ሃይሾ ታኣኒ ፆኦሲም ማዻዜሎኬ፤ ኔኤኒ ጌዔሢጉዲ ታኣም ማዖንጎ» ጋዓዛ፥ ኪኢታንቻሢ ዒዞይዳፓ ዱማዺ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ዒማ''ና ማይራማ ዔልሳቤፆ ዖኦጫኒ ዪሁዳ ዓጫ'' ዹኮ''ይዳ ዓኣ ካታሜሎ ሩኡሪ ዔቂ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ዛካሪያሴ ማኣሪያ ጌሊ ዔልሳቤፆ፦ «ኮሺዳ?» ጌዒ ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ዔልሳቤፃ ማይራሞኮ ዔኤሊ''ፆ ዋይዜ ዎዶ''ና ዒዞኮ ጎጶይዳ ዓኣ ናዓ ዓጊፂ ዓማሌ''ኔ። ዬማና ዔልሳቤፃ ዓያና ጌኤሺኮ ዎልቆ ጋሮ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ዒዛ ዑኡዞ ፔኤኮ ዼ'ጊዲ፦ «ኔኤኒ ላኣሎ ቢያፓ ዓንጂንቴያኬ፤ ኔጊዳፓ ሾይንታንዳ ናዓ ዓንጂንቴያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ታ ጎዳኮ ዒንዳ ታና ዖኦጫኒ ሙካሢ ሃይ ኮሽካንዳ! ");
INSERT INTO mdybse_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","‹ኮሺዳ?› ጋዓ ኔኤኮ ዔኤሊ''ፆ ታ ዋዋይዛኣና ታኣኮ ጎጶይዳ ዓኣ ናዓ ዎዛና ዓጊፂ ዓማሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ኔኤኒ ፆኦሲ ኬኤዜ ባካ ቢያ ኩማያ ማዔሢ ጉሙርቂፆና ኔ ዎዚጉዴ ባሊቲና ዓኣያዳይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማይራማ ጋዓዖ፦ «ታኣኮ ሼምፓሢ ጎዳ ቦንቻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ታኣኮ ዓያና'' ዻቂሻ ፆኦዛሢና ዎዛዻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ፆኦሲ ታና ላኣፖ ማዻዜሎ ዛጌሢሮ ሓናፓ ዓርቃዖ ሾይንታ ቢያ፦ ‹ኔ ጋላቲንቴያኬ› ታና ጋዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ዓይጎሮ ጌዔቶ ፑኡፖ ፆኦዛሢ፥ ዼኤፒ ባኣዚ'' ታኣም ማዼሢሮኬ፤ ሱ'ንፃኣ ዒዛኮ ዱማዼያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ፆኦሲ ዒዛ ቦንቻ ዓሶ ቢያ ሾይንታፓ ሾይንቲ ሄላ''ንዳኣና ሚጪንታያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ዒዛኮ ዶዶ ኩጮና ዎልቆ ፔኤሲ'' ዒ ዻዌኔ፤ ዖቶርቃ ዓሶ ዔያቶኮ ማሊፆና ዎላ'' ዳኪ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ዼኤፖ ዎይሣ ዓሶዋ ካኣቱሞ ዖይታፓ ኬይሴኔ፤ ሂርኬዞንሢ ጋዓንቴ ቦንቺሲ ዼ'ጊዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ናይዼዞንሢ ኮሺ ባኣዚ'' ሙኡዚ'' ሚሼኔ፤ ዖርጎጮ ዓሶ ጋዓንቴ ኩቺ ጉሪ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","ዓብራሃሜና ዒዛኮ ዜርፆዋ ናንጊና ዒ ሚጪንቴ ሚጪንቶ ጶቂሲ፥ ዒዛም ማዻ ዒስራዔኤሌ ፆኦሲ ማኣዴ''ኔ። ሃሣ ዬያ ዒዚ ማዼሢ ኑኡኮ ቤርታኣ ዓዶንሢም ዒንጌ ዎዞ ቃኣሎ'' ኩንሣኒኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ማይራማ ዔልሳቤፆና ዎላ'' ሃይሦ ዓጊኒ ማዓያ ዴዔሢኮ ጊንፃ ማኣሪ ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ዔልሳቤፆኮ ሾይፆ ዓጊና ሄሌ''ም ዓቲንቄ ናይ ዒዛ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ዒዞኮ ዓሺኖና ዒጊኖና ቢያ ጎዳ ዒዞም ማዼ ኮዦ ባኮ ዋይዚ ዒዞና ዎላ'' ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ናዓሢ ሾይንቴስካፓ ሳላ''ሳ ኬሎ''ና ናዖኮ ዓቲንቶ ቤርቶ ቲቂፆ ዎጎ ኩንሦ ኬሎ''ይዳ ዒዞኮ ዓሺኖና ዒጊኖና ሙካዖ ናዓሢኮ ሱ'ንፆ «ዛካሪያሴ» ጌዒ ዓዶ ሱንፆና ጌሣኒ ኮዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ዒንዳ ጋዓንቴ፦ «ያዺ ማዓዓኬ፤ ሱ'ንፃ ዒዛኮ ‹ዮሓኒሴኬ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ዔያታ ማሃዖ፦ «ኔ ፃጶይዳ ዬያ ሱ'ንፆና ዔኤሊ''ንቴ ዓሲ ዖኦኒያ ባኣንቴሞ?» ዒዞ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ዬካፓ ዔያታ ዓዶ ኮራ፦ «ናዓሢኮ ሱ'ንፃ ዖና ጌይንታንዳጉዲ ኔ ኮዓይ?» ጌዒ ማላታና ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ዛካሪያሴ ፃኣፖ ባኣዚ'' ዒዛም ዒንጋንዳጉዲ ዖኦጪ ዔኪ፦ «ሱ'ንፃ ዒዛኮ ዮሓኒሴኬ» ጌዒ ፃኣፓዛ ቢያሢ ዬኖ ዛሎ''ና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ዬማና ዛካሪያሴኮ ዻንጋ ቡሊ''ንቲ ጌስታኒ ዳንዳዔም ፆኦሲ ጋላቲሢያ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ዬያፓ ዔቄያና ዔያቶኮ ዓሺና ቢያ ዒጊጬኔ፤ ዬይ ሃይሳኣ ዪሁዳይዳ ዓኣ ዹኮ'' ዓጫ'' ቢያ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ዬያ ባኮ ዋይዜ ዓሳ ቢያ፦ «ሓይ ናዓሢ ሃጊ ዓይጎ ማዓንዳኣ ናንዳይ?» ሂዚ ጌዒ ጌዒ ዎሊ ዖኦጫኔ። ዬይ ያዺ ማዔሢ ጎዳ ጎኔና ዒዛና ዎላ'' ዓኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ናዓሢኮ ዓዴ፥ ዛካሪያሴ ዓያና ጌኤሺኮ ዎልቆ ጋሮ ጌሊ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«ዴሮ'' ፔኤኮ ዓውሳኒ ሙኬሢሮ ዒስራዔኤሌኮ ጎዳ ማዔ ፆኦዛሢ ጋላቲንቶም፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ዒዛም ማዻ፥ ዳውቴ ዜርፃፓ ዼኤፒ ዻቂሻያ ዒ ኬሴ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ቤርታዺ ፆኦሲ ፔ ማሊፆ ኬኤዛ፥ ጌኤዦ ዓሶ ዛሎ''ና ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ዬይያ ኑና ዒፃ ዓሶና ሞርኮና ኩጫፓ ኑና ዻቂሻኒ ");
INSERT INTO mdybse_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ሓሣ ኑ ዓዶንሢማኣ ሚጪንታኒና ዒ ጫኣቄ ጌኤዦ ጫኣቁሞዋ ኩንሣኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ዬያ ጫኣቁሞ ዒ ጫኣቄሢ ኑ ዓዳሢ ዓብራሃሜምኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ዒዚ ጫኣቄ ዎዞ ቃኣላ'' ኑኡኒ ሞርኮ ኩጫፓ ኬስኪ ዒጊቹሞ ባኣያ ኑ ዒዛም ማዻንዳጉዲኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ዬይ ያዺ ማዔሢ፦ ኑኡኮ ናንጎ ዎዶ''ና ቢያ ፆኦሲ ቤርቶይዳ ጌኤሹሞና ፂሉሞና ኑ ናንጋንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ሓይ ኔ፥ ናዓሢ፥ ፑኡፖ ፆኦዛሢኮ ማሊፆ ኬኤዛሢ ኔ ጌይንታንዳኔ። ጎዳኮ ኔ ጎይፆ ጊኢጊሻኒ፥ ጎዳኮ ቤርታ ኔ ዓኣዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ጎዳኮ ዴራ'' ጎዳ ዔያቶኮ ጎሞ ዓቶም ጌዔም ዔያታ ዻቃንዳ ጎይፆ ኔ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ዓቢ ፆርቂ ኑም ፖዓሢጉዲ ፆኦሲኮ ሚጪንቶና ናሹሞና ኑም ሙካኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ዒዚያ ዹሞና ባይሲንቶናም ጊኢጊ ዓኣዞንሢም ቢያ ፖዓንዳኔ፤ ኑኡኮ ሄፆዋ ኮሺ ጎይሢ ባንሢ ዔኪ ዓኣዻንዳኔ» ሂዚ ጌዒ ፆኦሲ ማሊሢ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ናዓሢያ ዲጪ ዒናዼኔ፤ ዒስራዔኤሌ ዴሮ''ም ፔጋዺ ጴዻንዳያ ሄላ''ንዳኣና ዓሲ ናንጉዋ ዳውሎ''ይዳ ዴንዲ ናንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ዬኖ ዎዶ''ና ሮሜ ዓጮ''ይዳ ዓኣ ዴሮ'' ቢያ ፓይዳኒ፥ ሱ'ንፃ ዴሮ''ኮ ፃኣፒንታንዳጉዲ ሮሜ ካኣቲ ዓውጊስፆሴ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ቤርታዺ ዴሮ'' ፓይዳኒ ሱ'ንፆ ፃኣፖና ዎዶ''ና ቄርኔዎሴ ጎዖሢ ሶኦሪያ ዓጮ'' ዎይሣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ዬያሮ ፔቴ'' ፔቴ'' ዓሳ ሱንፆ ፃኣፒሳኒ ፔኤኮ ዓጮ'' ካታሞ ካታሞ ዴንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ዮሴፔ ጌሊላይዳ ዓኣ ናዚሬቴ ካታማ''ፓ ዔቂ ዪሁዳ ዓጮ''ይዳ ዓኣ ዳውቴ ካታሞ ጌይንታ ቤኤቴሌሄሜ ዴንዴኔ፤ ዓይጎሮ ጌዔቶ ዒዛኮ ዜርፃ ዳውቴ ፃጳፓ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ዒዚ ፃኣፒንታኒ ዓኣዼሢያ ጎጳዺ ዓኣ፥ ዒዛኮ ዖኦጮዞ፥ ማይራሞና ዎላ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ዔያታ ላምዖንሢ ቤኤቴሌሄሜ ካታሞይዳ ዓኣንቴ ማይራሞኮ ሾይፆ ኬላ'' ሄሌ''ም፥ ");
INSERT INTO mdybse_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ዒኢካ ዒዞኮ ኮይሮ ናዓሢ ሾዓዖ ናይ ዓርቆ ቱርጫና ካንቄኔ፤ ሾኦጫ ዎርቃ ቤዛ ቤሲ ዔያታ ዴንቂባኣሢሮ ባይ ሞስካ፥ ባኣታ ሙዖ ሙዓ ጎንጋላ'' ናዓሢ ላይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ዬኖ ዓጮ''ይዳ ካታሞኮ ዙላ፥ ቦኦሎ''ይዳ ቆልሞ ሄንቂ ሞኦሢዳ ዎርቃ ናይ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ዒማ''ና ዔያቶም ፆኦሲ ኪኢታንቻሢ ጴዼም፥ ፆኦሲኮ ቦንቾ ፖዓ ዔያቶ ዑፃ ፖዔሢሮ ሚርጌና ዔያታ ዒጊጪ ዲቃቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ኪኢታንቻሢ ጋዓንቴ፦ «ሃይ ዒንሢ ዎይታይ? ዒጊጪፖቴ፤ ዴሬም ቢያ ዼኤፒ ዎዛ ማዓ ኮሺ ሃይሴ ታ ዒንሢም ኬኤዛንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ዋይዙዋቴ! ሓኖ'' ዳውቴ ካታሞይዳ ዼኤሻ ዒንሢም ሾይንቴኔ፤ ዒዚያ ጎዳ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ዬያኮ ማላታ ያዺ ማዓንዳኔ፦ ናይ ዓርቆ ቱርጫና ካንቂንቴ ናይ፥ ባይ ባርታይዳ ባኣታ ሙዖ ሙዓ ጎንጋላ'' ላሂ ዓኣንቴ ዒንሢ ዴንቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ዬማና ዔያታ ዔሩዋንቴ ሚርጌ ጫሪንቺ ኪኢታንቻ ኪኢታንቻሢና ዎላ'' ጴዻዖ ፆኦሲ ጋላቲሢና፦ ");
INSERT INTO mdybse_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ጫሪንጮይዳ ፆኦሲም ቦንቾ ማዖም፤ ሳዖይዳኣ ዒዚ ናሽካ ዓሶም ቢያ ኮሹሞ ማዖም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ኪኢታንቾንሢ ዔያቶይዳፓ ዱማዺ ሌካ ጫሪንጮ ዴንዴ ዎዶ''ና ቆልሞ ሄንቃ ናኣታ'' ዎሊ ኮይላ''፦ «ዓካሪ ቤኤቴሌሄሜ ኑ ዴንዲ፥ ሃሢ ማዔ ባኮና ጎዳ ኑም ፔጋሲ ዻዌ ባኮ ኑ ዛጎም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ዔያታ ዒማ''ና ዑኬና ዴንዳዖ ማይራሞና ዮሴፔና ዴንቄኔ፤ ሃሣ ናዖዋ ባኣቶ ባርታ ባኣታ ሙዖ ሙዓ ጎንጋላ'' ላሂ ዓኣንቴ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ናዓሢ ዔያታ ዛጌሢኮ ጊንፃ ኪኢታንቻሢ ዒዛ ዛሎ'' ዔያቶም ኬኤዜሢ ዔያታ ማይራሞና ዮሴፔናም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ቆልሞ ናኣታ'' ኬኤዜ ባኮ ዋይዜ ዓሳ ቢያ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ማይራማ ጋዓንቴ ዬያ ቢያ ባኮ ፔ ዒና'' ዓርቂ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ቆልሞ ናኣታ'' ቢያ ባካ ኪኢታንቻሢ ዔያቶም ኬኤዜሢጉዲ ማዔም ዔያታ ዛጌሢና ዋይዜሢናሮ ፆኦሲ ቦንቺ ቦንቺ ሃሣ ጋላቲ ጋላቲ ዔያታ ሙኬ ቤዞ ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ናዓ ሾይንቴስካፓ ሳሊ'' ኬሊ''ኮ ጊንፃ ናዖኮ ዓቲንቶ ቤርቶ ቲቂፆ ዎጎ ኬሎ''ና ሱ'ንፃ ዒዛኮ «ዬሱሴ» ጌይንቴኔ። ዬይያ፦ ሓጊ ዒንዳ ዒዛ ጎጳዹዋንቴ ቤርታ ኪኢታንቻሢ ዒዛም ጌሤ ሱ'ንፆኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ሙሴ ዔርዜ ዎጎ ጎይፆና ዑፆ ጌኤሺፆ ዎጋ'' ጋፓ ኬላ'' ሄሌ''ሢሮ ናዓሢ ጎዳም ዔያታ ሺኢሻኒ ዔኪ ዬሩሳላሜ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ዬያ ዔያታ ዓይጎሮ ማዼይ ጌዔቶ ጎዳኮ ዎጎይዳ፦ «ዓቲንቄ ማዔ ቶይዲ ናይ ቢያ ጎዳም ዒንጊንቲ ዱማዼያ ማዖንጎ» ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ዬያጉዲ ሃሣ ጎዳኮ ዎጎይዳ፦ «ላምዖ ኪሬ፤ ማዒባኣቴ ላምዖ ዶኦሌ'' ናይ ሚቺ ዒንጎ ካኣዦም ዒንጋንዳያ ኮይሳኔ» ጋዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ዒማ''ና ዬሩሳላሜይዳ ሲሞኦኔ ጎዖ ፔቴ'' ዓሲስኬያ ዓኣኔ፤ ዒዚያ ፂሎ'' ሃሣ ፆኦሲ ዒጊጫ ዓሲኬ፤ ዒስራዔኤሌኮዋ ሃጊ ማዓንዳ ዻቂንቶ ዎዞ ካፓያ ሃሣ ዓያና ጌኤሺያ ዒዛና ዓኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ዒዚ ጎዳፓ ማዔ፥ ሜሲሔ ዛጉዋዖ ሃይቂንዱዋኣሢ ዓያና ጌኤሺ ዒዛም ቤርታ ዔርዜያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ዬኖ ኬሎ'' ዓያና ጌኤሺ ዒዛ ዔቂሴም ጌኤዦ ማኣሪ ዒ ዓኣዼኔ፤ ዒማ''ና ዮሴፔና ማይራሞና ካኣዦ ዎጎ ኩንሣኒ ናዓሢ ዔኪ ጌኤዦ ማኣሪ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ዒማ''ና ሲሞኦኔ ናዓሢ ኮንቂ ፆኦሲ ጋላቲሢና፦ ");
INSERT INTO mdybse_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ታ ጎዳሢዮ! ሓይሾ፥ ኔ ታኣም ኬኤዜ ሃጊ ማዓንዳ ዎዞ ቃኣላ'' ኩሜኔ፤ ዓካሪ ሃሢ ታና ኔኤኮ ማዻሢ ኮሺና ዔኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","ታኣኒ ታ ዓኣፒና ዓሶም ቢያ ኔ ጊኢጊሼ፥ ዼኤሻሢ ዛጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ዒዚ ሜሌ'' ዴሮ''ም ጎኑሞ ፔጋሲ ዻዋ ፖዒ ማዓንዳኔ፤ ኔኤኮ ዴሮ'' ዒስራዔኤሌ ዓሶዋ ዒ ቦንቺሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሴፔና ማይራሞና ናዓሢ ዛሎ'' ጌይንቴ ባኮ ቢያና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ሲሞኦኔ ዔያቶ ዓንጄሢኮ ጊንፃ ዱማና ናዓሢኮ ዒንዶ ማይራሞም፦ «ሃይ ናዓሢ ዒስራዔኤሌይዳ ሚርጌ ዓሶኮ ባይሲንታ፤ ሃሣ ሚርጌ ዓሶኮ ጋዓንቴ ዻቂንታ ካራ ማዓንዳኔ፤ ዒዚ ሚርጌሢ ዒዛ ጎናሲ ዔኩዋ ማላታ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ዬያና ሚርጌ ዓሶኮ ዒኖይዳ ዓኣሺንቴ ማሊፃ ፔጋዺ ጴዻንዳኔ፤ ዖዪሢያ ኔኤኮ ዒኖ'' ጬንቻ ዓፓሮጉዲ ቲቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ዬያጉዲ ሃሣ ዬኖ ዎዶ''ና ዓሴኤሬ ዜርፆይዳፓ ማዔ፥ ፓኑዔኤሌ ጎዖሢኮ ናዎ፥ ሃኣና'' ጌይንታ ፆኦሲ ማሊሢ ኬኤዛስኬና ዓኣኔ። ዒዛ ሚርጌ ጋርቼ ላኣሊኬ፤ ዓኒና ዎላ'' ዒዛ ላንካይ ሌዔ ዴዔስካፓ ዓኒ ዒዞኮ ሃይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ዬካፓ ሌዓ ዒዞኮ ሳሊ''ታሚ'' ዖይዶ ማዓንዳያ ሄላ''ንዳኣና ጌኤዦ ማኣራፓ ዱማዹዋዖ ሙኡዚ'' ሓሺ'' ሺኢቆ ሺኢጲሢ ሺኢቂ ሺኢቂ ሮኦሪና ዋንቴና ቢያ ፆኦሲም ማዻያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ዬኖና ዒዛ ሙኪ ፆኦሲ ጋላቲሢ ዓርቄኔ፤ ናዓሢ ዛሎ''ዋ ዬሩሳላሜኮ ዻቂንቶ ሃጊ ማዓንዳ ዎዛ ጌሢ ካፓዞንሢም ቢያ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ጎዳኮ ዎጎይዳ ዓይሢንቴ ዎጎ ቢያ ኩንሤስካፓ ጌሊላይዳ ዓኣ ዔያቶኮ ናንጎ ካታሞ ናዚሬቴ ዔያታ ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ናዓሢያ ዑጊ ዶዲ ዶዲ ዓኣዼኔ፤ ዒናዺያ ዶዴኔ፤ ሓሣ ፆኦሲ ዒዛ ዓንጄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ዮሴፔና ማይራሞና ሌዓ ሌዓ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ሮ ዬሩሳላሜ ዓኣዻያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ዬሱሴኮ ሌዓ ታጶ ላምዖ ማዔም ቤርታ ዔርቴ ጎይፆጉዴያ ዬኖ ቦንቾ ቦንቻኒ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ቦንቾ ኬላ'' ጋፔም ዔያታ ማኣሪ ማዓዛ ዬሱሴ ዬሩሳላሜይዳ ዓቴ''ኔ፤ ዮሴፔና ማይራሞና ጋዓንቴ ዒዚ ዒኢካ ዓቴ''ሢ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ጎይፆ ዓኣዻ ዓሶና ዒዚያ ዎላ'' ዓኣያ ዔያቶም ማሌሢሮ ፔቴ'' ኬሊ'' ጎይሢ ጉቤ ዔያታ ዓኣዻዖ ዔያቶኮ ዒጊኖና ፔ ላጎና ኮይላ'' ኮዒሢ ዒዛ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ጋዓንቴ ዔያታ ዒዛ ዴንቃኒ ዳንዳዒባኣሢሮ ዒዛ ኮዒ ኮዒ ጊንሣ ዬሩሳላሜ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ሓይሦ ኬሊ''ኮ ጊንፃፓ ጌኤዦ ማኣራ ዔያታ ዒዛ ዴንቄኔ፤ ዒዚያ ዒኢካ ዎጎ ዔራ ዓሶ ባኣካ'' ዴዒ ዔያቶሲ ዋይዚ ሃሣ ዖኦጪሢያ ዖኦጫኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ዒዛሲ ዋይዛ ዓሳ ቢያ ዒዚ ማሊ ጶቂሣ ጶቂሢፆና ሓሣ ዒ ማሃ ማሂፆና ዛሎ''ሮ ዲቃቲ ሄርሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ዮሴፔና ማይራሞና ጌኤዦ ማኣሮይዳ ዒዛ ዴንቂ ዲቃቲ ሄርሻዖ ዒንዴላ ዒዛ ኮራ፦ «ታ ናዓሢዮ፥ ዓይጎሮ ኔ ኑና ሃያይዴይ? ኔኤኮ ዓዶና ታኣና ሜታዺ ኔና ኑ ኮዓንቴቱዋይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ዬሱሴ ማሃዖ፦ «ዓይጎሮ ዒንሢ ታና ኮዔይ? ታኣኒ ታ ዓዶ ማኣራ ማዓንዳያ ኮይሳሢ ዒንሢ ዎንዴ ዔሩዋያዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ዔያቶም ጋዓንቴ ዒዚ ዬይ ጌዔ ባካ ዔርቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ዬካፓ ዬሱሴ ዔያቶና ዎላ'' ናዚሬቴ ዴንዴኔ፤ ዒኢካ ዔያቶም ዒ ዓይሢንታኔ፤ ያዺ ማዓዛ ዒንዳ ዬያ ባኮ ቢያ ፔ ዒና ዓርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ዬሱሴ ፆኦሲንታ ዓሲንታ ዎዛሳያ ማዔኔ፤ ሓሣ ዒናዺ ዔጶናኣ ዲጪ ዲጪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ሮሜ ዓጮ'' ካኣቲ ፂባርዮሴ ካኣታዼንቴ ታጶ ዶንጋሳ ሌዖና ጴንፄ ጲላፆሴ ጎዖሢ ዪሁዳ ዓጮ''፥ ሄሮዲሴ ጌሊላ ዓጮ''፤ ዬያጉዲ ሃሣ ጌርሲ ፒልጶሴ ዒፁሪያሴና ፂራክንዶሴ ዓጮ''፥ ሊሳኒዮሴ ጎዖሢ ዓቢላኒሴ ዓጮ'' ዎይሣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ዒማ''ና ሃኣናና ቃያፓና ቄኤሶ ቢያሢኮ ሱኡጎንሢኬ፤ ዬማና ዛካሪያሴ ናኣዚ''፥ ዮሓኒሴ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዓኣንቴ ፆኦሲ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ዬያሮ ዮሓኒሴ ዮርዳኖሴ ዎሮ ኮይሎ''ይዳ ዓኣ ዓጮ'' ቢያ ሃንቲ ሃንቲ፦ «ፆኦሲ ዒንሢም ዓቶም ጋዓንዳጉዲ ጎሞ ቡኡፂ ቡኡፂ ዋኣፆና ማስቱዋቴ» ጌዒ ጌዒ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ዬይ ያዺ ማዔሢ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዮሓኒሴ ዛሎ'' ቤርታዺ፦ «ሃይ ዓሲ ናንጉዋ ዳውሎ''ይዳ ሂዚ ጌዒ ጌዒ ዒላታ ዓሲኮ ዑኡሲኬ፤ ‹ጎዳኮ ጎይፆ ጊኢጊሹዋቴ፤ ሉኡጎ ጎይፆዋ ፒዚሱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ዶኦጫዻ ቤዛ ቢያ ኩሞንጎ፤ ዹኮ''ና ጌሜሮና ቢያ ሂርኪ ጎዖንጎ፤ ዎቦ ጎይፃኣ ፒኮንጎ፤ ጊኢጊ ኮሺ''ንቲባኣ ጎይፃኣ ጊኢጎንጎ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ዓሲ ቢያ ፆኦሲኮ ዻቂሻ ዎልቆ ዛጎንጎ!› » ሂዚ ጌዒ ፃኣፒንቴ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ዋኣፆና ማስቶሮ ዒዛ ኮይላ'' ሙካ ዓሶም ዮሓኒሴ፦ «ዒንሢ ሓይ ሾኦዣ! ሙካንዳ ፆኦዛሢኮ ጎሪ''ንቶይዳፓ ቶላ''ኒ ዒንሢ ዳንዳዓንዳጉዲ ዖኦኒ ዒንሢም ኬኤዜይ? ");
INSERT INTO mdybse_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ዓካሪ ሃሢ ጎሞ ዒንሢኮ ቡኡፂፆ ዔርዛ ማዾ ማዻንዳኣፓዓቴም ‹ኑኡኒ ዓብራሃሜ ናኣቶ''ኬ› ጌዒ ዒንሢ ዒኖና ሄርሺንቲፖቴ። ፆኦሲ ሃያ ሹጫፓ ዓብራሃሜ ናይ ማሂ ዔቂሳኒ ዳንዳዓያ ማዔሢ ታ ዒንሢም ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ሃሢ ሚፆ ፃጳፓ ቲቂ ኬኤራኒ ሄርጋ ጊኢጊንቴሢሮ ቃራ ዓኣፒ ዓኣፑዋ ሚሢ ቢያ ቲቂንቲ ታሚዳ ኬኤሪንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ዴራ'' ማሃዖ፦ «ሂዴቶ ኑ ዓይጎ ማዾንዶይ?» ጌይ ዮሓኒሴ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ዒዚያ፦ «ላምዖ ማኣዓ ዓኣሢ ፔቴ''ማ ባኣሢም ዒንጎንጎ፤ ሙኡዚ'' ዓኣሢያ ባኣሢም ጊሽኮንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ኮርሞ ኮርማ ዓሶይዳፓ ሚኢሾ ቡኩሲ ማዻዞንሢያ ማስቲፆሮ ዒዛ ኮይላ'' ሙካዖ፦ «ዔርዛሢዮ! ኑኡኒሾ፥ ዓይጎ ማዾንዶይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ዒዚያ፦ «ዎጎና ዓይሢንቴሢፓ ዑሣ ዓኣሢ ዔካኒ ዖኦጪፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ሃሣ ፖኦሊሳ ሙካዖ፦ «ኑኡኒሾ፥ ዓይጎ ማዾንዶይ?» ጌዔኔ። ዒዚ፦ «ዓሲ ሚኢሼ ጌኔና ቡሪ ዔኪፖቴ፤ ዖና ማዔቶዋ ሉኡቂ ዎጌና ዓይሢሲፖቴ፤ ዒንሢ ማዼሢ ዛሎ'' ዒንጎ ሚኢሻ ዒንሢም ጊዶንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ዒማ''ና ዴራ'' ቢያ ሜሲሔኮ ሙኪፆ ዎዛና ካፓያታሢሮ ዮሓኒሴ፦ «ሃይ ዓሢ ጎዖንቴ ሜሲሔ ማዓንዳሞ?» ጌዒ ጌዒ ዒኖና ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዮሓኒሴ ጋዓንቴ ዔያቶም፦ «ታኣኒ ዒንሢ ዋኣሢና ማስካኔ፤ ጋዓንቴ ሜሌ'' ታጊዳፓ ባሼ ሙካንዳኔ፤ ታኣኒ ዒዛኮ ዱርዞ ቱኮ'' ሱዞታዖ ቡላ''ኒ ኮይሳያቱዋሴ፤ ዬይ ዒንሢ ዓያና ጌኤሺና ሃሣ ታሚና ማስካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ዒዚ ቆይዳይዳ ዓኣ ሃኣኮ ሶኦራኒ ሶኦሮ ዓንዶ ኩጫ ዓርቄሢሮ ሶኦሪ ጌኤሼሢኮ ጊንፃ ኮዦ ዓኣፖ ኮናይዳ ዋሂ፥ ዲኢሮ ጋዓንቴ ባይቁዋ ታሚና ሚቻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ዬያጉዲ ሃሣ ዮሓኒሴ ዱማ ዱማ ጎይሢና ዴሮ'' ዞሪ ኮዦ ሃይሶ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ጌሊላ ዓጮ'' ዎይሣ ሄሮዲሴ ጋዓንቴ ጌርሲ ፒልጶሴኮ ማቾ ሄሮዲያዳ ዔኬሢሮና ሜሌ'' ሚርጌ ፑርታ ባኣዚ'' ማዼሢሮ ዒዛ ዒ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮዲሴም ዬይ ፑርቱሞ ማዻ'' ቢያ ጊዶ'' ዒፄም ፑርቱሞይዳ ፑርቱሞ ቃሲ''ሢና ዮሓኒሴ ቱኡዞ ማኣራ ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ዓሳ ቢያ ማስቴሢኮ ጊንፃ ዬሱሴያ ማስቴኔ፤ ዒዚ ዒማ''ና ሺኢቃ ጎይሣ ዓኣንቴ ጫሪንጫ ቡሊ''ንቴም፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ዓያና ጌኤሺያ ዶኦሌ'' ማሎና ማዒ ዒዛ ዑፃ ኬዴ''ኔ፤ ዒማ''ና «ኔኤኒ ታ ኔና ናሽካ ታኣኮ ናዓሢኬ፤ ኔኤና ታ ዎዛዻኔ» ጋዓ ዑኡሲ ጫሪንጫፓ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ዬሱሴ ዔርዚፆ ማዾ'' ዓርቃኣና ሌዓ ዒዛኮ ሓይሢታሚ'' ጉዴያኬ፤ ዒዚ ዓሶም ዮሴፔ ናይ ማላኔ። ዬይያ ዮሴፔ ዔኤሊ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ዔኤሊ ማቲ ናኣዚ''፥ ማቲ ሃሣ ሌዊ ናኣዚ''፥ ሌዊ ሚልኪ ናኣዚ''፥ ሚልኪ ዮና ናኣዚ''፥ ዮና ዮሴፔ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ዮሴፔ ማታቲዮ ናኣዚ''፥ ማታቲዮ ዓሞፄ ናኣዚ''፥ ዓሞፄ ናሆሜ ናኣዚ''፥ ናሆሜ ዔስሊሜ ናኣዚ''፥ ዔስሊሜ ናጌ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ናጌ ማዖቴ ናኣዚ''፥ ማዖቴ ማታቲዮ ናኣዚ''፥ ማታቲዮ ሴኤሜዬ ናኣዚ''፥ ሴኤሜዬ ዮሴፔ ናኣዚ'' ዮሴፔ ዮዳ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ዮዳ ዮናኔ ናኣዚ''፥ ዮናኔ ሬሴ ናኣዚ''፥ ሬሴ ዜሬባቡሌ ናኣዚ''፥ ዜሬባቡሌ ሳላቲያሌ ናኣዚ''፥ ሳላቲያሌ ኔሪ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ኔሪ ሚልኪ ናኣዚ''፥ ሚልኪ ሃዲ ናኣዚ''፥ ሃዲ ቆሳሜ ናኣዚ''፥ ቆሳሜ ዔልሞዳሜ ናኣዚ''፥ ዔልሞዳሜ ዔሪ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ዔሪ ዮሴዔ ናኣዚ''፥ ዮሴዔ ዔኤሊዔዛሬ ናኣዚ''፥ ዔኤሊዔዛሬ ዮራሜ ናኣዚ''፥ ዮራሜ ማፃቴ ናኣዚ''፥ ማፃቴ ሌዊ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ሌዊ ሲሞኦኔ ናኣዚ''፥ ሲሞኦኔ ዪሁዳ ናኣዚ''፥ ዪሁዳ ዮሴፔ ናኣዚ''፥ ዮሴፔ ዮናኔ ናኣዚ''፥ ዮናኔ ዔልያቂሜ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ዔልያቂሜ ሜሊያ ናኣዚ''፥ ሜሊያ ማይኔኔ ናኣዚ''፥ ማይኔኔ ማፃቴ ናኣዚ''፥ ማፃቴ ናኣታኔ ናኣዚ''፥ ናኣታኔ ዳውቴ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ዳውቴ ዒሴዬ ናኣዚ''፥ ዒሴዬ ዒዮቤዴ ናኣዚ''፥ ዒዮቤዴ ቦዔዜ ናኣዚ''፥ ቦዔዜ ሳልሞኔ ናኣዚ''፥ ሴልሞኔ ናዖሶኔ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ናዖሶኔ ዓምናኣዳኣቤ ናኣዚ''፥ ዓምናኣዳኣቤ ራሜ ናኣዚ''፥ ራሜ ዓርኔ ናኣዚ''፥ ዓርኔ ሄፂሮኔ ናኣዚ''፥ ሄፂሮኔ ፔርሴ ናኣዚ''፥ ፔርሴ ዪሁዳ ናኣዚ''፥ ዪሁዳ ያይቆኦቤ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ያይቆኦቤ ዪሳኣቄ ናኣዚ''፥ ዪሳኣቄ ዓብራሃሜ ናኣዚ''፥ ዓብራሃሜ ታራ ናኣዚ''፥ ታራ ናኮሬ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ናኮሬ ሴሩጌ ናኣዚ''፥ ሴሩጌ ሬዑ ናኣዚ''፥ ሬዑ ፔሌጌ ናኣዚ''፥ ፔሌጌ ዔቤሬ ናኣዚ''፥ ዔቤሬ ሼላሄ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ሼላሄ ቃይኒሜ ናኣዚ''፥ ቃይኒሜ ዓርፓክሳዴ ናኣዚ''፥ ዓርፓክሳዴ ሴኤሜ ናኣዚ''፥ ሴኤሜ ኖሄ ናኣዚ''፥ ኖሄ ላሜሄ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ላሜሄ ማቶሳላ ናኣዚ''፥ ማቶሳላ ሄኖኬ ናኣዚ''፥ ሄኖኬ ያሬዴ ናኣዚ''፥ ያሬዴ ሜላሊዔኤሌ ናኣዚ''፥ ሜላሊዔኤሌ ቃይናኔ ናኣዚ''፥ ");
INSERT INTO mdybse_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ቃይናኔ ሄኖሴ ናኣዚ''፥ ሄኖሴ ሴቴ ናኣዚ''፥ ሴቴ ዓዳኣሜ ናኣዚ''፥ ዓዳኣሜ ፆኦሲ ናኣዚ''ኬ ዔያታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ዬሱሴ ዓያና ጌኤሺ ቢታንቶ ዴሞ ጌሊ ዮርዳኖሴ ዎራፓ ማዓዛ፥ ዓያና ጌኤሺ ዓሲ ናንጉዋ ዳውሎ'' ዒዛ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ዒኢካ ዖይዲታሚ'' ኬሊ'' ፃላሄ ዒዛ ዛጋኒ ጌሼኔ፤ ዬንሢ ኬሎ''ንሢዳ ዓይጎዋ ዒዚ ሙዒባኣሢሮ ጋፒንፃ ዒዛ ናይዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ፃላሄ ዬሱሴ ኮራ፦ «ፆኦሲ ናይ ኔ ማዔያታቴ ሂንዳ ሃያ ሹጮ ካሣ ማዓንዳጉዲ ዓይሤ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ዬሱሴ ዒዛም ማሃዖ፦ «ዓሲ ካሣ ሌሊ ሙዒ ናንጉዋሴ ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ዬካፓ ፃላሄ ዬሱሴ ፔቴ'' ዼ'ጌ ቤሲ ኬሲ'' ካኣቶ'' ዓጮ'' ቢያ ዓኣፒ ጊኢጳማ ጉዴያና ዻዋዖ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«ሓያ ቢያ ቢታንቶና ቦንቾና ኔኤም ታ ዒንጋንዳኔ፤ ሃይ ቢያ ታኣም ዒንጊንቴያ ማዔሢሮ ታኣኒ ኮዔሢም ዒንጋኒ ዳንዳዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ዬያሮ ኔኤኒ ታና ዚጊ ካኣሽኬቴ ሓይ ቢያ ኔኤም ማዓንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ዬሱሴ ዒዛም ማሃዖ፦ «ፆኦሲ፥ ኔ ጎዳ ሌሊ ዚጊ ካኣሽኬ፤ ሃሣ ዒዛም ሌሊ ማዼ፥ ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ዬካፓ ፃላሄ ሃሣ ዬሱሴ ዔኪ ዬሩሳላሜ ዴንዳዖ ጌኤዦ ማኣሮኮ ሙስኩላ'' ዔቂሲ፦ «ኔኤኒ ፆኦሲ ናይ ማዔቶ ሂንዳ ሃይካፓ ሊካ ኮኦሚ ኬዴ''፤ ");
INSERT INTO mdybse_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ዓይጎሮ ጌዔቶ ‹ኔና ዔያታ ካፓንዳጉዲ ፆኦሲ ኪኢታንቾ ዓይሣንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ቶካ'' ኔኤኮ ሹጮይዳ ዹቂንቱዋጉዲ ዔያታ ፔ ኩጮና ኔና ዓርቃንዳኔ› ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ዬሱሴ ማሃዖ፦ « ‹ፆኦሲ፥ ኔ ጎዳሢ ዎይታቴያ ዛጋኒ ጌሺሺሪፖ› ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ፃላሄ ዬሱሴ ሚርጌ ጎይሢና ዛጋኒ ጌሼሢኮ ጊንፃፓ ዻካ'' ዎዴሮ ሓሺ'' ዒዛ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ዬሱሴ ዓያና ጌኤሺ ዎልቄ ዔኪ ጌሊላ ባንሢ ማዔኔ፤ ዒዛኮ ሱ'ንፃኣ ዓጮ'' ቢያይዳ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ዓይሁዶ ዓሳ ቡካ ቤዞይዳ ቤዞይዳ ዔርዛኣና ቢያሢ ዒዛኮ ዔርዚፆሮ ዒዛ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ዬካፓ ዬሱሴ ዒ ዲጬ ዓጮ''፥ ናዚሬቴ ዴንዳዖ ዒዚ ቤርታ ማዻ ጎይፆ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ዔያቶኮ ቡኪንቶ ቤዞ ጌሊ ናባባኒ ዔቃዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ማፃኣፓ ዒዛም ዒንጊንቴም፥ ማፃኣፖ ዒ ቡሌ'' ዎዶ''ና ሂዚ ጌዒ ፃኣፒንቴ ቤሲ ዴንቄኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ፆኦሲኮ ዓያና'' ታኣም ዒንጊንቴኔ፤ ዬይ ያዺ ማዔሢ ማንቆ ዓሶም ኮሺ ሃይሴ ቱኡቴዞንሢም ቡሊ''ንቲሢ ሃይሴ ዓኣፖ ባይቄዞንሢም ዛጊሢ ሃይሴ ታ ኬኤዛንዳጉዲና ሄ'ርቂንቲ ዴማ'' ዎርቃዞንሢ ዓይላ''ታፓ ታ ኬሳ''ንዳጉዲ፤ ቢታንቶ ታኣም ዒንጋኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ዬያጉዲ ሓሣ ጎዳ ፔ ዴሮ'' ዻቂሻንዳ ዎዳ'' ሃማታሢ ታ ኬኤዛንዳጉዲ ታና ዳኬኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ዬሱሴ ማፃኣፔሎ ጳንጪ ቤርታ ዔቄ ዓሢም ዒንጋዖ ዴዓዛ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ዓኣ ዓሳ ጊዥ ጌይ ዒዛ ዛጊሢ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ዒዚያ፦ «ሓይ ሓሢ ናባቢንታንቴ ዒንሢ ዋይዜ ማፃኣፖ ቃኣላ'' ሓኖ'' ኩሜኔ!» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ቢያሢ ዒዛ ኮሺ ማሂ ጌስታኔ፤ ዒ ኬኤዛ ኮዦ ቃኣሎ''ናኣ ዲቃቲ ሄርሻዖ፦ «ሓይ ዮሴፔ ናዓሢቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ዬሱሴ ዔያቶም ማሃዖ፦ « ‹ሓይ ኔ ዼኤሾ ዔራሢ ሂንዳ ኔና ዻቂሼ› ጌይንታ ኮኦኪንሦ ታጊዳ ዒንሢ ኬኤዛንዳሢ ታ ዔራኔ፤ ዬያጉዲ ‹ቂፒርናሆሜይዳ ኔ ማዼኔ ዓሳ ጋዓንቴ ኑ ዋይዜሢ ቢያ ሃይካ ኔ ዓጮ''ይዳኣ ማዼ› ዒንሢ ታና ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ጎኔ ታ ዒንሢም ጋዓኔ፦ «ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ፔ ዓጮ'' ዓሶ ኮይላ'' ቦንቺንቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«ዋይዙዋቴ! ጎኔ ታ ዒንሢም ኬኤዞም፤ ፆኦሲ ማሊፆ ኬኤዛ ዔኤሊያሴ ዎዶ''ና ሃይሦ ሌዔና ላሆ'' ዓጊኒና ዒርዚ ዋርቂባኣሢሮ ዓጮ'' ቢያይዳ ዼኤፒ ናይዚ ኬስኬኔ፤ ዬኖ ዎዶ''ና ዒስራዔኤሌ ዓጮ''ይዳ ዜኤሪንዶ ማዔ ሚርጌ ላኣሊ ዓኣንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ዔኤሊያሴ ሲዶና ጌይንታ ዓጮ''ይዳ ሴራጲታ ጌይንታ ጉርዴሎይዳ ዓኣ ፔቴ'' ዜኤሪንዴስኬኖ ኮይላ'' ሌሊ ዳኪንቴያፓዓቴም ሜሌ'' ዖ ኮይላ''ኣ ዳኪንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ዬያጉዲ ሃሣ ፆኦሲ ማሊፆ ኬኤዛ ዔልሳዒ ዎዶ''ና ዑሢዳ ኬስካ ዶርዖና ዓርቂንቴ ዓሲ ዒስራዔኤሌ ዓጮ''ይዳ ሚርጌ ዓኣንቴ ሶኦሪያ ዓጮ'' ዓሢ ኒዒማኔፓ ዓታዛ ዔያቶይዳፓ ፔቴ''ታዖ ዻቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ዓኣ ዓሳ ቢያ ዬያ ዋይዛዖ ዻጋዺ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ዬሱሴ ጎቺ ዔኪ ካታማፓ ዙሎ'' ኬሴ''ኔ፤ ዬና ካታሜላ ማዢንቴሢ ዹኬ ዑስካታሢሮ ዒዛ ዔያታ ጎኦቦ'' ሂዒ ዳካኒ ኮዒ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ዒዚ ጋዓንቴ ዔያቶኮ ባኣኪና ቶሊ'' ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ዬካፓ ዬሱሴ ጌሊላ ዓጮ''ይዳ ዓኣ፥ ቂፒርናሆሜ ካታሜሎ ዴንዲ ዒኢካ ዴሮ'' ዓይሁዶ ዓሶኮ ሓውሾ ኬሎ''ና ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ዒዚ ቢታንቶና ኬኤዛሢሮ ቢያሢ ዒዛኮ ዔርዚፆና ዲቃቲ ሄርሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ዒኢካ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ፑርታ ዓያና ዓርቄ ዓሲ ዓኣኔ፤ ዒዚ ዼኤፒ ዑኡሲና ሂዚ ጌዒ ዒላቴኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«ናዚሬቶ ዬሱሴ! ኑኡኮ ኔኤና ዎላ'' ዓይጎ ካኣሚሢ ዓኣይ? ኑና ኔ ባይዛኒ ሙኪያ? ኔ ዖና ማዔቴያ ታ ኔና ዔራኔ፤ ኔኤኒ ዱማዼያ ፆኦሲ ናይኬ!» ");
INSERT INTO mdybse_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ዬሱሴያ ማሃዖ ፑርቶ ዓያናሢ፦ «ዚቲ ጌዒ፥ ሃያ ዓሢፓ ኬስኬ!» ጌዒ ጎራ''ዛ፥ ፑርቶ ዓያናሢ ዓሢ ዴሮ''ኮ ቤርታ ሎንሤስካፓ ፔቴ''ታዖ ዔኤቢ ዎኦቱዋዖ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ቢያሢ ዲቃቲ ሄርሻዖ ዎሊ ኮይላ''፦ «ሃይ ዎዚጉዴ ባኣዚ''ዳይ? ቢታንቶና ሓሣ ዎልቄና ፑርቶ ዓያኖ ዒዚ ዓይሣኔ፤ ዔያታኣ ዒዛም ዓይሢንቲ ኬስካኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ዬሱሴኮ ሱ'ንፃ ዬኖ ዓጬ''ሎ ኮይሎ''ይዳ ቢያ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ዬሱሴ ዓይሁዶ ዓሳ ቡኪንታ ቤዛፓ ዔቂ ሲሞኦኔ ማኣሪ ዓኣዼኔ፤ ዒኢካ ሲሞኦኔኮ ባይሳ ሚርጌና ቆፂንቲ ላሂ ዓኣኔ፤ ዬያሮ ዒዞ ዒ ፓሣንዳጉዲ ዬሱሴ ዔያታ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ዬሱሴያ ዒዞ ባንሢ ዑካዖ ዓጫ ዒዞኮ ዔቂ ቆሣ ሺማንዳጉዲ ዓይሣዛ ቆሣ ዒዞኮ ሺሜም ቤዞማና ዔቂ ዒዛ ዔያቶ ሾኦቺንሥሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ዓባ'' ጌላኣና ዓሳ ዱማ ዱማ ሃርጌና ዓኣ ዓሲ ቢያ ዬሱሴ ባንሢ ዔኪ ሙካዛ፥ ዒዚ ፔቴ'' ፔቴ''ሢኮ ዑፃ ኩጮ ጌሢ ፓሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ፑርቶ ዓያና''ኣ፦ «ኔኤኒ ፆኦሲ ናኣዚ''ቲ!» ጌዒ ጌዒ ዒላቲ''ና ዓሶይዳፓ ሓሺ'' ኬስካኔ። ዒዚ ሜሲሔ ማዔሢያ ዔያታ ዔሬኔ፤ ዬሱሴ ጋዓንቴ ዒዛ ዛሎ'' ፔቴ''ታዖ ኬኤዙዋጉዲ ዔያቶ ጎሪ'' ላኣጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ሳዓ ካራዛ ዬሱሴ ዒኢካፓ ኬስኪ ዓሲባኣ፥ ዔዌ ቤሲ ዴንዳዛ ዓሳ ዒዛ ዒማ''ና ኮዓኔ፤ ዔያታ ዒዛ ዴንቃዖ፦ «ኑ ኮራፓ ዴንዲፖ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ዒዚ ጋዓንቴ፦ «ሜሌ'' ካታሞ ታ ዴንዲ ፆኦሲ ካኣቱሞ ኮዦ ሓይሶ ኬኤዛንዳያ ታኣም ኮይሳኔ፤ ታ ዳኪንቴሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ዬያሮ ዪሁዳይዳ ዓይሁዳ ቡካ ቤዞ ሓንቲ ሓንቲ ዒ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ፔቴ'' ኬሊ'' ዬሱሴ ጌንሴሬፄ ጌይንታ ባዞ'' ዓጫ ዔቂ ዓኣንቴ ሚርጌ ዓሳ ዒዛ ባንሢ ሙኪ ፆኦሲኮ ቃኣሎ'' ዋይዛኒ ቱቺንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ዒዚያ ባዞ'' ዓጮይዳ፥ ሳዖኮ ዑኬ ዔቄ፥ ላምዖ ዋኣሢና ፒንቆ ጎንጊ ዴንቄኔ፤ ሞላሢ ዓርቃዞንሢ ጋዓንቴ ዋኣፆና ፒንቆ ጎንጋፓ ኬዲ'' ዔያቶኮ ሞላሢ ዓርቆ ሮኦጮ ማላ ሱዞ ማስካኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ዬሱሴ ዋኣፆና ፒንቆ ጎንጎንሢዳፓ ፔቴ''ዞ፥ ሲሞኦኔሬሎይዳ ጌላዖ ሲሞኦኔ ኮራ፦ «ሓኖ'' ዋኣፆና ፒንቆ ጎንጌሎ ሳዖ ኮራፓ ባዞ'' ሳዞ'' ባንሢ ታኣም ዶጪሴ» ጌዔኔ። ዬካፓ ዋኣፆና ፒንቆ ጎንጌሎይዳ ዴዒ ዴሮ'' ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ዒ ኬኤዛ ባኮ ጋፒሴሢኮ ጊንፃ ሲሞኦኔ ኮራ፦ «ዋኣፆና ፒንቆ ጎንጌሎ ሴካ ባዞ'' ሳዞ'' ጌልዚ ኔኤኒ ኔኤኮ ላጎንሢና ዎላ'' ሞላሢ ዓርቃኒ ሮኦጮ ማላ ሱዞ ዋኣፆይዳ ዓጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ሲሞኦኔ ማሃዖ፦ «ዔርዛሢዮ! ዋንቴ ሳዓ ካራንዳያ ሄላ''ንዳኣና ዓርቃኒ ኮዒ ሚርጌ ኑ ላቤዖ ፔቴ''ታዖ ዓርቂባኣሴ፤ ኔ ጌዔቶ ጋዓንቴ ሓይሾ ሱዞ ኑ ዓጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ሮኦጮ ማላ ሱዞ ዔያታ ዓጋዖ ሱዛ ማኣማንዳያ ሄላ''ንዳኣና ሚርጌ ሞሎ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ዬያሮ ሜሌ'' ዋኣፆና ፒንቆ ጎንጎይዳ ዓኣ ዔያቶኮ ላጎንሢ ሙኪ ዔያቶ ማኣዳ''ንዳጉዲ ኩቻ ዉቲ ዔኤላ''ዛ፥ ዔያታ ሙኪ ላምዖ ዋኣፆና ፒንቆ ጎንጋ ዔኤዺንታኒ ዑካንዳያ ሄላ''ንዳኣና ሞላሢ ዓርቂ ጎንጎ ኩንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ሲሞኦኔ ጎዖ ጴፂሮሴ ዬያ ዛጌ ዎዶ''ና ዬሱሴኮ ቤርታ ጉምዓቲ፦ «ታ ጎዳሢዮ! ታ ጎሜ ዓሲ ማዔሢሮ ታ ባንሢ ኔ ዑኪፖ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ዬያ ዒ ጌዔሢ ዒዛንታ ዒዛና ዎላ'' ዓኣ ላጎንሢ ቢያ ዓርቄ ሞላሢ ሚርጉሞይዳፓ ዔቄያና ሚርጌና ዲቃቲ ሄርሼሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ዬያጉዲ ሃሣ ሲሞኦኔኮ ላጎንሢ ማዔ ዜብዲዮሴ ናኣቶ''ንሢ፥ ያይቆኦቤና ዮሓኒሴናኣ ዲቃቲ ሄርሼኔ። ዬሱሴ ሲሞኦኔ ኮራ፦ «ሓይ ኔ ዎይታይ! ዒጊጪፖ፤ ሓካፓ ሴካ ኔ ዓሲ ፒሪ ዓርቃያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ዔያታ ዋኣፆና ፒንቆ ጎንጎንሢ ሳዖ ባንሢ ዑኪሲ ዔቂሴስካፓ ቢያ ባኮ ሓሺ'' ዬሱሴ ጊንፆ ሓንታያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ፔቴ'' ኬሊ'' ዬሱሴ ካታሞይዳ ዓኣንቴ ፔቴ'' ዑሢዳ ኬስካ ዶርዓ ዑፆ ባይዜ ዓሲ ዒዛ ኮራ ሙኬኔ፤ ዒዚ ዬሱሴ ዴንቃዖ፦ ባሊቲና ሳዓ ሎኦሚ፦ «ኔ ኮዔቴ፥ ታና ጌኤሻኒ ዳንዳዓኔ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ዬሱሴያ ኩጮና ዒዛኮ ዑፆ ፒፃ''ዖ፦ «ጌኤሽኬ! ኔ ጌኤሽካንዳጉዲ ታ ኮዔኔ» ዒዛም ጋዓዛ፥ ቤዞማና ዓሢ ዑፃ ኬስኬ ዶርዓስካፓ ጌኤሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ሄሊ''ሳዖ ዬሱሴ ዒዛም ሂዚ ጌዒ ዓይሤኔ፦ «ሓያ ባኮ ዖኦማኣ ኬኤዚፖ፤ ጋዓንቴ ዴንዲ ኔና ቄኤሳሢም ዻዌ፤ ዴሮ''ም ማርካ ማዓንዳጉዲ ኔኤኮ ጌኤሽኪፆ ዛሎ'' ሙሴ ዓይሤ ፆኦሲም ዒንጎ ባኮ ዒንጌ።» ");
INSERT INTO mdybse_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ዬማፓ ዬሱሴኮ ሱ'ንፃ ቤርታኣስካፓ ባሼና ዋይዚንቴሢሮ ሚርጌ ዓሳ ዒዛሲ ዋይዛኒና ፔኤኮ ዶርዓስካፓ ዻቃኒ ኮዒ ዒዛ ኮራ ቡካኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ዒዚ ጋዓንቴ ቢያ ዎዴ ፔኤሮ ሌሊ ዔዌ ቤሲ ዴንዲ ዴንዲ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ፔቴ'' ኬሊ'' ዬሱሴ ዔርዚፆይዳ ዓኣንቴ ፔርሴ ዓሶና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ዒዛ ኮይላ'' ዴዒ ዓኣኔ፤ ዔያታ ጌሊላና ዪሁዳ ጉርዶናይዳፓ፥ ዬያጉዲ ሃሣ ዬሩሳላሜ ካታማፓ ሙኬያኬ፤ ዬሱሴ ሃርጊንቴ ዓሶ ፓሣንዳጉዲ ፆኦሲ ዒንጌ ዎልቄ ዒዛና ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ዒማ''ና ፔቴ'' ዎቦ ዓሲ ሃሎና ኬዴ ዓሲ ዬሱሴ ኮራ ዒዚ ዓኣ ቤዞ ሙኪ፥ ዬሱሴ ዓኣ ኬኤፆ ጌልዚ ዒዛኮ ቤርታ ጌሣኒ ኮዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ጋዓንቴ ዴሮ''ኮ ሚርጉማፓ ዔቄያና ዎቦ ዓሢ ጋሮ ዔኪ ጌላኒ ዔያቶ ባሼሢሮ ማኣሮኮ ዑፆ ዔኪ ጊዓዖ ማኣሮኮ ሄላሢዳ ኬስኬኔ፤ ዬካፓ ሳኮ ሻሂ ዎቦ ዓሢ ሃላሢና ዎላ'' ዬሱሴኮ ቤርታ ኬይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ዬሱሴ ዔያቶኮ ጉሙርቂፆ ዛጌ ዎዶ''ና ዎባሢም፦ «ዔኤዛይ! ኔኤኮ ጎማ ዓቶም ጌይንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶና፦ «ፆኦሲ ጫሽካሢ ሓይ ዖናዳይ? ጎሜ ዓቶም ጋዓሢ ፆኦሲዳፓዓቴም ሜሌ'' ዖናዳይ?» ጌዒ ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ዬሱሴ ዬያ ማሊፆ ዔያቶኮ ዔራዖ፦ «ዒንሢ ዒኖና ዓይጎሮ ዬያ ጌይ ማላይ? ");
INSERT INTO mdybse_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ማዓዛ ‹ጎማ ኔኤኮ ዓቶም ጌይንቴኔ› ጌይሢና ‹ዔቂ ዴንዴ› ጌይሢናይዳፓ ዎና ሼሌዓይ? ");
INSERT INTO mdybse_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ጋዓንቴ ዓሲኮ ናዓሢ ሳዖይዳ ጎሜ ዓቶም ጋዓኒ ቢታንቶ ዓኣያ ማዔሢ ዒንሢ ዔራንዳያ ኮይሳኔ» ጌዒ ዎቦ ዓሢም፦ «ዔኤዛይ፥ ኔኤኮ ሃላሢ ኬዲ ዔኪ ኔ ማኣሪ ዓኣዼ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ዎቦ ዓሢያ ዓሶ ቤርቶይዳ ዔቃዖ ሃላሢ ፔኤኮ ኬዲ ፆኦሲ ጋላቲ ጋላቲ ፔ ማኣሪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ዒኢካ ዓኣ ዓሳ ቢያ ሚርጌና ዲቃቲ ሄርሺ ሓሣ ዒጊጫዖ፦ «ሓኖ'' ኑ ዓኪ ባኣዚ'' ዛጌኔ» ጌዒ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ዬሱሴ ዬካፓ ኬስኪ ዓኣዻንቴ ሌዊ ጎዖ፥ ኮርሞ ኮርማ ዓሶይዳፓ ሚኢሾ ቡኩሳሢ ሚኢሾ ቡኩሳ ቤዛ ዴዒ ዓኣንቴ ዛጋዖ፦ «ሓኒ ታ ጊንፆ ሙኬ» ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ሌዊ ላዓ ጌዒ ዔቂ፥ ቢያ ባኮዋ ሓሺ'' ዬሱሴ ጊንፆ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ዬካፓ ሌዊ ፔ ማኣሮይዳ ዬሱሴ ቦንቺ ዼኤፒ ሙኡዚ'' ጊኢጊሻዛ ዬኖ ሙዖይዳ ሚርጌ ኮርሞ ኮርማ ዓሶፓ ሚኢሾ ቡኩሳ ዓሶና ሜሌ'' ሚርጌ ዓሲያ ዒኢካ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፔርሴ ዓሶና ዔያቶ ፃጳፓ ማዔ፥ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ፦ «ኮርሞ ኮርማ ዓሶይዳፓ ሚኢሾ ቡኩሳ ዓሶና ጎሞ ዓሶና ዎላ'' ዒንሢ ሙይ ዑሽካሢ ዓይጌንዴሮዳይ?» ጌዒ ዬሱሴኮ ጊንፆ ሃንታዞንሢ ዑፃ ጉንዱሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ዬሱሴ ዒማ''ና ሂዚ ጌዒ ዔያቶም ማሄኔ፦ «ሃርጊንቴ ዓሲም ማዓንዳኣፓዓቴም ዋሊ'' ዓሲም ዼኤሻ ዔራ ዓሲ ኮይሱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ታኣኒ ሙኬሢ ጎሞ ዓሳ ጎሞ ፔኤኮ ቡኡፂ ፆኦሲ ባንሢ ማዖም ዔኤላ''ኒ ማዓንዳኣፓዓቴም ፂሎ'' ዓሶ ዔኤላ''ኒቱዋሴ።» ");
INSERT INTO mdybse_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ዬካፓ ዔያታ ዬሱሴ ኮራ፦ «ማስካ ዮሓኒሴና ፔርሴ ዓሶናኮ ጊንፆ ሃንታዞንሢ ሙዖ ሃሺፆ ዳምቦ ካፓኔ ሓሣ ሺኢጲሢያ ዎዶ''ማ ካፒ ካፒ ሺኢቃኔ፤ ኔ ጊንፆ ሃንታዞንሢ ጋዓንቴ ቢያ ዎዴና ሙዒ ዑሽካሢ ዓይጌንዴሮዳይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ዬሱሴ ዔያቶም ማሃዖ፦ «ዑኡታሢ ዔያቶና ዎላ'' ዓኣንቴ ዔፖ ዓሶም ሙኡዚ'' ሃሺ''ሢ ኮይሳኔ ጌይ ዒንሢ ማላ? ");
INSERT INTO mdybse_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ጋዓንቴ ዑኡታሢ ዔያቶይዳፓ ዱማዻንዳ ዎዴ ሙካንዳኔ፤ ዬኖና ዔያታ ሙኡዚ'' ሃሻ''ንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ሄሊ''ሳዖ ዬሱሴ ሂዚ ጌዒ ፔቴ'' ኮኦኪንሢ ዔያቶም ኬኤዜኔ፦ «ዓኪ ዓፒላይዳፓ ዳርዚ ዔኪ ጪሚ ዓፒላይዳ ዓጊ ሲካይ ዖኦኒያ ባኣሴ፤ ዬያይዳ ዓሲ ዓኣቶ ጋዓንቴ ዓኮ ዓፒሎ ጉሪ ዳዳርዜያ ማዓኔ፤ ዓኮ ዓፒላኣ ጪሞ ዓፒሎም ጊኢጉዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ዬያጉዲ ሃሣ ሶልኪ ዑሺ ዋሆ ጪንቄ ዖቲዳ ሺሜ ዑሺ ዋሃይ ዖኦኒያ ባኣሴ፤ ዬያይዳ ዓሲ ዓኣቴ ጋዓንቴ ሺሜ ዑዣ ዖቶ ዹኡሴም፥ ዑዣኣ ላኣሊንታንዳኔ፤ ሃሣ ዖታኣ ሃይቂ ጉሪ ዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ዬያሮ ሺሜ ዑዦ፡ ዓኪ ዖቲዳ ዋሃንዳያ ኮይሳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ሚርጌ ዎዴ ዴዒ ሶልኬ ዑሺ ዑሽካሢ ሺሜ ዑዦ ዑሽካኒ ኮዑዋሴ፤ ዓይጎሮ ጌዔቶ ‹ዴዒ ካፂ፥ ሶልኬ ዑሺ ኮሺኬ› ጋዓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ዬሱሴ ዛርጌ ጎሺ ጊዴና ዓኣዻንቴ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዛርጎ ቲሻሢ ዱኡዚ ዔኪ ዔኪ ኩቻ ሺርኪ ዻይሢ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ፔርሴ ዓሶይዳፓ ፔቴ'' ፔቴ''ዞንሢ ዬሱሴኮ ጊንፆ ሃንታ ናኣቶ'' ኮራ፦ «ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ማዺንታኒ ኮይሱዋ ባኣዚ'' ዒንሢ ዓይጎሮ ማዻይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ዬሱሴ ዔያቶም ሂዚ ጌዒ ማሄኔ፦ «ዒዛንታ ዒዛና ዎላ'' ዓኣ ዓሳ ናይዺንቴ ዎዶ''ና ዳውቴ ማዼ ባኮ ዒንሢ ናባቢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ዒዚ ፆኦሲ ማኣሪ ጌሊ ቄኤሶይዳፓ ዓታዛ ሜሌ'' ሙዓንዳጉዲ ዓይሢንቲባኣ፥ ዱማሶና ካፆ ዔኪ ሙዒ ዒዛና ዎላ'' ዓኣ ዓሶማኣ ዒንጌኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ሄሊ''ሳዖ ዬሱሴ፦ «ዓሲኮ ናዓሢ ሃውሾ ኬሎ''ኮዋ ጎዳኬ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ሃሣ ሜሌ'' ዓይሁዶኮ ሃውሾ ኬሊ'' ዓቢና ዬሱሴ ዓይሁዴ ዓሶኮ ቡኪንቶ ቤዞ ጌሊ ዔርዚሢ ዓርቄኔ፤ ዒኢካ ሚዛቆ ኩጫ ዎቤ ፔቴ'' ዓሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶንታ ፔርሴ ዓሶንታ ዬሱሴ ዎጎና ዓይሢሳንዳ ዻቢንቲ ዴንቃኒ ኮዓዖ፦ «ሂንዳ ዒ ሃያ ሃውሾ ኬሎ''ና ዓሢኮ ኩጮ ፒሻቶ ኑ ዛጎም» ጌዒ ዒዛ ካፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ዬሱሴ ጋዓንቴ ዔያቶኮ ማሊፆ ዔራዖ ኩጮ ዎባሢም፦ «ሃካ ሙኪ ባኣካ'' ዔቄ!» ጋዓዛ፥ ኩጮ ዎቦ ዓሢያ ባኣካ'' ሙኪ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ዬማ''ና ዬሱሴ፦ «ሂንዳ ታ ዒንሢ ዖኦጮም፤ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ዓይሢንቴሢ ኮሺ ማዾ ማዺሢሞ ፑርታ ማዺሢዳይ? ሃሣ ሼምፖ ዻዻቂሺሢሞ ባባይዚሢዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ዬሱሴ ኮይሎ''ይዳ ዓኣ ዓሶ ባንሢ ቢያ ዛጌሢኮ ጊንፃ ኩጮ ዎቦ ዓሢም፦ «ኩጮ ኔኤኮ ፒሼ!» ጋዓዛ፥ ዒዚ ኩጮ ፒሻዛ ኩጫ ፒኪ ባጎ ኩጮ ጉዲ ኮሺ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶና ጋዓንቴ ሚርጌና ዻጋዻዖ፦ «ዓካሪ ሃያ ዬሱሴ ኑ ዎዎዶ''ንዶይ?» ጌይ ዎላ'' ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ዬካፓ ፔቴ'' ኬሊ'' ዬሱሴ ሺኢቃኒ ዹኬ ኬስኪ ዒኢካ ዬኖ ዋንቴሎ ጉቤ ፆኦሲ ሺኢቄ ጎይሣ ዎርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ዚሮ ጉቴ''ሎ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ባንሢ ዒ ዔኤላ''ዖ ዔያቶ ባኣካ''ፓ ታጶ ላምዖንሢ ዶኦሪ «ዳኪንቴዞንሢ» ጌይ ሱ'ንሢ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ዬያታ ሃይፓ ዴማ'' ፓይዲንታዞንሢኬ፦ ጲፂሮሴ ጌይንቲ ሱ'ንፃ ጌሢንቴ ሲሞኦኔና ጌርሲ ዒንዲራሴ፥ ያይቆኦቤ፥ ዮሓኒሴ፥ ፒልጶሴ፥ ቤርቴሌሞሴ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቲዎሴ፥ ቶኦማኣሴ፥ ዒልፒዮሴ ናኣዚ'' ያይቆኦቤ፥ «ፔ ዓጮ ሚጪንታያ» ጌይንታ ሲሞኦኔ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያይቆኦቤ ናኣዚ'' ዪሁዳንታ ዬሱሴ ዓኣሢ ዒንጌ ዓስቆሮንቶ ዓጮ'' ዓሢ ዪሁዳንታኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","ዬሱሴ ዳኪንቴዞንሢና ዎላ'' ዹካ''ፓ ኬዲ'' ቦኦላ'' ዔቄኔ፤ ዒማ''ና ዒዛ ዓሲ ማዔ ዓሶፓ ሚርጌ ዓሲ ዒኢካ ዓኣኔ፤ ዬያጉዲ ሃሣ ዒዛሲ ዋይዛኒና ሃርጎይዳፓኣ ፖዓኒ ኮዒ ሙኬ ሚርጌ ዓሲ ዓኣኔ፤ ዔያታ ሙኬሢ ዪሁዳ ዓጫ''ፓ፥ ዬሩሳላሜ ካታማፓ፥ ባዞ'' ዓጮይዳ ዓኣ ፂሮሴና ሲዶና ካታሞናይዳፓኬ፤ ፑርቶ ዓያኖና ዓርቂንቲ ሜታዻ ዓሳኣ ዒዛ ኮራ ሙኪ ፖዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ዓሲ ዻቂሻ ዎልቄ ዒዛይዳፓ ኬስኪ ኬስኪ ሃርጌ ዓሶ ቢያሢ ፖዒሳያ ማዔሢሮ ዓሳ ቢያ ዬሱሴኮ ዑፆ ካኣማኒ ኮዓኔ፤ ካኣሜ ዓሳኣ ቢያ ዻቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ዬሱሴ ሺሪ ፔኤኮ ጊንፆ ሃንታዞንሢ ባንሢ ዛጋዖ ሂዚ ጌዔኔ፦ «ፆኦሲ ካኣቱማ ዒንሢምታሢሮ ዒንሢ ማንቆ ዓሳ ዓንጂንቴያኬ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ዒንሢ ሃሢ ናይዺንታዞንሢ ጊንፃፓ ሚሽካንዳሢሮ ዒንሢ ዓንጂንቴያኬ! ዒንሢ ሃሢ ዬኤካዞንሢ ጊንፃፓ ሚኢጫንዳሢሮ ዒንሢ ዓንጂንቴያኬ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«ዒንሢ ዓሲ ናዓሢ ጊንፆ ሃንታሢሮ ዓሳ ዒንሢ ዒፃኣና ሃሣ ‹ኑኡና ፔቴ'' ማዒፖቴ› ጌዒ ዒንሢ ዱማሳኣና ጫሽኪ ዒንሢኮ ሱ'ንፆ ፑርቲሶናቴያ ዒንሢ ዓንጂንቴያኬ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«ጫሪንጮይዳ ዒንሢም ዒንጎንዶ ባካ ዼኤፒ ማዔሢሮ ዬይ ቢያ ዒንሢዳ ሄላ''ኣና ዎዛዺ ኮኦሙዋቴ፤ ዔያቶኮ ዓዶንሢያ ቤርታ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዑፃ ዬያጉዲ ፑርታ ባኣዚ'' ማዼያኬ።» ");
INSERT INTO mdybse_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«ዒንሢ ዖርጎጫ ጋዓንቴ ዒንሢ ኮዔ ባኮ ቢያ ሃሢ ዴንቄያ ማዔሢሮ ዒንሢና ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ዒንሢ ሃሢ ሚሽኬ ዓሳ ሃጊ ዒንሢ ናይዻንዳሢሮ ዒንሢና ባዴዔ! ዒንሢ ሃሢ ሚኢጫ ዓሳ ሃጊ ዒንሢ ዖዪ ዬኤካንዳሢሮ ዒንሢና ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«ዓሳ ጉቤ ዒንሢ ጋላቲ ዒንሢ ዛሎ'' ኮሺ ባኣዚ'' ኬኤዛቶ ዒንሢና ባዴዔ! ዔያቶኮ ዓዶንሢያ ሉኡቂ ፆኦሲ ማሊፆ ኬኤዛኔ ጋዓ ዓሶ ዬያይዲናኣኮኬ።» ");
INSERT INTO mdybse_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ዒንሢ ዋይዛዞንሢም ጋዓንቴ ታ ሂዚ ጋዓኔ፦ ዒንሢኮ ሞርኮ ናሽኩዋቴ፤ ዒንሢ ዒፃ ዓሶም ኮሺ ማዹዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ዒንሢም ጋዳንቃዞንሢ ዓንጁዋቴ፤ ዒንሢም ፑርቲሲ ዻባዞንሢም ሺኢቁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ፔቴ'' ጋንጋሮ ባዓሢም ባጎ ጋንጋሮ ሺርሹዋቴ፤ ዑፃ ኔ ማኣዔ ማኣዓሢ ኔኤኮ ዔካኒ ኮዓሢም ዴማ'' ኔ ማኣዔሢያ ቃሲ'' ዒንጌ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ኔና ሺኢቃሢም ቢያ ዒንጌ፥ ኔ ባኣዚ'' ማዔያ ዔካሢ ኔኤም ማሃንዳጉዲ ዖኦጪፖ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ዓሳ ዒንሢም ማዻንዳጉዲ ዒንሢ ኮዓ ባኮ ዒንሢ ዬያጉዲ ዔያቶም ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ዒ'ንሢ ናሽካዞንሢ ዒንሢ ናሽኬቴ ዓይጎ ባሼ ባኣዚ'' ዒንሢ ዴንቃንዳይ? ጎሞ ዓሳ ፔና ናሽካዞንሢ ናናሽካኣዋይ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ዒንሢም ኮሺ ባኣዚ'' ማዼዞንሢም ሌሊ ኮሺ ባኣዚ'' ዒንሢ ማዼቶ ዓይጎ ባሼ ባኣዚ'' ዒንሢ ዴንቃንዳይ? ጎሞ ዓሳ ዬያጉዲ ማማዻኣዋይ! ");
INSERT INTO mdybse_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ኑም ማሃንዳኔ ጌዒ ጉሙርቃ ዓሶንሢም ሌሊ ዒንሢ ታልዔቶ ዓይጎ ባሼ ባኣዚ'' ዒንሢ ዴንቃንዳይ? ዬያጉዲ ዔያታ ታልዔዞንሢ ማሂ ዔካኒ ጎሞ ዓሳ ጎሞ ዓሶም ታልዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ዒንሢ ጋዓንቴ ዒንሢኮ ሞርኮ ናሽኩዋቴ፤ ኮሺ ባኣዚ''ያ ዔያቶም ማዹዋቴ፤ «ታልዖ ኑኡኮ ማሃንዳኔ» ጌይ ዎዛ ጌሡዋዖ ታልዑዋቴ፤ ዬያ ዒንሢ ማዼቶ ዒንሢም ዒንጎንዶ ባካ ዼኤፒ ማዓንዳኔ፤ ፑኡፖ ፆኦዛሢ ናይያ ዒንሢ ማዓንዳኔ፤ ዒዚ ማዺንቴ ባኮሮ ጋላቱዋዞንሢና ፑርቶንሢማኣ ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ዒንሢኮ ጫሪንጮ ዓዳሢ ሚጪንታያ ማዔሢሮ ዒንሢያ ዓሲ ሚጪንታያ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«ዓሲኮ ዻቢንቲ ኮይ ሺሪፖቴ፤ ፆኦሲያ ዒንሢ ዻቢንቶሮ ሜቶ ዒንሢም ዒንጋዓኬ፤ ዖጊዳኣ፦ ‹ዒ ፑርታኬ› ጌዒ ዎጊፖቴ፤ ዒንሢ ዑፃኣ ፆኦሲ ዎጋዓኬ፤ ዒንሢም ዻባሢም ዓቶም ጎዑዋቴ፤ ዒንሢማኣ ፆኦሲ ዓቶም ጋዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ዓሲም ዔኤቢ ዒንጉዋቴ፥ ዒንሢማኣ ፆኦሲ ዒንጋንዳኔ፤ ዒንሢ ማካ'' ባኮና ዬያጉዲ ፆኦሲ ዒንሢም ማካንዳኔ፤ ዬያይዳፓ ዑሣ ቃራ ማኮ ባኣዚ''ና ቱቺ፥ ጫርጊ ላኣሊንታንዳያ ሄላ''ንዳኣና ማኪ'' ዒንሢም ዒዚ ዒንጋንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ሄሊ''ሳዖ ዬሱሴ ሂዚ ጌይ ማላታና ዔያቶም ኬኤዜኔ፦ «ዓኣፒ ባይቄያ ሜሌ'' ዓኣፒ ባይቄ ዓሲ ጎቺ ሃንታኒ ዳንዳዓ? ዬያጉዲ ማዼቶ ላምዖንሢ ዎሊ ዔኪ ዔቴይዳ ሎኦማንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ሃጊ ዔራ ናዓሢ ዔርዛሢዳፓ ባሹዋሴ፤ ጋዓንቴ ሃጊ ዔራ ናዓሢ ዔርዞ ባኮ ጋፒሲ ዔሬያ ማዔቶ ፔኤኮ ዔርዛሢጉዲ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«ኔኤኮ ዓኣፖይዳ ዓኣ ዼኤፖ ቡኡሮ ኔ ዛጉዋዖ ዓይጎሮ ዓሶ ዓኣፖይዳ ዓኣ ዻኮ'' ቡኡሮ ኔ ዛጋይ? ");
INSERT INTO mdybse_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ሃሣ ኔ ዓኣፖይዳ ዓኣ ዼኤፖ ቡኡሮ ዛጉዋዖ ሜሌ''ሢ ኮራ ‹ታ ዒሻሢዮ፥ ሂንዳ ታ ኔኤኮ ዓኣፓ ዓኣ ቡኡሮማ ኬሶ''ም› ዎይቲ ኔ ጋዓይ? ኔ ጎኦቦ'' ማላሢ ቤርታዺ ኔ ዓኣፖይዳ ዓኣ ዼኤፖ ቡኡሮ ኬሴ''፤ ዬካፓ ሜሌ''ሢ ዓኣፓ ዓኣ ዻኮ'' ቡኡሮ ኔ ዴንቂ ኬሳ''ኒ ዳንዳዓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«ኮሺ ሚሢ ፑርታ ዓኣፒ ዓኣፑዋሴ፤ ዬያጉዲ ፑርታ ሚሢ ኮሺ ዓኣፒ ዓኣፑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ሚሢ ቢያ ዓኣፓፓ ዔርታኔ፤ ጋኣላንሣይዳፓ ሻኣቢ ዓኣፒ ማንፂንቱዋሴ፤ ዬያጉዲ ሃሣ ጋውዲዳፓ ኩንቱሩሼ ማንፂንቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ዬያሮ ኮሺ ዓሲ ፔኤኮ ኮዦ ዒኖይዳፓ ኮሺ ባኣዚ'' ኬሳ''ኔ፤ ፑርታ ዓሲያ ፑርቶ ዒኖይዳፓ ፑርታ ባኣዚ'' ኬሳ''ኔ። ዓሲ ፔ ዻንጎና ኬኤዛሢ ዒኖ'' ኩሚ ኬስኬሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ታኣኒ ዒንሢም ኬኤዛሢ ዒንሢ ኩንሡዋሴ፤ ሂዳዖ ዓይጎሮ ዒንሢ ‹ታ ጎዳሢዮ! ታ ጎዳሢዮ!› ጌዒ ታና ዔኤላ''ይ? ");
INSERT INTO mdybse_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ሃንጋ ታ ባንሢ ሙካሢና ታ ጋዓሢያ ዋይዚ ኩንሣሢ ዖና ማላቴያ ታ ዒንሢም ኬኤዞም፤ ");
INSERT INTO mdybse_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ዬይ ዔቶ'' ኮሺ'' ጌልዚ ቦኦኪ ዾቂ፥ ማኣሮ ዶዶ ላሎይዳ ቦኦኮልቄ ዓሢ ማላኔ፤ ዲጲ ሙኪ ዬኖ ማኣሬሎ ሂዔኔ፤ ጋዓንቴ ኮሺ'' ቦኦኪንቲ ዶዲ ቤስካ ማዢንቴሢሮ ዓጊሣኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ታ ጋዓ ባኮ ዋይዚ ኩንሡዋኣሢ ጋዓንቴ ዶዲ ቦኦኮላ ባኣያ፥ ማኣሮ ሺኢቺ ሳዓይዳ ካኣሺ ዾቂ ማዤ ዓሲ ማላኔ፤ ዲጲ ሙኪ ዬኖ ማኣሬሎ ሂዔ ዎዶ''ና ቤዞና ጋፒ ዶዔኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ዬሱሴ ዬያ ቢያ ዴሮ''ም ኬኤዚ ጋፒሴስካፓ ቂፒርናሆሜ ካታሞ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ዒኢካ ፔቴ'' ሮሜ ዓጪ ዓሲ ማዔያ፥ ፄኤታ ፖኦሊሴ ዓይሣስኬይ ዓኣኔ። ዒዚ ሚርጌ ናሽካ፥ ዒዛም ዓይሢንቲ ማዻስኬይ ኮሺ'' ሃርጊንቲ ሃይቃኒ ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ፄኤቶ ፖኦሊሶ ዓይሣሢ ዬሱሴ ዛሎ'' ዋይዜ ዎዶ''ና ዓይሁዶ ዓሶኮ ጪሞ ኮራ፦ «ሃዳራቴ፥ ዬሱሴ ሙኪ ታኣኮ ማዻሢ ፖዒሳንዳጉዲ ዒዛ ታኣም ሺኢቁዋቴ» ጌዒ ዔያቶ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ዔያታ ዬሱሴ ባንሢ ዓኣዻዖ፦ «ዬያ ዒዛም ኔ ማዻኒ ኮይሳ ዓሲኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ዒዚ ኑኡኮ ዴሮ'' ናሽካያኬ፤ ዬያሮ ኑኡኮ ቡኪንቶ ቤሲያ ዒ ኑም ማዤኔ» ጌይ ዶዲሺ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ዬያሮ ዬሱሴ ዬንሢ ዓሶንሢና ዎላ'' ዓኣዺ፥ ፄኤቶ ፖኦሊሶ ዓይሣሢኮ ማኣሮ ሄላ''ኒ ዑካዛ ላሚ ሃሣ ፄኤቶ ፖኦሊሶ ዓይሣሢ ዒዛኮ ላጌስኬንሢ ዬሱሴ ኮራ፦ «ጎዳሢዮ! ታኣኒ፡ ኔ ታ ማኣሪ ጌላንዳ ዓሲቱዋኣሢሮ ታ ኮይላ'' ሙኪ ላቢ''ፖ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ታኣኒያ ኔ ኮይላ'' ሙካኒ ዳንዳዓ ዓሲቱዋሴ፤ ዬያሮ ኔኤኒ ዬካ ዓኣዖ ዻንጋና ሌሊ ዓይሤቴ ታኣኮ ማዻሢ ፖፖዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ታኣኒ ታ ቶኦኪና ዎይሣ ዓሶም ዓይሢንታያታዖ ታኣኮ ዴማ'' ታ ዓይሣ ፖኦሊሴ ዓኣኔ። ዬያሮ ዔያቶይዳፓ ፔቴ''ሢ ‹ዴንዴ› ታ ጋዓዛ ዴዴንዳኔ፤ ባጋሢ ሃሣ ‹ሃኒ ሙኬ› ታ ጋዓዛ ሙሙካኔ፤ ታኣም ማዻሢማኣ ‹ሃያ ማዼ› ታ ጋዓዛ ማማዻኔ» ሂዚ ጌዒ ኬኤዙዋቴ ጌይ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ዬሱሴ ዬያ ዋይዛዖ ዲቃቲ ሄርሺ ዒዛ ጊንፆ ሙካ ዴሮ'' ባንሢ ሺሪ፦ «ዒስራዔኤሌይዳታዖ ሃያጉዴ ጉሙርቂሢ ፔቴ''ታዖ ታ ዴንቂባኣሴ፤ ታ ዒንሢም ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ዒዛ ኮይላ'' ዳኪንቴ ዓሶንሢ ፄኤቶ ፖኦሊሶ ዓይሣሢ ማኣሮ ባንሢ ማዔ ዎዶ''ና ዒዛኮ ማዻሢ ፖዒ ዓኣንቴ ዔያታ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ዬማፓ ኔጉዋዖ ዬሱሴ ናይኔ ጌይንታ ፔቴ'' ካታማስኬኖ ዒዛኮ ጊንፆ ሃንታዞንሢና ሜሌ'' ሃሣ ሚርጌ ዴሬና ዎላ'' ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ዬሱሴ ካታሜሎ ጌላ ካሮ'' ዑካዛ ዓሳ ሌሲ'' ኬዲ ካታማ''ፓ ኬስካኔ። ዬይ ሓይቄ ናዓሢ ዒንዶኮ ፔቴ''ኬ። ዒንዴላኣ ዓኒ ሓይቄያ ዜኤሪንዶኬ፤ ሓሣ ዬኖ ካታሜሎይዳፓ ሚርጌ ዓሲ ዒዞና ዎላ'' ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ጎዳሢ ዒዞ ዛጋዖ ዒዞ ሚጪንቲ፦ «ዔናኣሬ፥ ዬኤኪፖ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ዬካፓ ዬሱሴ ቤርቲም ዴንዳዖ ኪንቺሎ ኩቻ ሄላ''ዛ ኬዴ ዓሳ ዔቄኔ፤ ዬሱሴ ዒማ''ና፦ «ሃይ ኔ ዼጌሢ ዔቄ ታ ኔና ጋዓኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ሓይቄሢያ ዬማና ዔቂ ዴዒ ጌስቲሢ ዓርቄኔ፤ ዬካፓ ዬሱሴ ዒንዴሎም፦ «ሓይሾ ኔኤኮ ናዓሢ» ጌዒ ዒንጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ዬያሮ ቢያሢ ዒጊቹሞ ዓርቄም፦ «ኑ ባኣካ'' ፑኡፒ ፆኦሲ ማሊሢ ኬኤዛያ ዔቄኔ፤ ፆኦሲያ ፔ ዴሮ'' ዻቂሻኒ ሙኬኔ» ጌዒ ጌዒ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ዬሱሴኮ ሱ'ንፃ ዪሁዳ ዓጫ'' ሃሣ ኮይሎ ዓጮ'' ቢያይዳ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ዮሓኒሴኮ ጊንፆ ሃንታዞንሢ ዬሱሴ ማዼ ባኮ ቢያ ዮሓኒሴም ኬኤዜኔ፤ ዒዚያ ዒዛኮ ጊንፆ ሓንታዞንሢዳፓ ላምዖንሢ ዔኤሊ''፦ ");
INSERT INTO mdybse_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","« ‹ሙካንዳኔ› ጌይንቴ ሜሲሔ ኔናሞ ሜሌ'' ኑ ካፖንዶይ? ጌዒ ዒዛ ዖኦጩዋቴ» ጌይ ዬሱሴ ባንሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ዔያታ ዬሱሴ ኮራ ዓኣዻዖ፦ « ‹ሙካንዳኔ› ጌይንቴ ሜሲሔ ኔናሞ ሜሌ'' ኑ ካፖንዶይ? ጌይ ዒዛ ዖኦጩዋቴ ጌዒ ማስካ ዮሓኒሴ ኔ ኮራ ኑና ዳኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ዬሱሴ ዬማና ዓሶ ዱማ ዱማ ዶርዖና ፑርታ ሓርጌናይዳፓ ፓሤኔ፤ ፑርቶ ዓያኖዋ ኬሴ''ኔ፤ ሃሣ ሚርጌ ዓኣፖ ባይቄ ዓሶኮዋ ዓኣፖ ቡሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ዬሱሴ ሙኬ ኪኢቶ'' ዓሶንሢም፦ «ማዒ ዴንዲጋፓ ዮሓኒሴም ዒንሢ ዛጌ ባኮና ዋይዜ ባኮዋ ሂዚ ጌይ ኬኤዙዋቴ፦ ዓኣፖ ባይቄ ዓሳ ዛጋኔ፤ ዎቦ ዓሳ ፒኪ ሃንታኔ፤ ዑፃ ኬስካ ዶርዓሢና ዓኣ ዓሳ ዻቃኔ፤ ዋዮ ባይቄ ዓሳ ዋይዛኔ፤ ሃሣ ሃይቄ ዓሳ ዔቃኔ፤ ማንቆ ዓሶማኣ ኮዦ ሃይሳ ኬኤዚንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","‹ጎኔሞ ሉኡዚዳይ?› ጌዒ ታ ዛሎ''ና ዹቂንቱዋኣሢ ዓንጂንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ዮሓኒሴ ኮራፓ ሙኬ ኪኢቶ'' ዓሶንሢ ማዒ ዴንዴሢኮ ጊንፃፓ ዬሱሴ ዮሓኒሴ ዛሎ'' ዴሮ''ም ሂዚ ጌዒ ኬኤዚሢ ዓርቄኔ፦ «ዒንሢ ሃካ ዓሲ ናንጉዋ ዳውሎ'' ዓይጎ ዛጋኒ ሙኬይ? ዢባራ ዓጊሣ ዱሮ'' ፒሎ'' ዛጋኒዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ሃሣ ዒንሢ ዓይጎ ዛጋኒ ኬስኬይ? ጉኡፂሲ ሱኪ ዹይሶና ዓፒሎ ማኣዔ ዓሲ ዛጋኒዳ? ዬያጉዴ ዓፒሎ ማኣዒ፥ ፔና ኮሺ'' ናንጋ ዓሳ ካኣቶ'' ማኣራ ዓኣኔ! ");
INSERT INTO mdybse_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ሂዴቶ ዓይጎ ዒንሢ ዛጋኒ ኬስኬይ? ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ዛጋኒዳ? ሂዮ ጎኔኬ፥ ፔቶ'' ዬያ ፆኦሲ ማሊፆ ኬኤዛሢዳፓ ባሼሢ ዛጋኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ዒዚያ ‹ቤርታ ቤርታ ዴንዲ ጎይፆ ኔኤም ጊኢጊሻ ታኣኮ ኪኢቶ'' ናዓሢ ታ ዳካንዳኔ› ጌይንቲ ዒዛ ዛሎ'' ፃኣፒንቴሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ሳዖይዳ ሾይንቴ ዓሶይዳፓ ቢያ ዮሓኒሴፓ ባሻይ ዖኦኒያ ባኣሴ፤ ፆኦሲ ካኣቱሞ ጋራ ዓኣ ዓሶ ባኣካ'' ዓሲኬ ጌይንቱዋኣሢ ጋዓንቴ ዒዛፓ ባሼኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ዬያ ዔያታ ዋይዜ ዎዶ''ና ዴራ'' ቢያ፤ ኮርሞ ዓሶፓ ሚኢሾ ቡኩሳ ዓሳኣ ዓቱዋዖ ዮሓኒሴ ኮራ ቤርታ ዋኣፆ ማስቴሢሮ ፆኦሲ ማዻ'' ፒዜ ማዔሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ፔርሴ ዓሶና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ጋዓንቴ፦ «ዮሓኒሴ ኮራ ኑ ማስታዓ» ጌዒ ፆኦሲ ማሊፆ ዒፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ሄሊ''ሳዖ ዬሱሴ፦ «ዓካሪ ሃያ ዎዶ'' ዓሶ ዓይጎና ታ ማላታንዳይ? ዓይጎ ዔያታ ማላይ? ጌዔቶ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ዓሳ ቡካ ጶኦካ'' ዴዒ ዓማላ'' ናኣቶ'' ማላኔ፤ ዔያታ ዎሊ ዔኤሊ'' ዔኤሊ'' ‹ዎዛ ዓይኑሞ ኑ ዒንሢ ዋይዚሴኔ፤ ዒንሢ ጋዓንቴ ኮርጊባኣሴ፤ ቃዮ ኑ ቃዬኔ፥ ዒንሢ ጋዓንቴ ዬኤኪባኣሴ› ጋዓዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ዬያጉዲ ማስካ ዮሓኒሴ ሙዖ ሃሾ ዳምቦ ካፓዛ ሃሣ ማሣ ዎይኖ ዑዦዋ ዑሽኩዋዖ ሙካዛ ‹ፑርታ ዓያና ዒዛይዳ ዓኣኔ› ዒንሢ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ዓሲኮ ናዓሢ ሙዒ ሙዒ ሃሣ ዑሽኪ ዑሽኪ ሙካዛ ‹ሃይ ሃሣ ሙኡዚ''ና ማሣ ዑሺና ናሽካያ፥ ኮርሞ ዓሶፓ ሚኢሾ ቡኩሳዞንሢና ጎሞ ዓሶናኮ ላጌኬ› ዒንሢ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ጋዓንቴ ፆኦሲ ዔራቶኮ ፒዙማ ፆኦሲም ዓይሢንታ ዓሶ ዛሎ''ና ፔጋዺ ዔርታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ፔቴ'' ፔርሴ ዓሲስኬይ ዬሱሴ ሙኡዚ'' ሙዓንዳጉዲ ዔኤላ''ዛ ዬሱሴ ዬያ ዓሢ ማኣሪ ጌሊ ሙዓኒ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ዬኖ ካታሜሎይዳ ፔቴ'' ጎሜና ዓኣ፥ ላኣሊስኬና ዓኣኔ፤ ዬሱሴ ፔርሴ ዓሢ፥ ሲሞኦኔ ማኣሮይዳ ሙዖም ዔኤሊ''ንቴሢ ዒዛ ዋይዛዖ ሳውቃ ቲሺ ሹቺ ቢልቃፄና ኩንሢ ዔኪ ሙኪ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ዬሱሴኮ ጊንፆ ዛሎ''ና ቶኮ'' ዓጫ ዔቂ፥ ዬኤኪ ዬኤኪ ዒዛኮ ቶኮ''ዋ ፔ ዓቢፆና ማስኪ ፔኤኮ ቶኦኮ'' ጋሞና ዑጫኔ፤ ሃሣ ቶኮ'' ዒዛኮ ሄርቂያ ሄርቂ ሳውቃ ቲዦናኣ ቲሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ሙዖ ዒዚ ሙዖም ዔኤሌ'' ፔርሴ ዓሢ ዬያ ዛጌ ዎዶ''ና፦ «ሃይ ዓሢ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ማዔቴ፥ ሃና ዒዛኮ ዑፆ ፒፃ'' ላኣሌላ ዖና ማዔቶ ሃሣ ዎዚጉዴ ጎሜና ዓኣያ ማዔቴያ ዔሬያናንዳኔ» ጌይ ፔ ዒኖና ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ዬሱሴያ ፔርሴ ዓሢ ኮይላ''፦ «ሲሞኦኔ! ፔቴ'' ታ ኔኤም ኬኤዛ ባኣዚ'' ዓኣኔ» ጌዔኔ። ዒዚ፦ «ዔርዛሢዮ! ሂንዳ ታኣም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ዬሱሴያ ሂዚ ጌዒ ሃይሶ ኬኤዚሢ ዓርቄኔ፦ «ፔቴ'' ዓሲዳፓ ሚኢሼ ታልዔ ላምዖ ዓሲ ዓኣኔ፤ ፔቴ''ሢ ዶንጎ ፄኤታ ኬሊ'' ማዾ ማዼም ዒንጊንታ ቢራ፤ ባጋሢ ሃሣ ዶንጊታሚ'' ኬሊ'' ማዾ ማዼም ዒንጊንታንዳ ቢራ ታልዒ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ላምዖንሢ ዔያታ ታልዒ ዔኬ ሚኢሾ ጪጎ ባሺንቴም ታልዔሢ ዔያቶኮ ጋሎ'' ማሂሱዋዖ ሃሼ''ኔ፤ ዓካሪ ጋሎ'' ዓሶ ላምዖንሢዳፓ ዎይ ባሼ ታልዔ ዓሢ ናሽካንዳያ ማላይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ሲሞኦኔያ፦ «ሚርጌ ጋላ'' ዓቴ'' ዓሢ ባሼ ዒዛ ናሽካንዳያ ማላኔ» ጌይ ማሄኔ። ዬሱሴ፦ «ኔ ጌዔሢ ጎኔኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ዬካፓ ዬሱሴ ላኣሌሎ ባንሢ ሺራዖ፦ «ሃኖ' ላኣሌሎ ኔ ዛጋ? ታ ኔ ማኣሪ ጌላዛ ኔኤኒ ታ ቶኮም ዋኣሢታዖ ዒንጊባኣሴ፤ ዒዛ ጋዓንቴ ቶኮ ታኣኮ ፔኤኮ ዓቢፆና ማስኪ ፔ ቶኦኮ'' ጋሞና ዑጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ታ ኔ ኮይላ'' ጌላኣና ኔ ታና ሄርቂባኣሴ፤ ዒዛ ጋዓንቴ ታ ኔ ማኣሪ ጌሌሢዳፓ ዓርቃዖ ታኣኮ ቶኮ ሄርቂፆ ሃሺ''ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ኔኤኒ ታኣኮ ቶኦኮ'' ዛይቶ ቲዦናታዖ ቲሽኪባኣሴ፤ ዒዛ ጋዓንቴ ታኣኮ ቶኮ ሳውቃ ቲዦና ቲሽኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ሚርጌ ጎማ ዒዞኮ ዓቶም ጌይንቴሢሮኬ ሚርጌና ዒዛ ናሽኬሢ፤ ታ ኔኤም ጋዓኔ። ጎማ ዻካ'' ዓቶም ጌይንቴሢ ጋዓንቴ ናሽካሢያ ዻካ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ዬካፓ ዬሱሴ ላኣሌሎ ኮራ፦ «ኔኤኮ ጎማ ዓቶም ጌይንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ዒዛና ዎላ'' ሙዓ ዓሳ፦ «ጎሜ ዓቶም ጋዓሢ ሃይ ዎዚ ዓሲዳይ!» ጌዒ ጌዒ ፔ ዒኖና ማሊሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ዬሱሴ ጋዓንቴ ላኣሌሎ ኮራ፦ «ኔኤኮ ጉሙርቂፃ ኔና ዻቂሼኔ፤ ኮሺ ዓኣዼ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ዬካፓ ዬሱሴ ካታሞና ጉርዶናይዳ ፆኦሲ ካኣቱሞ ኮዦ ሃይሶ ኬኤዚ ኬኤዚ ዓኣዻኣና ታጶ ላምዖ ዒዛኮ ጊንፆ ሃንታዞንሢያ ዒዛና ዎላ'' ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ዬያጉዲ ሃሣ ፑርቶ ዓያና'' ኬስኬም ፖዔዞንሢና ሜሌ'' ዶርዓሢዳፓኣ ፖዔ ላኣላ ዬሱሴ ጊንፆ ዓኣዻኔ፤ ዔያታ፦ ላንካይ ፑርታ ዓያና ኬስኬ ማይራማ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ሄሮዲሴ ማኣራ ዓኣ ዓሶ ዓይሢ ዎይሣ ኩዛ ጎዖሢ ማቻ ዮሃናንታ ሶሲና ጎዖዞንታ ሜሌ'' ሚርጌ ላኣሊያ ዓኣኔ፤ ዬንሢ ላኣሎንሢ ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ፔኤኮ ሚኢሾ ዒንጊ ማኣዳ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ሚርጌ ዴሬ ካታማፓ ካታማፓ ሙኪ ዬሱሴ ኮራ ቡኪንታዛ ዬሱሴ ኮኦኪንሢና ሂዚ ጌይ ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«ፔቴ'' ጎሺ ጎሽካ ዓሲ ዜርሢ ዜርቃኒ ኬስኬኔ፤ ዒዚ ዜርቃኣና ፔቴ'' ፔቴ'' ዜርፃ ጎይፆ ዓጫ ኬዲ'' ሄ'ርቂንቴኔ፤ ካፒያ ሙዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ዛሎ'' ዜርፃ ሃኣሻ ሳዓይዳ ኬዲ''፥ ባቃሌ ዎዶ''ና ሳዖኮ ሚርጌ ዎዑሞ ባኣሢሮ ባቃላ'' ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ዓቴ'' ዜርፃ ሃሣ ዓንጊሢ ቶሻ ባኣካ ኬዳ''ዛ ዓንጊፆ ቶሻ'' ዎላ'' ዑጊ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ሜሌ'' ዜርፃ ጋዓንቴ ኮሺ ሳዓይዳ ኬዲ'' ባቃሌኔ፤ ባቃላ''ኣ ዑጊ ፔቴ'' ፔቴ''ሢ ሚርጌ ዺቢ ዓኣፒ ዓኣፔኔ።» ዬካፓ ዬሱሴ፦ «ዋይዛሢ ኮሺ'' ዋይዞንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ዒዛኮ ጊንፆ ሃንታዞንሢ ዬሱሴ ኮራ፦ «ዬኖ ኮኦኪንሤሎኮ ቡሊ''ፃ ዓይጌንዴዳይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ዬሱሴ ዔያቶም ማሃዖ፦ «ዒንሢም ፆኦሲ ካኣቱሞ ዛሎ''ኮ ዓኣሺንቴ ባኮ ዔሪሢ ዒንጊንቴኔ፤ ሜሌ''ዞንሢም ጋዓንቴ ቢያ ባኣዚ'' ኮኦኪንሢና ኬኤዚንታኔ፤ ዓይጎሮ ጌዔቶ ዔያታ ዛጋያታዖ ዒና ዔኩዋጉዲ፥ ዋይዛያታዖ ጶቂሡዋጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ኮኦኪንሦኮ ቡሊ''ፃ ያዺኬ፦ «ዜርፃ ፆኦሲ ቃኣሎ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ጎይፆ ዓጫ ኬዴ'' ዜርፃ ዻዋሢ' ቃኣሎ'' ዋይዛ ዓሶኬ፤ ጋዓንቴ ዔያታ ጉሙርቂ ጎናሲ ዻቁዋጉዲ ፃላሄ ሙኪ ቃኣሎ'' ዔያቶኮ ዒና''ፓ ዔካኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ሃኣቾ ዓጮ''ይዳ ኬዴ'' ዜርፃ ዻዋሢ' ቃኣሎ'' ዋይዚ ዎዛና ዔካዞንሢኬ፤ ጋዓንቴ ዔያታ ጉሙርቂ ጎናሲ ዔካሢ ዻካ'' ዎዴምኬ፤ ፃጲ ዔያቶኮ ባኣሢሮ ሜታ ሄሌ'' ዎዶ''ና ቤዞና ዔያታ ሃሻ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ዓንጊፆ ቶሾ ባኣካ'' ኬዴ'' ዜርፃ ዻዋሢ ቃኣሎ'' ሃሣ ዋይዛ ዓሶንሢኬ፤ ጋዓንቴ ሃያ ዓጮ'' ማሊፆና ቆሎ''ና ሃሣ ሳዖ ናንጎ ኮሹማ ዒኖ ዓርቂ ዓኣፒ ባኣያ ዬያቶ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ኮዦ ሳዖይዳ ኬዴ'' ዜርፃ ዻዋሢ' ጋዓንቴ ኮሺ ሃሣ ፒዜ ዒናና ቃኣሎ'' ዋይዚ ካፓዞንሢኬ፤ ዬንሢ ቃኣሎ''ና ዶዲ፥ ዓኣፖ ዓኣፓዞንሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ዬካፓ ሃሣ ዬሱሴ፦ «ፖዒ ፖዒሲ ጉኡፒ ዓኣቻያና ሃሣ ሻኣላ'' ዴንካ ጌሣ ዓሲ ባኣሴ። ዬያይዲፆፓ ማኣሪ ጌላ ዓሳ ፖዖ ዛጋንዳጉዲ ዼ'ጌ ሻርናይዳ ጌሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«ዬያጉዲ ፔጋዹዋዖ ሓሣ ዔርቱዋዖ ዓኣሺንቲ ዓታንዳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«ዬያሮ ዒንሢ ዎማይዲ ዋይዛንዳቴያ ዒንሢና ዔሩዋቴ፤ ዓይጎሮ ጌዔቶ ዔኤቢ ዓኣ ዓሲም ቃሲ'' ዒንጊንታኔ፤ ባኣሢዳፓ ጋዓንቴ ‹ታኣኮ ዓኣኔ› ጌዒ ዒ ማላ ዻኮ''ማኣ ዓይሱዋዖ ዒዛይዳፓ ዔኪንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ዬሱሴኮ ዒንዶና ጌርሲንሢና ዒዚ ዓኣ ቤዞ ሙኬኔ፤ ጋዓንቴ ዴሮ'' ሚርጉሞፓ ዔቄያና ዔያታ ዒዛ ዴንቃኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ዬያሮ፦ «ኔኤኮ ዒንዶና ጌርሲንሢና ዙላ'' ዔቂ ኔና ዛጋኒ ኮዓኔ» ጌዒ ዓሳ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ዬሱሴ ማሃዖ፦ «ፆኦሲ ቃኣሎ'' ዋይዚ ኩንሣዞንሢ ቢያ፥ ዬንሢ' ታኣኮ ዒንዶና ጌርሲንሢናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ፔቴ'' ኬሊ''ና ዬሱሴ ፔኤኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዋኣፆና ፒንቆ ጎንጎ ቶጋዖ፦ «ባዞ''ኮ ሶ ሱኮ ኑ ፒንቆም» ጋዓዛ፥ ዔያታ ዴንዳኒ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ዔያታ ባዞ'' ዑፆይዳ ዓኣዻኣና ዬሱሴ ጊንዔኔ፤ ዬማና ዎልቄና ዓኣ ባዚ'' ጉዳ ባዞ''ይዳ ዔቄኔ። ዋኣፃ ጎንጎ ጋሮ ኩሚሢ ዓርቄሢሮ ቢያሢ ካራ ባይዚ ሜታዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ዬያሮ ዒዛኮ ጊንፆ ሃንታዞንሢ ላሚ ላሚ፦ «ዔርዛሢዮ! ኑ ኩዴኔ!» ጌዒ ዬሱሴ ጴቼኔ። ዒዚ ጴጫዖ ዢባሮና ጉዳሢና ጎራ''ዛ ዢባሮንታ ጉዳሢንታ ቤዞና ዚቲዮ ጌዔም ፔቴ''ታዖ ዓጊፃ ባኣዚ'' ባኣያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ዒንሢኮ ጉሙርቂፃ ዋኣዳዖ?» ጌዔኔ። ዔያታ ጋዓንቴ ሚርጌና ዒጊጬስካፓ ሄርሺ ዲቃታዖ ዎሊ ኮይላ''፦ «ዢባሮና ጉዳሢና ዓይሣኔ፤ ዔያታኣ ዒዛም ዓዓይሢንታኔ፤ ካኣ! ሓይ ዓይጎ ዓሲዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ዬካፓ ዔያታ ባዞ''ና ፒንቂ ጌሊላ ሱኮ''ይዳ ዓኣ ጌርሴኖኔ ዓጮ'' ሄሌ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ዬሱሴ ዋኣፆና ፒንቆ ጎንጋፓ ሳዓ ኬዳ''ዛ ፑርታ ዓያና ዓኣ ፔቴ'' ዓሲ ካታማ''ፓ ኬስኪ ዒዛና ካኣሜኔ፤ ዬይ ዓሢ ፔኤኮ ማኣዓሢ ኬኤሪ፥ ጉሪ ሃንታንቴ ሚርጌ ዎዴ ማዔያኬ፤ ዒዚ ናንጋሢ ዱኡፒ ካይዚዳኬ፥ ማኣሪዳቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ዒዚ ዬሱሴ ዴንቂ ዒላቲ ዬሱሴ ቤርታ ሎኦማዖ ዑኡዞ ዼ'ጊዲ፦ «ኔኤኒ ፑኡፖ ፆኦዛሢ ናዓሦ፥ ዬሱሴ! ታኣና ዎላ'' ኔኤኮ ዓይጎ ዒጊንቶ ዓኣይ? ሃዳራ ታና ሜታሲፖ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ዬያ ዒ ጌዔሢ ዬሱሴ ፑርቶ ዓያናሢ ዓሢዳፓ ኬስካንዳጉዲ ዓይሤሢሮኬ። ዬያኮ ቤርታ ፑርቶ ዓያናሢ ዓሢ ዑፆይዳ ሚርጌ ዎዴ ዔቃያኬ፤ ዬያሮ ዒዛኮ ቶኮ''ና ኩጮና ካኒ ቢራታና ዓንጊ ዱፄና ቱኡቲ ቱኡቲ ካፒንታያ ማዔቶዋ ካኖ ቢራቶዋ ዱኡዚ ዓንጎ ዱፆዋ ሜንሢሲ ዓሲ ናንጉዋ ዳውሎ'' ዒዛ ዔኪ ዔኪ ዴንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ዬሱሴ፦ «ሱንፃ ኔኤኮ ዖናዳይ?» ጌዒ ዖኦጫዛ፥ ዒዚ ሚርጌ ፑርታ ዓያና ዒዛይዳ ቡኪ ዓኣሢሮ፦ «ሱንፃ ታኣኮ ዴሬኬ» ጌዒ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ፑርቶ ዓያና'' ዬሱሴ ኮራ፦ «ሓዳራ ጋፒንፃ ጴዹዋ ዔቶ'' ዼኤፖ ኑና ዳኪፖ» ጌዒ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ዬኖ ቤዞይዳ ዓኣ ዹኮ'' ጎኦባ'' ዓሲኮ ቆሎ ሚርጌ ጉዱንሢ ሄንቃንቴ ፑርቶ ዓያና''፦ «ሴኬ ጉዱንፆይዳ ኑ ጌላንዳጉዲ ኑና ዓይሤ» ጌዒ ዬሱሴ ሺኢቃዛ፥ ዔያታ ጌላንዳጉዲ ዒ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ዬያሮ ፑርቶ ዓያና'' ዓሢዳፓ ኬስኪ ጉዱንፆይዳ ጌላዛ ጉዱንፃ ዎሊ ዑፃ ዲርጊ ማጎ ዓኣዻዖ ባዞ''ይዳ ጌሊ ሙይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ጉዱንፆ ሄንቃ ናኣታ'' ዬያ ባኮ ዛጋዖ ጳሽኪ ዴንዲ ካታሞና ዙሎ''ናይዳ ሚርጌና ሓይሶ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ዓሳ ዬያ ባኮ ዛጋኒ ፔ ማኣራፓ ኬስኪ ዬሱሴ ባንሢ ሙካንቴ፥ ፑርቶ ዓያና'' ኬስኬ ዓሢ' ዒና'' ዒዛኮ ማዔም ዓፒሎ ፔኤኮ ማኣዒ ዬሱሴኮ ቶኮ'' ዴማ'' ዴዒ ዓኣንቴ ዔያታ ዴንቂ ዒጊጬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ዓኣፖና ዛጌ ማርኮ ማዔ ዓሶንሢ ፑርቶ ዓያና'' ዓኣ ዓሢ ዎማይዲ ዻቄቶዋ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ዬካፓ ጌርሴኖኔ ዓጮ'' ዓሳ ቢያ ዬሱሴ ዔያቶኮ ዓጫ''ፓ ዴንዳንዳጉዲ ዒዛ ሺኢቄኔ። ዬያ ዔያታ ጌዔሢ ሚርጌና ዒጊጬሢሮኬ። ዬያሮ ዬሱሴ ዋኣፆና ፒንቆ ጎንጎ ቶጊ፥ ዎንዴ ሙኬ ቤዞ ባንሢ ዴንዳኒ ዔቃዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ፑርቶ ዓያና'' ኬስኬ ዓሢ ዬሱሴ ኮራ፦ «ሓዳራ፥ ታ ኔ ጊንፆ ሙኮም» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ዬሱሴ ጋዓንቴ፦ «ኔ ማኣሪ ዓኣዺጋፓ ፆኦሲ ኔኤም ማዼ ባኮ ቢያ ኬኤዜ» ጌዒ ዒዛ ዳካዛ፥ ዓሢ ዬሱሴ ዒዛም ማዼ ፑኡፖ ባኮ ካታሞይዳ ቢያ ኬኤዚ ኬኤዚ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ዴራ'' ዒዛ ቢያ ካፒ ዓኣሢሮ ዬሱሴ ማዒ ሙካኣና ቢያሢ ዒዛ ዎዛና ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ዒማ''ና ፔቴ'' ዓይሁዶ ዓሳ ቡኪንታ ቤዞኮ ሱኡጌ ማዔ፥ ዒያዒሮሴ ጌይንታ ዓሲ ሙኪ ዬሱሴኮ ቶኮ'' ዴማ'' ሎኦሚ፦ «ሓዳራ፥ ታ ማኣሪ ሙኬ» ጌዒ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ዓይጎሮ ጌዔቶ ዒዛኮ ታጶ ላምዖ ሌዔ ማዔ ናይስኬና ሓርጊንቲ ሃይቃኒ ዑኪ ዓኣሢሮኬ። ዬያሮ ዬሱሴ ዒዛና ዎላ'' ዴንዳንቴ፥ ዒዛና ዎላ'' ዓኣዻ ሚርጌ ዓሳ ቱቺ ዒዛ ሜታሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ዒማ''ና ታጶ ላምዖ ሌዔ ጉቤ ሱጉሢ ሾኦቲ ሜታሳ ፔቴ'' ላኣሊስኬና ዓኣኔ፤ ዒዛ ፔኤኮ ዓኣ ሚኢሾ ጉቤ ዼኤሾ ዔራ ዓሶም ዒንጊ ጋፒሴቶዋ ዖኦኒያ ዒዞ ዻቂሻኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ዬና ላኣሌላ ዬሱሴ ባንሢ ሙኪ ጊንፆ ዛሎ''ና ዑኪ ዒዛኮ ዓፒሎ ዓጮ ሄላ''ዛ ቤዞማና ዒዞኮ ሾኦታ'' ሱጉፃ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ዬሱሴ ዒማ''ና፦ «ዖ ታና ካኣሜይ?» ጌዒ ዖኦጬኔ። ቢያሢ፦ «ኑ ኔና ሄሊ''ባኣሴ» ጋዓዛ፥ ጴፂሮሴ ማሃዖ፦ «ዔርዛሢዮ! ዴራ'' ቱቺንቲ ኔ ጊንፆ ዓኣዻሢ ኔ ዛጉዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ዬሱሴ ጋዓንቴ፦ «ታጊዳፓ ዎልቄ ኬስኬሢ ታ ዔራሢሮ ጎኔ፤ ፔቴ'' ዓሲ ታና ካኣሜኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ላኣሌላ ዓኣሺንታኒ ዳንዳዒባኣሢ ዔራዖ ጎጋይቂ ጎጋይቂ ዒዛኮ ቶኮ'' ዴማ'' ሎኦሜኔ፤ ዬካፓ ዒዛ ዓይጎሮ ካኣሜቶዋ ሃሣ ዎማይዲ ዒዛ ቤዞና ፖዔቶዋ ዴሮ'' ቢያ ቤርታ ፔጋሲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ዬሱሴያ፦ «ታ ናዔሌ! ኔ ጉሙርቂፃ ኔና ፖዒሴኔ፤ ኮሺ ዴንዴ» ዒዞም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ዬሱሴ ዬያ ሃጊ ኬኤዛ ጎይሣ ዓኣንቴ ፔቴ'' ዓሲ ዓይሁዶኮ ቡኪንቶ ቤዞ ሱኡጋሢ፥ ዒያዒሮሴ ማኣራፓ ሙኪ ዒያዒሮሴ ኮራ፦ «ናዔላ ኔኤኮ ሓይቄኔ፤ ማይ ዔርዛሢ ጉሪ ላቢ''ሲፖ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ዬሱሴ ጋዓንቴ ዬያ ዋይዛዖ ዒያዒሮሴ ኮራ፦ «ኔኤሮ ዒጊጪፖ፥ ጉጉሙርቄ፤ ናዔላ ኔኤኮ ዻቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ዬሱሴ ዬማና ዒያዒሮሴ ማኣሪ ሄላ''ዖ ጲፂሮሴና ዮሓኒሴና ያይቆኦቤና ሃሣ ናዔሎኮ ዓዶና ዒንዶናፓ ዓታዛ ሜሌ'' ዖኦኒያ ዒዛና ዎላ'' ጋሮ ጌላንዳጉዲ ኮዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ዒኢካ ዓኣ ዓሳ ቢያ ናዔሎ ዛሎ'' ዖዪ ዬኤፒዳ ዓኣንቴ ዬሱሴ ዔያቶም፦ «ዬኤኪፖቴ፤ ናዔላ ጊጊንዓንዳፓዓቴም ሃሃይቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ዔያታ ጋዓንቴ ናዔላ ሃይቄሢ ዔሬሢሮ ቢያሢ ዒዛ ቦሂ፥ ሚኢጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ዬሱሴ ናዔሎኮ ኩጮ ዓርቃዖ፦ «ዓንቆ፥ ዔቄ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ዒዛ ሼምፓሢ ዒዞኮ ማዔሢሮ ቤዞማና ላዓ ጌዒ ዔቃዛ፥ ዬሱሴ፦ «ዒዛ ሙዓንዳ ባኣዚ'' ዒዞም ዒንጉዋቴ» ጌዒ ዔያቶ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ናዔሎኮ ዓዶና ዒንዶና ዲቃቲ ሄርሼኔ፤ ዒዚ ጋዓንቴ፦ «ሃያ ባኮ ዖኦማኣ ኬኤዚፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ዬሱሴ ታጶ ላምዖ ዳኪንቴዞንሢ ዒዛ ባንሢ ዔኤላ''ዖ ፑርቶ ዓያኖ ቢያ ኬሳ''ንዳያ ሓሣ ዱማ ዱማ ዶርዖዋ ፖዒሳንዳ ዎልቄና ቢታንቶና ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ፆኦሲ ካኣቱሞ ዛሎ'' ዓሶም ቢያ ኬኤዛንዳጉዲ፥ ሃርጊንቴ ዓሶዋ ፖዒሳንዳጉዲ ዔያቶ ዳካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","«ዒንሢኮ ጎይፆም ማዓ ባኣዚ'' ዓይጎዋ ዔኪፖቴ፤ ኮኦሎ'' ማዔቶዋ፥ ጋላታቶዋ፥ ጋላ ዓርቆ ሉካ''ታቶዋ፥ ሚኢሼታቶዋ፥ ዒንሢ ማኣዔ ዓፒላፓ ሜሌ'' ማኣዖዋ ዔኪፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ሾኦቹሞና ዒንሢ ጌላ ማኣሮይዳ ዬኖ ጉርዴሎይዳፓ ኬስኪ ዓኣዻንዳያ ሄላ''ንዳኣና ዒኢካ ዴዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ዓሳ ዒንሢ ሾኦቺንሢ ዔኩዋያ ማዔቶ ጋዓንቴ ዬኖ ጉርዴሎ ሃሺ'' ኬስካዖ፥ ቶካ''ፓ ዒንሢኮ ሲላሎ ፒፂ'' ዓኣዹዋቴ፤ ዬይ ዔያቶም ‹ዒንሢና ዔሩዋቴ› ጋዓ ማርካቶ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ዬያሮ ዳኪንቴዞንሢ ዬካፓ ኬስኪ ኮዦ ሃይሶ ዔርዚ ዔርዚ፥ ሃርጊንቴ ዓሶዋ ፖዒሲ ፖዒሲ ጉርዶ ቢያይዴና ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ጌሊላ ዓጮ'' ዎይሣ፥ ሄሮዲሴ ዬሱሴ ማዼ ባኮ ቢያ ዋይዜሢሮ ጎዖንዶ ጎይሢ ባይዜኔ፤ ዓይጎሮ ጌዔቶ ፔቴ'' ፔቴ'' ዓሳ፦ «ማስካ ዮሓኒሴ ሃይቦ''ይዳፓ ዔቄኔ» ጌዒ ጌዒ ጌስታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ዬያጉዲ ሃሣ ፔቴ'' ፔቴ'' ዓሳ፦ «ፆኦሲ ማሊፆ ኬኤዛ ዔኤሊያሴ ማዒ ሙኬኔ» ጋዓዛ፥ ዓቴ'' ዓሳ ሃሣ፦ «ሚና ፆኦሲ ማሊፆ ኬኤዛዞንሢዳፓ ፔቴ'' ሃይባ''ፓ ዔቄኔ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ሄሮዲሴ ፔ ዛሎ''ና፦ «ታኣኒ ዮሓኒሴኮ ቶኦኮ'' ቲቂሴንቴ፥ ሂዳዖ ሃያ ቢያ ባኮ ማዻኔ ጌይንቲ ኬኤዚንታሢ ዒ ዖናዳይ?» ጌዒ ዛጋኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ዳኪንቴዞንሢ ዳኪንቴ ቤዛፓ ማዒ ሙካዖ ማዼ ባኮ ቢያ ዬሱሴም ኬኤዜኔ። ዒማ''ና ዒዚ ዔያቶ ዱማሲ ዔኪ ቤቴሳይዳ ጌይንታ ካታሞ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ዓሳ ዬሱሴ ዓንካ ዓኣቶዋ ዔራዖ ዒዛ ጊንፆ ሙካዛ፥ ዒዚ ዔያቶ ዔኪ ፆኦሲ ካኣቱሞ ዛሎ'' ዔርዜኔ። ዶርዓሢዳፓኣ ፖዓኒ ኮዔ ሃርጊንቴ ዓሶዋ ፖዒሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ሳዓ ዓማ''ኒ ጋዓኣና ታጶ ላምዖንሢ ዬሱሴ ኮራ ሙካዖ፦ «ኑኡኒ ዓኣ ቤዛ ዓሲ ናንጉዋ ዳውሎ''ይዳኬ፤ ዬያሮ ዓሳ ሃካ ኮይሎ''ይዳ ዓኣ ካታሞና ካታሞ ዙላ'' ዓኣ ጉርዶ ዴንዲ ሙዖ ባኣዚ''ና ዎርቆ ቤሲና ኮይ ዴንቃንዳጉዲ ዓሶ ዳኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ዬሱሴ ጋዓንቴ፦ «ዒንሢ፥ ዔያታ ሙዓንዳ ባኣዚ'' ዒንጉዋቴ» ጋዓዛ፥ ዔያታ ማሃዖ፦ «ኑኡኮ ዓኣዞንሢ ዶንጎ ካሣና ላምዖ ሞሎና ሌሊኬ፤ ዬያሮ ኑ ዓኣዺ ካሣ ሻንቂባኣያታቶ ሃያ ዴሮ''ም ቢያ ጊዳዓኬ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ዒማ''ና ዓቲንቆኮ ሚርጉማ ዶንጎ ሺያ ማዓያኬ። ዬካፓ ዬሱሴ ጊንፆ ሃንታዞንሢም፦ «ዓሶ ዶንጊታሚ'' ዶንጊታሚ'' ማሂ ፓቂ ዴይሡዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ጊንፆ ሃንታ ናኣታ'' ዒዚ ዔያቶ ዓይሤሢጉዲ ዓሶ ዴይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ዬካፓ ዬሱሴ ዶንጎ ካሦንሢና ላምዖ ሞሎንሢና ዔኪ ሌካ ጫሪንጮ ዼ'ጊ ጌዒ ዛጋዖ ፆኦሲ ጋላቲ፥ ቡንፄስካፓ ዓሶም ዔያታ ዒንጋንዳጉዲ ዒዛኮ ጊንፆ ሃንታዞንሢም ዒንጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ቢያሢ ሙይ ሚሽካዛ፥ ዒዛኮ ጊንፆ ሃንታዞንሢ ዓቴ'' ዶንቦ ታጶ ላምዖ ዳልጊ ሌማቴ ኩሙሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ፔቴ'' ኬሊ'' ዬሱሴ ፔኤሮ ሌሊ ሺኢቂቤቃ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ኮራ ዓኣሢሮ፦ «ዓሳ ታና ዖናኬ ጋዓይ?» ጌይ ዔያቶ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ዔያታ ማሃዖ፦ «ፔቴ'' ፔቴ'' ዓሳ፥ ‹ማስካ ዮሓኒሴኬ› ዛላ'' ሃሣ ‹ዔኤሊያሴኬ› ኔና ጋዓኔ፤ ዓቴ'' ዓሳ ሃሣ ‹ሚና ቤርታ ፆኦሲ ማሊፆ ኬኤዛዞንሢዳፓ ፔቴ'' ሃይባ''ፓ ዔቄኔ› ጋዓሢያ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ዒንሢ፦ «ታና ዖናኬ ጋዓይ?» ጌይ ዔያቶ ዖኦጫዛ፥ ጴፂሮሴ ማሃዖ፦ «ኔኤኒ ፆኦሲ ኔና ዳኬ፥ ሜሲሔኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ዬሱሴያ ዬያ ዔያታ ዖኦማኣ ኬኤዙዋጉዲ ላቲ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ዬካፓ ሃሣ ዬሱሴ ፔኤኮ ጊንፆ ሃንታ ናኣቶ''ም፦ «ዓሲኮ ናዓሢ ሚርጌ ሜቶ ዔካንዳያ ኮይሳኔ፤ ጪሞና ቄኤሶኮ ሱኡጎና ሃሣ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳኣ ዒዛ ቦሂ ሃሻ''ንዳኔ፤ ሃሣ ዎዺያ ዎዻንዳኔ፤ ማዔቶዋ ሃይሣሳ ኬሎ''ና ሃይባ''ፓ ዔቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ቢያሢም ሃሣ፦ «ታ ጊንፆ ሙካኒ ናሽካያ ዓኣቶ ፔና ሃሾ''ንጎ፤ ቢያ ኬሊ'' ሃይቢ ሄላ''ንዳኣና ጊኢጌያ ማዒ ታ ጊንፆ ሃንቶንጎ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ፔ ናንጎ ዓይሳኒ ኮዓሢ ቢያ ፔ ናንጎ ባይዛንዳኔ፤ ታ ጋይቴ ጌዒ ፔ ናንጎ ዓኣሢ ዒንጋሢ ጋዓንቴ ፔ ናንጎ ዓይሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ዓሲ ዓጮ''ይዳ ዓኣ ቆሎ ቢያ ዴንቃዖ ናንጎ ፔኤኮ ባይዚ ሓሣ ጉሪ ዓታያ ማዔቶ ዓይጎ ፓሣንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ታኣና ታ ቃኣሎ''ና ዛሎ'' ኬኤዛኒ ቦርሲንታሢዳ ቢያ ዓሲኮ ናዓሢ ፔ ቦንቾና ሃሣ ፔ ዓዶ ቦንቾና ዬያጉዲ ጌኤዦ ኪኢታንቾ ቦንቾና ሙካ ዎዶ''ና ዒዛይዳ ቦርሲንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃሢ ሃይካ ዒንሢ ባኣካ''ፓ ፆኦሲ ካኣቱሞ ዛጋንዳያ ሄላ''ንዳኣና ሃይቂንዱዋ ፔቴ'' ፔቴ'' ዓሲ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ዬሱሴ ዬያ ባኮ ኬኤዜሢኮ ሳሊ'' ኬሊ''ኮ ጊንፃ ጲፂሮሴና ዮሓኒሴና ያይቆኦቤና ዔኪ ሺኢቃኒ ፔቴ'' ዹካ'' ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ዒዚ ሺኢቃንቴ ዓውካራ ዒዛኮ ላኣሚንቲ ዓፒላ''ኣ ዒዛኮ ቦኦሪ፥ ዓኣፓ ዱካያ ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ዬማና ዔርቲባኣንቴ ላምዖ ዓሲ ሙኪ ዒዛና ዎላ'' ጌስታኔ። ዬንሢያ ሙሴና ዔኤሊያሴናኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ቦንቾና ጴዺ ዒዛና ዔያታ ጌስታሢ' ዬሱሴ ዬሩሳላሜይዳ ሃይቂ ፆኦሲ ማሊፆ ኩንሣንዳሢ ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ዬማና ጴፂሮሴና ዒዛኮ ላጎንሢና ጊንዓ ባሼም ላሂ ዓኣኔ። ጋዓንቴ ዔያታ ጴጪ ዬሱሴ ፔ ቦንቾና ፖዒ ዓኣንቴ ዴንቄኔ፤ ሃሣ ዬያጉዲ ዒዛና ዎላ'' ዓኣ ላምዖ ዓሶንሢያ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ላምዖ ዓሶንሢ ዬሱሴ ኮራፓ ዱማዺ ዓኣዻዛ ጴፂሮሴ ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ኑም ሃይካ ዴዒፃ ኮሺኬ፤ ዬያሮ ፔቴ'' ኔኤም፥ ፔቴ'' ሙሴም፥ ፔቴ'' ሃሣ ዔኤሊያሴም ማዓያ ሃይሦ ዉዲ ኑኡኒ ማዦም» ጌዔኔ። ጴፂሮሴ ዬያ ጋዓኣና ዒ ጋዓ ባኮ ዔሩዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ጴፂሮሴ ዬያ ኬኤዜ ጎይሣ ዓኣንቴ ሻኣሬ ሙኪ ዔያቶ ባይዜኔ፤ ዬይ ሻኣራ ዔያቶ ባይዛዛ ዔያታ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ሻኣሮ ባኣኮ''ይዳፓ፦ «ታኣኒ ዶኦሬ፥ ታ ናዓሢ ሃያኬ፤ ዒዚ ጋዓሢ ዋይዙዋቴ» ጋዓ ዑኡሲ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ዑኡዛ ዋይዚንቴሢኮ ጊንፃ ዬሱሴ ፔኤሮ ሌሊ ዓቲ'' ጴዼኔ፤ ዬንሢ ዒዛና ዓኣ ጊንፆ ሃንታዞንሢ ዔያታ ዛጌ ባኮ ቢያ ዒማ''ና ዖኦማኣ ኬኤዙዋዖ ዚቲዮ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ዚሮ ጉቴ''ሎ ዬሱሴና ሃይሦ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዹካ''ፓ ኬዳ''ዛ ሚርጌ ዓሲ ዬሱሴና ካኣሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ዓሶ ባኣኮ''ይዳፓ ፔቴ'' ዓሲስኬይ፦ «ዔርዛሢዮ! ሓይ ናዓሢ ታኣኮ ፔቴ'' ሌሊኬ፤ ሃዳራ ታኣም ዛጌ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ሃኣዛጌ፥ ዒዛ ፑርታ ዓያና ዓርቂ ዔሩዋንቴ ዒላሣኔ፤ ሳዖይዳኣ ሎንሢ ዻንጎና ዱባሲ ዱባሲ ባርዲሳኔ፤ ዑፆዋ ዒዛኮ ኪፃሲ ኮሺ'' ሜታሴስካፓ ሓሻ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ዬያ ፑርቶ ዓያናሢ ኬሳ''ንዳጉዲ ኔኤኮ ጊንፆ ሃንታዞንሢ ታ ዖኦጬንቴ ዔያታ ኬሳ''ኒ ዳንዳዒባኣሴ» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ዬሱሴ ማሃዖ፦ «ዒንሢ ጉሙርቁዋ፥ ሃይ ዎቦ ሾይንታ! ታ ዒንሢና ዎላ'' ዓይዲ ሄላ''ንዳኣና ናንጋንዳይ? ሃሣ ዓይዲ ሄላ''ንዳኣና ታ ዒንሢ ጊቢ'' ዳንዳዓንዳይ? ሂንዳ ኔኤኮ ናዓሢ ሃኒ ዔኪ ባዔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ናዓሢ ዬሱሴ ባንሢ ዑኬ ዎዶ''ና ፑርቶ ዓያናሢ ናዖ ሳዓ ሎንሢ ባርዲሳኣና ዬሱሴ ፑርቶ ዓያናሢ ጎሪ''፥ ናዓሢያ ዻቂሺ ዓዳሢም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ዴራ'' ቢያ ፆኦሲኮ ዼኤፖ ዎልቆ ዛጌሢሮ ዲቃቲ ሄርሼኔ፤ ዓሳ ቢያ ማዺንቴ ባኮና ዲቃቲ ሄርሺፆይዳ ዓኣንቴ ዬሱሴ ዒዛኮ ጊንፆ ሃንታ ናኣቶ''ም፦ ");
INSERT INTO mdybse_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«ሓያ ታ ዒንሢም ኬኤዛ ቃኣሎ'' ዒና ዔኪ ማሉዋቴ፤ ሓይሾ ዓካሪ ዓሲኮ ናዓሢ ዓሶ ኩጫ ዓኣሢ ዒንጊንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ዔያታ ጋዓንቴ ዬያ ዒ ጌዔ ባኮ ዔሪባኣሴ፤ ፆኦሲ ዔያቶም ዒ ጌዔ ባካ ዎዚ ጌይሢታቴያ ዓኣቼሢሮ ዒ ጌዔ ባካ ዔያቶም ጌሊባኣሴ፤ ጋዓንቴ ዒዛ ዖኦጫኒ ዔያታ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ዒዛኮ ጊንፆ ሃንታ ናኣታ''፦ «ኑጊዳፓ ቢያ ባሼሢ ዖናዳይ?» ጌዒ ዎላ'' ማርሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ዬሱሴ ጋዓንቴ ዔያቶኮ ዒኖ'' ማሊፆ ዔራዖ ፔቴ'' ናይ ዔኪ ሙኪ ፔ ኮይላ'' ዔቂሲ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«ሓያ ናዖ ታ ሱንፆና ቦንቺ ዔካሢ ቢያ ታና ዔካኔ፤ ታና ቦንቺ ዔካሢያ ቢያ ታና ዳኬሢያ ዔካኔ። ዒንሢ ባኣካ''ፓ ቢያ ባሼ ሂርኬ ማዓ ዓሢ ዒዚ ቢያይዳፓ ባሼ ማዓንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ዬካፓ ዮሓኒሴ ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ፔቴ'' ዓሲ ኔ ሱንፆና ፑርታ ዓያና ኬሳ''ንቴ ኑ ዛጌኔ፤ ጋዓንቴ ዒ ኑኡና ዎላ'' ኔ ዓሲ ማዒባኣሢሮ ዒዚ ኬሱ''ዋጉዲ ኑ ላኣጌኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ዬሱሴ ማሃዖ፦ «ዒንሢ ማኪ፥ ዒፁዋኣሢ ቢያ ዒንሢና ዎላ''ታሢሮ ሃሹ''ዋቴ፥ ላኣጊፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ዬሱሴ ሌካ ጫሪንጮ ዔውታ ኬላ'' ዑኬ ዎዶ''ና ዬሩሳላሜ ባንሢ ዓኣዻኒ ማሊ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ዒዛኮ ቤርታ ቢሪ ዓኣዻንዳ ኪኢታ ዓሲያ ዳኬኔ፤ ዔያታ ቢያ ባኣዚ'' ጊኢጊሻኒ ሳማሪያይዳ ዓኣ ፔቴ'' ጉርዳ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ጋዓንቴ ዬኖ ጉርዴሎ ዓሳ ዒዛ ሾኦቺንሢ ዔካኒ ኮዒባኣሴ፤ ዓይጎሮ ጌዔቶ ዒዚ ዬኖ ዓጮ''ና ጌዒ ዬሩሳላሜ ዓኣዻንዳሢ ዔያታ ዔሬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ዒዛኮ ጊንፆ ሃንታ፥ ያይቆኦቤና ዮሓኒሴና ዬያ ዛጌ ዎዶ''ና፦ «ጎዳሢዮ! ጫሪንቺዳፓ ታሚ ኬዲ'' ሃንሢ ዓሶንሢ ሙዓንዳጉዲ ኑ ዓይሦም?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ዬሱሴ ጋዓንቴ ዔያቶ ባንሢ ሺሪጋፓ፦ «ዒንሢም ዎዚጉዴ ዓያና ዒንጊንቴቶዋ ዒንሢ ዔሩዋሴ፤ ዓሲኮ ናዓሢ ሙኬሢ ዓሲ ዓዓይሳኒ ማዓንዳኣፓዓቴም ባይዛኒቱዋሴ» ጌይ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ዬካፓ ዔያታ ዔቂ ሜሌ'' ጉርዳ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ጎይፆ ዓኣዺፆይዳ ዓኣንቴ ፔቴ'' ዓሲ ዬሱሴ ኮራ፦ «ታኣኒ ኔ ዓኣዻ ቤዞ ቢያ ኔኤና ዎላ'' ዓኣዻኒ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ዬሱሴ ዒዛም ማሃዖ፦ «ዉኡካሢኮ ዔቴ ዓኣኔ፤ ካፖኮ ሃሣ ዎርቆ ማኣሪ ዓኣኔ፤ ዓሲ ናዓሢ ጋዓንቴ ላሂ ሃውሻንዳ ቤሲታዖ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ባጋሢም ሃሣ፦ «ታ ጊንፆ ሙኬ» ጋዓዛ፥ ዓሢ ጋዓንቴ «ጎዳሢዮ! ቤርታዺ ታ ዴንዲ ዓዶ ዱኡኪ ሙኮም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ዬሱሴ ማሃዖ፦ «ሓይቄ ዓሳ ሃይቄ ዓሶ ዱኡካንዳጉዲ ሃሼ''፤ ኔኤኒ ጋዓንቴ ዓኣዺጋፓ ፆኦሲ ካኣቱሞ ዛሎ'' ዔርዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ሃሣ ፔቴ'' ሜሌ'' ዓሲስኬይ፦ «ታ ጎዳሢዮ! ታ ኔ ጊንፆ ሙካኒ ኮዓኔ፤ ጋዓንቴ ቤርታዺ ታ ማኣሮ ዓሶ ሳራሢ ታ ዬዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ዬሱሴ፦ «ጌማይ ጎሽካኣና ዙርጎ ዓርቃዖ ጊንሢም ዛጋ ዓሲ ፆኦሲ ካኣቱሞም ማዓ ዓሲቱዋሴ» ጌይ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ጎዳ ዬካፓ ሜሌ'' ላንካይታሚ'' ላምዖ ዓሲ ዶኦሪ፥ ዒዚ ዴንዳኒ ማላ ካታሞና ቤዞና ቢያ ዔያታ ቤርታዺ ዓኣዻንዳጉዲ ላምዖ ላምዖ ማሂ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ሂዚያ ዔያቶም ጌዔኔ፦ «ቡኩሶንዶ ሃኣካ ሚርጌኬ፥ ሃኣኮ ቡኩሳ ዓሳ ጋዓንቴ ዻካ''ኬ፤ ዬያሮ ሃኣኮኮ ዓዴ ሃኣኮ ቡኩሶ'' ማዾ''ም ቃሲ'' ሜሌ'' ማዻ ዓሲ ዳካንዳጉዲ ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ዓካሪ ዓኣዹዋቴ፥ ታ ዒንሢ ማራይጉዲ ያኣያሢ ባኣኮ'' ዳካኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ዒንሢ ጎይፆኮ ዓይጎ ባኣዚ''ያ ዓርቂፖቴ፤ ሚኢሼ ዓጎ ቡራሻ፥ ጋላ ዓርቆ ሉካ'' ማዔቶ ሃሣ ዱርሲ ማዔቶዋ ዔኪፖቴ፤ ዓሲና ዎላ'' ጎይፃ ካኣማዖ ዔኤሊ''ሢና ናጊፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ዒንሢ ጌላ ማኣራ ቢያ ቤርታዺ ‹ማኣሪ ዓሲዮ፥ ኮሹሞ ሃኖ' ማኣሮም ማዖም› ጎዑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ኮሹሞ ናሽካ ዓሲ ዬኖ ማኣራ ዓኣቴ ዒንሢ ጌዔ ኮሹማ ዔያቶም ማዓንዳኔ፤ ያዺ ማዒባኣያታቶ ዒንሢ ጌዔ ኮሹማ ጊንሣ ዒንሢም ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ማዾ'' ማዻ ዓሲም ማዻ ዛሎ'' ዒንጎ ባኣዚ'' ኮይሳኔ፤ ዬያሮ ዒንሢ ጌሌ ማኣሮይዳ ዒንሢም ሺኢሾና ባኮ ሙዒ ሙዒ ሃሣ ዑሽኪ ዑሽኪ ዒኢካ ዴዑዋቴ፤ ዬኖ ማኣራፓ ሜሌ'' ማኣሪ ሃንቲ ሃንቲ ሺሪፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ዎኖ ካታሞዋ ዒንሢ ጌላኣና ዓሳ ዒንሢ ሾኦጫሲ ዔካዖ ዒንጋ ባኮ ሙዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ዬኖ ካታሜሎይዳ ዓኣ ሃርጊንቴ ዓሶ ፓሡዋቴ፤ ዴሮ''ማኣ ‹ፆኦሲ ካኣቱማ ዒንሢ ባንሢ ዑኬኔ› ጌዒ ኬኤዙዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ጋዓንቴ ዎኖ ካታሞዋ ዒንሢ ጌላኣና ዓሳ ዒንሢ ዔኩዋያ ማዔቶ ካታሜሎኮ ዙሎ'' ኬስኪጋፓ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹ሃይሾ፥ ኑኡኮ ቶካ'' ዓኣ ሃኖ' ካታሜሎ ሲላሎ ኑ ዒንሢም ፒፃ''ኔ፤ ጋዓንቴ ፆኦሲ ካኣቱማ ዒንሢ ባንሢ ዑኬሢ ዔሩዋቴ› ዔያቶም ጎዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ጋፒንፆ ዎዶ''ና ፆኦሲ ዬኖ ካታሜሎም ዒንጋንዳ ዎጋ'' ቤርታ ሶዶሜ ካታሞ ሄሌ''ስካፓ ባሼ ማዓንዳኔ ታ ዒንሢም ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ዬካፓ ዬሱሴ፦ «ኮራዚኔ ጎዖዜ ኔና ባዴዔ፤ ቤቴሳይዳ ኔናኣ ባዴዔ፤ ዒንሢዳ ማዺንቴ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባካ ዎንዴ ፂሮሴና ሲዶናናይዳ ማዺንቴያታቶ ዒኢካ ናንጋ ዓሳ ሄኤዶ ሲዬ ፓቲሌ ማይንቲ፥ ቢዲንሢያ ቶኦካ ዋሂ ዬኖ ዎዶ''ና ጎሞ ቡኡፄያ ናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ዬያሮ ጋፒንፆ ዎጎ ኬሎ''ና ቤርታ ፂሮሴና ሲዶናናም ዒንጎናስካፓ ዒንሢ ሜታሢ ባሼ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ሃና'' ኔኤኒ ቂፒርናሆሜ ካታሜሌ፥ ሌካ ጫሪንጮ ሄላ''ንዳኣና ዼ'ጊ ጋዓኒ ኔ ኮዒያ? ማዔቶዋ ኔ ሊካ ሄሊ''ንቱዋ ዼኤፖ ዔቶ'' ኬዳ''ንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ላሚ ሃሣ ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ዒንሢም ዋይዛሢ ታኣም ዋይዛኔ፤ ዒንሢ ቦንቺ ዔኩዋኣሢ ታና ዔኩዋሴ፤ ታና ዔኩዋኣሢ ታና ዳኬሢያ ቦንቺ ዔኩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ላንካይታሚ'' ላምዖ ጊንፆ ሃንታዞንሢ ዳኪንቴ ቤዛፓ ሚርጌ ዎዛና ዬሱሴ ባንሢ ማዒ ሙካዖ፦ «ጎዳሢዮ! ኔ ሱንፆና ፑርቶ ዓያና'' ኑም ዓይሢንቲናኣኮቲ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ዬሱሴ ዔያቶም፦ «ፃላሄ ዜኤሊንሢጉዲ ጫሪንጫፓ ኬዳ''ንቴ ታ ዛጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ዬያሮ ዒንሢ ሾኦዦና ኮርናሢና ሄ'ርቃንዳጉዲ፥ ዒንሢ ሞርኮ ዒንሢ ባሻንዳጉዲ ቢታንቶ ዒንሢም ታ ዒንጌኔ፤ ዒንሢ ሄላ''ንዳ ባኣዚ'' ፔቴ''ታዖ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ጋዓንቴ ፑርቶ ዓያና'' ዒንሢም ዓይሢንቴሢሮ ዒንሢ ዎዛዻሢፓ ባሼ ሱንፃ ዒንሢኮ ጫሪንጮ ማኣራ ፃኣፒንቴም ፆኦሲ ዓሶ ባኣካ'' ዒንሢ ማዔሢሮ ዎዛዹዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ዬማና ዬሱሴ ዓያና ጌኤሺ ዒዛ ዎዛሴም፦ «ጫሪንጮና ሳዖናኮ ጎዳ ማዔ፥ ዓዳሢዮ! ሃያ ባኮ ኔኤኒ ዔሮ''ና ዼኤፖ ዓሶናይዳፓ ዓኣቺ ናይጉዲ ማዔ ዓሶም ፔጋሲ ዻዌሢሮ ታ ኔና ጋላታኔ፤ ሂዮ! ታ ዓዳሢዮ! ዬያይዳኒ ኔ ማሊሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«ቢያ ባኣዚ'' ታ ዓዶይዳፓ ታኣም ዒንጊንቴኔ፤ ናኣዚ'' ዖና ማዔቴ ዓዶይዳፓ ዓታዛ ሜሌ'' ዔራይ ባኣሴ፤ ዬያጉዲ ሃሣ ዓዴ ዖና ማዔቶ ናኣዚ''ዳፓ ዓታዛ ሃሣ ጊንሣ ናኣዚ'' ዒዛም ፔጋሲ ኬኤዛኒ ኮዔ ዓሲዳፓ ዓታዛ ሜሌ'' ዖኦኒያ ዔራይ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ዬካፓ ሃሣ ዬሱሴ ፔኤኮ ጊንፆ ሃንታዞንሢ ባንሢ ሺራዖ ዔያቶም ሌሊ፦ «ዒንሢ ሃያ ዛጋሢ ዛጋዞንሢ ኮሺ ባሊቲና ዓኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ጎኔና ሚርጌ ፆኦሲ ማሊፆ ኬኤዛዞንሢና ካኣቶ''ና ሃሢ ሃያ ዒንሢ ዛጋ ባኮ ዛጋኒ ሱኡካዼያታዖ ዔያታ ዛጊባኣሴ፤ ዒንሢ ዋይዛ ባኮዋ ዔያታ ዋይዛኒ ሱኡካዼኔ፤ ጋዓንቴ ዔያታ ዋይዚባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ፔቴ'' ኬሊ'' ሙሴ ዔርዜ ዎጎ ዔርዛ ፔቴ'' ዓሲስኬይ ዬሱሴ ኮራ ሙካዖ ዒ ዎዚ ጋዓቴያ ዛጋኒ ኮዒ፦ «ዔርዛሢዮ! ናንጊና ናንጊ ዴንቃኒ ዓይጌንዴ ማዻንዳያ ታና ኮይሳይ?» ጌይ ዒዛ ዖኦጫዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ዬሱሴ ማሃዖ፦ «ሙሴ ዔርዜ ዎጎይዳ ዓይጌ ፃኣፒንቴይ? ኔ ናባባዛ ዎዚ ጋዓይ?» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ዓሢ ማሃዖ፦ «ዎጋ'' ‹ፆኦሲ ኔ ጎዳሢ ጉቤ ዒናፓ፥ ጉቤ ሼምፓፓ፥ ጉቤ ዎልቃፓ፥ ጉቤ ማሊፃፓ ናሽኬ› ዬያጉዲ ሃሣ ‹ኔ ዓሺኖ ዓዳ'' ኔና ማሂ ናሽኬ› ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ዬሱሴያ ፒዜ ኔ ማሄኔ፤ «ዓካሪ ኔኤኒ ዬኖ ጎይፆ ማዼ፤ ናንጊና ናንጊያ ኔ ዴንቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ዎጎ ዔርዛሢ ጋዓንቴ ፔና ጌኤሺ ዓሲ ማሃኒ ኮዓዖ፦ «ያዺ ማዔቶ ታኣኮ ዓሺናሢ ዖናዳይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ዬሱሴ ዒዛም ማሃዖ፦ «ፔቴ'' ዓሲ ዬሩሳላሜፓ ዒያርኮ ኬዳ''ንቴ ጎይፆይዳ ሱላ ዒዛ ዴንቂ ዓፒሎ ዒዛኮ ቡሪ ዔኪ ጳርቄሢኮ ጊንፃ ሃይቃኒ ሳዛ ጋሽካንቴ ሃሺ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ዒዛ ቶኪጉዲ ፔቴ'' ቄኤሴስኬይ ዬኖ ጎይፄሎና ዓኣዺቤቃ ጳዺንቲ ላቢ''፥ ላሂ ዓኣ ዓሢ ዴንቄያታዖ ዚቲ ጌዒ ዒዛኮ ኮርሳ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ዬያጉዲ ሃሣ ቄኤሶ ፃጳፓ ማዔ ሌዊ ዜርሢስኬይ ዬኖ ጎይፆና ዓኣዺቤቃ ዬያ ዓሢ ዴንቄዖ ኮርሳ ዚቲ ጌዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ፔቴ'' ሳማሪያ ዓጪ ዓሲስኬያ ዬኖ ጎይፆና ዓኣዺቤቃ ጳዺንቴ ዓሢ ዴንቂ ሚጪንታዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ዓሢ ኮይላ'' ሙኪ ዛይቴ ቲሺና ዎይኔፓ ኮሾ''ና ዑሺና ኪፆይዳ ዓሢኮ ዋሂ ቱርጫና ማሪ ቱኬ''ሢኮ ጊንፃ ፔ ሃሮ'' ቶጊሲ ፔቴ'' ሾኦቺ ዎርቃ ማኣሪ ዔኪ ዓኣዼኔ፥ ዒኢካ ዒዛ ዒ ኮሺ'' ዛጊ ማይሤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ዚሮ ጉቴ''ሎ ፔቴ'' ዓሲ ላምዖ ኬሊ'' ማዾ ማዼም ጪጎንዶ ቢራጉዴያ ኬሲ'' ዬኖ ሾኦጮ ዎይሣ ማኣሮኮ ዓዶም ዒንጋዖ ‹ሃያ ዓሢ ታኣም ኮሺ'' ዛጊ ማይሤ፤ ጊዳ'' ቃሲ'' ኔ ዒዛ ዛሎ'' ጪጌ ባኣዚ'' ዓኣቶ ታ ማዒ ሙካዖ ኔኤም ማሂ ጪጋንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«ዓካሪ ዬንሢ ሃይሦንሢዳፓ ሱሎ''ና ጳዺንቴ ዓሢም ዓሺኖ ማዔሢ ዎያ ኔኤም ማላይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ዎጎ ዔርዛሢ «ዬያ ዒዛ ሚጪንቲ ማኣዴ''ሢሾ!» ጌዒ ማሃዛ፥ ዬሱሴ ማሃዖ፦ «ሂዴቶ ኔኤኒያ ዒማ ጎይፆ ማዼ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ጎይሢ ዓኣዺ ፔቴ'' ጉርዳስኬኖ ሄላ''ዛ ዒኢካ ማርታ ፔ ማኣራ ዒዛ ሾኦቺንሢ ዔኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ዒዞኮ ማይራሞ ጌይንታ ጌራ ዓኣኔ፤ ዒማ''ና ዬና ማይራማ ዬሱሴኮ ቶኮ'' ዴማ'' ዴዒ ዒዛኮ ጌኤዞ ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ማርታ ጋዓንቴ ሙዖ ጊኢጊሺፆና ሚርጌ ላባ''ዖ፥ ዬሱሴ ባንሢ ሙኪ፦ «ጎዳሢዮ! ሃና'' ታ ጌኤዳ ቢያ ማዾ'' ታኣም ሃሼ''ም ታኣኒ ታኣሮ ሌሊ ላባ''ሢ ኔ ዛጋዖ ዚቲ ጋዓ? ሃዳራ ታና ዒዛ ማኣዳ''ንዳጉዲ ዒዞም ኬኤዜቴራ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ጎዳ ዬሱሴ ጋዓንቴ ማሃዖ፦ «ማርታ! ኔኤኒ ሚርጌ ባኣዚ''ና ሜታዺ ጳሽኪ ሺራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ጋዓንቴ ኮይሳሢ ፔቴ'' ባኣዚ'' ሌሊኬ፤ ማይራማ ኮዦ ባኮማ ዶኦሬኔ፤ ዬማ ዒዞይዳፓ ዔካንዳያ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ፔቴ'' ኬሊ'' ዬሱሴ ፔቴ'' ቤሲዳ ሺኢቃኔ፤ ዒዚ ሺኢቂ ጋፒሳዛ ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ''ይ፦ «ጎዳሢዮ! ዮሓኒሴ ፔኤኮ ጊንፆ ሃንታዞንሢ ሺኢጲፆ ዔርዜሢጉዲ ኔኤኒያ ኑና ሺኢቂሢ ዔርዜቴራ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ዬሱሴያ፦ «ዒንሢ ሺኢቃዖ፥ ‹ጫሪንጫ ናንጋ ኑ ዓዳሢዮ! ሱ'ንፃ ኔኤኮ ቦንቺንቶም፤ ኔ ካኣቱማ ሙኮም፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ኬላ'' ኬላ'' ኑ ሙዓንዳ ሙኡዚ'' ዒንጌ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ኑም ዻቤሢም ኑ ዓቶም ጋዓሢጉዲ ኑ ዻቢንቶ ኑም ዓቶም ጌዔ፤ ዻቢሻኒ ጌሾያይዳ ኑና ጌልዚፖ› » ጎዑዋቴ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ዬካፓ ዬሱሴ ፔኤኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ኮኦኪንሢና፡ ዒንሢዳፓ ፔቴ''ሢኮ ላጌ ዓኣኔ ኑ ጎዖም፤ ዒዚ ሳዓ ጊዲሚሺ ማዓኣና ፔ ላጋሢ ማኣሪ ዓኣዺ ‹ዔኤዛይ! ሃዳራ ታኣም ሃይሦ ካሣ ታልዔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ፔቴ'' ታኣኮ ላጌ ማዔ ዓሲ ሃኬ ጎይሢዳፓ ሙኬም ታ ዒዛ ሙኡዛንዳ ካሣ ባይቄኔ› ዒዛ ኮራ ጌዔቶ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ዓካሪ ዬይ ላጋሢ ጋራ ዓኣዖ ‹ሃዳራ ታሚ ዋኣሢ ላሄም ሃያ ዎዴ ታና ሜታሲፖ፤ ዬያሮ ታ ዔቂ ኔ ኮዔ ካሦ ዒንጋኒ ዳንዳዑዋሴ› ጋዓንዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ጋዓንቴ ላጉሞ ዛሎ''ሮ ጌዒ ዔቂ፥ ዒንጋኒ ኮዒባኣቶዋ ዒዛ ሺኢቂ ሜታሳሢሮ ኮይሳሢ ቢያ ዒንጋንዳኔ፤ ታ ዒንሢም ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«ዬያሮ ታ ዒንሢም ሂዚ ጋዓኔ፦ ሺኢቁዋቴ ዒንሢም ዒንጊንታንዳኔ፥ ኮዑዋቴ ዒንሢ ዴንቃንዳኔ፥ ካራ'' ዔቂ ዔኤሉ''ዋቴ ዒንሢም ቡሊ''ንታንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ሺኢቃሢ ጉቤ ዔካንዳኔ፤ ኮዓሢያ ዴንቃንዳኔ፤ ካራ'' ዔቂ ዔኤሊ''ንታሢማኣ ቡሊ''ንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ዒንሢዳፓ ዓዶ ማዔ ዓሲ ናዓ ካሣ ሺኢቃዛ ሹቺ ዒንጋይ ዖናዳይ? ሞሎ ሺኢቄም ሾኦሺ ዒንጋ? ");
INSERT INTO mdybse_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ሃሣ ጱኡላ'' ሺኢቄም ኮርኖ ዒንጋ? ");
INSERT INTO mdybse_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ዒንሢ ፑርታታዖ ዒንሢ ናኣቶ''ም ኮሺ ባኣዚ'' ዒንጊ ዔራቶ፥ ጫሪንጫ ናንጋ ዒንሢኮ ዓዳሢ ዒንሢፓ ባሼ ዒዛ ሺኢቃዞንሢም ዓያኖ ጌኤዦ ዒንጋኒ ኮዓያኬ!» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ፔቴ'' ኬሊ'' ዬሱሴ ዻንጋ ባይቄ ዓሲስኬያይዳፓ ፑርታ ዓያና፥ ጌስቲሱዋያ ኬሳ''ንቴ ፑርቶ ዓያና'' ኬስካዛ ዻንጎ ባይቄሢ ጌስቲሢ ዓርቄም ዴራ'' ዬያ ባኮና ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ፔቴ'' ፔቴ''ዞንሢ ጋዓንቴ፦ «ፑርቶ ዓያኖ ዒዚ ኬሳ''ሢ ፑርቶ ዓያኖኮ ሱኡጋሢ ቢዔልዛቡሌናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ዓቴ''ዞንሢ ሃሣ ዬሱሴ ዎዚ ጋዓቴያ ዛጋኒ ኮዓዖ ጫሪንጮይዳፓ ዒዚ ኪሪስቶሴ ማዒፆ ዔርዛ ፔቴ'' ማላታ ማዓ ባኣዚ'' ዻዋንዳጉዲ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ዬሱሴ ጋዓንቴ ዔያቶኮ ማሊፆ ዔራዖ፦ «ፔቴ'' ካኣታ'' ዎሊፓ ፓቂንታያና ዖልታያና ማዔቶ፥ ዬያ ዓጮ'' ካኣቲ ባይቃንዳኔ፤ ዬያጉዲ ሃሣ ፔቴ'' ማኣሪ ዓሲ ዎሊም ዋይዚ ዒፂ ፓቂንቴቶ ባይቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ዓካሪ ፃላሄ ካኣታ'' ዎሊፓ ፓቂንታያና ዖልታያ ማዔቶ ዎዲ'' ዶዲ ዔቃኒ ዳንዳዓይ? ዒንሢ ጋዓንቴ ‹ዒዚ ፑርቶ ዓያኖ ኬሳ''ሢ ቢዔልዛቡሌናኬ› ታና ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ታኣኒ ፑርቶ ዓያኖ ቢዔልዛቡሌ ዎልቆና ኬሳ''ያ ማዔቶ ዒንሢኮ ዓሳ ዖኦና ፑርቶ ዓያኖ ኬሳ''ይ? ዬያሮ ዒንሢ ዓሳ ዒንሢ ዑፃ ዎጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ዓካሪ ታኣኒ ፑርቶ ዓያኖ ፆኦሲ ዎልቄና ኬሳ''ያ ማዔቶ ዬይ፡ ፆኦሲ ካኣቱማ ሙኬሢ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«ፔቴ'' ዎልቄና ዓኣ ዓሲ ዖልዚ ዓንጋሞ ዓርቂ ፔ ማኣሮ ካፓያ ማዔቶ ዒዛኮ ማኣራ ቡሪንታዓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ጋዓንቴ ዒዛይዳፓ ባሼ ዎልቄና ዓኣ ዓሲ ሙኪ፥ ዒዛ ባሼቶ ዒ ጉሙርቃ ዓንጋሞ ዒዛይዳፓ ዔኪ ዒዛኮ ዓኣ ባኮ ቢያ ቡሪ ሜሌ'' ዓሲማኣ ጊሽካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«ታኣና ዎላ'' ማዒባኣሢ ቢያ ታና ዒፃኔ፤ ታኣና ዎላ'' ማዒ ቡኩሲባኣሢ ላኣሊ ባይዛኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«ፑርታ ዓያና ዓሲዳፓ ኬስኬ ዎዶ''ና ጌሊ ሃውሾ ቤሲ ኮዒሢና ዋኣሢባኣ ዓሲ ናንጉዋ ዳውሎ'' ቢያ ሃንቲ፥ ሃውሺ ዴዓ ቤሲ ዴንቂባኣቶ ‹ታ ኬስኬ ማኣሮ ታኣኮ ታ ማዒ ዓኣዾም› ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ዬያሮ ማዒ ሙካኣና ዬና ቤዜላ ጌኤሽኪ ጊኢጊንቲ ዓኣንቴ ዴንቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ዬካፓ ዴንዲ ዒዛይዳፓ ባሼ ፑርታ ሜሌ'' ላንካይ ፑርታ ዓያና ዔኪ ሙኪ፥ ቤርታ ዒ ናንጋ ማኣራ ጌሊ ናንጋንዳኔ። ዓካሪ ዬያ ዓሢኮ ጋፒንፃ ሚና ቤርታኣሲዳፓ ባሼ ፑርታ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ዬሱሴ ዬያ ጌይ ኬኤዛኣና ፔቴ'' ላኣሊስኬና ዴሮ'' ባኣካ''ፓ ዑኡዞ ዼ'ጊዲ፦ «ኔና ሾዒ ዻንሢሤ፥ ዒንዴላ ዎዚ ዓንጂንቴያዳይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ዬሱሴ ጋዓንቴ፦ «ዓንጂንቴዞንሢ ፆኦሲኮ ቃኣሎ'' ዋይዚ ማዾይዳ ፔኤሻዞንሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ሚርጌ ዓሳ ሙኪ ዒዛ ኮይላ'' ቡካዛ ዬሱሴ፦ «ሃያ ዎዶ'' ዓሳ ማላታ ዛጋኒ ኮዓ ፑርታ ዓሲኬ፤ ጋዓንቴ ፆኦሲ ማሊፆ ኬኤዛ ዮናሴይዳ ማዺንቴ ማላታ''ፓ ዓታዛ ሜሌ'' ማላታ ዔያቶም ዒንጊንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ፆኦሲ ማሊፆ ኬኤዛ ዮናሴ ኔኔዌ ካታሞ ዓሶም ማላታ ማዔሢጉዲ፥ ዓሲኮ ናዓሢ ሃያ ዎዶ'' ዓሶም ማላታ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ዓባ'' ኬስኪ ጌላ ካሮ''ኮ ዾኦሎ'' ዛሎ'' ዓጫ''ፓ ሙኬ ካኣቴላ ጋፒንፆ ዎጎ ኬሎ''ና ዔቂ ዔያቶ ዑፃ ዎጋንዳኔ፤ ዓይጎሮ ጌዔቶ ዒዛ ሴሎሞኔኮ ዔራቶ ዋይዛኒ ዓጮ''ኮ ጋፒንፆይዳፓ ሙኬኔ፤ ጋዓንቴ ሓይሾ ሴሎሞኔይዳፓ ባሼ ሃይካ ዓኣኔ! ");
INSERT INTO mdybse_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ዬያጉዲ ሃሣ ኔኔዌ ዓሳ ጋፒንፆ ዎጎ ኬሎ''ና ዔቂ ዔያቶ ዑፃ ዎጋንዳኔ፤ ዓይጎሮ ጌዔቶ ኔኔዌ ዓሳ ዮናሴ ኬኤዜ ባኮ ዋይዜ ዎዶ''ና ፔኤኮ ጎማ ዻቢንቲታሢ ዔሪ ቡኡፄኔ፤ ጋዓንቴ ሃይሾ ዮናሴይዳፓ ባሻይ ሃይካ ዓኣኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ሄሊ''ሳዖ ዬሱሴ፦ «ፖዒ ፖዒሲ ዓኣሺንታ ቤስካ ጌሣያና ሃሣ ጉኡፖ ባኣዚ''ና ጉኡፓ ዓሲ ባኣሴ፤ ዬያፓ ዓሳ ጋሮ ጌላኣና ጴዻንዳጉዲ ዼ'ጊዲ ሻርናይዳ ጌሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ኔኤኮ ዑፆኮ ፖዒ ዓኣፒኬ፤ ኔኤኮ ዓኣፓ ኮሺ ማዔቶ ዑፃ ኔኤኮ ቢያ ፖዒ ማዓንዳኔ፤ ዓኣፓ ኔኤኮ ጋዓንቴ ሃርጌያ ማዔቶ ዑፃ ኔኤኮ ጉቤ ዹሜያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ዬያሮ ኔጊዳ ዓኣ ፖዓ ዹሚ ማዑዋጉዲ ኔና ዔሬ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ዓካሪ ኔኤኮ ዑፆይዳ ዓይጌንዴ ዹሚያ ባኣያ፥ ፖዔ ማዔቶ ፆምፔ ኔ ዑፃ ፖዓዖ ሼኤራሢጉዲ ኔኤኒ ፖዓያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ዬሱሴ ዬያ ኬኤዚ ጋፔስካፓ ፔቴ'' ፔርሴ ዓሲስኬይ ሙኡዚ'' ሙዖም ዔኤላ''ዛ፥ ዒዚ ዓሢ ማኣሪ ጌሊ ሙዖ ሙዓኒ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ዬሱሴ ሙዖ ሙዓንዳሢኮ ቤርታ ኩጮ ማስቲባኣሢሮ ዬይ ዓሢ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ዬያሮ ዬሱሴ ዒዛም፦ «ዒንሢ ፔርሴ ዓሳ፥ ዒንሢኮ ዑሽኮ ዓንጎና ሙዖ ሙዎ ጋባዶናኮ ዙሎ'' ዛሎ'' ኮሺ'' ዒንሢ ጌኤሺ ማስካኔ፤ ዒንሢኮ ጋራ ጋዓንቴ ቡሪሢና ፑርቱሞና ኩሜያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ዒንሢ ሃይ ዔኤዮ ዓሳ፥ ዙሎ'' ማዤ ፆኦዛሢ ጋሮ ማዢባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ዒንሢኮ ዑሽኮ ዓንጎና ሙዖ ጋባዶናይዳ ዓኣ ባኮ ማንቆ ዓሶም ዒንጉዋቴ፤ ዬካፓ ቢያ ባካ'' ዒንሢም ጌኤሺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«ዒንሢ ፔርሴ ዓሳ ዒንሢና ባዴዔ! ዓይጎሮ ጌዔቶ ፔቴ'' ዛሎ''ና ዲዮና ፃልቴናይዳፓ፤ ሃሣ ኮልፖና ዬያጉዴ ባኮይዳፓ ቤርቶ ዒንሢ ፆኦሲም ዒንጋያታዖ ፔቴ'' ዛሎ''ና ጋዓንቴ ፒዜ ዎጌና ፆኦሲ ናሽኪሢና ዒንሢ ሃሼ''ኔ፤ ዬያ ዒንሢ ማዻንዳያ ኮይሳኔ። ጋዓንቴ ዬያ ዒንጎ ባኮ ዒንሢ ሃሻ''ኒ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«ዒንሢ ፔርሴ ዓሳ ዒንሢና ባዴዔቴ! ዓይጎሮ ጌዔቶ ዓይሁዶኮ ዓሳ ቡኪንታ ቤዛ ቦንቺንታ ዖይቶይዳ ዴዓኒ ዒንሢ ኮዓኔ፤ ዬያጉዲ ቦኦኮ'' ቤዞይዳኣ ዓሲ ዒንሢ ቦንቾ ዔኤሊ''ሢ ዔኤላ''ንዳጉዲ ዒንሢ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ዓሳ ዔሩዋዖ ጊዴና ዓኣዻ፥ ማላታባኣ ዱኡፒ ዒንሢ ማላሢሮ ዒንሢና ባዴዔቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢዳፓ ፔቴ'' ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ሃይ ኔ ኑና ጫሽካንቴሞ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ዬሱሴ ማሃዖ፦ «ዒንሢ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ! ዓሲ ዑሢዳ ዴኤሢ ኬዲ ዒንሢ ጌሣኔ፤ ዒንሢ ጋዓንቴ ዬኖ ኬዶ'' ኬኤላ''ናታዖ ካኣሙዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ዬያጉዲ ዒንሢኮ ዓዶንሢ' ዎዼ፥ ፆኦሲ ማሊፆ ኬኤዛ ዓሶኮ ዱኡፖ ዒንሢ ፓልሚሲ ኮሻ''ሢሮ ዒንሢና ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ዓካሪ ዒንሢኮ ዓዶንሢ' ዎዼ፥ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዱኡፖ ኮሺ''ሶና ዔያቶኮ ፑርቶ ማዾ'' ኮሺ ማሂ ዒንሢ ዻዋኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ዬያ ዒንሢኮ ፑርቶ ማዾ'' ፆኦሲ ዔሬሢሮ ፔ ዔራቶና ‹ታ ማሊፆ ኬኤዛዞንሢና ዳኪንቴዞንሢና ታ ዔያቶ ባንሢ ዳካንዳኔ፤ ፔቴ'' ፔቴ''ዞንሢ ዎዾንዶኔ፥ ዓቴ''ዞንሢ ሃሣ ዳውሶንዶኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ዬያሮ ሳዓ ማዢንቴሢዳፓ ዓርቃዖ ላኣሊንቴ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ሱጉፆ ዛሎ'' ሃያ ዎዶ'' ዓሳ ዖኦጪንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ጎኔ ታ ዒንሢም ኬኤዛኔ፤ ዓኣቤኤሌይዳፓ ዓርቃዖ ፆኦሲም ዒንጎ ባኮ ዒንጊ ካኣሽኮ ቤዞና ጌኤዦ ማኣሮና ባኣኮ''ይዳ ዎዾና ዛካሪያሴ ሱጉፆ ዛሎ''ሮ ሃያ ዎዶ'' ዓሳ ዖኦጪንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«ዒንሢ ዎጎ ዔርዛ ዓሳ ዒንሢና ባዴዔቴ! ጌኤዦ ማፃኣፖ ዓሳ ዔሩዋጉዲ ካሮ'' ዒንሢ ዎዼኔ፤ ዒንሢሮዋ ዒንሢ ዔሪባኣሴ፤ ሃሣ ዔራኒ ኮዓ ዓሶዋ ዒንሢ ላኣጌኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ዬሱሴ ዬኖ ቤዜሎፓ ዴንዳኒ ዔቃዛ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶና ዒዛ ዒፂ ማኪሢና ሚርጌ ዖኦጪሢያ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ዬያ ዔያታ ማዼሢ ጌኤሲና ዒዛ ቡኡዳኒ ኮዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ዬኖ ዎዶ''ና ኮሺ'' ሚርጌ ዓሲ ቡኪንቴኔ፤ ዔያቶኮ ዺቡማፓ ዔቄያና ዎሊ ዓሳ ሂዒ ሂዒ ሄ'ርቃኔ፤ ዬሱሴ ዒዛኮ ጊንፆ ሃንታ ናኣቶ'' ኮራ፦ «ፔርሴ ዓሶኮ ሙኑቆ ፃኣዛፓ ካፒንቱዋቴ፤ ዬይ፦ ዔያቶኮ ፔና ጌኤሺ ማሊሲፆፓ ሃኩዋቴ ታኣኮ ጌይፆኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ካንቂንቴ ባኣዚ'' ፔጋዹዋዖ፥ ዓኣሺንቴ ባኣዚ'' ዔርቱዋዖ ዓታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ዬያሮ ዹሞይዳ ዒንሢ ኬኤዜ ባካ ቢያ ፖዒዳ ዋይዚንታንዳኔ፤ ካራ ዎዺንቴ ማኣሪዳ ካሽካሺ፥ ዋይካ ዒንሢ ጌስቴ ባካ ዼ'ጌ ቤሲዳ ፔጌና ኬኤዚንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ሃሣ ዒንሢ፥ ታ ዒጊኖንሢም፦ «ዓሽኮ ዎዺሢዳፓ ዓታዛ ሜሌ'' ዓይጎ ባኣዚ''ያ ማዻኒ ዳንዳዑዋዞንሢ ዒጊጪፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ጋዓንቴ ዖና ዒጊጫንዳያ ዒንሢ ኮይሳቴ ታ ዒንሢም ኬኤዛንዳኔ፤ ዬይያ፦ ዎዼሢኮ ጊንፃ ባይቁዋ ታሞይዳ ዓጋኒ ቢታንቶ ዓኣ፥ ፆኦዛሢኬ፤ ሂዮ! ዒዛ ሌሊ ዒጊጩዋቴ ታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«ዶንጎ ሱኡታ ፔቴ'' ሳንቲፔም ሻንቺንታያቱዋይ? ዔያቶይዳፓ ፔቴ''ታዖ ፆኦሲ ቤርቶይዳ ዋሊ''ንቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ዬያጉዲ ዒንሢኮ ቶኦኮ'' ጋፓና ቢያ ፓይዲንቴያኬ፤ ዬያሮ ዒጊጪፖቴ፥ ዒንሢ ሚርጌ ሱኡቶ''ይዳፓ ባሼታንቴሞ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ዬካፓ ዬሱሴ፦ «ቦርሲንቱዋዖ ዓሲ ቤርቲዳ ታ ዛሎ'' ማርካዺ ኬኤዛሢም፥ ታኣኒ ሃሣ ፆኦሲ ኪኢታንቾም ዒዛ ዛሎ'' ማርካዺ ኬኤዛንዳኔ፤ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ዓሲ ቤርቲዳ ታና ዔሩዋሴ ጋዓሢ፡ ታኣኒያ ሃሣ ፆኦዛሢ ኪኢታንቾም ዒዛ ዔሩዋሴ ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«ዓሲ ናዓሢ ጫሽካይ ዓኣቶ ዻቢንታ ዒዛም ዓቶም ጌይንታንዳኔ፤ ዓያኖ ጌኤዦ ጫሽካይ ዓኣቶ ጋዓንቴ ዻቢንታ ዒዛም ዓቶም ጌይንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«ዓሳ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ቢያ ዒንሢ ዔኪ ዓኣዻኣና፥ ዎይሣ ዓሶንታ ቢታንታ ዓኣ ዓሶ ቤርታ ቢያ ዒንሢዳ ዎጊሳኒ ሺኢሻ ዎዶ''ና ‹ዓይጎ ኑ ማሃንዳይ? ዎዚ ጌይ ኑ ኬኤዛንዳይ?› ጌዒ ሜታዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ዓይጎሮ ጌዔቶ ዒንሢ ኬኤዛኒ ኮይሳ ባኮ ዬማና ዓያኖ ጌኤዣ ዒንሢም ኬኤዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ዴሮ'' ባኣኮ''ይዳፓ ፔቴ'' ዓሲስኬይ ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ኑ ዓዳሢ ኑም ዻካልሴ ቤዞ ታኣና ዎላ'' ጊሽታንዳጉዲ ታ ጌርሲንሢም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ዬሱሴ ጋዓንቴ ማሃዖ፦ «ዔኤዛይ፥ ዒንሢ ባኣኮ''ይዳ ታ ዎጋያ ማዓንዳጉዲና ዓጪ ታ ዒንሢም ጊሽካንዳጉዲ ዖ ታና ጌሤይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ሄሊ''ሳዖ ሃሣ ቢያሢም፦ «ዓሲኮ ሼምፓ ጴዻሢ ቆሎ ሚርጉሞፓቱዋኣሢሮ ቢያ ባኣዚ'' ናሽኪሢና ቢያ ባኣዚ''ም ጎጋይቂሢዳፓ ዒንሢ ካፑዋቴ፤ ሃሣ ዔሩዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ዬካፓ ዬሱሴ ኮኦኪንሢና፦ «ጎዣ ዒዛኮ ሚርጌ ሃኣኮ ካፄ፥ ፔቴ'' ዖርጎቺ ዓሲ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ዒዚያ ፔ ማሊፆና ‹ሃያ ቢያ ሃኣኮ ታ ዓርሣንዳ ቤሲ ታኣኮ ባኣሢሮ ታ ዎዳ''ንዳይ?› ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ዬካፓ ሃሣ ‹ታ ዓካሪ ሂዳንዳኔ፤ ቤርታ ታኣኮ ዓኣ ኮኖ ቢያ ሻሂጋፓ ሜሌ'' ዼኤፒ ዼኤፒ ኮና ታ ማዢ፥ ዒኢካ ታኣኮ ሃኣኮና ዓኣ ባኮና ቢያ ቡኩሲ ታ ዓርሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ዬካፓ ታኣኒ ታኣም፦ ሃይሾ! ዓካሪ ኔኤም ሚርጌ ሌዔይዳ ጊዳ ሚርጌ ባኣዚ'' ኔኤኮ ዓኣኔ፤ ዬያሮ ሜታ ባኣያ ማዒ፥ ሃውሺጋፓ ሙዔ፤ ዑሽኬ፥ ዎዛዼ፥ ታ ጋዓንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ፆኦሲ ጋዓንቴ ‹ዔኤዛይ፥ ኔ ዔኤያሢ! ሃኖ'' ዒባኒ ኔ ሃይቃንዳኔ፤ ዓካሪ ሃይ ኔ ቡኩሴ ባካ'' ቢያ ዖኦም ማዓንዳይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«ዬያሮ ፔኤም ሳዖይዳ ቆሎ ቡኩሳ ዓሲ፥ ፆኦሲ ቤርቶይዳ ጋዓንቴ ማንቆ ማዔ ዓሲ ዬያጉዲ ማዓንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሃንታ ናኣቶ''ም፦ «ዓካሪ ‹ዓይጎ ኑ ሙዒ፥ ዓይጎ ዑሽካንዳይ?› ሂዚ ጌይሢና ዒንሢኮ ናንጎ ዛሎ'' ሜታዺፖቴ ታ ዒንሢም ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ዓይጎሮ ጌዔቶ ሙኡዚ''ዳፓ ሼምፓ፥ ማኣዖይዳፓ ዑሢ ባሼኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ሂንዳ ቁራኮ ዛጉዋቴ፦ ዔያታ ጎሽኪ ሃኣኮ ቡኩሱዋሴ፤ ሃሣ ዔያቶኮ ኮናኣ ባኣሴ፤ ማዔቶዋ ፆኦሲ ዔያቶ ሙኡዛኔ፤ ዒንሢ ዓካሪ ካፖይዳፓ ባሼቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ጎዖንቴ ዒንሢዳፓ ማሊ ሜታዺሢና ፔ ናንጎ ሌዖይዳ ፔቴ'' ኬሊ'' ቃሳ''ኒ ዳንዳዓሢ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ዓካሪ ዬማ ዻኮ'' ባኮማታዖ ማዻኒ ዳንዳዑዋያታዖ ዓይጎሮ ሜሌ'' ባኮሮ ዒንሢ ሜታዻይ? ");
INSERT INTO mdybse_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ካዮ ቡና'' ዎይቲ ዑጋቴ ሂንዳ ዛጉዋቴ፦ ዔያታ ማዺ ላቡ''ዋሴ፥ ሱኩዋሴ፥ ማዔቶዋ ካኣቲ ሴሎሞኔታዖ ፔ ቦንቾ ዎዶ''ና ቢያ ዔያቶይዳፓ ፔቴ''ማጉዲ ሚዛጳ ማኣዖ ማይንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ዓካሪ ፆኦሲ ሃኖ'' ጴዺ ዚሮ ታሞይዳ ዓጊንታንዳ ካዮ ማኣቶ ዬያይዲ ፓልሚሲ ማይሳያ ማዔቶ፥ ዒንሢ ጉሙርቂፃ ፓጬ ዓሳ፤ ዒንሢ ዒዚ ዎይቲ ዬያይዳፓ ባሼና ማይሲንዱዋይ? ");
INSERT INTO mdybse_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«ዬያሮ ‹ዓይጎ ኑ ሙዒ ዑሽካንዳይ?› ጌዒ ጌዒ ማሊሢና ሜታዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ዬያ ዴንቃኒ ሓያ ዓጮ'' ዓሳ ሜታዻኔ፤ ዒንሢም ጋዓንቴ ዬይ ቢያ ኮይሳሢ ዒንሢኮ ጫሪንጮ ዓዳሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ዬያይዳፓ ባሼ ፆኦሲ ካኣቱሞ ዛሎ''ም ኮይሳ ባኮ ቤርታሱዋቴ፤ ዒንሢም ኮይሳ ባካ ቢያ ቃሲ''ንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ዬሱሴ ሓሣ ኬኤዛዖ፦ «ዒንሢ ሚርጌቱዋ፥ ዻኮ'' ታ ዒጊኖንሢዮቴ ዒጊጪፖቴ፤ ዓይጎሮ ጌዔቶ ዒንሢኮ ጫሪንጮ ዓዳሢ ዒዛ ካኣቱሞይዳ ዒንሢ ጌልዛኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ዒንሢኮ ዓኣ ባኮ ቢያ ሻንቺ፥ ሚኢሾ ማንቆ ዓሶም ዒንጉዋቴ፤ ሚኢሾ ዓጎ ጪንቁዋ ቡራሾይዳ፥ ዉዛ ሄሉ''ዋ ቤዞይዳ፥ ቁንቁናሢያ ሙዒ ፑርቲሱዋ ቤዞና ፔቴ''ታዖ ጋፑዋ ቤዞ፥ ጫሪንጮ ማኣራ ዒንሢኮ ሚኢሾ ጌሡዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ዓይጎሮ ጌዔቶ ሚኢሻ ዒንሢኮ ዓኣ ቤዛ ዒና''ኣ ሃሣ ዒንሢኮ ዒኢካ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ሃሣ ዬሱሴ ኬኤዛዖ፦ «ጊኢጊንቲ ቱኡቲ፥ ቢያ ዎዴና ማዾም ጊኢጊንቱዋቴ፤ ፖዓኣ ዒንሢኮ ፖዓያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ዬያይዲ ዔያቶ ጎዳሢኮ ዔፖ ቤዞይዳፓ ማዒ ሙኪፆ ካፓ፥ ማዻ ዓሶንሢ ማሉዋቴ፤ ዔያታ ፔኤኮ ጎዳሢ ሙኪ ካራ'' ዔቂ ዔኤላ''ኣና ዑኬና ሩኡሪ ቡላ''ኒ ጊኢጊንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ዬንሢ ዔያቶኮ ጎዳሢ ዔሩዋንቴ ሙኪ፥ ጴጪ ዔያታ ካፓንቴ ዔያቶ ዴንቆና ማዾ'' ማዻዞንሢ ዎዚጉዲ ጋላቲንቴያዳይ! ጎኔ ታ ዒንሢም ጋዓኔ፦ ዒዚያ ጊኢጊንቲ፥ ቱኡቲ ሙዖ ሙዎ ቤዛ ዔያቶ ዴይሣንዳኔ፤ ሙዖ ሙኡዚ''፥ ዔያቶ ሾኦቺንሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ዔያቶኮ ጎዳሢ፦ ሳዓ ጊዲሚሺ ሓሣ ጊዲሚሺፓ ዑሣ ዓኣዼም ሙኪ፥ ጴጪ ጊኢጊንቲ፥ ካፓንቴ ዴንቄ ማዻዞንሢ ጋላቲንቴያኬ! ");
INSERT INTO mdybse_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ኮሺ'' ዔሩዋቴ፤ ዉሲ ሙካ ዎዴ ዓሲ ዱማሲ ዔራያ ማዔቶ ጊንዑዋዖ ካፒ፥ ዉዞና ማኣሮ ቦኦኪሲንዱዋያታዖ፥ ዔሩዋ ዓቲፆና ዉዛ ማኣሪ ጌላሢጉዲ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ዓሲኮ ናዓሢ ዒንሢ ማሊባኣ ዎዴና ዔሩዋንቴ ሙካንዳኔ፤ ዬያሮ ዒንሢ ጊኢጊ ካፑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ዬማና ጴፂሮሴ፦ «ጎዳሢዮ! ሃያ ኮኦኪንሦ ኔ ኬኤዛሢ ኑምሞ? ቢያ ዓሲምዳይ?» ጌይ ዬሱሴ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ጎዳ፥፥ ዬሱሴ ማሃዖ፦ «ዓካሪ ፔኤኮ ማኣሮ ዓሶ ዎይሣንዳጉዲና ማዻ ዓሶማኣ ሙዓ ኮይሳ ዎዶ''ና ዒንጋንዳጉዲ፥ ጎዳ ዶኦሪ ጌሣ ጉሙርቂንታያና ጪንጫ ማዔሢ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ዒዛኮ ጎዳሢ ዓኣዼ ቤዛፓ ማዔ ዎዶ''ና ዒዛም ዓይሢንቴማጉዴያ ማዺ ጴዻ ማዻ ዓሢ ዎዚ ጋላቲንቴያዳይ! ");
INSERT INTO mdybse_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ጎኔ ታ ዒንሢም ጋዓኔ፤ ጎዳሢ ዬያ ማዻ ዓሢ ፔኤኮ ማኣሮይዳ ዓኣ ባኮ ቢያኮ ዑፃ ማሂ ዶኦሪ ጌሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ጋዓንቴ ዬይ ማዻ ዓሢ ‹ታ ጎዳ ዑኬ ሙካዓኬ፥ ኔጋንዳኔ› ጌይ ማሊሢና ሙዒ ሙዒ ሃሣ ዑሽኪ ዑሽኪ፥ ማሢንቲ ማዾ'' ማዻ ዓቲንቆና ላኣሎና ጳዺ ዓርቄቶ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ጎዳሢ ዒዛኮ ዔርቲባኣ ዎዴይዳ ሙኪ፥ ዬያ ማዻሢ ኮሺ'' ጳርቃንዳኔ፤ ሓሣ ዒዛ ጉሙርቂንቱዋ ዓሲ ማሂ ፓይዳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«ዒዛኮ ጎዳሢ ማሊፆ ዔራያታዖ ጎዳሢ ማሊፆጉዲ ማዺባኣሢ ሃሣ ዬያጉዲ ጎዳሢኮ ዓይሢፆ ኩንሡዋ ማዻ ዓሢ ኮሺ'' ጳርቂንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ጋዓንቴ ጎዳኮ ማሊፆ ዔሪባኣዖ ዒዛ ጳርቂሳ ባኣዚ'' ማዼቶዋ ዒዛ ጳርቆንዶ ጳዻ'' ሼሌዔኬ፤ ዓይጎሮ ጌዔቶ ሚርጌ ዒንጊንቴ ዓሲዳፓ ሚርጌ ኮይንታኔ፤ ሚርጌ ባኣዚ''ዳ ቢታንቶ ዒንጊንቴ ዓሲዳፓ ሚርጌ ባኣዚ'' ካፒንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ሄሊ''ሳዖ ዬሱሴ፦ «ሃኣዛጉዋቴ፤ ታኣኒ ሳዖይዳ ታሚ ዔኪ ሙኬኔ፤ ዬይ ታማ'' ዑኬና ታኣም ዔኤቴቴ ዎዚ ታና ናሻንዳይ! ");
INSERT INTO mdybse_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ጋዓንቴ ታኣኒ ፑኡፒ ዔካንዳ ሜታ ዓኣሢሮ ዬይ ኩማንዳያ ሄላ''ንዳኣና ሃውሺሢ ታኣኮ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ታኣኒ ሳዖም ኮሹሞ ዔኪ ሙኬጉዲ ዒንሢም ማላ? ታኣኒ ዔኪ ሙኬሢ ፓቂንቲሢ ማዓንዳኣፓዓቴም ኮሹሞቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ሃሢፓ ዓርቃዖ ፔቴ'' ማኣሪዳ ዓኣ ዶንጎ ዓሲ ዎሊፓ ዱማዻንዳኔ፤ ሃይሦንሢ ላምዖንሢዳ ጊንሣ ሃሣ ላምዖንሢ ሃይሦንሢዳ ዔቂ ዎላ'' ዑራዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ዓዴ ናዖ ዑፆይዳ፥ ናዓ ዓዶ ዑፆይዳ፥ ዒንዳ ናዎ ዑፆይዳ፥ ናኣ ዒንዶ ዑፆይዳ፥ ማዔ ናኣዚ'' ማቾ ዑፆይዳ ናኣዚ'' ማቻ ሃሣ ማዖ ዑፆይዳ ፑርቱሞና ዔቂ ዱማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ላሚ ሃሣ ዬሱሴ ዴሮ''ም፦ «ዓባ'' ጌላ ዛሎ''ና ሻኣሬ ዒንሢ ዴንቃዖ ‹ሃይሾ፥ ሃኖ'' ዒርዚ ዋርቃንዳኔ!› ዒንሢ ጋዓዛ፥ ዔርዚ ዋዋርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ዬያጉዲ ሃሣ ዓባ'' ኬስኪ ጌላ ዛሎ''ኮ ዾኦሎ'' ዛሎ''ና ቱሮ'' ዢባርሼቶ ‹ሃኖ'' ዓቢኬ› ዒንሢ ጋዓዛ፥ ጎኔ ዒማዺ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ዒንሢ ሃይ ዒንሢና ጌኤሺ ማሊሳ ዓሳ ጫሪንጮና ሳዖና ዓኣ ጎይፆ ዛጊ ማዓንዳ ባኮ ዒንሢ ዔሪ ዔራኔ፤ ዓካሪ ሃሢ ሃያ ዎዶ''ና ማዺንታ ባኮ ዓይጎሮ ዒንሢ ዔሩዋይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ዬካፓ ዬሱሴ፦ «ዓካሪ ዒንሢ ዒ'ንሢ ቶኦኪና ፒዜ ማዔ ባኣዚ'' ዔሪ ዓይጎሮ ዎጉዋይ? ");
INSERT INTO mdybse_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ኔኤኮ ሞርኬ ኔና ዎጌና ዓይሢሲ ዎጎ ዎጎ ማኣሪ ዔኪ ዓኣዻ ዎዶ''ና ጎይፃ ዓኣዖ ኔ ሞርካሢና ጊኢጋኒ ኮሺ'' ማሌ፤ ያዺ ማዒባኣያታቶ ዒዚ ኔና ዎጎ ዓሢ ኮይላ'' ዔኪ ዓኣዻንዳኔ፤ ዎጋሢ ሃሣ ፖኦሊሳሢም ዓኣሢ ዒንጋንዳኔ፤ ጋፒንፃ ፖኦሊሳሢ ኔና ቱኡዞ ማኣራ ቱካ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ኔ ዻቤ ባኮ ዛሎ'' ቢያ ጋፒሲ ጪጉዋዖ ቱኡዞ ማኣራፓ ኬስካኒ ኔ ዳንዳዑዋኣሢ ታ ኔኤም ኬኤዛኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ዒማ''ና ዓሳ ዬሱሴ ባንሢ ሙኪ፦ «ጌሊላ ዓጮ'' ዓሳ ፆኦሲም ሹኪ ዒንጊ ካኣሽኮ ባኮ ሺኢሻ ዎዶ''ና ጲላፆሴ ዔያቶ ዎዼም፥ ሱጉፃኣ ዔያቶኮ ዔያታ ፆኦሲም ዒንጊ ካኣሽካ ባኮና ዎላ'' ሲኢሪንቴኔ» ጌይ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ዬሱሴ ዔያቶም ማሃዖ፦ «ዓካሪ ዬንሢ ጌሊሎ ዓሶንሢ፥ ዬይ ሃይቦ'' ባይሲንታ ሄሌ''ሢ ሜሌ'' ዓቴ'' ጌሊላ ዓሶይዳፓ ቢያ ባሼ ጎሜ ዓሲ ዔያታ ማዔሢሮ ዒንሢም ማላ? ");
INSERT INTO mdybse_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ያዺቱዋሴ! ዒንሢኮ ጎማ ዻቢንቲ ማዔሢ ዔሪ ጎሞ ቡኡፂባኣቴ ዒንሢያ ዔያቶጉዲ ባይቃንዳኔ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ሴሌሆሜ ጎዖ ቤዞይዳ ሹጮና ኬልቂ ማዦና ዲራ ዶዔም፥ ሃይቄ ታጶ ሳሎ'' ዓሶ ዛሎ'' ዒንሢ ዎዚ ጋዓይ? ዔያታ ዬሩሳላሜይዳ ናንጋ ዓሶይዳፓ ቢያ ዑሣ ዓኣዼ ጎሜ ዓሲ ዒንሢ ኮራ ማላ? ");
INSERT INTO mdybse_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ያዺቱዋሴ! ዒንሢኮ ጎማ ዻቢንቲ ማዔሢ ዔሪ ጎሞ ቡኡፂባኣቴ ዒንሢያ ዔያቶጉዲ ባይቃንዳኔ ታ ዒንሢም ጋዓኣኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ዬካፓ ዬሱሴ ሃያ ኮኦኪንሦ ዔያቶም ኬኤዜኔ፦ «ፔቴ'' ዓሲ ፔኤኮ ቱኮ'' ሚፆ ባኣኮ''ይዳ ቱኬ'' ቤሌሴ ሚሢስኬና ዓኣኔ፤ ዬኖ ሚፄሎይዳ ዓኣፒ ናንዳኔ ጌዒ ዴንዲ፥ ፔቴ''ታዖ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ዬያሮ ዒዛኮ ዬኖ ቤዜሎይዳ ማዻ ዓሢም ‹ሃኣዛጌ፥ ሃኖ' ቤሌሶ ሚፄሎይዳፓ ዓኣፒ ታ ዴንቃኒ ጌዒ ሃይሦ ሌዔ ኩሙሢ ታ ሃንቴኔ፤ ጋዓንቴ ፔቴ''ታዖ ዓኣፒ ዒዞይዳፓ ታ ዴንቂባኣሴ፤ ዬያሮ ሃሢ ዒዞ ቲቄ፤ ዓይጎሮ ዒዛ ሜሌ'' ቱኪ''ንቴ ባኮኮ ጉሪ ቤዞ ዓርቂ ሳዖ ፑርቲሳይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ዬኖ ቤዜሎ ጎሽካሢ ጋዓንቴ ‹ጎዳሢዮ! ሂንዳ ሃኖ' ሌዖ ሃሼ''፤ ዓጮ ታ ዒዞኮ ቦኦኪ ቡኡራ ዋሂ ዛጋንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ሙካ ሌዖ ዒዛ ዓኣፔቴ ኮሺኬ፤ ሃንጎታቴ ጋዓንቴ ዒዛ ቲቂንታንዳኔ› » ጌይ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ዬሱሴ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ዔያታ ቡካ ቤዞይዳ ዔርዛንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ዒኢካ ታጶ ሳሊ'' ሌዔ ጉቤ ፑርታ ዓያና ዎቢሴ ላኣሊስኬና ዓኣኔ፤ ዒዞኮ ጊኢራ ዎቤሢሮ ዼ'ግ ጋዓኒ ዒዛ ፔቴ''ታዖ ዳንዳዑዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ዬሱሴ ዒዞ ዴንቃዖ ዔኤሊ''፦ «ዔና፥ ኔኤኒ ኔኤኮ ዶርዓስካፓ ፖዔኔ» ዒዞም ጌዒ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ፔ ኩጮና ዒዞ ዒ ፒፃዛ ቤዞማና ዼ'ግ ጌይ ዔቂ፥ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ዬሱሴ ዒዞ ዓይሁዶኮ ሃውሾ ኬሎ''ና ፓሤሢሮ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጋሢ ዻጋዻዖ ዴሮ'' ኮራ፦ «ቃልሾ ኬሎ'' ጋራ ማዾ ማዺንታንዳ ላሆ'' ኬሊ'' ዓኣኔ፤ ዬንሢ ኬሎ''ንሢዳ ሌሊ ሙኪ ሙኪ ፖዑዋቴ፤ ሃውሾ ኬሎ''ና ጋዓንቴ ማዑዋያኬ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ዬማና ጎዳ ዬሱሴ ዒዛም፦ «ዒንሢ ሃይ ፔና ጌኤሺ ማሊሳ ዓሳ! ዒንሢ ፔቴ'' ፔቴ''ሢ ሃውሾ ኬሎ''ና ዒንሢኮ ጌማይ ሃሣ ሃሬ ቱኬ'' ቤዛፓ ቡሊ'' ዋኣሢ ዑሻኒ ዔኪ ዓኣዹዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ሃሢ ሃና ዓብራሃሜ ፃጳፓ ማዔ፥ ላኣሌላ ታጶ ሳሊ'' ሌዔ ጉቤ ፃላሄ ቱኬ''ም ሜታዺ ናንጌኔ፤ ዓካሪ ዒዛ ቱኡቲ ሜታዻ ዶርዓሢዳፓ ሃውሾ ኬሎ''ና ቡሊ''ንታኒ ዒዞም ኮይሱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ያዺ ጌዒ ዬሱሴ ዒዛ ማካ ዓሶ ቢያ ቦርሲሴኔ፤ ዴራ'' ጋዓንቴ ዬሱሴ ማዼ ዲቃሣ ባኮና ቢያ ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ዬሱሴ፦ «ፆኦሲ ካኣቱማ ዓይጎ ኮኦኪንሢና ኬኤዚንታንዳይ? ሃሣ ጊንሣ ዓይጎና ታ ቤኤዛንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ፔቴ'' ዓሲ ፔኤኮ ቱኮ''ና ባኮ ባኣካ'' ዜርቄ ሴናፒጬ ጌይንታ ሚፄሎ ዜርፆ ማላኔ፤ ዒዛ ዑጊ ዼኤፒ ሚሢ ማዓኔ፤ ካፓኣ ዒዞኮ ካኣፖይዳ ማኣሪ ማዣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ዬሱሴ ሃሣ ላሚ፦ «ፆኦሲ ካኣቱሞ ዓይጎና ዎላ'' ታ ቤኤዛንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ፆኦሲ ካኣቱማ ፔቴ'' ላኣሊ ሙኑቆ ካፂሳንዳጉዲ ዺቦ'' ዺኢሎ ዲርካኣና ዋሃ ሙኑቃ ፃኣዛ ማላኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ዬካፓ ዬሱሴ ዬሩሳላሜ ባንሢ ዴንዳዖ ካታሞና ካታሞኮ ዙሎ''ናይዳ ቢያ ዔርዚ ዔርዚ ዓኣዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ዬማና ፔቴ'' ዓሲ፦ «ጎዳሢዮ! ዻቃንዳዞንሢ ዻካ'' ዓሲዳ?» ጌይ ዖኦጫዛ፥ ዬሱሴ ዔያቶም ማሃዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ኩንዖ ካሬ''ሎና ጌላኒ ኮሺ'' ዶዱዋቴ፤ ዬኖ ካሬ''ሎና ጌላኒ ኮዓ ዓሳ ሚርጌኬ፤ ጋዓንቴ ጌላኒ ዔያታ ዳንዳዑዋሴ፥ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ማኣሮ ዓዴ ዔቂ ካሬ''ሎ ዎዻንዳኔ፤ ዒንሢ ዙላ'' ዔቂ ዔኤሊ''ንቲ ‹ጎዳሢዮ! ሃዳራ ካሮ'' ኑም ቡሌ''!› ጋዓዛ፥ ዒዚያ ‹ዓንካፓ ዒንሢ ሙኬቶዋ ታ ዒንሢ ዔሩዋሴ› ጌይ ዒንሢም ማሃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ዬኖ ዎዶ''ና ዒንሢ ‹ኔኤና ዎላ'' ኑ ሙዒ ዑሽኬኔ፤ ኑ ጉርዶይዳ ኔ ዔርዜንቴሞ!› ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ዒዚ ላሚ ሃሣ ‹ዓንካፓ ዒንሢ ሙኬቶዋ ታ ዒንሢ ዔሩዋሴ! ዒንሢ ሃይ ፑርቶ ዓሳ ታ ኮራፓ ሺኢኩዋቴ!› ዒንሢ ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ዒንሢ ዓብራሃሜንታ ዪሳኣቄንታ ያይቆኦቤንታ ሃሣ ፆኦሲ ማሊፆ ኬኤዛዞንሢ ቢያ ፆኦሲ ካኣቱሞይዳ ዛጋንዳኔ፤ ዒንሢ ጋዓንቴ ዙላ'' ኬኤሪንቲ ዓቴ'' ዎዶ''ና ዬኤፒና ዓቺ ዻይሢና ዒንሢም ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ሚርጌ ዓሳ ዓባ'' ኬስካ ካሮ''ና ጌላ ካሮ''ናይዳፓ ሃሣ ሳዖኮ ዾኦሎ''ና ኬዶ''ናይዳፓ ሙኪ ፆኦሲ ካኣቱሞይዳ ሙዎ ሙዖ ቤዛ ዴዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ዬያሮ ሚርጌ ላቤ''ያ ሃሣ ጊንፃዼያ ማላ ዓሳ ቤርታ ማዓንዳኔ፤ ጎኦቢ ቤርታዻያ ማላ ዓሳ ጊንሢም ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ዒማ''ና ፔቴ'' ፔቴ'' ፔርሴ ዓሳ ዬሱሴ ኮራ ሙካዖ፦ «ሄሮዲሴ ኔና ዎዻኒ ኮዓሢሮ ሃይፓ ሜሌ'' ቤሲ ዴንዴ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ዬሱሴ ጋዓንቴ ዔያቶም፦ «ዒንሢ ዴንዲጋፓ ዬያ ዉኡካሢም ‹ሃኖ''ና ዚሮና ፑርቶ ዓያኖ ታ ኬሲ''፥ ሃርጊንቴ ዓሶዋ ፓሣንዳኔ፤ ሃይሣሳ ኬሎ''ና ማዾ'' ታኣኮ ታ ጋፒሳንዳኔ› ጋዓኔ ጎዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ዓካሪ ሃኖ'' ማዔቶዋ ዚሮ፤ ሃሣ ሂንቶታቴያ ዬሩሳላሜ ታ ዓኣዺፆሮ ዔቃንዳኔ፤ ዓይጎሮ ጌዔቶ ፆኦሲ ማሊሢ ኬኤዛሢ ዬሩሳላሜይዳፓ ዓታዛ ሜሌ'' ቤስካ ሃይቃንዳያ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«ዬሩሳላሜ! ዬሩሳላሜ! ኔኤኒ ፆኦሲ ማሊፆ ኬኤዛዞንሢያ ዎዻኔ፤ ኔ ባንሢ ዳኪንታ ኪኢቶ'' ዓሶዋ ሹቻ ኔ ዹዓኔ፤ ኮይዳ ፔኤኮ ጋኣዞ ዴማ'' ናኣቶ'' ቡኩሳሢጉዲ ታኣኒያ ሚርጌና ናኣቶ'' ኔኤኮ ቡኩሳኒ ኮዔኔ፤ ዒንሢ ጋዓንቴ ዒፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ዬያሮ ማኣራ ዒንሢኮ ባዔ ማዒ ዓታንዳኔ፤ ዒንሢያ ‹ፆኦሲ ሱ'ንፆና ሙካሢ ዓንጂንቴያኬ› ጋዓንዳ ኬሎ'' ሄላ''ንዳኣና ፔቴ''ታዖ ታና ዒንሢ ዴንቃዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ዬሱሴ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ፔርሴ ዓሶኮ ሱኡጎይዳፓ ፔቴ''ስኬያ ማኣሪ ሙኡዚ'' ሙዓኒ ጌላዛ፥ ፔርሴ ዓሳ ዒዚ ማዻ ባኮ ዛጋኒ ኮሺ'' ዒዛ ሙራኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ሃርጊንቲ፥ ዑፃ ጉቤ ኪፄ ፔቴ'' ዓሲ ዒማ''ና ዬሱሴኮ ቤርታ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ዬሱሴ ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶና ኮራ፦ «ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ዓሲ ፓሥሢ ዎጋ'' ዓይሣሞ ዓይሡዋይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ዔያታ ጋዓንቴ ዚቲዮ ጌዔኔ፤ ዬሱሴ ዒማ''ና ሃርጊንቴ ዓሢ ፓሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ዬካፓ ሃሣ ዬሱሴ፦ «ዒንሢዳፓ ሃውሾ ኬሎ''ና ናዓ ሃሣ ጌማይ ዔቴይዳ ሎኦሜም ቤዞማና ኬሱ''ዋኣሢ ዖናዳይ?» ጌዒ ዔያቶ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ዔያታ ጋዓንቴ ማሂ ኬኤዛኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ዬሱሴ ሙዖም ዔኤሊ''ንቴ ዓሳ ቦንቺንቴ ቤዛ ዴዓኒ ኮዓሢ ዛጋዖ ሂዚ ጋዓ ኮኦኪንሢ ዔያቶም ኬኤዜኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ፔቴ'' ዓሲ ዔፒ ቤሲ ሙኡዚ''ም ኔና ዔኤሌ''ቴ፥ ቦንቾ ቤዛ ሩኡሪ ዴዒፖ፤ ጎዖንቴ ኔ ጊዳ''ፓ ባሼ ቦንቺንቴ ዓሲ ዔኤሊ''ንቴያናንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ዒንሢ ላምዓሢ ዔኤሌ'' ዓሢ ኔ ኮይላ'' ሙኪጋፓ ‹ሃኖ' ቤዜሎ ሃያ ዓሢም ሃሼ''› ኔና ጌዔቴ፥ ዒማ''ና ዼኤፒ ቦርሲንቲና ሂርኬ ቤዛ ኬዲ'' ኔ ዴዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ጋዓንቴ ሙኡዚ'' ቤሲ ኔ ዔኤሊ''ንታኣና ዴንዲ ሂርኬ ቤሲዳ ዴዔ፤ ዬካፓ ኔና ዔኤሌ'' ዓሢ ኔ ኮራ ሙኪ ‹ታ ዒጊናሢዮ! ሃይካ ዼ'ጌ ቤዛ ኬስኪ ዴዔ› ኔና ጋዓዛ፥ ሜሌ'' ኔኤና ዔኤሊ''ንቴዞንሢ ቤርታ ቢያ ቦንቾ ኔኤም ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ዓይጎሮ ጌዔቶ ፔ ቶኦኮ'' ዼ'ጊዳሢ ቢያ ሂርኪ ጋዓንዳኔ፤ ፔ ቶኦኮ'' ሂርኪዳሢ ጋዓንቴ ዼ'ግ ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ዬሱሴ ሃሣ ሙዖ ሙኡዛኒ ዔኤሌ'' ዓሢም፦ «ካሣ ኔ ሙኡዛኒ ሮኦሪያ ማዖም ዋንታ ዔኤላ'' ዎዶ''ና ‹ዔያታ ሙዔሢ ዛሎ'' ማሂ ታና ዔኤሊ'' ሙኡዛንዳኔ› ጌዒ ማሊሢና ኔኤኮ ላጎ፥ ኔኤኮ ጌርሲንሢ፥ ኔኤኮ ዒጊኖና ሃሣ ዖርጎጮ ማዔ ኔኤኮ ዓሺኖ ዔኤሊ''ፖ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ጋዓንቴ ኔ ካሣ ሙኡዛኒ ዔኤላ'' ዎዶ''ና ዔኤቢባኣ ዓሶ፥ ኩቺና ቶኪና ዱጴ ዓሶ፥ ዎቦ ዓሶ፤ ሃሣ ዓኣፖ ባይቄ ዓሶ ዔኤሌ''። ");
INSERT INTO mdybse_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ያዺ ኔ ማዼቶ ዔያታ ኔ ማዼሢ ዛሎ'' ኔኤም ጪጋኒ ዳንዳዑዋኣሢሮ ኔ ዓንጂንታንዳኔ፤ ጋፒንፃ ጌኤዦ ዓሳ ሃይባ''ፓ ዔቃ ዎዶ''ና ፆኦሲ ኔኤም ጪጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ሙዖ ሙዓኒ ዴዔ ዓሶይዳፓ ፔቴ''ስኬይ ዬሱሴ ኬኤዜሢ ዋይዛዖ፦ «ፆኦሲ ካኣቱሞይዳ ሙኡዚሮ ዴዒሢ ዎዚጉዲ ዓንጂንቲሢዳይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ዬሱሴ ጋዓንቴ ማሃዖ፦ «ፔቴ'' ዓሲ ዼኤፒ ሙኡዚ'' ጊኢጊሺ ሚርጌ ዓሲ ዔኤሌ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ሙዖ ሙዖንዶ ኬላ'' ሄላ''ዛ ‹ሃይሾ ዓካሪ ቢያ ባካ ጊኢጊንቴሢሮ ታኣኮ ሙዖ ሙዓኒ ሙኩዋቴ!› ጌዒ ዔኤላ''ንዳጉዲ ሙዖ ጊኢጊሼሢ ዒዛኮ ዓይሢንቲ ማዻሢ ዔኤሊ''ንቴ ዓሶ ኮራ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ጋዓንቴ ፔቴ'' ፔቴ'' ዔኤሊ''ንቴ ዓሳ ሙዖይዳፓ ዓቶንዶ ጎይሢ ኮዒሢ ዓርቃዖ፥ ፔቴ''ሢ ‹ቤሲ ታ ሻንቄሢሮ ዴንዲ ታ ዛጋንዳኔ፤ ዬያሮ ታ ሙካኒ ዳንዳዒባኣሴ፤ ታና ቆፂፖ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ባጋሢ ሃሣ ‹ዶንጎ ዋኣፃ ጌማይ ታ ሻንቄሢሮ ዔያቶ ታ ዓኣሢ ዛጋንዳኔ፥ ታና ሄሊ''ሲንዱዋሴ፤ ቆፂፖ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ዓቴ''ሢ ሃሣ ‹ላኣሊ ታ ዔኪ ዑኡቱሞይዳ ዓኣሢሮ ሙካኒ ታ ዳንዳዑዋሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«ዔኤሊፆ ዳኮና ማዻሢ ማኣሪ ሙካዖ ዬያ ቢያ ባኮ ጎዳሢም ኬኤዜኔ፤ ዬያሮ ማኣሮ ዓዳሢ ዻጋዻዖ፥ ዓይሢንቲ ማዻሢም ‹ዑኬና ካታሞኮ ዳልጎ ጎይፆና ጊዴ''ና ቲቂ ዓኣዻ ጎይፆና ዴንዲጋፓ ማንቆ ዓሶ፥ ኩቺና ቶኪና ዱጴ ዓሶ፥ ዓኣፓ ባይቄ ዓሶና ሃሣ ዎቦ ዓሶዋ ዔኤሊ'' ሃኒ ዔኪ ሙኬ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ዓይሢንቲ ማዻሢያ ሙካዖ ጎዳሢ ኮራ ‹ታ ጎዳሢዮ! ኔኤኒ ታና ዓይሤ ባኮ ቢያ ታ ማዼንቴ፥ ሃጊ ቤዛ ኩሚባኣሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ዬያሮ ማኣሮ ዓዴ ማዻሢም ‹ማኣራ ታኣኮ ኩማንዳጉዲ ካታሞኮ ዙሎ'' ዔኪ ዓኣዻ ዳልጎ ጎይፆና ቲቂ ዓኣዻ ጎይፆና ዴንዲ ዓቴ''ያ ሜሌ'' ዓሲያ ሃሣ ሙካንዳጉዲ ዔኤሌ''፤ ");
INSERT INTO mdybse_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ዬንሢ ቤርታ ዔኤሊ''ንቴዞንሢፓ ፔቴ'' ዓሲታዖ ታኣኮ ሙዖ ሙዓዓኬ› ጌዔኔ፤ ታ ዒንሢም ጋዓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ሚርጌ ዓሲ ዬሱሴና ዎላ'' ዓኣዻንቴ ዒዚ ዔያቶ ባንሢ ሺሪጋፓ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ታ ባንሢ ሙካሢ ቢያ ፔኤኮ ዓዶና ዒንዶና ማቾና ናኣቶ''ና ጌርሲንሢና ጌሮንሢና ሓሣ ፔ ሼምፓሢያ ታ ጊዳ''ፓ ባሼ ናሽካያ ማዔቶ፥ ታ ዓሲ ማዓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ሓሣ ሃይቢ ሄላ''ንዳኣና ጊኢጌያ ማዒባኣሢ ታኣኮ ጊንፆ ሃንታ ናይ ማዓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ዒንሢዳፓ ፔቴ'' ዓሲ ሹቺና ማዦ ማኣሪ ማዣኒ ኮዔቶ ማዾ'' ማዺ ጋፒሳኒ ዋኣዺ ሚኢሼ ኮይሳያታቶዋ ቤርታዺ ዴዒ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ጋዓንቴ ሹጮና ማዦ ማኣሮ ማዢፆ ዓርቃዖ ጋፒሳኒ ዳንዳዒባኣያታቴ ዓይፆይዳ ዓቴ'' ማኣሬሎ ዛጋ ዓሳ ቢያ ዒዛ ቦሃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹ሃኣዛጉዋቴ፤ ሃይ ዓሢ፥ ማኣሪ ማዣኒ ዓርቄዖ ጋፒሳኒ ዳንዳዒባኣሴ› ጌዒ ጌዒ ሃሣ ዒዛ ፓሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«ሃሣ ጊንሣ ታጶ ሺያ ፖኦሊሴ ዓኣ፥ ፔቴ'' ዓጪኮ ካኣቲ ሜሌ'' ላማታሚ'' ሺያ ፖኦሊሴ ዔኪ ዖላኒ ሙካ ካኣቲና ዎላ'' ዖልታኒ ኮዔቶ ቤርታዺ ፔኤኮ ሞርኮ ባሻኒ ዳንዳዓያ ማዔቶ ዔራኒ ዴዒ ዞርታኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ዳንዳዑዋያ ማዔቶ ጋዓንቴ ዒዛ ዖላኒ ሙካ ካኣታ''ሢ ሃጊ ሃኬ ዓኣንቴ፥ ዬይ ካኣታሢ ጪማቶ ዓሲ ዳካኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ዬያጉዲ ዒንሢዳፓ ፔኤኮ ዓኣ ባኮ ቢያ ሃሺ''ባኣ፥ ዓይጎ ዓሲታቶዋ ታ ዓሲ ማዓኒ ዳንዳዒንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ዬካፓ ሃሣ ዬሱሴ፦ «ሶኦጌ ኮሺኬ፤ ሶኦጌ ሶኦጌ ማዒባኣያታቶ ዓይጎና ጊንሣ ሶኦጌ ማሂንታንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ዬኖጉዴ ሶኦጌላ ጎሽኪንታ ዓጮ''ም ማዔቶዋ ሃሣ ጎሺ ማሊ''ሳኒያ ላኣሊንቱዋ ቡኡራጉዲ ማዔሢሮ ጉሪ ኬኬኤሪንታንዳኔ፤ ዓካሪ ዋይዛ ዋይዚ ዓኣሢ ዋይዞንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ኮርሞ ዓሶይዳፓ ሚኢሾ ቡኩሳ ዓሶና ጎሞ ዓሶና ቢያ ዬሱሴ ዔርዛ ዔርዚፆ ዋይዛኒ ቡኪንቲ ዒዛ ኮራ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ፔርሴ ዓሶና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ጋዓንቴ ዬያ ዛጋዖ፦ «ሓይ ሃይሾ ጎሞ ዓሶ ናሽኪ ዔኪ፥ ዔያቶና ዎላ'' ሙዓኔ» ጌዒ ጌዒ ዬሱሴ ዾንኪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ዬያሮ ዬሱሴ ሃያ ኮኦኪንሦ ዔያቶም ሂዚ ጌዒ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ዒንሢዳፓ ፄኤታ ማራይ ዓኣ ዓሲ ፔቴ'' ማራይ ባይቄቶ ዎይታንዳያ ዒንሢም ማላይ? ታዞጲታሚ ታዞጶ ማራቶ ካያ ሃሺ''፥ ዬያ ባይቄ ማራዓሢ ዴንቃኒ ኮዓኒ ዴንዳዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ዬካፓ ዒዚ ዴንቃዖ ኮሺ'' ዎዛዺ፥ ጌኤታ ኬዲ ማሂ ዔኪ ሙኪ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ማኣሪ ሄሌ''ስካፓ ፔኤኮ ላጎና ዓሺኖና ፔቴ''ይዳ ዔኤሊ''፦ ‹ታኣኮ ባይቄ ማራዓሢ ታ ዴንቄሢሮ ታ ዎዛዻኔ፤ ታኣና ዎዛዹዋቴ!› ዔያቶም ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ጎሜ ቡኡፂ ማዓኒ ኮይሱዋ፥ ታዞጲታሚ'' ታዞጶ ጌኤዦ ዓሶይዳፓ ባሼ ጎሞ ቡኡፂ ጌኤሽካ ፔቴ'' ጎሜ ዓሲ ዛላና ፆኦሲ ካኣቱሞይዳ ዎዛ ማዓኔ ታ ዒንሢም ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ሄሊ''ሳዖ ዬሱሴ፦ «ታጶ ቢራ ዓኣ ላኣሊኮ ፔቴ'' ቢራ ባይቄቶ ዒዛ ዎዳ''ንዳያ ዒንሢም ማላይ? ፖዒ ፖዒሲ ጋሮዋ ፒፂ'' ዴንቃንዳያ ሄላ''ንዳኣና ዓኣሺንቴ ቤዞ ቢያ ኮዓዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ዬካፓ ዒዛ ዴንቃዖ ዒዞኮ ላጎና ዓሺኖና ፔቴ''ይዳ ዔኤሊ'' ‹ታኣኮ ባይቄ ቢሬሎ ዴንቂ ታ ዎዛዻሢሮ፥ ታኣና ዎላ'' ዎዛዹዋቴ!› ዔያቶም ዒዛ ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ጎሜ ቡኡፂ ጌኤሽካ ፔቴ'' ጎሜ ዓሲ ዛላና ጫሪንጮይዳ ኪኢታንቻ ዬያጉዲ ዎዛዻኔ፥ ታ ዒንሢም ጋዓኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ሃሣ ዬሱሴ፦ «ፔቴ'' ዓሲኮ ላምዖ ናይ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ጌኤዛሢ ዓዳሢ ኮራ ‹ዓዴ! ኔኤኮ ዓኣ ባካፓ ፓቂ፥ ታና ሄላ''ዞንሢ ሃሢ ታኣም ዒንጌ› ጌዔሢሮ፥ ዓዳሢ ዓኣ ባኮ ላምዖ ናኣቶ''ም ጊሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ዻካ'' ኬሊ''ኮ ጊንፃፓ ጌኤዛሢ ፔኤኮ ፓቂ ዔኬ ባኮ ሻንቺያ ሻንቺ ሃሣ ላኣሚያ ላኣሚ ዔካዖ ሃኬ ዓጪ ዴንዴኔ፤ ዒኢካ ዒ ዓኣዼ ቤዛ ፔኤኮ ሚኢሾ ቢያ ጉሪ ላኣሊ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ሚኢሾ ዒ ፔኤኮ ቢያ ጋፒሴስካፓ ዬኖ ዓጬ''ሎይዳ ሚርጌ ናይዚ ኬስኬሢሮ ሜቶይዳ ዒ ኬዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ዬያ ሜታሢዳፓ ዔቄያና ዬኖ ዓጮ''ይዳ ዓኣ ፔቴ'' ዓሲስኬያ ኮይላ'' ናንጋኒ ጌላዛ፥ ዬይ ዓሢ ፔኤኮ ቆሎ ጉዱንፆ ሄንቂሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ናያ ዶዴሢሮ ናዓሢ ጉዱንፃ ሙዓ ሃኣኮ ዲልቦ ሙዒ ሚሽካኒ ዓፃዼቶዋ ዬያ ዒዛም ዒንጋ ዓሲ ባይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ዒማ''ና ናዓሢ ፔኤኮ ዻቢንቶ ዔሪጋፓ ‹ታ ዓዶ ማኣሮይዳ ማዾ'' ማዻኒ ጌላ ዓሳ ካሦ ሙዒ ሚሽኬም ዓዓታንቴ፥ ታኣኒ ሃይካ ናዮና ሃይቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ዓካሪ ታ ዔቂ ታ ዓዶ ኮይላ'' ዓኣዺጋፓ፦ «ዓዴ! ፆኦሲና ኔኤናና ቤርታ ታ ዻቤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ሃካፓ ሴካ ኔ ናይ ታ ጌይንታኒ ታኣም ኮይሱዋሴ፤ ጋዓንቴ ኔኤኒ ማዺሻ፥ ዓይሎ''ይዳፓ ፔቴ''ሢ ታና ማሄ ታ ጋዓንዳኔ» › ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ዬያ ጋዓዖ ዔቂ ዓዶ ባንሢ ዓኣዼኔ። «ዬካፓ ዓዴ ሃጊ ሃኬ ዓኣንቴ ናዓሢ ዴንቃዖ፥ ሚጪንቲ ዒዛ ባንሢ ጳሽኪ ኮንቂ ዒዛ ሄርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ናዓሢያ፦ ‹ዓዴ! ፆኦሲና ኔኤና ቤርታ ታ ዻቤኔ፤ ሃይፓ ሴካ ኔኤኮ ናይ ጌይንታኒ ታና ኮይሱዋሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ዓዴ ጋዓንቴ ማዻ ዓሶ ዔኤላ''ዖ፦ ‹ዑካዺ ቃራ ማኣዖ ዔኪ ሙኪ ማይሱዋቴ፤ ኬኤሎ''ይዳ ዢኢሮ፥ ቶኮ''ይዳኣ ዱርሲ ዓኣሡዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ሃሣ ቃራ ማሊ'' ቡዋ ዔኪ ሙኪ ሹኩዋቴ፥ ሙዒ ኑ ዎዛዾም፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ዓይጎሮ ጌዔቶ ሃይ ናዓሢ ታኣኮ «ሃይቄኔ» ታ ጌዔንቴ፥ ሃይሾ ሃሢ ሼምፖና ዓኣያ ማዔኔ፤ ባይቄያታዖ ጴዼኔ› ጋዓዖ፥ ዎዛዺሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«ዬማና ቶይዳሢ ማዾ''ሮ ቦኦሎ'' ዓኣዼዖ ማዒ ሙኪ ማኣሮኮ ዑኬ ዎዶ''ና ኮሢ ኮርጎንቴ ዋይዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ዬካፓ ዒዚ ዓይሎ''ይዳፓ ፔቴ''ስኬያ ዔኤላ''ዖ ‹ሓይ ዓይጎዳይ?› ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ዓይላ''ሢ ማሃዖ ‹ኔ ጌኤዚ'' ማዒ ሙኬኔ፤ ኔ ዓዴ ዒ ኮሺ ዓኣንቴ ዒዛ ዴንቄሢሮ ማሌ'' ቡዋሢ ዒዛም ሹኬኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«ዬያሮ ቶይዳሢ ሚርጌና ዻጋዻዖ፦ ‹ማኣሪ ታ ጌላዓ› ጋዓዛ፥ ዓዴ ካሮ'' ኬስኪ ጌላንዳጉዲ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ናዓሢ ጋዓንቴ ዓዶም ‹ሃኣዛጌ፥ ሃያጉዴ ሌዔ ታ ኔኤም ማዼኔ፤ ኔ ዓይሤ ባኣዚ''ያ ዒፂ ታ ቤቂባኣሴ፤ ዓካሪ ታኣኒ ታ ላጎንሢና ዎላ'' ዎዛዻንዳጉዲ ፔቴ'' ዋናናይታዖ ታኣም ኔ ዒንጊ ቤቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ሃይ ኔኤኮ ናዓሢ ጋዓንቴ ኔጊዳፓ ፓቂ ዔኬ ባኮ ዞኦዞ ላኣሎና ዎላ'' ኩርሲ ማዔ ዎዶ''ና ማሌ'' ቡዋሢ ኔ ዒዛም ሹኬኔ› ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ዓዳሢ ማሃዖ፦ ‹ታ ናዓሢዮ! ኔኤኒ ቢያ ኬሊ'' ታኣና ዎላ''ኬ፤ ታኣሲ'' ጉቤ ኔኤሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ሃይ ኔ ጌኤዚ'' «ሃይቄኔ» ታ ጌዔንቴ፥ ሃሢ ሼምፖና ዓኣያ ማዔኔ፤ ባይቄያታዖ ሃሢ ጴዼኔ፤ ዬያሮ ሚርጌ ኑ ዎዛዻንዳያ ኑና ኮይሴኔ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ሓሣ ዬሱሴ ፔኤኮ ጊንፆ ሃንታዞንሢም፦ «ፔቴ'' ዖርጎቺ ዓሲስኬያኮ ማኣሮይዳ ዒናና ማሊ ዔሪ ሙኡዚ'' ዎይሣ ፔቴ'' ዓሲ ዓኣኔ፤ ዓሳ ‹ሃይ ኔኤኮ ዓሶ ዎይሣ ዓሢ ኔኤኮ ዓኣ ባኮ ላኣሊ ባይዛኔ› ጌዒ ዖርጎጫሢም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ዬካፓ ዖርጎጫሢ ዬያ ፔኤኮ ማዻ ዓሢ ዔኤሊ''ሳዖ ‹ሃይ ታ ኔኤኮ ዋይዛ ባካ ዓይጌንዴዳይ? ዓካሪ ሃይፓ ሴካ ታኣኮ ኔ ማኣሮ ዓሶ ሙኡዛ ዓሲ ማዓኒ ዳንዳዑዋሴ፤ ኔ ዎንዴ ዬኖ ማዾ'' ማዻኣና ዓኣ ሚኢሾና ዓኣ ባኮና ቢያ ታኣም ሺኢሼ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ዬይ ማዾ'' ዓሢ ፔ ዒኖና ‹ማይ ሃይፓ ሴካ፥ ታ ጎዳሢ ታኣኮ ዎንዴ ዓሶ ሙኡዚፆ ማዾ''ይዳፓ ታና ኬሳ''ኒኬ፤ ዓካሪ ታ ዎዴ''ቶ ኮሽካንዳይ? ጎሽካኒ ታ ዳንዳዑዋሴ፥ ሺኢቃኒያ ታና ቦርሳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ጫክ፥ ታ ማዻንዳ ባኣዚ'' ዔራኔ፤ ታ ዒዛኮ ማኣራ ዓሶ ሙኡዚፆ ማዻ''ፓ ኬስኬ ዎዶ''ና ዒዛኮ ማኣሮይዳ ታና ናሽካ፥ ታኣኮ ላጌ ማዔ ዓሲ ጴዻንዳጉዲ ታ ማዻንዳኔ› ሂዚ ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«ዬካፓ ዒዛ ጎዳኮ ጋሌና ዓኣ ዓሶ ቢያ ፔቴ'' ፔቴ'' ዔኤላ''ዖ፥ ቤርታኣሲ ኮራ ‹ታ ጎዳሢም ኔ ጪጋንዳ ጋሌ ዓኣፒኒ ኔ ዑፃ ዓኣይ?› ጌይ ዒዛ ዖኦጬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ዒዚ ማሃዖ ‹ፄኤታ ዖቲ ኩሙሢ፥ ዛይቴ ታ ጪጋንዳያ ዓኣኔ› ጋዓዛ፥ ሙኡዛሢያ ‹ሃቦ ፃኣፒ ዓርቆ ባኮ፥ ዑኬና ዴዒጋፓ ዶንጊታሚ'' ዖቲ ዛይቴ ጌዒ ፃኣፔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ላምዓሳሢያ ዔኤላ''ዖ ‹ኔ ዑፃ ዓኣፒኒ ጋሌ ዓኣይ?› ጋዓዛ፥ ዒዚ ማሃዖ ‹ፄኤታ ሓሬ ጫኣና ማዓ ዛርጌ ጋሌ ዓኣኔ› ጌዔኔ፤ ሙኡዛሢያ ‹ሃኣዛጌ ፃኣፒ ዓርቆ ባኮ! ሳሊ''ታሚ'' ሓሬ ጫኣና ጌዒ ፃኣፔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ዬይ ዖርጎጮ ዓሢ ጉሙርቂንቲባኣ፥ ፔ ማኣራ ሙኡዛ ዓሢ ጪንጩሞና ዒ ማዼ ማዾ'' ሄርሼኔ፤ ዬይ ፆኦሲ ዓሶይዳፓ ባሼ፥ ሃያ ዓጮ'' ዓሳ ሳዖይዳ ዔያታ ናንጋ ናንጎኮ ጪንጫ ማዔሢ ዔርዛኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ሃሣ ሄሊ''ሳዖ ዬሱሴ፦ «ዬያሮ ሃያ ዓጮ'' ሚኢሾና ዒንሢኮ ላጌ ዓርቁዋቴ፥ ታ ዒንሢም ጋዓኔ፤ ዬያ ዒንሢ ማዼያታቶ ዒንሢኮ ሚኢሻ ጋፔም ኩቺ ጉሪ ዒንሢ ማዔ ዎዶ''ና ዒንሢኮ ላጎንሢ፥ ናንጊና ናንጎ ማኣሮይዳ ሾኦቺንሢ ዒንሢ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ዻካ'' ባኣዚ''ና ጉሙርቂንታ ዓሲ ዼኤፒ ባኣዚ''ና ጉሙርቂንታያ ማዓንዳኔ፤ ዻካ'' ባኣዚ''ና ጉሙርቂንቱዋ ዓሲ ጋዓንቴ ዼኤፒ ባኣዚ''ናኣ ጉሙርቂንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ዬያሮ ሃያ ዓጮ'' ቆሎ'' ዎይሢፆና ዒንሢ ጉሙርቂንቱዋያ ማዔቶ ጎጌ ቆሎ'' ዖኦኒ ዒንሢ ጉሙርቂ ዒንጋንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ሃሣ ሜሌ'' ዓሲ ባኣዚ''ና ጉሙርቂንቱዋያ ዒንሢ ማዔቶ፥ ዒንሢም ማዓ ባኣዚ'' ዖኦኒ ዒንሢም ዒንጋንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«ፔቴ'' ዓሲ ፔቴ''ና ላምዖ ዎይሣ ዓሲም ዎርቃኒ ዳንዳዑዋሴ፤ ያዺ ማዔያታቶ ፔቴ''ሢ ዒፂ ባጋሢ ናሽካንዳኔ፤ ሃሣ ፔቴ''ሢ ቦንቺ ባጋሢ ቦሃንዳኔ፤ ዬያጉዲ ሚኢሼም ዎርቃ ዓሲ ፆኦሲም ማዻያ ማዓኒ ፔቴ''ታዖ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ፔርሴ ዓሳ ሚኢሼ ናሽካያ ማዔሢሮ ዬሱሴ ዬያ ጌዔ ባኮ ቢያ ዋይዚ ዒዛኮ ጌኤዞ ቦሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ዒዚ ጋዓንቴ ዒንሢ ዒ'ንሢ ቶኦኮ'' ዓሲ ቤርቲዳ ጌኤሺ ማሊሳኔ፤ «ፆኦሲ ጋዓንቴ ዒንሢኮ ዒኖ ዔራኔ፤ ዓይጎሮ ጌዔቶ ዓሲ ቤርቲዳ ቦንቺንታያ ማሊ ጴዻሢ ቢያ፥ ፆኦሲ ቤርቲዳ ቦሂንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ዬሱሴ ቃሲ'' ኬኤዛዖ፦ «ሙሴ ዔርዜ ዎጎና ፆኦሲ ማሊፆ ኬኤዛ ዓሶኮ ማፃኣፓ ሙኪ ማስካ ዮሓኒሴ ዎዶ'' ሄላ''ንዳኣና ኬኤዚ ኬኤዚ ዴዔኔ፤ ሃሢ ዬካፓ ሃንጋ ኬኤዛሢ ፆኦሲ ካኣቱሞ ኮዦ ሃይሶኬ፤ ፔቴ'' ፔቴ'' ዓሳ ዬኖ ካኣቱሜሎይዳ ጌላኒ ኮሺ'' ሜታዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ማዔቶዋ ዎጎይዳፓ ፔቴ'' ባኣዚ'' ባይቃስካፓ ጫሪንጮና ሳዖና ዓኣዻኒ ሼሌዔ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«ማቾ ፔኤኮ ዓንጂ ሜሌ'' ላኣሊ ዔካሢ ቢያ ዞኦስካ ኮኦማያ ማዓኔ፤ ዬያጉዲ ሃሣ ፔ ዓኒፓ ዓንጂንቴ ላኣሌሎ ዔካሢያ ፔና ዒኢሳ''ኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ሃሣ ዬሱሴ፦ «ዲንኪ ዞቄ ማኣዖና ሃሣ ሻኣዣ፥ ሚዛጲ ዓፒላ ማይንታ ፔቴ'' ዖርጎቺ ዓሲ ዓኣኔ፤ ዒዚ ቢያ ኬሊ''ና ሚርጌ ዎዛና፥ ሜታ ባኣያ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ዒማ''ና ዒዛ ካራ ዑፃ ቢያ ኪሢ ሌሊ ማዔ ዓላዓዜሬ ጌይንታ ፔቴ'' ማንቆ ዓሲ ላሂ ናንጋኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ዬይ ማንቆ ዓሢ ዖርጎጫሢ ሙዖይዳፓ ዲኢናሢ ሙይ ሚሽካኒ ኮዓኔ፤ ዬያ ዖርጎጫሢኮ ካናታኣ ሙኪ ሙኪ ማንቃሢኮ ኪፆ ላዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«ዬካፓ ዬይ ማንቆ ዓሢ ሃይቄም፥ ፆኦሲ ኪኢታንቻ ሎ ዓብራሃሜ ኮራ ዒዛ ዔኪ ዓኣዼኔ፤ ዬያጉዲ ሃሣ ዖርጎጮ ዓሢያ ሃይቂ ዱኡቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ዬኖና ጋፒንፃ ጴዹዋ ዔቶ'' ሜታሢ ቤዞይዳ ዒ ሜታዺቤቃ ዼ'ጊ ጌዒ ዓብራሃሜና ኮይሎ''ይዳ ዓኣ ዓላዓዜሬያ ሃኬና ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ዬካፓ ዒዚ ዑኡዞ ዼ'ጊዲ ‹ታ ዓዳሢዮ ዓብራሃሜ! ሃዳራ ታኣም ማሌቴራ፤ ሃይካ ታኣኒ ታሚዳ ሚርጌና ሜታዻሢሮ ፔኤኮ ኬኤሎ'' ቤርቶ ዋኣሢዳ ዳኪ ታኣኮ ዒንዲርዞ ሺሚሳንዳጉዲ ዓላዓዜሬ ታኣም ዳኬ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«ዓብራሃሜ ጋዓንቴ ‹ታ ናዓሢዮ! ኔኤኒ ኔኤኮ ሳዖ ናንጎ ዎዶ''ይዳ ሚርጌ ኮሺ ባኣዚ'' ዴንቂ ዎዛዼሢ ማሊ ጶቂሡዋይ? ዓላዓዜሬ ጋዓንቴ ዬኖ ዎዶ''ና ሜቶይዳ ዓኣኔ፤ ዬያሮ ሃሢ ዒዚ ሃይካ ዎዛዻኔ፤ ኔኤኒ ጋዓንቴ ሜታዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ዬይያ ዓኣንቴ ኑኡና ዒንሢና ባኣኮ''ይዳ ፑኡፒ ማጊ ዓኣኔ፤ ዬያሮ ኑ ኮይላ''ፓ ዒንሢ ባንሢ፥ ዒንሢ ኮይላ''ፓ ኑ ባንሢ ፒንቃኒ ዳንዳዒንቱዋሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ዬካፓ ዖርጎጮ ዓሢ ‹ታ ዓዳሢዮ! ያዺ ማዔቶ ሃዳራ ዓላዓዜሬ ሊካ ታ ዓዶ ማኣሪ ዳኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ዒኢካ ሉ ታኣኮ ዶንጎ ጌርሲንሢ ዓኣሢሮ ዔያታ ሃሣ ሃያ ፑርቶ ሜታሢ ቤዞ ሙኩዋጉዲ ዒዚ ዔያቶም ላቲ'' ኬኤዞንጎ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«ዓብራሃሜ ጋዓንቴ ‹ሙሴና ፆኦሲ ማሊፆ ኬኤዛ ዓሶናኮ ማፃኣፓ ዔያቶ ኮራ ዓኣኔ፤ ዬያቶይዳፓ ዔያታ ዋይዞንጎ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ዖርጎጮ ዓሢ ‹ታ ዓዳሢዮ፥ ዓብራሃሜ! ዬይ ጊዳያቱዋሴ፤ ጋዓንቴ ፔቴ'' ዓሲ ሃይቢዳፓ ዔቂ ዴንዲ ዔያቶም ኬኤዜቶ፥ ዻቢንቶ ፔኤኮ ዔሪ ጎማፓ ማዓንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ዓብራሃሜ ማሃዖ ‹ሙሴሲና ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፓ ዔያቶም ጋዓሢ ዔያታ ዋይዚባኣያታቶ፥ ፔቴ'' ዓሲ ሃይቢዳፓ ዔቂ ዔያቶም ኬኤዜቶዋ ዒዛሲ ጉሙርቂ ጎናሲ ዔያታ ዔካዓኬ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ዬሱሴ ፔኤኮ ጊንፆ ሃንታ ናኣቶ''ም፦ «ዓሲ ዻቢሲ ጎሜይዳ ጌልዛ ባኣዚ'' ሙኩዋዖ ፔቴ''ታዖ ዓታዓኬ፤ ጋዓንቴ ጎሜ ማዒ ዻቢሳ ባኣዚ'' ዔኪ ሙካ ዓሢም ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ዖናታቴያ ሃንሢ ዻኮ'' ናኣቶ''ንሢዳፓ ፔቴ'' ዻቢሲ ጎሜ ማዺሳያይዳፓ ዎንሢ ሹቺ ባቃና'' ቱኪ'' ዋኣፆ ባዞ''ይዳ ጌሌቴ ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ዬያሮ ዒንሢ ዒንሢና ዔሩዋቴ። ኔ ዒሻሢ ኔኤም ፑርቲሲ ዻቤቶ ዞሪ ጎሬ፤ ዒዚ ፔ ዻቢንቶ ዔሪ ‹ታ ዻቤኔ› ጌዔቶ ዓቶም ጌዔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ሃና''ኣ ዓቢዳ ሌሊ ላንካይ ማይንቲ ኔኤም ፑርቲሲ፥ ዻቢ፤ ሃሣ ላንካይ ማይንቲ ሙኪ ሙኪ ‹ታ ዻቢንቶ ታ ዔሬኔ› ጌዔቶ ዓቶንጎ ዒዛም ጌዔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ዳኪንቴዞንሢያ ዬሱሴ ኮራ፦ «ሃዳራ ኑም ጉሙርቂሢ ቃሴ''» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ጎዳ ዬሱሴ ማሃዖ፦ «ሴናፒጬ ጎዖ ባኬሎኮ ዓኣፖ ዻኮ''ማ ጉዴያ ማዓ፥ ጉሙርቂሢ ዒንሢኮ ዓኣቶ ሃያ ሻኣቦ'' ‹ሃይካፓ ቱጊንቲ ባዛ'' ኬዴ''› ዒንሢ ጌዔቶ ዒንሢም ዓይሢንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ዬካፓ ሃሣ ዬሱሴ፦ «ዒንሢኮ ፔቴ'' ጎሺ ጎሽካይ ሃሣ ጊንሣ ማራይ ሄንቃ ዓሲ ዓኣቶ ዬይ ማዻ ዓሢ ማዻ''ፓ ማዔ ዎዶ''ና ቤዞና ‹ሃኒ ሙኪ ካዎ ሙዔ› ዒዛም ጋዓ? ");
INSERT INTO mdybse_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ዬያፓ ‹ዓካሪ ታኣም ካዎ ጊኢጊሼ፥ ታ ሙዒ ዑሽካንዳኣና ታና ሙኡዛያ ማዔ፤ ዬካፓ ኔኤኒ ሙዓንዳኔ› ጋዓያቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ያዺ ማዔቶዋ ዬይ ማዻሢ ዬያ ዓሢ ባኮ ኩንሤሢሮ ዒዛኮ ጎዳሢ ዒዛ ጋላታያ ዒንሢም ማላ? ");
INSERT INTO mdybse_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ዒንሢያ ዬያጉዲ ዒንሢ ዓይሦና ባኮ ቢያ ኩንሤሢኮ ጊንፃ ‹ኑኡኒ ፓሡዋ ማዻ ዓሶንሢኬ፤ ኑ ኩንሤሢያ ኑኡኒ ማዻንዳጉዲ ኑም ኮይሳ ባኮንሢ ሌሊኬ› ጎዑዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ዬሱሴ ዬሩሳላሜ ባንሢ ዴንዳዖ ሳማሪያና ጌሊላ ዓጮ''ናኮ ሳዞ''ና ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ፔቴ'' ጉርዳስኬኖ ዒ ጌላዛ ዑፃ ኬስካ ዶርዓሢና ዓዺንቴ ታጶ ዓሲ ዒዛ ኮይላ'' ሙኪ ሃኬ ዔቃዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ዑኡዞ ፔኤሲ'' ዼ'ጊዲ፦ «ዬሱሴ! ዔርዛሢዮ! ሃዳራ ኑም ማሌቴራ» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ዬሱሴ ዔያቶ ዛጋዖ፦ «ዴንዱዋቴ! ዒንሢኮ ዑፆዋ ቄኤሶም ዻውዋቴ» ዔያቶም ጋዓዛ፥ ዔያታ ዓኣዻ ጎይሣ ዓኣንቴ ዔያቶኮ ዑፃ ኬስካ ዶርዓሢ ባይቄም ዔያታ ጌኤሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ዔያቶይዳፓ ፔቴ''ሢ ዬያ ዶርዓሢዳፓ ጌኤሽኬሢ ዛጌ ዎዶ''ና ዼ'ጊ ጌዔ ዑኡሲና ፆኦሲ ጋላቲ ጋላቲ ጊንሣ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ዬይ ዓሢ ዬሱሴያ ጋላቲ ጋላቲ ዒዛኮ ቶኮ'' ዴማ'' ባሊቲና ሎኦሜኔ፤ ዒዚ ዬይ ዓሢ ሳማራ ዓጪ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ዬሱሴ፦ «ዑፃ ኬስኬ ዶርዓሢዳፓ ዻቂ፥ ጌኤሽኬ ዓሳ ታጶቱዋዓዳ? ሂዳዖ ታዞጶንሢ ዓንኮ ጌሌይ? ");
INSERT INTO mdybse_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ፆኦዛሢ ጋላታኒ ማዒ ሙኬሢ ሃያ ሜሌ'' ዜርፃሢዳፓ ዓታዛ ሜሌ'' ባኣዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ዬካፓ ዬሱሴ ዬያ ዓሢ ኮራ፦ «ዔቂ፥ ዴንዴ፤ ኔ ጉሙርቂፃ ኔና ዻቂሼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፔርሴ ዓሳ ዬሱሴ ኮራ፦ «ፆኦሲ ካኣቱማ ዓይዴ ሙካንዳይ?» ጌዒ ዖኦጫዛ፥ ዒዚ ዔያቶም፦ «ፆኦሲ ካኣቱማ ሙካንዳሢ ዓሳ ዛጊ ካፓ ጎይፆናቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ዬያጉዲ ሃሣ ‹ሃይሾ ሃካኬ ሃሣ ሴኬያኬ› ጌይንታያቱዋሴ፤ ዓይጎሮ ጌዔቶ ፆኦሲ ካኣቱማ ሃሢ ዒንሢኮ ባኣካ'' ማዔሢሮኬ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ሄሊ''ሳዖ ዬሱሴ ፔኤኮ ጊንፆ ሃንታ ናኣቶ''ም፦ «ዓሲ ናዓሢኮ ኬሎ''ይዳፓ ፔቴ''ማታዖ ‹ኑና ዓይጌ ዛጊሳንዳይ?› ዒንሢ ጋዓንዳ ኬሊ'' ሙካንዳኔ፤ ጋዓንቴ ዒንሢ ዛጋዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ዓሳ ‹ሃይሾ ኪሪስቶሴ ሃካኬ! ሃሣ ሴኬያኬ!› ዒንሢም ጋዓንዳኣኬ፤ ጋዓንቴ ዔያታ ዒንሢም ጋዓ ባኮ ጉሙርቂ ዔያቶ ጊንፆ ዓኣዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ዜኤሊንሢ ጫሪንቺዳ ዜኤሊንሣዖ፥ ካራ''ፓ ካሮ'' ሄላ''ንዳኣና ፖዓሢጉዲ ዓሲ ናዓሢ ሙካ ኬሎ''ናኣ ያዺ ማዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ጋዓንቴ ዓሲ ናዓሢ ቤርታዺ ሚርጌ ሜቶ ዔካንዳሢና ሃኖ' ዎዶ'' ዓሶና ቦሂንታንዳሢ ዓቱዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ኖሄ ዎዶ''ና ማዔሢጉዲ፥ ዓሲ ናዓሢ ሙኮ ዎዶ''ናኣ ያዺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖሄ ዋኣፆ ካኣሚሎይዳ ጌላንዳያ ሄላ''ንዳኣና ዓሳ ሙዒያ ሙዒ ዑሽኪያ ዑሽኪ ዔፒያ ዔካንቴ፥ ዬኖ ዎዶ''ና ባይሲንቶ ዋኣፃ ሙኪ ቢያሢ ዔኤዺ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ዬያጉዲ ሎኦፄ ዎዶ''ና ማዔሢጉዲያ ማዓንዳኔ፤ ዬኖ ዎዶ''ና ዓሳ ሙዒ ዑሽካንቴ፥ ሻንቺያ ሻንቺ ሓሣ ሻንቂያ ሻንቃንቴ፥ ሙዖ ሚሢያ ቱኪ'' ቱኪ'' ማኣሪያ ማዣንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ጋዓንቴ ሎኦፄ ሶዶሜይዳፓ ኬስኬ ኬሎ''ና ታሚና ታሚኮ ፂኢሊ''ና ጫሪንጮይዳፓ ዋርቂ ቢያሢ ሙዒ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ዓሲኮ ናዓሢ ሙካ ዎዶ''ናኣ ያዺ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«ዬኖ ኬሎ''ና ማኣሮ ቶኦኮ''ይዳ ዓኣ ዓሢ፥ ማኣሮይዳ ዓኣ ሜሆ'' ዔካኒ ኬዶ''ፓ፤ ጎዦይዳ ዓኣ ዓሢ ሃንጋ ማኣሮ ባንሢ ማዖፓ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ሎኦፄ ማቾ ጶቂሢ ማሉዋቴ! ");
INSERT INTO mdybse_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ፔ ሼምፓሢ ዻቂሻኒ ኮዓሢ ቢያ ባይዛንዳኔ፤ ሼምፓሢ ፔኤኮ ዓኣሢ ዒንጋሢ ቢያ ዻቂሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ዬኖ ዋንቴሎ ላምዖ ዓሲ ፔቴ'' ሻኣላ''ይዳ ላሃንዳኔ፤ ዔያቶይዳፓ ፔቴ''ማ ዔኪንታዛ፥ ባጋሢ ዓታንዳኔ፤ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ላምዖ ላኣሊ ሃሣ ፔቴ'' ቤሲዳ ዎላ'' ዎንሢ ዎዻንዳኔ፤ ፔቴ''ዛ ዔውታንዳኔ፥ ባጌላ ዓታንዳኔ።  ");
INSERT INTO mdybse_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ላምዖ ዓሲ ፔቴ'' ጎሺዳ ዎላ'' ማዻንዳኔ፤ ፔቴ''ሢ ዔውታንዳኔ፥ ባጋሢ ዓታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬሱሴ ኮራ፦ «ጎዳሢዮ! ዔያታ ዓንኮ ዔኪ ዓኣዺንታይ?» ጌይ ዒዛ ዖኦጬኔ። ዒዚ ማሃዖ፦ «ሃይቄ ባኣዚ'' ዓኣ ቤስካ ሃምፑራ ቡካኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ዬካፓ ቤልፃዹዋዖ ቢያ ኬሊ'' ሺኢቃንዳያ ኮይሳሢ ዔርዛኒ ዬሱሴ ኮኦኪንሢ ሂዚ ጌዒ ዔያቶም ኬኤዜኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«ፔቴ'' ካታማይዳ ፆኦሲ ዒጊጩዋያ ሓሣ ‹ታና ዓሲ ዎዚ ጋዓንዳይ› ጎዑዋ ፔቴ'' ዎጌ ዎጋስኬይ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ዒማ''ና ፔቴ'' ዓኒ ሃይቄ ላኣሊስኬና ዬኖ ካታሜሎ''ይዳ ናንጋኔ፤ ዒዛ ዬያ ዎጎ ዎጋሢ ኮይሎ''ይዳ ሙኪ ሙኪ ‹ታኣና ዎላ'' ሞኦቶ ሞኦቲንታ ዓሲ ዓኣሢሮ ታኣም ዎጌ› ዒዛ ኮራ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ዒዚ ዒዞም ዎጉዋዖ ሚርጌ ኬሊ'' ዴዔስካፓ ጋዓንቴ፦ ‹ዎዚ ታ ፆኦሲ ዒጊጩዋቴያ ሃሣ «ዓሲ ታና ዎዚ ጋዓንዳይ» ጎዑዋቴያ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ሃና ዓኒ ሃይቄ ላኣሌላ ታና ሜታሳሢሮ ሌሊ ታ ዒዞም ዎጋንዳኔ፤ ሃንጎ ቢያ ዎዴ ዒዞኮ ሙኪፃ ታኣኮ ጎጳ ዖይዻኔ› » ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ሄሊ''ሳዖ ጎዳ ዬሱሴ፦ «ሚጪንቱዋ፥ ፑርቶ ዎጋሢ ጌዔ ባኮ ሂንዳ ማሉዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ፆኦሲ ዓካሪ ሮኦሪና ዋንቴና ዒላቲ ዒላቲ ሺኢቃ ፔ ዴሮ''ም ዎጋዓዳ? ‹ቻዓ› ጌይ ዔያቶም ዒንጎንዶ ባኮ ቃዚ ኔጊሳንዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ኔጉዋዖ ሩኡሪና ዔያቶም ዎጋንዳኔ፤ ታ ዒንሢም ጋዓኔ። ጋዓንቴ ዓሲኮ ናዓሢ ሙካ ዎዶ''ና ሳዖይዳ ጉሙርቂሢ ዴንቃንዳ ናንዳኖ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ዬካፓ ሃሣ ዬሱሴ ኑኡኒ ጌኤሺኬ ጌዒ ጌዒ ሄርሺንቲ፥ ሃንጎ ዓሶ ቦሃ ዓሶም ሃያ ኮኦኪንሦ ኬኤዜኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«ላምዖ ዓሲ ሺኢቃኒ ጌኤዦ ማኣሪ ዴንዴኔ፤ ዔያቶይዳፓ ፔቴ''ሢ ፔርሴ ዓሲ ማዓዛ፥ ባጋሢ ኮርሞ ዓሶፓ ሚኢሼ ቡኩሳ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«ፔርሴ ዓሢ ሺኢቆሮ ዔቂጋፓ ዒኖና ‹ፆኦሲዮ! ታኣኒ ሃንጎ ዓሶጉዲ ቡሩዋያ፥ ፑርታ ዓይሢንቱዋያ ሃሣ ማቾ ማዒባኣ ላኣሊና ላሃያ ማዒባኣሢሮ ታ ኔና ጋላታኔ፤ ሃሣ ባሼ ሃያ ሚኢሾ ቡኩሳሢጉዲ ታ ማዒባኣሢሮዋ ኔና ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ታኣኒ ቃልሾ ኬሎ'' ጋሮይዳ ላምዖ ኬሊ'' ሙኡዚ'' ሃሺ'' ሺኢቆ ሺኢጲፆ ሺኢቃኔ፤ ታ ዴንቃ ባኮይዳፓ ቢያ ታጳሢዳፓ ፔቴ''ማ ኬሲ'' ኬሲ'' ኔኤም ዒንጋኔ› ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«ዬይ ሚኢሾ ቡኩሳሢ ጋዓንቴ ሃኬ ዔቃዖ፥ ዼ'ግ ጌዒ ሌካ ጫሪንጮ ዛጋኒታዖ ጫርቂባኣሴ፤ ጋዓንቴ ኩጮና ፔኤኮ ዳዶ'' ባዒ ባዒ ‹ታ ፆኦዛሢዮ! ታና ጎሞሲ ማኣሬ!› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ጌኤሹሞ ዴንቂ ማኣሪ ማዔሢ ዬያ፥ ዓሶፓ ሚኢሾ ቡኩሳሢ ማዓንዳኣፓዓቴም ፔርሴ ዓሢቱዋሴ። ፔ ቶኦኮ'' ዼ'ግዳሢ ቢያ ሂርኪ ጋዓንዳኔ፤ ፔ ቶኦኮ'' ሂርኪዳሢ ጋዓንቴ ዼ'ግ ጋዓንዳኔ» ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ዬሱሴ ዔያቶ ፔ ኩጮና ካኣሚ ፒፃ''ንዳጉዲ ዓሳ ናኣቶ'' ዒዛ ኮይላ'' ዔኪ ሙካዛ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ጋዓንቴ ዬያ ዛጌ ዎዶ''ና ዓሶ ኮራ ጎሪ''ንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ዬሱሴ ጋዓንቴ ናኣቶ'' ሃንጋ ፔ ባንሢ ዔኤላ''ዖ፦ «ፆኦሲ ካኣቱማ ሃንሢጉዴዞንሢም ማዔሢሮ ናኣታ'' ሃንጋ ታ ባንሢ ሙኮንጎ፤ ዔያቶ ላኣጊፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ጎኔ ታ ዒንሢም ጋዓኔ፤ ፆኦሲ ካኣቱሞ ናይጉዲ ሼሌዑሞና ዔኪባኣ ዓሲ ፔቴ''ታዖ ጌላዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ዓይሁዶ ዓሶኮ ሱኡጎይዳፓ ፔቴ''ስኬይ ዬሱሴ ኮራ፦ «ኮዦ ዔርዛሢዮ! ናንጊና ናንጊ ዴንቃኒ ዓይጎ ማዻንዳያ ታና ኮይሳይ!» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ዬሱሴ ማሃዖ፦ «ዓይጎሮ ኔ ታና ኮሺ ጋዓይ? ፔቴ'' ፆኦሲዳፓ ዓታዛ ኮሺ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ዓይሢፆንሢ ኔ ዔራኔ፤ ዬንሢያ፦ ‹ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂፖ፥ ዓሲ ዎዺፖ፥ ዉኡቂፖ፥ ሉኡዙሞና ማርካዺፖ፥ ኔ ዓዶና ኔ ዒንዶና ቦንቼ› ጌይንቴዞንሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ዓሢ ማሃዖ፦ «ዬንሢ ዓይሢፆንሢ ናኣቶፓ ዓርቂ ታ ካፓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ዬሱሴ ዬያ ዋይዛዖ ዓሢ ኮራ፦ «ዓካሪ ፔቴ'' ባኣዚ'' ኔ ማዻንዳያ ዓቴ''ኔ፤ ዬይያ ኔኤኮ ዓኣ ባኮ ቢያ ሻንቺ ሚኢሾ ማንቆ ዓሶም ዒንጌ፤ ጫሪንጮ ካኣቱሞይዳ ፃኣፒ ጌሦ ቤዞይዳፓ ኔ ዔካንዳኔ፤ ዬካፓ ሙኪ ታ ጊንፆ ሃንቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ዓሢ ጋዓንቴ ኮሺ'' ዖርጎቺ ማዔሢሮ ዬያ ዋይዛዖ ሚርጌና ዖዬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ዬሱሴያ ዓሢ' ዖዬሢ ዛጋዖ፦ «ዖርጎጮ ዓሶም ፆኦሲ ካኣቱሞይዳ ጌሊሢ ዎማጉዲ ሜታንዳይ! ");
INSERT INTO mdybse_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ዖርጎቺ ዓሲ ፆኦሲ ካኣቱሞይዳ ጌላንዳያይዳፓ ጋኣላ ናርፔ ፂኢናና ጌላኒ ሼሼሌዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ዬያ ዋይዜ ዓሳ፦ «ዓካሪ ዬይ ያዺ ማዔቶ ዖኦኒ ዻቃኒ ዳንዳዓንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ዬሱሴ ጋዓንቴ፦ «ዓሲም ዳንዳዒንቱዋ ባኣዚ'' ፆኦሲም ዳዳንዳዒንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴፂሮሴ፦ «ሃይሾ ኑኡኒ ኑኡኮ ዓኣ ባኮ ቢያ ሃሺ'' ኔ ጊንፆ ሃንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ዬሱሴ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፦ ፆኦሲ ካኣቱሞሮ ጌዒ ፔኤኮ ማኣሮ፥ ማቾ፥ ጌርሲንሢ፥ ሾዔ ዓሶ፤ ሃሣ ናኣቶ''ዋ ሃሻ'' ዓሲ ባሼና ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ዬይ ሃሢ ሃያ ዓጮ''ይዳኣ ሚርጌ ጳንጬና ዔካንዳኔ፤ ሃጊ ሙካ ዓጮ''ይዳኣ ናንጊና ናንጊ ዴንቃንዳኔ ጌይሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ዬሱሴ ታጶ ላምዖንሢ ዱማሲ ዒዛ ባንሢ ሺኢሻዖ፦ «ሃይሾ ኑ ሃሢ ዬሩሳላሜ ዴንዳኔ፤ ዓሲ ናዓሢ ዛሎ'' ፆኦሲ ማሊፆ ኬኤዛ ዓሶና ፃኣፒንቴሢ ቢያ ዒኢካ ኩማንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ዒዚ ዓይሁዴ ማዒባኣ ዓሶም ዓኣሢንቲ ዒንጊንታንዳኔ፤ ዔያታኣ ዒዛ ዓማሊ'' ቦሃንዳኔ፤ ጫሽኪ፥ ዒዛይዳ ጩቲያ ጩታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ዒዛ ዢራፓና ጳርቄሢኮ ጊንፃ ዔያታ ዎዻንዳኔ፤ ጋዓንቴ ሃይሣሳ ኬሎ''ና ሃይባ''ፓ ዒ ዔቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ዒዛኮ ጊንፆ ሃንታዞንሢ ዬያ ቢያ ባኮይዳፓ ፔቴ''ታዖ ማሊ ዒና ዔኪባኣሴ፤ ዒዛ ጌኤዞኮ ዓኣሺንቴ ቡሊ''ፃ ዔያቶም ዔርቲባኣሢሮ ዬይ ዒዛኮ ዎዚ ጌይፆታቴያ ዔያታ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ዬሱሴ ዒያርኮኮ ሙኪ ዑካዛ ፔቴ'' ዓኣፒ ባይቄ ዓሲስኬይ ዒንጎ ሚኢሼ ሺኢቂ ሺኢቂ ጎይፆ ዓጫ ዴዒ ዓኣዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ዒዛኮ ኮይሌና ዓኣዻ ሚርጌ ዓሶ ዑኡዞ ዋይዚ፦ «ሃይ ዓይጎዳይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ዓሳ ማሃዖ፦ «ሓይሾ ናዚሬቶ ዬሱሴ ሃይና ዴንዳኔ» ጌዒ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ዬማና ዓኣፖ ባይቄሢ፦ «ዳውቴ ናዓሢዮ ዬሱሴ! ሃዳራ ታኣም ማሌ» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ዬሱሴኮ ቤርታ ቤርታ ዓኣዻ ዓሳ፦ «ዚቲ ጌዔ!» ጌይ ዒዛ ጎራ''ዛ፥ ዒዚ ጋዓንቴ ዑኡዞ ኮሺ'' ዼ'ግዲ፦ «ዳውቴ ናዓሢዮ! ሃዳራ ታኣም ማሌ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ዬያሮ ዬሱሴ ዔቃዖ፦ «ሃኒ ዒዛ ታ ባንሢ ዔኪ ባውዋቴ» ጌዒ ዓይሣዛ፥ ዓኣፖ ባይቄሢ ዒዛ ኮይላ'' ሙኬም፥ ዬሱሴ ሂዚ ጌዒ ዒዛ ዖኦጬኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«ዓይጎ ታ ኔኤም ማዻንዳጉዲ ኔ ኮዓይ?» ጌዔኔ። ዓኣፖ ባይቄሢ ማሃዖ፦ «ጎዳሢዮ! ዛጋኒ ታ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ዬሱሴ ዒዛም፦ «ዛጌ! ኔኤኮ ጉሙርቂፃ ኔና ዻቂሼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ዬማና ዓኣፖ ባይቄሢ ቤዞና ዛጋኒ ዳንዳዓዖ፥ ፆኦሲ ጋላቲ ጋላቲ ዬሱሴ ጊንፆ ሃንቲሢ ዓርቄኔ፤ ዴራ'' ቢያ ዬያ ዛጋዖ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ዬሱሴ ጎይፆ ሃንቴ ጎይሣ ዒያርኮ ካታሞ ጌላዖ፥ ካታሞኮ ሳዞ''ና ቲቂ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ዒኢካ ዜኪዮሴ ጎዖ ዓሲ ዓኣኔ፤ ዒዚ ኮርሞ ዓሶፓ ሚኢሾ ቡኩሳ ዓሶኮ ሱኡጌ ሃሣ ዖርጎቺ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ዒዚ ዬሱሴ ዎያታቴያ ዛጋኒ ኮዓያታንቴ፥ ዔጳ ዒዛኮ ቃሚሢ ማዔሢሮ ዴሮ'' ሚርጉሞፓ ዔቄያና ዒዚ ዬሱሴ ዛጋኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ዬሱሴ ዒ ዓኣ ቤዞና ዓኣዻሢሮ ዜኪዮሴ ዬሱሴ ዛጋኒ ጌዒ ዴሮ''ኮ ቤርታ ዓኣዻዖ ፔቴ'' ቦኦቢ ጊዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ዬሱሴ ዬኖ ቦኦቦ ዴሞ'' ሄላ''ዖ ሌካ ዼ'ግ ጌዒ ዛጌስካፓ ዜኪዮሴ ኮራ፦ «ዜኪዮሴ! ሃኖ'' ታ ኔ ማኣራ ፔኤቃንዳያ ኮይሳሢሮ፥ ዑኬና ሚፃፓ ኬዴ''» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ዜኪዮሴ ዑኬና ኬዳ''ዖ ዎዛና ዬሱሴ ፔ ማኣራ ሾኦቺንሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ዬያ ዛጌ ዓሳ ቢያ፦ «ሃይ ዓሢ ጎሞ ዓሶ ማኣሪ ሾኦቺንቃኒ ጌሌኔ!» ጌዒ ዬሱሴ ዾንኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ዜኪዮሴ ጋዓንቴ ዔቃዖ ጎዳ ዬሱሴ ኮራ፦ «ጎዳሢዮ! ሃሢ ታኣኮ ዓኣ ባኮይዳፓ ቢያ ሄካሢ ማንቆ ዓሶም ታ ዒንጋንዳኔ፤ ጌሺ ዓሲዳፓ ታ ዔኬ ሚኢሼ ዓኣቴያ፥ ዔኬሢፓ ዖይዶ ጳንጬ ማሂ ታ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ዬሱሴ ማሃዖ፦ «ሃይ ዓሢ ሃሣ ዓብራሃሜ ዜርፃፓኬ፤ ሓኖ'' ዻቂንታ ሃያ ማኣሮም ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ዓይጎሮ ጌዔቶ ዓሲኮ ናዓሢ ባይቄሢ ኮዓኒና ዻቂሻኒ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ዓሳ ዬያ ዋይዚፆይዳ ዓኣንቴ ዬሱሴ ሃሣ ፔቴ'' ኮኦኪንሢ ዔያቶም ኬኤዜኔ፤ ዓይጎሮ ጌዔቶ ዒዚ ዬሩሳላሜ ባንሢ ዑኬሢሮ ዓሶም ፆኦሲኮ ካኣቱማ ሃሢ ዒማ ዎዶ''ና ፔጋዺ ጴዻያ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ዬያሮ ዬሱሴ፦ «ካኣቱሞ ቢታንቶ ዔኪ ማዓኒ ሃኬ ዓጪ ዴንዴ ፔቴ'' ዼኤፒ ዓሲስኬይ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ዒዚ ዴንዳንዳሢኮ ቤርታ ዒዛኮ ማዻ ዓሶይዳፓ ታጶ ዓሲ ዔኤሊ'' ፔቴ'' ፔቴ''ሢም ታጶ ታጶ ሹቺ ቢራ ዒንጋዖ ‹ታ ማዒ ሙካንዳኣና ሃያ ቢሮ''ና ኮርሙዋቴ› ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ዒዛኮ ዓጮ'' ዓሳ ጋዓንቴ ዬያ ዓሢ ዒፃያታሢሮ፦ ‹ዬይ ዓሢ ኑ ዑፃ ካኣታዻንዳጉዲ ኑ ኮዑዋሴ› ጌዒ ዒዚ ዴንዴሢኮ ጊንፃ ኪኢታ ዓሲ ጊንፆ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«ዬይ ዓሢ ካኣቲ ማዒ ሙኬ ዎዶ''ና ዔያቶም ዒንጊንቴ ሚኢሾና ዎዚጉዲ ኮርሚ ጊዳ'' ጌልዜቶዋ ዔራኒ ፔኤኮ ማዻ ዓሶንሢ ዔኤሊ''ሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ቤርታ ሙኬ ማዻ ዓሢ ሙካዖ፦ ‹ጎዳሢዮ! ኔ ታኣም ዒንጌ ሚኢሾ ኮርሚ፥ ሃይሾ ታ ታጶ ሹቺ ቢራ ጊዳ'' ጌልዜኔ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ዒዛኮ ጎዳሢያ ‹ኔኤኒ ጉሙርቂንታ፥ ማዻሢዮ! ቃራ ኔ ማዼኔ! ዻካ'' ባኣዚ''ና ኔ ጉሙርቂንቴሢሮ ታ ሃሢ ኔና ታጶ ካታማ ኔ ዎይሣንዳጉዲ ቢታንቶ ዒንጌኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ላምዓሳሢ ሙካዖ ‹ጎዳሢዮ! ኔ ታኣም ዒንጌ ሚኢሾና ታ ኮርሚ ዶንጎ ሹቺ ቢራ ጊዳ'' ጌልዜኔ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ጎዳሢያ ዬያም ‹ኔኤማኣ ሃሣ ታኣኒ ዶንጎ ካታማ ኔ ዎይሣንዳጉዲ ቢታንቶ ዒንጌኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«ዓቴ'' ማዻ ዓሢ ሙካዖ ‹ታ ጎዳሢዮ! ኔ ታኣም ዒንጌ ሚኢሾ ሃኣዛጌ፤ ቱርጫና ታ ቱኪ'' ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ዓይጎሮ ጌዔቶ ኔኤኒ ጌሢ ባኣያና ኔኤሮ ማዒባኣያታንቴ ዔካያ፥ ኔ ጎሽኪባኣዖ ሃኣኮ ቡኩሳያ፥ ሚርጌ ፑርታ ዓሲ ኔ ማዔሢ ዔሪ ታ ኔና ዒጊጬሢሮኬ› ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ጎዳሢ ማሃዖ ‹ሃይ ኔ ፓሡዋኣሢ ሃይ! ኔ ጌዔ ባኮና ታ ኔ ዑፃ ዎጋኔ፤ ታኣኒ ታኣም ማዒባኣሢ ዔካያና ጎሽኪባኣዖ ቡኩሳያ ሃሣ ፑርታ ዓሲታሢ ታ ኔና ዔራኔ ኔ ጌዒባይ? ");
INSERT INTO mdybse_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ያዺ ማዔቴ ሚኢሾ ታኣኮ ጊዳ'' ቃሲ''ንታንዳጉዲ ኮርሚንታ ቤስካ ኔ ዓይጎሮ ጊሽኪባኣይ? ታኣኒ ማዒ ሙካዖ ጊዳ'' ቃሲ''ንቴያና ዎላ'' ዔካንዳያታንቴኬ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«ዬካፓ ዒዛኮ ጎዳሢ ዒኢካ ዔቂ ዓኣዞንሢ ኮራ ‹ሃያ ዓሢኮ ሚኢሾ ዔኪጋፓ ታጶ ጊዳ'' ቃሴ''፥ ማዻ ዓሢም ዒንጉዋቴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ዔያታ ማሃዖ ‹ጎዳሢዮ! ዒዛኮ ዒ ጊዳ'' ጌልዜ ታጶ ሹቺ ቢራ ዓኣንቴሞ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ጎዳሢ ጋዓንቴ ‹ዓኣሢም ቢያ ዑሣ ዓኣሢ ዒንጊንታኔ፤ ባኣሢዳፓ ጋዓንቴ ዬማ ዓኣማታዖ ዔዔኪንታኔ ታ ዒንሢም ጋዓኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ታ ካኣታዻንዳጉዲ ኮዒባኣ ዬንሢ ታኣኮ ሞርኮንሢ ጋዓንቴ ሃይካ ዔኪ ሙኪ ታ ቤርታ ዎዹዋቴ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ዬሱሴ ዬያ ኮኦኪንሦ ኬኤዜስካፓ ዬሩሳላሜ ባንሢ ዒዛኮ ጊንፆ ሃንታዞንሢኮ ቤርታ ቤርታ ዴንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ዬሱሴ ዛይቶ ሪሚቶ ዹኮ'' ኮይሎ''ይዳ ዓኣ ቤቴፓጌና ቢታኒያ ጌይንታ ካታሞንሢ ሙካዖ ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ላምዖንሢ ሂዚ ጌዒ ዳኬኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«ሃኖ'' ሴኮ ቤርታ ዓኣ ጉርዴሎ ዴንዱዋቴ፤ ዒኢካ ዒንሢ ሄላ''ዖ ዓይጎ ዓሲያ ቶጊ ቤቂባኣ ሃሬ ናይ ቱኡቲ ዓኣንቴ ዒንሢ ዴንቃንዳኔ፤ ዒማ ቡሊ'' ዔኪ ታኣም ባውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ዖኦኒያ ‹ዓይጎሮ ዒንሢ ቡላ''ይ?› ጌይ ዒንሢ ዖኦጬቶ ‹ጎዳም ኮይሳሢሮኬ› ጌይ ዒዛም ማሁዋቴ።» ");
INSERT INTO mdybse_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ኪኢቶ''ና ዳኪንቴዞንሢያ ዴንዳዖ ቢያ ባካ ዬሱሴ ዔያቶም ጌዔሢጉዲ ማዔንቴ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ዒማ ሃሮ'' ናዖማ ዔያታ ቡላ''ኣና ሃሮ'' ናዖኮ ዓዶንሢ፦ «ዓይጎሮ ዒንሢ ቡላ''ይ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ዔያታ ማሃዖ፦ «ጎዳም ኮይሳሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ሃሮ'' ናዖዋ ዬሱሴ ኮራ ዔኪ ሙካዖ ዔያታ ፔኤኮ ዓፒሎ ሃሮ'' ናዖ ዙላ'' ጌሢ ዬሱሴ ቶጊሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ዬሱሴ ዓኣዻ ጎይሣ ዓኣንቴ ዓሳ ፔኤኮ ዓፒሎ ጎይፃ ዒዛ ቤርታ ሂኢሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ዬሱሴ ዬሩሳላሜ ሄላ''ኒ ዑካዖ ዛይቶ ሪሚቶ ዹኮ''ና ሊካ ኬዳ''ንቴ ዒዛኮ ጊንፆ ሙካ ዓሳ ቢያ ዔያታ ዛጌ፥ ፆኦሲ ዎልቄና ማዺንቴ ዓኮ ባኮ ዛሎ''ና ሚርጌ ዎዛዼሢሮ ዑኡዞ ፔኤኮ ዼ'ጊዲ ፆኦሲ ጋላቲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«ፆኦሲ ሱ'ንሢና ሙካ ካኣቲ ዓንጂንቴያኬ! ኮሹሞ ጫሪንቺዳ፥ ቦንቾ ፆኦሲም ዼ'ጌ ቤዞይዳ ማዖንጎ!» ዔያታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ዴሮ''ኮ ባኣኮ''ይዳ ዓኣ፥ ፔርሴ ዓሳ ጋዓንቴ ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ኔኤኮ ጊንፆ ሃንታ ናኣቶ'' ጎሪ'' ዚቲዴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ዬሱሴ ማሃዖ፦ «ዔያታ ዚቲ ጌዔቴያ ሹጫ ሃይ ዒላታንዳኔ፥ ታ ዒንሢም ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ዬሱሴ ዬሩሳላሜ ካታሞኮ ዑኪ ካታሜሎ ዛጋዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«ኔኤም ኮሹሞ ማዓንዳ ባኮ ሃኖ'' ኔ ዔሬያታቶ ዓይጎ ጎዖንዶይ! ሃሢ ጋዓንቴ ዬይ ባካ ኔ ዓኣፓፓ ዓኣሺንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ኔኤኮ ሞርካ ኔኤኮ ዙላ'' ቲኢሢ ዲርቂ ሃሣ ኔና ማንጊ፥ ሃንጌና ሶንጌና ሜታሳንዳ ዎዴ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ኔናንታ ኔ ጊዳ'' ዓኣ ኔኤኮ ናኣቶ''ንታ ዔያታ ባይዛንዳኔ፤ ዔያታ ዶይሱዋዖ፥ ፔቴ'' ሹቺታዖ ኔኤም ሃሻ''ዓኬ፤ ዓይጎሮ ጌዔቶ ፆኦሲ ኔና ዛጋኒና ዻቂሻኒ ሙካ ዎዶ'' ኔ ዔሪባኣሢሮኬ» ጌዒ ዬኤኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ዬሱሴ ጌኤዦ ማኣሪ ጌሊ ዒኢካ ኮርሞ ኮርማ ዓሶ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","« ‹ማኣራ ታኣኮ ሺኢጲሢ ማኣሪ ማዓንዳኔ› ጌይንቲ ፃኣፒንቴኔ፤ ዒንሢ ጋዓንቴ ዉሲ ፑና ቤሲ ማሄኔ» ጌዒ ዳውሲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ዬካፓ ዬሱሴ ቢያ ኬሊ''ና ጌኤዦ ማኣራ ዔርዜኔ፤ ዬኖ ዎዶ''ና ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ሃሣ ሜሌ'' ዴሮ''ኮዋ ሱኡጎ ማዔዞንሢ ዬሱሴ ዎዻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ጋዓንቴ ዓሳ ቢያ ዬሱሴ ጋዓ ባኮ ዋይዛኒ ሚርጌና ናሽካሢሮ፥ ዔያቶም ዎኦቶንዶ ጎይፃ ባይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ፔቴ'' ኬሊ'' ዬሱሴ ጌኤዦ ማኣራ ጴዺ ዴሮ'' ዔርዚ ዔርዚ ሃሣ ኮዦ ሃይሶዋ ኬኤዛንቴ ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ሃሣ ጪሞና ዒዛ ኮይላ'' ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«ሂንዳ ኑም ኬኤዜ! ሃያ ባኮ ኔ ማዻሢ ዓይጎ ቢታንቶናዳይ? ሃሣ ጊንሣ ሃያ ኔ ማዻንዳጉዲ ቢታንቶ ኔኤም ዒንጌሢ ዖናዳይ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ዬሱሴ ማሃዖ፦ «ታ ዒንሢ ፔቴ'' ባኣዚ'' ዖኦጫንዳኔ፤ ሂንዳ ዒንሢ ታኣም ማሁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ዮሓኒሴኮ ዋኣፆና ማስኪፃ ፆኦሲዳፓሞ ዓሲዳፓዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ዔያታ ዎሊ ኮይላ''፦ « ‹ፆኦሲዳፓኬ› ኑ ጌዔቶ፥ ‹ሂዳዖ ዒንሢ ዓይጎሮ ጉሙርቂ ጎናሲ ዔኪባኣይ?› ዒ ጋዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‹ዓሲዳፓኬ› ኑ ጌዔቶ ሃሣ ዓሳ ኑና ሹቻ ዹዓንዳኔ፤ ዓይጎሮ ጌዔቶ ቢያሢ ዮሓኒሴ ፆኦሲ ማሊሢ ኬኤዛያ ማዔሢ ጉሙርቃሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ዬያሮ፦ «ዓንካፓ ማዔቴያ ኑ ዔሩዋሴ» ጌይ ዒዛም ዔያታ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ዬሱሴያ፦ «ሂዴቶ ታኣኒያ ዓይጎ ቢታንቶና ሃያ ባኮ ማዻቶ ዒንሢም ኬኤዛዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ዬካፓ ዬሱሴ ሃያ ኮኦኮንሦ ዴሮ''ም ኬኤዜኔ፦ «ፔቴ'' ዓሲ ዎይኔ ጌይንታ ባኣዚ'' ቱካ''ዖ ጎሽካ ዓሲም ጎሽኪ ጎሽኪ ካፓንዳጉዲ ዒንጊ፥ ሜሌ'' ሃኬ ዓጪ ዴንዲ ማዑዋዖ ሚርጌ ዎዴ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ዬና ካፃዛ ዎይኔሎኮ ዓዳሢ ዓኣፖይዳፓ ዒዛ ሄላ''ዞንሢ ዔካንዳጉዲ ፔቴ'' ማዻስኬያ ጎዦ ጎሽካዞንሢ ኮይላ'' ዳኬኔ፤ ጎዦ ጎሽካዞንሢ ጋዓንቴ ማዻ ዓሢ ጳርቂ ኩቺ ጉሪ ማሂ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ዬያጉዲ ሜሌ'' ማዻስኬያ ዳካዛ ዬያኣ ሃሣ ዔያታ ጳርቂ፥ ቦርሲሲ ኩቺ ጉሪ ማሂ ዳኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ሃሣ ሃይሣሳ ማዻ ዓሲ ዳካዛ ዬያ ሃሣ ጳርቂ ዑፆ ኪፃሴስካፓ ጎዦኮ ቲኢፆ ዙላ'' ኬኤሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ዬካፓ ዎይኔሎኮ ዓዳሢ ‹ዓካሪ ታ ዎዳ''ንዳይ? ታኣኮ ታ ናሽካ ናዓሢ ዳካንዳኔ! ዒዛ ጎዖንቴ ዔያታ ቦንቻንዳያ ናንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ጋዓንቴ ጎሽካዞንሢ ዒዛኮ ናዓሢ ዛጌ ዎዶ''ና ዎሊ ኮይላ'' ‹ሃይ ዒዛ ዻካላንዳሢኬ፤ ሃኒ ሙኩዋቴ ኑ ዒዛ ዎዾም፤ ቤዛኣ ኑም ማዓንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ዬያሮ ናዓሢ ዔያታ ዎይኖ ቱኮ''ና ቤዞኮ ቲኢፆ ዙላ'' ኬሲ'' ዎዼኔ። «ዓካሪ ያዺ ማዔቶ ዎይኔሎኮ ዓዳሢ ዬንሢ ጎሽካዞንሢ ዎዳ''ንዳያ ዒንሢም ማላይ? ");
INSERT INTO mdybse_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ዬኖ ዎይኔሎኮ ዓዳሢ ፔኤሮ ዬዓንዳኔ፤ ጎሽካዞንሢያ ዎዻንዳኔ፤ ዬኖ ዎይኖ ሜሌ'' ጎሽካ ዓሲም ዒንጋንዳኔ» ጌዔኔ። ዓሳ ዬያ ዋይዛዖ፦ «ዬያጉዴ ባኣዚ'' ማሊ ማዖፓ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ዬሱሴ ጋዓንቴ ዔያቶ ባንሢ ዛጋዖ፦ «ዓካሪ ‹ማኣሮ ማዣ ዓሳ ቦሂ ሃሼ'' ሹጫሢ ማኣሮኮ ሄላ''ሢ ማዔኔ› ጌይንቲ ፃኣፒንቴሢ ዓይጎ ዔርዛይ? ");
INSERT INTO mdybse_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ዬያ ሹጫሢዳ ሎኦማሢ ቢያ ሜቃንዳኔ፤ ሃሣ ዒዚ ዑፃ ኬዳ''ሢያ ቢያ ዳኣፂንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ቄኤሶኮ ሱኡጎና ዬያ ኮኦኪንሦ ዔያቶይዳ ዒ ኬኤዜሢ ዔራዖ ዬማና ዒዛ ዓርቃኒ ማሌኔ፤ ጋዓንቴ ዴሮ'' ዔያታ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ዬያሮ ዬሱሴ ዔያታ ዓርቃኒ ዔያቶም ጊኢጋ ኬሊ'' ካፔኔ። ዓጮ'' ዎይሣሢ ቢታንቶና ዒዛይዳ ዎጋንዳጉዲ ዓኣሢ ዒዛ ዒንጊሳኒ ዳንዳዓ ፑርታ ባኣዚ'' ዒዛይዳፓ ዴንቃኒ ኮዓዖ ፒዜ ዓሲ ማሊ ዒ ጌስታ ጌኤዞና ዒዛ ቡኡዲ ዓራቃንዳ፥ ሙሪ ዓሲ ዒዛ ኮይላ'' ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ዬንሢ ዓሶንሢ ዬሱሴ ኮራ ሙኪ፦ «ዔርዛሢዮ! ኔኤኒ ኬኤዛሢና ዔርዛሢ ጎኑሞ ማዔሢ ኑ ዔራኔ፤ ፆኦሲ ጎይሢ ጎኔና ኔ ዔርዛፓዓቴም ዖኦማኣ ኔ ሉኡዙሞና ዱማሲ ማኣዲ'' ጌስቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ሂንዳ ኑም ኬኤዜ! ኑኡኮ ዎጎ ጎይፆና ሮሜ ዓጮ'' ካኣቲም ጊኢራ ጪጋኒ ዓይሢንቴሞ ዓይሢንቲባኣይ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ዬሱሴ ጋዓንቴ ዔያቶኮ ጌኖ ማሊፆ ዔራዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«ሂንዳ ታና ሚኢሾ ዻውዋቴ፤ ሃኖ' ሚኢሾይዳ ዓኣ ዓውካሮና ፃኣፒንቴ ሱ'ንፆና ዖኦሮዳይ?» ጋዓዛ፥ ዔያታ፦ «ሮሜ ካኣቲሲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ዬሱሴ ማሃዖ፦ «ያዺ ማዔቶ ካኣቲሲ ካኣቲም፥ ፆኦሲሲ ፆኦሲም ዒንጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ዔያታ ዴሮ'' ቤርቶይዳ ጌኤዞና ዒዛ ፒሪ ዓርቃኒ ዳንዳዒባኣሴ፤ ዬያሮ ዒ ማሄ ማሂፆና ዲቃቲ ሄርሻዖ ዚቲዮ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","«ሃይቄ ዓሲ ዔቂንዱዋሴ» ጋዓ ሳዶቄ ዓሳ ዬሱሴ ኮራ ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«ዔርዛሢዮ! ሙሴ ‹ፔቴ'' ዓሲ ናይ ሾውዋዖ ማቾይዳፓ ሃይቢና ዱማዼቶ ጌኤዛሢ ላኣሌሎ ዔኪ፥ ናይ ሾይ ሃይቄሢም ዜርሢ ጌሦንጎ› ጌዒ ፃኣፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ዓካሪ ላንካይ ዎሊኮ ጌርሲንሢ ማዓይ ዓኣንቴ፥ ቢያሢኮ ቶይዳሢ ላኣሊ ዔኪ ናይ ሾውዋዖ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ዒዛ ሄሊ''ሴ ጌኤዛሢ ዬኖ ላኣሌሎ ዔኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ሃሣ ሃይሣሳሢያ ዔኬኔ፤ ዬያይዴ ጎይሣ ላንኮንሢ ቢያ ዒዞ ዔካዖ ናይ ሾውዋዖ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ቢያሢኮ ጊንፃ ዬና ላኣሌላ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ዓካሪ ላንካዎንሢ ቢያ ፔ ዎዶ''ና ዎዶ''ና ቢያ ዒዞ ዔኬያታሢሮ፥ ሃይቄ ዓሳ ዔቃ ዎዶ''ና ዎያኮ ዒዛ ማቾ ማዓንዳይ?» ጌዒ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ዬሱሴ፦ «ሃያ ዓጮ ዓሳ ዔካኔ፥ ሎዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ሃይቢዳፓ ዔቂ፥ ሙካ ዓጮ''ይዳ ናንጋኒ ኮይሳ ዓሳ ጋዓንቴ ዔኩዋሴ፥ ሎዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ዓይጎሮ ጌዔቶ ፆኦሲ ኪኢታንቾጉዲ ማዓንዳሢሮ ሃይቁዋሴ፤ ሃይቢዳፓ ዔያታ ዔቄሢሮ ፆኦሲ ናይኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ሃይቦ''ይዳፓ ዔቃንዳ ዓሶ ዛሎ'' ጋዓንቴ ሙሴ ካዮ ባኣኮ''ይዳ ዔኤቴ ታሞ ዛሎ'' ኬኤዜ ሃይሶይዳ ፔጋሲ ዬያ ኬኤዜኔ፤ ዬኖ ሃይሶይዳ ሙሴ ፆኦሲ፦ ‹ዓብራሃሜ ፆኦሲ፥ ዪሳኣቄ ፆኦሲ፥ ያይቆኦቤ ፆኦሲኬ› ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ፆኦሲ ሼምፖና ናንጊና ናንጋ ዓሶ ፆኦሲ፥ ሓይቄቶዋ ናንጊና ናንጋ ዓሶ ፆኦሲኬ፤ ዬያሮ ቢያሢ ዒዛም ሼምፔና ናንጋኔ» ጌዒ ዔያቶም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢዳፓ ፔቴ'' ፔቴ''ዞንሢ፦ «ዔርዛሢዮ! ኮሺ ባኣዚ'' ኔ ኬኤዜኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ዬካፓ ማይ ዬሱሴ ጫርቂ ዖኦጬ ዓሲያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ዬካፓ ዬሱሴ፦ «ዎይቲ ሜሲሔ ዳውቴ ናይኬ ዔያታ ጋዓይ? ");
INSERT INTO mdybse_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","ዳውቴ ፔ ቶኦኪና ዓይኑሞ ማፃኣፖይዳ፦ ‹ፆኦሲ ታ ጎዳሢም (ሜሲሔም) ኔኤኮ ሞርኮ ኔ ቢታንቶ ዴማ'' ታ ማሃንዳያ ሄላ''ንዳኣና ታኣኮ ሚዛቆ ዛላ'' ዴዔ ዒዛም ጌዔኔ› ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«ዓካሪ ዳውቴ ፔ ቶኦኪና ጎዳ ጌዒ ዒዛ ዔኤሌ''ቶ ሜሲሔ ዳውቴኮ ዎይቲ ናይ ማዓኒ ዳንዳዓይ?» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ዴራ'' ቢያ ዒዛሲ ዋይዛ ጎይሣ ዓኣንቴ ዬሱሴ ጊንፆ ሃንታዞንሢ ኮራ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ዖዶሲ ማኣዖ ማኣዒ ሴካ ሃንጋ ጌዒ ሃንታኒ፥ ቦኦካ ቤሲዳ ቦንቾ ዔኤሊ''ሢ ዔኤሊ''ንታኒ፥ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ቦንቺንታ ዖይታ፤ ሙኡዚ'' ሙዖ ቤስካ ቦንቺንታ ቤሲዳ ዴዓኒ ኮዓ ሙሴ ዔርዜ ዎጎ ዔርዛዞንሢዳፓ ዒንሢና ካፑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ዔያታ ዓሲ ቤርቲዳ ጴዻኒ ዖዶሲ ሺኢቆ ሺኢጲሢና ጌሺ ጌሺ ዓኒንሢ ሃይቄ ላኣሎኮ ማኣሮ ማንቂሳኔ፤ ዬያሮ ዔያቶይዳ ዑሣ ዓኣዼ ፑርታ ዎጌ ዎጊንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ዬሱሴ ዼ'ግ ጌዒ ዛጋንቴ ዖርጎጮ ዓሳ ፆኦሲም ዒንጎ ባኮ፥ ሳኣፂኖ ጋራ ዓጋንቴ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ዬያጉዲ ሓሣ ፔቴ'' ዜኤሪንዶስኬና ዬኖ ዎዶ'' ሚኢሾና ላምዖ ሲኪና ማዓያ ሳኣፂኖ ጋራ ዓጋንቴ ዒ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ዒማ''ና ዬሱሴ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃና፥ ዜኤሮይንዶ ማንቄላ ቢያፓ ዑሣ ዓኣዼ ባሼ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ዓይጎሮ ጌዔቶ ዔያታ ዒንጌሢ ዔያቶኮ ዓኣ ባካፓ ዺቢ ዑሣ ዓኣዼሢኬ፤ ዒዛ ጋዓንቴ ማንቆታዖ ፔቴ''ታዖ ዒዞም ዓይሱዋዖ ዒዞኮ ዓኣ ባኮማ ጋፒ ዒንጌኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ፔቴ'' ፔቴ'' ዓሳ፦ «ሃይ ጌኤዦ ማኣራ ሚዛጲ ሹቺና ሃሣ ፆኦሲም ዒንጊንቴ ዒንጊፆና ሚዛጲሲ ኮሾ''ናያኬ» ጌዒ ጌዒ ዎላ'' ጌስታንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ዬሱሴ፦ «ሃይ ዒንሢ ዛጋሢ ቢያ፥ ሹጫ ሹጮይዳ ኬልቂንቲ ዓቲንዱዋ ዎዴ ሙካንዳኔ፤ ሃይ ሹጫ ቢያ ፔቴ'' ዓቢና ዶዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ዔያታኣ፦ «ዔርዛሢዮ! ዬይ ማዓንዳሢ ዓይዲዳይ? ዬይ ያዺ ማዓንዳ ዎዳ'' ዑኬሢ ኑ ዔራንዳ ማላታ'' ዓይጌንዴዳይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ዬሱሴ፦ «ዒንሢ ዻቢንቱዋጉዲ ዒንሢና ዔሩዋቴ፤ ሚርጌሢ ‹ታኣኒ ኪሪስቶሴኬ! ሃይሾ ዎዳ'' ዑኬኔ!› ጌዒ ጌዒ ታ ሱንፆና ሙካንዳኔ፤ ዔያቶ ጊንፆ ዓኣዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ዖልዚና ዴሬኮ ዋይዚ ዒፂሢና ዛላ ዒንሢ ዋይዜ ዎዶ''ና ዲቃቲፖቴ፤ ቤርታዺ ዬይ ቢያ ያዺ ማዓንዳያ ኮይሳኔ፤ ማዔቶዋ ጋፒንፃ ዑኬ ማዓዓኬ» ጌዒ ዔያቶም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ዬካፓ ሃሣ ዬሱሴ፦ «ዴራ'' ዴሮ''፥ ካኣታ'' ካኣቶ'' ዖላንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ዱማ ዱማ ቤሲዳ ዶዲ፥ ዒጊቻ ሳዓ ዓጊፂሢና ሉማና ሃሣ ዶርዓኣ ኬስካንዳኔ። ሃሣ ዒጊቻ ባኣዚ''ና ዼኤፒ ዼኤፒ ማላታ ጫሪንጮይዳ ጴዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ጋዓንቴ ዬይ ቢያ ማዓንዳሢኮ ቤርታ ዓሳ ዒንሢ ዓርቃንዳኔ፤ ዒፂ ሃሣ ዒንሢ ዳውሶንዶኔ፤ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞና ቱኡዞ ማኣሮናም ዓኣሢ ዒንሢ ዒንጎንዶኔ፤ ታ ሱንፆሮ ጌዒ ካኣቶ'' ቤርቶ ሃሣ ዎይሣ ዓሶ ቤርቶ ዔኪ ዒንሢ ዓኣዾንዶኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ዬይያ ታ ሱንፆ ዛሎ'' ዒንሢ ማርካታኒ ዒንሢም ኮሺ ዎዴ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ዬያሮ ዒንሢ ፑርቲሴ ዓሲጉዲ ዖኦጪንታ ባኮኮ ዒንሢ ማሃንዳ ባኮሮ ሜታዻንዳያ ኮይሱዋኣሢ ቤርታዺ ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ዓይጎሮ ጌዔቶ ዒንሢኮ ሞርኮይዳፓ ዖኦኒያ ዒንሢ ባሻኒና ማካኒ ዳንዳዑዋ ጌስቶንዶ ጌኤሲና ዔራቶና ታ ዒንሢም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ዒንሢኮ ሾዔ ዓሶና ጌርሲንሢና ዒንሢኮ ዒጊኖና ላጎና ዓቱዋዖ ዓኣሢ ዒንሢ ዬያ ባኮም ዒንጋንዳኔ፤ ዒንሢዳፓ ፔቴ'' ፔቴ''ሢ ሃይቂያ ሃይቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ታ ሱንፆሮ ጌዒ ዓሲ ቢያና ዒፂንቴያ ዒንሢ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ጋዓንቴ ዒንሢኮ ቶኦኮ'' ጋፓናፓ ፔቴ''ታዖ ባይቃዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ዒንሢ ጊቢ'' ዳንዳዒ ሼምፓሢ ዒንሢኮ ዒንሢ ዓውሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ዬካፓ ሃሣ ዬሱሴ፦ «ዒዞ ሞርኮኮ ዖላ ዓሶና ዬሩሳላሜ ማንጊንቲ ዓኣንቴ ዒንሢ ዛጌ ዎዶ''ና ባይቃኒ ዒዛ ዑኬሢ ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ዒማ''ና ዪሁዳ ዓጮ''ይዳ ዓኣዞንሢ ሌካ ዹኮ'' ባንሢ ዓኣሺንቶንጎ፤ ካታማ ዓኣዞንሢ ዬካፓ ኬስኮንጎ፤ ካታሞኮ ዙላ'' ዓኣዞንሢያ ሃንጋ ካታሞ ጌሎፓ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ዓይጎሮ ጌዔቶ ዬኖ ባይሲንቴሎ ዛሎ'' ፃኣፒንቴ ሎንሣ ኩማንዳጉዲ፥ ዬና ኮሜ ዔኪሢና ሜቶ ዒንጊሢ ዎዴ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ዬኖ ዎዶ''ና ጎጶይንዶና ናኣቶ'' ዓኣሎ ዻንሢሣዞንሢም ባዴዔ! ዓይጎሮ ጌዔቶ ዬኖ ዓጬ''ሎይዳ ዼኤፒ ሜቶ ዎዴ ማዓንዳኔ፥ ዴሮ'' ዑፆይዳኣ ፆኦሲ ጎሪ''ንቲ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ዔያቶይዳፓ ሚርጌሢ ዖልዚና ሃይቃንዳኔ፤ ዓቴ'' ዓሳ ዲዒንቲ ዱማ ዱማ ዓጪ ዔኪ ዓኣዺንታንዳኔ፤ ሜሌ'' ዴራ ዑፃ ማዒ ዎይሣ ዎዳ'' ጋፓንዳያ ሄላ''ንዳኣና ዬሩሳላሜ ካታሞ ዔያታ ሄ'ርቂ ዎይሣያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ሄሊ''ሳዖ ዬሱሴ፦ «ዓቦ''ና ዓጊኖናይዳ ሃሣ ዦኦጋሢዳ ዲቃሣ ማላታ ጴዻንዳኔ፤ ሳዖይዳ ዓኣ ዴራ'' ቢያ ባዞ''ና ባዞ''ይዳ ዔቃ ዲቃሣ ጉዳሢ ዢባሮ ዑኡዞፓ ዔቄያና ዒጊጪ ሜታዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሳዖይዳ ሙካ ባኮ ካፒሢና ዓሳ ዒጊቹሞና ሂርጊ ሜታዻንዳኔ፤ ዓይጎሮ ጌዔቶ ዬኖ ዎዶ''ና ጫሪንጫ ዎልቄና ዓኣ ባካ ዓጊፃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ዬካፓ ዓሲኮ ናዓሢ ዼኤፒ ዎልቄና ሃሣ ቦንቺንቲ ሻኣሮ ዑፃ ማዒ ሙኪ ጴዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ዬይ ቢያ ማዒፆ ዓርቄ ዎዶ''ና ዒንሢኮ ዻቂንታ ዑኬሢሮ ዼ'ግ ጌዒ ሌካ ዛጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ዬካፓ ዬሱሴ ሂዚ ጌዒ ኮኦኪንሢ ዔያቶም ኬኤዜኔ፦ «ቤሌሶ ሚፆንታ ሃንጎ ሚፆዋ ኮሺ'' ዒና ዔኪ ዛጉዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ዔያቶኮ ዒላዣ ፂላንቴ ዒንሢ ዛጌ ዎዶ''ና ዖጎሢ ዑኬሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ዬያ ጎይፆ ዬይ ቢያ ባካ ማዒፆ ዓርቃሢ ዒንሢ ዛጌ ዎዶ''ና ፆኦሲ ካኣቱማ ሙካኒ ዑኬሢ ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«ጎኔ ታ ዒንሢም ጋዓኔ፤ ዬይ ቢያ ኩማንዳያ ሄላ''ንዳኣና ሃይ ሾይንታ ዓኣዻዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ጫሪንጮና ሳዖና ዓኣዻንዳኔ፤ ታኣኮ ቃኣላ'' ጋዓንቴ ናንጊና ዶዲ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ሄሊ''ሳዖ ዬሱሴ፦ «ሚርጌ ሙኡዚ''ና ዑሺና ዛላ ማሊ ማሊ ዎዶ'' ዒንሢኮ ጉሪ ኩርሲፖቴ፤ ሓሣ ሃያ ሳዖ ናንጎ ባኮ ዛሎ'' ሜታዺሢና ዒኖ ዒንሢኮ ዶጪሲፖቴ፤ ያዺ ዒንሢ ማዔቴ ዬና ኬሌ''ላ ፒሮጉዲ ዔሩዋንቴ ዒንሢ ዓርቃንዳሢ ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ዬና ኬላ'' ሳዖይዳ ዓኣ ዓሶ ቢያ ዔሩዋንቴ ዓርቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ዬያሮ ሙካ ፑርቶ ባኮ''ይዳፓ ቢያ ቶላ''ኒ፥ ዎልቄያ ዴንቃኒና ዓሲ ናዓሢኮ ቤርታ ዒንሢ ዔቃኒ ዳንዳዓንዳጉዲ ሺኢቂ ሺኢቂ ቢያ ዎዴና ዶዱዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ዒማ''ና ዬሱሴ ቢያ ኬሊ'' ጌኤዦ ማኣሮይዳ ዔርዛኔ፤ ሳዓ ዓማኣና ጋዓንቴ ዛይቴ ሪሚቲ ዹካ ጌይንታ ዹኮ'' ኬስኪ ኬስኪ ዎርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ዓሳ ቢያ ዬሱሴ ኮራፓ ዋይዛኒ ጉቴ'' ዓማ'' ጌኤዦ ማኣሪ ዒዛ ባንሢ ዓኣዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ጌይንታ ላኣዶ ሙዒ ቦንቾ ኬላ'' ዑካዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ዴሮ'' ዒጊጬሢሮ ዬሱሴ ዓርቂ ዎዾንዶ ጎይሢ ዴሜና ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ዬማና ታጶ ላምዖንሢዳፓ ፔቴ''ሢ ማዔ፥ ዓስቆሮንቶ ዓጮ'' ዓሢ፥ ዪሁዳይዳ ፃላሄ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ዬያሮ ዪሁዳ ቄኤሶኮ ሱኡጎና ጌኤዦ ማኣሮ ካፓ ዓሶ ዓይሣዞንሢ ኮይላ'' ዴንዲ ዬሱሴ ዎዲ'' ዓኣሢ ዔያቶም ዒንጋንዳቴ ዔያቶና ዎላ'' ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ዔያታ ዒ ኬኤዜ ባኮና ዎዛዺ ሚኢሼ ዒዛም ዒንጋኒ ዎላ'' ጌስቲ ጊኢጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ዔያታ ጌስቲ ጊኢጌስካፓ፥ ዴራ'' ዔሩዋንቴ ዒዚ ዬሱሴ ዓኣሢ ዒንጋኒ ጊኢጋ ዎዴ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ዬካፓ ዑሣ ዓኣዺፆ ቦንቾሮ ማራቶ ሹኪ፥ ላኣዶዋ ሙዒ ቦንቾ ኬላ'' ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ዬሱሴ፦ «ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዋሢ ኑ ሙዓንዳጉዲ ዴንዲ ኑም ጊኢጊሹዋቴ» ጌዒ ጴፂሮሴና ዮሓኒሴና ቤርታ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ዔያታ ማሃዖ፦ «ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዎ ዎካ ኑ ጊኢጊሻንዳጉዲ ኔ ኮዓይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ዒዚያ ዔያቶም፦ «ዴንዲ ካታሞ ዒንሢ ጌላኣና ዒኢካ ዋኣሢ ጉሲ ኬዴ ዓሲ ዒንሢና ካኣማንዳኔ፤ ዒዛ ጊንፆ ዓኣዺ፥ ዒ ጌላ ማኣሮ ጌሉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ማኣሮ ዓዶ ኮራ ኑና ዔርዛሢ ‹ታኣኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዎ ታ ዴዒ ሙዓንዳ ቤዛ ዎካዳይ? ኔና ጋዓኔ› ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ዒዚያ ኩቦ ጋራ ዓኣ ሂኢሢንቲ ጊኢጌ፥ ዳልጎ ቤዞ ዒንሢ ዻውዋንዳኔ፤ ዒኢካ ጊኢጊሹዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ላምዖ ዒዛኮ ጊንፆ ሃንታዞንሢ ዴንዲ ቢያ ባካ ዬሱሴ ዔያቶም ጌዔሢጉዲ ማዔም ዴንቃዖ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዎ ዒኢካ ጊኢጊሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ዒማ''ና ካዎ ሙዖ ዎዳ'' ሄላ''ዛ ዬሱሴ ዳኪንቴዞንሢና ዎላ'' ሙዓኒ ዴዓዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","«ታኣኒ ሜታሢ ዔካንዳሢኮ ቤርታ ዒንሢና ዎላ'' ሃያ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዋሢ ሙዓኒ ሚርጌና ኮዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ሃያ ባኮኮ ዓኣሺንቴ ጎኑማ ፆኦሲ ካኣቱሞይዳ ጌኤሽኪ ዔርታንዳያ ሄላ''ንዳኣና ሃይካፓ ሴካ ሃኖ' ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ካዎ ፔቴ''ታዖ ታ ሙዒንዱዋያታሢ ዒንሢም ታ ኬኤዛኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ዬካፓ ዬሱሴ ዑሽኮ ባኮ ዔኪ ጋላታ ሺኢጲሢ ሺኢቃዖ፦ «ሃቦቴ፥ ሃያ ዎሊ ሄሊ''ሱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃይማፓ ዓርቃዖ ፆኦሲ ካኣቱማ ሙካንዳያ ሄላ''ንዳኣና ሃያ ዎይኖ ዓኣፖ ዑዣፓ ታ ዑሽካዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ሄሊ''ሳዖ ዬሱሴ ካሦ ዔኪ ጋላታ ሺኢጲሢ ሺኢቂ፥ ቡንፃዖ ጊንፆ ሃንታዞንሢም፦ «ሃቦቴ፥ ሃይ ዒንሢም ዒንጊንታሢ ታናኬ፤ ሃያ ዒንሢ ታና ማሊ ጶቂሣ ባኣዚ'' ማሁዋቴ» ጌዒ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ዬያጉዲ ካሦ ሙዔስካፓ ዑሽኮ ባኮ ዔኪ ዒንጋዖ፦ «ሃይ ዑሽኮ ባካ ዒንሢም ላኣሊንታንዳ፥ ታ ሱጎፆና ኩማንዳ ዓኮ ጫኣቃሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«ጋዓንቴ ታና ዓኣሢ ዒንጋሢ ሃሢ ታኣና ዎላ'' ጎንጋፓ ካሦ ዔኪ ሙዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ዓሲኮ ናዓሢ ዒዛ ዛሎ'' ቤርታዺ ማሊንቴ ጎይፆና ሃይቁዋዖ ዓታዓኬ፤ ጋዓንቴ ዓሲኮ ናዓሢ ዓኣሢ ዒንጋ ዬያ ዓሢም ባዴዔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ዒዛኮ ጊንፆ ሃንታ ናኣታ''፦ «ኑ ባኣካ''ፓ ዬያ ማዻንዳሢ ዖናዳይ?» ጌይሢና ዎሊ ሴካና ሃንጋና ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ሄሊ''ሳዖ ዔያታ፦ «ኑጊዳፓ ቢያ ባሼሢ ዖናዳይ?» ጌዒ ዎላ'' ማርሞ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ዬሱሴ ጋዓንቴ፦ «ሃያ ዓጮ'' ካኣቶ''ኮ ዴሮ'' ዑፃ ቢታንቶ ዓኣኔ፤ ሃሣ ዎይሣ ዓሳኣ ዴሮ''ም ኮዦ ማዻ ዓሶ ጌይንታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ዒንሢ ጋዓንቴ ዔያቶጉዲ ማዓንዳያ ኮይሱዋሴ፤ ዬያይዳፓ ዒንሢ ባኣካ'' ቶይዲ ማዓሢ ጌኤዚ''ጉዲ ማዖንጎ፤ ዓይሢ ማዺሻያ ማዔሢያ ማዻሢጉዲ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ሙዖ ዴዒ ሙዓሢና ዔቂ ሙኡዛሢናይዳፓ ዎያዳይ ዼኤፓሢ? ዼኤፒ ጌይንታሢ ዴይ ሙዓሢቱዋዓዳ? ታኣኒ ጋዓንቴ ዒንሢኮ ባኣካ'' ዓይሢንቲ ማዻሢ ጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«ዒንሢ ታኣኮ ሜታሢ ዎዶ''ና ቢያ ታኣና ዎላ'' ዶዲ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ዬያሮ ታ ዓዴ ታ ማዾ''ም ቢታንቶ ታኣም ዒንጌሢጉዲ ታኣኒያ ዒንሢም ቢታንቶ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ታኣና ዎላ'' ታ ካኣቱሞይዳ ሙዖ ቤዛ ዒንሢ ዴዒ ሙይ ዑሽካንዳኔ፤ ዎጎ ዎጎ ቤዞይዳኣ ዴዒ፥ ታጶ ላምዖ ዒስራዔኤሌኮ ፃጶ ዑፃ ቢታንቶ ዔኪ ዒንሢ ዎጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ሄሊ''ሳዖ ዬሱሴ፦ «ሲሞኦኔ! ሃኣዛጌ፤ ጎሽካ ዓሢ ዛርጋሢ ዓኣፖ ዲልባፓ ሶኦሪ፥ ጌኤሺ ዱማሳሢጉዲ ፃላሄ ዒንሢ ሶኦሪ ዛጋኒ ዒናፓ ሱኡካዺ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ጋዓንቴ ኔኤኮ ጉሙርቂፃ ባይቁዋጉዲ ታ ዓዶ ታ ሺኢቄኔ፤ ኔኤኒያ ኔ ዻቢንቶ ዔሪ ታ ባንሢ ማዔ ዎዶ''ና ኔ ዒሾንሢ ዶዲሼ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ጴፂሮሴ ማሃዖ፦ «ጎዳሢዮ! ቱኡሲም ማዔቶዋ ሃሣ ሃይቢም ታኣኒ ኔኤና ዎላ'' ዓኣዻኒ ጊኢጊንቴያኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ዬሱሴ ጋዓንቴ ዒዛም፦ «ጴፂሮሴ፥ ሃኖ'' ኮይዳ ቂኢቁዋንቴ ሃይሢ ማይንቲ ‹ታ ዒዛ ዔሩዋሴ› ኔ ጋዓንዳኔ፤ ታ ኔኤም ጋዓኣኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ዬካፓ ዬሱሴ ፔኤኮ ጊንፆ ሃንታ ናኣቶ'' ኮራ፦ «ሚኢሼ ዓርቆ ቡራሻ፥ ጋላ ዔኮ ሉካ''፥ ዱርሲያ ዒንሢ ዔኩዋንቴ ታ ዒንሢ ዳኬ ዎዶ''ና ዒንሢም ፓጬ ባኣዚ'' ዓኣ?» ጌዔኔ። ዔያታኣ ማሃዖ፦ «ዓይጌያ ፓጬ ባኣዚ'' ኑም ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ዬሱሴ ዔያቶም፦ «ሃሢ ዓካሪ ሚኢሼ ዓርቆ ቡራሻ ማዔቴያ፥ ጋላ ዓርቆ ሉካ'' ዓኣሢ ዬያ ፔኤኮ ዔኮንጎ፤ ጬንቻ ዓፓሮ ባኣሢያ ማኣዓሢ ፔኤኮ ሻንቺ ጬንቻ ዓፓሮ ሻንቆንጎ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","‹ፑርቶ ዓሶና ዎላ'' ፓይዲንቴኔ!› ጋዓ ማፃኣፖ ቃኣላ'' ታ ጊዳ'' ኩማንዳያ ኮይሳኔ፤ ታ ዒንሢም ጋዓኣኬ፤ ዓይጎሮ ጌዔቶ ታ ዛሎ'' ቤርታዺ ፃኣፒንቴሢ ቢያ ኩማኒ ኮይሳሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ዒዛኮ ጊንፆ ሃንታ ናኣታ''፦ «ጎዳሢዮ! ሃይሾ ሃይካ ላምዖ ጬንቻ ዓፓሮ ዓኣኔ!» ዒዛም ጋዓዛ፥ ዒዚ «ጊዳንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ዬሱሴ ካታሞይዳፓ ኬስኪ ቤርታ ማዻሢጉዲ ዛይቶ ሪሚቶ ዹኮ'' ዴንዴኔ፤ ዒዛኮ ጊንፆ ሃንታ ናኣታ''ኣ ዒዛና ዎላ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ዒኢካ ዔያታ ሄላ''ዛ ዬሱሴ፦ «ዻቢሻ ጌሺሢዳ ዒንሢ ጌሉዋጉዲ ሺኢቁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ዬካፓ ሹቺ ዹዔም ሄላ''ንዳጉዴ ቤሲዳ ዔያቶይዳፓ ሃኪ ዴንዳዖ ጉምዓቲ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«ዓዳሢዮ! ኔ ማሊሢ ማዔቶ ሃያ ሜታሢ ታ ጊዳ''ፓ ሃኪሴ፤ ጋዓንቴ ታ ማሊፆጉዲቱዋንቴ ኔ ማሊፃ ኩሞንጎ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ዒማ''ና ዒዛ ዶዲሻ ኪኢታንቻሢ ጫሪንጮይዳፓ ሙኪ ዒዛም ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ዒና'' ዒዛኮ ሚርጌና ሜታዼም፥ ኮሺ'' ዶዲ ሺኢጲሢ ዒ ሺኢቃኔ፤ ዬማና ጮጋጫ ዒዛኮ ሱጉሢ ማሊ ሳዓ ፆዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ሺኢጲፆይዳፓ ዒ ዔቂ ጊንፆ ሃንታዞንሢ ባንሢ ሙካንቴ ዔያታ ሚርጌና ዖዪፆይዳፓ ዔቄያና ላቢ'' ጊንዒ ዓኣንቴ ዛጋዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«ዓይጎሮ ዒንሢ ጊንዓይ? ዬያይዳፓ ዻቢሻ ጌሺሢዳ ዒንሢ ጌሉዋጉዲ ዔቂ ሺሺኢቁዋቴ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ዬሱሴ ዬያ ኬኤዛ ጎይሣ ዓኣንቴ ዒማ''ና ሚርጌ ዓሲ ሙኬኔ፤ ዬያ ዓሶ ዔኪ ሙኬሢ ታጶ ላምዖንሢዳፓ ፔቴ''ሢ ማዔ፥ ዪሁዳኬ፤ ዒዚያ ዬሱሴ ሄርቃኒ ዬሱሴ ባንሢ ዶጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ዬሱሴ ጋዓንቴ፦ «ዔዞ፥ ዪሁዳ! ዓሲኮ ናዓሢ ሄርቂሢና ዓኣሢ ኔ ዒንጋ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ዬሱሴና ዎላ'' ዓኣ ጊንፆ ሃንታዞንሢ ዬያ ዛጋዖ፦ «ጎዳ! ዓፓሮና ኑ ዔያቶ ቆፆ''ንዶ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ዔያቶይዳፓ ፔቴ''ስኬይ ቄኤሶ ቢያኮ ሱኡጋሢም ዓይሢንቲ ማዻሢኮ ሚዛቆ ዋዮ ዓፓሮና ቆፂ'' ቲቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ዬሱሴ ጋዓንቴ፦ «ማይ ጊዴኔ! ሃሼ''!» ጋዓዖ፥ ዓሢኮ ዋዮ ኩቻ ዓርቂ ካንሢ ፓሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ዬካፓ ዬሱሴ ዒዛ ዓርቃኒ ሙኬዞንሢና ቄኤሶኮ ሱኡጎና ሓሣ ጌኤዦ ማኣሮኮ ዓይሣዞንሢና ዴሮ''ኮ ጪሞና ኮራ፦ «ታና ዒንሢ ሱላጉዲ ዓርቃኒ ጬንቻ ዓፓሮና ኮኦሎ''ና ዔኪ ሙኪያ? ");
INSERT INTO mdybse_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ቢያ ኬሊ'' ጌኤዦ ማኣሮይዳ ዒንሢና ዎላ'' ታ ዓኣንቴ ዒንሢ ታና ዓርቂባኣሴ፤ ሃሢ ጋዓንቴ ዒንሢና ዹማሢናኮ ቢታንቶ ዎዶ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ዬካፓ ዓሳ ዬሱሴ ዔኪ ቄኤሶ ቢያኮ ሱኡጋሢ ማኣሪ ዴንዴኔ፤ ዒማ''ና ጴፂሮሴ ዻካ'' ዒዛይዳፓ ሃኬ ሃኬ ጊንፆ ዓኣዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ዓሳ ዬያ ዓሢኮ ዲሮ ጋራ ታሚ ዔኤሢ ፔቴ''ይዳ ዴዒ ካሽታንቴ ጴፂሮሴ ሙኪ ዔያቶና ዎላ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ጴፂሮሴ ታሞ ዓጫ ዴዒ ዓኣንቴ ፔቴ'' ዉዱሮ ናይስኬና ዒዛ ዴንቂ ኮሺ'' ዒዛ ዛጋዖ፦ «ሃይያ ዬሱሴና ዎላ'' ዓኣያኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ጴፂሮሴ ጋዓንቴ፦ «ሃና ዓሴላ! ታኣኒ ዒዛ ዔሩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ዻካ'' ናጌስካፓ ፔቴ'' ዓሲ ሃሣ ጴፂሮሴ ዛጋዖ፦ «ኔኤኒያ ዔያቶይዳፓ ፔቴ''ሢኬ!» ጋዓዛ፥ ጴፂሮሴ ጋዓንቴ፦ «ሃይ ዓሢ ኔ! ታ ዔያቶና ዎላ'' ዓኣያቱዋሴ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ፔቴ ሳኣቴጉዴያ ሃሣ ኔጋዖ ፔቴ'' ሜሌ'' ዓሲ፦ «ሃይ ዓሢ ጌሊላ ዓሲኬ፤ ጎኔ ዒዛና ዎላ'' ዓኣያኬ» ጌዒ ኮሺ'' ዶዲሺ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ጴፂሮሴ ጋዓንቴ፦ «ሃይ ዓሢ ኔ! ኔ ጋዓ ዓሢ ታ ዔሩዋሴ!» ጌዔኔ። ዬኖ ዒ ጋዓ ጎይሣ ዓኣንቴ ኮይዳ ቂኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ዬማና ጎዳ ዬሱሴ ሺሪ ጴፂሮሴ ዛጋዛ፥ ጴፂሮሴም፦ «ሃኖ'' ኮይዳ ቂኢቁዋንቴ ሃይሢ ማይንቲ ‹ታ ዒዛ ዔሩዋሴ› ኔ ታና ጋዓንዳኔ» ጌይ ጎዳ ዬሱሴ ቤርታ ዒዛም ኬኤዜሢ ጶቃዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ካሮ'' ኬስካዖ ኮሺ'' ዒናፓ ዖዪ ዒዚ ዬኤኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ዒማ''ና ዬሱሴ ዓርቄ ዓሳ ዒዛ ቦሂ ቦሂ ጳርቂያ ጳርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ዓኣፖ ካሮ''ዋ ዒዛኮ ካንቂ ካንቂ፦ «ዖናዳይ ኔና ባዔሢ? ሂንዳ ኔ ፆኦሲ ማሊሢ ኬኤዛያታቴ ዔሬ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ዬያጉዲ ሃሣ ሚርጌ ባኣዚ'' ጌዒ ጌዒ ዒዛ ጫሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ሳዓ ካራዛ ዴሮ''ኮ ጪሞና ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሶና ፔቴ''ይዳ ቡኪንቴኔ፤ ዬሱሴያ ዔያታ ቡኪንቶ ቤዞ ዔኪ ሙካዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ዒዛ ኮራ፦ «ሂንዳ ኑም ኬኤዜ! ኔኤኒ ሜሲሔዳ?» ጋዓዛ፥ ዒዚ ጋዓንቴ ዔያቶም፦ «ታ ዒንሢም ኬኤዛዛ ዒንሢ ጎኔኬ ጎውዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ሃሣ ታ ዒንሢ ዖኦጫዛኣ ታኣም ዒንሢ ማሂ ኬኤዙዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ጋዓንቴ ሃይማፓ ዓርቃዖ ዓሲኮ ናዓሢ ዼኤፖ ፆኦዛሢኮ ሚዛቆ ዛላ'' ቦንቺንቲ ዴዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ዬካፓ ቢያሢ ፔቱሞና፦ «ሂዴቶ ኔ ፆኦሲ ናይኬ ጌይሢዳ?» ጌይ ዒዛ ዖኦጫዛ፥ ዒዚ፦ «ሂዮ፤ ዒንሢ ታና ጋዓሢጉዴያኬ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ዔያታ ማሃዖ፦ «ዓካሪ ማይ ዓይጎ ማርካ ኑም ኮይሳይ? ሃይሾ ዒ ጌዔ ባኮ ኑ ኑ ቶኦኪና ዋይዜኔ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ዎጎሮ ቡኪንቴ ዓሳ ቢያ ዔቂ ዬሱሴ ጲላፆሴ ቤርቶ ዔኪ ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ሂዚ ጌዒያ ዒዛ ዔያታ ዎጎና ዓይሢሳኒ ኬኤዚሢ ዓርቄኔ፦ «ሃይ ዓሢ፥ ኑኡኮ ዴሮ'' ዻቢሻንቴ ኑ ዴንቄኔ፤ ሮሜ ካኣቲም ጊኢራ ጊኢሪንቱዋጉዴያ ላኣጋኔ፤ ሃሣ ‹ታኣኒ ካኣቲ ማዔ፥ ሜሲሔኬ› ጌዒ ጌዒ ኬኤዛኔ።» ");
INSERT INTO mdybse_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጲላፆሴያ፦ «ኔኤኒ ዓይሁዴ ካኣቲዳ?» ጌይ ዬሱሴ ዖኦጫዛ፥ ዬሱሴ ማሃዖ፦ «ሂዮ፥ ኔ ታና ጌዔሢጉዴያኬ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ዬማና ጲላፆሴ ቄኤሶኮ ሱኡጎና ዴሮ''ናም፦ «ሃያ ዓሢ ዑፃ ዓይጎ ዻቢንቲያ ታ ዴንቂባኣሴ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ዓሳ ጋዓንቴ፦ «ሃይ ዓሢ ጌሊላይዳፓ ዓርቃዖ ሃይካ ሄላ''ንዳኣና ዪሁዳ ዓጫ'' ቢያ ዔርዚ ዔርዚ ዴሮ'' ፑርቱሞም ዔቂሳኔ» ጌዒ ጌዒ ኮሺ ዶዲሺ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጲላፆሴ ጌሊላ ጌይንቴ ዑኡዞ ዋይዛዖ፦ «ሃይ ጌሊላ ዓጪ ዓሲዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ዬሱሴ ሙኬሢ ሄሮዲሴ ዎይሣ ዓጫ''ፓ ማዔሢ ጲላፆሴ ዔሪ ማሂ ጊንሣ ሄሮዲሴ ባንሢ ዳኬኔ፤ ሄሮዲሴ ዬማና ዬሩሳላሜይዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮዲሴ ዬሱሴ ዛጋዖ ሚርጌ ዎዛዼኔ፤ ዓይጎሮ ጌዔቶ ዬሱሴ ዛሎ'' ቤርታ ዒ ዋይዜሢሮ ዛጋኒ ሚርጌ ዎዴ ዒዛ ኮዓኔ፤ ዬያጉዲ ሃሣ ዬሱሴ ፆኦሲ ዎልቄና ዓኪ ባኣዚ'' ማዼም ዛጋኒ ማሊሢያ ጌሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ዬያሮ ሄሮዲሴ ዬሱሴ ሚርጌ ዖኦጪሢ ዖኦጬኔ፤ ዬሱሴ ጋዓንቴ ዓይጎዋ ዒዛም ማሂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ቄኤሶኮ ሱኡጎና ሙሴ ዔርዜ ዎጎ ዔርዛ ዓሳ ዒኢካ ዔቂ ሚርጌና ዒ ፑርቲሴያ ማሊሲ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮዲሴ ፖኦሊሶና ዎላ'' ማዒ ዒዛ ቦሂ ዓማላ''ዖ፥ ሚዛጲ ዓፒላ ማይሲ ጊንሣ ጲላፆሴ ባንሢ ማሂ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ዬኖ ኬሎ''ና ሄሮዲሴና ጲላፆሴና ዎላ'' ዒጊንቴኔ፤ ዬያኮ ቤርታ ጋዓንቴ ዔያታ ዎላ'' ዱጲሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ዬካፓ ጲላፆሴ ቄኤሶኮ ሱኡጎና ሃሣ ዴሮ''ይዳፓ ዔርቴ ዓሶና ዴሮ''ና ቢያ ዔኤላ''ዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹ዴሮ'' ዒ ፑርቱሞም ዔቂሳኔ!› ጌዒ ዒንሢ ሃያ ዓሢ ታ ኮይላ'' ዔኪ ሙኬኔ፤ ታኣኒ ጋዓንቴ ዒንሢኮ ቤርታ ዒዛ ዖኦጪ፥ ዒንሢ ጌዒ ኬኤዛ ባኮይዳፓ ቢያ ሃያ ዓሢ ዑፃ ዓይጎዋ ዻቢንቲ ታ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ዬያጉዲ ሃሣ ሄሮዲሴያ ዒዛይዳ ዓይጎ ዻቢንቲ ዴንቂባኣሢሮ ሃንጋ ኑ ባንሢ ማሂ ዳኬኔ፤ ዓካሪ ሃይ ዓሢ ዒዛ ሃይቢም ሄሊ''ሳ ባኣዚ'' ዓይጎዋ ማዺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ዬያሮ ታ ጳዺና ኩንሢ ሃሻ''ንዳኔ» ጌዔኔ።  ");
INSERT INTO mdybse_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ሌዓ ሌዓ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ና ጲላፆሴ ፔቴ'' ቱኡሲ ዓሲ ዴሮ''ም ቡላ''ያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ዬያሮ ዴራ'' ቢያ፦ «ሃያ ዓሢ ባይዜ! ባርባኔ ጋዓንቴ ኑም ቡሌ''!» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባኔ ጎዖሢ ካታሞይዳ ዑራ ዔቂሲ ዓሲ ዎዼ ዛላና ቱኡቲ ዓኣ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጲላፆሴ ዬሱሴ ቡሊ'' ሃሻ''ኒ ኮዓዖ ላሚ ዴሮ''ም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ዴራ'' ጋዓንቴ፦ «ሱፄ፥ ሱሱፄ!» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ጲላፆሴ ሃይሣሲ፦ «ሃይ ዓሢ ዻቤ ዻቢንታ ዓይጌንዴዳይ? ታኣኒ ዒዛ ሃይቢም ሄሊ''ሳንዳ ዓይጎ ባኣዚ''ያ ዴንቂባኣሢሮ ጳዺና ታ ኩንሢ ሃሻ''ንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ዔያታ ጋዓንቴ ዑኡዞ ፔኤኮ ዼ'ጊዲ፦ «ሱሱፄ!» ጌዒ ጌዒ ዒላቴኔ፤ ዒላታኣ ዔያቶኮ ኮሺ'' ዺቤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ዬያ ዛሎ''ሮ ዔያታ ዖኦጬሢ ዔያቶም ማዺንታንዳጉዲ ጲላፆሴ ዎጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ዑራ ዔቂሲ፥ ዓሲ ዎዺ ቱኡቲ ዓኣ ባርባኔ ጎዖሢ ዔያታ ዖኦጬ ጎይፆና ቡላ''ዖ፥ ዬሱሴ ጋዓንቴ ዔያታ ኮዔሢጉዲ ዓኣሢ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ዬያሮ ዬሱሴ ዔያታ ዔኪ ዴንዲፆይዳ ዓኣዖ፥ ፔቴ'' ቄሬና ጌይንታ ዓጪ ዓሲ ማዔ ሲሞኦኔ ጎዖሢ ካታሞኮ ዙላ''ፓ ካታሞ ጌላንቴ ዒዛ ዔኪ ዬሱሴ ሱፆንዶ ፑርቲሴ ዓሶ ሱፆ ሚፆ ኬዲሲ ዬሱሴ ጊንፆ ዓኣዻንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ሚርጌ ዓሲ ዬሱሴ ጊንፆ ዓኣዻኔ፤ ዔያቶ ባኣኮ''ይዳፓ ሚርጌና ዒዛ ጋይቴ ዖዪ ዬኤካ ላኣሊ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ዬሱሴ ጋዓንቴ ዔያቶ ባንሢ ሺሪጋፓ፦ «ዒንሢ ዬሩሳላሜ ላኣላ! ዒንሢ ቶኦኮ''ና ዒንሢ ናኣቶ''ናም ዬኤኩዋቴ! ታ ጋይቴ ዬኤኪፖቴ! ");
INSERT INTO mdybse_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ዓይጎሮ ጌዔቶ ‹ዞኦካሢ ማዔ ላኣሎና ሾይባኣ ጎጶና ዻንሥሢባኣ ላኣሎና ዎዚ ባሊቲና ዓኣያዳይ?› ጌይንታንዳ ኬሊ'' ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ዬኖና ዓሳ ዹኮ'' ‹ኑ ዑፃ ዶዔ!› ሃሣ ጌሜሮ ‹ኑና ዓኣቹዋቴ!› ጌይሢ ዓርቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ዓካሪ ዬይ ቢያ ባካ ዓኣዔ ሚሢዳ ሃኣዺ ማዓያ ማዔቶ ሜሎ ሚፆይዳ ዎይታንዳያ ናንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ዬያጉዲ ሃሣ ዬሱሴና ዎላ'' ዎዻኒ ላምዖ ፑርታ ማዼ ዓሲስኬንሢያ ዔኪ ዔያታ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ዬካፓ ዔያታ ቶኦኪ ሜጌሢ ጌይንታ ቤዞ ሄላ''ዖ ዒኢካ ዬሱሴ ሱፄኔ፤ ሃሣ ላምዖ ፑርቶ ማዼዞንሢያ ዬሱሴኮ ሻውሎ''ና ሚዛቆ ዛሎ''ናይዳ ሱፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ዬካፓ ዬሱሴ፦ «ዓዳሢዮ! ዔያታ ማዻ ባኮ ዔሩዋኣሢሮ ዓቶንጎ ዔያቶም ጌዔ!» ጌዔኔ። ፖኦሊሳ ዱማሲ ዔራኒ ዓጎ ባኣዚ'' ዓጊ ዬሱሴኮ ዓፒሎ ጊሽቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ዴራ'' ዔቂ ዛጋንቴ ዓይሁዶኮ ሱኡጋ፦ «ሜሌ'' ዓሶ ዒ ዻቂሼኔ፤ ዓካሪ ዒዛ ፆኦሲ ዶኦሬያ፥ ሜሲሔ ማዔቶ ሂንዳ ፔና ዻቂሾንጎ!» ጌዒ ጌዒ ዒዛ ቦሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ፖኦሊሳ ሃሣ ዬያጉዲ ዒዛ ቦሄኔ፤ ፑርቲ ሶልኬ ዑሺያ ዒዛም ዒንጋዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«ኔኤኒ ዓይሁዴ ካኣቲታቶ ሂንዳ ኔና ዻቂሼ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","«ሃይ ዓይሁዴ ካኣቲኬ!» ጌዒ ፃኣፖናያ ዬሱሴኮ ቶኦኮ ኬዴ ሚፆ ዑፃ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ዬሱሴና ዎላ'' ሱፆና ፑርቶ ማዼዞንሢዳፓ ፔቴ''ሢ ዬሱሴ ኮራ፦ «ኔኤኒ ሜሲሔቱዋዓዳ? ሂንዳ ኔና ዻቂሺ ኑናኣ ዻቂሼ!» ጌዒ ጌዒ ጫሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ባጋሢ ጋዓንቴ፦ «ኔኤኒ ሃሢ ሃይቢም ዎጊንቲ ዓኣዖ ፆኦሲ ዒጊጩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ኑኡኒ ኑ ማዼ ዻቢንቶ ዛሎ''ና ኑም ዒንጎና ዎጋ'' ኮይሳያኬ፤ ሃይ ዓሢ ጋዓንቴ ፔቴ''ታዖ ፑርታ ባኣዚ'' ማዺባኣሴ» ጌዒ ዒዛ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ዬካፓ ዬሱሴ ኮራ፦ «ጎዳሢዮ! ኔ ካኣቱሞይዳ ኔ ጌላ ዎዶ''ና ታና ጶቂሳዎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ዬሱሴ ማሃዖ፦ «ጎኔ ታ ኔኤም ጋዓኔ፤ ሃኖ'' ኔ ታኣና ዎላ'' ጌኔቴይዳ ማዓንዳኔ!» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ዓካሪ ዬይ ያዺ ማዔሢ ዓባ'' ሳዛ ማዓኣናኬ፤ ዬካፓ ዓርቃዖ ዴንዲ ማሢ ዶምቦልሳ ዎዴ ሄላ''ንዳኣና ዓቦ''ኮ ፖዓ ዓርቂንቲ ሳዓ ጉቤ ዹሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ዬማና ጌኤዦ ማኣሮይዳ ዱማሲፆሮ ጎኦቦና ዓፒላ ሳዛ''ፓ ሄኮ ዳርዒ ላምዖ ፓቂንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ዬሱሴ ዑኡዞ ዼ'ጊዲ፦ «ዓዳሢዮ! ሃይሾ ታኣኮ ሼምፓሢ ኔኤም ታ ዒንጋኔ!» ጌዔኔ። ዬያ ጌዔስካፓ ሼምፓሢ ዒዛኮ ዱጴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ዒኢካ ዓኣ፥ ፄኤቶ ፖኦሊሶኮ ሱኡጋሢ ዬያ ማዔ ባኮ ዛጋዖ፦ «ጎኔና ሃይ ዓሢ ፂሎ''ታዖኬ!» ጌዒ ፆኦሲ ቦንቼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ዬያ ባኮ ዛጋኒ ዒኢካ ቡኪንቲ ዓኣ ዓሳ ቢያ ማዔ ባኮ ዛጊ ዖዪሢና ዳዶ'' ፔኤኮ ኩቻ ባዒ ባዒ ፔ ማኣሪ ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ዬሱሴ ኮሺ'' ዔራ ዓሶ ቢያሢና ጌሊላይዳፓ ዓርቃዖ ዒዛኮ ጊንፆ ሃንታ ላኣሎና ሃኬ ዔቂ ዬያ ባኮ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ዓይሁዴ ዓጪ ካታማ ማዔ፥ ዓርማቲያሴ ጌይንታዞይዳ ናንጋ ዮሴፔ ጌይንታ ፔቴ'' ዓሲ ዓኣኔ፤ ዒዚ ፂሎ'' ሃሣ ኮሺ ዓሲኬ፤ ሃሣ ጊንሣ ዒ ዓይሁዶ ዓሶኮ ዎጎሮ ቡካ ዓሶይዳፓ ፔቴ''ሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ማዔቶዋ ዓይሁዶ ዓሳ ዬሱሴ ባይዛኒ ዞርታ ዞርቲፆና ጌኤዞናይዳ ዒ ጌሊባኣያኬ፤ ፆኦሲ ካኣቱሞዋ ሓጊ ማዓንዳ ዎዛ ጌሢ ካፓ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ዬይ ዓሢ ጲላፆሴ ኮይላ'' ዴንዲ ዬሱሴኮ ሌዞ ዒዛም ዒንጋንዳጉዲ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ሌዞዋ ዒዛኮ ሚፃፓ ኬይሲ ሻኣዣ፥ ቦኦሬ ሚዛጲ ዓፒላና ሱኡዲ ዖኦኒያ ዱኡቲባኣ ላሌ ቆኦቂ ኮሾ''ና ዱኡፒ ዔቴይዳ ዱኡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ዬያ ዒ ማዼሢ ሳዓ ዹሜም ዓይሁዶኮ ሃውሾ ኬሎ'' ቦንቻ ዓርቃኒ ዑካንቴኬ፤ ዬና ኬሌላ ሓውሾ ኬሎ''ም ጊኢጊንቲ ጊኢጊንቶ ኬሊ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ጌሊላ ዓጮ''ይዳፓ ዬሱሴ ጊንፆ ሙኬ ላኣላ ዮሴፔና ዎላ'' ዓኣዺ ዬሱሴኮ ዱኡፖ ዛጌኔ፤ ሃሣ ዎዲ'' ዒዛ ዱኡኮናቴያ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ዬካፓ ዔያታ ፔኤኮ ማኣሪ ማዒ ዴንዳዖ ሌዞም ማዓ ዼኤሻና ሳውቃ ቲሺና ጊኢጊሼስካፓ ሙሴ ዎጎ ጎይፆና ሃውሾ ኬሎ'' ዔያታ ሃውሺ ፔኤቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ላኣሎንሢ ጊኢጊሼ፥ ሳውቃ ቲዦ ዔኪ ቃልሾ ኬሎ''ኮ ቤርታሳ ዓቦ'' ጉቴ ዓሚ'' ዱኡፖ ቤዞ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ዒማ''ና ዱኡፖ ካሮ'' ዎዾና ሹጫሢ ዱኡፖ ካራ''ፓ ኮላዺ ዓኣንቴ ዔያታ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ዔያታ ዱኡፖ ዔቶ'' ጋሮ ጌሌ ዎዶ''ና ጋዓንቴ ጎዳ ዬሱሴኮ ሌዞ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ዬያ ባኮና ኮሺ'' ዔያታ ዲቃቲ ዓኣንቴ ዓኣፒዳ ዱካ፥ ጌኤሺ ቦኦሬ ዓፒላ ማይንቴ ላምዖ ዓሲ ዔያታ ዔሩዋንቴ ሙኪ ዔያቶ ኮይላ'' ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ላኣሎንሢ ሚርጌና ዒጊጫዖ ሊካ ሳዓ ዛጊ ዓኣንቴ፦ «ሼምፔና ዓኣ፥ ዬሱሴ ሃይቄ ዓሶ ባኣካ'' ዓይጋ ዒንሢ ኮዓይ? ");
INSERT INTO mdybse_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ዒዚ ሃይካ ባኣሴ፤ ዔቄኔ፤ ቤርታ ዎንዴ ጌሊላይዳ ዓኣ ዎዶ''ና ዒንሢም ኬኤዜሢ ማሉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ዬይያ፦ ‹ዓሲኮ ናዓሢ ጎሞ ዓሶም ዓኣሢ ዒንጊንታኒ ሃሣ ሱፂንታኒ፥ ሃይሣሳ ኬሎ''ና ሃይባ''ፓ ዔቃኒ ኮይሳኔ› ዒንሢም ጌዔሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ላኣሎንሢ ዬሱሴኮ ቃኣሎ'' ማሊ ጶቂሴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ዱኡፖ ቤዛፓ ማዒ ዬያ ቢያ ታጶ ፔቴ''ዞንሢና ዓቴዞንሢናም ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ዬያ ዳኪንቴዞንሢም ኬኤዜዞንሢ ሜግዴላ ዓጮ'' ማይራማ፥ ዮሃና፥ ያይቆኦቤኮ ዒንዶ ማይራሞንታ ዬያጉዲ ሃሣ ሜሌ'' ላኣሊያ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ዳኪንቴዞንሢ ጋዓንቴ ዬይ ባካ ዔያቶም ዓውቲ ማሌሢሮ ጎኔኬ ጌይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ጋዓንቴ ጴፂሮሴ ዔቂ ዱኡፖ ቤዞ ጳሽኬኔ፤ ዒኢካ ዒ ሄሊ'' ሂርኪ ጌዒ ዛጋዖ ሌዞ ሱኡዶና ሻኣዦ ሚዛጶ ዓፒሎ ሌሊ ዴንቄስካፓ ማዔ ባኮ ዲቃቲ ሄርሺ ሄርሺ ማኣሪ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ዬኖ ኬሎ''ና ዬሱሴኮ ጊንፆ ሃንታዞንሢዳፓ ላምዖንሢ ዔማዎሴ ጌይንታ ጉርዳስኬኖ ዴንዳኔ፤ ዔማዎሴ ዓኣሢ ዬሩሳላሜይዳፓ ኮሺ'' ሃኩዋ ቤስካኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ዔያታ ዬያ ማዔ ባኮ ቢያ ዛሎ'' ዎላ'' ጌስቲ ጌስቲ ዓኣዻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ዬያ ዔያታ ኬኤዚ ጌስታ ዎዶ''ና ዬሱሴ ፔ ቶኦኪና ሙኪ ዔያቶና ዎላ'' ዓኣዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ጋዓንቴ ዔያታ ፔ ዓኣፖና ዒዛ ዛጋያታዖ ዖና ማዔቶዋ ዔራኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ዒዚ፦ «ዒንሢ ሃይ ጌስቲ ጌስቲ ዓኣዻሢ፥ ዬይ ዓይጎ ባኣዚ''ዳይ?» ዔያቶ ኮራ ጌዔኔ። ዔያታ ዒማ''ና ኮሺ'' ዖያዖ ዓኣ ቤዛ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ዔያቶይዳፓ ፔቴ'' ቄሌዮጳ ጌይንታሢ፦ «ኔኤኒ ዬሩሳላሜ ካታሞይዳ ዓኣዖ ሃሢ ቢሪ ማዺንቴ ባኮ ቢያ ዔሩዋዖ ሾኦቺ ማዒ ዓቴሢ ኔና ሌሊዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ዬሱሴ ማሃዖ፦ «ዬይ ዓይጌንዴዳይ?» ጋዓዛ፥ ዔያታ «ናዚሬቶ ዓጮ'' ዓሢ፥ ዬሱሴ ዑፃ ማዔ ባኮሾ! ዒዚያ ፆኦሲና ዓሲና ቢያ ቤርታ ኬኤዛ ባኮና ማዾና ዶዲ ማዔ ፆኦሲ ማሊሢ ኬኤዛያኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ቄኤሶኮ ሱኡጎና ኑና ዎይሣ ዔርቴ ዓሳ ሃይቃንዳጉዲ ዒዛይዳ ዎጌስካፓ ዒዛ ሱፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ኑኡኒ ጋዓንቴ ‹ዒስራዔኤሌ ዓሶ ዻቂሻንዳይ ዒዛኬ› ጌዒ ሚርጌና ሃጊ ማዓንዳ ዎዛ ጌሤያታንቴ፥ ዬይ ቢያ ባካ ማዔስካፓ ሃኖ'' ሃይሣሳ ኬሊ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ሃሣ ኑ ባኣኮ''ይዳ ዓኣ ፔቴ'' ፔቴ'' ላኣላ ሚርጌና ኑና ዲቃሢ ማሊሼኔ፤ ዔያታ ሃኖ'' ጉቴ ዱኡፖ ቤዞ ዴንዳዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ዒዛኮ ሌዞ ዴንቂባኣሴ፤ ‹ዒዚ ሃይባ''ፓ ዔቄኔ› ጋዓ ኪኢታንቾ ዓውቲጉዴያና ዛጌኔ ጌዒ ዔያታ ማዒ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ሃሣ ኑጊዳፓ ፔቴ'' ፔቴ''ዞንሢ ዱኡፖ ቤዞ ዴንዳዖ ላኣላ ጌዔሢጉዲ ማዔም ዛጌኔ፤ ዬሱሴ ጋዓንቴ ዔያታ ዴንቂባኣሴ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ዬሱሴ ዔያቶም ማሃዖ፦ «ዒንሢ ማሊ ጶቂሡዋያ ሃሣ ፆኦሲ ማሊፆ ኬኤዛዞንሢ ኬኤዜሢ ቢያ ጎኔኬ ጎዑዋዖ ዒኖ ዶጪሴ ዓሳ! ");
INSERT INTO mdybse_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ሜሲሔ ዬያ ቢያ ሜታሢ ዔካንዳያና ቦንቺንታኒያ ኮይሳያቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ዬካፓ ሙሴና ፆኦሲ ማሊፆ ኬኤዛ ዓሶና ማፃኣፖይዳፓ ዓርቃዖ ጌኤዦ ማፃኣፖይዳ ቢያ ዒዛ ዛሎ'' ኬኤዚንቴ ባኮ ፓይዲ ፓይዲ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ዔያታ ዴንዳ ጉርዴሎኮ ዑካዛ ዬሱሴ ዔያቶ ኮራ ዎርቁዋዖ ዴንዳያ ማሌሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ዔያታ፦ «ሳዓ ዓሜ''ኔ፥ ዓባ''ኣ ጌሌኔ፤ ዬያሮ ኑኡና ዎላ'' ሃካ ዎርቄ» ጌይ ዒዛ ኮሺ'' ዶዲሺ ሺኢቄሢሮ ዔያቶና ዎላ'' ዎርቃኒ ማኣሪ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ዬካፓ ዔያቶና ዎላ'' ሙዓኒ ዴዓዖ፥ ካሣ ዔኪ ጋላታ ሺኢጲሢ ሺኢቄሢኮ ጊንፃ ቡንፂ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ዬማና ዓኣፓ ዔያቶኮ ቡሊ''ንታዛ ዬሱሴ ማዔሢ ዔያታ ዔሬኔ፤ ዒዚ ጋዓንቴ ቤዞማና ዔያቶኮ ዓኣፓፓ ዓኣሺንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ዔያታ ዎሊ ኮይላ''፦ «ዎንዴ ጎይፃ ኑ ዓኣንቴ ኑም ዒ ኬኤዛኣና፥ ጌኤዦ ማፃኣፓፓ ፓይዲ ፓይዲ ኑም ዔርዛኣና ዎዛና ኑኡኮ ዒና'' ታሚጉዲ ዔኤቲባይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ዔያታ ዬማና ዔቃዖ ዬሩሳላሜ ማዒ ዴንዴኔ፤ ዒኢካ ታጶ ፔቴ''ዞንሢ፥ ዔያቶኮ ላጎንሢና ዎላ'' ፔቴ''ይዳ ቡኪንቲ ዓኣንቴ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ዒማ''ና ታጶ ፔቴ''ዞንሢ፦ «ጎዳ ዬሱሴ ጎኔ ሃይባ''ፓ ዔቄኔ! ሲሞኦኔማ ጴዼኔ!» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ላምዖ ጊንፆ ሃንታዞንሢ ሃሣ ፔ ዛሎ''ና ዔያቶ ኮይላ'' ጎይፃ ማዔ ባኮና ጎዳ ዬሱሴ ካሦ ዔያቶም ቡንፂ ዒንጌ ዎዶ''ና ዎይቲ ዒዛ ዔያታ ዔሬቶዋ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ዔያታ ዬያ ጋዓ ጎይሣ ዓኣንቴ ዬሱሴ ፔ ቶኦኪና ዔያቶ ባኣካ'' ሙኪ ዔቃዖ፦ «ዒንሢ ዎዚ ዓኣይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ዔያታ ጋዓንቴ ዔኤዤ ዛጋያ ዔያቶም ማላዛ፥ ዲቃቲ ሚርጌና ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ዬሱሴ ጋዓንቴ፦ «ዓይጎሮ ዒንሢ ዲቃታይ? ሃሣ ዓይጎሮ ዒንሢ ‹ሃይ ጎኔ ባኣዚ''ዳ?› ጌዒ ማላይ? ");
INSERT INTO mdybse_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ታኣኮ ኩጮና ቶኮ''ና ዛጊጋፓ ታና ማዔሢ ዔሩዋቴ፤ ሃሣ ዑፆዋ ታኣኮ ዓርቂ ዛጉዋቴ፤ ታና ዒንሢ ዛጋሢጉዲኬ፤ ዔኤዤኮ ጋዓንቴ ዓሽኪንታ ሜጌሢንታ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ዬያ ጌዒጋፓ ፔኤኮ ኩጮና ቶኮ''ና ዔያቶ ዻዌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ዔያታ ኮሺ'' ዎዛዺ፥ ሃሣ ዲቃቲ ሄርሺፆይዳፓ ዔቄያና ዬያ ጎኔኬ ጌዒባኣሴ። ዬሱሴ ማሃዖ፦ «ዔኤቢ፥ ሙዖ ባኣዚ'' ዒንሢኮ ዓኣ?» ጌይ ዔያቶ ዖኦጫዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ዔያታ ሚቺንቴ ሞሎ ዓሽኪ ዻካ'' ዒዛም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ዒዚያ ዔኪ ዔያቶኮ ቤርታ ሙዓዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","«ቤርታ ዒንሢና ዎላ'' ታ ዓኣ ዎዶ''ና ሙሴ ዎጎይዳ፥ ፆኦሲ ማሊፆ ኬኤዛ ዓሶና ዓይኑሞ ማፃኣፖናይዳ ታ ዛሎ'' ፃኣፒንቴሢ ቢያ ኩማንዳያ ኮይሳኔ ጌዒ ታ ዒንሢም ኬኤዜ ቃኣላ'' ሃያኬ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ዬካፓ ጌኤዦ ማፃኣፖ ማሊ ዔያታ ጶቂሣንዳጉዲ ዒኖ ዔያቶኮ ቡሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ዒዚ ዔያቶም፦ «ሜሲሔ ሜቶ ዔካንዳሢና ሃይሣሳ ኬሎ''ና ሃይቢዳፓ ዔቃንዳሢ ቤርታዺ ፃኣፒንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ዬያጉዲ ሃሣ ዒዛኮ ሱንፆና ጎሜ ቡኡፂ ጌኤሽኪሢ ዛላኮ ኮሺ ሃይሴ ዬሩሳላሜይዳፓ ዓርቃዖ ቢያ ዓጮ''ይዳ ዓኣ ዴሮ''ም ኬኤዚንታንዳጉዲ ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ዒንሢያ ዬያ ባኮኮ ቢያ ማርኮንሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ዓካሪ ታኣኒ ታ ዓዳሢኮ ሃጊ ማዓንዳ ዎዞ ዒንጊፆ ዒንሢም ዳካንዳኔ፤ ዒንሢያ ዎልቄ ዒንሢም ሎፓ ዒንጊንታንዳያ ሄላ''ንዳኣና ዬሩሳላሜ ካታሞይዳ ዴዑዋቴ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ዬካፓ ዬሱሴ ዔያቶ ዬሩሳላሜ ካታማፓ ኬሲ''፥ ቢታኒያ ጌይንታ ቤዞ ሄላ''ንዳኣና ዔኪ ዴንዳዖ ዒኢካ ኩጮ ዒዛኮ ዔያቶ ዑፃ ፒሺ ዔያቶ ዓንጄኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ዒኢካ ዔያቶ ዒ ዓንጄ ጎይሣ ዓኣዖ ዔያቶይዳፓ ዱማዺ ሌካ ጫሪንጮ ዔውቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ዔያታኣ ዒዛም ዚጋዖ፥ ዼኤፒ ዎዛና ጊንሣ ዬሩሳላሜ ማዒ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ሓሣ ፆኦሲ ጋላቲ ጋላቲ ቢያ ኬሊ''ና ጌኤዦ ማኣራፓኣ ዔያታ ዱማዺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ቢያ ማዢንቴ ባኮኮ ቤርታ ቃኣላ ዓኣኔ፤ ዬይ ቃኣላ'' ፆኦሲና ዎላ'' ፔቴ''ኬ፤ ዬይ ቃኣላ''ኣ ፆኦሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ዬይ ቤርታዺ ፆኦሲና ዎላ'' ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ቢያ ባኣዚ'' ዒዛና ማዢንቴኔ፤ ማዢንቴ ባኮይዳፓ ቢያ ፔቴ'' ባኣዚ''ታዖ ዒዛናቱዋዖ ማዢንቴ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ዒዛና ናንጊ ዓኣኔ፤ ዬና ናንጌላኣ ዓሲኮ ፖዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ፖዒ ዹሚና ፖፖዓኔ፤ ዹሚ ፖዒ ፔቴ''ታዖ ባሹዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ፆኦሲዳፓ ዳኪንቴ፥ ዮሓኒሴ ጌይንታ ፔቴ'' ዓሲስኬይ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ዬያ ዓሢኮ ማርካዺፆና ዓሲ ቢያ ዬሱሴ ጉሙርቃንዳጉዲ ፖዖ ዛሎ'' ማርካዻያ ማዒ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ዒዚ ፖዖ ዛሎ'' ማርካዻኒ ሙካንዳኣፓዓቴም ዒ ፔ ቶኦኪና ፖዒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ዓሲም ቢያ ፖዒ ፖዓ ጎኔ ፖዒ ዓጮ'' ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ዬይ ፖዓሢ፦ ቤርታ ዓጮ''ይዳ ዓኣያኬ፤ ዓጫ'' ማዢንቴሢያ ዒዛናኬ፤ ዓጫ'' ጋዓንቴ ዒዛ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ዒዚ ፔኤኮ ፃጶ ባንሢ ሙካዛ ፃጳ ዒዛኮ ጋዓንቴ ዒዛ ጎኔኬ ጌይ ዔኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ያዺ ማዔያታቴያ ዒዛ ጎናሲ ዔኬዞንሢና ዒዛኮ ሱ'ንፆ ጉሙርቃዞንሢም ፆኦሲ ናይ ማዓንዳ ቢታንቶ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ዔያታ ፆኦሲዳፓ ሾይንቴያፓዓቴም ዓሲ ዜርሢዳፓ፤ ጌይፃ፦ ዓሲ ማሊሢና ዓዶና ዒንዶናፓ ሾይንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ዬይ ቃኣላ'' ዓሲ ማዔኔ፤ ፆኦሲኮ ኮሹሞ ዒንጊፆና ጎኑሞና ኩሙሢ ማዒ ኑ ጊዳ'' ዒ ናንጌኔ፤ ፔቴ'' ናዓሢ፡ ፔኤኮ ዓዶ ኮራ ዓኣ ቦንቺንቶጉዴያ ማዔ ቦንቺንቶ ዒዛኮ ኑ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዮሓኒሴ፦ «ታኣኮ ጊንፆ ሙካንዳሢ ታ ጊዳ''ፓ ባሻያኬ፤ ታኣኮ ቤርታ ዒ ዓኣኔ ጌዒ ታ ዒንሢም ኬኤዜሢያ ሃያኬ!» ጌዒ ዒላቲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ዒዛኮ ሚርጌ ኮሹሞ ዒንጊፆይዳፓ ኮሹሞ ዒንጊሢ ኑም ቃሲ''ንቲ ቃሲ''ንቲ ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ፆኦሲ፡ ሙሴ ዛሎ''ና ቤርታ ዎጌ ኑም ዒንጌኔ፤ ጋዓንቴ ፆኦሲኮ ኮሹሞ ዒንጊፆና ጎኑሞና ዬሱስ ኪሪስቶሴ ዛሎ''ና ኑም ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ፆኦሲ ዛጌይ ፔቴ''ታዖ ዖኦኒያ ባኣሴ፤ ማዔቴያ ዓዶ ኮራ ዓኣ ዒዛኮ ፔቴ'' ናዓሢ ማዔ፥ ጎዳሢ ፔጋሲ ዒዛ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ዓይሁዶ ዓሶ ዎይሣ ዓሳ ዬሩሳላሜይዳፓ ቄኤሶና ሌዊ ዓሶናይዳፓ ዮሓኒሴ ኮራ ዳኪ፦ «ኔ ዖናዳይ?» ጌዒ ዖኦጪሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ዮሓኒሴያ፦ «ታኣኒ ሜሲሔቱዋሴ» ጌዒ ማርካዼያፓዓቴም ሉኡቂ ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ዔያታ፦ «ሂዳዖ ኔ ዖናዳይ? ኔ ዔኤሊያሴዳ?» ጌዒ ዒዛ ዖኦጫዛ፥ ዒዚ፦ «ታ ዒዛቱዋሴ» ጌይ ማሄኔ፤ ዔያታ፦ « ‹ሙካንዳኔ› ጌይንቴ፥ ፆኦሲ ማሊፆ ኬኤዛሢ ኔናዳ?» ጌዔኔ። ዒዚያ፦ «ታናቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ጋፒንፆይዳ ዔያታ፦ «ሂዳዖ ኔ ዖናዳይ? ኑና ዳኬ ዓሶም ማሂ ኑ ኬኤዛንዳጉዲ፥ ኔ ኔ ዛሎ'' ዎዚ ጋዓይ?» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ዒዚያ ዔያቶም ማሃዖ፦ «ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና፦ ‹ፆኦሲኮ ጎይፆ ፒዚሱዋቴ› ጌዒ ጌዒ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዒላታ ዓሲ ዑኡሲ ጌይንቴሢ ታናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ዳኪንቴ ፔርሴ ዓሶይዳፓ ፔቴ'' ፔቴ''ዞንሢ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","«ኔኤኒ ሜሲሔ ሓሣ ዔኤሊያሴ፤ ጊንሣ ሓሣ ‹ሙካንዳኔ› ጌይንቴ ፆኦሲ ማሊፆ ኬኤዛሢ ማዒባኣቴ ሂዳዖ ኔ ዓይጎሮ ዋኣፆና ማስካይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ዮሓኒሴ ማሃዖ፦ «ታኣኒ ማስካሢ ዋኣሢናኬ፤ ጋዓንቴ ዒንሢ ዔሩዋይ፥ ዒንሢኮ ባኣካ'' ሓሢ ዔቂ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ታኣኮ ጊንፃፓ ሙካንዳሢ ዒዛኬ፤ ታኣኒ ዒዛኮ ዱርዞ ቱኮ'' ሱዞ ቡላ''ኒታዖ ኮይሱዋያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ዬይ ቢያ ማዔሢ ዮሓኒሴ ዋኣፆና ማስካ ቤዞ፥ ቢታኒያይዳኬ፤ ቢታኒያ ጌይንታዛ፦ ዮርዳኖሴ ዎሮ ሱካ'' ዓኣ ካታማኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ዚሮ ጉቴ''ሎ ዮሓኒሴ ዒዛ ባንሢ ዬሱሴ ሙካንቴ ዛጋዖ፦ «ሓይሾ ዓሶኮ ጎሞ ጌኤሻንዳ ፆኦሲ ማራዓሢ ሓያኬ! ");
INSERT INTO mdybse_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‹ታኣኮ ጊንፃፓ ሙካንዳሢ ታ ጊዳ''ፓ ባሼኬ፤ ዒ ታኣኮ ቤርታ ዓኣያኬ› ታ ዒንሢም ጌዔሢ ሓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ታኣኒያ ታ ቶኦኪና ዒዛ ቤርታ ዔሩዋሴ፤ ጋዓንቴ ዒዚ ዒስራዔኤሌ ዴሮ''ም ፔጋዺ ዔርታንዳጉዲ ታኣኒ ዋኣፆና ማስኪ ማስኪ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ሄሊ''ሳዖ ዮሓኒሴ፦ «ዓያና ጌኤሺ ጫሪንቺዳፓ ዶኦሌ'' ኬዳ''ያጉዲ ዒዛይዳ ኬዲ'' ዴዓንቴ ታ ዛጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ታ ታ ቶኦኪና ቤርታዺ ዒዛ ዔሪባኣሴ፤ ጋዓንቴ ዋኣፆና ታ ማስካንዳጉዲ ታና ዳኬሢ፦ ‹ዓያኖ ጌኤዣ ኬዲ'' ዒዛ ዑፃ ዴዓንቴ ኔ ዛጋንዳሢ ሓሣ ዓያኖ ጌኤዦናኣ ማስካንዳሢ ዒዛኬ› ታኣም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ታኣኒያ ዬያ ዛጌኔ፤ ዬያሮ ዒዚ ፆኦሲ ናይታሢ ታ ማርካዻኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ዚሮ ጉቴ''ሎ ዮሓኒሴ ላምዖ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዒኢካ ዔቂ ዓኣዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ዬሱሴ ዒኢና ዓኣዻንቴ ዛጊ፦ «ሓይሾ ፆኦሲኮ ማራዓሢ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ላምዖ ዮሓኒሴኮ ጊንፆ ሃንታዞንሢ ዮሓኒሴ ዬያ ጋዓሢ ዋይዛዖ ዬሱሴ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ዬሱሴ፡ ዔያታ ዒዛ ጊንፆ ሙካሢ ሺሪ ዛጋዖ፦ «ዓይጎ ዒንሢ ኮዓይ?» ጋዓዛ፥ ዔያታ፦ «ሬቢ! ኔኤኒ ናንጋሢ ዓንካዳይ?» ጌዔኔ። ሬቢ ጌይፃ፦ ዔብሬ ዓሶ ሙኡጮና «ዔርዛሢዮ» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ዒዚያ፦ «ሓኒ ሙኪ ዛጉዋቴ» ዔያቶም ጌዔኔ፤ ዒማ''ና ዓባ'' ኬዴ''ያኬ። ዬያሮ ዔያታ ዓኣዺ ዒዚ ዎካ ናንጋቴያ ዛጌኔ። ዬኖ ኬሎ'' ዒዛና ዎላ'' ዴንዲ ዓባ'' ጌላንዳያ ሄላ''ንዳኣና ዔያታ ፔኤቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ዮሓኒሴ ጌዔሢ ዋይዚ ዬሱሴ ጊንፆ ዓኣዼ፥ ጊንፆ ሃንታዞንሢፓ ፔቴ''ሢ፡ ሲሞኦኔ ጌይንታ ጴፂሮሴኮ ጌርሲ ዒንዲራሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ዒንዲራሴ ቤርታዺ ፔኤኮ ጌርሲ ሲሞኦኔ ኮራ ዓኣዻዖ፦ «ኑኡኒ ሜሲሔ ዴንቄንቴሞ!» ጌዔኔ። ሜሲሔ ጌይፃ፦ ካኣቱሞም ዶኦሚ ዓርቆናያ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ዬካፓ ዒንዲራሴ ፔኤኮ ጌርሲ ሲሞኦኔ ዬሱሴ ኮራ ዔኪ ሙኬኔ። ዬሱሴ ዒማ''ና ዒዛ ጊዥ ጌይ ዛጋዖ፦ «ኔኤኒ ዮና ናዓሢ ሲሞኦኔ ጎዖሢኬ፤ ሃይፓ ሴካ ጋዓንቴ ኔ ኬፓ ጌይንታንዳኔ» ጌዔኔ። ኬፓ ጌይፃ፦ ዔብሬ ዓሶ ሙኡቺና «ላሌ» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ዚሮ ጉቴ''ሎ ዬሱሴ ጌሊላ ዓኣዻዖ ፒልጶሴ ጎዖሢ ዴንቂ፦ «ታ ጊንፆ ሙኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፒልጶሴያ ዒንዲራሴና ጴፂሮሴናጉዲ ቤቴሳይዳ ጌይንታ ካታሜሎይዳ ናንጋ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፒልጶሴ ናቲናዔኤሌ ጎዖሢ ዴንቃዖ፦ «ሙሴ ዔርዜ ዎጎ ማፃኣፖይዳ ሓሣ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፖይዳ ዒዛ ዛሎ'' ፃኣፒንቴሢ፥ ዮሴፔ ናዓሢ፥ ናዚሬቶ ዓጮ'' ዓሢ ዬሱሴ ኑ ዴንቄኔ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናቲናዔኤሌ ጋዓንቴ ማሃዖ፦ «ናዚሬቴ ዓጮ''ይዳፓ ኮሺ ባኣዚ'' ጴዻኒ ዳንዳዓያዳ?» ጋዓዛ፥ ፒልጶሴ፦ «ሂንዳ ሙኪ ዛጌ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ዬሱሴ ናቲናዔኤሌ ዒዛ ባንሢ ሙካንቴ ዛጋዖ፦ «ሃይሾ ፑርቱሞባኣ፥ ጎኔ ዒስራዔኤሌ ዓሲ!» ጌዒ ዒዛ ዛሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናቲናዔኤሌ፦ «ኔ ታና ዎዲ'' ዔሬይ?» ጋዓዛ፥ ዬሱሴ ማሃዖ፦ «ፒልጶሴ ኔና ዔኤላ''ንዳሢኮ ቤርታ ቤሌሶ ሚፄሎ ዴማ'' ዴዒ ዓኣንቴ ታ ኔና ዴንቄኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ዬማና ናቲናዔኤሌ፦ «ዔርዛሢዮ! ኔኤኒ ፆኦሲ ናይኬ! ሓሣ ኔኤኒ ዒስራዔኤሌ ዓሶኮ ካኣቲኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ዬሱሴ ዒዛም፦ «ኔኤኒ ጎኔኬ ጌዔሢ ‹ቤሌሶ ሚፄሎ ዴማ'' ታ ኔና ዛጌኔ› ታ ኔኤም ጌዔሢሮዳ? ዬያፓ ባሼ ባኣዚ'' ኔ ሃጊ ዛጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ጎኔ ታ ዒንሢም ጋዓኔ፦ ጫሪንቺ ቡሊ''ንቲ ፆኦሲኮ ኪኢታንቻ ዓሲኮ ናዓሢ ዑፃ ኬዲ'' ኬስካንቴ ዒንሢ ዛጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ዬካፓ ሓይሣሳ ኬሎ''ና ጌሊላ ዓጮ''ይዳ ዓኣ ቃና ጌይንታ ካታሜሎይዳ ዔፒ ዓኣንቴ፥ ዬሱሴኮ ዒንዳኣ ዒኢካ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ዬሱሴና ዒዛኮ ጊንፆ ሓንታዞንሢና ዔፖ ቤዞ ዔኤሊ''ንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ዔፖ ቤዞይዳ ዎይኖ ዑዣ ጋፓዛ ዬሱሴኮ ዒንዳ ዒዛ ኮራ፦ «ዑዣ ዔያቶኮ ጋፔያታንቴቱዋይ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ዬሱሴያ ማሃዖ ዒንዶ ኮራ፦ «ዬያ ኔኤና ታኣና ማዻንዳ ባኣዚ''ቱዋሴ፤ ታኣኮ ዎዳ'' ሃጊ ሄሊ''ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ዒማ''ና ዒዛኮ ዒንዳ ዒኢካ ዓኣ፥ ማዻ ዓሶም፦ «ዒዚ ዒንሢም ጌዔ ባኮ ቢያ ማዹዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ዓይሁዶ ዓሶኮ ዑፆ ጌኤሺፆ ካኣዦም ማዓ ዋኣፆ ዓርቃ፥ ላሆ'' ሹቺዳፓ ኮሺ''ንቴ ኮሎሢ ዖቲ ዒኢካ ዓኣኔ፤ ፔቴ'' ፔቴ'' ኮሎፆ ዖታ ላምዖና ሓይሦና ማዓ፥ ፑኡፒ ዖቲ ኩማ'' ዋኣሢ ዓርቃኒ ዳንዳዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ዬሱሴ ማዻዞንሢም፦ «ዬንሢ ኮሎፆንሢ ዋኣሢ ኩንሡዋቴ» ጋዓዛ፥ ዔያታኣ ኩንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ዬካፓ ዬሱሴ ማዻዞንሢም፦ «ዓካሪ ዱይ ሙዖ ጊኢጊሻ ዓሶ ሱኡጋሢም ዒንጉዋቴ» ጋዓዛ፥ ዔያታኣ ዔኪ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ሙዖ ጊኢጊሻ ዓሶኮ ሱኡጋሢ ጫርዦ ዑዦ ማዔ ዋኣፆ ዑኡቂ ዛጋዖ ዓንካፓ ዔያታ ዔኬቴያ ዔሪባኣሴ፤ ዋኣፆ ዱዔ፥ ማዻ ዓሳ ጋዓንቴ ዔዔራኔ። ዬያሮ ሙዖ ጊኢጊሻ ዓሶ ሱኡጋሢ' ዑኡታሢ ዔኤላ''ዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«ዓሲ ቢያ ቤርታዺ ዒንጋሢ ጫርሺ ዑሺኬ፤ ዔኤሊ''ንቴ ዓሳ ማሢንቴሢኮ ጊንፃ ባስኪ ዑሺ ዒንጋኔ፤ ኔኤኒ ጋዓንቴ ኮዦ፥ ጫርዦ ዑዦ ዑሼ ጎይሣ ሃይማ ሄሊ''ሴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ዬሱሴ ዬኖ ፆኦሲ ዎልቄና ማዺንቴ ዓኮ ባኮ ቤርታሲ ጌሊላ ዓጮ''ይዳ ቃና ጌይንታ ካታማ ማዼኔ፤ ዬያይዲፆና ፔኤኮ ቦንቾ ፔጋሲ ዔርዜሢሮ ዒዛኮ ጊንፆ ሃንታዞንሢያ ዒዛ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ዬካፓ ዬሱሴ ፔኤኮ ዒንዶና ጌርሲንሢና ሓሣ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ቂፒርናሆሜ ዓጮ'' ኬዲ''፥ ዒኢካ ዻካ'' ኬሊ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ዒማ''ና ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬላ'' ዑኬሢሮ ዬሱሴ ዬሩሳላሜ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ዒዚ ጌኤዦ ማኣሮይዳ፡ ጌማቶንታ ማራቶንታ ዶኦሎ''ንታ ሻንቻ ዓሳ ሓሣ ሚኢሾ ላኣማዞንሢያ ሚኢሼ ላኣማንቴ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ዬያሮ ሱሲ ዢራፓ ማዣዖ ዓሶ ቢያ ማራቶንታ ጌማቶንታ ዎላ'' ጌኤዦ ማኣራፓ ኬሴ''ኔ፤ ሚኢሾ ላኣማ ዓሶኮዋ ሚኢሾ ላኣሌኔ፤ ዔያታ ሚኢሾ ጌሣ፥ ዼ'ጌ ሎኦዦ ዖይቶዋ ሂዒ ዶይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ዶኦሎ'' ሻንቻ ዓሶዋ፦ «ሓያ ቢያ ሴካ ዔኪ ዓኣዹዋቴ፤ ታ ዓዶኮ ማኣሮ ኮርሞ ማኣሪ ማሂፖቴ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ዒማ''ና ዒዛኮ ጊንፆ ሃንታዞንሢ፦ «ኔ ማኣሮ ዛሎ'' ባካ ታሚጉዲ ታና ሚቻኔ» ጌይንቲ ፃኣፒንቴሢ ጶቂሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ዬካፓ ዓይሁዶ ዓሶ ዎይሣ ዓሳ፦ «ኔኤኒ ሓያ ማዻንዳ ቢታንቶ ኔኤኮ ዓኣያታሢ ዔርዛኒ ዓይጎ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዺ ኔ ኑና ዻዋንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ዬሱሴ፦ «ሓያ ጌኤዦ ማኣሮ ሻሁዋቴ፤ ታኣኒ ሓይሦ ኬሊ''ዳ ጊንሣ ማሂ ማዣንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ዔያታ ማሃዖ፦ «ሓያ ጌኤዦ ማኣሮ ማዣኒ ዖይዲታሚ'' ላሆ'' ሌዔ ጋፒሴኔ፤ ሂዳዖ ኔኤኒ ሓይሦ ኬሊ''ዳ ማዣንዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ዬሱሴ ጋዓንቴ፦ «ጌኤዦ ማኣሮ» ጌዒ ኬኤዜሢ ፔኤኮ ዑፆ ዛሎ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ዬሱሴ ሓይባ''ፓ ዔቄሢኮ ጊንፃ ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬያ ጶቂሤኔ፤ ዬያ ዛሎ''ና ማፃኣፓ ፃኣፒንቴ ባኮና ዬሱሴ ኬኤዜ ቃኣሎ'' ዔያታ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ዬሱሴ ዓይሁዶኮ ዑሣ ዓኣዺፆ ቦንቾና ዬሩሳላሜይዳ ዓኣዖ ማዼ፥ ፆኦሲ ዎልቆና ማዺንቴ ዓኮ ባኮ ዔያታ ዛጌሢሮ ሚርጌ ዓሲ ዒዛ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ዬሱሴ ጋዓንቴ ዓሶ ቢያ ዔራያ ማዔሢሮ ዔያቶ ዒ ጉሙርቂባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ዒዚ ዓሲ ዒና ጋርካ ዓኣ ባኣዚ'' ቢያ ዔራሢሮ ዓሲ ዛላ ዒዛም ዖኦኒያ ኬኤዛኒ ኮይሱዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ኒቆዲሞሴ ጌይንታ ፔቴ'' ዓሲ ዓኣኔ፤ ዒዚ ፔርሴ ዓሶ ዛላ''ፓ ማዔያታዖ ዓይሁዶ ዓሶኮ ሱኡጌኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ዬይ ዓሢ ዹሚና ዬሱሴ ኮራ ሙካዖ፦ «ዔርዛሢዮ! ፆኦሲ ዒዛና ዎላ'' ማዔሢዳፓዓቴም ሓያ ኔኤኒ ማዻ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮ ማዻኒ ዳንዳዓይ ዖኦኒያ ባኣሴ፤ ዬያሮ ኔኤኒ ፆኦሲ ኮራፓ ሙኬ፥ ዔርዛያ ማዔሢ ኑኡኒ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ዬሱሴያ፦ «ጎኔ ታ ኔኤም ጋዓኔ፡ ዓሲ ላሚ ሎፓ ሾይንቲባኣዖ ፆኦሲ ካኣቱሞ ዛጋኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ኒቆዲሞሴ ማሃዖ፦ «ሂዳዖ ዓሲ ጋርቼስካፓ ጊንሣ ዎይቲ ሾይንታኒ ዳንዳዓይ? ላሚ ዒንዶ ጎጶ ጌሊ ሾይንታኒ ዳንዳዓ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ዬሱሴ ማሃዖ፦ «ጎኔ ታ ኔኤም ጋዓኔ፡ ዓሲ ዋኣሢና ዓያና ጌኤሺናይዳፓ ሾይንቲባኣዖ ፆኦሲ ካኣቱሞይዳ ጌላኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ዓሲዳፓ ሾይንቴሢ ዓሲኬ፤ ዓያናይዳፓ ሾይንቴሢ ዓያናኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ዬያሮ ‹ላሚ ሾይንታንዳያ ዒንሢም ኮይሳኔ› ታ ኔኤም ጌዔሢሮ ዲቃቲ ሄርሺፖ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ዢባሬ ኮዔ ዛላ ዢባርሻኔ፤ ዑኡዞ ኔ ዋይዛኔ፤ ጋዓንቴ ዓንካፓ ሙካቴ ሃሣ ዓንኮ ዓኣዻቴያ ኔ ዔሩዋሴ፤ ዓያናፓ ሾይንታሢ ቢያ ዬያጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ኒቆዲሞሴ፦ «ዬይ ዎይቲ ማዓኒ ዳንዳዓይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ዬሱሴ ዒዛም፦ «ኔኤኒ ዒስራዔኤሌ ዓሶ ዔርዛሢ ማዓዖ ዬያ ኔ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ጎኔ ታ ኔኤም ጋዓኔ፡ ኑ ዔራ ባኮ ኬኤዛኔ፤ ኑ ዛጌ ባኮዋ ኑ ማርካዻኔ፤ ዒንሢ ጋዓንቴ ኑኡኮ ማርካዺፆ ዔኩዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ሳዓ ዓኣ ባኣዚ'' ታ ዒንሢም ኬኤዛኣና ዒንሢ ጉሙርቁዋያ ማዔቴ ጫሪንቺ ባኣዚ'' ታ ዒንሢም ኬኤዜም ዎይቲ ዒንሢ ጉሙርቃንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ጫሪንጫፓ ኬዴ'' ዓሲ ናዓሢዳፓ ዓታዛ ሌካ ጫሪንጮ ኬስኬይ ዖኦኒያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«ዓሲ ናንጉዋ ዳውሎ''ይዳ ሙሴ ሾኦዦ ሚፆና ዼ'ጊዲ ዓርቄሢጉዲ ዓሲኮ ናዓሢ ሱፂንታንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ዓይጎሮ ጌዔቴ ዒዛ ጉሙርቂ ጎናሲ ዔኬዞንሢ ቢያ ናንጊና ናንጊ ዴንቃንዳጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ሓሣ ዬሱሴ፦ «ፆኦሲ ዓጮ'' ሚርጌ ናሽኬሢሮ ፔኤኮ ፔቴ'' ናዓሢ ዒንጌኔ፤ ዬያሮ ዒዛኮ ናዓሢ ጉሙርቃሢ ቢያ ናንጊና ናንጋያ ማዓንዳኣፓዓቴም ባይቃዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ፆኦሲ ፔኤኮ ናዖ ዓጮ'' ባንሢ ዳኬሢ' ዓጫ'' ዒዛ ናዖና ዻቃንዳጉዲ ማዓንዳፓዓቴም ዓጮ'' ዒ ፑርታና ዎጋንዳጉዲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«ዒዛ ጉሙርቂ ጎናሲ ዔኬይ ፑርታና ዎጊንታዓኬ፤ ዒዛ ጉሙርቂ ዔኩዋኣሢ ጋዓንቴ ፆኦሲ ናዓሢ ጉሙርቂ ዔኪባኣሢሮ ሓሢ ዓኣንቴ ፑርታና ዎጊንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ፖዒ ዓጮ'' ሙኬኔ፤ ዓሳ ጋዓንቴ ዔያቶኮ ማዻ'' ፑርታ ማዔሢሮ ፖዒዳፓ ባሼ ዹሚ ናሽኬኔ፤ ዎጊንቴ ፑርቶ ዎጋኣ ዬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ፑርታ ባኣዚ'' ማዻሢ ቢያ ፖዒ ዒፃኔ፤ ፔኤኮ ፑርቶ ማዻ'' ዔርቱዋጉዲ ፖዖ ባንሢ ሙካኒ ኮውዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ጎኔ ማዔ ባኣዚ'' ማዻሢ ጋዓንቴ ሃንጋ ፖዒ ባንሢ ሙካኔ፤ ሃንጋ ፖዖ ባንሢ ዒ ሙካሢ ፆኦሲ ዓይሢፆ ጎይፆ ማዺንቴ ዒዛኮ ማዻ ዔርታንዳጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ዬካፓ ዬሱሴ ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ና ዎላ'' ዪሁዳ ዓጮ'' ዓኣዺ ዒኢካ ዔያታ ዋኣፆና ዓሶ ማስኪ ማስኪ ዻካ'' ኬሊ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ሳላሜ ጌይንታ ዓጮ'' ኮይሎ''ይዳ ሄኖኔ ጎዖ ቤዛ ሜርጌ ዋኣሢ ዓኣሢሮ ዮሓኒሴ ዋኣፆና ዓሶ ማስካኔ፤ ዓሳኣ ዒዛ ባንሢ ዓኣዺ ዓኣዺ ዋኣፆና ማስታኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ዬማና ዮሓኒሴ ሓጊ ቱኡዞ ማኣራ ቱኡቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ዒዛኮ ጊንፆ ሃንታዞንሢና ፔቴ'' ዓይሁዴ ዓሲስኬያና ባኣካ'' ዑፆ ጌኤሺፆ ካኣዦ ዛሎ'' ማርማ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ዮሓኒሴኮ ጊንፆ ሃንታዞንሢ ዮሓኒሴ ኮራ ሙካዖ፦ «ዔርዛሢዮ! ዬይ ዮርዳኖሴ ዎሮ ሱኮይዳ ኔኤና ዎላ'' ዓኣሢ፥ ኔኤኒ ዒዛ ዛሎ'' ማርካዼሢ፥ ሓይሾ ዒዚያ ዋኣሢና ማስካኔ፤ ዓሳ ቢያ ሴካ ዒዛ ባንሢ ዓኣዻኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዮሓኒሴ ማሃዖ፦ «ዓይጎ ዓሲታቶዋ ፆኦሲ ዒዛም ዒንጊባኣታቴ ዓይጎ ባኣዚ''ያ ዒዛኮ ዓኣያ ማዓኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹ዒዛኮ ቤርታ ታ ዳኪንቴያፓዓቴም ታኣኒ ሜሲሔቱዋሴ› ጌዒ ታ ዒንሢም ኬኤዜሢኮ ዒ'ንሢ ዒንሢ ቶኦኪና ታኣኮ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ዑኡቴላ ዑኡታሢሮኬ፤ ዑኡታሢኮ ዔርጎና ዓሢ ጋዓንቴ ዑኡታሢኮ ዓጫ ዔቂ፥ ዑኡታሢ ዑኡዞ ዋይዛኣና ዎዛዻኔ፤ ዬያጉዲ ታኣኮዋ ዎዛ'' ሃሢ ጎኔ ዎዛ'' ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ዒዚ ዼ'ጊ ዼ'ግ ጌዔም፥ ታኣኒ ሂርኪ ሂርኪ ጋዓንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ዮሓኒሴ ሓሣ፦ «ዑፃፓ ሙካሢ ቢያኮ ዑሣኬ፤ ሳዓፓ ማዔሢ ሳዓ ዓሲኬ፤ ሳዓ ባኣዚ'' ዒ ኬኤዛኔ፤ ጫሪንጫፓ ሙካሢ ቢያኮ ዑፃኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ዒዚ ዛጌሢና ዋይዜሢ ማርካዻኔ፤ ጋዓንቴ ዒዛኮ ማርካዺፆ ዔካይ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ዒዛኮ ማርካዺፆ ዔካሢ ጋዓንቴ ፆኦሲ ጎኔ ማዔሢ ጌኤሺ'' ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ፆኦሲ ዳኬሢ' ፆኦሲ ቃኣላ ኬኤዛኔ፤ ፆኦሲያ ፔኤኮ ዓያኖ ሚርጌና ዒዛም ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ዓዴ፡ ፔኤኮ ናዓሢ ናሽካኔ፤ ቢያ ባኮ ዒዛ ኩጫ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ናዓሢ ጉሙርቂ ዔካሢኮ ናንጊና ናንጊ ዓኣኔ፤ ናዓሢ ጉሙርቂ ዔኩዋኣሢ ጋዓንቴ ፆኦሲ ዒንጋ ሜቶ''ይዳ ናንጋንዳኣፓዓቴም ኮሺ ናንጊ ዴንቃዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ዬኖ ዎዶ''ና ዬሱሴ ዮሓኒሴይዳፓ ባሼ ሚርጌ ዓሶ ፔና ዔርዚ፥ ፔ ዓሲ ማሃሢና ዋኣፆና ማስካሢያ ፔርሴ ዓሳ ዋይዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ጋዓንቴ ዋኣፆና ዓሶ ማስካሢ ዒዛኮ ጊንፆ ሃንታዞንሢ ማዓንዳፓዓቴም ዒዚ ፔኤሮ ዋኣፆና ማስኩዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ዒዛ ዛሎ'' ጌይንቴ ባኮ ፔርሴ ዓሳ ዋይዜሢ ዒ ዔራዖ ዪሁዳ ዓጮ'' ሃሺ'' ጌሊላ ማዒ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ዒኢካ ዒ ዓኣዻዖ ሳማሪያ ዓጮ'' ጊዴና ዓኣዻንዳያ ዒዛ ኮይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ዬያሮ ሲካሬ ጌይንታ ሳማሪያይዳ ዓኣ ካታሜሎ ዒ ሙኬኔ፤ ሲካሬ ያይቆኦቤ ፔኤኮ ናኣዚ'' ዮሴፔም ዒንጌ ቤዞኮ ኮይሎ''ይዳ ዓኣያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ዒኢካ ያይቆኦቤኮ ቦኦኮና ዔቴ ዋኣሢ ዓኣንቴ ዬሱሴ ጎይፆ ሓንቲ ላቤ''ሢሮ ዬኖ ዔቶ'' ዋኣፄሎ ዓጫ ዴዔኔ፤ ዬማና ዓባ'' ሳዛ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ዒማ''ና ፔቴ'' ሳማሪያ ዓጪ ላኣሊስኬና ዋኣፆ ዱዓኒ ዔቶ'' ባንሢ ሙካዛ ዬሱሴ፦ «ዔና፥ ዋኣሢ ታና ዑሼቴራ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ዬማና ዒዛኮ ጊንፆ ሓንታዞንሢ ሙኡዚ'' ሻንቃኒ ካታሞ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ዬና ሳማሪያ ዓጮ'' ላኣሌላ ዬሱሴ ኮራ፦ «ኔኤኒ ዓይሁዴ ዓሲታዖ ዎዲ'' ታና ሳማሪያ ዓጮ'' ላኣሌሎ ‹ዋኣሢ ታና ዑሼ!› ጌይ ዖኦጫይ?» ጌዔኔ። ዬያ ዒዛ ጌዔሢ ዓይሁዶ ዓሶና ሳማሪያ ዓጮ'' ዓሶናኮ ዎላ'' ፔቱሞ ባኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ዬሱሴ፦ «ፆኦሲ ዒንጋ ባኮና ‹ዋኣፆ ታና ዑሼ› ኔና ጋዓሢኮ ዖኑሞ ኔ ዔሬያ ማዔቴ ዒዛ ሺኢቃኒ ኔና ኮይሳንቴኬ፤ ዒዚያ ኔኤም ናንጊ ዋኣሢ ዒንጋንዳያታንቴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ዒዛ ማሃዖ፦ «ጎዳሢዮ! ኔኤኮ ዋኣሢ ዱዖ ባኣዚ'' ባኣሴ፤ ዋኣፆ ዔታኣ ኮሺ'' ዔታዻያኬ፤ ሂዳዖ ናንጎ ዋኣፆ ዓንካፓ ኔ ዴንቃንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ኔኤኒ ሓያ ኑም ዋኣፆ ዔቶ'' ዒንጌ፥ ኑ ዓዳሢ፥ ያይቆኦቤይዳፓ ባሼዳ? ዒዛና ዒዛኮ ናኣቶ''ና ዒዛኮ ቆልማኣ ሃኖ ዋኣፆ ዔታፓ ዑሽኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ዬሱሴ ዒዞም ማሃዖ፦ «ሓኖ ዋኣፆይዳፓ ዑሽካሢ ቢያ ላሚ ዋኣሢ ዼኤባንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ታኣኒ ዒንጋ ዋኣፆይዳፓ ዑሽካሢ ናንጊና ፔቴ''ታዖ ዼኤቢንታዓኬ፤ ዓይጎሮ ጌዔቴ ታ ዒንጋ ዋኣፆ ዑሽካ ዓሢዳፓ ናንጊና ናንጊ ዋኣሢ ዓልቃያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ላኣሌላ፦ «ጎዳሢዮ! ሓይፓ ሴካ ዋኣሢ ታና ዼኤቡዋጉዲና ሓይካኣ ታ ዱዓኒ ሙኩዋጉዲ ሓዳራ ታኣም ዬኖጉዴ ዋኣፄሎ ዒንጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ዬሱሴያ፦ «ዴንዲ ኔኤኮ ዓኒ ዔኤሊ'' ዔኪ ሙኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ላኣሌላ፦ «ዓኒ ታኣኮ ባኣሴ» ጌይ ማሄኔ፤ ዬሱሴ ጊንሣ ዒዞም፦ «ዓኒ ታኣኮ ባኣሴ ጌይፃ ኔኤኮ ጎኔኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ያዺ ማዔቴያ ኔኤኮ ዶንጎ ዓኒንሢ ዓኣኔ፤ ሓሢ ኔኤና ዎላ'' ዓኣሢ ኔኤኮ ዓኒቱዋሴ፤ ዬያሮ ኔኤኒ ጎኔ ጌስቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ላኣሌላ ዒዛም፦ «ጎዳሢዮ! ኔኤኒ ፆኦሲ ማሊሢ ኬኤዛያታሢ ሓሢ ታ ኔና ዔሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ኑ ዓዶንሢ ሓያ ዹካ''ሢ ዑፃ ካኣሽካኔ፤ ዒንሢ ጋዓንቴ ‹ዓሲ ዚጊ ካኣሽካኒ ኮይሳሢ ዬሩሳላሜይዳኬ› ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ዬሱሴ ሃሣ ዒዞም፦ «ኔ ሓና ላኣሌላ ፆኦሲ ዓዳሢም ሓያ ዹኮ'' ዑፆይዳ፤ ሃሣ ዬሩሳላሜይዳ ዚጊ ካኣሽኪሢ ዛላ ዒንሢ ሜታዺንዱዋ ዎዴ ሙካንዳሢ ዔሪ ታና ጉሙርቄ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ዒንሢ ሳማሪያ ዓሳ ዒንሢሮ ዒንሢ ዔሩዋ ፆኦሲ ዚጊ ካኣሽካኔ፤ ኑኡኒ ጋዓንቴ ዻቂንታ ዓይሁዴይዳፓ ማዔሢሮ ኑ ዔራ ፆኦዛሢ ዚጊ ካኣሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ጋዓንቴ ጎኔና ዚጊ ካኣሽካዞንሢ፦ ፆኦሲ ዓዳሢም ዓያና ጌኤሺና ሓሣ ጎኑሞና ዚጊ ካኣሽካንዳ ዎዴ ሙካንዳኔ፤ ዬይ ሓሢ ሙኪናኣኮኬ፤ ፆኦሲ፥ ዓዳሢያ ኮዓሢ ዬያጉዴ ዚጊ ካኣሽኪፆኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ፆኦሲ ዓያናኬ፤ ጎኑሞና ዒዛም ዚጊ ካኣሽካዞንሢያ ዓያናና ዚጊ ዒዛ ካኣሽካንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ላኣሌላኣ፦ «ዓያና ጌኤሺ ካኣቱሞም ዓርቄ፥ ሜሲሔ ሙካንዳሢ ታ ዔራኔ፤ ዒዚ ሙካዖ ቢያ ባኣዚ'' ኑም ኬኤዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ዬሱሴ ዒማ''ና፦ «ሓሢ ሓይ ኔኤና ጌስታሢ፥ ታ ዒዛኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ዬማና ዒዛኮ ጊንፆ ሃንታዞንሢ ዴንዴ ቤዛፓ ማዒ ሙካንቴ ዬሱሴ ላኣሊና ዎላ'' ጌስታሢሮ ዲቃቲ ሄርሼኔ፤ ማዔቶዋ፦ «ኔኤኒ ዔናኣሬ፥ ዓይጎ ኮዓይ? ሓሣ ዒዞና ዎላ'' ኔ ዓይጋ ጌስታይ?» ጌዒ ዖኦጬ ዓሲ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ዬካፓ ላኣሌላ ዋኣፆ ዱዓኒ ዔኪ ሙኬ ጉዞ ሓሺ''፥ ካታሞ ዴንዲ ዓሶም፦ ");
INSERT INTO mdybse_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ታ ማዼ ባኮ ቢያ ታኣም ኬኤዜ ዓሲስኬያ ሃኒ ሙኪ ዛጉዋቴ! ጎዖንቴ ዒዚ ሜሲሔ ማዓንዳሞ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ዬያሮ ዓሳ ካታማ''ፓ ኬስኪ ዬሱሴ ዓኣ ቤዞ ባንሢ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ዒማ''ና ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ካሦ ሙዔ» ጌይ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ዒዚ ጋዓንቴ፦ «ዒንሢ ዔሩዋያ፥ ታኣኒ ሙዓ ሙኡዚ'' ታኣኮ ዓኣኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ዬያሮ ዒዛኮ ጊንፆ ሓንታዞንሢ፦ «ዓሲ ዒዛም ሙኡዚ'' ዔኪ ሙኬያናንዳሞ?» ዎሊ ኮይላ'' ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ዬሱሴ ዔያቶም፦ «ታኣኮ ሙዓ ታና ዳኬሢኮ ዓይሢፆ ኩንሥሢና ማዾ''ዋ ማዺሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ዒንሢ፦ ‹ሓጊ ዖይዶ ዓጊኒ ዓቴ''ኔ፤ ዬካፓ ማኣሊ'' ቡሪንታንዳኔ› ጋዓያቱዋይ? ታ ሓሢ ዒንሢም ‹ሂንዳ ዼ'ግ ጌይጋፓ ማኣላ'' ሃሢ ቡሪሢም ሄሌ''ሢ ዛጉዋቴ› ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ማኣሎ'' ቡራሢ ዒ ማኣሎ'' ቡሬሢ ዛሎ'' ዔካንዳኔ፤ ናንጊና ናንጊም ማዓ ዓኣፒያ ቡኩሳንዳኔ፤ ዬያሮ ዜርቃሢያ፥ ማኣሎ'' ቡራሢያ ዎላ'' ዎዛዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ዬያ ጎይፆና ‹ፔቴ''ይ ዜርቃኔ፥ ሜሌ''ሢ ሃሣ ማኣሎ'' ቡራኔ› ጌይንቴ ማላታ ጎኔኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ዒንሢ ላቢ''ባኣ ማኣሊ'' ቡራንዳጉዲ ታ ዒንሢ ዳኬኔ፤ ሜሌ'' ዓሳ ማዾ''ና ላቤ''ኔ፤ ዒንሢ ጋዓንቴ ዔያቶኮ ላቢ''ፆ ዓኣፖ ቡኩሲ ዔኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ላኣሌላ፦ «ታ ማዼ ባኮ ቢያ ታኣም ኬኤዜኔ» ጌዒ ዒዛ ማርካዼሢሮ ዬኖ ካታሜሎይዳ ሚርጌ ሳማሪያ ዓጪ ዓሲ ዬሱሴ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ዬያሮ ሳማሪያ ዓጮ'' ዓሳ ዒዛ ኮራ ሙካዖ ዔያቶና ዎላ'' ዒ ዴዓንዳጉዲ ዒዛ ሺኢቃዛ፥ ዒዚያ ላምዖ ኬሊ'' ዒኢካ ፔኤቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ዒ ኬኤዛ ቃኣሎ'' ዛሎ''ና ሜሌ'' ሚርጌ ዓሲ ዒዛ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ዓሳ ላኣሌሎም፦ «ዓካሪ ኑኡኒ ዒዛ ጉሙርቄሢ ኔኤኒ ኑም ኬኤዜ ቃኣሎ''ና ሌሊቱዋንቴ ኑ ኑ ቶኦኪና ዋይዜሢሮና ጎኔና ዒዚ ዓጮ'' ዻቂሻያ ማዔሢ ኑ ዔሬሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ዬሱሴ ሳማሪያይዳ ላምዖ ኬሊ'' ፔኤቄስካፓ ጌሊላ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ዒዚ ፔ ቶኦኪና፦ «ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ፔ ዓጮ''ይዳ ቦንቺንቱዋሴ» ጌይ ቤርታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ጋዓንቴ ጌሊላ ዓጮ'' ዒ ዴንዳዛ ጌሊላ ዓሳ ኮሺና ዒዛ ሾኦቺንሢ ዔኬኔ፤ ዓይጎሮ ጌዔቴ ዓይሁዶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ና ዬሩሳላሜ ዴንዲ ዒዚ ዒኢካ ማዼ ባኮ ቢያ ዔያታ ዛጌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ዬካፓ ዬሱሴ ዋኣፆ ጫርሺ ዑሺ ማሄ ቤዞ፥ ጌሊላ ዓጮ''ይዳ ዓኣ፥ ቃና ካታሜሎ ላሚ ዴንዴኔ፤ ዒማ''ና ቂፒርናሆሜይዳ ፔቴ'' ናይ ሃርጊንቴ፥ ካኣቲ ማኣራ ፑኡፒ ማዒ ማዻ ዓሲስኬይ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ዒዚያ ዬሱሴ ዪሁዳ ዓጫ''ፓ ጌሊላ ሙኬሢ ዋይዛዖ ዬሱሴ ባንሢ ቂፒርናሆሜ ሙኪ ኮሺ'' ሓርጊንቲ ሃይቃኒ ዑኬ ዒዛኮ ናይስኬያ ፓሣንዳጉዲ ዬሱሴ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ዬሱሴያ፦ «ዒንሢ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮና ማላታና ዛጊባኣታቶ ፔቴ''ታዖ ጉሙርቁዋያቲ!» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ዬይ ፑኡፖ ዓሣሢ፦ «ጎዳሢዮ! ታኣኮ ናዓሢ ሓይቁዋንቴ ሃዳራ ዑኬና ሄሌ''» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ዬሱሴ ዒዛም፦ «ኔ ማኣሪ ዴንዴ፤ ናዓ ኔኤኮ ፖዔኔ» ጋዓዛ፥ ዓሢ ዬሱሴ ኬኤዜ ቃኣሎ'' ጉሙርቂ ማኣሪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ዒ ማኣሪ ዴንዳንቴ ዒዛኮ ማዻ ዓሳ ጎይፃ ዒዛና ካኣማዖ፦ «ናዓ ኔኤኮ ፖዔኔ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ዒዚያ ናማ ኮሺ ማዔ ዎዶ'' ዖኦጫዛ፥ ዔያታ፦ «ዚጊኖ ዓባ'' ሳዛፓ ሺራኣና ቆሣ ሺሜኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ዓዳሢያ፦ «ናዓ ኔኤኮ ፖዔኔ» ዬሱሴ ጌዔሢ ዒማ'' ዎዶ'' ማዔሢ ዔሬኔ፤ ዬያሮ ዬኖ ኬሎ''ይዳፓ ዓርቃዖ ዒዛንታ ዒዛኮ ማኣሮ ዓሳኣ ቢያ ዬሱሴ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ዬይ ፆኦሲ ዎልቄና ማዺንቴ ዓኮ ባካ ዬሱሴ ዪሁዳይዳፓ ጌሊላ ሙካዖ ማዼ ላምዓሳ ዓኮ ባኮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ዬካፓ ዓይሁዶኮ ቦንቾ ኬሎ'' ማዔሢሮ ዬሱሴ ዬሩሳላሜ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ዬሩሳላሜይዳ ማራታ ጌላ ካሮ'' ዓጫ፥ ዔብሬ ዓሶ ሙኡቺና ቤኤቴ ዛኣታ ጌይንታ ፔቴ'' ዴዔ ዋኣሢ ዓኣንቴ ዒዞ ቤዛ ዶንጎ ጎይሢ ዎላ'' ካኣማኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ሚርጌ ሃርጊንቴ ዓሲ፥ ዓኣፒ ባይቄ ዓሲ፥ ዎቦ ዓሲ ሓሣ ሃንታኒ ዳንዳዑዋ ዎቦ ዓሲ ዬንሢ ጎይፆንሢ ካኣማ ካራ'' ላሂ፥ ዋኣፃ ዓጊፃንዳያ ሄላ''ንዳኣና ካፓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ፔቴ'' ፔቴ''ና ጎዳኮ ኪኢታንቻሢ ዴዔ ዋኣፄሎ ኬዲ'' ዓጊሣኔ፤ ዋኣፃ ዓጊፃኣና ቤርታዺ ዋኣፆይዳ ጌላሢ ፔኤኮ ዓኣ፥ ዓይጎ ዶርዖይዳፓ ቢያ ፖፖዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ዒኢካ ሃይሢታሚ'' ሳሊ'' ሌዔ ጉቤ ሓርጊንቴ፥ ፔቴ'' ዓሲስኬይ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ዬሱሴ ዬይ ዓሢ ዒኢካ ላሂ ዓኣንቴ ዛጋዖ፥ ሚርጌ ዎዴይዳፓ ዓርቂ ሃርጊንቴያታሢ ዔሪ፦ «ፖዓኒ ኔ ኮዓ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ሓርጊንቴ ዓሢ፦ «ጎዳሢዮ! ዋኣፃ ዓጊፃኣና ታና ዔኪ ዋኣፄሎይዳ ጌልዛ ዓሲ ባኣሴ፤ ታኣኒ ጌላንዳኔ ጋዓኣና ሜሌ''ሢ ታና ቢሪ ኬዳ''ኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ዬሱሴያ፦ «ዔቂጋፓ ኔና ኬዲ ዔኪ ሙኮና ሃላሢ ኬዲ ዔኪ ዴንዴ» ዒዛም ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ዓሢ ቤዞማና ፖዓዖ ሃላሢ ኬዲ ዴንዴኔ። ዬይ ያዺ ማዔሢ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ናኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ዬያሮ ዓይሁዶ ዓሶ ዎይሣ ዓሳ ዬያ ፖዔ ዓሢ ኮራ፦ «ሃኖ'' ሃውሾ ኬሎ''ታሢሮ ኔኤኮ ሃላሢ ኔ ኬዳንዳጉዲ ዎጋ'' ዓይሡዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ዒዚ ጋዓንቴ፦ «ታና ፖዒሴ ዓሢ ‹ኔኤኮ ሃላሢ ኬዲ ዔኪ ዓኣዼ› ታኣም ጌዔኔ» ጌይ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ዔያታ ማሃዖ፦ «ሃላሢ ኔኤኮ ኬዲ ዓኣዼ ኔና ጌዔሢ ዖናዳይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ዬሱሴ ዬኖ ቤዛፓ ዴሮ'' ባኣኮ'' ዓኣዼሢሮ ዒዛ ፖዒሴሢ ዖና ማዔቴያ ዒ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ዬካፓ ዬሱሴ ዓሢ ጌኤዦ ማኣሮይዳ ዴንቃዖ፦ «ሃይሾ ኔ ፖዔኔ! ሓያይዳፓ ባሼ ባኣዚ'' ኔና ሄሉ''ዋጉዲ ሃካፓ ሴካ ጎሜ ማዺፖ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ዓሢ ዓኣዻዖ ዒዛ ፖዒሴሢ ዬሱሴ ማዔሢ ዓይሁዶኮ ዎይሣ ዓሶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ዬያ ባኮ ሃውሾ ኬሎ''ና ማዼሢሮ ዓይሁዶኮ ዎይሣ ዓሳ ዬሱሴ ዒፂ ኬሚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ዬሱሴ ጋዓንቴ፦ «ታ ዓዴ ቢያ ኬሊ'' ማዻኔ፤ ታኣኒያ ሃሣ ማዻኔ» ጌይ ዔያቶም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ዓካሪ ዓይሁዶኮ ዎይሣ ዓሳ ዒዚ ሃውሾ ኬሎ''ና ማዾ ማዼሢሮ ሌሊቱዋንቴ፦ «ፆኦሲ ታኣኮ ዓዶኬ» ጌይ ፔና ፆኦሲና ዎላ'' ሄኮ ማሄሢሮ ባሼና ዒዛ ዎዻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ዬሱሴ ዔያቶም፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓዴ ማዻንቴ ዛጌሢ ማዺሢዳፓ ዓታዛ ናዓሢ ፔ ቢታንቶና ዓይጎ ባኣዚ''ያ ማዹዋሴ። ዓዴ ማዻ ባኮ ናዓሢያ ዬያጉዲ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ዓዴ ፔኤኮ ናዓሢ ናሽካሢሮ ዒ ማዻ ባኮ ቢያ ዒዛ ዻዋኔ፤ ዒንሢ ሄርሺ ዲቃታንዳጉዲ ሓያይዳፓ ባሼ ማዾዋ ዒዛ ዻዋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ዓዴ፡ ሓይቄዞንሢ ዔቂሳሢና ሼምፖ ዔያቶም ዒንጋሢጉዲ ናዓሢያ ኮዔ ዓሲም ሼምፖ ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ዓዴ ዖ ዑፆይዳኣ ዎጉዋሴ፤ ጋዓንቴ ዎጊፆ ቢታንቶ ቢያ ናዓሢም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ዬያ ዒ ማዼሢ ዓሳ ቢያ ዓዶ ቦንቺ ናዓሢያ ቦንቻንዳጉዲኬ። ናዓሢ ቦንቹዋኣሢ ናዓሢ ዳኬ፥ ዓዶዋ ቦንቻዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ዬሱሴ ሃሣ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ታኣኮ ቃኣሎ'' ዋይዛሢና ታና ዳኬሢያ ጉሙርቃሢኮ ናንጊና ናንጊ ዓኣኔ፤ ዒዚያ ሃይቢይዳፓ ናንጊ ባንሢ ፒንቄያፓዓቴም ናንጊና ሜታዻንዳጉዲ ዎጊንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ጎኔ ታ ዒንሢም ጋዓኔ፤ ሃይቄ ዓሳ ፆኦሲኮ ናዓሢ ዑኡዞ ዋይዛንዳ ዎዴ ሙካንዳኔ፤ ዬና ዎዳ''ኣ ሃሢኬ፤ ዋይዛዞንሢያ ቢያ ሼምፔና ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ዓይጎሮ ጌዔቴ ዓዴ ፔ ቶኦኪና ሼምፖ ዒንጋያ ማዔሢጉዲ ናዓሢያ ሼምፖ ዒንጋያ ማዓንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ናዓሢ ዓሲ ናይ ማዔሢሮዋ ዎጌ ዒ ዎጋንዳጉዲ ቢታንቶ ዒዛም ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ዬያ ባኮ ዲቃቲ ሄርሺፖቴ! ዓይጎሮ ጌዔቴ ሓይቄ ዓሳኣ ቢያ ፆኦሲኮ ዑኡዞ ዋይዛ ዎዴ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ኮሺ ማዼዞንሢ ሓይቦ''ይዳፓ ዔቂ፥ ሼምፔና ናንጋንዳኔ፤ ፑርታ ማዼዞንሢ ጋዓንቴ ሓይቦ''ይዳፓ ዔቂ፥ ሜታዻንዳጉዲ ዎጊንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ዬሱሴ ሃሣ፦ «ታኣኒ ታ ቢታንቶና ዓይጎ ባኣዚ''ያ ማዻኒ ዳንዳዑዋሴ፤ ጋዓንቴ ታ ዓዶይዳፓ ታ ዋይዜሢ ዎጋኔ፤ ታና ዳኬሢኮ ማሊፆ ማዓንዳኣፓዓቴም ታ ማሊፆ ታ ኩንሡዋኣሢሮ ዎጋ'' ታኣኮ ፒዜኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«ታኣኒ ታኣሮ ታ ዛሎ'' ማርካዼቴ፥ ማርካዺፃ ታኣሲ'' ጎኔቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","«ሃሣ ዬሱሴ ታኣም ማርካዻይ ሜሌ'' ዓኣኔ፤ ዒዚ ታ ዛሎ'' ማርካዻ ማርካታ ጎኔ ማዔሢ ታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ዒንሢ ዮሓኒሴ ባንሢ ዓሲ ዳኬያና ዒዚ ጎኔ ማርካዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ሓያ ታ ጋዓሢ ዒንሢ ዻቃንዳጉዲ ማዓንዳኣፓዓቴም ታኣም ዓሲ ማርካዻንዳያ ኮይሳሢሮቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ዮሓኒሴ ዔኤታያ ሃሣ ፖዓ ፖዒ ጉዴያኬ፤ ዒንሢያ ዻካ'' ዎዴሮ ዒዛ ፖዖና ዎዛዻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ታኣኮ ጋዓንቴ ዮሓኒሴ ማርካዼሢዳፓ ባሼ ማርካ ዓኣኔ፤ ታኣኮ ማርካ' ታ ዓዴ ታ ማዻንዳጉዲ ዒንጌ ማዾ''ኬ፤ ዬይ ታ ማዻ ማዻ'' ዓዴ ታና ዳኬያ ማዒፆ ዛሎ'' ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ታና ዳኬ ዓዴ ፔ ቶኦኪና ታ ዛሎ'' ማርካዼኔ፤ ዒንሢ ጋዓንቴ ዒዛኮ ዑኡዞ ፔቴ''ታዖ ዋይዚባኣሴ፤ ሃሣ ዒዛ ዒንሢ ዛጊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ዒዚ ዳኬሢ ዒንሢ ጉሙርቂባኣሢሮ ዒዛኮ ቃኣላ'' ዒንሢኮ ዒና'' ዴዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ዒንሢ፡ ጌኤዦ ማፃኣፖይዳፓ ናንጊና ናንጊ ዴንቃንዳያ ዒንሢም ማላሢሮ ዬያ ማሂ ማሂ ዒንሢ ዛጋኔ፤ ዬያታ ታ ዛሎ'' ማርካዻዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ዬይ ያዺ ማዔቴያ ዒንሢ ሼምፖ ዴንቃኒ ታ ባንሢ ሙካኒ ኮዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ዬሱሴ ሃሣ፦ «ታኣኒ ቦንቾ ዓሲዳፓ ኮዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ጋዓንቴ ዒንሢ ዎዚጉዴ ዓሲታቴያ ታ ዒንሢ ዔራኔ፤ ፆኦሲ ናሹሞዋ ዒንሢኮ ዒና'' ባኣያ ማዔሢ ታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ታኣኒ ታ ዓዶ ሱ'ንፆና ሙኬኔ፤ ዒንሢ ጋዓንቴ ታና ጎኔኬ ጌይ ዔኪባኣሴ፤ ሜሌ'' ፔ ሱ'ንሢና ሙኬቴ ጋዓንቴ ዒንሢ ዬያ ጎኔኬ ጌይ ዔዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ዒንሢ ሴካና ሃንጋና ዎሊ ቦንቻ ዓሳ፥ ፔቴ'' ፆኦዛሢዳፓ ጴዻ ቦንቾ ጋዓንቴ ኮዑዋ ዓሳ፥ ዎዲ'' ታና ዒንሢ ጉሙርቃኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ታ ዒንሢ ታ ዓዶ ቤርታ ዎጎና ዓይሢሳንዳያ ዒንሢም ማሎፓ፤ ዒንሢ ዎጎና ዓይሢሳንዳሢ ዒንሢ ዒዛ ጉሙርቃ ሙሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ሙሴ ዒንሢ ጉሙርቃያ ማዔያታቴ ዒዚ ታ ዛሎ'' ፃኣፔያታሢሮ ታናኣ ዒንሢ ጉሙርቄያናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ዒዚ ፃኣፔሢ ዒንሢ ጉሙርቂባኣቴ ታ ኬኤዛሢ ዒንሢ ዎይቲ ጉሙርቂ ዔካንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ዬካፓ ዬሱሴ ፂብራዶሴ ጌይንታ ጌሊላ ባዞ'' ሱኮ ፒንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ሚርጌ ዓሳ ዬሱሴ ሃርጊንቴ ዓሶ ፖዒሴሢሮና ፆኦሲ ዎልቆና ማዺንታ ዓኮ ባኮ ማዼም ዛጌሢሮ ዒዛ ጊንፆ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ዬሱሴ ሌካ ዹኮ'' ኬስካዖ ዒኢካ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ዒማ''ና ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬላ'' ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ዬሱሴ ሚርጌ ዴሬ ዒዛ ባንሢ ሙካሢ ዼ'ግ ጌይ ዛጋዖ፥ ፒልጶሴ ኮራ፦ «ሓያ ቢያ ዓሶም ጊዳንዳ ሙኡዚ'' ዓንካፓ ኑ ሻንቃንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ዬሱሴ ዬያ ጌዔሢ ፒልጶሴ ዎዚ ጋዓቴያ ዋይዛኒ ማዓንዳኣፓዓቴም ዒ ማዻንዳ ባኮ ፔ ቶኦኪና ዔዔራያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፒልጶሴያ፦ «ፔቴ'' ፔቴ''ሢም ዻካ'' ዻካ'' ቡንፂሢታዖ ዒንጊንታንዳጉዲ ፔቴ'' ዓሲ ላምዖ ፄኤታ ኬሊ'' ማዼም ዒንጊንታንዳ ሚኢሼጉዴያና ካሣ ዔያቶም ሻንቆናቴያ ጊዳዓኬ» ጌይ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ዒዛኮ ጊንፆ ሓንታ ናኣቶ''ይዳፓ ፔቴ''፥ ሲሞኦኔ ጌይንታ ጴፂሮሴኮ ጌርሲ፥ ዒንዲራሴ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«ዶንጎ ዔልዓ ካሣና ላምዖ ሞሎና ዓኣ፥ ፔቴ'' ናይስኬይ ሃካ ዓኣኔ፤ ጋዓንቴ ዬንሢ ሃያ ቢያ ዴሮ''ም ዓይጎ ማዓንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ዬሱሴ፦ «ዓሶ ዴይሡዋቴ» ዔያቶም ጌዔኔ። ዬኖ ቤዛ ቡጬታሢሮ ዓሳ ዴዔኔ፤ ዒኢካ ዓኣ፥ ዓቲንቆ ዓሶኮ ፓይዳ'' ዶንጎ ሺያ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ዬካፓ ዬሱሴ ካሦ ዔካዖ ጋላቲ፥ ዴዔ ዓሶም ዒንጋንዳጉዲ ፔኤኮ ጊንፆ ሃንታ ናኣቶ''ም ዒንጌኔ። ዬያጉዲ ሞላሢያ ሃሣ ዒዞ ጎይፆ ዒንጌም ቢያሢ ኮይሳሢጉዴያ ሙዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ቢያሢ ሙይ ሚሽኬስካፓ ዬሱሴ ጊንፆ ሃንታዞንሢም፦ «ፔቴ''ታዖ ዲኢኒ ዓቱዋጉዲ ዶንቦ ቡኩሱዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ዔያታኣ ዓሳ ሙዒ ሚሽኬ፥ ዶንጎ ካሦ ዶንቦ ቡኩሲ ታጶ ላምዖ ዼኤፒ ሌማቴ ኩንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ዓሳ ዬሱሴ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮ ማዼሢ ዛጋዖ፦ «ጎኔና ሓይ፥ ዓጮ'' ሙካንዳኔ ጌይንቴ፥ ፆኦሲ ማሊፆ ኬኤዛሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ዒማ''ና ዓሳ ዎልቄና ዓርቂ ዒዛ ካኣታሳኒ ማላሢ ዔራዖ ዬሱሴ ዓሶፓ ዱማዺ፥ ፔኤሮ ጌሜሪ ባንሢ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ሳዓ ዓማ''ዛ ዒዛኮ ጊንፆ ሓንታዞንሢ ጌሊላ ባዞ'' ባንሢ ኬዴ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ዬካፓ ዋኣፆና ፒንቆ ጎንጎ ቶጊ፥ ቂፒርናሆሜ ባንሢ ዓኣዺሢ ዓርቄኔ፤ ዬማና ሳዓ ዓሜ''ንቴ ዬሱሴ ሃጊ ዔያቶ ኮራ ሙኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ዒማ''ና ዼኤፒ ጉዶ ዢባሬ ዢባርሻሢሮ ባዞ'' ዋኣፃ ዓጊፃኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ዬሱሴኮ ጊንፆ ሃንታ ናኣታ'' ዶንጎ ሃሣ ላሆ'' ሺያ ታኣኪሢ ማዓንዳያ ዋኣፆ ጊዶ'' ጎንጎ ዔኪ ዓኣዼስካፓ ዬሱሴ ባዞ'' ዑፆይዳ ቶኪና ሃንቲ ሃንቲ ዔያቶ ባንሢ ሙካሢ ዛጋዖ ዔያታ ዲቃቲ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ዒዚ ጋዓንቴ፦ «ታናኬ! ዒጊጪፖቴ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ዔያታ ዎዛዺ፥ ዋኣፆና ፒንቆ ጎንጎ ጋሮ ዒዛ ዔኪ ጌልዛዛ ቤዞማና ዋኣፆና ፒንቆ ጎንጌላ ዔያታ ዓኣዻ ቤዞ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ዚሮ ጉቴ''ሎ ባዞ''ኮ ሶ ሱኮ''ይዳ ዓቴ'' ዓሳ ባዞ''ይዳ ፔቴ'' ዋኣፆና ፒንቆ ጎንጊ ዓኣንቴ ዛጌኔ፤ ዬሱሴኮ ጊንፆ ሃንታ ናኣታ'' ፔኤሮ ዴንዴሢና ዬሱሴ ዔያቶና ዎላ'' ዋኣፆና ፒንቆ ጎንጎ ጋሮ ጌሊባኣሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ጋዓንቴ ሜሌ'' ዋኣሢና ፒንቆ ጎንጊ ፂብራዶሴፓ ዔቂ ዬሱሴ ፆኦሲ ጋላቲ ዴሮ'' ካሦ ሙኡዜ ቤዞ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ዴራ'' ዬሱሴ ማዔቴያ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒኢካ ባኣሢ ዛጋዖ ዬንሢ ዋኣፆና ፒንቆ ጎንጎንሢ ቶጊ ዬሱሴ ኮዒ፥ ቂፒርናሆሜ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ባዞ''ኮ ሱኮ''ይዳ ዒዛ ዔያታ ዴንቃዖ፦ «ዔርዛሢዮ! ሓይካ ኔ ዎዳኣ ዎዳ ሙኬይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ዬሱሴ ዔያቶም፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒንሢ ታና ኮዓሢ ካሦ ሙይ ሚሽኬሢሮ ማዓንዳኣፓዓቴም ፆኦሲ ዎልቆና ማዺንቴ ዓኮ ባኮ ዛጌሢሮቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ባይቃ ካሣም ማዺፖቴ፤ ባሼና ዓሲ ናዓሢ ዒንሢም ዒንጋ፥ ናንጊና ናንጊ ሼምፖም ማዓንዳ ካሦም ማዹዋቴ፤ ፆኦሲ፥ ዓዳሢ ፔኤኮ ናዓሢ' ዒዛሮ ማዔሢ ዔርዛ ማላቶ ዒዛይዳ ዓይሤኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ዓሳኣ፦ «ሂዳዖ ኑኡኒ ፆኦሲ ማዾ'' ማዻኒ ዓይጎ ማዻንዳያ ኑና ኮይሳይ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ዬሱሴ፦ «ዒንሢ ማዻንዳጉዲ ፆኦሲ ኮዓ ማዻ'' ዒዚ ዳኬሢ ጉሙርቂ ዔኪሢኬ» ጌይ ዔያቶም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ዔያታ ዒዛ ኮራ፦ «ኑኡኒ ዛጊ ኔና ጉሙርቂ ዔካንዳጉዲ ዓይጎ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ኔ ዻዋንዳይ? ሃሣ ዓይጎ ኔ ማዻንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‹ዔያታ ሙዓንዳጉዲ ጫሪንጫፓ ካሣ ዔያቶም ዒንጌ› ጌይንቲ ፃኣፒንቴሢጉዲ ኑኡኮ ዓዶንሢ ዓሲ ናንጉዋ ዳውሎ''ይዳ ማና'' ጌይንታ ካሦ ሙዔኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ዒማ''ና ዬሱሴ ዔያቶም፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ጫሪንጫፓ ኬዴ'' ካሦ ዒንሢም ዒንጌሢ ሙሴቱዋሴ፤ ጎኑሞ ካሦ ጫሪንጫፓ ዒንሢም ዒንጋሢ ታኣኮ ዓዳሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ዒዚ ዒንጋ ካሣ ጫሪንጫፓ ኬዳ''ያ ሓሣ ዓጪም ሼምፖ ዒንጋያኬ» ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ዓሳ፦ «ጎዳሢዮ! ዬያጉዴ ካሦ ቢያ ዎዴ ኑም ዒንጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ዬሱሴ ዔያቶም፦ «ሼምፖኮ ካሣ ታናኬ፤ ታ ኮራ ሙካሢ ፔቴ''ታዖ ናይዺንታዓኬ፤ ታና ጉሙርቂ ዔካሢያ ፔቴ''ታዖ ዼኤቢንታዓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ዒንሢ ጋዓንቴ ታና ዛጌያታዖ ጉሙርቂ ዔኪባኣሢሮ ታ ዒንሢም ሃያ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ዓዴ ታኣም ዒንጋሢ ቢያ ሃንጋ ታ ባንሢ ሙካንዳኔ፤ ሃንጋ ታ ባንሢ ሙካሢያ ሴካ ዙሎ'' ታ ኬሳ''ዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ዓይጎሮ ጌዔቴ ታኣኒ ጫሪንጮይዳፓ ኬዴ''ሢ ታና ዳኬሢኮ ማሊፆ ኩንሣኒ ማዓንዳኣፓዓቴም ታ ማሊፆ ኩንሣኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ታና ዳኬሢኮ ማሊፃ፦ ዒ ታኣም ዒንጌዞንሢዳፓ ቢያ ፔቴ''ታኣ ባይዙዋዖ ጋፒንፆ ኬሎ''ና ናንጊና ናንጊ ሼምፖ ዴንቃንዳጉዲ ሓይቢፓ ታ ዔያቶ ዔቂሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ሂዮ፤ ታ ዓዳሢኮ ማሊፃ ናዓሢ ዛጊ ዒዛ ጉሙርቂ ዔኬሢ ቢያ ናንጊና ናንጊ ሼምፖ ዴንቃንዳጉዲኬ፤ ታኣኒያ ጋፒንፆ ኬሎ''ና ዒዛ ናንጊና ናንጊ ሼምፖ ዴንቃንዳጉዲ ሓይቢፓ ዔቂሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ዬሱሴ፦ «ጫሪንጮይዳፓ ኬዴ'' ካሣ ታናኬ» ጌዔሢሮ ዓይሁዶ ዓሳ ዒዛ ዑፃ ጉንዱሚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ዔያታ ዒዛ፦ «ሓይ ዮሴፔ ናዓሢ፥ ዬሱሴቱዋዓዳ? ዓዶና ዒንዶና ዒዛኮ ኑ ዔራዞንሢቱዋዓዳ? ሂዳዖ ሃሢ ዒዚ ‹ጫሪንካፓ ታ ኬዴ''ኔ› ዎይቲ ጋዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ዬሱሴ ዔያቶም ማሃዖ ታ ዛሎ'' ዎላ'' ጉንዱሚፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ታና ዳኬ፥ ዓዴ ዔኪ ሙኪባኣ ዓሲ ማዔቴ ታ ባንሢ ሙካኒ ዳንዳዓ ዓሲ ዖኦኒያ ባኣሴ፤ ሃንጋ ታ ባንሢ ሙካሢያ ጋፒንፆ ኬሎ''ና ናንጊና ናንጊ ዴንቃንዳጉዲ ሃይቢዳፓ ታ ዔቂሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፖይዳ፦ «ዓሳ ቢያ ፆኦሲዳፓ ዔሬያ ማዓንዳኔ» ጌይንቲ ፃኣፒንቴኔ፤ ዬያሮ ዓዶይዳፓ ዋይዚ ዔሬሢ ቢያ ሃንጋ ታ ባንሢ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ዬይ ያዺ ማዓዛ ዓዶ ዛጌ ዓሲ ዓኣኔ ጌይሢቱዋሴ። ዓዶ ዛጌሢ ፆኦሲ ኮራፓ ሙኬሢ ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ጎኔ ታ ዒንሢም ጋዓኔ፤ ታና ጉሙርቂ ዔካሢኮ ናንጊና ናንጊ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ታኣኒ ሼምፖኮ ካሣኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ዒንሢኮ ዓዶንሢ ዓሲ ናንጉዋ ዳውሎ''ይዳ ማና'' ጌይንታ ካፆ ሙዔኔ፤ ጋዓንቴ ዔያታ ሃይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ጫሪንጮይዳፓ ኬዴ'' ካሣ ሓያታሢሮ፥ ሓያ ካሦ ሙዓሢ ፔቴ''ታዖ ሃይቃዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ጫሪንጫፓ ኬዴ''፥ ናንጊና ባይቁዋ ካሣ ታናኬ፤ ሃኖ' ካሦይዳፓ ሙዓሢ ቢያ ናንጊና ናንጋንዳኔ፤ ዓጮ''ም ሼምፖ ማዓንዳጉዲ ታኣኒ ዒንጋ ካሣ ታናኬ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ዬማና ዓይሁዶ ዓሳ፦ «ሓይ ዓሢ ዒዛ ኑ ሙዓንዳጉዲ ዎዲ'' ኑም ፔና ዒንጋኒ ዳንዳዓይ?» ጌይሢና ዎላ'' ማርሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ዬያሮ ዬሱሴ ዔያቶም፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓሲ ናዓሢ ዒንሢ ሙዒባኣቴ ሃሣ ሱጉፆዋ ዒንሢ ዒዛኮ ዑሽኪባኣቶ ዒንሢኮ ናንጊ ሼምፓ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ታና ሙዓሢና ሱጉፆዋ ታኣኮ ዑሽካሢኮ ቢያ ናንጊና ናንጊ ሼምፓ ዓኣኔ፤ ታኣኒያ ጋፒንፆ ኬሎ''ና ዒዛ ናንጊና ናንጊ ዴንቃንዳጉዲ ሓይቢዳፓ ዔቂሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ዓይጎሮ ጌዔቴ ታኣኒ ጎኔ ሙኡዚ''፤ ሱጉፃኣ ታኣኮ ጎኔ ዑሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ታና ሙዓሢና ሱጉፆዋ ታኣኮ ዑሽካሢ ቢያ ታኣና ናንጋንዳኔ፤ ታኣኒያ ዒዛና ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ናንጊና ባይቁዋ፥ ዓዴ ታና ዳኬም ታኣኒያ ዒዛና ናንጊና ባይቁዋያ ማዒ ናንጋሢጉዲ ታና ሙዓሢያ ቢያ ታኣና ናንጊና ባይቁዋያ ማዒ ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ዓካሪ ጫሪንጮይዳፓ ኬዴ'' ካሣ ሓያኬ፤ ዬይያ፦ ዒንሢኮ ዓዶንሢ ሙዔሢ ጉዴያቱዋሴ፤ ዓይጎሮ ጌዔቴ ዬኖ ካሦ ሙዔ ዓሳ ሃይቄኔ፤ ሃኖ ካሦ ሙዓሢ ጋዓንቴ ናንጊና ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ዬሱሴ ዬያ ኬኤዜሢ ቂፒርናሆሜይዳ፥ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ዔርዚቤቃኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ዒዛ ዔሪ፥ ዒዛ ዓሲ ማዔ ዓሶይዳፓ ሚርጌዞንሢ ዬያ ዋይዛዖ፦ «ሓይ ዴኤሢ ጌኤሲኬ፤ ዖኦኒ ጎኔኬ ጌይ ዔካኒ ዳንዳዓንዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ዔያታ ዬኖ ባኮ ዛሎ'' ጉንዱማሢ ፔ ዓያኖና ዬሱሴ ዔራዖ፦ «ሓይ፥ ዒንሢ ዻቢሳ ባኣዚ''ዳ? ");
INSERT INTO mdybse_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ዓሲኮ ናዓሢ ዎንዴ ዓኣ ቤዞ ማዒ ኬስካሢ ዒንሢ ዛጋዖ ዎዚ ጋዓኒዳይ? ");
INSERT INTO mdybse_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ሼምፖ ዒንጋሢ ፆኦሲ ዓያናኬ፤ ዓሲኮ ዎልቄ ጋዓንቴ ዓይጎዋ ማኣዱዋሴ፤ ታኣኒ ዒንሢም ኬኤዛ ቃኣላ'' ሼምፖ ዒንጋ ዓያናኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ጋዓንቴ ዒንሢ ባኣኮ''ይዳፓ ፔቴ'' ፔቴ'' ዬያ ጉሙርቁዋ ዓሲ ዓኣኔ» ጌዔኔ። ዬሱሴ ዬያ ጌዔሢ ቤርታፓ ዓርቃዖ ዒዛ ጉሙርቁዋኣሢና ዒዛ ዓኣሢ ዒንጋንዳሢ ዖናታቶዋ ዔራሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ሄሊ''ሳዖ ዬሱሴ፦ «ዓዴ ዓይሤያ ማዒባኣያታቶ ታ ባንሢ ሙካኒ ዳንዳዓይ ባኣሴ ታ ዒንሢም ጌዔሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ዬያይዳፓ ዔቄያና ዒዛ ዔሪ፥ ዒዛ ዓሲ ማዔ ዓሶይዳፓ ሚርጌሢ ጊንሢም ማዔኔ፤ ዬማፓ ዓርቃዖ ዔያታ ዒዛ ጊንፆ ሃንቲፆ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ዬያሮ ዬሱሴ ታጶ ላምዖንሢ ኮራ፦ «ዒንሢያ ሓሺ'' ዓኣዻኒ ኮዓ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ዬማና ሲሞኦኔ ጌይንታ ጴፂሮሴ ማሃዖ፦ «ጎዳሢዮ! ኑኡኒ ዖ ባንሢ ዓኣዻንዳይ? ኔኤኮ ናንጊና ናንጊ ሼምፖ ቃኣላ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ኑኡኒ ኔና ጉሙርቂ ዔኬኔ፤ ፆኦሲም ዱማዼያ ዒዛኮ ናዓሢ ኔና ማዔሢያ ኑ ዔሬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ዬሱሴያ፦ «ታናቱዋይ ዒንሢ፥ ታጶ ላምዖንሢ ዶኦሬሢ? ጋዓንቴ ዒንሢዳፓ ፔቴ''ሢ ፃላሄኬ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ዬያ ዒ ጌዔሢ ሲሞኦኔ ናኣዚ''፥ ዓስቆሮንቶ ዓጮ'' ዓሢ፥ ዪሁዳ ዛሎ''ሮኬ፤ ዓይጎሮ ጌዔቴ ዪሁዳ ዎዚ ታጶ ላምዖንሢዳፓ ፔቴ''ሢ ማዔቴያ ዬሱሴ ዓኣሢ ዒንጋሢ ዒዛ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ዬካፓ ዬሱሴ ጌሊላ ዓጮ''ይዳ ሴካ ሃንጋ ሃንታኔ፤ ዪሁዳ ዓጮ''ይዳ ጋዓንቴ ሃንታኒ ኮይባኣሴ፤ ዓይጎሮ ጌዔቴ ዓይሁዶ ዓሶ ዎይሣ ዓሳ ዒዛ ዎዻኒ ኮዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ዬኖ ዎዶ''ና ዓይሁዶ ዓሶኮ ዉልሾ ዴማ'' ዴዒ ቦንቾ ኬላ'' ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ዬያሮ ዬሱሴኮ ጌርሲንሢ ዒዛ ኮራ ሙካዖ፦ «ኔኤኮ ጊንፆ ሃንታዞንሢ ኔኤኒ ፆኦሲ ዎልቄና ማዻ ዓኮ ባኮ ዛጋንዳጉዲ ሃካፓ ኬስኪ ዪሁዳ ዓጮ'' ዓኣዼ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ዓይጎሮ ጌዔቴ ፔጌና ዔርታኒ ኮዓ ዓሲ ማዾ'' ፔኤሲ'' ዓኣቺ ማዹዋሴ፤ ኔኤኒያ ሓያ ባኮ ቢያ ማዻ ዎዶ''ና ኔና ኔ ዓጮ''ም ፔጋሲ ዔርዛንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ዬያ ዔያታ ጌዔሢ ዒዛኮ ጌርሲንሢታዖ ዒዛ ጉሙርቂ ዔኪባኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ዬሱሴ ዔያቶም፦ «ታ ዎዳ'' ሃጊ ሄሊ''ባኣሴ፤ ዒንሢ ዎዳ'' ጋዓንቴ ቢያ ዎዴ ጊኢጌያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ዓጫ'' ዒንሢ ዒፃኒ ዳንዳዑዋሴ፤ ታና ጋዓንቴ ዒፃኔ፤ ዓይጎሮ ጌዔቴ ታኣኒ ዓጮ''ኮ ማዻ'' ፑርታ ማዔሢ ማርካዻሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ዒንሢ ጋዓንቴ ቦንቾ ኬሎ''ሮ ዓኣዹዋቴ፤ ታኣኮ ዎዳ'' ሃጊ ሄሊ''ባኣሢሮ ዬኖ ቦንቾ ኬሎ'' ቤዞ ታ ዓኣዻዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ዬያ ጌዒጋፓ ዒዚ ጌሊላይዳ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ጋዓንቴ ዒዛኮ ጌርሲንሢ ቦንቾ ኬሎ'' ቤዞ ዓኣዼሢኮ ጊንፃ ዒዚ ዓኣሺንቲ ዬኖ ቤዞ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ዬኖ ቤዞይዳ ዓይሁዶ ዓሶ ዎይሣ ዓሳ፦ «ዬይ ዓሢ ዎካዳይ?» ጌዒ ጌዒ ዒዛ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ዴራ'' ዒዛ ሚርጌና ዾንካኔ፤ ዒማ''ና ፔቴ'' ፔቴ''ዞንሢ፦ «ዒዚ ኮሺ ዓሲኬ» ጋዓዛ፥ ዛላ''፦ «ያዺቱዋሴ፤ ዒዚ ዴሮ'' ዻዻቢሻኔ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ያዺ ማዔቶዋ ዓይሁዶ ዓሶኮ ዎይሣ ዓሶ ዒጊጪሢና ዖኦኒያ ዒዛ ዛሎ'' ፔጌና ጌስቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ዬኖ ቦንቾ ኬሎ''ኮ ሄካስካ ዬሱሴ ጌኤዦ ማኣሪ ዓኣዺ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ዓይሁዶ ዓሶ ዎይሣ ዓሳ፦ «ሓይ ዓሢ ዓሲዳፓ ዔሪባኣያታዖ ሃያ ቢያ ዎዲ'' ዔራኒ ዳንዳዔይ?» ጌዒ ጌዒ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ዬያሮ ዬሱሴ፦ «ታ ዔርዛ ባካ ታና ዳኬ፥ ታ ዓዶይዳፓ ዒንጊንቴያ ማዓንዳኣፓዓቴም ታጊዳፓቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ታና ዳኬሢኮ ዓይሢፆ ኩንሣኒ ኮዓያ ዓኣቶ ሃይ ታኣኮ ዔርዚፃ ፆኦሲዳፓ ዒንጊንቴቴያ ሃሣ ታኣኒ ታ ቶኦካ''ፓ ዔኪ ኬኤዛያ ማዔቴያ ዱማሲ ዔራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ፔ ቶኦካ''ፓ ኬኤዛሢ ፔ ቦንቾ ኮዓኔ፤ ዳኬሢ ቦንቾም ማዻሢ ጋዓንቴ ጎኑሞ ዓኣያኬ፥ ሉኡዙሞዋ ዒዛይዳ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሴ ዒንሢም ዎጌ ዒንጊባይ? ጋዓንቴ ዒንሢዳፓ ዎጎ ኩንሣይ ዖኦኒያ ባኣሴ። ዒንሢ ዓይጎሮ ታና ዎዻኒ ኮዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ዴራ''ኣ፦ «ሓይ ኔ፥ ፑርቶ ዓያና'' ዓርቄሢ ሃይ! ዖ ኔና ዎዻኒ ኮዔይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ዬሱሴ ዔያቶም፦ «ታኣኒ ፔቴ'' ማዾ ማዼኔ፤ ዒንሢ ቢያሢ ዬኖ ማዼ''ሎ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ሙሴ ዓቲንቴ ቤርቲ ቲቂሢ ዎጌ ዒንሢም ዒንጌኔ፤ ዬይ ዎጋ'' ዒንጊንቴሢ ዒንሢኮ ዓዶንሢዳፓ ማዓንዳኣፓዓቴም ሙሴይዳፓቱዋሴ፤ ዓካሪ ዒንሢ ሃውሾ ኬሎ''ናታዖ ዓሲኮ ዓቲንቴ ቤርቲ ቲቲቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ዓካሪ፥ ሙሴ ዎጋ'' ዓቱዋጉዲ ዓሲ ሃውሾ ኬሎ''ና ዓቲንቴ ቤርቲ ቲቂንታያ ማዔቴ ታኣኒ ሃውሾ ኬሎ''ና ዓሲ ሼምፖ ዻቂሼሢሮ ዓይጎሮ ታ ዑፃ ዒንሢ ጎሪ''ንታይ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ዓሲ ዛጊ፥ ዱማሲ ዎጊፆይዳፓ ፒዜ ዎጌ ዎጉዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ዬሩሳላሜ ዓሶይዳፓ ፔቴ'' ፔቴ''ዞንሢ፦ «ዓይሁዶ ዓሶኮ ሱኡጋ ዎዻኒ ኮዓ ዓሢ ሃያቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ሓይሾ ዒዚ ሃሢ ፔጌና ኬኤዛኔ፤ ዔያታ ዒዛ ኮይላ'' ፔቴ''ታዖ ዔኤቢ ጌይባሴ፤ ሓይ ዓሢ ሜሲሔ ማዔሢ ዎይሣ ዓሳ ጎናሲ ዔዔሬሞ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ጋዓንቴ ኑኡኒ ሃይ ዓሢ ዓንካፓታቴ ዔራኔ፤ ሜሲሔ ሙካኣና ዓንካፓታቴያ ዔራንዳያ ዖኦኒያ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ዬያሮ ዬሱሴ ጌኤዦ ማኣሮይዳ ዔርዛዖ ዑኡዞ ፔኤሲ'' ዼ'ግዲ፦ «ታና ዒንሢ ዔራኔ፤ ታኣኒ ዓንካፓ ሙኬቴያ ታና ዒንሢ ዔራኔ፤ ጋዓንቴ ታኣኒ ታ ቢታንቶና ሙኪባኣሴ፤ ታና ዳኬሢ ጎኑሞ ዓኣያኬ፤ ዒንሢ ዒዛ ዔሩዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ታኣኒ ጋዓንቴ ዒዛ ኮራፓ ሙኬሢሮ ሃሣ ዒዚ ታና ዳኬሢሮ ታ ዒዛ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ዒማ''ና ዔያታ ዒዛ ዓርቃኒ ኮዔያታንቴ ዎዳ'' ዒዛኮ ሃጊ ሄሊ''ባኣሢሮ ዖኦኒያ ዒዛ ዓርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ጋዓንቴ ዴሮ''ይዳፓ ሚርጌ ዓሲ ዒዛ ጉሙርቂ ዔካዖ፦ «ሜሲሔ ሙካ ዎዶ''ና ሓይ ዓሢ ማዼ ፆኦሲ ዎልቆና ማዺንቴ ዓኮ ባኮይዳፓ ባሼ ማዻንዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ዴራ'' ዬሱሴ ዾንካሢ ፔርሴ ዓሳ ዋይዜኔ፤ ዬያሮ ቄኤሶኮ ሱኡጎና ፔርሴ ዓሶና ዬሱሴ ዓርቃኒ ጌኤዦ ማኣሮ ካፓ ዓሶ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ዬማና ዬሱሴ፦ «ዒንሢና ዎላ'' ዻካ'' ዎዴ ታ ዴዓንዳኔ፤ ዬካፓ ታና ዳኬሢ ባንሢ ታ ዓኣዻንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ዒንሢ ታና ኮዓንዳኔ፤ ጋዓንቴ ዒንሢ ታና ዴንቃዓኬ፤ ታኣኒ ዓኣ ቤዞ ዒንሢ ሙካኒ ዳንዳዒንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ዬያሮ ዓይሁዶ ዓሶ ዎይሣ ዓሳ ዎሊ ኮይላ''፦ «ኑኡኒ ዒዛ ዴንቁዋጉዲ ሃይ ዓሢ ዓንኮ ዓኣዻኒዳይ? ጎዖንቴ ጊሪኬ ዓጮ'' ዓሶ ባኣካ'' ላኣሊንቲ ዓኣ፥ ዓይሁዶ ዓሶ ባኣኮ'' ዓኣዺ ጊሪኮ ዓሶ ዔርዛኒሞ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹ዒንሢ ታና ኮዓንዳኔ፤ ጋዓንቴ ዒንሢ ታና ዴንቃዓኬ፤ ታኣኒ ዓኣ ቤዞዋ ዒንሢ ሙካኒ ዳንዳዒንዱዋሴ› ጌይፃ ዒዛኮ ዎዚ ጌይሢዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ቦንቾ ኬሎ''ኮ ጋፒንፆ ማዔ፥ ዼኤፖ ኬሎ''ና ዬሱሴ ዔቂጋፓ ዑኡዞ ዼ'ግዲ፦ «ዋኣሢ ዼኤቤይ ዓኣቶ ሃኒ ታ ኮራ ሙኪ ዑሽኮንጎ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ታና ጉሙርቂ ዔካሢኮ ጌኤዦ ማፃኣፓ ጋዓሢጉዲ ናንጊና ናንጊ ዋኣሢ ጋራፓ ዓልቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ዬያ ዒ ጌዔሢ ዒዛ ጉሙርቃዞንሢ ዔካንዳ ዓያኖ ዛሎ''ኬ። ዓይጎሮ ጌዔቴ ዬሱሴ ሃይቂ ሌካ ዔውታ ዎዳ'' ሄሊ''ባኣሢሮ ዓያኖ ጌኤዣ ሃጊ ዒንጊንቲባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ዴሮ''ኮ ባኣኮ''ይዳፓ ፔቴ'' ፔቴ''ዞንሢ ዬያ ቃኣሎ'' ዋይዛዖ፦ «ሙካንዳኔ ጌይንቴ ፆኦሲ ማሊፆ ኬኤዛሢ ጎኔና ሃያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ዛላ'' ሃሣ፦ «ሓይ ሜሲሔኬ» ጌዔኔ። ዓቴ'' ዓሳ ጋዓንቴ፦ «ሜሲሔ ሙካሢ ጌሊላ ዓጮ''ይዳፓዳ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ሜሲሔ ዳውቴ ዜርፃፓ ሾይንታንዳሢና ዳውቴ ካታሞ ቤኤቴሌሄሜይዳፓ ሙካንዳሢ ጌኤዦ ማፃኣፖይዳ ፃኣፒንቲባኣዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ዬያሮ ዒዛ ዛሎ''ና ዴሮ'' ባኣካ'' ፓቂንቲሢ ማዢንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ፔቴ'' ፔቴ''ዞንሢ ዒዛ ዓርቃኒ ኮዔንቴ ዖኦኒያ ዒዛ ዓርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ዬካፓ ጌኤዦ ማኣሮ ካፓዞንሢ ቄኤሶ ሱኡጎና ፔርሴ ዓሶና ባንሢ ዓኣዼኔ፤ ዬና ፑኡፖ ዓሳ፦ «ዒዛ ዒንሢ ዓይጎሮ ዔኪ ሙኪባኣይ?» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ጌኤዦ ማኣሮ ካፓዞንሢያ፦ «ሓይ ዓሢ ኬኤዛሢጉዲ ዖኦኒያ ኬኤዚ ቤቂባኣሴ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ፔርሴ ዓሳ ጋዓንቴ፦ «ዒንሢያ ሃሣ ዻቢንቲያ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ዎይሣ ዓሶና ፔርሴ ዓሶናይዳፓ ዒዛ ጉሙርቄ ዓሲ ዓኣኖ? ");
INSERT INTO mdybse_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ሃይ ሙሴ ዎጎ ዔሩዋ ዴራ'' ጎኔና ጋዳንቂንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ዒማ''ና ሓያኮ ቤርታ ዬሱሴ ኮራ ዓኣዼ፥ ፔርሴ ዓሶ ዛላ''ፓ ማዔ፥ ኒቆዲሞሴ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«ኑኡኮ ዎጎ ጎይፆና ፔቴ'' ዎጌና ዓርቂንቴ ዓሢኮ ጌኤዞ ዋይዙዋዖ ሃሣ ዓይጎ ማዼቴያ ዔሩዋዖ ዎጌ ዎጊንታ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ዔያታ ማሃዖ፦ «ኔኤኒያ ጌሊላ ዓጮ''ይዳፓዳ? ፆኦሲ ማሊሢ ኬኤዛይ ጌሊላ ዓጮ''ይዳፓ ዔቂንዱዋኣሢ ማፃኣፖ ኮሺ'' ማሂ ዛጊ ዔሬ» ዒዛም ጌዔኔ።  ");
INSERT INTO mdybse_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ዬካፓ ፔቴ'' ፔቴ''ሢ ፔኤኮ ማኣሪ ማኣሪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ዬካፓ ዬሱሴ ዛይቴ ሪሚቲ ዹካ ጌይንታ ቤዞ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ዚሬሎ ጉቴ'' ዓማ'' ጌኤዦ ማኣሪ ዒ ማዒ ሙካንቴ ዴራ'' ቢያ ዒዛ ባንሢ ሙካዛ፥ ዒዚ ዴዒ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ሙሴ ዎጎ ዔርዛ ዓሶና ፔርሴ ዓሶና ዓቲንቄና ዞኦዜይዳ ኮኦማንቴ ዴንቄ ላኣሊስኬኖ ዔኪ ሙኪ ዴሮ''ኮ ባኣካ'' ዔቂሳዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ሓይሾ፥ ሃና ላኣሌላ ዓቲንቄና ዞኦስካ ኮኦሚ ዓዺንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ሓኖጉዴ ላኣላ ሹቺና ዹይንቲ ሓይቃንዳጉዲ ሙሴ ኑኡኮ ዎጎይዳ ኑና ዓይሤኔ፤ ኔኤኒ ዒዞ ዛሎ'' ዎዚ ጋዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ዬያ ዔያታ ጌዔሢ ዒዛ ዎጎና ዓይሢሳንዳ ዻቢንቲ ዴንቃኒ ኮዓሢሮኬ፤ ዬሱሴ ጋዓንቴ ሂርኪ ጌይ ፔኤኮ ኬኤሎ''ና ሳዓ ፃኣፒሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ላሚ ላሚ ዒዛ ዔያታ ዖኦጫዛ ዒዚ ዼ'ግ ጋዓዖ፦ «ዒንሢ ባኣካ''ፓ ጎሜ ባኣሢ ቤርታዺ ዒዞ ሹቺና ዹዖንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ዬካፓ ላሚ ሃሣ ሂርኪ ጋዓዖ ሳዓ ፃኣፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ዔያታ ዬያ ዋይዚ ጪሞይዳፓ ዓርቃዖ ቢያሢ ፔቴ'' ፔቴ'' ኬስኪ ኬስኪ ዴንዴሢሮ ዬሱሴ ላኣሌሎና ዎላ'' ሌሊ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ዬካፓ ዬሱሴ ዼ'ግ ጋዓዖ፦ «ዔናኣሬ፤ ኔና ዓርቂ ዔኪ ሙኬ ዓሳ ዎካዳይ? ኔ ጊዳ'' ዎጌ ዓሲ ባኣዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ዒዛ ማሃዖ፦ «ጎዳሢዮ! ዖኦኒያ ባኣሴ» ጌዔኔ። ዬሱሴያ፦ «ታኣ ኔ ዑፃ ዎጋዓኬ፤ ዓኣዼ፥ ላሚ ጎሜ ማዺፖ» ዒዞም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ላሚ ሃሣ ዬሱሴ፦ «ታኣኒ ዓጮ''ኮ ፖዒኬ፤ ታ ጊንፆ ሃንታሢ ቢያ ናንጊ ፖዒ ዴንቃንዳኔ፤ ዹሚዳኣ ሃንቲንዱዋሴ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፔርሴ ዓሳ፦ «ኔኤኒ ኔ ዛሎ'' ኔኤሮ ማርካዻሢሮ ኔኤኮ ማርካታ'' ጎኔቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ዬሱሴ ዔያቶም፦ «ታኣኒ ታ ዛሎ'' ማርካዻያ ማዔያታቴያ ዓንካፓ ታ ሙኬቶ ሃሣ ታ ዓንኮ ዓኣዻቶ ታ ዔራሢሮ ታኣኮ ማርካዺፃ ጎኔኬ፤ ዒንሢ ጋዓንቴ ዓንካፓ ታ ሙኬቶ ሃሣ ዓንኮ ታ ዓኣዻቶዋ ዔራ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ዒንሢ ዓሲ ማሊሢጉዲ ዎጋኔ፤ ታኣኒ ጋዓንቴ ዬያጉዲ ዖ ዑፆይዳኣ ዎጉዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ታኣኒ ዎጌቴያ ታኣኮ ዎጊፃ ፒዜኬ፤ ዓይጎሮ ጌዔቴ ታኣኒ ታኣሮ ሌሊ ዎጉዋሴ፤ ታና ዳኬ ዓዴያ ታኣና ዎላ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ላምዖ ዓሲኮ ማርካታ'' ጎኔ ማዓሢ ዒንሢኮ ዎጎይዳ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ታ ዛሎ''ኮ ፔቴ'' ማርካሢ ታናኬ፤ ሃንጎ ማርካሢ ታና ዳኬ፥ ታ ዓዳሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ዬካፓ ዔያታ፦ «ኔኤኮ ዓዴ ዓንካዳይ?» ጌይ ዒዛ ዖኦጫዛ፥ ዬሱሴ ማሃዖ፦ «ታና ማዔቴያ ታኣኮ ዓዶዋ ዒንሢ ዔሩዋሴ፤ ታና ዒንሢ ዔሬያታቶ ታ ዓዶዋ ዒንሢ ዔራንዳዖኬ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ዬሱሴ ዬያ ቃኣሎ'' ኬኤዜሢ ጌኤዦ ማኣራ፥ ሚኢሾ ዔኮ ሳኣፂኖ ዓጫ ዴዒ ዔርዚቤቃኬ። ዬይ ያዺ ማዔቴያ ዎዳ'' ዒዛኮ ሃጊ ሄሊ''ባኣሢሮ ዖኦኒያ ዒዛ ዓርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ላሚ ዬሱሴ ሃሣ፦ «ታኣኒ ዓኣዻንዳኔ፤ ዒንሢያ ታና ኮዓንዳኔ፤ ጋዓንቴ ዒንሢ ዒንሢኮ ጎሞና ዎላ'' ሓይቃንዳኔ፤ ታኣኒ ዴንዳ ቤዞዋ ዒንሢ ሙካኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ዓይሁዶ ዓሶኮ ዎይሣ ዓሳ፦ « ‹ታኣኒ ዴንዳ ቤዞ ዒንሢ ሙካኒ ዳንዳዑዋሴ› ዒዛኮ ጌይፃ ፔና ዎዎዻኒሞ?» ዎሊ ኮይላ'' ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ሄሊ''ሳዖ ሃሣ ዬሱሴ፦ «ዒንሢ ሃካፓኬ፤ ታኣኒ ሎፓኬ፤ ዒንሢ ሓያ ዓጫ''ፓኬ፤ ታኣኒ ሃያ ዓጫ''ፓቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","‹ዒንሢኮ ጎሞና ዎላ'' ዒንሢ ሃይቃንዳኔ› ታ ጌዔሢ ዬያሮኬ፤ ታኣኒ ታና ማዔሢ ጉሙርቁዋያ ማዔቴ ዒንሢ ዒንሢኮ ጎሞና ዎላ'' ሓይቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ዔያታ ማሃዖ፦ «ኔኤኒ ዖናዳይ?» ዒዛ ኮራ ጋዓዛ፥ ዬሱሴ ዔያቶም፦ «ቤርታፓ ዓርቃዖ ዒንሢም ኬኤዛሢ፥ ታኣኒ ዒዛኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ታኣኒ ዒንሢም ኬኤዛንዳያና ዎጋንዳ፥ ሚርጌ ባኣዚ'' ዓኣኔ፤ ማዔቴያ ታና ዳኬሢ ጎኑሞ ዓኣያኬ፤ ታኣኒያ ዓጮ''ም ኬኤዛሢ ዒዛይዳፓ ዋይዜሢ ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ዔያቶም ጋዓንቴ ዓዶ ዛሎ'' ዒ ኬኤዜሢ ዔርቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ዬያሮ ዬሱሴ ዔያቶም፦ «ዓሲኮ ናዓሢ ዒንሢ ሱፃኣና ታኣኒ ‹ዓያናና ናንጋያ› ማዔሢ ዒንሢ ዔራንዳኔ፤ ዬያጉዲ ዓዴ ታና ዔርዜ ባኮ ታ ኬኤዛንዳፓዓቴም ታ ቢታንቶና ሌሊ ዓይጎ ባኣዚ''ያ ታ ማዹዋኣሢ ዬኖ ዎዶ''ና ዒንሢ ጶቂሣንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ታና ዳኬሢ ታኣና ዎላ''ኬ፤ ታኣኒ ቢያ ኬሊ'' ማዻሢ ዒዛ ዎዛሳ ባኣዚ'' ማዔሢሮ ታና ታኣሮ ሌሊ ዒ ሃሺ''ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ዬሱሴ ዬያ ኬኤዛዛ ሚርጌ ዓሲ ዒዛ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ዬሱሴ ዒዛ ጉሙርቃ ዓይሁዶ ዓሶም፦ «ዒንሢ ታ ዔርዚፆና ዶዲ ናንጌቴ ጎኔና ዒንሢ ታና ዔሪ፥ ታ ዓሲ ማዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ጎኑሞ ዒንሢ ዔራንዳኔ፤ ጎኑሞዋ ዒንሢ ዓይላ''ቶይዳፓ ኬሳ''ንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ዔያታ ጋዓንቴ፦ «ኑኡኒ ዓብራሃሜ ዜርሢኬ፤ ፔቴ''ታዖ ዖኦኮዋ ኑ ዓይሌ'' ማዒ ዔሩዋሴ፤ ዓካሪ ኔኤኒ ‹ዒንሢ ዓይሉ''ሞይዳፓ ኬስካንዳኔ› ኑና ጋዓሢ ዎይቲዳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ዬሱሴ ዔያቶም፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ጎሜ ማዻሢ ቢያ ጎሜኮ ዓይሌ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ዓይሌ'' ቢያ ዎዴና ማኣሪዳ ናንጊ ዓቱዋሴ፤ ሾዖና ናይ ጋዓንቴ ቢያ ዎዴ ማኣራ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ዬያሮ ሾዖና ናዓሢ ዒንሢ ዓይላ''ቶፓ ኬሴ''ቴ ጎኔና ዒንሢ ዓይላ''ቶፓ ኬስኬያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ዒንሢ ዓብራሃሜ ዜርፆ ማዔሢ ታ ዔራኔ፤ ጋዓንቴ ታኣኮ ቃኣሎ'' ዒንሢ ዔኩዋያታሢሮ ታና ዎዻኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ታኣኒ ታ ዓዶ ኮራፓ ዛጌ ባኮ ዒንሢም ኬኤዛኔ፤ ዒንሢ ጋዓንቴ ዒንሢ ዓዶ ኮራፓ ዋይዜ ባኮ ማዻኔ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ዔያታ ማሃዖ፦ «ኑኡኮ ዓዳሢ ዓብራሃሜኬ» ዒዛም ጋዓዛ፥ ዬሱሴ ዔያቶም፦ «ዓብራሃሜ ናይ ዒንሢ ማዔያታቴ ዓብራሃሜ ማዼሢጉዲ ማዼያናንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ታኣኒ ፆኦሲዳፓ ዋይዜ ጎኑሞ ዒንሢም ኬኤዜኔ፤ ዒንሢ ጋዓንቴ ታና ዎዻኒ ኮዓኔ፤ ዓብራሃሜ ዬያይዲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ዓካሪ ዒንሢ ማዻሢ ዒንሢኮ ዓዳሢ ማዾ''ኬ» ጋዓዛ፥ ዔያታ ማሃዖ፦ «ኑኡኒ ዓሌ'' ናይቱዋሴ፤ ኑኡኮ ፔቴ'' ዓዴ ዓኣኔ፤ ዒዚያ ፆኦሲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ዬሱሴ ዔያቶም፦ «ፆኦሲ ዒንሢኮ ዓዶ ማዔያታቴ ታና ዒንሢ ናሽኬያ ናንዳኔ፤ ዓይጎሮ ጌዔቴ ታኣኒ ሓይካ ዓኣሢ ፆኦሲ ኮራፓ ሙኪኬ፤ ታና ዳኬሢያ ዒዛ ማዓንዳኣፓዓቴም ታኣኒ ታ ቢታንቶና ሙኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ታኣኒ ጋዓ ባካ ዒንሢም ዎይቲ ጌሉዋይ ጌዔቶ ታ ቃኣሎ'' ዒንሢ ዋይዚ ዔካኒ ኮዑዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ዒንሢ ዒንሢኮ ዓዳሢ፥ ፃላሄ ናኣቶ''ኬ፤ ዒንሢኮ ማሊፃ ዒንሢ ዓዳሢ ዓፃዻ ባኮ ኩንሥሢኬ፤ ዒዚ ቤርታፓ ዓርቃዖ ሼምፖ ዎዻያኬ፤ ጎኑሞ ዒዛይዳ ባኣሢሮ ጎኑሞና ዎላ'' ፔቴ''ታዖ ካኣሚ ዒዛኮ ባኣሴ፤ ዒዚ፡ ሉኡቃያ ሃሣ ሉኡዙሞኮዋ ዓዶ ማዔሢሮ ሉኡቂ ዒ ኬኤዛ ዎዶ''ና ፔ ማሊፃፓ ዔኪ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ታኣኒ ጋዓንቴ ጎኑሞ ኬኤዛያ ማዔሢሮ ዒንሢ ታና ጉሙርቁዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ሂንዳ ዒንሢዳፓ፦ ‹ኔኤኒ ጎሜናኬ› ታና ጋዓንዳሢ ዖናዳይ? ጎኑሞ ታ ኬኤዛያ ማዔቴ ዓካሪ ዒንሢ ዓይጎሮ ታና ጉሙርቁዋይ? ");
INSERT INTO mdybse_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ፆኦሲዳፓ ማዔሢ ዒዛኮ ቃኣሎ'' ዋይዛንዳኔ፤ ዓካሪ ዒዛኮ ቃኣሎ'' ዒንሢ ዋይዙዋኣሢ ዒዛይዳፓ ዒንሢ ማዒባኣሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ዓይሁዶ ዓሳ፦ «ኔኤኒ ሳማሪያ ዓጪ ዓሲኬ፤ ፑርታ ዓያናኣ ኔ ጊዳ'' ዓኣኔ፤ ኑኡኮ ጌይፃ ፒዜቱዋዓዳ?» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ዬሱሴ ዔያቶም፦ «ታ ጊዳ'' ፃላሄ ዓያና ባኣሴ፤ ታኣኒ ታኣኮ ዓዶ ቦንቻኔ፤ ጋዓንቴ ዒንሢ ታኣኮ ቶኦኪ ባይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ማዔቶዋ ታኣኒ ታ ቦንቾ ኮዑዋሴ፤ ታኣኒ ቦንቺንታንዳጉዲ ኮዓያና ዬኖ ዛሎ'' ታኣም ዎጋይ ሜሌ'' ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ጎኔ ታ ዒንሢም ጋዓኔ፦ ‹ታኣኮ ቃኣሎ'' ካፓሢ ፔቴ''ታዖ ሃይቃዓኬ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ዓይሁዶ ዓሳ ጊንሣ፦ «ፑርቶ ዓያና'' ኔ ጊዳ'' ዓኣሢ ዓካሪ ኑ ዔሬኔ፤ ዓብራሃሜታዖ ሃይቄኔ ሃሣ ፆኦሲ ማሊፆ ኬኤዛ ዓሳኣ ሃይቄኔ፤ ኔኤኒ ጋዓንቴ ‹ታኣኮ ቃኣሎ'' ካፓሢ ፔቴ''ታዖ ሃይቃዓኬ› ጋዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ጎኔና ኔኤኒ ኑኡኮ ሃይቄ፥ ዓዶ፥ ዓብራሃሜፓ ባሻ? ፆኦሲ ማሊፆ ኬኤዛ ዓሳ ሃይቄኔ፤ ሂዳዖ ኔኤኒ ኔና ዖናኬ ጋዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ዬሱሴ ማሃዖ፦ «ታኣኒ ታ ቦንቾ ኮዔቴ ታ ቦንቻ ማኣዳ''ያቱዋሴ፤ ታና ቦንቻሢ ታ ዓዶኬ፤ ዒዚያ፦ ‹ኑ ፆኦሲ› ዒንሢ ጋዓሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ጋዓንቴ ዒንሢ ዒዛ ዔሩዋሴ፤ ታኣኒ ዒዛ ዔዔራኔ፤ ታኣኒ ዒዛ ዔሩዋሴ ጌዔቶ ዒንሢጉዲ ሉኡዚ ማዔያ ናንዳንቴኬ፤ ጋዓንቴ ታኣኒ ዒዛ ዔራሢሮ ቃኣሎ''ዋ ታ ዒዛኮ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ዒንሢ ዓዳሢ፥ ዓብራሃሜኮ ማሊፃ ታ ሙኬም ዛጊ ዎዛዻኒኬ፤ ዒዚያ ዛጊ ዎዛዼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ዒማ''ና ዓይሁዶ ዓሳ፦ «ኔኤኮ ሃጊ ዶንጊታሚ'' ሌዔ ኩሚባኣሢ፥ ኔናንሢ ዓብራሃሜ ዛጊያ!» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ዬሱሴ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓብራሃሜ ሾይንቱዋንቴ ታኣኒ ዓኣኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ዬያሮ ዒዛ ዓይሁዶ ዓሳ ሹቻ ዹዓኒ ሹቺ ዔካዛ፥ ዬሱሴ ጋዓንቴ ዔያታ ዒዛ ዴንቁዋጉዲ ፔና ዓኣቺ ጌኤዦ ማኣራፓ ኬስኪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ዬሱሴ ጎይፆና ዓኣዺቤቃ ዓኣፒ ባይቄያ ማዒ ሾይንቴ ዓሲ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ዒዛኮ ጊንፆ ሃንታ ናኣታ'' ዬሱሴ ኮራ፦ «ዔርዛሢዮ! ሃይ ዓሢ ዓኣፒ ባይቄያ ማዒ ሾይንቴሢ ዖ ጎሜ ዛላናዳይ? ፔ ጎሜናሞ ዒዛ ሾዔ ዓሶ ጎሜናዳይ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ዬሱሴ ዔያቶም ማሃዖ፦ «ሓይ ዓኣፖ ባይቄሢ ፔ ዛላና ሃሣ ዒዛኮ ሾዔ ዓሶ ጎሜ ዛላናቱዋሴ፤ ጋዓንቴ ፆኦሲ ማዻ'' ዒዛይዳ ፔጋዺ ዔርታንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ሄላ'' ዓኣንቴ ታና ዳኬሢኮ ማዾ'' ማዻንዳያ ታና ኮይሳኔ፤ ዖኦኒያ ማዻኒ ዳንዳዑዋ ዹሚ ኬሊ'' ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ታኣኒ ዓጮ''ይዳ ዓኣና ዓጮ''ኮ ፖዔኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ዬያ ጌዔሢኮ ጊንፃ ሳዖይዳ ጩታዖ ጩጮና ሲላሎ ዲርኪ፥ ዾቃሎና ዓኣፖ ባይቄሢኮ ዓኣፖ ቲሽካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«ዴንዲጋፓ ሴሌሆሜ ቦቆሎይዳ ማስቴ» ዒዛም ጌዔኔ። ሴሌሆሜ ጌይፃ፦ «ዳኪንቴያ» ጌይሢኬ፤ ዬያሮ ዓሢ ዴንዲ ማስታዖ ዛጊ ዛጊ ማዒ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ዒዛኮ ዓሺኖና ቤርታ ዒ ሺኢቃንቴ ዛጌ ዓሶና፦ «ሓይ ዓሢ ዴይ ዔኤቢ ዒንጎም ጌይ ሺኢጲፆ ሺኢቃሢቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ፔቴ'' ፔቴ'' ዓሳ፦ «ሂዮ፥ ዒዛኬ» ጋዓዛ፥ ሃንጎ ዓሳ ሃሣ፦ «ዒዛ ማማላኔ፥ ዒዛቱዋሴ!» ጌዔኔ፤ ዒዚ ጋዓንቴ፦ «ታ ዒዛኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ዓሳኣ፦ «ሂዴቶ ኔኤኮ ዓኣፓ ዎይቲ ቡሊ''ንቴይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ዒዚያ፦ «ዬሱሴ ጌይንታ ዓሢ ሲላሊ ዲርኪ ታኣኮ ዓኣፖ ቲሽካዖ ‹ሴሌሆሜ ዴንዲ ማስቴ› ታኣም ጋዓዛ፥ ታኣኒ ዓኣዺ ማስቴስካፓ ዛጋኒ ዳንዳዔኔ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ዔያታ፦ «ዬይ ዓሢ፥ ሃሢ ዓንካዳይ?» ዒዛ ኮራ ጋዓዛ፥ ዒዚያ፦ «ዒዚ ሃሢ ዓንካ ዓኣቴያ ታ ዔሩዋሴ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ዬካፓ ዓሳ ዓኣፓ ባይቄ ዓሢ ዔኪ ፔርሴ ዓሶ ኮራ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ዬሱሴ ሲላሎ ዲርኪ ዓሢኮ ዓኣፖ ቡሌ'' ኬላ'' ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ናኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ፔርሴ ዓሳ፦ «ኔኤኒ ዎይቲ ዛጋኒ ዳንዳዔይ?» ጌይ ዓሢ ላሚ ዖኦጫዛ፥ ዒዚ ማሃዖ፦ «ዒዚ ታኣኮ ዓኣፖይዳ ዾቃሌ ቲሽካዛ፥ ታኣኒ ማስቴኔ፤ ዬያሮ ታ ዛጋኒ ዳንዳዔኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ዬማና ፔርሴ ዓሶይዳፓ ፔቴ'' ፔቴ''ዞንሢ፦ «ሓይ ዓሢ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ'' ቦንቹዋኣሢሮ ዒዚ ፆኦሲዳፓቱዋሴ» ጋዓዛ፥ ዛላ'' ጋዓንቴ፦ «ያዺ ማዔቴ ጎሜና ዓኣ ዓሲ ሃያ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮ ዎዲ'' ማዻኒ ዳንዳዓይ?» ጌዔኔ። ዬያ ዛሎ''ና ዔያቶ ባኣካ'' ፓቂንቲሢ ማዢንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ዬያሮ ዓኣፖ ባይቄ ዓሢ፦ «ኔኤኒ ኔኤኮ ዓኣፖ ዻቂሼኔ፥ ጋዓ ዓሢ ዛሎ'' ኔ ዎዚ ጋዓይ?» ጌይ ዔያታ ዒዛ ላሚ ዖኦጫዛ፥ ዒዚ ማሃዖ፦ «ፆኦሲ ማሊሢ ኬኤዛ ዓሲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ዬይ ዓሢ ዓኣፒ ባይቄያ ማዔሢና ዓኣፓ ጊንፃፓ ዒዛኮ ቡሊ''ንቴሢ ዒዛ ሾዔ ዓሶ ዔኤሊ'' ዖኦጫንዳያ ሄላ''ንዳኣና ዓይሁዶ ዓሶ ዎይሣ ዓሳ ዬያ ጎኔኬ ጌይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ዬያሮ ዒዛ ሾዔ ዓሶ ኮራ፦ « ‹ዓኣፒ ባይቄያ ማዒ ሾይንቴኔ› ዒንሢ ጋዓ ናዓሢ ዒንሢኮ ሃያዳ? ሓሢ ዒ ዎይቲ ዛጋኒ ዳንዳዔይ?» ጌይ ዔያታ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ሾዔ ዓሳ ዔያቶም ማሃዖ፦ «ሓይ ኑኡኮ ናዓሢ ማዔሢና ዓኣፒ ባይቄያ ማዒ ዒዛኮ ሾይንቲፆ ኑ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ጋዓንቴ ሃሢ ዒ ዎይቲ ዛጋኒ ዳንዳዔቴያ ሃሣ ዓኣፓ ዒዛኮ ዎይቲ ቡሊ''ንቴቴያ ኑ ዔሩዋሴ፤ ዒዛ ዖኦጩዋቴ፤ ዒዚ ፔኑሞ ዔራያ፥ ዒናዼ ዓሲ ማዔሢሮ ዒዚ ፔ ዛሎ'' ኬኤዛኒ ዳንዳዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ዒዛ ሾዔ ዓሳ ዬያ ጌዔሢ ዓይሁዶ ዓሶኮ ዎይሣ ዓሶ ዒጊጬሢሮኬ፤ ዓይጎሮ ጌዔቴ፦ «ዬሱሴ፥ ሜሲሔኬ» ጋዓ ዓሲ ዓኣቶ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛፓ ዳውሳኒ ዬና ዎይሣ ዓሳ ዎላ'' ጌስቲ ዔቂሴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ዬያሮ ዓሢ ሾዔ ዓሳ፦ «ዒዚ ፔኑሞ ዔራ፥ ዒናዼ ዓሲ ማዔሢሮ ዒዛ ዖኦጩዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ዬኖ ዛሎ''ና ዔያታ ዬያ ዓሢ ላሚ ዔኤላ''ዖ፦ «ኔኤኒ ሂንዳ ፆኦሲ ቦንቺ ጎኑሞ ኬኤዜ፤ ዬይ ዓሢ ጎሜና ዓኣ ዓሲ ማዔሢ ኑ ዒዛ ዔራኔ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ዓሢያ፦ «ዒዚ ጎሜና ዓኣ ዓሲ ማዔሢ ታ ዔሩዋሴ፤ ታኣኒ ዔራማ ታኣኒ ዓኣፒ ባይቄያታዖ ሃሢ ዛጋኒ ዳንዳዔማ ሌሊኬ» ጌይ ዔያቶም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ዔያታ፦ «ዒ ኔኤም ዓይጎ ማዼይ? ዓኣፖ ኔኤኮ ዒ ቡሌ''ሢ ዎዲዳይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ዒዚያ ማሃዖ፦ «ቤርታ ታ ዒንሢም ኬኤዛዛ ዒንሢ ጋዓንቴ ዋይዛኒ ኮይባኣሴ፤ ሂዳዖ ዒንሢ ዓይጎሮ ላሚ ዋይዛኒ ኮዓዖ? ዒንሢያ ሃሣ ዒዛ ዔሪ፥ ዒዛ ዓሲ ማዓኒ ኮዓሞ?» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ዔያታ ዒዛ፦ «ዒዛ ዓሲ ማዔሢ ኔናኬ! ኑኡኒ ጋዓንቴ ሙሴ ዓሲኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ፆኦሲ ሙሴና ጌስቴሢ ኑ ዔራኔ፤ ሃይ ዓሢ ጋዓንቴ ዓንካፓታቴያ ኑ ዒዛ ዔሩዋሴ» ጌዒ ጫሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ዓሢያ ዔያቶም፦ «ሓይ ዓሢ ዓንካፓ ማዔቴያ ዒንሢኮ ዔሩዋዖ ዓቲፃ ታና ዲቃሢ ሄርሺሳኔ! ጋዓንቴ ታኣኮ ዓኣፖ ቡሌ''ሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ፆኦሲ ጎሞ ዓሶም ዋይዙዋኣሢ ዔርቴያኬ፤ ጋዓንቴ ፆኦሲ ዒጊጫያና ዒዛኮ ማሊፆዋ ኩንሣይ ዓኣቶ ዬያም ፆኦሲ ዋዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","‹ዓኣፒ ባይቄያ ማዒ ሾይንቴ ዓሲኮ ዓኣፒ ቡሌ''ኔ› ጎዖያ ሳዓ ማዢንቴማፓ ዓርቃዖ ዋይዚንቲ ቤቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ሓይ ዓሢ ፆኦሲዳፓ ማዒባኣያታቶ ዓይጎዋ ማዻኒ ዳንዳዒንዱዋያታንቴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ዔያታ፦ «ኔ ጎሜና ማዒ ሾይንቴሢ ሃይ! ኔ ኑና ዔርዛኒዳ?» ጋዓዖ፥ ዔያታ ዒዛ ፔኤኮ ቡኪንቶ ቤዛፓ ኬሴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ዓሢ ዔያታ ፔኤኮ ቡኪንቶ ቤዛፓ ኬሴ''ሢ ዬሱሴ ዋይዜኔ፤ ዬካፓ ዓሢና ካኣማዖ፦ «ዓሲኮ ናዓሢ ኔ ጉሙርቃ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ዒዚ፦ «ጎዳሢዮ! ዒዛ ታ ጉሙርቃንዳጉዲ ዒዚ ዖናታቴያ ታኣም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ዬሱሴ ማሃዖ፦ «ሓያኮ ቤርታ፥ ዎዳ ኔ ዒዛ ዛጌኔ፤ ሃሢ ሃይ ኔኤና ዎላ'' ጌስታሢ ዒዛኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ዒዚያ፦ «ጎዳሢዮ! ታኣኒ ጉሙርቃኔ» ጌይ ጉምዓቲ ዒዛም ዚጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ዬሱሴ፦ «ዓኣፓ ዛጉዋኣሢ ዛጋንዳጉዲ፥ ዓኣፓ ዛጋሢያ ዓኣፒ ባይቄያ ማዓንዳጉዲ ታኣኒ ሓያ ዓጮ''ይዳ ዎጋኒ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ዬማና ዬሱሴ ኮራ ዓኣ፥ ፔርሴ ዓሳ፦ «ሂዴቴ ኑኡኒ ዓኣፒ ባይቄ ዓሲኬ ጌይሢዳ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ዬሱሴ ዔያቶም ማሃዖ፦ «ዓኣፒ ባይቄያ ዒንሢ ማዔቶ ጎሜ ዒንሢም ማዓዓታንቴ ሃሢ ኑ ዴንቃኔ ዒንሢ ጋዓሢሮ ጎሜ ዓሲ ማዒ ዒንሢ ናንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ሄሊ''ሳዖ ዬሱሴ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ማራቶ ባርቶኮ ካሮ''ናቱዋንቴ ሜሌ'' ዛላና ጌላ ዓሲ ዉሲ ሃሣ ሱላኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ካሮ''ና ጌላሢ ጋዓንቴ ማራቶ ሄንቃሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ካሮ'' ካፓሢ ዬያም ካሮ'' ቡላ''ንዳኔ፤ ማራታኣ ዒዛኮ ዑኡዞ ዋይዛንዳኔ፤ ዒዚያ ፔኤኮ ማራቶ ሱ'ንፆና ሱ'ንፆና ዔኤላ''ንዳኔ፤ ሃሣ ዔያቶ ዔኪ ሄንፆዋ ዓኣዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ዒዚ ፔኤኮ ማራቶ ቡላ''ዖ ቤርታ ቤርታ ዓኣዻንዳኔ፤ ማራታኣ ዒዛኮ ዑኡዞ ዔራሢሮ ዒዛ ጊንፆ ዓኣዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ቢሪ ማዔሢኮ ጋዓንቴ ዑኡዞ ዔያታ ዔሩዋኣሢሮ ዬያይዳፓ ዣኣሊ ባይቃንዳኣፓዓቴም ዒዛ ጊንፆ ዴንዲንዱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ዬሱሴ ዬያ ማላቶ ዔያቶም ኬኤዛዛ ዔያታ ጋዓንቴ ዒዚ ዔያቶም ኬኤዜሢ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ዬያሮ ዬሱሴ ላሚ ዔያቶም፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ታኣኒ ማራቶኮ ካራ''ሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ታኣኮ ቤርታ ሙኬዞንሢ ዉዞና ሱሎ''ናኬ፤ ማራታ ጋዓንቴ ዔያቶም ዋይዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ካራ''ሢ ታናኬ፤ ታ ዛሎ''ና ጌላሢ ዻቃንዳኔ፤ ጌላንዳኔ፥ ኬስካንዳኔ፥ ሄንቆ ቤሲያ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ዉዛሢ ሙካሢ ዉኡቃኒና ሹካኒ ሃሣ ባይዛኒ ሌሊኬ፤ ታኣኒ ጋዓንቴ ሙኬሢ ናንጊ ዔያታ ዴንቃንዳጉዲና ፓጬ ባኣዚ''ባኣ፥ ኩሙሢ ናንጊ ናንጋንዳጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ሃሣ ዬሱሴ፦ «ኮዦ ሄንቃሢ ታናኬ፤ ኮዦ ሄንቃሢ ፔኤኮ ሼምፓሢ ማራቶ ዛሎ'' ዓኣሢ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ማራታ ዒዛሮ ማዒባኣያ፥ ሚኢሾ ዴንቃኒ ሄንቃሢ ጋዓንቴ ያኣያሢ ሙካሢ ዛጋዖ ማራቶ ሃሺ'' ጳሽካንዳኔ፤ ያኣያሢያ ማራቶይዳፓ ዓርቂ ዎዻንዳኔ፤ ዣኣሊሲያ ዣኣሊሳንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ሄንቃያታዖ ጳሽኬሢ ሚኢሼ ዴንቃኒ ሄንቃሢሮና ሃሣ ማራቶማኣ ዒ ማሉዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ኮዦ ሄንቃሢ ታናኬ፤ ታኣኒ ታኣኮ ማራቶ ዔራኔ፤ ታ ማራታኣ ታና ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ታኣኒ ዔያቶ ዔራሢ ታና ታ ዓዴ ዔራሢና ታኣኒያ ታ ዓዶ ዔራሢ ጎይፆ ጉዴያናኬ፤ ታኣኒ ታ ማራቶ ዛሎ''ሮ ታኣኮ ሼምፓሢ ዓኣሢ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ሓያ ቆልሞ ባኣካ'' ማዒባኣ ሜሌ'' ዓቴ'' ማራይ ታኣኮ ዓኣኔ፤ ዔያቶዋ ታ ዔኪ ሙካንዳያ ታና ኮይሳኔ፤ ዔያታኣ ታኣኮ ዑኡዞ ዋይዛንዳኔ፤ ፔቴ'' ባርታይዳ ዓኣ ቆሎዋ ማዓንዳኔ፤ ሄንቃሢያ ሃሣ ፔቴ'' ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ዬሱሴ ላሚ ሃሣ፦ «ታ ማሂ ዔካንዳ፥ ታኣኮ ሼምፔሎ ዓኣሢ ታ ዒንጋኒ ናሽካያ ማዔሢሮ ታ ዓዴ ታና ናሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ታኣኮ ሼምፔሎ ታኣሮ ታ ናሽኪ ዓኣሢ ዒንጋፓዓቴም ታ ጊዳ''ፓ ዔካንዳይ ዖኦኒያ ባኣሴ፤ ታኣኮ ሼምፔሎ ዓኣሢ ታ ዒንጋኒና ማሂ ጊንሣ ዔካኒ ቢታንቶ ታኣኮ ዓኣኔ፤ ዬይ፦ ታ ዓዴ ታ ማዻንዳጉዲ ዓይሤሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ዬያ ዒ ጌዔሢሮ ዓይሁዶ ዓሶ ባኣኮ''ይዳ ላሚ ሃሣ ፓቂንቲሢ ማዢንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ዔያቶይዳፓ ሚርጌዞንሢ፦ «ዒዛይዳ ፑርታ ዓያና ዓኣኔ፤ ሃሣ ዒ ዣኣሽካኔ፤ ዒንሢ ዒዛሲ ዓይጎሮ ዋይዛይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ዛላ'' ሃሣ፦ «ሓይ ጌኤዛ ፑርታ ዓያና ዓኣ ዓሲ ጌስታ ጌኤሲቱዋሴ፤ ፑርታ ዓያና ዓኣፒ ባይቄ ዓሲኮ ዓኣፒ ቡላ''ኒ ዳንዳዓ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ዬሩሳላሜይዳ፡ ጌኤዦ ማኣራ ዒኢቴንቴ ጊንሣ ጌኤሾና ኬሎ'' ማሊ ቦንቾ ኬላ'' ሄሌ''ኔ፤ ዬና ዎዳ'' ባርጊ ዎዴኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ዒማ''ና ዬሱሴ ጌኤዦ ማኣሮይዳ ካኣቲ ሴሎሞኔ ሓንታ ቤዞይዳ ሃንታንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ዓይሁዶ ዓሳ ዒዛ ኮራ ቡካዖ፦ «ዓይዲ ሄላ''ንዳኣና ‹ዒ ዖናሞ?› ጌይሲ ኔ ኑና ናንጊሳይ? ኔኤኒ ሜሲሔ ማዔቴ ፔጋሲ ኑም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ዬሱሴ ዔያቶም ማሃዖ፦ «ታኣኒ ዒንሢም ቤርታ ኬኤዜኔ፤ ዒንሢ ጋዓንቴ ታኣሲ'' ጎኔኬ ጎዑዋሴ፤ ታ ዓዶ ሱ'ንፆና ታ ማዻ ዓኮ ባካ ታ ዛሎ'' ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ዒንሢ ጋዓንቴ ታኣኮ ማራቶ ማዒባኣሢሮ ጉሙርቁዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ታኣኮ ማራታ ታ ዑኡዞ ዋይዛኔ፤ ታኣኒያ ዔያቶ ዔራኔ፤ ዔያታኣ ታ ጊንፆ ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ታኣኒ ናንጊና ናንጊ ሼምፖ ዔያቶም ዒንጋንዳኔ፤ ዬያሮ ፔቴ''ታዖ ዔያታ ባይቃዓኬ፤ ታ ኩጫፓ ዖኦኒያ ዔያቶ ቡሪ ዔካዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ዔያቶ ታኣም ዒንጌ፥ ታ ዓዴ ቢያፓ ባሼታሢሮ ታ ዓዶ ኩጫፓ ዔያቶ ቡሪ ዔካኒ ዳንዳዓይ ዖኦኒያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ታኣና ታ ዓዶና ኑ ዎላ'' ፔቴ''ኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ዬማና ዓይሁዶ ዓሳ ዬሱሴ ሹቻ ዹዓኒ ላሚ ሃሣ ሹቺ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ዬሱሴ ጋዓንቴ፦ «ታ ዓዶይዳፓ ታኣም ዒንጊንቴም፥ ሚርጌ ዓኪ ባኣዚ'' ታ ማዺ ዒንሢ ዻዌኔ፤ ዓካሪ ዒንሢ ታና ሹጮና ዹዓዛ ዎኖ ማዾ'' ዛሎ''ሮዳይ?» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ዔያታኣ፦ «ኔና ኑ ዹዓሢ ፆኦሲ ኔ ጫሽኬሢሮ ማዓንዳኣፓዓቴም ኔ ማዼ ማዾ''ሮቱዋሴ፤ ሃሣ ኔኤኒ ዓሲታዖ ኔና ኔ ፆኦሲ ማሄሢሮኬ» ጌይ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ዬሱሴ ዔያቶም፦ «ዒንሢኮ ዎጎይዳ ‹ዒንሢ ካኣሽኮ ፆኦዞኬ› ፆኦሲ ጌዔኔ ጌይንቲ ፃኣፒንቲባይ? ");
INSERT INTO mdybse_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ፆኦሲ ቃኣላ'' ኬኤዚንቴዞንሢ ፆኦሲ ‹ካኣሽኮ ፆኦዞኬ› ጌዔያታቶ ሃሣ ማፃኣፓ ጌዔ ባካኣ ላኣሚንቱዋያ ማዔቶ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ዓካሪ ‹ታኣኒ ፆኦሲ ናይኬ› ጌዔሢሮ ዓዴ ፔኤም ዱማሲ፥ ዓጮ'' ባንሢ ዳኬሢ፦ ‹ኔኤኒ ፆኦሲ ጫሽኪ ዻቢንቴኔ› ዒንሢ ታና ዎይቲ ጋዓይ? ");
INSERT INTO mdybse_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ታ ዓዴ ማዻ ባኮ ታ ማዹዋያ ማዔቶ ታና ጉሙርቂፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ዬያ ታ ማዻያ ማዔቶ ጋዓንቴ ታና ዒንሢ ጉሙርቂባኣቴያ ዓዴ ታኣና፥ ታኣኒያ ዓዶና ማዔሢ ኮሺ'' ዔራኒ ዒዛ ዎልቆና ማዺንቴ ዓኮ ባኮ ጉሙርቁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ዔያታ ላሚ ሃሣ ዒዛ ዓርቃኒ ኮዔኔ፤ ዒዚ ጋዓንቴ ቶሊ'' ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ዬካፓ ላሚ ዮርዳኖሴ ዎሮና ፒንቂ ዮሓኒሴ ቤርታ ዓሶ ዋኣፆና ማስካ ቤዞ ሙካዖ ዒኢካ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ዒማ''ና ሚርጌ ዓሲ ዒዛ ኮራ ሙኪ፦ «ዮሓኒሴ ዓይጎዋ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዺባኣሴ፤ ጋዓንቴ ዮሓኒሴ ሃያ ዓሢ ዛሎ'' ኬኤዜ ባካ ቢያ ጎኔኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ዒኢካ ሚርጌ ዓሲ ዒዛ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ቢታኒያ ጌይንታ ጉርዴሎይዳ ናንጋ፥ ዓላዜሬ ጎዖ ዓሲስኬይ ሃርጊንቴኔ፤ ቢታኒያ ጎዖዛ ማይራሞና ዒዞኮ ጌሮ ማርታና ናንጋ ጉርዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ዬና ማይራማ ጎዳኮ ዑፃ ሳውቃ ቲዦ ዋሂ፥ ዒዛኮ ቶኮዋ ዒዞኮ ቶኦኮ'' ጋፓኖና ዑጬዜሎኬ፤ ሃርጊንቴሢ ዒዞኮ ጌርሲ ዓላዜሬኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ዬንሢ ዎሊኮ ጌኤዶና ሚሾና ማዔዞንሢ፦ «ጎዳሢዮ! ኔ ናሽካ ኔኤኮ ላጋሢ ሓርጊንቴኔ» ጌይ ዔያታ ዬሱሴ ባንሢ ዔኤሊ''ሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ዬሱሴ ዬያ ዋይዛዖ፦ «ዬይ ሃርጋ ዎዻያቱዋሴ፤ ጋዓንቴ ፆኦሲ ቦንቾም ማዓንዳጉዲና ፆኦሲ ናዓሢያ ዬያ ዛሎ''ና ቦንቺንታንዳጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ዬሱሴ ማርታና ጌሮ ማይራሞና ሃሣ ዔያቶኮ ጌርሲ ዓላዜሬያ ሚርጌ ናሽካያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ማዔቴያ ዓላዜሬ ሓርጌሢ ዋይዜዖ ዒ ዓኣ ቤዞይዳ ላምዖ ኬሊ'' ፔኤቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ዬካፓ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮራ፦ «ዪሁዳ ዓጮ'' ላሚ ኑ ዓኣዾም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ዒዛኮ ጊንፆ ሃንታዞንሢያ ማሃዖ፦ «ዔርዛሢዮ! ዓይሁዶ ዓሳ ዻካ'' ኬሊ''ኮ ቤርታ ዹይ ኔና ዎዻኒ ኮዔኔ፤ ሃሢ ኔ ላሚ ዒኢካ ዓዓኣዻኒ ጋዓ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ዬሱሴ ዔያቶም ማሃዖ፦ «ዓባ'' ኬስኪ ጌላንዳሢኮ ጋራ ታጶ ላምዖ ፓቂንታ ዎዳ'' ቢያ ፖዔቱዋይ? ዓካሪ ሓያ ዓጮ'' ፖዖይዳ ሃንታሢ ዛጋያታሢሮ ዹቂንቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ጋዓንቴ ዹሚና ሃንታሢ ፖዒ ባኣያታሢሮ ዹቂንታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ዬሱሴ ዬያ ጌዔስካፓ፦ «ኑኡኮ ላጋሢ ዓላዜሬ ጊንዔኔ፤ ታኣኒ ጋዓንቴ ጊንዓስካፓ ዒዛ ጴቻኒ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ዒዛኮ ጊንፆ ሃንታዞንሢያ፦ «ጎዳሢዮ! ጊንዔያ ማዔቴ ዒዚ ፖዔኔ ጌይሢኬ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ዬሱሴኮ ዬያ ጌይፃ ዓላዜሬ ሃይቄኔ ጌይፆኬ፤ ዔያቶም ጋዓንቴ ጊንዖ ዛላ ኬኤዚንቴያ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ዬያሮ ዬሱሴ ፔጌና ዔያቶም፦ «ዓላዜሬ ሃይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ዒንሢ ጉሙርቃንዳጉዲ ታኣኮ ዒኢካ ባኣያ ማዒፃ ዒንሢ ዛሎ''ሮ ሚርጌ ታኣም ኮሺ ማዔኔ፤ ሃሢ ጋዓንቴ ኑኡኒ ዒዛ ባንሢ ዓኣዾም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ዬማና ሱ'ንፃ «ሜንቴ» ጌይንታ፥ ቶኦማኣሴ ሃንጎዋቶ ኮራ፦ «ኑኡኒያ ዬሱሴና ዎላ'' ሃይቃኒ ዓኣዾም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ዬሱሴ ዓላዜሬ ዓኣ ቤዞ ሄላ''ኣና ዓላዜሬ ዱኡኪንቴንቴ ዖይዳሳ ኬሊ'' ማዔያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ቢታኒያ ዬሩሳላሜይዳፓ ሃካሢ ሃይሦ ሺያ ታኣኪሢ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ማርታና ጌሮ ማይራሞናኮ ጌርሲ ሃይቄሢሮ ዶዲሻኒ ሚርጌ ዓይሁዴ ዓሲ ዔያቶ ኮይላ'' ሙኪ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታ ዬሱሴኮ ሙኪፆ ዋይዛዖ ጎይሣ ዔካኒ ዴንዴኔ፤ ማይራማ ጋዓንቴ ጋራ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታ ዬሱሴ ኮራ፦ «ጎዳሢዮ! ኔኤኒ ዎንዴ ሃይካ ዓኣቴ ታ ጌርሲ ሃይቂንዱዋያታንቴኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ሓሢታቴያ ኔኤኒ ሺኢቃ ባኮ ቢያ ፆኦሲ ኔኤም ዒንጋንዳሢ ታ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ዬሱሴ ማሃዖ፦ «ጌርሲ ኔኤኮ ሃይባ''ፓ ዔቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርታ ዒማ''ና፦ «ጋፒንፆ ዎዶ''ና ሃይባ''ፓ ዔቃንዳሢ ታ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ዬሱሴ ማሃዖ፦ «ሃይቢፓ ዔቂሳሢና ናንጊና ናንጊ ዒንጋሢ ታናኬ፤ ታና ጉሙርቃሢ ሃይቄቴታዖ ናንጊና ናንጋንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ታኣና ናንጋሢ ሃሣ ታና ጉሙርቃሢ ቢያ ፔቴ''ታዖ ሃይቃዓኬ፤ ዬያ ኔ ጉሙርቃ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ዒዛኣ፦ «ሂዮ፥ ጎዳ! ኔኤኒ ሃያ ዓጮ'' ‹ሙካንዳኔ› ጌይ ኑ ካፓ፥ ፆኦሲ ናኣዚ''፥ ሜሲሔ ማዔሢ ታ ኔና ጉሙርቃኔ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርታ ዬያ ጌዔሢኮ ጊንፃ ዴንዲ ጌሮ ማይራሞ ኮራ፦ «ዔርዛሢ ሙኪ ኔና ዔኤላ''ኔ» ጌይ ዴሚና ዒዞ ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ማይራማ ዬያ ዋይዛዖ ዑኬ ዔቂ ዒዚ ዓኣ ቤዞ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ዬሱሴ ዒማ''ና ማርታ ዎንዴ ዒዛ ጎይሢና ዔኬ ቤዞይዳፓ ሃጊ ሃንጋ ጉርዶ ጌሊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ዒዞ ዶዲሻኒ፥ ማኣሮይዳ ዎላ'' ዓኣ፥ ዓይሁዶ ዓሳ ማይራማ ዑኬና ዔቂ ኬስካሢ ዛጋዖ ዓላዜሬኮ ዱኡፖ ቤዞ ዓኣዺ ዬኤካንዳያ ዔያቶም ማሌሢሮ ዒዞ ጊንፆ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማይራማ ዬሱሴ ዓኣ ቤዞ ሙኪ ዒዛ ዴንቄስካፓ ቶኮ'' ዴማ'' ሎኦማዖ፦ «ጎዳሢዮ! ኔኤኒ ዎንዴ ሃይካ ዓኣያታቶ ታኣኮ ጌርሲ ሃይቂንዱዋያታንቴኬ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ዬሱሴ ዒዞንታ ዒዞ ኮይላ'' ዓኣ ዓይሁዶ ዓሳ ዬኤካሢ ዛጊ ዒናፓ ዲቃቲ ዖያዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«ዒንሢ ዒዛ ዎካ ዱኡኬይ?» ጋዓዛ፥ ዔያታ ማሃዖ፦ «ጎዳሢዮ! ሃኒ ሙኪ ዛጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ዒማ''ና ዬሱሴ ዓቢቲ ዬኤኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ዬያሮ ዓይሁዶ ዓሳ፦ «ዎዚ ዒዛ ናሽካቴያ ሂንዳ ዛጉዋቴ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ዔያቶይዳፓ ፔቴ'' ፔቴ''ዞንሢ ጋዓንቴ፦ «ዓኣፖ ባይቄሢኮ ዓኣፖ ዒ ቡሌ''ኔ፤ ዓካሪ ሃይ ዓሢ ሃይቁዋጉዲ ቃዙዋዖ ዓይጋ ዒ ሃሼራ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ዬሱሴ ዒማ''ና ዻጋዺ ዱኡፖ ቤዞ ዓኣዻኔ፤ ዱኡፖ ዔቶ'' ካራ'' ሹቺና ዎዺንቴያ ዴኔ ቆኦፔኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ዬሱሴ ዔያቶ ኮራ፦ «ሹጫሢ ሺኢሹዋቴ» ጋዓዛ፥ ሃይቄሢኮ ጌራ፥ ማርታ፦ «ጎዳሢዮ! ዒዚ ሃይቄንቴ ዖይዶ ኬሊ''ኬ፤ ሃሢ ዛዛዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ዬሱሴ ዒዞም ማሃዖ፦ «ኔኤኒ ጉሙርቄቶ ፆኦሲኮ ቦንቾ ኔ ዛጋንዳኔ፤ ቤርታ ታ ኔኤም ጌይባይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ዓሳ ዬማና ሹጫሢ ሺኢሼኔ፤ ዬካፓ ዬሱሴ ሌካ ዼ'ግ ጌይ ዛጋዖ፦ «ታ ዓዳሢዮ! ኔ ታኣም ዋይዜሢሮ ታ ጋላታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ቢያ ዎዴና ኔ ታኣም ዋይዛሢያ ታ ዔራኔ፤ ጋዓንቴ ዬያ ታ ጋዓሢ ሃይካ ዔቂ ዓኣ ዓሳ ኔኤኒ ታና ዳኬያ ማዔሢ ዔሪ ጉሙርቃንዳጉዲ ጌይኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ዬሱሴ ዬያ ጌዔስካፓ፦ «ዓላዜሬ! ሃኒ ኬስኬ!» ጌይ ዑኡዞ ዼ'ግዲ ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ሃይቄ፥ ዓላዜሬያ ዱኡፓፓ ኩጮና ቶኮ''ና ዒዛኮ ሱኡዲ ቱኮ''ና ጎይሣ ዓኣፖ ካራ''ኣ ዓፒሎ ቱርጮና ማርቴ ጎይሣ ዓኣንቴ ኬስኬኔ፤ ዬካፓ ዬሱሴ፦ «ቡሊ'' ዒዛ ሃሹ''ዋቴ፥ ዒ ዴንዶም» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ማይራሞ ዶዲሻኒ ሙኬ፥ ዓይሁዶ ዓሶይዳፓ ሚርጌሢ ዒ ማዼ ባኮ ዛጋዖ ዬሱሴ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ፔቴ'' ፔቴ'' ዓሳ ጋዓንቴ ፔርሴ ዓሶ ባንሢ ዴንዲ ዬሱሴ ማዼ ባኮ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ዬያሮ ቄኤሶኮ ሱኡጎና ፔርሴ ዓሶና ዎጎ ዎጋ ዓሶ ቡኩሳዖ፦ «ሓይ ዓሢ ሚርጌ ፆኦሲ ዎልቄና ማዺንታ፥ ዓኪ ባኣዚ'' ማዻሢሮ ኑ ዎዴቴ ኮሽካንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ጉሪ ኑ ዒዛ ሃሼ''ቴ ዓሲ ቢያ ዒዛ ጉሙርቃንዳኔ፤ ሮሜ ዓሳኣ ሙኪ ኑኡኮ ጌኤዦ ማኣሮና ኑኡኮ ዴሮ''ና ቢያ ባይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ዬኖ ሌዖና ቄኤሶኮ ሱኡጎ ማዒ ዓኣ፥ ዔያቶይዳፓ ፔቴ''ሢ፥ ቃያፓ፦ «ዒንሢ ዔኤቢ ፔቴ''ታዖ ዔሩዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ዴራ'' ቢያ ባይቃሢዳፓ ፔቴ'' ዓሲ ዴሮ'' ዛሎ''ሮ ሓይቄቴ ኮሺ ማዔሢ ዒንሢ ዔሩዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ዒዚ ዬያ ጌዔሢ ፔ ቶኦካ''ፓ ማሊ ዔኪቱዋሴ፤ ጋዓንቴ ዬኖ ሌዖና ዒዚ ቄኤሶኮ ሱኡጌ ማዔሢሮ ዬሱሴ ዴሮ'' ዛሎ'' ሃይቃንዳሢ ፆኦሲ ማሊሢ ዒ ኬኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ዒ ሃይቃንዳሢ ዴሮ'' ዛሎ'' ሌሊ ማዒባኣንቴ ዳኪንቴ ዱማ ዱማ ላኣሊንቲ ዓኣ ፆኦሲ ናኣቶ'' ፔቴ''ይዳ ቡኩሳኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ዬያሮ ዬኖ ኬላ''ፓ ዓርቃዖ ዔያታ ዬሱሴ ዎዻኒ ዞርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ዬካፓ ሴካ ዬሱሴ ዓይሁዴ ዓሶ ባኣካ'' ፔጌና ሃንቲባኣሴ፤ ጋዓንቴ ዬካፓ ኬስኪ ዓሲ ናንጉዋ ዳውሎ'' ኮይላ'' ዓኣ ዔፕሬኤሜ ጌይንታ ካታማ ዴንዲ፥ ዒኢካ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬላ'' ዑኬሢሮ ሚርጌ ዓሳ ዬና ቦንቾ ኬሌ''ላ ሄላ''ንዳሢኮ ቤርታ ፔና ጌኤሺፆ ዎጎ ኩንሣኒ ዓጫ''ፓ ዓጫ''ፓ ዬሩሳላሜ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ዔያታ ዬሱሴ ኮዓያታሢሮ ጌኤዦ ማኣሮይዳ፦ «ዓይጎ ዒንሢም ማላይ? ሃኖ' ቦንቾ ኬሎ'' ቤዞ ዒ ሙካንዳያ ዒንሢም ማሉዋይ?» ጌይ ጌይ ዎሊ ዖኦጫኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ቄኤሶኮ ሱኡጎና ፔርሴ ዓሶና ዬሱሴ ዓርቃኒ ዒ ዓኣ ቤዞ ዔራ ዓሲ ዓኣቶ ዔያቶም ኬኤዛንዳጉዲ ዓሲ ቢያም ቤርታ ኬኤዜያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ኬሎ'' ቦንቻኒ ላሆ'' ኬሊ'' ዓታዛ ዬሱሴ ቢታኒያ ጎዖ ጉርዳ ዓኣዼኔ፤ ዬሱሴ ሃይባ''ፓ ዔቂሴ፥ ዓላዜሬ ናንጋሢ ዬኖ ጉርዴሎይዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ዬሱሴም ዒኢካ ዬኖ ዋንቴሎ ሙኡዚ'' ጊኢጊሺንቴኔ፤ ዬኖ ሙዖ ሙኡዛዛ ማርታኬ፤ ዬማና ሙዓኒ ዴዔ ዓሶይዳፓ ዓላዜሬ ፔቴ''ሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ዒማ''ና ማይራማ ሻንቾናቴ ሚርጌ ሚኢሼ ኬሳ''ንዳያ፥ ቦንቺንቴ፥ ናርዶሴ ጌይንታ ሳውቃ ቲሺ ዶሎዜኮ ጊዲሚሺ ማዓንዳያ ዔኪ ሙኪ ዬሱሴኮ ቶካ'' ዋሄኔ፤ ዬካፓ ዒዞኮ ቶኦኮ'' ጋፓኖና ቶኮ ዑጬኔ፤ ዬኖ ኬኤፄሎኮ ጋራ ቲዦ ሳዎና ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ዬሱሴኮ ጊንፆ ሃንታ ናኣቶ''ይዳፓ ፔቴ''ሢ፥ ዒዛ ዓኣሢ ዒንጋንዳ ዓስቆሮንቶ ካታማፓ ማዔ ዪሁዳ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«ሓይ ሳውቃ ቲዣ ፔቴ'' ዓሲ ሃይሦ ፄኤታ ኬሊ'' ማዼም ዒንጎንዶ ሚኢሼም ሻንቺንቲ፤ ሚኢሻ ማንቆ ዓሶም ዓይጎሮ ዒንጊንቱዋይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ዒዚ ዬያ ጌዔሢ ማንቆ ዓሶ ሚጪንቲቱዋንቴ ዉሲ ማዔሢሮኬ፤ ዒማና ዒዚ ሚኢሼ ዓርቃያ ማዔሢሮ ሚኢሾ ዒ ጌሣ ቤዛፓ ዔኪ ዔኪ ዔሬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ዬሱሴ፦ «ታኣኒ ዱኡኪንታንዳ ኬሎ''ም ዒዛ' ታና ጊኢጊሻያ ማዔሢሮ ዒዞ ሃሹ''ዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ማንቆ ዓሳ ቢያ ኬሊ'' ዒንሢና ዎላ''ኬ። ታኣኒ ጋዓንቴ ቢያ ኬሊ'' ዒንሢና ዎላ''ቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ዬማና ሚርጌ ዓይሁዴ ዓሲ ዬሱሴ ቢታኒያይዳታሢ ዔሪ ሙኬኔ፤ ዔያታ ሙኬሢ ዬሱሴ ዛሎ''ሮ ሌሊቱዋንቴ ዬሱሴ ሃይባ''ፓ ዔቂሴ፥ ዓላዜሬያ ዛጋኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ዬያሮ ቄኤሶኮ ሱኡጋ ዓላዜሬያ ዎዻኒ ዞርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ዓይጎሮ ጌዔቶ ዒዛይዳፓ ዔቄያና ሚርጌ ዓይሁዴ ዓሳ ፔኤኮ ዔኪ ዓኣዻ ዓሶ ሃሺ'' ሃሺ'' ዬሱሴ ጉሙርቃሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ዚሮ ጉቴሎ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ'' ቦንቻኒ ሙኬ፥ ሚርጌ ዓሳ ዬሱሴ ዬሩሳላሜ ሙካያ ማዔሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ዬያሮ ዔያታ ዒማ''ና ዓኣዔ ሜኤፄ ዓርቂ ኬስካዖ፦ «ፆኦሲ ጋላቲንቶም! ጎዳ ሱ'ንፆና ሙካ፥ ዒስራዔኤሌኮ ካኣታሢ ዓንጂንቴያኬ!» ጌይ ጌይ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ዬሱሴ ሃሬ ናይ ዻካ'' ዴንቃዖ ዒማ'' ቶጌኔ፤ ዬይ ያዺ ማዔሢ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«ሃና'' ኔኤኒ፥ ፂዮኔ ካታሜሌ፥ ዬሩሳላሜ ዒጊጪፖ፤ ሓይሾ ኔኤኮ ካኣታ''ሢ ሃሬ ናይ ቶጊ ሙካኔ» ጌይንቲ ፃኣፒንቴሢ ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ዬሱሴኮ ጊንፆ ሃንታዞንሢም ዬይ ባካ ቤርታ ዔርቲባኣሴ፤ ጋዓንቴ ዬሱሴ ቦንቾና ሌካ ጫሪንጮ ዔውቴ ዎዶ''ና ዬይ ባካ ዒዛ ዛሎ'' ፃኣፒንቴሢና ሃሣ ዒዛም ማዺንቴሢ ዔያታ ጶቂሲ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ዬሱሴ ዓላዜሬ ዱኡፓፓ ዔኤሊ''፥ ሃይባ''ፓ ዔቂሳማና ዒዛና ዎላ'' ዓኣ ዓሳ ቢያ ዒዚ ዓላዜሬ ሃይባ''ፓ ዔቂሴሢ ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ሚርጌ ዓሳ ዬሱሴ ጎይሣ ዔካኒ ኬስኬሢ ዬያ ፆኦሲ ዎልቆና ማዺንቴ ዓኮ ባኮ ዒ ማዼሢ ዋይዜሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ዒማ''ና ፔርሴ ዓሳ፦ «ሃኣዛጉዋቴ፤ ዴራ'' ቢያ ዒዛ ጊንፆ ኬስኬኔ! ኑ ፔቴ'' ባኣዚ''ታዖ ማዻኒ ዳንዳዑዋኣሢ ዒንሢ ዛጋ?» ዎሊ ኮይላ'' ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ዬኖ ቦንቾ ኬሎ''ና ዚጊ ካኣሽኮሮ ዬሩሳላሜ ዓኣዼ ዓሶ ባኣካ'' ፔቴ'' ፔቴ'' ጊሪኬ ዓጪ ዓሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ዔያታ ጌሊላይዳ ቤቴሳይዳ ጌይንታ ዓጮ'' ዓሢ ማዔ፥ ፒልጶሴ ኮራ ሙኪ፦ «ጎዳሢዮ! ዬሱሴ ዛጋኒ ኑ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፒልጶሴ ዴንዲ ዒንዲራሴም ኬኤዜኔ፤ ዬካፓ ዒንዲራሴና ፒልጶሴና ዴንዲ ጊንሣ ዬሱሴም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ዬሱሴ ዔያቶም፦ «ሓይሾ ዓካሪ ዓሲኮ ናዓሢ ቦንቺንታ ዎዳ'' ሄሌ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዓሲ ሃይቂ ዱኡታሢጉዲ ጉምቡሦኮ ፔቴ'' ዓኣፒ ዱኡቂንቲባኣያታቴ ፔኤሮ ሌሊ ማዒ ዓታኔ፤ ጋዓንቴ ዱኡቂንቴያታቴ ሚርጌ ዓኣፒ ዓኣፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ፔኤኮ ናንጎ ፆኦሲፓ ባሼ ናሽካሢ ባይዛንዳኔ፤ ሓያ ዓጮ''ይዳ ፔ ናንጎይዳፓ ባሼ ፆኦሲ ናሽካሢም ጋዓንቴ ናንጊና ናንጊ ጊኢጊ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ታኣም ማዻኒ ኮዓሢ ታ ጊንፆ ሙኮንጎ፤ ታኣኒ ዓኣ ቤዞይዳ ታኣም ማዻሢያ ዒኢካ ማዓንዳኔ፤ ታኣም ማዻሢ ታ ዓዴ ዒዛ ቦንቻንዳኔ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ዬካፓ ዬሱሴ፦ «ዓካሪ ታኣኮ ሼምፔላ ሚርጌና ሜታዼኔ፤ ‹ታ ዓዳሢዮ! ሃያፓ ታና ኔ ዻቂሼ ጎዖንዶ?› ዬያ ታ ጎዑዋጉዲ ታኣኒ ሙኬሢ ሃኖ'' ሜቴሎምኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ታ ዓዳሢዮ! ኔኤኮ ሱ'ንፆ ቦንቼ» ጌዔኔ። ዬካፓ፦ «ታኣኮ ሱ'ንፆ ታ ቦንቼኔ፤ ሃሣ ታ ቦንቻንዳኔ!» ጋዓ ዑኡሲ ጫሪንጫፓ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ዒኢካ ዔቂ ዓኣ ዓሳ ዬያ ዑኡዞ ዋይዛዖ፦ «ጉጉንሢኬ!» ጋዓዛ፥ ዛላ'' ሃሣ፦ «ፆኦሲ ኪኢታንቻ ዒዛና ጌስታኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ዬሱሴ ጋዓንቴ፦ «ሓይ ዑኡዛ ዒንሢም ኬኤዚንቴያ ማዓንዳኣፓዓቴም ታኣም ኬኤዚንቴያቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ዓጫ'' ሃይ ዎጊንታንዳ ዎዳ'' ሃሢኬ፤ ሃያ ዓጮ'' ዎይሣ ፃላሄ ዙላ'' ኬኤሪንታንዳሢያ ሃሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ታኣኒ ሳዓፓ ዼ'ግ ጌዔ ዎዶ''ና ዓሳ ቢያ ታ ባንሢ ሙኪ ዻቃንዳጉዲ ታ ማሃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ዬሱሴ ዬያ ጌዔሢ ዎዚጉዴ ጎይሢና ዒ ሃይቃንዳቴያ ዔርዛኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ዓሳኣ ማሃዖ፦ «ኑኡኮ ዎጎይዳ ፃኣፒንቴም ኑ ዛጋሢ ‹ሜሲሔ ናንጊና ናንጋኔ› ጋዓያኬ፤ ዓካሪ ኔኤኒ ‹ዓሲኮ ናዓሢ ዼ'ግ ጋዓንዳያ ኮይሳኔ› ዎዲ'' ጋዓይ? ዬይ ዓሲኮ ናዓሢ ዖናዳይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ዬሱሴ ዔያቶም፦ «ሓሢ ዻካ'' ዎዴ ዒንሢም ፖዒኬ፤ ጎይፃኣ ዒንሢ ዓኣንቴ ዒንሢም ዹሙዋንቴ፥ ፖዓ ዓኣ ጎይሣ ዓኣንቴ ሃንቱዋቴ፤ ዹሚና ሃንታሢ ዓንኮ ዴንዳቴያ ዔሩዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ዒንሢ ፖዒ ናይ ማዓንዳጉዲ ዒንሢኮ ፖዓሢ ዓኣንቴ ፖዓሢ ጉሙርቁዋቴ» ጌይ ማሄኔ። ዬሱሴ ዬያ ዔያቶም ኬኤዛዖ ዓኣፓፓ ዔያቶኮ ዓኣሺንቲ ባይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ዬሱሴ ዬያ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮ ዔያቶ ቤርቶይዳ ማዼቶዋ ዓይሁዶ ዓሳ ዒዛ ጉሙርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ዬይ ያዺ ማዔሢ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ፦ «ጎዳሢዮ! ኑኡኮ ማርካቶ ዖኦኒ ጎኔኬ ጌዔይ? ፆኦሲ ዎልቃ ሃሣ ዖኦም ጴዼይ?» ጌዒ ኬኤዜ ቃኣላ'' ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ዬያሮ ዔያታ ጉሙርቃኒ ዳንዳዒባኣሴ፤ ዓይጎሮ ጌዔቴ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«ዔያታ ፔኤኮ ዓኣፖና ዛጊ ሃሣ ዒኖና ጶቂሢ ፆኦሲ ባንሢ ማዒ ዔያታ ዻቁዋጉዲ ዒዚ ዔያቶኮ ዓኣፖ ባይዜኔ፤ ሃሣ ዒኖዋ ዶጪሴኔ» ሂዚ ጌዒ ፃኣፔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ዒሲያሴ ዬያ ጌዔሢ ሜሲሔኮ ቦንቾ ዛጌሢሮኬ፤ ዬያሮ ሂዚ ጌዒ ዬሱሴ ዛሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ያዺ ማዔቴያ ዓይሁዶ ዓሶኮ ሱኡጎይዳፓ ሃሣ ሜሌ'' ሚርጌ ዓሲያ ዬሱሴ ጉሙርቄኔ፤ ጋዓንቴ ዓይሁዶ ዓሳ ፔኤኮ ቡኪንቶ ቤዛፓ ዔያቶ ኬሱ''ዋጉዲ ፔርሴ ዓሶ ዒጊጬሢሮ ፔጌና ዔያታ ዬሱሴ ጉሙርቃያ ማዔሢ ዔርዙዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ዬያ ዔያታ ማዼሢ ፆኦሲ ዔያቶ ናሽካሢፓ ባሼ ዓሲና ናሽኪንታኒ ኮዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ዬሱሴ ዒማ''ና ዑኡዞ ዼ'ጊዲ፦ «ታና ጉሙርቃሢ ታና ሌሊቱዋንቴ ታና ዳኬሢያ ጉሙርቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ታና ዛጋሢ ታና ዳኬሢያ ዛጋኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ታና ጉሙርቃሢ ቢያ ዹሚዳ ናንጉዋጉዲ ታኣኒ ፖዔ ማዒ ሃያ ዓጮ'' ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ታኣኮ ቃኣሎ'' ዋይዚ ማዾይዳ ፔኤሹዋኣሢዳ ዎጋንዳሢ ታናቱዋሴ፤ ዓይጎሮ ጌዔቴ ታኣኒ ሙኬሢ ዓጮ'' ዻቂሻኒ ማዓንዳኣፓዓቴም ዓጮ''ይዳ ዎጋኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ታና ኮዑዋኣሢና ታኣኮ ቃኣሎ''ዋ ዔኩዋ ዓሶይዳ ዎጋንዳያ ዓኣኔ፤ ዬይያ፦ ታኣኒ ኬኤዛ ቃኣላ'' ጋፒንፆ ኬሎ''ና ፔኤሮ ዎጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ዓይጎሮ ጌዔቶ ታኣኒ ታ ቢታንቶና ኬኤዚባኣሴ፤ ታኣኒ ጋዓ ባኮና ኬኤዛ ዓይሢፆ ታኣም ዒንጌሢ ታና ዳኬ ዓዶኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ዒዛኮ ዓይሢፃ ናንጊና ናንጊ ሼምፖ ዒንጋሢ ታ ዔራኔ። ዬያሮ ታኣኒ ኬኤዛሢ ዓዴ ታኣም ኬኤዜሢኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ዬሱሴ ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ኮ ቤርታ ሓያ ዓጮ'' ሃሺ'' ሌካ ዓዶ ባንሢ ዓኣዻንዳሢ ዔሬኔ፤ ዬያሮ ሃያ ዓጮ''ይዳ ዓኣ፥ ዒዛም ማዔዞንሢ ቢያ ዒ ናሽኬኔ፤ ሃሣ ሜቶ ጉቤ ዔያቶ ዛሎ'' ዔካኒ ጋፒንሢ ዒ ዔያቶ ናሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ዬሱሴና ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ሙኡዚ'' ሙዓንቴ፦ ሲሞኦኔ ናዓሢ፥ ዓስቆሮንቶ ካታሞ ዓሢ፥ ዪሁዳ ዬሱሴ ዓኣሢ ዒንጋንዳጉዲ ፃላሄ ዒዛኮ ዒኖይዳ ፑርታ ማሊሢ ጌልዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ዓዴ ቢታንቶ ቢያ ዒዛም ዒንጌሢና ፆኦሲ ዳኬም ዒ ሙኬሢ ሃሣ ፆኦሲ ባንሢያ ማዒ ዴንዳንዳሢ ዬሱሴ ዔራዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ሙዖይዳፓ ዔቂ፥ ዓፒሎ ፔኤኮ ጌሢ ዋኣሢ ማስቴስካፓ ዑጪንቶ ማርፆ ዔኪ ኬርና ቱኡቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ዬካፓ ቶኮ ማስቶ ጋባዶይዳ ዋኣሢ ዋሃዖ ፔኤኮ ጊንፆ ሃንታዞንሢኮ ቶኮ ማስኪ ማስኪ ኬርና ዒ ቱኬ'' ዑጪንቶ ማርፄሎና ዔያቶኮ ቶኮ ዑጪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ዬሱሴ ዬያይዴ ጎይሣ ሲሞኦኔ ጌይንታ ጴፂሮሴ ኮራ ሙካዛ ጴፂሮሴ፦ «ጎዳሢዮ! ኔኤኒ ታ ቶኮ ማስካንዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ዬሱሴ ማሃዖ፦ «ታኣኒ ማዻ ባኮ ሃሢ ኔ ዔራዓኬ፤ ጊንፃፓ ጋዓንቴ ኔ ዔራንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ጴፂሮሴ ማሃዖ፦ «ኔኤኒ ታ ቶኮ ፔቴ''ታዖ ማስካዓኬ» ዒዛም ጋዓዛ፥ ዬሱሴ፦ «ታኣኒ ኔኤኮ ቶኮ ማስኪባኣታቴ ታኣና ዎላ'' ፔቱሞ ኔኤኮ ባኣሴ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ጴፂሮሴ ማሃዖ፦ «ጎዳሢዮ! ያዺ ማዔቶ ታኣኮ ቶኮ ሌሊቱዋንቴ ኩጮንታ ሃሣ ቶኦኮ''ዋ ታኣኮ ማስኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ዬሱሴ ማሃዖ፦ «ዑፆ ማስቴሢኮ ዑፃ ጌኤሺታሢሮ ቶኮ ማስቲሢዳፓ ዓታዛ ሜሌ'' ዒዛም ኮይሱዋሴ፤ ዒንሢ ሃሢ ጌኤሺኬ፤ ጋዓንቴ ቢያሢ ዒንሢ ጌኤሺቱዋሴ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ዬሱሴ፦ «ቢያሢ ዒንሢ ጌኤሺቱዋሴ» ጌዔሢ ዓኣሢ ዒዛ ዒንጋንዳሢ ዖናታቴያ ዔራሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ቶኮ ዔያቶኮ ዒ ማስኬስካፓ ፔኤኮ ማኣዓሢ ማይንቲ ፔ ቤዞይዳ ዴዓዖ፦ «ታ ዒንሢም ዓይጎ ማዼቴያ ዒንሢ ጶቂሢ ዔሪያ?» ");
INSERT INTO mdybse_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ዒንሢ ታና፦ «ዔርዛሢ ሃሣ ጎዳ» ጋዓኔ፤ ታኣኒ ዔርዛሢ ሃሣ ጎዳ ማዔሢሮ ዒንሢ ጌዔሢ ጎኔኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ዓካሪ ታኣኒ ዒንሢኮ ጎዳ ሃሣ ዔርዛሢታዖ ቶኮ ዒንሢኮ ማስኬቶ ዒንሢ ዎሊኮ ቶኮ'' ማስካንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ታኣኒ ዒንሢም ማዼ ባኮ ዒንሢያ ማዻንዳጉዲ ማላታ ታ ዒንሢም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ጎኔ ታ ዒንሢም ጋዓኔ፥ ማዻሢ ፔ ጎዳፓ ባሼቱዋሴ፤ ኪኢቲንታዞንሢያ ሓሣ ኪኢታሢዳፓ ባሹዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ዬያ ባኮ ዒንሢ ዔሪ ማዾይዳ ፔኤሼቶ ዓንጂንቴያ ዒንሢ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«ሓያ ታ ኬኤዛሢ ዒንሢ ቢያሢ ዛሎ''ሮቱዋሴ፤ ታ ዶኦሬዞንሢ ታ ዔራኔ፤ ጋዓንቴ ‹ታኣና ዎላ'' ካሦ ሙዔሢ ታኣኮ ሞርኬ ማዔኔ› ጌይንቴ ጌኤዦ ማፃኣፖ ቃኣላ'' ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ዬይ ማዓንዳሢኮ ቤርታ ሃሢ ታኣኒ ዒንሢም ቤርታሲ ኬኤዛሢ ዬይ ኩሜስካፓ ታ ዖኑሞ ዒንሢ ጉሙርቃንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ጎኔ ታ ዒንሢም ጋዓኔ፤ ታኣኒ ዳኬሢ ጎኔኬ ጌይ ዔካሢ፦ ታና ዔካኔ፤ ታና ዔካሢያ ሃሣ ታና ዳኬሢያ ጎኔኬ ጌይ ዔካኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ዬሱሴ ዬያ ጌዔስካፓ ማሊ ሜታዻዖ፦ «ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒንሢዳፓ ፔቴ''ሢ ዓኣሢ ታና ዒንጋንዳኔ» ጌይ ፔጋሲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ዒዛኮ ጊንፆ ሃንታዞንሢ ዬያ ዒ ዖናኬ ጌይ ጋዓቴያ ዔሪባኣሢሮ ዎሊ ሴካ ሃንጋ ዛጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ዬሱሴ ዒዛ ናሽካ፥ ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ''ሢ ዬሱሴ ሄሊ'' ዴዒ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ሲሞኦኔ ጌይንታ ጴፂሮሴ ዬያ ዉታዖ፦ «ዒ ዬያ ዖናኬ ጌይ ጋዓቴያ ሂንዳ ዬሱሴ ዖኦጬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ዬያሮ ዒዚ ዬሱሴ ባንሢ ዛላዺ ሂርኪ ጌዔስካፓ፦ «ጎዳሢዮ! ዬይ ዖናዳይ?» ጌይ ዒዛ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ዬሱሴ ማሃዖ፦ «ሃይ፥ ካሦ ታ ዎፆና ዓይሢ ዔኪ ኩልሳንዳሢ ዒዛኬ» ጌዔኔ። ዬያ ጌዔስካፓ ካሦ ዎፆና ዓይሢ ዔኪ ዓስቆሮንቶ ካታሞ ዓሢ፥ ሲሞኦኔ ናኣዚ''፥ ዪሁዳ ኩልሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ዪሁዳ ካሦ ኩኡሌስካፓ ቤዞማና ፃላሄ ዒዛይዳ ጌሌኔ፤ ዒማ''ና ዬሱሴ ዪሁዳም፦ «ኔኤኒ ማዻኒ ማሌ ባኮ ሃሢ ዑኬና ማዼ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ዬሱሴ ዓይጎሮ ዬያ ጌዔቶዋ ሙዖይዳ ዴዔዞንሢዳፓ ዖኦኒያ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ዪሁዳ ሚኢሾ ዓርቃያ ማዔሢሮ ዬሱሴኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ'' ፔቴ''ዞንሢም ዒዚ፦ «ቦንቾ ኬሎ''ም ኮይሳ ባኣዚ'' ኑም ሻንቄ፤ ሃሣ ማንቆ ዓሶም ሚኢሼ ዒንጌ» ዪሁዳም ጌዔያ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ዪሁዳ ዬኖ ካሦ ኩኡሌሢዳፓ ቤዞማና ኬስኪ ዓኣዼኔ፤ ዬማና ሳዓ ዹሚኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ዪሁዳ ኬስኪ ዓኣዼስካፓ ዬሱሴ፦ «ዓካሪ ዓሲኮ ናዓሢ ቦንቺንቴኔ፤ ዒዛ ዛሎ''ና ፆኦዛሢያ ቦንቺንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ፆኦሲ ዒዛ ዛሎ''ና ቦንቺንቴያ ማዔቶ ፆኦሲያ ፔ ናዓሢ ፔኤና ዎላ'' ቦንቺሳንዳኔ፤ ኔጉዋዖ፥ ሃሢ ዒዛ ቦንቺሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ናይዮቴ! ታ ዒንሢና ዎላ'' ሚርጌ ዎዴ ዴዓዓኬ፤ ዒንሢያ ታና ኮዓንዳኔ፤ ዓይሁዶ ዓሶ ዎይሣ ዓሶም ‹ታኣኒ ዴንዳ ቤዞ ዒንሢ ሙካኒ ዳንዳዒንዱዋሴ› ታ ጌዔሢጉዲ ሃሢ ታ ዒንሢማኣ ያዺ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ዎሊ ዒንሢ ናሽካንዳጉዲ ዓኪ ዓይሥሢ ታ ዒንሢ ዓይሣኔ፤ ታ ዒንሢ ናሽኬሢጉዲ ዒንሢያ ዎሊ ናሽኩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ዎሊ ዒንሢ ናሽኬቴ ዒንሢ ታኣኮ ጊንፆ ሃንታዞንሢ ማዔሢ ዓሲ ቢያ ዬያና ዔራንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ዬካፓ ሲሞኦኔ ጌይንታ ጴፂሮሴ ዬሱሴ ኮራ፦ «ጎዳሢዮ! ኔኤኒ ዓንኮ ዴንዳንዳይ?» ጌይ ዒዛ ዖኦጫዛ፥ ዬሱሴ ማሃዖ፦ «ታኣኒ ዴንዳ ቤዞ ሃሢ ኔ ታ ጊንፆ ሙካኒ ዳንዳዒንዱዋሴ፤ ጊንፃፓ ኔ ጋዓንቴ ሙካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴፂሮሴ ጊንሣ፦ «ጎዳሢዮ! ዓይጎሮ ሃሢ ታ ኔ ጊንፆ ሙካኒ ዳንዳዑዋይ? ታኣኒ ታኣኮ ሼምፓሢታዖ ኔ ጋይቴ ዓኣሢ ዒንጋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ዬሱሴ፦ «ኔኤኒ ታ ጋይቴ ኔኤኮ ሼምፓሢ ዓኣሢ ዒንጋንዳ? ጎኔ ታ ኔኤም ጋዓኔ፤ ሃኖ'' ኮይዳ ቂኢቃንዳሢኮ ቤርታ ሃይሢ ማይንቲ ‹ታ ዒዛ ዔሩዋሴ› ኔ ታና ጋዓንዳኔ» ጌይ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ዬካፓ ዬሱሴ፦ «ዒንሢኮ ዒና'' ማሊ ሜታዾፓ፤ ፆኦሲ ጉሙርቁዋቴ፤ ታናኣ ጉሙርቁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ታ ዓዶ ኮሮይዳ ሚርጌ ናንጎ ቤሲ ዓኣኔ፤ ያዺ ማዒባኣታቴ ‹ዒንሢ ናንጋንዳ ቤዞ ታ ጊኢጊሻኒ ዓኣዻንዳኔ› ታ ዒንሢም ጌይንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ታኣኒ ዴንዲ ዒንሢም ቤዞ ጊኢጊሼስካፓ ታኣኒ ዓኣ ቤዞይዳ ዒንሢያ ናንጋንዳጉዲ ላሚ ታ ሙኪ ዒንሢ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ታኣኒ ዴንዳ ቤዞ ሄሊ''ሳ ጎይፆ ዒንሢ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ቶኦማኣሴ ዒማ''ና፦ «ጎዳሢዮ! ዓንኮ ኔ ዓኣዻቶዋ ኑ ዔሩዋሴ፤ ሂዳዖ ጎይፆ ኑ ዎዲ'' ዔራኒ ዳንዳዓንዳይ?» ዬሱሴ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ዬሱሴ ዒዛም፦ «ጎኑሞና ጎይፃሢና ሼምፓሢያ ታናኬ፤ ታ ዛሎ''ና ማዒባኣታዖ ዖኦኒያ ዓዶ ኮራ ሙካንዳይ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ታና ዒንሢ ዔሬያታቴ ታ ዓዶዋ ዒንሢ ዔሬያ ናንዳንቴኬ፤ ሃካፓ ሴካ ጋዓንቴ ዒንሢ ዔራንዳኔ፤ ዒዛ ዒንሢ ዛጌኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፒልጶሴ፦ «ጎዳሢዮ! ዓዶ ኑና ኔ ዻዌቴ ማይ ኑም ጊዳንዳኔ» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ዬሱሴ ዒዛም፦ «ፒልጶሴ! ሓያጉዴ ዎዴ ታ ዒንሢና ዎላ'' ናንጋዛ ኔ ታና ዔሩዋዓዳ? ታና ዛጌሢ ዓዶ ዛጌኔ፤ ሂዳዖ ዓካሪ ኔኤኒ ‹ዓዶ ኑና ዻዌ› ዎይቲ ጋዓይ? ");
INSERT INTO mdybse_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ታኣኒ ዓዶና ዎላ'' ዓኣሢ ሃሣ ዓዴያ ታኣና ማዔሢ ኔ ጉሙርቁዋዓዳ? ዒንሢም ኬኤዛ ቃኣሎ'' ታኣኒ ኬኤዛሢ ታ ቢታንቶናቱዋሴ፤ ጋዓንቴ ማዾ'' ቢያ ማዻሢ ታኣና ናንጋ፥ ዓዶኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ታኣኒ ዓዶና ዓኣሢጉዲ ዓዴያ ታኣና ዓኣሢ ታ ዒንሢም ኬኤዛሢ ጉሙርቁዋቴ፤ ዬይ ዓቴቴ ታኣኒ ማዻ ዓኮ ባኮ ዛሎ''ሮታዖ ታና ጉሙርቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ጎኔ ታ ዒንሢም ጋዓኔ፤ ታና ጉሙርቃሢ ታኣኒ ማዻ ማዾ'' ማዻንዳኔ፤ ዬያፓ ዑሣ ዓኣዼ ባኣዚ''ያ ማዻንዳኔ፤ ዓይጎሮ ጌዔቴ ታኣኒ ሌካ ታ ዓዶ ባንሢ ዴንዳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ዓዴ ናዓሢ ዛሎ''ና ቦንቺንታንዳጉዲ ታ ሱ'ንፆና ዒንሢ ሺኢቃ ባኮ ቢያ ታ ዒንሢም ማዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ዓይጎ ባኣዚ''ታቶዋ ታ ሱ'ንፆና ዒንሢ ሺኢቄቶ ታ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ዬሱሴ ሃሣ ኬኤዛዖ፦ «ታና ዒንሢ ናሽካያ ማዔቶ ታ ዓይሢፆ ዒንሢ ካፓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ታኣኒ ዓዶ ሺኢቃንዳኔ፤ ዒዚያ ናንጊና ዒንሢና ናንጋንዳ፥ ሜሌ'' ዶዲሻያ ዒንሢም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ዬያ ዶዲሻሢ ዓጫ'' ዴንቂንዱዋኣሢሮና ዔሪንዱዋኣሢሮ ዔካኒ ዳንዳዑዋሴ፥ ዬይ ጎኑሞ ዔርዛ ዓያናኬ፤ ዒንሢ ጋዓንቴ ዬያ ዔራንዳኔ፤ ዓይጎሮ ጌዔቴ ዒንሢና ዎላ'' ናንጋንዳሢሮና ዒንሢኮ ጋሮይዳ ማዓንዳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«ዓዶና ዒንዶናባኣ ናይጉዲ ታ ዒንሢ ዒንሢሮ ሌሊ ሃሺ''ንዱዋሴ፤ ማዒ ታ ዒንሢ ኮራ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ዻካ'' ዎዴኮ ጊንፃፓ ዓጫ'' ታና ዛጊንዱዋሴ፤ ዒንሢ ጋዓንቴ ታና ዛጋንዳኔ፤ ታኣኒ ናንጊና ባይቁዋያ ማዔሢሮ ዒንሢያ ናንጊና ባይቁዋያ ማዒ ናንጋንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ታኣኒ ዓዶና ዓኣሢ፥ ዒንሢያ ታኣና ዓኣሢ፥ ታኣኒያ ዒንሢና ዓኣሢ ዬኖ ኬሎ''ና ዒንሢ ዔራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«ታኣኮ ዓይሢፆ ዔካሢና ሃሣ ማዾይዳ ፔኤሻሢ፥ ዒዚ ታና ናሽካኔ፤ ታና ናሽካሢ ታ ዓዴያ ዒዛ ናሽካንዳኔ፤ ታኣ ዒዛ ናሽካንዳኔ፤ ታና ታ ዒዛም ፔጋሲ ዻዋንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ዓስቆሮንቶ ካታሞሲቱዋንቴ ሃንጎ ዪሁዳ፦ «ጎዳሢዮ! ኔና ዓጮ''ምቱዋንቴ ኑም ኔ ፔጋሲ ዻዋንዳሢ ዎይቲዳይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ዬሱሴ ዒዛም፦ «ታና ናሽካሢ ታ ቃኣሎ'' ካፓንዳኔ፤ ታ ዓዴያ ዒዛ ናሽካንዳኔ፤ ኑኡኒያ ዒዛ ኮይላ'' ሙኪ ዒዛና ዎላ'' ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ታና ናሽኩዋኣሢ ታ ቃኣሎ'' ካፒንዱዋሴ፤ ሃይ ዒንሢ ዋይዛ ቃኣላ'' ታና ዳኬ፥ ዓዶሮ ማዓንዳኣፓዓቴም ታኣሮቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ዬሱሴ ሃሣ፦ «ሓሢ ታ ዒንሢና ዎላ'' ዓኣዖ ሃያ ባኮ ታ ዒንሢም ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ዓዴ ታ ሱ'ንፆና ዳካ፥ ዶዲሻ ዓያኖ ጌኤዣ ጋዓንቴ ቢያ ባኣዚ'' ዒንሢ ዔርዛንዳኔ፤ ታ ዒንሢም ኬኤዜ ባኮዋ ቢያ ዒንሢ ጶቂሳንዳጉዲ ማሃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«ኮሹሞ ታ ዒንሢም ዒንጋንዳኔ፤ ሃሣ ታ ኮሹሞዋ ታ ዒንሢም ዒንጋንዳኔ፤ ታኣኒ ዒንሢም ዒንጋ ኮሹማ ዓጫ'' ዒንሢም ዒንጋሢጉዲቱዋሴ፤ ዒና'' ዒንሢኮ ማሊ ሜታዺ ዒጊጮፓ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ዬሱሴ ሃሣ ኬኤዛዖ፦ « ‹ታኣኒ ዒንሢ ኮራፓ ዓኣዻንዳኔ፤ ሃሣ ማዒያ ታ ዒንሢ ባንሢ ሙካንዳኔ› ታ ጌዔሢ ዒንሢ ዋይዜኔ፤ ታና ዒንሢ ናሽካያ ማዔቶ ዓዴ ታጊዳፓ ባሼታሢሮ ታኣኒ ዓዶ ባንሢ ዓኣዺፆና ዒንሢ ዎዛዻንዳያታዖኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ዬይ ያዺ ማዔ ዎዶ''ና ዒንሢ ጉሙርቃንዳጉዲ ዬይ ማዓንዳሢኮ ቤርታዺ ታ ዒንሢም ሃሢ ኬኤዜያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ሓያ ዓጮ'' ዎይሣ ፃላሄ ሙካሢሮ ሃካፓ ሴካ ታ ዒንሢና ዎላ'' ሚርጌ ጌስታዓኬ። ዒዚ ታ ጊዳ'' ፔቴ'' ባኣዚ''ያ ማዻኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ጋዓንቴ ታኣኒ ታ ዓዶ ናሽካሢ ዓጫ'' ዔራንዳጉዲ ዓዴ ታና ዓይሤ ባኮ ቢያ ታኣኒ ኩንሣንዳኔ፤ ‹ዓካሪ ሃካፓ ኑ ዴንዶም› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ዬካፓ ዬሱሴ፦ «ዎይኖ ሚፆኮ ጎኔ ፃጳሢ ታናኬ፤ ቱኪ'' ኮሻ''ሢ ታ ዓዶኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ታ ጊዳ'' ዓኣዖ ዓኣፑዋ ካኣፖ ቢያ ታ ዓዴ ቲቂ ኬኤራንዳኔ፤ ዓኣፖ ዓኣፓ ካኣፖ ጋዓንቴ ሚርጌ ዓኣፓንዳጉዲ ቲቂ ቲቂ ጊኢጊሺ ኮሻ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ታኣኒ ሃሢ ዒንሢም ኬኤዛ ቃኣሎ''ና ሃሢ ዒንሢ ጊኢጊሺ ኮሺ''ንቴዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ታኣና ናንጉዋቴ፤ ታኣኒያ ዒንሢና ናንጋንዳኔ፤ ካኣፓ ፃጶይዳ ማዒባኣያታቶ ፔ ቶኦኪና ሌሊ ዓኣፒ ዓኣፓኒ ዳንዳዑዋኣሢጉዲ ዒንሢያ ታኣና ናንጊባኣያታቶ ዓኣፒ ዓኣፓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«ታኣኒ ዎይኖ ሚፆኮ ፃጳሢኬ፤ ዒንሢ ካኣፖኬ፤ ሚርጌ ዓኣፒ ዓኣፓንዳሢ ታኣና ናንጋሢና ታኣኒያ ዒዛና ናንጋሢኬ፤ ዓይጎሮ ጌዔቶ ታ ባኣንቴ ዓይጎ ባኣዚ''ያ ዒንሢ ማዻኒ ዳንዳዑዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ታኣና ናንጉዋ ካኣፓ ዙላ'' ኬኤሪንቲ ሜላ ካኣፖጉዲኬ፤ ዬካፓ ቡኩሲ፥ ታሚና ሚቺንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ታኣና ዒንሢ ናንጌቴ ሃሣ ታ ቃኣላ'' ጋዓ ጎይፆዋ ዒንሢ ናንጋቶ ዒንሢ ኮዔ ባኣዚ'' ሺኢቄቴ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ሚርጌ ዓኣፒ ዒንሢ ዓኣፓኣና ታ ዓዴ ቦንቺንታኔ፤ ዬያይዲፆና ታኣኮ ጊንፆ ሃንታዞንሢ ማዒፆ ዒንሢ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ዓዴ ታና ናሽኬሢጉዲ ታኣኒያ ዒንሢ ናሽኬኔ፤ ዬያሮ ታ ናሹሞና ናንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ታኣኒ ታ ዓዶኮ ዓይሢፆ ኩንሤሢና ዒዛኮ ናሹሞናኣ ናንጌሢጉዲ ዒንሢያ ታ ዓይሢፆ ኩንሤቶ ታ ናሹሞና ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«ሓያ ታ ዒንሢም ኬኤዛሢ ታ ዎዛዼሢጉዲ ዒንሢ ዎዛዻንዳጉዲ ሓሣ ዒንሢኮዋ ዎዛ ዼኤፒ ማዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ታ ዓይሢፃ ታ ዒንሢ ናሽኬሢጉዲ ዒንሢያ ዎሊ ናሽካንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ዓሲ ፔኤኮ ሼምፓሢ ፔ ላጌ ዛላ ዓኣሢ ዒንጋያይዳፓ ባሻ ናሹሞ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ዒንሢያ ታኣኒ ዒንሢ ዓይሣሢ ኩንሤቶ ታኣኮ ላጌኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ዓይሌ'' ፔ ጎዳ ማዻ ባኮ ዔሩዋኣሢሮ ሃይካፓ ሴካ ታ ዒንሢ ታ ዓይሎ'' ጌይንዱዋሴ፤ ጋዓንቴ ታ ዓዶይዳፓ ታ ዋይዜ ባኮ ቢያ ዒንሢም ፔጋሲ ዔርዜሢሮ ታ ዒንሢ ታኣኮ ላጌ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ታ ዒንሢ ዶኦሬያፓዓቴም ዒንሢ ታና ዶኦሪባኣሴ፤ ዴንዲ ዒንሢ ሚርጌ ዓኣፒ ዓኣፓንዳጉዲ፥ ዒንሢኮ ዓኣፓኣ ናንጋያ ማዓንዳጉዲ፥ ታ ዒንሢም ቢታንቶ ዒንጌኔ። ዬያሮ ታ ሱ'ንፆና ዒንሢ ሺኢቃሢ ቢያ ዓዴ ዒንሢም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ዓካሪ ታ ዒንሢ ዓይሣሢ ዎሊ ዒንሢ ናሽካንዳጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ሄሊ''ሳዖ ዬሱሴ፦ «ዓጫ'' ዒንሢ ዒፄቶ ዒንሢኮ ቤርታ ታና ዒፄሢ ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ዒንሢ ዎንዴ ዓጮ''ሮ ማዔያታቶ ዓጫ'' ፔኤም ማዔሢ ዔሪ ዒንሢ ናሽካንዳያታንቴኬ፤ ዓጮ''ም ዒንሢ ማዒባኣሢሮና ታ ዒንሢ ሃሣ ዓጫ''ፓ ዱማሲ ዶኦሬሢሮ ዓጫ'' ዒንሢ ዒፃኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ዓይሢንቲ ማዻሢ ፔኤኮ ጎዳሢዳፓ ባሹዋሴ ጌይ ታ ዒንሢም ኬኤዜሢ ጶቂሱዋቴ፤ ታና ዔያታ ዒፂ ዳኬያታቶ ዒንሢያ ዔያታ ዒፂ ዳካንዳኔ፤ ታኣኮ ቃኣሎ'' ዔያታ ካፔያታቶ ዒንሢኮዋ ቃኣሎ'' ካፓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ታና ሎፓ ዳኬሢ ዖናታቴያ ዔያታ ዔሩዋኣሢሮ ታ ዛሎ''ሮ ዬያ ቢያ ዔያታ ማዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ታኣኒ ሙኪ ዔያቶም ዎንዴ ኬኤዚባኣያታቴ ጎሜ ዔያቶኮ ማዓዓታንቴ፤ ሃሢ ዔያታ ፔኤኮ ጎሞ ዛሎ'' ‹ኑ ዔሪባኣሴ› ጋዓንዳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ታና ዒፃሢ ታ ዓዶ ዒፃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ሜሌ'' ዓሲ ማዺባኣ ማዾ ዔያቶኮ ባኣካ'' ታ ማዺባኣያ ማዔቶ ጎሜ ዔያቶኮ ማዒንዱዋያታንቴ ሃሢ ሃያ ፆኦሲ ዎልቄና ማዺንቴ ዓኮ ባኮ ዔያታ ዛጌኔ፤ ጋዓንቴ ታናንታ ታ ዓዶንታ ዔያታ ዒፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ዬይ ያዺ ማዔሢ፦ ‹ዔኤቢ ታ ፑርቲሴ ባኣዚ'' ባኣንቴ ታና ዒፄኔ› ጌይንቲ ዔያቶኮ ዎጎይዳ ፃኣፒንቴ ቃኣላ'' ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«ጋዓንቴ ዓዶይዳፓ ኬስካያ ሃሣ ታኣኒያ ዓዶ ኮራፓ ዳካንዳ፥ ጎኑሞ ዔርዛ ዓያኖ ማዔ፥ ዶዲሻሢ ሙካዖ ታ ዛሎ'' ዒ ማርካዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ዒንሢያ ቤርታፓ ዓርቃዖ ታኣና ዎላ'' ዓኣሢሮ ታኣም ዒንሢ ማርካዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ዬካፓ ሃሣ ዬሱሴ፦ «ዓካሪ ሃይሾ ሓያ ቢያ ታ ዒንሢም ኬኤዛሢ ዒንሢ ዻቢንቱዋጉዲ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛፓ ዒንሢ ኬሲ'' ዳውሶንዶኔ፤ ዬካፓ ዑሣ ሓሣ ዒንሢ ዎዻሢ ቢያ ፆኦሲም ኮሺ ማዼያ ማዒ ፓይዲንታንዳ ዎዴ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ዬያ ዔያታ ማዻንዳሢ' ዓዶንታ ታናንታ ዔሩዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ሓያ ታ ዒንሢም ኬኤዛሢ ዎዳ'' ሄላ''ዛ ታ ዒንሢም ዓይጎ ጌዔቴያ ዒንሢ ጶቂሣንዳጉዲኬ። «ሓያ ባኮ ቤርታ ታ ዒንሢም ኬኤዚባኣሢ ታኣኒ ዒንሢና ዎላ'' ዓኣሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ዬሱሴ ሃሣ፦ «ታና ዳኬሢ ባንሢ ታ ዴንዳንዳኔ፤ ጋዓንቴ ዒንሢዳፓ ‹ኔኤኒ ዓንኮ ዓኣዻይ?› ጌይ ታና ዖኦጫንዳያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ማዔቶዋ ሓያ ቢያ ታ ዒንሢም ኬኤዜሢሮ ዒንሢኮ ዒና'' ዖዪ ማሊሢና ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ታኣኒ ጋዓንቴ ጎኔ ዒንሢም ጋዓኔ፥ ታኣኮ ዓኣዺፃ ዒንሢ ማኣዳ''ንዳያኬ፤ ዎይቲ ጌዔቶ ታኣኒ ዓኣዺባኣያታቴ ዒንሢ ዶዲሻሢ ዒንሢ ኮራ ሙካዓኬ፤ ታኣኒ ዓኣዼቴ ጋዓንቴ ዬያ ዒንሢ ኮራ ታ ዳካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ዬይ ሙኬ ዎዶ''ና ጎሜ ዛላ፥ ፂሉ''ሞ ዛላና ሃሣ ፆኦሲ ዎጋንዳ ዎጎ ዛሎ''ዋ ዓሶም ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ጎሞ ዛሎ''ሮ ኬኤዛንዳሢ' ታና ዔያታ ጉሙርቁዋኣሢ ጎሜ ማዔሢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ፂሉ''ሞ ዛሎ''ሮ ኬኤዛንዳሢ' ታኣኮ ዓዶ ባንሢ ዓኣዺፆና ሃይካፓ ሴካ ዒንሢ ታና ዛጊንዱዋኣሢ ዛሎ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ዎጊፆ ዛሎ'' ኬኤዛንዳሢ ሓያ ዓጮ'' ዎይሣ ፃላሄ ፑርታና ዎጊንቴሢ ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«ሓጊ ታ ዒንሢም ኬኤዛንዳ ሚርጌ ባኣዚ'' ዓኣኔ፤ ጋዓንቴ ሃሢ ዒንሢም ዴኤፃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ጎኑሞ ዔርዛ ዓያና ሙኬ ዎዶ''ና ጎኑሞ ባንሢ ዒንሢ ዔኪ ዓኣዻንዳኔ፤ ዓይጎሮ ጌዔቴ ዬይ ኬኤዛንዳሢ ዒ ዋይዜሢ ማዓንዳኣፓዓቴም ፔ ቶኦካ''ፓ ዔኪቱዋሴ። ዒዚ ሴካ ቤርቲም ማዓንዳ ባኮ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ታ ጊዳ''ፓ ዔኪ ዒንሢም ኬኤዛንዳሢሮ ታና ዒዚ ቦንቻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ዓዶሮ ማዔ ባካ ቢያ ታኣሮኬ፤ ‹ታ ጊዳ''ፓ ዔኪ ዒንሢም ኬኤዛንዳኔ› ታ ዒንሢም ጌዔሢ ዬያሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ሓሣ ዬሱሴ ኬኤዛዖ፦ «ዻካ'' ዎዴኮ ጊንፃ ታና ዒንሢ ዴንቂንዱዋሴ፤ ጊንሣ ዻካ'' ዎዴኮ ጊንፃፓ ታና ዒንሢ ዴንቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ'' ፔቴ''ዞንሢ፦ «ሓይ ‹ዻካ'' ዎዴኮ ጊንፃፓ ዒንሢ ታና ዴንቃዓኬ፤ ጊንሣ ዻካ'' ዎዴኮ ጊንፃፓ ታና ዒንሢ ዴንቃንዳኔ፤ ሓሣ ሌካ ዓዶ ባንሢ ታ ዓኣዻንዳኔ› ኑም ጌይንታ ባካ ዓይጌንዴዳይ?» ዎሊ ኮይላ'' ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ሓሣ ዔያታ፦ «ዓካሪ ሓይ ‹ዻካ'' ዎዴኮ ጊንፃፓ› ጌይንታ ባካ ዓይጌንዴዳይ? ዬይ ኑም ዔርታ ባኣዚ''ቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ዬሱሴ ዔያታ ዒዛ ዖኦጫኒ ማላሢ ዔራዖ፦ «ዒንሢ ዎሊ ዖኦጫሢ ‹ዻካ'' ዎዴኮ ጊንፃፓ ታና ዒንሢ ዴንቂዱዋሴ፤ ጊንሣ ዻካ'' ዎዴኮ ጊንፃፓ ታና ዒንሢ ዴንቃንዳኔ› ታ ዒንሢም ጌዔሢሮዳ? ");
INSERT INTO mdybse_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ጎኔ ታ ዒንሢም ጋዓኔ፤ ዒንሢ ዬኤካንዳኔ፤ ዓጫ'' ጋዓንቴ ዎዛዻንዳኔ፤ ዒንሢ ዖያንዳኔ፤ ጋዓንቴ ዒንሢኮ ዖዪፃ ዎዛና ላኣሚንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ላኣሊ ሾዓ ዎዶ''ና ቆፃ'' ቆፂ''ፆና ሜታዻኔ፤ ሾዔሢኮ ጊንፃ ጋዓንቴ ዓጮ''ይዳ ናይ ሾይንቴሢሮ ዎዛፓ ዔቄያና ዒዛ ፔኤኮ ቤርታኣ ሜታሢ ዋላ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ዬያጉዲ ዒንሢ ሃሢ ዖያንዳኔ፤ ላሚ ታ ዒንሢ ጊንሣ ዛጋንዳኔ፤ ዒና''ኣ ዒንሢኮ ዎዛዻንዳኔ፤ ዒንሢኮ ዎዞዋ ዒንሢዳፓ ዔካንዳይ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«ዬኖና ዒንሢ ዓይጎዋ ታና ዖኦጫዓኬ፤ ጎኔ ታ ዒንሢም ጋዓኔ፥ ታ ዓዶ ታ ሱ'ንፆና ዒንሢ ሺኢቄቶ ቢያ ባኣዚ'' ዒንሢም ዒ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ሓሢ ሃይማ ሄላ''ንዳኣና ዓይጎ ባኣዚ''ያ ታ ሱ'ንፆና ዒንሢ ሺኢቂባኣሴ፤ ሺኢቁዋቴ ዒንሢ ዔካንዳኔ፤ ዎዛ''ኣ ዒንሢኮ ኩሙሢ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ሓኖ ሄላ''ንዳኣና ኮኦኪንሢና ታ ዒንሢም ኬኤዜኔ፤ ዓካሪ ሃካፓ ሴካ ኮኦኪንሢና ታ ዒንሢም ኬኤዚንዱዋ ዎዴ ሙካንዳኔ፤ ጋዓንቴ ዓዶ ዛሎ'' ቢያ ባኣዚ'' ፔጋሲ ታ ዒንሢም ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ዬኖና ዒንሢ ታ ሱ'ንፆና ሺኢቃንዳኔ፤ ታኣኒያ ‹ታ ዓዶ ዒንሢም ሺኢቃንዳኔ› ጌይንዱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ዓይጎሮ ጌዔቶ ዓዴ ፔ ቶኦኪና ዒንሢ ናሽካሢሮኬ፤ ዓዴ ዒንሢ ናሽካሢ ዒንሢ ታና ናሽኬሢሮና ፆኦሲ ኮራፓ ታ ሙኬያ ማዔሢ ዒንሢ ጉሙርቄሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ታ ዓዶ ኮራፓ ሓያ ዓጮ'' ታ ሙኬኔ፤ ጊንሣ ሃሣ ሓያ ዓጮ'' ሃሺ'' ሌካ ዓዶ ባንሢ ታ ዓኣዻንዳኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ዒዛኮ ጊንፆ ሓንታዞንሢያ፦ «ሃይሾ፥ ሃሢ ኔ ኮኦኪንሢናቱዋንቴ ፔጌና ኑም ኬኤዛኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ኔኤኒ ቢያ ባኣዚ'' ዔራያታሢ ሃሣ ዖኦኒያ ኔና ዖኦጫኒ ኮይሱዋኣሢ ኑ ሃሢ ዔሬኔ፤ ዬያሮ ፆኦሲ ኮራፓ ኔ ሙኬሢ ኑ ጉሙርቃኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ዬሱሴ ዔያቶም፦ «ሓሢ ዒንሢ ጎኔ ታና ጉሙርቄኔ ጌይፆዳ? ");
INSERT INTO mdybse_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ጋዓንቴ ዒንሢ ፔቴ'' ፔቴ''ሢ ዒንሢሮ ዒንሢሮ ዣኣሊ፥ ታና ታኣሮ ሃሻ''ንዳ ዎዴ ሙካንዳኔ፤ ዬና'' ዎዳ'' ሃሢኬ፤ ጋዓንቴ ዓዴ ታኣና ዎላ'' ዓኣሢሮ ታ ታኣሮ ሌሊ ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ሓያ ታ ዒንሢም ኬኤዛሢ ዒንሢ ታኣና ዎላ'' ማዔም ዎዛ ዒንሢኮ ዓኣያ ማዓንዳጉዲ ጌይኬ፤ ዓጮ''ይዳ ዒንሢ ዓኣንቴ ሜታ ዓኣኔ፤ ጋዓንቴ ዒጊጪፖቴ፥ ታኣኒ ዓጮ'' ባሼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ዬሱሴ ዬያ ኬኤዜሢኮ ጊንፃ ሌካ ጫሪንጮ ባንሢ ዛጋዖ ሂዚ ጌይ ሺኢቄኔ፦ «ታ ዓዳሢዮ! ሓይሾ ዎዳ'' ዓካሪ ሄሌ''ኔ፤ ናዓሢ ኔኤኮ ኔና ቦንቻንዳጉዲ ኔኤኮ ናዓሢ ቦንቼ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ኔ ዒዛ ቦንቻንዳሢያኣ ኔኤኒ ዒዛሮ ማሂ ዒንጌሢም ቢያ ናንጊና ናንጊ ሼምፖ ዒ ዒንጋንዳጉዲ፥ ዓሶ ቢያሢ ዑፃ ቢታንቶ ኔ ዒንጌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ናንጊና ናንጎ ሼምፖ ጌይፃ፦ ኔኤሮ ሌሊ ጎኔ ፆኦሲ ማዔሢ፥ ኔናንታ ኔኤኒ ዳኬ፥ ዬሱስ ኪሪስቶሴያ ዔሪሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ኔኤኒ ታኣም ዒንጌ ማዾ'' ኩንሢ ሳዖይዳ ታ ኔና ቦንቼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ታ ዓዳሢዮ! ዓጫ'' ማዢንታንዳሢኮ ቤርታ ኔኤና ዎላ'' ታኣኮ ዓኣ ቦንቾ ጎይፆ ሃሢ ኔ ኮራ ታና ቦንቺሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«ዓጮ''ይዳፓ ዶኦሪ ኔ ታኣም ዒንጌ ዓሶም ኔኤኮ ዖኑሞ ታ ፔጋሲ ኬኤዜኔ፤ ዔያታ ኔኤሮኬ፤ ኔኤኒ ዔያቶ ታኣም ዒንጌኔ፤ ዔያታኣ ኔ ቃኣሎ'' ካፔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ኔ ታኣም ዒንጌ ባካ ቢያ ኔ ጊዳ''ፓ ማዔሢ ዔያታ ሃሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ኔ ታኣም ዒንጌ ቃኣሎ'' ታ ዔያቶም ዒንጌኔ፤ ዔያታኣ ዬያ ዔኬኔ፤ ኔ ኮይላ''ፓ ታ ሙኬሢያ ጎኔና ዔያታ ዔሬኔ፤ ሃሣ ኔ ታና ዳኬሢ ጉሙርቂ ዔያታ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«ታኣኒ ሃሢ ሺኢቃሢ ዔያቶሮኬ፤ ሃንሢ፥ ኔኤኒ ዒንጌዞንሢ ኔኤሮ ማዔሢሮ ዔያቶ ዛሎ'' ታ ሺኢቃኣፓዓቴም ሓያ ዓጮ''ሮ ማዔ ዓሶም ታ ሺኢቁዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ታኣም ማዔሢ ቢያ ኔኤሮኬ፤ ዬያጉዲ ሃሣ ኔኤም ማዔሢያ ታኣሮኬ፤ ታኣኒያ ዔያቶና ቦንቺንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ታኣኒ ሃይፓ ሴካ ዓጮ''ይዳ ናንጊንዱዋሴ፤ ዔያታ ጋዓንቴ ዓጫ''ኬ። ታኣኒ ኔ ኮይላ'' ሙካኒኬ፤ ጌኤዦ ዓዳሢዮ! ሃንሢ ኔ ታኣም ዒንጌዞንሢ ኑ ፔቴ'' ማዔ ጎይፆ ዔያታኣ ፔቴ'' ማዓንዳጉዲ ታኣም ኔኤኒ ዒንጌ፥ ኔ ሱ'ንፆና ዔያቶ ካፔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ታኣኒ ዔያቶና ዎላ'' ዓኣ ዎዶ''ና ኔ ታኣም ዒንጌ ኔ ሱ'ንፆና ታ ዔያቶ ካፔኔ ዬያሮ ፃኣፒንቴ፥ ፆኦሲ ቃኣላ'' ኩማንዳጉዲ ዬያ ባይሲንቶ ናዓሢዳፓ ዓታዛ ፔቴ''ታዖ ዔያቶይዳፓ ዖኦኒያ ባይቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ሃሢ ታኣኒ ኔ ኮራ ሙካኒኬ፤ ታኣኒ ዓጮ''ይዳ ዓኣዖ ዬያ ኬኤዛሢ ታ ዎዛዼሢጉዲ ዔያታኣ ሚርጌና ዎዛዻንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ታኣኒ ኔኤኮ ቃኣሎ'' ዔያቶም ዒንጌኔ፤ ታኣኒ ዓጫ''ፓቱዋኣሢጉዲ ዔያታኣ ሃሣ ዓጫ''ፓቱዋሴ፤ ዬያሮ ዓጫ'' ዔያቶ ዒፃኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ፑርታፓ ዔያቶ ኔ ካፓንዳጉዲ ማዓንዳኣፓዓቴም ዓጮ''ይዳፓ ዙላ'' ኔ ዔያቶ ኬሳ''ንዳጉዲ ታ ኔና ሺኢቁዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ታኣኒ ሃያ ዓጫ''ፓቱዋኣሢጉዲ ዔያታኣ ሃያ ዓጫ''ፓቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ኔኤኮ ጎኑሞና ዔያቶ ኔኤም ዱማሴ፤ ኔኤኮ ቃኣላ''ኣ ጎኑሞኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ኔኤኒ ታና ዓጮ'' ባንሢ ዳኬሢጉዲ ታኣኒያ ዔያቶ ዓጮ'' ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ዔያታ ጎኔና ኔኤም ዱማዼያ ማዓንዳጉዲ ታኣኒ ታ ቶኦኮ'' ዔያቶ ጋቴ ዱማሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«ሃሢ ታ ኔና ሺኢቃሢ ሃንሢ፥ ዔያቶ ዛሎ''ሮ ሌሊቱዋንቴ ዔያታ ማርካዻ ቃኣሎ'' ዛሎ''ና ታና ጉሙርቃንዳ ዓሶንታም ዎላ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ታ ኔና ሺኢቃሢ ቢያሢ ዎላ'' ፔቴ'' ማዓንዳጉዲኬ፤ ዬያጉዲ ሃሣ ዓዳሢዮ! ኔኤኒ ታኣና ዎላ'' ፔቴ'' ማዔሢጉዲ ታኣኒያ ኔኤና ዎላ'' ፔቴ'' ማዔሢጉዲ ዔያታኣ ኑኡና ዎላ'' ፔቴ'' ማዓንዳጉዲኬ፤ ሃሣ ኔኤኒ ታና ዳኬያ ማዔሢያ ዓጫ'' ጉሙርቃንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ኑኡኒ ፔቴ'' ማዔሢ ጎይፆ ዔያታኣ ዎላ'' ፔቴ'' ማዓንዳጉዲ ታኣም ኔኤኒ ዒንጌ ቦንቾ ታ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ታኣኒ ኔና ሺኢቃሢ ታኣኒ ዔያቶና፤ ኔኤኒያ ታኣና ማዔሢጉዲ ዔያታኣ ጉቤና ፔቴ'' ማዓንዳጉዲኬ፤ ሃሣ ኔኤኒ ታና ዳኬሢና ኔ ታና ናሽኬሢጉዲ ዔያቶዋ ኔኤኒ ናሽካሢ ዓጫ'' ዔራንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«ታ ዓዳሢዮ! ዓጫ'' ማዢንቱዋንቴ ኔ ታና ናሽኬሢሮ ታኣም ኔኤኒ ዒንጌ ቦንቾ ዔያታ ዛጋንዳጉዲ ሃንሢ፥ ኔ ታኣም ዒንጌዞንሢ ታኣኒ ዓኣ ቤዞይዳ ታኣና ዎላ'' ዔያታ ናንጋንዳጉዲ ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ፂሎ'' ዓዳሢዮ! ዓጫ'' ኔና ዔሪባኣሴ፤ ታኣኒ ጋዓንቴ ኔና ዔሬኔ፤ ሃንሢያ ሃሣ ኔ ታና ዳኬሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ኔኤኒ ታና ናሽኬ ናሹሞ ጎይፆ ዔያታ ዎሊ ናሽካንዳጉዲ ሃሣ ታኣኒያ ዔያቶና ማዓንዳጉዲ ጊንሣ ሃሣ ዔያታ ኔና ዔራንዳጉዲ ታ ዔያቶ ማሄኔ፤ ዬኖ ጎይፆ ቃሲ'' ቃሲ'' ታ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ዬሱሴ ዬያ ጌዔስካፓ ዒዛኮ ጊንፆ ሃንታዞንሢና ዎላ'' ቄድሮኦኔ ዎሮ ሱኮ ዴንዳዖ፥ ዒኢካ ቱኮ''ና ሚፃ ዓኣ ቤዞ ዔያቶና ዎላ'' ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ዔያታ ዬኖ ቤዜሎይዳ ቢያ ዎዴ ቡኪንታያ ማዔሢ ዓኣሢ ዒንጋ፥ ዪሁዳ ዔራያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ዬያሮ ዪሁዳ ፖኦሊሶንታ ቄኤሶኮ ሱኡጎና ፔርሴ ዓሶናም ዓይሢንቲ ማዻስኬንሢንታ ዔኪ ዬኖ ቤዜሎ ሙኬኔ፤ ዔያታ ዒማ''ና ፓኖሴ ጌይንታ ፖዓ ባኮንታ ኩሻንታ ፖዒሲ ሃሣ ዖልዚ ዓንጋሞዋ ዔኪ ዬዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ዬሱሴ ዒዛ ሄላ''ንዳ ባኮ ቢያ ዔራዖ ዔያቶ ባንሢ ዓኣዺ፦ «ዖና ዒንሢ ኮዓይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ዔያታ ማሃዖ፦ «ናዚሬቴ ካታሞ ዓሢ፥ ዬሱሴ ኑ ኮዓኔ» ጌዔኔ። ዬማና ዒዚ ዔያቶም፦ «ዬይ ታናኬ» ጌዔኔ። ዓኣሢ ዒንጋ፥ ዪሁዳ ዬያ ሙኬ ዓሶና ዎላ'' ዔቂ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ዬሱሴ፦ «ዬይ ታናኬ» ዔያቶም ጋዓዛ ጊንሢም ዴንዲ ዔያታ ሎኦሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ዬሱሴ ሃሣ፦ «ዖና ዒንሢ ኮዓይ?» ጌይ ላሚ ዔያቶ ዖኦጫዛ፥ ዔያታ፦ «ናዚሬቴ ካታሞ ዓሢ፥ ዬሱሴ ኑ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ዒዚ ዔያቶም፦ «ታናኬ ታ ዒንሢም ጌዔኔ፤ ዓካሪ ዒንሢ ታና ኮዓያ ማዔቶ ሃኣቶ ሓሹ''ዋቴ፥ ዔያታ ዴንዶም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ዬይ ያዺ ማዔሢ፦ «ታ ዓዳሢዮ! ኔ ታኣም ዒንጌ ዓሶይዳፓ ፔቴ''ታዖ ታ ባይዚባኣሴ» ጌዔ ቃኣላ'' ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ዒማ''ና ሲሞኦኔ ጎዖ ጴፂሮሴ ጬንቻ ዓፓሮ ዓርቄሢሮ ቱጊ ቄኤሶኮ ሱኡጋሢም ዓይሢንቲ ማዻሢኮ ዋዮ ቆፂ'' ቲቄኔ፤ ዬያ ዓይሢንቲ ማዻሢኮ ሱንፃ «ማልኮሴ» ጌይንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ዬሱሴ ጋዓንቴ ጴፂሮሴ ኮራ፦ «ዓፓሮ ኔኤኮ ጎንጎኖይዳ ዳኬ፤ ዓዴ ታኣም ዒንጌ፥ ሃያ ሜታሢ ታ ዔካኑዋያ ኔኤም ማላ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ዬካፓ ፖኦሊሶንሢንታ ዔያቶ ዓይሣሢንታ ሃሣ ዓይሁዶ ዓሶም ዓይሢንቲ ማዻዞንሢንታ ዎላ'' ማዒ ዬሱሴ ዓርቂ ሱሲና ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ዬያይዴስካፓ ቤርታሲ ቃያፓኮ ባይሲ፥ ሃኣና ኮራ ዔኪ ዔያታ ዓኣዼኔ፤ ቃያፓ ዬኖ ሌዖ ቄኤሶኮ ሱኡጋሢ ማዒ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቃያፓ ቤርታ፦ «ፔቴ'' ዓሲ ዴሮ'' ዛሎ''ሮ ሓይቄቶ ኮሺኬ» ጌይ ዓይሁዶኮ ዎይሣ ዓሶ ዞሬሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ሲሞኦኔ ጌይንታ ጴፂሮሴንታ ሃሣ ሜሌ'' ዬሱሴኮ ጊንፆ ሃንታስኬያንታ ዬሱሴኮ ጊንፆ ዓኣዼኔ፤ ዬይ ሜሌ'' ዬሱሴኮ ጊንፆ ሃንታሢ ቄኤሶኮ ሱኡጋሢና ዎላ'' ዔርታሢሮ ዬሱሴና ዎላ'' ቄኤሶ ሱኡጋሢኮ ዲሮ ጋሮ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ጴፂሮሴ ዒማ''ና ማርሾ ካራ'' ዔቂ ዓኣንቴ ዬይ ቄኤሶኮ ሱኡጋሢና ዔርታ፥ ዬሱሴኮ ጊንፆ ሃንታሢ ሙካዖ ካሮ'' ካፓ ዉዱሮ ናዔሎም ኬኤዚ ዒዛ ጋሮ ጌልዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ዬና ካሮ'' ካፓ ዉዱሮ ናዔላ ጴፂሮሴ ኮራ፦ «ኔኤኒ ሃያ ዓሢኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ''ሢቱዋዓዳ?» ጋዓዛ፥ ዒዚ ጋዓንቴ «ታ ዒዛቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ዬማና ጪኢሺ ጪኢሽካያታሢሮ ዓይሢንቲ ማዻዞንሢና ዲሮ ጋሮ ካፓዞንሢና ዒኢካ ታሚ ዔኤሢ ካሽታንቴ፥ ጴፂሮሴያ ዔያቶና ዎላ'' ዔቂ ካሽታኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ዒማ''ና ቄኤሶኮ ሱኡጋሢ ዬሱሴ ኮራ ዒዛኮ ጊንፆ ሃንታዞንሢና ዒዛኮ ዔርዚፆና ዛሎ'' ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ዬሱሴ ዒዛም፦ «ታኣኒ ዓሲም ቢያ ፔጌና ኬኤዜኔ፤ ዓይሁዶ ዓሳ ቢያ ቡኪንታ ቤዞይዳ ማዔቶዋ ጌኤዦ ማኣሮይዳ ቢያ ኬሊ'' ታ ዔርዛ ዎዶ''ና ዓኣቺ ታ ኬኤዜ ባኣዚ'' ዓይጌያ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ዓካሪ ኔ ሃሢ ዓይጎሮ ታና ዖኦጫይ? ታ ኬኤዛንቴ ዋይዜ ዓሶ ዖኦጬ፤ ታ ኬኤዜ ባኮ ዔያታ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ዬሱሴ ዬያ ጋዓዛ ዒኢካ ዔቂ ዓኣ፥ ዓይሢንቲ ማዻዞንሢዳፓ ፔቴ''ሢ፦ «ቄኤሶኮ ሱኡጋሢም ኔ ሂዚ ጌይ ማሃ?» ጌይ ዬሱሴ ባዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ዬሱሴ ማሃዖ፦ «ፑርታ ባኣዚ'' ታ ኬኤዜያ ማዔቶ ዬኖ ፑርቴሎ ታኣም ኬኤዜ፤ ታኣኒ ኬኤዜ ባካ ፒዜ ማዔቶ ኔ ታና ዓይጎሮ ባዔይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ዬካፓ ሃኣና ዬሱሴ ሱዞና ቱኡቴ ጎይሣ ዓኣንቴ ቄኤሶኮ ሱኡጋሢ ቃያፓ ኮራ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ዒማ''ና ሲሞኦኔ ጎዖ ጴፂሮሴ ዔቂ ታሞ ካሽታንቴ ሜሌ'' ዓሲስኬንሢ ሃሣ፦ «ኔኤኒ ዬሱሴኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ''ሢቱዋዓዳ?» ጋዓዛ፥ ዒዚ፦ «ታ ዒዛቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ጴፂሮሴ ዋዮ ቲቄ ዓሢኮ ዒጊኒ ማዔያ ሃሣ ቄኤሶ ሱኡጋሢኮ ዓይሢንቲ ማዻዞንሢዳፓ ፔቴ''ስኬይ፦ «ዬኖ ቱኮ''ና ሚፃ ዓኣ ቤዜሎይዳ ታ ኔና ዔያቶና ዎላ'' ዓኣንቴ ዴንቂባይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴፂሮሴ ላሚ ሃሣ፦ «ታ ዒዛ ዔሩዋሴ» ጌዔኔ፤ ዬማና ኔጉዋዖ ኮይዳ ቂኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ዬካፓ ዬሱሴ ዔያታ ቃያፓ ማኣራፓ ዔኪ ሮሜ ዓጮ'' ዎይሣሢ ማኣሪ ዔኪ ዓኣዼኔ፤ ዬና ዎዳ'' ጉቴ'' ዓሚ''ናኬ፤ ዓይሁዶ ዓሳ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ና ሙዖ ሙዓኒ ዔያቶ ኮይሳሢሮ ዔያቶ ዒኢሱዋጉዲ ጌይሢና ዓጮ'' ዎይሣሢኮ ማኣሮ ዲሮ ጋሮ ጌሊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ዬያሮ ዓጮ'' ዎይሣ፥ ጲላፆሴ ዔያቶ ባንሢ ኬስካዖ፦ «ሓያ ዓሢ ዑፃ ዒንሢ ሺኢሻ ጌኤዛ ዓይጌንዴዳይ?» ጌይ ዔያቶ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ዔያታ ማሃዖ፦ «ሓይ ዓሢ ፑርታ ማዺባኣ ዓሲ ማዔቶ ኔኤም ኑ ዒዛ ዓኣሢ ዒንጋዓታንቴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጲላፆሴያ፦ «ዒንሢ ዒንሢሮ ዒዛ ዔኪ ዓኣዺጋፓ ዒንሢ ዎጎ ጎይፆ ዒዛ ዑፃ ዎጉዋቴ» ዔያቶም ጋዓዛ፥ ዓይሁዶኮ ዎይሣ ዓሳ፦ «ኑኡኒ ዓሲ ዎዻኒ ቢታንቶ ኑኡኮ ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ዬይ ያዺ ማዔሢ ዬሱሴ ዎዚጉዴ ሓይቢና ሓይቃንዳቴያ ኬኤዚንቴ ቃኣላ'' ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጲላፆሴ ጊንሣ ማዒ ፔ ጋሮ ጌላዖ ዬሱሴ ዔኤሊ''፦ «ኔኤኒ ዓይሁዶ ዓሶኮ ካኣቲዳ?» ጌይ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ዬሱሴ ማሃዖ፦ «ኔኤኒ ዬያ ጋዓሢ ኔ ቶኦካፓ ዔኪሞ? ሜሌ'' ዓሳ ታ ዛሎ'' ዬያ ኔኤም ኬኤዜምዳይ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጲላፆሴ ዒማ''ና፦ «ታኣኒ ኔ ኮራ ዓይሁዴ ዓሲ ማላ? ኔና ዓኣሢ ዒንጌዞንሢ ኔኤኮ ፃጶና ቄኤሶኮ ሱኡጎናኬ፤ ኔኤኒ ማዼ ባካ ዓይጌንዴዳይ» ዬሱሴ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ዒዚ ማሃዖ፦ «ታ ካኣቱማ ሃያ ዓጫ''ፓቱዋሴ፤ ታ ካኣቱማ ሃያ ዓጫ''ፓታቶ ዓይሁዶ ዓሶኮ ዎይሣ ዓሶ ኩጫ ታ ዓርቂንቱዋጉዲ ታኣም ዓይሢንቲ ማዻዞንሢ ታ ዛሎ'' ሄኤዶ ዖልቴያ ናንዳንቴኬ፤ ጋዓንቴ ታ ካኣቱማ ሃያ ዓጫ''ፓቱዋሴ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ጲላፆሴያ፦ «ሂዴቶ ኔ ካኣቲኬ ጌይሢዳ?» ዒዛ ኮራ ጋዓዛ፥ ዬሱሴ ማሃዖ፦ «ሂዮ፥ ኔ ታና ጌዔሢጉዴያኬ፤ ታኣኒ ሾይንቴሢና ሃያ ዓጮ'' ሙኬሢ ጎኑሞ ዛላ ማርካዻኒኬ፤ ጎኑሞይዳፓ ማዔሢ ቢያ ታኣኮ ዑኡዞ ዋይዛኔ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጲላፆሴ ዒማ''ና፦ «ጎኑሞ ዓይጌንዴዳይ?» ጌዔኔ። ዬካፓ ላሚ ሃሣ ዓይሁዶ ዓሶ ባንሢ ኬስኪ ዔያቶም፦ «ታኣኒ ሃያ ዓሢኮ ዓይጎ ፑርታ ባኣዚ''ያ ዴንቂባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ጋዓንቴ ዒንሢኮ ዔርቴሢ ጎይፆ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ና ቢያ ዎዴ ፔቴ'' ቱኡቴ ዓሲ ታ ዒንሢም ቡላ''ያኬ፤ ዬያሮ ሃሢ ዓይሁዶ ዓሶኮ ካኣታ''ሢ ታ ዒንሢም ቡላ''ንዳጉዲ ዒንሢ ኮዓ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ዔያታ ጋዓንቴ፦ «ዬያቱዋንቴ ባርባኔ ኑም ቡሌ''!» ጌይ ጌይ ዒላቴኔ። ባርባኔ ጎዖሢ ካይዚ ጌሌ፥ ሱላኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ዬካፓ ጲላፆሴ ዬሱሴ ዔኪ ጳርቂሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ዒማ''ና ፖኦሊሶንሢ ካኣታ'' ቶኦካ ዓጋ ባኮ ማሊሲ ዓንጊሢ ማራዖ ዬሱሴኮ ቶኦካ'' ዓጌኔ፤ ዞቄ ዲንኪ ዓፒላኣ ዔያታ ዒዛ ማይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ዬያይዴስካፓ ዔያታ ዒዛ ባንሢ ሙኪ ሙኪ ዒዛ ቦሂሢና፦ «ዓይሁዴ ካኣቲዮ! ኮሹሞ ኔኤም ማዖንጎ!» ጌይ ጌይ ሃሣ ዒዛ ባዒያ ባዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ጲላፆሴ ጊንሣ ዙሎ'' ኬስካዖ፦ «ሓይሾ፥ ታ ዓይጎ ዻቢንቲያ ዒዛይዳ ዴንቂባኣሢ ዒንሢ ዔራንዳጉዲ ዒዛ ታ ዒንሢም ኬሳ''ንዳኔ» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ዒማ''ና ዬሱሴ ዬኖ ዓንጊፆ ማሮናዞ ቶኦካ'' ዓጊ፥ ዞቄ ማኣዓሢያ ማይንቲ ዙሎ'' ኬስኬኔ፤ ጲላፆሴ ዓሶም፦ «ዓካሪ ዓሢ ሃይሾ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ቄኤሶኮ ሱኡጎና ዔያቶም ዓይሢንቲ ማዻዞንሢና ዬሱሴ ዴንቃዖ፦ «ሱፄ! ሱሱፄ!» ጌይ ጌይ ዒላታዛ፥ ጲላፆሴ ጋዓንቴ፦ «ታኣኒ ታ ዛሎ''ና ዓይጎ ዻቢንቲያ ዒዛይዳ ዴንቂባኣሴ፤ ዒንሢ ኮዔቶ ዒዛ ዔኪ ዓኣዺጋፓ ሱፁዋቴ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ዓይሁዶ ዓሳ ዒማ''ና፦ «ኑኡኮ ዎጌ ዓኣኔ፤ ሓይ ዓሢ ፔና ፆኦሲ ናይ ማሄሢሮ ኑ ዎጎ ጎይፆና ሓይቢ ዒዛም ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ዬያ ቢያ ጌኤዞ ዋይዜሢኮ ጊንፃ ጲላፆሴ ሚርጌና ዒጊጬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ዒማ''ና ሃሣ ጊንሣ ዒ ጋሮ ጌላዖ ዬሱሴ ኮራ፦ «ኔ ዓንካፓዳይ?» ጌይ ዖኦጫዛ፥ ዬሱሴ ጋዓንቴ ዓይጎዋ ዒዛም ማሂ ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ዬያሮ ጲላፆሴ፦ «ኔ ታኣም ኬኤዙዋይ? ታ ኔና ቡላ''ኒ ሃሣ ሱፃኒያ ቢታንቶ ታኣኮ ዓኣሢ ኔ ዔሩዋዓዳ?» ዒዛ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ዬሱሴ ማሃዖ፦ «ፆኦሲዳፓ ኔኤም ቢታንቶ ዒንጊንቲባኣያ ማዔቶ ታ ዑፆይዳ ኔኤኮ ዓይጎ ቢታንቶዋ ናንጋዓታንቴኬ፤ ኔኤም ዓኣሢ ታና ዒንጌሢኮ ባሼ ጎሜ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ዬያ ዬሱሴ ጌስቴ ባኮ ጲላፆሴ ዋይዛዖ ቡሊ'' ዒዛ ሃሻ''ኒ ኮዓዛ፥ ዓይሁዶ ዓሳ ጋዓንቴ፦ «ሓያ ዓሢ ኔ ቡሌ''ቶ ኔኤኒ ሮሜ ዓጮ'' ካኣቲኮ ላጌቱዋሴ፤ ዓይጎሮ ጌዔቴ ፔና ካኣቲ ማሃሢ ቢያ ሮሜ ካኣቲኮ ሞርኬ ማዓያኬ» ጌይ ጌይ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጲላፆሴ ዬያ ዋይዛዖ ዬሱሴ ካሮ'' ባንሢ ኬሲ''፦ «ዳልጎ ፓልዒንቴ ሹጫሢ» ጌይንታ ቤዞይዳ ዓኣ፥ ዎጎ ዎጎ ዖይታ ዴዔኔ፤ ዬና ቤዜላ ዔብሬ ዓሶ ሙኡጮና «ጋባታ» ጌይንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ዬና ኬሌ''ላ ዑሣ ዓኣዺፆ ቦንቾኮ ጊኢጊንቶ ኬሊ'' ማዓዛ፥ ዬማና ዓባ'' ሳዛ ጫርጋያኬ፤ ዒማ''ና ጲላፆሴ ዓይሁዶ ዓሶ ኮራ፦ «ሓይሾ፥ ዒንሢኮ ካኣቲ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ዔያታ ጋዓንቴ፦ «ባይዜ! ባባይዜ! ሱፄ!» ጌዒ ጌዒ ዒላታዛ፥ ጲላፆሴ ማሃዖ፦ «ዒንሢኮ ካኣቲ ታ ሱፆንዶ?» ዔያቶ ኮራ ጌዔኔ፤ ቄኤሶኮ ሱኡጋ ዒማ''ና፦ «ሮሜ ዓጮ'' ካኣቲዳፓ ዓታዛ ሜሌ'' ካኣቲ ኑኡኮ ባኣሴ» ጌይ ዒዛም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ዬማ''ና ዬሱሴ ሱፂንታንዳጉዲ ጲላፆሴ ዓኣሢ ዔያቶም ዒንጋዛ፥ ፖኦሊሳ ዬሱሴ ዔኪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ዬካፓ ዬሱሴ ዒ ሱፂንታንዳ፥ ፑርቲሴ ዓሶ ሱፆ ሚፆ ኬዲ «ቶኦኪ ሜጌሢ ማላ ቤሲ» ጌይንታ ቤዞ ኬስኬኔ፤ ዬና ቤዜላ ዔብሬ ዓሶ ሙኡጮና «ጎልጎታ» ጌይንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ዬኖ ቤዞይዳ ዔያታ ዒዛና ዎላ'' ላምዖ ዓሲ፤ ፔቴ''ሢ ሻውሎ'' ዛላ'' ፔቴ''ሢ ሚዛቆ ዛላ'' ማሂ ዬሱሴ ባኣካ'' ሱፄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጲላፆሴ ዒማ''ና፦ «ዓይሁዶ ካኣታ''ሢ፥ ናዚሬቶ ዓጮ'' ዓሢ፥ ዬሱሴ» ጋዓያ ፃኣፒ ፑርቲሴ ዓሶ ሱፆ ሚፆ ዑፃ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ዬሱሴ ሱፂንቴ ቤዛ ካታሞኮ ዑኬ ማዔሢሮ ሚርጌ ዓይሁዶ ዓሳ ዬኖ ፃኣፒ ጌሦናዞ ናባቤኔ፤ ዬና ፃኣፒንቴሢ ዔብሬ ዓሶ ሙኡጮና ላኣቲኔ ሙኡቺና ሃሣ ጊንሣ ጊሪኬ ሙኡቺናኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ዓይሁዶ ዓሶኮ ቄኤሶ ሱኡጋ ጲላፆሴ ኮራ፦ «ኔኤኒ ‹ዓይሁዴ ካኣቲኬ› ጌይ ፃኣፒፖ፤ ‹ሓይ ዓሢ ታኣኒ ዓይሁዴ ካኣቲኬ ጋዓኔ› ጌይ ፃኣፔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ጲላፆሴ ጋዓንቴ፦ «ታኣኒ ፃኣፔሢ ማይ ፃኣፒ ሃሼ''ኔ» ጌይ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ፖኦሊሶንሢ ዬሱሴ ሱፄስካፓ ዖዶዞ ቦንቾ ማኣዓሢ ሌሊ ዓታዛ ዒዛኮ ሃንጎ ዓፒሎ ዔኪ ፔቴ'' ፔቴ'' ፖኦሊሶም ሄላ''ንዳጉዲ ዖይዶ ቤሲ ፓቄኔ፤ ጋዓንቴ ዬና ቦንቾ ዓፒሌላ ጊኢጊሺ ሲኪንቲባኣያ ሎፓ ሉ ሄላ''ንዳኣና ፔቴ'' ማዒ ኮሺ''ንቴ ዓፒላኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ዬያሮ ፖኦሊሶንሢ፦ «ዬና ዓፒሌላ ዖኦም ሄላ''ንዳቴያ ዒፃ ኑ ዓጋንዳኔ፤ ኑ ዳዳርዚንዱዋሴ» ዎሊ ኮይላ'' ጌዔኔ። ዬይ ያዺ ማዔሢ፦ «ታኣኮ ዓፒሎ ዔያታ ጊሽቴኔ፤ ታኣኮ ፔቴ'' ማሂ ሲኮና ዓፒሎይዳ ዱማሲ ዔሮ ባኮ ዔያታ ዓጌኔ» ጌይንቴ ማፃኣፖ ቃኣላ'' ኩማንዳጉዲ ፖኦሊሳ ዬኖ ዓጎ ባኮ ዓጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ዬሱሴ ሱፂንቴ፥ ፑርቲሴ ዓሶ ሱፆ ሚፆ ኮይሎ''ይዳ ዒዛኮ ዒንዶና ዒንዶ ጌሮና ቄሌዮጳ ጎዖሢ ማቾ ማይራሞና ሜግዴላ ዓጮ'' ማይራማኣ ዔቂ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ዬሱሴ ዒዛኮ ዒንዶና ዒ ናሽካ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ኮይሎ''ይዳ ዔቂ ዓኣሢ ዛጋዖ ዒንዶ ኮራ፦ «ዒንዴ! ሃይሾ፥ ኔኤኮ ናዓሢ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ዬካፓ ዒዛኮ ጊንፆ ሃንታዞንሢ፦ «ኔኤኮ ዒንዳ ሃናሾ!» ዒዛም ጌዔኔ፤ ዬማፓ ዒዛኮ ጊንፆ ሃንታዞንሢ ማኣሪ ዒዞ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ዬካፓ ዬሱሴ ቢያ ባካ ኩሜሢ ዔራዖ ማፃኣፖይዳ ፃኣፒንቴ ቃኣላ'' ኩማንዳጉዲ «ታና ዼኤቤኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ዬኖ ቤዞይዳ ፔቴ'' ሶልኪ፥ ጊኢጉዋ ዑሺ ኩንሢ ጌሦና ሜሄ ዓኣኔ፤ ዬያሮ ዒኢካ ዓኣ ዓሳ ዬያ ዑዦይዳ ዓፒላ ቱርጫ ማላ ባኣዚ'' ዓጊ ዎኦሺ ማላ ሚሢና ዔኪ ዻንጎ ባንሢ ዑኪሳዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ዬሱሴ ዬኖ ዑዤሎ ፁንፄስካፓ፦ «ዓካሪ ኩሜኔ» ጋዓዖ፥ ቶኦኮ'' ዛላሲ ፔ ሼምፓሢ ዓኣሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ዬያ ባኮኮ ጊንፃፓ ዓይሁዶኮ ዎይሣ ዓሳ ሱፂንቴ ዓሶኮ ዞኦሎ'' ሜንሢ፥ ሱፆና ሚፆይዳፓኣ ዔያቶ ኬይሳንዳጉዲ ጲላፆሴ ኮራ ሺኢቄኔ፤ ዬያ ዔያታ ሂዴሢ ዓይሁዶ ዓሶኮ ሓውሾ ኬሎ''ም ጊኢጊንቲ ኬሊ'' ማዔሢሮ ሃሣ ዬና ኬሌ''ላ ዼኤፒ ቦንቾ ኬሊ'' ማዔሢሮ ዔያቶኮ ሓውሾ ኬሎ''ና ሌዛ ሱፆና ሚፆይዳ ዴዑዋጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ዬያሮ ፖኦሊሶንሢ ዴንዲ ዬሱሴና ዎላ'' ሱፂንቴ ዓሶንሢኮ ዞኦሎ'' ሜንሤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ዬካፓ ዬሱሴ ባንሢ ዔያታ ሙካዖ ዒዚ ቤርታዺ ሓይቄያ ማዔሢ ዛጊ ዞኦሎ'' ዒዛኮ ዔያታ ሜንሢባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ጋዓንቴ ፖኦሊሶንሢዳፓ ፔቴ''ስኬይ ዒዛኮ ጎኦቦ'' ዎርሢና ጫርጋዛ ቤዞማና ጎኦባ''ፓ ሱጉሢና ዋኣሢና ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ዬያ ዛጌሢ ዒንሢ ጉሙርቃንዳጉዲ ማርካዼኔ፤ ማርካታኣ ዬይ ጎኔኬ፤ ዒ ኬኤዜ ባካ ጎኔ ማዔሢ ዒዚ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ዬይ ያዺ ማዔሢ ማፃኣፖይዳ፦ «ዒዛኮ ሜጌፃፓ ፔቴ''ታዖ ሜቃዓኬ» ጌይንቴሢ ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ሃሣ ሜሌ'' ማፃኣፔይዳ፦ «ዒዛ ጫርጌዞንሢ ሃጊ ዒዛ ዛጋንዳኔ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ዓይሁዶ ዓሶኮ ዎይሣ ዓሶ ዒጊጪሢና ዬሱሴ ዓሲ ዒ ማዔሢ ዔርዙዋዖ ናንጋ፥ ዓርማቲያሴ ዓጮ'' ዓሢ፥ ዮሴፔ ዬሱሴኮ ሌዞ ዔካኒ ጲላፆሴ ኮራ ሺኢቃዛ፥ ጲላፆሴ ዒዛ ዔኮንጎ ጌዔኔ፤ ዬያሮ ዮሴፔ ዴንዲ ሌዞ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ሓያኮ ቤርታ ዹሞና ዬሱሴ ኮራ ሙኬ፥ ኒቆዲሞሴ ጎዖሢ ዶንጊታሚ'' ዶሎዜ ማዓንዳ ካርቤ ዋላንጎና ዎላ'' ሲኢሪ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ዬንሢ ላምዖ ዓሶንሢ ዬሱሴኮ ሌዞ ዔኪ ዓይሁዶ ዓሳ ሃይቄ ዓሶ ሱኡዳ ጎይፆ ሳውቃ ቲሺና ቲሽኪ ሻኣዣ ዓፒላና ዒዛ ሱኡዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ዬሱሴ ሱፂንቴ ቤዞይዳ ፔቴ'' ሚሢ ቱኮ''ና ቤሲ ዓኣኔ፤ ዬኖ ቤዜሎይዳ ዖኦኒያ ዱኡቲባኣ ዓኪ ዱኡፒ ዔቴ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ዬና ኬላ'' ዓይሁዶ ዓሶኮ ሓውሾ ኬሎ''ም ጊኢጊንቶ ኬሊ'' ማዔሢሮ ሃሣ ጊንሣ ዱኡፖ ቤዛኣ ዑኬ ማዔሢሮ ዬሱሴ ዔያታ ዒኢካ ዱኡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ዉዴ ኬሊ'' ጉቴ'' ዓሚ'' ዹማ ሚኢሪ ሜግዴላ ዓጮ'' ማይራማ ዬሱሴኮ ዱኡፖ ቤዞ ዴንዴኔ፤ ዒኢካ ዒዛ ሄላ''ዖ ዱኡፖ ዔቶ'' ካሮ'' ዎዾና ሹጫሢ ዱኡፖ ዔቶ'' ካራ''ፓ ኮላዺ ዓኣንቴ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ዬያሮ ዒዛ ሲሞኦኔ ጌይንታ ጴፂሮሴና ዬሱሴ ዒዛ ናሽካያ ማዔ፥ ሜሌ'' ዒዛኮ ጊንፆ ሃንታሢና ኮራ ጳሽኪ ዴንዳዖ፦ «ጎዳ ዱኡፖይዳፓ ቱጊ ዔኮናኔ፤ ዓንካ ዒዛ ጌሦናቴያ ኑ ዔሩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ዬማና ጴፂሮሴና ሓንጎ ዬሱሴኮ ጊንፆ ሃንታሢና ዎላ'' ኬስካዖ ዱኡፖ ቤዞ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ዒማ''ና ላምዖንሢ ዎላ'' ጳሽኬኔ፤ ጋዓንቴ ባጋሢ ጴፂሮሴ ጳሽኪ ቢራዖ፥ ቤርታዺ ዱኡፖ ቤዞ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ሂርኪ ጌይ ዒዚ ዱኡፖ ዔቶ'' ዛጋዖ፥ ዬሱሴ ሱኡዶና ዓፒላ ሌሊ ዓኣንቴ ዴንቄኔ፤ ጋዓንቴ ዒ ዔቶ'' ጋሮ ጌሊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ዬካፓ ሲሞኦኔ ጎዖ ጴፂሮሴ ጊንፆ ሙኪ ዒኢካ ሄላ''ዖ፥ ዱኡፖ ዔቶ'' ጋሮ ጌሌኔ፤ ዒዚያ ዬሱሴ ሱኡዶና ዓፒላ ሌሊ ዓቲ ዓኣንቴ ዴንቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ዬሱሴኮ ቶኦኮ'' ማሮና ቱርጫ ሃንጎ ዑፆ ሱኡዶና ቱርጮና ዎላ''ቱዋንቴ ዱማዺ ሜሌ'' ቤስካ ቁሪንቲ ዓኣንቴ ዒ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ዬካፓ ሓሣ ዬይ ቤርታ ሄሌ''፥ ዬሱሴ ጊንፆ ሃንታሢ ዱኡፖ ዔቶ'' ጌሊ ዛጋዖ ዬይ ጎኔ ማዔሢ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ዒማ''ና፦ «ሓይባ''ፓ ዒዚ ዔቃንዳያ ኮይሳኔ» ጋዓ ጌኤዦ ማፃኣፖ ቃኣሎ'' ዔያታ ማሊ ጶቂሢ ዔሪባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ዬካፓ ዬንሢ ላምዖ ዬሱሴ ጊንፆ ሃንታዞንሢ ማዒ ፔ ማኣሪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ዒማ''ና ሜግዴላ ዓጮ'' ማይራማ ዬኤኪ ዬኤኪ ዱኡፖ ኮይላ'' ዔቂ ዓኣዖ፥ ሂርኪ ጌይ ዱኡፖ ዔቶ'' ጋሮ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ዒዛ ዛጋንቴ ዬሱሴኮ ሌዛ ዓኣ ቤዞይዳ ቦኦሬ ማኣዖ ማይንቴያ፥ ላምዖ ኪኢታንቾስኬንሢ ፔቴ'' ኬሮ'' ኬዴ'' ፔቴ''ሢ ቶኮ'' ዛላ'' ዴዒ ዓኣንቴ ዒዛ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ዬንሢ ማይራሞ ኮራ፦ «ዔና! ዓይጎሮ ኔ ዬኤካይ?» ጋዓዛ፥ ዒዛ ማሃዖ፦ «ታ ጎዳሢ ሃካፓ ዔኮናኔ፤ ዓንካ ጌሦናቴያ ታ ዔሩዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ዬያ ዒዛ ጋዓዖ ጊንሢም ሺሪ፥ ዬሱሴ ዔቂ ዓኣንቴ ዴንቄኔ፤ ጋዓንቴ ዬይ ዬሱሴ ማዔሢ ዒዛ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ዬሱሴ ዒዞ ኮራ፦ «ዔና ኔ ዓይጎሮ ዬኤካይ? ሓሣ ኔ ዖና ኮዓይ?» ጌዔኔ፤ ዒዞም ዬይ ዓሢ ሚፆ ቱኮ''ና ቤዛ ማዻ ዓሲ ማሌሢሮ፦ «ጎዳሢዮ! ኔኤኒ ዒዛ ዔኬቴ ዎካ ኔ ዒዛ ጌሤቶ ሓዳራ ታኣም ኬኤዜ፤ ታኣኒ ዒዛ ዔካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ዒማ''ና ዬሱሴ፦ «ማይራሜ» ዒዞ ኮራ ጋዓዛ፥ ዒዛ ዒዛ ባንሢ ሺራዖ ዔብሬ ዓሲ ሙኡቺና «ሬቡኒ» ጌዔኔ፤ ዬኖኮ ቡሊ''ፃ «ዔርዛሢዮ!» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ዬሱሴ ዒዞም፦ «ሓጊ ታኣኒ ሌካ ታ ዓዶ ባንሢ ኬስኪባኣሢሮ ታና ዓርቂፖ፤ ጋዓንቴ ታ ጌርሲንሢ ኮራ ዓኣዺጋፓ ‹ታኣኒ ሌካ ታ ዓዶና ዒንሢ ዓዶና ባንሢ፤ ሃሣ ታ ጎዳ ማዔ ፆኦዛሢና ዒንሢኮዋ ጎዳ ማዔ ፆኦዛሢ ባንሢ ታ ዔውታንዳኔ ጌዔኔ› ጌይ ዔያቶም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ዬያሮ ሜግዴላ ዓጮ'' ማይራማ ዬሱሴኮ ጊንፆ ሃንታዞንሢ ኮይላ'' ዴንዳዖ ጎዳ ዒዛ ዛጌሢና ዒዚ ዒዞም ጌዔ ባኮዋ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ዬኖ ዉዶ ኬሎ'' ዋንቶ ዬሱሴኮ ጊንፆ ሃንታዞንሢ ዓይሁዶኮ ዎይሣ ዓሶ ዒጊጬሢሮ ካሮ'' ፔኤኮ ዑፃ ዎዺ ጋራ ቡኪንቲ ዓኣንቴ ዬሱሴ ዔያታ ቡኪንቲ ዴዒ ዓኣ ማኣሬሎ ጌላዖ ባኣካ'' ዔያቶኮ ዔቂ፦ «ኮሹሞ ዒንሢም ማዖንጎ!» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ዬያ ጋዓዖ ፔኤኮ ኩጮንታ ጎኦቦ''ንታ ዔያቶ ዻዋዛ፥ ዔያታ ጎዳ ዛጊ ሚርጌና ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ዬካፓ ዬሱሴ ላሚ ሃሣ፦ «ኮሹሞ ዒንሢም ማዖንጎ! ታ ዓዴ ታና ዳኬሢጉዲ ታኣኒያ ዒንሢ ዳካኔ» ዔያቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ዬያ ጌይ ዔያቶ ዑፃ ዑኡዛዖ፦ «ዓያና ጌኤሺ ዔኩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ዒንሢ ዓሶኮ ጎሞ ዓቶም ጌዔቶ ዔያቶም ዓቶም ጌይንታንዳኔ፤ ዓሶኮ ጎሞ ዒንሢ ዓቶም ጌይባኣቶ ጎማ ዔያቶኮ ዓቶም ጌይንታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ዬሱሴ ዒዛኮ ጊንፆ ሃንታዞንሢ ኮይላ'' ሙኬ ኬሌ''ሎ ታጶ ላምዖንሢዳፓ ፔቴ''ሢ፥ ሱ'ንፃ «ሜንቴ» ጌይንታ ቶኦማኣሴ ዔያቶና ዎላ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ዬያሮ ሃንጎ ጊንፆ ሃንታዞንሢ ቶኦማኣሴ ኮራ፦ «ጎዳ ኑ ዛጊስካይ!» ጋዓዛ፥ ዒዚ፦ «ዓጬ ዓንጎና ዒዛኮ ጳርቂንቴ ኩጮ ታ ኬኤሎ''ና ሄሊ'' ዛጉዋዖ ሃሣ ዒዛኮ ጎኦቦ'' ዲኢዶዋ ኩቻ ዓርቂ ዛጉዋዖ ታ ዬያ ጎኔኬ ጋዓዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ሳሊ'' ኬሊ''ኮ ጊንፃፓ ዒዛኮ ጊንፆ ሃንታዞንሢ ሃሣ ፔቴ'' ማኣሪዳ ዓኣንቴ ቶኦማኣሴ ዔያቶና ዎላ'' ዓኣኔ፤ ዒማ''ና ዔያታ ዓኣ ማኣሮኮ ካራ'' ዎዺንቲ ዓኣንቴ ዬሱሴ ሙኪ ዔያቶኮ ባኣካ'' ዔቃዖ፦ «ኮሹሞ ዒንሢም ማዖንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ዬካፓ ቶኦማኣሴ ኮራ፦ «ሓኒ ሙኪ፥ ኔ ኬኤሎ''ና ታ ኩጮ ካኣሚ ዛጌ፤ ሓሣ ኔ ኩጮና ታ ጎኦቦ'' ዓርቂ ዛጌ፤ ዓልቲፆ ሃሺ'' ጉሙርቃ ዓሲ ማዔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶኦማኣሴ ዬማና፦ «ኔ ታኣኮ ጎዳ ሃሣ ፆኦዛሢኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ዬሱሴያ ቶኦማኣሴም፦ «ኔ ታና ዛጌሢሮ ጉሙርቄኔ፤ ጋዓንቴ ታና ዛጉዋዖ ጉሙርቃዞንሢ ጋላቲንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ዬሱሴ ሃኖ'' ማፃኣፖይዳ ፃኣፒንቲባኣ ሚርጌ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ዒዛኮ ጊንፆ ሃንታዞንሢ ቤርታ ማዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ጋዓንቴ ዬሱሴ ፆኦሲ ናይ ሃሣ ሜሲሔ ማዔሢ ዒንሢ ጉሙርቃንዳጉዲና ጉሙርቂ ዔኪ ዒዛ ሱ'ንፆና ናንጊና ናንጊ ሼምፖ ዒንሢ ዴንቃንዳጉዲ ሓይ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ዬካፓ ዬሱሴ ፂብራዶሴ ጌይንታ ባዞ'' ዓጫ ዒዛኮ ጊንፆ ሃንታዞንሢም ላሚ ሃሣ ጴዼኔ፤ ዒ ዬካ ዔያቶም ጴዼሢ ሂዲኬ፦ ");
INSERT INTO mdybse_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ሲሞኦኔ ጌይንታ ጴፂሮሴ፥ ሱ'ንፃ «ሜንቴ» ጌይንታ ቶኦማኣሴ፥ ጌሊላ ዓጮ''ኮ ቃናፓ ናቲናዔኤሌ፤ ሓሣ ዜብዲዮሴ ናኣቶ''ንሢና ሜሌ'' ላምዖ ዒዛኮ ጊንፆ ሃንታስኬንሢንታ ዎላ'' ዓኣንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ሲሞኦኔ ጌይንታ ጴፂሮሴ ዔያቶ ኮራ፦ «ሞሎ ዓርቃኒ ታ ዓኣዻንዳኔ» ጋዓዛ፥ ዔያታ ሃሣ፦ «ኑኡኒያ ኔኤና ዎላ'' ዓኣዻንዳኔ» ጌዔኔ፤ ዬካፓ ዔያታ ኬስኪ ዓኣዺ ዋኣፆና ፒንቆ ጎንጎይዳ ዓይፆሮ ጌሌኔ፤ ጋዓንቴ ዬኖ ዋንቴሎ ፔቴ'' ሞሎታዖ ዔያታ ዓርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ዚሮ ጉቴ''ሎ ሳዓ ካራዛ ዬሱሴ ዬኖ ባዜ''ሎ ዓጫ ዔቂ ዓኣንቴ ዒዛኮ ጊንፆ ሃንታዞንሢ ዬይ ዬሱሴ ማዔሢ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ዒማ''ና ዬሱሴ፦ «ዔዛታ! ሞላ ዒንሢ ኮራ ዓኣ?» ጋዓዛ፥ ዔያታ ማሃዖ፦ «ፔቴ''ታዖ ኑ ኮይላ'' ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ዒዚ ዔያቶም፦ «ሞላሢ ዓርቆ ሮኦጮ ማላ ሱዞ ዋኣፆና ፒንቆ ጎንጎኮ ሚዛቆ ዛሎ''ና ዓጉዋቴ፥ ዒንሢ ዴንቃንዳኔ» ጌዔኔ። ዬያሮ ሞላሢ ዓርቆ ሱዞ ባዞ''ይዳ ዔያታ ዓጌኔ፤ ዬማና ሚርጌ ሞላ ዓርቂንቴሢሮ ዬኖ ሞላሢ ዓርቆ ሮኦጮ ማላ ሱዜሎ ጎቻኒ ዔያቶ ባሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ዒማ''ና ዬሱሴ ዒዛ ናሽካ ዒዛኮ ጊንፆ ሃንታሢ ጴፂሮሴ ኮራ፦ «ሓይ ጎዳታንቴሞ!» ጋዓዛ፥ ሲሞኦኔ ጎዖ ጴፂሮሴ፦ «ሓይ ጎዳታንቴሞ!» ዬይ ጌዔሢ ዋይዛዖ ማዾ''ሮ ጌይ ማኣዓሢ ፔኤኮ ዒ ኬሲ'' ዓኣሢሮ ዑኬና ሃንጎ ማኣዓሢ ፔኤኮ ማይንቲ ሊካ ባዞ''ይዳ ጱሊ'' ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ዓቴ'' ዬሱሴኮ ጊንፆ ሃንታዞንሢ ጋዓንቴ ፃኣዾ ዓጮ''ይዳፓ ፄኤታ ታኣካ ማዓያ ሃኪ ዋኣፆ ሳዛ'' ዓኣሢሮ ሞላሢ ኩሜ፥ ሮኦጮ ማላ ሱዜሎ ጎቺ ጎቺ ዋኣፆና ፒንቆ ጎንጎና ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ዬኖ ጎንጌሎይዳፓ ዔያታ ኬዳ''ዖ ሞሎ ጊዳ'' ዓጎና ታሚ ቄንሢና ካሣኣ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ዬሱሴ ዔያቶም፦ «ሓሢ ዒንሢ ዓርቄ ሞላሢ ሃኒ ባውዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ዬያሮ ሲሞኦኔ ጎዖ ጴፂሮሴ ዋኣፆና ፒንቆ ጎንጌሎ ጋሮ ጌላዖ ፄኤታና ዶንጊታሚ'' ሓይሦ ኮሺ'' ዼኤፒ ዼኤፒ ሞላ ኩሜ፥ ሮኦጮ ማላ ሱዜሎ ሳዖ ባንሢ ጎቼኔ፤ ዬያጉዴ ሚርጌ ሞሎ ዓርቄቶዋ ዬና ሞላሢ ዓርቆ ሮኦጮ ማላ ሱዜላ ዱጲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ዬካፓ ዬሱሴ ዔያቶ ኮራ፦ «ሓኒ ሙኪ ሙዑዋቴ» ጋዓዛ፥ ዬይ ጎዳ ዬሱሴ ማዔሢ ቢያሢ ዔሬሢሮ ዒዛኮ ጊንፆ ሃንታዞንሢዳፓ ፔቴ''ታዖ፦ «ኔኤኒ ዖናዳይ?» ጌይ ዒዛ ዖኦጫኒ ጫርቄይ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ዒማ''ና ዬሱሴ ሙካዖ ካሦና ዬያጉዲ ሃሣ ሞላሢና ዔኪ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ዬሱሴ ሃይባ''ፓ ዔቄስካፓ ዒዛኮ ጊንፆ ሃንታዞንሢ ዒዛ ዛጋንቴ ዬና ሃይሣሶኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ዬኖ ሙዖ ሙዔስካፓ ዬሱሴ ሲሞኦኔ ጌይንታ ጴፂሮሴ ኮራ፦ «ዮና ናዓሦ፥ ሲሞኦኔ! ሓኣቶይዳፓ ኔ ታና ባሼ ናሽካ?» ዒዛ ኮራ ጋዓዛ፥ ዒዚ ማሃዖ፦ «ሂዮ፥ ጎዳሢዮ! ታ ኔና ናሽካሢ ኔ ታና ዔራኔ» ጌዔኔ። ዬሱሴያ ዒዛም፦ «ዓካሪ ታኣኮ ዔቃሎ ማራናኣቶ'' ዛጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ላሚ ሃሣ፦ «ዮና ናዓሦ፥ ሲሞኦኔ! ኔ ታና ናሽካ?» ዒዛም ጋዓዛ፥ ዒዚ ማሃዖ፦ «ሂዮ፥ ጎዳሢዮ! ታ ኔና ናሽካሢ ኔ ታና ዔራኔ» ጌዔኔ። ዬሱሴ ዒዛም፦ «ታኣኮ ጎሎጮ ማራናኣቶ'' ሄንቄ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ሓይሣሲ፦ «ዮና ናዓሦ፥ ሲሞኦኔ! ኔ ታና ናሽካ?» ዒዛ ኮራ ጋዓዛ፥ ሓይሣሲ፦ «ኔ ታና ናሽካ?» ጌይ ዒዛ ዖኦጬሢሮ ጴፂሮሴ ዖያዖ፦ «ታ ጎዳሢዮ! ኔኤኒ ቢያ ዔራኔ፥ ታኣኒ ኔና ናሽካሢ ኔ ታና ዔራኔ» ጋዓዛ፥ ዬሱሴ ማሃዖ፦ «ታኣኮ ዼኤፖ ማራቶ ሄንቄ፤ ");
INSERT INTO mdybse_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ጎኔ ታ ኔኤም ጋዓኔ፤ ኔኤኒ ዼጌ ዓኣዖ ኔኤኮ ኬርና ቱኡቶ ቃልሾ ኔ ኩቻ ኔ ቱኪ'' ኮዔ ቤሲ ዓኣዻኔ፤ ኔ ጋርቻዛ ጋዓንቴ ኔኤኒ ኩጮ ሌካ ዔቂሳዛ ሜሌ'' ዓሲ ኔና ቱኡሲ ኔ ኮዒባኣ ቤሲ ኔና ዔኪ ዓኣዻንዳኔ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ዬያ ዒ ጌዔሢ ጴፂሮሴ ዎማጉዴ ሓይቢና ፆኦሲ ዒ ቦንቻንዳያ ኮይሳቴያ ዒዛ ዔርዞሮኬ፤ ዬካፓ ጴፂሮሴ ኮራ፦ «ታ ጊንፆ ሙኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴፂሮሴ ሺሪ ዬሱሴ ዒዛ ናሽካ፥ ሜሌ'' ዒዛኮ ጊንፆ ሃንታሢ ዒዛ ጊንፆ ዓኣዻንቴ ዴንቄኔ፤ ዬይ ጊንፆ ሃንታሢ ፔቴ''ና ዔያታ ካሦ ሙዓኣና ዬሱሴ ባንሢ ዛላዺ ሂርኪ ጋዓዖ፦ «ጎዳሢዮ! ኔና ዓኣሢ ዒንጋንዳሢ ዖናዳይ?» ጌይ ዒዛ ዖኦጬሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴፂሮሴ ዬያ ዛጋዖ፦ «ጎዳሢዮ! ሃይ ዓሢ ዎይታንዳይ?» ጌይ ዬሱሴ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ዬሱሴ ማሃዖ፦ «ታኣኒ ሙካንዳያ ሄላ''ንዳኣና ዒ ሼምፖና ናንጋንዳጉዲ ታ ዒዛ ጌዔቶ ኔና ዓይጌ ጌልዜይ? ኔኤኒ ኔኤሮ ታ ጊንፆ ሙኬ» ዒዛም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ዬያ ዛሎ''ና ጌርሲንሢ ባኣካ''፦ «ሓይ ዬሱሴ ጊንፆ ሃንታሢ ሓይቂንዱዋሴ» ጌይንታ ሓይሴ ኬኤዚንቴኔ፤ ጋዓንቴ ዬሱሴ፦ «ታኣኒ ሙካንዳያ ሄላ''ንዳኣና ዒ ናንጋንዳጉዲ ታ ጌዔቶ ኔና ዓይጌ ጌልዜይ?» ጋዓንዳፓዓቴም «ኔ ሃይቂንዱዋሴ» ዒዛም ጌይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ዬያ ባኮ ቢያ ማርካዼሢና ዬንሢ ባኮንሢ ፃኣፔሢ ዒዛ ዬያ ዬሱሴኮ ጊንፆ ሃንታሢኬ፤ ዒዛኮ ማርካዺፃኣ ጎኔ ማዔሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ዬሱሴ ማዼ ሜሌ'' ሚርጌ ባኣዚ'' ሃሣ ዓኣኔ። ታ ማላ ጎይፆታቴ ዒዚ ማዼ ባኮ ቢያ ፔቴ'' ፔቴ'' ፃኣፒንቴያ ማዔቶ ዬያ ፃኣፒንቴ ማፃኣፖ ዓጫ'' ሃይ ፔ ቶኦኪና ዓርቃኒ ዳንዳዒንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ቴዎፒሎሴ! ታኣኮ ቤርታሳ ማፃኣፖይዳ ዬሱሴ ማዼ ባኮና ዔርዜ ባኮ ቢያ ታ ፃኣፔኔ፤ ታኣኒ ፃኣፔሢያ ዬሱሴ ሳዖይዳ ማዾ'' ዓርቄማፓ ዴንዲ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ሌካ ጫሪንጮ ዔውቴ ኬሎ'' ሄላ''ንዳኣና ዒዚ ማዼ ማዾ''ኬ፤ ሌካ ጫሪንጮ ዒዚ ዔውቴሢ' ዳኪንቴዞንሢ ጌይንቲ ዶኦሪንቴዞንሢም ዓያና ጌኤሺ ዎልቄና ዓይሢፆ ዓይሤሢኮ ጊንፃፓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ዒ ሓይቄሢኮ ጊንፃ ዺቢ ዔርታ ማርካ ማዓ ጎይሢና ሼምፔና ዓኣያ ማዒፆ ጎናሳኒ ዔያቶም ዖይዲታሚ'' ኬሊ''ዳ ጴዺ ጴዺ ፆኦሲኮ ካኣቱሞ ዛሎ'' ዔርዜኔ፤ ዔያታኣ ዒዛ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ዔያቶና ዎላ'' ዒዚ ዓኣና፦ «ታ ዒንሢም ቤርታ ኬኤዜሢ ሓሣ ዓዶይዳፓ ዒንጊንቴ ዎዞ ዒንሢ ዬሩሳላሜይዳፓ ኬስኩዋዖ ዒኢካ ካፑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ዮሓኒሴ ቤርታ ዋኣሢና ማስኬኔ፤ ዒንሢ ጋዓንቴ ሓሢ ዻካ'' ኬሊ''ኮ ጊንፃፓ ዓያና ጌኤሺና ማስታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ዒማ''ና ዳኪንቴዞንሢ ፔቴ''ይዳ ቡኪንቲ ዓኣዖ፦ «ጎዳሢዮ! ዒስራዔኤሌም ካኣቱሞ ማሂ ኔ ዒንጋንዳ ዎዳ'' ሓሢዳ?» ጌዒ ዬሱሴ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ዬሱሴ ማሃዖ፦ «ዓዳሢ ፔ ቢታንቶና ማሊ ጌሤ ዎዶ''ና ማዓንዳ ባኮና ዒንሢ ዔራኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ጋዓንቴ ዓያና ጌኤሺ ዒንሢዳ ኬዴ'' ዎዶ''ና ዎልቄ ዒንሢ ዴንቃንዳኔ፤ ዬካፓ ዬሩሳላሜይዳ፥ ዪሁዳ ዓጮ'' ቢያይዳ፥ ሳማሪያይዳ፥ ዴንዲ ዓጮ''ኮ ጋፒንፆ ሄላ''ንዳኣና ዒንሢ ታኣኮ ማርካ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ያዺ ጌዔስካፓ ዔያታ ዛጋ ጎይሣ ዓኣንቴ ሌካ ጫሪንጮ ባንሢ ሳዓፓ ዔውታኣና ሻኣሬ ዔያቶኮ ዓኣፓፓ ዒዛ ዓኣቼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ዒዚ ዓኣዻኣና ዔያታ ጫሪንጮ ባንሢ ጊዥ ጌዒ ዛጊፆይዳ ዓኣንቴ ቦኦሬ ዓፒላ ማኣዔ ላምዖ ዓሲ ዔያቶ ኮራ ዔቃዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«ዒንሢ ሓይ ጌሊላ ዓጮ'' ዓሳ፡ ጫሪንጮ ባንሢ ዛጊ ዒንሢ ዓይጎሮ ዔቄይ? ሓይ ጫሪንጮ ዔኪንታንቴ ዒንሢ ዛጌ ዬሱሴ፥ ጫሪንጮ ዴንዳንቴ ዒንሢ ዛጌማ ጎይፆ ዒማይዲ ማዒ ሙካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ዬካፓ ዛይቴ ሪሚቲ ዹካ'' ጌይንታዞይዳፓ ዬሩሳላሜ ባንሢ ዔያታ ማዔኔ፤ ዛይቴ ሪሚቲ ዹካ ጌይንታ ዹካ'' ዬሩሳላሜይዳፓ ዓሲ ዔኤሌም ዋይዛንዳጉዴ ፓዴ ቤሲዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ዬሩሳላሜ ዔያታ ሙካዖ ዎንዴ ናንጋ ኩቦ ማኣሮ ኬስኬኔ፤ ዔያታ፦ ጴፂሮሴ፥ ዮሓኒሴ፥ ያይቆኦቤ፥ ዒንዲራሴ፥ ፒልጶሴ፥ ቶኦማኣሴ፥ ቤርቴሌሞሴ፥ ማቲዎሴ፥ ዒልፒዮሴ ናኣዚ'' ያይቆኦቤ፥ ፔ ዓጮ'' ሚጪንታ ሲሞኦኔንታ ያይቆኦቤ ናኣዚ'' ዪሁዳንታኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ዬያታ ቢያ ኬሊ'' ፔቱሞና ዶዲ ፆኦሲ ሺኢቃኔ፤ ዔያቶና ዎላ'' ፔቴ'' ፔቴ'' ላኣሊና ዬሱሴኮ ዒንዶ ማይራሞና ሓሣ ዬሱሴኮ ጌርሲንሢያ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ዒማ''ና ጴፂሮሴ ፄኤታና ላማታሚ''ና ማዓ ኪሪስቶሴ ጉሙርቃ ዓሲ ባኣካ ዔቃዖ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«ታ ዒሾንሦ! ታ ሚሾንሦ! ዬሱሴ ዓርቄ ዓሶኮ ዓርና ማዔ፥ ዪሁዳ ዛሎ'' ፃኣፒንቴሢጉዲ ዓያና ጌኤሺ ቤርታሲ ዳውቴ ዛሎ''ና ኬኤዜ ፆኦሲ ማሊፃ ኩማኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ዪሁዳ ኑኡኮ ፔቴ''ሢ ማዒ ቤርታ ኑኡና ዎላ'' ማዻያኬ።» ");
INSERT INTO mdybse_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ጋዓንቴ ዬይ ዓሢ ፔኤኮ ፑርቶ ማዾ'' ዛሎ''ሮ ዔኬ ሚኢሾና ሳዓ ሻንቄኔ፤ ሓሣ ባሊቲና ሳዓ ጳዺንቲ ዹኡቂ ሔኮ ፓቂንታዛ፥ ሩቁንታኣ ዒዛኮ ኬስኪ ሚጪ''ንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ዬይ ማዺንቴ ባካ ዬሩሳላሜ ዓጮ''ይዳ ቢያ ዋይዚንቴኔ፤ ዬያሮ ዬና ሳዓ ዔያቶ ዓጮ'' ሙኡጮና «ዓኬልዳማ» ጌይንቴኔ፤ ዬኖኮ ቡሊ''ፃ «ሱጉሢ ሳዓ» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«ዬይ ያዺ ማዓኒ ዳንዳዔሢ ዓይኑሞ ማፃኣፖይዳ፦ ‹ዒዚ ናንጋ ማኣራ ባዔ ማዖንጎ፤ ዖኦኒያ ዒኢካ ናንጎፓ፤ ሓሣ ዒዛኮ ዓኣ ቢታንቶ ሜሌ'' ዓሲ ዔኮንጎ› ጌይንቲ ፃኣፒንቴያ ዓኣሢሮኬ።» ");
INSERT INTO mdybse_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«ዬያሮ ጎዳ ዬሱሴ ኑ ባኣኮ''ይዳ ኑኡና ዎላ'' ሃንቴ ዎዶ''ና ጉቤ ኑኡና ዎላ'' ዓኣ ዓሶይዳፓ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ዬያጉዲ ሓሣ ዮሓኒሴ ዋኣፆና ማስካ ዎዶ''ይዳፓ ዓርቃዖ ዴንዲ ጎዳ ዬሱሴ ጫሪንጮ ዔውቴ ኬሎ'' ሄላ''ንዳኣና ኑኡና ዎላ'' ዓኣ ዓሶይዳፓ ፔቴ'' ዓሲ' ጎዳ ሓይባ''ፓ ዔቄሢኮ ኑኡና ዎላ'' ማርካ ማዓኒ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ዬካፓ ላምዖ ዓሲ ዔያታ ዱማሲ ፔ ባንሢ ኬሴ''ኔ፤ ዬያታ ቤርሳባሴ ሓሣ ባጎ ሱ'ንፃ ዒዮስፆሴ ጌይንቲ ላምዖ ሱ'ንሢና ዔኤሊ''ንታ ዮሴፔ ጎዖሢና ማቲያሴናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ዬካፓ ጴፂሮሴንሢ ሂዚ ጌዒ ሺኢቄኔ፦ «ዓሲኮ ቢያ ዒኔ ዔራ ጎዳሢዮ! ሓንሢ ላምዖንሢዳፓ ዖና ኔኤኒ ዶኦሬቴያ ኑና ዻዌ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ኑ ሓሢ ሺኢቃሢ ዪሁዳ ፔ ሼኔና ፔ ማሌ ቤዞ ዓኣዻዖ ሓሼ'' ዳኪንቲፆ ማዾ'' ዔኪ ፔ ማዾ ማሂ ዒዛ ቤዛ ማዻንዳሢ ዖናታቴያ ኔ ኑም ዔርዛንዳጉዲኬ።» ");
INSERT INTO mdybse_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ጋዓዖ ዒፃ ዓጋዛ ዬና ባኬላ ማቲያሴም ኬስኬኔ፤ ዬያሮ ዬይ ማቲያሴ ጎዖሢ ታጶ ፔቴ'' ዳኪንቴዞንሢና ዎላ'' ማዒ ፓይዲንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺሢ ኬሊ'' ጌዒ ቦንቾ ኬላ'' ጋፔስካፓ ዶንጊታሚ'' ኬሊ'' ዴዒ ቦንቾ ጴንፄቆስፄ ጌይንታ ቦንቾ ኬሎ''ና ኪሪስቶሴ ጉሙርቃ ዓሳ ቢያ ፔቱሞና ቡኪ ፔቴ'' ቤስካ ዓኣንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ዔርቲባኣ ዶዲ ዓልጎ ዢባሬጉዴ ዑኡሲ ጫሪንጫፓ ሙኪ ዔያታ ዓኣ ጋሮ ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ዓዳ'' ታሚኮ ሎስቶ ማላያ ሚርጌ ዒንዲርሲ ዔያቶም ጴዻዖ፥ ፓቂንቲ ፓቂንቲ ፔቴ'' ፔቴ''ሢ ዑፃ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ዬማና ቢያሢ ዓያና ጌኤሺኮ ዎልቆ ጋሮ ጌሌኔ፤ ሓሣ ዓያኖ ጌኤዣ ዔያቶም ጌስታንዳጉዲ ዒንጌ ዱማ ዱማ ሙኡቺና ጌስቲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ዓጪ ማዔ ካራና ዓኣ ቤዛፓ ቢያ ሙኬ፥ ፆኦሲ ካኣሽካ ዓይሁዴ ዓሳ ዬሩሳላሜይዳ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ዒማ''ና ዬኖ ዑኡዜሎ ዋይዛዖ ሚርጌ ዓሲ ሙኪ ዒኢካ ቡኪንቴኔ፤ ዬና ጌስታ ዓሳ ዬያ ሙኪ ቡኪንቴ ዱማ ዱማ ዓሶኮ ሙኡጮና ጌስታንቴ ዋይዜስካፓ ዓሳ ጎዖንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ሓሣ ዲቃቲ ሄርሺሢና ሂዚ ጌዔኔ፦ «ሓኣታ ሓያይዲ ጌስታ ዓሳ ቢያ ጌሊላ ዓሲቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ሂዳዖ ሓሢ ዔያታ ኑኡኮ ኑ ሾይንቴ ዓጮ'' ሙኡጮና ጌስታንቴ ኑ ዋይዛሢ ዎይቲዳይ? ");
INSERT INTO mdybse_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ኑኡኒ ሓሢ ናንጋሢ ጳርቴይዳ፥ ሜዴይዳ፥ ዔላሜይዳ፥ ሜሶፖታሚያይዳ፥ ዪሁዳይዳ፥ ቄጶዶቂያዳ፥ ጳንፆሴይዳ፥ ዒሲያይዳ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ፒርጊያይዳ፥ ጲንፒሊያይዳ፥ ጊብፄይዳ፥ ቄሬና ጌይንታ ካታሞ ኮይላ'' ዓኣ ሊቢያ ዓጮ''ይዳኬ፤ ሓሣ ሮሜ ዓጫ''ፓ ሙኬ ዓይሁዴ ዓሶንታ ቤርታ ዓይሁዴቱዋዖ ዓይሁዴ ማዔ ዓሳ ኑኡኒያ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ዬያጉዲ ቄርፄሴ ዓጪ ዓሲንታ ዓሬቤ ዓጪ ዓሲንታ ዓኣኔ፤ ሓይሾ፦ ሓይ ዓሳ ቢያ ፆኦሲ ማዼ ፑኡፖ ማዾ'' ዛሎ'' ኑ ሙኡጮና ኬኤዛሢ ኑ ዋይዛንቴሞ!» ጌዒ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ቢያሢ ዲቃቲ ሄርሻዖ ጎዖንዶ ጎይሢ ባይዚ፦ «ሓይ ዓይጎ ባኣዚ'' ናንዳይ!» ጌዒ ጌዒ ዎሊ ኮራ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ፔቴ'' ፔቴ'' ዓሳ ጋዓንቴ ዬያ ባኮ ዓማሊ'' ማሃዖ፦ «ዎይኔፓ ኮሾ''ና ዑዦ ዑሽኪ ዔያታ ማማሢንቴያዋይ!» ጌዒ ጌዒ ቦሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ዒማ''ና ጴፂሮሴ ታጶ ፔቴ'' ዳኪንቴዞንሢና ዎላ'' ዔቂ ዓኣዖ ዴሮ''ም ዑኡዞ ፔኤሲ'' ዼ'ጊዲ ሂዚ ጌዒ ኬኤዜኔ፦ «ዒንሢ ዪሁዳ ዓጮ'' ዓሶ ማዔ ኑ ዓሶንታ ዬሩሳላሜይዳ ናንጋ ዓሳ ቢያ ማዺንቴ ባካ ዓይጎታቴያ ዔራኒ ታ ጋዓሢ ኮሺ'' ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ሳዓ ሓጊ ሶኦፓ ዎዴታሢሮ ዒንሢ ማላሢጉዲ ሓይ ዓሳ ማማሢንቴያቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ጋዓንቴ ሓይ ሓኣዺ ማዔሢ ፆኦሲ ማሊፆ ኬኤዛ ዒዩዔኤሌ ኬኤዛዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹ፆኦሲ ጋፒንፆ ኬሎ''ና ሓኣዺ ማዓንዳኔ ጋዓኔ፦ ታኣኮ ዓያኖ ታኣኒ ቢያ ዓሲ ዑስካ ላኣላንዳኔ፤ ዒንሢኮ ዓቲንቆና ዉዱሮ ናኣቶ''ና ፆኦሲ ማሊሢ ኬኤዛንዳኔ፤ ዼጌሢያ ሓሣ ፆኦሲ ፔጋሲ ዻዋ ባኣዚ'' ዛጋንዳኔ፤ ጋርቾ ዓሳኣ ዓውቲ ዓውታዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ዬያጉዲ ዬኖ ዎዶ''ና ዓቲንቆና ላኣሎና ማዒ ታኣም ማዻ ዓሶ ዑፃ ዓያኖ ታኣኮ ታ ላኣላንዳኔ፤ ዔያታኣ ፆኦሲ ማሊሢ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ሌካ ጫሪንጮይዳ ዲቃሢ ሄርሺሳ ባኣዚ'' ሊካ ሳዖይዳ ታ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ታ ዻዋንዳኔ፤ ሱጉሢና ታሚና ሓሣ ጩቢ ሊኢሎጉዲ ላሂ ጴዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ዼኤፒ ሃሣ ሚርጌና ቦንቺንታያ ማዔ ጎዳኮ ሙኮ ኬላ'' ሄላ''ንዳሢኮ ቤርታ ዓባ'' ዹማንዳኔ፤ ዓጊናኣ ሓሣ ሱጉሢ ማላንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ጎዳ ማኣዶ''ም ጌዒ ዔኤላ'' ዓሲ ቢያ ዻቃንዳኔ› » ሂዚ ጌዔሢ ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ጋዓዖ፥ ቃሲ'' ጊንሣ ጴፂሮሴ፦ «ሓይ ኑ ዓሶ ማዔ ዒስራዔኤሌ ዓሳ! ሓያ ታ ኬኤዛ ባኮ ኮሺ'' ዋይዙዋቴ፤ ዒንሢያ ቤርታዺ ዔራሢጉዲ ናዚሬቶ ዬሱሴ ፆኦሲዳፓ ዳኪንቲ ዒንሢ ባኣካ'' ጴዼያ ሃሣ ፆኦሱሞ ቢታንቶ ዒዛኮ ዓኣያኬ፤ ዬይ ፑኡፑማ ዒዛኮ ዔርቴሢ ፆኦሲ ዒዛ ዛሎ''ና ፆኦሲ ዎልቄና ማዺንታ ዓኪ ማዾ፥ ዲቃሣ ባኣዚ''፥ ዼኤፒ ማላታ ማዓ ባኣዚ'' ዒንሢ ቤርታ ማዺፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ፆኦሲ ቤርታዺ ማሌሢጉዴያና ሓሣ ማዺንታንዳሢ ዒ ዔሬ ጎይፆና ዒንሢም ዒዚ ዓኣሢንቲ ዒንጊንቴኔ፤ ዒንሢያ ዒዛ ፑርቶ ዓሶም ዒንጊ ሱፂንቲ ሓይቃንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ፆኦሲ ጋዓንቴ ሓይቢኮ ዓኣ ዎልቆ ሜንሢ ሓይቢፓ ዒዛ ዔቂሴኔ፤ ሓይቢያ ዒዛ ዓርቂ ቃዛኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳውቴ ዒዛ ዛሎ'' ኬኤዛዖ፦ ‹ጎዳ፡ ታኣኒ ቢያ ዎዴ ታኣኮ ቤርታ ዓኣንቴ ዛጋኔ፤ ዒ ታኣኮ ሚዛቆ ዛላ'' ዓኣሢሮ ታ ሂርጋዓ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ዬያሮ ታኣኒ ዎዛዻኔ፤ ዒና'' ሓሣ ታኣኮ ዎዛና ኩሜኔ። ሓይቃ ዓሽኬላ ታኣኮ ሓጊ ማዓንዳ ዎዛና ናንጋኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ሼምፔሎ ታኣኮ ኔ ሃይቄ ዓሶ ባኣካ'' ሓሺ''ንዱዋሴ፤ ኔኤኮ ጉሙርቂንታ ዓይላ''ሢ ዱኡፖ ዔቶይዳ ኔ ዎዒሲንዱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ናንጊኮ ጎይሢ ታኣም ኔ ዻዌኔ፤ ሓሣ ኔኤኒ ታኣና ዎላ'' ዓኣሢሮ ዎዛ'' ታኣኮ ጉቤ ዒናፓ ማዓንዳኔ› » ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ጌዔስካፓ፦ «ዒሾንሢዮቴ! ቤርታኣ ዓዶንሢዳፓ ፔቴ''ሢ ማዔ፥ ዳውቴ ሃይቂ ዱኡቴሢና ሓሣ ዒዛኮ ዱኡፓ ሓኖ'' ሄላ''ንዳኣና ኑ ኮራ ዓኣሢ ፔጌና ታ ዒንሢም ኬኤዛኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ዳውቴ ፆኦሲ ማሊሢ ኬኤዛያ ማዔሢሮ ሓሣ ፆኦሲ ዒዛም ‹ኔኤኮ ዜርፃፓ ፔቴ'' ዓሲ ታኣኒ ኔ ካኣቱሞ ቤዛ ጌሣንዳኔ› ጌዒ ጫኣቄሢሮ ዒዚ ዬያ ዔሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ዬያይዳፓ ዔቄያና ሜሲሔ ዱኡፖ ዔቶይዳ ዓቲንዱዋኣሢና ዓሽካ ዒዛኮ ዒኢካ ዎዒንዱዋኣሢ ቤርታዺ ዔሪ ዔቂፆ ዛሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ፆኦሲ ዬያ ዬሱሴ ሓይባ''ፓ ዔቂሴኔ፤ ኑኡኒያ ቢያሢ ዬያ ባኮኮ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ፆኦሲ ፔኤኮ ሚዛቆ ዛላ'' ቦንቺንቴ ቤዞ ዒዛም ዒንጌኔ፤ ሓሣ ዓዳሢዳፓ ዒንጊንታንዳኔ ጌይንቴ ዓያኖ ጌኤዦዋ ዔኬኔ፤ ሓያ ዒንሢ ዛጋ ባኮና ዋይዛ ባኮ ዒዚ ላኣሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","«ዓካሪ ጫሪንጮ ዓኣዼሢ ዳውቴቱዋሴ፤ ዳውቴ ፔ ቶኦኪና፥ ‹ናንጊና ናንጋ ጎዳ፡ ታ ጎዳሢም (ሜሲሔም) ኔ ሞርኮ ታ ኔና ባሺሳንዳያ ሄላ''ንዳኣና ታኣኮ ሚዛቆ ዛላ'' ዴዔ› ጌዔኔ ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«ማይ ዓካሪ ሓያ ዒንሢ ሱፄ ዬሱሴ ፆኦሲ ሜሲሔ ሓሣ ጎዳቲ ማሄሢ ዒስራዔኤሌ ዴራ'' ቢያ ጎኔና ዔሮንጎ!» ጴፂሮሴ ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ዓሳ ዬያ ዋይዜስካፓ ዒኔ ዱጲ ዖያዖ ጴፂሮሴንታ ዒዛና ዎላ'' ዓኣ ዳኪንቴዞንሢ ኮራ፦ «ዒሾንሢዮቴ! ዓካሪ ኑ ዎዶ''ንዶይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴፂሮሴ ማሓዖ፦ «ጎሞ ቡኡፁዋቴ፤ ጎማ ዒንሢኮ ዓቶም ጌይንታንዳጉዲ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ዋኣፆ ማስቱዋቴ፤ ፆኦሲ ዒንጊሢ ማዔ ዓያኖ ጌኤዦ ዒንሢ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ዓይጎሮ ጌዔቶ ፆኦሲኮ ዎዞ ቃኣላ'' ዒንሢንታ ዒንሢኮ ናኣቶ''ንታም ሓሣ ጎዳ ፆኦዛሢ ፔ ባንሢ ዔኤላ''ንዳ ሓጋ ሴካ ቤርታ ሙካንዳ ዓሶም ቢያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ሓሣ ዬያጉዲ ቃሲ'' ሚርጌ ባኣዚ'' ማርካ ማሂ ኬኤዚ ኬኤዚ፦ «ሓያ ዎቦ ሾይንቶይዳ ሄላ''ንዳ ባይሲንቶይዳፓ ዒንሢ ቶኦኮ'' ዻቂሹዋቴ» ጌዒ ዔያቶ ዞሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ዬያ ዓሶይዳፓ ሚርጌሢ ጴፂሮሴ ጌዔ ባኮ ጎኔኬ ጌዒ ዔኪ ዋኣፆ ማስቴኔ፤ ዬኖ ኬሎ''ና ሓይሦ ሺያ ማዓ ዓሲ ኪሪስቶሴ ጎናሲ ዔኪ ዔያቶይዳ ቃሲ''ንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ዬያታ ዳኪንቴዞንሢኮ ዔርዚፆ ዋይዚ ዋይዚ፥ ፔቱሞና ናሽኪንቲ ዎላ'' ናንጊ ናንጊ፥ ካሣኣ ዎላ'' ሙዒ ሙዒ ሺኢጲሢያ ዶዲ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ዬኖ ዎዶ''ና ዳኪንቴዞንሢ ዛሎ''ና ሚርጌ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ''ና ዲቃሣ ባኣዚ''ና ማዺንታያ ማዔሢሮ ዒዞ ዎዶ''ና ዒኢካ ናንጋ ዓሳ ቢያ ዬያ ባኮ ዲቃቲ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ኪሪስቶሴ ጉሙርቃ ዓሳ ጋዓንቴ ፔቱሞና ናንጋኔ፤ ዔያቶኮ ዓኣ ባካ ቢያሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ዔያታ ፔኤኮ ዓኣ ሳዖና ቆሎ''ና ሻንቺ ሻንቺ ሚኢሾ ዎሊም ኮይሳሢ ጎይፆ ፓቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ቢያ ኬሊ'' ጌኤዦ ማኣሮይዳ ፔቱሞና ቡኪንታኔ፤ ፔቴ'' ፔቴ''ሢኮ ማኣሮ ዓኣዺ ዓኣዺ ካሣ ዎላ'' ሙዒ ኮሺ ዒኔና ዎዛዺ ናንጋኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ፆኦሲያ ዔያታ ጋላታኔ፤ ዓሲ ቢያ ዔያቶ ቦንቻኔ፤ ፆኦሲ ሃሣ ዔያቶ ጊዳ'' ዻቃ ዓሲ ቢያ ኬሊ'' ቃሳ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ፔቴ'' ኬሊ'' ጴፂሮሴና ዮሓኒሴና ፆኦሲ ሺኢቆ ዎዳ'' ሄሌ''ም ጌኤዦ ማኣሪ ዓኣዼኔ፤ ዬና ዎዳ'' ማሢ ዶምቦልሳ ዎዴ ማዓኣናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ዒማ''ና ጌኤዦ ማኣሮ ጌሎ ካራ'' «ሚዛጲ ካራ» ጌይንታ ቤሲ ዓኣኔ፤ ዒዞ ቤዜሎይዳ ሾይንቴማፓ ዓርቃዖ ዎቦ ማዔ ዓሲ ዓኣኔ፤ ዬያ ዓሢ ዓሳ ቢያ ኬሊ'' ዔኪ ሙኪ ሙኪ ዒኢካ ጌሣኔ፤ ጌሤስካፓ ዒዚ ዒኢካ ዴዒ ጌኤዦ ማኣሮ ጌላ ዓሳ ዒዛም ዔኤቢ ዒንጋንዳጉዲ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ጴፂሮሴና ዮሓኒሴና ጌኤዦ ማኣሪ ጌላሢ ዬይ ዓሢ ዛጋዖ ዔኤቢ ዒንጎም ዔያቶ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ዔያታ ጋዓንቴ ዓሢ ኮሺ'' ዛጌስካፓ ጴፂሮሴ ዓሢ ኮራ፦ «ሂንዳ ኑ ባንሢ ዛጌ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ዎቦ ዓሢ «ታኣም ዔኤቢ ዒንጋንዳሲኑዋይ» ጌዒ ኮሺ'' ዔያቶ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ጴፂሮሴ ጋዓንቴ፦ «ቢራና ዎርቄና ታኣኮ ባኣሴ፤ ታኣኮ ዓኣማ ታ ኔኤም ዒንጋንዳኔ፤ ‹ናዚሬቶ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ዔቂ ሃንቴ› » ጌዒ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ሚዛቆ ኩጮ ዓሢኮ ዓርቂ ዔቂሴኔ፤ ዓሢኮ ቶኮ''ና ጪጊጮና ቤዞና ዶዴም፥ ");
INSERT INTO mdybse_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ላዓ ጌዒ ዔቂ ዔያቶና ዎላ'' ሓንቲ ጌኤዦ ማኣሪ ጌሌኔ፤ ሴካ ሓንጋ ጌዒያ ሃንቲ ሃንቲ ሓሣ ኮኦሚ ኮኦሚ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ዓሳ ቢያ ዒዚ ፆኦሲ ጋላቲ ጋላቲ ሃንታሢ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ጌኤዦ ማኣሮ ጌሎ ካራ'' «ሚዛጲ ካራ» ጌይንታ ቤዛ ዴዒ ሺኢቃሢ ዒዛ ማዔሢያ ዔያታ ዔሬኔ፤ ሓሣ ዒዛይዳ ማዺንቴ ባኮ ዛጋዖ ዲቃቲ ሄርሺሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ዬይ ዻቄ ዓሢ ጴፂሮሴና ዮሓኒሴናይዳፓ ታ ዱማዻዓ ጌዒ ዴንዶ ዒፂ «ሴሎሞኔ ዴማ'' ሃንታ፥ ዼኤፖ ዛምፓሢ» ጌይንታ ቤዞይዳ ዓኣንቴ፥ ዓሳ ዲቃቲ ሄርሺሢና ዒዞ ቤዜሎ ዔያቶ ባንሢ ጳሽኪ ሙኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴፂሮሴ ዓሶ ዛጋዖ፦ «ዒስራዔኤሌ ዓሲዮቴ! ሓያ ባኮ ዒንሢ ዓይጎሮ ዲቃቲ ሄርሻይ? ዓይጎሮ ዒንሢ ሓያይዲ ፔቶ'' ጊዥ ጌዒ ኑና ዛጋይ? ኑኡኒ ሓያ ዓሢ ኑ ዎልቄና ሓሣ ኑኡኒ ኮሺ ማዻያ ማዒ ዔቂሲ ሃንቲሴያ ዒንሢ ኮራ ማላ? ");
INSERT INTO mdybse_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ጋዓንቴ ዓብራሃሜኮ፥ ዪሳኣቄኮ፥ ያይቆኦቤኮ ፆኦዛሢ ሓሣ ቤርታኣ ኑ ዓዶንሢ ፆኦዛሢ ፔኤኮ ናዓሢ ዬሱሴ ቦንቼኔ፤ ዒንሢ ጋዓንቴ ዒዛ ሓይቃንዳጉዲ ጲላፆሴም ዓኣሢ ዒንጌኔ፤ ጲላፆሴ ዒዛ ሓሻ''ኒ ኮዓዛ ዒንሢ ‹ኑ ዒዛ ኮዑዋሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ጌኤሺ ማዔ ፂላ''ሢ ‹ኑ ዒዛ ኮዑዋሴ› ዒንሢ ጌዒ ፔቴ'' ዓሶ ዎዼ ዓሢ ቡሊ''ንታንዳጉዲ ጲላፆሴ ኮራ ዒንሢ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ሼምፖ ዒንጋያ ማዔሢ ዒንሢ ዎዼንቴ፥ ፆኦሲ ዒዛ ሓይባ''ፓ ዔቂሴኔ፤ ዬያ ባኮኮ ኑኡኒ ሓሢ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ሓይ ሓሢ ዒንሢ ዛጋ ዓሢ፥ ቤርታኣ ዒንሢ ዒዛ ዔራ ዓሢ ዻቂ ዶዴሢ ዬሱሴ ሱ'ንፆና ጴዼ ጉሙርቂሢናኬ፤ ዬሱሴ ሱ'ንፆ ጉሙርቂፆና ዒንሢ ቢያሢኮ ቤርቶይዳ ዻቂ ዓሲ ማዒ ዒዚ ጴዻኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ጴፂሮሴ ሓሣ ኬኤዛዖ፦ «ዒሾንሢዮቴ! ዬሱሴይዳ ዒንሢ ማዼ ባኮ ዒንሢኮ ሱኡጎጉዲ ዒንሢያ ዔሩዋዖ ማዼሢ ታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ፆኦሲ ጋዓንቴ ዬያ ማዼሢ' ‹ዒዛም ዱማዼ፥ ሜሲሔ ሜቶ ዔካንዳያ ኮይሳኔ› ጌይንቲ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ኬኤዚንቴሢ ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ዓካሪ ጎማ ዒንሢኮ ዓቶም ጌይንታንዳጉዲ ጎሞ ቡኡፁዋቴ፤ ፆኦሲ ባንሢያ ማዑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ዬያይዴቴ ዒንሢም ጎዳይዳፓ ዓያና ዛላና ዶዲሢ ዎዴ ሙካንዳኔ፤ ፆኦሲ ቤርታዺ ዒዛ ዶኦሬ ሜሲሔያ ዒንሢም ዳካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ዒዚ ጫሪጮይዳ ዴዓኒ ኮይሳሢ' ጌኤሺ ማዔ፥ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ፆኦሲ ቤርታዺ ኬኤዜሢጉዲ ዓጪ ካራና ቢያ ዓካዻንዳ ዎዳ'' ሄላ''ንዳኣናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙሴያ ኬኤዛዖ ‹ፆኦሲ ታና ኬሲ'' ዒንሢም ኬኤዚሳሢጉዲ ዒንሢኮ ጌርሲንሢ ባኣካ''ፓ ፆኦሲ ማሊሢ ኬኤዛያ ኬሳ''ንዳኔ፤ ዬይ ኬኤዛ ባኮ ቢያ ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ዬይ ፆኦሲ ማሊፆ ኬኤዛሢ ኬኤዛ ባኮ ዋይዙዋይ ቢያ ዴራ''ፓ ዱማዺ ባይቆንጎ› ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ፆኦሲ ማሊፆ ኬኤዛ ሳሙዔኤሌይዳፓ ዓርቂ ፆኦሲ ማሊፆ ኬኤዛ ዓሳ ቢያ ሓኖ'' ዎዶ'' ዛሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ኬኤዚንቴ ሓጊ ማዓንዳ ዎዛ'' ዒንሢሮኬ፤ ዬያጉዲ ፆኦሲ ዓብራሃሜም ‹ሳዖይዳ ዓኣ ዴራ'' ቢያ ኔ ዜርፆና ዓንጂንታንዳኔ› ጌዒ ኑኡኮ ዓዶንሢና ዎላ'' ጫኣቄ ጫኣቁማ ዒንሢማኣ ማዓያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ዬያሮ ፆኦሲ ቤርታዺ ፔ ናዓሢ ዳኬሢ ዒንሢምኬ፤ ዬያ ፆኦሲ ማዼሢ' ዬይ ናዓሢ ዒንሢ ፔቴ'' ፔቴ''ሢ ፑርቶ ጎይፃፓ ማሂ ሓሣ ዒንሢ ዓንጃንዳጉዲኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጴፂሮሴና ዮሓኒሴና ዴሮ''ም ኬኤዛ ጎይሣ ዓኣንቴ፥ ቄኤሶና ጌኤዦ ማኣሮ ካፓ ዓሶኮ ሱኡጋሢና ዬያጉዲ ሓሣ ሶዶቄ ጌይንታ ዓሳ ዔያቶ ኮራ ሙካዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ዬንሢ ላምዖ ዳኪንቴዞንሢ ዬሱሴኮ ሓይባ''ፓ ዔቂፆ ዛሎ'' ዒኢካ ዓሶ ዔርዜሢሮ፤ ሓሣ ዬያጉዲ ሓይቄ ዓሶኮ ዔቂሢ ዓኣያ ማዔሢ ዓሶም ፔጋሲ ኬኤዜሢሮ ዔያታ ዻጋና ጎሪ''ንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ሓሣ ዔያቶ ዓርቄኔ፤ ዒማ''ና ሳዓ ዓሜ''ያታሢሮ ሳዓ ካራንዳኣና ቱኡዞ ማኣራ ቱኪ'' ዎይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ያዒ ማዔቶዋ ዔያታ ኬኤዜ ቃኣሎ'' ዋይዜ ዓሶይዳፓ ሚርጌሢ ኪሪስቶሴ ጉሙርቄኔ፤ ዬማና ኪሪስቶሴ ጉሙርቃ ዓቲንቆኮ ፓይዳ'' ዶንጎ ሺያ ባንሢ ዼ'ግ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ዚሮ ጉቴ''ሎ ዓይሁዶ ዓሶኮ ሱኡጎና ጪሞ ማዔ ዓሶና ሙሴ ዎጎ ዔርዛ ዓሶና ዎላ'' ዬሩሳላሜይዳ ቡኪንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ዒኢካ ቡኬ ዓሶ ባኣካ'' ቄኤሶ ቢያኮ ሱኡጋሢ ማዔ፥ ሃኣናንታ ቃያፓንታ ዮሓኒሴንታ ዒስኪንዲሮሴንታ ቄኤሶ ሱኡጋሢኮ ዒጊኖ ማዔ ዓሳኣ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ዬካፓ ዔያታ ላምዖ ዳኪንቴዞንሢ ዔኪ ሙኪ ዔያቶ ባኣካ'' ዔቂሳዖ፦ «ሓያ ዒንሢ ዓይጎ ዎልቄና ሓሣ ዖ ሱ'ንሢና ማዼይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ዬማና ጴፂሮሴ ዓያና ጌኤሺ ቢታንቶ ዴሞ ጌሊ፦ «ዒንሢ ዴሮ''ኮ ሱኡጎና ጪሞ ማዔ ዓሳ! ");
INSERT INTO mdybse_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ኑኡኒ ሓኖ'' ዖኦጪንታሢ ፔቴ'' ዎቦ ዓሢም ኮሺ ባኣዚ'' ማዺንቴሢሮና ሓሣ ዒዚ ዎይቲ ዻቄታቶዋ ዬኖ ዛሎ''ሮ ማዔቶ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ሓይ ዓሢ ዻቂ ዒንሢ ቤርታ ዔቄሢ፦ ዒንሢ ሱፄሢ ሓሣ ፆኦሲ ሓይባ''ፓ ዔቂሴሢ፥ ናዚሬቶ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ማዔያታሢ ዒንሢንታ ዒስራዔኤሌ ዴሮ'' ቢያሢም ዔርቴያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ዒንሢ ማኣሮ ማዣ ዓሳ ቦሂ ኬኤሬ ሹጫሢ ዒዛኬ፤ ጋዓንቴ ዒዚ ማኣሮ ዶዲሺ ዓርቃ ሄላ''ሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ዬያሮ ዻቂንታ ዒዛና ማዓንዳፓዓቴም ሜሌ'' ዓይጎ ዓሲናታዖ ባኣሴ፤ ዓይጎሮ ጌዔቶ ኑ ዻቃኒ ኮይሳያ ሓሣ ፆኦሲ ዓሲም ዒንጌ ሱ'ንሢ ዒዛ ሱ'ንፆይዳፓ ዓታዛ ዓጮ'' ቢያይዳ ዖኦኒያ ባኣሴ» ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ዎጎ ዎጋ ዓሳ ጴፂሮሴና ዮሓኒሴና ዒጊጩዋዖ ቢያ ባኮ ጎናሲ ኬኤዛሢ ዛጌ ዎዶ''ና ዔርዞ ማኣሮ ጌሊባኣ፥ ጉሪ ዓሲታሢ ዔያቶ ዔራያታሢሮ ዲቃቲ ሄርሻዖ፥ ዔያታ ዬሱሴና ዎላ'' ዓኣያ ማዔሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ዻቄ ዓሢያ ጴፂሮሴና ዮሓኒሴና ኮራ ዔቂ ዓኣሢ ዛጋዖ ጎዖንዶ ጎይሢ ዔያታ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ዬያሮ ዎጎ ዎጎ ቤዞይዳፓ ዻካ''ሮ ዔያቶ ሺኢሻዖ ሂዚ ጌዒ ዔያታ ዞርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«ዓካሪ ሓንሢ ዓሶንሢ ኑ ዎዶ''ንዶይ? ሓይ፥ ፆኦሲ ዎልቄና ማዺንታ ዼኤፖ ዓኮ ባካ ዔያቶ ዛሎ''ና ማዺንቴሢ ዬሩሳላሜ ዓጫ'' ናንጋ ዓሶም ቢያ ዋይዚንቴኔ፤ ዬያሮ ኑ ዔሩዋሴ ጋዓኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ጋዓንቴ ዴሮ'' ባኣካ'' ሓይ ዳልጊ ዴንዱዋንቴ ሓካፓ ሴካ ዬሱሴ ሱ'ንፆ ዔኤሊ'' ዖኦማኣ ዔያታ ዔኤቢ ኬኤዙዋጉዲ ‹ዒንሢና ዔሩዋቴ!› ኑ ጋዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ዬካፓ ዔያታ ጴፂሮሴና ዮሓኒሴና ዔኤላ''ዖ ዬሱሴ ሱ'ንፆ ዔኤሊ'' ፔቴ''ታዖ ዔኤቢ ኬኤዙዋጉዲና ሃሣ ዔርዙዋጉዲ ኮሺ'' ላቲ'' ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ጴፂሮሴና ዮሓኒሴና ጋዓንቴ ማሃዖ፦ «ፆኦሲም ዓይሢንቲፃፓ ባሼ ዒንሢም ዓይሢንቲሢ ፆኦሲ ቤርቶይዳ ኮይሳያዳ? ዒንሢ ሂንዳ ዒንሢ ቶኦኪና ዎጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ኑም ጋዓንቴ ዛጌሢና ዋይዜሢና ኬኤዚሢ ሓሺ''ንታዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ዴሮ''ኮ ሱኡጎና ዎጎ ዎጋ ዓሶና ጴፂሮሴና ዮሓኒሴናይዳ ጌስቲ ዎጎንዶ ባኣዚ'' ዴንቂባኣሢሮ ዴሮ''ዋ ሃሣ ዔያታ ዒጊጬሢሮ ጊንሣ ሓሣ «ዒንሢና ዔሩዋቴ» ጌዒ ላታ''ዖ ሓሼ''ኔ። ዓይጎሮ ጌዔቶ ዴራ'' ማዺንቴ ባኮሮ ፆኦሲ ጋላታያ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ዬያ ፆኦሲ ዎልቆና ማዺንቴ ዓኮ ባኮና ዻቄ ዓሢኮ ሌዓ ዖይዲታሚ''ፓ ዑሣኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጴፂሮሴና ዮሓኒሴና ቡሊ''ንቲ ኪሪስቶሴ ጉሙርቃዞንሢ ኮራ ሙካዖ ቄኤሶኮ ሱኡጎና ዓይሁዶ ዓሶኮ ጪሞና ዔያቶ ኮራ ጌዔ ባኮ ቢያ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ዔያቶኮ ላጎንሢያ ዬያ ዋይዛዖ ዑኡዞ ፔኤሲ'' ዼ'ጊዲ ፆኦሲ ሂዚ ጌዒ ሺኢቄኔ፦ «ጫሪንጮንታ ሳዖንታ ባዞ''ንታ ሃሣ ዬያ ባኮ ቢያይዳ ዓኣ ባኮ ቢያ ዎይሣሢና ማዤ ጎዳሢዮ! ");
INSERT INTO mdybse_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ዓያኖ ጌኤዣ ማኣዴ''ም ማዻ ኔ ዓይላ''ሢ፥ ኑ ዓዳሢ ዳውቴ ዛሎ''ና፦ ‹ዓይሁዴ ማዒባኣ ዓሳ ዓይጎሮ ጎሪ''ንቲ ጉንዱሜይ? ዴራ'' ሃሣ ጉሪ ፓሡዋ ባኣዚ'' ዓይጎሮ ማሌይ? ");
INSERT INTO mdybse_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ሳዖኮ ካኣታ'' ዎሊ ጊንፆ ዔቂ ዎይሣ ዓሳኣ ፔቴ''ይዳ ቡኪንቲ ጎዳና ሜሲሔናይዳ ሞርኬ ማዒ ዔቄኔ› » ሂዚ ጌዒ ኬኤዜሢ ጎኔኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ሓሣ ዔያታ ጋዓዖ፦ «ጎኔና ሄሮዲሴንታ ጴንፆስጲላፆሴንታ ዓይሁዴ ማዒባኣ ዓሶንታ ዒስራዔኤሌ ዴሮ''ንታ ዎላ'' ሓኖ'' ካታሜሎይዳ ቡኪንቲ ኔኤኒ ሜሲሔ ማሄ ኔኤም ማዻ፥ ዱማዼ፥ ዬሱሴ ዑፆይዳ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ያዺ ዔያታ ማዼሢ' ቤርታዺ ኔኤኒ ኔ ዎልቆና ሓሣ ኔ ማሊፆና ማሌ ባኮ ኩንሣኒኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ሓሢያ ጎዳሢዮ! ዔያቶኮ ዚርቂፆ ዋይዜ፤ ኔኤም ማዻ ዓይላ'' ቃኣሎ'' ኔኤሲ'' ዒጊቹሞ ባኣያ ጫርቂ ኬኤዛንዳጉዲ ማዼ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ኔኤም ዱማዺ ማዻ፥ ዬሱሴ ሱ'ንፆና ሃርጊንቴ ዓሳ ዻቃንዳጉዲና ሓሣ ኔ ዎልቆና ማዺንታ ዓኪ ባኣዚ''ና ማላታና ማዺንታንዳጉዲ ዎልቆ ኔኤሲ'' ዻዌ» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ሺኢቂ ዔያታ ጋፓማና ዔያታ ዓኣ ቤዛ ዓጊፄኔ፤ ጉቤሢ ዬማና ዓያና ጌኤሺ ቢታንቶ ዴሞ ጌሌኔ፤ ፆኦሲኮዋ ቃኣሎ'' ዔያታ ዒጊቹሞ ባኣያ ጫርቂ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ኪሪስቶሴ ጉሙርቃ ዓሶኮ ቢያ ፔቴ'' ዒኔና ፔቴ'' ማሊሢና ዓኣኔ፤ ዖና ማዔቶዋ «ሃይ ታኣሮኬ» ጋዓ ባኣዚ'' ባኣሴ፤ ዔያቶኮ ዓኣ ባካ ቢያ ፔቴ''ይዳኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ዳኪንቴዞንሢያ ጎዳ ዬሱሴኮ ሓይባ''ፓ ዔቂፆ ዼኤፒ ዎልቄና ማርካዺ ኬኤዛኔ፤ ፆኦሲያ ዔያቶ ቢያሢም ሚርጌ ዼኤፒ፥ ኮሺ ማዾ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ሳዓታቶዋ ማኣሪታቶዋ ዔያቶኮ ዓኣ ባኮ ቢያ ሻንቺ ሻንቺ ሚኢሾ ዔኪ ሙኪ ፔቴ''ይዳ ጌሢ ማኣዲ''ንታሢሮ ዔያቶ ባኣኮ''ይዳ ፔቴ''ታዖ ሜታዻ ዓሲ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ሚኢሾ ዔያታ ዔኪ ሙካዖ ዳኪንቴዞንሢም ዒንጋኔ፤ ዬያሮ ፔቴ'' ፔቴ''ሢም ኮይሳሢጉዴያ ጊሽኪንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ቆጲሮሴ ጌይንታ ዓጪዳ ሾይንቴ ዮሴፔ ጌይንታ ፔቴ'' ሌዊ ፃጳፓ ማዔስኬያ ዓኣኔ፤ ዳኪንቴዞንሢያ ዒዛኮ ሱ'ንፆ «ባርናባሴ» ጋዓኔ። ዬኖኮ ቡሊ''ፃ «ዶዲሻ ናይ» ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ዒዚያ ፔኤኮ ሳዖ ሻንቺ ሚኢሾ ዔኪ ሙኪ ዳኪንቴዞንሢም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ፔቴ'' ሓናኒያ ጎዖ ዓሲስኬያ ሳጲራ ጌይንታ ዒዛኮ ማቾስኬኖና ዎላ'' ሳዓ ሻንቼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ማቻ ዒዛኮ ዔራንቴ ሳዖ ሻንቾና ሚኢሾይዳፓ ፓቂ፥ ዓይሲ ዔኪ ሙኪ ዳኪንቴዞንሢም ዒንጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ጴፂሮሴ ጋዓንቴ ዒዛም፦ «ሓናኒያ! ዓያኖ ጌኤዦም ኔ ሉኡቃንዳጉዲ ሓሣ ሳዖ ኔ ሻንቼ ሚኢሾኮ ዛሎ'' ፓቂ ዓይሳንዳጉዲ ማዼ ፃላሄ ዒና'' ኔኤኮ ዓይጋ ጌሌይ? ");
INSERT INTO mdybse_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ኔኤኒ ሳዖ ሻንቺባኣንቴ ቤርታ ኔኤሮቱዓዳ? ሓሣ ኔ ሻንቼስካፓ ሚኢሻ ኔኤሮቱዋይ? ሂዳዖ ሓያ ባኮ ዓይጋ ኔ ዒኖና ማሌይ? ኔ ሉኡቄሢ ፆኦሲም ማዓንዳኣፓዓቴም ዓሲምቱዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሓናኒያ ዬያ ዋዋይዛዖ ሎኦሚ ሓይቄኔ፤ ዬኖ ባኮ ዋይዜ ዓሳ ቢያ ኮሺ'' ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ዓሲስኬንሢ ዒማ''ና ሌዞ ዒዛኮ ሱኡዳዖ ዔኪ ዓኣዺ ዱኡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ዬካፓ ኔጌንቴ ሓናኒያኮ ማቻ ዒዞ ቤዞ ሙኬኔ፤ ዓኒዳ ማዺንቴ ባኮ ጋዓንቴ ዒዛ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴፂሮሴ ዒዞ ኮራ፦ «ሂንዳ ታኣም ኬኤዜ፤ ዒንሢ ሳዖ ዒንሢኮ ሻንቼሢ ሓንሢጉዴ ሚኢሼምዳ?» ጌዔኔ። ዒዛ ማሓዖ፦ «ሂዮ፥ ዬንሢጉዴ ሚኢሼምኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ዬማና ጴፂሮሴ፦ « ‹ፆኦሲኮ ዓያና'' ዎይታቴ ሂንዳ ኑ ዛጎም ጌዒ ዎዲ'' ዒንሢ ዎላ'' ጌስቴይ?› ሓይሾ ኔኤኮ ዓኒ ዱኡኪ ማዓ ዓሳ ካራ'' ዓኣኔ፤ ኔናኣ ሓሣ ዔያታ ዔኪ ዓኣዺ ዱኡካንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ዒዛኣ ቤዞማና ቶኮ'' ዴማ'' ዒዛኮ ሎኦሚ ሓይቄኔ፤ ዓሶንሢ ጌላንቴ ዒዛ ሓይቂ ዓኣ ጋዓዛ፥ ዔኪ ዓኣዺ ዓኒ ዱኡፖ ኮራ ዱኡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ሺኢጲፆ ማኣሮ ዓሶ ቢያሢዳ፤ ሓሣ ጊንሣ ዬያ ባኮ ዋይዜ ዓሶ ቢያሢዳ ዒጊቹሞ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ሚርጌ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ''ና ዲቃሣ ባኣዚ''ና ዳኪንቴዞንሢ ዛሎ''ና ዒማ''ና ማዺንታኔ፤ ሓሣ ኪሪስቶሴ ጉሙርቃዞንሢያ ፔቴ'' ዒኔና ማዒ «ሴሎሞኔ ዴማ'' ሃንታ፥ ዼኤፖ ዛምፓሢ» ጎዖ ቤዞይዳ ቡኪንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ዔያቶይዳፓዓቴም ጉሪ ሜሌ'' ዓሲ ማዔያ ፔቴ''ታዖ ዔያቶና ዎላ'' ማዓኒ ጫርቂባኣሴ፤ ያዺ ማዔቴያ ዴራ'' ዔያቶ ቦቦንቻኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ጎዳ ጉሙርቃ ዓሶ ዓቲንቆና ላኣሎናኮ ፓይዳ'' ኮሺ'' ሚርጊ ሚርጊ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ዳኪንቴዞንሢ ዛሎ''ና ማዺንታ ዲቃሣ ማዾ''ሮ ጌዒ ዓሳ ዺቢ ሃርጊንቴ ዓሲ ጎይፆይዳ ኬሲ'' ኬሲ''፥ ዛሎ'' ሻኣላ''ይዳ ዛሎ'' ሃላሢዳ ላይሣኔ፤ ያዒ ዔያታ ማዼሢ ጴፂሮሴ ዬይና ዓኣዻኣና ዔኤዦ ሺባታዖ ፔቴ'' ፔቴ'' ዓሶ ዑፆ ሄላ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ዬሩሳላሜ ኮይላ'' ዓኣ ካታማፓ ዓሳ ፔኤኮ ሃርጊንቴ ዓሶና ፑርታ ዓያናና ሜታዻ ዓሶ ዔኪ ሙካኔ፤ ቢያሢያ ዶርዓሢዳፓ ፖዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ዬያይዳፓ ዔቄያና ቄኤሶኮ ሱኡጋሢና ዒዛና ዎላ'' ዓኣ ሶዶቄ ዓሶ ዜርፃ ቢያ ሞርኬ ማዒ ዳኪንቴዞንሢ ዑፃ ዔቄኔ፤ ሓሣ ዔያቶ ዒናፓ ቂኢሪ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ዓርቂ ዔኪ ዴሮ''ኮ ቱኡዞ ማኣራ ጌልዚ ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ፆኦሲኮ ኪኢታንቻ ጋዓንቴ ዹሞና ቱኡዞ ማኣሮኮ ካሮ'' ቡሊ'' ዔያቶ ኬሳ''ዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«ዴንዲ ሺኢጲፆ ማኣሮይዳ ዔቂ ዴሮ''ም ሓያ ሼምፖ ቃኣሎ'' ቢያ ኬኤዙዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ዳኪንቴዞንሢያ ዬኖ ዓይሢፆ ዔኪ ጉቴ'' ዓሚ'' ሺኢጲፆ ማኣሪ ጌላዖ ቃኣሎ'' ኬኤዚሢ ዓርቄኔ፤ ዒማ''ና ቄኤሶኮ ሱኡጋሢንታ ዒዛና ዎላ'' ዓኣ ዓሶንታ ሓሣ ዎጎ ዎጋ ዓሶንታ ዓይሁዶ ዓሶኮ ጪሞንታ ቢያ ሙኪ ፔቴ''ይዳ ቡኪንቴኔ፤ ዬካፓ ዳኪንቴዞንሢ ቱኡዞ ማኣራፓ ዴንዲ ዔኪ ሙካንዳጉዲ ዓሲ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ኪኢቶ''ና ዓኣዼ ዓሶንሢ ጋዓንቴ ቱኡዞ ማኣሪ ዓኣዻዖ ዳኪንቴዞንሢ ዒኢካ ዴንቂባኣሴ፤ ዬያሮ ማዒ ሙካዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«ቱኡዞ ማኣሮኮ ካራ'' ኮሺ'' ዎዺንቲ፥ ካፓ ዓሳ ሓሣ ካራ'' ዔቂ ዓኣንቴ ኑ ዴንቄኔ፤ ቱኡዞ ማኣሮኮ ካሮ'' ኑ ቡላ''ዖ ጋሮይዳ ፔቴ''ታዖ ዓሲ ዴንቂባኣሴ» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ጌኤዦ ማኣሮ ካፓ ዓሶ ዓይሣሢና ቄኤሶኮ ሱኡጎና ዬያ ዋይዛዖ፦ «ሓይ ዓይጎ ባኣዚ'' ናንዳይ?» ጌዒ ዔያቶ ዛሎ'' ጎዖንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ዬማና ፔቴ'' ዓሲስኬያ ሙካዖ፦ «ዒንሢ ቱኡዞ ማኣራ ቱኬ'' ዓሶንሢ ሓይሾ ጌኤዦ ማኣሮይዳ ዔቂ ዴሮ'' ዔርዛኔ» ጌዒ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ጌኤዦ ማኣሮ ካፓ ዓሶኮ ሱኡጋሢ ዒዛኮ ዓይሢንቲ ማዻ ዓሶና ዎላ'' ኔጉዋዖ ዴንዲ ዳኪንቴዞንሢ ዔኪ ሙኬኔ፤ ዔያታ ዔኪ ሙኬሢ' ዎልቄናቱዋንቴ ጌሺሢናኬ፤ ያዺ ዔያታ ማዼሢ' ዴራ'' ዔያቶ ሹቻ ዹዓንዳኔ ጌዒ ዒጊጬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ዔያታ ዔኪ ሙካዖ ዎጎ ዎጋ ዓሶ ቤርታ ዔቂሳዛ፥ ቄኤሶኮ ሱኡጋሢ ዔያቶ ኮራ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«ዬሱሴኮ ሱ'ንፆ ዔኤሊ'' ፔቴ'' ባኣዚ''ታዖ ዒንሢ ዔርዙዋጉዲ ላቲ'' ዒንሢ ኑ ዓይሤኔ፤ ሓሢ ዒንሢ ጋዓንቴ ዬሩሳላሜ ዓጮ'' ቢያ ዔርዚ ሓይሾ ኩርሴኔ፤ ዒንሢ ሃና ዓሳ ዬያ ዓሢኮ ሱጉፆ ኑ ዑፃ ማሃኒ ኮዓያኬ ሃይሾ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጴፂሮሴንታ ዒዛና ዎላ'' ዓኣ ዳኪንቴዞንሢንታ ማሓዖ፦ «ዓሲም ዓይሢንቲሢፓ ፆኦሲም ዓይሢንቲሢ ኑና ኮይሳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ኑ ዓዶንሢ ፆኦዛሢ' ሚፆይዳ ዒንሢ ሱፂ ዎዼ ዬሱሴ ሓይባ''ፓ ዔቂሴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ዬይ ዬሱሴ ዒስራዔኤሌ ዴሮ'' ጎማፓ ማሓንዳጉዲና ጎሞ ዓቶም ጋዓንዳጉዲ ፆኦሲ ዒዛ ዓርና ሓሣ ዻቂሻያ ማሂ ፔኤኮ ሚዛቆ ዛላ'' ቦንቾና ጌሤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ዬያ ባኮኮ ኑናንታ ፆኦሲ ፔኤም ዓይሢንታ ዓሶም ቢያ ዒንጌ ዓያኖ ጌኤዦንታ ማርካኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ዎጎ ዎጋ ዓሳ ዬያ ዋይዛዖ ኮሺ'' ዻጋዺ ዳኪንቴዞንሢ ዎዻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ጋዓንቴ ዴሮ'' ባኣካ'' ቦንቺንታያ ሙሴ ዎጎ ዔርዛ ጌማሊያሌ ጌይንታ ፔቴ'' ፔርሴ ዓሲስኬይ ዔቃዖ ዻካ''ሮ ዎጎ ዎጋ ዓሶ ቤርታፓ ዳኪንቴዞንሢ ሺኢሻንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ዬካፓ ዎጎ ዎጋ ዓሶም፦ «ዒስራዔኤሌ ዓሲዮቴ! ዒንሢ ሓኖ' ዓሶይዳ ዓይጎ ማዻኒ ማላቴያ ዒንሢና ኮሺ'' ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ሃያኮ ቤርታ ዬያጉዲ ቴዎዳሴ ጌይንታ ዓሲ ‹ታ ዼኤፒኬ› ጌዒ ዔቄኔ፤ ሓሣ ዒዛና ዎላ'' ዖይዶ ፄኤታ ዓሲ ፔቴ'' ማዔኔ፤ ጋዓንቴ ዬያ ዎዾም ዒዛኮ ጊንፆ ሓንታ ዓሳ ላኣሊንቲ ባይቃዛ ማሊፃ ዒዛሲያ ባይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ዬካፓ ሓሣ ዴራ'' ፓይዲንቴ ዎዶ''ና ጌሊላ ዓጪ ዓሲ ማዔ፥ ዪሁዳ ጎዖሢ ዔቂ ሚርጌ ዴሬ ዒዛ ጊንፆ ሃንታንዳጉዲ ማሄኔ፤ ዒዚያ ዎዺንቴኔ፤ ዒዛ ጊንፆ ሓንታ ዓሳኣ ላኣሊንቲ ባይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ዬያሮ ሓሢ ታ ዒንሢም ጋዓሢ ሓንሢ ዓሶንሢዳፓ ሓኪ ዒንሢ ዔያቶ ሃሻ''ንዳጉዲኬ፤ ዓይጎሮ ጌዔቶ ሓይ ማሊፃ ሓሣ ሃይ ማዻ'' ዓሲፓ ሙኬያታቶ ባይቃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ፆኦሲፓ ሙኬያ ማዔቶ ጋዓንቴ ዔያቶ ዒንሢ ባይዛኒ ዳንዳዑዋሴ፤ ፔቶ'' ዬይ ዒንሢኮ ፆኦሲና ዎላ'' ፑርቲሢ ማዓንዳኔ» ጋዓዛ፥ ዔያታ ጌማሊያሌኮ ዞሮ'' ዋይዚ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ዬካፓ ዔያታ ዳኪንቴዞንሢ ዔኤላ''ዖ ጳርቂሲ ዬሱሴኮ ሱ'ንፆ ዔኤሊ'' ዓሶ ዔርዙዋጉዲ ላታ''ዖ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ዳኪንቴዞንሢ ጋዓንቴ ዬሱሴ ዛሎ''ና ቦርሲንቲታቶዋ ዔካኒ ጊኢጌያታሢሮ ዎዛዺ ዎዛዺ ዎጎ ዎጋ ዓሶ ቤርታፓ ኬስኪ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ቢያ ኬሊ'' ጌኤዦ ማኣሮና ዓሶኮ ማኣሮናይዳ ሜሲሔ ማዔ፥ ዬሱሴ ዛሎ'' ኬኤዚፆንታ ኮዦ ሓይሶ ኬኤዚፆዋ ዔያታ ሓሺ''ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ዬካፓ ኪሪስቶሴ ጉሙርቃ ዓሶኮ ፓይዳ'' ሚርጊ ሚርጊ ዓኣዻዛ ጊሪኬ ሙኡጮ ጌስታ ዓይሁዶ ዓሳ ዬሩሳላሜይዳ ናንጋ ዓይሁዶ ዓሶ ዑፆይዳ ጉንዱሞ ዓርቄኔ፤ ዓይጎሮ ጌዔቶ ኬሊ'' ኬሊ'' ሙዖ ባካ ዒንጊንታ ዎዶ''ና ዔያቶኮ ባኣካ'' ዓኒንሢ ሓይቄ ላኣሎ ዬሩሳላሜ ዓይሁዶ ዓሳ ዋላ''ሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ዬያሮ ታጶ ላምዖንሢ ኪሪስቶሴ ጉሙርቃ ዓሶ ፔቴ''ይዳ ቡኩሳዖ፦ «ሙኡዚ'' ጊሽኪሢሮ ጌዒ ፆኦሲ ቃኣሎ'' ዔርዚፆ ማዾ'' ኑና ሓሻ''ኒ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ዓካሪ ታ ዒሾንሦ! ታ ሚሾንሦ! ኮሺ ዒኔና ዓኣያ ማዒ ማዾና ቢያሢ ጋላቲሳያ፥ ዓያና ጌኤሺ ኩሙሢ ዎልቄና ማዻያ ሓሣ ሚርጌ ዔራ ማዔ ላንካይ ዓሲ ዒንሢ ባኣካ''ፓ ዶኦሩዋቴ፤ ዬያቶ ኑኡኒ ሃኖ' ማዾ'' ማዺሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ኑኡኒ ጋዓንቴ ሺኢጲፆንታ ፆኦሲ ቃኣሎ'' ዔርዚፆ ማዾ''ዋ ዶዲ ማዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ዬና ጌኤዛ ቢያሢ ዎዛሴኔ፤ ሓካፓ ሊካ ዓኣ ዓሶዋ ዔያታ ዶኦሬኔ፤ ጉሙርቂሢ ዓኣያ ሓሣ ዓያና ጌኤሺ ቢታንቶ ዴሞ ጌሌ ዒስፂፓኖሴ፥ ፒልጶሴ፥ ጲሮኮሮሴ፥ ኒቃሮና፥ ፂሞና፥ ጴርሜ፥ ዓይሁዴቱዋዖ ዓይሁዴ ማዔ ዓንፆኪያ ዓጮ'' ዓሢ ኒቆላዎሴ ጎዖሢንታኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ዬንሢ ዔያታ ዳኪንቴዞንሢ ቤርቶ ሺኢሼኔ፤ ዳኪንቴዞንሢያ ሺኢቃዖ ኩጮ ዔያቶ ዑፃ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ያዺዲ ፆኦሲኮ ቃኣላ'' ዳልጊ ዳልጊ ዓኣዼሢሮ ዬሩሳላሜይዳ ኪሪስቶሴ ጉሙርቃ ዓሶኮ ፓይዳ'' ሚርጊ ሚርጊ ዓኣዼኔ፤ ቄኤሶይዳፓኣ ሚርጌሢ ኪሪስቶሴ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ዒስፂፓኖሴ ፆኦሲኮ ኮሹሞ ዒንጊፆ ዔኪ ዎልቄና ማዒ ዲቃሣ ባኣዚ''ንታ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ''ያ ዴሮ'' ባኣካ'' ዬኖ ዎዶ''ና ማዻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ዒማ''ና «ዱማዺ ኬስኬ ዓሶ ሺኢጲፆ ማኣሮ» ጌይንታ ዓይሁዶ ዓሶኮ ሺኢጲፆ ማኣራፓ ማዔ ዓሳ፥ ቄሬናና ዒስኪንዲሪያ ዓጮ'' ዓሳ፥ ኪልቂያንታ ዒሲያ ዓጮ'' ዓሶንታ ፔቴ''ይዳ ዔቂ ዒስፂፓኖሴ ዒፂ ማርማኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ጋዓንቴ ዒስፂፓኖሴ ኬኤዛ ዔራቶና ዓያኖና ዔያታ ባሻኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ዒማ''ና፦ «ሓይ ዓሢ ሙሴና ፆኦሲና ጫሽካንቴ ኑ ዋይዜኔ» ጋዓንዳ ዓሲ ዔያታ ዴሚ''ና ጊኢጊሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ዬያይዲ ዴሮ''ንታ ጪሞንታ ሓሣ ሙሴ ዎጎ ዔርዛ ዓሶዋ ዔያታ ዔቂሲ፥ ዒስፂፓኖሴያ ዓይሢሲ ዎጎ ዎጋ ዓሶ ቤርቶ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ዒማ''ና ዒዛ ዑፃ ሉኡዙሞና ማርካዻንዳ ፔቴ'' ፔቴ'' ዓሲያ ዔያታ ዔኪ ሙኬኔ፤ ሉኡዙሞና ማርካዻ ዓሳ ኬኤዛዖ፦ «ሓይ ዓሢ ሓያ ጌኤዦ ማኣሮና ሙሴ ዎጎና ጫሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ሓሣ ‹ናዚሬቶ ዬሱሴ ሓያ ማኣሮ ሻሃንዳኔ፤ ሙሴ ኑና ዓይሤ ዎጎዋ ላኣማንዳኔ› ጌዒ ኬኤዛንቴ ኑ ዋይዜኔ» ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ዬማና ዎጎ ዎጊፆይዳ ዓኣ ዓሳ ቢያ ዒስፂፓኖሴ ኮሺ'' ዛጋዛ፥ ዓኣፖ ካራ'' ዒዛኮ ፆኦሲ ኪኢታንቻ ዓኣፒ ካራጉዲ ማሊ ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ቄኤሶኮ ሱኡጋሢ ዒስፂፓኖሴ ኮራ፦ «ዬይ ጌይንቴ ባካ ጎኔዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ዒስፂፓኖሴ ሂዚ ጌዒ ማሄኔ፦ «ታ ዒሾንሦ! ታ ዓዶንሦ! ሂንዳ ዋይዙዋቴ፤ ኑ ዓዳሢ ዓብራሃሜ ካኣራኔ ዓጮ''ይዳ ናንጊፆሮ ዓኣዻንዳሢኮ ቤርታ ሜሶፖታሚያ ዓጫ'' ዓኣንቴ ቦንቺንቴ ፆኦዛሢ ዒዛም ጴዻዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹ኔ ዓጫ''ፓ ኬስኪ ሓሣ ኔ ዒጊኖይዳፓ ዱማዺ ታ ኔና ዻዋ ዓጮ'' ዓኣዼ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ዒማ''ና ዒዚ ካላዳ ዓሶ ዓጫ''ፓ ኬስኪ ካኣራኔይዳ ዴዔኔ፤ ዒዚ ዒኢካ ዓኣንቴ ዓዴ ሓይቃዛ ካኣራኔ ዓጮ''ይዳፓ ኬሲ'' ሃሢ ዒንሢ ናንጋ ዓጬ''ሎ ፆኦሲ ዒዛ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ያዺ ማዔቶዋ ቶኪ ሄ'ርቃንዳ ቤሲጉዴያታዖ ፆኦሲ ዒዛም ዒንጊባኣሴ፤ ጋዓንቴ ሓኖ' ዓጬሎ ዒዛና ዒዛኮ ፃጶናም ሓጊ ዓጪ ማሂ ዒዛም ዒንጋንዳሢ ጫኣቄኔ፤ ዬኖ ፆኦሲ ዒዛም ጫኣቄሢ' ዓብራሃሜኮ ሓጊ ናይ ባኣንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ዜርፃ ዒዛኮ ዓሲ ዓጪዳ ዒፂንቲሢና ዳውሲንቲ ናንጋንዳሢ ሓሣ ዬኖ ዓጮ''ይዳ ዖይዶ ፄኤታ ሌዔ ዓሳ ዔያቶ ዓይሌ'' ማሂ ሜታሲ ዎይሣንዳሢ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ሓሣ ‹ዓይሌ'' ማሂ ዎይሣ ዴሮ'' ታኣኒ ፑርታና ዎጋንዳኔ፤ ዬካፓ ዔያታ ዓይሉ''ማፓ ኬስኪ ሃኖ' ቤዞይዳ ታና ካኣሽካንዳኔ› ሂዚ ጌዒ ፆኦሲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ቃሳ''ዖ ሓሣ ዓቲንቶ ቤርቶ ቲቂፆ ዎጎዋ ዒንጌኔ። ዬያሮ ዓብራሃሜ ዪሳኣቄ ሾዔስካፓ ሳላ''ሳ ኬሎ''ና ዓቲንቶ ቤርቶ ዒዛኮ ቲቄኔ፤ ዪሳኣቄ ያይቆኦቤ ሾዔኔ፥ ያይቆኦቤያ ዱማ ዱማ ዒስራዔኤሌ ፃጶኮ ዓዶንሢ ማዔ ታጶ ላምዖ ናኣቶ'' ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«ያይቆኦቤኮ ናኣታ'' ዔያቶኮ ጌርሲ ዮሴፔ ቂኢሪ ጊብፄ ዓጫ'' ዓይሌ'' ማዓንዳጉዲ ሻንቼኔ። ፆኦሲ ጋዓንቴ ዒዛና ዎላ'' ማዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ሜቶ'' ቢያሢዳፓኣ ዒዛ ኬሴ''ኔ፤ ሓሣ ጊብፄ ካኣቲ ቤርቶይዳ ቦንቺንቲና ዔራቶና ዒዛም ዒንጌኔ፤ ካኣቲያ ጊብፄ ዓጮ'' ቢያና ፔ ማኣሮናይዳ ሱኡጌ ዒዛ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ዬኖ ዎዶ''ና ጊብፄ ዓጮ''ና ካኣናኔ ዓጮ''ናይዳ ቢያ ዼኤፒ ሜቶ ማዤ ኪሊ''ንኮ ሉማ ዔቄኔ፤ ዓዶንሢያ ኑኡኮ ሙኡዚ'' ዴንቃኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያይቆኦቤ ጊብፄ ዓጮ''ይዳ ሓኣኮ ዓኣሢ ዋይዛዖ ኑ ዓዶንሢ ቤርታሲ ዒኢካ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ላሚፆ ማዒ ዔያታ ጊብፄ ዓኣዼ ዎዶ''ና ዮሴፔ ፔኤኮ ጌርሲንሢም ፔና ፔጋሲ ኬኤዚ ዔርቴኔ፤ ዒማ''ና ማኣሮ ዓሳኣ ዒዛኮ ካኣቲና ዔርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ዬካፓ ዮሴፔ ፔኤኮ ዓዶ ያይቆኦቤና ዒጊኖ ቢያ ፔ ኮራ ዔኪ ሙኬኔ፤ ዬያታ ዎሊ ዑፃ ጉቤ ላንካይታሚ'' ዶንጎ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ዬያሮ ያይቆኦቤ ጊብፄ ዓጮ'' ዓኣዺ ናንጊ ዒዛንታ ኑ ዓዶንሢንታ ዒኢካ ሓይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ዔያቶኮ ሌዛ ሴኬሜ ዓጮ'' ዔኪ ዓኣዺንቲ፥ ዓብራሃሜ፦ ሴኬሜይዳ ዔሞሬ ናኣቶ''ይዳፓ ፔ ሚኢሼና ሻንቄ ዱኡፖ ካያ ዱኡቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«ፆኦሲ ዓብራሃሜም ጫኣቂ ዒንጌ ሃጊ ማዓንዳ ዎዛ'' ኩማንዳ ዎዳ'' ዑካዛ ጊብፄይዳ ዓኣ ኑ ዴሮ''ኮ ፓይዳ'' ሚርጊ ሚርጊ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ዬካፓ ሜሌ'' ካኣቲ ዮሴፔ ዔሩዋያ ጊብፄይዳ ካኣታዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ዬይ ዓኮ ካኣታ''ሢ ኑ ዴሮ'' ዑፆይዳ ጌኔ ማሊሢና ዔቂ ዬያ ዓሶኮ ናኣታ'' ሃይቃንዳጉዲ ሓሣ ኬኤሪንታንዳጉዲ ኑኡኮ ዓዶንሢ ዎልቄና ዒዚ ኮሺ'' ሜታሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ዬኖ ዎዶ''ና ሙሴ ሾይንቴኔ፤ ዒዚያ ሚርጌ ሚዛጲ ናይኬ፤ ሓሣ ሓይሦ ዓጊኒያ ፔ ዓዶ ማኣራ ዴዒ ዲጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ዬካፓ ዒዚ ኬኤሪንቴንቴ ጊብፄ ካኣቲኮ ናይስኬና ዒዛ ዔኪ ፔ ናይ ማሂ ዲቼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ዬያይዴም ሙሴ ጊብፄ ዓሶ ዔራቶ ቢያ ዔሬኔ፤ ጌስታ ጌኤዞና ማዻ ማዾና ቢያ ዶዲ ዓሲ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«ሙሴኮ ሌዓ ዖይዲታሚ'' ኩሜ ዎዶ''ና ፔኤኮ ጌርሲንሢ ጌይፃ ዒስራዔኤሌ ናኣቶ'' ዛጋኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ዛጎሮ ዒ ሙካንቴ ዒዛኮ ዒጊኖይዳፓ ፔቴ''ስኬያ ፔቴ'' ጊብፄ ዓጪ ዓሲስኬይ ጳርቂ ሂዓንቴ ዴንቃዖ ዬያ ዒጊናሢ ዒ ማኣዴኔ፤ ዬያ ጳርቂንቴ ዓሢ ዛሎ''ዋ ኮሜ ዔካኒ ጊብፄ ዓጮ'' ዓሢ ጳርቂ ጶዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ዒዛ ዛሎ''ና ፆኦሲ ዔያቶ ዓይሉ''ማፓ ኬሳ''ንዳሢ ዒጊና ዒዛኮ ዔራንዳያ ዒዛም ማሌኔ፤ ጋዓንቴ ዔያታ ዬያ ዒና ዔኪ ዔሪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ዚሮ ጉቴ''ሎ ላምዖ ዒስራዔኤሌ ዓሲ ዎላ'' ዑራዻንቴ ዴንቃዖ ዔያቶ ላኣጋኒ ኮዒ ‹ዒንሢ ሃይ ዓሳ! ዒንሢ ዎሊኮ ጌርሲንሢኬ፤ ዓይጎሮ ዒንሢ ዎላ'' ዑራዻይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ዬይ ፔ ላጋሢ ጳርቃ ዓሣሢ ሙሴ ሴካ ሂዓዖ ‹ኔና ኑ ዑፃ ዎይሣያና ዎጋያ ማሄሢ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ዚጊኖ ኔ ጊብፄ ዓሢ ዎዼ ጎይፆ ታናኣ ኔ ዎዻኒ ኮዓ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሴ ዬያ ዋይዛዖ ጊብፄ ዓጫ''ፓ ፑኒንቲ ሚዲያሜ ጌይንታ ዓጪ ዓኣዺ ዒኢካ ናንጊ፥ ላምዖ ዓቲንቄ ናይያ ሾዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«ሙሴ ዒዞ ዓጮ''ይዳ ዖይዲታሚ'' ሌዔ ዓኣሤስካፓ ዴብሬሲና ጌይንታ ዹኮ'' ኮራ ዓኣ ቦኦሎ''ይዳ ካዮ ባኣካ'' ዔኤታ ታሚና ፆኦሲ ኪኢታንቻ ዒዛም ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙሴ ዬያ ዛጌ ዎዶ''ና ዲቃቲ ሄርሻዖ፥ ባንሢ ዑኪ ዛጋንቴ ሂዚ ጋዓ ዑኡሲ ዋይዚንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹ታኣኒ ኔ ዓዶንሢ ዓብራሃሜ ፆኦሲ፥ ዪሳኣቄ ፆኦሲ፥ ያይቆኦቤ ፆኦሲኬ› ጋዓዛ፥ ሙሴ ዒማ''ና ዒጊጪ ጎጋይቄኔ፤ ዛጋኒያ ጫርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ፆኦሲ ዒዛም ጋዓንቴ ‹ኔ ዔቄ ቤዛ ጌኤሺ ሳዓታሢሮ ቶካ''ፓ ዱርዞ ኔኤኮ ኬሴ''፤ ");
INSERT INTO mdybse_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ጊብፄ ዓጮ''ይዳ ዓኣ ታ ዴሮ''ኮ ዼኤፖ ሜቶ ጎኔና ታ ዛጌኔ፤ ዋዪንቶ ዒላቶዋ ታ ዔያቶኮ ዋይዜኔ፤ ዬያሮ ታ ዔያቶ ዓውሳኒ ኬዴ''ሢሮ ሓሢ ኔ ሓኒ ዬዔ፥ ታ ኔና ጊብፄ ዓጮ'' ማሂ ዳካንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«ዒስራዔኤሌ ዴራ'' ሙሴ ኮራ ‹ኔና ኑ ዑፃ ዎይሣያና ዎጋያና ማሄሢ ዖናዳይ?› ጌዒ ቤርታ ዒዛ ማኬያ ማዔቶዋ ፆኦሲ ጋዓንቴ ዬያ ሙሴም ካዮ ባኣካ'' ጴዺ ኪኢታንቻሢ ዛሎ''ና ዎይሣያና ዎጋያና ማሂ ዔያቶ ባንሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ጊብፄ ዓጮ''ና ዞቄ ባዞ''ናይዳ ዲቃሣ ባኣዚ''ና ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ''ና ማዺ ዴሮ'' ዓይሉማፓ ኬሲ''፥ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዖይዲታሚ'' ሌዔ ጉቤ ዔኪ ሓንቴሢ ዬያ ሙሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‹ፆኦሲ ታና ዔቂሴሢጉዲ ዒንሢኮ ዒሾንሢ ባኣካ''ፓ ፆኦሲ ማሊሢ ኬኤዛ ዓሲ ዒንሢም ዔቂሳንዳኔ› ጌዒ ዒስራዔኤሌ ዴሮ''ም ኬኤዜሢያ ዬያ ሙሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ዓሲ ናንጉዋ ዳውሎ''ይዳ ቡኪንቴ ዴሮ''ና ዎላ'' ሓሣ ሲና ዹኮ''ይዳ ጌስቴ ኪኢታንቻሢና ዬያጉዲ ኑ ዓዶንሢና ዎላ'' ማዔሢያ ዒዛኬ፤ ፆኦሲኮዋ ናንጎ ቃኣሎ'' ኑም ዳኪ ሄሊ''ሴሢያ ዬያ ሙሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«ኑ ዓዶንሢ ጋዓንቴ ዒዛ ማማኬያፓዓቴም ዒዛም ዓይሢንቲባኣሴ፤ ዒኖና ዔያታ ጊብፄ ዓጮ'' ማዓኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ዓኣሮኔ ኮራ ዔያታ ‹ሓይ ጊብፄ ዓጫ''ፓ ኑና ኬሴ'' ሙሴ ዎዎይቴቴያ ኑ ዔሩዋሴ፤ ዬያሮ ኑኡኮ ቤርታ ቤርታ ዓኣዺ ኑና ዔኪ ዓኣዻንዳያ ካኣሽኮንዶ ባኣዚ'' ኑም ማዤ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ዒማ''ና ዔያታ ናኣሪ ማላያ ካኣሽኮንዶ ባኣዚ'' ማዢ ዒንጎ ባኣዚ''ያ ዬያም ዒንጌኔ፤ ዔያታ ፔ ኩጮና ማዤ ባኮናኣ ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ፆኦሲ ጋዓንቴ ዔያቶይዳፓ ዱማዼኔ፤ ጫሪንጮ ዦኦጋሢ ዔያታ ካኣሽካንዳጉዲ ዔያቶ ማሄኔ። ዬይያ፦ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ‹ዒንሢ ዒስራዔኤሌ ዓሳ! ዓሲ ናንጉዋ ዳውሎ''ይዳ ዒንሢ ሹኬ ቆልሞንታ ዖይዲታሚ'' ሌዔ ጉቤ ዒንሢ ዒንጌ ዒንጊፃ ታኣምዳ? ");
INSERT INTO mdybse_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ዔኪ ዒንሢ ዴንዴሢ ዒንሢ ካኣሽካ ሞሎኬኮ ዓፒሎ ማኣሮንታ ሬፓኔ ጌይንታ ዒንሢ ፆኦዛሢኮ ዦኦጎ ማላ ባኮንታኬ። ዬያቶ ዒንሢ፦ ዒንሢ ኩቻ ማዢ ዬያቶም ዒንሢ ዚጋ ዒንሢኮ ካኣሽኮ ፆኦዞኬ። ታኣኒያ ባብሎኔ ዓጫ''ፓ ዒንሢ ዳኪንቲ ዴንዳንዳጉዲ ማሓንዳኔ› ጌይንቲ ፃኣፒንቴሢ ጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«ኑ ዓዶንሢኮ ዓሲ ናንጉዋ ዳውሎ''ይዳ ዓፒላና ማዢንቴ ፆኦሲ ካኣሽኪንታ ማኣሪ ዓኣኔ፤ ዬኖ ዓፒሎና ማዦና ማኣሮ ፆኦሲ ዒዛ ዓይሤ ጎይፆና ሓሣ ዻዌ ጎይፆና ማዤሢያ ሙሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","«ፆኦሲ ዔያቶኮ ቤርታፓ ዳውሴ ሜሌ'' ዴሮ'' ዓጮ'' ዔያታ ዻካሌ ዎዶ''ና ኑ ዓሶንሢ ዬኖ ዔያታ ዔኬ ዓፒሎና ማዢንቴ ማኣሬሎ ዒያሱና ዎላ'' ዒዞ ቤዞ ጌልዜኔ፤ ዴንዲ ዳውቴ ዎዶ'' ሄላ''ንዳኣና ዬና ዒኢካ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ዳውቴያ ፆኦሲ ዒዛ ቦንቼሢሮ ያይቆኦቤ ዜርፆ ባኣካ'' ፆኦዛሢ ዎርቃንዳ ማኣሪ ማዣኒ ፆኦሲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ጋዓንቴ ዬኖ ማኣሮ ፆኦሲም ማዤሢ ሴሎሞኔኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«ያዺ ማዔቶዋ ዼኤፖ ፆኦዛሢ ዓሲ ኩቺና ማዢንቴ ማኣሪዳ ናንጉዋሴ፤ ዬይያ፦ ፆኦሲ ማሊፆ ኬኤዛሢ ዛሎ''ና ");
INSERT INTO mdybse_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹ጫሪንጫ ታኣኮ ዴዖ ዖይቶኬ፤ ሳዓ ታኣኮ ቶካ ሄ'ርቃ ቤዞኬ፤ ሂዳዖ ታኣም ዒንሢ ዎዚጉዴ ማኣሪ ማዣንዳይ? ታ ዴዒ ሓውሻንዳ ቤዛ ዎዚጉዴያዳይ? ");
INSERT INTO mdybse_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ዬያ ቢያ ታኣኒ ታ ኩጮና ኮሼ''ሢቱዓዳ?› ፆኦሲ ሂዚ ጋዓኔ ጌዒ ፃኣፔሢጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«ዒንሢ ባቃኖ ዴይሤ፥ ፑርቶ ዓሳ! ዒና'' ዒንሢኮ ዔኩዋያ፤ ዋያኣ ዒንሢኮ ዋይዙዋያ፥ ዒንሢኮ ዓዶንሢጉዲ ዒንሢያ ቢያ ዎዴና ዓያኖ ጌኤዦ ማካኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ዒንሢኮ ዓዶንሢ ዒፂ ዳውሲ ባኣያ ፆኦሲ ማሊፆ ኬኤዛ ዓሶይዳፓ ዖናዳይ? ዔያታ ጌኤዣሢኮ ሙኪፆ ቤርታዺ ኬኤዜዞንሢታዖ ዎዼኔ፤ ዒንሢያ ሃሢ ዬያ ጌኤዣሢ ዓኣሢ ዒንጊ ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ዒንሢ፦ ኪኢታንቾ ዛሎ''ና ፆኦሲ ዎጎ ዔኬኔ፤ ጋዓንቴ ዒንሢ ዬያ ካፒባኣሴ።» ");
INSERT INTO mdybse_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ዎጎ ዎጋ ዓሳ ዬያ ዋይዜ ዎዶ''ና ዒናፓ ኮሺ'' ዻጋዼኔ፤ ዒስፂፓኖሴ ዑፆይዳኣ ዻጋና ሓኣሚ ዻዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ዒዚ ጋዓንቴ ዓያና ጌኤሺኮ ዎልቆ ጋሮ ጌሊ ጫሪንጮ ባንሢ ጊዥ ጌዒ ዛጋዖ፥ ፆኦሲኮ ቦንቾ ዴንቄኔ፤ ዬሱሴያ ፆኦሲኮ ሚዛቆ ዛላ'' ዔቂ ዓኣንቴ ዛጊ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«ሓይሾ፤ ጫሪንጫ ቡሊ''ንቲ፥ ፆኦሲኮዋ ናዓሢ ፆኦሲኮ ሚዛቆ ዛላ'' ዔቂ ዓኣንቴ ታ ዛጋኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ዬማና ዔያታ ዼ'ጊዲ ዒላቲ፥ ዋዮ ጉቤሢ ፔኤኮ ዓርቃዖ ፔቱሞና ዒዛ ባንሢ ጳሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ዬካፓ ዔያታ ዒዛ ዓርቂ ካታሞይዳፓ ኬሲ'' ሹቻ ዹዒ ዎዼኔ፤ ማርኮ ማዔ ዓሶንሢያ ዒስፂፓኖሴ ዹዓ ዓሶኮ ዓፒሎ ዔኪ ሳውሌ ጌይንታ ፔቴ'' ዼጌስኬይ ካፓንዳጉዲ ዒዛ ኮራ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ዔያታ ዒዛ ሹጮና ዹዓ ጎይሣ ዓኣንቴ ዒስፂፓኖሴ፦ «ጎዳ ዬሱሴ! ሼምፓሢ ታኣኮ ዔኬ!» ጌዒ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ሓሣ ዒ ጉምዓታዖ፦ «ጎዳሢዮ! ሓያ ዔያቶኮ ማዾ'' ዻቢንቲ ማሂ ፓይዲፖ!» ጌዒ ዼ'ጊዲ ዒላቲ፥ ሓይቄኔ። ሳውሌያ ዒስፂፓኖሴ ዎዾናሢ ቃራኬ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ዒስፂፓኖሴ ሓይቄ ኬሎ''ና ዬሩሳላሜይዳ ዓኣ ሺኢጲፆ ማኣሮ ዓሶይዳ ዼኤፒ ዳውሲሢ ዔቄኔ፤ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢፓ ዓታዛ ሓንጎ ፆኦሲ ጉሙርቃ ዓሳ ቢያ ዪሁዳ ዓጮ''ና ሳማሪያ ዓጮ''ና ባንሢ ላኣሊንቲ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ፆኦሲ ዶዲ ካኣሽካ፥ ፔቴ'' ፔቴ'' ዓሳ ዒስፂፓኖሴ ዱኡኬኔ፤ ሓሣ ዒናፓ ማዔ ዼኤፒ ዬኤፒያ ዬኤኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ሳውሌ ጋዓንቴ ዬኖ ዎዶ''ና ሺኢጲፆ ማኣሮ ዓሶ ባይዛኒ ሚርጌ ካራ ኮዓኔ፤ ዓሶኮዋ ማኣሮ ቢያ ጌሊ ጌሊ ኪሪስቶሴ ጉሙርቃ ዓሶ ዓቲንቆና ላኣሎና ጎቺ ጎቺ ኬሲ''፥ ቱኡሲ ማኣሪዳ ቱኪ''ሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ዱማ ዱማ ቤዞ ላኣሊንቲ ዓኣዼ ኪሪስቶሴ ጉሙርቃ ዓሳ ቢያ ቤዞይዳ ፆኦሲኮ ቃኣሎ'' ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፒልጶሴያ ሳማሪያኮ ፑኡፖ ካታሞ ዴንዲ ሜሲሔ ዛሎ'' ዓሶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ዓሳ ፒልጶሴኮ ቃኣሎ'' ዋይዛዖ ሓሣ ዒ ማዻ ፆኦሲ ዎልቆና ማዺንታ ዓኮ ባኮዋ ዛጋዖ ፔቱሞና ዒዚ ጋዓ ባኮ ኮሺ'' ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ፑርቶ ዓያናኣ ዼ'ጊዲ ዒላቲ ዒላቲ ሚርጌ ዓሶይዳፓ ኬስካኔ፤ ሃሣ ሚርጌ ሓንታኒ ዳንዳዑዋ ዎቦ ዓሲና ፒዜ ሃንቱዋ ዎቦ ዓሲያ ዻቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ዬያሮ ዬኖ ካታሞይዳ ዼኤፒ ዎዛ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ዬኖ ካታሜሎይዳ ሲሞኦኔ ጌይንታ ፔቴ'' ዓሲ ዓኣኔ፤ ዬይ ዓሢ ካታሞይዳ ዦዋቶና ዓኪ ባኣዚ'' ማዺ ማዺ ሳማሪያ ዓጮ''ይዳ ሄርሺ ዲቃቲንታያ ማዒ ናንጋኔ፤ ሓሣ «ታኣኒ ዼኤፒ ዓሲኬ!» ጌዒ ጌዒ ፔና ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ዓሶ ዻኮ''ንታ ዼኤፖንታ ቢያ፦ «ሓይ ዓሢ ዼኤፒ ጌይንቲ ዔኤሊ''ንታ ፆኦሲ ዎልቃሢኬ!» ጌዒ ጌዒ ዒዛሲ ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ዔያታ ዒዛሲ ዋይዛሢ ሚርጌ ዎዴይዳፓ ዓርቃዖ ዦዋቶና ዓኪ ባኣዚ'' ማዺሢና ዔያቶ ዲቃሢ ሄርሺሳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ጋዓንቴ ፒልጶሴ ፆኦሲ ካኣቱሞ ዛሎ''ና ዬሱስ ኪሪስቶሴ ዛሎ''ና ኬኤዜ ኮዦ ሓይሶ ጎናሲ ዔኪ ዓቲንቆንታ ላኣሎንታ ዋኣፆና ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ሲሞኦኔያ ዓቱዋዖ ኪሪስቶሴ ጉሙርቂ ዋኣፆና ማስቲ ፒልጶሴና ዎላ'' ፔቴ'' ማዔኔ፤ ሓሣ ዒዚ ፆኦሲ ዎልቆና ማዺንታ ዓኮ ባኮንታ ማላቶንታ ዛጊ ዛጊ ዲቃቲ ሄርሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ዬሩሳላሜይዳ ዓኣ ዳኪንቴዞንሢ ሳማሪያ ዓጮ'' ዓሳ ፆኦሲ ቃኣሎ'' ጎናሲ ዔኬሢ ዋይዛዖ ጴፂሮሴና ዮሓኒሴና ሳማሪያ ዓጮ'' ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ዬያሮ ሳማሪያ ዓጮ'' ዓሳ ዓያና ጌኤሺ ዔካንዳጉዲ ጴፂሮሴና ዮሓኒሴና ዓኣዺ ዔያቶም ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ዓይጎሮ ጌዔቶ ሳማሪያ ዓጮ'' ዓሳ ጎዳ ዬሱሴ ሱ'ንፆና ዋኣፆ ማስቴያፓዓቴም ዓያና ጌኤሺ ሓጊ ፔቴ''' ዓሲዳታዖ ኬዲ''ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ዬያሮ ጴፂሮሴና ዮሓኒሴና ዔያቶ ዑፃ ኩጮ ጌሣዛ ዓሳ ዓያና ጌኤሺ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ዳኪንቴዞንሢ ፔኤኮ ኩጮ ዓሶ ዑፃ ጌሣዛ ዓያና ጌኤሺ ዓሶም ዒንጊንቴሢ ሲሞኦኔ ዛጋዖ ዳኪንቴዞንሢም ሚኢሼ ዔኪ ሙኪ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«ታኣኒያ ኩጮ ጌሣዛ ዓሳ ቢያ ዓያና ጌኤሺ ዔካንዳጉዲ ሓኖ' ቢታንቶ ታኣም ዒንጉዋቴራ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ጴፂሮሴ ጋዓንቴ ዒዛም፦ «ፆኦሲኮ ዒንጊፆ ኔኤኒ ሚኢሼና ዔካኒ ማሌሢሮ ኔናንታ ኔ ሚኢሾንታ ዎላ'' ባይቁዋቴ! ");
INSERT INTO mdybse_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ዒና'' ኔኤኮ ፆኦሲ ቤርቶይዳ ፒዜ ማዒባኣሢሮ ኑ ማዾ''ይዳ ኔኤኮ ቤሲያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ዬያሮ ሓያ ኔኤኮ ፑርቱሞ ዻቢንቶ ጎማፓ ማዔ፤ ጎዖንቴ ፆኦሲ ኔኤኮ ዒኖ ማሊፆ ዓቶም ጋዓንዳቴ ዒዛ ሺኢቄ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ዓይጎሮ ጌዔቶ ኔኤኒ ባይዛ ቂኢሩሞ ማሊሢና ኩሜያ ሃሣ ጎሜና ቱኡቴ ዓሲ ማዔሢ ታ ዛጋኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ሲሞኦኔያ፦ «ዒንሢ ሓሢ ጌዔ ባኮይዳፓ ፔቴ'' ባኣዚ''ታዖ ታና ሄሉ''ዋጉዲ ዒንሢ ዒንሢሮ ጎዳሢ ታኣም ሺኢቁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጴፂሮሴና ዮሓኒሴና ዬሱሴ ዛሎ'' ዔራ ባኮ ማርካዺ፥ ጎዳኮዋ ቃኣሎ'' ኬኤዜስካፓ ሚርጌ ሳማሪያ ዓጮ'' ጉርዶይዳ ኮዦ ሓይሶ ኬኤዚ ኬኤዚ ዬሩሳላሜ ባንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ፆኦሲኮ ኪኢታንቻ ፒልጶሴ ኮራ፦ «ዔቂ ዬሩሳላሜይዳፓ ጋኣዛ ዴንዳ ጎይፆና ሊካ ዴንዴ» ጌዔኔ፤ ዬና ጎይፃ፦ ዓሲ ናንጉዋ ዳውሌ''ይዴና ዓኣዻያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ዒዚ ዔቂ ዴንዴኔ። ዒማ''ና ፔቴ'' ዒቶጲያ ዓጮ''ኮ ካኣቶ'' ማኣራ ዓሽቲንቂ ማዻ ዒቶጲያ ዓጪ ዓሲስኬያ ፆኦሲም ዚጊ ካኣሽካኒ ዬሩሳላሜ ዴንዲ ዒኢካ ዓኣኔ፤ ዬይ ዓሢ ሂንዴኬ ጌይንታ ዒቶጲያ ዓጮ'' ካኣቴሎና ዎላ'' ቢታንቶ ዓኣያ ማዒ ማዻያ ሓሣ ሚኢሾ ዒዞኮ ቢያ ዛጊ ዓርቂ ቆላያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ዬይ ዓሢ ፓራሢ ጎቻ ሳርጌሎ ዖይቶይዳ ዴዒ ፔ ዓጮ'' ባንሢ ማዒ ዴንዲቤቃ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ማፃኣፖ ናባባኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ዬማና ዓያኖ ጌኤዣ ፒልጶሴም፦ «ዴንዲ ሓሴኬ ሳርጌሎ ዖይቶ ባንሢ ዑኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ዬያሮ ፒልጶሴ ጳሽኪ ዬያ ባንሢ ዴንዳዖ ዒቶጲያ ዓጮ'' ዓሢ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ማፃኣፖ ናባባንቴ ዋይዚ፦ «ኔ ናባባሢኮ ቡሊ''ፃ ኔኤም ጌላ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ዒቶጲያ ዓጮ'' ዓሢ ማሓዖ፦ «ቡሊ'' ኬኤዛ ዓሲ ባኣንቴ ዎዲ'' ታኣም ጌላንዳይ?» ጋዓዖ፥ ፒልጶሴም፦ «ሳርጌሎ ዖይቶይዳ ኬስኪ ታኣና ዎላ'' ዴዔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ዬይ ዒቶጲያ ዓጮ'' ዼኤፖ ዓሢ ናባባ ማፃኣፓ፦ «ሹኪንታኒ ዒሺንታ ማራይጉዲ ማዔኔ፤ ዑፃፓ ጋፓኖ ታይዛ ዓሳ ታይዛኣና ዚቲ ጋዓ ማራይጉዲ ዒዚ ዻንጎ ፔኤሲ'' ቡሊ''ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ዒዚ ቦሂንቴኔ፤ ፒዜ ዎጌያ ዒዛም ዎጊንቲባኣሴ፤ ሼምፓሢ ዒዛኮ ሳዖይዳፓ ባይቄኔ፤ ዒዛኮ ሾይንቶ ዛሎ'' ዖኦኒ ኬኤዛኒ ዳንዳዓይ?» ሂዚ ጋዓ ቤዞኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ዬይ ካኣቶ'' ማኣራ ዼኤፒ ዓሲ ማዒ ማዻ ዓሢ ፒልጶሴ ኮራ፦ «ፆኦሲ ማሊፆ ኬኤዛሢ ሓኖ' ጌዔሢ ዖ ዛላዳይ? ፔ ዛላሞ? ሜሌ'' ዓሲ ዛላዳይ? ሓዳራ ታኣም ኬኤዜ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፒልጶሴያ ዬኖ ማፃኣፖ ቤዞይዳፓ ዓርቃዖ ዬሱሴ ዛሎ'' ኮዦ ሓይሶ ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ዔያታ ዴንዲቤቃ ዋኣሢ ዓኣ ቤሲ ሄላ''ዛ፥ ካኣቶ'' ማኣራ ማዻ ዼኤፖ ዓሢ ፒልጶሴ ኮራ፦ «ሓይሾ ሓካ ዋኣሢ ዓኣኔ፤ ታኣኒ ማስቱዋጉዲ ታና ላኣጋሢ ዓይጎዳይ?» ጌዔኔ።  ");
INSERT INTO mdybse_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፒልጶሴያ፦ «ጉቤ ዒናፓ ኔ ጉሙርቄቶ ዋኣፆ ማስታኒ ዳንዳዓኔ» ዒዛም ጌዔኔ። ካኣቶ'' ማኣራ ማዻ ዼኤፖ ዓሢያ፦ «ዬሱስ ኪሪስቶሴ ፆኦሲ ናኣዚ'' ማዔሢ ታ ጉሙርቃኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ካኣቶ'' ማኣራ ማዻ ዼኤፖ ዓሢ ሳርጌሎ ዖይቶ ዔቂሴኔ፤ ዬካፓ ላምዓሢ ዋኣፆይዳ ኬዳ''ዛ ፒልጶሴ ዬያ ዓሢ ማስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ዋኣፆይዳፓ ዔያታ ኬስኬስካፓ ፆኦሲኮ ዓያና'' ፒልጶሴ ዔኬኔ፤ ካኣቶ'' ማኣራ ማዻ ዼኤፖ ዓሢ ላሚ ዒዛ ዴንቂባኣሴ። ዒዚያ ዎዛዺ ዎዛዺ ፔኤኮ ጎይፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ፒልጶሴ ዒማ''ና ጋዓንቴ ዓዛፆሴ ጎዖ ቤሲዳ ጴዼኔ፤ ዒዚ ቂሳሪያ ዓጮ'' ማዒ ሙካንዳያ ሄላ''ንዳኣና ካታሞ ቢያ ሓንቲ ሓንቲ ኮዦ ሓይሶ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ዒማ''ና ቢያ ዎዴ ሳውሌ ጎዳኮ ጊንፆ ሓንታ ናኣቶ'' ዻጋና ዎዻኒ ዚርቂ ዚርቂ ናንጊቤቃ ቄኤሶኮ ሱኡጋሢ ኮራ ዓኣዺ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ጎዳኮ ጎይፆ ሃንታ ዓሶ ዓቲንቆንታ ላኣሎንታ ዴንቃዖ ቱኪ'' ቱኪ'' ዬሩሳላሜ ዔኪ ሙኪሳኒ ዳንዳዓ ኪኢታ ዋርቃታ ዴማስቆይዳ ዓኣ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ዎይሣ ዓሶም ፃኣፒ ዒንጋንዳጉዲ ቄኤሶኮ ሱኡጋሢ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ዬካፓ ዒዚ ጎይፆ ዴንዲ ዴማስቆ ካታሞ ሄላ''ኒ ዑካዛ ዒዚ ዔሩዋንቴ ጫሪንጫፓ ዓኣፒዳ ዱካ ፖዒ ዒዛ ዓጫ ፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ዬማና ዒዚ ቶጊ ዓኣዻ ባካፓ ሳዓ ኬዲ'' ሎኦማዖ፦ «ሳውሌ! ሳውሌ! ኔ ታና ዓይጋ ዳውሳይ?» ጋዓ ዑኡሲ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳውሌያ «ጎዳሢዮ! ኔኤኒ ዖናዳይ?» ጌዔኔ፤ ዒዚ ማሃዖ «ኔ ታና ዳውሳ፥ ታኣኒ ዬሱሴኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ሓሢ ዔቂጋፓ ካታሞ ጌሌ፤ ኔ ማዻንዳ ባካ ዒኢካ ኔኤም ኬኤዚንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ሳውሌና ዎላ'' ዓኣዻ ዓሶንሢ ዑኡሲ ዋይዛዖ ዖናኣ ዴንቃኒ ዳንዳዒባኣሢሮ ዔያታ ጎዖንዶ ጎይሢ ባይዚ ዚቲዮ ጌዒ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳውሌ ሳዓፓ ዔቃዖ ዓኣፖ ቡሌ'' ዎዶ''ና ዓይጎዋ ዴንቃኒ ዳንዳዒባኣሴ፤ ዬያሮ ዓሳ ዒዛኮ ኩጮ ዓርቂ ጎቺ ጎቺ ዴማስቆ ካታሞ ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ዒዚ ዒማ''ና ዓይጎዋ ዴንቃኒ ዳንዳዑዋዖ ሓሣ ሙዒ ዑሽኩዋዖ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ዴማስቆይዳ ፔቴ'' ሃናኒያ ጎዖ ኪሪስቶሴ ጉሙርቃ ዓሲ ዓኣኔ። ዬያ ዓሢ ጎዳ፦ «ሃናኒያ!» ጌዒ ዔኤላ''ያ ፆኦሲ ፔጋሲ ዻዋዛ፥ ዒዚ፦ «ዮ፥ ጎዳሢዮ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ጎዳ ዒዛም፦ «ፒዜ ጎይሢ ጌይንታ ጎይፄሎና ዴንዴ፤ ዒኢካ ዪሁዳ ማኣሮይዳ ሳውሌ ጌይንታ ፄርሴሴ ዓጮ'' ዓሢ ኮዔ፥ ዒዚ ሃሢ ሺኢጲሢዳኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ሳውሌያ ዒማ''ና ዓኣፓ ዒዛኮ ላሚ ዛጋንዳጉዲ ሓናኒያ ዒዛ ዑፃ ኩጮ ጌሣንቴ ፆኦሲ ዒዛ ፔጋሲ ዻዋያ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ሃናኒያ ጋዓንቴ ሂዚ ጌዒ ማሔኔ፦ «ጎዳሢዮ! ዬይ ዓሢ ዬሩሳላሜይዳ ዓኣ ኔ ዓሶ ዑፆይዳ ሚርጌ ፑርታ ባኣዚ'' ማዼሢ ሚርጌ ዓሲዳፓ ታ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ሓካኣ ሓሣ ኔና ካኣሽካ ዓሶ ቢያ ቱኡሳኒ ቄኤሶኮ ሱኡጎይዳፓ ቢታንቶ ዔኪ ሙኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ጎዳ ሃናኒያም፦ «ዒዚ ታኣኮ ሱ'ንፆ ሜሌ'' ዴሮ''ንታ ካኣቶ''ንታም ሓሣ ዒስራዔኤሌ ዓሶማኣ ዔርዛንዳያ ታኣኮ ዶኦሪንቴ ዓንጋሞ ማዔሢሮ ሓሢ ዒዛ ኮራ ዓኣዼ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ታ ዛሎ''ና ዎዚጉዴ ሚርጌ ሜቶ ዒ ዔካንዳቴያ ታ ታኣሮ ዒዛም ዔርዛንዳኔ» ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ዬያሮ ሃናኒያ ዒኢካ ዴንዲ ሳውሌ ዓኣ ማኣሮ ጌሊ፥ ኩጮ ፔኤኮ ሳውሌ ዑፃ ጌሣዖ፦ «ታ ዒሻሢዮ ሳውሌ! ሓይካ ኔ ሙካንቴ ጎይፃ ኔኤም ጴዼ ጎዳ ዬሱሴ ዓኣፓ ኔኤኮ ዛጋንዳጉዲና ሃሣ ዓያና ጌኤሺ ኩሙሢ ዎልቄና ኔጊዳ ማዻንዳጉዲ ማሆም ታና ዳኬኔ» ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ቤዞማና ቁኡሪ ማላ ባኣዚ'' ዓኣፓፓ ኬዳ''ዛ ሳውሌ ዛጋኒ ዳንዳዔኔ፤ ዬካፓ ዔቂ ዒ ዋኣፆ ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ሙኡዚ''ያ ሙዒ ዶዲ ዴማስቆይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶንሢና ዎላ'' ዻካ'' ኬሊ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ዬካፓ ኔጉዋዖ ሳውሌ፦ «ዬሱሴ ፆኦሲ ናይኬ» ጌዒ ጌዒ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ዬያ ዋይዜ ዓሳ ቢያ፦ «ሓይ ዓሢ ዬሩሳላሜይዳ ዬሱሴ ካኣሽካዞንሢ ቢያ ዎዻሢቱዓዳ? ሓይካኣ ዒዚ ሙኬሢ ዔያቶ ቱኪ'' ቱኪ'' ቄኤሶኮ ሱኡጎ ባንሢ ዔኪ ዓኣዻኒቱዓዳ?» ጌዒ ጌዒ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ሳውሌ ጋዓንቴ ፔቶ'' ዶዲ ዶዲ ዓኣዼኔ፤ ዬሱሴ ሜሲሔ ማዔሢያ ኬኤዚ ኬኤዚ ዴማስቆይዳ ናንጋ ዓይሁዶ ዓሶኮ ጎዖንዶ ጎይሢ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ሚርጌ ኬሊ''ኮ ጊንፃፓ ዓይሁዶ ዓሳ ሳውሌ ዎዻኒ ዞርቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ዒዚ ጋዓንቴ ዒዛ ዎዻኒ ዔያታ ዞርታሢ ዔሬኔ፤ ዔያታ ዒማ''ና ዒዛ ዎዻኒ ሮኦሮና ዋንቶና ቢያ ካሮ'' ካሮ'' ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ጋዓንቴ ዹሚና ሳውሌኮ ጊንፆ ሃንታ ናኣታ'' ዒዛ ሮኦጬና ዲሮ ዑሣ ዓኣሢ ካታሞ ዙላ'' ኬይሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳውሌ ዬሩሳላሜ ዓኣዻዖ ዒኢካ ዓኣ ኪሪስቶሴ ጉሙርቃዞንሢና ዎላ'' ማዓኒ ኮዔኔ፤ ዔያታ ጋዓንቴ ዒዛኮ ኪሪስቶሴ ጉሙርቂፃ ጎኔ ዔያቶም ማሊባኣሢሮ ቢያሢ ዒዛ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ባርናባሴ ጋዓንቴ ሳውሌ ዔያቶ ኮይላ'' ሺኢሻዖ ዒዚ ጎይፃ ዓኣንቴ ጎዳ ዒዛም ዎይቲ ጴዼቶ ሓሣ ዎማይዲ ዒዛና ጌስቴቶ፥ ዴማስቆይዳኣ ዬሱሴ ሱ'ንፆና ዎማይዲ ዒዚ ጫርቂ ዓሶ ዔርዜቶዋ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ዬያሮ ሳውሌ ዔያቶና ዎላ'' ማዒ ዬሩሳላሜይዳ ሓንቲ ሓንቲ ጎዳ ሱ'ንፆና ጫርቂ ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ጊሪኬ ዓጮ'' ሙኡጮ ጌስታ ዓይሁዶ ዓሶና ዎላ'' ጌስቲ ማርማዛ፥ ዔያታ ጋዓንቴ ዒዛ ዎዻኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ኪሪስቶሴ ጉሙርቃዞንሢያ ዬያ ዔራዖ ቂሳሪያ ዓጮ'' ዒዛ ዔኪ ዓኣዺ ዬካፓ ፄርሴሴ ዓጮ'' ዓኣዻንዳጉዲ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ዒማ''ና ዪሁዳ ዓጫ''፥ ጌሊላና ሳማሪያ ዓጮ''ናይዳ ቢያ ዓኣ ሺኢጲፆ ማኣሮ ዓሳ ሓውሾ ዴንቂ ዶዴኔ፤ ሓሣ ጎዳ ቦንቺ ቦንቺ ዓያና ጌኤሺናኣ ዶዲ ዶዲ ፓይዶና ሚርጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴፂሮሴ ዓጮ'' ሓንቲቤቃ፥ ሊዳይዳ ናንጋ ኪሪስቶሴ ጉሙርቃዞንሢ ኮራ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ዒኢካ ዒዚ ሳሊ'' ሌዔ ጉቤ ላሂ ናንጋ ዔኒያ ጌይንታ ዎቦ ዓሲ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴፂሮሴ ዬያ ዓሢ፦ «ዔኒያ! ዬሱስ ኪሪስቶሴ ኔና ፓሣንዳኔ፤ ዔቂ ኔኤኮ ዜዾ ማሄ» ጋዓዛ፥ ዒዚ ኔጉዋዖ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ሊዳና ሳሮናሜ ጌይንታ ዓጮ''ናይዳ ናንጋ ዓሳ ቢያ ዬያ ዛጋዖ ጎዳ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ዒማ''ና ዒዮጴ ዓጮ''ይዳ ፃቢታ ጌይንታ ፔቴ'' ኪሪስቶሴ ጉሙርቃስኬና ዓኣኔ፤ ዒዞ ሱ'ንፆኮ ቡሊ''ፃ ጊሪኬ ሙኡቺና «ዶርቃ» ጌይሢ ማዓዛ ዬና ጌይፃ «ጌንዖ» ጌይሢኬ፤ ዒዛ ኮሺ ባኣዚ'' ማዺሢና ሓሣ ጊንሣ ማንቆ ዓሶም ሚርጌና ዔኤቢ ዒንጊሢና ዔርቴ ላኣሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ዒማ''ና ዒዛ ሓይቄም፥ ዓሳ ዒዞ ሱኡዲ ማስካዖ ሹጮና ማዦና ማኣሮ ዑፃ ዓኣ ቤዞይዳ ኬሲ'' ላይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ሊዳ ጌይንታ ቤዜላ ዒዮጴኮ ዑኬ ማዔያታሢሮ ዒዮጴይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሳ ጴፂሮሴ ሊዳይዳ ዓኣሢ ዋይዚ፦ «ኔጉዋዖ ዑኬ ኑ ኮራ ሙኬ» ጌዒ ዒዛም ኪኢታ ላምዖ ዓሲ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ዬያሮ ጴፂሮሴ ዔኤሊ''ፆ ሙኬዞንሢና ዎላ'' ሙኬኔ፤ ዒኢካ ዒዚ ሄላ''ዛ ሹጮና ማዦና ማኣሮ ዑፃ ዓኣ ቤዞ ዔያታ ዒዛ ዔኪ ኬሴ''ኔ፤ ዬማና ዓኒንሢ ሃይቄ ላኣላ ቢያ ዒዛኮ ዓጫ ዔቃዖ ዬኤኪ ዬኤኪ ዶርቃ ዔያቶና ዎላ'' ሼምፔና ዓኣዖ ሲኬ ማኣዓሢንታ ዓፒሎዋ ዻዊ ዻዊ ቤኤዚንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጴፂሮሴ ጋዓንቴ ቢያሢ ካሮ'' ባንሢ ኬሲ''ጋፓ ጉምዓቲ ሺኢቃዖ ሌዞ ባንሢ ዛጊ፦ «ፃቢታ ዔቄ!» ጋዓዛ፥ ዒዛ ዓኣፖ ቡሌ''ኔ፤ ዒዛኣ ሓሣ ዒዛ ዴንቃዖ ዔቂ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ዒዚ ዒዞኮ ኩጮ ዓርቂ ዔቂሳዖ፥ ዓኒንሢ ሃይቄ ላኣሎንታ ኪሪስቶሴ ጉሙርቃ ዓሶንታ ዔኤሊ'' ዻቂሺ ዒዞ ዔያቶ ቤርታ ዔቂሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ዬይ ባካ ዒዮጴ ዓጮ''ይዳ ቢያ ዔርቴሢሮ ሚርጌ ዓሳ ጎዳ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጴፂሮሴ ዒማ''ና ሲሞኦኔ ጌይንታ ጎሮ'' ጉኡዓ ዓሲስኬያና ዎላ'' ሚርጌ ኬሊ'' ዒዮጴይዳ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቂሳሪያ ዓጮ''ይዳ ናንጋ ቆርኔሌዎሴ ጌይንታ ፔቴ'' ዓሲ ዓኣኔ፤ ዒዚያ «ዒፃሊያ ፖኦሊሶ» ጌይንታ ፖኦሊሶኮ ፄኤቶ ዓሶ ዓይሣ ሱኡጌኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ዒዚ ፔ ማኣሮ ዓሶና ዎላ'' ዓይሁዶ ዎጎ ጎይፆ ፆኦሲ ካኣሽካያና ዒጊጫያ፥ ማንቆ ዓሶዋ ሚርጌና ማኣዳ''ያ ሓሣ ፆኦሲ ቢያ ዎዴ ሺኢቃያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ፔቴ'' ኬሊ'' ማሢ ዶንቦልሳ ዎዴ ጉዴያ ማዓኣና ፆኦሲኮ ኪኢታንቻ ዒዛ ኮራ ጌሊ፦ «ቆርኔሌዎሴ!» ጌዒ ዒዛ ዔኤላ''ያ ፆኦሲ ዒዛም ፔጋሲ ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ዒዚ ጊዥ ጌዒ ኪኢታንቻሢ ባንሢ ዛጋዖ ዲቃቲሢና፦ «ጎዳሢዮ! ዓይጎዳይ?» ጋዓዛ፥ ኪኢታንቻሢ ዒዛም፦ «ኔኤኮ ሺኢጲፆና ማንቆ ዓሶ ኔ ማኣዳ'' ማኣዲፃ ፆኦሲ ቤርታ ጴዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ሓሢ ኔ ኮራፓ ዓሲ ዒዮጴ ዓጮ'' ዳኪጋፓ ጴፂሮሴ ጌይንታ ሲሞኦኔ ዔኤሊ''ሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ዒዚ ሃሢ ባዞ'' ዓጮይዳ ዓኣ፥ ጎሮ'' ጉኡዓ ሲሞኦኔ ማኣራ ሾኦቹሞይዳ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ዬያ ዒዛም ኬኤዜ ኪኢታንቻሢ ዒዛይዳፓ ዱማዺ ዓኣዻዛ ቆርኔሌዎሴ ዒዛም ላምዖ ማዾ ማዻስኬንሢና ጉሙርቂንቲ ማዻ ፔቴ'' ፆኦሲ ጉሙርቃ ፖኦሊሴስኬያ ዔኤሊ''፥ ");
INSERT INTO mdybse_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ማዔ ባኮ ቢያ ዔያቶም ኬኤዜሢኮ ጊንፃ ዒዮጴ ዓጮ'' ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ዚሬሎ ዔያታ ዓኣዺ ካታሞኮ ዑካኣና ዓባ'' ሳዛ ሄሌ''ም ጴፂሮሴ ዒዚ ቤርታ ሺኢቃ ሹጮና ማዦና ማኣሮኮ ዑፆ ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ዬማና ዒዛ ናይዼም ሙኡዚ'' ሙዓኒ ኮዔኔ፤ ሮኦሪ ሙዎ ሙዓ ዒዛም ጊኢጊንታ ጎይሣ ዓኣንቴ ፆኦሲ ዒዛም ፔጋሲ ዻዋ ባኣዚ'' ዒዚ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ዬና ዒ ዛጌ ባኬላ ያዺኬ፦ ጫሪንጫ ቡሊ''ንቴም ዖይዶ ዛላ'' ዓርቂንቴ ዓፒላ ማላ ባኣዚ'' ሳዖ ኬዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ዬኖ ጊዶይዳ ዱማ ዱማ ዻካ''ንታ ዼኤፒ ቦዖንታ ሓሣ ካፒያኣ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ዓካሪ ዒማ''ና፦ «ጴፂሮሴ! ዔቂ ሓያ ሹኪ ሹኪ ሙዔ» ጋዓ ዑኡሲ ዒዛም ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ጴፂሮሴ ጋዓንቴ፦ «ጎዳሢዮ፥ ዬይ ማዓዓኬ! ሙዒንቱዋ ቄፄ ማዔ፥ ዒኢቴ ባኣዚ'' ሙዒ ታ ቤቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ላሚ ሓሣ፦ «ፆኦሲ ጌኤሺ ማሄ ባኮ ኔኤኒ ዒኢቴያኬ ጋዓንዳያ ኮይሱዋሴ» ጋዓ ዑኡሲ ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ዬና ሓይሢ ማይንቲ ዒዛም ጴዼስካፓ ዓፒሎጉዴ ባኬላ ቤዞማና ሌካ ጫሪንጮ ዔውቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴፂሮሴ ዬኖ ፆኦሲ ዒዛ ዻዌ ባኮኮ ቡሊ''ፃ «ዓይጎ ናንዳይ?» ጌዒ ጌዒ ፔ ማሊፆና ማሊ ሜታዻንቴ፥ ቆርኔሌዎሴ ዳኬ ዓሶንሢ ሲሞኦኔኮ ማኣሮ ዖኦጪ ዖኦጪ ዲሮ ካራ'' ዔቃዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ዔኤሊ''ንቲ፦ «ጴፂሮሴ ጌይንታ ሲሞኦኔ ሾኦቹሞና ዓኣሢ ሓካዳ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴፂሮሴ ፆኦሲ ዒዛ ፔጋሲ ዻዌ ባኬሎ ዛሎ'' ማሊፆይዳ ዓኣንቴ ዓያና ጌኤሺ ዒዛም፦ «ሓይሾ፥ ኔና ሓይሦ ዓሲ ኮዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ዔያቶ ዳኬሢ ታናታሢሮ ዓልቱዋዖ ኬዲ''ጋፓ ዔያቶና ዎላ'' ዓኣዼ» ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴፂሮሴያ ዓኣ ቤዛፓ ኬዲ'' ዓሶንሢ ባንሢ ሙካዖ፦ «ዒንሢ ኮዓሢ ሓይሾ፥ ታናኬ፤ ዒንሢ ዓይጋ ሙኬይ?» ጌዒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ዔያታ፦ «ኑኡኒ ሙኬሢ ፄኤቶ ፖኦሊሶኮ ሱኡጋሢ፥ ቆርኔሌዎሴ ኮራፓኬ፤ ዒዚያ ዓይሁዶ ዓሳ ቢያ ዒዛ ቦንቻያ ሓሣ ፆኦሲ ካኣሽካያ ኮሺ ዓሲኬ። ኔና ዒዚ ፔ ማኣሪ ዔኤሊ''ሲ ኔ ጋዓ ባኮ ዋይዛንዳጉዲ ፆኦሲ ኪኢታንቻ ዒዛም ኬኤዜኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ዬካፓ ጴፂሮሴ ዔያቶ ማኣሪ ጌልዚ ሾኦቺንሢ ዎይሣዖ ጉቴ''ሎ ዔቂ ዬንሢ ሙኬዞንሢና ዎላ'' ዓኣዼኔ፤ ዒዮጴይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶይዳፓ ፔቴ'' ፔቴ'' ዓሲያ ዒዛና ዎላ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ዚሬሎ ዔያታ ቂሳሪያ ሙካንቴ ቆርኔሌዎሴ ፔኤኮ ዒጊኖና ዑኬ ላጌ ማዔ ዓሶዋ ዔኤሊ'' ጴፂሮሴ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴፂሮሴ ጌሊ ቆርኔሌዎሴና ካኣማዛ ቆርኔሌዎሴ ዒዛኮ ቶኮ'' ዴማ'' ሂርኪ ጌዒ ቦንቾ ዔኤሊ''ሢ ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ጴፂሮሴ ጋዓንቴ፦ «ዔቄ! ታኣ ኔጉዲ ዓሲዋይ!» ጌዒ ዒዛ ዔቂሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ጴፂሮሴ ቆርኔሌዎሴና ዎላ'' ጌስቲ ጌስቲ ጋሮ ጌላዖ ሚርጌ ቡኪንቲ ዓኣ ዓሲ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ዬካፓ ዬያ ዓሶም፦ «ዓይሁዴ ዓሳ ዓይሁዴ ማዒባኣ ዜርፆና ዎላ'' ፔቴ'' ማዒ ሓሣ ዎሊኮ ማኣሪ ጌላኒያ ኑ ካኣዦ ዎጋ ዓይሡዋኣሢ ዒንሢ ዒንሢ ቶኦኪና ዔራኔ፤ ጋዓንቴ ዖናኣ ታኣኒ ጌኤሽኪባኣ፥ ዒኢቴ ዓሲኬ ጎዑዋጉዲ ፆኦሲ ታና ፔጋሲ ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ዬያሮ ታኣም ዒንሢ ዓሶ ዳኬ ዎዶ''ና ፔቴ''ታዖ ዓልቱዋዖ ታ ሙኬኔ፤ ዓካሪ ዓይጎሮ ዒንሢ ታና ዔኤሌ''ቶዋ ታ ዔራኒ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ዒማ''ና ቆርኔሌዎሴ፦ «ሓኖ'' ዖይዳሳ ኬሊ'' ሃይማ ዎዴ፥ ማሢ ዶንቦልሳ ዎዴ ማዓኣና ታኣኒ ታ ማኣራ ፆኦሲ ሺኢቃንቴ ዓኣፒዳ ዱዱካ ቦኦሬ ዓፒላ ማኣዔ ዓሲ ታ ዔሩዋንቴ ታ ቤርታ ዔቃዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‹ቆርኔሌዎሴ! ፆኦሲ ኔኤኮ ሺኢጲፆ ዋይዜኔ፤ ሓሣ ማንቆ ዓሶም ኔ ዒንጋ ዒንጊፆዋ ኔኤኮ ዔኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ዓካሪ ዒዮጴ ዓጮ'' ኪኢታ ዓሲ ዳኪጋፓ ጴፂሮሴ ጌይንታ ሲሞኦኔ ዔኤሊ''ሴ፤ ሓሢ ዒዚ ባዞ'' ዓጫ ዓኣ ጎሮ'' ጉኡዓሢ፥ ሲሞኦኔ ማኣራ ሾኦቹሞይዳ ዓኣኔ› ታኣም ጌዔሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ቤዞና ኪኢቶ'' ዓሶንሢ ታ ኔ ኮራ ዳኬኔ፤ ኔኤኒያ ሓሢ ሙኬሢ ቃራኬ፤ ዓካሪ ፆኦሲ ኔና ኬኤዛንዳጉዲ ዓይሤ ባኮ ቢያ ዋይዛኒ ኑኡኒ ቢያሢ ፆኦሲ ቤርታ ሓይካ ቡኬኔ» ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ጴፂሮሴ ዔያቶም ኬኤዛዖ፦ «ጎኔና ፆኦሲ ዓሲ ዓሲዳፓ ዱማሱዋኣሢና ፔቴ''ያ ባሼ ማሂ ዛጉዋኣሢ ታ ዔሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ዓይጎ ዓጪ ዓሲ ማዔቶዋ ፆኦሲ ዒጊጫያ ሓሣ ጎኑሞ ባኣዚ'' ማዻያ ማዔ ዓሢ፥ ዬያ ፆኦሲ ናሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ፆኦሲ ዒስራዔኤሌ ዴሮ''ም ቃኣሎ'' ዳኬሢ ዔርቴያኬ፤ ኮዦ ሓይሳ ዬሱስ ኪሪስቶሴ ዛሎ''ና ሙኬሢያ ዔያቶምኬ፤ ጋዓንቴ ዬሱስ ኪሪስቶሴ ቢያሢኮ ጎዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዮሓኒሴ ዋኣፆና ማስኪፆ ኬኤዜ ዎዳ''ፓ ዓርቃዖ፥ ጌሊላ ዓጫ''ፓ ዴንዲ ዪሁዳ ዓጮ'' ቢያይዳ ማዔ ባኮ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ሓሣ ፆኦሲ፡ ናዚሬቶ ዬሱሴ ዓያኖ ጌኤዦና ዶኦሬሢንታ ዎልቄያ ዒዛም ዒንጌሢ ዒንሢ ዔራኔ፤ ፆኦሲ ዒዛና ዎላ'' ማዔሢሮ ዒዚ ኮሺ ባኣዚ'' ማዺ ማዺ ፑርቶ ዓያኖና ዓርቂንቴ ዓሶዋ ፓሢ ፓሢ ሓንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«ዪሁዳ ካታሞ ኮይሎ''ና ዬሩሳላሜ ካታሞናይዳ ዒዚ ማዼ ባኮኮ ቢያ ኑኡኒ ማርካኬ፤ ዔያታ ጋዓንቴ ዒዛ ሚሢዳ ሱፂ ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ፆኦሲ ዒዛ ሃይሣሳ ኬሎ''ና ሓይባ''ፓ ዔቃንዳጉዲና ዓሶማኣ ዒ ጴዻንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ዒዚ ጴዼሢ ቢያ ዓሲምቱዋንቴ ሓይባ''ፓ ዔቄሢኮ ጊንፃ ዒዛና ዎላ'' ሙዒ ዑሽኬ፥ ፆኦሲ ቤርታዺ ዶኦሬ፥ ኑና ዒዛኮ ማርኮንሢምኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ሓያ ባኮ ዴሮ''ም ኑ ኬኤዛንዳጉዲ፥ ሼምፖና ዓኣ ዓሶና ሓይቄ ዓሶናይዳ ዒ ዎጋንዳያ ማዒፆ ሓሣ ዬያ ፆኦሲ ማሊ ጌሤያ ማዔሢያ ኑ ማርካዻንዳጉዲ ኑና ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ዒዛና ጉሙርቃዞንሢም ቢያ ዒዛኮ ሱ'ንፆና ጎማ ዓቶም ጌይንታንዳሢ ፆኦሲ ማሊፆ ኬኤዛ ዓሳ ዒዛ ዛሎ'' ማርካዼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴፂሮሴ ዬያ ኬኤዛኣና ቃኣሎ'' ዋይዜ ዓሶ ቢያሢዳ ዓያና ጌኤሺ ኬዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጴፂሮሴና ዎላ'' ሙኬ፥ ኪሪስቶሴ ጉሙርቃ ዓይሁዶ ዓሳ፡ ዓይሁዴ ማዒባኣ ዜርፆም ዓያኖ ጌኤዦ ዒንጊፃ ላኣሊንቴሢ ዛጋዖ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ዓይሁዴ ማዒባኣ ዜርፆም ዓያኖ ጌኤዣ ዒንጊንቴያታሢ ዔያታ ዔሬሢ፥ ዓይሁዴ ማዒባኣ ዜርፃ ዱማ ዱማ ዻንጋና ጌስታንቴ ሓሣ ፆኦሲ ጋላቲ ጋላቲ ቦንቻንቴ ዔያታ ዋይዜሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ዬማና ጴፂሮሴ፦ «ሓኣታ ዓሳ ኑጉዲ ዓያና ጌኤሺ ዔኬኔ፤ ዓካሪ ዋኣፆና ዔያታ ማስቱዋጉዲ ዖኦኒ ዔያቶ ላኣጋይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ዬያሮ ዔያታ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ዋኣፆ ማስታንዳጉዲ ዓይሤኔ፤ ዬካፓ ጴፂሮሴ ዔያቶና ዎላ'' ዻካ'' ኬሊ'' ዴዓንዳጉዲ ዔያታ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ዓይሁዴ ማዒባኣ ዓሳ ፆኦሲ ቃኣሎ'' ዋይዚ ዔኬሢ ዪሁዳ ዓጮ''ይዳ ዓኣ ዳኪንቴዞንሢንታ ሓንጎ ኪሪስቶሴ ጉሙርቃ ዓሶንታ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጴፂሮሴ ዬሩሳላሜ ጊንሣ ማዒ ዓኣዼ ዎዶ''ና ዓቲንቶ ቤርቶ ቲቂንቲፃ ፒዜኬ ጋዓ፥ ዓይሁዴታዖ ኪሪስቶሴ ጉሙርቃ ዓሶ ዛላ''ፓ ማዔ ዓሳ ዒዛ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«ዓይጎሮ ኔ ዓቲንቶ ቤርቶ ቲቂንቲባኣ ዓሶ ማኣሪ ጌሊ ዔያቶና ዎላ'' ሙዔይ?» ጌዒ ፓሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ጴፂሮሴ ጋዓንቴ ሂዚ ጌዒ ቢያ ባኮ ፓይዲ ፓይዲ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«ታኣኒ ዒዮጴ ካታማ'' ሺኢጲሢዳ ዓኣዖ ፆኦሲ ታኣም ፔጋሲ ዻዌ ባኣዚ'' ዛጌኔ፤ ታ ዛጌሢ' ፑኡፒ ዓፒላ ማላ ባኣዚ'' ዖይዶ ዛሎ'' ዓርቂንቲ ጫሪንጫፓ ኬዲ'' ታ ባንሢ ሙካንቴኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ዬኖ ባኬሎ ኮሺ'' ታ ዛጋዛ ዱማ ዱማ ቆልሞ፥ ካይዚ ቦዖ ዻካ''ንታ ዼኤፒንታ፥ ካፒያ ጊዳ'' ዓኣንቴ ታ ዛጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ዒማ''ና ‹ጴፂሮሴ! ዔቂ ሹኪ ሹኪ ሙዔ› ጋዓ ዑኡሲ ታ ዋይዛዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ዬይ ‹ማዓዓኬ ጎዳሢዮ! ሙዒንቱዋ ዒኢቴ ባኣዚ'' ታ ሙዒ ቤቂባኣሴ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ሓሣ ላሚሢና ዬና ዑኡዜላ ‹ፆኦሲ ጌኤሺ ማሄሢ ኔ ዒኢቴያኬ ጋዓኒ ኮይሱዋሴ› ጌዒ ጫሪንጫፓ ታኣም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ዬና ሓይሢ ማይንቲ ያዺ ማዔስካፓ ዬና ዓፒሎ ማላ ባኬላ ጉቤ ሌካ ጫሪንጮ ዔውቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ዒማ''ና ቂሳሪያይዳፓ ታ ባንሢ ዳኮና ሓይሦ ዓሲ ኑ ዓኣ ማኣሮ ሙኪ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ዓያና ጌኤሺ ታኣኒ ፔቴ''ታዖ ዓልቲሢ ባኣያና ዔያቶና ዎላ'' ዓኣዻንዳጉዲ ታኣም ኬኤዜኔ፤ ሓንሢ ላሆ'' ኪሪስቶሴ ጉሙርቃ ዓሶንሢ ታኣና ዎላ'' ዓኣኔ፤ ዔያቶንታ ዎላ'' ኑ ቆርኔሌዎሴ ማኣሪ ዓኣዺ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ዒዚያ ፆኦሲ ኪኢታንቻ ዒዛም ጴዼም ዒ ዛጌሢና፦ ‹ዒዮጴ ዓጮ'' ዓሲ ዳኪ ጴፂሮሴ ጌይንታ ሲሞኦኔ ዔኤሊ''ሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ዒዚ ኔኤና ኔ ማኣሮ ዓሶና ቢያ ዒንሢ ዻቃንዳ ቃኣላ ኔኤም ኬኤዛንዳኔ› ጌዔሢ ዒ ኑም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ዬያሮ ታኣኒ ዔያቶም ኬኤዚፆ ዓርቄ ዎዶ''ና ዓያኖ ጌኤዣ ቤርታ ኑ ዑፃ ኬዴ''ሢጉዲ ዔያቶ ዑፃኣ ኬዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ዬማና ‹ዮሓኒሴ ዋኣሢና ማስኬኔ፤ ዒንሢ ጋዓንቴ ዓያና ጌኤሺና ማስታንዳኔ› ጌዒ ጎዳ ኬኤዜ ቃኣላ'' ታኣም ጶቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ኑኡኒ ጎዳ ዬሱስ ኪሪስቶሴ ጉሙርቄ ዎዶ''ና ፆኦሲ ኑም ዒንጌ ዒንጊፃ ዔያቶማኣ ዒንጊንቴያታቴ ሂዳዖ ፆኦሲ ታ ላኣጋኒ ዎልቄ ታኣኮ ዓኣ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ዔያታ ዬያ ዋይዛዖ ጎዖንዶ ጎይሢ ባይዚ ዚቲዮ ጌዔኔ፤ ዬካፓ ዔያታ፦ «ዓካሪ፥ ፆኦሲ ዓይሁዴ ማዒባኣ ዓሳ ዻቃንዳጉዲ ጎሞ ዔያቶም ዓቶም ጌዔኔ» ጌዒ ፆኦሲ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ዒስፂፓኖሴ ሹጮና ዹይንቲ ሃይቄ ዎዶ''ና ዔቄ ዒፂ ዳውሲፆ ዛሎ''ና ላኣሊንቲ ዴንዴ ኪሪስቶሴ ጉሙርቄ ዓሳ ዴንዲ ፒንቄ፥ ቆጲሮሴና ዓንፆኪያ ዓጮ'' ሄላ''ንዳኣና ዓኣዻዖ ፆኦሲኮ ቃኣሎ'' ዓይሁዴ ዓሲዳፓ ዓታዛ ሜሌ'' ዓሲም ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ማዔቶዋ ቆጲሮሴና ቄሬና ዓጮ''ናይዳፓ ሙኬ ፔቴ'' ፔቴ'' ኪሪስቶሴ ጉሙርቄ ዓሳ ዓንፆኪያ ዓኣዻዖ ዓይሁዴ ማዒባኣ ዓሶማኣ ዓይሱዋዖ ጎዳ ዬሱሴ ዛሎ'' ኮዦ ሓይሶ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ጎዳ ዔያቶ ማኣዴ''ሢሮ ሚርጌ ዓሲ ኪሪስቶሴ ጉሙርቂ ጎዳ ባንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ዬሩሳላሜይዳ ዓኣ ሺኢጲፆ ማኣሮ ዓሳ ዬያ ዋይዜሢሮ ባርናባሴ ዓንፆኪያ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ዒዚያ ዓኣዺ ፆኦሲ ኮሹሞና ዒንጋ ዒንጊፆ ዴሮ''ም ዎማይዲ ዒንጌቶዋ ዛጋዛ ሚርጌ ዒዛ ዎዛሴኔ፤ ቢያሢ ጉቤ ዒናፓ ዶዲ ጎዳም ጉሙርቂንታያ ማዒ ናንጋንዳጉዲ ዒ ዞሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ዒዚያ ዓያና ጌኤሺ ኩሙሢ ዎልቄና ዒዛይዳ ማዻያ ሃሣ ሚርጌና ፆኦሲ ጉሙርቃ ኮሺ ዓሲኬ። ሚርጌ ዓሲያ ጎዳ ባንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ዬካፓ ባርናባሴ ሳውሌ ኮዓኒ ፄርሴሴ ጎዖ ዓጮ'' ዓኣዺ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ዒዛ ዴንቃዖ ዓንፆኪያ ዔኪ ዒዛ ሙኬኔ። ፔቴ'' ሌዔ ኩሙሢ ዔያታ ዒኢካ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶና ዎላ'' ፔቴ'' ማዒ ሚርጌ ዓሲ ዔርዜኔ፤ ኪሪስቶሴ ጉሙርቄ ዓሳ ፔቴ'' ጌዒ ዓንፆኪያይዳ «ዓማኖ'' ዓሶ» ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ዒማ''ና ፔቴ'' ፔቴ'' ፆኦሲ ማሊፆ ኬኤዛዞንሢ ዬሩሳላሜይዳፓ ዓንፆኪያ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ዔያቶይዳፓ ፔቴ''ሢ ዓጋቦሴ ጎዖሢ ዔቂ ዓጮ'' ቢያይዳ ዼኤፒ ናይዚ ኬስካንዳሢ ዓያና ጌኤሺ ማሊሴም ኬኤዛዛ፥ ዬይ ናያ ሮሜ ዓጮ'' ካኣቲ ቄላውዴዎሴ ዎዶ''ና ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ዬያሮ ኪሪስቶሴ ጉሙርቃ ዓሳ ቢያ ፔቴ'' ፔቴ''ሢ ፔ ዳንዳዔሢጉዴያ ሚኢሼ ኬሲ'' ዪሁዳ ዓጮ''ይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶም ማኣዶ ዳካኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ዬካፓ ሚኢሾ ዔያታ ኬሲ'' ባርናባሴና ሳውሌና ዑፃ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ዒማ''ና ካኣቲ ሄሮዲሴ ፔቴ'' ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓማኖ'' ዓሶ ዳውሲሢ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ዮሓኒሴኮ ቶይዲ ያይቆኦቤ ጬንቻ ዓፓሮና ዒዚ ቲቂሲ ዎዺሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ዬይ ባካ ዓይሁዴ ዓሶ ዎዛሴሢ ዛጋዖ ጴፂሮሴያ ሓሣ ዓርቂሴኔ። ዬይ ማዔሢ ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ጌዒ ላኣዶ ሙዒ ቦንቾ ኬሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ጴፂሮሴ ዒዚ ዓርቂሴስካፓ ቱኡሲ ማኣሪዳ ቱኬ''ኔ፤ ዓይሁዶ ዓሶኮ ዑሣ ዓኣዺፆ ቦንቾ ኬሎ''ኮ ጊንፃፓ ዴሮ'' ቤርቶ ሺኢሻንዳያ ሄላ''ንዳኣና ዖይዶ ዖይዶ ማዒ ፔቴ''ና ዒዛ ዖይዶ ዓሲ ካፓንዳጉዲ ካፓ ዓሶ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ዬያሮ ጴፂሮሴ ቱኡዞ ማኣሮይዳ ቱኡቲ ካፓ ዓሶና ካፒንቴኔ፤ ሺኢጲፆ ማኣሮ ዓሳ ጋዓንቴ ዒዛ ጋይቴ ዶዲ ፆኦሲ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮዲሴ ዴሮ'' ቤርቶ ጴፂሮሴ ሺኢሻኒ ማሌ ዋንቴሎ ጴፂሮሴ ላምዖ ካኒ ቢራታና ቱኡቲ ላምዖ ካፓ ዓሲኮ ባኣካ'' ላሂ ዓኣኔ፤ ዓቴ'' ሜሌ'' ካፓዞንሢ ቱኡዞ ማኣሮኮ ካሮ'' ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ዬማና ፆኦሲኮ ኪኢታንቻ ሙኪ ጴዻዛ፥ ቱኡዞ ማኣሮይዳ ጴፂሮሴ ዓኣ ጋራ ፖዒ ፖዔኔ፤ ዬካፓ ፆኦሲኮ ኪኢታንቻሢ ጴፂሮሴኮ ቴቄሎ ባዒ ጴቻዖ፦ «ዑኬና ዔቄ!» ጋዓዛ፥ ካኖ ቢራታ ዒዛኮ ኩጫፓ ኬዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ጊንሣ ፆኦሲኮ ኪኢታንቻሢ፦ «ቃልሾ ኔኤኮ ቱኡቴ፤ ዱርዞዋ ኔኤኮ ዓኣሢንቴ» ጌዔኔ። ጴፂሮሴያ ዓይሢንቴሢጉዲ ማዼኔ፤ ሓሣ ጊንሣ ፆኦሲኮ ኪኢታንቻሢ፦ «ዓፒሎ ኔኤኮ ማይንቲ ታ ጊንፆ ሙኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ዬያሮ ጴፂሮሴ ኬስካዖ ፆኦሲኮ ኪኢታንቻሢ ጊንፆ ዓኣዻኣና ዒዛም ዓውቲ ማሌያፓዓቴም ዬይ ማዺንታ ባካ ቢያ ጎኔ ባኣዚ'' ማሊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ቤርታሳሢና ላምዓሳ ቤዞናይዳ ካፓ ዓሶና ዖኦኪ ካታሞ ዴንዳ ዓንጎና ዎዺንቴ ካሮ'' ሄላ''ዛ ዓሲ ካኣሙዋንቴ ካራ'' ጉሪ ዔያቶም ቡሊ''ንቴም ዔያታ ኬስኪ ፔቴ'' ሉኡጋ ጎይሢ ጊዴና ቲቂ ዓኣዻኣና ዒዚ ዔሩዋንቴ ፆኦሲኮ ኪኢታንቻሢ ጴፂሮሴይዳፓ ዱማዺ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ዬካፓ ጴፂሮሴኮ ዒና'' ማዓዛ፦ «ፆኦሲ ፔኤኮ ኪኢታንቻሢ ዳኪ ታና ሄሮዲሴና ዓይሁዴ ዓሳ ካፓ ባኮናይዳፓ ቢያ ዻቂሼያ ማዔሢ፥ ዓካሪ ታ ጎኔ ዔሬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ዬካፓ ዒዚ ሚርጌ ዓሳ ፔቱሞና ቡኪንቲ ሺኢቃ ማይራሞ ጎዖዞ ማኣሪ ዓኣዼኔ፤ ዬና ማይራማ ማርቆሴ ጌይንታ ዮሓኒሴኮ ዒንዶኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ጴፂሮሴ ዒኢካ ሄላ''ዖ ማርሾ ካሮ''ይዳ ዔቂ፦ «ማኣሪ ዓሲዮ!» ጋዓዛ፥ ሮዳ ጌይንታ ዉዱሮ ናይስኬና ዖናታቴያ ዔራኒ ማርሾ ካሮ'' ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ናዔላ ጴፂሮሴ ዑኡሲ ማዔሢ ዔራዖ ሚርጌ ዎዛፓ ዔቄያና ማርሾ ካሮ'' ቡሉ''ዋዖ ሓሺ'' ጳሽኪ ጋሮ ጌሊ፦ «ጴፂሮሴ ካራ'' ዔቂ ዓኣኔ!» ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ዔያታ ጋዓንቴ፦ «ኔ ዣዣኣሽካኔ!» ጋዓዛ፥ ዒዛ፦ «ጎኔ ዒዛኬ» ጌዒ ዶዲሺ ኬኤዛዛ፥ ዔያታ ጊንሣ፦ «ሂዴቶ፥ ዒዛኮ ዔኤዦ ናንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ጴፂሮሴ ዒማ''ና ዔኤሊ''ፆ ሓሾ'' ዒፃዛ፥ ዔያታ ካሮ'' ቡላ''ዖ ዒዛ ዛጊ ሚርጌ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ዒዚ ጋዓንቴ ዔያታ ዚቲዮ ጋዓንዳጉዲ ኩቻ ዻዋዖ፥ ፆኦሲ ዒዛ ቱኡዞ ማኣራፓ ዎይቲ ኬሴ''ቶዋ ዔያቶም ኬኤዜኔ። ዬካፓ፦ «ሓያ ባኮ ያይቆኦቤና ሃንጎ ኪሪስቶሴ ጉሙርቃዞንሢማኣ ኬኤዙዋቴ» ጌዒ ዔያቶይዳፓ ዱማዺ ሜሌ'' ቤሲ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ዚሮ ጉቴ''ሎ፦ «ጴፂሮሴ ዎካ ባይቄይ?» ጌዒ ካፓ ዓሳ ሴካ ሓንጋ ጳሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮዲሴ ዒዛ ኮዒሲ ባሺንታዖ ዬኖ ኬሎ''ና ካፓ ዓሶ ዖኦጬሢኮ ጊንፃ ዔያቶ ዎዻንዳጉዲ ዓይሤኔ፤ ዬካፓ ሄሮዲሴ ዪሁዳይዳፓ ቂሳሪያ ዴንዲ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮዲሴ ፂሮሴና ሲዶና ዓጮ'' ዓሶናይዳ ኮሺ'' ዻጋዼኔ፤ ዬያሮ ዔያታ ፔቱሞና ሙካዖ ካኣቲኮ ላጌ ማዔ፥ ቢላስፆሴ ጌይንታሢ ዔያቶም ካኣቲ ቃይሻንዳጉዲ ሺኢቂ ዔኤዒሴሢኮ ጊንፃ ካኣቲና ቡካኒ ዔያታ ዖኦጬኔ፤ ዬያ ዔያታ ማዼሢ ዔያቶኮ ዓጮ'' ዓሳ ሙዖንዶ ባኣዚ'' ዴንቃሢ ዬያ ካኣቲ ዓጫ''ፓ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ካኣቲ ጌኤዞ ዋይዛኒ ጌሤ ኬሎ''ና ካኣቱሞ ዓፒሎ ፔኤኮ ማኣዒ፥ ካኣቱሞ ዖይቶይዳ ዴዒ ዴሮ''ም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ዴራ''ኣ፦ «ሓይ ፆኦሲ ዑኡሲ ማዓንዳፓዓቴም ዓሲ ዑኡሲቱዋሴ» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ዒማ''ና ሄሮዲሴ ፆኦሲም ቦንቾ ዒንጊባኣሢሮ ቤዞማና ፆኦሲ ኪኢታንቻ ፑርታ ዶርዖ ዒዛይዳ ዓጋዛ ዒዚ ዛልቂ ሓይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ፆኦሲኮ ቃኣላ'' ጋዓንቴ ቢያ ዎዴ ሚርጌና ዳልጊ ዳልጊ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ባርናባሴና ሳውሌና ፔኤኮ ማዾ'' ኩንሢ ዬሩሳላሜይዳፓ ዓንፆኪያ ማዓዖ፥ ማርቆሴ ጌይንታ ዮሓኒሴያ ዔያቶና ዎላ'' ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ዓንፆኪያይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶ ባኣካ'' ፆኦሲ ማሊሢ ኬኤዛያና ኪሪስቶሴ ጉሙርቃ ዓሶ ዔርዛ ዓሲያ ዓኣኔ፤ ዬያታ «ባርናባሴ፥ ካርፃሢ ጌይንታ ሲሞኦኔ፥ ቄሬና ዓጮ'' ዓሢ ሉኪዮሴ፥ ዓጮ''ኮ ዖይዳሳ ቤዞ ዎይሣ ሄሮዲሴንታ ዎሊ ኮሺ'' ናሽካ ሚናሄና ሳውሌናኬ።» ");
INSERT INTO mdybse_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ዬንሢ ሙኡዚ'' ሓሺ'' ሺኢጲሢ ሺኢቃንቴ ሓሣ ፆኦሲ ካኣሽካንቴ ዓያና ጌኤሺ፦ «ታኣኒ ዶኦሬ ማዾ''ም ባርናባሴና ሳውሌና ታኣም ዱማሲ ኬሱ''ዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ዔያታ ላሚ ሓሣ ሙዖ ሓሺ'' ሺኢቆ ሺኢጲፆ ሺኢቂ፥ ኩጮ ዔያቶ ዑፃ ጌሤስካፓ ዔያቶ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ባርናባሴና ሳውሌና ዓያና ጌኤሺ ዔያቶ ዳኬም ሴሌውቂያ ጌይንታ ዓጮ'' ዓኣዺ፥ ዬካፓ ዋኣፆ ካኣሚሎና ዋኣፆ ሳዛ'' ዓኣ ቆጲሮሴ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ሲልማና ዔያታ ሄላ''ዖ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ፆኦሲ ቃኣላ ኬኤዜኔ፤ ዮሓኒሴ ጌይንታ ማርቆሴያ ዔያቶና ዎላ'' ማዒ ዔያቶ ማኣዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ቆጲሮሴኮ ጳፑ ጋዓ ቤዞ ዴንዲ ዔያታ ሄላ''ዖ፥ ባሪዬሱሴ ጌይንታ ፔቴ'' ዓይሁዴ ዓሲ ዦይስኬያ ዴንቄኔ፤ ዒዚያ ሉኡዙሞና ፆኦሲ ማሊሢ ኬኤዛኔ ጋዓ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ዒዚ ሴርጊዮስ ጳውሎሴ ጌይንታ ኮሺ'' ጫዋ ማዒ ዓጪ ዎይሣስኬያኮ ላጌኬ፤ ዬይ ዎይሣ ዓሢ ባርናባሴና ሳውሌና ዔኤሊ''ሲ ፆኦሲ ቃኣላ ዋይዛኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ጋዓንቴ ጊሪኬ ሙኡጮና «ዔሊማሴ» ጌይንታ ዦዋኣሢ፥ ባሪዬሱሴ ዬይ ዓጮ'' ዎይሣሢ ኪሪስቶሴ ጉሙርቁዋጉዲ ላኣጊ ባርናባሴና ሳውሌና ኬኤዛ ባኮ ዒፂ ማኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ሳውሌ ጌይንታ ጳውሎሴ ጋዓንቴ ዓያና ጌኤሺ ኩሙሢ ዎልቄና ዒዛይዳ ሙኬም ዬያ ዓሢ ኮሺ'' ዛጋዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«ሓይ ኔ ፃላሄ ናዓሢ፥ ጎኑሞ ቢያኮ ሞርኬ ማዔሢ፥ ጌሺሢና ፑርቱሞና ኔ ጊዳ'' ኩሜሢ ሓይ! ፒዜ ፆኦሲ ጎይፆ ዎቢሶ ኔ ሓሻ''ዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ሓሢ ሓይሾ ኔና ፆኦሲ ኩቺ ጳርቃንዳኔ፤ ዓኣፒ ባይቄያ ኔ ማዓንዳኔ፤ ፆኦሲ ጌዔ ዎዳ'' ሄላ''ንዳኣና ዓቦ''ኮ ፖዖ ኔ ዛጋዓኬ» ጋዓዛ፥ ቤዞማና ዓኣፓ ዒዛኮ ሻኣራቲ ዹሚ ባይቄም፥ ኩጮ ዒዛኮ ዓርቂ ዔኪ ዒዛ ዓኣዻንዳ ዓሲ ኮይላ'' ዒዛኮ ዒ ኮይሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ዓጮ'' ዎይሣሢ ማዔ ባኮ ቢያ ዛጋዖ ኪሪስቶሴ ጉሙርቄኔ፤ ጎዳ ዛሎ'' ዋይዜ ባኮሮዋ ቢያ ዲቃቲ ሄርሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ዬካፓ ጳውሎሴና ዒዛኮ ላጎንሢና ዋኣፆ ካኣሚሎና ጳፑይዳፓ ጲንፒሊያ ዓጫ'' ዓኣ ጴርጌ ዓኣዼኔ፤ ዮሓኒሴ ጌይንታ ማርቆሴ ጋዓንቴ ዔያቶይዳፓ ዱማዺ ጊንሣ ዬሩሳላሜ ማዒ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ዔያታ ጋዓንቴ ጴርጌይዳፓ ዔቂ ጲሲዲያ ዓጮ''ይዳ ዓኣ ዓንፆኪያ ዓኣዼኔ፤ ዓይሁዶኮ ሓውሾ ኬሎ''ና ዔያቶኮ ቡኪንቶ ቤዞ ጌሊ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ዒማ''ና ዎጎ ማፃኣፖና ፆኦሲ ማሊፆ ኬኤዛ ዓሶናኮ ማፃኣፓፓ ናባቢንቴሢኮ ጊንፃ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጋ፦ «ዒሾንሢዮቴ! ዴሮ'' ዶዲሻ ቃኣላ ዒንሢኮ ዓኣቶ ዴሮ''ም ኬኤዙዋቴ» ጌዒ ዓሲ ዔያቶም ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ዬያሮ ጳውሎሴ ዔቃዖ ዴሮ'' ባንሢ ኩቺና ዻዊ ዻዊ ሂዚ ጌዔኔ፦ «ዒስራዔኤሌ ዓሶንታ ሓሣ ዒንሢ ፆኦሲ ዒጊጫ፥ ዓይሁዴ ማዒባኣ ዴራ''! ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ሓያ ዒስራዔኤሌ ዴሮ''ኮ ፆኦዛሢ ኑኡኮ ቤርታዻ ዓዶንሢ ዶኦሪ፥ ጊብፄ ዓጮ''ይዳ ዔያታ ዓኣ ዎዶ''ና ዳልጊ ዴሬ ዔያቶ ማሂ ዒዛኮ ዼኤፖ ዎልቆና ዬኖ ዓጫ''ፓ ዔያቶ ኬሴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ዖይዲታሚ'' ሌዔ ማዓንዳያ ዓሲ ናንጉዋ ዳውሎ''ይዳ ጊቢ'' ዳንዳዒሢና ዔያቶ ዒ ማኣዴ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ዬካፓ ካኣናኔ ዓጮ''ይዳ ላንካይ ካኣቶ'' ባይዚ፥ ዬያቶኮ ዓጮ'' ዔያቶ ዻካልሴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ዬካፓ ሓሣ ዖይዶ ፄኤታና ዶንጊታሚ'' ሌዔ ማዓንዳያ ፆኦሲ ማሊፆ ኬኤዛ ሳሙዔኤሌ ዎዶ'' ሄላ''ንዳኣና ሱኡጌ ዔያቶ ዎይሣንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«ዬካፓ ሄሊ''ሲ ካኣቲ ዔያቶም ካኣታሳንዳጉዲ ፆኦሲ ዔያታ ሺኢቃዛ፥ ፆኦሲ ዔያቶም ቢኢኒያሜ ፃጳፓ ማዔ ቂሴ ናኣዚ'' ሳኣዖኦሌ ዖይዲታሚ'' ሌዔ ካኣታሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ፆኦሲ ሳኣዖኦሌ ካኣቱማፓ ኬይሴስካፓ ዳውቴ ዔያቶም ካኣታሴኔ፤ ፆኦሲ ዳውቴ ዛሎ'' ማርካዻዖ ‹ዒናፓ ታ ዒዛ ናሽካያ፥ ታኣኮ ማሊፆ ኩንሣ፥ ዒሴዬ ናኣዚ'' ዳውቴ ታ ዴንቄኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ዬያ ዓሢ ዜርፆይዳፓ ፆኦሲ ዒንጌ ሃጊ ማዓንዳ ዎዞጉዴያ ዒስራዔኤሌ ዓሶ ዻቂሻ፥ ዬሱሴ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ዬሱሴ ማዾ'' ዓርቃንዳሢኮ ቤርታ ዒስራዔኤሌ ዓሳ ጎሞ ፔኤኮ ቡኡፂ ዋኣሢና ማስታንዳጉዲ ዮሓኒሴ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ዮሓኒሴ ፔ ማዾ'' ኩርሳኒ ዑኪ ዓኣዖ፦ ‹ታና ዒንሢ ዖናኬ ጋዓይ? ታኣኒ ሜሲሔቱዋሴ፤ ጋዓንቴ ዒዛኮ ዱርዞ ቱኮ'' ሱዞ ቡላ''ኒ ታኣም ኮይሱዋያ፥ ታኣኮ ጊንፆ ሜሌ'' ሙካንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«ዒንሢ ዓብራሃሜ ዜርፃፓ ሾይንቴ ዒሾንሢንታ ፆኦሲ ዒጊጫዞንሢ ቢያ! ሓይ ዻቂንቶ ቃኣላ'' ዳኪንቴሢ ኑምኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ጋዓንቴ ዬሩሳላሜይዳ ናንጋ ዓሶና ዔያቶኮ ሱኡጎና ዬሱሴ ዓሲ ዻቂሻያ ማዔሢ ዔሪባኣሴ፤ ሃሣ ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ''ና ቢያ ናባቢንታ፥ ፆኦሲ ማሊፆ ኬኤዛ ዓሶኮ ማፃኣፖ ቃኣላ''ኣ ዔያቶም ጌሊባኣሴ፤ ያዺ ማዔቴያ ፆኦሲ ማሊፆ ኬኤዛ ዓሳ ጌዔ ጎይፆ ዒዛ ዑፃ ፑርታ ዎጌ ዔያታ ዎጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ሓይቢም ዒዛ ሄሊ''ሳ ዻቢንቲ ዔያታ ዒዛይዳ ዴንቂባኣዖ ዔያቶም ዒዛ ዎዻንዳጉዲ ጲላፆሴ ዔያታ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ዒዛ ዛሎ'' ፃኣፒንቴ ባኮ ቢያ ዔያታ ኩንሤሢኮ ጊንፃ ፑርቲሴ ዓሶ ሱፆ ሚፃፓ ኬይሲ ዒዛ ዔያታ ዱኡኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ጋዓንቴ ፆኦሲ ዒዛ ሓይባ''ፓ ዔቂሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ጌሊላይዳፓ ዬሩሳላሜ ዒዛና ዎላ'' ሙኬዞንሢማኣ ሚርጌ ኬሊ'' ዒዚ ጴዼኔ፤ ዬያታ ሓሢ ዴሮ''ኮ ቤርቶይዳ ዒዛኮ ማርኮንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ኑኡኒ ሓሢ ዒንሢም ዔኪ ሙኬሢ ፆኦሲ ኑ ዓዶንሢም ሃጊ ማዓንዳ ዎዛ ማሂ ዒንጌ ኮዦ ሓይሶኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ዎይቲ ጌዔቶ ፆኦሲ ዬሱሴ ሓይባ''ፓ ዔቂሲፆና ዬያ ዎዞ'' ኑና ዔያቶኮ ናኣቶ''ም ኩንሤኔ። ዬይያ፦ ዓይኑሞ ማፃኣፖ ዓይሢ ላምዖይዳ፥ ‹ኔ ታኣኮ ናዓሢኬ፤ ታ ኔኤኮ ሃኖ'' ዓዶ ማዔኔ!› ጌይንቲ ፃኣፒንቴሢ ጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ዒዚ ዎዑዋጉዲ ፆኦሲ ዒዛ ሓይባ''ፓ ዔቂሴሢ ዔርዛኒ፦ ‹ዳውቴም ዒንጊንቴ ሃጊ ማዓንዳ ዎዛሢ፥ ፆኦሲም ዱማዼያ ሃሣ ጉሙርቂንታያ ማዔሢ ታ ዒንሢም ዒንጋንዳኔ› ጌዒ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«ሓሣ ሜሌ'' ቤስካ ዓይኑሞ ማፃኣፖይዳ፦ ‹ኔኤም ጉሙርቂንቲ ማዻሢ ዱኡፓ ኔ ዎዒሲንዱዋሴ› ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«ጋዓንቴ ዳውቴ ፔኤኮ ናንጎ ዎዶ''ይዳ ማዾ'' ፆኦሲ ማሊፆጉዲ ኩንሤስካፓ ሓይቂ፥ ፔኤኮ ዓዶንሢና ዎላ'' ዱኡቲ ዎዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ፆኦሲ ሓይባ''ፓ ዔቂሴሢ ጋዓንቴ ዎዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ዓካሪ ዒሾንሢዮቴ! ዒንሢም ኬኤዚንቴሢ፥ ጎሞ ቢያ ዒንሢኮ ዓቶም ጋዓኒ ዳንዳዓሢ ዬሱሴኬ፤ ሙሴኮ ዓሶ ዎይሦ ዎጋ ጎሜ ዓይሉሞፓ ቢያ ዒንሢ ኬሳ''ኒ ዳንዳዑዋሴ ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ዬሱሴ ጉሙርቃ ዓሲ ቢያ ጎሜ ዓይሉሞፓ ኬስካኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ዬያሮ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ሂዚ ጌይንቴሢ ዒንሢዳ ሄሉ''ዋጉዲ ዒንሢና ዔሩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹ዒንሢ ሓይ ቦሃ ዓሳ! ዛጉዋቴ፥ ዲቃቲ ሄርሹዋቴ፥ ባይቁዋቴ! ዓይጎሮ ጌዔቶ ዖኦኒያ ዒንሢም ኬኤዜቶ ዒንሢ ጉሙርቃኑዋ፥ ማዾ ዒንሢ ዎዶ''ና ታ ማዻንዳኔ።› » ");
INSERT INTO mdybse_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ዬካፓ ጳውሎሴና ባርናባሴና ዓይሁዴ ዓሶኮ ቡኪንቶ ቤዛፓ ኬስካኣና ዬኖ ዔያታ ኬኤዜዜሎ ሙካ ዔያቶኮ ሓውሾ ኬሎ''ና ላሚ ዔያቶም ኬኤዛንዳጉዲ ዓሳ ጳውሎሴንሢ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ዓይሁዴ ዓሶኮ ቡኪንታ ላኣሊንታዛ ሚርጌ ዓይሁዴ ዓሲና ሜሌ'' ዓሲታዖ ዓይሁዶ ካኣዣ ጌሌ ዓሳ ጳውሎሴና ባርናባሴና ጊንፆ ዓኣዼኔ፤ ጳውሎሴንሢ ዓሶ ፆኦሲ ባኮ ዔርዚ ሓሣ ፆኦሲኮ ኮሹሞ ዒንጊፆና ዶዲ ዓሳ ናንጋንዳጉዲ ላቲ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ላምዓሳ ዓይሁዴ ዓሶኮ ሓውሾ ኬሎ''ና ካታማ'' ናንጋ ዓሶይዳፓ ዻካ'' ዓሲ ዓታዛ፥ ሓንጎ ዓሳ ቢያ ፆኦሲ ቃኣሎ'' ዋይዛኒ ሙኪ ቡኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ዓይሁዶ ዓሳ ዴሮ''ኮ ሚርጉሞ ዛጋዖ ዒናፓ ቂኢሪ፥ ጳውሎሴኮ ሓይሶዋ ማኪ ዒዛ ጫሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ጳውሎሴና ባርናባሴና ጋዓንቴ፦ «ቤርታዺ ፆኦሲ ቃኣላ'' ዒንሢም ኬኤዚንታኒ ኮይሳኔ፤ ዒንሢ ዔይዔ ጌዒ፥ ናንጊና ናንጊ ኑም ኮይሱዋሴ ጌዔቶ ዓካሪ ኑኡኒ ሓሺ'' ዓይሁዴ ማዒባኣ ዓሶ ባንሢ ዓኣዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ዓይጎሮ ጌዔቶ፦ ‹ዓጫ'' ጉቤ ኔ ዛሎ''ና ዻቃንዳጉዲ ሜሌ'' ዴሮ''ም ፖዒ ታ ኔና ማሄኔ› ጌዒ ጎዳ ዓይሤሢሮኬ» ጌዒ ጫርቂ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ዓይሁዴ ማዒባኣ ዓሳ ዬያ ዋይዛዖ ዎዛዼኔ፤ ፆኦሲ ቃኣሎ''ዋ ዔያታ ቦንቼኔ፤ ናንጊና ናንጎም ዶኦሪንቴዞንሢ ቢያ ዒማ''ና ኪሪስቶሴ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ጎዳኮዋ ቃኣላ'' ዬኖ ዓጮ'' ቢያ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ዓይሁዶኮ ሱኡጋ ጋዓንቴ ዓይሁዶ ካኣዦ ካኣሽካ ዖርጎጮ ላኣሎና ካታሞኮ ፑኡፖ ፑኡፖ ዓሶ ፔ ባንሢ ማሂ ጳውሎሴና ባርናባሴና ዒፂንቲ ዳውሲንታንዳጉዲ ማዺ ዓጫ''ፓ ዔያቶ ኬሴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ዒማ''ና ጳውሎሴና ባርናባሴና «ዒንሢና ባዴዔ» ጋዓ ማርካ ዔያቶም ማዓንዳጉዲ ቶኮ ሲላሎ ፒፂ'' ዒቆኒዮ ዓጮ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ኪሪስቶሴ ጉሙርቃ ዓሳ ኮሺ'' ዎዛዺ ሓሣ ዓያና ጌኤሺያ ኩሙሢ ዎልቄና ዔያቶይዳ ማዻያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ዓንፆኪያይዳ ዔያታ ማዼ ጎይፆ ሃሣ ዒቆኒዮ ዓጮ''ይዳ ጳውሎሴና ባርናባሴና ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ጌሊ፥ ዒኢካ ዼኤፒ ዎልቄና ዔያታ ፆኦሲ ባኮ ኬኤዜሢሮ ሚርጌ ዓይሁዴ ዓሲና ጊሪኬ ዓሲና ኪሪስቶሴ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ኪሪስቶሴ ጉሙርቂፆ ዒፄ ዓይሁዶ ዓሳ ዓይሁዴ ማዒባኣ ዓሶ ዴሚ''ና ዞሪ ኪሪስቶሴ ጉሙርቄ ዓሶ ዒፃንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ጳውሎሴና ባርናባሴና ጋዓንቴ ጎዳ ዛሎ'' ጫርቂ ኬኤዚ ኬኤዚ ዒኢካ ሚርጌ ዎዴ ዴዔኔ፤ ጎዳኣ ዔያቶም ዲቃሣ ባኣዚ''ና ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዻንዳ ቢታንቶ ዒንጊ ዒዛኮ ኮሹሞና ዒንጊንቴ ቃኣላ'' ጎኔ ማዔሢ ፔጋሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ካታሞይዳ ናንጋ ዓሳ ጋዓንቴ ላምዖ ቤሲ ፓቂንቲ ዛላ'' ዓይሁዶ ዓሶና፥ ዛላ'' ሓሣ ዳኪንቴዞንሢና ዎላ'' ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ዓይሁዴ ማዒባኣ ዓሶና ዓይሁዴ ዓሶና ሓሣ ዔያቶኮ ሱኡጎና ዎላ'' ማዒ ጳውሎሴና ባርናባሴና ዔያታ ሜታሳኒ፥ ጊንሣ ሹቻ ዹዒያ ዎዻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ጳውሎሴና ባርናባሴና ዬያ ዔራዖ ሊቃዖኒያይዳ ሊስፂራና ዴርቤና ጌይንታ ካታሞ ሓሣ ኮይሎይዳ ዓኣ ዓጮ'' ባንሢ ፑኒንቲ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ዒኢካ ኮዦ ሓይሶዋ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ሊስፂራይዳ ቶኪ ሲሌ፥ ፔቴ'' ዎቦ ዓሲስኬያ ዓኣኔ፤ ዬይ ዓሢ ሾይንቴማፓ ዓርቃዖ ዎቦ ማዔሢሮ ቶኪና ሃንቲ ቤቂባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ዬይ ዓሢ ጳውሎሴ ኬኤዛኣና ዴዒ ዋይዛንቴ፥ ጳውሎሴ ዓሢ ኮሺ'' ዛጋዖ ዓሢኮ ፔና ዻቂሻንዳ ጉሙርቂሢ ዓኣያ ማዔሢ ዴንቂ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ፔ ዑኡዞ ዼ'ጊዲ፦ «ሌካ ኔኤሮ ዔቄ!» ጌዔስካፓ ዓሢ ላዓ ጌዒ ዔቂ ሃንቲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ዓሳ ዬያ ጳውሎሴ ማዼ ባኮ ዛጋዖ ፔኤኮ ዑኡዞ ዼ'ጊዲ ሊቃዖኒያ ዓጮ'' ሙኡጮና፦ «ካኣሽኮ ፆኦዛ ዓሲ ማሎና ኑ ባንሢ ኬዴ''ኔ!» ጋዓዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ዔያታ ባርናባሴኮ ሱ'ንፆ «ዲያ» ጌዔኔ፤ ጳውሎሴ ዔያቶም ባሼ ኬኤዛሢታሢሮ ዒዛ ዔያታ «ሄርማኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ዬማና ካታሞኮ ዙላ'' ዓኣ ዲያ ጌይንታ፥ ዓይሁዶ ዓሶኮ ጌኤዦ ማኣሮ ቄኤሳሢ ዚያ ጌማይና ቡኒና ካታሞኮ ጌሎ ካሮ'' ባንሢ ዔኪ ሙኪ ዴሮ''ና ዎላ'' ማዒ ጳውሎሴና ባርናባሴናም ዒንጎ ባኣዚ ማሂ ሺኢሻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ጳውሎሴና ባርናባሴና ጋዓንቴ ዬያ ዋይዛዖ ዖዪ ዓፒሎ ፔኤኮ ዳርዚ፥ ዒላቲ ዒላቲ ዴሮ'' ባንሢ ጳሽኪ ሙኪ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«ዒንሢ ሃይ ዓሳ፥ ዓይጎሮ ሓያይዳይ? ኑኢኒያ ዒንሢጉዲ ዓሲኬ፤ ኑኡኒ ሓይካ ሙኬሢ ዒንሢ ሓያ ጉሪ ማዔ ካኣዦ ሓሺ''፥ ሳዖንታ ዼኤፖ ዋኣፆ ባዞ''ንታ ዬያቶኮ ጊዳ'' ዓኣ ባኮ ቢያ ማዤ ናንጊና ናንጋ ፆኦዛሢ ባንሢ ማዓንዳጉዲ ኮዦ ሓይሶ ኑ ዒንሢም ኬኤዛኒኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ሓያኮ ቤርታ ሚናኣ ዎዶ''ና ዴራ'' ፔ ሼኔ ጌዔ ጎይሢ ዓኣዻንዳጉዲ ፆኦሲ ዔያቶ ሓሼ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ያዺ ማዔቶዋ ፆኦሲ ኮሺ ማዾ ሃሹ''ዋዖ ማዺፆና ዒዚ ዓኣያ ማዒፆ ማርካሴኔ። ዬያ ዒ ማርካሴሢ፦ ጫሪንጫፓ ዒርዚ ዒንሢም ዋርቂሲፆና ሃኣካ ዒንሢም ካፃንዳጉዲ ቃራ ዎዴ ዒንጊፆና፤ ሃሣ ዒንሢ ሙኡዚ'' ዴንቂ ሚርጌና ዎዛዻንዳጉዲያ ማሂፆናኬ።» ");
INSERT INTO mdybse_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ዳኪንቴዞንሢ ያዺ ጌዒ ኬኤዜያ ማዔቶዋ ዴራ'' ዔያቶም ዒንጋ ዒንጊፆ ሺኢሹዋጉዲ ዔያታ ሓሺ''ሴሢ ሚርጌ ሜቶናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ዓይሁዶ ዓሳ ጋዓንቴ ዓንፆኪያና ዒቆኒዮ ዓጮ''ናይዳፓ ዒኢካ ሙኪ ዴሮ'' ፑርታ ማሊሲሢና ዔያቶ ባንሢ ማሄስካፓ፥ ጳውሎሴ ዔያታ ሹቻ ዹዒ «ዎዼኔ» ጌዒ ጎቺ ካታማ''ፓ ኬሴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ጋዓንቴ ኪሪስቶሴ ጉሙርቃ ዓሳ ሙኪ ዒዛኮ ዓጫ ዔቃዛ ጳውሎሴ ዔቂ ካታሞ ጊንሣ ማዒ ጌሌኔ፤ ዬካፓ ዚሮ ጉቴ''ሎ ባርናባሴና ዎላ'' ዴርቤ ዒዚ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ጳውሎሴና ባርናባሴና ዴርቤይዳ ኮዦ ሓይሶ ኬኤዚ ሚርጌ ዓሲ ኪሪስቶሴ ጉሙርቃንዳጉዲ ማሄኔ። ዬካፓ ሊስፂራና ዒቆኒዮ ጊዴና ጌዒ ዓንፆኪያ ዓጮ'' ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ዬያቶ ዓጮ'' ቢያሢዳ ኪሪስቶሴ ጉሙርቃ ዓሳ ጉሙርቂፆና ዶዳንዳጉዲ ዶዲሺ ዶዲሺ ሓሣ ዞሪ ዞሪ፦ «ፆኦሲ ካኣቱሞይዳ ጌላኒ ኑና ሚርጌ ሜቶ ዔካንዳያ ኮይሳኔ» ጌዒ ጌዒ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ሓሣ ሺኢጲፆ ማኣሮኮ ጪሚያ ዔያታ ዶኦሪ፥ ሙኡዚ'' ሓሺ'' ሺኢቆ ሺኢጲፆዋ ሺኢቄስካፓ ዔያታ ጉሙርቄ ጎዳሢም ሃዳርሲ ዔያቶ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ዬካፓ ጲሲዲያ ዓጮ'' ጊዴና ጌዒ ጲንፒሊያ ዓጮ'' ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ጴርጌይዳ ቃኣሎ'' ኬኤዜስካፓ ዓፃሊያ ዓጮ'' ኬዴ''ኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ዬካፓ ዔያታ ዋኣፆ ካኣሚሎ'' ቶጊ ሶኦሪያይዳ ዓኣ ዓንፆኪያ ጊንሣ ማዔኔ፤ ሶኦሪያ ጌይንታ ቤዜላ ዔያታ ማዼ ማዾ''ኮ ቤርታዺ ዓይሢፆ ሓዳራ ዔያቶም ዒንጊንቴ ካታሜሎኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ዒኢካ ዔያታ ሄላ''ዖ ኪሪስቶሴ ጉሙርቃ ዓሶ ፔቴ''ይዳ ቡኩሲ፥ ፆኦሲ ዔያቶና ዎላ'' ማዒ ማዼ ባኮ ቢያሢና ዓይሁዴ ማዒባኣ ዓሳ ኪሪስቶሴ ጉሙርቃንዳጉዲ ዎዲ'' ዔያቶም ካራ ቡሊ''ንቴቴያ ዓሶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ኪሪስቶሴ ጉሙርቃ ዓሶና ዎላ'' ሚርጌ ዎዴ ዔያታ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ፔቴ'' ፔቴ'' ዓሳ ዓንፆኪያ ዓጮ'' ዴንዲ፦ «ሙሴ ዎጎ ጎይፆ ዓቲንቶ ቤርቶ ዒንሢ ቲቂንቲባኣቶ ዻቃኒ ዳንዳዑዋሴ» ሂዚ ጌዒ ኪሪስቶሴ ጉሙርቃ ዓሶ ዔርዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ጳውሎሴና ባርናባሴና ጋዓንቴ ዬኖ ዛሎ'' ዓሶና ዎላ'' ኮሺ'' ማርሜኔ፤ ዬካፓ ጳውሎሴና ባርናባሴና ዓንፆኪያይዳ ዓኣ፥ ፔቴ'' ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሲና ዎላ'' ማዒ ዬሩሳላሜ ዓኣዺ ዬኖ ማሊፆ ዳኪንቴዞንሢና ጪሞናም ሺኢሻንዳጉዲ ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ዔያታ ሺኢጲፆ ማኣሮ ዓሳ ዔያቶ ዳኬም ዴንዲ ፒንቄና ሳማሪያ ዓጮ'' ጊዴና ዓኣዻዖ ዓይሁዴ ማዒባኣ ዓሶኮ ፆኦሲ ባንሢ ማዒፆ ዛሎ'' ኬኤዛዛ፥ ዬይ ሓይሳ ኪሪስቶሴ ጉሙርቃ ዓሶ ቢያ ዎዛሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ዬካፓ ዬሩሳላሜ ዔያታ ሄላ''ዛ ሺኢጲፆ ማኣሮ ዓሶና ዳኪንቴዞንሢና ሓሣ ጪማኣ ዔያቶ ሾኦቺንሢ ዔኬኔ፤ ሓሣ ፆኦሲ ዔያቶና ዎላ'' ማዒ ማዼ ባኮ ቢያ ዔያቶም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ጋዓንቴ ፔርሴ ፃጳፓ ማዔ ፔቴ'' ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሳ ዔቃዖ፦ «ዓይሁዴ ማዒባኣ ዓሳ ዓቲንቶ ቤርቶ ቲቂንታንዳጉዲና ሙሴ ዎጎ ካፓንዳጉዲ ዓይሣንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ዬያሮ ዳኪንቴዞንሢና ጪሞና ዬኖ ዛሎ'' ዎላ'' ዞርታኒ ቡኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ዔያታ ሚርጌና ማርሜሢኮ ጊንፃ ጴፂሮሴ ዔቃዖ፦ «ታ ዒሾንሦ! ታ ሚሾንሦ! ዓይሁዴ ማዒባኣ ዓሳ ታ ዛሎ''ና ኮዦ ሓይሶ ዋይዚ ኪሪስቶሴ ጉሙርቃንዳጉዲ ሓያኮ ቤርታ ፆኦሲ ታና ዒንሢ ባኣካ''ፓ ዶኦሬሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ዓሲኮ ዒና ዔራ ፆኦሲ፥ ኑም ዓያኖ ጌኤዦ ዒንጌሢጉዲ ዔያቶማኣ ዒንጊፆና ዔያቶ ፔ ዓሲ ማሄሢ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ዔያታ ዒዛ ጉሙርቄሢሮ ጎሞ ዔያቶኮ ዒ ጌኤሼኔ፤ ዬያሮ ኑኡና ዔያቶና ባኣካ'' ፔቴ''ታዖ ዱሙሞ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ዓካሪ ኑ ዓዶንሢታዖ ሓሣ ኑኡኒያ ኬዳኒ ዳንዳዒባኣ ቃምባሮ ኪሪስቶሴ ጉሙርቃ ዓሶ ባቃኖይዳ ጌሢ ‹ፆኦሲ ዎይታቴያ ኑ ዛጋንዳኔ› ዒንሢ ሓሢ ዓይጎሮ ጋዓይ? ");
INSERT INTO mdybse_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ኑኡኒያ ዻቄሢ ጎኔና ዔያቶጉዲ ጎዳ ዬሱሴኮ ኮሹሞ ዒንጊፆና ማዔሢ ኑ ጉሙርቃኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ዬማና ዴራ'' ባርናባሴና ጳውሎሴ ዛሎ''ና ፆኦሲ ዓይሁዴ ማዒባኣ ዓሶ ባኣካ'' ማዼ ዒዛ ዎልቆና ማዺንቴ ባኮንታ ዲቃሣ ባኮ ቢያ ዔያታ ኬኤዛኣና ዚቲ ጌይ ዔያቶሲ ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ዔያታ ኬኤዚ ኩርሴስካፓ ያይቆኦቤ፦ «ታ ዒሾንሦ! ታ ሚሾንሦ! ሂንዳ ዋይዙዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ፆኦሲ ዓይሁዴ ማዒባኣ ዓሶ ባኣካ''ፓ ፔኤም ማዓንዳ ዴሬ ዶኦሪፆና ዔያቶም ዎማይዲ ማሌቶዋ ሲሞኦኔ ቤርታዺ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ሓኖ' ማሊፆና ፆኦሲ ማሊፆ ኬኤዛ ዓሶኮ ቃኣሎ''ና ዎሊ ማላያኬ፤ ዬይያ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹ዬካፓ ታ ማዓንዳኔ፤ ዳውቴኮ ሻሂንቴ ማኣሮ ታ ማዣንዳኔ፤ ሻሂንቲ ላኣሊንቴ ባኮዋ ጊንሣ ታ ዶዲሺ ዔቂሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ዬያ ታ ማዻንዳሢ ሃንጎ ዓቲ'' ዓኣ ዓሶንታ ታ ዓሶ ማዔ፥ ሜሌ'' ዴራ ቢያ ታና ኮዓንዳጉዲኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ቤርታፓ ዓርቂ ዬያ ቢያ ፔጋሴ፥ ጎዳሢ ሂዚ ጋዓኔ› ጌይንቲ ፃኣፒንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«ዬያሮ ታኣኮ ማሊፃ ፆኦሲ ባንሢ ማዓ ዓይሁዴ ማዒባኣ ዓሶ ኑኡኒ ሜታሲባኣቴ ኮሺኬ ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ዬያይዳፓ ‹ሜሌ'' ካኣሺም ሹኪንቴ፥ ዒኢቴ ባኣዚ'' ሙዒፖቴ፤ ማቾ ሓሣ ዓኒ ማዒባኣ ዓሲና ላሂፖቴ፤ ሱጉሢ ሾኦቲ ባኣያ፥ ጩኡሊ''ንቲ ሓይቄ ቆልሞ ሙዒፖቴ፤ ሱጉሢያ ዑሽኪፖቴ› ጌዒ ኑ ዔያቶም ፃኣፓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ዓይጎሮ ጌዔቶ ሚናፓ ዓርቃዖ ሙሴ ዎጋ'' ዓይሁዶኮ ሓውሾ ኬሎ''ና ዔያቶኮ ቡኪንቶ ቤዛ ናባቢንታኔ፤ ሓሣ ቃኣላ'' ካታሞይዳ ቢያ ኬኤዚንታኔ» ሂዚ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ዬካፓ ዳኪንቴዞንሢንታ ጪሞንታ ሺኢጲፆ ማኣሮ ዓሶ ቢያሢንታ ዎላ'' ማዒ ቡኪንቴ ዓሶ ባኣካ''ፓ ዻካ'' ዓሲ ዶኦራዖ ጳውሎሴና ባርናባሴና ዎላ'' ዓንፆኪያ ዓጮ'' ዳካኒ ጌስቲ ዔቂሴኔ፤ ዬያሮ ኪሪስቶሴ ጉሙርቃ ዓሶ ባኣካ'' ዓሶ ዔኪ ዓኣዺሢና ኮሺ ሱ'ንሢ ዓኣ፥ ቤርሲያኔ ጌይንታ ዪሁዳና ሲላሴና ዔያታ ዶኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ዬካፓ ፃኣፒንቴ ኪኢቶ'' ዔያቶ ዑፃ ዳኬኔ፤ ኪኢታ፦ «ኑኡኒ ዳኪንቴዞንሢና ጪሞ ማዔ ዒንሢኮ ዒሾንሢ፥ ዓንፆኪያና ሶኦሪያናይዳ ሓሣ ኪልቂያይዳ ናንጋ ዓይሁዴ ማዒባኣ ኑ ዒሾንሢ፡ ዒንሢ ኮሺዳ ኑ ጋዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ኑ ባኣኮ''ይዳፓ ፔቴ'' ፔቴ'' ዓሲ ኑ ዔያቶ ዓይሢባኣንቴ ዒንሢ ኮራ ሙኪ ዒንሢም ኬኤዜ ቃኣሎ''ና ሜታሲ፤ ሓሣ ዒንሢም ጎይሢ ባይዜሢ ኑ ዋይዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ዬያሮ ፔቴ''ይዳ ቡኪንቲ ኪኢታ ዓሲ ኑ ዶኦሬስካፓ ናሽኪንታ ኑ ዒሾንሢ ባርናባሴና ጳውሎሴና ዎላ'' ዔያቶ ኑ ዒንሢ ባንሢ ዳካኒ ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ባርናባሴና ጳውሎሴና ኑ ጎዳሢ ዬሱስ ኪሪስቶሴ ዛሎ''ሮ ፔ ሼምፓሢ ሚርጌ ሜቶም ዓኣሢ ዒንጌያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ኑ ጌስቴ ሓይሶ ዻንጋና ቃሲ'' ዒንሢም ኬኤዛንዳጉዲ ዪሁዳና ሲላሴና ኑ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ሓንሢ ፓይዲንቴ፥ ኮይሳ ባኮንሢፓ ዓታዛ ሜሌ'' ዴኤሢ ቃምባራ ኑ ዒንሢ ዑፃ ጌሡዋጉዲ ዓያኖ ጌኤዦና ኑኡናናም ኮሺ ማዒ ጴዼኔ፤ ዬንሢያ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ሜሌ'' ካኣሺም ሹኪንቴ፥ ዒኢቴ ባኣዚ'' ሙዒፖቴ፤ ሱጉሢ ሾኦቱዋንቴ ጩኡሊ''ንቲ ሓይቄ ቆልሞ ሙዒፖቴ፤ ሱጉሢያ ዑሽኪፖቴ፤ ማቾ ሃሣ ዓኒ ማዒባኣ ዓሲና ላሂፖቴ፤ ዬንሢ ባኮፓ ዒንሢ ካፒንቴቶ ኮሺ ባኣዚ'' ዒንሢ ማዼኔ፤ ዓካሪ ኮሺ ናንጉዋቴ» ሂዚ ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ዬካፓ ኪኢቶ'' ዓሶንሢ ዔያቶ ሳራሣዖ ዓንፆኪያ ዓጮ'' ዴንዲ፥ ኪሪስቶሴ ጉሙርቃ ዓሶ ቢያ ቡኩሲጋፓ ፃኣፒንቴ ኪኢቶ'' ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ኪሪስቶሴ ጉሙርቃ ዓሳ ፃኣፒንቴ ኪኢቶ'' ናባባዖ ዳኪንቴ፥ ዶዲሻ ኪኢቶ''ና ኮሺ'' ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ዪሁዳና ሲላሴና ፆኦሲ ማሊሢ ኬኤዛያታሢሮ ዒሾንሢ ማዔ ዓሶ ሚርጌ ቃኣላና ዞሪ ዶዲሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ዪሁዳና ሲላሴና ዒኢካ ዻካ'' ዎዴ ዴዔስካፓ ኪሪስቶሴ ጉሙርቃዞንሢ ዔያታ ሳራሢ ዔያቶ ዳኬ ዓሶ ባንሢ ማዒ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ጳውሎሴና ባርናባሴና ኪሪስቶሴ ጉሙርቃ ሜሌ'' ሚርጌ ዓሲና ዎላ'' ማዒ ጎዳኮ ቃኣሎ'' ዔርዚ ዔርዚ ሓሣ ኬኤዚ ኬኤዚ ሚርጊባኣያ፥ ዻካ'' ዓጊኒ ዓንፆኪያይዳ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ሚርጊባኣያ፥ ዻካ'' ዓጊኒኮ ጊንፃፓ ጳውሎሴ ባርናባሴ ኮራ፦ «ሓኒ ሙኬ፤ ሓያኮ ቤርታ ጎዳኮ ቃኣሎ'' ኑ ኬኤዜ ካታሞ ቢያይዳ ዓኣ ዒሾንሢንታ ሚሾንሢታ ሓንቲ ሓንቲ ዔያታ ዎይቴቴያ ኑ ዛጎም» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ዒማ''ና ባርናባሴ ዮሓኒሴ ጌይንታ ማርቆሴ ዔያቶና ዎላ'' ዓኣዻንዳጉዲ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ጳውሎሴ ጋዓንቴ ዬይ ዓሢ ዔያቶና ዎላ'' ዓኣዻንዳጉዲ ኮዒባኣሴ፤ ዓይጎሮ ጌዔቶ ዒዚ ቤርታ ጲንፒሊያይዳ ዔያቶፓ ዱማዺ ዓቴ''ሢሮና ሓሣ ማዾ''ይዳ ዔያቶና ዎላ'' ዓኣዺባኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ዬኖይዳፓ ዔቄያና ዔያቶ ባኣካ'' ፑኡፒ ማርማ ዔቃዛ፥ ዔያታ ዎሊፓ ዱማዼም ባርናባሴ ማርቆሴ ዔካዖ ዋኣፆ ካኣሚሎና ቆጲሮሴ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ጳውሎሴ ጋዓንቴ ሲላሴ ዶኦሬኔ፤ ኪሪስቶሴ ጉሙርቃ ዓሳ ጎዳሢ ጳውሎሴንሢ ፔ ኮሹሞና ካፓንዳጉዲ ሺኢጲሢና ሓዳርሲ ዒንጌስካፓ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ዒማ''ና ዔያታ ሺኢጲፆ ማኣሮ ዓሶ ዶዲሺ ዶዲሺ ሶኦሪያና ኪልቂያ ጌይንታ ዓጮ'' ሃንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳውሎሴ ዴርቤና ሊስፂራና ጌይንታ ዓጮ'' ዴንዴኔ፤ ሊስፂራይዳ ፂሞቴዎሴ ጌይንታ ኪሪስቶሴ ጉሙርቃ ዓሲ ናንጋኔ፤ ዒንዳ ዒዛኮ ዓይሁዴ ፃጳፓታዖ ኪሪስቶሴ ጉሙርቄያኬ፤ ዓዴ ጋዓንቴ ዒዛኮ ዓይሁዴ ማዒባኣ ጊሪኬ ዓጪ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ሊስፂራና ዒቆኒዮኔናይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሳ ፂሞቴዎሴ ሚርጌ ኮሺ ዓሲ ማዔሢ ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳውሎሴ ፂሞቴዎሴ ዔኪ ዓኣዻኒ ኮዔሢሮ ዓቲንቶ ቤርቶ ቲቂንታንዳጉዲ ማሄኔ፤ ዬያ ዒ ማዼሢ' ዬኖ ቤዞይዳ ዓኣ ዓይሁዴ ዓሶ ዛሎ''ሮኬ፤ ዓይጎሮ ጌዔቶ ዔያታ ፂማቴዎሴኮ ዓዴ ጊሪኬ ዓሲ ማዔሢ ዔራያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ጳውሎሴና ሲላሴና ሚርጌ ካታሞ ቲቂ ዓኣዻኣና ዬሩሳላሜይዳ ዓኣ ዳኪንቴዞንሢና ጪሞና ማሊ ቱኬ'' ባኮ ኪሪስቶሴ ጉሙርቃ ዓሶም ኬኤዜኔ፤ ዔያታ ማዾይዳ ፔኤሻንዳጉዲያ ሓሣ ላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ዬያሮ ዱማ ዱማ ሺኢጲፆ ማኣሮ ዓሳ ኪሪስቶሴ ጉሙርቂፆና ዶዴኔ፤ ፓይዳኣ ዔያቶኮ ኬሎ''ይዳ ኬሎ''ይዳ ቃሲ''ንቲ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ጳውሎሴና ሲላሴና ዒሲያይዳ ቃኣሎ'' ኬኤዙዋጉዲ ዓያና ጌኤሺ ዔያቶ ላኣጌሢሮ ፒርጊያና ጋላቲያ ዓጮ'' ጊዴና ቲቂ ዔያታ ዴንዴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ዬካፓ ዔያታ ሚሲያ ዓጮ''ኮ ዛጶ ሄላ''ዖ ቢታኒያ ባንሢ ዓኣዻኒ ማሌኔ፤ ጋዓንቴ ዬሱሴኮ ዓያና'' ዒኢካ ዔያታ ዓኣዻንዳጉዲ ዓይሢባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ዬያሮ ዔያታ ሚሲያ ዓጮ''ና ጌዒ ፂሮዓዳ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ዒዞ ቤዞይዳ ዹሞና ፔቴ'' ሜቄዶኒያ ዓሲ ዔቂ ጴዻዖ ጳውሎሴ ኮራ፦ «ሜቄዶኒያ ባንሢ ፒንቂ ኑና ማኣዴ''!» ጌዒ ጌዒ ዒዛ ሺኢቃያ ፆኦሲ ፔጋሲ ጳውሎሴም ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ጳውሎሴ ዬያ ዛጌስካፓ ዑኬና ሜቄዶኒያ ዓጮ'' ዓኣዻኒ ኑ ኮዔኔ፤ ዓይጎሮ ጌዔቶ ሜቄዶኒያ ዓጮ'' ዓሶም ኮዦ ሓይሶ ኬኤዞም ፆኦሲ ኑና ዓይሤያ ማዔሢ ኑ ዔሬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ፂሮዓዳይዳፓ ዋኣፆ ካኣሚሎ ቶጊ ዔዔቃዖ ሳሞቲራቄ ጌይንታ ዓጮ'' ኑ ዓኣዼኔ፤ ዚሮ ጉቴ''ሎ ጊንሣ ናጱሌ ኑ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ዬካፓ ሓሣ ኑ ዔቂ ፒልጲሲዮሴ ሔሌ''ኔ፤ ፒልጲሲዮሴ ጌይንታዛ ሜቄዶኒያ ዓጮ''ይዳ ዓኣ ካታሞይዳፓ ፔቴ''ዞ ማዔያ ሓሣ ሮሜ ዓጮ'' ዓሳ ማዤ ካታማኬ፤ ዬኖ ካታሜሎይዳ ኑኡኒ ዻካ'' ኬሊ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ዓይሁዶ ዓሶኮ ሓውሾ ኬሎ''ና ካታማፓ ኬስኪ ዎርዚ ዓቺ ኑ ኬዴ''ኔ፤ ዬና ቤዛ ኑ ኮራ ሺኢጲሢ ቤሲ ማሌኔ፤ ዒዞ ቤዞይዳ ኑ ዴዒ ዒኢካ ቡኪንቲ ዓኣ ላኣሎም ፆኦሲ ቃኣሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ኑ ኬኤዛ ባኮ ዋይዛ ላኣሎይዳፓ ፔቴ''ዛ ቲያፂሮኔ ጌይንታ ካታሞይዳ ሾይንቴያ፥ ዞቄ ዓፒላ ኮርማያ፥ ሊዲያ ጎዖ ላኣሊስኬኖኬ፤ ዒዛ ፆኦሲ ካኣሽካ ላኣሊኬ፤ ጎዳሢ ዒዞኮ ዒኖ ቡሌ''ያታሢሮ ጳውሎሴ ኬኤዛ ቃኣሎ'' ዒዛ ዒናፓ ዋይዛኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ዒዞና ዒዞኮ ማኣራ ዓኣ ዓሶና ቢያ ዋኣፆና ማስቴስካፓ፦ «ጎዳሢ ታ ጉሙርቃያ ማዒፆ ዒንሢ ጎኔኬ ጋዓያ ማዔቶ ታ ማኣራ ሙኪ ዴዑዋቴ» ጌዒ ሚርጌና ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ፔቴ'' ኬሊ'' ፆኦሲ ሺኢቆ ቤሲ ኑ ዴንዳንቴ ሎንሦ ባኣዚ ዦዋቶና ኬኤዛ፥ ፑርታ ዓያና ዓርቄ ፔቴ'' ማዾ ማዻ ዉዱሮ ናይስኬና ጎይሢዳ ኑኡና ካኣሜኔ፤ ዬና ዉዱሮ ናዔላ ፔ ዦዋቶና ዒዞ ዎይሣ ዓሶም ሚርጌ ሚኢሼ ዴንቂሳያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ዒዛ ጳውሎሴና ኑኡናናኮ ጊንፆ ሓንቲ ሓንቲ፦ «ሓንሢ ዓሶንሢ፥ ዒንሢም ዻቂንቶ ጎይፆ ኬኤዛዞንሢ፥ ዼኤፖ ፆኦዛሢኮ ማዻዞንሢኬ!» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ዬኖ ዒዛ ሚርጌ ኬሊ'' ማዻኔ፤ ጋፒንፃ ጳውሎሴ ዻጋዻዖ ጊንሢም ሺሪ ፑርቶ ዓያናሢም፦ «ጎዳ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ዒዞይዳፓ ኔ ኬስካንዳጉዲ ታ ኔና ዓይሣኔ!» ጋዓዛ፥ ፑርቶ ዓያናሢያ ቤዞና ኬስኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ዒዞ ዎይሣ ዓሳ ዴንቂ ዔኪ ማኣዲንታ ባኮኮ ጎይፃ ባይቄያ ማዔሢ ዛጋዖ ዔያታ ጳውሎሴና ሲላሴና ዓርቂ፥ ጎቺ ጎቺ ዓሳ ቡኪንታ ቤዞ ኬሲ'' ካታሞ ዎይሣ ዓሶ ቤርቶ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ዬካፓ ሮሜ ዓጮ'' ዎይሣ ዓሶ ቤርቶ ዔኪ ሙካዖ፦ «ሓንሢ ዓሶንሢ ዓይሁዴ ዓሲኬ፤ ሓሣ ካታሞይዳኣ ዔያታ ሚርጌ ዣሎ ዔቂሲሳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ኑኡኒ ሮሜ ዓሳ ዔካኒና ማዻኒ ዓይሢንቲባኣ ባኣዚ'' ዔያታ ኬኤዛኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ዬያሮ ዴራ'' ዎሊ ዑፃ ማዒ ዎልቄና ዔያቶይዳ ዔቄኔ። ዬካፓ ዎይሣ ዓሳ ጳውሎሴና ሲላሴናኮ ዓፒሎ ዑፃፓ ጉሲሳዖ ኮኦሎ''ና ዓሳ ዔያቶ ጳርቃንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ሚርጌና ዔያታ ጳርቂንቴስካፓ ቱኡሲ ማኣሪ ጌልዚ ቱኪ''፥ ቱኡዞ ማኣሮ ካፓ ዓሢ ዔያቶ ዛጊ ካፓንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ካፓ ዓሢ ዓይሢንቴስካፓ ቱኡዞ ማኣሮኮ ጋሮይዳ ዓኣ ሜሌ'' ቆልዓይዳ ጌልዚ ቶኮ'' ዔያቶኮ ዱፄና ኮሺ'' ዓይሢ ቱኬ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ሳዖኮ ዴንዲ ጊዲሚሺ ማዓንዳ ዎዴይዳ ጳውሎሴና ሲላሴና ሺኢጲሢ ሺኢቂ ሺኢቂ ሓሣ ዓይኑሞዋ ዓይናዺ ዓይናዺ ፆኦሲ ጋላታንቴ፤ ሓንጎ ቱኡቴ ዓሳ ዬያ ዔያቶኮ ዋይዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ዒማ''ና ዔርቲባኣንቴ ቱኡዞ ማኣሮኮ ፃጶ ሄሊ'' ዓጊሣ ዼኤፒ ሳዓ ዓጊፂሢ ዓጊፃዛ፥ ቱኡዞ ማኣሮ ካራ'' ቢያ ፔቴ''ና ቡሊ''ንቴኔ፤ ሓሣ ቢያ ቱኡቴ ዓሶ ቱኮ''ና ካኖ ቢራታኣ ቡሊ''ንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ቱኡዞ ማኣሮ ካፓ ዓሢ ጊንዓስካፓ ጴጪ ቱኡዞ ማኣሮ ካራ'' ቡሊ''ንቲ ዓኣሢ ዴንቃዖ ቱኡዞ ዓሳ ቶሊ'' ዴንዴያ ዒዛም ማላዛ ዓፓሮ ፔኤኮ ቱጊ ፔና ዎዻኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ጋዓንቴ ጳውሎሴ፦ «ኑኡኒ ቢያሢ ሃይካኬ! ዬያሮ ኔ ቶኦኮ''ይዳ ፔቴ'' ባኣዚ''ታዖ ማዺፖ!» ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ዬማና ካፓ ዓሢ ፖዒ ዔኪ ጳሽኪ ጋሮ ጌላዖ፥ ጎጋይቂ ጎጋይቂ ጳውሎሴና ሲላሴናኮ ቶኮ'' ዴማ'' ባሊቲና ሎኦሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ዬካፓ ዔያቶ ዙሎ'' ኬሳ''ዖ፦ «ታ ጎዳንሢዮ! ታ ዻቃኒ ዓይጎ ዎኦታንዳያ ኮይሳይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ዔያታ ዒዛም፦ «ጎዳ ዬሱሴ ጉሙርቄ፤ ኔናንታ ኔ ማኣሮ ዓሶንታ ዻቃንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ዬካፓ ጎዳሢኮ ቃኣሎ'' ዒዛና ዒዛኮ ማኣራ ዓኣ ዓሶናም ቢያ ዔያታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ዬማና ቱኡዞ ማኣሮ ካፓ ዓሢ ዬኖ ዋንቶ ዹማ ፔ ማኣሪ ዔኪ ዓኣዺ ኪፆ ዔያቶኮ ማስኬኔ፤ ዬማፓ ኔጉዋዖ ዒዛና ማኣሮ ዓሶና ቢያ ዋኣፆና ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ቱኡዞ ማኣሮ ካፓ ዓሢ ጳውሎሴና ሲላሴና ፔ ማኣሪ ዔኪ ዓኣዺ ሙኡዚ'' ዔያቶም ዒንጌኔ፤ ማኣሮ ዓሶ ቢያሢና ዎላ'' ኪሪስቶሴ ጉሙርቄሢሮዋ ዒ ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ሳዓ ካራዛ ዓጮ'' ዎይሣ ዓሳ፦ «ዬንሢ ዓሶንሢ ቡሊ''ንቶንጎ» ጌዒ ፖኦሊሴስኬንሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ቱኡዞ ማኣሮ ካፓሢያ፦ «ዒንሢ ቡሊ''ንታንዳጉዲ ዓጮ'' ዎይሣ ዓሳ ዓሲ ዳኬሢሮ ዓካሪ ኬስኪ ኮሺ ዓኣዹዋቴ» ጌዒ ጳውሎሴም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ጳውሎሴ ጋዓንቴ፦ «ኑኡኒ ሮሜ ዓሲታንቴ ኑ ጊዳ'' ዎጉዋዖ ዓሳ ቡካ ቤዞይዳ ኑና ጳርቂ፥ ቱኡዞ ማኣራ ኑና ዔያታ ቱኬ''ኔ። ሓሢ ጊንሣ ቱኡዞ ማኣራፓ ዴሚ''ና ኑ ኬስካንዳጉዲ ዎዲ'' ዔያታ ጌዔይ? ዬይ ማዑዋሴ! ዔያታ ፔ ቶኦኪና ሙኪ ኑና ኬሶ''ንጎ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖኦሊሶንሢ ዬያ ዎይሣ ዓሶም ኬኤዛዛ ዎይሣ ዓሳ ጳውሎሴና ሲላሴና ሮሜ ዓጪ ዓሲ ማዔሢ ዔራዖ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ዬያሮ ዔያታ ሙኪ፦ «ኑ ዻቤኔ፤ ማኣሩዋቴ» ጌዒ፥ ቱኡዞ ማኣራፓ ዔያቶ ኬሳ''ዖ ካታማ''ፓኣ ዔያታ ዴንዳንዳጉዲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳውሎሴና ሲላሴና ቱኡዞ ማኣራፓ ኬስኪ ሊዲያ ጎዖዞ ማኣሪ ጌሊ ዒኢካ ኪሪስቶሴ ጉሙርቃ ዓሶ ዴንቂ፥ ዞሪ ዶዲሼስካፓ ካታሞ ሓሺ'' ኬስኪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ጳውሎሴና ሲላሴና ዓንፒጶሊሴና ዓጶሎኒያ ጎዖ ዓጮ'' ጊዴና ቴስሎንቄ ዓኣዼኔ፤ ዒኢካ ዓይሁዶ ዓሶኮ ቡኪንቲ ቤሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳውሎሴ ቤርታፓ ዒዚ ዔራ ጎይፆና ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ፥ ሓይሢ ማይንቲ ዓይሁዶ ዓሶኮ ሓውሾ ኬሎ''ና ኬሎ''ና ጴዺ ጌኤዦ ማፃኣፓፓ ዔኪ ዔኪ ዓሶና ዎላ'' ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ዒማ''ና ዒዚ ሜሲሔ ሜቶ ዔካንዳያ፤ ሃሣ ሓይቢፓኣ ዔቃንዳያ ኮይሳያ ማዔም ማዔሢ ፔጋሲ ኬኤዚ ኬኤዚ፦ «ሃይ ዒንሢም ታ ኬኤዛ ዬሱሴ ዒ ሜሲሔኬ» ጌዒ ጌዒ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ዬያሮ ፔቴ'' ፔቴ'' ዓሳ ቃኣሎ'' ዒና ዔኪ ጳውሎሴና ሲላሴና ዎላ'' ማዔኔ፤ ዬያጉዲ ፆኦሲ ካኣሽካ ሚርጌ ጊሪኬ ዓሲንታ ካታሞይዳ ዔርቴ ዺቢ ላኣሊንታ ቃኣሎ'' ዒና ዔኪ ዔያቶና ዎላ'' ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ዓይሁዶ ዓሳ ጋዓንቴ ቂኢሩሞና ማዾባኣ ፑርታ ዓሲ ጎይፃፓ ጎይፃፓ ቡኩሲ ጌኔ ማዻንዳጉዲ ማሄኔ። ካታሞይዳኣ ዣላ ዔቃንዳጉዲ ማሂ ሓሣ ጳውሎሴና ሲላሴና ዒያሱኔ ማኣራፓ ኬሲ'' ዔኪ ዴሮ'' ቤርቶ ሺኢሻኒ ማኣሮ ካሮ'' ሂዒ ኬኤሪ ጋሮ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ጋዓንቴ ጳውሎሴንሢ ኮዒ ዔያታ ባይዜሢሮ ዒያሱኔና ፔቴ'' ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሲ ካታሞ ዎይሣ ዓሶ ቤርቶ ሺኢሻኒ ጎቺ ጎቺ ዔኪ ዓኣዻዖ፦ «ሓንሢ ዓሶንሢ ዓጮ'' ቢያ ፑርቲሲ ሓሣ ሃይካ ሙኬኔ! ");
INSERT INTO mdybse_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ዒያሱኔያ ዔያቶ ሾኦቺንሢ ዔኬኔ፤ ዔያታ ‹ዬሱሴ ጌይንታ ሜሌ'' ካኣቲ ዓኣኔ› ጌይ ሮሜ ዓጮ'' ካኣቲኮ ዓይሢፆ ዒፂ ማካኔ» ጌይሢና ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ዴሮ''ንታ ካታሞ ዎይሣ ዓሶንታ ዬያ ዋይዛዖ ዲቃቲ ዒኔ ዱጴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ዬካፓ ዎይሣ ዓሳ ዒያሱኔና ዒዛና ዎላ'' ዔኪ ሙኮና ዓሶንሢ ሚኢሼ ዓይሢሳዖ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ኪሪስቶሴ ጉሙርቃ ዓሳ ሳዓ ዹዹማኣና ቤኤሪያ ዓጮ'' ጳውሎሴና ሲላሴና ዑኬና ዓኣዻንዳጉዲ ዳካዛ፥ ዒኢካ ዔያታ ሄላ''ዖ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ቤኤሪያይዳ ዓኣ ዓይሁዶ ዓሳ ቴስሎንቄይዳ ዓኣ ዓሶይዳፓ ፒዜ ማሊሢና ዓኣያ ማዔሢሮ ቃኣሎ'' ዋይዚ ዼኤፒ ዎዛና ዔኪ ቃኣሎ''ኮዋ ጎኑሞ ዔራኒ ቢያ ኬሊ'' ጌኤዦ ማፃኣፖ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ዬያሮ ዔያቶይዳፓ ሚርጌሢ ፆኦሲ ጉሙርቄኔ፤ ጊሪኬ ዓሶይዳፓኣ ሚርጌ ዖርጎቺ ላኣሊ፤ ሃሣ ሜሌ'' ሚርጌ ዓቲንቄያ ፆኦሲ ጉሙርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ጋዓንቴ ቴስሎንቄይዳ ዓኣ ዓይሁዶ ዓሳ ጳውሎሴ ቤኤሪያይዳ ፆኦሲ ቃኣሎ'' ኬኤዜሢ ዋይዛዖ ዒኢካ ሙኪ ዴሮ'' ፑርታ ማሊሢና ዔቂሲ ዣሎ ማዤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ዒማ''ና ኪሪስቶሴ ጉሙርቃ ዓሳ ዑኬና ጳውሎሴ ባዞ'' ዓጮ ዓኣዻንዳጉዲ ዳኬኔ፤ ሲላሴና ፂሞቴዎሴና ጋዓንቴ ዒኢካ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳውሎሴ ጎይፆና ዓኣሤ ዓሳ ዒዛ ዓቴና ሄሊ''ሴኔ፤ ዬና ዓሳ፦ «ሲላሴና ፂሞቴዎሴና ታ ኮራ ዑኮ ሙኮንጎ» ጋዓ ኪኢታ ጳውሎሴ ኮራፓ ዔኪ ቤኤሪያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳውሎሴ ዓቴናይዳ ዴዒ ሲላሴና ፂሞቴዎሴና ካፓንቴ ካታሜሎይዳ ሜሌ'' ካኣሺ ባኣዚ'' ኩሜያ ማዔሢ ዛጋዖ ፔ ማሊፆና ማሊ ሜታዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ዬያሮ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳ፥ ዓይሁዶ ዓሶና ፆኦሲ ካኣሽካ ጊሪኬ ዓሶና ሓሣ ቦኦኮ'' ቤዞይዳ ጴዻ ዓሶና ዎላ'' ፔ ማሊፆ ኬኤዚ ኬኤዚ ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ዔፒቆሮሴ ሓሣ ዒስቶኬ ዓሶ ጌይንታ ዔሮ'' ዓሶይዳፓ ዒዛ ኮራ ዓሲ ሙኪ ሙኪ ማርማኔ። ዔያታ ዒዛና ማርማዖ ፔቴ'' ፔቴ'' ዓሳ፦ «ሓይ ጌኤሲኮ ፃጲ ዔሩዋዖ ጌስታ ዓሢ ዎዚ ጋዓኒ ኮዓይ?» ጋዓዛ፥ ሓንጎዋታ ጊንሣ፦ «ዓኪ ማዔ ካኣሽኮ ፆኦዛ ዛላ ኬኤዛያ ማላኔ» ጋዓኔ። ዬኖ ዔያቶ ጌይሴሢ ጳውሎሴ ዬሱሴና ዒዛኮ ሃይባ''ፓ ዔቂፆ ዛሎ''ዋ ኬኤዜሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ዬያሮ ጳውሎሴ ዔያታ ዓሪዮስፓጎሴ ጌይንታ ቡኪንቶ ቤዞ ዔኤሊ'' ዔኪ ሙካዖ፦ «ኔኤኒ ዔርዛ ዓኮ ባካ ዓይጎታቴያ ኑ ዔራኒ ዳንዳዓ? ");
INSERT INTO mdybse_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ፔቴ'' ፔቴ'' ዓኪ ማዔ ባኣዚ'' ኔ ኑም ኬኤዜኔ፤ ዬያሮ ዬንሢ ባኮንሢ ዓይጎታቴያ ኑ ዔራኒ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ዬያ ዔያታ ጌዔሢ ዓቴናይዳ ናንጋ ዓሶንታ ዒኢካ ናንጋ ሜሌ'' ዓጮ'' ዓሳኣ ቢያ ዓኪ ባኣዚ'' ኬኤዚሢና ዋይዚሢና ዎዶ'' ፔኤኮ ዓኣሣኒ ኮዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ዬማና ጳውሎሴ ዓሪዮስፓጎሴይዳ ቡኪንቴ ዓሶ ቤርታ ዔቃዖ፦ «ዓቴና ዓጪ ዓሲዮቴ! ሚርጌና ዒንሢ ካኣሺ ካኣሽካያ ማዔሢ ታ ዛጋኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ዎይቴይ ጌዔቶ ዒንሢኮ ካታሞ ታ ሓንቲ ሓንቲ ዒንሢኮ ካኣዦ ቤዞ ታ ዛጋኣና ‹ዔርቲባኣ ፆኦሲም› ጌይንቲ ፃኣፒንቴ፥ ሹቺና ኮሾ''ና ዔኤቢ ዒንጎ ቤሲ ታ ዴንቄኔ፤ ዓካሪ፥ ታ ዒንሢም ኬኤዛሢ ዬያ ዔርቲባኣንቴ ዒንሢ ካኣሽካ ፆኦዛሢ ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ዒዚ ዓጮ''ንታ ዓጮ''ይዳ ዓኣ ባኮ ቢያ ማዤሢኬ፤ ሳዖና ጫሪንጮናኮዋ ጎዳኬ፤ ዒዚ ዓሲ ኩቺና ማዢንቴ ካኣሺ ማኣሪዳ ናንጉዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ሼምፔንታ ዑኡሲንታ ሜሌ'' ባኮዋ ቢያ ዓሲም ዒንጋሢ ዒዛ ማዔሢሮ ፔቴ''ታዖ ዒዛም ፓጬ ባኣዚ'' ባኣሴ፤ ዓሲ ማኣዶዋ ዒዛም ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ዒዚ ዓሲ ዜርሢ ቢያ ፔቴ'' ዓሲዳፓ ማዤኔ፤ ዬያኮ ቤርታ ዓሲ ናንጋንዳ ዎዶ''ና ናንጋንዳ ቤዞዋ ማሊ ጊኢጊሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ዬያ ዒ ማዼሢ' ዓሲ ዒዛ ኮዓንዳጉዲና ዛጊ ኮዒ ዴንቃንዳጉዲኬ፤ ያዺ ማዔቶዋ ፆኦሲ ኑና ቢያሢዳፓ ሓኬኬ ጌይሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ዓይጎሮ ጌዔቶ፦ ‹ሼምፔና ኑ ዴዓሢ፥ ኑኡኒ ዓጊፂ ሃንታሢ ናንጊያ ኑ ናንጋሢ ዒዛናኬ› ዬይያ ዒንሢኮ ዓይናዻ ዓሳ፦ ‹ኑኡኒ ቢያሢ ዒዛ ናይኬ› ጋዓሢ ጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«ዓካሪ፥ ኑ ዒዛ ናይ ማዔቶ ‹ፆኦሲ' ዓሲ ዔራቶና ዓሲ ማሊሢና ዎርቄይዳፓ ሓሣ ቢራ ዓንጊና ሹቺናይዳፓ ኮሺ''ንቴ ባኣዚ'' ማላኔ› ጌዒ ማላንዳያ ኑና ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ዓሳ ቤርታ ዒዛ ዔሪባኣ ዎዶ''ና ማዼ ባኮ ፆኦሲ ዛጊ ዓኣሤኔ፤ ሓሢ ጋዓንቴ ዓጮ''ይዳ ዓኣ ዓሳ ቢያ ጎሜይዳፓ ማዓንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ዒዚ ዶኦሬ ዓሢ ዛሎ''ና ዓጮ'' ቢያይዳ ጎኑሞና ዎጋንዳ ኬሊ'' ጌሤኔ፤ ዬያ ዒ ጎናሲ ዔርዜሢ ዬያ ዒዚ ዶኦሬሢ ሓይባ''ፓ ዔቂሲፆናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ዒማ''ና «ሓይቢፓ ዔቂሢ» ጋዓዞ ዔያታ ዋይዛዖ ፔቴ'' ፔቴ'' ዓሳ ዒዛ ቦሄኔ፤ ዛሎ'' ዓሳ ጋዓንቴ፦ «ሓኖ' ባኮ ዛሎ'' ሜሌ'' ዓቢ ኔ ኬኤዛንቴ ኑ ዋይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ዬካፓ ጳውሎሴ ቡኪንቶ ባኣካ''ፓ ኬስኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ፔቴ'' ፔቴ'' ዓሳ ጋዓንቴ ዒዛና ዎላ'' ማዒ ኪሪስቶሴ ጉሙርቄኔ፤ ዬኖ ኪሪስቶሴ ጉሙርቄ ዓሶ ባኣኮ''ይዳ ዓሪዮስፓጎሴ ቡኪንቶ ቤዛ ዎጎ ዎጋያ ማዔ፥ ዲዮኒሲዮሴ ጌይንታ ዓሲና ዴማሪሶ ጌይንታ ፔቴ'' ላኣሊስኬኖና ሓሣ ሜሌ'' ዓሲያ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ዬካፓ ጳውሎሴ ዓቴናይዳፓ ዔቂ ቆሮንቶሴ ዓኣዺ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ዒኢካ ጳንፆሴ ጌይንታ ዓጪዳ ሾይንቴ ዓቂላ ጌይንታ ፔቴ'' ዓሲ ዴንቄኔ። ዬማና ዓቂላ ፔኤኮ ማቾ ጲርስቂላ ጌይንታዞና ዎላ'' ዒፃሊያ ዓጮ''ይዳፓ ሓጊ ሙሙካኔ፤ ዓይጎሮ ጌዔቶ ሮሜ ዓጮ'' ካኣቲ ቄላውዶሴ ዓይሁዶ ዓሳ ቢያ ሮሜ ዓጫ''ፓ ኬስካንዳጉዲ ዓይሤሢሮኬ፤ ዬያሮ ጳውሎሴ ዔያቶ ኮራ ዓኣዺ ዔያቶና ዎላ'' ዔርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ዒዛኮ ማዻ'' ዓዳ'' ዔያቶ ጎይፆ ዓፒላና ማዦ ማኣሮ ሲኪሢታሢሮ ዔያቶና ዎላ'' ዴዒ ዬኖ ማዾ'' ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ሓሣ ዓይሁዴ ዓሶኮ ሓውሾ ኬሎ''ና ኬሎ''ና ዔያቶኮ ቡኪንቶ ቤዞ ዓኣዺ ዓኣዺ ሓይሴ ኬኤዚ ዓይሁዴ ዓሶንታ ጊሪኬ ዓሶንታ ዒ ኬኤዛ ባኮ ጉሙርቃንዳጉዲ ዶዲሺ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ሲላሴና ፂሞቴዎሴና ሜቄዶኒያይዳፓ ዬዓዛ ጳውሎሴ ቢያ ዎዴ፦ «ዬሱሴ ሜሲሔኬ» ጌዒ ዓይሁዶ ዓሶም ማርካዺ ማርካዺ ሓሣ ዔያቶ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ጋዓንቴ ዓይሁዶ ዓሳ ዒዛ ማኪ ጫሽካዛ ፔኤኮ ቶኮ ፒፂ''፦ «ማይ ዓካሪ ዒንሢ ፑርታና ዎጊንቴቴ ዒንሢ ዻቢንቲናኬ! ታና ዖኦጪሳ ባኣዚ'' ባኣሴ፤ ሓካፓ ዓካሪ ታ ዓይሁዴ ማዒባኣ ዓሶ ባንሢ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ዬያይዲ ዔያቶይዳፓ ዱማዺ ቲቶስ ዒዮስፆሴ ጌይንታ ዓሲስኬያ ማኣሪ ዴንዴኔ፤ ዬይ ዓሢ ፆኦሲ ካኣሽካያ ሓሣ ማኣራ ዒዛኮ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞኮ ኮራኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ዬማና ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ሱኡጌ፥ ቄሪስጶሴ ጌይንታስኬይ ፔ ማኣሮ ዓሶ ቢያሢና ዎላ'' ጎዳ ጉሙርቄኔ፤ ሓሣ ሚርጌ ቆሮንቶሴ ዓጮ'' ዓሲያኣ ጳውሎሴ ኬኤዛሢ ዋይዚ ጎዳ ጉሙርቂ ዋኣፆናኣ ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ጎዳሢያ ጳውሎሴም ዹሞና፦ «ዒጊጪፖ፥ ኬኬኤዜ፤ ዚቲ ጌዒፖ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ዓይጎሮ ጌዔቶ ታኣኒ ኔኤና ዎላ''ኬ፤ ሓኖ' ካታሜሎይዳ ታኣኮ ሚርጌ ዓሲ ዓኣኔ፤ ኔ ጊዳ'' ፑርታ ባኣዚ'' ማዻንዳ ዓሲ ፔቴ''ታዖ ባኣሴ» ጋዓያ ፔጋሲ ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ዬያሮ ጳውሎሴ ፆኦሲ ቃኣሎ'' ዴሮ''ም ኬኤዚ ኬኤዚ ፔቴ'' ሌዔና ሲላና ዒኢካ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋሊዮሴ ዓካይያ ጎዖ ዓጮ''ይዳ ዎይሣያ ማዔ ዎዶ''ና ዓይሁዶ ዓሳ ፔቱሞና ጳውሎሴይዳ ፑርታ ማሊሢና ዔቂ፥ ዎጎ ዎጋ ዓሶ ኮራ ዒዛ ዔኪ ዓኣዻዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«ሓይ ዓሢ ዎጋ'' ዓይሡዋ ጎይሢና ዓሳ ፆኦሲ ካኣሽካንዳጉዲ ዓሶ ዻቢሻኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ዒማ''ና ጳውሎሴ ማሂ ኬኤዛኒ ጊኢጊንቲ ዓኣንቴ፥ ጋሊዮሴ ዓይሁዶ ዓሶም፦ «ዒንሢ ዓይሁዶ ዓሳ! ዒንሢዳ ዎንዴ ፑኡፒ ጌኔ ባኣዚ'' ማዺንቴቴ ዒንሢኮ ጌኤዞ ታ ዋይዛንዳያታንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ሓሢ ጌይንቴ ባኣዚ''ና ዔኤቢኮ ሱ'ንሢና ሓሣ ዒንሢኮ ዎጌ ዛላ ዒንሢ ሞኦታቴ ዬይ ዒንሢ ሜቶኬ፤ ታኣኒ ሓያ ባኮይዳ ዎጋኒ ኮዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ያዺ ጌዔስካፓ ዎጎ ዎጎ ቤዛፓ «ኬስኩዋቴ» ጌይ ዔያቶ ኬሴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ዬማና ቢያሢ ዓይሁዶ ዓሶ ቡኪንቶ ቤዞኮ ሱኡጋሢ፥ ሶስቴንሲኔ ዓርቂ ዎጎ ዎጋ ዓሶ ቤርታ ጳርቄኔ፤ ዬይ ባካ ቢያ ማዺንታኣና ጋሊዮሴ ዔኤቢ ዓቴ''ኔ ጎዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳውሎሴ ኪሪስቶሴ ጉሙርቃ ዓሶና ዎላ'' ሚርጌ ኬሊ'' ቆሮንቶሴይዳ ዴዔስካፓ ዔያቶ «ኮሺ ዴዑዋቴ» ጌዒ ዋኣፆ ካኣሚሎና ሶኦሪያ ዓኣዼኔ፤ ዒማ''ና ጲሪስቂላና ዓቂላና ዒዛና ዎላ'' ዓኣዼኔ፤ ዒዛኮ ናኣቢ'' ዓኣሢሮ ዴንዳንዳሢኮ ቤርታ ኪንኪሪያ ጌይንታ ቤሲዳ ቶኦኮ'' ፔኤኮ ጉኡሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ዬካፓ ዴንዲ ዔያታ ዔፕሶኔ ዓጮ'' ሄላ''ዖ ጲሪስቂላና ዓቂላና ዒኢካ ሓሺ'' ፔኤሮ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ጌሊ ዓይሁዴ ዓሶም ሓይሶ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ሚርጌ ዎዴ ዔያቶና ዎላ'' ዴዓንዳጉዲ ዓሳ ዒዛ ሺኢቄንቴ ዒዚ ዔኤዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ጋዓንቴ፦ «ፆኦሲ ጌዔቴ ሜሌ'' ዓቢ ዒንሢ ኮራ ታ ማዒ ሙካንዳኔ» ጋዓዖ፥ ዔፕሶኔ ዓጮ''ይዳፓ ዋኣፆ ካኣሚሎና ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ዒዚ ቂሳሪያ ሄላ''ዖ፥ ዬካፓ ዬሩሳላሜ ዓኣዺ ሺኢጲፆ ማኣሮ ዓሶ «ኮሺዳ» ጌዔስካፓ ማዒ ዓንፆኪያ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ዒኢካ ዻካ'' ዴዔስካፓ ጋላቲያና ፒርጊያ ዓጮ''ናይዳ ፔቴ'' ቤዛፓ ሜሌ'' ቤሲ ሃንቲ ሃንቲ ኪሪስቶሴ ጉሙርቃ ዓሶ ዶዲሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ዒስኪንዲሪያ ዓጪ ዓሲ ፔቴ'' ዓጲሎሴ ጎዖ ዓይሁዴ ዓሲስኬይ ዔፕሶኔ ዓጮ'' ሙኬኔ፤ ዒዚ ጌኤዦ ማፃኣፖ ኮሺ'' ዔራያ ሓሣ ጌስቶ ጎይሢ ዔሪ ጌስታ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ዬይ ዓሢ ጎዳ ዛሎ'' ኮሺ'' ዔራያና ዓያናና ዒናፓ ማዻኒ ማላያ ማዒ ዬሱሴ ዛሎ'' ፒዜ ኬኤዚ ኬኤዚ ዔርዛኔ። ያዺ ማዔቶዋ ዒዚ ባሼ ዔራሢ ዮሓኒሴኮ ዋኣፆ ማስኪፆ ዛሎ'' ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ዬማና ዒዚ ጫርቂ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዛ ኬኤዚሢ ዓርቄኔ፤ ጋዓንቴ ጲሪስቂላና ዓቂላና ዒዛሲ ዋይዛዖ ዒዛ ዔያታ ፔ ማኣሪ ዔኪ ዓኣዺ፥ ፆኦሲ ጎይፆ ዛሎ'' ቤርታኣስካፓ ባሼ ቡሊ'' ዒዛም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ዓጲሎሴ ዓካይያ ዓኣዻኒ ጋዓዛ ኪሪስቶሴ ጉሙርቃ ዓሳ ዒዛ ማሊፆ «ቃራኬ» ጌዔኔ፤ ዓካይያይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሳ ቃራሲ ሾኦቺንሢ ዒዛ ዔካንዳጉዲ ኪኢታ ዔያቶም ዳኬኔ። ዒኢካ ዒዚ ሄላ''ዖ ፆኦሲኮ ኮሹሞ ዛሎ''ና ኪሪስቶሴ ጉሙርቃያ ማዔ ዓሶም ዼኤፒ ማኣዶ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ዎይቲ ጌዔቶ ዬሱሴ ሜሲሔ ማዔሢ ጌኤዦ ማፃኣፖይዳፓ ዔኪ ማርካሲ ማርካሲ፥ ዴሮ'' ቢያሢ ቤርታ ሚርጌና ማርሚ ዓይሁዶ ዓሶ ላሢፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ዓጲሎሴ ቆሮንቶሴይዳ ዓኣ ዎዶ''ና ጳውሎሴ ኬዶ'' ዛሎ'' ዓጮ''ና ጌዒ ዔፕሶኔ ዓኣዺ ሄሊ''፥ ዒኢካ ዻካ'' ኪሪስቶሴ ጉሙርቃ ዓሲ ዴንቃዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«ኪሪስቶሴ ዒንሢ ጉሙርቂ ጎናሲ ዔካኣና ዓያና ጌኤሺ ዒንሢ ዔኪያ?» ጌዒ ዖኦጬኔ። ዔያታ ማሓዖ፦ «ኑኡኒ ዔኪባኣሴ፤ ሓሣ ዓያና ጌኤሺ ዓኣሢያ ኑ ዋይዚ ቤቂባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ጳውሎሴ፦ «ሂዳዖ ዎዚጉዴ ዋኣሢ ማስቲሢዳይ ዒንሢ ማስቴሢ?» ዔያቶ ኮራ ጋዓዛ፥ ዔያታ፦ «ዮሓኒሴ ኬኤዜ ዋኣፆ ማስቲፆናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳውሎሴ ጊንሣ፦ «ዮሓኒሴኮ ማስኪፃ ጎሞ ቡኡፂፆ ዔርዛያ ማዔኔ፤ ዬማና ዴሮ''ም ዒዚ ኬኤዛዖ ‹ታኣኮ ጊንፃፓ ሙካሢ ጉሙርቁዋቴ› ጌዒ ጌዒኬ፤ ያዺ ጌይንቴሢያ ዬሱሴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ዬያ ዔያታ ዋይዛዖ ጎዳ ዬሱሴ ሱ'ንፆና ዋኣፆ ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳውሎሴያ ዔያቶ ዑፃ ኩጮ ጌሣዛ ዓያና ጌኤሺ ዔያቶ ዑፃ ኬዴ''ም፥ ዱማ ዱማ ዻንጋና ዔያታ ጌስቴኔ፤ ፆኦሲ ማሊሢያ ዔያታ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ዬንሢ ዓሶንሢኮ ፓይዳ'' ታጶ ላምዖ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ዒማ''ና ጳውሎሴ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞ ዓኣዺ ሓይሦ ዓጊኒጉዴያ ፆኦሲ ካኣቱሞ ዛሎ'' ማርሚሢና ሓሣ ዴሮ''ም ቡሊ'' ኬኤዚ ኬኤዚ ጫርቂ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ፔቴ'' ፔቴ'' ዓሳ ጋዓንቴ ዒናፓ ዒፂሢና ጎዳሢኮ ጎይፆ ዴሮ'' ቤርታ ጫሽኪ ጫሽኪ «ኑ ዒዛ ጉሙርቃዓ» ጋዓዛ ዔያቶ ዒ ሓሺ'' ዴንዳዖ፥ ኪሪስቶሴ ጉሙርቃዞንሢ ሌሊ ዔኪ ዓኣዺ ፂራኖሴ ጌይንታ፥ ዓሶ ዔርዞ ዳልጎ ማኣሮይዳ ቢያ ኬሊ'' ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ጳውሎሴ ላምዖ ሌዔ ጉዴያ ዒዞ ጎይፆ ዒኢካ ማዼኔ፤ ዒማ''ና ዒሲያ ዓጮ''ይዳ ናንጋ ዓይሁዶ ዓሶንታ ዓይሁዴ ማዒባኣ ዓሶንታ ቢያ ጎዳኮ ቃኣሎ'' ዋይዛኒ ዳንዳዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ኮሺ'' ዲቃሣ፥ ፔ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ጳውሎሴ ዛሎ''ና ፆኦሲ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ዬያይዳፓ ዔቄያና ጳውሎሴኮ ዑፆ ሄሌ'' ዓፒሎንታ ማኣዓሢንታ ዓሳ ዔኪ ዔኪ ሓርጊንቴ ዓሶ ዑፆ ካንሣዛ ዶርዓሢዳፓ ዓሳ ዻቃኔ፤ ሓሣ ፑርቶ ዓያናኣ ዓሶይዳፓ ኬስካኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ፑርቶ ዓያኖ ዓሶይዳፓ ኬሲ'' ኬሲ'' ሃንታ ፔቴ'' ፔቴ'' ዓይሁዶ ዓሳ፦ «ጳውሎሴ ኬኤዛ፥ ዬሱሴ ሱ'ንፆና ዒንሢ ኬስካንዳጉዲ ኑ ዒንሢ ዓይሣኔ» ጌዒ ጌዒ ፑርቶ ዓያኖ ዓሶፓ ኬሳ''ኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ዬኖ ማዻሢ' ዓይሁዶ ቄኤሶኮ ሱኡጋሢ፥ ዓስቄዋ ጎዖሢኮ ላንካይ ናይስኬንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ጋዓንቴ ፑርቶ ዓያናሢ፦ «ዬሱሴ ታ ዔራኔ! ጳውሎሴ ዛሎ''ዋ ታ ዔራኔ! ሓይ ዒንሢ ዖናንሢዳዖ?» ዔያቶ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ዒማ''ና ፑርቶ ዓያና'' ዓርቄ ዓሢ ኮኦሚ ጩኡሊ'' ዓርቂ ዓርቂ ዔያቶ ባሼኔ፤ ዬካፓ ዔያታ ሱጉቲ፥ ኪፃዺ ሓሣ ዓፒላ''ኣ ዔያቶኮ ዳርዔም ጋራፓ ጳሽኪ ኬስኪ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ዬይ ባካ ዔፕሶኔይዳ ናንጋ፥ ዓይሁዴ ማዒባኣ ዓሶና ዓይሁዶ ዓሶናም ዋይዚንቴሢሮ ቢያሢ ዒጊጬኔ፤ ጎዳ ዬሱሴኮዋ ሱ'ንፃ ሚርጌና ቦንቺንቴያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ኪሪስቶሴ ጉሙርቃ ዓሶይዳፓ ሚርጌሢ ፑርቶ ማዾ'' ፔኤኮ ፔጌና ቡኡፂ ቡኡፂ ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ሚርጌ ማርሾ ማርሻ ዓሳ ፔኤኮ ማርሻሢ ማፃኣፖ ቡኩሲ ዴሮ'' ቤርታ ታሚና ሚቼኔ፤ ዬያ ማፃኣፖኮ ሚኢሻ ዶንጊታሚ'' ሺያ ሹቺ ቢራ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ዬያይዲ ጎዳሢኮ ቃኣላ'' ሚርጌና ዳልጊ ዳልጊ ሓሣ ባሺ ባሺ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ዬይ ቢያ ማዔሢኮ ጊንፃ ጳውሎሴ ሜቄዶኒያና ዓካይያ ዓጮ'' ጊዴና ጌዒ ዬሩሳላሜ ዓኣዻኒ ፔ ማሊሢና ማላዖ፦ «ዒኢካ ታ ሄሌ''ስካፓ ሮሜ ዓጮ'' ዓኣዻንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ዬያሮ ዒዛና ዎላ'' ማዻ ዓሶይዳፓ ላምዖንሢ፥ ፂሞቴዎሴና ዔራስፆሴና ሜቄዶኒያ ዓጮ'' ዳኪ ዒዚ ፔኤሮ ዒሲያይዳ ዻካ'' ኬሊ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ዬማና ጎዳሢ ጎይፆ ዛሎ''ና ዔፕሶኔይዳ ዼኤፒ ዣላ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ፔቴ'' ዴሜፂሮሴ ጌይንታ ሚኢሼ ዹዓስኬይ ዓርፄሚሴ ጌይንታ ሺኢጲፆ ማኣሮ ማላ ባኣዚ'' ቢራ ዓንጊና ዹይ ማዢ ማዢ ቢሮ'' ዹዓ ዓሶም ሚርጌ ባኣዚ'' ዴንቂሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ዬይ ዓሢ ዬያቶ፥ ቢሮ'' ዹዓ ዓሶና ዔያቶጉዴያ ማዾ'' ማዻ ሜሌ'' ዓሶ ቡኩሳዖ፦ «ዓሲዮቴ! ኑኡኒ ቆሎ ዴንቃሢ ሓኖ' ማዾ''ና ማዔሢ ዒንሢ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ሓይ ጳውሎሴ ጎዖሢ ‹ዓሲ ኩቺና ማዢንቴ ማላሢ ካኣሽኮ ባኣዚ''ቱዋሴ› ጌዒ ጌዒ ዔፕሶኔ ዓጮ''ይዳ ሌሊቱዋንቴ ዻካ'' ዓጪ ሌሊ ዓታዛ ዒሲያ ዓጮ'' ቢያይዳ ዋኣዼ ዓሲ ዒዚ ጎኔኬ ጌይሲ፤ ሓሣ ኪሪስቶሴ ጉሙርቃንዳጉዲ ማሄቶዋ ዒንሢ ዒንሢ ቶኦኪና ዛጌሢና ዋይዜሢና ጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ዬያ ዛሎ''ና ሓይ ኑኡኮ ማዻ'' ቦሂንታንዳኔ ጌይሢኬ፤ ሓሣ ዬያ ሌሊቱዋንቴ ዒሲያና ዓጮ'' ቢያሢናይዳ ዓኣ ዓሳ ቢያ ካኣሽካ፥ ዼኤፖ ዓርፄሚሴ ሺኢጲፆ ማኣሬላ ጉሪ ማዒ ዓታኒኬ፤ ዒዞኮ ዼኤፑማኣ ማይ ጋፓኒኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ዓሳ ዬያ ዋይዛዖ ዻጋዺ፦ «ዔፕሶኔይዳ ዓኣ ዓርፄሚሴ ሺኢጲፆ ማኣራ ዼኤፒኬ!» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ካታሜላ ዬያ ዣላሢዳፓ ዔቄያና ካራ ባይዜኔ፤ ዴራ'' ሜቄዶኒያ ዓጮ'' ሾይንቲ ማዔ ላምዖ ጳውሎሴኮ ላጎንሢ፥ ጋይዮሴና ዓሪስፂሮኮሴና ዓርቂ ጎቺ ጎቺ ዴራ'' ቡኪንታ ቤዞ ዔኪ ጳሽኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳውሎሴ ዬማና ዴሮ'' ባንሢ ዓኣዻኒ ኮዔንቴ ኪሪስቶሴ ጉሙርቃ ዓሳ ዒዛ ላኣጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ዒሲያ ዓጮ''ይዳ ዓኣ ዎይሣ ዓሶይዳፓ ፔቴ'' ፔቴ'' ዒዛ ናሽካዞንሢ ጳውሎሴ ኮራ ዓሲ ዳኪ፦ «ኔኤኒ ዓሳ ቡኪንታ ቤዞ ዓኣዺ፥ ዒኢካ ኔ ጴዹዋጉዲ» ጌዒ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ዒማ''ና ዴሮ'' ባኣኮ''ይዳ ዼኤፒ ዣላ ዓኣሢሮ ባሼሢ ዓይጎሮ ቡኪንቶቴያ ፔቴ''ታዖ ዔሩዋሴ፤ ዬያይዳፓ ዔቄያና ፔቴ'' ዓሲ ፔቴ'' ባኣዚ'' ጌዒ ዒላታዛ፥ ሜሌ''ሢ ሜሌ ባኣዚ'' ጌዒ ጌዒ ዒላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ፔቴ'' ፔቴ'' ዓይሁዶ ዓሳ ዒስኪንዲሬ ጌይንታ ዓሢ ዔቂ ጌስታንዳጉዲ ሂዖሢጉዲ ዎኦቲ ዴሮ'' ቤርቶ ሺኢሼኔ፤ ዛሎ'' ዓሳ ሓሣ ዒዚ ኮሺ'' ማርማንዳጉዲ ዒዛ ዞሬኔ፤ ዬያሮ ዒስኪንዲሬ ዴራ'' ዚቲ ጋዓንዳጉዲ ኩቺና ቤኤዛዖ ጌኤዞ ማሃንዳ ጌኤሲ ጌስታኒ ጊኢጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ጋዓንቴ ዒስኪንዲሬ ዓይሁዴ ዓሲ ማዔሢ ዴራ'' ዔራዖ፦ «ዔፕሶኔይዳ ዓኣ ዓርፄሚሴ ዼኤፒኬ!» ጌዒ ቢያሢ ፔቴ'' ዑኡሲና ሚርጌ ኔጊ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ጋፒንፆይዳ ካታሞኮ ፃኣፓሢ ዴሮ'' ዚቲ ጌይሳዖ፦ «ዔፕሶኔ ዓጪ ዓሲዮቴ! ዔፕሶኔ ካታሞይዳ ናንጋ ዓሳ ዼኤፖ ዓርፄሚሴ ጌይንታ ሺኢጲፆ ማኣሬሎና ጫሪንጫፓ ኬዴ'' ዒዞኮ ማላሢና ካፓያ ማዔሢ ቢያሢ ዔራያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ዬያ ዔሩዋሴ ጋዓንዳይ ዖኦኒያ ባኣሢሮ ዚቲዮ ዒንሢ ጋዓንዳጉዲና ሩኡሪ ፑርታ ባኣዚ'' ማዺሢዳፓ ዒንሢ ካፒንታንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ጌኤዦ ሺኢጲፆ ማኣሮ ቡሪባኣ ዓሲና ኑኡኮ ካኣሽኮ ፆኦዞ ጫሽኪባኣ ዓሲ ሓይካ ዒንሢ ጉሪ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ዲሜፂሮሴንታ ዒዛና ዎላ'' ዓኣ ቢሮ'' ዹዓ ዓሳ ኬኤዛ ባኣዚ'' ዓኣቶ ጌኤዛ ዛጊ ዎጊንታኒ ሜሌ'' ኬሊ'' ዓኣኔ፤ ሓሣ ዬኖ ዛሎ''ና ቢታንታ ዓኣ ዓሳኣ ዓኣኔ፤ ዒኢካ ዔያታ ሞኦቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ሜሌ'' ዒንሢ ኮዓ ባኣዚ'' ዓኣታቶ ዳምቤና ጌስቲ ዎጋንዳጉዲ ጌይንቴ ዓሶና ዛጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ሓያ ማዺንቴ ባኮ ዛሎ''ና ‹ዔያታ ዣላሢ ዔቂሲሴኔ› ጌይ ኑና ዖኦጪሱዋጉዲ ኑና ዒጊቻኔ፤ ‹ሓይ ዣላሢና ፑርቶ ባካ ዓይጎ ዛላና ዔቄይ?› ጌይ ኑና ዖኦጮናቶ፥ ማሂ ኑ ኬኤዛንዳ ባኣዚ'' ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ያዺ ጌዔስካፓ ቡኪንቶ ላኣሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ዣላሢ ዚቲ ጌዔስካፓ ጳውሎሴ ኪሪስቶሴ ጉሙርቃ ዓሶ ፔቴ''ይዳ ዔኤሊ''ሲ ዞሮ ቃኣላና ዶዲሺ፦ «ኮሺ ዴዑዋቴ» ጌዒ ሜቄዶኒያ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ዒዚ ጊዴና ዓኣዻ ቤዞይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶ ሚርጌና ዞሪ ዶዲሺ ዶዲሺ ጊሪኬ ዓጮ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ዒኢካ ዒዚ ሓይሦ ዓጊኒ ዴዒ፥ ዬካፓ ዋኣፆ ካኣሚሎና ሶኦሪያ ዓጮ'' ዓኣዻኒ ማሌኔ፤ ጋዓንቴ ዓይሁዶ ዓሳ ዒዛይዳ ፑርታ ማሊሢ ማሌሢ ዒ ዔሬ ዎዶ''ና ሜቄዶኒያ ዓጮ'' ጊዴና ዓኣዻኒ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ጳፂሮሴ ናኣዚ'' ሱሲ ጎዖሢ ቤኤሪያይዳፓ፥ ዓሪስፂሮኮሴና ሲኮንዶሴና ቴስሎንቄይዳፓ፥ ጋይዮሴ ዴርቤይዳፓ፥ ቲኪቆሴና ፂሮፒሞሴና ዒሲያ ዓጫ''ፓ፤ ሓሣ ፂሞቴዎሴያ ዒዛና ዎላ'' ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ዔያታ ቤርታዺ፥ ቢሪ ዓኣዺ ፂሮዓዳይዳ ኑና ካፔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ኑኡኒ ጋዓንቴ ላኣዶ ሙዒ ቦንቾ ኬሎ''ኮ ጊንፃ ፒልጲሲዮሴይዳፓ ዋኣፆ ካኣሚሎና ዶንጎ ኬሊ'' ሓንቲ፥ ዔያታ ዓኣ ቤዞ ፂሮዓዳ ሄሊ'' ዒኢካ ላንካይ ኬሊ'' ኑ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ቂዳሜ ዋንቴ ዉዴ ባንሢ ካራኒ ዑካኣና ካሣ ሙዓኒ ሓሣ ጎዳ ካዋሢያ ሙዓኒ ፔቴ''ይዳ ኑ ቡኪንቴኔ፤ ጳውሎሴ ዚሮ ጉቴ''ሎ ዓኣዻኒ ጌዔያ ማዔሢሮ ቡኪንቴ ዓሶም ሓይሴ ኬኤዛዖ፥ ሃይሶ ሳዖኮ ዴንዲ ጊዲሚሺ ሄላ''ንዳኣና ዖዶሲ ጌስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ኑኡኒ ቡኪንቴ፥ ኩቦጉዲ ዎሊ ዑፃ ዑፃ ማዢንቴ ማኣሮይዳ ሚርጌ ፖዒ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ዔውፂኮሴ ጌይንታ ፔቴ'' ዼጌስኬያ ኬኤፆኮ ፑልቶ ካራ'' ዴዒ ዓኣንቴ ጳውሎሴ ጌኤዞ ዖዶሴሢሮ ዼጌ ናዓሢ ጊንዓ ዓርቃዛ ጊንዒቤቃ ጊንዓሢ ባሼም ዎሊኮ ዑፃ ዑፃ ማዦና ማኣሮኮ ሓይሣሳሢዳፓ ኬዲ'' ሎኦሜኔ፤ ዬካፓ ዓሳ ዔቂሳኣና ናማ ሃይቄያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ጋዓንቴ ጳውሎሴ ሎፓ ኬዲ'' ሂርኪ ጌይ፥ ናማ ኮንቂ ዓርቃዖ፦ «ናማ ሼምፔና ዓኣኔ፤ ዲቃቲፖቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ዬካፓ ጳውሎሴ ጊንሣ ዑፆ ኩቦ ማኣሮ ኬስኪ፥ ጎዳ ካዋሢና ካሦና ኪሪስቶሴ ጉሙርቃ ዓሶና ዎላ'' ሙዔኔ። ሳዓ ካራንዳያ ሄላ''ንዳኣና ዓሶና ዎላ'' ጌስታዖ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ዓሳ ሓይቄዖ ዻቄ፥ ዼጌ ናዓሢ ማኣሪ ዔኪ ዓኣዼኔ፤ ሓሣ ኮሺ''ያ ዶዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ኑኡኒ ጳውሎሴ ዔኪ ዓኣዻኒ ማሌሢሮ ቤርታዺ ዋኣፆ ካኣሚሎና ዓሶሳ ኑ ዴንዴኔ፤ ዬያ ኑ ማዼሢ' ጳውሎሴ ዓሶሳ ዴንዲ ሄላ''ንዳኣና ቶኪና ዓኣዻኒ ኮዔሢሮና ሓሣ ኑ ዬያይዳንዳጉዲ ኑና ዒ ዓይሤሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ዬካፓ ዒዛና ኑ ዓሶሳይዳ ካኣማዖ፥ ዋኣፆ ካኣሚሎ ዒዛ ቶጊሲ ዔኪ ሚሊፂ ዓጮ'' ዎላ'' ኑ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ዬካፓ ዚሮ ጉቴሎ ዔቂ ኪዮሴ ጌይንታ ዓጮ''ኮ ቤርቶ ዛላ'' ዓኣ ቤዞ ኑ ሄሌኔ፤ ላማሳ ኬሎ'' ሳሞኔ ፒንቃዖ ጉቴና ሚሊፂ ኑ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳውሎሴ ዒሲያይዳ ዎዶ'' ጉሪ ኩርሱዋጉዲ ጌዒ ዔፕሶኔ ዓጮ''ኮ ኮርሳ ዓኣዻኒ ኮዔኔ፤ ዓይጎሮ ጌዔቶ ዓይሁዶ ዓሶኮ ጴንፄቆስፄ ጌይንታ ቦንቾ ኬሎ'' ዎይቴቴያ ዬሩሳላሜ ሄላ''ኒ ዒ ማሌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳውሎሴ ሚሊፂዳፓ ዔፕሶኔ ኪኢታ ዳኪ፥ ሺኢጲፆ ማኣሮኮ ጪሞ ዔኤሊ''ሴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ዬካፓ ዔያታ ዒዛ ኮራ ሙካዛ ዒዚ ዔያቶም ኬኤዛዖ፦ «ዒሲያ ዓጮ'' ታ ጌሌ ኬላ''ፓ ዓርቂ ቢያ ኬሊ'' ዒንሢና ዎላ'' ታኣኒ ዎይቲ ናንጌያታቴያ ዒንሢ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ዓይሁዶ ዓሳ ታ ጊዳ'' ፑርቶ ማዻ ዛሎ''ና ሜታ ታና ሄሌ''ታቴያ ጉቤ ዒናፓ ማዔ ሼሌዑሞና ሓሣ ሚርጌ ዓቢሢና ታ ጎዳሢም ታ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ዓሳ ቡካ ቤዞይዳ ማዖም ዒንሢኮ ማኣራ ማኣራ ታ ዒንሢ ዔርዛ ዎዶ''ና ዒንሢም ኮይሳ ባኣዚ'' ቢያ ታ ኬኤዜኔ፤ ፔቴ''ታዖ ዓይሴ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ዓይሁዶ ዓሶ ማዔቶዋ ዓይሁዴ ማዒባኣ ዓሳ ጎሞ ቡኡፂ ፆኦሲ ባንሢ ሙካንዳጉዲና ሓሣ ጎዳ ዬሱስ ኪሪስቶሴ ጉሙርቃንዳጉዲ ዔያቶም ታ ላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ሓሢያ ታ ዒኢካ ሄላ''ዛ ታ ጊዳ'' ዓይጌ ማዺንታንዳቴያ ታ ዔሩዋዖ፥ ዓያና ጌኤሺም ዓይሢንቲ ዬሩሳላሜ ታ ዓኣዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ጋዓንቴ ታ ዔራሢ' ታኣኒ ዴንዳ ካታሞይዳ ቢያ ቱኡሲና ሜቶና ታና ሄላ''ንዳሢ ዓያና ጌኤሺ ታኣም ላቲ ኬኤዜማ ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ታኣኒ ጋዓንቴ ታኣኮ ማዾ'' ኩንሤንቴ ሓሣ ጎዳ ዬሱሴ ታኣም ዒንጌ ማዾ'' ታ ማዼንቴ ሓይቄቴያ ሜታ ባኣሴ፤ ታኣኮ ማዻ'' ፆኦሲ ፔ ኮሹሞና ታኣም ዒንጌ ኮዦ ሓይሶ ኬኤዚሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«ሃኖ'' ሄላ''ንዳኣና ዒንሢ ቢያሢ ባኣካ'' ታ ሃንቲ ሃንቲ ፆኦሲኮ ካኣቱሞ ዛሎ'' ኬኤዜኔ፤ ሓይካፓ ሴካ ጋዓንቴ ዒንሢዳፓ ፔቴ'' ዓሲታዖ ታኣኮ ዓኣፖ ካሮ'' ማሊ ዛጊንዱዋኣሢ ታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ዓካሪ ዒንሢዳፓ ፔቴ'' ዓሲታዖ ባይቄቶ ታና ዖኦጪሳ ባኣዚ'' ባኣያ ማዔሢ ሓኖ'' ታ ዒንሢም ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ዓይጎሮ ጌዔቶ ፆኦሲኮ ማሊፆ ቢያ ዒንሢም ታ ኬኤዜያፓዓቴም ፔቴ''ታዖ ታ ዓይሴ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ዓያኖ ጌኤዣ ቆልሞኮ ሄንቃ ዓሲ ማሂ ዒንሢ ዶኦሬኔ፤ ዓካሪ ዒ'ንሢ ቶኦኮ''ና ዒንሢ ሄንቃ ቆልሞ ዛሎ''ናሮ ዒንሢ ኮሺ'' ዔሩዋቴ፤ ጎዳ ፔ ሱጉፆና ሻንቂ ፔኤም ማሄ፥ ሺኢጲፆ ማኣሮ ዓሶ ሄንቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ታኣኒ ዓኣዼስካፓ ቆልሞም ሚጪንቱዋያ፥ ያኣዮጉዴ ዓሲ ዒንሢ ባኣኮ'' ጌላንዳሢ ታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ዬያጉዲ ሓሣ ዒንሢ ባኣካ''ፓ ፔቴ'' ፔቴ'' ዓሲ ዔቂ ኪሪስቶሴ ጉሙርቃ ሚርጌ ዓሶ ፔ ባንሢ ማሃኒ ዎቦ ማዔ ዔርዚሢ ዔርዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ዬያሮ ዒንሢ ፔቴ'' ፔቴ''ሢ ታኣኒ ሓይሦ ሌዔ ዋንቴና ሮኦሪና ዓቢሢና ዬኤኪ ዬኤኪ ዞሬያ ማዔሢ ጶቂሢ ጶቂሢ ዶዱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«ሓሢ ታኣኒ ፆኦሲ ዒንሢ ካፓንዳጉዲ ዒዛም ዓኣሢ ዒንጋኔ፤ ዒንሢ ፆኦሲኮ ዼኤፖ ኮሹሞ ዛሎ'' ኬኤዛ፥ ኪኢቶ'' ጶቂሡዋቴ፤ ዬይ ኪኢታ'' ዒንሢ ማኣዳ''ንዳኔ፤ ሓሣ ፆኦሲ ዓሶ ማዒፆና ዒንሢሮ ማዔ ባኮ ዒንሢም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ታኣኒ ዖኦኮ ቢራኣ ማዖም ዎርቄ፤ ሓሣ ማኣዖዋ ዛጊ ሱኡካዺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ታ ኩቺና ማዺ ማዺ ታናንታ ታ ላጎንታ ታኣኒ ማኣዴ''ሢ ዒንሢ ዒንሢ ቶኦኪና ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‹ዔዔካያይዳፓ ባሼ ዒንጋያ ዓንጂንቴያኬ› ጋዓ፥ ጎዳ ዬሱሴኮ ቃኣሎ'' ጶቂሢ ጶቂሢ ኑ ኩቻ ኑ ማዺ ማዺ ላቢንቴ ዓሶ ማኣዳ''ንዳያ ኮይሳሢ ሚርጌ ጎይሢና ታ ዒንሢ ዻዌኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ዬካፓ ጳውሎሴ ቢያሢና ዎላ'' ጉምዓቲ ፆኦሲ ሺኢቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ዒማ''ና ቢያሢ ዬኤካዖ፥ ጳውሎሴ ኮንቂ ኮንቂ ሄርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ፔቶ ዔያቶ ኮሺ'' ዖዪሴዛ፦ «ሓካፓ ሴካ ታኣኮ ዒንሢ ዓኣፖ ካሮ'' ዛጊንዱዋሴ» ዒዚ ጌዔዞኬ። ዬካፓ ዴንዲ ዋኣፆ ካኣሚሎ ሄላ''ንዳኣና ዒዛ ዔያታ ጎይሣ ዓኣሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ዔያቶይዳፓ ኑ ዱማዼሢኮ ጊንፃ ዋኣፆ ካኣሚሎ ቶጊ ዔዔቃዖ ቆሴ ጌይንታ፥ ዋኣሢ ሳዛይዳ ዓኣ ዓጪ ኑ ዓኣዼኔ፤ ዬካፓ ዚሮ ጉቴ''ሎ ዋኣፆ ሳዛ'' ዓኣ ሩዴ ጌይንታ ዓጪ ኑ ሄሊ''፥ ዒኢካፓ ጳፂራ ካታሞ ኑ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ዒዞ ቤዞይዳፓ ፒንቄ ዓጮ'' ዓኣዻ ዋኣሢ ካኣሚሌ ዴንቃዖ ዒዞ ቶጊ ጊንሣ ኑ ዓኣዺፆ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ዋኣፆ ሳዞ''ይዳ ዓኣ ቆጲሮሴ ዓጮ'' ሻውሎ'' ዛሎ''ይዳ ሓሺ''፥ ሶኦሪያ ዓጮ'' ኑ ዓኣዺቤቃ ባዞ'' ዓጫ ዓኣ ፂሮሴ ኑ ዴንዴኔ፤ ዓይጎሮ ጌዔቶ ዋኣፆ ካኣሚላ ጫኣኒንቴ ባኮ ዒኢካ ኬይሳንዳያ ኮይሳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ዒዞ ቤዞይዳ ኪሪስቶሴ ጉሙርቃ ዓሶ ኮዒ ኑ ዴንቃዖ፥ ዔያቶና ዎላ'' ላንካይ ኬሊ'' ዴዔኔ። ዔያታኣ ዓያና ጌኤሺ ዔያቶም ኬኤዛዛ ጳውሎሴም፦ «ዬሩሳላሜ ዴንዲፖ» ጌይ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ዒኢካ ኑ ዴዓ ዎዳ'' ጋፔም ዔያቶይዳፓ ኑ ዱማዺ ሓንቲፆ ዓርቃዛ፥ ቢያሢ ፔኤኮ ላኣሎና ናኣቶ''ና ዎላ'' ማዒ ካታሞኮ ዙሎ'' ሄላ''ንዳኣና ኑና ጎይሢና ዓኣሢ ባዞ'' ዓጮ ኑና ሄሊ''ሴም፥ ዒኢካ ጉምዓቲ ፆኦሲ ኑ ሺኢቄስካፓ ዎሊ ኑ ሳራሢ ዱማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ዬካፓ ኑኡኒ ዋኣፆ ካኣሚሎ ቶጊ ዴንዳዛ ዔያታ ፔ ማኣሮ ባንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ፂሮሴይዳፓ ዒቂ ባዞ'' ጊዴና ሓንቲፆ ኑ ኩርሴስካፓ ጴፄሌማይሴ ጌይንታ ዓጮ'' ሄሊ''፥ ዒኢካ ኪሪስቶሴ ጉሙርቃ ዓሶና ዎላ'' ካኣሚ ዎሊ «ኮሺዳ?» ጌዔስካፓ ዔያቶና ዎላ'' ፔቴ'' ኬሊ'' ኑ ፔኤቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ዚሮ ጉቴ''ሎ ዒኢካፓ ኬስኪ ቂሳሪያ ዓጮ'' ዓኣዺ፥ ዒኢካ ፆኦሲ ማኣራ ማዻንዳጉዲ ዶኦሪንቴ ላንካዎ ዲ=ያቆኖንሢዳፓ ፔቴ''ሢ ማዔ፥ ኮዦ ሓይሶ ኬኤዛ፥ ፒልጶሴ ማኣሪ ጌላዖ ዒዛና ዎላ'' ኑ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ዒዛኮ ፆኦሲ ማሊሢ ኬኤዛ፥ ዖይዶ ዉዱሮ ናይ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ሚርጌ ኬሊ'' ዒኢካ ኑ ዴዔስካፓ ዓጋቦሴ ጌይንታ ፆኦሲ ማሊሢ ኬኤዛስኬይ ዪሁዳ ዓጫ''ፓ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ዬይ ዓሢ ኑ ባንሢ ሙካዖ ጳውሎሴኮ ቃልሾ ዔኪ ፔኤኮ ኩጮና ቶኮና ቱኪ''፦ «ዓያና ጌኤሺ ሃኖ' ቃልሼሎኮ ዓዶ ዬሩሳላሜይዳ ዓኣ፥ ዓይሁዶ ዓሳ ሓይማይዲ ቱኪ'' ዓይሁዴ ማዒባኣ ዓሶም ዒንጋንዳኔ ጋዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ዬያ ኑኡኒ ዋይዛዖ ኑናንታ ዒኢካ ዓኣ ዓይሁዶ ዓሶንታ ጳውሎሴ ዬሩሳላሜ ዴንዱዋጉዲ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ጳውሎሴ ጋዓንቴ፦ «ሓያይዲ ዬኤኪ ዬኤኪ ዓይጎሮ ዒንሢ ታኣኮ ዒኖ ዱኡዛይ? ታኣኒ ጎዳ ዬሱሴ ሱ'ንፆ ዛሎ''ሮ ዬሩሳላሜይዳ ቱኡቲሢሮ ሌሊቱዋንቴ ሓይቃኒያ ጊኢጊንቴያኬ» ጌዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ኑ ዞራ ዞሮ'' ዒ ዔኮ ዒፃዛ፦ «ማይ ፆኦሲ ማሊሢ ማዖንጎ» ጌዒ ኑ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ዒኢካ ኑኡኒ ዻካ'' ኬሊ'' ዴዔስካፓ ኑኡኮ ዓኣ ሜሆ'' ኑ ጊኢጊሺ ዬሩሳላሜ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ቂሳሪያይዳ ዓኣ፥ ፔቴ'' ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሳ ኑኡና ሙኪ፥ ሚናሶኔ ጌይንታሢ ማኣራ ኑ ዴዓንዳጉዲ ዒዛ ማኣሮ ኑና ዻዌኔ። ዬይ ዓሢ ቤርታዺ ኪሪስቶሴ ጉሙርቄያ፥ ቆጲሮሴ ዓጮ''ይዳ ሾይንቴ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ዬሩሳላሜ ኑ ሄላ''ዛ ኪሪስቶሴ ጉሙርቃ ዓሳ ዎዛና ኑና ሾኦቺንሢ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ዚሮ ጉቴ''ሎ ጳውሎሴ ኑኡና ዎላ'' ያይቆኦቤ ኮራ ዓኣዼኔ፤ ዒኢካ ሺኢጲፆ ማኣሮኮ ጪማ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳውሎሴ ቢያሢ «ኮሺዳ?» ጌዔስካፓ ዒዛ ዛሎ''ና ዓይሁዴ ማዒባኣ ዓሶ ባኣካ'' ፆኦሲ ማዼ ባኮ ቢያ ፓይዲ ፓይዲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ዬያ ዋይዜ ዎዶ''ና ቢያሢ ፆኦሲ ጋላታዖ ጳውሎሴም፦ «ዒሻሢዮ! ሚርጌ ሺያና ፓይዲንታ፥ ኪሪስቶሴ ጉሙርቃ ዓሲ ዓይሁዶ ዓሶ ባኣካ'' ዓኣያ ማዔሢና ሓሣ ቢያሢ ሙሴ ዎጎ ዓርቂ ካፓያ ማዔሢ ኔኤኒ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ኔኤኒ ዓይሁዴ ማዒባኣ ዓሶ ባኣኮ''ይዳ ናንጋ፥ ዓይሁዶ ዓሶ ቢያ ‹ናኣቶ''ኮ ዒንሢኮ ዓቲንቶ ቤርቶ ቲቂፖቴ፤ ሓሣ ዎጎዋ ኩንሢፖቴ› ጌዒሢና ሙሴ ዔርዜ ዎጎ ዓሳ ሓሻ''ንዳጉዲ ማሓኔ ጌይንቴሢ ኑ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ማይ ዎዴቴ ኮሽካንዳይ? ሙኪፆ ኔኤኮ ዔያታ ጎኔና ዋይዛንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ዬያሮ ኑኡኒ ጋዓ ባኮ ማዼ፤ ኑ ባኣኮ''ይዳ ናኣቢ'' ዓኣ ዖይዶ ዓሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ዔያቶ ዔኪጋፓ ዔያቶና ዎላ'' ማዒ ኔና ጌኤሼ፤ ቶኦኮ'' ጋፓኖ ዔያታ ጉኡሊ''ንታንዳጉዲ ጌኤዦ ማኣሮም ዒንጊንታ ሚኢሾ ዔያቶም ጪጌ፤ ዬያ ኔ ማዼቶ ኔ ዑፃ ጌስቲንታ ጌኤዛ ጉሪ ማዔሢና ኔኤኒያ ኔ ቶኦኪና ሙሴ ዎጎ ኩንሣያ ማዔሢ ቢያሢ ዔራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ኪሪስቶሴ ጉሙርቃ፥ ዓይሁዴ ማዒባኣ ዓሶ ዛሎ'' ጋዓንቴ ‹ሜሌ'' ካኣሺም ሹኪንቴ፥ ዒኢቴ ባኣዚ'' ሙዒፖቴ፤ ሱጉሢያ ዑሽኪፖቴ፤ ሱጉሢ ሾኦቲ ባኣንቴ ጩኡሊ''ንቲ ሓይቄ ቆልሞ ሙዒፖቴ፤ ማቾ ሓሣ ዓኒ ማዒባኣያና ላሂሢና ዬያጉዴ ባኣዚ'' ማዺፖቴ› ጋዓያ፥ ኑኡኒ ዎላ'' ጌስቲ ዔቂሴ ኪኢታ ዔያቶም ኑ ዳኬኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ዬካፓ ጳውሎሴ ዓሶንሢ ዔኪ ዚሮ ጉቴ''ሎ ዔያቶና ዎላ'' ዑፆ ጌኤሾ ዎጎ ኩንሤኔ፤ ጌኤሽኪንቶ ኬላ'' ዋኣዒ ማዓቴያ ሓሣ ፔቴ'' ፔቴ'' ዓሶ ዛሎ'' ፆኦሲም ዒንጎ ባካ ዒንጊንታሢ ዓይዲታቴያ ዔርዛኒ ጌኤዦ ማኣሪ ዒ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ላንካዎ ኬላ'' ጋፓኒ ዑካዛ ዒሲያ ዓጮ''ይዳፓ ሙኬ ዓይሁዶ ዓሳ ጳውሎሴ ጌኤዦ ማኣራ ዓኣንቴ ዛጋዖ፥ ዴራ'' ቢያ ዒዛይዳ ፑርታ ማሊሢና ዔቃንዳጉዲ ማሂ ዒዛ ዓርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ዬካፓ ዔያታ፦ «ዒስራዔኤሌ ዓሲዮቴ! ኑና ዓልቁዋቴ፤ ኑኡኮ ዴሮ''ንታ ሙሴ ዔርዜ ዎጎንታ ሓሣ ሓያ ጌኤዦ ማኣሮዋ ጫሽኪ ጫሽኪ ዓጮ'' ቢያይዳ ዓኣ ዴሮ'' ቢያ ዔርዛሢ ሓያ ዓሢኬ፤ ዬይ ዒዛም ጊዶ'' ዒፄም ዓይሁዴ ማዒባኣ ዓሶ ጌኤዦ ማኣሪ ጌልዚ ሓያ ፆኦሲም ዱማዼ ቤዞዋ ዒኢሳሢ ዒዛኬ» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ዬኖ ዔያቶ ጌይሴሢ ዬያኮ ቤርታ ዔፕሶኔ ዓጮ''ይዳ ሾይንቴ ፂሮፒሞሴ ጎዖሢ ጳውሎሴና ዎላ'' ካታሞይዳ ዓኣንቴ ዔያታ ዛጌሢሮ ዒዚ ዬያ ዔኪ ጌኤዦ ማኣሪ ጌሌያ ማሌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ዬያሮ ካታማ'' ቢያ ዎኦቶንዶ ጎይሢ ባይዜኔ፤ ዬማና ዴራ'' ቢያ ፔቱሞና ጳሽኪ ጳሽኪ ሙካዖ ጳውሎሴ ዓርቂ ጎቺ ጌኤዦ ማኣራፓ ኬሲ''፥ ጌኤዦ ማኣሮኮዋ ካሮ'' ዑኬና ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ዓሳ ጳውሎሴ ዎዻኒ ማላዛ፦ «ዬሩሳላሜ ካታማ'' ዎኦቶንዶ ጎይሢ ባይዜኔ» ጋዓ ኪኢታ ሮሜ ዓጮ''ኮ ፖኦሊሶ ዓይሣሢም ዋይዚንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ዬያሮ ዒዚ ዒዛኮ ካፓ ዓሶና ፄኤቶ ፖኦሊሶ ዓይሣ ዓሶዋ ፔኤና ዎላ'' ዔኪ ዑኬና ጳሽኪ ጳሽኪ ዓሶ ባንሢ ዴንዴኔ፤ ዓሳ ዬያ ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢንታ ኮራ ካፓ ዓሶዋ ዴንቃዖ ጳውሎሴ ጳርቂፆ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢ ጳውሎሴ ዓርቂ ላምዖ ካኒ ቢራታና ቱኪ''ንታንዳጉዲ ዓይሤኔ። ዬካፓ ዒዚ ዖናታቴያ ሓሣ ዓይጎ ማዼቴያ ዔራኒ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ዒማ''ና ዴራ'' ዱማ ዱማ ባኣዚ'' ጋዓያ ሓሣ ዒላታያ ማዔሢሮ ፖኦሊሶ ዓይሣሢ ፒዜ ጌኤዛ ዎኖታቴያ ዔራኒ ዳንዳዒባኣሴ፤ ዬያሮ ዔያታ ፖኦሊሳ ዓኣ ቤዞ ጳውሎሴ ዔውታንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ጳውሎሴ ኬኤሎ'' ዑፆ ኬስካዛ ዴራ'' ቢያ ሚርጌና ዻጋ ዔቂሲ ፑርታ ባኣዚ'' ማዻኒ ኮዔሢሮ ፖኦሊሳ ኬዲ ዔኪ ዒዛ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ዴራ'' ዒማ''ና፦ «ዒዛ ዎዎዹዋቴ» ጌዒ ጌዒ ዒላቲ''ና ዒዛኮ ጊንፆ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ፖኦሊሳ ፔኤኮ ዓኣ ቤዞ ዒዛ ዔኪ ጌልዛኒ ዑካኣና ጳውሎሴ ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢ ኮራ፦ «ፔቴ'' ባኣዚ'' ታ ኔኤም ኬኤዛንዳጉዲ ኔ ዓይሣንዳ?» ጌዒ ዖኦጫዛ፥ ዒዚያ ማሃዖ፦ «ኔኤኒ ጊሪኬ ዓጪ ሙኡቺ ዔራ? ");
INSERT INTO mdybse_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ሓሢ ዑኬ ካኣቲም ዋይዞ ዒፂ ዴሮ''ዋ ፑርቲሲ ሓሣ ዓሲ ዎዼ ዖይዶ ሺያ ዓሲያ ዔኪ ዓሲ ናንጉዋ ዳውሎ'' ፑኒንቴ፥ ጊብፄ ዓጮ'' ዓሢ ኔናቱዋዓዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ጳውሎሴ፦ «ታኣኒ ኪልቂያይዳ ኮሺ'' ዔርቴያ ማዔ፥ ፄርሴሴ ካታሜሎይዳ ሾይንቴ ዓይሁዴ ዓሲኬ፤ ሓዳራ ታኣኒ ዴሮ''ም ኬኤዞም ጌዔቴራ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ዬካፓ ዒዚ ኬኤዛንዳጉዲ ዓይሣዛ ጳውሎሴ ኬኤሎ''ይዳ ዔቂ ዴራ'' ዚቲዮ ጋዓንዳጉዲ ኩቺና ዻዌም ዴራ'' ዚቲዮ ጌዔስካፓ ዒብሬ ዓሶ ሙኡቺና ሂዚ ጌዒ ኬኤዚሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«ታ ዒሾንሦ፥ ታ ዓዶንሦ፤ ሓይሾ ሓሢ ታ ዒንሢም ኬኤዛ ባኮ ዋይዙዋቴ» ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ዒዚ ዒብሬ ዓሶ ሙኡጮና ጌስታሢ ዓሳ ዋይዛዖ ዎንዳስካፓ ባሼ ዚቲዮ ጌዔኔ፤ ዬካፓ ጳውሎሴ ፔኤኮ ጌኤዞ ጌስታዖ ሂዚ ጌዔኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«ታኣኒ ኪልቂያይዳ ዓኣ ፄርሴሴ ካታሞይዳ ሾይንቴያ ዓይሁዴ ዓሲኬ፤ ታኣኒ ዲጬሢያ ሓኖ' ዬሩሳላሜ ካታሞይዳኬ። ዓዶንሢ ዎጎ ኮሺ'' ታኣኒ ዔሪ ዓዳ'' ሃሢ ዒንሢ ማዻ ጎይፆ ዒናፓ ናሽኪ ፆኦሲም ታ ማዻያኬ፤ ታና ዔርዜሢያ ጌማሊያሌ ጎዖሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ሓኖ'፥ ጎዳ ጎይፆ ሓንታ ዓሶ ቢያ ታ ዳውሳያኬ፥ ዛሎ'' ታ ዎዺያ ዎዻኔ፤ ዓቲንቆንታ ላኣሎንታ ዓርቂ ዓርቂ ቱኡዞ ማኣራ ታ ቱኡሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ዬይ ጎኔ ማዒፆ ቄኤሶኮ ቢያ ሱኡጋሢና ዎጎ ዎጋ ዓሳ ቢያ ታኣም ማርካዻንዳኔ። ዬያ ሌሊቱዋንቴ ዴማስቆይዳ ዓኣ ዬኖ'ጉዴ ዓሶ ቱኪ'' ዬሩሳላሜ ዔኪ ሙኪ ሜታሳኒ ዳንዳዒሳ ፃኣፒንቴ ኪኢታ ዴማስቆይዳ ዓኣ ቢቶ'' ዓሶም ዒንጋኒ ታ ዔኬሢያ ቄኤሶ ቢያኮ ሱኡጋሢንታ ዬያቶ ዎጎ ዎጋ ዓሶንታፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«ዬያይዲ ዔኪ ታኣኒ ዴማስቆ ዴንዲ ካታሞኮ ዑካኣና ዓባ'' ሳዛ ጫርጌ ዎዶ''ይዳ ታ ዔሩዋንቴ ዼኤፒ ዓኣፒዳ ዱካ'' ፖዒ ታ ኮይላ'' ፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ዒማ''ና ታኣኒ ቶጊ ዓኣዻ ባካ''ፓ ሳዓ ሎኦሚ ‹ሳውሌ! ሳውሌ! ኔ ታና ዓይጋ ዳውሳይ?› ጋዓ ዑኡሲ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ታኣኒ ‹ጎዳሢዮ! ኔ ዖናዳይ?› ጌዔኔ፤ ዒዚያ ማሓዖ ‹ታኣኒ ኔ ታና ዳውሳ ናዚሬቶ ዬሱሴኬ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ታኣና ዎላ'' ዓኣ ዓሳ ፖዖ ዛጌያፓዓቴም ዒዚ ታኣና ዎላ'' ጌስታኣና ዎዚ ጌዔቴያ ዑኡዞ ዔያታ ዋይዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ታኣኒያ ‹ጎዳሢዮ! ታ ዓይጎ ዎዶ''ንዶይ?› ጋዓዛ፥ ጎዳሢ ታኣም ኬኤዛዖ ‹ሓሢ ዔቂጋፓ ዴማስቆ ዓኣዼ፤ ኔ ማዻንዳ ባካ ቢያ ዒኢካ ኔኤም ኬኤዚንታንዳኔ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ዓኣፓ ታኣኮ ፖዓ ዱኬሢሮ ዛጋኒ ዳንዳዒባኣያ ማዓዛ ታኣና ዎላ'' ዓኣ ዓሳ ኩጮ ታኣኮ ዓርቂ ጎቺ ታና ዴማስቆ ሄሊ''ሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«ዒኢካ ሓናኒያ ጌይንታ ፔቴ'' ዓሲስኬይ ዓኣኔ፤ ዬይ ዓሢ ዴማስቆይዳ ዓኣ ዓይሁዶ ዓሳ ቢያ ዒዛ ጋላታያ፥ ሙሴ ዎጎዋ ቦንቻ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ዒዚ ታ ኮራ ሙኪ ዓጫ ዔቃዖ፦ ‹ዒሻሢዮ ሳውሌ! ዓኣፓ ኔኤኮ ጊንሣ ዛጎንጎ› ጋዓዛ፥ ዬማና ኔጉዋዖ ዓኣፓ ታኣኮ ዛጌም ዒዛኣ ታ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ዒዚ ታኣም ‹ኑ ዓዶንሢ ፆኦዛሢ ኔ ዒዛኮ ማሊፆ ዔራንዳጉዲ፥ ፂላ''ሢያ ኔ ዛጋንዳጉዲና ዑኡዞዋ ኔ ዒዛኮ ዋይዛንዳጉዲ ቤርታዺ ኔና ዒ ዶኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ዬያ ዒዚ ማዼሢ' ኔ ዛጌ ባኮና ዋይዜ ባኮናኮ ዓሲ ቢያ ቤርቲዳ ዒዛኮ ኔ ማርካ ማዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ሂዳዖ ሓሢ ኔ ዓይጎሮ ናጋይ? ዔቂጋፓ ዋኣፆ ማስቴ፤ ጎዳ ሺኢቂ ጎሞይዳፓኣ ማስቲ ጌኤሽኬ› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«ዬካፓ ዬሩሳላሜ ማዒ ታ ሙኪ ጌኤዦ ማኣሮይዳ ሺኢቃኣና ፆኦሲ ፔጋሲ ዻዌ ባኣዚ'' ታ ዛጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ዬማና ጎዳሢ ታኣም ጴዺ ‹ኔኤኒ ታ ዛሎ''ና ኬኤዛ ማርካቶ ኔኤኮ ዔያታ ዔኪንዱዋኣሢሮ ኔጉዋዖ ሩኡሪና ዬሩሳላሜይዳፓ ኬስኬ!› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ታኣኒያ ‹ጎዳሢዮ! ዓይሁዴ ዓሶኮ ቡኪንቶ ቤዞ ዓኣዺ ዓኣዺ ኔና ጉሙርቃ ዓሶ ቢያ ታ ቱኬ''ሢና ጳርቄሢ ዔያታ ፔ ቶኦኪና ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ኔኤኮ ማርካ ማዔ ዒስፂፓኖሴ ዎዾዋኣና፥ ታኣኒያ ታ ቶኦኪና ዎዻ ዓሶ ዓጫ ዔቂ ዔያቶና ዎላ'' ዎዺፃ ቃራኬ ጌዔኔ፤ ዓፒሎዋ ታ ዔያቶኮ ካፔኔ፤› ");
INSERT INTO mdybse_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ጎዳሢ ጊንሣ ‹ሓኬ ዓኣ፥ ዓይሁዴ ማዒባኣ ዜርፆ ባንሢ ታ ኔና ዳካንዳሢሮ ዔቂ ዴንዴ› » ታኣም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ዬያ ሄላ''ንዳኣና ዴራ'' ቢያ ጳውሎሴኮ ጌኤዞ ዋይዛኔ፤ ዬማፓ ዓሳ ዑኡዞ ዼ'ግዲ፦ «ሓያጉዴ ዓሲ ሳዖይዳፓ ባይቆም! ሓያጉዴ ዓሲ ሼምፖና ናንጋኒያ ኮይሱዋሴ!» ጌዒ ጌዒ ዒላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ዒማ''ና ዔያታ ዒላቲ ዒላቲ ማኣዓሢ ፔኤኮ ኬሲ'' ዡጊ ዡጊ ዓጪያ ሳዓፓ ዔኪ ዔኪ ጫሪንጮ ባንሢ ላኣሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ፖኦሊሶ ዓይሣሢ ዬያ ዛጋዖ ጳውሎሴ ፖኦሊሳ ዓኣ ቤዞ ጌልዛንዳጉዲ ፖኦሊሶ ዓይሢ፥ ዴራ'' ዒዛይዳ ዓይጎሮ ሃያይዲ ዒላታቴያ ዔራኒ ጳርቂ ጳርቂ ዒዛ ዖኦጫንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ዒማ''ና ዒልዒዳፓ ፑኡሲንቴ ቃልሾና ፒሪ ቱኪ'' ጳርቃኒ ዔያታ ጊኢጋኣና ጳውሎሴ ዒዛ ኮራ ዔቂ ዓኣ ፄኤቶ ፖኦሊሶ ዓይሣሢ ኮራ፦ «ሮሜ ዓጪ ዓሲ ማዔያ ዎጊንቲባኣንቴ ጳርቃንዳጉዲ ዒንሢም ዓይሢንቲያ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ፄኤቶ ፖኦሊሶ ዓይሣሢ ዬያ ዋይዛዖ ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢ ባንሢ ዓኣዺ፦ «ኔኤኒ ዎዳ''ኒ ጋዓይ? ሓይ ዓሢ ሮሜ ዓጪ ዓሲኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ዬያሮ ፖኦሊሶ ዓይሣሢ ጳውሎሴ ባንሢ ዶጪጋፓ፦ «ሂንዳ ታኣም ኬኤዜ፤ ኔኤኒ ሮሜ ዓጪ ዓሲዳ?» ጋዓዛ፥ ዒዚያ፦ «ሂዮ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ፖኦሊሶ ዓይሣሢ፦ «ታኣኒ ዒዞ ዓጮ'' ዓሲ ማዓኒ ሚርጌ ሚኢሼ ጪጌኔ» ጋዓዛ፥ ጳውሎሴ ጊንሣ፦ «ታኣኒ ጋዓንቴ ሮሜ ዓጪ ዓሲ ማዒ ዒኢካ ሾሾይንቴያኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ዬያሮ ዒዛ ዖኦጫኒ ጊኢጊንቲ ዓኣ ዓሳ ኔጉዋዖ ዒዛ ኮራፓ ሺኢኬኔ፤ ፖኦሊሶ ዓይሣሢያ ሮሜ ዓጪ ዓሲ ማዔሢ ካኒ ቢራታና ቱኪ''ሴሢሮ ዒጊጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ዚሮ ጉቴ''ሎ ፖኦሊሶ ዓይሣሢ ዓይሁዶ ዓሳ ጳውሎሴ ዎጎና ዓይሢሳሢኮ ፒዜ ማዔ ካራ'' ዓይጎታቴያ ዔራኒ ኮዒ፥ ቄኤሶኮ ሱኡጎና ዎጎ ዎጋ ዓሶና ቢያ ቡኪንታንዳጉዲ ዓይሤኔ፤ ዬካፓ ጳውሎሴ ቱኪ''ንቴ ካኖ ቢራቶ ቡሊ''፥ ዔያቶ ቤርቶ ዒዛ ዒ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ዬካፓ ጳውሎሴ ዎጎ ዎጋ ዓሶ ጊዥ ጌዒ ዛጋዖ፦ «ዒሾንሢዮቴ! ሓኖ'' ሄላ''ንዳኣና ቢያ ዎዴ ፆኦሲ ቤርቶይዳ ታ ናንጌሢ ኮሺ ማሊሢናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ቄኤሶ ቢያኮ ሱኡጋሢ፥ ሓናኒያ ጋዓንቴ ጳውሎሴኮ ዻንጎ ባዓንዳጉዲ ኮራ ዔቂ ዓኣ ዓሶ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ዬማ''ና ጳውሎሴ ሃናኒያም፦ «ኔኤኒ ቦኦሪንታሢና ዑፃ ሜኤቺንቴ ኮጫሦ! ኔና ፆኦሲ ጳርቃንዳኔ፤ ዎጌ ጎይሢና ዎጋኒ ሓካ ኔ ዴዒ ዓኣዖ ዎጌባኣ ጎይሢና ታና ጳርቃንዳጉዲ ኔ ዓይሣ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ዒኢካ ዓኣ ዓሳ ጳውሎሴ ኮራ፦ «ቄኤሶ ቢያኮ ሱኡጋሢ ማዔ፥ ፆኦሲም ማዻሢ ኔ ጫጫሽካ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳውሎሴያ፦ «ዒሾንሢዮቴ! ቄኤሶኮ ቢያ ዒ ሱኡጌ ማዔሢ ታ ዔሪባኣሢሮኬ፤ ጌኤዦ ማፃኣፖይዳ ‹ኔ ዴሮ''ኮ ሱኡጋሢ ዑፆይዳ ፑርታ ጌኤሲ ጌስቲፖ› ጌይንቲ ፃኣፒንቴኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ጳውሎሴ ዒኢካ ዓኣ ዓሶይዳፓ ሄካሢ ፔርሴ ዓሲ፤ ዛላ'' ሶዶቄ ዓሲ ማዔሢ ዔራዖ፦ «ዒሾንሢዮቴ! ታኣኒ ፔርሴ ዓሶ ፃጳፓ ሾይንቴያ ፔርሴ ዓሲኬ፤ ሓይሾ ሓሢ ታኣኒ ዎጎ ዓሶ ቤርቶ ሺኢኬሢ ሓይቄ ዓሲ ዔቃንዳያታሢ ጉሙርቃሢሮኬ» ጌዒ ዑኡዞ ፔኤሲ'' ዼ'ጊዲ ዎጎ ዎጋ ዓሶ ባኣካ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ጳውሎሴያ ዬያ ኬኤዛዛ ፔርሴ ዓሶና ሶዶቄ ዓሶና ባኣካ'' ዣላ ማዢንቴም ዎጎ ዎጋ ዓሳ ላምዖ ፓቂንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ዓይጎሮ ጌዔቶ ሶዶቄ ዓሳ፦ «ሓይቢፓ ዔቂሢ ባኣሴ፤ ፆኦሲኮ ኪኢታንቻኣ ባኣሴ፤ ዓያናኣ ባኣሴ» ጋዓዛ፥ ፔርሴ ዓሳ ጋዓንቴ «ዬይ ባካ ቢያ ዓኣኔ» ጌዒ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ዬያሮ ዼኤፒ ዣላ ዔቄኔ፤ ፔርሴ ፃጳፓ ማዔ ፔቴ'' ፔቴ'' ሙሴ ዎጎ ዔርዛ ዓሳ ዔቃዖ፦ «ኑኡኒ ሓያ ዓሢዳ ፔቴታዖ ፑርታ ባኣዚ'' ዴንቂባኣሴ፤ ዓያና ሓሣ ፆኦሲኮ ኪኢታንቻ ዒዛም ኬኤዜያ ናንዳኔ ኑ ዓይጎ ዔራንዳይ?» ጌዒ ማርሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ዣላሢ ዶዲ ዶዲ ዴንዴሢሮ ዓሳ ጳውሎሴ ሾኦሊ ላኣሉዋጉዲ ፖኦሊሶ ዓይሣሢ ዒጊጫዖ፦ «ኬዲ'' ዓሶ ባኣካ''ፓ ጳውሎሴ ጎቺ ኬሲ'' ዔኪ ዬዒ፥ ፖኦሊሳ ዓኣ ቤዞ ዔኪ ዓኣዹዋቴ!» ጌዒ ፖኦሊሶ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ዬኖ ዋንቴሎ ጎዳሢ ጳውሎሴኮ ኮይሎ''ይዳ ዔቃዖ፦ «ዒጊጪፖ! ዬሩሳላሜይዳ ታኣም ኔ ማርካዼሢጉዲ ሓሣ ሮሜይዳኣ ኔ ታኣም ማርካዻንዳያ ኮይሳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ሳዓ ካራዛ ዓይሁዶ ዓሳ ቡኪንታዖ፦ «ጳውሎሴ ኑ ዎዹዋዖ ሙኡዚ''ያ ሙዒ ዑሽኮ ባኣዚ''ያ ዑሽካዓ» ጌዒ ጫኣቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ዬኖ ጌዒ ፑርቶ ማሊፆና ዎላ'' ዞርቴ ዓሶኮ ፓይዳ'' ዖይዲታሚ''ፓ ዑሣኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ዔያታ ቄኤሶኮ ሱኡጎና ጪሞና ኮራ ዓኣዻዖ፦ « ‹ጳውሎሴ ኑኡኒ ዎዹዋዖ ሙኡዚ'' ሙዒንዱዋሴ› ጌዒ ጫኣቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ዬያሮ ዒንሢ ዎጎ ዎጋ ዓሶና ዎላ'' ጌስታዖ፥ ኮሺ'' ዒንሢ ዖኦጫንዳ ባኣዚ'' ዓኣያ ማሊሲጋፓ፥ ጳውሎሴ ዒንሢም ዒዚ ዔኪ ዬዓንዳጉዲ ፖኦሊሶ ዓይሣሢ ዖኦጩዋቴ። ኑኡኒያ ዒዚ ሃካ ዒንሢ ቤርቶ ሄላ''ንዳሢኮ ቤርታ ዒዛ ዎዻኒ ጊኢጌኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ጋዓንቴ ጳውሎሴኮ ዔኤዚማቲ ማዓ፥ ናይስኬያ ዬኖ ፑርቶ ዞርቶና ማሊፄሎ ዋይዜሢሮ ፖኦሊሳ ዓኣ ቤዞ ዴንዲ ጌላዖ ሓይሶ ጳውሎሴም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳውሎሴያ ፄኤቶ ፄኤቶ ፖኦሊሶ ዓይሣዞንሢዳፓ ፔቴ''ሢ ዔኤላ''ዖ፦ «ሓይ ናዓሢ ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢም ኬኤዛ ባኣዚ'' ዓኣያታሢሮ ዒዛ ቤርቶ ሺኢሼ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ፄኤቶ ፖኦሊሶ ዓይሣሢ ናዓሢ ዔኪ ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢ ኮራ ጌላዖ፦ «ቱኡዞ ዓሢ፥ ጳውሎሴ፡ ሓይ ናዓሢ ኔኤም ኬኤዛ ባኣዚ'' ዓኣሢሮ ኔ ቤርቶ ዒዛ ሺኢሻንዳጉዲ ታና ሺኢቄኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢ ናዓሢኮ ኩጮ ዓርቂ ዶጪሳዖ፦ «ኔ ታኣም ኬኤዛ ባካ ዓይጎዳይ?» ጌዒ ዒዛ ዱማሲ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ናዓሢያ ዒዛም ኬኤዛዖ፦ «ዓይሁዶ ዓሳ ጳውሎሴ ዛሎ'' ባኮ ዶዲሺ ዖኦጫያ ማሊ ዚሮ ዎጎ ዎጋ ዓሶ ቤርቶ ኔ ዔያቶም ሺኢሻንዳጉዲ ኔና ዖኦጫኒ ዎላ'' ዞርቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ጋዓንቴ ኔ ዔያቶም ዔኤዒፖ፤ ዓይጎሮ ጌዔቶ ዔያታ ‹ዒዛ ኑ ዎዹዋዖ ሙኡዚ''ያ ሙዓዓ፥ ዑሽኮ ባኣዚ''ያ ዑሽካዓ› ጌዒ ዎላ'' ዞርቲ ጫኣቄ ዖይዲታሚ''ፓ ባሼ ዓሲ ዒዛ ዎዻኒ ካቲ'' ዓኣኔ፤ ሓሢ ዔያታ ካፓሢ ኔ ዑኡዞ ሌሊኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢያ፦ «ሓያ ኔ ታኣም ኬኤዜ ባኮ ሜሌ'' ዖኦማኣ ኬኤዚፖ» ጋዓዖ ናማሢ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ዬካፓ ሮሜ ዓጮ'' ፖኦሊሶ ዓይሣሢ ፄኤቶ ፄኤቶ ፖኦሊሶ ዓይሣዞንሢዳፓ ላምዖንሢ ዔኤላ''ዖ፦ «ዹሞኮ ዖኦሻ ዎዴ ማዓዛ ቂሳሪያ ዓጮ'' ዴንዳንዳ ላምዖ ፄኤታ ዱማ ዱማ ዖልዚ ዓሲ፥ ላንካይታሚ'' ፓሮና ዖላ ዓሲ ሃሣ ላምዖ ፄኤታ ዎርሢና ዖላ ዓሲ ጊኢጊሺ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ጊንሣ ጳውሎሴማኣ ፓሮ ጊኢጊሻዖ ዓጮ'' ዎይሣ ፒልኪሴ ባንሢ ኮሺና ሄሊ''ሱዋቴ» ጌዔኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ቃሲ'' ሓሣ ሂዚ ጋዓ ኪኢታ ዳኬኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«ቦንቺንታያና ዓጮ'' ዎይሣያና ማዔ ፒልኪሴም፤ ሓይ ኪኢታ ዳኪንቴሢ፦ ቄላውዲዎስ ሉሲያይዳፓኬ፤ ኔ ኮሺዳ? ");
INSERT INTO mdybse_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ሓያ ዓሢ ዓይሁዴ ዓሳ ዓርቂ ዎዻኒ ጋዓንቴ ዒዚ ሮሜ ዓጪ ዓሲ ማዔሢ ታ ዔሬሢሮ ታኣኮ ፖኦሊሶና ዎላ'' ታ ሙኪ ዒዛ ዻቂሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ዓይጎ ዛላና ዓሳ ዒዛ ዎጎና ዓይሢሳኒ ኮዔቴያ ዔራኒ ዔያቶኮ ዎጎ ዎጋ ዓሶ ቤርቶ ዒዛ ታ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ጋዓንቴ ዔያታ ዓይሢሳኒ ኮዓሢ ፔ ዎጎ ዛሎ'' ባኣዚ''ና ማዔሢ ታ ዔሬኔ፤ ሓሣ ሓያ ዓሢ ሃይቢና ቱኡሲናም ሄሊ''ሳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ሓያ ዓሢ ዎዺሢሮ ዒዛይዳ ፑርታ ማሊሢ ማሊንቴሢ ታ ዋይዛዖ ኔጉዋዖ ኔ ባንሢ ታ ዳኬኔ፤ ዎጎና ዓይሢሳኒያ ኮዓ ዓሳኣ ፔኤኮ ሓይሶ ኔ ቤርታ ሺኢሻንዳጉዲ ታ ዔያቶም ኬኤዜኔ።» ");
INSERT INTO mdybse_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ዬያሮ ዖሎ ዓሳ ዓይሢንቴ ጎይፆና ጳውሎሴ ዹማ ዔኪ፥ ዓንቲጳፂሪሴ ጌይንታ ዓጮ'' ሄሊ''ሴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ዚሮ ጉቴ''ሎ ፓራሢና ዎላ'' ዓኣ ዓሳ ጳውሎሴና ዎላ'' ዴንዳንዳጉዲ ማሃዖ፥ ዔያታ ጊንሣ ፔ ቤዞ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ፓራሢና ዓኣ ዓሳ ቂሳሪያ ሄላ''ዖ ዳኪንቴ ኪኢቶ'' ዓጮ'' ዎይሣሢም ዒንጊ፥ ጳውሎሴ ዒዛ ቤርቶ ዔኪ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ዓጮ'' ዎይሣሢ ኪኢቶ'' ዛጌስካፓ ጳውሎሴ ኮራ፦ «ኔ ዓጮ''ኮ ዎኖ ቤዛፓዳይ?» ጌዒ ዖኦጪ፥ ኪልቂያ ዓጪ ዓሲ ማዔሢ ዔራዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ኔና ዎጎና ዓይሢሳኒ ኮዓ ዓሳ ሙካዛ ታ ሓይሶ ዋይዛንዳኔ» ጌዒ፥ ካኣቲ ሄሮዲሴ ማዢሴ ማኣሮይዳ ዴይሢ ዒዛ ካፓንዳጉዲ ዓሶ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ዶንጎ ኬሊ''ኮ ጊንፃፓ ቄኤሶኮ ሱኡጋሢ ሓናኒያ ፔቴ'' ፔቴ'' ጪሚንታ ፄርፄሉሴ ጌይንታ ዎጌ ኮሺ'' ዔራያ፥ ዓሲ ዛላ ጌስታስኬያንታ ፔኤና ዔኪ ቂሳሪያ ዓጮ'' ዴንዴኔ፤ ዔያታ ዴንዲ ዓጮ'' ዎይሣ ፒልኪሴ ቤርቶ ሺኢኪ «ጳውሎሴ ዻቤኔ» ጋዓ ባኮ ዛሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ዬካፓ ጳውሎሴ ዔኤሊ''ንቲ ሙካዛ፥ ፄርፄሉሴ ሂዚ ጌዒ ኬኤዚፆ ዓርቄኔ፦ «ቦንቺንታ ፒልኪሴ! ኔ ዛሎ''ና ኑኡኒ ሚርጌ ኮሹሞ ዴንቄኔ፤ ኔኤኮ ኮዦ ዎይሢፆና ኑ ዴሮ''ም ላኣሚንቲሢያ ጴዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ዬኖ ኔኤኮ ኮዦ ማዾ'' ቢያ ቤዞና ቢያ ዎዶ''ናይዳ ኑ ዔኬሢ ዼኤፒ ቦንቾናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ሓሢ ጋዓንቴ ኔኤኮ ዎዶ'' ታ ጉሪ ኩርሱዋዖና ሃሣ ታ ኔና ጉሪ ላቢ''ሱዋዖ ቃሚሢና ታ ኔኤም ኬኤዛ ባኮ ሼሌዑሞና ኔ ዋይዛንዳጉዲ ታ ኔና ሺኢቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ሃይ ዓሢ ኑኡኮ ፑርታ ዶርዖ ማዔኔ፤ ዓጮ''' ቢያይዳ ዓኣ ዓይሁዶ ዓሶ ቢያሢዳ ዣሎ ዔቂሳኔ፤ ናዝራ ዓሶ ጌይንታ፥ ዱሙሞ ማዤ ዓሶኮዋ ዒዚ ዔኪ ዓኣዻሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ሓሣ ዒዚ ፆኦሲኮ ጌኤዦ ማኣሮ ዒኢሳኒ ጋዓንቴ ኑኡኒ ዓርቂ፥ ኑ ዎጎ ጎይፆና ዎጋኒ ማሌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ጋዓንቴ ፖኦሊሶ ዓይሣ ሉሲዮሴ ሙኪ ዼኤፒ ዎልቄና ኑ ኩጫፓ ዒዛ ቶሊ''ሲ ዔኪ፥ ዒዛ ዎጎና ዓይሢሳኒ ጋዓ ዓሶዋ ኔ ቤርቶ ሺኢኮንጎ ጌዒ ዓይሤኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ሃይ ኑኡኒ ዒዛይዳ ሺኢሻ ጌኤዛ ቢያ ጎኔ ማዒፆ ኔ ኔ ቶኦኪና ዖኦጪ ዔራኒ ዳንዳዓኔ» ጋዓዛ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ዓይሁዶ ዓሳ፦ «ዬይ ባካ ቢያ ጎኔኬ» ጌዒ ጌዒ ሶኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ዓጮ'' ዎይሣ፥ ፒልኪሴ ኩቻ ዻዊ ጳውሎሴ ጌስታንዳጉዲ ዓይሤኔ፤ ጳውሎሴያ ሂዚ ጌዒ ማሄኔ፦ «ሚርጌ ሌዔ ሓያ ዓጮ''ኮ ኔ ዎይሣያ ማዔሢ ታ ዔራሢሮ ታ ጊዳ'' ሺኢኬ ጌኤዞኮ ማሂፆ ኔኤም ኬኤዛሢ ዎዛናኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ዬሩሳላሜይዳ ታ ፆኦሲ ዚጊ ካኣሽካኒ ዓኣዼንቴ ታጶ ላምዖ ኬሊ''ዳፓ ባሺንዱዋኣሢ ኔ ኔ ቶኦኪና ዔራኒ ዳንዳዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ጌኤዦ ማኣሮይዳ ማዖም ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳ ሓሣ ካታሞይዳ ማዔቶዋ ዓይጎ ዓሲናታዖ ታ ማርማንቴ፥ ዴሮ''ዋ ዣሎም ታ ዔቂሳንቴ ዔያታ ታና ዴንቂባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ሓሢ ታ ጊዳ'' ሺኢኬ ጌኤዞኮ ቢያ ጎናሲሢ ማዓንዳ ማርካ ፔቴ''ታዖ ዔያታ ኔኤም ሺኢሻኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ጋዓንቴ ዬያ ታ ኔኤም ፔጋሲ ኬኤዛኒ ኮዓኔ፤ ዔያታ ‹ዒዚ ሉኡቂ ካኣሽካኔ› ጋዓ ጎይፆ ታኣኒ ኑ ዓዶንሢ ፆኦዛሢ ካኣሽካኔ፤ ጋዓንቴ ታኣኒ ሙሴ ዎጎና ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፖናይዳ ፃኣፒንቴ ባኮ ቢያ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ዔያታ ሃጊ ማዓንዳ ዎዞ'' ጌሣሢጉዲ ኮዦ ዓሶንታ ፑርቶ ዓሶንታ ሓይቢዳፓ ዔቃንዳሢ ታኣኒያ ፆኦሲና ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ዬያሮ ፆኦሲና ዓሲና ቤርቲዳ ጌኤሺ ዒና ታኣኮ ዓኣያ ማዓንዳጉዲ ቢያ ኬሊ'' ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«ዬሩሳላሜይዳፓ ታ ኬስኬንቴ ሚርጌ ሌዔ ዓኣዼሢኮ ጊንፃ ማንቆ ማዔ ታ ዓሶም ማዓንዳያ፥ ማኣዶ ሚኢሼና ሓሣ ፆኦሲም ዒንጊንታ ዒንጎ ባኣዚ'' ታኣኒ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ጌኤዦ ማኣሮይዳ ታና ዔያታ ዴንቄሢ ታ ዬያ ማዻንቴኬ፤ ዬማና ዑፆ ጌኤሺፆ ካኣዦ ዎጎ ታኣኒ ኩንሣኔ፤ ሓሣ ዒኢካ ታኣና ዎላ'' ሚርጌ ዴሬያ ባኣሴ፤ ዣላኣ ዔቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ጋዓንቴ ዒሲያ ዓጮ''ይዳፓ ሙኬ ፔቴ'' ፔቴ'' ዓይሁዴ ዓሲ ዒኢካ ዓኣኔ፤ ሂንዳ ዔያታ ታና ዎጎና ዓይሢሳኒ ጋዓ ካራ ዓኣቶ ኔ ቤርታ ሺኢኪ ኬኤዞንጎ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ጊንሣ ሓሣ ዎጎ ዎጋ ዓሶ ቤርቶይዳ ታ ሺኢካዖ ማዼ ዻቢንቲ ዓኣቶ ሓሢ ሃይካ ዓኣዞንሢ ኬኤዞንጎ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ጎኔና ታ ዔያቶ ባኣኮ''ይዳ ዔቂ ‹ሓይቄ ዓሲኮ ዔቂሢ ዓኣኔ› ጌይፆና ሓኖ'' ታኣኒ ዎጌም ዒንሢ ቤርቶ ሺኢኬኔ ጌዒ ዼ'ግ ጌዔ ዑኡሲና ታ ኬኤዜኔ፤ ዬማፓ ዓታዛ ሜሌ'' ታኣኒ ማዼ ባኣዚ'' ባኣሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ፒልኪሴ ጋዓንቴ ጎዳሢ ጎይፆ ዛሎ'' ሚርጌና ዔራያታሢሮ፦ «ፖኦሊሶ ዓይሣ፥ ሉሲዮሴ ሙካዛ ዒንሢ ጌኤዞ ጌስቲ ታ ኩንሣንዳኔ» ጌዒ ዔያቶ ዳካዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ጳውሎሴ ካፓ፥ ፄኤቶ ፖኦሊሶ ዓይሣሢም፦ «ፔቶዋ ዒዛ ቃዚ ሜታሱዋዖ ዛጊ ካፔ፤ ዒዛኮ ዒጊና ዒዛም ኮይሳ ባኮ ዔኪ ሙካኣና ላኣጊፖ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ዻካ'' ኬሊ''ኮ ጊንፃፓ ፒልኪሴ ዲሩሲላ ጌይንታ ዓይሁዴ ዓሲ ማዔያ ዒዛኮ ማቾስኬኖና ዎላ'' ሙኪ፥ ጳውሎሴ ዔኤሊ''ሴስካፓ ዬሱስ ኪሪስቶሴ ጉሙርቂሢ ዛላ ዒዚ ኬኤዛሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ፂሉ''ሞና፥ ዓሲ ፔና ዎይሣንዳ ዛላና ሓሣ ፆኦሲ ሃጊ ቢያሢዳ ዎጋንዳሢ ዛሎ'' ጳውሎሴ ኬኤዛዛ ፒልኪሴ ዒጊጫዖ፦ «ሓሢ ዴንዴ፤ ጊኢጌቴ ሜሌ'' ኬሊ''ና ታ ኔና ዔኤሊ''ሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ፒልኪሴ ጳውሎሴይዳፓ ሚኢሼ ዔካኒ ዎዛ ጌሢ፥ ሚርጌ ኬሊ'' ጳውሎሴ ዔኤሊ''ሲ ዔኤሊ''ሲ ጌስታኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ላምዖ ሌዔኮ ጊንፃፓ ጶርቂዮስ ፒስፆሴ ጎዖሢ ፒልኪሴ ቤዞ ጌሌኔ፤ ፒልኪሴያ ዓይሁዶ ዓሶ ዎዛሳኒ ጳውሎሴ ቱኪ''ንቴ ቤዛ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፒስፆሴ ፔኤኮ ዒ ዓጮ'' ዎይሣ ቤዞ ጌሊ ሓይሦ ኬሊ'' ዴዓዖ፥ ቂሳሪያይዳፓ ዬሩሳላሜ ዓኣዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","ዒኢካ ቄኤሶኮ ሱኡጎና ፔቴ'' ፔቴ'' ዓይሁዶ ዓሶኮ ዼኤፖና ጳውሎሴ ማዼ ባኮ ዛሎ'' ኬኤዛዖ፦ «ጳውሎሴ ሓካ ዬሩሳላሜ ዔኪ ኑም ዬዔቴራ» ጌዒ ዒዛ ኮራ ሚርጌና ሺኢቄኔ፤ ዬያ ዔያታ ጋዓኒ ዳንዳዔሢ' ጎይፃ ካቲ'' ጳውሎሴ ዎዻኒ ኮዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፒስፆሴ ጋዓንቴ፦ «ጳውሎሴ ቂሳሪያይዳ ቱኡዞ ማኣራ ቱኡቲ ካፒንቲ ዓኣኔ፤ ታኣኒያ ሓሣ ዑኬና ማዒ ዒኢካ ዓኣዻንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ዒንሢኮ ዎይሣ ዓሳ ታኣና ዎላ'' ቂሳሪያ ዓኣዺ፥ ጳውሎሴ ማዼ ዻቢንቲ ዓኣቴ ዒኢካ ዔያታ ዎጊሶንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፒስፆሴ ሳሊ''ዳፓ ዴንዲ ታጶ ኬሊ'' ሄላ''ንዳኣና ዔያቶና ዎላ'' ዴዔስካፓ ቂሳሪያ ዓጮ'' ዓኣዼኔ፤ ዒኢካ ዒዚ ሄላ''ዖ ዚሮ ጉቴ''ሎ ዎጎ ዎጎ ቤዞይዳ ዴዒ ዓሳ ዒዛም ጳውሎሴ ዔኪ ሺኢሻንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ዬካፓ ጳውሎሴ ሙካዛ ዬሩሳላሜይዳፓ ሙኬ ዓይሁዶ ዓሳ ዒዛኮ ዓጮ'' ማንጊ ዔቃዖ ዒዛ ላሣንዳ ማርካ ዴንቃኑዋያ ሚርጌ ዴኤሢ ሓይሴ ዒዛይዳ ሺኢሼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳውሎሴያ፦ «ታኣኒ ዓይሁዶ ዓሶኮ ዎጎይዳ ማዔቶዋ ጌኤዦ ማኣሮይዳ ሓሣ ሮሜ ዓጮ''ኮ ካኣቲ ዑፆይዳ ማዼ ዻቢንቲ ባኣሴ» ጌዒ ማሂ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ፒስፆሴ ጋዓንቴ ዓይሁዶ ዓሶ ዎዛሳኒ ኮዓዖ ጳውሎሴ ኮራ፦ «ዬሩሳላሜ ዓኣዺ ሓያ ባኮ ዛሎ'' ዒኢካ ታ ቤርታ ኔ ሞኦታኒ ዴንዲንዱዋይ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ጳውሎሴ ጋዓንቴ ሂዚ ጌዒ ማሄኔ፦ «ሓይሾ ታኣኒ ሞኦቲንታኒ ታና ኮይሳ፥ ሮሜ ዓጮ'' ካኣቲኮ ዎጎ ቤዛ ዔቄኔ፤ ኔኤኒ ኮሺ'' ዔራሢጉዲ ዓይሁዶ ዓሶይዳ ታኣኒ ፔቴ''ታዖ ማዼ ዻቢንቲ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ታኣኒ ዻቤያ ማዔቶ ሓሣ ሃይቢም ታና ዎጊሳ ዻቢንቲ ታ ማዼቶ ሃይቢፓ ዻቆም ታ ጎዑዋሴ፤ ጋዓንቴ ዔያቶኮ ጌኤዛ ጉሪ ባኣዚ'' ማዔቶ ዖኦኒያ ታና ዔያቶም ዓኣሢ ዒንጋኒ ዳንዳዑዋሴ፤ ታኣኒ ሓሢ ጌኤዛ ሮሜ ዓጮ'' ካኣቲ ቤርቶ ዓኣዻንዳጉዲ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ዒማ''ና ፒስፆሴ ዒዛና ዎላ'' ዞርቲ ማዻ ዓሶና ጌስታዖ፦ « ‹ሮሜ ዓጮ'' ካኣቲ ቤርቶ ታና ዳኬ› ጌዒ ኔ ዖኦጬሢሮ ካኣቲ ቤርቶ ኔ ዓኣዻንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ዻካ'' ኬሊ''ኮ ጊንፃ ካኣቲ ዓጊሪጳና ቤርኒቄና ፒስፆሴ ዛጋኒ ቂሳሪያ ዓጮ'' ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ዒኢካ ዔያታ ሚርጌ ኬሊ'' ዴዔሢሮ ፒስፆሴ ጳውሎሴ ዛሎ'' ባኮ ሂዚ ጌዒ ካኣቲ ዓጊሪጳም ፔጋሲ ኬኤዜኔ፦ «ፒልኪሴ ቤርታ፥ ዎዳ ቱኪ'' ሓሼ'' ፔቴ'' ዓሲ ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ታኣኒ ዬሩሳላሜ ዓኣዺ ዒኢካ ዓኣንቴ ቄኤሶኮ ሱኡጎና ዓይሁዶ ዓሶኮ ጪሞና ዬያ ዓሢ ዛሎ'' ታኣም ኬኤዜስካፓ ታ ዎጋንዳጉዲ ዔያታ ዖኦጬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ታኣኒ ጋዓንቴ ‹ዎጌም ሺኢኬ ዓሲ ሺኢሼ ዓሶ ቤርታ ዔቂ ዎጊሳ ሓይሶ ዛሎ'' ማሂ ኬኤዙዋንቴ ዎጊሳኒ ሺኢሼ ዓሶም ዓኣሢ ዒንጊሢ ሮሜ ዓጪ ዳምቤቱዋሴ› ጌዒ ዔያቶም ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ዬያሮ ዎጎም ሺኢሼ ዓሳ ቡኪንቲ ሃይካ ሙካዛ ኔጉዋዖ ዚሬሎ ዎጎ ዎጎ ቤዞይዳ ዴዒ፥ ጳውሎሴ ዓሳ ዔኪ ዬዓንዳጉዲ ታ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ዬካፓ ዎጎም ሺኢሼ ዓሳ ዒ ዻቤ ባኮ ኬኤዛኒ ዔቃዛ፦ ‹ፑርታ ባኣዚ'' ዒዚ ማዼያናንዳኔ› ጌዒ ታ ማሌጎይፆ ጉዴያ ዎጌም ሺኢሻንዳ ባኣዚ'' ፔቴ''ታዖ ዔያታ ሺኢሺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ጋዓንቴ ዒዛና ዎላ'' ዔያታ ማርማሢ ፔኤኮ ካኣዦ ዛሎ''ና ሃሣ ሃይቄያታንቴ፥ ጳውሎሴ ‹ሼምፔና ዓኣኔ› ጋዓ ዬሱሴና ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ታኣኒያ ዬያጉዴ ባኣዚ'' ዖኦጪፃ ታኣም ዴኤፄሢሮ ጳውሎሴ ኮራ፦ ‹ዬሩሳላሜ ዓኣዺ ዒኢካ ሓያ ባኮ ኔ ሞኦቲንታኒ ዴንዲንዱዋይ?› ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ዒዚ ጋዓንቴ ጌኤዛ ሮሜ ካኣቲ ባንሢ ዓኣዻንዳጉዲ ኮዒ ‹ካኣቲ ባንሢ ታና ዳኩዋቴ› ጌዔሢሮ ታ ዒዛ ዳካንዳያ ሄላ''ንዳኣና ቱኡዞ ማኣራ ዴዓንዳጉዲ ዓይሤኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ካኣታሢ ዓጊሪጳ ፒስፆሴ ኮራ፦ «ታኣኒያ ዬይ ዓሢ ጌስታ ሓይሶ ዋይዛኒ ኮዓኔ» ጌዔኔ። ፒስፆሴያ ዒዛም፦ «ሂዴቶ ዚሮ ኔ ዋይዛንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ዬያሮ ዚሮ ጉቴ''ሎ ዓጊሪጳና ቤርኒቄና ካኣቱሞ ዓፒሎ ማኣዒ፥ ዼኤፒ ዒጊቻ ቦንቺንቲና ፖኦሊሶኮ ሱኡጎና ሓሣ ካታሞይዳ ዓኣ ዼኤፖ ዓሶና ዎላ'' ዎጎ ዎጎ ዳልጎ ማኣሮ ጌላዛ ፒስፆሴ ጳውሎሴ ዒኢካ ዔኤሊ'' ዔኪ ሺኢሻዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","«ካኣታሦ ዓጊሪጳ! ሃሣ ዒንሢያ ቢያ ኑኡና ዎላ'' ዓኣ ዓሳ፤ ‹ሓይ ዓሢ ሃካፓ ሴካ ሼምፔና ናንጋንዳያ ኮይሱዋሴ› ጌዒ ዒላቲ ዬሩሳላሜይዳ ሓሣ ሃይካ ናንጋ ዓይሁዶ ዓሳ ታ ዎጋንዳጉዲ ታና ዔያታ ዖኦጬ ዓሢ ሃይ ዒንሢ ዛጋሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ታኣኒ ጋዓንቴ ሃይቢም ዎጊሳንዳ ዻቢንቲ ዒዛይዳ ፔቴ''ታዖ ዴንቂባኣሴ፤ ጋዓንቴ ዒዚ ሮሜ ዓጮ'' ካኣቲ ባንሢ ታና ዳኬ ጌዔሢሮ ዒኢካ ታ ዳካኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ያዺ ማዔቶዋ ዒዛ ዛሎ'' ሮሜ ዓጮ'' ካኣቲም ታ ፃኣፒ ዳካንዳ ዔርቴ ባኣዚ'' ባኣሴ፤ ዬያሮ ሓሢ ዒዚ ዖኦጪንቴስካፓ ታ ፃኣፓንዳ ባኣዚ'' ዴንቃንዳያናንዳኔ ጌዒ ዒንሢ ቤርቶ፥ ባሼና ሓሣ ካኣቲ ዓጊሪጳ! ኔ ቤርቶ ታ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ዓይጎሮ ጌዔቶ ቱኡሲ ዓሲ ሌካ ዼ'ጌ ቤሲ ዳኪንታኣና ዒዛ ዓይሤ ባኮ ዛሎ'' ፔጋሱዋዖ ሓሺ''ሢ ዔኤያቶ ታኣም ማሊ ጴዼኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ዓጊሪጳ ጳውሎሴም፦ «ኔኤኒ ኔ ዛሎ'' ኬኤዛኒ ዳንዳዓኔ» ጋዓዛ፥ ጳውሎሴ ቶኦኮ'' ሂርኪዴስካፓ ዔቂ ሂዚ ጌዒ ጌኤዞ ማሂፆ ሓይሶ ኬኤዜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ካኣታሦ ዓጊሪጳ! ዓይሁዶ ዓሳ ታና ዎጎና ዓይሢሳ ባኮ ዛሎ'' ቢያሮ ሃኖ'' ታ ኔ ቤርቶይዳ ጌኤዞ ማሂፆ ሓይሶ ኬኤዛሢ ኮሺ'' ዼኤፒ ዎዛናኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ዓይጎሮ ጌዔቶ ኔኤኒ ዓይሁዴ ዓሶ ዳምቦና ዔያቶኮ ማርማሢና ፔጋሲ ዔራያታሢሮ፥ ሼሌዔ ዒናና ዳንዳዒ ታ ጌኤዞ ኔ ዋይዛንዳጉዲ ታ ኔና ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«ናኣቶይዳፓ ዓርቃዖ ዎይቲ ታ ናንጌቶዋ ዓይሁዶ ዓሳ ዔራኔ፤ ቤርታፓ ዓርቃዖ ታ ዓጮ''ና ዬሩሳላሜናይዳ ታ ናንጌ ናንጎ ታኣሲ'' ዔያታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ሓሣ ዔያታ ፔ ቶኦኪና ማርካዻኒ ኮዔቶ ኑ ካኣዦይዳ ዎጎ ኮሺ'' ዶዲሺ ዓርቃያ ማዔ፥ ፔርሴ ዓሶ ዛላ'' ማዒ ታ ናንጌሢ ዓይፃፓ ዓርቃዖ ዔያታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ሓሢ ታ ሓካ ዎጎም ሺኢኬሢ ፆኦሲ ኑ ዓዶንሢም ጫኣቂ ዒንጌ፥ ሃጊ ማዓንዳ ዎዞ ጉሙርቃሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ዬኖ ሃጊ ማዓንዳ ዎዞ'' ሄላ''ኒ ታጶ ላምዖ ፃጳ ሮኦሪና ዋንቴና ፆኦሲ ካኣሽኪ ካኣሽኪ ካፔኔ፤ ካኣቲዮ! ታና ሃሢ ዓይሁዶ ዓሳ ዎጎና ዓይሢሳሢ ዬኖ ታ ጉሙርቃሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ሓይቄ ዓሶ ፆኦሲ ዔቂሳንዳያ ማዒፃ ዎይቲ ዒንሢ፥ ዓይሁዶ ዓሶም ጉሙርቂንቱዋያ ማዔይ? ");
INSERT INTO mdybse_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«ታኣኒ ታ ቶኦኪና ናዚሬቶ ዬሱሴኮ ሱ'ንፆ ዒፂ ማካንዳያ ኮይሳኔ ጌዒ ሚርጌ ባኣዚ'' ታ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ዬሩሳላሜይዳ ታ ማዼሢ ዬያኬ፤ ቄኤሶኮ ሱኡጎይዳፓ ታ ዔኬ ቢታንቶና ኪሪስቶሴ ጉሙርቃ ዓሶይዳፓ ሚርጌሢ ታ ቱኡሴኔ፤ ዔያቶ ዎዾዋኣና ዎዻ ዓሶኮ ማዻ'' ቃራኬ ታ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ሚርጌ ዎዴ ዓይሁዶ ዓሶኮ ቡኪንቶ ቤዞይዳ ዔያታ ሜታዻንዳጉዲና ጉሙርቂፆዋ ዔያታ ሓሻ''ንዳጉዲ ማሃኒ ታ ማሌኔ፤ ዔያቶ ዑፆይዳ ሚርጌና ዻጋዺ ሓሣ ሜሌ'' ሜሌ'' ካታሞይዳኣ ዓኣዺ ታ ዔያቶ ዳውሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«ዬኖ ዛሎ''ና ቄኤሶኮ ሱኡጎይዳፓ ጉቤ ማዔ ቢታንቶና ዓይሥሢና ዔኪ ዴማስቆ ታ ዴንዳንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ካኣቲዮ! ጎይፆይዳ ዓባ'' ሳዛ ጫርጋኣና ዓቢ ፖዒዳፓ ባሼ ፖዒ ታ ዛጌኔ፤ ዬይ ፖዓ ታናንታ ታኣና ዎላ'' ዓኣዻ ዓሶናኮ ኮይላ'' ጫሪንጫፓ ፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ዬማና ኑኡኒ ቢያሢ ሳዖይዳ ሎኦሚ ዓኣንቴ ዓይሁዴ ዓጪ ሙኡቺና ‹ሳውሌ! ሳውሌ! ኔ ታና ዓይጎሮ ዳውሳይ? ጌማይ ጫጮ ሚፆ ማሂ ዓኪ ማኣሳናያጉዲ ኔኤኒ ዬያ ዓጬ ሚፆ ማሂ ዓኪፆና ኔኤሮ ኔ ማኣሳናኔ› ጋዓ ዑኡሲ ታ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ታኣኒ ማሃዖ ‹ጎዳሢዮ፥ ኔኤኒ ዖናዳይ?› ጋዓዛ፥ ጎዳሢያ ታኣም ሂዚ ጌዔኔ፦ ‹ታኣኒ ኔ ታና ዳውሳ ዬሱሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ጋዓንቴ ሓሢ ዔቄ፤ ታ ኔኤም ሓሢ ፔጋዺ ጴዼሢ' ታና ኔ ዛጌ ጎይፆና፤ ሓሣ ሓጋ ሴካ ቤርታ ታ ኔኤም ዻዋንዳ ባኮንታሮ ቢያ ታኣም ኔ ማዻያና ማርካዻያ ማዓንዳጉዲ ታ ኔና ዶኦራኒ ኮዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ኔ ዓሶ ዒስራዔኤሌ ዴሮ''ንታ ታ ኔና ዳካ ዓይሁዴ ማዒባኣ ዓሶንታ ኩጫፓ ታ ኔና ዻቂሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ኔ ዔያቶኮ ዓኣፖ ቡላ''ንዳጉዲና ዹሞይዳፓ ፖዖ ኔ ዔያቶ ኬሳ''ንዳጉዲ ሓሣ ፃላሄ ዴማ''ፓ ፆኦሲ ባንሢ ኔ ዔያቶ ማሃንዳጉዲ ታ ኔና ማሃንዳኔ፤ ኔ ዬያይዴሢሮ ዔያታ ታና ጉሙርቂ ፔ ጎሞኮ ማኣሪንቲሢ ዴንቃንዳኔ፤ ፆኦሲ ዶኦሬዞንሢ ባኣኮ''ይዳ ዒንጊንቴ ቤዞዋ ዔያታ ዴንቃንዳኔ› » ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ጳውሎሴ ቃሲ'' ኬኤዛዖ፦ «ዬያሮ ካኣቲ ዓጊሪጳ! ጫሪንጫፓ ታኣም ዒንጊንቲ፥ ጴዼ ባኮም ታ ዓይሢንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ጋዓንቴ ቤርታዺ ዴማስቆይዳ ዓኣ ዓሶ፥ ሄሊ''ሲ ዬሩሳላሜና ዪሁዳ ዓጮ''ናይዳ ዓኣ ዓሶ ቢያሢና ሓሣ ዬያጉዲ ዓይሁዴ ማዒባኣ ዓሳኣ ጊዳ'' ጎሞ ቡኡፂ ፆኦሲ ባንሢ ሙካንዳጉዲ ታ ዔርዜኔ፤ ጎሞ ቡኡፂፆ ዔርዛ ባኣዚ''ያ ዔያታ ማዻንዳጉዲ ዔያቶም ታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ዬያይዳፓ ዔቄያና ዓይሁዶ ዓሳ ጌኤዦ ማኣሮይዳ ታ ዓኣንቴ ታና ዓርቂ ዎዻኒ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ታኣኒ ፆኦሲኮ ማኣዲ''ፃ ታ ጊዳ''ፓ ዱማዺባኣሢሮ ዓሲ ዱማሱዋዖ ቢያሢም ኬኤዚ ኬኤዚ ሓይማ ሄሌ''ኔ፤ ፆኦሲ ማሊፆ ኬኤዛ ዓሶንታ ሙሴንታ ቤርታዺ ሃጊ ‹ያዺ ማዓንዳኔ› ጌዔ ባኮ ታ ኬኤዜማፓ ሜሌ'' ፔቴ'' ባኣዚ''ታዖ ታ ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ዔያታ ኬኤዜሢ፦ ‹ሜሲሔ ሜቶ ዔካንዳኔ፤ ሓይቢፓ ዔቂሢና ቤርታሳያ ማዒ፥ ዒስራዔኤሌ ዴሮ''ና ዓይሁዴ ማዒባኣ ዓሶናም ዻቂንታኮ ፖዒ ዻዋንዳኔ ጌዒኬ› ጌዔኔ።» ");
INSERT INTO mdybse_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳውሎሴ ዬኖ ኬኤዛ ጎይሣ ዓኣንቴ ፒስፆሴ፦ «ጳውሎሴ! ዓካሪ ኔ ዣኣሽኬኔ፤ ሚርጌ ዔሪፃ ኔና ዣኣሹሞይዳ ጌልዜኔ!» ጌዒ ዼ'ግዲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ጳውሎሴ ጋዓንቴ ሂዚ ጌዒ ማሄኔ፦ «ቦንቺንታ ፒስፆሴ! ጎኔና ፒዜ ማዔ ባኣዚ'' ታ ኬኤዛፓዓቴም ታ ዣኣሽኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ታ ዒዛ ቤርቶይዳ ፔጋሲ ኬኤዜ፥ ካኣቲ ዓጊሪጳ ዬያ ዔራንዳኔ። ዬይ፦ ዓኣሺንቲባኣ ባኣዚ'' ማዔሢሮ ካኣታሢ ዔራንዳሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ካኣቲዮ ዓጊሪጳ! ኔኤኒ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ጉሙርቃያቱዋይ? ኔ ጉሙርቃሢያ ታ ዔራኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ዓጊሪጳ ጳውሎሴ ኮይላ''፦ «ኔኤኒ ሃይሾ ታና ሃይማካ ኪሪስቶሴ ጉሙርቃ ዓሲ ማሄኔ ጌይሢኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳውሎሴ ጊንሣ፦ «ዑኬ ዎዴያ ማዖም ዖዶሲ ዎዴ፤ ኔና ሌሊቱዋንቴ ሓኖ'' ሃያ ታኣኮ ጌኤዞ ዋይዛ ዓሳ ቢያ ሃይማ ታኣኮ ቱኡዞማፓ ዓታዛ ታጉዲ ማዖም ፆኦሲ ታ ሺኢቃኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ዬካፓ ካኣቲንታ ዓጮ'' ዎይሣሢንታ ቤርኒቄንታ ዒዛና ዎላ'' ዴዒ ዓኣ ዓሶንታ ቢያ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ዒማ''ና ኬስኪ ዔያታ ዴንዲፆይዳ ዓኣዖ፦ «ሃይ ዓሢ ሃይቃንዳጉዲና ቱኡታንዳጉዲ ዒዚ ማዼ ባኣዚ'' ፔቴ''ታዖ ባኣሴ» ዎሊ ኮይላ'' ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ሓሣ ዓጊሪጳ ፒስፆሴም፦ «ሃይ ዓሢ ዎንዴ ‹ሮሜ ካኣቲ ባንሢ ታና ዳኬ› ጌዒባኣቶ ቡሊ''ንታንዳያታንቴኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ዬካፓ ዋኣፆ ካኣሚሎና ዒፃሊያ ዓጮ'' ኑ ዓኣዻንዳጉዲ ጌይንታዛ ዔያታ ጳውሎሴንታ ሜሌ'' ቱኡሲ ዓሲንታ «ሮሜ ዓጮ'' ካኣቲኮ ፖኦሊሶ» ጌይንቲ ፓቂንቴ ዓሶ ዓይሣ ዓሶፓ ፔቴ''ሢ ማዔ፥ ዩሊዮሴ ጌይንታ ፄኤቶ ዓሶ ዓይሣሢም ዔኪ ዓኣዻንዳጉዲ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ዬማና ዒሲያ ዓጮ''ኮ ባዞ'' ዓጮይዳ ዓኣ ሳዖ ባንሢ ዓዲራሚፂዮኔ ጎዖ ቤዛፓ ዓኣዻ ዋኣፆ ካኣሚሎና ኑ ዴንዴኔ፤ ቴስሎንቄይዳ ናንጋ፥ ሜቄዶኒያ ዓጮ'' ዓሢ ዓሪስፂሮኮሴያ ኑኡና ዎላ'' ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ዚሬሎ ኑኡኒ ሲዶና ሄሌ''ኔ፤ ዩሊዮሴ ጳውሎሴም ኮሺ ማዔሢሮ ጳውሎሴ ፔኤኮ ላጎ ባንሢ ዴንዴም ዔያታ ዒዛም ኮይሳ ማኣዶ ማኣዳ''ንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ዬካፓ ኑ ዔቃኣና ዢባራ ኑኡኮ ቤርታ ዢባርሻያ ማዔሢሮ ቆጲሮሴ ጌይንታ ዋኣፆ ሳዛ'' ዓኣ ዓጬ''ሎና ካናዺ ኑ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ኪልቂያና ጲንፒሊያ ዓጮ'' ኮይሎ''ይዳ ዓኣ ባዞ''ና ፒንቄስካፓ ሉቂያ ዓጮ''ይዳ ዓኣ ሙራ ጌይንታ ካታማ ኑ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ዒዞ ቤዞይዳ ፄኤቶ ፖኦሊሶ ዓይሣሢ ዒፃሊያ ዓጪ ባንሢ ዒስኪንዲሪያ ጎዖ ቤዛፓ ዓኣዻ ዋኣሢ ካኣሚሌ ዴንቃዖ ዒዞ ኑና ቶጊሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ሚርጌ ኬሊ'' ታሢ ታሢ ኑ ዓኣዺ፥ ሚርጌ ሜቶና ቄኔዲዮሴ ካታሞ ኮይሎ ሄሌ''ኔ፤ ዢባራ ጋዓንቴ ቤርቲም ኑ ዴንዱዋጉዲ ኑና ላኣጌሢሮ ሲልሞና ጌይንታ ዋኣፆ ሳዞ'' ሶርቶሚ ጌሌ ሳዓኮ ኮይሊ''ና ጌዒ ዋኣፆ ሳዛ'' ዓኣ፥ ቄርፄሴና ካናዺ ኑ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ዬኖ ቤዞና ሚርጌ ሜታዺ፥ ባዞ''ኮ ዓጮማ ዓርቂ ኑ ዓኣዼስካፓ ላሲያ ካታሞ ኮይላ'' ዓኣ «ዢባሮና ጉዳሢና ዋኣፆ ካኣሚሎ ፑርቲሱዋ ኮሺ ቤሲ» ጌይንታ ቤዞ ኑ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ኑኡኮ ሃንቲፆይዳ ሌሊ ሚርጌ ዎዴ ጋፔሢሮና ሙኡዚ'' ሙዑዋዖ ሺኢቆ ዎዳ'' ዓኣዼሢሮ ሓሣ ዬኖ ዎዶ''ና ባዚ'' ጊዳ'' ዓኣዺሢ ኮሺ'' ፑርታሢሮ ዬማና ጳውሎሴ ዓሶም፦ ");
INSERT INTO mdybse_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«ዓሲዮቴ! ሓካፓ ሴካ ዓኣ ኑኡኮ ጎይፆይዳ ፑርታ ባኣዚ'' ዓኣሢ ታኣም ጴዻኔ፤ ዬይያኣ፦ ዋኣፆ ካኣሚሎይዳ ጫኣኒንቴ ባኮና ዋኣፆ ካኣሚሎናይዳ ሌሊቱዋንቴ ዓሲ ሼምፖይዳኣ ዼኤፒ ፑርታ ባኣዚ''ና ባይሲንታና ሄላ''ንዳኔ» ጌይ ላቲ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ፄኤቶ ፖኦሊሶ ዓይሣሢ ጋዓንቴ ጳውሎሴ ዞሮ''ይዳፓ ዋኣፆ ካኣሚሎ ዒሻሢና ዋኣፆ ካኣሚሎኮ ዓዳሢና ጋዓ ባኮ ባሼ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ዬና ባዞ'' ዓጮይዳ ዓኣ ሳዔላ ባርጊ ዎዴና ዒኢካ ዴዓኒ ጊኢጉዋያ ማዔሢሮ ሚርጌ ዓሳ፦ «ኑኡኒ ዴንዲጋፓ፥ ዳንዳዒንቴቶ ኬዶ'' ዛሎ''ኮ ዓባ'' ጌላ ባንፆና ሓሣ ዾኦሎ'' ዛሎ''ኮዋ ዓባ'' ጌላ ባንፆይዳ ዓኣ ፒንቄ ጌይንታ ቄርፄሴ ዓጮ''ኮ ዋኣፆ ካኣሚሎ ዔቂሶ ቤዞ ሄሊ'' ዒኢካ ባርጎ ዎዶ'' ኑ ዓኣሦም» ጌዒ ማሊሢ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ዓባ'' ኬስኪ ጌላ ዛሎ''ኮ ዾኦሎ'' ዛሎ'' ዢባራ ዻካ'' ዢባርሼም ዔያታ ዛጋዖ ዔያታ ማሌ ጎይፆ ማዔያ ዔያቶም ማላዛ ዋኣፆ ካኣሚሎ ዓርቂ ዔቂሳ ዓንጎ ኮንጮ ቱጊ ዓኣዺፆ ዔቄኔ፤ ዔያታ ዋኣፆ ካኣሚሎ ዔቂሶ ቤዛፓ ዔቂ ባዞ''ኮ ዓጮማ ዓርቂ ቄርፄሴኮ ኮይሊ''ና ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ጋዓንቴ ኔጉዋዖ «ኬዶ'' ዛሎ''ኮ ዓባ'' ኬስካ ባንፆ ዓልጋሢ» ጌይንታ ዶዲ ዓልጋ ዋኣፆ ሳዛ'' ዓኣ ሳዔሎይዳፓ ዔቂ ዔያቶይዳ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ዋኣፆ ካኣሚላ ሂዒንቴሢሮ ሓሣ ዢባሮዋ ቃዛኒ ዳንዳዒባኣሢሮ ዢባራ ኑና ዒሼም ዚቲዮ ጌዒ ኑ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ዬካፓ ቄዳ ጌይንታ ዋኣፆ ሳዛ'' ዓኣ ዻካ'' ዓጪስኬኖና ካናዺ ኑ ዴንዲቤቃ ዋኣፆ ካኣሚሎይዳ ቱኪ''ንቲ ዓኣ ዋኣፆና ፒንቆ ጎንጊስኬና ቶላ''ኒ ዑኬም ሜቶና ኑ ቃዛኒ ዳንዳዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ዋኣፆ ካኣሚሎይዳ ዓኣ ዓሳ ዋኣፆና ፒንቆ ጎንጌሎ ጎቺ ዔኪ ዋኣፆ ካኣሚሎ ጋሮ ጌልዜስካፓ ሱሲና ዶዲሺ ቱኬ''ኔ፤ ዋኣፆ ካኣሚላ ሓሣ ሱሪቲሴ ጌይንታ ዋኣፆ ዴማ'' ዓኣ፥ ኩሊንቴ ማኣሻላ'' ዴንዲ ዹዒንቱዋጉዲ ሻራሢ ጌይንታ ዳልጎ ዓፒሎጉዴ ባኮ ኬይሳዖ ኮዔ ጎይሢ ዓኣዻንዳጉዲ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ጋዓንቴ ዓልጋሢ ሓሾ'' ዒፄሢሮ ዚሬሎ ዋኣፆ ካኣሚሎ ዑፆይዳ ጫኣኒንቴ ሜሆ''ይዳፓ ዛሎ'' ባዞ''ይዳ ዓሳ ኬኤሪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ሓይሣሳ ኬሎ''ና ዋኣፆ ካኣሚሎም ኮይሳ ባኮዋ ዔኪ ዔኪ ፔ ኩቻ ዔያታ ኬኤሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ሚርጌ ኬሊ'' ዓቢንታ ዦኦጎንታ ኑ ዛጊባኣሢሮ ሓሣ ዓልጋሢ ዢባርሺፆ ሃሾ'' ዒፄሢሮ፦ «ኑ ዻቃኒ ዳንዳዑዋሴ» ኑ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ዓሳ ፔቴ''ታዖ ሙኡዚ'' ሙዑዋዖ ሚርጌ ኬሊ'' ዴዔሢሮ፥ ጳውሎሴ ዔያቶ ባኣካ'' ዔቃዖ፦ «ዓሲዮቴ! ዒንሢ ዎንዴ ታ ዒንሢም ጌዔ ባኮ ዋይዚ ቄርፄሴይዳፓ ዔቂባኣያታቶ ሓይ ዋኣፆ ካኣሚሎይዳ ማዔ ባካ ቢያ ዒንሢ ሄሊ''ንዱዋያታንቴኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ሓሢ ዋኣፆ ካኣሚላ ሌሊ ፑርታንዳኣፓዓቴም ዒንሢዳፓ ዖናይዳኣ ማዖም ባይሲንታ ሄሊ''ንዱዋሴ፤ ዬያሮ ዶዱዋቴ፥ ዒጊጪፖቴ፤ ጌዒ ታ ዒንሢ ዞራኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ታ ዒዛሮ ማዒ፥ ዒዛ ካኣሽካ ፆኦዛሢ ዳኬ ኪኢታንቻ ዋንቴ ታ ኮራ ዔቂ፦ ");
INSERT INTO mdybse_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹ጳውሎሴ ዒጊጪፖ! ኔኤኒ ሮሜ ዓጮ'' ካኣቲ ቤርታ ዔቃንዳያ ኮይሳኔ፤ ሓይሾ፥ ኔኤና ዎላ'' ዓኣዻ ዓሶ ቢያ ኔ ጋይቴ ጌዒ ፆኦሲ ሃይቢዳፓ ዻቂሻንዳኔ› ጌዒ ታኣም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ዬያሮ ዒንሢ ሓይ ዓሳ ዶዱዋቴ፤ ፆኦሲ ዬያ ታኣም ኬኤዜ ባኮ ቢያ ኩንሣንዳሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ማዔቶዋ ዢባራ ኑና ዔኪ ፔቴ'' ዋኣሢ ሳዛይዳ ዓኣ ሳዓኮ ዓቺዳ ኬኤራንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ታጶ ዖይዳሳ ዋንቶና ዓዲሪያ ባዞ''ይዳ ዢባሮና ሂዒንቲ ሴካ ሃንጋ ኑ ጌዒ ጌዒ ዓኣንቴ ሳዖኮ ጊዲሚሺ ማዓዛ ዋኣፆ ካኣሚሎይዳ ማዻ ዓሶ ኮራ ሳዖ ባንሢ ዑኬያ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ዬያሮ ባዞ''ኮ ዔታዺፆ ሚፂ'' ዛጎ ሱዞ ዔያታ ዓጋዛ፥ ባዞ''ኮ ዔታ'' ሳሊ''ታሚ'' ዋዻ ማዒ ጴዼኔ፤ ሓሣ ዻካ'' ናጋዖ ዛጎ ሱዜሎ ዔያታ ዓጌም ላሂ''ታሚ'' ዋዻ ማዒ ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ዋኣፆ ካኣሚላ ባዞ'' ዓጮይዳ ዓኣ ሹጫ ዓኣዺ ዹይንቱዋጉዲ ዔያታ ዒጊጪ፥ ዋኣፆ ካኣሚሎኮ ጊንፆ ዛሊ''ና ዋኣፆ ካኣሚሎ ቃዛንዳ ዖይዶ ዓንጎ ኮንጮ ሊካ ዓጊ፥ ዬካፓ ዹማ ካራንዳጉዲ ሺኢጲሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ዋኣፆ ካኣሚሎይዳ ማዻ ዓሳ ዋኣፆ ካኣሚሎይዳፓ ኬስኪ ዴንዳኒ ኮዔያታሢሮ ዋኣፆ ካኣሚሎኮ ቤርቶ ዛሎ''ና ዓንጎ ኮንጮ ሊካ ዓጋያ ማሊ ዋኣፆ ካኣሚሎይዳ ዓኣ ዋኣፆና ፒንቆ ጎንጌሎ ባዞ''ይዳ ኬኤሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ዬማና ጳውሎሴ ፄኤቶ ፖኦሊሶ ዓይሣሢና ፖኦሊሶና ኮይላ''፦ «ሓኣታ፥ ዋኣፆ ካኣሚሎይዳ ማዻ ዓሳ ዋኣሊ''ንቂፆ ሃሺ'' ዚቲ ጌዒ ዴዒባኣቶ ዒንሢ ዻቃኒ ዳንዳዑዋሴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ዬያሮ ፖኦሊሳ ዋኣፆና ፒንቆ ጎንጌሎኮ ሱዞ ቲቃዖ ዋኣፆይዳ ጉሪ ዒዛ ሴካ ሃንጋ ጋዓንዳጉዲ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ሳዓ ካራኒ ዑካዛ ቢያሢ ሙኡዚ'' ሙዓንዳጉዲ ጳውሎሴ ዔያቶ ሺኢቃዖ፦ «ፔቴ''ታዖ ሙኡዚ'' ሙዑዋዖ ዒንሢ ካፓንቴ ሓኖ'' ዒንሢኮ ታጶ ዖይዶ ኬሊ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ዬያሮ ዒንሢ ሙኡዚ'' ሙዓንዳጉዲ ታ ሺኢቃኔ፤ ዬይያ፦ ዒንሢም ዎልቄ ዶዲሻንዳኔ፤ ዓይጌንዴጉዴ ፑርታ ባኣዚ'' ፔቴ''ታዖ ዒንሢዳ ሄላ''ዓኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ዬያ ጌዔስካፓ ካሣ ዔኪ ቢያሢኮ ቤርታ ፆኦሲ ጋላታዖ፥ ቡንፂ ሙዒሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ዬማና ቢያሢኮ ዒና'' ማዔም ዶዲ ሙዖ ሙዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ዋኣፆ ካኣሚሎይዳ ኑኡኒ ዓኣ ዓሳ ቢያ ላምዖ ፄኤታና ላንካይታሚ'' ላሆ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ዬካፓ ቢያሢ ሙዒ ሚሽካዖ ዋኣፆ ካኣሚሎይዳ ጫኣኒንቴ ዛርጋሢ ባዞ''ይዳ ኬኤሪ ዋኣፆ ካኣሚሎ ዴኤፃ ባኮ ሼሌዒሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ዬማፓ ሳዓ ካራዛ ዔያታ ሄሌ'' ቤዞ ዔያታ ዔሪባኣሴ፤ ጋዓንቴ ማኣሻላ ዓኣ ባዚ'' ዓቺ ዔያታ ዴንቄኔ፤ ዬያሮ ዔያቶም ዳንዳዒንቴቶ ዒዞ ባንሢ ዶጪሳኒ ማላዖ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ዓርቄ ሱዞ ቲቂ ዓንጎ ኮንጮ ባዞ''ይዳ ሓሼ''ኔ፤ ዬማና ሓሣ ጊንፆ ዛላ'' ዓኣ፥ ዓጊሢ ዓጊሢ ዒሺ ዔኪ ዓኣዾ ዳልጎ ዖዶዞ ሚፆኮ ሱዞ ቡሊ''፥ ቤርቶ ዛሎ''ና ዓኣ ዳልጎ ሻራሢ ዢባሮ ባንሢ ዼ'ጊዲ ባዞ'' ዓጮ ባንሢ ኬስካኒ ዔያታ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ጋዓንቴ ዋኣፆ ካኣሚላ ዋኣፆ ዴማ'' ዓኣ ኩሊንቴ ማኣሻሎይዳ ዹዒንቲ ቤርቶ ዛሎ''ና ሊካ ዾቂንቲ ዓጊፁዋያ ማዓዛ፥ ጊንፆ ዛሎ''ና ጋዓንቴ ጉዳሢዳፓ ዔቄያና ካኣሚላ ሜቂሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ቱኡዞ ዓሳ ፁቢ ፒንቂ ቶሉ''ዋጉዲ ፒንቃኒ ጌዔቶ ዔያቶ ፖኦሊሳ ዎዻኒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ፄኤቶ ፖኦሊሶ ዓይሣሢ ጋዓንቴ ጳውሎሴ ዓውሳኒ ኮዔሢሮ ዬኖ ፖኦሊሶኮ ማሊፆ ዔኤዖ ዒፂ፥ ፁቢ ዔራ ዓሳ ቤርታዺ ዋኣፆ ካኣሚሎይዳፓ ባዞ''ይዳ ኮኦሚ ጌሊ ፁቢ ፁቢ ፒንቃንዳጉዲ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ሓሣ ዓቴ'' ዓሳ ዋኣፆ ካኣሚሎኮ ዱማ ዱማ ሜቂፆንታ ዳልጎ ላሻሢ ሚፆንታ ዓርቂ ዓርቂ ፒንቃንዳጉዲ ዓይሣዛ ዬያይዲ ቢያሢ ኮሺና ሳዖ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ዬካፓ ኑኡኒ ሳዖ ኮሺ ሄላ''ዖ ኑ ሄሌ'' ሳዔላ ማልታ ጌይንታያ፥ ዋኣሢ ሳዛይዳ ዓኣ ዓጪ ማዔሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ዬኖ ዋኣፆ ሳዛ'' ዓኣ ዓጬ''ሎይዳ ናንጋ ዓሳ ሚርጌና ሄርሺሳ ኮሺ ማዾ ኑኡም ማዼኔ፤ ዬማና ዒርዚ ዋርቃያታሢሮ ጪኢዦሮ ጌዒ ታሚ ዔኤሢ ኑና ዔያታ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳውሎሴ ዒማ''ና ሻርሻ ሃኣኪ ዔኪ ታሞይዳ ዓጋንቴ፥ ሉ ታሞኮ ዖይዾይዳፓ ዔቄያና ፔቴ'' ሾኦሺ ሻርሻፓ ኬስካዖ ኩጮ ዻይ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ማልታ ዓጬ''ሎይዳ ዓኣ ዓሳ ጳውሎሴኮ ኩጫ ሾኦዣ ዻይ ዓርቄሢ ዴንቃዖ፦ «ሓይ ዓሢ ጎኔና ዓሲ ዎዼ ዓሲኬ ጌይሢኬ! ዓይጎሮ ጌዔቶ ባዞ'' ጉዳሢዳፓ ኮሺና ቶሊ'' ኬስኬቶዋ ኑኡኒ ‹ፆኦሲ› ጌዒ ካኣሽካ ፒዜ ዎጋ ፆኦዛሢኮ ዎጊፆይዳፓ ቶሊ''፥ ናንጋኒ ዳንዳዒባኣሴ» ዎሊ ኮራ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ጳውሎሴ ጋዓንቴ ሾኦዣሢ ታሞይዳ ዉፁርቂ ዓጌኔ፤ ዒዛ ፔቴ''ታዖ ዎኦቴ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ዓሳ ጋዓንቴ፦ «ኔጉዋዖ ሓሢ ዑፃ ዒዛኮ ኪፃንዳኔ፤ ሓሣ ዒዚ ዔርቲባኣንቴ ሃይቃንዳኔ» ጌዒ ካፔኔ። ጋዓንቴ ሚርጌ ዎዴ ዔያታ ዬያይዲ ካፔም ፔቴ''ታዖ ዎኦቴ ባኣዚ'' ባኣያ ማዔሢ ዛጋዖ ማሊፆ ጊንፃ ላኣሚ፦ «ሓይ ዓሢ ፆኦሲኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ዬኖ ኑኡኒ ዓኣ ቤዜሎኮ ኮይሎይዳ ዋኣፆ ሳዛ'' ዓኣ ዓጬ''ሎ ዎይሣያ ማዔ፥ ፑፒሊዮሴ ጎዖሢኮ ሳዓ ዓኣኔ፤ ዬይ ዓሢ ፔ ማኣራ ኑና ዔኪ ሓይሦ ኬሊ'' ቃራሲ ሾኦቺንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ዬማ''ና ፑፒሊዮሴኮ ዓዴ ቆሢና ፂርሲ ዶርዖና ሓርጌም ላሂ ዓኣንቴ ጳውሎሴ ዒዛ ባንሢ ጌሊ ሺኢቂ ኩጮ ዑፃ ጌሢ ዓሢ ፖዒሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ዬይ ያዺ ማዔሢኮ ጊንፃ ዋኣፆ ሳዛ'' ዓኣ ዓጬ''ሎይዳ ናንጋ ሃርጊንቴ ዓሳኣ ሙኪ ፖዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ዓሳ ሚርጌ ኑኡም ዒንጎ ባኣዚ'' ዔኪ ሙኪ ኑና ቦንቻያ ማዒፆ ዔርዜኔ፤ ጊንሣ ዋኣፆ ካኣሚሎና ኑ ዓኣዻኒ ዔቃኣና ኑም ኮይሳ ባኮ ቢያ ዋኣፆ ካኣሚሎይዳ ዔያታ ጫኣኔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ሓይሦ ዓጊኒ ማልታይዳ ኑ ዴዔስካፓ ባርጎ ዎዶ'' ዒዞ ቤዞይዳ ዴዒ ዓኣሤ፥ ዒስኪንዲሪያ ዓጪሮ ማዔ ዋኣሢ ካኣሚሌ ቶጊ ዓኣዺፆ ኑ ዔቄኔ፤ ዋኣፆ ካኣሚሌሎኮ ሱ'ንፃ «ሜንቴ ማዔ ፆኦዞ''» ጌይንታያኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ሲራኩሴ ጌይንታ ካታሞ ኑ ሄላ''ዖ ዒኢካ ሓይሦ ኬሊ'' ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ዬካፓ ባዞ'' ጊዶ'' ኑ ሓንቲ ሬጊዩሜ ካታሞ ሄሊ'' ዒኢካ ፔቴ'' ኬሊ'' ኑ ዴዔስካፓ፥ ዾኦሎ'' ዛሎ'' ዢባራ ዢባርሼሢሮ ላምዓሳ ኬሎ''ና ፑቲዮላሴ ካታሞ ኑ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ዒዞ ቤዞይዳ ኪሪስቶሴ ጉሙርቃ ዓሶ ኑ ዴንቃዛ፥ ኑ ዔያቶና ዎላ'' ላንካይ ኬሊ'' ዴዓንዳጉዲ ዔያታ ሺኢቄም ዴዔስካፓ ሮሜ ዓጮ'' ኑ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ሮሜ ዓጮ''ይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሳ ኑ ዛሎ'' ዋይዛዖ ዓፒዮሴ ቦኦኮ'' ካሮ''፤ ሓሣ «ዎርቆ ቤሲ ሃይሦ» ጌይንታ ቤዞ ኑና ዔካኒ ሙኬኔ፤ ጳውሎሴያ ዔያቶ ዴንቃዖ ፆኦሲ ጋላቲ ዶዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ሮሜ ዓጮ'' ኑ ጌላዛ ጳውሎሴም ፔቴ'' ዒዛ ካፓንዳ ፖኦሊሴ ዒንጊንቴስካፓ ዒዚ ፔኤኮ ናንጋንዳጉዲ ዓይሢንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ሓይሦ ኬሊ''ኮ ጊንፃ ጳውሎሴ ሮሜ ዓጮ''ይዳ ናንጋ ዓይሁዶኮ ዼኤፖ ዼኤፖ ዓሶ ዔኤሊ''ሴኔ፤ ዔያታ ሙኪ ቡኬስካፓ ሂዚ ዔያቶም ጌዔኔ፦ «ዒሾንሢዮቴ! ዒስራዔኤሌ ዴሮ''ና ዓዶንሢ ዎጎናይዳ ታ ማዼ ዻቢንቲ ባኣዚ'' ፔቴ''ታዖ ባኣሴ፤ ጋዓንቴ ዬሩሳላሜይዳ ታኣኒ ቱኡቲ ሮሜ ዓጮ'' ዓሶም ታ ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ሮሜ ዓጮ'' ዓሳ ታና ዖኦጬስካፓ ሃይቢም ታና ዎጊሳንዳ ባኣዚ'' ዴንቂባኣሢሮ ጉሪ ታና ሓሻ''ኒ ማሌንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ዓይሁዶ ዓሳ ታኣኮ ጉሪ ሓሺ''ንቲፆ ዒፄም ሜሌ'' ታ ዎኦታንዳ ጎይሢ ባይቄሢሮ፦ ‹ሮሜ ካኣቲ ባንሢ ታና ዳኩዋቴ› ጌዒ ዖኦጫኒ ታ ዳንዳዔኔ፤ ማዔቶዋ ዴሮ'' ታኣኮ ታ፦ ‹ዎጌና ዓይሢሳንዳኔ› ጋዓ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ሃሢያ ታ ዒንሢ ዔኤሊ''ሴሢ' ታ ዒንሢ ዛጋኒና ዬያኣ ታ ዒንሢም ኬኤዛኒኬ፤ ታኣኒ ሃያ ካኖ ቢራቶና ቱኡቴሢ ዒስራዔኤሌም ዒንጊንቴ ሃጊ ማዓንዳ ዎዞ ዛሎ''ናኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ዔያታ ሂዚ ጌዒ ማሄኔ፦ «ዪሁዳ ዓጮ''ይዳፓ ኔ ዛሎ'' ባኣዚ'' ዳኪንቴ ኪኢታ ኑና ሄሊ''ባኣሴ፤ ሓሣ ሓካ ሙኬ ዓሶይዳፓ ፔቴ'' ዓሲታዖ ኔኤኮ ፑርቱሞ ሃይሳቲ ኬኤዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ኔኤኒ ሃኖ' ካኣሽካ ካኣዤሎ ዱማ ዱማ ቤዞይዳ ዓሳ ማኪ ዒፃያ ማዔሢ ኑ ዔራኔ፤ ዬያሮ ኔ ማሊፃ ሃሢ ዓይጎታቴያ ኑ ዔራኒ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ዬካፓ ዋይዞንዶ ኬሊ'' ጌሣዖ ሚርጌ ዓሲ ዒዚ ናንጋ ማኣሮ ሙካዛ፥ ዒዚያ ጉቴ''ይዳፓ ዴንዲ ዒባኒ'' ሄላ''ንዳኣና ፆኦሲ ካኣቱሞ ዛሎ'' ማርካዺ ማርካዺ ፔኤኮ ዓኣ ማሊፆ ዔያቶም ፔጋሴኔ፤ ሙሴ ዎጎና ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፖናይዳፓ ዔኪ ዔኪ ዬሱሴ ዛሎ'' ዔያቶም ኮሺ'' ዔርዚ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ፔቴ'' ፔቴ'' ዓሳ ዒዚ ኬኤዛ ቃኣሎ'' ጉሙርቄኔ፤ ሃንጎ ዓሳ ጋዓንቴ ጉሙርቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ዔያታ ሓሣ ማሊፆ ዎላ'' ፔቴ'' ማሂ ጊኢጉዋዖ ዱማዺ ዴንዴኔ። ጳውሎሴ ዒማ''ና ጋፒንሢ ሂዚ ጌዔኔ፤ ዓያኖ ጌኤዣ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዛሎ''ና ዒንሢኮ ዓዶንሢም ኬኤዜሢ ፒዜኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ዒዚያ ኬኤዜ ቃኣላ''፦ «ሓያ ዴሮ'' ባንሢ ዓኣዺጋፓ ‹ዋይዚ ዒንሢ ዋይዛኔ፤ ጋዓንቴ ዒንሢ ጶቂሱዋሴ፤ ዛጊ ዒንሢ ዛጋኔ፤ ጋዓንቴ ዒንሢ ዒና ዔኩዋሴ› ዔያቶም ጌዔ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ዓይጎሮ ጌዔቶ ሓያ ዓሶኮ ዒና'' ዶጬኔ፤ ዋያኣ ባይቄኔ፤ ዓኣፓኣ ዔያቶኮ ዱኡሚንቴኔ፤ ያዺ ዔያታ ዎንዴ ማዒባኣያታቴ ዓኣፖና ዔያታ ዛጊ ዋዮናኣ ዔያታ ዋይዚ ዒኖናኣ ሓሣ ጶቂሲ ታ ባንሢ ዔያታ ማዔም ታ ዔያቶ ዓውሴያናንዳኔ፤ ሂዚ ጋዓሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ዬያሮ ፆኦሲኮ ዻቂንቶ ኪኢታ'' ዓይሁዴ ማዒባኣ ዓሶም ዳኪንቴሢ ዔሩዋቴ፤ ዔያታ ናሽኪ ዔካንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳውሎሴ ዒዚ ሚኢሾ ጪጊ ጪጊ ዎርቃ ማኣሬሎይዳ ላምዖ ሌዔ ቢያ ዴዒ፥ ዒዛ ባንሢ ሙካ ዓሶ ቢያ ሾኦቺንሢ ዔካኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ፆኦሲኮ ካኣቱሞ ዛሎ''ዋ ኬኤዚ ኬኤዚ ሃሣ ጎዳ ዬሱስ ኪሪስቶሴ ዛሎ'' ዒዛ ላኣጋ ዓሲ ባኣያ ማዒ ጫርቂ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ዬሱስ ኪሪስቶሴም ማዻያ ማዔ፥ ፆኦሲ ማዾ''ም ዔኤሊ''ንቴ፥ ኮዦ ሓይሶ ቃኣሎ'' ኬኤዛኒ ዶኦሪንቴ፥ ጳውሎሴይዳፓ ዳኪንቴ ኪኢታ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ሃይ ኮዦ ሓይሶ ቃኣላ'' ፆኦሲ ፔ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ጌኤዦ ማፃኣፖይዳ ቤርታዺ ዒንጌ ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ኮዦ ሃይሳ' ፆኦሲ ናዓሢ ዓሲ ማዒ፥ ዳውቴ ዜርፆይዳፓ ሾይንቴሢ ኬኤዛያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ዬያጉዲ ሓሣ ጎዳ ዬሱስ ኪሪስቶሴ ጌኤዦ ዓያኖ ዛሎ''ና ዼኤፒ ዎልቄና ሓይባ''ፓ ዔቂፆና ፆኦሲ ናይ ማዔሢ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ዒዛ ዛሎ''ና ፆኦሲ ማዾ''ም ዳኪንቴያ ኑና ማሃኒ ዳንዳዒሳ ፆኦሲኮ ኮሹሞ ዒንጊፆ ኑ ዴንቄኔ፤ ዬያሮ ዒዛ ዛሎ''ና ዓይሁዴ ማዒባኣ ዓሳ ቢያ ኪሪስቶሴ ጉሙርቃንዳጉዲና ዒዛም ዓይሢንታንዳጉዲ ኑ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ዒንሢያ ዬሱስ ኪሪስቶሴሮ ማዓንዳጉዲ ፆኦሲ ዔኤሌ'' ዓሶ ባኣካ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ዬያሮ ሮሜ ዓጮ''ይዳ ናንጋያ፤ ሃሣ ፆኦሲ ዒንሢ ናሽኪ፥ ዒዛ ዓሲ ማዓንዳጉዲ ዔኤሌ''ዞንሢም ቢያ፦ ኑ ዓዳሢ ፆኦሲና ጎዳ ዬሱስ ኪሪስቶሴናኮ ሚጪንቲፆና ኮሹሞና ዒንሢም ማዖም። ");
INSERT INTO mdybse_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ዒንሢኮ ፆኦሲ ጉሙርቂፆ ሓይሳ ዓጮ'' ቢያይዳ ዋይዚንቴሢሮ ቢያፓ ቤርታሲ ዬሱስ ኪሪስቶሴ ዛሎ''ና ዒንሢ ቢያሢ ዛሎ''ሮ ታ ፆኦዛሢ ታኣኒ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ቢያ ኬሊ'' ታ ሺኢቃ ዎዶ''ና ዒንሢ ዛሎ'' ዋሉ''ዋያ ማዒፆኮ ዒዛ ናኣዚ'' ዛሎ'' ኮዦ ሓይሶ ቃኣሎ'' ኬኤዚ ኬኤዚ ጉቤ ዒናፓ ታ ዒዛም ማዻ ፆኦዛሢ ታኣኮ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ፆኦሲ ጌዔቴ ጋፒንፃ ሓሢ ዒንሢ ኮራ ታ ሙካንዳ ጎይሢ ዒ ጊኢጊሻንዳጉዲ ቢያ ኬሊ'' ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ዓይጎሮ ጌዔቴ ዒንሢ ፆኦሲ ጉሙርቂፆና ዶዳንዳጉዲ ማሃ ዓያኖ ዒንጊፆ ታ ዒንሢም ኬኤዛኒ ኮዓሢሮ ታ ዒንሢ ዛጋኒ ኮሺ'' ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ዬያ ታ ጋዓሢ ታኣኒ ዒንሢ ጉሙርቂፆ ዛሎ''ና ዒንሢያ ታ ጉሙርቂፆ ዛሎ''ና ዎሊ ኑ ዶዲሻኒ ኮዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ታ ዒሾንሦ! ታ ሚሾንሦ! ሜሌ'' ዓይሁዴ ማዒባኣ ዓሶ ታ ዔርዚ ሚርጌ ኪሪስቶሴ ጉሙርቃ ዓሲ ዴንቄኔ፤ ዬያጉዲ ሃሣ ዒንሢ ባኣኮ''ይዳኣ ታ ዔርዚ ኪሪስቶሴ ጉሙርቃ ዓሲ ዴንቃኒ ማሌኔ፤ ጋዓንቴ ዒንሢ ባንሢ ሙካኒ ሚርጌና ታ ማሌም ሓኖ'' ሄላ''ንዳኣና ታኣም ጊኢጊባኣሢ ዒንሢ ዔራንዳጉዲ ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ጊሪኮ ዓጮ'' ናንጎና ሙኡጮና ዔራ ዓሶና ዔሩዋ ዓሶናም፥ ጪንጮ ዓሶና ቦኦዞ ዓሶናም ኮዦ ሓይሶ ዔርዛንዳያ ታና ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ዬያሮኬ ዒንሢ፥ ሮሜይዳ ናንጋዞንሢም ኮዦ ሓይሶ ኬኤዛኒ ታ ኮዓሢ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ታኣኒ ኮዦ ሓይሶ ቃኣሎ'' ኬኤዛኒ ቦርሲንቱዋሴ፤ ዓይጎሮ ጌዔቶ ኮዦ ሓይሶ ቃኣላ'' ቤርታዺ ዓይሁዴ ዓሶ፥ ሄሊ''ሳዖ ዓይሁዴ ማዒባኣ ዓሶ፤ ጌይፃ፦ ጉሙርቃ ዓሶ ቢያ ዻቂሻኒ ዳንዳዓ ፆኦሲ ዎልቄኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ዬይ ኮዦ ሃይሶ ቃኣላ'' ፆኦሲ' ዓሲ ፂሎ'' ማሂ ዛጋሢ ኪሪስቶሴ ጉሙርቄቶ ሌሊ ማዔሢ ኬኤዛኔ፤ ዓይጎሮ ጌዔቴ፦ «ፆኦሲ ጉሙርቃ ዓሲ ፆኦሲ' ፂሎ'' ማሂ ዛጋኔ፤ ናንጊያ ዴንቃንዳኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ዓሳ ፔኤኮ ፑርቱሞና ጎኑሞ ፔጋዺ ዔርቱዋጉዲ ማሃኔ፤ ዬያሮ ዔያቶኮ ጎሞና ፑርቱሞና ዛሎ''ሮ ፆኦሲኮ ጎሪ''ንታ ጫሪንጫፓ ዔያቶይዳ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ፆኦሲ ዔያቶ ሜቶና ጎራ''ሢ' ፆኦሲ ዛሎ'' ዔያታ ዔራኒ ኮይሳ ባኮ ዒ ዔያቶ ፔኤሮ ዔርዜም ዔያታ ዔራያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ዓጫ'' ማዢንቴሢዳፓ ዓርቃዖ ዓሲም ጴዹዋ፥ ፆኦሲ ባካ፤ ጌይፃ፦ ናንጊና ናንጋ ዒዛኮ ዎልቆና ፆኦሱሞና ዒ ማዤ ባኮይዳ ፔጋዺ ጴዼኔ፤ ዬያሮ ዬኖ ዓሶጉዲ ዔሬዖ ፑርቲሳዞንሢ ቶላ''ኒ ጌስታንዳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ዓይጎሮ ጌዔቴ ዔያታ ፆኦሲ ዔሬያታዖ ዒዛም ኮይሳ ቦንቾና ጋላታና ዒንጊባኣሴ፤ ዬያሮ ዔያታ ፔኤኮ ማሊፆና ፓሡዋ ዓሲ ማዔኔ፤ ሓሣ ጶቂሡዋያ ማዒ ዒና'' ዔያቶኮ ባይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ዔያታ «ኑ ጪንጫ ዓሲኬ» ጋዓኔ፤ ታንቴ ዔያታ ዔኤያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ናንጊና ናንጋ ፆኦዛሢ ካኣሽኪፆ ሃሺ'' ላኣሚንታያና ባይቃያ ማዔ፥ ዓሲንታ ካፒንታ ቆልሞንታ ሳዓይዳ ዳዲና ሃንታ ባኮ ማሊሲ ማዦና ካኣሽኮ ባኣዚ'' ዔያታ ካኣሽኪሢ ዓርቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ዬያሮ ፆኦሲ፡ ቦርሲሳ ባኣዚ'' ዔያታ ማዻንዳጉዲ ዒኢሳ ፑርታ ባኣዚ'' ኩሜ ዔያቶ ማሊፆ ዔያታ ኩንሣንዳጉዲ ዔያቶ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ዬይ ያዺ ማዔሢ ፆኦሲኮ ጎኑሞ ሉኡዙሞና ዔያታ ላኣሜሢሮ፥ ማዤሢ ዓኣንቴ ማዢንቴ ባኮ ዔያታ ካኣሽኪ፥ ዬያ ባኮም ማዻሢሮኬ፤ ፆኦሲ ጋዓንቴ ናንጊና ጋላቲንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ዓሳ ዬያ ማዼሢሮ ፆኦሲ' ዓሶ ኮይሱዋ ቦርሲሳ ሱኡኬም ዓኣሢ ዒንጌኔ፤ ዔያቶኮ ላኣላታዖ ዔርቴ ጎይፆጉዲቱዋንቴ ዳምቤባኣ ጎይሢ ላኣሊና ላሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ዬያጉዲ ሃሣ ዓቲንቃ ላኣሎና ላሂፆ ሃሺ''፥ ዎላ'' ላሃኒ ኮዒሢና ዓቲንቃ ዓቲንቆና ዎላ'' ቦርሲሳ ባኣዚ'' ማዼኔ፤ ዬያሮ ዔያቶኮ ዻቢንቶ ዛሎ''ና ዔያቶም ኮይሳ ሜቶ'' ፔጊዳ ዔያታ ዔኪ ዬዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ዓሳ ፆኦሲ ዔራኒ ኮዒባኣሢሮ ቦርሲሳ ባኣዚ'' ማዻንዳጉዲ ፆኦሲ ፓሡዋ ማሊሢም ዓኣሢ ዔያቶ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ዬያሮ ጌኔ ማዾ፥ ፑርቱሞ፥ ዱኡዹሞ፥ ኮሜ ዓርቂሢ፥ ቂኢሩሞ፥ ዓሲ ዎዺሢ፥ ዑራ፥ ጌሺሢ፥ ፑርታ ማሊሢ ዔያቶይዳ ኩሜኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ዬያጉዲ ሃሣ ዔያታ ዾንካያ፥ ዓሲ ሱ'ንሢ ባይዛያ፥ ፆኦሲ ዒፃያ፥ ዓሲ ቦሃያ፥ ዖቶርቃያ፥ ሄርሺንታያ፥ ፑርታ ባኣዚ'' ማዾንዶ ጎይሢ ኮዓያ፥ ሾዔ ዓሶም ዓይሢንቱዋያ፥ ");
INSERT INTO mdybse_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ጶቂሡዋያ፥ ጌስቲ ቱኮ''ና ጌኤዞ ካፑዋያ፥ ናሹሞ ባኣያ፥ ሚጪንቲሢያ ባኣ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","«ዬንሢ ማዻዞንሢም ቢያ ሃይቢ ኮይሳኔ» ጋዓ ፆኦሲኮ ዎጎ ዔራያታዖ ዬያ ቢያ ዔያታ ማዻኔ፤ ማዾ'' ሌሊቱዋንቴ ዬያጉዲ ማዻ ዓሶዋ ዔያታ ማዻንዳጉዲ ዶዲሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ሜሌ'' ዓሲ ዑስካ ኮይሱዋ ጎይሢ ዎጋሦ! ኔ ቶኦኪና ኔ ኬኤዚ ቶላ''ንዳ ጎይሢ ኔኤኮ ባኣሢ ዔሬ፤ ዎይቲ ጌዔቴ ኔኤኒ ዓሶይዳ ዎጋያታዖ ዬይ ኔ ዎጋ ዓሢ ማዻማ ኔ ማዻኔ፤ ዬያሮ ሜሌ''ሢ ዑፃ ኔ ዎጋ ዎዶ''ና ኔ ቶኦካ'' ኔ ዎጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ዬያ ማዾ'' ማዻ ዓሶ ዑፆይዳ ፆኦሲ ዔያቶም ኮይሳ ዎጌ ዎጋንዳሢ ኑ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ሃይ ዓሢ ኔ! ዬያይዲ ማዻ ዓሶ ዑፃ ኔ ዎጋያታዖ፥ ዔያታ ማዻ ባኮ ኔ ማዻያታቴ ፆኦሲኮ ዎጋፓ ኔ ቶላ''ንዳያ ኔኤም ማላ? ");
INSERT INTO mdybse_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ሓሣ ፆኦሲኮ ኮሹሞና ጊቢ'' ዳንዳዒፆናኮ ሚርጊፆ ኔ ቦሃ? ፆኦሲ ኔኤም ኮሹሞና ማሌሢ' ኔና ጎሞይዳፓ ፔ ባንሢ ማሃኒታሢ ኔ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ዓካሪ ኔኤኒ ጎሞ ቡኡፆ ዒፃያ ማዔሢሮ ፆኦሲኮ ጎሪ''ንቶና ፂሎ'' ዎጎና ፔጋዻ ዎዶ''ና ሜታ ኔ ጊዳ'' ሃቺም ዺባንዳጉዲ ኔ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ዓይጎሮ ጌዔቴ ፆኦሲ ፔቴ'' ፔቴ''ሢም ፔኤኮ ማዾ''ጉዴያ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ኮሺ ማዾ ዶዲ ማዺ ጋላታና ቦንቾና ሓሣ ባይቁዋ ናንጊያ ኮዓዞንሢም ናንጊና ጋፑዋ ናንጊ ፆኦሲ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ጋዓንቴ ፔኤም ማዓ ባኣዚ'' ኮዓያ፥ ሃሣ ጎኑሞ ሃሺ'' ፑርታ ማዻዞንሢዳ ፆኦሲፓ ፑርታ ዎጌና ጎሪ''ንቲና ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ፑርታ ማዻ ዓይጎ ዓሲዳ ማዖም ሜቶና ዋኣዮና ሄላ''ንዳኔ፤ ዬይያ፦ ቤርታዺ ዓይሁዴ ዓሶይዳ ዬካፓ ዓይሁዴ ማዒባኣ ዓሶይዳ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ጋዓንቴ ዓይሁዴ ዓሲ ማዔቴያ ዓይሁዴ ማዒባኣያታዖ ኮሺ ባኣዚ'' ማዻ ዓሲም ቢያ ጋላታና ቦንቾና ሃሣ ኮሹሞዋ ዒንጊንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ዎይቲ ጌዔቴ ፆኦሲ ዓሲ ዱማሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ሙሴ ዔርዜ ዎጎ ዔሩዋያታቴያ ጎሜ ማዻ ዓሳ ቢያ ዔያታ ማዼ ፑርቶ ማዾ'' ዛሎ''ና ባይቃንዳኔ፤ ዬያ ዎጎ ዔራያታዖ ጎሜ ማዼሢ ዬያ ዎጎ ጎይፆና ኮይሳ ሜቶ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ዓይጎሮ ጌዔቴ ፆኦሲ ቤርቲዳ ፂሎ'' ማዓዞንሢ ዎጎ ካፓዞንሢኬ፤ ዋይዛዖ ካፑዋዞንሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ሙሴ ዔርዜ ዎጎ ዔሩዋ ዓይሁዴ ማዒባኣ ዓሳ ዔያቶኮ ናንጎ ዎጋ'' ዓይሣ ባኮ ማዻኔ፤ ዬያሮ ሙሴ ዔርዜ ዎጎ ዔያታ ዔሩዋቴያ ዔያቶኮ ናንጎ ዎጌ ዓኣሢሮ ዔያታ ማዾንዶ ባኮ ዔዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ሓሣ ዔያቶኮ ዒና'' ዔያቶም ማርካዻኔ፤ ዎይቲ ጌዔቴ ዔያቶኮ ዒና'' ፔቴ'' ፔቴ''ና ዔያታ ማዻ ባካ ፑርታ ማዒፆ፥ ፔቴ'' ፔቴ''ና ሃሣ ኮሺ ማዒፆ ዔያቶም ዔርዛኔ፤ ዬያይዲ ዔያታ ማዻሢሮ ሙሴ ዔርዜ ዎጋ ዓይሣ ባካ ቢያ ዔያቶኮ ዒና'' ፃኣፒንቲ ዓኣሢ ዔርታኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ዬይ ያዺ ማዓንዳሢ' ሃሢ ታኣኒ ኮዦ ሃይሶ ቃኣሎ'' ዛሎ''ና ኬኤዚ፥ ዔርዛሢ ጎይፆ ዓሳ ማዼ ዓኣሺንቴ ባኮይዳ ዬሱስ ኪሪስቶሴ ዛሎ''ና ፆኦሲ ዎጋ ኬሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ሓይሾ ኔኤኒ ኔና፦ «ታኣኒ ዓይሁዴ ዓሲኬ» ጌዒ ሙሴ ዔርዜ ዎጎ ጉሙርቃያ ሃሣ፦ «ታ ፆኦሲ ዓሲኬ» ጌዒ ኔ ሄርሺንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ኔኤኒ ፆኦሲ ማሊፆ ዔራያ፥ ሙሴ ዔርዜ ዎጋ'' ጋዓሢያ ዔራሢሮ ኮሺ ማዾ ኔ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ኔኤኒ ሃሣ፦ «ዓኣፖ ባይቄ ዓሶ ታ ዔኪ ዓኣዻያ፥ ዹሞይዳ ዓኣ ዓሶኮዋ ታ ፖዒኬ» ኔ ኔና ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ዬያጉዲ ሃሣ ኔ፦ «ዔሪባኣ ዓሶ ታ ዔርዛያኬ፤ ናኣቶ'' ታ ዔርዛያኬ» ጋዓኔ፤ ጊንሣ ሃሣ፦ «ዎጎንታ ዎጎኮ ጎኑሞ ሚርጌና ታ ዔራያኬ» ኔ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ዓካሪ ሜሌ'' ዓሶ ኔ ዔርዛያ ማዓዖ፥ ኔና ኔ ዔርዙዋዓዳ? «ውኡቂፖቴ» ኔ ጋዓኔ፤ ጋዓንቴ ኔ ኔኤሮ ዉዉኡቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ጊንሣ «ዓኒ ሃሣ ማቾ ማዒባኣያና ላሂፖቴ» ኔ ጋዓኔ፤ ጋዓንቴ ዬያ ኔ ማማዻኔ፤ ሜሌ'' ካኣሽኮ ባኮ ኔ ሻሻኣኪንታኔ፤ ጋዓንቴ ዬያ ካኣዦ ማኣራ ዓኣ ባኮ ዔያቶኮ ኔ ቡቡራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ኔኤኒ ፆኦሲ ዎጎና ሄርሺንታኔ፤ ጋዓንቴ ዬያ ዎጎ ኔ ካፖ ሃሺ''ፆና ፆኦሲ ኔ ቶኦቻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ዬይ ያዺ ማዔሢ፦ «ዒንሢ፥ ዓይሁዶ ዓሶ ዛሎ''ና ፆኦሲኮ ሱ'ንፃ ዓይሁዴ ማዒባኣ ዓሶና ጫሽኪንታኔ» ጌይንቲ ፃኣፒንቴ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ዓቲንቶ ቤርቶ ቲቂፃ ካኣሺ ኔኤም ማዓሢ ዎጎ ኔ ኩንሤቶኬ፤ ዎጎ ኔ ካፑዋያ ማዔቶ ጋዓንቴ ዓቲንቶ ቤርቶ ቲቂፆ ካኣዣ ጉሪ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ዬያሮ ዓቲንቶ ቤርቶ ቲቂንቲባኣ ዓይሁዴቱዋ ዓሢ ዎጎ ዓይሢፆ ኩንሣያ ማዔቶ ዓቲንቶ ቤርቶ ቲቆ ካኣዦ ኩንሤያ ማዑዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ኔኤኒ ኔኤኮ ዎጌ ዓኣያ፥ ሃሣ ዓቲንቶ ቤርቶ ቲቂንቶ ካኣዦ ኩንሤያ ማዓዖ፥ ዎጎ ኔ ካፒባኣያ ማዔቴ ዓሽኮ ዓቲንቶ ቤርቶ ቲቂባኣያታዖ ዎጎ ኩንሤ ዓይሁዴ ማዒባኣ ዓሢ ኔ ጊዳ'' ዎጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ዬያሮ ሱ'ንፃ ሌሊ ዓይሁዴ ማዔ ዓሲ' ጎኔ ዓይሁዴ ዓሲ ማዑዋሴ፤ ዬያጉዲ ሃሣ ጴዻ ዓሽኮ ዓቲንቶ ቤርቶ ቲቂፃ ሌሊ ጎኑሞ ቲቂንቲ ካኣሺቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ጎኔ ዓይሁዴ ዓሲ' ዒኖ ጋራፓ ዓይሁዴ ዓሲ ማዒ ጴዼቶኬ፤ ጎኔ ዓቲንቴ ቤርቲ ቲቂሢ ካኣሺ፦ ፆኦሲ ዓያናፓ ማዔ ዒኔ ቲቂንቲ ካኣሺ ማዓንዳኣፓዓቴም ሙሴ ዔርዜ ዎጎይዳ ፃኣፒንቴ ጎይፆጉዲ ዓሽኮ ዓቲንቶ ቤርቶ ቲቂንቶ ካኣዦቱዋሴ። ዬያይዳ ዓሲ ጋላታ ዴንቃንዳሢ ፆኦሲዳፓ ማዓንዳኣፓዓቴም ዓሲዳፓቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ዓካሪ ዓይሁዴ ዓሳ ዓይሁዴ ማዒባኣ ዓሶይዳፓ ባሻሢ ዓይጎናዳይ? ዓቲንቶ ቤርቶ ቲቂፆ ካኣዣ ዓይጎ ማኣዳ''ይ? ");
INSERT INTO mdybse_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ዓይሁዴ ዓሲ ማዒፃ ጎኔና ሚርጌ ጎይሢና ባሻያኬ፤ ዬይያ፦ ፆኦሲ ፔኤኮ ቃኣሎ'' ዓይሁዶ ዓሶም ጉሙርቂ ዒንጌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ዓይሁዶኮ ፔቴ'' ፔቴ'' ዓሳ ጉሙርቂንቱዋያ ማዒ ጴዼቶ፦ ዔያቶኮ ጉሙርቂንቱዋያ ማዒፃ ፆኦሲ ጉሙርቂንቱዋያ ማሃ? ");
INSERT INTO mdybse_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ፔቴ''ታዖ ማሁዋሴ! «ኔ ጌስታ ጌኤዞና ጎኔ ዓሲ ማዒ ኔና ሞኦታሢ ኔ ላሣንዳኔ» ጌይንቲ ፃኣፒንቴሢጉዲ ዓሲ ቢያ ሉኡቃያ ማዔቴያ ፆኦሲ ጎኔ ጌስታያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ጋዓንቴ ኑኡኮ ጎማ ፆኦሲ ፂሉ''ሞ ፔጋሲ ዻዋያ ማዔቴ፥ ኑ ዎዚ ጋዓንዳይ? ፆኦሲ ኑ ጎሞሮ ኑና ሜቶይዳ ዓጌቶ ፒዜ ዒ ዎጋያቱዋሴ ጌይሢዳ? ዬያ ታ ዓሲ ማሊሢ ጎይሢ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","«ፆኦሲ ፒዜ ዎጋያቱዋሴ» ጋዓኒ ፔቴ''ታዖ ዳንዳዒንቱዋሴ፤ ያዺ ማዔቶ ፆኦሲ ዓጮ''ይዳ ሃጊ ዎዲ'' ዎጋንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ጋዓንቴ ታኣኮ ሉኡዚ ዓሲ ማዒፃ ፆኦሲኮ ጎኑሞ ፔጋሲ ቦንቾ ዼኤፑሞዋ ዻውዋያ ማዔቶ ዓካሪ ታኣኒ ሉኡዚ ዓሲ ማዒ ዎጊንታሢ ዓይጌንዴሮዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ፔቴ'' ፔቴ'' ዓሳ፦ «ኮሺ ባኣዚ'' ኑ ዴንቃኒ ፑርታ ባኣዚ'' ኑ ማዾም» ጌዒ ጌዒ ታኣኒ ዔርዛያ ማሊሲ ታና ዾንካኔ፤ ዬያሮ ዔያቶ ዑፃ ዎጊንታንዳ ዴኤፆ ዎጋ ፒዜኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ዬያይዴቴ ኑኡኒ፥ ዓይሁዶ ዓሳ ዓይሁዶ ማዒባኣ ዓሶይዳፓ ባሻኔ ጌይሢዳ? ፔቴ''ታዖ ያዺቱዋሴ! ዓይሁዶ ዓሶ ማዔቴያ ዓይሁዴ ማዒባኣ ዓሳ ሓሣ ዓሲ ቢያ ጎሜና ማዔሢ ቤርታዺ ታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ጌኤዦ ማፃኣፖይዳ፦ «ፔቴ''ታዖ ፂሎ'' ዓሲ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ዒኔና ጶቂሣ ዓሲያ ባኣሴ፤ ዒናፓ ፆኦሲ ኮዓ ዓሲ ፔቴ''ታዖ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ቢያሢ ጎኑሞ ጎይፃፓ ዻቢ ዣኣሌኔ፤ ፔቴ''ታዖ ኮሺ ማዾ ማዻ ዓሲ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ዓሲ ባይዛ፥ ፑርታ ጌኤሲ ጌስታኒ ዻንጋ ዔያቶኮ ጉሪ ዱኡፒ ዔቴጉዲኬ፤ ዻንጋ ዔያቶኮ ጌሻያኬ፤ ጌኤዛ ዔያቶኮ ሾኦሺ ዻዓሢጉዲኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ዻንጋ ዔያቶኮ ፑርታ ጋዳማ ሌሊ ጋዳንቃያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ዔያታ ዓሲ ዎዻኒ ሩራያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ዔያታ ዴንዳ ቤዞ ቢያይዳ ባይሲንታና ሜቶናኮ ካራኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ዎዲ'' ኮሺ ናንጎንዶቴያ ዔያታ ዔሩዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ፔቴ''ታዖ ፆኦሲ ዔያታ ዒጊጩዋሴ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ዎጎኮ ዓይሢፃ ኮይሳሢ ዎጌና ዎርቃ ዓሲም ማዔሢ ኑ ዔራኔ፤ ዬያ ዛሎ''ና ዓሳ ቶላ''ኒ ጎዖንዶ ባኣዚ'' ባይዚ ዻንጎ ፔኤሲ'' ዓርቃንዳኔ፤ ዓጫ'' ቢያ ፆኦሲ ቤርታ ዻቢንቴያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ዬያሮ ዓይጎ ዓሲያ ፆኦሲ ቤርታ ሙሴ ዔርዜ ዎጎ ኩንሥሢና ፂሉ''ዋሴ፤ ዎጋ ዻዋሢ፦ ዓሲ ጎሜና ማዒፆኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ሓሢ ጋዓንቴ ፆኦሲ ዓሲ ፂሊ''ሳ ጎይፃ ዎጋፓ ዱማዺ ጴዼኔ፤ ዬይያ፦ ሙሴ ዔርዜ ዎጎና ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ዛሎ''ና ማርካዺንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ዬያሮ ፆኦሲ ዖናኣ ዱማሱዋዖ ዬሱስ ኪሪስቶሴ ጉሙርቃዞንሢም ቢያ ፂሉ''ሞ ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ዓይጎሮ ጌዔቶ ዓሲ ቢያ ጎሜ ማዺ ፆኦሲ ዔያቶም ዒንጌ ቦንቻፓ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ዬያሮ ዓሳ ዬሱስ ኪሪስቶሴ ማዼ ዻቂሺፆ ማዾ''ና ፆኦሲ ፔ ኮሹሞና ዒንጌ ዒንጊፆና ፂላ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ፆኦሲ ዬሱስ ኪሪስቶሴ፡ ጎሞ ዛሎ ዒንጎ ባኣዚ'' ማሂ ዒንጌሢ' ዒዛ ጉሙርቃሢ ቢያ ዒዛ ሱጉፆና ዔያቶኮ ጎማፓ ማኣሪንቲሢ ዴንቃንዳጉዲኬ፤ ፆኦሲ ዬያ ማዼሢ' ቤርታ ዓኣ ጎሞ ጊቢ'' ዳንዳዒሢና ባኣያ ማሂ ፔኤኮ ፂሉ''ሞ ጎይፆ ዻዋኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ሓሣኣ ዎዶ''ና ፆኦሲ ፂሎ'' ዎጋያ ማዒፆ ዻዋሢ' ዬሱሴ ጉሙርቃዞንሢ ቢያ ፂሊ''ሲፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ዓካሪ ኑኡኒ ሄርሺንታንዳ ባኣዚ'' ዓይጌ ዓኣይ? ዓይጎናኣ ኑ ሄርሺንታ ባኣዚ'' ባኣሴ፤ ኑ ሄርሺንቱዋኣሢ ዓይጎ ዛላናዳይ? ዎጎ ኑ ማዺ ኩንሣሢሮዳ? ዔይዔ፤ ኪሪስቶሴ ጉሙርቂሢ ዎጌናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ዬያሮ ፆኦሲ ዓሲ ፂሎ'' ማሂ ዛጋሢ፦ ዎጌ ማዾ ኩንሤምቱዋንቴ ጉሙርቄቶ ማዔሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ፆኦሲ፡ ዓይሁዶ ዓሶ ፆኦሲ ሌሊዳ? ዓይሁዶ ማዒባኣ ዓሶኮ ፆኦሲቱዋዓዳ? ጎኔና ዓይሁዶ ማዒባኣ ዓሶኮዋ ፆኦሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ፆኦሲ ፔቴ''ኬ፤ ዓይሁዶ ዓሶ ማዔቴያ ዓይሁዴ ማዒባኣ ዓሶ ኪሪስቶሴ ጉሙርቂሢ ዛላና ፂሊ''ሳሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ዓካሪ ኪሪስቶሴ ጉሙርቂሢ ዛላና ዎጎ ኑ ባይዛኔ ጌይሢዳ? ያዺቱዋሴ! ባሼና ዎጎ ኑ ዶዲሺ ካካፓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ዓካሪ፡ ኑኡኮ ዓዳሢ፥ ዓብራሃሜ «ዴንቄኔ» ኑ ጋዓሢ ዓይጌንዴዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ዓብራሃሜ ዎንዴ ፂሌ''ሢ ማዾና ማዔያታቴ ዒ ሄርሺንታንዳ ባኣዚ'' ዴንቃንዳዖኬ፤ ጋዓንቴ ዒ ፆኦሲ ቤርታ ሄርሺንታኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ዓይጎሮ ጌዔቴ፦ «ዓብራሃሜ ፆኦሲ ጉሙርቄሢሮ ጉሙርቂፃ ዒዛኮ ፂሉ''ሞ ማዒ ፓይዲንቴኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ማዾ ማዻ ዓሲም ማዾ'' ዛሎ'' ዒንጊንታ ባካ ዒዛኮ ዎልቆ ዛሎ''ኬ፤ ጉሪ ዒንጎያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ዓሲ ኮሺ ባኣዚ'' ማዺባኣያ ማዔቴያ ጎሞ ዓሶ ፂሊ''ሳ ፆኦዛሢ ጉሙርቄቶ ጉሙርቂፃ ፂሉ''ሞ ማዒ ዒዛም ፓይዲንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ዓሲ ኮሺ ማዼ ዛላሮቱዋንቴ ፆኦሲ ጉሪ ፂሊ''ሳ ዓሲ ዓንጂንቴያ ማዒፆ ዳውቴ ዔርዛዖ፦ ");
INSERT INTO mdybse_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ዻቢንታ ዓቶም ጌይንቴዞንሢና ጎሞዋ ሓሾ''ና ዓሳ ዓንጂንቴያኬ! ");
INSERT INTO mdybse_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ፆኦሲ ጎሞ ዒዛኮ ዓርቂባኣ ዓሢ ዓንጂንቴያኬ!» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ዓካሪ ዬይ፥ ዳውቴ ኬኤዜ፥ ዓንጃ ዓቲንቶ ቤርቶ ቲቂንቴ ዓሶም ሌሊሞ? ቲቂንቲባኣ ዓሶማኣ ኬኤዜይ? ቲቂንቲባኣዞንሢማኣ ኬኤዜኔ። ዓይጎሮ ጌዔቴ፦ «ዓብራሃሜ ፆኦሲ ጉሙርቄሢሮ ጉሙርቂፃ ዒዛኮ ፂሉ''ሞ ማዒ ዒዛም ፓይዲንቴኔ» ኑ ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ዓብራሃሜኮ ጉሙርቂፃ ፂሉ''ሞ ማዒ ፓይዲንቴሢ ዓይዴዳይ? ዓቲንቶ ቤርቶ ቲቂንቶኮ ቤርታሞ? ጊንፃኣዳይ? ዓቲንቶ ቤርቶ ቲቂፆኮ ቤርታኬ፥ ጊንፃኣቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ዓብራሃሜ ዓቲንቶ ቤርቶ ቲቂንታንዳሢኮ ቤርታ ዒዛኮ ጉሙርቂፃ ፂሉ''ሞ ማዒ ዒዛም ፓይዲንቴሢ ዔርዛንዳ ማላታ ማዓንዳጉዲ ዓቲንቶ ቤርቶ ዒ ቲቂንቴኔ፤ ዬያሮ ዓብራሃሜ ዓቲንቶ ቤርቶ ቲቂንቱዋዖ ጉሙርቃዞንሢና ጉሙርቂፃኣ ፂሉ''ሞ ማዒ ፓይዲንታዞንሢኮ ቢያ ዓዶኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ዬያጉዲ ሃሣ ዓብራሃሜ ዓቲንቶ ቤርታ ቲቂንቴዞንሢኮዋ ዓዶኬ፤ ዓቲንቶ ቤርቶ ቲቂንቴዞንሢኮ ዓዶ ማዔ ጎይፃ ዔያቶኮ ዓቲንቶ ቤርቶ ቲቂንቶና ሌሊቱዋንቴ ዒዚ ዓቲንቶ ቤርቶ ቲቂንቶኮ ቤርታ ዓኣ ዒዛኮ ጉሙርቂፆጉዴያ ዔያታ ጉሙርቄሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ዓብራሃሜ ፔ ዜርፆና ዓጮ'' ዻካላንዳያታሢ ፆኦሲ ዒዛም ሃጊ ማዓንዳ ዎዛ ዒንጌኔ፤ ዬይ ዎዛ'' ጴዼሢ' ዓብራሃሜ ዎጎ ኩንሤሢሮቱዋንቴ ጉሙርቄሢሮና ጉሙርቂፃኣ ዒዛም ፂሉ''ሞ ማዒ ፓይዲንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ዬያ ሓጊ ማዓንዳ ዎዞ'' ዴንቃንዳዞንሢ ዎጎ ካፓ ዓሶ ማዔቴ ጉሙርቂሢ ፓሡዋ ባኣዚ'' ማዓኔ፤ ዒንጊንቴ ዎዛ''ኣ ጉሪ ማዓኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ዎጌ ፆኦሲ ጎሪ''ንቲ ዔኪ ዬዓኔ፤ ዎጌባኣያ ማዔቶ ጋዓንቴ ዎጌኮ ዑሣ ዓኣዺ ዻቦ ዻቢንቲ ባኣያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ሃጊ ማዓ ዎዞ''ኮ ዓይፃ ጉሙርቂሢኬ፤ ዬያሮ ዓብራሃሜ ዜርፃ ቢያ ዬያ ዔርቴ ዎዞ'' ፆኦሲኮ ኮሹሞ ዒንጊፆና ዴንቃንዳኔ፤ ዬይያ፦ ዎጎ ዛሎ''ና ፂላ''ዞንሢም ሌሊቱዋንቴ ዓብራሃሜጉዲ ጉሙርቂፆና ፂላ''ንዳዞንሢማኣ ማዓንዳኔ፤ ዓብራሃሜ ጉሙርቂፆ ዛሎ''ና ኑና ቢያሢኮ ዓዶ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ዬይ ያዺ ማዔሢ፦ «ሚርጌ ዴሬኮ ታ ኔና ዓዶ ማሄኔ» ጌይንቲ ፃኣፒንቴ ጎይፆናኬ። ዬያሮ ዓብራሃሜ ጉሙርቄ ፆኦዛሢ፥ ሓይቄሢያ ዔቂሳሢና ባኣ ባኮዋ ዓኣያ ማዓንዳጉዲ ማሃ ፆኦዛሢኮ ቤርታ ሃጊ ማዓ ዎዛ'' ዒዛኮ ዶዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ዓብራሃሜ ጉሙርቂሢና ሃጊ ማዓ ዎዛ ጌሤሢ' ዓይጎ ባኣዚ''ያ ሃጊ ማዓ ዎዛ ማሆንዶ ባኣዚ'' ባኣያይዳኬ፤ ዬያሮ፦ «ዜርፃ ኔኤኮ ዬያጉዲ ሚርጋንዳኔ» ጌይንቲ ፃኣፒንቴ ጎይፆና ሚርጌ ዴሬኮ ዒ ዓዶ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ሌዓ ዒዛኮ ፄኤታ ሄላ''ያ ማዔ፥ ጋርቼ ዓሲታዖ ዒዛንታ ማቾ ሳኣራንታ ጋርቺ ሾዓኒ ዳንዳዑዋኣሢ ዔሬቴያ ፆኦሲ ጉሙርቂፆ ዒ ሼሌዒሲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ጉሙርቂፆና ዒዚ ዶዲ ፆኦሲ ቦንቼያፓዓቴም ፆኦሲ ዒንጌ ሃጊ ማዓ ዎዛ''፦ «ማዓያሞ ማዑዋያዳይ?» ጌይ ማሊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ዓይጎሮ ጌዔቴ ፆኦሲ ዒዛም ዒንጌ ዎዞ'' ኩንሣኒ ዳንዳዓሢ ዒ ዔሬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ዓብራሃሜኮ ጉሙርቂፃ ፂሉ''ሞ ማዒ ፓይዲንቴሢ ዬያናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ጋዓንቴ፦ «ፂሉ''ሞ ማዒ ዒዛም ፓይዲንቴኔ» ጋዓ ቃኣላ'' ፃኣፒንቴሢ ዓብራሃሜም ሌሊቱዋንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ኑማኣ ማዓያኬ፤ ጎዳ ዬሱሴ ሃይባ''ፓ ዔቂሴ ፆኦዛሢ ኑ ጉሙርቃሢሮ ኑማኣ ኑ ጉሙርቂፃ ፂሉ''ሞ ማዒ ፓይዲንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ዬይ፡ ኑ ጎዳሢ፥ ዬሱሴ ኑ ጎሞሮ ሃይቢም ዓኣሢንቲ ዒንጊንቴሢና ኑናኣ ፂሊ''ሳኒ ሃይባ''ፓ ዔቄሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ዓካሪ፡ ኑኡኒ ፂሉ''ሞ ዴንቄሢ ጉሙርቂሢና ማዔሢሮ ኑ ጎዳ ዬሱስ ኪሪስቶሴ ዛሎ''ና ፆኦሲና ዎላ'' ኑኡኮ ኮሹሞ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ዒዛ ዛሎ''ና ሃሢ ኑ ዓኣ፥ ፆኦሲኮ ኮሹሞ ዒንጊፆይዳ ጉሙርቂሢና ኑ ጌላኒ ዳንዳዔኔ፤ ፆኦሲና ዎላ'' ቦንቺንታያ ኑ ማዓንዳሢሮ ሃጊ ማዓንዳ ዎዞና ኑ ዎዛዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ዬያና ሌሊቱዋንቴ ኑኡኮ ሜታሢናኣ ኑ ዎዛዻኔ፤ ዓይጎሮ ጌዔቶ ሜቶይዳፓ ዶዱሞ ጴዻያታሢ ኑ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ዶዲሢ ሜቶ ዳንዳዔያ ማዔሢ ዔርዛኔ፤ ዬካፓ ሃጊ ማዓንዳ ዎዛ ጴዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ኑም ዒንጊንቴ ዓያኖ ጌኤዦ ዛሎ''ና ፆኦሲ ናሹማ ዒና'' ኑኡኮ ሚርጌና ዓኣሢሮ ዒ ሃሢ ዒንጌ ሃጊ ማዓንዳ ዎዛ'' ኑና ቦርሲሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ቤርታ ኑ ላቤ''ያ ማዒ ዓኣንቴ ፆኦሲ ማሊ ጌሤ ዎዶ''ና ኪሪስቶሴ ጎሞ ዓሶ ዛሎ'' ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ፂሎ'' ዓሲ ዛላሮ ጌዒ ሃይቃንዳ ዓሲ ዴንቃኒ ሚርጌ ሜቶኬ፤ ጋዓንቴ ኮሺ ዓሲ ዛላ ሃይቃኒ ጫርቃይ ጎዖንቴ ጴዻንዳያ ናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ጋዓንቴ ኑኡኒ ጎሜናታንቴ ኪሪስቶሴ ኑ ዛሎ'' ሃይቄኔ፤ ዬይያ፦ ፆኦሲ ኑና ናሽካ ናሹማ ኮሺ'' ዼኤፒ ማዔሢ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ዓካሪ፡ ኑኡኒ ፂሌ''ሢ ዬሱስ ኪሪስቶሴ ሱጉፆ ዛሎ''ና ማዔቴ፥ ባሼና ፆኦሲ ጎሪ''ንታፓ ኑ ዓታንዳሢ ዒዛ ዛሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ኑኡኒ ፆኦሲና ሞርኬ ማዒ ዓኣዖ ዒዛኮ ናዓሢ ሃይቦ''ና ዒዛና ዎላ'' ኑ ቡኬኔ፤ ሓሢያ ኑኡኒ ፆኦሲና ዎላ'' ቡኬሢኮ ጊንፃ ዒዛኮ ናዓሢ ናንጎ ዛሎ''ና ባሼ ኑ ዻቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ዬያ ሌሊቱዋንቴ ኑና ቡኩሴ፥ ዬሱስ ኪሪስቶሴ ዛሎ''ና ፆኦሲ ማዼ ባኮሮ ኑ ዎዛዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ፔቴ'' ዓሲ ዛላና ጎሜ ዓጮ'' ጌሌም፥ ጎሜ ዛላና ሓይቢ ሙኬኔ፤ ዬይያ፦ ዓሲ ቢያ ጎሜ ማዼሢሮ ሓይቢ ዓሲ ቢያ ሄሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ዎይቲ ጌዔቴ ሙሴኮ ዓሶ ዎይሦ ዎጋ ዒንጊንታንዳሢኮ ቤርታ ጎሜ ዓጫ'' ዓኣኔ፤ ማዔቴያ ዎጌባኣ ዎዴና ጎሜ ጎሜኬ ጌይንቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ጋዓንቴ ዓዳኣሜጉዲ ዎጌ ዻቢ ጎሜ ማዺባኣዞንሢያ ዓይሱዋዖ፥ ሓይቢ ዓዳኣሜፓ ዓርቂ ሙኪ ሙሴ ሄላ''ንዳኣና ዓሲ ቢያይዳ ቢታንቶ ዴንቄኔ። ዬይ ዓዳኣሜ ሃጊ ሙካንዳ ኪሪስቶሴኮ ማላታ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ጋዓንቴ ፆኦሲኮ ኮሹሞ ዒንጊፃ ዓሢኮ ጎሞይዳፓ ባሼኬ፤ ፔቴ'' ዓሲ ጎሜ ዛላና ሚርጌ ዓሲ ሃይቄሢጉዲ ፆኦሲኮ ኮሹሞ ዒንጊፆ ማዔ፥ ፔቴ'' ዬሱስ ኪሪስቶሴ ዛሎ''ና ጴዼ ዒንጊፃ ሚርጌ ዓሶም ዑሣ ዓኣሢ ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ዬያጉዲ ፆኦሲኮ ኮሹሞ ዒንጊፆኮ ዓኣፓ ዓሢኮ ጎሞ ዓኣፓፓ ባሼኔ፤ ፔቴ'' ዓሲ ጎሜ ዛላ ዒንጊንቴ ዎጌ ሜቶ ዒኪ ሙኬኔ፤ ሚርጌ ጎሞ ዛሎ''ና ዒንጊንቴ ፆኦሲ ኮሹሞ ዒንጊፃ ጋዓንቴ ፂሉ''ሞ ዒኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ፔቴ'' ዓሲ ዻቢንቲ ዛላና ሓይቢ ዓሲ ቢያይዳ ቢታንቶ ዴንቄኔ፤ ጋዓንቴ ዬያፓ ዬሱስ ኪሪስቶሴ ማዼሢ ባሼኬ፤ ዬይያ፦ ፔቴ'' ዬሱስ ኪሪስቶሴ ዛሎ''ና ፆኦሲኮ ሚርጌ ኮሹሞ ዒንጊፆ ዴንቂ ፂሌ'' ዓሳ ቢያ ሃይቢ ባሺ ናንጊና ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ዓካሪ፡ ፔቴ'' ዓዳኣሜ ጎማ ሜቶ ዎጌ ዓሲ ቢያይዳ ዔኪ ሙኬያ ማዔቴያ፥ ፔቴ'' ኪሪስቶሴኮ ፂሉ''ሞ ማዻ'' ሚርጌሢ ሜቶይዳፓ ኬሲ'' ናንጊ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ዓዳኣሜኮ ዓይሢንቱዋዖ ዓቲፆ ዛሎ''ና ሚርጌ ዓሳ ጎሜና ማዔሢጉዲ፥ ኪሪስቶሴኮ ዓይሢንቲፆ ዛሎ''ና ሚርጌ ዓሳ ፂላ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ዎጌ ሙኪፆና ዻቢንቲ ሚርጌኔ፤ ጋዓንቴ ዻቢንታ ሚርጌሢዳፓ ፆኦሲኮ ኮሹሞ ዒንጊፃ ዑሣ ዓኣዼ ሚርጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ዬይ ያዺ ማዔሢ' ጎሜ ሃይቢ ዛላና ካኣታዼሢጉዲ ፆኦሲኮ ኮሹሞ ዒንጊፃ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴ ዛሎ''ና ጴዻ ናንጊና ናንጊ ፂሉ''ሞ ዔኪ ሙኪሢና ካኣታዻንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ዓካሪ ኑ ዎዚ ጎዖንዶይ? ፆኦሲኮ ኮሹሞ ዒንጊፃ ኑም ሚርጋንዳጉዲ ጎሜ ማዺ ማዺ ናንጎንዶ? ");
INSERT INTO mdybse_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ፔቴ''ታዖ ዬይ ኮይሱዋሴ! ኑኡኒ ሃይቢና ዱማዾሢጉዲ ጎሜይዳፓ ዱማዻዖ ጊንሣ ዎይቲ ኑ ጎሜ ማዺ ማዺ ናንጋንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ዬሱስ ኪሪስቶሴና ዎላ'' ፔቴ'' ማዓኒ ኑ ዋኣፆ ማስቴ ዓሳ ቢያ ዒዛኮ ሃይቦ''ና ፔቴ'' ማዓኒ ዋኣፆና ማስቴሢ ዒንሢ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ዋኣፆ ማስቲፆና ዒዛና ዎላ'' ኑ ዱኡቴ ዎዶ''ና ዒዛና ዎላ'' ኑ ሓይቄያ ማዔኔ፤ ዬያሮ ኪሪስቶሴ ዓዶኮ ቦንቾና ሓይባ''ፓ ዔቄሢጉዲ ኑኡኒያ ዓኪ ናንጊ ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ኑኡኒ ሓይቂ ዒዛና ዎላ'' ፔቴ'' ማዔቴ፥ ሓይባ''ፓ ዔቂፆና ዒዛና ዎላ'' ኑ ፔቴ'' ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ኑኡኮ ቤርታኣ ናንጋ ላኣሚንቴም ጎሜኮ ካራሚ ማዒፃ ዓታንዳጉዲ ቤርታኣ ናንጋ ኑኡኮ ኪሪስቶሴና ዎላ'' ሱፂንቴሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ጎሜኮ ሓይቄ ዓሲ ዑስካ ቢታንቶ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ዓካሪ ኑኡኒ ኪሪስቶሴና ዎላ'' ሓይቄቴ ዒዛና ዎላ'' ናንጊና ናንጋንዳሢ ኑ ጉሙርቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ኪሪስቶሴ ሓይባ''ፓ ዔቄሢሮ ላሚ ሓይቂንዱዋኣሢና ሓይቢኮዋ ዒዛይዳ ቢታንቶ ባኣሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ዒዚ ሓይቄ ዎዶ''ና ጎሜኮ ዒዛ ዑፃ ቢታንቶ ባኣያ ማዓንዳጉዲ ጋፒንሢ ፔቴ''ና ዒ ሓይቄኔ፤ ሓሢ ዒ ሼምፔና ማዒ ናንጋሢ ፆኦሲምኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ዓካሪ ሓሢ፡ ዒንሢዳ ጎሜኮ ቢታንቶ ባኣሢና ዬሱስ ኪሪስቶሴ ዛሎ''ና ፆኦሲም ሼምፔና ዓኣያ ማዒ ዒንሢ ናንጋያታሢ ማሉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ዬያሮ ጎሜ ፔኤኮ ፑርቶ ማሊፆ ዒንሢ ኩንሢሱዋጉዲ ዒንሢኮ ሃይቃ ዑፆይዳ ጎሜ ቢታንታንዳጉዲ ማሂፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ዒንሢኮ ዱማ ዱማ ዑፆ ፑርታ ባኣዚ'' ማዻያ ማሂ ጎሜም ዒንጊፖቴ፤ ጋዓንቴ ሃይቢፓ ዒንሢ ዔቄ ጎይፆና ዒንሢ ፆኦሲም ዒንጉዋቴ፤ ሃሣ ዒንሢኮ ዱማ ዱማ ዑፆዋ ቢያ ፂሎ'' ማዾ ማዻንዳጉዲ ፆኦሲም ዒንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ዓይጎሮ ጌዔቴ ሃሢ ዒንሢ ናንጋሢ ፆኦሲኮ ኮሹሞ ዒንጊፆ ዴማ'' ማዓንዳኣፓዓቴም ዎጌ ዴንካቱዋኣሢሮ ጎሜ ዒንሢ ዎይሣኒ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ዓካሪ ኑ ዎዶ''ንዶይ? ዎጌ ዴማ'' ማዒፃ ዓቴም ፆኦሲኮ ኮሹሞ ዒንጊፆኮ ዴማ'' ኑ ማዔያታሢሮ ጎሜ ኑ ማዾም ጌይሢዳ? ዬይ ፔቴ''ታዖ ማዓዓኬ! ");
INSERT INTO mdybse_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ፔቴ'' ዓሲም ዒንሢ ማዻኒ ዓይሢንታኣና ዬያ ዒንሢ ዓይሢንታ ዓሢም ካራሚ ማዔሢ ዒንሢ ዔራኔ፤ ዬያጉዲ ጎሜም ዒንሢ ዓይሢንቴቴ ሓይቢ ዔኪ ሙካ፥ ጎሜኮ ካራሚ ዒንሢ ማዓንዳኔ፤ ፆኦሲም ዓይሢንቴቴ ጋዓንቴ ፂሉ''ሞ ዒንሢ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ዒንሢ ቤርታ ጎሜኮ ካራሚኬ፤ ሓሢ ጋዓንቴ ዋይዚ ዔኬ ዔራቶ''ም ዒናፓ ዒንሢ ዓይሢንታሢሮ ፆኦሲ ጋላታ ሄሎ''ንጎ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ጎሜ ካራሙሞይዳፓ ኬስኪ ፂሉ''ሞኮ ካራሚ ዒንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ታኣኒ ሃያ ዒንሢም ዔርታንዳ ጎይሢና ኬኤዛሢ' ዒንሢኮ ማሊፃ ላቤ''ያታሢሮኬ፤ ሃያኮ ቤርታ ዒንሢኮ ዑፆ ዒኢቴ ባኣዚ''ና ፑርታ ማዾናም ማሂ ዒንሢ ዒንጌሢጉዲ ሓሢ ዒንሢኮ ዱማ ዱማ ዑፆ ፆኦሲም ዱማዼያ ማዓንዳጉዲ ፂሉ''ሞኮ ካራሚ ማሂ ዒንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ዒንሢ ጎሜኮ ካራሚ ማዒ ዓኣ ዎዶ''ና ፂሉ''ሞም ዒንሢ ማዻንዳሢ ዒንሢም ዔርቲባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ሂዳዖ ዬኖ ዎዶ''ና ዓይጎ ዒንሢ ፓሣ ባኣዚ'' ዴንቄይ? ሓሢ ዒንሢ ቦርሲሳ ባኮይዳፓ ዓታዛ፥ ዓይጎዋ ፓሣ ባኣዚ'' ዒንሢ ዴንቂባኣሴ፤ ዬያ ባኮኮ ጋፒንፃ ሃይቢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ሓሢ ጋዓንቴ ጎሜኮ ካራሙሞይዳፓ ዒንሢ ኬስኪ ፆኦሲ ካራሚ ማዔሢሮ፥ ፆኦሲም ዱማዼያ ዒንሢ ማዓንዳኔ፤ ፆኦሲም ዱማዺፆኮዋ ጋፒንፃ ናንጊና ናንጊኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ዓይጎሮ ጌዔቴ ጎሜይዳፓ ጴዻ ባኣዚ'' ሓይቢኬ፤ ፆኦሲዳፓ ዒንጊንታ ዒንጊፃ ጋዓንቴ ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴ ዛሎ''ና ጴዻ ናንጊና ናንጊኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ቢያሢ ዒንሢ ዎጌ ዔራያታሢሮ ዎጌ ዓሲዳ ቢታንቶ ዴንቃሢ ዓሲ ሼምፖና ዓኣ ዎዶ''ማና ሌሊታሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ኮኦኪንሢና፦ ፔቴ'' ሎዔ ላኣሊ ዓኒና ዎላ'' ሼምፔና ናንጋ ዎዶ''ይዳ ዒዛና ዎላ'' ዎጌና ቱኡቴ''ያኬ፤ ዓኒ ዒዞኮ ሃይቄቶ ጋዓንቴ ዒዛ ቱኡቴ'' ዎጎይዳፓ ኬስኬያ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ዬያሮ ዓኒ ዒዞኮ ሼምፔና ዓኣንቴ ሜሌ'' ዓቲንቄም ዒዛ ሎዔቴ ዓኒ ማዒባኣያና ላሄኔ ጌይንታኔ፤ ዓኒ ሃይቄቶ ጋዓንቴ ዒዛና ዎላ'' ዒዛ ቱኡቴ'' ዎጎይዳፓ ኬስኬያኬ፤ ሜሌ'' ዓሲም ዒዛ ሎዔቴ ዓኒ ማዒባኣያና ላሄኔ ጌይንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ዒሾንሢዮቴ! ዒንሢ ባካ ዬያጉዴያኬ፤ ዒንሢ ኪሪስቶሴ ዑፆኮ ዱማ ዱማ ቤዞ ማዔሢሮ ሓይቢና ዱማዾሢጉዲ ሙሴ ዎጋ''ፓ ዒንሢ ዱማዼኔ። ዬያሮ ፆኦሲ ማዾ''ም ዓኣፒ ኑ ዓኣፓንዳጉዲ ሃይቦ''ይዳፓ ዔቄ፥ ኪሪስቶሴሮ ዒንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ዎይቲ ጌዔቴ ጎሞ ማሊፆና ኑ ናንጋ ዎዶ''ና ዎጎ ዛሎ''ና ማዺንታ ፑርቶ ማሊፃ ሓይቢ ዓኣፒ ኑ ዓኣፓንዳጉዲ ኑኡኮ ዱማ ዱማ ዑፆይዳ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ሓሢ ጋዓንቴ ቤርታ ቱኪ'' ኑና ዓኣ ዎጎይዳፓ ሓይቢና ዱማዺሢጉዲ ኑ ዱማዼያ ማዔሢሮ ዎጎ ቱኡዛፓ ኑ ኬስኬኔ። ዬያሮ ሃካፓ ሴካ ኑኡኒ ማዻሢ ዓኪ ማዔ ዓያኖ ዓይሢፆጉዲኬ፤ ሚና ቤርታ ፃኣፒንቴ ጪንቄ ዎጋ'' ዓይሣሢ ጎይፆቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ዓካሪ ኑ ዎዚ ጎዖንዶይ? ዎጌ ፔ ቶኦኪና ጎሜኬ ጌይሢዳ? ፔቴ''ታዖ ያዺቱዋሴ! ጋዓንቴ ጎሜ ዓይጎ ማዔቴያ ታ ዔራንዳጉዲ ማሄሢ ዎጌኬ። ዎይቲ ጌዔቴ ዎጋ''፦ «ዓሲሮ ዛጊ ሱኡካዺፖ» ጌዒባኣያታቴ፥ «ሱኡካዺሢ» ዓይጎታቴያ ታ ዔሪንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ጎሜ' ሱኡኬ ቢያ ታ ሱኡካዻንዳጉዲ ማሄሢ ዎጌይዳፓ ሙኬ ዓይሢፆ ዛሎ''ናኬ፤ ዎጌባኣቶ ጋዓንቴ ጎሜ ሓይቄ ባኣዚ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ዎጌ ታ ናንጎይዳ ሓጊ ቢታንቶ ዴንቂባኣንቴ ዎጎኮ ዓይሢፆ ታ ዔራዛ ጎሜ ሼምፖ ዴንቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ታኣኒ ሓይቄኔ፤ ናንጊና ናንጊ ዒንጋንዳጉዲ ዒንጊንቴ ዎጎኮ ዓይሢፃ ታኣም ሓይቢ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ዎይቲ ጌዔቴ ዎጌኮ ዓይሢፆ ዛሎ''ና ጎሜ ካራ ዴንቂ ታና ጌሺ ዓይሥሢና ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ዬያሮ ዎጌ ፆኦሲም ዱማዼያኬ፤ ዓይሥሢያ ዱማዼያ፥ ጌኤሺ ሓሣ ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ሂዳዖ ዬይ ኮዦ ባካ ታኣም ሃይቢ ዔኪ ሙኬኔ ጌይሢዳ? ያዺቱዋሴ! ሓይቢ ታኣም ዔኪ ሙኬ ባካ ጎሜኬ። ጎሜ ዓይጎታቴያ ዔርታንዳጉዲ ኮሺ ማዔ ባኬሎ ካራ ማሂ ዬይ ሃይቢ ታኣም ዔኪ ሙኬኔ። ዬያሮ ጎሞኮ ፑርቱማ ዔርታሢ ዎጌኮ ዓይሢፆ ዛሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ዓካሪ ዎጌ ዓያና ባኣዚ'' ማዔሢ ኑ ዔራኔ፤ ታኣኒ ጋዓንቴ ጎሜኮ ካራሚ ማዓኒ ሻንቺንቴያ፥ ጎሜ ማሊሢ ታና ዎይሣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ታኣኒ ማዻ ባኮ ታ ዔሩዋሴ፤ ዓይጎሮ ጌዔቴ ናሽካ ባኮ ታ ሓሺ''፥ ታ ዒፃ ባኮ ማዻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ዓካሪ፤ ታኣኒ ማዻሢ ታ ኮዑዋ ባኣዚ'' ማዔቴ ዎጌ ኮሺ ማዔሢ ታ ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ታ ማዻኒ ኮይሱዋ ባኮ ማዻሢ ታ ጊዶይዳ ዓኣ ጎሞ ማዓንዳኣፓዓቴም ታናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ታ ጊዶይዳ ሓሣ ታኣኮ ጎሞ ማሊፆይዳ ዓይጌያ ኮሺ ባኣዚ'' ባኣሢ ታ ዔራኔ፤ ዓይጎሮ ጌዔቴ ዓይጎ ኮሺ ባኣዚ'' ታ ማዻኒ ማላቶዋ ዬኖ ኮዦ ማዼ''ሎ ታ ማዻኒ ዳንዳዑዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ማዻኒ ታኣም ኮይሳ ኮዦ ማዾ'' ታ ማዹዋሴ፤ ጋዓንቴ ታ ኮዑዋ ፑርታ ማዾ ታ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ዓካሪ ማዻኒ ታኣም ኮይሱዋ ፑርቶ ማዾ'' ማዻያ ታ ማዔቴ ዬያ ማዻሢ ታ ጊዶይዳ ዓኣ ጎሞ ማዓንዳኣፓዓቴም ታናቱዋሴ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ዬያሮ ፔቴ'' ዎጌ ማዺ ማዺ ዓኣሢ ታ ዛጋኔ፤ ዎይቲ ጌዔቴ ታ ኮሺ ባኣዚ'' ማዻኒ ኮዓ ዎዶ''ና ፑርታ ባኣዚ'' ሌሊ ማዺንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ታኣኮ ጋሮ ዒና'' ጋዓንቴ ፆኦሲ ዎጎና ዎዛዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ማዔቴያ ታኣኮ ማሊፆ ዎጎና ዎላ'' ካኣሞ ዒፂ፥ ታኣኮ ዱማ ዱማ ዑፆይዳ ማዻ ጎሞ ዎጎና ዲዒንቴያ ታና ማሃ ሜሌ'' ዎጌ ታ ጋራ ዓኣሢ ታ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ዬያሮ ታ ዎዚጉዴ ላኣፓ ዓሲዳይ! ሓያ ታና ሓይቢም ዔኪ ዴንዳ ዓሽኮይዳፓ ዖ ታና ዓውሳንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ፆኦሲም ጋላታ! ዬሱስ ኪሪስቶሴ ዛሎ''ና ዬያ ዒ ማዼሢሮ። ዓካሪ ታኣኒ ማሊፆና ፆኦሲ ዎጌም ዎርቃያ ማዓዛ፥ ጎሞ ማሊፆና ጋዓንቴ ጎሜ ዎጌም ዎርቃያ ታ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ዓካሪ ሃሢ ዬሱስ ኪሪስቶሴና ፔቱሞ ዓኣዞንሢ ናንጊና ፑርታ ዎጌና ዎጊሳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ዓይጎሮ ጌዔቴ ዬሱስ ኪሪስቶሴ ዛሎ''ና ናንጊ ዒንጋ ዓያና ጌኤሺ ዎጌ፦ ጎሜና ሓይቢ ዎጌናኮ ዓይላቶይዳፓ ታና ኬሴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ዓሲኮ ላቤ'' ማሊፆይዳፓ ዔቄያና ዎጋ'' ኑና ፂሊ''ሳኒ ዳንዳዒባኣታንቴ ፆኦሲ ማዼኔ፤ ፆኦሲ ፔ ናዖ ኑና ጎሞ ዓሶ ማሊሲ ኑ ጎሞ ዛሎ'' ዳኪ ኑኡኮ ጎሞ ማሊፆ ናንጊና ዎጊ ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ዬያ ዒ ማዼሢ ዓሲ ማሊሢናቱዋንቴ ዓያና ማሊሢና ሃንታ ዓሶ፥ ኑጊዳ ፒዜ ማዔ ዎጎ ዓይሢፃ ማዺንቲ ኩማንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ዓሲ ማሊሢና ናንጋዞንሢ፦ ዓሲ ባኣዚ''፤ ዓያና ማሊሢና ናንጋዞንሢ ጋዓንቴ ዓያና ባኣዚ'' ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ዓሲ ባኣዚ'' ማሊሢ ሓይቢ ዔኪ ሙካኔ፤ ዓያና ባኣዚ'' ማሊሢ ጋዓንቴ ሼምፖና ኮሹሞና ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ዓይጎሮ ጌዔቴ ዓሲ ባኣዚ'' ዛላ ማላ ዓሲ ፆኦሲ ዎጌም ዓይሢንቱዋያ ሓሣ ዓይሢንታኒያ ዳንዳዑዋያ፥ ፆኦሲኮ ሞርኬ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ዓሲ ማሊሢ ማሊ ሃንታዞንሢ ፆኦሲ ዎዛሳኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ዒንሢ ጋዓንቴ ፆኦሲኮ ዓያና'' ዒንሢዳ ዓኣቶ ዓያናና ማዓንዳፓዓቴም ዓሲ ማሊሢና ዒንሢ ናንጋዓኬ፤ ኪሪስቶሴ ዓያና'' ባኣ ዓሲ ኪሪስቶሴ ዓሲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ኪሪስቶሴ ዒንሢ ጋራ ማዔቴ፥ ዎዚ ዒንሢኮ ዑፃ ጎሜ ዛላና ሓይቃያ ማዔቴያ ፆኦሲ ዒንሢ ፂሊ''ሴሢሮ ዓያና'' ዒንሢኮ ናንጊና ናንጋያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ዬሱሴ ሓይባ''ፓ ዔቂሴ፥ ፆኦሲ ዓያና'' ዒንሢዳ ዓኣቶ ዬሱስ ኪሪስቶሴ ሓይባ''ፓ ዔቂሴ፥ ፆኦዛሢ ዒንሢዳ ናንጋ ዓያኖ ዛሎ''ና ዒንሢኮ ሓይቃ ዑፆም ሼምፖ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ዬያሮ ታ ዒሾንሦ! ታ ሚሾንሦ! ኑኡኒ ናንጋኒ ኮይሳ ጎይሢ ዓኣኔ፤ ዬና ኮይሳ ጎይፄላ ዓሲ ማሊሢና ኑ ናንጋንዳጉዲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ዓሲ ማሊሢ ማሊ ዒንሢ ናንጋያታቴ ሓይቃንዳኔ፤ ዓያና ጌኤሺ ዎልቄና ዓሲ ማሊሢ ማዾ ዒንሢ ባሼቴ ጋዓንቴ ሼምፖና ዒንሢ ናንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ፆኦሲ ዓያና ዓይሣ ጎይፆ ዓኣዻዞንሢ ቢያ ፆኦሲ ናይኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ዬያሮ «ዓዴ» ጌይ ዒንሢ ዔኤላ''ንዳ ፆኦሲ ናይ ማሃ ዓያና ዒንሢ ዔኬኔ፤ ጊንሣ ዒጊቹሞና ናንጋኒ ካራሙሞ ዓያና ዒንሢ ዔኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ፆኦሲ ዓያና'' ኑ ዓያኖና ዎላ'' ማዒ ፆኦሲ ናይ ኑኡኮ ማዒፆ ኑም ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ዓካሪ ኑኡኒ ፆኦሲ ናይ ማዔያታቴ ኪሪስቶሴና ዎላ'' ዬያ ሃጊ ማዓንዳ ዎዞ'' ቢያ ኑ ዴንቃንዳኔ፤ ሓሢ ኑ ኪሪስቶሴ ሜታዼ ሜቶ'' ዔካያ ማዔቴ ሃጊ ዒዛና ዎላ'' ኑ ቦንቺንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ኑኡኮ ሓሣኣ ዎዶ'' ሜታሢ' ሃጊ ኑም ጴዻንዳ ቦንቾና ዎላ'' ቤቂሦዛ ኮሺ'' ዻካኬ ታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ማዢንታ ቢያ ፆኦሲኮ ናኣታ'' ፔጋዺ ጴዻንዳሢ ዼኤፒ ማሊሢ ጌሢ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ማዢንታ ቢያ ዔኤቢ ፓሡዋ ባኣዚ'' ማዓንዳጉዲ ናንጊና ዔያቶይዳ ዎጊንቴኔ፤ ዬይያ፦ ማዢንታ ፔ ማሊሢናቱዋንቴ ፆኦሲ ማሊሢና ማዔኔ፤ ማዔቴያ ዬይ ሓጊ ማዓንዳ ዎዛ'' ዔያቶም ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ዬይ ሃጊ ማዓንዳ ዎዛ'' ማዢንታ ፔ ቶኦኪና ባይሲንታ ካራሙሞይዳፓ ኬስኪ፥ ፆኦሲ ናኣቶ''ና ዎላ'' ካራሙሞ ባኣያ ቦንቾ ናንጊ ናንጋንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ማዢንታ ቢያ ሓኖ'' ሄላ''ንዳኣና ሾይቺ ባኒሢ ሜታሳ ሜቶጉዴያና ሜታዺሢዳ ዓኣሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ጋዓንቴ ሜታዺፆይዳ ዓኣሢ ማዢንቶ ሌሊቱዋንቴ ቤርታዺ ዓያኖ ጌኤዣ ዒንጊንቴም ዔኬ ዓሳ፥ ኑኡኒያ ፆኦሲ ናይ ማዔሢ ዒዚ ፔጋሳንዳ ኬሎ'' ሃጊ ማዓንዳ ዎዛና ካፒ ካፒ ኑኡኮ ጋሮ ማሊፆና ኑ ሜታዺሢዳ ዓኣኔ፤ ዬካፓ ኑኡኮ ዓይሌ'' ማዒፃ ዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ዓይጎሮ ጌዔቴ ኑኡኒ ዻቄሢ ዬያ ሃጊ ማዓንዳ ዎዞ''ናኬ። ጋዓንቴ ዬይ ዎዛ ኑ ማሄ ባካ ጴዻ ባኣዚ'' ማዔቴ ሃጊ ማዓንዳ ዎዛ'' ዎዛ ማዒፃ ዓቴ''ኔ ጌይሢኬ፤ ጴዻ ባኣዚ'' ዖኦኒ «ሃጊ ማዓንዳ ዎዛኬ» ጋዓንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ጴዹዋ ባኣዚ'' ሃጊ ማዓንዳ ዎዛ ኑ ማሃያ ማዔቶ ጊቢ'' ዳንዳዓሢና ኑ ካፓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ዎያይዲ ሺኢቃኒ ኑም ኮይሳቴያ ኑ ዔሩዋኣሢሮ ዓያና ጌኤሺ ኑ ላቤ'' ዎዶ''ና ኑና ማኣዳ''ኔ፤ ጊንሣ ሓሣ ሓያኬ ጌይ ኬኤዚንቱዋ ጎይሢና ሜታዺ ማሊ ኑ ሺኢጲፆ ፆኦሲም ሺኢሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ዓሲኮ ዒና ዴንቃ ፆኦሲ፥ ዓያኖ ጌኤዦኮ ማሊፃ ዓይጎ ማዔቴያ ዔራኔ፤ ዎይቲ ጌዔቴ ዓያኖ ጌኤዣ ፆኦሲም ዱማዼ ዓሶኮ ሺኢጲፆ ፆኦሲም ሺኢሻሢ ፆኦሲ ማሊፆጉዴያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ፆኦሲ ዒዛ ናሽካዞንሢና ዒዛኮ ማሊፆጉዴያ ዔኤሊ''ንቴ ዓሶም ፆኦሲ ቢያ ባኣዚ'' ኮይሳያ ማሂ ማዻሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ዓይጎሮ ጌዔቴ ፆኦሲ ናዓሢ ሚርጌ ጌርሲንሢኮ ባኣካ'' ቶይዲ ማዓንዳጉዲ ፆኦሲ ቤርታዺ ዶኦሬዞንሢ ዒዛኮ ናዓሢ ማላንዳጉዲ ጌዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ቤርታዺ ዒዚ ማሌዞንሢ ዔኤሌ''ኔ፤ ዔኤሌ''ዞንሢ ሃሣ ፂሎ'' ማሂ ዛጌኔ፤ ፂሎ'' ማሂ ዒ ዛጌዞንሢ ቦንቺሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ዓካሪ ሃያ ባኮ ዛሎ'' ኑ ዎዚ ጎዖንዶይ? ፆኦሲ ኑኡና ዎላ'' ማዔቴ ዖ ኑና ዒፂ ማካኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ፔኤኮ ፔቴ'' ናዓሢ ሚጪንቱዋዖ ኑ ዛሎ''ሮ ዓኣሢ ዒንጌ ፆኦዛሢ ቢያ ባኣዚ'' ኑም ዒንጋንዳሢ ዔርቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ፆኦሲ ዶኦሬዞንሢ ዖኦኒያ «ዻቤያኬ» ጋዓኒ ዳንዳዓይ? ፂሎ'' ማሂ ዛጋሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ዬያሮ ዔያቶይዳ «ዔያታ ዻቤያኬ» ጌይ ዎጋንዳሢ ዖናዳይ? ዬሱስ ኪሪስቶሴ ዔያቶይዳ ዎጋንዳ? ዒዚ ዔያቶይዳ ዎጊንዱዋሴ፤ ዓይጎሮ ጌዔቴ ዒዚ ኑ ጋይቴ ሓይቂ፥ ሓይቢፓ ዔቂ ፆኦሲኮ ሚዛቆ ዛላ'' ዴዒ ኑ ሺኢጲፆ ፆኦሲም ሺኢሻሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ዓካሪ ኪሪስቶሴ ናሹሞይዳፓ ዓይጌ ኑና ዱማሳንዳይ? ሜቶታቴያ፥ ኮሺ'' ዑሣ ዓኣዼ ሜቶታቴያ፥ ዒፂ ዳውሲሢታቴያ፥ ናይዚታቴያ፥ ካሉሞታቴያ፥ ዎዻንዳ ባኣዚ''ታቴያ፥ ጬንቻ ዓፓሮና ዎዾያታቴያ ኑና ዱማሲንዱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ዬይያ፦ «ኔ ጋይቴ ጌዒ ቢያ ኬሊ''ና ሓይቢና ኑ ዖልታኔ፤ ሹኪንታ ማራይጉዲ ኑ ማዔኔ» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ዓካሪ ኑና ናሽኬ፥ ኪሪስቶሴ ዛሎ''ና ዬንሢ ባኮንሢ ቢያ ባሺፆና ዎልቆሮንሢዳፓ ቢያ ኑ ባሻያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ዬያሮ ሓይቢ ማዔቴያ ናንጊ፥ ፆኦሲ ኪኢታንቾ ማዔቴያ ፑርታ ዓያና፥ ሓሢ ዓኣ ባኣዚ''ታቴያ ሓጊ ሙካንዳያ፥ ዓይጎ ዎልቄ ማዔቴያ፥ ");
INSERT INTO mdybse_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ዼጉሞ ማዔቴ ሂርኩሞ፥ ዓይጎ ማዢንቲ ማዖም ኑ ጎዳሢ ዬሱስ ኪሪስቶሴ ዛሎ''ና ኑም ጴዼ ፆኦሲ ናሹሞይዳፓ ኑና ዱማሳኒ ዳንዳዓ ዓይጎ ባኣዚ''ያ ባኣሢ ጎኔና ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ታኣኒ ኪሪስቶሴ ዓሲታሢሮ ጎኔ ኬኤዛፓዓቴም ሉኡቁዋሴ፤ ዓያና ጌኤሺ ዔኪ ዓኣዻ፥ ታኣኮ ጋሮ ዒና'' ታ ሉኡቁዋኣሢ ታኣም ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ዼኤፒ ዖዪሢና ጋፑዋ ማሊሢና ታኣኮ ዒና'' ዓኣኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ታኣኮ ዓሽኮ ዒጊኖ ማዔ፥ ታ ፃጶ ዛሎ''ሮ ኪሪስቶሴይዳፓ ዱማዼም ፆኦሲ ጋዳማ ታና ሄላ''ቶ ቃራታዖኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ዒስራዔኤሌ ዓሳ ፆኦሲኮ ዶኦሪንቴ ዴሬኬ፤ ፆኦሲያ ዔያቶ ፔ ናይ ማሄኔ፤ ፔ ቦንቾዋ ዔያቶም ዻዌኔ፤ ጫኣቁሞዋ ዔያቶና ዒ ጫኣቄኔ፤ ዎጌያ ዔያቶም ዒንጌኔ፤ ጎኔ ካኣሺያ ዔያቶም ዻዌኔ፤ ሃጊ ማዓንዳ ዎዛ ቃኣላኣ ዔያቶም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ዔያታ ሾይንቶና ዓዶንሢ ፃጳፓ ሙኬያኬ፤ ኪሪስቶሴያ ዓሲ ማዒ ሾይንቴሢ ዔያቶይዳፓኬ፤ ዒዚ ጋዓንቴ ቢያሢዳፓ ዑሣ ማዔያኬ፤ ሃሣ ዓንጂንቴ ፆኦሲኬ፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ያዺ ማዔቴያ ፆኦሲ ቃኣላ'' ሓሺ''ንቴኔ ጌይሢቱዋሴ፤ ሓሣ ዒስራዔኤሌ ዜርፃ ጉቤ ጎኔ ዒስራዔኤሌ ዓሲኬ ጌይሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ዬያጉዲ ሃሣ ዓብራሃሜ ዜርፃ ቢያ ፆኦሲ ናይኬ ጌይሢቱዋሴ፤ ዎይቲ ጌዔቴ ፆኦሲ ዓብራሃሜም፦ «ዜርፃ ኔኤኮ ዔኤሊ''ንታንዳሢ ዪሳኣቄ ዛሎ''ናኬ» ጌዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ዬያሮ ዓብራሃሜይዳፓ ሾይንቲ ሌሊ ሾይንቴ ዓሳ ፆኦሲ ናይቱዋሴ፤ ጋዓንቴ ዓብራሃሜ ዜርፆ ማዒ ፓይዲንቴዞንሢ ሃጊ ማዓንዳ ዎዛ ዒንጊንቴ ናኣቶ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ዬይ ፆኦሲ ዒንጌ ዎዛ''፦ «ሙካ ሌዓ ሃይማ ዎዶ'' ታ ሙካንዳኔ፤ ሳኣራ ዒማ''ና ዓቲንቄ ናይ ሾዓንዳኔ» ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ዬያ ሌሊቱዋንቴ ኑ ፃጶ ማኣሮኮ ዓዳሢ ማዔ፥ ዪሳኣቄም ዒርቢቃ ሜንቴ ናይ ጎጳዼ ዎዶ''ና፥ ");
INSERT INTO mdybse_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","ፆኦሲኮ ዶኦሪፃ፦ ማዾ ዛጊቱዋንቴ ዶኦራኒ ኮዔሢ ዶኦራኒ ዳንዳዓያ ማዔሢ ዔርዛኒ ላምዖ ናኣታ'' ሾይንቲ ፑርታኣ ማዖም ኮሺ ባኣዚ'' ማዻንዳሢኮ ቤርታ ፆኦሲ ዒርቢቃም፦ «ቶይዲ ጌኤዚም ማዻያ ማዓንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ዬይያ፦ «ያይቆኦቤ ታ ናሽኬኔ፤ ዔኤሳዎ ጋዓንቴ ታ ዒፄኔ» ጌይንቲ ፃኣፒንቴሢጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ዓካሪ ኑ ዎዚ ጋዓንዳይ? «ፆኦሲ ዓሲ ዱማሳኔ» ኑ ጋዓኒ ዳንዳዓ? «ፆኦሲ ዓሲ ዱማሳኔ» ፔቴ''ታዖ ኑ ጋዓኒ ዳንዳዑዋሴ! ");
INSERT INTO mdybse_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ዓይጎሮ ጌዔቴ ፆኦሲ ሙሴም፦ «ታ ማኣራኒ ኮዓሢ ማኣራንዳኔ፤ ሚጪንታኒ ኮዓሢማኣ ታ ሚጪንታንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ዬያሮ ፆኦሲ ዓሲ ዶኦራሢ ዓሲ ማሊሢና ዓሲ ማዾና ዛጊቱዋንቴ ዒዛኮ ማኣሪፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ያዺታሢሮ ጊብፄ ካኣቲም፦ «ታ ዎልቆ ኔ ዛሎ''ና ታ ዻዋኒና ሱ'ንፃኣ ታኣኮ ዓጮ'' ቢያይዳ ዔርቴያ ማዓንዳጉዲ ታ ኔና ካኣታሴኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ዬያሮ ፆኦሲ ኮዔሢ ማኣራኔ፤ ዒና ባይቃንዳጉዲ ዒ ኮዔሢኮ ዒኖ'' ማሉዋጉዲ ዶዲሻኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ዓካሪ፦ «ፆኦሲ ማሊሢ ማካኒ ዳንዳዒንቱዋያ ማዔቴ ፆኦሲ ዓሶ ዓይጎሮ ‹ፑርታ ማዼኔ› ጌይ ጎራ''ይ» ጋዓይ ናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ሓይ ዓሢ ኔ! ፆኦሲና ዎላ'' ማርማኒ ዓይጎ ዎልቄ ኔኤኮ ዓኣይ? ማዢንቴሢ ማዤሢ ኮራ፦ «ኔ ታና ዓይጎሮ ሃያይዲ ማዤይ?» ጋዓኒ ዳንዳዓ? ");
INSERT INTO mdybse_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ዖቲ ማዣሢ ዢኢጬ ዓጪዳፓ ዔኪ ፔቴ'' ባኬሎ ቦንቺንታያ ማሂ፤ ባጎዞ ቦንቺንቱዋያ ማሂ ማዣኒ ዳንዳዑዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ፆኦሲ ዻጎ ጎሪ''ንቶ ፔኤኮ ዻዋኒና ዎልቆ ፔኤኮ ዔርዛኒ ኮዒ ባይሲንቶም ጊኢጊንቴዞንሢ ሚርጌና ጊቢ'' ዳንዳዓያ ማዔቴሽ! ");
INSERT INTO mdybse_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ዬያ ዒዚ ማዼሢ ቤርታዺ ቦንቾም ዒ ጊኢጊሼ፥ ዒ ማኣሬ ዓሶም ዒዛኮ ቦንቾ ዼኤፑሞ ዻዋኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ዒ ማኣሬ ዓሶ ዓይሁዳፓ ሌሊቱዋንቴ ዓይሁዴ ማዒባኣ ዓሶይዳፓኣ ኑና ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ዬይያ፦ ፆኦሲ ማሊፆ ኬኤዛ'' ሆሴዔ ዛሎ''ና «ታ ዴሬ ማዒባኣ ዓሶ ‹ታ ዴሬ!› ጌይ ታ ዔኤላ''ንዳኔ፤ ታ ናሽኩዋ ዴሮ'' ‹ታኣኒ ናሽካዞንሢ!› ጌዒ ታ ዔኤላ''ንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ዔያታ ‹ዒንሢ ታኣኮ ዴሬቱዋሴ› ጌይንቴ ቤዞይዳ ‹ናንጊና ባይቁዋ ፆኦዛሢ ናኣቶ''› ጌይንታንዳኔ» ጌይንቴሢጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ዒስራዔኤሌ ዓሶ ዛሎ'' ዑኡዞ ዼ'ጊዲ፦ «ዒስራዔኤሌ ናኣቶ''ኮ ፓይዳ'' ባዞ'' ማኣሻሎ''ጉዲ ሚርጌቴያ ዔያቶይዳፓ ዻቃንዳዞንሢ ዻካ'' ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ዬይያ ፆኦሲ ናጉዋዖ ሩኡሪና ዓጮ''ይዳ ዎጋንዳሢሮኬ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ዬያጉዲ ሃሣ ዒሲያሴ ኬኤዛዖ፦ «ቢያ ባኮ ዎይሣ ጎዳሢ ዜርፆ ኑኡኮ ዓይሲባኣያታቴ ሶዶሜና ጋሞራና ካታማ'' ባይቄሢጉዲ ኑኡኒ ሄኤዶ ባይቄያ ናንዳንቴኬ» ጌይ ቤርታዺ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ዓካሪ ኑ ዎዚ ጎዖንዶይ? ኪሪስቶሴ ጉሙርቂሢና ጴዻ ፂሉ''ሞ ላቢ'' ኮዒባኣ፥ ዓይሁዴቱዋ ዓሳ ዴንቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ጋዓንቴ ዎጌይዳፓ ጴዻ ፂሉ''ሞ ኮዔ፥ ዒስራዔኤሌ ዓሳ ዎጎ ኩንሣኒ ዳንዳዒባኣሢሮ ፂሉ''ሞ ዴንቃኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","«ዓይጎሮ ፂሉ''ሞ ዴንቂባኣይ?» ጌዔቴ ዔያታ ፂሉ''ሞ ዴንቃኒ ኮዔሢ ፆኦሲ ጉሙርቂሢናቱዋንቴ ማዾና ማዔሢሮ ዹቃ ሹጫሢዳ ዔያታ ዹቂንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ዬይያ፦ «ሓይሾ፤ ዓሲ ዹቃ ሹቺ ፂዮኔይዳ ታ ጌሤኔ፤ ዬይ ሹጫሢ' ዓሲ ዹቂ፥ ዓጋ ላሌኬ። ዒዛ ጉሙርቃሢ ጋዓንቴ ቦርሲንታዓኬ» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ታኣኮ ዒኖ''ይዳ ዓኣ ዼኤፖ ማሊፆና ፆኦሲ ታ ሺኢቃ ሺኢጲፃ ዒስራዔኤሌ ዓሳ ዻቃንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ጎኔና ዔያታ ዔሩዋዖ ማዻኔ፤ ፆኦሲ ዛሎ'' ባኮ ዒናፓ ናሽካ ዓያና ዔያቶኮ ዓኣሢ ታ ታ ቶኦኪና ዔያቶኮ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ፆኦሲ ዓሶ ፂሎ'' ማሂ ዛጋ ጎይፆ ዔያታ ዔሩዋዖ ዔያታ ፔኤሮ ፂላ''ኒ ኮዒፆና ፆኦሲ ፂሉሞም ዓይሢንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ዓሲ ቢያ ኪሪስቶሴ ጉሙርቂሢና ፂላ''ንዳጉዲ፥ ሙሴኮ ዓሶ ዎይሦ ዎጋ ኪሪስቶሴና ኩሜኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ዎጎ ኩንሥሢና ጴዻ ፂሉ''ሞ ዛሎ'' ሙሴ ፃኣፔሢ፦ «ዎጎ ኩንሣሢ ቢያ ሼምፔና ናንጋንዳኔ» ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","7","«ኔኤኒ ዒኖና ‹ፔቴ'' ዓሲ ኪሪስቶሴ ኬይሳኒ ሌካ ጫሪንጮ ኬስኮንጎ› ጌዒፖ፤» ሃሣ «ኔ ዒኖና ‹ፔቴ'' ዓሲ ኪሪስቶሴ ኬሳ''ኒ ሓይቄ ዓሳ ዓኣ ቤዞ ኬዶ''ንጎ› ጌይፖ» ዬይ፦ ኪሪስቶሴ ሓይካኬ፤ ፆኦሲ «ፂሎ''ኬ» ጌይ ዛጋ ዓሳ ያዺ ጎዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ሓሣ ጊንሣ፦ «ፆኦሲኮ ቃኣላ'' ኔኤኮ ኮይላ''ኬ፤ ፔቶ'' ሃሣ ኔኤኮ ዻንጎና ዒኖናይዳኬ» ጌይንቲ ፃኣፒንቴኔ። ዬይ ቃኣላ'' ኑኡኒ ኬኤዛ ጉሙርቂፆ ቃኣሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ዬሱሴ ጎዳ ማዔሢ ኔ ዒኖና ኔ ማርካዺ ፆኦሲ ዒዛ ሓይባ''ፓ ዔቂሴሢያ ኔ ጉሙርቄቶ ዻቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ዓይጎሮ ጌዔቴ ዓሲ ፔ ዒኖና ጉሙርቂ ፂላ''ኔ፤ ፔ ዻንጎና ማርካዺ ዻቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ዬይያ፦ «ዒዛ ጉሙርቃሢ ቢያ ቦርሲንቲንዱዋሴ» ጌይንቲ ፃኣፒንቴሢጉዴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ዓካሪ፤ ፔቴ'' ፆኦዛሢ ቢያሢኮ ጎዳ ማዔሢሮ ዓይሁዴ ዓሶና ዓይሁዴ ማዒባኣ ዓሶና ባኣካ'' ዱሙሞ ባኣሴ፤ ዒዚ ኮሺ ፆኦሲ ማዔሢሮ ሺኢቃዞንሢም ቢያ ዻቂንቶ ዓንጆ ሚርጌና ዒንጋኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ዓይጎሮ ጌዔቴ ጌኤዦ ማፃኣፖይዳ፦ «ጎዳ ማኣዳ''ንዳጉዲ ዔኤላ''ሢ ጉቤ ዻቃንዳኔ» ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ጋዓንቴ ዒዛ ጉሙርቂባኣታዖ ዎይቲ ዔያታ ዔኤላ''ኒ ዳንዳዓይ? ሓሣ ዒዛ ዛሎ'' ዋይዚ ባኣዖ ዎይቲ ዔያታ ጉሙርቃንዳይ? ዔያቶም ኮዦ ሓይሶ ቃኣሎ'' ኬኤዛ ዓሲ ባኣንቴ ዎይቲ ዔያታ ዋይዛኒ ዳንዳዓንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ጌኤዦ ማፃኣፖይዳ ኮዦ ሓይሶ ቃኣሎ'' ኬኤዛዞንሢ ኬኤዞም ዳኪንቲባኣያታቴ ዎይቲ ዔያታ ኬኤዛኒ ዳንዳዓንዳይ? «ኮዦ ሓይሶ ኬኤዛ ዓሶኮ ቶካ ዎዚጉዴ ኮሺዳይ?» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ጋዓንቴ ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ፦ «ጎዳሢዮ! ኑኡኒ ኬኤዛ ቃኣሎ'' ዖኦኒ ዔኬይ?» ጌዔሢጉዲ ቢያሢ ኮዦ ሃይሶ ቃኣሎ'' ዔኪባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ዓካሪ፤ ኪሪስቶሴ ጉሙርቂሢ ጴዻሢ ኮዦ ሓይሶ ዋይዚዳፓኬ፤ ኮዦ ሓይሳኣ ኪሪስቶሴ ዛሎ'' ኬኤዛሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ሂንዳ ታ ሂዚ ጎዖም፤ ኮዦ ሓይሶ ዔያታ ዋይዚባኣሴ ጌይሢዳ? ጌኤዦ ማፃኣፖይዳ፦ «ኮዦ ሓይሳ ዓጮ'' ቢያይዳ ኬኤዚንቴኔ፤ ዬይ ዑኡዛ ዓጮ''ኮ ጋፖ ሄሌ''ኔ» ጌይንቲ ፃኣፒንቴሢጉዲ፥ ጎኔና ዒስራዔኤሌ ዓሳ ዋይዜያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ሓሣ ዒስራዔኤሌ ዓሳ ኮዦ ሓይሶ ዔሪባኣሴ ጌይሢዳ? ዬይ ያዺ ጌይንቱዋጉዲ ሙሴ ሃያኮ ቤርታ፦ «ቦሂንቴ ዓሶ ዓሲ ማሂ ‹ዎይቲ ዔያታ ኑጉዲ ማዔይ› ታ ዒንሢ ጌይሲሳንዳኔ፤ ዔኤቢ ዔሩዋ ዓሶ ዔርዚ ታ ዒንሢ ዻጋሳንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ፆኦሲ ማሊፆ ኬኤዛ ዒሲያሴ ሓሣ፦ «ታና ኮዒባኣሢም ታ ጴዼኔ፤ ‹ፆኦሲ ዓንካዳይ?› ጌይ ታና ዖኦጪባኣዞንሢም ታ ፔጋዺ ጴዼኔ» ጌዒ ጫርቂ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ጋዓንቴ ዒስራዔኤሌ ዓሶ ዛሎ'' ኬኤዛዖ፦ «ዓይሢንቱዋ፥ ዒፃ ዴሬ ታ ባንሢ ሙካንዳጉዲ ቢያ ዎዴ ኩጮ ታ ቤኤዜኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ሂንዳ ታ ሓሣ ሂዚ ጎዖም፤ ፆኦሲ ፔ ዴሮ'' ሃሺ''ያ? ፔቴ''ታዖ ሃሺ''ባኣሴ! ታኣኒ ታ ቶኦኪና ዓብራሃሜ ዜርፃፓ ሓሣ ቢኢኒያሜ ማኣራፓ ማዔያ ዒስራዔኤሌ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ዬያሮ ፆኦሲ ቤርታዺ ዶኦሬ ዴሮ'' ሓሺ''ባኣሴ፤ ጌኤዦ ማፃኣፓ ዔኤሊያሴ ዛሎ'' ዎዚ ጌዔቴያ ዒንሢ ጶቂሡዋዓዳ? ሓሣ ዒስራዔኤሌ ዴራ'' ማዼ ባኮ ዎዚ ጌዒ ፆኦሲም ዒዚ ፑሽኬቴያ ዒንሢ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ዒማ''ና ዔኤሊያሴ፦ «ጎዳሢዮ! ኔ ማሊፆ ኬኤዛዞንሢ ዔያታ ዎዼኔ፤ ኔኤም ዒንጎ ባኮ ዒንጊ ካኣሽኮ ቤዞዋ ሻሄም ታኣኒ ሌሊ ዓቴ''ኔ፤ ታናኣ ሓሣ ዔያታ ዎዻኒ ኮዓኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ጋዓንቴ ፆኦሲ ዒዛም ማሃዖ፦ «ጎኔ ፆኦሲ ማዒባኣ፥ ባዓኣሌ ጎዖ ፆኦዞ ካኣሽኪባኣ ላንካይ ሺያ ዓሲ ታኣኮ ዓኣኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ሓሢ ማዔቴያ ፆኦሲኮ ኮሹሞ ዒንጊፆና ዶኦሪንቴ ዻካ'' ዒስራዔኤሌ ዓሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ፆኦሲኮ ዶኦሪፃ ኮሹሞ ዒንጊፆና ማዔቶ ማዾናቱዋሴ ጌይሢኬ፤ ዎንዴ ማዾና ማዔቴ ፆኦሲኮ ኮሹሞ ዒንጊፃ ኮሹሞ ዒንጊሢ ማዒንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ዓካሪ ጋፒንፃ ዓይጎ ማዔይ? ዒስራዔኤሌ ዓሳ ዔያታ ኮዔ ባኮ ዴንቂባኣሴ፤ ዔያቶይዳፓ ዶኦሪንቴዞንሢ ጋዓንቴ ኮዔ ባኮ ዴንቄኔ፤ ዓቴ'' ዓሳ ጎኑሞ ዔራኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ዬይያ ያዺ ማዔሢ፦ «ፆኦሲ ዒኖ'' ዔያቶኮ ዶጪሴኔ፤ ዬያሮ ሃኖ'' ሄላ''ንዳኣና ዓኣፓ ዔያቶኮ ዴንቁዋሴ፤ ዋያኣ ዔያቶኮ ዋይዙዋሴ» ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ዳውቴ ሓሣ፦ «ዔያታ ሙዓኒ ቡካ ቤዛ ዓርቃ ፒሮ፤ ሓሣ ሎንሣ ዔቴ ማዒ ዔያቶ ሜታሶንጎ! ");
INSERT INTO mdybse_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ዓኣፓ ዔያቶኮ ዴንቁዋጉዲ ዹሞንጎ፤ ጊኢራኣ ዔያቶኮ ሜቶና ቢያ ኬሊ'' ዎቦንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ሂንዳ ላሚ ታ ሓሣ ሂዚ ጎዖም፤ ዓይሁዶ ዓሳ ዻቢንቴሢ ናንጊና ባይቃንዳጉዲዳ? ያዺቱዋሴ! ዓይሁዶ ዓሶ ዻቢንቶ ዛሎ''ና ዓይሁዴ ማዒባኣ ዓሳ ዻቂንታ ዴንቄኔ፤ ዬይ ያዺ ማዔሢ ዔያታ ዓይሁዴ ማዒባኣ ዓሳ፦ «ዎይቲ ዔያታ ኑጉዲ ማዔይ?» ጋዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ዓይሁዶ ዓሶኮ ዻቢንታ ዓጮ''ም ሚርጌ ዓንጆ ጴዺሴኔ፤ ሓሣ ዔያቶኮ ባሊቲባኣያ ማዒፃ ዓይሁዴ ማዒባኣ ዓሶም ዓንጆ ማዔኔ፤ ዎንዴ ዓይሁዶ ዓሳ ቢያ ዻቄያ ማዔቴ ዓንጃ ዎዚ ሚርጋንዳንቴዳይ? ");
INSERT INTO mdybse_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ሓሢ ሓያ ታ ኬኤዛሢ ዒንሢ፥ ዓይሁዴ ማዒባኣ ዓሶምኬ፤ ዒንሢ፥ ዓይሁዴ ማዒባኣ ዓሶም ታ ኬኤዛንዳጉዲ ዳኪንቴሢሮ ታ ማዻ ማዾ''ና ዎዛዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ሓያ ታ ማዻሢ ታ ፃጶ ማዔ ዓይሁዴ ዓሶ፦ «ዔያታ ዎይቲ ኑጉዲ ማዔይ?» ጌይሳኒኬ፤ ዬያይዲፆና ጎዖንቴ ዔያቶይዳፓ ፔቴ'' ፔቴ''ዞንሢ ታ ዻቂሻንዳያ ናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ፆኦሲ ዔያቶ ሃሼ''ሢሮ ሜሌ'' ዓሳ ፆኦሲና ቡካያ ማዔቴ ፆኦሲ ዔያቶ ፔ ዓሲ ማሂ ዔካ ዎዶ''ና ዎዎይታንዳያ ዒንሢም ማላይ? ዬይ ሓይቢዳፓ ዔቂሢጉዴያኬ! ");
INSERT INTO mdybse_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ፔቴ'' ቆኦሮ ሙኑቃኮ ካራ''ፓ ዔኪ ፆኦሲም ዱማዼያ ማሆናቴ ሙኑቃ ጉቤ ፆኦሲም ዱማዼያ ማዓኔ። ዬያጉዲ ሃሣ ፔቴ'' ሚሢኮ ፃጳ ፆኦሲም ዱማዼያ ማዔቴ ካኣፓኣ ዱማዼያ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ማኣሮ ካራ'' ቱኮ''ና ሪሚቶ ሚፆኮ ካኣፖ ማዔ ዓይሁዶ ዓሳ ሜቂ ኬዴ'' ቤዛ ጌሦና፥ ካዮ ሪሚቶ ካኣፖጉዲ ማዔ፥ ዒንሢ ዓይሁዴ ማዒባኣ ዓሳ ዔያቶም ዒንጊንታ ዓንጆ ዒንሢያ ዴንቃያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ዬያሮ ዒንሢ ዓይሁዴ ማዒባኣ ዓሳ ሜቂ ኬዴ'' ካኣፖ፥ ዓይሁዶ ዓሶይዳ ዖቶርቂፖቴ፤ ዒንሢ ካኣፒ ሌሊ ማዔሢሮ ፃጳ ዒንሢ ኬዲ ዓርቄኔ፤ ዒንሢ ፃጶ ኬዲ ዓርቂባኣሢሮ ሄርሺንታንዳያ ዒንሢም ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ጋዓንቴ፦ «ካኣፓ ሜቂ ኬዴ''ሢ ኑኡኒ ዔያቶ ቤዛ ጌላንዳጉዲ ጌይኬ» ዒንሢ ጋዓንዳኣናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ያዺ ዒንሢ ጋዓኒ ጎኔኬ፤ ጋዓንቴ ዔያታ ሜቂ ኬዴ''ሢ ኪሪስቶሴ ጉሙርቁዋዖ ዓቲፆና ማዓዛ ዒንሢ ዶዲ ዒኢካ ዴዔሢ ኪሪስቶሴ ጉሙርቂፆናኬ፤ ያዺ ማዔሢሮ ዒዒጊጫንዳፓዓቴም ዖቶርሙሞ ዒንሢ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ዓይጎሮ ጌዔቴ ፆኦሲ ቤርታ ማዢንቶ ካኣፖ ማዔ፥ ዓይሁዶ ዓሶም ሚጪንቲባኣያ ማዔቴ ዒንሢማኣ ሚጪንታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ዓካሪ ፆኦሲኮ ሚጪንቶና ሚጪንቶ ዒፂፆና ዛጉዋቴ፤ ሚጪንቶ ዒፂፃ ዒዛኮ ሜቂ ኬዴ''ዞንሢም ማዓዛ፥ ሚጪንቶ ዒ ዒንሢ ሚጪንታኔ፤ ዬያ ዒ ማዻንዳሢ' ዒዛ ጉሙርቂፆና ዶዲ ዒንሢ ናንጌቴኬ፤ ዶዲባኣቴ ጋዓንቴ ዒንሢያ ሜቂ ኬዳ''ንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ዓይሁዶ ዓሳ ኪሪስቶሴ ጉሙርቂፆ ዒፂፆ ሃሺ'' ማዔቴ ቤርታ ዔያታ ዓኣ ቤዞ ማማዓንዳኔ፤ ዎይቲ ጌዔቴ ፆኦሲ ዔያቶ ቤርታ ዓኣ ቤዞ ማሃኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ዒንሢ፥ ዓይሁዴ ማዒባኣ ዓሳ፤ ዒንሢ ካዮ ሪሚቶ ካኣፖ ማዒ ዓኣያታዖ ዒንሢኮ ቤዞ ማዒባኣ፥ ቱኮ''ና ሪሚቶ ሚፆይዳ ዓይሢንታኒ ዳንዳዔቴ ቱኮ''ና ሪሚቶ ካኣፖ ማዔ ዓይሁዶ ዓሳ ቤርታ ዔያታ ዓኣ ቤዞ ማዓኒ ዎይቲ ዔያቶም ዳንዳዒንቲንዱዋይ! ");
INSERT INTO mdybse_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ታ ዒሾንሦ! ታ ሚሾንሦ! «ኑ ዔራኬ» ጌይ ሄርሺንቲፖቴ፤ ፔቴ'' ዓኣሺንቴ ባኣዚ'' ታ ዒንሢም ኬኤዛንዳኔ፤ ዬና ዓይጎዳይ ጌዔቴ ዒስራዔኤሌ ዓሶኮ ጉሙርቆ ዒፂፃ ጋፒንሢ ሄላ''ንዳኣናቱዋንቴ ዔኤሊ''ንቴ፥ ዓይሁዴ ማዒባኣ ዓሳ ቢያ ፆኦሲ ባንሢ ሙካንዳያ ሄላ''ንዳኣናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ዓካሪ፤ ዒስራዔኤሌ ዓሳ ቢያ ዻቃንዳሢ፦ «ዻቂሻሢ ፂዮኔፓ ኬስካንዳኔ፤ ያይቆኦቤ ዜርፆኮ ጎሞ ባይዛንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ጎሞ ታ ዔያቶኮ ባይዛ ዎዶ''ና ዔያቶና ዎላ'' ታ ጫኣቃንዳ ጫኣቁማ ያዺኬ» ጌይንቲ ፃኣፒንቴ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ዒስራዔኤሌ ዓሳ ኮዦ ሓይሶ ዋይዜዖ ዔኮ ዒፂፆና ዒንሢ ዓይሁዴ ማዒባኣ ዓሶም ዻቂንታ ማዓንዳጉዲ ፆኦሲኮ ዔያታ ሞርኬ ማዔኔ። ጋዓንቴ ዶኦሪንቲፆ ዛሎ''ታቴ ዔያታ ዓዶንሢ ዛሎ''ና ፆኦሲኮ ዒጊኖኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ፆኦሲ ዶኦሪ ሓሣ ኮሹሞ ዒንጊፆዋ ዒንጌሢኮ ጊንፃ ዒ ማዼ ማዾ''ና «ዓይጋ ታ ሂዴይ!» ጌይ ማሉዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ዒንሢ፥ ዓይሁዴ ማዒባኣ ዓሳ ቤርታ ፆኦሲም ዓይሢንቱዋያኬ፤ ሓሢ ጋዓንቴ ዓይሁዴ ዓሳ ዓይሢንቲባኣ ዛሎ''ና ፆኦሲ ማኣሪፆ ዒንሢ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ፆኦሲ ዒንሢ ማኣሬሢ ዔያታ ዛጋዖ ፆኦሲም ዓይሢንቱዋያ ማዔኔ፤ ጋፒንፃ ጋዓንቴ ዒንሢ ማኣሬ ጎይፆ ዔያቶዋ ማኣራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ዓይጎሮ ጌዔቴ ፆኦሲ ዓሲ ቢያ ማኣራኒ ጋዓዖ፥ ዓሲ ቢያ «ዓይሢንቱዋያኬ» ጌይ ሃሼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ፆኦሲኮ ኮሹሞና ሃኣማቶና ሃሣ ዔራቶና ዖኦኒያ ዔሩዋያኬ! ዒ ዎጋ ዎጊፃ «ዎዚምዳይ?» ጌይንቱዋያኬ፤ ዒ ማዻ ጎይፃኣ ዔርቱዋያኬ! ");
INSERT INTO mdybse_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ፆኦሲ ማሊሢ ዔራይ ዖኦኒያ ባኣሴ፤ ዒዛ ዞራ ዓሲያ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ታልዖ ማሃንዳጉዲ፥ ዒዛም ታልዔ ዓሲያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ዎይቲ ጌዔቴ ቢያ ባኮ ማዤሢ ዒዛኬ፤ ቢያ ባኮ ናንጊሻሢያ ዒዛኬ፥ ዒዛም ናንጋያኬ፤ ናንጊና ቦንቾ ዒዛም ማዖንጎ፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ዓካሪ ታ ዒሾንሦ! ታ ሚሾንሦ! ፆኦሲ ዎዛሳያ ሃሣ ናንጊና ባይቁዋ ዒንጎ ባኣዚ'' ማሂ ዒንሢ ፆኦሲም ዒ'ንሢ ዒንጋንዳጉዲ ዓቶም ጋዓ ፆኦዛሢ ሱ'ንፆና ታ ዒንሢ ሺኢቃኔ፤ ዬይ ዒንሢ ዒንጋኒ ኮይሳሢ' ፒዜ ማዔያ ጎኔና ፆኦሲ ካኣሽኪሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ኮሺ ሃሣ ዎዛሳያ፥ ፓጫ ባኣዚ''ያ ባኣያ ማዔ ፆኦሲ ማሊፆ ዒንሢ ዔራንዳጉዲ ዒንሢኮ ዒና'' ዓካዺ ላኣሚንቶንጎ፤ ጋዓንቴ ሓያ ዓጮ'' ዓሶኮ ፑርቶ ማሊፆጉዲ ማዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ሓሣ፦ «ዒንሢ ፔቴ'' ፔቴ''ሢም ፆኦሲ ዒንጌ ጉሙርቂፆጉዴያ ሼሌዑሞና ማላንዳፓዓቴም ዒንሢም ኮይሳሢዳፓ ዑሣ ዓኣሢ፥ ዒንሢ ዼ'ጊዲ ማሊፖቴ» ጌይ ፆኦሲ ታኣም ፔ ኮሹሞና ዒንጌ ጎይፆና ታ ዒንሢ ዞራኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ኑኡኮ ፔቴ'' ፔቴ''ሢኮ ዑፆይዳ ዱማ ዱማ ቤሲ ዓኣኔ፤ ዬያ ዱማ ዱማ ዑፆኮ ዱማ ዱማ ማዾ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ዬያጉዲ ኑኡኒ ሚርጌታዖ ኪሪስቶሴና ኑ ፔቴ'' ዑሢኬ፤ ፔቴ'' ዑፆኮ ዱማ ዱማ ቤዞ ኑ ማዔ ጎይፆና ዎላ'' ኑ ካኣማያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ዬያሮ ፆኦሲ ፔ ኮሹሞ ዒንጊፆና ኑም ዒንጌ ዱማ ዱማ ዒንጊፆጉዴያ ኑ ማዾም፤ ኑም ዒንጊንቴሢ ፆኦሲ ማሊሢ ኬኤዚሢ ማዔቴ ፆኦሲ ጉሙርቃ ጎይፆማ ኑ ኬኤዞም። ");
INSERT INTO mdybse_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ኑም ዒንጊንቴሢ ሜሌ'' ዓሲም ማዺሢ ማዔቴ ዶዲ ኑ ማዾም፤ ኑም ዒንጊንቴሢ ዔርዚሢታቴ ኮይሳ ጎይፆ ኑ ዔርዞም፤ ");
INSERT INTO mdybse_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ኑም ዒንጊንቴሢ ዓሲ ዞሪሢ ማዔቴ ኑ ዞሮም፤ ኑም ዒንጊንቴሢ ዓሲም ዔኤቢ ዒንጊሢ ማዔቴ ዒናፓ ኑ ዒንጎም፤ ኑም ዒንጊንቴሢ ዓሲ ዎይሥሢ ማዔቴ ዶዲ ኑ ዎይሦም፤ ኑም ዒንጊንቴሢ ሜሌ'' ዓሲ ሚጪንቲሢ ማዔቴ ዎዛና ኑ ሚጪንቶም፤ ");
INSERT INTO mdybse_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ናሹማ ዒንሢኮ ዑሣ ማዒባኣ ናሹሞ ማዖንጎ፤ ፑርታ ባኣዚ'' ሻኣኪንቲ፥ ኮሺ ባኣዚ'' ዒናፓ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ኪሪስቶሴ ዛሎ''ና ዒንሢ ዎሊኮ ጌርሲንሢ ሃሣ ጌሮንሢ ማዔሢሮ ዎሊ ዒናፓ ናሽኪንቱዋቴ፤ ሜሌ'' ዓሲ ዒንሢ ቦንቻስካፓ ባሼ ቦንቻኒ ኮዑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ቤልፁሞ ሃሺ''፥ ጉቤ ዒናፓ ጎዳ ዬሱሴም ዶዲ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ሓጊ ማዓንዳ ባኮና ዎዛዹዋቴ፤ ሜቶ ዎዴና ጊቢ'' ዳንዳዑዋቴ፤ ቢያ ዎዴና ሃሣ ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ኪሪስቶሴ ጉሙርቃ፥ ዒንሢኮ ዒሾንሢ ሜቴቶ ማኣዱ''ዋቴ፤ ሾኦቺ ማዒ ሙካዞንሢያ ሾኦቺንሢ ዔኩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ዒንሢ ዒፂ፥ ዳውሳዞንሢ ዓንጁዋቴ፤ ዓዓንጃንዳፓዓቴም ዔያቶም ጋዳንቂፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ዎዛዻ ዓሶና ዎላ'' ዎዛዹዋቴ፤ ዬኤካ ዓሶና ዎላ'' ዬኤኩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ዎላ'' ፔቴ'' ማሊሢና ጊኢጊ ናንጉዋቴ፤ ዒንሢ ቶኦኮ'' ዼ'ጊሲ ዖቶርቂሢ ሃሺ''፥ ማንቆ ዓሶና ዎላ'' ፔቴ'' ማዑዋቴ፤ «ታጊዳፓ ሜሌ'' ዔሮ ባኣሴ» ጌይፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ዓሲ ቢያም ኮሺ ባኣዚ'' ማዹዋቴ፤ ዓሲ ፑርታ ባኣዚ'' ዒንሢም ማዼቴ ዒንሢያ ፑርታ ባኣዚ'' ማሂ ማዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ዒንሢም ዳንዳዒንታያ ማዔቴ ዓሲ ቢያና ኮሹሞና ናንጋኒ ዒንሢ ማዻንዳያ ኮይሳ ባኣዚ'' ቢያ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ታ ዒሾንሦ! ታ ሚሾንሦ! ኮሜ ፆኦሲም ሃሹ''ዋቴ፤ ዒንሢሮ ኮሜ ዔኪፖቴ፤ ዓይጎሮ ጌዔቴ ፆኦሲ፦ «ኮሞ ማሃንዳሢ ታናኬ» ጋዓኔ ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ዬያሮ ኮሜ ማሃሢዳፓ፦ «ኔኤኮ ሞርካሢ ናይዼቴ ዒዛ ሙኡዜ፤ ዼኤቤቴያ ዒዛ ዑሼ፤ ዬያ ኔ ሂዴቴ ዒ ማዼ ማዻ'' ዼኤፒ ዻቢንቲ ማዔሢ ዒዛም ዔርታንዳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ዬያሮ ፑርታ ማዾ ኮሹሞና ባባሼ፤ ፑርቱሞና ባሺንቲፖ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ዓይጎ ቢታንቶዋ ማዖም ዒንጊንታሢ ፆኦሲ ማሊሢና ማዔሢሮ ሓሢ ዓኣ ዎይሣ ዓሶዋ ዶኦሬሢ ፆኦሲታሢሮ ዓሲ ቢያ ዎይሣ ዓሲም ዓይሢንታንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ዬያሮ ዓጮ'' ዎይሣ ዓሶም ዓይሢንቶ ዒፃሢ ቢያ ፆኦሲ ዓይሢፆዋ ዒፃያኬ፤ ዓይሢንቶ ዒፃሢ ፔ ቶኦካ ሜቶ ዔኪ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ዎይቲ ጌዔቴ ዓጮ'' ዎይሣ ዓሳ ዒጊቻሢ ፑርቶ ማዻዞንሢ ማዓንዳኣፓዓቴም ኮሺ ማዻዞንሢቱዋሴ፤ ዓጮ'' ዎይሣ ዓሶ «ዒጊጫዓ» ኔ ጋዓ? ሂዴያታቴ ኮሺ ባኣዚ'' ማዼ፤ ዎይሣ ዓሳ ኔና ጋላታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ዓጮ'' ዎይሣ ዓሳ ኔኤም ኮሺ ማዻንዳጉዲ ፆኦሲ ዶኦሬም ማዻያኬ፤ ዓጮ'' ዎይሣ ዓሳ ዓንጋሞ ዓርቃሢ ጉሪቱዋኣሢሮ ፑርታ ኔ ማዻያ ማዔቴ ዓጮ'' ዎይሣ ዓሶ ዒጊጬ፤ ዒዚ ፑርታ ማዻ ዓሶ ዓርቂ ሜቶ ሄሊ''ሳንዳጉዲ ፆኦሲ ጌሤያ ዒዛኮ ዓንጋሞኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ዬያሮ ዓጮ'' ዎይሣ ዓሶም ዓይሢንታንዳያ ዒንሢ ኮይሳኔ፤ ዒንሢ ዓይሢንታንዳሢ ፆኦሲ ዒንሢዳ ዔኪ ሙካንዳ ጎሪ''ንቶሮ ሌሊቱዋንቴ ዒና'' ዒንሢኮ ዬያይዶንዶሢ ዔራያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ዓካሪ ጊኢራ ዒንሢ ጪጋሢ ዬያሮኬ፤ ዓጮ'' ዎይሣ ዓሳ ዬያ ማዺሻንዳጉዲ ፆኦሲ ጌሤዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ዬያሮ ዓጮ'' ዎይሣ ዓሶ ዛሎ''ና ዒንሢዳፓ ኮይንታ ባኮ ቢያ ኩንሡዋቴ፤ ጊኢራ ኮይሳሢም ጊኢራ፥ ሻንቾ ባኮ ዛሎ'' ጪጎሢታቴያ ጪጉዋቴ፤ ዒጊጪንታኒ ኮይሳሢ ዒጊጩዋቴ፤ ቦንቻኒ ኮይሳሢያ ቦንቹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ዒንሢ ዎሊ ሴካና ሃንጋና ናሽኩዋቴ፤ ዖ ጊዳ''ኣ ዒንሢኮ ናሹሞ ጋሌ ባኣያ ማዖንጎ፤ ዓይጎሮ ጌዔቴ ዓሲ ናሽካሢ ዎጎ ኩንሤኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«ማቾ ሃሣ ዓኒ ማዒ ባኣያና ላሂፖ፤ ዓሲ ዎዺፖ፤ ዉኡቂፖ፤ ዓሲሮ ማዔ ባኣዚ'' ዓይጎዋ ዛጊ ሱኡካዺፖ» ጋዓ ዓይሢፆንታ ሃንጎ ዓይሢፃኣ ቢያ «ዓሲ ቢያ ኔና ማሂ ናሽኬ» ጋዓ ዬኖ ፔቴ'' ዓይሢፆ ዎጌሎ ጋራ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ዓሲ ናሽካሢ ቢያ፡ ዓሲም ፑርታ ባኣዚ'' ማዹዋሴ፤ ዬያሮ ዓሲ ናሽካሢ ዎጎ ቢያ ኩንሤኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ዓካሪ ጊንዓስካፓ ዒንሢ ጴጫንዳ ዎዳ'' ሄሌ''ሢ ዔሪጋፓ ዬያ ቢያ ማዹዋቴ፤ ዓይጎሮ ጌዔቴ ቤርታ ኑኡኒ ኪሪስቶሴ ጉሙርቄ ዎዶ''ይዳፓ ባሼ ሃሢ ኑኡኮ ዻቂንቶ ኬላ'' ኑ ባንሢ ኮሺ ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ዹማ ካራኒ ማዔሢሮ ዹሞ ማዾ'' ሃሺ''፥ ፖዖኮ ዓኣ ዖሎ ዓንጋሞ ኑ ዓርቆም። ");
INSERT INTO mdybse_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ሮኦሪና ሃንታ ዓሲጉዲ ዔሪ፥ ኮይሳ ናንጊ ኑ ናንጎም፤ ኮይሱዋ ኮሢና ማሢንቲሢና፥ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂሢ፥ ላኣሊ ዓርቃኒ ኮዒ ዑሢ ዓርቂ ዓማሊ''ሢ፥ ማርሞና ፑርታ ቂኢሩሞዋ ኑ ሃሾ''ም። ");
INSERT INTO mdybse_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ዬያይዳፓ ጎዳ ዬሱስ ኪሪስቶሴና ዎላ'' ፔቴ'' ማዑዋቴ፤ ዒንሢኮ ጎሞ ማሊፆዋ ኩንሣኒ ማሊፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ዒንሢ ባኣኮ''ይዳ ኪሪስቶሴ ጉሙርቂፆና ዶዲቱዋ፥ ላቤ'' ዓሲ ዓኣቶ ናሹሞና ዒዛ ዓዓርቁዋቴ፤ ኮይሱዋ ጎይሢና ዒዛኮ ላቤ'' ማሊፆይዳ ዎጊፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ፔቴ'' ዓሲኮ ጎሙርቂፃ፦ «ቢያ ባኣዚ'' ሙይንታኒ ኮይሳያኬ» ጋዓያ ማዓኒ ዳንዳዓኔ፤ ኪሪስቶሴ ጉሙርቂፆና ዶዲባኣሢ ጋዓንቴ ሙዓኒ ቱኮ''ናያ ሃሣ ዜርቆና ሳኣሚ ሌሊ ሙዓያ ናንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ዬያሮ ጉቤ ባኮ ሙዓሢ ሙዑዋኣሢ ቦሆፓ፤ ቱኮ'' ባኮ ሙዓሢ ጉቤ ባኮ ሙዓሢ ዑፃ ኮይሱዋ ጎይሢና «ዻቤኔ» ጌይ ዎጎፓ፤ ዎይቲ ጌዔቴ ዒዛሲያ ፆኦሲ «ኮሺኬ» ጌዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ዓካሪ ሜሌ'' ዓሲም ማዻሢ ዑፃ ዎጋንዳያ ኔኤም ኮይሱዋሴ፤ ዓይጎሮ ጌዔቴ ዒዚ ሎኦሜቴያ ዔቄቴያ ዒዛኮ ጎዳ ዔራፓኣዓቴም ኔ ባኣዚ''ቱዋሴ፤ ዒዛኮ ጎዳሢ ዒዛ ዔቂሳኒ ዳንዳዓሢሮ ዶዲ ዒ ዔቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ዬያጉዲ ሃሣ፦ «ፔቴ'' ኬላ'' ባጎ ኬላ''ፓ ባሼ ቦንቺንታያኬ» ጌይ ማላይ ናንዳኔ፤ ባጋሢ ሓሣ፦ «ቢያ ኬላ'' ሄኮ ቦንቺንታኒ ኮይሳኔ» ጌይ ማላይ ናንዳኔ። ዓካሪ ዬያጉዴ ባኮ ቢያይዳ ፔቴ'' ፔቴ''ሢ ፔ ማሊፆ ዱማሲ ዔራንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ፔቴ'' ኬሎ'' ሜሌ'' ኬላ''ፓ ባሼ ማሂ ቦንቻያ ዓኣቶ ዬያ ዒ ማዻሢ' ጎዳ ቦንቾም ጌዒኬ፤ ቢያ ባኮ ሙዓሢ ጎዳ ቦንቾም ጌዒ ሙዓኔ፤ ሙዓ ሙዖሮዋ ፆኦሲ ዒ ጋላታኔ። ቢያ ሙዖ ሙዑዋኣሢያ ፆኦሲ ቦንቾም ጌዒ ሙዑዋሴ፤ ዒ ሙዑዋዖ ሃሺ''ፆና ፆኦሲ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ኑጊዳፓ ዖና ማዔቴያ ፔኤሮ ናንጋያና ፔኤሮ ሓይቃይ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ኑኡኒ ናንጌቴያ ጎዳ ዬሱሴም፥ ሓይቄቴያ ጎዳ ዬሱሴምኬ፤ ዬያሮ ኑ ናንጌቴያ ሓይቄቴያ ጎዳ ዬሱሴሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ዓይጎሮ ጌዔቴ ኪሪስቶሴ ሓይቂ ሓይባ''ፓ ዔቄሢ' ሼምፖና ናንጋ ዓሶና ሓይቄቴያ ናንጊና ናንጋ ዓሶኮ ጎዳ ማዓኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ሂዴቴ ፔቴ''ይ ሜሌ''ሢ ዑፃ ዓይጎሮ ኮይሱዋ ጎይሢና ዎጋይ? ሃሣ ፔቴ''ሢ ባጋሢ ዓይጎሮ ቦሃይ? ኑኡኒ ቢያሢ ፆኦሲ' ዎጎ ዎጋ ቤዞ ሺኢካንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ዎይቲ ጌዔቴ ጎዳ፦ «ታኣኒ ናንጊና ባይቁዋ ፆኦሲኬ፤ ዓሲ ቢያ ታ ቤርታ ጉምዓቲ ፔ ዻንጎና ታኣኒ ፆኦሲ ማዔሢ ማርካዻንዳኔ» ጋዓኔ ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ዬያሮ ኑ ፔቴ'' ፔቴ''ሢ ኑ ማዾ'' ዛሎ'' ፆኦሲ ቤርቶ ሺኢኪ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ዓካሪ ኑጊዳፓ ፔቴ''ይ ባጋሢዳ ኮይሱዋ ጎይሢና ዎጊፆ ሃሾ''ንጎ፤ ሓሣ ዓሲ ዹቂሲ ጎማሲሳ ባኣዚ'' ማዺሢዳፓ ካፒንቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ጎዳ ዬሱስ ኪሪስቶሴ ዓሲ ታ ማዔ ጎይፆና ሙኡዚዳ ሙይንታኒ ኮይሱዋ ሙኡዚ'' ባኣሢ ታ ዔሬኔ፤ ጋዓንቴ ፔቴ'' ዓሲ ፔቴ'' ባኣዚ'' «ሙይንታኒ ኮይሱዋ ባኣዚ''ኬ» ጌዒ ማላያ ማዔቴ ዬና'' ባኬላ ዒዛም ሙይንታኒ ኮይሱዋ ባኣዚ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ሙኡዚ'' ዛላና ኔ ዒሻሢ ኔ ማሊሺ ዖዪሳያ ማዔቴ ናሹሞና ዒዛና ኔ ናንጋያቱዋሴ፤ ዬያሮ ኪሪስቶሴ ዒዛም ሓይቄ ዓሢ፥ ኔ ሙዓ ሙዖ ዛሎ''ና ጎማሲ ባይዚፖ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ዓካሪ ዒንሢም ኮሺ ማዔ ባኮ ሜሌ'' ዓሳ ቦሃንዳጉዲ ማሂፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ፆኦሲ ካኣቱማ ዓያና ጌኤሺ ዛሎ''ና ጴዻ ፂሉ''ሞ፥ ኮሹሞና ዎዛና ማዓንዳኣፓዓቴም ሙኡዚ''ና ዑሺና ዛላ ባኣዚ''ቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ዬያ ዱማሲ ዔሪ ኪሪስቶሴም ማዻ ዓሲ ፆኦሲ ዎዛሳንዳኔ፤ ዓሲ ቤርቲዳኣ ጋላቲንቴያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ዬያሮ ኮሹሞ ጴዻያ፥ ሓሣ ዎሊያ ሴካና ሃንጋና ዶዲሻያ ማዔ ባኣዚ'' ኑ ማዾም። ");
INSERT INTO mdybse_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ሙኡዚ'' ዛላና ፆኦሲ ማዾ'' ኑ ባይዚባኣቴ ኮሺኬ፤ ሙኡዚ'' ቢያ ሙይንታኒ ኮይሳያኬ፤ ጋዓንቴ ሜሌ'' ዓሲ ዹቂ ጎማሲሳ ሙኡዚ'' ሙዒሢ ዻቢንቲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ዓሲ ዹቂ ዻቢሻ ባኣዚ'' ማዔቴ ዓሽኪ ሙዒሢንታ ዳጋሢ ዑሺንታ ሃሣ ዬያጉዴ ሜሌ'' ባኮዋ ሃሺ''ፃ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ዓካሪ፤ ዬያ ኔኤኮ ጉሙርቂፆ ኔኤና ፆኦሲና ሌሊ ዔራያ ማዖንጎ፤ ዓይጎሮ ጌዔቴ «ፒዜኬ» ጌይ ዒ ማዻ ባኮ ዒና'' ዒዛኮ «ኔ ዻቤኔ» ጎዑዋ ዓሲ ጋላቲንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ሙኡዚ'' ዓልቲ ዓልቲ ሙዓ ዓሲ ጋዓንቴ ጉሙርቂሢና ዒ ሙዑዋኣሢሮ ፆኦሲ ዒዛይዳ ሜቶ ሄሊ''ሳንዳኔ፤ ዎይቲ ጌዔቴ ጉሙርቂሢና ማዺንቲባኣ ባኣዚ'' ቢያ ጎሜኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ኑኡኒ ኪሪስቶሴ ጉሙርቂፆና ዶዲ ማዔ ዓሳ ጉሙርቂፆና ላቤ'' ዓሶኮ ላቢ''ፆ ዔሪ ማኣዳ''ያ ማዓንዳኣፓዓቴም ኑና ኑ ዎዛሳያ ማዓኒ ኮይሱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ኑኡኒ ፔቴ'' ፔቴ''ሢ ሜሌ''ሢ ፆኦሲ ጉሙርቂፆና ዶዳንዳጉዲ ሜሌ'' ዓሢ ማኣዳ''ኒ ዒዛ ዎዛሳ ባኣዚ'' ኑ ማዾም። ");
INSERT INTO mdybse_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ዓይጎሮ ጌዔቴ ኪሪስቶሴ ፔና ዎዛሲባኣሴ፤ ጋዓንቴ «ኔና ጫሽኮና ጫዣ ታና ሄሌ''ኔ» ጌይንቲ ፃኣፒንቴሢ ዒዛይዳ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ጌኤዦ ማፃኣፓፓ ኑ ዴንቃ ጊቢ'' ዳንዳዒፆና ዶዲፆና ሃጊ ማዓንዳ ዎዛ ኑኡኮ ዓኣያ ኑና ማሃንዳጉዲ ቤርታዺ ፃኣፒንቴ ባካ ቢያ ዔራቶ ኑ ዴንቃንዳጉዲ ኑም ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ዒንሢ ዬሱስ ኪሪስቶሴ ጊንፆ ሃንታዞንሢ ማዔሢሮ ጊቢ'' ዳንዳዓሢና ዶዲሢና ዒንጋ፥ ጎዳ ፔቱሞ ዓያና ዒንሢም ዒንጎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ዬይ ኑ ጎዳ ዬሱስ ኪሪስቶሴኮ ዓዶ ማዔ ፆኦዛሢ ፔቴ'' ዒናና ፔቴ'' ዑኡሲና ዒንሢ ዒዛ ቦንቻንዳጉዲ ማሆንጎ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ኪሪስቶሴ ዒንሢ ቦንቺ ዔኬሢጉዲ ዒንሢያ ዎሊ ፆኦሲ ቦንቾም ጌዒ ቦንቹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ሓይ ታ ኬኤዛሢ ቤርታ ኑ ዓዶንሢም ዒንጊንቴ ሃጊ ማዓንዳ ዎዛ'' ኩማንዳጉዲና ፆኦሲኮዋ ጉሙርቂንቲፃ ዔርታንዳጉዲ ኪሪስቶሴ ዓይሁዴ ማዒባኣ ዓሶም ማዻያ ማዔኔ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ኪሪስቶሴ ዓይሁዴ ማዒባኣ ዓሶም ማዻያ ማዔ ሜሌ'' ጎይፃ ዓይሁዴ ማዒባኣ ዓሳ ፆኦሲኮ ማኣሪፆ ዛሎ'' ጋላታንዳጉዲኬ፤ ዬይያ፦ «ዓይሁዴ ማዒባኣ ዓሶ ባኣካ'' ታ ኔና ጋላታኔ፤ ኔ ሱንፆዋ ዓይኑሞና ታ ጋላታኔ» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ሓሣ፦ «ዒንሢ ዓይሁዴ ማዒባኣ ዓሳ ፆኦሲ ዶኦሬ ዴሮ''ና ዎላ'' ዎዛዹዋቴ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ላሚ ሃሣ፦ «ዓይሁዴ ማዒባኣ ዓሳ ቢያ ፆኦሲ ጋላቱዋቴ፤ ዴራ''ኣ ቢያ ፆኦሲ ጋላቱዋቴ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ዬያጉዲ ዒሲያሴ፦ «ዴሮ'' ቢያ ዑፃ ካኣታዻንዳያ ዒሴዬ ዜርፃፓ ሾይንታንዳኔ፤ ዒዛይዳ ዓይሁዴ ማዒባኣ ዓሳ ሃጊ ማዓንዳ ዎዛ ጌሣንዳኔ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ዒንሢኮ ሃጊ ማዓንዳ ዎዛ'' ዓያኖ ጌኤዦ ዎልቆና ዲጪ ዲጪ ዓኣዻንዳጉዲ ሃጊ ማዓንዳ ዎዞ ዒንጋ፥ ጎዳ ዒንሢ ጉሙርቄሢሮ ዎዛና ኮሹሞና ሚርጊሺ ዒንሢም ዒንጎም። ");
INSERT INTO mdybse_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ታ ዒሾንሦ! ታ ሚሾንሦ! ሚርጌና ዒንሢ ኮሺ ማዔሢ ሃሣ ሚርጌና ዒንሢ ዔራያ ማዔሢና ፔቴ'' ፔቴ''ሢ ሜሌ''ሢ ዞራኒ ዳንዳዓያ ማዔሢ ጎኔና ታ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ፔቴ'' ፔቴ'' ባኣዚ'' ታ ዒንሢም ጶቂሣኒ ኮዒ ሃያ ኪኢቶ'' ጫርቂ ታ ዒንሢም ፃኣፔሢ' ፆኦሲ ታኣም ፔ ኮሹሞና ዒንጌ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ዬይ ኮሹሞ ዒንጊፃ ታኣም ዒንጊንቴሢ ፆኦሲኮ ኮዦ ሓይሶ ዓይሁዴ ማዒባኣ ዓሶም ቄኤሴ ማዒ ኬኤዚ፥ ዬሱስ ኪሪስቶሴም ማዻንዳጉዲኬ፤ ዬያሮ ዓይሁዴ ማዒባኣ ዓሳ ዓያና ጌኤሺና ፆኦሲም ዱማዼያ ሃሣ ፆኦሲ ዎዛሳያ ማዓ ፆኦሲም ዒንጎ ባኣዚ'' ማዒ ዒንጊንታንዳጉዲ ታ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ታኣኒ ዬሱስ ኪሪስቶሴና ማዒ ፆኦሲም ማዻኒ ዳንዳዒፆና ዖቶርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ታኣኒ ዖቶርቃሢ ታ ኬኤዛ ባኮና ማዻ ማዾ'' ዛሎ''ና ዓይሁዴ ማዒባኣ ዓሳ ፆኦሲም ዓይሢንታንዳጉዲ ኪሪስቶሴ ማሄሢሮ ሌሊኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ዬያጉዲ ሃሣ ኪሪስቶሴ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ማዾንታ ዲቃሣ ማዾዋ ዓያኖ ጌኤዦ ዎልቆና ማዺ ዓይሁዴ ማዒባኣ ዓሳ ዓይሢንታንዳጉዲ ማሄሢሮ ታ ዖቶርቃኔ፤ ዬያይዲፆና ዬሩሳላሜይዳፓ ዴንዲ ዔልዋሪቆኔ ሄላ''ንዳኣና ሓንቲ ሓንቲ ኪሪስቶሴኮ ኮዦ ሓይሶ ታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ቢያ ኬሊ'' ታ ማላሢ ሜሌ'' ዓሲ ቦኦኮልቄያይዳ ማዢሢ ማዒባኣንቴ ኪሪስቶሴኮ ሱ'ንፃ ዋይዚንቲባኣ ቤስካ ቢያ ኮዦ ሓይሶ ኬኤዛኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ዬያ ታ ማዻሢ፦ «ዒዛ ዛሎ'' ኬኤዚንቲ ቤቂባኣ ዓሳ፥ ዒዛ ዛጋንዳኔ፤ ዒዛ ዛሎ'' ዋይዚ ቤቂባኣ ዓሳኣ ጶቂሢ ዔራንዳኔ» ጌይንቲ ፃኣፒንቴ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ሃኖ'' ሄላ''ንዳኣና ዒንሢ ኮይላ'' ታ ሙካኒ ዳንዳዒባኣሢ ታ ዒንሢም ኬኤዜ ጎይፆና ጊኢጊባኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ሓሢ ታ ሃካ ዓኣ ማዾ'' ኩርሴሢሮ ሃሣ ሚርጌ ሌዔፓ ዓርቂ ዒንሢ ዛጋኒ ሚርጌና ታ ኮዓሢሮ፥ ");
INSERT INTO mdybse_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ዒስፔኔ ዓጮ'' ታ ዴንዳዖ ዒንሢያ ዒኢና ዛጊ ዓኣዻኒ ማሌኔ። ዒኢካ ዻካ'' ዒንሢና ዎላ'' ታ ዴዔስካፓ ጎይፆ ታ ዓኣዻንዳጉዲ ታኣም ኮይሳ ማኣዶ ዒንሢ ማኣዳ''ንዳሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ሓሢ ጋዓንቴ ኪሪስቶሴ ጉሙርቃ ዓሶም ዒንጊንታ፥ ማኣዶ ሚኢሼ ዔኪ ዬሩሳላሜ ታ ዴንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ዓይጎሮ ጌዔቴ ሜቄዶኒያና ዓካይያ ጌይንታ ዓጮ''ይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሳ ዬሩሳላሜይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶ ባኣካ'' ዓኣ ማንቆ ዓሶም ሚኢሼ ማኣዶ ዳካኒ ማሌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ሓያ ማኣዳሢ ዔያታ ፔ ማሊሢና ዒንጌሢ' ዔያቶ ኮይሳያ ማዔምኬ፤ ዎይቲ ጌዔቴ ዓይሁዴ ማዒባኣ ዓሳ ዓይሁዴ ዓሶና ዎላ'' ዓያኖ ዓንጆ ዴንቃያ ማዔሢሮ ዓይሁዴ ማዒባኣ ዓሳ ሳዖ ዓንጆ ዒንጊ ዓይሁዴ ዓሶ ማኣዳ''ኒ ኮይሳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ዬያሮ ሃያ፥ ቡኩሶና ማኣዳሢ ሚኢሾ ዬሩሳላሜ ዔኪ ዓኣዺ ታ ዒንጌሢኮ ጊንፃ ዒስፔኔ ዓጮ'' ዴንዳዖ ዒንሢ ዬማና ታ ዛጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ዒንሢ ኮይላ'' ታ ሙካኣና ኪሪስቶሴ ዛሎ''ና ማዓ ዓንጆ ሚርጌና ታ ዒንሢም ዔኪ ሙካንዳሢ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዛሎ'' ታኣና ዎላ'' ዶዲ ፆኦሲ ሺኢጲሢና ታና ዒንሢ ማኣዳ''ንዳጉዲ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴና ዓያኖ ጌኤዦናኮ ናሹሞና ታ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ዒንሢ ታኣም ሺኢቃንዳሢ' ዪሁዳ ዓጮ''ይዳ ዓኣ ኪሪስቶሴ ጉሙርቁዋ ዓሶይዳፓ ፆኦሲ ታና ካፓንዳጉዲና ዬሩሳላሜይዳ ታ ማዻንዳ ማዻ'' ኪሪስቶሴ ጉሙርቃ ዓሶ ዎዛሳንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ሓሣ ያዺ ማዔሢኮ ጊንፃ ፆኦሲ ማሊሢ ማዔም ዒንሢ ኮይላ'' ታ ዎዛና ዬዒ፥ ዒንሢና ዎላ'' ዴዒ ሃውሻንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ኮሹሞ ዒንጋ፥ ፆኦዛሢ ዒንሢ ቢያሢና ዎላ'' ማዖንጎ፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ኪንክሪያ ካታሞይዳ ዓኣ ሺኢጲፆ ማኣራ ማዻ ኑ ሚሼሎ ፔቤኔ ዛሎ'' ታ ዒንሢ ሺኢቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ዒዛ ታናንታ ሜሌ'' ሚርጌ ዓሲ ማኣዳ''ያ ማዔሢሮ ፆኦሲ ዓሲ ሾኦቺንሣኒ ኮይሳ ጎይፆና ጎዳ ሱንፆና ሾኦቺንሢ ዔኪ ዒዞም ኮይሳ ባኮና ቢያ ዒንሢ ዒዞ ማኣዳ''ንዳጉዲ ታ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ዬሱስ ኪሪስቶሴም ማዺፆና ታኣና ዎላ'' ፔቴ'' ማዔ፥ ጲርስቂላና ዓቂላናም «ኮሺዳ?» ጌዔኔ ጎውዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ዔያታ ታ ዛሎ''ሮ ሓይቃኒያ ጌዔ ዓሲኬ፤ ዬያሮ ቢያ ዎዴ ታ ዔያቶም «ፆኦሲ ዒንጎም» ጋዓኔ፤ ዬያ ታ ሌሊቱዋንቴ ዓይሁዴ ማዒባኣ ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሳኣ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ሓሣ ዔያቶ ማኣሮይዳ ሺኢቃኒ ቡካ፥ ኪሪስቶሴ ጉሙርቃ ዓሶም፤ ዒሲያ ዓጮ''ይዳፓ ቤርታዺ ኪሪስቶሴ ጉሙርቄያ፥ ታ ዒዛ ናሽካ ዔፖኖቶሴም «ኮሺዳ?» ጋዓኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ዒንሢም ሚርጌና ላቤ'' ማይራሞማኣ «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ሃሣ ታኣና ዎላ'' ቱኡቴዞንሢንታ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢ ባኣካ'' ዔርቴያ ዓይሁዴ ማዔ፥ ታ ዒጊኖንሢ፥ ዓንዲሮኒቆሴና ዩኒያሴናም «ኮሺዳ?» ጎውዋቴ። ዔያታ ኪሪስቶሴ ጉሙርቂፆና ታና ቢራያኬ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ጎዳ ሱንፆና ታ ናሽካ ዓንፒሊያቶሴማኣ «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ኪሪስቶሴ ማዾ'' ማዺፆና ኑኡና ዎላ'' ፔቴ'' ማዔ፥ ዑርባኖሴና ታኣኒ ናሽካ፥ ዒስፃኩሴናም «ኮሺዳ?» ጋዓኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ኪሪስቶሴ ዒ ጉሙርቃሢ ዛጊንቲ ዔርቴም «ጎኔኬ» ጌይንቴ፥ ዓፒሊሴም ሃሣ ዓርፄቡሎሴ ማኣሮ ዓሶፓ ማዔዞንሢማ «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ዓይሁዴ ዓሲ ማዔ፥ ታ ዒጊናሢ ሄሮዲዮኔም፤ ሃሣ ጎዳ ጉሙርቃ ናርሴሴ ማኣሮ ዓሶማኣ «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ጎዳ ማዾ'' ማዺ ላባ'' ቲሩፓይኖና ቲሩፖሶ ጌይንታ ላኣሎንሢም፤ ሓሣ ሚርጌና ላቢ'' ማዼ፥ ኪሪስቶሴ ሱ'ንፆና ታ ናሽካ ፒሪሲሳ ጎዖዜሎም «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ጎዳ ማዾ'' ማዺፆና ዔርቴ ሩፖሴም ሓሣ ታና ፔናጉዲ ማሂ ናሽካ ዒዛኮ ዒንዶማኣ «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ዓስኪራቶሴና ፒሌጎዖኔናም፥ ሄርሜሴም፥ ፓትሮባሴም፥ ሄርማሴም ሓሣ ዔያቶና ዎላ'' ዓኣ ኪሪስቶሴ ጉሙርቃ ዒሾንሢንታ ሚሾንሢታም «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ፒሎጎሴም፥ ዩሊያም፥ ኔሪያና ዒዛኮ ጌሮናም ሓሣ ዖሎምሴና ዒዛና ዎላ'' ዓኣ ኪሪስቶሴ ጉሙርቃዞንሢም ቢያ «ኮሺዳ?» ጌዔኔ፤ ጎውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ዎሊኮ ጌርሲንሢጉዲ፥ ናሹሞና ዎሊ ሄርቂ ዔኤሊ''ንቱዋቴ። ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሳ ቢያ ዒንሢ «ኮሺዳ?» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ታ ዒሾንሦ! ታ ሚሾንሦ! ዒንሢኮ ባኣካ'' ዒንሢ ዱማሳያና ዒንሢ ኪሪስቶሴ ጉሙርቂፆና ዶዱዋጉዲ ማሃ ዓሶይዳፓ ዒንሢና ካፑዋቴ፤ ዒንሢ ዋይዚ ዔኬ ዔራቶ'' ዔያታ ዒፃያ ማዔሢሮ ዔያቶይዳፓ ዱማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ዬያጉዴ ዓሳ ፔኤኮ ፑርቶ ማሊፆ ኩንሣያኬ፤ ኑ ጎዳሢ ኪሪስቶሴም ማዻያቱዋሴ፤ ዔያታ ኮሺ ጌስታያ ማሊ፥ ጌሺሢ ሓይሴና ዒና'' ፂሎ'' ማዔ፥ ኮዦ ዓሶ ጌሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ዒንሢ ኮዦ ሓይሶ ዋይዚ ዔኪ ዓይሢንታያ ማዔሢ ዓሳ ቢያ ዔራሢሮ ታና ኮሺ'' ዎዛሳኔ። ጋዓንቴ ኮሺ ባኣዚ''ም ጪንጫ፤ ፑርታ ባኣዚ''ም ጋዓንቴ ዔኤቢ ዔሩዋ ዓሲ ዒንሢ ማዓንዳጉዲ ታ ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ዒንሢ ዬያይዴቴ ኮሹሞ ዒንጋ ፆኦዛሢ ፃላሄ ዒንሢኮ ቶኮ ዴማ ዓጊ ሄ'ርቂ ዳኣፃንዳኔ። ጎዳ ዬሱስ ኪሪስቶሴኮ ኮሹሞ ዒንጊፃ ዒንሢና ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ታኣና ዎላ'' ማዻ ፂሞቴዎሴንታ ኑ ዜርፆ፥ ዓይሁዴ ማዔ፥ ሉቂዮሴንታ ዒያሱኔንታ ዬያጉዲ ሃሣ ሶስጳፂሮሴያ «ኮሺዳ?» ዒንሢ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ሓያ ኪኢቶ'' ፃኣፓሢ፥ ታኣኒ ፄፄሪዮሴያ ጎዳ ሱ'ንፆና ዒንሢ «ኮሺዳ?» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ታና ሃሣ ሾኦቺንሣሢና ሃይካ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶዋ ፔ ማኣሮይዳ ቡኪ ሺኢቃንዳጉዲ ማሃ፥ ጋይዮሴንታ ሃኖ' ካታሜሎኮ ሚኢሾ ዓርቃያ ማዔ፥ ዔራስፆሴንታ ኑ ዒሻሢ ቁዋርፆሴንታ ዒንሢ «ኮሺዳ?» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ጎዳ ዬሱስ ኪሪስቶሴኮ ኮሹሞ ዒንጊፃ ዒንሢ ቢያሢም ማዖንጎ፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ዓካሪ ፆኦሲም ጋላታ ሄሎንጎ! ሚርጌ ሌዔ ዓኣሺንቲ ዓኣዖ ሃሢ ታኣኒ ዬሱስ ኪሪስቶሴ ዛሎ'' ኬኤዛ፥ ኮዦ ሓይሶና ፔጋዼ ጎኑሞና ዶዲ ዒንሢ ዔቃንዳጉዲ ፆኦሲ ዒንሢ ማሃኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ሓሢ ጋዓንቴ ዬይ ጎኑማ ፆኦሲ ማሊፆ ኬኤዛ ዓሶ ማፃኣፖ ዛሎ''ና ፔጋዺ ጴዼኔ፤ ቢያሢ ጉሙርቂ ዓይሢንታንዳጉዲ ናንጊና ናንጋ ፆኦዛሢ ዓይሤም ዴሬ ቢያ ዔራንዳጉዲ ዬይ ማዺንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ዒዚ ሌሊ ዔራ ማዔ፥ ፔቴ'' ፆኦዛሢም ዬሱስ ኪሪስቶሴ ዛሎ''ና ናንጊና ቦንቾ ማዖንጎ! ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ፆኦሲ ማሊሢና ዬሱስ ኪሪስቶሴም ዳኪንቲ ማዻያ ማዒ፥ ዔኤሊ''ንቴ ጳውሎሴና ኑ ዒሻሢ ሶስቴንሴናይዳፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ዬሱስ ኪሪስቶሴና ዎላ'' ዔያቶኮ ዓኣ ፔቱሞና ዔያቶና ኑኡናናኮ ጎዳ ማዔ፥ ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴ ቢያ ቤዛ ካኣሽካ ኪሪስቶሴ ጉሙርቃ ዓሶና ዎላ'' ፆኦሲም ዱማዼ ዴሬ ማዓንዳጉዲ ዔኤሊ''ንቴ ቆሮንቶሴይዳ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶም ቢያ፥ ");
INSERT INTO mdybse_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ኑ ዓዳሢ፥ ፆኦዛሢና ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴናይዳፓ ዒንጊንታ ዒንጊፆና ኮሹሞና ዒንሢም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ዬሱስ ኪሪስቶሴ ዛሎ''ና ፆኦሲ ፔኤኮ ኮሹሞ ዒንጊፆ ዒንሢም ዒንጌሢሮ ዒንሢ ዛሎ''ሮ ቢያ ዎዴ ታ ዒዛ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ዓይጎሮ ጌዔቴ ጌኤሲና ሃሣ ዔራቶና ኪሪስቶሴና ማዒ ዒንሢ ሚርጌ ባኣዚ'' ዔሬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ኪሪስቶሴ ዛሎ'' ኑ ዒንሢም ማርካዼ ማርካታ'' ዒንሢኮ ዒና'' ዶዲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ዬያሮ ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴኮ ሙኪፆ ካፒ ካፒ ዒንሢ ናንጌቴ ዓይጎጉዴ ዓያና ዒንጊሢ ማዔቴያ ዒንሢም ፓጫዓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴ ማዒ ሙካ ኬሎ''ና ዾንኪሳ ባኣዚ'' ባኣያ ማዒ ዒንሢ ጴዻንዳጉዲ ዒዚ ዒንሢ ጋፒንፆ ሄላ''ንዳኣና ዶዲ ናንጋንዳጉዲ ማሃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ፔኤኮ ናዓሢ፥ ኑ ጎዳ፥ ዬሱስ ኪሪስቶሴና ዎላ'' ፔቱሞ ዒንሢኮ ዓኣያ ማዓንዳጉዲ ዒንሢ ዔኤሌ'' ፆኦዛሢ ጉሙርቂንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ታ ዒሾንሦ፥ ታ ሚሾንሦ! «ዒንሢ ባኣካ'' ዱማዺሢ ጴዾፓ፤ ቢያሢ ዎላ'' ጊኢጊ፥ ፔቴ'' ማሊሢና ፔቴ'' ዒናና ዓኣያ ማዒ ዶዲ ናንጉዋቴ» ጌይ ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ታ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ታ ዒሾንሦ፥ ታ ሚሾንሦ! ዒንሢ ባኣካ'' ማርሞና ፓቂንቲሢና ዓኣሢ ቄሎዔ ማኣሮ ዓሶይዳፓ ታ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ታ ዋይዜ ጎይፃ ዒንሢ ፔቴ'' ፔቴ''ሢ፦ «ታኣኒ ጳውሎሴ ዓሲኬ፤ ታኣኒ ዓጲሎሴ ዓሲኬ፤ ታኣኒ ኬፓ ዓሲኬ» ጋዓዛ፥ ዛላ''፦ «ታኣኒ ኪሪስቶሴ ዓሲኬ» ጋዓኔ፥ ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ሂዳዖ ኪሪስቶሴ ፓቂንቴኔ ጌይሢዳ? ጳውሎሴ ዒንሢ ዛሎ'' ሱፂንቲ ሃይቂያ? ሃሣ ዒንሢ ዋኣፆና ማስቴሢ ጳውሎሴ ሱ'ንፆናዳ? ");
INSERT INTO mdybse_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ታኣኒ ቄሪስጶሴና ጋይዮሴናይዳፓ ዓታዛ ዒንሢዳፓ ዖናኣ ዋኣሢና ማስኪባኣሢሮ ፆኦሲ ታ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ዬያሮ «ጳውሎሴ ሱ'ንፆና ታ ዋኣፆ ማስቴኔ» ጌዒ ኬኤዛንዳይ ዒንሢዳፓ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ጎኔኬ፤ ዒስፂፓኖሴ ማኣሮ ዓሶ ታ ማስኬኔ፤ ያቶይዳፓ ዓታዛ ሜሌ'' ዓሲ ታ ማስኬያ ዓኣሢ ታኣም ዔርቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ኪሪስቶሴ ታና ዳኬሢ' ዒዛኮ ኮዦ ሃይሶ ቃኣሎ'' ኬኤዛንዳጉዲኬ፤ ዋኣሢና ታ ማስካንዳጉዲቱዋሴ፤ ኪሪስቶሴኮ ፑርቶ ዓሶ ሱፆ ሚፃ ሱፂንቲ ሃይቂፃ ጉሪ ማዒ ዓቱዋጉዲ ዒዛኮ ኮዦ ሃይሶ ቃኣሎ'' ታ ኬኤዛሢ ዓሲዳፓ ማዔ፥ ጌኤሲ ዔራቶናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","«ኪሪስቶሴ ፑርቶ ዓሶ ሱፆ ሚፆ ዑፃ ሱፂንቲ ሃይቄኔ» ጋዓ ቃኣላ'' ባይቃኒ ጊኢጌ ዓሶም ዔኤያቶ ማዒ ዛጊንታኔ፤ ኑና ዻቃ ዓሶም ጋዓንቴ ፆኦሲ ዎልቄኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ዓይጎሮ ጌዔቴ፦ «ዔሮ'' ዓሶኮ ዔራቶ'' ታ ባይዛንዳኔ፤ ዑሣ ዓኣዼ ዔሮ''ኮ ዔራቶ'' ታ ጉሪ ማሃንዳኔ» ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ዓካሪ ዔራ''ሢ ዎካ ዓኣይ? ዑሣ ዓኣዼ ዔራሢያ ዎካዳይ? ሃሣ ቢያ ባኮ ዛጊ፥ ዱማሲ ዔራሢያ ዎካ ዓኣይ? ፆኦሲ ሃያ ዓጮ'' ዔራቶ'' ዔኤያቶ ማሂባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ሃያ ዓጮ'' ዓሳ ፔ ዔራቶና ፆኦሲ ዔራኒ ዳንዳዑዋጉዲ፥ ፆኦሲ ፔ ዔራቶና ዔያታ ዔሩዋጉዲ ማሄኔ፤ ጋዓንቴ ዓጮ'' ሃያም ዔኤያቶ ማዒ ፓይዲንቴ፥ ኑ ኬኤዛ ኮዦ ሃይሶ ኪኢታ'' ጉሙርቃዞንሢ ዻቂሻንዳጉዲ ፆኦሲ ማሊሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ዒንሢ ዔራሢጉዲ ዓይሁዶ ዓሳ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ዛጋኒ ኮዓኔ፤ ሃሣ ዓይሁዴ ማዒባኣ ጊሪኮ ዓሳ ዔራቶ ዔራኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ኑኡኒ ጋዓንቴ ሱፂንቲ ሃይቄ ኪሪስቶሴ ዛሎ'' ኬኤዛኔ፤ ዬይ ኑኡኒ ኬኤዛ ሃይሳ፦ ዓይሁዶ ዓሶም ዔርቶ ዒፂ ዻቢሻያና ዓይሁዴ ማዒባኣ ጊሪኬ ዓሶም ዔኤያቶኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ፆኦሲ ዔኤሌ''፥ ዓይሁዴ ማዔቴያ ዓይሁዴ ማዒባኣ ጊሪኬ ዓሶም ጋዓንቴ ኪሪስቶሴ ፆኦሲኮ ዎልቄና ዔራቶናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ዎይቲ ጌዔቴ ፆኦሲ ዔዔኤዬኔ ጎዖዛ፥ ዬይ ዓሲ ዔራቶይዳፓ ባሼኬ፤ ሃሣ ፆኦሲ ላላቤኔ ጎዖዛ፥ ዓሲ ዎልቄይዳፓ ባሼ ማዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ታ ዒሾንሦ ታ ሚሾንሦ! ፆኦሲ ዒንሢ ዔኤላ'' ዎዶ''ና ዒንሢ ዎዚጉዴ ዓሲታቴ ሂንዳ ማሉዋቴ፤ ዓሲ ማላ ጎይሢና ዒንሢ ባኣካ'' ሚርጌሢ ዔራ ዓሲ፥ ዎልቄና ዓኣ ዓሲ ሃሣ ዼኤፒ ዼኤፒ ጌይንታ ዓሲ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ጋዓንቴ ፆኦሲ ዔሮ'' ዓሶ ቦርሲሳኒ ዓጮ''ይዳ ዔኤያኬ ጎዖ ዓሶ ዶኦሬኔ፤ ሃሣ ዎልቄና ዓኣ ዓሶ ቦርሲሳኒ ዓጮ''ይዳ ላቤ''ያ ማዒ ፓይዲንታዞንሢ ዶኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ዓጮ'' ዓሶም ቦንቺንቴያ ማዒ ጴዻ ባኮ ባይዛኒ ዓጮ''ይዳ ቦሂንቴያ፥ ጉሪ ማዔያ ሃሣ ቤሲ ባኣ ባኮ ዶኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ዬያ ፆኦሲ ማዼሢ' ዓይጎ ዓሲያ ዒዛ ቤርታ ዖቶርቁዋጉዲኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ዒንሢ ጋዓንቴ ፆኦሲ ዬሱስ ኪሪስቶሴና ዎላ'' ፔቱሞ ዓኣያ ማዓንዳጉዲ ማሄኔ። ዬያሮ ኑኡኮ ዔራታ''፥ ፂሉ''ማ፥ ኑኡኮ ፆኦሲም ዱማዼያ ማዒፃ፤ ሃሣ ኑና ዻቂሻያ ማዓሢያ ዬሱስ ኪሪስቶሴ ማዓንዳጉዲ ፆኦሲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ዓካሪ ጌኤዦ ማፃኣፓ ጋዓሢጉዲ፦ «ዖቶርቃሢ ፆኦሲና ዖቶርቆንጎ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ታኣኒ ዒንሢ ኮይላ'' ሙኬያና ፆኦሲኮ ዓኣሺንቴ ማሊፆ ታ ዒንሢ ዔርዜኔ፤ ታኣኒ ሓይሴ ዔሪ ጌስታያ ማዔሢና ታኣኮ ዓኣ ዔራቶና ዒንሢም ዻዋኒ ታ ኮዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ዓይጎሮ ጌዔቴ ዒንሢና ታ ዓኣ ዎዶ''ማና ዬሱስ ኪሪስቶሴ ዛሎ''ና ሃሣ ዒዛኮ ሱፂንቲ ሃይቦ'' ዛሎ''ይዳፓ ዓታዛ ሜሌ'' ዓይጎዋ ዔሩዋያ ማዓኒ ታ ማሌሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ዬያሮ ዒንሢ ኮራ ታ ዓኣ ዎዶ''ና ላቤ'' ዓሲ ማዒ፥ ዒጊቹሞና ሚርጌ ጎጋይቂሢናይዳ ታ ዓኣያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ታኣኒ ኬኤዜሢታቴያ ዔርዜ ቃኣላ'' ፆኦሲ ዓያናና ማኣዲ''ንቲ ማዓንዳኣፓዓቴም ዓሲ ዔራቶና ዑሣ ዓኣዼ ዔራቶና ሃሣ ሃይሴ ኮሺ''ሢናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ዬያ ታኣኒ ማዼሢ ዒንሢኮ ፆኦሲ ጉሙርቂፃ ዓሲ ዔራቶና ማዒባኣዖ፥ ፆኦሲ ዎልቄና ማዔያ ማዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ጋዓንቴ ዓያኖ ናንጎና ዶዴ ዓሶም ዔራቶና ኑ ኬኤዛኔ፤ ኑኡኒ ኬኤዛ ዔራታ''፦ ሃያ ዓጮ'' ዔራቶ ሃሣ ጋፒንፃ ባይሲንታ ማዔ፥ ሃያ ዓጮ'' ዎይሣ ዓሶ ዔራቶናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ኑኡኒ ኬኤዛ ዔራታ'' ጋዓንቴ ፆኦሲ ቤርታዺ ሚርጌ ዎዴኮ ቤርታኣፓ ኑ ቦንቾም ጌዒ ጊኢጊሼ፥ ፆኦሲኮ ዓኣሺንቲ ዓኣ ዔራቶኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ሓያ ዓጮ'' ዎይሣ ዓሶ ባኣካ''ፓ ዬያ ዔራቶ ዔሬይ ዖኦኒያ ባኣሴ፤ ዎንዴ ዔያታ ዬያ ዔሬያ ማዔቴ ቦንቺንቴ፥ ጎዳሢ ሱፂ ዔያታ ዎዺንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ዬይ ያዺ ማዔቴያ ጌኤዦ ማፃኣፓ፦ «ዓሲኮ ዓኣፒ ዴንቂባኣያ ዋይዚ ዋይዚባኣያ ሃሣ ዒናኣ ማሊባኣያ ፆኦሲ ዒዛ ናሽካዞንሢም ጊኢጊሼኔ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ኑም ጋዓንቴ ፆኦሲ ፔኤኮ ዓያኖ ዛሎ''ና ዓኣሺንቴ ማሊፆ ፔጋሲ ዔርዜኔ። ዓይጎሮ ጌዔቴ ፆኦሲኮ ዓያና'' ዔርቱዋያ ማዔ፥ ፆኦሲ ማሊፆታዖ ዓይሱዋዖ ቢያ ባኣዚ'' ዴንቂ ዔራሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ፔቴ'' ዓሲ ዛላ ማዔቴ ፔቴ'' ዒዛ ዓሢ ዓያናፓ ዓታዛ ሜሌ'' ዒዛይዳ ዓኣ ዒዛኮ ማሊፆ ዔራንዳይ ዖኦኒያ ባኣሴ፤ ዬያጉዲ ፆኦሲ ዓያናፓ ዓታዛ ፆኦሲ ማሊፆ ዔራይ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ኑኡኒ ሃያ ዓጮ'' ዓያኖ ዔኪባኣሴ፤ ኑኡኒ ዔኬሢ' ፆኦሲ ኑም ዒንጌ ባኮ ቢያ ኑና ዔርዛ ፆኦሲ ዓያኖኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ዬያሮ ኑኡኒ ዓያኖ ዛሎ'' ባኮ ዓያኖና ዓኣ ዓሶም ዔርዛሢ ዓሲዳፓ ጴዼ ዔራቶናቱዋንቴ ፆኦሲ ዓያኖይዳፓ ጴዻ ዔራቶናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ፆኦሲ ዓያናባኣ ዓሲ ፆኦሲ ዓያና ዒንጋ ዒንጊፆ ዔካኒ ዳንዳዑዋሴ፤ ዓይጎሮ ጌዔቴ ዬይ ዓያኖና ዛጊንቲ ዔርታ ባኣዚ'' ማዔሢሮ ዒዛም ዔርታኒ ዳንዳዑዋሴ፤ ጉቤ ዬይ ዒዛም ዔኤያቶ ማሊ ጴዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ፆኦሲ ዓያናና ዓኣ ዓሲ ቢያ ባኣዚ'' ዛጊ ዔራኒ ዳንዳዓኔ፤ ዒዛ ጋዓንቴ ዖኦኒያ ዛጊ ዔራኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ዬይያ፦ «ፆኦሲ ዒና ዖኦኒ ዔራይ? ዒዛ ዞራኒ ዳንዳዓሢያ ዖናዳይ?» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ኑኡኮ ጋዓንቴ ኪሪስቶሴ ዒና ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ታ ዒሾንሦ ታ ሚሾንሦ! ጎኔ ኬኤዞያታቴ ታኣኒ ዒንሢ ዔርዜሢ ሃጊ ዒንሢ ኪሪስቶሴ ጉሙርቂፆና ዶዲባኣ፥ ናይ ማዔያ ሃሣ ሃያ ዓጮ'' ማሊፆና ዓኣ ዓሲ ማሂ ማዓንዳኣፓዓቴም ዶዲ ዓያናና ዓኣ ዓሲ ማሂ ታ ዒንሢ ዔርዛኒ ዳንዳዒባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ዶዲ ሙኡዚ'' ሙዓኒ ዳንዳዑዋያ ዒንሢ ማዔሢሮ ታ ዒንሢ ዑሼሢ ዲኢቂ ማዓንዳኣፓዓቴም ዶዲ ሙኡዚ'' ታ ዒንሢ ሙኡዚ''ባኣሴ፤ ሃሢታቴያ ዒንሢ ዶዲ ሙኡዚ'' ሃጊ ሙዓኒ ዳንዳዑዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ዎይቲ ጌዔቴ ሃሢያ ዒንሢ ሃያ ዓጮ'' ዓሶ ማሊፆና ዓኣያኬ፤ ዎሊ ዒንሢ ቂኢራያና ማርማያናታሢሮ ሃያ ዓጮ'' ዓሶ ማሊፆና ዓኣኔ ጌይሢቱዋዓዳ? ፆኦሲ ዓሲ ማዒፃ ዒንሢኮ ዓቴም ሃያ ዓጮ'' ዓሶ ዒንሢ ማዒባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ዒንሢዳፓ ፔቴ''ሢ፦ «ታ ጳውሎሴ ዓሲኬ» ጋዓዛ፥ ባጋሢ ሃሣ፦ «ታኣኒ ዓጲሎሴ ዓሲኬ» ጌይፆና ዒንሢ ፆኦሲ ዓሲ ማዒፆ ሃሺ'' ሃያ ዓጮ'' ዓሲ ማዒባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ዓካሪ ዓጲሎሴንታ ጳውሎሴንታ ዓይጎዳይ? ዔያታ ዒንሢ ኪሪስቶሴ ጉሙርቃንዳጉዲ ማሄ ፆኦሲም ማዻ ዓሶኬ፤ ዔያታ ፔቴ'' ፔቴ''ሢ ማዻሢ ጎዳ ዔያቶ ማዻንዳጉዲ ዓይሤ ጎይፆኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ዜርፆ ታ ዱኡቄኔ፤ ዓጲሎሴ ዋኣፆ ዑሼ''ኔ፤ ባቃልሲ ዑጊሴሢ ጋዓንቴ ፆኦሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ዬያሮ ዼኤፖ ማዾ'' ማዼሢ ባቃሎ'' ዑጊሴ፥ ፆኦዛሢ ማዓንዳኣፓዓቴም ዱኡቄሢንታ ዋኣፆ ዑሼ''ሢንታቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ዜርፆ ዱኡቄሢና ዋኣፆ ዑሼ''ሢና ሄኮኬ፤ ዬያታ ፔቴ'' ፔቴ''ሢ ፔኤኮ ማዾ''ጉዴያ ማዼ ዛሎ'' ዒንጎ ባኮ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ዓይጎሮ ጌዔቴ ኑኡኒ ፆኦሲም ዎላ'' ማዻዞንሢኬ፤ ዒንሢ ጋዓንቴ ፆኦሲኮ ጎዦና ማኣሮና ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ፆኦሲ ታኣም ዒንጌ ኮሹሞ ዒንጊፆጉዴያ ኮሺ'' ዔራ፥ ማኣሪ ማዣ፥ ሃኣሚጉዲ ቦኦኮሎ ታ ቦኦኮልቄኔ፤ ባጋሢ ታኣኒ ቦኦኮልቄሢዳ ማኣሮ ማዣኔ፤ ጋዓንቴ ፔቴ'' ፔቴ''ሢ ዎማይዲ ዔሪ ማዣንዳቴያ ኮሺ'' ዔራኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ዓይጎሮ ጌዔቴ ፔቴ''ና ቦኦኮልቂንቴማፓ ዓታዛ ዖኦኒያ ሜሌ'' ጊዳ'' ቦኦኮልቃኒ ዳንዳዑዋሴ፤ ዬይ ቦኦኮላሢ ዬሱስ ኪሪስቶሴታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ዬያ ቦኦኮላሢዳ ዎርቄና ማዔቴያ ቢራ ዓንጊና ሃሣ ኮሺ'' ሚዛጲ ሹቺናኣ ማዖም ሚሢና ሃሣ ማኣቲና ማዔቴያ ሃውሊ''ና ማዣይ ዓኣቶ፦ ");
INSERT INTO mdybse_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ፔቴ'' ፔቴ''ሢ ዓይጎና ማዤቴያ ዔርታንዳ ዎጌ ኬሊ'' ሙካንዳኔ፤ ዬና ኬላ'' ፔቴ'' ፔቴ'' ዓሳ ማኣሮ ማዤሢ ዓይጎናታቴያ ታሚዳ ዓጊንቲ ዛጊንታንዳሢሮ ዱማዺ ዔርታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ማኣሮ ማዤ ዓሢኮ ማዻ'' ታሞና ሙይንቱዋዖ ዶዲ ዓቴቴ ዬይ ዓሢ ፔ ማዾ'' ዛሎ'' ዒንጎ ባኮ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ማዻ'' ታሚና ሙይንቲ ባይቄ ዓሢ ጋዓንቴ ማዻ ዛሎ'' ዒንጎንዶ ባኮይዳፓ ዓታንዳኔ፤ ዬይ ያዺ ማዔቴያ ዓሢ ታማ'' ጋውሌንቴ ዓቴያጉዲ ማዒ ዻቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ዒንሢ ዒንሢ ቶኦኪና ፆኦሲኮ ጌኤሺ ማኣሪ ሃሣ ፆኦሲኮ ዓያና ዒንሢዳ ናንጋያታሢ ዒንሢ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ዓካሪ ዓሲ ፆኦሲኮ ጌኤዦ ማኣሮ ሻሄቴ ፆኦሲ ዒዛ ዓሢ ባይዛንዳኔ፤ ዓይጎሮ ጌዔቴ ፆኦሲኮ ጌኤዦ ማኣራ ዒዛም ዱማዼያታሢሮኬ፤ ዬይ ጌኤዦ፥ ዱማዼ ማኣራ ዒንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ዖኦኒያ ፔና ጌሾፓ፤ ሃያ ዓጮ'' ዔራቶ ጎይፆና ዔራ ማሂ ፔና ዛጋ ዓሲ ዓኣቶ ፆኦሲኮ ጎኔ ዔራቶ ዴንቃኒ ፔና ዔኤያ ማሂ ዛጎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ዓይጎሮ ጌዔቴ ሃያ ዓጮ'' ዔራታ'' ፆኦሲ ቤርታ ዔኤያቶታሢሮኬ፤ ዬይያ፦ «ፆኦሲ ‹ዔሮኬ› ጋዓ ዓሶ ዔያቶኮ ጌኖ'' ማሊፆና ዔያቶ ዓርቃኔ» ጌይንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ዬያጉዲ ሃሣ፦ «ፆኦሲ ሃያ ዓጮ'' ዔሮ'' ዓሶኮ ማሊፃ ጉሪ ባኣዚ'' ማዔሢ ዔራኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ዬያሮ ቢያ ባካ ዒንሢሮ ማዔሢሮ ዓይጎ ዓሲያ ፔ ማዻ ባኣዚ''ና ሄርሺንቶፓ። ");
INSERT INTO mdybse_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳውሎሴ፥ ዓጲሎሴ፥ ጴፂሮሴ፥ ሃይ ዓጫ''፥ ናንጋ፥ ሃይባ''፥ ሃሢ ዓኣ ባኮ ማዔቴያ ሃጊ ሙካንዳ ባካ ቢያ ዒንሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ዒንሢ ጋዓንቴ ኪሪስቶሴሮኬ፤ ኪሪስቶሴ ሃሣ ፆኦሲሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ዓካሪ ዓሲ ቢያ ኑና፡ ኪሪስቶሴም ማዻ ዓሲ ሃሣ ፆኦሲኮ ዓኣሺንቴ ማሊፆ ፔጋሳንዳጉዲ፥ ጉሙርቂ ዒንጎና ዓሲኬ ጋዓንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ጉሙርቂ ዒንጎና ዓሳ' ጉሙርቂንታያ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ታና ዒንሢታቴያ ሃሣ ሜሌ'' ዓሳ «ዒ ዻቤኔ» ጌዒ ዎጋያ ማዔቴያ ሜታ ባኣሴ፥ ናንጎንጎ፤ ታኣኒታዖ «ታ ዻቤኔ» ጌዒ ታ ጊዳ'' ዎጋኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ታ ዔራ ጎይፆናታቴ ታ ዒና'' ታና «ዻቤኔ» ጎዑዋሴ፤ ዬይ፦ ታኣኮ ዻቢንቲ ባኣያ ማዒፆ ዔርዙዋሴ፤ ጋዓንቴ ታ ጊዳ'' «ኔ ዻቤኔ» ጌይ ዎጋንዳሢ ጎዳ ዬሱሴ ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ዬያሮ ጎዳ ዬሱሴ ጋፒንፆ ዎጎሮ ሙካንዳሢኮ ቤርታ ዖጊዳ ማዔቴያ ኮይሱዋ ጎይሢና ዎጊፖቴ፤ ዒዚ ሙኬ ዎዶ''ና ዹሞይዳ ዓኣሺንቴ ባኮ ፔጋሳንዳኔ፤ ሃሣ ዓሳ ፔ ዒና'' ዓኣቺ ዓርቄ ማሊፆ ፔጋሲ ዒማና ዻዋንዳኔ። ዒማ''ና ፔቴ'' ፔቴ''ሢ ፆኦሲዳፓ ኮይሳ ጎይፆና ጋላታ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ታ ዒሾንሦ! ታ ሚሾንሦ! ዒንሢ ማኣዳ''ኒ ጌዒ ታኣና ዓጲሎሴና ዬያ ዛሎ''ኮ ኮኦኪንሢ ማሂ ታ ዒንሢም ኬኤዜኔ፤ ዬያ ታ ማዼሢ፦ «ፃኣፒንቴ ዎጎኮ ዑሣ ዓኣዺፖ» ጋዓ ዞሮ'' ኑ ዛሎ''ና ዒንሢ ዔራንዳጉዲ ጌይኬ። ዬያሮ ፔቴ''ያ ባጋሢዳፓ ባሼ ማሂ ዛጊ፥ ዒዛና ሄርሺንቲፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ኔና ሃንጎ ዓሶይዳፓ ባሼ ማሄሢ ዖናዳይ? ቢያ ባኮ ኔ ዔኬሢ ፆኦሲዳፓኬ፤ ኔኤሮ ማዔ፥ ዓይጎ ባኣዚ''ያ ባኣሴ፤ ሂዳዖ ቢያ ባኮ ኔ ዔኬሢ ፆኦሲዳፓ ማዔቴ ዔኪባኣያ ማዒ ዓይጋ ኔ ሄርሺንታይ? ");
INSERT INTO mdybse_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ሓሢ ሃይሾ ዒንሢም ኮይሳ ባኮ ቢያ ዒንሢ ዴንቄኔ! ሃሣ ዒንሢ ዖርጎጬኔ! ኑ ጊዳ''ፓ ዱማዺያ ዒንሢ ካኣታዼኔ! ጎኔ ዒንሢ ካኣታዼያ ማዔቴያ ኑኡኒ ዒንሢና ዎላ'' ካኣታዻንዳያታሢሮ ካኣቱማ ዒንሢኮ ኮሺ ማዓንዳንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ዎይቲ ጌዔቴ ፆኦሲ ኑና፥ ዒዛ ማዾ''ም ዳኪንቴዞንሢ ሃይቃንዳጉዲ ዎጊንቲ ዎዾ ቤዞ ዔኪ ዓኣዾ ዓሶ ባኣኮ''ይዳፓ ጋፒንሢ ዓሲ ማሄያ ታኣም ማላኔ፤ ዬያይዳፓ ዔቄያና ዓጮ'' ቢያይዳ ፆኦሲ ኪኢታንቾንታ ዓሶንታ ቤርቶይዳ ዓማሊ'' ባኣዚ'' ሃሣ ሚኢቺም ማዓ ባኣዚ'' ማዒ ኑ ጴዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ኑኡኒ ኪሪስቶሴሮ ጌዒ ዔኤያ ማዔኔ፤ ዒንሢ ጋዓንቴ ኪሪስቶሴና ማዒፆና ዔራ ዓሲ ማዔኔ፤ ዬያጉዲ ዒንሢ ዶዲ ዓሲ ማዔኔ፤ ኑኡኒ ላቤ'' ዓሲ ማዔኔ፤ ሃሣ ዒንሢ ቦንቺንቴ ዓሲ ማዔኔ፤ ኑኡኒ ጋዓንቴ ቦሂንቴ ዓሲ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ሃሢያ ሃይማ ሄላ''ንዳኣና ኑ ናይዺንታኔ፥ ዼኤቢንታኔ፥ ካላ''ዻኔ፥ ጳርቂንታኔ፤ ሃሣ ማኣሪ ባይዚ ኑ ሜታዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ሃሣ ኑ ኩቻ ኑ ማዺ ማዺ ላቢ''ንታኔ፤ ዓሳ ኑና ጫሽካኣና ኑ ዓንጃኔ፤ ኑና ዒፂ ዳውሶዋና ኑ ጊቢ'' ዳንዳዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ኑና ጫሽኪ፥ ሱ'ንፆዋ ኑኡኮ ፑርቲሳኣና ኮሺ ዑኡሲ ኑ ዔያቶም ማሃኔ፤ ሃሢ ሄላ''ንዳኣና ሃያ ዓጮ''ኮ ኬኤሪንቴያ ሃሣ ፒፆ''ና ቡኡራጉዲ ኑ ማዒ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ሓያ ታ ዒንሢም ፃኣፓሢ ታኣኮ ናሽኪንቴ ናኣቶ'' ማሂ ዒንሢ ዞራኒ ማዓንዳኣፓዓቴም ዒንሢኮ ዒኔ ዱኡዛኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ዎዚ ዒንሢኮ ሚርጌ ሺያና ፓይዲንታ ዲቻ ዓሲ ኪሪስቶሴ ዛሎ''ና ዓኣቴያ ሚርጌ ዓዶንሢ ዒንሢኮ ባኣሴ፤ ኮዦ ሃይሶ ኬኤዚፆና ዬሱስ ኪሪስቶሴ ዛሎ''ና ዒንሢ ሾዔሢ ታና ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ዬያሮ ታ ሃንቴ ጎይፆ ዒንሢ ሃንታንዳጉዲ ታ ዒንሢ ሺኢቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ጎዳ ሱ'ንፆና ታኣኮ ናሽኪንታሢና ጉሙርቂንታ ናዓሢ ማዔ፥ ፂሞቴዎሴ ታ ዒንሢም ዳኬሢ ዬያሮኬ፤ ታኣኒ ቢያ ቤዞይዳ ሺኢጲፆ ማኣራ ዔርዜ ጎይፆ ሃሣ ኪሪስቶሴና ታ ዴንቄ ዓኮ ናንጎ ታ ናንጌ ጎይፆ ዒዚ ዒንሢ ዔርዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ጋዓንቴ ዒንሢ ባኣካ''ፓ ፔቴ'' ፔቴ''ዞንሢ ታ ዒንሢ ኮይላ'' ሙኪንዱዋያ ዔያቶም ማሌም ሚርጌና ዖቶርቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ያዺ ማዔቴያ ፆኦሲ ጌዔቴ ዑኬ ኬሊ''ዳ ታ ዒንሢ ኮይላ'' ሙኪ ዬኖ ዖቶርቃ ዓሶኮ ጌኤዞ ሌሊቱዋንቴ ዎልቆዋ ዔያቶኮ ታ ዔራኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ዓይጎሮ ጌዔቴ ፆኦሲ ካኣቱማ ማዒባኣ ጉሪ ሃይሴቱዋንቴ ፆኦሲ ዎልቄታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ዒንሢ ኮዓ ባካ ዓይጎዳይ? ዒንሢ ጳርቆንዶ ኮኦሎ'' ታ ዔኪ ሙካንዳጉዲ ዒንሢ ኮዓሞ? ናሹሞና ሼሌዑሞ ዓያናና ማዒ ታ ዒንሢ ኮይላ'' ሙካንዳጉዲ ዒንሢ ኮዓይ? ");
INSERT INTO mdybse_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ዒንሢ ባኣኮ''ይዳ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂንታ፥ ቦርሲሳ ሃይሴ ዋይዚንታኔ፤ ዬያጉዴ ማዾ ሜሌ'' ዴሮ'' ባኣካ''ታዖ ማዺንቱዋያኬ፤ ዬይያ፦ ዒንሢ ባኣካ'' ፔኤኮ ዒንዶ ሌጎ ዔኬ ዓሲ ዓኣኔ ጌይንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ዓካሪ ዬያጉዴ ቦርሲሳ ማዾ ዒንሢ ባኣካ'' ዓኣንቴ ዓይጎሮ ዒንሢ ዖቶርቃይ? ዬያይዳፓ ዬያ ባኮ ዛሎ''ሮ ዖዪ፥ ዬያ ማዾ'' ማዼሢ ዒንሢ ባኣካ''ፓ ሺኢሻንዳያ ኮይሳያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ዎዚ ታ ዒንሢና ዎላ''ቱዋቴያ ዓያኖና ታ ዒንሢና ዎላ''ኬ፤ ሃሢ ታ ዓዳ'' ዒንሢና ዎላ'' ዓኣያ ማዒ፥ ዬያጉዴ ዒኢቴ ማዾ ማዼ ዓሢ ዑፃ ጎዳ ዬሱስ ኪሪስቶሴ ሱ'ንፆና «ዒ ዻቤኔ» ጌይ ታ ዎጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ዒንሢ ቡኪንታ ዎዶ''ና ታኣኒያ ዓያኖና ዒንሢና ዎላ''ታሢሮ፥ ኑ ጎዳሢ፥ ዬሱሴ ሱ'ንፆና ሃሣ ዒንሢ ባኣኮ''ይዳ ዓኣ፥ ጎዳ ዬሱሴ ዎልቆና፥ ");
INSERT INTO mdybse_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ጎሜ ማዻ፥ ዬያ ዓሢኮ ዑፆ ዓሽካ ባይቃንዳጉዲ ዒንሢ ባኣካ''ፓ ዱማሲ፥ ፃላሄም ዒዛ ዓኣሢ ዒንጋንዳያ ኮይሳኔ፤ ዬያ ዒንሢ ማዻንዳሢ' ጎዳ ጋፒንፆ ዎጎሮ ሙካኣና ዬያ ዓሢኮ ሼምፓሢ ዻቃንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ዓካሪ ዒንሢ ሄርሺንቲ ዖቶርቃሢ ጉሪኬ፤ ሙኑቃ ፃኣዛ ዺቦ'' ሙኑቆ ቢያ ካፂሳሢ ዒንሢ ዔሩዋይ? ");
INSERT INTO mdybse_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ፃኣዛ ባኣ ሙኑቃ ዒንሢ ማዓንዳጉዲ ሙኑቆ ፃኣዞ ዒንሢዳፓ ባይዙዋቴ፤ ዒንሢዳ ዬይ ባኣሢያ ታ ዔራኔ፤ ዑሣ ዓኣዺፆ ኬሎ'' ማራዓሢ ማዔ፥ ኪሪስቶሴ ኑ ጋይቴ ሹኪንቲ ሃይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ዬያሮ ፑርቱሞና ጌኔ ማዾና ኩሜ፥ ሙኑቆ ፃኣዞናቱዋንቴ ሙኑቆ ፃኣዛባኣ ላኣዶ ሙዒ ኑኡኮ ቦንቾ ኬሎ'' ፒዙሞና ሃሣ ጎኑሞና ኑ ቦንቾም። ");
INSERT INTO mdybse_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ሓያኮ ቤርታ ታ ዒንሢም ፃኣፔ ኪኢቶ''ይዳ፦ «ማቾ ሃሣ ዓኒ ማዒባኣያና ላሃ ዓሶና ዎላ'' ፔቴ'' ማዒፖቴ» ታ ዒንሢም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ዬያ ታ ጋዓዛ ሃያ ዓጮ''ይዳ ዓኣ ማቾ ሃሣ ዓኒ ማዒባኣ ዓሶና ላሃ ዓሶና ሚኢሾሮ ጎጋይቃ ዓሶና ዬያጉዲ ዉዞና ጎኔ ፆኦሲ ማዒባኣ ባኮ ካኣሽካ ዓሶና ዎላ'' ፔቴ'' ማዒፖቴ ጌይሢቱዋሴ፤ ያዺ ማዔያታቴ ሃያ ዓጮ''ይዳፓ ኬስካንዳያ ዒንሢም ኮይሳኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ታኣኒ ጋዓንቴ ዒንሢም ፃኣፔሢ፦ «ኪሪስቶሴ ጉሙርቃ ዓሲኬ» ጌይ ጌይ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሃዞንሢና ሚኢሾሮ ጎጋይቃዞንሢና፥ ዬያጉዲ ጎኔ ፆኦሲ ማዒባኣ ካኣዦ ካኣሽካ ዓሶና ዓሲ ጫሽካ ዓሶና ማሢንታ ዓሶና ሃሣ ዉኡቃ ዓሶና ዎላ'' ፔቴ'' ማዒፖቴ ጌይኬ። ዬያጉዴ ዓሶና ዎላ'' ሙኡዚ''ታዖ ሙይፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ኪሪስቶሴ ጉሙርቁዋ፥ ዙላ'' ዓኣ ዓሶ ዑፃ ዎጋኒ ታኣም ኮይሳያቱዋሴ፤ ኪሪስቶሴ ጉሙርቃ ዓሶይዳ ጋዓንቴ ዒንሢ ዎጋኒ ዳንዳዓያቱዋይ? ");
INSERT INTO mdybse_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ኪሪስቶሴ ጉሙርቁዋ ዓሶይዳ ዎጋሢ ፆኦሲኬ፤ ዓካሪ ማፃኣፓ ጋዓሢጉዲ «ፑርቶ ዓሢ ዒንሢ ባኣካ''ፓ ሺኢሹዋቴ።» ");
INSERT INTO mdybse_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ዒንሢዳፓ ፔቴ'' ዓሲ ኪሪስቶሴ ጉሙርቃያ ማዔ፥ ዒሻሢና ዎላ'' ፑርቴቴ ጌኤዞ ፆኦሲ ዓሳ ዎጋንዳጉዲ ማሂፆይዳፓ ዎጌና ዓይሢሳኒ ፆኦሲ ዔሩዋ ዓሶና ዎጊሳኒ ዎይቲ ዓኣዻኒ ጫርቃይ? ");
INSERT INTO mdybse_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ፆኦሲ ዓሳ ዓጮ''ይዳ ዎጋያታሢ ዒንሢ ዔሩዋዓዳ? ሂዳዖ ዓጮ''ይዳ ዒንሢ ዎጋያታንቴ ዬያ ዻኮ'' ባኮ ዎጊፃ ዒንሢ ባሺያ? ");
INSERT INTO mdybse_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ፆኦሲ ኪኢታንቾይዳታዖ ኑ ዎጋንዳሢ ዒንሢ ዔሩዋዓዳ? ሂዳዖ ሃያ ዓጮ'' ባኮይዳ ባሼና ዎይቲ ዎጋኒ ኑ ዳንዳዑዋይ? ");
INSERT INTO mdybse_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ዓካሪ ዎሊና ዒንሢ ፑርቴቴ ኪሪስቶሴ ጉሙርቃ ዓሶ ባኣካ'' ባኣ ዓሶና ዎጊሳኒዳ? ");
INSERT INTO mdybse_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ዔዛታ! ዒንሢ ባኣኮ''ይዳ ዓሲ ጊኢጊሻኒ ዳንዳዓ፥ ዒናና ዓኣ፥ ጪሚባኣዓዳ? ቦርሶ ዒንሢም ማዖም፤ ");
INSERT INTO mdybse_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ዓካሪ ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሲ ባጋሢ ዎጌና ዓይሢሳኒ ፆኦሲ ዔሩዋ ዓሶ ዎጎ ቤዞ ዓኣዻኒ ኮይሳ? ");
INSERT INTO mdybse_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ጉቤና ዎላ'' ዒንሢኮ ሞኦቲንታ ዻውሲንቲኬ፤ ዬያይዳፓ ዒንሢም ፑርቲሶናኣታቴ ሃሣ ዒንሢ ጌሾናኣታቴ ኮሺቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ዒንሢ ጋዓንቴ ዒንሢም ፑርቲሳኔ፤ ሃሣ ዒንሢ ጌሻኔ፤ ዬያጉዲ ዒንሢ ዒሾንሢንታ ሚሾንሢንታም ዒንሢ ዬያይዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ፑርቶ ዓሳ ፆኦሲ ካኣቱሞይዳ ጌሊንዱዋኣሢ ዒንሢ ዔሩዋዓዳ? ዬያ ባኮና ጌሺንቲፖቴ፤ ዓኒ ሃሣ ማቾ ማዒባኣ ዓሶና ላሃኒ ሱኡካዻ ዓሳ፥ ፆኦሲፓ ሜሌ'' ካኣሽካ ዓሳ፥ ዓኒ ሃሣ ማቾ ማዒባኣ ዓሶና ላሃ ዓሳ፥ ዓቲንቄና ላሃ ዓቲንቄ፥ ");
INSERT INTO mdybse_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ዉሲ፥ ሚኢሼሮ ጎጋይቃ ዓሲ፥ ዑሽኪ ማሢንታ ዓሲ፥ ዓሲ ዾንካ ዓሲ፥ ዓሲ ባኣዚ'' ቡራ ዓሲ ፆኦሲ ካኣቱሞይዳ ጌላዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ዒንሢዳፓ ፔቴ'' ፔቴ''ዞንሢ ቤርታ ያዺኬ፤ ሃሢ ጋዓንቴ ጎዳ ዬሱስ ኪሪስቶሴ ሱ'ንፆና ኑ ጎዳሢ ዓያኖና ጎማፓ ዒንሢ ማስቲ ጌኤሽኬኔ፤ ፆኦሲም ዱማዼ ዴሬያ ዒንሢ ማዔኔ፤ ፂሊ''ያ ፂሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ቢያ ባኣዚ'' ታ ማዻንዳጉዲ ዓይሢንቴያኬ፤ ጋዓንቴ ቢያ ባካ ታኣም ኮይሳያቱዋሴ፤ ቢያ ባኣዚ'' ታ ማዻንዳጉዲ ታኣም ዓይሢንቴኔ፤ ዬይ ያዺ ማዔቴያ ዓይጎ ባኣዚ''ማኣ ካራሚ ማዒ ታ ዎርቃዓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ሙኡዚ'' ጎጲም፥ ጎጲ ሃሣ ሙኡዚ''ምኬ፤ ያዺ ማዔቴያ ፆኦሲ ሙዖንታ ጎጶንታ ባይዛንዳኔ። ኑኡኮ ዑፃ ጎዳም፥ ጎዳኣ ኑ ዑፆም ማዔሢሮ ኑኡኮ ዑፆ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂሢም ማሃንዳያ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ፆኦሲ ጎዳ ዬሱሴ ሃይባ''ፓ ዔቂሴኔ፤ ሃሣ ኑናኣ ፔ ዎልቆና ሃይባ''ፓ ዔቂሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ዒንሢኮ ዑፃ ኪሪስቶሴ ዑፆይዳፓ ፔቴ'' ቤሲ ማዔሢ ዒንሢ ዔሩዋዓዳ? ዓካሪ ኪሪስቶሴ ዑፆ ማዔሢ ዔኪ ዓኒ ማዒባኣ ዓሶና ላሃ ላኣሎ ዑፆና ዎላ'' ፔቴ'' ማሃንዳያ ታኣም ኮይሳ? ፔቴ''ታዖ ዬይ ኮይሱዋሴ! ");
INSERT INTO mdybse_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ዓኒ ማዒባኣ ዓሶና ላሃ ላኣሎና ላሃ ዓሲ ዒዞና ዎላ'' ፔቴ'' ማዓሢ ዒንሢ ዔሩዋዓዳ? ዎይቲ ጌዔቴ፦ «ላምዖንሢ ፔቴ'' ማዓኔ» ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ጎዳና ዎላ'' ፔቴ'' ማዓ ዓሳ ጋዓንቴ ዒዛና ዎላ'' ዓያናና ፔቴ'' ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ዬያሮ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂፖቴ፤ ዓሲ' ማዻ ሜሌ'' ጎሜ ቢያ ፔ ዑፆኮ ዙላ'' ማዻያኬ፤ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሃ ዓሲ ጋዓንቴ ፔ ዑፆይዳ ጎሜ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ፆኦሲዳፓ ዒንሢ ዔኬ፥ ዒንሢኮ ጋሮይዳ ናንጋ ዓያኖ ጌኤዦኮ ዒንሢ ዑፃ ማኣሮ ማዔያታሢ ዒንሢ ዔሩዋዓዳ? ዒንሢ ፆኦሲሮ ማዓንዳኣፓዓቴም ዒንሢሮቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ዎይቲ ጌዔቴ ዒዚ ዒንሢ ሻንቂ ዔኬያኬ፤ ዬያሮ ዒንሢኮ ዑፆና ፆኦሲ ቦንቹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ዒንሢ ታና ፃኣፒ ዖኦጬ ዓኦጪፆ ዛሎ''ኮ፦ ዓሲ ላኣሊ ዔኪባኣቴ ኮሺኬ ታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ጋዓንቴ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂ ጎሜ ማዹዋጉዲ ፔቴ'' ፔቴ'' ዓቲንቆኮ ማቻ ዓኣያ፤ ሃሣ ፔቴ'' ፔቴ'' ላኣሎኮ ዓኒ ዓኣያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ዓኒ ፔ ማቾም ፔና ዒንጋኒ ኮይሳኔ፤ ዬያጉዲ ማቻኣ ፔ ዓኒም ፔና ዒንጋኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ማቾኮ ዑፃ ዒዞሮ ሌሊቱዋንቴ ዓኒንታ ዎላ''ሮኬ፤ ዬያጉዲ ሃሣ ዓኒ ዑፃ ዒዛሮ ሌሊቱዋንቴ ማቾንታ ዎላ''ሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ፆኦሲ ሺኢቃኒ ላምዖንሢ ዎላ'' ጊኢጊ ዻካ'' ዎዴም ማዓንዳኣፓዓቴም ዱማዺ ዎርቂባኣያታቴ ቃራኬ፤ ዒንሢ ዒ'ንሢ ካፓኒ ዳንዳዑዋያ ማዔም ፃላሄ ዒንሢ ጌሹዋጉዲ ዎላ'' ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ዬያ ታ ዒንሢም ጋዓሢ ዞሮጉዲ ማዓንዳኣፓዓቴም ዓይሥሢ ማሂቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ዓሲ ቢያ ታጉዲ ላኣሊ ዔኩዋዖ ናንጌቴ ቃራኬ ታ ጋዓኔ፤ ጋዓንቴ ፔቴ'' ፔቴ''ሢም ፆኦሲ ዱማ ዱማ ዒንጊሢ ዒንጌኔ፤ ፔቴ''ሢም ፔቴ'' ባኣዚ''፥ ባጋሢም ሜሌ'' ባኣዚ'' ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ሎይባኣ ዓሶንታ ዔኪባኣ ዓሶንታም፤ ጊንሣ ሃሣ ዓኒንሢ ሃይቄ ላኣሎንታም ታ ሂዚ ጋዓኔ፦ ዔያታ ሎውዋዖ ሃሣ ዔኩዋዖ ታጉዲ ናንጌቴ ዔያቶም ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ጋዓንቴ ዔያታ ፔና ዳንዳዒ ካፓኒ ባሺንቴቴ ሌዖንጎ፥ ዔኮንጎ፤ ዓይጎሮ ጌዔቴ ዔኪሢና ሎዒሢና ዛላ ማሊ ሜታዺሢዳፓ ዔኪፆና ሎይፆና ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ዔኬዞንሢና ሎዔዞንሢናም ታ ሂዚ ጋዓኔ፦ ሃይ ጎዳ ጋዓያ ማዓንዳኣፓዓቴም ታ ጋዓያቱዋሴ። ሎዔ ላኣሊ ፔኤኮ ዓኒዳፓ ዱማዾፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ዓኒፓ ዱማዺ ዒዛ ኬስኬቴ ሎውዋዖ ፔኤሮ ናንጎንጎ፤ ዔይዔ ጌዔቴ ዓኒና ቡኮንጎ፤ ዬያጉዲ ዓኒያ ፔ ማቾ ዓንጆፓ። ");
INSERT INTO mdybse_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ሃንጎዋቶም ጎዳ ጋዓያቱዋንቴ ታ ሂዚ ጋዓኔ፦ ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሲኮ ኪሪስቶሴ ጉሙርቁዋ ላኣሊ ዓኣያታዖ ዒዛና ዎላ'' ናንጋኒ ኮዔቴ ዒዞ ዒ ዓንጆፓ። ");
INSERT INTO mdybse_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ሃሣ ኪሪስቶሴ ጉሙርቃ ላኣሊኮ ኪሪስቶሴ ጉሙርቁዋ ዓኒ ዓኣያ ማዒ፥ ዒዞና ዎላ'' ናንጋኒ ኮዔቴ ዒዛ ዒዛፓ ዓንጂንቶፓ። ");
INSERT INTO mdybse_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ዓይጎሮ ጌዔቴ ኪሪስቶሴ ጉሙርቁዋያ ማዔ ዓናሢ ኪሪስቶሴ ጉሙርቃ ዒዛኮ ማቾ ዛሎ''ና ፆኦሲ ዓሲ ማዓሢሮኬ፤ ኪሪስቶሴ ጉሙርቁዋያ ማዔ ላኣሌላኣ ኪሪስቶሴ ጉሙርቃ ዓኒ ዛሎ''ና ፆኦሲ ዓሲ ማዓኔ፤ ያዺ ማዒባኣቶ ናኣታ'' ዒንሢኮ ፆኦሲ ዓሲ ማዓኒ ዳንዳዑዋሴ፤ ዬያይዲ ዒንሢ ናንጌቴ ናኣታ'' ዒንሢኮ ፆኦሲ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ኪሪስቶሴ ጉሙርቁዋያ ማዔ ዓሶማ ዱማዻኒ ኮዔቴ ዱማዾንጎ፤ ዬካፓ ኪሪስቶሴ ጉሙርቃያ ማዔ ዓኒታቴያ ማቾ ፔቴ'' ማሃ ዎጋ'' ዓርቃኒ ዳንዳዑዋሴ። ዓይጎሮ ጌዔቴ ፆኦሲ ኑና ዔኤሌ''ሢ ኮሹሞና ኑ ናንጋንዳጉዲታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ዔና፥ ኪሪስቶሴ ጉሙርቃዜሌ ኪሪስቶሴ ጉሙርቁዋ ዓኒ ኔኤኮ ኔ ዻቂሻንዳያ ናንዳኔ ኔ ዔራ? ኔኤኒ ኪሪስቶሴ ጉሙርቃሦ ኪሪስቶሴ ጉሙርቁዋ ኔኤኮ ማቾ ኔ ዻቂሻንዳያ ናንዳኔ ኔ ዔራ? ");
INSERT INTO mdybse_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ፔቴ'' ፔቴ''ሢ ፆኦሲ ዒዛም ጌዔ ጎይፆ ሃሣ ፆኦሲ ዒዛ ዔኤላ''ኣና ዓኣ ጎይፆ ናንጎንጎ። ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሶም ቢያ ታ ዒንጌ ዎጋ'' ዬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ዖናታቴያ ዓቲንቶ ቤርቶ ቲቂንቴያታዖ ዔኤሊ''ንቴያ ማዔቴ ቲቂንቲባኣሢጉዲ ማዓኒ ማሎፓ፤ ዓቲንቶ ቤርቶ ቲቂንቲባኣዖ ዔኤሊ''ንቴያ ማዔቴ «ቲቂንታኒ ኮይሳኔ» ጌይሳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ዓቲንቴ ቤርቲ ቲቂንቲሢ ማዔቴያ ቲቂንቱዋ ሃሺ''ፃ ማኣዳ'' ባኣዚ'' ባኣሴ፤ ባሼ ኮይሳሢ ፆኦሲ ዓይሢፆ ኩንሥሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ዬያሮ ፔቴ'' ፔቴ'' ዓሳ ፆኦሲ ዒዛ ዔኤላ''ኣና ዓኣ ጎይፆማ ናንጎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ፆኦሲ ኔና ዔኤላ''ኣና ኔ ዓሲኮ ዓይሌ''ዳ? ያዺ ኔ ማዔቴያ ዔኤቢባኣሴ፤ ማሊ ሜታዺፖ፤ ዓይሉ''ማፓ ኬስካኒ ካራ ኔኤም ጴዼቴ ኬዞ ሃሺ''ፖ። ");
INSERT INTO mdybse_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ዓይጎሮ ጌዔቴ ዓሲኮ ዓይሌ'' ማዒ ዓኣንቴ ጎዳ ዔኤሌ'' ዓሲ ጎዳና ዓይሉ''ማፓ ኬስኬኔ፤ ዬያጉዲ ዓይሌ''ቱዋያታዖ ዔኤሊ''ንቴ ዓሲ ኪሪስቶሴኮ ዓይሌ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ፆኦሲ ዒንሢ ሻንቂ ዔኬሢሮ ዓሲኮ ዓይሌ'' ማዒፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ዬያሮ ታ ዒሾንሦ ታ ሚሾንሦ! ፔቴ'' ፔቴ'' ዓሳ ዔኤሊ''ንታማና ዓኣ ጎይፆ ፆኦሲና ዎላ'' ናንጎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ዔኪባኣያ ሃሣ ሎዒባኣ ዓሶ ዛሎ'' ጎዳፓ ታ ዔኬ ዓይሥሢባኣሴ፤ ጋዓንቴ ጎዳኮ ማኣሪፃፓ ዔቄያና ጉሙርቂንቴ ዓሲ ማዒ ሃካፓ ሊካ ታ ማሊፆ ታ ኬኤዛኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ሃሢ ኑ ዓኣ ዎዳ'' ሜቶ ዎዴታሢሮ ዓሲ ዓኣማ ጎይፆ ናንጌቴ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ጋዓንቴ ላኣሊ ኔ ዔኬያ ማዔቴ ዓንጃኒ ኮይፖ፤ ላኣሊ ኔ ዔኪባኣያ ማዔቴ ዔካኒ ኮይፖ። ");
INSERT INTO mdybse_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ኔኤኒ ላኣሊ ዔኬቴ ጎሜ ማዼኔ ጌይሢቱዋሴ፤ ሃሣ ፔቴ'' ዉዱሮ ናይ ሎዔቴ፡ ጎሜ ዒዛ ማዼኔ ጌይሢቱዋሴ፤ ማዔቴያ ዔካ ዓሶና ሎዓ ዓሶና ሃያ ዓጮ''ይዳ ሚርጌ ናንጊ ሜታ ሄላ''ኔ፤ ታኣኒ ዒንሢ ዬይ ሄሉ''ዋጉዲ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዒንሢም ሂዚ ጋዓኔ፦ ዎዳ'' ጋፒ ጋፒኬ፤ ሃካፓ ሴካ ላኣሊ ዓኣሢያ ዔኪባኣያጉዲ ማዒ ናንጎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ዖያሢ ዖዩዋኣሢጉዲ፥ ዎዛዻሢ ዎዛዹዋኣሢጉዲ ማዒ ናንጎንጎ፤ ዔኤቢ ሻንቃሢ ዒ ሻንቄ ባካ ዒዛሮኬ ጌይ ማሎፓ። ");
INSERT INTO mdybse_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ሓያ ሳዖይዳ ዓኣ ቆሎ''ና ማኣዲ''ንታሢ ጉቤ ማኣዲ''ንቱዋያ ማዒ ናንጎንጎ፤ ዓይጎሮ ጌዔቴ ሃያ ዓጮ'' ባካ'' ላኣሚንታንዳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ዬያሮ ዓይጎ ማሊሢና ዒንሢ ሜታዹዋዖ ናንጋንዳጉዲ ታ ኮዓኔ፤ ላኣሊ ዔኪባኣ ዓሲ ጎዳ ዎዛሳንዳ ባኣዚ'' ኮዓሢሮ ጎዳ ዎዛሳ ባኣዚ'' ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ላኣሊ ዔኬ ዓሲ ጋዓንቴ ማላሢ ሃያ ዓጮ'' ባኣዚ''ና ፔ ማቾ ዎዛሳንዳ ባኣዚ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ዬያሮ ማሊፃ ዒዛኮ ላምዖ ፓቂንታኔ ጌይሢኬ። ዬያጉዲ ሎዒባኣ ላኣሊታቴያ ዉዱሮ ናይ ፔኤኮ ዓሽኮና ሼምፓሢና ፆኦሲም ዱማዼያ ማዓኒ ኮዓሢሮ ማሊፃ ዒዞኮ ጎዳም ኮይሳ ማዾ''ይዳኬ። ሎዔ ላኣሌላ ጋዓንቴ ፔኤኮ ዓኒ ዎዛሳኒ ኮዓሢሮ ዒዛ ማላሢ ሃያ ዓጮ'' ባኣዚ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ዬያ ታ ጋዓሢ' ዒንሢም ኮይሳ ባኮ ማሊሢና ማዓንዳኣፓዓቴም ዒንሢም ዔቦ'' ዴኤፂሳኒቱዋሴ፤ ታኣኮ ማሊፃ ዒንሢ ኮይሳ ጎይሢ ናንጋንዳጉዲና ማሊፃ ዒንሢኮ ዣኣሉዋንቴ ጉቤ ዒናና ማዒ ጎዳም ማዻንዳጉዲ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ፔቴ'' ዓሲ ፔቴ'' ዉዱሮ ናሽኪ ዎላ'' ዓማላ''ያታዖ ዬኖ ዔካኒ ማሊባኣንቴ፥ ዬኖ ዉዱሬሎኮ ሎዖንዶ ዎዳ'' ዓኣዻያ ማዔቴ ሃሣ ዒ ዔኪፆ ማሊፆ ጊባ''ኒ ዳንዳዒባኣያታቴ ጎሜ ባኣሴ ዔዔኮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ጋዓንቴ ዔካኒ ዒዛ ሜታሳ ባኣዚ'' ባኣቴ፥ ዔኩዋዖ ዴዓኒ ዳንዳዓያታቴ ሃሣ ዬይ ጎኔ ዒናፓ ማዔያታቴ ዔኪባኣቴ ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ዬያሮ ዖኦጮዞ ዔኬሢ ኮሺ ማዼኔ፤ ዔኩዋዖ ሃሼ''ሢያ ባሼ ኮሺ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ፔቴ'' ላኣሊ ዓኒ ሼምፔና ዓኣና ዔፒ ዛላ ዎጌና ቱኡቴያኬ፤ ዓኒ ሃይቄቴ ጋዓንቴ ሜሌ'' ኮዔ ዓሲም ዒዛ ሎዓኒ ዳንዳዓኔ፤ ዒዛ ሎዓንዳ ዓሢ ኪሪስቶሴ ጉሙርቃያ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ታ ማሊፆና ታ ጋዓሢ ሎውዋዖ ፔኤሮ ዒዛ ናንጌቴ ባሼ ዒዛ ዎዛና ናንጋንዳኔ፤ ታና ፆኦሲ ዓያና ዬያ ጌይሳያ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ሜሌ'' ፆኦዞም ሹኪንቴ ቆልሞ ዓሽኮ ዛሎ'' ሂዚ ታ ጋዓኔ፦ ቢያሢኮ ኑኡኮ ዔራቶ ዓኣኔ። ዔራቶ ዓሲ ዖዖቶርሳኔ፤ ናሹሞ ጋዓንቴ ዓሲ ኮኮሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","«ታ ዔራኔ» ጋዓ ዓሲ ኮይሳሢጉዴያ ሃጊ ዔሪባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ፆኦሲ ናሽካ ዓሲ ጋዓንቴ ፆኦሲና ዔርቴያ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ዓካሪ ሜሌ'' ፆኦዞም ሹኪንቴ ዓሽኪ ዛላ ታ ጋዓሢ' ሜሌ'' ፆኦዛ ሃያ ዓጮ''ይዳ ዓይጎዋቱዋኣሢ ኑ ዔራኔ፤ ዬያጉዲ ፔቴ'' ፆኦዛሢዳፓ ዓታዛ ሜሌ'' ፆኦሲ ባኣሢያ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ሚርጌ፡ ፆኦሲ ጌይንታ ባኣዚ''ና ጎዳቲ ጌይንታይ ዓኣኔ፤ ጋዓንቴ ጫሪንጫ ማዔቴያ ሳዖይዳ ፆኦሲ ጌይንታ ካኣሽኮ ባኣዚ'' ዓኣቴያ፥ ");
INSERT INTO mdybse_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ኑኡኮ ጋዓንቴ ቢያ ባኣዚ'' ዒዛይዳፓ ማዢንቴያ፥ ኑኡኒያ ዒዛም ማዢንቴያ ፔቴ'' ፆኦሲ ማዔ ዓዴ ዓኣኔ፤ ዬያጉዲ ሃሣ ቢያ ባኣዚ'' ዒዛ ዛሎ''ና ማዢንቴያ ኑኡኒያ ዒዛ ዛሎ''ና ማዢንቴ፥ ፔቴ'' ጎዳ ዬሱስ ኪሪስቶሴ ኑኡኮ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ጋዓንቴ ዬያ ቢያሢ ዔሩዋሴ፤ ፔቴ'' ፔቴ''ዞንሢ ሃሢ ሄላ''ንዳኣና ሜሌ'' ፆኦዞ ካኣሽኪሢ ዔሬሢሮ ዬያጉዴ ዓሽኮ ዔያታ ሙዓሢ ሜሌ'' ፆኦዞም ሹኪንቴያ ማሂኬ፤ ዒና'' ዔያቶኮ ዔያቶ ዻቢንቴያኬ ጋዓሢሮ ዔያታ ዒኢታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ጋዓንቴ ፆኦሲና ኑኡና ዎላ'' ካንሣሢ ሙኡዚ''ቱዋሴ፤ ኑ ሙዒባኣቴያ ፓጫንዳ ባኣዚ'' ባኣሴ፤ ኑ ሙዔቴያ ባሼ ዴንቃንዳ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ዬይ ያዺ ማዔቴያ ዬይ ኮዔ ጎይፆ ማዺፃ፥ ኪሪስቶሴ ጉሙርቂፆና ዶዲባኣ ዓሶ ዻቢሻያ ማዑዋጉዲ ዒንሢና ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ዓይጎሮ ጌዔቴ «ታ ዔራኔ» ጌዒ ሜሌ'' ፆኦዞም ሹኪንቴ ዓሽኮ ካኣዦ ማኣራ ኔ ዴዒ ሙዓንቴ ኪሪስቶሴ ጉሙርቂ ዶዲባኣ ዓሢ ኔና ዴንቄቴ ዬይ ማዻ'' ኔኤኮ ሜሌ'' ፆኦዞም ሹኪንቴ ዓሽኮ ሙዓንዳጉዲ ዓሢ ማሃያቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ዬያሮ ኔኤኮ «ታ ዔራኬ» ጌይፆና ኪሪስቶሴ ዒዛ ጋይቴ ሃይቄሢና ጉሙርቂፆናኣ ዶዲባኣሢ ባይቄኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ዬያይዲ ኪሪስቶሴ ጉሙርቃ ዒንሢኮ ዒሾንሢንታ ሚሾንሢንታ ዻቢሺፆና ሃሣ ዔያቶኮ ላቤ'' ዒኖ ባሼ ላቢ''ሲፆና ኪሪስቶሴም ዋይዞ ዒፃያ ማዒ ዒንሢ ዻባኔ። ");
INSERT INTO mdybse_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ዬያሮ ሙኡዚ'' ታኣኮ ኪሪስቶሴ ጉሙርቃ ዒሻሢንታ ሚሾንታ ዻቢሻያ ማዔቴ፥ ታ ዒሻሢንታ ታ ሚሾንታ ዹቂሲፆይዳፓ ፔቴ''ታዖ ዓሽኪ ታ ሙዓዓ። ");
INSERT INTO mdybse_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ታኣኒ ቢያ ባኣዚ'' ማዻኒ ዳንዳዓ ዓሲቱዋዓዳ? ፆኦሲ ማዾ''ማኣ ታ ዳኪንቴያቱዋዓዳ? ኑ ጎዳሢ ዬሱሴ ታ ዛጊባኣዓዳ? ጎዳ ዬሱሴም ታ ማዼ ማዾ''ኮ ዓኣፓ ዒንሢቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ጎዳ ታና ፆኦሲ ማዾ''ም ዳኬያ ማዔሢ ዔርዛ ማላታ' ዒንሢ ማዔሢሮ ሃንጎዋታ ታና ፆኦሲ ማዾ''ም ዳኪንቴያኬ ጌይባኣቴያ ዒንሢም ጋዓንቴ ታ ጎኔና ፆኦሲ ማዾ''ም ዳኪንቴሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ፆኦሲ ማዾ''ም ዳኪንቲፆ ዛሎ'' ታና ዾንካ ዓሶም ታ ሂዚ ጋዓኔ፦ ");
INSERT INTO mdybse_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ሙዖ ባኣዚ''ና ዑሽኮ ባኣዚ''ና ታኣም ኮይሱዋያዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ፆኦሲ ማዾ''ም ዳኪንቴ ሜሌ''ዞንሢና ጎዳ ዬሱሴኮ ጌርሲንሢና ጴፂሮሴንሢናጉዲ ኪሪስቶሴ ጉሙርቃ ላኣሊ ዔኪ ዎላ'' ሃንታኒ ኮይሱዋኣሢ ታና ሌሊዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ሃሣ ኑና ዎይሣኒ ማዺ ላቢ'' ናንጋኒ ኮይሳሢ ባርናባሴና ታኣና ሌሊዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ዒንጎ ሚኢሼ ባኣንቴ ፔ ሚኢሼና ፖኦሊሴ ማዒ ማዻይ ዖናዳይ? ሃሣ ዎይኖ ቱካ''ዖ ዓኣፓ ካፃዛ ሙዑዋኣሢ ዖናዳይ? ቆልሞ ሄንቃያታዖ ዲኢቆ ዑሽኩዋይ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ሓያ ታ ጋዓሢ ዓሲ ማሊሢና ሌሊዳ? ሙሴ ዔርዜ ዎጋ'' ሂዚ ጎውዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ዎጎይዳ፦ «ሃኣኮ ሺርካ ጌሜኮ ዻንጎ ቱኪ''ፖ» ጌይንቲ ፃኣፒንቴኔ። ሂዳዖ ፆኦሲ ዬያ ጌዔሢ ጌማቶም ማሊዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ዒዚ ዬያ ጌዔሢ ጎኔና ኑ ዛሎ''ቱዋዓዳ? ጎኔኬ፥ ዬይ ፃኣፒንቴሢ ኑ ዛላኬ፤ ዓይጎሮ ጌዔቴ ጎሽካሢ ሃሣ ሃኣኮ ሺርካሢ ሃኣኮይዳፓ ዒዛም ሄላ''ንዳያ ዓኣሢ ዔሪ፥ ሃጊ ማዓንዳ ዎዛ ጌሣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ኑኡኒ ዒንሢም ዓያና ባኣዚ'' ዜርቃዖ ዒንሢዳፓ ዓሲ ዒንጋ ባኣዚ'' ዴንቄቴ ዬይ ዼኤፒ ባኣዚ''ዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ሃንጎዋታ ዬያ ባኮ ዒንሢዳፓ ዴንቃያ ማዔቴ ዓካሪ ኑኡኒ ዬያፓ ባሼ ዴንቃኒ ኮይሱዋዓዳ? ኑኡኒ ጋዓንቴ ዬያይዲባኣሴ፤ ኑኡኒ ዬያ ሃሼ''ሢ፥ ኪሪስቶሴ ኮዦ ሃይሶ ማዾ''ኮ ዹቆ ማዑዋጉዲ ቢያ ባኣዚ'' ጊቢ'' ኑ ዳንዳዖም ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ጌኤዦ ማኣሮይዳ ማዻ ዓሳ ሙዖ ዒኢካፓ ዴንቃሢንታ ሹጮና ማዦና፥ ፆኦሲም ዒንጎ ቤዞይዳ ማዻ ዓሳኣ ዒንጎ ባኮይዳፓ ዔኪ ሙዓሢ ዒንሢ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ዬያጉዲ ኮዦ ሃይሶ ኬኤዛ ዓሳ ዔያታ ሙዓንዳ ባኮ ዬኖ ማዻ ማዾ''ይዳፓ ዴንቃንዳጉዲ ጎዳ ዓይሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ታኣኒ ጋዓንቴ ዬያ ታኣም ኮይሳ ባኮይዳፓ ፔቴ''ታዖ ዔኪባኣሴ፤ ዬይ ታኣም ሃሢ ያዺ ማዓንዳጉዲ ጌይቱዋሴ ሃያ ታ ዒንሢም ፃኣፓሢ፤ ታ ጫርቂ ጌስቴ ባኮ ጉሪ ማሃያይዳፓ ታ ሃሃይቄቴ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ኮዦ ሃይሶ ኬኤዚፃ ታኣም ዓይሢንቴ ዓይሥሢ ማዔሢሮ ታና ሄርሺንቲሳ ባኣዚ''ቱዋሴ፤ ታኣኒ ኮዦ ሃይሶ ኬኤዚባኣያ ማዔቴ ታና ባዴዔ! ");
INSERT INTO mdybse_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ኮዦ ሃይሶ ቃኣሎ'' ናሽኪ ታ ኬኤዛያ ማዔቴ ላቢ''ፆ ዛሎ'' ታኣም ዒንጊንታንዳ ባኣዚ'' ዓኣኔ፤ ዓይሥሢና ታ ኬኤዛያ ማዔቴ «ማዼ» ጌይ ዓይሢንቴሢ ኩንሤያፓዓቴም ሜሌ'' ባኣዚ'' ታ ማዼኔ ጌይሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ሂዳዖ ታኣኮ ላቢ''ፆም ዒንጊንታ ባካ ዓይጌንዴዳይ? ዓካሪ ታኣም ዒንጊንታ ባካ ኮዦ ሃይሶ ታ ኬኤዛኣና ታኣም ኮይሳ ባኮ ዔኩዋዖ፥ ዔኤቢ ባኣያ ማዺሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ታኣኒ ዓይጎ ዓሲኮዋ ካራሚቱዋሴ፤ ማዔቴያ ታኣም ዳንዳዒንቴ ጎይፆና ሚርጌሢ ዻቂሻኒ ጌዒ ቢያሢኮ ታ ካራሚ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ዓይሁዴ ዓሶ ታ ዻቂሻኒ ዓይሁዶ ዓሶና ዓይሁዴ ዓሲ ታ ማዔኔ፤ ዎዚ ታ ሙሴ ዔርዜ ዎጎም ዓይሢንቱዋያ ማዔቴያ ሙሴ ዎጎም ዓይሢንታ ዓሶ ዻቂሻኒ ጌዒ ዔያቶጉዲ ታ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ዎዚ ታኣኒ ፆኦሲ ዎጋ''ፓ ኬስኪባኣያ ሃሣ ኪሪስቶሴ ዎጎማኣ ዓይሢንታያታዖ ዎጋባኣ፥ ዓይሁዴቱዋ ዓሶ ዻቂሻኒ ዔያቶጉዲ ታ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ኪሪስቶሴ ጉሙርቂፆና ላቤ''ዞንሢ ዻቂሻኒ ታ ዔያቶጉዲ ማዔኔ፤ ዳንዳዒንቴ ጎይፆና ፔቴ'' ፔቴ''ዞንሢ ዻቂሻኒ ቢያሢና ዎላ'' ቢያ ባኣዚ'' ታ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ዬያ ታ ቢያ ማዼሢ' ኮዦ ሃይሶኮ ዓንጆ ዴንቃኒ ኮዦ ሃይሶ ዛሎ''ሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ጳዦ ሄሌላሢዳ ቢያሢ ጳሽካዖ ዔያቶይዳፓ ፔቴ''ማ ሌሊ ቢሬሢ ዛሎ'' ዒንጎ ባኮ ዔካሢ ዒንሢ ዔሩዋዓዳ? ዬያሮ ዒንሢያ ባሺ ዔኮ ባኮ ዴንቃኒ ጳሽኩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ሄሌሎ ጳሽካ ዓሲ ጳዦኮ ቤርታ ሚርጌና ላቢ'' ጳሽኪ ጳሽኪ ዔራኔ፤ ዔያታ ዬያይዲ ላባ''ሢ፦ ባይቃ ባኣዚ''ና ዻካ'' ዎዴሮ ማዓ ቦንቾ ባኮ ዔካኒኬ፤ ኑኡኒ ጋዓንቴ ላቢ''ንታሢ' ባይቁዋያና ናንጊና ናንጋያ ማዔ፥ ቦንቾ ባኮ ዴንቃኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ታኣኒ ጋዓንቴ ሄሎ''ንዶ ቤሲ ባኣንቴ ጉሪ ጳሽካ ዓሲጉዲቱዋሴ፤ ሃሣ ዢባሬ ዱላ'' ዓሶጉዲ ጉሪ ታ ላባ''ያቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ዬያሮ ሜሌ'' ዓሶም ኬኤዛዖ ታኣሮ ታ ጉሪ ዓቱዋጉዲ ታ ዑፃ ፑርታ ባኣዚ'' ማዻንዳያይዳፓ ዎልቄና ቃዚ ቃዚ ታኣም ዓይሢንታጉዲ ታ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ኑ ዓዶንሢኮ ሻኣራ ዑፃ ሺቤም ዔያታ ዓኣዼሢና ዞቄ ባዞ''ና ዔያታ ፒንቄሢ ታ ዒንሢም ጶቂሣኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ዔያታ ሙሴና ዎላ'' ፔቴ'' ማዓኒ ዬያ ሻኣሮና ባዞ'' ዋኣፆናይዳ ማስቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ዔያታ ቢያሢ ፔቴ'' ዓያና ሙኡዚ'' ሙዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ቢያሢ ሃሣ ፔቴ'' ዓያና ዑሺ ዑሽኬኔ፤ ዬይ ዔያታ ዑሽኬሢ' ዔያቶና ዎላ'' ዓኣዻ ዓያኖ ላላሢዳፓኬ፤ ዬይ ላላሢ ፔ ቶኦኪና ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ያዺ ማዔቴያ ፆኦሲ ዔያቶኮ ሚርጌሢና ዎዛዺባኣሢሮ ሌዛ ዔያቶኮ ዓሲ ናንጉዋ ዳውሎ''ይዳ ኬኤሪንቲ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ዔያታ ፑርታ ባኣዚ'' ሱኡካዼሢጉዲ ኑኡኒያ ፑርታ ባኣዚ'' ሱኡካዹዋጉዲ ዬይ ኑም «ዒንሢና ዔሩዋቴ» ጋዓ ላቲሢ ኮኦኪንሢ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","«ዓሳ ሙዒ፥ ዑሽካኒ ዴዔኔ፤ ኮርጋኒያ ዔቄኔ » ጌይንቲ ፃኣፒንቴሢጉዲ ሃሣ ዔያታ ሜሌ'' ካኣሽኮ ባኣዚ'' ካኣሽኬ ጎይፆ ዒንሢያ ዔያቶጉዲ ሜሌ'' ካኣሽኮ ባኣዚ'' ካኣሽኪፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ዔያቶይዳፓ ፔቴ'' ፔቴ'' ዓሳ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂ፥ ጎሜ ማዼሢጉዲ ኑኡኒያ ዓኒ ሃሣ ማቾ ማዒባኣያና ላሂባኣቴ ኮሺኬ፤ ዓይጎሮ ጌዔቴ ዔያታ ዬያ ማዼሢሮ ዔያቶይዳፓ ላማታሚ'' ሃይሦ ሺያ ዓሲ ፔቴ'' ኬሊ''ና ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ሃሣ ዔያቶኮ ፔቴ'' ፔቴ'' ዓሳ ጎዳ «ዒ ዎይታቴያ ኑ ዛጎም» ጌዒ ሾኦዦና ዻይንቲ ሃይቄሢጉዲ ኑኡኒያ ያዺ ማዺባኣቴ ኮሺኬ። ");
INSERT INTO mdybse_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ዔያቶይዳፓ ፔቴ'' ፔቴ'' ዓሳ ዾንኪ፥ ጉንዱሜም ፆኦሲ ዳኬ ዎዻ ኪኢታንቻሢ ዔያቶ ዎዺ ባይዜሢጉዲ ዒንሢያ ያዺ ማዒባኣቴ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ዬይ ቢያ ባካ ዔያቶ ሄሌ''ሢ ኑም ኮኦኪንሢ ማዓንዳጉዲኬ፤ ሃሣ ፃኣፒንቴሢያ ዎዶ''ኮ ጋፒንፆይዳ ዓኣ፥ ኑም «ዒንሢና ዔሩዋቴ» ጋዓ ላቲሢምኬ። ");
INSERT INTO mdybse_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ዬያሮ «ጉሙርቂፆና ታ ዶዲ ዓኣኔ» ጋዓሢ ሎኦሙዋጉዲ ፔና ኮሺ'' ዔሮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ዓሲ ሜሌ''ይዳ ሄሊ''ባኣ፥ ፆኦሲ ዛጋኒ ዳካ ሜታ ዒንሢ ሄሊ''ባኣሴ፤ ፆኦሲ ጉሙርቂንታያታሢሮ ዒንሢ ዳንዳዓንዳሢኮ ዑሣ ዓኣዼ ዒንሢ ሜታዻንዳጉዲ ዒ ኮዑዋሴ፤ ዒንሢም ሜታሢ ዒንጊ ዒንሢ ዛጎ ዎዶ''ና ዳንዳዓንዳጉዲ ዎልቄ ዒንጊ፥ ዒንሢ ኬስካንዳ ጎይሢያ ዒንሢም ዒ ጊኢጊሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ዓካሪ ዒጊኖንሢዮቴ! ሜሌ'' ካኣሽኮ ባኮ ካኣሽኪፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ዬያ ታ ዒንሢም ጋዓሢ ዒንሢ ዔራ ዓሲ ማዔሢሮኬ፤ ሂንዳ ታ ኬኤዛ ባኮ ዒንሢ ዒንሢሮ ዎጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ፆኦሲ ሺኢቂ ኑኡኒ ዑሽካ ባካ ኪሪስቶሴ ሱጉፆና ፔቱሞ ዓኣያቱዋዓዳ? ሃሣ ኑኡኒ ዎላ'' ዔካ ካፃ ኪሪስቶሴና ዎላ'' ፔቴ''ቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ኑ ሙዓሢ ፔቴ'' ካሣ ሌሊታሢሮ ዎዚ ኑ ሚርጌታቴያ ፔቴ'' ዑሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ሂንዳ ዒስራዔኤሌ ዴራ'' ማዼ ባኮ ማሉዋቴ፤ ፆኦሲም ዒንጎና ባኮ ሙዓዞንሢና ሹጮና ኮሾ''ና ዒንጎ ቤዞናኮ ፔቱሞ ባኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ሂዳዖ ሜሌ'' ካኣሽኮ ባኮም ሹኪንቴ ቆልሞ ዓሽኮና ሃሣ ካኣሽኮ ባካኣ ዔኤቢኬ ታ ጋዓኔ ጌይሢዳ? ");
INSERT INTO mdybse_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ያዺቱዋሴ፤ ፆኦሲ ዔሩዋ ዓሳ ቆልሞ ሹካሢ ፆኦሲምቱዋንቴ ፑርቶ ዓያኖምኬ፤ ዬያሮ ዒንሢ ፑርቶ ዓያኖና ዎላ'' ፔቴ'' ማዓንዳጉዲ ታ ኮዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ጎዳ ባኮ ዑሽኪ ዑሽኪ ሃሣ ፑርቶ ዓያኖ ባኮዋ ዒንሢ ዑሽካኒ ዳንዳዑዋሴ፤ ዬያጉዲ ሃሣ ጎዳ ባኮ ሙዒ ሙዒ ፑርቶ ዓያኖ ባኮዋ ዒንሢ ሙዓኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ዓካሪ ኑኡኒ ጎዳ ባኮ ሃሺ''ፆና ዒዛ ዻጋሶንዶ? ኑ ዒዛይዳፓ ባሼ ዶዲኬ ጌይሢዳ? ");
INSERT INTO mdybse_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","«ቢያ ባኣዚ'' ማዻንዳጉዲ ዓይሢንቴያኬ» ጋዓንቴ ቢያ ባካ ማኣዳ''ያቱዋሴ፤ «ቢያ ባካ ማዻንዳጉዲ ዓይሢንቴያኬ» ጋዓንቴ ቢያ ባካ ኮሻ''ያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ፔቴ'' ፔቴ''ሢ ሜሌ''ሢም ማዓ ባኮዋ ማላንዳኣፓዓቴም ፔኤም ማዓ ባኣዚ'' ሌሊ ዛጎፓ። ");
INSERT INTO mdybse_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ዒኔና ማሊ ሂርጉዋዖ፥ ቦኦካይዳ ሻንቺንታ ዓሽኮ ዚቲ ጋዓዖ ሙዑዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ዓይጎሮ ጌዔቴ፦ «ሳዖና ጋሮይዳ ዓኣ ባካ ቢያ ጎዳሮኬ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ኪሪስቶሴ ጉሙርቁዋ ዓሲ ሙኡዚ'' ሙዖም ዒንሢ ዔኤሌ''ያ ማዔም ዒንሢ ዓኣዻኒ ኮዔቴ ዒኔና ማሊ ሂርጉዋዖ ዚቲ ጌይ ዒንሢም ዒንጊንቴ ዓይጎ ሙኡዚ''ታቴያ ቢያ ሙዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ጋዓንቴ ፔቴ'' ዓሲ፦ «ሃይ ዓሽካ ሜሌ'' ካኣሽኮ ባኣዚ''ም ሹኪንቴያኬ» ዒንሢም ጌዔቴ፥ ዬያ ኬኤዜ ዓሢንታ ዒኔ ቆፂ ማላ ማሊፆንታሮ ጌዒጋፓ ዬያ ሙዒፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ማሊፆ ታ ጌዔሢ ዓሢ ማሊፆሮ ጌይሢ ማዓንዳኣፓዓቴም ዒንሢሲቱዋሴ፤ ዓካሪ ሜሌ'' ዓሲ ማሊሢ ዛላ ጌዒ ዎይቲ ታና ላኣጊንታይ? ");
INSERT INTO mdybse_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ታኣኒ ፆኦሲ ጋላቲ ጋላቲ ሙዔቴ ፆኦሲ ታ ጋላቲ ሙዔ ባኮና ዎይቲ ታ «ዻቤኔ» ጌይንታይ? ");
INSERT INTO mdybse_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ዓካሪ ሙዓቶዋ፥ ዑሽካቶዋ ዓይጎ ባኣዚ''ያ ማዻቴ ቢያ ባኣዚ'' ፆኦሲ ቦንቾም ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ዓይሁዶ ዓሶም ማዔቴያ ዓይሁዶ ማዒባኣ፥ ጊሪኮ ዓሶም ሃሣ ኪሪስቶሴ ጉሙርቃ ዓሶማኣ ዹቆ ማዒፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ታኣኒ ቢያሢ ዻቃንዳጉዲ ሜሌ'' ዓሶም ኮይሳ ባኮ ማዓንዳኣፓዓቴም ታኣም ኮይሳ ባኮ ኮውዋዖ ቢያ ዓሲ፥ ቢያ ባኣዚ''ና ታ ዎዛሳሢጉዲ ዒንሢያ ዬያይዱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ታኣኒ ኪሪስቶሴ ማዼ ጎይፆ ማዻሢጉዲ ዒንሢያ ታ ማዻ ጎይፆማ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ታ ማዼ ባኮና ታ ዒንሢ ዔርዜ ባኮና ዶዲሺ ዓርቂ ዒንሢ ጶቂሣሢሮ ታ ዒንሢ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ጋዓንቴ ዓቲንቄኮ ቢያ ዑፃ ቢታንቶ ዓኣሢ ኪሪስቶሴ ማዔሢ፥ ላኣሊ ዑፃ ቢታንቶ ዓኣሢ ዓቲንቄ ማዔሢ፤ ሃሣ ኪሪስቶሴ ዑፆይዳኣ ቢታንቶ ዓኣሢ ፆኦሲ ማዔሢ ዒንሢ ዔራንዳጉዲ ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ቶኦኪ ካንቂ ፆኦሲ ሺኢቃያና ፆኦሲ ማሊሢ ኬኤዛ ዓቲንቄ ቢያ ዒዛኮ ቶኦካ''ሢ ማዔ ኪሪስቶሴ ቦሂሳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ዬያጉዲ ቶኦኮ'' ፔኤኮ ዖሹዋዖ ሺኢቃያ፥ ሃሣ ፆኦሲ ማሊሢ ኬኤዛ ላኣሌላኣ ዒዞኮ ቶኦካ''ሢ ማዔ ዓቲንቃሢ ቦሂሳኔ፤ ዎይቲ ጌዔቴ ፔ ቶኦኮ'' ዖሹዋ ላኣሌላ ጉኡሊ''ንቴያጉዲ ማዓሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ላኣሊ ፔ ቶኦኮ'' ዖሹዋያ ማዔቴ ቶኦኮ'' ፔኤኮ ታይዞንጎ፤ ጋዓንቴ ቶኦኮ'' ታይዚፆንታ ጉኡሊ''ፆንታ ቦርሳያ ዒዞም ማዔቴ ቶኦኮ'' ዖሾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ዓቲንቄ ፆኦሲ ማሎና ሃሣ ፆኦሲ ቦንቾም ማዓያ ማዔሢሮ ፔኤኮ ቶኦኮ'' ካንቃንዳያ ኮይሱዋሴ፤ ላኣሊ ጋዓንቴ ዓቲንቄኮ ቦንቾ ማዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ዎይቲ ጌዔቴ ላኣሊ ዓቲንቄይዳፓ ማዢንቴያፓዓቴም ዓቲንቄ ላኣሊፓ ማዢንቲባኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ሃሣ ላኣሊ ዓቲንቄም ማዢንቴያፓዓቴም ዓቲንቄ ላኣሊም ማዢንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ዬያ ዛሎ''ንታሮ ሃሣ ፆኦሲ ኪኢታንቻኣ ዒዞ ዛጋሢሮ ጌዒ ላኣሊ ዓቲንቄ ቢታንቶ ዴማ'' ማዔሢ ዔርዛኒ ቶኦኮ'' ፔኤኮ ዖሺንታንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ጎዳ ማሊፆና ላኣሊ ዓቲንቄ ባኣያ፥ ዓቲንቄ ላኣሊ ባኣያ ማዑዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ዓይጎሮ ጌዔቴ ላኣሊ ዓቲንቄይዳፓ ማዢንቴሢጉዲ ዓቲንቄያ ላኣሊዳፓ ሾይንታሢሮኬ፤ ጋዓንቴ ዓቲንቄ ማዔቴያ ላኣሊ፥ ሃሣ ቢያ ባኣዚያ ጴዻሢ ፆኦሲዳፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ሂንዳ ዒንሢሮ ዎጉዋቴ፤ ላኣሊ ፔኤኮ ቶኦኮ'' ዖሹዋዖ ፆኦሲ ሺኢቂፃ ቃራዳ? ");
INSERT INTO mdybse_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ዓቲንቄ ሃሣ ፔኤኮ ቶኦኮ'' ዲቼቴ ጊኢጉዋያታሢ ፆኦሲ ቢያ ባኮ ናንጎም ጌዔ ጎይፃፓ ዒንሢም ዔርቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ላኣሊ ጋዓንቴ ጋፓና ዒዞም ዒንጊንቴሢ ቶኦኮ'' ዒዛ ዖሻንዳጉዲ ማዔሢሮ ጋፓኖ ፔኤኮ ዒዛ ዲቼቴ ዒዞም ቦንቾኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ዬያ ዛሎ'' ማርማኒ ኮዓ ዓሲ ዓኣቶ ኑኡኮ ማዔቴያ ሜሌ'' ኪሪስቶሴ ጉሙርቃ ዓሶኮ ዬያይዶ ዳምቤ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ዒንሢ ቡኪንታኣና ዒንሢ ማዻ ባካ ባባይዛ ባኣዚ'' ማዓንዳፓዓቴም ዒንሢ ፓሣ ባኣዚ'' ማዒባኣሢሮ ታ ዒንሢም ሃሢ ዓይሣ ዓይሢፆና ዒንሢ ጋላታኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ቢያፓ ቤርታ ዒንሢ ፔቱሞ ቡኪንቶ ቡካኣና ባኣካ'' ዒንሢኮ ዱሙሞ ዓኣሢ ታ ዋይዜኔ፤ ታ ዋይዜ ባኮኮ ዛላ'' ጎኔ ማዓንዳኔ ታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ፒዜ ማዔዞንሢ ዎንሢ ማዔቴያ ዱማዺ ዔርታንዳጉዲ ዒንሢ ባኣካ'' ዱማዺፃ ማዢንታንዳሢ ኮይሳያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ዒንሢ ቡኪንታዖ ሙዋ ሙዓ ጎዳ ማዾ'' ካሦቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ዎይቲ ጌዔቴ ዒንሢ ሙዓኣና ፔቴ''ይ ባጋሢ ካፑዋዖ፥ ፔኤሮማ ሩኡሪ ሙዓኔ፤ ዬያይዲፆና ፔቴ''ይ ናይዺንታዛ ባጋሢ ማሢንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ዔዛታ! ዒንሢ ሙዓያናኣ ዑሽካ ማኣሪ ዒንሢኮ ባኣዓዳ? ሃንጎታቴ ዒንሢ ኪሪስቶሴ ጉሙርቃ ዓሶ ቦሃኔ ጌይሢዳ? ሃሣ ዓይጌያ ባኣ፥ ሜታዻ ዓሶ ዒንሢ ቦርሲሳኔ ጌይሢዳ? ዓካሪ ታ ዒንሢ ዎዚ ጋዓንዳይ? ዬያ ባኮሮ ታ ዒንሢ ጋላቶንዶ? ፔቴ''ታዖ ታ ዒንሢ ጋላታዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ታኣኒ ጎዳይዳፓ ዔሪ፥ ዒንሢማኣ ታ ዔርዛሢ ሃያኬ፤ ጎዳ ዬሱሴ ዓርቂንቲ ዒንጊንቴ ዋንቴሎ ካሣ ዔኪ፥ ");
INSERT INTO mdybse_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ፆኦሲ ሺኢቄስካፓ ቡንፃዖ፦ «ሃቦቴ ሙዑዋቴ፤ ሓይ ዒንሢ ዛሎ'' ዒንጊንታንዳሢ፥ ታናኬ፤ ሃያና ታና ጶቂሣያ ማሁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ዬያጉዲ ካሦኮ ጊንፃ ዑሽኮ ባኮ ዔኪ፦ «ሓይ ዑዣ ታኣኮ ሱጉፆና ማዓ ዓኮ ጫኣቃሢኬ፤ ዒንሢ ዑሽካኣና ቢያ ሃያና ታና ጶቂሣያ ማሁዋቴ» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ዬያሮ ሃያ ካፆ ዒንሢ ሙዓኣና ዑዦዋ ዒንሢ ዑሽካኣና ቢያ ጎዳ ሙካንዳያ ሄላ''ንዳኣና ዒዛኮ ሓይቦ'' ዛሎ'' ዒንሢ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ዖኦኒያ ዒዛም ኮይሱዋያ ጎይሢና ሓያ ካሦ ቦሂ ሙዒ፥ ዑዦዋ ዑሽኬቴ ጎዳና ሱጉፆናኮ ጋሌ ዓሲ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ዬያሮ ዓይጎ ዓሲያ ማዖም ዬያ ካሦ ሙዒፆና ዑዦዋ ዑሽኪፆናኮ ቤርታ ፔና ዛጋንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ዓይጎ ዓሲያ ማዖም «ጎዳኬ» ጌዒ ሙዖ ካሣ ዓይጎታቴያ ዱማሲ ዔሩዋዖ ጎዳ ማሊ ጶቂሶ ካፆ ሙዒ ዑዦዋ ዑሽኬቴ ፔ ቶኦካ'' ሜቶ ዔኪ ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ዒንሢ ባኣካ''ፓ ሚርጌሢ ላቢ''ንቴሢ፥ ሓርጌሢ ሃሣ ሓይቄሢያ ዬያ ዛሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ዎንዴ ኑና ኑ ዛጊ ዔሬያታቴ ያዺ ኑ ጊዳ'' ፑርታና ዎጊንቲንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ጋዓንቴ ጊንፃፓ ዓጮ''ና ዎላ'' ኑ ፑርታና ዎጊንቱዋጉዲ ጎዳ ሃሢ ኑ ዔሮም ጌዒ ፑርታና ዎጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ዬያሮ ታ ዒሾንሦ! ታ ሚሾንሦ! ጎዳ ማዾ'' ሙዖ ሙዓኒ ዒንሢ ቡካኣና ዎሊ ካፑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ዒንሢ ቡኪንታኣና ዒንሢ ፑርታና ዎጊሳ ባኣዚ'' ማዑዋጉዲ ዒንሢ ባኣካ'' ናይዼ ዓሲ ዓኣቶ ፔኤኮ ማኣራ ሙዖንጎ። ዓቴ'' ባኮ ዒንሢ ኮራ ታ ሙካዖ ማዾንዶ ጎይፆ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ሃሣ ዓያኖ ጌኤዣ ዒንጋ ዒንጊፆኮ ጎኑሞ ዒንሢ ዔራንዳጉዲ ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ቤርታ ዒንሢ ፆኦሲ ዓሲ ማዒባኣ ዎዶ''ና ጌስታኒ ዳንዳዑዋ ካኣሽኮ ባኮ ካኣሽካንዳጉዲ ሴካ ሃንጋ ዒሺንቲ ዒንሢ ዔኪ ዓኣዺንቴሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ዖኦኒያ ፆኦሲ ዓያናና ኬኤዛዖ፦ «ዬሱሴ ጋዳንቂንቴያኬ!» ጋዓ ዓሲ ባኣሴ፤ ዬያጉዲ ሃሣ ዓያና ጌኤሺና ማዒባኣያታዖ፦ «ዬሱሴ ጎዳኬ!» ጋዓ ዓሲ ባኣሢ ታ ዒንሢም ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ዱማ ዱማ ዓያና ጌኤሺ ዒንጋ ዒንጊሢ ዓኣኔ፤ ዓያና ጌኤሺ ጋዓንቴ ፔቴ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ዱማ ዱማ ማዾ ዓኣኔ፤ ጎዳ ጋዓንቴ ፔቴ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ዱማ ዱማ ማዺንታ ባኣዚ'' ዓኣኔ፤ ጋዓንቴ ቢያ ባኮ ቢያሢና ማዻሢ ፔቴ'' ፆኦዛሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ፔቴ'' ፔቴ''ሢም ዓያኖ ጌኤዣ ፔጋሲ ዻዋ ባኮ ዻዋሢ ቢያሢ ማኣዳ''ንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ፔቴ''ሢም ጪንጪ ጌስታንዳጉዲ ዓያኖ ጌኤዦ ዛሎ''ና ዒንጊንታኔ፤ ባጋሢም ሃሣ ዬኖ ዓያኖ ዛሎ''ና ዔራቶና ጌስታንዳጉዲ ዒንጊንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ፔቴ''ሢም ሃሣ ዬኖ ዓያኖ ዛሎ''ና ፆኦሲ ጉሙርቂሢ ዒንጊሢ ዒንጊንታኔ፤ ባጋሢም ጊንሣ ሓርጌፓ ዓሲ ፓሥሢ ዒንጊሢ ዒንጊንታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ዬያጉዲ ሃሣ ዓቴ''ሢም ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዻንዳ ዎልቄ ዒንጊንታኔ፤ ባጋሢም ጊንሣ ፆኦሲ ማሊሢ ኬኤዚሢ ዒንጊሢ ዒንጊንታኔ፤ ሜሌ''ሢም ሃሣ ዒንጊንታ ዒንጊፃ ዓያና ጌኤሺፓታቴያ ፑርታ ዓያናፓታቴያ ዱማሲ ዔራንዳ ዒንጊሢ ዒንጊንታኔ፤ ዬያጉዲ ፔቴ''ሢም ዓኪ ሙኡቺና ጌስታንዳጉዲ ዒንጊሢ ዒንጊንታኔ፤ ሜሌ''ሢም ጊንሣ ዬያ ዓኮ ሙኡጮና ጌስቲንቴ ባኮ ቡላ''ንዳ ዒንጊሢ ዒንጊንታኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ዬይ ያዺ ማዔቴያ ዬያ ቢያ ማዻሢ ዬያ ፔቴ'' ዓያኖ ጌኤዦኬ፤ ዓያና ጌኤሺ ኮዔሢ ጎይፆ ፔቴ'' ፔቴ''ሢም ዱማ ዱማ ዒንጊሢ ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ፔቴ'' ዑሢኮ ዱማ ዱማ ቤሲ ዓኣኔ፤ ዑፆኮ ሚርጌ ቤሲ ዓኣያታቴያ ዬይ ሚርጌ ቤዛ ዬኖ ፔቴ'' ዑፆይዳኬ። ዬያጉዲ ኪሪስቶሴ ሚርጌ ቤሲ ዓኣ ፔቴ'' ዑሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ዎይቲ ጌዔቴ ዓይሁዴታቴያ ዓይሁዴ ማዒባኣ ጊሪኬ ዓሳ፥ ዓይሌታቴያ ዓይሌ'' ማዒባኣ ዓሳ ፔቴ'' ዑሢ ማዓኒ ዓያኖ ጌኤዦና ኑ ማስቴኔ፤ ሃሣ ቢያሢ ዬያ ፔቴ'' ዓያናሢ ኑ ዑሽካንዳጉዲ ኑም ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ፔቴ'' ዑሢ ማዢንቴሢ ሚርጌ ዱማ ዱማ ቤሲና ማዓንዳኣፓዓቴም ፔቴ'' ቤሲናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ዬያሮ ቶኪ፦ «ታኣኒ ኩቺቱዋኣሢሮ ዑሢኮ ፔቴ'' ቤሲቱዋሴ» ጌዔቴ ያዺ ጌይፆና ዑሢኮ ፔቴ'' ቤሲ ማዒፃ ዓታንዳ? ");
INSERT INTO mdybse_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ዋይዚያ፦ «ታኣኒ ዓኣፒቱዋኣሢሮ ዑሢኮ ፔቴ'' ቤሲቱዋሴ» ጌዔቴ ዓካሪ ዬያ ጌይፆና ዑፆኮ ፔቴ'' ቤዞ ማዒፃ ዓታንዳ? ");
INSERT INTO mdybse_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ሂንዳ ዑሢ ቢያ ዓኣፒ ሌሊ ማዔቴ ዔኤቢ ዋይዛ ባኣዚ'' ዓንካፓ ጴዻንዳያናንዳይ! ሃሣ ዑሢ ቢያ ዋይዚ ሌሊ ማዔቴ ዔኤቢ ዼሂ ዔራ ባኣዚ'' ዓንካፓ ጴዻንዳያናንዳይ! ");
INSERT INTO mdybse_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ሃሢ ጋዓንቴ ፆኦሲ ኮዔሢ ጎይፆ ዑፆኮ ፔቴ'' ፔቴ'' ቤዞ ዑፆይዳ ኮይሳ ቤዛ ቤዛ ማዓንዳጉዲ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ዑሢ ማዢንቴሢ ፔቴ'' ቤሲና ሌሊ ማዔቴ ኩሙሢ ዑሢ ጌይንታሢ ዓንካፓ ጴዻንዳያናንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ዓካሪ ዑሢኮ ዱማ ዱማ ቤሲ ዓኣያ ማዔቴያ ዑሢ ፔቴ'' ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ዓኣፒ ኩቺ ኮራ፦ «ኔኤኒ ታኣም ኮይሱዋሴ» ጋዓኒ ዳንዳዑዋሴ፤ ቶኦኪያ ቶኪ ኮራ፦ «ኔ ታኣም ኮይሱዋሴ» ጋዓኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ጎኔና «ፓሡዋያኬ» ጌይንታ ቤዛታዖ ሚርጌና ኑም ኮይሳያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","«ዻካኬ» ኑ ጋዓ ኑ ዑፆ ቤዞ ባሼ ኑ ቦንቻኔ፤ ሃሣ ኑና ቦርሲሳያ ማዓ ቤዞዋ ሚርጌና ኑ ሂርጊ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ቦንቺንታ ዑፆም ጋዓንቴ ዬይ ቢያ ኮይሱዋሴ። ቦርሲሳያ ማዒ ጴዻ ቤዛ ባሼ ቦንቺንቲ ዓርቂንታንዳጉዲ ዑፆኮ ፔቴ'' ቤሲ ማሂ ፆኦሲ ማዤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ዬያ ዒ ማዼሢ' ፔቴ'' ዑፆኮ ዱማ ዱማ ቤዛ ዱማዹዋዖ ዎሊም ማላንዳጉዲ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ዑሢኮ ፔቴ'' ቤሲ ሜታዻኣና ዓቴ'' ዑፆኮ ቤዛ ቢያ ዎላ'' ሜታዻኔ፤ ሃሣ ፔቴ'' ቤሲ ቦንቺንታኣና ዎላ'' ቢያሢ ቦንቺንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ዬያጉዲ ዓካሪ ዒንሢ ኪሪስቶሴ ዑፆኬ፤ ዒንሢ፥ ፔቴ'' ፔቴ''ሢ ዒዛ ዑፆኮ ዱማ ዱማ ቤዞኬ። ");
INSERT INTO mdybse_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ዬያሮ ፆኦሲ ፔቴ'' ፔቴ'' ዓሶ ሺኢጲፆ ማኣሮይዳ ዱማ ዱማ ማዾ ዓኣያ ማዓንዳጉዲ ማሄኔ፤ ዬያ ጎይፆና ፔቴ'' ጋዓዖ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢ፥ ላምዓሳዖ ፆኦሲ ማሊሢ ኬኤዛዞንሢ፥ ሓይሣሳዖ ዔርዛዞንሢ ማሂ ዓሶ ዶኦሬኔ። ዬያጉዲ ሃሣ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዻዞንሢ፥ ሓርጌ ዓሶ ፖዒሳ ዒንጊሢ ዓኣዞንሢ፥ ዓሲ ማኣዲ''ሢ ዒንጊሢ ዓኣዞንሢ፥ ዓሲ ዎይሥሢ ዒንጊሢ ዓኣዞንሢና ዓኪ ሙኡቺና ጌስቲሢ ዒንጊሢ ዓኣዞንሢ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ዬያሮ ቢያሢ ፆኦሲ ማዾ''ም ዳኪንቴያቱዋሴ፤ ቢያሢ ሃሣ ፆኦሲ ማሊሢ ኬኤዛያቱዋሴ፤ ቢያሢ ዓሲ ዔርዛያቱዋሴ፤ ቢያሢ ፆኦሲ ዎልቄና ማዺንታ ዓኪ ባኣዚ'' ማዻያቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ቢያሢኮ ሓርጌ ዓሲ ፓሣ ዒንጊሢ ዓኣያቱዋሴ፤ ቢያሢ ዓኪ ሙኡቺና ጌስታኒ ዳንዳዑዋሴ፤ ቢያሢ ሃሣ ዓኮ ሙኡጮና ጌስቶናሢ ቡላ''ኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ጋዓንቴ ቢያሢፓ ባሼ ማዔ ዒንጊፆ ዴንቃኒ ኮዑዋቴ። ዓካሪ ታ ዒንሢ ቢያፓ ባሼ ማዔ ጎይሢ ዻዋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ዓሲ ጌስታ ሙኡቺታቴያ ሃሣ ፆኦሲ ኪኢታንቻ ጌስታ ሙኡቺያ ጌስቲ ታ ዔሬንቴ ናሹሞ ታኣኮ ባኣያታቴ ዖኦላ'' ሉኡሊና ሂቾናጉዲ ታ ማዔኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ፆኦሲ ማሊሢ ኬኤዚሢ ዒንጊሢ ታኣኮ ዓኣቶዋ ሃሣ ዓኣሺንቴ ባኣዚ'' ቢያ ታ ዔራያ ማዔቴያ፥ ዬያጉዲ ቢያ ባኣዚ'' ታ ዔሬቴያ ሃሣ ዹኮ'' ፔቴ'' ቤስካፓ ሺኢሻንዳ ፆኦሲ ጉሙርቂሢ ታኣኮ ዓኣቴያ ናሹሞ ባኣያታቴ ዬይ ታኣኮ ጉሪኬ። ");
INSERT INTO mdybse_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ታኣኮ ዓኣ ባኮ ቢያ ማንቆ ዓሶም ታ ዒንጋያ ማዔቴያ፥ ታ ዑፆታዖ ታሚዳ ሚጫንዳጉዲ ታ ማሃያ ማዔቴያ ናሹሞ ታኣኮ ባኣቴ ዓይጎዋ ታና ዬይ ማኣዳ''ዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ናሹሞ ጊቢ'' ዳንዳዒሳያኬ፤ ሃሣ ኮሺ ባኣዚ'' ማዺሻኔ፥ ቂኢሪሱዋሴ፥ ሄርሺንቲሱዋሴ፥ ዖቶርሱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ኮይሱዋያ ባኣዚ'' ማዺሹዋሴ፥ ፔ ባኣዚ'' ሌሊ ኮይሲሱዋሴ፥ ዻጋሱዋሴ፥ ዻቦናቴያ ዻቢንቶ ዓርቂሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ናሹሞ ዓኣ ዓሲ ጎኔ ማዔ ባኣዚ''ና ዎዛዻኣፓዓቴም ፑርታ ባኣዚ''ና ዎዛዹዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ቢያ ባኣዚ'' ጊቢ'' ዳንዳዒሳኔ፤ ቢያ ባኣዚ''ና ፆኦሲ ጉሙርቂሳኔ፤ ቢያ ባኣዚ''ዳ ሃጊ ማዓንዳ ዎዛ ጌሢሳኔ፤ ቢያ ባኣዚ''ያ ዶዲ ዓኣሢሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ናሹሞ ዓኣ ዓሲ ቢያ ዎዴ ናናንጋኔ፥ ባይቁዋሴ፤ ፆኦሲ ማሊሢ ኬኤዚሢ ዒንጊሢ ማዔቴያ ዻካ'' ዎዴሮ ማዔሢሮ ባባይቃኔ፤ ዓኪ ሙኡቺና ጌስቲሢ ማዔቴያ ዻካ'' ዎዴሮታሢሮ ዓታኔ፤ ዔራቶ ማዔቴያ ባይቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ዎይቲ ጌዔቴ ኑኡኒ ዔራ ባኮ ማዔቴያ ፆኦሲ ማሊፆ ኬኤዛሢታቴያ ዛላ ኑ ዔሪ ኬኤዛያ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ጋዓንቴ ጉቤ ማዔ ባካ ሙካዛ ዛላ ማዔ ባካ ዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ናይ ታ ዓኣ ዎዶ''ና ናይጉዲ ታ ጌስታኔ፥ ማላኔ፤ ሃሣ ቢያ ባኮ ታ ዛጋኔ። ዶዲ ዓሲ ታ ማዓዖ ጋዓንቴ ናኣቱሞ ማሊፆ ታ ሓሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ሓሢ ኑኡኒ ሌማሌኤሼና ዛጎሢጉዲ ሌም ሌም ጌዔ ባኣዚ'' ዛጋኔ፤ ዬኖና ጋዓንቴ ኑ ጌኤሺ'' ዛጋንዳኔ። ሃሢ ታ ዔራሢ ዔቦኮ ዛላኬ፤ ዬኖና ጋዓንቴ ፆኦሲ ታና ዔራ ጎይፆጉዴያ ኩሙሢ ዔራቶ ዓኣያ ታ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ዓካሪ ጉሙርቂሢና ሓጊ ማዓንዳ ዎዛና ናሹሞና፥ ዬንሢ ሃይሦንሢ ባይቁዋያ ማዒ ናንጋንዳኔ፤ ዬንሢ ባኮይዳፓ ባሼዛ ናሹሞኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ናሹሞ ዓይሣ ጎይፆማ ማዹዋቴ፤ ሃሣ ዓያኖ ጌኤዦ ዒንጊፆ ባሼና ፆኦሲ ማሊሢ ኬኤዚሢ ሚርጌና ኮዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ዓኪ ሙኡቺና ኬኤዛሢ ፆኦሲም ኬኤዛኔ፥ ዓሲም ኬኤዙዋሴ፤ ዎይቲ ጌዔቴ ዓኣሺንቴ ባኣዚ'' ዓያና ጌኤሺ ዎልቄና ኬኤዛያ ማዔሢሮ ዒ ኬኤዛ ባኮ ዔራ ዓሲ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ፆኦሲ ማሊሢ ኬኤዛሢ ጋዓንቴ ዓሶ ኮሻ''ኒና ዞራኒ ሃሣ ዶዲሻኒ ዓሲም ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ዓኪ ሙኡቺና ጌስታሢ ፔና ሌሊ ኮሻ''ኔ፤ ፆኦሲ ማሊሢ ኬኤዛሢ ጋዓንቴ ኪሪስቶሴ ጉሙርቃ ዓሶ ቢያ ዶዲሺ ማዣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ዒንሢ ቢያሢ ዓኪ ሙኡቺና ጌስታቴ ቃራታንቴ፥ ባሼ ታ ናሽካሢ ፆኦሲ ማሊሢ ዒንሢ ኬኤዛቶኬ፤ ዓይጎሮ ጌዔቴ ኪሪስቶሴ ጉሙርቃ ዓሳ ቢያ ዶዲሺ ማዢንታንዳጉዲ ዓኮ ሙኡጮና ጌስቲንቴሢ ቡላ''ይ ባኣያ ማዔቴ ዓኪ ሙኡቺና ጌስታ ዓሲዳፓ ፆኦሲ ማሊሢ ኬኤዛሢ ባሼኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ዓካሪ ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዒንሢ ኮራ ሙካዖ ዓኪ ሙኡቺና ጌስቴቴ ዓይጎ ዒንሢ ታ ማኣዳ''ንዳይ? ዬያይዳፓ ዒንሢ ማኣዳ''ንዳሢ ፆኦሲኮ ዓኣሺንቴ ባኮ ፔጋሲ ኬኤዜቴ፥ ዔራቶና ጌስቴቴ፥ ፆኦሲ ማሊሢ ኬኤዜቴ፤ ሃሣ ዒንሢ ዔርዞንዶ ባኣዚ'' ዔርዜቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ሹሉንጎና ጎኦላ''ናጉዴ፥ ሼምፓባኣ ኮፆም ማዓ ባኮኮታዖ ዱማ ዱማ ዋርቂንታ ዑኡሲ ባኣያ ማዔቴ ዔያታ ዖኦላ''ዛ ዓይጎ ማዔቴያ ዎዲ'' ዔርታኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ዖልዚም ዋርቂንታ ዛያሢ ዔርቱዋ ጎይሢ ዋርቂንቴቴ ዖልዚም ዖኦኒ ጊኢጊንታንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ዬያጉዲ ዒንሢ ዔርታ ሙኡቺና ኬኤዚባኣቶ ዒንሢ ኬኤዛ ባኮ ዖኦኒ ዔራኒ ዳንዳዓንዳይ? ዢባሬይዳ፥ ጉሪ ዒንሢ ኬኤዛያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ዓጮ''ይዳ ቢያ ሚርጌ ሙኡቺ ዓኣኔ፤ ጋዓንቴ ቢያሢኮ ፔ ጌስታ ጎይሢ ዓኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ዓካሪ ጌስቲንቴ ሙኡጫ ዎዚ ጋዓቴያ ታ ዔሩዋያ ማዔቴ ዬያ ዓሢም ታ ዓኪ ማዓንዳኔ፤ ዒዚያ ታኣም ዓኪ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ዒንሢያ ዓያኖ ጌኤዦኮ ዒንጊፆ ሚርጌና ኮዓሢሮ ባሼ ዒንሢ ኮዓንዳያ ኮይሳሢ ኪሪስቶሴ ጉሙርቃ ዓሶ ዶዲሺ ማዣ ዒንጊፃ ዒንሢም ሚርጋንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ዬያሮ ዓኪ ሙኡቺና ጌስታ ዓሲ ጌስቲንቴ ባኮ ቡሊ'' ኬኤዛኒ ዳንዳዒሢ ዒዛኮ ዓኣያ ማዓንዳጉዲ ሺኢቆንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ዓኪ ሙኡቺና ታ ሺኢቃ ዎዶ''ና ዓያና'' ታኣኮ ሺኢቃኔ፤ ታኣኒ ጋዓንቴ ዔሬ ባኣዚ'' ባኣያ ማዒ ዓታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ዬያሮ ታ ዎዳ''ንዳያ ኮይሳይ ጌዔቴ ዓያናና ታ ሺኢቃንዳኔ፤ ሃሣ ጊንሣ ታ ዒኖናኣ ሺኢቃንዳኔ፤ ዓያናናኣ ታ ፆኦሲም ዓይናዻንዳኔ፤ ታ ዒኖናኣ ፆኦሲም ታ ዓይናዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ያዺ ማዒባኣያታቴ ኔኤኒ ዓያኖና ሌሊ ፆኦሲ ጋላታኣና ኔ ጋዓ ባኮ ዔሩዋ ዓኪ ዓሲ «ዓኣሜን» ዎዲ'' ጋዓንዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ኔኤኒ ሺኢቃ ጋላቶ ሺኢጲፃ ሚርጌና ቃራ ማዓኒ ዳንዳዓኔ፤ ጋዓንቴ ሜሌ'' ዓሲ ዬይ ዶዲሺ ማዡዋያ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ታኣኒ ዒንሢ ቢያሢዳፓ ባሼ ዓኪ ሙኡቺና ጌስታሢሮ ፆኦሲ ታ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ጋዓንቴ ዓኪ ሙኡቺና ሜሌ'' ዓሶ ዔርዛኒ ሚርጌ ሺያና ፓይዲንታ ባኣዚ'' ኬኤዚሢዳፓ ኪሪስቶሴ ጉሙርቃ ዓሶ ባኣካ'' ዶንጎ ባኣዚ'' ዔርታ ሙኡቺና ታ ዒናፓ ማሊ ታ ኬኤዜቴ ባሼኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ታ ዒሾንሦ! ታ ሚሾንሦ! ፑርታ ባኣዚ'' ማዺሢም ናይ ማዑዋቴ፥ ዒንሢ ማላ ማሊፆና ናይ ማዒፖቴ፤ ማላ ማሊፆና ጋዓንቴ ዒናዼ፥ ዶዲ ዓሲ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ዬይያ፦ « ‹ዓኪ ሙኡቺ ጌስታ ዓሶ ዛሎ''ና ሃሣ ሜሌ'' ዓሲ ሙኡቺና ሓያ ዴሮ''ም ታ ኬኤዛንዳኔ፤ ያዺ ማዔቴያ ዔያታ ታኣሲ'' ዋይዚንዱዋሴ› ጎዳ ጋዓኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ዬያሮ ዓኪ ሙኡቺና ጌስቲሢ ማላታ ማዓሢ ኪሪስቶሴ ጉሙርቁዋ ዓሶምኬ፥ ኪሪስቶሴ ጉሙርቃ ዓሶምቱዋሴ፤ ፆኦሲ ማሊሢ ኬኤዚሢ ጋዓንቴ ማላታ ማዓሢ ኪሪስቶሴ ጉሙርቃ ዓሶምኬ፥ ጉሙርቁዋ ዓሶምቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ዓካሪ ኪሪስቶሴ ጉሙርቃ ዓሳ ቡኪንቴ ዎዶ''ና ቢያሢ ዓኪ ሙኡቺና ጌስታንቴ ዬይ ባካ ዔርቱዋያ ሃሣ ኪሪስቶሴ ጉሙርቁዋ ዓሲ ሙኪ ዬያ ጌስታ ዓሶ ዛጋዖ፦ «ሃይ ዓሳ ዣኣሽካኔ!» ጋኣዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ጋዓንቴ ቢያሢ ፆኦሲ ማሊሢ ኬኤዛያ ማዔም ዬያ ባኮ ዔሩዋያ ሃሣ ኪሪስቶሴ ጉሙርቁዋ ዓሲ ሙኬቴ ኬኤዚንታ ባኮ ቢያ ዋይዛዖ ዬያና ጫታንዳኔ፤ ዻቢንቶ ፔኤሲ''ያ ዴንቂ ዔራንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ሃሣ ዒናኣ ዒዛኮ ዓኣሺንቴ ባካኣ ፔጋዻንዳኔ፤ ጊንሣ ሃሣ ዒ ባሊቶና ሳዓ ሎኦሚ፦ «ጎኔና ፆኦሲ ዒንሢ ባኣካ''ኬ!» ጌዒ ፆኦሲ ካኣሽካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ታ ዒሾንሦ! ታ ሚሾንሦ! ዓካሪ ታ ሂዚ ጋዓኔ፦ ፆኦሲ ካኣሽካኒ ዒንሢ ቡኪንታኣና ዒንሢዳፓ ፔቴ'' ፔቴ''ሢኮ ፆኦሲም ዓይናዺሢ ዒንጊሢ ዓኣኔ፥ ባጋሢኮ ዔርዚሢ ዒንጊሢ ዓኣኔ፥ ዓቴ''ሢኮ ሃሣ ዓኣሺንቴ ባኮ ፔጋሲ ዔርዚሢ ዒንጊሢ ዓኣኔ፥ ሜሌ''ሢኮ ጊንሣ ዓኪ ሙኡቺና ጌስታንዳ ዒንጊሢ ዓኣኔ፥ ባጋሢም ዬያ ዓኮ ሙኡጮና ጌስቲንቴሢ ቡላ''ንዳ ዒንጊሢ ዒንጊንቴያ ዓኣኔ። ዓካሪ ዬይ ቢያ ዒንጊፃ ኪሪስቶሴ ጉሙርቃ ዓሶ ዶዲሺ ማዣያ ማዓኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ዓኪ ሙኡቺና ጌስታይ ዓኣቶ ላምዖ፥ ሚርጌቴ ሓይሦ ማዒ ፔቴ'' ፔቴ'' ኬኤዞንጎ፤ ዔያታ ኬኤዛሢ ሜሌ'' ዓሲ ቡሎ''ንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ጌይንቴ ባኮ ቡሊ'' ኬኤዛ ዓሲ ባኣያታቴ ጋዓንቴ ዓኮ ሙኡጮና ጌስታ ዓሳ፥ ዓሶ ባኣካ'' ዚቲ ጌዒ፥ ጋርሲና ፔኤና ፆኦሲናም ኬኤዞንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ፆኦሲ ማሊፆ ኬኤዛዞንሢ ላምዖ ሃንጎ ሃይሦ ማዒ ኬኤዞንጎ፤ ሃንጎዋታ ጋዓንቴ ኬኤዚንቴ ባኮ ዋይዚ ኮሺ'' ዱማሲ ዔሮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ዒማ''ና ቡኪንቴ ቤዛ ዴዔ ዓሶይዳፓ ፔቴ'' ዓሲም ፆኦሲ ኬኤዜቶ ቤርታ ኬኤዛሢ ዚቲ ጎዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ፔቴ'' ፔቴ''ሢ ዔራንዳጉዲና ዶዳንዳጉዲ ዒንሢ ቢያሢ ፔቴ'' ፔቴ'' ዔቂ ዔቂ ፆኦሲ ኪኢቶ'' ኬኤዛኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ፆኦሲ ማሊፆ ኬኤዛ ዓሶኮ ዓያና'' ፆኦሲ ማሊፆ ኬኤዛ ዓሶም ዓዓይሢንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ጌስቶ ጌኤዞኮ ዣሊ ኑ ቤሲ ባይዛንዳጉዲ ፆኦሲ ኮዑዋሴ፤ ጋዓንቴ ቢያ ባካ ኮሹሞና ማዓንዳጉዲ ኮዓኔ። ፆኦሲ ዴሮ'' ባኣካ'' ቢያ ማዺንታሢጉዲ፦ ");
INSERT INTO mdybse_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ላኣላ ቡኪንቴ ዓሶ ባኣካ'' ዚቲ ጎዖንጎ፤ ዓይጎሮ ጌዔቴ ሙሴ ዔርዜ ዎጋ'' ዓይሣ ጎይፆ ዔያታ ዓዓይሢንታንዳፓ ዓቴ''ም ኬኤዛንዳጉዲ ዔያቶም ዓይሢንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ዔያታ ፔቴ'' ፔቴ'' ባኣዚ'' ዔራኒ ኮዔቴ ፔኤኮ ዓኒንሢ ማኣራ ዴንዳዖ ዖኦጮንጎ፤ ዓይጎሮ ጌዔቴ ዓሳ ቡኪንቴ ቤዛ ላኣላ ኬኤዛኒ ጊኢጉዋያ፥ ቦርሲሳያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ፆኦሲ ቃኣላ'' ኬስኬሢ ዒንሢ ኮራፓዳ? ሃሣ ፆኦሲ ቃኣላ'' ሄሌ''ሢያ ዒንሢም ሌሊዳ? ");
INSERT INTO mdybse_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","«ታኣኒ ፆኦሲ ማሊሢ ኬኤዛያኬ፤ ሃሣ ታኣም ዓያና ዒንጌ ዒንጊሢ ዓኣኔ» ጋዓ ዓሲ ዓኣቶ ሓይ ታ ዒንሢም ፃኣፓሢ ጎዳ ዓይሥሢ ማዔሢ ዔሮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ዬያ ዔራኒ ኮዑዋ ዓሲ ዓኣቶ ዒዚያ ዔርቶፓ። ");
INSERT INTO mdybse_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ዬያሮ ታ ዒሾንሦ! ታ ሚሾንሦ! ፆኦሲ ማሊሢ ኬኤዛኒ ሚርጌና ኮዑዋቴ፤ ዓኪ ሙኡቺና ጌስቲፆዋ ላኣጊፖቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ጋዓንቴ ቢያ ባካ ኮይሳ ጎይሢና ሃሣ ዳምቤና ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዒንሢም ኬኤዜ ኮዦ ሓይሶ ቃኣሎ'' ሃሣ ጊንሣ ታ ዒንሢም ጶቂሣኒ ኮዓኔ፤ ዬይ ኮዦ ሓይሶ ቃኣላ'' ዒንሢ ዋይዚ ዔኬሢና ዬያና ዶዲ ዒንሢ ዔቂ ዓኣሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ታኣኒ ዒንሢም ኬኤዜ ኮዦ ሃይሶ ቃኣሎ'' ዶዲሺ ዒንሢ ዓርቄቴ ዬያ ኮዦ ሃይሶ ቃኣሎ''ና ዒንሢ ዻቃንዳኔ፤ ያዺ ማዒባኣያታቴ ዒንሢኮ ዬይ ጉሙርቂፃ ጉሪኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ታኣኒ ዋይዚ ዔኬሢና ቢያፓ ቤርታ ኮይሳያ ማዔ ባኮ ዒንሢም ታ ዔኪ ሄሊ''ሴኔ፤ ዒንሢም ታ ሄሊ''ሴ ባካ፦ ጌኤዦ ማፃኣፖይዳ ፃኣፒንቴሢ ጎይፆ ኪሪስቶሴ ኑኡኮ ጎሞ ዛሎ''ሮ ሓይቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ዱኡቴኔ፤ ሃይሣሳ ኬሎ''ና ሃይባ''ፓ ዔቄኔ ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ዬካፓ ኬፓም፥ ሄሊ''ሳዖ ታጶ ላምዖ ዳኪንቴዞንሢም፥ ");
INSERT INTO mdybse_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ሃሣ ጊንሣ ዶንጎ ፄኤታፓ ዑሣ ማዓ ዒዛኮ ጊንፆ ሃንታዞንሢም ፔቴ''ና ጴዼኔ፤ ዬያቶይዳፓ ባሼሢ ሼምፔና ዓኣኔ፤ ፔቴ'' ፔቴ''ዞንሢ ጋዓንቴ ሃይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ዬካፓ ሃሣ ያይቆኦቤም፥ ሄሊ''ሳዖ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢም ቢያ ጴዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ቢያሢኮ ጋፒንፆይዳ ዻውቴ ኬሊ''ዳ ሾይንቴያጉዲ ማዔሢ፥ ታኣም ጴዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ታኣኒ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢዳፓ ቢያ ላኣፓ፥ ፆኦሲ ማዾ''ም ዳኪንቴሢ ጌይንቲ ዔኤሊ''ንታኒያ ታኣም ኮይሱዋያኬ፤ ዓይጎሮ ጌዔቴ ታኣኒ ኪሪስቶሴ ጉሙርቃ ዓሶ ዒፂ ዳውሴያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ጋዓንቴ ፆኦሲኮ ኮሹማፓ ዔቄያና ታ ሃሢ ዓኣ ጎይፆ ዓኣያ ማዔኔ፤ ፆኦሲ ፔ ኮሹሞና ታኣም ዒንጌ ባካ ጉሪ ዓቲባኣሴ፤ ዑሣ ዓኣዼ፥ ሃንጎዋቶይዳፓ ባሼ ዶዲ ታ ማዼኔ፤ ጋዓንቴ ዬያ ማዼሢ ፆኦሲ ታኣም ኮሹሞና ዒንጌ ዒንጊፆ ማዓንዳኣፓዓቴም ታናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ዓካሪ ታናንታ ዔያቶንታ ኑኡኒ ኬኤዛሢ ዬያኬ፤ ዒንሢያ ጉሙርቄሢ ዬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ኪሪስቶሴ ሓይባ''ፓ ዔቄሢ ኬኤዚንታያ ማዔቴ ዒንሢዳፓ ፔቴ'' ፔቴ'' ዓሳ፦ «ሓይቄ ዓሲ ዔቁዋሴ» ዎይቲ ጋዓይ? ");
INSERT INTO mdybse_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ሓይቢዳፓ ዓሲ ዔቁዋያ ማዔቴ ኪሪስቶሴያ ሓይባ''ፓ ዔቂባኣሴ ጌይሢዳ! ");
INSERT INTO mdybse_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ኪሪስቶሴ ሓይባ''ፓ ዔቂባኣያ ማዔቴ ኑ ኬኤዛ ባኮንታ ዒንሢ ጉሙርቃ ባካኣ ጉሪኬ ጌይሢዳ! ");
INSERT INTO mdybse_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ሃሣ «ፆኦሲ ኪሪስቶሴ ሓይባ''ፓ ዔቂሴኔ» ጌይ ኑ ኬኤዚፆና ሉኡዙሞና ኑ ፆኦሲም ማርካዻኔ ጌይሢዳ! ዓካሪ ሓይቄ ዓሳ ሓይባ''ፓ ዔቁዋያ ማዔቴ ፆኦሲ ኪሪስቶሴያ ሃይባ''ፓ ዔቂሲባኣሴ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ሓይቄ ዓሳ ሓይባ''ፓ ዔቁዋቴ፥ ኪሪስቶሴያ ሓይባ''ፓ ዔቂባኣያኬ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ኪሪስቶሴ ሓይባ''ፓ ዔቂባኣያ ማዔቴ ዒንሢኮ ጉሙርቂፃ ጉሪኬ ጌይሢኬ! ሃሢ ሄላ''ንዳኣና ዒንሢ ጎሜ ዎልቄኮ ዴማ''ኬ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ኪሪስቶሴ ጉሙርቄዖ ሓይቄ ዓሳኣ ማይ ጋፔኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ኪሪስቶሴይዳ ሃጊ ማዓንዳ ዎዛ ኑ ጌሣሢ ሃያ ዓጮ'' ናንጎሮ ሌሊ ማዔቴ ዓሲ ቢያይዳፓ ባሼ ዓሲኮ ዎልቃ ጌላያ፥ ኑ ላኣፓ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ጋዓንቴ ኪሪስቶሴ ሃይቄ ዓሳ ዔቃንዳሢ ዔርዛያ ማዒ፥ ጎኔ ሓይባ''ፓ ዔቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ሓይቢ ሙኬሢ ፔቴ'' ዓሢ ዛሎ''ና ማዔሢጉዲ ሃይቢፓ ዔቂሢ ሙኬሢያ ፔቴ'' ዓሲ ዛላናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ዓዳኣሜ ዛሎ''ና ዓሲ ቢያ ሃይቃሢጉዲ፥ ዓሲ ቢያ ኪሪስቶሴ ዛሎ''ና ሼምፔ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ጋዓንቴ ፔቴ'' ፔቴ''ሢም ዬይ ማዓንዳሢ ፔ ዎዴና ዎዴናኬ፤ ኪሪስቶሴ ሃይቢፓ ዔቂሢኮ ቶይዳሢ ማዔኔ፤ ጊንፃፓ ዒዚ ሙካኣና ዒዛሮ ማዔዞንሢያ ሃይባ''ፓ ዔቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ዬካፓ ዓካሪ ዒዚ ፑርቶ ዓያና'' ዎይሣ ዎይሢፆና ቢታንቶና ሃሣ ዎልቆዋ ቢያ ባይዚ፥ ካኣቱሞዋ ፆኦሲ ዓዶም ማሄ ዎዶ''ና ዓጮ''ኮ ጋፒንፆ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ዬያሮ ፆኦሲ ዒዛኮ ሞርኮ ቢያ ዒዛ ባሺሳንዳያ ሄላ''ንዳኣና ዒ ካኣታዻኒ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ጋፒንፆይዳ ባሺንታንዳ፥ ሞርካሢ ሓይቢኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ዓይጎሮ ጌዔቴ፦ «ፆኦሲ ቢያ ባኣዚ'' ዒ ባሺ ዎይሣንዳጉዲ ማሄኔ» ጌይንቲ ፃኣፒንቴሢሮኬ። ጋዓንቴ፦ «ቢያ ባኣዚ'' ዒ ባሺ፥ ዎይሣንዳጉዲ ማሄኔ» ጋዓዛ፥ ቢያ ባኣዚ'' ዒ ባሺ ዎይሣንዳጉዲ ዒዛ ዴማ'' ማሄ፥ ፆኦሲ፥ ዓዳሢያ ዒ ዎይሣንዳኔ ጌይሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ቢያ ባካ ኪሪስቶሴ ቢታንቶ ዴማ'' ማዔሢኮ ጊንፃ ፆኦሲ፥ ዓዳሢ ቢያ ባኮ ዎይሣንዳጉዲ ናዓሢ ፔኤሮ ቢያ ባኮ ዒዛ ቢታንቶ ዴማ'' ማሄ ፆኦሲ፥ ዓዳሢ ቢታንቶ ዴማ'' ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ዓካሪ ሓይቄ ዓሳ ዔቁዋያ ማዔቴ ዓሳ ሃይቄ ዓሶ ዛሎ'' ዋኣፆ ማስታሢ ዓይጎ ማኣዳ''ንዳይ? ሓይቄ ዓሳ ማሊ ዔቁዋያ ማዔቴ ዓሳ ዔያቶ ዛሎ'' ጌዒ ዓይጋ ማስታይ? ");
INSERT INTO mdybse_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ኑኡኒ ቢያ ዎዴ ሜታዺ ናንጋሢ ዓይጌንዴሮዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ታ ዒሾንሦ! ታ ሚሾንሦ! ቢያ ኬሊ'' ታ ሓይቄዖ ዓቲ ዓቲ ናንጋኔ፥ ዬይ ጎኔኬ፤ ዬያጉዲ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴና ዒንሢኮ ዓኣ ፔቱማኣ ጎኔኬ፤ ዬያ ታ ጫርቂ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ታኣኒ ዔፕሶኔይዳ ቦዖጉዴ ዓሶና ዖልቴሢ ዓሲ ማሊሢሮ ሌሊ ማዔቴ ዓይጎ ታ ዴንቃንዳይ? ሓይቄ ዓሳ ዔቁዋያ ማዔቴ፦ «ዚሮ ኑ ሓይቃንዳሢሮ ኑ ሙዖም፥ ዑሽኮም» ጋዓ ዓሶጉዲ ኑ ማዒባይ! ");
INSERT INTO mdybse_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ዻቢንቲፖቴ፤ «ፑርታ ላጌ ዓሲ ፑፑርቲሳኔ።» ");
INSERT INTO mdybse_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ፒዜ ማሊሢ ማሉዋቴ፤ ጎሜ ማዺፖቴ፤ ዒንሢ ባኣካ'' ፆኦሲ ዔሩዋ፥ ፔቴ'' ፔቴ'' ዓሲ ዓኣኔ፤ ዬያ ታ ጋዓሢ ቦርሶ ዒንሢም ማዖንጎ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","«ሓይቄ ዓሲ ዎይቲ ዔቃይ? ሓይባ''ፓ ዔያታ ዎዚጉዴ ዑሢና ዔቃይ?» ጌዒ ዖኦጫ ዓሲ ናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ዬይ ዓይጎ ዔኤዩሞዳይ! ኔኤኒ ዜርቃ ዜርፃ ሳዖይዳ ዎዒባኣቴ ባቃላኒ ዳንዳዑዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ኔኤኒ ዜርቃኣና ዛርጌታቴያ ሜሌ'' ሜይኮ ዓኣፖማ ኔ ሌሊ ዜርቃኣፓዓቴም ባቃሊ ኬስካ ባኮ ቢያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ፆኦሲ ጋዓንቴ ዜርፄሎም ኮዔሢጉዴያ ዑሢ ዒንጋኔ፤ ፔቴ'' ፔቴ'' ዜርፆም ቢያ ዱማ ዱማ ዑሢ ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ዓሽኪ ቢያ ዎሊ ማላያቱዋሴ፤ ዓሲ ዓሽኪ ዎሊ ማላያኬ፤ ቆልሞ ዓሽኪ፥ ካፒ ዓሽኪ፥ ሞሎ ዓሽኪ ዱማ ዱማኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ዬያጉዲ ጫሪንቺዳ ዓኣ ማዢንቲ ዓኣኔ፤ ሳዖይዳ ዓኣ ማዢንቲ ዓኣኔ፤ ጋዓንቴ ጫሪንጫ ዓኣ ማዢንቶኮ ቦንቻ ዎሊ ማላያኬ፤ ሳዖይዳ ዓኣ ማዢንቶኮ ቦንቻ ዱማኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","ዓቢ ማላ ፔቴ''ኬ፤ ዓጊኒ ማላ ዱማኬ፤ ሃሣ ዦኦጋሢኮዋ ማላሢ ዱማ ዱማኬ፤ ዎይቲ ጌዔቴ ፔቴ'' ዦኦጌኮ ማላሢ ሜሌ'' ዦኦጎይዳፓ ዱማታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ሓይቢፓ ዔቃ ዓሳ ያዺ ማዓንዳኔ፤ ሃይቂ ዎዓ ዑሢ ማኣዒ ዱኡቴሢ ዎዑዋያና ናንጊና ናንጋ ዑሢ ማኣዒ ዔቃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ሚዛጱዋያ ማዒ ዱኡቴሢ ሚዛጲ ዔቃንዳኔ፤ ላቤ''ያ ማዒ ዱኡቴሢ ዎልቄና ዓኣያ ማዒ ዔቃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ዓሲ ዑሢና ዓኣያ ማዒ ዱኡቴሢ ዓያና ዑሢ ዓኣያ ማዒ ዔቃንዳኔ። ዓሲ ዑሢ ዓኣያ ማዔቴ ዓያና ዑሢያ ዓኣኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ዬያሮ፦ «ቤርታሳ ዓሢ፥ ዓዳኣሜ ሼምፖና ዓኣ ዓሲ ማዔኔ» ጌይንቲ ፃኣፒንቴኔ፤ ጊንፃኣ ዓዳኣሜ፥ ኪሪስቶሴ ጋዓንቴ ሼምፖ ዒንጋ ዓያና ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ጋዓንቴ ቤርታ ሙኬሢ ዓሶ ዑፆና ዓኣሢ ማዓንዳኣፓዓቴም ዓያኖሲቱዋሴ፤ ዓያኖሲ ሙኬሢ ዓሶ ዑፆና ዓኣሢኮ ጊንፃፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ቤርታኣ ዓሢ፥ ዓዳኣሜ ዓጪዳፓ ማዢንቴ ሓያ ዓጮ'' ዓሲኬ፤ ላምዓሳ ዓሢ ሙኬሢ ጫሪንጫፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ሓያ ሳዖሮ ማዔዞንሢ ሳዓፓ ማዢንቴሢ ጉዲኬ፤ ጫሪንጮሮ ማዔ ዓሳ ጫሪንጮሲ ማላያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ኑኡኮ ዑፃ ሳዖ ዓሢሲ ማላሢጉዲ፥ ጫሪንጮ ዓሢሲያኣ ማላንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዒንሢም ኬኤዞም፤ ዓሲ ዓኣ ጎይፆ ዓኣዖ ፆኦሲ ካኣቱሞይዳ ጌላኒ ዳንዳዑዋሴ፤ ዬያጉዲ ባይቃ ዑፃ ባይቁዋ ዑፆ ዻካላዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ዓካሪ ፔቴ'' ዓኣሺንቴ ባኣዚ'' ታ ዒንሢም ኬኤዞም፤ ኑኡኒ ቢያሢ ሓይቃዓኬ፤ ጋዓንቴ ቢያሢ ኑ ላኣሚንታንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ኑኡኒ ላኣሚንታንዳሢ ጋፒንሢ ዛያ ዋርቂንታዛ ዓኣፒ ጊኢጳማጉዲ ዔርቲባኣንቴኬ፤ ዛያ ዋርቂንታንዳኔ፤ ዬማና ሓይቄ ዓሳ ባይቁዋያ፥ ናንጊና ናንጋያ ማዒ ዔቃንዳኔ፤ ኑኡኒ ጌይፃ፦ ሓይቂባኣዖ ዓኣ ዓሳ ላኣሚንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ዓይጎሮ ጌዔቴ ሃይ፥ ባይቃ ዑፃ ባይቁዋ ዑሢና ሓይቃ ዑፃ ሓይቁዋ ዑሢና ላኣሚንታንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ባይቃ ዑፃ ባይቁዋኣሢ፥ ሃይ፥ ሓይቃ ዑፃ ሓይቁዋኣሢ ማኣዓ ዎዶ''ና «ሓይቢ ባሺንቴኔ!» ጌይንቴሢ ኩማንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ዬያጉዲ፦ «ሓይቢዮ! ኔ ባሻሢ ዎካዳይ? ዓሶ ኔ ጫርጋ ዎልቃ ኔኤኮ ዓንካይዳ?» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ሓይቢኮ ዓሲ ጫርጎ ዎልቃ ጎሜኬ፤ ጎሜኮ ዎልቃ ሃሣ ዎጌኬ። ");
INSERT INTO mdybse_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ጋዓንቴ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴ ዛሎ''ና ባሺሢ ኑም ዒንጋ ፆኦዛሢም ጋላታ ሄሎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ዬያሮ ታ ዒንሢ ናሽካ፥ ታ ዒሾንሦ! ታ ሚሾንሦ! ዶዲ ዔቁዋቴ፤ ዓይጎ ባኣዚ''ናኣ ሴካ ሃንጋ ጌዒ ዓጊፂፖቴ፤ ጎዳ ማዾ'' ማዻኒ ዒንሢ ላቢ''ንታሢ ጉሪ ማዒባኣሢ ዔሪ፥ ቢያ ዎዴ ጎዳ ማዾ'' ዶዲ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","ኪሪስቶሴ ጉሙርቃ ዓሶም ኬሲ''ንታ ሚኢሾ ዛሎ''ኮ ጋላቲያ ዓጫ'' ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ዓሶም ታ ዓይሤ ጎይፆ፥ ዒንሢያ ያዺ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ታኣኒ ሙኬም ዒንሢ ሚኢሾ ኬሱ''ዋጉዲ፤ ቃልሾ ኬሎ'' ጋራ ቢያ ዉዴ ዉዴ ፔቴ'' ፔቴ''ሢ ሚኢሾ ዴንቃ ጎይፆ ሚኢሻፓ ፔኤኮ ዱማሲ ኬሲ'' ኬሲ'' ጌሦንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ታኣኒ ዒንሢ ኮይላ'' ሙካዖ ዒንሢ ዶኦራንዳ ዓሳ፥ ሚኢሾ ዬሩሳላሜ ዔኪ ዓኣዻንዳጉዲ ዋርቃታ ፃኣፒ ዔያቶና ዳካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ታ ዓኣዻንዳያ ኮይሳያ ማዔቴ ታኣና ዎላ'' ዔያታ ዓኣዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ሜቄዶኒያ ጊዴና ጌዒ ዓኣዻኒ ታ ማሌሢሮ ዒኢና ዓኣዻዖ ዒንሢ ኮይላ'' ታ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ታኣኒ ዴንዳ ቤዞ ቢያኮ ጎይፆም ማዓ ማኣዶ ዒንሢ ታኣም ማዻንዳጉዲ ጎዖንቴ ታ ዒንሢ ኮራ ዴዒ፥ ባርጎዋ ታ ዒኢካ ዓኣሣንዳያ ናንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ሓሢ ዴንዶ ዴንዳዖ ታ ዒንሢ ዻካ''ና ዛጋኒቱዋንቴ ጎዳ ጌዔቴ ዻካ'' ዖዶሲ ዎዴ ታ ዒንሢና ዴዓንዳኔ ጌዒ ሃጊ ማዓንዳ ዎዛ ታ ጌሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ጋዓንቴ ጴንፄቆስፄ ጌይንታ ቦንቾ ኬሎ'' ሄላ''ንዳኣና ዔፕሶኔይዳ ታ ዴዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ዓይጎሮ ጌዔቴ ሚርጌ ማዾኮ ካራ ታኣም ቡሊ''ንቴኔ፤ ታና ዒፂ ማካ ዓሳ ጋዓንቴ ሚርጌኬ። ");
INSERT INTO mdybse_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ፂሞቴዎሴ ዒንሢ ኮይላ'' ሙኬቴ ሂርጋ ባኣያ ዒንሢ ኮይላ'' ዒ ዴዓንዳጉዲ ዒዛ ማኣዱ''ዋቴ፤ ዓይጎሮ ጌዔቴ ዒዚ ታጉዲ ጎዳ ዬሱሴ ዓይሤ ማዾ'' ማዻያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ዬያሮ ዖኦኒያ ዒዛ ቦሁዋጉዲ፤ ዒዚ ዒሾንሢና ዎላ'' ታ ኮራ ማዒ ሙካንዳኔ ጌዒ ታ ካፓያታሢሮ፥ ታ ኮይላ'' ዒ ኮሺና ሙካንዳጉዲ ጎይፆኮ ዒዛም ኮይሳ ባኣዚ'' ማኣዲ''ሢና ዎዛሲ ዳኩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ኑ ዒሻሢ ዓጲሎሴ፥ ሜሌ'' ዒሾንሢና ዎላ'' ዒንሢ ኮይላ'' ዓኣዻንዳጉዲ ሚርጌና ታ ሺኢቄንቴ ዒዚ ሃሢ ዒንሢ ኮይላ'' ሙካኒ ዳንዳዒባኣሴ፤ ዒዛም ጊኢጌ ዎዴና ጋዓንቴ ዒንሢ ኮይላ'' ዒ ሙካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ጴጩዋቴ፤ ጉቤ ዒናፓ ኪሪስቶሴ ጉሙርቁዋቴ፤ ዶዱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ዒንሢ ማዻ ባኮ ቢያ ናሹሞና ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ታ ዒሾንሦ! ታ ሚሾንሦ! ዒስፂፓኖሴ ማኣሮ ዓሳ ዓካይያይዳ ቤርታሲ ኪሪስቶሴ ጉሙርቃ ዓሲ ማዔሢና ፆኦሲ ዓሶ ማኣዳ''ኒ ዒናፓ ናሽካያ ማዔሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ዬያቶጉዴ ዓሶና ዔያቶና ዎላ'' ማዺ ማዺ ላባዞ''ንሢም ቢያ ዒንሢ ዓይሢንታንዳጉዲ ታ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","ዒስፂፓኖሴንታ ፔርዶናፆሴንታ ዓካይቆሴንታ ታ ኮራ ሙኬሢሮ ታ ኮሺ'' ዎዛዼኔ፤ ዓይጎሮ ጌዔቴ ዒንሢ ታ ኮይላ'' ባኣያ ማዒፆና ታኣም ፓጬ ባኮ ዔያታ ኩንሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ዔያታ ታናንታ ዒንሢንታኮ ዒኖ ሃውሺሴኔ። ዬያሮ ዬኖጉዴ ዓሳ ጋዓ ባኮ ዋይዙዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ዒሲያ ዓጮ''ይዳ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ዓሳ ዒንሢ «ኮሺዳ?» ጋዓኔ፤ ሃሣ ዓቂላና ጲሪስቂላና ዬያጉዲ ዔያቶ ማኣራ ቡኪንታ፥ ኪሪስቶሴ ጉሙርቃ ዓሳ ቢያ ጎዳ ዬሱሴ ሱ'ንፆና ሚርጌና ዒንሢ «ኮሺዳ?» ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ሓይካ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ዓሳኣ ቢያ ዒንሢ «ኮሺዳ?» ጋዓኔ፤ ዎሊኮ ጌርሲንሢጉዲ፥ ናሹሞና ሄርቂ ሄርቂ ዎሊ ዔኤሉ''ዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ታኣኒ፥ ጳውሎሴ ሓያ ሳራሢፆ ኪኢቶ'' ዒንሢም ታ ኩቻ ፃኣፔያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ጎዳ ናሽኩዋ ዓሲ ዓኣቶ ጋዳንቂንቴያ ማዖንጎ፤ ኑ ጎዳሢዮ፥ ሙኬ! ");
INSERT INTO mdybse_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ጎዳ ዬሱሴኮ ኮሹማ ዒንሢና ዎላ'' ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ዬሱስ ኪሪስቶሴ ሱ'ንፆና ዒንሢ ቢያሢ ታ ናሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ፆኦሲ ማሊሢ ማዔም ዬሱስ ኪሪስቶሴኮ ዳኪንቲ ማዻያ ማዔ፥ ጳውሎሴና ኑ ዒሻሢ ፂሞቴዎሴናይዳፓ፦ ቆሮንቶሴይዳ ዓኣ ሺኢጲፆ ማኣሮ ዓሶና፤ ዬያጉዲ ዓካይያይዳ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ዴሮ''ም ቢያ። ");
INSERT INTO mdybse_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ኑ ዓዳሢ፥ ፆኦዛሢና ኑ ጎዳሢ ዬሱስ ኪሪስቶሴናኮ ሚጪንቲፆና ኮሹሞና ዒንሢም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ሚጪንታ ዓዶ ማዔያ፤ ሃሣ ቢያ ባኣዚ''ና ዶዲሻያ ማዔ ፆኦዛሢ፥ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴኮ ዓዶ፥ ፆኦዛሢም ጋላታ ሄሎ''ንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ኑኡኒ ፆኦሲዳፓ ዴንቃ ዶዱሞና ሜታሢዳ ዓኣ ዓሶ ቢያ ዶዲሻኒ ዳንዳዓንዳጉዲ፥ ፆኦሲ' ኑ ሜታዻ ዎዶ''ና ቢያ ኑና ዶዲሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ኪሪስቶሴ ሜታዼ ሜቶ'' ኑዋ ሚርጌና ሜታዼሢጉዲ ኪሪስቶሴ ዛሎ''ና ዶዱሞ ሚርጌና ኑ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ኑኡኒ ሜታዻ ዎዶ''ና ዒንሢ ዶዱሞና ዻቂንታና ዴንቃኔ። ኑኡኒ ዶዱሞ ዴንቃ ዎዶ''ና ሃሣ ዒንሢያ ኑኡኒ ሜታዼ ሜቶ''ጉዴ ሜቶ ጊቢ'' ዳንዳዒ ዶዱሞ ዴንቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ኑኡና ዎላ'' ዒንሢ ሜታዻሢጉዲ፥ ኑ ዶዱሞዋ ዒንሢ ዴንቃያ ማዔሢ ኑ ዔራሢሮ ዒንሢዳ ኑ ጌሣ፥ ሃጊ ማዓንዳ ዎዛ'' ዶዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ታ ዒሾንሦ! ታ ሚሾንሦ! ዒሲያይዳ ኑ ዓኣንቴ ኑና ሄሌ'' ሜታሢ ዒንሢ ዔራንዳጉዲ ኑ ኮዓኔ፤ ዬይ ኑና ሄሌ'' ሜታሢ ሚርጌና ኑም ዴኤፄያ ማዔሢሮ ኑ ሼምፔና ዓታንዳኔ ጌዒ ማሊባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ፔቶ ኑ ሓይቃንዳጉዲ ኑ ዑፃ ዎጊንቴያ ኑም ማሊ ጴዼኔ፤ ዬይ ቢያ ኑና ሄሌ''ሢ ሃይቄ ዓሶ ዔቂሳ፥ ፆኦሲ ኑ ጉሙርቃንዳጉዲ ማሃንዳፓዓቴም ኑና ኑ ጉሙርቁዋጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ዬያሮ ዒዚ ኑና ዬያ ሓይቦ''ይዳፓ ዻቂሼኔ፤ ሓጊያ ኑና ዻቂሻንዳኔ፤ ኑና ዻቂሻንዳኔ ጌዒ ሃጊ ማዓንዳ ዎዞ ኑ ጌሤሢ ዒዛይዳኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ዬይ፡ ዒንሢ ኑና ሺኢጲፆና ማኣዳ''ሢሮ፥ ሚርጌ ዓሶ ሺኢጲፆና ኑኡኒ ፆኦሲ ማኣዶ ዴንቄም ሚርጌሢ ፆኦሲ ጋላታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ሓያ ዓጮ''ይዳ ባሼ ዒንሢና ዎላ'' ኑ ፔቱሞና ሃሣ ፆኦሲዳፓ ማዔ፥ ፂሉ''ሞና ፒዙሞና ኑ ናንጌሢ ኑ ዒና'' ማርካዻኔ፤ ዬይ ዓሲ ዔራቶናቱዋንቴ ፆኦሲ ፔ ኮሹሞና ዒንጋ ዒንጊፆ ዎልቆናኬ፤ ዬያሮ ሄርሺንታ ኑኡኮ ዬያናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ናባቢ ዒንሢ ዔራኒ ዳንዳዑዋ ባኣዚ'' ኑ ዒንሢም ፃኣፓዓኬ፤ ቢያ ባኮ ዒንሢ ዔራንዳሢያ ታ ጉሙርቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ሓሢ ዒንሢ ኑ ዛሎ'' ጋፒሲ ዔሩዋ ባኮ ጊንፃፓ ጋፒሲ ዒንሢ ዔራንዳሢ ታ ጉሙርቃኔ፤ ጎዳ ዬሱሴ ኬሎ''ና ኑ ዒንሢና ዖቶርቃንዳሢጉዲ ዒንሢያ ኑኡና ዖቶርቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ዬይ ባካ ጎኔ ማዔሢ ታ ዔራሢሮ ላሚ ዒንሢም ማዓ ባኣዚ'' ዒንሢ ዴንቃዳጉዲ ቤርታዺ ዒንሢ ታ ዛጋኒ ማሌንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ዬያ ታ ዛጋኒ ማሌሢ' ሜቄዶኒያ ባንሢ ዓኣዻኣና ሃሣ ዒኢካፓ ማዒ ሙካኣናኣ ቢያኬ፤ ዬካፓ ዪሁዳ ታ ዓኣዻኣና ዒንሢ ታና ማኣዳ''ንዳኔ ጌዒ ታ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ጋዓንቴ ዬያ ታ ማላኣና ታኣኒ ማዻ ባኮ ዔሩዋዖ፥ ማሊፆና ሴካ ሃንጋ ጌዒ ሺራ ዓሲ ማላ? ሃሣ ዬያ ማሊፆና ፔቴ''ና «ሂዮዋ፥ ዔይዔያ» ጌዒ ጌዒ ዓሲ ማሊሢና ታ ማዻያ ማላ? ");
INSERT INTO mdybse_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ፆኦሲ ሉኡቁዋ ፆኦሲ ማዔሢሮ ኑኡኒያ ዒንሢም ኬኤዛሢ «ሂዮዋ፥ ዔይዔያ» ጌዒ ሴካ ሃንጋ ጌይሲ ሺርሻ ባኣዚ''ቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ዓይጎሮ ጌዔቴ ታናንታ ሲላሴንታ ፂሞቴዎሴንታ ፆኦሲኮ ናዓሢ፥ ዬሱስ ኪሪስቶሴ ዛሎ'' ኑ ዒንሢም ኬኤዛሢ «ሂዮ» ጋዓያና ሌሊ ማዓንዳኣፓዓቴም «ሂዮዋ፥ ዔይዔያ» ጋዓያናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ፆኦሲ ኑም ዒንጌ ሃጊ ማዓንዳ ዎዛ'' ቢያ «ሂዮ» ማዒ ኩማንዳሢ ዬሱስ ኪሪስቶሴናኬ። ዬያሮኬ ፆኦሲ ቦንቾም ኪሪስቶሴና «ዓኣሜን» ኑ ጋዓሢ። ");
INSERT INTO mdybse_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ኑና ማዔቴያ ዒንሢ ኪሪስቶሴና ኑ ዶዳንዳጉዲ ማሄሢ ፆኦሲኬ፤ ዒዛም ኑና ዱማሴሢያ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ዒዛም ኑ ማዔሢ ዔርዛ ማላታ ኑጊዳ ጌሤሢና ሃጊ ኑም ዒንጊንታንዳ ባኮኮ ዓያኖ ጌኤዦ ዓይሢ ባኣዚ'' ማሂ ኑም ዒንጌሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ታኣኒ ቆሮንቶሴ ማዒ ሙኪባኣሢ ዒንሢ ዖዪሳዓ ጌዒ፥ ሚጪንቲሢናኬ፤ ዬያኮ ፆኦሲ ታኣኮ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ዒንሢ ጉሙርቂሢና ዶዴያ ማዔሢሮ ዒንሢ ዎዛሳኒ ዒንሢና ዎላ'' ኑ ማዓንዳኣፓዓቴም ዒንሢ ጉሙርቃንዳ ባኮ ኑ ዒንሢም ኬኤዚ ዓይሣያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ዓካሪ ታ ዒንሢ ዖዪሳኒ ኮይባኣሢሮ ላሚ ታ ዒንሢ ኮይላ'' ሙካዓ ጌዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ታ ዒንሢ ዖዪሴያ ማዔቴያ ታ ዖዪሴ፥ ዒንሢዳፓ ዓታዛ ሜሌ'' ታና ዎዛሳንዳይ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ሓያኮ ቤርታ ታ ዒንሢም ፃኣፔሢ ዒንሢ ኮይላ'' ታ ሙካኣና ታና ዎዛሳኒ ኮይሳ ዓሳ ታና ዖዪሱዋጉዲ ጌዒኬ፤ ዓይጎሮ ጌዔቴ ታ ዎዛዼኔ ጌይፃ ዒንሢ ቢያሢ ዎዛዼኔ ጌይሢ ማዔሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ሚርጌ ዖዪ፥ ሜታዺ ማሊሢና ሃሣ ሚርጌና ዬኤኪ ዬኤኪ ታ ዒንሢም ፃኣፔሢ ሚርጌ ታ ዒንሢ ናሽካያ ማዔሢ ዒንሢ ዔራንዳጉዲ ጌይ ማዓንዳኣፓዓቴም ዒንሢ ዖዪሳኒ ጌይቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ዓይጎ ዓሲያ ማዖም ዓሲ ዖዪሴይ ዓኣቶ ዒዛኮ ዻቢንቶ ፑኡፒሲ ኬኤዚሢቱዋንቴ ዒ ዖዪሴሢ ታናቱዋንቴ ዒንሢዳፓ ሚርጌሢ ዒ ዖዪሴኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ዬያጉዴ ዓሢም ዒንሢዳፓ ሚርጌሢ ጌስቲ ዓጌ ባካ ዒዛም ጊዳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ዬያሮ ዬይ ዓሢ ሚርጌ ዖዪሢና ዎዛ ባይዙዋጉዲ፥ ዒዛም ዒንሢ ዓቶም ጋዓንዳያና ዶዲሻንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ሃሣ ዒንሢ ዒዛ ናሽካያ ማዒፆ ጊንሣ ጎናሲ ዔርዛንዳጉዲ ታ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ዬያ ኪኢቶ'' ታ ዒንሢም ፃኣፔሢ ዒንሢ ዛጋኒ ዒንጎ ሜታሢ ዎዲ'' ዒንሢ ዶዲ ዓኣሣቴያ ሃሣ ቢያ ዎዴ ታኣኒ ዓይሣ ባኮ ዒንሢ ኩንሣያ ማዔቴያ ዔራኒ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ዒንሢ ዻቢንቶ ዓቶም ጋዓ ዓሢም ታኣኒያ ዓቶም ጋዓንዳኔ፤ ታ ዒዛም ዓቶም ጋዓንዳ ዔርቴ ዻቢንቲ ዓኣቶ ታኣኒ ኪሪስቶሴ ቤርታ ዒዛም ዓቶም ጌዔሢ ዒንሢ ጋቴ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ዬያ ኑ ማዻሢ ፃላሄኮ ጌኖ ማሊፆ ኑ ዔራሢሮ ካራ ዒ ዴንቂ ጌሉዋጉዲ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ዬካፓ ኪሪስቶሴኮ ኮዦ ሃይሶ ኬኤዛኒ ፂሮዓዳ ታ ዓኣዼ ዎዶ''ና ጎዳ ዳልጊ ማዾኮ ካራ ታኣም ቡሌ''ንቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ዒኢካ ታኣኒ ታ ዒሻሢ፥ ቲቶ ዴንቂባኣሢሮ ዒና'' ታኣኮ ሃውሺባኣሴ። ዬያሮ ዒኢካ ዓኣ ኪሪስቶሴ ጉሙርቃ ዓሶ ሳራሢ ሜቄዶኒያ ታ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ጋዓንቴ ቢያ ዎዴ ኪሪስቶሴ ባሻ ባሺፆና ዔኪ ኑና ሃንታሢንታ ኪሪስቶሴኮ ዓኣ ዔራቶ ቢያ ቤዞ ሳውቃ ቲሺጉዲ ኑ ሄሊ''ሳንዳጉዲ ኑና ማሃ ፆኦዛሢም ጋላታ ሄሎ''ም። ");
INSERT INTO mdybse_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ኑኡኒ ዻቃ ዓሶም ማዔቴያ ባይቃ ዓሶም ኮሺ ሳውሞ ዓኣ ዑንጄጉዲ ኪሪስቶሴ ዛሎ''ና ፆኦሲም ዒንጊንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ባይቃ ዓሶም ዎዻያ፥ ሃይቢ ሃይቢ ጌይ ሳውቃያ፤ ዻቃዞንሢም ጋዓንቴ ኑኡኒ ናንጊ ዒንጋያ ሼምፖ ሳዊኬ፤ ዓካሪ ዬያ ማዾ'' ማዻኒ ዳንዳዓሢ ዖናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ኑኡኒ፡ ፆኦሲ ቃኣሎ'' ኮርሞ ባኣዚ''ሮ ዔኪ ሃንታ ሚርጌ ዓሶጉዲቱዋሴ፤ ጋዓንቴ ኑኡኒ ፆኦሲፓ ዳኪንቴ ዓሶጉዲ ኪሪስቶሴና ማዒ ፆኦሲ ቤርታ ፒዙሞና ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ኑ ኑና ጊንሣ ሄሄርሻኔ ጌይሢዳ? ሃሣ ፔቴ'' ፔቴ'' ዓሳ ማዻሢጉዲ ዒንሢምታቴያ ዒንሢዳፓ ፒዜ ማዻያ ማዒፆ ዔርዛ ዋርቃታ ኑም ኮይሳኔ ጌይሢዳ? ");
INSERT INTO mdybse_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ዓሲ ቢያ ዒንሢ ዛጋያና ናባባያ፥ ኑ ፒዜ ማዻያ ማዒፆ ዔርዛ፥ ኑ ዒና'' ፃኣፒንቲ ዓኣሢ ዒንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ዒንሢ፡ ኑ ማዼ ማዻ''ፓ ጴዼያ፥ ኪሪስቶሴኮ ፃኣፒንቴ ኪኢታ ማዔሢ ዔርቴያኬ፤ ዬይ ኪኢታ'' ፃኣፒንቴሢ ናንጊና ናንጋ ፆኦሲ ዓያኖና ማዓንዳኣፓዓቴም ዓሲ ፃኣፓ ባኣዚ''ናቱዋሴ፤ ሃሣ ዬይ ዓሲ ዒናይዳ ፃኣፒንቴያኬ፤ ዓርሲንቴ ሹቺዳ ፃኣፖናያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ዬያ ኑ ጋዓሢ ኪሪስቶሴ ዛሎ''ና ፆኦሲ ጉሙርቂኬ። ");
INSERT INTO mdybse_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ኑ ማዻ ማዾ'' ማዻንዳጉዲ ዎልቄ ኑም ዒንጋሢ ፆኦሲ ማዓንዳኣፓዓቴም ኑኡኒ ኑ ቶኦኪና ዓይጎዋ ማዻኒ ዎልቄ ኑኡኮ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ዓኮ ጫኣቁሞ ዎዶ'' ማዾ'' ኑ ማዻንዳጉዲ ማሄሢ ፆኦሲኬ፤ ዬይ ፃኣፒንቴ ዎጎናቱዋንቴ ዓያኖ ጌኤዦ ዛሎ''ና ማዔያኬ፤ ፃኣፒንቴ ዎጋ'' ዎዎዻኔ፤ ዓያኖ ጌኤዣ ጋዓንቴ ሼምፖ ዒንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ፃኣፒንቴ ዎጎ ቆኦቂ ኮሾ''ናሢ ዓርሲንቴ ሹጮይዳኬ፤ ዎጋ ዒንጊንቴ ዎዶ''ና ፆኦሲ ቦንቻ ፔጋዺ ጴዼኔ፤ ሙሴኮ ዓኣፖ ካሮ''ይዳ ፖዔ ፖዓ ባይቂ ባይቂ ዓኣዻያ ማዔቴያ ዒስራዔኤሌ ዓሳ ሙሴኮ ዓኣፖ ካሮ'' ኮሺ'' ዛጋኒ ዳንዳዒባኣሴ፤ ዓካሪ ዎዻ ዎጋ'' ዬያጉዴ ቦንቾና ጴዼያ ማዔቴ፥ ");
INSERT INTO mdybse_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ዓያኖ ጌኤዦ ዛሎ''ና ማዺንታ ማዻ'' ዎዚ ባሼ ቦንቾ ዓኣያ ማዓንዳይ! ");
INSERT INTO mdybse_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","ዓሶ «ዻቤኔ» ጌዒ ዎጋ ማዻ'' ዬያይዲ ቦንቺንታያ ማዔቴ ዓሶ ዻቂሻ ማዻ'' ዎዚ ባሼ ቦንቾ ዓኣያ ማዓንዳይ! ");
INSERT INTO mdybse_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ቤርታ ቦንቺንቴያ ማዔ ማዻ'' ሃሢ ባሼ ቦንቺንቴ ማዾ''ና ዎላ'' ቤኤዚ ዛጎዛ ቦንቾ ባኣ ባኣዚ'' ማዒ ጴዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ዬይ ባይቃያ ማዔ ባካ ዬያጉዴ ቦንቾና ዓኣያ ማዔቴ ናንጊና ባይቁዋዖ ናንጋ ባኮኮ ባሼ ቦንቾ ዓኣኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ዬያጉዴ ሃጊ ማዓንዳ ዎዛ ኑኡኮ ዓኣሢሮ ዑሣ ዓኣዼ ጫርቂ ኑ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ሙሴኮ ዓኣፖ ካራ'' ፖዓሢ ሓሻኣና ዒስራዔኤሌ ዓሳ ዒዛኮ ዓኣፖ ካሮ'' ዴንቁዋጉዲ ዓኣፖ ካሮ'' ዒ ካንቃኔ፤ ኑኡኒ ጋዓንቴ ዒዛ ጉዲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ዒስራዔኤሌ ዓሶኮ ዒና'' ዔኩዋያ ማዒ ጎኔና ዶጪ ዓኣኔ፤ ሃኖ'' ሄላ''ንዳኣና ሚናኣ ጫኣቃሢ ማፃኣፖ ዔያታ ናባባኣና ዒና'' ዔያቶኮ ዬኖ ካንቆ ዓፒሌሎና ካንቂንታያኬ፤ ጋዓንቴ ዬና'' ካንቃ ባኬላ ባይቃንዳሢ ኪሪስቶሴ ዛሎ''ና ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ሃኖ'' ሄላ''ንዳኣና ሙሴ ዔርዜ ዎጎ ማፃኣፖ ዔያታ ናባባኣና ዒና'' ዔያቶኮ ዬኖ ባኬሎና ካንቂንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ጋዓንቴ ዬና ባኬላ ሺኢካኒ ዳንዳዓኔ፤ ጌኤዦ ማፃኣፖይዳ፦ «ሙሴ ጎዳ ባንሢ ማዓዛ ካንቃ ባኬላ ሺኢኬኔ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ዬያሮ ጎዳ ጌይንቴሢ ዓያኖኬ፤ ጎዳኮ ዓያና'' ዓኣ ቤስካ ዓይሉሞ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ዬያሮ ኑ ቢያሢ ጎዳኮ ቦንቾ ካንቂንቲባኣ ዓኣፒ ካራና ፖዒ፥ ፔጋሲ ዻዋኔ፤ ዓያና ማዔ ጎዳይዳፓ ጴዻ ሃይ ቦንቻ ቦንቾይዳ ቦንቾ ኑም ቃሲ'' ቃሲ'' ዓዳ'' ጎዳ ኑ ማላንዳጉዲ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ፆኦሲ ፔ ኮሹሞና ሃያ ማዾ'' ኑም ዒንጌሢሮ ሓጋኣ ዎዛባኣ ዓሲ ኑ ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ዔርቲባኣ ባኮና ቦርሳያ ማዔ ባኮ ኑ ሃሼ''ኔ፤ ጌሺሢ ማዾዋ ኑ ማዹዋሴ፤ ፆኦሲኮ ቃኣሎ'' ሉኡዙሞ ባኣዚ''ና ዎላ'' ኑ ሲኢሩዋሴ፤ ጋዓንቴ ጎኑሞ ፔጋሲ፥ ፔጋ ኬኤዛኔ፤ ማሊፆ ኑኡሲያ ዓሲም ቢያ ፔጋሲ ፔጋሲ ፆኦሲ ቤርታ ኑ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ኑ ኬኤዛ ኮዦ ሃይሳ ዔርቱዋያ ማዔቴያ ዔርቱዋያ ማዓሢ ባይቃ ዓሶምኬ። ");
INSERT INTO mdybse_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ዔያታ ኑ ኬኤዛ ባኮ ጉሙርቁዋኣሢ ሃያ ዓጮ''ኮ ፆኦሲ ማዔ፥ ፃላሄ ዒኖ'' ዔያቶኮ ባይዜሢሮኬ፤ ፆኦሲ ማሎና ጴዼ፥ ኪሪስቶሴ ቦንቾ ዛሎ'' ኬኤዚንቴ ኮዦ ሃይሶይዳፓ ጴዻ ፖዖ ዴንቁዋጉዲ ዔያቶ ማሄሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ኑኡኒ ኬኤዛሢ' ዬሱስ ኪሪስቶሴ ጎዳ ማዔሢና ኑኡኒያ ኑ ቶኦኪና ዬሱሴ ዛሎ''ና ዒንሢም ማዻያ ማዒፆ ማዓንዳኣፓዓቴም ኑ ዛላ ኑ ኬኤዙዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","ዓይጎሮ ጌዔቴ፦ «ፖዓ ዹሞይዳ ፖዖንጎ» ጌዔ ፆኦዛሢ ኪሪስቶሴ ማሎና ፖዓ፥ ፆኦሲ ቦንቾ ዔርዛ ፖዒ ኑም ዒንጊንታዳጉዲ ፖዖ ኑኡኮ ዒኖይዳ ፖዒሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ጋዓንቴ ሃይ ዼኤፖ ዎልቃ ፆኦሲዳፓ ማዓንዳኣፓዓቴም ኑኡሮ ማዒባኣሢ ዔርታንዳጉዲ ሃያ ቦንቾ ባኮ ዖቲ ማዒ ኑ ዓርቂ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ቢያ ዛሎ''ና ሜታ ኑና ሄላ''ኔ፤ ጋዓንቴ ኑ ባሺንቱዋሴ፤ ሚርጌና ዔርቲ ዒፃ ባኣዚ'' ኑ ጊዳ'' ሙካኔ፤ ማዔቴያ ኑ ሃጊ ማዓንዳ ዎዛ ባይዙዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ኑና ዒፃ ዓሳ ዳውሳኔ፤ ጋዓንቴ ላጌ ኑ ባይዚ ቤቂባኣሴ፤ ጳዺንቲ ኑ ሎኦማኔ፤ ጋዓንቴ ኑ ባይቁዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","ዬሱሴኮ ሃይቦ'' ባሼ ሼምፓሢ ኑ ዑፃ ፔጋዺ ዔርታንዳጉዲ ቢያ ዎዴ ዬሱሴኮ ሃይቦ'' ኑ ዑፃ ኑ ኬዲ ሃንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","ዒዛኮ ሃይቦ'' ባሼ፥ ሼምፓሢ ኑኡኮ ሃይቃ ዑፆይዳ ፔጋዺ ዔርታንዳጉዲ ጌዒ ኑኡኒ ሃሢ ሼምፖና ዓኣ ዓሳ ቢያ ኬሊ'' ዬሱሴ ዛሎ''ሮ ሃይቄዖ ዓቲ ዓቲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ዓካሪ ኑኡኒ ሓይቄዖ ዓቲ ዓቲ ናንጋኔ፤ ዒንሢ ጋዓንቴ ሼምፖና ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ጌኤዦ ማፃኣፖይዳ፦ «ታ ጉሙርቃሢሮ ኬኤዜኔ» ጌይንቲ ፃኣፒንቴሢጉዲ፥ ኑኡኒያ ዬኖ ዓያኖና ጉሙርቃኔ፤ ዬያሮ ኑ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ጎዳ ዬሱሴ ሃይባ''ፓ ዔቂሴ ፆኦዛሢ ኑናኣ ዬሱሴና ዎላ'' ዔቂሲ፥ ዒንሢና ዎላ'' ፔ ቤርቶ ሺኢሻንዳሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ዬይ ቢያ ዒንሢ ማኣዳ''ንዳጉዲ ማዔኔ፤ ፆኦሲኮ ኮሹሞ ዒንጊፃ ሚርጌ ዓሶም ዒንጊንቲ ዒንጊንቲ ዓኣሢ ዬይ ዓሳ ፆኦሲ ሚርጌና ጋላታንዳጉዲና ቦንቻንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ዬያሮ ኑ ሃጋኣ ዎዛባኣ ዓሲ ማዓዓኬ፤ ዎዚ ኑኡኮ ዙላ'' ጴዻ፥ ዑፃ ባይቃያ ማዔቴያ ጋሮ ዑፃ ኑኡኮ ቢያ ኬሊ'' ዓካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ዎይቲ ጌዔቴ ሃይ ሼሌዔ፤ ሃሣ ዻካ'' ዎዴሮ ማዔ ሜታሢ ቤቃያባኣ፥ ናንጊና ናንጋ ቦንቾ ኑም ጴዺሻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ኑኡኒ ዛጊ ዓኣሢ፦ ጴዻ ባኮቱዋንቴ ጴዹዋ ባኮኬ፤ ዓይጎሮ ጌዔቴ ጴዻ ባካ ሃሣኣ ባኣዚ'' ሌሊኬ፤ ጴዹዋ ባካ ጋዓንቴ ናንጊና ባይቁዋ ባኣዚ'' ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ሓይ ዉልሻ ማላ፥ ዻካ'' ዎዴሮ ማዔ ዑፃ ኑኡኮ ባይቄቴያ ዓሲ ማዢባኣያ፥ ፆኦሲ ማዤ ናንጊና ናንጎ ማኣሪ ኑኡኮ ጫሪንጮይዳ ዓኣሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ሃይካ ሳዖይዳ ኑ ዓኣዖ ጫሪንጮይዳ ዓኣ ማኣሮ ኑኡኮ ጌላኒ ኮዒ ሚርጌና ማሊ ኑ ሜታዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ዬያ ማኣሮይዳ ኑ ጌሌ ዎዶ''ና ማኣሪባኣያ ካሎ'' ኑ ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ሓያ ዉልሾጉዴ ማኣሮይዳ ኑ ናንጋ ናንጋ ዴኤፄም፥ ኑ ሚርጌና ማሊ ሜታዻኔ፤ ኑ ዬያይዲ ማሊ ሜታዻሢያ ኑኡኮ ሃይቃ ዑፃ ናንጎና ዔኤዺንቶም ጊዳ'' ቃቃሳኒ ማዓንዳፓዓቴም ኑፓ ሺኢሻኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ያዺ ማዓንዳጉዲ ኑና ጊኢጊሼሢ ፆኦሲኬ፤ ኑም ሃጊ ማዓንዳ ባኮኮ ቢያ ዓይሢ ባኣዚ'' ማዓንዳጉዲ ፔኤኮ ዓያኖዋ ኑም ዒንጌሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ኑኡኮ ሳዖይዳ ናንጎ ማኣሮ ማዔ ዑፆና ኑ ዓኣ ዎዶ''ማና ጎዳይዳፓ ኑ ሃኪ ናንጋሢ ዔራያ ማዔቴያ ቢያ ዎዴ ዒጊጩዋዖ ጎዳ ጉሙርቂ ኑ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ኑኡኒ ናንጋሢ ጎዳ ጉሙርቂሢና ማዓንዳኣፓዓቴም ዛጊሢናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ሓያ ኑኡኮ ማኣሮ ማዔ ዑፆይዳፓ ዱማዺ ጎዳና ናንጋኒ ኑኡኒ ኮዓኔ፤ ጫርቂኬ ኑ ጌስታሢ። ");
INSERT INTO mdybse_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ዬያሮ ሓያ ኑኡኮ ዑፆና ኑ ዓኣቴያ ዱማዺ ኑ ናንጌቴያ ኑኡኮ ማሊፃ ጎዳ ዎዛሲሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ፔቴ'' ፔቴ''ሢ ፔ ናንጌ ዎዶ''ና ማዼማ ጉዴያ፥ ኮሺ ማዔቴያ ፑርታ ማዼ ማዾ'' ዛሎ'' ዒንጊንታ ባኮ ዔካኒ ኪሪስቶሴኮ ዎጎ ዎጎ ቤዞ ሺኢኪ ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ፆኦሲ ዒጊጪሢ ዎዚ ጌይሢታቴያ ኑ ዔራሢሮ ዓሳ ኑ ጋዓ ባኮ ጎኔኬ ጌይ ዔካንዳጉዲ ኑ ማዻኔ፤ ኑኡኒ ዖናንሢታቴያ ፆኦሲ ኑና ዔራኔ፤ ዒንሢያ ሃሣ ዒንሢ ዒኖና ኑኡኒ ዖናንሢታቴያ ዔራኔ ጌይ ታ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ጋርሲ ዒናይዳ ዓኣ ባኣዚ''ቱዋንቴ፥ ዙላ'' ዓሲም ጴዻ ባኣዚ''ና ሄርሺንታ ዓሶም ዒንሢ ማሂ ኬኤዛኒ ኑኡና ዒንሢ ሄርሺንታንዳጉዲ ማዓንዳኣፓዓቴም ላሚ ጊንሣ ኑኡኮ ዖኑሞ ዒንሢም ኑ ኬኤዛኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ኑ ዣኣሽካ ዓሲ ማዔቴያ ፆኦሲሮ ጌይኬ፤ ሃሣ ዒናና ዓኣ ዓሲ ኑ ማዔቴ ዒንሢሮ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ኪሪስቶሴኮ ናሹማ ኑና ዬያ ማዺሻኔ፤ ፔቴ''ሢ ቢያሢ ዛሎ'' ሃይቄሢሮ ቢያሢ ዒዛና ዎላ'' ሃይቄያ ማዔሢ ኑ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ሼምፔና ዓኣዞንሢ ቢያ ዔያቶ ጋይቴ ሓይቂ ሓይባ''ፓ ዔቄሢም ናንጋንዳኣፓዓቴም ሃይካፓ ሴካ ፔኤም ጌዒ ናንጉዋጉዲ ኪሪስቶሴ ቢያሢም ሓይቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ዬያሮ ሃይፓ ሴካ ዖናኣ ኑ ዓሲ ዛጋ ዓኣፒና ዛጋዓኬ፤ ሃያኮ ቤርታ ኪሪስቶሴ ኑ ዛጌሢ ዓሲ ዛጋ ዓኣፒና ማዔቴያ ሃካፓ ሴካ ጋዓንቴ ኑ ዛጋንዳሢ ዬያ ጎይፆቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ዬያሮ ዖኦኒያ ኪሪስቶሴና ዎላ'' ፔቴ'' ማዔቴ ዓኪ ማዢንቲኬ፤ ቤርታኣ ባካ ዓኣዼኔ፤ ዬያ ቤዞ ዓኪ ባኣዚ'' ዓርቄኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ዬይ ቢያ ያዺ ማዔሢ ኑና ፔኤና ዎላ'' ኪሪስቶሴ ዛሎ''ና ጊኢጊሼሢና፥ ጊኢጊሺፆ ማዾ''ዋ ኑም ዒንጌ ፆኦዛሢ ዛሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ዬይያ ፆኦሲ' ኪሪስቶሴ ዛሎ''ና ዓሶ ቢያ ፔኤና ዎላ'' ጊኢጊሼኔ ጌይሢኬ፤ ሃሣ ዻቢንቶዋ ዔያቶኮ ዓርቂባኣሴ፤ ኑኡማኣ ዬያ ዓሶ ጊኢጊሻ ቃኣሎ'' ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ፆኦሲ' ዓሶ ፔ ባንሢ ኑ ዛሎ''ና ዔኤላ''ሢሮ ኑኡኒ ኪሪስቶሴ ዛሎ'' ማዒ ጌስታያኬ፤ ዬያሮ፦ «ፆኦሲና ዎላ'' ጊኢጉዋቴ» ጌዒ ኪሪስቶሴ ሱ'ንፆና ኑ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ኑኡኒ ኪሪስቶሴና ዎላ'' ፔቴ'' ማዒ ፆኦሲ ፂሉ''ሞ ዴንቃንዳጉዲ ጎሜባኣ ኪሪስቶሴ ኑኡኮ ጎሞ ኬዳንዳጉዲ ፆኦሲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ፆኦሲና ዎላ'' ኑኡኒ ማዻያ ማዔያታሢሮ፦ «ዒንሢ ፆኦሲዳፓ ዔኬ፥ ዒ ፔ ኮሹሞና ዒንጌ ዒንጊፆ ጉሪ ማሂፖቴ» ጌይ ኑ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ፆኦሲ ኬኤዛዖ፦ «ታ ኔኤም ኮሺ ባኣዚ'' ማዻንዳኔ ጌዔ ኬላ'' ሄሌ'' ዎዶ''ማና ታ ኔኤም ዋይዜኔ፤ ታ ኔና ዻቂሻንዳኔ ጌዔ ኬላ'' ሄሌ'' ዎዶ''ማና ታ ኔና ማኣዴ''ኔ» ጋዓሢሮ «ሓይሾ ዓካሪ ጌይንቴ ዎዳ'' ሃያኬ፤ ዻቂንቶ ኬላ''ኣ ሃኖ''ኬ።» ");
INSERT INTO mdybse_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ኑ ማዻ ማዻ'' ቦሂንቱዋጉዲ ዓይጎ ባኣዚ''ና ማዔቴያ ዖኦማኣ ዹቆ ኑ ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ጋዓንቴ ኑና ሄላ'' ሜቶና ሄላ'' ባኮ ቢያ፤ ሃሣ ዋኣዪሳ ሜቶ ቢያ ጊቢ'' ዳንዳዒሢና ፆኦሲም ማዻ ዓሲ ማዒፆ ቢያ ዛሎ''ና ኑ ፔጋሲ ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ፆኦሲም ማዻ ዓሲ ማዒፆ ኑ ዔርዜሢ፦ ዢራፓና ጳዺንቲ፥ ቱኡቲ፥ ዓሲና ዣሊ፥ ሚርጌ ማዺ ላቢ''ንቲ፥ ጊንዖ ዓቲሢና ናይዺንቲሢናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ዬያጉዲ ሃሣ ጌኤሹሞና፥ ዔራቶና፥ ጊቢ'' ዳንዳዒሢና፥ ኮሹሞና፥ ዓያና ጌኤሺ ዻዋ ጎይፆ ሃንቲሢና፥ ጎኔ ናሹሞና፥ ");
INSERT INTO mdybse_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ጎኔ ባኮ ኬኤዚሢና ፆኦሲ ዎልቄና ማዺፆናኬ፤ ዔኤቢ ባሻኒ ማዔቴያ ኑ ጊዳ'' ሙካ ባኮ ላኣጋኒ ዳንዳዒሳ ዓንጋሞ ኑኡኮ ማዓሢ ፂሉ''ሞኬ። ");
INSERT INTO mdybse_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ቦንቺንቲሢና ዻውሲንቲሢና ጋላቲንቲሢና ጫሽኪንቲሢና ኑ ናንጌኔ፤ ሃሣ ኑ ጎኔ ኬኤዛ ዓሲታዖ ሉኡዚ ዓሲ ጌይንቴኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ኑ ዔርቴ ዓሲታዖ ዔርቲባኣ ዓሲ ማዔኔ፤ ሃይቄኔ ኑ ጌይንቴያታዖ ሃሢ ሼምፔና ኑ ዓኣኔ፤ ኑኡኒ ጳርቂንቴቴያ ኑና ዎዺቦኦሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ኑና ዖዪሶናያ ማዔቴያ ቢያ ዎዴ ኑ ዎዎዛዻያኬ፤ ኑ ማንቆ ዓሲታዖ ሚርጌሢ ኑ ዖርጎቻኔ፤ ዓይጎ ባኣዚ''ያ ባኣ ዓሲታዖ ቢያ ባካ ኑኡሮ ማዔያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ዒንሢ ቆሮንቶሴይዳ ናንጋ ዓሳ! ታ ዒንሢም ፔጌና ኬኤዜኔ፤ ዒኖ'' ኑኡኮ ኑ ዒንሢም ዻዊ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ዒንሢ ዒንሢኮ ዒኖ'' ኑም ዻዊ ሃሺ''ባኣፓዓቴም ኑ ዒኖ'' ዒንሢም ዻዊ ኑ ሃሼ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ታኣኮ ዒንሢ ናኣቶ'' ማዔሢሮ ታ ዒንሢም ኬኤዛሢ፦ «ዒንሢያ ዒማይዲ፥ ሚርጌና ዒኖ'' ዒንሢኮ ኑም ዻዊ ሃሻ''ንዳጉዲ» ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ኪሪስቶሴ ጉሙርቁዋ ዓሶና ዎላ'' ኮይሱዋ ጎይሢና ፔቴ'' ማዒፖቴ፤ ፂሉ''ሞና ጎሜና ፔቴ'' ማዓኒ ዳንዳዓ? ፖዒና ዹሚና ዎላ'' ዎዲ'' ናንጋኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ኪሪስቶሴና ዲያብሎሴና ዎይቲ ዎላ'' ጊኢጋኒ ዳንዳዓይ? ኪሪስቶሴ ጉሙርቃ ዓሲና ጉሙርቁዋ ዓሲና ዎይቲ ፔቴ'' ማዓኒ ዳንዳዓይ? ");
INSERT INTO mdybse_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ፆኦሲኮ ጌኤዦ ማኣሮና ሜሌ'' ፆኦዞናኮ ዓይጎ ፔቱሞ ዓኣይ? ፆኦሲ፦ «ታ ናንጋ ማኣሮ፥ ታ ዴሮ'' ባኣካ'' ታ ማሃንዳኔ፤ ዔያቶና ዎላ'' ታ ናንጋንዳኔ፤ ታ ዔያቶኮ ፆኦዛሢ ማዓንዳኔ፤ ዔያታኣ ታ ዴሬ ማዓንዳኔ» ጌዔሢጉዲ ኑኡኒ ባይቁዋ ፆኦዛሢም ዱማዼ ማኣሪኬ። ");
INSERT INTO mdybse_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ሓሣ ፆኦሲ ኬኤዛዖ፦ «ዔያቶ ባኣካ''ፓ ዱማዺ ኬስኩዋቴ፥ ዒኢቴ ባኮ ካኣሚፖቴ፤ ታኣኒያ ዒንሢ ታ ዓሲ ማሃንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ታ ዒንሢኮ ዓዶ ማዓንዳኔ፤ ዒንሢ ታኣኮ ዓቲንቆና ዉዱሮ ናኣቶ''ና ማዓንዳኔ፤ ጋዓኔ፤ ቢያ ባኣዚ'' ዳንዳዓ ጎዳሢ።» ");
INSERT INTO mdybse_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ዓካሪ ታ ዒጊኖንሢዮቴ! ሓይ ቢያ ሃጊ ማዓንዳ ዎዛ'' ዒንጊንቴሢ፡ ኑም ማዔሢሮ ዓሲኮ ዑሢና ዓሲኮ ጋሮ ዓያኖና ዒኢሳ፥ ዓይጎ ባኣዚ''ዳፓኣ ኑ ቶኦኮ'' ኑ ጌኤሾም፤ ፆኦሲ ዒጊጪሢና ዒዛም ኑኡኮ ዱማዺፆ ዔርቴያ ኑ ማሆም። ");
INSERT INTO mdybse_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ዒኖ'' ዒንሢኮ ኑም ዻዊ ሃሹ''ዋቴ፤ ዖኦማኣ ኑ ፑርታ ማዺባኣሴ፥ ዖናኣ ኑ ዻቢሲባኣሴ፤ ሃሣ ዖናኣ ኑ ጌሺ ዎልቆ ሙይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ዬያ ታ ጋዓሢ፦ «ዒንሢ ዻቤኔ» ጋዓኒ ጌይቱዋሴ፤ ዓይጎሮ ጌዔቴ ሃያኮ ቤርታ ኑ ዒንሢም ጌዔሢጉዲ ዒንሢ ኑ ዒና''ፓ ባይቂባኣሴ፤ ዬያሮ ኑ ናንጌቴያ ሓይቄቴያ ቢያ ዎዴ ዒንሢና ዎላ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ዒንሢ ታ ኮሺ'' ጉሙርቃኔ፤ ሃሣ ዒንሢና ታ ኮሺ'' ሄርሺንታኔ፤ ኑ ሜታዻኣና ቢያ ዼኤፒ ዶዱሞ ታ ዴንቃኔ፤ ታ ዎዛዻ ዎዞኮዋ ጋፒንሢ ባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ሜቄዶኒያ ኑ ሄሌ''ያናታዖ ሚርጌ ዛላና ሜታ ኑና ሄሌ''ያፓዓቴም ሃውሺሢ ኑኡኮ ባኣያ ማዔኔ፤ ዙላ''፥ ሜሌ'' ዓሳፓ ሙካ ባኮና ሃሣ ኑ ዒና'' ኑና ዒጊቻ ባኮና ኑ ሚርጌ ሜታዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ጋዓንቴ ዖያ ዓሶ ዶዲሻ፥ ፆኦዛሢ ቲቶ ኑ ኮራ ዳኪፆና ኑና ዶዲሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ኑ ዶዴሢ' ዒዛኮ ኑ ኮራ ሙኪፆና ሌሊ ማዒባኣንቴ ዒንሢ ዒዛ ዶዲሼያ ማዔሢያ ኑ ዋይዜሢሮኬ። ሃሣ ዒንሢ ታና ጶቂሣሢያ፥ ታ ዛሎ''ሮ ዒንሢ ዖያያ፤ ጊንሣ ሃሣ ታና ሚጪንቲ ዒንሢ ማላ ማሊፆ ኑም ዒ ኬኤዛዛ ሚርጌና ታ ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ሃያኮ ቤርታ ታ ዒንሢም ፃኣፔ ኪኢታ'' ዒንሢ ዖይሴያ ማዔቴያ ዬያ ፃኣፒፆና «ዻቤኔ» ታና ታ ጎዑዋሴ፤ ታ ታና «ዻቤኔ» ጌዔቴያ ዬይ ታ ፃኣፔ ኪኢታ'' ዻካ'' ዎዴሮ ሌሊ ዒንሢ ዖዪሴሢ ታ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ሃሢ ታ ሚርጌና ዎዛዻኔ፤ ታ ዎዛዻሢያ ዒንሢ ዖዪሴሢሮቱዋንቴ ዒንሢኮ ዖዪፃ ዒንሢኮ ዻቢንቶ ዒንሢም ዔርዜም፥ ዒንሢ ዬያፓ ማዔያታሢሮኬ፤ ዓካሪ ዒንሢኮ ዖዪፃ ፆኦሲ ማሊሢጉዲ ማዔሢሮ ዓይጎዋ ኑ ዒንሢም ፑርቲሲባኣሴ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ፆኦሲ ማሊሢጉዴያ ማዔ ዖዪሢ፦ ዻቂንታ ባንሢ ዔኪ ሙካ፥ ጎሜ ቡኡፂም ጊኢጊሻሢሮ «ዓይጋ ዬይ ማዔይ» ጌይሳያቱዋሴ። ሃያ ዓጮ'' ዛሎ''ና ሙካ ዖዪሢ ጋዓንቴ ሓይቢ ዔኪ ሙካኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ዬይ ፆኦሲ ማሊፆ ጉዴያ ማዔ ዖዪፃ፡ ዶዲ ዒንሢ ማላንዳጉዲና ዻቢንቲባኣያ፥ ጌኤሺ ዒንሢ ማዔሢ ዔርዛንዳጉዲ ዒንሢ ማሄኔ፤ ዬያጉዲ ሃሣ ጎሜ ማዔ ባኣዚ'' ዒንሢ ዒፃያ ማዓንዳጉዲ፥ ታ ዞሮ'' ዒንሢ ዒጊጪ ዔካንዳጉዲ፥ ታና ዒንሢ ጶቂሣንዳጉዲ፥ ዓያና ዓኣ ማሊሢና ፒዜ ዒንሢ ዎጋንዳጉዲና ዻቢንቴሢያ ዒንሢ ጎራ''ንዳጉዲ ዒንሢ ማሄኔ። ዬያ ባኮ ቢያና ዒንሢ ጌኤሺ ማዔሢ ዒንሢ ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ዓካሪ ታ ዒንሢም ፃኣፔሢ፦ ኑ ዛሎ'' ዒንሢ ማላ ማሊፃ ፆኦሲ ቤርቶይዳ ጌኤሺ ማዒ ዒንሢም ጴዻንዳጉዲ ማዓንዳኣፓዓቴም ዻቢንቴ ዓሲና ፑርታ ባኣዚ'' ማዺንቴ ዓሲና ዛላቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ኑ ዶዴሢያ ዬያ ዛሎ''ናኬ። ሃሣ ኑኡኮ ዶዱማፓ ባሼ ቲቶ ዎዛዼሢሮ ሚርጌና ኑዋ ዎዛዼኔ፤ ዓይጎሮ ጌዔቴ ዒንሢ ቢያሢ ቲቶ ዶዲሺፆና ዒዛኮ ዒኖ'' ሃውሺሴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ዒንሢና ታ ሄርሺንታ ሄርሺንቶ ቲቶም ታ ኬኤዜኔ፤ ዒንሢ ታና ዬያና ቦርሲሲባኣሴ። ቢያ ዎዴ ኑ ዒንሢም ኬኤዛ ባካ ጎኔ ባኣዚ'' ማዔሢጉዲ፥ ዒንሢ ዛሎ'' ሄርሺንቲ ቲቶም ኑ ኬኤዜ ባካ ጎኔ ማዔሢ ዔርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ቢያሢ ዒንሢ ዓይሢንታያታሢና ዒጊቹሞና ጎጋይቂ ዒንሢ ዒዛ ሾኦቺንሢ ዔኬሢ ዒዚ ጶቂሣኣና ዒንሢ ዒ ዑሣ ዓኣዼ ናሽካንዳጉዲ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ታኣኒያ ጉቤ ባኣዚ''ና ዒንሢ ጉሙርቃኒ ዳንዳዒፆና ሚርጌ ዎዛዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ፆኦሲ ሜቄዶኒያይዳ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሶም ዒንጌ ኮሹሞ ዒንጊፆ ዒንሢ ዔራንዳጉዲ ኑ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ዶዲ ሜታ ዔያቶ ሄሌ''ያ ማዔቴያ ዔያታ ሚርጌና ዎዛዻያኬ፤ ሃሣ ኮሺ'' ዔያታ ማንቆ ማዔቴያ ኮሹሞና ዔያታ ዒንጌ ዒንጊፃ ሚርጌኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ዔያቶም ዳንዳዒንታሢጉዲቱዋንቴ ዑሣ ዓኣሢ ፔ ናሹሞና ዔያታ ዒንጌሢ ታ ዔያቶ ዛሎ'' ማርካዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ዪሁዳይዳ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ዓሶ ዔያታ ማኣዳ''ኒ ኮዒ ሚርጌና ኑና ሺኢቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ዔያታ ማዼ ባኮ ኑ «ዔያታ ማዻንዳያ ናንዳኔ» ጌዒ ማሌስካፓ ዑሣኬ፤ ዔያታ ቤርታሲ ፔና ጎዳሢም ዒንጌኔ፤ ዬካፓ ጊንሣ ፆኦሲ ማሊፆጉዴያ ፔ ቶኦኮ'' ኑም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ዬያ ማዾ'' ቤርታ ማዺሾ ዓርቄሢ ቲቶ ማዔሢሮ ሃሢ ዬይ ዒንሢ ኮሹሞና ዒንጋ ዒንጊፆ ጋፒንሢ ሄሊ''ሲ ዒ ማዺሻንዳጉዲ ኑ ዒዛ ሺኢቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ዒንሢ ኪሪስቶሴ ጉሙርቂፆና ማዖም ጌስቶ ጌኤሲና፥ ዔራቶና፥ ዓሲ ማኣዳ''ኒ ዒንሢኮ ዓኣ ዶዶ ማሊፆና፤ ሃሣ ኑና ዒንሢ ናሽካ ናሹሞና ማዔቴያ ዼኤፒ ማዾ ዒንሢ ማዼሢጉዴያ ዬያ ኮሹሞና ዒንሢ ዒንጊ ማዻ ማዾ''ናኣ ዒንሢ ዶዳንዳጉዲ ኑ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ዓካሪ ዬያ ታ ጋዓሢ ዓይሥሢ ኪኢታ ማሂቱዋሴ፤ ጋዓንቴ ሜሌ'' ዓሳ ዶዲ ዒንጋ ዒንጊፆና ዒንሢና ዎላ'' ቤኤዚ ዛጊ ዒንሢኮ ጎኔ ናሹሞ ዔራኒ ታ ኮዓሢሮ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ዒንሢ ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴ ኮሹሞና ዒንጌ ዼኤፖ ዒንጊፆ ዔራኔ፤ ዒዚ ሚርጌ ዖርጎቺታዖ ዒንሢ ዖርጎቻኒ ዒንሢ ዛሎ''ሮ ጌዒ ማንቆ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ዬኖ ዛሎ''ና ዒንሢም «ኮሺ ማዓንዳኔ» ጌዒ ታ ማላ ዞሮ ዒንሢ ታ ዞራኔ፤ ሂናኣቤሬ ዒንጊፆና ሌሊቱዋንቴ ዒንጋኒ ማሊፆናኣ ቤርቲ ማዔ ዓሳ ዒንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ዬያሮ ዒንሢ፡ ዒንጋኒ ናሹሞና ዔቄ ማሊፃ ማዺንቴያ ማዒ ጋፒንሢ ሄላ''ንዳጉዲ ዒንሢኮ ዓኣ ጎይፆ ዬያ ዒንሢ ማሌ ማዾ'' ሃሢ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","ናሹሞና ዒንጋኒ ማሊሢ ዓኣቴ ዓሲኮ ዒንጊሢ ፆኦሲ ቤርታ ዔውቴያ ማዓሢ ዓሢ ፔኤኮ ዓኣ ጎይፆ ዒንጋዛ ማዓንዳኣፓዓቴም ባኣ ባኣዚ'' ዒንጋንዳኔ ጌይፆናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ዬያ ታ ጋዓሢ' ቢያሢ ዒንሢ ሄኮ ማዓንዳጉዲ ማዓንዳኣፓዓቴም ዒንሢ ዒንጊፆና ሜቶይዳ ጌሌም ማኣዲ''ንታ ዓሳ ሜታባኣያ ዴዓንዳጉዲ ጌይቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ሃሢ ዒንሢኮ ዓኣ ባካ ዔያቶ ሜታሢ ማኣዳ''ያ ማዖንጎ፤ ሃሣ ዒንሢ ሜታዼ ዎዶ''ና ዔያቶኮ ዓኣ ባካ ዒንሢ ሜታሢ ማኣዳ''ያ ማዖንጎ፤ ዬያይዲፆና ዒንሢኮ ባኣካ'' ሄኩሞ ዓኣያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ዬይያ፦ «ሚርጌ ቡኩሲ ዔኬሢም ዑሣ ዓኣዼ፥ ዺቢባኣሴ፤ ዻካ'' ቡኩሲ ዔኬሢማኣ ፓጪ፥ ዻኪ''ባኣሴ» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ታ ዒንሢም ማላሢጉዲ ቲቶዋ ዒንሢም ማላንዳጉዲ ማሄ ፆኦዛሢ ጋላቲንቶጎ። ");
INSERT INTO mdybse_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ሓሢ ቲቶ ዒንሢ ኮራ ዴንዳሢ ፔኤሮ ናሽኪኬ፤ ኑ ዒዛ ዴንዶም ሺኢቃሢሮ ሌሊቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ኮዦ ሃይሶ ኬኤዚፆና ኪሪስቶሴ ጉሙርቃ ዓሶ ሺኢጲፆ ማኣሮይዳ ቢያ ዔርቴ፥ ዒሻሢ ዒዛና ዎላ'' ኑ ዳካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ዒዚ ዬይ፥ ዒሻሢ ኑኡኒ ዬያ ኮዦ ማዾ'' ጎዳ ቦንቾም ማዻኣና፤ ሃሣ ኑ ማዻኒ ናሹሞና ዔቃኣና ኑኡና ዎላ'' ዒ ዓኣዺ ማዻንዳጉዲ ሺኢጲፆ ማኣሮ ዓሳ ዒዛ ዶኦሬያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ዬያ ዒንጎና ሚኢሾ ዓርቂ ማዾይዳ ኑ ፔኤሻ ዎዶ''ና ኑ ዾንኪንቱዋጉዲ ኮሺ'' ኑ ሂርጊ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ዓይጎሮ ጌዔቴ ማሊፃ ኑኡኮ ጎዳ ቤርታ ሌሊቱዋንቴ ዓሲ ቤርቲዳኣ ኮሺ ማዔ ባኣዚ'' ማዻኒታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ሚርጌ ዎዴ ሚርጌ ባኣዚ''ና ጉሙርቂንታያ ማዒፃ ዛጊንቴም ዶዲ ማዒ ጴዼ፥ ዒሻሢያ ቲቶንሢና ዎላ'' ኑ ዳኬሢ ዬያሮኬ፤ ዒዚ ዒንሢ ሚርጌና ጉሙርቃሢሮ ሃሢ ዒንሢ ዒ ማኣዳ''ኒ ዶዲ ማላ ማሊፃ ኮሺ'' ዼኤፒኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ቲቶ ዛሎ'' ዔራኒ ዖኦጫ ዓሲ ዓኣቴ ዒዚ ዒንሢ ማኣዳ''ኒ ታኣና ዎላ'' ማዻ ታኣኮ ላጌኬ፤ ዒዛና ዎላ'' ዒንሢ ኮይላ'' ሙካንዳ ዒሾንሢ ዛሎ'' ማዔቴ ዔያታ ኪሪስቶሴ ጉሙርቃ ዓሶ ሺኢጲፆ ማኣሮይዳፓ ዳኪንቴያ፥ ኪሪስቶሴ ቦንቺሳያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ዬያሮ ዒንሢ ዔያቶ ናሽካያ ማዒፆ ፔጋሲ ዔርዙዋቴ፤ ሃንጎ፥ ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሳ ዬያ ዔሮንጎ፤ ኑኡኒያ ዒንሢና ሄርሺንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ዪሁዳ ዓጮ''ይዳ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ዓሶ ማኣዳ''ኒ ዒንሢ ኬሴ'' ሚኢሾ ዛሎ'' ታ ዒንሢም ፃኣፓንዳያ ኮይሱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","ዒንሢ ዓካይያይዳ ዓኣ ዓሳ ሜሌ'' ዓሲ ማኣዳ''ኒ ዒንሢኮ ኮሺ ማሊሢ ዓኣሢ ታ ዔራሢሮ «ዓካይያይዳ ዓኣ ዓሳ ሂናኣ ቤራፓ ዓርቃዖ ሜሌ'' ዓሲ ማኣዳ''ኒ ጊኢጊንቲ ዓኣያኬ» ጌዒ ታ ሜቄዶኒያ ዓሶም ጫርቂ ኬኤዜኔ፤ ዒንሢኮ ኮሺ ማሊሢና ዔቂ ማዺፃ ሜሌ'' ዓሶ ኮሺ ማዻንዳጉዲ ጴቼኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ዓካሪ ኑ ዒንሢና ሄርሺንቲ ጌዔ ጌኤዛ ጉሪ ማዑዋጉዲ ሃንሢ ዒሾንሢ ታ ዒንሢ ኮይላ'' ዳኬኔ፤ ዒንሢያ ታ ዒንሢም ቤርታ ኬኤዜሢጉዲ ጊኢጊንቲ ካፑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ሜቄዶኒያ ዓሳ ታኣና ዎላ'' ዒንሢ ኮይላ'' ሙካ ዎዶ''ና ዒንሢ ጊኢጊንቲባኣያ ማዒ ዓኣንቴ ዴንቄቴ ኑ ዒንሢና ሄርሺንቲ ኬኤዜ ባኮና ኑናንታ ዒንሢንታ ዎላ'' ቦርሲንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ዬያሮ ዒንሢ ዒንጋንዳኔ ጌዒ ናኣቤ ባኮ ቤርታዺ ዒንሢ ጊኢጊሻንዳጉዲ ዒንሢም ጶቂሢ ኬኤዞም ጌዒ ሃንሢ ዒሾንሢ ቤርታሲ ዒንሢ ኮይላ'' ዔያቶ ሺኢቂ ዳካኒ ኮይሳያታሢ ታ ዔሬኔ፤ ዬያይዴም ታኣኒ ሙካ ዎዶ''ና ዒንሢ ዒንጋኒ ጌዔ ባካ ዒንጊንቲ ጊኢጌያ ማዓንዳኔ፤ ዒንሢ ዒንጋሢያ ዓሲ ዎልቃዼምቱዋንቴ ናሹሞና ዒንጋያ ማዒፃኣ ዔርታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","«ዻካ'' ዜርሢ ዜርቄሢ ዻካ'' ሃኣኮ ዔካንዳኔ፤ ሚርጌ ዜርሢ ዜርቄሢ ሚርጌ ሃኣኮ ቡኩሲ ዔካንዳኔ» ጌይንቴሢ ጶቂሡዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ፆኦሲ' ናሽካሢ ዎዛና ዒንጋ ዓሲ ማዔሢሮ ፔቴ'' ፔቴ''ሢ ዒንጋኣና ፔ ዒና'' ናሽኬሢጉዲ ማዓንዳኣፓዓቴም «ዓይጎሮ ታ ዒንጋይ?» ጌዒ ጌዒ ዓሲ ዒንጎም ጌዒ ዎልቃዼም ዒንጎፓ። ");
INSERT INTO mdybse_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ዒንሢ ቢያ ዎዴ ኮይሳ ባኣዚ'' ቢያ ዴንቂ፥ ኮሺ ማዾ ቢያ ማዻንዳጉዲ ዓንጆ ዒንሢም ፆኦሲ ዒንጋኒ ዳንዳዓኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ዬይያ፦ «ማንቆ ዓሶም ኮሹሞና ዒዚ ዒንጌኔ፤ ዒዛኮ ኮሹማ ናንጊና ናንጋኔ» ጌይንቲ ፃኣፒንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ዜርሢ ዜርቃሢም ዜርሢ፤ ሃሣ ዓሲ ሙዓንዳጉዲ ሙኡዚ'' ዒንጋ ፆኦዛሢ' ዒንሢ ዜርቃንዳ ዜርፆ ሚርጌ ዒንሢም ዒንጋንዳኔ፤ ዒንሢ ዒንጋሢኮዋ ዓኣፖ ዒ ሚርጊሻዳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ዒንሢ ኮሹሞና ዒንጋ ባካ ኑ ዛሎ''ና ዔያቶም ሄላ'' ዓሳ ቢያ ፆኦሲ ጋላታንዳጉዲ ሃሣ ቢያ ዎዴ ኮሹሞና ዒንሢ ዒንጋንዳጉዲ ፆኦሲ ቢያ ባኣዚ''ና ዒንሢ ዖርጎቻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ዬይ ዒንሢ ዒንጊፆና ማዻ ማዻ'' ኪሪስቶሴ ጉሙርቃ ዓሶኮ ሜታሢ ሼሌዒሳያ ሌሊቱዋንቴ ፆኦሲ ሚርጌና ዔያታ ጋላታንዳጉዲ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ዬይ ማዻ'' ዒንሢኮ ዒ'ንሢ ኪሪስቶሴኮ ኮዦ ሃይሶ ዋይዚ ዔኪ ዓይሢንቴሢሮና ዔያቶና ሜሌ''ዞንሢናም ዒንሢኮ ዒንጊፃ ዔርቴያ ማዔሢሮ ቢያሢ ፆኦሲ ጋላታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ዔያታ ፆኦሲ ዒንሢም ዒንጌ፥ ዑሣ ዓኣዼ ዼኤፒ ማዔ ኮሹሞ ዒንጊፆ ዛሎ''ና ዒንሢ ጶቂሣሢሮ ዒንሢም ዔያታ ሺኢቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ዓሲ «ሃማኬ» ጌይ ኬኤዛኒ ዳንዳዑዋ ፆኦሲኮ ዒንጊፆሮ ዒዚ ጋላቲንቴያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ዒንሢ ኮይላ'' ዓኣዖ «ሴልቃያ»፤ ዒንሢ ኮይላ''ፓ ሃኪ ዴንዳዖ ጋዓንቴ «ጫርቃያ» ጌይንቴሢ፥ ታኣኒ ጳውሎሴ ኪሪስቶሴኮ ኮሹሞና ሼሌዑሞና ማዒ ታ ዒንሢ ሺኢቃኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ታ ዒንሢ ሺኢቃሢ' ዒንሢ ኮራ ታ ሙኬ ዎዶ''ና ዬያይዲ ጫርቂ ጌስታንዳጉዲ ታና ማሂፖቴ ጌይኬ፤ ዓሲ ማሊሢና ኑ ሃንታያ ማሂ ኑና ፓይዳ፥ ፔቴ'' ፔቴ'' ዓሶ ቤርታ ጋዓንቴ ጫርቂ ጌስታኒ ታ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","ዎዚ ኑ ሃያ ዓጫ'' ናንጋያ ማዔቴያ ኑ ዖልታሢ ሃያ ዓጮ'' ዓሳ ዖልታ ጎይፆቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ኑኡኮ ዖሎ ዓንጋማ፡ ዖሎሮ ኬልቂ ዴዖና ኬኤሎ'' ዶይሳኒ ዳንዳዓ፥ ፆኦሲ ዎልቄ ዓኣ፥ ዓንጋሞ ማዓንዳኣፓዓቴም ሃያ ዓጮ'' ዖሎ ዓንጋሞጉዲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ዓሲ ፆኦሲ ዔሩዋጉዲ ሉኡዙሞና ማርሞ ማርማሢንታ ዖቶርሞ ማሊፆዋ ጉቤ ኑ ባይዛንዳኔ፤ ዓሲኮ ማሊፆ ጉቤ ኑ ዲዒ ዲዒ ኪሪስቶሴም ዓይሢንታንዳጉዲ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ዒንሢኮ ዓይሢንቲፃ ጎኔ ማዔሢ ኑ ዔሬሢኮ ጊንፃ ዓይሢንቲ ዒፃ ባኣዚ'' ዓይጎዋ ጉቤ ኑ ፑርታና ዎጋኒ ጊኢጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ዒንሢ ዛጋሢ ፔጌና ጴዻ ባኣዚ'' ሌሊኬ፤ ዓይጎ ዓሲያ ታኣኒ ሌሊ ኪሪስቶሴሮኬ ጌዒ ጉሙርቃቶ ፔና ጊንሣ ሺርሺ ዛጎንጎ፤ ኑኡኒያ ዒዛጉዲ ኪሪስቶሴሮ ማዔሢ ዔሮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ጎዳ ኑም ዒንጌ ቢታንቶና ሚርጌና ታ ሄርሺንቴቴያ ታና ቦርሱዋሴ፤ ዎይቲ ጌዔቴ ዬይ ቢታንታ ኑም ዒንጊንቴሢ ዒንሢኮ ጉሙርቂፆ ዶዲሻኒ ማዓንዳኣፓዓቴም ባይዛኒቱዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ታኣኮ ኪኢታ'' ታ ዒንሢ ዒዒጊቻኒ ኬኤዛያ ማሎፓ። ");
INSERT INTO mdybse_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","ፔቴ'' ፔቴ'' ዓሳ «ጳውሎሴኮ ኪኢታ'' ዴኤፃያ ሃሣ ዶዲኬ፤ ጋዓንቴ ዒዛ ኑ ዛጋኣና ዑፃ ላኣፓ፥ ጌኤዛኣ ዒዛኮ ፓሡዋያኬ» ጋዓያ ናንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ዬኖ ጋዓ ዓሳ ዒንሢዳፓ ሃኬ ዓኣዖ ኑ ፃኣፓ ኪኢቶ''ና ዒንሢ ኮይላ'' ዓኣዖ ኑ ማዻ ማዾ''ናኮ ባኣካ'' ዱሙሞ ባኣያታሢ ዔሮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ኑኡኒ ጋዓንቴ ፔ ቶኦኮ'' ጋላታ ዓሶና ኑና ዎላ'' ፔቴ'' ማሃኒ፥ ሃሣ ጊንሣ ቤኤዚ ዛጋኒ ፔቴ''ታዖ ኑ ማሊሢዳ ባኣሴ፤ ዔያታ ፔና ፔኤና ቤኤዚ ዛጋሢሮ ዔያቶኮ ዒና ባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ኑኡኒ ጋዓንቴ ፔቶ'' ዑሣ ዓኣዼ ሄርሺንቱዋሴ፤ ኑኡኒ ሄርሺንታሢ' ፆኦሲ ኑና ማዾንጎ ጌዔማ ጎይፆ ዴንዲ ዒንሢ ሄላ''ንዳኣና ማዼ ማዾ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ዒንሢ ሃሢ ዓኣሢ ኑ ማዻንዳጉዲ ጌይንቴ ቤዞይዳ ማዔሢሮ ኪሪስቶሴኮ ኮዦ ሃይሶ ኬኤዛኒ ኑ ዔኪ ዒንሢ ኮይላ'' ሙኬ ዎዶ''ና ያፓ ኑ ዑሣ ዓኣዺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ዬያሮ ፆኦሲ ኑም ጌዔ ቤዛፓ ኑ ዓኣዺ ሜሌ'' ዓሲ ማዼ ማዾና ኮይሱዋ ጎይሢ ዑሣ ዓኣዼ ኑ ሄርሺንታዓ፤ ጋዓንቴ ዒንሢኮ ጉሙርቂፃ ዶዳንዳጉዲና ኑኡኮዋ ማዻ'' ፆኦሲ ኑም ዒንጌ ቤዞ፥ ዒንሢ ባኣካ'' ባሼና ዳልጋንዳኔ ጌዒ ሃጊ ማዓንዳ ዎዛ ኑ ጌሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ዓካሪ ሜሌ'' ዓሳ ማዼ ቤዞይዳ ጌሊ፥ ቤርታ ማዺንቴ ማዾ''ና ሄርሺንቱዋዖ ዒንሢኮ ዙላ'' ዓኣ ዓጮ''ም ኮዦ ሃይሶ ኑ ኬኤዛኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ጋዓንቴ «ሄርሺንታሢ ጎዳና ሄርሺንቶንጎ።» ");
INSERT INTO mdybse_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ዓይጎሮ ጌዔቴ ዓሲ ጋላቲንቴያ ማዓኒ ዳንዳዓሢ ፆኦሲ ዒዛ ጋላቴቴ ማዓንዳኣፓዓቴም ፔና ፔኤሮ ዒ ጋላቴቴቱዋኣሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ዻካ'' ዔኤያቶና ታ ጌስታ ባኮ ዒንሢ ጊቢ'' ዳንዳዓንዳጉዲ ታ ኮዓኔ፤ ጎኔኬ፥ ዒንሢ ዳንዳዒ ዳንዳዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ፆኦሲ ዒንሢ ናሽኪ፥ ዒዛም ሌሊ ዒንሢ ማዓንዳጉዲ ኮዓሢጉዲ ታኣኒያ ዒማዺ ማላኔ፤ ታ ያዺዲ ማላሢ' ፔቴ'' ኩሙሢ ዉዱሮ ናይጉዲ ፔቴ'' ዓቲንቄም ታ ዒንሢ ዖኦጬሢሮኬ፤ ዬይ ዓሢያ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ሾኦሺ ሂዋኣኖ ጪንጩሞና ጌሺ ዻቢሴሢጉዲ ጎዖንቴ ዒንሢኮዋ ማሊፃ ፑርቴም ኪሪስቶሴም ዒንሢኮ ዓኣ ፒዙሞና ጌኤሹሞና ዒንሢ ሃሻ''ንዳያናንዳኔ ጌይ ታ ሂርጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ዓይጎሮ ጌዔቴ ፔቴ'' ዓሲ ዒንሢ ኮይላ'' ሙኪ ኑኡኒ ዒንሢም ኬኤዜ ዬሱሴቱዋንቴ ሜሌ'' ዬሱሴ ዒንሢም ኬኤዜቴ ሃሣ ዒንሢ ቤርታ ዔኬ ዓያኖይዳፓ ሜሌ'' ዓያና ዒንሢ ዔኬቴ ጊንሣ ሃሣ ቤርታ ዒንሢ ዋይዚ ዔኬ ኮዦ ሃይሶይዳፓ ሜሌ'' ዋይዚ ዒንሢ ዔኬቴያ ዬያ ዒንሢ ዚቲዮ ጌይ ዛዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ጋዓንቴ ታኣኒ ዬንሢ «ፆኦሲ ማዾ''ም ዳኪንቴ ዼኤፖ ዓሶ» ጌይንታ ዓሶይዳፓ ዓይጎናኣ ሃታያ ታኣም ማሉዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ዬና ዓሳ ጌኤታ''ሢጉዲ ሃይሴ ማዢ ታ ጌስቲባኣቴያ ዔራቶ ታኣኮ ናንጊኬ፤ ዬያ ሚርጌ ዎዴ፥ ሚርጌ ባኣዚ''ና ፔጋሲ ኑ ዒንሢም ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ታኣኒ ፆኦሲኮ ኮዦ ሃይሶ ሚኢሼ ዔኩዋኣዖ ዒንሢም ኬኤዚፆና፥ ሃሣ ዒንሢ ዼ'ጊዳኒ ታ ቶኦኮ'' ሂርኪሲፃ ታኣኮ ጎሜ ማዔኔ ጌይሢዳ? ");
INSERT INTO mdybse_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ዒንሢም ማዻኒ ኪሪስቶሴ ጉሙርቃ ሃንጎ ሺኢጲፆ ማኣሮ ዓሶይዳፓ ማኣዳሢ ታ ዔኪፆና ታ ዔያቶ ቡሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ዒንሢና ዎላ'' ታ ዓኣንቴ ሜታሢ ታና ሄሌ'' ዎዶ''ና ሜቄዶኒያፓ ሙኬ ዒሾንሢ ታኣም ኮይሳ ባኮ ዒንጊ ማኣዳ''ያ ማዔሢሮ ዖናኣ ታ ሜታሲባኣሴ፤ ሃኖ'' ሄላ''ንዳኣና ዓይጎ ባኣዚ''ናኣ ታ ዒንሢ ሜታሲባኣሴ፤ ሴካ ሃጋ ቤርታኣ ታ ዒንሢ ሜታሲንዱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ኪሪስቶሴኮ ጎኑማ ታጊዳ ዓኣሢሮ ታ ጫርቂ ጌስቱዋጉዲ ዓካይያ ዓጮ''ይዳ ታና ላኣጋኒ ዳንዳዓይ ዖኦኒያ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ዬያ ታ ጋዓሢ ዓይጎሮዳይ? ታ ዒንሢ ናሽኩዋኣሢሮዳ? ፆኦሲ ዔራሢጉዲ ታ ዒንሢ ናሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ዬያታ ሓንጎ ፆኦሲ ማዾ''ም ዳኪንቴ ዓሳ፦ «ኑኡኒያ ጳውሎሴንሢጉዲ ማዻኔ» ጌይ ጌይ ሄርሺንታ ባኮ ዔያቶ ሃሺ''ሳኒ ሃሢ ታ ማዻ ጎይፆ ሃጊ ሴካኣ ማዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ዬኖጉዴ ዓሳ ኪሪስቶሴ ማዾ''ም ዳኪንቴያ ፔና ማሊሻኒ ኮዓያ፥ ሉኡዙሞና ፆኦሲ ማዾ''ም ዳኪንቴያ ማላ ጌሺ ማዻ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ዬይ ዲቃሢ ሄርሺሳ ባኣዚ''ቱዋሴ፤ ዎይቲ ጌዔቴ ፃላሄታዖ ፔና ፖዖ ኪኢታንቾ ማሃኒ ዱማ ዱማ ጎይሢና ፔና ላኣማኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ዬያሮ ፃላሄም ማዻ ዓሳ ፂሉ''ሞና ማዻያ ማሊሲ ፔና ዱማ ዱማ ጎይሢና ላኣሜቴያ ዲቃሢ ሄርሺሳያቱዋሴ፤ ጋፒንፃ ዔያታ ማዼ ማዾ'' ዛሎ'' ፔኤኮ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","«ዓይጎ ዓሲያ ታና ዔኤያኬ ጎዖፓ» ጌይ ላሚ ታ ኬኤዛኔ። ታ ዒንሢም ዔኤያ ማሊ ጴዼቴያ ዻካ'' ታ ጫርቂ ጌስታንዳጉዲ ዔኤያ ማሂ ታና ፓይዱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ሓያይዲ ታ ጫርቂ ጌስታሢ ጎዳ ማሊፆጉዲቱዋንቴ ዔኤያ ማዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ሚርጌሢ' ሃያ ሳዖ ባኣዚ''ና ሄርሺንታሢሮ ታኣኒያ ሄርሺንታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ዒንሢ ጪንጫ ማዔሢሮ ዔኤዮ ዓሶ ባኮ ዛጌዖ ጊባ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ዬያጉዲ ዖኦኒያ ዒንሢ ዓይሌ'' ማሄቶ፥ ቡሪ ዒንሢ ባኮ ዔኬቴ፥ ዒንሢ ጌሼቴ፥ ዒንሢዳ ዖቶርቂ ጌስቴቴ፥ ዖኦኒያ ዒንሢ ባዔቴ ዚቲ ጌዒ ጊቢ'' ዒንሢ ዳንዳዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ዎዚ ታና ቦርሳያ ማዔቴያ ዒንሢጉዲ ጊቢ'' ዳንዳዒፆና ኑ ዶዲ ማዒባኣሢ ታ ዒንሢም ኬኤዛኔ። ጋዓንቴ ዖኦኒያ ሄርሺንታኒ ጫርቃቶ ታኣኒያ ዒዛጉዲ ጫርቂ ሄርሺንታንዳኔ፤ ዬያ ታ ጋዓሢ ሃሢ ዔኤያጉዲ ማዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ዔያታ፥ ዬና ዓሳ፡ ዔብሬ ዓሲዳ? ታኣኒያ ዔያቶጉዲኬ፤ ዔያታ ዒስራዔኤሌ ዓሲዳ? ታኣኒያ ዔያቶጉዲኬ፤ ዔያታ ዓብራሃሜ ዜርሢዳ? ታኣኒያ ዔያቶጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ዔያታ ኪሪስቶሴም ማዻ ዓሶዳ? ታኣኒ ዔያቶይዳፓ ባሼ ኪሪስቶሴም ማዻያኬ፤ ዬያ ታ ጋዓሢ ዣኣሹሞጉዲኬ። ታኣኒ ሚርጌ ዎዴ ማዾና ላቤ''ኔ፥ ሚርጌ ዎዴ ታ ቱኡቴኔ፥ ሚርጌ ዎዴ ዢራፓናኣ ታ ጳርቂንቴኔ፥ ሚርጌ ዎዴ ሃሣ ታ ሃይቄዖ ዓቲ'' ዓቲ'' ዓኣሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","ዓይሁዶ ዓሳ ዢራፓና ሃይሢታሚ'' ታዞጳ ጳዺ ዶንጎ ማይንቲ ታና ጳርቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ሓይሢ ማይንቲ ኮኦሎ''ና ታ ጳዺንቴኔ፥ ፔቴ''ና ሹቻ ታ ዹይንቴኔ፥ ሃይሢ ማይንቲ ዋኣሢ ካኣሚሌይዳ ሜታ ታና ሄሌ''ኔ፥ ፔቴ'' ኬሊ'' ዹሚና ሮኦሪና ቢያ ዋኣሢዳ ታ ዎርቂ ፔኤቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ሚርጌ ዎዴ ታ ጎይሢ ሃንቲሢና ሜታዼኔ፤ ዬያይዳ ዎርዚ ኩሚ ታና ሙዔዖ ዓቴ''ኔ፥ ሱላንታ ታ ዒጊኖ ዓይሁዶ ዓሶንታ ዓይሁዶ ማዒባኣ ዓሳኣ ታና ዎዼዖ ዓቴ''ኔ፥ ካታሞና ካዮና ዼኤፖ ባዞ''ናይዳ ታ ሃይቄዖ ዓቴ''ኔ፤ ሃሣ ሉኡዙሞና ኪሪስቶሴ ጉሙርቃኔ ጋዓ ዓሳ ታና ዎዼዖ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ሚርጌ ታ ላቢ'' ማዺ ሜቶ ዛጌኔ፥ ሚርጌ ዎዴ ጊንዖ ታ ዓቴ''ኔ፥ ናይዚና ዋኣሢ ዼኤቢ''ና ታና ሜታሴኔ፥ ሚርጌ ዎዴ ሙኡዚ'' ባይቄም ታ ሜታዼኔ፥ ሚርጌ ዎዴ ጪኢሺና ካሉ''ሞና ታና ሜታሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ጋዓንቴ ሜሌ'' ዓቴ'' ባኮይዳፓ ባሼ ቢያ ኬሊ'' ታና ሜታሴሢ ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሶ ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ፔቴ'' ዓሲ ላባ''ኣና ታ ዒዛና ዎላ'' ላባ''ኔ፤ ሃሣ ፔቴ'' ዓሲ ባጋሢ ዻቢሲ ጎሜይዳ ጌልዜቴ ሚርጌና ታ ዻጋዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ሄርሺንቲ ጌስቲሢ ኮይሳያ ማዔቴ ታኣኒ ሄርሺንታሢ ታ ላቤ''ያ ማዒፆ ዻዋ ባኮንሢናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴኮ ዓዶ ማዔ ፆኦዛሢ ናንጊና ጋላቲንቴያ ማዖም፤ ታ ሉኡቂ ኬኤዙዋኣሢ ዒ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ዴማስቆ ካታሞይዳ ታ ዓኣ ዎዶ''ና ካኣቲ ዓሬታሴኮ ዴማ'' ማዒ ዴሮ'' ዎይሣሢ ታና ዓርቃኒ ኮዒ ካታሞ ጌላ ካሮ'' ካሮ'' ካፓ ዓሶና ካፒሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ጋዓንቴ ሹጮና ኬልቂ ኮሾ''ና ዲሮኮ ፑልታና ዓሳ ታና ሮኦጬና ኬይሴም ታ ዒዛይዳፓ ቶሊ'' ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ታኣኒ ሄርሺንቲ ጌስታንዳኔ፤ ጋዓንቴ ዬይ ፓሣ ባኣዚ''ቱዋሴ፤ ሃሢ ታኣኒ ጎዳ ታና ፔጋሲ ዻዌ ባኮና፤ ሃሣ ታኣኒ ዛጌ ባኮዋ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ፔቴ'' ኪሪስቶሴ ጉሙርቃ ዓሲስኬያ ታ ዔራኔ፤ ዬይ ዓሢ ታጶ ዖይዶ ሌዔኮ ቤርታ ጫሪንጮኮ ዑፃ ዓኣ ጫሪንጮ ዔውቲ ዓኣዼኔ፤ ዬይ ዓሢ ዔውቴሢ' ዑፃ ዒዛኮ ዬማዺ ዓኣንቴሞ ባኣንቴሞ? ታ ዔሩዋሴ፤ ፆኦሲ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","ጎኔ ዬይ ዓሢ፥ ዑፃ ዒዛኮ ዬማዺ ዓኣንቴሞ ባኣንቴሞ? ታ ዔሩዋሴ፥ ፆኦሲ ዔራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","ጋዓንቴ ዬይ ዓሢ ጌኔቴ ጌይንታ ቤዞ ዔውቴሢ ታ ዔራኔ፤ ዒኢካ ዒዚ ዓሲ' ፔጋሲ ኬኤዛኒና ጌስታኒ ዳንዳዑዋ ባኣዚ'' ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ዬያጉዴ ዓሢ ዛሎ''ና ታ ሄርሺንታኔ፤ ታ ታ ዛሎ'' ጋዓንቴ ታኣኮ ላቤ''ያ ማዒፆና ሄርሺንታኔ፤ ሜሌ'' ሄርሺንታ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ታ ሄርሺንቲ ጌስታኒ ኮዔቴታዖ ዖኦኒያ ታና ዔኤያኬ ጎዖፓ፤ ዓይጎሮ ጌዔቴ ታ ኬኤዛሢ ጎኔ ባኣዚ''ኬ። ጋዓንቴ ዓይጎ ዓሲያ ታ ዛሎ'' ዛጋ ባኮና ዋይዛ ባኮናይዳፓ ዑሣ ዼኤፒሲ ኬኤዙዋጉዲ፥ ሄርሺንቲፆ ታ ሃሻ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ዬንሢ ታኣም ጴዼ፥ ዼኤፖ ባኮንሢ ዛሎ''ና ታ ዖቶርቁዋጉዲ ታኣኮ ዓሽኮ ዓንጊሢጉዲ ጫርጋ ባኣዚ'' ታኣም ዒንጊንቴኔ፤ ዬይ ፃላሄኮ ኪኢታንቻ ማዒ ታና ሜታሴም ታ ዖቶርቁዋጉዲ ታኣም ዒንጎናያኬ። ");
INSERT INTO mdybse_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ዬይ ታና ሜታሳ ባካ ታጊዳፓ ባይቃንዳጉዲ ጎዳ ሃይሢ ማይንቲ ታ ሺኢቄኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ጋዓንቴ ዒዚ፦ «ታኣኮ ዎልቃ ጴዻሢ ኔኤኒ ላቢንቴ ዎዶ''ና ማዔሢሮ ታ ዒንጌ ኮዦ ዒንጊፃ ኔኤም ጊዳንዳኔ» ታኣም ጌዔኔ፤ ዬያሮ ኪሪስቶሴኮ ዎልቃ ታጊዳ ማዓንዳጉዲ ዑሣ ዓኣዼ ታ ዎዛዺ ዎዛዺ ታ ላቢ''ፆና ታ ሄርሺንታኒ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ዎልቄ ታኣኒ ዴንቃሢ ታኣኒ ላቤ'' ዎዶ''ና ማዔሢሮ ኪሪስቶሴ ዛሎ'' ታ ላቢ''ንታኣና፥ ጫሽኪንታኣና፥ ሜታዻኣና፥ ዒፂንቲ ዳውሲንታኣና፥ ካራ ባይዚ ታ ሃንታኣና ቢያ ታና ዎዎዛሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ታኣኒ ዬያ ጌስቲፆና ዔኤያ ማዔኔ፤ ያዺ ታ ጌስታንዳጉዲ ማሄሢ ዒንሢኬ፤ ታና ጋላታንዳዖ ዓቴ''ሢያ ዒንሢኬ፤ ዓይጎሮ ጌዔቴ ታኣኒ ዓሲ ጌይንቱዋ ዓሲ ማዔቴያ፦ «ፆኦሲ ማዾ''ም ዳኪንቴ፥ ዼኤፖ ዓሶ» ጌይንታ ዓሶይዳፓ ታ ሃታያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","ታኣኒ ዒንሢ ባኣካ'' ዓኣ ዎዶ''ና ፆኦሲ ማዾ''ም ጎኔ ዳኪንቴ ዓሲ ማዒፆ ዔርዛ ባኣዚ'' ጊቢ'' ዳንዳዒሢና ማዼ ባካ ዱማ ዱማ ማላታ፥ ዲቃሣ ባኣዚ''ንታ ፆኦሲ ዎልቄና ማዺንታ ዓኮ ባኮንታኬ። ");
INSERT INTO mdybse_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","ዒንሢ ታ ሜታሱዋዖ ሃሼ''ማፓ ዓታዛ ሃንጎ ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሶይዳፓ ዓይጎና ታ ዒንሢ ዻኪ''ሴይ? ዬይ ታኣኮ ዻቢንቲ ማዔቴ ታኣም ዓቶም ጎዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ዒንሢ ኮይላ'' ታ ሙካንዳኔ ጌይ፥ ጊኢጊንቲ ጊኢጊንቲ ዓታንቴ ሃኖ' ሃይሣሲኬ፤ ታቴያ ታ ዒንሢ ሜታሳኒ ኮዑዋሴ፤ ዓይጎሮ ጌዔቴ ታ ኮዓሢ ዒንሢ ማዓንዳኣፓዓቴም ዒንሢኮ ሚኢሾቱዋኣሢሮኬ። ናይም ሚኢሼ ቡኩሳሢ ሾዔ ዓሶ ማዓንዳኣፓዓቴም ናኣታ'' ሾዔ ዓሶም ሚኢሼ ቡኩሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ታኣኒ ጋዓንቴ ዒንሢ ዛሎ''ሮ ታኣኮ ዓኣ ባኮ ቢያ፥ ሃሣ ጊንሣ ታና ዓኣሢ ታ ዒንጌቴ ታኣም ቃራኬ፤ ዓካሪ ታ ዒንሢ ዬያይዲ ሚርጌና ናሽካዛ ዒንሢ ታና ዬማይዲ ዻካ''ና ናሽካኔ ጌይሢዳ? ");
INSERT INTO mdybse_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ዬይ ያዺ ማዔቴያ ታ ዒንሢ ሜታሳዓኬ፤ ጋዓንቴ ፔቴ'' ፔቴ'' ዓሳ ጋዓሢጉዲ ፑርታ ማሊሢና ጌሺ ታ ዒንሢ ዓርቄያ ማሉዋዖ ዓታዓ! ");
INSERT INTO mdybse_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ታ ዒንሢ ኮይላ'' ዳኬ ዓሶይዳፓ ፔቴ''ሢ ዛሎ''ናታዖ ታ ዒንሢ ቡሪያ? ");
INSERT INTO mdybse_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ቲቶ ዒንሢ ኮይላ'' ዓኣዻንዳጉዲ ታ ሺኢቄኔ፤ ፔቴ'' ኑ ዒሻሢያ ዒንሢ ኮይላ'' ዒዛና ዎላ'' ታ ዳኬኔ፤ ሂዳዖ ቲቶ ዒንሢ ዒማና ቡሪያ? ታኣና ዒዛና ዒንሢም ማዼሢ ፔቴ'' ማሊሢናቱዋዓዳ? ኑኡኮ ማዻ''ኣ ፔቴ''ቱዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ሃኖ'' ሄላ''ንዳኣና ኑ ዬያይዲ ጌስታሢ «ኑ ዻቤዖ ዻቢባኣሴ» ጌይ ጌስታያ ዒንሢም ማላ? ኑኡኒ ኪሪስቶሴና ማዒ ኬኤዛሢ ፆኦሲ ቤርታኬ፤ ኑ ዒጊኖንሢዮቴ! ኑኡኒ ሃያ ዒንሢም ኬኤዛሢ ዒንሢ ዶዲሺ ማዣኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ታኣኒ ዒንሢ ኮይላ'' ሙካ ዎዶ''ና ታ ማላ ጎይፆ ዒንሢ ማዒባኣያ፥ ሃሣ ታኣኒያ ዒንሢ ማላ ጎይፆ ማዒባኣዖ ኑ ዎላ'' ካኣማንዳኣ ናንዳኔ ጌዒ ታ ዒጊጫኔ፤ ጎዖንቴ ዒንሢ ባኣካ'' ዑራ፥ ቂኢሩሞ፥ ጎሪ''ንቲ፥ ፑርታ ማዻኒ ዞርቲሢ፥ ዓሲ ፑርቲሲ ጌስቲሢ፥ ዾንኮ፥ ዖቶርሙሞንታ ዣሎንታ ዓኣ ናንዳኔ ጌዒ ታ ዒጊጫኔ። ");
INSERT INTO mdybse_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ዬኖ ታ ዒንሢ ኮይላ'' ላሚፆ ሙካዞና ታ ፆኦዛሢ ጎዖንቴ ዒንሢ ቤርታ ታና ቦርሲሳንዳያ ናንዳኔ ጌዒ ታ ዒጊጫኔ፤ ሃሣ ሚርጌ ዓሳ ሓያኮ ቤርታ ዔያታ ማዼ ጎሞንታ ዒኢቴ ማዾ''ንታ ዓኒ ሃሣ ማቾ ማዒባኣያና ላሄሢንታ ዓኒ ሃሣ ማቾ ማዒባኣያና ላሃኒ ኮዒ ዓማሊ''ፆ ጎሞንታ ዔያታ ቡኡፂባኣያ ማዔም ታና ሚርጌ ዖዪሳንዳያ ናንዳኔ ጌዒ ታ ሚርጌ ዒጊጫኔ። ");
INSERT INTO mdybse_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ዓካሪ ሃና ታኣኮ ዒንሢ ኮይላ'' ሃይሣሶ ሙኮ ማዓንዳኔ፤ ቢያ ባኣዚ''ኮ ጎኑማ ዔርታሢ ላምዖ ሃንጎ ሃይሦ ማርካናኬ። ");
INSERT INTO mdybse_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ላሚፆ ታ ዒንሢ ዛጋኒ ዒንሢ ኮይላ'' ሙኬ ዎዶ''ና ላቲ'' ታ ዒንሢም ኬኤዜ ባኣዚ'' ዓኣኔ፤ ሃሢያ ታ ሃኬ ዓኣዖ ቤርታ ጎሞ ማዼዞንሢንታ ሃንጎዋቶንታም ላቲ'' ታ ኬኤዛኔ፤ ዓካሪ ታ ዒንሢ ኮራ ማዒ ሙካኣና ዖናኣ ታ ሚጪንቲ ጌስታዓኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ዬያይዲ ታኣና ማዒ ኬኤዛሢ ኪሪስቶሴታሢ ዒንሢ ዔራንዳኔ፤ ዒንሢ ባኣካ'' ዒ ማዻንዳሢ ዎልቄናኬ፤ ላቢ''ሢናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ዒዚ ፑርቶ ዓሶ ሱፆ ሚፆይዳ ሱፂንቲ ሓይቄሢ ላቢ''ሢና ማዔያታቴያ፥ ሃሢ ዒዚ ፆኦሲ ዎልቄና ሼምፖና ናንጋኔ፤ ኑኡኒያ ዒዛና ዎላ'' ማዒፆና ላቤ''ያ ማዔቴያ ዒንሢም ማዻኒ ፆኦሲ ዎልቄና ዒዛና ዎላ'' ሼምፔና ዓኣያ ማዒ ኑ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","ዒንሢ ፆኦሲ ጎኔ ጉሙርቃያ ማዒፆ ዔራኒ ዒንሢ ማሂ ዛጉዋቴ፤ ሃሣ ዒንሢ ጊንሣ ሺሪ ዖኦጩዋቴ፤ ዒንሢ ዣኣሌቴ ሌሊ ማዓንዳኣፓዓቴም ሃንጎ ዬሱስ ኪሪስቶሴ ዒንሢዳ ዓኣሢ ዒንሢ ዔሩዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ኑኡኒ ጋዓንቴ ዬያና ዻቢንቲ ዣኣሊባኣያ ማዔሢ ዒንሢ ዔራኔ ጌይ ኑ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ዒንሢ ፔቴ''ታዖ ፑርታ ባኣዚ'' ማዹዋጉዲ ፆኦሲ ኑ ሺኢቃኔ፤ ኑኡኒ ሺኢቃሢ ዎዚ ዓሲም ኑ ኮሺ ዓሲ ማዒ ጴዺባኣቴያ ዒንሢ ቢያ ዎዴ ፒዜ ማዔ ባኣዚ'' ማዻንዳጉዲ ማዓንዳኣፓዓቴም ኑ ኮሹሞ ዻዋኒቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ዓይጎሮ ጌዔቴ ኑ ጎኑሞም ማዻኣፓዓቴም ጎኑሞና ዎላ'' ዓኣዹዋ ባኣዚ'' ዓይጎዋ ኑ ማዻኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ኑኡኒ ላቤ''ያ ማዔም ዒንሢ ዶዲ ማዔቴ ኑም ቃራኬ፤ ኑኡኮ ሺኢጲፃ ዒንሢ ፓጬ ባኣዚ''ባኣ ዓሲ ማዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ሓያ ኪኢቶ'' ዒንሢፓ ሃኬ ዓኣዖ ታ ፃኣፔሢ ዬያሮኬ፤ ዬያይዲፆና ታ ዒንሢ ኮይላ'' ሙኬ ዎዶ''ና ጎዳ ታኣም ዒንጌ ቢታንቶና ታ ዒንሢ ሜታሳዓኬ፤ ዓይጎሮ ጌዔቴ ጎዳ ዬያ ቢታንቶ ታኣም ዒንጌሢ ዒንሢ ታ ዶዲሺ ማዣንዳጉዲኬ፥ ሻሂ ባባይዛንዳጉዲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ዓካሪ ታ ዒሾንሦ! ሚሾንሦ! ኮሺ ናንጉዋቴ፥ ፓጬ ባኣዚ''ባኣ ዓሲ ማዓኒ ዶዱዋቴ፥ ታ ዞሮ'' ዋይዙዋቴ፥ ዎላ'' ሃሣ ጊኢጊ ናንጉዋቴ፥ ሴካና ሃንጋና ኮሹሞና ናንጉዋቴ። ናሹሞና ኮሹሞናኮ ፆኦዛሢ ዒንሢና ዎላ'' ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ዎሊኮ ጌርሲንሢጉዲ ማዒ ዎሊ ሄርቂ ሄርቂ ዎሊ ዔኤሉ''ዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","ፆኦሲም ዱማዼ ዓሳ ቢያ ዒንሢ «ኮሺዳ?» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ጎዳ ዬሱስ ኪሪስቶሴኮ ኮሹማ፥ ፆኦሲኮ ናሹማ፥ ዓያኖ ጌኤዦኮ ፔቱማ ዒንሢ ቢያሢና ዎላ'' ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","ዓሲ ማሊሢና ዓሲ ዳኬያቱዋንቴ ዬሱስ ኪሪስቶሴ ዛሎ''ና ሃሣ ዒዛ ሓይባ''ፓ ዔቂሴ፥ ፆኦሲ፥ ዓዳሢ ዛሎ''ና ዒዛም ማዻኒ ዳኪንቴያ ማዔ፥ ዶኦሪንቴ ጳውሎሴይዳፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ሓሣ ዒዛና ዎላ'' ዓኣ ዒሾንሢዳፓ ቢያ ጋላቲያይዳ ዓኣ ሺኢጲፆ ማኣሮ ዓሶም ዳኪንቴ ኪኢታ፦ ");
INSERT INTO mdybse_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","ኑ ዓዳሢ፥ ፆኦዛሢዳፓ፤ ሓሣ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴይዳፓ ማዔ ሚጪንቲፆና ኮሹሞና ዒንሢም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ሓያ ዓጮ'' ፑርቱሞይዳፓ ኑና ዻቂሻኒ ኑኡኮ ዓዳሢ ማዔ፥ ፆኦዛሢ ማሊሢና ኪሪስቶሴ ኑ ጎሞሮ ጌዒ ፔና ዓኣሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ዬያሮ ፆኦሲም ናንጊና ቦንቾ ማዖንጎ፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ኪሪስቶሴኮ ኮሹሞ ዒንጊፆና ዒንሢ ዔኤሌ'' ጎዳይዳፓ ሓያይዲ ሩኡሪና ዒንሢኮ ዱማዺፆና ሜሌ'' ኮዦ ሓይሶ ባንሢ ዓኣዺፃ ታኣም ዔርቲባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ሓያ ታ ጋዓሢ ዒንሢ ዻቢሳ ዓሶና ኪሪስቶሴኮ ኮዦ ሓይሶ ዎቢሳኒ ኮዓ ፔቴ'' ፔቴ'' ዓሳ ዓኣሢሮ ማዓንዳኣፓዓቴም ኮዦ ሓይሳ ጋዓንቴ ፔቴ'' ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ዬይ ያዺ ማዔቴያ ኑኡና ጫሪንጮ ፆኦሲ ኪኢታንቻሢና ዒንሢም ኬኤዜ ኮዦ ሓይሶይዳፓ ዱማዼ ኮሺ ሓይሴ ዒንሢም ኬኤዜያ ማዔቴ ዬይ ጋዳንቂንቴያ ማዖም። ");
INSERT INTO mdybse_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","ሓያኮ ቤርታ ታ ዒንሢም ጌዔሢጉዲ ሃሣ ታ ዒንሢም ጋዓኔ፦ ዒንሢ ዋይዚ ዔኬሢዳፓ ዱማ ሜሌ'' ኮሺ ሓይሴ ዖኦኒያ ዒንሢም ኬኤዜቴ ዬይ ጋዳንቂንቴያ ማዖም። ");
INSERT INTO mdybse_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ዓካሪ ሃሢ ታኣኒ ኮዓሢ ዓሲ ታና ሄርሻንዳጉዲሞ ፆኦሲ ሄርሻንዳጉዲዳይ? ሃሣ ዓሲ ታ ዎዛሳኒ ኮዓያ ዒንሢም ማላ? ዓሲ ታ ዎዛሳኒ ኮዓያ ማዔቴ ኪሪስቶሴም ታ ማዻያ ማዓዓታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዒንሢም ኬኤዜ ኮዦ ሓይሳ ዓሲ ኬሴ'' ማሊሢዳፓ ማዒባኣሢ ታ ዒንሢም ዔርዛኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ዎይቲ ጌዔቴ ታኣም ዬያ ዬሱስ ኪሪስቶሴ ፔጋሲ ዻዌኔ፤ ዓይጎ ዓሲዳፓኣ ታ ዔኪባኣሴ፤ ሃሣ ዖኦኒያ ታና ዔርዚባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ሚና ቤርታ ዓይሁዶ ካኣዦና ዎማይዲ ታ ናንጌቴያ፥ ፆኦሲ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሶዋ ሚጪንቱዋዖ ዎማይዲ ታ ዳውሴቴያ፥ ዔያቶ ባይዛኒያ ታ ዎማዒ ማሌቴያ ዒንሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","ዓይሁዶ ዓሶ ካኣዦ ዎጎ ካፒ ታ ናንጋኣና ዓኣ ታ ዒጊኖ፥ ዓይሁዶ ዓሶይዳፓ ቢያ ታ ባሼኬ፤ ዓዶንሢ ካኣዦ ዎጎይዳፓ ሜሌ'' ታ ሃሣ ኮዑዋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ጋዓንቴ ታ ሾይንታንዳሢኮ ቤርታ ፆኦሲ ታና ዶኦሪ ፔኤኮ ኮሹሞና ታ ዒዛም ማዻንዳጉዲ ዔኤሌ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","ዓይሁዴ ማዒባኣ ዓሶም ኮዦ ሃይሶ ታ ኬኤዛንዳጉዲ ፆኦሲ ፔ ናዓሢ ታኣም ፔጋሲ ዻዋኒ ማሌ ዎዶ''ና ዓይጎ ዓሲናኣ ታ ዞርቲባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ሓሣ ታኣኮ ቤርታ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢና ካኣማኒ ዬሩሳላሜ ዒማ''ና ታ ዴንዲባኣሴ፤ ጋዓንቴ ቤርታዺ ታኣኒ ዓሬቤ ዓጪ ዓኣዼኔ፤ ዬካፓ ታ ጊንሣ ዴማስቆ ማዒ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ሓይሦ ሌዔኮ ጊንፃፓ ጴፂሮሴና ካኣሚ ጌስታኒ ዬሩሳላሜ ታ ዴንዲ፥ ዒኢካ ዒዛና ዎላ'' ታጶ ዶንጎ ኬሊ'' ታ ዴዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ጋዓንቴ ጎዳኮ ጌርሲ፥ ያይቆኦቤይዳፓ ዓታዛ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢዳፓ ዖናኣ ታ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ሓይ ታ ዒንሢም ፃኣፓሢ ሉኡዚቱዋኣሢ ፆኦሲ ቤርታ ታ ዒንሢም ዔርዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ዬካፓ ሶኦሪያና ኪልቂያ ጋዓ ዓጪ ታ ዴንዴኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ዬማና ዪሁዳ ዓጮ''ይዳ ዓኣ፥ ኪሪስቶሴ ጉሙርቃ ሺኢጲፆ ማኣሮ ዓሳ ታና ዛጊ ቤቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ዔያታ ዋይዜሢ፦ «ዬይ ሚና ኑና ዒፂ ዳውሳ ዓሢ' ዬኖ ዒ ባይዛንዳኔ ጌዒ ኮዓ ካኣዤሎ ዛሎ'' ሃሢ ኬኤዛኔ» ጋዓ ሓይሴ ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ታ ዛሎ''ሮዋ ፆኦሲ ዔያታ ጋላቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ታጶ ዖይዶ ሌዔኮ ጊንፃፓ ባርናባሴና ዎላ'' ዬሩሳላሜ ታ ዓኣዻዖ ቲቶ ታኣና ዎላ'' ዔኪ ዓኣዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ታ ዒኢካ ዴንዴሢ' ፆኦሲ ታኣም ፔጋሲ ዻዌ ጎይፆናኬ። ዬያኮ ቤርታ ታ ማዼ ባኮንታ ሃሢ ታ ማዻሢ ጉሪ ዓቱዋጉዲ ጌይሢና ዓይሁዴ ማዒባኣ ዓሶም ታ ኬኤዛ ኮዦ ሓይሶ ዔያቶኮ ዼኤፖ ዼኤፖ ሱኡጎ ዱማሲ ታ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ታኣና ዎላ'' ዓኣ ቲቶ ዎዚ ዒ ጊሪኬ ዓሲ ማዔቴያ ዓቲንቶ ቤርቶ ዒ ቲቂንታንዳጉዲ ዎልቄና ዓይሢንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ጋዓንቴ ኑኡኮ ባኣኮ'' ዔርቱዋዖ ዓኣሺንቲ ጌሌ ፔቴ'' ፔቴ'' ሉኡቃ ዒሾንሢ ዒዚ ዓቲንቶ ቤርቶ ቲቂንታንዳጉዲ ኮዔኔ፤ ዬንሢ ዓሳ ኑ ባኣኮ'' ዔርቱዋዖ ጌሌሢ ዬሱስ ኪሪስቶሴና ኑኡኮ ጎማፓ ጌኤሽኪፆ ሙሪ ዛጋኒና ኑና ዓይሌ'' ማሃኒ ማሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ኑኡኒ ጋዓንቴ ኮዦ ሓይሶኮ ጎኑማ ዒንሢና ዶዲ ናንጋንዳጉዲ ጌይሢና ዻካ'' ዎዴታዖ ዔያቶ ማሊፆም ባሺንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ዬንሢ ዓሶ ዔኪ ዓኣዻያ ማላዞንሢ ዛሎ'' ጋዓንቴ ፆኦሲ ዓሲኮ ዓኣፒ ካራ ዛጊ ዓሲ ዱማሱዋኣሢሮ ዔያቶኮ ዼኤፑማ ታኣም ዔኤቢቱዋሴ፤ ዬንሢ ዓሶ ዔኪ ዓኣዻኔ ጌይንታዞንሢዳፓ ታኣኒ ኬኤዛ ኮዦ ሓይሶ ቃኣሎ''ይዳ ታና ማኣዳ''፥ ዓይጎዋ ዓኪ ባኣዚ'' ታ ዴንቂባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ጋዓንቴ ፆኦሲ ጴፂሮሴ ዓይሁዶ ዓሶም ኮዦ ሓይሶ ኬኤዛንዳያ ማሄሢ፤ ታናኣ ኮዦ ሓይሶ ቃኣሎ'' ዓይሁዴ ማዒባኣ ዓሶም ኬኤዛንዳጉዲ ማሄሢ ዔያታ ዔሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ዬያሮ ጴፂሮሴ ዓይሁዴ ዓሶም ፆኦሲ ማዾ''ም ዳኪንቴያ ማዒ ማዻንዳጉዲ ማሄ ፆኦዛሢ ታናኣ ዓይሁዴ ማዒባኣ ዓሶም ዳኪንቲ ማዻያ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ዓሶ ዔኪ ዓኣዻያ ማላ፥ ያይቆኦቤና ጴፂሮሴና ዮሓኒሴና ፆኦሲ ታኣም ሃያ ዱማ ማዾ'' ዒንጌሢ ዔራዖ ታኣና ባርናባሴና ዎላ'' ዔያታ ፔቴ'' ማዒፆ ዔርዛ ማላታ ማዓ ሚዛቆ ኩጮና ኑ ዎሊ ዓርቄኔ፤ ዬካፓ ኑኡኒ ዓይሁዴ ማዒባኣ ዓሶ ባንሢ ዓኣዼም፤ ዔያታ ዓይሁዴ ዓሶ ባንሢ ዓኣዻኒ ኑ ዎላ'' ጫኣቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ዬይ ያዺ ማዔቴያ ዔያቶኮ ባኣካ'' ዓኣ ማንቆ ዓሶ ኑኡኒ ማኣዳ''ንዳጉዲ ዔያታ ኑና ሺኢቄኔ፤ ታኣኒያ ዬያ ማዻኒ ሚርጌ ማላያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጴፂሮሴ ዓንፆኪያ ሙካዛ ፔጌና ዒ ዻቤሢሮ ፔጋ'' ታ ዒዛ ጎሬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ያይቆኦቤ ዳኬ፥ ፔቴ'' ፔቴ'' ዓሳ ዓንፆኪያ ሙካንዳሢኮ ቤርታ ዓይሁዴ ማዒባኣ ዓሶና ዎላ'' ዒ ሙዓኔ፤ ዔያታ ሙኬሢኮ ጊንፃ ጋዓንቴ «ዓይሁዴ ዓሲቱዋዖ ኪሪስቶሴ ጉሙርቄ ዓሳ ዓቲንቶ ቤርቶ ቲቂንታንዳያ ኮይሳኔ» ጋዓ ዓይሁዶ ዓሶ ዒጊጪሢና ሎኦሺ፥ ዓይሁዴ ማዒባኣ ዓሶይዳፓ ዱማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ሃንጎዋታ ዓይሁዶታዖ ኪሪስቶሴ ጉሙርቃ ዓሳ ጴፂሮሴ ማዼሢጉዲ ማዻዛ ባርናባሴያ ዔያቶ ጎይፆ ማዺሢዳ ጌሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ዔያቶኮ ማዻ'' ኮዦ ሓይሶ ጎኑሞ ጎይፆጉዲ ፒዜቱዋኣሢ ታ ዛጋዖ ጴፂሮሴ ኮይላ''፦ «ኔኤኒ ዓይሁዴ ዓሲታዖ ዓይሁዶ ዓሶ ካኣዦ ዎጎናቱዋንቴ ዓይሁዴ ማዒባኣ ዓሶ ካኣዦ ዎጎ ጎይፆ ኔ ናንጋያኬ። ሂዳዖ ዓይሁዴ ማዒባኣ ዓሳ ዓይሁዶ ካኣዦ ዎጎ ጎይፆ ናንጋንዳጉዲ ዓይጎሮ ኔ ዔያቶ ዎልቃዺ ዓይሣይ?» ጌይ ቢያሢ ቤርታ ታ ዒዛ ጎሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ጎኔኬ፥ ኑኡኮ ዜርፃ ዓይሁዴኬ፤ ጎሞ ዓሶ፥ ዓይሁዴ ማዒባኣ ዓሶጉዲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ጋዓንቴ ዓሲ' ፆኦሲ ቤርታ ፂላ''ሢ ዬሱስ ኪሪስቶሴ ጉሙርቂሢና ማዓንዳፓዓቴም ሙሴ ዔርዜ ዎጎ ኩንሥሢናቱዋኣሢ ኑ ዔራኔ፤ ኑኡኒያ ዎጎ ኩንሥሢናቱዋንቴ ኪሪስቶሴ ጉሙርቂሢና ፆኦሲ ቤርታ ፂላ''ኒ ዬሱስ ኪሪስቶሴ ኑ ጉሙርቄኔ፤ ዓይጎሮ ጌዔቴ ዓይጎ ዓሲያ ሙሴ ዔርዜ ዎጎ ኩንሥሢና ፂሉ''ዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ኪሪስቶሴና ኑኡኮ ዎላ'' ዓኣ ፔቱሞና ፆኦሲ ቤርታ ኑ ፂላ''ኒ ኮዓዖ ኑኡኒ ኑ ቶኦኪና ጎሜ ዓሲ ማዒ ጴዼያታቶ ጎሜይዳ ኑና ዔኪ ጌልዛሢ ኪሪስቶሴኬ ጌይሢዳ? ፔቴ''ታዖ ያዺቱዋሴ! ");
INSERT INTO mdybse_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ጋዓንቴ ታኣኒ ሻሄ ካኣዦ ዎጎ ማሂ ጊንሣ ማዻሢ ታና ማዔቴ ታኣኒ ታ ቶኦኪና ዎጌ ሻሃያ ማዔሢ ዔርዛኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ታኣኒ ፆኦሲም ናንጋንዳኔ ጌይ ዎጎ ዛሎ''ና ሃይቢና ዱማዺሢጉዲ ዎጌይዳፓ ታ ዱማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ታኣኒ ኪሪስቶሴና ዎላ'' ሱፂንቴያጉዲ ማዒ ፓይዲንቴሢሮ ሃካፓ ሴካ ኪሪስቶሴ ታ ጊዳ'' ናንጋንዳፓዓቴም ታ ታኣሮ ናንጋያቱዋሴ፤ ሃሢያ ታኣኒ ዓሲ ማዒ ናንጋ ናንጋ፥ ታና ናሽኬሢና ታ ጋይቴ ፔና ዓኣሢ ዒንጌ፥ ፆኦዛሢ ናዓሢ ጉሙርቂፆና ጴዼ ናንጎናኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ፆኦሲኮ ኮሹሞ ዒንጊፆ ታኣኒ ሼሌዒሲ ዛጉዋሴ፤ ዓሲ' ፆኦሲ ቤርታ ፂላ''ሢ ሙሴ ዔርዜ ዎጎ ኩንሥሢናታቴ ኪሪስቶሴ ሓይቄሢ ጉሪኬ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","ዒንሢ ሓይ፥ ማሊ ጶቂሡዋ ጋላቲያ ዓጮ'' ዓሳ! ዖ ጌሺ ዒኖ ዒንሢኮ ባይዜይ? ኪሪስቶሴኮ ፑርቶ ዓሶ ሱፆ ሚፆይዳ ሱፂንቲ ሃይቂፆ ዛሎ'' ዒንሢ ዛዛጋጉዲ ፔጋሲ ታ ዒንሢም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ታኣኒ ሃሢ ዒንሢዳፓ ፔቴ'' ዔራኒ ኮዓ ባኣዚ'' ዓኣኔ፤ ዒንሢ ዓያኖ ጌኤዦ ዔኬሢ ሙሴ ዎጎ ኩንሥሢናሞ ኮዦ ሓይሶ ቃኣሎ'' ዋይዚ ጉሙርቂፆናዳይ? ");
INSERT INTO mdybse_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ዒንሢ ዓይፆ ፆኦሲ ዓያናና ዓርቃዖ ዓሲ ዎልቄና ኩንሣኒ ኮዓኔ፤ ሓይሾ ዒንሢ ሃኣዺ ዔኤያኬ! ");
INSERT INTO mdybse_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ኮዦ ሓይሶ ዛሎ''ና ዒንሢ ዔኬ ሜታሢ ቢያ ጉሪ ማዒ ዓቴ''ኔ ጌይሢዳ? ዬይ ጉሪ ዓቲባኣሴ! ");
INSERT INTO mdybse_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ፆኦሲ ፔኤኮ ዓያኖ ዒንሢም ዒንጋሢና ዒንሢ ኮራ ፔ ዎልቆና ማዺንታ ዓኮ ባኮ ማዻሢ ሙሴ ዎጎ ዒንሢ ኩንሣሢሮሞ ኮዦ ሓይሶ ቃኣሎ'' ዋይዚ ዒንሢ ጉሙርቃሢሮዳይ? ");
INSERT INTO mdybse_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","ሂንዳ ዓብራሃሜሲ ማሉዋቴ፦ «ዓብራሃሜ ፆኦሲ ጉሙርቄኔ፤ ፆኦሲያ ዒዛ ፔ ዓሲ ማሄኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ዓካሪ፤ ፆኦሲ ጉሙርቃዞንሢ ቢያ ዓብራሃሜ ናኣቶ'' ማዓሢ ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ፆኦሲ ዓይሁዴ ማዒባኣ ዓሶ ጉሙርቂሢ ዛላና ፂሊ''ሳንዳያ ማዔሢ ጌኤዦ ማፃኣፓ ቤርታዺ ዴንቂ፦ «ዴራ'' ቢያ ኔ ዛሎ''ና ዓንጂንታንዳኔ» ጌይሢና ቤርታ ዓብራሃሜም ኮዦ ሓይሶ ቃኣሎ'' ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ዬያሮ ፆኦሲ ጉሙርቃዞንሢ ቢያ ፆኦሲ ጉሙርቄ፥ ዓብራሃሜጉዲ ዓንጂንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","«ዎጎ ኩንሢፆና ኑ ፂላ''ንዳኔ» ጋዓዞንሢ ቢያ ጋዳንቂንቴያኬ፤ ዓይጎሮ ጌዔቴ፦ «ሙሴ ዔርዜ ዎጎ ማፃኣፖይዳ ፃኣፒንቴ ዓይሢፆና ቢያ ዶዲ ናንጉዋያ ሃሣ ማዺ ኩንሡዋ ዓሲ ጋዳንቂንቴያኬ» ጌይንቲ ፃኣፒንቴሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","«ፂሎ'' ዓሲ ጉሙርቂሢና ሼምፔና ናንጋኔ» ጌይንቲ ፃኣፒንቴሢሮ ዎጎ ኩንሥሢና ዓይጎ ዓሲያ ፆኦሲ ቤርቶይዳ ፂሉ''ዋኣሢ ዔርቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ዎጌ ጉሙርቂሢና ዓርቂንቴ ባኣዚ''ቱዋሴ፤ ጋዓንቴ «ዓሲ ዎጌና ናንጋኒ ዳንዳዓሢ ዎጎ ዓይሢፆ ቢያ ኩንሤቶኬ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","«ሚሢዳ ሱፂንቲ ሓይቃ ዓሲ ቢያ ጋዳንቂንቴያኬ» ጌይንቲ ፃኣፒንቴኔ፤ ኪሪስቶሴ ኑ ጋይቴ ጌይ ሱፂንቲፆና ጋዳንቂንቴያ ማዒ ዎጎ ጋዳሞይዳፓ ኑና ዻቂሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ዬይ ያዺ ማዔሢ' ፆኦሲ ዓብራሃሜም ዒንጌ ዓንጃ ዬሱስ ኪሪስቶሴ ዛሎ''ና ዓይሁዴ ማዒባኣ ዓሶ ሄላ''ንዳጉዲ፤ ሃሣ ፆኦሲ፦ «ታ ዒንሢም ዒንጋንዳኔ» ጌዔ ዓያኖ ጌኤዦዋ ጉሙርቂሢና ኑ ዔካንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ታ ዒሾንሦ! ታ ሚሾንሦ! ዓሲም ዔርታ ማላታ ማዓንዳ ባኣዚ'' ታ ዒንሢም ኬኤዞም። ዓሲ ዎላ'' ጫኣቁሞ ጫኣቄስካፓ ዖኦኒያ ዬኖ ጫኣቁሞ ሃሻ''ኒና ጊዳ'' ቃሳኒያ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ፆኦሲ ዓብራሃሜና ዒዛኮ ዜርፆናም ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ'' ዒንጌሢ ዬኖ ጎይፆኬ፤ ጌኤዦ ማፃኣፓ ሃጊ ማዓንዳ ዎዞ'' ቃኣላ'' ሚርጌ ዓሲም ማዓያ ማሂ፥ «ኔ ዜርፆም» ጎዑዋሴ፤ ጋዓንቴ ፔቴ'' ዓሲም ማዓያ ማሂ፥ «ኔ ዜርፃሢም» ጋዓኔ፤ ዬይያ «ኔ ዜርፃሢ» ጌይንቴሢ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ዓካሪ፥ ታ ሂዚ ጋዓኔ፤ ዖይዶ ፄኤታና ሓይሢታሚ'' ሌዔኮ ጊንፃፓ ዒንጊንቴ ዎጋ'' ቤርታዺ ፆኦሲ' ዔሪ ዶዲሼ ጫኣቁሞ ዓይሲ፥ ዒንጊንቴ ዎዞ'' ቃኣሎ''ዋ ጉሪ ማሃኒ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ፆኦሲኮ ዒንጊፃ ዎጌ ዛላና ጴዻያታቴ፥ ፆኦሲ ዒንጌ ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ''ና ማዒፃ ዓታንዳንቴኬ፤ ጋዓንቴ ፆኦሲ ዓብራሃሜም ዒንጌ ዒንጊፃ ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ''ናኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ሂዳዖ ዎጌ ዒንጊንቴሢ ዓይጌንዴሮዳይ? ዎጌ ጊዳ'' ቃሲ''ንቴሢ ዓብራሃሜም ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ''ና ዒንጊንቴ ዜርፃሢ ሙካንዳያ ሄላ''ንዳኣና ፑርታ ማዾ ዓይጎ ማዔቴያ ዔርዛኒኬ፤ ዎጌ ሙኬሢ ፆኦሲና ዓሲና ባኣካ'' ማዔ፥ ዓሢም ፆኦሲ ኪኢታንቾ ዛሎ''ና ኬኤዚንቴምኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ዬይ ያዺ ማዔቴያ ባኣካ'' ማዔ ዓሢ ፔቴ'' ዜርሢም ሌሊ ዔቃያቱዋሴ፤ ፆኦሲ ጋዓንቴ ፔቴ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ዓካሪ፤ ሙሴ ዎጋ'' ፆኦሲኮ ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ''ና ዎላ'' ጊኢጉዋያዳ? ያዺቱዋሴ! ሼምፖ ዒንጋ ዎጌ ዒንጊንቴያ ማዔቴ ፂሉ''ሞ ዎጌም ዓይሢንቲሢና ጴዼያ ናንዳንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ጋዓንቴ ጌኤዦ ማፃኣፓ ዓጫ'' ጉቤ ጎሜና ቱኡቴያ ማዔኔ ጋዓኔ፤ ዬይያ፦ ዬሱስ ኪሪስቶሴ ጉሙርቂፆና ጴዻ ዎዞ'' ቃኣላ'' ጉሙርቃዞንሢም ዒንጊንታንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","ዬይ ኪሪስቶሴ ጉሙርቂፃ ሙካንዳሢኮ ቤርታ ዎጎ ዛሎ''ና ኑ ቱኡሲ ዓሲ ማዒ ዬይ ፔጋዻንዳያ ሄላ''ንዳኣና ካራ ኑም ባይቄያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ዬያሮ ጉሙርቂፆና ኑ ፂላ''ንዳጉዲ ኪሪስቶሴ ሙካንዳያ ሄላ''ንዳኣና ሙሴ ዎጋ'' ኑና ዔርዚ ዔርዚ ዲቻያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ሓሢ ጋዓንቴ ኪሪስቶሴ ጉሙርቂሢ ሙኬሢሮ ዎጌ ኑና ዔርዚ ዔርዚ ዲቻያ ማዒፃ ዓቴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","ዬሱስ ኪሪስቶሴ ጉሙርቂፆና ዒንሢ ቢያሢ ፆኦሲ ናይኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ኪሪስቶሴና ዎላ'' ፔቴ'' ማዓኒ ዋኣፆና ማስቴ ዓሳ ቢያ ኪሪስቶሴ ዒንሢ ማኣዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ቢያሢ ዬሱስ ኪሪስቶሴ ዛሎ''ና ፔቴ'' ዒንሢ ማዔሢሮ ዓይሁዴና ዓይሁዴ ማዒባኣ ዓሲና፥ ማዻሢና ማዺሻሢና፥ ዓቲንቄና ላኣሊናኮ ባኣካ'' ዱሙሞ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ዓካሪ ዒንሢ ኪሪስቶሴሮ ማዔቶ ዓብራሃሜ ዜርፆኬ፤ ዒንጊንቴ ዎዞ'' ቃኣሎ'' ጎይፆና ዒዛና ዎላ'' ዒንሢ ፆኦሲ ዒንጋ ባኮ ዔካንዳዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ሃሣ ታ ሂዚ ጋዓኔ፦ ዓዶ ዻካላኒ ቶይዶ ናዖ ማዔሢ ናይ ዓኣዖ ዎዚ ዒ ዓዶ ቆሎ''ኮ ቢያ ቢቲ ማዔቴያ ማኣራ ዓኣ ካራሞይዳፓ ዒ ዱማቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ጋዓንቴ ዓዴ ዒዛም ጌዔ ዎዶ'' ሄላ''ንዳኣና ዒዛ ዔርዚ ዔርዚ ዲቻ ዓሶ ዴማ'' ዒ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ዬያጉዲ ኑኡኒ ፆኦሲ ዓያኖ ባኮ ዛሎ''ና ናይ ዓኣ ዎዶ''ና ሓያ ዓጮ'' ካኣዦ ዎጎም ዓይሌ ማዒ ኑ ዎርቃያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ጋዓንቴ ፆኦሲ ጌዔ ዎዳ'' ሄላ''ዛ ዓሲዳፓ ሾይንቴያ፤ ሓሣ ዎጎም ዓይሢንታያ ማዔ ፔኤኮ ናዓሢ ዒዚ ኑም ዳኬኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ዬያ ዒ ማዼሢ ዎጎም ዓይሢንታያ ማዔዞንሢ ዻቂሻኒና ኑናኣ ዒዛኮ ኮሹሞና ፔ ናይ ማሃኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ፆኦሲ ናይ ኑ ማዔሢሮ፦ «ታ ዓዴ» ጌይ ዒዛ ዔኤላ''፥ ፔኤኮ ናዓሢ ዓያኖ ኑም ዒ ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ዬያሮ ሃይፓ ሴካ ፆኦሲኮ ኔ ናይ ማዓንዳፓዓቴም ዓይሌ''ቱዋሴ፤ ፆኦሲኮ ኔ ናይ ማዔያታቴ ፆኦሲ ፔ ናኣቶ''ም ጊኢጊሼ ባኮ ቢያ ኔኤም ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ሓያኮ ቤርታ ፆኦሲ ዒንሢ ዔሪባኣሢሮ ካኣሽኮንዶ ባኣዚ'' ማዒባኣ ባኮም ዓይሌ'' ማዒ ዒንሢ ናንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ሃሢ ጋዓንቴ ዒንሢ ፆኦሲ ዔሬኔ፤ ላሚ ታ ኬኤዛኒ ኮዔቴ ፆኦሲያ ዒንሢ ዔሬኔ። ሂዳዖ ጊንሣ ዬያ ፓሡዋያና ላቤ''ያ ማዔ፥ ዓጮ'' ካኣዦ ዎጎ ባንሢ ዎዲ'' ዒንሢ ማዔይ? ሃሣ ዎዲ'' ዒንሢ ላሚ ዔያቶኮ ዓይሌ'' ማዓኒ ኮዔይ? ");
INSERT INTO mdybse_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ዱማ ዱማ ኬሎ''፥ ዓጊኖ፥ ዎዶ''ንታ ሌዖንታ ዒንሢ ቦንቻኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ዬያሮ ታ ዒንሢ ማኣዳ''ኒ ላቢ''ንቲ ማዼ ማዻ'' ጉሪ ማዓንዳሲንታኔ ጌይ ታ ሂርጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ዒንሢጉዲ ማዔሢሮ ዒንሢያ ታጉዲ ማዑዋቴ ጌይ ታ ሺኢቃኔ፤ ዒንሢ ታኣም ዓይጎዋ ፑርቲሲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ቤርቲ ቤርታ ኮዦ ሓይሶ ታ ዒንሢም ኬኤዛኒ ዳንዳዔሢ ታኣኮ ሃርጎ ዛሎ''ና ማዔሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ዎዚ ዒንሢም ታኣኮ ሃርጋ ሜቶ ማዔያታቴያ ዒንሢ ታና ቦሂባኣሴ፤ ሃሣ ሻኣኪንቲባኣሴ። ጋዓንቴ ፆኦሲኮ ኪኢታንቻጉዲ ዬያፓ ዑሣ ኪሪስቶሴ ቦንቺ ዔካያጉዲ ታና ዒንሢ ቦንቺ ዔኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ሓሢ ሃያኮ ቤርታ ዒንሢ ታ ዛሎ''ና ዎዛዻ ዎዛ'' ቢያ ዎዎይቴይ? ዬኖና ዒንሢም ዳንዳዒንታቴ ዒንሢኮ ዓኣፖታዖ ታኣም ዒንጋንዳጉዲታሢ ታ ታ ቶኦኪና ዬያኮ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ሂዳዖ ሃሢ ጎኑሞ ታ ዒንሢም ኬኤዜሢሮ ዒንሢኮ ሞርኬ ታ ማዒያ? ");
INSERT INTO mdybse_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ሓንጎ ዓሳ ዒንሢ ዛሎ'' ማሊ ሜታዻንዳያ ናንዳኔ፤ ማዔቴያ ዬያ ዔያታ ማዻሢ ኮሹሞምቱዋሴ፤ ዔያቶኮ ማሊፃ፦ ዒንሢ ኑ ጊዳ''ፓ ዱማዻንዳጉዲና ዔያቶም ዒንሢ ባሼ ማላንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ኮሹሞ ባኣዚ''ምታቴ ዶዲ ማሊፃ ኮሺኬ፤ ጋዓንቴ ዬይ ዒንሢኮ ታኣኒ ዒንሢና ናንጋ ዎዶ''ና ሌሊ ማዖፓ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ታ ናይዮቴ! ኪሪስቶሴ ዒንሢዳ ፔጋዺ ጴዻንዳያ ሄላ''ንዳኣና ጊንሣ ዒንሢ ዛሎ'' ማሊፆና ሾይቺ ቆፂ''ሢ ሜታሳሢጉዲ ሜቶይዳ ታ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ዱማ ማዔ ጎይሢና ዒንሢም ኬኤዛኒ ሃሢ ታ ዒንሢ ኮራታቴ ዓይጎ! ጋዓንቴ ዓይጎ ታ ማዻንዳቴያ ዔርቶ ዒፂ ባሼሢሮ ታ ሜታዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","ዒንሢ ሙሴ ዔርዜ ዎጎም ዓይሢንቲ ናንጋኒ ኮዓ ዓሳ፥ ሂንዳ ታኣም ኬኤዙዋቴ፤ ዎጋ'' ዎዚ ጋዓቴያ ዒንሢ ዋይዙዋዓዳ? ");
INSERT INTO mdybse_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ዎጎ ማፃኣፖይዳ፦ «ዓብራሃሜኮ ላምዖ ናይ ዓኣኔ፤ ፔቴ''ሢ ዒዛኮ ዓይሌ''ላ ሾዔያ ማዓዛ፥ ባጋሢ ሾይንቴሢ ማኣሮ ዒንዶይዳፓኬ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ዓይሌ''ሎይዳፓ ሾይንቴሢ ዓሲ ማሊሢና ማዓዛ ማኣሮ ዒንዶ ናዓሢ ሾይንቴሢ ጋዓንቴ ፆኦሲ ዒንጌ ዎዞ'' ቃኣሎ'' ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ዬንሢ ላምዖ ላኣሎንሢ ፆኦሲ ጫኣቄ ላምዖ ጫኣቁሞኮ ኮኦኪንሢ ማዓኔ። ፔቴ''ዛ፥ ሲና ዹኮ''ና ኮኦኪንሢንታዛ ዓጋኣሮኬ፤ ዒዛ ናኣቶ'' ሾዓሢ ዓይሉሞምኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","ዓጋኣራ ዓሬቦ'' ዓጮ''ይዳ ዓኣ፥ ሲና ዹኮ'' ማላታኬ፤ ዬያሮ ሃሢ ዓኣ ዬሩሳላሜ ማላኔ፤ ዒዛ ፔኤኮ ናኣቶ''ና ዎላ'' ዓይሉሞይዳ ዓኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ሎ ጫሪንጫፓ ማዔ፥ ዬሩሳላሜ ጋዓንቴ ዓይሌ''ቱዋሴ፤ ዒዛ ኑኡኮ ዒንዴሎኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","ዓይጎሮ ጌዔቶ፦ «ኔኤኒ ናይ ሾውዋ ዞኦኬሌ ዎዛዼ! ኔኤኒ ሾዓኒ ባኒ ዔሩዋዜሌ ዒላሼ! ዓኒ ዓኣ ላኣሌሎይዳፓ ባሼ ዓኒ ሃሼ'' ላኣሌሎኮ ሚርጌ ናይ ዓኣያ ማዓንዳኔ» ጌይንቲ ፃኣፒንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ታ ዒሾንሦ! ታ ሚሾንሦ! ዒንሢያ ዪሳኣቄጉዲ ዒንጊንቴ ዎዞ'' ቃኣሎ'' ናኣቶ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ጋዓንቴ ዬኖ ዎዶ''ና ዓሲ ማሊሢና ሾይንቴሢ ዓያኖ ማሊፆና ሾይንቴሢ ዒፂ ዳውሴሢጉዲ ሓኖ''ዋ ዬያጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ጋዓንቴ ጌኤዦ ማፃኣፓ ዬያ ዛሎ'' ዎዚ ጋዓይ? ማፃኣፓ፦ «ዓይሌ''ሎ ናዓሢ ማኣሮ ዒንዳ ሾዔ ናዓሢና ዎላ'' ዓዶ ባኮ ዻካሊንዱዋኣሢሮ ዓይሌ''ሎ ናዓሢና ዎላ'' ኬሲ'' ዳኬ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ዬያሮ ታ ዒሾንሦ! ታ ሚሾንሦ! ኑኡኒ ማኣሮ ዒንዶ ናኣቶ''ኬ፤ ዓይሌ''ሎ ናኣቶ''ቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ዓይሉሞፓ ኑ ኬስኪ፥ ሜታ ባኣያ ናንጋንዳጉዲ ኪሪስቶሴ ኑና ሙሴ ዔርዜ ዎጎ ዓይሉሞፓ ኬሴ''ኔ። ዬያሮ ዶዲ ዔቁዋቴ፤ ላሚ ዬያ ዓይሉሞይዳ ጌሊፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ሓሢ ታኣኒ፥ ጳውሎሴ ዒንሢም ሂዚ ጋዓኔ፦ «ዓቲንቴ ቤርቲ ቲቂንታንዳያ ኑና ኮይሳኔ» ጌዒ ዒንሢ ዓቲንቶ ቤርቶ ቲቂንቴቴ ኪሪስቶሴ ዒንሢ ማኣዱዋያ ማዓንዳኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","«ዓቲንቴ ቤርቲ ቲቂሢ ታኣም ኮይሳኔ» ጌይ ቲቂንታይ ቢያ «ሙሴ ዔርዜ ዎጎ ቢያ ካፒ ኩንሣንዳያ ኮይሳኔ» ጌይ ላሚ ታ ላቲ'' ኬኤዛኣኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ዒንሢ ዎጎ ካፒ ፂላ''ኒ ኮዓዞንሢ ቢያ ኪሪስቶሴይዳፓ ዱማዺ፥ ፆኦሲኮ ኮሹሞ ዒንጊፆ ዻቂንታፓኣ ዒንሢ ሃኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ኑኡኒ ጋዓንቴ ፂሉ''ሞ ዴንቃኒ ዎዛ ጌሣሢ ፆኦሲ ዓያኖ ዛሎ''ና ጉሙርቂሢናኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ዓይጎሮ ጌዔቴ ኑና ማኣዳ''ንዳሢ ኑኡኒ ዬሱስ ኪሪስቶሴና ዎላ'' ፔቴ'' ማዔም ናሹሞ ዛላና ማዾይዳ ፔኤቃ ጉሙርቂሢ ማዓንዳኣፓዓቴም ዓቲንቴ ቤርቲ ቲቂንቴቴያ ሓሼ''ቴያ ኑና ማኣዳ''ዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ሓይማ ሄላ''ንዳኣና ዒንሢ ቃራታዖ ሃሢ ዒንሢ ጎኑሞም ዓይሢንቱዋጉዲ ዖ ላኣጌይ? ");
INSERT INTO mdybse_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ዬያጉዴ ጌሺፃ ዒንሢ ኮራ ሙኬሢ ዒንሢ ዔኤሌ''፥ ፆኦዛሢዳፓቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ዬይያ፦ «ዻካ'' ሙኑቃ ፃኣዛ ሙኑቆ ቢያ ካፂሳኔ» ጌይንቴሢጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ፔቴ''ታዖ ሜሌ'' ፑርታ ማሊሢ ዒንሢኮ ባኣሢ ታኣኒ ጎዳና ማዒ ጉሙርቃኔ። ጋዓንቴ ዒንሢ ዻቢሻኒ ማላይ ዓኣቶ ዬይ ዓሢ ዒዛም ኮይሳ ሜቶ'' ዔካንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","ታ ዒሾንሦ! ታ ሚሾንሦ! ታኣኒ ሃኖ'' ሄላ''ንዳኣና ኬኤዛሢ፦ «ዻቂንታሮ ዓቲንቴ ቤርቲ ቲቂንቲሢ ኮይሳኔ» ጌይ ጌይታቶ ሃሢ ሄላ''ንዳኣና ዓይጎሮ ዒፂንቲ ታ ዳኪንታይ? ያዺ ማዔያታቴ ታ ኬኤዛ፥ ኪሪስቶሴ ሓይባ'' ዹቆ ዓሶም ማዒንዱዋያታንቴኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ዓካሪ ዬንሢ፥ ዒንሢ ዻቢሻኒ ኮዓ ዓሶንሢ ዓቲንቶ ቤርቶ ቲቂፃ ዓታዛ ጉቤ ቲቄቶ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","ታ ዒሾንሦ! ታ ሚሾንሦ! ዒንሢ ዎጌ ዓይላቶይዳፓ ኬስካንዳጉዲ ዔኤሊ''ንቴኔ፤ ጋዓንቴ ፔቴ''ሢ ባጋሢም ናሹሞና ዓይሢንቲ ማዻንዳኣፓዓቴም ዬይ ዒንሢኮ ዓይሉማፓ ኬስኪፃ ዒንሢ ሱኡኬ ኩንሥሢም ማዖፓ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ዓይጎሮ ጌዔቴ፦ «ዓሲ ዓዳ'' ኔና ማሂ ናሽኬ» ጋዓዛ ሙሴ ዔርዜ ዎጎ ቢያ ዓርቂ ዓኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ጋዓንቴ ዎሊ ዒንሢ ጌኤሲና ዻዓያና ሙዓያ ማዔቴ ዒንሢ ዎላ'' ባይቁዋጉዲ ዒንሢና ባዴዔ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ዓካሪ ዓያናና ናንጉዋቴ፤ ዒንሢ ዬያይዴቴ ዒንሢ ማዻኒ ሱኡካዻ ባኮ ማዺንዱዋሴ ታ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","ዓይጎሮ ጌዔቴ ዒንሢ ማዻኒ ሱኡካዻ ማሊፃ ዓያና ማሊሢና ዎሊ ዒፃያኬ፤ ዓያናና ዒንሢ ማሊፆና ዎላ'' ካኣሙዋሴ፤ ዬያሮ ዒንሢ ማዻኒ ናሽካ ባኮ ማዻኒ ዒንሢ ዳንዳዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","ዓያና ዒንሢ ዔኪ ዓኣዻያ ማዔቴ ዎጌም ዒንሢ ዎርቃያ ማዒንዱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","ዓሲ ማዻኒ ሱኡካዻ ማዾ ዔርቴያኬ፤ ዬያታ፦ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂሢ፥ ዒኢሳ ማዾ ማዺሢ፥ ማቾ ሃሣ ዓኒ ማዒባኣያና ላሃኒ ኮዒ ማሊሢ፥ ");
INSERT INTO mdybse_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ሜሌ'' ካኣሺ ካኣሽኪሢ፥ ማርሻ ማርሺሢ፥ ዓሲ ዒፂሢ፥ ዑራ፥ ቂኢሩሞ፥ ዻጋ፥ ፔና ሌሊ ናሽኪሢ፥ ዱማዺሢ፥ ጌኔ ማዾሮ ዞርቲሢ፥ ");
INSERT INTO mdybse_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ጌኔ ማዾ፥ ማሢንቲሢ፥ ኮይሱዋ ኮሢ ኮርጊሢና ዬያጉዴ ማዾኬ፤ ሓያኮ ቤርታ ታ ዒንሢም ላቴሢጉዲ ሓሣ ታ ዒንሢም ላቲ'' ኬኤዛኣኬ፤ ዬያጉዴ ማዾ'' ማዻዞንሢ ፆኦሲ ካኣቱሞይዳ ጌላዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ዓያና ጌኤሺኮ ዓኣፒ ጋዓንቴ፦ ናሹሞ፥ ዎዛ፥ ኮሹሞ፥ ጊቢ'' ዳንዳዒሢ፥ ዓሲም ኮሽኪሢ፥ ጉሙርቂንቲሢ፥ ");
INSERT INTO mdybse_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ሼሌዑሞ፥ ፔና ዔሪ ዎይሥሢኬ። ዬንሢጉዴ ባኮ ዒፃ ዎጌ ባኣሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ዬሱስ ኪሪስቶሴሮ ማዔ ዓሳ ፔኤኮ ፑርቶ ማሊፆ ሱኡኮ ዬሱሴና ዎላ'' ፑርቲሴ ዓሶ ሱፆ ሚፆይዳ ሱፂ ዎዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","ዓያናና ኑ ናንጋያ ማዔቴ ዓያና ኑና ዻዋ ጎይፆ ኑ ሓንቶም። ");
INSERT INTO mdybse_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","ዎሊዳ ፑርቱሞና ኑ ዔቂ ዔቂ፥ ሓሣ ቂኢሪ ቂኢሪ ጉሪ ኑ ሄርሺንቲባኣያታቴ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","ታ ዒሾንሦ! ታ ሚሾንሦ! ዓሲ ዓይጎ ባኣዚ'' ዻቤቴያ ዒንሢ፥ ዓያናና ማዔ ዓሳ ዬያጉዴ ዓሶ ሼሌዑሞና ጊኢጊሹዋቴ፤ ጋዓንቴ ኔና ዬይ ዻቢሹዋጉዲ ኔና ዔሬ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ዎሊ ሴካና ሃንጋና ማኣዲ'' ማኣዲ'' ፔቴ''ይ ባጋሢኮ ዴኤፆ ባሶ'' ባሶ''ንጎ፤ ዬያይዲ ኪሪስቶሴ ዓይሤ ዎጎ ዒንሢ ኩንሣያ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ዖናታቴያ ሓንጎዋቶይዳፓ ዱማዻ ባኣዚ'' ባኣያታንቴ፦ «ታኣኒ ሓንጎ ዓሶፓ ባሼኬ» ጌይ ማላቶ ፔና ጌሻኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ፔቴ'' ፔቴ'' ዓሳ ፔ ማዾ'' ዛጊ ዔሮንጎ፤ ዬካፓ ፔኤሲ'' ሓንጎዋቶሲና ዎላ'' ሄካሲፆ ሃሺ'' ፔ ማዾ''ና ሌሊ ሄርሺንታንዳ ባኣዚ'' ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ዓይጎሮ ጌዔቴ ፔቴ'' ፔቴ''ሢ ፔ ኬዶ'' ኬዳንዳያ ኮይሳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ፆኦሲ ቃኣሎ'' ዔሪፆይዳ ዓኣሢ ዔርዛሢና ዎላ'' ኮሺ ማዔ ባኮ ዞርቲ ዔካያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ዒንሢ ዒ'ንሢ ጌሺፖቴ፤ ፆኦሲ ዓማሊ''ንታያቱዋሴ። ዓሲ ፔ ማዾ''ማ ዔካኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ፔ ሱኡኮ ማሊፆ ባኮ ማዻ ዓሲ ፔ ሱኡኮ ማሊፆይዳፓ ሓይቢ ዴንቃንዳኔ፤ ዓያና ዎዛሳኒ ማዻ ዓሢ ዓያናይዳፓ ናንጊና ናንጊ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","ኑ ማዾ'' ሃሺ''ባኣቶ ኮይሳ ዎዶ''ማና ኑ ማዼሢኮ ዓኣፖ ኑ ዔካንዳሢሮ ኮሺ ማዾ ማዺሢ ኑ ቤልፃዺባኣቴ ቃራኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ኑ ማዻንዳ ዎዴ ዴንቄቴ ዓሲም ቢያ ሃሣ ባሼና ኪሪስቶሴ ጉሙርቃ ዓሶም ኮሺ ማዾ ኑ ማዾም። ");
INSERT INTO mdybse_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ሓያ ዎማይዲ ታ ኩቻ ዓንዲርሲ ታ ዒንሢም ፃኣፔቴ ሂንዳ ዛጉዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","ዒንሢ ዓቲንቶ ቤርቶ ቲቂንታንዳጉዲ ዎልቄና ዓይሣዞንሢ ዙልካ ጴዻ ባኣዚ''ና ሄርሺንታዞንሢኬ፤ ዬያ ዔያታ ማዻሢ' ኪሪስቶሴኮ ሓይቦ''ና ሜታሢ ዛሎ'' ኬኤዛያ ማዔቴ ዳውሲንታንዳሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ዔያታ ዒንሢ ዓቲንቶ ቤርቶ ቲቂሾና ሄርሺንታኒ ማዓንዳኣፓዓቴም ዔያታ ቲቂንቴ ዓሳ ፔ ቶኦኪና ዎጋ'' ዓይሣ ጎይፆ ኩንሣያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ታኣኒ ዓጮ''ኮ ፑርቶ ማዻ''ፓ ዱማዺ፥ ዓጮ''ኮ ፑርቶ ማዻ'' ታጊዳፓ ዱማዺ ኪሪስቶሴና ዎላ'' ሓይቄ ሓይቦ''ይዳፓ ዓታዛ ሜሌ'' ታ ሄርሺንታ ባኣዚ'' ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ዓቲንቴ ቤርቲ ቲቂንቴቴያ ሓሼ''ቴያ ማኣዳ'' ባኣዚ'' ባኣሴ፤ ማኣዳ''ሢ ዓኪ ማዢንቲ ማዒሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","ሓኖ' ዓይሢፆ ጎይፆ ዓኣዻ ፆኦሲ ዴሮ''ም ቢያ ኮሹሞና ማኣሪሢና ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","ታኣኮ ዑፆይዳ ዓኣ ጳዺንቶ ዲኢዳ፡ ዬሱስ ኪሪስቶሴኮ ታ ዓይሌ'' ማዔሢ ዔርዛያታሢሮ ሓይፓ ሴካ ዖኦኒያ ታና ሜታሶፓ። ");
INSERT INTO mdybse_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","ታ ዒሾንሦ! ታ ሚሾንሦ! ኑ ጎዳሢ ዬሱስ ኪሪስቶሴኮ ኮሹሞ ዒንጊፃ ዒንሢ ዓያኖና ዎላ'' ማዖም፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ፆኦሲ ማሊሢና ዬሱስ ኪሪስቶሴ ማዾ''ም ዳኪንቴያ ማዔ፥ ጳውሎሴፓ ዬሱስ ኪሪስቶሴ ዛሎ''ና ጉሙርቂንታያ ማዔ፥ ዔፕሶኔይዳ ዓኣ ፆኦሲም ዱማዼዞንሢም፤ ");
INSERT INTO mdybse_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ኑ ዓዳሢ ኑኡኮ ፆኦዛሢና ኑ ጎዳ ዬሱስ ኪሪስቶሴኮ ኮሹሞ ዒንጊፆና ዎዞ''ና ዒንሢም ማዖም። ");
INSERT INTO mdybse_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ጫሪንጮይዳ ዓያኖ ዓንጆ ዒንጊሢና ኪሪስቶሴ ዛሎ''ና ኑና ዓንጄ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሴኮ ዓዶ ማዔ፥ ፆኦዛሢ ጋላቲንቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ፆኦሲም ኑ ዱማዼያ ሃሣ ቦሂሳ ባኣዚ'' ባኣያ ማዒ ዒዛ ቤርታ ኑ ጴዻንዳጉዲ፥ ዓጫ'' ማዢንቱዋንቴ ኪሪስቶሴ ዛሎ''ና ኑና ዒ ዶኦሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ፆኦሲኮ ናሹሞና ዒዛኮ ኮሺ ማሊሢ ማዔም ዬሱስ ኪሪስቶሴ ዛሎ''ና ዒዛኮ ኑ ናይ ማዓንዳጉዲ ቤርታዺ ዒ ማሌኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ዬያ ዒ ማዼሢ ፔኤኮ ዒ ናሽካ ናዓሢ ዛሎ''ና ጉሪ ኑም ዒንጊንቴ፥ ቦንቺንቴ ዒንጊፃ ጋላቲንታንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","ፆኦዛሢኮ ኮሹሞ ዒንጊፆ ሚርጉማፓ ዔቄያና ዒዛኮ ናዓሢ ሱጉፆና ኑ ጎማፓ ጌኤሽኪ፥ ጎሜፓ ማኣሪንቲሢያ ኑ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ፆኦሲ ፔኤኮ ኮሹሞ ዒንጊፆ ፔ ዔራቶና ፔ ማሊፆ ዳልጉሞና ሚርጊሺ ኑም ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ሓሣ ዒዚ ፔ ኮሹሞና ኪሪስቶሴ ዛሎ''ና ቤርታዺ ዒ ማሌ ጎይፆና ዒዛኮ ኮዦ ማሊፆኮ ዓኣሺንቴ ባኮ ኑና ዔርዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ፆኦሲ ማሊፃ ማዾይዳ ፔኤቃንዳሢ' ጫሪንጮና ሳዖናይዳ ዓኣ ባካ ቢያ ፔቱሞና ኪሪስቶሴ ቢታንቶ ዴማ'' ማዓኣናኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ቢያ ባኮ ፔ ማሊፆና ማዻ፥ ፆኦዛሢ ማሊፆ ጎይፆ ዒዛ ማሊፆ ጋራ ኑ ማዔሢሮ ሃሢ ኪሪስቶሴ ዛሎ''ና ኑ ዶኦሪንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ዬይ ያዺ ማዔሢ' ቤርታዺ ኪሪስቶሴይዳ ሃጊ ማዓንዳ ዎዛ ኑ ጌሤ ጎይፆና ኑ ዛሎ''ና ፆኦሲም ቦንቾና ጋላታና ማዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","ዒንሢያ ዒንሢኮ ዻቂንቶ ኮዦ ሃይሶ ማዔ፥ ጎኑሞ ቃኣሎ'' ዋይዜ ዎዶ''ና ኪሪስቶሴ ዒንሢ ጉሙርቄኔ፤ ዒዚያ ዒንሢም ዒንጋኒ ሃጊ ማዓንዳ ዎዛ ማሂ ጌሤ፥ ዓያኖ ዒንሢም ዒንጊፆና ዒንሢኮ ዒዛሮ ማዒፃ ዔርቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ፆኦሲ ቦንቺንቲ ጋላቲንታንዳጉዲ ዒዚ ፔኤም ማዔዞንሢ ጎሜ ዓይሉሞይዳፓ ኬሲ'' ዔካንዳያ ሄላ''ንዳኣና ዓያኖ ጌኤዣ ኑም ጊኢጊሾና ባኮ ዔኪሳኒ ዓይሢ ማሂ ዒንጎናያኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ዬያሮ ጎዳ ዬሱስ ኪሪስቶሴና ዓኣ ዒንሢኮ ጉሙርቂፆና ፆኦሲም ዱማዼዞንሢ ቢያ ዒንሢ ናሽካ ናሹሞና ታ ዋይዚ፥ ");
INSERT INTO mdybse_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ታኣኒ ሺኢቃ ዎዶ''ና ቢያ ዒንሢም ማሊ ማሊ ዒንሢ ዛሎ''ሮ ፆኦሲ ጋላቲፆ ሃሺ''ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ቦንቾ ኮይሳ፥ ኑ ጎዳሢ ዬሱስ ኪሪስቶሴኮ ዓዶ ማዔ፥ ፆኦዛሢ ኮሺ'' ዒንሢ ዔራንዳጉዲ ዔራቶና ዓኣሺንቴ ባኣዚ'' ዔርዛያ ማዔ፥ ዓያና ዒንሢም ዒንጊንታንዳጉዲ ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ዎዚጉዴ ሃጊ ማዓንዳ ዎዛም ዒንሢ ዔኤሊ''ንቴቴያ፥ ሃሣ ጌኤዦ ዓሳ ዔካንዳ ቦንቺንቴ ባካ ዎዚጉዲ ዺቤቴያ ዒንሢ ዔራኒ ዒና'' ዒንሢኮ ቡሊ''ንታንዳጉዲ ጌዒ ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ዬያጉዲ ሃሣ ኑና ኪሪስቶሴ ጉሙርቃዞንሢም ጊኢጊንቴ ዎልቃ ዎዚጉዲ ዶዲ ማዔቴያ ዒንሢ ዔራንዳጉዲ ታ ሺኢቃኔ፤ ዬያ ኑጊዳ'' ማዻ ፑኡፖ ዎልቆ፥ ");
INSERT INTO mdybse_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ፆኦሲ፥ ዓዳሢ፡ ኪሪስቶሴ ሓይባ''ፓ ዔቂሶና ጫሪንጮይዳ ፔኤኮ ሚዛቆ ዛላ'' ዴይሢፆና ኪሪስቶሴ ዛሎ''ና ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","ዒዚ ኪሪስቶሴ ጫሪንጫ፥ ፔኤኮ ሚዛቆ ዛላ'' ዴይሤሢ ዓይጎ ካኣታቶና ቢታንቶናኮ ዎልቁሞና ጎዳቱሞናኮዋ ዑፃሲኬ፤ ዬያጉዲ ሃያ ዓጫ'' ሌሊቱዋንቴ ሃጊ ሙካንዳ ዎዶ''ይዳኣ ሱ'ንሢፓ ቢያ ዑሣ ዓኣዼ ቦንቺንታ ሱ'ንሢ ዒዛም ጌሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ቢያ ባኣዚ'' ዒዛ ቢታንቶኮ ዴማ'' ማዓንዳጉዲ ማሄኔ፤ ሺኢጲፆ ማኣሮ ዓሶና ቢያ ባኣዚ''ኮዋ ዑፃ ማሂ፥ ዶኦሪ ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ሺኢጲፆ ማኣሮ ዓሳ ዒዛ ዑፆ ኩሙሢ ማሃያ ማዓዛ፥ ቢያ ባካ ዒዛና ኩሙሢ ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","ዒንሢ ዒንሢኮ ዻቢንቶና ጎሞ ዛሎ''ና ቤርታ ዓያኖ ናንጎ ዛሎ''ና ሓይቄያኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ዬያ ዎዶ''ና ሃያ ዓጮ''ኮ ፑርቶ ማዾ'' ማዺ ማዺ ዻቢንቲና ጎሜናይዳ ዒንሢ ናንጋያኬ፤ ዬያጉዲ ሃሣ ሳዖኮ ዑፃ፥ ዢባራ ዓኣ ፑርቶ ዓያኖ ዓይሣሢሲ፤ ሃሢያ ፆኦሲም ዓይሢንቱዋ ዓሶ ቆላሢሲ ዒንሢ ኩንሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ኑኡኒያ ቢያሢ ዬያ ዓሶ ባኣካ'' ኑኡኮ ዓሱሞ ማሊፆ፥ ዒኖሲ ኩንሢ ኩንሢ ሃያኮ ቤርታ ኑም ኮይሳ ጎይሢ ኑ ናንጋኔ፤ ሃሣ ዓቴ'' ዬያ ዓሶጉዲ ኑ ሾይንታፓ ዓርቃዖ ፆኦሲ ዻጋሳ ዓሲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ጋዓንቴ ማኣሪፆና ዖርጎቺ ማዔ ፆኦዛሢ ኑና ዒ ናሽኬ፥ ዼኤፖ ናሹማፓ ዔቄያና፥ ");
INSERT INTO mdybse_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ዎዚ ኑ ዻቢንቶና ሓይቄያ ማዔቴያ ኪሪስቶሴና ናንጊ ኑም ፆኦሲ ዒንጌኔ፤ ዒንሢያ ዻቄሢ ዒዛኮ ኮሹሞ ዒንጊፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ፆኦሲ ዬሱስ ኪሪስቶሴና ዎላ'' ኑና ሃይባ''ፓ ዔቂሲ፥ ዬሱሴና ዎላ'' ጫሪንጫ ዒ ዓኣ ቤዛ ኑና ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ዬያ ዒ ማዼሢ' ሙካ ዎዶ''ይዳ ዬሱስ ኪሪስቶሴ ዛሎ''ና ፔ ኮሹሞና ኑም ፔጋሲ ዻዋ ኮሹሞ ዒንጊፆ ሚርጉሞ ዔርዛኒ ኮዒኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","ዓይጎሮ ጌዔቴ ዒንሢ ዻቄሢ ጉሙርቂሢና ፆኦሲኮ ኮሹሞ ዒንጊፆ ዛሎ''ናኬ፤ ዬይ ፆኦሲ ዒንጊሢ ማዓንዳኣፓዓቴም ዒንሢ ማዾና ጴዼያቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ሓይ ዻቂንታ ጴዼሢ ማዾናቱዋኣሢሮ ዓይጎ ዓሲያ ሄርሺንታኒ ኮይሱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ዓይጎሮ ጌዔቴ ኑኡኒ ቤርታዺ ፆኦሲ ጊኢጊሼ፥ ኮዦ ማዾ'' ማዻንዳጉዲ ዬሱስ ኪሪስቶሴ ዛሎ''ና ማዢንቴ ፆኦሲ ማዢንቲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ዬያሮ ዒንሢ ቤርታ ሾይንቶና ዓይሁዴ ማዒባኣ ዓሳ፡ ዓይሁዶ ዓሳ ዔያቶኮ ዓቲንቶ ቤርቶ ዓሲ ቲቄያታንቴ ሄርሺንቲ ሄርሺንቲ፦ «ዒንሢ ዓቲንቶ ቤርቶ ቲቂንቲባኣዞንሢ ሓይ!» ዒንሢ ጋዓሢ ማሉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","ዬኖ ዎዶ''ና ዒንሢ ዒስራዔኤሌ ዜርሢ ጌይንቱዋዖ ሃሣ ቤርታ ዔያቶም ጫኣቆና ጫኣቁሞኮ ዙላ'' ማዒ፥ ሃያ ዓጮ''ይዳ ሃጊ ማዓ ዎዛ ባኣያ ማዒ ጊንሣ ፆኦሲዳፓኣ ዱማዺ ኪሪስቶሴያ ዔሩዋዖ ዒንሢ ናንጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ሓሢ ጋዓንቴ ቤርታ ዒንሢ ሃኪ ዓኣ ዓሳ ዬሱስ ኪሪስቶሴ ዛሎ''ና፤ ሓሣ ዒዛኮ ሱጉፆና ፆኦሲ ባንሢ ዒንሢ ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","ቤርታ ኑና ፓቂ ዎላ'' ካኣሞ ላኣጌ ባኮ ሺኢሺ፥ ዓይሁዶና ዓይሁዴ ማዒባኣ ዓሶና ፔቴ'' ማሂ ቡኩሴሢ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ኮሹሞ ዒንጋኒ ላምዖ ዴሮ''ይዳፓ ዒዛና ፔቴ'' ማዓ፥ ፔቴ'' ዓኪ ዜርሢ ማሂ ማዣኒ ዎጎኮ ዓይሢፆና ማዾ ጎይፆና ፔ ሃይቦ''ና ባይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ኪሪስቶሴ ፑርቶ ዓሶ ሱፆ ሚፆይዳ ሓይቂ፥ ዎላ'' ካኣሙዋ ዓሶዋ ካንሢ ላምዖ ዜርፆ ፔቴ'' ማሂ ፆኦሲና ዎላ'' ቡኩሴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ዒዚ ሙኪ ዒንሢ ፆኦሲፓ ሃኪ ዓኣ ዓሶና ዑኬ ዓኣ ዓይሁዶ ዓሶናም ኮሹሞ ዛላ ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","ዬያሮ ኑኡኒ ቢያሢ ዒዛ ዛሎ''ና ፔቴ'' ዓያናና ማዒ ዓዳሢ ባንሢ ሙካኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ዓካሪ ዒንሢ፡ ፆኦሲም ዱማዼዞንሢና ዎላ'' ፔቴ'' ዓጪ ዓሲ፤ ሃሣ ፆኦሲ ማኣሪ ዓሲ ማዓንዳኣፓዓቴም ሃካፓ ሴካ ዒንሢ ሾኦቺና ቤቲ ሙኬ ዓሲናቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ፆኦሲ ማዾ''ም ዳኪንቴዞንሢና ፆኦሲ ማሊፆ ኬኤዛ ዓሳ ዓርቄ ቦኦኮላሢዳ ዒንሢ ማዢንቴኔ፤ ማኣሮኮዋ ሄሎ ማዔ ሹጫሢ ዬሱስ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ማኣሮ ማዦ ባካ ቢያ ዒዛና ካኣሚ ካኣሚ ጎዳም ዱማዼ ጌኤሺ ማኣሪ ማዓኒ ማዢንታኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","ፆኦሲ ፔ ዓያኖና ዎርቃ ማኣሪ ማዓንዳጉዲ ኪሪስቶሴ ዒንሢያ ማዣኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ዬያሮ፡ ዒንሢ፥ ዓይሁዴ ማዒባኣ ዓሶም ዬሱስ ኪሪስቶሴ ዛሎ''ና ማዻሢሮ ቱኡቲ ዓኣ፥ ታኣኒ ጳውሎሴ' ፆኦሲ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ዒንሢም ታ ማኣዳ''ንዳ ማዾ'' ኮሹሞ ዒንጊፆና ፆኦሲ ታኣም ዒንጌሢ ዒንሢ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","ቤርታ ታ ዒንሢም ዻካ''ና ፃኣፔሢጉዲ ፆኦሲ ዓኣሺንቴ ባኣዚ'' ታና ፔጋሲ ዻዌኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ሃሢ ታ ዒንሢም ፃኣፔሢ ዒንሢ ናባቤቶ ኪሪስቶሴ ዛሎ'' ዓኣሺንቴ ባኮ ታ ዔሬያ ማዔሢ ዒንሢም ጴዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ዬይ ዓኣሺንቴ ባካ ፆኦሲ ዓያኖ ዛሎ''ና ፆኦሲም ዱማዼ፥ ዒዛ ማዾ''ም ዳኪንቴዞንሢና ዒዛኮ ማሊፆ ኬኤዛዞንሢም ሃሢ ጴዼ ጎይፆ ሚናኣ ዎዶ''ና ዓኣ ዓሶም ጴዺባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ዬይያ፦ ኮዦ ሃይሶ ዛሎ''ና ዓይሁዴ ማዒባኣ ዓሳ ዓይሁዶ ዓሶና ዎላ'' ፆኦሲ ዒንጋ ዓንጆ ዔካያ፥ ፔቴ'' ዑሢኮ ዱማ ዱማ ቤዞጉዲ ማዓያ ሃሣ ፆኦሲ ዬሱስ ኪሪስቶሴ ዛሎ''ና ዒንጌ ሃጊ ማዓንዳ ዎዞ'' ዎላ'' ዔካያ ማዔሢ ዔያቶም ጴዺባኣሴ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","ፆኦሲ ፔ ዎልቆና ማዻ ጎይፆ ታኣም ዒንጌ ኮሹሞ ዒንጊፆና ሓያ ኮዦ ሃይሶ ማዾ'' ታ ማዻያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ዎዚ ታኣኒ ፆኦሲም ዱማዼ ዓሶይዳፓ ላኣፓ ማዔቴያ ዛጳባኣ ኪሪስቶሴኮ ዖርጎቹሞ ዓይሁዴ ማዒባኣ ዓሶም ታ ኬኤዛንዳጉዲ ሃይ ኮሹሞ ዒንጊፆ ማዻ'' ታኣም ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ዬያጉዲ ሃሣ ቢያ ባኮ ማዤ ፆኦዛሢ' ሓያኮ ቤርታኣ ዎዶ''ይዳ ዓኣቺ ጌሢ ዓኣ ዒዛኮ ማሊፃ ዓይጎ ማዔቴያ ቢያሢም ታ ዔርዛንዳጉዲ ሃይ ኮሹሞ ዒንጊፆ ማዻ'' ታኣም ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ዬይ ማዔሢ' ሓሣኣ ዎዶ'' ሺኢጲፆ ማኣሮ ዓሶ ዛሎ''ና ጫሪንጫ ዓኣ ሱኡጎና ቢታንታ ዓኣ ማዢንቶና ፆኦሲኮ ዔራቶዋ ዱማ ዱማ ጎይሢና ዔራንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ኑ ጎዳ፥ ዬሱስ ኪሪቶስቶሴ ዛሎ''ና ፆኦሲ ዬያ ማዼሢ ቤርታፓ ዓርቃዖ ማዻኒ ማሌ ጎይፆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ኪሪስቶሴ ኑ ጉሙርቄ ጎይፆና ፆኦሲ ቤርቶ ዒጊቹሞ ባኣያ ዶዲ ኪሪስቶሴና ኑ ሙካኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ዬያሮ ሓይ ታና ዒንሢ ዛሎ''ሮ ሄሌ'' ሜታሢ' ዒንሢኮ ቦንቾ ማዔሢሮ ሃጋኣ ዎዛ ባኣያ ዒንሢ ማዑዋጉዲ ታ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ዓካሪ ፆኦሲ፥ ዓዳሢ ቤርታ ጉምዓቲ ታ ሺኢቃሢ ዬያ ዛሎ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ጫሪንጮና ሳዖናይዳ ዓኣ ፔቴ'' ማኣሮ ዓሳ ሱ'ንፆ ዴንቃንዳሢ ፆኦሲዳፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ዒንሢኮ ጋሮ ዒኖ ዶዲሻ ዎልቄ፥ ዓያኖ ዛሎ''ና ፆኦሲ ፔኤኮ ቦንቾ ዼኤፑማፓ ዒንሢም ዒንጋንዳጉዲ ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ዬያጉዲ ሃሣ ዒንሢኮ ጉሙርቂፆና ኪሪስቶሴ ዒንሢ ዒና'' ናንጋንዳጉዲ፤ ሃሣ ዒንሢኮ ፃጶና ዓይፆና ናሹሞና ዶዲ ማዓንዳጉዲ ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ሃሣ ጊንሣ ኪሪስቶሴ ናሹሞኮ ዳልጉሞ፥ ዖዶሱሞ፥ ዼ'ጉሞ፥ ሊካ ዔታዺፃኣ ዎማዒታቴ ፆኦሲም ዱማዼዞንሢንታ ቢያ ዒንሢ ዔራንዳጉዲና፥ ");
INSERT INTO mdybse_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","ዔርታያፓ ዑሣ ዓኣዼ ማዔ፥ ኪሪስቶሴኮ ናሹሞ ዒንሢ ዔራንዳጉዲና ፆኦሲ ፓጬ ባኣዚ'' ባኣያ ማዔሢጉዲ ዒንሢያ ያዺ ማዓንዳጉዲ ፆኦሲ ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ዬያሮ ኑጊዳ ማዻ ዎልቆ ዛሎ''ና ኑ ሺኢቃሢና ማላሢናይዳፓ ዑሣ ዓኣዼ ማዻኒ ዳንዳዓ ፆኦዛሢም፥ ");
INSERT INTO mdybse_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ሺኢጲፆ ማኣሮ ዓሶና ዬሱስ ኪሪስቶሴ ዛሎ''ና ዎዶ'' ቢያይዳ ቦንቾ ዒዛም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ዓካሪ ፆኦሲ ዒንሢ ናንጎንጎ ጌዒ ዔኤሌ'' ናንጎ ዒንሢ ናንጋንዳጉዲ ጎዳ ማዾ'' ዛሎ''ሮ ቱኪ''ንቲ ዓኣሢ፥ ታኣኒ ዒንሢ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ቢያ ዎዴ ሴካና ሃንጋና ዎሊ ናሽኪሢና ሃሣ ሚጪንቲሢና ኮሹሞና ዳንዳዒሢና ዓኣያ ማዒ ናንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ኮሹሞና ናንጊ ናንጊ ዓያኖ ጌኤዦ ዛሎ''ና ጴዻ ፔቱሞ ናንጎ ዶዲ ካፑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","ዒንሢ ፔቴ'' ሃጊ ማዓ ዎዛም ዔኤሊ''ንቴያ ማዔሢጉዲ ፔቴ'' ዑሢና ፔቴ'' ዓያናና ዒንሢኮ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ዬያጉዲ ሓሣ ፔቴ'' ጎዳ፥ ፔቴ'' ጉሙርቂሢና ፔቴ'' ዋኣሢ ማስቲሢና ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ሃሣ ዬያ ቢያይዳፓ ዑሣ ማዔ፥ ቢያሢና ማዻ፥ ቢያሢና ናንጋ፥ ቢያሢኮ ዓዶ ማዔ፥ ፔቴ'' ፆኦሲ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ጋዓንቴ ኪሪስቶሴ ዒንጋኒ ማሌ ጎይፆ ኑና ፔቴ'' ፔቴ''ሢም ፆኦሲኮ ኮሹሞና ዒንጎ ዒንጊፃ ዒንጊንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ዬይያ፦ «ሌካ ዒ ኬስኬ ዎዶ''ና ሚርጌ ዓሲ ዲዒ ዔኪ ዒ ዓኣዼኔ፤ ሚርጌ ዓሲማኣ ሚርጌ ዒንጊሢ ዒንጌኔ» ጌይንቴሢ ጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ዓካሪ «ሌካ ኬስኬኔ» ጌይፃ ሊካ ሳዖ ዴሞ'' ኬዴ''ያ ማዒባኣያታቴ ሜሌ'' ዓይጎ ዻዋይ? ");
INSERT INTO mdybse_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ዬይ ሊካ ዴሞ'' ኬዴ''ሢ ሳዖና ጫሪንጮና ዒኢካ ዓኣ ባኮ ቢያናይዳ ጴዻያ ማዓኒ ጫሪንጮኮ ቢያ ዑፆ ኬስኬሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ዒዚ ፔቴ'' ፔቴ''ሢ ፆኦሲ ማዾ''ም ዳኪንቴዞንሢ፥ ፆኦሲ ማሊፆ ኬኤዛዞንሢ፥ ኮዦ ሓይሶ ኬኤዛዞንሢ፥ ፆኦሲ ዓሶ ሄንቃዞንሢና ዔርዛዞንሢ ማዓንዳጉዲ ዒንጊሢ ዒንጌኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ዬያ ዒ ማዼሢ ዒዛኮ ዑፆ ማዔ፥ ሺኢጲፆ ማኣሮ ዓሶ ዲቻኒና ዒዛ ጉሙርቃ ዓሶ ፆኦሲ ዓሲ' ማዻ ማዾ ማዻንዳጉዲ ጊኢጊሻኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ዬያጉዲ ሃሣ ፆኦሲ ናዓሢ ጉሙርቂሢና ዔሪሢ ዛላና ጴዻ ፔቱሞ ዴንቂ፥ ኪሪስቶሴ ፓጬ ባኣዚ'' ባኣያ ኩሙሢ ማዔሢጉዲ ኑኡኒ ኩሙሢ ዓሲ ማዓንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ዓካሪ ሃካፓ ሴካ ዓሶኮ ዻቢሻ ጌሺፆ ዔርዚፆ ዢባሮና ሴካ ሃንጋ ጌዒ ጌዒ ናይ ኑ ማዓዓኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ዬያይዳፓ ጎኑሞ ናሹሞ ዓያናና ጌስቲ ጌስቲ ቶኦካ''ሢ ማዔ፥ ኪሪስቶሴ ማላኒ ቢያና ኑ ዲዲጫንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ዑፆኮ ዱማ ዱማ ዓኣ ቤዛ ካኣማሢ ኪሪስቶሴናኬ፤ ዑፃ ቢያ ዎላ'' ዓርቂንቲ ዓኣሢ ዱማ ዱማ ካኣማ ካራናኬ፤ ዬያሮ ፔቴ'' ፔቴ'' ዑፆኮ ቤዛ ፔኤም ዒንጊንቴ ማዾ'' ማዻዛ፥ ዑፃ ቢያ ናሹሞና ዲጪ ዲጪ ዼኤፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","«ሓይፓ ሴካ ፓሡዋ ማሊሢና ናንጋ፥ ዓይሁዴ ማዒባኣ ዓሶጉዲ ናንጊፖቴ» ጌዒ ጎዳ ሱ'ንፆና ታ ዒንሢም ላቲ'' ዞራኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ዔያቶኮ ዒኖ ባይቂፆይዳፓ ዔቄያና ዔያታ ጶቂሡዋኣሢሮ ዒና'' ዔያቶኮ ዹሜኔ፤ ፆኦሲ ዒንጋ ናንጎይዳፓኣ ዔያታ ሃኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","«ዓሲ ዎዚ ጋዓንዳይ» ጋዓ ማሊሢ ዔያቶኮ ባይቄሢሮ ፔና ፑርታ ማዾም ዓኣሢ ዒንጌኔ፤ ዬያሮ ቢያ ዎዴ ቦርሲሳ ባኣዚ'' ማዻኒ ኮሺ'' ዔያታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ዒንሢ ጋዓንቴ ኪሪስቶሴ ዛሎ''ና ዔሬሢ ያዺቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ጎኔና ዒንሢ ዒዛ ዛሎ'' ዋይዜኔ፤ ጎኑሞ ዬሱሴና ዓኣሢያ ዒዛይዳፓ ዒንሢ ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ዬያሮ ጌሺ ዒንሢ ጎሜ ባንሢ ዔኪ ዓኣዻ ማሊፆና ፑርቴያ፥ ሚና ቤርታ ዒንሢ ናንጋ ናንጎ ሃሹ''ዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ዒና'' ዒንሢኮ ላኣሚንቲ ዓኪ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ጎኔ ፂሉ''ሞና ፆኦሲም ዱማዺሢና ፆኦሲ ማላኒ ማዢንቴ ዓኪ ዓሲ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ዬያሮ ሉኡዙሞ ጌስቲፖቴ! ቢያሢ ኑኡኒ ፔቴ'' ዑሢኮ ዱማ ዱማ ቤሲ ማዔሢሮ ሴካና ሃንጋና ጎኑሞ ኑ ጌስቶም። ");
INSERT INTO mdybse_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ዒንሢ ዻጋዼያ ማዔቴያ ጎሜ ማዓንዳ ጎይሢ ዔኪ ዓኣዺፖቴ፤ ዻጎ ዒንሢኮ ዒንሢ ሃሹ''ዋንቴ ዓቢ ጌሎፓ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ሃሣ ፃላሄማኣ ቤሲ ጌሢፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ዉኡቃያ ዓኣቴ ሃይፓ ሴካ ዉኡቆፓ፤ ዬያይዳፓ ሜታዼ ዓሲያ ማኣዳ''ንዳ ሚኢሼ ዴንቃኒ ፔ ኩቻ ዶዲ ማማዾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ፔቴ''ታዖ ዒንሢኮ ዻንጋፓ ፑርታ ዑኡሲ ኬስኮፓ፤ ጋዓንቴ ዓሲ ዶዲሻያና ፓሣ ባኣዚ''ና ጌስቱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ዒንሢ ጋፒ ዓይላ''ቶፓ ሻንቂንቲ ኬስካንዳ ኬሎ'' ጎናሲ ዔርዛኒ ፆኦሲ ዒንሢም ዒንጌ፥ ጌኤዦ ዓያኖ ዖዪሲፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ዒንሢዳፓ ፑርቱሞ ማሊሢ፥ ዻጋ፥ ጎሪ''ንቲ፥ ዒላቲ''፥ ጫሺንታ ዓይጌያ ፑርታ ባኣዚ'' ቢያ ሃኮንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","ዎላ'' ሴካና ሃንጋና ኮሺ ዓሲ ሃሣ ዎሊም ማላ ዓሲና ማዑዋቴ፤ ፆኦሲ' ኪሪስቶሴ ዛሎ''ና ዒንሢም ዓቶም ጌዔሢጉዲ ዒንሢያ ዎሊም ዓቶም ጋዓያ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ዓካሪ ዒንሢ ፆኦሲ ዒ'ንሢ ናሽካያ፥ ዒዛኮ ናኣቶ'' ማዔሢሮ ዒዛ ማሉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ኪሪስቶሴ ኑና ናሽኬሢና ፆኦሲ ዎዛሳ ሳውሞ ዓኣ ዒንጎ ባኣዚ'' ማሂ ፔ ሼምፓሢ ኑ ጋይቴ ዓኣሢ ዒንጌሢጉዲ ዒንሢያ ናሹሞና ናንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ማቾ ሃሣ ዓኒ ማዒባኣያና ላሂሢ፥ ቦርሲሳ ማዾ፥ ዓሲሮ ዛጊ ሱኡካዺሢ ማዔቴያ ዒንሢ ባኣካ'' ጴዾፓ፤ ዬይ ጌኤሺ ማዔ፥ ፆኦዛሢ ዴሬም ኮይሳ ማዾቱዋሴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ዒንሢ ፆኦሲ ጋላታንዳኣፓዓቴም ቦርሲሳ ባኣዚ''ና ፓሣ ባኣዚ''ባኣ ጊኢጉዋ ሃይሴ ጌስታንዳያ ኮይሱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ማቾ ሃሣ ዓኒ ማዒባኣያና ላሃያኮ፥ ቦርሲሳ ማዾ ማዻያኮ፥ ሜሌ'' ካኣሺ ካኣሽኪሢጉዲ ዓሲሮ ዛጊ ሱኡካዻ ዓሲኮ ኪሪስቶሴና ፆኦሲ ካኣቱሞናይዳ ቤሲባኣያ ማዓንዳሢ ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ዬንሢ ባኮንሢ ዛሎ''ና ፆኦሲም ዓይሢንቱዋ ዓሶ ዑፃ ዒዛኮ ጎሪ''ንቲ ሙካንዳሢሮ ዖኦኒያ ዒንሢ ጉሪ ማዔ ሃይሴና ጌሾፓ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ዬያሮ ዬንሢ፥ ዒዛም ዓይሢንቱዋ ዓሶና ዎላ'' ፔቴ'' ማዒፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ቤርታ ዒንሢ ዹሚዳ ናንጋኔ፤ ሃሢ ጋዓንቴ ጎዳና ፖዓ ዒንሢ ዓኣሢሮ ፖዖ ዓሳ ናንጋ ጎይፆ ናንጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ዓይጎሮ ጌዔቴ ኮሹሞ ቢያ፤ ፂሉ''ሞንታ ጎኑሞንታኮዋ ዓኣፒ ጴዻሢ ፖዒዳፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ዬያሮ ጎዳ ዎዛሳያ ማዓ ባካ ዓይጎታቴያ ዱማሲ ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ዓኣፒባኣ ዹሞ ማዾ'' ዒንሢያ ማዻያ ማዒፖቴ፤ ፖዓ ኬሲ'' ፔጋሲ ዻውዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ዹሞ ማዾ'' ማዻ ዓሳ ዓኣቺ ማዻ ባኮ ዛሎ'' ኬኤዛኒታዖ ቦርሳያኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ቢያ ባኣዚ'' ፖዒዳ ኬስካዛ ዬይ ዓይጎ ማዔቴያ ጌኤሽኪ ዔርታኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","ዎይቲ ጌዔቴ ቢያ ባኣዚ'' ፔጋሲ ዻዋሢ ፖዒታሢሮኬ፤ ዬያሮ፦ «ኔኤኒ ሃይ ጊንዓሦ ጴጬ! ሓይባ''ፓ ዔቄ! ኪሪስቶሴ ኔኤም ፖዓንዳኔ» ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ዓካሪ ዒንሢ ዎማይዲ ናንጋንዳቴያ ኮሺ'' ማሉዋቴ፤ ዔራ ዓሲ ማዑዋቴ፤ ዔኤያ ዓሲ ጎይሢ ናንጊፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ሓይ ዎዳ'' ፑርታ ማዔሢሮ ዓይጎ ካራና ማዔቴያ ዒንሢ ዴንቄ ዎዶ''ማና ማዻ ባኮ ዔሪ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ዬያሮ ጎዳኮ ማሊፃ ዓይጎታቴያ ዔራያ ማዑዋቴ፤ ዔኤያ ማዒፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ዒንሢ ባይሲንታ ባንሢ ዔኪ ዓኣዻያታሢሮ ዳጋሢ ዑሺና ማሢንቲፖቴ፤ ዬያይዳፓ ዓያና ጌኤሺ ቢታንቶ ዴሞ ጌላያ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ፆኦሲም ማዓ ዓይኑሞና ፆኦሲ ሄርሺ ሄርሺ ዒንሢ ዎላ'' ቡኬ ዎዶ''ና ዓይናዹዋቴ፤ ዬያይዲ ዒኔፓ ጎዳ ጋላቱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ኑ ጎዳሢ ዬሱስ ኪሪስቶሴ ሱንፆና ቢያ ባኣዚ''ሮ ፆኦሲ፥ ዓዳሢ ቢያ ዎዴ ጋላቱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ኪሪስቶሴ ቦንቾሮ ጌዒ ዒንሢ ፔቴ'' ፔቴ''ሢ ዎሊም ዓይሢንታያ ማዑዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ዒንሢ፥ ላኣሎ ናኣታ! ጎዳ ዬሱሴም ዒንሢ ዓይሢንታሢጉዲ ዒንሢኮ ዓኒንሢም ዓይሢንቱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ዓይጎሮ ጌዔቴ ኪሪስቶሴ ሺኢጲፆ ማኣሮ ዓሶኮ ዑፃ ቶኦኪ ማዔሢጉዲ ዓኒያ ማቾኮ ቶኦኪኬ፤ ዬያጉዲ ኪሪስቶሴ ፔኤኮ ዑፆ ማዔ፥ ሺኢጲፆ ማኣሮ ዓሶ ዻቂሻሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ሺኢጲፆ ማኣሮ ዓሳ ኪሪስቶሴም ዓይሢንታሢጉዲ ማቾንሢ ቢያ ባኣዚ''ና ፔ ዓኒንሢም ዓይሢንቶንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","ዒንሢ፥ ዓቲንቃ! ኪሪስቶሴ ሺኢጲፆ ማኣሮ ዓሶ ናሽኬሢና ፔ ቶኦኮ''ዋ ዔያቶ ጋቴ ሃይቢም ዓኣሢ ዒንጌሢጉዲ ዒንሢያ ዒንሢ ላኣሎ ናሽኩዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ኪሪስቶሴ ዬያ ማዼሢ' ሺኢጲፆ ማኣሮ ዓሳ ፆኦሲም ዱማዼያ ማዓንዳጉዲ ጌይኬ፤ ዒ ዔያቶ ፆኦሲም ዱማሴሢያ ቃኣሎ'' ዛሎ''ና ሓሣ ዋኣሢናኣ ማስኪ ጌኤሺ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ዬያይዲ፦ ኪንሢ፥ ዓኣፒ ካራ ቱኪ''ሢ፥ ፑርታ ባኣዚ''ያ ፔቴ''ታዖ ባኣያ፥ ጌኤሺ፤ ሃሣ ሚዛጲ ሺኢጲሢ ማኣሪ ዓሲ ማሂ ፔ ቤርቶ ዒንሢ ዒ ሺኢሻኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ዓኒንሢ ፔና ናሽካሢጉዴያ ፔ ማቾንሢ ናሽካኒ ኮይሳኔ፤ ፔ ማቾ ናሽካሢ ፔና ናሽካኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ዎይቲ ጌዔቴ ፔና ዒፃ ዓሲ ዖኦኒያ ባኣሴ፤ ጋዓንቴ ኪሪስቶሴ ሺኢጲፆ ማኣሮ ዓሶ ሙኡዚ'' ሙኡዚ'' ካፓ ጎይፆ ዒዚ ሙኡዚ'' ሙዒ ሙዒ ፔናኣ ካፓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ኑኡኒ ኪሪስቶሴ ዑፆኮ ዱማ ዱማ ቤዞኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","«ዓሲ ዬያሮ ዓዶና ዒንዶና ሃሺ'' ማቾና ዎላ'' ፔቴ'' ማዓኔ፤ ላምዖንሢያ ፔቴ'' ዓሲ ዑሢጉዲ ማዓኔ» ጌይንቴኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ዬይ ዼኤፒ ዓኣሺንቴ ባኣዚ''ኬ፤ ሓያ ታ ጋዓሢ' ኪሪስቶሴና ሺኢጲፆ ማኣሮ ዓሶና ማላታ ማሂኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ጋዓንቴ ሓይ ባካ ዒንሢማ ማዓያኬ፤ ዬያሮ ዓኒ ፔ ማቾ ፔናጉዲ ማሂ ናሽኮንጎ፤ ማቻኣ ዓኒ ቦንቾንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ናይዮቴ! ጎዳ ዬሱሴሮ ዒንሢ ማዔ ጎይፆና ዒንሢ ሾዔ ዓሶም ዓይሢንቱዋቴ፤ ዓይጎሮ ጌዔቴ ዬይ ባካ ኮይሳያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«ኔ ዓዶና ኔ ዒንዶና ቦንቼ» ጋዓ ቤርታኣ ዓይሢፆይዳ ዓኣ ሃጊ ማዓ ዎዛ''፥ ");
INSERT INTO mdybse_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","«ቢያ ባኣዚ'' ኔኤም ኮሽካንዳኔ፤ ናንጎ ሌዓኣ ሳዓ ኔኤም ዖዶቃንዳኔ» ጋዓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","ዒንሢ ሾዔ ዓሳ! ጎዳ ዬሱስ ኪሪስቶሴ ዓይሣ ዓይሢፆ ጎይፆ ዞሪ ዲቹዋቴ፤ ናኣቶ'' ዒንሢኮ ጎሪ'' ዻጋሲሢና ፑርቱሞ ማሊሲሲፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","ዓሲም ዓይሌ'' ማዒ ማዻዞንሢዮቴ! ዒንሢ ማዺሻያ ማዔ ዓሶም ዒጊቹሞና ቦንቺ ዓይሢንቱዋቴ፤ ኪሪስቶሴም ዒንሢ ማዻ ጎይፆ ፒዜ ዒናና ዓይሢንቱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","ዒንሢ ዓይሢንታንዳሢያ ፆኦሲ ማሊፆ ዒናፓ ኩንሣ፥ ኪሪስቶሴም ማዻ ዓሶጉዲ ማዓንዳኣፓዓቴም ዓሲ ዎዛሳኒ ጌዒ ዓሲ ቤርቲም ጴዺሢሮ ማዖፓ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","ዓሲም ማዒባኣንቴ ጎዳ ዬሱስ ኪሪስቶሴም ማዻያ ማዒ ናሽኪ ኮሺ ማሊሢና ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","ዓይጎሮ ጌዔቴ ዓይላ''ሢ ማዔቴያ ማዺሻሢ ፔቴ'' ፔቴ''ሢ ማዼ ኮዦ ማዾ''ሮ ጎዳ ዬሱሴ ኮይላ''ፓ ዒንጊንታ ባኣዚ'' ዔካንዳያ ማዔሢ ዒንሢ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ሃሣ ዒንሢ ዓሶ ማዺሻ ዓሳ! ዓሲ ዱማሱዋ፥ ዒንሢንታ ዔያቶንታኮ ጎዳ ጫሪንጮይዳ ዓኣሢ ዔሪ ዔያቶ ዲቃሢፆ ሃሺ''ጋፓ ዒንሢም ማዻ ዓሶም ኮሺ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ዓካሪ ጎዳና ዒዛኮ ዼኤፖ ዎልቆና ዶዱዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ፃላሄኮ ጌኖ'' ማዾ'' ዒንሢ ባሻኒ ዳንዳዓንዳጉዲ ፆኦሲ ዒንጋ ዖሎ ዓንጋሞ ቢያ ዓርቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ዓይጎሮ ጌዔቴ ኑኡኮ ዖላ ዓሲናቱዋንቴ ሃያ ዹሞ ዓጮ'' ዎይሣ፥ ቢቶ'' ማዔያ፤ ሃሣ ሃያ ዓጮ''ኮ ዎልቆ ማዔያ፥ ሳዖ ዑፃ ዢባራ ዓኣ ፑርቶ ዓያኖናኬ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ዬያሮ ፆኦሲ ዒንጋ ዖሎ ዓንጋሞ ጉቤ ዓርቁዋቴ! ዬያይዲ ፑርታ ኬሊ'' ዒንሢ ሄላ''ኣና ዒንሢ ሞርካሢኮ ዎልቆ ቃዚ ጋፒንፆ ሄላ''ኒ ዖሌስካፓ ዶዲ ዒንሢ ዔቃኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","ዓካሪ ፂኢቶ ዓርቃ ቡራሾጉዲ ጎኑሞ ኬርና ቱኡቲ፥ ፂሉ''ሞዋ ዖሎሮ ዳዳ ማኣዖ ዓንጎጉዲ ማይንቲ፥ ");
INSERT INTO mdybse_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ኮዦ ሃይሶ ቃኣሎ'' ቶካ ዱርሲጉዲ ዓኣሢ፥ ጊኢጊ ዔቁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ሃሣ ታሚ ሎስቶጉዲ ዔኤታ፥ ፃላሄኮ ፓልዖ ሜንሣኒ ዳንዳዓንዳጉዲ ቢያፓ ዑሣ ማዔ ጉሙርቂፆ ጊቲማ ማሂ ዓርቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ዬያጉዲ ሃሣ ዻቂንቶ' ቶኦካ ዓጎ ዖሎ ዓንጎ ቆኦቦ''ጉዲ ዓጊ፥ ፆኦሲኮ ቃኣሎ''ዋ ዓያና ጌኤሺ ጬንቻ ዓፓሮ ማሂ ዓርቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ዒንሢም ኮይሳ ባኮ ቢያ ዒንሢ ሺኢቃኣና ዓያና ጌኤሺና ቢያ ዎዴ ሺኢቁዋቴ፤ ዬያይዲ ዶዲ ጴጩዋቴ፤ ኪሪስቶሴ ጉሙርቃ ዓሶማኣ ቢያ ዋሉ''ዋዖ ሺኢቁዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ኮዦ ሃይሶኮ ዓኣሺንቴ ባኮ ዒጊጩዋዖ ታኣኒ ዓሶ ዔርዛንዳጉዲ፤ ሃሣ ታ ኬኤዛ ዎዶ''ና ኮይሳ ቃኣላ ታኣም ዒንጊንታንዳጉዲ ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ሃሢያ ታ ካኖ ቢራቶና ቱኡቲ ዓኣዖ ዬያ ኮዦ ሃይሶኮ ታኣኒ ኪኢታ ዓሲኬ፤ ዬያሮ ታኣም ኮይሳሢጉዲ ዒጊጩዋዖ ታኣኒ ኬኤዛንዳጉዲ ሺኢቁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ኑ ዒዛ ናሽካ፥ ኑኡኮ ዒሻሢ፥ ጎዳ ዬሱስ ኪሪስቶሴ ማዾ'' ጉሙርቂንቲ ማዻያ ማዔሢ፥ ቲኪቆሴ ታ ዛሎ''፤ ሃሣ ታ ዓይጎ ማዻቴያ ዒንሢ ዋይዛንዳጉዲ ቢያ ባኮ ዒንሢም ዒ ኬኤዛንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ዬያሮ ኑኡኒ ዎይቲ ዓኣቴያ ዒንሢ ዔራንዳጉዲና ዒንሢያ ዒ ዶዲሻንዳጉዲ ጌዒ ዒዛ ታ ዒንሢ ኮይላ'' ዳኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ፆኦሲ፥ ዓዳሢና ጎዳ ዬሱስ ኪሪስቶሴናይዳፓ ማዔ ኮሹሞና ናሹሞና ሃሣ ጉሙርቂሢና ዎላ'' ኪሪስቶሴ ጉሙርቃዞንሢም ቢያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ጋፑዋ ናሹሞና ኑ ጎዳ፥ ዬሱስ ኪሪስቶሴ ጉሙርቂ ናሽካዞንሢም ቢያ ፆኦሲኮ ኮሹሞ ዒንጊፃ ዒንጊንቴያ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","ሓይ ኪኢታ'' ዬሱስ ኪሪስቶሴም ማዻያ ማዔ፥ ጳውሎሴና ፂሞቴዋሴናይዳፓ ዳኪንቴያኬ፤ ዳኪንቴሢያ ፒልጲሲዮሴ ካታማ'' ናንጋ ዬሱስ ኪሪስቶሴ ጉሙርቂፆና ፆኦሲም ዱማዼ ዓሶና ሺኢጲፆ ማኣሮ ዎይሣ ዓሶና ዲያቆኔ ማዒ ዔያቶ ማኣዲ'' ማዻ ዓሶናምኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ኑኡኮ ዓዳሢ፥ ፆኦዛሢዳፓ፤ ዬያጉዲ ሃሣ፥ ጎዳ ዬሱስ ኪሪስቶሴይዳፓ ፆኦሲኮ ኮሹሞ ዒንጊፆና ዎዛና ዒንሢም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","ዒንሢ ታ ጶቂሣ ዎዶ''ና ቢያ፡ ታ ፆኦዛሢ ታኣኒ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","ዒንሢ ቢያሢም ታ ሺኢቃኣና ዼኤፒ ዎዛና ታ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ታኣኒ ፒልጲሲዮሴ ካታሞ ሄሌ'' ኬላ''ፓ ዓርቃዖ ሃኖ'' ሄላ''ንዳኣና ኮዦ ሃይሶ ኬኤዚፆ ማዾ''ና ታኣና ዎላ'' ዒንሢ ማዔሢሮ ፆኦሲ ታ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ዬሱስ ኪሪስቶሴ ማዒ ሙካ ኬሎ''ና ኩንሣኒ ዬያ ኮዦ ማዾ'' ዒንሢና ማዻኒ ዓርቄ ፆኦዛሢ ሃሢያ ማዺሺ ዴዴዓንዳሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ታ ዒንሢ ዛሎ'' ዬያይዲ ማላንዳያ ኮይሳኔ፤ ዓይጎሮ ጌዔቴ ጎኔ ዒናፓ ታ ዒንሢ ናሽካያታሢሮኬ፤ ሃሣ ታ ዒንሢሮ ዬያይዲ ማላሢ ኮዦ ሃይሶ ዛሎ'' ዖኦጪንታ ባኮሮ ማሂ ታ ኬኤዛ ዎዶ''ና፤ ሃሣ ታ ሃይካ ቱኡዞ ማኣራ ኬኤዛኣና ዒንሢ ታኣና ዎላ'' ፆኦሲኮ ኮሹሞ ዒንጊፆ ዔካያ ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","ዬሱስ ኪሪስቶሴ ዒንሢ ናሽካሢጉዲ ታኣኒያ ዒንሢ ናሽካያ ማዒ ዒንሢ ጶቂሣሢኮ ፆኦሲ ማርካኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ናሹማ ዒንሢኮ ዔራቶና ጶቂሥሢና ዓኣያ ማዒ፥ ዳልጊ ዳልጊ ዓኣዻንዳጉዲ ታ ፆኦሲ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","ዬይ ዑሣ ዓኣዼ ኮዦ ባኮ ዱማሲ ዒንሢ ዔራንዳጉዲና ኪሪስቶሴ ማዒ ሙካ ኬሎ''ና ጌኤሺ፤ ሃሣ ቦሂሳ ባኣዚ''ያ ባኣያ ማዒ ዒንሢ ጴዻንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ያዒ ማዒፆና ዬሱስ ኪሪስቶሴ ዒንሢም ዒንጋ ፂሉ''ሞ ዓኣፖና ኩሚ ፆኦሲ ቦንቻያና ጋላታያ ዒንሢ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","ታ ዒሾንሦ! ታ ሚሾንሦ! ታጊዳ ሄሌ'' ባካ ቢያ ኮዦ ሃይሶ ማዾ'' ባሼና ዳልጋንዳጉዲ ማሄሢ ዒንሢ ዔራንዳጉዲ ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ታኣኒ ቱኡቴሢ ኪሪስቶሴኮ ኮዦ ሃይሶ ኬኤዚፆ ዛሎ''ናታሢ ሮሜ ዓጮ'' ካኣቲ ማኣሮ ካፓ ዓሶንታ ሜሌ'' ዓሳኣ ቢያ ታና ዔሬኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ታ ቱኡቴቴያ ኪሪስቶሴ ጉሙርቃ፥ ታ ዒሾንሢና ታ ሚሾንሢናፓ ሚርጌዞንሢ ፆኦሲ ቃኣሎ'' ዒጊቹሞ ባኣያ ኬኤዛኒ ዳንዳዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ጋዓንቴ ፔቴ'' ፔቴ''ዞንሢ ኮዦ ሃይሶ ኬኤዛሢ' ቄኤሙሞና ዒፂሢ ዓያናናኬ፤ ዛላ'' ኬኤዛሢ ፒዜ ዒናፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ዬንሢ ኮዦ ሃይሶ ፒዜ ዒናፓ ኬኤዛዞንሢ ናሹሞና ኬኤዛኔ፤ ዔያታ ዬያ ማዻሢ' ታኣኒ ኪሪስቶሴኮ ኮዦ ሃይሶ ዛሎ'' ሞኦታንዳጉዲ ፆኦሲ ታና ዶኦሬሢ ዔራሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ሃንጎዋታ ኮዦ ሃይሶ ዎቢሲ ኬኤዛሢ ፔና ዼ'ግ ዼ'ጊዳኒ ዓኣ ማሊፆይዳፓ ዔቄያና ቱኡዞኮ ጊዳ'' ቃሲ'' ታና ሜቶ ሄሊ''ሳኒ ማሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ዬይ ያዺ ማዔቴያ ዬይ ቢያ ታና ዎዎዛሳኔ፤ ሴካ ቤርታ ዓኣ ዎዛ'' ታኣኮ ሃያኬ ጌይንቱዋያኬ፤ ዎይቲ ጌዔቴ ኮሺና ማዖም ፑርታ ማሊሢና ኪሪስቶሴኮ ኮዦ ሃይሳ ኬኤዚንታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ሜሌ'' ሃሣ ታና ዎዛሳ ባካ ዒንሢ ሺኢጲፆና፤ ሓሣ ዬሱስ ኪሪስቶሴኮ ዓያኖ ጌኤዣ ታና ማኣዴ''ም ታኣኒ ቱኡዛፓ ቡሊ''ንታንዳሢ ታ ዔሬሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ዬያሮ ዓይጎ ባኣዚ''ናኣ ታ ባሺንቲንዱዋኣሢ ጉቤ ዒናፓ ሃጊ ማዓንዳ ዎዛ ጌሢ ታ ጉሙርቃኔ፤ ዬያጉዲ ሃሣ ቤርታኣስካፓ ባሼና ሓሢ ታ ናንጌቴያ ሃይቄቴያ ታኣና ኪሪስቶሴ ቦንቺንታንዳጉዲ ማሃኒ ጫርሹሞ ታኣኮ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ዬያሮ ታኣኮ ናንጎ ጌይፃ፦ ኪሪስቶሴና ናንጊሢኬ፤ ታ ሃይቄቴያ ዑሣ ዓኣዼ ኮሺ ታኣም ማዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ታኣኮ ኪሪስቶሴና ማዒ ናንጊፃ ዓኣፒ ማዾ ማዺሻያ ማዔቴ፥ ሃሢ ናንጊና ሃይቢናይዳፓ ዎኖ ታ ዶኦራንዳቴያ ታኣም ዔርቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ዬንሢ ላምዖ ማሊፆንሢና ታ ሜታዻኔ፤ ፔቴ'' ዛሎ''ና ሃካ ናንጊፆይዳፓ ሃይቢና ዱማዺ፥ ኪሪስቶሴና ዎላ'' ታ ናንጋኒ ኮዓኔ፤ ዓይጎሮ ጌዔቴ ኪሪስቶሴና ማዒፃ ቢያፓ ባሼ ታኣም ማዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ሜሌ'' ዛሎ''ና ዒንሢ ማኣዳ''ኒ ታኣኮ ሃካ ሳዓ ናንጊፃ ሚርጌ ኮይሳያ ማዔሢ ታ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ታኣኮ ዬኖ ዛሎ'' ማሊፃ ባሼያ ማዔሢሮ ሃይቢዳፓ ታ ዓቲ'' ዒንሢና ዎላ'' ናንጋንዳሢ ታ ጉሙርቃኔ፤ ያዺ ማዔቴ፦ ኪሪስቶሴ ጉሙርቂ ዲጪሢና ዎዛና ዒንሢ ዴንቃንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ላሚ ዒንሢ ኮይላ'' ታ ሙካኣና ታ ዛሎ''ና ኪሪስቶሴና ዒንሢኮ ዓኣ ዎዞና ዒንሢ ሚርጌና ዎዛዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ዓካሪ ቢያፓ ባሼ ማዔ ባካ ዓይጎዳይ ጌዔቴ፦ ናንጋ ዒንሢኮ ኪሪስቶሴ ኮዦ ሃይሶ ጋላቲሳያ ማዓኒ ኮይሳሢኬ፤ ዬይ ያዺ ማዔቴ ታ ዒንሢ ሙኪ ዛጌቴያ ሃኬ ማዔቴያ ፔቴ'' ማሊሢና ዶዲ ዒንሢ ዔቃንዳሢንታ ኮዦ ሃይሶ ማዾ'' ዶዲ ዒንሢ ማዻንዳሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ዓይጎ ባኣዚ''ናኣ ማዖም ዒንሢ ማዾ'' ማካ ዓሶ ዒጊጪፖቴ፤ ዬይ ዒንሢኮ ጫርሹማ ዔያቶም ባይሲንታ ማላታ ማዓዛ ዒንሢም ጋዓንቴ ዻቂንታም ፆኦሲ ዒንጌ ማላታ ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ኪሪስቶሴ ዛሎ'' ዒንሢ ሜቶ ዔካንዳጉዴያ ማዓንዳፓዓቴም ዒዛ ጉሙርቃንዳጉዲ ሌሊ ሃይ ፆኦሲኮ ኮሹሞ ዒንጊፆ ማዻ'' ዒንሢም ዒንጊንቲባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ዬያሮ ሃሢ ዒንሢ ታኣና ዎላ'' ሜታዻያ ማዔኔ፤ ዬይ ሜታሢ ሃያኮ ቤርታ ታና ሄሌ''ሢና ሃሢያ ታኣኒ ሜታሢዳ ዓኣሢ ዒንሢ ዋይዛሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ኪሪስቶሴሮ ዒንሢ ማዔሢሮ ዒዛና ዒንሢ ዎልቄ ዴንቄኔ፤ ሃሣ ዒዛ ናሹሞና ዒንሢ ዶዴኔ፤ ዓያኖ ጌኤዦ ዛሎ''ናኣ ፔቱሞ ዒንሢ ዴንቄኔ፤ ዎላ'' ዒንሢ ኮሹሞና ሚጪንቲሢና ናንጌኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ዬያሮ ፔቴ'' ማሊሢና ናሹሞ ዓያናና ዎላ'' ጊኢጊ ናንጊሢና ታኣኮ ዎዞ'' ኩሙሢ ዎዛ ማሁዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ሚርጌና ሼሌዔ ማዒ፥ ሜሌ'' ዓሶ ዒንሢዳፓ ባሼ ማሂ ዛጉዋቴ፤ ፔና ናሽኪሢና ሃሣ ዬያጉዲ፦ «ታ ጊዳ''ፓ ሜሌ'' ዖናዳይ?» ጋዓ ሄርሺንቲና ዓይጎ ባኣዚ''ያ ማዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ሃሣ ዬያጉዲ ፔቴ'' ፔቴ''ሢ ፔኤም ኮይሳ ባኮ ሌሊቱዋንቴ ሜሌ'' ዓሲማኣ ማዓንዳ ባኣዚ'' ማሎንጎ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ዬያይዲ ዬሱስ ኪሪስቶሴ ዒንሢ ዻዌ ሼሌዑሞ ማዻ'' ዒንሢ ናንጎይዳ ጴዻንዳያ ኮይሳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ዒ ፔኤሮ ፆኦሲታዖ ፆኦሲና ዎላ'' ዒዛ ሄኮ ማሃ ዒዛኮ ፆኦሱሞ ዓርቂ ዴዓኒ ኮይባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ጋዓንቴ ዒዚ ፔና ጉሪ ማሄኔ፤ ዓይሌ'' ማሎዋ ዔኬኔ፤ ሃሣ ዓሲ ማዒያ ጴዼኔ፤ ");
INSERT INTO mdybse_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ዓሲ ማዔዖዋ ሼሌዑሞና ፔ ቶኦኮ'' ሂርኪዴኔ፤ ሃይቢ ሄላ''ንዳኣና ዬይያ ፑርቶ ዓሶ ሱፆ ሚፆይዳ ሱፂንቲ ሃይቃኒ ዓይሢንታያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ዬያ ዛሎ''ሮ ፆኦሲ ዒዛ ቢያፓ ዑፃ ዼ'ጊዴኔ፤ ሱ'ንሢ ቢያይዳፓ ባሼ ሱ'ንሢ ዒዛም ጌሤኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ዬያሮ ዬሱሴ ሱ'ንፆ ቦንቺ ጫሪንጮና ሳዖናይዳ ሃሣ ሳዖኮዋ ዴማ'' ዓኣሢ ቢያ ዒዛም ጉምዓታንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ሃሣ ዔያታ ፔ ዻንጎና «ዬሱስ ኪሪስቶሴ ጎኔ ጎዳኬ» ጌዒ ማርካዺሢና ፆኦሲ፥ ዓዳሢ ቦንቻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ታ ዒጊኖንሢዮቴ! ታኣኒ ዒንሢና ዎላ'' ማዔ ዎዶ'' ቢያና ዒንሢ ዓይሢንታያኬ፤ ዓካሪ ባሼና ታ ዒንሢዳፓ ሃኬ ዎዶ''ናኣ ዓይሢንታያ ማዓንዳጉዲ ታ ዒንሢ ዞራኔ። ዬያሮ ዒንሢ ፔቴ'' ፔቴ''ሢኮ ዓኣ ዻቂንታ ጋፒንፆ ሄላ''ንዳኣና ዶዲ ዴዓንዳጉዲ ፆኦሲ ዒጊጪሢና ቦንቺሢና ዶዲ ማዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ዓይጎሮ ጌዔቴ ዒዛ ማሊፆጉዴያ ዓይሢንቲሢና ናሽኪ ዔኤዒሢና ዒንሢም ዒንጊ ዒንጊ ማዻሢ ፆኦሲታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","ዓይጎ ማዾዋ ዒንሢ ማዻ ዎዶ''ና ጉንዱሚ ጉንዱሚ ጎሪ''ንቲያ ዎላ'' ጎሪ''ንቲ ማርሚፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ያዺዴቴ ሃያ ዎርቆ ጎይፃ ዔርቱዋ ሾይንቶ ዓሶ ባኣካ'' ቦሂሳ ባኣዚ'' ባኣያ፥ ጌኤሺ ፆኦሲ ናይ ማዒ፥ ዦኦጌጉዲ ፖዒ ዒንሢ ጴዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ዬይ ያዺ ማዓንዳሢ' ናንጊ ዒንጋያ ማዔ፥ ኮዦ ሃይሶ ሃሹ''ዋዖ ዒንሢ ኬኤዛኒ ዳንዳዔቶኬ፤ ዬያ ጎይፆና ታኣኮ ጳዦ ማዔቴያ ማዻ'' ጉሪ ማዒ ዓቲንዱዋኣሢሮ ኪሪስቶሴ ማዒ ሙካኣና ታና ሄርሺንቲሳንዳ ባኣዚ'' ዓኣኔ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ፆኦሲም ጉሙርቂሢና ዒንሢ ዒንጎ ባኮ ሺኢሻኣና ታ ሼምፓሢያ ቃሲ'' ዋሆ ዑዦጉዲ ማዒ ዒንጊንታያታቴ ታና ዎዛሳያ ማዓንዳኔ፤ ዒንሢያ ታኣና ዎላ'' ዎዛዻንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ዬያይዲ ዒንሢያ ታኣና ዎላ'' ዎዛዹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ታኣኒ ዒንሢ ዛሎ'' ዋይዚ ዎዛዻኒ ፂሞቴዎሴ ዑኬና ዒንሢ ባንሢ ዳካንዳጉዲ ጎዳ ታና ማኣዳ''ንዳሢ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ዒንሢ ዛሎ'' ሜታዺ ማላ ዓሲ ፂሞቴዎሴይዳፓዓቴም ሜሌ'' ዓሲ ታኣኮ ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","ሜሌ'' ዓሳ ጋዓንቴ ቢያ ፔኤም ማዓ ባኣዚ'' ሌሊ ዳኪ ሃንታኣፓዓቴም ዬሱስ ኪሪስቶሴ ማዾ'' ዛሎ'' ዔኤቢ ዓቴ''ኔ ጎዑዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ፂሞቴዎሴኮ ጉሙርቂንቲፃ ዛጊንቲ ዔርቴያ፤ ሃሣ ኮይሳ ዓሲ ማዔሢ ታኣና ዎላ'' ዓዶና ናይናጉዲ ፔቴ'' ማዒ ኮዦ ሃይሶ ኬኤዚፆና ዎላ'' ኑ ማዺ ናንጌሢ ዒንሢ ዒ'ንሢ ቶኦኪና ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ታ ጌኤዛ ዎይታንዳቴያ ታ ዔሬሢኮ ጊንፃ ፂሞቴዎሴ ዑኬና ዒንሢ ባንሢ ታ ዳካኒ ማላኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ሃሣ ታኣኒያ ታኣሮ ዒንሢ ኮይላ'' ሙካንዳጉዲ ጎዳ ታና ማኣዳ''ንዳኔ ጌዒ ታ ጉሙርቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ዬያጉዲ ሃሣ ዒንሢ ታና ማኣዶ''ንጎ ጌዒ ዳኬ፥ ጎዳ ሱ'ንፆና ኑኡኮ ዒሻሢ ማዔ፥ ዔፓራዲቶሴያ ዒንሢ ባንሢ ዳካኒ ኮይሳያ ማዒ ታኣም ጴዼኔ፤ ዒዚያ ታኣና ዎላ'' ዬሱስ ኪሪስቶሴ ማዾ''ና ፖኦሊሴጉዲ ማዒ፥ ዶዲ ማዺ ናንጌያኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ዒዛ ታ ዒንሢ ኮይላ'' ዳካሢ' ዒንሢ ዒዛ ዛጋኒ ጶቂሣሢሮና ዒዚ ሃርጊንቴሢያ ዒንሢ ዋይዜሢናሮ ዒ ማላያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ጎኔና ዒ ኮሺ'' ሃርጊንቲ ሃይቃኒ ዑኬዖኬ፤ ጋዓንቴ ፆኦሲ ዒዛ ሚጪንቲ ዓውሴኔ፤ ዒዛም ሌሊቱዋንቴ ታኣማኣ ሚጪንቴሢሮ ታኣኮ ቤርታኣ ማሊፆይዳ ቃሲ'' ቃሲ'' ታ ማሉዋጉዲ ታናኣ ማኣዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ዬያሮ ዒንሢ ዒዛ ዛጊ ዎዛዻንዳጉዲና ታኣኮዋ ማሊፃ ሼሌዓንዳጉዲ ዒዛ ታ ዒንሢ ባንሢ ዳካኒ ባሼና ኮዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ዓካሪ ጎዳ ሱ'ንፆና ዒዚ ዒንሢኮ ዒሾ ማዔሢ ዔሪ፥ ዎዛና ዒዛ ሾኦቺንሢ ዔኩዋቴ፤ ሃሣ ዒዛጉዴ ዓሶዋ ቢያ ቦንቹዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ዓይጎሮ ጌዔቴ ዒንሢ ታ ኮይላ'' ሙኪ ማኣዳ''ኒ ዳንዳዒባኣ ማኣዶ ዒዚ ታና ማኣዳ''ኒ ጌዒ ኪሪስቶሴኮ ኮዦ ሃይሶ ኬኤዚፆ ማዾ''ሮ ፔ ሼምፓሢ ሚጪንቱዋዖ ሃይቃኒ ዑኬዖ ዓቴ''ሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ዓካሪ ታ ዒሾንሦ! ታ ሚሾንሦ! ጎዳና ዎዛዹዋቴ፤ ዬያ፥ ታኣኒ ቤርታ ፃኣፔ ባኮ ላሚ ፃኣፓኒ ታና ዒሡዋሴ፤ ዒንሢ ዬይ ዻቢንቲፓ ካፓኒ ዳንዳዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ካናቶጉዲ ፑርቶ ማዾ'' ማዻ ዓሶይዳፓ ዒንሢና ካፑዋቴ፤ ዬያታ ዓቲንቴ ቤርቲ ቲቂሢ ኮይሳያኬ ጌይ ዔርዛዞንሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ኑኡኒ ዓያናና ፆኦሲ ካኣሽካያ፥ ዙልካ ዓሲም ጴዻ ዎጌና ማዒባኣንቴ ዬሱስ ኪሪስቶሴና ሌሊ ሄርሺንታያ ማዔሢሮ ጎኑሞና ዓቲንቴ ቤርቲ ኑ ቲቂንቴያኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ዓሲም ጴዻ ባኣዚ''ና ሄርሺንታኒ ኮይሳያ ማዔቴ ሚርጌ ባኣዚ''ና ታ ሄርሺንታኒ ዳንዳዓኔ፤ ዓሲ ቤርቲዳ ጴዻ ባኣዚ''ና ሄርሺንታኒ ጋዓይ ዓኣቶ ታ ዒዛፓ ባሼ ሄርሺንታንዳ ሚርጌ ባኣዚ'' ታኣኮ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ታኣኒ ሾይንቴስካፓ ሳላ''ሳ ኬሎ''ና ዓቲንቶ ቤርቶ ቲቂንቴኔ፤ ሃሣ ቢኢኒያሜ ዜርሢ ማዔያ፥ ታኣኒ ዒስራዔኤሌ ዓሲኬ፤ ዬያጉዲ ሃሣ ዔብሬ ዓሲ ታ ማዔሢኮ ዖኦጪሳ ባኣዚ'' ባኣያኬ፤ ጊንሣ ዓይሁዶ ዎጎ ካፒፆ ዛሎ'' ማዔቴ ታ ፔርሴ ዓሶይዳፓኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ፆኦሲ ካኣዦ ሚጪንቶ ዛሎ'' ማዔቴ ዬሱስ ኪሪስቶሴ ጉሙርቃዞንሢ ዒፂ ታ ዳውሳሢኬ፤ ሃሣ ዎጌ ካፒሢና ፂሊ''ሢ ዛላ ማዔቴ ዔኤቢ ቦሂሳ ባኣዚ'' ባኣያ ታ ናንጋያኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ጋዓንቴ ሃያኮ ቤርታ ታኣም ኮይሳያኬ ጌዒ ታ ጉሙርቃ ባኮ ቢያ ኪሪስቶሴሮ ጌዒ ዔኤቢ ፓሡዋ ባኣዚ'' ማሂ ታ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ታ ጎዳሢ ዬሱስ ኪሪስቶሴ ዔሪፃፓ ባሼ፥ ሜሌ'' ዓይጎ ባኣዚ''ያ ባኣሢ ታ ጉሙርቃሢሮ ቢያ ባኣዚ'' ዔኤቢ ፓሡዋያ ማሂ ታ ዛጊ ዒዛሮ ጌዒ ቢያ ባኣዚ'' ታ ሃሼ''ኔ፤ ሃሣ ዒዛ ዴንቃኒ ጌዒ ቢያ ባኣዚ'' ፒፆ''ና ቡኡራጉዲ ማሂ ታ ዛጋኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ዬያ ታ ማዻሢ ዎጌ ካፒሢና ጴዻ፥ ታ ቶኦኮ'' ፂሉ''ሞናቱዋንቴ ጉሙርቂሢና ጴዻ ፂሉ''ሞ ኪሪስቶሴ ዛሎ''ና ዴንቃኒና ዒዛና ዎላ'' ማዓኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","ሃሣ ኪሪስቶሴንታ ዒዛኮ ሃይባ''ፓ ዔቂፆ ዎልቆንታ ዔራኒ፥ ሃሣ ዒዛኮ ሃይቦ''ናኣ ዒዛ ማላኒና ሜታሢያ ዒዛና ዎላ'' ዔካኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ዬያጉዲ ሃይቄሢኮ ጊንፃ ዔቂ፥ ናንጊና ሼምፔና ናንጋኒ ሃጊ ማዓንዳ ዎዛ ታ ጌሣኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ዬያ ቢያ ሃጊ ታ ዴንቂባኣሴ፤ ሃሣ ዬያ ቢያ ታ ኩንሤኔ ጋዓኒ ዳንዳዑዋሴ፤ ማዔቴያ ዬሱስ ኪሪስቶሴ ታና ዒዛም ማሂ፥ ታኣም ዒንጋኒ ጊኢጊሼ ባኮ ዔካኒ ሴካ ቤርቲም ዶዲ ታ ጳዦይዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ታ ዒሾንሦ! ታ ሚሾንሦ! ሃሢ ታ ዒኢካ ሄሌ''ኔ ታና ታ ጎዑዋሴ፤ ጋዓንቴ ፔቴ'' ባኣዚ'' ታ ማዻኔ፤ ዬይያ፦ ታኣኮ ጊንፃ ዓኣ ባኮ ታ ሃሺ'' ሃሺ'' ቤርታ ዓኣሢ ዴንቃኒ ዶዲ ታ ማዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","ታኣም ዒንጊንታ ባኮ ዔካኒ፥ ታኣኮ ቤርታ ሄሎ''ም ጌሦና ቤዞ ታ ጳሽካኔ፤ ዬይ ታኣም ዒንጊንታንዳሢ' ፆኦሲ ዬሱስ ኪሪስቶሴ ዛሎ''ና ሌካ ታና ዔኤሊ'' ዒንጋንዳ ሼምፖኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ዓካሪ፡ ዓያኖ ናንጎና ዶዶ ዓሳ፥ ኑኡኒ ቢያ ዬያጉዴ ማሊሢና ናንጋንዳያ ኮይሳኔ፤ ዒንሢ ዱማሳ ማሊሢ ባኣካ'' ማዢንቴቴ ዬያ ማሊፆዋ ፆኦሲ ዒንሢም ፔጋሳንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ዬይ ያዺ ማዔቴያ ኑኡኮ ዬይ ናንጋ፡ ኑ ሃሢ ናንጋ ዓያኖ ናንጎና ዎላ'' ሄኮ ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","ታ ዒሾንሦ! ታ ሚሾንሦ! ታ ማዼ ባኮ ዛጊ ማዺሢና ሓንጎ ዓሶና ዎላ'' ፔቴ'' ማዑዋቴ፤ ሓሣ ኑ ማዼ ባኮ ዛጊ ሓንታ ዓሶዋ ቢያ ዒናፓ ኮሺ'' ዛጉዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ሃያኮ ቤርታ ሚርጌ ዎዴ ታ ኬኤዜሢጉዲ ሃሢያ ታ ዬኤኪ ዬኤኪ ዒንሢም ኬኤዛ ጎይፆ ሚርጌ ዓሳ ኪሪስቶሴ ፑርቲሴ ዓሶ ሱፆ ሚፃ ሓይቄ ሓይቦኮ ሞርኬ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ዔያቶኮ ፆኦዛሢ ጎጲኬ፤ ሃሣ ቦርሲሳያ ማዔ፥ ፑርቶ ባካ ዔያቶኮ ቦንቾኬ፤ ባሼ ዔያቶኮ ማሊፃ ሳዓይዳ ዓኣ ባኣዚ''ዳኬ፤ ዬያሮ ጋፒንፃ ዔያቶኮ ባይሲንታኬ ጌይሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ኑኡኒ ጋዓንቴ ጫሪንጮ ዓጪ ዓሲኬ፤ ዒኢካፓ ሙካንዳ ዼኤሻሢ፥ ኑ ጎዳሢ፥ ዬሱስ ኪሪስቶሴ ጶቂሢ ኑ ካፓያኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ዒዚ ሃያ ኑኡኮ ላቤ''ያ ማዔ፥ ሓይቃ ዑፆ ላኣሚ ዒዛኮ ቦንቺንታ ዑፆ ማላያ ማዓንዳጉዲ ማሃንዳኔ፤ ዬያ ዒ ማዻንዳሢ' ቢያሢ ዒዛ ቢታንቶ ዴማ'' ማዒ ዎርቃንዳጉዲ ማሃ ዎልቆናኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ታ ዒንሢ ናሽካያ፥ ጶቂሣያ፤ ሃሣ ታና ዎዛሳያና ታ ማዼ ማዾ''ኮ ቦንቺ ዒንጎ ባኮ ማዔ ታ ዒጊኖንሢዮቴ! ዓካሪ ዬያይዲ ጎዳና ዶዲ ዒንሢ ናንጋንዳጉዲ ታ ዒጊኖ ዒንሢ ማዔ ጎይፆና ታ ዒንሢ ዞራኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ዔዎዲያና ሲንፂኬና ዔያታ ዎላ'' ቡኪ ጎዳና ዓኣ ፔቱሞና ናንጋንዳጉዲ ታ ዔያቶ ሺኢቃኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ኔኤኒያ፥ ዒኢካ ዓኣ ጉሙርቂንታ ታኣኮ ማዾ'' ላጋሢ' ዬንሢ ላኣሎንሢኮ ዑኬ ማዒ ዓያኖ ናንጎ ዛሎ''ና ዔያቶ ኔ ማኣዳ''ንዳጉዲ ጌዒ ታ ኔኤም ኬኤዛኔ፤ ዓይጎሮ ጌዔቴ ዬንሢ ላኣሎንሢ ቄሌማፆሴና፤ ሃሣ ሱ'ንፃ ናንጎ ማፃኣፖይዳ ፃኣፒንቴ፥ ሜሌ'' ኑኡኮ ማዾ'' ላጎንሢንታ ዎላ'' ማዒ ኮዦ ሓይሶ ኬኤዚፆና ታኣና ዎላ'' ዔያታ ላቤ''ያታሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ጎዳና ዒንሢ ዓኣሢሮ ቢያ ዎዴ ዎዛዹዋቴ፤ ላሚ ላሚ ታ ዒንሢ «ዎዛዹዋቴ» ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ዒንሢኮ ኮሹማ ዓሲ ቢያም ዔርቴያ ማዖንጎ፤ ጎዳ ሙካኒ ዑኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ዬያሮ ዒንሢም ኮይሳ ባኣዚ'' ዓኣቶ ጋላቲ ጋላቲ ፆኦሲ ሺኢቃንዳኣፓዓቴም ዓይጎ ባኣዚ''ሮዋ ማሊ ሜታዺፖቴ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","ዓሲ ማሊሢኮ ዑሣ ማዔ፥ ፆኦሲኮ ኮሹማ ዒንሢኮ ዒኖና ማሊፆና ዬሱስ ኪሪስቶሴ ዛሎ''ና ካፓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ታ ዒሾንሦ! ታ ሚሾንሦ! ዓካሪ ጋፒንፆይዳ ታ ዒንሢም ኬኤዛሢ' ጎኔ ማዔ ባኣዚ''፥ ዒናና ዓኣያ ማሃ ባኣዚ''፥ ጌኤሺ ማዔ ባኣዚ''፥ ፂሎ'' ማዔ ባኣዚ''፥ ናሹሞ ዓኣ ባኣዚ''፥ ኮሺ ሃይሴ ማዓ ባኣዚ'' ቢያ፤ ሃሣ ኮሺ ማዾ ማዔቴያ ጋላቲሢ፤ ዬንሢ ባኮንሢ ማሉዋቴ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ታኣኒ ዔርዛኣና ዋይዚ ዒንሢ ዔኬ ባኮና ታ ማዻኣና ዛጌ ባኮ ቢያ ማዹዋቴ፤ ዬያ ዒንሢ ማዼቴ ኮሹሞ ዒንጋ ፆኦዛሢ ዒንሢና ዎላ'' ማዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ሚርጌ ዎዴኮ ጊንፃፓ ታ ሜታሢ ዛሎ'' ዒንሢ ማሊሢ ዓርቄሢሮ ፆኦሲ ሱ'ንፆና ሚርጌና ታ ዎዛዻኔ፤ ዬያ ታ ጋዓሢ' ዒንሢ ማሌ ባኮ ማዻኒ ዒንሢም ጊኢጉዋዖ ዓቴ''ኔ ጌይሢ ማዓንዳኣፓዓቴም ታ ሜታሢ ዛሎ'' ማሊፆ ዒንሢ ሃሼ''ዖ ዓርቄኔ ጌይሢቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ሃሣ ዬያ ታ ጋዓሢ' ታና ሜቴ ባኣዚ'' ዓኣኔ ጌይቱዋሴ፤ ዓይጎሮ ጌዔቴ «ታኣኮ ዓኣ ባካ ታኣም ጊዳንዳኔ» ጌይሢ ታ ዔራሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ዬያሮ ዔኤቢ ዴንቂሢ ማዔቴያ ዔኤቢኮ ባይቂሢ ታ ዔራኔ፤ ዓይጎ ቤስካ ማዔቴያ ዓይጎ ዎዴና ማዖም ሚሽኪሢና ናይዺንቲሢና፥ ሃሣ ዴንቂሢና ዔኤቢ ባይዚሢናኮ ዓኣ ባኣዚ'' ታ ዔራኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ዬያሮ ኪሪስቶሴ ታኣም ዒንጋ ዎልቆና ቢያ ባኣዚ'' ታ ዳንዳዓንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ጋዓንቴ ዒንሢ ታ ሜታሢ ታኣና ዎላ'' ዔካያ ማዒፆና ኮሺ ማዾ ዒንሢ ማዼኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ዬያ ሌሊቱዋንቴ ኮዦ ሃይሶ ማዾ'' ታ ዓርቄ ዎዶ''ና ሜቄዶኒያ ዓጫ''ፓ ታ ኬስካኣና ዒንሢ፥ ፒልጲሲዮሴይዳ ዓኣ ዓሶፓ ዓታዛ ሜሌ'' ታና ማኣዴ'' ሺኢጲሢ ማኣሪ ዓሲ ባኣሢ ዒንሢ ዒ'ንሢሮ ዔራያኬ፤ ዬያሮ ታኣኮ ዔቦ'' ዴንቂፆናኣ ማዖም ባይዚፆናይዳ ታና ማኣዴ''ሢ ዒንሢ ሌሊኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ቴስሎንቄይዳ ታ ዓኣና ሜታዼሢ ዔሪ፥ ላሚ ላሚ ታና ዒንሢ ማኣዴ''ኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ዬያ ታ ጋዓሢ' ዒንሢ ሃያኮ ቤርታ ማዼ ባኮፓ ባሼ ሚርጌ ኮሺ ማዾ ዒንሢም ቃሲ''ንታንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ታኣም ኮይሳሢጉዲ ሌሊቱዋንቴ ዑሣ ዓኣዼ ማዔ፥ ዒንሢ ታኣም ዳኬ ባኮ ዔፓራዲቶሴይዳፓ ታ ዔኬኔ፤ ዬይ ዒንሢ ዳኬ ባካ፦ ኮሺ ሳውሞ ዓኣ ፆኦሲም ዒንጎ ባኣዚ''ጉዲ ማሂ ፆኦሲ ዔካንዳያና ዎዛዻንዳ ዒንጊሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ዬያሮ ታ ፆኦዛሢ ሃይማኬ ጌይንቱዋ፥ ዒዛኮ ዓኣ ባኮይዳፓ ዬሱስ ኪሪስቶሴ ዛሎ''ና ዒንሢም ኮይሳ ባኮ ቢያ ዺቢሺ ዒንጋንዳኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ኑ ዓዳሢ፥ ፆኦዛሢም ናንጊና ናንጊ ሄላ''ንዳኣና ቦንቾ ማዖንጎ፤ ዓኣሜን። ");
INSERT INTO mdybse_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","ዬሱስ ኪሪስቶሴ ጉሙርቂ ፆኦሲም ዱማዼያ ማዔ፥ ዒዛ ዓሶም ቢያ «ኮሺዳ?» ጌዔኔ፥ ጎዑዋቴ፤ ታኣና ዎላ'' ዓኣ ዒሾንሢንታ ሚሾንሢንታ «ኮሺዳ?» ዒንሢ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ዓቴ'' ኪሪስቶሴ ጉሙርቃ ዓሳ ቢያ፤ ሃሣ ዱማና ሮሜ ካኣቲም ማዻ ኪሪስቶሴ ጉሙርቃ ዓሳኣ «ኮሺዳ?» ዒንሢ ጋዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ጎዳ ዬሱስ ኪሪስቶሴኮ ኮሹሞ ዒንጊፃ ዒንሢ ቢያሢም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ፆኦሲ ማሊሢና ዬሱስ ኪሪስቶሴ ማዾ''ም ዳኪንቴያ ማዔ፥ ጳውሎሴና ኑ ዒሻሢ፥ ፂሞቴዎሴናይዳፓ፦ ");
INSERT INTO mdybse_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቆላሲያሴይዳ ናንጋያ፥ ኪሪስቶሴ ዛሎ''ና ፆኦሲም ዱማዼዞንሢና ጉሙርቂንታያ ማዔ፥ ዒሾንሢንታ ሚሾንሢንታም፤ ኑ ዓዳሢ፥ ፆኦሲኮ ኮሹሞ ዒንጊፃ ዒንሢም ማዖንጎ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ኑ ዒንሢ ዛሎ'' ሺኢቃ ዎዶ''ና ኑ ጎዳሢ ዬሱስ ኪሪስቶሴኮ ዓዳሢ ማዔ፥ ፆኦዛሢ ቢያ ዎዴ ኑ ጋላታኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ዓይጎሮ ጌዔቴ ዒንሢ ዬሱስ ኪሪስቶሴ ጉሙርቃሢና ፆኦሲም ዱማዼ ዓሶ ዒንሢ ናሽካሢ ኑ ዋይዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ጎኑሞ ማዔ፥ ኮዦ ሃይሳ ዒንሢም ሄሌ'' ዎዶ''ና ሃጋ ማዓንዳ ዎዞ'' ዬያ ዛሎ''ና ዒንሢ ዋይዜኔ፤ ዬያሮ ዒንሢኮ ጉሙርቂፆና ናሹሞናኮ ካራ'' ጫሪንጫ ዒንሢም ጊኢጊንቲ ዓኣ ሃጊ ማዓንዳ ዎዞ''ይዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ዒንሢ ኮዦ ሃይሶ ዋይዜሢና ፆኦሲኮዋ ኮሹሞ ዒንጊፆ ጎናሲ ዔኬስካፓ ዓርቃዖ፥ ሃይ ኮዦ ሃይሳ ዒንሢ ባኣካ'' ማዻ ጎይፆ ዓጮ'' ቢያይዳ ዓኣፒ ዓኣፒ ሃሣ ዳልጊሢዳ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ዬያ፡ ኑና ማዒ ኪሪስቶሴም ጉሙርቂንቲ ማዻያ ማዔያ ሃሣ ኑኡና ዎላ'' ማዻያ ማዔ፥ ናሽኪንታ ዔጳፒራ ዒንሢም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ሃሣ ዒዚ ዓያና ጌኤሺ ዒንሢም ዒንጌ ናሹሞ ኑም ኬኤዜኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ዬያሮ ዬያ ኑ ዋይዜስካፓ ዓርቃዖ፥ ዒንሢም ዓያናፓ ማዔ ዔራቶና ማሊ ጶቂሲሢና ቢያ ፆኦሲ ማሊፆጉዴያ ዺባንዳጉዲ ኑኡኒ ፆኦሲ ሺኢጲሢ ሃሺ''ባኣሴ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ኑኡኒ ሺኢቃሢ ጎዳም ዒንሢ ኮይሳሢጉዲ ናንጋንዳጉዲና ቢያ ባኣዚ''ና ዒዛ ዒንሢ ዎዛሳያ ማዓንዳጉዲኬ፤ ዬይያ፦ ኮሺ ማዺ ማዺ፥ ፆኦሲ ዔሪሢና ዲጪ ዲጪ፥ ");
INSERT INTO mdybse_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","ዼኤፒ ዶዱሞና ዳንዳዒሢና ዒንሢኮ ዓኣያ ማዓንዳጉዲ፥ ዒዛኮ ቦንቺንቴ ዎልቆጉዴያ ዎልቄና ቢያ ዒንሢ ዶዲ ሃሣ ዎዛዺ ዎዛዺ፥ ");
INSERT INTO mdybse_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ሃሣ ፖዖ ካኣቱሞይዳ ፆኦሲም ዱማዼ ዓሶና ዎላ'' ፆኦሲ ዒንጋ ባኮ ዒንሢ ዔካያ ማዓንዳጉዲ ዒንሢ ማሄ ፆኦዛሢ፥ ዓዳሢ ዎዛና ዒንሢ ጋላታንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ዓይጎሮ ጌዔቴ ዒዚ ዹሞ ካኣቱሞ ዴማ''ፓ ኑና ዻቂሺ፥ ፔኤኮ ናሽኪንታ ናዓሢ ካኣቱሞ ዴሞ ጌላንዳጉዲ ኑና ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ዒዛ ዛሎ''ና ኑ ዻቂ፥ ጎሜፓ ማኣሪንቲሢያ ኑ ዴንቄኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ኪሪስቶሴ ዓሲም ጴዹዋ ፆኦዛሢኮ ጎኔ ማሎኬ። ዒዚ ቢያ ማዢንቶኮ ቤርታ ዓኣ ቶይዳሢኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ዎይቲ ጌዔቴ ጫሪንጮና ሳዖናይዳ ዓኣ ባካ፥ ዓኣፒዳ ጴዻሢንታ ጴዹዋ ባካ፥ ጫሪንጫ ዼኤፖ ማዢንቶና ዎይሣዞንሢ፥ ሱኡጎንታ ቢታንታ ዓኣዞንሢያ ቢያ ማዢንቴሢ ዒዛናኬ። ፆኦሲ ቢያ ባኮ ማዤሢ ዒዛና ሃሣ ዒዛምኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ዒ ቢያ ባኮኮ ቤርታፓ ዓኣያኬ፤ ቢያ ባካ ዎላ'' ካኣሚ ዶዲ ዔቄሢ ዒዛናኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ዒዚ ዒዛኮ ዑፆ ማዔ፥ ሺኢጲፆ ማኣሮ ዓሶኮ ቶኦካ''ሢኬ፤ ቢያ ባኮና ዒ ቤርቲ ማዓንዳጉዲ ሃይቢፓ ዔቂሢናኣ ቤርታሳሢ ዒዛኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ዬይ ማዔሢ ፆኦሲኮ ዓኣ ዎልቃ ናዓሢዳ ኩሙሢና ዓኣያ ማዓንዳጉዲ ፆኦሲ፥ ዓዳሢ ኮዔሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ዒዛ ዛሎ''ና ጫሪንጮይዳ ማዔቴያ ሳዖይዳ ዓኣ ባኮ ቢያ ፆኦሲ' ፔኤና ዎላ'' ጊኢጊሺ፥ ቡኩሴኔ፤ ፑርቶ ዓሶ ሱፆ ሚፆይዳ ዒ ሓይቄም ላኣሊንቴ ሱጉፆናኣ ኮሹሞ ዔኪ ሙኬኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ሓያኮ ቤርታ ዒንሢኮ ፑርቶ ማዾ''ና ፆኦሲፓ ዒንሢ ሃኪ፥ ዒንሢኮ ማሊፆናኣ ፆኦሲኮ ዒንሢ ሞርኬኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ሃሢ ጋዓንቴ ፆኦሲኮ ናዓሢ ዓሲ ማዒ ኬዲ'' ሃይቄ ዛሎ''ና ፆኦሲ ፔኤና ዎላ'' ዒንሢ ቡኩሴኔ፤ ዬያ ዒ ማዼሢ' ዒንሢ ዒዛም ዱማዼያና ጌኤሺ፥ ሃሣ ዔኤቢ ቦሂሳ ባኣዚ'' ባኣያ ማሂ ፔ ቤርቶ ሺኢሻኒኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ዬይ ያዺ ማዓንዳሢ' ዒንሢ ጉሙርቂሢና ፃጲ ዳኪ፥ ሃሣ ዶዲ ዔቂ ኮዦ ሃይሶይዳፓ ጴዼ ሃጊ ማዓንዳ ዎዞ'' ቃኣሎ''ና ዓጊፁዋዖ ዶዲ ናንጌቴ ሌሊኬ፤ ዬይ ኮዦ ቃኣላ'' ዒንሢ ዋይዛሢና ዓጫ'' ዓኣ ዓሶም ቢያ ኬኤዚንቴሢኬ፤ ታኣኒ፥ ጳውሎሴያ ማዻያ ማዔሢ ዬያ ኮዦ ቃኣሎ'' ማዾ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ሃሢ ዒንሢ ዛሎ''ና ታ ዔካ ሜታሢ ታና ዎዎዛሳኔ፤ ኪሪስቶሴኮ ዑፆ ማዔ፥ ሺኢጲፆ ማኣሮ ዓሶ ዛሎ''ሮ ኪሪስቶሴይዳ ሄሊ'' ዓቴ'' ሜታሢ ታጊዳ ማዒ ኩማዳንዳጉዲ ታ ማሃኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ፆኦሲኮ ኮዦ ሃይሶ ፔቴ''ታዖ ታ ዓይሱዋዖ፥ ጉቤ ዒንሢም ኬኤዛንዳጉዲ ፆኦሲዳፓ ታኣም ዒንጊንቴ ጎይፆና ሺኢጲፆ ማኣሮ ዓሶም ታ ማዻያ ማዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ሓይ፥ ታ ኬኤዛ ኮዦ ሃይሶ ቃኣላ'' ሃያኮ ቤርታ ዓሲም ዓኣሺንቲ ዓኣያ፤ ሃሢ ጋዓንቴ ፆኦሲ ፔኤም ዱማዼዞንሢም ዔርዜ ዓኣሺንቴ ባኣዚ''ኬ፤ ");
INSERT INTO mdybse_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ፆኦሲኮ ማሊፃ ዬያ ዓኣሺንቴ ባኮኮ ቦንቾና ዖርጎቹሞና ዓይሁዴ ማዒባኣ ዓሶ ባኣካ'' ዎዚጉዲ ዼኤፒታቴ ዒዛም ዱማዼ ዓሶም ዔርዛኒኬ፤ ዬይ፥ ዓኣሺንቴ ባካ ሃጊ ማዓንዳ ዎዛ ጌሢ ኑ ካፓ ቦንቻ ዒዛና ጴዻንዳ፥ ዒንሢ ባኣካ'' ዓኣ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ዔራቶና ዓይጎ ዓሲያ ኑ ዞሪ ዞሪ ሃሣ ዔርዚ ዔርዚ ፔቴ'' ፔቴ'' ዓሶ ኪሪስቶሴ ዛሎ''ና ዒናዼ ዓሲ ማሂ ፆኦሲ ቤርቶ ሺኢሻኒ ኪሪስቶሴ ዛሎ'' ኑ ኬኤዛኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ፆኦሲ ፔኤኮ ዼኤፖ ዎልቆና ታኣና ማዻሢሮ ዬያ ዼኤፖ ዎልቆና ዶዲ ማዺፆይዳ ታ ዓኣኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ዒንሢንታ ሎዶቂያይዳ ዓኣ ዓሶ ዛሎ''ንታ፥ ሃሣ ዬያጉዲ ታና ዔሩዋ ዓሶማኣ ቢያ ታ ዎማይዲ ዶዲ ማዻቴ ዒንሢ ዔራንዳጉዲ ታ ኮዓኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ታ ዶዲ ማዻሢ' ዒና'' ዔያቶኮ ዶዲ፥ ናሹሞናኣ ፔቴ'' ማዒ፥ ፒዜ ማዔ ማሊ ጶቂሥሢ ዖርጎቹሞ ዴንቂ ፆኦሲኮ ዓኣሺንቴ ማሊፆ ማዔ፥ ኪሪስቶሴ ዔያታ ዔራንዳጉዲኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ሃኣማቶና ዔራቶናኮ ቆሎ ዓኣሺንቲ ዓኣሢ ኪሪስቶሴ ኮይላ''ኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ዬያ ታ ዒንሢም ጋዓሢ ዖኦኒያ ጌሺሢ ሃይሴና ዒንሢ ዻቢሹዋጉዲ ጌይኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ዎዚ ታ ዒንሢዳፓ ሃኪ ዓኣያ ማዔቴያ ዓያናና ታ ዒንሢና ዎላ''ኬ፤ ዒንሢ ኮይሳማ ጎይፆ ናንጊሢና ኪሪስቶሴይዳ ዒንሢኮ ዓኣ ጉሙርቂፆ ዶዱሞ ታ ዛጋሢሮ ዎዛዻኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ጎዳ ዬሱስ ኪሪስቶሴ ዒንሢ ጉሙርቂ ዔኬ ጎይፆና ዒዛና ዎላ'' ፔቴ'' ማዒ ናንጉዋቴ፤ ");
INSERT INTO mdybse_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ዒዛይዳ ፃጲ ዳኪ፥ ናንጎ ዒንሢ ዒዛና ማሂ ዓርቂ፥ ዒንሢ ዔሬ ጎይፆና ኪሪስቶሴ ጉሙርቂፆና ዶዲ ናንጉዋቴ፤ ሚርጌና ሃሣ ፆኦሲ ጋላቱዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ኪሪስቶሴ ዔርዜ ጎይፆጉዲቱዋንቴ ዓሲ ኬሴ'' ዎጌና ሓይ ዓጫ'' ዎርቃ ዎጌይዳፓ ማዔ ጉሪ ጌሺሢ ባኣዚ''ና ሃሣ ሃምዓቶና ማዢንቴ ሃይሴና ጎኔ ጎይፃፓ ዖኦኒያ ዒንሢ ዲዒ ዔኩዋጉዲ ዒንሢና ዔሩዋቴ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ፆኦሲኮ ፆኦሱማ ጉቤና ፔጋዺ ዔርቲ ናንጋሢ ዓሲ ማዔ፥ ኪሪስቶሴይዳኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ዒንሢያ ኩሙሢ ናንጊ ዴንቄሢ ሱኡጉሞና ቢታንቱሞናኮ ዑፃሢ ማዔ፥ ኪሪስቶሴናኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ዒዛና ዎላ'' ፔቴ'' ማዒፆና ዒንሢ ዓቲንቶ ቤርቶ ቲቂንቴያ ማዔኔ፤ ዬይ ዓቲንቶ ቤርቶ ቲቂንቲፃ ዒንሢኮ ጎሞ ማዾ'' ላኣማኒ ኪሪስቶሴና ማዺንቴያ ማዓንዳፓዓቴም ዓሲ ቲቃ፥ ዓቲንቴ ቤርቲ ቲቂንቲቱዋሴ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ዓይጎሮ ጌዔቴ ዒንሢ ዋኣፆና ማስቴ ዎዶ''ና ኪሪስቶሴና ዎላ'' ዒንሢ ዱኡቴኔ፤ ሃሣ ዒዛና ዎላ'' ሃይባ''ፓኣ ዒንሢ ዔቄኔ፤ ዒንሢ ሃይባ''ፓ ዔቄሢ' ኪሪስቶሴ ሃይባ''ፓ ዔቂሴ፥ ፆኦዛሢ ዎልቆ ዒንሢ ጉሙርቃሢሮኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ዒንሢኮ ጎሞ ዓቲንቶ ቤርታ ቲቂንቲባኣሢሮ ቤርታ ዒንሢ ሃይቄያኬ፤ ሃሢ ጋዓንቴ ፆኦሲ ኪሪስቶሴና ዎላ'' ናንጊና ባይቁዋያ ዒንሢ ማሄኔ፤ ጎሞዋ ኑኡኮ ቢያ ዓቶም ጌዔኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ኑና ዻቢንቲ ዓሲ ማሂ ዒፃያ፥ ሃሣ ኑኡኒ ጋሌ ዓሲ ማዒፆ ኑኡኮ ዔርዛ ፃኣፒንቴ ባኮ ዑጪ ባይዚ፥ ፑርቶ ዓሶ ሱፆ ሚፃ ጳርቂ ኑጊዳፓ ዒዚ ሺኢሼኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ዒዛኮ ሞርኮ ማዔ፥ ጫሪንጫ ዓኣ ሱኡጎና ቢታንታ ዓኣ ማዢንቶ ቢያ ፑርቶ ዓሶ ሱፆ ሚፆይዳ ባሺ ዖሎ ዓንጋሞዋ ጉሲሲ ባሺንቴያ ማዒፆ ዓሲ ቢያ ዴንቃንዳጉዲ ዒ ማሄኔ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ዓካሪ ሙኡዚ'' ዛላ ማዔቴ ዑሺ ዛላ ቦንቾ ኬሊ'' ቦንቺሢ ዛላ፥ ዓጊኒ ፄኤሪ ቦንቺሢ ዛላና ዓይሁዶ ዓሶኮ ሃውሾ ኬሎ'' ቦንቺሢ ዛላና ዖኦኒያ ዒንሢ ዻቤኔ ጎዖፓ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","ዬንሢ ቢያ ሃጊ ሙካንዳ ባኮኮ ሺቦ'' ማዔዞንሢኬ፤ ጎኔ ዓኣያ ማዒ ሺባሢ ኪሪስቶሴኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ኮይሱዋ ሼሌዑሞ ዓኣያ፥ ሃሣ ፆኦሲ ኪኢታንቾ ካኣሽኪሢ ናሽካ ዓሲ ጌሺ ዒንሢ ጉሪ ዓይሱዋጉዲ ዒንሢና ዔሩዋቴ። ዬያጉዴ ዓሢ' ዒዛም ፔጋዺ ጴዻ ባኮና ሄርሺንቲ ሄርሺንቲ ጉሪ ማዔ ዓሲ ማሊሢና ዖቶርቃያኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","ዬያ ዓሢኮ ዑሢ ቢያ ጪጊቺና ሻሺና ካኣሚ ካኣሚ ሙኡዚ''ያ ዴንቂ ዴንቂ ፆኦሲ ዒንጋ ዲጪሢና ዲጪሳ ቶኦካ''ሢናኮ ዎላ'' ካኣሚሢ ባኣያኬ። ");
INSERT INTO mdybse_vpl VALUES ("CL2_20","0