﻿USE sofia;
DROP TABLE IF EXISTS sofia.mdm_vpl;
CREATE TABLE mdm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mdm_vpl WRITE;
INSERT INTO mdm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A ɨnde-e ’lɨ onguo ogbi Yesu Kilisito , ɨnde u azu e bhʉ́ piga gba ’ngbé ngámá Davidi, di ne bhʉ́ piga gba Abalahama-o. ");
INSERT INTO mdm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahama azu Ɨsaka, Ɨsaka azu Yakobho, Yakobho azu Yuda di ne ondaise e, ");
INSERT INTO mdm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda azu Peledje ne Djala lɨ Tamala, Peledje azu Esɨlome, Esɨlome azu Lama, ");
INSERT INTO mdm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lama azu Aminadaba, Aminadaba azu Nasone, Nasone azu Salɨmona, ");
INSERT INTO mdm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salɨmona azu Boadja lɨ Laaba, Boadja azu Obede lɨ Luta, Obede azu Yese, ");
INSERT INTO mdm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese azu ’ngbé ngámá Davidi. Davidi azu Salomo lɨ ɵlɵ gba Ulia, ");
INSERT INTO mdm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo azu Loboama, Loboama azu Abɨa, Abɨa azu Asa, ");
INSERT INTO mdm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa azu Djodjafata, Djodjafata azu Djolama, Djolama azu Odjiasɨ, ");
INSERT INTO mdm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Odjiasɨ azu Djoatama, Djoatama azu Akadjɨ, Akadjɨ azu Edjekia, ");
INSERT INTO mdm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Edjekia azu Manasɨ, Manasɨ azu Amosɨ, Amosɨ azu Djodjiasɨ, ");
INSERT INTO mdm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Djodjiasɨ azu Djekonia di ne ondaise e. Abhomʉ-o, u atsia abha omaƗsalaele bhʉ́ bali abhʉ́ kʉtɨ na Babilona. ");
INSERT INTO mdm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pɨta nabha uo bhʉ́ bali bhʉ́ Babilona-a, Djekonia azu Salatiele, Salatiele azu Djolobabele, ");
INSERT INTO mdm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Djolobabele azu Abiuda, Abiuda azu Eliakime, Eliakime azu Adjole, ");
INSERT INTO mdm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Adjole azu Sadoka, Sadoka azu Akime, Akime azu Eliude, ");
INSERT INTO mdm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliude azu Eleadjalɨ, Eleadjalɨ azu Matana, Matana azu Yakobho, ");
INSERT INTO mdm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobho atsia azu Djodjefʉ ’ko Malɨa ɨnde azu Yesu, u aꞌɨ e me Masɨya-o . ");
INSERT INTO mdm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nako ndʉ opiga bhomʉ-o hana-a, nayie lɨ Abalahama nakolo lɨ Davidi-e, a ko opiga ndjɨkpa ne ká badha, nayie lɨ Davidi nakolo lɨ namba omaƗsalaele bhʉ́ bali na Babilona-a, a ko opiga ndjɨkpa ne ká badha, nayie lɨ nanʉ bhʉ́ bali abhʉ́ Babilona-a nakolo lɨ nazu Masɨya-a, a ko di opiga ndjɨkpa ne ká badha. ");
INSERT INTO mdm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A ɨnde-e lele maka u azu Yesu Kilisito lɨe ko. Malɨa, ’hi anɨ-e adʉ adjeke kʉva gba o ne Djodjefʉ-o. Engʉ́ bini, kala me u mbɨla lɨo na ɵlɵ ne bhoko-o, anɨ abɨ ebhɨ bhʉ́ angu gba Bu Bhobua . ");
INSERT INTO mdm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Abhomʉ-o, ’ko anɨ Djodjefʉ ɨnde adʉ nanɨ kpála namanga Ebhe-e, dʉ akʉnda naha nʉmʉ pɨ anɨ bhʉ́ ká djila okpála de. Anɨ atsia au ndjɨndjɨ me nɨ tse anɨ bhʉ́ pepe. ");
INSERT INTO mdm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nedhɨnga anɨ adʉ abhundja lɨe mo-o, andjelu bini gba Ngámá akoto lɨ anɨ bhʉ́ loto. Anɨ atsia apa pɨ anɨ me: «Djodjefʉ, ndɨlɨ gba Davidi, mo okpé naha wala mʉ Malɨa de, anga ebhɨ ɨnde anɨ nde ne e ayie ka Bu Bhobua. ");
INSERT INTO mdm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Anɨ azú ndɨlɨ na bhobhoko ɨnde mo ogísila ’lɨ e me Yesu, anga anɨ akóbho omaha e bhʉ́ osisiti ’ngʉ́ gba o-o.» ");
INSERT INTO mdm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ndʉ ’ngʉ́ bhomʉ-o hana amene lɨe ngʉbula me engʉ́ lɨ Ebhe Ngámá apa nanɨ e bhʉ́ ’li polofeta mene lɨe. Engʉ́ ɨnde anɨ apa nanɨ e me: ");
INSERT INTO mdm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Tsia nga, ɵlɵ ɨnde ɨ mbɨla nga ’ngʉ́ na bhoko de-e abɨ́ ’bhɨ, anɨ tsia zú ndɨlɨ na bhobhoko ɨnde u agísila ’lɨ e me Ɨmanʉeli.» (A akʉnda napa me: Ebhe bhʉ́ dabɨlɨ bini ne nɨ́.) ");
INSERT INTO mdm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lɨ Djodjefʉ azʉkʉ lɨe, anɨ amene maka lɨ andjelu gba Ngámá apa pɨ anɨ lɨe-o. Anɨ atsia aha Malɨa maka wala e. ");
INSERT INTO mdm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Engʉ́ bini, u sɨ ne anɨ pɨ́ polo bini maka ɵlɵ ne bhoko de nakolo lɨ ’kpɨ́ lɨ Malɨa azu ndɨlɨ na bhobhoko ɨnde lɨ Djodjefʉ agisila ’lɨ e me Yesu-o lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","U azu nanɨ Yesu bhʉ́ Beteleme. Kʉtɨ bini na ndu doto na Yudaya, bhʉ́ nedhɨnga gba ’ngbé ngámá Elode me-e, obhʉlʉ ɨmbɨlangʉ ayie ne andjongu, u akolo bhʉ́ Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","U atsia ayi me: «’Ngbé ngámá gba omaYuda ɨnde u azu e mbɨa ɨnde-e su? Padhá de, anga ya au ɨkʉpala ɨnde asuno me u azu anɨ-e akoto ne andjongu, abhomʉ-o, ya atsia ago ngʉ́ nadhɵgɵ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lɨ Elode adje lɨe mo-o, mabhundja gba anɨ di ne bhe gba ndʉ okpála na Yelusalema hana angbɨngɨ. ");
INSERT INTO mdm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Abhomʉ-o, anɨ apo bhʉ́la ongbengbe odimandɵ gba Ebhe , di ne omʉsuno na lɨ́lɨ gba Moidje-o . Anɨ atsia ayi uo me: «Bɨlɨ ɨnde a ayo me u zu Masɨya lɨ e ngae dho?» ");
INSERT INTO mdm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","U agie pɨ anɨ me: «Abhʉ́ Beteleme, bhʉ́ ndu doto na Yudaya, anga polofeta aye nanɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ngamʉ, Beteleme ɨnde bhʉ́ ndu doto na Yudaya, mʉ mbomboye ane okʉtɨ koko na Yudaya mane ade. Padhá de, anga ngámá ɨnde alíla okpála gba ma na Ɨsalaele, akóto bhʉ́ mʉ.›» ");
INSERT INTO mdm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Abhomʉ-o, Elode aꞌɨ obhʉlʉ ɨmbɨlangʉ-o bhʉ́ pepe. Anɨ ayi uo lɨ kʉkʉlʉ nedhɨnga ɨnde lɨ ɨkʉpala ango-o akoto lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","U agie ’ngʉ́ lɨe pɨ anɨ tété-e, anɨ atsia atima uo bhʉ́ Beteleme ne napa pɨ uo me: «Yi nʉnʉ, yi gɨlɨ ’ngʉ́ pɨndjɨ ndɨlɨ-e na paká paká. Lɨ yi u anɨ-e, yi de go pa mʉma, amba ngama di-e, ma nʉ dhɵgɵ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pɨta u adje engʉ́ lɨ ’ngbé ngámá Elode apa e lɨe, u atsia aholo ’nʉ́. Me-e, ɨkʉpala u au e andjongu-o adʉ adholo kala uo, a atsia anʉ alʉ pɨ́ bɨlɨ ɨnde lɨ ndɨlɨ-e adʉ lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","U au matá ɨkʉpala-a lɨe me-e, u abedhe ne djalɨ bedhe. ");
INSERT INTO mdm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","U alɨ abhʉ́ ’tɨ-o, u atsia au ndɨlɨ-e ne ’hi e Malɨa . Abhomʉ-o, u akikita lɨpʉkʉ o kuto, u atsia adhɵgɵ anɨ. U abhulu okíli gba o-o. U atsia aha apepe pɨ anɨ lɨ olo, ne mʉngotsi, la di ne mʉngotsi koko na mase naali ɨnde ’lɨ e me mila . ");
INSERT INTO mdm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pɨpɨta-a, Ebhe atsia apa pɨ uo bhʉ́ loto me u agíe matá lɨo agba Elode de. Abhomʉ-o, u atsia agie lɨo agba o lɨ kpadjɨ koko. ");
INSERT INTO mdm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pɨta lɨ obhʉlʉ ɨmbɨlangʉ-o agbida lɨe, andjelu bini gba Ngámá-a akoto lɨ Djodjefʉ bhʉ́ loto, anɨ atsia apa pɨ anɨ me: «Yie bhʉ́lá, ha ndɨlɨ-e ne ’hi e, amba mʉ kpe ne uo bhʉ́ Edjipeto. Dʉ oo akólo lɨ nedhɨnga ɨnde ma agáma ’ngʉ́ pɨ mʉ lɨe-o. Padhá de, anga Elode agɨ́lɨ ndɨlɨ-e ngʉ́ nabhɵlɵ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sukpe-e, Djodjefʉ ayie bhʉ́lá, anɨ aha ndɨlɨ-e ne ’hi e, anɨ atsia akpe ne uo bhʉ́ Edjipeto. ");
INSERT INTO mdm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Anɨ adʉ oo akolo lɨ ’kpɨ́ lɨ Elode akpi lɨe, ngʉbula me engʉ́ ɨnde lɨ Ebhe Ngámá apa nanɨ e pɨ polofeta-a, amene lɨe. Ngámá apa nanɨ pɨ opolofeta me: «Ma aꞌɨ ndɨlɨ gba ma me anɨ koto bhʉ́ Edjipeto kokoto.» ");
INSERT INTO mdm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lɨ Elode au lɨe me obhʉlʉ ɨmbɨlangʉ-o apite nɨ-e, anɨ abɨ ’gʉ́ naali. Abhomʉ-o, anɨ atsia aha lɨ́lɨ me u nʉ bhʉ́ Beteleme di ne bhʉ́ ndu doto gba nɨ-e hana, amba u bhili ndʉ ongɨsɨ na djedjedje hana nayie bhʉ́ kalanga bhisi akɵ ne kuto. Anɨ aha lɨ́lɨ bhomʉ-o nakpata lele kalanga ɨnde lɨ obhʉlʉ ɨmbɨlangʉ-o aha e pɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abhomʉ-o, engʉ́ ɨnde lɨ polofeta Djelemi apa nanɨ e, atsia amene lɨe. Djelemi apa nanɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«U adje eli bini bhʉ́ kʉtɨ na Lama, oegbá di ne omʉlopolo. A ngaku ’gbá ongɨsɨ gba e bhomʉ-o Lasele. Anɨ kʉnda de me u yoko nɨ-e de, anga ndʉ ongɨsɨ gba anɨ-e hana amu.» ");
INSERT INTO mdm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pɨta lɨ Elode akpi lɨe-e, andjelu bini gba Ebhe Ngámá-a akoto lɨ Djodjefʉ bhʉ́ loto bhʉ́ Edjipeto. ");
INSERT INTO mdm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Anɨ atsia apa pɨ anɨ me: «Yie bhʉ́lá, ha ndɨlɨ-e ne ’hi e, yi holo kpadjɨ, amba yi gie lɨyi ne uo bhʉ́ doto na Ɨsalaele. Padhá de, anga okpála ɨnde adʉ nako nakʉnda nabhɵlɵ ndɨlɨ-e amu.» ");
INSERT INTO mdm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Djodjefʉ ayie bhʉ́lá, anɨ aha ndɨlɨ-e ne ’hi e, anɨ atsia agie lɨe bhʉ́ doto na Ɨsalaele. ");
INSERT INTO mdm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Engʉ́ bini, anɨ adje la lɨe me Alɨkɨlausɨ ne ’ngbé ngámá bhʉ́ ndu doto na Yudaya bhʉ́ da ’dyɨ e Elode-e, anɨ atsia adje tsʉlʉ ngʉ́ nanʉ oo. Ebhe agbele matá ’dje anɨ bhʉ́ loto, anɨ atsia agie lɨe bhʉ́ ndu doto na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Anɨ anʉ asɨ kʉtɨ bhʉ́ gʉdhʉ na Nadjaleta, ngʉbula me engʉ́ ɨnde lɨ opolofeta apa nanɨ e, amene lɨe. Opolofeta apa nanɨ me: «U adʉ́ aꞌɨ́ anɨ me Kpála na Nadjaleta.» ");
INSERT INTO mdm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bhʉ́ oekpɨ́ bhomʉ-o, Djaa bhʉlʉ nabatisa okpála akoto nanɨ abhʉ́ mili bɨlɨ na ndu doto na Yudaya. Anɨ adʉ atotobhɨla me: ");
INSERT INTO mdm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Yi dji bua yi, anga Naʉ na abhʉ́lá akolo masɨkpe!» ");
INSERT INTO mdm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Djaa nanɨ ne kpála ɨnde lɨ polofeta Ɨsaya akpokpo ’ngʉ́ gba e me: «Kpála bini ngatotobhɨla bhʉ́ mili bɨlɨ me: ‹Yi leke kpadjɨ gba Ngámá-o. Yi leke bua yi ngʉ́ nago ka anɨ-o.›» ");
INSERT INTO mdm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Djaa adʉ adyɨ bongo ɨnde u adʉ e lɨ su enʉ, anɨ adʉ agbite ekpʉ́ na kó ’nʉ ludu e. Anɨ atsia adʉ azʉ omakindolo di ne nadha eʉ́. ");
INSERT INTO mdm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abhomʉ-o, okpála na Yelusalema di ne okpála na Yudaya libhomu ne obhende na ndu doto ɨnde lɨngo ngade ’ngu na Djʉlʉdanɨ libhomu adʉ ago nadje engʉ́ ɨnde anɨ adʉ akpokpo e-o. ");
INSERT INTO mdm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","U adʉ ambamba ta osisiti ’ngʉ́ gba o-o kala ndʉ okpála hana. Djaa atsia adʉ abatisa uo bhʉ́ ngade ’ngu na Djʉlʉdanɨ. ");
INSERT INTO mdm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bhiti omʉFalisai di ne oSadukai adʉ ago ngʉ́ nasia batisimo. Lɨ Djaa au lɨe mo-o, anɨ atsia ayi uo me: «Ngayi opiga kpʉlʉ ɨnde-e, a asuno pɨ yi da me yi kpe egʉ́ gba Ebhe ɨnde ngago-o? ");
INSERT INTO mdm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","La-a, yi suno bhʉ́ okulu gba yi-e me yi adji bua yi adji, ");
INSERT INTO mdm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","amba yi ꞌo nabhundja lɨ bhobua yi makpe me: ‹Engʉ́ lɨ ya ade anga Abalahama ne ogbi ya.› Padhá de, anga ma ngapa pɨ yi me, Ebhe tɨ da nagbe ongɨsɨ pɨ Abalahama bhʉ́ ká oteme yi ngau e ɨnde-e mada yi. ");
INSERT INTO mdm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ꞌE-e! Mbɨa ɨnde-e, ngbakpa aꞌo lɨe bhʉ́ li ’dhʉ ondula-a ngʉbula nadodolo. Ndʉ ndula hana ɨnde ɨ lɨ lɨ́lɨ́ na babadha de-e, u adé, u tsia bhíke bhʉ́ djua. ");
INSERT INTO mdm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngama-a, ma ngabatisa yi bhʉ́ engu ngʉ́ nasuno me yi adji bua yi adji. Engʉ́ bini, kpála bhende ɨ ngago pɨta ma-a, ane ma ne angu. Ma la ne mangua tetele kpála dho me ma gbe malɵkɵ bhʉ́ ’dhʉ anɨ-e! Ngaanɨ-e, anɨ abátisa yi ne Bu Bhobua di ne djua. ");
INSERT INTO mdm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anɨ aholo kakpa gba e sa ’kpa e ngʉ́ nape fufukudha bhʉ́ nguwa gba e amba nɨ bu nguwa bhʉ́ ngbokopi. Engʉ́ bini, fufukudha-a, anɨ atsúlu bhʉ́ djua ɨnde na dʉdʉma ne dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Abhomʉ-o, Yesu ayie bhʉ́ Galilaya, anɨ anʉ abhaka Djaa bhʉ́ ngade ’ngu na Djʉlʉdanɨ ngʉ́ nasia batisimo ka anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Djaa di me yala. Anɨ atsia adʉ apa me: «Ma sía mangbo batisimo ka mʉ ngama. Mʉ ngago matá abhaka ma ngamʉ!» ");
INSERT INTO mdm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Engʉ́ bini, Yesu atsia agie pɨ anɨ me: «Zɨba me amene lɨe moko mbɨa ɨnde. Padhá de, anga a ayo me nɨ́ mene ndʉ ’ngʉ́ hana ɨnde lɨ Ebhe ayo e ka nɨ́-o.» Abhomʉ-o, Djaa atsia azɨba me amene lɨe moko. ");
INSERT INTO mdm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lɨ Yesu asia batisimo lɨe, anɨ atsia akoto bhʉ́ ’ngu-o. Me-e, kokpɨ́ abhulu lɨe. Anɨ atsia au Bu Bhobua gba Ebhe-e ngakɵ maka pidjo, a nde ngago pɨ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Abhomʉ-o, eli bini atsia ayie abhʉ́lá ne napa me: «A ɨnde-e ndɨlɨ gba ma na mʉkʉnda-o. A ko kpʉ́kpʉ́ na bua ma.» ");
INSERT INTO mdm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Abhomʉ-o, Bu Bhobua atsia amba bhʉ́la Yesu abhʉ́ mili bɨlɨ ngʉbula me djabʉlʉ le anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pɨta namene ngbɨkpɨ ndjɨkpa badha ne sukpe ndjɨkpa badha mandɨ nazʉ ’he-e, anɨ adje gʉmʉ. ");
INSERT INTO mdm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Djabʉlʉ, kpála ɨnde adji ale anɨ-e atuto lɨe de anɨ. Anɨ atsia apa pɨ anɨ me: «Ɨ dʉ me mʉ nde ne Ndɨlɨ gba Ebhe-e, ha lɨ́lɨ pɨ oteme ɨnde-e me akolo mapa.» ");
INSERT INTO mdm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Engʉ́ bini, Yesu agie me: «U aye bhʉ́ Bhuku me: ‹Kpála kóbho bha bini ka ezʉ de, engʉ́ bini, anɨ akóbho ka ndʉ oeli hana ɨnde ɨ ngakoto bhʉ́ ’bhɵ Ebhe-o.›» ");
INSERT INTO mdm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Abhomʉ-o, Djabʉlʉ aha anɨ, anʉ ne anɨ bhʉ́ Yelusalema, gʉdhʉ na bubu-o. Anɨ atsia aꞌo anɨ pɨ́ tulundjɨ ’ngbé ’tɨ Ebhe gba omaYuda-o. ");
INSERT INTO mdm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Do anɨ pɨ Yesu de me: «Ɨ dʉ me mʉ nde ne ndɨlɨ gba Ebhe-e, ꞌulu mʉ kɵ kuto! Padhá de, anga u aye bhʉ́ Bhuku me: ‹Ebhe ahá lɨ́lɨ pɨ oandjelu gba e ngʉ́ mʉ. U tsia bɨ́ mʉ sa ’kpa o ngʉbula me mo otʉ́ ’dhʉ mʉ lɨ teme bini de.›» ");
INSERT INTO mdm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu apa pɨ anɨ me: «U aye di bhʉ́ Bhuku gba Ebhe-e me: ‹Mo olé Ebhe, Ngámá gba mʉ-o de.›» ");
INSERT INTO mdm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Djabʉlʉ anʉ aꞌo matá anɨ pɨ́ ’ndjá eta na ndjándjá nane mane. Anɨ atsia apana pɨ anɨ ndʉ naʉ na doto hana bhʉ́ dabɨlɨ bini ne sangu gba o-o. ");
INSERT INTO mdm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Anɨ atsia apa pɨ anɨ me: «Ndʉ ’he ɨnde-e hana, ma ahá pɨ mʉ ɨ dʉ me mʉ nde akikita lɨpʉkʉ mʉ kuto kala ma ngʉ́ nadhɵgɵ ma-o.» ");
INSERT INTO mdm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Yie oo ko, Satana ! Padhá de, anga u aye bhʉ́ Bhuku me: ‹Dhɵgɵ Ebhe ’ngbé Ngámá gba mʉ-o, amba mʉ yo la bhadi anɨ kpi e kpi.›» ");
INSERT INTO mdm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Abhomʉ-o, Djabʉlʉ aꞌo ka anɨ. Me-e, oandjelu ago de anɨ, u atsia aholo nateteke anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lɨ Yesu adje lɨe me u aholo Djaa-a, anɨ atsia agbe lɨe ne abhʉ́ ndu doto na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","La-a, anɨ nʉ bhʉ́ kʉtɨ na Nadjaleta de, anɨ anʉ mangbo bhʉ́ Kapalanauma, dengo ekpɵ na Galilaya, bhʉ́ kʉtɨ gba okpála na Djabulona ne Nefɨtali. ");
INSERT INTO mdm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Anɨ amene mo-o ngʉbula me engʉ́ nanɨ lɨ polofeta Ɨsaya apa e amene lɨe. Engʉ́ nanɨ anɨ apa e me: ");
INSERT INTO mdm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ngayi okpála na doto na Djabulona ne Nefɨtali, ne yi okpála na kpadjɨ na ekpɵ, ne yi okpála na kʉtɨ ɨnde ayi ’ngu na Djʉlʉdanɨ, ɨnde akolo mbɨa ɨnde-e okpála na Galilaya ɨnde lɨ ogandji okpála ngadʉlʉ bhʉ́ e-e, yi dje nga engʉ́ ɨnde! ");
INSERT INTO mdm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ngayi okpála ɨnde adʉ́dʉ bhʉ́ biti má ndundulundu-o, yi aú zɨ ’kpɨ́ na ngbéngbé na kuo kuo. A akʉnda napa me zɨ ’kpɨ́ ango-o akóto pɨ yi okpála ɨnde abedhe ndʉ ’kpɨ́ hana ne tsʉlʉ kuo-o.» ");
INSERT INTO mdm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nayie lɨ nedhɨnga bhomʉ-o, Yesu aholo akpokpo mbámbá me: «Yi dji bua yi. Padhá de, anga Naʉ na abhʉ́lá akolo masɨkpe.» ");
INSERT INTO mdm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lɨ Yesu adʉ adhʉkʉ lɨe lɨngo ekpɵ na Galilaya-a, anɨ au obhosɨ bhisi me u nde ngagbe sungu. A adʉ ondaise. A adʉ Simo ɨnde u agisila ’lɨ e me Piele ne ndai e Andɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Anɨ atsia apa pɨ uo me: «Yi go kpata ma, amba ma mene me yi dʉ ɨbili nagɨlɨ okpála pɨ Ebhe maka yi agbegbe osungu lɨe-o.» ");
INSERT INTO mdm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma gala kolo me-e, u abala ’kpa lɨ onado gba o-o, u atsia anʉ ne uo. ");
INSERT INTO mdm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu adyudyo matá lɨe ne kalanʉ, anɨ au obhosɨ koko bhisi, a adʉ Djakɨ ne uo ne ndai e Djaa , ongɨsɨ gba Djebedayo-o. U adʉ bhʉ́ zabʉ gba o bhʉ́ dabɨlɨ bini ne ’dyɨ o me u nde ngaleke onado gba o-o. Anɨ aꞌɨ uo me u go kpata nɨ. ");
INSERT INTO mdm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma gala me-e, u aꞌo ka ’dyɨ o ne zabʉ gba o-o. U atsia anʉ ne uo. ");
INSERT INTO mdm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Abhomʉ-o, Yesu adhʉkʉ bhʉ́ Galilaya libhomu. Anɨ adʉ asuno bhʉ́ oetɨ nadje lɨ́lɨ gba Moidje ɨnde na ndu doto bhomʉ-o. Anɨ adʉ di akpokpo Bádha Ngali Naʉ na abhʉ́lá-o. Anɨ atsia adʉ di akobho ndʉ okuo hana di ne ndʉ eze hana lɨ okpála adʉ ne e-o. ");
INSERT INTO mdm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Abhomʉ-o, ngali gba anɨ ayangba bhʉ́ ndu doto na Silia libhomu. U atsia ago pɨ anɨ ne okpála ɨnde adʉ ne okuo ngangá-a hana: obhende lɨ osisiti bua adʉ ato mbolo lɨ o, obhende lɨ kuo nagbʉlʉ magbʉlʉ adʉ amene o, ne obhende na eze. Anɨ atsia akobho uo. ");
INSERT INTO mdm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Abhomʉ-o, okpála bhelé ɨnde ayie bhʉ́ Galilaya, ne bhʉ́ ogʉdhʉ Ndjɨkpa, ne bhʉ́ Yelusalema, ne bhʉ́ Yudaya la di ne ayi ’ngu na Djʉlʉdanɨ atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lɨ Yesu au bhiti okpála lɨe-e, anɨ aꞌʉ apɨ́ ’ta. Anɨ adʉ kuto, omʉkpata gba anɨ-e atsia adyudyo lɨo de anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Abhomʉ-o, anɨ aholo nasuno pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«A ko djalɨ pɨ okpála ɨnde ngau lɨo padhá kala Ebhe, anga ngauo-o, Naʉ na abhʉ́lá-a pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","A ko djalɨ pɨ obhende ngaku ’gbá, anga ngauo-o, Ebhe akúo ngʉla sala uo ngae. ");
INSERT INTO mdm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A ko djalɨ pɨ obhende na bhʉkʉ bua, anga ngauo-o, u agbógbo bhʉsʉ o lɨ doto ɨnde lɨ Ebhe apana e pɨ uo-o. ");
INSERT INTO mdm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A ko djalɨ pɨ obhende akʉnda bha ndjʉ namene ngbili ’ngʉ́ , anga ngauo-o, Ebhe améne me u dʉ bedhe ngʉ́ namemene. ");
INSERT INTO mdm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A ko djalɨ pɨ obhende ngadje ndjinga okpála koko, anga ngauo-o, Ebhe adjé ndjinga uo. ");
INSERT INTO mdm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A ko djalɨ pɨ obhende bubu lɨ bua o, anga ngauo-o, u aú Ebhe. ");
INSERT INTO mdm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","A ko djalɨ pɨ obhende ngato guo ’ngʉ́ sʉnda okpála, anga ngauo-o, u aꞌɨ́ uo me ongɨsɨ gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","A ko djalɨ pɨ obhende u ngato mbolo lɨ o ka anga u ngamene ngbili ’ngʉ́, anga ngauo-o, Naʉ na abhʉ́lá-a pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","A ko djalɨ pɨ yi ɨ dʉ me okpála nde ngasobho yi, u nde ngato mbolo lɨ yi, u nde di ngapa ndʉ sisiti ’ngʉ́ lɨ yi hana ne eu ka yi abhuka ma lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yi mbɨla me, u ato bhadi nanɨ mbolo lɨ opolofeta na kalanʉ-o moko. Kaka-a, yi dʉ bhʉ́ djalɨ, amba yi dʉ di bhʉ́ ndjɨlɨ, anga makalá gba yi ɨnde abhʉ́lá-a adʉ́ ngbéngbé.» ");
INSERT INTO mdm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ngayi-e, yi ne ngʉtʉ na pɨ́la doto. Ɨ dʉ la me ngʉtʉ nde andapa-a, a akólo matá dédé lele pɨ? A matá lɨ kulu ade. A ayo bha ɨbili nababala kilidjo, lɨ okpála tsia dédele ne ’dhʉ o. ");
INSERT INTO mdm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ngayi-e, yi ne zɨ ’ke na pɨ́la doto. Gʉdhʉ ɨnde ayiki lɨe pɨ́ eta-a, a awó lɨe belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","U dhedhe eke-e, a ko ngʉ́ naꞌoꞌo asa lʉsa de. Engʉ́ bini, a ko ngʉ́ naꞌoꞌo apɨ́ misa ngʉbula me aziga ndʉ okpála ɨnde abhʉ́ ’tɨ-e hana. ");
INSERT INTO mdm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","A bhadi pɨ yi moko. A ayo me zɨ yi suno lɨe bhʉ́ djila ndʉ okpála hana ngʉbula me u u babadha kulu gba yi-e, u de dhɵgɵ ’Dyɨ yi ɨnde abhʉ́lá-o.» ");
INSERT INTO mdm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Yi abhúndja de me ma ago ngʉ́ nabhɵlɵ lɨ́lɨ gba Moidje di ne me ma ago nabhɵlɵ nasuno gba opolofeta-a de. Ma go ngʉ́ nabhɵbhɵlɵ de. Engʉ́ bini, ma ago mangbo ngʉbula nambamba tata hana. ");
INSERT INTO mdm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ma apa pɨ yi na paká me: abana lɨ kokpɨ́ ne doto bhue bha pɨ-ie, ndʉ ’ngʉ́ hana ɨnde bhʉ́ lɨ́lɨ gba Moidje-e, améne lɨe. U bʉ́lʉ belegʉ mboye ’dhʉ balʉa, ɨ dʉ di-e mboye ’kpʉ́ balʉa bini bhʉ́bhʉ́ de, nakolo bha lɨ sokpɨ́. ");
INSERT INTO mdm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaka-a, kpála bhende ɨ gʉmʉ mboye ’ngʉ́ bhʉ́ ká olɨ́lɨ gba Moidje-e, anɨ suno la di pɨ okpála koko namene mo-o, anɨ adʉ́ kpála na yeye bhʉ́ Naʉ na abhʉ́lá. Engʉ́ bini, kpála bhende ɨ lila-a, anɨ nde di ngasusuno pɨ okpála koko-o, anɨ adʉ́ kpála na ngbéngbé bhʉ́ Naʉ na abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ma pa pɨ yi mo-o padhá de, anga lɨ ngbili ’ngʉ́ gba yi-e dʉ ngbéngbé nane bhende gba omʉsuno na lɨ́lɨ gba Moidje ne omʉFalisai-e mane de-e, yi tɨ da nalɨ bhʉ́ Naʉ na abhʉ́lá-a de.» ");
INSERT INTO mdm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Yi adje me u apa nanɨ pɨ onguo ogbi yi me: ‹Mo obhɵ́lɵ kpála de. Kpála bhende ɨ bhɵlɵ kpála bhʉ́ gandji-e, a ayo me u gbe anɨ kala Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda .› ");
INSERT INTO mdm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Engʉ́ bini, ngama-a, ma ngapa pɨ yi me: kpála bhende ɨ bɨ ’gʉ́ ne ndai e, a ayo me u gbe anɨ bhʉ́ tilibinale. Kpála bhende ɨ pa pɨ ndai e me: ‹Mʉ ne ngingi›, a ayo nagbe anɨ kala Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda-o. Kpála bhende ɨ sobho ndai e me: ‹Mʉ ne bhʉlʉ pele›, a ayo me u bhike anɨ bhʉ́ dé djua na dʉdʉma-o. ");
INSERT INTO mdm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ɨ dʉ me mʉ nde adji naha makiso pɨ Ebhe lɨ bɨlɨ natsulu enʉ pɨ anɨ-e, ɨ dʉ la me mʉ nde abhundja me nɨ amene siti ’ngʉ́ lɨ pabɨlɨ gba ndai nɨ-e, ");
INSERT INTO mdm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mʉ de ꞌo ka makiso gba mʉ-o kala bɨlɨ natsulu enʉ-o oo, amba mʉ gie ngaɨza lɨmʉ nato guo ’ngʉ́ sʉnda yi ne ndai mʉ. Pɨpɨta la-a, mʉ go ha makiso gba mʉ-o pɨ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ɨ dʉ di me kpála nde akʉnda nagbe mʉ kala odjudji-e, yi de dje kolo lɨyi ne anɨ me yi nde nga bha lɨ kpadjɨ, ngʉbula nalila me kpála yi nde ne e bhʉ́ ’ngʉ́-o agbe mʉ bhʉ́ tilibinale de, amba djudji aꞌɨ́ polisi de me anɨ to mʉ bhʉ́ tɨkpʉ-o de. ");
INSERT INTO mdm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ma apa pɨ mʉ na paká me, mʉ tɨ da nakoto oo padhá de ɨ dʉ me mʉ nde di mangɨmbo bhomʉ-o nakolo lɨ senge na soso-o de ko.» ");
INSERT INTO mdm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Yi adje me u apa nanɨ me: ‹Mo okʉ́nda bhoko, ɨ dʉ di-e ɵlɵ koko de.› ");
INSERT INTO mdm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Engʉ́ bini, ngama-a, ma apa pɨ yi me: kpála bhende ɨ tsia ɵlɵ koko ne gʉmʉ anɨ-e, kpála ango-o akʉnda ɵlɵ ango-o lɨ bhobua e akʉnda. ");
INSERT INTO mdm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ɨ dʉ me lɨ́ djila mʉ na kokpa nde ngato mʉ bhʉ́ siti ’ngʉ́-o, mʉ de gbe, mʉ bhike de mʉ tsutsu. Padhá de, anga nakpi ka yá mʉ bini-e, a pɨ mʉ ndjɨndjɨ ane me u bhike ’lá mʉ libhomu bhʉ́ djua na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ɨ dʉ la di me ’kpa mʉ na kokpa nde ngato mʉ bhʉ́ siti ’ngʉ́-o, mʉ de kodho, mʉ bhike de mʉ tsutsu. Padhá de, anga nakpi ka yá mʉ bini-e, a pɨ mʉ ndjɨndjɨ ane me u bhike ’lá mʉ libhomu bhʉ́ djua na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«U apa di nanɨ me: ‹Ɨ dʉ me kpála bini nde agie wala e-e, a ayo me anɨ ye balʉa ɨnde lɨ ongámásɨ adéle ’kpa o bhʉ́ e pɨ anɨ. Balʉa ango-o asúno ngae me anɨ atse anɨ atse.› ");
INSERT INTO mdm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Engʉ́ bini, ngama-a, ma apa pɨ yi me, kpála bhende ɨ ꞌe wala e me anɨ nde holo anɨ ne bhoko koko de-e, anɨ ngakata anɨ bhʉ́ nakʉnda bhoko koko. A akʉnda napa me, kpála bhende ɨ ha ɵlɵ ɨnde lɨ bhoko koko agie e, anɨ akʉnda bhomʉ-o ɵlɵ gba kpála koko.» ");
INSERT INTO mdm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Yi adje matá nanɨ me u apa pɨ onguo ogbi nɨ́ me: ‹Mo ogúlu silika mo otʉ e de. Engʉ́ bini, mene engʉ́ mo otʉ silika lɨ e kala Ngámá-o.› ");
INSERT INTO mdm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","La ngama-a, ma apa pɨ yi me, yi atʉ silika belegʉ de bini: yi atʉ́ silika ne ’lɨ kokpɨ́ de, anga a bhomʉ-o bɨlɨ lɨ Ebhe ngadʉ lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yi atʉ́ silika ne ’lɨ doto de, anga a ko bɨlɨ ɨnde anɨ ngaꞌo ’dhʉ e lɨ e ko. Yi atʉ́ silika ne ’lɨ Yelusalema de, anga a ko gʉdhʉ gba Ebhe, ’Ngbé Ngámá. ");
INSERT INTO mdm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mo otʉ́ la di silika ne ’lɨ ’ndjɨ mʉ de, anga mʉ tɨ da nadji lɨ́ sundjo mʉ bini de me akolo bubu, ɨ dʉ di-e bɨbɨlɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ɨ dʉ me yi nde ngagama ’ngʉ́-o, yi de pa bha me: ‹A moko›, di ne me ‹A mo-o ade.› Padhá de, anga ndʉ ongʉ́ bhe pépé-e hana ayie ka Djabʉlʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Yi adje nanɨ me u apa me: ‹Lɨ kpála dʉ djila mʉ-o, mʉ de dʉ di djila anɨ›, u apa di me: ‹Lɨ kpála gʉmʉ ’te mʉ-o, mʉ de gʉmʉ di ’te anɨ.› ");
INSERT INTO mdm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","La ngama-a, ma apa pɨ yi me, ɨ dʉ me kpála nde amene siti ’ngʉ́ lɨ yi-e, yi agísila de. Engʉ́ bini, ɨ dʉ me kpála bini nde asʉ pabhɵ mʉ na kokpa-a, mʉ de dji di pabhɵ mʉ na galɨ-e pɨ anɨ, amba anɨ sʉ di. ");
INSERT INTO mdm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ɨ dʉ me kpála bini nde akʉnda nagbe mʉ bhʉ́ ngbanga ngʉbula simisi gba mʉ-o, mʉ de ꞌo di ká koti gba mʉ-o pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɨ dʉ me kpála nde aholo mʉ ne kpéke me mʉ bɨ ’he gba nɨ-e ngʉbula kilometele bini-e, mʉ de bɨ bha ɨbili pɨ anɨ ngʉ́ kilometele bhisi. ");
INSERT INTO mdm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɨ dʉ me kpála nde ayo ’he ka mʉ-o, mʉ de ha pɨ anɨ. Ɨ dʉ me kpála nde ayo bopulu ka mʉ-o, mʉ de ha pɨ anɨ. Mo oyála naha bopulu pɨ kpála ɨnde akʉnda nayoyo ka mʉ-o de.» ");
INSERT INTO mdm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Yi adje me u apa nanɨ me: ‹Kʉnda kilí mʉ, amba mʉ yala bhʉlʉ yala gba mʉ-o.› ");
INSERT INTO mdm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Engʉ́ bini, ngama-a, ma apa pɨ yi me, yi kʉnda obhʉlʉ yala gba yi ko. Yi yo Ebhe pɨ obhende ngato mbolo lɨ yi-o. ");
INSERT INTO mdm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yi mene mo-o, yi dʉ́ ne kʉkʉlʉ ongɨsɨ gba ’Dyɨ yi ɨnde abhʉ́lá-o. Padhá de, anga anɨ ngagbe zɨndjɨla gba e pɨ́ osisiti okpála di ne pɨ́ obabadha okpála. Anɨ ngatuko ebha pɨ́ okpála na ngbingbili di ne pɨ́ obhende na ngbingbili ade ko. ");
INSERT INTO mdm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ma pa mo-o padhá de, anga ɨ dʉ me yi nde ngakʉnda bha obhende ngakʉnda yi-e, yi asía tété mangua makalá dho? Ondɵmbɨ na mandjandja bhadi ngamemene moko! ");
INSERT INTO mdm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ɨ dʉ la di me yi nde ngayi bha bini ondaise yi-e, yi ngamene bhomʉ-o mangua ngamba ’ngʉ́ dho? Omʉpagano bhadi ngamemene moko. ");
INSERT INTO mdm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","La ngayi-e, yi dʉ ngbingbili bhʉ́ ndʉ ’ngʉ́ hana maka lɨ ’Dyɨ yi ɨnde abhʉ́lá-a nde lɨe ngbingbili ko.» ");
INSERT INTO mdm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Yi lila lɨyi me yi améne bádha ’ngʉ́ gba yi-e kala okpála de me u u yi mau-o de. Ɨ dʉ mo-o de-e, yi sía makalá ka ’Dyɨ yi ɨnde abhʉ́lá-a de. ");
INSERT INTO mdm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nedhɨnga ɨnde mʉ ngapʉ ’he lɨe pɨ bhʉlʉ ndɨbhɨlɨ-e, mo oméne de me nɨ bhɨ tété makpɵ maka lɨ obhʉlʉ kali amemene lɨe bhʉ́ otɨ nadje lɨ́lɨ gba Moidje di ne lɨ ohi kpadjɨ-e de. U memene mo-o ngʉbula me okpála dhɵgɵ o. Ma apa pɨ yi na paká me u asia makalá gba o asia. ");
INSERT INTO mdm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","La pɨ mʉ-o, nedhɨnga mʉ ngapʉ ’he lɨe pɨ bhʉlʉ ndɨbhɨlɨ-e, a ayo de me ’kpa mʉ na galɨ-e mbɨla ehe ɨnde lɨ ’kpa mʉ na kokpa ngamene e de. ");
INSERT INTO mdm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A moko, a ayo me napʉ ’he gba mʉ-o tigala bhʉ́ pepe, amba ’Dyɨ mʉ ɨnde ngau ’kpɨ́ bhʉ́ pepe-e gie pɨ mʉ ngae.» ");
INSERT INTO mdm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Nedhɨnga yi ngayo Ebhe lɨe, yi adʉ́ maka obhʉlʉ kali de. Padhá de, anga u kʉkʉnda nayo Ebhe me u nde alʉ malʉ bhʉ́ otɨ nadje lɨ́lɨ gba Moidje di ne lɨ odi-kpadjɨ, amba okpála dʉ au o mau. Ma apa pɨ yi na paká me u asia makalá gba o asia. ");
INSERT INTO mdm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","La pɨ mʉ-o, nedhɨnga mʉ ngayo Ebhe lɨe, a ayo me lɨ bhʉ́ tɨna ’tɨ gba mʉ-o. Dho bhɵbhɵ nganda mʉ madho, amba mʉ yo ’Dyɨ mʉ ɨnde lɨ bɨlɨ na pepe bhomʉ-o. Abhomʉ-o, ’Dyɨ mʉ ɨnde a uu ’kpɨ́ bhʉ́ pepe hana-a, tsia há makalá pɨ mʉ ngae. ");
INSERT INTO mdm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nedhɨnga yi ngayo Ebhe lɨe, yi agíe lɨyi pɨ́ oeli bini bhʉtsibhʉtsi maka omʉpagano de. Padhá de, anga u ngabhundja me Ebhe adjé o ɨ dʉ me o nde ngakpokpo kambɨ oeli. ");
INSERT INTO mdm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yi améne maka uo de, anga ’Dyɨ yi mbɨla ehe yi nde ne gʉmʉ e hana kala me yi yo ka anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ngayi-e, yi yoyo Ebhe me: ‹’Dyɨ ya ɨnde abhʉ́lá, a ayo me kpála ne kpála mbɨla me, mʉ ne Ebhe ɨnde bubu. ");
INSERT INTO mdm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A ayo me mʉ go ʉ ngámá pɨ́la doto. A ayo me kpála ne kpála pɨ́la doto mene mʉkʉnda gba mʉ-o maka ɨ ngamene lɨe lɨe abhʉ́lá ko. ");
INSERT INTO mdm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ha ezʉ ɨnde atɨ ne ya lɨ ’kpɨ́ na nakɨ-e pɨ ya. ");
INSERT INTO mdm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ꞌE siti ’ngʉ́ gba ya ɨnde ya amene e lɨ pabɨlɨ gba mʉ-o. Padhá de, anga ngaya makpe ya ngambu di lɨ obhende ngamene osisiti ’ngʉ́ lɨ pabɨlɨ gba ya-o. ");
INSERT INTO mdm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɨ dʉ me ya nde alɨ bhʉ́ nale-e, mo oꞌó de me ya mene siti ’ngʉ́-o de. Engʉ́ bini, lila ya sakpa Djabʉlʉ malila. Padhá de, anga Naʉ ne angu la di ne sangu , a ko naamʉ ’he, dʉdʉma ne dʉdʉma. A adʉ moko.› ");
INSERT INTO mdm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ɨ dʉ me yi nde ngambu lɨ osisiti ’ngʉ́ gba okpála-a, ’Dyɨ yi ɨnde abhʉ́lá-a aꞌé bhadi osisiti ’ngʉ́ gba yi-e moko. ");
INSERT INTO mdm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Engʉ́ bini, ɨ dʉ me yi nde mbu lɨ osisiti ’ngʉ́ gba okpála de-e, ’Dyɨ yi ꞌé di osisiti ’ngʉ́ gba yi-e de.» ");
INSERT INTO mdm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Nedhɨnga yi ngatse ’zʉ lɨe ngʉ́ nayo Ebhe-e, yi aná bhʉ́la yi maka obhʉlʉ kali amemene lɨe de. U memene mo-o ngʉ́ nasuno pɨ okpála me o ngatse ’zʉ ngʉ́ nayo Ebhe. Ma apa pɨ yi na paká me u asia makalá gba o asia. ");
INSERT INTO mdm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","La pɨ mʉ-o, nedhɨnga mʉ ngatse ’zʉ lɨe ngʉ́ nayo Ebhe-e, vʉlʉ bhʉ́la mʉ, amba mʉ pulu ne emʉ ndjɨndjɨ, ");
INSERT INTO mdm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","amba okpála ambɨ́la de me mʉ ngatse ’zʉ-o de. ’Dyɨ mʉ ɨnde ne ndʉ bɨlɨ hana, abana bhʉ́ bɨlɨ na pepe-e, mbɨla bha ngae kpi e kpi. Abhomʉ-o, ’Dyɨ mʉ ɨnde a uu ’kpɨ́ bhʉ́ pepe hana-a, tsia há makalá pɨ mʉ ngae.» ");
INSERT INTO mdm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Yi apó bhʉ́la tɨa pɨ yi pɨ́la doto ɨnde-e de. Padhá de, anga yi po bhʉ́la tɨa pi yi ei-e, opálanga ne mbelende síti, lɨ obhʉlʉ ’zi dʉ́dʉ pabu ’tɨ-e, u tsia zí. ");
INSERT INTO mdm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Engʉ́ bini, yi po mangbo bhʉ́la tɨa pɨ yi abhʉ́lá. Padhá de, anga oo, opálanga ne mbelende ngʉ́ nasisiti ade, obhʉlʉ ’zi di ngʉ́ nadʉdʉ pabu ’tɨ-e me u zi-e ade. ");
INSERT INTO mdm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Padhá de, anga bɨlɨ ɨnde lɨ tɨa gba mʉ nde lɨe, bua mʉ dʉ́ bhadi oko.» ");
INSERT INTO mdm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Djila kpála ne zɨ ’ké na kʉte anɨ. Ɨ dʉ me djila mʉ nde ndjɨndjɨ-e, kʉte mʉ libhomu dʉ́ lɨ zɨ ’kpɨ́. ");
INSERT INTO mdm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Engʉ́ bini, ɨ dʉ lɨ djila mʉ ne kuo-o, kʉte mʉ libhomu dʉ́ bhʉ́ biti. Ɨ dʉ me zɨ ’kpɨ́ ɨnde mʉ ngabhundja me a bhʉ́ nɨ-e nde biti-e, biti ango-o né la matá dada mane.» ");
INSERT INTO mdm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Kpála bini tɨ da namene kulu pɨ ongámásɨ bhisi de. A akʉnda napa me, anɨ ú bhe bini-e padhá, anɨ tsia tsé anɨ, anɨ kʉ́nda bhe koko-o, anɨ tsia dhɨ́ka lɨ anɨ. Yi tɨ da nadʉ bali pɨ Ebhe ne pɨ tɨa bhʉ́ nedhɨnga bini de. ");
INSERT INTO mdm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kaka-a, ma apa pɨ yi me, yi aꞌó bua yi abhʉ́lá ngʉbula mʉkobho gba yi-e de. Yi adʉ́ akina lɨyi de me ya azʉ́ sɨ nɨ, di ne me ya andjɨ́ sɨ nɨ-ie de. Mʉkobho gba kpála ane ezʉ mane adɨ? Yi akína di lɨyi de me ya adyɨ́ sɨ nɨ-ie de. Kʉte kpála ane bongo mane adɨ? ");
INSERT INTO mdm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yi tsia nga maka lɨ odhu nde lɨe abhʉ́lá: u lulu ’dyɨ de, u gbegbe di nguwa abhiye de, u ꞌoꞌo la di ’he bhʉ́ ngbokopi de. Engʉ́ bini, ’Dyɨ yi ɨnde abhʉ́lá-a ngakʉ uo! La ngayi-e, yi ane uo ne tata. ");
INSERT INTO mdm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A ko da bhʉ́ ka yi ka nakina lɨe ɨ tɨ da naꞌo mbo ekpɨ́ koko pɨ́ mʉkobho gba e? ");
INSERT INTO mdm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ka nɨ la yi ngabhɵlɵ bua yi lɨe lɨ ’ngʉ́ na bongo-o? Yi tsia nga maka lɨ ofelele ngabhele lɨe abhiye: u memene kulu de, u dʉdʉ di bongo de. ");
INSERT INTO mdm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma apa la pɨ yi me, abana ’ngbé ngámá Salomo bhʉ́ ká tɨa gba e hana-a, anɨ dyɨ belegʉ nanɨ bongo maka sʉka uo de. ");
INSERT INTO mdm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɨ dʉ me Ebhe nde ngato bongo lɨ ulu ɨnde abhiye mo-o, ulu ɨnde nakɨ oo-o, ɨnde u abhíke la mambi e bhʉ́ djua-a, anɨ méne pɨ yi ane mane dɨ? Nabhuka gba yi-e yeye mo-o ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ka ’ngʉ́ ango-o, yi akína lɨyi de me: ‹Ya azʉ́ nɨ? Ya andjɨ́ nɨ? Ya adyɨ́ lɨ ya mangua bongo dho?› ");
INSERT INTO mdm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ndʉ ongʉ́ bhomʉ-o hana, omʉpagano ngagɨgɨlɨ ngao. U gɨlɨ ne ndala de. La-a, ’Dyɨ yi ɨnde abhʉ́lá-a, mbɨla ndjɨndjɨ me yi ne gʉmʉ ndʉ ’he bhomʉ-o hana. ");
INSERT INTO mdm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yi gɨlɨ ngaɨza Naʉ gba Ebhe-e bhʉ́ dabɨlɨ bini ne namene ngbili ’ngʉ́ ɨnde anɨ akʉnda e-o. Pɨpɨta-a, lɨ Ebhe tsia há di ndʉ oehe koko bhomʉ-o hana pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kaka-a, bua yi angámba lɨ ’ngʉ́ na mambi de. Mambi abhúndja ’ngʉ́ gba e ngae. A lɨ ekpɨ́ bini ne bini ne lɨkabhu ɨnde atɨ ne e.» ");
INSERT INTO mdm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Yi akódho ’ngʉ́ gba okpála koko de, amba Ebhe akódho di engʉ́ gba yi-e de. ");
INSERT INTO mdm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Padhá de, anga lele maka yi ngakodho ’ngʉ́ gba okpála koko lɨe, Ebhe akódho bhadi engʉ́ gba yi-e moko. La di-e, anɨ améne bhadi pɨ yi maka yi ngamemene lɨe pɨ okpála koko-o. ");
INSERT INTO mdm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ka nɨ mʉ ngau mboye kʉ mʉsoli ɨnde bhʉ́ djila ndai mʉ-o lɨe, mʉ nde u la pála ndula ɨnde bhʉ́ djila mʉ-o de? ");
INSERT INTO mdm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Lele pɨ mʉ tɨ da napa pɨ ndai mʉ lɨe me: ‹Djedjeke, ma go gbe kʉ mʉsoli ɨnde bhʉ́ djila mʉ bhomʉ-o›, me a nde bhʉ́ djila mʉ ne pála ndula-a? ");
INSERT INTO mdm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Bhʉlʉ kali, gbe ngaɨza pála ndula ɨnde bhʉ́ djila mʉ-o, amba pɨpɨta-a, mʉ tsia ú la ’kpɨ́ ndjɨndjɨ ngʉ́ nagbe mboye kʉ mʉsoli ɨnde bhʉ́ djila ndai mʉ ko. ");
INSERT INTO mdm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yi ahá ehe na bubu gba Ebhe-e pɨ obʉlʉ de, anga ɨ dʉ mo-o de-e, u gó sisidha yi má tsʉe tsʉe! Yi abála omayaka gba yi na tɨa bhelé-e pɨ opame de, ngʉ́ nakpe me u anʉ́ adedele ne ’dhʉ o de.» ");
INSERT INTO mdm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Yi yo ’he, amba u ha pɨ yi. Yi gɨlɨ ’he, amba yi sia. Yi bhɨ bhotɨ, amba u ꞌʉ pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Padhá de, anga kpála bhende ngayo ’he ngasisia. Kpála bhende ngagɨlɨ ’he ngauu. Kpála bhende ngabhɨ bhotɨ-e, u ngaꞌʉꞌʉ pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bhʉ́ ká yi-e, a ko da ɨnde ɨ dʉ me ndɨlɨ gba anɨ-e nde ayo mapa ka anɨ-e, anɨ tsia há pɨ anɨ teme? ");
INSERT INTO mdm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ɨ dʉ di-e me ndɨlɨ nde ayo sungu ka ’dyɨ e, anɨ tsia há pɨ anɨ kpʉlʉ? ");
INSERT INTO mdm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɨ dʉ la me, ngayi okpála-kʉtɨ ɨnde sisiti-e, yi nde ambɨla naha ohe na babadha pɨ ongɨsɨ gba yi-e, lele pɨ lɨ ’Dyɨ yi ɨnde abhʉ́lá-a há ohe na babadha lɨe pɨ obhende ngayoyo ka anɨ-e de-e?» ");
INSERT INTO mdm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Ndʉ ’ngʉ́ hana ɨnde yi ngakʉnda me okpála mene e pɨ yi-e, yi mene di engʉ́ ango-o pɨ uo. A bhomʉ-o engʉ́ ɨnde lɨ lɨ́lɨ gba Moidje apa e, la di ne ongʉ́ ɨnde lɨ opolofeta aye e-o.» ");
INSERT INTO mdm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","«Yi lɨ lɨ bhotɨ bhende na mbomboye ko! Padhá de, anga a ngato kpála bhʉ́ mʉkobho ngae. La-a, kpadjɨ ango-o dada kpekpeke. Kaka-a, okpála ngalɨ lɨ kpadjɨ ango-o bhelé ade. Yi alɨ́ lɨ bhotɨ bhende na ngbéngbé-e de. Padhá de, anga a ngato kpála bhʉ́ ngɨta ngae. La-a, dada kpekpeke ade. Kaka-a, okpála bhelé ngagbida lɨ kpadjɨ ango-o.» ");
INSERT INTO mdm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Yi lila lɨyi ka opolofeta na eu-o malila. Padhá de, anga u ngago agba yi me u nde adyɨ kó kandɵlɵ, engʉ́ bini, abhʉ́ uo-o, a ko onʉte. ");
INSERT INTO mdm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yi ambɨ́la uo lɨ okulu gba o-o. U koko manga lɨ ondula na eti de. U koko la di malɨbhombi lɨ kobe de. ");
INSERT INTO mdm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","A moko, ndula na babadha ngalɨ bhadi olɨ́lɨ́ na babadha. Engʉ́ bini, ndula na sisiti ngalɨ bhadi olɨ́lɨ́ na sisiti. ");
INSERT INTO mdm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ndula na babadha tɨ da nalɨ olɨ́lɨ́ na sisiti de, la di-e, ndula na sisiti tɨ da nalɨ olɨ́lɨ́ na babadha de. ");
INSERT INTO mdm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ndʉ ndula hana ɨnde ɨ lɨ lɨ́lɨ́ na babadha de-e, u adé, u tsia bhíke bhʉ́ djua. ");
INSERT INTO mdm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","A moko, yi ambɨ́la opolofeta na eu lɨ okulu gba o-o.» ");
INSERT INTO mdm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«A ko de me okpála bhende ngapa mʉma me ‹Ngámá, Ngámá-a!› alɨ́ ndʉ o hana bhʉ́ Naʉ na abhʉ́lá-a de. Engʉ́ bini, a alɨ́ bha bini ne obhende ngamene engʉ́ ɨnde lɨ ’Dyɨ ma ɨnde abhʉ́lá-a ngakʉnda e ko. ");
INSERT INTO mdm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lɨ ’kpɨ́ nakodho ’ngʉ́-o, okpála bhelé apá mʉma me: ‹Ngámá, Ngámá, ya mene nanɨ kulu na polofeta ne ’lɨ mʉ dɨ? Ya pandja nanɨ osisiti bua bhʉ́ okpála ne ’lɨ mʉ dɨ? Ya mene nanɨ ongamba ’ngʉ́ bhelé ne ’lɨ mʉ dɨ?› ");
INSERT INTO mdm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","La-a, ma tsia gíe pɨ uo me: ‹Ngayi obhʉlʉ namene siti ’ngʉ́ ɨnde-e, ma mbɨla nanɨ yi belegʉ de bini. Yi gbe lɨyi de ma tsutsu!›» ");
INSERT INTO mdm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«A moko, ndʉ kpála hana ɨnde adje eli ɨnde ma apa e, anɨ atsia amene maka lɨ eli ango-o apa lɨe, anɨ maka kpála na ɨmbɨlangʉ ɨnde aꞌo ’dhʉ ’tɨ gba e pɨ́ teme. ");
INSERT INTO mdm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ebha adhɨ, engu asi, anvi ago ne engu-o, a atsia atʉ lɨe lɨ kʉte etɨ-o. La-a, etɨ-e tɨ de, anga odhʉdhʉ adʉ me a nde pɨ́ teme. ");
INSERT INTO mdm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Engʉ́ bini, ndʉ kpála hana ɨnde adje eli ɨnde ma apa e, anɨ tsia mene maka lɨ eli ango-o apa lɨe de-e, anɨ maka kpála bini na ngingi ɨnde ayiki etɨ gba e pɨ́ sike. ");
INSERT INTO mdm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ebha adhɨ, engu asi, anvi ago ne engu-o, a atʉ lɨe lɨ kʉte etɨ bhomʉ-o. Etɨ ango-o atuko kuto, a atsia atsambala hana!» ");
INSERT INTO mdm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lɨ Yesu andjia nakpo ongʉ́ bhomʉ-o lɨe, ndʉ okpála hana atsia angamba lɨ nasuno gba anɨ-e naali. ");
INSERT INTO mdm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Padhá de, anga anɨ dʉ nasuno pɨ uo maka omʉsuno na lɨ́lɨ gba uo-o de. Engʉ́ bini, anɨ adʉ asuno pɨ uo maka ngámá. ");
INSERT INTO mdm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lɨ Yesu akɵ eta-a lɨe, okpála bhelé atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Abhomʉ-o, bhʉlʉ kába bini adyudyo lɨe, anɨ atʉtʉ lɨpʉkʉ e kuto kala anɨ. Anɨ atsia apa me: «Ngámá, ɨ dʉ me mʉ nde akʉnda-a, mʉ tɨ da nakobho ma.» ");
INSERT INTO mdm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ato ’kpa e, anɨ ꞌo lɨ kʉte anɨ ne napa me: «Ma akʉnda moko, kokobho!» Ma ’li ma me-e, kába agʉlʉ bha kolo lɨ anɨ hana. ");
INSERT INTO mdm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Gbo dje mʉ, mo opá ’ngʉ́ ɨnde-e pɨ kpála bini de. Engʉ́ bini, nʉ suno bha lɨmʉ pɨ dimandɵ gba Ebhe , amba mʉ ha makiso maka lɨ lɨ́lɨ gba Moidje apa lɨe ngʉbula nasuno pɨ okpála me mo okobho.» ");
INSERT INTO mdm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Abhomʉ-o, Yesu alɨ bhʉ́ kʉtɨ na Kapalanauma. Anɨ adʉ alɨ lɨe oo, ngámá bini gba osʉdha na Loma adyudyo lɨe de anɨ. Anɨ atsia akikiliki lɨe pɨ anɨ ");
INSERT INTO mdm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","me: «Ngámá, kpála na kulu gba ma-a asɨ kuto abhʉ́ ’tɨ. Anɨ agʉgʉmʉ kuto, anɨ ngadje lɨkabhu na kuo kuo.» ");
INSERT INTO mdm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu apa pɨ anɨ me: «Ngama-a, ma adji akobho anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Engʉ́ bini, ngámá gba osʉdha-a atsia agie me: «Ngámá, ma ne tetele kpála ade, ngʉbula me mʉ lɨ bhʉ́ ’tɨ gba ma-o. La-a, mʉ pa bha koli eli bini-e, lɨ kpála na kulu gba ma-a kóbho. ");
INSERT INTO mdm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Padhá de, anga ngama makpe-e, ma sa lɨ́lɨ gba ngámá, ma la di ngaha lɨ́lɨ pɨ osʉdha. Ma pa pɨ bhe bini-e me: ‹Nʉnʉ!› Anɨ nʉ́. Ma pa pɨ bhe koko-o me: ‹Gogo!› Anɨ gó. Ma pa pɨ bali gba ma-a me: ‹Mene ’he ɨnde!› Anɨ méne.» ");
INSERT INTO mdm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lɨ Yesu adje engʉ́ bhomʉ-o lɨe, anɨ angamba naali. Anɨ atsia apa pɨ okpála ɨnde adʉ akpata anɨ-e me: «Ma apa pɨ yi na paká me, ma bhaka nga ngua nabhuka ɨnde-e bhʉ́ kpála bini bhʉ́ ká omaƗsalaele de! ");
INSERT INTO mdm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma atsia apa la di pɨ yi me: okpála bhelé ayíe ne andjongu di ne akati, u tsía dʉ́lʉ pɨ́ dabɨlɨ na anokomɨa bhʉ́ dabɨlɨ bini ne Abalahama, ne Ɨsaka, la di ne Yakobho bhʉ́ Naʉ na abhʉ́lá ko. ");
INSERT INTO mdm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Engʉ́ la bini, obhende ayo nanɨ me u sia dabɨlɨ bhomʉ-o, u abála uo bhʉ́ biti akilidjo. Oo, u adʉ naku ’gbá di ne nazʉ tate o.» ");
INSERT INTO mdm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Abhomʉ-o, Yesu atsia apa pɨ ngámá gba osʉdha-a me: «Gie lɨmʉ agba mʉ! Maka mo obhuka lɨe, a ayo me amene lɨe pɨ mʉ moko.» Kpála na kulu-o atsia akobho bha bini lɨ nedhɨnga ango-o ko. ");
INSERT INTO mdm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pɨpɨta-a, Yesu alɨ bhʉ́ ’tɨ gba Piele. Anɨ abhaka me ’hi wala anɨ nde asɨ kuto, kʉte anɨ nde kpákpá. ");
INSERT INTO mdm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu aꞌo ’kpa e lɨ ’kpa anɨ, kʉte anɨ atsia aguo. Anɨ ayie bhʉ́lá, anɨ atsia aholo nalʉ ’zʉ pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A akolo lɨe tagolo-o, u ago pɨ Yesu ne okpála bhelé ɨnde lɨ osisiti bua adʉ nadʉ bhʉ́ o-o. Anɨ apandja osisiti bua ango-o ne ’li e, anɨ atsia akobho di ndʉ okpála na kuo hana. ");
INSERT INTO mdm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anɨ amene mo-o ngʉbula me eli ɨnde lɨ polofeta Ɨsaya apa nanɨ e amene lɨe. Engʉ́ ɨnde anɨ apa nanɨ e me: «Anɨ abha ndʉ olɨkabhu gba ya hana, anɨ atsia abɨ ndʉ okuo gba ya hana lɨ kʉte e.» ");
INSERT INTO mdm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lɨ Yesu au kambɨ okpála lɨe lɨngo e, anɨ atsia aha lɨ́lɨ pɨ omʉkpata gba e me o kodho ’kpɨ́ ne ayi ekpɵ na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Abhomʉ-o, mʉsuno bini na lɨ́lɨ gba Moidje adyudyo lɨe, anɨ atsia apa pɨ Yesu me: «Mʉsuno, ma akpáta mʉ lɨ ndʉ bɨlɨ mo onʉ́ lɨ e hana.» ");
INSERT INTO mdm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu apa pɨ anɨ me: «A ka onekpɵ ne gudho u asɨsɨ bhʉ́ e, a di ka odhu ne ’tɨ o. Engʉ́ la bini, ngama Ndɨlɨ gba kpála-a, dabɨlɨ ka ma ngʉ́ nasɨ tété ngʉ́ naguo ade.» ");
INSERT INTO mdm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kpála koko ɨnde adʉ di sʉka omʉkpata gba anɨ-e apa pɨ anɨ me: «Ngámá, ha kpadjɨ mʉma, amba ma nʉ zɨ ngaɨza ’dyɨ ma.» ");
INSERT INTO mdm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Engʉ́ bini, Yesu apa pɨ anɨ me: «ꞌO okpála koko u zɨ anɨ ngao. La ngamʉ-o, go kpata ma.» ");
INSERT INTO mdm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pɨpɨta-a, Yesu aꞌʉ bhʉ́ zabʉ, omʉkpata gba anɨ-e atsia aꞌʉꞌʉ nganda anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma gala kolo me-e, anvi bini na kpekpeke aholo nape pɨ́ ekpɵ-o masɨkpe de me zabʉ-o linda ka ngbo ’ngu-o. La ngaanɨ Yesu-o, anɨ adʉ tɨla. ");
INSERT INTO mdm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abhomʉ-o, omʉkpata-a adyudyo lɨo de anɨ masɨkpe, u atsia azʉkʉ anɨ ne napa me: «Yaka! Ngámá, kobho nɨ́, nɨ́ adji amú!» ");
INSERT INTO mdm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu atsia agie pɨ uo me: «Yi ne tsʉlʉ mo-o ka nɨ? Nabhuka gba yi-e nga bha yeye!» Anɨ ayie bhʉ́lá, anɨ ambe bhʉ́ ’ndjɨ anvi di ne engu-o. Abhomʉ-o, ndʉndʉ hana atsia akolo guguo! ");
INSERT INTO mdm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Okpála angamba, u atsia adʉ apa me: «Kpála ɨnde-e, a ko mangua kpála dho ngʉbula me belegʉ anvi di ne engu dʉ namanga anɨ-e!» ");
INSERT INTO mdm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lɨ Yesu akolo lɨe ayi ’ngu, bhʉ́ doto gba okpála na Gadala-a, okpála bhisi ayie bhʉ́ ká olata, u atsia ago abhaka anɨ. A adʉ bhʉ́ okpála ango-o ne osisiti bua, u atsia adʉ azɨ ’gʉ́ naali. Kaka-a, okpála dʉ apʉ lɨ kpadjɨ lɨ pápá bhomʉ-o de. ");
INSERT INTO mdm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Abhomʉ-o, u aholo nasʉsʉla me: «Mo okʉnda namene ngʉ́ ya pɨ, Ndɨlɨ gba Ebhe? Mo ogo ei ngʉ́ nato mbolo lɨ ya kalanʉ me nedhɨnga nakodho ’ngʉ́-o nde kolo nga dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A abhaka me de bɨlɨ ango-o, ’ngbé piga opame nde oo, u nde ngazʉ ’he. ");
INSERT INTO mdm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Osisiti bua adʉ nakikiliki lɨo pɨ Yesu me: «Ɨ dʉ me mʉ nde akʉnda napandja ya-a, mba ya bhʉ́ piga opame ɨnde.» ");
INSERT INTO mdm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Anɨ apa pɨ uo me: «Yi nʉnʉ.» U aze bhʉ́ okpála bhomʉ, u atsia anʉ alɨlɨ bhʉ́ opame-o. Me-e, ndʉ opame ango-o hana akɵ eta ne holo, u anʉ atuko bhʉ́ ’ngu má dhululu, ne namu ka o. ");
INSERT INTO mdm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Omʉlila gba uo atsi ne holo, u agbida bhʉ́ gʉdhʉ, u atsia akpokpo ndʉ ’ngʉ́ hana di ne engʉ́ ɨnde akodho ’kpɨ́ lɨ okpála bhisi ɨnde adʉ ne osisiti bua bhʉ́ o-o. ");
INSERT INTO mdm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Me-e, ndʉ okpála hana na gʉdhʉ ango-o anʉ ngʉ́ nabhaka Yesu. U au anɨ lɨe, u atsia akikiliki lɨo pɨ anɨ me anɨ yie bhʉ́ kʉtɨ gba o mayie. ");
INSERT INTO mdm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pɨpɨta-a, Yesu aꞌʉ bhʉ́ zabʉ, anɨ agulu matá ekpɵ-o, anɨ atsia akolo bhʉ́ Kapalanauma, gʉdhʉ anɨ adʉ nadʉ bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Me-e, okpála ago pɨ anɨ ne bhoko bini ɨnde agʉgʉmʉ kuto. U ago ne anɨ pɨ́ kalagba. Lɨ Yesu au nabhuka gba uo lɨe, anɨ atsia apa pɨ kpála ɨnde gʉgʉmʉ e bhomʉ-o me: «Atou, ndɨka ma, u aꞌe osisiti ’ngʉ́ gba mʉ-o aꞌe.» ");
INSERT INTO mdm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abhomʉ-o, omʉsuno koko na lɨ́lɨ gba Moidje atsia apa lɨ bua o me: «Kpála ɨnde-e ngasobho Ebhe!» ");
INSERT INTO mdm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lɨ Yesu ambɨla mabhundja gba uo lɨe, anɨ atsia apa pɨ uo me: «Ka nɨ yi ngabhundja lɨe lɨ bua yi sisiti mo-o? ");
INSERT INTO mdm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Padhá de, anga ane ne bhʉkʉ ne bhedho? Ne napa me: ‹U aꞌe osisiti ’ngʉ́ gba mʉ aꞌe›, ne napa me: ‹yie bhʉ́lá, dhʉdhʉkʉ?› ");
INSERT INTO mdm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngʉ́ nasuno me ngama, Ndɨlɨ gba kpála, ma ne angu pɨ́la doto ngʉ́ naꞌe osisiti ’ngʉ́-o, a ayo me ma kobho bhoko ɨnde.» Abhomʉ-o, anɨ atsia apa pɨ kpála ɨnde agʉgʉmʉ-o me: «Yie bhʉ́lá, ha kalagba gba mʉ, amba mʉ gie lɨmʉ agba mʉ!» ");
INSERT INTO mdm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kpála ango-o ayie bhʉ́lá, anɨ atsia atapa agba e. ");
INSERT INTO mdm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lɨ okpála au ’ngʉ́ ango-o lɨe, aꞌo tsʉlʉ lɨ uo naali, u adhɵgɵ Ebhe ɨnde aha ngua angu bhomʉ-o pɨ okpála-kʉtɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pɨpɨta-a, Yesu ayie oo. Anɨ adʉ akodho ’kpɨ́ lɨe, anɨ au kpála bini, a adʉ ’lɨ anɨ me Matié. Anɨ adʉ me anɨ nde adʉ kuto bhʉ́ bilo ɨnde u adʉ akala mandjandja bhʉ́ e-o. Anɨ apa pɨ anɨ me: «Kpata ma!» Matié ayie bhʉ́lá, anɨ atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pɨpɨta-a, Yesu anʉ nazʉ ’he abhʉ́ ’tɨ gba anɨ. Abhomʉ-o, bhiti ondɵmbɨ na mandjandja di ne okpála koko na sisiti ago adʉlʉ nazʉ ’he bhʉ́ dabɨlɨ bini ne Yesu di ne omʉkpata gba e-o. ");
INSERT INTO mdm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lɨ omʉFalisai au lɨe mo-o, u atsia ayi omʉkpata gba anɨ-e me: «Ka nɨ lɨ mʉsuno gba yi-e ngazʉ ’he lɨe bhʉ́ dabɨlɨ bini ne ondɵmbɨ na mandjandja di ne okpála na sisiti-e?» ");
INSERT INTO mdm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","La-a, Yesu adje engʉ́ ango-o, anɨ atsia apa me: «Okpála bhende ne kuo ade-e, u ne gʉmʉ mʉtɨa ade. Engʉ́ bini, okpála bhende ne kuo mangbo ne gʉmʉ mʉtɨa ngao. ");
INSERT INTO mdm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kaka-a, yi nʉ gɨlɨ ta ’ngʉ́ ɨnde lɨ Bhuku gba Ebhe-e apa e me: ‹Engʉ́ ɨnde anga lɨ ma naali-e, a ko nadje ndjinga okpála koko, a ko naha makiso de.› Padhá de, anga ma go naꞌɨ okpála bhende apa me o ngbingbili-e de. Engʉ́ bini, ma ago mangbo naꞌɨ okpála bhende au lɨo me o ne osisiti okpála-o.» ");
INSERT INTO mdm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ekpɨ́ bini, omʉkpata gba Djaa bhʉlʉ nabatisa okpála adyudyo lɨo de Yesu, u atsia ayi anɨ me: «Ka nɨ lɨ ngaya ne omʉFalisai, ya ngatse ’zʉ lɨe gɵmɵ ngʉ́ nayo Ebhe-e, la-a, omʉkpata gba mʉ-o ngamemene mo-o ade-e?» ");
INSERT INTO mdm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu atsia agie pɨ uo me: «Okpála bhende u aꞌɨ o bhʉ́ anokomɨa na kʉva tɨ da nayala nazʉ ’he uu me ’ko ɵlɵ-o nde ngabha bhʉ́ dabɨlɨ bini ne uo-o? Engʉ́ bini, oekpɨ́ akólo makolo, ekpɨ́ ɨnde u aꞌé ’ko ɵlɵ-o lɨe bhʉ́ ká uo-o, lɨ oekpɨ́ bhomʉ-o, u tsia tsé ’zʉ. ");
INSERT INTO mdm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kpála bini tɨ da nadʉ pála bongo na mbɨa lɨ bhe na didili de. Padhá de, anga pápála bhende u aꞌo e pépé-e sídha bongo-o, lɨ kaka-a tsia dʉ́ la matá sisiti naali. ");
INSERT INTO mdm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","U ꞌoꞌo pandɨ na mbɨa bhʉ́ odidili dhudhu na kó ’nʉ de. Ɨ dʉ mo-o, lɨ odhudhu-o ʉ́pa, lɨ pandɨ-e túko, lɨ odhudhu-o tsia síti di. U ꞌoꞌo mangbo pandɨ na mbɨa bhʉ́ odhudhu na mbɨa. Abhomʉ-o, ndʉndʉ hana tsia líla lɨe ndjɨndjɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lɨ Yesu adʉ agie ’ngʉ́ pɨ omʉkpata gba Djaa lɨe, ngámá bini adyudyo lɨe de anɨ masɨkpe, anɨ atʉtʉ lɨpʉkʉ e kuto kala anɨ. Anɨ atsia apa pɨ anɨ me: «Ndɨlɨ gba ma na ɵɵlɵ-o andjili mbɨa ɨnde. Engʉ́ bini, go ꞌo ’kpa mʉ pɨ́ anɨ, amba anɨ zuku.» ");
INSERT INTO mdm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Abhomʉ-o Yesu ayie bhʉ́lá, anɨ atsia akpata anɨ bhʉ́ dabɨlɨ bini ne omʉkpata gba e-o. ");
INSERT INTO mdm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bha lɨ nedhɨnga bhomʉ-o, ɵlɵ bini ɨnde lɨ ngʉte adʉ natuko lɨe ngʉbula kalanga ndjɨkpa ne ká bhisi-e ago de Yesu ne akele anɨ, anɨ atsia abu ’kpa e lɨ ’so bongo gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Padhá de, anga anɨ adʉ apa lɨ bua e me: «Ɨ dʉ bha me ma nde abu ’kpa ma lɨ bongo gba anɨ-e, ma kóbho.» ");
INSERT INTO mdm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Engʉ́ bini, Yesu adji lɨe, anɨ au anɨ, anɨ atsia apa me: «Atou, ndɨka ma! Nabhuka gba mʉ-o akobho mʉ akobho.» Bha lɨ nedhɨnga bhomʉ-o, ɵlɵ ango-o atsia akobho. ");
INSERT INTO mdm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu akolo agba ngámá-o. Anɨ abhaka me okpála nde má dja dja dja ngʉ́ nanʉ azɨ kuo-o, omavʉlʉ mbálá-a nde ngaꞌu mbálá. ");
INSERT INTO mdm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Abhomʉ-o, anɨ atsia apa me: «Yi gbe lɨyi ne sidi, anga ndɨlɨ na ɵɵlɵ ɨnde-e kpi de, engʉ́ bini, anɨ ngala.» Abhomʉ-o, u aholo namʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lɨ u apandja ndʉ okpála hana lɨe kilidjo-o, Yesu alɨ abhʉ́ ’tɨ. Anɨ aha ’kpa ndɨlɨ-o. Abhomʉ-o, ndɨlɨ-e atsia ayie bhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngali na engʉ́ ango-o atsia ayangba bhʉ́ ndu doto bhomʉ-o libhomu. ");
INSERT INTO mdm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lɨ Yesu aholo ’nʉ́ lɨe, okpála bhisi ɨnde ɨ u ’kpɨ́ de-e, aholo akpata anɨ ne nasʉsʉla me: «Ndɨlɨ gba Davidi, dje ndjinga ya!» ");
INSERT INTO mdm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anɨ alɨ lɨe abhʉ́ ’tɨ-e, okpála bhisi ɨnde ɨ u ’kpɨ́ de bhomʉ-o adyudyo lɨo de anɨ. Yesu atsia ayi uo me: «Yi abhuka me ma tɨ da nateteke yi?» U agie pɨ anɨ me: «Heni, Ngámá.» ");
INSERT INTO mdm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Abhomʉ-o, anɨ abu ’kpa e lɨ djila uo ne napa me: «A ayo me amene lɨe pɨ yi maka nabhuka gba yi-e nde lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Abhomʉ-o, djila uo abhulu, Yesu atsia agbele ’dje uo kpekpeke me: «Yi gbo ’dje yi! A ayo de me kpála bini mbɨla engʉ́ ɨnde-e de!» ");
INSERT INTO mdm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Engʉ́ bini, bha naze ka uo me-e, u apandjala ngali gba anɨ-e bhʉ́ ndu doto ango-o libhomu. ");
INSERT INTO mdm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nedhɨnga lɨ okpála bhisi ɨnde lɨ Yesu akobho o bhomʉ-o adʉ nanʉ lɨe, bha lɨ nedhɨnga bhomʉ-o, okpála ago pɨ Yesu ne kpála bini ɨnde ɨ bhʉ ’ngʉ́ de ka siti bua ɨnde adʉ nadʉ bhʉ́ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lɨ Yesu agbe siti bua ango-o lɨe bhʉ́ anɨ-e, kpála ango-o atsia aholo nagama ’ngʉ́. Abhomʉ-o, kambɨ okpála angamba, u atsia adʉ napa me: «Ngua ’ngʉ́ ɨnde-e u nga lɨe bhʉ́ ká omaƗsalaele belegʉ de bini!» ");
INSERT INTO mdm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","La-a, omʉFalisai adʉ napa me: «Ngámá gba osisiti bua ngaha angu pɨ anɨ ngʉ́ napandja osisiti bua ngae bha-a!» ");
INSERT INTO mdm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Abhomʉ-o, Yesu adʉ adholo bhʉ́ ndʉ ogʉdhʉ di ne bhʉ́ ndʉ okʉtɨ hana. Anɨ adʉ nasuno bhʉ́ oetɨ nadje lɨ́lɨ gba Moidje . Anɨ adʉ akpokpo Bádha Ngali Naʉ gba Ebhe , anɨ atsia adʉ nakobho ndʉ kuo hana di ne ndʉ oeze hana. ");
INSERT INTO mdm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lɨ anɨ au kambɨ okpála lɨe, anɨ adje ndjinga uo naali, anga u adʉ me u nde andala, angu uo nde la di andjia maka piga okandɵlɵ ɨnde lɨ mʉlila nde ka o ade. ");
INSERT INTO mdm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Abhomʉ-o, anɨ atsia apa pɨ omʉkpata gba e me: «Nguwa abhiye-e bhelé, engʉ́ la bini, okpála na kulu-o bhelé ade. ");
INSERT INTO mdm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yi yo ka bhʉlʉ ’dyɨ-e me anɨ tima okpála na kulu bhʉ́ edyɨ gba e ngʉ́ naꞌe nguwa-o.» ");
INSERT INTO mdm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pɨpɨta-a, Yesu aꞌɨ omʉkpata ndjɨkpa ne ká bhisi gba e-o. Anɨ aha angu pɨ uo ngʉ́ napandja osisiti bua bhʉ́ okpála, di ne nakobho ndʉ okuo hana, la di ne ndʉ oeze hana. ");
INSERT INTO mdm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A ɨnde-e ’lɨ obhʉlʉ titima ndjɨkpa ne ká bhisi-o: kpála na kalanʉ-o, a ko Simo ɨnde lɨ Yesu agisila ’lɨ e me Piele, ne uo ne ndai e Andɨlɨ, a la di-e ongɨsɨ bhisi gba Djebedayo-o. A adʉ nanɨ Djakɨ ne uo ne ndai e Djaa , ");
INSERT INTO mdm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","a la di-e Filipo ne uo ne Batelemi; a la di-e Tʉma ne uo ne Matié, ndɵmbɨ na mandjandja-o; a la di-e Tade ne uo ne Djakɨ, ndɨlɨ gba Alafayo-o; ");
INSERT INTO mdm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","a la di-e Simo kpála na Kanana ngauo ne Yuda Ɨsɨkaliote. Simo nanɨ ne sʉka omaYuda ɨnde adʉ agɨlɨ ne kpéke me o ze bhʉ́ bali sa kpa okpála na Loma zeze-o. Yuda Ɨsɨkaliote nanɨ ne kpála ɨnde apʉ́ ngbángá Yesu pɨ obhʉlʉ yala-o. ");
INSERT INTO mdm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Abhomʉ-o, Yesu atima obhʉlʉ titima ndjɨkpa ne ká bhisi bhomʉ-o. Anɨ atsia aha olɨ́lɨ ɨnde-e pɨ uo me: «Yi adji-e, yi anʉ́ agba okpála ɨnde ne omaYuda ade-e de. Yi alɨ́ di bhʉ́ ogʉdhʉ gba okpála na Samalɨa de. ");
INSERT INTO mdm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Engʉ́ bini, yi nʉ mangbo agba omaƗsalaele. Padhá de, anga uo maka okandɵlɵ ɨnde angɨta. ");
INSERT INTO mdm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lɨ kpadjɨ-e, yi kpokpo Bádha Ngali gba Ebhe-o. Yi pa pɨ okpála me: ‹Naʉ na abhʉ́lá akolo masɨkpe!› ");
INSERT INTO mdm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yi kobho okpála na kuo, yi zuku okpála ɨnde amu, yi kobho obhʉlʉ kába, yi pandja osisiti bua bhʉ́ okpála. Yi asia padhá, yi ha bhadi pɨ okpála koko padhá. ");
INSERT INTO mdm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yi ahá belegʉ kʉ lɨ falanga de bini. ");
INSERT INTO mdm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yi ahá gonia ngʉ́ enʉ́-o de. Yi ahá bongo na mbulu bhisi de, yi nʉ bha ne koli malɵkɵ ɨnde bhʉ́ ’dhʉ yi ko, yi ahá ndula de. Padhá de, anga okpála ɨnde yi adji amene kulu bhʉ́ ká o-o abɨ́ mʉkobho gba yi-e ngao. ");
INSERT INTO mdm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yi lɨ bhʉ́ gʉdhʉ bini, ɨ dʉ di-e bhʉ́ kʉtɨ bini-e, yi de gɨlɨ kpála ɨnde bedhe ngʉ́ nasia yi, amba yi dʉ gba kpála ango-o akólo bhʉ́ nayie ka yi ko. ");
INSERT INTO mdm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yi lɨ bhʉ́ etɨ bini-e, yi de yi okpála ɨnde bhʉ́ ’tɨ ango-o mayi. ");
INSERT INTO mdm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ɨ dʉ me okpála na etɨ ango-o nde asia yi-e, guo ’ngʉ́ yi adhʉkʉ ne e de dʉ ne uo. Engʉ́ bini, ɨ dʉ la me okpála ango-o nde sia yi de-e, guo ’ngʉ́ gba yi-e de gie lɨe pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɨ dʉ me u nde sia yi de-e, u dje la di ’li yi de-e, nedhɨnga ɨnde yi ngakoto lɨe bhʉ́ ’tɨ ango-o, ɨ dʉ di-e bhʉ́ gʉdhʉ ango-o, yi de dyɨkɨ ndju doto na ’dhʉ yi ngʉ́ nasuno pɨ uo me yi atse uo atse. ");
INSERT INTO mdm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma apa pɨ yi na paká me, lɨ ’kpɨ́ nakodho ’ngʉ́-o, okpála na gʉdhʉ ango-o asía lɨkabhu kpekpeke ané okpála na Sodomʉ ne Gomolo mane.» ");
INSERT INTO mdm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Yi gbo nga ’dje yi! Ngama-a, ma ngatima yi maka okandɵlɵ bhʉ́ ká onʉte. ꞌE-e! Yi alá-a de, amba yi dʉ di ne bhʉkʉ bua maka opidjo. ");
INSERT INTO mdm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yi lila lɨyi ka okpála ndjɨndjɨ. Padhá de, anga u ambá yi bhʉ́ otilibinali, u tsia bhɨ́ yi ne fimbo bhʉ́ otɨ gba o nadje lɨ́lɨ gba Moidje-o . ");
INSERT INTO mdm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","U anʉ́ ne yi kala ongámásɨ na ndu doto di ne kala ongbengbe ongámásɨ anga yi abhuka ma. A améne lɨe mo-o ngʉbula me yi kpokpo ’ngʉ́ gba ma-a kala uo di ne kala okpála ɨnde ne omaYuda ade-o. ");
INSERT INTO mdm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nedhɨnga u anʉ́ ne yi lɨe kala okpála ango-o, yi akína lɨyi lɨ ’ngʉ́ ɨnde yi apá e de, di ne lele maka yi ayípa ’ngʉ́ lɨ ’ngʉ́ ango-o lɨe de. Ongʉ́ ɨnde a ayo me yi pa e, a ahá bha lɨe pɨ yi lɨ nedhɨnga ango-o. ");
INSERT INTO mdm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Padhá de, anga engʉ́ ɨnde yi agáma e yíe ka yi de. Engʉ́ bini, Bua gba ’Dyɨ yi-e agáma ’ngʉ́ bhʉ́ yi ngae. ");
INSERT INTO mdm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Okpála apʉ́ ondaise o me u bhili uo. ’Dyɨ ndɨlɨ apʉ́ ndɨlɨ gba e me u bhɵlɵ anɨ. Ongɨsɨ akólo ne kpekpeke ’ndjɨ pɨ okpála ɨnde azu o, u tsia pʉ́ okpála azu o me u bhili uo. ");
INSERT INTO mdm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndʉ okpála hana ayála yi ka ’lɨ ma. Engʉ́ bini, kpála bhende akíbila nakolo bha bini makolo alɨ soso-o, anɨ tsia kóbho. ");
INSERT INTO mdm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","U mene yi sisiti bhʉ́ gʉdhʉ bini-e, yi de kpe bhʉ́ gʉdhʉ koko. Ma apa la pɨ yi na paká me yi ndjía nadhʉkʉ bhʉ́ ogʉdhʉ na Ɨsalaele hana de me Ndɨlɨ gba kpála nde go de-e de. ");
INSERT INTO mdm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yi mbɨla ndjɨndjɨ me mʉkpata ne mʉsuno gba e ne engbé de, kpála na kulu ne di ngámá na kulu gba e ne engbé de. ");
INSERT INTO mdm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A ayo me mʉkpata kolo maka mʉsuno gba e-o. A ayo di me kpála na kulu kolo maka ngámá na kulu gba e-o. Ɨ dʉ me u nde ngaꞌɨ bhʉlʉ etɨ-e me Baladjebula-a, u aꞌɨ́ la ɨbili okpála na etɨ gba anɨ-e pɨ! ");
INSERT INTO mdm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","27","Kaka-a, yi akpé okpála ɨnde améne yi sisiti-e de! Engʉ́ ɨnde ma apa e pɨ yi bhʉ́ biti-e, yi pa ɨbili ne ngbɨkpɨ. Engʉ́ ɨnde u apa e pɨ yi bhʉ́ tʉpele-e, yi totobhɨla ɨbili ne di apɨ́ ongbʉtɨ. Padhá de, anga ndʉ ’he ɨnde awo lɨe mawo-o hana akóto bhʉ́ mbasʉ, la di-e, ndʉ ’he ɨnde na pepe hana ambɨ́la lɨe mambɨla. ");
INSERT INTO mdm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yi akpé obhende ngabhɵlɵ kʉte yi, ɨnde ɨ tɨ da nabhɵlɵ bua yi de-e de. Yi kpe mangbo Ebhe ɨnde ɨ tɨ da nabhɵlɵ bua yi, la di ne kʉte yi libhomu bhʉ́ djua na dʉdʉma ko. ");
INSERT INTO mdm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Lɨ mʉ tsɨndjɨ oɨndjɨlɨndjɨlɨ bhisi-e, mo osía tété mangua tetele tɨa dho? La-a, sʉka uo bini kpí padhá de me ’Dyɨ yi Ebhe nde zɨba de-e de. ");
INSERT INTO mdm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","La pɨ yi-e, Ebhe atanga belegʉ osundjo yi hana. ");
INSERT INTO mdm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kaka-a, yi akpé ehe bini de. Ngayi-e, abana u po bha bhʉ́la oɨndjɨlɨndjɨlɨ bhelé-e, yi ane uo ne tata. ");
INSERT INTO mdm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Lɨ kpála bini pa bhʉ́ ká djila okpála me nɨ ne kpála ka ma-a, ngama-a, ma apá bhadi bhʉ́ djila ’Dyɨ ma ɨnde abhʉ́lá-a me a ko naama kpála. ");
INSERT INTO mdm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Engʉ́ bini, lɨ kpála bini pa bhʉ́ ká djila okpála me nɨ ne kpála ka ma ade-e, ngama-a, ma apá bhadi bhʉ́ djila ’Dyɨ ma ɨnde abhʉ́lá me a ko naama kpála de.» ");
INSERT INTO mdm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Yi abhúndja de me ma ago ngʉ́ naꞌo guo ’ngʉ́ pɨ́la doto de. Ma go ngʉ́ naꞌo guo ’ngʉ́ de, engʉ́ bini, ma ago mangbo ngʉ́ nagbogbo bhʉsʉ okpála. ");
INSERT INTO mdm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A moko, ma ago nagbogbo bhʉsʉ kpála ne ’dyɨ e. Ma ago nagbogbo bhʉsʉ ndɨlɨ na ɵɵlɵ ne ’hi e. Ma ago nagbogbo bhʉsʉ ɵlɵ gba ndɨlɨ-e ne ogbi e na ɵɵlɵ. ");
INSERT INTO mdm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kaka-a, obhʉlʉ yala gba kpála adʉ́ bha okpála na abhʉ́ ’tɨ gba anɨ ko. ");
INSERT INTO mdm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kpála bhende ngakʉnda ’dyɨ e, ɨ dʉ di-e ’hi e ane ma mane-e, kpála ango-o tɨ ne ma de. La di-e, kpála bhende ngakʉnda ndɨlɨ na bhobhoko gba e, ɨ dʉ di-e ndɨlɨ na ɵɵlɵ gba e ane ma mane-e, kpála ango-o tɨ ne ma de. ");
INSERT INTO mdm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kpála bhende ɨ bɨ kulusi gba e de, ɨ tsia kpata ma de-e, kpála ango-o tɨ ne ma de. ");
INSERT INTO mdm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kpála bhende alíla mʉkobho gba e-e, anɨ kpí. Engʉ́ bini, kpála bhende atsé la mʉkobho gba e ngʉbula ma-a, anɨ sía mʉkobho na kʉkʉlʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kpála bhende asia yi-e, anɨ asia bhomʉ-o ma. La di-e, kpála bhende asia ma-a, anɨ asia bhomʉ-o kpála bhende atima ma ko. ");
INSERT INTO mdm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kpála bhende asia polofeta anga a ko polofeta-a, anɨ asía makalá ɨnde atɨ ne opolofeta. La di-e, kpála bhende asia kpála na ngbingbili anga a ko kpála na ngbingbili-e, anɨ asía makalá ɨnde atɨ ne okpála na ngbingbili-o. ");
INSERT INTO mdm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma apa pɨ yi na paká me kpála bhende ahá ngabha kópo kpina ’ngu bini pɨ sʉka okpála ɨnde lɨ okpála ngau o padhá ɨnde-e anga a ko mʉkpata gba ma-a, kpála ango-o asía makalá gba e masia.» ");
INSERT INTO mdm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lɨ Yesu andjia naha olɨ́lɨ bhomʉ-o lɨe pɨ omʉkpata gba e ndjɨkpa ne ká bhisi-e, anɨ ayie oo. Anɨ atsia anʉ ngʉ́ nasuno di ne nakpokpo eli gba Ebhe-e bhʉ́ ogʉdhʉ na ndu doto na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lɨ Djaa bhʉlʉ nabatisa okpála adʉ lɨe bhʉ́ tɨkpʉ-o, anɨ adje ngali okulu lɨ Kilisito adʉ amene e-o. Abhomʉ-o, anɨ atsia atima omʉkpata gba e ");
INSERT INTO mdm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","me u nʉ yi anɨ me: «Mʉ ne Masɨya ɨnde ayo me Ebhe tima e? Ne me ayo me ya adjeke kpála koko?» ");
INSERT INTO mdm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu agie pɨ uo me: «Yi nʉ kpokpo engʉ́ ɨnde yi ngadje e ne bhende yi ngau e pɨ Djaa: ");
INSERT INTO mdm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","okpála ɨ u ’kpɨ́ de-e ngau ’kpɨ́, obhende ne eze lɨ ’dhʉ o-o ngadhʉkʉ ndjɨndjɨ, obhʉlʉ kába ngakobho, obhende ɨ dje ’kpɨ́ de-e, la di ngadje ’kpɨ́, obhende amu-o ngazuku, okpála bhende ngau lɨo padhá kala Ebhe-e la di ngadje Bádha Ngali . ");
INSERT INTO mdm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A ko djalɨ pɨ kpála ɨnde lɨ engʉ́ gba ma-a bhɵ́lɵ nabhuka gba e mabhɵlɵ de ko.» ");
INSERT INTO mdm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lɨ omʉkpata gba Djaa aholo ’nʉ́ lɨe, Yesu atsia aholo nakpokpo ’ngʉ́ lɨ ’ngʉ́ gba Djaa pɨ kambɨ okpála ɨnde adʉ oo me: «Yi anʉ ɨgɨnɨ natsia abhʉ́ mili bɨlɨ-e nɨ? Yi anʉ ɨgɨnɨ natsia mbamba ɨnde lɨ anvi ngadyɨkɨ e? A mo-o ade. ");
INSERT INTO mdm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɨ dʉ mo-o de-e, yi anʉ nga ɨgɨnɨ natsia nɨ? Yi anʉ ɨgɨnɨ natsia kpála ɨnde adyɨ babadha bongo-o ? La-a, okpála bhende adyɨdyɨ obabadha bongo-o, u dʉdʉ bhʉ́ oetɨ gba ongbengbe ongámásɨ. ");
INSERT INTO mdm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yi anʉ nga la ɨgɨnɨ natsia nɨ? Yi anʉ ɨgɨnɨ natsia polofeta ? A moko. Ma apa pɨ yi me, yi anʉ ɨgɨnɨ natsia kpála ɨnde ane belegʉ polofeta mane. ");
INSERT INTO mdm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Padhá de, anga a ko kpála ɨnde lɨ Bhuku gba Ebhe-e apa nanɨ lɨ ’ngʉ́ gba e me: ‹Ebhe apa me, ma ngatima bhʉlʉ titima gba ma-a pɨ mʉ kalanʉ ngʉ́ naleke kpadjɨ pɨ mʉ.› ");
INSERT INTO mdm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngama-a, ma apa pɨ yi na paká me, bhʉ́ ká okpála-kʉtɨ-e, kpála bini ɨnde akoto, ɨnde ngbéngbé ane Djaa bhʉlʉ nabatisa okpála belegʉ ade bini. La-a, ndʉ okpála hana ɨnde azɨba Naʉ na abhʉ́lá-a , abana anɨ dʉ bha mbomboye pɨ-ie, anɨ ane Djaa ne engbé. ");
INSERT INTO mdm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","14","Padhá de, anga ndʉ opolofeta hana di ne lɨ́lɨ gba Moidje akpokpo ngali Naʉ na abhʉ́lá nakolo makolo lɨ nedhɨnga gba Djaa-o. Ɨ dʉ me yi nde akʉnda nazɨba engʉ́ ma apa e, Djaa ne Elɨya ɨnde a ayo nanɨ me anɨ go-o ngae. Nayie bhʉ́ nedhɨnga gba Djaa bhʉlʉ nabatisa okpála akolo pɨ mbɨa ɨnde-e, Naʉ na abhʉ́lá bhʉ́ gbene. La di-e, omangopu ngamene ne kpéke hana me o siti masiti. ");
INSERT INTO mdm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A ayo me kpála ɨnde lɨ e ne djedje ngʉ́ nadje ’kpɨ́-e djedje! ");
INSERT INTO mdm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma tɨ́ da nasuno okpála na nakɨ ɨnde-e lɨ da? Uo maka ongɨsɨ ɨnde adʉlʉ bhʉ́ mbadhasʉ. ");
INSERT INTO mdm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Okoko ngaꞌu mbálá na ebɨ pɨ obɨ o, engʉ́ bini, obhe u aꞌu mbálá ango-o pɨ o ayala nadho ’bɨ! U ali matá etsi na da kuo pɨ uo, engʉ́ bini, u ayala naku ’gbá! ");
INSERT INTO mdm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yi maka ongɨsɨ ɨnde ayala nadho ’bɨ di ne naku ’gbá bhomʉ. Padhá de, anga a maka lɨ Djaa ago nanɨ lɨe-o. Anɨ ago maka kpála ɨnde bhʉ́ dá kuo. Anɨ zʉ ’he de, anɨ ndjɨ di vino de, yi atsia apa me: ‹A bhʉ́ anɨ ne siti bua !› ");
INSERT INTO mdm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ndɨlɨ gba kpála ago di. Anɨ ago maka kpála ɨnde bhʉ́ dá ’bɨ. Anɨ azʉ ’he, anɨ andjɨ di vino, do yi de me: ‹Yi tsia nga kpála ɨnde. Anɨ bha bini ngabhundja nazʉ ’he ne nandjɨ vino! A ko olia ondɵmbɨ na mandjandja, di ne okpála na sisiti!› Engʉ́ bini, bhʉ́ natsia nganda okulu gba Ebhe-e, a ngasuno pɨ yi me ɨmbɨlangʉ gba anɨ-e ngbingbili.» ");
INSERT INTO mdm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Abhomʉ-o, Yesu aholo nagama ’ngʉ́ ne ndje djila pɨ okpála na ogʉdhʉ ɨnde anɨ amene nanɨ ongamba ’ngʉ́ gba e bhelé bhʉ́ e-o. Padhá de, anga okpála ango-o dji nanɨ bua o de. ");
INSERT INTO mdm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Anɨ adʉ apa me: «A ko lɨkabhu pɨ yi, okpála na gʉdhʉ na Koladjina! A ko lɨkabhu pɨ yi, okpála na gʉdhʉ na Betesaida! Padhá de, anga ma amene ongamba ’ngʉ́ bhelé bhʉ́ ogʉdhʉ gba yi-o. Engʉ́ bini, yi dji bua yi de. La-a, ma méne nanɨ ongamba ’ngʉ́ bhomʉ-o bhʉ́ ogʉdhʉ na Tile ne Sidona-a, okpála na ogʉdhʉ ango-o de adyɨ nanɨ gonia, u túko embɨ bhʉ́ ’ndjɨ o didili naali, u tsia djí bua o. ");
INSERT INTO mdm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A moko. Ma apa pɨ yi me, lɨ ’kpɨ́ lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, lɨkabhu gba yi-e ané bhende gba okpála na Tile ne Sidona mane. ");
INSERT INTO mdm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne yi di, okpála na gʉdhʉ na Kapalanauma, yi abhundja naayi me u aꞌéꞌe yi akolo abhʉ́lá-a? A mo-o ade. U akɵ́ yi ne kuto, akólo bha bini lɨ bɨlɨ gba okpála ɨnde amu. Padhá de, anga ma amene ongamba ’ngʉ́ bhelé bhʉ́ gʉdhʉ gba yi-o. Engʉ́ bini, yi dji bua yi de. La-a, ma méne nanɨ ongamba ’ngʉ́ bhomʉ-o bhʉ́ gʉdhʉ na Sodomʉ-o, gʉdhʉ ango-o de nga bha bhʉ́ka, nakolo pɨ nakɨ. ");
INSERT INTO mdm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kaka-a, ma apa pɨ yi me, lɨ ’kpɨ́ lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, lɨkabhu gba yi-e ané bhende gba okpála na Sodomʉ mane.» ");
INSERT INTO mdm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bhʉ́ nedhɨnga bhomʉ-o, Yesu atsia apa me: «Ma ngadhɵgɵ mʉ, ’Dyɨ ma, Ngámá na abhʉ́lá ne Ngámá na doto. Padhá de, anga engʉ́ ɨnde mo owo e pɨ okpála ɨnde ngabhundja me a bhʉ́ ’ndjɨ o ne ɨmbɨlangʉ-o, mo ombamba tata pɨ obhende ngau lɨo me o ne okpála na padhá kala mʉ! ");
INSERT INTO mdm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A moko, ’Dyɨ ma, anga bhʉ́ bádha bhʉ́ ’bu gba mʉ-o, mo okʉnda bha nanɨ me a adʉ moko. ");
INSERT INTO mdm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yi mbɨla ndjɨndjɨ me ’Dyɨ ma asuno ndʉ ’ngʉ́ hana mʉma. Kpála bini mbɨla Ndɨlɨ-e de, bha bini ’Dyɨ Ndɨlɨ-o. Kpála bini mbɨla la di ’Dyɨ Ndɨlɨ-e de, bha bini Ndɨlɨ gba anɨ-o, a la di-e kpála bhende lɨ Ndɨlɨ-e akʉnda nasuno anɨ pɨ e ko. ");
INSERT INTO mdm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yi andala ka okpekpeke lɨ́lɨ di ne okpekpeke da ’ngʉ́ ɨnde u ngabu e pɨ́ yi-o. Mbɨa ɨnde-e, yi go bhaka ma, ma ꞌe pɨ́ yi maꞌe, amba ma ha naguo pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yi mene olɨ́lɨ gba ma-o, amba yi ꞌo me ma suno engʉ́ pɨ yi. Padhá de, anga ma súno pɨ yi ne bhʉkʉ bua di ne naꞌo lɨma ne kuto. Yi mene mo-o, yi tsia sía naguo pɨ yi makpe. ");
INSERT INTO mdm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","A moko, da namene ongʉ́ ɨnde ma akʉnda e di ne olɨ́lɨ gba ma-a kpekpeke ade.» ");
INSERT INTO mdm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Bhʉ́ oekpɨ́ bhomʉ-o, Yesu ne omʉkpata gba e adʉ akodho ’kpɨ́ bhʉ́ ngu ’zʉ ɨnde u aꞌɨ e me ngano. A adʉ ekpɨ́ naguo gba omaYuda-o . Omʉkpata gba anɨ adʉ ne gʉmʉ. Abhomʉ-o, u aholo nakodho ’ndjɨ ’ndjɨ, u atsia adʉ nazʉzʉ. ");
INSERT INTO mdm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lɨ omʉFalisai au lɨe mo-o, u atsia apa pɨ Yesu me: «Ka nɨ lɨ omʉkpata gba mʉ-o ngamene kulu lɨe bhʉ́ ’kpɨ́ naguo me lɨ́lɨ gba nɨ́-e nde zɨba mo-o de-e?» ");
INSERT INTO mdm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu agie pɨ uo me: «Yi tanga nga engʉ́ ɨnde lɨ Davidi amene nanɨ e dɨ, nedhɨnga ɨnde lɨ ngaanɨ makpe ne okpála gba e, u adʉ lɨe ne gʉmʉ-o? ");
INSERT INTO mdm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Anɨ alɨ nanɨ bhʉ́ ’tɨ Ebhe, ngaanɨ ne okpála gba e, u atsia azʉ mapa ɨnde u aha e pɨ Ebhe-o. A ayo la nanɨ pɨ sʉka uo bini nazʉzʉ de. Engʉ́ bini, a ayo bha nanɨ me azʉ mapa ango-o ne odimandɵ gba Ebhe . ");
INSERT INTO mdm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne me engʉ́ ɨnde bhʉ́ lɨ́lɨ gba Moidje-e , yi tanga nga dɨ? Lɨ́lɨ gba Moidje apa me, lɨ ’kpɨ́ naguo gba omaYuda-a, odimandɵ ɨnde ngamene kulu bhʉ́ ’ngbé ’tɨ Ebhe-e ngagʉmʉ bhomʉ-o lɨ́lɨ na ekpɨ́ naguo-o. La-a, u ꞌó ’ngʉ́ pɨ́ uo kaka de! ");
INSERT INTO mdm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Engʉ́ bini, ma apa la pɨ yi me kpála bini bhʉ́ ká yi sɨ, anɨ ane ’ngbé ’tɨ Ebhe mane. ");
INSERT INTO mdm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ɨ dʉ́ me yi mbɨ́la engʉ́ ɨnde lɨ Bhuku gba Ebhe-e apa e uu-o, yi de ꞌó engʉ́ pɨ́ okpála bhomʉ-o de. Padhá de, anga Bhuku gba Ebhe apa me: ‹Engʉ́ ɨnde a nga lɨ ma naali-e, a ko nadje ndjinga okpála koko, a ko naha makiso de.›» ");
INSERT INTO mdm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yesu atsia abu tata-a me: «Ngama, Ndɨlɨ gba kpála-a, ma ne ngámá pɨ́ ’ndjɨ ekpɨ́ naguo.» ");
INSERT INTO mdm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pɨpɨta-a, Yesu ayie oo, anɨ atsia anʉ alɨ bhʉ́ etɨ gba uo nadje lɨ́lɨ gba Moidje-o . ");
INSERT INTO mdm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bhʉ́ ’tɨ oo, kpála bini ɨnde lɨ ’kpa e andɨa adʉ oo. OmʉFalisai adʉ akʉnda naꞌo ’ngʉ́ pɨ́ Yesu. Kaka-a, u ayi anɨ me: «Lɨ́lɨ gba nɨ́-e azɨba me u kobho kpála bhʉ́ ’kpɨ́ naguo uu?» ");
INSERT INTO mdm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu agie pɨ uo me: «A ko da bhʉ́ ká yi ɨnde ɨ dʉ ka e ne koli kandɵlɵ bini-e, lɨ kandɵlɵ ango-o tɨ bhʉ́ ’dú lɨ ’kpɨ́ naguo, anɨ nʉ́ nagbe anɨ de-e? ");
INSERT INTO mdm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","La-a, kpála-kʉtɨ ane kandɵlɵ bhʉtsibhʉtsi! Kaka-a, lɨ́lɨ azɨba namene bádha ’ngʉ́ bhʉ́ ’kpɨ́ naguo.» ");
INSERT INTO mdm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Abhomʉ-o, anɨ atsia apa pɨ kpála ango-o me: «Gbele ’kpa mʉ.» Kpála ango-o agbele ’kpa e, ’kpa anɨ atsia akolo ndjɨndjɨ maka ’kpa anɨ bhe koko-o. ");
INSERT INTO mdm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pɨpɨta-a, omʉFalisai aze kilidjo. U apo bhʉ́la o ngʉ́ nagɨlɨ kpadjɨ me o bhɵlɵ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lɨ Yesu ambɨla lɨe me omʉFalisai ngagɨlɨ nabhɵlɵ nɨ-e, anɨ ayie lɨ bɨlɨ ango-o. Bhiti okpála akpata anɨ, anɨ atsia akobho ndʉ obhende adʉ ne kuo hana. ");
INSERT INTO mdm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Engʉ́ bini, anɨ agbele ’dje uo kpekpeke me u apá pɨ kpála bini de me nɨ ne da-ie de, ");
INSERT INTO mdm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ngʉbula me engʉ́ ɨnde lɨ polofeta Ɨsaya apa nanɨ e amene lɨe. Polofeta Ɨsaya apa nanɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ebhe apa me: ‹Tsia nga bali gba ma ɨnde ma abhʉ nanɨ e-o, ma kʉnda anɨ naali, engʉ́ gba anɨ-e nga lɨ ma naali. Ma aꞌó Bu Bhobua gba ma-a pɨ́ anɨ, anɨ tsia kpókpo ngbili ’ngʉ́ pɨ ndʉ opiga hana. ");
INSERT INTO mdm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Anɨ bí bhaiki ne kpála bini de, anɨ gáma kpéke ’ngʉ́ de. U djé ’li anɨ lɨ okpadjɨ de. ");
INSERT INTO mdm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Anɨ bú dú mbamba ɨnde agʉmʉ-o de, anɨ bʉ́lʉ dhegʉ eke ɨnde ngatsi-e de. Anɨ améne mo-o akólo lɨ ’kpɨ́ ɨnde anɨ aꞌó lɨe me ngbili ’ngʉ́ kolo angu e pɨ́la doto ko. ");
INSERT INTO mdm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abhomʉ-o, lɨ ndʉ opiga hana tsia ꞌó nabhuka gba o-o bhʉ́ anɨ.›» ");
INSERT INTO mdm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Abhomʉ-o, u ago pɨ Yesu ne kpála bini ɨnde ɨ u ’kpɨ́ de, ɨ bhʉ di ’ngʉ́ de, anga adʉ bhʉ́ kpála ango-o ne siti bua . Yesu akobho kpála ango-o, anɨ atsia aholo nagama ’ngʉ́ di ne nau ’kpɨ́. ");
INSERT INTO mdm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bhiti okpála hana angamba, u atsia aholo napa me: «A ɨnde-e Ndɨlɨ gba Davidi-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lɨ omʉFalisai adje engʉ́ bhomʉ-o lɨe, u atsia apa me: «Kpála bhomʉ-o ngapandja osisiti bua padhá ade, Baladjebula, ngámá gba osisiti bua-a, ngaha angu pɨ anɨ ngae!» ");
INSERT INTO mdm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Engʉ́ bini, Yesu adʉ ambɨla mabhundja gba uo hana. Abhomʉ-o, anɨ atsia apa pɨ uo me: «Ndʉ kʉtɨ hana, ɨ dʉ me okpála kpála nde dje lɨo de-e, kʉtɨ ango-o pípilo me a nde akpɵdhɵlɵ. Okpála na gʉdhʉ bini, ɨ dʉ di-e piga bini, ɨ dʉ me u nde dje lɨo de-e, gʉdhʉ ango-o, ɨ dʉ di-e piga ango-o lʉ́-ʉ de. ");
INSERT INTO mdm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ɨ dʉ me Satana nde ngabhike Satana-a, amba anɨ agbogbo bhomʉ-o bhʉsʉ e ngae makpe. Ɨ dʉ la mo-o, kʉtɨ gba anɨ-e lʉ́ lele pɨ? ");
INSERT INTO mdm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ɨ dʉ me ngama-a, ma nde ngapandja osisiti bua ka angu gba Beledjebula-a, omʉkpata gba yi-e ngapandja naao uo ka angu gba da? Kaka-a, omʉkpata gba yi-e akódho galikpe ’ngʉ́ gba yi-e ngao makpe. ");
INSERT INTO mdm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Engʉ́ bini, ɨ dʉ la me ma nde ngapandja osisiti bua ka angu gba Bua gba Ebhe-e, bhobhomʉ-o asuno me Naʉ gba Ebhe-e akolo lɨ yi akolo. ");
INSERT INTO mdm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kpála bini tɨ da nalɨ bhʉ́ ’tɨ gba kpéke kpála, anɨ tsia bhá ohe gba anɨ-e de. Anɨ kʉnda nalɨ bhʉ́ ’tɨ gba anɨ ngʉ́ nabha ohe gba anɨ-e hana-a, anɨ gbíte ngaɨza anɨ kalanʉ. Pɨpɨta-a, anɨ tsia lɨ́ bhʉ́ ’tɨ gba anɨ ngʉ́ nabha ohe gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kpála bhende ne ma bhʉ́ dabɨlɨ bini ade-e, a ko bhʉlʉ yala gba ma. Kpála bhende ngapo la di bhʉ́la okpála bhʉ́ dabɨlɨ bini ne ma ade-e, anɨ ngatsambala uo matsambala. ");
INSERT INTO mdm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kaka-a, ma apa pɨ yi me, okpála asía mambu lɨ ndʉ osisiti ’ngʉ́ di ne lɨ ndʉ osobho ɨnde lɨ okpála ngasobho Ebhe ne e hana. Engʉ́ la bini, lɨ kpála sobho Bu Bhobua-a, anɨ sía mambu de. ");
INSERT INTO mdm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɨ dʉ me kpála nde apa siti ’ngʉ́ lɨ kʉte ma, ngama Ndɨlɨ gba kpála-a, Ebhe mbu lɨ anɨ tété. Engʉ́ la bini, ɨ dʉ me kpála nde asobho Bu Bhobua-a, Ebhe mbú lɨ anɨ tété bhʉ́ nedhɨnga na nakɨ ɨnde-e de, anɨ mbú di lɨ anɨ tété bhʉ́ nedhɨnga ɨnde ngago-o de.» ");
INSERT INTO mdm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ɨ dʉ me ndula nde ndjɨndjɨ-e, lɨ́lɨ́-e dʉ́ bhadi ndjɨndjɨ. Ɨ dʉ me a nde bhʉ́ ndula ne kuo-o, lɨ́lɨ́-e dʉ́ sisiti. U mbɨmbɨla ndula lɨ lɨ́ e. ");
INSERT INTO mdm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ngayi opiga mbʉma ɨnde-e, yi tɨ da napa ongʉ́ na babadha lele pɨ, me yi nde ne okpála na sisiti-e? Padhá de, anga ebhɵ ngapa engʉ́ ɨnde abedhe lɨ bhobua mabedhe ko. ");
INSERT INTO mdm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kpála na babadha-a, ka bádha ’ngʉ́ ɨnde lɨ bhobua anɨ-e, anɨ apá bhadi bádha ’ngʉ́. Engʉ́ bini, kpála na sisiti-e, ka siti ’ngʉ́ ɨnde lɨ bhobua anɨ-e, anɨ apá bhadi engʉ́ na sisiti. ");
INSERT INTO mdm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kaka-a, ma apa pɨ yi me, bhʉ́ nedhɨnga nakodho ’ngʉ́ gba okpála-a, okpála apá ta oeli na padhá padhá ɨnde lɨ u apa e hana. ");
INSERT INTO mdm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Padhá de, anga Ebhe akódho ’ngʉ́ gba mʉ-o lɨ nakpata ’li mʉ. Ɨ dʉ me mʉ nde apa oeli na babadha-a, anɨ ꞌó mangɨmbo pɨ́ mʉ de, ɨ dʉ me mʉ nde apa oeli na sisiti-e, anɨ ꞌó mangɨmbo pɨ́ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Abhomʉ-o, omʉsuno koko na lɨ́lɨ gba Moidje di ne omʉFalisai koko apa pɨ Yesu me: «Mʉsuno, ya akʉnda me mene ehe bini pɨ ya ɨnde asuno me mo oyie bha ndjʉ agba Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Do anɨ pɨ uo me: «Okpála na nakɨ ɨnde-e sisiti, u bhuka la di Ebhe ne bua o bini de, u ngayo ngamba ’ngʉ́. Engʉ́ bini, Ebhe méne ngamba ’ngʉ́ pɨ uo bini de, bha bini bhende anɨ amene nanɨ e lɨ polofeta Djonasɨ ko. ");
INSERT INTO mdm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Padhá de, anga maka lɨ Djonasɨ asɨ nanɨ lɨe ekpɨ́ bata, di ne sukpe bata bhʉ́ ’bu ’ngbé sungu-o, ngama Ndɨlɨ gba kpála-a, ma asɨ́ bhadi bhʉ́ lata ekpɨ́ bata di ne sukpe bata moko. ");
INSERT INTO mdm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lɨ ’kpɨ́ lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, okpála na Ninive akóto kala Ebhe bhʉ́ dabɨlɨ bini ne okpála na nakɨ ɨnde, lɨ okpála na Ninive tsia ꞌó ’ngʉ́ pɨ́ okpála na nakɨ-o. Padhá de, anga u adji nanɨ bua o lɨ nedhɨnga u adje ngali gba Ebhe ɨnde lɨ Djonasɨ adʉ akpokpo e-o. Yi mbɨla la ndjɨndjɨ me, kpála bini sɨ, anɨ ngbéngbé ane Djonasɨ mane! ");
INSERT INTO mdm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Matá di-e, lɨ ’kpɨ́ lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, ’ngbé ngámá na ɵɵlɵ ɨnde adʉ nanɨ atsia ’kpɨ́ lɨ ndu doto na Saba-a, akóto kala Ebhe bhʉ́ dabɨlɨ bini ne okpála na nakɨ ɨnde. Anɨ tsia ꞌó ’ngʉ́ pɨ́ uo, anga anɨ ayie nanɨ tsutsu ngʉ́ nanʉ nadje eli na ɨmbɨlangʉ gba Salomo-o. Yi mbɨla la ndjɨndjɨ me, kpála bini sɨ, anɨ ngbéngbé ane Salomo mane! Engʉ́ bini, ngayi-e, yi dje anɨ de.» ");
INSERT INTO mdm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Abhomʉ-o, Yesu atsia apa matá gbitaku pɨ kambɨ okpála me: «Adʉ nanɨ bhʉ́ kpála bini ne siti bua. Nedhɨnga lɨ siti bua akoto lɨe bhʉ́ anɨ-e, siti bua ango-o anʉ ne djakadha abhʉ́ obɨlɨ ɨnde lɨ engu nde lɨ e ade ngʉ́ nagɨlɨ bɨlɨ naguo ka e tété. Engʉ́ bini, anɨ u de. ");
INSERT INTO mdm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Anɨ atsia apa lɨ bua e me: ‹Ma gie nga lɨma bhʉ́ ’tɨ gba ma ɨnde ma akoto nako bhʉ́ e-o.› Anɨ akolo oo, anɨ abhaka me a nde padhá, u nde apo mapo, u nde aleke ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Abhomʉ-o, anɨ anʉ, anɨ abha osisiti bua koko mananɨka ɨnde ane anɨ ne siti. U agie lɨo, u alɨ bhʉ́ ’tɨ-o, u atsia dʉlʉ oo. Mʉkobho gba kpála ango-o atsia akolo la matá pɨpɨta-a sisiti naali ane bhende na kalanʉ-o mane. A adʉ́ bhadi pɨ osisiti okpála na nakɨ ɨnde-e moko.» ");
INSERT INTO mdm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu adʉ ngabha nagama ’ngʉ́ pɨ kambɨ okpála-o. Me-e, ’hi anɨ di ne ondaise anɨ akolo. U alʉlʉ akilidjo, u adʉ agɨlɨ me o gama ’ngʉ́ ne anɨ.  ");
INSERT INTO mdm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu agie pɨ kpála ɨnde apa ’ngʉ́ pɨ anɨ-e me: «’Hi ma ngae dho, ondaise ma la di ngao dho?» ");
INSERT INTO mdm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pɨpɨta-a, anɨ aꞌe ’kpa e, anɨ asuno omʉkpata gba e-o. Anɨ atsia apa me: «Yi tsitsia, ’hi ma ne ondaise ma ngao ɨnde. ");
INSERT INTO mdm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Padhá de, anga kpála ɨnde ngamene engʉ́ lɨ ’Dyɨ ma ɨnde abhʉ́lá-a ngakʉnda e, kpála ango-o, a ko ndai ma na bhobhoko, a ko ndai ma na ɵɵlɵ, a ko la di ’hi ma-a ngae.» ");
INSERT INTO mdm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bha lɨ ’kpɨ́ ango-o, Yesu akoto kilidjo. Anɨ atsia anʉ adʉ kuto lɨngo ekpɵ. ");
INSERT INTO mdm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Abhomʉ-o, bhiti okpála na bhibhiti ago apo bhʉ́la o de anɨ. Kaka-a, anɨ anʉ aꞌʉ bhʉ́ zabʉ bini, anɨ atsia adʉ bhʉ́bhʉ́ ngʉ́ nasuno pɨ uo. Bhiti okpála bhomʉ-o atsia alʉlʉ naao lɨngo ’ngu-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Anɨ atsia aholo nakpokpo ’ngʉ́ pɨ uo bhelé bhʉ́ ogbitaku. Anɨ adʉ apa pɨ uo me: «Ekpɨ́ bini, kpála bini nalu nguwa anʉ abhiye gba e ngʉ́ nabala nguwa. ");
INSERT INTO mdm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nedhɨnga anɨ adʉ ababala lɨe, té nguwa koko abala lɨngo ’hi kpadjɨ. Odhu ago, u atsia ahopo nguwa ango-o hana má kpɵkɵbhɵ! ");
INSERT INTO mdm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Olɨ́ nguwa koko abala lɨ bɨlɨ na teme, ɨnde lɨ doto dʉ lɨ e bhelé de. Ɨ nde lɨe me doto dʉ sasa bhelé de-e, ezʉ-o akɵ má gala ka lɨ doto akpa sasa lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lɨ ela akolo la lɨe kpekpeke-e, a atsulu ezʉ-o, ezʉ atsia aꞌʉlʉ ka ndɨbhɨlɨ sisie-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Olɨ́ nguwa koko abala lɨ bɨlɨ lɨ lɨ́ oulu na eti adʉ lɨe. Oeti abhele, a atsia anguvo bhobhomʉ-o hana. ");
INSERT INTO mdm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Olɨ́ nguwa koko abala bhʉ́ doto na dobho, a atsia alɨ lɨ́lɨ́: bhe bini-e alɨ lɨ́lɨ́ kámá bini, koko-o alɨ lɨ́lɨ́ ndjɨkpa madhɨa, koko-o alɨ lɨ́lɨ́ ndjɨkpa bata.» ");
INSERT INTO mdm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu atsia apa matá me: «Yi dje ndjɨndjɨ, ɨ dʉ me a nde lɨ yi ne djedje ko!» ");
INSERT INTO mdm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abhomʉ-o, omʉkpata gba Yesu adyudyo lɨo de anɨ, u atsia ayi anɨ me: «Mʉ ngakpokpo ’ngʉ́ pɨ okpála bhʉ́ ogbitaku ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Do anɨ de-e: «Ma ngakpo ’ngʉ́ pɨ uo bhʉ́ ogbitaku anga Ebhe ha nambɨla ngbadhʉ ’ngʉ́ na Naʉ na abhʉ́lá-a pɨ uo de. Anɨ aha mangbo pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Padhá de, anga kpála ɨnde anɨ aha ngbadhʉ ’ngʉ́ ango-o pɨ e-e, anɨ aꞌó matá koko pɨ anɨ pépé. Kpála ango-o tsia dʉ́ ne di bhelé. Engʉ́ bini, kpála bhende anɨ ha pɨ e de-e, anɨ adhépe belegʉ dhegʉ bhende ka anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ka ’ngʉ́ ango-o, ma ngakpo ’ngʉ́ pɨ uo bhʉ́ ogbitaku. Padhá de, anga u ngatsia ’kpɨ́, u u la ’kpɨ́ de, u ngagbo ’dje o, u dje la ’kpɨ́ de, u kɵ la di mboli ’ngʉ́ bini de. ");
INSERT INTO mdm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Abhomʉ-o, engʉ́ ɨnde lɨ polofeta Ɨsaya apa e, a atsia amene lɨe pɨ uo, engʉ́ ɨnde me: ‹Ebhe apa me: Yi adʉ́ adje ’kpɨ́, yi kɵ́ la mboli engʉ́ ango-o de. Yi adʉ́ atsia ’kpɨ́, yi ú la ’kpɨ́ de.› ");
INSERT INTO mdm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‹Padhá de, anga Ebhe apa me: okpála ɨnde-e agbite bua o, ngʉbula me o kɵ́ matá mboli ’ngʉ́ de. U anini djila o, amba o oú matá ’kpɨ́ de, u anini ’dje o, amba o odjé matá ’kpɨ́ de. U kʉnda nanɨ nadji bua o de, abhomʉ-o, ma tsia tɨ nanɨ da nakobho uo de.› ");
INSERT INTO mdm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","La pɨ yi-e, a ko djalɨ pɨ yi anga djila yi ngau ’kpɨ́, ’dje yi la di ngadje ’kpɨ́. ");
INSERT INTO mdm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ma apa pɨ yi na paká me opolofeta bhelé, di ne okpála na ngbingbili bhelé adʉ nanɨ ne gʉmʉ nau ongʉ́ yi ngau e ɨnde, la-a, u tsia u de. U adʉ nanɨ ne gʉmʉ nadje ongʉ́ yi ngadje e ɨnde, la-a, u tsia dje de.» ");
INSERT INTO mdm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Abhomʉ-o, Yesu atsia apa matá pɨ omʉkpata gba e me: «Ngayi-e, yi dje nga la ta gbitaku gba kpála nalu nguwa-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Obhende ngadje ngali na Naʉ gba Ebhe-e , ɨ kɵ mbolimboli de-e, uo maka ngo ’hi kpadjɨ ɨnde lɨ nguwa atɨ lɨ e-o. Djabʉlʉ ngago, anɨ tsia dhépe ’li Ebhe ɨnde u asia e lɨ bua o-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Okpála koko maka bɨlɨ na teme ɨnde lɨ nguwa atɨ lɨ e-o. U ngadje eli-o, u tsia sía kolo ne djalɨ. ");
INSERT INTO mdm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Engʉ́ bini, u ꞌo de me eli-e toto sie e abhʉ́ o-o de. U ngaha lɨo ngánga bha ngʉbula nedhɨnga bedɨ. Abhomʉ-o, ɨ dʉ me lɨkabhu, ɨ dʉ di-e mbolo nde ago kabula eli gba Ebhe-e , u ngabala ’kpa lɨ nabhuka má gala! ");
INSERT INTO mdm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Okpála koko maka bɨlɨ lɨ lɨ́ oulu na eti adʉ lɨe-o. U adje eli-o, engʉ́ bini, gʉmʉ ’he na doto ɨnde bhʉ́ dabɨlɨ bini ne eu lɨ tɨa na doto ɨnde-e ngapite uo ne e, nganguvo eli gba Ebhe-e bhʉ́ uo. Kaka-a, a tsia lɨ́ lɨ́lɨ́ belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Engʉ́ bini, okpála koko maka doto na dobho. U ngadje eli-o, u la di ngakɵ mbolimboli. Kaka-a, kulu gba uo ngazu nguwa. Kulu gba okpála koko ngazu nguwa kámá bini, bhe gba okoko ndjɨkpa madhɨa, bhe gba okoko ndjɨkpa bata.» ");
INSERT INTO mdm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu atsia apa matá gbitaku koko pɨ okpála adʉ adje anɨ-e me: «Naʉ na abhʉ́lá-a mana lɨe ne engʉ́ ɨnde: bhoko bini alu nanɨ bádha nguwa abhiye gba e. ");
INSERT INTO mdm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sukpe bini, nedhɨnga lɨ ndʉ okpála hana adʉ lɨe tɨla-a, bhʉlʉ yala gba anɨ-e ago. Anɨ atsia alu siti ulu bhʉ́ ká nguwa-o, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ezʉ-o akɵ, abhele, atsia aba lɨ́lɨ́. Abhomʉ-o, siti ulu-o atsia akoto di. ");
INSERT INTO mdm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Okpála na kulu gba bhʉlʉ edyɨ-e ago ayi anɨ me: ‹Ngámá, siti ulu ɨnde-e ayie bhʉ́ bádha nguwa mo olu nako e bhʉ́ ’dyɨ gba mʉ-o su?› ");
INSERT INTO mdm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Do anɨ pɨ uo me: ‹Bhʉlʉ yala amene engʉ́ bhomʉ-o ngae.› Abhomʉ-o, okpála na kulu-o atsia ayi anɨ me: ‹Mo okʉnda me ya nʉ luko siti ulu ango-o?› ");
INSERT INTO mdm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Anɨ agie pɨ uo me: ‹Yi alúko de, anga yi luko-o, yi nʉ́ lúko siti ulu bhomʉ-o ne ezʉ-o bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yi ꞌo me ndʉndʉ bhisi hana bhele bhʉ́ dabɨlɨ bini akólo nedhɨnga naꞌe nguwa abhiye-o. Nedhɨnga naꞌe nguwa abhiye-e, ma apá pɨ okpála naꞌe nguwa-a me u ꞌe ngaɨza siti ulu-o. U gbigbite ꞌiꞌi ngʉbula natsutsulu, amba pɨpɨta-a, u ꞌo nguwa-a bhʉ́ ngbokopi gba ma-o.›» ");
INSERT INTO mdm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu akpokpo matá gbitaku koko pɨ okpála adʉ adje anɨ-e pɨndjɨ lɨ́ ndula ɨnde u aꞌɨ e me mʉtadi. Anɨ pɨ uo me: «Naʉ na abhʉ́lá-a mana lɨe ne lɨ́ mʉtadi. Kpála bini aha, anɨ atsia alu abhiye gba e. ");
INSERT INTO mdm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A ko lɨ́ ndula na yeye ane mane bhʉ́ ká olɨ́ nguwa hana. Engʉ́ la bini, ɨ dʉ me a nde akɵ-o, ɨ né ndʉ ezʉ ɨnde abhʉ́ ’dyɨ-e hana ne endjá, ɨ kólo ’ngbé ndula da napa me odhu na abhʉ́lá go nayiki ’tɨ o bhʉ́ oyáyá-o.» ");
INSERT INTO mdm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu akpokpo matá gbitaku koko pɨ okpála adʉ adje anɨ-e me: «Naʉ na abhʉ́lá mana lɨe ne levile ɨnde lɨ ɵlɵ aha e, anɨ atsia akpɵdhɵlɵ ne bhiti fufú. Abhomʉ-o, fufú-o hana atsia afuka.» ");
INSERT INTO mdm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu adʉ akpokpo ndʉ ’ngʉ́ bhomʉ-o hana pɨ bhiti okpála bhʉ́ ogbitaku. Anɨ kpo ’ngʉ́ pɨ uo mandɨ gbitaku belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Anɨ adʉ amene mo-o ngʉbula me engʉ́ ɨnde nanɨ lɨ polofeta akpokpo e-e amene lɨe, engʉ́ ɨnde me: «Ma akpókpo ’ngʉ́ bhʉ́ ogbitaku. Ma akpókpo ’ngʉ́ ɨnde awo lɨe nayie maka u abho nanɨ doto lɨe-o.» ");
INSERT INTO mdm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Abhomʉ-o, Yesu aꞌo ká bhiti okpála ɨnde anɨ adʉ akpo ’ngʉ́ pɨ o-o, anɨ atsia agie lɨe lɨ bɨlɨ anɨ adʉ nadʉ lɨ e-o. Omʉkpata gba anɨ-e adyudyo lɨo de anɨ. U atsia apa pɨ anɨ me: «Kpokpo nga ta gbitaku pɨndjɨ siti ulu ɨnde abhiye-e pɨ ya.» ");
INSERT INTO mdm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu atsia agie pɨ uo me: «Kpála bhende ɨ ngalu bádha nguwa-a, a ko ma Ndɨlɨ gba kpála-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Edyɨ-e, a ko doto. Bádha nguwa-a, a ko okpála ɨnde ɨ ngazɨba nadʉ sa lɨ́lɨ na Naʉ na abhʉ́lá-o. Siti ulu-o, a ko okpála bhende ngazɨba nadʉ sa lɨ́lɨ gba Djabʉlʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bhʉlʉ yala ɨnde alu siti ulu-o, a ko Djabʉlʉ. Nedhɨnga naꞌe nguwa abhiye-e, a ko ekpɨ́ na soso-o. Obhʉlʉ naꞌe nguwa abhiye-e, a ko oandjelu . ");
INSERT INTO mdm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Maka u akukuo siti ulu lɨe ngʉ́ nabubu bhʉ́ djua-a, a adʉ́ bhadi lɨ sokpɨ́-e moko. ");
INSERT INTO mdm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ndɨlɨ gba kpála atíma oandjelu gba e, u tsia kúo ndʉ obhʉlʉ nato okpála bhʉ́ nale ne ndʉ obhʉlʉ namene siti ’ngʉ́ hana-a ngʉ́ napandja uo bhʉ́ ká omaha e mapandja. ");
INSERT INTO mdm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pɨpɨta-a, u tsia bála uo bhʉ́ dé djua. Oo, u adʉ́ aku ’gbá, u tsia dʉ́ di nazʉ tate o. ");
INSERT INTO mdm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Abhomʉ-o, okpála bhe na ngbingbili-e adʉ́ nasʉ má ngbɨ ngbɨ ngbɨ maka ela bhʉ́ Naʉ gba ’Dyɨ o-o. Yi dje ndjɨndjɨ, ɨ dʉ me a nde lɨ yi ne djedje-o!» ");
INSERT INTO mdm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Naʉ na abhʉ́lá-a mana lɨe ne tɨa ɨnde lɨ kpála awo e abhʉ́ ’dyɨ. Kpála bini akoto tété, anɨ atsia awo ne toto. Lɨ djalɨ abhɵlɵ la anɨ lɨe má kusu-o, anɨ anʉ atsɨndjɨ ndʉ ’he gba e hana, anɨ atsia ago akala edyɨ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Naʉ na abhʉ́lá-a mana di matá lɨe ne kpála natsɨndjɨ ’he ɨnde ngagɨlɨ nakala babadha léké. ");
INSERT INTO mdm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nedhɨnga anɨ au léké bini na kpéke mase lɨe, anɨ anʉ atsɨndjɨ ndʉ ’he adʉ ka e hana. Anɨ atsia ago akala léké na kpéke mase-o.» ");
INSERT INTO mdm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Naʉ na abhʉ́lá-a mana matá lɨe ne nado ɨnde u abhike e bhʉ́ ’ngu, ɨnde ɨ ngadhe ndʉ djua osungu hana. ");
INSERT INTO mdm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nedhɨnga abedhe lɨe, obhʉlʉ nagbe sungu-o gbéle lɨngo ’gɵ. Pɨpɨta-a, u dʉ́lʉ, u bhá osungu na babadha-a bhʉ́ kíli, u tsia bála obhende azi-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","A adʉ́ bhadi lɨ sokpɨ́-e moko: oandjelu agó, u tsia gbógbo bhʉsʉ okpála na ngbingbili-e ne obhende na sisiti-o. ");
INSERT INTO mdm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","U tsia bála okpála na sisiti-e bhʉ́ dé djua. Oo, u adʉ́ aku ’gbá, u tsia dʉ́ di nazʉ tate o.» ");
INSERT INTO mdm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu atsia ayi omʉkpata gba e me: «Yi akɵ mboli ndʉ ongʉ́ bhomʉ-o hana akɵ?» U agie me: «Heni.» ");
INSERT INTO mdm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Abhomʉ-o, anɨ atsia apa pɨ uo me: «A moko, yi maka ndʉ omʉsuno na lɨ́lɨ gba Moidje hana ɨnde azɨba engʉ́ pɨndjɨ Naʉ na abhʉ́lá-o. Yi maka obhʉlʉ ’tɨ. Yi ngalo bhʉ́ ká oehe ɨnde bhʉ́ ’tɨ gba yi-e obhe na mbɨa, yi tsia ló di obhe na didili.» ");
INSERT INTO mdm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lɨ Yesu andjia nakpokpo ogbitaku bhomʉ-o lɨe, anɨ ayie oo. ");
INSERT INTO mdm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Anɨ atsia anʉ bhʉ́ Nadjaleta, kʉtɨ ɨnde anɨ abhele bhʉ́ e-o. Anɨ aholo nasuno bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje na kʉtɨ bhomʉ. Nasuno gba anɨ-e atsia adʉ nangamba okpála naali. Kaka-a, u atsia adʉ ayi lɨo me: «Anɨ asia ngua ɨmbɨlangʉ ɨnde-e su? A aha angu pɨ anɨ ngʉ́ namene ongamba ’ngʉ́ ɨnde-e da? ");
INSERT INTO mdm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A ɨnde-e ndɨlɨ gba salapaté-e dɨ? A ’lɨ ’hi anɨ me Malɨa adɨ? Djakɨ, ne Djodjefʉ , ne Simo la di ne Djude ne ondaise anɨ ngao adɨ? ");
INSERT INTO mdm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ondaise anɨ na olɨsɨlɨsɨ-e, ndʉ uo hana gba nɨ́ sɨɨ adɨ? Anɨ ayie la ne ndʉ ’ngʉ́ bhomʉ-o hana su?» ");
INSERT INTO mdm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ka u ambɨla dʉ anɨ lɨe ndjɨndjɨ-e, u tsia kʉnda nabhuka anɨ de. Abhomʉ-o, Yesu atsia apa pɨ uo me: «U mamanga polofeta ne ndʉ bɨlɨ hana, naneke bha bini bhʉ́ kʉtɨ u azu anɨ bhʉ́ e di ne bhʉ́ piga gba anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu atsia amene bha mbo oo ongamba ’ngʉ́ bedɨ ka u bhuka anɨ lɨe de-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lɨ nedhɨnga bhomʉ-o, Elode Atipasɨ ɨnde adʉ ngámá na ndu doto na Galilaya adje engʉ́ gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Anɨ atsia apa pɨ omaha e me: «Kpála u ngakpo ’ngʉ́ gba e bhomʉ-o, a ko Djaa bhʉlʉ nabatisa okpála! Anɨ azuku bhʉ́ ká okpála amu-o bhomʉ ngae. Kaka-a, angu namene ongamba ’ngʉ́ bhʉ́ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Elode pa mo-o padhá de. Anɨ apa mo-o, anga anɨ aha nanɨ lɨ́lɨ me u holo Djaa, u gbigbite anɨ, amba u bhike anɨ bhʉ́ tɨkpʉ lɨ ’ngʉ́ gba Elodiade, wala Filipo, ndai anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Anɨ aholo nanɨ Djaa, anga Djaa adʉ apa pɨ anɨ me: «A ayo de me mʉ ha Elodiade maka wala mʉ-o de.» ");
INSERT INTO mdm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Elode adʉ akʉnda nabhɵlɵ Djaa na paká. Engʉ́ bini, anɨ adʉ akpe okpála makpe. Padhá de, anga u adʉ au Djaa maka polofeta . ");
INSERT INTO mdm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","La-a, lɨ ekpɨ́ nakina nazu Elode-e, ndɨlɨ na ɵɵlɵ gba Elodiade adho ’bɨ kala okpála u aꞌɨ o bhʉ́ ’bɨ-o. Ebɨ ango-o atsia anga lɨ Elode naali. ");
INSERT INTO mdm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kaka-a, anɨ atsia atʉ silika me nɨ ahá pɨ ndɨlɨ na ɵɵlɵ bhomʉ-o ndʉ ’he hana ɨnde anɨ ayó e-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","’Hi anɨ atsia ato pɨ anɨ me anɨ yo ’ndjɨ Djaa bhʉlʉ nabatisa okpála. Abhomʉ-o, ndɨlɨ-e atsia anʉ apa pɨ ngámá Elode me: «Ha ’ndjɨ Djaa, Bhʉlʉ nabatisa okpála mʉma mbɨa ɨnde-e bhʉ́ tsakpa saanɨ!» ");
INSERT INTO mdm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngámá adje lɨkabhu lɨ bua e naali. La ka silika anɨ atʉ e di ne nakpe djila okpála anɨ aꞌɨ o bhʉ́ ’bɨ-e, anɨ atsia aha lɨ́lɨ me u ha ’ndjɨ Djaa pɨ anɨ haha. ");
INSERT INTO mdm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Abhomʉ-o, anɨ atsia atima kpála bini me anɨ nʉ kodho ngʉlʉ Djaa bhʉ́ tɨkpʉ. ");
INSERT INTO mdm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kpála ango-o, anʉ. Anɨ akodho ngʉlʉ Djaa, anɨ atsia ago ne di bhʉ́ tsakpa saanɨ. Anɨ atsia aha pɨ ndɨlɨ na ɵɵlɵ bhomʉ-o. Abhomʉ-o, ndɨlɨ na ɵɵlɵ ango-o atsia anʉ ne di pɨ ’hi e. ");
INSERT INTO mdm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Omʉkpata gba Djaa anʉ aha kuo anɨ, u anʉ azɨ. U atsia anʉ akpokpo engʉ́ akodho ’kpɨ́ bhomʉ-o pɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lɨ Yesu adje engʉ́ lɨ omʉkpata gba Djaa akpokpo e pɨ anɨ-e lɨe, anɨ agbe lɨe lɨ bɨlɨ bhomʉ. Anɨ aꞌʉ ne omʉkpata gba e bhʉ́ zabʉ, u atsia anʉ adʉlʉ kpi o kpi lɨ bɨlɨ lɨ kpála nde lɨ e ade. Lɨ okpála ambɨla lɨe, u aloko ne ogʉdhʉ ngangá, u aha ’nʉ́ ne ’dhʉ o lɨngo ’ngu-o ngʉ́ nanʉ nakpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lɨ Yesu akɵ lɨe bhʉ́ zabʉ-o, anɨ au bhiti okpála-o. Anɨ adje ndjinga uo, anɨ atsia akobho okpála na kuo ɨnde adʉ bhʉ́ ká uo-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A akolo lɨe tagolo-o, omʉkpata adyudyo lɨo de anɨ. U atsia apa pɨ anɨ me: «Ngámá, ekpɨ́-e asegele, bɨlɨ ɨnde-e la di mimili, gie bhiti okpála ɨnde-e, amba u nʉ kala ehe nazʉ mazʉ pɨ o bhʉ́ okʉtɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Engʉ́ bini, Yesu agie pɨ uo me: «Tata lɨ nagie lɨe ka uo ade. Yi ha ezʉ pɨ uo ngayi makpe.» ");
INSERT INTO mdm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Abhomʉ-o, omʉkpata apa pɨ anɨ me: «A bha ka ya sɨ ne koli mapa bhuluvue ne osungu bhisi má kpɨkɨlɨ!» ");
INSERT INTO mdm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu agie pɨ uo me: «Yi go mʉma ne di ei.» ");
INSERT INTO mdm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pɨpɨta-a, anɨ aha lɨ́lɨ pɨ bhiti okpála bhomʉ-o me u dʉlʉ kuto pɨ́ ulu-o. Anɨ atsia aha mapa bhuluvue ne osungu bhisi-o. Anɨ aꞌe djila e ne abhʉ́lá, anɨ agie heni pɨ Ebhe. Pɨpɨta-a, anɨ agʉgʉmʉ mapa-o, anɨ aha pɨ omʉkpata, omʉkpata-a atsia agapa lɨ bhiti okpála me u zʉzʉ. ");
INSERT INTO mdm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","U azʉ ndʉ o hana, u atsia aꞌuꞌu. U alo dudu bhe atigala-o, a atsia abebedhe okíli ndjɨkpa ne ká bhisi. ");
INSERT INTO mdm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Okpála hana ɨnde azʉ-o, u adʉ masɨkpe de okpála kutu bhuluvue mandɨ natanga olɨsɨ ne ongɨsɨ. ");
INSERT INTO mdm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pɨpɨta kolo me-e, Yesu akata omʉkpata gba e me u ꞌʉꞌʉ bhʉ́ zabʉ, amba u gulu ’ngu pɨ nɨ kalanʉ bhʉ́ nedhɨnga nɨ nde nga lɨe ngaha kpadjɨ pɨ bhiti okpála-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pɨta anɨ aha kpadjɨ pɨ bhiti okpála lɨe, anɨ aꞌʉ apɨ́ ’ta ngʉ́ nayo Ebhe. Ekpɨ́ abi lɨ anɨ kpi e kpi me anɨ nde nga bha oo. ");
INSERT INTO mdm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lɨ zabʉ lɨ omʉkpata-a adʉ bhʉ́ e akolo lɨe mbo ne atʉ ’ngu-o, anvi aholo nape pɨ́ ’ngu-o, atsia adʉ nandi uo ne sidi. Zabʉ-o atsia adʉ adimba ka ngbo ’ngu-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bhʉ́ ’gbá ’ngʉ na bini-e, Yesu aholo nago ne lɨ pápá ne apɨ́ uo me anɨ nde ngadholo pɨ́ ’ngu. ");
INSERT INTO mdm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lɨ omʉkpata au anɨ lɨe ngadhʉkʉ pɨ́ ’ngu-o, tsʉlʉ aholo uo naali. U adʉ apa me: «A ko ɨgbadyɨbhe!» U atsia aholo atʉ ꞌue ka tsʉlʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Engʉ́ bini, Yesu atsia apa kolo pɨ uo me: «A ko ma, yi adjé tsʉlʉ de. Yi gbite bua yi.» ");
INSERT INTO mdm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Abhomʉ-o, Piele atsia apa pɨ anɨ me: «Ngámá, ɨ dʉ me a nde mʉ na paká-a, ha lɨ́lɨ me ma go bhaka mʉ me ma nde ngadhʉkʉ pɨ́ ’ngu.» ");
INSERT INTO mdm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Do Yesu de-e: «Gogo.» Abhomʉ-o, Piele akɵ bhʉ́ zabʉ-o, anɨ aholo ’nʉ́ nabhaka Yesu me anɨ nde ngadholo pɨ́ ’ngu. ");
INSERT INTO mdm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Engʉ́ bini, anɨ au lɨe me anvi-e ngape kpekpeke-e, anɨ adje tsʉlʉ. Abhomʉ-o, anɨ aholo nalinda bhʉ́ ’ngu. Anɨ atsia asʉla me: «Ngámá, kobho ma!» ");
INSERT INTO mdm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma ’li ma me-e, Yesu ato ’kpa e, anɨ atsia aholo anɨ ne napa pɨ anɨ me: «Ngamʉ, kpála lɨ nabhuka gba e nde yeye, mo osia bua na bhisi bhisi ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pɨpɨta-a, u aꞌʉꞌʉ ndʉ o bhisi hana bhʉ́ zabʉ-o. Anvi atsia aguo. ");
INSERT INTO mdm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Abhomʉ-o, omʉkpata bhe adʉ ɨgɨnɨ bhʉ́ zabʉ-o akikita lɨpʉkʉ o kuto kala Yesu. U atsia apa pɨ anɨ me: «A na paká me mʉ ne Ndɨlɨ gba Ebhe!» ");
INSERT INTO mdm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pɨta lɨ Yesu ne omʉkpata gba e agulu ’ngu-o lɨe, u akolo bhʉ́ ndu doto na Genedjaleta. ");
INSERT INTO mdm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Okpála na kʉtɨ ango-o ambɨla lɨe me a ko Yesu-o, u agapa ngali nago ka anɨ-e bhʉ́ ndu doto ango-o libhomu. Okpála atsia ago pɨ anɨ ne ndʉ obhʉlʉ kuo hana. ");
INSERT INTO mdm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","U atsia adʉ akikiliki lɨo pɨ anɨ me anɨ ꞌo o me o bu nga bha mbo ’kpa o lɨ ’so bongo gba anɨ-o. Abhomʉ-o, ndʉ obhende hana adʉ abu ’kpa o tété-e adʉ akobho. ");
INSERT INTO mdm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Abhomʉ-o, omʉFalisai di ne omʉsuno na lɨ́lɨ gba Moidje ɨnde ayie bhʉ́ Yelusalema anʉ abhaka Yesu. U atsia ayi anɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Omʉkpata gba mʉ-o ngagʉmʉ lɨ́lɨ lɨ onguo ogbi ya aꞌo nanɨ e ka nɨ? Padhá de, anga u ngavʉlʉ ’kpa o kala nazʉ ’he maka lele lɨ lɨ́lɨ-e apa lɨe ade.» ");
INSERT INTO mdm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Anɨ atsia agie pɨ uo me: «Ala yi-e, yi ngagʉmʉ lɨ́lɨ gba Ebhe-e ne ’lɨ dasʉndʉ gba yi-e ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Padhá de, anga Ebhe apa me: ‹Manga ’dyɨ mʉ ne ’hi mʉ mamanga.› Anɨ apa di matá me: ‹Kpála ɨnde agbó nganda ’dyɨ e, ɨ dʉ di-e ’hi e, a ayo me u bhɵlɵ anɨ mabhɵlɵ.› ");
INSERT INTO mdm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Engʉ́ bini ngayi-e, yi ngapa me: ‹Ɨ dʉ me kpála bini nde apa pɨ okpála ɨnde azu anɨ-e me, tɨa ɨnde a ayo ɨgɨnɨ me nɨ teteke uo ne e, nɨ aꞌo pɨ Ebhe-e, ");
INSERT INTO mdm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kpála ango-o matá ne engʉ́ namene mamene pɨ uo ade.› Yi ngagʉmʉ lɨ́lɨ gba Ebhe-e lɨ ongua okpadjɨ bhomʉ ngʉ́ nakpata lele odasʉndʉ gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yi ne obhʉlʉ kali! Polofeta Ɨsaya pa nanɨ lɨ ’ngʉ́ gba yi-e tala me Ebhe apa me: ");
INSERT INTO mdm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Opiga ɨnde-e ngadhɵgɵ bha ma ne ’bhɵ-o, engʉ́ bini, bua uo de ma tsutsu. ");
INSERT INTO mdm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mayo u ngayo ma lɨe, tata tété ade. Padhá de, anga nasuno ɨnde u ngasuno e, a ko bha ndʉ olɨ́lɨ lɨ okpála ngagbe e ngao.›» ");
INSERT INTO mdm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pɨpɨta-a, Yesu aꞌɨ bhiti okpála ɨnde adʉ oo me u dyudyo lɨo de nɨ masɨkpe, anɨ atsia apa pɨ uo me: «Yi djedje nga, amba yi kɵ di mboli engʉ́ ɨnde ma adji apa e ɨnde: ");
INSERT INTO mdm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A ko de me oehe ɨnde ngalɨ bhʉ́ ’bhɵ kpála ngamene ngae me anɨ adʉ́ bubu kala Ebhe de-e de. Oehe bhe ngakoto bhʉ́ ’bhɵ kpála mangbo ngamene ngae me anɨ adʉ́ bubu kala Ebhe de.» ");
INSERT INTO mdm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Abhomʉ-o, omʉkpata-a adyudyo lɨo de anɨ, u atsia apa pɨ anɨ me: «Mʉsuno, mʉ mbɨla uu me engʉ́ mo opa e ake lɨ bua omʉFalisai make-e?» ");
INSERT INTO mdm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Anɨ agie pɨ uo me: «Ndʉ ’he hana ɨnde lɨ ’Dyɨ ma ɨnde abhʉ́lá-a lu e ngae de-e, u alúko maluko. ");
INSERT INTO mdm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yi ꞌo uo: a ko okpála ɨ u ’kpɨ́ de ɨnde aholo ’kpa obɨ o ngʉ́ nasuno kpadjɨ pɨ uo. La-a, ɨ dʉ me kpála ɨ u ’kpɨ́ de-e nde aholo ’kpa kilí e ngʉ́ nasuno kpadjɨ pɨ anɨ-e, ndʉ uo bhisi hana bála bhʉ́ ’dú!» ");
INSERT INTO mdm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piele atsia apa pɨ anɨ me: «Kpokpo nga ta gbitaku bhomʉ-o pɨ ya.» ");
INSERT INTO mdm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Do Yesu de-e: «Ngayi di-e, ɨmbɨlangʉ nga bhʉ́ yi adɨ? ");
INSERT INTO mdm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yi mbɨla de me ndʉ ’he hana ɨnde ngalɨ bhʉ́ ’bhɵ kpála ngakodho ’kpɨ́ abhʉ́ ’bu, u tsia bhíke bhʉ́ pedu-o dɨ? ");
INSERT INTO mdm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Engʉ́ bini, ndʉ ’he hana ɨnde ngakoto bhʉ́ ’bhɵ kpála ngayie lɨ bua anɨ. A la bhomʉ-o bhende ɨ ngamene me anɨ adʉ́ bubu kala Ebhe de-o. ");
INSERT INTO mdm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Padhá de, anga bua kpála ngamene ngae me anɨ dʉ ne mabhundja na sisiti, anɨ bhɵlɵ kpála bhʉ́ gandji, anɨ kʉnda ɵlɵ, ɨ dʉ di-e bhoko koko, anɨ kʉnda olɨsɨ, ɨ dʉ di-e obhosɨ ngangá, anɨ zi ’he, anɨ pa ’ngʉ́ lɨ obɨ e ne eu, anɨ sobho la di kpála. ");
INSERT INTO mdm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A bhomʉ-o ndʉ ongʉ́ ɨnde ngamene me kpála adʉ́ bubu kala Ebhe de-o. A ko de me nazʉ ’he mandɨ navʉlʉ ’kpa o ngamene me kpála adʉ́ bubu kala Ebhe de-e de.» ");
INSERT INTO mdm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pɨpɨta-a, Yesu ne omʉkpata gba e ayie lɨ bɨlɨ bhomʉ, u atsia anʉ lɨ pápá na ndu doto lɨ ogʉdhʉ na Tile ne Sidona adʉ bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ɵlɵ bini dʉ nanɨ nadʉ bhʉ́ ndu doto ango-o. A adʉ nanɨ ɨgba maYuda de, a ko nanɨ naae ɨgba Kanana. Me-e, anɨ ago abhaka Yesu ne nasʉsʉla me: «Ngámá, ndɨlɨ gba Davidi, dje nga bha-a mbo ndjinga ma! Siti bua ngato mbolo lɨ ndɨlɨ na ɵɵlɵ gba ma-a naali.» ");
INSERT INTO mdm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Engʉ́ bini, Yesu gie engʉ́ pɨ anɨ belegʉ de bini. Omʉkpata gba anɨ adyudyo lɨo de anɨ, u atsia apa pɨ anɨ me: «Mʉsuno, mʉ tɨ da namene engʉ́ anɨ ngayo e ka mʉ-o pɨ anɨ dɨ, amba anɨ ꞌo nakpata nɨ́ ne tolo gba e bhomʉ-o?» ");
INSERT INTO mdm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu agie pɨ uo me: «Ebhe atima bha ma ngʉ́ nagɨlɨ okpála na Ɨsalaele ɨnde maka okandɵlɵ ɨnde angɨta-o.» ");
INSERT INTO mdm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Engʉ́ bini, ɵlɵ ango-o ago atʉtʉ lɨpʉkʉ e kuto kala anɨ ne napa me: «Ngámá, go teteke nga bha mbo ma!» ");
INSERT INTO mdm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu agie pɨ anɨ bhʉ́ gbitaku me: «A ndjɨndjɨ ade me u ha ezʉ gba ongɨsɨ-e, u bhike pɨ obʉ́lʉ-o de.» ");
INSERT INTO mdm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɵlɵ ango-o agie me: «A ko paká Ngámá, la-a, obʉlʉ ngazʉ okʉlʉ ’zʉ ɨnde ngabala sa misa gba omakʉlasɨ o-o.» ");
INSERT INTO mdm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Abhomʉ-o, Yesu agie pɨ anɨ me: «’Hi ma-a, nabhuka gba mʉ-o ngbéngbé! A ayo me Ebhe ha ehe ɨnde mo okʉnda e pɨ mʉ.» Abhomʉ-o, ndɨlɨ gba anɨ-e atsia akobho bha lɨ nedhɨnga bhomʉ. ");
INSERT INTO mdm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Abhomʉ-o, Yesu ayie oo, anɨ atapa lɨngo ekpɵ na Galilaya. Anɨ aꞌʉ apɨ́ ’ta, anɨ atsia adʉ kuto. ");
INSERT INTO mdm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Okpála bhelé ago abhaka anɨ. U ago ne okpála adʉ ne eze lɨ ’dhʉ o, ne okpála lɨ djila o adʉdʉ, ne okpála lɨ yá o apʉ, ne obhe ɨ bhʉ ’ngʉ́ de, la di ne okpála koko bhelé ɨnde adʉ lɨ o ne kuo. U abu uo bhʉ́ li ’dhʉ Yesu, anɨ atsia akobho uo. ");
INSERT INTO mdm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Okpála atsia adʉ angamba naali nedhɨnga u adʉ au okpála ɨ bhʉ ’ngʉ́ de-e lɨe ngagama ’ngʉ́-o, obhe lɨ yá o apʉ adʉ lɨe akólo ne angu-o, nedhɨnga di lɨ obhe adʉ ne eze lɨ ’dhʉ o adʉ adholo lɨe ndjɨndjɨ-o, ne nedhɨnga lɨ obhe ɨ u ’kpɨ́ de-e adʉ lɨe au ’kpɨ́-o. U atsia aholo nadhɵgɵ Ebhe gba omaƗsalaele-o. ");
INSERT INTO mdm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Abhomʉ-o, Yesu aꞌɨ omʉkpata gba e-o. Anɨ atsia apa pɨ uo me: «Ma ngadje ndjinga bhiti okpála ɨnde, anga akolo mbɨa ɨnde-e ’kpɨ́ bata u bha ngadʉ de ma sɨ, ehe nazʉ mazʉ la matá di ka uo ade. Ma kʉnda nagie uo gʉmʉ de, anga angu uo tɨ da nandjia lɨ kpadjɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Omʉkpata atsia ayi anɨ me: «Nɨ́ tɨ da nasia mapa na tetele bhʉ́ mili bɨlɨ ɨnde-e su, ɨnde ɨ tɨ da nale ne bhiti okpála ɨnde-e?» ");
INSERT INTO mdm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu atsia ayi uo me: «A ka yi ne mapa madho?» U agie pɨ anɨ me: «A ka ya ne mapa mananɨka ne mbo odjedje sungu.» ");
INSERT INTO mdm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Abhomʉ-o, Yesu apa pɨ bhiti okpála me, u dʉlʉ kuto. ");
INSERT INTO mdm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Anɨ atsia aha mapa mananɨka ne osungu-o. Pɨta nagie heni pɨ Ebhe-e, anɨ agʉgʉmʉ, anɨ aha pɨ omʉkpata-o, u atsia agapa lɨ bhiti okpála me u zʉzʉ. ");
INSERT INTO mdm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","U azʉ ndʉ o hana, u atsia aꞌuꞌu. Omʉkpata apo bhʉ́la dudu-o, atsia abebedhe okíli mananɨka. ");
INSERT INTO mdm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Okpála hana ɨnde azʉ-o, adʉ obhosɨ kutu badha mandɨ nako olɨsɨ ne ongɨsɨ. ");
INSERT INTO mdm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pɨta lɨ Yesu aha kpadjɨ pɨ bhiti okpála lɨe, anɨ aꞌʉ bhʉ́ zabʉ, anɨ atsia atapa bhʉ́ ndu doto lɨ gʉdhʉ na Magadana adʉ bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Abhomʉ-o, omʉFalisai ne oSadukai ago abhaka Yesu. U adʉ akʉnda nale anɨ. Kaka-a, u atsia ayo ka anɨ me anɨ mene nga bha ngamba ’ngʉ́ bini pɨ o ɨnde asúno me Ebhe atima anɨ ngae. ");
INSERT INTO mdm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Anɨ agie pɨ uo me: «Ɨ kolo tagolo-o, yi pá me: ‹Ekpɨ́-e adʉ́ babadha, anga bhʉ́la ’kpɨ́-e akodho má ngbɨ́, oɨkʉpala aze la di bhelé.› ");
INSERT INTO mdm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɨ dʉ di-e kɵkpɨ-e, yi pá me: ‹Nakɨ-e, ekpɨ́-e adʉ́ sisiti, anga bhʉ́la ’kpɨ́-e mbembe, a la di ne biti.› Yi mbɨla hana me bhʉ́la ’kpɨ́-e dʉ me-e, a akʉnda napa pɨ-ie. La-a, ongʉ́ ɨnde ngakodho ’kpɨ́ bhʉ́ onedhɨnga ɨnde-e, yi mbɨla de me akʉnda napa pɨ-ie de! ");
INSERT INTO mdm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Okpála na nakɨ ɨnde-e sisiti, u bhuka la di Ebhe ne bua o bini de! U ngayo ngamba ’ngʉ́. Engʉ́ bini, Ebhe méne ngamba ’ngʉ́ bini pɨ uo de, bha bini bhende anɨ amene nanɨ e lɨ polofeta Djonasɨ ko.» Pɨpɨta-a, Yesu aꞌo ka uo oo, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lɨ Yesu ne omʉkpata gba e agulu ekpɵ na Galilaya lɨe, omʉkpata-a aꞌɨlɨ ’to o lɨ naha mapa. ");
INSERT INTO mdm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu atsia apa pɨ uo me: «ꞌE-e! Yi lila lɨyi ka levile gba omʉFalisai ne oSadukai-e malila!» ");
INSERT INTO mdm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abhomʉ-o, omʉkpata aholo napa sʉnda o me: «Anɨ ngapa mo-o, anga nɨ́ go ne mapa de.» ");
INSERT INTO mdm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Engʉ́ bini, Yesu ambɨla engʉ́ ango-o, anɨ atsia apa pɨ uo me: «Nabhuka gba yi-e yeye. Ka nɨ yi ngapa lɨe sʉnda yi me, yi go ne mapa dɨ-e? ");
INSERT INTO mdm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yi kɵ nga mboli engʉ́ bini dɨ? Yi aꞌɨlɨ ’to yi lɨ mapa bhuluvue ɨnde ma agapa nako e lɨ okpála kutu bhuluvue aꞌɨlɨ? Yi atsia aꞌɨlɨ la di ’to yi me o obebedhe nako okíli madho-ie ne dudu-o? ");
INSERT INTO mdm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","La di-e, yi aꞌɨlɨ ’to yi lɨ mapa mananɨka ɨnde ma agapa nako e lɨ okpála kutu badha aꞌɨlɨ? Yi atsia aꞌɨlɨ la di ’to yi me o obebedhe nako okíli madho-ie ne dudu-o? ");
INSERT INTO mdm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ma apa ɨgɨnɨ lɨe pɨ yi me yi lila lɨyi ka levile gba omʉFalisai ne oSadukai malila-a, ma pa ɨgɨnɨ bhomʉ-o engʉ́ na mapa de. Yi kɵ mbolimboli de ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Abhomʉ-o, omʉkpata-a atsia akɵ la mboli ’ngʉ́ ango-o me anɨ pa engʉ́ nalila lɨe ka levile na mapa de, engʉ́ bini, a ko nalila lɨe ka nasuno gba omʉFalisai di ne oSadukai ko. ");
INSERT INTO mdm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lɨ Yesu ne omʉkpata gba e akolo lɨe bhʉ́ ndu doto lɨ gʉdhʉ na Sedjale gba Filipo adʉ bhʉ́ e-e, anɨ ayi uo me: «Okpála ngapa me ngama Ndɨlɨ gba kpála-a, ma ne da?» ");
INSERT INTO mdm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","U agie pɨ anɨ me: «Pɨ okpála koko-o, mʉ ne Djaa bhʉlʉ nabatisa okpála. Pɨ okoko-o, mʉ ne Elɨya. Pɨ okoko matá-a, mʉ ne Djelemi, ɨ dʉ di-e sʉka opolofeta koko.» ");
INSERT INTO mdm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Anɨ apa pɨ uo me: «A la yi-e, yi ngapa naayi me ma ne da?» ");
INSERT INTO mdm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Piele atsia agie pɨ anɨ me: «Mʉ ne Masɨya , Ndɨlɨ gba Ebhe ɨnde ʉʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «A ko djalɨ pɨ mʉ, Simo, ndɨlɨ gba Djaa , anga ambamba ta engʉ́ na kʉkʉlʉ ɨnde-e pɨ mʉ ne kpála de, engʉ́ bini, ambamba tata pɨ mʉ ne ’Dyɨ ma ɨnde abhʉ́lá ko. ");
INSERT INTO mdm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kaka-a, ma apa pɨ mʉ me a ’lɨ mʉ me Piele, mʉ maka teme. Piga gba ma-a alʉ́ pɨ́ teme ango-o. Angu kuo kólo tété de. ");
INSERT INTO mdm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma ahá olɨfʉngʉla na Naʉ na abhʉ́lá-a pɨ mʉ. Ne angu ɨnde ma aha e pɨ mʉ bhomʉ-o, ndʉ ’he hana ɨnde mo ogbíte e pɨ́la doto-o, agbíte bhadi lɨe abhʉ́lá moko. Ndʉ ’he hana ɨnde mo obhúlu e pɨ́la doto-o, abhúlu bhadi lɨe abhʉ́lá moko.» ");
INSERT INTO mdm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Abhomʉ-o, Yesu atsia aha lɨ́lɨ pɨ omʉkpata-a me u apá belegʉ pɨ kpála bini de me nɨ ne Masɨya-a de. ");
INSERT INTO mdm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nayie bhʉ́ nedhɨnga bhomʉ-o, Yesu aholo nasuno pɨ omʉkpata gba e mbámbá me: «A ayo me ma nʉ bhʉ́ Yelusalema. Oo, ma djé lɨkabhu naali sakpa obhelesɨ okpála, sakpa ongbengbe odimandɵ gba Ebhe , di ne sakpa omʉsuno na lɨ́lɨ gba Moidje-o . U abhɵ́lɵ ma. La-a, bhʉ́ ’kpɨ́ na bata-a, ma tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Abhomʉ-o, Piele agbele anɨ ne lɨ ngongo, anɨ aholo naboyo anɨ ne napa pɨ anɨ me: «Ngámá, a ayo me Ebhe lila mʉ! A mo-o ade, engʉ́ bhomʉ-o kólo lɨ mʉ de!» ");
INSERT INTO mdm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Engʉ́ bini, Yesu adji lɨe, anɨ atsia apa pɨ Piele me: «Yie oo ko, Satana ! Mʉ ne ndjukudu lɨ kpadjɨ gba ma-o. Padhá de, anga omabhundja gba mʉ-o, a ko bhende gba Ebhe-e de, engʉ́ bini, a ko bhende gba okpála.» ");
INSERT INTO mdm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Abhomʉ-o, Yesu atsia apa pɨ omʉkpata gba e me: «Ɨ dʉ me kpála bini nde akʉnda bha nakpata ma na paká-a, a ayo me anɨ ꞌo nabhundja ’ngʉ́ gba e makpe. A ayo me anɨ bɨ kulusi gba e-o, amba anɨ kpata ma. ");
INSERT INTO mdm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Padhá de, anga ɨ dʉ me kpála nde akʉnda nalila mʉkobho gba e, anɨ kpí. Ɨ dʉ la me kpála nde atse ’kpa lɨ mʉkobho gba e ngʉbula ma-a, anɨ sía mʉkobho na kʉkʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","La di-e, ɨ dʉ me kpála nde asia ndʉ ’he hana na doto, engʉ́ la bini, ngaanɨ makpe anɨ kpi-e, anɨ asía bhʉ́bhʉ́ mangua ’he dho? Kpála tɨ da nakala mʉkobho gba e ka Ebhe ne mangua ’he dho? ");
INSERT INTO mdm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Padhá de, anga Ndɨlɨ gba kpála agó ne oandjelu gba e bhʉ́ sangu gba ’Dyɨ e-o. Abhomʉ-o, kpála ne kpála tsia sía mbini kulu gba e sakpa anɨ nakpata lele kulu ɨnde anɨ amene e-o. ");
INSERT INTO mdm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma apa pɨ yi na paká me, okpála koko bhʉ́ ká obhende ɨnde sɨ-e, mú padhá de, u aú ngaɨza nago gba Ndɨlɨ gba kpála maka ’ngbé ngámá kalanʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pɨta ekpɨ́ madhɨa, Yesu aha Piele, ne Djakɨ ne ndai e Djaa . Anɨ anʉ ne uo tɨtɨ o apɨ́ ’ndjá ’ta. ");
INSERT INTO mdm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bha sɨ me-e, anɨ adji lɨe kala uo kpi. Bhʉ́la anɨ aholo nasʉ má ngbɨ ngbɨ ngbɨ maka zɨ ’ndjɨ ’la! Obongo lɨ kʉte anɨ-e, akolo bububu maka zɨ ’kpɨ́. ");
INSERT INTO mdm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kolo me-e, Moidje ne Elɨya aze lɨ uo, u atsia aholo agama ’ngʉ́ ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Abhomʉ-o, Piele atsia apa pɨ Yesu me: «Ngámá, a ndjɨndjɨ me nɨ́ dʉlʉ sɨ. Ɨ dʉ me mʉ nde akʉnda-a, ma yíki ’tɨ ngbangbalɨ bata: bini pɨ mʉ, bini pɨ Moidje, bini pɨ Elɨya.» ");
INSERT INTO mdm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nedhɨnga anɨ adʉ nga bha lɨe nagama ’ngʉ́-o, ndindi ɨnde adʉ lɨ e ne zɨzɨ-e ago abuku uo hana. Me-e, eli akoto bhʉ́ ndindi ango-o atsia apa pɨ uo me: «Kpála ɨnde-e ne Ndɨlɨ gba ma na mʉkʉnda. Engʉ́ gba anɨ-e nga lɨ ma naali. Yi dje anɨ!» ");
INSERT INTO mdm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lɨ omʉkpata adje lɨe mo-o, u adje tsʉlʉ naali. Kaka-a, u atuko kuto, u atsia atʉtʉ bhʉ́la o bhʉ́ doto. ");
INSERT INTO mdm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Abhomʉ-o Yesu adyudyo lɨe de uo, anɨ aꞌo ’kpa e lɨ kʉte uo, anɨ atsia apa me: «Yi yie bhʉ́lá! Yi adjé tsʉlʉ de!» ");
INSERT INTO mdm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naꞌe djila o ka uo me-e, u u kpála bini de, u au bha Yesu kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nedhɨnga u adʉ nakɵ eta-a lɨe, Yesu atsia aha lɨ́lɨ ɨnde-e pɨ uo me: «Yi apá engʉ́ ɨnde yi au e pɨ kpála bini de, nakolo bha lɨ nedhɨnga lɨ ngama Ndɨlɨ gba kpála ma azúku lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abhomʉ-o, omʉkpata ayi anɨ me: «Ka nɨ lɨ omʉsuno na lɨ́lɨ gba Moidje ngapa lɨe me, a ayo me Elɨya go ngaɨza kala me Masɨya go-o?» ");
INSERT INTO mdm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Anɨ agie me: «A moko, Elɨya agó mago, anɨ tsia léke ndʉ ’ngʉ́ hana ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Engʉ́ la bini, ma apa pɨ yi me Elɨya ago nanɨ ago. Okpála mbɨla anɨ de, engʉ́ bini, u amene ndʉ ’ngʉ́ hana lɨ kʉte anɨ maka u akʉnda lɨe. A ayo me ngama Ndɨlɨ gba kpála ma dje bhadi lɨkabhu ka uo moko.» ");
INSERT INTO mdm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A la bhomʉ-o, nambɨla ka omʉkpata-a me anɨ adʉ akpo ’ngʉ́ pɨ o pɨndjɨ Djaa bhʉlʉ nabatisa okpála. ");
INSERT INTO mdm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu ne omʉkpata gba e bata akɵ eta-o. U akolo lɨe de kambɨ okpála-a, kpála bini adyudyo lɨe de Yesu. Anɨ atʉtʉ lɨpʉkʉ e kuto kala anɨ, ");
INSERT INTO mdm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","anɨ atsia apa pɨ anɨ me: «Ngámá, dje nga mbo ndjinga ndɨlɨ gba ma na bhobhoko-o. A lɨ anɨ ne kuo na gbʉlʉ magbʉlʉ. A ngagbo ꞌi anɨ bhʉ́ djua, ɨ dʉ di-e bhʉ́ ’ngu pɨko. Anɨ ngadje lɨkabhu naali. ");
INSERT INTO mdm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma anʉ ne anɨ pɨ omʉkpata gba mʉ-o, la-a, u tɨ da nakobho anɨ de.» ");
INSERT INTO mdm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Do Yesu de-e: «Ngayi-e, nabhuka gba yi-e su? Yi ne okpála na sisiti. Ma adʉ́ bhʉ́ dabɨlɨ bini ne yi akólo bhʉ́ mangua nedhɨnga dho? Ma akíbila yi akólo bhʉ́ mangua nedhɨnga dho? Yi go ne anɨ mʉma ei.» ");
INSERT INTO mdm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","U ago pɨ anɨ ne ndɨlɨ-o. Yesu ambe bhʉ́ ’ndjɨ siti bua-o , siti bua ango-o atsia akoto bhʉ́ ndɨlɨ-o. Nayie bha lɨ nedhɨnga bhomʉ-o, ndɨlɨ ango-o atsia akobho. ");
INSERT INTO mdm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abhomʉ-o, omʉkpata-a adyudyo lɨo de Yesu, u atsia ayi anɨ me u nde ne uo kpi o kpi me: «Mʉsuno, ka nɨ ngaya makpe ya tɨ ɨgɨnɨ da nagbe siti bua bhomʉ-o lɨe dɨ-e?» ");
INSERT INTO mdm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu agie pɨ uo me: «A ko anga nabhuka gba yi-e mbomboye. Padhá de, anga ma apa pɨ yi na paká me, ɨ dʉ́ me lɨ nabhuka gba yi-e dʉ́ nga bha bhʉ́ ’ngbé lɨe maka lɨ́ kʉndjʉ-o, yi de pá pɨ eta ɨnde-e me: ‹Yie sɨ, nʉ aoo›, ɨ tsia nʉ́ oo. Kpéke da ’ngʉ́ de dʉ́ pɨ yi de.  ");
INSERT INTO mdm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","La di-e, ngua siti bua bhomʉ-o tɨ́ da nakoto bha ka mayo bhʉ́ dabɨlɨ bini ne natse ’zʉ ngʉ́ nayo Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ekpɨ́ bini, Yesu ne omʉkpata gba e anʉ apo bhʉ́la o ndʉ o hana abhʉ́ ndu doto na Galilaya. Anɨ atsia apa pɨ uo me: «A ayo me u pʉ ma Ndɨlɨ gba kpála pɨ okpála na doto, ");
INSERT INTO mdm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","amba u bhɵlɵ ma, engʉ́ bini, bhʉ́ ekpɨ́ na bata-a, ma tsia zúku.» Abhomʉ-o, bua omʉkpata atsia asia lɨkabhu naali. ");
INSERT INTO mdm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ne omʉkpata gba e akolo bhʉ́ Kapalanauma. Lɨ u akolo lɨe oo-o, okpála atsɨtsɨndjɨ mandjandja na ’ngbé ’tɨ Ebhe gba omaYuda-a adyudyo lɨo de Piele, u atsia ayi anɨ me: «Mʉsuno gba yi-e kakala naae mandjandja na ’ngbé ’tɨ Ebhe-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piele agie me: «A mo ade, anɨ kala makala.» Lɨ Piele alɨ la lɨe abhʉ́ ’tɨ-e, Yesu akpo nagama ’ngʉ́ ngae. Anɨ ayi Piele me: «Simo, mo obhundja pɨ? A kakala mandjandja, ɨ dʉ di-e otakisi gba ongbengbe ongámásɨ na doto da, ne me a ko ongɨsɨ gba uo, ne me a ko okpála koko?» ");
INSERT INTO mdm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piele agie me: «A kakala ne okpála koko.» Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Ɨ dʉ mo-o, ongɨsɨ gba ongámásɨ kála naao de, anga uo bhʉ́ ngʉ o. ");
INSERT INTO mdm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","La-a, ngʉ́ napa me bua okpála ɨnde-e asíti de-e, nʉ abhʉ́ ekpɵ. Bhike engbe bhʉ́ ’ngu. Sungu na kalanʉ ɨnde mo ogbé e, bhulu ’bhɵ anɨ. Mo obháka oo lɨ́ falanga bini. Haha, amba mʉ ha pɨ uo, ngʉbula nɨ́ ne mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bhʉ́ nedhɨnga bhomʉ-o, omʉkpata adyudyo lɨo de Yesu, u atsia ayi anɨ me: «A nga ngbéngbé bhʉ́ Naʉ na abhʉ́lá-a da?» ");
INSERT INTO mdm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu aꞌɨ mboye ndɨlɨ bini, anɨ aꞌo anɨ tʉ uo, ");
INSERT INTO mdm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","anɨ atsia apa me: «Ma apa pɨ yi na paká me, ɨ dʉ me yi nde lɨ bua yi de, yi kɵ́ lɨyi ne kuto ngʉ́ nakolo maka ongɨsɨ na djedjedje de-e, yi lɨ́ belegʉ bhʉ́ Naʉ na abhʉ́lá-a de. ");
INSERT INTO mdm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Padhá de, anga gagala ’ngʉ́ bhʉ́ ndɨlɨ ade. Kaka-a, kpála bhende ɨ ngakɵ lɨe ne kuto maka mboye ndɨlɨ ɨnde-e, kpála ango-o ngbéngbé bhʉ́ Naʉ na abhʉ́lá-a ngae.» ");
INSERT INTO mdm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yesu atsia apa matá pɨ omʉkpata gba e me: «Kpála bhende asía nga bha belegʉ kpála bhende ngakɵ lɨe ne kuto maka mboye ndɨlɨ ɨnde-e ka ’lɨ ma-a, kpála ango-o ngasia bhomʉ-o ma makpe. ");
INSERT INTO mdm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Engʉ́ bini, lɨ kpála bini to sʉka ongɨsɨ bini ɨnde abhuka ma-a bhʉ́ siti ’ngʉ́-o, a ndjɨndjɨ pɨ anɨ me u gbite ngɨngɨ tangʉlʉ anɨ, amba u bhike anɨ bhʉ́ ’ngbé ’ngu. ");
INSERT INTO mdm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","A ko lɨkabhu pɨ okpála na doto, anga a ne ongʉ́ bhelé ɨnde ngato uo bhʉ́ siti ’ngʉ́! A moko, engʉ́ na sisiti néke galikpe ’kpɨ́ bini de, engʉ́ la bini, a ko lɨkabhu pɨ kpála ɨnde ɨ ngayie ka e ko! ");
INSERT INTO mdm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɨ dʉ me ’kpa mʉ, ɨ dʉ di-e ’dhʉ mʉ nde ngato mʉ bhʉ́ siti ’ngʉ́-o, mʉ de kodho, amba mʉ bhike de mʉ tsutsu. Padhá de, anga a ndjɨndjɨ pɨ mʉ nalɨ bhʉ́ mʉkobho na kʉkʉlʉ ne ekpa bini, ɨ dʉ di-e edhʉ bini. Bhobhomʉ-o ane ne bádha me u bhike mʉ ne ’kpa mʉ bhisi, ɨ dʉ di-e ne ’dhʉ mʉ bhisi hana bhʉ́ djua na dʉdʉma! ");
INSERT INTO mdm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ɨ dʉ di me lɨ́ djila mʉ bini nde ngato mʉ bhʉ́ siti ’ngʉ́-o, mʉ de gbe, amba mʉ bhike de mʉ tsutsu. Padhá de, anga a ndjɨndjɨ pɨ mʉ nalɨ ne djila mʉ bini bhʉ́ mʉkobho na kʉkʉlʉ. Bhobhomʉ-o ane ne bádha me u bhike mʉ ne djila mʉ bhisi hana bhʉ́ djua na dʉdʉma!» ");
INSERT INTO mdm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu atsia apa matá pɨ omʉkpata gba e me: «ꞌE-e! Yi aú sʉka okpála ɨnde ngakɵ lɨo ne kuto maka ongɨsɨ ɨnde-e padhá de, anga ma apa pɨ yi me abhʉ́lá-a, oandjelu gba uo ngalʉ ndʉ nedhɨnga hana kala ’Dyɨ ma.  ");
INSERT INTO mdm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Padhá de, anga ngama Ndɨlɨ gba kpála ma ago nanɨ ngʉ́ nakobho kpála bhende angɨta ko. ");
INSERT INTO mdm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yi ngabhundja pɨ? Lɨ kpála bini dʉ ne okandɵlɵ kámá bini-e, lɨ sʉka uo bini ngɨta-a, anɨ ꞌó ká obhende ndjɨkpa odukpabini ne ká odukpabini-e apɨ́ ’ta dɨ, anɨ tsia nʉ́ nagɨlɨ bhende angɨta-a dɨ? ");
INSERT INTO mdm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ɨ dʉ la me anɨ nde au anɨ au-o, ma apa pɨ yi na paká me, anɨ bédhe ne djalɨ bedhe ane djalɨ ɨnde anɨ nde ne e ngʉ́ obhende ndjɨkpa odukpabini ne ká odukpabini ɨnde ɨ ngɨta naao de ko. ");
INSERT INTO mdm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","A moko, ’Dyɨ yi ɨnde abhʉ́lá-a kʉnda de me sʉka okpála ɨnde ngakɵ lɨo ne kuto maka ongɨsɨ ɨnde-e ngɨta belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu apa matá pɨ omʉkpata gba e me: «Lɨ ndai mʉ mene mʉ sisiti-e, mʉ de nʉ bhaka anɨ, amba mʉ suno siti ’ngʉ́ gba anɨ-e pɨ anɨ me yi nde bhisi ka yi ne anɨ. Anɨ dje mʉ-o, amba mo osia ndai mʉ asia. ");
INSERT INTO mdm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Anɨ dje mʉ de-e, mʉ de nʉ, mʉ ha kpála bini, ɨ dʉ di-e okpála bhisi, amba ‹engʉ́ ango-o lʉ lɨ ’li okpála bhisi, ɨ dʉ di-e okpála bata› maka lɨ Bhuku gba Ebhe apa lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Anɨ dje uo de-e, mʉ de pa engʉ́ ango-o bhʉ́ Piga gba Ebhe. Ɨ dʉ la me anɨ nde ayala nadje belegʉ okpála na Piga gba Ebhe-e, a ayo me anɨ kolo pɨ mʉ maka mʉpagano, la di maka ndɵmbɨ na mandjandja. ");
INSERT INTO mdm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ma apa pɨ yi na paká me, ndʉ ’he hana ɨnde yi agbíte e pɨ́la doto-o, a agbíte bhadi lɨe abhʉ́lá moko. Ndʉ ’he hana la di yi abhúlu e pɨ́la doto-o, a abhúlu bhadi lɨe abhʉ́lá moko.» ");
INSERT INTO mdm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Do Yesu pɨ omʉkpata gba e de-e: «Ma apa matá pɨ yi me, ɨ dʉ me pɨ́la doto, okpála bhisi bhʉ́ ká yi nde adje lɨo ngʉ́ nayo ’he, abana ɨ dʉ bha mangua ’he dho-ie, ’Dyɨ ma ɨnde abhʉ́lá-a há ehe ango-o pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Padhá de, anga bɨlɨ ɨnde lɨ okpála bhisi, ɨ dʉ di-e okpála bata apo bhʉ́la o lɨe ne ’lɨ ma-a, ma bhʉ́ ká uo oo.» ");
INSERT INTO mdm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Abhomʉ-o, Piele adyudyo lɨe de Yesu, do anɨ pɨ anɨ me: «Ngámá, lɨ ndai ma mene siti ’ngʉ́ lɨ pabɨlɨ gba ma-a, ma de mbu lɨ anɨ bhʉtsibhʉtsi madho? A apise lɨ bhʉtsibhʉtsi mananɨka?» ");
INSERT INTO mdm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu agie pɨ anɨ me: «Ma pa pɨ mʉ de me a apise lɨ bhʉtsibhʉtsi mananɨka-a de, engʉ́ bini, a apise lɨ bhʉtsibhʉtsi ndjɨkpa mananɨka bhʉtsibhʉtsi mananɨka. ");
INSERT INTO mdm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","A bhadi moko, Naʉ na abhʉ́lá-a, a maka tsingʉ gba ’ngbé ngámá bini ɨnde akʉnda nanɨ naleke ’ngʉ́ na tɨa gba e ne okpála na kulu gba e-o. ");
INSERT INTO mdm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kalanʉ-o, u ago pɨ anɨ ne bhe bini ɨnde adʉ ne tɨa gba anɨ-e bhelé na kuo kuo. ");
INSERT INTO mdm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Lɨ tɨa dʉ la lɨe ka anɨ ngʉ́ nagigie de-e, ngámá-a atsia aha lɨ́lɨ me u tsɨndjɨ anɨ, ne wala anɨ, ne ongɨsɨ gba anɨ, la di ne ndʉ ’he gba anɨ-e hana, amba nɨ sia tɨa gba nɨ-e bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Abhomʉ-o, kpála na kulu-o atɨ bhʉ́ ’li ’dhʉ anɨ, anɨ atʉ ’ndjɨ e ne kuto, anɨ atsia akikiliki lɨe pɨ anɨ me: ‹Dʉ nga mbo ne ’ndjá bua lɨ pabɨlɨ gba ma, ma agíe ndʉ tɨa gba mʉ-o hana.› ");
INSERT INTO mdm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngámá adje ndjinga anɨ, anɨ ambu lɨ ndʉ bopulu gba anɨ-e hana. Anɨ atsia aꞌo anɨ me anɨ nʉnʉ. ");
INSERT INTO mdm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Lɨ kpála na kulu ango-o akoto lɨe, anɨ akɵ lɨe ne sʉka kilí e na kulu-o bini. Kpála ango-o adʉ ne bopulu gba anɨ na lɨ́ falanga kámá bini má kpɨkɨlɨ! Anɨ atɨ lɨ ngʉlʉ kpála na bopulu gba e bhomʉ-o má gbu! Anɨ aholo nafɵlɵ ngʉlʉ anɨ me nɨ ngabhɵlɵ anɨ ne napa pɨ anɨ me: ‹Gie falanga gba ma ɨnde ka mʉ ko.› ");
INSERT INTO mdm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kilí anɨ ango-o atɨ bhʉ́ li ’dhʉ anɨ, anɨ aholo nakikiliki lɨe pɨ anɨ me: ‹Dʉ nga mbo ne ’ndjá bua lɨ pabɨlɨ gba ma, ma agíe pɨ mʉ magie.› ");
INSERT INTO mdm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Engʉ́ bini, bhe koko ayala. La matá pépé-e, anɨ aha anɨ, anɨ anʉ ne anɨ me u to anɨ bhʉ́ tɨkpʉ akólo bha bini lɨ anɨ agíe bopulu gba e lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lɨ obɨ anɨ koko au lɨe mo-o, u adje lɨkabhu lɨ bua o naali. Kaka-a, u anʉ akpokpo ndʉ ’ngʉ́ bhomʉ-o hana maka a akodho ’kpɨ́ lɨe pɨ ngámá gba o-o. ");
INSERT INTO mdm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Abhomʉ-o, ngámá gba anɨ-e atsia apa me u ꞌɨ anɨ. Do ngámá-a pɨ anɨ de-e: ‹Mʉ ne siti kpála na kulu! Ma ambu lɨ ndʉ bopulu gba mʉ ɨnde-e hana, anga mo okikiliki lɨmʉ mʉma. ");
INSERT INTO mdm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngamʉ di-e, a ayo ɨginɨ de me mʉ dje di ndjinga kilí mʉ maka ngama makpe ma adje ndjinga mʉ lɨe dɨ?› ");
INSERT INTO mdm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bua ngámá-a ake naali. Anɨ aha anɨ, anɨ anʉ ne anɨ pɨ okpekpeke obhosɨ me u mene anɨ kpekpeke, ngʉ́ nakolo bha bini lɨ ’kpɨ́ ɨnde anɨ agíe ndʉ bopulu gba e lɨe hana ko. ");
INSERT INTO mdm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Dyɨ ma ɨnde abhʉ́lá améne bhadi pɨ yi moko, ɨ dʉ me kpála ne kpála nde mbu lɨ ndai e ne bua e hana de ko.» ");
INSERT INTO mdm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nedhɨnga lɨ Yesu andjia nagama ongʉ́ bhomʉ-o lɨe, u ayie ne omʉkpata gba e bhʉ́ ndu doto na Galilaya. U atsia anʉ bhʉ́ ndu doto na Yudaya ɨnde lɨngo ngade ’ngu na Djʉlʉdanɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bhiti okpála akpata anɨ oo. Abhomʉ-o, anɨ atsia akobho okpála na kuo ɨnde adʉ bhʉ́ ká uo-o. ");
INSERT INTO mdm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","OmʉFalisai koko adyudyo lɨo de anɨ. U atsia ayi anɨ ngʉ́ nale anɨ me: «Lɨ́lɨ gba nɨ́-e azɨba pɨ bhoko uu me anɨ gie wala e abana ɨ dʉ bha mangua ’ngʉ́ dho-ie?» ");
INSERT INTO mdm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Anɨ agie me: «Yi tanga nga engʉ́ lɨ Bhuku gba Ebhe-e apa e de me nanɨ lɨ lilita-a, Ebhe abho uo ɵlɵ ne bhoko-o dɨ? ");
INSERT INTO mdm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bhuku ango-o atsia apa matá me: ka ’ngʉ́ ango-o, bhoko aꞌó ká ’dyɨ e ne ’hi e, anɨ tsia dhédhe lɨ wala e. Ndʉ uo bhisi hana tsia kólo koli kpála bini. ");
INSERT INTO mdm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kaka-a, ma apa pɨ yi me, uo matá bhisi ade. Engʉ́ bini, u akolo koli kpála bini. A ayo de me kpála gbo bhʉsʉ ’he ɨnde lɨ Ebhe agbite e de!» ");
INSERT INTO mdm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Abhomʉ-o, omʉFalisai ayi anɨ me: «Ka nɨ la lɨ Moidje aha nanɨ lɨ́lɨ lɨe me bhoko ha balʉa nagbo bhʉsʉ e pɨ wala e nedhɨnga anɨ agie anɨ lɨe?» ");
INSERT INTO mdm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu agie me: «Moidje aha nanɨ kpadjɨ pɨ yi ngʉ́ nagie olɨsɨ gba yi-e ka kpéke ’ndjɨ gba yi-o. Engʉ́ la bini, a lɨ lilita-a, adʉ nanɨ mo-o de. ");
INSERT INTO mdm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma apa pɨ yi me: ɨ dʉ me kpála nde agie wala e, a nde de me ɵlɵ ango-o akʉnda gala bhoko de-e, ɨ dʉ me kpála ango-o nʉ ha ɵlɵ koko-o, kpála ango-o akʉnda bhomʉ-o ɵlɵ koko.» ");
INSERT INTO mdm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Omʉkpata-a apa pɨ anɨ me: «Ɨ dʉ me lɨ́lɨ gba bhoko lɨ pabɨlɨ gba wala e nde mo-o, tata lɨ naha lɨo ade.» ");
INSERT INTO mdm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Anɨ agie pɨ uo me: «Ndʉ okpála hana kɵ mboli engʉ́ bhomʉ-o de, bha bini obhende lɨ Ebhe aka kpadjɨ pɨ o tété-o. ");
INSERT INTO mdm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","A ne engʉ́ bhelé bhelé ɨnde ngaꞌo me kpála dʉdʉ bhʉ́ lɨngbangɨ. Pɨ okpála koko-o, u azu uo me angu na ɵlɵ nde bhʉ́ uo ade. Pɨ okoko, okpála asiti uo ngao. A la di ne okoko ɨ ha olɨsɨ de, ngʉbula naꞌo lɨo kpi ngʉbula Naʉ na abhʉ́lá . A ayo me kpála ɨnde atɨ da nakɵ mboli nasuno ɨnde-e, anɨ kɵ mbolimboli kɵkɵ.» ");
INSERT INTO mdm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abhomʉ-o, okpála ago pɨ Yesu ne ongɨsɨ ngʉbula me anɨ ꞌo ’kpa e pɨ́ ’ndjɨ uo, amba anɨ yo Ebhe pɨ uo. Engʉ́ bini, omʉkpata aholo nayoko okpála ango-o. ");
INSERT INTO mdm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu atsia apa pɨ omʉkpata-a me: «Yi ꞌo ongɨsɨ bhomʉ, u go bhaka ma, yi ayóko uo de, anga Naʉ na abhʉ́lá pɨ okpála bhende lɨ bua o nde maka ongɨsɨ ko.» ");
INSERT INTO mdm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anɨ aꞌo ’kpa e pɨ́ ’ndjɨ uo, pɨpɨta-a, anɨ atsia ayie lɨ bɨlɨ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Abhomʉ-o, makombi bini adyudyo lɨe de Yesu. Anɨ atsia ayi anɨ me: «Mʉsuno, a ayo me ma mene mangua bádha ’ngʉ́ dho ngʉ́ nasia mʉkobho na dʉdʉma-a?» ");
INSERT INTO mdm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu agie pɨ anɨ me: «Mʉ ngayi ma pɨndjɨ bádha ’ngʉ́ ka nɨ? Koli bádha kpála bha bini. Ɨ dʉ me mʉ nde akʉnda nalɨ bhʉ́ mʉkobho na dʉdʉma-a, lila olɨ́lɨ-e malila.» ");
INSERT INTO mdm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Makombi ango-o ayi Yesu me: «Olɨ́lɨ bhedho?» Yesu agie pɨ anɨ me: «Mo obhɵ́lɵ kpála de, mo okʉ́nda ɵlɵ, ɨ dʉ di-e bhoko koko de, mo ozí ’he de, mo opá ’ngʉ́ lɨ kilí mʉ bhʉ́ djila okpála ne eu de. ");
INSERT INTO mdm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Manga ’dyɨ mʉ ne ’hi mʉ mamanga. Kʉnda kilí mʉ maka mo okʉnda lɨmʉ lɨe ngamʉ makpe-o.» ");
INSERT INTO mdm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Makombi-e apa pɨ anɨ me: «Ndʉ ’he bhomʉ-o hana, ma amene. A aneke matá ma ne bhedho?» ");
INSERT INTO mdm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu apa pɨ anɨ me: «Ɨ dʉ me mʉ nde akʉnda nadʉ ngbingbili-e , nʉ tsɨndjɨ ndʉ ’he ɨnde ka mʉ-o hana, amba mʉ ha tɨa ango-o pɨ obhʉlʉ ndɨbhɨlɨ. Abhomʉ-o, mʉ tsia sía tɨa abhʉ́lá. Pɨpɨta-a go kpata ma!» ");
INSERT INTO mdm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lɨ makombi bhomʉ-o adje ’ngʉ́ bhomʉ-o lɨe, anɨ agie lɨe ne lɨkabhu naali, anga tɨa adʉ nanɨ ka anɨ na mʉgwe mʉgwe. ");
INSERT INTO mdm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Abhomʉ-o, Yesu atsia apa pɨ omʉkpata gba e me: «Ma apa pɨ yi na paká me, da nalɨ ka bhʉlʉ tɨa bhʉ́ Naʉ na abhʉ́lá-a kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma amata apa pɨ yi ne toto me da nalɨ ka enʉ maka eya lɨ gudho mʉsana kpekpeke. La-a, da nalɨ ka bhʉlʉ tɨa bhʉ́ Naʉ gba Ebhe-e ane la matá ne kpéke.» ");
INSERT INTO mdm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lɨ omʉkpata adje eli bhomʉ-o lɨe, u angamba na kuo kuo. U adʉ apa me: «Ɨ dʉ mo-o, a atɨ la ɨbili da nakobho da?» ");
INSERT INTO mdm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu atsia uo, anɨ atsia apa pɨ uo me: «Pɨ okpála-a, a tɨ́ da namene lɨe de, engʉ́ bini, pɨ Ebhe-e, a tɨ́ da namene lɨe.» ");
INSERT INTO mdm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Abhomʉ-o, Piele atsia ayi anɨ me: «Mʉsuno, djedje nga. Ngaya-a, ya aꞌo ká ndʉ ’he hana ngʉ́ nakpata mʉ. Engʉ́ bhe gba ya-a adʉ́ lele e pɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu agie pɨ omʉkpata-a me: «Ma apa pɨ yi na paká me, nedhɨnga lɨ doto adjí lɨe lɨe na mbɨa-a, Ndɨlɨ gba kpála adʉ́ pɨ́ kiti na asasaua gba e-o. Ngayi obhe akpata ma-a, yi tsía dʉ́ di pɨ́ okiti na ngámá ndjɨkpa ne ká bhisi ngʉ́ nakodho ’ngʉ́ gba opiga ndjɨkpa ne ká bhisi gba omaƗsalaele ko. ");
INSERT INTO mdm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","La di-e, kpála ne kpála ɨnde aꞌo ká oetɨ gba e, ɨ dʉ di-e ondaise e na obhosɨbhosɨ ne obhe na olɨsɨlɨsɨ, ɨ dʉ di-e ’dyɨ e ne ’hi e, ɨ dʉ di-e ongɨsɨ gba e, ɨ dʉ di-e edyɨ gba e ngʉbula ’lɨ ma-a, anɨ asía matá koko bhelé. Anɨ tsia sía di mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yi mbɨla ndjɨndjɨ me, bhelé na obhende mbɨa ɨnde-e ne okpála na kalanʉ-o, akólo okpála na asidi, lɨ obhende mbɨa ɨnde asidi-e, tsia kólo okpála na kalanʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Abhomʉ-o, Yesu atsia apa matá me: «Yi gbo nga ’dje yi. Naʉ na abhʉ́lá mana lɨe ne tsingʉ gba bhʉlʉ ’dyɨ bini. Bhʉlʉ ’dyɨ ango-o akoto agba e kɵkpɨ́ má bhɵ́ ngʉbula naha okpála ngʉ́ kulu na edyɨ na vino gba e-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Anɨ au uo lɨe, u adje lɨo ne uo me nɨ ahá kuo ’kpa pɨ uo lɨ lele kulu na ekpɨ́ bini. Anɨ atsia atima uo ngʉ́ nanʉ amene kulu abhiye na vino gba e-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Anɨ akoto matá bhʉ́ saa na odukpabini na kɵkpɨ́. Anɨ au okpála ɨnde alʉlʉ lɨ bɨlɨ bini bhomʉ-o mandɨ kulu. ");
INSERT INTO mdm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Anɨ pɨ uo me: ‹Ngayi di-e, yi nʉ abhiye gba ma-o. Kuo ’kpa ma ahá e pɨ yi-e, adʉ́ lɨ lelele.› ");
INSERT INTO mdm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Abhomʉ-o, u atsia agbida oo. Bhʉlʉ ’dyɨ-e akoto matá tulukpe. Pɨpɨta-a, anɨ akoto matá bhʉ́ saa na bata pɨta tulukpe. Ndʉ nedhɨnga anɨ adʉ akoto lɨe hana, anɨ adʉ abhaka okpála koko alʉlʉ lɨ bɨlɨ bini bhomʉ. U adje lɨo ne uo, anɨ atsia apa pɨ uo me u nʉ abhiye gba nɨ ko. ");
INSERT INTO mdm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nakolo matá bhʉ́ saa na bhuluvue pɨta tulukpe-e, anɨ akoto. Anɨ abhaka okpála koko alʉlʉ oo. Anɨ atsia ayi uo me: ‹Yi alʉlʉ sɨ ngbolo ’kpɨ́ libhomu mandɨ kulu ka nɨ?› ");
INSERT INTO mdm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Do uo pɨ anɨ de-e: ‹A ko anga kpála bini ha ya bhʉ́ kulu de.› Anɨ pɨ uo me: ‹Ngayi di-e, yi nʉ mene kulu abhiye na vino gba ma-o.› ");
INSERT INTO mdm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lɨ ekpɨ́ akolo lɨe tagolo-o, bhʉlʉ ’dyɨ-e apa pɨ kapita gba e me: ‹ꞌƗ okpála na kulu-o, amba mʉ ha kuo ’kpa gba kpála ne kpála pɨ e, nayie lɨ obhe ago sidi ngʉ́ nabu soso lɨ obhe ago ɨgɨnɨ kalanʉ-o.› ");
INSERT INTO mdm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Obhe akpo ɨgɨnɨ lita kulu bhʉ́ saa na bhuluvue pɨta tulukpe-e ago. Kpála ne kpála atsia asia kuo ’kpa maka u adje ɨgɨnɨ lɨo ne uo lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lɨ obhe ago ɨgɨnɨ kalanʉ-o ago lɨe, u abhundja naao me o osía tɨa bhelé nane obhe ago ɨgɨnɨ sidi-o. Engʉ́ bini, ngauo di-e, kpála ne kpála asia kuo ’kpa aviti bini ne obhe ago ɨgɨnɨ sidi-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","U adʉ asisia lɨe, u aholo adi mʉtokono lɨ bhʉlʉ ’dyɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","U adʉ apa me: ‹Okpála ɨnde-e ago sidi. U amene kulu bha koli saa bini má kpɨkɨlɨ, la-a, mʉ ngaha uo aviti bini ne ya, ngaya okpála ɨnde andala ne kulu ngbolo ’kpɨ́ libhomu bhʉ́ ke ku ’la!› ");
INSERT INTO mdm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Engʉ́ bini, bhʉlʉ ’dyɨ-e agie pɨ sʉka uo me: ‹Olia ma, mʉ tɨ da nadi mʉtokono de. Ma aha tɨa gba mʉ-o pɨ mʉ maka nɨ́ adje ɨgɨnɨ lɨnɨ́ ne mʉ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ha tɨa gba mʉ-o, tatapa. Ma tɨ́ da naha pɨ obhende ago sidi-e bha maka ma aha pɨ mʉ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mʉ mbɨla de me ma tɨ da namene ne tɨa gba ma-a maka ma akʉnda lɨe dɨ? Ne me mʉ ngatsia ma ne ndje djila ka ma amene okpála bhe ago sidi-e lɨe ndjɨndjɨ-e!›» ");
INSERT INTO mdm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu atsia abu tata-a me: «Okpála ɨnde asidi-e akólo okpála na akalanʉ, lɨ okpála na kalanʉ-o tsia kólo okpála na asidi.» ");
INSERT INTO mdm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lɨ Yesu adʉ lɨe nanʉ bhʉ́ Yelusalema-a, anɨ aꞌɨ omʉkpata gba e de e tɨtɨ o. Anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Yi djedje nga! Nɨ́ adji bhʉ́ Yelusalema, bɨlɨ ɨnde u apʉ́ ma Ndɨlɨ gba kpála lɨe pɨ ongbengbe odimandɵ di ne omʉsuno na lɨ́lɨ gba Moidje-o . U akódho ’ngʉ́ gba ma-a me ma kpi bha makpi. ");
INSERT INTO mdm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","U apʉ́ ma pɨ okpála ɨnde ne omaYuda ade ngʉbula me u mʉ ma. U abhɨ́ ma ne fimbo, u tsia gɨ́ ma lɨ kulusi. La-a, ekpɨ́ na bata-a, ma tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Abhomʉ-o, wala Djebedayo adyudyo lɨe de Yesu bhʉ́ dabɨlɨ bini ne ongɨsɨ gba e bhisi na obhosɨbhosɨ, Djakɨ ne uo ne Djaa , ɨnde adʉ nanɨ omʉkpata gba Yesu-o. Anɨ atʉ ’ndjɨ e ne kuto kala Yesu ngʉ́ nayo ’he ka anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ayi anɨ me: «Mo okʉnda me ma mene pɨ mʉ nɨ?» Anɨ agie pɨ Yesu me: «Tsia nga ongɨsɨ gba ma bhisi ɨnde. Ha lɨ́lɨ me u dʉlʉ bhʉ́ Naʉ gba mʉ-o: bhe bini lɨ pá ’kpa mʉ na kokpa, bhe koko lɨ pá ’kpa mʉ na galɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Do Yesu de-e: «Yi mbɨla ehe ɨnde yi ngayo e de. Yi tɨ da nazʉ lɨkabhu ɨnde ma azʉ́ e uu?» U agie me: «Ya tɨ da nazʉzʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu atsia apa pɨ uo me: «A moko, lɨkabhu ma azʉ́ e, yi azʉ́ mazʉ. La-a, ngʉ́ nadʉ ka yi lɨ pá ’kpa ma na kokpa ne bhe na galɨ-e, a ko ’ngʉ́ ka ma nakodho ’ngʉ́ tété de. Obɨlɨ bhomʉ-o pɨ okpála ɨnde lɨ ’Dyɨ ma aleke pɨ o ko.» ");
INSERT INTO mdm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lɨ omʉkpata bhe ndjɨkpa adje ’ngʉ́ bhomʉ-o lɨe, u ake ’ngʉ́ lɨo pɨ omʉkpata bhe bhisi bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Abhomʉ-o, Yesu aꞌɨ ndʉ omʉkpata hana me u go de nɨ. Anɨ atsia apa pɨ uo me: «Yi mbɨla ndjɨndjɨ me ongámásɨ na doto aꞌo omaha o pɨ o maꞌo, ongbengbe okpála adele omaha o sa ’dhʉ o. ");
INSERT INTO mdm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A ayo de me a dʉ bhʉ́ ká yi mo-o de. A ayo mangbo me ɨ dʉ me kpála nde akʉnda nadʉ ’ngbé kpála bhʉ́ ká yi-e, anɨ de dʉ kpála na kulu gba yi. ");
INSERT INTO mdm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","La di-e, lɨ kpála bini kʉnda nadʉ kpála na bini bhʉ́ ká yi-e, anɨ de dʉ bali gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","A bhadi moko, ngama Ndɨlɨ gba kpála ma go ngʉ́ napa de me okpála mene kulu lɨo pɨ ma-a de. Engʉ́ bini, ma ago mangbo ngʉbula namene kulu lɨma pɨ okpála, amba ma ha di mʉkobho gba ma-a maka tɨa ngʉ́ nagbegbe okpála bhelé bhʉ́ siti ’ngʉ́ gba o-o.» ");
INSERT INTO mdm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nedhɨnga lɨ Yesu ne omʉkpata gba e adʉ akoto lɨe bhʉ́ gʉdhʉ na Djeliko-o, bhiti okpála atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Abhaka me okpála bhisi ɨnde ɨ u ’kpɨ́ de-e nde adʉlʉ lɨngo kpadjɨ oo. U adje me Yesu ngakodho ’kpɨ́ bhomʉ-o ngae. Abhomʉ-o, u aholo nasʉsʉla me: «Ngámá, ndɨlɨ gba Davidi, dje ndjinga ya!» ");
INSERT INTO mdm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bhiti okpála bhomʉ-o adʉ ambembe bhʉ́ ’ndjɨ uo ngʉbula me u ndjili má bulu! Engʉ́ bini, u aholo matá nasʉsʉla kpekpeke me: «Ngámá, ndɨlɨ gba Davidi, dje ndjinga ya!» ");
INSERT INTO mdm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Abhomʉ-o, Yesu alʉ. Anɨ aꞌɨ uo. Anɨ atsia ayi uo me: «Yi akʉnda me ma mene pɨ yi mangua ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Do uo pɨ anɨ de-e: «Ngámá, mene me djila ya u ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu adje ndjinga uo, anɨ abu ’kpa e lɨ djila uo. Ma gala kolo me-e, u aholo nau ’kpɨ́. Abhomʉ-o, u atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ne omʉkpata gba e akolo masɨkpe de Yelusalema. U adʉ ɨbili de kʉtɨ na Betefadje, lɨ ngba ’ta na ondula na Olive. Abhomʉ-o, Yesu atsia atima omʉkpata bhisi bhʉ́ ká omʉkpata gba e-o. ");
INSERT INTO mdm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Anɨ apa pɨ uo me: «Yi nʉ bhʉ́ kʉtɨ ɨnde kala yi aoo. Yi akólo lɨe oo, yi abháka kolo me u nde agbite punda na ɵɵlɵ bini, la di ne ndɨlɨ punda bini bhʉ́ dabɨlɨ bini ne anɨ. Yi bhulu uo, amba yi go ne uo mʉma. ");
INSERT INTO mdm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lɨ kpála bini yi yi me yi adji ne uo su-oie, yi de gie me: ‹Ngámá ne gʉmʉ uo.› Abhomʉ-o, anɨ ꞌó bha kolo me yi nʉ ne uo nʉnʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Engʉ́ bhomʉ-o améne lɨe mo-o ngʉbula me engʉ́ ɨnde lɨ polofeta apa nanɨ e, amene lɨe. Polofeta apa nanɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Yi pa pɨ okpála na Siona me: ‹Yi tsitsia nga, ’ngbé ngámá gba yi-e ngago agba yi. Anɨ akɵ lɨe ne kuto. Kaka-a, anɨ adʉ pɨ́ ’ngbʉ ndɨlɨ punda.›» ");
INSERT INTO mdm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Omʉkpata-a anʉ, u atsia amene maka lɨ Yesu apa pɨ uo lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","U ago ne ndɨlɨ punda ne ’hi e. U aha okoti gba o-o, u abu pɨ́ ’ngbʉ uo. Abhomʉ-o, Yesu atsia adʉ pɨ́ ’ngbʉ ndɨlɨ punda-o. ");
INSERT INTO mdm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bhiti okpála na bhibhiti apa okoti gba o kuto lɨ kpadjɨ. Okoko adʉ atsolo ’kpá ngulu, u atsia adʉ napapa lɨ kpadjɨ. ");
INSERT INTO mdm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bhiti okpála ɨnde adʉ adholo kala anɨ di ne obhende adʉ nakpata anɨ-e adʉ asʉsʉla me: «Odjana pɨ ndɨlɨ gba Davidi! A ayo me bisagu dʉ pɨ́ kpála ɨnde ngago ne ’lɨ Ngámá-o! Odjana pɨ Ebhe ɨnde abhʉ́lá-o!» ");
INSERT INTO mdm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lɨ Yesu alɨ lɨe bhʉ́ Yelusalema-a, gʉdhʉ-o adimba madimba. Okpála adʉ ayi me: «A ko da?» ");
INSERT INTO mdm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bhiti okpála atsia adʉ agie me: «A ko polofeta Yesu, kpála na Nadjaleta bhʉ́ ndu doto na Galilaya.» ");
INSERT INTO mdm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pɨpɨta-a, Yesu alɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Anɨ apandja ndʉ okpála hana ɨnde adʉ natsɨndjɨ onʉ di ne odhu ɨnde u adʉ aha o pɨ Ebhe, a la di-e obhende adʉ akakala kilidjo. Anɨ abala omisa gba okpála nayipa falanga, di ne odabɨlɨ gba okpála natsɨndjɨ opidjo-o kuto. ");
INSERT INTO mdm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Abhomʉ-o, anɨ atsia apa pɨ uo me: «U aye bhʉ́ Bhuku gba Ebhe-e me, Ebhe apa me, ‹u aꞌɨ́ etɨ gba ma-a me a ko etɨ na mayo.› La ngayi-e, yi adji, a tsia akolo bɨlɨ gba obhʉlʉ ’zi!» ");
INSERT INTO mdm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Abhomʉ-o, okpála ɨnde ɨ u ’kpɨ́ de ne obhende na eze-e adyudyo lɨo de anɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda, anɨ atsia akobho uo. ");
INSERT INTO mdm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lɨ ongbengbe odimandɵ gba Ebhe , di ne omʉsuno na lɨ́lɨ gba Moidje au ongamba ’ngʉ́ ɨnde anɨ amene e lɨe, la di ne ongɨsɨ ɨnde adʉ asʉsʉla bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda me: «Odjana pɨ ndɨlɨ gba Davidi-e», u asia siti bua . ");
INSERT INTO mdm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Abhomʉ-o, u atsia ayi Yesu me: «Mʉ ngadje engʉ́ ɨnde lɨ ongɨsɨ bhomʉ-o ngapa e uu?» Yesu atsia agie pɨ uo me: «Heni, ma ngadjedje hana. Yi tanga nga engʉ́ ɨnde lɨ Davidi apa nanɨ e bhʉ́ Bhuku gba Ebhe-e belegʉ de bini? Davidi apa nanɨ me, Ebhe amene me belegʉ ongɨsɨ na djedjedje ne obhende ngandjɨ ’ka toko nɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pɨpɨta-a, anɨ aꞌo ká ongbengbe odimandɵ di ne omʉsuno na lɨ́lɨ gba Moidje-e bhʉ́ gʉdhʉ oo. Anɨ atapa bhʉ́ kʉtɨ na Betanɨa, anɨ atsia asɨ oo ko. ");
INSERT INTO mdm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kɵkpɨ́ lɨ ekpɨ́ aseke lɨe, lɨ Yesu aholo nagie matá lɨe lɨe abhʉ́ gʉdhʉ-o, anɨ aholo nadje gʉmʉ. ");
INSERT INTO mdm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Abhomʉ-o, anɨ au ’lá figi dengo ’hi-kpadjɨ. Anɨ adyudyo lɨe dede masɨkpe, engʉ́ bini, anɨ bhaka ’he bhʉ́bhʉ́ belegʉ de bini, bha bini ndʉ mbʉlʉ kpákpá padhá. Anɨ atsia apa pɨ ndula na figi-e me: «Mʉ lɨ́ matá lɨ́lɨ́ belegʉ de bini!» Kolo me-e, ’lá figi aꞌʉlʉ hana má kekele! ");
INSERT INTO mdm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lɨ omʉkpata au lɨe mo-o, u angamba naali, u atsia ayi Yesu me: «Lele pɨ lɨ ’lá figi-e aꞌʉlʉ bha lɨe ma ’li mʉ-o?» ");
INSERT INTO mdm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Do Yesu pɨ uo me: «Ma apa pɨ yi na paká me, ɨ dʉ me yi nde ne nabhuka , yi dʉ ne bua na bhisi bhisi de-e, yi méne bha bini engʉ́ ɨnde ma amene e lɨ kʉte ’lá figi-e de. Engʉ́ bini, yi tɨ da napa belegʉ pɨ eta ɨnde-e me: ‹Yie oo, amba mʉ nʉ tɨ bhʉ́ ngade ’ngu›, ɨ tsia méne lɨe moko. ");
INSERT INTO mdm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ɨ dʉ me yi nde ne nabhuka-a, ndʉ ’he hana ɨnde yi ayó e bhʉ́ mayo-o, yi asía masia.» ");
INSERT INTO mdm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu akolo lɨe bhʉ́ gʉdhʉ-o, anɨ alɨ matá bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Anɨ atsia aholo nasuno pɨ okpála. Abhomʉ-o, ongbengbe odimandɵ gba Ebhe, ne obhelesɨ okpála adyudyo lɨo de anɨ. U atsia ayi anɨ me: «A aha kpadjɨ pɨ mʉ ngʉ́ namene ongʉ́ ɨnde-e da? A aha la di angu ango-o pɨ mʉ ngánga da?» ");
INSERT INTO mdm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu agie pɨ uo me: «Ngama di-e, ma ayí yi lɨ koli engʉ́ bini. Ɨ dʉ me yi nde agie ’ngʉ́ mʉma tété-e, ma tsia pá di pɨ yi me ma ngamene ehe ɨnde-e ne mangua angu dho-ie. ");
INSERT INTO mdm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ma ngayi yi me: ‹A aha nanɨ kpadjɨ pɨ Djaa ngʉ́ nabatisa okpála da? Ne me aha nanɨ kpadjɨ pɨ anɨ ne okpála, ne me aha kpadjɨ pɨ anɨ ne Ebhe?›» U atsia aholo natoto bua o sʉnda o me: «Ɨ dʉ me nɨ́ nde apa me: ‹A aha kpadjɨ pɨ anɨ ne Ebhe-e›, anɨ yí nɨ́ me: ‹Ka nɨ la yi bhuka nanɨ anɨ lɨe de-e?› ");
INSERT INTO mdm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɨ dʉ la di me nɨ́ nde apa me: ‹A aha kpadjɨ pɨ anɨ ne okpála-a›, nɨ́ de tsia ’kpɨ́ lɨnɨ́ ka okpála-a ndjɨndjɨ, anga ndʉ okpála hana dʉ nanɨ nau Djaa me a ko polofeta.» ");
INSERT INTO mdm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Abhomʉ-o, u atsia agie pɨ Yesu me: «Ya mbɨla de me aha nanɨ kpadjɨ pɨ anɨ da-ie de.» Ngaanɨ di-e, anɨ atsia apa pɨ uo me: «Ngama-a, ma pá di pɨ yi de me aha angu mʉma ngʉ́ namene ongʉ́ ɨnde-e da-ie de.» ");
INSERT INTO mdm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu atsia ayi matá me: «Yi apa nga naayi lɨ ’ngʉ́ ɨnde-e pɨ? Kpála bini adʉ nanɨ ne ongɨsɨ gba e bhisi. Anɨ anʉ abhaka bhe na kalanʉ-o, anɨ atsia apa pɨ anɨ me: ‹Ndɨka ma, nakɨ-e, nʉ mene kulu abhiye na vino.› ");
INSERT INTO mdm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ndɨlɨ agie me: ‹Ma nʉ de.› Pɨpɨta-a, anɨ adji bua e, anɨ atsia anʉ abhiye-o. ");
INSERT INTO mdm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","’Dyɨ uo anʉ apa di pɨ bhe na bhisi-e me anɨ nʉ abhiye na vino-o. Bhobhomʉ-o agie pɨ anɨ me: ‹Ma adji, ’dyɨ ma.› La-a, anɨ tsia nʉ de. ");
INSERT INTO mdm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bhʉ́ ká ongɨsɨ bhisi bhomʉ-o, a amene engʉ́ ɨnde lɨ ’dyɨ uo adʉ akʉnda e da?» U agie me: «Bhende na kalanʉ-o.» Yesu atsia apa pɨ uo me: «Ma apa pɨ yi na paká me, ondɵmbɨ na mandjandja, di ne obambakʉya alɨ pɨ yi kalanʉ bhʉ́ Naʉ gba Ebhe-o . ");
INSERT INTO mdm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Padhá de, anga Djaa ago agba yi ne nasuno pɨ yi kpadjɨ na ngbili ’ngʉ́ , yi tsia bhuka anɨ de. Engʉ́ bini, ondɵmbɨ na mandjandja di ne obambakʉya atsia abhuka anɨ. Abana yi au ndʉ ’ngʉ́ bhomʉ-o hana lɨe ne djila yi-e, ngayi-e, yi bhuka anɨ de.» ");
INSERT INTO mdm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu atsia apa matá me: «Yi dje nga matá gbitaku koko ɨnde. Bhʉlʉ bɨlɨ bini alu nanɨ ngu vino, anɨ asa ngongo-o hana ne aga. Anɨ adjɨ edú ngʉ́ napi olɨ́lɨ́-e bhʉ́bhʉ́, anɨ atsia ayiki ’ndjá ’tɨ abhʉ́lá bhʉ́bhʉ́ ngʉbula nalila edyɨ-o. Pɨpɨta-a, u adje lɨo ne okpála ngʉ́ namene kulu bhʉ́ ’dyɨ-o, amba o dʉ agbó bhʉsʉ o ne uo lɨ nguwa-o. Abhomʉ-o, anɨ atsia atapa dhʉkʉ. ");
INSERT INTO mdm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A akolo lɨe lɨ nedhɨnga nako lɨ́lɨ́-e, anɨ atima okpála na kulu gba e agba okpála ɨnde ngamene kulu bhʉ́ ’dyɨ vino me u ha nguwa bhe gba nɨ-e pɨ nɨ haha. ");
INSERT INTO mdm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Engʉ́ bini, okpála namene kulu bhʉ́ ’dyɨ vino azʉmʉ bha okpála ango-o hana. Bhe bini-e, u abhɨ anɨ má kpu! Bhe koko-o, u abhɵlɵ anɨ, bhe na bata-a, u atʉtʉlʉ anɨ ne teme. ");
INSERT INTO mdm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Abhomʉ-o, bhʉlʉ ’dyɨ-e atima matá okpála na kulu koko bhelé nane obhende na kalanʉ-o mane. U amene bhadi uo moko. ");
INSERT INTO mdm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Alɨ soso-o, anɨ atima ndɨlɨ gba e agba okpála ango-o ne nabhundja me: ‹U amánga ndɨlɨ gba ma-a mamanga.› ");
INSERT INTO mdm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Engʉ́ bini, lɨ okpála namene kulu bhʉ́ ’dyɨ vino au ndɨlɨ-e lɨe, u apa sʉnda o me: ‹Kʉkʉlʉ kpála ɨnde atígala la ndjʉ ne edyɨ-e ngae ɨnde. Yi gógo, nɨ́ bhɵlɵ anɨ, amba nɨ́ tigala ɨbili ne edyɨ-e nganɨ́!› ");
INSERT INTO mdm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Abhomʉ-o, u atɨ pɨ anɨ má kɨɨ! U aha anɨ, u agbe anɨ bhʉ́ ’dyɨ na vino-o, u atsia abhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mbɨa ɨnde-e, nedhɨnga lɨ bhʉlʉ ’dyɨ vino agó lɨe, anɨ améne ngʉ́ okpála na kulu bhomʉ-o pɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","U agie pɨ anɨ me: «Anɨ abhíli omabhɵbhɵlɵ kpála bhomʉ-o hana, anɨ djé ndjinga uo de. Pɨpɨta-a, anɨ há ’dyɨ vino pɨ okpála koko ngʉ́ namene kulu bhʉ́bhʉ́, obhende ahá nguwa pɨ anɨ bhʉ́ nedhɨnga u adje lɨo ne uo lɨ e-o.» ");
INSERT INTO mdm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu atsia apa pɨ uo me yi ngagama ’ngʉ́ mʉgɨto me yi tanga nga engʉ́ ɨnde lɨ Bhuku gba Ebhe-e apa e belegʉ de bini. Bhuku gba Ebhe-e apa lɨ ’ngʉ́ gba Masɨya me: «Teme ɨnde lɨ okpála nayiki etɨ-e au me a ne tata ade-e, a akolo teme ɨnde abɨ etɨ-e libhomu-o ngae. Ebhe Ngámá amene mo-o ngae. Bhʉ́ djila nɨ́-e, a ko ’ngʉ́ na ngangamba!» ");
INSERT INTO mdm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Kpála bhende atɨ́ pɨ́ teme ango-o, anɨ gʉ́gʉmʉ. Kpála bhende la di lɨ teme ango-o atɨ́ pɨ́ e, teme ango-o bá mbu anɨ má mbu! Ka yi au teme lɨ Bhuku gba Ebhe-e apa ’ngʉ́ e lɨe padhá-a, ma apa pɨ yi me, ngayi-e, Ebhe aní ’bhɵ bhotɨ na Naʉ gba e pɨ yi mani, anɨ tsia bhúlu pɨ okpála bhende ngamene engʉ́ ɨnde anɨ akʉnda e-o. ");
INSERT INTO mdm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lɨ ongbengbe odimandɵ di ne omʉFalisai adje gbitaku ango-o lɨe, u atsia akɵ mbolimboli me anɨ de ngagama ’ngʉ́ bhomʉ-o pɨndjɨ o. ");
INSERT INTO mdm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","U aholo agɨlɨ kpadjɨ ngʉ́ naholo anɨ, engʉ́ bini, u adʉ ne tsʉlʉ ka okpála, anga okpála adʉ au me a ko polofeta. ");
INSERT INTO mdm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Abhomʉ-o, Yesu apa matá gbitaku pɨ okpála anɨ adʉ akpo ’ngʉ́ pɨ o-o me: ");
INSERT INTO mdm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Yi tsia nga engʉ́ ɨnde lɨ Naʉ na abhʉ́lá akpo ’ndjɨ e ne e-o: A maka tsingʉ gba ’ngbé ngámá bini ɨnde amene anokomɨa na kʉva pɨ ndɨlɨ gba e na bhobhoko. Anɨ atsia aꞌɨ okpála bhʉ́ anokomɨa ango-o. ");
INSERT INTO mdm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ekpɨ́ na anokomɨa ale lɨe, anɨ atima okpála na kulu gba e naꞌɨ okpála ɨnde anɨ aꞌɨ o me u go bhʉ́ anokomɨa ango-o. Engʉ́ bini, u zɨba nago lɨ eꞌɨ ango-o de. ");
INSERT INTO mdm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Anɨ atima matá okpála na kulu koko. Anɨ aha lɨ́lɨ pɨ uo me u nʉ pa pɨ okpála anɨ aꞌɨ o-o me: ‹Mbɨa ɨnde-e, ma alʉ ezʉ gba ma-a alʉ. Ma abhili obagala gba ma ne onʉ na tsɨkpa abhili, ndʉndʉ hana ɨbili bedhe. Yi go bhʉ́ anokomɨa ango-o gogo!› ");
INSERT INTO mdm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Engʉ́ bini, ngauo-o, u adje bha ne ’dje o. U atsia agbida bhʉ́ ongʉ́ gba o. Bhe bini aholo ne enʉ́ abhʉ́ ’dyɨ gba e, koko bhʉ́ natsɨndjɨ mase gba e. ");
INSERT INTO mdm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Okoko aholo okpála na kulu ɨnde u atima o-o, u amene uo kpekpeke, u atsia abhili uo. ");
INSERT INTO mdm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lɨ ’ngbé ngámá-a adje lɨe, anɨ abɨ ’gʉ́ naali. Abhomʉ-o, anɨ atsia atima osʉdha gba e me u bhili omabhɵbhɵlɵ kpála bhomʉ, amba u to di djua lɨ gʉdhʉ gba uo-o. ");
INSERT INTO mdm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pɨpɨta-a, anɨ atsia apa pɨ okpála na kulu gba e me: ‹Anokomɨa na kʉva-a bedhe. Engʉ́ bini, okpála ma aꞌɨ o-o tɨ matá da nago bhʉ́bhʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kaka-a, yi nʉ lɨ odi kpadjɨ, yi ꞌɨ ndʉ okpála ɨnde yi abháka o hana, amba u go zʉ ’he-o.› ");
INSERT INTO mdm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Okpála na kulu bhomʉ-o aze lɨ okpadjɨ. U atsia apo bhʉ́la okpála bhende u adʉ abhaka o-o hana, obabadha okpála di ne osisiti okpála. U anʉ ne uo bhʉ́ ’tɨ na anokomɨa-o. Abhomʉ-o, tɨna ’tɨ na anokomɨa atsia abedhe ne uo bedhe. ");
INSERT INTO mdm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Abhomʉ-o, ’ngbé ngámá-a alɨ bhʉ́ ’tɨ na anokomɨa ngʉbula natsia okpála ɨnde anɨ aꞌɨ o-o. Anɨ au kpála bini ɨnde ɨ dyɨ bongo na anokomɨa de. ");
INSERT INTO mdm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Anɨ ayi kpála ango-o me: ‹Wai, mo olɨ ei lele pɨ me mʉ nde dyɨ bongo na anokomɨa dɨ-e?› Kpála ango-o andjili bha má bulu! ");
INSERT INTO mdm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Abhomʉ-o, ’ngbé ngámá-a apa pɨ okpála na kulu-o me: ‹Yi gbigbite ’kpa anɨ ne ’dhʉ anɨ, amba yi bhike anɨ bhʉ́ biti akilidjo. Oo-o, anɨ adʉ́ aku ’gbá ne nazʉ tate e.›» ");
INSERT INTO mdm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu atsia abu tata-a me: «A moko, Ebhe aꞌɨ okpála bhelé, engʉ́ la bini, obhende anɨ alo o-o, uo bhelé ade.» ");
INSERT INTO mdm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Abhomʉ-o, omʉFalisai anʉ nadi bula ngʉbula nagɨlɨ kpadjɨ ngʉ́ nateke Yesu lɨ ’li e. ");
INSERT INTO mdm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","U atsia atima té omʉkpata gba o bhʉ́ dabɨlɨ bini ne okpála gba Elode ngʉbula napa pɨ Yesu me: «Mʉsuno, ya mbɨla ndjɨndjɨ me mʉ ngapa ngbili ’ngʉ́ . Mʉ ngasuno bhadi kpadjɨ gba Ebhe-e ngbingbili. Tsʉlʉ kpála belegʉ lɨ mʉ ade bini, anga mʉ tsia di engbé gba kpála de. ");
INSERT INTO mdm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mʉ ngabhundja naamʉ pɨ? A ayo me ya kala mandjandja gba ’ngbé ngámá Kaisala ne me ya kala de. Pa nga pɨ ya.» ");
INSERT INTO mdm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Engʉ́ bini, lɨ Yesu ambɨla siti kali gba uo-o lɨe, anɨ atsia apa pɨ uo me: «Obhʉlʉ kali ɨnde-e, ka nɨ yi ngato ma lɨe? ");
INSERT INTO mdm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yi suno nga falanga ɨnde u akakala mandjandja ne e mʉma.» U atsia ago pɨ anɨ ne lɨ́ falanga bini. ");
INSERT INTO mdm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu atsia ayi uo me: «Kulu kpála, ne balʉa ɨnde pɨ́ lɨ́ falanga ɨnde-e, a ko naa da?» ");
INSERT INTO mdm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","U atsia agie pɨ anɨ me: «A ko naa Kaisala.» Abhomʉ-o, anɨ atsia apa pɨ uo me: «Yi ha oehe bhende lɨ Kaisala ngayo e pɨ Kaisala, amba oehe bhende lɨ Ebhe ngayo e, yi ha pɨ Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","U adje lɨe mo-o, u angamba naali. U aꞌo ká anɨ, u atsia agbida. ");
INSERT INTO mdm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bha lɨ ’kpɨ́ bhomʉ-o, oSadukai ago abhaka Yesu. (Ngauo-o, u ngapa naao me okpála ɨnde amu-o zúku de.) U atsia ayi Yesu me: ");
INSERT INTO mdm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Mʉsuno, Moidje apa nanɨ me: ‹Ɨ dʉ me bhoko bini kpi me anɨ nde zu ongɨsɨ de-e, ndai anɨ na bhobhoko-o bhe akɵ pɨta anɨ-e de ha ɵkɵ anɨ ngʉbula nazu ongɨsɨ pɨ ndai e ɨnde akpi-o.› ");
INSERT INTO mdm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gbo nga la ’dje mʉ. Obhosɨ mananɨka adʉ nanɨ agba ya. A adʉ nanɨ ondaise. Bhebhele-e aha ɵlɵ, anɨ atsia akpi me anɨ nde zu de. Bhende akɵ pɨta anɨ-e atsia aha ɵkɵ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bhende na bhisi bhomʉ-o akpi bhadi moko, anɨ nde zu de. A akɵ lɨ bhende na bata, nakolo makolo lɨ bhende na mananɨka-o. Ndʉ uo hana amu me u nde zu de. ");
INSERT INTO mdm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pɨta namu ka ndʉ uo hana-a, ɵlɵ-o atsia akpi di. ");
INSERT INTO mdm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lɨ ’kpɨ́ lɨ okpála ɨnde amu-o azúku lɨe, bhʉ́ ká obhosɨ mananɨka bhomʉ-o, ɵlɵ bhomʉ-o adʉ́ naa da? Padhá de, anga ndʉ uo hana aha nanɨ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu atsia agie pɨ uo me: «Yi angɨta, anga yi kɵ mboli engʉ́ lɨ Bhuku gba Ebhe-e ngapa e de. Yi mbɨla di angu gba Ebhe-e de. ");
INSERT INTO mdm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Padhá de, anga lɨ okpála ɨnde amu-o azúku lɨe, olɨsɨ ne obhosɨ há lɨo de. Engʉ́ bini, u adʉ́ ɨbili maka oandjelu abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pɨndjɨ ’ngʉ́ bhende atsia nazuku ka okpála ɨnde amu-o, yi tanga nga eli gba Ebhe-e dɨ? Ebhe apa nanɨ pɨ yi me: ");
INSERT INTO mdm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ngama-a, ma ne Ebhe ɨnde lɨ onguo ogbi yi Abalahama, Ɨsaka, ne Yakobho ngamene kulu lɨo pɨ e ko.› Ebhe-e, a ko Ebhe gba okpála bhende amu-o ade. Engʉ́ bini, a ko Ebhe gba okpála ɨnde ʉʉ ko.» ");
INSERT INTO mdm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ndʉ okpála hana ɨnde adje engʉ́ bhomʉ-o angamba naali lɨ nasuno gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Abhomʉ-o, Yesu atsia agbite ’bhɵ oSadukai ne engʉ́ anɨ agie e pɨ uo-o. Lɨ omʉFalisai adje lɨe mo-o, u anʉ apo bhʉ́la o de anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sʉka uo adʉ mʉsuno na lɨ́lɨ gba Moidje . Anɨ adʉ akʉnda nato Yesu. Kaka-a, anɨ atsia ayi anɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Mʉsuno, bhʉ́ ká olɨ́lɨ-e, bhende ane ne engbé-e ngae dho?» ");
INSERT INTO mdm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu atsia agie pɨ anɨ me: «‹A ayo me kʉnda Ebhe, Ngámá gba mʉ-o ne bua mʉ hana, ne mʉkobho gba mʉ-o hana, di ne mabhundja gba mʉ-o hana.› ");
INSERT INTO mdm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A bhomʉ-o lɨ́lɨ ɨnde ane ne engbé, ɨnde di lɨ́lɨ na kalanʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bhende pɨpɨta, ɨnde bhadi ngbéngbé maka bhe na kalanʉ-o ngae ɨnde: ‹A ayo me kʉnda kilí mʉ maka mo okʉnda lɨmʉ lɨe ngamʉ makpe-o.› ");
INSERT INTO mdm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Engʉ́ lɨ u aye e bhʉ́ lɨ́lɨ gba Moidje ne bhende lɨ opolofeta aye e hana alʉ pɨ́ olɨ́lɨ bhisi bhomʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","OmʉFalisai adʉ nga bha nagama ’ngʉ́ ne Yesu. Anɨ atsia ayi uo me: ");
INSERT INTO mdm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Yi ngabhundja pɨndjɨ Masɨya pɨ? A ko ndɨlɨ ka da?» U atsia agie pɨ anɨ me: «A ko ndɨlɨ ka Davidi.» ");
INSERT INTO mdm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu atsia ayi uo me: «Ɨ dʉ mo-o, lele pɨ lɨ Davidi, bhʉ́ angu gba Bu Bhobua-a ngaꞌɨ Masɨya lɨe me Ngámá gba nɨ-e? Padhá de, anga Davidi apa nanɨ me: ");
INSERT INTO mdm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Ebhe Ngámá apa pɨ Ngámá gba ma-a me: go dʉ lɨ pá ’kpa ma na kokpa, amba ma mene me mʉ ha angu obhʉlʉ yala gba mʉ-o.› ");
INSERT INTO mdm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ɨ dʉ la me Davidi nde ngaꞌɨ Masɨya me ‹Ngámá gba nɨ-e›, lele pɨ lɨ Masɨya tɨ da nadʉ lɨe ndɨlɨ ka anɨ-e?» ");
INSERT INTO mdm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Abhomʉ-o, kpála bini tsia dʉ ne eli nagigie pɨ anɨ lɨ ’ngʉ́ anɨ ayi e de. Nayie lɨ ’kpɨ́ bhomʉ-o, kpála bini tsia le matá nayi anɨ lɨ ’ngʉ́ belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Abhomʉ-o, Yesu apa pɨ bhiti okpála di ne omʉkpata gba e me: ");
INSERT INTO mdm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Kulu gba omʉsuno na lɨ́lɨ gba Moidje di ne omʉFalisai-e , a ko nambamba ta olɨ́lɨ gba Moidje pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kaka-a, yi mene ndʉ ’ngʉ́ hana ɨnde u apá e pɨ yi-o, amba yi tsia lila di ndjɨndjɨ. Engʉ́ la bini, yi akpáta kulu gba uo-o de, anga engʉ́ u ngapa e, u mene maka u ngapapa lɨe de. ");
INSERT INTO mdm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","U ngagbite titili ’he na titili, u ngaꞌoꞌo de-ngʉlʉ okpála. La-a, ngauo makpe, u ngayala naꞌo nga bha tété ndjɨlɨ ’kpa o ngʉ́ nateteke okpála lɨ tili ’he ɨnde u aꞌo e de-ngʉlʉ uo-o. ");
INSERT INTO mdm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndʉ ’ngʉ́ gba uo hana, u ngamemene me okpála u o mau. Kaka-a, u ngaye ’li Ebhe ne baba djila balʉa, u ngagbigbite pidi o ne lɨ ’kpa o. U la di ngadʉ ’so kandjʉ gba o ndjandjandja ane mane. ");
INSERT INTO mdm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","U ngakʉnda nadʉlʉ bhʉ́ dá oanokomɨa lɨ bɨlɨ gba ongbengbe okpála, u kʉnda di nadʉlʉ bhʉ́ otɨ nadje lɨ́lɨ gba Moidje lɨ bɨlɨ ɨnde lɨ okpála adʉ́ au o lɨe mau. ");
INSERT INTO mdm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","U kʉkʉnda me u dʉ nayi o bhʉ́ odaposo, di ne me okpála dʉ aꞌɨ o me ‹Mʉsuno.› ");
INSERT INTO mdm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pɨ yi-e, yi améne de me okpála dʉ aꞌɨ yi me ‹Mʉsuno-o› de. Padhá de, anga yi bha ne koli Mʉsuno bini, yi la bhadi ndʉ yi hana ne ondaise . ");
INSERT INTO mdm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yi aꞌɨ́ kpála bini pɨ́la doto de me ‹’Dyɨ yi-e› de, anga koli ’dyɨ yi bha bini ngae ɨnde abhʉ́lá ko. ");
INSERT INTO mdm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yi améne di de me okpála dʉ aꞌɨ yi me ‹Ngámá-a› de, anga koli Ngámá gba yi-e bha bini ne Kilisito . ");
INSERT INTO mdm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A ayo me kpála ɨnde ane ne engbé bhʉ́ ká yi-e dʉ kpála na kulu gba yi ko. ");
INSERT INTO mdm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kpála bhende aꞌó lɨe ngae makpe ne abhʉ́lá-a, u akɵ́ anɨ ne akuto. Kpála bhende aꞌó la lɨe ngae makpe ne akuto-o, u aꞌéꞌe anɨ ne abhʉ́lá.» ");
INSERT INTO mdm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesu apa matá me: «A ko lɨkabhu pɨ yi, omʉsuno na lɨ́lɨ, di ne omʉFalisai. Yi ne obhʉlʉ kali! Padhá de, anga yi ngani ’bhɵ bhotɨ na Naʉ gba Ebhe-e pɨ okpála. La ngayi-e, yi lɨ oo de, yi ka la di kpadjɨ pɨ obhende akʉnda nalɨ-e de.  ");
INSERT INTO mdm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","A ko lɨkabhu pɨ yi, omʉsuno na lɨ́lɨ di ne omʉFalisai. Yi ne obhʉlʉ kali! Padhá de, anga yi ngadholo ne ndʉ bɨlɨ hana pɨ́la doto ne pɨ́ ’ngbé ’ngu ngʉbula me gandji kpála bini bhuka lɨ́lɨ gba Moidje-o. Ɨ dʉ la me anɨ nde abhuka-a, yi ngamene me anɨ kolo kpála na djua na dʉdʉma nane yi bhʉtsibhʉtsi bhisi. ");
INSERT INTO mdm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","A ko lɨkabhu pɨ yi, djila yi adʉdʉ. Yi la ngale me yi suno kpadjɨ pɨ okpála! Yi ngapa me: ‹Ɨ dʉ me kpála nde atʉ silika ne ’lɨ ’ngbé ’tɨ Ebhe gba omaYuda-a, engʉ́ tété ade. Engʉ́ la bini, ɨ dʉ me kpála nde atʉ silika ne ’lɨ olo na ’ngbé ’tɨ Ebhe gba omaYuda-a, a ayo me kpála ango-o mene engʉ́ ɨnde anɨ atʉ silika ngʉ́ e-o.› ");
INSERT INTO mdm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ngayi-e, yi ne ongingi, djila yi adʉdʉ! A ane ne engbé ne bhedho? Ne me a ko olo, ne me a ko ’ngbé ’tɨ Ebhe ɨnde ngamene me olo-o kolo bubu kala Ebhe-e? ");
INSERT INTO mdm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yi ngapa matá me: ‹Ɨ dʉ me kpála nde atʉ silika ne ’lɨ bɨlɨ natsulu enʉ pɨ Ebhe-e, engʉ́ tété ade. Engʉ́ la bini, ɨ dʉ me kpála nde atʉ silika ne ’lɨ enʉ ɨnde u ngatsulu e pépé-e, a ayo me kpála ango-o mene engʉ́ ɨnde anɨ atʉ silika ngʉ́ e-o.› ");
INSERT INTO mdm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ngayi-e, djila yi adʉdʉ! A ane ne engbé ne bhedho? Ne me a ko enʉ ɨnde u ngatsulu e pɨ Ebhe, ne me a ko bɨlɨ ɨnde ngamene me enʉ ango-o kolo bubu kala Ebhe-e? Ndʉndʉ hana viti bini. ");
INSERT INTO mdm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kaka-a, kpála bhende ngatʉ silika ne ’lɨ bɨlɨ natsulu enʉ-o, anɨ bhomʉ-o ngatʉtʉ ne ’lɨ bɨlɨ natsulu enʉ, la di ne ’lɨ ndʉ ’he hana ɨnde pépé-o. ");
INSERT INTO mdm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","La di-e, kpála bhende ngatʉ silika ne ’lɨ ’ngbé ’tɨ Ebhe, anɨ bhomʉ-o ngatʉtʉ ne ’lɨ ’ngbé ’tɨ Ebhe, di ne ’lɨ Ebhe ɨnde ngadʉ bhʉ́bhʉ́ ko. ");
INSERT INTO mdm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kpála bhende ngatʉ la di silika ne ’lɨ kokpɨ́-e, anɨ bhomʉ-o ngatʉtʉ ne ’lɨ kiti na ngámá gba Ebhe, la di ne ’lɨ Ebhe ɨnde ngadʉ pépé-o. ");
INSERT INTO mdm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","A ko lɨkabhu pɨ yi omʉsuno na lɨ́lɨ di ne omʉFalisai. Yi ne obhʉlʉ kali! Padhá de, anga yi ngaha belegʉ bini bhʉ́ ká ndjɨkpa na oulu na babadha sese. La-a, ongbengbe ’ngʉ́ ɨnde lɨ lɨ́lɨ-e ngasuno e pɨndjɨ nakodho ’ngʉ́ lɨ lelele bhʉ́ dabɨlɨ bini ne bua na ndjinga, a la di-e namene engʉ́ ɨnde lɨ Ebhe akʉnda e, yi ngauu padhá. A la bhomʉ-o engʉ́ ɨnde a ayo me yi de amene e, me yi nde ꞌɨlɨ di ’to yi lɨ okoko de ko. ");
INSERT INTO mdm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ngayi-e, djila yi adʉdʉ, Yi la ngale me o suno kpadjɨ pɨ okpála! Yi ngapandja ondjindji bhʉ́ ’he nandjɨ mandjɨ gba yi-o. La-a, yi ngabhɨ enʉ maka eya libhomu bhʉ́ ’bu yi má ngbi! ");
INSERT INTO mdm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","A ko lɨkabhu pɨ yi omʉsuno na lɨ́lɨ di ne omʉFalisai. Yi ne obhʉlʉ kali! Padhá de, anga yi ngavʉlʉ kʉte okópo ne osaanɨ gba yi-e má ngbɨ, la-a, ohe ɨnde yi ngaꞌo e bhʉ́bhʉ́-o, a ko ohe ɨnde yi asia e lɨ kpadjɨ na ezi bhʉ́ dabɨlɨ bini ne kʉndʉ ’he ɨnde bhʉ́ yi-o. ");
INSERT INTO mdm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ngayi omʉFalisai-e, yi u ’kpɨ́ de! Yi vʉlʉ ngaɨza bhʉ́ kópo-o ngʉbula me kʉkʉte kolo di babadha. ");
INSERT INTO mdm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","A ko lɨkabhu pɨ yi omʉsuno na lɨ́lɨ di ne omʉFalisai. Yi ne obhʉlʉ kali! Padhá de, anga yi maka olata ɨnde u apulu embú pɨ́ e, ɨnde ɨ ngau lɨe akilidjo babadha. Engʉ́ bini, abhʉ́bhʉ́ abedhe ne tsagala bɨkɨ okpála bhende amu di ne ondʉ ’he na sisiti hana. ");
INSERT INTO mdm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A bhadi pɨ yi moko. Bhʉ́ djila okpála-a, yi ngau lɨyi me yi ne okpála na ngbingbili . La abhʉ́ yi-e, yi abedhe ne kali di ne ongʉ́ na sisiti bedhe. ");
INSERT INTO mdm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","A ko lɨkabhu pɨ yi omʉsuno na lɨ́lɨ di ne omʉFalisai. Yi ne obhʉlʉ kali! Padhá de, anga yi ngaleke olata opolofeta ndjɨndjɨ, yi di ngaye obabadha tele lɨ olata okpála na ngbingbili-o. ");
INSERT INTO mdm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yi la ngapa me: ‹Ya dʉ́ nanɨ bhʉ́ ’kpɨ́ odyɨ ya u-o, ya de kpɵtsɵ ’kpa ya ne uo ngʉ́ nabhili opolofeta de.› ");
INSERT INTO mdm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kaka-a, yi ngakpokpo bhomʉ-o engʉ́ gba yi makpe, me yi ne ongɨsɨ gba okpála ɨnde abhili opolofeta-o! ");
INSERT INTO mdm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Atoú! Yi bedhe ’bhɵ engʉ́ lɨ odyɨ yi akpo nanɨ lita e bebedhe! ");
INSERT INTO mdm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yi ne okpʉlʉ, yi ne piga ombʉma! Yi anéke mangɨmbo nanʉ bhʉ́ djua na dʉdʉma lele pɨ? ");
INSERT INTO mdm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kaka-a, yi djedje nga: ma ngatima opolofeta ne obhʉlʉ ɨmbɨlangʉ, la di ne okʉkʉlʉ omʉsuno na lɨ́lɨ pɨ yi. Yi abhíli okoko bhʉ́ ká uo, yi gɨ́ okoko lɨ kulusi. Yi abhɨ́ okoko ne fimbo bhʉ́ oetɨ nadje lɨ́lɨ gba yi-o, yi tsia nʉ́ ne nato mbolo lɨ okoko bhʉ́ gʉdhʉ bini ne bini. ");
INSERT INTO mdm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yi améne mo-o ngʉbula me ngʉte ndʉ okpála na ngbingbili hana ɨnde yi abhili nanɨ o pɨ́la doto libhomu-o tuko pɨ́ ’ndjɨ yi. Padhá de, anga yi abhili nanɨ okpála na ngbingbili bhelé, nayie lɨ Abele, nakolo lɨ Djakalɨa, ndɨlɨ gba Balasɨ-o. Yi abhɵlɵ nanɨ Djakalɨa bhʉ́ mbadhasʉ na ’ngbé ’tɨ Ebhe, sʉnda bɨlɨ natsulu enʉ pɨ Ebhe ne tɨtɨna na bubu-o. ");
INSERT INTO mdm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A moko, ma apa pɨ yi me ndʉ ’ngʉ́ bhomʉ-o hana atúko pɨ́ ’ndjɨ okpála na nakɨ ɨnde.» ");
INSERT INTO mdm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu apa matá me: «Ngayi okpála na Yelusalema, ngayi okpála na Yelusalema, ngayi-e, yi ngabhili opolofeta, yi la di ngabhili okpála ɨnde lɨ Ebhe atima o pɨ yi-e ne teme! A ko bhʉtsibhʉtsi madho, ma akʉnda napo bhʉ́la ongɨsɨ gba yi-e lɨe maka lɨ ’hi ’ngʉ apopo bhʉ́la ongɨsɨ gba e lɨe sa mbudha e? La-a, yi tsia kʉnda de! ");
INSERT INTO mdm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaka-a, kʉtɨ gba yi-e atígala padhá. ");
INSERT INTO mdm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Padhá de, anga ma apa pɨ yi me nayie pɨ mbɨa ɨnde-e, yi ú matá ma belegʉ de bini akólo lɨ ’kpɨ́ ɨnde yi apá lɨe me: ‹A ayo me Ebhe tuko bisagu pɨ́ kpála ɨnde ngago ne ’lɨ anɨ-o!›» ");
INSERT INTO mdm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Abhomʉ-o, Yesu akoto bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Lɨ anɨ aholo ne ’nʉ́ lɨe, omʉkpata gba anɨ atsia adyudyo lɨo de anɨ ngʉ́ napana pɨ anɨ maka lɨ ’ngbé ’tɨ Ebhe gba omaYuda-a ayiki lɨe lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu atsia apa pɨ uo me: «Yi ngau ndʉ ’he bhomʉ-o hana? Ma apa pɨ yi na paká me, ekpɨ́ bini akólo makolo, u agʉ́gʉmʉ ’ngbé ’tɨ Ebhe-e hana kuto. Teme bini tígala pɨ́ kíli e de.» ");
INSERT INTO mdm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Abhomʉ-o, Yesu anʉ adʉ kuto pɨ́ ’ta na ondula na Olive. Omʉkpata gba anɨ-e adyudyo lɨo de anɨ, u atsia ayi anɨ me u nde ne uo kpi o kpi me: «Mʉsuno, pa nga pɨ ya, engʉ́ mʉ de ngapa e bhomʉ-o améne lɨe nadho? Ehe ɨnde asúno nago ka mʉ-o ne nɨ? Ehe ɨnde asúno la di me sokpɨ́-e akolo ne nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu agie pɨ uo me: «ꞌE-e! Yi lila lɨyi me kpála bini apíte yi de. ");
INSERT INTO mdm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Padhá de, anga okpála bhelé agó ne ’lɨ ma. U adʉ́ abhɨ ’kpa o pɨ́ mbulu o me o ne Masɨya , u tsia píte okpála bhelé naali. ");
INSERT INTO mdm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yi adjé tolo egʉ́ ne ngali ’ngʉ́ na egʉ́. ꞌE-e! Yi adjé tsʉlʉ de, anga a ayo me ndʉ ’ngʉ́ bhomʉ-o hana mene lɨe. Engʉ́ bini, a nga bhomʉ-o sokpɨ́-e de. ");
INSERT INTO mdm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Padhá de, anga okpála na kʉtɨ bini ahá ’gʉ́ pɨ okpála na kʉtɨ koko, lɨ ngámá na kʉtɨ bini há ’gʉ́ pɨ ngámá na kʉtɨ koko. Adyɨndɨ adʉ́ lɨ obɨlɨ ngangá, lɨ adjigidjo dyɨ́kɨ doto lɨ obɨlɨ ngangá. ");
INSERT INTO mdm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ndʉ ’ngʉ́ bhomʉ-o adʉ́ maka lɨkabhu ɨnde adʉ́dʉ kala nazu ka ɵlɵ. ");
INSERT INTO mdm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Abhomʉ-o, ndʉ okpála hana ayála yi ka ’lɨ ma, u apʉ́ yi me u mene yi sisiti. U tsia bhíli yi. ");
INSERT INTO mdm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lɨ okpála bhelé bhʉ́ ká yi ꞌó ká nabhuka gba o. U apʉ́ ngbángá o sʉnda o, u tsia yála di lɨo sʉnda o. ");
INSERT INTO mdm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Opolofeta na eu azé bhibhiti naali, u tsia píte di okpála bhelé. ");
INSERT INTO mdm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Siti ’ngʉ́ abé ndʉ e naali, lɨ mʉkʉnda gba okpála bhelé tsia bɨ́ zini. ");
INSERT INTO mdm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","La-a, kpála bhende alʉ́ kpekpeke bhʉ́ nabhuka nakolo makolo alɨ soso-o, kpála ango-o tsia kóbho. ");
INSERT INTO mdm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","U akpókpo Bádha NgaliNaʉ na abhʉ́lá ɨnde-e pɨ́la doto libhomu, amba ndʉ opiga hana mbɨla ’ngʉ́ tété ndjɨndjɨ. Pɨpɨta-a, lɨ sokpɨ́-e tsia kólo.» ");
INSERT INTO mdm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesu atsia apa matá pɨ omʉkpata gba e me: «Yi aú kpála u aꞌɨ e me ‹’Ngbé Siti bhʉlʉ nabhɵlɵ kʉtɨ›, ɨnde lɨ polofeta Danyele apa nanɨ engʉ́ gba e adʉ bhʉ́ tɨna ’tɨ na bubu ɨnde bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. A ayo me kpála ɨnde atánga engʉ́ nanɨ lɨ Danyele aye e bhomʉ-o kɵ mbolimboli ndjɨndjɨ! ");
INSERT INTO mdm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Abhomʉ-o, obhende abháka o abhʉ́ Yudaya-a, a ayo me u kpe apɨ́ oeta. ");
INSERT INTO mdm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kpála bhende abháka e kilidjo-o, a ayo de me anɨ djidji matá lɨe ngʉ́ nanʉ nabha oehe ɨnde abhʉ́ ’tɨ gba e de. ");
INSERT INTO mdm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kpála bhende abháka e abhiye-e, a ayo de me anɨ gie matá lɨe asidi ngʉ́ naha koti gba e de. ");
INSERT INTO mdm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A ko la mangua lɨkabhu dho pɨ olɨsɨ ɨnde adʉ́ ne ebhɨ di ne obhende adʉ́ aꞌo ’ka bhʉ́ ’bhɵ ongɨsɨ lɨ ’kpɨ́ ango-o! ");
INSERT INTO mdm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yi yo Ebhe me ekpɨ́ nakpe ka yi-e adʉ́ bhʉ́ nedhɨnga na zini di ne lɨ ’kpɨ́ naguo gba omaYuda-a de. ");
INSERT INTO mdm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Padhá de, anga a adʉ́ ’ngbé lɨkabhu na ngbéngbé, ɨnde lɨ okpála u nga e de, nayie maka lɨ Ebhe abho nanɨ kokpɨ́ ne doto lɨe, nakolo pɨ mbɨa ɨnde. Okpála ú la matá di galikpe ngua lɨkabhu ango-o belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ebhe amene me oekpɨ́ ango-o adʉ́ ngengele de. Ɨ dʉ́ me Ebhe gbɵ́tɵlɵ oekpɨ́ ango-o de-e, kpála bini de kóbho de. La-a, anɨ agbɵ́tɵlɵ oekpɨ́ ango-o kabula okpála bhende anɨ alo o-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lɨ nedhɨnga bhomʉ-o, lɨ kpála bini pa pɨ yi me: ‹Yi tsitsia nga, Masɨya sɨ-ɨ›, ɨ dʉ di-e me: ‹Anɨ abhe-e›, yi abhúka anɨ de. ");
INSERT INTO mdm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Padhá de, anga omasɨya na eu di ne opolofeta na eu azé bhelé. U améne ongʉ́ na ngbengbengbe di ongʉ́ na ngangamba ngʉbula napite okpála. Lɨ angu uo kólo makolo-o, u de píte belegʉ okpála ɨnde lɨ Ebhe alo o ko. ");
INSERT INTO mdm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaka-a, ma apa engʉ́ ango-o pɨ yi kalanʉ. ");
INSERT INTO mdm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A moko, ɨ dʉ me u nde apa pɨ yi me: ‹Yi tsitsia nga, Masɨya abhʉ́ mili bɨlɨ-e›, yi anʉ́ oo de. U pa di pɨ yi-e me: ‹Yi tsitsia, anɨ awo lɨe kɨ›, yi abhúka de. ");
INSERT INTO mdm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Padhá de, anga maka lɨ ekpɨ́ andjendjengene lɨe nayie andjongu nakolo akati-e, nago ka ma Ndɨlɨ gba kpála-a adʉ́ bhadi moko. Ndʉ okpála hana au ne djila o. ");
INSERT INTO mdm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A viti bini maka bɨlɨ lɨ kuo ’he nde lɨe me okpála nde mbɨla de-e, okpála ambɨ́la ka odhu ɨnde azʉzʉ kuo apɵ́kɵbhɵ bhadi bhʉ́la o lɨe dede-o.» ");
INSERT INTO mdm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu atsia apa matá me: «Pɨta lɨkabhu na oekpɨ́ bhomʉ-o, ma ’li ma me-e, biti abúku bhʉ́la ela libhomu, epe sʉ́ matá-a de, oɨkʉpala abála kuto, lɨ oangu na abhʉ́lá tsia dyɨ́kɨ má djigi djigi! ");
INSERT INTO mdm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Abhomʉ-o, ehe bini ɨnde asúno me ngama Ndɨlɨ gba kpála ma ngago-o akóto abhʉ́lá. Ndʉ okpála hana pɨ́la doto libhomu adʉ́ bhʉ́ ’gbá. U tsia ú ma, ngama Ndɨlɨ gba kpála me ma nde ngago pɨ́ ndindi abhʉ́lá, ma nde abedhe ne angu la di ne sangu bedhe. ");
INSERT INTO mdm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","U adjé gɨlɨ totɨ na kpekpeke ngaʉ. Ngama, Ndɨlɨ gba kpála-a, ma tsia tíma oandjelu gba ma me u nʉ po bhʉ́la okpála bhende lɨ Ebhe alo o ne ndʉ ’dje doto badha hana, nayie lɨ pápá bini, akólo makolo lɨ pápá koko.» ");
INSERT INTO mdm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesu akpokpo matá gbitaku koko me: «Nago ka ma, Ndɨlɨ gba kpála-a, adʉ́ maka engʉ́ ɨnde asuno lɨe pɨ yi lɨ ndula na figi-o . Yi kɵ mbolimboli ndjɨndjɨ. Padhá de, anga nedhɨnga lɨ ’ndjɨ ’ndjɨ aholo asʉ́ lɨe, lɨ okpákpá holo nakɵ-o, yi mbɨ́la me gbokokpɨ akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kaka-a, nedhɨnga yi aú ndʉ ongʉ́ ɨnde ma akpokpo e pɨ yi bhomʉ-o lɨe hana-a, yi mbɨla ndjɨndjɨ me nago ka ma, Ndɨlɨ gba kpála akolo masɨkpe, me ma bha ɨbili lɨ obhɵ bhotɨ gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ma apa pɨ yi na paká me, ndʉ ’ngʉ́ ɨnde ma akpokpo e pɨ yi pɨndjɨ nago ka ma, Ndɨlɨ gba kpála-a akódho ’kpɨ́ me okpála na nakɨ ɨnde-e nde mu nga ndʉ o hana de. ");
INSERT INTO mdm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kokpɨ́ ne doto akódho ’kpɨ́ makodho, engʉ́ bini, ’li ma kódho ’kpɨ́ belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","La-a, kpála bini mbɨla ekpɨ́ di ne nedhɨnga nago ka ma Ndɨlɨ gba kpála-a de, abana bha oandjelu ɨnde abhʉ́lá, u mbɨla de, abana bha ma Ndɨlɨ-o, ma mbɨla de. Kpála bini mbɨla de, ambɨla bha bini ne ’Dyɨ ma kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Maka engʉ́ ɨnde akodho nanɨ ’kpɨ́ bhʉ́ nedhɨnga gba Nʉa-a, nago ka ma Ndɨlɨ gba kpála adʉ́ bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Padhá de, anga bhʉ́ nedhɨnga bhomʉ-o, kala me engu-o si na eu eu-o, okpála adʉ mʉgɨto me engʉ́ ade. U adʉ nazʉ ’he, u atsia adʉ di nandjɨ pandɨ. Obhosɨ ne olɨsɨ adʉ naha lɨo, u atsia adʉ di amba ongɨsɨ gba o na olɨsɨlɨsɨ bhʉ́ kʉva, akolo lɨ ’kpɨ́ ɨnde lɨ Nʉa alɨ lɨe bhʉ́ ’ngbé zabʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","’To uo dʉ ’to ’ngʉ́ bini de, akolo lɨ nedhɨnga ɨnde lɨ engu asi lɨe, a atsia abha ndʉ uo hana má kpɵkɵbhɵ! Nago ka ma, Ndɨlɨ gba kpála-a adʉ́ bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Abhomʉ-o, ɨ bhaka okpála bhisi abhiye-e, oandjelu gba Ebhe-e ahá bini, u tsia ꞌó ká bhe koko-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɨ bhaka olɨsɨ bhisi ngatʉ mapunga-a, oandjelu gba Ebhe-e ahá bini, u tsia ꞌó ká bhe koko-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yi lila lɨyi ndjɨndjɨ, anga yi mbɨla ekpɨ́ ɨnde lɨ Ngámá gba yi-e agó lɨe de. ");
INSERT INTO mdm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","A ayo me yi mbɨla ndjɨndjɨ me, ɨ dʉ́ me bhʉlʉ ’tɨ-e mbɨ́la nedhɨnga ɨnde lɨ bhʉlʉ ’zi agó lɨe sukpe uu-o, anɨ de dʉ́ bha bini lɨ zʉkʉ. Anɨ de ꞌó de me bhʉlʉ ’zi gʉmʉ etɨ gba nɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kaka-a, ngayi di-e, yi dʉ bedhe, anga nedhɨnga yi nde lɨe bhʉ́ ꞌɨlɨ ’to-o, a la bhomʉ-o nedhɨnga ɨnde lɨ ngama Ndɨlɨ gba kpála ma agó lɨe-o.» ");
INSERT INTO mdm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu atsia apa matá me: «Kpála na kulu ɨnde ngbingbili ɨnde di na ɨmbɨlangʉ-o ngae dho? Yi tsitsia nga, a ko ngua kpála na kulu ɨnde lɨ ngámá gba e aꞌo e pɨ́ ’ndjɨ okpála na etɨ gba e me anɨ dʉ naha ezʉ pɨ uo lɨ nedhɨnga ayo lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A ko djalɨ pɨ kpála na kulu bhomʉ ɨ dʉ me ngámá gba anɨ-e nde ago, anɨ bhaka me anɨ nde ngamemene mo-o. ");
INSERT INTO mdm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma apa pɨ yi na paká me, ngámá aꞌó anɨ pɨ́ ’ndjɨ ndʉ ’he gba e hana. ");
INSERT INTO mdm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Engʉ́ bini, ɨ dʉ me a nde kpála na kulu na sisiti-e, anɨ pá lɨ bua e me: ‹Ha-a, ngámá gba ma nga bha ngabhue.› ");
INSERT INTO mdm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Abhomʉ-o, anɨ hólo nabhɨ obɨ e koko na kulu-o, anɨ hólo nazʉ ’he, anɨ hólo nandjɨ pandɨ ne omʉlangba. ");
INSERT INTO mdm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lɨ ngámá gba kpála na kulu ango-o go lɨ ’kpɨ́ anɨ djeke anɨ lɨe de, di lɨ nedhɨnga ɨnde anɨ mbɨla e de-e, ");
INSERT INTO mdm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","anɨ ꞌé anɨ bhʉ́ kulu, anɨ tsia méne anɨ kpekpeke maka lɨ Ebhe améne galikpe obhʉlʉ kali lɨe lɨ bɨlɨ anɨ abú uo lɨe-o. Oo-o, u adʉ́ aku ’gbá, u tsia dʉ́ di nazʉ tate e-o.» ");
INSERT INTO mdm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Abhomʉ-o, Yesu apa matá me: «Ekpɨ́ lɨ ngama Ndɨlɨ gba kpála ma agó lɨe, engʉ́ ɨnde akódho ’kpɨ́ bhʉ́ Naʉ na abhʉ́lá adʉ́ maka gbitaku ɨnde: a adʉ nanɨ otsalɨsɨ ndjɨkpa ɨnde aha otala gba o ngʉ́ nanʉ nakɵ lɨo ne bhoko ɨnde adʉ akʉnda naha ɵlɵ. ");
INSERT INTO mdm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bhʉ́ ká uo, obhe bhuluvue adʉ ongingi, obhe bhuluvue koko adʉ obhʉlʉ ɨmbɨlangʉ. ");
INSERT INTO mdm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Otsalɨsɨ bhe na ngingi-e aha otala gba o-o, la-a, ’to uo aꞌɨlɨ lɨ naha otsupa ’mʉ koko dede. ");
INSERT INTO mdm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Engʉ́ bini, obhe na ɨmbɨlangʉ-o aha otala gba o bhʉ́ dabɨlɨ bini ne otsupa ’mʉ koko dede. ");
INSERT INTO mdm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lɨ bhoko-o go lɨe má gala de-e, ela aholo ndʉ uo hana, u atsia atuko ne ela. ");
INSERT INTO mdm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tutu sukpe-e, tolo ꞌue akoto: ‹Bhoko-o kɨ-e! Yi ze ngʉ́ nakɵ lɨyi ne uo.› ");
INSERT INTO mdm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Abhomʉ-o, ndʉ otsalɨsɨ-e hana azʉkʉ. U atsia aholo naleke otala gba o-o. ");
INSERT INTO mdm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Otsalɨsɨ bhe na ngingi-e apa pɨ obhende na ɨmbɨlangʉ-o me: ‹Yi ha mbo té emʉ gba yi-e pɨ ya, anga otala gba ya-a ngabʉlʉ.› ");
INSERT INTO mdm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Obhe na ɨmbɨlangʉ-o agie pɨ uo me: ‹A mo-o ade, anga bhe ka ya-a bhelé da nale lɨ lele nɨ́ ne yi ade. Yi nʉ bhaka mangbo okpála ɨ ngatsɨtsɨndjɨ, amba yi kala pɨ yi ka uo.› ");
INSERT INTO mdm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Obhe na ngingi-e anʉ nakala emʉ-o. Engʉ́ bini, nedhɨnga u adʉ anʉ lɨe nakakala-a, bhoko-o akolo. Otsalɨsɨ bhuluvue ɨnde adʉ bedhe alɨ ne anɨ bhʉ́ ’tɨ na anokomɨa-o. U atsia adʉla bhotɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A abhue bedɨ, otsalɨsɨ bhe koko akolo. U atsia aholo nasʉsʉla me: ‹Ngámá, ngámá, bhulu bhotɨ-e pɨ ya!› ");
INSERT INTO mdm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Engʉ́ bini, bhoko-o agie pɨ uo me: ‹Ma apa pɨ yi na paká me, ma mbɨla yi de.›» ");
INSERT INTO mdm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu atsia abu tata-a me: «Yi lila lɨyi, anga yi mbɨla ekpɨ́ lɨ ngama Ndɨlɨ gba kpála ma agó lɨe de, yi mbɨla la di nedhɨnga ango-o de.» ");
INSERT INTO mdm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu apa matá me: «Ekpɨ́ lɨ ngama Ndɨlɨ gba kpála ma agó lɨe, engʉ́ ɨnde akódho ’kpɨ́ bhʉ́ Naʉ na abhʉ́lá adʉ́ maka gbitaku ɨnde: a adʉ nanɨ bhoko bini ɨnde adʉ akʉnda nanʉ dhʉkʉ. Kala nanʉ ka anɨ-e, anɨ aꞌɨ okpála na kulu gba e-o. Anɨ atsia aꞌo tɨa gba e sakpa uo. ");
INSERT INTO mdm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anɨ aha pɨ bhe bini-e lɨ́ falanga kámá bhuluvue. Anɨ aha pɨ bhe koko lɨ́ falanga kámá bhisi. Anɨ atsia aha pɨ bhe koko lɨ́ falanga kámá bini. Anɨ aha pɨ kpála ne kpála lɨ lele angu gba e. Pɨpɨta-a, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kpála na kulu bhe asia kámá bhuluvue-e, anʉ kolo nabe ndʉndʉ. Anɨ atsia asia di lɨ́ falanga koko pépé kámá bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bhende asia kámá bhisi-e amene bhadi moko. Anɨ atsia asia di lɨ́ falanga koko pépé kámá bhisi. ");
INSERT INTO mdm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Engʉ́ bini, bhende asia kámá bini-e anʉ bha naae nadjɨ edú bhʉ́ doto. Anɨ atsia awo tɨa gba ngámá gba e bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pɨpɨta abhue naali, ngámá na kulu gba okpála bhomʉ-o ago. Anɨ atsia aholo nagama ’ngʉ́ ne uo pɨndjɨ lele maka u amene kulu ne tɨa gba nɨ-e lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bhe asia nako lɨ́ falanga kámá bhuluvue adyudyo lɨe. Anɨ agbe lɨ́ falanga kámá bhuluvue koko-o ne napa me: ‹Ngámá, mo oha nako mʉma lɨ́ falanga kámá bhuluvue. A ɨnde-e lɨ́ falanga kámá bhuluvue koko ɨnde ma asia e pépé ko.› ");
INSERT INTO mdm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Do ngámá gba anɨ pɨ anɨ me: ‹So! Mʉ ne bádha kpála na kulu, mʉ la di ngbingbili. Mo omene nako ngbili ’ngʉ́ bhʉ́ ongʉ́ ɨnde djedjedje, ma aꞌó ɨbili mʉ me mʉ dʉ atsia ’kpɨ́ lɨ ongʉ́ na ngbengbengbe. Go kpi djalɨ bhʉ́ dabɨlɨ bini ne ma.› ");
INSERT INTO mdm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kpála na kulu bhende asia nako lɨ́ falanga kámá bhisi-e adyudyo di lɨe. Anɨ pɨ ngámá-a me: ‹Ngámá, mo oha nako mʉma lɨ́ falanga kámá bhisi. A ɨnde-e lɨ́ falanga kámá bhisi koko ɨnde ma asia e pépé ko.› ");
INSERT INTO mdm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Do ngámá gba anɨ pɨ anɨ me: ‹So! Mʉ ne bádha kpála na kulu. Mʉ la di ngbingbili. Mo omene nako ngbili ’ngʉ́ bhʉ́ ongʉ́ ɨnde djedjedje, ma aꞌó ɨbili mʉ me mʉ dʉ atsia ’kpɨ́ lɨ ongʉ́ na ngbengbengbe. Go kpi djalɨ bhʉ́ dabɨlɨ bini ne ma.› ");
INSERT INTO mdm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Lɨ soso-o, kpála bhende asia nako lɨ́ falanga kámá bini-e ago di. Anɨ pɨ ngámá-a me: ‹Ngámá, ma adʉ nako ambɨla ndjɨndjɨ me mʉ ne kpála na gʉ́gʉ́. Mʉ ngaha ’zʉ lɨ bɨlɨ ɨnde mʉ lu ’zʉ lɨ e de. Mʉ ngazʉ ’he lɨ kulu ɨnde lɨ okpála koko andala lɨe ngao. ");
INSERT INTO mdm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ma adje tsʉlʉ mʉ. Ma atsia anʉ awo tɨa gba mʉ-o bhʉ́ doto. A la bhadi ɨɨ. Tɨa gba mʉ-o kɨ.› ");
INSERT INTO mdm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Engʉ́ bini, ngámá gba anɨ agie pɨ anɨ me: ‹Mʉ ne siti kpála na kulu! Mʉ di ne bhʉlʉ ɨpio! Ka nɨ mo odʉ nako ambɨla lɨe ndjɨndjɨ me ma ngaha ’zʉ lɨ bɨlɨ ɨnde ma alu ’zʉ lɨe de, me ma ngazʉ ’he lɨ kulu ɨnde lɨ okpála koko andala lɨe ngao, ");
INSERT INTO mdm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mʉ tsia ꞌo nako tɨa gba ma-a bhʉ́ bakɨ de ka nɨ, amba ma agó lɨe, ma de bhaka me a nde abe ndʉ e abe-e? ");
INSERT INTO mdm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yaka! Yi gbʉlʉ lɨ́ falanga kámá bini bhomʉ-o ka anɨ, amba yi ha pɨ kpála ɨnde ka e kutu bini ko.› ");
INSERT INTO mdm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngámá bhomʉ-o apa mo-o, anga kpála ɨnde ka e ne ehe, u ahá matá koko pɨ anɨ pépé. Anɨ tsia dʉ́ bhʉ́ mʉndeyi. Engʉ́ bini, kpála lɨ ehe nde ka e belegʉ ade bini-e, u agbʉ́lʉ belegʉ dhegʉ bhende ɨ tɨ da nadʉ ka anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ngámá-a atsia abu ’so ’ngʉ́ gba siti kpála na kulu bhomʉ-o ne napa me, u bhike anɨ bhʉ́ biti akilidjo lɨ bɨlɨ ɨnde lɨ okpála nde lɨe bhʉ́ ’gbá di ne nazʉ tate o-o.» ");
INSERT INTO mdm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu atsia apa matá me: «Ekpɨ́ lɨ ngama Ndɨlɨ gba kpála ma agó lɨe bhʉ́ sangu gba ma bhʉ́ dabɨlɨ bini ne oandjelu hana-a, ma adʉ́ pɨ́ kiti na ngámá gba ma na sangu-o. ");
INSERT INTO mdm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ndʉ okpála na pɨ́la doto hana apó bhʉ́la o kala ma. Ma tsia gbógbo bhʉsʉ uo maka lɨ mʉlila agbogbo bhʉsʉ okandɵlɵ lɨe ne omeme-o. ");
INSERT INTO mdm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma aꞌó okandɵlɵ lɨ pá ’kpa ma na kokpa, ma tsia ó omeme-e lɨ pá ’kpa ma na galɨ. ");
INSERT INTO mdm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Abhomʉ-o, ma tsia pá pɨ obhende adʉ́ lɨ pá ’kpa ma na kokpa-a me: ‹Yi gógo, ngayi okpála asia bisagu ka ’Dyɨ ma-o. Yi go sia ngámá ɨnde lɨ anɨ aleke nanɨ e pɨ yi nayie lɨ nedhɨnga anɨ abho kokpɨ́ ne doto lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Padhá de, anga ma adje gʉmʉ, yi atsia aha ezʉ mʉma. Ma adʉ adje gʉmʉ ’ngu, yi atsia aha engu nandjɨ mandjɨ mʉma. Ma adʉ ne gomago, yi atsia asia ma agba yi. ");
INSERT INTO mdm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma adʉ ndumbu, yi atsia ato bongo lɨ ma. A adʉ lɨ ma ne kuo, yi atsia ateteke ma. Ma adʉ bhʉ́ tɨkpʉ, yi atsia ago natsia ma.› ");
INSERT INTO mdm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Abhomʉ-o, obhende amene mʉkʉnda gba Ebhe-e tsia yí ma me: ‹Ngámá, ya au mʉ ne gʉmʉ nadho, ya atsia aha ’zʉ pɨ mʉ-o? Ya au mʉ ne gʉmʉ ’ngu nadho, ya atsia aha engu nandjɨ mandjɨ pɨ mʉ-o? ");
INSERT INTO mdm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ya au mʉ me mʉ nde ne gomago nadho, ya atsia asia mʉ agba ya-a? Ya au mʉ ndumbu nadho, ya atsia ato bongo lɨ mʉ-o? ");
INSERT INTO mdm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ya au mʉ ne kuo, ɨ dʉ di-e me mʉ nde bhʉ́ tɨkpʉ nadho, ya atsia anʉ ateteke mʉ-o?› ");
INSERT INTO mdm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ma tsia gíe pɨ uo me: ‹Ma apa pɨ yi na paká me, ndʉ nedhɨnga hana ɨnde yi amene bádha ’ngʉ́ lɨe pɨ sʉka ondaise ma ɨnde lɨ okpála ngau o padhá ɨnde-e, yi amene bhomʉ-o mʉma.› ");
INSERT INTO mdm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Abhomʉ-o, ma tsia pá di pɨ obhende adʉ́ lɨ pá ’kpa ma na galɨ-e me: ‹Yi yie sɨ yiyie, yi gbida de ma tsutsu, ngayi okpála lɨ Ebhe atʉ pɵdjɵ lɨo-o! Yi nʉ bhʉ́ djua na dʉdʉma ɨnde lɨ Ebhe aleke nanɨ e pɨ djabʉlʉ ne omaha e-o! ");
INSERT INTO mdm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Padhá de, anga ma adʉ adje gʉmʉ, yi tsia ha ’zʉ mʉma de. Ma adʉ adje gʉmʉ ’ngu, yi tsia ha engu nandjɨ mandjɨ mʉma de. ");
INSERT INTO mdm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma adʉ ne gomago, yi tsia sia ma agba yi de. Ma adʉ ndumbu, yi tsia to bongo lɨ ma de. Ma adʉ ne kuo di ne bhʉ́ tɨkpʉ, yi tsia go nateteke ma de.› ");
INSERT INTO mdm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Abhomʉ-o, u tsia yí di ma me: ‹Ngámá, ya au mʉ nadho me mʉ nde ne gʉmʉ, ɨ dʉ di-e gʉmʉ ’ngu-o? Ya au mʉ nadho me mʉ nde ne gomago, mʉ nde ndumbu, ɨ dʉ di-e me mʉ nde ne kuo, ɨ dʉ di-e me mʉ nde bhʉ́ tɨkpʉ-o, ya tsia nʉ teteke mʉ dɨ-e?› ");
INSERT INTO mdm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma tsia gíe pɨ uo me: ‹Ma apa pɨ yi na paká me, ndʉ nedhɨnga hana yi mene bádha ’ngʉ́ lɨe pɨ sʉka ondaise ma ɨnde lɨ okpála ngau o padhá ɨnde-e de-e, yi mbɨla me yi aneke di namemene bhomʉ-o mʉma.› ");
INSERT INTO mdm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Abhomʉ-o, obhende ɨ mene mʉkʉnda gba Ebhe-e de-e, gbída nazʉ lɨkabhu na dʉdʉma. Engʉ́ bini, obhende amene mʉkʉnda gba Ebhe-e, tsia gbída naao bhʉ́ mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lɨ Yesu andjia nakpo ongʉ́ bhomʉ-o lɨe hana-a, anɨ atsia apa pɨ omʉkpata gba e me: ");
INSERT INTO mdm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Yi mbɨla hana me pɨta ’kpɨ́ bhisi-e, adʉ́ anokomɨa na Pasɨka . Lɨ ’kpɨ́ ango-o, u apʉ́ ma Ndɨlɨ gba kpála ngʉbula me u gɨ ma lɨ kulusi.» ");
INSERT INTO mdm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesu adʉ akpo ’ngʉ́ bhomʉ-o pɨ omʉkpata gba e lɨe, abhaka me ongbengbe odimandɵ ne obhelesɨ okpála gba omaYuda nde apo bhʉ́la o agba bhele kpála gba odimandɵ , u aꞌɨ e me Kaifa. ");
INSERT INTO mdm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","U atsia azɨba lɨo ngʉbula naholo Yesu bhʉ́ pepe, amba o bhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Engʉ́ bini, u adʉ apa me: «A ayo de me nɨ́ holo anɨ bhʉ́ nedhɨnga na anokomɨa de, anga lɨ okpála gbe tolo.» ");
INSERT INTO mdm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ekpɨ́ bini, Yesu ne omʉkpata gba e adʉ bhʉ́ kʉtɨ na Betanɨa, abhʉ́ ’tɨ gba Simo nanɨ lɨ kába amene e-o. ");
INSERT INTO mdm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nedhɨnga u adʉ azʉ ’he lɨe, ɵlɵ bini ago de anɨ ne gɨlɨ ɨnde u abho e lɨ alabatele. Gɨlɨ ango-o adʉ me a nde abedhe ne mʉngotsi na kpéke mase bedhe. Anɨ atsia atuko mʉngotsi ango-o pɨ́ ’ndjɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lɨ omʉkpata gba anɨ-e au lɨe mo-o, u ake ’ngʉ́ lɨo, u atsia apa me: «Ta nasiti mʉngotsi ɨnde-e padhá me-e ne nɨ? ");
INSERT INTO mdm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","U tɨ ɨgɨnɨ da natsɨtsɨndjɨ bhʉ́ kpéke mase, u tsia há tɨa ango-o pɨ obhʉlʉ ndɨbhɨlɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lɨ Yesu ambɨla engʉ́ u adʉ apa e lɨe, anɨ atsia apa pɨ uo me: «Yi ngato mbolo lɨ ɵlɵ ɨnde-e ka nɨ? Engʉ́ ɨnde anɨ amene e lɨ pabɨlɨ gba ma-a, a ko bádha ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Padhá de, anga obhʉlʉ ndɨbhɨlɨ-e, yi adʉ́ ne uo ndʉ nedhɨnga hana. Engʉ́ bini, ngama-a, nɨ́ dʉ́ ne yi ndʉ ’kpɨ́ hana de. ");
INSERT INTO mdm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Anɨ atuko mʉngotsi ɨnde lɨ kʉte ma, ngʉbula naleleke ngʉ́ ekpɨ́ ɨnde u azɨ́ ma lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma apa pɨ yi na paká me, pɨ́la doto libhomu, ndʉ bɨlɨ hana ɨnde u akpókpo Bádha Ngali gba Ebhe-e lɨe, u akpókpo di engʉ́ ɨnde lɨ ɵlɵ ɨnde-e amene e ngʉ́ nabhundja anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Abhomʉ-o, sʉka omʉkpata ndjɨkpa ne ká bhisi anʉ nabhaka ongbengbe odimandɵ. A adʉ ’lɨ mʉkpata ango-o me Yuda Ɨsɨkaliote. ");
INSERT INTO mdm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Anɨ atsia apa pɨ uo me: «Yi akʉnda naha mʉma nɨ, amba ma pʉ Yesu pɨ yi-e?» Abhomʉ-o, u adje lɨo ne uo lɨ mase-o. Ongbengbe odimandɵ atanga lɨ́ falanga ndjɨkpa bata, u atsia aha pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nayie bhʉ́ nedhɨnga bhomʉ-o, Yuda adʉ nagɨlɨ nedhɨnga na ndjɨndjɨ ngʉbula napʉ Yesu pɨ uo me u bhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lɨ ’kpɨ́ na kalanʉ na anokomɨa nazʉ mapa ɨnde lɨ levile nde bhʉ́ e ade-e , omʉkpata gba Yesu ago nayi anɨ me: «Mo okʉnda me ya leke dá Pasɨka pɨ mʉ su?» ");
INSERT INTO mdm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu agie pɨ uo me: «Yi nʉ abhʉ́ gʉdhʉ, agba kpála bini me, amba yi pa pɨ anɨ me: ‹Mʉsuno apa me, nedhɨnga gba nɨ-e akolo masɨkpe. Nganɨ ne omʉkpata gba nɨ-e, o ozʉ́ anokomɨa agba mʉ.›» ");
INSERT INTO mdm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Omʉkpata amene maka Yesu apa lɨe pɨ uo-o. Abhomʉ-o, u atsia anʉ aleke da anokomɨa-o. ");
INSERT INTO mdm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lɨ akolo lɨe tagolo-o, Yesu ne omʉkpata gba e ndjɨkpa ne ká bhisi-e aholo nazʉ ’he. ");
INSERT INTO mdm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nedhɨnga uo adʉ azʉ ’he lɨe, do Yesu de-e: «Ma apa pɨ yi na paká me, sʉka yi bini apʉ́ ma.» ");
INSERT INTO mdm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Omʉkpata-a asia lɨkabhu naali. Abhomʉ-o, kpála ne kpála aholo nayi anɨ me: «Ngámá, a adʉ́ bha ndjʉ ma?» ");
INSERT INTO mdm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Anɨ agie pɨ uo me: «Kpála ɨnde ya ngato ’kpa ya ne e bhʉ́ saanɨ bini-e, kpála ango-o apʉ́ ma ngae. ");
INSERT INTO mdm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngama Ndɨlɨ gba kpála, ma adji akpí maka u aye ’ngʉ́ gba ma lɨe-o. Engʉ́ bini, a ko lɨkabhu pɨ kpála ɨnde ngapʉ ma-o! A nanɨ pɨ kpála ango-o ndjɨndjɨ me u azú anɨ de!» ");
INSERT INTO mdm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Abhomʉ-o, Yuda, kpála ɨnde apʉ́ anɨ atsia ayi me: «Mʉsuno, a adʉ́ bha ndjʉ ma?» Yesu atsia agie pɨ anɨ me: «Mo opa ngamʉ!» ");
INSERT INTO mdm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nedhɨnga u adʉ azʉ ’he lɨe, Yesu aha mapa-o. Anɨ agie heni pɨ Ebhe, anɨ agʉmʉ bhʉsʉ bhʉsʉ, anɨ atsia aha pɨ omʉkpata gba e ne napa me: «Yi zʉzʉ, a ɨnde-e kʉte ma.» ");
INSERT INTO mdm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pɨpɨta-a, anɨ aha kópo na vino-o, anɨ agie heni pɨ Ebhe, anɨ atsia aha pɨ uo ne napa me: «Yi ndjɨ ndʉ yi hana, ");
INSERT INTO mdm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","anga a ɨnde-e ngʉte ma. A ko ngʉte ɨnde ngasuno me Ebhe akodho gandja ne okpála-o. Ngʉte ango-o atuko ngʉ́ naꞌe osisiti ’ngʉ́ gba okpála bhelé. ");
INSERT INTO mdm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma apa pɨ yi me: Nayie pɨ mbɨa ɨnde-e, ma ndjɨ́ matá vino belegʉ de bini, akólo lɨ ’kpɨ́ ɨnde ma andjɨ́ lɨe ne toto bhʉ́ dabɨlɨ bini ne yi bhʉ́ Naʉ gba ’Dyɨ ma-o.» ");
INSERT INTO mdm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pɨpɨta-a, u ali etsi na anokomɨa-o. U aze, u atsia agbida apɨ́ eta na ondula na Olive. ");
INSERT INTO mdm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abhomʉ-o, Yesu atsia apa pɨ omʉkpata gba e me: «Sukpe na nakɨ ɨnde-e, ndʉ yi hana aꞌó ká ma. Padhá de, anga Ebhe apa bhʉ́ Bhuku gba e me: ‹Ma abhɵ́lɵ mʉlila gba okandɵlɵ-o, lɨ okandɵlɵ-o tsámbala ne bɨlɨ ngangá.› ");
INSERT INTO mdm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Engʉ́ bini, ngama-a, ekpɨ́ ma azúku lɨe, ma anʉ́ adjeke yi abhʉ́ Galilaya.» ");
INSERT INTO mdm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piele atsia apa pɨ anɨ me: «Abana lɨ ndʉ okpála hana ꞌo ká mʉ-o, ngama-a, ma ꞌó ká mʉ belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Abhomʉ-o, Yesu atsia agie pɨ anɨ me: «Ma apa pɨ mʉ na paká me, sukpe na nakɨ ɨnde-e, kala me engʉ ku ’gbá-a, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» ");
INSERT INTO mdm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piele atsia apa matá pɨ anɨ me: «Abana ɨ dʉ bha me a nde ayo me nɨ́ kpi bhʉ́ dabɨlɨ bini ne mʉ-o, ma ꞌó ká mʉ de.» Abhomʉ-o, ndʉ omʉkpata koko hana atsia apa bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Abhomʉ-o, Yesu akolo ne omʉkpata gba e lɨ bɨlɨ bini ɨnde u aꞌɨ e me Getesemanɨ. Anɨ atsia apa pɨ uo me: «Yi dʉlʉ sɨ nedhɨnga ma adji lɨe nayo Ebhe aoo ko.» ");
INSERT INTO mdm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Anɨ aha Piele ne ongɨsɨ bhisi gba Djebedayo-o. Anɨ anʉ ne uo bhʉ́ dabɨlɨ bini. Tsʉlʉ aholo anɨ, lɨkabhu atsia abedhe di lɨ bua anɨ bedhe. ");
INSERT INTO mdm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Abhomʉ-o, anɨ atsia apa pɨ uo me: «Bua ma abedhe ne lɨkabhu bedhe ka ma adji akpi lɨe-o. Yi dʉlʉ sɨ, yi dʉ la di ne ma lɨ zʉkʉ bhʉ́ dabɨlɨ bini.» ");
INSERT INTO mdm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pɨpɨta-a, anɨ adyudyo mbo lɨe tsutsu bedɨ. Anɨ atʉtʉ lɨpʉkʉ e kuto, anɨ atʉ bhʉ́la e pɨ́ doto, anɨ atsia ayo Ebhe me: «’Dyɨ ma, ɨ dʉ ndjɨndjɨ-e, mʉ de dyudyo lɨkabhu ɨnde-e de ma tsutsu! Engʉ́ la bini, mo oméne maka ma akʉnda lɨe de, mene mangbo maka mo okʉnda lɨe ko!» ");
INSERT INTO mdm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Anɨ agie lɨe lɨ bɨlɨ lɨ omʉkpata bata adʉ lɨe-o. Anɨ abhaka me u nde atuko ne ’la má dhululu! Do anɨ pɨ Piele de-e: «Yi tɨ ɨgɨnɨ da nadʉ lɨ zʉkʉ ngabha ne ma ngʉbula saa bini dɨ? ");
INSERT INTO mdm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yi dʉ lɨ zʉkʉ, yi yo Ebhe, amba yi alɨ́ bhʉ́ nale de. Bua kpála bedhe ndʉ ’kpɨ́ hana ngʉ́ namene bádha ’ngʉ́, engʉ́ bini, kʉte anɨ bhʉbhʉkʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Matá bhʉtsibhʉtsi na bhisi-e, anɨ adyudyo lɨe de omʉkpata bata-a tsutsu. Anɨ atsia ayo Ebhe me: «’Dyɨ ma, ɨ dʉ me lɨkabhu ɨnde-e nde tɨ da naneke ma de-e, a nde ayo bha me a kolo lɨ ma-a, a ayo me engʉ́ mo okʉnda e mene lɨe ngae!» ");
INSERT INTO mdm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Abhomʉ-o, Yesu agie matá lɨe lɨ bɨlɨ lɨ omʉkpata-a adʉ lɨe-o. Anɨ abhaka me u nde tɨla. Padhá de, anga djila uo adʉ me a nde ne ela má yikpokpo! ");
INSERT INTO mdm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Anɨ aꞌo ká uo, anɨ adyudyo matá lɨe de uo tsutsu. Anɨ atsia ayo Ebhe bhʉtsibhʉtsi na bata ne napa bha oeli bini bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Abhomʉ-o, anɨ ago abhaka omʉkpata gba e bata-o, anɨ atsia apa pɨ uo me: «A ndjɨndjɨ! Yi la nga lala, amba yi guo! La-a, nedhɨnga akolo, nedhɨnga ɨnde u apʉ́ ma, Ndɨlɨ gba kpála lɨe pɨ osisiti okpála-o. ");
INSERT INTO mdm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yi tsitsia nga, kpála ɨnde apʉ́ ma akolo. Yi yie bhʉ́lá, nɨ́ nʉ bhaka uo!» ");
INSERT INTO mdm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bha lɨ nedhɨnga lɨ Yesu adʉ agama ’ngʉ́ lɨe, me-e, Yuda, sʉka omʉkpata ndjɨkpa ne ká bhisi-e akolo. Anɨ ago nanɨ ne bhiti okpála ɨnde adʉ sa ’kpa o ne ombotɨa di ne ondula. A atima nanɨ uo ne ongbengbe odimandɵ di ne obhelesɨ okpála gba omaYuda. ");
INSERT INTO mdm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda adje nanɨ lɨe ne uo kalanʉ me: «Kpála ɨnde ma akáma e, a ko anɨ. Yi holo anɨ!» ");
INSERT INTO mdm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Me-e, anɨ adyudyo lɨe de Yesu, anɨ atsia ayi anɨ me: «Mʉsuno, mʉ oo!» Anɨ atsia akama anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu atsia apa pɨ anɨ me: «Olia ma, engʉ́ ɨnde mo ogo namene e, memene!» Abhomʉ-o, okpála koko ɨnde ago bhʉ́ dabɨlɨ bini ne Yuda-a, adyudyo lɨo de Yesu, u abu ’kpa o lɨ anɨ, u atsia aholo anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kolo me-e, sʉka okpála ɨnde adʉ bhʉ́ dabɨlɨ bini ne Yesu-o agbe mbotɨa gba e, anɨ asʉ kpála na kulu gba bhele kpála gba odimandɵ-o ne nakodho ’dje anɨ má tse! ");
INSERT INTO mdm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu atsia apa pɨ anɨ me: «Gie mbotɨa gba mʉ-o bhʉ́ ’tɨ e. Padhá de, anga ndʉ okpála hana ɨnde ngagʉ ’gʉ́ ne mbotɨa-a, amú bhadi lɨ mbotɨa. ");
INSERT INTO mdm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mʉ mbɨla de me ma tɨ ɨgɨnɨ da nayo ka ’Dyɨ ma me anɨ go teteke ma-a dɨ? Ma yo ka anɨ-e, anɨ kolo tíma libi oandjelu mʉma nane ndjɨkpa ne ká bhisi mane. ");
INSERT INTO mdm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ɨ dʉ la mo-o, engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e améne lɨe lele pɨ? Padhá de, anga Bhuku gba Ebhe-e apa me, a ayo me engʉ́ ɨnde ngamene lɨe ɨnde-e, amene lɨe moko.» ");
INSERT INTO mdm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Abhomʉ-o, Yesu atsia apa pɨ kambɨ okpála bhomʉ-o me: «Ndʉ ’kpɨ́ hana ma adʉ nako nadʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda ngʉ́ nasuno. La-a, yi holo nako ma de. Ka nɨ yi ngago lɨe ngʉ́ ma ne ombotɨa di ne ondula sa ’kpa yi mʉgɨto me ma ne siti bhʉlʉ ’zi-e? ");
INSERT INTO mdm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Engʉ́ bini, ndʉ ’ngʉ́ bhomʉ-o hana amene lɨe ngʉbula me engʉ́ ɨnde lɨ opolofeta aye e amene lɨe.» Abhomʉ-o, ndʉ omʉkpata hana atsambala de anɨ má mʉe, u atsia agbida! ");
INSERT INTO mdm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Abhomʉ-o, okpála ɨnde u atima nanɨ o ngʉ́ naholo Yesu-o anʉ ne anɨ kala Kaifa, bhele kpála gba odimandɵ-o, lɨ bɨlɨ ɨnde lɨ omʉsuno na lɨ́lɨ gba Moidje ne obhelesɨ okpála apɵkɵbhɵ bhʉ́la o lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piele atsia adʉ naae nakpata Yesu mbo tsutsu, nakolo makolo bhʉ́ mbadhasʉ gba bhele kpála gba odimandɵ-o. Anɨ alɨ bhʉ́ mbadhasʉ-o, anɨ atsia adʉ kuto bhʉ́ ká okpála na kulu ngʉbula natsia me engʉ́ ango-o abú ’ta e lele pɨ-ie. ");
INSERT INTO mdm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abhomʉ-o, ongbengbe odimandɵ bhʉ́ dabɨlɨ bini ne ndʉ okpála koko na Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda libhomu adʉ agɨlɨ kpála ɨnde agó napa ’ngʉ́ lɨ Yesu sisiti, abana ɨ dʉ eu, amba o kodho ’ngʉ́ gba anɨ-e me anɨ kpi bha makpi. ");
INSERT INTO mdm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Engʉ́ bini, belegʉ lɨ bhiti okpála adʉ apa ’ngʉ́ lɨ Yesu lɨe ne eu-o, u u kpála bini de ɨnde apa engʉ́ ɨnde u tɨ da nabhɵlɵ anɨ ka e. Lɨ soso-o, okpála bhisi adyudyo lɨo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","U atsia apa me: «Bhoko ɨnde-e apa nako me, ‹nɨ tɨ da nabhɵlɵ ’ngbé ’tɨ Ebhe gba omaYuda-o, nɨ tsia yíki matá ne toto sʉnda ekpɨ́ bata.›» ");
INSERT INTO mdm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Abhomʉ-o, ’ngbé dimandɵ-o ayie bhʉ́lá, anɨ atsia ayi Yesu me: «Mʉ gie ’ngʉ́ lɨ ’ngʉ́ ɨnde lɨ okpála ɨnde-e ngapa e lɨ kʉte mʉ-o belegʉ de bini?» ");
INSERT INTO mdm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Engʉ́ bini, Yesu andjili bha má bulu! Abhomʉ-o, bhele kpála gba odimandɵ-o atsia ayi matá anɨ me: «Ma ngayi mʉ ne ’lɨ Ebhe ɨnde ʉʉ-o me pa nga pɨ ya: ngamʉ-o, mʉ ne Masɨya , Ndɨlɨ gba Ebhe-e?» ");
INSERT INTO mdm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu agie pɨ anɨ me: «Mo opa ngamʉ. Mbɨla la me, nayie pɨ mbɨa ɨnde-e, yi aú Ndɨlɨ gba kpála adʉ lɨ pápá na kokpa gba Angbamɨlɨ me anɨ nde ngago pɨ́ ndindi na abhʉ́lá.» ");
INSERT INTO mdm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Engʉ́ bhomʉ-o ake lɨ bua bhele kpála gba odimandɵ-o naali. Abhomʉ-o, anɨ asidha bongo lɨ e má tsʉe! Anɨ atsia apa me: «Anɨ asobho Ebhe, anga kpála-kʉtɨ tɨ da nakpo ’ndjɨ e ne Ebhe de! Nɨ́ matá ne gʉmʉ okpála koko ngʉ́ nakpokpo ’ngʉ́ gba anɨ-e ade! Yi adje sobho anɨ asobho Ebhe ne e ne ’dje yi makpe. ");
INSERT INTO mdm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yi abhundja naayi me nɨ́ mene ngʉ́ anɨ pɨ?» U agie me: «A ayo me u bhɵlɵ anɨ mabhɵlɵ.» ");
INSERT INTO mdm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Abhomʉ-o, u aholo akuku ngʉsʉ bhʉ́la anɨ, u adʉ asʉ anɨ, u atsia adʉ di abhɨ bhʉ́la anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","U atsia adʉ apa pɨ anɨ me: «Ɨ dʉ me mʉ nde bha ndjʉ ne Masɨya na paká-a, pa nga pɨ ya me asʉ mʉ da?» ");
INSERT INTO mdm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nedhɨnga u adʉ ato mbolo lɨ Yesu lɨe, abhaka me Piele nde adʉ kilidjo tʉ mbadhasʉ gba bhele kpála gba odimandɵ-o. Kpála bini na kulu na ɵɵlɵ adyudyo lɨe de anɨ. Anɨ atsia apa pɨ anɨ me: «Ngamʉ di-e, mo odʉ nako bhʉ́ dabɨlɨ bini ne Yesu, kpála na Galilaya-o.» ");
INSERT INTO mdm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Engʉ́ bini, Piele ayala kala ndʉ okpála hana me: «Ma mbɨla engʉ́ ɨnde mʉ ngakʉnda napa e de.» ");
INSERT INTO mdm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Abhomʉ-o, Piele adyudyo lɨe de ’bhɵ aga-o. Kpála na kulu koko bini na ɵɵlɵ au anɨ. Anɨ atsia apa pɨ okpála ɨnde adʉ oo me: «Kpála ɨnde-e adʉ nako bhʉ́ dabɨlɨ bini ne Yesu, kpála na Nadjaleta-o.» ");
INSERT INTO mdm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piele ayala matá, anɨ atsia apa me: «Ne ’lɨ Ebhe, ma mbɨla kpála ɨnde yi ngapa ’ngʉ́ gba e bhomʉ-o de!» ");
INSERT INTO mdm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pɨpɨta kolo me-e, okpála ɨnde adʉ oo adyudyo lɨo, u atsia apa pɨ Piele me: «A ko kʉkʉlʉ ’ngʉ́. Ngamʉ di-e, mʉ bha ne sʉka uo, anga nagama ’ngʉ́ gba mʉ-o ngambamba ta mʉ ngae.» ");
INSERT INTO mdm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Abhomʉ-o, Piele aholo natʉ silika ne nasɨma me: «Ne ’lɨ Ebhe, ma mbɨla kpála bhomʉ-o de!» Bha lɨ nedhɨnga bhomʉ-o, engʉ atsia aku ’gbá. ");
INSERT INTO mdm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Abhomʉ-o, Piele abhundja eli ɨnde lɨ Yesu apa ɨgɨnɨ e pɨ anɨ me: «Kala me engʉ ku ’gbá-a, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» Anɨ akoto kilidjo, anɨ atsia abhɵlɵ kuo e ne egbá má kusu! ");
INSERT INTO mdm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kɵkpɨ́ má bhɵ, ndʉ ongbengbe odimandɵ hana di ne obhelesɨ okpála gba omaYuda adje lɨo me o méne lele pɨ me o bhɵlɵ Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","U agbigbite anɨ, u anʉ ne anɨ, u atsia aha anɨ pɨ guvelenele Pɨlatɵ. ");
INSERT INTO mdm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Abhomʉ-o, Yuda, kpála ɨnde apʉ Yesu-o au lɨe me u akodho ’ngʉ́ gba anɨ-e me anɨ kpi bha makpi-e, anɨ adje lɨkabhu lɨ bua e naali. Anɨ atsia anʉ nagie lɨ́ falanga ndjɨkpa bata-a pɨ ongbengbe odimandɵ di ne obhelesɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Do anɨ pɨ uo de-e: «Ma amene siti ’ngʉ́, anga ma apʉ kpála ɨnde ɨ tʉ ’ngʉ́ de-e pɨ yi me u bhɵlɵ anɨ!» Engʉ́ bini, u agie pɨ anɨ me: «Naaya bhʉ́bhʉ́ ne nɨ? A ko naamʉ ’ngʉ́!» ");
INSERT INTO mdm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Abhomʉ-o, Yuda abala lɨ́ falanga kuto bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda ne nakoto bini. Anɨ atsia anʉ nagɨ ngʉlʉ e. ");
INSERT INTO mdm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ongbengbe odimandɵ-o aha tɨa-o. U atsia apa me: «Lɨ́lɨ gba nɨ́-e zɨba de me nɨ́ ꞌo tɨa ɨnde-e bhʉ́ ká tɨa na ’ngbé ’tɨ Ebhe gba omaYuda-a de, anga a ko tɨa ɨnde u asia e lɨ ngʉte kpála.» ");
INSERT INTO mdm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pɨta u adje lɨo lɨe, u atsia akala ne tɨa bhomʉ-o edyɨ gba kpála bini ɨnde apopo lʉsa ngʉbula me u dʉ azɨ ogomago bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kaka-a, u ngaꞌɨ ’lɨ edyɨ ango-o nakolo pɨ nakɨ me: «Edyɨ ɨnde u akala e ne tɨa na ngʉte kpála.» ");
INSERT INTO mdm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Abhomʉ-o, engʉ́ nanɨ lɨ polofeta Djelemi apa e atsia amene lɨe. Anɨ apa nanɨ me: «U aha lɨ́ falanga ndjɨkpa bata-o. A bhomʉ-o mase ɨnde lɨ omaƗsalaele ato e lɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","U atsia akala ne di edyɨ gba bhʉlʉ napo lʉsa. A bhomʉ-o engʉ́ ɨnde lɨ Ebhe Ngámá aha nanɨ lɨ́lɨ mʉma me ma pa e pɨ uo-o.» ");
INSERT INTO mdm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nedhɨnga u akolo ne Yesu lɨe kala guvelenele Pɨlatɵ-o, anɨ ayi anɨ me: «Ngamʉ-o, mʉ ne ’ngbé ngámá gba omaYuda-a?» Yesu agie me: «Mo opa ngamʉ.» ");
INSERT INTO mdm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Abhomʉ-o, ongbengbe odimandɵ di ne obhelesɨ okpála gba omaYuda adʉ apa ’ngʉ́ lɨ anɨ sisiti. La-a, anɨ gie ’ngʉ́ tété de. ");
INSERT INTO mdm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pɨlatɵ atsia ayi anɨ me: «Mʉ dje engʉ́ ɨnde u ngapa e lɨ kʉte mʉ bhomʉ-o dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Engʉ́ bini, Yesu gie engʉ́ bini pɨ anɨ tété de. Abhomʉ-o, Pɨlatɵ atsia angamba naali. ");
INSERT INTO mdm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bhʉ́ ndʉ Pasɨka hana, guvelenele dʉ nanɨ natse ’kpa lɨ bhʉlʉ ’kpʉ́ bini, bhende lɨ bhiti okpála adʉ akʉnda me anɨ tse ’kpa lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A abhaka me ’ngbé bhʉlʉ ’kpʉ́ bini ɨnde adʉ ’lɨ e me Balabasɨ nde bhʉ́ tɨkpʉ. ");
INSERT INTO mdm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pɨlatɵ atsia ayi bhiti okpála ɨnde apo bhʉ́la o me: «Yi akʉnda me ma tse ’kpa lɨ da pɨ yi-e? Ne me ma tse ’kpa lɨ Yesu Balabasɨ, ne me ma tse ’kpa lɨ Yesu ɨnde u aꞌɨ e me Masɨya-a ?» ");
INSERT INTO mdm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pɨlatɵ yi mo-o padhá de. Anɨ ayi mo-o, anga anɨ adʉ ambɨla ndjɨndjɨ me u apʉ Yesu pɨ nɨ anga u adʉ adje siti bua lɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nedhɨnga lɨ Pɨlatɵ adʉ lɨe pɨ́ kiti nakodho ’ngʉ́-o, wala anɨ atima kpála bini pɨ anɨ ne tobhɨla me: «Mo olɨ́ bhʉ́ ’ngʉ́ gba ngbili kpála bhomʉ-o de, anga sukpe na nakɨ ɨnde-e, ma aloto siti loto lɨ ’ngʉ́ gba anɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ongbengbe odimandɵ, di ne obhelesɨ okpála gba omaYuda ato bhʉ́ ’ndjɨ bhiti okpála me u yo ka Pɨlatɵ me anɨ tse ’kpa lɨ Balabasɨ, amba anɨ ka kpadjɨ me u bhɵlɵ Yesu. Okpála atsia amene bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pɨlatɵ atsia apa pɨ uo me: «Ma atsé ’kpa lɨ bhʉlʉ ’kpʉ́ bini pɨ yi matse. Bhʉ́ ká Yesu ne Balabasɨ-e, yi akʉnda me ma tse ’kpa lɨ da pɨ yi-e?» U agie me: «Balabasɨ!» ");
INSERT INTO mdm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pɨlatɵ ayi uo me: «Ma mene la ngʉ́ Yesu ɨnde u aꞌɨ e me Masɨya pɨ?» Do uo de-e: «Gɨ anɨ lɨ kulusi!» ");
INSERT INTO mdm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pɨlatɵ atsia ayi uo me: «Anɨ amene la mangua siti ’ngʉ́ dho?» Engʉ́ bini, u atsia adʉ asʉsʉla matá kpekpeke me: «Gɨ anɨ lɨ kulusi!» ");
INSERT INTO mdm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lɨ Pɨlatɵ au lɨe me angu nɨ kolo de-e, di ne me tolo ngakolo kpekpeke-e, anɨ aha engu, anɨ atsia avʉlʉ ’kpa e kala bhiti okpála ne napa me: «Ngama-a, ma bhʉ́ ta nakpi gba kpála ɨnde-e ade! A ko naayi ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ndʉ okpála hana agie me: «A ayo me ngʉte anɨ tuko pɨ́ ’ndjɨ ya ne ongɨsɨ gba ya-o!» ");
INSERT INTO mdm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Abhomʉ-o, anɨ atse ’kpa lɨ Balabasɨ pɨ uo. Anɨ aha lɨ́lɨ me u bhɨ Yesu ne fimbo. Anɨ atsia aha anɨ pɨ uo me u gɨ anɨ lɨ kulusi. ");
INSERT INTO mdm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Abhomʉ-o, osʉdha gba guvelenele anʉ ne Yesu bhʉ́ mbadhasʉ gba o dengo ’tɨ gba guvelenele-o. Ndʉ osʉdha hana atsia apo bhʉ́la o de anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","U agbe bongo lɨ anɨ, u atsia ato koti na mbembe lɨ anɨ mʉgɨto me a ko ngámá. ");
INSERT INTO mdm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","U agala ’he na kilikili lɨ kʉte yá ndula na eti, u atsia ato bhʉ́ ’ndjɨ anɨ. U ato mbamba sa ’kpa anɨ na kokpa, u atsia atʉtʉ lɨpʉkʉ o kuto kala anɨ. U adʉ amʉ anɨ ne napa me: «’Ngbé ngámá gba omaYuda, mʉ oo!» ");
INSERT INTO mdm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","U adʉ aku ngʉsʉ lɨ anɨ, u aha mbamba-a, u atsia adʉ asʉ ’ndjɨ anɨ ne di. ");
INSERT INTO mdm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","U andjia namʉ anɨ lɨe, u agbe koti u de ato e lɨ anɨ-o, u atsia ato matá bongo gba anɨ-e lɨ anɨ. Pɨpɨta-a, u atsia anʉ ne anɨ ngʉ́ nagɨ anɨ lɨ kulusi. ");
INSERT INTO mdm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Osʉdha akoto ne Yesu bhʉ́ gʉdhʉ-o. U adʉ akoto lɨe, u akɵ lɨo ne kpála bini na kʉtɨ na Silene, adʉ ’lɨ anɨ me Simo. Osʉdha aholo anɨ ne kpéke me anɨ bɨ kulusi gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lɨ u akolo lɨe lɨ bɨlɨ ɨnde u aꞌɨ e me Gologota-a, ɨnde akʉnda napa me «Bɨlɨ na pelege ’ndjɨ-e», ");
INSERT INTO mdm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","osʉdha aha vino ɨnde u amata e ne ’he na sʉsʉ-o pɨ anɨ. Anɨ ale lɨe, anɨ tsia kʉnda nandjɨndjɨ de. ");
INSERT INTO mdm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Osʉdha-a agɨ Yesu lɨ kulusi. Pɨta u agɨ anɨ lɨe lɨ kulusi-e, u agʉ gbanda ngʉ́ obongo gba anɨ-o. U atsia agbogbo bhʉsʉ o tété. ");
INSERT INTO mdm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pɨpɨta-a, u atsia adʉlʉ kuto oo ngʉ́ nalila anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","U aꞌo nanɨ abhʉ́lá pɨ́ ’ndjɨ anɨ balʉa ɨnde asuno ta nagɨ anɨ lɨ kulusi-o. U aye nanɨ balʉa ango-o me: «A ɨnde-e Yesu, ’ngbé ngámá gba omaYuda-o.» ");
INSERT INTO mdm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","U atsia agɨ osisiti obhʉlʉ ’zi bhisi lɨ okulusi de anɨ: bini lɨ kulusi gba e lɨ pá ’kpa anɨ na kokpa, koko lɨ kulusi gba e lɨ pá ’kpa anɨ na galɨ. ");
INSERT INTO mdm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Okpála ɨnde adʉ akodho ’kpɨ́-e, adʉ asobho Yesu ne nako ’ndjɨ o. ");
INSERT INTO mdm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","U adʉ apa pɨ anɨ me: «Ngamʉ, bhʉlʉ nagʉgʉmʉ ’ngbé ’tɨ Ebhe gba omaYuda ne nayiyiki bhʉ́ ’kpɨ́ bata-a, kobho lɨmʉ ngamʉ makpe! Ɨ dʉ me mʉ nde ne ndɨlɨ gba Ebhe-e, kɵ lɨ kulusi-e kuto.» ");
INSERT INTO mdm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ongbengbe odimandɵ, omʉsuno na lɨ́lɨ gba Moidje bhʉ́ dabɨlɨ bini ne obhelesɨ okpála, adʉ bhadi amʉ anɨ moko. U adʉ apa me: ");
INSERT INTO mdm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Anɨ akobho okpála koko. Ka nɨ anɨ tɨ da nakobho lɨe lɨe ngae makpe dɨ-e, ngaanɨ ɨnde ’ngbé ngámá gba omaƗsalaele-e? Anɨ kɵ nga kuto lɨ kulusi mbɨa ɨnde, amba ya bhuka anɨ! ");
INSERT INTO mdm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anɨ aꞌo nabhuka gba e bhʉ́ Ebhe. A ayo me Ebhe kobho anɨ mbɨa ɨnde, ɨ dʉ me Ebhe nde akʉnda anɨ na paká-o, anga anɨ apa me nɨ ne Ndɨlɨ gba Ebhe!» ");
INSERT INTO mdm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abana osisiti obhʉlʉ ’zi ɨnde u agɨ o lɨ kulusi lɨngo Yesu-o, u adʉ bhadi asobho anɨ moko. ");
INSERT INTO mdm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Abhomʉ-o, nayie tulukpe akolo bhʉ́ saa na bata pɨta tulukpe-e, biti agba pɨ́la doto libhomu. ");
INSERT INTO mdm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bhʉ́ saa na bata pɨta tulukpe-e, Yesu asʉla kpekpeke me: «Eli, Eli, lema sabakatanɨ?» A akʉnda napa me: «Ebhe gba ma, Ebhe gba ma, mo oꞌo ka ma ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bini bini bhʉ́ ká okpála ɨnde adʉ oo adje anɨ lɨe, u atsia adʉ apa me: «Anɨ ngaꞌɨ Elɨya!» ");
INSERT INTO mdm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma ’li ma-e, sʉka osʉdha-a agu holo. Anɨ anʉ aha epondje, anɨ ato bhʉ́ kpongadha pandɨ. Anɨ atsia ato lɨ ’ndjɨ mbamba, anɨ aha pɨ Yesu me anɨ ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Engʉ́ bini, okoko apa pɨ anɨ me: «Djedjeke, nɨ́ u nga ne me Elɨya ngago nakobho anɨ!» ");
INSERT INTO mdm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu atsia asʉla matá kpekpeke, anɨ atsia andala ’kpa lɨ bua e. ");
INSERT INTO mdm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Me-e, ’ngbé ’kpá bongo ɨnde adʉ abuku ’bhɵ tɨna ’tɨ na bubu bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a asidha bhʉsʉ e bhisi má tsʉe nayie abhʉ́lá, akolo akuto. Doto adyɨkɨ, ongbengbe teme atsia aʉʉpa. ");
INSERT INTO mdm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Abhomʉ-o, olata-a ada bhʉsʉ o, bhiti omabhuka ɨnde amu nanɨ-e atsia azuku. ");
INSERT INTO mdm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","U aze bhʉ́ olata gba o-o. Pɨta lɨ Yesu azuku lɨe, u atsia agbida bhʉ́ Yelusalema, gʉdhʉ na bubu-o. Okpála bhelé atsia au uo. ");
INSERT INTO mdm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ngámá gba osʉdha na Loma bhʉ́ dabɨlɨ ne osʉdha gba e ɨnde adʉ alila Yesu nedhɨnga anɨ adʉ lɨe lɨ kulusi-e au engʉ́ ɨnde akodho ’kpɨ́ ne nadyɨkɨ ka doto-o. Abhomʉ-o, u adje tsʉlʉ naali. U atsia apa me: «Kpála ɨnde-e bha ndjʉ nako ne Ndɨlɨ gba Ebhe na paká!» ");
INSERT INTO mdm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Olɨsɨ bhelé adʉ lɨ bɨlɨ bhomʉ-o. U adʉ atsia ’ngʉ́ bhomʉ-o mbo tsutsu. Olɨsɨ ango-o ayie nanɨ ne Yesu bhʉ́ Galilaya, nakolo makolo bhʉ́ Yelusalema ngʉ́ nateteke anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bhʉ́ ká uo, a adʉ nanɨ Malɨa , kpála na gʉdhʉ na Magadala, Malɨa ’hi Djakɨ ne Djodjefʉ , a la di-e ’hi ongɨsɨ gba Djebedayo-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A akolo lɨe tagolo-o, bhʉlʉ tɨa bini ago. A adʉ kpála na gʉdhʉ na Alɨmatayo. A adʉ ’lɨ anɨ me Djodjefʉ . Kpála ango-o dʉ di nanɨ mʉkpata gba Yesu. ");
INSERT INTO mdm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Anɨ anʉ abhaka guvelenele Pɨlatɵ, anɨ atsia ayo kuo Yesu ka anɨ. Pɨlatɵ atsia aha lɨ́lɨ me u ha pɨ anɨ haha. ");
INSERT INTO mdm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Abhomʉ-o, Djodjefʉ aha kuo Yesu, anɨ agagala ne daladeli na mbɨa ɨnde anɨ akala e bhʉ́ kpéke mase. ");
INSERT INTO mdm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Anɨ anʉ ato bhʉ́ lata na mbɨa ɨnde anɨ aleke nanɨ e pɨ e makpe bhʉ́ teme-o. Pɨpɨta-a, anɨ awawala ’ngbé teme bini lɨ bhɵbhɵ ngʉ́ nanini, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nedhɨnga bhomʉ-o, Malɨa, kpála na gʉdhʉ na Magadala ne Malɨa bhe koko adʉlʉ kuto bhʉ́la lata-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lɨ ekpɨ́ aseke lɨe, a akʉnda napa me bhʉ́ ekpɨ́ naguo gba omaYuda-a , ongbengbe odimandɵ di ne omʉFalisai anʉ bhʉ́ dabɨlɨ bini agba Pɨlatɵ. ");
INSERT INTO mdm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","U atsia apa pɨ anɨ me: «Ngámá, ’ndjɨ ya ago mbɨa ɨnde-e lɨ engʉ́ lɨ bhʉlʉ eu bhomʉ-o apa nako e nedhɨnga anɨ adʉ lɨe ʉʉ-o me pɨta ’kpɨ́ bata nɨ zúku-o. ");
INSERT INTO mdm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kaka-a, a ayo me ha lɨ́lɨ me u lila lata anɨ nakolo bhʉ́ ’kpɨ́ na bata. Padhá de, anga ɨ dʉ mo-o de, omʉkpata gba anɨ-e tɨ da nago nazi kuo anɨ. U tsia pá pɨ okpála me anɨ azuku. Lɨ okpála dje la ɨbili mo-o, eu bhende-e né la ɨbili da bhende anɨ apa nako e kalanʉ-o mane.» ");
INSERT INTO mdm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pɨlatɵ atsia apa pɨ uo me: «Yi ha osʉdha-a haha. Yi nʉ ne uo, amba u lila lata-a maka yi au lɨe ndjɨndjɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","U atsia anʉ naleke lele nalila lata-o. U ayele bhɵbhɵ ne teme, u atsia aꞌo osʉdha ngʉ́ nalilila. ");
INSERT INTO mdm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pɨta ekpɨ́ naguo gba omaYuda-a , bhʉ́ ’kpɨ́ yinga kɵkpɨ́ má bhɵ́-o, Malɨa , kpála na gʉdhʉ na Magadala ne Malɨa koko-o, agbida ngʉ́ natsia lata-o. ");
INSERT INTO mdm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Me-e, doto adyɨkɨ ne adjigidjo na ngbéngbé, anga andjelu bini gba Ngámá-a ayie abhʉ́lá, anɨ ago awawala teme ɨnde adʉ lɨ ’bhɵ lata-o, anɨ atsia adʉ pépé. ");
INSERT INTO mdm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kʉte anɨ adʉ asʉ má ngbɨ́ ngbɨ́ ngbɨ́! La di-e, bongo gba anɨ-e avu má tuu! ");
INSERT INTO mdm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lɨ osʉdha ɨnde adʉ alila lata-a au lɨe mo-o, u aholo nagʉkʉ ka tsʉlʉ má kpi kpi kpi, u atsia abala kuto mʉgɨto me a ko okpála ɨnde amu. ");
INSERT INTO mdm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Engʉ́ bini, andjelu-o apa pɨ olɨsɨ-e me: «Yi akpé-e de, anga ma ambɨla me yi ngagɨlɨ Yesu ɨnde u agɨ nako e lɨ kulusi-o. ");
INSERT INTO mdm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anɨ sɨɨ ade. Anɨ azuku maka anɨ apa nako lɨe-o. Yi go tsia bɨlɨ ɨnde u aseke nako anɨ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yi nʉ pa kolo pɨ omʉkpata gba anɨ-e má gala me, anɨ azuku. Anɨ adji kala yi bhʉ́ Galilaya bhomʉ. Yi aú anɨ oo. A bhomʉ-o ngali ma de ago napa e pɨ yi-o.» ");
INSERT INTO mdm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Abhomʉ-o, olɨsi-e ayie bha kolo bhʉ́ lata-a má gala me u nde abedhe ne tsʉlʉ di ne djalɨ bedhe. U anʉ ne holo, u atsia anʉ ngʉ́ napa ngali ango-o pɨ omʉkpata gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma ’li ma me-e, Yesu ago akɵ lɨe ne olɨsɨ ango-o. Anɨ atsia ayi uo me: «Yi oo!» Abhomʉ-o, u adyudyo lɨo de anɨ, u atuko kuto bhʉ́ li ’dhʉ anɨ, u atsia adhɵgɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pɨpɨta-a, Yesu atsia apa pɨ uo me: «Yi akpé-e de. Yi nʉ pa pɨ ondaise ma me u nʉ abhʉ́ Galilaya, u aú ma oo ko.» ");
INSERT INTO mdm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lɨ olɨsɨ-e adʉ nga bha lɨe lɨ kpadjɨ-e, okpála koko bhʉ́ ká osʉdha ɨnde adʉ nalila lata-a anʉ abhʉ́ gʉdhʉ. U atsia akpokpo ndʉ ’ngʉ́ hana ɨnde akodho ’kpɨ́ abhʉ́ lata-a pɨ ongbengbe odimandɵ gba Ebhe-o . ");
INSERT INTO mdm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Abhomʉ-o, ongbengbe odimandɵ apo bhʉ́la o ne obhelesɨ okpála gba omaYuda-o, u atsia adje lɨo me o méne pɨ-ie. Pɨta nadje lɨe ka uo-o, u aha tɨa bhelé pɨ osʉdha-a me u apá kʉkʉlʉ ’ngʉ́ ɨnde akodho ’kpɨ́-e de. ");
INSERT INTO mdm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","U atsia apa pɨ uo me: «Ɨ dʉ me kpála bini nde ayi yi-e, yi de pa me: ‹Nedhɨnga ya adʉ lɨe tɨla-a, omʉkpata gba anɨ-e ago, u atsia azi kuo anɨ lɨ ya.› ");
INSERT INTO mdm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","La di-e, ɨ dʉ me guvelenele nde adje-e, ya ambɨ́la lele ya akpókpo pɨ anɨ lɨe ngaya, amba yi asía mangɨmbo de.» ");
INSERT INTO mdm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Osʉdha abha tɨa-o, u atsia amene bha maka u apa lɨe pɨ uo-o. Abhomʉ-o, ngali ango-o ayangba bha sʉnda omaYuda moko nakolo pɨ nakɨ. ");
INSERT INTO mdm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abhomʉ-o, omʉkpata ndjɨkpa ne ká bini-e anʉ bhʉ́ Galilaya, pɨ́ eta ɨnde lɨ Yesu apana nanɨ e pɨ uo me nɨ akɵ́ lɨnɨ ne uo pɨ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","U akolo lɨe oo, Yesu akoto lɨ uo. U au anɨ lɨe, u atuko kuto bhʉ́ li ’dhʉ anɨ, u atsia adhɵgɵ anɨ. Engʉ́ bini, okoko bhʉ́ ká uo adʉ ne bua na bhisi bhisi. ");
INSERT INTO mdm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Abhomʉ-o, Yesu adyudyo lɨe de uo, anɨ atsia apa pɨ uo me: «Ebhe aha ndʉ angu na abhʉ́lá ne bhe na pɨ́la doto hana mʉma. ");
INSERT INTO mdm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaka-a, yi nʉ bhʉ́ ndʉ opiga hana. Yi mene me u kolo omʉkpata gba ma. Yi batisa uo ne ’lɨ ’Dyɨ nɨ́, ne ’lɨ Ndɨlɨ, la di ne ’lɨ Bu Bhobua . ");
INSERT INTO mdm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yi suno pɨ uo me u lila ndʉ lɨ́lɨ ɨnde ma aha e pɨ yi-e hana. Yi mbɨla la me ngama-a, nɨ́ ne yi bhʉ́ dabɨlɨ bini ndʉ ’kpɨ́ hana akólo bha bini makolo alɨ sokpɨ́.»");
INSERT INTO mdm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","A ɨnde-e lita Bádha Ngali gba Yesu Kilisito , Ndɨlɨ gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Maka lɨ polofeta Ɨsaya aye lɨe bhʉ́ bhuku gba e me: «Ebhe apa me: Djedje nga! Ma atíma bhʉlʉ titima gba ma-a pɨ mʉ kalanʉ ngʉbula naleke kpadjɨ pɨ mʉ. ");
INSERT INTO mdm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kpála ango-o ngatotobhɨla abhʉ́ mili bɨlɨ me: ‹Yi leke kpadjɨ pɨ Ngámá! Yi lɨlɨ odjedje kpadjɨ pɨ anɨ má ngbʉʉ ngbʉʉ!›» ");
INSERT INTO mdm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kaka-a, Djaa bhʉlʉ nabatisa okpála akoto nanɨ abhʉ́ mili bɨlɨ. Anɨ adʉ aꞌɨ okpála me u go sia batisimo ngʉ́ nasuno me u adji bua o adji, amba Ebhe ꞌe siti ’ngʉ́ gba uo-o. ");
INSERT INTO mdm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abhomʉ-o, ndʉ okpála hana na ndu doto na Yudaya, di ne ndʉ okpála hana na gʉdhʉ na Yelusalema adʉ ago abhaka anɨ. U adʉ ambamba ta osisiti ’ngʉ́ gba o-o kala ndʉ okpála hana. Djaa atsia adʉ abatisa uo bhʉ́ ngade ’ngu na Djʉlʉdanɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Djaa adʉ adyɨ bongo ɨnde u adʉ e lɨ su enʉ u aꞌɨ e me «samo.» Anɨ adʉ agbite ludu e ne ekpʉ́ na kó ’nʉ. Anɨ adʉ azʉ omakindolo di ne nadha ’mʉ eʉ́. ");
INSERT INTO mdm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anɨ atsia adʉ apa pɨ uo me: «Kpála bini ngago pɨta ma. Kpála ango-o ane ma ne angu. Ma ne tetele kpála ade ngʉbula me ma kita ne kuto ngʉbula me ma bhulu ekpʉ́ na malɵkɵ gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngama-a, ma ngabatisa yi ne engu. Engʉ́ bini, ngaanɨ-e, anɨ abátisa yi ne Bu Bhobua .» ");
INSERT INTO mdm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bhʉ́ okpɨ́ bhomʉ-o, Yesu ayie bhʉ́ Nadjaleta, gʉdhʉ bini na ndu doto na Galilaya, Djaa atsia abatisa anɨ bhʉ́ ngade ’ngu na Djʉlʉdanɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nedhɨnga lɨ Yesu adʉ akoto lɨe bhʉ́ ’ngu-o, anɨ au kokpɨ́ ngada bhʉsʉ e. Anɨ atsia au di Bu Bhobua ngakɵ pɨ́ e maka bɵbhɵ. ");
INSERT INTO mdm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Abhomʉ-o, eli bini akoto abhʉ́lá, atsia apa me: «Mʉ ne Ndɨlɨ gba ma ɨnde ma kʉnda e naali, mʉ ne kpʉ́kpʉ́ na bua ma.» ");
INSERT INTO mdm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pɨpɨta kolo me-e, Bu Bhobua atsia amba bhʉ́la Yesu abhʉ́ mili bɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anɨ adʉ oo ngʉbula ekpɨ́ ndjɨkpa badha me Satana nde ngale anɨ. Yesu adʉ nadʉ lɨ bɨlɨ lɨ onʉ na bɨlɨ adʉdʉ lɨ e-o. Oandjelu atsia adʉ nateteke anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ekpɨ́ bini, pɨta lɨ Elode Atipasɨ aholo Djaa lɨe, anɨ atsia ato anɨ bhʉ́ tɨkpʉ-o, Yesu anʉ bhʉ́ ndu doto na Galilaya. Anɨ adʉ akpokpo Bádha Ngali gba Ebhe-e pɨ okpála. Anɨ adʉ apa me: ");
INSERT INTO mdm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Nedhɨnga nanɨ lɨ Ebhe aꞌo e akolo. Naʉ gba anɨ-e akolo di masɨkpe. Yi dji bua yi, yi bhuka Bádha Ngali gba Ebhe-o.» ");
INSERT INTO mdm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Lɨ anɨ adʉ akpangba ngo ’kpɵ na Galilaya lɨe, anɨ au Simo ne ndai e Andɨlɨ me u nde ngabhike nado bhʉ́bhʉ́. Padhá de, anga u dʉ nanɨ obhʉlʉ nagbe sungu. ");
INSERT INTO mdm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu atsia apa pɨ uo me: «Yi kpata ma, ma adjí ɨbili yi obhʉlʉ nagɨlɨ okpála pɨ Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kolo me-e, u aꞌo ka onado gba o-o, u atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pɨpɨta-a, Yesu adyudyo mbo lɨe ne kalanʉ masudha, anɨ au ongɨsɨ gba Djebedayo: Djakɨ ne ndai e Djaa . U adʉ me u nde bhʉ́ zabʉ gba o, u nde ngaleke onado gba o-o. ");
INSERT INTO mdm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Abhomʉ-o, anɨ aꞌɨ uo. Má gala kolo me-e, u aꞌo ka ’dyɨ o, Djebedayo bhʉ́ zabʉ bhʉ́ dabɨlɨ bini ne okpála na kulu-o. U atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Abhomʉ-o, Yesu ne omʉkpata gba e akolo bhʉ́ kʉtɨ na Kapalanauma. A akolo lɨe bhʉ́ ’kpɨ́ naguo gba omaYuda-a , Yesu alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje , anɨ atsia aholo nasuno. ");
INSERT INTO mdm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Okpála ɨnde adʉ nadje anɨ-e, adʉ nangamba naali lɨ nasuno gba anɨ-o. Padhá de, anga anɨ dʉ asuno maka omʉsuno na lɨ́lɨ gba Moidje de. Engʉ́ bini, anɨ adʉ asuno ne angu. ");
INSERT INTO mdm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A abhaka me bhʉ́ ’tɨ nadje lɨ́lɨ oo, kpála bini ɨnde lɨ siti bua adʉ bhʉ́ e nde oo. Abhomʉ-o, kpála ango-o asʉla me: ");
INSERT INTO mdm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yesu, kpála na Nadjaleta, mo okʉnda namene ngʉ́ ya pɨ? Mo ogo ngʉ́ nandjia angu ya? Ma mbɨla hana me mʉ ne da-ie. Mʉ ne Kpála na Bubu ɨnde lɨ Ebhe atima e ko!» ");
INSERT INTO mdm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Engʉ́ bini, Yesu ambe bhʉ́ ’ndjɨ siti bua ango-o me: «Gbite ’bhɵ mʉ, amba mʉ koto la di bhʉ́ kpála ango-o makoto!» ");
INSERT INTO mdm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Abhomʉ-o, siti bua adyɨkɨ kpála bhomʉ-o má djigi djigi! Anɨ atʉ ꞌue, anɨ atsia akoto bhʉ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ndʉ okpála hana angamba naali. Kaka-a, u aholo nayi lɨo sʉnda o me: «A ɨnde-e mangua ’ngʉ́ dho? Nasuno na mbɨa ɨnde-e abedhe ne angu! Kpála ɨnde-e ngaha belegʉ lɨ́lɨ pɨ osisiti bua, u la bhadi ngamemene!» ");
INSERT INTO mdm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Abhomʉ-o, ngali gba Yesu-o ayangba bha kolo bhʉ́ ndu doto na Galilaya libhomu. ");
INSERT INTO mdm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu akoto lɨe bhʉ́ ’tɨ nadje lɨ́lɨ-e me-e, u atsia anʉ ne Djakɨ di ne Djaa bhʉ́ ’tɨ gba Simo ne Andɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A abhaka me ’hi wala Simo nde asɨ kuto, ka anga adʉ lɨ anɨ ne kuo, kʉte anɨ adʉ kpákpá. Abhomʉ-o, u atsia apa kolo engʉ́ gba anɨ-e pɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Anɨ dyudyo lɨe de anɨ. Anɨ aha ’kpa anɨ, anɨ aꞌe anɨ bhʉ́lá. Kuo ayie lɨ anɨ, anɨ atsia aholo nalʉ ’zʉ pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A akolo lɨe tagolo pɨta natɨ ka ela-a, okpála aholo nago ne obhʉlʉ kuo di ne obhende adʉ ne osisiti bua bhʉ́ o pɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Okpála na gʉdhʉ libhomu adʉ apo bhʉ́la o lɨ ’bhɵ bhotɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Abhomʉ-o, Yesu akobho okpála bhelé ɨnde adʉ ne okuo ngangá. Anɨ atsia apandja di obua na sisiti bhelé ɨnde adʉ nadʉ bhʉ́ okpála-o. Anɨ ha la di nedhɨnga pɨ osisiti bua ango-o ngʉ́ nagama ’ngʉ́ belegʉ de bini. Padhá de, anga a adʉ me u nde ngambɨla anɨ hana. ");
INSERT INTO mdm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bhʉ́ sɨkɨkpɨ-e, me biti nde ani nga bha má gbu-o, Yesu ayie bhʉ́lá, anɨ akoto. Anɨ atsia atapa abhʉ́ mili bɨlɨ. Oo, anɨ aholo nayo Ebhe. ");
INSERT INTO mdm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Abhomʉ-o, Simo ne okpála bhende u adʉ ne o-o, aholo nagɨlɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","U au anɨ lɨe, do uo pɨ anɨ me: «Ndʉ okpála hana ngagɨlɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Nɨ́ nʉ lɨ obɨlɨ koko, bhʉ́ okʉtɨ na ngongo, amba ma kpokpo di Ngali gba Ebhe-e oo. Padhá de, anga a bhomʉ-o engʉ́ ɨnde ma ago ngʉ́ e ko.» ");
INSERT INTO mdm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Abhomʉ-o, Yesu adholo nanɨ bhʉ́ ndu doto na Galilaya libhomu. Anɨ atsia adʉ akpokpo Ngali gba Ebhe-e bhʉ́ otɨ nadje lɨ́lɨ na kʉtɨ gba uo-o. Anɨ adʉ di napandja osisiti bua ɨnde adʉ nadʉ bhʉ́ okpála-o. ");
INSERT INTO mdm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bhʉ́ oekpɨ́ bhomʉ-o, bhʉlʉ kába bini adyudyo lɨe de Yesu. Anɨ atʉtʉ lɨpʉkʉ e kuto kala anɨ, anɨ atsia akikiliki lɨe pɨ anɨ me: «Ɨ dʉ me mʉ nde akʉnda-a, mʉ tɨ da nakobho ma.» ");
INSERT INTO mdm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu adje ndjinga anɨ, anɨ aꞌo ’kpa e lɨ kʉte anɨ. Anɨ atsia apa pɨ bhʉlʉ kába ango-o me: «Ako, ma akʉnda. Kokobho!» ");
INSERT INTO mdm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma ’li ma me-e, kába agʉlʉ lɨ anɨ hana má da! Anɨ atsia akobho. ");
INSERT INTO mdm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kolo me-e, Yesu agie anɨ sidi ne nagbele ’dje anɨ kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Anɨ atsia apa pɨ anɨ me: «Djedje! Mo osʉ́ ’kpá lɨ ’ngʉ́ ɨnde-e de kpála bini belegʉ de má kpo! Engʉ́ bini, nʉ suno lɨmʉ pɨ dimandɵ gba Ebhe , amba mʉ ha makiso gba mʉ-o maka lɨ Moidje aye nanɨ lɨe-o. Bhobhomʉ-o asúno pɨ okpála me mo okobho.» ");
INSERT INTO mdm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","La-a, lɨ kpála ango-o ayie lɨe oo, anɨ aholo bha ne kpokpo ’ngʉ́ bhomʉ-o pɨ ndʉ okpála hana lɨ ndʉ bɨlɨ hana ɨnde anɨ adʉ apʉ lɨ e-o. Kaka-a, Yesu tɨ matá nanɨ da nasuno lɨe mbámbá bhʉ́ gʉdhʉ de. Engʉ́ bini, anɨ adʉ bha ɨbili nadʉ ne alɨngo gʉdhʉ, bhʉ́ omili bɨlɨ. Okpála adʉ ayie ne ndʉ bɨlɨ hana, u atsia adʉ ago nabhaka anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pɨta ’kpɨ́ masudha-a, Yesu agie lɨe bhʉ́ Kapalanauma. Okpála atsia adje me anɨ akʉtɨ. ");
INSERT INTO mdm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Abhomʉ-o, kambɨ okpála ago apo bhʉ́la o oo. Kaka-a, bɨlɨ na padhá tsia dʉ de, belegʉ de alɨ ’bhɵ bhotɨ. Anɨ atsia adʉ akpokpo eli gba Ebhe-e pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bhʉ́ nedhɨnga bhomʉ-o, obhosɨ badha ago pɨ anɨ ne dʉkuto bini me u nde abɨ anɨ mabɨ. ");
INSERT INTO mdm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Engʉ́ bini, lɨ okpála adʉ la lɨe bhelé-e, u tsia tɨ nanɨ da nakolo ne anɨ lɨ Yesu de. Abhomʉ-o, u atsia aꞌʉ ne anɨ apɨ́ ’ngbʉ ’tɨ. U adʉ gudho lɨ ’ngbʉ ’tɨ-e lɨ lele bɨlɨ ɨnde Yesu adʉ lɨe-o. U atsia akɵ dʉkuto-o pɨ́ kalagba gba e tété. ");
INSERT INTO mdm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lɨ Yesu au nabhuka gba uo lɨe, anɨ atsia apa pɨ dʉkuto-o me: «Ndɨka ma, osisiti ’ngʉ́ gba mʉ-o aꞌe lɨe aꞌe.» ");
INSERT INTO mdm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Omʉsuno na lɨ́lɨ koko gba Moidje adʉ me u nde adʉlʉ kuto oo. U atsia adʉ nabhundja lɨ bua o me: ");
INSERT INTO mdm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Kpála ɨnde-e ngagama ’ngʉ́ mo-o ka nɨ? Anɨ ngasobho Ebhe. A tɨ da naꞌe siti ’ngʉ́ gba kpála da, bha bini Ebhe kpi e kpi dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu atsia ambɨla bha kolo me u ngabhundja lɨ bua o mo-o. Abhomʉ-o, anɨ atsia apa pɨ uo me: «Yi ngabhundja lɨ bua yi mo-o ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A ane ne bhʉkʉ ne bhedho: ne napa pɨ dʉkuto-o me «Osisiti ’ngʉ́ gba mʉ-o aꞌe lɨe aꞌe», ne napa me «Yie bhʉ́lá, ha kalagba gba mʉ-o, amba mʉ dhʉkʉ?» ");
INSERT INTO mdm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Engʉ́ bini, ma adji asuno pɨ yi me «Ndɨlɨ gba kpála ne angu naꞌe osisiti ’ngʉ́ gba okpála na pɨ́la doto.» Abhomʉ-o, anɨ atsia apa pɨ dʉkuto-o me: ");
INSERT INTO mdm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ma apa pɨ mʉ me yie bhʉ́lá, ha kalagba gba mʉ-o, amba mʉ gie lɨmʉ agba mʉ!» ");
INSERT INTO mdm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kolo me-e, bhoko ango-o ayie bhʉ́lá, anɨ aha kalagba gba e-o, anɨ akoto bhʉ́ ká djila ndʉ okpála hana, anɨ atsia atapa. Ndʉ okpála hana adʉ angamba. U adʉ adhɵgɵ Ebhe. U atsia adʉ apa me: «Ya u nga ngua engʉ́ ɨnde-e belegʉ de bini!» ");
INSERT INTO mdm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pɨpɨta-a, Yesu anʉ matá lɨngo ekpɵ na Galilaya. Bhiti okpála adʉ ago abhaka anɨ, anɨ atsia adʉ asuno pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anɨ adʉ akodho ’kpɨ́ lɨe, anɨ au Levi, ndɨlɨ gba Alafayo me anɨ nde adʉ bhʉ́ ’tɨ ɨnde u adʉ akala mandjandja bhʉ́ e-o. Yesu apa pɨ anɨ me: «Kpata ma.» Levi ayie bhʉ́lá, anɨ atsia akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pɨpɨta-a, Yesu atsia anʉ nazʉ ’he bhʉ́ ’tɨ gba anɨ. Ondɵmbɨ na mandjandja di ne okpála namene siti ’ngʉ́ bhelé adʉlʉ de Yesu ne omʉkpata gba e-o. Padhá de, anga ongua okpála bhomʉ-o bhelé adʉ akpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lɨ omʉsuno na lɨ́lɨ ɨnde adʉ bhʉ́ ká omʉFalisai au lɨe me Yesu ngazʉ ’he ne ongua okpála bhomʉ-o, u atsia ayi omʉkpata gba anɨ-e me: «Anɨ ngazʉ ’he bhʉ́ dabɨlɨ bini ne ondɵmbɨ na mandjandja di ne okpála namene siti ’ngʉ́ ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu adje uo napa engʉ́ bhomʉ-o lɨe, anɨ atsia apa pɨ uo me: «Okpála ɨnde ne kuo ade-e ne gʉmʉ mʉtɨa ade. Engʉ́ bini, okpála na kuo mangbo ne gʉmʉ anɨ ngao. Ma go ngʉ́ naꞌɨ okpála bhende apa me o ngbingbili-e de. Engʉ́ bini, ma ago mangbo ngʉ́ naꞌɨ obhende ngau lɨo me o ne osisiti okpála ko.» ");
INSERT INTO mdm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ekpɨ́ bini, omʉkpata gba Djaa bhʉlʉ nabatisa okpála di ne omʉFalisai adʉ atse ’zʉ ngʉ́ nayo Ebhe. Abhomʉ-o, okpála ago ayi Yesu me: «Ka nɨ́ lɨ omʉkpata gba mʉ-o tsetse ezʉ lɨe ngʉ́ nayo Ebhe de-e, obhende gba Djaa bhʉlʉ nabatisa okpála di ne obhende gba omʉFalisai-e nde la ngatsetse-e?» ");
INSERT INTO mdm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu agie pɨ uo me: «Yi abhundja naayi me okpála ɨnde ago bhʉ́ da anokomɨa na kʉva tɨ da natse nazʉ ’he me ’ko ɵlɵ-o nde bhʉ́ dabɨlɨ bini ne uo? ’Kpɨ́ bini de! Nedhɨnga ɨnde lɨ ’ko ɵlɵ-o nde nga bha lɨe bhʉ́ dabɨlɨ bini ne uo-o, u tɨ da natse nazʉ ’he de. ");
INSERT INTO mdm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Engʉ́ bini, ekpɨ́ akólo makolo nedhɨnga ɨnde lɨ u aꞌé ’ko ɵlɵ-o lɨe bhʉ́ ká uo-o, ekpɨ́ ango-o, u tsia tsé nazʉ ’he. ");
INSERT INTO mdm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kpála bini tɨ da naleke bongo na didili ne pála bongo na mbɨa de. Ɨ dʉ mo-o de-e, pála bongo bhe na mbɨa sídha té bhe na didili-o, lɨ eka ango-o kólo ngbéngbé ane bhe na kalanʉ-o mane. ");
INSERT INTO mdm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","La di-e, kpála bini túko pandɨ na mbɨa bhʉ́ odidili dhudhu na kó ’nʉ de. Ɨ dʉ mo-o de-e, pandɨ-e ʉ́pa bhʉsʉ odhudhu-o. Anɨ tsia néke pandɨ-e ne odhudhu-o hana. Engʉ́ bini, pandɨ na mbɨa ayo bha ne odhúdhú na mbɨa.» ");
INSERT INTO mdm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ekpɨ́ bini naguo gba omaYuda-a , Yesu ne omʉkpata gba e adʉ akodho ’kpɨ́ bhʉ́ ngu ’zʉ ɨnde u aꞌɨ e me ngano. Omʉkpata gba anɨ-e aholo akodho ’ndjɨ ’ndjɨ, u atsia adʉ nazʉzʉ. ");
INSERT INTO mdm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","OmʉFalisai apa pɨ Yesu me: «Tsia nga engʉ́ u ngamene e lɨ ’kpɨ́ naguo-o. Lɨ́lɨ gba nɨ́-e zɨba namene kulu bhʉ́ ’kpɨ́ naguo de.» ");
INSERT INTO mdm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Anɨ atsia gie pɨ uo me: «Yi tanga nga engʉ́ ɨnde lɨ Davidi amene nanɨ e dɨ? Ekpɨ́ bini, ngaanɨ ne okpála ɨnde adʉ adhʉkʉ bhʉ́ dabɨlɨ bini ne anɨ-e adje gʉmʉ. ");
INSERT INTO mdm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abhomʉ-o, anɨ alɨ bhʉ́ ’tɨ Ebhe, anɨ atsia azʉ mapa ɨnde u aꞌo e pɨ Ebhe-o (a adʉ me Abɨatali nde ne bhele kpála gba odimandɵ lɨ nedhɨnga bhomʉ-o ngae). La-a, lɨ́lɨ gba nɨ́ azɨba me odimandɵ zʉzʉ bha ngao kpi o kpi. Engʉ́ bini, Davidi azʉ, anɨ atsia aha di pɨ okpála ɨnde adʉ adhʉkʉ bhʉ́ dabɨlɨ bini ne anɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu atsia apa matá pɨ uo me: «U aꞌo ekpɨ́ naguo pɨ kpála-kʉtɨ. Engʉ́ la bini, u bho kpála-kʉtɨ pɨ ekpɨ́ naguo de. ");
INSERT INTO mdm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaka-a, Ndɨlɨ gba kpála di ne Ngámá pɨ́ ’ndjɨ ekpɨ́ naguo.» ");
INSERT INTO mdm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ekpɨ́ koko, Yesu alɨ matá bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-o . Bhʉ́ ’tɨ oo, kpála bini ɨnde lɨ ’kpa e andɨa adʉ oo. ");
INSERT INTO mdm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","OmʉFalisai adʉ akʉnda naꞌo ’ngʉ́ pɨ́ Yesu. Kaka-a, u aholo atsia anɨ ne kpéke djila, atɨgala anɨ kóbho kpála ɨnde adʉ me ’kpa e nde andɨa-a lɨ ’kpɨ́ naguo . ");
INSERT INTO mdm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Abhomʉ-o, Yesu atsia apa pɨ kpála ango-o me: «Yie bhʉ́lá, amba mʉ lʉ sɨ bhʉ́ ká djila ndʉ okpála hana.» ");
INSERT INTO mdm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pɨpɨta-a, Yesu atsia ayi okpála ɨnde adʉ oo me: «Lɨ ’kpɨ́ naguo gba omaYuda-a, lɨ́lɨ gba nɨ́-e azɨba bhedho: U mene bádha ’ngʉ́ ne me u mene siti ’ngʉ́? U kobho kpála ne me u bhɵlɵ kpála?» Engʉ́ bini, u tsia dʉ ne engʉ́ na gigie de! ");
INSERT INTO mdm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Anɨ aholo atsia ndʉ uo hana bini ne bini na gʉ́gʉ́. Bua anɨ ake, ka kpéke ’ndjɨ gba uo-o. Abhomʉ-o, anɨ atsia apa pɨ kpála lɨ ’kpa e andɨa me: «Gbele ’kpa mʉ.» Kpála ango-o agbele ’kpa e, ’kpa anɨ atsia akolo matá ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lɨ omʉFalisai aze lɨe oo, u atsia apo kolo bhʉ́la o ne omaha Elode . U atsia adje lɨo me ogɨlɨ kpadjɨ nabhɵlɵ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pɨpɨta-a, Yesu ne omʉkpata gba e agbida lɨngo ekpɵ na Galilaya. Kambɨ okpála atsia akpata anɨ. Okpála ango-o ayie nanɨ bhʉ́ ndu doto na Galilaya ne Yudaya, ");
INSERT INTO mdm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","bhʉ́ gʉdhʉ na Yelusalema, bhʉ́ ndu doto na Idumé, bhʉ́ ndu doto ɨnde ayi ’ngu na Djʉlʉdanɨ, bhʉ́ odoto na Tile ne Sidona. Kambɨ okpála ango-o adje nanɨ ngali na ongʉ́ lɨ Yesu adʉ amene e lɨe, u atsia ago abhaka anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu atsia aha lɨ́lɨ pɨ omʉkpata gba e me u ꞌo zabʉ pɨ nɨ bini masɨkpe, amba ɨ dʉ me okpála bhomʉ-o nde asʉlʉ nɨ má wakaka-a, nɨ de ꞌʉ bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Padhá de, anga anɨ akobho nanɨ okpála bhelé. Kaka-a, okpála na kuo adʉ agbene lɨo me o bu ’kpa o lɨ anɨ amba o kobho. ");
INSERT INTO mdm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lɨ okpála ɨnde lɨ osisiti bua adʉ ato mbolo lɨ o adʉ au anɨ lɨe, u adʉ ago atuko ne ꞌue bhʉ́ li ’dhʉ anɨ me: «Mʉ ne Ndɨlɨ gba Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Engʉ́ bini, Yesu adʉ apa pɨ uo na gʉ́gʉ́ me u ambámba ta nɨ pɨ okpála koko de. ");
INSERT INTO mdm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pɨpɨta-a, Yesu aꞌʉ apɨ́ ’ta. Anɨ atsia aꞌɨ obhende anɨ adʉ akʉnda o-o. U atsia ago abhaka anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Abhomʉ-o, bhʉ́ ká okpála ango-o, anɨ alo okpála ndjɨkpa ne ká bhisi. Anɨ agisila ’lɨ uo me obhʉlʉ titima . Anɨ aꞌo uo ngʉbula me nɨ dʉ adʉ́ ne uo bhʉ́ dabɨlɨ bini, la di ngʉbula me nɨ tima uo ngʉ́ nakpokpo Ngali gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Anɨ aha di pɨ uo angu ngʉ́ napandja osisiti bua bhʉ́ okpála. ");
INSERT INTO mdm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A ɨnde-e obhe ndjɨkpa ne ká bhisi ɨnde anɨ alo nanɨ o-o: Simo (ɨnde lɨ Yesu agisila nanɨ ’lɨ e me «Piele»), ");
INSERT INTO mdm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Djakɨ ne ndai e Djaa (ongɨsɨ gba Djebedayo ɨnde lɨ Yesu aha nanɨ ꞌɨlɨ koko pɨ o me «Boaneledjesɨ», a akʉnda napa me «ongɨsɨ gba mʉgbálá»), ");
INSERT INTO mdm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","a la di-e, Andɨlɨ, Filipo, Batelemi, Matié, Tʉma, Djakɨ (ndala Alafayo), Tade, Simo (kpála nakʉnda doto gba e naali), ");
INSERT INTO mdm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","di ne Yuda Ɨsɨkaliote, kpála ɨnde apʉ́ Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Abhomʉ-o, Yesu agie matá lɨe lɨ bɨlɨ anɨ adʉ nadʉ lɨ e-o, bhiti okpála atsia ago apo matá bhʉ́la o de anɨ. Kaka-a, Yesu ne omʉkpata gba e sia belegʉ nedhɨnga ngʉ́ nazʉ ’he de. ");
INSERT INTO mdm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lɨ okpála na piga gba anɨ adje ngali ango-o lɨe, u akɵ kpadjɨ ngʉ́ nanʉ aholo anɨ. Padhá de, anga u adʉ apa me: «Yesu akolo bhʉlʉ pele!» ");
INSERT INTO mdm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abhomʉ-o, omʉsuno na lɨ́lɨ gba Moidje ɨnde ayie nanɨ bhʉ́ Yelusalema adʉ apa me: «A bhʉ́ kpála bhomʉ-o ne Beledjebula!» U adʉ di apa matá me: «A ngaha angu nato holo bhʉ́ ’dhʉ osisiti bua pɨ anɨ ne ngámá gba osisiti bua.» ");
INSERT INTO mdm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Abhomʉ-o, Yesu atsia aꞌɨ omʉsuno bhomʉ-o. Anɨ atsia apa pɨ uo bhʉ́ gbitaku me: «Lele pɨ Satana tɨ da nato holo lɨe bhʉ́ ’dhʉ Satana-a? ");
INSERT INTO mdm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɨ dʉ me okpála gba ngámá bini nde ngagʉ gbele sʉnda o, kʉtɨ ango-o lʉ́-ʉ de. ");
INSERT INTO mdm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɨ dʉ me okpála na piga bini nde ngagʉ gbele sʉnda o, piga ango-o lʉ́-ʉ de. ");
INSERT INTO mdm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ɨ dʉ me Satana nde ngagʉ lɨe ngae makpe, naʉ gba anɨ-e gbógbo bhʉsʉ e. Anɨ tɨ da nabhue de, lɨ ’ngʉ́ gba anɨ-e ndjía. ");
INSERT INTO mdm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kpála tɨ da nalɨ bhʉ́ ’tɨ gba kpéke bhoko bini de, anɨ tsia bhá ndʉ ’he gba anɨ-e me anɨ nde gbigbite ngaɨza kpéke bhoko bhomʉ-o kalanʉ de-e de. Engʉ́ bini, anɨ de agbigbite anɨ agbigbite-e, anɨ tsia bhá ndʉ ’he gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ma apa pɨ yi na paká me, u tɨ́ da nambu lɨ osisiti ’ngʉ́ gba okpála di ne osobho ɨnde u ngasobho Ebhe ne e hana. ");
INSERT INTO mdm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Engʉ́ la bini, lɨ kpála sobho Bu Bhobua-a , Ebhe ꞌé siti ’ngʉ́ gba kpála ango-o de. Padhá de, anga anɨ amene bhomʉ-o siti ’ngʉ́ na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu adʉ apa nanɨ pɨ uo mo-o, anga u adʉ apa me: ‹A bhʉ́ anɨ ne siti bua.›» ");
INSERT INTO mdm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pɨpɨta-a, ’hi Yesu ne ondaise anɨ akolo lɨ bɨlɨ anɨ adʉ asuno lɨ e-o. U alʉlʉ akilidjo, u atsia atima kpála bini ngʉ́ naꞌɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kambɨ okpála adʉlʉ nanɨ de anɨ. U atsia apa pɨ anɨ me: «Tsia nga, ’hi mʉ di ne ondaise mʉ alʉlʉ akilidjo, u ngagɨlɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Anɨ atsia gie pɨ uo me: «’Hi ma ne ondaise ma ngao dho?» ");
INSERT INTO mdm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Abhomʉ-o, anɨ atsia bhiti okpála asa dengo anɨ ngbalina-o. Anɨ atsia apa me: «Yi tsitsia nga, ’hi ma ne ondaise ma ngao ɨnde! ");
INSERT INTO mdm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ndʉ kpála hana ɨnde ngamene engʉ́ lɨ Ebhe akʉnda e, kpála ango-o, a ko ndai ma na bhobhoko, a ko ndai ma na ɵɵlɵ, a ko la di ’hi ma.» ");
INSERT INTO mdm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Lɨ Yesu akolo lɨe lɨngo ekpɵ na Galilaya-a, anɨ aholo matá nasuno. Abhomʉ-o, bhiti okpála na bhibhiti ago apo bhʉ́la o de anɨ. Kaka-a, anɨ atsia aꞌʉ bhʉ́ zabʉ bini, anɨ anʉ adʉ bhʉ́bhʉ́ apɨ́ ’ngu. Bhiti okpála-a atsia adʉ naao apigo dengo ’ngu-o. ");
INSERT INTO mdm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu atsia adʉ asuno ongʉ́ pɨ uo bhelé bhʉ́ ogbitaku. Anɨ adʉ apa bhʉ́ nasuno gba e me: ");
INSERT INTO mdm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Yi djedje nga! Ekpɨ́ bini, kpála bini anʉ abhiye gba e ngʉ́ nalu ’zʉ. ");
INSERT INTO mdm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nedhɨnga anɨ adʉ alulu lɨe, tété abala lɨngo kpadjɨ. Odhu ago, u atsia azʉ hana má kpɵkɵbhɵ! ");
INSERT INTO mdm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Koko atsia abala lɨ bɨlɨ na teme, doto dʉ lɨ bɨlɨ ango-o bhelé de. Kaka-a, a atsia akɵ má gala, anga doto dʉ sasa bhelé de. ");
INSERT INTO mdm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Engʉ́ bini, lɨ ela akolo lɨe kpekpeke-e, ezʉ ango-o atsia atsulu ka ndɨbhɨlɨ sisie-o. Abhomʉ-o, a atsia aꞌʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Té koko abala lɨ bɨlɨ na oeti, oeti atsia abhele, a anguvo ezʉ-o. Kaka-a, a atsia lɨ lɨ́lɨ́ de. ");
INSERT INTO mdm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lɨ́ nguwa koko atsia abala lɨ bɨlɨ na dobho, a akɵ, a abhele a atsia alɨ lɨ́lɨ́. Lɨ́ nguwa bini alɨ lɨ́lɨ́ ndjɨkpa bata. Koko alɨ lɨ́lɨ́ ndjɨkpa madhɨa. Koko alɨ lɨ́lɨ́ kámá bini.» ");
INSERT INTO mdm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu atsia abu tata me: «Ɨ dʉ me a nde lɨ kpála ne djedje ngʉ́ nadje ’kpɨ́-e, anɨ de dje!» ");
INSERT INTO mdm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pɨpɨta-a, lɨ Yesu atigala bha lɨe ne omʉkpata ndjɨkpa ne ká bhisi di ne okpála ɨnde adʉ nadʉ de anɨ tɨtɨ o-o, u aholo nayi anɨ pɨndjɨ ogbitaku-o. ");
INSERT INTO mdm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Anɨ atsia agie pɨ uo me: «Ngayi-e, Naʉ gba Ebhe ambamba ta e pɨ yi ambamba. La-a, pɨ okpála bhende kilidjo-o, ma bha ngapapa pɨ uo bhʉ́ ogbitaku. ");
INSERT INTO mdm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","A ko ngʉbula me engʉ́ ɨnde bhʉ́ Bhuku gba Ebhe-e mene lɨe. Engʉ́ ɨnde me: ‹Abana u dʉ atsia ’kpɨ́-e, u ú ’kpɨ́ de, abana u dʉ adje ’kpɨ́-e, u kɵ́ mbolimboli de. Kaka-a, u djí bua o de, Ebhe ꞌé di siti ’ngʉ́ gba uo-o de.›» ");
INSERT INTO mdm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pɨpɨta-a, Yesu atsia apa pɨ uo me: «Yi kɵ mboli gbitaku bhomʉ-o de! La mbɨa ɨnde-e, yi akɵ́ mboli ndʉ ogbitaku koko hana lele pɨ? ");
INSERT INTO mdm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bhʉlʉ nalu nguwa ɨnde ma de apa ’ngʉ́ e ngalu eli gba Ebhe . ");
INSERT INTO mdm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Okpála koko maka ngo ’hi kpadjɨ lɨ bɨlɨ ɨnde lɨ eli gba Ebhe-e alu lɨe lɨ e-o. Nedhɨnga u adje eli-e lɨe, kolo ma ’li ma me-e, Satana gó, anɨ tsia ꞌé eli ɨnde alu lɨe bhʉ́ uo-o. ");
INSERT INTO mdm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Okpála koko ngasia eli-e bhʉ́ doto na ká teme. Nedhɨnga u ngadje eli-e lɨe, a bhúe de u ngasisia ne djalɨ hana. ");
INSERT INTO mdm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Engʉ́ bini, u ꞌo de me eli bhomʉ-o sɨ kʉtɨ e alɨ bua o-o de. U ngaꞌo ’to o tété bha mbo ngʉ́ nedhɨnga bedɨ. Kaka-a, nedhɨnga lɨ okpekpeke da ’ngʉ́ ngago lɨe, ɨ dʉ di-e mbolo ka ’li Ebhe-e, u ngaꞌo ká nabhuka gba o kolo má gala! ");
INSERT INTO mdm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Matá-a, okoko ngasia eli-e bhʉ́ ká oeti. A bhomʉ-o, obhende ɨ di me zɨba eli ɨnde u ngadje e-o. ");
INSERT INTO mdm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Engʉ́ bini, u ngabhundja naali pɨndjɨ ongʉ́ na doto ɨnde. Tɨatɨa ngapipite uo. La di-e, ndʉ ogʉmʉ ’ngʉ́ ngangá ngalɨ bhʉ́ uo, ɨ tsia ngúvo eli-o. Kaka-a, eli-e zú nguwa de. ");
INSERT INTO mdm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngʉ́ nabu tata-a, okoko ngasia eli-e bhʉ́ doto na dobho. U ngadje eli-o, u ngasisia, u la di ngalɨ lɨ́lɨ́. Bhʉ́ okoko-o, lɨ́lɨ́ bini ngalɨ lɨ́lɨ́ ndjɨkpa bata, bhʉ́ okoko ndjɨkpa madhɨa, bhʉ́ okoko kámá bini.» ");
INSERT INTO mdm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pɨpɨta-a, Yesu atsia apa pɨ uo me: «U dhedhedhe eke ngʉbula naꞌoꞌo asa lʉsa ɨ dʉ di-e asa mako uu? U dhedhedhe mangbo ngʉbula naꞌoꞌo pɨ́ misa. ");
INSERT INTO mdm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Padhá de, anga ehe bini ade ɨnde adʉ́dʉ bhʉ́ pepe, ɨnde ɨ kóto bhʉ́ mbasʉ de-e ade. La di-e, ndʉ ’he hana ɨnde awo lɨe mawo ɨnde lɨ kpála u e de-e ade. ");
INSERT INTO mdm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɨ dʉ me a nde lɨ kpála ne djedje ngʉ́ nadje ’kpɨ́-e, anɨ de dje!» ");
INSERT INTO mdm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu atsia apa pɨ uo me: «Yi ꞌo ’to yi lɨ ’ngʉ́ ma ngapa e ndjɨndjɨ, anga yi dje ndjɨndjɨ-e, yi kɵ́ bhadi mboli engʉ́ bhelé. ");
INSERT INTO mdm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Padhá de, anga kpála ɨnde ngakɵ mboli engʉ́ ndjɨndjɨ-e, Ebhe ambámba bhadi ta engʉ́ bhelé pɨ anɨ. Engʉ́ bini, kpála ɨnde ɨ kɵ mboli engʉ́ ndjɨndjɨ de-e, u aꞌé belegʉ mboye bhende ka anɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu atsia apa matá pɨ uo me: «Yi tsia nga ehe ɨnde lɨ Naʉ gba Ebhe-e nde maka e ko. A maka kpála ɨnde adji abhiye ngʉ́ nalu nguwa. ");
INSERT INTO mdm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ngbɨkpɨ ne sukpe, abana anɨ dʉ bha tɨla, ne me anɨ dʉ lɨ zʉkʉ, lɨ́ nguwa dʉ bha me a nde ngaze, a nde la di ngabhele. Anɨ mbɨla la de me a ngamene lɨe lele pɨ-ie de. ");
INSERT INTO mdm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Doto ne tɨtɨ e ngakɵ ngaɨza mʉsana. Pɨpɨta-a, ɨ bɨ́ ’bhɨ. Lɨ soso-o, ɨ bá lɨ́lɨ́ ɨnde ato na paká paká. ");
INSERT INTO mdm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lɨ lɨ́lɨ́ mbe-e, kpála alu-o tsia kodho anga a ko nedhɨnga naꞌe nguwa abhiye.» ");
INSERT INTO mdm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu atsia apa matá me: «Nɨ́ tɨ da nakpo ’ndjɨ Naʉ gba Ebhe-e ne nɨ, ne me nɨ́ tɨ da nasusuno lɨ mangua gbitaku dho? ");
INSERT INTO mdm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A maka lɨ́ ’lá u aꞌɨ e me mʉtadi. Lɨ u lu anɨ bhʉ́ doto-o, a ko lɨ́ nguwa bhe na yeye ane mane bhʉ́ ká olɨ nguwa hana na pɨ́la doto. ");
INSERT INTO mdm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Engʉ́ bini, nedhɨnga u alu anɨ lɨe, a ngabhele, ɨ tsia kólo ngbéngbé ane ondula koko hana. Lɨ oyáyá-a kólo ngbengbengbe da napa me odhu tɨ da nayiki otɨ gba o bhʉ́ bhiti kpákpá-o.» ");
INSERT INTO mdm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Abhomʉ-o, Yesu adʉ asuno bhʉ́ ogbitaku bhelé maka obhende bhomʉ. Anɨ adʉ akpokpo ’li Ebhe pɨ uo lɨ lele bhende lɨ okpála adʉ adje anɨ-e, tɨ da nakɵ mbolimboli lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Anɨ dʉ nanɨ agama ’ngʉ́ pɨ uo padhá de mandɨ gbitaku. Engʉ́ bini, nedhɨnga anɨ adʉ nadʉ lɨe ne omʉkpata gba e tɨtɨ o, anɨ atsia adʉ ambamba tata-a pɨ uo hana. ");
INSERT INTO mdm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bha tagolo bhʉ́ ekpɨ́ bhomʉ-o, Yesu atsia apa pɨ omʉkpata gba e me: «Nɨ́ gulu ’ngu ayi ’ngu.» ");
INSERT INTO mdm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Abhomʉ-o, u aꞌo ká bhiti okpála-o, u anʉ ne Yesu bhʉ́ zabʉ anɨ adʉ bhʉ́ e-o. Ozabʉ koko adʉ di bhʉ́ dabɨlɨ bini ne uo. ");
INSERT INTO mdm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kolo me-e, kpéke anvi na gipi aholo ape. Ongbo ’ngu-o adʉ atuko bhʉ́ zabʉ masɨkpe de me zabʉ-o bedhe ne engu. ");
INSERT INTO mdm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","La ngaanɨ, Yesu-o, anɨ adʉ me anɨ nde ala atabhu zabʉ-o. Anɨ aꞌo ’ndjɨ e pɨ́ kuse. Omʉkpata gba anɨ anʉ azʉkʉ anɨ ne napa pɨ anɨ me: «Mʉsuno, nɨ́ adji amú. A zɨ ’ngʉ́ bhʉ́ djila mʉ dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Anɨ azʉkʉ lɨe, anɨ ambe bhʉ́ ’ndjɨ anvi-o. Anɨ atsia apa pɨ ngbo ’ngu-o me: «Gba ’bhɵ mʉ! Ndjili má bulu!» Anvi aꞌo nape, engu atsia akolo guguo má bi! ");
INSERT INTO mdm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu atsia apa pɨ omʉkpata gba e me: «Yi ne tsʉlʉ mo-o ka nɨ? Nabhuka nga bhʉ́ yi adɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Engʉ́ bini, u adʉ adje tsʉlʉ naali. U atsia adʉ apa sʉnda o me: «Ae mangua kpála dho ɨ ngadje belegʉ e ne anvi di ne engu-o?» ");
INSERT INTO mdm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pɨpɨta-a, Yesu ne omʉkpata gba e akolo ayi ’ngu, bhʉ́ ndu doto gba okpála na Gelasa. ");
INSERT INTO mdm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lɨ Yesu akoto lɨe bhʉ́ zabʉ-o, kolo me-e, kpála bini akoto lɨ bɨlɨ na olata, anɨ atsia ago abhaka anɨ. Kpála ango-o, siti bua adʉ nadʉ bhʉ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kpála ango-o adʉ nadʉ bhʉ́ ká olata. Kpála bini tɨ nanɨ da nagbite anɨ de, belegʉ de ne gbɨndjɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Padhá de, anga bhʉtsibhʉtsi, u adʉ agbite ’dhʉ anɨ di ne ’kpa anɨ ne ogbɨndjɨlɨ. Engʉ́ bini, anɨ adʉ akokodho ogbɨndjɨlɨ bhomʉ-o má dhu dhu dhu! Kpála bini ko nanɨ angu e pɨ́ anɨ de. ");
INSERT INTO mdm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ndʉ ’kpɨ́ hana sukpe ne ngbɨkpɨ anɨ adʉ bha nasʉsʉla bhʉ́ ká olata di ne bhʉ́ ká oeta. Anɨ atsia adʉ natsotsolo eka lɨ kʉte e ngae makpe ne oteme. ");
INSERT INTO mdm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Anɨ au Yesu lɨe me anɨ nde nga bha tsutsu-o, anɨ ago ne holo, anɨ atʉtʉ lɨpʉkʉ e kuto kala anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Anɨ atsia asʉla kpekpeke me: «Yesu, Ndɨlɨ gba Ebhe Apɨ́ ’Kpɨ́, mo okʉnda namene ngʉ́ ma pɨ? Ma akikiliki lɨma pɨ mʉ! Ne ’lɨ Ebhe, mo otó mbolo lɨ ma de.» ");
INSERT INTO mdm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Anɨ asʉla mo-o, anga Yesu apa nanɨ pɨ siti bua ango-o me anɨ koto bhʉ́ kpála bhomʉ-o makoto!) ");
INSERT INTO mdm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Abhomʉ-o, Yesu ayi anɨ me: «A ’lɨ mʉ pɨ?» Anɨ agie pɨ anɨ me: «A ’lɨ ma me Bhelé, anga ya bhibhiti.» ");
INSERT INTO mdm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Abhomʉ-o, osisiti bua-a akikiliki lɨo pɨ Yesu naali me anɨ agbe o bhʉ́ ndu doto bhomʉ-o de. ");
INSERT INTO mdm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A abhaka me ’ngbé piga opame nde ngazʉ ’he lɨ pabu ’ta oo. ");
INSERT INTO mdm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Osisiti bua atsia akikiliki lɨo pɨ Yesu me: «Tima ya bhʉ́ ká opame ɨnde, amba ya lɨ bhʉ́ uo.» ");
INSERT INTO mdm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Abhomʉ-o, Yesu atsia azɨba pɨ uo. U aze bhʉ́ kpála ango-o, u atsia alɨ bhʉ́ opame-o. Piga opame bhomʉ-o libhomu akɵ eta ne holo, u anʉ atuko bhʉ́ ekpɵ-o, u atsia amu ndʉ o hana. U adʉ masɨkpe de kutu bhisi. ");
INSERT INTO mdm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abhomʉ-o, omʉlila gba opame atsi naao ne holo. U anʉ akpokpo ’ngʉ́ ango-o pɨ okpála abhʉ́ gʉdhʉ ne bhʉ́ okʉtɨ na ngongo. Okpála atsia ago ngʉ́ nau engʉ́ ɨnde akodho ’kpɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","U ago de Yesu, u au kpála ɨnde lɨ bhiti osisiti bua adʉ nadʉ bhʉ́ e-o: anɨ adʉ me anɨ nde adʉ kuto, anɨ nde ato bongo lɨ e, anɨ nde ngabhundja ’ngʉ́ ndjɨndjɨ. Abhomʉ-o, u atsia adje tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Okpála bhende au engʉ́ ango-o, atsia akpokpo engʉ́ ɨnde akolo lɨ kpála bhomʉ-o, di ne lɨ opame-e pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Abhomʉ-o, u atsia aholo nakikiliki lɨo pɨ Yesu me anɨ yie bhʉ́ ndu doto gba o yiyie. ");
INSERT INTO mdm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lɨ Yesu adʉ aꞌʉ lɨe bhʉ́ zabʉ-o, kpála lɨ siti bua adʉ ɨgɨnɨ bhʉ́ e, adʉ akikiliki lɨe pɨ anɨ me nɨ dʉ bha ɨbili ne anɨ bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu tsia zɨba pɨ anɨ mo-o de. Engʉ́ bini, anɨ apa pɨ anɨ me: «Gie lɨmʉ agba mʉ, bhʉ́ ká okpála na piga gba mʉ-o, amba mʉ kpokpo ndʉ ’ngʉ́ hana lɨ Ngámá amene e pɨ mʉ-o maka anɨ adje ndjinga mʉ lɨe pɨ uo.» ");
INSERT INTO mdm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Abhomʉ-o, kpála ango-o atapa. Anɨ atsia aholo nakpokpo ndʉ ’ngʉ́ hana lɨ Yesu amene e pɨ anɨ-e bhʉ́ ndu doto na Ogʉdhʉ Ndjɨkpa. Okpála ɨnde adʉ adje anɨ-e, ndʉ uo hana adʉ angamba naali. ");
INSERT INTO mdm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lɨ Yesu agie matá lɨe lɨe ayi ekpɵ-o, kambɨ okpála abedhe de anɨ bedhe lɨngo ekpɵ-o. ");
INSERT INTO mdm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Abhomʉ-o, sʉka ongámásɨ na etɨ nadje lɨ́lɨ gba Moidje ago. A dʉ lɨ anɨ me Yailo. Anɨ au Yesu lɨe, anɨ atɨ bhʉ́ li ’dhʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Anɨ atsia akikiliki lɨe pɨ anɨ ne kekele ne napa me: «Ndɨlɨ na ɵɵlɵ gba ma-a masɨkpe de nakpi. Gogo, nʉ ꞌo ’kpa mʉ pɨ́ ’ndjɨ anɨ ngʉbula me anɨ kobho, amba anɨ akpí-i de.» ");
INSERT INTO mdm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Abhomʉ-o, Yesu anʉ ne anɨ bhʉ́ dabɨlɨ bini. Bhiti okpála na bhibhiti naali adʉ akpata anɨ. U aholo nasʉlʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Abhomʉ-o, ɵlɵ bini ɨnde asɨ ne kuo naze ka ngʉte kalanga ndjɨkpa ne ká bhisi-e adʉ oo. ");
INSERT INTO mdm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bhiti omʉtɨa ɨnde atɨa nanɨ anɨ-e, aha nanɨ lɨkabhu pɨ anɨ naali. Padhá de, anga anɨ andjia nanɨ tɨa nganda e hana má kpɵkɵbhɵ, anɨ kobho de! Engʉ́ bini, kuo gba anɨ-e adʉ mangbo nakolo sisiti naali. ");
INSERT INTO mdm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Anɨ adje ngali gba Yesu-o lɨe, abhomʉ-o, anɨ ago bhʉ́ ká bhiti okpála ne akele anɨ, anɨ atsia abu ’kpa e lɨ bongo gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Padhá de, anga anɨ adʉ apa lɨ bua e me: «Ɨ dʉ me ma nde abu nga bha bini ’kpa ma lɨ bongo gba anɨ-e, ma kóbho.» ");
INSERT INTO mdm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Abhomʉ-o, kolo ma ’li ma me-e, ngʉte-e akodho má ká! Anɨ atsia ambɨla bhʉ́ e me Yesu akobho nɨ ne kuo gba nɨ-e akobho. ");
INSERT INTO mdm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bha lɨ nedhɨnga bhomʉ-o, Yesu ambɨla bhʉ́ e makpe me angu nakobho kpála akoto bhʉ́ nɨ. Abhomʉ-o, anɨ atsia tsia ’kpɨ́ ne lɨngo e hana, anɨ atsia ayi me: «A abu ’kpa e lɨ bongo gba ma-a da?» ");
INSERT INTO mdm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abhomʉ-o, omʉkpata gba anɨ-e agie pɨ anɨ me: «Mʉ ngau hana me bhiti okpála asʉlʉ mʉ má wakaka! Lele pɨ mʉ tɨ da nayi lɨe me: ‹Abu ’kpa e lɨ ma da-ie?›» ");
INSERT INTO mdm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Engʉ́ bini, Yesu adʉ bha natsitsia ’kpɨ́ lɨngo e ngʉ́ nau kpála ɨnde amene engʉ́ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɵlɵ ango-o adʉ adje tsʉlʉ, anɨ aholo nagʉkʉ. Padhá de, anga anɨ ambɨla nanɨ engʉ́ ɨnde akolo lɨ anɨ-e ndjɨndjɨ. Anɨ ago atɨ bhʉ́ li ’dhʉ Yesu, anɨ atsia apa ndʉ ’ngʉ́ hana na kʉkʉlʉ pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Ndɨ ɵlɵ-e, nabhuka gba mʉ-o akobho mʉ akobho, nʉ ne guo ’ngʉ́ . Mo okobho ne kuo gba mʉ-o akobho.» ");
INSERT INTO mdm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ndjia nga nagama ’ngʉ́ de, okpála ɨnde ayie agba Yailo akolo. U atsia apa pɨ anɨ me: «Ndɨlɨ gba mʉ-o akpi. Mo ondála matá Mʉsuno de.» ");
INSERT INTO mdm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Engʉ́ bini, Yesu ꞌo ’to e lɨ ’ngʉ́ u adʉ apa e de. Anɨ apa bha pɨ Yailo me: «Mo odjé tsʉlʉ de, dʉ bha ne nabhuka.» ");
INSERT INTO mdm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu tsia zɨba pɨ kpála koko nanʉ ne o de. U anʉ bha bhʉ́ dabɨlɨ bini ne Piele ne Djakɨ, a la di-e Djaa ndai Djakɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","U akolo akʉtɨ gba Yailo. Yesu au me okpála má dja dja dja! U adʉ aku ’gbá naali, u atsia adʉ di atʉ ꞌue. ");
INSERT INTO mdm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Abhomʉ-o, anɨ alɨ abhʉ́ ’tɨ, anɨ atsia apa pɨ uo me: «Yi má dja dja dja di ne naku ’gbá naali me-e ka nɨ? Ndɨlɨ-e kpi de, engʉ́ bini, anɨ tɨla.» ");
INSERT INTO mdm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Abhomʉ-o, u aholo amʉ anɨ. Engʉ́ bini, ngaanɨ-e, anɨ apandja ndʉ okpála hana kilidjo. Anɨ aha bha bini ’dyɨ ndɨlɨ-e ne ’hi ndɨlɨ-o, la di ne omʉkpata gba e bata-o. Abhomʉ-o, u atsia alɨ ne uo abhʉ́ tɨna ’tɨ ɨnde lɨ ndɨlɨ-e adʉ bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Anɨ aha ’kpa ndɨlɨ-o, anɨ atsia apa pɨ anɨ me: «Talita kumi!» (Tata-a me: «Ndɨ ɵlɵ-e, ma apa pɨ mʉ me yie bhʉ́lá!») ");
INSERT INTO mdm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ndɨ ɵlɵ ango-o (ɨnde adʉ nanɨ ne kalanga ndjɨkpa ne ká bhisi ayie kolo bhʉ́lá má gala! Anɨ atsia aholo nadhʉkʉ). Bhʉ́ nedhɨnga bhomʉ-o, bhʉ́ ’bhɵ okpála akpina má dɨ! ");
INSERT INTO mdm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Abhomʉ-o, Yesu agbele ’dje uo kpekpeke me u apá engʉ́ ango-o pɨ kpála belegʉ de bini. Pɨpɨta-a, anɨ atsia apa pɨ uo me u ha ezʉ pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ayie lɨ bɨlɨ bhomʉ-o, anɨ atsia gie lɨe bhʉ́ Nadjaleta, kʉtɨ ɨnde anɨ abhele bhʉ́ e-o. Omʉkpata gba anɨ-e atsia anʉ di bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A akolo lɨe bhʉ́ ’kpɨ́ naguo gba omaYuda-a , anɨ aholo nasuno bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-o . Abhomʉ-o, bhiti okpála ɨnde adʉ nadje anɨ-e, adʉ angamba naali. U adʉ apa me: «A asuno ongʉ́ ɨnde-e pɨ anɨ da? Anɨ ayie ne ɨmbɨlangʉ di ne angu namene ongua ongamba ’ngʉ́ ɨnde-e su? ");
INSERT INTO mdm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A ɨnde-e kpála nagolo ndula-a dɨ? A ko ndɨlɨ gba Malɨa dɨ? A ko ndai Djakɨ ne Djodje, ne Djude, la di ne Simo-o dɨ? Ondaise anɨ na olɨsɨlɨsɨ la bhadi bhʉ́ dabɨlɨ bini ne nɨ́ sɨɨ adɨ?» Kaka-a, u atsia ayala nabhuka anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Abhomʉ-o, Yesu atsia apa pɨ uo me: «U mamanga polofeta ne ndʉ bɨlɨ hana. La-a, u mamanga anɨ de-e bha bhʉ́ kʉtɨ ɨnde u azu anɨ bhʉ́ e-o, ne bhʉ́ ká omaha anɨ, ne la di bhʉ́ ká okpála na bhʉ́ ’bu ’tɨ gba anɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ka ndɨ nabhuka gba uo-o, anɨ tɨ nanɨ da namene ongamba ’ngʉ́ oo bhelé de. Anɨ akobho bha obhʉlʉ kuo bedɨ me anɨ nde ngaꞌo ’kpa e pɨ́ uo. ");
INSERT INTO mdm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Abhomʉ-o, anɨ atsia adʉ angamba naali ka ndɨ nabhuka gba uo-o. Pɨpɨta-a, Yesu adholo bhʉ́ ndʉ okʉtɨ na ngongo hana me anɨ nde ngasuno pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Abhomʉ-o, anɨ aꞌɨ omʉkpata ndjɨkpa ne ká bhisi gba e-e ngʉ́ natima uo bhisi bhisi. Kala natima uo-o, anɨ aha angu pɨ uo ngʉ́ napandja osisiti bua bhʉ́ okpála. ");
INSERT INTO mdm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Anɨ atsia aha lɨ́lɨ ɨnde-e pɨ uo me: «Yi ahá ehe bini ngʉ́ enʉ́-o de, yi ha bha ndula bini. Yi abɨ́ ezʉ de, yi ahá gonia de, yi ató falanga lɨ yi bhʉ́ ’tɨ bongo de. ");
INSERT INTO mdm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yi dyɨ malɵkɵ bhʉ́ ’dhʉ yi, engʉ́ bini, yi adyɨ́ bongo na mbulu bhisi de. ");
INSERT INTO mdm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nedhɨnga yi lɨ lɨe bhʉ́ gʉdhʉ bini-e, yi de dʉ bha nasɨ gba koli kpála bini akólo lɨ ’kpɨ́ yi akóto bhʉ́ gʉdhʉ ango-o lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɨ dʉ me okpála na kʉtɨ bini nde sia yi de-e, ɨ dʉ la di me u nde dje yi de-e, yi de yie oo, amba yi pulu ndju doto na kʉtɨ bhomʉ-o lɨ ’dhʉ yi hana. Bhobhomʉ-o asúno ngae me yi abala uo ne ndʉ ’ngʉ́ gba o hana abala.» ");
INSERT INTO mdm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Abhomʉ-o, omʉkpata ndjɨkpa ne ká bhisi-e agbida. U atsia adʉ akpokpo ngali gba Ebhe-e pɨ okpála ne napa pɨ uo me a ayo me u dji bua o. ");
INSERT INTO mdm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","U adʉ apandja osisiti bua bhelé bhʉ́ okpála. U atsia adʉ akobho okpála na kuo bhelé ne napulu ’mʉ pɨ́ ’ndjɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Abhomʉ-o, ’ngbé ngámá Elode Atipasɨ adje engʉ́ gba Yesu-o, anga ’lɨ anɨ ayangba nanɨ ne ndʉ bɨlɨ hana. Okpála adʉ apa me: «Djaa bhʉlʉ nabatisa okpála azuku! Kaka-a, a bhʉ́ anɨ ne angu namene ongamba ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Okpála koko adʉ apa naao me: «A ko polofeta Elɨya.» Do okoko me: «A ko polofeta koko maka sʉka obhende na kalanʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lɨ Elode adje engʉ́ gba Yesu lɨe-e, anɨ atsia apa me: «A ko Djaa bhʉlʉ nabatisa okpála! Ma ha nanɨ lɨ́lɨ ngama makpe me u kodho ngʉlʉ anɨ. La-a, anɨ azuku bhomʉ-o ngae!» ");
INSERT INTO mdm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A na paká me Elode atima nanɨ osʉdha me u nʉ holo Djaa bhʉlʉ nabatisa okpála, amba u to anɨ bhʉ́ tɨkpʉ ngʉbula Elodiade. Elodiade nanɨ ne ɵlɵ gba ndai anɨ Filipo. Engʉ́ bini, Elode atsia aha nanɨ anɨ maka ɵlɵ ka e. ");
INSERT INTO mdm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Abhomʉ-o, Djaa adʉ apa pɨ Elode me: «Lɨ́lɨ zɨba pɨ mʉ ngʉ́ naha ɵlɵ gba ndai mʉ-o de.» ");
INSERT INTO mdm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kaka-a, Elodiade adʉ nayala Djaa, anɨ atsia adʉ akʉnda me u bhɵlɵ anɨ. Engʉ́ bini, anɨ tɨ nanɨ da naha lɨ́lɨ de me u bhɵlɵ anɨ mandɨ napa me Elode zɨba. ");
INSERT INTO mdm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","La pɨ Elode, anɨ ambɨla nanɨ lɨe me Djaa ne kpála na ngbingbili di na bubu-o, anɨ adʉ namanga anɨ naali, anɨ atsia adʉ di nalila anɨ. Nedhɨnga lɨ Elode adʉ adje ’li Djaa lɨe, mabhundja gba Elode adʉ angbɨngɨ naali. Engʉ́ bini, anɨ adʉ ne djalɨ naali ngʉ́ nadje anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Abhomʉ-o, lɨ ekpɨ́ u azu Elode akolo lɨe, a adʉ ekpɨ́ na babadha pɨ Elodiade. Elode amene anokomɨa pɨ olubasa gba e, pɨ ongámásɨ na sʉdha, di ne pɨ ongámásɨ na ndu doto na Galilaya hana. ");
INSERT INTO mdm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndɨlɨ ɵlɵ gba Elodiade ango-o ago. Anɨ atsia alɨ bhʉ́ ’tɨ na anokomɨa-o. Anɨ adho ebɨ, a atsia anga lɨ Elode di ne okpála ɨnde anɨ aꞌɨ o bhʉ́ anokomɨa-o. Abhomʉ-o, Elode atsia apa pɨ ndɨlɨ ɵlɵ ango-o me: «Yo ’he ɨnde mʉ nde ne gʉmʉ e ka ma, amba ma ha pɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Anɨ atsia atʉ silika pɨ anɨ me: «Ehe ɨnde mo oyó e ka ma-a, ma há bha pɨ mʉ e, abana ɨ dʉ bha nagbo bhʉsʉ naʉ gba ma ko.» ");
INSERT INTO mdm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Abhomʉ-o, ndɨlɨ ango-o akoto, anɨ anʉ ayi ’hi e me: «Mo okʉnda me ma yo ka ngámá nɨ?» ’Hi anɨ atsia agie pɨ anɨ me: «Yo ’ndjɨ Djaa bhʉlʉ nabatisa okpála ko.» ");
INSERT INTO mdm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anɨ agie lɨe ne holo agba ngámá. Anɨ atsia apa pɨ anɨ me: «Ma akʉnda me ha mʉma mbɨa ɨnde-e, bhʉ́ tsakpa saanɨ, ’ndjɨ Djaa bhʉlʉ nabatisa okpála!» ");
INSERT INTO mdm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Abhomʉ-o, Elode asia lɨkabhu lɨ bua e naali. Engʉ́ bini, anɨ tɨ nanɨ da nayayala de ka silika ɨnde anɨ atʉ e kala okpála ɨnde anɨ aꞌɨ o bhʉ́ anokomɨa-o. ");
INSERT INTO mdm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Abhomʉ-o, Elode atima kolo sʉka omʉlila gba e me anɨ nʉ, amba anɨ go ne ’ndjɨ Djaa bhʉlʉ nabatisa okpála-o. Mʉlila ango-o anʉ, anɨ atsia akodho ngʉlʉ Djaa bhʉlʉ nabatisa okpála bhʉ́ tɨkpʉ-o má tse! ");
INSERT INTO mdm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pɨpɨta-a, anɨ aha ’ndjɨ Djaa-a, anɨ ago ne di bhʉ́ tsakpa saanɨ, anɨ aha pɨ ndɨlɨ ɵlɵ ango-o. Abhomʉ-o, ndɨlɨ ɵlɵ ango-o atsia anʉ aha pɨ ’hi e. ");
INSERT INTO mdm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lɨ omʉkpata gba Djaa adje engʉ́ ango-o lɨe, u ago aha kuo anɨ, u atsia azɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pɨta nagie lɨe ka obhʉlʉ titima ndjɨkpa ne ká bhisi-e bhʉ́ kulu-o, u apo bhʉ́la o de Yesu. U atsia akpokpo ndʉ ’ngʉ́ ɨnde u amene e di ne bhende u asuno e hana pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Do anɨ pɨ uo me: «Yi gógo, nɨ́ nʉ lɨ bɨlɨ ɨnde lɨ kpála nde lɨe ade, amba yi guo nga mbo masudha.» Padhá de, anga okpála ɨnde adʉ nago, di ne obhende adʉ agie lɨo-o, u adʉ bhibhiti naali. Kaka-a, Yesu ne omʉkpata gba e sia belegʉ nedhɨnga ngʉ́ nazʉ ’he de. ");
INSERT INTO mdm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Abhomʉ-o, u aꞌʉꞌʉ bhʉ́ zabʉ-o, u atsia atapa bha ngao kpi o kpi lɨ bɨlɨ lɨ kpála nde lɨ e ade ko. ");
INSERT INTO mdm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Engʉ́ bini, okpála bhelé au maka u adʉ anʉ lɨe hana. U atsia ambɨla me a ko uo. Abhomʉ-o, okpála ayie ne ndʉ ogʉdhʉ bhelé, u agu holo ne ’dhʉ o, u atsia akolo lɨ bɨlɨ ango-o pɨ Yesu ne omʉkpata gba e kalanʉ. ");
INSERT INTO mdm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lɨ Yesu akoto lɨe bhʉ́ zabʉ-o, anɨ au bhiti okpála-o. Anɨ adje ndjinga uo, anga u adʉ maka okandɵlɵ ɨnde lɨ mʉlila nde ka o ade ko. Abhomʉ-o, anɨ atsia aholo nasuno engʉ́ bhelé pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A akolo lɨe masɨkpe de nabi ka ekpɨ́-e, omʉkpata gba anɨ-e adyudyo lɨo de anɨ. U atsia apa pɨ anɨ me: «Ekpɨ́-e ngabi, a la di-e mili bɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ha kpadjɨ pɨ okpála ɨnde, amba u nʉ kala ezʉ nazʉ mazʉ pɨ o lɨ ongangba di ne bhʉ́ okʉtɨ na ngongo sɨ.» ");
INSERT INTO mdm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Engʉ́ bini, Yesu agie pɨ uo me: «Yi ha ezʉ pɨ uo ngayi makpe!» Abhomʉ-o, u atsia ayi anɨ me: «Ya ayíe ne bhiti tɨa ngʉ́ nakala ezʉ nazʉ mazʉ pɨ bhiti okpála ɨnde-e su?» ");
INSERT INTO mdm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Abhomʉ-o, anɨ ayi uo me: «Mapa ka yi madho? Yi nʉ tsitsia!» U atsia lɨe, u atsia apa me: «A ka ya ne mapa bhuluvue, la di ne sungu bhisi.» ");
INSERT INTO mdm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Abhomʉ-o, Yesu atsia aha lɨ́lɨ pɨ uo me: «Yi pa pɨ ndʉ okpála hana me u popo bhʉ́la o, amba u dʉlʉ kuto pɨ́ ulu-o.» ");
INSERT INTO mdm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","U apopo bhʉ́la o, u adʉlʉ kuto: okoko kámá kámá, okoko ndjɨkpa bhuluvue ndjɨkpa bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Abhomʉ-o, Yesu aha mapa bhuluvue ne sungu bhisi-o. Anɨ atsia ’kpɨ́ ne abhʉ́lá, anɨ atsia agie heni pɨ Ebhe ngánga. Pɨpɨta-a, anɨ atsia agʉgʉmʉ mapa ango-o, anɨ aha pɨ omʉkpata gba e-o, amba u gapa lɨ okpála. Anɨ atsia agapa di sungu bhisi-e pɨ ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ndʉ uo hana azʉ ’he, u atsia aꞌuꞌu má kpe-e kpe-e! ");
INSERT INTO mdm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pɨpɨta-a, omʉkpata alo dú mapa ne sungu ɨnde atigala-o, a atsia abebedhe okíli ndjɨkpa ne ká bhisi. ");
INSERT INTO mdm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bhʉ́ ká obhende azʉ ’he ango-o, obhosɨ nanɨ kutu bhuluvue. (Mandɨ natanga olɨsɨ ne ongɨsɨ.) ");
INSERT INTO mdm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pɨpɨta kolo me-e, Yesu apa pɨ omʉkpata gba e me: «Yi ꞌʉꞌʉ bhʉ́ zabʉ. Yi kodho ’kpɨ́ mʉma kalanʉ ayi ’ngu lɨ pápá na gʉdhʉ na Betesaida lɨ nedhɨnga ma nde nga lɨe naha kpadjɨ pɨ okpála ko.» ");
INSERT INTO mdm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pɨta nagbo bhʉsʉ e ne uo-o, anɨ anʉ aꞌʉ apɨ́ ’ta ngʉ́ nayo Ebhe. ");
INSERT INTO mdm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lɨ ekpɨ́ abi lɨe, omʉkpata adʉ ne zabʉ atʉ ’ngu, Yesu atsia atigala apɨ́ ’go kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anɨ au me omʉkpata gba nɨ-e ale nadjele zabʉ pima anga anvi adʉ amene uo kpekpeke. Abhomʉ-o, akolo lɨe bhʉ́ ’gbá ’ngʉ na bini-e, anɨ aholo nadholo pɨ́ ’ngu, anɨ atsia akolo masɨkpe de uo. Anɨ di me ne uo mane. ");
INSERT INTO mdm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Engʉ́ bini ngauo-o, u au anɨ lɨe ngadholo pɨ́ ’ngu-o, u abhundja naao me a ko ɨgbadyɨbhe. Kaka-a, u aholo natʉ ꞌue. ");
INSERT INTO mdm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Padhá de, anga u adʉ au anɨ ndʉ o hana. Kaka-a, u atsia abedhe ne tsʉlʉ na kuo kuo. La-a, anɨ atsia apa bha kolo pɨ uo me: «Yi sia kpéke bua! A ko ma, yi adjé tsʉlʉ de!» ");
INSERT INTO mdm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Abhomʉ-o, anɨ aꞌʉ nganda uo bhʉ́ zabʉ-o, anvi-e aꞌo nape. U atsia adʉ ne nangamba na kuo kuo. ");
INSERT INTO mdm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Padhá de, anga ngamba ’ngʉ́ ɨnde anɨ amene e lɨ mapa-a, u mbɨla nga nanɨ de ka ndɨ nabhuka gba o-o. ");
INSERT INTO mdm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pɨta u agulu ekpɵ na Galilaya lɨe, u atsia akolo bhʉ́ ndu doto na Genedjaleta. Abhomʉ-o, u atsia agbite zabʉ lɨngo ’kpɵ-o. ");
INSERT INTO mdm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","U aze lɨe bhʉ́ zabʉ-o me-e, okpála ambɨla bha kolo me Yesu ngae ɨnde. ");
INSERT INTO mdm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Abhomʉ-o, okpála adji ndu doto ango-o libhomu ne holo. U aholo nabɨ obhʉlʉ kuo pɨ́ okalagba, ne nanʉ ne uo lɨ bɨlɨ ɨnde u adʉ adje lɨe me Yesu lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ndʉ bɨlɨ hana ɨnde lɨ anɨ adʉ anʉ lɨ e, lɨ ongangba, bhʉ́ ogʉdhʉ, ɨ dʉ di-e bhʉ́ okʉtɨ, okpála adʉ nabu obhʉlʉ kuo bhʉ́ odaposo. Obhʉlʉ kuo ango-o adʉ akikiliki lɨo pɨ anɨ me anɨ ha kpadjɨ me o bu nga bha ’kpa o lɨ ’so bongo lɨ anɨ-o. A na paká me ndʉ okpála hana ɨnde adʉ nabu ’kpa o lɨ anɨ-e, adʉ nakobho. ");
INSERT INTO mdm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Abhomʉ-o, omʉFalisai di ne omʉsuno koko na lɨ́lɨ gba Moidje ɨnde ayie nanɨ bhʉ́ Yelusalema-a, ago apo bhʉ́la o de Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","U au me okoko bhʉ́ ká omʉkpata gba Yesu-o ngazʉ ’he mandɨ navʉlʉ ’kpa o kalanʉ. Kaka-a, omʉFalisai adʉ abhundja me omʉkpata bhomʉ-o bubu kala Ebhe ade. ");
INSERT INTO mdm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Padhá de, anga omʉFalisai ne ndʉ omaYuda hana ngalila odasʉndʉ gba onguo ogbi o-o. Kaka-a, kala nazʉ ’he-e, u vʉvʉlʉ ngaɨza ’kpa o ɨ lí mali. ");
INSERT INTO mdm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɨ dʉ me u nde kolo bhʉ́ daposo-o, u vʉvʉlʉ ’kpa o ndʉ ’kpɨ́ hana kala nazʉ ’he. U ngalila di olɨ́lɨ koko u asia e ka onguo ogbi o naali maka: navʉlʉ okópo, obhende maka zulubho di ne obhende maka zikio.) ");
INSERT INTO mdm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Abhomʉ-o, omʉFalisai di ne omʉsuno na lɨ́lɨ-e ayi Yesu me: «Omʉkpata gba mʉ-o ngakpata ’ngʉ́ maka lɨ dasʉndʉ gba onguo ogbi nɨ́ apa lɨe ade. U ngazʉ ’he me u nde vʉlʉ ’kpa o de. U ngamene la mo-o ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu agie pɨ uo me: «Polofeta Ɨsaya pa nanɨ tala lɨ ’ngʉ́ gba yi-e me, yi ne obhʉlʉ kali. Anɨ aye nanɨ bhʉ́ bhuku gba e me: ‹Okpála ɨnde-e ngamanga ma bha ne ’bhɵ o padhá. La-a, bua uo de ma tsutsu. ");
INSERT INTO mdm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nadhɵgɵ gba uo zɨ bhʉ́ djila ma de. Padhá de, anga ongʉ́ ɨnde u ngasuno e a ko bha bhende ɨ ngayie ka okpála.› ");
INSERT INTO mdm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yi ngaꞌo ká olɨ́lɨ gba Ebhe-e ngʉ́ nazɨ ’ndjɨ yi bhʉ́ olɨ́lɨ gba onguo ogbi yi.» ");
INSERT INTO mdm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Anɨ atsia apa matá pɨ uo me: «Yi ngaꞌo olɨ́lɨ gba Ebhe-e lɨ ngongo ngʉbula nalila odasʉndʉ gba onguo ogbi yi-o. ");
INSERT INTO mdm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Padhá de, anga Moidje apa nanɨ me: ‹Manga ’dyɨ mʉ ne ’hi mʉ mamanga.› Anɨ atsia apa matá di me: ‹Kpála bhende ɨ sobho ’dyɨ e, ɨ dʉ di-e ’hi e, a ayo me u bhɵlɵ anɨ mabhɵlɵ.› ");
INSERT INTO mdm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Engʉ́ bini, ngayi-e, yi ngasuno pɨ okpála me, kpála bini tɨ da napa pɨ ’dyɨ e, ɨ dʉ di-e ’hi e me: ‹Mbu lɨ ma, anga ehe ɨnde ayo ɨgɨnɨ me ma ha e pɨ mʉ-o, a ko makiso ɨnde ma adji naha e pɨ Ebhe.› ");
INSERT INTO mdm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ngayi omʉFalisai-e, yi ngazɨba bhomʉ-o pɨ okpála me u améne ’he pɨ odyɨ o di ne pɨ ohi o belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kaka-a, yi bhomʉ-o ngalila odasʉndʉ gba onguo ogbi yi-e ane eli gba Ebhe-e mane. Yi la di ngamene ndʉ ngua ongʉ́ bhomʉ-o bhelé.» ");
INSERT INTO mdm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pɨpɨta-a, Yesu aꞌɨ matá bhiti okpála-o. Abhomʉ-o, anɨ atsia apa pɨ uo me: «Yi dje ma ndʉ yi hana, amba yi kɵ la di mboli engʉ́ ɨnde: ");
INSERT INTO mdm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ehe bini ade ɨnde yi zʉ e, ɨ ꞌó yi sisiti-o. La-a, engʉ́ ɨnde ngakoto lɨ bua yi-e, maka oeli di ne okulu-o, a bhomʉ-o ongʉ́ ɨnde ngaꞌo yi sisiti-o.»  ");
INSERT INTO mdm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lɨ Yesu ayie lɨe bhʉ́ ká bhiti okpála bhomʉ-o, anɨ atsia alɨ abhʉ́ ’tɨ-e, omʉkpata gba anɨ atsia ayi anɨ lɨ ta gbitaku bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Ngayi di-e, yi mbɨla ’ngʉ́ ɨnde-e dɨ? Yi mbɨla de me ndʉ ’he hana lɨ kpála ngazʉ e tɨ da naꞌo anɨ siti kpála de-e dɨ? ");
INSERT INTO mdm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Padhá de, anga ezʉ ango-o ngalɨ lɨ bhobua anɨ ade. Engʉ́ bini, a ngalɨ bhʉ́ ’bu anɨ. Pɨpɨta-a, ɨ tsia kóto.» (Yesu adʉ apa bhomʉ-o me ndʉ ’zʉ hana ndjɨndjɨ ngʉ́ nazʉzʉ.) ");
INSERT INTO mdm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Abhomʉ-o, Yesu atsia abu tata-a me: «Engʉ́ ɨnde ayie lɨ bua kpála, a bhomʉ-o bhende ɨ ngaꞌo kpála sisiti-o. ");
INSERT INTO mdm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Padhá de, anga osisiti ’ngʉ́ ɨnde ngayie lɨ bhobua kpála ngae ɨnde: omabhundja na sisiti, zabhe, ezi, nabhili okpála, ");
INSERT INTO mdm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nakʉnda olɨsi, ɨ dʉ di-e obhosɨ gba okpála koko, kʉndʉ tɨa, gʉmʉ namene osisiti ’ngʉ́, kali, bambakʉya, gʉmʉ ’he gba okpála koko, osobho, ’ngbé ’ndjɨ di ne pʉlʉ ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ndʉ osisiti ’ngʉ́ bhomʉ-o hana ngakoto lɨ bhobua kpála, ɨ tsia ꞌó kpála ango-o sisiti bhʉ́ djila Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pɨpɨta-a, Yesu ayie oo, anɨ atsia atapa bhʉ́ doto ɨnde lɨngo gʉdhʉ na Tile. Anɨ alɨ bhʉ́ ’tɨ bini, anɨ tsia kʉnda de me u mbɨla de me nɨ oo de. Engʉ́ bini, ngali nago ka anɨ-e adje lɨe ne ndʉ bɨlɨ hana. ");
INSERT INTO mdm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ma ’li ma me-e, gandji ɵlɵ bini adje ’ngʉ́ gba Yesu-o. Ɵlɵ ango-o dʉ nanɨ maYuda de. Dʉ anɨ ayie nanɨ bhʉ́ ndu doto na Fenisia, bhʉ́ doto na Silia. Ndɨlɨ gba anɨ na ɵɵlɵ adʉ me siti bua nde bhʉ́ anɨ. Abhomʉ-o, ɵlɵ bhomʉ-o ago atɨ bhʉ́ li ’dhʉ Yesu, anɨ atsia ayo ka Yesu me anɨ gbe siti bua bhʉ́ ndɨlɨ ɵlɵ gba nɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu atsia apa pɨ anɨ me: «ꞌO nga ongɨsɨ me u zʉ ’he gba o, amba u ꞌuꞌu. Padhá de, anga a ndjɨndjɨ ade me u ha mapa gba ongɨsɨ ngʉ́ nabhibhike pɨ ongɨsɨ bʉlʉ-o de.» ");
INSERT INTO mdm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɵlɵ ango-o atsia agie pɨ Yesu me: «Ngámá, belegʉ ongɨsɨ bʉ́lʉ ngazʉ okʉlʉ ’zʉ bhende ɨ ngabala asa misa-o.» ");
INSERT INTO mdm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu apa pɨ anɨ me: «Bha bini ka ’li mʉ bhomʉ-o, nʉnʉ, siti bua-a akoto bhʉ́ ndɨlɨ gba mʉ na ɵɵlɵ-o akoto.» ");
INSERT INTO mdm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Abhomʉ-o, ɵlɵ ango-o agie lɨe agba e, anɨ atsia abhaka ndɨlɨ-e me anɨ nde asɨ pɨ mako me siti bua nde akoto bhʉ́ anɨ akoto. ");
INSERT INTO mdm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pɨpɨta-a, Yesu ayie bhʉ́ ndu doto na gʉdhʉ na Tile. Anɨ apʉ bhʉ́ Sidona. Anɨ anʉ lɨ pápá na ekpɵ na Galilaya, anɨ atsia akolo bhʉ́ ndu doto na Ogʉdhʉ Ndjɨkpa. ");
INSERT INTO mdm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","U atsia ago pɨ anɨ ne bhoko bini ɨnde ɨ dje ’kpɨ́ de. Bhoko ango-o da nagama ’ngʉ́ ka anɨ adʉ kpekpeke. U atsia akikiliki lɨo pɨ Yesu me anɨ ꞌo ’kpa e pɨ́ bhoko ango-o, amba anɨ kobho. ");
INSERT INTO mdm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Abhomʉ-o, Yesu atsia aha anɨ, anɨ anʉ ne anɨ lɨ ngongo masudha de bhiti okpála-o. Anɨ atsia ꞌo lɨkpa e bhʉ́ ’dje anɨ. Anɨ aku ngʉsʉ lɨ lɨkpa e, anɨ atsia ꞌo pɨ́ ’mi bhoko ango-o ko. ");
INSERT INTO mdm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pɨpɨta-a, Yesu atsia ’kpɨ́ ne abhʉ́lá, anɨ awo má fe, anɨ atsia apa pɨ bhoko ango-o me: «Efata!» (A akʉnda napa me: «A ayo me bhulu lɨmʉ!») ");
INSERT INTO mdm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma ’li ma me-e, ’dje anɨ abhulu lɨe, ’mi anɨ ayaka, anɨ aholo agama ’ngʉ́ ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu atsia aha lɨ́lɨ pɨ okpála me u avɵ́ ’ngʉ́ ango-o pɨ kpála belegʉ de bini. Engʉ́ bini, anɨ adʉ ayoko uo lɨe, engʉ́ ango-o tsia dje yoko de. ");
INSERT INTO mdm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","U adʉ angamba na kuo kuo. Kaka-a, u atsia adʉ apa me: «Anɨ ngamene ndʉ ’ngʉ́ hana ndjɨndjɨ. Anɨ ngaha pɨ obhende ɨ dje ’kpɨ́ de-e nadje ’kpɨ́. Anɨ ngaha pɨ obhende ɨ bhʉ ’ngʉ́ de-e nabhʉ ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Bhʉ́ oekpɨ́ bhomʉ-o, bhiti okpála apo matá bhʉ́la o de Yesu. Abhomʉ-o, lɨ ehe nazʉ mazʉ dʉ la lɨe ka uo de-e, Yesu atsia aꞌɨ omʉkpata gba e, anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ma ngadje ndjinga bhiti okpála ɨnde, anga akolo mbɨa ɨnde-e ’kpɨ́ bata u bha ngadʉ de ma sɨ, ehe nazʉ mazʉ la matá di ka uo ade. ");
INSERT INTO mdm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ɨ dʉ me ma nde agie uo agba o ne gʉmʉ mo-o, angu uo ndjía lɨ kpadjɨ, anga a di bhʉ́ ká uo ne okpála bhende ayie tsutsutsu.» ");
INSERT INTO mdm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Omʉkpata gba anɨ agie pɨ anɨ me: «Nɨ́ aú ezʉ bhʉ́ mili bɨlɨ sɨ-e ngʉbula nazʉzʉ ka uo su?» ");
INSERT INTO mdm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Abhomʉ-o, Yesu atsia ayi uo me: «A ka yi ne mapa madho?» U agie me: «Mananɨka.» ");
INSERT INTO mdm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Abhomʉ-o, anɨ apa pɨ bhiti okpála me u dʉlʉ kuto. Anɨ aha mapa mananɨka-o, anɨ agie heni pɨ Ebhe. Anɨ agʉgʉmʉ mapa-o, anɨ atsia aha pɨ omʉkpata gba e me u gapa lɨ okpála. U atsia agapa lɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","U adʉ di nanɨ ne djedje osungu. Anɨ agie di heni pɨ Ebhe ngʉ́ osungu-o, anɨ atsia apa me u gapa di osungu-o lɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Okpála azʉ ’he, u aꞌuꞌu. Pɨpɨta-a, omʉkpata apo bhʉ́la dúdú ɨnde atigala, atsia abebedhe okíli mananɨka. ");
INSERT INTO mdm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Okpála ɨnde adʉ oo, u adʉ masɨkpe de kutu badha. Pɨpɨta-a, Yesu atsia aha kpadjɨ pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kolo má gala me-e, anɨ aꞌʉ ne omʉkpata gba e bhʉ́ zabʉ, u atsia atapa bhʉ́ ndu doto na Dalamanuta. ");
INSERT INTO mdm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Abhomʉ-o, omʉFalisai ago, u aholo namene kpekebhɵ ne Yesu. U adʉ akʉnda nale anɨ. Kaka-a, u ayo ka anɨ me anɨ mene nga bha pɨ o ngamba ’ngʉ́ bini ɨnde asúno me Ebhe atima anɨ ngae. ");
INSERT INTO mdm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lɨ Yesu adje lɨe mo-o, anɨ atsia apa me: «Okpála na nakɨ ɨnde-e ngayo ngamba ’ngʉ́ ngʉbula nɨ? Ma apa pɨ yi na paká me, ma méne ngamba ’ngʉ́ bini pɨ uo de!» ");
INSERT INTO mdm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anɨ aꞌo ka uo oo, anɨ aꞌʉ matá bhʉ́ zabʉ, anɨ atsia akodho ’kpɨ́ ayi ’ngu. ");
INSERT INTO mdm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lɨ omʉkpata aꞌʉ lɨe bhʉ́ zabʉ-o, u aꞌɨlɨ ’to o lɨ naha mapa. Kokoli adʉ bha ka uo bini bhʉ́ zabʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Abhomʉ-o, Yesu atsia agbele dje uo me: «ꞌE-e! Yi lila lɨyi ka levile gba omʉFalisai di ne bhende gba Elode malila.» ");
INSERT INTO mdm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Omʉkpata aholo namene kpekebhɵ sʉnda o me: «Anɨ ngapa mo-o, anga nɨ́ go ne mapa de.» ");
INSERT INTO mdm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Lɨ Yesu ambɨla engʉ́ ɨnde u adʉ apa e sʉnda o lɨe, anɨ atsia ayi uo me: «Yi ngamene kpekebhɵ sʉnda yi lɨ ’ngʉ́ na mapa lɨ ’to yi aꞌɨlɨ lɨ e ka nɨ? Yi kɵ nga mbolimboli dɨ? Yi mbɨla la di dɨ? Yi ne nabhuka adɨ? ");
INSERT INTO mdm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Alɨ yi ne djidjila, yi ngau ’kpɨ́ adɨ ka nɨ? Alɨ yi ne djedje, yi ngadje ’kpɨ́ adɨ ka nɨ? ’To yi aꞌɨlɨ lɨ ndʉ ongamba ’ngʉ́ ɨnde ma amene e hana? ");
INSERT INTO mdm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nedhɨnga ma akʉ nako obhosɨ kutu bhuluvue lɨe ne mapa bhuluvue, dudu ɨnde atigala-a, yi abebedhe nako okíli ne di madho?» U agie pɨ anɨ me: «Ndjɨkpa ne ká bhisi.» ");
INSERT INTO mdm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Abhomʉ-o, Yesu atsia ayi matá uo me: «La di-e, mapa mananɨka ɨnde ma akʉ nako okpála kutu badha ne e, dudu ɨnde atigala-a, yi abebedhe nako okíli ne di madho?» U agie me: «Mananɨka.» ");
INSERT INTO mdm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Yi kɵ nga mbolimboli sɨɨ dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pɨpɨta-a, Yesu ne omʉkpata gba e akolo bhʉ́ gʉdhʉ na Betesaida. Oo, okpála ago ne kpála bini ɨnde ɨ u ’kpɨ́ de-e pɨ Yesu. U atsia akikiliki lɨo pɨ anɨ me, anɨ ꞌo ’kpa e lɨ anɨ amba anɨ kobho. ");
INSERT INTO mdm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu aholo ’kpa kpála ɨnde ɨ u ’kpɨ́ de-o. Anɨ agbe anɨ bhʉ́ gʉdhʉ-o. Anɨ aku ngʉsʉ e bhʉ́ djila anɨ, anɨ abu ’kpa e lɨ anɨ, anɨ atsia ayi anɨ me: «Mʉ ngau mbo-o ’he uu?» ");
INSERT INTO mdm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kpála ango-o atsia ’kpɨ́ lɨ ngo e, anɨ atsia apa me: «Ma ngau okpála, u mana ndula ɨnde ngadhʉkʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pɨpɨta-a, Yesu abu matá ’kpa e lɨ djila anɨ. Kpála ango-o atsia ’kpɨ́ má sʉʉ, anɨ atsia adʉ au ’kpɨ́ ndjɨndjɨ. Anɨ atsia akobho. ");
INSERT INTO mdm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Abhomʉ-o, Yesu agie anɨ agba e, anɨ atsia apa pɨ anɨ me: «Mo onʉ́ abhʉ́ gʉdhʉ de.» ");
INSERT INTO mdm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pɨpɨta-a, Yesu ne omʉkpata gba e anʉ bhʉ́ okʉtɨ ɨnde lɨ ngo gʉdhʉ na Sedjale gba Filipo-o. Lɨ kpadjɨ-e, anɨ ayi uo me: «Okpála ngapa lɨ ma me ma ne da?» ");
INSERT INTO mdm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","U agie pɨ anɨ me: «Okoko ngapa me mʉ ne Djaa bhʉlʉ nabatisa okpála, okoko me mʉ ne Elɨya, okoko matá me mʉ ne sʉka opolofeta .» ");
INSERT INTO mdm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu atsia ayi uo me: «A la yi-e, yi ngapa naayi me ma ne da?» Piele atsia agie pɨ anɨ me: «Mʉ ne Kilisito .» ");
INSERT INTO mdm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Abhomʉ-o, Yesu atsia aha lɨ́lɨ pɨ uo kpekpeke me u apá ’ngʉ́ gba nɨ-e pɨ kpála bini de. ");
INSERT INTO mdm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pɨpɨta-a, Yesu aholo nasuno pɨ omʉkpata gba e me: «A ayo me ngama Ndɨlɨ gba kpála-a, ma dje lɨkabhu naali. Obhelesɨ okpála, ongbengbe odimandɵ gba Ebhe di ne omʉsuno na lɨ́lɨ gba Moidje ayála ma. U tsia bhɵ́lɵ ma. La-a, pɨta ekpɨ́ bata-a, ma tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Anɨ dʉ apa ’ngʉ́ ango-o lɨe ne tsʉlʉ de-e, Piele atsia agbele anɨ lɨ ngongo. Do anɨ pɨ Yesu de-e: «Mo opá mo-o de.» ");
INSERT INTO mdm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Engʉ́ bini, Yesu adji lɨe, anɨ atsia omʉkpata gba e-o, anɨ ambe bhʉ́ ’ndjɨ Piele me: «Yie de ma mayie, ngamʉ Satana ! Padhá de, anga mabhundja gba mʉ-o, a ko bhende gba Ebhe-e de. Engʉ́ bini, a ko bhende gba okpála.» ");
INSERT INTO mdm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pɨpɨta-a, Yesu apo bhʉ́la bhiti okpála di ne omʉkpata gba e de e. Anɨ atsia apa pɨ uo me: «Ɨ dʉ me kpála nde akʉnda nakpata ma-a, a ayo me anɨ ꞌo nabhundja engʉ́ gba e makpe, anɨ bɨ la di kulusi gba e, amba anɨ kpata ma. ");
INSERT INTO mdm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Padhá de, anga kpála bhende ngalila mʉkobho gba e pɨ e makpe, akpí makpi. La-a, kpála bhende ngaha mʉkobho gba e libhomu ngʉbula ma di ne ngʉbula Bádha Ngali gba Ebhe-e, anɨ akóbho makobho. ");
INSERT INTO mdm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɨ dʉ me kpála nde asia ndʉ tɨa na doto hana, tata-a pɨ anɨ ne nɨ ɨ dʉ me anɨ nde akpi na dʉdʉma-a? ");
INSERT INTO mdm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ehe bini ade ɨnde lɨ kpála-kʉtɨ tɨ da naꞌo e bhʉ́ da mʉkobho gba e. ");
INSERT INTO mdm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɨ dʉ me kpála bini nde adje nʉmʉ lɨ ma di ne lɨ oeli gba ma kala obhʉlʉ namene sisiti ’ngʉ́ na nakɨ ɨnde-e, ɨnde ɨ bhuka di Ebhe ne bua o bini de-e, ngama Ndɨlɨ gba kpála ma adjé bhadi nʉmʉ lɨ anɨ nedhɨnga ma agó lɨe bhʉ́ sangu gba ’Dyɨ ma bhʉ́ dabɨlɨ bini ne oandjelu na bububu ko.» ");
INSERT INTO mdm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu atsia apa matá pɨ uo me: «Ma apa pɨ yi na paká me, okpála koko bhʉ́ ká obhende sɨ-e, mú padhá de, u aú ngaɨza Naʉ gba Ebhe-e me, a nde ngago ne angu kalanʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pɨta ekpɨ́ madhɨa, Yesu aha Piele ne Djakɨ, di ne Djaa , anɨ anʉ ne uo tɨtɨ o apɨ́ ’ndjá ’ta. Bha sɨ me-e, anɨ adji lɨe kala uo kpi, ");
INSERT INTO mdm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bongo gba anɨ avu má tuu! Pɨ́la doto libhomu-o, kpála bini tɨ da navʉlʉ bongo, ɨ tsia vú mo-o de. ");
INSERT INTO mdm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kolo me-e, Elɨya ne Moidje aze lɨ uo, u atsia aholo agama ’ngʉ́ ne Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piele atsia apa pɨ Yesu me: «Mʉsuno, a ndjɨndjɨ maka nɨ́ nde lɨe sɨ. Zɨba pɨ ya me ya yiki otɨ ngbangbalɨ bata: bini pɨ mʉ, bini pɨ Moidje, bini pɨ Elɨya.» ");
INSERT INTO mdm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Engʉ́ bini, Piele dʉ ambɨla de me nɨ apa pɨ-ie de, anga ngaanɨ makpe ne omʉkpata bhisi ɨnde adʉ bhʉ́ dabɨlɨ ne anɨ-e, adʉ me u nde abedhe ne tsʉlʉ na kuo kuo. ");
INSERT INTO mdm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Abhomʉ-o, ndindi ago abuku uo má kagbu! Eli atsia akoto bhʉ́ ndindi ango-o me: «Kpála ɨnde-e, a ko Ndɨlɨ gba ma ɨnde ma akʉnda e naali-o. Yi dje anɨ!» ");
INSERT INTO mdm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma gala kolo me-e, lɨ omʉkpata atsia ’kpɨ́ lɨe lɨngo o-o, u u matá kpála bini de, bha Yesu kpi e kpi bhʉ́ dabɨlɨ bini ne uo. ");
INSERT INTO mdm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lɨ Yesu ne omʉkpata gba e adʉ akɵ eta-a lɨe, anɨ atsia apa pɨ uo me: «Yi apá engʉ́ yi au e ɨnde-e pɨ kpála belegʉ de bini, akólo lɨ nedhɨnga ɨnde ngama Ndɨlɨ gba kpála ma azúku lɨe bhʉ́ ká okpála ɨnde amu ko.» ");
INSERT INTO mdm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Abhomʉ-o, u awo eli bhomʉ-o lɨ bua o, u atsia adʉ ayi lɨo sʉnda o pépé me: «Nazuku bhʉ́ ká okpála ɨnde amu-o, anɨ akʉnda ɨgɨnɨ napa bhomʉ-o pɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pɨpɨta-a, u ayi Yesu me: «Ka nɨ lɨ omʉsuno na lɨ́lɨ gba Moidje ngapa lɨe me kala nago ka Masɨya-a , a ayo me Elɨya go ngaɨza kalanʉ-o?» ");
INSERT INTO mdm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu atsia agie pɨ uo me: «A na paká me Elɨya ngago ngaɨza kalanʉ, naleke ndʉ ’ngʉ́ hana. Engʉ́ bini, ka nɨ u aye nanɨ lɨe bhʉ́ Bhuku gba Ebhe-e me, Ndɨlɨ gba kpála adjé lɨkabhu naali, la di-e lɨ okpála tsia yála anɨ-e? ");
INSERT INTO mdm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","La-a, ma apa pɨ yi me, Elɨya ago nanɨ ago, okpála atsia ato mbolo lɨ anɨ má gbekpe maka u a aye lɨe bhʉ́ Bhuku gba Ebhe ko.» ");
INSERT INTO mdm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lɨ Yesu ne omʉkpata bata akɵ eta-a lɨe, u anʉ abhaka omʉkpata koko-o. A abhaka me bhiti okpála nde asa uo ngbalina. La di-e, omʉsuno na lɨ́lɨ nde ngamene kpekebhɵ ne omʉkpata ango-o. ");
INSERT INTO mdm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Lɨ bhiti okpála-a au Yesu lɨe, ndʉ uo hana angamba, u atsia agu holo ngʉ́ nago ayi anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu ayi omʉkpata gba e me: «Yi ngamene kpekebhɵ ne uo pɨndjɨ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kpála bini bhʉ́ ká bhiti okpála bhomʉ-o, atsia agie pɨ anɨ me: «Mʉsuno, ma ago ne ndɨlɨ gba ma-a pɨ mʉ me kobho anɨ, anga a bhʉ́ anɨ ne siti bua ɨnde ngagbite ’bhɵ anɨ me anɨ agáma ’ngʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndʉ nedhɨnga hana lɨ siti bua ango-o agbʉgbʉlʉ anɨ lɨe, a ngagʉ ꞌi anɨ kuto, lɨ efu holo naze bhʉ́ ’bhɵ anɨ, anɨ holo nazʉ tate e, kʉte anɨ kpekpeke má kɨ kɨ kɨ! Ma ayo ka omʉkpata gba mʉ-o me u gbe siti bua ango-o, engʉ́ bini, u ale pima.» ");
INSERT INTO mdm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu atsia apa pɨ uo me: «Ngayi okpála na nakɨ-e, nabhuka bhʉ́ yi ade! Ma adʉ́ matá ne yi ngʉbula nedhɨnga madho? Ma akíbila matá yi ngʉbula nedhɨnga madho? Yi go ne ndɨlɨ-e mʉma ei.» ");
INSERT INTO mdm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Abhomʉ-o, u ago ne anɨ pɨ Yesu. Lɨ ndɨlɨ-e au Yesu lɨe, siti bua adyɨkɨ anɨ má djigi djigi, anɨ agʉ ꞌi anɨ kuto! Ndɨlɨ-e aholo nawawala kuto me efu nde ngaze bhʉ́ ’bhɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu atsia ayi ’dyɨ ndɨlɨ-e me: «Kuo ɨnde-e amene anɨ me-e ngʉbula kalanga madho?» Anɨ agie me: «Nayie bhʉ́ ndɨlɨ lɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","La di-e, siti bua ango-o ngagʉ ꞌi anɨ bhʉ́ djua di ne bhʉ́ ’ngu bhʉtsibhʉtsi ngʉ́ nabhɵlɵ anɨ. Engʉ́ bini, ɨ dʉ me mʉ nde tɨ da namene ’he-e, mʉ de dje mbo ndjinga ya, teteke ya!» ");
INSERT INTO mdm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu agie pɨ anɨ me: «Mʉ ngapa me: ‹Ɨ dʉ me mʉ nde tɨ da namene ’he.› La-a, ndʉ ’ngʉ́ hana tɨ da namene lɨe pɨ kpála ɨnde ngabhuka ko.» ");
INSERT INTO mdm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Má gala kolo me-e, ’dyɨ ndɨlɨ-e asʉla me: «Ma abhuka. La-a, go teteke ma, amba nabhuka gba ma-a kolo kpekpeke!» ");
INSERT INTO mdm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lɨ Yesu au bhiti okpála ngago ne holo lɨ pápá gba o lɨe, anɨ atsia ambe bhʉ́ ’ndjɨ siti bua me: «Ngamʉ siti bua ɨnde ngagbite ’bhɵ ndɨlɨ ɨnde-e ne nanini ’dje anɨ, ma aha lɨ́lɨ pɨ mʉ me: ‹Koto bhʉ́ ndɨlɨ ɨnde, la di-e, mo ogíe matá lɨmʉ bhʉ́ anɨ belegʉ de bini!›» ");
INSERT INTO mdm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Abhomʉ-o, siti bua atʉ ꞌue, anɨ adyɨkɨ ndɨlɨ-e má djigi djigi, pɨpɨta-a, anɨ atsia akoto bhʉ́ anɨ! Ndɨlɨ na bhobhoko ango-o, akolo maka kpála ɨnde akpi. Okpála bhelé adʉ apa me: «Anɨ akpi.» ");
INSERT INTO mdm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Engʉ́ bini, Yesu aholo ’kpa anɨ, anɨ aꞌe anɨ bhʉ́lá, ndɨlɨ-e atsia alʉ malʉ. ");
INSERT INTO mdm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pɨpɨta-a, Yesu ne omʉkpata gba e agie lɨo lɨ bɨlɨ u adʉ nadʉ lɨ e-o. Nedhɨnga u adʉ lɨe ne uo tɨtɨ o-o, u atsia ayi anɨ me: «Ka nɨ ya tɨ ɨgɨnɨ lɨe da nagbe siti bua bhomʉ-o bhʉ́ ndɨlɨ ɨnde-e lɨe de-e?» ");
INSERT INTO mdm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu atsia agie pɨ uo me: «U tɨ da nagbe ngua bua bhomʉ-o bha bini ne mayo.» ");
INSERT INTO mdm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lɨ Yesu ne omʉkpata gba e ayie lɨe oo, u agulu ndu doto na Galilaya. Yesu dʉ akʉnda de me okpála mbɨla bɨlɨ ɨnde nɨ adʉ lɨ e de, ");
INSERT INTO mdm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","anga anɨ adʉ asuno pɨ omʉkpata gba e-o. Anɨ adʉ apa pɨ uo me: «U apʉ́ ngbángá Ndɨlɨ gba kpála pɨ okpála, lɨ okpála ango-o tsia bhɵ́lɵ anɨ. La-a, pɨta ’kpɨ́ bata-a, anɨ tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Engʉ́ bini, omʉkpata dʉ ambɨla nanɨ ta engʉ́ bhomʉ-o de. U adʉ la di ne tsʉlʉ ngʉ́ nayi anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Abhomʉ-o, Yesu ne omʉkpata gba e anʉ bhʉ́ gʉdhʉ na Kapalanauma. Pɨpɨta-a, u alɨ lɨe bhʉ́ ’tɨ bini me-e, Yesu atsia ayi omʉkpata gba e me: «Yi de ɨgɨnɨ ngamene kpekebhɵ sʉnda yi lɨ kpadjɨ-e pɨndjɨ mangua ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Engʉ́ bini, u andjili má bulu, anga lɨ kpadjɨ-e, u amene kpekebhɵ sʉnda o me a ngbéngbé bhʉ́ ká o da-ie. ");
INSERT INTO mdm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Abhomʉ-o, Yesu adʉ kuto. Anɨ apo bhʉ́la omʉkpata ndjɨkpa ne ká bhisi-e de e masɨkpe. Anɨ atsia apa pɨ uo me: «Ɨ dʉ me kpála bini nde akʉnda nadʉ kpála na kalanʉ-o, a ayo me anɨ dʉ pɨta ndʉ okpála hana, anɨ dʉ di bali gba ndʉ okpála koko hana.» ");
INSERT INTO mdm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pɨpɨta-a, anɨ aha mboye ndɨlɨ, anɨ aꞌo anɨ bhʉ́ ká uo, anɨ abɨ anɨ sa ’kpa e, anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Kpála ɨnde ngasia mboye ndɨlɨ maka bhende-e ka ’lɨ ma-a, anɨ ngasia bhomʉ-o ma makpe. La di-e, kpála ɨnde ngasia ma-a, anɨ sia bha bini ma kpi ma kpi de, engʉ́ bini, anɨ ngasia di bhomʉ-o ’Dyɨ ma ɨnde atima ma ko.» ");
INSERT INTO mdm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Abhomʉ-o, Djaa apa pɨ Yesu me: «Mʉsuno, ya au kpála bini ngapandja osisiti bua ne ’lɨ mʉ. Ya atsia ayoko anɨ, anga a ko sʉka nɨ́ de.» ");
INSERT INTO mdm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Engʉ́ bini, Yesu agie pɨ uo me: «Yi ayóko anɨ de, anga kpála ɨnde amene ngamba ’ngʉ́ ne ’lɨ ma-a, tɨ da napa kolo siti ’ngʉ́ lɨ ma pɨpɨta-a de. ");
INSERT INTO mdm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Padhá de, anga kpála ɨnde ɨ gʉ nɨ́ de-e, a ko naanɨ́ kpála. ");
INSERT INTO mdm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ma apa pɨ yi na paká me, kpála ɨnde ngaha kópo na engu pɨ yi bini kabula me yi ne okpála gba Kilisito-o , anɨ asía makalá gba e masia.» ");
INSERT INTO mdm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu atsia apa matá pɨ omʉkpata gba e me: «Kpála ɨnde ngato sʉka odjedje ongɨsɨ ɨnde ngabhuka ma ɨnde-e bhʉ́ siti ’ngʉ́-o, a pɨ anɨ ndjɨndjɨ me u gɨ ngɨngɨ tangʉlʉ anɨ, amba u bhike anɨ bhʉ́ ’ngbé ’ngu. ");
INSERT INTO mdm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ɨ dʉ me ’kpa mʉ nde ngato mʉ bhʉ́ siti ’ngʉ́ ngae-e, mʉ de kodho. A ndjɨndjɨ pɨ mʉ nalɨ bhʉ́ mʉkobho na dʉdʉma ne koli ’kpa mʉ bini, ane mane nanʉ ka mʉ bhʉ́ djua na dʉdʉma ne dʉdʉma ne ’kpa mʉ bhisi hana.  ");
INSERT INTO mdm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ɨ dʉ di me ’dhʉ mʉ nde ngato mʉ bhʉ́ siti ’ngʉ́ ngae-e, mʉ de kodho. A ndjɨndjɨ pɨ mʉ nalɨ bhʉ́ mʉkobho na dʉdʉma ne koli ’dhʉ mʉ bini, ane mane me u bhike mʉ bhʉ́ djua na dʉdʉma ne dʉdʉma ne ’dhʉ mʉ bhisi hana.  ");
INSERT INTO mdm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɨ dʉ me lɨ djila mʉ nde ngato mʉ bhʉ́ siti ’ngʉ́ ngae-e, mʉ de gbe. A ndjɨndjɨ pɨ mʉ nalɨ bhʉ́ Naʉ gba Ebhe-e ne koli lɨ djila mʉ bini, ane mane me u bhike mʉ bhʉ́ djua na dʉdʉma ne dʉdʉma ne djila mʉ bhisi hana. ");
INSERT INTO mdm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Oo, ‹okɵkɵ́ maka bangili ɨnde ngazʉ kʉte kpála mumu de, djua bʉbʉlʉ la di-i de.› ");
INSERT INTO mdm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Padhá de, anga Ebhe alé nabhuka gba ndʉ okpála hana bhʉ́ djua, amba a kolo kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ngʉtʉ ne bádha ’he. Engʉ́ bini, ɨ dʉ me a nde abolo, u tɨ da nagie matá kpokpo bhʉ́bhʉ́ ne nɨ? Nabhuka gba yi dʉ maka ngʉtʉ ɨnde ɨ bolo de, yi dʉ la di ne guo ’ngʉ́ sʉnda yi.» ");
INSERT INTO mdm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Lɨ Yesu ayie lɨe oo, anɨ anʉ bhʉ́ ndu doto na Yudaya, ayi ’ngu na Djʉlʉdanɨ. Bhiti okpála ago matá de anɨ. Anɨ aholo nasuno pɨ uo maka anɨ amemene lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Abhomʉ-o, omʉFalisai koko adyudyo lɨo de Yesu, ngʉ́ naholo anɨ lɨ ’li e. Kaka-a, u atsia ayi anɨ me: «Lɨ́lɨ gba nɨ́-e azɨba uu me bhoko gbo bhʉsʉ e ne ɵlɵ gba e?» ");
INSERT INTO mdm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu atsia agie pɨ uo me: «Moidje aha nanɨ pɨ yi lɨ ’ngʉ́ bhomʉ-o mangua lɨ́lɨ dho?» ");
INSERT INTO mdm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","U atsia apa me: «Moidje aha nanɨ pɨ bhoko kpadjɨ me anɨ ye balʉa ngʉ́ nagbo bhʉsʉ o ne wala e, amba anɨ gie anɨ agba o.» ");
INSERT INTO mdm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Engʉ́ bini, Yesu agie pɨ uo me: «Moidje aye nanɨ lɨ́lɨ bhomʉ-o pɨ yi ka kpéke ’ndjɨ gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","La lɨ lilita-a, nedhɨnga lɨ Ebhe abho ndʉ ’he lɨe hana-a ‹anɨ abho uo bhoko ne ɵlɵ.› ");
INSERT INTO mdm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹Kaka-a, bhoko aꞌɨ́lɨ ka ’dyɨ e ne ’hi e, anɨ tsia dhédhe lɨ wala e, ");
INSERT INTO mdm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ndʉ uo bhisi hana kólo koli kpála bini.› Abhomʉ-o, uo matá okpála bhisi ade. Engʉ́ bini, u akolo koli kpála bini. ");
INSERT INTO mdm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaka-a, a ayo de me kpála-kʉtɨ gbo bhʉsʉ uo de, anga Ebhe akpɵtsɵ uo ngae.» ");
INSERT INTO mdm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lɨ Yesu ne omʉkpata gba e agie lɨo lɨe lɨ bɨlɨ u adʉ nadʉ lɨ e, u atsia ayi anɨ lɨ ’ngʉ́ ango-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu apa pɨ uo me: «Ɨ dʉ me bhoko bini nde aꞌe wala e ngʉ́ naha ɵlɵ koko-o, anɨ aꞌo bhomʉ-o ká wala e na kalanʉ-o ngʉ́ nakʉnda ɵlɵ koko. ");
INSERT INTO mdm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɨ dʉ la di me ɵlɵ nde atse ’ko e ngʉ́ naha bhoko koko-o, anɨ aꞌo bhomʉ-o ká ’ko e ngʉ́ nakʉnda bhoko koko.» ");
INSERT INTO mdm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Abhomʉ-o, okpála adʉ ago ne ongɨsɨ gba o me Yesu ꞌo ’kpa e pɨ́ uo, ne natuko bisagu pɨ́ uo. Engʉ́ bini, omʉkpata ake ’ngʉ́ lɨo pɨ okpála ango-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu au lɨe mo-o, bua anɨ ake, anɨ atsia apa pɨ omʉkpata gba e me: «Yi ꞌo ongɨsɨ me, u go lɨ pabɨlɨ ma nde lɨ e-o, yi ayóko uo de. Padhá de, anga Naʉ gba Ebhe-e , a pɨ obhende maka uo ko. ");
INSERT INTO mdm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ma apa pɨ yi na paká me, kpála bhende nabhuka gba e nde maka bhe gba ndɨlɨ ade-e, kpála ango-o tɨ da nalɨ bhʉ́ Naʉ gba Ebhe-e belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Abhomʉ-o, Yesu adʉ abɨ ongɨsɨ bhomʉ-o, anɨ atsia adʉ atuko bisagu pɨ́ uo me anɨ nde ngaꞌo ’kpa e pɨ́ uo. ");
INSERT INTO mdm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lɨ Yesu adʉ aꞌe ne enʉ lɨe, bhoko bini ago ne holo nabhaka anɨ, anɨ akikita lɨpʉkʉ e kuto kala anɨ. Anɨ atsia ayi anɨ me: «Mʉsuno na babadha, a ayo me ma mene pɨ ngʉ́ nasia mʉkobho na dʉdʉma-a?» ");
INSERT INTO mdm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu atsia apa pɨ anɨ me: «Ka nɨ mʉ ngaꞌɨ ma lɨe me bádha kpála-a? Bádha kpála belegʉ ade bini, bha bini Ebhe kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","La-a, mʉ mbɨla olɨ́lɨ-e ndjɨndjɨ: ‹Mo obhɵ́lɵ kpála de, mo osɨ́ ne ɵlɵ, ɨ dʉ di-e bhoko gba kpála koko de, mo ozí ’he de, mo opá ’ngʉ́ lɨ kilí mʉ bhʉ́ djila okpála ne eu de, mo ozí kpála bhʉ́ nyalɨ de, manga ’dyɨ mʉ ne ’hi mʉ mamanga.›» ");
INSERT INTO mdm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bhoko ango-o apa pɨ anɨ me: «Mʉsuno, nayie bhʉ́ ndɨlɨ lɨ ma-a, ma amene ndʉ olɨ́lɨ bhomʉ-o hana.» ");
INSERT INTO mdm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu atsia anɨ ne mʉkʉnda hana. Anɨ atsia apa pɨ anɨ me: «Mo oneke bha koli ’he bini. Nʉnʉ, tsɨndjɨ ndʉ ’he ɨnde mʉ nde ne e hana, amba mʉ ha tɨatɨa pɨ obhʉlʉ ndɨbhɨlɨ, mo osía tɨa abhʉ́lá. Pɨpɨta-a, go kpata ma.» ");
INSERT INTO mdm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Engʉ́ bini, nedhɨnga lɨ bhoko ango-o adje lɨe mo-o, anɨ atʉ ’ndjɨ e ne kuto, anɨ atsia agie lɨe ne babuma naali, anga tɨa adʉ nanɨ ka anɨ bhelé. ");
INSERT INTO mdm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Abhomʉ-o, Yesu atsia omʉkpata gba e ɨnde adʉ me u nde asa anɨ ngbalina-o. Anɨ apa pɨ uo me: «A ko kpéke da ’ngʉ́ pɨ obhʉlʉ tɨa ngʉ́ nalɨ bhʉ́ Naʉ gba Ebhe-o!» ");
INSERT INTO mdm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abhomʉ-o, omʉkpata atsia angamba ka eli ango-o. La-a, Yesu apa matá pɨ uo me: «Odi ma, a ko kpéke da ’ngʉ́ ngʉ́ nalɨ bhʉ́ Naʉ gba Ebhe-o! ");
INSERT INTO mdm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Da nalɨ ka samo lɨ gudho mʉsana kpekpeke. A la matá kpekpeke naali pɨ bhʉlʉ tɨa nalɨ bhʉ́ Naʉ gba Ebhe-o.» ");
INSERT INTO mdm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Omʉkpata angamba matá bha naali, u atsia adʉ apa sʉnda o me: «Ɨ dʉ mo-o, a tɨ da nakobho da?» ");
INSERT INTO mdm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu atsia uo má sʉʉ, anɨ atsia apa pɨ uo me: «Pɨ okpála-a, a ko kpéke da ’ngʉ́. Engʉ́ bini, pɨ Ebhe-e, a ko kpéke da ’ngʉ́ de, anga anɨ tɨ da namene ndʉ ’ngʉ́ hana.» ");
INSERT INTO mdm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Abhomʉ-o, Piele apa pɨ anɨ me: «Djedje nga, ya aꞌo ndʉ ’he hana ngʉ́ nakpata mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu atsia apa pɨ anɨ me: «Ma apa pɨ yi na paká me, kpála ɨnde aꞌo ka etɨ gba e, ɨnde aꞌo ka ondaise e na obhosɨbhosɨ, ɨ dʉ di-e obhende na olɨsɨlɨsɨ, ɨnde aꞌo ka ’hi e, ɨ dʉ di-e ’dyɨ e, ɨ dʉ di-e ongɨsɨ gba e, ɨ dʉ di-e edyɨ gba e ngʉbula ma, la di ne ngʉbula Bádha Ngali-e , ");
INSERT INTO mdm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kpála ango-o asía mbɨa ɨnde-e bhʉtsibhʉtsi kámá bini: oetɨ, ondaise na obhosɨbhosɨ ne obhende na olɨsɨlɨsɨ, oehi, ongɨsɨ, la di ne oedyɨ bhʉ́ dabɨlɨ bini ne olɨkabhu. Anɨ tsia sía di bhʉ́ nedhɨnga ɨnde ngago-o, mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Engʉ́ bini, bhelé na okpála ɨnde u ngau o maka okpála na akalanʉ mbɨa ɨnde-e, akólo okpála na asidi, lɨ obhende u ngau o maka okpála na asidi mbɨa ɨnde-e kólo okpála na akalanʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lɨ Yesu ne omʉkpata gba e aꞌe ɨbili ne enʉ́ lɨe ngʉ́ nanʉ bhʉ́ Yelusalema-a, anɨ akɵ pɨ uo kalanʉ. Omʉkpata-a adʉ angamba. Obhende adʉ akpata uo-o, adʉ ne tsʉlʉ, Yesu aha matá omʉkpata gba e ndjɨkpa ne ká bhisi tɨtɨ o, ngʉ́ nagama ’ngʉ́ pɨ uo. Anɨ atsia aholo akpokpo ’ngʉ́ pɨ uo pɨndjɨ ongʉ́ ɨnde akólo lɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Anɨ apa pɨ uo me: «Yi dje nga ’ngʉ́ ɨnde. Nɨ́ adji bhʉ́ Yelusalema. Oo, u apʉ́ ngbángá Ndɨlɨ gba kpála pɨ ongbengbe odimandɵ gba Ebhe ne omʉsuno na lɨ́lɨ-o . U akódho ’ngʉ́ gba anɨ me anɨ kpi bha makpi. Pɨpɨta-a, u tsia pʉ́ anɨ pɨ omʉpagano. ");
INSERT INTO mdm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","U ató pádha lɨ anɨ, u akú ngʉsʉ lɨ anɨ, u abhɨ́ anɨ ne fimbo, u tsia bhɵ́lɵ anɨ. Engʉ́ bini, pɨta ’kpɨ́ bata-a, anɨ tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pɨpɨta-a, Djakɨ ngauo ne Djaa , ongɨsɨ gba Djebedayo, adyudyo lɨo de Yesu. U atsia apa pɨ anɨ me: «Mʉsuno, ya ngakʉnda me mene pɨ ya engʉ́ ɨnde ya adji ayo e ka mʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu atsia ayi uo me: «Yi akʉnda me ma mene pɨ yi nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","U agie pɨ anɨ me: «Zɨba pɨ ya nadʉlʉ bhʉ́ Naʉ gba mʉ na sangu-o , bini lɨ pá ’kpa mʉ na kokpa, koko lɨ pá ’kpa mʉ na galɨ.» ");
INSERT INTO mdm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Engʉ́ bini, Yesu atsia apa pɨ uo me: «Yi mbɨla ehe ɨnde yi ngayo e de. Yi tɨ da nandjɨ kópo na lɨkabhu ɨnde ma andjɨ́ e uu? Yi tɨ da nasia batisimo na lɨkabhu ɨnde ma asía e uu?» ");
INSERT INTO mdm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","U atsia agie pɨ anɨ me: «Ya tɨ da namemene.» Do Yesu pɨ uo me: «A moko, yi andjɨ́ kópo na lɨkabhu ɨnde ma andjɨ́ e-o, yi sía di batisimo na lɨkabhu ɨnde ma asía e-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Engʉ́ bini, ma tɨ da napa ngama de me a adʉ́lʉ lɨ pá ’kpa ma na kokpa ne me a adʉ́lʉ lɨ pá ’kpa ma na galɨ da-ie de. Obɨlɨ ango-o, a pɨ obhende lɨ Ebhe aleke pɨ o ko.» ");
INSERT INTO mdm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lɨ omʉkpata ndjɨkpa bhe koko adje engʉ́ lɨ Djakɨ ne Djaa ayo e lɨe, u atsia ake ’ngʉ́ lɨo pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Abhomʉ-o, Yesu aꞌɨ uo de e, anɨ atsia apa pɨ uo me: «Yi mbɨla hana me ongámásɨ na doto ɨnde ngaʉ pɨ́ omaha o ne kpéke. La di-e, ongbengbe okpála ngaha okpekpeke lɨ́lɨ pɨ omaha o. ");
INSERT INTO mdm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Engʉ́ bini, a ayo de me adʉ akodho ’kpɨ́ sʉnda yi mo-o de. Ɨ dʉ me kpála bini nde akʉnda nadʉ ’ngbé kpála bhʉ́ ká yi-e, a ayo me anɨ dʉ kpála na kulu gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ɨ dʉ me kpála bini bhʉ́ ká yi nde akʉnda nadʉ kpála na kalanʉ-o, a ayo me anɨ dʉ bali gba ndʉ okpála koko hana. ");
INSERT INTO mdm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Padhá de, anga ngama Ndɨlɨ gba kpála ma go nanɨ de me okpála dʉ amene kulu lɨo pɨ ma-a de. Engʉ́ bini, ma ago mangbo ngʉ́ namene kulu lɨma pɨ okpála, di ne ngʉbula nagbegbe okpála bhelé bhʉ́ bali ne lá ma makpe.» ");
INSERT INTO mdm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pɨpɨta-a, Yesu akolo bhʉ́ gʉdhʉ na Djeliko. Lɨ Yesu ne omʉkpata gba e, la di ne bhiti okpála adʉ akoto lɨe oo, u abhaka kpála bini ɨ u ’kpɨ́ de me anɨ nde adʉ dengo ’hi kpadjɨ. A adʉ ’lɨ anɨ me Balatimé, a adʉ ndala Timaya. Anɨ adʉ me anɨ nde ngayoyo ’he. ");
INSERT INTO mdm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nedhɨnga anɨ adje lɨe me a ko Yesu, kpála na Nadjaleta-a, anɨ aholo asʉsʉla me: «Yesu, Ndɨlɨ gba Davidi, dje nga mbo ndjinga ma!» ");
INSERT INTO mdm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bhiti okpála adʉ ambembe bhʉ́ ’ndjɨ anɨ me: «Gbite ’bhɵ mʉ!» Engʉ́ bini, anɨ aholo la matá asʉsʉla kpekpeke me: «Ndɨlɨ gba Davidi, dje nga mbo ndjinga ma!» ");
INSERT INTO mdm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Abhomʉ-o, lɨ Yesu adje lɨe, anɨ alʉ, anɨ atsia apa me: «Yi ꞌɨ anɨ ei.» U atsia aꞌɨ kpála ɨ u ’kpɨ́ de ne napa pɨ anɨ me: «Atou! Yie bhʉ́lá. Anɨ ngaꞌɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Abhomʉ-o, anɨ abala ’kpa lɨ koti gba e-o, anɨ aꞌulu má ngudha, anɨ atsia ago abhaka Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Abhomʉ-o, Yesu atsia ayi anɨ me: «Mo okʉnda me ma mene pɨ mʉ nɨ?» Kpála ɨ u ’kpɨ́ de-e agie pɨ anɨ me: «Mʉsuno, ma akʉnda me ma u matá ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu atsia agie pɨ anɨ me: «Nʉnʉ, nabhuka gba mʉ-o akobho mʉ akobho.» Má gala kolo me-e, anɨ aholo au ’kpɨ́, anɨ atsia adʉ akpata Yesu lɨ kpadjɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lɨ u akolo lɨe de Yelusalema-a, masɨkpe de okʉtɨ na Betefadje ne Betanɨa-a, u akolo pɨ́ eta na ondula na Olive. Yesu atima omʉkpata bhisi bhʉ́ ká omʉkpata gba e akalanʉ. ");
INSERT INTO mdm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Anɨ atsia apa pɨ uo me: «Yi nʉ bhʉ́ kʉtɨ ɨnde kala yi aoo. Yi akólo lɨe oo me-e, yi abháka me u nde agbite ndɨlɨ punda ɨnde lɨ kpála bini dhʉkʉ nga pɨ́ e de. Yi bhulu anɨ, amba yi go ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɨ dʉ la me kpála bini nde ayi yi me: ‹Yi ngabhulu anɨ ngʉ́ nɨ?› Yi de gie pɨ anɨ me: ‹Ngámá ne gʉmʉ anɨ. Engʉ́ bini, anɨ agie bha anɨ sɨ mbɨa ɨnde.›» ");
INSERT INTO mdm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Abhomʉ-o, u anʉ, u atsia abhaka ndɨlɨ punda me u nde agbite anɨ akilidjo, de ’bhɵ bhotɨ bini lɨ ’hi kpadjɨ. U atsia abhulu anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","U adʉ abhulu anɨ lɨe, okpála koko bhʉ́ ká obhende adʉ oo, ayi uo me: «Yi ngamene bhomʉ-o nɨ? Yi ngabhulu ndɨlɨ punda bhomʉ-o ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Omʉkpata agie pɨ uo maka lɨ Yesu apa lɨe pɨ uo-o. Okpála ango-o atsia aꞌo uo me u nʉnʉ. ");
INSERT INTO mdm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Abhomʉ-o, omʉkpata-a atsia ago ne ndɨlɨ punda-a pɨ Yesu, u apa obongo gba o pɨ́ ’ngbʉ anɨ. Abhomʉ-o, Yesu atsia adʉ pépé. ");
INSERT INTO mdm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Okpála bhelé apa obongo gba o lɨ kpadjɨ, okoko apa okpálá ɨnde u akodho e bhʉ́ bɨlɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Okpála bhende adʉ adhʉkʉ kala Yesu ne obhende adʉ akpata anɨ-e, adʉ asʉsʉla me: «Ebhe heni! A ayo me Ebhe tuko bisagu pɨ́ kpála ɨnde ngago ne ’lɨ Ngámá ko! ");
INSERT INTO mdm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","A ayo me Ebhe tuko bisagu pɨ́ naʉ ɨnde ngago, naʉ gba ogbi nɨ́ Davidi ko! Ebhe Apɨ́ ’Kpɨ́ heni!» ");
INSERT INTO mdm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Abhomʉ-o, Yesu anʉ bhʉ́ gʉdhʉ na Yelusalema, anɨ atsia alɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Pɨta natsia ’kpɨ́ ka anɨ lɨngo e hana, anɨ atsia anʉ ne omʉkpata gba e ndjɨkpa ne ká bhisi bhʉ́ Betanɨa, anga adʉ me ekpɨ́ nde ngabi. ");
INSERT INTO mdm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pɨta ekpɨ́ bhomʉ-o, u adʉ akoto lɨe bhʉ́ Betanɨa-a, Yesu aholo nadje gʉmʉ. ");
INSERT INTO mdm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Anɨ au ndula na figi ɨnde adʉ bhʉ́ e ne kpákpá-a de e tsutsu. Anɨ atsia anʉ ngʉ́ natsia ’kpɨ́ bhʉ́ ndula ango-o atɨgala nɨ u lɨ́lɨ́ bhʉ́bhʉ́. Engʉ́ bini, anɨ akolo lɨe dede-e, anɨ au bha bhiti kpákpá-o. Padhá de, anga adʉ nedhɨnga nalɨ kaka de. ");
INSERT INTO mdm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Abhomʉ-o, Yesu atsia atʉ pɵdjɵ lɨ ndula na figi-e ne napa me: «Mʉ lɨ́ matá lɨ́lɨ ɨnde lɨ kpála tɨ da nazʉ e belegʉ de bini!» Omʉkpata gba anɨ adje ’ngʉ́ ango-o hana. ");
INSERT INTO mdm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Abhomʉ-o, u atsia agie matá lɨo bhʉ́ Yelusalema. Lɨ Yesu alɨ lɨe bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a, anɨ aholo natsambala okpála ɨnde adʉ atsɨndjɨ ’he, ne obhende adʉ akala ’he oo-o. Anɨ atʉmba omisa gba okpála ɨnde adʉ ayipa falanga, di ne okiti gba obhende adʉ atsɨndjɨ obɵbhɵ-o kuto. ");
INSERT INTO mdm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yesu ꞌo nanɨ kpála bini akodho ’kpɨ́ ne ehe bini na mase bhʉ́ ’ngbé ’tɨ Ebhe de. ");
INSERT INTO mdm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pɨpɨta-a, anɨ aholo asuno, ne napa pɨ uo me: «U aye bhʉ́ Bhuku gba Ebhe-e me, Ebhe apa me: ‹U aꞌɨ́ etɨ gba ma-a me etɨ nayo Ebhe pɨ ndʉ opiga hana.› Engʉ́ bini, ngayi-e, yi adji, a atsia akolo bɨlɨ gba obhʉlʉ ’zi!» ");
INSERT INTO mdm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ongbengbe odimandɵ di ne omʉsuno na lɨ́lɨ adje engʉ́ ɨnde lɨ Yesu amene e-o. U atsia aholo agɨlɨ kpadjɨ ngʉ́ nabhɵlɵ anɨ. Engʉ́ bini, u adʉ akpe anɨ, anga ndʉ okpála hana adʉ angamba lɨ nasuno gba anɨ-e mangamba. ");
INSERT INTO mdm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Akolo lɨe tagolo-o, Yesu ne omʉkpata gba e akoto bhʉ́ gʉdhʉ-o. ");
INSERT INTO mdm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kɵkpɨ́ má bhɵ-o, Yesu ne omʉkpata gba e aꞌe ne enʉ. U akolo lɨe lɨ bɨlɨ lɨ Yesu atʉ pɵdjɵ lɨe lɨ ndula na figi-e, omʉkpata gba anɨ au me ndula ango-o aꞌʉlʉ hana, akolo makolo bha bini lɨ osisie. ");
INSERT INTO mdm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Abhomʉ-o, Piele abhundja engʉ́ ɨnde lɨ Yesu apa lili e lɨ figi-o, anɨ atsia apa pɨ Yesu me: «Mʉsuno, tsitsia nga, ndula na figi ɨnde mo otʉ pɵdjɵ lɨe aꞌʉlʉ hana!» ");
INSERT INTO mdm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu atsia apa pɨ omʉkpata gba e me: «Yi dʉ ne nabhuka bhʉ́ Ebhe! ");
INSERT INTO mdm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ɨ dʉ me yi nde apa pɨ eta ɨnde-e me: ‹Yie sɨɨ, amba mʉ nʉ gʉ ꞌi mʉ bhʉ́ ’ngbé ’ngu-o, Ebhe méne pɨ yi, ɨ dʉ me yi nde ne bua na bhisi bhisi ade ko. Engʉ́ bini, a ayo la me yi bhuka me Ebhe améne mamene.› ");
INSERT INTO mdm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kaka-a, ma apa pɨ yi me: ndʉ ehe hana yi ayó e bhʉ́ mayo-o, yi bhuka me yi asia ehe ango asia. Abhomʉ-o, ehe ango tsia méne lɨe pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Engʉ́ bini, nedhɨnga yi nde lɨe ngayo Ebhe-e, ɨ dʉ me yi nde ne engʉ́ pɨ kpála-a, yi de mbu ngaɨza lɨ anɨ, amba ’Dyɨ yi ɨnde abhʉ́lá-a ꞌe di osisiti ’ngʉ́ gba yi o.  ");
INSERT INTO mdm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","» ");
INSERT INTO mdm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ne omʉkpata gba e agie lɨo bhʉ́ Yelusalema. Lɨ Yesu adʉ adholo lɨe bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a, ongbengbe odimandɵ gba Ebhe, ne omʉsuno na lɨ́lɨ, di ne obhelesɨ okpála ago de anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","U atsia ayi anɨ me: «A aha kpadjɨ pɨ mʉ ngʉ́ namene ongʉ́ ɨnde-e da? A aha la di angu pɨ mʉ ngʉ́ namemene da?» ");
INSERT INTO mdm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu atsia agie pɨ uo me: «Ma adji ayi yi lɨ koli engʉ́ bini, ɨ dʉ me yi nde agie engʉ́ mʉma tété-e, ma atsia pá pɨ yi me ma ngamemene ne mangua angu dho-ie. ");
INSERT INTO mdm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aha kpadjɨ pɨ Djaa ngʉ́ nabatisa okpála da? Ne me a ko Ebhe, ne me a ko okpála? Yi gie engʉ́ mʉma tété.» ");
INSERT INTO mdm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","U aholo amene kpekebhɵ sʉnda o me: «Ɨ dʉ me nɨ nde apa me, aha kpadjɨ pɨ Djaa ne Ebhe-e, anɨ yí nɨ́ me, ɨ dʉ mo-o, ka nɨ nɨ́ bhuka la nanɨ Djaa lɨe de-e? ");
INSERT INTO mdm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Engʉ́ bini, nɨ́ tɨ da nale napa me: ‹Aha kpadjɨ pɨ Djaa ne okpála-a›?» (U apa nanɨ mo-o anga u adʉ adje tsʉlʉ ka bhiti okpála-o. Padhá de, anga ndʉ okpála hana adʉ abhundja me Djaa ne polofeta na kʉkʉlʉ.) ");
INSERT INTO mdm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Abhomʉ-o, u agie pɨ Yesu me: «Ya mbɨla de.» Yesu atsia agie pɨ uo me: «A ndjɨndjɨ, ngama di-e, ma apa pɨ yi de me a aha angu mʉma ngʉ́ namene ehe ɨnde-e da-ie de.» ");
INSERT INTO mdm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Abhomʉ-o, Yesu aholo nakpokpo ’ngʉ́ pɨ uo bhʉ́ ogbitaku me: «Kpála bini alu nanɨ ngu vino, anɨ asa ngongo-o hana ne aga. Anɨ adjɨ edú ngʉ́ napi olɨ́lɨ́-e bhʉ́bhʉ́, anɨ atsia ayiki ’ndjá ’tɨ abhʉ́lá bhʉ́bhʉ́ ngʉbula nalila edyɨ-o. Pɨpɨta-a, u adje lɨo ne okpála ngʉ́ namene kulu bhʉ́ ’dyɨ-o, amba o dʉ agbó bhʉsʉ o ne uo lɨ nguwa-o. Abhomʉ-o, anɨ atsia atapa dhʉkʉ. ");
INSERT INTO mdm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nedhɨnga lɨ nguwa abhele lɨe, anɨ atima kpála bini na kulu agba okpála ango-o me u ha nguwa bhe gba nɨ-e pɨ nɨ haha. ");
INSERT INTO mdm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Okpála namene kulu bhʉ́ ngu vino aholo kpála ango-o, u abhɨ anɨ má kpú! U atsia agie anɨ ne mbʉlʉ ’kpa e padhá. ");
INSERT INTO mdm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bhʉlʉ ’dyɨ-e atima matá kpála na kulu koko bini, bhobhomʉ-o di-e, u abhɨ anɨ lɨ ’ndjɨ e, u atsia asosobho anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bhʉlʉ ’dyɨ-e atima matá kpála koko bini, u abhɵlɵ bha ɨbili bhobhomʉ-o mabhɵlɵ. Pɨpɨta-a, bhelé na okpála koko-o, u abhɨ uo. Okoko-o, u abhili uo. ");
INSERT INTO mdm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A atigala nanɨ ɨbili ka bhʉlʉ edyɨ-e bha ne koli kpála bini anɨ tɨ da natima e, bha ndɨlɨ na bhobhoko gba anɨ bini na ’kpʉ́ bua anɨ-o. Alɨ soso hana-a, anɨ aha anɨ, anɨ atsia atima anɨ agba uo oo-o. Do anɨ de-e: ‹U amánga ndɨlɨ gba ma-a mamanga.› ");
INSERT INTO mdm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Engʉ́ bini, okpála ango-o apa sʉnda o me: ‹Yi tsia nga la ndjʉ kpála ɨnde atígala galikpe ne edyɨ-o. Yi gógo! Nɨ́ bhɵlɵ anɨ, amba edyɨ-e kolo ɨbili pɨ nɨ́.› ");
INSERT INTO mdm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","U aholo anɨ, u abhɵlɵ anɨ, u atsia abhike kuo anɨ alɨngo ’dyɨ.» ");
INSERT INTO mdm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Abhomʉ-o, Yesu atsia ayi me: «Mbɨa ɨnde-e, bhʉlʉ ’dyɨ-e améne pɨ? Anɨ agó, anɨ bhíli okpála namene kulu bhʉ́ ’dyɨ-e hana. Pɨpɨta-a, anɨ há edyɨ-e, anɨ tsia pʉ́ pɨ okpála koko. ");
INSERT INTO mdm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yi atanga bha ndjʉ Bhuku gba Ebhe-e uu? Lɨ bɨlɨ ɨnde u aye lɨe me: ‹Teme ɨnde lɨ okpála nayiki etɨ-e abhike e, akolo teme ɨnde abɨ etɨ-e libhomu. ");
INSERT INTO mdm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ebhe Ngámá amene engʉ́ bhomʉ-o ngae. Bhʉ́ djila nɨ́-e, a ko engʉ́ na ngbéngbé!›» ");
INSERT INTO mdm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lɨ Yesu apa lɨe mo-o, obhʉlʉ yala gba anɨ-e atsia adʉ agɨlɨ naholo anɨ. Padhá de, anga u adʉ ambɨla ndjɨndjɨ me anɨ apa gbitaku bhomʉ-o pɨ o. Engʉ́ la bini, u adʉ adje tsʉlʉ ka bhiti okpála. Abhomʉ-o, u aꞌo ká anɨ, u atsia agbida. ");
INSERT INTO mdm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Abhomʉ-o, u atima té omʉFalisai di ne okpála gba Elode me u nʉ agba Yesu, u gama ’ngʉ́ ne anɨ, amba u holo anɨ lɨ ’li e. ");
INSERT INTO mdm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","U ago, u atsia apa pɨ anɨ me: «Mʉsuno, ya ngambɨla ndjɨndjɨ me mʉ ngapa kʉkʉlʉ ’ngʉ́. Mʉ ne tsʉlʉ kpála belegʉ ade bini. Mʉ tsia di engbé gba kpála bini de. Engʉ́ bini, mʉ ngasuno engʉ́ gba Ebhe-e pɨ okpála bhʉ́ kʉkʉlʉ ’ngʉ́. Lɨ́lɨ azɨba pɨ? U kala mandjandja gba Kaisala , ’ngbé ngámá na doto na Loma , ne me u akála de. A ayo me ya kala, ne me ya akála de?» ");
INSERT INTO mdm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu ambɨla kali gba uo lɨe, abhomʉ-o, anɨ atsia ayi uo me: «Yi ngale ma ngʉbula nɨ? Yi go nga mʉma ne lɨ́ falanga bini, ma tsia!» ");
INSERT INTO mdm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","U ago ne lɨ́ falanga bini pɨ anɨ. Anɨ atsia ayi uo me: «Kulu kpála di ne balʉa ɨnde pépé ɨnde-e, a ko naa da?» U agie pɨ anɨ me: «A ko naa Kaisala.» ");
INSERT INTO mdm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Yi ha ehe bhende gba Kaisala-a pɨ Kaisala, amba yi ha la di bhende gba Ebhe-e pɨ Ebhe.» U atsia adʉ nangamba lɨ anɨ naali. ");
INSERT INTO mdm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abhomʉ-o, oSadukai ago de Yesu. (Ngauo-o, u zɨba nanɨ naao de me okpála ɨnde amu-o azúku mazuku-o de.) U atsia ayi Yesu me: ");
INSERT INTO mdm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Mʉsuno, Moidje aye nanɨ lɨ́lɨ pɨ nɨ́ me: ‹Ɨ dʉ me kpála bini nde akpi, anɨ ꞌo ká wala e me u nde zu ne anɨ de-e, a ayo me ndai anɨ ha ɵkɵ ango-o, amba anɨ zu ndɨlɨ pɨ ndai e ɨnde akpi ko.› ");
INSERT INTO mdm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","La-a, a adʉ nanɨ obhosɨ mananɨka bhʉ́ piga bini. Bhende na kalanʉ-o aha ɵlɵ, anɨ akpi padhá me anɨ nde zu de. ");
INSERT INTO mdm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bhende na bhisi aha ɵlɵ ango-o, anɨ akpi padhá me anɨ nde zu de. A akolo bhadi lɨ kʉte bhende na bata moko. ");
INSERT INTO mdm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ndʉ obhosɨ bhomʉ-o mananɨka hana amu me u nde zu de. Pɨta ndʉ uo hana-a, ɵlɵ-o atsia akpi di. ");
INSERT INTO mdm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lɨ ’kpɨ́ lɨ okpála ɨnde amu-o azúku lɨe, ɵlɵ ango-o adʉ́ naa da? Padhá de, anga ndʉ uo mananɨka hana aha nanɨ anɨ!» ");
INSERT INTO mdm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Abhomʉ-o, Yesu atsia agie pɨ uo me: «Yi angɨta, anga yi mbɨla Bhuku gba Ebhe-e de, yi mbɨla la di angu gba Ebhe-e de. ");
INSERT INTO mdm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Padhá de, anga lɨ okpála ɨnde amu-o azúku lɨe, u há lɨo de. Engʉ́ bini, u adʉ́ ɨbili maka oandjelu abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lɨ ’ngʉ́ bhende atsia nazuku ka okpála-a, yi tanga nga bhuku gba Moidje, lɨ bɨlɨ ɨnde anɨ akpo ’ngʉ́ lɨe pɨndjɨ tsá ’pó ɨnde adʉ atsi-e dɨ? Lɨ bɨlɨ bhomʉ-o, u aye me Ebhe apa pɨ anɨ me: ‹Ma ne Ebhe gba Abalahama, Ebhe gba Ɨsaka, Ebhe gba Yakobho.› ");
INSERT INTO mdm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ebhe ne Ebhe gba okpála ɨnde amu-o ade. Engʉ́ bini, anɨ mangbo ne Ebhe gba okpála ɨnde ʉʉ ko. Yi angɨta bha ndjʉ na paká paká.» ");
INSERT INTO mdm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mʉsuno bini na lɨ́lɨ gba Moidje adje uo nedhɨnga u adʉ amene kpekebhɵ lɨe-o. Anɨ atsia au di maka lɨ Yesu agie ’ngʉ́ lɨe pɨ oSadukai ndjɨndjɨ-o. Abhomʉ-o, anɨ adyudyo lɨe, anɨ atsia ayi Yesu me: «Lɨ́lɨ ɨnde ane ne engbé-e ngae dho?» ");
INSERT INTO mdm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu agie pɨ anɨ me: «Lɨ́lɨ na bini ɨnde ane ne engbé-e ngae ɨnde: ‹Ɨsalaele, djedje nga! Ebhe, Ngámá gba nɨ́-e bha ne koli Ngámá kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A ayo me kʉnda Ebhe, Ngámá gba mʉ-o ne bua mʉ hana, ne mʉkobho gba mʉ-o hana, ne mabhundja gba mʉ-o hana, la di ne angu gba mʉ-o hana.› ");
INSERT INTO mdm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bhende na bhisi-e ngae ɨnde: ‹A ayo me kʉnda kilí mʉ maka mo okʉnda lɨmʉ lɨe makpe ko.› Lɨ́lɨ bini ade ɨnde ane obhobhomʉ-o ne engbé.» ");
INSERT INTO mdm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Abhomʉ-o, mʉsuno na lɨ́lɨ-e apa pɨ anɨ me: «A ndjɨndjɨ naali, Mʉsuno! Mo opa paká. Anɨ bha ne koli Ngámá ngae kpi e kpi, Ngámá koko ade, bha bini anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","La di-e, a ayo me kpála kʉnda anɨ ne bua e hana, ne ɨmbɨlangʉ gba e hana, ne angu gba e hana, amba anɨ kʉnda la di kilí e maka anɨ akʉnda lɨe lɨe makpe ko. Bhobhomʉ-o ndjɨndjɨ ane natsulu oenʉ pɨ Ebhe di ne obhe u ahaha e pɨ anɨ ko.» ");
INSERT INTO mdm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lɨ Yesu au lɨe me anɨ agie ’ngʉ́ ne ɨmbɨlangʉ-o, anɨ atsia apa pɨ anɨ me: «Mʉ de Naʉ gba Ebhe-e tsutsu ade.» Pɨpɨta-a, kpála bini le matá nayi Yesu belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lɨ Yesu adʉ asuno lɨe pɨ okpála bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a, anɨ atsia adʉ ayi me: «Lele pɨ lɨ omʉsuno na lɨ́lɨ gba Moidje tɨ da napa lɨe me Masɨya ne ndɨlɨ gba Davidi-e? ");
INSERT INTO mdm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Padhá de, anga ngaanɨ Davidi makpe-e bhʉ́ nateteke gba Bu Bhobua apa nanɨ me: ‹Ebhe Ngámá apa pɨ ngámá gba ma-a me: Dʉ lɨ pá ’kpa ma na kokpa, akolo lɨ nedhɨnga ɨnde ma aꞌó obhʉlʉ yala gba mʉ-o lɨe sa ’dhʉ mʉ ko.› ");
INSERT INTO mdm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi ngae makpe ngaꞌɨ Masɨya me ‹Ngámá.› Lele pɨ anɨ nde la lɨe ne ndɨlɨ gba Davidi-e?» Bhiti okpála na bhibhiti adʉ nadje anɨ ne djalɨ naali. ");
INSERT INTO mdm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu adʉ apa pɨ okpála bhʉ́ nasuno gba e me: «Yi lila lɨyi ka omʉsuno na lɨ́lɨ gba Moidje malila. Padhá de, anga ngauo-o, u kʉnda bha nadhʉkʉ ne ondjandja yambu, di ne me u dʉ nayi o maka ongámásɨ lɨ obɨlɨ ɨnde lɨ okpála apɵpɵkɵbhɵ bhʉ́la o lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","U kʉnda bha nadʉlʉ pɨ́ odabɨlɨ na akalanʉ bhʉ́ oetɨ nadje lɨ́lɨ gba Moidje , di ne pɨ́ odabɨlɨ na akalanʉ bhʉ́ da oanokomɨa. ");
INSERT INTO mdm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","U ngabha oehe gba oɵkɵsɨ na olɨsɨlɨsɨ. U ngayo Ebhe ngengele ngʉbula me okpála u o. Kaka-a, u asía mangɨmbo ane bhende gba okpála koko mane.» ");
INSERT INTO mdm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu adʉ lɨ bɨlɨ lɨ sanduku na makiso na ’ngbé ’tɨ Ebhe-e adʉ nadʉ lɨ e, ne lɨ pápá na abhʉ́bhʉ́la. Yesu adʉ atsia maka lɨ okpála adʉ naꞌo makiso lɨe bhʉ́bhʉ́-o. Kambɨ obhʉlʉ tɨa adʉ naꞌo tɨa bhelé. ");
INSERT INTO mdm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Engʉ́ bini, ɵkɵ bini na ɵɵlɵ, bhʉlʉ ndɨbhɨlɨ ago. Anɨ aha bha naae djedje lɨ́ falanga bhisi padhá má kpɨkɨlɨ! ");
INSERT INTO mdm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Abhomʉ-o, Yesu aꞌɨ omʉkpata gba e-o. Anɨ atsia apa pɨ uo me: «Ma apa pɨ yi na paká me, ɵkɵ na ɵɵlɵ ɨnde naae ne bhʉlʉ ndɨbhɨlɨ ɨnde-e, aha makiso ane ndʉ okpála ɨnde aꞌo makiso bhʉ́ sanduku ɨnde-e hana. ");
INSERT INTO mdm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Padhá de, anga ndʉ okoko hana, u aha tɨa bhende u nde ne gʉmʉ e ade ko. Engʉ́ bini, ngaanɨ, bhʉ́ ndɨbhɨlɨ gba e, anɨ aha ndʉ bhende adʉ ka e, ɨnde anɨ adʉ akobho lɨ e hana-o.» ");
INSERT INTO mdm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nedhɨnga lɨ Yesu adʉ akoto lɨe bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a, sʉka omʉkpata gba anɨ bini atsia apa pɨ anɨ me: «Mʉsuno, tsitsia nga! Ae mangua babadha ka oteme dho! Ae mangua babadha ka oetɨ dho!» ");
INSERT INTO mdm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu atsia agie pɨ anɨ me: «Mo ou ongbengbe ’tɨ ɨnde ayiki lɨe ɨnde-e au? Oteme bhomʉ-o, sʉsʉka bini tígala pɨ́ kilí e de. Ndʉndʉ hana atúko kuto.» ");
INSERT INTO mdm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Lɨ Yesu adʉ lɨe pɨ́ eta na ondula na Olive bhʉ́la ’ngbé ’tɨ Ebhe gba omaYuda-a, Piele, Djakɨ, Djaa ne Andɨlɨ adʉ ne anɨ tɨtɨ o. U atsia ayi anɨ me: ");
INSERT INTO mdm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Pa nga pɨ ya me engʉ́ ango-o akólo nadho? Ehe ɨnde asúno la di me ndʉ ’ngʉ́ hana adji andjia adʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Abhomʉ-o, Yesu aholo napa pɨ uo me: «ꞌE-e! Kpála bini apíte yi de! ");
INSERT INTO mdm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Okpála bhelé agó amene engʉ́ ne ’lɨ ma ne napa me: ‹Ma ne Masɨya !› U tsia píte okpála bhelé. ");
INSERT INTO mdm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nedhɨnga yi adjé ngali na oegʉ́ di ne dhukudhuku na oegʉ́ lɨe, yi adjé tsʉlʉ de, anga a ayo me oengʉ́ ango-o kolo. Engʉ́ bini, adʉ́ nga bhomʉ-o sokpɨ́-e de. ");
INSERT INTO mdm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Padhá de, anga okpála na kʉtɨ bini atɨ́ ’gʉ́ lɨ okpála na kʉtɨ koko. Ngámá na kʉtɨ bini atɨ́ ’gʉ́ lɨ ngámá na kʉtɨ koko. Oadjigidjo na ngbengbengbe adyɨ́kɨ doto lɨ obɨlɨ ngangá. Ehe nazʉ mazʉ dʉ́ ka okpála belegʉ de bini. A adʉ́ maka lɨ bhʉ́ ’bu ɵlɵ azʉzʉ lɨe kala nazu ka e-o. ");
INSERT INTO mdm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ꞌE-e! Yi lila lɨyi malila. Padhá de, anga okpála agbé yi bhʉ́ ngbanga kala ongámásɨ, di ne abhʉ́ oetɨ nadje lɨ́lɨ gba Moidje . U abhɨ́ yi, u apándja yi kala okpála natsia ’kpɨ́ lɨ ndu doto di ne kala ongbengbe ongámásɨ ngʉbula ma, amba yi kpokpo ’ngʉ́ gba ma kala uo. ");
INSERT INTO mdm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Padhá de, anga a ayo ngaɨza me u kpokpo Bádha Ngali pɨ ndʉ opiga hana. ");
INSERT INTO mdm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lɨ nedhɨnga u anʉ́ ne yi lɨe kala ongámásɨ ngʉ́ nakodho ’ngʉ́ gba yi-e, bua yi agʉ́kʉ de me nɨ apá pɨ-ie de. Engʉ́ bini, engʉ́ ɨnde akóto bhʉ́ ’bhɵ yi lɨ nedhɨnga bhomʉ-o, yi de pa bha e. Padhá de, anga engʉ́ yi apá e yíe ka yi de. Engʉ́ bini, ayíe ka Bu Bhobua . ");
INSERT INTO mdm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kpála apʉ́ ndai e na bhobhoko me u bhɵlɵ anɨ. ’Dyɨ ndɨlɨ améne bhadi moko lɨ pabɨlɨ gba ndɨlɨ gba e. Lɨ ongɨsɨ kólo obhʉlʉ yala gba odyɨ o, u tsia pʉ́ uo me u bhili uo. ");
INSERT INTO mdm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndʉ okpála hana ayála yi kabula ’ngʉ́ gba ma. Engʉ́ bini, kpála bhende alʉ́ kpekpeke akólo lɨ soso-o, akóbho ngae.» ");
INSERT INTO mdm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Yi aú kpála ɨnde u aꞌɨ e me ‹Siti bhʉlʉ nabhɵlɵ kʉtɨ-e› adʉ lɨ bɨlɨ ɨnde ɨ tɨ de me anɨ dʉ lɨe de-o. (A ayo me kpála atánga bhuku ɨnde-e, kɵ mbolimboli ndjɨndjɨ!) Abhomʉ-o, obhende adʉ́ abhʉ́ Yudaya-a, a ayo me u kpe apɨ́ oeta. ");
INSERT INTO mdm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kpála ɨnde adʉ́ apɨ́ ’ngbʉ ’tɨ-e, a ayo de me anɨ kɵ ngʉ́ nanʉ abhʉ́ ’tɨ gba e naha ’he bini-e de. ");
INSERT INTO mdm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kpála bhende adʉ́ abhiye-e, a ayo de me anɨ gie lɨe naha bongo gba e de. ");
INSERT INTO mdm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lɨ ’kpɨ́ ango-o, a adʉ́ lɨkabhu na ngbéngbé pɨ olɨsɨ na ’bhɨ di ne obhende lɨ ongɨsɨ adʉ andjɨ ’ka o-o! ");
INSERT INTO mdm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yi yo Ebhe ngʉbula me engʉ́ ango-o akólo lɨ nedhɨnga na zini de. ");
INSERT INTO mdm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Padhá de, anga oekpɨ́ ango-o adʉ́ oekpɨ́ na lɨkabhu u u nga ngua e de, nayie maka lɨ Ebhe abho doto lɨe nakolo pɨ mbɨa ɨnde. La di-e, u ú matá ngungua de. ");
INSERT INTO mdm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ɨ dʉ́ me Ngámá gbɵ́tɵlɵ oekpɨ́ ango-o de-e, kpála bini de tɨ́ da nadʉ bhʉ́ mʉkobho de. Engʉ́ bini, anɨ agbɵtɵlɵ oekpɨ́ ango-o ka okpála bhende anɨ alo o ko. ");
INSERT INTO mdm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ɨ dʉ me kpála bini nde apa pɨ yi me: ‹Yi tsitsia, Masɨya sɨɨ!›, ɨ dʉ di-e me: ‹Yi tsitsia, anɨ abhe!›, yi azɨ́ba kpála ango-o de. ");
INSERT INTO mdm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Padhá de, anga omasɨya na eu di ne opolofeta na eu agó mago. U améne ongʉ́ na ngangamba di ne okɨaka ’ngʉ́ ngʉ́ napite okpála. Lɨ angu uo kolo-o, u apíte belegʉ okpála lɨ Ebhe alo o-o. ");
INSERT INTO mdm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","La-a, ngayie, yi tsia ’kpɨ́ lɨyi ndjɨndjɨ, anga ma agbele ’dje yi lɨ ndʉ ’ngʉ́ hana kalanʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Engʉ́ bini, lɨ oekpɨ́ ango-o, pɨta lɨkabhu bhomʉ-o, lɨ ela kólo biti, epe sʉ́ matá-a de, ");
INSERT INTO mdm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","oɨkʉpala ahólo nabala kuto, oangu ɨnde abhʉ́lá adyɨ́kɨ má djigi djigi! ");
INSERT INTO mdm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Abhomʉ-o, u ú Ndɨlɨ gba kpála nago bhʉ́ ndindi, ne ndʉ angu di ne ndʉ sangu gba e hana. ");
INSERT INTO mdm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anɨ atíma oandjelu lɨ odje bɨlɨ badha hana ngʉ́ napo bhʉ́la obhende anɨ alo o-o, abana u dʉ bha su-oie.» ");
INSERT INTO mdm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Yi kɵ mboli nasuno ɨnde lɨ ndula na figi asuno e-o. Ɨ dʉ me yi nde au me oyáyá angbɵngbɵlɵ-o, di me okpákpá-a nde akɵ-o, yi de mbɨla me gbokokpɨ ɨbili masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A bhadi moko. Ngayi di-e, nedhɨnga yi aú engʉ́ bhomʉ-o ngakolo lɨe, yi mbɨla me nago gba Ndɨlɨ gba kpála akolo masɨkpe. Anɨ lɨ obhɵbhotɨ gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma apa pɨ yi na paká me, nedhɨnga na engʉ́ ango-o akólo makolo, me ndʉ okpála ɨnde-e nde ndjia nga ndʉ o hana de. ");
INSERT INTO mdm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ekpɨ́ ne doto andjía mandjia. Engʉ́ bini, oeli gba ma-a adʉ́ dʉdʉma ne dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Engʉ́ bini, ekpɨ́ di ne nedhɨnga lɨ ongʉ́ bhomʉ-o akólo lɨe, kpála bini mbɨla de, belegʉ de oandjelu abhʉ́lá, belegʉ de Ndɨlɨ-o. Ambɨla bha ne ’Dyɨ ma kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ꞌE-e! Yi alá-a de, anga yi mbɨla nedhɨnga lɨ engʉ́ ango-o agó lɨe de! ");
INSERT INTO mdm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A adʉ́ maka kpála bini ɨnde adji enʉ́: anɨ aꞌo ká etɨ gba e pɨ obhʉlʉ kulu gba e me u dʉ atsia ’kpɨ́ tété. Anɨ aha kulu namene mamene pɨ kpála bini ne bini. Anɨ aha lɨ́lɨ pɨ mʉlila me anɨ alá-a de. ");
INSERT INTO mdm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kaka-a, yi alá-a de, anga yi mbɨla nedhɨnga lɨ bhʉlʉ etɨ-e agíe lɨe lɨe de! Nedhɨnga koko adʉ́ tagolo, koko adʉ́ tutu sukpe, koko adʉ́ bhʉ́ ’gbá ’ngʉ na bini, koko adʉ kɵkpɨ́. ");
INSERT INTO mdm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anɨ koto la di-e má gbilikiti-e, a ayo de me anɨ bhaka yi tɨla-a de! ");
INSERT INTO mdm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Engʉ́ ɨnde ma ngapa e pɨ yi-e, ma ngapapa pɨ ndʉ okpála hana me: ‹Yi alá-a de!›» ");
INSERT INTO mdm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A adʉ nanɨ ’kpɨ́ bhisi kala anokomɨa na Pasɨka , ne kala anokomɨa nazʉ mapa ɨnde lɨ levile nde bhʉ́ e ade-o . Ongbengbe odimandɵ di ne omʉsuno na lɨ́lɨ gba Moidje adʉ agɨlɨ me o hólo Yesu bhʉ́ pepe lele pɨ, amba o bhɵlɵ anɨ-e. ");
INSERT INTO mdm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","U adʉ apa me: «A ayo de me nɨ́ holo anɨ bhʉ́ nedhɨnga na anokomɨa de, anga nɨ́ mene mo-o, lɨ okpála gbé tolo.» ");
INSERT INTO mdm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu adʉ bhʉ́ kʉtɨ na Betanɨa bhʉ́ ’tɨ gba Simo, bhʉlʉ kába-o. Nedhɨnga u adʉ lɨe nazʉ ’he-e, ɵlɵ bini ago ne gɨlɨ ɨnde u amene e lɨ alabatele. A adʉ bhʉ́bhʉ́ ne tiki mʉngotsi na nalade. A adʉ la di bhʉ́ kpéke mase. Anɨ agʉmʉ gɨlɨ na alabatele-o, anɨ atsia atuko mʉngotsi ango-o pɨ́ ’ndjɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Okpála koko a adʉ apa sʉnda o ne ke bua me: «Mʉngotsi ɨnde-e ngasiti lɨe me-e ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","U tɨ nako da natsɨtsɨndjɨ ngʉ́ lɨ́ denalio ane kámá bata mane. U tsia há tɨa ango-o pɨ obhʉlʉ ndɨbhɨlɨ!» U atsia adʉ ake ’ngʉ́ lɨo pɨ ɵlɵ ango-o. ");
INSERT INTO mdm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Engʉ́ bini, Yesu apa me: «Yi ꞌo anɨ. Yi ngato mbolo lɨ anɨ ngʉ́ nɨ? Anɨ amene mʉma bhomʉ-o bádha ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Padhá de, anga ngayi-e, yi ngadʉ ne obhʉlʉ ndɨbhɨlɨ ndʉ ’kpɨ́ hana de yi. Nedhɨnga yi kʉnda lɨe, yi tɨ da namene bádha ’ngʉ́ pɨ uo. Engʉ́ bini, ngama-a, nɨ́ ne yi ndʉ ’kpɨ́ hana ade. ");
INSERT INTO mdm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bhende anɨ atɨ nako da namene e, anɨ amene: anɨ apulu mʉngotsi lɨ kʉte ma kalanʉ ngʉ́ nazɨ ma ko. ");
INSERT INTO mdm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ma apa pɨ yi na paká me, ndʉ bɨlɨ hana ɨnde u akpokpo Bádha Ngali lɨe pɨ́la doto libhomu-o, u akpókpo di engʉ́ anɨ amene e, lɨ okpála dʉ di abhundja anɨ.» ");
INSERT INTO mdm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Abhomʉ-o, Yuda Ɨsɨkaliote, sʉka omʉkpata ndjɨkpa ne ká bhisi-e anʉ agba ongbengbe odimandɵ ngʉ́ napʉ Yesu pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","U adje engʉ́ bhomʉ-o lɨe, u akpi ndjɨlɨ naali. U atsia apa me o há pɨ anɨ tɨa. Abhomʉ-o, Yuda atsia adʉ agɨlɨ bádha nedhɨnga ngʉbula napʉ Yesu pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ekpɨ́ na bini na anokomɨa nazʉ mapa ɨnde lɨ levile nde bhʉ́ e ade-e, ekpɨ́ u adʉ abhɵlɵ kandɵlɵ lɨe ngʉbula Pasɨka-a, omʉkpata gba Yesu ayi anɨ me: «Mo okʉnda me ya nʉ leke da nazʉ Pasɨka pɨ mʉ su?» ");
INSERT INTO mdm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Abhomʉ-o, anɨ atima omʉkpata bhisi bhʉ́ ká omʉkpata gba e-o. Anɨ atsia apa pɨ uo me: «Yi nʉ bhʉ́ gʉdhʉ, yi akɵ́ lɨyi ne bhoko bini ɨnde abɨ lʉsa ’ngu, yi kpata anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bɨlɨ ɨnde anɨ alɨ́ lɨ e-e, yi de pa pɨ bhʉbhʉlʉ-o me: ‹Mʉsuno apa me: tɨna ’tɨ ɨnde mo oleke e mʉma ne omʉkpata gba ma ngʉ́ nazʉ Pasɨka tété-e ngae dho?› ");
INSERT INTO mdm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Abhomʉ-o, anɨ asúno tɨna ’tɨ ɨnde abhʉ́lá-a pɨ yi. A ngbéngbé, u aleke ndjɨndjɨ, ndʉ ’he hana bhʉ́bhʉ́ bedhe. A bhomʉ-o bɨlɨ ɨnde yi aléke da anokomɨa pɨ nɨ́ lɨ e ko.» ");
INSERT INTO mdm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Omʉkpata-a agbida. U anʉ abhʉ́ gʉdhʉ. U atsia abhaka ndʉ ’ngʉ́ hana maka lɨ Yesu apa pɨ uo lɨe ko. Abhomʉ-o, u atsia alʉ ezʉ na Pasɨka-o. ");
INSERT INTO mdm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A akolo lɨe tagolo-o, Yesu ne omʉkpata gba e ndjɨkpa ne ká bhisi-e akolo. ");
INSERT INTO mdm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nedhɨnga u adʉlʉ lɨe pɨ́ misa me u nde ngazʉ ’he-e, Yesu atsia apa me: «Ma apa pɨ yi na paká me, sʉka yi bini, ɨnde ngazʉ ’he ne ma-a, apʉ́ ma.» ");
INSERT INTO mdm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Omʉkpata-a abedhe ne babuma lɨ bua o bedhe. U atsia aholo nayi anɨ bini ne bini me: «A adʉ́ ma?» ");
INSERT INTO mdm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Anɨ apa pɨ uo me: «A ko sʉka yi omʉkpata ndjɨkpa ne ká bhisi-o, bhende ɨ ngato ’kpa e ne ma bhʉ́ saanɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndɨlɨ gba kpála akpí bha na paká maka u aye lɨe bhʉ́ Bhuku gba Ebhe lɨ ’ngʉ́ gba anɨ-o. Engʉ́ bini, a ko lɨkabhu pɨ kpála ɨnde apʉ́ Ndɨlɨ gba kpála-o. A belegʉ nako pɨ kpála ango-o ndjɨndjɨ me u azú anɨ de!» ");
INSERT INTO mdm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nedhɨnga u adʉ azʉ ’he lɨe, Yesu aha mapa-o. Pɨpɨta-a, anɨ agie heni pɨ Ebhe. Anɨ atsia agʉmʉ bhʉsʉ bhʉsʉ, anɨ atsia aha pɨ uo. Do anɨ de-e: «Yi haha, a ɨnde-e kʉte ma.» ");
INSERT INTO mdm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pɨpɨta-a, anɨ aha kópo-o, pɨta anɨ agie heni lɨe pɨ Ebhe-e, anɨ atsia aha pɨ uo. U atsia andjɨ ndʉ o hana. ");
INSERT INTO mdm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Anɨ atsia apa pɨ uo me: «A ɨnde-e ngʉte ma, ngʉte na gandja ɨnde atuko lɨe pɨ bhiti okpála-o. ");
INSERT INTO mdm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma apa pɨ yi na paká me, ma andjɨ́ matá galikpe lɨ́ ndula na vino belegʉ de bini, akólo lɨ ’kpɨ́ ɨnde ma andjɨ́ matá lɨe ne toto bhʉ́ Naʉ gba Ebhe-o .» ");
INSERT INTO mdm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pɨta u ali ’tsi lɨe, u aze ngʉ́ nanʉ pɨ́ ’ta na ondula na Olive. ");
INSERT INTO mdm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Abhomʉ-o, Yesu apa pɨ uo me: «Ndʉ yi hana, yi aꞌó ká ma, anga u aye bhʉ́ Bhuku gba Ebhe-e me: ‹Ma asʉ́ mʉlila gba okandɵlɵ-o, lɨ ongɨsɨ kandɵlɵ-o gbóngbolo ne bɨlɨ ngangá.› ");
INSERT INTO mdm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Engʉ́ bini, ma azúku lɨe, ma anʉ́ adjeke yi abhʉ́ Galilaya.» ");
INSERT INTO mdm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piele atsia apa pɨ anɨ me: «Belegʉ lɨ ndʉ okpála hana ꞌo ká mʉ-o, ngama de!» ");
INSERT INTO mdm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu atsia apa pɨ anɨ me: «Ma apa pɨ mʉ na paká me, ngamʉ-o, sukpe na nakɨ ɨnde-e, kala me engʉ ku ’gbá bhʉtsibhʉtsi bhisi-e, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» ");
INSERT INTO mdm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Engʉ́ bini, Piele atsia apa matá ne kekele me: «Abana ɨ yo bha me ma kpi bhʉ́ dabɨlɨ bini ne mʉ-o, ma atsé mʉ de!» Abhomʉ-o, ndʉ uo hana atsia apa bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pɨpɨta-a, Yesu ne omʉkpata gba e akolo lɨ bɨlɨ ɨnde u aꞌɨ e me Getesemanɨ. Anɨ atsia apa pɨ uo me: «Yi dʉlʉ kuto sɨ, nedhɨnga ɨnde ma adʉ́ lɨe nayo Ebhe ko.» ");
INSERT INTO mdm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Anɨ anʉ bhʉ́ dabɨlɨ bini ne Piele, Djakɨ ne Djaa . Abhomʉ-o, tsʉlʉ aholo anɨ, anɨ aholo azʉ lɨkabhu lɨ bua e. ");
INSERT INTO mdm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Anɨ atsia apa pɨ uo me: «Bua ma abedhe ne lɨkabhu bedhe ka ma adji akpi lɨe-o. Yi tigala sɨ, yi alá-a de!» ");
INSERT INTO mdm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pɨpɨta-a, anɨ anʉ mbo tsutsu bedɨ. Anɨ atsia agʉ ꞌi e bhʉ́ doto. Anɨ atsia adʉ ayo Ebhe ngʉbula e me ɨ dʉ me a nde alé male-e, nedhɨnga bhomʉ-o de kodho ’kpɨ́ de nɨ tsutsu. ");
INSERT INTO mdm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Anɨ adʉ apa me: «Aba, ’Dyɨ ma, kpéke da ’ngʉ́ pɨ mʉ ade. ꞌE kópo na lɨkabhu ɨnde-e de ma maꞌe! Engʉ́ bini, mo oméne maka ma akʉnda lɨe de, mene mangbo maka mo okʉnda lɨe ko!» ");
INSERT INTO mdm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu agie lɨe, anɨ abhaka omʉkpata gba e bata me u nde tɨla. Do anɨ pɨ Piele de-e: «Simo, mʉ ngala-a? Mʉ sia angu ngʉ́ nadʉ ndɨla belegʉ de ngʉbula saa bini? ");
INSERT INTO mdm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yi alá-a de, yi yo Ebhe, amba yi alɨ́ bhʉ́ nale de. Bua kpála dʉdʉ bedhe ne angu, engʉ́ bini, kʉte anɨ bhʉbhʉkʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pɨpɨta-a, Yesu atuto matá lɨe mbo tsutsu masudha. Anɨ atsia ayo Ebhe ne oeli bini bhomʉ. ");
INSERT INTO mdm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Abhomʉ-o, anɨ ago matá, anɨ abhaka uo tɨla, anga djila uo adʉ me a nde alɨ tili ne ela má yikpokpo! U tsia dʉ nambɨla de me o opá pɨ anɨ pɨ-ie de. ");
INSERT INTO mdm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bhʉtsibhʉtsi na bata, anɨ ago. Anɨ apa pɨ uo me: «Yi nga bha ngala di ne naguo? A andjia, nedhɨnga akolo. Yi tsitsia nga, u apʉ́ Ndɨlɨ gba kpála mbɨa ɨnde-e pɨ obhʉlʉ siti ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yi yie bhʉ́lá, nɨ́ nʉnʉ! Yi tsitsia nga, kpála ɨnde ɨ ngapʉ ma-a, akolo!» ");
INSERT INTO mdm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bha lɨ nedhɨnga lɨ Yesu adʉ ngabha lɨe agama ’ngʉ́-o, Yuda, sʉka obhʉlʉ titima ndjɨkpa ne ká bhisi-e, akoto lɨ uo bhʉ́ dabɨlɨ bini ne okpála ɨnde adʉ sa ’kpa o ne tɨa ’gʉ́: ombotɨa ne ondula. U ago me a nde atima uo ne ongbengbe odimandɵ, ne omʉsuno na lɨ́lɨ gba Moidje di ne obhelesɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda, kpála ɨnde apʉ́ Yesu-o, adje lɨe ne uo me: «Kpála ɨnde ma anvʉ́ pabhɵ e, a ko anɨ! Yi holo anɨ, amba yi nʉ ne anɨ ne nalila anɨ ndjɨndjɨ.» ");
INSERT INTO mdm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nedhɨnga lɨ anɨ akolo lɨe, anɨ atuto lɨe de Yesu. Anɨ atsia apa pɨ anɨ me: «Labi!» Anɨ atsia anvʉ pabhɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Okpála bhe koko abu ’kpa o lɨ anɨ, u atsia aholo anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sʉka okpála ɨnde adʉ oo agbe mbotɨa gba e-o. Anɨ asʉ kpála na kulu gba bhele kpála gba odimandɵ-o , anɨ atsia akodho ’dje anɨ má tse! ");
INSERT INTO mdm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Yi ago ngʉ́ ma ne ombotɨa di ne ondula mʉgɨto me ma ne bhʉlʉ ’zi! ");
INSERT INTO mdm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma dʉ nako ndʉ ’kpɨ́ hana bhʉ́ ká yi bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda ngʉ́ nasuno, yi tsia holo ma de. Engʉ́ bini, a ko ngʉbula me engʉ́ ɨnde u aye e bhʉ́ Bhuku-o mene lɨe.» ");
INSERT INTO mdm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Abhomʉ-o, ndʉ omʉkpata hana aꞌo ká anɨ. U atsia akpekpe. ");
INSERT INTO mdm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Makombi bini adʉ akpata Yesu me anɨ nde abuku kʉte e bha ne mbʉlʉ daladeli. U aholo anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Engʉ́ bini, ngaanɨ-e, anɨ abala ’kpa lɨ daladeli-o, anɨ atsia ayiki lɨe ne holo ndumbu. ");
INSERT INTO mdm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Abhomʉ-o, u anʉ ne Yesu kala bhele kpála gba odimandɵ-o. U atsia apo bhʉ́la o ndʉ o hana: ongbengbe odimandɵ, obhelesɨ okpála di ne omʉsuno na lɨ́lɨ gba Moidje. ");
INSERT INTO mdm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piele adʉ akpata Yesu mbo tsutsu. Anɨ atsia akolo bhʉ́ mbadhasʉ gba bhele kpála gba odimandɵ-o. Anɨ adʉ kuto, anɨ atsia adʉ atʉ djua bhʉ́ dabɨlɨ bini ne omʉlila. ");
INSERT INTO mdm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","La-a, ongbengbe odimandɵ bhʉ́ dabɨlɨ bini ne Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda adʉ naao agɨlɨ kpála ɨnde agó apa ’ngʉ́ lɨ kʉte Yesu sisiti, amba o kodho ’ngʉ́ gba anɨ-e me anɨ kpi. Engʉ́ bini, u u de. ");
INSERT INTO mdm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Okpála bhelé adʉ apa ’ngʉ́ lɨ Yesu ne eu. Engʉ́ bini, ongʉ́ u adʉ apa e, a go lɨ kpadjɨ bini de. ");
INSERT INTO mdm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Okpála bini bini adʉ ayie bhʉ́lá ne napa ’ngʉ́ lɨ anɨ ne eu me: ");
INSERT INTO mdm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ya adje anɨ me anɨ nde ngapa me: ‹Ngama-a, ma abhɵ́lɵ ’tɨ Ebhe ɨnde lɨ okpála amene e ɨnde. Pɨta ’kpɨ́ bata, ma tsia yíki koko ɨnde lɨ ’kpa kpála mene e de.›» ");
INSERT INTO mdm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Engʉ́ bini, abana u adʉ apa lɨe mo-o, u dʉ adje lɨo bhʉ́ nakpokpo ’ngʉ́ ango-o de. ");
INSERT INTO mdm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Abhomʉ-o, bhele kpála gba odimandɵ-o ayie bhʉ́lá bhʉ́ ká okpála-o. Anɨ atsia ayi Yesu me: «Mʉ gie ’ngʉ́ lɨ kʉte engʉ́ u ngakpokpo e lɨ mʉ-o dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Engʉ́ bini, ngaanɨ-e, anɨ andjili bha má bulu, anɨ gie engʉ́ bini de! Bhele kpála gba odimandɵ-o atsia ayi matá anɨ me: «Mʉ ne Masɨya , Ndɨlɨ gba Ebhe ɨnde lɨ okpála ngadhɵgɵ e?» ");
INSERT INTO mdm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu agie me: «A moko, ma ne anɨ. Yi aú Ndɨlɨ gba kpála adʉ lɨ pápá na kokpa gba Angbamɨlɨ me anɨ nde ngago ne ndindi na abhʉ́lá.» ");
INSERT INTO mdm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Abhomʉ-o, bhele kpála gba odimandɵ-o asidha bongo gba e. Anɨ atsia apa me: «Nɨ́ matá ne gʉmʉ okpála koko ngʉ́ nakpokpo ’ngʉ́ gba nɨ-e ade! ");
INSERT INTO mdm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yi adje maka anɨ asobho Ebhe lɨe adje. Yi apa tété pɨ?» Abhomʉ-o, ndʉ uo hana akodho ’ngʉ́ gba anɨ-e me anɨ atɨ ne nakpi. ");
INSERT INTO mdm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bini bini bhʉ́ ká uo aholo aku ngʉsʉ lɨ anɨ. U atsia adʉ di abuku bhʉ́la anɨ, asʉ anɨ ne napa pɨ anɨ me: «Pa pɨ ya me asʉ mʉ da!» Omʉlila-a aha anɨ, u atsia aholo di nasʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nedhɨnga lɨ Piele adʉ nga bha lɨe tʉ mbadhasʉ-o, sʉka okpála na kulu bini na ɵɵlɵ gba bhele kpála gba odimandɵ ago. ");
INSERT INTO mdm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Anɨ au Piele lɨe ngatʉ djua-a, anɨ atsia anɨ má sʉʉ! Anɨ atsia apa pɨ anɨ me: «Ngamʉ di-e, mo odʉ nako bhʉ́ dabɨlɨ bini ne Yesu, kpála na Nadjaleta-o!» ");
INSERT INTO mdm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Engʉ́ bini, Piele ayaya. Anɨ atsia apa me: «Ma mbɨla de. Ma kɵ di mboli engʉ́ mʉ ngakʉnda napa e de.» Abhomʉ-o, anɨ akoto kilidjo bhʉ́ mbaladja. Pɨpɨta-a, engʉ atsia aku ’gbá. ");
INSERT INTO mdm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Engʉ́ bini, kpála na kulu na ɵɵlɵ ango-o au anɨ. Anɨ atsia apa matá bhʉ́ djila okpála ɨnde adʉ oo me: «Kpála ɨnde aoo, a ko di sʉka uo!» ");
INSERT INTO mdm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","La-a, Piele ayaya matá. Pɨta nedhɨnga masudha, okpála ɨnde adʉlʉ oo apa matá pɨ Piele me: «A ko paká, mʉ ne sʉka uo, anga ngamʉ di-e mʉ ne kpála na Galilaya.» ");
INSERT INTO mdm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Engʉ́ bini ngaanɨ-e, anɨ aholo natʉ silika ne nasɨma me: «Ma mbɨla kpála ɨnde yi ngapa ’ngʉ́ gba e mʉma bhomʉ-o de!» ");
INSERT INTO mdm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Má gala kolo me-e, engʉ atsia aku ’gbá bhʉtsibhʉtsi na bhisi. Abhomʉ-o, Piele abhundja engʉ́ ɨnde lɨ Yesu apa ɨgɨnɨ e pɨ anɨ me: «Kala me engʉ ku ’gbá bhʉtsibhʉtsi bhisi-e, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» Anɨ atsia akoto ne holo ne naku ’gbá. ");
INSERT INTO mdm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kɵkpɨ́ má bhɵ, ongbengbe odimandɵ gba Ebhe-e apo bhʉ́la o bhʉ́ bula. U adʉ bhʉ́ dabɨlɨ bini ne obhelesɨ okpála, ne omʉsuno na lɨ́lɨ gba Moidje , la di ne Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda libhomu. U agbite Yesu ne ekpʉ, u anʉ ne anɨ, u atsia aha anɨ pɨ Pɨlatɵ. ");
INSERT INTO mdm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pɨlatɵ ayi anɨ me: «Mʉ ne ’ngbé ngámá gba omaYuda?» Yesu agie pɨ anɨ me: «Mʉ ngapapa ngamʉ.» ");
INSERT INTO mdm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ongbengbe odimandɵ adʉ apa osisiti ’ngʉ́ bhelé lɨ kʉte anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Abhomʉ-o, Pɨlatɵ atsia ayi matá anɨ me: «Ndʉ ’ngʉ́ ɨnde u ngapa e lɨ kʉte mʉ ɨnde-e, mʉ gie ’ngʉ́ tété bini dɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Engʉ́ bini, Yesu gie ’ngʉ́ tété belegʉ de bini. Kaka-a, Pɨlatɵ angamba naali. ");
INSERT INTO mdm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bhʉ́ ndʉ anokomɨa na Pasɨka hana, a ayo me Pɨlatɵ tse ’kpa lɨ kpála bini ɨnde u aholo e bhʉ́ tɨkpʉ-o pɨ omaYuda. A ayo me a adʉ bhende lɨ okpála ayó me Pɨlatɵ tse ’kpa lɨ e ko. ");
INSERT INTO mdm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A abhaka me kpála bini ɨnde u aꞌɨ e me Balabasɨ nde bhʉ́ tɨkpʉ. A adʉ me u nde aholo anɨ bhʉ́ dabɨlɨ bini ne okpála na kpekpeke ’ndjɨ me u nde abhɵlɵ kpála bini bhʉ́ nedhɨnga u agbe kpéke ’ndjɨ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Abhomʉ-o, bhiti okpála anʉ abhaka Pɨlatɵ, u atsia aholo nayo me Pɨlatɵ mene pɨ o maka anɨ amemene lɨe gɵmɵ gɵmɵ-o. ");
INSERT INTO mdm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pɨlatɵ agie pɨ uo me: «Yi akʉnda me ma tse ’kpa lɨ ’ngbé ngámá gba omaYuda pɨ yi?» ");
INSERT INTO mdm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Padhá de, anga anɨ adʉ ambɨla ndjɨndjɨ me ongbengbe odimandɵ apʉ Yesu, anga okpála adʉ ne mʉkʉnda naali pɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Abhomʉ-o, ongbengbe odimandɵ atsia ato bhʉ́ okpála bhelé me u yo me Pɨlatɵ tse mangbo ’kpa lɨ Balabasɨ. ");
INSERT INTO mdm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pɨlatɵ atsia ayi bha matá uo me: «A ayo la me ma mene ngʉ́ kpála bhende yi ngaꞌɨ e me ’ngbé ngámá gba omaYuda-a pɨ?» ");
INSERT INTO mdm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Okpála bhomʉ-o atsia agie ne nasʉsʉla me: «Gɨ anɨ lɨ kulusi!» ");
INSERT INTO mdm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pɨlatɵ atsia adʉ ayi uo me: «Anɨ amene la mangua siti ’ngʉ́ dho?» U asʉsʉla matá kpekpeke naali ne naꞌeꞌe ’li o ne abhʉ́lá me: «Gɨ anɨ lɨ kulusi!» ");
INSERT INTO mdm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Abhomʉ-o, Pɨlatɵ atse ’kpa lɨ Balabasɨ pɨ uo, amba nɨ atsógbolo bua uo de. Anɨ aha lɨ́lɨ me u bhɨ Yesu ne fimbo, pɨpɨta-a, anɨ atsia aha anɨ pɨ uo me u gɨ anɨ lɨ kulusi gɨgɨ. ");
INSERT INTO mdm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abhomʉ-o, osʉdha aha Yesu, u atsia anʉ ne anɨ tʉ mbadhasʉ gba Pɨlatɵ. U aꞌɨ ndʉ osʉdha koko hana. ");
INSERT INTO mdm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","U ato bongo na zʉmbe zʉmbe lɨ kʉte anɨ, u atsia agala ehe na eti má kilili, u aha-a, a ato bhʉ́ ’ndjɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","U atsia aholo nayi anɨ me: «’Ngbé ngámá gba omaYuda, atou!» ");
INSERT INTO mdm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","U adʉ abhɨ ’ndjɨ anɨ ne mbamba, u atsia adʉ aku ngʉsʉ lɨ kʉte anɨ. U atʉtʉ lɨpʉkʉ o kuto, u atsia adʉ atɨ kala anɨ. ");
INSERT INTO mdm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pɨta u amʉ anɨ lɨe má tsɨkɨ tsɨkɨ-e, u agbe bongo na zʉmbe zʉmbe-e lɨ kʉte anɨ, u atsia agie obongo gba anɨ-e pɨ anɨ. Pɨpɨta-a, u atsia agbe anɨ kilidjo ngʉbula nagɨ anɨ lɨ kulusi. ");
INSERT INTO mdm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Abhomʉ-o, osʉdha aholo kpála bini ne kpéke me anɨ bɨ kulusi gba Yesu-o. A adʉ ’lɨ kpála ango-o me Simo, a adʉ ’dyɨ Alekɨdjandele ngauo ne Lufusɨ. A adʉ kpála na gʉdhʉ na Silene. U aholo anɨ me anɨ nde ngakodho ’kpɨ́ oo nedhɨnga anɨ adʉ agie lɨe lɨe abhiye-o. ");
INSERT INTO mdm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","U anʉ ne Yesu lɨ bɨlɨ ɨnde u aꞌɨ e me Gologota, (a akʉnda napa me «bɨlɨ na pelege ’ndjɨ»). ");
INSERT INTO mdm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","U adʉ akʉnda naha vino ɨnde u akpɵtsɵ e ne mila pɨ anɨ. Engʉ́ bini, Yesu ndjɨ de. ");
INSERT INTO mdm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","U agɨ anɨ lɨ kulusi. U agbogbo bhʉsʉ o lɨ obongo gba anɨ-e me u nde agʉ ngaɨza tété gbanda ngʉ́ nambɨla bhende a ayo me kpála bini ne bini sia e ko. ");
INSERT INTO mdm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","U agɨ Yesu lɨ kulusi bhʉ́ saa na odukpabini kala tulukpe. ");
INSERT INTO mdm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Balʉa ɨnde u aye e ngʉ́ nasuno ta mangɨmbo gba anɨ-e aye nanɨ lɨe me: «’Ngbé ngámá gba omaYuda.» ");
INSERT INTO mdm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","U atsia agɨ la di bhʉ́ dabɨlɨ bini ne anɨ-e, obhʉlʉ ’zi bhisi ɨnde adʉ agbʉlʉ ’he gba okpála ne kpéke. Bini adʉ lɨ kulusi gba e lɨ pá ’kpa anɨ na kokpa. Koko atsia adʉ lɨ kulusi gba e lɨ pá ’kpa anɨ na galɨ.  ");
INSERT INTO mdm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Abhomʉ-o, eli gba Ebhe ɨnde aye lɨe bhʉ́ Bhuku gba anɨ-e me: «U ato ’lɨ anɨ bhʉ́ ká okpála na sisiti-e», atsia amene lɨe. ");
INSERT INTO mdm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Okpála ɨnde adʉ akodho ’kpɨ́ oo adʉ asosobho anɨ. U adʉ ako ’ndjɨ o, u atsia adʉ apa me: «He-e! Ngamʉ, kpála ɨnde abhɵ́lɵ ’ngbé ’tɨ Ebhe gba omaYuda, ɨ tsia yíki sʉnda ’kpɨ́ bata-a, ");
INSERT INTO mdm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kobho lɨmʉ ngamʉ makpe, amba mʉ yie lɨ kulusi-e kɵ kuto.» ");
INSERT INTO mdm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ongbengbe odimandɵ gba Ebhe di ne omʉsuno na lɨ́lɨ gba Moidje adʉ bhadi namʉ anɨ moko. U adʉ apa sʉnda o me: «Anɨ akobho okpála koko, anɨ tɨ da nakobho lɨe ngae makpe dɨ! ");
INSERT INTO mdm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mbɨa ɨnde-e, a ayo me Masɨya , ’ngbé ngámá gba omaƗsalaele yie lɨ kulusi, ya u, amba ya bhuka.» Obhende u agɨ o ne lɨ okulusi gba o dengo anɨ-e adʉ bhadi namʉ anɨ moko. ");
INSERT INTO mdm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tulukpe-e, biti akɵ pɨ́ doto libhomu, nakolo pɨ saa na bata pɨta tulukpe. ");
INSERT INTO mdm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Abhomʉ-o, bhʉ́ saa na bata-a, Yesu asʉla kpekpeke me: «Eloi, Eloi, lama sabakatanɨ?» (A akʉnda napa me, «Ebhe gba ma, Ebhe gba ma, mo oꞌo ká ma ka nɨ?») ");
INSERT INTO mdm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bini bini bhʉ́ ká okpála ɨnde adʉ oo adje anɨ lɨe, u atsia apa me: «Yi djedje, anɨ ngaꞌɨ Elɨya!» ");
INSERT INTO mdm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sʉka kpála bini agu holo. Anɨ anʉ azɨ epondje bhʉ́ kpongadha pandɨ. Anɨ agbite lɨ kʉte mbamba. Anɨ atsia aha pɨ anɨ me anɨ ndjɨ ne napa pɨ obɨ e me: «Ayó nga! Nɨ́ tsia nga ne me Elɨya agó ngʉ́ nakɵ anɨ lɨ kulusi-e kuto.» ");
INSERT INTO mdm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Engʉ́ bini, Yesu asʉla kpekpeke. Anɨ atsia akpi. ");
INSERT INTO mdm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Abhomʉ-o, lido ɨnde adʉ agbo bhʉsʉ ’ngbé ’tɨ Ebhe-e asidha bhʉsʉ e bhisi má tsʉe nayie abhʉ́lá, akolo akuto! ");
INSERT INTO mdm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ngámá gba osʉdha kámá bini ɨnde adʉ bhʉ́la anɨ au lele maka anɨ akpi lɨe, anɨ atsia apa me: «Kpála ɨnde-e bha ndjʉ nako ne ndɨlɨ gba Ebhe kʉkʉlʉ!» ");
INSERT INTO mdm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Olɨsɨ bini bini adʉ di oo. U adʉ atsia ’ngʉ́ bhomʉ-o mbo tsutsu. Bhʉ́ ká uo-o, a adʉ nanɨ Malɨa , kpála na gʉdhʉ na Magadala, Malɨa , ’hi Djodje ngauo ne Djakɨ bhe na makombi makombi-o, a la di-e Salome. ");
INSERT INTO mdm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nedhɨnga lɨ Yesu adʉ lɨe bhʉ́ Galilaya-a, olɨsɨ bhomʉ-o adʉ adhʉkʉ bhʉ́ dabɨlɨ bini ne anɨ. U atsia adʉ di ateteke anɨ. Olɨsɨ koko bhelé ɨnde ayie nanɨ ne anɨ bhʉ́ Yelusalema adʉ di oo. ");
INSERT INTO mdm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A adʉ ɨbili tagolo. A abhaka la lɨe me a nde ekpɨ́ naleke lɨo ngʉ́ anokomɨa-a, a akʉnda napa me ekpɨ́ kala ekpɨ́ naguo gba omaYuda-a , ");
INSERT INTO mdm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","sʉka okpála na Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda ago. A adʉ ’lɨ anɨ me Djodjefʉ , kpála na gʉdhʉ na Alimatayo. A adʉ kpála nakpe makpe. Anɨ adʉ di adjeke Naʉ gba Ebhe-o . Anɨ atsia asia kpéke bua ngʉ́ nalɨ agba Pɨlatɵ ngʉ́ nanʉ ayo kuo Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pɨlatɵ angamba naali nadje me Yesu akpi kolo akpi-o. Abhomʉ-o, anɨ aꞌɨ ngámá gba osʉdha-o. Anɨ atsia ayi anɨ me anɨ akpi ɨgɨnɨ bhʉtode i-e. ");
INSERT INTO mdm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pɨta nagie ’ngʉ́ tété ka ngámá gba osʉdha-a, Pɨlatɵ azɨba pɨ Djodjefʉ naha kuo Yesu. ");
INSERT INTO mdm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Abhomʉ-o, Djodjefʉ akala daladeli ɨnde u amene e lɨ lene. Anɨ akɵ kuo Yesu lɨ kulusi-e kuto. Anɨ atsia agagala ne daladeli bhomʉ. Anɨ anʉ aꞌo bhʉ́ lata ɨnde adʉ me u nde adjɨ e bhʉ́ teme-o. Anɨ awawala ’ngbé teme lɨ bhɵbhɵ. ");
INSERT INTO mdm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malɨa, kpála na gʉdhʉ na Magadala ngauo ne Malɨa, ’hi Djodje adʉ atsia bɨlɨ u aꞌo anɨ lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lɨ ekpɨ́ naguo gba omaYuda akodho ’kpɨ́ lɨe, Malɨa , kpála na gʉdhʉ na Magadala, ne Malɨa , ’hi Djakɨ, bhʉ́ dabɨlɨ bini ne Salome, akala emʉ ɨnde bhʉ́ e ne mʉngotsi ngʉ́ nanʉ apulu kʉte kuo Yesu ne di. ");
INSERT INTO mdm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Abhomʉ-o, bhʉ́ ’kpɨ́ yinga kɵkpɨ́ má bhɵ́-o, nedhɨnga lɨ ela adʉ akoto lɨe, u anʉ abhʉ́ lata. ");
INSERT INTO mdm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","U adʉ apa sʉnda o me: «A atʉ́mba teme ɨnde lɨ ’bhɵ lata-a pɨ nɨ́ da?» ");
INSERT INTO mdm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Engʉ́ bini, u atsia ’kpɨ́ lɨe me-e, u au me teme bhomʉ-o atʉmba lɨe atʉmba. Abana a adʉ lɨe ngbéngbé. ");
INSERT INTO mdm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","U alɨ lɨe bhʉ́ lata-a, u au makombi bini ato ’ndjá yambu na bubu me anɨ nde adʉ lɨ pápá na kokpa. U atsia adje tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Engʉ́ bini, makombi bhomʉ-o apa pɨ uo me: «Yi adjé tsʉlʉ de. Yi ngagɨlɨ Yesu, kpála na Nadjaleta, ɨnde u agɨ nako e lɨ kulusi-o. Anɨ azuku. Anɨ sɨɨ ade. Yi tsia nga bɨlɨ nako u aꞌo anɨ lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yi nʉ pa mangbo pɨ omʉkpata gba anɨ di ne Piele me: ‹Anɨ akodho ’kpɨ́ pɨ yi bhʉ́ Galilaya kalanʉ. Yi aú anɨ oo maka anɨ apa nako pɨ yi lɨe ko.›» ");
INSERT INTO mdm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Abhomʉ-o, u aze bhʉ́ lata-a ne holo kilidjo, anga mabhundja gba uo angbɨngɨ, kʉte uo atsia adʉ agʉkʉ. U tsia pa pɨ kpála de, anga u adʉ ne tsʉlʉ.  ");
INSERT INTO mdm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Lɨ Yesu azuku lɨe bhʉ́ ’kpɨ́ yinga kɵkpɨ-e, anɨ akoto ngaɨza lɨ Malɨa, kpála na gʉdhʉ na Magadala, ɨnde anɨ apandja nanɨ osisiti bua mananɨka bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Malɨa anʉ napapa pɨ okpála ɨnde adʉ nanɨ bhʉ́ dabɨlɨ bini ne Yesu-o. U adʉ ne lɨkabhu, u atsia adʉ di aku ’gbá. ");
INSERT INTO mdm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Engʉ́ bini, lɨ okpála bhomʉ-o adje lɨe me anɨ ʉʉ, di ne me Malɨa au anɨ-e, u bhuka anɨ de. ");
INSERT INTO mdm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pɨpɨta-a, Yesu asuno matá lɨe maka kpála koko pɨ omʉkpata bhisi ɨnde adʉ lɨ kpadjɨ ngʉ́ nanʉ akʉtɨ-o. ");
INSERT INTO mdm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Abhomʉ-o, obhobhomʉ-o ago apa pɨ okoko-o. Engʉ́ bini, okoko bhuka uo de. ");
INSERT INTO mdm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lɨ soso-o, Yesu atsia asuno lɨe pɨ obhʉlʉ titima gba e ndjɨkpa ne ká bini-e me u nde ngazʉ ’he. Abhomʉ-o, anɨ atsia agbele ’dje uo ka ndɨ nabhuka di ne kpéke ’ndjɨ gba uo-o. Padhá de, anga u bhuka nanɨ okpála ɨnde au anɨ me anɨ nde azuku-o de. ");
INSERT INTO mdm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Abhomʉ-o, anɨ atsia apa pɨ uo me: «Yi nʉ pɨ́la doto libhomu nakpokpo Bádha Ngali pɨ ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kpála ɨnde abhúka-a, ɨnde asía la di batisimo-o, anɨ kóbho. Kpála bhende ɨ bhúka de-e, asía mangɨmbo. ");
INSERT INTO mdm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A ɨnde-e ongʉ́ ɨnde adhʉ́kʉ bhʉ́ dabɨlɨ bini ne obhende abhúka-o: u apándja osisiti bua bhʉ́ okpála ne ’lɨ ma, u agáma ’ngʉ́ bhʉ́ odikongʉ na mbɨa. ");
INSERT INTO mdm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","U ahólo okpʉlʉ ne ’kpa o. Ɨ dʉ di me u nde andjɨ elá na bhɵlɵ kpála-a, a améne ’he bini ngʉ́ uo de. U aꞌó ’kpa o pɨ́ ’ndjɨ okpála na kuo, lɨ okpála na kuo ango-o kóbho.» ");
INSERT INTO mdm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pɨta napa ongʉ́ bhomʉ-o pɨ uo-o, Ebhe aha Ngámá Yesu abhʉ́lá. Anɨ atsia adʉ kuto lɨ pá ’kpa Ebhe na kokpa. ");
INSERT INTO mdm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abhomʉ-o, omʉkpata-a atsia anʉ naao nakpokpo Bádha Ngali ne ndʉ bɨlɨ hana. Ngámá adʉ ateteke uo bhʉ́ okulu bhomʉ-o hana. Ongamba ’ngʉ́ ɨnde u adʉ amene e adʉ di asuno me nasuno ɨnde u ngasuno e-e, a ko ’ngʉ́ na paká.");
INSERT INTO mdm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ndai ma na mʉkʉnda Tɨofile, Okpála bhelé ale naye todʉ na ongʉ́ ɨnde akodho ’kpɨ́ bhʉ́ ká ya-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","U aye ongʉ́ ango-o maka lɨ okpála ɨnde au nayie lɨ lilita-a, akpokpo pɨ ya lɨe ko. A ko okpála ɨnde adʉ nakpokpo eli gba Ebhe-o . ");
INSERT INTO mdm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kaka-a, ngama di-e, pɨta nagɨlɨ ’ngʉ́ tété má bhotobhoto nayie lɨ dʉdʉ-o, ma au ndjɨndjɨ me, ma kpokpo kúkú pɨ mʉ lɨ lelele, bhele kpála Tɨofile, maka lɨ ongʉ́ ango-o akodho ’kpɨ́ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma kpokpo kúkú pɨ mʉ, amba mʉ mbɨla kʉkʉlʉ ’ngʉ́ na ongʉ́ ɨnde u asuno e pɨ mʉ ko. ");
INSERT INTO mdm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bhʉ́ nedhɨnga lɨ Elode adʉ lɨe ’ngbé ngámá na ndu doto na Yudaya-a, dimandɵ bini gba Ebhe-e adʉ oo. A adʉ ’lɨ anɨ me Djakalɨa, anɨ adʉ bhʉ́ libi odimandɵ gba Abɨa. A adʉ ’lɨ wala anɨ me Alɨdjabhetɨ, anɨ adʉ bhʉ́ piga gba ’ngbé dimandɵ Alona. ");
INSERT INTO mdm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ndʉ uo bhisi hana adʉ bhʉ́ djila Ebhe ngbingbili. U atsia adʉ amene ndʉ lɨ́lɨ gba Ngámá Ebhe-e hana. ");
INSERT INTO mdm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Engʉ́ bini, ndɨlɨ dʉ ka uo de, anga Alɨdjabhetɨ adʉ ne ɨzude. La di-e, u adʉ ndʉ o bhisi hana me u nde agbegbe. ");
INSERT INTO mdm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ekpɨ́ bini, Djakalɨa adʉ amene kulu na dimandɵ gba e kala Ebhe, anga adʉ ekpɨ́ na libi gba uo-o ngʉ́ namemene. ");
INSERT INTO mdm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Maka lɨ odimandɵ adʉ amemene lɨe, Djakalɨa atsia asia ngasa ngʉ́ nanʉ natsulu mʉngotsi pɨ Ebhe abhʉ́ ’ngbé ’tɨ gba Ngámá Ebhe, bhʉ́ tɨtɨna na bubu-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nedhɨnga anɨ adʉ atsutsulu lɨe, ndʉ okpála hana adʉ ayo Ebhe akilidjo. ");
INSERT INTO mdm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Abhomʉ-o, kolo má gala me-e, andjelu gba Ngámá Ebhe-e akoto lɨ anɨ. Anɨ alʉ de bɨlɨ natsulu mʉngotsi-e ne lɨ pápá na kokpa. ");
INSERT INTO mdm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lɨ Djakalɨa au anɨ lɨe me-e, tsʉlʉ aholo amene anɨ, mabhundja gba anɨ-e atsia angbɨngɨ. ");
INSERT INTO mdm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Engʉ́ bini, andjelu-o apa pɨ anɨ me: «Djakalɨa, mo odjé tsʉlʉ de, anga Ebhe adje nayo gba mʉ-o adje. Wala mʉ Alɨdjabhetɨ azú pɨ mʉ ndɨlɨ na bhobhoko. Mo ogísila ’lɨ anɨ me Djaa . ");
INSERT INTO mdm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mo odʉ́ ne djalɨ naali, lɨ okpála bhelé tsia kpí di djalɨ ka nazu anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Anɨ adʉ́ ’ngbé kpála bhʉ́ djila Ebhe. Anɨ ndjɨ́ vino de, anɨ ndjɨ́ di pandɨ na kpekpeke de. Anɨ abédhe ne Bu Bhobua me anɨ nde nga bha bhʉ́ ’bu ’hi e. ");
INSERT INTO mdm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anɨ agíe ongɨsɨ na Ɨsalaele bhelé lɨ pápá gba Ebhe, Ngámá gba o-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anɨ adʉ́ amene kulu kala Ebhe bhʉ́ dabɨlɨ bini ne bua di ne angu maka Polofeta Elɨya. Anɨ aléke engʉ́ sʉnda odyɨ ongɨsɨ ne ongɨsɨ gba o-o. Anɨ adjí mabhundja gba okpála na kpekpeke ’ndjɨ, u tsia kólo ngbingbili, ngʉbula naleke okpála ɨnde bedhe pɨ Ebhe Ngámá.» ");
INSERT INTO mdm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Abhomʉ-o, Djakalɨa ayi andjelu-o me: «Ma ambɨ́la la lele pɨ me a ko kʉkʉlʉ ’ngʉ́-o? Padhá de, anga ma agbe, wala ma akolo la di ne kalanga bhelé.» ");
INSERT INTO mdm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Andjelu-o atsia agie pɨ anɨ me: «Ngama-a, ma ne Gabiele, ndʉ ’kpɨ́ hana ma dʉdʉ de Ebhe. Anɨ atima ma me ma go kpokpo bádha ngali ɨnde-e pɨ mʉ. ");
INSERT INTO mdm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Engʉ́ bini, lɨ mʉ bhuka engʉ́ ma apa e pɨ mʉ-o lɨe de-e, kaka-a, ’bhɵ mʉ aní, mʉ tɨ́ da nagama ’ngʉ́ belegʉ de bini akólo lɨ ’kpɨ́ lɨ ongʉ́ ango-o améne lɨe lɨe ko. Engʉ́ ɨnde améne lɨe na paká lɨ nedhɨnga lɨ Ebhe aꞌo e-o.» ");
INSERT INTO mdm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lɨ nedhɨnga bhomʉ-o, okpála adʉ adjeke Djakalɨa, u adʉ angamba ka anɨ adʉ abhue lɨe bhʉ́ ’tɨ Ebhe oo naali-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Anɨ akoto lɨe, anɨ ale nagama ’ngʉ́ pɨ uo pima. Abhomʉ-o, u atsia ambɨla me oo, anɨ au engʉ́ na ngangamba gba Ebhe-e au. Anɨ adʉ asuno ’ngʉ́ pɨ uo ne ’kpa e, anɨ tɨ da nagagama ne ’bhɵ e de. ");
INSERT INTO mdm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lɨ nedhɨnga na kulu gba anɨ andjia lɨe, anɨ atsia agie lɨe agba e. ");
INSERT INTO mdm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pɨta nedhɨnga bhomʉ-o, wala anɨ Alɨdjabhetɨ atsia abɨ ’bhɨ. Anɨ awo nga bha lɨe ngʉbula epe bhuluvue libhomu. Anɨ adʉ apa me: ");
INSERT INTO mdm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Tsia nga engʉ́ ɨnde lɨ Ngámá Ebhe amene e mʉma-o. Anɨ abhundja ma. Mbɨa ɨnde-e, anɨ aꞌe ehe ɨnde nako adʉ aha nʉmʉ mʉma bhʉ́ ká djila okpála aꞌe.» ");
INSERT INTO mdm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lɨ ebhɨ gba Alɨdjabhetɨ akolo lɨe ne epe madhɨa-a, Ebhe atima andjelu Gabiele bhʉ́ kʉtɨ bini na ndu doto na Galilaya, ɨnde ’lɨ e me Nadjaleta. ");
INSERT INTO mdm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anɨ atima anɨ gba tsangba bini ɨnde adʉ adjeke naha lɨe ne bhoko bini. A adʉ ’lɨ bhoko ango-o me Djodjefʉ , anɨ adʉ bhʉ́ piga gba ’ngbé ngámá Davidi. Tsangba ango-o, a adʉ ’lɨ anɨ me Malɨa . ");
INSERT INTO mdm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Andjelu-o alɨ agba anɨ, anɨ atsia ayi anɨ me: «Mʉ oo! Ngamʉ ɨnde asia bádha bhʉ́ ’bu gba Ebhe-e , Ngámá Ebhe bhʉ́ dabɨlɨ bini ne mʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malɨa angamba ka eli bhomʉ-o naali. Anɨ adʉ ayi bua e me: «Ta nayi ɨnde-e pɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Abhomʉ-o, andjelu-o atsia apa pɨ anɨ me: «Malɨa, mo odjé tsʉlʉ de, anga mo osia bádha bhʉ́ ’bu gba Ebhe-e asia. ");
INSERT INTO mdm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tsia nga, mo obɨ́ ’bhɨ, mʉ zú ndɨlɨ na bhobhoko, mʉ tsia gísila ’lɨ anɨ me Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Anɨ adʉ́ ’ngbé kpála, u tsia dʉ́ aꞌɨ anɨ me, Ndɨlɨ gba Apɨ́ ’Kpɨ́. Ebhe Ngámá aꞌó me anɨ ʉ maka ogbi e Davidi. ");
INSERT INTO mdm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Anɨ aʉ́ dʉdʉma ne dʉdʉma pɨ́ piga gba omaƗsalaele. Naʉ gba anɨ-e ndjía de.» ");
INSERT INTO mdm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malɨa atsia ayi andjelu-o me: «Engʉ́ ango-o améne lɨe lele pɨ? Padhá de, anga ma kʉnda nga naama bhoko de!» ");
INSERT INTO mdm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Andjelu-o agie pɨ anɨ me: «Bu Bhobua agó pɨ́ mʉ, lɨ angu gba Ebhe Apɨ́ ’Kpɨ́ búku mʉ maka kulu zini. Kaka-a, ndɨlɨ ɨnde mo ozú e adʉ́ bubu, u atsia dʉ aꞌɨ́ anɨ me, Ndɨlɨ gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tsia nga okala mʉ Alɨdjabhetɨ di ne ebhɨ. Anɨ azú ndɨlɨ na bhobhoko, abana anɨ nde lɨe ne kalanga bhelé. Kpála nako u adʉ aꞌɨ e me ɨzude-o. Mbɨa ɨnde-e, ebhɨ gba anɨ-e ɨbili ne epe madhɨa, ");
INSERT INTO mdm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","anga kpéke da ’ngʉ́ pɨ Ebhe belegʉ ade bini.» ");
INSERT INTO mdm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Abhomʉ-o, Malɨa atsia apa me: «Ma ne bali gba Ngámá. A ayo me ndʉ ’ngʉ́ mo opa e hana, a mene lɨe mʉma moko.» Pɨpɨta-a, andjelu-o atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bha bhʉ́ oekpɨ́ bhomʉ-o, Malɨa ayie, anɨ anʉ má gala bhʉ́ kʉtɨ bini na ndu doto na ndʉ ká eta na Yudaya. ");
INSERT INTO mdm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Anɨ akolo lɨe oo, anɨ alɨ bhʉ́ ’tɨ gba Djakalɨa, anɨ atsia ayi Alɨdjabhetɨ. ");
INSERT INTO mdm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lɨ Alɨdjabhetɨ adje maka lɨ Malɨa ayi anɨ lɨe me-e, ndɨlɨ-e atsia atɨlɨ bhʉ́ ’bu anɨ. Abhomʉ-o, Alɨdjabhetɨ atsia abedhe ne Bu Bhobua. ");
INSERT INTO mdm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Anɨ atsia asʉla kpekpeke me: «Ebhe aha bisagu pɨ mʉ ane ndʉ olɨsɨ hana, bisagu gba anɨ-e di pɨ́ ndɨlɨ ɨnde mo ozú e-o! ");
INSERT INTO mdm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma ne da me ’hi Ngámá gba ma-a go tsia ma-a? ");
INSERT INTO mdm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tsia nga, lɨ nedhɨnga ɨnde ma adje maka mo oyi ma lɨe me-e, ndɨlɨ ɨnde bhʉ́ ’bu ma-a atɨlɨ ne djalɨ hana. ");
INSERT INTO mdm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A ko djalɨ pɨ mʉ, ngamʉ ɵlɵ ɨnde abhuka! Padhá de, anga engʉ́ ɨnde lɨ Ebhe apa e pɨ mʉ-o, améne lɨe mamene.» ");
INSERT INTO mdm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Abhomʉ-o Malɨa atsia atoko Ebhe me: «Bua ma ngadhɵgɵ Ngámá, ");
INSERT INTO mdm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","bua ma abedhe ne djalɨ pɨ Ebhe Mʉkobho gba ma-o, ");
INSERT INTO mdm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","anga anɨ abhundja ma, bali gba e-e ko. A moko, nayie pɨ mbɨa ɨnde-e, ndʉ opiga hana adʉ́ aꞌɨ ma me, ma ne ɵlɵ ɨnde asia bisagu ka Ebhe, ");
INSERT INTO mdm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","anga Ebhe na Angu amene ongʉ́ na ngbengbengbe mʉma. A ko Ebhe na bubu, ");
INSERT INTO mdm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ndjinga gba anɨ-e ngadʉ dʉdʉma ne dʉdʉma pɨ okpála ɨnde ngakpe anɨ ko. ");
INSERT INTO mdm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anɨ amene ngbengbe ’ngʉ́ ne angu gba e-o. Anɨ atsambala okpála na ’ngbé bua. Anɨ atsia amene me mabhundja gba uo-o kolo padhá. ");
INSERT INTO mdm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anɨ akɵ ongbengbe ongámásɨ ne kuto, anɨ atsia aꞌeꞌe okpála na padhá ne abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anɨ aha ehe bhelé pɨ obhende adʉ ne gʉmʉ-o, anɨ atsia agie obhʉlʉ tɨa ne ’kpa o padhá. ");
INSERT INTO mdm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Anɨ ateteke omaƗsalaele, obalise gba e-o. Anɨ ꞌɨlɨ ’to e de lɨ nasuno bádha ’ngʉ́ gba e ndʉ ’kpɨ́ hana, ");
INSERT INTO mdm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","maka nanɨ anɨ apa lɨe pɨ onguo ogbi nɨ́ Abalahama ne opiga gba e-o.» ");
INSERT INTO mdm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malɨa asɨ ne Alɨdjabhetɨ masɨkpe de epe bata. Pɨpɨta-a, anɨ atsia agie lɨe agba e. ");
INSERT INTO mdm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lɨ nedhɨnga nazu ka Alɨdjabhetɨ akolo lɨe, anɨ atsia azu ndɨlɨ na bhobhoko. ");
INSERT INTO mdm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lɨ okpála ɨnde asɨlɨ kʉtɨ dengo anɨ-e, di ne obhe na piga gba anɨ-e adje lɨe me, Ebhe adje bha ndjʉ ndjinga anɨ-e, u atsia adʉ akpi djalɨ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pɨta poso bini-e, u ago ngʉ́ nato ndɨlɨ-e bhʉ́ gandja. U adʉ akʉnda nagisila ’lɨ ’dyɨ anɨ Djakalɨa. ");
INSERT INTO mdm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Abhomʉ-o, ’hi anɨ atsia apa me: «A mo-o ade, adʉ́ ’lɨ anɨ me Djaa.» ");
INSERT INTO mdm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","U atsia apa pɨ anɨ me: «Bhʉ́ piga gba mʉ-o, kpála bini ɨnde ne ꞌɨlɨ bhomʉ-o ade.» ");
INSERT INTO mdm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Abhomʉ-o, u atsia amene ’kpa o pɨ ’dyɨ anɨ ngʉ́ nayi anɨ me anɨ akʉnda me u gisila ’lɨ ndɨlɨ-e pɨ. ");
INSERT INTO mdm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Djakalɨa amene ’kpa e pɨ uo me u go pɨ nɨ́ ne pála ndula, anɨ atsia aye pépé me: «A ’lɨ anɨ me Djaa.» Ndʉ uo hana atsia angamba naali. ");
INSERT INTO mdm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bha lɨ nedhɨnga bhomʉ-o, ’bhɵ anɨ abhulu, anɨ aholo nagama ’ngʉ́, di ne nadhɵgɵ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abhomʉ-o, ndʉ okpála hana ɨnde asɨlɨ kʉtɨ lɨngo uo-o, aholo adje tsʉlʉ. Ngali na engʉ́ ango-o atsia aya bhʉ́ ndu doto na ndʉ ká eta na Yudaya libhomu. ");
INSERT INTO mdm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndʉ okpála hana ɨnde adʉ adjedje-e, adʉ abhundja pépé, u atsia adʉ apa me: «Mbo! Ndɨlɨ ango-o, adʉ́-e maka da?» Angu gba Ebhe-e adʉ bha ndjʉ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Djakalɨa, ’dyɨ ndɨlɨ-e, abedhe ne Bu Bhobua. Abhomʉ-o, anɨ atsia aholo nakpokpo ’ngʉ́ maka polofeta me: ");
INSERT INTO mdm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«A ayo me, u dhɵgɵ Ebhe, Ngámá gba omaƗsalaele-o, anga anɨ abhundja okpála gba e, anɨ atsia agbegbe uo bhʉ́ bali. ");
INSERT INTO mdm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anɨ atima kpála na angu bini bhʉ́ piga gba Davidi, bali gba e, ngʉ́ nakobho ya. ");
INSERT INTO mdm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A bhomʉ-o engʉ́ ɨnde anɨ apa nanɨ e didili bhʉ́ ’li obubu opolofeta gba e-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Anɨ apa nanɨ me, nɨ akóbho nɨ́ sa ’kpa ndʉ obhʉlʉ yala gba nɨ́-e hana, di ne obhende ngakʉnda amene nɨ́ sisiti-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anɨ adje ndjinga onguo ogbi nɨ́, anɨ atsia abhundja di gandja na bubu gba e-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Silika nanɨ ɨnde anɨ atʉ e pɨ ogbi nɨ́ Abalahama-a, anɨ améne pɨ nɨ́ mamene. ");
INSERT INTO mdm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Pɨta nakobho nɨ́ sa ’kpa obhʉlʉ yala ngʉbula me nɨ́ améne kulu pɨ nɨ ne tsʉlʉ de, ");
INSERT INTO mdm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","amba nɨ́ dhɵgɵ nɨ ne bua nɨ́ hana. Nɨ́ dʉ di bhʉ́ djila nɨ ngbingbili ndʉ ’kpɨ́ hana bhʉ́ mʉkobho gba nɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pɨ mʉ-o, ndɨka ma, u adʉ́ aꞌɨ mʉ me, polofeta gba Apɨ́ ’Kpɨ́, anga mo onʉ́ kalanʉ ngʉ́ naleke kpadjɨ gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mo osúno pɨ okpála gba anɨ-e me, anɨ aꞌé siti ’ngʉ́ ɨnde bhʉ́ uo-o maꞌe, anɨ tsia kóbho di uo. ");
INSERT INTO mdm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","A ko anga Ebhe gba nɨ́-e abedhe ne ndjinga bedhe, kaka-a, anɨ atíma zɨ ’kpɨ́ pɨ́ nɨ́ maka zɨ ’ndjɨ ’la na kɵkpɨ́. ");
INSERT INTO mdm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Anɨ asúno lɨe pɨ obhende bhʉ́ biti di ne obhende ne tsʉlʉ kuo, ngʉbula me nɨ́ dhʉkʉ lɨ kpadjɨ na guo ’ngʉ́ .» ");
INSERT INTO mdm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ndɨlɨ-e adʉ abhele, anɨ atsia adʉ asia kpéke bua. Anɨ adʉ nadʉ bhʉ́ omili bɨlɨ akolo lɨ ’kpɨ́ ɨnde anɨ asuno lɨe lɨe mbámbá pɨ omaƗsalaele ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lɨ nedhɨnga bhomʉ-o, Agosite, ’ngbé ngámá na Loma , aha lɨ́lɨ me u ye ’lɨ okpála hana ɨnde pɨ́la doto gba nɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gina naye ’lɨ okpála ango-o amene lɨe me Kiliniusɨ nde ne ’ngbé ngámá na Silia. ");
INSERT INTO mdm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndʉ okpála hana adʉ anʉ me u ye ’lɨ o. Abhomʉ-o, kpála ne kpála atsia anʉ bhʉ́ kʉtɨ u azu anɨ bhʉ́ e ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Djodjefʉ ayie bhʉ́ kʉtɨ na Nadjaleta, bhʉ́ ndu doto na Galilaya, ngʉ́ nanʉ bhʉ́ ndu doto na Yudaya, bhʉ́ kʉtɨ ɨnde u aꞌɨ e me Beteleme. A ko bɨlɨ ɨnde u azu ’ngbé ngámá Davidi lɨe-o, anga ngaanɨ makpe, anɨ dʉ nanɨ bhʉ́ piga gba Davidi ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Anɨ anʉ oo me u ye ’lɨ nɨ, bhʉ́ dabɨlɨ bini ne Malɨa , ɵlɵ ɨnde anɨ adʉ adjeke naha e ko. Ɵlɵ ango-o adʉ ne ebhɨ. ");
INSERT INTO mdm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","U adʉ lɨe abhʉ́ Beteleme-e, ekpɨ́ nazu ka anɨ atsia akolo. ");
INSERT INTO mdm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Anɨ azu ndɨlɨ na bhobhoko, gina ndɨlɨ gba e ko. Anɨ agagala anɨ ne bongo , anɨ atsia aseke anɨ bhʉ́ ehe nazʉ ’he gba onʉ, anga dabɨlɨ dʉ pɨ uo bhʉ́ ’tɨ gba ogomago-o de. ");
INSERT INTO mdm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bha bhʉ́ ndu doto bhomʉ-o, omʉlila gba okandɵlɵ adʉ asɨlɨ abhʉ́ ’gʉ ngʉ́ nalila onʉ gba o-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Andjelu gba Ebhe-e akoto lɨ uo. Sangu gba Ebhe-e asa uo ngbalina maka zɨ ’kpɨ́. Abhomʉ-o, u atsia adje tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Engʉ́ bini, andjelu-o apa pɨ uo me: «Yi adjé tsʉlʉ de, anga ma ago akpokpo pɨ yi bádha ngali ɨnde ahá djalɨ naali pɨ ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nakɨ bhʉ́ kʉtɨ gba Davidi-e, u azu Mʉkobho pɨ yi. A ko Kilisito , Ngámá. ");
INSERT INTO mdm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yi tsia ’he ɨnde yi ambɨ́la anɨ ka e ko: yi abháka ndje ndɨlɨ u agagala e ne bongo, u atsia aseke e bhʉ́ ehe nazʉ ’he gba onʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kolo má gala me-e, bhiti oandjelu ayie abhʉ́lá, u ago abhaka andjelu bhomʉ, u atsia adʉ adhɵgɵ Ebhe me: ");
INSERT INTO mdm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Sangu pɨ Ebhe ɨnde abhʉ́lá, guo ’ngʉ́ gba anɨ-e dʉ pɨ́la doto pɨ okpála ɨnde anɨ akʉnda o ko!» ");
INSERT INTO mdm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lɨ oandjelu-o agie lɨo lɨe abhʉ́lá-a, omʉlila atsia apa sʉnda o me: «Nɨ́ nʉ kolo nga bha abhʉ́ Beteleme, amba nɨ́ u engʉ́ ɨnde akolo oo, engʉ́ ɨnde lɨ Ebhe Ngámá asuno e pɨ nɨ́ ko.» ");
INSERT INTO mdm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","U anʉ bhʉ́ holo, u abhaka Malɨa, Djodjefʉ ne mboye ndɨlɨ-e me u nde aseke anɨ bhʉ́ ehe nazʉ ’he gba onʉ. ");
INSERT INTO mdm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","U au anɨ lɨe, u atsia akpokpo ’ngʉ́ ɨnde lɨ andjelu apa e pɨ uo pɨndjɨ mboye ndɨlɨ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ndʉ okpála hana ɨnde adje engʉ́ lɨ omʉlila adʉ apa e-e, angamba naali. ");
INSERT INTO mdm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","La-a, pɨ Malɨa, anɨ adʉ alila ndʉ ’ngʉ́ bhomʉ-o hana lɨ bua e ndjɨndjɨ. Anɨ atsia adʉ abhundja pépé. ");
INSERT INTO mdm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pɨpɨta-a, omʉlila aholo nagie lɨo. U adʉ aha sangu pɨ Ebhe, u atsia adʉ di adhɵgɵ anɨ ngʉbula ndʉ ’ngʉ́ ɨnde u adje e ne bhende u au e hana, anga ndʉndʉ hana akodho ’kpɨ́ maka lɨ andjelu-o akpokpo pɨ uo lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bhʉ́ ekpɨ́ na madjɨna pɨta nazu anɨ-e, lɨ nedhɨnga nato anɨ bhʉ́ gandja akolo lɨe, u atsia agisila ’lɨ anɨ me Yesu. A bhomʉ-o ꞌɨlɨ ɨnde lɨ andjelu asuno e kala me ’hi anɨ bɨ ’bhɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lɨ nedhɨnga navʉlʉ lɨe pɨta nazu ka Malɨa akolo lɨe, maka lɨ lɨ́lɨ gba Moidje apa lɨe, u atsia anʉ ne ndɨlɨ-e bhʉ́ Yelusalema ngʉ́ naꞌo anɨ sa ’kpa Ngámá. ");
INSERT INTO mdm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Padhá de, anga u aye bhʉ́ lɨ́lɨ gba Ngámá-a me: «Ndʉ ongɨsɨ na obhosɨbhosɨ na gigina hana, u aꞌó uo kpí pɨ Ngámá.» ");
INSERT INTO mdm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","U atsia aha di makiso maka lɨ lɨ́lɨ gba Ngámá-a apa lɨe me: «A ayo naha bɵbhɵ bhisi. Ɨ dʉ mo-o de-e, mʉ de ha ongɨsɨ bɵbhɵ bhisi.» ");
INSERT INTO mdm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bhʉ́ nedhɨnga bhomʉ-o, kpála bini adʉ nanɨ bhʉ́ Yelusalema, a adʉ ’lɨ anɨ me Simeo. A ko nanɨ kpála na ngbingbili , anɨ adʉ amanga Ebhe. Anɨ adʉ adjeke nedhɨnga lɨ Ebhe aꞌé lɨkabhu gba omaƗsalaele lɨe ko. Bu Bhobua adʉ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Abhomʉ-o, Bu Bhobua atsia apa nanɨ pɨ anɨ me, kala nakpi ka anɨ-e, anɨ aú ngaɨza Masɨya ɨnde lɨ Ngámá atima e-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nedhɨnga lɨ okpála ɨnde azu Yesu ago ne anɨ lɨe ngʉ́ namene maka lɨ lɨ́lɨ apa lɨe lɨ ’ngʉ́ gba anɨ-e, Bu Bhobua ato bhʉ́la Simeo abhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. ");
INSERT INTO mdm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Abhʉ́ ’tɨ Ebhe oo, anɨ aha ndɨlɨ-o, anɨ abɨ anɨ sa ’kpa e, anɨ atsia agie heni pɨ Ebhe me: ");
INSERT INTO mdm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ngámá, mbɨa ɨnde-e, maka mo opa lɨe, mʉ tɨ da naꞌo ma, bali gba mʉ-o, me ma nʉ ne guo ’ngʉ́, ");
INSERT INTO mdm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","anga ma au mʉkobho gba mʉ-o ne djila ma au. ");
INSERT INTO mdm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mʉkobho ɨnde mo otima e kala ndʉ okpála hana-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anɨ adʉ́ eke pɨ omʉpagano. Anɨ tsia dʉ́ sangu gba omaƗsalaele, okpála gba mʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","’Dyɨ Yesu ne ’hi Yesu angamba naali ka engʉ́ ɨnde u adʉ apa e lɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeo ayo me Ebhe tuko bisagu pɨ́ uo, anɨ atsia apa pɨ Malɨa, ’hi Yesu me: «Ebhe abhʉ ndɨlɨ ɨnde-e ngʉbula me okpála bhelé bhʉ́ ká omaƗsalaele lɨ bhʉ́ mangɨmbo, amba Ebhe ꞌeꞌe matá okoko bhʉ́lá. Anɨ adʉ́ ehe ɨnde lɨ Ebhe ngasuno e, lɨ okpála bhelé tsia yála anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kaka-a, anɨ agbé mabhundja ɨnde awo lɨe lɨ bua okpála bhelé-e bhʉ́ mbasʉ. La-a, pɨ mʉ makpe-e, lɨkabhu adʉ́ bua mʉ maka ngise má pʉʉ!» ");
INSERT INTO mdm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Polofeta bini na ɵɵlɵ adʉ di nanɨ oo. A adʉ ’lɨ anɨ me Ana, ndɨlɨ gba Fanʉele bhʉ́ piga gba Asela. Anɨ adʉ me anɨ nde agbe má dyuku! U amene nanɨ ne bhoko gba e ɨnde u aha lɨo ne e bhʉ́ ndɨlɨ-e kalanga mananɨka. ");
INSERT INTO mdm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pɨta nakpi ka ’ko anɨ-e, anɨ atsia ato ɵkɵ. Lɨ nedhɨnga bhomʉ-o, anɨ adʉ ɨbili ne kalanga ndjɨkpa madjɨna ne ká badha. Anɨ dʉ ayie bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a de. Anɨ adʉ amene kulu lɨe pɨ Ebhe sukpe ne ngbɨkpɨ. Anɨ adʉ atse ezʉ ngʉ́ nayo Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bha lɨ nedhɨnga bhomʉ-o, ngaanɨ di-e, anɨ ago, anɨ atsia aholo adhɵgɵ Ebhe. Anɨ aholo akpokpo ’ngʉ́ pɨndjɨ ndɨlɨ-e pɨ ndʉ okpála hana ɨnde adʉ adjeke me Ebhe gbegbe okpála na Yelusalema bhʉ́ lɨkabhu gba o ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lɨ ’dyɨ Yesu ne ’hi Yesu andjia namene ndʉ ’ngʉ́ hana ɨnde lɨ lɨ́lɨ gba Ngámá apa e lɨe, u atsia agie lɨo bhʉ́ ndu doto na Galilaya, bhʉ́ kʉtɨ gba o na Nadjaleta-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ndɨlɨ-e adʉ abhele, anɨ atsia adʉ abɨ angu. Ɨmbɨlangʉ gba anɨ-e atsia adʉ di abhulu lɨe. Bádha bhʉ́ ’bu gba Ebhe-e atsia adʉ di bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ndʉ kalanga hana, okpála ɨnde azu anɨ-e adʉ anʉ́ bhʉ́ Yelusalema ngʉ́ namene anokomɨa na Pasɨka . ");
INSERT INTO mdm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lɨ anɨ akolo lɨe ne kalanga ndjɨkpa ne ká bhisi-e, u atsia anʉ ne anɨ bhʉ́ dabɨlɨ bini maka u amemene lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lɨ anokomɨa andjia lɨe, u aholo agie lɨo. Engʉ́ bini, ndɨlɨ-e Yesu atigala naae bhʉ́ Yelusalema me ’dyɨ anɨ ne ’hi anɨ nde mbɨla de. ");
INSERT INTO mdm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","U adʉ abhundja lɨe me anɨ bhʉ́ dabɨlɨ bini ne obɨ o na kpadjɨ-e, u atsia adhʉkʉ ekpɨ́ bini libhomu. Pɨpɨta-a, u aholo nagɨlɨ anɨ bhʉ́ ká opiga gba o di ne bhʉ́ ká obɨ o-o. ");
INSERT INTO mdm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","U u la anɨ lɨe de-e, u atsia agie lɨo bhʉ́ Yelusalema ngʉ́ nagɨlɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bhʉ́ ’kpɨ́ na bata-a, u abhaka anɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda me anɨ nde adʉ bhʉ́ ká omʉsuno. Anɨ adʉ adje uo di ne nayiyi uo. ");
INSERT INTO mdm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ndʉ okpála ɨnde adʉ adje anɨ-e hana, adʉ angamba naali ka ɨmbɨlangʉ ɨnde anɨ adʉ agie engʉ́ ne e ko. ");
INSERT INTO mdm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lɨ okpála ɨnde azu anɨ au anɨ lɨe, u angamba naali. ’Hi anɨ atsia ayi anɨ me: «Ndɨka ma, mo omene ya mo-o ka nɨ? Tsia nga ya ne ’dyɨ mʉ-o, ya adʉ ɨgɨnɨ agɨlɨ mʉ me bua ya nde alʉ bha ndjʉ abhʉ́lá má gba!» ");
INSERT INTO mdm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Engʉ́ bini, anɨ agie pɨ uo me: «Yi de ngagɨlɨ ma ngʉ́ nɨ? Yi mbɨla ɨgɨnɨ de me, a ayo me ma dʉ bhʉ́ ’tɨ gba ’dyɨ ma-a dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Engʉ́ bini, u mbɨla nanɨ ta ’ngʉ́ ɨnde anɨ adʉ apa e pɨ uo-o de. ");
INSERT INTO mdm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pɨpɨta-a, anɨ atsia agie lɨe ne uo bhʉ́ Nadjaleta. Anɨ adʉ amene lɨ́lɨ gba uo-o. ’Hi anɨ adʉ alila ndʉ ’ngʉ́ bhomʉ-o hana lɨ bua e ndjɨndjɨ. Anɨ atsia adʉ abhundja pépé. ");
INSERT INTO mdm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu adʉ abhele, ɨmbɨlangʉ gba anɨ-e adʉ di abhulu lɨe. Engʉ́ ɨnde anɨ adʉ amene e bhʉ́ bádha bhʉ́ ’bu gba Ebhe-e, a adʉ anga lɨ Ebhe, di ne lɨ okpála naali. ");
INSERT INTO mdm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Pɨpɨta-a, Tibele akolo ’ngbé ngámá na Loma . Bhʉ́ kalanga na ndjɨkpa ne ká bhuluvue bhʉ́ naʉ gba anɨ-e, Djaa ndɨlɨ gba Djakalɨa, ɨnde adʉ nanɨ adʉ abhʉ́ ’gʉ-o, asia eli gba Ebhe . Nedhɨnga ango-o, Pose Pɨlatɵ adʉ alila ndu doto na Yudaya. Elode adʉ ngámá na ndu doto na Galilaya. Ndai anɨ Filipo atsia adʉ ngámá na ndu doto na Itule ne Talakonite. Lisaniasɨ atsia adʉ naae ngámá na Abilene. Bhʉ́ nedhɨnga bhomʉ-o, Ana ne uo ne Kaifa atsia adʉ obhelesɨ okpála gba odimandɵ gba Ebhe . ");
INSERT INTO mdm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Abhomʉ-o, Djaa aholo adhʉkʉ bhʉ́ ’gʉ lɨngo ngade ’ngu na Djʉlʉdanɨ, anɨ atsia adʉ atotobhɨla me: «Yi dji bua yi, yi sia batisimo, amba Ebhe ꞌe siti ’ngʉ́ gba yi ko.» ");
INSERT INTO mdm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Maka lɨ polofeta Ɨsaya, aye lɨe bhʉ́ bhuku gba e me: «A ko kpála bini ɨnde ngatotobhɨla abhʉ́ ’gʉ me: ‹Yi leke kpadjɨ pɨ Ngámá, yi lɨ okpadjɨ pɨ anɨ ngbingbili! ");
INSERT INTO mdm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ndʉ tsutsukudhu bɨlɨ sʉnda ongba ’ta hana abédhe lɨe. Ndʉ oeta na ngbengbengbe ne obhe na djedjedje hana adjɨ́ lɨe, ɨ kólo má gbata gbata! Ndʉ kpadjɨ na gagala hana akólo ngbingbili. Okpadjɨ na sisiti akólo babadha. ");
INSERT INTO mdm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lɨ ndʉ okpála hana tsia ú maka lɨ Ebhe ngakobho okpála lɨe ko!›» ");
INSERT INTO mdm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abhomʉ-o, okpála bhelé adʉ ago abhaka Djaa ngʉbula nasia batisimo. Anɨ atsia adʉ ayi uo me: «Ngayi opiga kpʉlʉ ɨnde-e! A asuno pɨ yi da me yi kpe mangɨmbo gba Ebhe ɨnde ngago-o? ");
INSERT INTO mdm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ɨ dʉ mo-o, yi mene engʉ́ ɨnde asúno me yi adji bua yi kʉkʉlʉ! Yi adʉ́ abhundja bha lɨ bua yi de me, Abalahama ne ogbi yi. Padhá de, anga ma apa pɨ yi na paká me, teme yi ngau e ɨnde-e, Ebhe tɨ́ da nadjidji, ɨ tsia kólo odi Abalahama! ");
INSERT INTO mdm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Maka ma ngapapa lɨe ɨnde-e, u aꞌo ngbakpa bhʉ́ li ndula-a ngʉ́ nadede aꞌo. Ndʉ ndula hana ɨnde ɨ lɨ lɨ́lɨ́ na babadha de-e, u adé, u tsia bhíke bhʉ́ djua.» ");
INSERT INTO mdm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Abhomʉ-o, okpála ango-o atsia adʉ ayi anɨ me: «Ɨ dʉ mo-o, a ayo me ya mene pɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Anɨ atsia adʉ agie pɨ uo me: «Kpála bhende lɨ bongo na mbulu nde ka e bhisi-e, a ayo me anɨ ha bini pɨ kpála bhende lɨ bongo na mbulu nde ka e ade ko. Kpála bhende lɨ ezʉ nde ka e-e, a ayo me anɨ ha di mbo pɨ kpála bhende lɨ ezʉ nde ka e ade ko.» ");
INSERT INTO mdm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ondɵmbɨ na mandjandja ago di ngʉ́ nasia batisimo, u atsia ayi anɨ me: «Mʉsuno, a ayo me ya mene pɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Anɨ atsia agie pɨ uo me: «Yi ayó tɨa ane bhende lɨ lɨ́lɨ azɨba e de.» ");
INSERT INTO mdm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Osʉdha atsia ayi di anɨ me: «A la ya-a, a ayo me ya mene naaya pɨ?» Anɨ atsia agie pɨ uo me: «Yi agbʉ́lʉ tɨa ka kpála bini ne kpéke, di ne eu de. Engʉ́ bini, yi mbɨla bha tɨa na kulu gba yi ko.» ");
INSERT INTO mdm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Maka lɨ okpála adʉ adjeke nago ka Masɨya lɨe, u atsia adʉ ayi lɨo lɨ bua o pɨndjɨ Djaa me: «A ko ndi-e Masɨya ɨnde lɨ Ebhe atima e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Djaa atsia agie pɨ ndʉ uo hana me: «Ngama-a, ma ngabatisa naama yi ne engu. Engʉ́ bini, a ngago pɨta ma ne kpála. Kpála ango-o ane ma ne angu. Ma belegʉ ne tetele kpála ade ngʉbula me ma bhulu ekpʉ́ na malɵkɵ gba anɨ-o. Anɨ abátisa yi ne Bu Bhobua di ne djua. ");
INSERT INTO mdm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Anɨ aholo kakpa gba e sa ’kpa e ngʉ́ nape nguwa gba e-o. Anɨ apó bhʉ́la nguwa na babadha gba e bhʉ́ ngbokopi, engʉ́ la bini, anɨ tsia bú fufukudha-a bhʉ́ djua ɨnde lɨ kpála bini tɨ da nabʉlʉ e de.» ");
INSERT INTO mdm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Djaa aha nanɨ lɨ́lɨ koko bhelé pɨ okpála. Bhʉ́bhʉ́-o, anɨ atsia adʉ akpokpo Bádha Ngali gba Ebhe-e pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngámá Elode aha nanɨ Elodiade, ɵlɵ gba ndai e-o. Anɨ amene nanɨ matá di osisiti ’ngʉ́ koko bhelé. Kaka-a, Djaa atsia ambe bhʉ́ ’ndjɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Abhomʉ-o, Elode amene matá siti ’ngʉ́ koko pépé, anɨ aha Djaa, anɨ atsia abhike anɨ bhʉ́ tɨkpʉ. ");
INSERT INTO mdm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kala me Djaa lɨ bhʉ́ tɨkpʉ-o, anɨ abatisa ngaɨza ndʉ okpála hana. Abhomʉ-o, Yesu atsia asia di batisimo. Nedhɨnga lɨ Yesu adʉ akpokpo ’ngʉ́ ne Ebhe lɨe, kokpɨ́ abhulu lɨe, ");
INSERT INTO mdm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","u au Bu Bhobua ngakɵ pɨ́ anɨ maka bɵbhɵ. U atsia adje eli ayie abhʉ́lá apa me: «Mʉ ne ndɨlɨ gba ma na mʉkʉnda. Djalɨ lɨ bua ma ngʉ́ mʉ naali.» ");
INSERT INTO mdm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu akpo nanɨ lita kulu gba e me anɨ nde ne kalanga masɨkpe de ndjɨkpa bata. Okpála adʉ abhundja naao me, a ko ndɨlɨ gba Djodjefʉ . Djodjefʉ ndɨlɨ gba Eli, ");
INSERT INTO mdm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ndɨlɨ gba Matatɨ, Matatɨ ndɨlɨ gba Levi, Levi ndɨlɨ gba Maleki, Maleki ndɨlɨ gba Djanai, Djanai ndɨlɨ gba Djodjefʉ , ");
INSERT INTO mdm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Djodjefʉ ndɨlɨ gba Matatɨasɨ, Matatɨasɨ ndɨlɨ gba Amosɨ, Amosɨ ndɨlɨ gba Nauma, Nauma ndɨlɨ gba Eseli, Eseli ndɨlɨ gba Nagai, ");
INSERT INTO mdm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ndɨlɨ gba Mata, Mata ndɨlɨ gba Matatɨasɨ, Matatɨasɨ ndɨlɨ gba Semeini, Semeini ndɨlɨ gba Djoseke, Djoseke ndɨlɨ gba Djoda, ");
INSERT INTO mdm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Djoda ndɨlɨ gba Yoanana, Yoanana ndɨlɨ gba Lesa, Lesa ndɨlɨ gba Djelubabela, Djelubabela ndɨlɨ gba Salatiele, Salatiele ndɨlɨ gba Neli, ");
INSERT INTO mdm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli ndɨlɨ gba Maleki, Maleki ndɨlɨ gba Adi, Adi ndɨlɨ gba Kosama, Kosama ndɨlɨ gba Elemadama, Elemadama ndɨlɨ gba Ele, ");
INSERT INTO mdm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ele ndɨlɨ gba Yesu, Yesu ndɨlɨ gba Eliedjele, Eliedjele ndɨlɨ gba Djolime, Djolime ndɨlɨ gba Matatɨ, Matatɨ ndɨlɨ gba Levi, ");
INSERT INTO mdm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ndɨlɨ gba Simeo, Simeona ndɨlɨ gba Yuda, Yuda ndɨlɨ gba Djodjefʉ , Djodjefʉ ndɨlɨ gba Djonama, Djonama ndɨlɨ gba Eliakime, ");
INSERT INTO mdm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakime ndɨlɨ gba Melea, Melea ndɨlɨ gba Mena, Mena ndɨlɨ gba Matata, Matata ndɨlɨ gba Natana, Natana ndɨlɨ gba Davidi, ");
INSERT INTO mdm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi ndɨlɨ gba Yese, Yese ndɨlɨ gba Obede, Obede ndɨlɨ gba Boadja, Boadja ndɨlɨ gba Salamona, Salamona ndɨlɨ gba Nasone, ");
INSERT INTO mdm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasona ndɨlɨ gba Aminadaba, Aminadaba ndɨlɨ gba Adimina, Adimina ndɨlɨ gba Aluni, Aluni ndɨlɨ gba Edjelone, Edjelone ndɨlɨ gba Peledje, Peledje ndɨlɨ gba Yuda, ");
INSERT INTO mdm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ndɨlɨ gba Yakobho, Yakobho ndɨlɨ gba Ɨsaka, Ɨsaka ndɨlɨ gba Abalahama, Abalahama ndɨlɨ gba Tela, Tela ndɨlɨ gba Naola, ");
INSERT INTO mdm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naola ndɨlɨ gba Seluga, Seluga ndɨlɨ gba Lagau, Lagau ndɨlɨ gba Pelege, Pelege ndɨlɨ gba Ebele, Ebele ndɨlɨ gba Sela, ");
INSERT INTO mdm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ndɨlɨ gba Kainame, Kainame ndɨlɨ gba Alepakasada, Alepakasada ndɨlɨ gba Seme, Seme ndɨlɨ gba Nʉa, Nʉa ndɨlɨ gba Lemeke, ");
INSERT INTO mdm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeke ndɨlɨ gba Matusalema, Matusalema ndɨlɨ gba Enoka, Enoka ndɨlɨ gba Yelede, Yelede ndɨlɨ gba Malalele, Malalele ndɨlɨ gba Kenana, ");
INSERT INTO mdm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenana ndɨlɨ gba Enosa, Enosa ndɨlɨ gba Sete, Sete ndɨlɨ gba Adamʉ , Adamʉ ndɨlɨ gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pɨta lɨ Yesu abedhe lɨe ne Bu Bhobua-a , anɨ ayie lɨngo ’ngu na Djʉlʉdanɨ, Bu Bhobua atsia amba bhʉ́la anɨ abhʉ́ mili bɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Oo, Djabʉlʉ ale anɨ ngʉbula ekpɨ́ ndjɨkpa badha. Bhʉ́ oekpɨ́ bhomʉ-o, anɨ zʉ ’he de. Pɨpɨta-a, gʉmʉ aholo amene anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Abhomʉ-o, Djabʉlʉ atsia apa pɨ anɨ me: «Ɨ dʉ me mʉ nde ne Ndɨlɨ gba Ebhe-e, pa pɨ teme ɨnde-e me a dji lɨe, amba a kolo ezʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu agie pɨ anɨ me: «Eli gba Ebhe-e apa me: ‹Kpála kóbho bha bini ka ezʉ de.›» ");
INSERT INTO mdm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Djabʉlʉ aha anɨ, anʉ ne anɨ apɨ́ ’ta. Anɨ asuno ndʉ ondende na doto pɨ anɨ hana, bhʉ́ nedhɨnga bedɨ bhomʉ. ");
INSERT INTO mdm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Anɨ atsia apa pɨ anɨ me: «Ebhe aha ndʉ angu, ne otɨa na ondende bhomʉ-o hana mʉma. Ma tɨ da nahaha pɨ kpála ɨnde ma akʉnda nahaha pɨ e. Ɨ dʉ me mʉ nde akikita lɨpʉkʉ mʉ kuto kala ma-a, ma ahá ndʉ angu ne otɨa na ondende bhomʉ-o hana pɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu atsia agie pɨ anɨ me: «Eli gba Ebhe-e apa me: ‹Dhɵgɵ Ebhe Ngámá gba mʉ, amba mʉ toko bha bini anɨ kpi e kpi.›» ");
INSERT INTO mdm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pɨpɨta-a, Djabʉlʉ aha anɨ, anʉ ne anɨ abhʉ́ Yelusalema. Anɨ aꞌo anɨ apɨ́ tulundjɨ ’ngbé ’tɨ Ebhe gba omaYuda, anɨ atsia apa pɨ anɨ me: «Ɨ dʉ me mʉ nde bha ndjʉ ne Ndɨlɨ gba Ebhe-e, ꞌulu, mʉ kɵ kuto, ");
INSERT INTO mdm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","anga eli gba Ebhe-e apa me: ‹Ebhe ahá lɨ́lɨ pɨ oandjelu gba e me, u lila mʉ. › ");
INSERT INTO mdm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","La di matá: ‹U abɨ́ mʉ sa ’kpa o, amba mo otʉ́ ’dhʉ mʉ lɨ teme de.›» ");
INSERT INTO mdm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu atsia agie pɨ anɨ me: «Eli gba Ebhe-e apa la di me: ‹Mo olé Ebhe Ngámá gba mʉ-o de.›» ");
INSERT INTO mdm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pɨta lɨ Djabʉlʉ andjia nale Yesu lɨe ne ndʉ kpadjɨ hana-a, anɨ atsia aꞌo ka anɨ ngʉ́ nadjeke nedhɨnga koko. ");
INSERT INTO mdm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Abhomʉ-o, Yesu atsia agie lɨe bhʉ́ ndu doto na Galilaya, bhʉ́ angu gba Bu Bhobua. Ndʉ okpála hana aholo nakpokpo ’ngʉ́ gba anɨ-e bhʉ́ ndu doto bhomʉ-o libhomu. ");
INSERT INTO mdm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Anɨ adʉ asuno bhʉ́ oetɨ gba uo nadje lɨ́lɨ gba Moidje-o . Ndʉ okpála hana atsia adʉ adhɵgɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pɨpɨta-a, anɨ atsia anʉ bhʉ́ Nadjaleta, kʉtɨ ɨnde anɨ abhele bhʉ́ e-o. Lɨ ’kpɨ́ naguo gba omaYuda-a , anɨ alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje maka anɨ adʉ amemene lɨe ko. Anɨ ayie bhʉ́lá ngʉ́ natanga eli gba Ebhe-e pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Abhomʉ-o, u atsia aha bhuku gba polofeta Ɨsaya pɨ anɨ. Anɨ abhulu bhuku-o, anɨ atsia agɨlɨ bɨlɨ u aye lɨe me: ");
INSERT INTO mdm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Bua gba Ngámá-a bhʉ́ dabɨlɨ bini ne ma. Anɨ abhʉ ma ngʉ́ nanʉ nakpokpo Bádha Ngali pɨ obhʉlʉ ndɨbhɨlɨ. Anɨ atima ma ngʉ́ natobhɨla pɨ obalise me, u azé bhʉ́ bali gba o-o maze, pɨ okpála ɨ u ’kpɨ́ de-e me, u aú matá ’kpɨ́ mau. Anɨ atima ma di ngʉ́ napandja obhende bhʉ́ mbolo sa ’kpa obhende ngato mbolo lɨ uo-o. ");
INSERT INTO mdm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ngama-a, ma akpókpo pɨ okpála me nedhɨnga ɨnde lɨ Ebhe adjé ndjinga uo lɨe akolo.» ");
INSERT INTO mdm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pɨta lɨ Yesu andjia natatanga lɨe, anɨ agagala bhuku-o, anɨ atsia agie pɨ kpála na kulu-o. Abhomʉ-o, anɨ aha lɨe adʉ kuto. Ndʉ okpála ɨnde adʉ bhʉ́ ’tɨ oo hana abanga djila o lɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Anɨ atsia aholo napa pɨ uo me: «Engʉ́ ɨnde yi adje e bhʉ́ Bhuku gba Ebhe-e lɨ bɨlɨ bhomʉ-o, amene lɨe nakɨ amene.» ");
INSERT INTO mdm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ndʉ okpála hana adʉ angamba lɨ Yesu naali. U atsia adʉ azɨba eli na bádha bhʉ́ ’bu ɨnde anɨ adʉ akpokpo e-o. Abhomʉ-o, u atsia adʉ apa me: «A ɨnde-e ndɨlɨ gba Djodjefʉ-o dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Abhomʉ-o, anɨ atsia apa pɨ uo me: «Ma ambɨla na paká me yi apá mʉma gbitaku ɨnde me: ‹Mʉtɨa, kobho lɨmʉ ne tɨtɨ mʉ.› Yi tsia pá di mʉma me: ‹Ya adje ndʉ ’ngʉ́ ɨnde mo omene e bhʉ́ Kapalanauma-a hana. Mene nga la di ngua ’ngʉ́ ango-o bhʉ́ kʉtɨ mo obhele bhʉ́ e ko.›» ");
INSERT INTO mdm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Anɨ atsia apa matá pɨpɨta-a me: «A moko, ma apa pɨ yi me, a ko kʉkʉlʉ ’ngʉ́, okpála zɨzɨba polofeta bhʉ́ kʉtɨ gba e belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ma apa pɨ yi na paká me, oɵkɵsɨ na olɨsɨlɨsɨ adʉ nanɨ bhelé bhʉ́ ká omaƗsalaele lɨ nedhɨnga gba polofeta Elɨya. Lɨ nedhɨnga bhomʉ-o, ebha dhɨ nanɨ-ɨ de ngʉbula kalanga bata ne epe madhɨa. Kaka-a, adyɨndɨ na ngbéngbé atsia alɨ bhʉ́ doto ango-o libhomu. ");
INSERT INTO mdm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Engʉ́ bini, Ebhe tima nanɨ Elɨya ngʉ́ nateteke sʉka oɵkɵsɨ bhomʉ-o bini de. Anɨ atima bha bini anɨ gba ɵkɵ bini na gandji kʉtɨ na Salepeta bhʉ́ ndu doto na Sidona. ");
INSERT INTO mdm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Matá-a, okpála na kába adʉ di nanɨ bhelé bhʉ́ ká omaƗsalaele lɨ nedhɨnga gba polofeta Elisa. Engʉ́ bini, Ebhe kobho nanɨ sʉka uo de, bha bini Namana, gandji kpála na Silia.» ");
INSERT INTO mdm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lɨ ndʉ okpála hana ɨnde adʉ bhʉ́ ’tɨ oo adje ’ngʉ́ bhomʉ-o lɨe, u ake ’ngʉ́ lɨo naali. ");
INSERT INTO mdm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","U ayie bhʉ́lá, u agbe anɨ bhʉ́ ’tɨ bhomʉ-o, u agbele anɨ apɨ́ ’ta ɨnde u ayiki gʉdhʉ gba o pɨ́ e-o. U amene nanɨ mo-o ngʉ́ nandjimba anɨ akuto. ");
INSERT INTO mdm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Engʉ́ bini, anɨ akodho bha ’kpɨ́ bhʉ́ ká uo oo, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Abhomʉ-o, Yesu anʉ bhʉ́ Kapalanauma, kʉtɨ bini na ndu doto na Galilaya. Anɨ atsia adʉ asuno pɨ okpála bhʉ́ ’kpɨ́ naguo gba omaYuda-o. ");
INSERT INTO mdm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","U adʉ nangamba lɨ ngua nasuno gba anɨ-o, anga anɨ adʉ nasuno ne angu gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje oo, kpála bini lɨ siti bua adʉ nato mbolo lɨe, aholo asʉsʉla kpekpeke me: ");
INSERT INTO mdm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aa! Yesu, kpála na Nadjaleta, mo okʉnda namene ngʉ́ ya pɨ? Mo ogo ngʉ́ nabhili ya? Ma mbɨla mʉ hana, mʉ ne kpála na bubu ɨnde lɨ Ebhe atima e ko!» ");
INSERT INTO mdm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu atsia ambe bhʉ́ ’ndjɨ anɨ me: «Gbite ’bhɵ mʉ, amba mʉ koto la di bhʉ́ kpála bhomʉ!» Siti bua-a agʉ ꞌi kpála ango-o kuto má gbwe, bhʉ́ ká djila ndʉ okpála ɨnde adʉ oo hana. Anɨ akoto bhʉ́ anɨ, engʉ́ bini anɨ mene anɨ sisiti de. ");
INSERT INTO mdm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ndʉ okpála hana angamba, u atsia adʉ ayi lɨo sʉnda o me: «A ɨnde-e mangua eli dho? Anɨ ngaha lɨ́lɨ ne kpéke, di ne angu pɨ osisiti bua, uo ngaze bhʉ́ okpála!» ");
INSERT INTO mdm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Okpála atsia adʉ apa ’ngʉ́ gba Yesu-o bhʉ́ ndʉ okʉtɨ bhomʉ-o hana. ");
INSERT INTO mdm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lɨ Yesu ayie lɨe bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-e, anɨ atsia anʉ alɨ bhʉ́ ’tɨ gba Simo. A abhaka me a nde lɨ ’hi wala Simo ne kpéke bandjɨ. Abhomʉ-o, u atsia ayo ka Yesu me anɨ kobho anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Anɨ ago alʉ pɨ anɨ, anɨ ambe bhʉ́ ’ndjɨ bandjɨ-o. Abhomʉ-o, bandjɨ-e atsia ayie lɨ anɨ. Anɨ ayie bhʉ́lá kolo má gala, anɨ atsia aholo nalʉ ’zʉ pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lɨ ela atɨ lɨe, ndʉ okpála hana ɨnde adʉ ne okpála na kuo ngangá agba o-o, abha uo, u atsia ago ne uo pɨ Yesu. Anɨ aꞌo ’kpa e pɨ́ ’ndjɨ uo bini ne bini, u atsia akobho ndʉ o hana. ");
INSERT INTO mdm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Osisiti bua aze di bhʉ́ okpála na kuo bhelé. Osisiti bua ango-o atsia adʉ asʉsʉla me: «Mʉ ne Ndɨlɨ gba Ebhe!» Engʉ́ bini, Yesu adʉ ambe bhʉ́ ’ndjɨ uo. Anɨ atsia adʉ di agbite kpadjɨ pɨ uo me u agama ’ngʉ́ de, anga u adʉ ambɨla hana me a ko Masɨya ɨnde lɨ Ebhe atima e ko. ");
INSERT INTO mdm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lɨ ekpɨ́ aseke lɨe, anɨ akoto bhʉ́ kʉtɨ bhomʉ, anɨ atsia atapa bhʉ́ mili bɨlɨ. Bhiti okpála aholo nagɨlɨ anɨ. U au anɨ lɨe, u aholo akikiliki lɨo pɨ anɨ me: «Mo oꞌó ká ya de, nɨ́ tigala ne yi sɨ-ɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Engʉ́ bini, Yesu apa pɨ uo me: «A ayo me ma anʉ di nakpokpo Bádha Ngali Naʉ gba Ebhe-e bhʉ́ okʉtɨ koko, anga Ebhe atima ma ngánga.» ");
INSERT INTO mdm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Abhomʉ-o, anɨ atsia adʉ akpokpo Bádha Ngali bhʉ́ otɨ nadje lɨ́lɨ gba Moidje na ndu doto na Yudaya-o. ");
INSERT INTO mdm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A akolo ekpɨ́ bini, Yesu adʉ lɨngo ekpɵ na Genedjaleta. Bhiti okpála asʉlʉ de anɨ má wakaka ngʉ́ nadje ’li Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Anɨ au zabʉ bhisi lɨngo ’ngu me obhʉbhʉlʉ-o nde aze, u nde ngavʉlʉ onado gba o na sungu-o. ");
INSERT INTO mdm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu atsia aꞌʉ bhʉ́ sʉsʉka bini, bhende gba Simo-o. Do anɨ pɨ Simo me: «Yie lɨngo ’gɵ-o, amba mʉ dyudyo lɨmʉ mbo ne abhʉ́ ’ngu.» Yesu atsia adʉ bhʉ́ zabʉ-o kuto. Anɨ aholo nasuno pɨ bhiti okpála bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Anɨ andjia nagama ’ngʉ́ lɨe, anɨ atsia apa pɨ Simo me: «Dyudyo zabʉ-o apɨ́ tsiba, amba ngayi ne obɨ mʉ-o, yi bala onado gba yi-e bhʉ́ ’ngu ngʉ́ naholo osungu-o.» ");
INSERT INTO mdm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo agie pɨ anɨ me: «Mʉsuno, ya amene kulu sukpe ɨnde-e libhomu, ya holo belegʉ sungu de bini. Engʉ́ la bini, ka ’li mʉ-o, ya abhíke onado-o bhʉ́ ’ngu mabhike.» ");
INSERT INTO mdm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","U abala onado lɨe bhʉ́ ’ngu-o, u atsia aholo osungu bhelé. Kaka-a, onado gba uo-o aholo natsotsolo. ");
INSERT INTO mdm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Abhomʉ-o, u amene ’kpa o pɨ obɨ o ɨnde adʉ bhʉ́ zabʉ koko ngʉ́ naꞌɨ uo me, u go ha mbo ’kpa o pɨ o. Obhobhomʉ-o ago, u abebedhe ozabʉ bhisi-e ne osungu bedhebedhe. Kaka-a, ozabʉ atsia aholo nalinda bhʉ́ ’ngu. ");
INSERT INTO mdm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lɨ Simo Piele au lɨe mo-o, anɨ atɨ bhʉ́ li ’dhʉ Yesu, anɨ atsia apa me: «Ngámá, gbe lɨmʉ de ma ne sidi, anga ma ne siti kpála!» ");
INSERT INTO mdm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Anɨ apa mo-o, anga ngauo ne obɨ e, u angamba nanɨ naali ka bhiti osungu ɨnde u aholo e ko. ");
INSERT INTO mdm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Djakɨ ne Djaa , ongɨsɨ gba Djebedayo ɨnde adʉ amene bhʉ́ dabɨlɨ bini ne Simo-o, angamba bhadi moko. Engʉ́ bini, Yesu apa pɨ Simo me: «Mo odjé tsʉlʉ de, anga nayie pɨ mbɨa ɨnde-e, mʉ dʉ́ matá agɨlɨ osungu de, engʉ́ bini, mo odʉ́ ɨbili agɨlɨ okpála pɨ Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Abhomʉ-o, u agbele ozabʉ gba o apɨ́ ’gɵ. U aꞌo ka ndʉ ’he gba o hana, u atsia anʉ bhʉ́ dabɨlɨ bini ne Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A akolo ekpɨ́ bini, Yesu adʉ bhʉ́ kʉtɨ bini na ndu doto na Galilaya, kpála bini ɨnde lɨ kába atsotsolo kʉte e hana-a, akoto. Lɨ anɨ au Yesu lɨe, anɨ ago atɨ kala anɨ, anɨ atʉ bhʉ́la e ne kuto, anɨ atsia alopolo lɨe pɨ anɨ me: «Ngámá, ɨ dʉ me mʉ nde akʉnda-a, mʉ tɨ da nakobho ma.» ");
INSERT INTO mdm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu aha ’kpa e aꞌo lɨ anɨ. Anɨ atsia apa me: «Ma akʉnda moko, kokobho!» Abhomʉ-o, kába agʉlʉ bha kolo lɨ kʉte kpála ango-o hana maka ndjombe. ");
INSERT INTO mdm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu atsia aha lɨ́lɨ pɨ anɨ me: «Mo opá belegʉ engʉ́ ɨnde-e pɨ kpála bini de. Engʉ́ bini, nʉ suno bha lɨmʉ pɨ dimandɵ gba Ebhe maka lɨ kʉte mʉ nde lɨe ko. Pɨpɨta-a, amba mʉ ha makiso maka lɨ lɨ́lɨ gba Moidje apa lɨe, ngʉbula napana pɨ ndʉ okpála hana me mo okobho.» ");
INSERT INTO mdm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Abana mo-o, engʉ́ gba Yesu adʉ bha ayangba ne kalanʉ. Okpála bhelé adʉ ago apo bhʉ́la o de anɨ ngʉ́ nadje anɨ, ne di me anɨ kobho o ne okuo gba o-o. ");
INSERT INTO mdm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Engʉ́ la bini, anɨ adʉ anʉ bhʉ́ omili bɨlɨ. Oo, anɨ atsia adʉ akpokpo ’ngʉ́ ne Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ekpɨ́ bini, Yesu adʉ asuno pɨ okpála. OmʉFalisai koko ne omʉsuno na lɨ́lɨ gba Moidje ɨnde ayie nanɨ bhʉ́ ndʉ okʉtɨ hana na ndu doto na Galilaya ne Yudaya, di ne bhʉ́ ’ngbé gʉdhʉ na Yelusalema adʉlʉ de anɨ. Ne angu gba Ebhe-e, anɨ atsia adʉ akobho okpála na kuo. ");
INSERT INTO mdm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lɨ nedhɨnga bhomʉ-o, okpála koko ago ne dʉkuto bini me u nde abɨ anɨ pɨ́ kalagba. U adʉ nagɨlɨ kpadjɨ ngʉ́ nato anɨ abhʉ́ ’tɨ, amba u ꞌo anɨ kala Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Engʉ́ bini, u ale nalɨ ne anɨ abhʉ́ ’tɨ pima ka lɨ okpála adʉ lɨe bhelé-o. Abhomʉ-o, u atsia aꞌʉ ne anɨ apɨ́ ’ngbʉ ’tɨ. U adʉ gudho lɨ ’ngbʉ ’tɨ-e má vuu! U atsia akɵ anɨ ne ekpʉ́ tété ne kalagba gba e hana bhʉ́ ká okpála kala Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lɨ Yesu ambɨla lɨe me okpála bhomʉ-o abhuka nɨ na paká-a, anɨ atsia apa pɨ kpála na kuo-o me: «Olia ma, ma aꞌe osisiti ’ngʉ́ gba mʉ-o aꞌe.» ");
INSERT INTO mdm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lɨ omʉsuno na lɨ́lɨ di ne omʉFalisai adje ’ngʉ́ bhomʉ-o lɨe, u atsia aholo nabhundja me: «Kpála ɨnde ngasobho Ebhe me-e, a ko nga naae da? A tɨ da naꞌe siti ’ngʉ́ gba okpála da, bha bini Ebhe ngae kpi e kpi dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu ambɨla mabhundja gba uo lɨe, anɨ apa pɨ uo me: «Yi ngabhundja lɨ bua yi mo-o ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ne napa me, ‹Ma aꞌe osisiti ’ngʉ́ gba mʉ aꞌe›, ne napa me, ‹Yie bhʉ́lá, amba mʉ dhʉkʉ-o› a ane ne bhʉkʉ ne bhedho? ");
INSERT INTO mdm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Engʉ́ bini, ma akʉnda me yi mbɨla me ngama, Ndɨlɨ gba kpála-a, ma ne angu pɨ́la doto ngʉ́ naꞌe siti ’ngʉ́.» Abhomʉ-o, Yesu atsia apa pɨ dʉkuto-o me: «Ma apa pɨ mʉ me yie bhʉ́lá, ha dabɨlɨ gba mʉ-o, amba mʉ gie lɨmʉ agba mʉ!» ");
INSERT INTO mdm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kolo má gala me-e, kpála bhomʉ ayie bhʉ́lá bhʉ́ ká djila ndʉ okpála hana, anɨ aha dabɨlɨ ɨnde anɨ de asɨ pɨ́ e, anɨ atsia agie lɨe agba e me anɨ nde ngadhɵgɵ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndʉ okpála hana adʉ angamba naali. U abedhe ne tsʉlʉ bedhe, u adʉ adhɵgɵ Ebhe, u atsia adʉ apa me: «Ya au nakɨ ongʉ́ na ngangamba!» ");
INSERT INTO mdm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pɨpɨta-a, Yesu akoto kilidjo, anɨ atsia au ndɵmbɨ bini na mandjandja, adʉ ’lɨ anɨ me Levi, anɨ nde adʉ kuto bhʉ́ bilo gba e-o. Yesu apa pɨ anɨ me: «Kpata ma.» ");
INSERT INTO mdm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi ayie bhʉ́lá, anɨ aꞌo ka ndʉ ’he hana, anɨ atsia akpata Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pɨpɨta-a, Levi atsia amene ’ngbé anokomɨa pɨ Yesu abhʉ́ ’tɨ gba e. Ondɵmbɨ na mandjandja bhelé di ne okpála koko adʉ nazʉ ’he ne uo bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","OmʉFalisai di ne omʉsuno na lɨ́lɨ gba o adʉ nadi mʉtokono, u atsia ayi omʉkpata gba Yesu-o me: «Ka nɨ yi ngazʉ ’he ne nandjɨ vino lɨe bhʉ́ dabɨlɨ bini ne ondɵmbɨ na mandjandja di ne okpála na sisiti-e?» ");
INSERT INTO mdm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu atsia agie pɨ uo me: «Okpála bhende lɨ kuo nde lɨ o ade-e, u ne gʉmʉ mʉtɨa ade. Engʉ́ bini, obhende ɨnde lɨ o ne kuo ne gʉmʉ mʉtɨa ngao. ");
INSERT INTO mdm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma go ngʉ́ naꞌɨ okpála bhende ngbingbili-e de. Engʉ́ bini, ma ago ngʉ́ naꞌɨ obhende na sisiti-o, ngʉbula me u dji bua o.» ");
INSERT INTO mdm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Okpála bhomʉ-o apa pɨ anɨ me: «Omʉkpata gba Djaa di ne obhende gba omʉFalisai ngatse ezʉ pɨko ngʉ́ nayo Ebhe. Engʉ́ bini, obhende gba mʉ-o la bha naao ngazʉ ’he ne nandjɨ vino.» ");
INSERT INTO mdm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu agie pɨ uo me: «Yi abhundja naayi me yi tɨ da naholo omaha ’ko ɵlɵ ne kpéke ngʉ́ natse ezʉ me ’ko ɵlɵ-o nde nga bha bhʉ́ dabɨlɨ bini ne uo? ");
INSERT INTO mdm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nedhɨnga koko akólo makolo, nedhɨnga ɨnde lɨ okpála adhépe ’ko ɵlɵ-o lɨe bhʉ́ ká uo-o. Lɨ oekpɨ́ ango-o, u tsia tsé la ’zʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu atsia aha di gbitaku ɨnde-e pɨ uo me: «Kpála bini tɨ́ da nasidha bongo na mbɨa, anɨ tsia há pápála-a ngʉ́ nadʉdʉ lɨ bongo na didili de. Anɨ mene mo-o, lɨ bongo na didili-e sídha, la di-e, pála bongo na mbɨa lé ne bhe na didili-e de. ");
INSERT INTO mdm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kpála bini tɨ da naꞌo vino na mbɨa bhʉ́ odidili dhudhu na ko ’nʉ de. Anɨ mene mo-o, lɨ vino na mbɨa bɨ́ ’fu, ɨ ʉ́pa odidili dhudhu-o. Pandɨ-e túko, lɨ odhudhu-o tsia síti di. ");
INSERT INTO mdm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Engʉ́ bini, a ayo naꞌo vino na mbɨa bhadi bhʉ́ odhudhu na mbɨa! ");
INSERT INTO mdm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɨ dʉ me kpála bini nde andjɨ pandɨ na didili andjɨ-e, anɨ kʉ́nda matá pandɨ na mbɨa de, anga anɨ pá me: ‹Pandɨ na didili-e ane ne bádha.›» ");
INSERT INTO mdm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ekpɨ́ bini naguo gba omaYuda-a, Yesu ne omʉkpata gba e adʉ akodho ’kpɨ́ bhʉ́ ngu ’zʉ ɨnde u aꞌɨ e me ngano. Omʉkpata gba anɨ-e aholo akodho ’ndjɨ ’ndjɨ, atutuluba sa-tɨkpa o, u atsia adʉ nazʉzʉ. ");
INSERT INTO mdm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","OmʉFalisai koko ayi uo me: «Yi ngamene bhomʉ-o nɨ? Lɨ́lɨ gba nɨ́-e zɨba namene kulu bhʉ́ ’kpɨ́ naguo de.» ");
INSERT INTO mdm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu atsia agie pɨ uo me: «Yi atanga ndjɨndjɨ bhʉ́ Bhuku gba Ebhe-e , engʉ́ nanɨ lɨ Davidi amene e? Ekpɨ́ bini, ngaanɨ ne omaha e, u adʉ lɨe ne gʉmʉ-o, ");
INSERT INTO mdm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","anɨ alɨ nanɨ bhʉ́ ’tɨ Ebhe. Anɨ aha mapa ɨnde u aꞌo e ngʉ́ nadhɵgɵ Ebhe-e, anɨ azʉ. Anɨ atsia aha di pɨ omaha e, abana lɨ lɨ́lɨ gba nɨ́-e apa lɨe me azʉ́ bha mapa ango-o ne odimandɵ-o .» ");
INSERT INTO mdm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu atsia apa matá pɨ uo me: «Yi mbɨla me ngama, Ndɨlɨ gba kpála-a, ma ne ngámá pɨ́ ’ndjɨ ekpɨ́ naguo.» ");
INSERT INTO mdm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A adʉ nanɨ ekpɨ́ naguo koko bini, Yesu alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-o . Anɨ akolo lɨe oo, anɨ atsia aholo nasuno. Bhʉ́ ká okpála-a, bhoko bini adʉ oo, adʉ lɨ ’kpa anɨ na kokpa-a ne eze. ");
INSERT INTO mdm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Omʉsuno na lɨ́lɨ gba Moidje di ne omʉFalisai adʉ agɨlɨ kpadjɨ ngʉ́ napʉ ngbángá Yesu me, anɨ ngamene siti ’ngʉ́. Kaka-a, u aholo atsia anɨ ne kpéke djila atɨgala anɨ kóbho kpála lɨ ’kpɨ́ naguo. ");
INSERT INTO mdm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Engʉ́ bini, lɨ Yesu ambɨla lɨe me alɨ bua uo oo, u ngabhundja mo-o, anɨ atsia apa pɨ kpála lɨ eze adʉ lɨ ’kpa e me: «Yie bhʉ́lá, amba mʉ lʉ sɨ bhʉ́ ká djila ndʉ okpála hana.» Kpála ango-o ayie bhʉ́lá, anɨ atsia alʉ kala ndʉ okpála ɨnde adʉ bhʉ́ ’tɨ oo hana. ");
INSERT INTO mdm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pɨpɨta-a, Yesu atsia apa pɨ uo me: «Ma ne engʉ́ bini ngʉ́ nayi yi tété: Lɨ ’kpɨ́ naguo, lɨ́lɨ gba nɨ́-e azɨba pɨ? U mene bádha ’ngʉ́, ne me u mene siti ’ngʉ́? U kobho kpála, ne me u akóbho anɨ de?» ");
INSERT INTO mdm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Anɨ atsia ndʉ uo hana bini ne bini. Abhomʉ-o, anɨ atsia apa pɨ kpála na eze-e me: «Gbele ’kpa mʉ.» Kpála ango-o agbele ’kpa e, ’kpa anɨ atsia akolo ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Engʉ́ bini, okpála ango-o abɨ ’gʉ́ naali, u atsia aholo nayi lɨo sʉnda o me: «Nɨ́ tɨ da namene ngʉ́ Yesu mangua ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bhʉ́ oekpɨ́ bhomʉ-o, sukpe bini, Yesu aꞌʉ apɨ́ ’ta ngʉ́ nakpokpo ’ngʉ́ ne Ebhe. Sukpe libhomu anɨ asɨ nakpokpo ’ngʉ́ ne Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lɨ ekpɨ́ aseke lɨe, anɨ aꞌɨ omʉkpata gba e-o, anɨ atsia alo okoko bhʉ́ ká uo ndjɨkpa ne ká bhisi ɨnde anɨ agisila nanɨ ’lɨ o me obhʉlʉ titima gba Yesu . ");
INSERT INTO mdm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A adʉ nanɨ Simo (ɨnde lɨ Yesu agisila ’lɨ e me Piele) ne ndai e Andɨlɨ, Djakɨ ne Djaa , Filipo ne Batelemi, ");
INSERT INTO mdm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matié ne Tʉma, Djakɨ ndɨlɨ gba Alafayo ne Simo (ɨnde u aꞌɨ e me kpála ɨnde akʉnda doto gba e), ");
INSERT INTO mdm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Djude ndɨlɨ gba Djakɨ ne Yuda Ɨsɨkaliote, ɨnde apʉ́ Yesu pɨ obhʉlʉ yala-o. ");
INSERT INTO mdm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Anɨ akɵ ne uo, anɨ atsia alʉ asabu ’ta lɨ bɨlɨ lɨ omʉkpata gba anɨ koko bhelé adʉ lɨe ko. Okpála bhelé na ndu doto na Yudaya libhomu, na Yelusalema ne ogʉdhʉ na ngo ’ngbé ’ngu, gʉdhʉ na Tile ne Sidona adʉ di oo. ");
INSERT INTO mdm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Okpála ango-o ago nanɨ ngʉ́ nadje Yesu, amba anɨ kobho di obhende adʉ ne okuo-o. Anɨ atsia akobho di okpála ɨnde lɨ osisiti bua adʉ ato mbolo lɨ o ko. ");
INSERT INTO mdm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndʉ okpála hana adʉ nagɨlɨ nabu ’kpa o lɨ kʉte anɨ, anga ndʉ uo hana adʉ akobho ka angu ɨnde adʉ bhʉ́ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu atsia omʉkpata gba e-o, anɨ atsia apa pɨ uo me: «A ko djalɨ pɨ yi, ngayi obhʉlʉ ndɨbhɨlɨ, anga Ebhe ne ngámá gba yi-e ngae! ");
INSERT INTO mdm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A ko djalɨ pɨ yi, ngayi obhende ngadje gʉmʉ mbɨa ɨnde, anga yi azʉ́ ’he, yi tsia ꞌú ꞌu! A ko djalɨ pɨ yi, ngayi obhende ngaku ’gba mbɨa ɨnde, anga yi amʉ́ ’zo! ");
INSERT INTO mdm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","A ko djalɨ pɨ yi, ɨ dʉ me okpála nde ngayala yi, u nde ngagbe yi bhʉ́ ká o, u nde ngasobho yi, u nde ngapa ’ngʉ́ gba yi-e sisiti kabula ma, Ndɨlɨ gba kpála. ");
INSERT INTO mdm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lɨ nedhɨnga ango kolo, yi de kpi djalɨ, amba yi dho di ebɨ, anga makalá na ngbéngbé ngadjeke yi abhʉ́lá. Ogbi uo adʉ nanɨ amene bhadi opolofeta sisiti moko. ");
INSERT INTO mdm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Engʉ́ bini, a ko lɨkabhu pɨ yi obhʉlʉ tɨa, anga yi asia makalá gba yi-e asia! ");
INSERT INTO mdm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A ko lɨkabhu pɨ yi, ngayi obhʉlʉ ká ’zʉ́ mbɨa ɨnde, anga yi adʉ́ adjé gʉmʉ! A ko lɨkabhu pɨ yi, ngayi obhende ngamʉ ’zo mbɨa ɨnde, anga yi adʉ́ bhʉ́ talia, yi tsia dʉ́ naku ’gbá! ");
INSERT INTO mdm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A ko lɨkabhu pɨ yi, ɨ dʉ me ndʉ okpála hana nde ngapa ’ngʉ́ gba yi-e ndjɨndjɨ, anga ogbi uo adʉ apa bhadi nanɨ babadha ’ngʉ́ moko lɨ opolofeta na eu ko!» ");
INSERT INTO mdm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Engʉ́ bini, ma apa la pɨ yi me, ngayi obhende ngadje ma-a, yi kʉnda obhʉlʉ yala gba yi-o. Yi mene bádha ’ngʉ́ pɨ obhende ngayala yi ko. ");
INSERT INTO mdm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yi yo me bisagu gba Ebhe-e go pɨ́ okpála bhende ngatʉ pɵdjɵ lɨ yi, amba yi yo Ebhe pɨ obhende ngamene yi sisiti ko. ");
INSERT INTO mdm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lɨ kpála bini sʉ pála mʉ lɨ pápá bini-e, mʉ de dji di pápá koko pɨ anɨ, amba anɨ sʉ. Lɨ kpála bini gbʉlʉ koti gba mʉ-o, mʉ de ꞌo di anɨ amba anɨ ha bongo na mbulu mʉ-o. ");
INSERT INTO mdm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lɨ kpála yo ’he ka mʉ-o, mʉ de ha pɨ anɨ. Ɨ dʉ me kpála bini nde agbʉlʉ ’he ka mʉ-o, mo oyó matá ka anɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yi mene pɨ okpála koko bhadi maka bhende yi akʉnda me u mene e pɨ yi ko. ");
INSERT INTO mdm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ɨ dʉ me yi nde ngakʉnda bha bini okpála bhende ngakʉnda yi-e, yi abhúndja de me yi asía makalá kaka-a de, anga okpála na sisiti-e, u ngakʉnda bhadi okpála bhende ngakʉnda o ko! ");
INSERT INTO mdm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ɨ dʉ me yi nde ngamene bha bini bádha ’ngʉ́ pɨ okpála bhende ɨ ngamemene pɨ yi-e, yi abhúndja de me yi asía makalá kaka-a de, anga okpála na sisiti-e bhadi ngamemene moko! ");
INSERT INTO mdm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ɨ dʉ me yi nde ngaha bha bini ’he pɨ okpála ɨnde yi abhundja me u tɨ da di nagigie pɨ yi lɨ ’kpɨ́ koko-o, yi abhúndja de me yi asía makalá kaka-a de. Abana okpála na sisiti, u ngaha di ’he pɨ obɨ o okpála na sisiti ngʉbula me, u gie di pɨ o lɨ ’kpɨ́ koko! ");
INSERT INTO mdm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Engʉ́ bini, yi kʉnda obhʉlʉ yala gba yi-o. Yi mene bádha ’ngʉ́ pɨ uo. Yi ha ’he pɨ uo me yi nde bhundja de me u agíe pɨ yi magie de. Yi asía ’ngbé makalá. Yi mene mo-o, yi tsia dʉ́ ongɨsɨ gba Ebhe Apɨ́ ’Kpɨ́, anga ngaanɨ-e, anɨ babadha pɨ okpála ɨnde ɨ gie heni pɨ anɨ de. Anɨ di babadha pɨ okpála na sisiti. ");
INSERT INTO mdm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yi bedhe ne ndjinga pɨ okpála maka lɨ ’dyɨ yi Ebhe abedhe di ne di lɨe pɨ okpála ko.» ");
INSERT INTO mdm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Yi akódho ’ngʉ́ gba okpála koko de, amba Ebhe akódho di ’ngʉ́ gba yi-e de. Yi aꞌó engʉ́ pɨ́ okpála koko de, amba Ebhe aꞌó di engʉ́ pɨ́ yi de. Yi mbu lɨ siti ’ngʉ́ gba okpála koko, amba Ebhe mbu di lɨ siti ’ngʉ́ gba yi ko. ");
INSERT INTO mdm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yi ha ’he pɨ okpála koko, amba Ebhe ha di ’he pɨ yi. Anɨ abédhe kíli gba yi-e ne nguwa bedhe má kpambɨ, ɨ hólo nabala kuto. A moko, Ebhe ahá bhadi pɨ yi maka lele yi ngahaha pɨ okpála koko lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu atsia apa matá pɨ uo gbitaku bini me: «Kpála ɨ u ’kpɨ́ de-e tɨ da naholo ’kpa kilí e ɨnde ɨ u ’kpɨ́ de ngʉ́ nasuno kpadjɨ pɨ anɨ uu? A mo-o ade! Ɨ dʉ mo-o, lɨ ndʉ uo bhisi hana bála bhʉ́ ’dú. ");
INSERT INTO mdm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mʉkpata bini ne mʉsuno gba e ne ɨmbɨlangʉ de. Engʉ́ la bini, ndʉ mʉkpata hana ɨnde u asuno ’he pɨ e ndjɨndjɨ-e, anɨ kólo maka mʉsuno gba e-o. ");
INSERT INTO mdm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ka nɨ mʉ ngau mboye kʉ mʉsoli ɨnde bhʉ́ djila ndai mʉ-o lɨe, mʉ tsia u la ndula ɨnde bhʉ́ djila mʉ-o de? ");
INSERT INTO mdm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Lele pɨ mʉ tɨ da napa lɨe pɨ ndai mʉ me: ‹Ndai ma, ꞌo ma, ma gbe mboye kʉ mʉsoli ɨnde bhʉ́ djila mʉ bhomʉ›, ngamʉ-o, mʉ nde u ngala belegʉ de ndula ɨnde bhʉ́ djila mʉ-o? Bhʉlʉ kali, gbe ngaɨza ndula ɨnde bhʉ́ djila mʉ-o. Pɨpɨta-a, mʉ tsia u la ’kpɨ́ ndjɨndjɨ ngʉ́ nagbe mboye kʉ mʉsoli ɨnde bhʉ́ djila ndai mʉ ko.» ");
INSERT INTO mdm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Ndula na babadha lɨlɨ lɨ́lɨ́ na sisiti de. La di-e, ndula na sisiti lɨlɨ lɨ́lɨ́ na babadha de. ");
INSERT INTO mdm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","U mbɨla ndula lɨ lɨ́ e. U koko manga lɨ ndula na eti de. La di-e, u koko malɨbhombi lɨ kobe de. ");
INSERT INTO mdm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kpála na babadha-a, ka bádha ’ngʉ́ ɨnde lɨ bua anɨ-e, anɨ méne bhadi engʉ́ na babadha. La di-e, kpála na sisiti-e, ka siti ’ngʉ́ ɨnde lɨ bua anɨ-e, anɨ méne bhadi engʉ́ na sisiti. Engʉ́ ɨnde ngakoto bhʉ́ ’bhɵ kpála-a, a ko engʉ́ ɨnde ngayie alɨ bua anɨ ko.» ");
INSERT INTO mdm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«La ka nɨ yi ngaꞌɨ ma lɨe ndʉ ’kpɨ́ hana me: ‹Ngámá, Ngámá?› Yi la ngamene engʉ́ ɨnde ma ngapa e pɨ yi me yi mene e ade. ");
INSERT INTO mdm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kpála bini ɨnde agó abháka ma, adjé ’li ma, anɨ tsia méne maka ma apa lɨe, ma akʉnda napana pɨ yi me anɨ maka da. ");
INSERT INTO mdm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Anɨ maka kpála ɨnde aholo nayiki etɨ. Anɨ adjɨ edú tsutsu, anɨ atsia aꞌo ’dhʉ ’dhʉ-o pɨ́ teme. Lɨ engu asi lɨe, a ago atʉ lɨe lɨ kʉte etɨ-o, etɨ ango-o tsia dyɨkɨ de, anga a alʉ kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Engʉ́ bini, kpála bhende adje ’li ma, anɨ tsia mene maka ma apa lɨe de-e, anɨ maka kpála ɨnde ayiki etɨ gba e pɨ́ doto. ’Dhʉ ’dhʉ tété ade. Lɨ engu asi lɨe, a ago atʉ lɨe lɨ kʉte etɨ-o. Etɨ-e atuko bha kolo má gala, a atsia agʉgʉmʉ hana má kpɵkɵbhɵ!» ");
INSERT INTO mdm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pɨta anɨ andjia napa ndʉ ongʉ́ bhomʉ-o lɨe hana pɨ okpála-a, anɨ atsia atapa bhʉ́ kʉtɨ na Kapalanauma. ");
INSERT INTO mdm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oo, abhʉ́ Kapalanauma-a, ngámá bini gba osʉdha na Loma, adʉ ne bali gba e bini ɨnde anɨ adʉ akʉnda e naali. A adʉ lɨ bali ango-o ne kuo masɨkpe de me anɨ kodho bua e. ");
INSERT INTO mdm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lɨ anɨ adje ’ngʉ́ gba Yesu-o lɨe, anɨ atsia atima obhelesɨ okpála koko gba omaYuda agba Yesu. U anʉ napa pɨ anɨ me, anɨ go kobho bali gba ngámá ango-o. ");
INSERT INTO mdm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lɨ obhelesɨ okpála bhomʉ-o akolo de Yesu lɨe, u atsia aholo nakikiliki lɨo pɨ anɨ me: «Mʉ tɨ da namene ehe ɨnde anɨ ayo e pɨ anɨ, ɨ dʉ me mʉ nde akʉnda-o, anga anɨ ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Anɨ kʉnda di omaha nɨ́ naali. Anɨ ayiki etɨ nadje lɨ́lɨ gba Moidje pɨ nɨ́ ngae.» ");
INSERT INTO mdm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Abhomʉ-o, Yesu atsia aholo ’nʉ́ ne uo. Anɨ akolo lɨe de kʉtɨ-e masɨkpe-e, ngámá gba osʉdha-a atsia atima obɨ e me u pa pɨ anɨ me: «Ngámá, mo ondála lɨmʉ de. Ma ne kpála na padhá. A ayo ka mʉ nalɨ bhʉ́ ’tɨ gba ma-a de. ");
INSERT INTO mdm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kaka-a, ma u ɨgɨnɨ lɨma ndjɨndjɨ de me ma go kolo lɨ mʉ ngama-a de. Engʉ́ bini, pa bha koli eli bini, amba bali gba ma-a kobho. ");
INSERT INTO mdm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma ngapa mo-o, anga ma sa lɨ́lɨ gba ongámásɨ. Ma la di ngaha lɨ́lɨ pɨ osʉdha. Ma pa pɨ bhe bini-e me: ‹Nʉnʉ!› Anɨ nʉ́. Ma pa pɨ bhe koko-o me: ‹Gogo!› Anɨ gó. Ma pa pɨ bali gba ma-a me: ‹Mene ’he ɨnde!› Anɨ méne.» ");
INSERT INTO mdm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lɨ Yesu adje engʉ́ ɨnde lɨ ngámá bhomʉ-o apa e lɨe, anɨ angamba naali. Anɨ adji lɨe, anɨ atsia apa pɨ bhiti okpála ɨnde adʉ akpata anɨ-e me: «Ma apa pɨ yi me, ma bhaka nga ngua kpála ɨnde abhuka ma me-e de, belegʉ de bhʉ́ ká omaƗsalaele!» ");
INSERT INTO mdm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lɨ okpála na titima agie lɨo lɨe agba ngámá-a, u abhaka me kuo nde ayie lɨ bali gba ngámá ango-o ayie. ");
INSERT INTO mdm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pɨta lɨ Yesu akobho bali gba ngámá bhomʉ-o lɨe, anɨ atsia atapa bhʉ́ gʉdhʉ na Naine. Omʉkpata gba anɨ ne okpála bhelé anʉ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anɨ akolo lɨ ’bhɵ bhotɨ na gʉdhʉ-o lɨe, a abhaka me u nde adji ne ngbangba makombi bini ngʉ́ nazɨzɨ. A ko nanɨ koli ndɨlɨ na bhobhoko bini gba ɵkɵ bini na ɵɵlɵ. Okpála bhelé na gʉdhʉ bhomʉ-o adʉ bhʉ́ dabɨlɨ bini ne ɵlɵ ango-o. ");
INSERT INTO mdm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Abhomʉ-o, Ngámá Yesu au anɨ. Lɨ anɨ au anɨ lɨe, anɨ adje ndjinga anɨ naali. Anɨ atsia apa pɨ anɨ me: «ꞌO naku ’gbá!» ");
INSERT INTO mdm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pɨpɨta-a, anɨ adyudyo lɨe, anɨ aꞌo ’kpa e lɨ ngbangba-o. Abhomʉ-o, okpála ɨnde abɨ kuo atsia alʉ. Yesu atsia apa pɨ makombi bhomʉ-o me: «Ma apa pɨ mʉ me, yie bhʉ́lá!» ");
INSERT INTO mdm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kpála ɨnde adʉ ɨgɨnɨ me anɨ nde akpi-e, anɨ ayie bhʉ́lá, anɨ adʉ madʉ. Anɨ atsia aholo nagama ’ngʉ́. Abhomʉ-o, Yesu atsia aha anɨ pɨ ’hi e. ");
INSERT INTO mdm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ndʉ okpála hana adje tsʉlʉ. U adʉ adhɵgɵ Ebhe, u atsia adʉ apa me: «’Ngbé polofeta akoto bhʉ́ ká nɨ́! Ebhe ago nateteke okpála gba e-o!» ");
INSERT INTO mdm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ngali na engʉ́ lɨ Yesu amene e atsia agbolo bhʉ́ ndu doto na Yudaya libhomu di ne bhʉ́ okʉtɨ na ngongo-o hana. ");
INSERT INTO mdm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lɨ omʉkpata gba Djaa agie lɨo lɨe, u atsia akpokpo ndʉ ongamba ’ngʉ́ ɨnde lɨ Yesu amene e hana pɨ Djaa. Abhomʉ-o, anɨ aꞌɨ okpála bhisi bhʉ́ ká uo. ");
INSERT INTO mdm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Anɨ atsia atima uo ngʉ́ nayi Yesu me: «Ne me mʉ ne Masɨya ɨnde ngago, ne me ayo me ya adjeke kpála koko?» ");
INSERT INTO mdm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lɨ okpála bhomʉ-o akolo lɨe de anɨ-e, u atsia apa pɨ anɨ me: «Djaa bhʉlʉ nabatisa okpála atima ya me ya go yi mʉ me: ‹Ne me mʉ ne Masɨya ɨnde ngago, ne me ayo me ya djeke kpála koko?›» ");
INSERT INTO mdm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bha lɨ nedhɨnga bhomʉ-o, Yesu akobho okpála bhelé na kuo. Anɨ akobho obhende adʉ ne okuo ngangá. Anɨ akobho di obhende adʉ ne osisiti bua bhʉ́ o-o. Anɨ atsia abhulu di djila okpála bhelé ɨnde ɨ u ’kpɨ́ de-e bhʉ́ bádha bhʉ́ ’bu gba e-o. ");
INSERT INTO mdm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pɨpɨta-a, anɨ atsia agie pɨ okpála lɨ Djaa atima o-o me: «Yi nʉ kpokpo pɨ Djaa engʉ́ ɨnde yi au e, di ne bhende yi adje e ko. Okpála ɨ u ’kpɨ́ de-e ngau ’kpɨ́. Obhende ne eze lɨ ’dhʉ o-o, u ngadhʉkʉ ndjɨndjɨ. Okpála na kába ngakobho. Obhende ɨ dje ’kpɨ́ de-e ngadje ’kpɨ́. Obhende amu-o ngazuku. Ma ngakpokpo Bádha Ngali pɨ obhʉlʉ ndɨbhɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A ko djalɨ pɨ kpála ɨnde ɨ bhúka ma ne bua na bhisi bhisi de ko!» ");
INSERT INTO mdm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bhiti okpála adʉ oo. Pɨta lɨ obhʉlʉ titima gba Djaa agbida lɨe, Yesu atsia aholo akpokpo ’ngʉ́ gba Djaa pɨ uo me: «Yi anʉ ɨgɨnɨ natsia abhʉ́ ’gʉ-o nɨ? Yi anʉ ɨgɨnɨ natsia kpála ɨnde maka mbamba ɨnde ngadyɨkɨ ka anvi-e? A mo-o ade. ");
INSERT INTO mdm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɨ dʉ mo-o de-e, yi anʉ la ɨgɨnɨ natsia nɨ? Kpála ɨnde adyɨ babadha bongo-o ? A mo-o ade, anga obhende ngadyɨ babadha bongo-o, ɨnde di ne ká tɨa ka o-o ngadʉ abhʉ́ ’tɨ gba ongámásɨ. ");
INSERT INTO mdm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yi anʉ nga la ɨgɨnɨ natsia nɨ? Polofeta? A moko, ma apa pɨ yi me, yi au bhende ane belegʉ polofeta mane. ");
INSERT INTO mdm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Padhá de, anga a ko kpála ɨnde lɨ eli gba Ebhe-e apa ’ngʉ́ gba e me: ‹Ebhe apa me, ma ngatima bhʉlʉ titima gba ma-a pɨ mʉ kalanʉ ngʉ́ naleke kpadjɨ pɨ mʉ.› ");
INSERT INTO mdm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma apa pɨ yi me, Djaa ngbéngbé ane ndʉ okpála hana. Engʉ́ bini, kpála ɨnde ane ne mboye bhʉ́ Naʉ gba Ebhe-e , anɨ ane anɨ ne engbé.» ");
INSERT INTO mdm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ndʉ okpála hana, belegʉ ondɵmbɨ na mandjandja adʉ adje Yesu. Abhomʉ-o, u ambɨla nanɨ ngbili ’ngʉ́ gba Ebhe-e lɨe, Djaa atsia abatisa uo. ");
INSERT INTO mdm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Engʉ́ bini, omʉFalisai ne omʉsuno na lɨ́lɨ gba Moidje ayala nanɨ me Djaa batisa o. U amene lɨe mo-o, u ayala engʉ́ ɨnde lɨ Ebhe adʉ akʉnda e pɨ uo-o. ");
INSERT INTO mdm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Do Yesu matá me: «Ma tɨ́ da nasuno okpála na nakɨ sɨ lɨ da? Uo maka da? ");
INSERT INTO mdm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Uo maka ongɨsɨ ɨnde adʉlʉ bhʉ́ daposo. Okoko ngasʉsʉla pɨ obɨ o me: ‹Ya abhɨ ngbabi na ebɨ pɨ yi, engʉ́ bini, yi tsia dho ’bɨ de! Ya ali etsi na da kuo pɨ yi, engʉ́ bini, yi ku ’gbá de!› ");
INSERT INTO mdm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Padhá de, anga Djaa bhʉlʉ nabatisa okpála ago, anɨ zʉ ’he maka okpála koko de, anɨ ndjɨ di vino de, do yi me: ‹A bhʉ́ anɨ ne siti bua!› ");
INSERT INTO mdm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngama, Ndɨlɨ gba kpála, ma ago, ma ngazʉ ’he maka okpála koko, ma ngandjɨ vino, do yi me: ‹Yi tsia nga kpála ɨnde ngabhundja bha bini nazʉ ’he di ne nandjɨ vino! Anɨ ngakʉnda ondɵmbɨ na mandjandja, a ko la di olia okpála na sisiti!› ");
INSERT INTO mdm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Engʉ́ bini, ndʉ okpála hana ɨnde abhuka ɨmbɨlangʉ gba Ebhe-e, u ambɨla me ɨmbɨlangʉ ango-o ngbingbili.» ");
INSERT INTO mdm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A adʉ nanɨ mʉFalisai bini, anɨ aꞌɨ Yesu ngʉ́ nazʉ ’he bhʉ́ dabɨlɨ bini ne e. Yesu alɨ bhʉ́ ’tɨ gba mʉFalisai-o. Oo, anɨ atsia aholo nazʉ ’he-o. ");
INSERT INTO mdm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɵlɵ bini na sisiti adʉ bhʉ́ gʉdhʉ bhomʉ-o. Anɨ adje lɨe me Yesu ngazʉ ’he abhʉ́ ’tɨ gba mʉFalisai bhomʉ-o, anɨ ago ne gɨlɨ bini ɨnde u abho e lɨ teme ɨnde u aꞌɨ e me alabatele. Gɨlɨ ango-o abedhe nanɨ ne mʉngotsi bedhe. ");
INSERT INTO mdm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Anɨ akolo lɨe, anɨ atsia akita bhʉ́ li ’dhʉ Yesu lɨ pápá ne akele anɨ. Anɨ aholo naku ’gbá, ngʉla adʉ atuko lɨ ’dhʉ Yesu. Abhomʉ-o, anɨ aholo nakukuo ne sundjo e. Anɨ akama ’dhʉ anɨ, anɨ atsia aha mʉngotsi-e, anɨ atuko tété. ");
INSERT INTO mdm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lɨ mʉFalisai ɨnde aꞌɨ Yesu au lɨe mo-o, anɨ atsia apa lɨ bua e me: «Kpála ɨnde-e, a ko bha ndjʉ polofeta de kʉkʉlʉ! Padhá de, anga ɵlɵ ɨnde ngabu ’kpa e lɨ anɨ bhomʉ-o, a ko siti ɵlɵ. Anɨ mbɨla la-a de!» ");
INSERT INTO mdm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Abhomʉ-o, Yesu atsia apa pɨ mʉFalisai-e me: «Simo, ma mbo ne engʉ́ bedɨ napapa pɨ mʉ.» Simo atsia agie me: «Mʉsuno, papa.» ");
INSERT INTO mdm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu atsia apa me: «Kpála bini aha nanɨ bopulu pɨ okpála bhisi. Anɨ aha pɨ kpála bhe bini-e lɨ́ falanga kámá bhuluvue. Anɨ atsia aha pɨ kpála bhe koko-o lɨ́ falanga ndjɨkpa bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lɨ tɨa dʉ la lɨe ka okpála ango-o ngʉ́ nagigie de-e, abhomʉ-o, anɨ atsia ambu lɨ bopulu gba ndʉ uo bhisi hana. Bhʉ́ ká okpála bhisi bhomʉ-o, akʉ́nda anɨ ané mane ne bhedho?» ");
INSERT INTO mdm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo atsia agie me: «Ma abhundja me a ko kpála bhende u ambu lɨ bopulu gba e adʉ bhelé naali ko.» Do Yesu pɨ anɨ me: «Mo opa ndjɨndjɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pɨpɨta-a, anɨ adji lɨe ne lɨ pápá gba ɵlɵ-o, anɨ atsia apa pɨ Simo me: «Mo ou engʉ́ lɨ ɵlɵ ɨnde-e amene e au? Ma alɨ lɨe bhʉ́ ’tɨ gba mʉ-o, mʉ ha engu mʉma ngʉ́ navʉlʉ ’dhʉ ma de. Engʉ́ bini, ngaanɨ-e, anɨ avʉlʉ ’dhʉ ma ne ngʉla na djila e. Anɨ atsia akuo ne sundjo e. ");
INSERT INTO mdm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʉ kama ma de. Engʉ́ bini, ngaanɨ-e, nayie maka ma alɨ ɨgɨnɨ lɨe sɨ-e, akolo pɨ mbɨa ɨnde-e, anɨ ꞌo nakama ’dhʉ ma de. ");
INSERT INTO mdm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉ tuko emʉ pɨ́ ’ndjɨ ma de. Engʉ́ bini, ngaanɨ-e, anɨ atuko mʉngotsi lɨ ’dhʉ ma. ");
INSERT INTO mdm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaka-a, ma apa pɨ mʉ me, mʉkʉnda na ngbéngbé ɨnde anɨ asuno e, apana me u aꞌe bhiti siti ’ngʉ́ gba anɨ-e aꞌe. Engʉ́ bini, kpála ɨnde u aꞌe siti ’ngʉ́ gba e me a nde yeye-e, anɨ pána bhadi mʉkʉnda na yeye.» ");
INSERT INTO mdm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Abhomʉ-o, anɨ atsia apa pɨ ɵlɵ bhomʉ-o me: «Ma aꞌe osisiti ’ngʉ́ gba mʉ-o aꞌe.» ");
INSERT INTO mdm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Okpála ɨnde adʉ azʉ ’he bhʉ́ dabɨlɨ bini ne anɨ aholo nabhundja me: «A ɨnde-e mangua kpála dho? Anɨ nga ꞌe belegʉ siti ’ngʉ́!» ");
INSERT INTO mdm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Abhomʉ-o, Yesu atsia apa pɨ ɵlɵ-o me: «Ebhe akobho mʉ, anga mo obhuka ma. Nʉ ne guo ’ngʉ́ .» ");
INSERT INTO mdm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pɨpɨta-a, Yesu adʉ adholo bhʉ́ ndʉ ogʉdhʉ di ne bhʉ́ ndʉ okʉtɨ hana. Anɨ adʉ akpokpo Bádha NgaliNaʉ gba Ebhe-e ne ndʉ bɨlɨ hana. Omʉkpata ndjɨkpa ne ká bhisi-e adʉ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Olɨsɨ koko nanɨ lɨ Yesu apandja osisiti bua bhʉ́ o, ne obhe anɨ akobho o ne okuo-o, a adʉ di bhʉ́ dabɨlɨ bini ne anɨ. A dʉ nanɨ: Malɨa (u aꞌɨ e me kpála na gʉdhʉ na Magadala) nanɨ lɨ Yesu apandja osisiti bua bhʉ́ e mananɨka-o; ");
INSERT INTO mdm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Djaanɨ, wala Kudja, ngámá na kulu gba ’ngbé ngámá Elode; Sudjana ne olɨsɨ koko bhelé. Ndʉ olɨsɨ bhomʉ-o hana adʉ aha tɨa gba o ngʉ́ nateteke Yesu ne omʉkpata gba e ne di. ");
INSERT INTO mdm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Okpála adʉ nayie bhʉ́ gʉdhʉ bini ne bini, u adʉ ago abhaka Yesu. Lɨ okpála bhelé adʉ apɵkɵbhɵ bhʉ́la o lɨe de anɨ-e, anɨ atsia apa gbitaku ɨnde-e me: ");
INSERT INTO mdm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Kpála bini anʉ ngʉ́ nabala nguwa abhʉ́ ’dyɨ gba e. Anɨ adʉ ababala lɨe, té nguwa koko atsia abala lɨ kpadjɨ. Okpála adedele ne ’dhʉ o, odhu atsia ago, u azʉ bhobhomʉ-o hana. ");
INSERT INTO mdm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Koko abala lɨ bɨlɨ na teme. Lɨ ezʉ-o aze lɨe, atsia aꞌʉlʉ anga engu dʉ bhʉ́ doto sasa de. ");
INSERT INTO mdm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Koko atsia abala lɨ bɨlɨ na eti. A akɵ lɨe, ezʉ-o akɵ ne eti-e bhʉ́ dabɨlɨ bini. Eti-e atsia agaga ezʉ-o. Kaka-a, ezʉ-o bhele ndjɨndjɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Engʉ́ bini, koko atsia abala naae bhʉ́ doto na babadha. Ezʉ-o akɵ, a atsia alɨ lɨ́lɨ́. Nguwa bini ne bini alɨ lɨ́lɨ́ kámá bini.» Yesu atsia apa matá me: «Yi dje ndjɨndjɨ, ɨ dʉ me a nde lɨ yi ne ’dje ’dje ngʉ́ nadje ’kpɨ́ ko!» ");
INSERT INTO mdm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Omʉkpata gba Yesu ayi anɨ me: «Ta gbitaku bhomʉ-o pɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Anɨ atsia agie pɨ uo me: «Ngayi-e, yi ambɨla naayi engʉ́ ɨnde awo nanɨ lɨe kalanʉ pɨndjɨ Naʉ gba Ebhe-e ambɨla. Engʉ́ bini pɨ okpála koko-o, ma akpo engʉ́ bhomʉ-o bhʉ́ ogbitaku maka lɨ Bhuku gba Ebhe apa lɨe me: ‹U tɨ da natsia ’kpɨ́, engʉ́ la bini, u ú ’kpɨ́ de. U tɨ da nadje ’kpɨ́, engʉ́ la bini, u mbɨ́la tata-a de.›» ");
INSERT INTO mdm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Ta gbitaku bhomʉ-o me, nguwa-a, a ko eli gba Ebhe-o . ");
INSERT INTO mdm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nguwa bhende abala lɨ kpadjɨ-e, a ko okpála bhende ngadje eli gba Ebhe-o. Engʉ́ bini, lɨ Djabʉlʉ gó, anɨ tsia dhépe eli ango-o lɨ bua uo, ngʉ́ nagbite kpadjɨ pɨ uo me u abhúka de, amba Ebhe akóbho uo de. ");
INSERT INTO mdm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nguwa bhende abala lɨ bɨlɨ na teme-e, a ko okpála bhende ngadje eli gba Ebhe-e, u tsia sía ne djalɨ hana. Engʉ́ bini, eli ango-o lɨ́ lɨ bua uo de. U bha ngabhuka ngʉbula nedhɨnga bedɨ. Lɨ nale kolo-o, u ꞌó ká nabhuka gba o-o. ");
INSERT INTO mdm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nguwa bhende abala lɨ bɨlɨ na oeti-e, a ko okpála bhende ngadje eli gba Ebhe-o. Engʉ́ bini, u ne gʉmʉ ndʉ ’he na doto ngangá. U ne gʉmʉ tɨa na doto ne odjalɨ na mʉkobho na doto. Gʉmʉ tɨa na doto ne odjalɨ na mʉkobho na doto ango-o ngagaga Eli-o. Kaka-a, eli bhomʉ-o lɨ́ lɨ́lɨ́ nabhele mabhele de. ");
INSERT INTO mdm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nguwa bhende abala bhʉ́ doto na babadha-a, a ko okpála bhende ngadje eli gba Ebhe ne bua na babadha, u tsia zɨ́ba. U líla ndjɨndjɨ, u tsia lɨ́ lɨ́lɨ́ ka kekele gba o ko.» ");
INSERT INTO mdm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ɨ dʉ me kpála bini nde adhedhe eke-e, anɨ búku ne lʉsa de. Anɨ tó di asa polo de. Engʉ́ bini, anɨ ꞌó pɨ́ ’he ngʉbula me okpála ɨnde ngalɨ bhʉ́ ’tɨ-e, u u ’kpɨ́ tété ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A moko, ndʉ ’he hana ɨnde awo lɨe mawo-o, akóto bhʉ́ mbasʉ. Ndʉ ’he ɨnde na pepe hana akóto lɨ zɨ ’kpɨ́, lɨ okpála tsia mbɨ́la. ");
INSERT INTO mdm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kaka-a, ꞌe-e! Yi lila lɨyi bhʉ́ nadje eli-o, anga kpála lɨ ehe nde ka e, u ahá matá koko pɨ anɨ pépé. Engʉ́ bini, kpála ɨnde lɨ ehe nde ka e ade-e, u adhépe belegʉ mboye ’he bhende anɨ ngabhundja me a ka nɨ ko.» ");
INSERT INTO mdm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","’Hi Yesu ne ondaise Yesu ago ngʉ́ natsia anɨ. Engʉ́ bini, u ale nakolo lɨ anɨ pima ka bhiti okpála-o. ");
INSERT INTO mdm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Abhomʉ-o, u atsia apa pɨ Yesu me: «’Hi mʉ ne ondaise mʉ akilidjo, u ngakʉnda nau mʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Engʉ́ bini, Yesu atsia apa pɨ ndʉ uo hana me: «’Hi ma ne ondaise ma-a, a ko okpála ɨnde ngadje eli gba Ebhe ne namemene ko.» ");
INSERT INTO mdm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ekpɨ́ bini pɨpɨta-a, Yesu ne omʉkpata gba e aꞌʉ bhʉ́ zabʉ bini. Anɨ atsia apa pɨ uo me: «Nɨ́ gulu ekpɵ-o ai ’ngu.» Abhomʉ-o, u atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nedhɨnga u adʉ agulu ’ngu-o lɨe, Yesu atsia atɨ ne ela. Kpéke anvi na gipi aholo nape pɨ́ ekpɵ-o. Engu aholo nabedhe bhʉ́ zabʉ-o, kuo atsia akolo de uo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Omʉkpata adyudyo lɨo de Yesu masɨkpe, u atsia azʉkʉ anɨ me: «Mʉsuno, Mʉsuno, nɨ́ adji amú!» Yesu azʉkʉ, anɨ atsia ambe bhʉ́ ’ndjɨ anvi di ne wowo ’ngu-o. Abhomʉ-o, anvi-e aꞌo nape, engu-o atsia akolo guguo. ");
INSERT INTO mdm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Do anɨ pɨ uo me: «Nabhuka gba yi-e su?» Engʉ́ bini, u adʉ adje tsʉlʉ, u atsia adʉ angamba naali. Abhomʉ-o, u adʉ apa sʉnda o me: «A e mangua kpála dho ɨnde ngaha belegʉ lɨ́lɨ pɨ anvi ne engu, uo ngamemene!» ");
INSERT INTO mdm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Abhomʉ-o, u akolo bhʉ́ ndu doto gba okpála na Gelasa, ayi ekpɵ bhʉ́la ndu doto na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nedhɨnga lɨ Yesu adʉ akoto bhʉ́ zabʉ-o lɨe, kpála bini na kʉtɨ bhomʉ-o ago ngʉ́ nabhaka anɨ. Kpála ango-o, osisiti bua adʉ bhʉ́ anɨ. Ekpɨ́ bhelé, anɨ dʉ adyɨ bongo de, anɨ dʉ asɨ bhʉ́ ’tɨ de. La-a, anɨ adʉ bha bini adʉ bhʉ́ ká olata. ");
INSERT INTO mdm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Siti bua-a adʉ agbʉlʉ anɨ pɨko. Abhomʉ-o, u atsia adʉ agbite ’kpa anɨ ne ’dhʉ anɨ ne ekpʉ́ di ne gbɨndjɨlɨ ngʉ́ nalila anɨ. Engʉ́ bini, kpála ango-o adʉ atsotsolo gbɨndjɨlɨ di ne ekpʉ-o má dhu dhu dhu! Siti bua atsia adʉ amba bhʉ́la anɨ ne abhʉ́ mili bɨlɨ. Lɨ kpála ango-o au Yesu lɨe me-e, anɨ aholo natʉ ꞌue. Abhomʉ-o, anɨ atɨ bhʉ́ li ’dhʉ Yesu, anɨ atsia asʉla kpekpeke me: «Yesu, Ndɨlɨ gba Ebhe na Apɨ́ ’Kpɨ́, mo okʉnda namene ngʉ́ ma pɨ? Ma ayo ka mʉ me, mo oméne ma sisiti de!» Anɨ apa nanɨ mo-o, anga Yesu adʉ aha lɨ́lɨ pɨ siti bua ango-o me anɨ koto bhʉ́ kpála bhomʉ-o makoto. ");
INSERT INTO mdm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu atsia ayi kpála ango-o me: «A ’lɨ mʉ pɨ?» Anɨ agie me: «A ’lɨ ma me ‹Bhelé.›» Anɨ apa mo-o anga osisiti bua bhelé alɨ nanɨ bhʉ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Osisiti bua ango-o atsia adʉ akikiliki lɨo pɨ Yesu me: «Mo ombá ya bhʉ́ tsu ’dú bhe má ngbongobho-o de!» ");
INSERT INTO mdm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A abhaka me ’ngbé piga opame bini nde ngagɨlɨ ’zʉ gba o pɨ́ ’ta oo. Osisiti bua-a atsia apa pɨ Yesu me: «Ha kpadjɨ pɨ ya, ya lɨ bhʉ́ opame bhomʉ-o.» Anɨ atsia azɨba pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Abhomʉ-o, osisiti bua aze bhʉ́ kpála ango-o, u atsia amba lɨo bhʉ́ opame-o. Piga opame bhomʉ-o libhomu ayie ne holo apɨ́ ’ta, u anʉ alilinda bhʉ́ ekpɵ-o, u atsia amu. ");
INSERT INTO mdm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lɨ omʉlila gba opame au engʉ́ ɨnde akodho ’kpɨ́-e lɨe, u atsi ne holo, u atsia anʉ nakpokpo ngali ango-o abhʉ́ gʉdhʉ ne abhʉ́ okʉtɨ. ");
INSERT INTO mdm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Okpála aze ngʉ́ nau engʉ́ ɨnde akodho ’kpɨ́-o. U akolo de Yesu lɨe, u abhaka me kpála ɨnde lɨ osisiti bua aze bhʉ́ e nde adʉ kuto bhʉ́ li ’dhʉ Yesu. Anɨ adʉ me anɨ nde adyɨ bongo, anɨ nde ngabhundja ’ngʉ́ hana ndjɨndjɨ. Abhomʉ-o, tsʉlʉ atsia aholo uo. ");
INSERT INTO mdm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Okpála ɨnde au ndʉ ’ngʉ́ bhomʉ-o hana atsia akpokpo pɨ uo maka lɨ Yesu akobho kpála ango-o lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abhomʉ-o, ndʉ okpála hana na ndu doto bhomʉ-o atsia apa pɨ Yesu me anɨ yie bhʉ́ kʉtɨ gba o mayie, anga u adʉ adje tsʉlʉ naali. Yesu aꞌʉ bhʉ́ zabʉ-o ngʉ́ naꞌe ne enʉ́. ");
INSERT INTO mdm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kpála ɨnde lɨ osisiti bua aze bhʉ́ e aholo nalopolo lɨe pɨ Yesu me: «Yesu, ɨ dʉ me mʉ nde akʉnda-a, mo oꞌó ka ma de, nɨ́ nʉ ne mʉ.» Engʉ́ bini, Yesu agie anɨ sidi, anɨ atsia apa pɨ anɨ me: ");
INSERT INTO mdm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Gie lɨmʉ agba mʉ, amba mʉ kpokpo ndʉ ’ngʉ́ ɨnde lɨ Ebhe amene e pɨ mʉ-o hana.» Abhomʉ-o, kpála ango-o atsia atapa ne kpokpo ndʉ ’ngʉ́ lɨ Yesu amene e pɨ anɨ-e hana bhʉ́ gʉdhʉ libhomu. ");
INSERT INTO mdm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nedhɨnga lɨ Yesu agie lɨe lɨe alɨ pála ekpɵ koko-o, okpála bhelé asia anɨ ndjɨndjɨ, anga ndʉ uo hana adʉ adjeke anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lɨ nedhɨnga bhomʉ-o, kpála bini akolo. A adʉ ’lɨ anɨ me Yailo. Anɨ adʉ nanɨ ngámá na etɨ nadje lɨ́lɨ gba Moidje na bɨlɨ bhomʉ-o. Anɨ atɨ bhʉ́ li ’dhʉ Yesu, anɨ atsia akikiliki lɨe pɨ anɨ me anɨ nʉ agba nɨ, ");
INSERT INTO mdm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","anga ndɨlɨ gba anɨ na ɵɵlɵ adʉ masɨkpe de nakpi. Koli ndɨlɨ bhomʉ-o bha nanɨ ka anɨ bini, anɨ adʉ ne kalanga ndjɨkpa ne ká bhisi. Lɨ kpadjɨ-e, bhiti okpála asʉlʉ Yesu má wakaka! ");
INSERT INTO mdm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A abhaka me ɵlɵ bini nde oo. Ɵlɵ ango-o, ngʉte adʉ atuko lɨ anɨ bhʉ́ sʉnda kalanga ndjɨkpa ne ká bhisi. Anɨ andjia nanɨ tɨa lɨe hana pɨ omʉtɨa, engʉ́ bini, kpála bini tɨ nanɨ da nakobho anɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Anɨ ago ne akele Yesu, anɨ atsia abu ’kpa e lɨ bongo ’ta anɨ-o. Ngʉte-e aꞌo bha kolo natuko lɨ anɨ maka ndjombe. ");
INSERT INTO mdm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Abhomʉ-o, Yesu atsia ayi me: «A abu ’kpa e lɨ ma da?» Ndʉ uo hana agie me: «A ko naae ya de!» Piele atsia apa pɨ Yesu me: «Mʉsuno, bhiti okpála ɨnde asa mʉ ngbalina ɨnde-e, ngasʉlʉ mʉ ngao.» ");
INSERT INTO mdm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Engʉ́ bini, Yesu atsia apa me: «Kpála bini abu ’kpa e lɨ ma, anga ma ambɨla me té angu gba ma-a akoto.» ");
INSERT INTO mdm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ɵlɵ ango-o au me Yesu ambɨla engʉ́ ɨnde nɨ amene e ambɨla. Abhomʉ-o, anɨ ago ne nagʉkʉ, anɨ tsia atɨ bhʉ́ li ’dhʉ Yesu. Anɨ atsia akpokpo pɨ Yesu kala ndʉ okpála hana ta ’ngʉ́ ɨnde anɨ abu ’kpa e lɨ anɨ lɨe, di ne maka anɨ akobho bha lɨe maka ndjombe-o. ");
INSERT INTO mdm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu pɨ anɨ me: «Ndɨ ɵlɵ-e, mo okobho, anga mo obhuka ma kʉkʉlʉ. Nʉ ne guo ’ngʉ́ .» ");
INSERT INTO mdm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nedhɨnga lɨ Yesu adʉ apa lɨe mo-o, kpála bini ayie agba ngámá Yailo, anɨ ago apa pɨ anɨ me: «Ndɨlɨ gba mʉ-o andjili. Mo ondála matá mʉsuno de.» ");
INSERT INTO mdm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Engʉ́ bini, lɨ Yesu adje anɨ lɨe, anɨ atsia apa pɨ Yailo me: «Mo odjé tsʉlʉ de, dʉ bha ne nabhuka, ndɨlɨ gba mʉ-o akóbho makobho.» ");
INSERT INTO mdm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lɨ Yesu akolo lɨe agba ngámá Yailo, anɨ zɨba de me kpála bini lɨ nganda nɨ abhʉ́ ’tɨ-e de, bha bini Piele, Djaa ne Djakɨ, a la bhadi-e ’dyɨ ndɨlɨ-e ne ’hi ndɨlɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ndʉ okpála ɨnde adʉ oo hana, adʉ atʉ ꞌue ne naku ’gbá ngʉ́ ndɨlɨ ango-o. Abhomʉ-o, Yesu atsia apa pɨ uo me: «Yi ꞌo naku ’gbá! Ndɨlɨ-e kpi de, engʉ́ bini, anɨ tɨla.» ");
INSERT INTO mdm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","La-a, u aholo namʉ anɨ anga u adʉ ambɨla ndjɨndjɨ me ndɨlɨ-e akpi. ");
INSERT INTO mdm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Abhomʉ-o, Yesu aholo ’kpa anɨ, anɨ atsia asʉla kpekpeke me: «Ndɨka ma, yie bhʉ́lá!» ");
INSERT INTO mdm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ndɨlɨ-e azuku, anɨ ayie bhʉ́lá kolo má gala! Yesu atsia aha lɨ́lɨ pɨ uo me, u ha ezʉ pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Okpála ɨnde azu anɨ angamba naali. Engʉ́ bini, Yesu agbele ’dje uo kpekpeke me u apá belegʉ engʉ́ ɨnde akodho ’kpɨ́-e pɨ kpála bini de. ");
INSERT INTO mdm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ekpɨ́ bini, Yesu apo bhʉ́la omʉkpata ndjɨkpa ne ká bhisi gba e-o. Anɨ aha angu pɨ uo me u pandja ndʉ osisiti bua hana bhʉ́ okpála, amba u kobho di okpála na kuo. ");
INSERT INTO mdm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pɨpɨta-a, anɨ atsia atima uo me u nʉ ne kpokpo ngali Naʉ gba Ebhe , amba u kobho di okpála na kuo. ");
INSERT INTO mdm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Anɨ pɨ uo me: «Nanʉ ka yi-e, yi abhá oehe de. Yi ahá ndula de. Yi ahá ehe ngʉ́ nabɨ ’he bhʉ́bhʉ́ de. Yi ahá ezʉ de. Yi ahá falanga de. Kpála bini bhʉ́ ká yi ahá bongo na mbulu bhisi de. ");
INSERT INTO mdm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndʉ etɨ hana u asía yi bhʉ́ e-e, yi dʉ bha oo, akólo lɨ nedhɨnga ɨnde yi ayíe lɨe bhʉ́ etɨ ango-o. ");
INSERT INTO mdm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ndʉ etɨ hana u sía yi bhʉ́ e de-e, yi de koto bhʉ́bhʉ́, amba yi pulu doto na kʉtɨ gba uo ɨnde adhedhe lɨ ’dhʉ yi-o. Bhobhomʉ-o asúno pɨ uo me u amene siti ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Obhʉlʉ titima gba Yesu agbida, u apʉ bhʉ́ ndʉ okʉtɨ hana. U akpokpo Bádha Ngali gba Ebhe-e pɨ okpála. U atsia akobho di okpála na kuo ne ndʉ bɨlɨ hana. ");
INSERT INTO mdm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Elode , ngámá na ndu doto na Galilaya, adje ndʉ ’ngʉ́ lɨ Yesu ne omʉkpata gba e adʉ amene e hana. Abhomʉ-o, mabhundja gba anɨ-e atsia aholo adholo ngangá, anga okpála koko adʉ apa me: «Djaa bhʉlʉ nabatisa okpála azuku!» ");
INSERT INTO mdm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Okoko adʉ apa me: «Polofeta Elɨya akoto bhomʉ-o ngae.» Okoko atsia adʉ apa matá me: «Sʉka opolofeta na kalanʉ-o, azuku bhomʉ-o ngae.» ");
INSERT INTO mdm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Engʉ́ bini, Elode atsia apa naae me: «Ma aha nanɨ lɨ́lɨ-e ngama me u kodho ngʉlʉ Djaa . Kpála bhende ma ngadje okpála apa ’ngʉ́ gba e me-e, a ko matá naae da?» Abhomʉ-o, anɨ atsia adʉ agɨlɨ me nɨ u Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lɨ obhʉlʉ titima agie lɨo lɨe de Yesu-o, u atsia akpokpo ndʉ ’ngʉ́ ɨnde u amene e hana pɨ anɨ. Pɨpɨta-a, anɨ abha uo, anɨ atsia atapa ne uo de okpála tsutsu lɨ pápá na gʉdhʉ na Betesaida. ");
INSERT INTO mdm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Engʉ́ bini, lɨ bhiti okpála bhomʉ-o ambɨla lɨe me u agbida oo, u atsia akpata anɨ. Abhomʉ-o, Yesu asia uo, anɨ atsia akpokpo ’ngʉ́ pɨndjɨ Naʉ gba Ebhe-e pɨ uo. Anɨ atsia akobho di okpála ɨnde adʉ ne kuo ko. ");
INSERT INTO mdm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lɨ ekpɨ́ aholo lɨe nabi-e, obhʉlʉ titima ndjɨkpa ne ká bhisi-e adyudyo lɨo de Yesu, u atsia apa pɨ anɨ me: «Ha kpadjɨ pɨ okpála, amba u gbida nagɨlɨ dabɨlɨ nasɨ tété, di ne ehe nazʉ mazʉ bhʉ́ odjedje kʉtɨ masɨkpe sɨ, anga nɨ́ ei bhʉ́ mili bɨlɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Do Yesu pɨ uo me: «Yi ha ’zʉ pɨ uo ngayi.» U atsia agie me: «A bha ka ya sɨ ne mapa bhuluvue di ne sungu bhisi. Ne me mo okʉnda me ya nʉ nakala ezʉ pɨ ndʉ okpála ɨnde-e hana ngaya?» ");
INSERT INTO mdm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Obhosɨ adʉ nanɨ oo masɨkpe de kutu bhuluvue.) Yesu atsia apa pɨ omʉkpata gba e me: «Yi pa pɨ uo me u popo bhʉ́la o okpála ndjɨkpa bhuluvue, ndjɨkpa bhuluvue, amba u dʉlʉ kuto.» ");
INSERT INTO mdm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Omʉkpata-a amene maka anɨ apa pɨ uo lɨe ko. U atsia apa pɨ ndʉ okpála hana me u dʉlʉ kuto. ");
INSERT INTO mdm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Abhomʉ-o, Yesu aha mapa bhuluvue ne sungu bhisi-o, anɨ atsia ’kpɨ́ ne bhʉ́lá, anɨ atsia agie heni pɨ Ebhe ngʉbula ezʉ bhomʉ-o. Pɨpɨta-a, anɨ agʉmʉ mapa ne sungu-o, anɨ aha pɨ omʉkpata ngʉ́ nagagapa lɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ndʉ uo hana azʉ ’he, u aꞌuꞌu má kpú kpú kpú! Dudu atigala-a, obhʉlʉ titima alo, a atsia abebedhe okíli ndjɨkpa ne ká bhisi. ");
INSERT INTO mdm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A akolo ekpɨ́ bini, Yesu adʉ akpokpo ’ngʉ́ ne Ebhe kpi e kpi me, omʉkpata gba anɨ-e nde de anɨ. Anɨ atsia ayi uo me: «Okpála ngapa me ma ne da?» ");
INSERT INTO mdm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","U agie me: «Okpála koko ngapa me, mʉ ne Djaa bhʉlʉ nabatisa okpála. Okoko me, mʉ ne polofeta Elɨya. Okoko matá me, sʉka opolofeta na kalanʉ-o azuku.» ");
INSERT INTO mdm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Anɨ atsia ayi matá uo me: «A la yi-e, yi ngapa naayi me ma ne da?» Do Piele me: «Mʉ ne Masɨya ɨnde lɨ Ebhe atima e ko.» ");
INSERT INTO mdm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Engʉ́ bini, anɨ agbele ’dje uo kpekpeke, anɨ atsia aha lɨ́lɨ me u apá belegʉ engʉ́ bhomʉ-o pɨ kpála bini de. ");
INSERT INTO mdm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Abhomʉ-o, anɨ atsia apa matá pɨ uo me: «A ayo me ngama, Ndɨlɨ gba kpála-a, ma dje lɨkabhu naali. Obhelesɨ okpála, ongbengbe odimandɵ di ne omʉsuno na lɨ́lɨ gba Moidje ayála ma. U abhɵ́lɵ ma, engʉ́ bini, ekpɨ́ na bata-a, ma tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pɨpɨta-a, anɨ apa pɨ ndʉ okpála hana ɨnde adʉ oo me: «Ɨ dʉ me kpála nde akʉnda nakpata ma-a, a ayo me anɨ ꞌo nabhundja ’ngʉ́ gba e makpe. Ekpɨ́ bini ne bini hana, a ayo me anɨ bɨ kulusi gba e-o, amba anɨ kpata ma. ");
INSERT INTO mdm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Padhá de, anga ɨ dʉ me kpála nde akʉnda nalila mʉkobho gba e, anɨ kpí. La-a, ɨ dʉ me kpála nde akʉnda nakpi ngʉbula ma-a, anɨ tsia kóbho. ");
INSERT INTO mdm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɨ dʉ me kpála nde asia ndʉ ’he na doto hana, engʉ́ la bini, ngaanɨ makpe anɨ ngɨta-a, anɨ tsia kpi-e, a la pɨ anɨ babadha bhʉ́bhʉ́ ne nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɨ dʉ me kpála bini nde adje nʉmʉ lɨ ’ngʉ́ gba ma-a, di ne bhe ma ngapa e-e, ngama Ndɨlɨ gba kpála, ma adjé bhadi nʉmʉ lɨ ’ngʉ́ gba anɨ. A adʉ́ moko lɨ nedhɨnga ma agó lɨe bhʉ́ naʉ na asasaua gba ma, ne bhe gba ’Dyɨ ma, di ne bhe gba oandjelu na bububu-o. ");
INSERT INTO mdm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma apa pɨ yi na paká me, okpála koko bhʉ́ ká obhende ɨnde sɨ-e, mú padhá de, u aú ngaɨza Naʉ gba Ebhe-e kalanʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Masɨkpe de ekpɨ́ madjɨna pɨta anɨ apa ’ngʉ́ bhomʉ-o lɨe, Yesu aha Piele, ne Djaa di ne Djakɨ, anɨ atsia aꞌʉ ne uo apɨ́ ’ta ngʉ́ nakpokpo ’ngʉ́ ne Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Anɨ adʉ akpokpo ’ngʉ́ ne Ebhe lɨe, bhʉ́la anɨ ayipa lɨe, bongo gba anɨ avu má tuu! ");
INSERT INTO mdm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kolo me-e, okpála bhisi aze, u atsia aholo nagama ’ngʉ́ ne anɨ. A adʉ nanɨ Moidje ne Elɨya. ");
INSERT INTO mdm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Zɨ Ebhe asa uo ngbalina. U atsia adʉ akpokpo ’ngʉ́ ne Yesu maka anɨ adji nandjia kulu gba e lɨe ne nakpi ka e abhʉ́ Yelusalema ko. ");
INSERT INTO mdm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piele ne obɨ e adʉ ne ela má yikpokpo! U agbʉngbʉa lɨo lɨe, u au Yesu ne okpála bhisi me zɨ Ebhe nde asa uo ngbalina. ");
INSERT INTO mdm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lɨ okpála bhisi bhomʉ-o adʉ ayie lɨe de Yesu-o, Piele atsia apa pɨ anɨ me: «Mʉsuno, ya sɨ ndjɨndjɨ. A ayo me ya yiki ’tɨ ngbangbalɨ bata, bini pɨ mʉ, bini pɨ Moidje, bini pɨ Elɨya.» (Engʉ́ bini, anɨ dʉ ambɨla ta ’ngʉ́ ɨnde anɨ adʉ apa e de.) ");
INSERT INTO mdm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nedhɨnga anɨ adʉ apa ’ngʉ́ bhomʉ-o lɨe, ndindi atsia ago abuku uo. Lɨ ndindi adʉ abuku uo lɨe, omʉkpata atsia aholo nadje tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bhʉ́ ndindi-e, eli bini akoto, atsia apa me: «Kpála ɨnde-e, a ko Ndɨlɨ gba ma ɨnde ma abhʉ e ko. Yi dje anɨ!» ");
INSERT INTO mdm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pɨta lɨ eli bhomʉ-o andjia lɨe, u au bha ɨbili Yesu kpi e kpi. Nanɨ lɨ nedhɨnga bhomʉ-o, omʉkpata andjili bha má bulu! U tsia pa nga nanɨ engʉ́ ango-o pɨ kpála bini de. ");
INSERT INTO mdm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lɨ ekpɨ́ aseke lɨe, Yesu ne omʉkpata bata-a akɵ eta-o. Okpála bhelé atsia ago ngʉ́ nakɵ lɨo ne Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bhʉ́ ká okpála bhomʉ-o, kpála bini aholo nasʉsʉla me: «Mʉsuno, kikiliako, dje nga bha-a mbo ndjinga ndɨlɨ gba ma na bhobhoko-o. Koli anɨ bha ka ma bini! ");
INSERT INTO mdm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Siti bua ngagbʉlʉ anɨ pɨko. A ngaha pɨ anɨ natʉ ꞌue. A ngadyɨkɨ anɨ kpekpeke má djigi djigi! Lɨ efu holo naze bhʉ́ ’bhɵ anɨ. Bua ango-o le bha nakoto bhʉ́ anɨ pima. Lɨ angu anɨ ndjia má ngba! ");
INSERT INTO mdm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma akikiliki lɨma pɨ omʉkpata gba mʉ-o me u gbe bua ango-o bhʉ́ anɨ, engʉ́ bini, u ale pima.» ");
INSERT INTO mdm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Do Yesu de-e: «Ngayi okpála na nakɨ-e, yi ne nabhuka ade, yi ngamene siti ’ngʉ́. Ma adʉ́ matá ne yi bhʉ́ dabɨlɨ bini ngʉbula ekpɨ́ madho? Ma akíbila matá yi ngʉbula ekpɨ́ madho?» Pɨpɨta-a, Yesu apa pɨ kpála ango-o me: «Go ne ndɨlɨ gba mʉ ei.» ");
INSERT INTO mdm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lɨ ndɨlɨ-e adʉ ago lɨe, bua ango-o adyɨkɨ anɨ má djigi djigi! Anɨ atsia agʉ ꞌi anɨ kuto má gbwe! Abhomʉ-o, Yesu ambe bhʉ́ ’ndjɨ siti bua ango-o. Anɨ akobho ndɨlɨ-o, anɨ atsia aha anɨ pɨ ’dyɨ e. ");
INSERT INTO mdm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ndʉ okpála hana adʉ angamba. U atsia azɨba me Ebhe ne angu naali. Lɨ ndʉ okpála hana adʉ angamba lɨe lɨ ndʉ ’ngʉ́ lɨ Yesu adʉ amene e, anɨ atsia apa pɨ omʉkpata gba e me: ");
INSERT INTO mdm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Yi dje engʉ́ ma adji apa e pɨ yi ɨnde-e ndjɨndjɨ. U apʉ́ ma, Ndɨlɨ gba kpála-a, pɨ okpála na doto.» ");
INSERT INTO mdm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Engʉ́ bini, omʉkpata gba anɨ-e mbɨla nanɨ ta ’ngʉ́ bhomʉ-o de. Ebhe awo nanɨ tata-a pɨ uo mawo. U atsia adʉ adje tsʉlʉ ngʉ́ nayi anɨ tété. ");
INSERT INTO mdm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Abhomʉ-o, omʉkpata aholo amene kpekebhɵ sʉnda o ngʉ́ nambɨla me, a tɨ da nadʉ ngbéngbé bhʉ́ ká o da. ");
INSERT INTO mdm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Engʉ́ bini, lɨ Yesu ambɨla engʉ́ ɨnde u adʉ abhundja e lɨ bua o-o lɨe, abhomʉ-o, anɨ aha mboye ndɨlɨ bini, anɨ aꞌo anɨ de e. ");
INSERT INTO mdm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Anɨ atsia apa pɨ uo me: «Kpála ɨnde asía mboye ndɨlɨ ɨnde-e ka ’lɨ ma-a, anɨ asia bhomʉ-o ma. Kpála ɨnde asía ma-a, anɨ asia la di bhomʉ-o kpála ɨnde atima ma ko. Padhá de, anga kpála ɨnde ane ne mboye bhʉ́ ká yi hana-a, anɨ ane ne engbé ngae.» ");
INSERT INTO mdm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Abhomʉ-o, Djaa adyudyo lɨe de anɨ, anɨ atsia apa pɨ anɨ me: «Mʉsuno, ya au kpála bini ngapandja osisiti bua bhʉ́ okpála ne ’lɨ mʉ. Ya di me yoko anɨ, anga a ko mʉkpata gba mʉ-o maka ya de.» ");
INSERT INTO mdm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Engʉ́ bini, Yesu agie pɨ anɨ me: «Yi ayóko anɨ de, anga kpála ɨnde ɨ yala yi de-e, a ko naayi kpála.» ");
INSERT INTO mdm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lɨ nedhɨnga nagie lɨe ka Yesu abhʉ́lá-a akolo lɨe masɨkpe-e, anɨ atsia aholo kpadjɨ na Yelusalema ne kpéke bua hana. ");
INSERT INTO mdm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Anɨ atima obhʉlʉ titima kalanʉ bhʉ́ kʉtɨ bini na ndu doto na Samalɨa, ngʉ́ naleke ndʉ ’ngʉ́ hana pɨ anɨ ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Engʉ́ bini, anɨ adʉ la anʉ lɨe ne abhʉ́ Yelusalema-a, okpála na kʉtɨ bhomʉ-o atsia ayala nasia anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Omʉkpata Djakɨ ne Djaa au lɨe mo-o, u atsia apa pɨ Yesu me: «Ngámá, mo okʉnda me ya ha lɨ́lɨ me mʉgbálá yie abhʉ́lá, amba a go bhili uo?» ");
INSERT INTO mdm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Engʉ́ bini, Yesu adji bhʉ́la e ne lɨ pápá gba uo, anɨ atsia ambe bhʉ́ ’ndjɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Abhomʉ-o, u atsia agbida bhʉ́ kʉtɨ koko. ");
INSERT INTO mdm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","U adʉ lɨe lɨ kpadjɨ-e, kpála bini apa pɨ Yesu me: «Ma akpáta mʉ lɨ ndʉ bɨlɨ mo onʉ́ lɨe hana.» ");
INSERT INTO mdm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu atsia apa pɨ anɨ me: «A ka onekpɵ di ne odhu ne dabɨlɨ gba o ngʉ́ nasɨ tété. Engʉ́ bini, dabɨlɨ ngʉ́ naguo ka ma, Ndɨlɨ gba kpála tété ade.» ");
INSERT INTO mdm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Anɨ apa matá pɨ kpála koko me: «Kpata ma.» Engʉ́ bini, kpála ango-o apa pɨ anɨ me: «Ngámá, ꞌo nga ma, amba ma nʉ́ zɨ ngaɨza ’dyɨ ma.» ");
INSERT INTO mdm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu agie pɨ anɨ me: «ꞌO okpála bhende amu-o, u zɨ okuo gba o-o, amba ngamʉ-o, mʉ nʉ naamʉ ne kpokpo ngali Naʉ gba Ebhe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kpála koko apa matá pɨ anɨ me: «Ngámá, ma akpáta mʉ makpata. Engʉ́ la bini, ꞌo ngaɨza ma, amba ma nʉ bhana lɨma pɨ opiga gba ma ko.» ");
INSERT INTO mdm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu agie pɨ anɨ me: «Lɨ kpála bini holo namene kulu ne kɵngɵ-o, pɨpɨta anɨ tsia ’kpɨ́ ne sidi-e, kpála ango-o tɨ ne Naʉ gba Ebhe-e de.» ");
INSERT INTO mdm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pɨpɨta-a, Ngámá Yesu alo omʉkpata koko ndjɨkpa mananɨka ne ká bhisi. Anɨ atsia atima uo bhisi bhisi kalanʉ bhʉ́ ndʉ ogʉdhʉ ne ndʉ bɨlɨ hana ɨnde a ayo nako lɨe me, anɨ nʉ bha ngae makpe ko. ");
INSERT INTO mdm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Anɨ atsia apa pɨ uo me: «Nguwa abhʉ́ ’dyɨ bhelé. Engʉ́ bini, okpála namene kulu ango-o bhelé ade. Yi yo ka bhʉlʉ edyɨ-e me anɨ tima okpála na kulu bhelé bhʉ́ edyɨ gba e ko. ");
INSERT INTO mdm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ma atima yi maka okandɵlɵ bhʉ́ ká osia. Yi nʉnʉ! ");
INSERT INTO mdm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yi ahá falanga de. Yi ahá ehe nabɨ ’he bhʉ́bhʉ́ de. Yi ahá malɵkɵ de. Yi adʉ́ ne lʉlʉ lɨ kpadjɨ-e ngʉ́ nayiyi okpála de. ");
INSERT INTO mdm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yi lɨ bhʉ́ ’tɨ bini-e, yi de pa ngaɨza me: ‹Guo ’ngʉ́ gba Ebhe-e dʉ bhʉ́ ’tɨ ɨnde.› ");
INSERT INTO mdm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lɨ kpála ɨnde akʉnda guo ’ngʉ́ dʉ bhʉ́ ’tɨ ango-o, lɨ guo ’ngʉ́ gba yi-e dʉ́ bhʉ́ dabɨlɨ bini ne anɨ. Ɨ dʉ mo-o de-e, nayi na guo ’ngʉ́ gba yi-e gíe lɨe pɨ́ yi. ");
INSERT INTO mdm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yi dʉ bhʉ́ ’tɨ ango-o. Ɨ dʉ me u nde aha ehe nazʉ mazʉ di ne bhe nandjɨ mandjɨ pɨ yi-e, yi de zʉ, amba yi ndjɨ. Padhá de, anga a ayo me kpála na kulu sia makalá na kulu gba e ko. Yi adʉ́ asɨ bhʉ́ ’tɨ ngangá de. ");
INSERT INTO mdm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ɨ dʉ me yi nde alɨ bhʉ́ gʉdhʉ bini-e, lɨ okpála na gʉdhʉ ango-o sia yi-e, yi de zʉ ’he ɨnde u ahá e pɨ yi ko. ");
INSERT INTO mdm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yi kobho obhʉlʉ kuo ɨnde bhʉ́ gʉdhʉ ango-o, amba yi pa pɨ ndʉ okpála hana me: ‹Naʉ gba Ebhe-e akolo de yi masɨkpe.› ");
INSERT INTO mdm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Engʉ́ bini, ɨ dʉ la me yi nde alɨ bhʉ́ gʉdhʉ bini-e, u sia yi de-e, yi de ze alɨ kpadjɨ, amba yi pa me: ");
INSERT INTO mdm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Ya ngapulu belegʉ doto na gʉdhʉ gba yi ɨnde adhedhe lɨ ’dhʉ ya, ngʉ́ nasuno pɨ yi me yi amene siti ’ngʉ́. Yi mbɨla la ndjɨndjɨ me, Naʉ gba Ebhe-e akolo de yi masɨkpe.› ");
INSERT INTO mdm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma apa pɨ yi me lɨ ’kpɨ́ lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, okpála na gʉdhʉ ango-o adjé lɨkabhu naali ané okpála na Sodomʉ mane.» ");
INSERT INTO mdm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«ꞌE-e! A ko lɨkabhu pɨ yi okpála na gʉdhʉ na Koladjina! A ko lɨkabhu pɨ yi okpála na gʉdhʉ na Betesaida! Padhá de, anga ɨ dʉ me ongamba ’ngʉ́ ɨnde amene lɨe agba yi-e, ɨ méne lɨe bhʉ́ ogʉdhʉ na Tile ne Sidona-a, okpála na ogʉdhʉ ango-o de adyɨ nanɨ pili didili, u tsia túko ’mbɨ bhʉ́ ’ndjɨ o ngʉ́ napana me u adji bua o adji. ");
INSERT INTO mdm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kaka-a, lɨ ’kpɨ́ lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, lɨkabhu gba yi-e ané bhende gba okpála na Tile ne Sidona mane. ");
INSERT INTO mdm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne yi di, okpála na Kapalanauma-a, yi abhundja naayi me u aꞌéꞌe yi abhʉ́lá-a? A mo-o ade. U abála yi bhʉ́ djua na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Do anɨ matá pɨ omʉkpata gba e me: «Lɨ kpála bini dje yi-e, amba anɨ adje bhomʉ-o ma. Lɨ kpála bini yala nasia yi-e, amba anɨ ayala bhomʉ-o nasia ma. Engʉ́ bini, lɨ kpála bini yala nasia ma-a, amba anɨ ayala bhomʉ-o nasia kpála ɨnde atima ma ko.» ");
INSERT INTO mdm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Omʉkpata ndjɨkpa mananɨka ne ká bhisi-e agie lɨo me u nde abedhe ne djalɨ bedhe. U atsia apa me: «Ngámá, osisiti bua ngamanga belegʉ ya ngao nedhɨnga ya ngaha lɨ́lɨ pɨ uo lɨe ne ’lɨ mʉ ko!» ");
INSERT INTO mdm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu atsia apa pɨ uo me: «Ma au Satana ayie abhʉ́lá akɵ kuto maka mʉgbálá. ");
INSERT INTO mdm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yi djedje nga, ma aha angu pɨ yi ngʉ́ nadele okpʉlʉ ne oapekebhe ne ’dhʉ yi di ne nandjia ndʉ angu gba bhʉlʉ yala gba yi-e hana. Ehe bini tɨ́ da namene yi sisiti de. ");
INSERT INTO mdm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Engʉ́ bini, yi akpí djalɨ ka lɨ osisiti bua ngamanga yi lɨe de. Yi kpi mangbo djalɨ ka lɨ Ebhe aye ’lɨ yi lɨe abhʉ́lá ko.» ");
INSERT INTO mdm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bha lɨ nedhɨnga ango-o makpe-e, Yesu abedhe nanɨ ne djalɨ bedhe ka Bu Bhobua . Anɨ atsia apa me: «Ma agie heni pɨ mʉ, ’Dyɨ ma, Ngámá na abhʉ́lá ne Ngámá na doto. Padhá de, anga engʉ́ ɨnde mo opana e pɨ obhende ɨmbɨlangʉ de-e, mo owo pɨ okpála na ɨmbɨlangʉ di ne obhende amene balʉa má too! A moko, ’Dyɨ ma, anga mo okʉnda bha nanɨ moko. ");
INSERT INTO mdm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Dyɨ ma, mo oha ndʉ ’he hana mʉma. Kpála bini mbɨla de me ngama, Ndɨlɨ-e, ma ne da-ie, bha bini ngamʉ, ’Dyɨ ma. Kpála bini mbɨla la di de me ngamʉ, ’Dyɨ ma-a, mʉ ne da-ie, bha bini ngama, Ndɨlɨ gba mʉ-o, la di ne okpála bhende lɨ ngama, Ndɨlɨ-e, ma akʉnda napana mʉ pɨ o ko.» ");
INSERT INTO mdm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pɨpɨta-a, anɨ adji bhʉ́la e lɨ pápá gba omʉkpata gba e-o, anɨ atsia apa pɨ uo kpi o kpi me: «A ko djalɨ pɨ yi, ngayi okpála ɨ ngau engʉ́ ɨnde yi ngau e ko! ");
INSERT INTO mdm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Padhá de, anga ma apa pɨ yi me opolofeta di ne ongbengbe ongámásɨ bhelé akʉnda nanɨ nau engʉ́ yi ngau e ɨnde, engʉ́ bini u u de. U akʉnda nanɨ nadje engʉ́ yi ngadje e ɨnde, engʉ́ bini u dje de.» ");
INSERT INTO mdm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Abhomʉ-o, mʉsuno bini na lɨ́lɨ gba Moidje ayie bhʉ́lá. Anɨ atsia ayi Yesu ngʉ́ nale anɨ me: «Mʉsuno, a ayo me ma mene pɨ ngʉbula me ma sia mʉkobho na dʉdʉma?» ");
INSERT INTO mdm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu agie pɨ anɨ me: «U aye bhʉ́ lɨ́lɨ gba nɨ́-e pɨ? Mo otatanga lɨe, mʉ djedje bhʉ́bhʉ́ pɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kpála ango-o atsia agie pɨ anɨ me: «‹A ayo me kʉnda Ebhe, Ngámá gba mʉ-o, ne bua mʉ hana, ne mʉkobho gba mʉ-o hana, ne angu gba mʉ-o hana, ne mabhundja gba mʉ-o hana›, amba ‹Mʉ kʉnda la di kilí mʉ, maka mo okʉnda lɨmʉ lɨe makpe ko.› » ");
INSERT INTO mdm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Do Yesu pɨ anɨ me: «Mo ogie ndjɨndjɨ. Mene moko, amba mʉ sia mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Engʉ́ bini, mʉsuno na lɨ́lɨ-e ango-o adʉ akʉnda nasuno me engʉ́ ɨnde nɨ ayi e, a ngbingbili. Abhomʉ-o, anɨ atsia ayi Yesu me: «Kilí ma-a, a ko da?» ");
INSERT INTO mdm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Do Yesu pɨ anɨ me: «Kpála bini ayie nanɨ bhʉ́ Yelusalema, anɨ adʉ akɵ ne abhʉ́ Djeliko. Lɨ kpadjɨ-e, anɨ atɨ bhʉ́ ’kpa obhʉlʉ ’zi ɨnde adʉ agbʉlʉ ’he gba okpála ne kpéke. U abha obongo gba anɨ-o. U abhɨ anɨ má kpú! U abha lɨo-o, u agbida. U atsia aꞌo ka anɨ masɨkpe de nakpi. ");
INSERT INTO mdm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dimandɵ bini adʉ apʉ lɨ kpadjɨ ango-o. Anɨ au kpála ango-o lɨe me-e, anɨ abʉma bha anɨ lɨ pála kpadjɨ koko, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kpála bini na piga gba Levi akolo di lɨ bɨlɨ lɨ kpála ango-o adʉ lɨe-o. Anɨ au anɨ lɨe, anɨ abʉma bha anɨ lɨ pála kpadjɨ koko, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Engʉ́ bini, kpála bini na ndu doto na Samalɨa ɨnde adʉ naae bhʉ́ dhʉkʉ lɨ kpadjɨ bhomʉ-o, akolo de anɨ. Anɨ au anɨ lɨe, anɨ adje ndjinga anɨ naali. ");
INSERT INTO mdm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Anɨ adyudyo lɨe de anɨ masɨkpe. Anɨ aha emʉ di ne vino, anɨ atuko lɨ djila oeka gba anɨ-o, anɨ atsia agbite ne papala bongo. Anɨ aha anɨ, anɨ aꞌo anɨ pɨ́ ’ngbʉ punda gba e-o. Anɨ anʉ ne anɨ bhʉ́ ’tɨ gba ogomago. Oo, anɨ atsia alila anɨ ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lɨ ekpɨ́ aseke lɨe, anɨ agbe lɨ́ falanga bhisi, anɨ aha pɨ bhʉlʉ etɨ-o. Anɨ atsia apa pɨ anɨ me: ‹Lila kpála ɨnde-e ndjɨndjɨ. Ɨ dʉ me mʉ nde apʉ tɨa koko pɨ anɨ pɨ́ bhende-e, ma agíe pɨ mʉ ngama, nedhɨnga ma apʉ́ matá lɨe sɨɨ ko.›» ");
INSERT INTO mdm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu atsia ayi mʉsuno bhomʉ-o me: «Mo obhundja naamʉ pɨ? Bhʉ́ ká okpála bata bhomʉ-o, a ko kpála bhedho adʉ nanɨ kilí kpála ɨnde atɨ bhʉ́ ’kpa obhʉlʉ ’zi bhomʉ-o?» ");
INSERT INTO mdm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mʉsuno na lɨ́lɨ-e agie me: «A ko bhende adje ndjinga anɨ-o.» Yesu atsia apa pɨ anɨ me: «Nʉnʉ, amba mʉ mene bhadi moko.» ");
INSERT INTO mdm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lɨ Yesu ne omʉkpata gba e adʉ lɨe lɨ kpadjɨ-e, anɨ alɨ bhʉ́ kʉtɨ bini. Oo, ɵlɵ bini adʉ ’lɨ anɨ me Malata, anɨ atsia asia Yesu agba e. ");
INSERT INTO mdm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malata adʉ ne ndai e na ɵɵlɵ bini, adʉ ’lɨ anɨ me Malɨa . Malɨa adʉ naae kuto bhʉ́ li ’dhʉ Yesu, anɨ atsia adʉ adje engʉ́ ɨnde lɨ Yesu adʉ apa e ko. ");
INSERT INTO mdm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bua Malata adʉ abhʉ́lá ka bhiti kulu-o. Anɨ ago de Yesu, anɨ atsia apa pɨ anɨ me: «Ngámá, lɨ ndai ma aꞌo ka ma lɨe namene ndʉ kulu hana kpi ma kpi me-e, mʉ bhundja ’ngʉ́ tété bini dɨ? Pa ngala pɨ anɨ me, anɨ go ha mbo ’kpa e mʉma.» ");
INSERT INTO mdm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngámá agie pɨ anɨ me: «Malata, Malata, mʉ ngaꞌo bua mʉ abhʉ́lá, mʉ la di ngatʉtʉ lɨmʉ ngʉbula ongʉ́ bhelé. ");
INSERT INTO mdm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","La-a, a ndjɨndjɨ ne koli ’he bini. Malɨa aha naae ehe ɨnde ane ne bádha, ɨnde lɨ kpála bini dhépe e ka anɨ de.» ");
INSERT INTO mdm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A adʉ ekpɨ́ bini, Yesu adʉ akpokpo ’ngʉ́ ne Ebhe lɨ bɨlɨ bini. Anɨ andjia lɨe, sʉka omʉkpata gba anɨ-e atsia apa pɨ anɨ me: «Ngámá, suno nakpokpo ’ngʉ́ ne Ebhe pɨ ya, maka lɨ Djaa asuno di lɨe pɨ omʉkpata gba e ko.» ");
INSERT INTO mdm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu atsia apa pɨ uo me: «Yi dʉ akpokpo ’ngʉ́ ne Ebhe-e, yi de pa me: ‹’Dyɨ ya, a ayo me, okpála mbɨla me, mʉ ne Ebhe na bubu; a ayo me, mʉ go ʉ Ngámá pɨ́la doto. ");
INSERT INTO mdm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ha ezʉ gba ya na ekpɨ́ bini ne bini-e pɨ ya. ");
INSERT INTO mdm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mbu lɨ osisiti ’ngʉ́ gba ya ko. A moko, ngaya makpe, ya ngambu di lɨ osisiti ’ngʉ́ lɨ okpála amene e lɨ pabɨlɨ gba ya ko. Mo oꞌó de me nale ha angu ya-a de.›» ");
INSERT INTO mdm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu atsia apa matá pɨ uo me: «Ɨ dʉ me sʉka yi bini nde ne kilí e, anɨ nʉ bhaka anɨ agba e tutu sukpe ngʉ́ napa pɨ anɨ me: ‹Wai, ha mbo mapa mʉma bata. ");
INSERT INTO mdm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kilí ma bini ɨnde bhʉ́ dholo ago lɨ ma oo, ehe la ka ma ngʉ́ nahaha pɨ anɨ ade.› ");
INSERT INTO mdm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɨ dʉ me bhende abhʉ́ ’tɨ-e nde agie pɨ anɨ me: ‹Mo ondála ma de! Ma ani bhotɨ-e ani. Ngaya ne ongɨsɨ gba ma-a, ya asɨlɨ kuto asɨlɨ. Ma tɨ da nayie bhʉ́lá ngʉ́ naha mapa pɨ mʉ de.› ");
INSERT INTO mdm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma apa pɨ yi na paká me, abana anɨ yie bhʉ́lá ngʉ́ nahaha pɨ anɨ kabula mʉkʉnda gba o-o de-e, engʉ́ bini, anɨ ayíe bhʉ́lá ngʉ́ naha ndʉ ’he hana ɨnde anɨ nde ne gʉmʉ e pɨ anɨ ka anɨ ngandala anɨ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ngama-a, ma atsia apa pɨ yi me, yi yo ’he ɨnde yi nde ne gʉmʉ e-o, amba Ebhe ha pɨ yi. Yi gɨlɨ ’he ɨnde yi nde ne gʉmʉ e-o, amba yi u. Yi bhɨ bhotɨ-o, amba Ebhe ꞌʉ pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Padhá de, anga ndʉ okpála hana ɨnde ngayo ’he anɨ nde ne gʉmʉ e, anɨ ngasisia. Kpála bhende ngagɨlɨ ’he ɨnde anɨ nde ne gʉmʉ e, anɨ ngauu. Ebhe ngaꞌʉ bhotɨ pɨ kpála bhende ngabhɨbhɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bhʉ́ ká yi odyɨ ongɨsɨ-e, a tɨ da naha kpʉlʉ pɨ ndɨlɨ gba e da, ɨ dʉ me ndɨlɨ-e nde ayo ka anɨ sungu-o? ");
INSERT INTO mdm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ɨ dʉ me anɨ nde ayo ka anɨ pala ’ngʉ-o, anɨ tsia há pɨ anɨ apekebhe-e? ");
INSERT INTO mdm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Belegʉ ngayi okpála na sisiti-e, yi ngaha babadha ’he pɨ ongɨsɨ gba yi-o. A ane la mane ne bádha pɨ ’Dyɨ yi ɨnde abhʉ́lá-a me anɨ ha Bu Bhobua pɨ obhende ngayoyo ka anɨ ko!» ");
INSERT INTO mdm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu adʉ agbe siti bua ɨnde adʉ ani ’bhɵ kpála bhʉ́ bhoko bini. Lɨ siti bua ango-o akoto lɨe, kpála ango-o aholo agama ’ngʉ́. Abhomʉ-o, bhiti okpála ɨnde adʉ oo angamba naali. ");
INSERT INTO mdm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Okpála koko bhʉ́ ká uo atsia apa me: «Ngámá gba osisiti bua ɨnde ’lɨ e me Beledjebula ngaha angu pɨ anɨ ngae, ngʉ́ napandja osisiti bua ne di!» ");
INSERT INTO mdm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Okoko adʉ agɨlɨ nale anɨ. Abhomʉ-o, u atsia apa pɨ anɨ me, anɨ mene ngamba ’ngʉ́ ngʉ́ napana me, angu gba anɨ-e ngayie abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Engʉ́ bini, Yesu ambɨla mabhundja gba uo-o lɨe, anɨ atsia apa pɨ uo me: «Ɨ dʉ me okpála gba ngámá bini nde ngagʉ gbele sʉnda o, naʉ ango-o lʉ́-ʉ de. Lɨ ndʉ etɨ hana túko. ");
INSERT INTO mdm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ɨ dʉ me omaha Satana nde ngagʉ gbele sʉnda o-o, naʉ gba anɨ-e tɨ da nalʉ lele pɨ? Padhá de, anga yi ngapa me, ma ngapandja osisiti bua ne angu gba Beledjebula. ");
INSERT INTO mdm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ɨ dʉ me ma nde ngapandja osisiti bua ne angu gba Beledjebula-a, okpála gba yi-e ngapandja uo ne angu gba da? Kaka-a, okpála gba yi-e akódho ’ngʉ́ gba yi-e ngao! ");
INSERT INTO mdm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","La-a, ɨ dʉ me ma nde ngapandja osisiti bua ne angu gba Ebhe na paká-a, apa bhomʉ-o me, Naʉ gba Ebhe-e akolo lɨ yi akolo. ");
INSERT INTO mdm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Lɨ kpála bini na angu ɨnde lɨ tɨa ’gʉ́ nde ka e ndjɨndjɨ, dʉ alila etɨ gba e-e, ehe bini dʉ́la tɨa gba anɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Engʉ́ la bini, ɨ dʉ me kpála bini ɨnde ane anɨ ne angu-o go, anɨ há egʉ́ pɨ anɨ, anɨ tsia há angu anɨ. Anɨ bhá ndʉ tɨa ’gʉ́ ɨnde anɨ adʉ aꞌo bua e lɨe hana. Anɨ tsia gápa ndʉ ’he ɨnde anɨ abha e ka anɨ-e hana. ");
INSERT INTO mdm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kpála bhende pɨ ma ade-e, a ko yala ma. Kpála bhende ɨ ha ’kpa e mʉma ngʉ́ napo bhʉ́la okpála de-e, anɨ ngatsambala uo matsambala.» ");
INSERT INTO mdm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Lɨ siti bua koto bhʉ́ kpála bini-e, anɨ nʉ́ ne djakadha abhʉ́ omili bɨlɨ ngʉ́ nagɨlɨ bɨlɨ naguo ka e tété. Ɨ dʉ me anɨ nde u de-e, anɨ pá lɨ bua e me: ‹Ma agíe lɨma bhʉ́ ’tɨ gba ma ɨnde ma akoto nako bhʉ́ e-o.› ");
INSERT INTO mdm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Anɨ gie lɨe oo, anɨ bháka me u apo bhʉ́ ’tɨ-o, u aleke ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Abhomʉ-o, anɨ nʉ́, anɨ bhá osisiti bua koko mananɨka ɨnde ane anɨ ne siti. U gíe lɨo bhʉ́ dabɨlɨ bini, u lɨ́ bhʉ́ ’tɨ-o, u tsia dʉ́lʉ. Pɨpɨta-a, mʉkobho gba kpála ango-o, kólo la matá sisiti naali ane bhende na kalanʉ-o mane.» ");
INSERT INTO mdm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nedhɨnga anɨ adʉ apa ’ngʉ́ bhomʉ-o lɨe, ɵlɵ bini atsia asʉla pɨ anɨ bhʉ́ ká okpála me: «A ko djalɨ pɨ ɵlɵ ɨnde azu mʉ-o, ɨnde di mo ondjɨ ’ka e-o!» ");
INSERT INTO mdm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Engʉ́ bini, Yesu agie me: «A ko djalɨ mangbo pɨ okpála ɨnde ngadje eli gba Ebhe di ne nalilila ko!» ");
INSERT INTO mdm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lɨ bhiti okpála ago apo bhʉ́la o lɨe de Yesu-o, anɨ atsia aholo apa me: «Okpála na nakɨ ɨnde-e sisiti. U ngayo ngamba ’ngʉ́. Engʉ́ bini, Ebhe méne ngamba ’ngʉ́ bini pɨ uo de, bha bini bhende gba polofeta Djonasɨ. ");
INSERT INTO mdm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Padhá de, anga maka lɨ Ebhe aha nanɨ Djonasɨ lɨe ngʉ́ napana ngamba ’ngʉ́ pɨ okpála na Ninive-e, Ebhe ahá bhadi ma, Ndɨlɨ gba kpála-a, ngʉ́ napana ngamba ’ngʉ́ pɨ okpála na nakɨ moko. ");
INSERT INTO mdm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ngámá na ɵɵlɵ ɨnde adʉ atsia ’kpɨ́ lɨ ndu doto na Saba ayie nanɨ tsutsu ngʉ́ nago nadje oeli na ɨmbɨlangʉ gba ’ngbé ngámá Salomo. Lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, ngámá na ɵɵlɵ ango-o alʉ́ kala okpála na nakɨ, anɨ tsia aꞌó ’ngʉ́ pɨ́ uo. Kaka-a, kpála bini sɨ, anɨ ane Salomo mane! ");
INSERT INTO mdm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Okpála na Ninive adji nanɨ bua o lɨ nedhɨnga u adje ngali gba Ebhe ɨnde lɨ Djonasɨ adʉ akpokpo e lɨe-o. Lɨ Ebhe akódho ’ngʉ́ gba okpála lɨe, okpála na Ninive alʉ́ kala okpála na nakɨ, u tsia aꞌó ’ngʉ́ pɨ́ uo. Kaka-a, kpála bini sɨ, anɨ ane Djonasɨ mane!» ");
INSERT INTO mdm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ɨ dʉ me kpála bini nde adhedhe eke-e, anɨ tó asa lʉsa de. Engʉ́ bini, anɨ ꞌó pɨ́ ’he amba okpála ɨnde ngalɨ bhʉ́ ’tɨ-e, u u ’kpɨ́ tété ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Djila mʉ ne zɨ ’kpɨ́ na kʉte mʉ. Lɨ djila mʉ dʉ ndjɨndjɨ-e, ndʉ kʉte mʉ hana dʉ́ bhʉ́ zɨ ’kpɨ́. Engʉ́ bini, lɨ djila mʉ dʉ sisiti-e, ndʉ kʉte mʉ hana dʉ́ bhʉ́ biti. ");
INSERT INTO mdm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tsia ndjɨndjɨ me zɨ ’kpɨ́ ɨnde bhʉ́ mʉ-o, adʉ́ biti de. ");
INSERT INTO mdm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ɨ dʉ me ndʉ kʉte mʉ hana nde lɨ zɨ ’kpɨ́-e, yá mʉ bini nde bhʉ́ biti ade-e, kʉte mʉ libhomu dʉ́ lɨ zɨ ’kpɨ́, maka lɨ zɨ ’ke ngaziga mʉ lɨe má ngɨlɨlɨ ko!» ");
INSERT INTO mdm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lɨ Yesu andjia nagama ’ngʉ́ lɨe, mʉFalisai bini atsia aꞌɨ anɨ agba e ngʉ́ nazʉ ’he. Anɨ alɨ abhʉ́ ’tɨ gba mʉFalisai-o, anɨ atsia aholo nazʉ ’he-o. ");
INSERT INTO mdm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","MʉFalisai ango-o angamba naali, anga anɨ au me Yesu vʉlʉ lɨe kala nazʉ ’he-e de. ");
INSERT INTO mdm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Abhomʉ-o, Ngámá Yesu apa pɨ anɨ me: «Ngayi omʉFalisai-e, yi ngavʉlʉ kʉte pápá di ne kʉte saanɨ. Engʉ́ la bini, ngayi-e, yi abedhe ne ’ngbé bua di ne siti bua bhʉ́ yi bedhe. ");
INSERT INTO mdm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɨmbɨlangʉ bhʉ́ yi ade! Ebhe ɨnde abho kʉte-e, anɨ bho di bua ngae dɨ? ");
INSERT INTO mdm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaka-a, yi ha mangbo pɨ obhʉlʉ ndɨbhɨlɨ ehe bhende bhʉ́ opápá di ne bhʉ́ osaanɨ gba yi ko. Yi mene mo-o, lɨ ndʉ ’he hana kólo pɨ yi babadha. ");
INSERT INTO mdm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","La-a, a ko lɨkabhu pɨ yi, omʉFalisai! Padhá de, anga yi ngaha bini bhʉ́ ká ndjɨkpa na oulu na sese ne ndʉ djedje ulu na abhʉ́ ’dyɨ-e hana pɨ Ebhe. La-a, yi mene engʉ́ na ngbingbili pɨ okpála de. Yi kʉnda la di Ebhe de. A la bhomʉ-o engʉ́ ɨnde ayo me yi mene ngaɨza e me, yi nde ꞌɨlɨ ’to yi lɨ naha bini bhʉ́ ká ndjɨkpa na oehe gba yi-e pɨ Ebhe de ko. ");
INSERT INTO mdm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","A ko lɨkabhu pɨ yi, omʉFalisai! Padhá de, anga yi kʉnda bha nadʉlʉ pɨ́ dabɨlɨ na akalanʉ bhʉ́ otɨ nadje lɨ́lɨ gba Moidje . Yi kʉnda la di me okpála dʉ ne yiyi yi maka ongámásɨ lɨ ohi-kpadjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","A ko lɨkabhu pɨ yi! Padhá de, anga yi maka olata ɨnde u ꞌo ’he pɨ́ e ngʉ́ nasusuno de, lɨ okpála ngadhʉkʉ pɨ́ e me u nde mbɨla de!» ");
INSERT INTO mdm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sʉka omʉsuno na lɨ́lɨ-e apa pɨ anɨ me: «Mʉsuno, mo opa lɨe mo-o, mo osobho di bhomʉ-o ya.» ");
INSERT INTO mdm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu atsia agie me: «A ko di lɨkabhu pɨ yi, omʉsuno na lɨ́lɨ! Padhá de, anga yi ngamene mʉgɨto me yi ngaꞌo titili ’he lɨ ’ngbʉ okpála. Engʉ́ la bini, ngayi makpe-e, yi ꞌo belegʉ lɨkpa yi bini tété ngʉ́ nateteke uo de. ");
INSERT INTO mdm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A ko lɨkabhu pɨ yi! Padhá de, anga yi ngaleke olata opolofeta, ɨnde lɨ ogbi yi abhili nanɨ o-o! ");
INSERT INTO mdm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yi ngapana bhomʉ-o me, yi azɨba engʉ́ ɨnde lɨ ogbi yi amene nanɨ e ko. Padhá de, anga ngauo-o, u abhili opolofeta, ngayi-e, yi la ngaleke olata uo! ");
INSERT INTO mdm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kaka-a, Ebhe ne ɨmbɨlangʉ gba e, apa lɨ ’ngʉ́ gba yi-e me: ‹Ma atíma opolofeta di ne obhʉlʉ titima pɨ uo. U abhíli okoko bhʉ́ ká uo, u tsia méne okoko sisiti.› ");
INSERT INTO mdm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nayie maka lɨ Ebhe abho nanɨ doto lɨe, okpála atuko ngʉte opolofeta bhelé. Kaka-a, okpála na nakɨ abɨ́ mangɨmbo ango-o ngao. ");
INSERT INTO mdm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kalanʉ-o, u abhɵlɵ Abele. Alɨ soso-o, u abhɵlɵ Djakalɨa bhʉ́ mbadhasʉ na ’ngbé ’tɨ Ebhe gba omaYuda, sʉnda bɨlɨ natsulu enʉ pɨ Ebhe ne tɨtɨna na bubu-o. Ma apa pɨ yi na paká me, okpála na nakɨ abɨ́ mangɨmbo na ngʉte okpála bhomʉ-o hana ngao! ");
INSERT INTO mdm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","A ko lɨkabhu pɨ yi, omʉsuno na lɨ́lɨ! Padhá de, anga yi ani bhotɨ na ɨmbɨlangʉ-o. La ngayi makpe-e, yi lɨ de. Yi atsia ani la di bhotɨ ango-o pɨ obhende akʉnda nalɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lɨ Yesu ayie lɨe lɨ bɨlɨ bhomʉ-o, omʉsuno na lɨ́lɨ ne omʉFalisai aholo napadha anɨ. U atsia aholo ayiyi anɨ lɨ ongʉ́ bhelé bhelé. ");
INSERT INTO mdm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Padhá de, anga u adʉ agɨlɨ nagbo anɨ lɨ ’li e. ");
INSERT INTO mdm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nedhɨnga bhomʉ-o, bhiti okpála apo bhʉ́la o de Yesu. U adʉ bhibhiti naali, kaka-a, u adʉ adedele ’dhʉ obɨ o. Abhomʉ-o, Yesu atsia aholo napa ngaɨza pɨ omʉkpata gba e me: «ꞌE-e! Yi lila lɨyi ka levile gba omʉFalisai-e uu! Padhá de, anga u ngalɨ bhʉ́ ndʉ ongʉ́ hana ne kali gba o-o maka lɨ levile ngalɨ bhʉ́ mapa lɨe hana ko. ");
INSERT INTO mdm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ndʉ ’ngʉ́ ɨnde awo lɨe mawo-o hana, akóto bhʉ́ mbasʉ. Ndʉ ’ngʉ́ ɨnde na pepe hana, ndʉ okpála hana ambɨ́la. ");
INSERT INTO mdm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kaka-a, ndʉ ’ngʉ́ ɨnde yi apá e sukpe-e hana, okpála adjé ne ngbɨkpɨ. Ndʉ ’ngʉ́ ɨnde yi apá e bhʉ́ tʉpele abhʉ́ ’tɨ-e hana, okpála asʉ́sʉla ne di bhʉ́ mbasʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ma apa pɨ yi, ngayi ondaise ma me: yi akpé okpála bhende ngabhɵlɵ kʉte-e de, ɨnde pɨpɨta-a, ɨ tɨ da matá namene ’he bini de ko. ");
INSERT INTO mdm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma asúno pɨ yi kpála ɨnde a ayo me yi kpe e ko. Yi kpe Ebhe ɨnde ka e ne angu ngʉ́ nabhili okpála. Pɨpɨta-a, anɨ tɨ da nabu uo bhʉ́ djua na dʉdʉma. A moko, ma apa pɨ yi me: yi kpe mangbo anɨ! ");
INSERT INTO mdm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","U tsɨtsɨndjɨ odjedje odhu bhuluvue ngʉbula senge bhisi dɨ? La-a, Ebhe ꞌɨlɨ ’to e lɨ sʉka uo bini de. ");
INSERT INTO mdm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ebhe mbɨla belegʉ alo na sundjo yi-e hana. Yi adjé tsʉlʉ de, bhʉ́ djila Ebhe-e, yi ane bhiti odjedje ’dhu bhomʉ-o mane!» ");
INSERT INTO mdm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ma apa pɨ yi me: kpála ɨnde apá lɨ ma bhʉ́ ká djila okpála me nɨ ne naama kpála-a, ngama, Ndɨlɨ gba kpála-a, ma apá bhadi lɨ anɨ bhʉ́ ká djila oandjelu gba Ebhe-e me, a ko naama kpála. ");
INSERT INTO mdm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Engʉ́ bini, kpála ɨnde apá lɨ ma bhʉ́ ká djila okpála me nɨ mbɨla ma de-e, ngama, Ndɨlɨ gba kpála, ma apá bhadi lɨ anɨ bhʉ́ ká djila oandjelu gba Ebhe-e me, ma ambɨla anɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɨ dʉ me kpála bini nde apa siti ’ngʉ́ lɨ kʉte ma, Ndɨlɨ gba kpála-a, lɨ Ebhe mbú lɨ anɨ. Ɨ dʉ la me kpála bini nde asobho Bu Bhobua-a , Ebhe mbú lɨ anɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nedhɨnga u anʉ́ lɨe ne yi bhʉ́ otɨ nadje lɨ́lɨ gba Moidje , di ne kala ongámásɨ ɨnde ngatsia ’kpɨ́ lɨ doto me u kodho ’ngʉ́ gba yi-e, yi adjé tsʉlʉ de me yi akóbho lɨ mangua kpadjɨ dho-ie de, di ne me yi apá pɨ-ie de. ");
INSERT INTO mdm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Padhá de, anga lɨ nedhɨnga bhomʉ-o, Bu Bhobua asúno pɨ yi ngae engʉ́ ɨnde a ayo me yi pa e-o.» ");
INSERT INTO mdm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Abhomʉ-o, kpála bini bhʉ́ ká okpála apa pɨ Yesu me: «Mʉsuno, pa pɨ ndai ma me anɨ ha naama tɨa na lɨbhondɨ ’dyɨ ya-a mʉma haha.» ");
INSERT INTO mdm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu agie pɨ anɨ me: «Wai, aꞌo ma kpála nakodho ’ngʉ́ di ne nagbogbo bhʉsʉ otɨa gba yi-e da?» ");
INSERT INTO mdm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Anɨ atsia apa pɨ ndʉ uo hana me: «ꞌE-e! Yi lila lɨyi ka gʉmʉ tɨa na doto uu, anga belegʉ lɨ tɨa dʉ bha ka kpála bhelé-e, mʉkobho gba anɨ-e dʉ́ bhʉ́bhʉ́ de.» ");
INSERT INTO mdm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Abhomʉ-o, anɨ atsia akpokpo gbitaku ɨnde-e pɨ uo me: «Kpála bini na tɨa adʉ nanɨ ne odyɨ bhelé ɨnde aha nguwa pɨ anɨ naali. ");
INSERT INTO mdm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Anɨ adʉ ayi lɨ bua e me: ‹Ma améne sɨ pɨ? Dabɨlɨ ka ma ngʉ́ nalila nguwa gba ma-a tété hana ade.› ");
INSERT INTO mdm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pɨpɨta-a, anɨ me: ‹Ma ambɨla engʉ́ ɨnde ma améne e ambɨla! Ma apándjala ongbokopi gba ma-o, ma ayíki ɨbili obhe na ngbengbengbe. Ma bú nguwa ne otɨa gba ma-a hana bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Abhomʉ-o, ma tsia pá lɨ bua ma me, tɨa ka ma bhelé ngʉbula bhiti kalanga. Ma guo ngala mbo guguo. Ma zʉ babadha ’zʉ, ma ndjɨ pandɨ, amba ma kpi djalɨ.› ");
INSERT INTO mdm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Engʉ́ bini, Ebhe pɨ anɨ me: ‹Mʉ ne ngingi! Sukpe na nakɨ-e, mʉ ngakpi. Ndʉ ’he ɨnde mo opo bhʉ́la e hana-a atígala pɨ da?›» ");
INSERT INTO mdm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu apa matá me: «A bhadi moko pɨ kpála ɨnde ngapo bhʉ́la tɨa pɨ e makpe, me anɨ nde gɨlɨ nadʉ bhʉlʉ tɨa lɨ pápá gba Ebhe de ko.» ");
INSERT INTO mdm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pɨpɨta-a, Yesu atsia apa pɨ omʉkpata gba e me: «Kaka-a, ma apa pɨ yi me: yi akína lɨyi ngʉbula ezʉ ɨnde yi nde ne gʉmʉ e ngʉ́ mʉkobho gba yi-e de. Yi akína di lɨyi ngʉbula obongo ɨnde yi nde ne gʉmʉ e ngʉ́ kʉte yi-e de. ");
INSERT INTO mdm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Padhá de, anga mʉkobho gba yi-e ane ezʉ. La di-e, kʉte yi ane bongo. ");
INSERT INTO mdm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yi tsia nga odhu, u lulu ’dyɨ de. U popo bhʉ́la nguwa de. Dabɨlɨ ngʉ́ naleke ’zʉ ka uo tété ade. Ngbokopi ka uo ade. La-a, Ebhe ngakʉ uo! Mʉkobho gba yi-e, ane bhe gba odhu-o tsutsu naali! ");
INSERT INTO mdm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A ko da bhʉ́ ká yi-e, ɨnde ka nakina lɨe, ɨ tɨ da nadyudyo ekpɨ́ na mʉkobho gba e nga bha mbo ne ekpɨ́ bini-e? ");
INSERT INTO mdm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ɨ dʉ me yi nde tɨ da namene belegʉ de mboye ehe bhomʉ-o, yi la ngakina lɨyi ngʉ́ ongʉ́ koko ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yi tsia nga ofelele abhiye. U memene kulu de. U dʉdʉ bongo de. Ma apa la pɨ yi me, belegʉ ’ngbé ngámá Salomo bhʉ́ ndʉ ká tɨa gba e hana-a, anɨ sia bongo bini ane ne bádha maka sʉsʉka de. ");
INSERT INTO mdm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɨ dʉ me Ebhe nde ngadyɨ bongo lɨ ulu ɨnde nakɨ abhiye, mambi u tsia bhíke e bhʉ́ djua-a, anɨ tɨ da nadyɨ bongo lɨ yi ane mane dɨ? Ngayi okpála ɨnde lɨ nabhuka gba yi-e nde yeye! ");
INSERT INTO mdm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kaka-a, yi aꞌó bua yi abhʉ́lá ngʉ́ nagɨlɨ ezʉ ɨnde yi azʉ́ e, ne ehe bhende yi andjɨ́ e de. ");
INSERT INTO mdm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Omʉpagano, okpála na doto ɨnde-e, u ngagɨlɨ ehe bhomʉ-o ndʉ ’kpɨ́ hana ngao. Engʉ́ bini, ’Dyɨ yi Ebhe mbɨla hana me yi ne gʉgʉmʉ. ");
INSERT INTO mdm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yi gɨlɨ nga mangbo namene ongʉ́ ɨnde lɨ Naʉ gba Ebhe-e akʉnda e ko. Yi mene mo-o, lɨ Ebhe tsia há di ndʉ ’he koko pɨ yi hana pépé.» ");
INSERT INTO mdm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Ngayi okpála gba ma, ɨnde bhelé ade-e, yi adjé tsʉlʉ de. Padhá de, anga ’Dyɨ yi Ebhe au ndjɨndjɨ me yi dʉ ongámásɨ bhʉ́ Naʉ gba anɨ-e, maka ngaanɨ ’Dyɨ yi, nɨ nde lɨe ne Ngámá ko. ");
INSERT INTO mdm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yi tsɨndjɨ ohe gba yi-o, amba yi ha tɨatɨa, yi ha pɨ obhʉlʉ ndɨbhɨlɨ. Yi bho pɨ yi otɨ bongo ɨnde ɨ kádha de. Yi wo tɨa gba yi-e abhʉ́lá, lɨ bɨlɨ ɨ síti lɨe de. Obhʉlʉ ’zi tɨ da nakolo tété de. Okɵkɵ́ tɨ la di da nazʉzʉ de. ");
INSERT INTO mdm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Padhá de, anga bɨlɨ ɨnde lɨ tɨa gba yi-e nde lɨe, bua yi bhadi oo ko.» ");
INSERT INTO mdm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Yi dʉ bedhe ngʉbula kulu maka kpála ɨnde adyɨ bongo na kulu, anɨ atsia adhedhe eke gba e madhedhe. ");
INSERT INTO mdm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yi dʉ bedhe maka okpála ɨnde ɨ ngadjeke ngámá gba o me, anɨ nde atapa bhʉ́ anokomɨa na kʉva. U ngadjeke me u ꞌʉ bhotɨ-e pɨ anɨ má gala, lɨ nedhɨnga ɨnde anɨ agó nabhɨbhɨ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A ko djalɨ pɨ okpála na kulu ɨnde lɨ ngámá gba o akólo lɨe, anɨ bháka me u nde la de ko! Ma apa pɨ yi na paká me, anɨ dyɨ́ bongo na kulu gba e-o, anɨ ꞌɨ́ uo ngʉbula nazʉ ’he. Anɨ tsia há ezʉ-o pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A ko djalɨ pɨ uo, ɨ dʉ me anɨ nde abhaka me u nde la de ko, belegʉ anɨ go tutu sukpe, belegʉ anɨ go bhʉ́ sɨkɨkpɨ! ");
INSERT INTO mdm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yi mbɨla ndjɨndjɨ me, ɨ dʉ́ me bhʉlʉ etɨ mbɨ́la nedhɨnga ɨnde lɨ bhʉlʉ ’zi agó lɨe mambɨla-a, anɨ de ꞌó de me anɨ lɨ abhʉ́ ’tɨ gba nɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ngayi di-e, yi dʉ bedhe. Padhá de, anga yi mbɨla nedhɨnga lɨ ngama, Ndɨlɨ gba kpála-a, ma agó lɨe de.» ");
INSERT INTO mdm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Abhomʉ-o, Piele atsia ayi anɨ me: «Ngámá, mo opa gbitaku ɨnde-e bha bini pɨ ya kpi ya kpi? Ne me, mo opa pɨ ndʉ okpála hana.» ");
INSERT INTO mdm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngámá agie pɨ anɨ me: «Kpála na kulu na ngbingbili ne ɨmbɨlangʉ-o, a ko bhedho? A ko kpála bhende lɨ ngámá gba e aꞌo e ngʉ́ nalila etɨ gba e-o, di ne nagapa ezʉ pɨ okpála koko na kulu, ɨ dʉ me nedhɨnga ango-o nde akolo-o. ");
INSERT INTO mdm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A ko djalɨ pɨ kpála na kulu ango-o, ɨ dʉ me ngámá gba anɨ-e nde agie lɨe agba e, anɨ tsia bhaka me anɨ nde ngamene kulu gba e ko! ");
INSERT INTO mdm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ma apa pɨ yi na paká me, ngámá bhomʉ-o ꞌó anɨ pɨ́ ’ndjɨ ndʉ ’he gba e hana. ");
INSERT INTO mdm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Engʉ́ bini, ɨ dʉ me kpála na kulu ango-o nde apa lɨ bua e me: ‹Ha-a! Ngámá gba ma-a gó má gala de.› Anɨ hólo nabhɨ obɨ e na obhosɨbhosɨ di ne obhe na olɨsɨlɨsɨ-o. Anɨ hólo nazʉ ’he, nandjɨ pandɨ ne nalangba ne di. ");
INSERT INTO mdm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ngámá gba anɨ-e gíe lɨe lɨ ekpɨ́ anɨ djeke anɨ lɨe de, lɨ nedhɨnga ɨnde anɨ mbɨla e de. Ngámá gba anɨ-e ꞌé anɨ bhʉ́ kulu, anɨ tsia ꞌó anɨ bhʉ́ ká okpála na sisiti. ");
INSERT INTO mdm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ɨ dʉ me kpála na kulu nde ambɨla engʉ́ lɨ ngámá gba e akʉnda e, engʉ́ bini anɨ tsia leke lɨe ngʉ́ namemene maka lɨ ngámá ango-o akʉnda lɨe de-e, kaka-a, u bhɨ́ anɨ naali. ");
INSERT INTO mdm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","La-a, ɨ dʉ me kpála na kulu nde mbɨla ’ngʉ́ lɨ ngámá gba e ngakʉnda e de-e, anɨ mene engʉ́ ɨnde a ayo me u bhɨ anɨ ka e, u bhɨ́ anɨ naali de. Padhá de, anga kpála bhende u aha ’he pɨ e bhelé-e, u ayó bhadi ’he ka anɨ bhelé. Kpála bhende u aꞌo ’he sa ’kpa e bhelé-e, u ayó matá ehe ka anɨ pépé ane mane.» ");
INSERT INTO mdm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Ma ago ngʉ́ nabhike djua pɨ́la doto. Ma akʉnda me adʉ atsi matsi! ");
INSERT INTO mdm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A ayo me ma sia batisimo na lɨkabhu. La-a, lɨkabhu lɨ bua ma naali akólo lɨ ’kpɨ́ ɨnde ma asía lɨe ko! ");
INSERT INTO mdm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yi abhundja naayi me ma ago ngʉ́ naꞌo guo ’ngʉ́ pɨ́la doto? Ma apa pɨ yi me, a mo-o ade. Ma ago mangbo ngʉ́ nagbogbo bhʉsʉ okpála. ");
INSERT INTO mdm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nayie pɨ mbɨa ɨnde-e, piga bini na okpála bhuluvue agbó bhʉsʉ e, bata ayála bhisi, lɨ bhisi yála bata. ");
INSERT INTO mdm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","’Dyɨ ndɨlɨ ayála ndɨlɨ na bhobhoko gba e-o, lɨ ndɨlɨ-e yála ’dyɨ e. ’Hi ndɨlɨ ayála ndɨlɨ na ɵɵlɵ gba e-o, lɨ ndɨlɨ-e yála ’hi e. Ogbi na ɵɵlɵ ayála ɵlɵ gba ndala e, lɨ ɵlɵ gba ndɨlɨ-e yála ogbi e. » ");
INSERT INTO mdm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu apa matá pɨ okpála me: «Yi u me ebha ngago ne kati, yi kolo pá me: ‹Ebha ɨnde-e adhɨ́ madhɨ.› Ɨ tsia méne la bhadi lɨe moko. ");
INSERT INTO mdm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yi dje anvi me a nde ngayie lɨ pápá na yoyoko, yi pá me: ‹Ekpɨ́-e akpá naali.› Ɨ tsia méne la bhadi lɨe moko. ");
INSERT INTO mdm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngayi obhʉlʉ kali ɨnde-e! Yi mbɨla engʉ́ ɨnde ngakodho ’kpɨ́ abhʉ́lá ne bhende pɨ́la doto-o hana. La ka nɨ, yi kʉnda nambɨla engʉ́ ɨnde ngakodho ’kpɨ́ lɨ nedhɨnga ɨnde-e lɨe de-e?» ");
INSERT INTO mdm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ka nɨ, ngayi makpe, yi mbɨla nakodho ’ngʉ́ na ngbingbili ɨnde ayo namene e lɨe de-e? ");
INSERT INTO mdm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɨ dʉ me yi nde bhʉ́ ’ngʉ́ ne kilí mʉ-o, anɨ dʉ anʉ́ ne mʉ bhʉ́ djila okpála nakodho ’ngʉ́-o, mʉ de mene ne kpéke me yi dje lɨyi ne anɨ lɨ kpadjɨ. Mʉ ngakpe bhomʉ-o me, anɨ anʉ́ ne mʉ pɨ kpála nakodho ’ngʉ́-o de. Lɨ kpála nakodho ’ngʉ́-o há mʉ pɨ osʉdha de. Lɨ osʉdha-a tsia bhíke mʉ bhʉ́ tɨkpʉ de. ");
INSERT INTO mdm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma apa pɨ mʉ me, mʉ kóto bha oo me, mʉ nde agie ndʉ bopulu gba mʉ-o hana má kpɵkɵbhɵ!» ");
INSERT INTO mdm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Abhomʉ-o lɨ nedhɨnga ango-o, okpála koko ago akpokpo pɨ Yesu me: «Pɨlatɵ abhili okpála koko na Galilaya me u nde ngatsulu enʉ pɨ Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Anɨ agie pɨ uo me: «Yi abhundja naayi me, ɨ dʉ me Pɨlatɵ nde abhili uo mo-o, a akʉnda napa me u adʉ sisiti ane ndʉ okpála koko na Galilaya hana? ");
INSERT INTO mdm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma apa pɨ yi me, a mo-o ade. Engʉ́ bini, ɨ dʉ me yi nde dji bua yi de-e, ndʉ yi hana, yi amú bhadi maka uo. ");
INSERT INTO mdm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yi bhundja okpála ndjɨkpa ne ká madjɨna nanɨ lɨ ’ndjá ’tɨ na Silʉe abhili o-o. Yi abhundja naayi me u adʉ nanɨ sisiti ane ndʉ okpála koko na Yelusalema hana? ");
INSERT INTO mdm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma apa pɨ yi me, a mo-o ade. Engʉ́ bini, ɨ dʉ me yi nde dji bua yi de-e, ndʉ yi hana, yi amú bhadi maka uo.» ");
INSERT INTO mdm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pɨpɨta-a, Yesu atsia apa gbitaku ɨnde-e pɨ uo me: «Kpála bini alu nanɨ ndula na figi bhʉ́ edyɨ gba e na vino. Ekpɨ́ bini, anɨ ago nagɨlɨ lɨ́lɨ́ bhʉ́bhʉ́. La-a, anɨ u belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Abhomʉ-o, anɨ atsia apa pɨ kpála na kulu gba e me: ‹Tsitsia nga, a ko mbɨa ɨnde-e kalanga bata, ma ngago agɨlɨ lɨ́lɨ́ bhʉ́ ndula ɨnde. La-a, ma u belegʉ de bini. Dede! A ngangɨ bɨlɨ padhá ka nɨ?› ");
INSERT INTO mdm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Engʉ́ bini, kpála na kulu-o agie pɨ anɨ me: ‹Ngámá, ꞌo nga matá ndula ango-o lɨ kalanga ɨnde, amba ma djɨ doto bhʉ́ lili ngbalina, ma tuko doto na eká bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Koko bhʉ́ kalanga na sidi-e, ɨ lɨ́ lɨ́lɨ́. Ɨ dʉ la me a nde lɨ lɨ́lɨ́ de-e, mʉ tsia dé.›» ");
INSERT INTO mdm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lɨ ’kpɨ́ bini naguo gba omaYuda-a , Yesu adʉ asuno bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-o . ");
INSERT INTO mdm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A abhaka me ɵlɵ bini na kuo nde oo. Sʉnda kalanga ndjɨkpa ne ká madjɨna, siti bua adʉ bhʉ́ anɨ. Siti bua ango-o atsia adʉ anu ’ngbʉ anɨ. Kaka-a, anɨ ale nanɨ nalɨ lɨe pima. ");
INSERT INTO mdm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lɨ Yesu au ɵlɵ ango-o lɨe, anɨ aꞌɨ anɨ. Anɨ atsia apa pɨ anɨ me: «’Hi ma, kuo gba mʉ-o ayie.» ");
INSERT INTO mdm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Anɨ abu ’kpa e pɨ́ anɨ, kolo má gala me-e, anɨ alɨ lɨe má ngbʉʉ! Anɨ atsia aholo nadhɵgɵ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Engʉ́ bini, ngámá na etɨ nadje lɨ́lɨ-e ake ’ngʉ́ lɨe naali, ka lɨ Yesu akobho kpála lɨe bhʉ́ ’kpɨ́ naguo-o. Do anɨ pɨ okpála ɨnde adʉ oo me: «A ne ’kpɨ́ madhɨa ngʉ́ namene kulu. Yi go lɨ okpɨ́ bhomʉ-o, ngʉbula me u kobho yi ne okuo gba yi ko. Engʉ́ bini, yi agó bhʉ́ ’kpɨ́ naguo de!» ");
INSERT INTO mdm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Abhomʉ-o, Ngámá Yesu atsia agie pɨ anɨ me: «Yi ne obhʉlʉ kali! Lɨ ’kpɨ́ naguo-o, yi bhubhulu bagala di ne punda gba yi-e bhʉ́ ’tɨ o, ngʉ́ nanʉ ne uo me u ndjɨ ’ngu dɨ? ");
INSERT INTO mdm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ɵlɵ ɨnde-e, anɨ bhʉ́ piga gba Abalahama. Satana agbite anɨ kalanga ndjɨkpa ne ká madjɨna. A ayo de me u bhulu anɨ lɨ ’kpɨ́ naguo dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Lɨ Yesu agie pɨ uo lɨe mo-o, ndʉ obhʉlʉ yala gba anɨ-e hana atsia asia nʉmʉ. Engʉ́ bini, ndʉ okpála hana adʉ akpi djalɨ ka ndʉ obabadha kulu hana ɨnde anɨ adʉ amene e ko. ");
INSERT INTO mdm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Abhomʉ-o, Yesu atsia apa me: «Naʉ gba Ebhe-e , a maka nɨ? Ma tɨ da napapana lɨ nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A maka lɨ́ ndula na mʉtadi. Kpála bini aha, anɨ alu bhʉ́ ’dyɨ gba e-o. A akɵ, a akolo ’ngbé ndula. Odhu atsia ayiki ’tɨ o bhʉ́ oyáyá ko.» ");
INSERT INTO mdm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Do Yesu matá me: «Ma tɨ da napana Naʉ gba Ebhe-e lɨ nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A maka levile ɨnde lɨ ɵlɵ bini aha e. Anɨ atsia akpɵdhɵlɵ ne bhiti faline akólo lɨ nedhɨnga lɨ faline hana afúka lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu aholo ’nʉ́ bhʉ́ Yelusalema. Lɨ anɨ adʉ anʉ lɨe oo, anɨ adʉ apʉ bhʉ́ ogʉdhʉ ne bhʉ́ okʉtɨ me anɨ nde ngasuno Bádha Ngali pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kpála bini ayi anɨ me: «Ngámá, Ebhe akóbho bha okpála masudha?» Abhomʉ-o, Yesu atsia agie pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Yi mene ne kpéke me yi lɨ lɨ bhotɨ na yeye-o. Padhá de, anga ma apa pɨ yi me, okpála bhelé agɨ́lɨ me nɨ lɨ, engʉ́ la bini u alé pima. ");
INSERT INTO mdm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A maka me lɨ nedhɨnga lɨ bhʉlʉ ’tɨ-e ayíe bhʉ́lá lɨe, anɨ ní bhotɨ-o. Pɨpɨta-a, yi dʉ́lʉ akilidjo. Yi hólo nabhɨ bhotɨ-e me yi nde ngapa me: ‹Ngámá, ꞌʉ bhotɨ-e pɨ ya.› Anɨ tsia gíe pɨ yi me: ‹Ma mbɨla bɨlɨ lɨ yi ayie lɨe de!› ");
INSERT INTO mdm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Abhomʉ-o, yi tsia pá pɨ anɨ me: ‹Nɨ́ azʉ nanɨ ’he, nɨ́ andjɨ di pandɨ ne yi bhʉ́ dabɨlɨ bini. Mo otsia asuno lɨ okpadjɨ gba ya-o.› ");
INSERT INTO mdm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Anɨ tsia gíe pɨ yi me: ‹Ma mbɨla bɨlɨ lɨ yi ayie lɨe de. Ngayi osisiti okpála, yi yie de ma oo ko!› ");
INSERT INTO mdm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nedhɨnga yi aú Abalahama, Ɨsaka, Yakobho di ne ndʉ opolofeta hana lɨe bhʉ́ Naʉ gba Ebhe-e, lɨ Ebhe tsia bála la naae yi akilidjo! Oo, yi adʉ́ aku ’gbá di ne nazʉ tate yi. ");
INSERT INTO mdm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Okpála ayíe ne ’dje doto badha hana, u tsia gó bhʉ́ anokomɨa bhʉ́ Naʉ gba Ebhe ko. ");
INSERT INTO mdm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Abhomʉ-o, okpála koko ɨnde asidi mbɨa ɨnde-e, u akólo akalanʉ. Lɨ obhe koko ɨnde akalanʉ mbɨa ɨnde-e, u tsia kólo asidi.» ");
INSERT INTO mdm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lɨ nedhɨnga ango-o, omʉFalisai koko ago apa pɨ Yesu me: «Yie sɨ mayie, anga ngámá Elode ngakʉnda nabhɵlɵ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu atsia agie pɨ uo me: «Yi nʉ pa pɨ bhʉlʉ kali maka nekpɵ bhomʉ-o me: ‹Ma ngapandja osisiti bua bhʉ́ okpála. Ma di ngakobho okpála na kuo nakɨ di ne mambi. Ma tsia ndjía kulu gba ma-a bhʉ́ ’kpɨ́ na bata.› ");
INSERT INTO mdm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Engʉ́ bini, a ayo me ma kpata kpadjɨ gba ma-a, nakɨ, mambi di ne ekpɨ́ na bata. Padhá de, anga a ayo de me, okpála bhɵlɵ polofeta lɨ bɨlɨ koko de, bha bini abhʉ́ Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aa! Ngayi, okpála na Yelusalema-a, yi ngabhili opolofeta! Yi la di ngabhili ne teme okpála ɨnde lɨ Ebhe atima o agba yi-o! A ko bhʉtsibhʉtsi madho ma akʉnda napo bhʉ́la yi maka lɨ ’hi ’ngʉ apopo bhʉ́la ongɨsɨ gba e lɨe sa mbudha e-o. La-a, yi tsia kʉnda de! ");
INSERT INTO mdm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mbɨa ɨnde-e, kʉtɨ gba yi-e atígala padhá. Ma apa pɨ yi me, yi ú matá ma belegʉ de bini akólo lɨ nedhɨnga ɨnde yi apá lɨe me: ‹A ayo me Ebhe tuko bisagu pɨ́ kpála ɨnde ngago ne ’lɨ anɨ ko!›» ");
INSERT INTO mdm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A akolo ekpɨ́ bini, ekpɨ́ naguo gba omaYuda-a , Yesu anʉ nazʉ ’he agba sʉka ongámásɨ gba omʉFalisai-o . Okpála ɨnde adʉ oo adʉ atsia Yesu ne kpéke djila. ");
INSERT INTO mdm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Abhomʉ-o, kpála bini ɨnde lɨ kʉte e asisika ne engu adʉ kala anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ayi omʉsuno na lɨ́lɨ gba Moidje ne omʉFalisai-e me: «Lɨ́lɨ gba nɨ́ azɨba nakobho kpála lɨ ’kpɨ́ naguo? Ne me a zɨba de.» ");
INSERT INTO mdm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Engʉ́ bini, u andjili bha má bulu! Abhomʉ-o, Yesu aha ’kpa bhʉlʉ kuo-o, anɨ akobho anɨ. Anɨ atsia apa pɨ anɨ me anɨ gie lɨe agba e. ");
INSERT INTO mdm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pɨpɨta-a, anɨ pɨ uo me: «Belegʉ lɨ ’kpɨ́ naguo-o, lɨ sʉka ongɨsɨ gba yi na bhosɨbhosɨ-e, ɨ dʉ di-e sʉka bagala gba yi-e tɨ bhʉ́ ’dú ’ngu-o, yi kolo gbé anɨ má gala! A mo-o adɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","U mbɨla engʉ́ bini ɨnde u agíe e tété-e de. ");
INSERT INTO mdm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu au me okpála ɨnde u aꞌɨ o-o ngadʉlʉ pɨ́ odabɨlɨ na akalanʉ. Abhomʉ-o, anɨ atsia apa gbitaku ɨnde-e pɨ ndʉ uo hana me: ");
INSERT INTO mdm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Lɨ kpála bini ꞌɨ mʉ bhʉ́ anokomɨa na kʉva-a, mo onʉ́ adʉ pɨ́ dabɨlɨ na akalanʉ de. Padhá de, anga mʉ mbɨla de me, u aꞌɨ kpála koko ɨnde ane mʉ mane e-e de. ");
INSERT INTO mdm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ɨ dʉ mo-o, lɨ kpála ɨnde aꞌɨ ndʉ yi bhisi hana gó pa pɨ mʉ me: ‹ꞌO ka dabɨlɨ bhomʉ-o pɨ anɨ.› Abhomʉ-o, mʉ nʉ́ ne nʉmʉ hana, mʉ tsia dʉ́ asidi. ");
INSERT INTO mdm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Engʉ́ bini, lɨ kpála bini ꞌɨ mʉ bhʉ́ anokomɨa-a, mʉ de nʉ dʉ pɨ́ dabɨlɨ na asidi, amba lɨ kpála ɨnde aꞌɨ mʉ agó lɨe, anɨ de pa pɨ mʉ me: ‹Ndai ma, dyudyo lɨmʉ ne akalanʉ.› Lɨ ndʉ okpála bhende yi ngazʉ ’he ne o-o hana, tsia ú mʉ me, mʉ ne ’ngbé kpála. ");
INSERT INTO mdm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Padhá de, anga ɨ dʉ me kpála nde ngaꞌo lɨe ne abhʉ́lá-a, lɨ Ebhe kɵ́ anɨ ne kuto. Ɨ dʉ la me kpála nde ngaꞌo lɨe ne kuto-o, lɨ Ebhe ꞌéꞌe anɨ ne abhʉ́lá.» ");
INSERT INTO mdm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pɨpɨta-a, Yesu apa pɨ kpála ɨnde aꞌɨ anɨ-e me: «Lɨ mʉ ꞌɨ okpála ngʉ́ nazʉ ’he tulukpe, ɨ dʉ di-e tagolo-o, mo oꞌɨ́ obɨ mʉ de. Mo oꞌɨ́ ondaise mʉ de. Mo oꞌɨ́ okpála na piga gba mʉ-o de. Mo oꞌɨ́ la di okpála na tɨa ɨnde asɨlɨ kʉtɨ lɨngo mʉ-o de. Padhá de, anga ngauo-o, u ꞌɨ́ di mʉ lɨ ’kpɨ́ koko, u tsia gíe ehe ɨnde mo omene e pɨ uo-o pɨ mʉ. ");
INSERT INTO mdm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Engʉ́ bini, lɨ mʉ ꞌɨ okpála bhʉ́ anokomɨa-a, ꞌɨ obhʉlʉ ndɨbhɨlɨ. ꞌƗ okpála na eze. ꞌƗ obhende ne eze lɨ ’dhʉ o-o di ne obhende ɨ u ’kpɨ́ de ko. ");
INSERT INTO mdm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mʉ mene mo-o, mʉ dʉ́ ne djalɨ, anga u tɨ da nagie ’he bini pɨ mʉ de. Ebhe agíe pɨ mʉ lɨ ’kpɨ́ lɨ okpála na ngbingbili-e azúku lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","U adje ’ngʉ́ bhomʉ-o lɨe, sʉka okpála ɨnde adʉ azʉ ’he bhʉ́ dabɨlɨ bini ne Yesu-o atsia apa pɨ anɨ me: «A ko djalɨ pɨ kpála ɨnde azʉ́ anokomɨa bhʉ́ Naʉ gba Ebhe-o !» ");
INSERT INTO mdm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Do Yesu pɨ anɨ me: «Kpála bini amene ’ngbé anokomɨa. Anɨ atsia aꞌɨ okpála bhelé ngánga. ");
INSERT INTO mdm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A akolo lɨe lɨ nedhɨnga nazʉ ’he-e, anɨ atsia atima kpála na kulu gba e ngʉ́ napa pɨ okpála ɨnde anɨ aꞌɨ o-o me: ‹Ezʉ-o abhʉ, yi gógo.› ");
INSERT INTO mdm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kpála ne kpála aholo ayo ka anɨ me anɨ mbu lɨ nɨ. Bhe na kalanʉ-o apa pɨ anɨ me: ‹Ma akala edyɨ, a ayo me ma nʉ natsitsia. Ma ayo ka mʉ me mbu lɨ ma.› ");
INSERT INTO mdm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Koko apa pɨ anɨ me: ‹Ma akala obagala ndjɨkpa ngʉbula kulu na edyɨ. Ma adji nale uo. Ma ayo ka mʉ me mbu lɨ ma.› ");
INSERT INTO mdm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Koko atsia apa matá me: ‹Ma aha ɵlɵ mbɨa ɨnde. Kaka-a, ma tɨ dá nanʉ-ʉ de.› ");
INSERT INTO mdm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kpála na kulu-o agie lɨe agba ngámá gba e-o. Anɨ atsia akpokpo ’ngʉ́ bhomʉ-o pɨ anɨ. Abhomʉ-o, ngámá-a aholo ake ’ngʉ́ lɨe. Anɨ atsia apa pɨ kpála na kulu gba e me: ‹Nʉ má gala bhʉ́ odaposo, di ne lɨ okpadjɨ. ꞌƗ obhʉlʉ ndɨbhɨlɨ. ꞌƗ okpála na eze. ꞌƗ obhende ɨ u ’kpɨ́ de, di ne obhende ne eze lɨ ’dhʉ o-o.› ");
INSERT INTO mdm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pɨta nedhɨnga masudha-a, kpála na kulu ago, anɨ atsia apa me: ‹Ngámá, ma amene lɨ́lɨ gba mʉ-o amene. Engʉ́ bini, dabɨlɨ nga bha uu.› ");
INSERT INTO mdm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Abhomʉ-o, ngámá atsia apa pɨ kpála na kulu gba e me: ‹Nʉ lɨ okpadjɨ ’dyɨ, lɨngo oaga na edyɨ, mba okpála ne kpéke, amba etɨ gba ma-a bedhe bedhe. ");
INSERT INTO mdm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Padhá de, anga ma apa pɨ yi me, okpála ɨnde ma aꞌɨ o kalanʉ-o, sʉka uo bini zʉ́ anokomɨa gba ma-a de!›» ");
INSERT INTO mdm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ekpɨ́ koko-o, lɨ okpála bhelé adʉ adhʉkʉ lɨe bhʉ́ dabɨlɨ bini ne Yesu-o, anɨ adji bhʉ́la e lɨ pápá gba uo-o, anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Kpála ɨnde akʉnda akpata ma-a, a ayo me anɨ yala ’dyɨ e ne ’hi e. Anɨ yala wala e ne ongɨsɨ gba e-o. Anɨ yala ondaise e na obhosɨbhosɨ, di ne obhende na olɨsɨlɨsɨ, amba anɨ yala belegʉ mʉkobho gba e makpe ko. Ɨ dʉ mo-o de-e, anɨ tɨ́ da nadʉ mʉkpata gba ma-a de. ");
INSERT INTO mdm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kpála ɨnde ɨ kʉnda nabɨ kulusi gba e de-e, ɨnde ɨ kpata ma de-e, anɨ tɨ́ da nadʉ mʉkpata gba ma-a de. ");
INSERT INTO mdm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ɨ dʉ me sʉka yi nde akʉnda nayiki ’ngbé ’tɨ-e, anɨ dʉ́ ngaɨza kuto. Anɨ tsia hólo nabhundja ngʉ́ nambɨla me tɨa ka nɨ bhelé ngʉ́ nandjia kulu ango-o. ");
INSERT INTO mdm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ɨ dʉ mo-o de-e, anɨ ꞌo ’dhʉ ’tɨ-e, pɨpɨta anɨ tsia ndjia etɨ-e de-e, ndʉ okpála hana ɨnde aú-o, u hólo namʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","U tsia dʉ́ apa me: ‹Yi tsia nga kpála ɨnde, anɨ akpo nako lita nayiki etɨ. Engʉ́ bini, anɨ ndjia de!› ");
INSERT INTO mdm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A bhadi moko, ɨ dʉ me ’ngbé ngámá bini nde akʉnda nagʉ ’gʉ́ ne ’ngbé ngámá koko, anɨ dʉ́ ngaɨza kuto. Anɨ holo nabhundja ngʉ́ nambɨla me, ne okpála kutu ndjɨkpa-a, nɨ tɨ da nagʉ ’gʉ́ ne ’ngbé ngámá ɨnde ka e ne okpála kutu ndjɨkpa bhisi-o. ");
INSERT INTO mdm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ɨ dʉ mo-o de-e, anɨ tíma obhʉlʉ titima pɨ ’ngbé ngámá ango-o nedhɨnga anɨ nde nga bha lɨe tsutsu-o. Anɨ tsia yí anɨ me: ‹A ayo namene pɨ ngʉbula me egʉ́ adʉ́-ʉ de-e?›» ");
INSERT INTO mdm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Abhomʉ-o, Yesu atsia apa matá me: «Sʉka yi bini tɨ da nadʉ mʉkpata gba ma-a de, ɨ dʉ me anɨ nde ꞌo ka ndʉ ’he gba e hana de ko.» ");
INSERT INTO mdm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ngʉtʉ ne bádha ’he. Engʉ́ bini, ɨ dʉ me kpokpo nde andjia bhʉ́bhʉ́ andjia, u tɨ́ da nagie matá kpokpo bhʉ́bhʉ́ ne nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A belegʉ ndjɨndjɨ ade ngʉ́ doto di ne ngʉ́ nalu ’zʉ. U bála bha ɨbili akilidjo. Kpála ɨnde ne ’dje ’dje ngʉ́ nadje ’kpɨ́-e, anɨ djedje!» ");
INSERT INTO mdm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ekpɨ́ bini, ondɵmbɨ na mandjandja di ne okpála na sisiti ago ndʉ o hana de Yesu ngʉ́ nadje anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","OmʉFalisai ne omʉsuno na lɨ́lɨ gba Moidje adʉ adi anɨ. U adʉ apa me: «Kpála ɨnde-e ngasia okpála na sisiti. Anɨ la di ngazʉ ’he ne uo bhʉ́ dabɨlɨ bini!» ");
INSERT INTO mdm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Abhomʉ-o, Yesu atsia apa gbitaku ɨnde-e pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Kpála bini bhʉ́ ká yi ne okandɵlɵ kámá bini. Lɨ sʉka uo bini ngɨta-a, anɨ mene pɨ? A na paká me, anɨ ꞌó ká obhende ndjɨkpa odukpabini ne ká odukpabini-e lɨ bɨlɨ nazʉ ’he ka o-o. Anɨ tsia nʉ́ nagɨlɨ bhende angɨta-a, akólo lɨ nedhɨnga ɨnde anɨ aú anɨ lɨe-e ko. ");
INSERT INTO mdm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lɨ anɨ au anɨ lɨe, anɨ bédhe ne djalɨ bedhe. Anɨ há kandɵlɵ-o, anɨ ꞌó anɨ pɨ́ de-ngʉlʉ e. ");
INSERT INTO mdm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Anɨ gíe lɨe agba e. Pɨpɨta-a, anɨ ꞌɨ́ obɨ e ne okpála ɨnde asɨlɨ kʉtɨ de anɨ-o. Anɨ tsia pá pɨ uo me: ‹Yi kpi djalɨ bhʉ́ dabɨlɨ bini ne ma, anga ma au kandɵlɵ gba ma ɨnde angɨta nako au!›» ");
INSERT INTO mdm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu atsia apa matá me: «Djalɨ adʉ́ bhadi moko abhʉ́lá ngʉbula kpála bini na sisiti ɨnde adji bua e. Djalɨ ango-o ané bhende u nde ne e ngʉbula okpála na ngbingbili ndjɨkpa odukpabini ne ká odukpabini, ɨnde ngabhundja me o ne gʉmʉ nadji bua o ade ko.» ");
INSERT INTO mdm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Matá di-e, ɨ dʉ me ɵlɵ bini nde ne lɨ́ falanga ndjɨkpa, lɨ sʉsʉka bini ngɨta-a, anɨ méne pɨ? A na paká me, anɨ dhédhe eke. Anɨ pó bɨlɨ abhʉ́ ’tɨ. Anɨ gɨ́lɨ má bhotobhoto, akólo lɨ nedhɨnga ɨnde anɨ aú lɨe-e ko! ");
INSERT INTO mdm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Lɨ anɨ au lɨe, anɨ ꞌɨ́ obɨ e di ne okpála ɨnde asɨlɨ kʉtɨ de anɨ-o. Anɨ tsia pá pɨ uo me: ‹Yi kpi djalɨ bhʉ́ dabɨlɨ bini ne ma, anga ma au lɨ́ falanga ɨnde angɨta nako ka ma-a au!›» ");
INSERT INTO mdm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu atsia apa matá me: «Oandjelu gba Ebhe-e akpí bhadi djalɨ moko ngʉbula koli kpála na sisiti bini ɨnde adji bua e ko.» ");
INSERT INTO mdm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu atsia apa matá me: «Bhoko bini adʉ nanɨ ne ongɨsɨ na obhosɨbhosɨ bhisi. ");
INSERT INTO mdm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bhende na ndimindimi-e apa pɨ ’dyɨ e me: ‹’Dyɨ ma, ha naama tɨa na lɨbhondɨ-e mʉma haha.› Abhomʉ-o, ’dyɨ uo atsia agapa tɨa gba e lɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pɨta ’kpɨ́ bedɨ, ndɨlɨ na ndimindimi-e abha tɨa gba e, anɨ atapa ne di bhʉ́ kʉtɨ bini tsutsu. Oo, anɨ andjia tɨa gba e hana má kpɵkɵbhɵ lɨ ndʉ ’ngʉ́ na padhá padhá! ");
INSERT INTO mdm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lɨ anɨ andjia tɨa gba e lɨe hana-a, adyɨndɨ na ngbéngbé atsia alɨ bhʉ́ ndu doto ango-o. Abhomʉ-o, anɨ aholo adje gʉmʉ. ");
INSERT INTO mdm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anɨ anʉ alɨ bhʉ́ kulu pɨ sʉka kpála na ndu doto bhomʉ-o. Kpála ango-o aha anɨ, anɨ atsia atima anɨ abhʉ́ ’dyɨ gba e me anɨ dʉ nalila opame. ");
INSERT INTO mdm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Anɨ adʉ akʉnda nazʉ ezʉ gba opame-o. La-a, kpála bini ha nanɨ ehe nazʉ mazʉ pɨ anɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Abhomʉ-o, anɨ aholo abhundja. Pɨpɨta-a, anɨ atsia apa lɨ bua e me: ‹Ndʉ okpála na kulu gba ’dyɨ ma-a hana, ezʉ ka uo bhibhiti naali. Ngama la ei-e, ma ngakpi ne gʉmʉ! ");
INSERT INTO mdm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma agíe lɨma agba ’dyɨ ma, ma tsia pá pɨ anɨ me: ’Dyɨ ma, ma amene siti ’ngʉ́ kala Ebhe di ne lɨ pápá gba mʉ. ");
INSERT INTO mdm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A ayo matá naꞌɨ ma me ndɨlɨ ka mʉ de. Ha bha ɨbili ma maka sʉka okpála na kulu gba mʉ ko.› ");
INSERT INTO mdm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Anɨ atsia aholo agie lɨe agba ’dyɨ e. Lɨ nedhɨnga ɨnde anɨ adʉ nga bha lɨe de kʉtɨ-e tsutsu-o, ’dyɨ anɨ au anɨ. Anɨ au anɨ lɨe, anɨ adje ndjinga anɨ naali. Anɨ anʉ ne holo, anɨ atɨ lɨ ngʉlʉ anɨ, anɨ atsia akama anɨ lɨ kʉte e. ");
INSERT INTO mdm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Abhomʉ-o, ndɨlɨ-e atsia apa pɨ anɨ me: ‹’Dyɨ ma, ma amene siti ’ngʉ́ kala Ebhe di ne lɨ pápá gba mʉ. A ayo matá naꞌɨ ma me ndɨlɨ ka mʉ de.› ");
INSERT INTO mdm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","U akolo lɨe akʉtɨ-e, do ’dyɨ anɨ pɨ okpála na kulu gba e me: ‹Yaka! Yi go ne yambu bhende ane ne bádha, yi dyɨ lɨ anɨ. Yi to kati bhʉ́ ’kpa anɨ, amba yi to malɵkɵ bhʉ́ ’dhʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pɨpɨta-a, yi nʉ bhɵlɵ folo bagala na tsɨkpa-o. Nɨ́ zʉ ’he, amba nɨ́ kpi djalɨ. ");
INSERT INTO mdm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Padhá de, anga ndɨlɨ gba ma ɨnde adʉ nako mʉgɨto me anɨ akpi-e, anɨ agie matá lɨe bhʉ́ mʉkobho. Anɨ adʉ nako me anɨ nde angɨta, ma atsia au matá anɨ.› Abhomʉ-o, u atsia aholo nakpi djalɨ. ");
INSERT INTO mdm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lɨ nedhɨnga bhomʉ-o, ndɨlɨ bhende na gigina adʉ abhiye. Nedhɨnga anɨ adʉ agie lɨe lɨe akʉtɨ-e, anɨ akolo lɨe de etɨ-e masɨkpe-e, anɨ adje tolo ’tsi ne ebɨ. ");
INSERT INTO mdm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Anɨ aꞌɨ sʉka okpála na kulu-o. Anɨ atsia ayi anɨ lɨ engʉ́ ɨnde adʉ akodho ’kpɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kpála na kulu ango-o agie pɨ anɨ me: ‹Ndai mʉ agie lɨe agie. ’Dyɨ mʉ atsia abhɵlɵ folo bagala na tsɨkpa-o, anga anɨ au me, anɨ agie lɨe ne kʉte na angu.› ");
INSERT INTO mdm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Abhomʉ-o, ndɨlɨ na gigina-a aholo nake ’ngʉ́ lɨe. Anɨ ayala nalɨ abhʉ́ ’tɨ-o. ’Dyɨ anɨ akoto, anɨ atsia alopolo lɨe pɨ anɨ me anɨ lɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Engʉ́ bini, ndɨlɨ-e agie pɨ ’dyɨ e me: ‹Djedje nga, a ko kalanga bhelé ma ngamene kulu pɨ mʉ maka bali. Ma ndjo sʉka lɨ́lɨ gba mʉ-o ’kpɨ́ bini de. Mʉ ha nga la belegʉ ndɨlɨ meeme mʉma bini de me, ya mene anokomɨa ne obɨ ma-a ne di. ");
INSERT INTO mdm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lɨ ndɨlɨ gba mʉ ɨnde andjia tɨa gba mʉ-o hana ne olɨsɨ na zabhe-e ago lɨe, mo otsia abhɵlɵ folo bagala na tsɨkpa-a pɨ anɨ!› ");
INSERT INTO mdm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Dyɨ anɨ atsia apa pɨ anɨ me: ‹Ndɨka ma, ndʉ ’kpɨ́ hana, nɨ́ ne mʉ bhʉ́ dabɨlɨ bini. Ndʉ ’he ɨnde gba ma-a hana, a ko naamʉ. ");
INSERT INTO mdm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Engʉ́ bini, a ayo bha ɨgɨnɨ me nɨ́ mene anokomɨa amba nɨ́ kpi djalɨ. Padhá de, anga ndai mʉ ɨnde adʉ nako mʉgɨto me anɨ akpi-e, anɨ agie matá lɨe bhʉ́ mʉkobho. Anɨ adʉ nako me anɨ nde angɨta, ma atsia au matá anɨ!›» ");
INSERT INTO mdm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pɨpɨta-a, Yesu atsia apa matá pɨ omʉkpata gba e me: «Bhʉlʉ tɨa bini adʉ ne kpála na kulu gba e. Kpála ango-o adʉ atsia ’kpɨ́ lɨ ohe gba anɨ-o. Okpála koko ago apa pɨ anɨ me, kpála na kulu ango-o ngapʉpʉ tɨa gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Abhomʉ-o, anɨ aꞌɨ kpála na kulu-o. Anɨ atsia apa pɨ anɨ me: ‹Ma ngadje pɨndjɨ mʉ e mangua ’ngʉ́ dho? Suno obhuku na ndʉ tɨa gba ma-a hana mʉma, anga mʉ tɨ́ da matá natsia ’kpɨ́ lɨ ohe gba ma-a de.› ");
INSERT INTO mdm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Abhomʉ-o, kpála na kulu ango-o aholo ayi bua e me: ‹Ma améne sɨ pɨ? Padhá de, anga ngámá gba ma adji aꞌé ma bhʉ́ kulu. Angu ka ma ngʉ́ nade edyɨ ade. A la di lɨ ma ne nʉmʉ ngʉ́ nadʉ ne yoyo ’he. ");
INSERT INTO mdm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa! Ma ambɨla engʉ́ ɨnde ma améne e ambɨla, ngʉbula me okpála sia ma ndjɨndjɨ lɨ nedhɨnga u aꞌé ma lɨe bhʉ́ kulu ko!› ");
INSERT INTO mdm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Abhomʉ-o, anɨ aꞌɨ okpála bini ne bini ɨnde adʉ ne bopulu gba ngámá gba anɨ-o. Anɨ ayi bhende na kalanʉ-o me: ‹Bopulu gba ngámá gba ma-a ka mʉ madho?› ");
INSERT INTO mdm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Anɨ agie pɨ anɨ me: ‹Ngbɵngɵlɵ na emʉ kámá bini.› Kpála na kulu-o pɨ anɨ me: ‹Ha ’kpa balʉa na bopulu gba mʉ-o. Dʉ kuto má gala, amba mʉ dji me ndjɨkpa bhuluvue.› ");
INSERT INTO mdm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pɨpɨta-a, anɨ ayi koko me: ‹A la mʉ-o, bopulu gba mʉ-o madho?› Anɨ agie me: ‹Kíli mapʉnga kámá bini.› Kpála na kulu-o pɨ anɨ me: ‹Ha ’kpa balʉa na bopulu gba mʉ-o, amba mʉ dji me ndjɨkpa madjɨna.› ");
INSERT INTO mdm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ngámá gba kpála na kulu na kali ango-o adhɵgɵ anɨ, anga anɨ amene ehe maka kpála ɨnde ngau ’kpɨ́ tsutsu. Okpála na doto ɨnde-e ne ɨmbɨlangʉ na kali gba o-o, u ambɨla namene ehe sʉnda o ane ongɨsɨ gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ngama-a, ma apa pɨ yi me, yi gɨlɨ nadʉ bhʉ́ makpolɨa ne obɨ yi ne tɨa na kali na doto ɨnde, amba lɨ tɨa neke ka yi-e, u de sia yi bhʉ́ kʉtɨ na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kpála bhende ngbingbili bhʉ́ ohe na djedjedje-e, anɨ bhadi ngbingbili bhʉ́ ohe na ngbengbengbe. Kpála bhende ngbingbili bhʉ́ ohe na djedjedje-e ade, anɨ di ngbingbili bhʉ́ ohe na ngbengbengbe ade. ");
INSERT INTO mdm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ɨ dʉ me yi nde mene ndjɨndjɨ ne tɨa na kali na doto ɨnde-e de-e, Ebhe tɨ́ da naha kʉkʉlʉ tɨa pɨ yi de. ");
INSERT INTO mdm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ɨ dʉ me yi nde mene ehe ngbingbili ne tɨa gba kpála koko de-e, a há tɨa gba yi-e pɨ yi da? ");
INSERT INTO mdm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kpála bini tɨ da namene kulu pɨ ongámásɨ bhisi de. Anɨ yála bini, anɨ tsia kʉ́nda koko. Anɨ méne kulu pɨ koko ndjɨndjɨ, anɨ tsia ú koko bhʉ́ djila e padhá. Yi tɨ da namene kulu pɨ Ebhe bhʉ́ dabɨlɨ bini ne namene pɨ tɨa de.» ");
INSERT INTO mdm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","OmʉFalisai adje ndʉ ’ngʉ́ bhomʉ-o hana. Abhomʉ-o, u atsia adʉ amʉ Yesu, anga u adʉ nanɨ akʉnda tɨa naali. ");
INSERT INTO mdm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu atsia apa pɨ uo me: «Yi ngamene ehe bhʉ́ djila okpála mʉgɨto me yi ngbingbili. Engʉ́ bini, Ebhe mbɨla bua yi hana, anga ehe lɨ okpála ngau e bhʉ́ djila o ngbéngbé-e, Ebhe ngauu bhʉ́ djila e padhá. ");
INSERT INTO mdm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nakolo lɨ nedhɨnga gba Djaa bhʉlʉ nabatisa okpála-a, u akpokpo ’li Ebhe pɨ okpála bhʉ́ lɨ́lɨ gba Moidje di ne bhʉ́ obhuku gba opolofeta . Nayie lɨ nedhɨnga bhomʉ-o, u akpokpo Bádha NgaliNaʉ gba Ebhe-e pɨ okpála. Kpála ne kpála ngagɨlɨ ne kpéke me nɨ lɨ bhʉ́ kʉtɨ na mʉndeyi-o . ");
INSERT INTO mdm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A ko mboye ’ngʉ́ masudha me ekpɨ́ di ne doto kodho ’kpɨ́. A ko la kpéke da ’ngʉ́ me okpála ꞌe mboye kʉ eli bini bhʉ́ ká lɨ́lɨ gba Moidje-o. ");
INSERT INTO mdm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Lɨ bhoko bini ꞌe wala e bhʉ́ kʉva-a, anɨ ha ɵlɵ koko-o, anɨ akʉnda bhomʉ-o ɵlɵ gba kpála koko. Lɨ bhoko bini ha ɵlɵ ɨnde lɨ ’ko e aꞌe e bhʉ́ kʉva-a, anɨ akʉnda di bhomʉ-o ɵlɵ gba kpála koko.» ");
INSERT INTO mdm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«A adʉ nanɨ bhʉlʉ tɨa bini. Anɨ adʉ adyɨ babadha bongo na tɨa naali. Ndʉ ’kpɨ́ hana, anɨ adʉ nadʉ ndjɨndjɨ. Anɨ atsia adʉ di nazʉ ’he ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bhʉlʉ ndɨbhɨlɨ bini adʉ di nanɨ oo. A adʉ ’lɨ anɨ me Ladjalo. Eka atsotsolo nanɨ kʉte anɨ hana. Anɨ adʉ asɨ kuto lɨ bhotɨ gba bhʉlʉ tɨa-o. ");
INSERT INTO mdm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Anɨ adʉ akʉnda nazʉ okʉlʉ ’zʉ ɨnde adʉ abala sa dabɨlɨ nazʉ ’he gba bhʉlʉ tɨa-o. La di-e, obʉlʉ adʉ ago adhapa oeka gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bhʉlʉ ndɨbhɨlɨ-e akpi. Oandjelu aha anɨ, u atsia anʉ aꞌo anɨ ade Abalahama. Bhʉlʉ tɨa akpi di, u atsia azɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Oo, lɨ bɨlɨ gba okpála ɨnde amu-o, anɨ adʉ adje lɨkabhu naali. Anɨ atsia ’kpɨ́ ne abhʉ́lá, anɨ au Abalahama tsutsu ne Ladjalo de e. ");
INSERT INTO mdm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Abhomʉ-o, anɨ aholo natobhɨla me: ‹’Dyɨ ma Abalahama, dje nga bha mbo ndjinga ma! Tima Ladjalo me anɨ to ndjɨ-lɨkpa e bhʉ́ ’ngu, amba anɨ go ne di tʉnʉ pɨ́ ’mi ma, anga ma ngadje lɨkabhu bhʉ́ djua ɨnde-e naali.› ");
INSERT INTO mdm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abalahama agie pɨ anɨ me: ‹Ndɨka ma, bhundja me mo osia nanɨ tɨa bhelé lɨ nedhɨnga mo odʉ lɨe bhʉ́ mʉkobho pɨ́la doto-o. La-a, Ladjalo atsia asia nanɨ naae lɨkabhu naali. Mbɨa ɨnde-e, anɨ ngasia bádha ’ngʉ́, mʉ la naamʉ ngasia lɨkabhu. ");
INSERT INTO mdm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Matá-a, a sʉnda nɨ́ ne tsú ’dú, ngʉbula me lɨ kpála kʉnda nayie gba ya ei akodho ’kpɨ́ ne agba yi oo, anɨ de le pima! Lɨ kpála kʉnda nayie gba yi oo akodho ’kpɨ́ ne agba ya ei-e, anɨ de le di pima!› ");
INSERT INTO mdm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Do bhʉlʉ tɨa me: ‹’Dyɨ ma, kikiliako, ma ayo nga bha-a ka mʉ me, tima Ladjalo agba ’dyɨ ma, ");
INSERT INTO mdm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","anga ondaise ma na obhosɨbhosɨ bhuluvue oo. A ayo me, anɨ nʉ nagbele ’dje uo, amba ngauo di-e, u agó lɨ bɨlɨ na lɨkabhu ɨnde-e de.› ");
INSERT INTO mdm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abalahama agie me: ‹U mbɨla lɨ́lɨ gba Moidje di ne obhuku gba opolofeta-a hana. A ayo me u dje uo.› ");
INSERT INTO mdm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bhʉlʉ tɨa atsia apa me: ‹’Dyɨ ma Abalahama, a mo-o ade. Engʉ́ bini, ɨ dʉ me sʉka okpála ɨnde amu-o nde azuku-o, anɨ nʉ pa pɨ uo-o, u djí bua o.› ");
INSERT INTO mdm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abalahama pɨ anɨ me: ‹Ɨ dʉ me u nde dje engʉ́ ɨnde bhʉ́ lɨ́lɨ gba Moidje di ne bhʉ́ obhuku gba opolofeta de-e, belegʉ ɨ dʉ me sʉka okpála ɨnde amu-o nde azuku-o, u djé di anɨ de.›» ");
INSERT INTO mdm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pɨpɨta-a, Yesu apa pɨ omʉkpata gba e me: «Engʉ́ ɨnde ngato okpála bhʉ́ siti ’ngʉ́-o néke de. Engʉ́ la bini, a ko lɨkabhu pɨ kpála ɨnde ɨ ngato engʉ́ ango-o ko! ");
INSERT INTO mdm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɨ dʉ me kpála bini nde ngato ongɨsɨ bhʉ́ siti ’ngʉ́-o, a pɨ anɨ ndjɨndjɨ me u gbite ngɨngɨ tangʉlʉ anɨ, amba u bhike anɨ bhʉ́ ’ngbé ’ngu. Bhobhomʉ-o pɨ anɨ ndjɨndjɨ naali ane me sʉka okpála na bhʉbhʉkʉ-o tɨ ka anɨ bhʉ́ siti ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ꞌE-e! Yi lila lɨyi ndjɨndjɨ! Ɨ dʉ me ndai mʉ nde amene siti ’ngʉ́-o, mʉ de suno pɨ anɨ. Ɨ dʉ me anɨ nde apa me nɨ amene sisiti-e, mʉ de mbu lɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ɨ dʉ me anɨ nde amene mʉ sisiti bhʉtsibhʉtsi mananɨka lɨ ’kpɨ́ bini-e, anɨ go bhʉtsibhʉtsi mananɨka hana, anɨ pa pɨ mʉ me: ‹Ma amene mʉ sisiti, mbu lɨ ma.› Mʉ de mbu lɨ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Obhʉlʉ titima apa pɨ Ngámá Yesu me: «Mene me nabhuka gba ya-a kolo matá kpekpeke.» ");
INSERT INTO mdm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Abhomʉ-o, Ngámá Yesu atsia agie me: «Ɨ dʉ́ me nabhuka gba yi-e dʉ́ maka lɨ́ ndula na mʉtadi-e, yi de tɨ́ da napa pɨ ndula ɨnde-e me: ‹Yie sɨ, amba mʉ nʉ lu lɨmʉ abhʉ́ ’ngbé ’ngu.› Ɨ tsia méne bhadi moko.» ");
INSERT INTO mdm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Lɨ kpála bini bhʉ́ ká yi dʉ ne kpála na kulu gba e bini-e, ɨ dʉ me kpála na kulu ango-o nde ngamene kulu abhiye, anɨ dʉ di-e ngalila onʉ-o, anɨ gie lɨe akʉtɨ-e, anɨ tsia pá pɨ kpála na kulu ago-o me: ‹Go má gala ngʉ́ nazʉ ’he?› ");
INSERT INTO mdm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A mo-o ade. Anɨ pá mangbo pɨ anɨ me: ‹Lʉ ezʉ, mʉ yipa bongo-o ngʉ́ naha ezʉ-o mʉma akólo lɨ nedhɨnga ma andjia nazʉ ’he lɨe di ne nandjɨ ’he bhende nandjɨ mandjɨ lɨe ko. Pɨpɨta-a, mʉ tsia zʉ ’he amba mʉ ndjɨ di ’he bhe gba mʉ-o.› ");
INSERT INTO mdm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Anɨ tɨ da nagie heni pɨ kpála na kulu-o, anga anɨ amene lɨ́lɨ gba anɨ-e uu? Belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A bhadi pɨ yi moko. Nedhɨnga yi amene ndʉ ’ngʉ́ ɨnde u apa e pɨ yi e lɨe hana-a, yi de pa me: ‹Ya bha naaya ne okpála na kulu. Ya amene bha kulu ɨnde a ayo ɨgɨnɨ me ya mene e ko.›» ");
INSERT INTO mdm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lɨ Yesu adʉ anʉ lɨe abhʉ́ Yelusalema-a, anɨ apʉ sʉnda ndu doto na Samalɨa ne bhe na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Anɨ alɨ lɨe bhʉ́ kʉtɨ bini me-e, obhosɨ na kába ndjɨkpa ago akɵ lɨo ne anɨ. U alʉlʉ mbo de anɨ tsutsu. ");
INSERT INTO mdm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","U atsia aholo atobhɨla me: «Ngámá Yesu, dje nga bha-a mbo ndjinga ya!» ");
INSERT INTO mdm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu au uo lɨe, anɨ atsia apa pɨ uo me: «Yi nʉ suno lɨyi pɨ odimandɵ gba Ebhe-o .» Nedhɨnga u adʉ anʉ lɨe, u atsia akobho. ");
INSERT INTO mdm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Lɨ sʉka uo bini au lɨe me nɨ akobho-o, anɨ atsia agie lɨe sidi me anɨ nde ngadhɵgɵ Ebhe ne angu hana. ");
INSERT INTO mdm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Anɨ atɨ bhʉ́ li ’dhʉ Yesu. Anɨ atʉ bhʉ́la e ne kuto. Anɨ atsia agie heni pɨ Yesu. Bhoko ango-o adʉ nanɨ kpála na Samalɨa. ");
INSERT INTO mdm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Abhomʉ-o, Yesu atsia ayi me: «Ndʉ okpála ndjɨkpa hana akobho adɨ? Obhende odukpabini-e la su? ");
INSERT INTO mdm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kpála bini bhundja nago nagie heni pɨ Ebhe de, bha bini kpála ɨnde naae ne maYuda ade ɨnde-e?» ");
INSERT INTO mdm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pɨpɨta-a, Yesu atsia apa pɨ anɨ me: «Yie bhʉ́lá, nʉnʉ. Mo okobho, anga mo obhuka ma.» ");
INSERT INTO mdm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","OmʉFalisai ayi Yesu me: «Naʉ gba Ebhe-e agó nadho?» Anɨ atsia agie pɨ uo me: «Naʉ gba Ebhe-e gó ngua bhende de me okpála nde ngauu mau-o de. ");
INSERT INTO mdm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","U pá de me: ‹Yi tsitsia, a sɨɨ!› ne me ‹A aoo!› padhá de, anga yi mbɨla me Naʉ gba Ebhe-e bhʉ́ ka yi.» ");
INSERT INTO mdm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pɨpɨta-a, anɨ atsia apa pɨ omʉkpata-a me: «Nedhɨnga koko akólo makolo. Yi akʉ́nda me yi u nga bha mbo ma, Ndɨlɨ gba kpála, ’kpɨ́ bini. Engʉ́ bini, yi ú la ma de. ");
INSERT INTO mdm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","U apá pɨ yi me: ‹Anɨ aoo!› di ne me: ‹Anɨ sɨɨ!› engʉ́ bini, yi agú holo oo de. ");
INSERT INTO mdm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ekpɨ́ lɨ ngama, Ndɨlɨ gba kpála, ma agó lɨe, a adʉ́ maka mʉgbálá, lɨ zɨ e ngayie lɨ ’dje kokpɨ́, lɨ pápá bini akólo lɨ pápá koko. ");
INSERT INTO mdm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Engʉ́ bini, a ayo me ma dje ngaɨza lɨkabhu naali, amba okpála na nakɨ yala di ma. ");
INSERT INTO mdm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Maka engʉ́ ɨnde akodho ’kpɨ́ nanɨ bhʉ́ ’kpɨ́ Nʉa-a, akódho bhadi ’kpɨ́ moko lɨ ’kpɨ́ ɨnde lɨ ngama, Ndɨlɨ gba kpála, ma agó lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Padhá de, anga bhʉ́ ’kpɨ́ Nʉa, okpála adʉ azʉ ’he. U adʉ andjɨ pandɨ. Obhosɨ ne olɨsɨ adʉ aha lɨo akolo lɨ ’kpɨ́ lɨ Nʉa alɨ bhʉ́ zabʉ lɨe ko. Ebha adhɨ, engu asi pɨ́la doto libhomu, a atsia abhili ndʉ uo hana. ");
INSERT INTO mdm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A adʉ́ maka bhʉ́ ’kpɨ́ gba Loto. Okpála adʉ azʉ ’he. U adʉ andjɨ pandɨ. U adʉ akala ’he di ne natsɨndjɨ ’he. U adʉ alu ’zʉ. U adʉ ayiki ’tɨ. ");
INSERT INTO mdm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Engʉ́ bini, ekpɨ́ lɨ Loto akoto bhʉ́ Sodomʉ lɨe, djua di ne ɨtɨmelɨ ayie abhʉ́lá, abala pɨ́ uo maka ebha, atsia abhili ndʉ uo hana. ");
INSERT INTO mdm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","A akódho bhadi ’kpɨ́ moko lɨ ’kpɨ́ lɨ ngama, Ndɨlɨ gba kpála-a, ma súno angu gba ma-a lɨe pɨ okpála ko. ");
INSERT INTO mdm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lɨ ’kpɨ́ ango-o, kpála bhende abháka e apɨ́ ’ngbʉ ’tɨ-e, a ayo de me anɨ lɨ abhʉ́ ’tɨ ngʉ́ nabha ohe gba e de. A bhadi moko, kpála bhende abháka e abhʉ́ ’dyɨ-e, a ayo de me anɨ gie lɨe akʉtɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yi bhundja engʉ́ ɨnde amene nanɨ wala Loto-o. ");
INSERT INTO mdm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kpála bhende agɨ́lɨ nalila mʉkobho gba e, anɨ kpí. Kpála bhende la abhíke mʉkobho gba e, anɨ tsia kóbho. ");
INSERT INTO mdm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ma apa pɨ yi me, sukpe ango-o, okpála bhisi adʉ́ pɨ́ mako bini, u ahá bini, u tsia ꞌó ká koko. ");
INSERT INTO mdm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Olɨsɨ bhisi adʉ́ atʉ mapʉnga bhʉ́ dabɨlɨ bini, u ahá bini, u tsia ꞌó ká koko.  ");
INSERT INTO mdm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Obhosɨ bhisi adʉ́ amene kulu bhʉ́ edyɨ bini, u ahá bini, u tsia ꞌó ká koko.» ");
INSERT INTO mdm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Omʉkpata ayi anɨ me: «Ngámá, engʉ́ ango-o akódho ’kpɨ́ ne su?» Anɨ atsia agie pɨ uo me: «Bɨlɨ lɨ kuo kpála adʉ́ lɨe, oagbagba apɵ́kɵbhɵ bhadi bhʉ́la o oo ko.» ");
INSERT INTO mdm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pɨpɨta-a, Yesu apa gbitaku bini pɨ omʉkpata gba e ngʉ́ nasuno pɨ uo me, a ayo me u dʉ nayo Ebhe ndʉ nedhɨnga hana, u andála de. ");
INSERT INTO mdm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anɨ pɨ uo me: «Kpála nakodho ’ngʉ́ bini adʉ nanɨ bhʉ́ gʉdhʉ bini. Anɨ dʉ akpe Ebhe de. Anɨ atsia adʉ di au okpála bhʉ́ djila e padhá. ");
INSERT INTO mdm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bhʉ́ gʉdhʉ ango-o, ɵkɵ na ɵɵlɵ bini adʉ di oo. Anɨ adʉ ago apa pɨ anɨ me: ‹Leke engʉ́ sʉnda ya ne kpála ɨnde ya nde ne e bhʉ́ ’ngʉ́ ko.› ");
INSERT INTO mdm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ekpɨ́ bhelé, kpála nakodho ’ngʉ́ ango-o adʉ ayayala. Pɨpɨta-a, anɨ atsia apa lɨ bua e me: ‹Ma ngakpe Ebhe ade. Ma la di ngau okpála bhʉ́ djila ma padhá. ");
INSERT INTO mdm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Engʉ́ bini, ɵkɵ ɨnde ngandala ma naali. A ayo me ma leke engʉ́ gba anɨ-o, anga ɨ dʉ mo-o de-e, anɨ dʉ bha ago naba ’ndjɨ ma.›» ");
INSERT INTO mdm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ngámá Yesu atsia apa matá me: «Yi dje engʉ́ ɨnde lɨ siti bhʉlʉ nakodho ’ngʉ́ bhomʉ-o apa e ndjɨndjɨ! ");
INSERT INTO mdm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ebhe méne bádha ’ngʉ́ pɨ okpála ɨnde anɨ alo o-o dɨ? Ɨ dʉ me u nde ngaku ’gba pɨ anɨ sukpe ne ngbɨkpɨ-e? Anɨ djéke ngengele ngʉ́ nateteke uo? ");
INSERT INTO mdm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ma apa pɨ yi me, anɨ aléke ’ngʉ́ gba uo-o má gala! La-a, lɨ nedhɨnga lɨ ngama, Ndɨlɨ gba kpála, ma agó lɨe, ma abháka me okpála nde abhuka Ebhe pɨ́la doto uu?» ");
INSERT INTO mdm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Okpála koko adʉ au lɨo me o naao ngbingbili. U atsia adʉ au ndʉ okpála koko hana bhʉ́ djila o padhá. Abhomʉ-o, Yesu atsia apa gbitaku ɨnde-e lɨ ’ngʉ́ gba uo-o me: ");
INSERT INTO mdm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ekpɨ́ bini, okpála bhisi anʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda ngʉ́ nayo Ebhe. Bhe bini adʉ mʉFalisai , bhe koko adʉ ndɵmbɨ na mandjandja. ");
INSERT INTO mdm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","MʉFalisai-e ayie bhʉ́lá, anɨ atsia ayo Ebhe a lɨ bua e me: ‹Oo, Ebhe! Ma ngagie heni pɨ mʉ, anga ma maka okpála koko ade. U ngazi ’he. U ngamene sisiti ’ngʉ́. U ngakʉnda olɨsɨ, ɨ dʉ di-e obhosɨ gba okpála koko. Ma di ngagie heni pɨ mʉ, anga ma maka ndɵmbɨ na mandjandja ɨnde-e ade. ");
INSERT INTO mdm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ma tsetse ezʉ ’kpɨ́ bhisi sʉnda poso bini ngʉ́ nayo mʉ. Ma haha bini bhʉ́ ká ndjɨkpa pɨ́ ndʉ ’he ma ngasia e hana.› ");
INSERT INTO mdm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ndɵmbɨ na mandjandja alʉ naae mbo tsutsu, anɨ akpe belegʉ natsia ’kpɨ́ ne abhʉ́lá. Engʉ́ bini, anɨ atʉ bhʉ́la e ne kuto, anɨ abu ’kpa e pɨ́ ’ka e, anɨ atsia apa me: ‹Oo, Ebhe! Dje nga bha-a mbo ndjinga ma, ma naama ne siti kpála.›» ");
INSERT INTO mdm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Do Yesu matá me: «Ma apa pɨ yi me, ndɵmbɨ na mandjandja ango-o agie nanɨ lɨe agba e me, Ebhe nde adje nayo gba anɨ-e adje. Engʉ́ bini, Ebhe dje bhende gba mʉFalisai-e de. Padhá de, anga kpála bhende ngaꞌo lɨe ne bhʉ́lá-a, lɨ Ebhe kɵ́ anɨ ne kuto. La-a, kpála bhende ngaꞌo lɨe ne kuto-o, lɨ Ebhe ꞌéꞌe anɨ ne bhʉ́lá.» ");
INSERT INTO mdm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Okpála adʉ ago di pɨ anɨ ne ongɨsɨ na ndjendje ngʉbula me anɨ ꞌo ’kpa e pɨ́ ’ndjɨ uo. Lɨ omʉkpata au lɨe mo-o, u aholo nayoko uo. ");
INSERT INTO mdm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Engʉ́ bini, Yesu aꞌɨ uo, anɨ atsia apa me: «Yi ꞌo ongɨsɨ na djedjedje me u go bhaka ma! Yi aní kpadjɨ pɨ uo de, anga Naʉ gba Ebhe-e , a pɨ okpála ɨnde maka uo ko. ");
INSERT INTO mdm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ma apa pɨ yi na paká me, kpála ɨnde ɨ sia Naʉ gba Ebhe-e maka mboye ndɨlɨ de-e, anɨ tɨ ne Naʉ gba Ebhe-e de.» ");
INSERT INTO mdm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Abhomʉ-o, ngámá bini gba omaYuda ayi Yesu me: «Mʉsuno, ngamʉ bádha kpála, a ayo me ma amene pɨ ngʉbula nasia mʉkobho na dʉdʉma?» ");
INSERT INTO mdm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu atsia agie pɨ anɨ me: «Mʉ ngaꞌɨ ma me bádha kpála ka nɨ? Kpála bini babadha ade. Ebhe bha babadha ngae kpi e kpi. ");
INSERT INTO mdm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mʉ mbɨla olɨ́lɨ-e ndjɨndjɨ: ‹Mo okʉ́nda ɵlɵ, ɨ dʉ di-e bhoko gba kpála koko de. Mo obhɵ́lɵ kpála de. Mo ozí ’he de. Mo opá eu lɨ kilí mʉ de. Manga ’dyɨ mʉ ne ’hi mʉ mamanga.›» ");
INSERT INTO mdm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ngámá ango-o atsia apa me: «Nayie bhʉ́ ndɨlɨ lɨ ma-a, ma amene ndʉ ’ngʉ́ bhomʉ-o hana.» ");
INSERT INTO mdm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pɨta lɨ Yesu adje engʉ́ bhomʉ-o lɨe, anɨ atsia apa pɨ anɨ me: «Mo oneke matá koli ehe bini. Nʉnʉ, tsɨndjɨ ndʉ ’he gba mʉ-o hana, amba mʉ gapa tɨatɨa pɨ obhʉlʉ ndɨbhɨlɨ. Mo osía tɨa abhʉ́lá. Pɨpɨta-a, mʉ go kpata ma.» ");
INSERT INTO mdm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Anɨ adje lɨe mo-o, anɨ asia lɨkabhu naali, anga tɨa adʉ nanɨ ka anɨ bhelé naali. ");
INSERT INTO mdm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Lɨ Yesu au lɨe me anɨ asia lɨkabhu mo-o, anɨ atsia apa me: «A bha ndjʉ kpekpeke pɨ obhʉlʉ tɨa ngʉ́ nalɨ bhʉ́ Naʉ gba Ebhe-o! ");
INSERT INTO mdm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A kpekpeke pɨ eya ngʉbula nalɨ lɨ gudho mʉsana. A la matá kpekpeke ane pɨ bhʉlʉ tɨa ngʉbula nalɨ bhʉ́ Naʉ gba Ebhe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abhomʉ-o, okpála ɨnde adje engʉ́ ɨnde anɨ apa e atsia ayi me: «Ɨ dʉ mo-o, a tɨ da nakobho da?» ");
INSERT INTO mdm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu agie me: «Engʉ́ bhende ɨ tɨ ne okpála de-e, a atɨ bha ne Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Abhomʉ-o, Piele atsia apa me: «Tsitsia nga, ya aꞌo ká ndʉ ’he gba ya-a hana ngʉ́ nakpata mʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Do Yesu pɨ uo me: «Ma apa pɨ yi na paká me, ɨ dʉ me kpála bini nde aꞌo ká etɨ gba e, anɨ ꞌo ká wala e, anɨ ꞌo ká ondaise e, anɨ ꞌo ká okpála ɨnde azu e, anɨ ꞌo ká ongɨsɨ gba e ngʉbula Naʉ gba Ebhe-e, ");
INSERT INTO mdm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anɨ sía ’he bhelé naali kuto ei. Pɨpɨta-a, bhʉ́ nedhɨnga ɨnde ngago-o, anɨ tsia sía di mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pɨpɨta-a, Yesu aha okpála na titima ndjɨkpa ne ká bhisi-e, anɨ anʉ ne uo lɨ ngongo, anɨ atsia apa pɨ uo me: «Yi djedje, nɨ́ adji mbɨa ɨnde-e abhʉ́ Yelusalema. Oo, ndʉ ’ngʉ́ hana ɨnde lɨ opolofeta aye e pɨndjɨ ma, Ndɨlɨ gba kpála-a, adji amene lɨe. ");
INSERT INTO mdm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Padhá de, anga u apʉ́ ma pɨ omʉpagano. Lɨ okpála ango-o mʉ́ ma, u sóbho ma, u tsia kú di ngʉsʉ lɨ kʉte ma. ");
INSERT INTO mdm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","U abhɨ́ ma ne fimbo. Pɨpɨta-a, u tsia bhɵ́lɵ ma. La-a, bhʉ́ ’kpɨ́ na bata-a, ma tsia zúku.» ");
INSERT INTO mdm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Engʉ́ bini, omʉkpata mbɨla nanɨ ta ’ngʉ́ ango-o de, anga a awo nanɨ lɨe pɨ uo mawo. U tsia dʉ ambɨla ta ’ngʉ́ lɨ Yesu adʉ apa e de. ");
INSERT INTO mdm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lɨ Yesu akolo lɨe masɨkpe de Djeliko-o, kpála bini ɨnde ɨ u ’kpɨ́ de-e adʉ kuto dengo ’hi-kpadjɨ. Anɨ adʉ ayo ’he. ");
INSERT INTO mdm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Anɨ adje tolo okpála akodho ’kpɨ́ lɨe, anɨ atsia ayi me: «A ko nɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Okpála atsia agie pɨ anɨ me: «Yesu, kpála na kʉtɨ na Nadjaleta ngakodho ’kpɨ́ bhomʉ-o ngae.» ");
INSERT INTO mdm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Abhomʉ-o, anɨ atsia asʉla me: «Yesu, Ndɨlɨ gba Davidi, dje nga bha-a mbo ndjinga ma!» ");
INSERT INTO mdm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Okpála ɨnde adʉ akalanʉ-o aholo ambembe bhʉ́ ’ndjɨ anɨ me: «Gbite ’bhɵ mʉ.» Engʉ́ bini, anɨ aholo asʉsʉla matá kpekpeke me: «Ndɨlɨ gba Davidi, dje nga bha-a mbo ndjinga ma!» ");
INSERT INTO mdm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu alʉ, anɨ atsia aha lɨ́lɨ me u go ne anɨ pɨ nɨ. Anɨ akolo lɨe de anɨ-e, Yesu atsia ayi anɨ me: ");
INSERT INTO mdm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Mo okʉnda me ma mene pɨ mʉ nɨ?» Anɨ agie me: «Ngámá, bhulu djila ma, amba ma u matá ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu apa pɨ anɨ me: «U matá ’kpɨ́ uu! Mo okobho anga mo obhuka ma.» ");
INSERT INTO mdm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kolo má gala me-e, anɨ aholo matá nau ’kpɨ́. Anɨ atsia adʉ akpata Yesu me anɨ nde ngadhɵgɵ Ebhe. Ndʉ okpála hana ɨnde au engʉ́ ango-o, aholo di nadhɵgɵ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pɨta lɨ Yesu alɨ lɨe bhʉ́ Djeliko, anɨ atsia adʉ agulu gʉdhʉ-o. ");
INSERT INTO mdm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A abhaka me kpála bini nde oo, a adʉ ’lɨ anɨ me Djakayo. A adʉ nanɨ ngámá gba ondɵmbɨ na mandjandja. Tɨa adʉ ka anɨ bhelé. ");
INSERT INTO mdm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Anɨ adʉ agɨlɨ nau me Yesu ngae dho. Engʉ́ bini, lɨ okpála adʉ la lɨe bhelé-e, anɨ ale nau anɨ pima anga anɨ adʉ nanɨ ndundu. ");
INSERT INTO mdm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Abhomʉ-o, anɨ ayiki lɨe ne holo ne akalanʉ. Anɨ atsia aꞌʉ bhʉ́ ndula bini dengo ’hi-kpadjɨ ngʉbula me nɨ u Yesu nedhɨnga ɨnde anɨ apʉ́ lɨe oo ko. ");
INSERT INTO mdm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lɨ Yesu akolo lɨe lɨ bɨlɨ bhomʉ-o, anɨ aꞌe djila e ne abhʉ́lá, anɨ atsia anɨ. Anɨ atsia apa pɨ anɨ me: «Djakayo, kɵ kuto má gala, anga a ayo me ma sɨ nakɨ bhʉ́ ’tɨ gba mʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Abhomʉ-o, Djakayo akɵ kuto bhʉ́ holo. Anɨ atsia asia Yesu ne djalɨ hana. ");
INSERT INTO mdm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ndʉ okpála hana au lɨe mo-o, u aholo adi mʉtokono. U atsia adʉ apa me: «Lele pɨ lɨ kpála ɨnde-e atapa lɨe nasɨ agba kpála na sisiti-e!» ");
INSERT INTO mdm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Djakayo ayie bhʉ́lá, do anɨ pɨ Yesu me: «Ngámá, djedje nga. Ma agbó bhʉsʉ tɨa gba ma-a bhisi. Ma ahá bhe bini-e pɨ obhʉlʉ ndɨbhɨlɨ. Ɨ dʉ me ma nde aha tɨa gba kpála bini ne kali-e, ma agíe pɨ anɨ bhʉtsibhʉtsi badha.» ");
INSERT INTO mdm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Nakɨ-e, Ebhe akobho mʉ. Ngamʉ di-e, mʉ bhʉ́ piga gba Abalahama-o. ");
INSERT INTO mdm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Padhá de, anga ngama, Ndɨlɨ gba kpála-a, ma ago nagɨlɨ di ne nakobho okpála ɨnde angɨta ko.» ");
INSERT INTO mdm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu akolo de Yelusalema masɨkpe. Okpála ɨnde adʉ adje anɨ-e adʉ abhundja naao me, Naʉ gba Ebhe-e asúno lɨe pɨ okpála mbɨa ɨnde. ");
INSERT INTO mdm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaka-a, anɨ atsia apa gbitaku bini pɨ uo me: «Kpála bini na piga gba ngámá bini anʉ nanɨ bhʉ́ doto bini tsutsu ngʉbula me u to palata na ngámá tangʉlʉ nɨ, amba pɨpɨta-a, nɨ gie lɨnɨ. ");
INSERT INTO mdm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kala me anɨ nʉ-o, anɨ aꞌɨ okpála na kulu gba e ndjɨkpa-o. Anɨ agapa lɨ́ falanga bini bini lɨ ndʉ uo hana. Anɨ atsia apa pɨ uo me: ‹Yi mene kulu ne falanga ɨnde, akólo lɨ nedhɨnga ɨnde ma agíe lɨma lɨe ko.› ");
INSERT INTO mdm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Okpála na doto gba anɨ-e adʉ ayala anɨ. U atima okpála nganda anɨ ngʉ́ napa me: ‹Ya kʉnda de me kpála bhomʉ-o ʉ ngámá pɨ́ ’ndjɨ ya-a de.› ");
INSERT INTO mdm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","La-a, u ato palata na ngámá tangʉlʉ anɨ. Anɨ atsia agie lɨe bhʉ́ doto gba e-o. Abhomʉ-o, anɨ aꞌɨ okpála na kulu ɨnde anɨ agapa nako falanga lɨo ngʉbula nambɨla bhende u asia e pépé-o. ");
INSERT INTO mdm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Abhomʉ-o bhe na kalanʉ-o ago. Anɨ atsia apa me: ‹Ngámá, ma asia lɨ́ falanga ndjɨkpa pɨ́ bhende nako mo oha e mʉma ko.› ");
INSERT INTO mdm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Abhomʉ-o, ngámá-a apa pɨ anɨ me: ‹A ndjɨndjɨ. Mʉ ne bádha kpála na kulu, anga mo omene ndjɨndjɨ bhʉ́ mboye ehe bedɨ. Ma aꞌó ɨbili mʉ ngámá pɨ́ ’ndjɨ ogʉdhʉ ndjɨkpa.› ");
INSERT INTO mdm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bhe na bhisi-e ago, anɨ atsia apa me: ‹Ngámá, ma asia lɨ́ falanga bhuluvue pɨ́ bhende nako mo oha e mʉma ko.› ");
INSERT INTO mdm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Abhomʉ-o, ngámá-a apa di pɨ anɨ me: ‹Ngamʉ di-e, ma aꞌó mʉ ngámá pɨ́ ’ndjɨ ogʉdhʉ bhuluvue.› ");
INSERT INTO mdm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pɨpɨta-a, koko ago, do anɨ de-e: ‹Ngámá, lɨ́ falanga gba mʉ-o ɨɨ. Ma awo nako bhʉ́ bongo . ");
INSERT INTO mdm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉ ꞌo lɨ ma tsʉlʉ, anga mʉ ne kpála ɨnde ngamene ’ngʉ́ na kpekpeke. Mʉ ngaha ehe bhende mʉ ꞌo e ngamʉ de. Mʉ ngaha ’zʉ ɨnde mʉ lu e ngamʉ de.› ");
INSERT INTO mdm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ngámá-a apa pɨ anɨ me: ‹Mʉ ne siti kpála na kulu. ’Li mʉ makpe agbíte mʉ ngae. Mo ombɨla nako hana me, ma ne kpála ɨnde ngamene ’ngʉ́ na kpekpeke. Ma ngaha ehe ɨnde ma aꞌo e ngama de. Ma ngaha ezʉ ɨnde ma alu e ngama de. ");
INSERT INTO mdm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ka nɨ mʉ ꞌo nako tɨa gba ma-a lɨe bhʉ́ bakɨ de-e? Maka ma ago-o, ma de asia koko pépé.› ");
INSERT INTO mdm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pɨpɨta-a, anɨ apa pɨ okpála ɨnde adʉ oo me: ‹Yi dhepe tɨa ɨnde ka anɨ bhomʉ, amba yi ha pɨ bhende ne di ndjɨkpa ko.› ");
INSERT INTO mdm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","U atsia apa pɨ anɨ me: ‹Ngámá, a ka anɨ ndjɨkpa!› ");
INSERT INTO mdm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Anɨ agie me: ‹Ma apa pɨ yi me, kpála bhende lɨ ehe nde ka e, u ahá ehe pɨ anɨ bhelé. Engʉ́ bini kpála bhende lɨ ehe nde ka e ade-e, u adhépe belegʉ mboye ehe ɨnde ka anɨ ko. ");
INSERT INTO mdm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","La-a, pɨ obhʉlʉ yala gba ma ɨnde ɨ kʉnda nako de me ma aʉ ngámá pɨ́ ’ndjɨ o-o, yi go ne uo ei, amba yi bhili uo kala ma sɨɨ.›» ");
INSERT INTO mdm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pɨta lɨ Yesu akpo ’ngʉ́ bhomʉ-o lɨe, anɨ atsia akodho ’kpɨ́ ne akalanʉ ngʉ́ nanʉ bhʉ́ Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Anɨ akolo lɨe sʉnda kʉtɨ na Betefadje ne Betanɨa-a, lɨngo ’ta na ondula na Olive, anɨ atsia atima omʉkpata bhisi. ");
INSERT INTO mdm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Anɨ pɨ uo me: «Yi nʉ bhʉ́ kʉtɨ ɨnde kala yi aoo. Yi akólo lɨe oo, yi abháka me u nde agbite ndɨlɨ punda oo. Kpála bini dhʉkʉ nga pɨ anɨ de. Yi bhulu anɨ amba yi go ne anɨ ei. ");
INSERT INTO mdm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɨ dʉ me kpála bini nde ayi yi me: ‹Yi ngabhulu anɨ ngʉ́ nɨ?› Yi de pa pɨ anɨ me: ‹Ngámá ne gʉmʉ anɨ.›» ");
INSERT INTO mdm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Omʉkpata bhisi anʉ, u atsia abhaka ndʉ ’ngʉ́ hana maka lɨ Yesu apa pɨ uo lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","U adʉ abhulu enʉ-o lɨe, obhʉbhʉlʉ-o ayi uo me: «Yi ngabhulu enʉ bhomʉ-o ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","U agie me: «Ngámá ne gʉmʉ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pɨpɨta-a, u ago ne ndɨlɨ ’nʉ-o pɨ Yesu. U apa okoti gba o pɨ́ ’ngbʉ enʉ-o. U atsia ateteke Yesu ngʉ́ naꞌʉ pɨ́ ’ngbʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Anɨ adʉ anʉ lɨe, okpála adʉ apa okoti gba o lɨ kpadjɨ. ");
INSERT INTO mdm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Anɨ akolo de Yelusalema masɨkpe lɨ ngba ’ta na ondula na Olive. Ndʉ omʉkpata hana abedhe ne djalɨ bedhe. U atsia aholo nadhɵgɵ Ebhe kpekpeke ngʉ́ ndʉ ongamba ’ngʉ́ hana ɨnde u au e ko. ");
INSERT INTO mdm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","U adʉ apa me: «A ayo me Ebhe tuko bisagu pɨ́ ’ngbé ngámá ɨnde anɨ atima e ko! Guo ’ngʉ́ abhʉ́lá, amba sangu dʉ di pɨ Ebhe Apɨ́ ’Kpɨ́!» ");
INSERT INTO mdm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","OmʉFalisai koko ɨnde adʉ bhʉ́ ká okpála bhomʉ-o, apa pɨ Yesu me: «Mʉsuno, yoko omʉkpata gba mʉ-o mayoko.» ");
INSERT INTO mdm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu atsia agie me: «Ma apa pɨ yi me, ɨ dʉ me u nde agbite ’bhɵ o-o, lɨ oteme holo natʉ ꞌue!» ");
INSERT INTO mdm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lɨ Yesu akolo lɨe masɨkpe de Yelusalema-a, anɨ au gʉdhʉ-o lɨe, anɨ atsia aholo aku ’gbá ngʉ́ okpála ango-o. ");
INSERT INTO mdm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Anɨ adʉ apa me: «Aa! Ngayi okpála na Yelusalema-a, ɨ dʉ́ me yi mbɨ́la lɨ ’kpɨ́ na nakɨ ɨnde-e, guo ’ngʉ́ ɨnde u ago pɨ yi ne e uu-o! La-a, a ko lɨkabhu pɨ yi anga mbɨa ɨnde-e, awo lɨe pɨ yi mawo. ");
INSERT INTO mdm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Padhá de, anga oekpɨ́ koko akólo pɨ yi makolo, lɨ ’kpɨ́ ango-o, obhʉlʉ yala gba yi-e, asá aga dengo yi ngbalina. U búka yi, u tsia há ’gʉ́ pɨ yi ne ndʉ pápá hana. ");
INSERT INTO mdm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","U agʉ́gʉmʉ gʉdhʉ-o. U tsia bhíli ndʉ okpála ɨnde bhʉ́bhʉ́-o hana. Agba yi-e, teme bini tígala pɨ́ kilí e de, anga yi mbɨla nanɨ ekpɨ́ ɨnde lɨ Ebhe ago natsia yi lɨe de!» ");
INSERT INTO mdm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pɨpɨta-a, Yesu alɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Anɨ atsia aholo natsambala okpála ɨnde adʉ atsɨndjɨ ’he oo-o. ");
INSERT INTO mdm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Anɨ apa pɨ uo me: «U aye bhʉ́ Bhuku gba Ebhe-e me, Ebhe apa me: ‹Etɨ gba ma-a, a adʉ́ etɨ nayo ma.› Engʉ́ bini, ngayi-e, yi adji, atsia akolo bɨlɨ gba obhʉlʉ ’zi!» ");
INSERT INTO mdm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu adʉ asuno ndʉ ’kpɨ́ hana bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. Ongbengbe odimandɵ , omʉsuno na lɨ́lɨ gba Moidje di ne obhelesɨ okpála adʉ agɨlɨ kpadjɨ ngʉ́ nabhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Engʉ́ bini, u tsia sia kpadjɨ ngʉ́ namemene de, anga ndʉ okpála hana adʉ adje anɨ ne gʉgʉmʉ naali. ");
INSERT INTO mdm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A akolo ekpɨ́ bini, Yesu adʉ asuno pɨ okpála bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. Anɨ atsia adʉ di nakpokpo Bádha Ngali pɨ uo. Ongbengbe odimandɵ gba Ebhe , omʉsuno na lɨ́lɨ gba Moidje di ne obhelesɨ okpála ago. ");
INSERT INTO mdm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","U atsia ayi anɨ me: «Pa nga pɨ ya, aha kpadjɨ pɨ mʉ ngʉ́ namene ongʉ́ ɨnde-e da? A aha la di angu ango-o pɨ mʉ ngánga da?» ");
INSERT INTO mdm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Abhomʉ-o, Yesu atsia agie pɨ uo me: «Ngama di-e, ma ayí yi lɨ ’ngʉ́ bini. Yi pa nga mʉma, ");
INSERT INTO mdm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a ha kpadjɨ pɨ Djaa ngʉ́ nabatisa okpála da? Ne me a ko Ebhe, ne me a ko okpála?» ");
INSERT INTO mdm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","U aholo namene kpekebhɵ sʉnda o. U atsia adʉ apa me: «Ɨ dʉ me nɨ́ nde agie me: ‹A aha kpadjɨ pɨ anɨ ne Ebhe›, anɨ yí nɨ́ me: ‹Ɨ dʉ mo-o, ka nɨ yi bhuka la nanɨ engʉ́ ɨnde anɨ adʉ apa e lɨe de-e?› ");
INSERT INTO mdm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ɨ dʉ di me nɨ́ nde apa me: ‹A ha kpadjɨ pɨ anɨ ne okpála-a›, lɨ ndʉ okpála hana bhíli nɨ́ ne teme, anga u ambɨla ndjɨndjɨ me Djaa nanɨ ne polofeta .» ");
INSERT INTO mdm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Abhomʉ-o, u atsia agie me: «Ya mbɨla kpála ɨnde aha kpadjɨ pɨ anɨ-e de.» ");
INSERT INTO mdm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Do Yesu pɨ uo me: «Ɨ dʉ mo-o, ngama di-e, ma pá pɨ yi de me aha kpadjɨ mʉma da ngʉ́ namene ehe ɨnde.» ");
INSERT INTO mdm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pɨpɨta-a, Yesu aholo nakpokpo gbitaku ɨnde-e pɨ okpála me: «Kpála bini alu nanɨ ngu vino. U adje lɨo ne okpála ngʉ́ namene kulu bhʉ́ ’dyɨ-o, amba o dʉ agbó bhʉsʉ o ne uo lɨ nguwa-o. Anɨ atsia atapa dhʉkʉ ngʉbula ’kpɨ́ bhelé. ");
INSERT INTO mdm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","A akolo lɨ nedhɨnga nako lɨ́lɨ́ o. Abhomʉ-o, anɨ atima kpála na kulu bini agba okpála ango-o me u ha nguwa bhe gba nɨ-e pɨ nɨ haha. Engʉ́ bini, okpála ango-o abhɨ kpála na kulu bhomʉ-o má kpú! U atsia agie anɨ ne mbʉlʉ ’kpa e padhá. ");
INSERT INTO mdm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bhʉlʉ ’dyɨ-e atima matá kpála na kulu koko bini. U abhɨ di anɨ, u asosobho anɨ, u atsia agie anɨ ne mbʉlʉ ’kpa e padhá. ");
INSERT INTO mdm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Anɨ atima matá kpála na bata. Bhobhomʉ-o, u atsotsolo kʉte anɨ ne eka. U atsia agbe anɨ bhʉ́ ’dyɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Abhomʉ-o, bhʉlʉ ’dyɨ atsia apa me: ‹Ma améne sɨ pɨ? Ma atíma nga ɨbili ndɨlɨ gba ma na mʉkʉnda-o. Nedhɨnga koko-o, u tɨ́ da namanga anɨ.› ");
INSERT INTO mdm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Engʉ́ bini, lɨ okpála ango-o au ndɨlɨ-e lɨe me-e, u atsia apa sʉnda o me: ‹Yi tsia nga la ndjʉ kpála ɨnde atígala galikpe ne edyɨ-o. Nɨ́ bhɵlɵ anɨ, amba edyɨ-e kolo ɨbili naanɨ́.› ");
INSERT INTO mdm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Abhomʉ-o, u agbe anɨ bhʉ́ ’dyɨ-o, u abhɵlɵ anɨ.» Yesu atsia ayi me: «Mbɨa ɨnde-e, bhʉlʉ ’dyɨ-e améne ngʉ́ uo pɨ? ");
INSERT INTO mdm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Anɨ agó, anɨ bhíli okpála na kulu ango-o. Anɨ tsia há edyɨ-e pɨ okpála na kulu koko.» Lɨ okpála adje engʉ́ bhomʉ-o lɨe, u atsia apa me: «A ayo de me, bhobhomʉ-o mene lɨe de!» ");
INSERT INTO mdm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu atsia uo, anɨ atsia apa me: «Engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e me: ‹Teme ɨnde lɨ okpála nayiki etɨ-e abhike e, akolo teme ɨnde abɨ etɨ-e libhomu.› A akʉnda napa pɨ? ");
INSERT INTO mdm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɨ dʉ me kpála nde atɨ pɨ́ teme ango-o, anɨ gʉ́gʉmʉ. Ɨ dʉ la di me teme ango-o nde atɨ pɨ́ kpála-a, ɨ tʉ́ nʉ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bha lɨ nedhɨnga bhomʉ-o, omʉsuno na lɨ́lɨ gba Moidje di ne ongbengbe odimandɵ gba Ebhe-e, agɨlɨ nanɨ naholo Yesu, anga u ambɨla me anɨ apa gbitaku bhomʉ-o lɨ ’ngʉ́ gba o-o. Engʉ́ bini, u adʉ adje tsʉlʉ ka okpála. ");
INSERT INTO mdm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Abhomʉ-o, u aholo akenge Yesu. U atsia atima obhʉlʉ kali ɨnde adʉ amene ehe mʉgɨto me uo ngbingbili. Okpála ango-o adʉ agɨlɨ naholo anɨ lɨ ’li e ngʉbula me o pʉ anɨ pɨ Pɨlatɵ, ngámá na ndu doto ango-o. ");
INSERT INTO mdm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","U ayi anɨ me: «Mʉsuno, ya ambɨla me mʉ ngagama ’ngʉ́ ndjɨndjɨ, mʉ la di ngasuno ’ngʉ́ ngbingbili. Mʉ tsia engbé gba kpála de. Mʉ ngasuno kpadjɨ gba Ebhe-e pɨ okpála ngbingbili. ");
INSERT INTO mdm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pa nga pɨ ya, a ayo me ya kala mandjandja gba Kaisala , ’ngbé ngámá na doto na Loma-a , ne me ya kala de?» ");
INSERT INTO mdm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lɨ Yesu ambɨla ekú gba uo-o lɨe, anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Yi suno nga lɨ́ falanga mʉma bini. A pépé ne kulu da, la di ne ’lɨ da?» U agie me: «A ko kulu Kaisala, ’ngbé ngámá na doto na Loma, di ne ’lɨ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Ɨ dʉ mo-o, yi ha ehe bhende gba Kaisala, ’ngbé ngámá na doto na Loma-a pɨ e, amba yi ha la di bhende gba Ebhe-e pɨ Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","U u siti ’ngʉ́ bhʉ́ engʉ́ ɨnde anɨ adʉ apa e kala okpála-a de. Engʉ́ bini, u angamba naali ka eli ɨnde anɨ agie e ko. Kaka-a, u andjili bha má bulu! ");
INSERT INTO mdm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Abhomʉ-o, oSadukai koko ago de Yesu. OSadukai zɨba nanɨ naao de me okpála ɨnde amu-o, azúku mazuku-o de. U ayi anɨ me: ");
INSERT INTO mdm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Mʉsuno, Moidje aye nanɨ lɨ́lɨ pɨ nɨ́ me: ‹Lɨ kpála kpi ꞌo ká wala e me anɨ nde zu de-e, a ayo me ndai anɨ de ha ɵlɵ ango-o, amba anɨ zu ongɨsɨ pɨ ndai e ɨnde akpi ko.› ");
INSERT INTO mdm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","La-a, adʉ nanɨ obhosɨ mananɨka bhʉ́ piga bini. Bhende na kalanʉ-o aha ɵlɵ, anɨ akpi padhá me anɨ nde zu de. ");
INSERT INTO mdm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bhende na bhisi-e aha ɵkɵ ango-o. Anɨ atsia akpi. ");
INSERT INTO mdm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pɨpɨta-a, bhende na bata-o. A adʉ bhadi moko pɨ ndʉ uo mananɨka hana, u amu me u nde zu de. ");
INSERT INTO mdm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Alɨ soso-o, ɵlɵ ango-o atsia akpi di. ");
INSERT INTO mdm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ya ngayi mʉ me: Lɨ ’kpɨ́ lɨ okpála ɨnde amu-o azúku lɨe, ɵlɵ ango-o adʉ́ naa da? Padhá de, anga ndʉ uo mananɨka hana aha nanɨ anɨ!» ");
INSERT INTO mdm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Abhomʉ-o, Yesu atsia agie pɨ uo me: «Okpála na nakɨ ɨnde-e ngaha lɨo. ");
INSERT INTO mdm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Engʉ́ bini, okpála bhende amu-o, lɨ Ebhe au me u tɨ da nazuku ngʉ́ nasia mʉkobho bhʉ́ nedhɨnga ɨnde ngago-o, u há lɨo de. ");
INSERT INTO mdm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","U tɨ́ da matá namu-u de, anga u akolo ɨbili maka oandjelu . A ko ongɨsɨ gba Ebhe, anga u azuku. ");
INSERT INTO mdm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moidje asuno pɨ nɨ́ mbámbá me okpála ɨnde amu-o azúku mazuku. Anɨ aye bhʉ́ bhuku gba e lɨ bɨlɨ ɨnde anɨ akpo ’ngʉ́ lɨe pɨndjɨ tsa ’po ɨnde adʉ atsi-e me, Ebhe apa me: ‹Ma ne Ebhe ɨnde lɨ Abalahama ngadhɵgɵ e, Ebhe ɨnde lɨ Ɨsaka ngadhɵgɵ e, Ebhe ɨnde lɨ Yakobho ngadhɵgɵ e ko.› ");
INSERT INTO mdm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ebhe ne Ebhe gba okpála bhende amu-o ade. Engʉ́ bini, a ko Ebhe gba okpála bhende bhʉ́ mʉkobho, maka lɨ Abalahama, Ɨsaka ne Yakobho nde pɨ anɨ lɨe bhʉ́ mʉkobho ko.» ");
INSERT INTO mdm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Abhomʉ-o, omʉsuno na lɨ́lɨ koko atsia agie pɨ anɨ me: «Mʉsuno, mo opa ndjɨndjɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kaka-a, u yi matá anɨ lɨ ’ngʉ́ bini de. ");
INSERT INTO mdm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Abhomʉ-o, Yesu apa matá pɨ uo me: «Lele pɨ lɨ okpála tɨ da napa lɨe me Masɨya ne ndɨlɨ na piga gba Davidi-e? ");
INSERT INTO mdm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Padhá de, anga ngaanɨ Davidi makpe-e, anɨ apa bhʉ́ bhuku na oetsi gba omaYuda me: ‹Ebhe Ngámá apa pɨ Ngámá gba ma-a me: Dʉ kuto lɨ pá ’kpa ma na kokpa, ");
INSERT INTO mdm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","akólo lɨ nedhɨnga ɨnde ma aꞌó obhʉlʉ yala gba mʉ-o lɨe dabɨlɨ na sa-tɨdhʉ mʉ ko.› ");
INSERT INTO mdm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɨ dʉ me Davidi nde ngaꞌɨ Masɨya me Ngámá gba nɨ-e, lele pɨ lɨ Masɨya tɨ da nadʉ lɨe ndɨlɨ na piga gba Davidi-e?» ");
INSERT INTO mdm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Anɨ apa pɨ omʉkpata kala ndʉ okpála hana ɨnde adʉ adje anɨ-e me: ");
INSERT INTO mdm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ꞌE-e! Yi lila lɨyi ka omʉsuno na lɨ́lɨ gba Moidje-e uu! U kʉnda bha nadhʉkʉ ne ondjandja yambu. U kʉnda bha me okpála dʉ ne yiyi o maka ongámásɨ lɨ bɨlɨ lɨ okpála apɵpɵkɵbhɵ bhʉ́la o lɨe ko. U kʉnda bha nadʉlʉ pɨ́ odabɨlɨ na akalanʉ bhʉ́ oetɨ nadje lɨ́lɨ , di ne odabɨlɨ na akalanʉ bhʉ́ da anokomɨa. ");
INSERT INTO mdm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","U ngandjia angu oɵkɵsɨ na olɨsɨlɨsɨ ne nabha ohe gba uo. U ngayo Ebhe ngengele ngʉ́ nasuno mʉgɨto me a ko obabadha okpála. Kaka-a, u asía lɨkabhu naali!» ");
INSERT INTO mdm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ekpɨ́ bini, Yesu adʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. Anɨ atsia ’kpɨ́, anɨ au me obhʉlʉ tɨa ngabhike tɨa gba o-o bhʉ́ sanduku na makiso na ’Ngbe ’tɨ Ebhe-e ngʉ́ nahaha pɨ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Anɨ atsia au di ɵkɵ bini na ɵɵlɵ bhʉlʉ ndɨbhɨlɨ me anɨ nde ngabhike senge bhisi. ");
INSERT INTO mdm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Abhomʉ-o, anɨ atsia apa me: «Ma apa pɨ yi na paká me, ɵlɵ na ndɨbhɨlɨ lɨ ’ko e akpi ɨnde-e, aha makiso ane ndʉ okpála koko hana. ");
INSERT INTO mdm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Padhá de, anga ndʉ okoko hana, u aha tɨa bhende u nde ne gʉmʉ e ade ko. Engʉ́ bini, ngaanɨ-e, abana anɨ nde lɨe bhʉ́ ndɨbhɨlɨ-e, anɨ aha ndʉ bhende anɨ adʉ akobho lɨe hana.» ");
INSERT INTO mdm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pɨpɨta-a, okpála koko aholo akpokpo ’ngʉ́ pɨndjɨ ’ngbé ’tɨ Ebhe gba omaYuda-o. U adʉ apa me: «A bha ndjʉ babadha naali ne obabadha teme ango-o, di ne ohe na mase naali ɨnde u aha e pɨ Ebhe-o.» Engʉ́ bini, Yesu atsia apa me: ");
INSERT INTO mdm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ndʉ ’he ɨnde yi ngau e ɨnde-e, ekpɨ́ koko akólo makolo, teme bini tígala pɨ́ kilí e de. U agʉ́gʉmʉ etɨ-e hana kuto.» ");
INSERT INTO mdm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abhomʉ-o, u atsia ayi anɨ me: «Mʉsuno, engʉ́ ɨnde mʉ ngakpokpo ’ngʉ́ pɨndjɨ e bhomʉ-o, akólo nadho? Ehe ɨnde asúno nedhɨnga nago ka engʉ́ ango-o, a adʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu agie me: «Yi lila lɨyi uu! Kpála bini apíte yi de. Padhá de, anga okpála bhelé agó ne ’lɨ ma, u tsia pá me: ‹Ma ne Masɨya !› U tsia pá di me: ‹Nedhɨnga nago ka Masɨya akolo!› Engʉ́ bini, yi akpáta uo de. ");
INSERT INTO mdm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ɨ dʉ me yi nde adje okpála ngakpo ’ngʉ́ na oegʉ́ di ne ongʉ́ na okpekpeke ’ndjɨ-e, yi adjé tsʉlʉ de. Padhá de, anga a ayo ngaɨza me oengʉ́ ango-o kolo kalanʉ. La-a, sokpɨ́-e dʉ́ nga kolo má gala mo-o de.» ");
INSERT INTO mdm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pɨpɨta-a, anɨ matá pɨ uo me: «Okpála na kʉtɨ bini ahá ’gʉ́ pɨ okpála na kʉtɨ koko. Lɨ ngámá na kʉtɨ bini há ’gʉ́ pɨ ngámá na kʉtɨ koko. ");
INSERT INTO mdm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Doto adyɨ́kɨ ne adjigidjo na ngbéngbé. Adyɨndɨ di ne osisiti kuo natagba matagba alɨ́ bhʉ́ obɨlɨ ngangá. Yi aú ongamba ’ngʉ́ di ne ongʉ́ na tsʉlʉ tsʉlʉ abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Engʉ́ bini, kala me ndʉ ’ngʉ́ bhomʉ-o hana kolo-o, u ahólo yi. U améne yi sisiti. U anʉ́ ne yi me u kodho ’ngʉ́ gba yi-e bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje . U tsia bhíke yi bhʉ́ tɨkpʉ. U asʉngʉla yi pɨ ongbengbe ongámásɨ di ne obhende ngatsia ’kpɨ́ lɨ kʉtɨ-e kabula ’lɨ ma. ");
INSERT INTO mdm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bhobhomʉ-o ahá kpadjɨ pɨ yi ngʉbula me, yi kpokpo ’ngʉ́ gba ma-a pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yi ꞌo lɨ bua yi me, yi gɨ́lɨ engʉ́ ɨnde yi apá e lɨ nedhɨnga nakodho ’ngʉ́ gba yi-e kalanʉ de. ");
INSERT INTO mdm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Padhá de, anga ma ahá eli di ne ɨmbɨlangʉ pɨ yi ngama makpe, ngʉbula nagbite ’bhɵ ndʉ obhʉlʉ yala gba yi-e hana. ");
INSERT INTO mdm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Odyɨ yi ne ohi yi, ondaise yi ne okpála na piga gba yi di ne obɨ yi apʉ́ belegʉ yi ngao. U abhíli okpála koko bhʉ́ ka yi. ");
INSERT INTO mdm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndʉ okpála hana ayála yi kabula ’lɨ ma. ");
INSERT INTO mdm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Engʉ́ bini, ’kpa sundjo yi ngɨ́ta belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɨ dʉ me yi nde alʉ kpekpeke akólo lɨ soso-o, yi sía mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Nedhɨnga yi aú lɨe me osʉdha asa Yelusalema ngbalina-a, yi de mbɨla me, nakpi kaka-a akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Abhomʉ-o, okpála bhende a abháka o bhʉ́ ndu doto na Yudaya-a, a ayo me u kpe ne apɨ́ ’ta. Obhende adʉ́ bhʉ́ Yelusalema-a, a ayo me u ze bhʉ́bhʉ́ maze. Obhende adʉ́ asangba gʉdhʉ-o, a ayo matá de me u lɨ abhʉ́ gʉdhʉ-o de. ");
INSERT INTO mdm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Padhá de, anga adʉ́ ekpɨ́ nakodho ’ngʉ́ gba Ebhe ngʉbula me ndʉ ’ngʉ́ hana ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e , amene lɨe. ");
INSERT INTO mdm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lɨ ’kpɨ́ ango-o, adʉ́ lɨkabhu na ngbéngbé pɨ olɨsɨ na ebhɨ di ne obhende lɨ ongɨsɨ adʉ́ andjɨ ’ka o-o. Padhá de, anga okpála na doto adjé lɨkabhu naali, lɨ mangɨmbo gba Ebhe-e súno lɨe pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","U abhíli okoko ne ombotɨa. U tsia mbá okoko bhʉ́ bali ne ndʉ bɨlɨ hana. Omʉpagano adédele Yelusalema ne ’dhʉ o akólo bha bini lɨ nedhɨnga gba uo andjía lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«U aú oengʉ́ na ngangamba bhʉ́la ela, bhʉ́la epe di ne bhʉ́la oɨkʉpala. Pɨ́la doto-o, bua okpála hana adʉ́ atɨ má ngbi ngbi ngbi ne tsʉlʉ ka tolo, di ne ka lɨ ’ngbé ’ngu adʉ́ adimba lɨe ko! ");
INSERT INTO mdm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Okpála amú ne tsʉlʉ ka nabhundja engʉ́ ɨnde akólo pɨ́la doto libhomu-o, anga ndʉ ’he na abhʉ́lá hana adyɨ́kɨ má djigi djigi! ");
INSERT INTO mdm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pɨpɨta-a, u tsia ú ma ngama, Ndɨlɨ gba kpála, me ma nde ngago bhʉ́ ndindi ne angu di ne asasaua gba ma-a hana. ");
INSERT INTO mdm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nedhɨnga lɨ ongʉ́ ango-o ahólo amene lɨe lɨe, yi de lʉ kpekpeke, amba yi ꞌe ’ndjɨ yi ne abhʉ́lá, anga ekpɨ́ lɨ Ebhe akóbho yi lɨe akolo masɨkpe.» ");
INSERT INTO mdm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pɨpɨta-a, Yesu atsia apa gbitaku ɨnde-e pɨ uo me: «Yi tsia nga ndula na figi di ne ondula koko hana. ");
INSERT INTO mdm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yi u me ’kpá ’kpá aholo nakɵ-o, yi mbɨla me gboko ’kpɨ́ akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A bhadi moko, nedhɨnga yi aú ongʉ́ bhomʉ-o lɨe ngakolo-o, yi de mbɨla me Naʉ gba Ebhe-e akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ma apa pɨ yi na paká me, ndʉ ’ngʉ́ bhomʉ-o hana akólo me okpála na nakɨ ɨnde-e nde mu nga ndʉ o hana de. ");
INSERT INTO mdm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ekpɨ́ ne doto akódho ’kpɨ́ makodho. Engʉ́ bini, ’li ma kódho ’kpɨ́ belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«ꞌE-e! Yi lila lɨyi uu! Yi adʉ́ abhundja bha engʉ́ na anokomɨa, ne engʉ́ nalangba ne pandɨ di ne ongangá ’ngʉ́ na doto ɨnde-e de. Ɨ dʉ mo-o, lɨ ekpɨ́ lɨ ngama, Ndɨlɨ gba kpála, ma agó lɨe, ɨ kólo lɨ yi bhʉ́ gbilikiti, ");
INSERT INTO mdm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","maka ekú ahoholo onʉ lɨe ko. Padhá de, anga ahólo okpála pɨ́la doto libhomu. ");
INSERT INTO mdm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yi alá-a de. Yi dʉ nayo Ebhe ndʉ nedhɨnga hana, ngʉbula me yi sia angu ngʉ́ nakpe ndʉ ’ngʉ́ ɨnde akólo hana, amba yi koto ngʉ́ nalʉ kala ma, Ndɨlɨ gba kpála-o.» ");
INSERT INTO mdm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ne ngbɨkpɨ-e, Yesu adʉ asuno bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Tagolo, anɨ atsia adʉ anʉ asɨ apɨ́ ’ta na ondula na Olive. ");
INSERT INTO mdm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndʉ okpála hana adʉ ago bhʉ́ sɨkɨkpɨ bhʉ́ ’ngbé ’tɨ Ebhe ngʉ́ nadje anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ekpɨ́ na anokomɨa na Pasɨka , ekpɨ́ ayo di lɨe me u zʉ mapa ɨnde lɨ levile nde bhʉ́ e ade-e, akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ongbengbe odimandɵ gba Ebhe di ne omʉsuno na lɨ́lɨ gba Moidje adʉ agɨlɨ kpadjɨ ngʉ́ nabhɵlɵ Yesu. Engʉ́ la bini, u adʉ adje tsʉlʉ ka okpála. ");
INSERT INTO mdm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pɨpɨta-a, Satana alɨ lɨ bua Yuda ɨnde u aꞌɨ e me Ɨsɨkaliote, sʉka obhʉlʉ titima ndjɨkpa ne ká bhisi gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Abhomʉ-o, anɨ anʉ nadje lɨe ne ongbengbe odimandɵ gba Ebhe di ne ongámásɨ gba okpála nalila ’ngbé ’tɨ Ebhe gba omaYuda. Anɨ anʉ nakpokpo ne uo maka anɨ apʉ́ Yesu lɨe pɨ uo ko. ");
INSERT INTO mdm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","U akpi djalɨ naali, u atsia adje lɨo sʉnda o me o há pɨ anɨ falanga. ");
INSERT INTO mdm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda azɨba. Anɨ atsia aholo agɨlɨ nedhɨnga na ndjɨndjɨ ngʉ́ napʉ Yesu pɨ uo me, okpála nde de uo ade. ");
INSERT INTO mdm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ekpɨ́ na anokomɨa nazʉ mapa ɨnde lɨ levile nde bhʉ́ e ade-e akolo. A adʉ di ekpɨ́ ɨnde ayo lɨe me u bhɵlɵ folo kandɵlɵ ngʉbula anokomɨa na Pasɨka-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu atima Piele ne Djaa . Anɨ pɨ uo me: «Yi nʉ leke ndʉ ’ngʉ́ hana pɨ nɨ́ ngʉ́ anokomɨa-o.» ");
INSERT INTO mdm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","U atsia ayi anɨ me: «Mo okʉnda me ya nʉ leke su?» ");
INSERT INTO mdm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Anɨ agie pɨ uo me: «Yi djedje, yi alɨ́ lɨe bhʉ́ Yelusalema-a, yi atʉ́ lɨyi ne bhoko bini me anɨ nde abɨ lʉsa ’ngu pɨ́ ’ndjɨ e. Yi kpata anɨ bhʉ́ etɨ ɨnde anɨ alɨ́ bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yi yi bhʉlʉ etɨ ango-o me: ‹Mʉsuno ngayi mʉ me, tɨna ’tɨ ɨnde ma azʉ́ anokomɨa ne omʉkpata gba ma-a bhʉ́ e ngae dho?› ");
INSERT INTO mdm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Anɨ asúno ’ngbé tɨna ’tɨ bhe na abhʉ́lá-a pɨ yi bini. Ndʉ ’he hana bhʉ́bhʉ́. Yi leke ehe na anokomɨa bhʉ́bhʉ́.» ");
INSERT INTO mdm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","U agbida, u abhaka ndʉ ’ngʉ́ hana maka lɨ Yesu apa lɨe ko. Abhomʉ-o, u atsia aleke ezʉ na anokomɨa-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lɨ nedhɨnga ango-o akolo lɨe, Yesu ne obhʉlʉ titima gba e atsia adʉlʉ kuto ngʉ́ nazʉ ’he-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Anɨ apa pɨ uo me: «Ma adʉ nako ne gʉmʉ naali me nɨ́ zʉ anokomɨa ɨnde-e ne yi bhʉ́ dabɨlɨ bini kala me ma dje lɨkabhu ko! ");
INSERT INTO mdm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Padhá de, anga ma apa pɨ yi me, ma zʉ́ matá-a de, akólo lɨ nedhɨnga ɨnde lɨ tata-a asúno lɨe lɨe bhʉ́ Naʉ gba Ebhe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Abhomʉ-o, anɨ aha kópo na vino-o, anɨ agie heni pɨ Ebhe. Anɨ atsia apa me: «Yi haha, amba yi ndjɨ ndʉ yi hana. ");
INSERT INTO mdm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma apa pɨ yi me, ma ndjɨ́ matá-a de akólo lɨ nedhɨnga ɨnde lɨ Naʉ gba Ebhe-e agó lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pɨpɨta-a, anɨ aha mapa-o, anɨ agie heni pɨ Ebhe. Anɨ agʉmʉ bhʉsʉ bhʉsʉ, anɨ aha pɨ uo. Anɨ atsia apa me: «A ɨnde-e kʉte ma ɨnde aha lɨe pɨ yi-o. Yi dʉ amemene moko, ngʉbula nabhundja ma.» ");
INSERT INTO mdm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pɨta u andjia nazʉ ’he bhomʉ-o lɨe, anɨ aha di kópo na vino-o pɨ uo, anɨ atsia apa me: «Vino ɨnde-e, a ko gandja na mbɨa lɨ Ebhe akodho e ne yi ne ngʉte ma ɨnde atuko pɨ yi-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Engʉ́ bini yi tsitsia, kpála ɨnde apʉ́ ma-a, anɨ ngazʉ ’he ne ma bhʉ́ dabɨlɨ bini sɨ! ");
INSERT INTO mdm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Padhá de, anga a ayo me ngama, Ndɨlɨ gba kpála-a, ma kpi maka lɨ Ebhe apa lɨe ko. Engʉ́ la bini, a ko lɨkabhu naali pɨ kpála ɨnde apʉ́ ma ko!» ");
INSERT INTO mdm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Abhomʉ-o, u atsia aholo ayi lɨo sʉnda o me, a ko kpála bhedho bhʉ́ ka o ɨnde ɨ tɨ́ da namene ’ngʉ́ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pɨpɨta-a, omʉkpata aholo amene kpekebhɵ sʉnda o ngʉ́ nambɨla me ane ne engbé bhʉ́ ká o da. ");
INSERT INTO mdm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu atsia apa pɨ uo me: «Ongbengbe ongámásɨ gba omʉpagano-o ngaha lɨ́lɨ pɨ okpála gba o-o. Obhende ngatsia ’kpɨ́ lɨ doto-o kʉnda me u ꞌɨ o me ‹Obabadha okpála.› ");
INSERT INTO mdm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pɨ yi-e, yi améne mo-o de. Engʉ́ bini, a ayo me kpála ɨnde ane ne engbé bhʉ́ ká yi-e dʉ maka mboye ndɨlɨ, amba kpála ɨnde ngatsia ’kpɨ́ lɨ okpála koko-o, dʉ naae maka kpála na kulu gba uo-o. ");
INSERT INTO mdm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Padhá de, anga ane ne engbé da, ne me a ko kpála ɨnde ngazʉ ’he? Ne me a ko kpála ɨnde ngamene kulu kulu-o. A ko kpála ɨnde ngazʉ ’he-e dɨ? La-a, ma bhʉ́ ká yi maka kpála na kulu gba okpála koko. ");
INSERT INTO mdm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ngayi obhʉlʉ titima gba ma-a, nɨ́ adʉ ne yi ndʉ ’kpɨ́ hana bhʉ́ nedhɨnga ɨnde ma adʉ adje lɨkabhu gba ma-a lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kaka-a, ma ahá Naʉ pɨ yi maka lɨ ’Dyɨ ma aha di mʉma lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Abhomʉ-o, yi azʉ́ ’he, yi tsia ndjɨ́ di vino ne ma bhʉ́ dabɨlɨ bini, ɨ dʉ me ma nde alɨ bhʉ́ Naʉ gba ma-o. Yi adʉ́lʉ di pɨ́ odabɨlɨ na ngámá ngʉ́ nakodho ’ngʉ́ gba opiga ndjɨkpa ne ká bhisi gba omaƗsalaele ko.» ");
INSERT INTO mdm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pɨpɨta-a, Ngámá Yesu atsia apa me: «Simo, Simo, djedje nga! Ebhe aha kpadjɨ pɨ Satana me anɨ pe yi maka u apepe mapʉnga lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Engʉ́ bini, ngama-a, ma ayo Ebhe ngʉ́ mʉ, amba mo oꞌó ká nabhuka gba mʉ-o de. Mo odjí matá bua mʉ lɨe, mʉ de ha di angu pɨ ondaise mʉ uu.» ");
INSERT INTO mdm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piele apa pɨ anɨ me: «Ngámá, ma bedhe me, abana ɨ dʉ nanʉ bhʉ́ tɨkpʉ di ne nakpi-e, nɨ́ nʉ́ ne mʉ bhʉ́ dabɨlɨ bini.» ");
INSERT INTO mdm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu agie pɨ anɨ me: «Piele, ma apa pɨ mʉ me, sukpe na nakɨ ɨnde-e, kala me engʉ ku ’gbá-a, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» ");
INSERT INTO mdm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pɨpɨta-a, anɨ atsia ayi uo me: «Nedhɨnga nako ma atima yi lɨe mandɨ tɨa-a, mandɨ gonia ne malɵkɵ-o, ehe bini aneke nako ka yi uu?» U agie me: «Ehe bini neke ka ya de.» ");
INSERT INTO mdm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Do anɨ pɨ uo me: «Mbɨa ɨnde-e, kpála bhende lɨ tɨa ne gonia nde ka e-e, a ayo me anɨ haha. Kpála bhende lɨ mbotɨa nde ka e ade-e, a ayo me anɨ tsɨndjɨ koti gba e-o, amba anɨ kala mbotɨa ne di. ");
INSERT INTO mdm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Padhá de, anga ma apa pɨ yi me, engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e me, ‹U ato anɨ bhʉ́ ká okpála na sisiti-e›, a ayo me amene lɨe lɨ kʉte ma. A moko, engʉ́ ɨnde atsia ma-a, a adji amene lɨe.» ");
INSERT INTO mdm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Omʉkpata atsia apa me: «Ngámá, a ka ya sɨ ne ombotɨa bhisi.» Anɨ atsia agie pɨ uo me: «A ale.» ");
INSERT INTO mdm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pɨpɨta-a, Yesu akoto. Anɨ anʉ apɨ́ eta na ondula na Olive maka anɨ adʉ amemene lɨe ko. Omʉkpata gba anɨ atsia akpata di anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","U akolo lɨe oo, anɨ atsia apa pɨ uo me: «Yi yo Ebhe, amba yi alɨ́ bhʉ́ nale de.» ");
INSERT INTO mdm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Anɨ ayie de uo, anɨ adyudyo mbo lɨe tsutsu masudha. Anɨ akikita lɨpʉkʉ e kuto, anɨ atsia ayo Ebhe me: ");
INSERT INTO mdm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«’Dyɨ ma, ɨ dʉ me mʉ nde akʉnda-a, mʉ de ꞌe lɨkabhu ɨnde-e de ma tsutsu. La-a, mo oméne maka ma akʉnda lɨe de, mene mangbo maka mo okʉnda lɨe ko.»  ");
INSERT INTO mdm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Abhomʉ-o, andjelu bini ayie abhʉ́lá, anɨ akoto lɨ anɨ, anɨ atsia aha angu pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Anɨ abedhe lɨe ne lɨkabhu-o, anɨ atsia aholo matá nayo Ebhe kpekpeke naali. Ngufo na kʉte anɨ akolo maka ngʉte, a atsia adʉ ayi kuto má ta ta ta! ");
INSERT INTO mdm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pɨta lɨ anɨ aꞌo nayo Ebhe lɨe, anɨ ayie bhʉ́lá, anɨ agie lɨe ade omʉkpata. Anɨ abhaka me u nde atuko ne ela ka lɨkabhu. ");
INSERT INTO mdm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Anɨ atsia apa pɨ uo me: «Yi atuko ne ela ka nɨ? Yi yie bhʉ́lá, amba yi yo Ebhe, ngʉbula me yi alɨ́ bhʉ́ nale de.» ");
INSERT INTO mdm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lɨ nedhɨnga lɨ Yesu adʉ apa ’ngʉ́ bhomʉ-o lɨe, Yuda sʉka obhʉlʉ titima ndjɨkpa ne ká bhisi-e ago ne bhiti okpála. Anɨ adyudyo lɨe de Yesu masɨkpe ngʉbula me nɨ nvʉ pabhɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Mʉ nganvʉ pabhɵ ma, Ndɨlɨ gba kpála, ngʉbula napʉ ma-a?» ");
INSERT INTO mdm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lɨ omʉkpata gba Yesu-o au engʉ́ ɨnde adji akódho ’kpɨ́-e lɨe, u atsia ayi Yesu me: «Ngámá, a la ya gʉ ne uo ne mbotɨa?» ");
INSERT INTO mdm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sʉka uo asʉ kpála na kulu gba bhele kpála gba odimandɵ gba Ebhe-o . Anɨ atsia akodho kpadje anɨ lɨ pápá na kokpa-a má tse! ");
INSERT INTO mdm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Engʉ́ bini, Yesu atsia apa me: «Yi ꞌoꞌo, a apise moko.» Anɨ aha kpadje kpála ango-o, anɨ aꞌo ’kpa e tété, anɨ atsia akobho anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pɨpɨta-a, Yesu atsia apa pɨ ongbengbe odimandɵ ne ongámásɨ gba omʉlila na ’ngbé ’tɨ Ebhe gba omaYuda, di ne obhelesɨ okpála ɨnde ago ngʉ́ naholo anɨ-e me: «Ka nɨ yi ago ngʉ́ ma lɨe ne ombotɨa, di ne ondula mʉgɨto me yi ago ngʉ́ naholo bhʉlʉ ’zi-e? ");
INSERT INTO mdm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nɨ́ adʉ nako ne yi ndʉ ’kpɨ́ hana bhʉ́ dabɨlɨ bini bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. La-a, yi holo ma de. Engʉ́ bini, nedhɨnga gba yi-e akolo, nedhɨnga gba ngámá na biti-o.» ");
INSERT INTO mdm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Abhomʉ-o, u aholo Yesu, u anʉ ato anɨ bhʉ́ ’tɨ gba bhele kpála gba odimandɵ gba Ebhe-o. Piele adʉ akpata uo mbo tsutsu. ");
INSERT INTO mdm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A abhaka me u nde akpo djua tʉ mbadhasʉ, okpála adʉlʉ dede. Piele atsia ago adʉ bhʉ́ ká uo. ");
INSERT INTO mdm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kpála na kulu bini na ɵɵlɵ au anɨ lɨ zɨ djua me anɨ nde adʉ kuto. Anɨ atsia Piele ne kpéke djila, anɨ me: «Kpála ɨnde-e dʉ di nako ne anɨ bhʉ́ dabɨlɨ bini!» ");
INSERT INTO mdm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Engʉ́ bini, Piele ayala, do anɨ de-e: «Ma ambɨla anɨ de, ɵlɵ-e.» ");
INSERT INTO mdm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pɨta nedhɨnga bedɨ-e, bhoko bini au anɨ, anɨ atsia apa me: «Ngamʉ di-e, mʉ ne sʉka okpála gba Yesu-o!» Engʉ́ bini, Piele atsia agie me: «Bhoko-e, ma ne sʉka uo ade.» ");
INSERT INTO mdm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pɨpɨta abhue mbo ngengele. Bhoko koko atsia azɨ kekele tété me: «A ko kʉkʉlʉ ’ngʉ́, kpála ɨnde-e dʉ nako ne Yesu bhʉ́ dabɨlɨ bini, anga a ko di kpála na Galilaya.» ");
INSERT INTO mdm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Engʉ́ bini, Piele agie pɨ bhoko ango-o me: «Bhoko-e, ma mbɨla ’ngʉ́ ɨnde mʉ ngapa e de.» Bha lɨ nedhɨnga ɨnde anɨ adʉ apapa lɨe, engʉ atsia aku ’gbá. ");
INSERT INTO mdm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ngámá Yesu adji bhʉ́la e, anɨ atsia bhʉ́la Piele. Abhomʉ-o, Piele atsia abhundja engʉ́ ɨnde lɨ ngámá Yesu apa ɨgɨnɨ e pɨ anɨ-o me: «Sukpe na nakɨ ɨnde-e, kala me engʉ ku ’gbá-a, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» ");
INSERT INTO mdm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piele akoto kilidjo, anɨ abhɵlɵ kuo e ne egbá má kusu! ");
INSERT INTO mdm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Okpála ɨnde adʉ alila Yesu-o aholo amʉ anɨ. U agbite djila anɨ. U aholo abhɨ anɨ. U atsia adʉ ayi anɨ me: «Aa! Ngamʉ, polofeta-a , pa nga pɨ ya me asʉ mʉ da!» ");
INSERT INTO mdm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","U asosobho anɨ. U atsia apa di ongʉ́ koko pɨ anɨ bhelé bhʉ́ osobho ɨnde u adʉ asosobho anɨ ne e ko. ");
INSERT INTO mdm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lɨ ekpɨ́ aseke lɨe, obhelesɨ okpála gba omaYuda apɵkɵbhɵ bhʉ́la o bhʉ́ dabɨlɨ bini ne ongbengbe odimandɵ gba Ebhe, di ne omʉsuno na lɨ́lɨ gba Moidje-o. U atsia agbe anɨ kala Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda-o . ");
INSERT INTO mdm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","U ayi anɨ me: «Ɨ dʉ me mʉ nde ne Masɨya-a , mʉ de pa pɨ ya.» Abhomʉ-o, anɨ agie pɨ uo me: «Ɨ dʉ me ma nde apa pɨ yi-e, yi bhúka de. ");
INSERT INTO mdm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɨ dʉ la di me ma nde ayi yi lɨ ’ngʉ́-o, yi gíe ’ngʉ́ mʉma tété de. ");
INSERT INTO mdm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nayie pɨ mbɨa ɨnde-e, ngama, Ndɨlɨ gba kpála-a, ma adʉ́ lɨ pápá na kokpa gba Ebhe na angu-o.» ");
INSERT INTO mdm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Abhomʉ-o, ndʉ uo hana atsia ayi me: «Bhobhomʉ-o apa me mʉ ne Ndɨlɨ gba Ebhe?» Anɨ agie pɨ uo me: «A maka yi apa lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Abhomʉ-o, u atsia apa me: «Nɨ́ matá ne gʉmʉ okpála koko ɨnde ɨ tɨ da napa engʉ́ ango-o pɨ nɨ́ ade, anga nɨ́ adje bha nganɨ́ makpe bhʉ́ ’li anɨ adje!» ");
INSERT INTO mdm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pɨpɨta-a, ndʉ okpála hana ɨnde adʉ bhʉ́ dá bula-a ayie bhʉ́lá, u atsia anʉ ne Yesu kala Pɨlatɵ, ngámá na Loma . ");
INSERT INTO mdm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Oo, u aholo apa lɨ Yesu me: «Ya abhaka kpála ɨnde-e me anɨ nde ngaha kpéke ’ndjɨ pɨ okpála gba ya-o. Anɨ nde ngayoko uo me u akala mandjandja gba Kaisala , ’ngbé ngámá na Loma-a de. Anɨ atsia adʉ apa di me nɨ ne Masɨya , akʉnda napa me ’ngbé ngámá.» ");
INSERT INTO mdm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pɨlatɵ ayi anɨ me: «Ngamʉ-o, mʉ ne ’ngbé ngámá gba omaYuda?» Yesu agie pɨ anɨ me: «Mo opa ngamʉ.» ");
INSERT INTO mdm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Abhomʉ-o, Pɨlatɵ atsia apa pɨ ongbengbe odimandɵ di ne bhiti okpála bhomʉ-o me: «Ma u engʉ́ bini ɨnde a ayo me u holo kpála ɨnde-e ngʉ́ e de.» ");
INSERT INTO mdm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Engʉ́ bini, u azɨ bha kekele tété me: «Bhʉ́ nasuno gba anɨ-e, anɨ ngaha kpéke ’ndjɨ pɨ okpála me u améne lɨ́lɨ gba ngámá-a de. Anɨ amene bhʉ́ doto gba omaYuda libhomu. Anɨ akpo bhʉ́ ndu doto na Galilaya. Mbɨa ɨnde-e, anɨ akolo ɨbili ne di ei.» ");
INSERT INTO mdm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lɨ Pɨlatɵ adje lɨe mo-o, anɨ atsia ayi me: «Kpála ɨnde-e, a ko kpála na Galilaya?» ");
INSERT INTO mdm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","U agie pɨ anɨ me: «A moko, a ko kpála na Galilaya.» Abhomʉ-o, lɨ Pɨlatɵ adje lɨe me Yesu ayie bhʉ́ ndu doto lɨ ngámá Elode adʉ alila e-e, anɨ atsia atima anɨ pɨ anɨ. Padhá de, anga bhʉ́ ekpɨ́ ango-o, Elode adʉ di bhʉ́ Yelusalema oo. ");
INSERT INTO mdm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elode akpi djalɨ naali lɨ anɨ au Yesu lɨe. Padhá de, anga nayie nanɨ didili naali, anɨ adʉ akʉnda me nɨ u Yesu ka engʉ́ gba anɨ ɨnde anɨ adʉ adje e-o. Anɨ atsia adʉ akʉnda nau anɨ me anɨ nde ngamene ngamba ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Anɨ ayiyi Yesu lɨ ongʉ́ bhelé. Engʉ́ bini, Yesu gie ’ngʉ́ pɨ anɨ tété belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ongbengbe odimandɵ di ne omʉsuno na lɨ́lɨ gba Moidje adʉ oo. U adʉ apa ’ngʉ́ lɨ kʉte anɨ sisiti naali. ");
INSERT INTO mdm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elode ne osʉdha gba e amʉ anɨ, u atsia asosobho di anɨ. Pɨpɨta-a, u adyɨ bádha bongo lɨ anɨ, u atsia agie anɨ pɨ Pɨlatɵ. ");
INSERT INTO mdm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kalanʉ-o, Elode ne Pɨlatɵ dʉ nadje lɨo de. Nayie lɨ ’kpɨ́ ango-o, u atsia akolo bhʉ́ makpolɨa. ");
INSERT INTO mdm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Abhomʉ-o, Pɨlatɵ apo bhʉ́la ongbengbe odimandɵ, ongámásɨ gba omaYuda di ne okpála. ");
INSERT INTO mdm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Anɨ atsia apa pɨ uo me: «Yi ago ne kpála ɨnde-e mʉma me anɨ ngaha kpéke ’ndjɨ pɨ okpála. La-a, ma ayi anɨ lɨ ’ngʉ́ ango-o kala yi sɨ, ma u anɨ ne siti ’ngʉ́ belegʉ de bini bhʉ́ ká ndʉ ’ngʉ́ hana ɨnde yi apa e lɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elode u di siti ’ngʉ́ ka anɨ de anga anɨ agie anɨ pɨ nɨ́ ei. A moko me kpála ɨnde-e mene siti ’ngʉ́ belegʉ de bini ɨnde u tɨ da nabhɵlɵ anɨ ka e ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaka-a, ma abhɨ́ anɨ ne fimbo, ma atsia tsé ’kpa lɨ anɨ.»  ");
INSERT INTO mdm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bhʉ́ ndʉ anokomɨa na Pasɨka hana, a ayo me Pɨlatɵ tse ’kpa lɨ kpála ɨnde u aholo e bhʉ́ tɨkpʉ-o pɨ uo bini. ");
INSERT INTO mdm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Engʉ́ bini, ndʉ uo hana aholo asʉsʉla bhʉ́ dabɨlɨ bini me: «Bhɵlɵ kpála bhomʉ-o mabhɵlɵ, amba mʉ tse ’kpa lɨ Balaba pɨ ya!» ");
INSERT INTO mdm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(U aholo nanɨ Balaba bhʉ́ tɨkpʉ anga anɨ agbe nanɨ kpéke ’ndjɨ abhʉ́ Yelusalema, anɨ atsia abhɵlɵ di kpála.) ");
INSERT INTO mdm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pɨlatɵ adʉ akʉnda natse ’kpa lɨ Yesu. Kaka-a, anɨ atsia ayi matá uo lɨ ’ngʉ́ ango-o ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Engʉ́ bini, u aholo bha nasʉsʉla me: «Gɨ anɨ lɨ kulusi! Gɨ anɨ lɨ kulusi!» ");
INSERT INTO mdm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bhʉtsibhʉtsi na bata-a, anɨ apa pɨ uo me: «Anɨ amene la mangua siti ’ngʉ́ dho? Ma u engʉ́ ɨnde anɨ amene e, u tɨ da nabhɵlɵ anɨ ka e de. Ma abhɨ́ bha anɨ ne fimbo, ma tsia tsé ’kpa lɨ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Engʉ́ bini, u azɨ bha kekele tété kpekpeke me, a ayo me u gɨ Yesu lɨ kulusi. U adʉ bha aꞌéꞌe ’li o ne bhʉ́lá, akolo lɨ nedhɨnga lɨ ’li uo aha angu Pɨlatɵ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Abhomʉ-o, Pɨlatɵ atsia azɨba namene maka u adʉ akʉkʉnda lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Anɨ atsia atse ’kpa lɨ kpála ɨnde u adʉ ayo e-o, kpála ɨnde u aholo e bhʉ́ tɨkpʉ-o. Padhá de, anga anɨ agbe kpéke ’ndjɨ, anɨ atsia abhɵlɵ di kpála. Engʉ́ bini, anɨ atsia aha Yesu pɨ uo me u mene ne anɨ maka u adʉ akʉkʉnda lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Lɨ osʉdha adʉ anʉ ne Yesu lɨe, u akɵ lɨo ne Simo, kpála na ndu doto na Silene, me anɨ nde ayie abhiye. U aholo anɨ, u atsia aꞌo kulusi gba Yesu-o lɨ ’ngbʉ anɨ me, anɨ bɨbɨ amba anɨ kpata Yesu ne di. ");
INSERT INTO mdm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Okpála bhelé adʉ akpata Yesu. Bhʉ́ ká uo-o, adʉ di ne olɨsɨ ɨnde adʉ aku ’gbá ne nalopolo lɨo ngʉ́ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu adji bhʉ́la e ne apɨ́ uo, anɨ atsia apa pɨ uo me: «Ngayi, olɨsɨ na Yelusalema-a, yi akú ’gbá ngʉ́ ma de! Engʉ́ bini, yi ku mangbo egbá ngʉ́ yi ne ongɨsɨ gba yi ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Padhá de, anga oekpɨ́ koko akólo makolo, oekpɨ́ ɨnde u apá lɨe me: ‹A ko djalɨ pɨ olɨsɨ ɨnde ɨ zu de, ɨnde ɨ bɨ ’bhɨ de, di ne obhende lɨ ongɨsɨ ndjɨ ’ka o de-o!› ");
INSERT INTO mdm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lɨ nedhɨnga bhomʉ-o, okpála ahólo napa pɨ ongbengbe ’ta me: ‹Yi buku ya!› U tsia pá pɨ odjedje ’ta me: ‹Yi wo ya!› ");
INSERT INTO mdm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Padhá de, anga ɨ dʉ me okpála nde amene ndula bhe na yiyi-e mo-o, u méne la ɨbili naae ndula bhe na keke-e pɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lɨ nedhɨnga bhomʉ-o, u anʉ di ne obhosɨ bhisi koko ɨnde amene sisiti ’ngʉ́ naali me u bhili uo bhʉ́ dabɨlɨ bini ne Yesu. ");
INSERT INTO mdm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","U akolo lɨ bɨlɨ ɨnde u aꞌɨ e me «Pelegendjɨ.» U atsia agɨ Yesu lɨ kulusi di ne okpála na sisiti bhisi-o, koko lɨ kulusi gba e lɨ pá ’kpa anɨ na kokpa, koko lɨ kulusi gba e lɨ pá ’kpa anɨ na galɨ. ");
INSERT INTO mdm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Abhomʉ-o, Yesu atsia apa me: «’Dyɨ ma, mbu lɨ siti ’ngʉ́ gba uo, anga u mbɨla engʉ́ ɨnde u ngamene e de.» Osʉdha agʉ gbanda ngʉ́ nagapa obongo gba anɨ-e lɨ o. ");
INSERT INTO mdm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Okpála adʉ oo, u adʉ atsia engʉ́ ɨnde adʉ akodho ’kpɨ́-o. Ongámásɨ gba omaYuda adʉ amʉ anɨ. U atsia adʉ apa me: «Anɨ akobho okpála koko. A ayo me anɨ kobho di lɨe ne tɨtɨ e, ɨ dʉ me anɨ nde ne Masɨya ɨnde lɨ Ebhe abhʉ e ko!» ");
INSERT INTO mdm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Osʉdha amʉ di anɨ. U adyudyo lɨo masɨkpe, u aha kpongadha pandɨ pɨ anɨ, u atsia apa me: ");
INSERT INTO mdm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ɨ dʉ me mʉ nde bha ndjʉ ne ’ngbé ngámá gba omaYuda-a, mʉ de kobho lɨmʉ ne tɨtɨ mʉ!» ");
INSERT INTO mdm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pɨ́ ’ndjɨ anɨ-e, u aye me: «A ɨnde-e ’ngbé ngámá gba omaYuda-o.» ");
INSERT INTO mdm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sʉka okpála na sisiti ɨnde u agɨ o lɨ kulusi adʉ asobho anɨ me: «Mʉ ne Masɨya adɨ? Kobho lɨmʉ ne tɨtɨ mʉ, amba mʉ kobho di ya!» ");
INSERT INTO mdm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Engʉ́ bini, bhe koko ambe bhʉ́ ’ndjɨ anɨ, do anɨ de-e: «Mʉ kpe Ebhe dɨ, ngamʉ ɨnde ngasia bhadi lɨkabhu maka anɨ-e? ");
INSERT INTO mdm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pɨ nɨ́-e, a lɨ lɨkabhu gba nɨ́-e ne tata, anga nɨ́ ngasia bhomʉ-o mbini kulu gba nɨ́ ko. La-a, ngaanɨ-e, anɨ mene naae siti ’ngʉ́ belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pɨpɨta-a, anɨ atsia apa pɨ Yesu me: «Bhundja ma uu, lɨ nedhɨnga ɨnde mo ogó lɨe ngʉ́ naʉ ngámá gba mʉ ko.» ");
INSERT INTO mdm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu agie pɨ anɨ me: «Ma apa pɨ mʉ na paká me, nakɨ-e, nɨ́ adʉ́ ne mʉ bhʉ́ dabɨlɨ bini bhʉ́ kʉtɨ na mʉndeyi ko.» ");
INSERT INTO mdm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A akolo masɨkpe de tulukpe, ela aꞌo nasʉ. Biti aha pɨ́la doto libhomu akolo lɨ saa na bata pɨta tulukpe. ");
INSERT INTO mdm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","’Ngbé ’kpá bongo ɨnde adʉ agbo bhʉsʉ ’ngbé ’tɨ Ebhe gba omaYuda asidha bhʉsʉ e tʉtʉ má tsʉe! ");
INSERT INTO mdm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Abhomʉ-o, Yesu atsia asʉla kpekpeke me: «’Dyɨ ma, ma ngaꞌo bua ma sa ’kpa mʉ.» Pɨta anɨ apa engʉ́ bhomʉ-o lɨe, anɨ atsia andala ’kpa lɨ bua e. ");
INSERT INTO mdm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lɨ ngámá gba osʉdha na Loma au engʉ́ ɨnde akodho ’kpɨ́-e lɨe, anɨ atsia adʉ adhɵgɵ Ebhe me: «A ko paká me kpála ɨnde-e bha ndjʉ nako ne kpála na ngbingbili !» ");
INSERT INTO mdm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndʉ okpála hana ɨnde ago apo bhʉ́la o ngʉ́ natsia engʉ́ ango-o, au engʉ́ ɨnde akodho ’kpɨ́-o. U atsia adʉ agie lɨo agba o me u nde abubu ’kpa o pɨ́ ’ka o ka lɨkabhu. ");
INSERT INTO mdm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndʉ obɨ Yesu hana di ne olɨsɨ ɨnde adhʉkʉ ne anɨ bhʉ́ dabɨlɨ bini nayie bhʉ́ Galilaya-a, alʉlʉ mbo tsutsu. U adʉ natsia engʉ́ ɨnde adʉ akodho ’kpɨ́ ko. ");
INSERT INTO mdm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kpála bini adʉ nanɨ oo. A adʉ ’lɨ anɨ me Djodjefʉ , kpála na Alimaté, sʉka gʉdhʉ gba omaYuda. A ko nanɨ kpála na babadha ɨnde adʉ di ngbingbili. Anɨ adʉ nanɨ nadjeke nago ka Naʉ gba Ebhe pɨ́la doto. A ko nanɨ sʉka Libi okpála natsia ’kpɨ́ lɨ ongʉ́ gba omaYuda-o. Engʉ́ bini, anɨ dʉ azɨba engʉ́ ɨnde lɨ Libi okpála natsia ’kpɨ́ lɨ ongʉ́ gba omaYuda adʉ abhundja e di ne namene e lɨ Yesu-o de. ");
INSERT INTO mdm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Anɨ anʉ abhaka Pɨlatɵ, anɨ atsia ayo kuo Yesu ka anɨ. Pɨlatɵ azɨba. ");
INSERT INTO mdm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pɨpɨta-a, anɨ atsia aꞌe kuo anɨ lɨ kulusi-o. Anɨ agagala ne bongo. Anɨ atsia ato bhʉ́ lata ɨnde u adjɨ e bhʉ́ teme, lata ɨnde u zɨ nga kpála bhʉ́ e kalanʉ de. ");
INSERT INTO mdm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A adʉ nanɨ ’kpɨ́ kulu bhuluvue, masɨkpe de ekpɨ́ naguo . ");
INSERT INTO mdm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Olɨsɨ ɨnde ayie nanɨ ne Yesu bhʉ́ Galilaya-a, anʉ bhʉ́ dabɨlɨ bini ne Djodjefʉ. U atsia lata-o, u au maka u aꞌo kuo Yesu lɨe bhʉ́bhʉ́-o. ");
INSERT INTO mdm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pɨpɨta-a, u agie lɨo agba o. U atsia aleke emʉ, di ne mʉngotsi ngʉbula me sidi-e, u nʉ pulu kʉte kuo-o ne di. Lɨ ’kpɨ́ naguo-o, u atsia aguo maka lɨ lɨ́lɨ apa lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bhʉ́ ’kpɨ́ yinga kɵkpɨ́ má bhɵ́-o, olɨsɨ aha mʉngotsi ɨnde u agɨlɨ e-o, u atsia agbida abhʉ́ lata. ");
INSERT INTO mdm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","U abhaka me teme nde awawala lɨ ’bhɵ lata-a awawala. ");
INSERT INTO mdm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","U alɨ lɨe, u bhaka kuo Ngámá Yesu de. ");
INSERT INTO mdm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nedhɨnga u adʉ akɨaka lɨe ka ’ngʉ́ ango-o, kolo me-e okpála bhisi aze lɨ uo. Okpála ango-o adyɨdyɨ bubu bongo má tuu tuu! ");
INSERT INTO mdm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","U adʉ la lɨe ne tsʉlʉ naali-e, u atʉtʉ bhʉ́la o ne kuto. Okpála ango-o atsia apa pɨ uo me: «Yi ngagɨlɨ kpála ɨnde ʉʉ-o bhʉ́ ká okpála ɨnde amu-o ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Anɨ sɨɨ ade. Engʉ́ bini, anɨ azuku. Yi bhundja engʉ́ nako anɨ apa e pɨ yi lɨ nedhɨnga ɨnde anɨ adʉ nga bha lɨe bhʉ́ Galilaya me: ");
INSERT INTO mdm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹A ayo me u pʉ ma, Ndɨlɨ gba kpála, pɨ okpála na sisiti. U gɨ ma lɨ kulusi, amba bhʉ́ ’kpɨ́ na bata-a, ma tsia zuku.›» ");
INSERT INTO mdm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Abhomʉ-o, u atsia abhundja ’li anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","U ayie bhʉ́ lata-o. U atsia anʉ nakpokpo ndʉ ’ngʉ́ bhomʉ-o hana pɨ obhʉlʉ titima ndjɨkpa ne ká bini, di ne ndʉ obhende adʉ ne uo bhʉ́ dabɨlɨ bini-e hana. ");
INSERT INTO mdm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Olɨsɨ ango-o, adʉ nanɨ Malɨa , kpála na gʉdhʉ na Magadala, Djaanɨ ne Malɨa , ’hi Djakɨ. Ngauo ne olɨsɨ koko ɨnde adʉ bhʉ́ dabɨlɨ bini ne uo akpokpo pɨ obhʉlʉ titima gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Engʉ́ bini, obhʉlʉ titima abhundja naao me, engʉ́ ɨnde lɨ olɨsɨ akpokpo e-e, a ko engʉ́ na ngingi. Kaka-a, u tsia bhuka de. ");
INSERT INTO mdm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Engʉ́ bini, Piele ayie bhʉ́lá, anɨ anʉ ne holo abhʉ́ lata. Anɨ akolo lɨe oo, anɨ akita ne kuto, anɨ atsia ’kpɨ́, anɨ au bha bongo ɨnde u agagala kuo ne e ko. Pɨpɨta-a, anɨ agie lɨe agba e me anɨ nde ngangamba naali ka engʉ́ ɨnde akodho ’kpɨ́ ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Bha lɨ ’kpɨ́ ango-o, omʉkpata bhisi adʉ anʉ bhʉ́ kʉtɨ bini ɨnde u aꞌɨ e me Emausɨ. Kʉtɨ ango-o adʉ de Yelusalema tsutsu, masɨkpe de kilometele ndjɨkpa ne ká bini. ");
INSERT INTO mdm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","U adʉ akpokpo ’ngʉ́ sʉnda o pɨndjɨ ndʉ ’ngʉ́ hana ɨnde akodho ’kpɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nedhɨnga uo adʉ akpokpo ’ngʉ́ di ne namene kpekebhɵ lɨe sʉnda o-o, ngaanɨ Yesu makpe, anɨ adyudyo lɨe de uo masɨkpe. Anɨ atsia aholo ’nʉ́ ne uo bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","U adʉ au anɨ, engʉ́ bini, ehe bini adʉ amene me u ambɨ́la anɨ de. ");
INSERT INTO mdm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Anɨ ayi uo me: «A ko mangua ’ngʉ́ dho yi adji ne kpokpo e sʉnda yi me-e?» Abhomʉ-o, u alʉ, u atsia abedhe ne lɨkabhu bedhe. ");
INSERT INTO mdm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sʉka uo bini ɨnde adʉ ’lɨ e me Keleopasɨ apa pɨ anɨ me: «Bhʉ́ ká ogomago na Yelusalema libhomu-o, engʉ́ ɨnde akodho ’kpɨ́ sʉnda okpɨ́ ɨnde-e, mʉ mbɨla bha de ngamʉ kpi mʉ kpi?» ");
INSERT INTO mdm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Anɨ ayi uo me: «Mangua ’ngʉ́ dho?» U atsia agie pɨ anɨ me: «Engʉ́ ɨnde akolo lɨ Yesu, kpála na Nadjaleta! A ko nako polofeta kʉkʉlʉ. Ongʉ́ ɨnde anɨ amene e ne bhende anɨ asuno e, anɨ amene ndʉndʉ hana ne angu. Anɨ atsia asuno ongʉ́ ango-o kala Ebhe di ne kala ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","La-a, ongbengbe odimandɵ gba Ebhe di ne ongámásɨ gba nɨ́-e, apʉ anɨ me u bhɵlɵ anɨ. U atsia agɨ anɨ lɨ kulusi. ");
INSERT INTO mdm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","La-a, ya adʉ nako ne ’to ya naaya me, a ko kpála ɨnde agbégbe Ɨsalaele bhʉ́ bali-o. Engʉ́ bini, a ane nakɨ ekpɨ́ bata maka lɨ oengʉ́ ango-o akodho ’kpɨ́ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","La matá di-e, ya angamba ka olɨsɨ koko bhʉ́ ka ya naali. U anʉ ɨgɨnɨ bhʉ́ sɨkɨkpɨ abhʉ́ lata. ");
INSERT INTO mdm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Engʉ́ bini, u u kuo anɨ de. U agie lɨo, u apa pɨ ya me oandjelu aze lɨo. Oandjelu atsia apa pɨ o me anɨ ʉʉ. ");
INSERT INTO mdm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pɨpɨta-a, okpála koko bhʉ́ ká ya anʉ abhʉ́ lata, u atsia abhaka ndʉ ’ngʉ́ hana maka lɨ olɨsɨ akpokpo lɨe ko. Engʉ́ bini, ngaanɨ makpe-e, u u anɨ de.» ");
INSERT INTO mdm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Yi ne ongingi! Ka nɨ yi ngabhuka lɨe má gala ade ndʉ ’ngʉ́ hana ɨnde lɨ opolofeta-a apa e! ");
INSERT INTO mdm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A ayo nako de me Kilisito dje lɨkabhu kala me anɨ lɨ bhʉ́ naʉ na asasaua gba e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pɨpɨta-a, anɨ aholo nakpokpo ndʉ ’ngʉ́ hana ɨnde u apa e pɨndjɨ anɨ bhʉ́ oBhuku gba Ebhe-e pɨ uo. Anɨ akpokpo nayie bhʉ́ obhuku gba Moidje akólo bhʉ́ obhuku gba ndʉ opolofeta-a hana. ");
INSERT INTO mdm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","U akolo lɨe de kʉtɨ ɨnde u adʉ anʉ bhʉ́ e masɨkpe-e, Yesu amene mʉgɨto me nɨ adji tsutsu. ");
INSERT INTO mdm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Engʉ́ bini, u atsia apa pɨ anɨ me: «Nɨ́ sɨ ne yi sɨ, anga ekpɨ́ asegele, biti la di ngago.» Anɨ atsia alɨ ngʉ́ nasɨ bhʉ́ dabɨlɨ bini ne uo oo ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nedhɨnga anɨ adʉ azʉ ’he lɨe bhʉ́ dabɨlɨ bini ne uo-o, anɨ aha mapa, anɨ agie heni pɨ Ebhe. Pɨpɨta-a, anɨ agʉmʉ mapa-o, anɨ atsia aha pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Abhomʉ-o, djila uo abhulu, u atsia ambɨla anɨ. Engʉ́ bini, anɨ angɨta bha kolo bhʉ́ djila uo má pele! ");
INSERT INTO mdm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","U atsia aholo nayi lɨo sʉnda o me: «Lɨ nedhɨnga ɨnde anɨ adʉ akpokpo ’ngʉ́ di ne nasuno ta eli gba Ebhe lɨe pɨ nɨ́ lɨ kpadjɨ-e, bua nɨ́ bedhe ɨgɨnɨ bhʉ́ nɨ́ ne djalɨ bedhe dɨ?» ");
INSERT INTO mdm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bha lɨ nedhɨnga bhomʉ-o, u ayie bhʉ́lá kolo má gala, u atsia agie lɨo abhʉ́ Yelusalema. Oo, u abhaka me obhʉlʉ titima ndjɨkpa ne ká bini-e nde apo bhʉ́la o ne obɨ o-o bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","U atsia apa pɨ obhe bhisi bhomʉ-o me: «Ngámá azuku na kʉkʉlʉ! Simo au anɨ!» ");
INSERT INTO mdm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pɨpɨta-a, omʉkpata bhe bhisi-e atsia akpokpo ’ngʉ́ ɨnde akodho ’kpɨ́ lɨ kpadjɨ-e pɨ uo, di ne maka u ambɨla Yesu lɨe lɨ nedhɨnga anɨ agʉmʉ mapa lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lɨ nedhɨnga u adʉ nga bha lɨe nakpokpo ’ngʉ́ ango-o, Yesu atsia alʉ bhʉ́ ká uo. Do anɨ pɨ uo me: «Guo ’ngʉ́ dʉ bhʉ́ dabɨlɨ bini ne yi!» ");
INSERT INTO mdm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","U adje tsʉlʉ naali, u atsia aholo agʉkʉ, anga u adʉ abhundja me o ou ɨgbadyɨbhe. ");
INSERT INTO mdm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Engʉ́ bini, Yesu atsia apa pɨ uo me: «Yi ngadje tsʉlʉ ka nɨ? Yi ne bua na bhisi bhisi ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yi tsia nga ’kpa ma di ne ’dhʉ ma, a ko bha ma makpe. Yi tana nga kʉte ma, amba yi u, anga mbɨlɨka ne bɨkɨ lɨ ɨgbadyɨbhe ade maka yi ngau ma lɨe ne di ko.» ");
INSERT INTO mdm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Anɨ apa engʉ́ bhomʉ-o lɨe, anɨ atsia asuno ’kpa e di ne ’dhʉ e pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lɨ djalɨ di ne nangamba aha angu uo lɨe naali-e, u tsia bhuka ngaɨza de. Anɨ atsia ayi uo me: «Mbo ’he nazʉ mazʉ ka yi sɨ uu?» ");
INSERT INTO mdm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","U atsia aha ndu sungu ɨnde u azɨ e mazɨ-e pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Anɨ aha, anɨ atsia azʉ lɨ djila uo oo. ");
INSERT INTO mdm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pɨpɨta-a, anɨ pɨ uo me: «Ma apa nako pɨ yi ndjɨndjɨ nedhɨnga nɨ́ adʉ nga bha lɨe bhʉ́ dabɨlɨ bini-e me, a ayo me ndʉ ’ngʉ́ hana ɨnde u aye e pɨndjɨ ma bhʉ́ lɨ́lɨ gba Moidje , bhʉ́ obhuku gba opolofeta di ne bhʉ́ bhuku na oetsi gba nɨ́-e, amene lɨe.» ");
INSERT INTO mdm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pɨpɨta-a, anɨ atsia abhulu ɨmbɨlangʉ gba uo ngʉbula me u mbɨla ta engʉ́ ɨnde u aye e bhʉ́ oBhuku gba Ebhe ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Anɨ atsia apa pɨ uo me: «Maka u aye lɨe bhʉ́ oBhuku gba Ebhe-e me, a ayo me Kilisito dje lɨkabhu, amba anɨ tsia zuku bhʉ́ ’kpɨ́ na bata. ");
INSERT INTO mdm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A ayo me okpála kpokpo ’ngʉ́ gba anɨ-e pɨ ndʉ okpála hana pɨ́la doto libhomu. U akpókpo nayie bhʉ́ Yelusalema me okpála dji bua o, amba Ebhe ꞌe siti ’ngʉ́ gba uo ko. ");
INSERT INTO mdm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yi au engʉ́ ɨnde akodho ’kpɨ́-e ne djila yi makpe. ");
INSERT INTO mdm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngama-a, ma atíma pɨ yi bhende lɨ ’Dyɨ ma apa me nɨ atíma e-o. Kaka-a, yi dʉ bha bhʉ́ gʉdhʉ sɨ akólo lɨ ’kpɨ́ ɨnde lɨ Ebhe atíma angu pɨ yi lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pɨpɨta-a, Yesu anʉ ne omʉkpata gba e masɨkpe de kʉtɨ na Betanɨa. U akolo lɨe oo, anɨ aꞌe ’kpa e, anɨ atsia atuko bisagu pɨ́ uo. ");
INSERT INTO mdm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lɨ nedhɨnga anɨ adʉ atuko bisagu pɨ́ uo lɨe, anɨ ayie bhʉ́ ká uo. Ebhe atsia aha anɨ abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ngauo-o, u adhɵgɵ anɨ. Pɨpɨta-a, u atsia agie lɨo abhʉ́ Yelusalema me u nde abedhe ne djalɨ bedhe. ");
INSERT INTO mdm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ndʉ ’kpɨ́ hana, u adʉ nadʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda ngʉ́ nadhɵgɵ Ebhe.");
INSERT INTO mdm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nayie lɨ lilita-a, Eli adʉ nanɨ uu. Eli ango-o adʉ nanɨ bhʉ́ dabɨlɨ bini ne Ebhe. La di-e, Eli ango-o a adʉ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nayie lɨ lilita-a, Eli ango-o adʉ nanɨ bhʉ́ dabɨlɨ bini ne Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ebhe atsia abho ndʉ ’he hana ne Eli ango-o. Ehe bini ɨnde amene lɨe mandɨ anɨ ade. ");
INSERT INTO mdm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mʉkobho akoto bhʉ́ Eli ango-o. Mʉkobho ango-o atsia adʉ zɨ ’kpɨ́ pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Zɨ ’kpɨ́ ngaziga bɨlɨ bhʉ́ biti. Engʉ́ la bini, biti ha angu zɨ ’kpɨ́ ango-o de. ");
INSERT INTO mdm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ebhe atima kpála bini. A adʉ ’lɨ kpála ango-o me Djaa . ");
INSERT INTO mdm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Anɨ ago maka kpála nakpokpo ’ngʉ́. Anɨ atsia akpokpo ’ngʉ́ mbámbá pɨndjɨ zɨ ’kpɨ́-o, amba ndʉ okpála hana bhuka ka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ngaanɨ makpe-e, anɨ dʉ nanɨ zɨ ’kpɨ́ de. Engʉ́ bini, anɨ ago nanɨ ngʉ́ nakpokpo ’ngʉ́ pɨndjɨ zɨ ’kpɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Zɨ ’kpɨ́ ango-o, a ko nanɨ zɨ ’kpɨ́ na kʉkʉlʉ. A ago pɨ́la doto, a ngaziga ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Eli-e adʉ nanɨ pɨ́la doto. Ebhe atsia abho ndʉ ’he hana ne di. La-a, okpála na pɨ́la doto tsia mbɨla anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eli-e ago nanɨ bhʉ́ ká omaha e. Engʉ́ bini, omaha anɨ tsia sia anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","La-a, okpála koko asia anɨ, u atsia abhuka di anɨ. Abhomʉ-o, anɨ atsia aha angu pɨ uo me u kolo ongɨsɨ gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","U kolo ongɨsɨ gba Ebhe lɨ kpadjɨ bhende maka u azuzu okpála na doto lɨe de. A ko la di ka gʉmʉ gba bhoko bini de. Engʉ́ bini, ayie ka Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eli-e adji lɨe, atsia akolo kpála. Anɨ adʉ nanɨ bhʉ́ ká nɨ́. Nɨ́ au sangu gba anɨ, sangu ɨnde anɨ asia e ka ’Dyɨ e-o. A ko sangu gba koli Ndɨlɨ bini, ɨnde abedhe ne bádha bua di ne ngbili ’ngʉ́ . ");
INSERT INTO mdm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Djaa akpokpo ’ngʉ́ pɨndjɨ anɨ mbámbá. Anɨ atsia asʉla me: «Engʉ́ nanɨ ma apa e me: ‹Kpála ɨnde ngago pɨta ma-a, anɨ ane ma mane. Padhá de, anga nanɨ me ma nde nga ade-e, anɨ adʉ bha naae uu.› Ma apa nanɨ engʉ́ ango-o pɨndjɨ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Abhomʉ-o, bhʉ́ bádha bua gba anɨ ɨnde bedhe-e, ndʉ nɨ́ hana nɨ́ atsia asia bádha bua pɨ́ bádha bua koko. ");
INSERT INTO mdm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Padhá de, anga nɨ́ asia lɨ́lɨ sa ’kpa Moidje . La-a, bádha bua di ne ngbili ’ngʉ́-o, nɨ́ asia ka Yesu Kilisito . ");
INSERT INTO mdm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kpála bini u Ebhe belegʉ de bini. La-a, koli Ndɨlɨ bini ɨnde di Ebhe, ɨnde ngadʉ de ’Dyɨ e-e, asuno anɨ pɨ nɨ́ ngae. ");
INSERT INTO mdm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A ɨnde-e engʉ́ lɨ Djaa akpokpo e, nedhɨnga lɨ ongámásɨ gba omaYuda na Yelusalema atima odimandɵ di ne okpála na piga gba Levi lɨe agba anɨ-o. U atima uo ngʉ́ nayi anɨ me: «Mʉ ne da?» ");
INSERT INTO mdm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Anɨ yala nagie engʉ́ tété de. Anɨ apa mbámbá me: «Ngama-a, ma ne Masɨya ade.» ");
INSERT INTO mdm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","U atsia ayi anɨ me: «Mʉ la ne da? Mʉ ne Elɨya?» Djaa agie me: «Ma ne anɨ ade.» U ayi anɨ me: «Mʉ ne polofeta ɨnde ya ngadjeke e?» Anɨ agie me: «Ma ne polofeta ade.» ");
INSERT INTO mdm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Abhomʉ-o, u atsia apa pɨ anɨ me: «Mʉ la naamʉ ne da? Padhá de, anga a ayo me ya gie engʉ́ tété pɨ okpála ɨnde atima ya ko. Ngamʉ makpe-e, mʉ ngapa lɨ ’ngʉ́ gba mʉ-o pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Djaa agie me: «Ma ne kpála ɨnde ngatotobhɨla bhʉ́ ’gʉ me, ‹Yi leke kpadjɨ ngbingbili pɨ Ngámá.›» (A bhomʉ-o engʉ́ ɨnde lɨ polofeta Ɨsaya apa nanɨ e-o). ");
INSERT INTO mdm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Okpála ɨnde u atima o agba Djaa, a adʉ nanɨ omʉFalisai . ");
INSERT INTO mdm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","U ayi anɨ me: «Mʉ ne Masɨya ade. Mʉ ne Elɨya ade. Mʉ ne polofeta ɨnde ya ngadjeke e ade. Mʉ la ngabatisa okpála ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Djaa agie pɨ uo me: «Ngama-a, ma ngabatisa okpála ne engu. La-a, kpála bini bhʉ́ ká yi, ɨnde yi mbɨla e de. ");
INSERT INTO mdm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Anɨ ngago pɨta ma. Ma belegʉ ne tetele kpála ade ngʉbula me ma bhulu ekpʉ́ na malɵkɵ gba anɨ-o.» ");
INSERT INTO mdm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Engʉ́ bhomʉ-o akodho ’kpɨ́ bhʉ́ kʉtɨ na Betanɨa, ayi ’ngu na Djʉlʉdanɨ lɨ bɨlɨ ɨnde lɨ Djaa adʉ abatisa okpála lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lɨ ekpɨ́ aseke lɨe, Djaa au Yesu me anɨ nde ngago lɨ pápá ɨnde anɨ adʉ lɨ e-o. Anɨ atsia apa me: «Yi tsia nga Ndɨlɨ Kandɵlɵ gba Ebhe-o. Anɨ ngaꞌe siti ’ngʉ́ pɨ́la doto ngae. ");
INSERT INTO mdm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Engʉ́ ɨnde ma akpokpo e, ma akpokpo pɨndjɨ anɨ, engʉ́ ɨnde me: ‹Kpála bini ngago pɨta ma. La-a, anɨ ane ma mane. Padhá de, anga anɨ adʉ nanɨ mʉma kalanʉ.› ");
INSERT INTO mdm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma dʉ ambɨla anɨ de. Engʉ́ bini, ma ago nabatisa okpála ne engu, ngʉbula me Ebhe suno anɨ pɨ omaƗsalaele.» ");
INSERT INTO mdm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Djaa akpokpo matá engʉ́ gba anɨ-e me: «Ma au Bua gba Ebhe-e ngayie ne abhʉ́lá, maka bɵbhɵ, atsia adʉ pɨ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ma dʉ ambɨla anɨ de. Engʉ́ bini, Ebhe ɨnde atima ma ngʉ́ nabatisa okpála ne engu-o, apa mʉma me: ‹Mo oú Bua gba Ebhe-e ngakɵ, ɨ tsia dʉ́ pɨ́ kpála bini. A bhomʉ-o kpála ɨnde abátisa okpála ne Bu Bhobua ko.› ");
INSERT INTO mdm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngama-a, ma au, ma atsia akpokpo la di ’ngʉ́ mbámbá me kpála ɨnde-e, a ko Ndɨlɨ gba Ebhe!» ");
INSERT INTO mdm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lɨ ekpɨ́ aseke lɨe, Djaa adʉ ago matá oo bhʉ́ dabɨlɨ bini ne omʉkpata gba e bhisi. ");
INSERT INTO mdm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nedhɨnga anɨ au Yesu lɨe ngakodho ’kpɨ́-e, anɨ atsia apa me: «Yi tsia nga Ndɨlɨ Kandɵlɵ gba Ebhe-o.» ");
INSERT INTO mdm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lɨ omʉkpata gba anɨ bhisi-e adje anɨ lɨe ngapa ’ngʉ́ bhomʉ-o, u atsia akpata Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu adji lɨe. Anɨ au me u adʉ akpata nɨ, anɨ atsia ayi uo me: «Yi ngagɨlɨ nɨ?» U agie pɨ anɨ me: «Labi, mʉ ngadʉ su?» (Labi akʉnda napa me Mʉsuno.) ");
INSERT INTO mdm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu agie pɨ uo me: «Yi gógo amba yi u.» (A adʉ nanɨ masɨkpe de saa na badha pɨta tulukpe.) U anʉ, u atsia au bɨlɨ ɨnde anɨ adʉ nadʉ lɨ e ko. Lɨ ’kpɨ́ ango-o, u atsia adʉlʉ ne uo bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andɨlɨ, ndai Simo Piele, nanɨ ne sʉka omʉkpata bhisi ɨnde adje engʉ́ lɨ Djaa apa e-e, atsia akpata Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andɨlɨ abhaka ngaɨza kalanʉ hana-a ndai e makpe Simo. Anɨ atsia apa pɨ anɨ me: «Ya au Masɨya au.» (A akʉnda napa me Kilisito.) ");
INSERT INTO mdm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anɨ anʉ ne Simo agba Yesu. Yesu atsia anɨ, anɨ atsia apa me: «Ngamʉ-o, mʉ ne Simo, ndɨlɨ gba Djaa . U adʉ́ aꞌɨ mʉ me Sefasɨ.» (ꞌƗlɨ ango-o akʉnda napa me Piele.) ");
INSERT INTO mdm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lɨ ekpɨ́ aseke lɨe, Yesu akʉnda nanʉ bhʉ́ ndu doto na Galilaya. Anɨ abhaka Filipo, anɨ atsia apa pɨ anɨ me: «Kpata ma.» ");
INSERT INTO mdm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filipo nanɨ ne kpála na gʉdhʉ na Betesaida, gʉdhʉ ɨnde lɨ Andɨlɨ ngauo ne Piele ayie bhʉ́ e-o.) ");
INSERT INTO mdm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pɨpɨta-a, Filipo abhaka Natanaele. Anɨ apa pɨ anɨ me: «Ya au kpála ɨnde lɨ Moidje aye nanɨ engʉ́ gba e bhʉ́ bhuku na lɨ́lɨ-o, lɨ opolofeta akpokpo di nanɨ engʉ́ gba e-o. A ko Yesu, ndɨlɨ gba Djodjefʉ , kpála na gʉdhʉ na Nadjaleta.» ");
INSERT INTO mdm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaele ayi anɨ me: «Ehe na ndjɨndjɨ tɨ da nayie bhʉ́ kʉtɨ na Nadjaleta uu?» Filipo agie pɨ anɨ me: «Gogo, amba mʉ u.» ");
INSERT INTO mdm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Lɨ Yesu au Natanaele lɨe ngago lɨ pápá gba e, anɨ atsia apa lɨ ’ngʉ́ gba anɨ-e me: «Yi tsia nga kʉkʉlʉ maƗsalaele ɨnde. Pʉlʉ ’ngʉ́ bhʉ́ anɨ belegʉ ade bini.» ");
INSERT INTO mdm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaele ayi anɨ me: «Mo ombɨla ma lele pɨ?» Yesu agie pɨ anɨ me: «Ma au mʉ nedhɨnga mo odʉ lɨe sa ndula na figi , kala me Filipo ꞌɨ mʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Abhomʉ-o, Natanaele atsia apa pɨ anɨ me: «Labi, ngamʉ-o, mʉ ne Ndɨlɨ gba Ebhe! Mʉ ne ’ngbé Ngámá gba omaƗsalaele!» ");
INSERT INTO mdm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu apa pɨ anɨ me: «Mo obhuka, anga ma apa pɨ mʉ me ma au mʉ sa ndula na figi? Mo oú ongʉ́ na ngbengbengbe ane bhobhomʉ-o mane!» ");
INSERT INTO mdm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu atsia apa matá me: «Ma apa pɨ yi na paká me yi aú kokpɨ́ me a nde abhulu lɨe, oandjelu gba Ebhe-e nde ngaꞌʉ, u nde di ngakɵ pɨ́ ’ndjɨ ma, Ndɨlɨ gba kpála!» ");
INSERT INTO mdm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Abhomʉ-o, pɨta ’kpɨ́ bhisi-e, anokomɨa na kʉva adʉ bhʉ́ Kana, kʉtɨ bini na ndu doto na Galilaya. ’Hi Yesu adʉ oo. ");
INSERT INTO mdm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","U atsia aꞌɨ di Yesu ne omʉkpata gba e bhʉ́ anokomɨa ango-o. ");
INSERT INTO mdm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lɨ vino andjia lɨe, ’hi Yesu atsia apa pɨ anɨ me: «Vino matá ka uo ade.» ");
INSERT INTO mdm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Engʉ́ bini, Yesu agie pɨ anɨ me: «’Hi ma, a ka nɨ́ ne mʉ ne nɨ? Nedhɨnga gba ma-a kolo nga de.» ");
INSERT INTO mdm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Abhomʉ-o, ’hi anɨ atsia apa pɨ okpála na kulu-o me: «Yi mene ndʉ ’ngʉ́ hana ɨnde anɨ apá e pɨ yi ko.» ");
INSERT INTO mdm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngbengbe madakpa ɨnde u abho e lɨ teme-e, adʉ oo madhɨa. OmaYuda vʉvʉlʉ lɨo bhʉ́bhʉ́ ngʉbula nakolo bubu kala Ebhe. Omadakpa ango-o bini ne bini tɨ da naha litele kámá bini. ");
INSERT INTO mdm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu apa pɨ okpála na kulu-o me: «Yi bebedhe omadakpa bhomʉ-o ne engu.» Okpála na kulu-o abebedhe omadakpa ne engu bedhe bedhe. ");
INSERT INTO mdm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Mbɨa ɨnde-e, yi sese, amba yi nʉ ha pɨ ngámá na anokomɨa-o.» U amene bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lɨ ngámá na anokomɨa ale engu-o lɨe, anɨ au me akolo vino. Anɨ dʉ ambɨla bɨlɨ ɨnde ayie lɨ e de. (La-a, okpála na kulu ɨnde asene engu-o, adʉ ambɨmbɨla ngao.) Abhomʉ-o, anɨ aꞌɨ ’ko ɵlɵ-o. ");
INSERT INTO mdm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Anɨ apa pɨ anɨ me: «Ndʉ okpála hana haha ngaɨza kalanʉ vino na babadha. Ɨ dʉ la me u nde andjɨ vino bhelé andjɨ-e, u tsia há bhende babadha ade ko. La-a, ngamʉ-o, mo owo vino bhende na babadha-a akolo lɨ nedhɨnga ɨnde!» ");
INSERT INTO mdm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Abhomʉ-o gina ongʉ́ na ngangamba ɨnde lɨ Yesu amene e-o. Anɨ amene bhʉ́ Kana, kʉtɨ bini na ndu doto na Galilaya. Anɨ asuno sangu gba e-o, omʉkpata gba anɨ-e atsia abhuka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pɨpɨta-a, anɨ anʉ bhʉ́ gʉdhʉ na Kapalanauma bhʉ́ dabɨlɨ bini ne ’hi e, ne ondaise e, di ne omʉkpata gba e-o. U mene la oo ekpɨ́ bhelé de. ");
INSERT INTO mdm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Anokomɨa na Pasɨka gba omaYuda akolo masɨkpe. Abhomʉ-o, Yesu atsia anʉ bhʉ́ gʉdhʉ na Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Oo, anɨ alɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Anɨ abhaka me okpála ngatsɨndjɨ obagala, ne okandɵlɵ, di ne obɵbhɵ. Anɨ atsia abhaka di me okpála nayipa falanga nde adʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Abhomʉ-o, Yesu amene fimbo lɨ kʉte ekpʉ. Anɨ apandja ndʉ uo hana bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-a kilidjo, bhʉ́ dabɨlɨ bini ne okandɵlɵ, di ne obagala gba o-o. Anɨ agʉ ꞌi dabɨlɨ gba okpála nayipa falanga kuto. Anɨ atsia abala di falanga gba uo-o. ");
INSERT INTO mdm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Anɨ atsia apa pɨ okpála ɨnde adʉ natsɨndjɨ obɵbhɵ-o me: «Yi ꞌe ehe ɨnde-e sɨ maꞌe! Yi adjí etɨ gba ’Dyɨ ma-a etɨ natsɨndjɨ ’he de!» ");
INSERT INTO mdm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Omʉkpata gba anɨ-e atsia abhundja engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e me: «Mʉkʉnda ɨnde ma nde ne e ngʉbula etɨ gba mʉ-o, atsúlu ma maka djua!» ");
INSERT INTO mdm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Abhomʉ-o, omaYuda ayi anɨ me: «Mo oméne pɨ ya mangua ngamba ’ngʉ́ dho ɨnde asúno me, mʉ ne angu namene mo-o?» ");
INSERT INTO mdm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu agie pɨ uo me: «Yi bhɵlɵ ’ngbé ’tɨ Ebhe gba omaYuda ɨnde, sʉnda ’kpɨ́ bata-a, ma tsia yíki matá.» ");
INSERT INTO mdm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","OmaYuda ayi anɨ me: «A ayo nanɨ kalanga ndjɨkpa badha ne ká madhɨa, ngʉ́ nayiki ’ngbé ’tɨ Ebhe gba omaYuda ɨnde! La ngamʉ-o, mʉ tsia yíki sʉnda ’kpɨ́ bata?» ");
INSERT INTO mdm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Engʉ́ bini, ’ngbé ’tɨ Ebhe ɨnde lɨ Yesu adʉ apa ’ngʉ́ e, adʉ kʉte anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kaka-a, lɨ Yesu azuku lɨe, omʉkpata gba anɨ-e atsia abhundja engʉ́ nanɨ anɨ apa e-o. Abhomʉ-o, u atsia abhuka engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe, di ne bhende nanɨ lɨ Yesu apa e ko. ");
INSERT INTO mdm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lɨ Yesu adʉ lɨe bhʉ́ gʉdhʉ na Yelusalema ngʉbula anokomɨa na Pasɨka-a, okpála bhelé au ongʉ́ na ngangamba ɨnde anɨ adʉ amene e-o. Abhomʉ-o, u atsia abhuka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Engʉ́ bini, ngaanɨ makpe, anɨ zɨba uo de. Padhá de, anga anɨ adʉ ambɨla ndʉ uo hana ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Anɨ ne gʉmʉ nayi kpála bini lɨ ’ngʉ́ pɨndjɨ kpála-kʉtɨ ade. Padhá de, anga ngaanɨ makpe, anɨ adʉ ambɨla engʉ́ ɨnde bhʉ́ kpála ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kpála bini adʉ nanɨ bhʉ́ ká omʉFalisai . A adʉ ’lɨ anɨ me Nikodemʉ. Anɨ adʉ nanɨ sʉka ongámásɨ gba omaYuda . ");
INSERT INTO mdm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Anɨ anʉ abhaka Yesu sukpe, anɨ atsia apa pɨ anɨ me: «Mʉsuno, ya ambɨla me Ebhe atima mʉ ngae, ngʉ́ nasuno ’ngʉ́ pɨ ya. Padhá de, anga kpála bini tɨ da namene ongamba ’ngʉ́ , maka mʉ ngamemene lɨe ɨnde-e de, ɨ dʉ me Ebhe nde bhʉ́ dabɨlɨ bini ne anɨ ade ko.» ");
INSERT INTO mdm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu agie pɨ anɨ me: «Ma apa pɨ mʉ na paká me, kpála bini tɨ da nau Naʉ gba Ebhe-e de, ɨ dʉ me u nde zu anɨ ne toto de ko.» ");
INSERT INTO mdm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemʉ ayi anɨ me: «Lele pɨ, u tɨ da nazu gbé kpála lɨe ne toto-o? Anɨ tɨ da nagie lɨe bhʉ́ ’bu ’hi e, lɨ ’hi anɨ tsia zú anɨ ne toto?» ");
INSERT INTO mdm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu agie pɨ anɨ me: «Ma apa pɨ mʉ na paká me, kpála bini tɨ da nalɨ bhʉ́ Naʉ gba Ebhe-e de, ɨ dʉ me anɨ nde sia nazu lɨ kpadjɨ na engu di ne lɨ kpadjɨ na Bua de ko. ");
INSERT INTO mdm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bhende azu lɨe bhʉ́ kʉte-e, a ko kʉte. Bhende azu lɨe bhʉ́ Bhobua-a , a ko bua. ");
INSERT INTO mdm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mo ongámba de ka ma apa lɨe pɨ mʉ me: ‹A ayo me u zu ndʉ yi hana ne toto.› ");
INSERT INTO mdm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Anvi ngape lɨ pápá akʉnda nape lɨ e. Mʉ ngadje gɨgɨlɨ. Engʉ́ bini, mʉ mbɨla bɨlɨ lɨ anvi ango-o ayie lɨ e de. Mʉ mbɨla la di pápá adji lɨ e de. A bhadi moko pɨ ndʉ obhende hana asia nazu lɨ kpadjɨ na Bua.» ");
INSERT INTO mdm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Abhomʉ-o, Nikodemʉ ayi Yesu me: «Engʉ́ ango-o tɨ da namene lɨe lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu atsia agie pɨ anɨ me: «Ngamʉ-o, mʉ ne sʉka ongbengbe omʉsuno na Ɨsalaele. Engʉ́ la bini, mʉ mbɨla engʉ́ ango-o de! ");
INSERT INTO mdm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ma apa pɨ mʉ na paká me: ya ngapa engʉ́ ɨnde ya ambɨla e. Ya la di ngakpokpo ’ngʉ́ pɨndjɨ bhende ya au e ne djila ya. Engʉ́ la bini, yi bhuka engʉ́ ɨnde ya akpokpo e pɨ yi-e de. ");
INSERT INTO mdm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ma ngakpokpo ’ngʉ́ pɨ yi pɨndjɨ ’ngʉ́ na pɨ́la doto. Engʉ́ bini, yi bhuka de. Ɨ dʉ la me, ma nde akpokpo ’ngʉ́ pɨ yi pɨndjɨ ’ngʉ́ na abhʉ́lá-a, yi tsia bhúka? ");
INSERT INTO mdm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Padhá de, anga kpála bini ade ɨnde akolo nga abhʉ́lá, bha bini ngama, Ndɨlɨ gba kpála ɨnde ayie oo-o! ");
INSERT INTO mdm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Maka lɨ Moidje aꞌeꞌe nanɨ kulu kpʉlʉ lɨe lɨ ndula abhʉ́ ’gʉ-o, a ayo bhadi me ngama, Ndɨlɨ gba kpála-a, u ꞌeꞌe bhadi ma moko. ");
INSERT INTO mdm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","U ꞌeꞌe ma, amba kpála ne kpála ɨnde abhuka ma-a, anɨ sia mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Padhá de, anga Ebhe akʉnda okpála na pɨ́la doto naali. Kaka-a, anɨ atima koli Ndɨlɨ gba e bini-e ngʉbula me kpála ne kpála ɨnde abhuka anɨ-e, anɨ akpí-i de. Engʉ́ bini, anɨ sia mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","La-a, Ebhe tima nanɨ Ndɨlɨ gba e ngʉ́ nakodho ’ngʉ́ gba okpála na pɨ́la doto de. Engʉ́ bini, anɨ atima anɨ ngʉbula me, okpála na pɨ́la doto kobho ka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kpála ne kpála ɨnde abhuka anɨ-e, mangɨmbo pɨ́ anɨ ade. Engʉ́ la bini, kpála ɨnde ɨ bhuka de-e, u aꞌo mangɨmbo pɨ́ anɨ bhʉtode. Padhá de, anga anɨ bhuka koli Ndɨlɨ bini gba Ebhe-e de. ");
INSERT INTO mdm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ta mangɨmbo ango-o me: zɨ ’kpɨ́ ago pɨ́la doto, engʉ́ la bini, okpála na pɨ́la doto akʉnda mangbo biti ane zɨ ’kpɨ́, ka siti ’ngʉ́ ɨnde u ngamene e-o. ");
INSERT INTO mdm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ndʉ kpála hana ɨnde ngamene siti ’ngʉ́-o, yala zɨ ’kpɨ́ mayala. Anɨ gó di lɨ bɨlɨ lɨ zɨ ’kpɨ́ nde lɨ e de. Padhá de, anga anɨ ngakpe me osisiti ’ngʉ́ gba nɨ-e akoto mbámbá lɨ zɨ ’kpɨ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Engʉ́ la bini, ndʉ kpála hana ɨnde ngamene ngbili ’ngʉ́ , ngago lɨ bɨlɨ lɨ zɨ ’kpɨ́ nde lɨ e-o. Anɨ ngamene mo-o ngʉbula me u u mbámbá me okulu nɨ ngamene e, a amene lɨe maka lɨ Ebhe azɨba lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pɨta ’ngʉ́ ango-o, Yesu ngauo ne omʉkpata gba e anʉ bhʉ́ ndu doto na Yudaya. Oo, anɨ adʉ ne uo ngʉbula mbo nedhɨnga bedɨ. Anɨ atsia adʉ abatisa okpála. ");
INSERT INTO mdm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Djaa atsia adʉ di nabatisa okpála bhʉ́ ’ngu na Enona, de bɨlɨ na Salime, anga engu adʉ lɨ bɨlɨ ango-o naali. Okpála adʉ ago abhaka anɨ, anɨ atsia adʉ abatisa uo. ");
INSERT INTO mdm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Lɨ nedhɨnga bhomʉ-o, a abhaka me u nde bhike nga Djaa bhʉ́ tɨkpʉ de.) ");
INSERT INTO mdm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Abhomʉ-o, bhʉ́ ká omʉkpata gba Djaa, okoko aholo nabi bhayiki ne maYuda bini, pɨndjɨ ’ngʉ́ navʉlʉ lɨe ngʉ́ nakolo ka e bubu, maka lɨ lɨ́lɨ apa lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","U anʉ abhaka Djaa, u atsia apa pɨ anɨ me: «Mʉsuno, kpála nako yi adʉ ne e ayi ’ngu na Djʉlʉdanɨ-e, di mo okpokpo ’ngʉ́ gba e-e, tsia nga mbɨa ɨnde-e, anɨ ngabatisa okpála. Okpála bhelé nganʉ abhaka anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Djaa agie pɨ uo me: «Kpála bini tɨ da nasia ’he belegʉ de bini, ɨ dʉ me Ebhe nde ha pɨ anɨ ngae de ko. ");
INSERT INTO mdm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ngayi makpe, yi tɨ da napapa lɨ ma ngayi me, ma apa nako me: ‹Ngama-a, ma ne Masɨya ade. Engʉ́ la bini, ma ne kpála ɨnde u atima e pɨ anɨ kalanʉ.› ");
INSERT INTO mdm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bhʉlʉ ɵlɵ-o, a ko ’ko ɵlɵ-o. Olia bhoko-o alʉ de anɨ, anɨ ngadje anɨ. Anɨ ngakpi djalɨ naali ka anɨ ngadje ’li ’ko ɵlɵ-o lɨe-o. A ko di djalɨ gba ma-o, djalɨ ango-o mbɨa ɨnde-e libhomu. ");
INSERT INTO mdm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A ayo me u ꞌeꞌe anɨ ne abhʉ́lá, amba ngama-a, ma kɵ naama ne kuto.» ");
INSERT INTO mdm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Kpála ɨnde ayie abhʉ́lá ane ndʉ okpála hana. Kpála ɨnde ayie pɨ́la doto-o, a ko kpála na pɨ́la doto. Anɨ ngakpokpo ’ngʉ́ na pɨ́la doto. Kpála ɨnde ayie abhʉ́lá-a ane ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Anɨ ngakpokpo ’ngʉ́ pɨndjɨ engʉ́ ɨnde anɨ au e, di ne bhende anɨ adje e-o. La-a, kpála bini zɨba engʉ́ ɨnde anɨ ngakpokpo e de. ");
INSERT INTO mdm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kpála ɨnde azɨba engʉ́ ɨnde anɨ ngakpokpo e abhuka me Ebhe ngapa kʉkʉlʉ ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kpála ɨnde lɨ Ebhe atima e, ngakpokpo eli gba Ebhe . Padhá de, anga Ebhe abedhe anɨ ne Bua gba e bedhe. ");
INSERT INTO mdm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","’Dyɨ Ndɨlɨ-e, akʉnda Ndɨlɨ na bhobhoko gba e-o. Anɨ aꞌo ndʉ ’he hana sa ’kpa anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kpála ɨnde abhuka Ndɨlɨ-e, asia mʉkobho na dʉdʉma. La-a, kpála ɨnde ɨ bhuka Ndɨlɨ-e de-e, sía mʉkobho ango-o de. Engʉ́ bini, ke ’ngʉ́ gba Ebhe-e adʉ́ pɨ́ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Abhomʉ-o, omʉFalisai adje me okpála bhelé ngakpata Yesu, di ne me anɨ ngabatisa okpála bhelé ane Djaa . (A na paká me Yesu dʉ nanɨ naae nabatisa okpála de. Omʉkpata gba anɨ-e adʉ mangbo nabatisa okpála ngao.) Lɨ Yesu adje lɨe mo-o, anɨ ayie bhʉ́ ndu doto na Yudaya, anɨ atsia agie lɨe bhʉ́ ndu doto na Galilaya, ");
INSERT INTO mdm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ngʉ́ nanʉ oo. Padhá de, anga a ayo me anɨ pʉ bhʉ́ ndu doto na Samalɨa. ");
INSERT INTO mdm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Anɨ akolo bhʉ́ gʉdhʉ bini na Samalɨa. A adʉ ’lɨ gʉdhʉ ango-o me Sikale, dengo ndu doto ɨnde nanɨ lɨ Yakobho aha e pɨ ndɨlɨ gba e Djodjefʉ-o . ");
INSERT INTO mdm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lɨ dabɨlɨ ango-o, kpongu gba Yakobho adʉ oo. Lɨ Yesu andala lɨe ka dhʉkʉ-o, anɨ atsia adʉ dengo kpongu ango-o kuto. A adʉ masɨkpe de tulukpe. ");
INSERT INTO mdm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɵlɵ bini na Samalɨa ago ngʉ́ nase ’ngu. Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Ha mbo engu nandjɨ mandjɨ mʉma.» ");
INSERT INTO mdm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(A abhaka me omʉkpata gba anɨ-e nde agbida bhʉ́ gʉdhʉ, ngʉ́ nakala ezʉ nazʉ mazʉ.) ");
INSERT INTO mdm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Abhomʉ-o, ɵlɵ-o apa pɨ Yesu me: «Mʉ ne maYuda. Ngama-a, ma ne kpála na Samalɨa. Lele pɨ mʉ tɨ da nayo engu nandjɨ mandjɨ lɨe ka ma?» (Padhá de, anga omaYuda djedje lɨo ne omʉSamalɨa de.) ");
INSERT INTO mdm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu agie pɨ anɨ me: «Ɨ dʉ́ me mʉ mbɨ́la makalá gba Ebhe-e uo, ɨ dʉ́ la di me mʉ mbɨ́la kpála ɨnde apa pɨ mʉ me: ‹Ha mbo engu nandjɨ mandjɨ mʉma uo›, mʉ de ayo mangbo engu ka anɨ ngamʉ. Anɨ de ahá engu na mʉkobho pɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɵlɵ ango-o agie pɨ anɨ me: «Ngámá, ehe ngʉ́ nase engu-o ne di ka mʉ ade. ’Du ’ngu-o la di tsutsu. Mo oyíe ne engu na mʉkobho-o su? ");
INSERT INTO mdm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ogbi ya Yakobho aha kpongu ɨnde-e pɨ ya ngae. Ngaanɨ makpe, anɨ andjɨ engu ɨnde-e bhʉ́ dabɨlɨ bini ne ongɨsɨ di ne onʉ gba e-o. Mo obhundja naamʉ me mʉ ngbéngbé ane anɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu agie pɨ anɨ me: «Kpála ɨnde andjɨ engu ɨnde-e, anɨ adjé matá gʉmʉ ’ngu madje. ");
INSERT INTO mdm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Engʉ́ bini, kpála ɨnde andjɨ́ engu ɨnde ma ahá e pɨ anɨ-e, anɨ djé matá gʉmʉ ’ngu belegʉ de bini. La-a, engu ɨnde ma ahá e pɨ anɨ-e, akólo bhʉ́ anɨ kpongu na mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɵlɵ ango-o apa pɨ anɨ me: «Ngámá, ha mbo engu ango-o mʉma, amba ma adjé matá gʉmʉ ’ngu de. Ma agó la di matá nase engu ɨnde-e de.» ");
INSERT INTO mdm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu apa pɨ anɨ me: «Nʉ ꞌɨ ’ko mʉ, amba mʉ gie matá lɨmʉ ei.» ");
INSERT INTO mdm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Anɨ agie pɨ Yesu me: «Bhoko ka ma ade.» Yesu atsia apa pɨ anɨ me: «Mo opa ndjɨndjɨ me bhoko ka mʉ ade ko. ");
INSERT INTO mdm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Padhá de, anga mo odʉ nako ne obhosɨ bhuluvue. Bhoko bhende yi nde ne e mbɨa ɨnde-e, a ko la di ’ko mʉ de. Mo opa kʉkʉlʉ ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Abhomʉ-o, ɵlɵ ango-o apa pɨ Yesu me: «Ngámá, ma au me mʉ ne polofeta . ");
INSERT INTO mdm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Onguo ogbi ya, okpála na ndu doto na Samalɨa-a, adhɵgɵ Ebhe pɨ́ eta ɨnde. Engʉ́ bini, ngayi omaYuda-a, yi ngapa me gʉdhʉ na Yelusalema ne bɨlɨ ɨnde a ayo lɨe me u dhɵgɵ Ebhe-o.» ");
INSERT INTO mdm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu atsia agie pɨ anɨ me: «Ɵlɵ-e, bhuka ’li ma. Nedhɨnga ngago, nedhɨnga ɨnde yi dhɵ́gɵ ’Dyɨ nɨ́ lɨe pɨ́ eta ɨnde-e de. Yi dhɵ́gɵ la di anɨ lɨe bhʉ́ gʉdhʉ na Yelusalema de. ");
INSERT INTO mdm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ngayi okpála na ndu doto na Samalɨa-a, yi ngadhɵgɵ Ebhe ɨnde yi mbɨla e de. Engʉ́ bini, ngaya-a, ya ngadhɵgɵ Ebhe ɨnde ya ambɨla e. Padhá de, anga mʉkobho ago ne lɨ pápá gba omaYuda. ");
INSERT INTO mdm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Engʉ́ bini, nedhɨnga ngago, nedhɨnga ango-o belegʉ akolo, nedhɨnga ɨnde lɨ okʉkʉlʉ okpála nadhɵgɵ ’Dyɨ nɨ́ adhɵ́gɵ anɨ lɨe bhʉ́ Bu Bhobua , di ne bhʉ́ kʉkʉlʉ ’ngʉ́-o. Padhá de, anga a bhomʉ-o okʉkʉlʉ okpála nadhɵgɵ ’Dyɨ nɨ́ ɨnde anɨ nde ne gʉmʉ o-o. ");
INSERT INTO mdm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ebhe ne Bua. Kaka-a, a ayo me okpála ɨnde ngadhɵgɵ anɨ-e, dhɵgɵ anɨ bhʉ́ Bua di ne bhʉ́ kʉkʉlʉ ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɵlɵ-o apa pɨ Yesu me: «Ma ambɨla me Masɨya (ꞌɨlɨ ango-o akʉnda napa me Kilisito) agó mago. Lɨ anɨ agó lɨe-e, anɨ tsia bhúlu ndʉ ’ngʉ́ hana pɨ ya mbámbá.» ");
INSERT INTO mdm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu agie pɨ anɨ me: «Ngama kpála ɨnde ngakpokpo ’ngʉ́ pɨ mʉ mbɨa ɨnde-e, ma ne anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lɨ nedhɨnga bhomʉ-o, omʉkpata gba Yesu-o agie lɨo. U angamba naali ngʉ́ nau anɨ me anɨ nde ngagama ’ngʉ́ ne ɵlɵ. Engʉ́ bini, sʉka uo bini yi anɨ de me: «Mʉ ngagɨlɨ nɨ?» di ne me: «Mʉ ngagama ’ngʉ́ ne anɨ ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Abhomʉ-o, ɵlɵ ango-o aꞌo ká lʉsa ’ngu gba e-o. Anɨ agie lɨe abhʉ́ gʉdhʉ. Anɨ atsia apa pɨ okpála me: ");
INSERT INTO mdm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Yi gógo, yi u kpála ɨnde akpokpo ndʉ ’ngʉ́ hana ɨnde ma amene e mʉma. A ko ndi Masɨya dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Abhomʉ-o, u aze bhʉ́ gʉdhʉ-o, u atsia agbida nabhaka Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bhʉ́ nedhɨnga bhomʉ-o, omʉkpata gba Yesu-o adʉ atʉ anɨ me anɨ zʉ ’he. U adʉ apa pɨ anɨ me: «Mʉsuno, zʉ nga mbo ’he!» ");
INSERT INTO mdm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Engʉ́ bini, anɨ agie pɨ uo me: «A ka ma ne ehe nazʉ mazʉ ɨnde yi mbɨla ’ngʉ́ lɨ e de.» ");
INSERT INTO mdm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Abhomʉ-o, omʉkpata-a ayi lɨo sʉnda o me: «Kpála bini ago ndi pɨ anɨ ne ehe nazʉ mazʉ adɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu apa pɨ uo me: «Ezʉ gba ma-a, a ko namene gʉmʉ gba kpála ɨnde atima ma-o, di ne nandjia kulu ɨnde anɨ aha e mʉma-o. ");
INSERT INTO mdm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ngayi-e, yi papa me: ‹A atigala matá epe badha ngʉbula naꞌe nguwa abhiye.› La ngama-a, ma apa pɨ yi me, yi tsia nga oedyɨ-e ndjɨndjɨ. Padhá de, anga nguwa abhele, a akolo bedhe ngʉbula naꞌeꞌe abhiye! ");
INSERT INTO mdm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kpála ɨnde ngagbe nguwa abhiye-e ngasia makalá gba e-o. Anɨ ngapo bhʉ́la nguwa-a ngʉbula mʉkobho na dʉdʉma. Kaka-a, kpála nalu nguwa, ne kpála ɨnde ngaꞌeꞌe abhiye-e, ngakpi djalɨ bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Padhá de, anga a ko kʉkʉlʉ ’ngʉ́, engʉ́ ɨnde u apa e bhʉ́ gbitaku me: ‹Kpála koko ngalu nguwa-o, lɨ kpála koko tsia ꞌé abhiye.› ");
INSERT INTO mdm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngama-a, ma atima yi naꞌe nguwa bhiye ɨnde yi ndala bhʉ́ e de. Okpála koko andala bhʉ́bhʉ́, yi la ngasia bádha ’ngʉ́ lɨ kulu gba uo-o.» ");
INSERT INTO mdm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Abhomʉ-o, okpála bhelé na gʉdhʉ na Samalɨa bhomʉ-o abhuka Yesu ka eli ɨnde lɨ ɵlɵ-o akpokpo e me: «Anɨ akpokpo ndʉ ’ngʉ́ hana ɨnde ma amene e mʉma.» ");
INSERT INTO mdm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kaka-a, lɨ okpála na gʉdhʉ na Samalɨa akolo lɨe de Yesu-o, u ayo ka anɨ me anɨ dʉ mbo gba o oo. Abhomʉ-o, Yesu atsia amene oo ekpɨ́ bhisi. ");
INSERT INTO mdm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Okpála bhelé naali abhuka matá ka eli ɨnde lɨ Yesu apa e-o. ");
INSERT INTO mdm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","U atsia apa pɨ ɵlɵ-o me: «Mbɨa ɨnde-e, ya bhuka bha bini ka engʉ́ mo okpokpo e de. Engʉ́ bini, ya abhuka anga ngaya makpe-e, ya adje anɨ. Ya atsia ambɨla na paká me a ko Mʉkobho gba okpála na pɨ́la doto.» ");
INSERT INTO mdm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pɨta ’kpɨ́ bhisi lɨ Yesu amene e oo, anɨ ayie oo, anɨ atsia anʉ bhʉ́ ndu doto na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ngaanɨ makpe-e, anɨ apa nanɨ me: «Polofeta ɨnde u amanga e bhʉ́ doto gba e belegʉ ade bini.» ");
INSERT INTO mdm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lɨ anɨ akolo lɨe bhʉ́ ndu doto na Galilaya-a, okpála ɨnde oo asia anɨ ndjɨndjɨ. Padhá de, anga u au ndʉ ’ngʉ́ hana ɨnde lɨ anɨ amene e lɨ nedhɨnga na anokomɨa bhʉ́ gʉdhʉ na Yelusalema-o, anga u adʉ di oo. ");
INSERT INTO mdm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pɨpɨta-a, Yesu agie lɨe bhʉ́ kʉtɨ na Kana, bhʉ́ ndu doto na Galilaya. A bhomʉ-o bɨlɨ ɨnde anɨ adji nanɨ engu lɨ e, atsia akolo vino-o. ’Ngbé kpála bini na Lɨta adʉ oo. Adʉ lɨ ndɨlɨ gba anɨ na bhobhoko-o ne kuo, bhʉ́ kʉtɨ na Kapalanauma. ");
INSERT INTO mdm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Lɨ kpála ango-o adje lɨe me Yesu ayie bhʉ́ ndu doto na Yudaya, anɨ akolo bhʉ́ ndu doto na Galilaya-a, anɨ anʉ abhaka anɨ. Anɨ atsia akikiliki lɨe pɨ anɨ me anɨ nʉ bhʉ́ kʉtɨ na Kapalanauma, amba anɨ kobho ndɨlɨ gba nɨ na bhobhoko-o. Padhá de, anga ndɨlɨ ango-o adʉ masɨkpe de nakpi. ");
INSERT INTO mdm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Ɨ dʉ me yi nde u ongamba ’ngʉ́ , di ne okɨaka ’ngʉ́ de-e, a na paká me yi tɨ da nabhubhuka de!» ");
INSERT INTO mdm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","’Ngbé kpála na Lɨta-a apa pɨ anɨ me: «Ngámá, kala me ndɨlɨ-e kodho bua e, gogo.» ");
INSERT INTO mdm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu apa pɨ anɨ me: «Gie lɨmʉ agba mʉ, ndɨlɨ gba mʉ-o akobho!» Kpála ango-o abhuka engʉ́ ɨnde lɨ Yesu apa e pɨ anɨ-o. Anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nedhɨnga anɨ adʉ anʉ lɨe-e, okpála na kulu gba anɨ-e ago akɵ lɨo ne anɨ lɨ kpadjɨ. U apa pɨ anɨ me: «Ndɨlɨ gba mʉ-o akobho!» ");
INSERT INTO mdm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anɨ atsia ayi uo lɨ nedhɨnga lɨ ndɨlɨ-e akolo lɨe ndjɨndjɨ-o. U apa pɨ anɨ me: «Bandjɨ-e ayie lɨ anɨ lili bhʉ́ saa na bini, pɨta tulukpe.» ");
INSERT INTO mdm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Abhomʉ-o, ’dyɨ ndɨlɨ-e atsia ambɨla me, a ko saa ɨnde lɨ Yesu apa pɨ anɨ lɨe me: «Ndɨlɨ gba mʉ-o akobho-o.» Nayie lɨ nedhɨnga bhomʉ-o, ngaanɨ makpe-e, anɨ abhuka, di ne piga gba e libhomu. ");
INSERT INTO mdm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A bhomʉ-o ngamba ’ngʉ́ na bhisi lɨ Yesu amene e, pɨta anɨ ayie lɨe bhʉ́ ndu doto na Yudaya, anɨ atsia agie lɨe bhʉ́ ndu doto na Galilaya ko. ");
INSERT INTO mdm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pɨta ongʉ́ akodho ’kpɨ́-e, anokomɨa bini gba omaYuda atɨ. Abhomʉ-o, Yesu atsia anʉ bhʉ́ gʉdhʉ na Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bhʉ́ gʉdhʉ oo, de bhotɨ ɨnde u aꞌɨ e me bhotɨ gba Okandɵlɵ-o, ’dú ’ngu bini navʉlʉ kʉte adʉ oo. A adʉ ’lɨ ’lɨ bhʉ́ eli na Ebele me Betedjata. Djedje ’he maka ’tɨ ngbangbalɨ adʉ dede bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Obhʉlʉ kuo bhelé adʉ me u nde asɨlɨ kuto sasa. A adʉ nanɨ okpála ɨnde ɨ u ’kpɨ́ de, ne okpála ɨnde ne eze lɨ ’dhʉ o, di ne okpála na bhʉkʉ kʉte. U adʉ adjeke me engu-o dimba. ");
INSERT INTO mdm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Padhá de, anga lɨ onedhɨnga koko-o, andjelu bini gba Ngámá-a adʉ akɵ bhʉ́ ’ngu-o, engu-o atsia adʉ adimba. Kpála na kuo ɨnde adʉ akɵ bhʉ́bhʉ́ kalanʉ-o, adʉ nakobho. Belegʉ lɨ kuo dʉ bha nanɨ pɨ-ie. ");
INSERT INTO mdm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bhoko bini adʉ oo, anɨ asɨ nanɨ ne kuo kalanga ndjɨkpa bata ne ká madjɨna. ");
INSERT INTO mdm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Lɨ Yesu au anɨ lɨe asɨ kuto-o, anɨ ambɨla di lɨe me anɨ asɨ ne kuo ’kpɨ́ bhelé-e, anɨ atsia ayi anɨ me: «Mo okʉnda nakobho?» ");
INSERT INTO mdm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kpála na kuo ango-o agie pɨ anɨ me: «Ngámá, kpála ka ma ade ngʉbula me anɨ kɵ ma bhʉ́ ’ngu-o, lɨ nedhɨnga ɨnde ɨ ngadimba lɨe-o. Ma le me ma nʉ me-e, lɨ kpála koko kodho ’kpɨ́ kala ma.» ");
INSERT INTO mdm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu apa pɨ anɨ me: «Yie bhʉ́lá, ha tsala gba mʉ-o, nʉnʉ.» ");
INSERT INTO mdm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kolo má gala me-e, kpála na kuo-o akobho. Anɨ aha tsala gba e-o, anɨ atsia aholo nadhʉkʉ. La-a, adʉ nanɨ lɨ ’kpɨ́ naguo gba omaYuda-o . ");
INSERT INTO mdm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Abhomʉ-o, omaYuda apa pɨ kpála ɨnde akobho-o me: «A ko ’kpɨ́ naguo. A ayo de me mʉ bɨ tsala gba mʉ-o de.» ");
INSERT INTO mdm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Anɨ agie pɨ uo me: «Kpála ɨnde akobho ma-a, apa mʉma me: ‹Ha tsala gba mʉ-o, nʉnʉ.›» ");
INSERT INTO mdm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","U ayi anɨ me: «A ko kpála bhedho ɨnde apa pɨ mʉ me: ‹Ha tsala gba mʉ-o nʉnʉ?›» ");
INSERT INTO mdm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Engʉ́ bini, kpála ɨnde akobho-o mbɨla de me a ko da. Padhá de, anga adʉ me Yesu nde angɨta bhʉ́ ká okpála ɨnde adʉ lɨ bɨlɨ ango-o angɨta. ");
INSERT INTO mdm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pɨpɨta-a, Yesu abhaka anɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. Yesu apa pɨ anɨ me: «Tsitsia nga, mo okobho. Mo oméne matá siti ’ngʉ́ de, amba engʉ́ ɨnde ane ne siti-e, akólo lɨ kʉte mʉ de.» ");
INSERT INTO mdm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kpála ango-o anʉ napa pɨ omaYuda me Yesu akobho nɨ ngae. ");
INSERT INTO mdm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kaka-a, omaYuda aholo nadje siti bua pɨndjɨ Yesu. Padhá de, anga anɨ amene nanɨ engʉ́ ango-o bhʉ́ ’kpɨ́ naguo. ");
INSERT INTO mdm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Engʉ́ bini, Yesu agie pɨ uo me: «Maka lɨ ’Dyɨ ma ngamene kulu lɨe nakolo pɨ mbɨa ɨnde-e, Ngama di-e, ma ngamemene moko.» ");
INSERT INTO mdm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kaka-a, omaYuda adʉ agɨlɨ matá ne kekele ngʉ́ nabhɵlɵ anɨ. Padhá de, anga anɨ gʉmʉ bha bini lɨ́lɨ na ’kpɨ́ naguo de, engʉ́ bini, anɨ adʉ apa lɨe me Ebhe ne ’Dyɨ nɨ-e, anɨ adʉ ale lɨe bhomʉ-o lɨ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Abhomʉ-o, Yesu apa matá pɨ uo me: «A moko, ma apa pɨ yi na paká me ngama Ndɨlɨ-e, ma tɨ da namene ’he bini bhʉ́ ngʉ ma de, bha bini bhende ma au me ’Dyɨ ma ngamene e-o. Padhá de, anga ehe ɨnde lɨ ’Dyɨ ma ngamene e, ngama Ndɨlɨ-e, ma ngamemene bhadi moko. ");
INSERT INTO mdm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","’Dyɨ ma kʉnda ma, Ndɨlɨ gba e-o. Anɨ ngasuno ndʉ ’ngʉ́ hana ɨnde ngaanɨ makpe anɨ ngamene e mʉma, Ndɨlɨ gba e-o. Anɨ asúno mʉma, Ndɨlɨ gba e, okulu na ngbengbengbe ɨnde ane obhende-e mane. Yi tsía ngámba tété. ");
INSERT INTO mdm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Padhá de, anga maka lɨ ’Dyɨ ma ngazuku okpála ɨnde amu-o lɨe, anɨ la di ngaha mʉkobho pɨ uo-o, ngama, Ndɨlɨ gba anɨ-e, ma ngaha bhadi mʉkobho moko pɨ kpála ɨnde ma akʉnda nahaha pɨ e ko. ");
INSERT INTO mdm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","’Dyɨ ma kodho ’ngʉ́ gba kpála bini de. Engʉ́ bini, anɨ aha nakodho ’ngʉ́ hana mʉma, Ndɨlɨ gba e, ");
INSERT INTO mdm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ngʉbula me ndʉ okpála hana dʉ namanga ma, Ndɨlɨ gba anɨ, maka u ngamanga anɨ ’Dyɨ ma lɨe ko. Kpála ɨnde ɨ manga ma, Ndɨlɨ-e de-e, anɨ manga di ’Dyɨ ma ɨnde atima ma-a de. ");
INSERT INTO mdm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A moko, ma apa pɨ yi na paká me kpála ɨnde adje ’li ma-a, ɨnde abhuka la di kpála ɨnde atima ma-a, kpála ango-o asia mʉkobho na dʉdʉma. U ꞌó mangɨmbo pɨ́ kpála ango-o de. Engʉ́ bini, anɨ ayie bhʉ́ kuo, anɨ atsia akodho ’kpɨ́ bhʉ́ mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A moko, ma apa pɨ yi na paká me nedhɨnga ngago, mbɨa ɨnde-e, nedhɨnga ango-o belegʉ akolo, nedhɨnga lɨ okpála ɨnde amu-o, adjé ’li Ndɨlɨ gba kpála-a lɨe-o. Abhomʉ-o, okpála ɨnde adjé-e, u tsia kóbho. ");
INSERT INTO mdm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Padhá de, anga maka lɨ ’Dyɨ ma nde lɨe ne angu ngʉbula naha mʉkobho-o, anɨ aha bhadi angu mʉma, Ndɨlɨ gba e moko ngʉbula me ma dʉ naha mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Anɨ atsia aha la di angu mʉma, Ndɨlɨ gba e, ngʉ́ nakodho ’ngʉ́ gba okpála, anga ma ne Ndɨlɨ gba kpála. ");
INSERT INTO mdm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yi angámba tété de. Padhá de, anga nedhɨnga ngago. Bhʉ́ nedhɨnga ango-o, ndʉ okpála hana ɨnde bhʉ́ lata-a, adjé ’li Ndɨlɨ gba kpála-o. ");
INSERT INTO mdm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Abhomʉ-o, u tsia zé. Okpála bhende amene bádha ’ngʉ́-o, azúku ngʉbula nasia mʉkobho. Engʉ́ bini, okpála bhende amene siti ’ngʉ́-o, azúku ngʉbula nasia mangɨmbo.» ");
INSERT INTO mdm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngama-a, ma tɨ da namene ’he bini bhʉ́ ngʉ ma de. Ma ngakodho ’ngʉ́ maka lɨ kpála atima ma-a ngapapa mʉma lɨe ko. Kaka-a, nakodho ’ngʉ́ gba ma-a ngbingbili. Padhá de, anga ma gɨlɨ namene gʉmʉ gba ma-a de. Engʉ́ bini, ma ngagɨlɨ mangbo namene gʉmʉ gba kpála ɨnde atima ma ko. ");
INSERT INTO mdm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ɨ dʉ́ me ma dʉ akpokpo ’ngʉ́ ɨnde a atsia ma-a, engʉ́ ango-o de dʉ́ kʉkʉlʉ ’ngʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Engʉ́ bini, kpála koko ngakpokpo ’ngʉ́ gba ma-a ngae. Ma ambɨla me engʉ́ gba ma ɨnde anɨ ngakpokpo e, a ko kʉkʉlʉ ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ngayi-e, yi atima okpála agba Djaa , anɨ atsia akpokpo kʉkʉlʉ ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngama-a, ma ne gʉmʉ kpála ngʉ́ nakpokpo ’ngʉ́ gba ma-a ade. La-a, ma ngapapa mo-o ngʉbula me yi sia mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Djaa nanɨ maka eke ɨnde u adhedhe e, ɨnde ngatsi matsi. Ngayi-e, yi atsia akʉnda nanɨ nakpi djalɨ ngʉbula mbo nedhɨnga bedɨ lɨ zɨ ’ke gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Engʉ́ bini, engʉ́ gba ma ɨnde u ngakpokpo e, ane bhende gba Djaa mane. A ko bhende na kulu ɨnde lɨ ’Dyɨ ma apa me ma mene e-o. A moko, kulu ɨnde ma ngamene e ngasuno me ’Dyɨ ma atima ma ngae. ");
INSERT INTO mdm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","’Dyɨ ma ɨnde atima ma-a, akpokpo di engʉ́ gba ma-a ngae. La-a, yi dje nga ’li anɨ belegʉ de bini, yi u nga la di anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Eli gba anɨ-e ngadʉ bhʉ́ yi ade. Padhá de, anga yi ayala nabhuka kpála ɨnde anɨ atima e-o. ");
INSERT INTO mdm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yi ngadjɨpɨ ’ngʉ́ pɨndjɨ Bhuku gba Ebhe-e ndjɨndjɨ, anga yi ngabhundja me yi asía mʉkobho na dʉdʉma bhʉ́bhʉ́. A la bhomʉ-o Bhuku ɨnde ngakpokpo ’ngʉ́ gba ma-o! ");
INSERT INTO mdm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Abana mo-o, yi kʉnda nago abhaka ma ngʉ́ nasia mʉkobho ango-o de. ");
INSERT INTO mdm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Ma gɨlɨ de me okpála dhɵgɵ ma-a de. ");
INSERT INTO mdm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Engʉ́ bini, ma mbɨla yi ndjɨndjɨ. Ma ambɨla me yi ne mʉkʉnda pɨ Ebhe ade. ");
INSERT INTO mdm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","’Dyɨ ma atima ma ngae. La-a, yi sia ma de. Ɨ dʉ la me kpála koko nde ago bhʉ́ ngʉ e, yi tsia sía anɨ! ");
INSERT INTO mdm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yi ngatoko lɨyi sʉnda yi. Yi gɨlɨ de me Ebhe toko bha yi ngae de. Lele pɨ yi tɨ da nabhuka ma lɨe? ");
INSERT INTO mdm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yi abhúndja de me ma aꞌó yi bhʉ́ mangɨmbo kala ’Dyɨ ma ngama-a de. Kpála bhende aꞌó yi bhʉ́ mangɨmbo-o, a ko Moidje ɨnde yi aꞌo ’to yi ’to e ko. ");
INSERT INTO mdm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ɨ dʉ́ me yi bhúka Moidje kʉkʉlʉ-o, yi de abhúka di ma mabhuka . Padhá de, anga Moidje aye nanɨ engʉ́ gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Engʉ́ bini, ɨ dʉ me yi nde bhuka engʉ́ ɨnde anɨ aye e de-e, yi abhúka la ’li ma lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pɨpɨta-a, Yesu akodho ’kpɨ́ lɨ pápá koko na ekpɵ na Galilaya, ɨnde u aꞌɨ di-e me ekpɵ na Tibeliade. ");
INSERT INTO mdm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bhiti okpála na bhibhiti adʉ akpata anɨ. Padhá de, anga u adʉ au ongamba ’ngʉ́ ɨnde anɨ adʉ amene e lɨ nakobho okpála na kuo-o. ");
INSERT INTO mdm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu atsia aꞌʉ apɨ́ ’ta. Oo, u atsia adʉlʉ ne omʉkpata gba e kuto. ");
INSERT INTO mdm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A adʉ me anokomɨa na Pasɨka gba omaYuda nde akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Abhomʉ-o, Yesu atsia ’kpɨ́, anɨ au bhiti okpála na bhibhiti ngago abhaka anɨ. Anɨ atsia ayi Filipo me: «Nɨ́ tɨ da nakala mapa su ngʉbula me okpála ɨnde-e hana zʉ-o?» ");
INSERT INTO mdm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesu adʉ apa mo-o ngʉbula nale Filipo. Padhá de, anga ngaanɨ Yesu-o, anɨ adʉ ambɨla engʉ́ ɨnde anɨ améne e ndjɨndjɨ.) ");
INSERT INTO mdm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo atsia agie pɨ anɨ me: «Abana ya kala mapa ne lɨ́ denalio kámá bhisi-e, alé de me kpála ne kpála sia mbo-o de.» ");
INSERT INTO mdm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sʉka omʉkpata gba anɨ koko-o, Andɨlɨ ndai Simo Piele, apa pɨ anɨ me: ");
INSERT INTO mdm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ndɨlɨ na bhobhoko bini sɨ-ɨ, a ka anɨ ne mapa na olodje bhuluvue di ne sungu bhisi. A la bhomʉ-o nɨ pɨ bhiti okpála ɨnde-e?» ");
INSERT INTO mdm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Do Yesu de-e: «Yi pa pɨ okpála me u dʉlʉ kuto.» (Ulu adʉ lɨ bɨlɨ ango-o naali.) Okpála atsia adʉlʉ kuto. Obhosɨ adʉ masɨkpe de kutu bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Abhomʉ-o, Yesu aha mapa-o. Anɨ atsia agie heni pɨ Ebhe. Anɨ atsia agapa lɨ okpála ɨnde adʉ oo-o. Anɨ aha bhadi sungu-o pɨ uo moko lɨ lele maka u adʉ akʉkʉnda lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lɨ okpála aꞌuꞌu lɨe, Yesu atsia apa pɨ omʉkpata gba e me: «Yi po bhʉ́la dudu ɨnde atigala-o, ngʉbula me asíti de.» ");
INSERT INTO mdm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dú mapa na olodje bhuluvue ɨnde atigala-a, u apo bhʉ́bhʉ́la. A atsia abebedhe okíli ndjɨkpa ne ká bhisi. ");
INSERT INTO mdm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lɨ okpála au ngamba ’ngʉ́ ɨnde lɨ Yesu amene e lɨe, u atsia apa me: «A ɨnde-e bha ndjʉ polofeta ɨnde a ayo me anɨ go pɨ́la doto-o!» ");
INSERT INTO mdm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu ambɨla me u ngakʉnda nago aholo nɨ ne kpéke me nɨ dʉ ngámá. Abhomʉ-o, anɨ ayie, anɨ atsia anʉ matá kpi e kpi apɨ́ ’ta. ");
INSERT INTO mdm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A akolo lɨe tagolo-o, omʉkpata gba Yesu akɵ alɨngo ekpɵ-o. ");
INSERT INTO mdm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","U aꞌʉ bhʉ́ zabʉ bini u atsia aholo nagugulu, anʉ lɨ pápá na Kapalanauma. La-a, ekpɨ́ abi lɨ uo padhá me Yesu nde kolo nga lɨ uo de. ");
INSERT INTO mdm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Anvi adʉ ape kpekpeke. Kaka-a, engu-o aholo nadimba. ");
INSERT INTO mdm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A abhaka me omʉkpata-a nde adhʉkʉ ne zabʉ-o masɨkpe de kilometele madhɨa. Lɨ nedhɨnga bhomʉ-o, u au Yesu me anɨ nde ngadhʉkʉ pɨ́ ’ngu. Anɨ akolo de zabʉ-o. Abhomʉ-o, u aholo nadje tsʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Engʉ́ bini, Yesu apa pɨ uo me: «A ko ma, yi adjé tsʉlʉ de!» ");
INSERT INTO mdm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","U adʉ akʉnda me o ha anɨ, amba o bɨ anɨ bhʉ́ zabʉ-o. La-a, zabʉ akolo bha kolo lɨngo ’gɵ lɨ bɨlɨ u adʉ anʉ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lɨ ekpɨ́ aseke lɨe, bhiti okpála ɨnde atigala ayi ’ngu-o au bha koli zabʉ bini. La-a, u adʉ ambɨla ndjɨndjɨ me Yesu ꞌʉ bhʉ́ zabʉ bhʉ́ dabɨlɨ bini ne omʉkpata gba e de. Omʉkpata-a anʉ kpi o kpi. ");
INSERT INTO mdm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lɨ nedhɨnga bhomʉ-o, ozabʉ koko ayie bhʉ́ gʉdhʉ na Tibeliade, atsia akolo de bɨlɨ lɨ okpála azʉ mapa lɨ e pɨta lɨ Ngámá agie heni lɨe pɨ Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lɨ bhiti okpála bhomʉ-o au lɨe me Yesu ne omʉkpata gba e oo ade-e, u aꞌʉꞌʉ bhʉ́ ozabʉ-o, u atsia agbida bhʉ́ Kapalanauma ngʉ́ nagɨlɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","U anʉ abhaka Yesu ayi ’ngu. Abhomʉ-o, u ayi anɨ me: «Mʉsuno, mo okolo ei nadho?» ");
INSERT INTO mdm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu agie pɨ uo me: «Heni, ma apa pɨ yi na paká me, yi ngagɨlɨ ma ka ongamba ’ngʉ́ ɨnde yi au e ade. Yi ngagɨlɨ mangbo ma ka mapa ɨnde yi azʉ e, yi atsia aꞌuꞌu ne e má kpú kpú kpú-o! ");
INSERT INTO mdm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","La-a, yi améne kulu ngʉbula ezʉ ɨnde ngazi mazi-e de. Engʉ́ bini, yi mene mangbo ngʉbula ezʉ ɨnde ngabhue, di ne bhende ngaha mʉkobho na dʉdʉma ko. Ngama, Ndɨlɨ gba kpála-a, ma ahá ezʉ ango-o pɨ yi ngama. Padhá de, anga Ebhe ’Dyɨ ma aꞌo kasé na angu gba e lɨ kʉte ma.» ");
INSERT INTO mdm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Abhomʉ-o, u atsia ayi anɨ me: «A ayo me ya mene pɨ ngʉ́ namene kulu maka lɨ Ebhe akʉnda lɨe?» ");
INSERT INTO mdm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Do Yesu pɨ uo me: «Kulu gba Ebhe-e, a ko me yi bhuka kpála ɨnde anɨ atima e ko.» ");
INSERT INTO mdm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Abhomʉ-o, u atsia ayi anɨ me: «Mo oméne mangua ngamba ’ngʉ́ dho me ya u, amba ya bhuka mʉ-o? Kulu gba mʉ-o ne nɨ? ");
INSERT INTO mdm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lɨ onguo ogbi ya adʉ lɨe abhʉ́ ’gʉ-o, u azʉ mana maka u aye nanɨ lɨe bhʉ́ Bhuku gba Ebhe-e me: ‹Anɨ aha mapa ɨnde ayie abhʉ́lá-a pɨ uo ngʉ́ nazʉzʉ.›» ");
INSERT INTO mdm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Abhomʉ-o, Yesu agie pɨ uo me: «A moko, ma apa pɨ yi na paká me, Moidje ha mapa na abhʉ́lá-a pɨ yi ngae de. Engʉ́ bini, ’Dyɨ ma ngaha mapa na kʉkʉlʉ na abhʉ́lá-a pɨ yi ngae. ");
INSERT INTO mdm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Padhá de, anga mapa ɨnde lɨ Ebhe ngaha e, a ko bhende ngayie abhʉ́lá, ɨnde ngaha la di mʉkobho pɨ okpála na doto-o.» ");
INSERT INTO mdm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Abhomʉ-o, u atsia apa pɨ Yesu me: «Ngámá, ha pɨ ya ndʉ ’kpɨ́ hana mapa bhomʉ!» ");
INSERT INTO mdm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu agie pɨ uo me: «Ma ne mapa na mʉkobho. Kpála bhende ago abhaka ma-a, gʉmʉ ’zʉ méne anɨ belegʉ de bini. Kpála bhende abhuka la di ma-a, gʉmʉ ’ngu méne anɨ belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Engʉ́ bini, ma apa ’ngʉ́ ɨnde-e pɨ yi apa. Yi au ma. La-a, yi bhuka de. ");
INSERT INTO mdm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndʉ kpála hana ɨnde lɨ ’Dyɨ ma ngaha e mʉma-a, agó lɨ pabɨlɨ gba ma. La di-e, ndʉ kpála hana ɨnde agó lɨ pabɨlɨ gba ma-a, ma bhíke anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Padhá de, anga ma ayie abhʉ́lá, ma ago ngʉ́ namene engʉ́ ɨnde lɨ kpála ɨnde atima ma-a akʉnda e ko. Engʉ́ bini, ma go ngʉ́ namene naama ’ngʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Engʉ́ ɨnde lɨ kpála ɨnde atima ma akʉnda e-e, a ngae ɨnde: ndʉ okpála ɨnde anɨ aha o mʉma hana, a ayo de me sʉka uo bini ngɨta-a de. Engʉ́ bini, a ayo me, alɨ sokpɨ́-e, ma zuku ndʉ uo hana. ");
INSERT INTO mdm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Padhá de, anga ’Dyɨ ma akʉnda me, ndʉ okpála hana ɨnde au ma Ndɨlɨ-e, ɨnde abhuka la di ma-a, sia mʉkobho na dʉdʉma, amba ma zuku uo alɨ sokpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Abhomʉ-o, omaYuda aholo namene bhayiki lɨ kʉte anɨ. Padhá de, anga anɨ apa nanɨ me: «Ma ne mapa ɨnde ayie abhʉ́lá.» ");
INSERT INTO mdm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","U atsia apa me: «A ɨnde-e Yesu, ndɨlɨ gba Djodjefʉ-o dɨ? Ya mbɨla ’dyɨ anɨ ne ’hi anɨ hana. Lele pɨ anɨ apa lɨe me nɨ ayie abhʉ́lá?» ");
INSERT INTO mdm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu agie pɨ uo me: «Yi ꞌo namene bhayiki sʉnda yi. ");
INSERT INTO mdm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kpála tɨ da nago abhaka ma de, ɨ dʉ me ’Dyɨ ma ɨnde atima ma-a nde holo ’kpa anɨ ngae de ko. Ngama la di-e, ma azúku anɨ lɨ sokpɨ́. ");
INSERT INTO mdm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Opolofeta aye engʉ́ ɨnde-e me: ‹Ebhe asuno ’ngʉ́ pɨ ndʉ okpála hana.› Kpála ne kpála ɨnde adje ’li ’Dyɨ ma, ɨnde asia la di nasuno gba anɨ-e, ago nabhaka ma. ");
INSERT INTO mdm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bhobhomʉ apa me, kpála bini u Ebhe de. Bha bini ma, kpála ɨnde ayie agba Ebhe-e, ma au bha ’Dyɨ ma ngama. ");
INSERT INTO mdm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A moko, ma apa pɨ yi na paká me, kpála ɨnde abhuka-a, asia mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngama-a, ma ne mapa na mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Onguo ogbi yi azʉ nanɨ mana abhʉ́ ’gʉ. La-a, u atsia amu. ");
INSERT INTO mdm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Engʉ́ bini, mapa bhende ayie abhʉ́lá-a, a ko bhende lɨ kpála zʉ e, anɨ kpí de ko. ");
INSERT INTO mdm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma ne mapa ɨnde ʉʉ, ɨnde ayie abhʉ́lá ko. Ɨ dʉ me kpála nde azʉ mapa ango-o, anɨ dʉ́ bhʉ́ mʉkobho na dʉdʉma. Mapa ɨnde ma ahá e, a ko kʉte ma. Ma ngahaha me okpála na doto sia mʉkobho.» ");
INSERT INTO mdm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lɨ omaYuda adje ’ngʉ́ bhomʉ-o lɨe, u aholo amene kpekebhɵ sʉnda o kpekpeke. U adʉ apa me: «Lele pɨ kpála ɨnde-e tɨ da naha kʉte e lɨe pɨ nɨ́ me nɨ́ zʉ-o?» ");
INSERT INTO mdm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Abhomʉ-o, Yesu apa pɨ uo me: «A moko, ma apa pɨ yi na paká me: ɨ dʉ me yi nde zʉ kʉte ma, Ndɨlɨ gba kpála de-e, ɨ dʉ la di me yi nde ndjɨ ngʉte ma de-e, yi dʉ́ bhʉ́ mʉkobho de. ");
INSERT INTO mdm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kpála ɨnde ngazʉ kʉte ma, ɨnde la di ngandjɨ ngʉte ma-a, anɨ bhʉ́ mʉkobho na dʉdʉma. Ngama-a, ma azúku la di anɨ alɨ sokpɨ́. ");
INSERT INTO mdm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Padhá de, anga kʉte ma-a, a ko ezʉ na kʉkʉlʉ. Ngʉte ma la di-e, a ko ehe nandjɨ mandjɨ na kʉkʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kpála ɨnde ngazʉ kʉte ma, ɨnde la di ngandjɨ ngʉte ma-a, anɨ ngadʉ bhʉ́ ma. Ma la di ngadʉ bhʉ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","’Dyɨ ma ɨnde atima ma-a, anɨ ʉʉ. Ma la di ngadʉ bhʉ́ mʉkobho ka anɨ. A bhadi moko, kpála ɨnde azʉ́ ma-a, anɨ adʉ́ bhʉ́ mʉkobho ka ma. ");
INSERT INTO mdm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A bhomʉ-o mapa ɨnde ayie abhʉ́lá ko. A maka bhende lɨ onguo ogbi yi azʉ e, u atsia amu-o ade. Engʉ́ bini, kpála ɨnde azʉ́ mapa ɨnde-e, adʉ́ bhʉ́ mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu akpokpo ndʉ ’ngʉ́ bhomʉ-o lɨ nedhɨnga ɨnde anɨ adʉ asuno lɨe bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje bhʉ́ Kapalanauma-o. ");
INSERT INTO mdm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pɨta u adje engʉ́ ɨnde lɨ Yesu apa e lɨe, bhelé na omʉkpata gba anɨ-e atsia apa me: «Eli ɨnde-e, a kpekpeke! A tɨ da nazɨzɨba da?» ");
INSERT INTO mdm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Engʉ́ bini, Yesu ambɨla me omʉkpata gba nɨ-e ngamene kpekebhɵ pɨndjɨ ’ngʉ́ ango-o. Kaka-a, anɨ apa pɨ uo me: «Engʉ́ ango-o ngamene yi sisiti? ");
INSERT INTO mdm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A la yi u me ngama, Ndɨlɨ gba kpála-a, ma nde ngaꞌʉ lɨ bɨlɨ ɨnde ma adʉdʉ nanɨ lɨe kalanʉ-o? ");
INSERT INTO mdm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bua gba Ebhe-e ngaha mʉkobho ngae. Kpála-kʉtɨ tɨ da namene ’he bini de. Oeli ɨnde ma apa e pɨ yi bhomʉ-o, a ko Bua ɨnde ngaha mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Engʉ́ bini, okoko bhʉ́ ká yi bhuka de.» A na paká me Yesu ambɨla nanɨ nayie lɨ lilita me obhende ɨ bhuka nɨ de-e ngao dho. Anɨ atsia ambɨla la di me apʉ́ nɨ da-ie. ");
INSERT INTO mdm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Anɨ atsia apa matá me: «Kaka-a, ma apa nako pɨ yi me: ‹Kpála bini tɨ da nago gba ma de, ɨ dʉ me ’Dyɨ ma nde ha kpadjɨ pɨ anɨ ngae de ko.›» ");
INSERT INTO mdm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nayie lɨ nedhɨnga bhomʉ-o, bhelé na omʉkpata gba anɨ-e aꞌo ká anɨ. U kpata matá anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Abhomʉ-o, Yesu atsia ayi obhende ndjɨkpa ne ká bhisi-e me: «Ngayi di-e, yi akʉnda nagbida?» ");
INSERT INTO mdm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo Piele agie pɨ anɨ me: «Ngámá, ya tɨ da nanʉ gba da? A ka mʉ ne oeli ɨnde ngaha mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ngaya-a, ya abhuka. Ya atsia ambɨla la di me mʉ ne Kpála na bubu ɨnde lɨ Ebhe atima e ko.» ");
INSERT INTO mdm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu agie pɨ uo me: «Ngayi okpála ndjɨkpa ne ká bhisi-e, ma lo nako yi ngama dɨ? La-a, sʉka yi bini ne djabʉlʉ!» ");
INSERT INTO mdm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Anɨ adʉ apa ’ngʉ́ bhomʉ-o lɨ Yuda, ndɨlɨ gba Simo Isɨkaliote. Padhá de, anga belegʉ anɨ adʉ lɨe sʉka omʉkpata ndjɨkpa ne ká bhisi-e, adʉ kpála ɨnde apʉ́ Yesu-o ngae. ");
INSERT INTO mdm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pɨpɨta-a, Yesu aholo nadholo bhʉ́ ndu doto na Galilaya. Anɨ dʉ akʉnda nadholo bhʉ́ ndu doto na Yudaya de, anga omaYuda adʉ akʉnda nabhɵlɵ anɨ oo. ");
INSERT INTO mdm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A adʉ me, anokomɨa na otɨ ngbangbalɨ gba omaYuda nde akolo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Abhomʉ-o, ondaise Yesu atsia apa pɨ anɨ me: «Yie sɨ yiyie. Nʉ bhʉ́ ndu doto na Yudaya, ngʉbula me omʉkpata gba mʉ-o, ngauo di-e, u u ngamba ’ngʉ́ ɨnde mʉ ngamene e ko. ");
INSERT INTO mdm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Padhá de, anga kpála ɨnde akʉnda me okpála u ngamba ’ngʉ́ ɨnde nɨ ngamene e mau-o, anɨ méne bhʉ́ pepe de. Ɨ nde lɨe me mʉ nde ngamene ngua ngamba ’ngʉ́ bhomʉ-o, mene kala ndʉ okpála hana!» ");
INSERT INTO mdm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Padhá de, anga ondaise anɨ-e, ngauo makpe-e, u bhuka nanɨ anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Nedhɨnga gba ma-a kolo nga de. Engʉ́ bini, pɨ yi-e, nedhɨnga ndʉ ’kpɨ́ hana ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Okpála na doto tɨ da nayala yi de. La mʉma-a, u ngayala ma. Padhá de, anga ma ngapa me kulu gba uo-o ndjɨndjɨ ade. ");
INSERT INTO mdm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yi nʉ bhʉ́ anokomɨa-a nʉnʉ. Ngama-a, ma nʉ́-ʉ de. Padhá de, anga nedhɨnga gba ma-a kolo nga de.» ");
INSERT INTO mdm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pɨta anɨ apa lɨe mo-o, anɨ atsia atigala bhʉ́ ndu doto na Galilaya. ");
INSERT INTO mdm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lɨ ondaise Yesu agbida lɨe bhʉ́ anokomɨa-a, anɨ atsia anʉ di oo. La-a, anɨ suno lɨe mbámbá de. Anɨ adʉ me anɨ nde awo lɨe mawo. ");
INSERT INTO mdm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Abhomʉ-o, omaYuda adʉ agɨlɨ anɨ bhʉ́ nedhɨnga na anokomɨa-o. U adʉ ayi me: «Anɨ su?» ");
INSERT INTO mdm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","U adʉ amene kpekebhɵ naali lɨ ’ngʉ́ gba anɨ-e bhʉ́ ká okpála. Okoko adʉ apa me: «A ko bádha kpála.» Okoko adʉ apa me: «A mo-o ade, anɨ ngapite okpála.» ");
INSERT INTO mdm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Engʉ́ bini, u dʉ apa engʉ́ ango-o mbámbá de. Padhá de, anga u adʉ akpe omaYuda. ");
INSERT INTO mdm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nedhɨnga lɨ anokomɨa akolo lɨe tʉtʉ-o, Yesu anʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda, anɨ atsia aholo nasuno pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Abhomʉ-o, omaYuda angamba naali. U atsia adʉ ayi lɨo me: «Kpála ɨnde-e mene balʉa de. Anɨ ambɨla la ’he me-e lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu agie pɨ uo me: «Nasuno gba ma-a ngayie ka ma ade. Engʉ́ bini, a ngayie ka Kpála ɨnde atima ma ko. ");
INSERT INTO mdm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɨ dʉ me kpála nde akʉnda namene engʉ́ ɨnde lɨ Ebhe akʉnda e-e, anɨ tɨ da nambɨla me, ne me ayie ka Ebhe, ne me ma ngakpokpo ’ngʉ́ gba ma makpe. ");
INSERT INTO mdm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kpála bhende ngakpokpo ’ngʉ́ gba e makpe-e, anɨ ngagɨlɨ me okpála dhɵgɵ nɨ. Engʉ́ bini, kpála bhende ngagɨlɨ me u dhɵgɵ kpála bhende atima nɨ-e, anɨ ngapa ’ngʉ́ na kʉkʉlʉ. Anɨ pa la di eu de. ");
INSERT INTO mdm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moidje aha nanɨ lɨ́lɨ pɨ yi ngae. A mo-o adɨ? La-a, kpála bini bhʉ́ ká yi ngamene lɨ́lɨ ango-o ade. Yi la ngagɨlɨ nabhɵlɵ ma ngʉbula nɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Okpála agie pɨ anɨ me: «A bhʉ́ mʉ ne siti bua ! A ngagɨlɨ nabhɵlɵ mʉ da?» ");
INSERT INTO mdm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu agie pɨ uo me: «Ma amene bha koli ngamba ’ngʉ́ bini má kpɨkɨlɨ, ndʉ yi hana yi atsia aholo nangamba! ");
INSERT INTO mdm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moidje aha nanɨ lɨ́lɨ pɨ yi me, yi dʉ nato ongɨsɨ na bhosɨbhosɨ-e bhʉ́ gandja. Engʉ́ bini, lɨ́lɨ ango-o yie ka Moidje de. A ayie ka onguo ogbi yi. Kaka-a, yi ngazɨba nato kpála bhʉ́ gandja belegʉ bhʉ́ ’kpɨ́ naguo gba omaYuda . ");
INSERT INTO mdm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yi ngato kpála bhʉ́ gandja bhʉ́ ’kpɨ́ naguo ngʉ́ nakpe me yi agʉ́mʉ lɨ́lɨ gba Moidje-e de. Ngama-a, ma akobho kpála-kʉtɨ libhomu bhʉ́ ’kpɨ́ naguo. Yi la ngake ’ngʉ́ lɨyi mʉma tété ngʉ́ nɨ? ");
INSERT INTO mdm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yi akódho ’ngʉ́ maka yi ngauu lɨe de. Engʉ́ bini, yi kodho ’ngʉ́ ngbingbili!» ");
INSERT INTO mdm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Abhomʉ-o, okpála koko na gʉdhʉ na Yelusalema adʉ apa me: «A oo kpála ɨnde u ngagɨlɨ nabhɵlɵ e dɨ? ");
INSERT INTO mdm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yi tsitsia nga, anɨ ngagama ’ngʉ́ mbámbá bhʉ́ ká okpála. La-a, u pa ’ngʉ́ pɨ anɨ belegʉ de bini! Ongámásɨ gba nɨ́-e ambɨla bha ndjʉ sɨ ndjɨndjɨ me Masɨya ngae ɨnde-e? ");
INSERT INTO mdm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Padhá de, anga bɨlɨ lɨ kpála ɨnde-e ayie lɨ e, ya mbɨla hana. Engʉ́ bini, nedhɨnga ɨnde lɨ Masɨya agó lɨe, kpála bini mbɨ́la bɨlɨ ɨnde anɨ ayíe lɨ e de.» ");
INSERT INTO mdm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Lɨ nedhɨnga bhomʉ-o, Yesu adʉ asuno bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. Abhomʉ-o, anɨ atsia asʉla me: «Yi mbɨla bha ndjʉ ma ndjɨndjɨ? Yi mbɨla la di bɨlɨ ɨnde ma ayie lɨ e hana? Padhá de, anga ngama-a, ma go bhʉ́ angu gba ma makpe-e de. Engʉ́ bini, kpála ɨnde atima ma-a, a ko kpála na ngbingbili . Kpála ango-o, yi mbɨla anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngama-a, ma mbɨla anɨ ndjɨndjɨ. Padhá de, anga ma ayie agba anɨ. Anɨ atima la di ma ngae.» ");
INSERT INTO mdm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Abhomʉ-o, u adʉ agɨlɨ me, o holo anɨ. La-a, kpála bini bu ’kpa e lɨ kʉte anɨ de. Padhá de, anga nedhɨnga gba anɨ-e le nga nanɨ-ɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","La-a, okpála bhelé bhʉ́ ká bhiti okpála bhomʉ-o abhuka anɨ. U adʉ apa me: «Nedhɨnga lɨ Masɨya agó lɨe, anɨ améne ongamba ’ngʉ́ ané obhende lɨ kpála ɨnde-e amene e?» ");
INSERT INTO mdm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","OmʉFalisai adje engʉ́ ɨnde lɨ okpála adʉ apa e bhʉ́ tʉpele lɨ ’ngʉ́ gba Yesu-o. Abhomʉ-o, ongbengbe odimandɵ di ne omʉFalisai atima omʉlila na ’ngbé ’tɨ Ebhe gba omaYuda ngʉ́ naholo anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu atsia apa me: «Ma adʉ́ nga matá ne yi ngʉbula nedhɨnga bedɨ. Pɨpɨta-a, ma tsia tápa agba kpála ɨnde atima ma ko. ");
INSERT INTO mdm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yi agɨ́lɨ ma, engʉ́ bini, yi ú la ma de. Padhá de, anga yi tɨ da nanʉ lɨ bɨlɨ ɨnde ma adji lɨ e de.» ");
INSERT INTO mdm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Abhomʉ-o, omaYuda atsia ayi lɨo sʉnda o me: «Anɨ anʉ́ lɨ bɨlɨ bhedho ɨnde nɨ́ tɨ da nau anɨ lɨe de-e? Anɨ anʉ́ nabhaka omaYuda bhende atsambala bhʉ́ ká oGiliki-e? Anɨ anʉ́ asuno pɨ oGiliki? ");
INSERT INTO mdm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Oeli ɨnde anɨ apa e me: ‹Yi agɨ́lɨ ma, engʉ́ bini, yi ú la ma de, anga yi tɨ da nanʉ lɨ bɨlɨ ɨnde ma adji lɨ e de.› A akʉnda napa pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ekpɨ́ na soso na anokomɨa-a, a adʉ ekpɨ́ na ngbéngbé. Lɨ ’kpɨ́ ango-o, Yesu alʉ malʉ, anɨ asʉla me: «Ɨ dʉ me kpála nde ne gʉmʉ ’ngu-o, a ayo me, anɨ go bhaka ma, amba anɨ ndjɨ! ");
INSERT INTO mdm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kpála bhende ngabhuka ma-a, maka lɨ Bhuku gba Ebhe-e apa lɨe me: ‹Engu adʉ́ aze lɨ bua anɨ. Engu ango-o, a ko engu na mʉkobho.›» ");
INSERT INTO mdm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Yesu adʉ apa ’ngʉ́ bhomʉ-o lɨ Bua gba Ebhe ɨnde lɨ okpála ɨnde abhúka anɨ asía e-o. Lɨ nedhɨnga bhomʉ-o, Bua gba Ebhe-e go nga nanɨ-ɨ de. Padhá de, anga Yesu nde sia nga nanɨ sangu gba e de.) ");
INSERT INTO mdm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Okpála adje oeli ɨnde lɨ Yesu apa e-o. Okpála koko bhʉ́ ká uo atsia apa me: «Kpála ɨnde-e bha ndjʉ ne polofeta ɨnde ya ngadjeke e kʉkʉlʉ!» ");
INSERT INTO mdm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Okoko atsia apa me: «A ko Masɨya!» Engʉ́ bini, okpála koko atsia apa matá me: «Masɨya tɨ da nayie bhʉ́ ndu doto na Galilaya? ");
INSERT INTO mdm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Padhá de, anga Bhuku gba Ebhe-e apa me, Masɨya adʉ́ sʉka okpála na piga gba Davidi. Anɨ ayíe la di bhʉ́ Beteleme, kʉtɨ ɨnde lɨ Davidi abhele bhʉ́ e ko.» ");
INSERT INTO mdm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Abhomʉ-o, okpála atsia agbogbo bhʉsʉ o lɨ ’ngʉ́ gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Okoko bhʉ́ ká uo adʉ akʉnda me, o holo anɨ. Engʉ́ bini, kpála bini bu ’kpa e lɨ anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Abhomʉ-o, omʉlila na ’ngbé ’tɨ Ebhe gba omaYuda-a agie lɨo agba ongbengbe odimandɵ, di ne omʉFalisai-o. U atsia ayi omʉlila-a me: «Yi go ne Yesu de ngʉbula nɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Omʉlila-a agie me: «Kpála ɨnde agama ’ngʉ́ maka kpála bhomʉ-o belegʉ ade bini!» ");
INSERT INTO mdm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Abhomʉ-o, omʉFalisai atsia agie pɨ uo me: «Ngayi di-e, yi aꞌo di me anɨ pite yi? ");
INSERT INTO mdm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bhʉ́ ká ongámásɨ, ɨ dʉ di-e bhʉ́ ká omʉFalisai-e, kpála bini abhuka anɨ uu? ");
INSERT INTO mdm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Engʉ́ bini, bhiti okpála bhende abhuka anɨ bhomʉ-o, u mbɨla lɨ́lɨ gba Moidje de. Ebhe abála uo mabala.» ");
INSERT INTO mdm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemʉ-o, a ko sʉka omʉFalisai. Anɨ anʉ la di nanɨ kalanʉ abhaka Yesu-o ngae. Anɨ apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Lɨ́lɨ gba nɨ́-e zɨba naholo kpála padhá de. A ayo ngaɨza me nɨ́ dje anɨ, amba nɨ́ mbɨla la di engʉ́ ɨnde anɨ amene e ko.» ");
INSERT INTO mdm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","U agie pɨ anɨ me: «Ngamʉ di-e, mʉ ne kpála na ndu doto na Galilaya? Tanga nga oBhuku gba Ebhe-e ndjɨndjɨ. Mʉ ú de me, polofeta bini ayie bhʉ́ ndu doto na Galilaya de.»  ");
INSERT INTO mdm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pɨpɨta-a, kpála ne kpála atsia agie lɨe agba e. ");
INSERT INTO mdm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Abhomʉ-o, Yesu anʉ apɨ́ ’ta na ondula na Olive. ");
INSERT INTO mdm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lɨ ekpɨ́ aseke lɨe, bhʉ́ sɨkɨkpɨ-e, anɨ agie lɨe bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. Ndʉ okpála hana adyudyo lɨo de anɨ masɨkpe. Yesu adʉ kuto, anɨ atsia aholo nasuno pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abhomʉ-o, omʉsuno na lɨ́lɨ gba Moidje , di ne omʉFalisai ago ne ɵlɵ bini. U akoto lɨ ɵlɵ ango-o bha lɨ nedhɨnga u adʉ akʉnda lɨo lɨe ne bhoko koko. U aha anɨ, u atsia aꞌo anɨ kala ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Do uo pɨ Yesu me: «Mʉsuno, u akoto lɨ ɵlɵ ɨnde-e bha lɨ nedhɨnga u adʉ akʉnda lɨo lɨe ne bhoko koko. ");
INSERT INTO mdm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moidje aye nanɨ pɨ ya bhʉ́ lɨ́lɨ-e me, a ayo nabhili ongua olɨsɨ bhomʉ-o ne teme. Ngamʉ-o, mo opa naamʉ tété pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","U adʉ apa engʉ́ bhomʉ-o ngʉ́ naꞌo ekú ngʉ́ anɨ. Padhá de, anga u adʉ agɨlɨ nau engʉ́ ɨnde u aꞌó e pɨ́ anɨ-o. Engʉ́ bini, Yesu akita ne kuto, anɨ aholo naye ’he kuto bhʉ́ doto ne lɨkpa e. ");
INSERT INTO mdm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","La-a, u azɨ bha kekele lɨ nayi anɨ. Abhomʉ-o, anɨ ayie bhʉ́lá, anɨ atsia apa pɨ uo me: «A ayo me kpála ɨnde bhʉ́ ká yi, ɨ mene nga naae siti ’ngʉ́ bini de-e, anɨ tʉlʉ anɨ ne teme na kalanʉ-o ngae.» ");
INSERT INTO mdm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pɨpɨta-a, Yesu akita matá ne kuto, anɨ atsia aholo bha naye ehe kuto bhʉ́ doto. ");
INSERT INTO mdm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lɨ u adje oeli bhomʉ-o lɨe, ndʉ uo hana atsia aholo ayie bini ne bini. Akpo nayie ne obhelesɨ okpála. Yesu atigala bha ngae kpi e kpi. Ɵlɵ ango-o atsia adʉ la bhadi lɨ bɨlɨ ɨnde u aꞌo anɨ lɨ e bhomʉ. ");
INSERT INTO mdm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Abhomʉ-o, Yesu ayie matá bhʉ́lá, anɨ ayi ɵlɵ ango-o me: «Okpála ango-o su? Kpála bini kodho ’ngʉ́ gba mʉ-o sisiti dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɵlɵ ango-o agie me: «Mʉsuno, ma u kpála bini de.» Do Yesu pɨ anɨ me: «Ngama di-e, ma kódho ’ngʉ́ gba mʉ-o sisiti de. Mʉ tɨ da natapa. La-a, nayie pɨ mbɨa ɨnde-e, mo oméne matá siti ’ngʉ́ belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Abhomʉ-o, Yesu apa matá pɨ bhiti okpála-a me: «Ngama-a, ma ne zɨ ’ke pɨ okpála na pɨ́la doto. Kpála ɨnde ngakpata ma-a, anɨ dhʉ́kʉ bhʉ́ biti de. Engʉ́ bini, a adʉ́ ka anɨ ne zɨ ’ke na mʉkobho.» ");
INSERT INTO mdm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abhomʉ-o, omʉFalisai atsia apa pɨ anɨ me: «Mʉ ngakpokpo bhomʉ-o naamʉ ’ngʉ́ makpe! Engʉ́ ɨnde mʉ ngakpokpo e bhomʉ-o, tata tété ade!» ");
INSERT INTO mdm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu agie pɨ uo me: «A na paká moko me ma ngakpokpo ’ngʉ́ gba ma makpe. La-a, engʉ́ ɨnde ma ngakpokpo e, a ko kʉkʉlʉ ’ngʉ́. Padhá de, anga ma mbɨla bɨlɨ ɨnde ma ayie lɨ e, di ne bɨlɨ ɨnde ma adji lɨ e ndjɨndjɨ. Engʉ́ bini, ngayi-e, yi mbɨla bɨlɨ ɨnde ma ayie lɨ e de. Yi mbɨla la di bɨlɨ ɨnde ma adji lɨ e de. ");
INSERT INTO mdm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yi ngakodho ’ngʉ́ maka okpála. Ngama-a, ma kodho ’ngʉ́ gba kpála bini de. ");
INSERT INTO mdm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ɨ dʉ la me, ma nde akodho ’ngʉ́-o, nakodho ’ngʉ́ gba ma-a dʉ́ ngbingbili. Padhá de, anga ma kpi ma kpi ade, engʉ́ bini, ’Dyɨ ma ɨnde atima ma-a, ya ne anɨ bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","U aye bhʉ́ lɨ́lɨ gba yi makpe-e me: ‹Ɨ dʉ me okpála bhisi nde akpokpo ’ngʉ́-o, engʉ́ ango-o dʉ́ ngbingbili.› ");
INSERT INTO mdm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma ngakpokpo naama ’ngʉ́ makpe. ’Dyɨ ma ɨnde atima ma-a, ngakpokpo la di engʉ́ gba ma ko.» ");
INSERT INTO mdm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Abhomʉ-o, u ayi anɨ me: «’Dyɨ mʉ su?» Yesu agie pɨ uo me: «Yi mbɨla ma de. Yi mbɨla la di ’Dyɨ ma de. Yi mbɨ́la ma uu-o, yi de ambɨla di ’Dyɨ ma ambɨla.» ");
INSERT INTO mdm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu apa ’ngʉ́ bhomʉ-o lɨ nedhɨnga anɨ adʉ asuno lɨe bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda, lɨ bɨlɨ lɨ osanduku ɨnde u adʉ aꞌo tɨa bhʉ́ e adʉ lɨ e-o. Kpála bini tsia bu nanɨ ’kpa e lɨ anɨ de, anga nedhɨnga gba anɨ-e kolo nga nanɨ-ɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Abhomʉ-o, Yesu atsia apa matá pɨ uo me: «Ma adji. Yi agɨ́lɨ ma. La-a, yi amú bhʉ́ siti ’ngʉ́ gba yi-o. Yi tɨ da nanʉ lɨ bɨlɨ ɨnde ma adji lɨ e de.» ");
INSERT INTO mdm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","OmaYuda atsia ayi lɨo sʉnda o me: «Anɨ abhɵ́lɵ lɨe ne tɨtɨ e? Kaka-a, anɨ apa me bɨlɨ ɨnde nɨ adji lɨ e, nɨ́ tɨ da nakolo tété dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu agie pɨ uo me: «Ngayi-e, yi ayie kuto sɨ. Engʉ́ la bini, ngama-a, ma ayie abhʉ́lá. Ngayi-e, yi ne okpála na pɨ́la doto. Engʉ́ la bini, ngama-a, ma ne kpála na pɨ́la doto ade. ");
INSERT INTO mdm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kaka-a, ma apa ɨgɨnɨ pɨ yi me, yi amú bhʉ́ siti ’ngʉ́ gba yi ko. Padhá de, anga ɨ dʉ me yi nde bhuka de me Ma uu-o de-e, yi amú bhʉ́ siti ’ngʉ́ gba yi ko.» ");
INSERT INTO mdm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Abhomʉ-o, u ayi anɨ me: «Ngamʉ-o, mʉ ne da?» Yesu agie pɨ uo me: «A ko bha engʉ́ ɨnde ma apa e pɨ yi, nayie lɨ lilita-o. ");
INSERT INTO mdm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ma ne engʉ́ bhelé napapa, di ne nakokodho lɨ ’ngʉ́ gba yi ko. Engʉ́ bini, ma ngapa pɨ okpála engʉ́ ɨnde ma adje e ka kpála ɨnde atima ma ko. Ngaanɨ-e, anɨ ngapa ngbili ’ngʉ́ .» ");
INSERT INTO mdm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","U mbɨla de me anɨ ngapa pɨ o bhomʉ-o engʉ́ gba ’Dyɨ e de. ");
INSERT INTO mdm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Nedhɨnga yi aꞌéꞌe ma, Ndɨlɨ gba kpála lɨe ne abhʉ́lá-a, yi tsia mbɨ́la me ngama-a, ma uu. Yi mbɨ́la la di me, ma mene ehe bini bhʉ́ angu gba ma makpe de. Engʉ́ bini, ma ngapa bha bini engʉ́ ɨnde lɨ ’Dyɨ ma asuno e mʉma ko. ");
INSERT INTO mdm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ya ne kpála ɨnde atima ma-a bhʉ́ dabɨlɨ bini. Anɨ ꞌo ká ma kpi ma kpi de. Padhá de, anga ma ngamene ndʉ ’kpɨ́ hana engʉ́ ɨnde ɨ nganga lɨ anɨ manga ko.» ");
INSERT INTO mdm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Abhomʉ-o, okpála bhelé ɨnde adje Yesu ngapa ’ngʉ́ bhomʉ-o, atsia abhuka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Abhomʉ-o, Yesu atsia apa pɨ omaYuda ɨnde abhuka nanɨ anɨ-e me: «Ɨ dʉ me yi nde alila eli ɨnde ma ngapa e pɨ yi-e ndjɨndjɨ-e, yi dʉ́ omʉkpata gba ma-a na kʉkʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yi mbɨ́la la di ngbili ’ngʉ́. Lɨ ngbili ’ngʉ́-o tsia gbégbe yi bhʉ́ bali.» ");
INSERT INTO mdm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","U agie pɨ anɨ me: «Ya ne odi Abalahama. Ya dʉ nga bali pɨ kpála belegʉ de bini. Lele pɨ mʉ tɨ da napa lɨe pɨ ya me, ya azé bhʉ́ bali maze-e?» ");
INSERT INTO mdm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu agie pɨ uo me: «A moko, ma apa pɨ yi na paká me: ndʉ kpála hana ɨnde ngamene siti ’ngʉ́-o, a ko bali ka siti ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Bali ngadʉ bhʉ́ piga ndʉ ’kpɨ́ hana ade. Engʉ́ bini, ndɨlɨ na bhobhoko ngadʉ ndʉ ’kpɨ́ hana bhʉ́ piga. ");
INSERT INTO mdm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kaka-a, ɨ dʉ me Ndɨlɨ-e nde agbegbe yi bhʉ́ bali-e, yi tsia zé bhʉ́ bali kʉkʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma mbɨla hana me, yi ne odi Abalahama. Engʉ́ la bini, yi ngagɨlɨ nabhɵlɵ ma. Padhá de, anga yi ngayala ’li ma. ");
INSERT INTO mdm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngama-a, ma ngakpokpo engʉ́ ɨnde lɨ ’Dyɨ ma asuno e mʉma ko. La ngayi-e, yi ngamene engʉ́ ɨnde lɨ ’dyɨ yi apa e pɨ yi ko.» ");
INSERT INTO mdm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Abhomʉ-o, u atsia agie pɨ anɨ me: «’Dyɨ ya-a, a ko Abalahama.» Do Yesu pɨ uo me: «Ɨ dʉ́ me yi dʉ́ ne odi Abalahama-a, yi de méne ’ngʉ́ maka Abalahama. ");
INSERT INTO mdm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Engʉ́ bini, mbɨa ɨnde-e, yi ngakʉnda nabhɵlɵ ma, abana ma apa kʉkʉlʉ ’ngʉ́ ɨnde ma adje e ka Ebhe lɨe pɨ yi-o. Abalahama mene la nanɨ mo-o de. ");
INSERT INTO mdm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Engʉ́ bini, ngayi-e, yi ngamene bhadi ngua kulu ɨnde lɨ ’dyɨ yi ngamene e-o.» U atsia agie pɨ anɨ me: «Ya ne ongɨsɨ na ngongo ade. Koli ’dyɨ ya bha bini, Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu apa pɨ uo me: «Lɨ Ebhe dʉ́ bha ndjʉ ne ’Dyɨ yi-e, yi de akʉnda ma. Padhá de, anga ma ayie agba Ebhe. Ma la di sɨ bhʉ́ ngʉ anɨ. Ma go bhʉ́ ngʉ ma de. Engʉ́ bini, anɨ atima ma ngae. ");
INSERT INTO mdm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yi mbɨla engʉ́ ɨnde ma ngapa e pɨ yi-e de ka nɨ? A ko anga, yi tɨ da nadje eli ɨnde ma ngapa e pɨ yi-e de. ");
INSERT INTO mdm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","’Dyɨ yi ne Djabʉlʉ. Yi la di ngamene ’ngʉ́ ɨnde lɨ ’dyɨ yi akʉnda e-o. A ko bhʉlʉ nabhɵlɵ kpála nayie lɨ lilita. Anɨ lʉ bhʉ́ kʉkʉlʉ ’ngʉ́ belegʉ de bini. Padhá de, anga kʉkʉlʉ ’ngʉ́ bhʉ́ anɨ ade. Nedhɨnga ɨnde anɨ ngapa eu lɨe, anɨ ngapa ’ngʉ́ gba e makpe. Padhá de, anga a ko kpála na eu. A ko la di ’dyɨ eu. ");
INSERT INTO mdm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Engʉ́ bini, ngama-a, ma ngapa kʉkʉlʉ ’ngʉ́. Yi ngabhuka ma ade kaka. ");
INSERT INTO mdm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A ko kpála bhedho bhʉ́ ká yi-e, ɨ tɨ da nasuno siti ’ngʉ́ ɨnde ma amene e? Ɨ dʉ me ma nde ngapa kʉkʉlʉ ’ngʉ́-o, ka nɨ yi bhuka la ma lɨe de-e? ");
INSERT INTO mdm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kpála gba Ebhe-e ngadje ’li Ebhe. Engʉ́ bini, yi ne okpála gba Ebhe ade. Kaka-a, yi ngadjedje ade.» ");
INSERT INTO mdm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","OmaYuda agie pɨ Yesu me: «Ya apa kʉkʉlʉ ’ngʉ́ de me mʉ ne kpála na Samalɨa, a la di bhʉ́ mʉ ne siti bua ?» ");
INSERT INTO mdm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu agie pɨ uo me: «Siti bua bhʉ́ ma ade. Engʉ́ bini, ma ngadhɵgɵ ’Dyɨ ma. La-a, ngayi-e, yi ngayala nadhɵgɵ ma. ");
INSERT INTO mdm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngama-a, ma gɨlɨ de me okpála dhɵgɵ ma-a de. ’Dyɨ ma ngagɨgɨlɨ mʉma ngae. Anɨ la di ngakodho ’ngʉ́-o ngae. ");
INSERT INTO mdm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A moko, ma apa pɨ yi na paká me: kpála ɨnde alila eli ɨnde ma ngapa e, anɨ kpí dʉdʉma de.» ");
INSERT INTO mdm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","OmaYuda atsia apa pɨ anɨ me: «Mbɨa ɨnde-e, ya ambɨla la kʉkʉlʉ me abhʉ́ mʉ ne siti bua! Abalahama akpi. Opolofeta di amu. La ngamʉ-o, mʉ ngapa me: ‹Kpála ɨnde ngalila eli ɨnde ma ngapa e, anɨ kpí dʉdʉma de.› ");
INSERT INTO mdm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","’Dyɨ ya Abalahama akpi. Mʉ ngabhundja me nɨ ngbéngbé ane anɨ? Opolofeta di amu. Mʉ la ngau nga naamʉ lɨmʉ me nɨ ne da?» ");
INSERT INTO mdm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu agie pɨ uo me: «Ɨ dʉ me, ma dʉ adhɵgɵ lɨma ngama makpe-e, nadhɵgɵ gba ma-a de padhá. ’Dyɨ ma ngadhɵgɵ ma ngae, a ko kpála ɨnde yi ngaꞌɨ e me: ‹A ko Ebhe gba ya-o› ");
INSERT INTO mdm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","me yi nde mbɨla la anɨ de ko. Engʉ́ bini ngama-a, ma mbɨla anɨ hana. Ɨ dʉ́ me ma pá me ma mbɨla anɨ de-e, ma de ne kpála na eu maka yi. Engʉ́ bini, ma mbɨla anɨ hana. Ma la di ngalila eli ɨnde anɨ ngapa e-o. ");
INSERT INTO mdm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","’Dyɨ yi Abalahama akpi nanɨ djalɨ naali. Padhá de, anga anɨ adʉ abhundja me nɨ aú ekpɨ́ nago gba ma-o. Anɨ au, anɨ atsia akpi djalɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Abhomʉ-o, omaYuda atsia apa pɨ anɨ me: «Ngamʉ-o, mʉ kolo nga ne kalanga ndjɨkpa bhuluvue de. Mʉ la ngapa me, nɨ au Abalahama!» ");
INSERT INTO mdm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu agie pɨ uo me: «A moko, ma apa pɨ yi na paká me kala me u zu Abalahama, ‹Ma uu.›» ");
INSERT INTO mdm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Abhomʉ-o, u abha teme ngʉbula natʉtʉlʉ anɨ ne di. Engʉ́ bini, Yesu awo lɨe, anɨ atsia akoto bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. ");
INSERT INTO mdm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lɨ Yesu adʉ akodho ’kpɨ́ lɨe lɨ kpadjɨ-e, anɨ au kpála bini ɨnde u azu e me anɨ nde u ’kpɨ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Omʉkpata gba anɨ ayi anɨ me: «Mʉsuno, u azu kpála ɨnde-e me anɨ nde u ’kpɨ́ de ka nɨ? A ko ka siti ’ngʉ́ gba anɨ makpe, ne me a ko ka siti ’ngʉ́ gba okpála ɨnde azu anɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu agie me: «A ko ka siti ’ngʉ́ gba anɨ-e de. A ko la di ka siti ’ngʉ́ gba okpála ɨnde azu anɨ-e de. Engʉ́ bini, u azu anɨ mo-o ngʉbula me okpála u ngamba ’ngʉ́ ɨnde lɨ Ebhe ngamene e bhʉ́ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A ayo me nɨ́ mene kulu gba kpála ɨnde atima ma-a nedhɨnga lɨ ekpɨ́ nde nga lɨe ne ngbɨkpɨ-o. Padhá de, anga biti ngago, kpála bini tɨ da namene kulu de. ");
INSERT INTO mdm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nedhɨnga ma nde nga lɨe pɨ́la doto-o, ma ne zɨ ’ke pɨ okpála na pɨ́la doto.» ");
INSERT INTO mdm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pɨta anɨ apa lɨe mo-o, anɨ aku ngʉsʉ bhʉ́ doto. Anɨ akpɵdhɵlɵ doto ne di. Anɨ aha ngbɵdhɵ ango-o, apulu pɨ́ kó djila kpála ɨnde ɨ u ’kpɨ́ de ko. ");
INSERT INTO mdm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Nʉ vʉlʉ bhʉ́la mʉ bhʉ́ ’dú ’ngu navʉlʉ kʉte na Siloe.» (ꞌƗlɨ bhomʉ-o akʉnda napa me «U atima anɨ.») Anɨ anʉ, anɨ atsia avʉlʉ bhʉ́la e. Anɨ agie lɨe me anɨ nde ngau ’kpɨ́ ndjɨndjɨ! ");
INSERT INTO mdm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Okpála bhende asɨlɨ kʉtɨ lɨngo anɨ, di ne obhende au anɨ kalanʉ me anɨ nde ne yoyo ’he-e, a adʉ ayi me: «A ɨnde-e kpála adʉ nako adʉ kuto ngʉ́ nayo ’he-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Okoko adʉ apa me: «A ko anɨ.» Do okpála koko me: «A ko anɨ de. Engʉ́ bini, anɨ mana anɨ.» La-a, kpála ango-o adʉ apa me: «A ko bha-a ma.» ");
INSERT INTO mdm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Abhomʉ-o, u ayi anɨ me: «Djila mʉ abhulu lɨe lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Anɨ atsia agie me: «Kpála ɨnde u aꞌɨ e me Yesu-o, amene ngbɵdhɵ, anɨ apulu pɨ́ kó djila ma. Anɨ atsia apa mʉma me: ‹Nʉ vʉlʉ bhʉ́la mʉ bhʉ́ Siloe.› Ma anʉ oo. Pɨta ma avʉlʉ lɨma lɨe, ma aholo nau ’kpɨ́!» ");
INSERT INTO mdm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","U ayi anɨ me: «Kpála ango-o su?» Anɨ agie me: «Ma mbɨla de.» ");
INSERT INTO mdm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Abhomʉ-o, u ago ne kpála ɨnde adʉ kalanʉ me anɨ nde u ’kpɨ́ de-e pɨ omʉFalisai . ");
INSERT INTO mdm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu amene nanɨ ngbɵdhɵ, anɨ atsia abhulu djila anɨ ne di me a nde la ekpɨ́ naguo gba omaYuda . ");
INSERT INTO mdm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Abhomʉ-o, omʉFalisai ayi di anɨ me djila anɨ aholo au ’kpɨ́ lele pɨ. Anɨ agie pɨ uo me: «Anɨ apulu ko djila ma ne ngbɵdhɵ. Ma avʉlʉ lɨma, ma atsia aholo au ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","OmʉFalisai koko atsia adʉ apa me: «Kpála amene engʉ́ ɨnde-e, anɨ yie agba Ebhe de. Padhá de, anga anɨ ngalila lɨ́lɨ na ekpɨ́ naguo ade.» Engʉ́ bini, okoko atsia adʉ apa naao me: «Kpála na sisiti tɨ da namene ngua ongamba ’ngʉ́ me-e lele pɨ?» U atsia agbogbo bhʉsʉ o. ");
INSERT INTO mdm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Abhomʉ-o, omʉFalisai ayi matá kpála ɨnde lɨ djila e abhulu-o me: «A la mʉ-o, mo opa naamʉ lɨ ’ngʉ́ gba kpála ɨnde abhulu djila mʉ-o pɨ?» Anɨ agie me: «A ko polofeta .» ");
INSERT INTO mdm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Engʉ́ bini, ongámásɨ gba omaYuda kʉnda nanɨ nabhuka de me, anɨ adʉ me anɨ nde u ’kpɨ́ de, anɨ atsia aholo au ’kpɨ́-e de. Kaka-a, u atsia aꞌɨ okpála ɨnde azu anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","U ayi uo me: «Kpála ɨnde-e, a ko ndɨlɨ gba yi na paká? A na paká me yi azu anɨ me anɨ nde u ’kpɨ́ dɨ? Anɨ la ngau ’kpɨ́ mbɨa ɨnde-e lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Okpála ɨnde azu anɨ-e agie me: «Ya ambɨla me a ko ndɨlɨ gba ya. Ya azu anɨ me anɨ nde u ’kpɨ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Engʉ́ la bini, maka anɨ ngau ’kpɨ́ lɨe mbɨa ɨnde-e, ya mbɨla naaya de. Ya mbɨla la di de me abhulu djila anɨ da-ie de. Yi yi anɨ, anɨ abhele, anɨ tɨ da nakpokpo ’ngʉ́ gba e ngae makpe!» ");
INSERT INTO mdm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Okpála ɨnde azu anɨ-e apa nanɨ mo-o, anga u adʉ akpe omaYuda. Padhá de, anga omaYuda adje nanɨ lɨo me, ɨ dʉ me kpála nde azɨba me Yesu ne Masɨya , u de gbe anɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-e magbe. ");
INSERT INTO mdm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kaka-a, okpála ɨnde azu anɨ-e apa nanɨ me: «Anɨ abhele, anɨ tɨ da nakpokpo ’ngʉ́ gba e ngae makpe. Yi yi anɨ!» ");
INSERT INTO mdm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Abhomʉ-o, omʉFalisai aꞌɨ matá kpála ɨnde adʉ nako me anɨ nde u ’kpɨ́ de-o. U atsia apa pɨ anɨ me: «Dhɵgɵ Ebhe bhʉ́ napa kʉkʉlʉ ’ngʉ́. Ya ambɨla me kpála ɨnde akobho mʉ bhomʉ-o, a ko siti kpála.» ");
INSERT INTO mdm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kpála ango-o atsia agie me: «Ɨ dʉ siti kpála, ɨ dʉ siti kpála de, ma mbɨla naama de. La-a, ma ambɨla koli ’ngʉ́ bini: ma dʉ nako au ’kpɨ́ de, engʉ́ bini, mbɨa ɨnde-e, ma ngau ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Abhomʉ-o, u ayi matá anɨ me: «Anɨ amene ngʉ́ mʉ pɨ? Anɨ abhulu djila mʉ lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Anɨ agie pɨ uo me: «Ma apa ɨgɨnɨ pɨ yi apa. Engʉ́ bini, yi dje ma de. Yi akʉnda matá nadjedje ne toto-o? Atɨgala yi ngakʉnda me yi kolo di omʉkpata gba anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","U asosobho anɨ. U atsia apa pɨ anɨ me: «Mʉ mangbo ne mʉkpata gba kpála bhomʉ-o ngamʉ! Ngaya-a, ya naaya ne omʉkpata gba Moidje . ");
INSERT INTO mdm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ya ambɨla me Ebhe akpokpo ’ngʉ́ pɨ Moidje. Engʉ́ bini, ngaanɨ-e, ya mbɨla de me anɨ ayie naae su-oie de!» ");
INSERT INTO mdm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kpála ango-o agie pɨ uo me: «A ko ’ngʉ́ na ngangamba. Yi mbɨla bɨlɨ ɨnde anɨ ayie lɨ e de. La-a, anɨ abhulu djila ma! ");
INSERT INTO mdm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nɨ́ mbɨla hana me Ebhe djedje okpála na sisiti de. Engʉ́ bini, anɨ djedje ndʉ kpála hana ɨnde ngamanga anɨ, ɨnde di ngamene engʉ́ anɨ akʉnda e-o. ");
INSERT INTO mdm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nanɨ akpo lɨe, kpála bini dje nga de me u ngapa me kpála bini abhulu djila kpála ɨnde u azu e me anɨ nde u ’kpɨ́ de-e de. ");
INSERT INTO mdm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɨ dʉ́ me kpála ɨnde-e yíe agba Ebhe de-e, anɨ de tɨ́ da namene ’he bini de.» ");
INSERT INTO mdm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Abhomʉ-o, u agie pɨ anɨ me: «Ngamʉ-o, ’lá mʉ libhomu bhʉ́ siti ’ngʉ́ nayie maka nanɨ u azu mʉ lɨe. Mʉ la ngakʉnda nasuno ’ngʉ́ pɨ ya?» U atsia agbe anɨ bhʉ́ ’tɨ nadje lɨ́lɨ-e kilidjo. ");
INSERT INTO mdm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu adje me omʉFalisai agbe kpála ɨnde lɨ djila e akobho-o kilidjo. Yesu anʉ abhaka anɨ, anɨ atsia ayi anɨ me: «Mo obhuka Ndɨlɨ gba kpála-a abhuka?» ");
INSERT INTO mdm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Anɨ agie pɨ anɨ me: «Mʉsuno, kpála ango-o, a ko da, amba ma bhuka anɨ-e?» ");
INSERT INTO mdm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu agie pɨ anɨ me: «Mo ou anɨ au. Anɨ ngagama ’ngʉ́ ne mʉ mbɨa ɨnde-e ngae.» ");
INSERT INTO mdm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Do kpála ango-o me: «Ngámá, ma abhuka.» Anɨ atsia atʉtʉ lɨpʉkʉ e kuto kala Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Abhomʉ-o, Yesu atsia apa pɨ anɨ me: «Ma ago pɨ́la doto ngʉ́ nakodho ’ngʉ́. Ma ago ngʉbula me okpála bhende ɨ u ’kpɨ́ de-e, u u ’kpɨ́, amba okpála bhende ngau ’kpɨ́-e, ꞌo nau ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","OmʉFalisai ɨnde adʉ de anɨ oo, adje oeli bhomʉ-o. U atsia ayi anɨ me: «Ngaya di-e, ya u ’kpɨ́ dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu agie pɨ uo me: «Yi dʉ́ ne okpála bhende ɨ u ’kpɨ́ de-e, yi de bhʉ́ siti ’ngʉ́ ade. Engʉ́ bini, maka yi apa lɨe me: ‹Ya ngau ’kpɨ́-e›, yi nga bha ne okpála na sisiti.» ");
INSERT INTO mdm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu apa me: «A moko, ma apa pɨ yi na paká me: kpála ɨnde ɨ lɨ bhʉ́ aga gba okandɵlɵ lɨ bhɵbhɵ-o de-e, engʉ́ bini, ɨnde ngaꞌʉ lɨ pabu aga lɨ pápá koko-o, kpála ango-o ne bhʉlʉ ’zɨ. Anɨ la di ne bhʉlʉ nagbʉlʉ ’he gba okpála ne kpéke. ");
INSERT INTO mdm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kpála ɨnde alɨ la naae lɨ bhɵbhɵ-o, a ko mʉlila gba okandɵlɵ-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mʉlila na ’bhɵ aga-a ngaꞌʉꞌʉ pɨ anɨ. Okandɵlɵ-o ngadje la di ’li anɨ. Anɨ ngaꞌɨ okandɵlɵ gba e bini ne bini lɨ ’lɨ e. Anɨ la di ngapandja uo kilidjo. ");
INSERT INTO mdm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lɨ anɨ apandja uo hana lɨe kilidjo-o, anɨ kɵ́ kala uo, u tsia holo nakpata anɨ. Padhá de, anga u mbɨla ’li anɨ hana. ");
INSERT INTO mdm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Engʉ́ bini, kpála bhende u mbɨla e de-e, u kpáta anɨ de. U kpé de anɨ tsutsu. Padhá de, anga u mbɨla ’li anɨ de.» ");
INSERT INTO mdm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu akpokpo gbitaku bhomʉ-o pɨ okpála ɨnde adʉ adje anɨ-o. La-a, u mbɨla nanɨ ta engʉ́ ɨnde anɨ adʉ apa e pɨ uo-o de. ");
INSERT INTO mdm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Abhomʉ-o, Yesu atsia apa matá me: «A moko, ma apa pɨ yi na paká me: ma ne ’bhɵ aga gba okandɵlɵ-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndʉ okpála hana ɨnde ago mʉma kalanʉ-o, a ko obhʉlʉ ’zi. A ko la di obhʉlʉ nagbʉlʉ ’he gba okpála ne kpéke. Engʉ́ bini, okandɵlɵ-o dje uo de. ");
INSERT INTO mdm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngama-a, ma ne ’bhɵ bhotɨ. Kpála ɨnde alɨ́ lɨ pá bɨlɨ gba ma-a, anɨ kóbho. Anɨ tɨ́ da nalɨ, anɨ kóto, anɨ tsia sía di ehe nazʉ mazʉ. ");
INSERT INTO mdm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bhʉlʉ ’zi ago bha naae ngʉbula nazi ’he. Anɨ ago ngʉbula nabhɵbhɵlɵ mabhɵlɵ. Anɨ ago ngʉbula nasisiti masiti. La ngama-a, ma ago ngʉbula me okandɵlɵ sia mʉkobho, u sia mʉkobho ango-o bhelé. ");
INSERT INTO mdm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ma ne bádha mʉlila gba okandɵlɵ. Mʉlila na babadha gba okandɵlɵ-o bedhe ngʉ́ naha mʉkobho gba e pɨ okandɵlɵ gba e-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kpála ɨnde ngamene kulu bha bini ngʉbula tɨa-a, a ko kʉkʉlʉ mʉlila gba okandɵlɵ-o de. A ko okandɵlɵ ka anɨ de. Lɨ anɨ u me sia ngago-o, anɨ há holo, anɨ ꞌó ká uo. Abhomʉ-o, lɨ sia-a tɨ́ pɨ́ uo, anɨ tsia tsámbala uo. ");
INSERT INTO mdm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Padhá de, anga anɨ ngamene bha naae kulu ngʉbula tɨa. Anɨ la di ne ndjinga uo ade. ");
INSERT INTO mdm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngama-a, ma ne mʉlila na babadha gba okandɵlɵ. Maka lɨ ’Dyɨ ma ambɨla ma lɨe, ma atsia ambɨla di anɨ-e, ma ambɨla okandɵlɵ gba ma-o, okandɵlɵ gba ma-a atsia ambɨla di ma. Ma la di bedhe ngʉ́ naha mʉkobho gba ma-a pɨ okandɵlɵ gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A ka ma ne okandɵlɵ koko ɨnde bhʉ́ aga ɨnde-e ade. A ayo me ma go di ne uo. U adjé ’li ma. U akólo koli piga okandɵlɵ bini, u tsia dʉ́ ne koli mʉlila bini. ");
INSERT INTO mdm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Dyɨ ma ngakʉnda ma, anga ma bedhe ngʉ́ naha mʉkobho gba ma-a, amba pɨpɨta-a, ma sia matá. ");
INSERT INTO mdm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kpála bini ha mʉkobho gba ma-a ne kpéke de. Engʉ́ bini, ma ngahaha bha ngama. Ma ne angu ngʉ́ nahaha, ma la di ne angu ngʉ́ nasisia. Ma asia lɨ́lɨ bhomʉ-o ka ’Dyɨ ma.» ");
INSERT INTO mdm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","OmaYuda atsia agbogbo matá bhʉsʉ o ka oeli bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bhelé bhʉ́ ká uo adʉ apa me: «A abhʉ́ anɨ ne siti bua ! A ko la di bhʉlʉ pele! Yi ngadje anɨ ka nɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Okoko adʉ apa me: «Kpála ɨnde bhʉ́ e ne siti bua-a tɨ da napa ’ngʉ́ mo-o de. Siti bua tɨ da nabhulu djila okpála ɨnde ɨ u ’kpɨ́ de-e uu?» ");
INSERT INTO mdm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Abhomʉ-o, bhʉ́ gʉdhʉ na Yelusalema-a, bhʉ́ nedhɨnga na zini-e, u amene anokomɨa Naleke ’ngbé ’tɨ Ebhe gba omaYuda-o . ");
INSERT INTO mdm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Bhʉ́ ’ngbé ’tɨ Ebhe-e , Yesu adʉ adhʉkʉ sa ngba ’tɨ gba Salomo-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Abhomʉ-o, omaYuda asa lɨo dengo anɨ ngbalina. U atsia apa pɨ anɨ me: «Bua ya adʉ́ bha ka mʉ me a nde alʉ abhʉ́lá má gba me-e ngʉbula ekpɨ́ madho? Ɨ dʉ me mʉ nde ne Masɨya-a , mʉ de pa pɨ ya mbámbá.» ");
INSERT INTO mdm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu agie pɨ uo me: «Ma apa pɨ yi apa. Engʉ́ bini, yi zɨba ma de. Ongamba ’ngʉ́ ɨnde ma ngamene e ne ’lɨ ’Dyɨ ma-a, a ngakpokpo ’ngʉ́ gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Engʉ́ bini, yi bhuka de anga yi ne okandɵlɵ gba ma-a ade. ");
INSERT INTO mdm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Okandɵlɵ gba ma-a ngadje ’li ma. Ma ambɨla uo, u la di ngakpata ma. ");
INSERT INTO mdm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma ngaha mʉkobho na dʉdʉma pɨ uo. U mú dʉdʉma de. Kpála bini tɨ́ la di da nagbʉlʉ uo ka ma de. ");
INSERT INTO mdm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","’Dyɨ ma ɨnde aha uo mʉma-a, anɨ ngbéngbé ane ndʉ ’ngʉ́ hana. Kpála bini tɨ́ la di da nagbʉlʉ ’he bini ka ’Dyɨ ma de. ");
INSERT INTO mdm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngaya ne ’Dyɨ ma-a, koli ya bha bini.» ");
INSERT INTO mdm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Abhomʉ-o, omaYuda abha matá teme ngʉ́ natʉtʉlʉ anɨ ne di. ");
INSERT INTO mdm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu agie pɨ uo me: «Obabadha ’ngʉ́ bhelé ɨnde ma asuno e pɨ yi-e, ayie ka ’Dyɨ ma. A ko ngʉbula obabadha ’ngʉ́ bhedho yi ngakʉnda nabhɵlɵ ma lɨe ne teme?» ");
INSERT INTO mdm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","OmaYuda agie pɨ anɨ me: «A ko de me ya ngakʉnda nabhɵlɵ mʉ ne teme ka bádha ’ngʉ́-o de. Engʉ́ bini, a ko anga mʉ ngasobho Ebhe. Ngamʉ ɨnde bha ne kpála-kʉtɨ-e, mʉ ngaꞌo lɨmʉ maka Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu agie pɨ uo me: «U aye bhʉ́ lɨ́lɨ gba yi-e me, ngama-a, ma apa me: ‹Yi ne oebhe.› ");
INSERT INTO mdm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ya ambɨla me, u tɨ da nabʉlʉ engʉ́ ɨnde lɨ Bhuku gba Ebhe-e apa e de. Okpála ɨnde lɨ eli gba Ebhe-e akolo nanɨ gba o-o, u aꞌɨ uo me oebhe. ");
INSERT INTO mdm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Engʉ́ bini ngama-a, Ebhe abhʉ ma, anɨ atsia atima ma pɨ́la doto. Lele pɨ yi ngapa la lɨe me ma ngasobho Ebhe, anga ma ngapa me ma ne Ndɨlɨ gba Ebhe-e? ");
INSERT INTO mdm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ɨ dʉ me ma nde ngamene ngamba ’ngʉ́ gba ’Dyɨ ma ade-e, yi abhúka ma de. ");
INSERT INTO mdm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ɨ dʉ la me ma nde ngamene ngamba ’ngʉ́ gba ’Dyɨ ma-a, abana yi bhuka ma de-e, yi de bhuka ngabha mbo ongamba ’ngʉ́ ango-o. Yi bhuka ongamba ’ngʉ́ ango-o ngʉbula nambɨla ndjɨndjɨ me ’Dyɨ ma ngakobho bhʉ́ ma, ma la di ngakobho bhʉ́ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Abhomʉ-o, u agɨlɨ matá naholo anɨ. Engʉ́ bini, anɨ atsia akobho sa ’kpa uo. ");
INSERT INTO mdm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu atsia agie matá lɨe ayi ’ngu na Djʉlʉdanɨ, lɨ bɨlɨ ɨnde lɨ Djaa adʉ nanɨ abatisa okpála lɨ e kalanʉ-o. Anɨ atsia adʉ oo. ");
INSERT INTO mdm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Okpála bhelé ago nabhaka anɨ. U adʉ apa me: «Djaa mene ngamba ’ngʉ́ belegʉ de bini. Engʉ́ bini, ndʉ ’ngʉ́ hana ɨnde anɨ apa nanɨ e pɨndjɨ kpála ɨnde-e, a ko kʉkʉlʉ ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Oo, okpála bhelé abhuka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kpála bini ɨnde adʉ ’lɨ e me Ladjalo, asɨ kuo. Anɨ adʉ nadʉ bhʉ́ Betanɨa, kʉtɨ lɨ Malɨa ne ndai e Malata adʉ nadʉ bhʉ́ e-o. ");
INSERT INTO mdm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malɨa ne ɵlɵ ɨnde atuko nanɨ mʉngotsi lɨ ’dhʉ Ngámá, anɨ atsia akuo ne sundjo e-o. Ladjalo ɨnde adʉ ne kuo-o, nanɨ ne ndai anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ondaise anɨ na olɨsɨlɨsɨ bhisi bhomʉ-o, atima kpála ngʉ́ napa pɨ Yesu me: «Ngámá, alɨ kpála mo okʉkʉnda e ne kuo.» ");
INSERT INTO mdm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lɨ Yesu adje engʉ́ bhomʉ-o lɨe, anɨ atsia apa me: «Kuo bhomʉ-o ngʉbula nabhɵlɵ anɨ mabhɵlɵ ade. Engʉ́ bini, a ngʉbula naha sangu pɨ Ebhe. A ko la di ngʉbula me ngama, Ndɨlɨ gba Ebhe-e, ma sia sangu bhʉ́bhʉ́.» ");
INSERT INTO mdm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu adʉ ne mʉkʉnda pɨ Malata, ne ndai e na ɵɵlɵ, di ne Ladjalo naali. ");
INSERT INTO mdm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","La-a, anɨ adje lɨe me alɨ Ladjalo ne kuo-o, anɨ amene matá ’kpɨ́ bhisi lɨ bɨlɨ abhaka me anɨ nde lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pɨpɨta-a, anɨ apa pɨ omʉkpata gba e me: «Nɨ́ gie matá lɨnɨ́ bhʉ́ ndu doto na Yudaya.» ");
INSERT INTO mdm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Omʉkpata-a apa pɨ anɨ me: «Mʉsuno, a mene nga ’kpɨ́ bhelé de, omaYuda adʉ nako agɨlɨ nabhɵlɵ mʉ ne teme oo. Mo odji matá bha oo?» ");
INSERT INTO mdm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu agie pɨ uo me: «Ngbɨkpɨ ne saa ndjɨkpa ne ká bhisi. A mo-o adɨ? Ɨ dʉ me kpála nde ngadhʉkʉ ne ngbɨkpɨ-e, anɨ dó ’dhʉ e de. Padhá de, anga anɨ ngau zɨ ’kpɨ́ na doto ɨnde-e ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Engʉ́ bini, ɨ dʉ la me kpála nde ngadhʉkʉ sukpe-e, anɨ dó ’dhʉ e. Padhá de, anga anɨ lɨ zɨ ’kpɨ́ ade.» ");
INSERT INTO mdm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pɨta lɨ Yesu apa ’ngʉ́ bhomʉ-o lɨe, anɨ atsia apa pɨ uo me: «Ladjalo, olia nɨ́-e, anɨ ala. Engʉ́ bini, ma adji, amba ma zʉkʉ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Abhomʉ-o, omʉkpata gba anɨ-e atsia apa pɨ anɨ me: «Ngámá, ɨ dʉ me anɨ nde tɨla-a, anɨ dʉ́ bhʉ́ mʉkobho.» ");
INSERT INTO mdm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","A na paká me Yesu adʉ apa me Ladjalo akpi. Engʉ́ bini, omʉkpata-a adʉ abhundja naao me anɨ akpo ’ngʉ́ pɨndjɨ ela ɨnde lɨ okpála alala e-o. ");
INSERT INTO mdm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Abhomʉ-o, Yesu atsia apa pɨ uo mbámbá me: «Ladjalo akpi. ");
INSERT INTO mdm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma ne djalɨ pɨ yi anga ma dʉ nako oo de, amba yi bhuka ma. Engʉ́ bini, nɨ́ nʉ nabhaka anɨ!» ");
INSERT INTO mdm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Abhomʉ-o, Tʉma (ɨnde u agisila ’lɨ e me Bhuko-o), apa pɨ omʉkpata koko me: «Nganɨ́-e, nɨ́ nʉ di oo, ngʉbula me nɨ́ mu ne Mʉsuno bhʉ́ dabɨlɨ bini.» ");
INSERT INTO mdm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lɨ Yesu akolo lɨe, anɨ abhaka me u azɨ Ladjalo azɨ, a nde ane nga ’kpɨ́ badha. ");
INSERT INTO mdm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kʉtɨ na Betanɨa dʉ nanɨ de gʉdhʉ na Yelusalema masɨkpe de kilometele bata. ");
INSERT INTO mdm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A abhaka me omaYuda bhelé nde ago oo ngʉ́ nateteke Malata ne Malɨa ka lɨ ndai uo na bhobhoko-o akpi lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lɨ Malata adje lɨe me Yesu akolo de kʉtɨ masɨkpe-e, anɨ anʉ akɵ lɨe ne anɨ lɨ kpadjɨ. Engʉ́ bini, Malɨa adʉ naae akʉtɨ. ");
INSERT INTO mdm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Abhomʉ-o, Malata atsia apa pɨ Yesu me: «Ngámá, mʉ dʉ́ nako sɨ-e, ndai ma de kpi de. ");
INSERT INTO mdm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Engʉ́ bini, ma ambɨla me belegʉ mbɨa ɨnde-e, Ebhe tɨ da naha ndʉ ’he hana ɨnde mo oyó e ka anɨ-e pɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu apa pɨ anɨ me: «Ndai mʉ azúku mazuku.» ");
INSERT INTO mdm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malata agie pɨ anɨ me: «Ma ambɨla me anɨ azúku lɨ ’kpɨ́ lɨ okpála ɨnde amu-o, azúku lɨe lɨ sokpɨ́-o.» ");
INSERT INTO mdm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu apa pɨ anɨ me: «Kpála nazuku okpála-a, a ko ma. Kpála naha la di mʉkobho pɨ okpála-a, a ko ma. Kpála ɨnde abhuka ma-a, abana anɨ kpi, anɨ kóbho. ");
INSERT INTO mdm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","La di-e, kpála ne kpála ɨnde bhʉ́ mʉkobho, ɨnde abhuka la di ma-a, anɨ kpí dʉdʉma de. Mo obhuka mo-o?» ");
INSERT INTO mdm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malata agie me: «A moko, Ngámá, ma abhuka me mʉ ne Masɨya , Ndɨlɨ gba Ebhe. Kpála ɨnde a ayo me anɨ go pɨ́la doto ko.» ");
INSERT INTO mdm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pɨta anɨ apa ’ngʉ́ bhomʉ-o lɨe, Malata anʉ aꞌɨ ndai e Malɨa. Do anɨ pɨ anɨ bhʉ́ tʉpele me: «Mʉsuno aoo. Anɨ ngaꞌɨ mʉ.» ");
INSERT INTO mdm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lɨ Malɨa adje lɨe mo-o, anɨ ayie kolo bhʉ́lá má kɨa! Anɨ atsia anʉ abhaka Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A adʉ me Yesu nde kolo nga bhʉ́ kʉtɨ na Betanɨa de. Engʉ́ bini, anɨ adʉ ngabha lɨ bɨlɨ ɨnde lɨ Malata anʉ akɵ lɨe ne anɨ lɨ e ko. ");
INSERT INTO mdm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lɨ omaYuda ɨnde adʉ abhʉ́ ’tɨ ngʉ́ nateteke Malɨa au lɨe me anɨ ayie bhʉ́lá ne nakoto kilidjo bhʉ́ holo-o, u atsia akpata anɨ. Padhá de, anga u adʉ abhundja naao me anɨ adji aku ’gba apɨ́ lata. ");
INSERT INTO mdm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malɨa akolo lɨ bɨlɨ lɨ Yesu adʉ lɨ e-o. Anɨ au Yesu lɨe, anɨ atɨ bhʉ́ li ’dhʉ anɨ. Anɨ atsia apa pɨ anɨ me: «Ngámá, mʉ dʉ́ nako sɨ-e, ndai ma de kpi de.» ");
INSERT INTO mdm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu au me anɨ ngaku ’gba di ne okpála ɨnde ago ne anɨ bhʉ́ dabɨlɨ bini-o. Anɨ asia lɨkabhu naali lɨ bua e. Mabhundja gba anɨ-e atsia angbɨngɨ di. ");
INSERT INTO mdm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Abhomʉ-o, anɨ atsia ayi uo me: «Yi azɨ anɨ su?» U agie pɨ anɨ me: «Ngámá, gogo, amba mʉ u.» ");
INSERT INTO mdm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu aku ’gba. ");
INSERT INTO mdm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Abhomʉ-o, omaYuda atsia apa me: «Yi u maka anɨ akʉnda nako anɨ lɨe ko!» ");
INSERT INTO mdm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Engʉ́ bini, okpála koko bhʉ́ ká uo atsia apa me: «Ngaanɨ ɨnde abhulu nako djila kpála ɨnde ɨ u kpɨ́ de-e, anɨ tɨ da nako namene de me Ladjalo akpí de-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Abhomʉ-o, Yesu asia matá lɨkabhu naali lɨ bua e. Anɨ anʉ abhʉ́ lata. A adʉ nanɨ lata ɨnde u adjɨ e bhʉ́ teme. U ani nanɨ bhɵbhɵ ne teme na ngbéngbé. ");
INSERT INTO mdm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Abhomʉ-o, Yesu atsia apa me: «Yi ꞌe teme-o.» Malata, ndai kpála ɨnde akpi-e, apa pɨ anɨ me: «Ngámá, se anɨ aholo napu aholo. Padhá de, anga anɨ amene nga satɵ ’kpɨ́ badha.» ");
INSERT INTO mdm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu agie pɨ anɨ me: «Ma pa ɨgɨnɨ pɨ mʉ de me, ɨ dʉ me mʉ nde abhuka ma-a, mʉ ú sangu gba Ebhe-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Abhomʉ-o, u aꞌe teme-o. Yesu atsia ’kpɨ́ ne bhʉ́lá, anɨ atsia apa me: «’Dyɨ ma, ma ngagie heni pɨ mʉ, anga mo odje ma. ");
INSERT INTO mdm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma ambɨla ndjɨndjɨ me mʉ ngadje ma ndʉ ’kpɨ́ hana. Ma ngapapa mo-o ka okpála ɨnde asa lɨo dengo ma ɨnde, amba u bhuka me, mo otima ma ngamʉ.» ");
INSERT INTO mdm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Anɨ apa ’ngʉ́ bhomʉ-o lɨe, anɨ asʉla kpekpeke me: «Ladjalo, koto ei!» ");
INSERT INTO mdm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ladjalo akoto. Anɨ akoto me ’dhʉ anɨ, di ne ’kpa anɨ nde agbigbite lɨe ne opapala bongo . Bhʉ́la anɨ nde agbite la di lɨe ne bongo. Yesu atsia apa pɨ uo me: «Yi bhulu anɨ, amba yi ꞌo anɨ, anɨ tapa.» ");
INSERT INTO mdm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Abhomʉ-o, omaYuda bhelé bhʉ́ ká okpála ɨnde ago gba Malɨa au engʉ́ ɨnde lɨ Yesu amene e-o. U atsia abhuka Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Engʉ́ bini, okoko bhʉ́ ká uo anʉ abhaka omʉFalisai . U akpokpo ’ngʉ́ ɨnde lɨ Yesu amene e pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Abhomʉ-o, ongbengbe odimandɵ gba Ebhe , di ne omʉFalisai apo bhʉ́la o bhʉ́ ’ngbé bula. U atsia apa me: «Kpála ɨnde-e ngamene ongamba ’ngʉ́ bhelé. Nɨ́ améne sɨ pɨ? ");
INSERT INTO mdm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ɨ dʉ me nɨ́ nde aꞌo me anɨ dʉ bha anʉ ne di ne kalanʉ me-e, ndʉ okpála hana bhúka anɨ. Pɨpɨta-a, okpála na gʉdhʉ na Loma kólo ne angu. U bhɵ́lɵ ’ngbé ’tɨ Ebhe gba nɨ́-o. U tsia bhɵ́lɵ la di kʉtɨ gba nɨ́-o!» ");
INSERT INTO mdm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kpála bini adʉ bhʉ́ ká uo. A adʉ ’lɨ anɨ me Kaifa. Anɨ adʉ bhele kpála gba odimandɵ bhʉ́ kalanga bhomʉ-o ngae. Anɨ apa pɨ uo me: «Ngayi-e, yi mbɨla ’ngʉ́ de! ");
INSERT INTO mdm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yi mbɨla de me a pɨ yi ndjɨndjɨ me kpála bini kpi pɨ ndʉ okpála hana, amba kʉtɨ libhomu akpí de-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","La-a, anɨ dʉ apa ’ngʉ́ bhomʉ-o bhʉ́ ngʉ e de. Engʉ́ bini, a adʉ la lɨe me anɨ nde ne bhele kpála gba odimandɵ bhʉ́ kalanga bhomʉ-o ngae-e, anɨ atsia apa ’ngʉ́ maka polofeta me: «A ayo me Yesu kpi ngʉbula kʉtɨ gba omaYuda-o. ");
INSERT INTO mdm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Anɨ kpi bha bini ngʉbula omaYuda de. Engʉ́ bini, anɨ kpi ngʉbula me nɨ po bhʉ́la ongɨsɨ gba Ebhe ɨnde atsambala ne bɨlɨ ngangá-a bhʉ́ piga bini.» ");
INSERT INTO mdm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nayie lɨ ’kpɨ́ bhomʉ-o, ongámásɨ gba omaYuda atsia adje lɨo me o bhɵlɵ Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kaka-a, Yesu dʉ matá adholo mbámbá bhʉ́ ká omaYuda de. Anɨ atapa bhʉ́ gʉdhʉ na Efalaime, bhʉ́ ndu doto ɨnde de egʉ-o. Abhomʉ-o, anɨ atsia adʉ ne omʉkpata gba e oo. ");
INSERT INTO mdm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pasɨka gba omaYuda akolo masɨkpe. Kaka-a, okpála bhelé na kʉtɨ ango-o atsia anʉ bhʉ́ gʉdhʉ na Yelusalema ngʉbula me o vʉlʉ lɨo, amba o dʉ pɨ Ebhe bubu kala anokomɨa-o . ");
INSERT INTO mdm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Abhomʉ-o, u adʉ agɨlɨ Yesu. U alʉlʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda-o. U atsia adʉ ayi lɨo sʉnda o me: «Yi abhundja pɨ? Anɨ agó bha ndjʉ bhʉ́ anokomɨa ɨnde-e mago? Ne me, anɨ gó-o de?» ");
INSERT INTO mdm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ongbengbe odimandɵ gba Ebhe, di ne omʉFalisai aha nanɨ lɨ́lɨ me: «Ɨ dʉ me kpála nde ambɨla bɨlɨ ɨnde lɨ Yesu nde lɨe-e, anɨ de pa, amba u nʉ holo anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Abhomʉ-o, ekpɨ́ madhɨa kala Pasɨka-a, Yesu anʉ bhʉ́ kʉtɨ na Betanɨa. A bhomʉ-o bɨlɨ ɨnde lɨ Ladjalo, kpála ɨnde lɨ Yesu azuku e adʉ nadʉ lɨ e-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oo, u aha ezʉ pɨ anɨ, Malata atsia adʉ aꞌoꞌo kala anɨ. Ladjalo atsia adʉ di bhʉ́ ká okpála ɨnde adʉ azʉ ’he bhʉ́ dabɨlɨ bini ne Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Abhomʉ-o, Malɨa aha gɨlɨ bini ɨnde lɨ mʉngotsi na mase naali adʉ bhʉ́ e-o. U amene nanɨ mʉngotsi ango-o bha lɨ ndula ɨnde ’lɨ e me nalade. Anɨ aha, anɨ atuko lɨ ’dhʉ Yesu. Anɨ akuo ’dhʉ anɨ ne sundjo e. Bádha se mʉngotsi ango-o atsia aha etɨ-e libhomu. ");
INSERT INTO mdm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Engʉ́ bini, Yuda Ɨsɨkaliote, sʉka omʉkpata gba Yesu, kpála ɨnde apʉ́ anɨ pɨ obhʉlʉ yala-a, atsia apa me: ");
INSERT INTO mdm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«A ayo ɨgɨnɨ de me u tsɨndjɨ mʉngotsi ɨnde-e lɨ lɨ́ denalio kámá bata, amba u ha falanga ango-o pɨ obhʉlʉ ndɨbhɨlɨ-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","La-a, a ko de me anɨ apa mo-o, anga anɨ adʉ ne ndjinga obhʉlʉ ndɨbhɨlɨ-e de. Engʉ́ bini, a ko anga anɨ adʉ bhʉlʉ ’zi. Padhá de, anga anɨ adʉ la alila gba tɨa lɨe ngae-e, anɨ adʉ azi tété. ");
INSERT INTO mdm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Engʉ́ bini, Yesu atsia apa me: «ꞌO ɵlɵ bhomʉ! Padhá de, anga engʉ́ ɨnde anɨ amene e, a ngʉbula ekpɨ́ ɨnde u azɨ́ ma lɨe bhʉ́ lata ko. ");
INSERT INTO mdm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Padhá de, anga yi adʉ́ bhʉ́ dabɨlɨ bini ne obhʉlʉ ndɨbhɨlɨ ndʉ ’kpɨ́ hana. Engʉ́ la bini, ngama-a, nɨ́ dʉ́ ne yi ndʉ ’kpɨ́ hana de.» ");
INSERT INTO mdm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Abhomʉ-o, bhiti omaYuda adje me Yesu abhʉ́ kʉtɨ na Betanɨa, u atsia anʉ oo. U nʉ oo bha bini ngʉbula Yesu de, engʉ́ bini, u anʉ di me o u Ladjalo ɨnde lɨ Yesu azuku e-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Abhomʉ-o, ongbengbe odimandɵ gba Ebhe-e atsia adje lɨo me o bhɵlɵ di Ladjalo. ");
INSERT INTO mdm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Padhá de, anga omaYuda bhelé adʉ aꞌo ká uo, u atsia adʉ abhuka Yesu ka engʉ́ gba Ladjalo-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ekpɨ́ bhe pɨpɨta-a, bhiti okpála na bhibhiti ɨnde ago bhʉ́ anokomɨa na Pasɨka adje me Yesu adji bhʉ́ gʉdhʉ na Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Abhomʉ-o, u abha ’kpá ngulu, u aze ngʉ́ nanʉ nakɵ lɨo ne anɨ. U atsia adʉ asʉsʉla me: «Sangu pɨ Ebhe! A ayo me Ebhe Ngámá tuko bisagu pɨ́ kpála ɨnde ngago ne ’lɨ anɨ-o! A ayo me Ebhe tuko bisagu pɨ́ ’ngbé Ngámá gba omaƗsalaele-o!» ");
INSERT INTO mdm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu au ndɨlɨ punda, anɨ atsia aꞌʉ pɨ́ ’ngbʉ anɨ maka lɨ Bhuku apa lɨe me: ");
INSERT INTO mdm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Gʉdhʉ na Siona , mo odjé tsʉlʉ de! Tsitsia, ’ngbé Ngámá gba mʉ-o ngago, anɨ adʉ pɨ́ ’ngbʉ ndɨlɨ punda na ɵɵlɵ.» ");
INSERT INTO mdm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Lɨ nedhɨnga bhomʉ-o, omʉkpata gba anɨ-e mbɨla nga nanɨ ta engʉ́ ango-o de. La lɨ nedhɨnga ɨnde lɨ Yesu asia sangu gba e lɨe, u atsia abhundja me u aye nanɨ ongʉ́ bhomʉ-o bhʉ́ Bhuku gba Ebhe-e pɨndjɨ anɨ. U atsia amene pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Abhomʉ-o, bhiti okpála ɨnde adʉ nanɨ bhʉ́ dabɨlɨ bini ne anɨ lɨ nedhɨnga ɨnde anɨ aꞌɨ Ladjalo lɨe me anɨ koto bhʉ́ lata-a, anɨ atsia azuku di anɨ-e, adʉ akpokpo ’ngʉ́ ɨnde u au e-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kaka-a, bhiti okpála ango-o abhaka anɨ. Padhá de, anga u adje nanɨ me anɨ amene ngamba ’ngʉ́ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Abhomʉ-o, omʉFalisai atsia apa sʉnda o me: «Yi au, nɨ́ tɨ da namene ’he bini de. Ndʉ okpála hana agbida nganda anɨ!» ");
INSERT INTO mdm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","OGiliki koko adʉ bhʉ́ ká okpála ɨnde ago bhʉ́ gʉdhʉ na Yelusalema ngʉ́ nadhɵgɵ Ebhe bhʉ́ anokomɨa-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","U adyudyo lɨo de Filipo, kpála na gʉdhʉ na Betesaida, bhʉ́ ndu doto na Galilaya. U atsia apa pɨ anɨ me: «Mʉsuno, ya akʉnda nau Yesu.» ");
INSERT INTO mdm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo anʉ apa pɨ Andɨlɨ. Pɨpɨta-a, ndʉ uo bhisi hana atsia anʉ apa pɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu agie pɨ uo me: «Mbɨa ɨnde-e, a ko nedhɨnga ɨnde a ayo lɨe me Ndɨlɨ gba kpála sia sangu gba e-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A moko, ma apa pɨ yi na paká me: ɨ dʉ me lɨ́ ngano bini nde atɨ bhʉ́ doto, ɨ kpi de-e, ɨ tígala bha ngae kpi e kpi. Engʉ́ bini, ɨ dʉ la me a nde akpi-e, ɨ lɨ́ lɨ́lɨ́ bhelé. ");
INSERT INTO mdm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kpála ɨnde akʉnda mʉkobho gba e, anɨ kpí. Engʉ́ bini, lɨ kpála bini kʉnda Ebhe ane mʉkobho gba e pɨ́la doto ɨnde-e, mʉkobho ango-o líla lɨe, lɨ kpála ango-o tsia sía di mʉkobho na dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɨ dʉ me kpála nde akʉnda namene kulu lɨe mʉma-a, a ayo me kpála ango-o kpata ma. La di-e, bɨlɨ ɨnde ma adʉ́ lɨ e, kpála na kulu gba ma-a adʉ́ bhadi oo. ’Dyɨ ma adhɵ́gɵ kpála ɨnde ngamene kulu mʉma ko.» ");
INSERT INTO mdm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Mbɨa ɨnde-e, bua ma ngadje lɨkabhu. Ma apá la pɨ? Ma pá de me, ‹’Dyɨ ma, kobho ma lɨ nedhɨnga ɨnde-e de.› Padhá de, anga ma ago ngʉbula nedhɨnga ango-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","’Dyɨ ma-e, dhɵgɵ ’lɨ mʉ!» Abhomʉ-o eli ayie abhʉ́lá, atsia apa me: «Ma adhɵgɵ anɨ adhɵgɵ. Ma adhɵ́gɵ la matá anɨ madhɵgɵ.» ");
INSERT INTO mdm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Abhomʉ-o, bhiti okpála ɨnde adʉ oo, ɨnde adje la di eli ango-o, adʉ apa me: «Mʉgbálá asʉla bhomʉ-o ngae!» Okoko atsia adʉ apa me: «Andjelu bini agama ’ngʉ́ pɨ anɨ ngae.» ");
INSERT INTO mdm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","La-a, Yesu apa pɨ uo me: «Eli bhomʉ-o pa lɨe ka ’ngʉ́ ka ma de. Engʉ́ bini, a apa lɨe ka ’ngʉ́ ka yi. ");
INSERT INTO mdm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mbɨa ɨnde-e, u akódho ’ngʉ́ gba okpála na pɨ́la doto. Mbɨa ɨnde-e, u ató holo bhʉ́ ’dhʉ ngámá na doto ɨnde. ");
INSERT INTO mdm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","La ngama-a, lɨ nedhɨnga ɨnde u aꞌéꞌe ma lɨe abhʉ́lá-a, ma agbéle ndʉ okpála hana lɨ pápá gba ma.» ");
INSERT INTO mdm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu adʉ apa ’ngʉ́ bhomʉ-o ngʉ́ nasuno lele maka anɨ akpí lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Abhomʉ-o, bhiti okpála-a atsia agie pɨ anɨ me: «Ya adje bhʉ́ bhuku na lɨ́lɨ me Masɨya adʉ́ dʉdʉma ne dʉdʉma. Lele pɨ mʉ ngapa lɨe me u aꞌéꞌe Ndɨlɨ gba kpála abhʉ́lá? Ndɨlɨ gba kpála ango-o ne da?» ");
INSERT INTO mdm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Abhomʉ-o, Yesu atsia agie pɨ uo me: «Zɨ ’ke nga matá bhʉ́ ká yi ngʉbula nedhɨnga bedɨ. Yi dhʉkʉ bhʉ́ nedhɨnga ɨnde yi nde nga lɨe ne zɨ ’ke, ngʉ́ nakpe me biti ahólo yi bhʉ́ gbilikiti de. Padhá de, anga kpála ɨnde ngadhʉkʉ bhʉ́ biti-e mbɨla bɨlɨ ɨnde anɨ adji lɨ e de. ");
INSERT INTO mdm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nedhɨnga yi nde lɨe ne zɨ ’ke-e, yi bhuka zɨ ’ke ango-o, amba yi kolo ongɨsɨ na zɨ ’ke.» Pɨta lɨ Yesu apa engʉ́ bhomʉ-o lɨe, anɨ atapa, anɨ atsia anʉ awo lɨe de uo tsutsu. ");
INSERT INTO mdm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Abana lɨ Yesu amene ongamba ’ngʉ́ lɨe bhelé-e, omaYuda dʉ abhuka anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","U dʉ abhuka anɨ de ngʉbula napa me engʉ́ ɨnde lɨ polofeta Ɨsaya apa e-e, a mene lɨe, engʉ́ ɨnde me: «Ngámá, abhuka engʉ́ ɨnde ya adʉ apa e da? Ngámá apana angu gba e pɨ da?» ");
INSERT INTO mdm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɨsaya apa di nanɨ me, ka nɨ lɨ okpála bhomʉ-o tɨ nanɨ da nabhuka lɨe de-e. Anɨ apa me: ");
INSERT INTO mdm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Ebhe agbite djila uo. Anɨ adji bua uo maka teme, ngʉbula me u aú ’kpɨ́ de, ngʉbula me u ambɨ́la ’ngʉ́ bini de, di me u adjí bua o de, amba Ebhe akóbho uo de.» ");
INSERT INTO mdm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ɨsaya apa engʉ́ bhomʉ-o, anga anɨ au nanɨ sangu gba Yesu-o. Anɨ atsia akpokpo di ’ngʉ́ pɨndjɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","La-a, belegʉ bhʉ́ ká ongámásɨ gba omaYuda-a , bhelé abhuka Yesu. Engʉ́ bini, ka nakpe omʉFalisai-e, u dʉ apa engʉ́ ango-o mbámbá de. Padhá de, anga u adʉ akpe me, u apándja o bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje de. ");
INSERT INTO mdm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","U adʉ akʉnda me okpála dhɵgɵ o ane me Ebhe dhɵgɵ o ngae. ");
INSERT INTO mdm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu asʉla me: «Kpála ɨnde abhuka ma-a, anɨ bhuka bhomʉ-o ma de. Engʉ́ bini, anɨ abhuka kpála ɨnde atima ma ko. ");
INSERT INTO mdm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kpála ɨnde ngau ma-a, anɨ ngau bhomʉ-o kpála ɨnde atima ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngama-a, ma ago pɨ́la doto maka zɨ ’ke, ngʉbula me ndʉ okpála hana ɨnde abhuka ma-a, adʉ́ bhʉ́ biti de. ");
INSERT INTO mdm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɨ dʉ me kpála nde adje ’li ma-a, anɨ lila de-e, ma kódho ’ngʉ́ gba anɨ-e ngama de. Padhá de, anga ma go ngʉbula naꞌo ’ngʉ́ pɨ́ okpála de. Engʉ́ bini, ma ago ngʉ́ nakobho uo. ");
INSERT INTO mdm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kpála ɨnde ayala ma-a, ɨnde ɨ zɨba di ’li ma de-e, u akódho ’ngʉ́ gba anɨ-o. Eli ɨnde ma apa e, eli ango-o akódho ’ngʉ́ gba anɨ lɨ sokpɨ́-e ngae. ");
INSERT INTO mdm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Padhá de, anga ma pa ’ngʉ́ gba ma makpe de. ’Dyɨ ma ɨnde atima ma-a, aha lɨ́lɨ mʉma ngae makpe ngʉbula ndʉ ’ngʉ́ hana ɨnde a ayo me ma pa e, di ne bhende a ayo me ma kpokpo e-o. ");
INSERT INTO mdm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Padhá de, anga ma ambɨla me lɨ́lɨ gba anɨ-e ngaha mʉkobho na dʉdʉma. Kaka-a, ndʉ ’ngʉ́ hana ɨnde ma ngapa e, ma ngapapa maka lɨ ’Dyɨ ma apa mʉma lɨe ko.» ");
INSERT INTO mdm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A adʉ nanɨ ekpɨ́ kala anokomɨa na Pasɨka . Yesu ambɨla nanɨ me nedhɨnga nayie ka nɨ pɨ́la doto ɨnde-e, ngʉ́ nanʉ agba ’Dyɨ nɨ-e akolo. Anɨ adʉ akʉnda okpála gba e ɨnde pɨ́la doto-o. Anɨ akʉnda uo akolo alɨ soso. ");
INSERT INTO mdm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu ne omʉkpata gba e adʉ azʉ ’he tagolo. A adʉ me Djabʉlʉ nde aꞌo lɨ bua Yuda, ndɨlɨ gba Simo Ɨsɨkaliote, me anɨ pʉ Yesu pɨ obhʉlʉ yala. ");
INSERT INTO mdm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ambɨla nanɨ ndjɨndjɨ me nganɨ makpe-e, nɨ ayie agba Ebhe. Anɨ atsia ambɨla la bhadi ndjɨndjɨ me nɨ agíe lɨnɨ agba Ebhe, la di me ’Dyɨ nɨ aꞌo ndʉ ’ngʉ́ hana sa ’kpa nɨ. ");
INSERT INTO mdm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Anɨ ayie bhʉ́lá, anɨ ayie lɨ bɨlɨ nazʉ ’he-o. Anɨ agbe bongo ɨnde u adyɨdyɨ e pɨ́ bongo koko-o. Anɨ aha pála bongo, anɨ agbite ludu e. ");
INSERT INTO mdm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pɨpɨta-a, anɨ aha engu, anɨ atuko bhʉ́ base. Anɨ aholo navʉlʉ ’dhʉ omʉkpata gba e ne di. Anɨ atsia adʉ akukuo ne bongo ɨnde anɨ agbite e ludu e-o. ");
INSERT INTO mdm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Anɨ akolo lɨ Simo Piele. Do Piele pɨ anɨ me: «Ngámá, mo ovʉ́lʉ bha ndjʉ ’dhʉ ma ngamʉ makpe?» ");
INSERT INTO mdm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu atsia agie pɨ anɨ me: «Engʉ́ ɨnde ma ngamene e mbɨa ɨnde-e, mʉ mbɨla de. Engʉ́ bini, mo ombɨ́la sidi.» ");
INSERT INTO mdm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piele apa pɨ anɨ me: «A mo-o ade. Mʉ vʉ́lʉ ’dhʉ ma belegʉ de bini!» Yesu atsia agie pɨ anɨ me: «Ɨ dʉ me ma nde vʉlʉ ’dhʉ mʉ de-e, mʉ tɨ da nadʉ bhʉ́ dabɨlɨ bini ne ma de.» ");
INSERT INTO mdm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simo Piele apa pɨ anɨ me: «Ngámá, mo ovʉ́lʉ bha bini ’dhʉ ma de. Engʉ́ bini, vʉlʉ di ’kpa ma, ne ’ndjɨ ma!» ");
INSERT INTO mdm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu apa pɨ anɨ me: «Kpála ɨnde avʉlʉ kʉte e avʉlʉ-o, kʉte anɨ libhomu akolo ndjɨndjɨ. Anɨ tɨ́ matá da navʉlʉ kʉte e de. Engʉ́ bini, anɨ vʉ́lʉ bha ɨbili ’dhʉ e. Ngayi-e, yi bubu. La-a, yi bubu ndʉ yi hana ade.» ");
INSERT INTO mdm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu apa ’ngʉ́ bhomʉ-o anga anɨ adʉ ambɨla ndjɨndjɨ me, apʉ́ nɨ pɨ obhʉlʉ yala da-ie. Kaka-a, anɨ atsia apa me: «Yi ndʉ yi hana bubu ade.» ");
INSERT INTO mdm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pɨta anɨ avʉlʉ ’dhʉ uo lɨe, anɨ aha bongo gba e, anɨ adyɨ. Anɨ agie lɨe lɨ bɨlɨ nazʉ ’he-o. Anɨ atsia apa pɨ uo me: «Yi mbɨla ta ’ngʉ́ ɨnde ma amene e lɨ yi-e uu? ");
INSERT INTO mdm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yi ngaꞌɨ ma me: ‹Mʉsuno›, yi la di ngaꞌɨ ma me: ‹Ngámá.› A ko kʉkʉlʉ ’ngʉ́, anga ma mo-o. ");
INSERT INTO mdm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ɨ dʉ me ngama, ɨnde ne Ngámá, ɨnde la di ne Mʉsuno-o, ma nde avʉlʉ ’dhʉ yi-e, ngayi di-e, yi de vʉlʉ ’dhʉ yi sʉnda yi moko. ");
INSERT INTO mdm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma asuno pɨ yi bhomʉ-o me amba ngayi di-e, yi mene maka ma amene pɨ yi lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A moko, ma apa pɨ yi na paká me, kpála na kulu ngbéngbé ane ngámá gba e ade. La di-e, bhʉlʉ titima ngbéngbé ane kpála ɨnde atima anɨ-e ade. ");
INSERT INTO mdm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mbɨa ɨnde-e, yi ambɨla ndʉ ongʉ́ bhomʉ-o hana ambɨla. A ko djalɨ pɨ yi, ɨ dʉ me yi nde ngamene ongʉ́ ango-o. ");
INSERT INTO mdm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Engʉ́ ɨnde ma ngapa e, a pɨ ndʉ yi hana ade. Ma mbɨla okpála ɨnde ma abhʉ o-o hana. Engʉ́ bini, a ayo me engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e , a mene lɨe, engʉ́ ɨnde me: ‹Kpála ɨnde ya adʉ azʉ ’he ne e bhʉ́ dabɨlɨ bini-e, adji lɨe bhʉlʉ yala gba ma.› ");
INSERT INTO mdm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma apa pɨ yi mbɨa ɨnde-e kala nakolo ka ongʉ́ ango-o, amba lɨ engʉ́ ango-o akólo lɨe, yi bhuka me ngama-a ‹Ma uu.› ");
INSERT INTO mdm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A moko, ma apa pɨ yi na paká me: ɨ dʉ me kpála nde asia kpála ɨnde ma atima e, amba anɨ asia bhomʉ-o ma. Ɨ dʉ la di me kpála nde asia ma-a, amba anɨ asia bhomʉ-o kpála ɨnde atima ma-o.» ");
INSERT INTO mdm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pɨta lɨ Yesu apa ongʉ́ bhomʉ-o lɨe, anɨ asia lɨkabhu lɨ bua e naali. Anɨ atsia apa mbámbá me: «A moko, ma apa pɨ yi na paká me: sʉka yi bini apʉ́ ma pɨ obhʉlʉ yala gba ma-o.» ");
INSERT INTO mdm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Omʉkpata-a aholo natsitsia bhʉ́la o. U dʉ ambɨla de me Yesu ngapa ɨnde-e engʉ́ gba da-ie de. ");
INSERT INTO mdm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Lɨ nedhɨnga u adʉ azʉ ’he lɨe, sʉka omʉkpata gba Yesu ɨnde lɨ Yesu adʉ akʉnda e naali-e, aseke ’ndjɨ e pɨ́ mbulu anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Abhomʉ-o, Simo Piele amene ’kpa e pɨ mʉkpata ango-o me, anɨ yi Yesu me anɨ ngapa engʉ́ gba da. ");
INSERT INTO mdm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Abhomʉ-o, mʉkpata ango-o adji bhʉ́la e lɨ pápá gba Yesu. Anɨ atsia ayi Yesu me: «Ngámá, a ko e da?» ");
INSERT INTO mdm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu agie pɨ anɨ me: «Ma ngatʉnʉ mapa bhʉ́ ’mʉ ’zʉ-o, kpála ɨnde ma ahá pɨ e-e, a ko anɨ.» Abhomʉ-o, Yesu aha mapa, anɨ atʉnʉ bhʉ́ ’mʉ ’zʉ-o. Pɨpɨta-a, anɨ atsia aha pɨ Yuda, ndɨlɨ gba Simo Ɨsɨkaliote. ");
INSERT INTO mdm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bha lɨ nedhɨnga lɨ Yuda aha mapa-a lɨe, Satana alɨ bhʉ́ anɨ. Yesu atsia apa pɨ anɨ me: «Engʉ́ ɨnde mʉ nde ne e, mene má gala!» ");
INSERT INTO mdm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kpála bini bhʉ́ ká okpála ɨnde u adʉ azʉ ’he ne o-o mbɨla de me anɨ apa pɨ Yuda mo-o ka nɨ-ie de. ");
INSERT INTO mdm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Lɨ Yuda adʉ alila tɨa lɨe ngae, kaka-a, okpála koko adʉ abhundja naao me, anɨ apa pɨ Yuda me anɨ kala ezʉ ɨnde a ayo me u kala e ngʉ́ anokomɨa-o, ne me anɨ ha mbo ehe pɨ obhʉlʉ ndɨbhɨlɨ. ");
INSERT INTO mdm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lɨ Yuda aha ndu mapa lɨe, kolo má gala me-e, anɨ akoto kilidjo. A adʉ me ekpɨ́ nde abi. ");
INSERT INTO mdm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pɨta lɨ Yuda akoto lɨe, Yesu atsia apa me: «Mbɨa ɨnde-e, Ndɨlɨ gba kpála, asia sangu gba e asia. Ebhe asia la di sangu ka anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Maka lɨ Ebhe asia sangu ka anɨ lɨe, Ebhe asúno ngae makpe sangu gba anɨ-o. Anɨ asúno má gala! ");
INSERT INTO mdm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Odi ma, nɨ́ dʉ́ matá ne yi ngʉbula ’kpɨ́ bhelé de. Pɨpɨta-a, yi agɨ́lɨ ma. Engʉ́ la bini, ma ngapa pɨ yi mbɨa ɨnde-e engʉ́ ɨnde ma apa e pɨ omaYuda koko me, yi tɨ da nanʉ lɨ bɨlɨ ɨnde ma adji lɨ e de. ");
INSERT INTO mdm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma ngaha pɨ yi-e lɨ́lɨ na mbɨa. Lɨ́lɨ ɨnde me yi dʉ ne mʉkʉnda sʉnda yi. A ayo me yi dʉ ne mʉkʉnda sʉnda yi maka ma nde lɨe ne mʉkʉnda pɨ yi ko. ");
INSERT INTO mdm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Padhá de, anga ɨ dʉ me yi nde ne mʉkʉnda sʉnda yi-e, lɨ ndʉ okpála hana mbɨ́la me yi ne omʉkpata gba ma-o.» ");
INSERT INTO mdm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo Piele ayi anɨ me: «Ngámá, mo odji su?» Yesu agie pɨ anɨ me: «Mʉ tɨ da nakpata ma lɨ bɨlɨ ma adji lɨ e mbɨa ɨnde-e de. Engʉ́ bini, mo okpáta ma sidi.» ");
INSERT INTO mdm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piele apa pɨ anɨ me: «Ngámá, ma tɨ da nakpata mʉ mbɨa ɨnde-e de ka nɨ? Ma bedhe ngʉ́ nandala ’kpa lɨ mʉkobho gba ma-a ngʉbula mʉ!» ");
INSERT INTO mdm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu agie pɨ anɨ me: «Mʉ bha ndjʉ bedhe ngʉ́ nandala ’kpa lɨ mʉkobho gba mʉ-o ngʉbula ma? A moko, ma apa pɨ mʉ na paká me, kala me engʉ ku ’gbá-a, mo opá bhʉtsibhʉtsi bata me nɨ mbɨla ma de.» ");
INSERT INTO mdm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu apa pɨ omʉkpata gba e me: «Yi aꞌó bua yi abhʉ́lá de. Yi bhuka Ebhe, yi bhuka di ma. ");
INSERT INTO mdm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Abhʉ́ ’tɨ́ gba ’Dyɨ ma-a, dabɨlɨ nadʉ tété-e bhelé. Ma adji naleke dabɨlɨ pɨ yi. Ɨ dʉ́ mo-o de-e, ma de apa pɨ yi apa. ");
INSERT INTO mdm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pɨta nanʉ ka ma naleke dabɨlɨ pɨ yi-e, ma agó matá, ma atsia há yi ngʉ́ nadʉ bhʉ́ dabɨlɨ bini ne yi, amba bɨlɨ ɨnde ma ngadʉ lɨ e, yi dʉ bhadi tété. ");
INSERT INTO mdm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yi mbɨla la di kpadjɨ na bɨlɨ ɨnde ma adji lɨ e hana.» ");
INSERT INTO mdm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tʉma apa pɨ anɨ me: «Ngámá, ya mbɨla bɨlɨ mo odji lɨ e de. Ya tɨ da nambɨla kpadjɨ-e lele pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu agie pɨ anɨ me: «Ma ne kpadjɨ. Ma ne kʉkʉlʉ ’ngʉ́. Ma la di ne mʉkobho. Kpála bini tɨ da nanʉ agba ’Dyɨ ma lɨ kpadjɨ koko de, bha bini me anɨ nde apʉ lɨ pápá gba ma. ");
INSERT INTO mdm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ɨ dʉ me yi nde ambɨla ma-a, yi mbɨ́la di ’Dyɨ ma. Nayie pɨ mbɨa ɨnde-e, yi mbɨla anɨ hana. Yi au la di anɨ au.» ");
INSERT INTO mdm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo apa pɨ anɨ me: «Ngámá, pana ’Dyɨ mʉ pɨ ya, amba ale pɨ ya.» ");
INSERT INTO mdm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu agie pɨ anɨ me: «Filipo, enʉ́ nɨ́ abhue lɨe ne yi ngengele-e, mʉ mbɨla nga ma sɨɨ dɨ? Kpála ɨnde au ma-a, anɨ au ’Dyɨ ma au. La ka nɨ mʉ ngapa lɨe me: ‹Pana ’Dyɨ mʉ pɨ ya?› ");
INSERT INTO mdm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mʉ bhuka de me ma ngadʉ bhʉ́ ’Dyɨ ma, ’Dyɨ ma la di ngadʉ bhʉ́ ma-a dɨ? Oeli ɨnde ma ngapa e pɨ yi-e, ayie ka ma makpe de. Engʉ́ bini, ’Dyɨ ma ɨnde ngadʉ bhʉ́ ma-a, anɨ ngamene kulu gba e-o. ");
INSERT INTO mdm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yi bhuka ma, maka ma apa lɨe pɨ yi me ma ngadʉ bhʉ́ ’Dyɨ ma, ’Dyɨ ma la di ngadʉ bhʉ́ ma-o. Ɨ dʉ mo-o de-e, yi de bhuka ka kulu ɨnde ma ngamene e-o. ");
INSERT INTO mdm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A moko, ma apa pɨ yi na paká me: kpála ɨnde abhuka ma-a, anɨ améne bhadi okulu ɨnde ma ngamene e-o. Anɨ améne belegʉ okulu na ngbengbengbe ane bhende-e mane. Padhá de, anga ma adji agba ’Dyɨ ma. ");
INSERT INTO mdm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma améne ndʉ ’ngʉ́ hana ɨnde yi ayó e ne ’lɨ ma-a mamene, ngʉbula me ’Dyɨ ma sia sangu gba e bhʉ́ ma, Ndɨlɨ gba e ko. ");
INSERT INTO mdm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ɨ dʉ me yi nde ayo ’he ka ma ne ’lɨ ma-a, ma améne. ");
INSERT INTO mdm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ɨ dʉ me yi nde akʉnda ma-a, yi líla olɨ́lɨ gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma ayó ka ’Dyɨ ma me anɨ ha kpála koko ngʉ́ nateteke yi. Anɨ adʉ́ ne yi dʉdʉma ne dʉdʉma. ");
INSERT INTO mdm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A ko Bua na kʉkʉlʉ ’ngʉ́ ɨnde lɨ okpála na pɨ́la doto tɨ da nasia e de. Padhá de, anga u u anɨ de. U mbɨla la di anɨ de. Engʉ́ bini, ngayi-e, yi mbɨla anɨ hana, anga anɨ ngadʉ bhʉ́ ká yi. Anɨ la di ngadʉ bhʉ́ yi. ");
INSERT INTO mdm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma ꞌó ká yi kpi yi kpi maka otsulosɨ de. Engʉ́ bini, ma agíe matá lɨma agba yi magie. ");
INSERT INTO mdm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Atigala nedhɨnga bedɨ, okpála na pɨ́la doto ú matá ma de. Engʉ́ bini, ngayi-e, yi aú ma, anga ma bhʉ́ mʉkobho. Ngayi di-e, yi adʉ́ bhʉ́ mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lɨ ’kpɨ́ ango-o, yi ambɨ́la me ma ngadʉ bhʉ́ ’Dyɨ ma, yi ngadʉ bhʉ́ ma, ma la di ngadʉ bhʉ́ yi. ");
INSERT INTO mdm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kpála ɨnde akʉnda ma-a, a ko kpála ɨnde ngalila, di ne namene olɨ́lɨ gba ma-o. ’Dyɨ ma akʉ́nda kpála ɨnde akʉnda ma-o. Lɨ ma kʉ́nda di anɨ. Ma tsia pána lɨma pɨ anɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Abhomʉ-o, Yuda (a ko Yuda Ɨsɨkaliote de) apa pɨ Yesu me: «Ngámá, mo opána bha bini lɨmʉ pɨ ya, lele pɨ mʉ tsia pána lɨmʉ pɨ okpála na pɨ́la doto lɨe de-e?» ");
INSERT INTO mdm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu agie pɨ anɨ me: «Ɨ dʉ me kpála nde akʉnda ma-a, anɨ méne engʉ́ ɨnde ma ngapa e-o. Lɨ ’Dyɨ ma kʉ́nda anɨ. Ngaya ne ’Dyɨ ma-a, ya agó agba anɨ, ya tsia dʉ́lʉ oo ko. ");
INSERT INTO mdm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kpála ɨnde ɨ kʉnda ma de-e, anɨ méne oeli ma ngapa e de. Engʉ́ ɨnde yi ngadje ma ngapa e, a ngayie ka ma ade. Engʉ́ bini, a ngayie ka ’Dyɨ ma ɨnde atima ma ko. ");
INSERT INTO mdm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ma apa ongʉ́ bhomʉ-o pɨ yi lɨ nedhɨnga ɨnde nɨ́ nde ngabha lɨe ne yi bhʉ́ dabɨlɨ bini-o. ");
INSERT INTO mdm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","’Dyɨ ma atíma Bu Bhobua pɨ yi ne ’lɨ ma. Anɨ atéteke yi ngae. Bu Bhobua ango-o asúno ndʉ ’ngʉ́ hana pɨ yi ngae. Anɨ tsia méne di me yi bhundja ndʉ ’ngʉ́ hana ɨnde ma apa e pɨ yi ko. ");
INSERT INTO mdm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ma aꞌo pɨ yi guo ’ngʉ́ . Ma aha guo ’ngʉ́ gba ma-a pɨ yi. Ma ha pɨ yi maka lɨ okpála na pɨ́la doto ngahaha lɨe de. Kaka-a, yi aꞌó bua yi abhʉ́lá de. Yi adjé la di tsʉlʉ de. ");
INSERT INTO mdm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yi adje maka ma apa lɨe pɨ yi me: ‹Ma adji, engʉ́ bini, ma agíe matá lɨma agba yi magie.› Ɨ dʉ́ me yi kʉ́nda ma uu-o, yi de kpí djalɨ kabula me ma adji agba ’Dyɨ ma. Padhá de, anga ’Dyɨ ma ngbéngbé ane ma. ");
INSERT INTO mdm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma apa pɨ yi mbɨa ɨnde-e kala me ongʉ́ ango-o kolo, amba ɨ kolo-o, yi de bhuka. ");
INSERT INTO mdm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma gáma matá ’ngʉ́ ne yi ngengele de, anga ngámá na pɨ́la doto ɨnde-e ngago. Anɨ ne angu pɨ́ ma belegʉ ade bini. ");
INSERT INTO mdm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Engʉ́ bini, a ayo me okpála na pɨ́la doto mbɨla me ma kʉnda ’Dyɨ ma. U mbɨla la di me ma ngamene olɨ́lɨ ɨnde anɨ aha e mʉma-o. Yi yie bhʉ́lá! Nɨ́ yie sɨ yiyie.» ");
INSERT INTO mdm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ma ne ndula na vino na kʉkʉlʉ. ’Dyɨ ma la ne kpála ɨnde ngaleleke-o. ");
INSERT INTO mdm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Anɨ ngaꞌe ndʉ yáyá hana ɨnde akɵ lɨ ma ɨnde ɨ lɨ lɨ́lɨ́ de ko. Engʉ́ bini, anɨ ngaleke obhende ngalɨ lɨ́lɨ́-o, amba a lɨ matá lɨ́lɨ́ bhelé. ");
INSERT INTO mdm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eli ɨnde ma apa e pɨ yi-e, avʉlʉ yi avʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yi dʉ bhʉ́ ma, maka ma nde lɨe bhʉ́ yi ko. Padhá de, anga yá ndula ngae kpi e kpi tɨ da nalɨ lɨ́lɨ́ de, ɨ dʉ me a nde lɨ kʉte ’lá e ade ko. A bhadi moko, yi tɨ da nalɨ lɨ́lɨ́ de, ɨ dʉ me yi nde bhʉ́ ma ade ko. ");
INSERT INTO mdm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ma ne ndula na vino. Yi ne oyáyá-o. Kpála ɨnde ngadʉ bhʉ́ ma, ma nde la di ngadʉ bhʉ́ e-e, anɨ lɨ́ lɨ́lɨ́ bhelé. Padhá de, anga ɨ dʉ me yi nde bhʉ́ dabɨlɨ bini ne ma ade-e, yi tɨ da namene ’he bini de. ");
INSERT INTO mdm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kpála ɨnde bhʉ́ ma ade-e, u abhíke anɨ akilidjo maka u abhibhike yá ndula lɨe-o. Yá ndula-a ꞌʉ́lʉ, u há, u bhíke bhʉ́ djua, ɨ tsí. ");
INSERT INTO mdm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ɨ dʉ me yi nde bhʉ́ ma-a, ’li ma nde la di bhʉ́ yi-e, yi yo ehe ɨnde yi akʉnda e, amba yi sia. ");
INSERT INTO mdm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ɨ dʉ me yi nde alɨ lɨ́lɨ́ bhelé-e, yi suno di me yi ne omʉkpata gba ma-a, lɨ ’Dyɨ ma tsia sía sangu . ");
INSERT INTO mdm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Maka lɨ ’Dyɨ ma akʉnda ma lɨe, ma akʉnda bhadi yi moko. Yi dʉ bhʉ́ mʉkʉnda gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ɨ dʉ me yi nde alila olɨ́lɨ gba ma-a, yi dʉ́ bhʉ́ mʉkʉnda gba ma-o, maka ma alila olɨ́lɨ gba ’Dyɨ ma lɨe, ma ngadʉ bhʉ́ mʉkʉnda gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ma apa engʉ́ bhomʉ-o pɨ yi, ngʉbula me djalɨ gba ma-a dʉ bhʉ́ yi, amba djalɨ gba yi-e dʉ libhomu. ");
INSERT INTO mdm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lɨ́lɨ gba ma-a ngae ɨnde: yi kʉnda lɨyi sʉnda yi maka ma akʉnda yi lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mʉkʉnda na ngbéngbé ɨnde lɨ kpála tɨ da nasuno e, a ko naha mʉkobho gba e pɨ oolia e. ");
INSERT INTO mdm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yi ne oolia ma, ɨ dʉ me yi nde amene lɨ́lɨ gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma ngaꞌɨ matá yi me okpála na kulu ade. Padhá de, anga kpála na kulu mbɨla ehe ɨnde lɨ ngámá gba anɨ-e ngamene e de. Ma ngaꞌɨ yi me oolia ma. Padhá de, anga ma asuno ndʉ ’ngʉ́ hana ɨnde ma asia e ka ’Dyɨ ma-a pɨ yi asuno. ");
INSERT INTO mdm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yi bhʉ ma ngayi de. Engʉ́ bini, ma abhʉ yi ngama. Ma atima yi me yi nʉ zu nguwa ɨnde ɨ tɨ da nabhue mabhue, amba ndʉ ’he hana ɨnde yi ayó e ka ’Dyɨ ma ne ’lɨ ma-a, anɨ de ha pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","La-a, lɨ́lɨ ma aha e pɨ yi-e ngae ɨnde, yi kʉnda lɨyi sʉnda yi.» ");
INSERT INTO mdm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Ɨ dʉ me okpála na doto nde ngayala yi-e, yi mbɨla ndjɨndjɨ me u ayala ngaɨza ma pɨ yi kalanʉ. ");
INSERT INTO mdm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ɨ dʉ́ me, yi dʉ́ ne okpála na doto-o, okpála na doto de ngakʉnda yi. Padhá de, anga yi bhʉ́ ngʉ doto. Engʉ́ bini, ma abhʉ yi, ma atsia aꞌe yi bhʉ́ ká okpála na doto. Kaka-a, okpála na doto ngayala yi. ");
INSERT INTO mdm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yi bhundja engʉ́ ɨnde ma apa e pɨ yi-e me: ‹Kpála na kulu ngbéngbé ane ngámá gba e ade.› Maka nanɨ u ato mbolo lɨ ma lɨe, u ató bhadi mbolo lɨ yi moko. Ɨ dʉ́ me u djé ’li ma uu-o, u de adjé bhadi ’li yi moko. ");
INSERT INTO mdm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Engʉ́ bini, u améne ndʉ ’ngʉ́ bhomʉ-o hana lɨ yi kabula ma. Padhá de, anga u mbɨla kpála ɨnde atima ma-a de. ");
INSERT INTO mdm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ɨ dʉ́ me ma gó de-e, ɨ dʉ́ la di me ma kpókpo pɨ uo de-e, a de okpála namene siti ’ngʉ́ ade. Engʉ́ bini, mbɨa ɨnde-e, u mbú lɨ siti ’ngʉ́ ɨnde u amene e de. ");
INSERT INTO mdm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kpála ɨnde ayala ma-a, anɨ ayala di ’Dyɨ ma. ");
INSERT INTO mdm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma amene bhʉ́ ká uo ongamba ’ngʉ́ , ɨnde lɨ kpála bini mene nga e de. Ɨ dʉ́ me ma méne mo-o de-e, a de okpála namene siti ’ngʉ́ ade. Engʉ́ bini, u au ongamba ’ngʉ́ gba ma-o, u ayala ma, u atsia yala di ’Dyɨ ma. ");
INSERT INTO mdm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Engʉ́ bini, engʉ́ bhomʉ-o akolo ngʉbula me, eli ɨnde u aye e bhʉ́ lɨ́lɨ gba uo-o, amene lɨe, eli ɨnde me: ‹U ayala ma padhá, tata tété ade.› ");
INSERT INTO mdm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ma atíma pɨ yi kpála ɨnde a ayo me anɨ teteke yi-o. Kpála ango-o ayíe agba ’Dyɨ ma. A ko Bua na kʉkʉlʉ ’ngʉ́ ɨnde ayie agba ’Dyɨ ma-o. Nedhɨnga anɨ agó lɨe, anɨ akpókpo ’ngʉ́ gba ma-a ngae. ");
INSERT INTO mdm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ngayi di-e, yi akpókpo ’ngʉ́ gba ma-o. Padhá de, anga nɨ́ adʉ ne yi nayie lɨ lilita.» ");
INSERT INTO mdm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Ma apa ’ngʉ́ bhomʉ-o pɨ yi, amba yi aꞌó de me nabhuka gba yi-e kpi-e de. ");
INSERT INTO mdm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","U apándja yi bhʉ́ otɨ nadje lɨ́lɨ gba Moidje . La di-e, ekpɨ́ akólo makolo, lɨ okpála ɨnde abhíli yi-e adʉ́ abhundja lɨe me o ngamene lɨo bhomʉ-o kulu pɨ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","U améne mo-o, anga u mbɨla ’Dyɨ ma de, u mbɨla la di ma de. ");
INSERT INTO mdm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kaka-a, ma apa ’ngʉ́ ango-o pɨ yi kalanʉ, amba lɨ engʉ́ ango-o akólo lɨe, yi de bhundja me ma apa engʉ́ ango-o pɨ yi apa.» «Ma pa nga nanɨ engʉ́ ango-o pɨ yi nayie lɨ lilita de, anga nɨ́ adʉ nga nanɨ ne yi bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mbɨa ɨnde-e, ma adji agba kpála ɨnde atima ma ko. La-a, kpála bini bhʉ́ ká yi yi ma de me: ‹Mo odji su?› ");
INSERT INTO mdm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Engʉ́ bini, bua yi abedhe ne babuma, anga ma apa pɨ yi moko. ");
INSERT INTO mdm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma apa la pɨ yi na paká me, pɨ yi-e, a ndjɨndjɨ me ma nʉ. Padhá de, anga ɨ dʉ me ma nde nʉ de-e, kpála ɨnde atéteke yi-e gó-o de. Engʉ́ bini, ɨ dʉ me ma nde anʉ-o, ma tsia tíma anɨ pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nedhɨnga anɨ agó lɨe, anɨ asúno pɨ okpála na doto me u ngapite lɨo pɨndjɨ osisiti ’ngʉ́ ɨnde u ngamene e-o. U di ngapite lɨo pɨndjɨ ngbili ’ngʉ́ , di ne pɨndjɨ nakodho ’ngʉ́ gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","U ngapite lɨo pɨndjɨ osisiti ’ngʉ́ ɨnde u ngamene e, anga u bhuka ma de. ");
INSERT INTO mdm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","U ngapite lɨo pɨndjɨ ngbili ’ngʉ́, anga ma adji agba ’Dyɨ ma. La di-e, u ú matá ma de. ");
INSERT INTO mdm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","U ngapite lɨo pɨndjɨ nakodho ’ngʉ́, anga u akodho ’ngʉ́ gba ngámá na doto ɨnde-e akodho. ");
INSERT INTO mdm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ma matá ne engʉ́ bhelé napapa pɨ yi. Engʉ́ bini, yi tɨ da nakikibila mbɨa ɨnde-e de. ");
INSERT INTO mdm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nedhɨnga lɨ Bua na kʉkʉlʉ ’ngʉ́-o agó lɨe, anɨ asúno pɨ yi ndʉ okʉkʉlʉ ’ngʉ́ hana. Anɨ pá ’ngʉ́ gba e makpe-e de. Engʉ́ bini, anɨ apá ndʉ ’ngʉ́ hana ɨnde anɨ adjé e-o. Anɨ tsia pá di ndʉ ’ngʉ́ hana ɨnde akólo-o pɨ yi. ");
INSERT INTO mdm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Anɨ adhɵ́gɵ ma. Padhá de, anga ndʉ ’ngʉ́ hana ɨnde anɨ apá e pɨ yi-e, anɨ asía ka ma. ");
INSERT INTO mdm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndʉ ’he gba ’Dyɨ ma-a hana, a ko di naama ’he. Kaka-a, ma apa me ndʉ ’ngʉ́ hana ɨnde lɨ Bua apá e pɨ yi-e, ayíe ka ma.» ");
INSERT INTO mdm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Pɨta nedhɨnga bedɨ, yi ú matá ma de. La matá pɨta nedhɨnga bedɨ-e, yi ú ma.» ");
INSERT INTO mdm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Omʉkpata koko gba anɨ-e apa sʉnda o me: «Anɨ apa pɨ nɨ́ me: ‹Pɨta nedhɨnga bedɨ, yi ú matá ma de. La matá pɨta nedhɨnga bedɨ-e, yi ú ma.› Anɨ apa matá di me: ‹Ma adji agba ’Dyɨ ma.› Engʉ́ bhomʉ-o akʉnda napa pɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","U adʉ apa matá me: «Engʉ́ ɨnde anɨ ngapa e me: ‹Nedhɨnga bedɨ›, a akʉnda napa pɨ? Nɨ́ mbɨla engʉ́ ɨnde anɨ ngapa e de.» ");
INSERT INTO mdm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu ambɨla me, u ngakʉnda nayi nɨ. Abhomʉ-o, anɨ atsia apa pɨ uo me: «Yi ngagɨlɨ sʉnda yi ta ’ngʉ́ ɨnde me: ‹Pɨta nedhɨnga bedɨ, yi ú matá ma de. La matá pɨta nedhɨnga bedɨ-e, yi ú ma.› ");
INSERT INTO mdm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A moko, ma apa pɨ yi na paká me yi akú ’gbá, yi tsia lópolo di lɨyi. La-a, okpála na doto adʉ́ naao akpi djalɨ. Yi adʉ́ ne babuma engʉ́ bini, lɨkabhu gba yi-e adjí lɨe djalɨ. ");
INSERT INTO mdm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nedhɨnga lɨ ɵlɵ ngazu lɨe, anɨ dʉ́ adje lɨkabhu naali. Padhá de, anga nedhɨnga na lɨkabhu pɨ anɨ akolo. Engʉ́ bini, nedhɨnga ɨnde anɨ azu lɨe, anɨ ꞌɨ́lɨ ’to e ’to lɨkabhu ango-o hana ka djalɨ. Padhá de, anga u azu kpála-kʉtɨ pɨ́la doto. ");
INSERT INTO mdm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ngayi di-e, mbɨa ɨnde-e, yi bhʉ́ lɨkabhu. Engʉ́ bini, ma aú matá yi mau. Yi tsia kpí djalɨ lɨ bua yi. La di-e, kpála bini ꞌé djalɨ ango-o bhʉ́ yi de. ");
INSERT INTO mdm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lɨ ekpɨ́ ango-o akólo lɨe, yi yí matá ma lɨ ’ngʉ́ belegʉ de bini. A moko, ma apa pɨ yi na paká me ndʉ ’he hana ɨnde yi ayó e ka ’Dyɨ ma ne ’lɨ ma-a, anɨ ahá pɨ yi maha. ");
INSERT INTO mdm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nakolo pɨ mbɨa ɨnde-e, yi yo nga ’he ne ’lɨ ma belegʉ de bini. Yi yoyo, amba yi sia, ngʉbula me djalɨ gba yi-e dʉ bedhe.» ");
INSERT INTO mdm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Engʉ́ bini, ma apa ’ngʉ́ bhomʉ-o pɨ yi bhʉ́ ogbitaku. Nedhɨnga ɨnde ngago-o, ma pá matá ’ngʉ́ pɨ yi mo-o belegʉ de bini. La-a, nedhɨnga ango-o, ma akpókpo ongʉ́ gba ’Dyɨ ma-a pɨ yi mbámbá. ");
INSERT INTO mdm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lɨ ’kpɨ́ ango-o, yi ayó ’he ka ’Dyɨ ma ne ’lɨ ma. Ma pa la di pɨ yi de me, ma ayó ’Dyɨ ma Ebhe pɨ yi-e de. ");
INSERT INTO mdm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Padhá de, anga ’Dyɨ ma, ngae makpe akʉnda yi. Anɨ akʉnda yi, anga yi akʉnda ma. La di-e, anga yi abhuka me ma ayie agba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ma ayie agba ’Dyɨ ma. Ma atsia ago pɨ́la doto. Mbɨa ɨnde-e, ma ngaꞌo ká doto, ma tsia gíe lɨma agba ’Dyɨ ma.» ");
INSERT INTO mdm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Abhomʉ-o, omʉkpata gba anɨ-e atsia apa pɨ anɨ me: «Tsia nga mbɨa ɨnde-e, mʉ ngapa ’ngʉ́ mbámbá. Mʉ matá ngapapa bhʉ́ ogbitaku ade. ");
INSERT INTO mdm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mbɨa ɨnde-e, ya ambɨla me, mʉ ngambɨla ndʉ ’ngʉ́ hana. A padhá me u yi mʉ lɨ ’ngʉ́. Kaka-a, ya ngabhuka me mo oyie agba Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu atsia agie pɨ uo me: «Yi abhuka la mbɨa ɨnde-e abhuka? ");
INSERT INTO mdm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yi tsitsia nga. Nedhɨnga ngago, mbɨa ɨnde-e, nedhɨnga ango-o akolo, nedhɨnga ɨnde yi andjámbala lɨe má mʉe! Kpála ne kpála atápa lɨ kpadjɨ gba e. Yi tsia ꞌó la di ká ma kpi ma kpi. Engʉ́ bini, ma la kpi ma kpi ade, anga ’Dyɨ ma bhʉ́ dabɨlɨ bini ne ma. ");
INSERT INTO mdm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma apa ’ngʉ́ bhomʉ pɨ yi, amba yi sia guo ’ngʉ́ bhʉ́ ma. Yi asía lɨkabhu pɨ́la doto. Engʉ́ bini, yi adjé tsʉlʉ de! Padhá de, anga ma aha angu doto aha.» ");
INSERT INTO mdm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pɨta lɨ Yesu apa ongʉ́ bhomʉ-o lɨe, anɨ atsia ’kpɨ́ ne bhʉ́lá, anɨ atsia apa me: «’Dyɨ ma, nedhɨnga akolo. Ha sangu mʉma, ngama Ndɨlɨ gba mʉ-o, amba ngama, Ndɨlɨ gba mʉ-o, ma ha di sangu pɨ mʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Padhá de, anga mo oha angu mʉma pɨ́ ’ndjɨ ndʉ okpála hana, amba ma ha mʉkobho na dʉdʉma pɨ ndʉ okpála hana ɨnde mo oha o mʉma-o. ");
INSERT INTO mdm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","La-a, mʉkobho na dʉdʉma-a, a ko me u mbɨla mʉ, ngamʉ koli Ebhe ɨnde na kʉkʉlʉ-o. A ko me u mbɨla la di Yesu Kilisito , kpála ɨnde mo otima e-o. ");
INSERT INTO mdm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma aha sangu pɨ mʉ pɨ́la doto. Ma andjia kulu ɨnde mo oha e mʉma me ma mene e andjia. ");
INSERT INTO mdm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","La mbɨa ɨnde-e, ’Dyɨ ma, ha sangu mʉma de mʉ, sangu ɨnde ma adʉ nanɨ ne e agba mʉ kala me u bho doto ko.» ");
INSERT INTO mdm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Ma asuno ’lɨ mʉ pɨ okpála ɨnde mo ꞌe o bhʉ́ ká okpála na doto, mo otsia aha o mʉma-o. A ko nanɨ okpála ka mʉ, mo otsia aha uo mʉma. U atsia alila la di ’li mʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mbɨa ɨnde-e, u ambɨla me ndʉ ’he ɨnde mo oha e mʉma hana, ayie ka mʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Padhá de, anga oeli ɨnde mo okpokpo e mʉma-a, ma akpokpo pɨ uo. U asia oeli ango-o. U ambɨla na paká me ma ayie agba mʉ. U atsia abhuka di me mo otima ma ngamʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ma ngayo mʉ ngʉbula uo. Ma ngayo mʉ ngʉbula okpála na doto ade. Engʉ́ bini, ma ngayo ngʉbula obhende mo oha o mʉma ko. Padhá de, anga a ko okpála ka mʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ndʉ ’he ɨnde ka ma-a hana, a ko naamʉ. Ndʉ ’he ɨnde la di ka mʉ-o hana, a ko naama. La di-e, ma atsia asia sangu ka uo. ");
INSERT INTO mdm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma matá ne kpála na doto ade. Engʉ́ bini, ngauo-o, a ko okpála na doto. Ngama-a, ma adji agba mʉ. ’Dyɨ ma ɨnde bubu, lila uo ne ’lɨ mʉ ɨnde mo oha e mʉma-o, amba u dʉ bini maka nganɨ́ ne mʉ, nɨ́ nde lɨe bini-o. ");
INSERT INTO mdm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nedhɨnga ya adʉ lɨe ne uo-o, ma alila uo ne ’lɨ mʉ ɨnde mo oha e mʉma ko. Ma alila uo ndjɨndjɨ, kpála bini bhʉ́ ká uo ngɨta de. Angɨta bha bini ne kpála ɨnde a ayo me anɨ ngɨta-o ngʉbula me engʉ́ ɨnde u aye e bhʉ́ Bhuku-o, a amene lɨe. ");
INSERT INTO mdm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","La mbɨa ɨnde-e, ma adji agba mʉ. Ma ngapa mo-o lɨ nedhɨnga ɨnde ma nde nga lɨe pɨ́la doto, amba u sia djalɨ gba ma-a bhʉ́ o makpe, u bedhe la di ne di bedhe. ");
INSERT INTO mdm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma aha ’li mʉ pɨ uo. Okpála na doto atsia ayala uo. Padhá de, anga uo bhʉ́ ngʉ doto ade, maka ma nde lɨe bhʉ́ ngʉ doto ade ko. ");
INSERT INTO mdm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma ngayo mʉ ade me mʉ ꞌe uo pɨ́la doto maꞌe-e de. Engʉ́ bini, ma ngayo mʉ me lila uo sakpa Siti malila. ");
INSERT INTO mdm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A ko okpála na doto de, maka ma nde lɨe ne kpála na doto ade ko. ");
INSERT INTO mdm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mene me u dʉ libhomu bubu lɨ kpadjɨ na kʉkʉlʉ ’ngʉ́. ’Li mʉ-o, a ko kʉkʉlʉ ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ma atima uo pɨ́la doto, maka mo otima ma lɨe pɨ́la doto-o. ");
INSERT INTO mdm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ngama makpe-e, ma aha lɨma hana pɨ mʉ ngʉbula me ngauo di-e, u ha lɨo hana pɨ mʉ lɨ kpadjɨ na kʉkʉlʉ ’ngʉ́.» ");
INSERT INTO mdm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ma ngayo bha bini ngʉbula uo ade. Engʉ́ bini, ma di ngayo ngʉbula okpála bhende abhúka ma ka ’li uo ko. ");
INSERT INTO mdm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma ngayo me ndʉ uo hana dʉ bini. ’Dyɨ ma, a ayo me u dʉ bhʉ́ nɨ́, maka mʉ nde lɨe bhʉ́ ma, ma la di bhʉ́ mʉ-o. A ayo me u dʉ bini, amba okpála na doto bhuka me mo otima ma ngamʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma aha sangu ɨnde mo oha e mʉma-a pɨ uo, amba u dʉ bini maka nganɨ́ ne mʉ nɨ́ nde lɨe bini-o. ");
INSERT INTO mdm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ma bhʉ́ uo, mʉ la di bhʉ́ ma. Abhomʉ-o, u tɨ́ da nadʉ bha ndjʉ bini, amba okpála na pɨ́la doto mbɨla me mo otima ma ngamʉ, u mbɨla la di me mo okʉnda uo maka mo okʉnda ma lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Dyɨ ma, mo oha uo mʉma. Ma akʉnda me u dʉ bhʉ́ dabɨlɨ bini ne ma lɨ bɨlɨ ɨnde ma nde lɨ e, amba u u sangu gba ma ko, sangu ɨnde mo oha e mʉma anga mo okʉnda ma kala nabho doto. ");
INSERT INTO mdm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","’Dyɨ ma ɨnde ngbingbili, okpála na pɨ́la doto mbɨla mʉ de. Engʉ́ bini, ngama-a, ma ambɨla mʉ. Okpála ɨnde-e ambɨla la di me mo otima ma ngamʉ. ");
INSERT INTO mdm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma asuno ’lɨ mʉ pɨ uo. Ma asúno la matá mʉ pɨ uo masuno, ngʉbula me mʉkʉnda ɨnde mʉ nde ne e mʉma-a dʉ bhʉ́ uo, amba ngama makpe-e, ma dʉ di bhʉ́ uo.» ");
INSERT INTO mdm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pɨta lɨ Yesu andjia nayo Ebhe lɨe, anɨ anʉ ne omʉkpata gba e ayi mʉtselemʉtsele ɨnde ’lɨ e me Sedolo. Edyɨ bini adʉ oo. Yesu atsia alɨ ne omʉkpata gba e bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, bhʉlʉ napʉ Yesu-o adʉ ambɨla di bɨlɨ ango-o ndjɨndjɨ. Padhá de, anga Yesu ne omʉkpata gba e adʉ anʉ oo pɨko. ");
INSERT INTO mdm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Abhomʉ-o, Yuda anʉ abhʉ́ ’dyɨ oo bhʉ́ dabɨlɨ bini ne ká osʉdha, di ne omʉlila na ’ngbé ’tɨ Ebhe gba omaYuda, ɨnde lɨ ongbengbe odimandɵ di ne omʉFalisai atima o-o. A adʉ sa ’kpa osʉdha-a ne otolosi, ne oeke, di ne otɨa ’gʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","La-a, Yesu ɨnde adʉ ambɨla ndʉ ’ngʉ́ ɨnde akólo lɨ kʉte e hana-a, adyudyo lɨe de uo. Anɨ atsia ayi uo me: «Yi ngagɨlɨ da?» ");
INSERT INTO mdm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","U agie pɨ anɨ me: «Ya ngagɨlɨ Yesu, kpála na Nadjaleta.» Yesu atsia apa pɨ uo me: «A ko ma.» Yuda, bhʉlʉ napʉ Yesu-o adʉ di bhʉ́ dabɨlɨ bini ne uo. ");
INSERT INTO mdm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lɨ Yesu apa pɨ uo lɨe me: «A ko ma-a», u agbe lɨo ne sidi, u atuko kuto má dhululu! ");
INSERT INTO mdm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu atsia ayi matá uo me: «Yi ngagɨlɨ da?» U agie me: «Ya ngagɨlɨ Yesu, kpála na Nadjaleta.» ");
INSERT INTO mdm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu apa pɨ uo me: «Ma apa ɨgɨnɨ pɨ yi apa me, a ko ma. Ɨ dʉ la me, yi nde ngagɨlɨ ma-a, yi de ꞌo okpála koko-o, amba u gbida naao.» ");
INSERT INTO mdm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Engʉ́ bhomʉ-o amene lɨe mo-o, ngʉbula me eli ɨnde nanɨ lɨ Yesu apa e, amene lɨe, eli ɨnde anɨ apa nanɨ e me: «’Dyɨ ma, bhʉ́ ká okpála ɨnde mo oha o mʉma-a, sʉka uo bini ngɨta ka ma de.» ");
INSERT INTO mdm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simo Piele adʉ ne mbotɨa ludu e. Anɨ aluko ngise ango-o bhʉ́ ’tɨ e má vuu! Anɨ asʉ Malakusɨ, kpála na kulu gba ’ngbé dimandɵ gba Ebhe-o . Anɨ atsia akodho kpadje anɨ lɨ pápá na kokpa-a má tse! ");
INSERT INTO mdm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Engʉ́ bini, Yesu atsia apa pɨ Piele me: «Gie mbotɨa gba mʉ-o bhʉ́ tɨtɨ. Mo obhundja naamʉ me lɨkabhu ɨnde lɨ ’Dyɨ ma aha e mʉma-a, ma azʉ́-ʉ dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Abhomʉ-o, osʉdha ne ngámá gba o, di ne omʉlila na ’ngbé ’tɨ Ebhe gba omaYuda ɨnde anʉ naholo Yesu-o, atsia aholo anɨ. U agbite anɨ ne ekpʉ. ");
INSERT INTO mdm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","U atsia anʉ ngaɨza ne anɨ gba Ana. Ana ango-o, a ko nanɨ ’dyɨ wala Kaifa. Kaifa adʉ nanɨ bhele kpála gba odimandɵ bhʉ́ kalanga bhomʉ-o ngae. ");
INSERT INTO mdm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Abhomʉ-o, Kaifa atsia aha nanɨ mabhundja pɨ ongámásɨ gba omaYuda ngae me, a ndjɨndjɨ mangbo me koli kpála bini kpi ngʉbula ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Piele, ngauo ne mʉkpata koko adʉ akpata Yesu. Bhele kpála gba odimandɵ-o ambɨla nanɨ mʉkpata ango-o ndjɨndjɨ. Kaka-a, mʉkpata ango-o alɨ nanɨ ne Yesu bhʉ́ dabɨlɨ bini bhʉ́ mbadhasʉ gba bhele kpála gba odimandɵ-o. ");
INSERT INTO mdm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Engʉ́ bini, Piele atigala naae lɨ ’bhɵ aga akilidjo. Abhomʉ-o, mʉkpata koko ɨnde lɨ bhele kpála gba odimandɵ-o ambɨla e ndjɨndjɨ-e akoto. U agama ’ngʉ́ ne ɵlɵ ɨnde adʉ alila ’bhɵ aga-o. Anɨ atsia ato Piele. ");
INSERT INTO mdm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɵlɵ ɨnde adʉ bhʉ́ kulu nalila ’bhɵ aga-a, apa pɨ Piele me: «Ngamʉ di-e, mʉ ndi ne sʉka omʉkpata gba kpála ɨnde-e adɨ?» Piele agie pɨ anɨ me: «A mo-o ade, ma ne sʉka uo ade.» ");
INSERT INTO mdm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Okpála na kulu, di ne omʉlila na ’ngbé ’tɨ Ebhe gba omaYuda-a akpo djua na makala. U ago alʉlʉ dede ngʉ́ natʉtʉ. Padhá de, anga zini adʉ naali. Piele ago alʉ di bhʉ́ dabɨlɨ bini ne uo ngʉ́ natʉ djua-o. ");
INSERT INTO mdm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Abhomʉ-o, bhele kpála gba odimandɵ-o aholo nayiyi Yesu pɨndjɨ ’ngʉ́ gba omʉkpata gba anɨ, di ne pɨndjɨ nasuno gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu agie pɨ anɨ me: «Ma akpokpo ’ngʉ́ mbámbá pɨ ndʉ okpála hana. Ma adʉ asuno ndʉ ’kpɨ́ hana bhʉ́ otɨ nadje lɨ́lɨ gba Moidje , di ne bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda lɨ bɨlɨ lɨ ndʉ omaYuda hana adʉ apɵkɵbhɵ bhʉ́la o lɨ e-o. Ma pa ’ngʉ́ bhʉ́ pepe belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mʉ ngayi ma ka nɨ? Yi okpála ɨnde adje ma-a me ma apa pɨ. Padhá de, anga u mbɨla engʉ́ ɨnde ma apa e ndjɨndjɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Lɨ Yesu apa lɨe mo-o, sʉka okpála nalila ’ngbé ’tɨ Ebhe gba omaYuda-a asʉ pála anɨ má pa! Anɨ atsia apa pɨ anɨ me: «Abhomʉ-o eli ɨnde mʉ tɨ da nagie e pɨ bhele kpála gba odimandɵ gba Ebhe-e?» ");
INSERT INTO mdm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu atsia apa pɨ anɨ me: «Engʉ́ ɨnde ma apa e, ɨ dʉ me a nde sisiti-e, yi de suno sisiti ango-o. Engʉ́ bini, ɨ dʉ la me ma nde apa ndjɨndjɨ-e, mo otsia asʉ la ma ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Abhomʉ-o, Ana atsia atima Yesu pɨ Kaifa, bhele kpála gba odimandɵ-o me u nde agbigbite anɨ magbigbite. ");
INSERT INTO mdm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nedhɨnga ango-o, Simo Piele alʉ de djua-o. Anɨ adʉ atʉtʉ. U atsia apa pɨ anɨ me: «Ngamʉ di-e, mʉ ne sʉka omʉkpata gba kpála ɨnde-e adɨ?» Piele ayala, anɨ atsia apa me: «A mo-o ade, ma ne sʉka uo ade.» ");
INSERT INTO mdm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sʉka okpála na kulu gba bhele kpála gba odimandɵ gba Ebhe-e, ɨnde adʉ kpála na piga gba kpála lɨ Piele akodho kpadje e, ayi Piele me: «A ko mʉ dɨ ɨnde ma au nako e ne Yesu abhʉ́ ’dyɨ-e?» ");
INSERT INTO mdm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Engʉ́ bini, Piele atsia ayala matá. Bha bini lɨ nedhɨnga ango-o, engʉ atsia aku ’gbá. ");
INSERT INTO mdm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Abhomʉ-o, omaYuda ayie ne Yesu agba Kaifa, u atsia anʉ ne anɨ agba ngámá na Loma , ɨnde adʉ atsia ’kpɨ́ lɨ ndu doto-o. A adʉ kɵkpɨ́ má bhɵ! Engʉ́ bini, omaYuda lɨ naao abhʉ́ ’tɨ oo de. Padhá de, anga u adʉ akʉnda nadʉ bubu kala Ebhe, amba o zʉ anokomɨa na Pasɨka-o . ");
INSERT INTO mdm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kaka-a, Pɨlatɵ ngámá na ndu doto ango-o ago abhaka uo akilidjo. Anɨ atsia ayi uo me: «Yi agbe kpála ɨnde-e kala ma me anɨ nde amene mangua siti ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","U agie pɨ anɨ me: «Lɨ kpála ɨnde-e dʉ́ ne siti kpála de-e, ya de go ne anɨ pɨ mʉ de.» ");
INSERT INTO mdm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Abhomʉ-o, Pɨlatɵ atsia apa pɨ uo me: «Yi ha anɨ ngayi makpe, amba yi kodho ’ngʉ́ gba anɨ-e maka lɨ lɨ́lɨ gba yi-e apa lɨe ko.» OmaYuda agie pɨ anɨ me: «U ha kpadjɨ pɨ ya ngʉ́ nabhɵlɵ kpála de.» ");
INSERT INTO mdm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Engʉ́ bhomʉ-o amene lɨe mo-o ngʉ́ nakpata engʉ́ ɨnde lɨ Yesu apa nanɨ e-o. Engʉ́ ɨnde anɨ apa nanɨ e ngʉ́ nasuno lele maka anɨ akpí lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Abhomʉ-o, Pɨlatɵ agie matá lɨe abhʉ́ ’tɨ. Anɨ aꞌɨ Yesu, anɨ atsia ayi anɨ me: «Mʉ ne ’ngbé ngámá gba omaYuda?» ");
INSERT INTO mdm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu agie pɨ anɨ me: «Engʉ́ ɨnde mo opa e bhomʉ-o, mo obhundja bha ngamʉ makpe? Ne me okpála koko apa ’ngʉ́ gba ma-a pɨ mʉ ngao!» ");
INSERT INTO mdm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pɨlatɵ agie pɨ anɨ me: «Ngama-a, ma ne maYuda? Okpála na kʉtɨ gba mʉ di ne ongbengbe odimandɵ gba Ebhe-e apʉ mʉ mʉma. Mo omene la mangua ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu agie pɨ anɨ me: «Naʉ gba ma-a, a ko bhende na doto ɨnde-e de. Ɨ dʉ́ bhende na doto ɨnde-e, okpála gba ma-a de agʉ ’gʉ́, ngʉbula me u apʉ́ ma pɨ omaYuda de. Engʉ́ bini, naʉ gba ma-a, a ko bhende na doto ɨnde-e de.» ");
INSERT INTO mdm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pɨlatɵ atsia apa pɨ anɨ me: «A akʉnda napa me, mʉ ne ’ngbé ngámá?» Yesu agie pɨ anɨ me: «Mo opa ngamʉ me ma ne ’ngbé ngámá. U azu ma, ma atsia ago pɨ́la doto ngʉ́ nakpokpo ’ngʉ́ pɨndjɨ kʉkʉlʉ ’ngʉ́. Kpála ɨnde bhʉ́ kʉkʉlʉ ’ngʉ́-o ngadje engʉ́ ɨnde ma ngapa e-o.» ");
INSERT INTO mdm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pɨlatɵ ayi anɨ me: «Kʉkʉlʉ ’ngʉ́-o, a ko nɨ?» Pɨta lɨ Pɨlatɵ apa ’ngʉ́ bhomʉ-o lɨe, anɨ akoto, anɨ anʉ matá nabhaka omaYuda akilidjo. Anɨ atsia apa pɨ uo me: «Ma u engʉ́ ɨnde u tɨ da nabhɵlɵ kpála ɨnde-e ka e belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Engʉ́ bini, maka u amemene lɨe agba yi-e, bhʉ́ anokomɨa na Pasɨka-a, a ayo me ma tse ’kpa lɨ bhʉlʉ ’kpʉ́ pɨ yi bini. Yi akʉnda me ma tse ’kpa lɨ ’ngbé ngámá gba omaYuda-a pɨ yi?» ");
INSERT INTO mdm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Abhomʉ-o, u aholo asʉsʉla me: «Ɨɨ-ɨ! Ngaanɨ de. Engʉ́ bini, tse mangbo pɨ ya ’kpa lɨ Balabasɨ!» La-a, Balabasɨ nanɨ ne ’ngbé bhʉlʉ ’zi. ");
INSERT INTO mdm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Abhomʉ-o, Pɨlatɵ atsia apa me u go ne Yesu, amba u bhɨ anɨ ne fimbo. ");
INSERT INTO mdm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Osʉdha agala ehe na eti má kilili, u ato bhʉ́ ’ndjɨ anɨ! U atsia ato di bongo na zʉmbe zʉmbe lɨ kʉte anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","U adʉ ago de anɨ. U atsia adʉ apa pɨ anɨ me: «’Ngbé ngámá gba omaYuda-a, atou!» U adʉ di nabhɨ bhʉ́la anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Abhomʉ-o, Pɨlatɵ akoto matá kilidjo. Anɨ atsia apa pɨ uo me: «Yi djedje nga! Ma agbé anɨ pɨ yi kilidjo ei, amba yi mbɨla ndjɨndjɨ me ma u belegʉ ehe bini de ɨnde ma tɨ da naholo anɨ ngʉ́ e.» ");
INSERT INTO mdm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Abhomʉ-o, Yesu atsia akoto kilidjo me u nde ato ehe na eti-e bhʉ́ ’ndjɨ anɨ, anɨ nde di ne bongo na zʉmbe zʉmbe lɨ kʉte e. Abhomʉ-o, Pɨlatɵ atsia apa pɨ uo me: «Kpála ango-o ɨ!» ");
INSERT INTO mdm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Engʉ́ bini, lɨ ongbengbe odimandɵ gba Ebhe , di ne omʉlila na ’ngbé ’tɨ Ebhe au anɨ lɨe me-e, u aholo nasʉsʉla me: «Gɨ anɨ lɨ kulusi! Gɨ anɨ lɨ kulusi!» Pɨlatɵ apa pɨ uo me: «Yi nʉ gɨ anɨ lɨ kulusi ngayi makpe. Padhá de, anga ngama-a, ma u belegʉ ehe bini de ɨnde ma tɨ da naholo anɨ ngʉ́ e.» ");
INSERT INTO mdm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","OmaYuda agie pɨ anɨ me: «A ka ya ne lɨ́lɨ. A ayo me anɨ kpi maka lɨ lɨ́lɨ ango-o apa lɨe-o. Padhá de, anga anɨ apa me nɨ ne ndɨlɨ gba Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lɨ Pɨlatɵ adje engʉ́ bhomʉ-o lɨe, anɨ adje matá tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Anɨ agie lɨe abhʉ́ ’tɨ. Anɨ atsia ayi Yesu me: «Mo oyie su?» Engʉ́ bini, Yesu gie ’ngʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Abhomʉ-o, Pɨlatɵ atsia apa pɨ anɨ me: «Mʉ kʉnda nagama ’ngʉ́ mʉma dɨ? Mʉ mbɨla de me ma ne angu natse ’kpa lɨ mʉ. Ma la di ne angu nagɨ mʉ lɨ kulusi-e dɨ?» ");
INSERT INTO mdm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu atsia apa pɨ anɨ me: «Mʉ ne angu pɨ́ ma belegʉ ade bini. Ɨ dʉ́ me Ebhe há angu pɨ mʉ de-e, mʉ de tɨ da namene ’he bini ngʉ́ ma de. Kaka-a, kpála ɨnde apʉ ma pɨ mʉ-o, amene siti ’ngʉ́ naali ane mʉ.» ");
INSERT INTO mdm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nayie lɨ nedhɨnga bhomʉ-o, Pɨlatɵ adʉ agɨlɨ kpadjɨ me nɨ tse ’kpa lɨ Yesu. Engʉ́ bini, omaYuda aholo asʉsʉla me: «Ɨ dʉ me mʉ nde atse ’kpa lɨ kpála bhomʉ-o, amba mʉ kʉnda ’ngbé ngámá Kaisala de! Ndʉ kpála hana ɨnde apa me nɨ ne ’ngbé ngámá-a, a ko bhʉlʉ yala gba ’ngbé ngámá Kaisala!» ");
INSERT INTO mdm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Lɨ Pɨlatɵ adje eli bhomʉ-o lɨe, anɨ agbe Yesu kilidjo. Pɨlatɵ atsia adʉ pɨ́ dabɨlɨ nakodho ’ngʉ́-o, lɨ bɨlɨ ɨnde u aꞌɨ e me «U apa oteme kuto» (ɨnde u aꞌɨ e bhʉ́ eli na ebele me «Gabata»). ");
INSERT INTO mdm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A adʉ nanɨ masɨkpe de tulukpe, kala ekpɨ́ na Pasɨka. Pɨlatɵ apa pɨ omaYuda me: «’Ngbé ngámá gba yi-e ɨ!» ");
INSERT INTO mdm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Engʉ́ bini, u aholo nasʉsʉla me: «Bhɵlɵ anɨ! Bhɵlɵ anɨ! Gɨ anɨ lɨ kulusi!» Pɨlatɵ apa pɨ uo me: «A ayo me ma gɨ ’ngbé ngámá gba yi-e lɨ kulusi?» Ongbengbe odimandɵ gba Ebhe-e agie pɨ anɨ me: «’Ngbé ngámá koko ka ya ade. A ko bha bini ’ngbé ngámá Kaisala.» ");
INSERT INTO mdm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Abhomʉ-o, Pɨlatɵ atsia atse ’kpa lɨ Yesu ngʉbula me u gɨ anɨ lɨ kulusi. U aha Yesu, u atsia atapa ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu abɨ kulusi gba e ngae makpe. Anɨ atsia akoto nayie bhʉ́ gʉdhʉ akolo lɨ bɨlɨ na «Pelege ’ndjɨ» (u aꞌɨ e bhʉ́ eli na ebele me «Gologota»). ");
INSERT INTO mdm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A bhomʉ-o bɨlɨ ɨnde lɨ osʉdha agɨ Yesu lɨ e lɨ kulusi-o. U atsia agɨ di okpála koko bhisi lɨ kulusi. Yesu adʉ tʉtʉ, koko lɨ kulusi gba e lɨ pá ’kpa anɨ na kokpa, koko lɨ kulusi gba e lɨ pá ’kpa anɨ na galɨ. ");
INSERT INTO mdm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pɨlatɵ atsia aha di lɨ́lɨ me, u ye balʉa, amba u bhɨ lɨ kulusi gba Yesu-o. Balʉa ango-o adʉ me: «Yesu, kpála na Nadjaleta, ’ngbé ngámá gba omaYuda.» ");
INSERT INTO mdm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Abhomʉ-o, omaYuda bhelé atanga balʉa ango-o. Padhá de, anga bɨlɨ ɨnde u agɨ nanɨ Yesu lɨ kulusi lɨ e, a adʉ de gʉdhʉ masɨkpe. La di-e, balʉa ango-o adʉ bhʉ́ eli na ebele, a adʉ bhʉ́ eli na latino, a atsia adʉ di bhʉ́ eli na giliki. ");
INSERT INTO mdm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Abhomʉ-o, ongbengbe odimandɵ gba omaYuda atsia apa pɨ Pɨlatɵ me: «Mo oyé de me, ‹’ngbé ngámá gba omaYuda-a› de. Engʉ́ bini, ye mangbo me, ‹Kpála bhomʉ-o apa me, ma ne ’ngbé ngámá gba omaYuda.›» ");
INSERT INTO mdm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pɨlatɵ agie pɨ uo me: «Bhende ma aye e, adjí lɨe de.» ");
INSERT INTO mdm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lɨ osʉdha agɨ Yesu lɨ kulusi lɨe, u abha obongo gba anɨ-o. U agbo bhʉsʉ bhʉsʉ badha. Sʉdha bini ne bini aha naae bini. U atsia aha di bongo gba anɨ ɨnde u dʉ e madʉ de-o. Pápála adʉ bha bini nayie abhʉ́lá akolo akuto. ");
INSERT INTO mdm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Osʉdha-a apa sʉnda o me: «Nɨ́ asídha bongo ɨnde-e de. Engʉ́ bini, nɨ́ gʉ mangbo gbanda tété, amba nɨ́ mbɨla me a adʉ́ na da.» U amene mo-o ngʉbula me eli ɨnde u aye e bhʉ́ Bhuku-o, amene lɨe, eli ɨnde me: «U agbogbo bhʉsʉ o lɨ obongo gba ma-o. U atsia agʉ gbanda lɨ bongo gba ma ko.» A bhomʉ-o engʉ́ ɨnde lɨ osʉdha amene e-o. ");
INSERT INTO mdm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Malɨa , ’hi Yesu, ne ndai e na ɵɵlɵ, ne Malɨa , wala Kolopasɨ, di ne Malɨa , kpála na kʉtɨ na Magadala, alʉlʉ de kulusi gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu au ’hi e ne mʉkpata ɨnde lɨ anɨ adʉ akʉnda e naali-o. Mʉkpata ango-o adʉ me anɨ nde alʉ de ’hi anɨ oo. Anɨ atsia apa pɨ ’hi e me: «Ɵlɵ-e, tsia ndɨlɨ gba mʉ-o ɨ.» ");
INSERT INTO mdm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pɨpɨta-a, anɨ atsia apa pɨ mʉkpata-a me: «Tsia ’hi mʉ ɨ.» Nayie lɨ nedhɨnga bhomʉ-o, mʉkpata-a atsia aha ’hi Yesu agba e. ");
INSERT INTO mdm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pɨta ongʉ́ bhomʉ-o, Yesu ambɨla me, mbɨa ɨnde-e, ndʉ ’ngʉ́ hana andjia. Abhomʉ-o, ngʉbula me ’li Bhuku-o amene lɨe akolo alɨ soso-o, anɨ atsia apa me: «A lɨ ma ne gʉmʉ ’ngu.» ");
INSERT INTO mdm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lʉsa bini adʉ oo. A adʉ bhʉ́bhʉ́ ne kpongadha pandɨ bedhe. Osʉdha aha epondje, u ato bhʉ́ kpongadha pandɨ-o. U agbite lɨ ndula ɨnde u aꞌɨ e me idjope. U atsia adyudyo de ’bhɵ Yesu masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lɨ Yesu andjɨ kpongadha pandɨ-e lɨe, anɨ atsia apa me: «Ndʉ ’ngʉ́ hana andjia!» Abhomʉ-o, anɨ atʉ ’ndjɨ e ne kuto, anɨ atsia andala ’kpa lɨ bua e. ");
INSERT INTO mdm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A adʉ nanɨ ekpɨ́ ɨnde u adʉ aleke lɨo lɨe ngʉ́ ekpɨ́ naguo-o . Ongámásɨ gba omaYuda dʉ akʉnda de me okuo okpála dʉ lɨ okulusi lɨ ’kpɨ́ naguo-o de. Padhá de, anga ekpɨ́ naguo ango-o, adʉ ngbéngbé ane okoko mane. Kaka-a, u atsia ayo ka Pɨlatɵ me u gʉgʉmʉ ’dhʉ okpála ɨnde u agɨ o lɨ okulusi-o, amba u ꞌe okuo uo tété maꞌe. ");
INSERT INTO mdm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Abhomʉ-o, osʉdha ago de okpála ɨnde u agɨ o lɨ okulusi bhʉ́ dabɨlɨ bini ne Yesu-o. U agʉgʉmʉ ’dhʉ kpála bhe na kalanʉ-o. Pɨpɨta-a, u agʉgʉmʉ ’dhʉ kpála bhe koko-o. ");
INSERT INTO mdm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","U akolo lɨe lɨ Yesu-o, u abhaka me anɨ nde akpi. Kaka-a, u gʉgʉmʉ ’dhʉ anɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Engʉ́ bini, sʉdha bini adʉ pá kala anɨ ne mandambi má pʉʉ! Kolo me-e, ngʉte di ne engu aze bhʉ́ eka ango-o. ");
INSERT INTO mdm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kpála ɨnde ngakpokpo ongʉ́ ɨnde-e, au ongʉ́ ango-o ne djila e. La di-e, ongʉ́ ɨnde anɨ ngakpokpo e, a ko kʉkʉlʉ ’ngʉ́. Ngaanɨ-e, anɨ mbɨla ndjɨndjɨ me nɨ ngakpo e kʉkʉlʉ ’ngʉ́. Anɨ ngakpokpo ngʉbula me ngayi di-e, yi bhuka. ");
INSERT INTO mdm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ongʉ́ bhomʉ-o akolo ngʉbula me engʉ́ ɨnde u aye e bhʉ́ Bhuku-o, amene lɨe, engʉ́ ɨnde u aye e me: «U gʉ́mʉ sʉka bɨkɨ anɨ belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","La di-e, u aye bhʉ́ Bhuku lɨ bɨlɨ koko me: «U atsía kpála ɨnde u adʉ e-o.» ");
INSERT INTO mdm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pɨta ongʉ́ akodho ’kpɨ́-e, Djodjefʉ , kpála na gʉdhʉ na Alimatayo, ayo ka Pɨlatɵ me anɨ ha kpadjɨ pɨ nɨ ngʉ́ naꞌe kuo Yesu. (Djodjefʉ nanɨ ne sʉka omʉkpata gba Yesu-o. Engʉ́ bini, anɨ dʉ asuno lɨe mbámbá de, anga anɨ adʉ akpe ongámásɨ gba omaYuda-o.) Pɨlatɵ azɨba pɨ anɨ. Abhomʉ-o, Djodjefʉ anʉ, anɨ atsia aꞌe kuo Yesu. ");
INSERT INTO mdm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemʉ, ɨnde anʉ nanɨ nabhaka Yesu ’kpɨ́ bini sukpe-e, ago di. Anɨ ago ne mʉngotsi ɨnde u amene e lɨ mila bhʉ́ dabɨlɨ bini ne aloesɨ. Mʉngotsi ango-o, adʉ masɨkpe de kilo ndjɨkpa bata. ");
INSERT INTO mdm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Abhomʉ-o, ndʉ uo bhisi hana aha kuo Yesu. U agagala ne opapala bongo na lene me u nde atuko mʉngotsi tété, maka lɨ omaYuda adʉ amemene lɨe bhʉ́ nedhɨnga nazɨ kuo-o. ");
INSERT INTO mdm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lɨ bɨlɨ nanɨ u agɨ Yesu lɨ e lɨ kulusi-e, edyɨ bini adʉ oo. Bhʉ́ ’dyɨ ango-o, edú bini na mbɨa adʉ oo. Edú ango-o, u zɨ nga nanɨ kpála bini bhʉ́bhʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","U atsia ato Yesu bhʉ́bhʉ́. Padhá de, anga u adʉ agbene lɨo ka lɨ ekpɨ́ naguo gba omaYuda adʉ lɨe masɨkpe-o. La di-e, edú ango-o adʉ oo masɨkpe. ");
INSERT INTO mdm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Abhomʉ-o, bhʉ́ ’kpɨ́ yinga kɵkpɨ́ má bhɵ́-o, Malɨa , kpála na gʉdhʉ na Magadala, anʉ abhʉ́ lata. A adʉ me ekpɨ́ nde nga bha ne biti. Anɨ au me teme ɨnde adʉ lɨ ’bhɵ lata-a nde ayie lɨ bhɵbhɵ ayie. ");
INSERT INTO mdm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Abhomʉ-o, anɨ anʉ ne holo, anɨ anʉ abhaka Simo Piele, di ne mʉkpata koko ɨnde lɨ Yesu adʉ akʉnda e naali-o. Anɨ atsia apa pɨ uo me: «U agbe kuo Ngámá bhʉ́ lata-a agbe. La-a, ya mbɨla de me u aꞌo anɨ su-oie de.» ");
INSERT INTO mdm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Abhomʉ-o, Piele ne uo ne mʉkpata koko-o aholo ’nʉ́, u atsia agbida abhʉ́ lata. ");
INSERT INTO mdm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ndʉ uo bhisi hana agu holo. Engʉ́ bini, mʉkpata bhe koko agu naae holo kpekpeke ane Piele mane. Kaka-a, anɨ atsia akolo abhʉ́ lata kalanʉ. ");
INSERT INTO mdm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Anɨ akita ne kuto ngʉ́ natsia ’kpɨ́ bhʉ́bhʉ́. Anɨ au opapala bongo na lene me a nde aꞌo lɨe oo. La-a, anɨ lɨ de. ");
INSERT INTO mdm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Abhomʉ-o, Simo Piele ɨnde adʉ akpata anɨ sidi-e, akolo di. Anɨ atsia alɨ abhʉ́ lata. Anɨ au opapala bongo na lene me a nde aꞌo lɨe oo, ");
INSERT INTO mdm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","la di ne bongo bhende adʉ me a nde abuku bhʉ́la Yesu-o. Bongo ango-o dʉ bhʉ́ dabɨlɨ bini ne opapala bongo na lene de. Engʉ́ bini, a adʉ me a nde agagala naae lɨe kpi lɨ bɨlɨ koko. ");
INSERT INTO mdm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Abhomʉ-o, mʉkpata koko ɨnde akolo abhʉ́ lata kalanʉ-o, atsia alɨ di. Anɨ au, anɨ atsia abhuka. ");
INSERT INTO mdm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Padhá de, anga nakolo lɨ nedhɨnga bhomʉ-o, omʉkpata mbɨla nga nanɨ ndjɨndjɨ de, engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e me Masɨya azúku bhʉ́ ká okpála ɨnde amu-o mazuku. ");
INSERT INTO mdm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pɨta ’ngʉ́ bhomʉ-o, omʉkpata bhisi-e atsia agie lɨo agba o. ");
INSERT INTO mdm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malɨa adʉ me anɨ nde alʉ akilidjo de lata-o. Anɨ adʉ naku ’gbá. Nedhɨnga ɨnde anɨ adʉ nga bha lɨe naku ’gbá-a, anɨ akita ne kuto ngʉbula natsia ’kpɨ́ abhʉ́ lata. ");
INSERT INTO mdm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Anɨ au oandjelu bhisi. U adyɨdyɨ obubu bongo. U adʉlʉ lɨ bɨlɨ ɨnde u aꞌo nako kuo Yesu lɨ e ko. Bini adʉ lɨ pápá na ’ndjɨ anɨ, koko atsia adʉ lɨ pápá na ’dhʉ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Oandjelu-o ayi Malɨa me: «Ɵlɵ-e, mʉ ngaku ’gba ngʉ́ nɨ?» Anɨ agie pɨ uo me: «U aꞌe kuo Ngámá gba ma-a aꞌe. Ma mbɨla de me u aꞌo su-oie de.» ");
INSERT INTO mdm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pɨta anɨ apa ’ngʉ́ bhomʉ-o lɨe, anɨ adji lɨe, anɨ atsia au Yesu me anɨ nde alʉ oo. Engʉ́ bini, anɨ dʉ ambɨla de me a ko Yesu-o de. ");
INSERT INTO mdm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu ayi anɨ me: «Ɵlɵ-e, mʉ ngaku ’gbá ngʉ́ nɨ? Mʉ ngagɨlɨ da?» Malɨa abhundja me a ko kpála ɨnde ngamene kulu bhʉ́ ’dyɨ-o. Kaka-a, anɨ apa pɨ anɨ me: «’Dyɨ ma, ɨ dʉ me mʉ nde aꞌe kuo Ngámá gba ma-a ngamʉ-o, suno bɨlɨ mo oꞌo lɨ e mʉma, amba ma nʉ ha.» ");
INSERT INTO mdm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu apa pɨ anɨ me: «Malɨa!» Malɨa adji lɨe, anɨ atsia apa pɨ anɨ bhʉ́ eli na ebele me: «Labonɨ!» (A akʉnda napa me «Mʉsuno.») ");
INSERT INTO mdm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu apa pɨ anɨ me: «Mo obú ’kpa mʉ lɨ ma de. Padhá de, anga ma nʉ nga agba ’Dyɨ ma abhʉ́lá de. Engʉ́ bini, nʉ bhaka ondaise ma, amba mʉ pa pɨ uo me: ‹Ma adji abhʉ́lá agba ’Dyɨ ma. A ko la di ’Dyɨ yi. Ma adji abhʉ́lá agba Ebhe gba ma-o. A ko la di Ebhe gba yi-o.›» ");
INSERT INTO mdm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Abhomʉ-o, Malɨa, kpála na kʉtɨ na Magadala, atsia anʉ akpokpo pɨ omʉkpata me: «Ma au Ngámá au!» Anɨ atsia akpokpo ’ngʉ́ ɨnde lɨ Yesu apa e pɨ anɨ-e, pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Bha bhʉ́ ’kpɨ́ yinga bhomʉ-o tagolo-o, omʉkpata-a apo bhʉ́la o bhʉ́ ’tɨ bini. U atsia adhodho obhɵ bhotɨ nganda o madhodho. Padhá de, anga u adʉ akpe ongámásɨ gba omaYuda-o . Yesu ago alʉ tʉ uo. Anɨ atsia apa pɨ uo me: «Guo ’ngʉ́ dʉ bhʉ́ dabɨlɨ bini ne yi!» ");
INSERT INTO mdm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pɨta anɨ apa ’ngʉ́ bhomʉ-o lɨe, anɨ asuno ’kpa e, di ne pála kala e pɨ uo. Lɨ omʉkpata au Ngámá lɨe, u abedhe ne djalɨ bedhe. ");
INSERT INTO mdm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu atsia apa matá pɨ uo me: «Guo ’ngʉ́ dʉ bhʉ́ dabɨlɨ bini ne yi! Maka lɨ ’Dyɨ ma atima ma lɨe, ngama di-e, ma atima yi.» ");
INSERT INTO mdm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pɨta anɨ apa lɨe mo-o, anɨ aꞌulu wo e pɨ́ uo, anɨ atsia apa pɨ uo me: «Yi sia Bu Bhobua ! ");
INSERT INTO mdm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Okpála bhende yi ambú lɨ siti ’ngʉ́ gba o-o, lɨ Ebhe mbú di lɨ siti ’ngʉ́ gba uo-o. Okpála bhende yi mbú lɨ siti ’ngʉ́ gba o de-e, Ebhe mbú di tété de.» ");
INSERT INTO mdm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nedhɨnga lɨ Yesu akoto lɨ omʉkpata gba e lɨe abhʉ́ ’tɨ-e, sʉka omʉkpata ndjɨkpa ne ká bhisi-e Tʉma (ɨnde u aꞌɨ di-e me Bhuko-o) dʉ bhʉ́ dabɨlɨ bini ne uo de. ");
INSERT INTO mdm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Abhomʉ-o, omʉkpata koko atsia apa pɨ anɨ me: «Ya au Ngámá.» Engʉ́ bini, anɨ atsia agie pɨ uo me: «Ma akʉnda nau oeka na osete ɨnde lɨ okpa anɨ-o. Ma akʉnda naꞌo lɨkpa ma lɨ pokoli na osete ango-o. Ma akʉnda la di naꞌo ’kpa ma lɨ pála kala anɨ. Ɨ dʉ mo-o de-e, ma bhúka de.» ");
INSERT INTO mdm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pɨta ’kpɨ́ madjɨna, omʉkpata gba Yesu apo matá bhʉ́la o abhʉ́ ’tɨ. Tʉma adʉ bhʉ́ dabɨlɨ bini ne uo. Obhɵ bhotɨ-e adʉ me a nde adhodho lɨe madhodho. Engʉ́ bini, Yesu ago, anɨ alʉ tʉ uo. Anɨ atsia apa pɨ uo me: «Guo ’ngʉ́ dʉ bhʉ́ dabɨlɨ bini ne yi!» ");
INSERT INTO mdm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pɨpɨta-a, anɨ apa pɨ Tʉma me: «ꞌO lɨkpa mʉ sɨ, amba mʉ tsia ’kpa ma. Go ne ’kpa mʉ, amba mʉ ꞌo lɨ pála kala ma. Mo odʉ́ ne bua na bhisi bhisi de. Dʉ mangbo ne nabhuka .» ");
INSERT INTO mdm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tʉma agie pɨ anɨ me: «Ngámá gba ma, di ne Ebhe gba ma!» ");
INSERT INTO mdm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu apa pɨ anɨ me: «Mo obhuka ka mo ou ma lɨe? A ko djalɨ pɨ okpála ɨnde ngabhuka me u nde u ne djila o de ko.» ");
INSERT INTO mdm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu amene matá ongamba ’ngʉ́ koko bhelé lɨ djila omʉkpata gba e-o. La-a, u ye bhʉ́ bhuku ɨnde-e de. ");
INSERT INTO mdm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Engʉ́ bini, ongʉ́ ɨnde aye lɨe bhʉ́bhʉ́-o, a ko ngʉbula me yi bhuka me Yesu ne Masɨya, Ndɨlɨ gba Ebhe, amba ɨ dʉ la me yi nde abhuka anɨ-e, yi de sia mʉkobho ka ’lɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ekpɨ́ koko pɨpɨta-a, Yesu akoto matá lɨ omʉkpata gba e lɨngo ekpɵ na Tibeliade. Lele maka anɨ akoto lɨ uo lɨe, ngae ɨnde: ");
INSERT INTO mdm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","a adʉ nanɨ Simo Piele, ne Tʉma, (ɨnde u aꞌɨ e me Bhuko), ne Natanaele, (kpála na kʉtɨ na Kana, bhʉ́ ndu doto na Galilaya), ne ongɨsɨ gba Djebedayo, di ne omʉkpata koko bhisi gba Yesu-o. U adʉ bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simo Piele apa pɨ uo me: «Ma adji nagbe sungu.» U agie pɨ anɨ me: «Ngaya di-e, nɨ́ anʉ́ ne yi bhʉ́ dabɨlɨ bini.» Abhomʉ-o, u anʉ, u atsia aꞌʉꞌʉ bhʉ́ zabʉ. Engʉ́ bini, sukpe bhomʉ-o, u gbe sungu belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lɨ ekpɨ́ aholo naseke lɨe, Yesu alʉ lɨngo ’ngu oo. Engʉ́ bini, omʉkpata-a dʉ ambɨla de me a ko anɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Abhomʉ-o, Yesu atsia apa pɨ uo me: «Odi ma, yi aholo mbo sungu uu?» U agie pɨ anɨ me: «Ya holo de.» ");
INSERT INTO mdm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Anɨ apa pɨ uo me: «Yi bhike nado lɨngo zabʉ-o ne lɨ pápá na kokpa, amba yi holo sungu.» Abhomʉ-o, u atsia abhike nado-o bhʉ́ ’ngu. U ale nagbele nado ango-o bhʉ́ ’ngu pima. Padhá de, anga osungu adʉ bhʉ́bhʉ́ bhibhiti naali. ");
INSERT INTO mdm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Abhomʉ-o, mʉkpata ɨnde lɨ Yesu adʉ akʉnda e naali-e apa pɨ Piele me: «A ko Ngámá!» Lɨ Simo Piele adje lɨe me a ko Ngámá-a, anɨ adyɨ bongo . Padhá de, anga abhaka me anɨ nde agbe bongo-o magbe ngʉ́ nagbe sungu-o. Anɨ atsia agʉ ꞌi e bhʉ́ ’ngu. ");
INSERT INTO mdm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Omʉkpata koko agie lɨo ne zabʉ-o me u nde ngagbele nado-o. Nado ango-o adʉ me a nde abedhe ne osungu bedhe. U dʉ nanɨ dengo ’gɵ-o tsutsu de. U adʉ masɨkpe de metele kámá bini. ");
INSERT INTO mdm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nedhɨnga u aze lɨe apɨ́ ’gɵ-o, u au djua ne sungu pépé, di ne mapa. ");
INSERT INTO mdm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu apa pɨ uo me: «Yi go ne té osungu ɨnde yi aholo e-o.» ");
INSERT INTO mdm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Abhomʉ-o, Simo Piele aꞌʉ matá bhʉ́ zabʉ-o. Anɨ agbele nado apigo. Nado ango-o adʉ me a nde abedhe ne ongbengbe osungu kámá bini ndjɨkpa bhuluvue ne ká bata. Abana lɨ osungu adʉ lɨe bhʉ́bhʉ́ bhelé-e, nado ango-o tsotsolo de. ");
INSERT INTO mdm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu apa pɨ uo me: «Yi go zʉ ’he.» Kpála bini bhʉ́ ká omʉkpata-a le nayi anɨ de me: «Mʉ ne da?» Padhá de, anga u adʉ ambɨla hana me, a ko Ngámá. ");
INSERT INTO mdm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Abhomʉ-o, Yesu adyudyo lɨe masɨkpe. Anɨ aha mapa, anɨ atsia agapa lɨ uo. Anɨ atsia aha di sungu-o pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A adʉ nanɨ bhomʉ-o bhʉtsibhʉtsi na bata me Yesu koto lɨ omʉkpata gba e, pɨta anɨ azuku lɨe bhʉ́ ká okpála bhende amu ko. ");
INSERT INTO mdm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pɨta u azʉ ’he-e lɨe, Yesu ayi Simo Piele me: «Simo, ndɨlɨ gba Djaa , mʉ kʉnda ma nane maka lɨ okpála koko ɨnde-e akʉnda ma lɨe mane?» Piele agie pɨ anɨ me: «Heni, Ngámá, mʉ mbɨla hana me ma kʉnda mʉ.» Yesu apa pɨ anɨ me: «Kʉ ongɨsɨ kandɵlɵ gba ma-o.» ");
INSERT INTO mdm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu ayi matá anɨ bhʉtsibhʉtsi na bhisi-e me: «Simo, ndɨlɨ gba Djaa, mʉ kʉnda ma uu?» Piele agie pɨ anɨ me: «Heni, Ngámá, mʉ mbɨla hana me ma kʉnda mʉ.» Yesu apa pɨ anɨ me: «Lila okandɵlɵ gba ma-o.» ");
INSERT INTO mdm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu ayi matá anɨ bhʉtsibhʉtsi na bata-a me: «Simo, ndɨlɨ gba Djaa, mʉ kʉnda ma uu?» Piele asia lɨkabhu lɨ bua e. Padhá de, anga Yesu ayi anɨ bhʉtsibhʉtsi na bata me: «Mʉ kʉnda ma uu?» Anɨ atsia apa pɨ Yesu me: «Ngámá, mʉ mbɨla ndʉ ’ngʉ́ hana. Mʉ mbɨla bhadi hana me ma kʉnda mʉ!» Yesu apa pɨ anɨ me: «Kʉ okandɵlɵ gba ma-o. ");
INSERT INTO mdm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A moko, ma apa pɨ mʉ na paká me, nedhɨnga nanɨ mo odʉ lɨe makombi-e, mo odʉ agbite ekpʉ́ gba mʉ-o ludu mʉ ngamʉ makpe. Mo odʉ la di anʉ lɨ bɨlɨ ɨnde mo odʉ akʉnda nanʉ lɨ e-o. Engʉ́ bini, nedhɨnga mo okólo lɨe ’gbé kpála-a, mo oꞌéꞌe ’kpa mʉ abhʉ́lá, lɨ kpála koko tsia gbíte ’kpʉ́ gba mʉ-o ludu mʉ ngae. Anɨ tsia nʉ́ di ne mʉ lɨ bɨlɨ ɨnde mʉ kʉnda nanʉ lɨ e de.» ");
INSERT INTO mdm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu adʉ apa mo-o ngʉbula nasuno lele maka lɨ Piele akpí lɨe, anɨ tsia há la di sangu pɨ Ebhe ko. Pɨpɨta-a, Yesu apa pɨ anɨ me: «Kpata ma!» ");
INSERT INTO mdm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Lɨ Piele adji lɨe lɨe, anɨ au mʉkpata lɨ Yesu adʉ akʉnda e-o, (kpála ɨnde aseke nanɨ ’ndjɨ e pɨ́ mbulu Yesu, nedhɨnga ɨnde u adʉ azʉ ’he lɨe-o, ɨnde atsia ayi di nanɨ Yesu me: «Ngámá, kpála bhende apʉ́ mʉ-o, a ko da?») ");
INSERT INTO mdm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Abhomʉ-o, Piele au mʉkpata ango-o, anɨ atsia ayi Yesu me: «Ngámá, a la anɨ-e, a akólo lɨ anɨ ne mangua ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu agie pɨ anɨ me: «Ɨ dʉ me ma nde akʉnda me anɨ dʉ, akolo lɨ nedhɨnga ɨnde ma agó matá lɨe, a ko naamʉ ’ngʉ́? Ngamʉ-o, kpata ma!» ");
INSERT INTO mdm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Abhomʉ-o, ngali atsia ayangba bhʉ́ ká omabhuka me, mʉkpata ango-o kpí naae de. La-a, Yesu pa nanɨ pɨ Piele de me: «Anɨ kpí de-e de.» Engʉ́ bini, anɨ apa nanɨ mangbo me: «Ɨ dʉ me ma nde akʉnda me anɨ dʉ akólo lɨ nedhɨnga ɨnde ma agó matá lɨe, a ko naamʉ ’ngʉ́?» ");
INSERT INTO mdm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mʉkpata ango-o ngakpokpo ongʉ́ ɨnde-e ngae makpe. Anɨ aye la di bhʉ́ bhuku ngae. Ya mbɨla la di ndjɨndjɨ me engʉ́ ɨnde anɨ ngakpokpo e, a ko kʉkʉlʉ ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu amene di nanɨ ongʉ́ koko bhelé. Ɨ dʉ́ me u yé ongʉ́ ango-o bini ne bini hana-a, ma abhundja me doto libhomu de tɨ́ ne obhuku ɨnde ɨ de yé lɨe de.");
INSERT INTO mdm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ndai ma na mʉkʉnda Tɨofile, Bhʉ́ bhuku gba ma na kalanʉ-o, ma akpokpo ndʉ ’ngʉ́ hana ɨnde lɨ Yesu amene e di ne bhende anɨ asuno e ko. Ma akpokpo nayie lɨ lilita ");
INSERT INTO mdm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","akolo lɨ ’kpɨ́ lɨ Ebhe aha anɨ lɨe abhʉ́lá ko. Kala nanʉ ka anɨ abhʉ́lá-a, bhʉ́ angu gba Bu Bhobua-a , anɨ aha olɨ́lɨ gba e pɨ okpála ɨnde anɨ alo nanɨ o maka obhʉlʉ titima-o . ");
INSERT INTO mdm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pɨta nakpi ka anɨ-e, anɨ apana lɨe pɨ obhʉlʉ titima gba e-o. Anɨ asuno pɨ uo lɨ okpadjɨ bhelé me nɨ bhʉ́ mʉkobho. Anɨ asuno lɨe pɨ uo ngʉbula ’kpɨ́ ndjɨkpa badha. Anɨ atsia akpokpo di ’ngʉ́ pɨ uo pɨndjɨ Naʉ gba Ebhe . ");
INSERT INTO mdm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ekpɨ́ bini, lɨ anɨ adʉ azʉ ’he lɨe bhʉ́ dabɨlɨ bini ne uo-o, anɨ atsia aha lɨ́lɨ ɨnde-e pɨ uo me: «Yi ayíe bhʉ́ Yelusalema de, engʉ́ bini, yi djeke ehe ɨnde lɨ ’Dyɨ ma apa me nɨ ahá e pɨ yi ko. A ko ehe ɨnde ma apa ’ngʉ́ pɨ yi pɨndjɨ e ko. ");
INSERT INTO mdm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Padhá de, anga Djaa abatisa nanɨ okpála ne engu. Engʉ́ bini ngayi-e, pɨta ’kpɨ́ masudha-a, yi asía batisimo na Bu Bhobua.» ");
INSERT INTO mdm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lɨ obhʉlʉ titima adʉ apo bhʉ́la o lɨe de Yesu-o, ekpɨ́ koko-o, u atsia ayi anɨ me: «Ngámá, mo ogbégbe omaƗsalaele bhʉ́ bali, mʉ tsia há ngámá pɨ uo mbɨa ɨnde-e?» ");
INSERT INTO mdm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu atsia agie pɨ uo me: «A ko engʉ́ ka yi de ngʉ́ nambɨla nedhɨnga di ne oekpɨ́ ango-o. Padhá de, anga Ebhe ne angu gba e makpe, aꞌo oekpɨ́ ango-o maka anɨ akʉnda lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Engʉ́ bini, yi asía angu, lɨ nedhɨnga lɨ Bu Bhobua akɵ́ pɨ́ yi lɨe-o. Yi tsia kpókpo ’ngʉ́ gba ma ɨnde yi au e ne bhe yi adje di e bhʉ́ gʉdhʉ na Yelusalema, bhʉ́ ndu doto na Yudaya libhomu, ne bhende na Samalɨa, akólo makolo alɨ dje doto.» ");
INSERT INTO mdm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lɨ Yesu andjia nakpokpo ’ngʉ́ bhomʉ-o lɨe, Ebhe atsia aha anɨ abhʉ́lá me ndʉ uo hana nde ngatsia anɨ. Abhomʉ-o, ndindi atsia abuku anɨ. U u matá anɨ de. ");
INSERT INTO mdm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nedhɨnga u adʉ nga bha lɨe atsia ’kpɨ́ abhʉ́lá-a, lɨ pápá lɨ Yesu atapa lɨe, kolo me-e, okpála bhisi aze lɨ uo. U adyɨdyɨ bubu bongo . ");
INSERT INTO mdm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","U atsia apa pɨ uo me: «Ngayi okpála na Galilaya, yi alʉlʉ sɨ ne natsia ’kpɨ́ abhʉ́lá ka nɨ? Yesu ɨnde lɨ Ebhe aha e abhʉ́lá bhomʉ-o, anɨ agíe bhadi lɨe maka yi au anɨ lɨe anʉ abhʉ́lá ko.» ");
INSERT INTO mdm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Abhomʉ-o, obhʉlʉ titima-a ayie pɨ́ eta u aꞌɨ e me eta na ondula na Olive, u atsia agie lɨo bhʉ́ gʉdhʉ na Yelusalema. Eta ango-o adʉ de Yelusalema masɨkpe de kilometele bini. ");
INSERT INTO mdm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","U akolo lɨe bhʉ́ Yelusalema-a, u aꞌʉ bhʉ́ tɨna ’tɨ bhe abhʉ́lá, bɨlɨ ɨnde u adʉ adʉlʉ lɨe-o. A adʉ nanɨ: Piele ne Djaa , ne Djakɨ di ne Andɨlɨ, ne Filipo di ne Tʉma, ne Batelemi di ne Matié, ne Djakɨ ndɨlɨ gba Alafayo, ne Simo kpála nakʉnda doto gba o, la di ne Djude ndɨlɨ gba Djakɨ. ");
INSERT INTO mdm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ndʉ uo hana, adʉ apo bhʉ́la o ne bua bini, ndʉ nedhɨnga hana ngʉ́ nayo Ebhe. U adʉ bhʉ́ dabɨlɨ bini ne olɨsɨ koko, ne Malɨa ’hi Yesu, di ne ondaise Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bhʉ́ oekpɨ́ bhomʉ-o, ekpɨ́ bini, omabhuka apo bhʉ́la o. U adʉ masɨkpe de kámá ne ndjɨkpa bhisi. Abhomʉ-o, Piele ayie bhʉ́lá bhʉ́ ká uo. Anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ondaise ma, engʉ́ ɨnde u aye e bhʉ́ Bhuku gba Ebhe-e , a ayo me amene lɨe. Bu Bhobua apa ’ngʉ́ ango-o bhʉ́ ’li Davidi pɨndjɨ Yuda, kpála ɨnde ago nanɨ ne okpála ɨnde aholo Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda nako ne sʉka nɨ́. Ngámá abhʉ anɨ ngʉ́ namene kulu maka nɨ́ adʉ di ne di lɨe-o.» ");
INSERT INTO mdm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Anɨ akala edyɨ ne tɨa ɨnde u aha e pɨ anɨ lɨ anɨ abhɵlɵ kpála lɨe-o. Bhʉ́ edyɨ ango-o, anɨ atɨ adji ’ndjɨ e ne kuto. ’Bu anɨ aʉpa. ’Ndja anɨ atsia aze kuto. ");
INSERT INTO mdm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ndʉ okpála hana na Yelusalema ambɨla ’ngʉ́ ango-o ndjɨndjɨ. Kaka-a, u aꞌo nanɨ ꞌɨlɨ lɨ edyɨ ango-o bhʉ́ eli na gba o me «Akeledama», a akʉnda napa me «edyɨ na Ngʉte».) ");
INSERT INTO mdm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pɨpɨta-a, Piele apa matá me: «Padhá de, anga u aye bhʉ́ bhuku na oEtsi gba omaYuda-a me: ‹A ayo me kʉtɨ gba anɨ-e kolo mili bɨlɨ, kpála bini adʉ́ bhʉ́bhʉ́ de.› U atsia aye matá me: ‹A ayo me kpála koko ha kulu gba anɨ-o.› ");
INSERT INTO mdm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kaka-a, a ayo me kpála bini lɨ bhʉ́ ká nɨ́, amba anɨ dʉ akpokpo ngali nazuku gba Ngámá Yesu-o. A ayo me kpála ango-o dʉ sʉka okpála ɨnde adhʉkʉ bhʉ́ dabɨlɨ bini ne nɨ́ ndʉ nedhɨnga hana lɨ Ngámá Yesu adhʉkʉ lɨe ne nɨ́ pɨ́la doto ko. Kpála ango-o dʉ kpála ɨnde adhʉkʉ bhʉ́ dabɨlɨ bini ne nɨ́ nayie lɨ nedhɨnga lɨ Djaa abatisa Yesu lɨe, akolo lɨ ekpɨ́ lɨ Ebhe aha anɨ lɨe ngʉ́ nanʉ abhʉ́lá-o.» ");
INSERT INTO mdm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Abhomʉ-o, u atsia agbe okpála bhisi. A adʉ ’lɨ bhe bini-e me Djodjefʉ , ɨnde u aꞌɨ e me Balasabasɨ. ꞌƗlɨ koko gba anɨ-e matá me Djusitusi. A adʉ ’lɨ bhe koko me Matɨasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","U atsia ayo Ebhe me: «Ngámá, mʉ mbɨla bua ndʉ okpála hana. Pana kpála ɨnde mo obhʉ e bhʉ́ ká okpála bhisi ɨnde-e pɨ ya. ");
INSERT INTO mdm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Anɨ adʉ́ bhʉlʉ titima gba Yesu. Anɨ ahá kulu ɨnde lɨ Yuda aꞌo ká e ngʉ́ nanʉ lɨ bɨlɨ gba e makpe ko.» ");
INSERT INTO mdm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pɨta u ayo Ebhe lɨe, u agʉ gbanda. Gbanda asuno Matɨasɨ. Abhomʉ-o, u atsia ato anɨ bhʉ́ ká obhʉlʉ titima ndjɨkpa ne ká bini-o. ");
INSERT INTO mdm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lɨ ekpɨ́ na Patekote akolo lɨe, ndʉ omabhuka hana apo bhʉ́la o lɨ bɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Má gala kolo me-e, tolo ayie abhʉ́lá maka anvi na kpekpeke. Tolo ango-o aha bɨlɨ bhʉ́ ’tɨ ɨnde u adʉ bhʉ́ e hana. ");
INSERT INTO mdm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Abhomʉ-o, u au oehe maka dɨngɨdhɨ djua. Oehe ango-o agbogbo bhʉsʉ e, atsia adʉlʉ pɨ́ ’ndjɨ ndʉ uo hana bini ne bini. ");
INSERT INTO mdm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ndʉ uo hana abedhe ne Bu Bhobua . U atsia aholo agama ’ngʉ́ bhʉ́ oeli koko, maka lɨ Bu Bhobua adʉ ahaha pɨ uo lɨe ngʉ́ nagagama ko. ");
INSERT INTO mdm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bhʉ́ gʉdhʉ na Yelusalema-a, omaYuda ɨnde ayie bhʉ́ ndʉ okʉtɨ hana pɨ́la doto libhomu adʉ oo. A adʉ okpála ɨnde adʉ akpe Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Lɨ u adje tolo ango-o lɨe, bhiti okpála ango-o ago apo bhʉ́la o. U atsia adʉ angamba naali. Padhá de, anga kpála ne kpála adʉ adje omabhuka agama ’ngʉ́ bhʉ́ eli gba e makpe. ");
INSERT INTO mdm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","U abedhe ne nangamba, di ne nakɨaka. U atsia adʉ apa me: «Okpála ɨ ngagama ’ngʉ́ ɨnde-e, ndʉ uo hana ne okpála na ndu doto na Galilaya adɨ? ");
INSERT INTO mdm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Lele pɨ ndʉ nɨ́ hana bini ne bini, nɨ́ ngadje uo lɨe ngagama ’ngʉ́ bhʉ́ eli gba nɨ́ makpe na kʉtɨ-e? ");
INSERT INTO mdm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Bhʉ́ ká nɨ́ sɨ-e, okpála koko ayie bhʉ́ doto na Palate. Okoko ayie bhʉ́ Media. Okoko ayie bhʉ́ Elama. Okoko ayie bhʉ́ Edjipeto. Okoko ne okpála na Medjopotami. Okoko ayie bhʉ́ ndu doto na Yudaya. Okoko ayie bhʉ́ Kapadose. Okoko ayie bhʉ́ Pote di ne Adjia. Okoko ayie bhʉ́ Filidjia. Okoko ayie bhʉ́ Pamifilia. Okoko ayie lɨngo gʉdhʉ na Silene ɨnde bhʉ́ doto na Libi ko. Okoko ayie bhʉ́ gʉdhʉ na Loma . ");
INSERT INTO mdm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Okoko ayie bhʉ́ kpɵmɵ na Kelete. Okoko ayie bhʉ́ doto na Alabi. U azu okoko omaYuda. Okoko-o, a ko ogandji okpála ɨnde abhuka Ebhe gba omaYuda-o. La-a, lele pɨ nɨ́ ngadje uo ngakpokpo ’ngʉ́ pɨndjɨ ongamba ’ngʉ́ gba Ebhe bhʉ́ eli gba nɨ́ na kʉtɨ lɨe bini ne bini-e!» ");
INSERT INTO mdm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ndʉ uo hana adʉ ne nangamba naali. Mabhundja gba uo-o angbɨngɨ. Abhomʉ-o, u atsia apa sʉnda o me: «Engʉ́ ɨnde-e akʉnda napa pɨ?» ");
INSERT INTO mdm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Engʉ́ bini, okoko adʉ amʉ omabhuka. U atsia adʉ apa me: «Pandɨ aholo uo e-e ngae bha-a!» ");
INSERT INTO mdm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piele ayie bhʉ́lá bhʉ́ dabɨlɨ bini ne obhʉlʉ titima ndjɨkpa ne ká bini koko-o. Anɨ aholo agama ’ngʉ́ kpekpeke pɨ bhiti okpála me: «Ngayi omaYuda, di ne ndʉ yi okpála hana ɨnde ngadʉlʉ bhʉ́ gʉdhʉ na Yelusalema-a, yi dje ma ndjɨndjɨ, amba yi mbɨla la di engʉ́ ɨ ngakodho ’kpɨ́ ɨnde. ");
INSERT INTO mdm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Okpála ɨnde-e, a holo uo ne pandɨ maka yi ngabhubhundja lɨe de. Padhá de, anga a ko nga bha saa na odukpabini na kɵkpɨ́. ");
INSERT INTO mdm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Engʉ́ bini, engʉ́ ɨ ngakodho ’kpɨ́ mbɨa ɨnde-e, a ko engʉ́ ɨnde lɨ polofeta Djʉele apa nanɨ e-o. Engʉ́ ɨnde me: ");
INSERT INTO mdm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Ebhe apa me: lɨ sokpɨ́-e, ma atúko Bua gba ma-a pɨ́ ndʉ okpála hana. Ongɨsɨ gba yi na obhosɨbhosɨ, di ne obhe na olɨsɨlɨsɨ akpókpo ongʉ́ ɨnde ma akʉnda e-o. Omakombise gba yi-e aú ongʉ́ ɨnde ma akʉnda nasuno e bhʉ́ loto. Ogbegbe okpála gba yi-e atsia alóto oloto ɨnde ma atíma e pɨ uo ko. ");
INSERT INTO mdm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lɨ oekpɨ́ ango-o, ma atúko belegʉ di Bua gba ma-a pɨ́ okpála na kulu gba ma na obhosɨbhosɨ, di ne obhe na olɨsɨlɨsɨ. U tsia kpókpo ongʉ́ ɨnde ma akʉnda e-o. ");
INSERT INTO mdm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma améne ongamba ’ngʉ́ abhʉ́lá. Ma tsia méne ongamba ’ngʉ́ kuto pɨ́la doto. Ngʉte atúko, lɨ djua tsí, a adʉ́ di ne ndindi nguwa. ");
INSERT INTO mdm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kala me ekpɨ́ gba Ngámá-a kolo-o, ekpɨ́ na ngbéngbé, di ne ekpɨ́ na asasaua-a, ela adjí lɨe biti. Lɨ epe djí lɨe maka ngʉte. ");
INSERT INTO mdm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abhomʉ-o, kpála ne kpála ɨnde abhʉ ’lɨ Ngámá-a, tsia sía mʉkobho.›» ");
INSERT INTO mdm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Abhomʉ-o, Piele atsia apa me: «Ngayi okpála na Ɨsalaele, yi dje nga engʉ́ ma adji apa e pɨ yi ɨnde: Ebhe apana pɨ yi mbámbá me nɨ atima Yesu, kpála na kʉtɨ na Nadjaleta-a, pɨ yi. Anɨ apana lɨ namene ongamba ’ngʉ́ sʉnda yi bhʉ́ anɨ. Anɨ amene okɨaka ’ngʉ́ , di ne oehe na tsʉlʉtsʉlʉ bhʉ́ anɨ. Ngayi makpe-e, yi mbɨla ’ngʉ́ tété ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kpála bhomʉ-o, u apʉ anɨ pɨ yi. Ebhe ambɨla nanɨ ’ngʉ́ tété kalanʉ. Anɨ atsia akʉnda me amene lɨe moko. Yi abhɵlɵ anɨ. Padhá de, anga yi aha anɨ pɨ okpála na sisiti. U agɨ anɨ lɨ kulusi, u atsia abhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Engʉ́ bini, Ebhe azuku anɨ, anɨ atsia aꞌe anɨ bhʉ́ lɨkabhu na kuo. Padhá de, anga a ayo nanɨ de me kuo to anɨ bhʉ́ tɨkpʉ gba e-e de. ");
INSERT INTO mdm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kaka-a, Davidi apa lɨ ’ngʉ́ gba anɨ-e me: ‹Ma adʉ au Ngámá Ebhe kala ma ndʉ nedhɨnga hana. Padhá de, anga anɨ lɨ pá ’kpa ma na kokpa, amba ma agʉ́kʉ de. ");
INSERT INTO mdm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kaka-a, bua ma abedhe ne djalɨ bedhe. Ma la di ngali ’tsi ne djalɨ hana. Ekpɨ́ ma akpí lɨe, ma adʉ́ ne ’to ma me ma akóbho makobho. ");
INSERT INTO mdm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Padhá de, anga mʉ ꞌó ká ma de me ma dʉ lɨ bɨlɨ gba okpála ɨnde amu-o de. Mʉ kʉ́nda de me kpála gba mʉ na ngbingbili-e zi bhʉ́ lata-a de. ");
INSERT INTO mdm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mo osuno mʉma okpadjɨ na mʉkobho. Mo obédhe ma ne djalɨ, anga nɨ́ ne mʉ bhʉ́ dabɨlɨ bini.›» ");
INSERT INTO mdm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piele apa matá me: «Ondaise ma, ma tɨ da napa engʉ́ pɨ yi mbámbá pɨndjɨ ogbi nɨ́ Davidi. Anɨ akpi, u atsia azɨ anɨ. Lata anɨ bhʉ́ ká nɨ́ akolo pɨ nakɨ. ");
INSERT INTO mdm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Engʉ́ bini, a ko nanɨ polofeta. Anɨ ambɨla me Ebhe apa nanɨ ne natʉ silika me: ‹Ma aꞌó sʉka ongɨsɨ gba mʉ-o bini ngámá bhʉ́ da mʉ.› ");
INSERT INTO mdm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidi au nanɨ engʉ́ ɨnde agó-o kalanʉ. Kaka-a, anɨ atsia apa engʉ́ nazuku gba Masɨya me: ‹Ebhe ꞌo ká anɨ lɨ bɨlɨ gba okpála ɨnde amu-o de. Anɨ ꞌo la di de me anɨ zi bhʉ́ lata-a de.› ");
INSERT INTO mdm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu ɨnde ma ngapa ’ngʉ́ gba e-e, Ebhe azuku anɨ. Ndʉ ya hana, ya au engʉ́ ango-o ne djila ya. ");
INSERT INTO mdm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pɨpɨta-a, Ebhe aꞌe anɨ abhʉ́lá, anɨ atsia aꞌo anɨ lɨ pá ’kpa e na kokpa. ’Dyɨ nɨ́ Ebhe aha Bu Bhobua pɨ anɨ maka anɨ apa nanɨ lɨe kalanʉ ko. Anɨ atsia atuko Bu Bhobua ango-o pɨ́ ya. A ko bhende yi ngau e, di ne bhende yi ngadje e mbɨa ɨnde-e ko. ");
INSERT INTO mdm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Padhá de, anga Davidi ngae makpe ꞌʉ nanɨ abhʉ́lá de. Engʉ́ bini, anɨ apa ngae me: ‹Ngámá Ebhe apa nanɨ pɨ Ngámá gba ma-a me: Dʉ lɨ pá ’kpa ma na kokpa, ");
INSERT INTO mdm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","akólo lɨ ’kpɨ́ ma aꞌó obhʉlʉ yala gba mʉ-o lɨe sa ’dhʉ mʉ ko.› ");
INSERT INTO mdm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","A ayo me ndʉ okpála hana na Ɨsalaele mbɨla engʉ́ ɨnde-e ndjɨndjɨ me: Yesu ɨnde-e, ɨnde yi abhɵlɵ e lɨ kulusi-e, Ebhe aꞌo anɨ Ngámá, anɨ atsia aꞌo di anɨ Masɨya!» ");
INSERT INTO mdm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lɨ u adje engʉ́ bhomʉ-o lɨe, bua uo asia lɨkabhu naali. U atsia ayi Piele di ne obhʉlʉ titima koko-o me: «Ondaise ya, a ayo me ya mene pɨ?» ");
INSERT INTO mdm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Abhomʉ-o, Piele atsia agie pɨ uo me: «Kpála ne kpála dji bua e, anɨ sia batisimo ne ’lɨ Yesu Kilisito , amba Ebhe ꞌe siti ’ngʉ́ gba anɨ-o. Abhomʉ-o, yi tsia sía la di Bu Bhobua padhá. ");
INSERT INTO mdm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Padhá de, anga anɨ apa nanɨ kalanʉ me nɨ améne pɨ yi ne ongɨsɨ gba yi-e moko. Anɨ atsia apa me nɨ améne di pɨ okpála bhende ngadʉlʉ tsutsutsu, di ne pɨ ndʉ okpála hana bhende lɨ Ngámá gba nɨ-e aꞌɨ́ o-o.» ");
INSERT INTO mdm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Abhomʉ-o, Piele atsia akpo ’ngʉ́ koko pɨ uo bhelé ngʉ́ naha pɨ uo gʉmʉ me u bhuka, di me u dʉ ne nalila lɨo malila. Anɨ adʉ apa pɨ uo me: «Okpála na nakɨ ɨnde-e sisiti. Yi yie bhʉ́ ká uo mayie, amba Ebhe kobho yi.» ");
INSERT INTO mdm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Okpála bhelé ɨnde adje ’li Piele-e, azɨba. U atsia asia batisimo. Lɨ ekpɨ́ ango-o, okpála masɨkpe de kutu bata alɨ bhʉ́ ká omabhuka. ");
INSERT INTO mdm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","U adʉ aha lɨo ndʉ ’kpɨ́ hana ngʉ́ nadje nasuno gba obhʉlʉ titima gba Yesu-o. U adʉ nadʉ sʉnda o bhʉ́ mʉkʉnda maka ondaise. U adʉ azʉ ’he bhʉ́ dabɨlɨ bini, u atsia adʉ di ayo Ebhe bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ndʉ okpála hana adʉ ne tsʉlʉ. Padhá de, anga obhʉlʉ titima-a adʉ amene ongʉ́ na ngangamba, di ne okɨaka ’ngʉ́ naali. ");
INSERT INTO mdm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ndʉ omabhuka hana adʉ adʉlʉ bhʉ́ dabɨlɨ bini. Ndʉ ’he gba uo-o hana adʉ bhadi bhʉ́ dabɨlɨ bini. U atsia adʉ agbogbo bhʉsʉ bhʉsʉ lɨ o. ");
INSERT INTO mdm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","U adʉ atsɨndjɨ oedyɨ gba o, di ne oehe koko gba o-o. U atsia adʉ agbogbo bhʉsʉ tɨa ango-o lɨ ndʉ okpála hana, maka lɨ gʉmʉ gba kpála bini ne bini adʉ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ekpɨ́ bini ne bini hana, u adʉ apo bhʉ́la o bhʉ́ dabɨlɨ bini, u adʉ alɨ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. U adʉ agʉmʉ mapa bhʉ́ etɨ gba o, u atsia adʉ azʉ ’he ne djalɨ, di ne bua na bhʉbhʉkʉ. ");
INSERT INTO mdm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","U adʉ atoko Ebhe. Engʉ́ ɨnde u adʉ amene e-e bhʉ́ bádha bhʉ́ ’bu gba Ebhe-e , a adʉ anga lɨ okpála naali. Abhomʉ-o, ndʉ ’kpɨ́ hana, Ngámá atsia adʉ ato okpála koko bhende asia mʉkobho-o bhʉ́ ká uo. ");
INSERT INTO mdm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ekpɨ́ bini, pɨta tulukpe, Piele ne Djaa adʉ anʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda, ngʉ́ nayo Ebhe ɨnde u adʉ ayo e bhʉ́ saa na bata-o. ");
INSERT INTO mdm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","De ’bhɵ ’ngbé ’tɨ Ebhe gba omaYuda ango-o ɨnde u aꞌɨ e me «Babadha-a», kpála bini ɨnde ɨ dhʉkʉ de nayie maka u azu anɨ lɨe adʉ oo. Ndʉ ’kpɨ́ hana, u adʉ ago aꞌo anɨ oo ngʉbula me anɨ dʉ ayo tɨa ka okpála ɨnde ngalɨ bhʉ́ ’tɨ Ebhe ko. ");
INSERT INTO mdm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lɨ anɨ au Piele ne Djaa lɨe me u nde adji alɨ bhʉ́ ’ngbé ’tɨ Ebhe-e, anɨ atsia ayo tɨa ka uo. ");
INSERT INTO mdm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piele ne Djaa abanga djila o lɨ anɨ. Abhomʉ-o, Piele atsia apa pɨ anɨ me: «Tsia ya!» ");
INSERT INTO mdm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kpála ango-o atsia aꞌo mabhundja gba e-e hana pɨ́ uo. Padhá de, anga anɨ adʉ abhundja me nɨ asía ’he ka uo masia. ");
INSERT INTO mdm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Abhomʉ-o, Piele atsia apa pɨ anɨ me: «Falanga ka ma ade. Olo la di ka ma ade. Engʉ́ bini, ma ahá pɨ mʉ ehe ɨnde ka ma-o: ne ’lɨ Yesu Kilisito na Nadjaleta-a, yie bhʉ́lá, amba mʉ dhʉkʉ!» ");
INSERT INTO mdm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pɨpɨta-a, Piele aholo ’kpa anɨ na kokpa, anɨ atsia aꞌe anɨ bhʉ́lá. Má gala kolo me-e, obɨkɨ na ’dhʉ anɨ akolo kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Anɨ aꞌulu, akɵ má kprii! Anɨ atsia aholo nadhʉkʉ. Pɨpɨta-a, anɨ alɨ bhʉ́ ’ngbé ’tɨ Ebhe bhʉ́ dabɨlɨ bini ne Piele ne Djaa. Anɨ adʉ adhʉkʉ. Anɨ adʉ aꞌuꞌulu. Anɨ atsia adʉ adhɵgɵ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndʉ okpála hana au anɨ me anɨ nde ngadhʉkʉ, anɨ nde ngadhɵgɵ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","U atsia ambɨla me, a ko kpála ɨnde adʉ nadʉ lɨ ’bhɵ ’ngbé ’tɨ Ebhe, lɨ bhɵbhɵ bhende u aꞌɨ e me «Babadha», ngʉbula nayo ’he. Abhomʉ-o, ndʉ uo hana angamba, u atsia akɨaka naali ka engʉ́ ɨnde akolo lɨ kʉte dʉkuto-o. ");
INSERT INTO mdm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Abhomʉ-o, kpála ango-o dʉ ayie de Piele ne Djaa de. Ndʉ okpála hana angamba naali ka engʉ́ ɨnde akodho ’kpɨ́-o. U ago ne holo, u atsia apo bhʉ́la o de uo sa basa ɨnde u aꞌɨ e me «Sa ngba ’tɨ gba Salomo.» ");
INSERT INTO mdm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lɨ Piele au lɨe mo-o, do anɨ pɨ bhiti okpála bhomʉ-o me: «Ngayi okpála na Ɨsalaele, yi ngangamba lɨ nakobho ka kpála ɨnde-e ka nɨ? Lɨ yi abanga djila yi lɨe lɨ ya mʉgɨto me ya amene ngaya ne angu gba ya makpe me kpála ɨnde-e dhʉkʉ-o? La di mʉgɨto me a ko anga ya ngakpata engʉ́ gba Ebhe-e? A mo-o ade. ");
INSERT INTO mdm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebhe gba Abalahama, Ebhe gba Ɨsaka, Ebhe gba Yakobho, Ebhe gba onguo ogbi nɨ́ amene me ’lɨ bali gba nɨ Yesu-o adhɵgɵ lɨe. La-a, ngayi makpe-e, yi apʉ anɨ pɨ ongámásɨ. Yi atsia ayala anɨ kala Pɨlatɵ me anɨ nde adʉ akʉnda la me nɨ tse ’kpa lɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ngayi-e, yi ayala Kpála bhende bubu, ɨnde di ngbingbili. Yi atsia ayo me Pɨlatɵ suno bádha bhʉ́ ’bu pɨ kpála bhende ngabhili okpála-o. ");
INSERT INTO mdm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yi abhɵlɵ kpála ɨnde ngaha mʉkobho. Engʉ́ bini, Ebhe azuku anɨ bhʉ́ ká okpála bhende amu-o. Ya au engʉ́ ango-o ne djila ya makpe. ");
INSERT INTO mdm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mbɨa ɨnde-e, yi ngau kpála ɨnde, yi mbɨla la di hana me a ko nako dʉkuto. Anɨ akobho ka ’lɨ Yesu. Padhá de, anga ya abhuka anɨ. A ko ka nabhuka bhʉ́ Yesu, anɨ atsia akobho hana maka yi ngau anɨ lɨe ɨnde. ");
INSERT INTO mdm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Engʉ́ bini, ondaise ma, ma ambɨla ndjɨndjɨ me ngayi ne ongámásɨ gba yi-e, yi amene lɨ Yesu mo-o, anga yi mbɨla nanɨ kʉkʉlʉ ’ngʉ́-o de. ");
INSERT INTO mdm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","La-a, Ebhe ngae makpe amene mo-o ngʉbula nasuno mbámbá engʉ́ ɨnde anɨ apa nanɨ e kalanʉ bhʉ́ ’li ndʉ opolofeta hana ko. Anɨ apa nanɨ me Masɨya gba nɨ-e azʉ́ lɨkabhu. ");
INSERT INTO mdm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kaka-a, yi dji bua yi. Yi gie lɨyi lɨ pápá gba Ebhe, amba anɨ ꞌe siti ’ngʉ́ gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Abhomʉ-o, Ebhe ahá onedhɨnga naguo pɨ yi. Anɨ tsia tíma matá Masɨya ɨnde anɨ abhʉ nanɨ e kalanʉ-o pɨ yi. A akʉnda napa me Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Engʉ́ bini, mbɨa ɨnde-e, a ayo me Yesu Kilisito dʉ ngaɨza abhʉ́lá. Anɨ dʉ oo akólo lɨ nedhɨnga ɨnde lɨ ndʉ ’ngʉ́ hana akólo lɨe na mbɨa-o. Nayie didili naali-e, Ebhe apa nanɨ engʉ́ ango-o bhʉ́ ’li obubu opolofeta-o. ");
INSERT INTO mdm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Maka lɨ Moidje apa la di nanɨ lɨe me: ‹Ebhe Ngámá gba yi-e atíma polofeta pɨ yi maka ma. A adʉ́ sʉka ondaise yi. A ayo me yi dje ndʉ ’ngʉ́ hana ɨnde anɨ apá e pɨ yi ko. ");
INSERT INTO mdm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","La-a, kpála bhende ɨ djé ’li anɨ de-e, u agbé anɨ bhʉ́ ká okpála gba Ebhe, u tsia bhɵ́lɵ anɨ.› ");
INSERT INTO mdm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","La di-e, ndʉ opolofeta hana ɨnde akpokpo ’ngʉ́ gba Ebhe-e, nayie lɨ Samʉele, akpo engʉ́ ndʉ o hana bini ne bini pɨndjɨ engʉ́ ɨnde-e akolo lɨ ’kpɨ́ ango-o ko. ");
INSERT INTO mdm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Engʉ́ lɨ Ebhe apa nanɨ e kalanʉ bhʉ́ ’bhɵ opolofeta-a, a pɨ yi. La di-e, gandja ɨnde lɨ Ebhe akodho nanɨ e kalanʉ-o ne onguo ogbi yi-e, a di pɨ yi. Anɨ apa nanɨ kalanʉ pɨ Abalahama me: ‹Ma atúko bisagu pɨ́ ndʉ opiga hana pɨ́la doto lɨ pápá gba ongɨsɨ gba mʉ-o.› ");
INSERT INTO mdm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kaka-a, Ebhe abhʉ bali gba e, anɨ atsia atima ngaɨza anɨ pɨ yi omaƗsalaele. Anɨ atima anɨ me anɨ tuko bisagu pɨ́ yi. Anɨ agbé kpála ne kpála bhʉ́ siti ’ngʉ́ gba e-o.» ");
INSERT INTO mdm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lɨ Piele ne Djaa adʉ akpo ’ngʉ́ lɨe pɨ okpála-a, odimandɵ gba Ebhe-e ago bhʉ́ dabɨlɨ bini ne ngámá gba okpála nalila ’ngbé ’tɨ Ebhe gba omaYuda di ne oSadukai . ");
INSERT INTO mdm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","U adje siti bua naali. Padhá de, anga Piele ne Djaa adʉ asuno pɨ bhiti okpála. U adʉ akpokpo pɨ uo me okpála ɨnde amu-o azúku di mazuku, maka lɨ Yesu azuku lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Abhomʉ-o, u aholo Piele ne Djaa. U atsia ato uo bhʉ́ tɨkpʉ akolo pɨ kɵkpɨ́, anga adʉ me ekpɨ́ nde ngabi. ");
INSERT INTO mdm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","La-a, bhelé na okpála ɨnde adje nanɨ eli gba Ebhe-e , akolo omabhuka . Abhomʉ-o, omabhuka abe ndʉ o, u atsia akolo masɨkpe de okpála kutu bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lɨ ekpɨ́ aseke lɨe, ongámásɨ gba omaYuda , ne obhelesɨ okpála di ne omʉsuno na lɨ́lɨ gba Moidje , apo bhʉ́la o bhʉ́ gʉdhʉ na Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","A adʉ nanɨ: bhele kpála gba odimandɵ Ana, ne Kaifa, ne Djaa , ne Alekɨdjandele di ne ndʉ okpála hana ɨnde bhʉ́ piga gba bhele kpála gba odimandɵ gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Abhomʉ-o, okpála ɨnde aholo Piele ne Djaa, atsia agbe Piele ne Djaa kala uo. U atsia ayi uo me: «Yi akobho kpála ɨnde ne mangua angu dho? La di ne ’lɨ da?» ");
INSERT INTO mdm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Abhomʉ-o, Piele ɨnde abedhe nanɨ ne Bu Bhobua-a atsia apa pɨ uo me: «Ngayi ongámásɨ, di ne yi obhelesɨ okpála-a, ");
INSERT INTO mdm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ya amene bádha ’ngʉ́ pɨ dʉkuto ɨnde. La nakɨ-e, u ngayi ya me anɨ akobho lele pɨ. ");
INSERT INTO mdm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","A ayo me ndʉ yi hana, di ne ndʉ okpála na Ɨsalaele hana, yi mbɨla engʉ́ ɨnde-e ndjɨndjɨ: kpála ɨnde-e alʉ kala yi ne kʉte na angu ka angu gba Yesu Kilisito , kpála na Nadjaleta. A ko Yesu ɨnde yi agɨ nanɨ e lɨ kulusi, Ebhe atsia azuku anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu ne kpála ɨnde lɨ Bhuku gba Ebhe-e apa nanɨ engʉ́ gba e me Ebhe apa me: ‹Anɨ ne teme ɨnde lɨ ngayi okpála nayiki ’tɨ-e abhike e-o. La-a, teme ango-o akolo teme ɨnde abɨ etɨ-e libhomu.› ");
INSERT INTO mdm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Anɨ tɨ bha da nakobho okpála ngae kpi e kpi. Padhá de, anga pɨ́la doto libhomu, Ebhe ha ’lɨ kpála koko bini de ɨnde u tɨ da nakobho ka e.» ");
INSERT INTO mdm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Lɨ Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda au lɨe me Piele ne Djaa ngagama ’ngʉ́ ne tsʉlʉ ade-e, u angamba naali. Padhá de, anga u adʉ ambɨla ndjɨndjɨ me Piele ne Djaa ne okpála na padhá. U mene balʉa bhelé de. La di-e, u adʉ ambɨla ndjɨndjɨ me, u adʉ adhʉkʉ nanɨ bhʉ́ dabɨlɨ bini ne Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Engʉ́ bini, u adʉ di au kpála ɨnde akobho-o alʉ de uo. U tsia dʉ ne engʉ́ nagigie pɨ uo de. ");
INSERT INTO mdm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Abhomʉ-o, ongámásɨ aha lɨ́lɨ me obhʉlʉ titima ze kilidjo. U atsia aholo nagama ’ngʉ́ sʉnda o. ");
INSERT INTO mdm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","U adʉ apa me: «Nɨ́ améne ngʉ́ okpála ɨnde-e pɨ? Padhá de, anga ndʉ okpála hana na Yelusalema ambɨla ndjɨndjɨ me, u amene ngamba ’ngʉ́ ɨnde-e ngao. Nɨ́ tɨ la di da nayayala de. ");
INSERT INTO mdm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Engʉ́ bini, ngʉbula me ngali ango-o ayángba naali sʉnda okpála de-e, a ayo me nɨ́ gbele ’dje uo kpekpeke me u apá matá engʉ́ ne ’lɨ Yesu pɨ kpála belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Abhomʉ-o, u aꞌɨ matá obhʉlʉ titima-o. U atsia aha lɨ́lɨ pɨ uo kpekpeke me, u agáma ’ngʉ́ di ne me u asúno ne ’lɨ Yesu matá-a de. ");
INSERT INTO mdm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Engʉ́ bini, Piele ne Djaa agie pɨ uo me: «Yi kodho ’ngʉ́ ɨnde-e ngayi makpe. Bhʉ́ djila Ebhe-e, a ngbingbili ne bhedho? Ne me ya mene lɨ́lɨ gba yi, ne me ya mene mangbo lɨ́lɨ gba Ebhe! ");
INSERT INTO mdm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","La pɨ ya-a, ya tɨ da naꞌo nakpokpo ngali na engʉ́ ɨnde ya au e ne bhende ya adje e de.» ");
INSERT INTO mdm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Abhomʉ-o, Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda agama matá engʉ́ pɨ uo kpekpeke. Pɨpɨta-a, u atsia atse ’kpa lɨ uo. La-a, u u nanɨ engʉ́ ɨnde u tɨ da namene uo sisiti ka e de. Padhá de, anga ndʉ okpála hana adʉ adhɵgɵ Ebhe ka engʉ́ ɨnde akodho ’kpɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dʉkuto lɨ nakobho gba e adʉ ngangamba bhomʉ-o, adʉ nanɨ ne kalanga nane ndjɨkpa badha mane. ");
INSERT INTO mdm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lɨ u atse ’kpa lɨ Piele ne Djaa lɨe, u anʉ abhaka obɨ o. U atsia akpokpo ndʉ ’ngʉ́ hana ɨnde lɨ ongbengbe odimandɵ gba Ebhe di ne obhelesɨ okpála apa e-e pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pɨta u adje engʉ́ bhomʉ-o lɨe, omabhuka ayo Ebhe ne bua bini me: «Ngámá, mo obho ekpɨ́ ne ndʉ ’he ɨnde bhʉ́bhʉ́-o hana ngamʉ. Mo obho doto ne ndʉ ’he ɨnde bhʉ́bhʉ́-o hana ngamʉ. Mo obho la di ’ngbé ’ngu ne ndʉ ’he ɨnde bhʉ́bhʉ́-o hana ngamʉ. ");
INSERT INTO mdm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mo opa nanɨ ngamʉ bhʉ́ angu gba Bu Bhobua, bhʉ́ ’li ogbi ya Davidi, bali gba mʉ-o, me: ‹Opiga ɨnde ne omaYuda ade-e abedhe ne siti bua ka nɨ? Okpála na kʉtɨ koko adje lɨo ngʉ́ namene ongʉ́ na padhá padhá ka nɨ? ");
INSERT INTO mdm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ongbengbe ongámásɨ na doto aleke lɨo ngʉ́ egʉ́. Ongámásɨ apo bhʉ́la o bhʉ́ dabɨlɨ bini ngʉ́ nagʉ Ngámá Ebhe, di ne kpála ɨnde lɨ Ebhe abhʉ e-o.› ");
INSERT INTO mdm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Padhá de, anga a na paká me ngámá Elode Atipasɨ ne Pose Pɨlatɵ apo nanɨ bhʉ́la o bhʉ́ gʉdhʉ ɨnde, bhʉ́ dabɨlɨ bini ne opiga ɨnde ne omaYuda ade, di ne opiga na Ɨsalaele. U apo bhʉ́la o ngʉbula me o gʉ Yesu, bali na bubu gba mʉ, ɨnde mo obhʉ e maka Masɨya-o . ");
INSERT INTO mdm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","U amene bhomʉ-o ndʉ ’ngʉ́ hana ɨnde mo opa nanɨ e didili ne angu gba mʉ-o me améne lɨe mamene ko. ");
INSERT INTO mdm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","La mbɨa ɨnde-e, Ngámá, tsia nga maka u ngato mbolo lɨ ya lɨe-o. Kaka-a, ha angu pɨ ya, obalise gba mʉ, amba ya akpókpo eli gba mʉ-o ne tsʉlʉ de. ");
INSERT INTO mdm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ha angu gba mʉ-o pɨ ya, ngʉbula me ya akobho okpála, amba ya mene ongamba ’ngʉ́ di ne okɨaka ’ngʉ́ ne ’lɨ Yesu, bali gba mʉ na bubu-o.» ");
INSERT INTO mdm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lɨ u andjia nayo Ebhe lɨe, bɨlɨ ɨnde u apo bhʉ́la o lɨe adyɨkɨ má djigi djigi! Ndʉ uo hana abedhe ne Bu Bhobua. U tsia dʉ akpokpo eli gba Ebhe-e ne tsʉlʉ de. ");
INSERT INTO mdm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndʉ omabhuka hana adʉ ne bua bini. U adʉ di ne nabhundja bini. Bhʉ́ ká uo-o, kpála bini dʉ abhundja de me ehe gba nɨ-e bha pɨ nɨ kpi nɨ kpi-e de. Engʉ́ bini, oehe gba uo-o adʉ bha pɨ ndʉ uo hana. ");
INSERT INTO mdm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Obhʉlʉ titima gba Yesu adʉ akpokpo ne angu hana me Ngámá Yesu azuku. Abhomʉ-o, bádha bhʉ́ ’bu gba Ebhe-e atsia adʉ pɨ́ ndʉ uo hana. ");
INSERT INTO mdm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bhʉ́ ká uo-o, kpála bini dʉ aneke ’he de. Padhá de, anga ndʉ okpála hana ɨnde adʉ ne oedyɨ di ne oetɨ-e adʉ atsɨtsɨndjɨ, u adʉ ago ne tɨa ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","U atsia adʉ ahaha pɨ obhʉlʉ titima. Pɨpɨta-a, u atsia adʉ agbogbo bhʉsʉ tɨa ango-o lɨ kpála bini ne bini maka lɨ gʉmʉ gba anɨ adʉ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kpála bini adʉ nanɨ bhʉ́ ká uo, a adʉ ’lɨ anɨ me Djodjefʉ . Anɨ adʉ kpála na piga gba Levi. U azu nanɨ anɨ bhʉ́ kpɵmɵ na Sipele. Obhʉlʉ titima agisila nanɨ ꞌɨlɨ koko lɨ anɨ me Balanabasɨ (ɨnde akʉnda napa me «Kpála ɨnde ngato masi»). ");
INSERT INTO mdm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Anɨ atsɨndjɨ edyɨ gba e. Anɨ ago ne tɨa ango-o, anɨ atsia aꞌo kala obhʉlʉ titima. ");
INSERT INTO mdm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Abhomʉ-o, kpála bini ɨnde adʉ ’lɨ e me Ananɨa, adje lɨe ne wala e Safila. U atsɨndjɨ edyɨ gba o-o. ");
INSERT INTO mdm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anɨ aha té tɨa ango-o, aꞌo pɨ e. Anɨ atsia anʉ aꞌo dudu-o kala obhʉlʉ titima gba Yesu-o . Wala anɨ adʉ ambɨla ’ngʉ́ tété ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Abhomʉ-o, Piele apa pɨ anɨ me: «Ananɨa, mo ozɨba me Satana pite nɨ ngʉ́ nɨ? Mo opa eu pɨ Bu Bhobua , anga mo oha té tɨa na edyɨ-e, mo oꞌo pɨ mʉ. ");
INSERT INTO mdm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kala me mʉ tsɨndjɨ edyɨ ango-o, a ko nako naamʉ dɨ? La di-e, mo otsɨndjɨ lɨe, tɨa ango-o, a ko nako naamʉ dɨ? Mo ozɨba me nɨ mene ngua ’ngʉ́ ɨnde-e ka nɨ? Mʉ pite okpála de, engʉ́ bini, mo opite bhomʉ-o Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bha lɨ nedhɨnga ɨnde lɨ Ananɨa adje engʉ́ bhomʉ-o lɨe, anɨ atɨ, anɨ atsia akpi. Ndʉ okpála hana ɨnde adje engʉ́ ango-o, adʉ ne tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Abhomʉ-o, omakombise ago. U agala kuo anɨ ne bongo , u aꞌe, u atsia anʉ azɨ. ");
INSERT INTO mdm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Masɨkpe de pɨta saa bata-a, wala Ananɨa ago alɨ oo me anɨ nde mbɨla engʉ́ ɨnde akodho ’kpɨ́-e de. ");
INSERT INTO mdm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piele ayi anɨ me: «Pa nga mʉma, yi atsɨndjɨ bha ndjʉ edyɨ gba yi-e bhʉ́ mase ɨnde-e?» Ɵlɵ-o agie me: «A moko, ya atsɨndjɨ bhʉ́ mase bhomʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Abhomʉ-o, Piele atsia apa pɨ anɨ me: «Yi adje lɨyi ne ’ko mʉ ngʉ́ nale Bua gba Ngámá-a ngʉ́ nɨ? Djedje nga! Okpála ɨnde ɨ kolo nazɨ ’ko mʉ-o, u alʉlʉ lɨ bhotɨ bhomʉ. U abɨ́ bhadi mʉ moko!» ");
INSERT INTO mdm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bha lɨ nedhɨnga bhomʉ-o, ɵlɵ-o atɨ kuto bhʉ́ li ’dhʉ Piele, anɨ atsia akpi. Omakombise alɨ, u abhaka me anɨ nde akpi. Abhomʉ-o, u aꞌe kuo anɨ, u atsia anʉ azɨ anɨ dengo ’ko e. ");
INSERT INTO mdm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ndʉ okpála na Piga gba Ebhe-e hana, di ne ndʉ okpála hana ɨnde adje engʉ́ ɨnde akodho ’kpɨ́-e, adje tsʉlʉ naali. ");
INSERT INTO mdm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Obhʉlʉ titima gba Yesu-o adʉ amene nanɨ ongamba ’ngʉ́ di ne okɨaka ’ngʉ́ bhelé bhʉ́ ká okpála. Ndʉ omabhuka hana adʉ apo bhʉ́la o sa basa ɨnde u aꞌɨ e me «Sa ngba ’tɨ gba Salomo.» ");
INSERT INTO mdm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kpála bini bhʉ́ ká okpála bhende ɨ bhuka de-e le nanɨ nalɨ bhʉ́ ká uo de, abana lɨ ndʉ okpála hana adʉ apa ’ngʉ́ gba uo-o lɨe ndjɨndjɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Obhosɨ bhelé naali di ne olɨsɨ bhelé naali ɨnde abhuka Ngámá-a, adʉ alɨ bhʉ́ ká omabhuka, u atsia adʉ abe ndʉ o. ");
INSERT INTO mdm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","U aholo belegʉ apandja okpála na kuo lɨ okpadjɨ. U adʉ aseke uo pɨ́ okalagba di ne pɨ́ otsala. U adʉ amene mo-o, anga u adʉ abhundja me ɨ dʉ me Piele nde akodho ’kpɨ́ oo, kulu anɨ de pʉ mbo pɨ́ sʉka uo, amba anɨ kobho. ");
INSERT INTO mdm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Okpála bhelé adʉ di ayie bhʉ́ okʉtɨ na ngo Yelusalema, u adʉ ago ne okpála na kuo di ne okpála ɨnde adʉ ne osisiti bua bhʉ́ o-o. Ndʉ uo hana atsia adʉ akobho. ");
INSERT INTO mdm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Abhomʉ-o, bhele kpála gba odimandɵ gba Ebhe-e di ne ndʉ okpála hana ɨnde adʉ bhʉ́ dabɨlɨ bini ne anɨ-e, a akʉnda napa me libi oSadukai , adje siti bua naali pɨndjɨ obhʉlʉ titima gba Yesu. U atsia apa me, a ayo namene uo sisiti. ");
INSERT INTO mdm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","U aholo obhʉlʉ titima-o, u atsia ato uo bhʉ́ tɨkpʉ bhe na ngbéngbé-o. ");
INSERT INTO mdm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","La sukpe-e, andjelu bini gba Ngámá aꞌʉ obhɵ bhotɨ na tɨkpʉ-o. Anɨ apandja obhʉlʉ titima-o. Anɨ atsia apa pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Yi nʉ bhʉ́ ’ngbé ’tɨ Ebhe gba omaYuda. Oo, yi kpokpo pɨ okpála ndʉ ’ngʉ́ hana ɨnde atsia mʉkobho na mbɨa-o.» ");
INSERT INTO mdm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Obhʉlʉ titima-a amene bhadi mo-o. Kɵkpɨ́ naali-e, u anʉ bhʉ́ ’ngbé ’tɨ Ebhe, u atsia aholo nasuno pɨ okpála. Lɨ nedhɨnga bhomʉ-o, bhele kpála gba odimandɵ gba Ebhe-e bhʉ́ dabɨlɨ bini ne okpála gba e-e, u aꞌɨ Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaƗsalaele-o. U atsia atima okpála me u nʉ ha obhʉlʉ titima-a bhʉ́ tɨkpʉ, amba u go ne uo. ");
INSERT INTO mdm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Engʉ́ bini, lɨ okpála ango-o anʉ lɨe, u bhaka uo bhʉ́ tɨkpʉ de. U agie lɨo, u atsia apa pɨ Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda-a me: ");
INSERT INTO mdm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Ya abhaka me ’bhɵ tɨkpʉ-o nde ani lɨe ndjɨndjɨ. Okpála nalila tɨkpʉ-o nde adʉlʉ lɨ obhɵbhɵ. La-a, ya aꞌʉ bhotɨ-e lɨe, ya abhaka kpála bhʉ́bhʉ́ oo belegʉ de bini!» ");
INSERT INTO mdm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lɨ ngámá gba okpála nalila ’ngbé ’tɨ Ebhe-e, di ne ongbengbe odimandɵ gba Ebhe , adje engʉ́ ango-o lɨe-e, mabhundja gba uo angbɨngɨ naali. U mbɨla de me a akolo lɨ obhʉlʉ titima-a ne mangua ’ngʉ́ dho-ie de. ");
INSERT INTO mdm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pɨpɨta-a, kpála bini ago, anɨ apa pɨ uo me: «Yi djedje nga! Okpála ɨnde yi abu nako o bhʉ́ tɨkpʉ-o, uo mbɨa ɨnde-e bhʉ́ ’ngbé ’tɨ Ebhe. U alʉlʉ malʉlʉ, u ngasuno pɨ okpála.» ");
INSERT INTO mdm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Abhomʉ-o, ngámá gba omʉlila-a anʉ ne osʉdha gba e-o. Anɨ aha obhʉlʉ titima-a, anɨ ago ne uo. Engʉ́ bini, u mene uo sisiti de. Padhá de, anga u adʉ akpe me okpála abhíli o ne teme de. ");
INSERT INTO mdm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pɨta anɨ ago ne uo lɨe, anɨ aꞌo uo kala Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda-o. Abhomʉ-o, bhele kpála gba odimandɵ gba Ebhe-e aholo nayiyi uo me: ");
INSERT INTO mdm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Ya aha nako lɨ́lɨ pɨ yi kpekpeke me yi asúno ne ’lɨ kpála bhomʉ-o de. La-a, nasuno gba yi-e aha Yelusalema libhomu! Yi ngakʉnda me ngʉte kpála bhomʉ-o tuko pɨ́ ya!» ");
INSERT INTO mdm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piele di ne obhʉlʉ titima koko agie me: «A ayo me ya mene lɨ́lɨ gba Ebhe ane lɨ́lɨ gba okpála. ");
INSERT INTO mdm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ngayi-e, yi abhɵlɵ Yesu lɨ kulusi. Engʉ́ bini, Ebhe gba ogbi nɨ́-e azuku anɨ bhʉ́ ká okpála ɨnde amu. ");
INSERT INTO mdm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ebhe aꞌeꞌe anɨ abhʉ́lá lɨ pá ’kpa e na kokpa, anɨ aꞌo anɨ Ngámá di ne Mʉkobho . Anɨ amene mo-o ngʉbula me okpála na Ɨsalaele dji bua o, amba Ebhe ꞌe siti ’ngʉ́ gba uo-o. ");
INSERT INTO mdm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ya au ongʉ́ bhomʉ-o ne djila ya makpe. Bu Bhobua, ɨnde lɨ Ebhe ngaha e pɨ okpála ɨnde ngamene lɨ́lɨ gba anɨ-e, au di.» ");
INSERT INTO mdm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lɨ Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda adje engʉ́ ango-o lɨe, u abɨ ’gʉ́ naali. U di me bhili obhʉlʉ titima gba Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Engʉ́ bini mʉFalisai bini ɨnde adʉ ’lɨ e me Gamaliele, a adʉ bhʉ́ ká uo. A adʉ mʉsuno na lɨ́lɨ . Ndʉ okpála hana adʉ amanga anɨ ndjɨndjɨ. Anɨ ayie bhʉ́lá. Anɨ ayo me u pandja nga obhʉlʉ titima-a kilidjo. ");
INSERT INTO mdm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pɨpɨta-a, anɨ atsia apa me: «Ngayi okpála na Ɨsalaele, yi lila lɨyi ndjɨndjɨ lɨ ’ngʉ́ ɨnde yi adji amene e lɨ kʉte okpála ɨnde-o! ");
INSERT INTO mdm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Padhá de, anga ane nga ekpɨ́ bhelé de, kpála bini akoto nako, a adʉ ’lɨ anɨ me Teudasɨ. Anɨ adʉ apa me nɨ ne ’ngbé kpála. Okpála masɨkpe de kámá badha adʉ akpata anɨ. Engʉ́ bini, u abhɵlɵ anɨ lɨe, ndʉ okpála hana ɨnde adʉ akpata anɨ-e atsia atsambala. Abhomʉ-o, engʉ́ gba anɨ-e atsia andjia. ");
INSERT INTO mdm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pɨta anɨ-e, lɨ nedhɨnga u adʉ atanga okpála lɨe, Yuda, kpála na Galilaya, akoto. Anɨ agbele okpála nganda e bhelé. Ngaanɨ di-e, u abhɵlɵ anɨ. Abhomʉ-o, okpála ɨnde adʉ akpata anɨ-e atsia atsambala. ");
INSERT INTO mdm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kaka mbɨa ɨnde-e, ma apa pɨ yi me yi adhédhe lɨ okpála ɨnde-e de. Yi ꞌo uo. Padhá de, anga ɨ dʉ me mabhundja di ne ongʉ́ gba uo nde ayie ka okpála-a, ɨ kólo padhá. ");
INSERT INTO mdm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Engʉ́ bini, ɨ dʉ la me ongʉ́ bhomʉ-o nde ayie ka Ebhe-e, yi tɨ́ da nabhɵbhɵlɵ de. ꞌE-e! Yi agʉ́ gbele ne Ebhe de.» Abhomʉ-o, Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda atsia azɨba mabhundja gba Gamaliele-o. ");
INSERT INTO mdm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","U aꞌɨ obhʉlʉ titima-o. U aha lɨ́lɨ me u bhɨ uo ne fimbo. U aha di lɨ́lɨ pɨ uo kpekpeke me u akpó ’ngʉ́ matá ne ’lɨ Yesu belegʉ de bini. Pɨpɨta-a, u atsia atse ’kpa lɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abhomʉ-o, obhʉlʉ titima-a akoto me u nde abedhe ne djalɨ bedhe. Padhá de, anga Ebhe au ndjɨndjɨ me u zʉ lɨkabhu ngʉbula ’lɨ Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ekpɨ́ bini ne bini hana, u adʉ bha nasuno di ne nakpokpo Bádha Ngali gba Yesu Masɨya bhʉ́ ’ngbé ’tɨ Ebhe di ne bhʉ́ otɨ gba o-o. ");
INSERT INTO mdm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lɨ nedhɨnga ango-o, omʉkpata adʉ akolo bhelé. Engʉ́ bini, omaYuda ɨnde adʉ nadi eli na giliki-e, atsia aholo nadi mʉtokono lɨ obhende adʉ nadi eli na ebele-o. U adʉ apa me: «Ndʉ ’kpɨ́ hana nedhɨnga nagapa ’zʉ-o, u ngaha ezʉ pɨ oɵkɵsɨ na libi gba ya-a ndjɨndjɨ ade.» ");
INSERT INTO mdm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Abhomʉ-o, obhʉlʉ titima ndjɨkpa ne ká bhisi gba Yesu-o apɵkɵbhɵ bhʉ́la ndʉ omabhuka hana. U atsia apa pɨ uo me: «A ayo de me ya ꞌo ká nakpokpo eli gba Ebhe-e ngʉ́ nagapa ’zʉ-o de. ");
INSERT INTO mdm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kaka-a, ondaise ya, yi gɨlɨ okpála mananɨka ɨnde lɨ okpála ngazɨba o ndjɨndjɨ, ɨnde abedhe ne Bu Bhobua di ne ɨmbɨlangʉ bhʉ́ ká yi, amba ya ha kulu bhomʉ-o pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Abhomʉ-o ngaya-a, ya tɨ́ da naha ndʉ nedhɨnga gba ya-a hana ngʉbula nayo di ne nakpokpo Bádha Ngali gba Ebhe-o.» ");
INSERT INTO mdm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ndʉ okpála hana azɨba engʉ́ ɨnde lɨ obhʉlʉ titima apa e ko. Abhomʉ-o, u alo Etieni, kpála ɨnde abedhe ne nabhuka di ne Bu Bhobua, ne Filipo, ne Polokole, ne Nikanola, ne Timonɨ, ne Palamenasɨ, ne Nikola, kpála na kʉtɨ na Atiokia ɨnde abhuka nanɨ Ebhe gba omaYuda ko. ");
INSERT INTO mdm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","U anʉ ne uo kala obhʉlʉ titima. Abhomʉ-o, obhʉlʉ titima aꞌo ’kpa o pɨ́ uo, u atsia ayo Ebhe pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eli gba Ebhe-e adʉ bha naya ne kalanʉ. Abhomʉ-o, alo gba omabhuka atsia adʉ aꞌʉ ne bhʉ́lá naali bhʉ́ Yelusalema. Odimandɵ gba Ebhe bhelé atsia abhuka di. ");
INSERT INTO mdm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etieni abedhe nanɨ ne angu ka bádha bhʉ́ ’bu gba Ebhe . Abhomʉ-o, anɨ atsia adʉ amene ongbengbe ’ngʉ́ di ne ongʉ́ na ngangamba bhʉ́ ká okpála. ");
INSERT INTO mdm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Okpála koko ago ngʉ́ namene kpekebhɵ ne Etieni. Bhʉ́ ká uo-o, okoko adʉ okpála ɨnde adʉ apo bhʉ́la o bhʉ́ etɨ nadje lɨ́lɨ gba Moidje , ɨnde u aꞌɨ e me «Etɨ nadje lɨ́lɨ gba okpála ɨnde aze bhʉ́ bali-o.» Okoko ayie nanɨ bhʉ́ gʉdhʉ na Silene, ne bhʉ́ gʉdhʉ na Alekɨdjandɨlɨ, ne bhʉ́ ndu doto na Silisia di ne bhʉ́ ndu doto na Adjia. ");
INSERT INTO mdm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Engʉ́ bini, ɨmbɨlangʉ gba uo tɨ nanɨ da nakolo lɨ bhe gba anɨ-e de. Padhá de, anga anɨ adʉ agama ’ngʉ́ ne ɨmbɨlangʉ di ne angu ɨnde lɨ Bu Bhobua adʉ aha e pɨ anɨ ngae ko. ");
INSERT INTO mdm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Abhomʉ-o, u aha tɨa pɨ okpála, amba u pa eu lɨ anɨ me: «Ya adje anɨ me anɨ nde ngasobho Moidje di ne Ebhe!» ");
INSERT INTO mdm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","U amene moko ngʉbula me okpála, ne obhelesɨ okpála di ne omʉsuno na lɨ́lɨ-e , bɨ ’gʉ́ ngʉ́ Etieni. Pɨpɨta-a, u aze lɨ Etieni, u aholo anɨ. U atsia anʉ ne anɨ kala Libi okpála natsia ’kpɨ́ lɨ ’ngʉ́ gba omaYuda ko. ");
INSERT INTO mdm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Oo, u anʉ di ne okpála ɨnde adʉ apa ’ngʉ́ lɨ Etieni ne eu. Okpála ango-o atsia adʉ apa me: «Kpála ɨnde-e, ndʉ ’kpɨ́ hana, ngapa bha bini ’ngʉ́ sisiti lɨ kʉte ’ngbé ’tɨ Ebhe na bubu gba nɨ́, di ne lɨ kʉte lɨ́lɨ gba Moidje-o . ");
INSERT INTO mdm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ya adje anɨ me anɨ nde ngapa me: ‹Yesu ango-o, kpála na Nadjaleta, abhɵ́lɵ ’ngbé ’tɨ Ebhe ɨnde, anɨ tsia djí di odasʉndʉ ɨnde ya asia e ka Moidje ko.›» ");
INSERT INTO mdm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ndʉ okpála ɨnde adʉ bhʉ́ ’tɨ oo hana abanga djila o lɨ Etieni. U atsia au me bhʉ́la anɨ adʉ asʉ maka bhʉ́la andjelu . ");
INSERT INTO mdm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Abhomʉ-o, bhele kpála gba odimandɵ ayi Etieni me: «Engʉ́ ɨnde u ngapa e lɨ mʉ bhomʉ-o, a ko bha ndjʉ kʉkʉlʉ ’ngʉ́?» ");
INSERT INTO mdm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etieni atsia agie me: «Odyɨ ma di ne ondaise ma, yi djedje nga! Ebhe na sangu akoto nanɨ lɨ ogbi nɨ́ Abalahama bhʉ́ ndu doto na Medjopotami kala me anɨ nʉ nasɨ kʉtɨ bhʉ́ ndu doto na Alana. ");
INSERT INTO mdm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Anɨ atsia apa pɨ anɨ me: ‹ꞌO ká doto gba mʉ di ne piga gba mʉ-o, amba mʉ nʉ bhʉ́ doto ɨnde ma asúno e pɨ mʉ ko.› ");
INSERT INTO mdm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abhomʉ-o, Abalahama ayie bhʉ́ doto gba oKaladea, anɨ atsia anʉ nasɨ kʉtɨ bhʉ́ Alana. Pɨta lɨ ’dyɨ anɨ akpi lɨe, Ebhe aꞌe anɨ bhʉ́ Alana, anɨ atsia ago aꞌo anɨ bhʉ́ doto yi nde bhʉ́ e mbɨa ɨnde-e ko. ");
INSERT INTO mdm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ebhe ha nga nanɨ edyɨ pɨ anɨ sɨɨ de, belegʉ de mboye bɨlɨ naꞌo ’dhʉ e ka anɨ tété. La-a, anɨ atsia apa nanɨ pɨ anɨ kalanʉ me: ‹Ma ahá doto ɨnde-e pɨ mʉ, lɨ ongɨsɨ gba mʉ-o tsia tígala ne di pɨta mʉ-o ngao.› La-a, lɨ nedhɨnga bhomʉ-o, ndɨlɨ dʉ nga nanɨ ka anɨ de. ");
INSERT INTO mdm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ebhe apa pɨ anɨ bhomʉ-o me: ‹Ongɨsɨ gba ongɨsɨ gba mʉ-o anʉ́ adʉlʉ bhʉ́ doto na gandji gandji. Oo, u akólo obalise gba okpála na doto ango-o. Lɨ okpála ango-o méne uo sisiti ngʉbula kalanga kámá badha.› ");
INSERT INTO mdm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","La-a, Ebhe apa matá di me: ‹Ma akódho ’ngʉ́ gba okpála ɨnde u akólo obalise pɨ o-o ngama. Pɨpɨta-a, u zé oo, u tsia gó dʉ́ adhɵgɵ ma lɨ bɨlɨ ɨnde.› ");
INSERT INTO mdm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Abhomʉ-o, Ebhe atsia akodho gandja ne Abalahama. Lɨ Abalahama azu Ɨsaka lɨe, anɨ atsia ato anɨ bhʉ́ gandja bhʉ́ ’kpɨ́ na madjɨna nayie lɨ ’kpɨ́ u azu anɨ lɨe-o. Ɨsaka amene bhadi moko pɨ Yakobho. Yakobho atsia amene bhadi moko pɨ onguo ogbi nɨ́ ndjɨkpa ne ká bhisi-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pɨpɨta-a, onguo ogbi nɨ́ ango-o adje siti bua naali pɨ Djodjefʉ , ndɨndɨlɨ pɨta o-o. Abhomʉ-o, u atsia atsɨndjɨ anɨ me u nʉ ne anɨ bhʉ́ bali bhʉ́ Edjipeto. La-a, Ebhe adʉ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ebhe agbegbe Djodjefʉ bhʉ́ lɨkabhu gba e hana. Anɨ asuno bádha bhʉ́ ’bu gba e pɨ anɨ ne ɨmbɨlangʉ, anɨ atsia amene di me engʉ́ gba anɨ-e dʉ anga lɨ Falao, ’ngbé ngámá na doto na Edjipeto-o naali. Abhomʉ-o, Falao atsia aꞌo anɨ ngámá pɨ́ ’ndjɨ Edjipeto di ne pɨ́ ’ndjɨ etɨ gba e libhomu. ");
INSERT INTO mdm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pɨpɨta-a, adyɨndɨ atsia alɨ bhʉ́ Edjipeto libhomu di ne bhʉ́ doto na Kanana. Lɨkabhu adʉ naali. Kaka-a, onguo ogbi nɨ́ dʉ asia ehe nazʉ mazʉ de. ");
INSERT INTO mdm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lɨ Yakobho adje lɨe me ehe nazʉ mazʉ bhʉ́ Edjipeto-o, anɨ atsia atima ongɨsɨ gba e, onguo ogbi nɨ́ oo bhʉtsibhʉtsi na bini. ");
INSERT INTO mdm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","U anʉ lɨe bhʉtsibhʉtsi na bhisi-e, Djodjefʉ atsia asuno lɨe pɨ ondaise e. Abhomʉ-o, Falao atsia ambɨla piga gba Djodjefʉ-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pɨpɨta-a, Djodjefʉ atima okpála me u nʉ ha ’dyɨ nɨ Yakobho ne piga gba e hana. U adʉ nanɨ ndʉ o hana okpála ndjɨkpa mananɨka ne ká bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Abhomʉ-o, Yakobho anʉ bhʉ́ dabɨlɨ bini ne ongɨsɨ gba e, onguo ogbi nɨ́, bhʉ́ Edjipeto. U atsia amu oo. ");
INSERT INTO mdm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","U abha kuo uo anʉ ne di bhʉ́ gʉdhʉ na Sikeme. Abhomʉ-o, u atsia azɨ bhʉ́ lata ɨnde lɨ Abalahama akala nanɨ e ka ongɨsɨ gba Emola bhʉ́ Sikeme-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Lɨ nedhɨnga akolo lɨe masɨkpe ngʉbula me Ebhe mene engʉ́ ɨnde anɨ apa nanɨ e kalanʉ me nɨ améne e pɨ Abalahama, piga gba nɨ́-e abe ndʉ e. Okpála atsia akolo bhelé bhʉ́ Edjipeto. ");
INSERT INTO mdm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pɨpɨta-a, ngámá koko aholo naʉ bhʉ́ Edjipeto. Ngámá ango-o mbɨla nanɨ engʉ́ gba Djodjefʉ-o de. ");
INSERT INTO mdm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Anɨ apite okpála gba nɨ́-o, anɨ atsia amene onguo ogbi nɨ́ sisiti. Anɨ aholo uo ne kpéke me u ꞌo ká ongɨsɨ na ndjendje gba o-o, amba ongɨsɨ ango-o mu. ");
INSERT INTO mdm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lɨ nedhɨnga bhomʉ-o, u azu Moidje . Anɨ adʉ babadha naali bhʉ́ djila Ebhe. U akʉ anɨ epe bata bhʉ́ ’bu ’tɨ gba ’dyɨ e. ");
INSERT INTO mdm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lɨ u aꞌo ká anɨ lɨe, ndɨlɨ na ɵɵlɵ gba Falao aha anɨ, anɨ atsia akʉ anɨ maka ndɨlɨ gba e makpe. ");
INSERT INTO mdm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","U asuno ndʉ ɨmbɨlangʉ hana gba okpála na Edjipeto pɨ Moidje. Anɨ atsia akolo kpekpeke bhʉ́ nagama ’ngʉ́ di ne namene ’he. ");
INSERT INTO mdm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Lɨ Moidje akolo lɨe ne kalanga ndjɨkpa badha-a, anɨ atsia abhundja lɨ bua e me nɨ nʉ tsia ondaise nɨ, omaƗsalaele. ");
INSERT INTO mdm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Oo, anɨ au me maEdjipeto bini ngamene sʉka omaƗsalaele sisiti. Abhomʉ-o, ngʉ́ nagie siti ’ngʉ́ bhomʉ-o, anɨ atsia abhɵlɵ maEdjipeto ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moidje adʉ abhundja naae me ondaise nɨ omaƗsalaele ambɨla me Ebhe alo nɨ ngʉ́ nakobho o. Engʉ́ bini ngauo-o, u mbɨla la mo-o de. ");
INSERT INTO mdm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lɨ ekpɨ́ aseke lɨe, Moidje abhaka me omaƗsalaele bhisi nde ngagʉ gbele sʉnda o. Abhomʉ-o, anɨ akʉnda nayoko uo. Do anɨ de-e: ‹Wai, yi ne ondaise. Yi ngamene lɨyi sisiti ka nɨ?› ");
INSERT INTO mdm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Engʉ́ bini, kpála bhende adʉ amene kilí e sisiti-e andjimba Moidje, anɨ atsia apa me: ‹A ko da ɨnde aꞌo mʉ ngámá di ne kpála nakodho ’ngʉ́ gba ya-a? ");
INSERT INTO mdm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mo okʉnda nabhɵlɵ ma, maka mo obhɵlɵ lili maEdjipeto lɨe?› ");
INSERT INTO mdm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lɨ Moidje adje eli bhomʉ-o lɨe, anɨ ayie bhʉ́ Edjipeto, anɨ akpe, anɨ atsia anʉ adʉ bhʉ́ doto na Madiana. Oo, anɨ azu ongɨsɨ na obhosɨbhosɨ bhisi. ");
INSERT INTO mdm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Pɨta kalanga ndjɨkpa badha-a, andjelu bini akoto lɨ Moidje bhʉ́ mili bɨlɨ dengo eta na Sinai. Andjelu ango-o akoto lɨ anɨ bhʉ́ djua me a nde ngatsi bhʉ́ tsá ’pó. ");
INSERT INTO mdm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Anɨ angamba naali ka engʉ́ ɨnde anɨ au e-o. Nedhɨnga anɨ adʉ adyudyo lɨe lɨe masɨkpe ngʉ́ natsitsia-a, anɨ atsia adje ’li Ngámá apa me: ");
INSERT INTO mdm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ma ne Ebhe gba onguo ogbi mʉ, Ebhe gba Abalahama, Ebhe gba Ɨsaka, Ebhe gba Yakobho.› Moidje aholo nagʉkʉ ka tsʉlʉ, anɨ le natsitsia de. ");
INSERT INTO mdm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Abhomʉ-o, Ngámá atsia apa pɨ anɨ me: ‹Pandja malɵkɵ bhʉ́ ’dhʉ mʉ, anga bɨlɨ mo olʉ lɨe ɨnde-e, a ko bɨlɨ na bubu. ");
INSERT INTO mdm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ma au maka u ngato mbolo lɨ okpála gba ma bhʉ́ Edjipeto lɨe au. Ma atsia adje la di maka u ngalopolo lɨo lɨe adje. Ma ago ngʉ́ nagbegbe uo bhʉ́ bali ango-o. Mbɨa ɨnde-e, ma ngatima mʉ bhʉ́ Edjipeto, nʉnʉ.› ");
INSERT INTO mdm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","A ko Moidje ɨnde lɨ omaƗsalaele ayala e, ɨnde u apa pɨ e me: ‹Aꞌo mʉ ngámá di ne kpála nakodho ’ngʉ́ gba ya-a da?› Ebhe atima anɨ me anɨ dʉ ngámá di ne mʉkobho. Andjelu apa pɨ anɨ lɨ nedhɨnga ɨnde anɨ akoto lɨ anɨ lɨe bhʉ́ tsá ’pó ɨnde adʉ atsi ko. ");
INSERT INTO mdm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moidje agbegbe omaƗsalaele bhʉ́ doto na Edjipeto ngae. Anɨ amene ongʉ́ na ngbengbengbe di na ngangamba bhʉ́ doto ango-o, bhʉ́ ’ngbé ’ngu na Mbembe di ne bhʉ́ ’gʉ. Anɨ amene ongʉ́ ango-o bhʉ́ kalanga ndjɨkpa badha. ");
INSERT INTO mdm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A ko matá bhadi Moidje ɨnde apa pɨ omaƗsalaele me: ‹Ebhe agbé polofeta pɨ yi maka ma bhʉ́ ká ondaise yi.› ");
INSERT INTO mdm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lɨ onguo ogbi nɨ́ apɵkɵbhɵ bhʉ́la o lɨe bhʉ́ ’gʉ-o, Moidje adʉ oo. Anɨ adʉ bhʉ́ dabɨlɨ bini ne onguo ogbi nɨ́. Anɨ adʉ la di bhʉ́ dabɨlɨ bini ne andjelu ɨnde adʉ agama ’ngʉ́ pɨ anɨ apɨ́ ’ta na Sinai-o. Anɨ asia eli na mʉkobho-o ngʉ́ nakpokpokpo pɨ nɨ́ ngae. ");
INSERT INTO mdm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Engʉ́ bini, onguo ogbi nɨ́ dʉ amene lɨ́lɨ gba anɨ-e de, u adʉ ayala anɨ. Abhomʉ-o, u adʉ akʉnda nagie lɨo bhʉ́ doto na Edjipeto. ");
INSERT INTO mdm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","U apa pɨ Alona me: ‹Bho oebhe pɨ ya, amba u dʉ adholo kala ya. Padhá de, anga Moidje ɨnde-e, ɨnde apandja ya bhʉ́ doto na Edjipeto-o, ya mbɨla engʉ́ ɨnde akolo lɨ anɨ-e de.› ");
INSERT INTO mdm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Abhomʉ-o, u abho kulu ndɨlɨ bagala, bhʉ́ oekpɨ́ bhomʉ, u atsia atsulu enʉ pɨ anɨ. U amene anokomɨa kabula ehe ɨnde u abho e ne ’kpa o-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Engʉ́ bini, Ebhe adji ’ngbʉ e lɨ uo, anɨ atsia aꞌo uo me u dhɵgɵ oɨkʉpala, maka u aye lɨe bhʉ́ bhuku gba opolofeta me: ‹Ngayi okpála na Ɨsalaele-e, yi atsulu nanɨ oenʉ mʉma uu? Yi aha la di oehe koko mʉma uu sʉnda kalanga ndjɨkpa badha bhʉ́ ’gʉ-o? A mo-o ade. ");
INSERT INTO mdm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yi abɨ mangbo wema gba ebhe Moloko, di ne kulu ɨkʉpala gba ebhe gba yi Lefana-o. A bhomʉ-o kulu oehe na padhá padhá, ɨnde yi abho o ngʉbula nadhɵgɵ o-o. Kaka-a, ma ambá yi tsutsu nane Babilona mane.› ");
INSERT INTO mdm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Onguo ogbi nɨ́, bhʉ́ ’gʉ-o, adʉ nanɨ ka uo ne ’tɨ ngbangbalɨ lɨ Ebhe adʉ asuno lɨe bhʉ́ e-o. Moidje abho nanɨ maka bhende lɨ Ebhe asuno nanɨ e pɨ anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Abhomʉ-o, u atsia aha ’tɨ ngbangbalɨ ango-o pɨ ongɨsɨ gba onguo ogbi nɨ́, ɨnde adʉ lɨ nedhɨnga lɨ Djodjue adʉ lɨe ngámá-o. U atsia adʉ alɨ ne di bhʉ́ odoto gba opiga ɨnde lɨ Ebhe ato nanɨ holo bhʉ́ ’dhʉ o kala uo-o. U adʉ oo akolo bhʉ́ nedhɨnga gba ’ngbé ngámá Davidi. ");
INSERT INTO mdm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Engʉ́ gba Davidi ɨnde asia nanɨ bádha bhʉ́ ’bu gba Ebhe-e , adʉ bhʉ́ djila Ebhe ndjɨndjɨ. Anɨ atsia ayo nanɨ kpadjɨ me nɨ yiki etɨ pɨ Ebhe gba Yakobho. ");
INSERT INTO mdm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Engʉ́ bini, Salomo, ndɨlɨ gba Davidi-e, ayiki mangbo nanɨ etɨ pɨ anɨ ngae. ");
INSERT INTO mdm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","La-a, Ebhe Apɨ́ ’Kpɨ́ dʉdʉ bhʉ́ ’tɨ ɨnde lɨ okpála ayiki e ne ’kpa o-o de. Maka lɨ polofeta apa lɨe me: ");
INSERT INTO mdm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Ngámá apa me: ekpɨ́ ne dabɨlɨ na ngámá gba ma-o. Doto ne dabɨlɨ na sa ’dhʉ ma. Mangua ’tɨ dho yi ayíki e mʉma? Bɨlɨ ma agúo lɨe su? ");
INSERT INTO mdm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ma bho ndʉ ’he bhomʉ-o hana ngama dɨ?›» ");
INSERT INTO mdm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pɨpɨta-a, Etieni atsia apa me: «Ngayi-e, yi ne okpála na kpekpeke ’ndjɨ! Bua yi agbigbite lɨe, ’dje yi atsia anini! Ndʉ ’kpɨ́ hana yi ngamene kpekebhɵ ne Bu Bhobua maka onguo ogbi yi! ");
INSERT INTO mdm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A ko polofeta bhedho ɨnde lɨ onguo ogbi yi to mbolo lɨ e de-e? U abhɵlɵ belegʉ obhende akpokpo ’ngʉ́ pɨndjɨ nago ka Kpála na Ngbingbili-o. Mbɨa ɨnde-e, kpála ango-o, yi apʉ anɨ, yi atsia abhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ngayi okpála ɨnde asia lɨ́lɨ gba Ebhe-e ka oandjelu-o, engʉ́ bini, yi mene la lɨ́lɨ ango-o de!» ");
INSERT INTO mdm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lɨ okpála ɨnde adʉ lɨ bɨlɨ nakodho ’ngʉ́-o adje engʉ́ lɨ Etieni apa e lɨe, u abɨ ’gʉ́ lɨ bua o. U atsia aholo nazʉ tate o ngʉbula anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Engʉ́ bini, Etieni ɨnde adʉ me anɨ nde abedhe ne Bu Bhobua-a, atsia ’kpɨ́ ne abhʉ́lá, anɨ au zɨ Ebhe. Anɨ atsia au di Yesu me anɨ nde alʉ lɨ pá ’kpa na kokpa gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Anɨ atsia apa me: «Yi djedje nga! Ma au kokpɨ́ abhulu lɨe, Ndɨlɨ gba kpála alʉ lɨ pá ’kpa na kokpa gba Ebhe!» ");
INSERT INTO mdm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ndʉ okpála hana ɨnde adʉ oo adje engʉ́ bhomʉ-o lɨe, u asʉla ne ꞌue kpekpeke, u anini ’dje o. U anʉ ndʉ o hana bhʉ́ dabɨlɨ bini, u atsia atuko pɨ́ Etieni. ");
INSERT INTO mdm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","U agbe anɨ bhʉ́ gʉdhʉ-o, u atsia aholo natʉtʉlʉ anɨ ne oteme ngʉ́ nabhɵlɵ anɨ. Okpála ɨnde adʉ apa ’ngʉ́ lɨ anɨ ne eu-o, abhʉ nanɨ makombi bini. U atsia abu obongo gba o-o bhʉ́ li ’dhʉ anɨ ngʉ́ nalilila. A adʉ ’lɨ makombi ango-o me Saulo. ");
INSERT INTO mdm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nedhɨnga u adʉ atʉtʉlʉ Etieni lɨe ne teme ngʉ́ nabhɵlɵ anɨ-e, anɨ atsia ayo Ebhe me: «Ngámá Yesu, ha bua ma haha!» ");
INSERT INTO mdm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Abhomʉ-o, anɨ akikita lɨpʉkʉ e kuto, anɨ asʉla kpekpeke me: «Ngámá, mo otsía siti ’ngʉ́ gba uo-o de!» Pɨta anɨ apa ’ngʉ́ bhomʉ-o lɨe, anɨ atsia andala ’kpa lɨ bua e. ");
INSERT INTO mdm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Abhomʉ-o, Saulo atsia azɨba me u bhɵlɵ Etieni. Bha lɨ ’kpɨ́ ango-o, u aholo nato mbolo naali lɨ okpála na Piga gba Ebhe na gʉdhʉ na Yelusalema. Ndʉ omabhuka hana akpe, naneke bha bini obhʉlʉ titima gba Yesu-o . U atsia atsambala bhʉ́ ndu doto na Yudaya ne bhʉ́ ndu doto na Samalɨa. ");
INSERT INTO mdm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Okpála koko bhende adʉ akpe Ebhe-e aku ’gbá Etieni naali. U aha kuo anɨ, u atsia anʉ azɨ. ");
INSERT INTO mdm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","La-a, Saulo aholo nato mbolo lɨ Piga gba Ebhe-e ngʉ́ nabhɵbhɵlɵ. Anɨ adʉ nalɨ bhʉ́ ’tɨ bini ne bini. Anɨ adʉ napandja omabhuka, olɨsɨ di ne obhosɨ, anɨ atsia adʉ namba uo bhʉ́ tɨkpʉ. ");
INSERT INTO mdm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Omabhuka ɨnde atsambala adʉ anʉ ne ndʉ bɨlɨ hana me u nde ne kpokpo Bádha Ngali . ");
INSERT INTO mdm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Abhomʉ-o, Filipo anʉ bhʉ́ sʉka gʉdhʉ bini na Samalɨa. Oo-o, anɨ atsia akpokpo ngali gba Masɨya-o . ");
INSERT INTO mdm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Okpála bhelé ne bua bini abhuka ’li Filipo. Padhá de, anga u adʉ adje ngali ongʉ́ na ngangamba ɨnde anɨ adʉ amene e-o. U atsia adʉ la di auu ne djila o. ");
INSERT INTO mdm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Osisiti bua bhelé aze bhʉ́ okpála. Osisiti bua ango-o adʉ aze me u nde ngatʉ ꞌue kpekpeke. Okpála bhelé ɨnde adʉ odʉkuto, di ne obhende adʉ ne eze lɨ ’dhʉ o-o, atsia akobho. ");
INSERT INTO mdm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Abhomʉ-o, djalɨ atsia adʉ naali bhʉ́ gʉdhʉ ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kpála bini adʉ nanɨ bhʉ́ gʉdhʉ ango-o, a adʉ ’lɨ anɨ me Simo. Nayie didili naali, anɨ adʉ amene ’ngʉ́ na mambengʉ mambengʉ. Ndʉ okpála hana na ndu doto na Samalɨa adʉ angamba ka anɨ naali. Anɨ atsia adʉ apa me nɨ ne ’ngbé kpála. ");
INSERT INTO mdm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ndʉ okpála hana adʉ aha lɨo ngʉ́ nadje anɨ, nayie lɨ okpála na padhá, akólo lɨ okpála na ngbengbengbe. U adʉ napa me: «Kpála ɨnde-e, a ko angu gba Ebhe, angu ɨnde u aꞌɨ e me ‹Angu na ngbéngbé.›» ");
INSERT INTO mdm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","U adʉ nakpata anɨ, anga nayie didili naali, ongʉ́ na mambengʉ gba anɨ-e adʉ angamba uo naali. ");
INSERT INTO mdm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Engʉ́ bini, lɨ Filipo adʉ akpokpo Bádha Ngali Naʉ gba Ebhe , di ne Yesu Kilisito lɨe pɨ uo-o, olɨsɨ ne obhosɨ abhuka. Pɨpɨta-a, u atsia asia batisimo. ");
INSERT INTO mdm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simo abhuka belegʉ di ngae, anɨ atsia asia batisimo. Anɨ dʉ matá nayie de Filipo de. Anɨ adʉ nangamba naali lɨ oehe di ne ongamba ’ngʉ́ na ngbengbengbe ɨnde lɨ Filipo adʉ namene e-o. ");
INSERT INTO mdm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Obhʉlʉ titima gba Yesu abhʉ́ gʉdhʉ na Yelusalema adje me okpála na ndu doto na Samalɨa asia eli gba Ebhe-o . Abhomʉ-o, u atima Piele di ne Djaa pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","U akolo lɨe bhʉ́ ndu doto na Samalɨa oo, u atsia ayo Ebhe pɨ uo ngʉbula me u sia Bu Bhobua . ");
INSERT INTO mdm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Padhá de, anga Bu Bhobua kɵ nga nanɨ pɨ́ sʉka uo bini de. U asia nga bha nanɨ batisimo ne ’lɨ Ngámá Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Abhomʉ-o, Piele ne Djaa aꞌo ’kpa o pɨ́ ’ndjɨ uo, u atsia asia Bu Bhobua. ");
INSERT INTO mdm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simo au me Bu Bhobua akɵ pɨ́ okpála ɨnde lɨ obhʉlʉ titima aꞌo ’kpa o pɨ́ ’ndjɨ o-o. Abhomʉ-o, anɨ ago ne tɨa me nɨ ngaha makiso pɨ Piele ne Djaa. ");
INSERT INTO mdm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Do anɨ de me: «Yi ha di angu ango-o mʉma, amba kpála bhende ma aꞌó ’kpa ma pɨ́ ’ndjɨ e, anɨ de sia Bu Bhobua.» ");
INSERT INTO mdm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Engʉ́ bini, Piele agie pɨ anɨ me: «Siti de bhaka bhado bha mʉ bhʉ́ dabɨlɨ bini ne tɨa gba mʉ-o! Padhá de, anga mo obhundja me mʉ tɨ da nakala ehe ɨnde lɨ Ebhe ngaha e padhá-a ne tɨa. ");
INSERT INTO mdm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndʉ ’ngʉ́ ɨnde ngakodho ’kpɨ́ ɨnde-e hana, a pɨ mʉ ade. Mʉ tɨ la di da nalɨ bhʉ́bhʉ́ de. Padhá de, anga bua mʉ kala Ebhe ngbingbili ade. ");
INSERT INTO mdm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","La-a, dji bua mʉ ka siti ’ngʉ́ ɨnde mo obhundja e lɨ bua mʉ ko. Yo ka Ngámá ngʉbula me, ɨ dʉ me anɨ nde akʉnda-a, anɨ de ꞌe siti ’ngʉ́ ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Padhá de, anga ma au me mo obedhe bhʉ́ mʉ ne gʉmʉ ’he. Mʉ la di bhʉ́ ’kpʉ́ gba siti.» ");
INSERT INTO mdm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Abhomʉ-o, Simo apa pɨ Piele ne Djaa me: «Ngayi makpe-e, yi yo mangbo Ngámá ngʉ́ ma ngayi, ngʉbula me ngua ’ngʉ́ yi apa e bhomʉ-o, akólo lɨ ma de.» ");
INSERT INTO mdm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pɨpɨta-a, Piele ne Djaa akpokpo ongʉ́ ɨnde lɨ Ngámá Yesu amene e lɨ djila uo-o. U asuno eli gba anɨ-e pɨ okpála. Abhomʉ-o, u atsia agie lɨo bhʉ́ Yelusalema. Lɨ kpadjɨ-e, u akpokpo Bádha Ngali bhʉ́ okʉtɨ bhelé na ndu doto na Samalɨa. ");
INSERT INTO mdm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pɨpɨta-a, andjelu bini gba Ngámá-a apa pɨ Filipo me: «Yie bhʉ́lá, amba mʉ kɵ lɨ pápá na yoyoko, lɨ kpadjɨ ɨnde ayie bhʉ́ gʉdhʉ na Yelusalema, atsia akɵ bhʉ́ Gadja ko. Kpadjɨ ango-o apʉ bhʉ́ mili bɨlɨ.» ");
INSERT INTO mdm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Abhomʉ-o, Filipo ayie bhʉ́lá, anɨ atsia aholo ne enʉ́ lɨ kpadjɨ ango-o. Lɨ kpadjɨ-e, bhoko bini akoto. A adʉ nanɨ eniki, ’ngbé kpála na doto na Etiopi. Anɨ adʉ nalila ndʉ tɨa hana gba Kandase, ngámá na ɵɵlɵ na Etiopi-o. Anɨ anʉ nanɨ bhʉ́ Yelusalema ngʉ́ nadhɵgɵ Ebhe, ");
INSERT INTO mdm_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","anɨ atsia adʉ nagie lɨe agba e. Anɨ adʉ kuto bhʉ́ kpulukpulu gba e-o. Anɨ atsia adʉ natanga bhuku gba polofeta Ɨsaya. ");
INSERT INTO mdm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bu Bhobua apa pɨ Filipo me: «Nʉ de kpulukpulu bhomʉ, amba yi nʉ ne bhʉbhʉlʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo anʉ bhʉ́ holo, anɨ atsia adje kpála na Etiopi bhomʉ-o ngatanga bhʉ́ bhuku gba polofeta Ɨsaya. Abhomʉ-o, Filipo ayi anɨ me: «Engʉ́ ɨnde mʉ ngatanga e bhomʉ-o, mʉ ngadje tata-a uu?» ");
INSERT INTO mdm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kpála ango-o agie me: «Ma ambɨ́la la tata-a lele pɨ, ɨ dʉ me kpála nde kpokpo kúkú mʉma de-e?» Abhomʉ-o, anɨ aꞌɨ Filipo me anɨ ꞌʉ bhʉ́ kpulukpulu-o, amba anɨ dʉ de nɨ. ");
INSERT INTO mdm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Eli ɨnde anɨ adʉ atanga e bhʉ́ bhuku gba Ɨsaya ngae ɨnde: «U adʉ nanʉ ne anɨ maka kandɵlɵ ɨnde u adji nabhɵlɵ e, maka ndɨlɨ kandɵlɵ ɨnde agbite ’bhɵ e lɨ nedhɨnga u ngaka su anɨ lɨe-o. Anɨ ꞌʉ ’bhɵ e de. ");
INSERT INTO mdm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","U akɵ anɨ ne kuto, u kodho ’ngʉ́ gba nɨ-e ngbingbili de. A ko da ɨnde ɨ tɨ da napa ’ngʉ́ gba ongɨsɨ gba anɨ-e? Padhá de, anga u aꞌe mʉkobho gba anɨ-e pɨ́la doto aꞌe.» ");
INSERT INTO mdm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bhoko na Etiopi ango-o ayi Filipo me: «Ma ayo ka mʉ me pa nga mʉma: polofeta ngapa ’ngʉ́ bhomʉ-o lɨ da? Ne me anɨ ngapapa lɨ e, ne me anɨ ngapapa lɨ kpála koko?» ");
INSERT INTO mdm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Abhomʉ-o, Filipo aholo naꞌoꞌo tata pɨ anɨ lɨ Bádha Ngali gba Yesu-o nayie lɨ Eli ɨnde anɨ adʉ atanga e-o. ");
INSERT INTO mdm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","U adʉ anʉ lɨe lɨ kpadjɨ-e, u akolo lɨ bɨlɨ bini, adʉ oo ne engu. Abhomʉ-o, ’ngbé kpála ango-o apa pɨ Filipo me: «Tsia nga engu ɨɨ! Nasia batisimo ka ma-a, a adha mbɨa ɨnde-e lɨ nɨ?»  ");
INSERT INTO mdm_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo atsia apa pɨ anɨ me: «Ɨ dʉ me mʉ nde abhuka ne bua mʉ hana-a, mʉ tɨ da nasia batisimo.» Kpála ango-o agie pɨ anɨ me: «Ma abhuka me Yesu Kilisito ne Ndɨlɨ gba Ebhe.» ");
INSERT INTO mdm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Abhomʉ-o, anɨ atsia apa me kpulukpulu-o lʉlʉ. Pɨpɨta-a, ndʉ uo bhisi hana, Filipo ne kpála ango-o, akɵ bhʉ́ ’ngu. Filipo atsia abatisa anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lɨ u aze lɨe bhʉ́ ’ngu-o me-e, Bua gba Ngámá-a atsia adhepe Filipo. Kpála na Etiopi u matá anɨ de. Kpála na Etiopi ango-o aholo bha ɨbili enʉ́ kpi e kpi me anɨ nde ngakpi djalɨ. ");
INSERT INTO mdm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","La pɨ Filipo-o, u anʉ au bha ɨbili anɨ bhʉ́ gʉdhʉ na Adjota. Pɨpɨta-a, anɨ apʉ bhʉ́ ndʉ ogʉdhʉ hana me anɨ nde ngakpokpo Bádha Ngali akólo bha bini lɨ nedhɨnga anɨ akolo lɨe bhʉ́ Sedjale ko. ");
INSERT INTO mdm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lɨ nedhɨnga bhomʉ-o, Saulo adʉ nagɨlɨ omʉkpata gba Ngámá Yesu ngʉ́ nabhili uo. Ekpɨ́ koko anɨ anʉ nabhaka bhele kpála gba odimandɵ gba Ebhe-o . ");
INSERT INTO mdm_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Anɨ anʉ nayo balʉa me nɨ nʉ ne di ngʉ́ nalɨ bhʉ́ otɨ nadje lɨ́lɨ gba Moidje ɨnde bhʉ́ gʉdhʉ na Damasɨ. Nɨ nʉ oo, amba ɨ dʉ me nɨ nde abhaka okpála ɨnde ngakpata ’ngʉ́ gba Yesu-o, obhosɨ di ne olɨsɨ, nɨ de holo uo, amba nɨ nʉ ne uo bhʉ́ gʉdhʉ na Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nedhɨnga anɨ adʉ anʉ lɨe, anɨ akolo lɨe de Damasɨ masɨkpe-e, má gala kolo me-e, zɨ ’kpɨ́ bini ayie abhʉ́lá, a ago asa ngo anɨ ngbalina. ");
INSERT INTO mdm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Anɨ atsokodho atɨ kuto má ngbi! Anɨ atsia adje eli bini apa pɨ anɨ me: «Saulo, Saulo, mʉ ngato mbolo lɨ ma ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Abhomʉ-o, Saulo atsia ayi me: «Ngámá, a ko mʉ da?» Eli atsia akoto matá pɨ anɨ me: «A ko ma Yesu, mʉ ngato mbolo e lɨ ma. ");
INSERT INTO mdm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","La-a, yie bhʉ́lá yiyie, amba mʉ nʉ bhʉ́ gʉdhʉ. Engʉ́ ɨnde ayo me mʉ mene e-e, u apá pɨ mʉ oo ko.» ");
INSERT INTO mdm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Okpála ɨnde adʉ anʉ ne anɨ bhʉ́ dabɨlɨ bini-e alʉlʉ. Bhʉ́ ’bhɵ uo akpina má ndje ka tsʉlʉ. U adʉ adje eli, engʉ́ bini, u dʉ au kpála ɨnde adʉ agama ’ngʉ́-o de. ");
INSERT INTO mdm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Abhomʉ-o, Saulo ayie bhʉ́lá, anɨ abhulu djila e, engʉ́ bini, anɨ u la ’kpɨ́ de. U atsia aholo ’kpa anɨ ngʉ́ nanʉ ne anɨ bhʉ́ Damasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oo, anɨ amene ngbolo ’kpɨ́ bata. Anɨ u ’kpɨ́ de, anɨ zʉ ’he de, anɨ ndjɨ la di ehe nandjɨ mandjɨ de. ");
INSERT INTO mdm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mʉkpata bini adʉ bhʉ́ Damasɨ oo, a adʉ ’lɨ anɨ me Ananɨa. Ngámá aꞌɨ anɨ bhʉ́ ehe maka loto me: «Ananɨa!» Ananɨa atsia abhuka me: «Ma ɨɨ, Ngámá!» ");
INSERT INTO mdm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Abhomʉ-o, Ngámá atsia apa pɨ anɨ me: «Mbɨa ɨnde-e, a ayo me mʉ nʉ lɨ kpadjɨ ɨnde u aꞌɨ e me Ngbili kpadjɨ bhʉ́ ’tɨ gba kpála bini ɨnde u aꞌɨ e me Yuda. Yi Saulo, kpála na gʉdhʉ na Talasɨ. Lɨ nedhɨnga ɨnde-e, anɨ ngayo Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Anɨ atsia au bhʉ́ ’he maka loto kpála bini, ɨnde ’lɨ e me Ananɨa, alɨ bhʉ́ ’tɨ nganda nɨ. Kpála ango-o atsia aꞌo ’kpa e pɨ́ ’ndjɨ anɨ ngʉ́ napa me anɨ u matá ’kpɨ́.» ");
INSERT INTO mdm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananɨa atsia agie me: «Ngámá, okpála bhelé apa ’ngʉ́ mʉma pɨndjɨ bhoko bhomʉ. Ma mbɨla la di ndʉ siti ’ngʉ́ hana ɨnde anɨ amene e lɨ kʉte okpála na bububu gba mʉ bhʉ́ Yelusalema-o. ");
INSERT INTO mdm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ongbengbe odimandɵ aha la di kpadjɨ pɨ anɨ me anɨ go ei ngʉ́ naholo ndʉ okpála hana ɨnde ngabhuka mʉ-o.» ");
INSERT INTO mdm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Engʉ́ bini, Ngámá apa pɨ anɨ me: «Nʉnʉ, anga bhoko bhomʉ-o, ma abhʉ anɨ ngʉ́ kulu gba ma-o. Anɨ anʉ́ nakpokpo engʉ́ gba ma-a pɨ opiga ɨnde ɨ mbɨla ma de, pɨ ongbengbe ongámásɨ gba uo, di ne pɨ omaƗsalaele. ");
INSERT INTO mdm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma asúno pɨ anɨ, ngama makpe, ndʉ lɨkabhu hana ɨnde a ayo me anɨ zʉ e kabula ’lɨ ma-o.» ");
INSERT INTO mdm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Abhomʉ-o, Ananɨa anʉ, anɨ alɨ bhʉ́ ’tɨ oo, anɨ abhaka Saulo, anɨ aꞌo ’kpa e pɨ́ anɨ. Anɨ atsia apa me: «Ndai ma Saulo, Ngámá atima ma ngae. A ko Yesu ɨnde akoto lɨ mʉ lɨ kpadjɨ nedhɨnga mo odʉ nago lɨe-o. Anɨ atima ma, ngʉbula me mʉ u matá ’kpɨ́, amba mʉ bedhe di ne Bu Bhobua .» ");
INSERT INTO mdm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kolo má gala me-e, ehe maka kʉdhʉ ’he ayie bhʉ́ djila Saulo, abala kuto. Anɨ atsia aholo nau matá ’kpɨ́. Abhomʉ-o, anɨ ayie bhʉ́lá, anɨ atsia asia batisimo. ");
INSERT INTO mdm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pɨpɨta-a, anɨ azʉ ’he, anɨ atsia asia angu. Saulo amene mbo ekpɨ́ bhʉ́ dabɨlɨ bini ne omʉkpata na Damasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kolo má gala me-e, anɨ aholo nakpokpo pɨ omaYuda bhʉ́ oetɨ nadje lɨ́lɨ gba Moidje me Yesu ne Ndɨlɨ gba Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndʉ okpála hana ɨnde adʉ nadje anɨ-e adʉ angamba naali. U adʉ nayi me: «A ɨnde-e bhʉlʉ nato mbolo lɨ okpála ɨnde ngabhuka Yesu abhʉ́ gʉdhʉ na Yelusalema dɨ? Anɨ go nako e ngʉ́ naholo uo, di ne nanʉ ne uo pɨ ongbengbe odimandɵ gba Ebhe dɨ?» ");
INSERT INTO mdm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Engʉ́ bini, Saulo adʉ akolo ne angu bhʉ́ nasuno. Anɨ adʉ asuno mbámbá pɨ omaYuda na Damasɨ me Yesu ne Masɨya . Kaka-a, u dʉ nambɨla matá engʉ́ ɨnde u agíe e pɨ anɨ-e de. ");
INSERT INTO mdm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pɨta ekpɨ́ bhelé, omaYuda adje lɨo me o bhɵlɵ Saulo. ");
INSERT INTO mdm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Engʉ́ bini, Saulo ambɨla siti mabhundja gba uo-o. U atsia adʉ di nalila obhotɨ na gʉdhʉ-o sukpe ne ngbɨkpɨ ngʉbula nato anɨ, amba o bhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sukpe bini-e, ngaanɨ ne omʉkpata gba e, u anʉ lɨ malilisa na aga na gʉdhʉ-o. U ato anɨ bhʉ́ kíli, u atsia akɵ anɨ ne di kuto akilidjo. ");
INSERT INTO mdm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Lɨ Saulo akolo lɨe bhʉ́ Yelusalema-a, anɨ adʉ nale nagbite lɨe lɨ omʉkpata, engʉ́ bini, ndʉ uo hana adʉ nadje tsʉlʉ. Padhá de, anga u dʉ nabhuka de me a ko ndjʉ kʉkʉlʉ mʉkpata-a de. ");
INSERT INTO mdm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","La-a, Balanabasɨ anʉ aha Saulo, anɨ atsia anʉ ne anɨ pɨ obhʉlʉ titima gba Yesu-o . Oo, Balanabasɨ akpokpo pɨ uo maka lɨ Saulo au Ngámá Yesu lɨe lɨ kpadjɨ, di ne maka lɨ Ngámá agama ’ngʉ́ lɨe pɨ anɨ-o. Anɨ atsia akpokpo di maka lɨ Saulo dʉ nasuno ’ngʉ́ lɨe ne tsʉlʉ de ne ’lɨ Yesu bhʉ́ Damasɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Abhomʉ-o, obhʉlʉ titima atsia azɨba Saulo. Nayie lɨ nedhɨnga bhomʉ-o, Saulo dʉ matá naꞌo ká obhʉlʉ titima-a de. U adʉ adhʉkʉ bhʉ́ Yelusalema bhʉ́ dabɨlɨ bini. Anɨ tsia dʉ nasuno ne ’lɨ Yesu ne tsʉlʉ de. ");
INSERT INTO mdm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Anɨ adʉ di nasuno pɨ omaYuda ɨnde adʉ nadi eli na giliki-o, anɨ atsia adʉ namene kpekebhɵ ne uo. Engʉ́ bini, ngauo-o, u adʉ agɨlɨ nabhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lɨ ondaise Saulo, omabhuka adje lɨe, u anʉ naꞌo Saulo bhʉ́ Sedjale. Oo, u atsia atima anɨ bhʉ́ Talasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Abhomʉ-o, omabhuka bhʉ́ ndu doto na Yudaya, bhʉ́ ndu doto na Galilaya, di ne bhʉ́ ndu doto na Samalɨa libhomu adʉ bhʉ́ guo ’ngʉ́ . U adʉ akolo kpekpeke bhʉ́ nabhuka. U adʉ amanga Ngámá mamanga. U atsia adʉ nabe ndʉ o, ka angu gba Bu Bhobua. ");
INSERT INTO mdm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piele adʉ napʉ ne ndʉ bɨlɨ hana. Abhomʉ-o, ekpɨ́ bini, anɨ anʉ natsia omabhuka ɨnde adʉ bhʉ́ gʉdhʉ na Lida-o. ");
INSERT INTO mdm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Oo-o, anɨ abhaka bhoko bini, a adʉ ’lɨ anɨ me Ene. Sʉnda kalanga madjɨna, anɨ adʉ me anɨ nde asɨ kuto pɨ́ kalagba gba e-o. Padhá de, anga adʉ nanɨ dʉkuto. ");
INSERT INTO mdm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Lɨ Piele au anɨ lɨe, anɨ atsia apa pɨ anɨ me: «Ene, Yesu Kilisito akobho mʉ mbɨa ɨnde akobho! Yie bhʉ́lá, amba mʉ leke dabɨlɨ gba mʉ-o, ngamʉ makpe.» Kolo má gala me-e, Ene ayie bhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndʉ okpála hana na Lida, di ne egʉ na Salona au lɨe mo-o, u adji bua o, u atsia abhuka Ngámá ");
INSERT INTO mdm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lɨ nedhɨnga bhomʉ-o, mʉkpata bini na ɵɵlɵ adʉ nanɨ bhʉ́ gʉdhʉ na Djope, a adʉ ’lɨ anɨ me Tabita (bhʉ́ eli gba oGiliki-e me «Dolokasɨ», a akʉnda napa me «gbelende»). Anɨ adʉ amene obabadha ’ngʉ́, anɨ atsia adʉ ateteke di obhʉlʉ ndɨbhɨlɨ ndʉ ’kpɨ́ hana. ");
INSERT INTO mdm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ekpɨ́ bini, anɨ asɨ kuo, anɨ atsia akpi. U avʉlʉ kʉte kuo anɨ, u atsia aꞌo bhʉ́ tɨna ’tɨ bini abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gʉdhʉ na Lida masɨkpe de gʉdhʉ na Djope. Kaka-a, lɨ omʉkpata adje lɨe me Piele bhʉ́ Lida-a, u atsia atima okpála bhisi ngʉ́ napa pɨ anɨ me: «Kikiliako, ya ayo ka mʉ me go nga gba ya ei má gala!» ");
INSERT INTO mdm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piele ayie bhʉ́lá kolo má gala, anɨ atsia anʉ bhʉ́ dabɨlɨ bini ne okpála ɨnde u atima o-o. Anɨ akolo lɨe oo-o, u anʉ naꞌo anɨ bhʉ́ tɨna ’tɨ ɨnde abhʉ́lá-o. Ndʉ oɵkɵsɨ hana na gʉdhʉ ango-o ago de Piele me u nde ngaku ’gbá. U adʉ asuno obongo na mbulu, di ne okoti ɨnde lɨ Tabita adʉ amene e nedhɨnga anɨ adʉ lɨe bhʉ́ mʉkobho-o pɨ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piele apandja ndʉ okpála hana kilidjo, anɨ akikita lɨpʉkʉ e kuto, anɨ atsia ayo Ebhe. Pɨpɨta-a, anɨ adji bhʉ́la e ne apɨ́ kuo-o, anɨ atsia apa me: «Tabita, yie bhʉ́lá!» Abhomʉ-o, Tabita aꞌʉ djila e. Lɨ anɨ au Piele lɨe, anɨ atsia adʉ madʉ. ");
INSERT INTO mdm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piele aholo ’kpa anɨ, anɨ atsia aꞌe anɨ bhʉ́lá. Pɨpɨta-a, Piele aꞌɨ omabhuka koko di ne oɵkɵsɨ na olɨsɨlɨsɨ, anɨ atsia asuno anɨ pɨ uo me anɨ nde ʉʉ. ");
INSERT INTO mdm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ndʉ okpála hana na Djope adje engʉ́ ɨnde akodho ’kpɨ́-o. Abhomʉ-o, okpála bhelé atsia abhuka Ngámá. ");
INSERT INTO mdm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piele amene bhʉ́ Djope ekpɨ́ bhelé. Anɨ adʉ nadʉ gba kpála bini ɨnde lɨ ’lɨ e adʉ me Simo. Kpála ango-o adʉ namene kulu na kó ’nʉ. ");
INSERT INTO mdm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kpála bini adʉ nanɨ bhʉ́ gʉdhʉ na Sedjale, a adʉ ’lɨ anɨ me Koloneli. Anɨ adʉ ngámá pɨ́ ’ndjɨ osʉdha kámá bini. Libi osʉdha ango-o ɨnde u aꞌɨ e bhʉ́ dabɨlɨ bini ne osʉdha koko-o me «Libi osʉdha na Itali.» ");
INSERT INTO mdm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kpála ango-o adʉ amanga Ebhe di ne nakpe Ebhe bhʉ́ dabɨlɨ bini ne piga gba e libhomu. Anɨ adʉ ateteke obhʉlʉ ndɨbhɨlɨ ɨnde adʉ bhʉ́ ká omaYuda-a naali. Anɨ atsia adʉ ayo Ebhe pɨko. ");
INSERT INTO mdm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ekpɨ́ bini, masɨkpe de saa na bata pɨta tulukpe-e, anɨ au mbámbá bhʉ́ ’he maka loto me andjelu bini gba Ebhe-e nde ngalɨ agba anɨ. Andjelu ango-o aꞌɨ anɨ me: «Koloneli!» ");
INSERT INTO mdm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Anɨ atsia andjelu ango-o ne tsʉlʉ hana. Anɨ atsia apa pɨ anɨ me: «A ko mangua ’ngʉ́ dho, Ngámá?» Andjelu-o agie pɨ anɨ me: «Ebhe adje nayo gba mʉ-o adje. Anɨ azɨba di oehe ɨnde mʉ ngaha e pɨ obhʉlʉ ndɨbhɨlɨ-o. Kaka-a, ’to anɨ ꞌɨlɨ lɨ mʉ de. ");
INSERT INTO mdm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mbɨa ɨnde-e, tima okpála bhʉ́ Djope ngʉbula naꞌɨ kpála bini ɨnde u agisila ’lɨ e me Simo Piele-o. ");
INSERT INTO mdm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Anɨ ngasɨ agba kpála bini ɨnde ’lɨ e me Simo, kpála namene kulu na kó ’nʉ. Kʉtɨ gba anɨ-e a de ’ngbé ’ngu.» ");
INSERT INTO mdm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pɨpɨta-a, andjelu ɨnde agama ’ngʉ́ pɨ anɨ-e atapa. Abhomʉ-o, Koloneli atsia aꞌɨ okpála na kulu gba e bhisi, di ne sʉdha bini. Sʉdha ango-o adʉ kpála nakpe Ebhe. Anɨ atsia asɨ di nanɨ bhʉ́ kulu gba anɨ-e naali. ");
INSERT INTO mdm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Koloneli akpokpo ndʉ ’ngʉ́ ɨnde akodho ’kpɨ́-e hana pɨ uo. Pɨpɨta-a, anɨ atsia atima uo bhʉ́ Djope. Abhomʉ-o, u atsia agbida. ");
INSERT INTO mdm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lɨ ekpɨ́ aseke lɨe, okpála u atima o-o adʉ nga bha lɨe lɨ kpadjɨ-e, u akolo de gʉdhʉ na Djope. A abhaka me Piele nde aꞌʉ apɨ́ ’ngbʉ ’tɨ ngʉ́ nayo Ebhe masɨkpe de tulukpe. ");
INSERT INTO mdm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","La-a, gʉmʉ aholo amene anɨ, anɨ adʉ akʉnda nazʉ ’he. Nedhɨnga u adʉ alʉ ’zʉ-o lɨe pɨ anɨ-e, anɨ atsia au engʉ́ maka loto. ");
INSERT INTO mdm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Anɨ au kokpɨ́ abhulu lɨe. Anɨ au ehe bini maka ’ngbé ’kpá bongo . U ahoholo lɨ odjedje badha. A ayie abhʉ́lá, atsia adʉ akɵ kuto. ");
INSERT INTO mdm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bhʉ́ ’ngbé ’kpá bongo ango-o, ndʉ djua onʉ hana na ’dhʉ badha, ne ndʉ djua onʉ ɨnde ngagbele lɨo ne ’bu o kuto, di ne ndʉ djua odhu hana adʉ bhʉ́bhʉ́. ");
INSERT INTO mdm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Abhomʉ-o, anɨ adje eli bini ɨnde apa pɨ anɨ me: «Piele, yie bhʉ́lá! Bhɵbhɵlɵ, amba mʉ zʉ!» ");
INSERT INTO mdm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Engʉ́ bini, Piele agie me: «A mo-o ade, Ngámá! Padhá de, anga ma zʉ nga ezʉ ɨnde lɨ lɨ́lɨ gba Moidje ayala e, di ne bhende na sisiti kala Ebhe belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Anɨ adje matá eli ango-o bhʉtsibhʉtsi na bhisi-e me: «Ehe ɨnde lɨ Ebhe adji e akolo bubu-o, mo opá de me a sisiti-e de.» ");
INSERT INTO mdm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Engʉ́ ango-o amene lɨe bhʉtsibhʉtsi bata. Pɨpɨta-a, má gala kolo me-e, bongo ango-o atsia agie lɨe abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Abhomʉ-o, mabhundja gba Piele atsia angbɨngɨ ka engʉ́ ɨnde anɨ au e-o. Anɨ adʉ ayi bua e me: «Tata-a pɨ?» Bha lɨ nedhɨnga lɨ Piele adʉ ayi bua e lɨe bhomʉ-o, okpála ɨnde lɨ Koloneli atima o akolo lɨ bhotɨ gba Simo-o. A adʉ me u nde ayi okpála me etɨ gba Simo-o su. ");
INSERT INTO mdm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","U aꞌɨ kpála bini, u atsia ayi anɨ me: «A ɨnde-e bɨlɨ lɨ Simo u agisila ’lɨ e me Piele asɨsɨ lɨe?» ");
INSERT INTO mdm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lɨ nedhɨnga bhomʉ-o, Piele adʉ nga bha nabhundja pɨndjɨ engʉ́ ɨnde anɨ au e-o. Abhomʉ-o, Bu Bhobua atsia apa pɨ anɨ me: «Tsitsia nga, okpála bata ngagɨlɨ mʉ. ");
INSERT INTO mdm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yie bhʉ́lá, kɵ akuto, amba yi nʉ bhʉ́ dabɨlɨ bini ne uo. Mo odjídji lɨmʉ de. Padhá de, anga ma atima uo ngama.» ");
INSERT INTO mdm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Abhomʉ-o, Piele akɵ, anɨ abhaka okpála ango-o. Do anɨ pɨ uo me: «Kpála ɨnde yi ngagɨlɨ e-e, a ko ma. Yi ago la ngʉ́ nɨ?» ");
INSERT INTO mdm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","U agie pɨ anɨ me: «Ngámá gba osʉdha, ɨnde ’lɨ e me Koloneli-e atima ya ngae. A ko kpála na ngbingbili , ɨnde di ngadhɵgɵ Ebhe. Ndʉ omaYuda hana ngapa ’ngʉ́ gba anɨ-e ndjɨndjɨ. Andjelu bini gba Ebhe-e akoto lɨ anɨ, anɨ atsia apa pɨ anɨ me: ‹Tima okpála ngʉ́ naꞌɨ Piele, amba mʉ dje engʉ́ ɨnde anɨ akpókpo e pɨ mʉ ko.›» ");
INSERT INTO mdm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Abhomʉ-o, Piele ato okpála ango-o abhʉ́ ’tɨ. Anɨ atsia asuno dabɨlɨ u asɨ lɨe pɨ uo. U atsia asɨ tété. Lɨ ekpɨ́ aseke lɨe, Piele anʉ bhʉ́ dabɨlɨ bini ne uo. Abhomʉ-o, omabhuka koko na Djope atsia anʉ naꞌo Piele. ");
INSERT INTO mdm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pɨta ’kpɨ́ bini-e, u atsia akolo bhʉ́ Sedjale. A abhaka me Koloneli nde apo bhʉ́la omaha e di ne obɨ e na mʉkʉnda. Anɨ atsia adʉ adjeke uo oo. ");
INSERT INTO mdm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lɨ Piele akolo lɨe, Koloneli ago nakɵ lɨo ne anɨ. Anɨ atɨ bhʉ́ lɨ ’dhʉ anɨ. Anɨ atsia atʉ bhʉ́la e ne kuto ngʉ́ namanga anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Engʉ́ bini, Piele aꞌe anɨ bhʉ́lá. Anɨ atsia apa pɨ anɨ me: «Lʉ malʉ! Padhá de, anga ngama-a, ma bhadi ne kpála na padhá!» ");
INSERT INTO mdm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Anɨ adʉ agama ’ngʉ́ lɨe ne Koloneli-e, anɨ atsia alɨ abhʉ́ ’tɨ. Oo-o, anɨ abhaka me bhiti okpála nde apo bhʉ́la o. ");
INSERT INTO mdm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Anɨ apa pɨ uo me: «Yi ambɨla ndjɨndjɨ me lɨ́lɨ zɨba de me maYuda bini dʉ bhʉ́ dabɨlɨ bini ne gandji kpála-a de. A zɨba la di de me anɨ nʉ agba anɨ-e de. Engʉ́ bini, ngama-a, Ebhe asuno mʉma me ma aꞌɨ́ kpála bini de me a ko kpála na sisiti kala Ebhe-e de. ");
INSERT INTO mdm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kaka-a, mo oꞌɨ ma lɨe, ma yala de. Mbɨa ɨnde-e, ma akʉnda nambɨla ta ’ngʉ́ ɨnde mo oꞌɨ ma ngʉ́ e-o.» ");
INSERT INTO mdm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Abhomʉ-o, Koloneli agie pɨ anɨ me: «A ane nga ekpɨ́ bata, masɨkpe de lɨ ngua nedhɨnga ɨnde, bhʉ́ saa na bata pɨta tulukpe, ma adʉ nayo Ebhe bhʉ́ ’tɨ gba ma-o. Kolo me-e, kpála bini alʉ kala ma. Anɨ adyɨ bongo ɨnde adʉ lɨ e ne zɨzɨ. ");
INSERT INTO mdm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Anɨ atsia apa mʉma me: ‹Koloneli, Ebhe adje nayo gba mʉ-o adje. Anɨ atsia abhundja di maka mʉ ngateteke obhʉlʉ ndɨbhɨlɨ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mbɨa ɨnde-e, tima okpála bhʉ́ Djope ngʉ́ naꞌɨ Simo ɨnde u agisila ’lɨ e me Piele. Anɨ ngadʉ gba Simo, ɨnde adʉdʉ dengo ’ngbé ’ngu, kpála namene kulu na kó ’nʉ.› ");
INSERT INTO mdm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Abhomʉ-o, ma atima bha kolo okpála ngʉ́ naꞌɨ mʉ má gala! Heni naali! A ndjɨndjɨ maka mo ogo lɨe-o. Mbɨa ɨnde-e, ndʉ nɨ́ hana nɨ́ kala Ebhe sɨ ngʉ́ nadje ndʉ ’ngʉ́ hana ɨnde lɨ Ngámá akpokpo e pɨ mʉ me mʉ pa e pɨ ya-o.» ");
INSERT INTO mdm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Abhomʉ-o, Piele aholo nakpokpo me: «Mbɨa ɨnde-e, ma ambɨla ndjɨndjɨ me Ebhe gbogbo bhʉsʉ okpála de. ");
INSERT INTO mdm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Engʉ́ bini, bhʉ́ ká ndʉ opiga hana, kpála ɨnde ngamanga Ebhe, ɨnde di ngamene engʉ́ na ngbingbili-e, kpála ango-o bhʉ́ djila Ebhe ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yi mbɨla ndjɨndjɨ me Ebhe atima eli gba e pɨ omaƗsalaele. A ko Bádha Ngali na guo ’ngʉ́ ɨnde nɨ́ asia e ka Yesu Kilisito-o . Ngaanɨ-e, a ko Ngámá gba ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yi mbɨla ndʉ ’ngʉ́ hana ɨnde akodho ’kpɨ́ nayie bhʉ́ ndu doto na Galilaya, akolo bhʉ́ ndu doto na Yudaya libhomu, pɨta lɨ Djaa akpokpo eli gba Ebhe , di ne nabatisa okpála lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yi mbɨla hana me Ebhe abhʉ nanɨ Yesu, kpála na Nadjaleta-a kalanʉ. Anɨ atsia aha Bu Bhobua di ne angu pɨ anɨ ngʉ́ namene kulu gba e-o. Anɨ apʉ ne ndʉ bɨlɨ hana me anɨ nde ngamene bádha ’ngʉ́. Anɨ atsia adʉ di nakobho ndʉ okpála hana ɨnde lɨ Djabʉlʉ agbigbite o-o. Padhá de, anga Ebhe adʉ bhʉ́ dabɨlɨ bini ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ngaya makpe, obhʉlʉ titima gba Yesu-o , ya au ndʉ ’ngʉ́ hana ɨnde anɨ amene e bhʉ́ kʉtɨ gba omaYuda di ne bhʉ́ Yelusalema ne djila ya. U abhɵlɵ anɨ me u nde agɨ anɨ lɨ kulusi. ");
INSERT INTO mdm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Engʉ́ bini, Ebhe azuku anɨ bhʉ́ ’kpɨ́ na bata. Anɨ aha angu pɨ anɨ ngʉ́ napana lɨe pɨ okpála me nɨ ʉʉ. ");
INSERT INTO mdm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Anɨ pana lɨe pɨ ndʉ okpála hana de. Engʉ́ bini, anɨ apana bha lɨe pɨ ya okpála ɨnde lɨ Ebhe abhʉ o kalanʉ, ɨnde au ’ngʉ́ ango-o ne djila o-o. Pɨta anɨ azuku lɨe, ya azʉ ’he, ya atsia andjɨ di ehe bhe nandjɨ mandjɨ ne uo bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Abhomʉ-o, anɨ atsia atima ya me ya nʉ ne kpokpo Bádha Ngali pɨ okpála. Anɨ atima ya me ya apa pɨ okpála me, a ko kpála ɨnde lɨ Ebhe aꞌo e ngʉ́ nakodho ’ngʉ́ gba okpála ɨnde ʉʉ di ne okpála bhende amu-o. ");
INSERT INTO mdm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ndʉ opolofeta hana akpokpo ’ngʉ́ gba anɨ-o. U akpokpo me kpála ne kpála ɨnde abhuka Yesu-o, Ebhe aꞌé siti ’ngʉ́ gba anɨ-e ka Yesu.» ");
INSERT INTO mdm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bha lɨ nedhɨnga lɨ Piele adʉ akpokpo ’ngʉ́ bhomʉ-o lɨe, Bu Bhobua atsia akɵ pɨ́ ndʉ okpála hana ɨnde adʉ adje anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","OmaYuda koko ɨnde abhuka Yesu-o, ago bhʉ́ dabɨlɨ bini ne Piele. U angamba naali, anga u au me Ebhe atuko di Bu Bhobua pɨ́ ogandji okpála. ");
INSERT INTO mdm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Padhá de, anga u adʉ adje uo ngagama ’ngʉ́ bhʉ́ odikongʉ koko. U adʉ adhɵgɵ Ebhe maka anɨ nde lɨe ngbéngbé-o. Abhomʉ-o, Piele atsia apa me: ");
INSERT INTO mdm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Mbɨa ɨnde-e, lɨ okpála ɨnde asia di Bu Bhobua lɨe maka nɨ́-e, kpála bini tɨ da nayoko me u abátisa uo ne engu dɨ?» ");
INSERT INTO mdm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Anɨ aha lɨ́lɨ me u batisa uo ne ’lɨ Yesu Kilisito. Abhomʉ-o, u atsia ayo ka anɨ me anɨ dʉ nga mbo ne o ngʉbula mbo ’kpɨ́ bedɨ. ");
INSERT INTO mdm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Obhʉlʉ titima gba Yesu , di ne omabhuka ɨnde bhʉ́ ndu doto na Yudaya-a, adje me ogandji okpála asia di eli gba Ebhe , u atsia abhuka Yesu Kilisito . ");
INSERT INTO mdm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lɨ Piele agie lɨe lɨe bhʉ́ gʉdhʉ na Yelusalema-a, omaYuda ɨnde abhuka aholo namene kpekebhɵ ne anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","U adʉ apa me: «Lele pɨ ngamʉ kpála ɨnde alɨ gandja mo olɨ lɨe bhʉ́ ’tɨ gba okpála ɨnde ɨ lɨ gandja de-e, mo otsia azʉ belegʉ di ’he ne uo bhʉ́ dabɨlɨ bini-e?» ");
INSERT INTO mdm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Abhomʉ-o, Piele atsia aholo akpokpo kúkú pɨ uo nayie lɨ lilita. Anɨ pɨ uo me: ");
INSERT INTO mdm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ngama-a, ma adʉ bhʉ́ gʉdhʉ na Djope. Nedhɨnga ma adʉ ayo Ebhe lɨe, ma au engʉ́ maka loto. Ehe bini ayie abhʉ́lá maka ’ngbé ’kpá bongo . U ahoholo lɨ odjedje badha. A ayie abhʉ́lá, atsia akɵ kuto lɨ bɨlɨ ma adʉ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ma atsia ’kpɨ́ bhʉ́bhʉ́ ne kpéke djila. Ma au onʉ na kʉtɨ, ma au onʉ na bɨlɨ, ma au onʉ bhende ngagbele lɨo ne ’bu o kuto di ne odhu. ");
INSERT INTO mdm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma atsia adje di eli bini ɨnde apa mʉma me: ‹Piele, yie bhʉ́lá! Bhɵbhɵlɵ amba mʉ zʉ!› ");
INSERT INTO mdm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Abhomʉ-o, ma atsia apa me: ‹A mo-o ade, Ngámá! Padhá de, anga ezʉ ɨnde lɨ lɨ́lɨ gba Moidje zɨba e de-e, di ne bhende na sisiti kala Ebhe lɨ nga bhʉ́ ’bhɵ ma belegʉ de bini.› ");
INSERT INTO mdm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Bhʉtsibhʉtsi na bhisi, ma adje matá eli ayie abhʉ́lá, a apa mʉma me: ‹Ehe ɨnde lɨ Ebhe apa lɨ e me a bubu-o, mo opá de me a sisiti-e de.› ");
INSERT INTO mdm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Engʉ́ ango-o, amene lɨe bhʉtsibhʉtsi bata. Pɨpɨta-a, bongo ango-o ne ndʉ ’he ɨnde bhʉ́bhʉ́-o hana atsia agie lɨe abhʉ́lá. ");
INSERT INTO mdm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bha lɨ nedhɨnga bhomʉ-o, obhosɨ bata akolo lɨ bɨlɨ ɨnde ya adʉ lɨ e-o. Kpála bini na gʉdhʉ na Sedjale atima uo me u go bhaka ma. ");
INSERT INTO mdm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Abhomʉ-o, Bu Bhobua apa mʉma me: ‹Nʉ bhʉ́ dabɨlɨ bini ne uo, mo opá de me a ko ogandji okpála-a de.› Ondaise ma madhɨa ɨnde-e atsia anʉ bhʉ́ dabɨlɨ bini ne ma. Ndʉ ya hana, ya alɨ bhʉ́ ’tɨ gba kpála ɨnde aꞌɨ ya-o. ");
INSERT INTO mdm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Abhomʉ-o, anɨ akpokpo pɨ ya maka lɨ andjelu akoto lɨ anɨ lɨe abhʉ́ ’tɨ gba anɨ-o. Andjelu ango-o atsia apa pɨ anɨ me: ‹Tima okpála bhʉ́ gʉdhʉ na Djope ngʉ́ naꞌɨ Simo ɨnde u agisila ’lɨ e me Piele-o. ");
INSERT INTO mdm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Anɨ akpókpo pɨ mʉ, ngamʉ di ne okpála ɨnde bhʉ́ ’tɨ gba mʉ-o, eli gba Ebhe ɨnde akóbho mʉ-o.› ");
INSERT INTO mdm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lɨ nedhɨnga lɨ ngama Piele, ma aholo nagama ’ngʉ́ lɨe, Bu Bhobua atsia akɵ pɨ́ uo maka anɨ akɵ nanɨ di lɨe pɨ́ nɨ́ lɨ ’kpɨ́ na Patekote ko. ");
INSERT INTO mdm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Abhomʉ-o, ma atsia abhundja eli gba Ngámá ɨnde apa me: ‹Djaa abatisa nanɨ okpála ne engu, engʉ́ bini ngayi-e, yi asía batisimo na Bu Bhobua.› ");
INSERT INTO mdm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ma au mbámbá me Ebhe aha Bu Bhobua pɨ ogandji okpála bhomʉ-o, maka anɨ aha di nanɨ koli Bu Bhobua bini bhomʉ-o pɨ nɨ́, lɨ nedhɨnga ɨnde nɨ́ abhuka Ngámá Yesu Kilisito lɨe-o. La-a, ngama-a, ma ne da me ma yoko Ebhe lɨ engʉ́ ɨnde anɨ akʉnda namene e?» ");
INSERT INTO mdm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lɨ omaYuda ɨnde abhuka bhomʉ-o adje lɨe, u adhɵgɵ Ebhe, u atsia apa me: «A na paká me Ebhe aha di nadji bua o pɨ ogandji okpála, amba u sia di mʉkobho na dʉdʉma.» ");
INSERT INTO mdm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pɨta u abhɵlɵ Etieni lɨe, u aholo namene omabhuka sisiti. Abhomʉ-o, omabhuka bhelé atsia atsambala. Okoko bhʉ́ ká uo agbida bhʉ́ ndu doto na Fenisia, di ne bhʉ́ kpɵmɵ na Sipele, di ne bhʉ́ gʉdhʉ na Atiokia. U atsia adʉ nakpokpo Bádha Ngali gba Yesu-o bha bini pɨ omaYuda. ");
INSERT INTO mdm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Okoko bhʉ́ ká uo adʉ okpála na kpɵmɵ na Sipele, di ne gʉdhʉ na Silene. U anʉ bhʉ́ gʉdhʉ na Atiokia. Abhomʉ-o ngauo, u atsia aholo nakpokpo Bádha Ngali gba Ngámá Yesu di pɨ ogandji okpála. ");
INSERT INTO mdm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Angu gba Ngámá-a adʉ bhʉ́ dabɨlɨ bini ne uo. Kaka-a, ogandji okpála bhelé abhuka, u atsia adji lɨo pɨ Ngámá. ");
INSERT INTO mdm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Omabhuka na Yelusalema adje engʉ́ ango-o. Abhomʉ-o, u atsia atima Balanabasɨ bhʉ́ Atiokia. ");
INSERT INTO mdm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Balanabasɨ nanɨ ne bádha kpála. Anɨ abedhe nanɨ ne Bu Bhobua di ne nabhuka bedhe. Anɨ akolo oo, anɨ atsia au me Ebhe atuko bisagu pɨ́ omabhuka. Abhomʉ-o, anɨ akpi djalɨ, anɨ atsia ato masi bhʉ́ ndʉ uo hana me u ha lɨo pɨ Ngámá ne bua o bini. Abhomʉ-o, okpála bhelé atsia abhuka Ngámá. ");
INSERT INTO mdm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pɨpɨta-a, Balanabasɨ anʉ nagɨlɨ Saulo bhʉ́ gʉdhʉ na Talasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lɨ anɨ au anɨ lɨe, u atsia agie lɨo ne anɨ bhʉ́ gʉdhʉ na Atiokia. Ndʉ uo bhisi hana amene kalanga bini libhomu bhʉ́ ká omabhuka ango-o. U atsia adʉ asuno pɨ okpála bhelé. U agisila nanɨ ꞌɨlɨ na omakilisito lɨ omabhuka bhʉtsibhʉtsi na bini bhʉ́ gʉdhʉ na Atiokia. ");
INSERT INTO mdm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lɨ nedhɨnga bhomʉ-o, opolofeta koko ayie bhʉ́ gʉdhʉ na Yelusalema, u atsia ago bhʉ́ gʉdhʉ na Atiokia. ");
INSERT INTO mdm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Abhomʉ-o, sʉka uo bini, a adʉ ’lɨ anɨ me Agabusɨ ayie bhʉ́lá. Anɨ akpokpo bhʉ́ angu gba Bu Bhobua me: «Adyɨndɨ na ngbéngbé alɨ́ pɨ́la doto libhomu.» (Atsia amene lɨe bhʉ́ nedhɨnga lɨ Kolode adʉ lɨe ’ngbé ngámá-o.) ");
INSERT INTO mdm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Omabhuka atsia apa me kpála ne kpála ha tɨa bhende lɨ angu anɨ akólo lɨe, ngʉbula natitima me ateteke omabhuka ɨnde bhʉ́ ndu doto na Yudaya ko. ");
INSERT INTO mdm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Abhomʉ-o, u amene bhadi mo-o. U atsia atima tɨa ango-o pɨ obhelesɨ okpála bhʉ́ Yelusalema sa ’kpa Balanabasɨ ne uo ne Saulo. ");
INSERT INTO mdm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bhʉ́ nedhɨnga bhomʉ-o, ’ngbé ngámá Elode Agilipa aholo amene okpála koko na Piga gba Ebhe-e sisiti. ");
INSERT INTO mdm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Anɨ aha lɨ́lɨ me u bhɵlɵ Djakɨ, ndai Djaa , ne mbotɨa. U atsia abhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Lɨ anɨ au lɨe me engʉ́ ango-o anga lɨ omaYuda naali-e, anɨ atsia aha matá lɨ́lɨ me u holo Piele. (A adʉ masɨkpe de nedhɨnga na anokomɨa na Pasɨka , di ne anokomɨa nazʉ mapa ɨnde lɨ levile nde bhʉ́ e ade ko.) ");
INSERT INTO mdm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lɨ anɨ aholo Piele lɨe, anɨ abhike anɨ bhʉ́ tɨkpʉ. Abhomʉ-o, anɨ atsia aꞌo osʉdha badha badha bhʉ́ libi badha ngʉ́ nalila anɨ. Anɨ adʉ akʉnda nakodho ’ngʉ́ gba anɨ-e bhʉ́ ká djila ndʉ okpála hana pɨta anokomɨa na Pasɨka-o. ");
INSERT INTO mdm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lɨ Piele adʉ lɨe bhʉ́ tɨkpʉ-o, okpála na Piga gba Ebhe-e adʉ ayo Ebhe ne bua o hana ngʉbula anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sukpe kala me Elode kodho ’ngʉ́ gba Piele, Piele adʉ ala sʉnda osʉdha bhisi. A adʉ me u nde agbigbite anɨ ne ogbɨndjɨlɨ bhisi. Omʉlila atsia adʉ alila obhotɨ na tɨkpʉ-o. ");
INSERT INTO mdm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Má gala kolo me-e, andjelu bini gba Ngámá-a akoto. Zɨ djua aha bɨlɨ bhʉ́ tɨna ’tɨ ango-o hana. Andjelu-o adʉla Piele lɨ kala e, anɨ azʉkʉ anɨ. Anɨ atsia apa pɨ anɨ me: «Yie bhʉ́lá má gala!» Abhomʉ-o, ogbɨndjɨlɨ-e abhulu bhʉ́ ’kpa anɨ, atsia abala kuto. ");
INSERT INTO mdm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pɨpɨta-a, andjelu-o apa pɨ anɨ me: «Gbite ’kpʉ́ ludu mʉ, mʉ toto la di malɵkɵ gba mʉ-o bhʉ́ ’dhʉ mʉ.» Piele amene bhadi moko. Andjelu-o atsia apa matá pɨ anɨ me: «To koti gba mʉ-o, amba mʉ kpata ma.» ");
INSERT INTO mdm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piele aholo nakpata andjelu-o, anɨ atsia akoto bhʉ́ tɨna ’tɨ ɨnde anɨ adʉ bhʉ́ e ko. Anɨ dʉ ambɨla de me engʉ́ ɨnde lɨ andjelu ngamene e-e, a ko kʉkʉlʉ ’ngʉ́-o de. Anɨ adʉ abhundja naae me a ko ehe maka loto. ");
INSERT INTO mdm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","U ane libi osʉdha na bini ɨnde adʉ nalila tɨkpʉ-o. Pɨpɨta-a, u ane libi osʉdha bhende na bhisi-o. U akolo lɨ ’ngbé bhotɨ na kalase ɨnde nakoto bhʉ́ gʉdhʉ-o. Bhotɨ ango-o aꞌʉ bha lɨe kala uo ne tɨtɨ e, u atsia aze. U aholo ’nʉ́, u akolo lɨ kpadjɨ bini. Má gala kolo me-e, andjelu-o angɨta lɨ anɨ má pele! ");
INSERT INTO mdm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Abhomʉ-o, Piele ambɨla me engʉ́ ɨnde amene lɨe-e, a ko kʉkʉlʉ ’ngʉ́. Anɨ atsia apa me: «Mbɨa ɨnde-e, ma ambɨla na paká me Ngámá atima andjelu gba e, anɨ atsia akobho ma sa ’kpa Elode di ne ndʉ osisiti ’ngʉ́ hana ɨnde lɨ omaYuda adʉ akʉnda namene e ngʉ́ ma ko.» ");
INSERT INTO mdm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Lɨ ɨmbɨlangʉ gba Piele abhulu lɨe lɨe, anɨ atsia anʉ bhʉ́ ’tɨ gba Malɨa , ’hi Djaa , kpála u agisila ’lɨ e me Maloko-o. Oo, okpála bhelé apɵkɵbhɵ nanɨ bhʉ́la o, u atsia adʉ ayo Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piele abhɨ bhotɨ na ngbéngbé-o. Abhomʉ-o, sʉka kpála bini na kulu na ɵɵlɵ adʉ oo, a adʉ ’lɨ anɨ me Lode. Anɨ atsia ago ngʉ́ naꞌʉ bhotɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Lɨ anɨ ambɨla ’li Piele lɨe, anɨ tsia ꞌʉ bhotɨ-e de ka djalɨ. Engʉ́ bini, anɨ agie lɨe ne holo abhʉ́ ’tɨ, anɨ atsia apa pɨ okpála ɨnde adʉ bhʉ́ ’tɨ oo me: «Piele alʉ lɨ bhotɨ akilidjo!» ");
INSERT INTO mdm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Okpála ango-o atsia agie pɨ anɨ me: «Mʉ ne bhʉlʉ pele!» Engʉ́ bini, anɨ azɨ bha kekele tété me a ko kʉkʉlʉ ’ngʉ́. Abhomʉ-o, u atsia apa pɨ anɨ me: «A ko andjelu gba anɨ ko.» ");
INSERT INTO mdm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","La-a, Piele adʉ bha nabhɨ bhotɨ-o. U aꞌʉ lɨe, u au anɨ, u atsia angamba naali. ");
INSERT INTO mdm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Abhomʉ-o, Piele amene ’kpa e pɨ uo me u ndjili nga má bulu! Anɨ atsia akpokpo pɨ uo maka lɨ Ngámá agbe anɨ lɨe bhʉ́ tɨkpʉ-o. Anɨ atsia apa matá me: «Yi kpokpo pɨ Djakɨ di ne pɨ ondaise nɨ́ koko-o.» Pɨpɨta-a, anɨ akoto, anɨ atsia atapa lɨ bɨlɨ koko. ");
INSERT INTO mdm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lɨ ekpɨ́ aseke lɨe, osʉdha ɨnde adʉ alila tɨkpʉ-o, aholo nazɨ tolo naali sʉnda o. Abhomʉ-o, u atsia adʉ ayi lɨo me: «A akolo lɨ Piele ne mangua ’ngʉ́ dho?» ");
INSERT INTO mdm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elode atima okpála me u gɨlɨ anɨ. Engʉ́ bini, u u anɨ de. Anɨ ayiyi osʉdha ɨnde adʉ alila anɨ-o. Abhomʉ-o, anɨ atsia aha lɨ́lɨ me u bhili uo. Pɨpɨta-a, Elode ayie bhʉ́ Yudaya, anɨ atsia anʉ bhʉ́ gʉdhʉ na Sedjale. Oo, anɨ adʉ mbo ngʉbula nedhɨnga. ");
INSERT INTO mdm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","La-a, Elode adʉ adje siti bua naali pɨ okpála na gʉdhʉ na Tile di ne Sidona. Okpála ango-o adje lɨo. Pɨpɨta-a, u atima okpála ngʉ́ nanʉ nagama ’ngʉ́ ne ’ngbé ngámá Elode. Okpála ango-o adje ngaɨza lɨo ne Balasitusi, kpála natsia ’kpɨ́ lɨ oehe gba ’ngbé ngámá Elode-o. U adʉ nayo ka ’ngbé ngámá guo ’ngʉ́ , anga ndʉ ezʉ gba uo-o hana adʉ nayie bhʉ́ doto gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Abhomʉ-o, Elode aꞌo ’kpɨ́ ngʉ́ nagama ’ngʉ́ pɨ uo. Lɨ ’kpɨ́ ango-o, anɨ adyɨ bongo na ngámá, anɨ atsia adʉ pɨ́ kiti na ngámá gba e-o. Anɨ atsia aholo agama ’ngʉ́ pɨ uo bhʉ́ ká djila ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ndʉ okpála hana asʉla me: «A ngagama ’ngʉ́ ɨnde mboye ebhe, a ko kpála-kʉtɨ de!» ");
INSERT INTO mdm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lɨ Elode adje lɨe mo-o, anɨ atsia azɨba, anɨ dhɵgɵ Ebhe de. Bha lɨ nedhɨnga bhomʉ-o, andjelu bini gba Ngámá-a asʉ anɨ. Padhá de, anga anɨ dhɵgɵ Ebhe de. Obangili aholo nazʉ anɨ, anɨ atsia akpi. ");
INSERT INTO mdm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lɨ nedhɨnga bhomʉ-o, eli gba Ebhe-e adʉ ayangba naali. ");
INSERT INTO mdm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lɨ Balanabasɨ ne Saulo andjia kulu gba o-o lɨe bhʉ́ gʉdhʉ na Yelusalema-a, u atsia agie lɨo bhʉ́ Atiokia bhʉ́ dabɨlɨ bini ne Djaa ɨnde u agisila ’lɨ e me Maloko-o. ");
INSERT INTO mdm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Opolofeta di ne omʉsuno ɨnde adʉ nanɨ bhʉ́ Piga gba Ebhe na Atiokia, a ko nanɨ Balanabasɨ, Simeo (ɨnde u aꞌɨ e me Negele), Lukiusɨ (kpála na Silene), Manaene ɨnde abhele bhʉ́ dabɨlɨ bini ne ngámá Elode Atipasɨ, di ne Saulo. ");
INSERT INTO mdm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ekpɨ́ bini, nedhɨnga u adʉ nayo Ebhe lɨe di ne natse ’zʉ-o, Bu Bhobua atsia apa pɨ uo me: «Yi ꞌo Balanabasɨ ne Saulo mʉma kpi ngʉbula namene kulu ɨnde ma aꞌɨ uo ngʉ́ e ko.» ");
INSERT INTO mdm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Abhomʉ-o, pɨta natse ’zʉ di ne nayo Ebhe-e, u aꞌo ’kpa o pɨ́ ’ndjɨ uo, u atsia aha kpadjɨ pɨ uo me u nʉnʉ. ");
INSERT INTO mdm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Lɨ Bu Bhobua atima uo lɨe, u atsia anʉ bhʉ́ gʉdhʉ na Selusia. Oo, u aꞌʉ bhʉ́ ’ngbé zabʉ, u atsia atapa bhʉ́ Sipele. ");
INSERT INTO mdm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","U akolo lɨe bhʉ́ Salamine-e, u aholo nakpokpo eli gba Ebhe-e bhʉ́ oetɨ nadje lɨ́lɨ gba omaYuda-o . Djaa Maloko adʉ bhʉ́ dabɨlɨ bini ne uo ngʉ́ nateteke uo. ");
INSERT INTO mdm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","U agulu kpɵmɵ-o hana, u atsia akolo bhʉ́ Pafosɨ. Oo, u abhaka maYuda bini, bhʉlʉ mambengʉ ɨnde adʉ ’lɨ e me Bale-Yesu. Anɨ adʉ apa me nɨ ne polofeta. ");
INSERT INTO mdm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Anɨ adʉ nadʉ agba Selugio Polo, kpála na ɨmbɨlangʉ, ɨnde adʉ ngámá na ndu doto ango-o. Ngámá ango-o aꞌɨ Balanabasɨ ne Saulo, anga anɨ akʉnda nanɨ nadje ’li Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Engʉ́ bini, bhʉlʉ mambengʉ Elɨmasɨ (anga ꞌɨlɨ bhomʉ-o akʉnda napa bhʉ́ eli gba oGiliki moko) ayala. Anɨ adʉ agɨlɨ me nɨ yoko ngámá na ndu doto ango-o me anɨ abhúka de. ");
INSERT INTO mdm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Abhomʉ-o, Saulo, ɨnde lɨ ’lɨ e adʉ di me Polo-o, abedhe ne Bu Bhobua, anɨ atsia anɨ ne kpéke djila. ");
INSERT INTO mdm_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Anɨ atsia apa me: «Ngamʉ siti kpála na kali ɨnde ngapite okpála, ndɨlɨ gba Djabʉlʉ, kpála nayala ndʉ ’ngʉ́ na babadha hana, mʉ ꞌó nasiti okpadjɨ na ngbingbili gba ngámá-a dɨ! ");
INSERT INTO mdm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tsitsia, mbɨa ɨnde-e, Ebhe asʉ́ mʉ. Djila mʉ aní. La di-e, mʉ ú matá zɨndjɨla de ngʉbula mbo oekpɨ́.» Kolo me-e, ndindi ani djila Elɨmasɨ. Biti atsia abuku anɨ hana, anɨ adʉ abubudha bɨlɨ de e ngbalina nagɨlɨ me kpála holo ’kpa nɨ ngʉ́ nateteke nɨ. ");
INSERT INTO mdm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lɨ ngámá na ndu doto au engʉ́ akodho ’kpɨ́-e lɨe me-e, anɨ atsia abhuka di ne nangamba naali ka nasuno ɨnde u asuno e ne ’lɨ Ngámá ko. ");
INSERT INTO mdm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polo di ne okpála ɨnde adʉ adhʉkʉ bhʉ́ dabɨlɨ bini ne anɨ-e, ayie bhʉ́ Pafosɨ ngʉ́ nanʉ bhʉ́ Peledje bhʉ́ ndu doto na Pamifilia. Engʉ́ bini, Djaa Maloko aꞌo ká uo oo, anɨ atsia agie lɨe abhʉ́ Yelusalema. ");
INSERT INTO mdm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ngauo-o, u akpata bha kpadjɨ gba o-o. U ayie bhʉ́ Peledje, u atsia akolo bhʉ́ Atiokia ɨnde bhʉ́ Pisidia ko. Bhʉ́ ’kpɨ́ naguo gba omaYuda-a , Polo ngauo ne Balanabasɨ alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje , u atsia adʉlʉ kuto. ");
INSERT INTO mdm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pɨta natanga lɨ́lɨ di ne obhuku gba opolofeta-a, ongámásɨ na etɨ nadje lɨ́lɨ-e atsia atima eli pɨ uo me: «Ondaise ya, ɨ dʉ me yi nde ne engʉ́ ngʉ́ nateteke okpála ne di-e, yi de pa!» ");
INSERT INTO mdm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Polo ayie bhʉ́lá, anɨ amene ’kpa e pɨ okpála, anɨ atsia apa me: «Ngayi okpála na Ɨsalaele di ne yi okpála ɨnde ngakpe Ebhe-e, yi dje nga ma! ");
INSERT INTO mdm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ebhe gba okpála ɨnde omaƗsalaele, abhʉ nanɨ onguo ogbi nɨ́. Anɨ abe ndʉ uo bhʉ́ nedhɨnga u adʉ lɨe bhʉ́ bali bhʉ́ Edjipeto-o. Pɨpɨta-a, ne angu gba e-e, anɨ atsia agbe uo bhʉ́ doto na Edjipeto. ");
INSERT INTO mdm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Anɨ akibila uo bhʉ́ mili bɨlɨ ngʉbula kalanga masɨkpe de ndjɨkpa badha. ");
INSERT INTO mdm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pɨpɨta-a, anɨ abhili opiga mananɨka bhʉ́ doto na Kanana. Anɨ atsia aha doto gba uo-o pɨ onguo ogbi nɨ́ ");
INSERT INTO mdm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ngʉbula kalanga masɨkpe de kámá badha ne ndjɨkpa bhuluvue. Pɨpɨta-a, anɨ aha okpála nakodho mangɨmbo pɨ uo akolo bhʉ́ nedhɨnga gba polofeta Samʉele. ");
INSERT INTO mdm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pɨpɨta-a, u ayo me o okʉnda ’ngbé ngámá. Abhomʉ-o, Ebhe atsia aha Saulo pɨ uo, ndɨlɨ gba Kisi, bhʉ́ piga gba Bendjamé. Anɨ aʉ nanɨ pɨ́ ’ndjɨ uo ngʉbula kalanga ndjɨkpa badha. ");
INSERT INTO mdm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pɨta lɨ Ebhe ayala Saulo lɨe, anɨ atsia agbe ’ngbé ngámá Davidi pɨ uo. Anɨ atsia apa lɨ ’ngʉ́ gba anɨ-e me: ‹Ma au Davidi, ndɨlɨ gba Yese. A ko kpála na babadha bhʉ́ djila ma. Anɨ améne ndʉ ’ngʉ́ hana maka ma akʉnda lɨe.› ");
INSERT INTO mdm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Bhʉ́ piga gba Davidi-e, Ebhe agbe pɨ omaƗsalaele Mʉkobho Yesu maka anɨ apa nanɨ lɨe kalanʉ ko. ");
INSERT INTO mdm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kala nago ka anɨ-e, Djaa akpokpo Bádha Ngali pɨ ndʉ okpála na Ɨsalaele hana. Anɨ adʉ ayo ka uo me u dji bua o, amba u sia batisimo. ");
INSERT INTO mdm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lɨ Djaa akolo lɨe lɨ ’so kulu gba e, anɨ adʉ apa me: ‹Yi ngabhundja me ma ne da? Ma ne kpála ɨnde yi ngadjeke e ade! Engʉ́ bini, yi djedje, a ngago pɨta ma ne kpála. Ma ne tetele kpála ade ngʉbula me ma gbe malɵkɵ bhʉ́ ’dhʉ anɨ.› ");
INSERT INTO mdm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ondaise ma, ngayi okpála na piga gba Abalahama di ne yi okpála ɨnde sɨ-e, ɨnde ngakpe Ebhe-e, Ebhe atima nanɨ ngali na mʉkobho ɨnde-e pɨ nɨ́. ");
INSERT INTO mdm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","A na paká me okpála na Yelusalema di ne ongámásɨ gba o-o mbɨla nanɨ Yesu de. Bhʉ́ oekpɨ́ naguo gba omaYuda bini ne bini hana-a, u adʉ atanga obhuku gba opolofeta. La-a, u dʉ ambɨmbɨla de. Engʉ́ bini u akodho ’ngʉ́ gba Yesu lɨe me u bhɵlɵ anɨ-e, u amene bhomʉ-o engʉ́ ɨnde lɨ opolofeta apa e ko. ");
INSERT INTO mdm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Belegʉ u u nanɨ engʉ́ bini ɨnde u tɨ da nabhɵlɵ Yesu ka e lɨe de-e, u ayo ka Pɨlatɵ me u bhɵlɵ anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pɨta u amene ndʉ ’ngʉ́ hana maka lɨ ’li Ebhe apa lɨe lɨ ’ngʉ́ gba anɨ-e, u aꞌe anɨ lɨ kulusi, u atsia anʉ ato anɨ bhʉ́ lata. ");
INSERT INTO mdm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Engʉ́ bini, Ebhe atsia azuku anɨ bhʉ́ ká okpála ɨnde amu-o. ");
INSERT INTO mdm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yesu asuno lɨe pɨ okpála ɨnde adʉ adholo ne anɨ bhʉ́ dabɨlɨ bini nayie bhʉ́ Galilaya akólo bhʉ́ Yelusalema ngʉbula ’kpɨ́ bhelé. Mbɨa ɨnde-e, okpála ango-o ngakpokpo ’ngʉ́ gba anɨ-e pɨ okpála na Ɨsalaele ngao. ");
INSERT INTO mdm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ngaya makpe-e, ya ago ngʉ́ nakpokpo Bádha Ngali ɨnde-e pɨ yi, Bádha Ngali ɨnde lɨ Ebhe apa nanɨ kalanʉ me nɨ apá e pɨ onguo ogbi nɨ́-o. ");
INSERT INTO mdm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Anɨ amene mbɨa ɨnde-e pɨ nɨ́ ongɨsɨ gba uo-o, lɨ kpadjɨ nazuku Yesu bhʉ́ ká okpála ɨnde amu, maka u aye nanɨ lɨe bhʉ́ Etsi na bhisi gba omaYuda-a me: ‹Mʉ ne ndɨlɨ gba ma na bhobhoko, Ma azu mʉ nakɨ ngama makpe.› ");
INSERT INTO mdm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ebhe apa nanɨ me nɨ azúku Yesu bhʉ́ ká okpála ɨnde amu-o mazuku, ngʉbula me anɨ akpí matá-a de. A ko engʉ́ ɨnde anɨ apa nanɨ e me: ‹Ma ahá obisagu na bububu ɨnde di na kʉkʉlʉ-o pɨ mʉ, ɨnde ma apana nanɨ e pɨ Davidi ko.› ");
INSERT INTO mdm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kaka-a, anɨ apa matá lɨ bɨlɨ koko me: ‹Mʉ ꞌó de me kpála na ngbingbili gba mʉ-o zi bhʉ́ lata-a de.› ");
INSERT INTO mdm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Padhá de, anga Davidi bhʉ́ nedhɨnga gba e, amene lɨ́lɨ gba Ebhe-e hana. Pɨpɨta-a, anɨ akpi, u azɨ anɨ de onguo ogbi e, anɨ atsia azi. ");
INSERT INTO mdm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Engʉ́ bini, kpála ɨnde lɨ Ebhe azuku e, anɨ zí naae de. ");
INSERT INTO mdm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ondaise ma, yi mbɨla ndjɨndjɨ me u apa pɨ yi me u aꞌe osisiti ’ngʉ́ gba yi-e ka Yesu. Yi tɨ da nakobho ka namene lɨ́lɨ gba Moidje-e de. Engʉ́ bini yi akóbho bha me yi nde abhuka Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ꞌE-e! Yi lila lɨyi uu me engʉ́ ɨnde lɨ opolofeta apa e akólo lɨ yi de, engʉ́ ɨnde me: ");
INSERT INTO mdm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Yi tsitsia nga, ngayi okpála na ’ngbé ’ndjɨ, yi ngamba naali, amba yi ngɨngɨta má pele pele! Padhá de, anga bhʉ́ nedhɨnga gba yi-e, ma améne engʉ́ bini ɨnde yi tɨ da nazɨba e de, abana ɨ dʉ me kpála bini nde apa nanɨ engʉ́ ango-o pɨ yi kalanʉ.›» ");
INSERT INTO mdm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Lɨ Polo ne uo ne Balanabasɨ akoto lɨe bhʉ́ ’tɨ nadje lɨ́lɨ-e, u atsia ayo ka uo me u go bhʉ́ ’kpɨ́ naguo na sidi, amba u kpokpo matá engʉ́ bini bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","U atsambala lɨe bhʉ́ bula-a, bhelé na omaYuda ne ogandji okpála ɨnde adʉ akpe Ebhe-e, akpata Polo ne uo ne Balanabasɨ. Abhomʉ-o, Polo ne uo ne Balanabasɨ, bhʉ́ nagama ’ngʉ́ gba o ne uo-o, u ato masi bhʉ́ uo me u holo lɨo lɨ bádha bhʉ́ ’bu gba Ebhe-e kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ekpɨ́ naguo na sidi-e, masɨkpe de ndʉ okpála na gʉdhʉ hana apo bhʉ́la o ngʉ́ nadje ’li Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lɨ omaYuda au bhiti okpála ango-o lɨe, u asia siti bua , u atsia adʉ asobho Polo ka eli ɨnde anɨ adʉ apa e ko. ");
INSERT INTO mdm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","La-a, Polo ne uo ne Balanabasɨ dʉ nanɨ nagama ’ngʉ́ pɨ uo ne tsʉlʉ de. U adʉ apa me: «A ayo nanɨ me ya kpo ngaɨza nakpokpo eli gba Ebhe-e kalanʉ pɨ yi. Engʉ́ bini, maka yi ayala lɨe, yi au la di me yi tɨ da nasia mʉkobho na dʉdʉma de. Kaka mbɨa ɨnde-e, ya anʉ́ ɨbili agba ogandji okpála. ");
INSERT INTO mdm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Padhá de, anga lɨ́lɨ ɨnde ya asia e ka Ngámá-a ngae ɨnde: ‹Ma aꞌo mʉ eke pɨ opiga, ngʉbula me mʉ gapa ngali na mʉkobho akólo bha bini alɨ ’dje doto!›» ");
INSERT INTO mdm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Lɨ ogandji okpála adje lɨe mo-o, u akpi djalɨ, u atsia aholo nadhɵgɵ ’li Ngámá. Ndʉ okpála hana lɨ Ebhe alo o ngʉ́ nasia mʉkobho na dʉdʉma atsia abhuka. ");
INSERT INTO mdm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Abhomʉ-o, ’li Ngámá atsia adhʉkʉ bhʉ́ ndu doto ango-o libhomu. ");
INSERT INTO mdm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Engʉ́ bini, omaYuda ato ’ngʉ́ bhʉ́ ’ndjɨ olɨsɨ na tɨa ɨnde adʉ adhɵgɵ Ebhe di ne obhelesɨ okpála na kʉtɨ-o. Abhomʉ-o, u aholo amene Polo ne uo ne Balanabasɨ sisiti, u atsia agbe uo bhʉ́ doto gba o-o. ");
INSERT INTO mdm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Abhomʉ-o, okpála bhisi ango-o apulu doto na kʉtɨ gba uo ɨnde adhedhe lɨ ’dhʉ o, ngʉbula nasuno pɨ uo me u amene siti ’ngʉ́. U atsia agbida bhʉ́ Ikoniomʉ. ");
INSERT INTO mdm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Engʉ́ bini, pɨ omʉkpata-a, u abedhe ne djalɨ di ne Bu Bhobua bedhe. ");
INSERT INTO mdm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bhʉ́ Ikoniomʉ-o, a amene bhadi lɨe moko. Polo ne uo ne Balanabasɨ alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba omaYuda . OmaYuda bhelé di ne okpála ɨnde ne omaYuda ade-e, akolo omabhuka ka engʉ́ ɨnde u agama e ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Engʉ́ bini, omaYuda bhende ɨ bhuka nanɨ de-e, a ato bhʉ́ ogandji okpála mabhundja na sisiti pɨndjɨ ondaise nɨ́, omabhuka. ");
INSERT INTO mdm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","La-a, Polo ne uo ne Balanabasɨ abhue mbo nanɨ bhʉ́ Ikoniomʉ naali. U dʉ agama ’ngʉ́ ne tsʉlʉ de anga u adʉ ne nabhuka bhʉ́ Ngámá, ɨnde adʉ asuno me eli ɨnde u adʉ akpokpo e pɨndjɨ bádha bhʉ́ ’bu gba nɨ-e, adʉ kʉkʉlʉ ’ngʉ́. Padhá de, anga anɨ adʉ aha angu pɨ uo ngʉ́ namene okɨaka ’ngʉ́ di ne ongʉ́ na ngangamba. ");
INSERT INTO mdm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kaka-a, okpála na gʉdhʉ ango-o atsia agbo bhʉsʉ o: okoko adʉ pɨ omaYuda, okoko atsia adʉ pɨ obhʉlʉ titima gba Yesu . ");
INSERT INTO mdm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Abhomʉ-o, omaYuda di ne ogandji okpála bhʉ́ dabɨlɨ bini ne ongámásɨ gba o-o, atsia aleke lɨo ngʉ́ namene Polo ne Balanabasɨ sisiti, ngʉ́ nabhili uo ne teme. ");
INSERT INTO mdm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Lɨ okpála bhisi bhomʉ-o ambɨla ’ngʉ́ ango-o lɨe, u atsia akpe agbida bhʉ́ ogʉdhʉ na Lisitele ne Delebe, la di ne bhʉ́ okʉtɨ na ngongo, bhʉ́ ndu doto na Likaonia. ");
INSERT INTO mdm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Oo di-e, u aholo akpokpo Bádha Ngali pɨ okpála. ");
INSERT INTO mdm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Bhʉ́ Lisitele-e, kpála ɨnde lɨ eze adʉ lɨ ’dhʉ e adʉ oo. Anɨ dhʉkʉ de nayie maka nanɨ u azu anɨ lɨe-o. ");
INSERT INTO mdm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Anɨ adʉ adje engʉ́ ɨnde lɨ Polo adʉ apa e ko. Polo atsia anɨ ne kpéke djila. Anɨ au me kpála ango-o abhuka me nɨ tɨ da nasia mʉkobho. ");
INSERT INTO mdm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Abhomʉ-o, Polo atsia apa pɨ anɨ ne kpéke ’li me: «Yie bhʉ́lá, lʉ ngbingbili!» Kpála ango-o ayie bhʉ́lá, anɨ aꞌulu akɵ má kprii! Anɨ atsia aholo nadhʉkʉ. ");
INSERT INTO mdm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lɨ okpála bhelé au engʉ́ lɨ Polo amene e lɨe, u asʉla bhʉ́ eli na kʉtɨ gba okpála na ndu doto na Likaonia me: «Oebhe akolo maka okpála-kʉtɨ, u atsia ago gba nɨ́!» ");
INSERT INTO mdm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","U aꞌo ꞌɨlɨ lɨ Balanabasɨ me Djeusi, u atsia aꞌo ’lɨ Polo me Elemesɨ, anga anɨ adʉ agama ’ngʉ́-o ngae. ");
INSERT INTO mdm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Dimandɵ gba ebhe Djeusi, ɨnde lɨ ’tɨ ebhe gba e adʉ lɨ ’bhɵ gʉdhʉ-o, ago ne obagala na obhosɨbhosɨ lɨ ’bhɵ bhotɨ na gʉdhʉ-o. Anɨ aha di ꞌi felele, bhʉ́ dabɨlɨ bini ne okpála na kʉtɨ-o, anɨ atsia adʉ akʉnda me nɨ bhɵlɵ onʉ ango-o ngʉ́ nahaha pɨ Balanabasɨ ne uo ne Polo. ");
INSERT INTO mdm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lɨ obhʉlʉ titima gba Yesu adje engʉ́ bhomʉ-o lɨe, u asisidha obongo lɨ kʉte o má tsʉe tsʉe! U anʉ ne holo bhʉ́ ká okpála ne nasʉsʉla me: ");
INSERT INTO mdm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Ondaise ya, yi ngamene bhomʉ-o nɨ? Ya bha ne okpála maka yi. Ya ago pɨ yi ne Bádha Ngali me yi ꞌo ká oebhe ɨnde na padhá padhá bhomʉ-o, ɨnde lɨ mbinimbini nde bhʉ́ o ade ko. La di me yi ha lɨyi pɨ Ebhe na mʉkobho ɨnde abho ekpɨ́, abho doto, abho ’ngbé ’ngu ne ndʉ ’he ɨnde bhʉ́bhʉ́-o hana ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bhʉ́ nedhɨnga gba okpála na kalanʉ-o, anɨ aꞌo me u kpata kpadjɨ gba o makpe ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Engʉ́ bini, anɨ ꞌɨlɨ ’to e lɨ napana lɨe ne namene babadha ’ngʉ́ pɨ uo de. Padhá de, anga anɨ ngatima pɨ yi ebha di ne onguwa bhʉ́ nedhɨnga gba o-o. Anɨ ngaha ezʉ pɨ yi. Anɨ la di ngabedhe yi ne djalɨ.» ");
INSERT INTO mdm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Abana u adʉ apapa lɨe mo-o, da me u yoko bhiti okpála adʉ kpekpeke me u abhɵ́lɵ onʉ pɨ o de ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lɨ nedhɨnga bhomʉ-o, omaYuda ɨnde ayie bhʉ́ Atiokia, bhʉ́ ndu doto na Pisidia, di ne bhʉ́ Ikoniomʉ, apite bhiti okpála bhomʉ-o me, u tʉtʉlʉ Polo ne teme ngʉ́ nabhɵlɵ anɨ. U agbe anɨ alɨ ngo gʉdhʉ anga u adʉ abhundja me anɨ akpi. ");
INSERT INTO mdm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Engʉ́ bini, lɨ omabhuka ago asa lɨo lɨe dengo anɨ-e, anɨ ayie bhʉ́lá, anɨ atsia agie matá lɨe bhʉ́ gʉdhʉ. Lɨ ekpɨ́ aseke lɨe, ngauo ne Balanabasɨ-e, u atsia atapa bhʉ́ Delebe. ");
INSERT INTO mdm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bhʉ́ gʉdhʉ na Delebe, u akpokpo Bádha Ngali pɨ okpála, u atsia asia omʉkpata bhibhiti. Pɨpɨta-a, u agie lɨo bhʉ́ Lisitele, bhʉ́ Ikoniomʉ di ne bhʉ́ Atiokia bhʉ́ ndu doto na Pisidia. ");
INSERT INTO mdm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","U aꞌe tsʉlʉ lɨ bua uo, u ato masi bhʉ́ uo me u lʉ kpekpeke bhʉ́ nabhuka. U adʉ apa pɨ uo me: «A ayo me nɨ́ dje lɨkabhu naali ngʉ́ nalɨ bhʉ́ kʉtɨ na Naʉ gba Ebhe ko.» ");
INSERT INTO mdm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bhʉ́ Dadjua gba Ebhe bini ne bini hana, u adʉ alo obhelesɨ okpála . Pɨta u atse ezʉ ngʉ́ nayo Ebhe lɨe, u atsia aꞌo uo sa ’kpa Ngámá ɨnde u abhuka e ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","U agulu Pisidia lɨe, u atsia akolo bhʉ́ Pamifilia. ");
INSERT INTO mdm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pɨta u akpokpo ’li Ebhe lɨe pɨ okpála bhʉ́ Peledje-e, u atsia anʉ bhʉ́ Atalia. ");
INSERT INTO mdm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","U ayie lɨe oo, u alɨ bhʉ́ zabʉ, u atsia anʉ bhʉ́ Atiokia. A bhomʉ-o bɨlɨ ɨnde u aꞌo nanɨ uo lɨe me u sia bádha bhʉ́ ’bu gba Ebhe ngʉbula kulu ɨnde u amene e mbɨa ɨnde-e ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","U akolo lɨe oo, u apo bhʉ́la okpála na Dadjua gba Ebhe-o. U atsia akpokpo pɨ uo ndʉ ’ngʉ́ hana ɨnde lɨ Ebhe amene e bhʉ́ dabɨlɨ bini ne uo-o. U atsia akpokpo di pɨ uo maka lɨ Ebhe abhulu kpadjɨ pɨ ogandji okpála lɨe ngʉ́ nabhuka di anɨ Ebhe ko. ");
INSERT INTO mdm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Polo ne Balanabasɨ asɨ nanɨ mbo ekpɨ́ bhelé bhʉ́ dabɨlɨ bini ne omʉkpata na Atiokia. ");
INSERT INTO mdm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Okpála koko ɨnde ayie bhʉ́ Yudaya-a, akolo bhʉ́ Atiokia. U adʉ asuno pɨ omabhuka me: «Yi tɨ da nasia mʉkobho de, ɨ dʉ me u nde kodho yi bhʉ́ gandja maka lɨ lɨ́lɨ gba Moidje apa lɨe de ko.» ");
INSERT INTO mdm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Abhomʉ-o, Polo ne Balanabasɨ agbe bhayiki, u atsia aholo amene kpekebhɵ ne uo naali pɨndjɨ engʉ́ ango-o. U atsia adje lɨo me Polo ne Balanabasɨ, la di ne okpála koko na Atiokia, nʉ bhʉ́ Yelusalema, amba u kpokpo ’ngʉ́ pɨndjɨ ’ngʉ́ ango-o bhʉ́ dabɨlɨ bini ne obhʉlʉ titima gba Yesu di ne obhelesɨ okpála . ");
INSERT INTO mdm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Abhomʉ-o, ndʉ okpála hana na Dadjua gba Ebhe atsia anʉ aꞌo uo lɨ kpadjɨ. U apʉ bhʉ́ ndu doto na Fenisia di ne bhʉ́ Samalɨa. U adʉ akpokpo maka lɨ ogandji okpála akolo omakilisito lɨe ko. Ngali ango-o aha djalɨ naali pɨ ndʉ omabhuka hana. ");
INSERT INTO mdm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","U akolo lɨe abhʉ́ Yelusalema-a, ndʉ okpála hana na Dadjua gba Ebhe, ne obhʉlʉ titima gba Yesu di ne obhelesɨ okpála-a, atsia asia uo. U atsia akpokpo pɨ uo ndʉ ’ngʉ́ hana ɨnde lɨ Ebhe amene e bhʉ́ dabɨlɨ bini ne uo-o. ");
INSERT INTO mdm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Engʉ́ bini, okpála bini bini bhʉ́ ká omʉFalisai , obhende akolo omabhuka-a, ayie bhʉ́lá, u atsia apa me: «A ayo me omabhuka ɨnde ne omaYuda de-e, u to uo bhʉ́ gandja, amba u pa pɨ uo me u mene lɨ́lɨ gba Moidje ko.» ");
INSERT INTO mdm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Abhomʉ-o, obhʉlʉ titima gba Yesu di ne obhelesɨ okpála apo bhʉ́la o ngʉ́ natsia ’kpɨ́ lɨ engʉ́ ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pɨta u amene kpekebhɵ lɨe naali-e, Piele ayie bhʉ́lá, anɨ atsia apa me: «Ondaise ma, yi mbɨla hana me Ebhe abhʉ nanɨ ma bhʉ́ ká yi bhʉtode ngʉbula me ma akpokpo Bádha Ngali pɨ okpála ɨnde ne omaYuda ade ko. U dje, amba u bhuka di Ngali ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","La di-e, Ebhe ɨnde ambɨla bua okpála-a, asuno me nɨ azɨba uo anga anɨ aha Bu Bhobua pɨ uo maka anɨ aha nanɨ di lɨe pɨ nɨ́ ko. ");
INSERT INTO mdm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Anɨ gbo bhʉsʉ nɨ́ ne uo de. Anɨ avʉlʉ bua uo anga u abhuka. ");
INSERT INTO mdm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mbɨa ɨnde-e, ka nɨ yi ngale Ebhe lɨe ne naꞌo tili ’ngʉ́ pɨ́ omabhuka? Engʉ́ ɨnde lɨ onguo ogbi nɨ́, abana nganɨ́ makpe, nɨ́ tɨ nanɨ da nabɨ e de-e! ");
INSERT INTO mdm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A mo-o ade! Engʉ́ bini, nɨ́ abhuka mangbo me nɨ́ akobho maka uo ka bádha bhʉ́ ’bu gba Ngámá Yesu.» ");
INSERT INTO mdm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Abhomʉ-o, ndʉ okpála hana andjili má bulu! U atsia adʉ adje engʉ́ ɨnde lɨ Balanabasɨ ne Polo adʉ akpokpo e ko. U adʉ adje okɨaka ’ngʉ́ di ne ongʉ́ na ngangamba ɨnde lɨ Ebhe amene e bhʉ́ dabɨlɨ bini ne uo bhʉ́ ká ogandji okpála ko. ");
INSERT INTO mdm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","U andjia nagama ’ngʉ́ lɨe, Djakɨ atsia apa me: «Ondaise ma, yi dje nga ma! ");
INSERT INTO mdm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo akpokpo maka lɨ Ebhe amene nanɨ lɨe nayie lɨ lilita pɨ okpála ɨnde naao ne omaYuda ade-e, maka anɨ alo piga bini lɨe bhʉ́ ká uo ngʉ́ nakolo piga gba e-o. ");
INSERT INTO mdm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","La di-e, engʉ́ ɨnde lɨ opolofeta apa e aviti bini ne di, anga u aye bhʉ́ Bhuku gba Ebhe-e me: ");
INSERT INTO mdm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Pɨta bhobhomʉ-o, ma agó matá, Ngámá apa moko, ngʉ́ nayiki etɨ gba Davidi ɨnde atuko-o. Ma aléke obɨlɨ bhende asisiti-e, ma atsia lɨ́lɨ ngbingbili. ");
INSERT INTO mdm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ndʉ okpála koko hana agɨ́lɨ ma, Ngámá, bhʉ́ dabɨlɨ bini ne ndʉ okpála hana ɨnde nanɨ ma alo o-o. ");
INSERT INTO mdm_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A bhomʉ-o eli ɨnde lɨ Ngámá apa nanɨ e ko. Ngaanɨ ɨnde ɨ ngamene engʉ́ ɨnde anɨ apa nanɨ e didili-o.›» ");
INSERT INTO mdm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Djakɨ atsia apa matá me: «Kaka-a, ma abhundja me, a ayo nani kpadjɨ pɨ ogandji okpála ɨnde ngabhuka Ebhe-e de. ");
INSERT INTO mdm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Engʉ́ bini, nɨ́ ye mangbo balʉa pɨ uo amba nɨ́ yo ka uo me, u ꞌo nazʉ so ’nʉ ɨnde u abhɵlɵ e pɨ oebhe na padhá padhá-a maꞌo. U ꞌo nakʉnda olɨsɨ di ne obhosɨ ngangá maꞌo. U ꞌo di nazʉ so ’nʉ ɨnde akpi ne ngʉte bhʉ́ e hana, amba u ꞌo di nazʉ ngʉte maꞌo. ");
INSERT INTO mdm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Padhá de, anga nanɨ bhʉtode, bhʉ́ ogʉdhʉ bini ne bini hana, okpála ngasuno lɨ́lɨ gba Moidje. U la di ngatatanga bhʉ́ otɨ nadje lɨ́lɨ-e ndʉ ’kpɨ́ naguo hana.» ");
INSERT INTO mdm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Abhomʉ-o, obhʉlʉ titima gba Yesu ne obhelesɨ okpála, bhʉ́ dabɨlɨ bini ne ndʉ okpála na Dadjua gba Ebhe hana, atsia azɨba me u gbe okpála koko bhʉ́ ká o. U tima uo bhʉ́ Atiokia bhʉ́ dabɨlɨ bini ne Polo ne Balanabasɨ. U atsia alo Djude ɨnde u aꞌɨ e me Balasabasɨ, di ne Sila, okpála bhisi ɨnde lɨ ndʉ okpála koko hana adʉ amanga o ko. ");
INSERT INTO mdm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Balʉa u atima uo ne e, a ngae ɨnde: «Obhʉlʉ titima gba Yesu di ne obhelesɨ okpála na Dadjua gba Ebhe, ondaise yi-e, u apa me o yi ondaise o ɨnde naao ne omaYuda ade ɨnde ngadʉlʉ bhʉ́ Atiokia, bhʉ́ Silia di ne bhʉ́ Silisia mayi. ");
INSERT INTO mdm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ya adje me okpála koko ɨnde ayie bhʉ́ ká ya ei-e, ato kpekebhɵ bhʉ́ ká yi ne ’li o, u atsia angbɨngɨ bua yi. Engʉ́ bini, yi mbɨla ndjɨndjɨ me ya tima uo ngaya de. ");
INSERT INTO mdm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kaka-a, ya adje lɨya ne bua bini me ya alo okpála, amba ya tima uo gba yi oo. U anʉ́ bhʉ́ dabɨlɨ bini ne ondaise ya na mʉkʉnda, Balanabasɨ ne Polo. ");
INSERT INTO mdm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Okpála ɨnde aha lɨo libhomu ngʉbula kulu gba Ngámá gba nɨ́ Yesu Kilisito ko. ");
INSERT INTO mdm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kaka-a, ya atima pɨ yi Djude ne uo ne Sila, u akpókpo ndʉ ’ngʉ́ hana ɨnde ya aye e sɨ-e pɨ yi ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Padhá de, anga Bu Bhobua di ne ya makpe-e, ya abhundja me, a ayo naꞌo tili ’ngʉ́ koko pɨ́ yi de, bha bini bhende a ayo me yi mene e ko: ");
INSERT INTO mdm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","yi azʉ́ so ’nʉ ɨnde u abhɵlɵ e pɨ oebhe na eu-o de. Yi azʉ́ ngʉte de. Yi azʉ́ so ’nʉ ɨnde akpi ne ngʉte bhʉ́ e hana-a de. Yi adʉ́ akʉnda olɨsɨ di ne obhosɨ ngangá de. Ɨ dʉ me yi nde alila lɨyi makpe ne ndʉ ’ngʉ́ bhomʉ-o hana-a, bhobhomʉ-o dʉ́ ndjɨndjɨ. Yi dʉ ndjɨndjɨ.» ");
INSERT INTO mdm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Abhomʉ-o, u aha kpadjɨ pɨ uo, u atsia agbida bhʉ́ Atiokia. Oo, u apo bhʉ́la omabhuka hana, u atsia aha balʉa pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","U atanga balʉa-o. Ndʉ uo hana akpi djalɨ naali ka masi ɨnde lɨ balʉa ango-o ato e bhʉ́ uo ko. ");
INSERT INTO mdm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","La-a, lɨ Yuda ne Sila adʉ di lɨe ngao makpe opolofeta-a, u agama ’ngʉ́ pɨ omabhuka ngengele ngʉbula nato masi bhʉ́ uo, di ne naha angu pɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mbo pɨta ’kpɨ́ bedɨ-e, omabhuka atsia aꞌo uo me u gie lɨo ne guo ’ngʉ́ agba okpála ɨnde atima uo ko.  ");
INSERT INTO mdm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Abhomʉ-o, Polo ne Balanabasɨ atigala bhʉ́ Atiokia. U atsia adʉ asuno di ne nakpokpo Bádha Ngali gba Ngámá-a bhʉ́ dabɨlɨ bini, di ne okpála koko bhelé. ");
INSERT INTO mdm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pɨta mbo ’kpɨ́ masudha, Polo apa pɨ Balanabasɨ me: «Nɨ́ gie lɨnɨ́ bhʉ́ ndʉ okʉtɨ hana ɨnde nɨ́ akpokpo nako eli gba Ngámá-a bhʉ́ e-o, amba nɨ́ mbɨla maka lɨ omabhuka nde lɨe oo ko.» ");
INSERT INTO mdm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balanabasɨ adʉ akʉnda me o nʉ bhʉ́ dabɨlɨ bini ne Djaa ɨnde u agisila ’lɨ e me Maloko-o. ");
INSERT INTO mdm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Engʉ́ bini, Polo tsia zɨba naha anɨ de, anga anɨ aꞌo nanɨ ká uo bhʉ́ Pamifilia. Anɨ tsia dʉ di matá namene kulu ne uo bhʉ́ dabɨlɨ bini de. ");
INSERT INTO mdm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","U amene kpekebhɵ sʉnda o naali. Kaka-a, u atsia agbogbo bhʉsʉ o. Abhomʉ-o, Balanabasɨ aha Maloko, u aꞌʉ bhʉ́ zabʉ, u atsia agbida bhʉ́ Sipele. ");
INSERT INTO mdm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɨta lɨ omabhuka ayo lɨe me Polo sia bádha bhʉ́ ’bu gba Ebhe-e , anɨ aha Sila, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Anɨ apʉ bhʉ́ ndu doto na Silia di ne Silisia. Anɨ atsia adʉ nateteke omabhuka na oDadjua gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Abhomʉ-o, Polo akolo bhʉ́ Delebe, pɨpɨta-a, bhʉ́ Lisitele. Mʉkpata bini adʉ nanɨ oo, a adʉ ’lɨ anɨ me Timoté. ’Hi anɨ adʉ ne maYuda ɨnde abhuka Ebhe. Engʉ́ bini, ’dyɨ anɨ nanɨ naae ne Giliki. ");
INSERT INTO mdm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Omabhuka na Lisitele di ne Ikoniomʉ adʉ apa ’ngʉ́ gba anɨ-e ndjɨndjɨ naali. ");
INSERT INTO mdm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Polo adʉ akʉnda me nɨ ha anɨ ngʉ́ nadhʉkʉ bhʉ́ dabɨlɨ bini ne anɨ. Anɨ aha anɨ, anɨ atsia ato anɨ bhʉ́ gandja. Anɨ amene nanɨ mo-o ka omaYuda ɨnde adʉ oo, anga ndʉ okpála hana adʉ ambɨla ndjɨndjɨ me ’dyɨ Timoté nanɨ ne Giliki. ");
INSERT INTO mdm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bhʉ́ ndʉ ogʉdhʉ ɨnde u adʉ apʉ bhʉ́ e hana-a, u adʉ akpokpo pɨ omabhuka lɨ́lɨ ɨnde lɨ obhʉlʉ titima gba Yesu di ne obhelesɨ okpála na Yelusalema aha e-o. U atsia adʉ ayo ka uo me u mene lɨ́lɨ ango-o ko. ");
INSERT INTO mdm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ODadjua gba Ebhe-e adʉ akolo kpekpeke bhʉ́ nabhuka . Alo gba omabhuka atsia adʉ abe ndʉ e ndʉ ’kpɨ́ hana. ");
INSERT INTO mdm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","La lɨ Bu Bhobua ayoko uo lɨe me u akpokpo ’ngʉ́ gba Ebhe bhʉ́ ndʉ doto na Adjia de-e, u atsia apʉ bhʉ́ ndu doto na Filidjia di ne Galatia. ");
INSERT INTO mdm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","U akolo lɨe de ndu doto na Misia-a, u adʉ ale nanʉ bhʉ́ Bitinia. Engʉ́ bini, Bua gba Yesu atsia ayoko uo. ");
INSERT INTO mdm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Abhomʉ-o, u agulu Misia, u atsia akɵ bhʉ́ gʉdhʉ na Tʉlʉasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A akolo lɨe sukpe-e, Polo au engʉ́ maka loto: kpála bini na Makedonia alʉ kala anɨ. Anɨ atsia adʉ akikiliki lɨe pɨ anɨ me: «Kodho ’ngbé ’ngu-o, nʉ bhʉ́ Makedonia, amba mʉ teteke ya!» ");
INSERT INTO mdm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɨta engʉ́ ɨnde lɨ Polo au e, ya agɨlɨ bha kolo má gala me ya anʉ bhʉ́ Makedonia. Padhá de, anga ya ambɨla na paká me Ebhe aꞌɨ ya ngʉ́ nakpokpo Bádha Ngali pɨ okpála na kʉtɨ ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ya aꞌʉ bhʉ́ zabʉ bhʉ́ Tʉlʉasɨ, ya anʉ ngbingbili bhʉ́ Samʉtalasɨ. Lɨ ekpɨ́ aseke lɨe, ya atsia anʉ bhʉ́ Neapolisi. ");
INSERT INTO mdm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ya ayie lɨe oo, ya atsia akolo bhʉ́ gʉdhʉ na Filipoi, gina kʉtɨ na ndu doto na Makedonia ɨnde adʉ sa oLoma-o . Ya amene mbo ekpɨ́ bhelé bhʉ́ gʉdhʉ ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bhʉ́ ’kpɨ́ naguo gba omaYuda-a , ya akoto bhʉ́ gʉdhʉ ngʉ́ nanʉ alɨ ngo ’ngu. Padhá de, anga ya adʉ abhundja me dabɨlɨ gba omaYuda ngʉ́ nayo Ebhe oo. Ya adʉlʉ kuto, ya atsia akpokpo ’ngʉ́ pɨ olɨsɨ ɨnde apɵkɵbhɵ bhʉ́la o oo. ");
INSERT INTO mdm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A adʉ ’lɨ sʉka olɨsɨ ango-o me Lidia. Anɨ ayie nanɨ bhʉ́ gʉdhʉ na Tiatile. Anɨ adʉ nanɨ atsɨndjɨ ombembe obongo na mase naali. Anɨ adʉ nanɨ adhɵgɵ Ebhe. Maka anɨ adʉ adje ya lɨe, Ngámá atsia abhulu bua anɨ ngʉ́ nabhuka engʉ́ ɨnde lɨ Polo adʉ apa e-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Abhomʉ-o, anɨ atsia asia batisimo bhʉ́ dabɨlɨ bini ne piga gba e-o. Pɨpɨta-a, anɨ atsia ayo ka ya me: «Ɨ dʉ me yi nde au me ma abhuka Ebhe kʉkʉlʉ-o, yi de go dʉ gba ma.» Anɨ atsia agbite ya ne kpéke ngʉ́ nazɨzɨba. ");
INSERT INTO mdm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ekpɨ́ bini, ya adʉ anʉ lɨe lɨ bɨlɨ nayo Ebhe-e, ndɨlɨ na ɵɵlɵ bini na kulu ago abhaka ya. Bua na madhoko adʉ bhʉ́ anɨ. Anɨ atsia adʉ asia tɨa pɨ omakʉlasɨ e naali. ");
INSERT INTO mdm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ngaya ne Polo-o, anɨ aholo akpata ya. Anɨ atsia adʉ asʉsʉla me: «Okpála ɨnde-e, a ko okpála na kulu gba Ebhe Apɨ́ ’Kpɨ́! U ngasuno pɨ yi kpadjɨ na mʉkobho.» ");
INSERT INTO mdm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Anɨ amene engʉ́ ango-o ngʉbula ekpɨ́ bhelé. Lɨ engʉ́ ango-o andala Polo lɨe naali-e, anɨ adji lɨe, anɨ atsia apa pɨ bua ango-o me: «Ne ’lɨ Yesu Kilisito , ma apa pɨ mʉ me: koto bhʉ́ anɨ!» Abhomʉ-o, bua na madhoko ango-o atsia akoto bha kolo bhʉ́ anɨ bhʉ́ nedhɨnga ango-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lɨ omakʉlasɨ anɨ au lɨe me o sía matá tɨa ka anɨ de-e, u aholo Polo ne Sila, u atsia agbele uo bhʉ́ mbadhasʉ kala okpála nakodho ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","U atsia anʉ ne uo kala ongámásɨ na Loma, do uo de-e: «Okpála ɨnde-e, a ko omaYuda. U ngato mbedhembedhe bhʉ́ gʉdhʉ gba ya-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","U ngasuno ongʉ́. La-a, lɨ́lɨ gba nɨ́ okpála na Loma zɨba nasia ongʉ́ ango-o ne namemene de.» ");
INSERT INTO mdm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Abhomʉ-o, ndʉ okpála hana atsia abɨ di ’gʉ́ ne uo. Ongámásɨ aha lɨ́lɨ me u pandja bongo lɨ kʉte uo, amba u bhɨ uo ne fimbo. ");
INSERT INTO mdm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pɨta u abhɨ uo lɨe ne fimbo naali-e, u atsia abhike uo bhʉ́ tɨkpʉ. U atsia aha lɨ́lɨ pɨ mʉlila na tɨkpʉ-o me anɨ lila uo ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Lɨ mʉlila asia lɨ́lɨ ango-o lɨe, anɨ ato uo bhʉ́ tɨna tɨkpʉ bhe na tʉtʉ-o. Anɨ atsia atoto ’dhʉ uo bhʉ́ kpɵkpɵ. ");
INSERT INTO mdm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Masɨkpe de tutu sukpe-e, Polo ne Sila adʉ ayo Ebhe di ne nadhɵgɵ anɨ bhʉ́ etsi. Okpála koko na tɨkpʉ-o adʉ adje uo. ");
INSERT INTO mdm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Má gala kolo me-e, doto adyɨkɨ ne adjigidjo na ngbéngbé má djigi djigi, masɨkpe de me tɨkpʉ-o tuko kuto! Ndʉ obhotɨ na tɨkpʉ-o hana akolo abhubhulu lɨe. Ogbɨndjɨlɨ ɨnde u agbigbite ndʉ okpála hana na tɨkpʉ-o ne e-e, atsia abhubhulu di lɨe. ");
INSERT INTO mdm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lɨ mʉlila agbʉngbʉa lɨe lɨe tɨla-a, anɨ au me ndʉ obhotɨ-e hana baba. Abhomʉ-o, anɨ agbe mbotɨa me nɨ ngabhɵlɵ lɨnɨ ne di, anga anɨ adʉ abhundja me ndʉ okpála na tɨkpʉ-o hana akpekpe. ");
INSERT INTO mdm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Engʉ́ bini, Polo atsia asʉla pɨ anɨ kpekpeke me: «Mo oméne lɨmʉ sisiti de, anga ndʉ ya hana bha sɨ!» ");
INSERT INTO mdm_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Abhomʉ-o, mʉlila-a ayo eke, anɨ alɨ kolo má gala abhʉ́ ’tɨ me anɨ nde ngagʉkʉ ka tsʉlʉ má kpi kpi kpi! Anɨ atsia atɨ bhʉ́ li ’dhʉ Polo ne Sila. ");
INSERT INTO mdm_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pɨpɨta-a, anɨ apandja uo kilidjo. Anɨ atsia ayi uo me: «Odyɨ ma, a ayo me ma mene pɨ ngʉbula me ma kobho?» ");
INSERT INTO mdm_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","U atsia agie pɨ anɨ me: «Bhuka Ngámá Yesu, amba mʉ kobho, ngamʉ di ne piga gba mʉ-o hana.» ");
INSERT INTO mdm_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Abhomʉ-o, u atsia akpokpo eli gba Ngámá Ebhe-e pɨ anɨ, di ne pɨ ndʉ okpála hana ɨnde adʉ bhʉ́ ’tɨ gba anɨ-o. ");
INSERT INTO mdm_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bha sukpe bhomʉ-o, mʉlila na tɨkpʉ-o abha uo, anɨ atsia avʉlʉ oeka gba uo-o. Pɨpɨta-a, anɨ asia bha kolo batisimo má gala, bhʉ́ dabɨlɨ bini ne okpála gba e hana. ");
INSERT INTO mdm_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pɨpɨta-a, anɨ anʉ ne uo agba e. Anɨ atsia aha ezʉ pɨ uo. Ngaanɨ ne piga gba e-e, u akpi djalɨ naali, anga u abhuka Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lɨ ekpɨ́ aseke lɨe, ongámásɨ gba okpála na Loma atima okpála me u nʉ pa pɨ mʉlila na tɨkpʉ-o me: «Pandja okpála bhomʉ-o bhʉ́ tɨkpʉ-o, amba mʉ ꞌo uo, u gbida.» ");
INSERT INTO mdm_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Abhomʉ-o, mʉlila atsia ago apa pɨ Polo me: «Ongámásɨ atima eli me ma apandja yi bhʉ́ tɨkpʉ papandja. Yi zeze, amba yi nʉ ne guo ’ngʉ́ .» ");
INSERT INTO mdm_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Do Polo pɨ okpála ango-o me: «Ya ne okpála na Loma! U aha lɨ́lɨ me u bhɨ ya bhʉ́ ká djila okpála me u nde kpokpo ’ngʉ́ lɨ ’ngʉ́ gba ya-a de. U abhike ya bhʉ́ tɨkpʉ. La mbɨa ɨnde-e, u ngakʉnda napandja ya bhʉ́ pepe? Belegʉ de bini, u go gbegbe bha ya ngao makpe!» ");
INSERT INTO mdm_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Okpála ango-o atsia anʉ apa eli ango-o pɨ ongámásɨ na Loma. Lɨ ongámásɨ na Loma adje lɨe me Polo ne Sila a ko okpála na Loma-a, u atsia adje tsʉlʉ. ");
INSERT INTO mdm_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Abhomʉ-o, ongámásɨ ago nakikiliki lɨo pɨ uo. U atsia ayo ka uo me u yie bhʉ́ kʉtɨ ango-o yiyie. ");
INSERT INTO mdm_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lɨ Polo ne Sila aze lɨe bhʉ́ tɨkpʉ-o, u atsia anʉ agba Lidia. Pɨta u au omabhuka lɨe, u ato masi bhʉ́ uo, u atsia agbida. ");
INSERT INTO mdm_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lɨ Polo ne Sila agulu gʉdhʉ na Afipolisi ne Apolonia lɨe, u atsia akolo bhʉ́ gʉdhʉ na Tesalonike. A bhomʉ-o bɨlɨ ɨnde lɨ omaYuda adʉ ne etɨ nadje lɨ́lɨ gba Moidje lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Polo amene maka anɨ amemene lɨe-o. Anɨ adʉ anʉ abhaka uo bhʉ́ ’tɨ nadje lɨ́lɨ-e ngʉbula poso bata bhʉ́ ’kpɨ́ naguo gba omaYuda-o . Anɨ atsia adʉ amene kpekebhɵ ne uo pɨndjɨ Bhuku gba Ebhe-o . ");
INSERT INTO mdm_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Anɨ adʉ abhulu tata pɨ uo mbámbá, di ne nasuno pɨ uo me bhuku apa me a ayo me Kilisito zʉ lɨkabhu, amba anɨ zuku. Anɨ adʉ apa pɨ uo me: «Yesu ɨnde ma ngakpokpo ’ngʉ́ gba e pɨ yi-e, a ko Kilisito ngae.» ");
INSERT INTO mdm_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Okpála koko bhʉ́ ká uo abhuka, u atsia akpata Polo ne Sila. OGiliki bhelé, ɨnde adʉ adhɵgɵ Ebhe-e, amene bhadi moko bhʉ́ dabɨlɨ bini ne bhiti olɨsɨ ɨnde adʉ ne tɨa naali-o. ");
INSERT INTO mdm_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Engʉ́ bini, omaYuda abɨ ’gʉ́ naali. U abha okpála koko na sisiti ɨnde adʉ adjakadha lɨ okpadjɨ, u apɵkɵbhɵ bhʉ́la uo. U agbe tolo bhʉ́ ká okpála, u atsia ato mbedhembedhe bhʉ́ ’ndjɨ okpála bhʉ́ gʉdhʉ. U anʉ nagɨlɨ Polo ne Sila bhʉ́ ’tɨ gba Djasone ngʉbula me o gbe uo kala okpála na kʉtɨ bhomʉ-o. ");
INSERT INTO mdm_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","U bhaka la uo lɨe de-e, u aha Djasone di ne omabhuka koko, u atsia anʉ ne uo kala ongámásɨ. U aholo asʉsʉla me: «Okpála ɨnde angbɨngɨ ’ndjɨ okpála pɨ́la doto libhomu. Mbɨa ɨnde-e, u akolo ɨbili sɨ! ");
INSERT INTO mdm_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Djasone asia uo agba e! Ndʉ uo hana ngayala namene lɨ́lɨ gba ’ngbé ngámá Kaisala . U ngapa me ngámá koko uu! A ’lɨ anɨ me Yesu.» ");
INSERT INTO mdm_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Lɨ bhiti okpála di ne ongámásɨ na kʉtɨ ango-o adje eli ango-o lɨe, bua uo atsia ake. ");
INSERT INTO mdm_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pɨta lɨ Djasone di ne okpála koko akakala lɨo lɨe ka uo, u atsia atse ’kpa lɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A akolo lɨe sukpe-e, omabhuka anʉ aꞌo bha kolo Polo ne Sila bhʉ́ Beloya má gala! U akolo lɨe oo, u atsia alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-o. ");
INSERT INTO mdm_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Okpála ango-o adʉ ne bádha bua nane okpála na Tesalonike. U asia eli gba Ebhe-e ne gʉgʉmʉ naali. Ndʉ ’kpɨ́ hana, u adʉ atsia ’kpɨ́ bhʉ́ Bhuku gba Ebhe ngʉ́ nambɨla me ongʉ́ ango-o, a ko ’ngʉ́ na paká. ");
INSERT INTO mdm_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Abhomʉ-o, okpála bhelé bhʉ́ ká uo atsia abhuka. Olɨsɨ na Giliki ɨnde adʉ ne tɨa naali-e abhuka. Bhiti obhosɨ ɨnde adʉ oo atsia abhuka di. ");
INSERT INTO mdm_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Engʉ́ bini, lɨ omaYuda na Tesalonike adje lɨe me Polo ngakpokpo eli gba Ebhe-e di bhʉ́ Beloya-a, u atsia ago di oo. U ato mbedhembedhe bhʉ́ ká okpála bhomʉ-o, u atsia angbɨngɨ di ’ndjɨ uo. ");
INSERT INTO mdm_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Abhomʉ-o, omabhuka anʉ bha kolo aꞌo Polo me anɨ nʉ alɨ ngo ’ngbé ’ngu. Engʉ́ bini, Sila ne Timoté atsia atigala naao abhʉ́ Beloya. ");
INSERT INTO mdm_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Obhende anʉ naꞌo Polo-o, u akolo ne anɨ bhʉ́ gʉdhʉ na Atene. Pɨpɨta-a, u adʉ agie lɨo lɨe, Polo atsia atima eli me Sila ne Timoté kpata nɨ má gala! U atsia agbida. ");
INSERT INTO mdm_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bhʉ́ nedhɨnga lɨ Polo adʉ adjeke Sila ne Timoté lɨe bhʉ́ Atene-e, anɨ au me gʉdhʉ ango-o abedhe ne oebhe na eu bedhe. Kaka-a, bua anɨ adʉ ne lɨkabhu naali. ");
INSERT INTO mdm_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Abhomʉ-o, anɨ adʉ amene kpekebhɵ ne omaYuda di ne okpála koko ɨnde adʉ adhɵgɵ Ebhe bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje-o. Ndʉ ’kpɨ́ hana, anɨ adʉ amene bhadi moko ne okpála ɨnde anɨ adʉ akɵ lɨe ne o oo. ");
INSERT INTO mdm_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Okpála na ɨmbɨlangʉ koko oEpikulo ne oSatʉa adʉ di agama ’ngʉ́ ne anɨ. Okoko adʉ ayi me: «Bhʉlʉ agɵlɵ ɨnde-e ngapa-e pɨ?» Lɨ okpála koko adje Polo ngakpokpo ’ngʉ́ pɨndjɨ Yesu di ne nazuku ka anɨ-e lɨe, u atsia adʉ apa me: «A amana mʉgɨto me anɨ ngasuno bhomʉ-o oebhe na gandji gandji.» ");
INSERT INTO mdm_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Abhomʉ-o, u aholo anɨ, u anʉ ne anɨ kala okpála ɨnde adʉ atsia ’kpɨ́ lɨ ’ngʉ́ na gʉdhʉ na Atene-o. U adʉ aꞌɨ uo me Alɨopadje. U atsia apa pɨ anɨ me: «Ya tɨ da nambɨla engʉ́ na mbɨa ɨnde mʉ ngasuno e uu? ");
INSERT INTO mdm_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ya akʉnda nambɨla tata-o. Padhá de, anga mʉ ngandala ’dje ya ne ndʉ ’ngʉ́ na gandji gandji.» ");
INSERT INTO mdm_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ndʉ okpála na Atene hana di ne okpála na gandji gandji ɨnde adʉ nadʉ oo, adʉ abhɵlɵ nedhɨnga gba o-o bha lɨ nakpokpo ’ngʉ́ di ne nadje engʉ́ na mbɨa.) ");
INSERT INTO mdm_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Abhomʉ-o, Polo ayie bhʉ́lá tʉ Alɨopadje-o, anɨ atsia apa me: «Ngayi okpála na Atene, ma au me yi kpekpeke lɨ engʉ́ gba oebhe ane ndʉ ’ngʉ́ hana. ");
INSERT INTO mdm_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Padhá de, anga ma adʉ adhʉkʉ lɨe bhʉ́ gʉdhʉ gba yi-e, ma atsia okulu oebhe gba yi-o. Ma au belegʉ bɨlɨ bini ɨnde u ngatsulu enʉ lɨe pɨ Ebhe. U aye tété me: ‹Pɨ ebhe ɨnde ya ambɨla e de.› A moko, ma ago asuno pɨ yi ebhe ɨnde yi ngadhɵgɵ e me yi nde mbɨla e de ko. ");
INSERT INTO mdm_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ebhe ɨnde abho doto di ne ndʉ ’he ɨnde bhʉ́bhʉ́-o hana-a, a ko Ngámá na abhʉ́lá di ne Ngámá na doto. Anɨ dʉdʉ bhʉ́ oetɨ ɨnde lɨ okpála ayiki e ne ’kpa o-o de. ");
INSERT INTO mdm_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Anɨ ne gʉmʉ ade me okpála mene ehe pɨ nɨ-e de, anga anɨ ne gʉmʉ ’he bini ade. Anɨ ngaha mʉkobho, ewo di ne ndʉ ’he koko pɨ ndʉ okpála hana ngae. ");
INSERT INTO mdm_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Anɨ abho kpála bini ɨnde lɨ ndʉ opiga hana aze bhʉ́ e-e ngae. Anɨ atsia abu uo pɨ́la doto libhomu. Anɨ agbo bhʉsʉ kalanga ne gbokokpɨ. Anɨ atsia akokodho okozie lɨ bɨlɨ ɨnde ayo me u sɨlɨ kʉtɨ lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ebhe amene mo-o ngʉbula me okpála gɨlɨ nɨ amba u le nau nɨ, ɨ dʉ me u nde tɨ da nau nɨ uu ko. A na paká me Ebhe de nɨ́ bini ne bini tsutsu ade. ");
INSERT INTO mdm_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Padhá de, anga anɨ ngaha mʉkobho ne angu ngʉ́ namene ehe di ne maka nɨ́ nde lɨe pɨ nɨ́ ngae. La di maka lɨ okpála koko na etsi gba yi-e apa lɨe me: ‹Nɨ́ di ne ongɨsɨ gba anɨ.› ");
INSERT INTO mdm_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","La-a, ka nɨ́ nde lɨe ne ongɨsɨ gba Ebhe-e, a ayo nabhundja de me Ebhe maka ebhe na padhá u abho e lɨ olo, lɨ aladja di ne teme-e de. A ayo la di nabhundja de me Ebhe maka ebhe ɨnde akoto lɨ kulu di ne mabhundja gba kpála-a de. ");
INSERT INTO mdm_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nanɨ-e, okpála dʉ ambɨla Ebhe de. Anɨ tsia matá ’kpɨ́ lɨ nedhɨnga ango-o de. Engʉ́ bini mbɨa ɨnde-e, anɨ ngaꞌɨ ndʉ okpála hana ne ndʉ bɨlɨ hana me u dji bua o. ");
INSERT INTO mdm_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Padhá de, anga anɨ aꞌo ekpɨ́ bini ɨnde anɨ akódho ’ngʉ́ gba okpála na doto libhomu lɨe ngbingbili ko. Anɨ abhʉ kpála bini ɨnde akódho ’ngʉ́ ango-o. Anɨ asuno engʉ́ ango-o pɨ ndʉ okpála hana lɨ nedhɨnga ɨnde anɨ azuku kpála ango-o lɨe ko!» ");
INSERT INTO mdm_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","U adje Polo lɨe apa me okpála ɨnde amu-o azúku mazuku-o, u aholo amʉ anɨ. Okoko atsia apa me: «Ya adjé nga matá mʉ pɨndjɨ ’ngʉ́ ango-o lɨ ’kpɨ́ koko.» ");
INSERT INTO mdm_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Abhomʉ-o, Polo atsia aꞌo ká uo. ");
INSERT INTO mdm_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Abana mo-o, okpála koko azɨba anɨ, u atsia abhuka. Bhʉ́ ká uo adʉ nanɨ Denisi, sʉka okpála na Alɨopadje, ne ɵlɵ bini ɨnde adʉ ’lɨ e me Damalɨsɨ di ne okpála koko. ");
INSERT INTO mdm_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɨpɨta-a, Polo ayie bhʉ́ gʉdhʉ na Atene, anɨ atsia atapa bhʉ́ gʉdhʉ na Kolito. ");
INSERT INTO mdm_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Oo, anɨ abhaka maYuda bini, a adʉ ’lɨ anɨ me Akuila, kpála na ndu doto na Pote. Ngaanɨ-e, anɨ ayie nanɨ bhʉ́ Itali, bhʉ́ dabɨlɨ bini ne wala e Pilisila, anga ’ngbé ngámá Kolode aha nanɨ lɨ́lɨ me ndʉ omaYuda hana ze bhʉ́ Loma maze. Abhomʉ-o, Polo atsia anʉ nabhaka uo. ");
INSERT INTO mdm_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Anɨ adʉ la lɨe amene ngua kulu bini ne uo (u adʉ abho etɨ ɨnde u aꞌɨ e me ’tɨ ngbangbalɨ), anɨ adʉ nadʉ agba uo, u atsia adʉ amene kulu bhʉ́ dabɨlɨ bini. ");
INSERT INTO mdm_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Polo adʉ nasuno eli gba Ebhe-e bhʉ́ ndʉ ’kpɨ́ naguo gba omaYuda hana bhʉ́ etɨ nadje lɨ́lɨ gba Moidje-o . Anɨ atsia adʉ di namene ne kpéke me omaYuda di ne oGiliki zɨba ’li nɨ. ");
INSERT INTO mdm_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lɨ Sila ne uo ne Timoté ayie lɨe bhʉ́ ndu doto na Makedonia, u atsia akolo bhʉ́ gʉdhʉ na Kolito. Polo aha nedhɨnga gba e hana ngʉ́ nakpokpo Bádha Ngali gba Ebhe-e pɨ okpála. Anɨ adʉ asuno pɨ omaYuda me Yesu ne Masɨya . ");
INSERT INTO mdm_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Engʉ́ bini, omaYuda adʉ ayayala, u atsia adʉ di nasobho Ebhe. Abhomʉ-o, anɨ apulu doto lɨ bongo gba e, anɨ atsia apa pɨ uo me: «A ayo me ngʉte gba yi-e, tuko pɨ́ ’ndjɨ yi. A ko matá naama ’ngʉ́ de. Nayie pɨ mbɨa ɨnde-e, ma anʉ́ ɨbili agba ogandji okpála .» ");
INSERT INTO mdm_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Abhomʉ-o, Polo ayie oo, anɨ atsia anʉ agba kpála bini ɨnde lɨ ’lɨ e adʉ me Tito Djusitusi. Kpála ango-o adʉ kpála nadhɵgɵ Ebhe. Kʉtɨ gba anɨ-e adʉ de etɨ nadje lɨ́lɨ gba Moidje-o. ");
INSERT INTO mdm_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipisi, ngámá na etɨ nadje lɨ́lɨ-e, abhuka Ebhe di ne piga gba e libhomu. Okpála bhelé na gʉdhʉ na Kolito adje Polo lɨe, u abhuka, u atsia asia di batisimo. ");
INSERT INTO mdm_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ekpɨ́ bini sukpe-e, Ebhe apa pɨ Polo bhʉ́ ehe maka loto me: «Mo odjé tsʉlʉ de. Engʉ́ bini, dʉ bha nagama ’ngʉ́, mo ondjíli má bulu de. ");
INSERT INTO mdm_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Padhá de, anga ma bhʉ́ dabɨlɨ bini ne mʉ. Kpála bini bú ’kpa e lɨ mʉ ngʉ́ namene mʉ sisiti de, anga okpála gba ma bhʉ́ gʉdhʉ ɨnde-e bhelé.» ");
INSERT INTO mdm_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Abhomʉ-o, Polo asɨ bhʉ́ gʉdhʉ na Kolito oo kalanga bini ne epe madhɨa. Anɨ adʉ asuno eli gba Ebhe-e pɨ ndʉ okpála hana. ");
INSERT INTO mdm_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bhʉ́ nedhɨnga ɨnde lɨ okpála na Loma aꞌo Galio lɨe ngámá na ndu doto na Akai-e, omaYuda adje lɨo bhʉ́ dabɨlɨ bini me o mene Polo sisiti. Abhomʉ-o, u atsia agbe anɨ kala okpála nakodho ’ngʉ́. ");
INSERT INTO mdm_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Do uo de me: «Kpála ɨnde ngagɨlɨ nagbele okpála ngʉ́ nadhɵgɵ Ebhe lɨ kpadjɨ bhende lɨ lɨ́lɨ zɨba e de.» ");
INSERT INTO mdm_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Lɨ Polo di me gama ’ngʉ́ lɨe, Galio atsia apa pɨ omaYuda me: «Ngayi omaYuda-a, ɨ dʉ́ ɨgɨnɨ me kpála ɨnde-e bhɵ́lɵ kpála, anɨ méne di engʉ́ na sisiti naali-e, ma de adje yi ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","La-a, ɨ nde lɨe me yi nde ngamene kpekebhɵ pɨndjɨ oeli ne oꞌɨlɨ di ne lɨ́lɨ gba yi makpe-e, atsia bha-a yi! Ma akʉnda naama nakodho ’ngʉ́ lɨ ngua ’ngʉ́ bhomʉ-o de!» ");
INSERT INTO mdm_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Anɨ atsambala uo lɨ bɨlɨ nakodho ’ngʉ́-o. ");
INSERT INTO mdm_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Abhomʉ-o, ndʉ uo hana aholo Sosetene, ngámá na etɨ nadje lɨ́lɨ gba Moidje, u atsia aholo nabhɨ anɨ bhʉ́ mbadhasʉ lɨ bɨlɨ nakodho ’ngʉ́-o. Engʉ́ bini, Galio adʉ bha au ’ngʉ́ ango-o bhʉ́ djila e padhá. ");
INSERT INTO mdm_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Polo adʉ matá mbo ngengele bhʉ́ gʉdhʉ na Kolito. Pɨpɨta-a, anɨ aꞌo ká omabhuka , anɨ aꞌʉ bhʉ́ zabʉ, anɨ atsia atapa bhʉ́ ndu doto na Silia bhʉ́ dabɨlɨ bini ne Pilisila di ne Akuila. Kala me anɨ ꞌʉ bhʉ́ zabʉ-o, u aka ngaɨza ’ndjɨ anɨ bhʉ́ gʉdhʉ na Sekele, anga anɨ asili nanɨ ndjinga me nɨ aha lɨnɨ pɨ Ebhe. ");
INSERT INTO mdm_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","U akolo bhʉ́ gʉdhʉ na Efeso. Oo, Polo aꞌo ká Pilisila ne Akuila. Anɨ alɨ bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje, anɨ atsia adʉ akpokpo ’ngʉ́ ne omaYuda. ");
INSERT INTO mdm_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","La-a, u ayo ka anɨ lɨe me o dʉ nga matá mbo ne anɨ ngengele-e, anɨ atsia ayala. ");
INSERT INTO mdm_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Engʉ́ bini, nedhɨnga ɨnde anɨ adʉ aꞌe ne enʉ́ lɨe, anɨ atsia apa me: «Ɨ dʉ me Ebhe nde akʉnda-a, ma agó matá agba yi mago.» Anɨ aꞌʉ bhʉ́ zabʉ. Anɨ ayie bhʉ́ gʉdhʉ na Efeso, ");
INSERT INTO mdm_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","anɨ atsia atapa bhʉ́ gʉdhʉ na Sedjale. Oo, anɨ aꞌʉ bhʉ́ gʉdhʉ na Yelusalema ngʉ́ nabhana lɨe pɨ omabhuka. Pɨpɨta-a, anɨ atsia akɵ bhʉ́ gʉdhʉ na Atiokia. ");
INSERT INTO mdm_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anɨ abhue oo mbo ekpɨ́ bedɨ, abhomʉ-o, anɨ atsia atapa. Anɨ agulu ndu doto na Galatia ne ndu doto na Filidjia me anɨ nde ngato masi bhʉ́ omabhuka. ");
INSERT INTO mdm_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","MaYuda bini akolo bhʉ́ gʉdhʉ na Efeso, a adʉ ’lɨ anɨ me Apolosɨ, kpála na gʉdhʉ na Alekɨdjandɨlɨ. Anɨ mbɨla nanɨ nagama ’ngʉ́ ndjɨndjɨ. Anɨ mbɨla di nanɨ Bhuku gba Ebhe-e ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","U asuno nanɨ kpadjɨ gba Ngámá pɨ anɨ ndjɨndjɨ. Anɨ adʉ ne bua na masi, anɨ atsia adʉ akpokpo di ne nasuno engʉ́ pɨndjɨ Yesu ngbingbili. Engʉ́ bini, anɨ ambɨla bha nanɨ naae batisimo gba Djaa-o . ");
INSERT INTO mdm_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Abhomʉ-o, anɨ aholo nakpokpo ’ngʉ́ ango-o bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje. Anɨ dʉ ne tsʉlʉ de. Lɨ Pilisila ne Akuila adje engʉ́ anɨ apa e lɨe, u aha anɨ, u anʉ ne anɨ. U atsia asuno kpadjɨ gba Ebhe-e pɨ anɨ ndjɨndjɨ. ");
INSERT INTO mdm_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pɨpɨta-a, Apolosɨ adʉ akʉnda nanʉ bhʉ́ ndu doto na Akai. Abhomʉ-o, omabhuka ato masi bhʉ́ anɨ, u atsia aye balʉa pɨ omabhuka na ndu doto ango-o me, u sia anɨ ndjɨndjɨ. Anɨ akolo lɨe oo, anɨ ateteke okpála ɨnde abhuka ka bádha bhʉ́ ’bu gba Ebhe-e ndjɨndjɨ naali. ");
INSERT INTO mdm_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Padhá de, anga anɨ adʉ asuno mbámbá ne angu hana bhʉ́ ká djila ndʉ okpála hana me omaYuda lɨ ngbili kpadjɨ ade. Anɨ atsia adʉ apana pɨ uo bhʉ́ Bhuku gba Ebhe-e me Yesu ne Masɨya. ");
INSERT INTO mdm_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nedhɨnga lɨ Apolosɨ adʉ lɨe bhʉ́ gʉdhʉ na Kolito-o, Polo agulu ndu doto na ndʉ ká eta na Adjia, anɨ atsia akolo bhʉ́ gʉdhʉ na Efeso. Anɨ abhaka omʉkpata koko oo. ");
INSERT INTO mdm_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Anɨ atsia ayi uo me: «Yi akolo omabhuka lɨe, yi asia Bu Bhobua uu?» U atsia agie pɨ anɨ me: «Ya adje nga engʉ́ pɨndjɨ Bu Bhobua belegʉ de bini.» ");
INSERT INTO mdm_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Abhomʉ-o, Polo atsia ayi uo me: «Yi asia la mangua batisimo dho?» U agie pɨ anɨ me: «Batisimo bhende gba Djaa ko.» ");
INSERT INTO mdm_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Polo atsia apa pɨ uo me: «Djaa adʉ abatisa okpála ɨnde adʉ azɨba nadji bua o. Anɨ atsia adʉ apa pɨ okpála na Ɨsalaele me: ‹Yi bhuka kpála ɨnde ngago pɨta ma ko.› A akʉnda napa me Yesu.» ");
INSERT INTO mdm_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","U adje engʉ́ bhomʉ-o lɨe, Polo atsia abatisa uo ne ’lɨ Ngámá Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɨpɨta-a, anɨ aꞌo ’kpa e pɨ́ ’ndjɨ uo, u atsia asia Bu Bhobua. U aholo agama ’ngʉ́ bhʉ́ odikongʉ koko di ne nakpokpo ’ngʉ́ maka opolofeta . ");
INSERT INTO mdm_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ndʉ obhosɨ bhomʉ-o hana adʉ masɨkpe de ndjɨkpa ne ká bhisi. ");
INSERT INTO mdm_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Polo adʉ alɨ pɨko bhʉ́ ’tɨ nadje lɨ́lɨ gba Moidje , sʉnda epe bata, anɨ dʉ akpokpo ’ngʉ́ pɨndjɨ Naʉ gba Ebhe-e ne tsʉlʉ de. Anɨ atsia adʉ amene ne kpéke ngʉbula me okpála bhuka Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Engʉ́ bini, okpála koko adʉ ne kpéke ’ndjɨ. U ayala nabhuka . U atsia adʉ apa sisiti ’ngʉ́ lɨ kʉte okpála ɨnde adʉ akpata kpadjɨ gba Yesu-o kala ndʉ okpála hana. Abhomʉ-o, Polo aꞌo ká uo, anɨ anʉ ne omʉkpata-a bhʉ́ ’tɨ balʉa gba Tulanisi. Oo, anɨ atsia adʉ asuno pɨ uo ndʉ ’kpɨ́ hana. ");
INSERT INTO mdm_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Anɨ amene mo-o ngʉbula kalanga bhisi. Abhomʉ-o ndʉ okpála hana na ndu doto na Adjia, omaYuda di ne oGiliki, atsia adje eli gba Ngámá-o. ");
INSERT INTO mdm_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ebhe adʉ amene ongamba ’ngʉ́ na ngbengbengbe pɨ okpála bhʉ́ Polo. ");
INSERT INTO mdm_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kaka-a, okɨtambala di ne obongo ɨnde atʉnʉ lɨe lɨ kʉte Polo-o, u adʉ ago ne di, aꞌoꞌo lɨ kʉte okpála na kuo. Abhomʉ-o, okpála na kuo ango-o adʉ akobho, osisiti bua atsia adʉ di aze bhʉ́ uo. ");
INSERT INTO mdm_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","OmaYuda koko, ɨnde adʉ anʉ lɨ obɨlɨ koko hana ngʉbula napandja osisiti bua bhʉ́ okpála-a, ale di napandja osisiti bua ne ’lɨ Ngámá Yesu. U adʉ apa pɨ osisiti bua ango-o me: «Ma aha lɨ́lɨ pɨ yi ne ’lɨ Yesu, ɨnde lɨ Polo ngakpokpo ’ngʉ́ gba e me, yi zeze.» ");
INSERT INTO mdm_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ongɨsɨ na obhosɨbhosɨ mananɨka gba Seva, sʉka ’ngbé dimandɵ bini gba omaYuda-a adʉ amemene moko. ");
INSERT INTO mdm_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Engʉ́ bini, siti bua-a agie pɨ uo me: «Ma mbɨla Yesu hana. Ma mbɨla la di hana me Polo ne da-ie. Ngayi-e, yi la naayi ne oda?» ");
INSERT INTO mdm_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Abhomʉ-o, kpála ɨnde lɨ siti bua adʉ bhʉ́ e, atɨ pɨ uo ne gbele, angu gba anɨ ane bhende gba uo-o mane. Anɨ amene uo sisiti naali. Kaka-a, u atsia aze bhʉ́ ’tɨ ango-o ndumbu di ne oeka lɨ kʉte o. ");
INSERT INTO mdm_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ndʉ okpála na gʉdhʉ na Efeso hana, omaYuda di ne oGiliki, adje engʉ́ ango-o. Ndʉ uo hana adje tsʉlʉ naali. Abhomʉ-o, u atsia adhɵgɵ ’lɨ Ngámá Yesu. ");
INSERT INTO mdm_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bhiti okpála ɨnde abhuka adʉ ago ambamba ta osisiti ’ngʉ́ ɨnde u amene e ko. ");
INSERT INTO mdm_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bhelé bhʉ́ ká uo adʉ obhʉlʉ mambengʉ. U ago ne obhuku gba o-o, u atsia atsulu kala ndʉ okpála hana. U ako masemase-e lɨe, u atsia au me a akoto olɨ́ falanga kutu ndjɨkpa bhuluvue. ");
INSERT INTO mdm_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Abhomʉ-o, ka angu gba Ngámá-a, eli-e adʉ ayangba, atsia adʉ akolo kpekpeke. ");
INSERT INTO mdm_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pɨta ongʉ́ bhomʉ-o, Polo atsia abhundja me nɨ gulu ondu doto na Makedonia di ne Akai ngʉ́ nanʉ bhʉ́ gʉdhʉ na Yelusalema. Anɨ adʉ apa me: «Ɨ dʉ me ma nde akolo oo, a ayo me ma akolo di bhʉ́ gʉdhʉ na Loma .» ");
INSERT INTO mdm_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Abhomʉ-o, anɨ atima okpála bhisi bhʉ́ ká okpála ɨnde adʉ ateteke anɨ-e, Timoté di ne Elasɨte, bhʉ́ gʉdhʉ na Makedonia. Engʉ́ bini, anɨ atsia adʉ mbo matá naae bhʉ́ ndu doto na Adjia ngʉbula nedhɨnga bedɨ. ");
INSERT INTO mdm_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bha lɨ nedhɨnga bhomʉ-o, tolo na ngbéngbé atsia akoto bhʉ́ gʉdhʉ na Efeso pɨndjɨ kpadjɨ gba Ngámá Yesu-o. ");
INSERT INTO mdm_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kpála bini adʉ oo, a adʉ ’lɨ anɨ me Demetiliusɨ. Anɨ adʉ abho djedje kulu etɨ gba ebhe na ɵɵlɵ Alatemi lɨ teme ɨnde u aꞌɨ e me aladja. Okpála na kulu ango-o adʉ asia tɨa tété naali. ");
INSERT INTO mdm_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Abhomʉ-o, anɨ apo bhʉ́la uo bhʉ́ dabɨlɨ bini ne okpála ɨnde adʉ amene di ngua kulu ango-o. Anɨ atsia apa pɨ uo me: «Ondaise ma, yi mbɨla ndjɨndjɨ me nɨ́ ngakobho ka kulu ɨnde. ");
INSERT INTO mdm_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yi ngauu, yi la di ngadjedje, engʉ́ lɨ Polo ɨnde-e ngamene e-o. Anɨ ngapa me oebhe ɨnde lɨ okpála amene e ne ’kpa-a, a ko oebhe de. Anɨ agbele okpála nganda e bhelé. Anɨ mene mo-o, bha bini bhʉ́ gʉdhʉ na Efeso sɨɨ de, engʉ́ bini, masɨkpe de bhʉ́ ndu doto na Adjia libhomu. ");
INSERT INTO mdm_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Eli ango-o tɨ da nasiti bha bini kulu gba nɨ́-e de, engʉ́ bini, a tɨ da nayaka di sa etɨ gba ’ngbé ebhe na ɵɵlɵ Alitemi. Abhomʉ-o, lɨ okpála ꞌó nadhɵgɵ Alitemi, ebhe na ɵɵlɵ ɨnde lɨ okpála na ndu doto na Adjia di ne pɨ́la doto libhomu ngadhɵgɵ e-o.» ");
INSERT INTO mdm_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lɨ okpála ɨnde adʉ oo adje engʉ́ bhomʉ-o lɨe, u abɨ ’gʉ́ naali. U atsia aholo nasʉsʉla me: «Alitemi gba okpála na gʉdhʉ na Efeso-o ngbéngbé!» ");
INSERT INTO mdm_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Abhomʉ-o, tolo aha gʉdhʉ libhomu. U aholo Gayusɨ, ngauo ne Alisitaluka, okpála bhisi na gʉdhʉ na Makedonia ɨnde adʉ adhʉkʉ bhʉ́ dabɨlɨ bini ne Polo-o. U atsia anʉ ne uo bhʉ́ holo lɨ bɨlɨ lɨ okpála apɵpɵkɵbhɵ bhʉ́la o lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Kaka-a, Polo me nɨ ngakoto kala ndʉ okpála hana, engʉ́ bini, omʉkpata atsia ayoko anɨ. ");
INSERT INTO mdm_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Okpála koko di na ndu doto na Adjia ɨnde adʉ akʉnda anɨ-e, atima eli pɨ anɨ me, ngaanɨ makpe-e, anɨ anʉ́ lɨ bɨlɨ lɨ okpála apɵkɵbhɵ bhʉ́la o lɨe de. ");
INSERT INTO mdm_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lɨ nedhɨnga ango-o, tolo adʉ naali. Abhomʉ-o, okpála dje lɨo de. Okoko adʉ asʉsʉla ne engʉ́ kpi, okoko atsia adʉ di asʉsʉla ne engʉ́ koko. Bhelé na uo dʉ ambɨla ta ’ngʉ́ ɨnde u apɵkɵbhɵ bhʉ́la o ngʉ́ e de. ");
INSERT INTO mdm_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Okpála koko bhʉ́ ká bhiti okpála bhomʉ-o, akpokpo pɨ Alekɨdjandele ɨnde adʉ bhʉ́ ká uo-o, u atsia adyudyo anɨ ne akalanʉ. Abhomʉ-o, anɨ aꞌe ’kpa e bhʉ́lá, ngʉbula nasuno me nɨ ngakʉnda nagama ’ngʉ́ kala okpála. ");
INSERT INTO mdm_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Engʉ́ bini, lɨ okpála ambɨla lɨe me a ko maYuda-a, ndʉ uo hana aholo asʉsʉla bhʉ́ dabɨlɨ bini ngʉbula nedhɨnga masɨkpe de saa bhisi me: «Alitemi gba okpála na gʉdhʉ na Efeso-o ngbéngbé!» ");
INSERT INTO mdm_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Alɨ soso-o, ndɵmbɨ bini na gʉdhʉ ango-o ayoko uo, anɨ atsia apa me: «Ngayi okpála na gʉdhʉ na Efeso-o, ndʉ okpála hana mbɨla ndjɨndjɨ me gʉdhʉ na Efeso ngalila ’tɨ ebhe gba ’ngbé ebhe na ɵɵlɵ Alitemi, di ne kulu anɨ ɨnde ayie nanɨ abhʉ́lá atsia atɨ kuto-o. ");
INSERT INTO mdm_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kpála bini tɨ da nayayala de. Kaka-a, a ayo me yi ꞌo bua yi kuto. Yi améne ’ngʉ́ bhʉ́ holo de. ");
INSERT INTO mdm_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Yi ago ne okpála ɨnde-e ei. Ngauo-o, u zi ’he bhʉ́ ’tɨ ebhe na ɵɵlɵ gba nɨ́-e de. U tsia sobho la di anɨ de. ");
INSERT INTO mdm_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ɨ dʉ me Demetelisi ne okpála na kulu gba e nde ne engʉ́ sʉnda o ne kpála bini-e, a ne oekpɨ́ di ne ongámásɨ ngʉ́ nakodho ’ngʉ́ ango-o. A bhomʉ-o bɨlɨ ɨnde a ayo me u nʉ kpokpo ’ngʉ́ sʉnda o lɨe ko. ");
INSERT INTO mdm_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɨ dʉ me a nde matá ne engʉ́ koko ɨnde a ayo me u gama ’ngʉ́ lɨe, ya apɵ́kɵbhɵ bhʉ́la ya maka lɨ lɨ́lɨ apa lɨe, ya tsia kpókpo ’ngʉ́ tété. ");
INSERT INTO mdm_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Atigala bedɨ me u pa lɨ nɨ́ me, nɨ́ ngaha kpéke ’ndjɨ pɨ okpála lɨ ’ngʉ́ ɨnde akodho ’kpɨ́ nakɨ-o. Padhá de, anga tata lɨ napɵkɵbhɵ bhʉ́la nɨ́ me-e ade. Nɨ́ tɨ la di da nakpokpo ’ngʉ́ tété pɨ okpála ndjɨndjɨ de.»  ");
INSERT INTO mdm_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lɨ tolo andjia lɨe, Polo aꞌɨ omʉkpata-o, anɨ atsia ato masi bhʉ́ uo. Pɨpɨta-a, anɨ abhana lɨe pɨ uo, anɨ atsia atapa bhʉ́ ndu doto na Makedonia. ");
INSERT INTO mdm_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Anɨ agulu ndu doto ango-o, anɨ ato masi bhʉ́ omabhuka ne oeli bhelé. Pɨpɨta-a, anɨ atsia akolo bhʉ́ ndu doto gba oGiliki. ");
INSERT INTO mdm_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Oo, anɨ asɨ epe bata. Lɨ nedhɨnga ɨnde anɨ adʉ akʉnda lɨe naha ’ngbé zabʉ ngʉ́ nanʉ bhʉ́ ndu doto na Silia, anɨ adje me omaYuda apo bhʉ́la o ngʉ́ namene nɨ sisiti. Abhomʉ-o, anɨ atsia au ndjɨndjɨ me nɨ gie lɨnɨ, amba nɨ pʉ ne abhʉ́ ndu doto na Makedonia. ");
INSERT INTO mdm_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Okpála ɨnde adʉ nanɨ adhʉkʉ ne anɨ bhʉ́ dabɨlɨ bini-e, adʉ nanɨ: Sopatolosɨ, ndɨlɨ gba Pilusi, kpála na gʉdhʉ na Beloya; Alisitaluka ngauo ne Sekundusi, okpála na gʉdhʉ na Tesalonike; Gayusɨ, kpála na gʉdhʉ na Delebe, ne uo ne Timoté; Tisike ngauo ne Tolofime, okpála na ndu doto na Adjia. ");
INSERT INTO mdm_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Okpála bhomʉ-o agbida kalanʉ, u atsia adʉ adjeke ya bhʉ́ gʉdhʉ na Tʉlʉasɨ. ");
INSERT INTO mdm_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Engʉ́ bini, ngaya-a, ya aha ’ngbé zabʉ bhʉ́ gʉdhʉ na Filipoi. Pɨta anokomɨa nazʉ mapa ɨnde lɨ levile nde bhʉ́ e ade-e , ya atsia anʉ abhaka uo bhʉ́ gʉdhʉ na Tʉlʉasɨ, pɨta ekpɨ́ bhuluvue. Oo, ya asɨ poso bini. ");
INSERT INTO mdm_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Bhʉ́ ’kpɨ́ kulu madhɨa tagolo-o, ya apo bhʉ́la ya ngʉ́ nazʉ mapa-o. Polo adʉ agama ’ngʉ́ pɨ uo, anga anɨ adʉ akʉnda nanʉ pɨta ’kpɨ́ ango-o. Anɨ atsia agama ’ngʉ́ ngengele akolo tutu sukpe. ");
INSERT INTO mdm_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ya apo bhʉ́la ya bhʉ́ tɨna ’tɨ bhende na abhʉ́lá-o. Oo, oeke adʉ bhelé. ");
INSERT INTO mdm_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Makombi bini, a adʉ ’lɨ anɨ me Etikusi, anɨ adʉ lɨ malilisa. Lɨ Polo adʉ la lɨe agama ’ngʉ́ ngengele-e, anɨ atɨ ne ela má kolio! Abhomʉ-o, anɨ atsokodho abhʉ́lá bhʉ́ tɨna ’tɨ na bata-a, anɨ atsia atɨ kuto má kpu! U aꞌe bha ɨbili anɨ me anɨ nde akpi. ");
INSERT INTO mdm_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Polo akɵ, anɨ angumba pɨ́ anɨ, anɨ aha anɨ, abɨ anɨ sa ’kpa e. Anɨ atsia apa me: «Yi adjé tsʉlʉ de. Anɨ kpi de.» ");
INSERT INTO mdm_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pɨpɨta-a, Polo agie matá lɨe abhʉ́lá, anɨ aha mapa-o, anɨ agʉmʉ, anɨ atsia azʉ. Abhomʉ-o, anɨ agama matá ’ngʉ́ ngengele akolo bhʉ́ sɨkɨkpɨ. Pɨpɨta-a, anɨ atsia atapa. ");
INSERT INTO mdm_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","La-a, pɨ makombi bhomʉ-o, u anʉ ne anɨ me anɨ nde ʉʉ. Engʉ́ bhomʉ-o ateteke okpála naali. ");
INSERT INTO mdm_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ya ayie kalanʉ, ya aha ’ngbé zabʉ ngʉ́ nanʉ bhʉ́ gʉdhʉ na Asosa. A bhomʉ-o bɨlɨ ɨnde a ayo lɨe me ya ha Polo bhʉ́ ’ngbé zabʉ-o. Padhá de, anga anɨ apa pɨ ya mo-o ngae me, nɨ anʉ́ naanɨ ne ’dhʉ nɨ. ");
INSERT INTO mdm_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Anɨ ago abhaka ya lɨe bhʉ́ gʉdhʉ na Asosa-a, ya aha anɨ bhʉ́ ’ngbé zabʉ, ya atsia atapa bhʉ́ gʉdhʉ na Mitilene. ");
INSERT INTO mdm_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lɨ ekpɨ́ aseke lɨe, ya ayie oo, ya akolo bhʉ́la kpɵmɵ na Kio. Ekpɨ́ na bhisi-e, ya akolo bhʉ́ kpɵmɵ na Samosɨ. Ekpɨ́ na bata-a, ya atsia akolo bhʉ́ gʉdhʉ na Milete. ");
INSERT INTO mdm_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Polo abhundja me nɨ lʉ́ bhʉ́ gʉdhʉ na Efeso de. Padhá de, anga anɨ dʉ akʉnda de me nɨ bhue bhʉ́ ndu doto na Adjia ngengele-e de. Anɨ adʉ agbene lɨe ngʉbula me, ɨ dʉ me nedhɨnga nde u-o, nɨ de dʉ bhʉ́ gʉdhʉ na Yelusalema bhʉ́ anokomɨa na Patekote . ");
INSERT INTO mdm_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lɨ Polo adʉ lɨe bhʉ́ gʉdhʉ na Milete-e, anɨ atima okpála bhʉ́ gʉdhʉ na Efeso me u nʉ ꞌɨ obhelesɨ okpála na Dadjua gba Ebhe-o. ");
INSERT INTO mdm_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","U akolo lɨe de anɨ-e, anɨ atsia apa pɨ uo me: «Yi mbɨla maka ma adʉ nadʉ lɨe bhʉ́ ká yi, nayie lɨ ’kpɨ́ ma akolo lɨe bhʉ́ ndu doto na Adjia hana. ");
INSERT INTO mdm_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ma amene kulu gba Ngámá me ma nde akɵ lɨma ne kuto. Ma adʉ aku ’gbá, ma atsia adʉ di adje lɨkabhu ka lɨ omaYuda adʉ adje lɨo lɨe ngʉ́ namene ma sisiti-o. ");
INSERT INTO mdm_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Yi mbɨla hana me ma wo ’he bini ɨnde ɨ tɨ da nadʉ pɨ yi ndjɨndjɨ-e belegʉ de bini. Ma akpokpo Bádha Ngali gba Yesu-o. Ma atsia asuno la di pɨ yi mbámbá bhʉ́ ká okpála, ne bhʉ́ oetɨ gba yi-o. ");
INSERT INTO mdm_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ma apa pɨ omaYuda di ne oGiliki me u dji lɨo pɨ Ebhe, amba u bhuka Yesu Ngámá gba nɨ́ ko. ");
INSERT INTO mdm_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mbɨa ɨnde-e, ma adji bhʉ́ gʉdhʉ na Yelusalema maka lɨ Bu Bhobua aha lɨ́lɨ mʉma lɨe ngʉ́ namemene ko. Ma mbɨla de me abháka ma oo ne mangua ’ngʉ́ dho-ie de. ");
INSERT INTO mdm_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ma ambɨla bha bini me Bu Bhobua ngapa mʉma me bhʉ́ gʉdhʉ bini ne bini-e, tɨkpʉ di ne lɨkabhu ngadjeke ma. ");
INSERT INTO mdm_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","La-a, mʉkobho gba ma makpe-e, bhʉ́ djila ma ngbéngbé ade. Padhá de, anga ma akʉnda namene kulu ɨnde lɨ Ngámá Yesu aha e mʉma-a, akólo bha bini alɨ soso: nakpokpo Bádha Ngali na bádha bhʉ́ ’bu gba Ebhe ko. ");
INSERT INTO mdm_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ma apʉ bhʉ́ okʉtɨ gba yi, ma akpokpo ’ngʉ́ pɨndjɨ Naʉ gba Ebhe . Engʉ́ bini mbɨa ɨnde-e, ma ambɨla me yi ú matá ma de. ");
INSERT INTO mdm_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kaka-a, ma apa pɨ yi nakɨ me: ɨ dʉ me kpála bini bhʉ́ ká yi nde angɨta-a, a ko matá naama ’ngʉ́ de. ");
INSERT INTO mdm_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Padhá de, anga ma akpokpo ndʉ ’ngʉ́ gba Ebhe-e pɨ yi hana. Ma wo engʉ́ belegʉ de bini. ");
INSERT INTO mdm_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Yi lila lɨyi ngayi makpe, di ne ndʉ piga hana