﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcu_vpl;
CREATE TABLE mcu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcu_vpl WRITE;
INSERT INTO mcu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hên né dɔ̀gɔ̀tì bɔ̀ nùàr Yeésò *Kristò. À né *ndùté ndùtù Davîd; Davîd né ndùté ndùtù Abrahâm. ");
INSERT INTO mcu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahâm né tele Isâk; Isâk né tele Jakɔ̂b; Jakɔ̂b né tele Júdà bɔ́ bɔ̀ bei mé bɔ̀ dìm seèn; ");
INSERT INTO mcu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Júdà né tele Farésà bɔ̂ Jará, meí bɔɔ̀n né Tàmár. Farésà né tele Eserɔ̂m; Eserɔ̂m né tele Àrâm; ");
INSERT INTO mcu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Àrâm né tele Aminádàb; Aminádàb né tele Násɔ̀ŋ; Násɔ̀ŋ né tele Salomɔ̂ŋ; ");
INSERT INTO mcu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomɔ̂ŋ né tele Boájà; meì Boájà né Rahâb; Boájà né tele Obêd; meì Obêd né Rût; Obêd né tele Jésè; ");
INSERT INTO mcu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jésè né tele mgbè Davîd. Davîd né tele Salomɔ̂ŋ; meì Salomɔ̂ŋ lé naâ veèh Yurî; ");
INSERT INTO mcu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ̂ŋ né tele Roboâm; Roboâm né tele Abíà; Abíà né tele Àsâf; ");
INSERT INTO mcu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Àsáf né tele Jósáfà; Jósáfà né tele Jorâm; Jorâm né tele Osíà; ");
INSERT INTO mcu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osíà né tele Joátàm; Joátàm né tele Àkásà; Àkásà né tele Èsékià; ");
INSERT INTO mcu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Èsékià né tele Manasê; Manasê né tele Amɔ̂ŋ; Amɔ̂ŋ né tele Josiâ; ");
INSERT INTO mcu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiâ né tele Jekoniâ bɔ́ bɔ̀ dìm seèn. Sâ né nàm mé bɔ́ lé sie njií naâ bɔ̀ *Iserálà bɔ̀ ké Babilɔ̂n teèn. ");
INSERT INTO mcu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bɔ́ yeé sie njií gi aá bɔ̀ Iserálà bɔ̀ ké Babilɔ̂n sâ, Jekoniâ ŋar Sabatiêl; Salatiêl né tele Sorobábèl; ");
INSERT INTO mcu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobábèl né tele Abiúdà; Abiúdà né tele Elíákìm; Elíákìm né tele Asôr; ");
INSERT INTO mcu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asôr né tele Sàdɔ̂g; Sàdɔ́g né tele Akìm; Akìm né tele Eliyúdà; ");
INSERT INTO mcu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyúdà né tele Eleasâr; Eleasâr né tele Matám; Matám né tele Jakɔ̂b; ");
INSERT INTO mcu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakɔ̂b né tele Josêf siì Marî. Marî né meì Yeésò. Bɔ́ Yeésò yilá cu né *Nùà Cɔ̀ŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yuoô ké jomo yoòr Abrahâm, nde ba mé Davîd né bɔ̀ mbei ŋaàr yulà cùɔ̀b nèà; yuo cuù mé Davîd, nde ba lè nàm mé bɔ́ lé sie njií naâ bɔ̀ huaán Iserálà ké Babilɔ̂n teèn sâ, né mbei ŋaàr yulà cùɔ̀b nèà; yuoò teèn sâ, nde wa mé ŋaàr Yeésò Nùà Cɔ̀ŋ, né cu mbei ŋaàr yulà cùɔ̀b nèà ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bɔ́ lé ŋaár naâ Yeésò Kristò faá bèh mân: Meí seèn Marî lé naâ veèh Josêf; sâ bɔ́ sua kwaá née bú lòù ye. À ŋene, à baá mé lèì, sâ à née siíb kɔ́ ŋgwéeh ye; Cúcuí Ŋagâ lé ménâ bɔɔ́ naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josêf si seèn lé naâ nùà dùlà-Càŋ. À yeé ŋene aá ménâ, à gwàn ŋgwéh bú cie tueé sɔɔ̀m, à kaga lom aá ndòn, ye nyí nde né bú lè nábe ŋgɔɔ́n lɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","À yeé baá ménâ munó den, cìlì Càŋ Nùà Dueè ŋené yuo kelà toò seèn lè vuû, ye bú a: «Josêf, ndùté ndùtù *Davîd, té vèh. Wèh veèh yeè Marî doô weèh; à ma mé lèì hueêh ŋa né mé terreb Cúcuí Ŋagâ. ");
INSERT INTO mcu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","À nde né huaán dé siîb ŋar, wò yilá bú Yeésò, à yili sɔm nde né dàm bɔ̀ dé seèn te veên bɔɔ̀n kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá Càŋ lé tueé keéh naâ sònò sòn-seèn déì nɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Mbò yàgà déì nde né lèì weh, à ŋar huaán dé siîb, bɔ́ yilá bú Èmánuèl.» Èmánuèl sâ tueé né ye: Càŋ baá ká lètenè beèh. ");
INSERT INTO mcu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josêf nyimé yuoô ndɔ, à bɔɔ́ faá cìlì Càŋ Nùà Dueè tueé naâ bú nɔ: bɔ́ colo haá bú veèh seèn. ");
INSERT INTO mcu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bɔ́ bú ka ndagá bílí ŋgwéh, méménâ tɔ́g Marî yeé ŋar aá, Josêf yilá huaán Yeésò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bɔ́ lé Yeésò ŋaár naâ ké Betelehem, te tàbè Judê; cu sâ *Herôde lé naâ mgbè teèn kɔɔ́. Bɔ̀ fém bɔ̀ déì yuoô gè Bà, bɔ́ wa ké Jerusalem, ");
INSERT INTO mcu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","bɔ́ bie ye: «Bɔ́ lé Mgbè bɔ̀ *Jûf ŋaár naâ he wa? Béh lé ŋene kɔɔ̀ naâ mé mbentò seèn gè Bà; béh hên ndeè né bú die weh.» ");
INSERT INTO mcu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te mgbè Herôde yeé nde ŋgweé njií mân, feh ŋellé bú ter, mé bɔ̀ Jerusalem bɔ̀ mene; ");
INSERT INTO mcu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","à yilá bilí bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù te tàbè seèn dɔɔ́ŋ, à bie njií mé bɔ́, ye bɔ́ a: «Bɔ́ lɔ ye, bɔ́ ndeè *Nùà Cɔ̀ŋ sâ ŋar nde né he wa?» ");
INSERT INTO mcu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bɔ́ ye bú a: «Bɔ́ lɔ ye, bɔ́ ndeè bú ŋar nde né ká te tàbè Judê hên lè lɔɔ́ Betelehem mà. *Sòn-Càŋ lé nyagá kwaá naâ te mvù ménâ kɔɔ́, ye: ");
INSERT INTO mcu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betelehem, wò jie né mbaá lètenè bɔ̀ lɔɔ́ kokoô te tàbè Judê dɔɔ́ŋ, Mgbè Dueè yuo ndeè né beè yeè, te à feh dàm bɔ̀ nùàr mò *Iserálà ceér.» ");
INSERT INTO mcu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mgbè Herôde yeé ŋgweé gi aá ménâ, à yilá nab njiî bɔ̀ fém bɔ̀ doô ká toò seèn, te à bie ŋgweé nyegé sònò bɔɔ̀n cu mé mbentò sâ lé ba duɔɔ́m naâ teèn. ");
INSERT INTO mcu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jomo sâ à ye bɔ́ a: «Bí ndé-re, né ké Betelehem; bí fɔ́n nyégé ká huaán sâ bagasé, mɔ bí ŋene aá bú, bí cuù, bí tueé keéh mè teèn; te mè nde ké toò seèn mé feh mò ménâ cemmé weh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mgbè Herôde yeé tueé gi aá bɔ́ mân, bɔ́ sɔm gò. Bɔ́ ke mbentò mé bɔ́ lé ŋenè naâ gè Bà doô baá cu toò bɔɔ̀n baá kelá; bɔ́ né ndeé, à né ka méménâ baá ndeé den. Bɔ́ yeé wa baá ké teèn, mbentò ba njebá le ké ter felè gwà mé huaán né teèn. ");
INSERT INTO mcu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bɔ́ yeé ŋene kɔ aá ménâ, vràb die, yo taré ŋellé bɔ́ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bɔ́ samé yila nde gwò, bɔ́ ŋene njií huaán bɔ̂ meí seèn Marî, bɔ́ cemmé nde gi doó toò huaân, bɔ́ komó lɔgɔ́ bɔ̀ ba bɔɔ̀n, bɔ́ haá bele bú bɔ̀ njèh huaân feh hihiné, bɔ̀ goó, bɔ̀ san, mé bɔ̀ kómó múmû. ");
INSERT INTO mcu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jomo sâ vuú kulu bɔ́ ndɔ, Càŋ ye bɔ́ a: «Mɔ bí baá mé gò lɔɔ̂, bí té ké yoòr Herôde kélá cú.» Yeé baá ménâ, bɔ́ kela seér baá-re ceér dé hiîn, bɔ́ nde cu lɔ bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bɔ̀ fém bɔ̀ doô yeé nde gi aá, cìlì Càŋ Nùà Dueè nde ŋené yuo kela cuù ké toò Josêf lè vuû, ye bú a: «Wùò ter, wèh huaán bɔ̂ meí, bí bɔ́ dùlà ndé ké Ejíptò, bí den den ké sâ, kɔ mè tueé cu aá wò kɔɔ́, bí cu cuù ye; wanɔɔ́ŋ Herôde nde aá huaán fɔɔ́n, te à wula sɔm bú.» ");
INSERT INTO mcu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josêf komo wuo ter kwar ndɔ, à weh huaán bɔ̂ meí, bɔ́ bɔ́ dula ŋaga cíbíteèn, bɔ́ fɔɔ́n gò Ejíptò. ");
INSERT INTO mcu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bɔ́ ké teèn cer den ka ménâ, tɔ́g nde wa mé cio Herôde. Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá Càŋ Dueè lé tueé keéh naâ sònò sòn-seèn déì nɔ, ye: «Mè yilá sɔm aá huaán mò ké Ejíptò kèn.» ");
INSERT INTO mcu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herôde yeé ŋgweé bɔ̀ fém bɔ̀ pɔ lɔ aá bú ménâ, temé bɔgɔ́ ŋaâ bú ká jomo lè. À tema njií ye bɔ́ ndé kɔ̀rè wúlá gí bɔ̀ huaán dé sisiîb ké Betelehem mé kukwarè mene dɔɔ́ŋ, wa bɔ́ dùɔ̀m mé bɔ̀ huaán mbembɔgɔ̀, nde wa mé bɔ̀ huaán dé nyèmà fèfà ma. À lé sâ taáŋ naâ mé nyèmà mbentò, mé bɔ̀ fém bɔ̀ lé tueé naâ bú doô. ");
INSERT INTO mcu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sâ dɔɔ́ŋ yuo gi né faá Jeremî *sòn-Càŋ lé naá giì tueé kwaá nɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Kéŋ baá ké Rámà silí, mbà né lom ter jɔgɔ́r ŋaá. Né Ràchêl yueé den né bɔ̀ ŋuna. Ye bɔ́ yì nyí be, bɔ̀ huaán nyî kuú gi aá, nùàr té nyí bɔ̀ŋ gùm dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herôde yeé kuú aá, cìlì Càŋ Nùà Dueè nde ŋené yuo kela cuù ké Ejíptò toò Josêf lè vuû, ");
INSERT INTO mcu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ye bú a: «Wùò ter, weh huaán bɔ̂ meí, bí bɔ́ cu cu ké *Iserálà; bɔ̀ɔ́ mé lé gwaán naâ huaán wulâ doô kuú gi aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josêf komo wuo ter ndɔ, weh huaán bɔ̂ meí, bɔ́ bɔ́ cu cu ké lè tàbè Iserálà. ");
INSERT INTO mcu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wa ké teèn, à ŋgweé njií ye Arkelayúsè né ké Judê te kɔgɔ Herôde tele seèn kɔɔ́. Veéh sie bú, à gwàn cú ké teèn ceèr. Yeé baá mân, vuú feh bú ceér, à nde cer seér ké Galilê ");
INSERT INTO mcu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","te lɔɔ́ Najarêt. Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá bɔ̀ sòn-Càŋ bɔ̀ lé tueé naâ nɔ, ye: «Bɔ́ yilá nde né bú nùà Najarêt.» ");
INSERT INTO mcu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nde nde, Jâŋ Bàptîs ŋené yuo kelà ké ya dueè te tàbè Judê, à né ŋgòr Càŋ teèn tueé, ye bɔ̀ nùàr a: ");
INSERT INTO mcu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Bí yúé fɔ́n feh biì yueè, bí kwéh sér temé. Càŋ baá mbàm seèn ká kwarè biì si njiî.» ");
INSERT INTO mcu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jâŋ né nuaá mé Esáyà *sòn-Càŋ lé naâ felè seèn tueé ye: «Hueh nuaré déì né ké ya dueè ŋgulí den, ye: Bí tɔ́ nyégé ceér Nùà Dueè tɔɔ̀, bí tɔ́ dìlì nyégé bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Cɔ̀gɔ̀ Jâŋ lé naâ mé yúlí ŋgelobà, à ké teneè cam tena né mé kàndá paàr mân; yáb seèn lé naâ kètàr mé nyuií. ");
INSERT INTO mcu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bɔ̀ Jerusalem bɔ̀ lé naá giì yoòr seèn kem ndeé, mé bɔ̀ nùàr te tàbè Judê sâ dɔɔ́ŋ. Bɔ̀ɔ́ mé né ké kwarè nòmò Jurdên dɔɔ́ŋ kem nde gi ké yoòr Jâŋ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bɔ́ né veên bɔɔ̀n cie tueé sɔm, Jâŋ né bɔ́ dùà Jurdên kou den. ");
INSERT INTO mcu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jâŋ yeé ke, bɔ̀ *Farisiên bɔ́ bɔ̀ *Sadusiên baá ká yoòr seèn bèh nòmò koù kem ndeê ndɔ, à ye bɔ́ a: «Bí bɔ̀ gèh ŋgòbò, neì ye bí a, temé né Càŋ mé bí lè yulá, bí dùlà ndê, wanɔɔ́ŋ bí nde né gèr beè seèn ŋené wa? ");
INSERT INTO mcu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sâ bí bɔ́-re faá Càŋ gwaán nê nɔ, te feh keéh ye, kènê bí kweéh seér aá temé kèn. ");
INSERT INTO mcu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bí té mé huún biì mbaá mùnò kú, ye: Abrahâm, tele beèh dé koô né teèn. Bí kɔ́ɔ ye, Càŋ né mé terreb bɔ̀ taá hên kwellé seêr, te ŋa bɔ̀ ndùté ndùtù Abrahâm. ");
INSERT INTO mcu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mè tueé bí, mbɔ̀gɔ̀ fa gi aá kèn, baá gi ka toû. Toú mé tàb dé bagaà wá ŋgwéh dɔɔ́ŋ, bɔ́ nde né bú tuar komo fuú njií. ");
INSERT INTO mcu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mè bí kou lom né dé mò mé nòmò, te feh keéh ye bí baá temé kweéh seér. Nuaré déì baá jomo mò ndeê, taré kela né bú mé mè. Né mene débágá seèn, mè wúlú ŋgwéh nuaá mé nde né bú débágá seèn huaár. À bí dé seèn kou nde né mé Cúcuí Ŋagâ bɔ̂ we. ");
INSERT INTO mcu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","À beè né mé suúŋ, à nde né mvum bɔ̂ tùlù mé njéh nyegé geé; à nde né mvum ter te mbèŋ kwaá, à tùlù kobo su njií ké tuar te we mé nyímé bèh.» ");
INSERT INTO mcu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jomo sâ Yeésò yuoô ké Galilê, à nde ké dùà Jurdên, te Jâŋ kou bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wa ké teèn, Jâŋ berɔ́ŋ ye bú a: «Wò sé la kou seér naâ mè kɔɔ́, wanɔɔ́ŋ mè mò wò kou nde né naàn wa!» ");
INSERT INTO mcu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mé njéh mene, Yeésò ye bú a: «Né dé kènê; gwàn ŋgɔ́gɔ yeè gwaàn. Kɔ béh bɔɔ́ gi ka ménâ dɔɔ́ŋ, te yuo ye faá Càŋ gwaán nê nɔ.» Yeé baá ménâ, Jâŋ gwaán ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","À yeé kou sɔm aá bú, Yeésò yuo kela cuù ká cie. À yeé ke, vulú gulu lɔgɔ́ baá ké ter, à ŋene njií Cúcuí Càŋ baá ké ter faá vɔgɔb nɔ suagâ, waà die felè seèn. ");
INSERT INTO mcu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hueh déì né ké jomo te vulúu ŋgulí, ye: «Hên né huaán yíé-temê mò; temé mò né lè mé bú nɔré.» ");
INSERT INTO mcu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jomo sâ, Cúcuí Ŋagâ weh njií Yeésò ké ya dueè te *Sátàn tab bú mé veên. ");
INSERT INTO mcu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","À sɔɔ́ ké teèn cieé yulà nèà, cibí yulà nèà ndɔ; à njeré déì sònò nágá kéh ŋgwéh. Jomo sâ, cùè yeé baá bú sie, ");
INSERT INTO mcu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","táhòrò doô ŋgoró nde ké kwarè seèn, ye bú a: «Mɔ wò né ka Ŋunà Càŋ bɔ̀n, jɔ̀gɔ̀ júé ke ye bɔ̀ taá hên a, ŋá ke sér ye.» ");
INSERT INTO mcu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeésò ye bú a: «Né te mvù Càŋe nyagá den ye: Nùàr mé ndândaà sêr yìlì lòm ndé ŋgwéh, à yili seér nde né mé ŋgòr mé yuo giì né sònò Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yeé baá ménâ, táhòrò doô weh njií bú te lɔɔ́ joloò, à weh ŋaá mé bú ké te ndɔ́ŋ gwà Càŋ koô, ");
INSERT INTO mcu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ye bú a: «Mɔ wò né ka Ŋunà Càŋ bɔ̀n, sâ lɔ́ súágá ké doó lòù; né gi te mvù Càŋe nyagá den ye: Càŋ nde né bɔ̀ cìlì seèn felè yeè tueé, te bɔ́ kwa sie wò teter, gule yeè te taá déì cén cú.» ");
INSERT INTO mcu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeésò ye bú a: «Né te mvù Càŋe nyagá den ye: Té Càŋ Dueè Nùà koô yeè sòn félá.» ");
INSERT INTO mcu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sátàn nde weh ŋaá cu mé bú ké te ndɔ́ŋ tòr déì dàbsé mân. Wa ké teèn, à feh laré bú lò nùàr ká doó dɔɔ́ŋ mé ŋgùlù bɔɔ̀n mene, ");
INSERT INTO mcu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ye bú a: «Mɔ wò cemmé né ka mò, wò né mè die, sâ mè bɔ̀ njií hên dɔɔ́ŋ haá gi nde né mé wò.» ");
INSERT INTO mcu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeésò ye bú a: «Yùò doó sâ nɔɔ́ŋ, Sátàn. Né gi te mvù Càŋe nyagá den ye: Cémmé cégé toò Càŋ Dueè Nùà koô yeè, wò die lom bú.» ");
INSERT INTO mcu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sátàn kwaá lɔɔ́ bú ndɔ. Bɔ̀ cìlì Càŋ waà, bɔ́ taré cu bú yo. ");
INSERT INTO mcu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yeésò ŋgweé njií ye Jâŋ baá gwà cibì ndɔ. À yeé ŋgweé aá ménâ, à sɔm gò, à nde ké Galilê. ");
INSERT INTO mcu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","À kwaá lɔɔ̀ Najarêt, à nde cer den ké Kapernahûm; lɔɔ́ sâ né ké sòn tub Galilê mân, né te gwèn tàbè Jebulɔ̂ŋ bɔ̂ Naftalî. ");
INSERT INTO mcu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá Esáyà *sòn-Càŋ lé naâ tueé nɔ ye: ");
INSERT INTO mcu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Lò Jebulɔ̂ŋ, lò Naftalî, mé né nòmò koô lemé, mé nòmò Jurdên né ká jomo doô, mè jue né Galilê tàbè bɔ̀ kurû, ");
INSERT INTO mcu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","bɔ́ né gi te cibî cer den, bɔ́ nde né meì bɔ̀ ŋagâ ŋené. Ŋagâ te lò bɔ̀ cio bɔ̀ waà baá kèn.» ");
INSERT INTO mcu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yeésò lé ŋgòr Càŋ tueé duɔɔ́m naâ cu sâ, ye bɔ̀ nùàr a: «Bí yúé fɔ́n feh biì yueè, bí kwéh sér temé. Càŋ baá mbàm seèn ká kwarè biì si njiî.» ");
INSERT INTO mcu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cieé déì Yeésò yeé baá ké sòn tub Galilê, à né sòn nòmò bele ndeé, à ŋene njií nuaré déì bɔ̂ dìm né ndoór ké dùà vuú njií den. Lé naâ bɔ̀ sìè-ŋgò bɔ̀ Simɔ̂ŋ, mé yilí seèn déì né cu Piêr, bɔ̂ dìm seèn Andrê. ");
INSERT INTO mcu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeésò ye bɔ́ a: «Bí bèlè mè; mè bí kènê sie kwaá seér nde aá bɔ̀ kòrò nùàr.» ");
INSERT INTO mcu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bɔ́ vu njií ndoór doó lè sòn Yeésò, bɔ́ yuo bele bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","À né ka ndeé. Wa beré déì, à ŋene njií cu bɔ̀ fà bɔ̀ déì, Jâk bɔ̂ dìm seèn Jâŋ; né bɔ̀ ŋunà Jebedê. Sâ, bɔ́ bɔ̀ tele bɔɔ̀n Jebedê né gi lè kɔme, bɔ́ né ndoór bɔɔ́ nyegé. Yeésò yilá njií cu bɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bɔ́ komo wuo ter kwar, bɔ́ kwaá lɔ tele bɔɔ̀n mé kɔm mene, bɔ́ yuo bele bú. ");
INSERT INTO mcu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeésò né lè tàbè Galilê bèh dɔɔ́ŋ ndeé, à né ŋgòr Càŋ te *gwà sóù feh bele, à né bɔ̀ nùàr Njàgà Bagaà felè *Lò Càŋ se, à né bɔ̀ beén dé kàn mé núr dé kân lètenè bɔ̀ nùàr taré sɔm bele. ");
INSERT INTO mcu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bɔ̀ɔ́ mé né lè tàbè Sirî mene dɔɔ́ŋ ŋgweé gi njàgà seèn. Bɔ́ né mé bɔ̀ beén bɔ̀ hihiné toò seèn weh ndeê: bɔ̀ déì lé naâ mé tándulu yoòr, bɔ̀ déì né bɔ̀ tì bɔ̀, bɔ̀ déì gule mé be né kuú, dɔɔ́ŋ à lé naá giì bɔ́ taré sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cìlì nùàr mé lò hihiné né lom bú jomo kem bele: bɔ̀ déì yuoô te lò Galilê, bɔ̀ déì te lò Dèkàpòlî, bɔ̀ déì yuoô ké Jerusalem te tàbè Judê mé bɔ̀ lɔɔ́ dé kukwarè, mé lò dé yí jomo nòmò Jurdên mene, bɔ́ dɔɔ́ŋ kem nde giì yoòr Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sâ Yeésò ŋene njií né cìlì nùàr mé né doó merré den, à ŋaá nde ké te tòre, à den den ké sâ. Bɔ̀ mbɔ̀ŋ ŋgoró nde ké kwarè seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","À duɔɔ́m bɔ́ njèh feèh, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Samésé né bɔ̀ɔ́ mé né saám yoòr bɔɔ̀n ŋené kɔɔ́; *Lò Càŋ né dé bɔɔ̀n! ");
INSERT INTO mcu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Samésé né bɔ̀ kújere bɔ̀; Càŋ nde né bɔ́ bɔŋ! ");
INSERT INTO mcu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Samésé né bɔ̀ɔ́ mé né dɔlésé; tàbè mé Càŋ lé ye nyí nde né bɔ́ haá doô, bɔ́ nde né kwa! ");
INSERT INTO mcu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Samésé né bɔ̀ɔ́ né mé nyúá dene jéjêg beè Càŋ; temé nde né bɔ́ lè dɔlé. ");
INSERT INTO mcu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Samésé né bɔ̀ɔ́ mé né bɔ̀ mbeí jere kɔɔ́; Càŋ kɔ nde né bɔ́ jere ménâ ndɔ! ");
INSERT INTO mcu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Samésé né bɔ̀ temé ŋeŋagâ bɔ̀; bɔ́ nde né Càŋ mé njolo ŋené! ");
INSERT INTO mcu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Samésé né bɔ̀ɔ́ mé né dɔlê lètenè bɔ̀ mbaábɔn goó su; Càŋ nde né bɔ́ bɔ̀ ŋuna seèn yilá! ");
INSERT INTO mcu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Samésé né bɔ̀ɔ́ mé né sòn Càŋ ŋgweé, bɔ́ né mene bɔ́ teèn bunó yií; Lò Càŋ né dé bɔɔ̀n! ");
INSERT INTO mcu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Samésé né bí ndɔ, mɔ bɔ̀ nùàr baá bí selé, bɔ́ né bí bunó, bɔ́ né bí nyeén vevenê yoòr cɔré su, ye bí né bɔ̀ mbɔ̀ŋ mò fí. ");
INSERT INTO mcu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mè tueé bí, bí sàmè sér dé biì cu sâ lòù; bí né tàbè dobo, ye sàgà biì né ké te vulúu ŋgún ma. Bí té njeré déì mùnò; bɔ́ lé naâ bɔ̀ *sòn-Càŋ bɔ̀ dé léí toò ménâ bunó ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Dé biì, bí né toò bɔ̀ nùàr faá túɔ́m nɔ. Mɔ túɔ́m cuaré baá, bɔ́ bɔɔ́ ŋgulí cu nde né bú naàn wa? Sâ gi aá kèn; à njeré déì gàm ndé cú; bɔ́ bú su njií nde aá doó, bɔ̀ nùàr dobo fulú kela teèn. ");
INSERT INTO mcu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Bí né ŋagâ toò bɔ̀ nùàr ndɔ. Lɔɔ́ mé den né ké felè tòr, dé seèn lòù dèn lèr ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bɔ́ lâm mɔ̀gɔ̀ bèh, ye te bɔ́ kibí kwaá ka sɔɔ̀. Bɔ́ lâm mɔgɔ seér né te bɔ́ tuú njií yí te súgo, te bɔ̀ gwò bɔ̀ ŋene njolo mé njéh. ");
INSERT INTO mcu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bí bá ŋágá toò bɔ̀ nùàr ménâ ndɔ, te bɔ́ ŋene kɔ seé bagaà biì teèn, bɔ́ seén Tele biì ké te vulúu.» ");
INSERT INTO mcu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Bí té mùnò ye mè ndeè naâ *sóú Músì mé ŋgòr bɔ̀ *sòn-Càŋ bɔ̀ ŋellé sɔm. Cí sam, mè ndeè naâ bɔ́ lòù mboón seér. ");
INSERT INTO mcu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mè né tueé ye bí a, mɔ vulú bɔ̂ tàbè née ka te be sâ, ndɔ́g njolo sóù déì kèh nyì ndé ŋgwéh. Le den nde né kɔ́bè sâ, kɔ loù mé njèh dɔɔ́ŋ mboón aá, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sâ mɔ né mân, nuaá mé keh luar sɔm njolo sóù déì, à feh bɔ̀ mbeí ménâ ndɔ, nùà sâ luar le nde né te *Lò Càŋe lòù ménâ ndɔ. Nuaá mé jolo feh seér né dé seèn bɔ̀ mbeí sóú lòù, te bɔ́ jolo ménâ ndɔ, nde né nùà dueè te Lò Càŋe ŋaá. ");
INSERT INTO mcu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mè tueé bí, mɔ bí kɔɔ́ dìlì kélá ŋgwéh mé bɔ̀ *njí-sóù bɔ́ bɔ̀ *Farisiên, ndɔ́g bí Lò Càŋe yílá ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Bí lé naâ ŋgweé, bɔ́ lé ye bɔ̀ jɔ̀gɔ̀ bɔ̀ a: Té feh wúlá, wa nuaá mé wula feh dɔɔ́ŋ nde né ju yilá ma. ");
INSERT INTO mcu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mè tueé seér né dé mò ye bí a: nuaá mé kwaá njií mene léláŋ njèh mé mbeí, nde né ju yilá. Nuaá mé yilá mbeí: cɔɔ́ŋ, nde né ké sònò bɔgɔ te *mbàgà juù ndeé. Nuaá mé yilá mbeí: duaàn, ju dé seèn wulu né mé we dé ndeèr. ");
INSERT INTO mcu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Sâ mɔ wò nde aá Càŋ mbe ké te kɔ haá, jɔ̀gɔ̀ mùnò nyége munò ye, mɔ temé né nuaré déì mé wò yulá, ");
INSERT INTO mcu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sâ lɔ̀gɔ̀ kwá njí mbe sâ doó nɔɔ́ŋ, wò jɔ̀gɔ̀ nde yoòr seèn, bí bú tueé kulú gi, te wò cu cuù, wò haá ye Càŋ mbe. ");
INSERT INTO mcu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Mɔ bî nuaré déì baá mé ju, à né wò sií, à ju sâ njií né ké sònò bɔ̀gɔ̀, mɔ bí bú gɔ bilí né bècénè, lègè lòm ceér dueè tég, te bí bú den mé sòn cên, wanɔɔ́ŋ wò nde né ju beè seèn ké toò bɔ̀ kokoô bɔ̀ die, bɔ́ sie haá njií wò mé bɔ̀ sɔ́jì, te bɔ́ si yií wò gwà cibì. ");
INSERT INTO mcu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mè né tueé ye wò a, bɔ́ sie kwaá den nde né wò beè méménâ, tɔ́g kɔ bɔ̀ tòmò njèh nùà hèllè yuo kela giì baá kèn, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Bí lé naâ ŋgweé, bɔ́ ye: Té yàgà ndé. ");
INSERT INTO mcu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mè tueé seér né dé mò ye bí a: Nuaá mé ke mene ma vêh déì, tuaá sie bú mé bú, kuú gi aá yàgà kèn. ");
INSERT INTO mcu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sâ mɔ njolo yeè dé gaâ wò te veêne dɔr yií né kɔɔ́, lùàgà sɔ̀m bú, wò si njií ké dàb. Huɔm kela né mé gà cén leér lom yoòr yeè kɔɔ́, mé bɔ́ si njií gùm yeè dɔɔ́ŋ te we dé ndeèr. ");
INSERT INTO mcu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mɔ be yeè dé gaâ wò te veêne dɔr yií né kɔɔ́, sâ cɔ̀ téná sɔ̀m bú, wò si njií bú ké dàb. Huɔm kela né mé gà cén leér lom yoòr yeè kɔɔ́, mé gùm yeè dɔɔ́ŋ die yila te we dé ndeèr ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Bɔ́ lé naá cuù tueé ye: Nuaá mé sɔm véh dɔɔ́ŋ, bú a, nyàgà há bú mvù beè. ");
INSERT INTO mcu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mè tueé seér né dé mò ye bí a: mɔ ma déì yàgà ndé ŋgwéh, si bú sɔm né mbaá, sâ si bú bèh yàgà kuû luú si né kɔɔ́. Véh mé bɔ́ naâ lòù mele sɔm, nuaá mé jɔgɔ bú dɔɔ́ŋ kuú taré né yàgà ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Bí lé naá giì ŋgweé, bɔ́ lé ye bɔ̀ jɔ̀gɔ̀ bɔ̀ a: Nùàr a, té jègè kèh; bú a, jòlò lòm faá à lé naá giì toò Càŋ Dueè jege nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mè tueé seér né dé mò ye bí a: ndɔ́g nùàr a, té jègè jègè nyì. Bí té vulú jègè kèmà, kɔgɔ Càŋ né ké sâ; ");
INSERT INTO mcu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bí té tàbè jègè kèmà ndɔ, gule seèn né toò; né mene Jerusalem, té bú jègè kèmà, né lɔɔ́ Nùà Dueè. ");
INSERT INTO mcu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Té feh yeè jègè kèmà ndɔ; yúlí feèh né mene dé wulê, né mene dé yilî, wò déì teèn kwéh sér kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mɔ né nyea, júée nyea; mɔ né sam, júée sam ndɔ; wanɔɔ́ŋ bɔ̀ dé felèbɔ̀ kabé gɔɔ̀ dɔɔ́ŋ, yuo yeé beè Sátàn.» ");
INSERT INTO mcu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Bí lé naâ ŋgweé, bɔ́ ye: Njolo mé njolo, nyie mé nyie ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mè tueé seér né dé mò ye bí a: Mɔ nuaré déì bɔɔ́ bí veên, bí té njùŋ kú. Mɔ nuaré déì bɔ wò te geí gaâ, kéh cú bú geí dé ŋgoù, à bɔ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mɔ nuaré déì tulu njií wò bèh juù, à gwaán né cɔ̀gɔ̀ suù yeè yiín weèh, há bílí bú mé cɔ̀gɔ̀ wagâ yeè mene. ");
INSERT INTO mcu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mɔ nùà koô déì ba haá wò seé dé kílòmétà cên, gɔ̀ cú mé njéh kílòmétà fà. ");
INSERT INTO mcu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɔ nuaré déì né wò njeré déì dua, há bú teèn. Mɔ nuaré déì bie wò hùà njeré déì, té bú nómó.» ");
INSERT INTO mcu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Bí lé naâ ŋgweé, bɔ́ ye: Gwàn mbeí yeè, wò né nùà bùnò yeè bunó. ");
INSERT INTO mcu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mè tueé seér né dé mò ye bí a: bí gwàn bɔ̀ bùnò bɔ̀ biì gwaàn. Bɔ̀ɔ́ mé né bí gèr feh keéh, bí dùà sér Càŋ felè bɔɔ̀n lòù, ");
INSERT INTO mcu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","te bí ŋa bɔ̀ ŋunà Tele biì mé né ké te vulúu. Bí kɔ́ɔ ye Càŋ lou ba fue njií né felè bɔ̀ jéré-temé bɔ̀, mé bɔ̀ húɔ́m-temé bɔ̀ mene. Nu seèn né felè bɔ̀ vevenê bɔ̀, mé bɔ̀ bebagaà bɔ̀ ménâ neé tɔɔ́m ndeé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mɔ bí gwaán lom né bɔ̀ɔ́ mé né bí gwaán, sâ bí sàgà teèn kela kuú né dé keì? Ŋgweéh né mene bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀, bɔ́ né gi ménâ bɔɔ́ komo mà. ");
INSERT INTO mcu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mɔ bí kɔ lom né léláŋ bɔ̀ nùàr biì, sâ beè biì né njèh kàm déì wa? Ŋgweéh né mene bɔ̀ Càŋ-kɔ́, bɔ́ né gi dé sâ bɔɔ́ kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mè tueé bí, bí dèn lòm dé biì dilísé faá Tele biì ké te vulúu né dilísé nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Mɔ bí baá njèh mé yilí Càŋ bɔɔ́, bí té toò bɔ̀ nùàr lòù sàn gɔ̀, ye te bɔ́ keí bí. Mɔ sam, bí sàgà beè Tele biì ké te vulúu kwà ndé cú. ");
INSERT INTO mcu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sâ mɔ wò nde aá nùà saâm njeré déì mé be yeè haá, té jùàgà lòbò. Dé sâ né seé bɔ̀ fù-ŋgàŋ bɔ̀. Né mene ké *gwà sóù, né mene ceér dueè, bɔ́ ménâ luerré gɔ né te bɔ̀ nùàr keí bɔ́ keì. Mè né tueé ye bí a, bɔ́ sàgà bɔɔ̀n kwa gi aá kèn, déì toò sam cuú. ");
INSERT INTO mcu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Té dé yeè ménâ bɔ́. Mɔ wò baá nùà saâm njeré déì mé be gaâ haá, be ŋgoù a, té kɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Náb há bú lòù, te Tele yeè ŋene dé nâb ménâ, à wò sàgà haá seér kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Mɔ bí baá Càŋ dua, bí té faá bɔ̀ lòbò-kàŋ bɔ̀ nɔ dèn. Mɔ bɔ́ nde aá Càŋ dua, kɔ bɔ́ njeba ter njolò bɔ̀ nùàr; né mene ké *gwà sóù, né mene te làrè ceér-e, kɔ né njolò bɔ̀ nùàr. Mè né tueé ye bí a, bɔ́ sàgà bɔɔ̀n kwa gi aá kèn, déì toò sam cuú. ");
INSERT INTO mcu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Té dé yeè ménâ bɔ́. Mɔ wò nde aá Càŋ dua, yílá ndé ké mí yeè, wò colo njií hin, wò dua leér Tele yeè lòù, te Tele yeè mé né bèh lèrrèb ménâ ŋené, à wò sàgà haá seér kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Mɔ bí baá Càŋ dua, bí té njèh sònò faá bɔ̀ Càŋ-kɔ́ nɔ mbèì gɔ̀. Bɔ́ munó né ye, kɔ bɔ́ kulá laré dàm njèh dɔɔ́ŋ te Càŋ ŋgweé ye. ");
INSERT INTO mcu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bí té dé biì ménâ bɔ́. Njií mé né bí saám dɔɔ́ŋ, Tele biì né gi ŋené, te bí nde ye bú dua. ");
INSERT INTO mcu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sâ mɔ bí baá Càŋ dua, bí júée: Tele beèh mé né ké ter te vulúu, yilí yeè a: dèn beè bɔ̀ nùàr jolosé. ");
INSERT INTO mcu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ndê kɔgɔ yeè ká lètenè beèh dilí kwaá. Gàm béh te béh ŋgweé sòn yeè ká doó faá bɔ́ né sòn yeè ké te vulúu ŋgweé nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Há béh yáb mé nde né béh lan wulú. ");
INSERT INTO mcu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kúlú njí bɔ̀ veên beèh doó faá béh né veên bɔ̀ mbeí beèh lè beèh kulú sɔm nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bèh mé veên né béh taáb dɔɔ́ŋ, té béh teèn njí, cí sér béh lòù. Kɔgɔ mé terreb mé *sùsùm né gi dé yeè dé nyèmà mé nyèmà. È môn. ");
INSERT INTO mcu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sâ tueé né ye: mɔ bí né veên bɔ̀ mbaábiì lè biì kulú sɔm, Càŋ nde né bí veên yoòr ménâ kulú sɔm ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Á, mɔ bí veên bɔ̀ mbaábiì lè biì kúlú sɔ̀m ŋgwéh, sâ Tele biì ké te vulúu bí veên yoòr kúlú sɔ̀m ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Mɔ bí baá yáb jolo, bí té kuún faá bɔ̀ lòbò-kàŋ bɔ̀ nɔ kàgà gɔ̀. Bɔ́ ménâ kaga gɔ né, te bɔ̀ nùàr ŋene kɔ teèn, ye bɔ́ né yáb jolo. Mè né tueé ye bí a, bɔ́ sàgà bɔɔ̀n kwa gi aá kèn, déì toò sam cuú. ");
INSERT INTO mcu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Té dé yeè ménâ bɔ́. Mɔ wò baá yáb jolo, vúá ŋágá njolo yeè, wò sieé feh, ");
INSERT INTO mcu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te wò mé nùàr fèh kéh cú ye nyí né yáb jolo; wò feh keéh cegé mé Tele yeè nuaá mé né bèh lèrrèb ŋené, à wò sàgà haá seér kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Bí té mé ŋgúlú wɔ̂ŋ bílí lè. Sueé bɔ̂ jagàb nde né yieé sɔm; yíb nde né gwà komo, à ŋuɔɔ́b yuo mé njéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bí ŋgúlú bílí sér dé ké te vulúu; dé sâ sueé bɔ̂ jagàb bú yíé kòmò ndé ŋgwéh, yíb bú ŋúɔ́b kòmò ndé ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bí kɔ́ɔ ye, temé nùàr né gi bèh mé ŋgúlú seèn né teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Njolo nùàr den né yoòr seèn faá lâm nɔ. Mɔ njolo yeè né ŋené, gùm yeè dɔɔ́ŋ nde né bèsɔ́nè ŋagá den. ");
INSERT INTO mcu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mɔ njolo yeè baá nyimé, sâ gùm yeè dɔɔ́ŋ den nde né bèh cibì. Mè tueé wò: mɔ ŋagâ mé né yoòr yeè doô ŋa seér cibí, gùm yeè dɔɔ́ŋ nde né toò yilí kelá ndeé.» ");
INSERT INTO mcu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nuaré déì seé nùà fà kèì cén bɔ́ kòmò ndé ŋgwéh. À nde né cén bunó, à gwaán déì. À beè déì den nde né nùà gècên, à seb déì. Bí seé Càŋ bɔ̂ seé kàgàlɔ̀ŋ fà dɔɔ́ŋ kèì cén bɔ́ kòmò ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Mè tueé bí, mɔ né mân, bí té mé yáb bɔ̂ mbè nyàmè lè, ye te bí koó feh biì. Bí té mé cɔ̀gɔ̀ nyàmè lè, ye te bí su kwaá yoòr ndɔ. Ŋgweéh kela né yɔ̀ŋ nùàr mé yab mà. Gùm nùàr huɔm kela né kɔɔ́ mé cɔ̀gɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bí jɔ̀gɔ̀ kè njí ke bɔ̀ non ye; bɔ́ yab dòbò bèh, bɔ́ kwá bèh, bɔ́ mé mbáŋ sam ndɔ; mé njéh mene, Tele biì ké te vulúu né gi bɔ́ koó laré; sé tagá bí wa? Ŋgweéh kela né bí mé bɔ̀ non mà.» ");
INSERT INTO mcu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","À den cuù ye bɔ́ a: «Bí né mene nyamé, lètenè biì dɔɔ́ŋ neì cieé déì felè bɔ̀ cieé seèn sagá komo nde né kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mɔ sam, bí cɔ̀gɔ̀ nyamé den né dé keì? Bí kè wèh yoòr bɔ̀ mvue nyurè mé né ké ŋueh baá: bɔ́ seé témá bèh, bɔ́ cɔ̀gɔ̀ cóló kɔ́ bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mé njéh mene, mè tueé bí, mgbè Salomɔ̂ŋ mé be ŋgùlù seèn mene dɔɔ́ŋ lé gèh nòmò cɔ̀gɔ̀ faá bɔ̀ mvue nɔ sù kwà ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mɔ Càŋ né nyure ké ya dueè mbaá yàgà ménâ nyegé huɔɔ́m, à cɔ̀gɔ̀ mé bí há kélá ndé ŋgwéh wa? Ŋgweéh bɔ̀ nyure ké ya den weh né dé laàn, kwéh bɔ́ nde né saá sɔm wa? Temé kuú né bí lòù, mè tueé bí! ");
INSERT INTO mcu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Sâ bí té mbaá nyàmè dèn ye: béh yieé nde né kei? Béh ŋueé nde né kei? Béh su nde né kei wa? ");
INSERT INTO mcu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dé sâ né seé bɔ̀ *wɔ́ŋ bɔ̀. Bɔ́ né gi ménâ nyamé fɔɔ́n. Bí né dé biì mé Tele ké te vulúu teèn; bɔ̀ njií mé saám né bí dɔɔ́ŋ, à né gi kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bí jɔ̀gɔ̀ yúé fɔ́n lɔ́gɔ *Lò Càŋ ye, bí dèn dilísé faá Càŋ gwaán nê nɔ; Càŋ nde né bí bɔ̀ njèh dé jomò teèn haá keéh gií. ");
INSERT INTO mcu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sâ mɔ né mân, bí té dé kwêh nyàmè; kɔ baá kwéh sâ, bí nyamé ye. Cieé dé kàn né mé seé seèn yoòr.» ");
INSERT INTO mcu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Bí té ju felè bɔ̀ mbaábiì mbaá téná gɔ̀, te Càŋ ju felè biì téná cú. ");
INSERT INTO mcu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mɔ sam, Càŋ nde né ju felè biì faá bí né dé bɔ̀ mbaábi nɔ tená. Mòù mé bí né bɔ̀ nùàr njèh teèn me haá dɔɔ́ŋ, Càŋ bí me haá cu nde né teèn. ");
INSERT INTO mcu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mbeí mò, wò yeè tòmò nyurè dé njolò mbeí yeè ŋene keéh naâ he, mé gùm ndilí toû dɔɔ́ŋ né wò njolò ŋgelá den, wò cí ŋéné ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wò ye bú a: kwá nyí ge sɔm wò tòmò nyurè njolò! Ŋgweéh wò njolò né mé gùm ndilí toû wa? Wò bú tòmò nyurè hèllè njolò ge sɔm keéh nde né naàn wa? ");
INSERT INTO mcu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nùà lòbò-kàŋ, jɔ̀gɔ̀ mvúá sɔ̀m lɔ́gɔ ndilí toû dé njolò yeè; mɔ njolo ŋagá baá, wò ge sɔm ye nyure dé njolò mbeí yeè. ");
INSERT INTO mcu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Bí té bɔ̀ njèh jojoloò mé bɔ̀ boór há; mɔ sam, bɔ́ nde cuù né mé bí ŋaár cu cuû, bɔ́ nema ŋaré sɔm seér bí lòù. Bí té gɔ̀m matàn toò bɔ̀ ŋguiâŋ sì kwá; mɔ sam bɔ́ nde né gulè dobo calé keéh.» ");
INSERT INTO mcu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Bí dùduaà, bɔ́ nde né bí haá; bí féfɔɔ̀n, bí nde né kwa; bí gɔ́ hin gɔɔ̀, bɔ́ nde né bí gulu keéh. ");
INSERT INTO mcu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lòù sam, nuaá mé né dua dɔɔ́ŋ nde né kwa. Nuaá mé né fɔɔ́n dɔɔ́ŋ nde né ŋené. Bɔ́ nde né nuaá mé né gɔɔ́ dɔɔ́ŋ, gulu keéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Hên, mɔ lètenè biì nuaré déì né mé huaán teèn, mɔ ŋuna dua bú sér, à bú dɔm haá seér nde né taá wa? ");
INSERT INTO mcu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mɔ sam, à sie haá seér bú sàb, sâ ŋuna dua né bú ŋgò wa? ");
INSERT INTO mcu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bí mé jéré-temé biì mene, bí né bɔ̀ ŋuna biì bɔ̀ njèh bebagaà haá komo; sé tagá Tele biì ké te vulúu wa? Bí kɔ́ɔ ye: bɔ̀ɔ́ mé né bú bɔ̀ njèh bebagaà dua dɔɔ́ŋ, à nde né bɔ́ haá. ");
INSERT INTO mcu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Bí bɔ́ mé bɔ̀ nùàr faá bí ye bɔ̀ nùàr a, bɔ́ mé bí nɔ. *Sóú Músì mé bɔ̀ *sòn-Càŋ bɔ̀ tueé gi né ménâ.» ");
INSERT INTO mcu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Bí yílá kélá sér lè hin dé barê; hin dé tàŋɔ̀r, mé ceér tàkpèlàŋ dé bɔɔ̀n nde né ké tuar. Mé njéh mene, bɔ̀ nùàr due kela gi né teèn. ");
INSERT INTO mcu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ceér mé nùàr nde né yɔ̀ŋ teèn kwa, né seér ceér dé ŋgoû mé hin dé barê. Nùàr ŋgɔ́b bú fɔɔ́n kwa né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Bí bɔ̀ŋ feh biì toò bɔ̀ *sòn-Càŋ bɔ̀ dé kòkòb. Bɔ́ yila den né lètenè biì mé par yoòr faá sòrŋgaŋ nɔ, sâ yí lè né ŋgùì. Bí nde né bɔ́ mé seé bɔɔ̀n ŋené kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mè tueé bí, màkpelâŋ beéh te kaáŋkaŋ wá bèh; nyie ŋgòbò máŋgɔ̀rè wá bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Toú bagaà wa né dé seèn tàb dé bagaà; toú veên wa cu ka tàb dé veên. ");
INSERT INTO mcu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Toú bagaà beéh tàb veên wá sér bèh; toú veên tàb dé bagaà wá ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mè tueé bí, toú mé tàb dé bagaà wá ŋgwéh dɔɔ́ŋ, bɔ́ nde né bú tuar komo fuú njií. ");
INSERT INTO mcu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sâ te bí ŋene kɔ bɔ̀ sòn-Càŋ bɔ̀ dé nyenyenê teèn mé seé bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Bí té mùnò ye, bɔ̀ɔ́ mé yilá né mè Nùà Dueè, Nùà Dueè doô nde gi né *Lò Càŋ dɔɔ́ŋ yilá. Mè tueé bí, bɔ̀ɔ́ mé bɔɔ́ né faá Tele mò ké te vulúu gwaán nê nɔ, Lò Càŋ yila cegé nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kwá nɔɔ́ŋ, loù mé ndeè jueè né jueè, bɔ̀ nùàr ŋgún nde né tueé ye: Nùà Dueè, Nùà Dueè, béh lé naâ sòn-Càŋ mé yilí yeè tueé, béh lé naá giì bɔ̀ tándulu mé yilí yeè kwɔgɔ́, béh lé naâ bɔ̀ fém hihiné mé yilí yeè bɔɔ́ bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mè tueé bí, loù sâ mè nde né tueé ye bɔ́ a: Mè bí kɔ́ ŋgwéh, bí né bɔ̀ dúágá-tie bɔ̀. Bí ndé sèr mé njéh toò.» ");
INSERT INTO mcu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Nuaá mé né ŋgòr mò hên ŋgweé, né ménâ bɔɔ́ dɔɔ́ŋ den né faá nùà kɔ́gɔ̀n mé lé meè naâ gwà seèn felè kweêh nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","À yeé me gi aá, nu die ndɔ. Nu yeé baá neé, nòmò yuo ber cie, né gwà doô luú; fu tarê né mene gwà doô kobó, njeré déì lé bú bɔ́ ná ŋgwêh, njua kweêh. ");
INSERT INTO mcu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nuaá mé né ŋgòr mò hên ŋgweé, à dé seèn ménâ bɔ́ ŋgwéh dɔɔ́ŋ, den nde né faá nùà yánè mé lé meè naâ gwà felè mbésebê nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nu yeé baá neé, nòmò yeé baá cie yuo ber, fu yeé baá kobó taré, vela ŋem sɔm gwà sâ, gwà hèllè calé yuo.» ");
INSERT INTO mcu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeésò yeé nde feh sɔm bɔ̀ nùàr mân, hiím laré bɔ́ doó dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Lòù sam, à lé bɔ́ njèh feh loóm naâ faá nùà njèh nɔ, à lé bɔ́ faá bɔ̀ *njí-sóù nɔ fèh ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeésò suaga cuù ké te tòre ndɔ, bɔ̀ nùàr ŋgún kem bele cu bú jomo. ");
INSERT INTO mcu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nùà beén veên déì waà dé seèn, cemmé nde toò seèn, ye bú a: «Dé koô, mɔ wò né gwaán, wò nde né mè taré sɔm, mè den cu ŋagásé.» ");
INSERT INTO mcu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeésò kema njií bú be yoòr ndɔ, ye bú a: «Mè gwaán aá kèn, táré yùò tarè.» Beén nùà doô nyimé yuo doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeésò ye bú a: «Càŋ a bɔ́ wò tueé nuaré déì. Ndé lòm ké yoòr *ŋgàŋ sèmè, wò feh keéh bú yo yeè, wò haá bú sèmè faá Músì lɔ naâ tueé nɔ, te bɔ̀ nùàr ŋene kɔ seér teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeésò yeé nde aá Kapernahûm yilá ndeé, kwaá-taâb bɔ̀ Rɔ̂m bɔ̀ déì ŋgoró ndeè kwarè seèn, ");
INSERT INTO mcu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ye bú a: «Kúkùr yeè, dé koô, nùà seê mò galé ŋgaga le aá ké gwò, à né lom mé beén kwaré.» ");
INSERT INTO mcu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeésò ye bú a: «Hin, béh nde, te mè taré sɔm bú.» ");
INSERT INTO mcu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kwaá-taâb doô yeé ŋgweé aá môn, ye Yeésò a: «Dé koô, mè nuaá mé wò nde né ké lɔ seèn yilá, wúlú ŋgwéh. Kòmò njí cégé yeè léláŋ sòn, nde né nùà seê mò taré sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mè né kɔɔ́ ye, bɔ̀ kokoô bɔ̀ né mé terreb teèn. Lòù sam, mè né ka bɔ̀ déì, bɔ̀ déì né ka mò. Mè né mé bɔ̀ŋ bɔ̀ sɔ́jì beè. Mɔ mè ye déì a: Ndé mân! à nde. Mɔ mè ye cén déì a: Ndê! à ndeè. Mɔ mè ye nùà seê mò a: Bɔ́ mân! à bɔɔ́ ka ménâ nág ndɔ. Mɔ né mân, túé cégé yeè lòù, nùà seê mò nde né taré yuo.» ");
INSERT INTO mcu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te Yeésò yeé nde ŋgweé njií mân, hiím lɔ bú mbaá, à tueé njií mé bɔ̀ɔ́ mé né jomo seèn ndɔ, ye bɔ́ a: «Mè né tueé ye bí a, ká te tàbè *Iserálà hên dɔɔ́ŋ, mè gèh ndèm hên teèn ŋéné ŋgúŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mè tueé bí, bɔ̀ nùàr yuo ndeè né kèb bà, mé kèb nyiìb, bɔ́ kwa gi bèh denè te *Lò Càŋe kwarè Abrahâm mé Isâk bɔ̂ Jakɔ̂b, ");
INSERT INTO mcu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","sâ bɔ̀ɔ́ mé Lò Càŋ sé né dé bɔɔ̀n, bɔ́ bɔ́ si njií aá ké cie te ndèndèŋ cibî, bèh kéŋ silî mé nyie yieé kuû.» ");
INSERT INTO mcu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yeésò tueé njií mé kwaá-taâb doô ndɔ, ye bú a: «Ndé cú yeè ké lɔ. Bú a, bɔ́ wò faá wò né temé yoòr mò kwaá njií sâ.» Nùà seê kwaá-taâb doô taré yuo beè nomo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jomo sâ Yeésò nde ké lɔ Piêr. À wa ké teèn, sâ gùnà Piêr né doó cer den, à né mé dùlù yoòr. ");
INSERT INTO mcu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeésò kema njií bú beè, dùlù kem yuo bú yoòr. Ma doô komo wuo ter, bɔɔ́ haá bú yáb. ");
INSERT INTO mcu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yeé baá liyilì, bɔ̀ nùàr kem waà mé bɔ̀ beên bɔ̀ ká yoòr Yeésò kókoó mbaá. À komo njií cegé né léláŋ sòn mbaá, bɔ̀ càŋ tándulu né bɔ́ yoòr durá yuo bele, bɔ̀ beén bɔ̀ dɔɔ́ŋ taré yuo gi ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sâ ménâ dɔɔ́ŋ bɔɔ́ gi né, te yuo faá Esáyà *sòn-Càŋ lé naá giì tueé nɔ, ye: «Dé seèn, à jɔgɔ weh né núr beèh, à ŋa weh beén beèh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bɔ̀ nùàr yeé baá kwarè Yeésò ŋgún, à ye: «Kwá béh sela yuo kela tub kèb yágà.» ");
INSERT INTO mcu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","*Njí-sóù déì ndeè ndɔ, ye bú a: «Nùà fèh-njèh, wò nde mene he, bélɔ̀ nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeésò ye bú a: «Hên bɔ̀ nyam bɔɔ̀n né mé gbàŋ, bɔ̀ non mé fulu ndɔ. Kɔ́ɔ ye, *Huaán Nùàr dé seèn mé bèh cèrrè teèn sam.» ");
INSERT INTO mcu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mbɔ̀ŋ Yeésò cén déì deên ndɔ, ye Yeésò a: «Dé koô, kwá mè ndeè furú sɔm tele mò ye.» ");
INSERT INTO mcu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeésò ye bú a: «Bèlè lòm mè. Kwá lɔ́ bɔ̀ komó nde furú bɔ̀ mbeí bɔɔ̀n kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jomo sâ, Yeésò ŋaá yila te kɔme, bɔ̀ mbɔ̀ŋ seèn njií lɔ bú. ");
INSERT INTO mcu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Fu tarê kɔ die dùà te tub sâ ndɔ, né lom mé terreb kobó taré, né nòmò te kɔme pieém yií. Sâ Yeésò baá lɔ́m. ");
INSERT INTO mcu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bɔ̀ mbɔ̀ŋ ŋgoró nde kwarè seèn, bɔ́ nyimé bú, bɔ́ ye bú a: «Fehtoò beèh, béh nde aá kum le, yìlì sɔ̀m yeè béh teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeésò ye bɔ́ a: «Bí môn veéh né dé keì wa? bɔ̀ temé kuû bɔ̀!» À komo wuo ter ndɔ, à pam fu bɔ̂ nòmò; pɔ́ŋ die dùà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Geí lɔ bɔ̀ nùàr mbaá, bɔ́ ye: «Hên né gèh nùà kei, mé sòn seèn ŋgweé bilí né mé fu bɔ̂ nòmò mene wa?» ");
INSERT INTO mcu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bɔ́ wa yí sònò tuùb kèb yágà, te tàbè Gadarénà, bɔ́ kwa bɔ̀ nuaré déì teèn fà; bɔ́ yuoó naâ ké màsou, bɔ́ ndeè né te bɔ́ bɔ̀ Yeésò kwaré. Sâ nùà hèllè bɔ̂ mbeí né gi mé bɔ̀ càŋ jejelâ mân yoòr fà dɔɔ́ŋ, nùàr doó sâ kélá cú bèh mé veéh. ");
INSERT INTO mcu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bɔ́ yeé waà baá toò Yeésò, bɔ́ sɔm hueh, bɔ́ ye bú a: «Ŋunà Càŋ Dueè, béh bí né lè keé-re wa? Wò ká doó waà né te wò feh duɔɔ́m béh gèr mé cu née le ye wa?» ");
INSERT INTO mcu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sâ bɔ̀ŋ bɔ̀ ŋguiâŋ kókoó mbaá né yab ké bèh ndɔ́ŋ-ndɔ̀ŋ mân ŋalé yieé den. ");
INSERT INTO mcu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bɔ̀ càŋ hèllè bɔŋ baá-re Yeésò, ye bú a: «Mɔ wò nde né béh kwɔgɔ́, kwɔ́gɔ́ yí sér béh ké lè bɔ̀ ŋguiâŋ kíê.» ");
INSERT INTO mcu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeésò ye bɔ́ a: «Bí fɔ́n gò!» Bɔ́ durá yuo kela gi ndɔ, bɔ́ nde yila nde ké lè bɔ̀ ŋguiâŋ hèllè. Bɔ̀ŋ ŋguiâŋ doô kem suagà ké cueè, bɔ́ sue yila nde ké te tube, bɔ́ kum le teèn. ");
INSERT INTO mcu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bɔ̀ tèŋ ŋguiâŋ durá yuo gi ndɔ; bɔ́ nde cu ké lɔ, bɔ́ né bɔ̀ nùàr njií mé la kelà naâ felè bɔ̀ tándulu bɔ̀ tueé, bɔ́ né bɔ́ dé toò tueé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yeé baá ménâ, bɔ̀ lɔɔ́ bɔ̀ kem yuo gi ké lɔ dɔɔ́ŋ, bɔ́ né yoòr Yeésò ndeé, te bɔ́ bɔ́ kwaré. Bɔ́ yeé ŋene aá bú, bɔ́ ye bú a: «Kúkùr yeè, yùò lè tàbè beèh yuoò.» ");
INSERT INTO mcu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeésò yila cu kɔm, sela nde cu lɔ seèn. ");
INSERT INTO mcu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wa lɔ, bɔ́ jɔgɔ waà mé nùà gule kuû déì toò seèn, à né te ndagáa cer den. Yeésò yeé ŋene, ye temé bɔɔ̀n dɔɔ́ŋ né lom yoòr nyî ménâ, à tueé njií mé nùà gule kuû doô, ye bú a: «Táré yo, huaán mò. Bɔ̀ veên yeè gi aá wò mé njéh kèn.» ");
INSERT INTO mcu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te bɔ̀ *njí-sóù yeé nde ŋgweé njií mân, bɔ́ yila lè bɔɔ̀n ndugó beleè ye: «Nùà hên feh seèn faá Càŋ nɔ weh né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeésò ŋene kɔ mùnò bɔɔ̀n ndɔ, ye bɔ́ a: «Bí veénsé mân munó né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Beè biì, taré kela né tueê ye: bɔ̀ veên yeè gi aá wò mé njéh kèn, wa né: wùò ter, gègɔɔ̀ wa? ");
INSERT INTO mcu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bí kɔ́ɔ ye: ká doó dɔɔ́ŋ *Huaán Nùàr né mé terreb veên kulú sɔɔ̀m teèn.» À den cuù baá-re, ye nùà gule kuû doô a: «Wùò ter, wèh ndagá yeè, ndé á lɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nùà hèllè komo wuo ter ndɔ, fɔɔ́n gò lɔɔ̂ seèn. ");
INSERT INTO mcu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Veéh sie ŋellé nùàr doó dɔɔ́ŋ, bɔ́ né Càŋ teèn seén yií, ye lòù sam, à né nùàr terreb ménâ haá ma. ");
INSERT INTO mcu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeésò yuo doó sâ ndɔ, à nde ser toò. Wa beré déì, à ŋene njií nuaré déì né ké gwò bèh seé seèn den den, à né kàgàlɔ̀ŋ làmpɔ̂ŋ weh. Yilí nùà sâ né Matíô. Ye bú a: «Yùò bèlè mè!» Matíô yuo bele bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yeésò yeé baá ké gwò Matíô yáb yieé, bɔ̀ vevenê bɔ̀, mé bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ déì kem wa cuù teèn ŋgún, bɔ́ bɔ́ mé bɔ̀ mbɔ̀ŋ seèn né yáb bècénè yieé bilí den. ");
INSERT INTO mcu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bɔ̀ *Farisiên yeé ŋene aá ménâ, bɔ́ ye bɔ̀ mbɔ̀ŋ a: «Nùà koô biì bɔ́ bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀, mé bɔ̀ vevenê bɔ̀ yáb bècénè yieé bilí né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeésò yeé ŋgweé aá ménâ, ye bɔ́ a: «Bɔ̀ beén bɔ̀ né yeé mé koró nùà lèh kɔɔ́, dèn ŋgwéh bɔ̀ tetarê bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bí ndé màn nyégé bɔ̀ ŋgòr hên maàn, né ter nyagá den ye: Mè gwaán kela né nùà kɔ́-jerè mé nùà há-sèmè. Mè hên nde kuú naâ bɔ̀ vevenê bɔ̀ ká yoòr mò yilá njiî, dèn ŋgwéh bɔ̀ didilî bɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Loù sâ bɔ̀ mbɔ̀ŋ Jâŋ Bàptîs ndeè ye Yeésò a: «Bɔɔ́ né naàn mé béh bɔ̀ *Farisiên né gi dé beèh yáb jolo, bɔ̀ mbɔ̀ŋ yeè dé bɔɔ̀n jòlò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeésò ye bɔ́ a: «Loù mé bɔ́ sua yeé véh, mé si né doó samé den, bɔ̀ mbeí nde né yáb jolo wa? Dé sâ ndɔ́g. Mé njéh mene, bí kwá cieé déì, mɔ bɔ́ ŋgaá sɔm aá bɔ́ siì fù beè, bɔ́ ndeè jolo ye bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Nuaré déì beéh cɔ̀gɔ̀ feê felè cɔ̀gɔ̀ dé cuûm téná làb njí bèh. Mɔ sam, dé feê nde né dé cuûm doô komo ŋɔré sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","«Bɔ́ tàgà mé kulu feê lè ŋguú cuúme sì kwá bèh ndɔ. Mɔ sam, ŋguú hèllè nde né mbè doó velé ber njií, bɔ́ vu bilí be mé ŋguú mene. Bɔ́ mbè mé kulu feê si seér yeé lè ŋguú feê, te kér cú, mbè doó bèr ndé cú ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nùà koô déì waà, sâ Yeésò née mé bɔ̀ nùàr ménâ tueé njií den; à cemmé nde toò seèn, ye bú a: «Huaán mò kuú aá kèn, à kuú née kuù ye. Mé njéh mene ndê kèmà njí bú be yoòr, à nde né nyimé yuo.» ");
INSERT INTO mcu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeésò komo wuo ter ndɔ, weh bɔ̀ mbɔ̀ŋ, bɔ́ bɔ́ bele sie bú. ");
INSERT INTO mcu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sâ ma déì né doó sâ teèn; baá nyèmà yulà cùɔ̀b fà húɔ́m né bú yoòr yuo den. À ŋgoró nde yí jomo Yeésò, à kema weh sòn cɔ̀gɔ̀ seèn. ");
INSERT INTO mcu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","À né ké lè tueé den ye: «Mɔ mè kema cegé mene léláŋ cɔ̀gɔ̀ seèn, nde né mè yili sɔm.» ");
INSERT INTO mcu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeésò bele seér ndɔ, ŋene bú, ye bú a: «Dé vêh, táré yo, wò né temé yoòr mò kwaá njií, wò taré yuo aá kèn.» Ma doô taré yuo doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeésò wa ké lɔ nùà koô doô, sâ bɔ̀ɔ́ mé tuaga yeé bené mé kû bɔ́ bɔ̀ nùàr baá lom doó ŋgún mbaá, bɔ́ né bèmè bɔɔ́. Yeésò yeé ŋene aá môn, ");
INSERT INTO mcu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ye bɔ́ a: «Bí yùò gí doó sâ dɔɔ́ŋ, huaán njeré déì kú ŋgwéh, à cer né lɔ́m.» Te bɔ̀ nùàr yeé nde ŋgweé njií ménâ, bɔ́ kem sue bú yoòr mé séb. ");
INSERT INTO mcu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bɔ́ yeé sɔm keéh gi aá bɔ̀ nùàr cie, Yeésò yila nde ké mí, à sie njií huaán vêh doô be ter; huaán doô komo den cu ter ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ŋgɔ́g dé sâ ŋgulí yɔŋ cu baá-re lò sâ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeésò yuo doó sâ ndɔ. À yeé baá beré déì kelá, bɔ̀ cùgò njolo bɔ̀ déì bɔ̂ mbeí duɔɔ́m bú jomo ŋgaré beleè, bɔ́ ye bú a: «Ŋunà *Davîd, kɔ́ yeè béh jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yeésò yeé baá ké gwò, bɔ̀ cùgò njolo bɔ̀ doô ŋgoró nde ké kwarè seèn ndɔ. À ye bɔ́ a: «Bí né temé kwaá njií ye mè né mé terreb faá bèh mân teèn wa?» Bɔ́ ye bú a: «Nyea, dé koô.» ");
INSERT INTO mcu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yeé baá ménâ, à kema njií bɔ́ be njolò ndɔ, ye bɔ́ a: «Bɔ́ bí faá bí né temé yoòr mò kwaá njií sâ.» ");
INSERT INTO mcu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Njolo bɔɔ̀n kwɔgɔ ŋagá ndɔ. À luɔm bɔ́, ye bɔ́ a: «Càŋ a bɔ́ nuaré déì ŋgweé tieè.» ");
INSERT INTO mcu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mé njéh mene, bɔ́ kɔ lom né mé yilí Yeésò lè tàbè sâ dɔɔ́ŋ saán yɔŋ gɔɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bɔ́ yeé baá dé bɔɔ̀n mé gò, bɔ̀ nuaré déì wa cuù mé nùà sòn ndûg déì ká toò Yeésò ndɔ. Nùà sâ lé naâ mé tándulu yoòr; càŋ hèllè lé naâ bú sòn yiín. ");
INSERT INTO mcu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te Yeésò yeé nde kwɔgɔ sɔm bú lè nùà doô mân, nùà hèllè duɔɔ́m keéh sòn tueê. Cìlì nùàr geí laré mé njéh doó dɔɔ́ŋ, bɔ́ ye: «Béh née gèh dé hên te tàbè *Iserálà dɔɔ́ŋ ŋéné ŋgúŋgwéeh ye.» ");
INSERT INTO mcu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bɔ̀ *Farisiên den seér cuù dé bɔɔ̀n ye: «Mgbè bɔ̀ tándulù bú terreb mân haá né kɔɔ́, à bɔ̀ tándulu kwɔgɔ né mé njéh.» ");
INSERT INTO mcu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeésò né te bɔ̀ lɔɔ́ kokoô mé tetɔɔ̂r mene kelá, à né ŋgòr Càŋ te *gwà sóù feh bele, à né Njàgà Bagaà felè *Lò Càŋ se yɔŋ, à né bɔ̀ beén dé kàn mé núr dé kân taré sɔm bele. ");
INSERT INTO mcu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","À yeé baá cìlì nùàr ménâ ŋené, jere bɔɔ́ bú njèh. Lòù sam, bɔ́ lé naâ doó mbaá homó ndab den; bɔ́ né lom faá bɔ̀ mbieè mé nùà njèh teèn sam nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yeé baá ménâ, à ye bɔ̀ mbɔ̀ŋ seèn a: «Yab bɔlé lom né ŋgún. Njèh cén, bɔ̀ seê bɔ̀ mé nde né ká lɔ kwaá bilí njiî màgà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bí bɔ̀ŋ nùà njèh bɔɔ̀ŋ, te à tema njií bɔ̀ seê bɔ̀ teèn, te bɔ́ kwa bilí njiî bú mé njéh ká lɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeésò yilá bilí bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô, à jege haá bɔ́ terreb te bɔ́ kwɔgɔ́ sɔm bele bɔ̀ nùàr càŋ tándulu yoòr, bɔ́ taré sɔm bele bɔ̀ beén bɔ̀, mé bɔ̀ núr bɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yilí bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà sâ lé naâ: Simɔ̂ŋ mé yilí seèn déì né cu Piêr, bɔ̂ dìm seèn Andrê; bɔ̀ ŋunà Jebedê, Jâk bɔ̂ dìm seèn Jâŋ; ");
INSERT INTO mcu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filîp bɔ̂ Bartelemî; Tomâs bɔ̂ Matíô nùà wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ; Jâk ŋunà Alfê bɔ̂ Tadê; ");
INSERT INTO mcu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ̂ŋ nuaá mé gwàn bèh dé mé bɔ̀ kìn den felè bɔ̀ lɔɔ́ bɔ̀ doô; mé Júdàs Iskariô, sàrnyé Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeésò tema sɔm bɔ̀ yulà cùɔ̀b fà bɔ̀ sâ ndɔ, à luɔm ye bɔ́ a: «Bí té lè tàbè bɔ̀ɔ́ mé *Jûf sam ndé, bí té lè lɔɔ́ déì te tàbè *Samarî yílá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bí ndé lòm yoòr bɔ̀ *Iserálà, bɔ́ né dé bɔɔ̀n faá bɔ̀ mbieè mé né lòù leér le nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bí túé gɔ̀ ŋgòr Càŋ ceceér, bí júée bɔ̀ nùàr a: Càŋ baá mbàm seèn ká kwarè bɔɔ̀n si njiî ma. ");
INSERT INTO mcu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bí táré sɔ̀m bèlè bɔ̀ beén bɔ̀, bí né bɔ̀ komó nyimé sɔm, bí né bɔ̀ beén veên bɔ̀ taré sɔm bele, bí kwɔ́gɔ́ sɔ̀m bèlè bɔ̀ nùàr tándulu yoòr ndɔ. Bí terreb kwa né dé lòù, bí ndé bɔ́ cú ká dé lòù ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","«Mɔ bí baá mé gò, bí té kàgàlɔ̀ŋ beè wèh sìè; né mene tòmò kàgàlɔ̀ŋ, bí té beè wèh sìè. ");
INSERT INTO mcu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bí té ba beè wèh sìè; bí té cɔ̀gɔ̀ su fà mé débágá beè wèh sìè; bí té cùgò beè wèh sìè ndɔ. Bí kɔ́ɔ ye, nùà seê yieé né mé seé seèn. ");
INSERT INTO mcu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Mɔ bí wa baá te lɔɔ́ déì, bí fɔ́n lòm nuaá mé gwaán né bí weèh, bí cer teèn. Bí cèr lòm lɔ nùà sâ. Mɔ cieé gò biì wulu baá, bí yuo cu. ");
INSERT INTO mcu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mɔ bí nde aá gwò yilá, bí júée bɔ̀ gwà bɔ̀ a: Kùsèm, dɔlê a dèn mé bí ma! ");
INSERT INTO mcu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mɔ bɔ́ né gwaán, sâ dɔlê biì nde né bɔ́ kwa. Á, mɔ bɔ́ né bí berɔ́ŋ, bí jɔ́gɔ́ yùò cú mé dɔlê biì. ");
INSERT INTO mcu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mɔ bí wa beré déì, bɔ́ bí wèh ŋgwéh, bɔ́ tie te ŋgòr biì félá njí ŋgwéh, bí yùò kwá lɔ́ bɔ́ nɔɔ́ŋ. Mɔ bí baá doó sâ yuo, né mene gwà, né mene lɔɔ́ déì, bí kàrè sɔ̀m gí fùfú bɔɔ̀n gulè biì karè. ");
INSERT INTO mcu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mè né tueé ye bí a, loù ju tenâ, gèr ŋene kela nde né lɔɔ́ hèllè mé *Sɔ́dɔ̀m bɔ̂ *Gɔmɔ̂r.» ");
INSERT INTO mcu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","À den cuù ye bɔ́ a: «Bí né ŋgweé wa, mè bí hên yi njií né faá bɔ̀ sòrŋgaŋ lètenè bɔ̀ ŋgùì nɔ; bí dèn lòm dene kɔ́ŋkɔɔ̀ŋ faá sàb nɔ; bí den mé sòn fuû faá vɔgɔb ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bí dèn làŋ, bí kɔ́ɔ ye, bɔ̀ nùàr nde né bí te *mbàgà juù mé sòn fuû jɔgɔ́ njií, bɔ́ nde né bí núr ké *gwà sóù bɔɔ̀n tegé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bɔ́ nde né bí ké toò bɔ̀ kokoô bɔ̀ mé bɔ̀ mgbèémgbè mgbɔmé njií, ye bí né bɔ̀ nùàr mò fí. Sâ dɔɔ́ŋ, mè ye te bí den nyegé cu ye baá-re bɔ̀ sòn mò ké toò bɔɔ̀n mé toò bɔ̀ Càŋ-kɔ̂ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sâ mɔ bɔ́ baá mé bí ké te mbàgà juù jɔgɔ́ ndeé, njií mé bí nde né sònò tueé dɔɔ́ŋ, bí té nyàmè. Loù sâ Càŋ nde né bí bɔ̀ ŋgòr sònò tueé kwaá gií. ");
INSERT INTO mcu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bí kɔɔ́ túé ndé ŋgwéh, Cúcuí Tele biì ké te vulúu tueé nde né sòn biì kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","À den cuù ye bɔ́ a: «Dìm bɔ̂ bei nde né yo bɔɔ̀n go kuú, te bɔ́ wula bɔ́ wulà. Bɔ̀ tele nde né bɔ̀ huaán go. Bɔ̀ huaán nde né yoòr bɔ̀ teleè ŋaár die; bɔ́ go sɔm bɔ́, te bɔ̀ nùàr wula taré bɔ́ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bɔ̀ nùàr nde né bí felè mò bunó kum. Mè tueé bí, nuaá mé nde né dɔɔ́ŋ yoló komo gií, yili yuo nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","À den cuù ye bɔ́ a: «Mɔ bɔ́ né bí lè lɔɔ́ déì bunó, bí dùlà ndé sèr te lɔɔ́ déì. Mè né tueé ye bí a, bí ndeè bɔ̀ lɔɔ́ te tàbè *Iserálà hên dɔɔ́ŋ yɔ̀ŋ làrè ndé ŋgwéh, mé *Huaán Nùàr née cú ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Mbɔ̀ŋ a, dèn méné naàn, à kɔɔ́ táré kélá ŋgwéh mé ŋgàŋ. Nùà seê dèn méné naàn, à tele seê seèn táré yɔ́gɔ́ ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mɔ mbɔ̀ŋ den wa né faá ŋgàŋ nɔ, bú a, sèsamè. Mɔ nùà seê né faá nùà koô seèn nɔ den waá, bú a, sèsamè ndɔ. Mè tueé bí, mɔ bɔ́ né mè nùà koô biì “mgbè bɔ̀ tándulù” yilá, sé tagá bí bɔ̀ jomo bɔ̀ mò wa?» ");
INSERT INTO mcu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","À den cuù ye bɔ́ a: «Sâ, bí té bɔ́ mbaá vèh dèn; bɔ̀ njèh lèrrèb dɔɔ́ŋ nde gi né cie ŋené yuo; bɔ̀ njèh dé nénâb ŋené yuo kela giì bèsɔ́nè ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bɔ̀ njií mé bí né ká sònò mò bèh cibì ŋgweé gií dɔɔ́ŋ, bí ndé túé bèh ŋagâ. Bɔ̀ njií mé bí né lòù ŋgweé naáb hên dɔɔ́ŋ, bí ndé yìè dèn ké felè gwà. ");
INSERT INTO mcu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bí té bɔ̀ wúlá-nùàr bɔ̀ vèh; bɔ́ wula lom né léláŋ ŋgàŋ yoòr, sâ gi aá, bɔ́ yɔ̀ŋ wúlá kɔ́ ŋgwéh. Bí vèh sér Càŋ nuaá mé nde né gùm nùàr mé yɔ̀ŋ mene te we tarê ŋgie njií. ");
INSERT INTO mcu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","«Hên faá bɔ̀ tásuagár doô, mɔ bɔ́ domó laáb mene bɔ́ fà, bɔ́ go sɔm kɔ́bɔ̀ cén, nde né nùàr yulá wa? Mé njéh mene, cén déì lètenè bɔɔ̀n mbaá lèr lè bèh, bɔ́ né gi njolò Tele biì. ");
INSERT INTO mcu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sé tagá bí wa? Mè tueé bí, né mene bɔ̀ yúlí feèh biì, né gi njolò seèn. ");
INSERT INTO mcu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bí té mbaá vèh kú, kela né bí te mbeî yuií mé dàm bɔ̀ tásuagár hèllè.» ");
INSERT INTO mcu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Nuaá mé né mè cie toò bɔ̀ nùàr gwaán njií dɔɔ́ŋ, loù sâ mè nde né bú toò Tele mò ké te vulúu gwaán weh ndɔ, ye né nùàr mò. ");
INSERT INTO mcu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nuaá mé né mè toò bɔ̀ nùàr ŋgɔɔ́n dɔɔ́ŋ, mè nde né bú toò Tele mò ké te vulúu ménâ ŋgɔɔ́n ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Bí té mùnò ye mè ká te wɔ́ŋe ndeè né bɔ̀ nùàr dɔlê haá. Mè tueé bí, né seér salê. ");
INSERT INTO mcu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mè ndeè nùàr bɔ̂ tele kerré kwaá; huaán dé vêh bɔ̂ meí kerré kwaá; véh bɔ̂ makoò kerré kwaá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nuaré déì bɔ̂ mbeí nde né mé gwà cên, déì nde né mbeí bunó. ");
INSERT INTO mcu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nuaá mé gwaán kela né tele seèn mé mè, nùàr mò wúlú ŋgwéh. Nuaá mé gwaán kela né meí seèn mé mè, nùàr mò wúlú ŋgwéh. Nuaá mé gwaán kela né ŋuna seèn mé mè, nùàr mò wúlú ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nuaá mé toú gèr seèn jɔ́gɔ́ wèh ŋgwéh, à mè bèlè ŋgwéh dɔɔ́ŋ, nùàr mò wúlú ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nuaá mé né yɔ̀ŋ seèn mé feh seèn gagá kwaá, nde né bú leér lɔɔ́. Nuaá mé né dé seèn cio felè mò ŋgɔɔ́n seér, nde né yɔ̀ŋ kwa.» ");
INSERT INTO mcu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Nuaá mé né bí sie nyegé dɔɔ́ŋ, sie nyegé né mè; nuaá mé sie nyegé né mè dɔɔ́ŋ, sie nyegé né Nuaá mé lé temà naâ mè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nuaá mé né *sòn-Càŋ déì sie nyegé, ye Càŋ bú temà naâ kɔɔ́ dɔɔ́ŋ, nde né sàgà faá bɔ̀ sòn-Càŋ bɔ̀ nɔ kwa. Nuaá mé né nùà dilî sie nyegé, ye né nùà gècên dɔɔ́ŋ, nde né gèh sàgà bɔ̀ gècên bɔ̀ kwa. ");
INSERT INTO mcu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mè né tueé ye bí a, nuaá mé kwe haá cegé mene huaán déì lètenè bɔ̀ mbɔ̀ŋ mò hên léláŋ nòmò, ye né mbɔ̀ŋ mò, nùà sâ nde né sàgà kwa.» ");
INSERT INTO mcu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeésò yeé feh gi aá bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô faá bèh ménâ, à fɔɔ́n gò ndɔ, à nde ŋgòr Càŋ lè lɔɔ́ mé lɔɔ́ tueé yɔŋ, à né bɔ̀ nùàr feh. ");
INSERT INTO mcu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sâ Jâŋ Bàptîs né cu sâ ké gwà cibì. Jâŋ yeé ŋgweé njií bɔ̀ nùàr baá felè seé *Kristò tueé den, à tema njií bɔ̀ mbɔ̀ŋ seèn déì ké teèn, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Bí ndé bíé ke ye bú a: Né bú mé béh né kela den doô wa, dé béh kèlà sèr nùà dé hiîn wa?» Bɔ́ nde ndɔ, bɔ́ wa. ");
INSERT INTO mcu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeésò ye bɔ́ a: «Bɔ̀ njií mé bí né ŋgweé, mé bí né gi ŋené hên dɔɔ́ŋ, bí ndé túé gí mé Jâŋ ménâ, ");
INSERT INTO mcu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bí júée bú a: bɔ̀ cùgò njolo bɔ̀ baá njolo ŋené, bɔ̀ gule kuú bɔ̀ baá gɔ, bɔ̀ beén-veên bɔ̀ né taré yuo bele, bɔ̀ tándúg baá ŋgweé, bɔ̀ komó baá lè cio nyimé yuo bele, bɔ̀ saám bɔ̀ baá Njàgà Bagaà ŋgweé ma. ");
INSERT INTO mcu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wa nuaá mé temé yoòr mò sɔ̀m ŋgwéh dɔɔ́ŋ nde né samésé den ma.» ");
INSERT INTO mcu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bɔ̀ mbɔ̀ŋ Jâŋ yeé nde cu aá, Yeésò duɔɔ́m ye bɔ̀ nùàr njèh felè Jâŋ tueé ŋagâ, ye bɔ́ a: «Bí lé ké ya dueè nde ŋenè naâ kei wa? Fu lé kobo jilí deén naâ gui wa? Háyè ndɔ! ");
INSERT INTO mcu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Á, bí lé ké sâ ke deén naâ kei wa? Bí lé ŋenè naâ nuaré déì mé cɔ̀gɔ̀ nyàgàm yoòr wa? Bɔ̀ɔ́ mé su yeé cɔ̀gɔ̀ nyàgàm bɔɔ̀n yuo yeé ké mbàm ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Á, ké ya dueè nɔ, bí lé ndeè naâ dé keì wa? Bí lé ye te bí ŋene *sòn-Càŋ déì wa? Mè tueé bí, né sòn-Càŋ sâ bɔ̀n. Njèh cén, bí kɔ́ɔ ye nùà dé sâ né sòn-Càŋ yɔgɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lòù sam, Jâŋ dé seèn né nùà tebê mé bɔ́ lé naâ felè seèn nyagá kwaá ye: Càŋ ye, nyí nde né nùà tebê nyî toò yeè temá njií, te à tɔɔ́ nyegé wò ceér.» ");
INSERT INTO mcu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","À den cuù ye bɔ́ a: «Mè né tueé ye bí a, bèh lɔ mé wɔ́ŋ lɔ deén naâ, bɔ́ lɔ née nùà koô déì faá Jâŋ Bàptîs nɔ ŋàr ŋgúŋgwéeh ye. Mé njéh mene, te *Lò Càŋe né mene huaán dé maàn, à ham kela seér cu né kɔɔ́ mé Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bèh léí mé Jâŋ Bàptîs lé tueé duɔɔ́m naâ ŋgòr Càŋ, tɔ́g nde wa hên, Lò Càŋ né lom mé taáb kwaré ndeé; bɔ̀ taáb bɔ̀ ye kɔ bɔ́ yieé bú yieè. ");
INSERT INTO mcu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dàm bɔ̀ sòn-Càŋ bɔ̀ lé naá giì felè Lò Càŋ tueé; mvù Músì tueé cu felè seèn môn ndɔ, te nde wa ye mé nàm Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ŋgweéh bí né yeé *Elî kela den wa? Mɔ bí nde né gwaán, mè tueé bí Elî sâ né Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nuaá né mé tie, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","À den cuù ye bɔ́ a: «Cafanê bɔ̀ nùàr den né faá kei wee? Mè tueé bí, bɔ́ den né faá bɔ̀ huaán mé né ké mbartɔgɔ̂ vɔgɔ́ den nɔ; bɔ̀ déì né mé bɔ̀ mbeí tueé njií, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Béh né mé térèm mbaá tuagá kuú, bí ŋgɔ̀ ŋgwéh! Béh né mene bɔ̀ bené kú-jerè genné, bí yúé ŋgwéh ndɔ! Bí ye: bɔ́ sà bá naàn wa? ");
INSERT INTO mcu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wanɔɔ́ŋ Jâŋ yeé waà, à sér yíé ŋgwéh, à mbè ŋúé ŋgwéh, bɔ́ ye: À né mé tándulu yoòr. ");
INSERT INTO mcu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","*Huaán Nùàr yeé waà dé seèn, à yieé sér, à ŋueé mbè, bɔ́ den cuù ye: Nùà hên kɔ lom né yieê mé ŋueê; à né mbeí bɔ̀ vevenê bɔ̀ mé bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mene! Mé njéh mene, mè tueé bí: seé Càŋ né gi tueé ŋagá, ye kékɔŋ Càŋ yila né teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jomo sâ, bɔ̀ lɔɔ́ mé Yeésò lé naâ fém teèn kókoó bɔɔ́, à duɔɔ́m bɔ́ nde njiî. Lòù sam, bɔ́ lé dene bɔɔ̀n kwéh sér ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","À ye bɔ́ a: «Wò lɔɔ́ Korasêŋ, wò nde né meì bɔ̀ gèr ŋené! Becaida, wò nde né gèr ŋené ndɔ! Mɔ gèh fém mé lé bɔɔ́ naâ lètenè biì hên sé bɔɔ́ naâ ké Tîr bɔ̂ Sídɔ̀ŋ, mè tueé bí, dàb mé bɔ̀ nùàr ké sâ sé lɔ temé kweéh seér gi aá kèn, bɔ́ yií wè, bɔ́ su tou, te feh keéh ye bɔ́ kweéh seér aá temé. ");
INSERT INTO mcu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mè tueé bí, loù ju tenâ, gèr dé biì taré kela nde né kɔɔ́ mé dé Tîr bɔ̂ Sídɔ̀ŋ hèllè. ");
INSERT INTO mcu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Déì né cu wò Kapernahûm. Wò munó né ye, nyí nde né ké te vulúu ŋgulí waá wa? Ndɔ́g, mè tueé wò, bɔ́ wò ba njií seér nde né ké ndugo bɔ̀ càŋ. Mɔ gèh fém mé lé bɔɔ́ naâ lètenè bɔ̀ nùàr yeè hên sé lé bɔɔ́ naâ ké *Sɔ́dɔ̀m, lɔɔ́ hèllè sé née teèn ye. ");
INSERT INTO mcu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mé gècên mene, loù ju tenâ, ju dé yeè nde né dé Sɔ́dɔ̀m taré yɔgɔ́ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jomo sâ Yeésò deên ndɔ, ye Tele a: «È môn, Tele mò, vulú bɔ̂ tàbè né gi beè yeè, mè vra baá wò! Lòù sam, njií mé né njolò bɔ̀ kɔ́gɔ̀n bɔ̀ mé bɔ̀ lo bɔ̀ cibi mbaá leér den, njua yeè mé wò bɔ́ feh keéh seér né mé bɔ̀ huaán tetɔɔ̂r mân. ");
INSERT INTO mcu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","È môn, Tele mò! Sâ né njií mé wò gwaán nê. ");
INSERT INTO mcu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Mè tueé bí, Tele mò njèh dɔɔ́ŋ kwaá lɔ gi né beè mò. Mé njéh mene, nuaré déì kɔ́ ŋgwéh ye: hên né Huaán; gi cu né ka Tele. Nuaré déì kɔ́ ŋgwéh ye: hên né Tele ndɔ, gi cu né ka Huaán mé bɔ̀ɔ́ mé Huaán né bɔ́ Tele feh doô.» ");
INSERT INTO mcu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jomo sâ, ye bɔ́ a: «Bí bɔ̀ɔ́ mé seé né bí felè mbiín den dɔɔ́ŋ, bí ndé gî ká beè mò, te bí kwa dù. ");
INSERT INTO mcu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bí ndê màn njèh ká beè mò. Lòù sam, mè né mé temé dɔlê mé kɔ́-jere lè, temé biì nde né lè die. ");
INSERT INTO mcu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tòù dé mò táré ŋgwéh; seé mò bí líé yɔ́gɔ́ ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Cu déì lé naâ teèn, sâ bɔ̀ Yeésò né te ŋueèh yolò gɔ kelá. Lé naâ *cieé sóù ndɔ. Cùè yeé baá bɔ̀ mbɔ̀ŋ seèn sie, bɔ́ yila lùà kwalé weèh, bɔ́ né segé yieé. ");
INSERT INTO mcu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bɔ̀ *Farisiên yeé ŋene aá ménâ, bɔ́ ye Yeésò a: «Kè kú bɔ̀ mbɔ̀ŋ yeè kán. Ŋgweéh *sóú beèh né yiín ye, loù sóù bɔ́ té ménâ bɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeésò ye bɔ́ a: «Njií mé *Davîd nùà njèh lé naâ bɔɔ́ doô, bí née jáŋé kè ŋgwéeh ye wa? Loù sâ cùè lé naâ bɔ́ bɔ̀ nùàr seèn sie, ");
INSERT INTO mcu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","à yila nde te gwà Càŋe, à nde jɔgɔ weh yáb mé bɔ́ lé kwaá lɔɔ̀ naâ ké toò Càŋ, bɔ́ bɔ̀ nùàr seèn yieé. Sâ bí né kɔɔ́ ye, né yeé jolo, bɔ̀ *ŋgàŋ sèmè yieé cegé yeé kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sóú Músì né cu beré déì ménâ tueé ndɔ ye: loù sóù, bɔ̀ ŋgàŋ sèmè nde né seé ké gwà Càŋ koô bɔɔ́, bɔ́ *cieé sóù táŋ ndé ŋgwéh; mé njéh mene, sóú bɔ́ sìè ndé ŋgwéh ndɔ. Bí née dé sâ jáŋé ŋéné ŋgwéeh ye wa? ");
INSERT INTO mcu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mè tueé bí, kwarè biì hên den den né njií mé né gwà Càŋ sâ yɔgɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ŋgweéh né te mvù Càŋe nyagá den ye: Mè gwaán kela né nùà kɔ́-jerè mé nùà há-sèmè. Mɔ bí sé la né ŋgòr sâ ŋgweé kɔɔ́, bí sé la bɔ̀ sòn fuû bɔ̀ mbaá sìè ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bí kɔ́ɔ ye, *Huaán Nùàr né cieé sóù yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeésò yeé yuo aá doó sâ, à yila nde te *gwà sóù bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sâ nùà be ŋemâ déì né gwò sâ ndɔ. Bɔ́ bie njií ye Yeésò a: «Sóú beèh ye táré sɔ̀m nùàr loù sóù tarè wa?» Sâ bɔ́ ye te bɔ́ sie bú teèn. ");
INSERT INTO mcu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","À deên ndɔ, ye bɔ́ a: «Hên mɔ lètenè biì mbieè nuaré déì die suaga ké dòù loù sóù, mé gi cegé né ka bú mé njéh sâ, à bú loù sâ beè nomo sɔ̀m kéh ndé ŋgwêh wa? ");
INSERT INTO mcu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Á, sé tagá nùàr wa? Sâ mɔ né mân, sóú beèh tueé né ye, béh bɔ́ bagaà loù sóù bɔɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jomo sâ Yeésò tueé njií mé nùà be ŋemâ doô, ye bú a: «Nèbbè be yeè nebbè.» Nùà hèllè nebbé be ndɔ, be seèn taré yuo, den cu ka faá kèb déì nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Te bɔ̀ Farisiên yeé nde ŋene njií ménâ, bɔ́ kem yuo kela gi cie, bɔ́ nde sòn nyɔgɔ, te bɔ́ wula sɔm Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeésò yeé ŋgweé aá ménâ, à kwaá lɔ bɔ́ doó sâ, à fɔɔ́n gò seèn. Cìlì nùàr kem bele cu bú jomo ndɔ. À né bɔ̀ beên bɔ̀ dɔɔ́ŋ taré sɔm gií. ");
INSERT INTO mcu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","À né bɔ́ luɔm, ye bɔ́ a: «Càŋ a bɔ́ bí tueé sɔm ndègè mò cie.» ");
INSERT INTO mcu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá Esáyà *sòn-Càŋ lɔ naâ tueé nɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Càŋ ye: Hên né nùà seê nyî, nyí bú balé sɔm né mé be nyî, né huaán yíé-temé nyî, à né nyí temé lè bɔɔ́ nɔré. Nyí nde né bú Cúcuí nyî yoòr nyeén kwaá, te à feh bɔ̀ nùàr ceér dilî, bɔ́ ju beè nyî dìè cú. ");
INSERT INTO mcu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","À tɔgɔ mé nùàr mbembaá ndè gɔ̀ ndé ŋgwéh, à njèh lòù ŋgáré ndé ŋgwéh. Né mene te kpɔŋe, bɔ́ hueh seèn teèn ŋgwé ndé ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gor né mene gobosé, à bú sìè kwá sɔ̀m ndé ŋgwéh. Lâm yuúm le mene lòù, à bú nyímé sɔ̀m ndé ŋgwéh. À bɔɔ́ den nde né méménâ tɔ́g te be gècên seèn yuo ŋa ter. ");
INSERT INTO mcu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te lò nùàr dɔɔ́ŋ kwaá njií gi ndèm yoòr seèn ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bɔ́ weh waà mé nùà cùgò njolò déì ká yoòr Yeésò ndɔ. Nùà hèllè né cu mùmúr; né càŋ tándulu bɔɔ́ né bú ménâ kɔɔ́. Yeésò taré sɔm bú; à duɔɔ́m sòn tueê, à ŋene njolo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hiím laré bɔ̀ nùàr doó dɔɔ́ŋ; bɔ́ ye: «Bí ye hên Ŋunà *Davîd sam á?» ");
INSERT INTO mcu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te bɔ̀ Farisiên yeé nde ŋgweé njií mân, bɔ́ den seér cuù dé bɔɔ̀n ye: «Nùà hên bɔ̀ tándulu mé feh seèn kwɔ́gɔ́ ŋgwéh. *Beljebu, mgbè bɔ̀ tándulù, bú terreb ménâ haá né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeésò kɔ gi mùnò bɔɔ̀n ndɔ, ye bɔ́ a: «Né mene lè lò mgbè dé heè, mɔ bɔ̀ nùàr né lètenè bɔɔ̀n kerré kuú, lò sâ nde né tɔb yuo. Né mene lɔɔ́, né mene mbàgà déì, mɔ bɔ̀ nùàr né lètenè bɔɔ̀n kerré kuú, sâ bɔ́ nde né kum yuo! ");
INSERT INTO mcu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mɔ Sátàn hên kwɔgɔ den cu né Sátàn mbeí seèn kɔɔ́, sâ Sátàn lege kuú cu né mé ŋgàŋ yoòr seèn. Mɔ né mân, sâ lò seèn tɔ̀b yùò ndé ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mɔ sé né gècên, ye mè tándulu kwɔgɔ né mè terreb Sátàn, sâ dé bɔ̀ ŋuna biì nɔ, neì bɔ́ terreb haá yeé kɔɔ́, bɔ́ kwɔgɔ tándulu mé njéh wa? Bí kwá biì nɔɔ́ŋ, bɔ̀ ŋuna biì sie nde né bí nyeén kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","À den cuù ye bɔ́ a: «Mè bɔ̀ tándulu kwɔgɔ né mé terreb Cúcuí Càŋ. Sâ bí kɔ́ɔ ye: Mbàm Càŋ die waà baá ká yoòr biì kèn.» ");
INSERT INTO mcu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","À den cuù ye bɔ́ a: «Mɔ nùà gwà né mé terreb yoòr, nuaré déì gwò seèn mbaá yílá ndé ŋgwéh, à nde yíb ŋuɔb, kɔ à jɔ̀gɔ̀ kaga gi aá nùà gwà hèllè kèn, te à ŋuɔb ye bú. ");
INSERT INTO mcu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mè tueé bí, nuaá mé jomo mò sam, né nùà bùnò mò; nuaá mé mè nùàr teèn bílí gàm ŋgwéh, né nùà ŋéllé-nùàr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mè cicie hên tueé njií né dé cî, ye bí a: nùàr a, bɔ́ mene gèh veên dé heè, bú a, júé mene yilí Càŋ, Càŋ nde né doó kulú njií gií. Nuaá mé dé seèn jue seér né Cúcuí Ŋagâ, bɔ́ veên seèn lè kúlú sɔ̀m ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nuaá mé né *Huaán Nùàr jueé, bɔ́ nde né veên seèn doó kulú njií. Nuaá mé dé seèn jue seér né Cúcuí Ŋagâ, bɔ́ veên seèn lè kúlú sɔ̀m ndé ŋgwéh dé ndɔ̂g. Né mene cafanê, ndeè né mene ké jomo, mban le nde aá môn dé nyèmà mé nyèmà.» ");
INSERT INTO mcu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yeésò den cuù ye bɔ̀ nùàr a: «Nuaá mé gwaán né tàb bagaà, à dobo toú dé bagaà ndɔ; mɔ bí dobo né toú veên, bí kwa cu nde né tàb dé veên ménâ ndɔ. Bɔ́ kèkènè toú dé kàn ŋene kɔ né mé tàb seèn. ");
INSERT INTO mcu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gèh ŋgòbò faá bí nɔ! Bí biì ŋgòr bebagaà sònò tueé keéh nde né he mé jéré-temé biì doô? Ŋgweéh sòn seèn tueé né njií mé goón den né ké te temé wa? ");
INSERT INTO mcu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nùà bagaà bɔ̀ njèh bebagaà sɔm weh yeé lètenè bɔ̀ njèh seèn dé bebagaà; nùà veên sɔm weh yeé dé seèn lètenè bɔ̀ njèh seèn dé vevenê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mè tueé bí, loù ju tenâ, bɔ̀ mamvuan ŋgòr mé sòn lé naá giì mbembaá fela njií dɔɔ́ŋ, nde gi né loù sâ cie kulu yuo. ");
INSERT INTO mcu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bɔ́ ju yeè tena nde né faá leba yeè lé tueé naâ nɔ, wò nde né-re mvelé wa, wò nde né die wa, né beè yeè.» ");
INSERT INTO mcu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yeé baá ménâ, bɔ̀ *njí-sóù mé bɔ̀ *Farisiên déì ye Yeésò a: «Nùà fèh-njèh, béh gwaán né fém cén beè yeè ŋenê, te béh kɔ ye Càŋ wò terreb haá né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeésò ye bɔ́ a: «Bɔ̀ cafanê bɔ̀ né lom bɔ̀ jélá-temé bɔ̀: bɔ́ temé yoòr Càŋ mbaá kwá njí cú, kɔ bɔ́ ŋene né fém, sâ ye. Mè tueé bí, bɔ́ ŋéné ndé cú, faga le aá te fém mé Càŋ lɔ bɔɔ́ naâ yoòr Jonâs *sòn-Càŋ doô. ");
INSERT INTO mcu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gèh dé mé Jonâs lé ceér naâ lè ŋgò cieé tagár doô, *Huaán Nùàr cer nde né dòù cieé tagár ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Loù téná-juù, bɔ̀ Ninivè bɔ̀ nde né ter kem wuo, bɔ́ sie bɔ̀ cafanê bɔ̀ nyeén. Lòù sam, bɔ̀ Ninivè bɔ̀ lé naâ dé bɔɔ̀n ŋgòr Jonâs ŋgweé, bɔ́ kweéh seér temé. Sâ nuaá mé né Jonâs yɔgɔ́ keéh né gi kwarè bɔ̀ cafanê bɔ̀ teèn. Mé njéh mene, bɔ́ temé kwéh sér ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwá nɔɔ́ŋ, loù-téná juù, mgbè dé vêh mé lɔ deén naâ ké túno, nde né ter komo wuo, à sie bɔ̀ cafanê bɔ̀ nyeén. Lòù sam, à lɔ yuoó naâ tɔ́g ké kunduŋ, bèh mé tàbè bɔ̂ vulú né teèn kwaré, à ndeè bèh ŋgòr kɔ́gɔ̀n sònò Salomɔ̂ŋ ŋgweê. Sâ nuaá mé né Salomɔ̂ŋ yɔgɔ́ keéh né gi kwarè bɔ̀ cafanê bɔ̀ teèn. Mé njéh mene, bɔ́ né lòù saán seér.» ");
INSERT INTO mcu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Sâ càŋ tándulu déì lé naâ lè nuaré déì dula yuo kelá, à nde ké ya dueè, à né bèh cèrrè te hobó ŋemâ fɔɔ́n gɔ. Mé njéh mene, à bèh cèrrè kwà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yeé baá ménâ, à ye: Kènê, nyí nde cu nde aá ké lɔ, lè nuaá mé nyí lé yuoó naâ teèn doô. À wa, sâ gwà née lòù mbaá den den ye, bɔ́ fɔ gi aá, bɔ́ te nyegé gi aá bèh denè gwò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","À yeé ŋene aá ménâ, à nde yilá fɔɔ́n cu bɔ̀ càŋ déì téhbeh mé né bú jelá yɔgɔ́, bɔ́ bɔ́ waà, bɔ́ bilí yila nde lè nùà hèllè. Nùà doô die cu péb; beén seèn taré yɔgɔ́ keéh cu dé jomò.» Yeésò yeé tueé gi aá mân, à den cuù ye bɔ́ a: «Dé bɔ̀ cafanê bɔ̀ mé jélá-temé bɔɔ̀n doô, nde cu né ménâ nág.» ");
INSERT INTO mcu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Meì Yeésò mé bɔ̀ dìm Yeésò waà, sâ Yeésò née mé bɔ̀ nùàr mân tueé njií den ye. Bɔ̀ meí seèn njebá le yí cie, ye te bɔ́ tueé bú njií. ");
INSERT INTO mcu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nuaré déì tueé Yeésò ndɔ, ye bú a: «Meí yeè bɔ́ bɔ̀ dìm yeè né wò yí cie njebá ke den, bɔ́ gwaán né wò njií tueê.» ");
INSERT INTO mcu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeésò ye nùà doô a: «Meí mò né neì, bɔ̀ dìm mò né bɔ̀ neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jomo sâ, à me njií bɔ̀ mbɔ̀ŋ seèn mé be, ye nùàrè a: «Meí mò mé bɔ̀ dìm mò né seér bɔ̀ hên bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bɔ̀ɔ́ mé né sòn Tele mò ké te vulúu ŋgweé dɔɔ́ŋ, bɔ̀ dìm mò, bɔ̀ tie mò, bɔ̀ meí mò né bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Loù sâ Yeésò yuo ké lɔ, à nde den seér ké dùà sòn tuùb njèh feh den. ");
INSERT INTO mcu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Cìlì nùàr ŋgún bilí nde gi teèn. À yeé ŋene aá ménâ, à ŋaá yila te kɔme, à den nde doó, sâ cìlì nùàr baá gi sòn nòmò teé den. ");
INSERT INTO mcu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","À duɔɔ́m bɔ̀ nùàr njèh kókoó mbaá te kàne silí keêh, ye bɔ́ a: «Nuaré déì lé ndeè naâ ké ŋueh bèh gèh vuû. ");
INSERT INTO mcu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","À yeé baá gèh vuú, kèb déì sue le ceér dueè. Bɔ̀ non waà, gwaré yieé sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kèb déì nde sue yila te kérré taâ, bèh sâ tàbè teèn màgà ŋgwéh. Ba yuoô wágácén ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lou yeé baá li, ŋema yuo cu. Lòù sam, bèh jɔgɔb yiî lé teèn ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kèb déì nde sue yila lètenè bɔ̀ ŋgobó deduanê, ba yuo ter. Yeé baá kulá, bɔ̀ ŋgobó deduanê hèllè lané wula sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kèb déì nde dé seèn sue yila bèh tàbè bagaà, ba yuo kelà, wa tàb: tab déì mvum teèn yuií, tab déì yulà ténjén, déì yulà tagár.» ");
INSERT INTO mcu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yeésò den cuù, ye bɔ́ a: «Nuaá né mé tie, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jomo sâ bɔ̀ mbɔ̀ŋ seèn ŋgoró nde kwarè seèn, bɔ́ ye bú a: «Wò bɔ́ ŋgòr te kàne ménâ si gi né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ye bɔ́ a: «Dé biì, ŋgòr felè *Lò Càŋ mé Càŋ lɔ naâ lòù leér kwaá doô, Càŋ né bí ceér feh te bí ŋgweé komo. Dé bɔɔ̀n môn sam. ");
INSERT INTO mcu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mè tueé bí, nuaré déì nde gi né mé njèh beè, bɔ́ haá sagá cu bú déì teèn, te merré den bú beè lòù. Nuaré déì dé seèn mé njèh beè sam nde ŋgweéh, né mene dé maàn mé à né mé njéh dɔɔ́ŋ, bɔ́ nde né bú beè horó sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mè bɔ́ te kàne silí keéh den né dé cî. Lòù sam, bɔ́ né mbaá ke den, bɔ́ ŋéné ŋgwéh; bɔ́ né mbaá felá den, bɔ́ ŋgwé kɔ́ ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yeé baá mân, yuo baá-re felè bɔɔ̀n faá Esáyà *sòn-Càŋ lé naá giì tueé nɔ ye: Dé felâ, bí nde gi né bagasé felá nyegé, bí seér ŋgwé ndé ŋgwéh lòù. Bí nde gi né bagasé ke den, ndɔ́g bí seér ŋéné kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lòù sam, temé bɔ̀ nùà hên baá gi lè maŋgwan, te bɔ́ mùnò kòmò cú. Bɔ́ duagá baá tie kèn, te bɔ́ mé tie ŋgwé cú. Bɔ́ lier aá njolo, te bɔ́ mé njolo ŋéné cú. Te bɔ́ ká yoòr mò ndé sér cû te mè bɔ́ táré sɔ̀m cú ndɔ, jue mè Càŋ dueè. ");
INSERT INTO mcu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dé biì, njua biì wa: njolo biì né ŋené, tie biì né ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mè né tueé ye bí a: dàm bɔ̀ sòn-Càŋ bɔ̀ mé bɔ̀ didilí bɔ̀ kókoó mbaá lɔ ye te bɔ́ ŋene faá bí né ŋené hên, ndɔ́g. Bɔ́ ye te bɔ́ ŋgweé kwa faá bí né ŋgweé hên, ndɔ́g ndɔ, dɔɔ́ŋ lé naá giì bɔ́ liím.» ");
INSERT INTO mcu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Bí ŋgwé nyégé kwɔ̀m kàn nùà vú-gèh doô bagasé: ");
INSERT INTO mcu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","bɔ̀ɔ́ mé né ŋgòr felè Lò Càŋ ŋgweé, bɔ́ ŋgwé kòmò ŋgwéh dɔɔ́ŋ, né gi faá kpɔŋ ceêr mé gèh lé sue leé naâ teèn cie doô. Nùà bùnò yeé waà, à luaga sɔm gi bɔ́ gèh njèh sâ lè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bɔ̀ déì felá né tàbè kérré taâ mé gèh lé sue yilà naâ teèn doô ndɔ: bɔ́ nde né ŋgòr Càŋ ŋgweé, bɔ́ gwaán nyegé mé vɔ́gɔ́-temé mene. ");
INSERT INTO mcu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Njèh cén, ŋgòr sâ jɔgɔb lè bɔɔ̀n yí ŋgwéh; bɔ́ gwaán lom né cuúr cén mbaá. Gèr sé yeé baá bɔ́ te ŋgòr Càŋe coró, bɔ̀ nùàr né bɔ́ mé njéh bunó, bɔ́ cuaré yuo wúwágá. ");
INSERT INTO mcu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bɔ̀ɔ́ mé né lètenè bɔ̀ ŋgobó deduanê sue yilá doô né bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, bɔ́ nyamé le mé *wɔ́ŋ, bɔ́ né te ŋgùlù wɔ́ŋe faá bɔ́ gwaán nê nɔ samé ndeé, né mé bɔ́ bele ndeé ndɔ. Nde nde bɔ̀ njèh hèllè karé wula sɔm njií ŋgòr Càŋ lè bɔɔ̀n, bɔ́ le cùr. ");
INSERT INTO mcu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bɔ̀ nuaré déì dé bɔɔ̀n den né faá bɔ̀ gèh mé bɔ́ vuú né te tàbè bagaà nɔ. Bɔ̀ sâ bɔ̀ né ŋgòr Càŋ ŋgweé, bɔ́ né ŋgweé nyegé. Yeé baá ménâ, bɔ́ né tàb waá ndɔ; tab déì mvum teèn yuií, tab déì yulà ténjén, déì yulà tagár.» ");
INSERT INTO mcu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeésò si cu bɔ́ kàn déì, ye bɔ́ a: «Lò Càŋ den cu né faá nuaré déì lé naâ gèh ké ŋueh seèn vuú nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cíbíteèn, bɔ̀ nùàr yeé baá gi lɔ́m, nùà bùnò seèn nde gui teèn naáb kɔ yií bele, à fɔɔ́n gò seèn. ");
INSERT INTO mcu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jomo sâ gèh doô ba yuoô, kula gi. Yeé baá velé, gui haá feh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bɔ̀ seê bɔ̀ seèn yeé ŋene aá ménâ, bɔ́ waà ye bú a: Tele beèh, ŋgweéh wò lé ké ŋueh vuú loóm naâ léláŋ gèh bagaà wa? Á, gèh nyure veên ké teèn kela he wa? ");
INSERT INTO mcu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ye bɔ́ a: Nùà bùnò déì bɔɔ́ né ménâ kɔɔ́. Bɔ́ ye bú a: Kwá béh nde nyure veên hèllè komó sɔm wa? ");
INSERT INTO mcu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ye bɔ́ a: Sam, bí nde né mé yab mene komó bilí. ");
INSERT INTO mcu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bí kwá bɔ́ bɔ́ den bɔɔ̀n ménâ, kɔ bɔlé baá kèn. Loù sâ mè tueé nde né ye bɔ̀ seé bɔ̀ a: kènê, bí ndé hóbó bá hobò; bí jɔ̀gɔ̀ kòmò sɔ̀m gî nyure veên ye, bí ŋuaán bilí kwaá keém keém, te bí fu njií tuar; jomo sâ bí weh kwaá njiî yab ká lɔ te mbáŋe.» ");
INSERT INTO mcu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeésò si cu bɔ́ kàn déì ndɔ, ye bɔ́ a: «*Lò Càŋ den né faá mvum tàb làm mé nuaré déì lé naâ ké ŋueh seèn dobo kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Támbên lètenè bɔ̀ mvuùm dɔɔ́ŋ né lom bú; tàyàm lètenè bɔ̀ toû né cu bú ndɔ. Mɔ à kula baá, bɔ̀ non nde fulu tieé gi yeé teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeésò si cu bɔ́ kàn déì, ye bɔ́ a: «*Lò Càŋ den né faá kulu nɔ. Ma déì lé naâ dɔɔ́m weh, à si ŋgàb tàgà ndètoón cùɔ̀b tîn mé njéh. Yeé baá jelá, fulu komo njií gùm tàgà dɔɔ́ŋ ter.» ");
INSERT INTO mcu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeésò bɔ̀ ŋgòr hên dɔɔ́ŋ si keéh lom né bɔ̀ nùàr te kàne te kàne; à ŋgòr mbaá túé njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","À lé ménâ bɔɔ́ belé naâ, ye te yuo faá *sòn-Càŋ déì lé naâ tueé nɔ, ye: «Mè bɔ́ njèh si keéh nde né te kàne te kàne, mè bɔ́ teèn tueé keéh nde né bɔ̀ njií mé bɔ́ lé naâ lòù leér kwaá, sâ wɔ́ŋ duɔɔ́m née lòù ye.» ");
INSERT INTO mcu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jomo sâ Yeésò kwaá lɔ bɔ̀ nùàr doó sâ, à nde cu ké gwò. Wa ké teèn, bɔ̀ mbɔ̀ŋ ŋgoró nde ké kwarè seèn, bɔ́ ye bú a: «Sè yeè béh kàn nyure veên ké ŋueh doô teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeésò ye bɔ́ a: «Nuaá mé naâ gèh dé bagaà dobo né *Huaán Nùàr; ");
INSERT INTO mcu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ŋueèh né wɔ́ŋ; gèh dé bagaà né bɔ̀ *Lò Càŋ bɔ̀; nyure veên dé seèn né bɔ̀ŋ bɔ̀ vevenê bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nùà bùnò mé naâ nyure veên dobo né *Sátàn. Cu yab hobô né loù mé wɔ́ŋ nde né teèn gií; bɔ̀ seé bɔ̀ né bɔ̀ cìlì Càŋ. ");
INSERT INTO mcu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Gèh dé mé bɔ́ komó ŋgie njií yeé nyure veên tuar doô, loù mé wɔ́ŋ gi nde né teèn nde cu né ménâ nág ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Huaán Nùàr nde né bɔ̀ cìlì seèn te bɔ̀ŋ bɔ̀ nùàr seèn temá njií. Bɔ́ nde né bɔ̀ vevenê bɔ̀ mé bɔ̀ njèh dé vevenê lètenè bɔɔ̀n dɔɔ́ŋ geí sɔm gií, ");
INSERT INTO mcu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bɔ́ bilí ŋgie njií tuar te we tarê, bèh kéŋ silî mé nyie yieé kuû. ");
INSERT INTO mcu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Loù sâ, bɔ̀ didilí bɔ̀ te Lò Tele bɔɔ̀n ba nde né faá lou nɔ. Nuaá né mé tie, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«*Lò Càŋ den né faá ŋgùlù mé lé naâ ké ŋueh leér den nɔ. Nuaré déì yeé ŋa kwa baá, à baré leér cu, à nde bɔ̀ njèh seèn mé vɔ́gɔ́-temé mene go sɔm gií, à ŋge weh seér ŋueèh sâ.» ");
INSERT INTO mcu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«*Lò Càŋ den né faá nùà toôn déì lé naâ gɔ̀m matàn fɔɔ́n gɔ nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","À yeé kwa baá, à nde bɔ̀ njèh seèn go sɔm gií, à ŋge weh seér cí.» ");
INSERT INTO mcu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«*Lò Càŋ den cu né faá ndoór mé bɔ́ né ké dùà vuú, à né ŋgò dɔɔ́ŋ kabé bilí nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yeé baá deí, bɔ́ tulu nde mé njéh yí sòn nòmò, bɔ́ den nde doó, bɔ́ geí weh bɔ̀ dé bebagaà teèn, bɔ́ kwaá ter; bɔ́ su njií cu bɔ̀ mvuagàr dùà. ");
INSERT INTO mcu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mè tueé bí, loù mé wɔ́ŋ nde né teèn gií, nde né ménâ nág. Bɔ̀ cìlì Càŋ nde né bɔ̀ vevenê bɔ̀ lètenè bɔ̀ dé bebagaà geí sɔm, ");
INSERT INTO mcu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","bɔ́ su njií tuar te we tarê, bèh kéŋ silî mé nyie yieé kuû.» ");
INSERT INTO mcu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeésò ye bɔ́ a: «Bí né gi dɔɔ́ŋ ŋgweé komo wa?» Bɔ́ ye bú a: «Nyea!» ");
INSERT INTO mcu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yeé baá ménâ, à den cuù ye bɔ́ a: «Sâ *njí-sóù mé nde né mbɔ̀ŋ te *Lò Càŋe ŋaá dɔɔ́ŋ, den né faá nùà njèh nɔ. À te ŋgúlú seèn sɔm weh né bɔ̀ njèh dé fefeê mé bɔ̀ njèh dé cucuûm mene.» ");
INSERT INTO mcu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeésò yeé si gi aá bɔ̀ kàn sâ, à fɔɔ́n gò ndɔ, ");
INSERT INTO mcu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","à cu cu lè lɔɔ́ mé à lé kulà naâ teèn. Wa ké teèn, à yila keéh lom njèh te *gwà sóù feh cuû. Bɔ̀ nùàr yeé ŋgweé aá, hiím gi bɔ́ doó dɔɔ́ŋ; bɔ́ ye: «À gèh kɔ́ŋkɔŋ mé fém dé hên weéh naâ he wa? ");
INSERT INTO mcu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ŋgweéh hên né ŋunà nùà kób-toû doô wa? Ŋgweéh meí seèn né Marî ndɔ wa? Ŋgweéh Jâk bɔ̂ Josêf, mé Simɔ̂ŋ bɔ́ bɔ̀ Jûde né gi bɔ̀ dìm seèn wa? ");
INSERT INTO mcu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ŋgweéh lètenè beèh hên né gi bɔ̀ tie seèn ndɔ wa? À gèh terreb dé hên weéh naâ he?» ");
INSERT INTO mcu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yeé baá ménâ, bɔ́ temé yoòr seèn kwá njí cú ndɔ. Yeésò yeé ŋene aá môn, ye bɔ́ a: «Bèh dɔɔ́ŋ, bɔ̀ nùàr né gi nuaá mé né *sòn-Càŋ veéh; sòn seèn ŋgeén seér yeé bɔ̀ lɔɔ́ bɔ̀ seèn mé bɔ̀ nùàr seèn ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","À yeé ŋene bɔ́ temé teèn kwá njí ŋgwéh ménâ, à fém ké sâ kókoó bɔ́ cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sâ *Herôde né mgbè cu sâ lè tàbè Galilê kɔɔ́. À yeé baá ŋgɔ́g Yeésò ménâ ŋgweé njií, ");
INSERT INTO mcu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ye bɔ̀ seê bɔ̀ seèn a: «Né Jâŋ Bàptîs komo yuo cuù né dòù kɔɔ́! À fém bɔɔ́ né mé terreb sâ.» ");
INSERT INTO mcu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sâ lòù sam, à lé seèn tueé naâ kɔɔ́, ye bɔ́ sìè kàgà njí Jâŋ gwà cibì. À lé bú môn bɔɔ́ kuú naâ felè Herodiâs veèh Filîp dìm seèn; à lé naâ ma sâ gwò ŋgaá kwaá njií. ");
INSERT INTO mcu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sâ Jâŋ lé naâ bú teèn bèsɔ́nè tueé njií ndɔ, ye bú a: «Né jolo. Wò sé lé veèh dìm yeè gwò wèh kwá ná ŋgwêh!» ");
INSERT INTO mcu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yeé baá mân, Herôde kaga lom kàgà-ndòn veên ndɔ, ye kɔ nyí wula sɔm aá Jâŋ. Njèh cén, à lé naâ bɔ̀ nùàr veéh. Lòù sam, bɔ́ lé naá giì dé bɔɔ̀n kɔɔ́ ye Jâŋ né *sòn-Càŋ. ");
INSERT INTO mcu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Te cu sâ cieé mé bɔ́ lé ŋaár naâ Herôde teèn yɔŋ kwaré cu ndɔ, à bɔɔ́ cieé koô. Ŋunà Herodiâs dé vêh waà, à ŋgɔ bené toò bɔ̀ kokoô bɔ̀ mé né doó sâ. Temé yeé nɔré kela baá Herôde lè, ");
INSERT INTO mcu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","à jege toò huaán doô, ye bú a: Njií mé wò né gwaán dɔɔ́ŋ nyí nde né wò haá ma! ");
INSERT INTO mcu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Te meí yeé nde ŋgweé njií ménâ, à soób ŋuna ndɔ, te ŋuna nde ye Herôde tueé, ye bú a: Téná kwá nyí feh Jâŋ Bàptîs te suúŋe ma. ");
INSERT INTO mcu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mgbè Herôde yeé nde ŋgweé njií mân, temé yili lom bú lè lég, à né jègè mé à la naâ toò bɔ̀ nùàr jege doô munó njií. Sie bú beè, ye sâ bɔ́ nde né bú feh Jâŋ tená haá. ");
INSERT INTO mcu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","À tema njií ndɔ, ye bɔ́ ndé téná wèllè feh Jâŋ Bàptîs ké gwà cibì ma. ");
INSERT INTO mcu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bɔ́ tena waà mé njéh te suúŋe, bɔ́ haá njií mé huaán doô. Huaán nde mé meí haá njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bɔ̀ mbɔ̀ŋ Jâŋ nde jɔgɔ furu sɔm kukuŋ. Bɔ̀ njií mé lé naâ kelá dɔɔ́ŋ, bɔ́ nde Yeésò tueé. ");
INSERT INTO mcu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeésò yeé ŋgweé aá njàgà sâ, à yuo doó sâ, à yila kɔm, à nde ser ké bèh ndɔ́ŋ-ndɔ̀ŋ mé huún seèn. Bɔ̀ nùàr ŋgweé gi ndɔ, bɔ́ kem yuo cu ké lɔ, bɔ́ bele bú ké sâ, bɔ́ gɔ bele seér dé bɔɔ̀n sòn nòmò sòn nòmò. ");
INSERT INTO mcu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","À yeé suaga die aá doó, à ŋene njií cìlì nùàr né merré den. Jere bɔɔ́ bú njèh, à duɔɔ́m cu bɔ̀ beén bɔ̀ lètenè bɔɔ̀n taré sɔm beleè. ");
INSERT INTO mcu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lou yeé yuɔm aá, bɔ̀ mbɔ̀ŋ seèn ŋgoró nde ké kwarè seèn, bɔ́ ye bú a: «Cu nde aá kelá, bèh hên né ká jomo ndɔ. Wò sé la kwaá lɔ bɔ̀ nùà hên nde cu lelɔ njèh yâb fɔɔ́n ŋge yieé.» ");
INSERT INTO mcu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeésò ye bɔ́ a: «Mɔ bɔ́ nde cu ménâ, húɔ́m ŋgwéh. Bí há bɔ́ yáb kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bɔ́ ye bú a: «Beè beèh gi cegé né breêd tîn mé ŋgò fà té fá.» ");
INSERT INTO mcu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ye bɔ́ a: «Bí há njî môn.» ");
INSERT INTO mcu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jomo sâ ye bɔ̀ nùàr a: «Bí dèn ndé gí doó te nyure.» À weh breêd tîn mé ŋgò fà doô, à ke njií njolo ké te vulúu, à dua Càŋ teèn, à kɔlé haá njií mé bɔ̀ mbɔ̀ŋ, te bɔ́ geé haá bele bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nùàr dɔɔ́ŋ yieé fulu gi; ndilí le. Bɔ̀ mbɔ̀ŋ ŋuaán bilí, yuú sɔgɔ́ yulà cùɔ̀b fà. ");
INSERT INTO mcu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bɔ̀ɔ́ mé lé yieé naâ yáb sâ lé naâ nùàr kám tîn. Sâ bɔ́ bɔ̀ véh mé bɔ̀ huaán teèn kùlà yí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bɔ́ yeé yieé sɔm aá, Yeésò kou yií njií bɔ̀ mbɔ̀ŋ seèn lè kɔme, te bɔ́ sela kela toò, bɔ́ nde kela den bú tub kèb yágà; à le ŋgɔgɔ̂ dé seèn ká jomo, te à sɔm gi bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","À yeé sɔm gi aá bɔ́, à ŋaá nde ké te tòre mé huún, bèh Càŋ duaà. Cibí yili lɔ bú ké teèn. ");
INSERT INTO mcu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sâ bɔ̀ mbɔ̀ŋ mé kɔm nde gi aá kèn; bɔ́ baá gi ké dàb; bɔ́ né mé fu tarê kwaré ndɔ, sâ nòmò né mé kɔm ké dùà libí ŋaáŋ yɔŋ. ");
INSERT INTO mcu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yeé baá mé be lɔ̂m nèà, Yeésò nde ké yoòr bɔɔ̀n ndɔ, à dé seèn gɔ nde seér né felè nòmò felè nòmò. ");
INSERT INTO mcu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te bɔ̀ mbɔ̀ŋ yeé nde ŋene njií, à baá felè nòmò gɔ ndeê ménâ, veéh bɔɔ́ bɔ́ njèh, bɔ́ ye né càŋ tándulu, bɔ́ sɔm kéŋ, sâ veéh nde aá bɔ́ sie wulá. ");
INSERT INTO mcu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tètèì sam, Yeésò ye bɔ́ a: «Bí sìè temé, né mè; bí té vèh.» ");
INSERT INTO mcu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piêr tueé keéh njií ndɔ, ye bú a: «Fehtoò beèh, mɔ né wò, há mè terreb teèn, te mè gɔ nde yí yoòr yeè felè nòmò ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeésò ye bú a: «Ndê!» Piêr yuo kela te kɔme ndɔ, duɔɔ̂m yí yoòr seèn felè nòmò gɔ ndeê. ");
INSERT INTO mcu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","À yeé ke, fu né ménâ kobó taré, càŋ tené bú lè, gule lɔgɔ́ yila dùà. À yeé baá ké ka nòmò lɔgɔ́ suagá, à sɔm kéŋ, ye Yeésò a: «Yìlì sɔ̀m mè teèn Fehtoò mò!» ");
INSERT INTO mcu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yeésò njií be, kwa sie bú ndɔ, ye bú a: «Temé yeè né kuú, wanɔɔ́ŋ wò ménâ saán naâ dé keì?» ");
INSERT INTO mcu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bɔ́ bú ŋaá yila nde te kɔme fà dɔɔ́ŋ, fu hèllè pɔ́ŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bɔ̀ mbɔ̀ŋ mé né gi lè kɔɔ̀m cemmé nde doó toò Yeésò, bɔ́ ye bú a: «Mé gècên mene, wò né Ŋunà Càŋ bɔ̀n!» ");
INSERT INTO mcu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bɔ́ nde sela yuo kela tub kèb yágà. Bɔ́ suaga die doó te tàbè Jenesarétè. ");
INSERT INTO mcu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bɔ̀ lɔɔ̂ bɔ̀ ŋene kɔ cu Yeésò, bɔ́ duɔɔ́m mé bɔ̀ déì tueé keêh, bɔ́ né nùàr te lɔɔ́ kukwarè temá njií ndɔ, te bɔ́ ye bɔ̀ nùàr a: Yeésò waà baá ma. Bɔ̀ nùàr domó wa giì mé dàm bɔ̀ beên bɔ̀ ká toò Yeésò, ");
INSERT INTO mcu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","bɔ́ né bú bɔŋ, ye bú a: «Mɔ bɔ̀ beén bɔ̀ kema weh cegé mene léláŋ sòn cɔ̀gɔ̀ yeè, bɔ́ nde né taré.» Bɔ̀ɔ́ mé lé naá belê kema dɔɔ́ŋ, lé naá giì taré yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jomo sâ bɔ̀ nuaré déì yuoô ké Jerusalem lètenè bɔ̀ *Farisiên mé bɔ̀ *njí-sóù, bɔ́ nde kwa Yeésò, bɔ́ ye bú a: ");
INSERT INTO mcu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Bɔɔ́ né naàn mé bɔ̀ mbɔ̀ŋ yeè né tabɔ́ kwaá lɔɔ́ wa? Wò ŋéné ŋgwéh, bɔ́ né yáb yieé, bɔ́ be faá tabɔ́ tueé nê nɔ, yàgà ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeésò deên ndɔ, ye bɔ́ a: «Á bí nɔ? Bí sòn Càŋ ŋgeén né dé keì wa? Ŋgweéh bí né tòù Càŋ kwaá lɔɔ́, bí feh seér tòù bɔ̀ tele biì wa? ");
INSERT INTO mcu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sâ Càŋ né gi tueé ye: Léb toò tele mé meí yeè, wò ŋgweé sòn bɔɔ̀n. À né cu tueé, ye nuaá mé duagá tele, wa né meí wa, bú a, kú táré lè teèn ŋgwán. ");
INSERT INTO mcu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mé njéh mene, bí ménâ fèh bèh; bí den seér cu né ye: Mɔ nuaré déì tueé njií mé tele, wa mé meí wa, ye bú a: nyí sé la naâ wò gam; njèh cén, baá gi *sèmè. Mɔ à né ménâ tueé, bí né gwaán. ");
INSERT INTO mcu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ŋgweéh sâ bí ye bú a: Té tele mbaá vèh kú cú wa? Ŋgweéh bí sâ bɔɔ́ ŋellé né ŋgòr Càŋ, te tòù lɔɔ̂ biì yam seér kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bɔ̀ sòn fà bɔ̀ faá bí nɔ, Esáyà sòn-Càŋ lɔ felè biì jue bɔ̀n, wa Càŋ ye: ");
INSERT INTO mcu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bɔ̀ nùà hên nyí seén kuú den né mé par sòn mbaá, temé bɔɔ̀n né bèh hiîn. ");
INSERT INTO mcu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Den né faá bɔ́ né nyí dua nɔ, sâ né dé lòù. Bɔ́ kwaá lɔɔ̀ né tòù nyî, bɔ́ feh seér tòù bɔ̀ tele bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jomo sâ Yeésò yilá bilí bɔ̀ nùàr, ye bɔ́ a: «Bí ŋgwé nyégé bagasé: ");
INSERT INTO mcu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","njií mé yila seér né sònò nùàr dé yilâ, bú kɔɔ́ bɔ́ yílí bèh; dé mé yuo kela seér né sònò seèn lòù bɔɔ́ yili yeé bú kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bɔ̀ mbɔ̀ŋ ŋgoró nde kwarè seèn ndɔ, bɔ́ ye bú a: «Wò né kɔɔ́ ye bɔ̀ *Farisiên la ŋgweé naâ ménâ, naâ bɔ́ seé weh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeésò ye bɔ́ a: «Bɔ̀ toú mé Tele mò ké te vulúu lé kɔɔ́ dòbò ná ŋgwêh dɔɔ́ŋ, bɔ́ nde né bɔ́ doó muró su njií. ");
INSERT INTO mcu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bí gè mé ceér bɔɔ̀n, né bɔ̀ tácugó! Mɔ tácugó derré né tácugó be kɔɔ́, sâ bɔ̂ mbeí fà dɔɔ́ŋ nde gi né ké dòù lùgò vulú die suagá.» ");
INSERT INTO mcu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piêr den cuù ye bú a: «Kàn njií mé bɔɔ́ yili né nùàr kɔɔ́ doô, sè béh teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeésò ye bú a: «Mé bí mene, bí née njèh ŋgwé kòmò ŋgwéeh ye wa? ");
INSERT INTO mcu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bí née kɔ́ ŋgwéeh ye: njií mé yila yeé sònò nùàr, mɔ baá ké lè, nde né ké cie suagá yuo kelá wa? ");
INSERT INTO mcu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Njií mé né sònò nùàr yuo kelâ, yuo yeé ké lè temê. Dé sâ nùàr bɔɔ́ yili né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Lòù sam, mùnò veên dɔɔ́ŋ jeré yuo den né te temé nùàr: wúlá-feh né sâ; yàgà ndeê né teèn; sár yɔɔ̀ŋ né sâ; yíb né teèn sâ; nyeén mé súí né gi teèn yaám den, ");
INSERT INTO mcu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","dɔɔ́ŋ yuo giì né te temê. Bɔ́ nùàr bɔɔ́ yili yeé kɔɔ́. Mè tueé bí, yáb mé be yilî yieê, nùàr kɔɔ́ bɔ́ yílí ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jomo sâ Yeésò yuo doó sâ ndɔ, à nde ser kwarè lɔɔ́ Tîr bɔ̂ Sídɔ̀ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wa ké teèn, ma Kanahân déì keéŋ waà doó sâ, né ma lɔɔ̂ ndɔ, ye bú a: «Dé koô, Ŋunà *Davîd, kɔ́ yeè mè jere teèn, huaán mò dé vêh nde aá mé gèr ŋené kuú, à né mé tándulu yoòr.» ");
INSERT INTO mcu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mé njéh mene, Yeésò bú sòn kòmò ŋgwéh. Bɔ̀ mbɔ̀ŋ yeé ŋene aá ménâ, bɔ́ ŋgoró nde yoòr Yeésò, bɔ́ ye bú a: «Njí cú ma hên lɔ, à né béh jomo mbembaá keéŋ bele gɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeésò deên ndɔ, ye bɔ́ a: «Bɔ́ hên tema kuú naâ mè felè bɔ̀ *Iserálà bɔ̀. Bɔ́ den né faá bɔ̀ mbieè mé né lòù leér le nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma doô nde cemmé die nde toò Yeésò ndɔ, ye bú a: «Dé koô, gàm yeè mè teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeésò ye bú a: «Mɔ bɔ́ si njií yáb bɔ̀ huaân mé boór, húɔ́m ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ye Yeésò a: «Né ka môn jég, dé koô. Á sâ, bɔ̀ boór tòmò yâb domó yieé yeé ka teleè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeé baá ménâ, Yeésò ye bú a: «Môn, dé vêh, wò né temé yoòr mò mé terreb mene kwaá njií; bú a, bɔ́ wò faá wò né gwaán nɔ.» Ŋunà ma hèllè taré yuo beè nomo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeésò yuo cuù doó sâ, à nde ké sòn tub Galilê. Wa ké teèn, à ŋaá nde ké te tòre. À yeé baá ké sâ den den, ");
INSERT INTO mcu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","bɔ̀ nùàr ŋgún kem wa cuù ké teèn mé bɔ̀ beên bɔ̀ beè: bɔ̀ gule kukuû bɔ̀, bɔ̀ cùgò njolo bɔ̀, bɔ̀ gule cécéné bɔ̀, bɔ̀ tándúg mé bɔ̀ beên bɔ̀ déì ndɔ. Bɔ́ nde bilí kwaá gi bɔ́ ké toò Yeésò, à taré sɔm bɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bɔ̀ tándúg tueé gi sòn, bɔ̀ gule kuú bɔ̀ mé bɔ̀ tácɔgɔ́ gɔ dilí gi, bɔ̀ cùgò njolo bɔ̀ ŋene gi njolo. Cìlì nùàr yeé ŋene aá ménâ, hiím yɔgɔ́ bɔ́ dé tueê. Bɔ́ né Càŋ ké ter seén njií, ye Tele *Iserálà né lom bú. ");
INSERT INTO mcu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeésò yilá njiî bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: «Jere né mè mé bɔ̀ nùà hên sie: kè kú lan baá cieé tagár, béh bɔ́ né lom kɔɔ́; bɔ́ mé yáb beè sam cuú ndɔ. Mè gwàn ŋgwéh bɔ́ lɔ mé lèì cùè ménâ yi njiî, bɔ́ nde né ceér dueè die le.» ");
INSERT INTO mcu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bɔ̀ mbɔ̀ŋ ye bú a: «Á, gèh cìlì nùàr dé hên, béh yáb ká ya dueè hên weh ndeè né he, te béh koó komo bɔ́ mé njéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeésò ye bɔ́ a: «Bí beè né mé breêd meèn wa?» Bɔ́ ye bú a: «Né téhbeh mé bɔ̀ ŋgò tetegér mân.» ");
INSERT INTO mcu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yeésò ye bɔ̀ nùàr a: «Bí dèn ndé gí doó.» ");
INSERT INTO mcu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jomo sâ à weh breêd téhbeh mé bɔ̀ ŋgò doô, à vra Càŋ teèn, à kɔlé haá njií bɔ̀ mbɔ̀ŋ, te bɔ́ geé haá bɔ̀ nùàr. Bɔ́ geé haá gi bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bɔ́ dɔɔ́ŋ yieé fulu gi; ndilí le. Bɔ̀ mbɔ̀ŋ ŋuaán bilí, yuú sɔgɔ́ téhbeh. ");
INSERT INTO mcu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bɔ̀ɔ́ mé lé yieé naâ yáb sâ dɔɔ́ŋ lé naâ kám nèà; sâ bɔ́ bɔ̀ véh mé bɔ̀ huaán teèn kùlà yí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bɔ́ yeé yieé gi aá, Yeésò yi njií ye bɔ́. À yila cu dé seèn kɔm, à nde ser te tàbè Magádàn. ");
INSERT INTO mcu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bɔ̀ *Farisiên mé bɔ̀ *Sadusiên bilí ndeè yoòr Yeésò te bɔ́ felá bú sòn, bɔ́ ye bú a: «Jɔ̀gɔ̀ bɔ́ ke fém déì mé feh keéh né ye wò bɔɔ́ né seé mé terreb Càŋ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yeésò ye bɔ́ a: «Jue ka bí! Mɔ baá liyilì mé bí ke vulú né ter bèlèsé, bí ye: kwéh nom nde né sɔɔ́. Sɔɔ́ ka môn. ");
INSERT INTO mcu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mɔ bí ŋene, yuoô maánjɔ̀gɔ̀ vulú né ter bɔ hunó, bí ye: nu nde né lan neé. Ne ka môn ndɔ. Bí né gi bɔ̀ njií sâ ŋené kɔɔ́. Yeé baá bɔ̀ njèh dé nàm biì hên, taré yɔgɔ́ bí wa? ");
INSERT INTO mcu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bɔ̀ cafanê bɔ̀ né lom bɔ̀ jélá-temé bɔ̀, bɔ́ temé yoòr Càŋ mbaá kwá njí cú, kɔ bɔ́ né fém ŋené, sâ ye. Kènê bɔ́ ŋéné ndé cú ndɔ, faga le aá te fém mé Càŋ lé bɔɔ́ naâ yoòr Jonâs léí doô.» À yeé tueé gi aá mân, à fɔɔ́n gò seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jomo sâ bɔ́ bɔ̀ mbɔ̀ŋ seèn sela yuo kela tub kèb yágà ndɔ, bɔ́ nyen njií breêd beè weh sieè. ");
INSERT INTO mcu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeésò yeé baá bɔ́ luɔm, bɔ́ munó seér cí. Sâ à lé ye bɔ́ a: «Bí bɔ̀ŋ feh biì mé kulu bɔ̀ Farisiên bɔ́ bɔ̀ Sadusiên.» ");
INSERT INTO mcu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yeé baá ménâ, bɔ́ yila lètenè bɔɔ̀n tueé kuû, ye: «À jue né breêd mé béh la naâ nyen doô.» ");
INSERT INTO mcu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeésò yeé ŋene aá ménâ, ye bɔ́ a: «Bí lètenè biì môn tueé den né dé keì ye: mè jue né breêd mé bí mé njéh beè sam doô wa? Temé kuú né bí lòù. ");
INSERT INTO mcu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hên bí née ka njèh ŋgwé kòmò ŋgwéeh ye wa? Hên bí mùnò kɔ́ cú mé breêd tîn lé naâ nùàr kám tîn koó doô wa? Bí bɔ̀ sɔgɔ́ ndilí yâb kùlà kɔ́ cú ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bí dé breêd téhbeh mé lé koó naâ nùàr kám nèà doô mùnò kɔ́ cú á? Bí bɔ̀ sɔgɔ́ ndilí yâb mé bí lé jɔgɔ́ sɔɔ́m naâ doô kɔ́ cú ndɔ sé wa? ");
INSERT INTO mcu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wanɔɔ́ŋ mè yeé tueé, ye bí a: Bɔ̀ŋ feh biì mé kulu bɔ̀ Farisiên bɔ́ bɔ̀ Sadusiên, kei mé bɔɔ́ bí kwɔ̀m sâ ŋgwé kɔ́ ŋgwéh wa? Bí kɔ́ ŋgwéh, ye mè felè breêd júé ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yeé baá môn, te bɔ̀ mbɔ̀ŋ nde ye ŋgweé komo, ye à bɔ́ luɔm seér né felè leba mé bɔ̀ Farisiên bɔ́ bɔ̀ Sadusiên né yeé feh doô, à felè kulu dé breêd túé ŋgwéh ma. ");
INSERT INTO mcu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeésò yuo doó sâ, à nde ser te tàbè Sesarê Filîp. Wa ké teèn, ye bɔ̀ mbɔ̀ŋ seèn a: «Bɔ̀ nùàr ye Huaán Nùàr né neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bɔ̀ mbɔ̀ŋ ye bú a: «Bɔ̀ déì ye wò né Jâŋ Bàptîs, bɔ̀ déì ye wò né *Elî, bɔ̀ déì ye: wò ne Jeremî, mɔ sam, sâ né *sòn-Càŋ déì.» ");
INSERT INTO mcu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ye bɔ́ a: «Á bí nɔ, bí ye mè né neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔ̂ŋ Piêr ye bú a: «Wò né *Nùà Cɔ̀ŋ, ŋunà Càŋ làŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeé baá môn, Yeésò ye bú a: «Njua yeè Simɔ̂ŋ ŋunà Jâŋ, nùàr wò gècên sâ kɔɔ́ fèh ná ŋgwêh; né Tele mò ké te vulúu feh né wò ménâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kwá mè tueé ŋagá wò mân: yilí yeè né Piêr, sâ jue né kweéh; mè bɔ̀ŋ bɔ̀ nùàr mò bilí kwaá nde né felè kweéh sâ. Cio mé terreb seèn mene bú njeré déì bɔ́ ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mè nde né wò kî *Lò Càŋ beè haá kwaá: mɔ wò yiín njeré déì ká doó, bɔ́ yiín bú ké te vulúu ménâ; mɔ wò yi ká doó, bɔ́ yi cu ké te vulúu ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","À yeé tueé gi aá mân, ye bɔ́ a: «Càŋ a bɔ́ bí ye nuaré déì a, mè né Nùà Cɔ̀ŋ!» ");
INSERT INTO mcu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jomo sâ, à yila baá-re bɔ̀ mbɔ̀ŋ njèh feèh, ye bɔ́ a: «Kɔ mè nde ké Jerusalem, te mè ŋene laré dàm gèr beè bɔ̀ kokoô bɔ̀ lɔɔ̂, bɔ́ bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù. Bɔ́ nde né mè wulá; lè cieé tagáre mè nde cu né lè cio komo yuo ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yeé baá mân, Piêr weh nde mé bú ké jomo bèh ndɔ́ŋ-ndɔ̀ŋ mân, à nde bú ndɔ, ye bú a: «Càŋ a bɔ́ wò kuú gèh cio bú sâ, Fehtoò mò. Càŋ a, lùàgà sɔ̀m sér wò teèn lòù.» ");
INSERT INTO mcu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yeésò bele seér ndɔ, ye Piêr a: «Máb *Sátàn, cú yo nɔɔ́ŋ! Hên, wò gwaán né mè te veéne tulu si njiî; wò faá Càŋ nɔ mùnò ŋgwéh, wò munó seér né faá bɔ̀ nùàr nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jomo sâ à tueé njií mé bɔ̀ mbɔ̀ŋ seèn ndɔ, ye bɔ́ a: «Nuaá mé ye nyí gwaán né jomo mò beleè dɔɔ́ŋ, kɔ à ŋgɔn feh seèn, à nde mbin weh toú gèr seèn, à bele mè, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mè tueé bí: nuaá mé gwaán né yɔ̀ŋ seèn mé feh seèn yili sɔɔ̀m, nde né bú leér lɔɔ́. Nuaá mé né dé seèn cio felè mò ŋgɔɔ́n seér, nde né yɔ̀ŋ kwa. ");
INSERT INTO mcu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Njií mé gam nde né nuaá mé né njèh ka lè wɔ́ŋe dɔɔ́ŋ kwa laré te yɔ̀ŋ seèn leér le teèn, né kei wa? Njií mé nùàr nde né yɔ̀ŋ seèn mé njéh ŋaá sɔm né teèn wa? Ndɔ́g, teèn sam. ");
INSERT INTO mcu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","«Bí kɔ́ɔ ye *Huaán Nùàr wa ndeè né loù sâ mé terreb Tele seèn yoòr. À *sum wa ndeè né lètenè bɔ̀ cìlì seèn mé sàgà nùà kàn beè: à gwɔm nde né nùà kàn faá seé seèn tueé keéh nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mè né tueé ye bí a, mé bí nde dɔɔ́ŋ kuú gií, sâ Huaán Nùàr waà baá kèn, bɔ̀ déì lètenè biì hên ŋene bú te kɔgɔ mé njolo.» ");
INSERT INTO mcu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yeé kela baá cieé ténjén, mé téhbeh Yeésò weh Piêr bɔ̂ Jâk mé Jâŋ dìm Jâk, bɔ́ bɔ́ ŋaá nde ké felè tòr mé huún bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wa ké teèn, Yeésò kweéh seér yo njolò bɔɔ̀n: kuún seèn ba seér faá lou nɔ, bɔ̀ cɔ̀gɔ̀ yoòr seèn ŋa seér bɔ̀ dé wuwulê, wula ŋuerré seér faá lou ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bɔ̀ nuaré déì kar yuo kelà toò bɔɔ̀n. Lé naâ Músì bɔ̂ *Elî. Bɔ́ bɔ̀ Yeésò né sòn tueé den. ");
INSERT INTO mcu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piêr ye Yeésò a: «Fehtoò beèh, kwá béh den le kɔ hên. Mɔ wò né gwaán, mè nde né pàgà tagár sieé: dé yeè cén, dé Músì cén, dé Elî cén ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piêr yeé baá sònò mân tueé den, bègè déì ba wula suagà ter, ka sie bɔ́ beè. Hueh déì né yí lètenè-bɔ̀ ŋgulí den ye: «Hên né Huaán yíé-temê mò, temé mò né lè mé bú nɔré, bí ŋgwé gí sòn seèn.» ");
INSERT INTO mcu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bɔ̀ mbɔ̀ŋ yeé nde ŋgweé njií ménâ, veéh kibí su bɔ́ yoòr, bɔ́ die sulí njií gi njolo doó. ");
INSERT INTO mcu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeésò ŋgoró nde yí kwarè bɔɔ̀n ndɔ, à kema njií bɔ́ be yoòr, ye bɔ́ a: «Bí wùò ter, bí té vèh.» ");
INSERT INTO mcu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bɔ́ komó njií cu feh ter, bɔ́ ke, bɔ́ nuaré déì ŋéné cú, bɔ́ ŋene lom aá Yeésò mé huún. ");
INSERT INTO mcu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bɔ́ yeé baá ké te tòre suagá cuû, à luɔm bɔ́, ye bɔ́ a: «Càŋ a bɔ́ bí tueé nuaré déì bɔ̀ njií mé bí ŋenè naâ hên. Bí kwá lɔ́ lè biì, kɔ loù mé *Huaán Nùàr komo yuo aá lè cio, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jomo sâ, bɔ̀ mbɔ̀ŋ ye bú a: «Bɔ̀ *njí-sóù tueé né dé keì ye Elî wa lɔgɔ́ ndeè né kɔɔ́ mé *Nùà Cɔ̀ŋ wa?» ");
INSERT INTO mcu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ye bɔ́ a: «Né bɔ̀n! Elî ndeè né faá bèh sâ waâ, te à sie nyegé cu bɔ̀ njèh dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mé njéh mene, mè tueé bí, Elî lé naá giì waâ, bɔ̀ nùàr lé bú ŋéné kɔ́ ná ŋgwêh lòù, bɔ́ sie seér cu bú faá bɔ́ lé gwaán naâ nɔ. Nde né mé Huaán Nùàr ménâ ndɔ, bɔ́ nde né bú gèr feh keéh.» ");
INSERT INTO mcu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","À yeé tueé aá ménâ, bɔ̀ mbɔ̀ŋ nde ye ŋgweé komo, ye Elî mé à né tueé doô, à jue né Jâŋ Bàptîs ma. ");
INSERT INTO mcu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bɔ́ wa beré déì, cìlì nùàr né silí den, nuaré déì ŋgoró nde kwarè Yeésò, à cemmé nde doó toò seèn, ");
INSERT INTO mcu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ye bú a: «Dé koô, kɔ́ yeè huaán mò jere teèn, à né yeé nab die. Gèh dé sâ né lom taré dé gècên: mɔ baá bú ŋaâ, à né yeé tuar die yilá; cu déì, à die yila dùà ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mè weh njií mene bú ké yoòr bɔ̀ mbɔ̀ŋ yeè, bɔ́ tándulu sâ yoòr seèn kwɔ́gɔ́ kòmò ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeésò deên ndɔ, ye: «Jue ka bí bɔ̀ dúágá-tie bɔ̀ mé jéré-temé biì sâ! Hên béh bí née cu-re heèh wa? Mè bí seŋ den cu nde né heèh ndɔ wa? Wèh ndê mé huaán sâ kán.» ");
INSERT INTO mcu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Huaán yeé waà baá, Yeésò pam kwɔgɔ sɔm tándulu hèllè yoòr seèn ndɔ, huaán doô taré yuo beè nomo. ");
INSERT INTO mcu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bɔ̀ mbɔ̀ŋ yeé ŋene aá ménâ, bɔ́ ŋgoró nde yí kwarè Yeésò léláŋ bɔɔ̀n, bɔ́ ye bú a: «La bɔɔ́ naâ naàn mé béh bú kwɔ́gɔ́ kòmò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeésò ye bɔ́ a: «Bí biì né mé temé kuú nɔ! Mè né tueé ye bí a, mɔ ndèm biì sé la né faá mvum tàb làms nɔ ham waá, bí sé la naâ tueé ye tòr hên a: Ndé kòmò dèn kíê, à sé la né sòn biì ŋgweé, njeré déì sé la bí yɔ́gɔ́ ná ŋgwêh.  ");
INSERT INTO mcu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mè tueé bí: gèh tándulu bú hên kwɔgɔ́ sɔɔ̀m, kɔ né lom te Càŋ duaà mé yáb joloò ndɔ, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cieé déì bɔ̀ mbɔ̀ŋ yeé baá gi cu ké Galilê bècénè dɔɔ́ŋ, Yeésò ye bɔ́ a: «*Huaán Nùàr nde né beè bɔ̀ nùàr yilá, ");
INSERT INTO mcu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bɔ́ wula sɔm bú; te cieé tagáre à nde cuù né lè cio komo yuo.» Bɔ̀ mbɔ̀ŋ yeé nde ŋgweé njií ménâ, yo bɔɔ̀n kuú gi mé gùm mene. ");
INSERT INTO mcu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yeésò bɔ́ bɔ̀ mbɔ̀ŋ cu cu ké Kapernahûm ndɔ. Wa ké teèn, bɔ̀ɔ́ mé weh yeé kàgàlɔ̀ŋ làmpɔ̂ŋ te gwà Càŋe ŋgoró nde, ye Piêr a: «Tele biì dé seèn làmpɔ̂ŋ gwà Càŋ gwɔ̀m bèh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piêr ye bɔ́ a: «À né yeé gwɔm.» Cu mé Piêr yeé baá ké gwò yilá ndeé, Yeésò jɔ̀gɔ̀ bie lɔgɔ́ cuù bú kɔɔ́ ye, ye bú a: «Wò dé yeè ŋene né naàn Simɔ̂ŋ? Ká lè wɔ́ŋe dɔɔ́ŋ, bɔ̀ mgbèémgbè làmpɔ̂ŋ weh yeé beè bɔ̀ huaân wa, né yeé beè bɔ̀ nùàr wa?» ");
INSERT INTO mcu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piêr ye bú a: «Né yeé beè bɔ̀ nùàr.» Yeésò ye bú a: «Ne môn, kɔ bɔɔ́-re naàn wanɔɔ́ŋ bɔ̀ huaán yeé gwɔ̀m bèh. ");
INSERT INTO mcu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mé njéh mene, béh gwàn ŋgwéh bɔ́ temé lè bɔɔ́ yulâ. Wèh nób, ndé ké te tube si, mèlè sɔ̀m kêh ŋgò cén, wò sie ŋaám bú sòn, wò luaga weh kàgàlɔ̀ŋ teèn, wò nde, wò gwɔm njií bɔ́, dé làmpɔ̂ŋ mò, mé dé yeè.» ");
INSERT INTO mcu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Cu sâ bɔ̀ mbɔ̀ŋ bilí nde ké kwarè Yeésò ndɔ, ye bú a: «Te *Lò Càŋe neì kela né kɔɔ́ mé bɔ̀ mbeí wa?» ");
INSERT INTO mcu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yeésò yilá njiî huaán déì, à njebá kwaá bú ká toò bɔɔ̀n, ");
INSERT INTO mcu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ye bɔ́ a: «Mè né tueé ye bí a, mɔ bí kwéh sér ŋgwéh, bí faá bɔ̀ huaán tetɔɔ̂r nɔ dèn ŋgwéh, ndɔ́g bí Lò Càŋ yílá ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nùà koô ké te Lò Càŋe né nuaá mé né lom cie mbaá faá huaán hên nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nuaá mé né huaán déì faá huaán hên nɔ sie nyegé, mɔ à bú sie nyegé né felè mò, sâ à sie nyegé né mè nùà njèh.» ");
INSERT INTO mcu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Bɔ̀ huaán tetɔɔ̂r mé né temé yoòr mò kwaá njií hên, nuaá mé dɔr njií cén déì lè veéne nde né mé gèr kwaré. Sâ nùà hèllè ye, mé sòn gèr hèllè bɔ́ wèh ndé kɔ́ mé nyí ké sòn nòmò koô, bɔ́ jɔ́gɔ́ kàgà kwá nyí nyèn tuagaà, bɔ́ vela si njií kɔ nyí dùà. ");
INSERT INTO mcu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kwá nɔɔ́ŋ, *wɔ́ŋ nde né meì bɔ̀ gèr ŋené, à nùàr te veên bele su njií né kɔɔ́. Dé bɔ̀ njií mé nde né nùàr mé veên taáb, bɔ́ ká lè wɔ́ŋe lím ndé ŋgwéh. Njèh cén, nuaá mé né yìè déì teèn kɔɔ́, nde né meì bɔ̀ gèr ŋené. ");
INSERT INTO mcu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Né mene be yeè, né mene gule yeè, mɔ à wò te veên dɔr yií né kɔɔ́, cɔ̀ sɔ̀m bú, wò si njií bú ké dàb. Huɔm kela né yɔ̀ŋ mé be cén, gule cén kwaà; wanɔɔ́ŋ mɔ wò né mé be fà, gule fà, seŋ den, bɔ́ nde né gùm yeè dɔɔ́ŋ te we dé ndeèr si njií. ");
INSERT INTO mcu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mɔ njolo yeè wò te veên dɔr yií né kɔɔ́, lùàgà sɔ̀m bú, wò si njií bú ké dàb. Huɔm kela né yɔ̀ŋ mé njolo cén kwaà; wanɔɔ́ŋ mɔ wò né mé njolo fà seŋ den, bɔ́ nde né gùm yeè dɔɔ́ŋ tuar te we tarê si njií.» ");
INSERT INTO mcu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Bí bɔ̀ŋ feh biì, bí té bɔ̀ huaán tetɔɔ̂r sèb. Mè tueé bí, jomo bɔɔ̀n né bɔ̀ cìlì Càŋ mé den yeé ké te vulúu toò Tele mò. ");
INSERT INTO mcu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bí kɔ́ɔ ye, *Huaán Nùàr tétég hên nde kuú naâ ye te nyí yili sɔm bɔ̀ɔ́ mé né lòù leér le. ");
INSERT INTO mcu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bí jɔ̀gɔ̀ mùnò ke ye: hên mɔ nuaré déì né mé mbieè yuií, cén déì nde leér le, à bɔɔ́ nde né naàn? À bɔ̀ dé yulà tárènèà cùɔ̀b tárènèà doô ké te tòre kwá lɔ́ ndé ŋgwéh, à nde dé cên doô fɔɔ́n wellê wa? ");
INSERT INTO mcu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mè né tueé ye bí a, mɔ à fɔɔ́n kwaá baá bú, à vra kela nde né dé sâ, mé bɔ̀ yulà tárènèà cùɔ̀b tárènèà bɔ̀ mé lèr ná ŋgwêh doô. ");
INSERT INTO mcu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Né ka beè Tele biì ké te vulúu nág ménâ ndɔ: à gwàn ŋgwéh mé lètenè bɔ̀ huaán hên cén déì leér le teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Mɔ mbeí yeè baá veên bɔɔ́, ndé yoòr seèn, bí bú fà, wò salé njií gi bú njonjolò. Mɔ à ŋgweé né sòn yeè ŋgweè, sâ wò ŋgaá kwa cu aá nùàr yeè kèn. ");
INSERT INTO mcu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Á, mɔ à sòn yeè ŋgúŋgwéh, yílá wèh cú nùà cén, wa né fà wa, te njèh dɔɔ́ŋ nyegé den njolò bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mɔ à cu ka sòn bɔɔ̀n ŋgúŋgwéh, sâ jɔ́gɔ́ njí bá bú te mɔ̀gɔ̀ bɔ̀ Càŋ bɔ̀. Mɔ à ŋgeén cu aá sòn bɔɔ̀n, sâ kè njí á bú faá cɔɔ́ŋ nɔ; mɔ sam, nùà wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yeésò den cuù ye bɔ́ a: «Mè né tueé ye bí a: mɔ bí yiín njeré déì ká doó, bɔ́ yiín bú ké te vulúu ménâ; mɔ bí yi ká doó, bɔ́ yi cu ké te vulúu ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mè né ka bí tueé ye bí a: Mɔ lètenè biì nuaré déì bɔ̂ mbeí den bilí ká doó fà, bɔ́ colo sòn felè njeré déì, né mene kei, mɔ bɔ́ né Càŋ teèn dua, Tele mò ké te vulúu nde né bɔ́ haá. ");
INSERT INTO mcu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bí kɔ́ɔ ye, bèh mé nùà fà mé tagár né teèn mé yilí mò bilí den dɔɔ́ŋ, mè né lètenè bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yeé baá ménâ, Piêr ŋgoró nde kwarè Yeésò, ye bú a: «Fehtoò mò, hên mɔ mbeí mò né ka mè veên bɔɔ́ den nɔ, mè doó kulu njií nde né mbei meèn wa? Nde né mbei téhbeh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeésò ye bú a: «Mbei téhbeh gí cégé ndé ŋgwéh, mè tueé wò, nde né yulà téhbeh mbei téhbeh. ");
INSERT INTO mcu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sâ *Lò Càŋ né faá mgbè déì lé naâ kàgà-ndòn kaga, ye nyí nde né bɔ̀ hùà nyî beè bɔ̀ seê bɔ̀ nyî kaá weh. ");
INSERT INTO mcu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","À yeé baá mé njéh taáŋ ndeé, bɔ́ weh waà bú mé mambin déì teèn; hùà hèllè né lom málaré mé málaré te mbeî. ");
INSERT INTO mcu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nùàrè bɔɔ́ mene naàn, à hùà doô gwɔ̀m kòmò ndé ŋgwéh. Yeé baá mân, mgbè doô ye bɔ́ gò sɔ̀m bú lòù, bɔ́ gò sɔ̀m veèh seèn, bɔ́ gò gí bɔ̀ ŋuna mé bɔ̀ njèh seèn mene dɔɔ́ŋ, te gwɔm hùà nyî kèb déì. ");
INSERT INTO mcu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nùà hùà doô yeé nde ŋgweé njií mân, à die tere nde doó toò tele seê seèn hèllè, à né bú be kobó, ye bú a: Kúkùr yeè, tele mò, sìè temé felè mò, mè nde né wò gwɔm gií. ");
INSERT INTO mcu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tele seê seèn yeé ŋene aá ménâ, jere sie yɔgɔ́ bú, à kwaá lɔ bú hùà doô dɔɔ́ŋ, à yi njií bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Nùà hùà doô yeé baá doó sâ yuo, bɔ̂ nuaré déì kwaré, à né nùà sâ kám yuií bele; né mbeí seê seèn ndɔ. À yeé nde ŋene keéh bú mân, à ŋar sie bú tuagaà tég, ye bú a: Gwɔ̀m nyí hùà nyî. ");
INSERT INTO mcu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mbeí die tere nde doó gule seèn, né bú be kobó, ye bú a: Kúkùr yeè, sìè temé felè mò, mè nde né wò gwɔm gií. ");
INSERT INTO mcu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mbeí né mene môn tueé dɔɔ́ŋ, à dé sâ táŋ ŋgwéh, à nde mgbeé yií njií bú gwà cibì, ye bú a: Kɔ wò gwɔm gi aá hùà nyî, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Bɔ̀ mbeí seê déì yeé ŋene aá ménâ, temé yulá bɔ́ lè, bɔ́ nde cu ké yoòr tele seê bɔɔ̀n, bɔ́ tueé gi bú bɔ̀ njií mé la kela giì naâ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tele seê bɔɔ̀n yeé nde ŋgweé njií ménâ, ye bɔ́ ndé sìè cú cû mé nùà hùà nyî hèllè. À yeé waà baá, tele seê seèn ye bú a: Nùàr seê jéré-temê faá wò nɔ sam, mè tueé wò. Jɔ̀gɔ̀ wò yeé baá mè be kobó, jere sie yɔgɔ́ mè, mè yi lɔ wò dàm bɔ̀ hùà mò dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ŋgweéh wò sé la naâ mbeí yeè jere faá bèh sâ kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Temé ŋaâ tele seê doô ndɔ, ye bɔ́ ndé sì njí bú ké gwà cibì, kɔ à gwɔm gi aá hùà nyî ndɔ, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeésò den cuù, ye bɔ́ a: «Mè tueé bí, mɔ bí né veên bɔ̀ mbeí biì lè kurú kwaá den, bí doó kúlú njí ŋgwéh, Tele mò ké te vulúu bɔɔ́ nde né mé bí faá bèh ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yeésò yeé tueé nyegé gi aá bɔ́ mân, à kwaá lɔ Galilê, à nde ser yí sòn nòmò Jurdên kèb yágà te sòn tàbè Judê kèb déì. ");
INSERT INTO mcu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cìlì nùàr kem bele cu bú ké sâ ndɔ; à taré sɔm gi bɔ̀ beén bɔ̀ lètenè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bɔ̀ *Farisiên déì ŋgoró nde baá-re Yeésò sòn felá, bɔ́ ye bú a: «Mɔ veèh nuaré déì bɔɔ́ sab aá njeré déì, né mene kei, *sóú beèh ye nùàr a, té bú sɔ̀m wa?» ");
INSERT INTO mcu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeésò ye bɔ́ a: «Bí te mvù Càŋe jáŋé ŋéné ŋgwéh, ye: ké bèh duɔɔ̂m, Càŋ lɔ naâ nùàr meé, dé siîb cén, dé vêh cén wa? ");
INSERT INTO mcu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","À ye, né dé cî mé nùàr nde né tele mé meí si lɔɔ́, à nde kwa veèh, bɔ́ bú den, te bɔ́ fà dɔɔ́ŋ ŋa lom cén. ");
INSERT INTO mcu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sâ tueé né ye, kènê bɔ́ fà sam cuú, bɔ́ baá seér njèh cén. Mɔ né mân, njií mé Càŋ nyɔgɔ́ bilí gi aá, ndɔ́g nùàr a, té gè sɔ̀m.» ");
INSERT INTO mcu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bɔ̀ Farisiên ye bú a: «Á, dé mé Músì lɔ ye: mɔ nùàr sɔm véh, bú a, nyàgà há ma sâ mvù beè nɔ?» ");
INSERT INTO mcu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeésò ye bɔ́ a: «Músì lɔ ménâ gwaán kuú naâ felè dúágá-tie biì, wanɔɔ́ŋ ké te ndègè lé môn ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mè né ka bí cicie tueé kwaá: nuaá mé sɔm véh mé yàgà ndé ná ŋgwêh, jɔgɔ cu déì ká jomo dɔɔ́ŋ, kuú baá yàgà.» ");
INSERT INTO mcu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bɔ̀ mbɔ̀ŋ deên ndɔ, ye bú a: «Mɔ hên né ka njií mé nde né felè huaán siîb bɔ̂ ma vêh kelá bɔ̀n, sâ nùàr a, té véh mbaá jɔ́gɔ́ kú.» ");
INSERT INTO mcu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeésò ye bɔ́ a: «Né taré, bɔ̀ nùàr ŋgòr hên dɔɔ́ŋ ŋgwé kòmò bèh, gi cegé yeé bɔ̀ɔ́ mé Càŋ né bɔ́ terreb sâ haá.» ");
INSERT INTO mcu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","À den cuù ye bɔ́ a: «Bɔ̀ nùàr liím cu né véh jɔgɔ̂ mé yìè bɔ̀ njèh hihinê ndɔ: bɔ̀ déì né kuú, yɔgɔ́ né bɔ́ cí; bɔ̀ déì, bɔ̀ nùàr ka né bɔ́ tùlù kɔɔ́; dé bɔ̀ déì, ju *Lò Càŋ yila né bɔ́ yoòr kɔɔ́. Yeé baá ménâ, bɔ́ liím ye véh ndɔ. Nuaá mé nde né ŋgòr hên ŋgweé, bú a, ŋgwé nyégé bagasé!» ");
INSERT INTO mcu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jomo sâ bɔ̀ nùàr né mé bɔ̀ huaán tetɔɔ̂r ká yoòr Yeésò weh ndeê, te à ba bɔ́ be felè, à dua Càŋ teèn. Bɔ̀ mbɔ̀ŋ nde seér cu bɔ́ dé ndeè. ");
INSERT INTO mcu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeésò ye bɔ́ a: «Bí kwá bɔ̀ huaán ndeè ká yoòr mò, bí té bɔ́ yín. Bí kɔ́ɔ ye, *Lò Càŋ né dé bɔ̀ɔ́ mé den né faá bɔ́ nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jomo sâ à ba bɔ́ be felè, à yuo doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nuaré déì ŋgoró ndeè kwarè Yeésò, ye bú a: «Nùà fèh-njèh, mè bɔɔ́ nde né gèh bagaà dé heè, te mè kwa yɔ̀ŋ tètàgà teèn wa?» ");
INSERT INTO mcu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeésò ye bú a: «Wò mè te njèh dé bagaà bie né mé ŋgei wa? Dé bagaà né lom Càŋ. Mɔ wò gwaán né yɔ̀ŋ kwaà, wò jòlò *sóú Càŋ.» Ye Yeésò a: ");
INSERT INTO mcu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","«Sóú Càŋ dé heè wa?» Yeésò ye bú a: «Té feh wúlá, te yàgà ndé, te yíb ŋúɔ́b, te nuaré déì nyeén yoòr cɔ̀ kwá. ");
INSERT INTO mcu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ŋgwé sòn tele yeè mé meí yeè; gwàn mbeí yeè faá wò gwaán né ŋgàŋ yoòr yeè nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nùà doô ye bú a: «Mè né yeé bɔ̀ sâ bɔ̀ jolo gií. Njeré déì né cu mè le ye wa?» ");
INSERT INTO mcu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeésò ye bú a: «Mɔ wò gwaán né ye te nyí yuo lom kɔ́bè sâ jég, ndé gò sɔ̀m bɔ̀ njèh yeè, wò geé haá njií bɔ̀ saám bɔ̀ kàgàlɔ̀ŋ sâ, te wò kwa seér ŋgúlú ké ter te vulúu. Jomo sâ wò ndeè, wò bele mè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te huaán ndà hèllè yeé nde ŋgweé njií dé sâ mân, à munó njií gi ŋgúlú seèn dɔɔ́ŋ, à durú yuo seér aá doó sâ lòù. ");
INSERT INTO mcu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yeésò yeé ŋene aá ménâ, à ye bɔ̀ mbɔ̀ŋ seèn a: «Mè né tueé ye bí a, te Lò Càŋ yilâ, nde né beè nùà lieê taré. ");
INSERT INTO mcu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ŋgweéh né taré mé ŋgelobà yila kela te lɔ́ŋ kɔ̀gɔ̀târ wa? Né ménâ mé nùà lieê ndɔ; te Lò Càŋe yilâ nde né beè seèn taré.» ");
INSERT INTO mcu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bɔ̀ mbɔ̀ŋ yeé ŋgweé aá ménâ, bɔ́ hiím gi dɔɔ́ŋ; bɔ́ ye bú a: «Sâ, mɔ né mân, nuaá mé nde né yili yuo né neì?» ");
INSERT INTO mcu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeésò ke njií bɔ́, ye bɔ́ a: «Taré yɔgɔ́ né bɔ̀ nùàr, wanɔɔ́ŋ dé Càŋ njeré déì bú táré yɔ́gɔ́ ŋgwéh gùm dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piêr deên ndɔ, ye bú a: «Ŋgweéh béh hên vu lɔ gi aá bɔ̀ njèh beèh dɔɔ́ŋ, béh bele wò mà. Sâ béh ndeè dé beèh kwa nde né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeésò ye bɔ́ a: «Mè né tueé ye bí a, mɔ *Huaán Nùàr ndeè baá ké te lɔɔ́ feê te kɔgɔ seèn ŋaá *sum den, bí bɔ̀ yulà cùɔ̀b fà bɔ̀ mé né gi jomo mò hên, nde né te kɔgɔ ménâ den gií ndɔ, te bí tueé ju felè gèh bɔ̀ huaán *Iserálà yulà cùɔ̀b fà doô. ");
INSERT INTO mcu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bí kɔ́ɔ ye, bɔ̀ɔ́ mé vu lɔ né gwà bɔɔ̀n wa, né bei wa, né dìm wa, né mene tie, né mene tele mé meí, né mene ŋuna, né mene ŋueèh, mɔ bɔ́ vu lɔ né felè mò, bɔ́ nde cu né méménâ te mbeí yuiî kwa gií, te bɔ́ teèn kwa bilí cu ye mé yɔ̀ŋ tètàgà mene. ");
INSERT INTO mcu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mè tueé bí: nùàr kókoó lètenè bɔ̀ ké toò bɔ̀ nde gi né ké jomo kelá seér; nùàr kókoó lètenè bɔ̀ ké jomo bɔ̀ kela seér cu ké toò.» ");
INSERT INTO mcu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Mè tueé bí, *Lò Càŋ felá né dèbbè nùà ŋueèh déì; à lé komo yuoó naâ maánjɔ̀gɔ̀, à nde bɔ̀ seé bɔ̀ ké ŋueh yií. ");
INSERT INTO mcu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bɔ́ bɔ́ colo gi sòn, ye nyí gwɔm nde né bɔ́ cieé cén kám cén faá bɔ́ gwɔm yeé nɔ. Jomo sâ à weh njií bɔ́ ké ŋueh bèh seê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","À yuo kela cuù mé lou lɔ̀ŋ tárènèà, sâ bɔ̀ déì né ké cie mbaá tɔɔ́m den, ");
INSERT INTO mcu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ye bɔ́ a: Bí ndé ké ŋueh mò seé bɔɔ́ ndɔ, mè gwɔm yií nde né bí teèn. ");
INSERT INTO mcu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bɔ̀ sâ bɔ̀ nde cu ké teèn. Nùà doô yɔŋ yuo kela cuù déì, sâ lou dilí baá; déì mé lou lɔ̀ŋ tagár; dɔɔ́ŋ à bɔɔ́ den ka njèh cén sâ. ");
INSERT INTO mcu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","À nde yuo kela weéh baá dé jomò mé lou lɔ̀ŋ tîn, sâ bɔ̀ déì baá cu ké cie mbaá tɔɔ́m den, ye bɔ́ a: Bí ká cie mbaá bɔɔ́ sɔɔ́ yeé kei wa? ");
INSERT INTO mcu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bɔ́ ye bú a: Nuaré déì seèn béh seé wèh ŋgwéh nɔ! Ye bɔ́ a: Sâ bí ndé ké ŋueh mò bèh seê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Yeé baá liyilì, nùà ŋueèh doô ye mabɔn a: Yílá bílí bɔ̀ seé bɔ̀ yilà, te wò gwɔm bɔ́ kàgàlɔ̀ŋ seê bɔɔ̀n; gwɔ̀m dùɔ̀m bɔ̀ɔ́ mé yila ceré naâ ká jomo, te wò nde ceré seér mé bɔ̀ɔ́ mé la yila lɔgɔ́ naâ maánjɔ̀gɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«Bɔ̀ɔ́ mé yilà naâ seé liyilì mé lou lɔ̀ŋ tîn doô waà ndɔ, bɔ́ weh bele kám cécéné. ");
INSERT INTO mcu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bɔ̀ɔ́ mé la yila lɔgɔ́ naâ seé kɔɔ́ yeé ŋene aá ménâ, bɔ́ ye merré déì kàgàlɔ̀ŋ dé bɔɔ̀n maga kela nde né kɔɔ́; kàmbér dɔɔ́ŋ né gi ka kám cécéné sâ. ");
INSERT INTO mcu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bɔ́ duɔɔ̂m kám cécéné hèllè ménâ weèh ndɔ; bɔ́ né weh, bɔ́ né teèn ndugó yií, ");
INSERT INTO mcu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ye nùà ŋueèh a: Hên béh bɔ̀ liyilì bɔ̀ weh cu né kàgàlɔ̀ŋ kèì cên, sâ béh duɔɔ́m naâ dé beèh seé maánjɔ̀gɔ̀; lou ŋgela sɔɔ́ béh teèn gùm cieê; yeé baá gi liyilì, te bɔ̀ hên bɔ̀ nde ye waâ; bɔ́ bɔɔ́ cegé seé yɔ̀ŋ loù cén, sâ gi aá. Kènê yeé baá dé gwɔɔ̀m, wò gwɔm ŋgeré béh bɔ́ lòù; hên né dilí wa? ");
INSERT INTO mcu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Nùà ŋueèh doô tueé njií mé cén déì lètenè bɔɔ̀n ndɔ, ye bú a: Mè wò lòù yíé ŋgwéh, mbeí mò. Ŋgweéh bélɔ̀ naá giì sòn coló ye gùm cieê né kám cén, wò gwaán ndɔ mà. ");
INSERT INTO mcu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hên né ka cí, sìè mè beè, fɔ́n lòm gò nɔɔ́ŋ; mè gwɔm nde né bí bɔ̀ɔ́ mé yila ceré naâ ká jomo dɔɔ́ŋ kèì cén; baga né mè cí. ");
INSERT INTO mcu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bɔ́ ye mè a: té mé kàgàlɔ̀ŋ mɔ̀ faá mè gwaán keéh nê nɔ bɔ́ wa? Wò né huer mé húɔ́m-temé mò hên bɔɔ́ wee?» ");
INSERT INTO mcu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeésò den cuù ye bɔ̀ nùàr a: «Nde né ka faá bèh mân nág: bɔ̀ ké jomo bɔ̀ nde né ké toò kelá seér, bɔ̀ ké toò bɔ̀ kela seér cu ké jomo.» ");
INSERT INTO mcu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sâ Yeésò né ké Jerusalem ndeé. Wa beré déì, à weh kwaá njií bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô bèh ndɔ́ŋ-ndɔ̀ŋ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Hên béh bí ŋaá nde baá ké Jerusalem sâ. Wa ké teèn, bɔ́ nde né *Huaán Nùàr sar, bɔ́ yií njií bú beè bɔ̀ *ŋgàŋ sèmè dé kokoô, mé bɔ̀ *njí-sóù. Bɔ̀ sâ bɔ̀ nde né bú ké bèh juù weh njií, te bɔ́ wula bú wulà. ");
INSERT INTO mcu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bɔ́ nde né bú beè bɔ̀ lòù bɔ̀ jɔgɔ́ yií. Bɔ̀ lòù bɔ̀ nde né bú selé, bɔ́ nde né bú lobo, bɔ́ nde né bú ter fagá njií ndɔ. Te cieé tagáre, à nde né lè cio komo yuo cuú.» ");
INSERT INTO mcu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jomo sâ meì bɔ̀ ŋunà Jebedê ŋgoró nde mé bɔ̀ ŋuna seèn kwarè Yeésò, à cemmé nde toò seèn bèh njeré déì bieê. ");
INSERT INTO mcu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeésò ye bú a: «Wò gwaán né kei wa?» Ye Yeésò a: «Kwá bɔ̀ huaán mò hên kwa gi bèh denè ké Mbàm yeè fà dɔɔ́ŋ: déì te be gaâ, déì te be ŋgoù yeè.» ");
INSERT INTO mcu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeésò ye bú a: «Njií mé bí né bieé hên, bí kɔ́ ŋgwéh, wanɔɔ́ŋ bí nde né ŋgàb jelâ faá mè nɔ jɔgɔ́ ŋueé komo wa?» Bɔ́ ye bú a: «Béh nde né ŋueé komo.» ");
INSERT INTO mcu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","À ye bɔ́ a: «Né bɔ̀n, bí nde né ŋgàb mò ŋueé; bí ŋueé gi nde né dág. Njèh cén, dé te be gaâ mé be ŋgoù mò deèn, beè mò sam. Bɔ̀ɔ́ mé Tele mò lé nyegé kwaá naâ bèh denè sâ mé bɔ́, kwa nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bɔ̀ mbɔ̀ŋ dé yulà doô yeé nde ŋgweé njií ménâ, temé yulá gi bɔ́ lè mé bɔ̀ fà bɔ̀ doô. ");
INSERT INTO mcu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yeésò yeé ŋene aá môn, à yilá njiî bɔ́ ká toò, ye bɔ́ a: «Bí né kɔɔ́ ye bɔ̀ mgbèémgbè mé tàbè hihiné né bɔ̀ nùàr lòù tuú; bɔ̀ kokoô bɔ̀ né bɔ́ ménâ tuú taré ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dé biì, bú a, té lètenè biì ménâ dèn. Nuaá mé gwaán né nùà koô lètenè biì ŋaâ dɔɔ́ŋ, bú a, ŋá sér nùà seê bɔ̀ mbeî kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nuaá mé gwaán né feh lètenè biì deèn, bú a, ŋá sér kwer bɔ̀ mbeî kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mè tueé bí, *Huaán Nùàr ndé ná ŋgwêh ye te bɔ́ bɔɔ́ kwaá nyí seé beè. À tétég nde seér naâ ye te nyí den nùà seê bɔ̀ nùàr, te nyí ŋa weh cio nùàr ŋgún mé húɔ́m nyî.» ");
INSERT INTO mcu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bɔ́ yeé baá Jerikò yuo, bɔ̀ nùàr ŋgún kem bele cu bɔ́ jomo. ");
INSERT INTO mcu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wa beré déì, sâ bɔ̀ tácugó déì fà né te sòn ceêr den den. Bɔ́ yeé baá ŋgweé ye, Yeésò kela né kɔɔ́ mân, bɔ́ sɔm hueh, ye: «Fehtoò beèh Ŋunà *Davîd, kɔ́ yeè béh jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ nde seér bɔ́ lòù, bɔ́ ye bɔ́ a: «Bí máb sòn biì doó sâ.» Mé njéh mene, bɔ́ kɔ lom né méménâ ké ter lɔgɔ́ njiî, ye: «Fehtoò beèh Ŋunà Davîd, kɔ́ yeè béh jere teèn!» ");
INSERT INTO mcu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeésò njebá le ndɔ, à yilá njiî bɔ́, ye bɔ́ a: «Bí ye mè a, gàm bí naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bɔ́ ye bú a: «Fehtoò beèh, bɔ́ yeè te béh ŋene njolo teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeésò yeé ŋgweé aá ménâ, jere bɔɔ́ bú njèh, à kema njií bɔ́ be njolò, njolo bɔɔ̀n kwɔgɔ yuo doó sâ. Bɔ́ yuo bele bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bɔ́ né ka ndeé, bɔ́ wa lè lɔɔ́ Betafajê kwarè Jerusalem. Lɔɔ́ sâ né ké te tòr Oliviê. Bɔ́ yeé nde aá lɔɔ́ yilá, Yeésò tema keéh bɔ̀ mbɔ̀ŋ fà déì toò, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Bí ndé lè lɔɔ́ toò biì sâ, bí nde né vuɔmndeè déì te yuiî ŋené, à né mé huaán jomo, bí sè ndé gî mé bɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mɔ nuaré déì bie bí njeré déì, bí júée bú a: Nùà Dueè né bɔ́ gwaán ma, bɔ́ nde né bí kwaá lɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá *sòn-Càŋ déì lɔ naâ tueé nɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Bí júée lɔɔ́ Siyɔ̂ŋ a: kè njí sâ ndeè né Nùà Dueè seèn ma. À né lom dɔlésé mân. À ŋaá né ŋgètenè mbò vuɔmndeè mé meí jomo mân ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bɔ̀ mbɔ̀ŋ fà doô fɔɔ́n gò ndɔ, bɔ́ nde bɔɔ́ faá Yeésò tueé naâ bɔ́ nɔ; ");
INSERT INTO mcu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","bɔ́ se ndeè mé vuɔmndeè doô bɔ̂ ŋuna, bɔ́ huaré weh bɔ̀ cɔ̀gɔ̀ suù bɔɔ̀n, bɔ́ te njií gi bɔ́ ŋgètenè. Yeésò ŋaá den teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nùàr kókoó mbaá né bɔ̀ cɔ̀gɔ̀ bɔɔ̀n ceceér huaré teé njií, bɔ̀ déì né bɔ̀ cù kwa, bɔ́ né ceceér teé bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Léh né lom gè toò mé ké jomo mene sue, ye: «Lieê né mé wò Ŋunà *Davîd! Kùsèm Càŋ a, kúlú nyégé nuaá mé ndeè né mé yilí seèn hên kulù. Vulú a, sén Càŋ seèn!» ");
INSERT INTO mcu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te Yeésò yeé nde yila nde baá-re Jerusalem mân, lɔɔ́ jilí; bɔ̀ nùàr né lom bieé ye: «Dé sâ né nùà dé heè mân wa?» ");
INSERT INTO mcu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Cìlì nùàr ye bɔ́ a: «Né Yeésò sòn-Càŋ, nùà Najarêt ké Galilê.» ");
INSERT INTO mcu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeésò yila nde yí cie gwà Càŋ koô ndɔ. À wa, sâ bɔ̀ nùàr né toón teèn bɔɔ́ den: bɔ̀ déì né go, bɔ̀ déì né ŋge, bɔ̀ déì né kàgàlɔ̀ŋ kwellé. À yeé nde ŋene njií ménâ, à kwɔgɔ sɔm keéh gi bɔ́ cie, à vela ŋellé sɔm gbàgà kàgàlɔ̀ŋ mé kɔgɔ bɔ̀ gò-vɔgɔb bɔ̀ mene, ");
INSERT INTO mcu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ye bɔ́ a: «Né gi lè mvù Càŋe nyagá den ye: Bɔ́ yilá nde né gwà mò, gwà Càŋ duaà. Keí mé bɔɔ́, bí weh kwaá seér aá gùr yîb biì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jomo sâ, bɔ̀ cùgò njolo bɔ̀ mé bɔ̀ gule kuû bɔ̀ ŋgoró nde bele kwarè seèn ké cie gwà Càŋ koô sâ, à taré sɔm gi bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù yeé ŋene, à baá ménâ bɔɔ́ huɔɔ́m, temé ŋaá seér bɔ́ lè lòù. Sâ bɔ́ ŋgweé naâ mé bɔ̀ huaán memanè naâ bú seén, ye bú a: «Lieê né mé wò, ŋunà *Davîd!» ");
INSERT INTO mcu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yeé baá ménâ, bɔ́ ye bú a: «Wò né njií mé bɔ́ né tueé hên ŋgweé wa?» Yeésò ye bɔ́ a: «Nyea. Bí née te mvù Càŋe jáŋé ŋéné ŋgwéeh ye ndɔ wa? Dé mé nyagá den né ter ye: Bɔ̀ huaán tetɔɔ̂r mé bɔ̀ dé mbembɔgɔ̀ mene nde gi né Càŋ mé sòn bɔɔ̀n seén doô!» ");
INSERT INTO mcu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","À yeé tueé gi aá ménâ, à kwaá lɔ bɔ́ ndɔ, à yuo lɔ sâ, à nde cu ké Betanî, à cer le toò. ");
INSERT INTO mcu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cieé ŋaga maánjɔ̀gɔ̀ à komo cu cuù ye ká jomo te lɔɔ́ koô, sâ cùè baá bú sie. ");
INSERT INTO mcu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","À ŋene njií toú déì kwarè ceêr mân, à njebá nde ké teèn, ye kɔ ŋgweéh tàb né teèn wa? Wa ké teèn, à ter kwa lom léláŋ yùè. À deên ndɔ, ye toú a: «Ndɔ́g wò tàb wá ndé cú.» Toú hèllè ŋema yuo njolò bɔɔ̀n doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bɔ̀ mbɔ̀ŋ yeé ŋene aá ménâ, geí lɔ bɔ́ mbaá, bɔ́ ye: «Toú hên kènê mbaá ŋema weh né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeésò ye bɔ́ a: «Mè né tueé ye bí a, mɔ bí temé kwaá njií né mé Càŋ, bí sàn ŋgwéh, sâ dé toú hên njeré déì sam gùm dɔɔ́ŋ; né mene tòr hên, mɔ bí ye bú a: ndé kòmò dìè ké dùà kíê, nde né te sòn biì bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mɔ bí né temé cén kwaá njií, njií mé bí né Càŋ teèn dua dɔɔ́ŋ, bí nde né kwa gií.» ");
INSERT INTO mcu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeésò yila nde cu yí cie *gwà Càŋ koô ndɔ, à duɔɔ́m njèh feèh. À yeé baá feh, bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ ŋgoró nde ye bú a: «Wò bɔ̀ njií hên bɔɔ́ né mé gèh terrèb dé heè? Neì wò jegé naâ kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeésò ye bɔ́ a: «Mè nde né bí njeré déì bieé ndɔ; mɔ bí né tueé kɔɔ́, mè se ye bí kwɔ̀m dé mò hên: ");
INSERT INTO mcu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Neì lé Jâŋ Bàptîs tema njií naâ kɔɔ́, ye bú a: ndé bɔ̀ nùàr kou bele wa? Lé naâ Càŋ wa, lé naâ nùàr wa?» Bɔ́ yila mé njéh lètenè bɔɔ̀n fellé kuû, ye: «Hên, mɔ béh ye bú a: Càŋ lé Jâŋ temà naâ kɔɔ́, à nde né tueé ye béh a: béh lé temé yoòr seèn kwá njí ná ŋgwêh dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Á, mɔ béh ye bú a: bɔ̀ nùàr lé bú temà naâ kɔɔ́, sâ dàm bɔ̀ nùàr nde né béh yoòr kem sue ndɔ; lòù sam, beè bɔɔ̀n Jâŋ lé naâ *sòn-Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yeé baá ménâ, bɔ́ ye bú a: «Béh kɔ́ ŋgwéh.» Yeésò ye bɔ́ a: «Sâ mè bí nuaá mé jegé naâ mè doô túé ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeésò si cu bɔ́ kàn déì, ye bɔ́ a: «Bí né ŋgweé wa? Nuaré déì lɔ naâ mé bɔ̀ huaán fà. Loù sâ à nde ye bei a: Huaán mò, ndé lan ké ŋueh bèh seê mò. ");
INSERT INTO mcu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ŋuna ye bú a: nyí ndé ŋgwéh. Jomo sâ, à munó nyegé cu mé be seèn, à fɔɔ́n gò ŋueèh doô. ");
INSERT INTO mcu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tele nde tueé cu mé dìm ménâ ndɔ, ye bú a: Ndé lan ké ŋueh bèh seê mò. Dìm gwaán nyegé, ye tele a: nyí nde né ndeé. Jomo sâ à nomo.» ");
INSERT INTO mcu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yeésò den cuù ye bɔ́ a: «Lètenè bɔ̀ huaán fà hên à, dé heè ŋgweé né sòn teleè kɔɔ́ wa?» Bɔ́ ye bú a: «Né bei.» Yeésò ye bɔ́ a: «Mè né tueé ye bí a: bɔ̀ɔ́ mé weh yeé kàgàlɔ̀ŋ làmpɔ̂ŋ, mé bɔ̀ sɔrmbe wa lɔgɔ́ nde né ké te *Lò Càŋe kɔɔ́ mé bí. ");
INSERT INTO mcu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wanɔɔ́ŋ Jâŋ yeé ndeè yoòr biì, ye te nyí feh bí ceér, bí temé teèn kwá njí ŋgwéh. Bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mé bɔ̀ sɔrmbe temé teèn kwaá njií seér kɔɔ́. Bí né mene bɔ́ ménâ ŋené, njeré déì bí yúlá ŋgwéh; kwá nɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Bí ŋgwé cú kàn déì: nuaré déì lé kieè naâ ŋueèh seèn; à yeé dobo gi aá yab, à kaga sie ŋueèh sâ beè, à nde ke beré déì, à sio kwaá vua dé tàb dorô teèn, à sie kwaá gbàgà teèn ndɔ. Jomo sâ, à haá kwaá ŋgɔgɔ̂ beè bɔ̀ seé bɔ̀, te bɔ́ ke nyegé den jomo, à nde dé seèn bèh gò. ");
INSERT INTO mcu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Cu mé yab yeé baá bɔlé, à tema njií bɔ̀ seé bɔ̀ seèn ké yoòr bɔ̀ kè-ŋueèh bɔ̀ doô, ye te nyí kwa yab teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wa ké teèn, bɔ̀ kè-ŋueèh bɔ̀ doô kem sue bɔ́ yoòr: bɔ́ duún déì núr, bɔ́ wula sɔm déì, bɔ́ yuo die dé tagâr yoòr mé taá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nùà ŋueèh doô yeé ŋene aá ménâ, à bɔ́ ké teèn tema njií lom ŋgún. Wa ké toò, bɔ̀ kè-ŋueèh bɔ̀ bɔɔ́ cu bɔ̀ sâ bɔ̀ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","«Yeé baá ménâ, nùà ŋueèh doô tema njií ŋuna seèn, ye dé hên né huaán nyî, bɔ́ nde né bú dé seèn veéh. ");
INSERT INTO mcu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mé njéh mene, wa ké toò, bɔ̀ kè-ŋueèh bɔ̀ doô yeé nde ŋene njií baá-re bú mân, bɔ́ nyɔgɔ sòn lètenè bɔɔ̀n, bɔ́ ye: Hên né nuaá mé nde né nùà ŋueèh ŋaá sâ. Mɔ sam, kɔ béh wula sɔm bú lòù, te ŋueèh hên ŋa dé beèh. ");
INSERT INTO mcu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bɔ́ cab sie bú ndɔ, bɔ́ tulu sɔm keéh bú ké luaà ŋueèh, bɔ́ wula si lɔ bú ké teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeésò den cuù, ye bɔ̀ nùàr a: «Sâ mɔ nùà ŋueèh wa ké teèn, à bɔɔ́ nde né bɔ̀ kè-ŋueèh bɔ̀ hèllè naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bɔ́ ye bú a: «À wula njií nde né bɔ̀ vevenê bɔ̀ doô mbaá, à jere kɔ́ ndé cú; à haá kwaá seér ŋueèh beè bɔ̀ déì; mɔ yab baá bɔlé te bɔ̀ sâ bɔ̀ kwa haá bú teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeésò ye bɔ́ a: «Bí née dé mé né lè mvù Càŋe nyagá den doô jáŋé ŋéné ŋgwéeh ye wa? Bèh sâ né tueé ye: Taá mé bɔ̀ mé-gwà bɔ̀ lé naâ ké jomo komo si njií hên, taá dàn ŋa seér cu né kɔɔ́. Sâ dɔɔ́ŋ né seé Nùà Dueè. Ŋgweéh huɔm kela né cí mà. Béh kéí lòm mé gècên mene.» ");
INSERT INTO mcu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeésò den cuù, ye bɔ́ a: «Mè tueé bí: mɔ né mân, sâ bɔ́ nde né bí *Lò Càŋ beè luaga sɔm, bɔ́ haá njií seér bɔ̀ɔ́ mé nde né tàb dé Lò Càŋe waá. ");
INSERT INTO mcu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kwá nɔɔ́ŋ, nuaá mé ceén die te taá sâ nde né teèn ŋerré le. Mɔ komo die seér né nuaré déì yoòr lòù, sâ nùà hèllè nde né faá fùfú nɔ nyoló den ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *Farisiên yeé baá bɔ̀ kàn sònò Yeésò ménâ ŋgweé, bɔ́ kɔ ye à si njií den né mé bɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bɔ́ duɔɔ̂m bú filî ndɔ. Njèh cén, bɔ́ veéh den née cìlì nùàr mé né temé yoòr Yeésò kwaá njií, ye à né *sòn-Càŋ doô. ");
INSERT INTO mcu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeésò né cu ka mé kàn tetoò si ndeé, ye bɔ̀ nùàr a: ");
INSERT INTO mcu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«*Lò Càŋ né faá mgbè déì lé naâ kùrmò fù ŋuna seèn neé nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yáb yeé bela baá, à ye bɔ̀ seé bɔ̀ a: Bí ndé júée bɔ̀ nùàr a: yáb bela baá ma. Wa ké toò, bɔ̀ nùàr berɔ́ŋ gi teèn ndeê. ");
INSERT INTO mcu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mgbè doô yeé ŋgweé aá môn, à tema sɔm cu bɔ̀ seé bɔ̀ déì, ye bɔ́ a: bí ndé júée bɔ́ a: Né mé núɔ́gɔ́ nàgà cèllè, bɔ́ ne bela gi aá ndɔ; bɔ́ ndé gî kùrmò fù yieé ma. ");
INSERT INTO mcu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mé njéh mene, bɔ́ bú mé njéh táŋ ŋgwéh, bɔ́ né lom bèh sénâ bɔɔ̀n sané ndeé. Dé kàn fɔɔ́n gò ŋueèh seèn, dé kân gò toôn seèn. ");
INSERT INTO mcu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bɔ̀ déì kem sue bɔ̀ seé bɔ̀ nùà koô doô yoòr, bɔ́ né bɔ́ selé, bɔ́ né bɔ́ wulá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Mgbè doô yeé ŋene aá mân, temé ŋaâ bú lè, ye bɔ̀ sɔ́jì seèn a: Bí ndé sá kùm sɔ̀m bɔ́ mé lɔɔ́ mene; né bɔ̀ wúlá-nùàr bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","À den cuù ye bɔ̀ seé bɔ̀ a: Yáb baá gi doó. Bɔ̀ɔ́ mé béh naá giì yilá dɔɔ́ŋ nùàr wúlú ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bí yùò bèlè ceér; bɔ̀ɔ́ mé bí né ŋené dɔɔ́ŋ, bí yílá kèm njî bɔ́ ká teèn. ");
INSERT INTO mcu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bɔ̀ seê bɔ̀ doô kem bele ceér ndɔ, bɔ́ né bɔ̀ nùàr ké teèn dɔɔ́ŋ yilá kabé njií. Tètèì sam nùàr baá gwò mbéráŋgáŋ. ");
INSERT INTO mcu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Mgbè doô yila nde gwò bɔ̀ nùàr yɔŋ ke ndɔ. À yeé baá yɔŋ, à ŋene njií nuaré déì yí doó lètenè bɔ̀ nùàr, à dé seèn mé cɔ̀gɔ̀ fù yoòr sam; ");
INSERT INTO mcu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ye bú a: Nùàr mò, wò mé cɔ̀gɔ̀ fù yoòr sam, wò ká gwò yila kelà naàn wa? Nùàrè sòn kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yeé baá ménâ, mgbè doô ye bɔ̀ seé bɔ̀ a: Sìè kàgà bú kagaà, bí kàgà bú gule mé be mene, bí jɔgɔ si njií bú kèb cieè te cibi, bèh kéŋ silî mé nyie yieé kuû.» ");
INSERT INTO mcu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeésò den cuù ye bɔ́ a: «Bí kɔ́ɔ ye, dé yilâ, bɔ́ nde né nùàr kókoó yilá. Njèh cén, bɔ́ balé weh lom nde né ŋgɔ́b.» ");
INSERT INTO mcu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jomo sâ bɔ̀ *Farisiên yuo nde sòn felè Yeésò nyɔgɔ ndɔ, ye bɔ́ nde né bú sòn felá. ");
INSERT INTO mcu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bɔ́ né bɔ̀ no bɔɔ̀n mé bɔ̀ no dé mgbè *Herôde ké yoòr seèn temá njií bele, ye bú a: «Nùà fèh-njèh, béh né gècên yeè kwaga; wò né bɔ̀ nùàr ceér Càŋ mé gècên mene feh dilí. Bɔ̀ nùàr tueé mene felè yeè naàn dɔɔ́ŋ, wò táŋ bèh, wò nùàr lòù bàlè bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mɔ né mân, sâ jɔ̀gɔ̀ túé ke béh ndɔ ye: *Sóú beèh ye gwɔ̀m làmpɔ̂ŋ mgbè Rɔ̂m gwɔɔ̀m wa, té gwɔ̀m wa?» ");
INSERT INTO mcu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yeésò yeé ŋene njií aá bɔ́ mé ndìèm veên lè ménâ, à ye bɔ́ a: «Bɔ̀ leba bɔ̀ faá bí nɔ! Bí mè mân tab tena né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bí jɔ̀gɔ̀ wèh kéh ke mè kàgàlɔ̀ŋ mé bɔ́ gwɔm yeé làmpɔ̂ŋ mé njéh, sâ ye.» Bɔ́ weh haá keéh bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","À bie njií cu mé bɔ́, ye bɔ́ a: «Feh nùàr mé yilí nùàr ká teèn hên nyagá den né dé neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bɔ́ ye bú a: «Né gi dé mgbè Rɔ̂m.» À deén baá-re, ye bɔ́ a: «Sâ bɔ̀ njií mé né dé mgbè dɔɔ́ŋ, bí gwɔ̀m njí cú mé mgbè; bí bɔ̀ dé Càŋ há njí cú mé Càŋ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bɔ́ yeé ŋgweé aá ménâ, hiím yɔgɔ́ bɔ́, bɔ́ yuo kwaá lɔ njií bú doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Loù cên sâ bɔ̀ *Sadusiên lé naâ kwarè Yeésò bilí ndeé, te bɔ́ bie bú njèh. Sâ bɔ́ né yeé tueé, ye mɔ nùàr kuú baá, sâ gi aá, à lè cio kòmò yùò ndé cú. ");
INSERT INTO mcu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bɔ́ yeé waà baá, bɔ́ ye bú a: «Nùà fèh-njèh, Músì lɔ naâ tueé ye: mɔ nuaré déì kuú kwaá lɔ véh mé huaán sam, dìm a, sàgà cú ma kû doô, à ŋar yilá cu bei ma. ");
INSERT INTO mcu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yeé baá ménâ, nuaré déì bɔ́ bɔ̀ dìm lé naâ lètenè beèh téhbeh ndɔ. Bei yeé jɔgɔ aá véh, à kuú yuo, huaán sam. Dìm sagá weh ma kû doô, ");
INSERT INTO mcu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","à kuú cu, huaán sam. Dìm bɔɔ̀n déì sagá weh keéh cu, bɔɔ́ cu bú môn ndɔ. Né ka mé bɔ́ méménâ bɔɔ́ ndeé. Nde nde bɔ́ kuú gi téhbeh dɔɔ́ŋ, huaán sam. ");
INSERT INTO mcu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jomo bɔɔ̀n ma kû doô kuú yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Á sâ, loù mé bɔ̀ komó ndeè né teèn komo yuo gií, ma hèllè ŋa sɔm nde né veèh dé heè? Ŋgweéh lètenè bɔɔ̀n téhbeh dɔɔ́ŋ bɔ́ lé naá giì bú sagá laré wa?» ");
INSERT INTO mcu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeésò deên ndɔ, ye bɔ́ a: «Dé sâ ndugó gɔ né bí. Lòù sam, bí ŋgòr Càŋ ŋéné kɔ́ ŋgwéh, bí terreb Càŋ kɔ́ ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bí kɔ́ɔ ye, loù mé bɔ̀ komó nde né te cio komo yuo, bɔ̀ siíb bɔ́ bɔ̀ véh ndeè jɔ́gɔ́ kú ndé cú, bɔ́ den nde aá faá bɔ̀ cìlì Càŋ ké te vulúu nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dé lè cio komo yuoò, bí dé mé Càŋ lɔ naâ bí tueé kwaá doô, jáŋé kè ŋgwéh wa? À lɔ ye: ");
INSERT INTO mcu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nyí né Càŋ mé bɔ̀ tele biì Abrahâm bɔ̂ Isâk mé Jakɔ̂b né yeé dua doô ma. Mè tueé bí: Càŋ né Càŋ bɔ̀ lèlàŋ bɔ̀, à Càŋ bɔ̀ komô sam.» ");
INSERT INTO mcu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cìlì nùàr yeé ŋgweé aá gèh dé mé à feh ŋagá né sâ, hiím lɔ bɔ́ mbaá. ");
INSERT INTO mcu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jomo sâ, bɔ̀ *Farisiên domó bilí ndɔ, sâ bɔ́ ŋgweé naâ ye sòn naâ bɔ̀ Sadusiên beè Yeésò ŋemá. Bɔ́ waà. ");
INSERT INTO mcu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Cén déì lètenè bɔɔ̀n mé né *njí-sóù, bie felá njií Yeésò sòn, ye bú a: ");
INSERT INTO mcu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Nùà fèh-njèh, sóú dé koô lètenè bɔ̀ sóù dɔɔ́ŋ né dé heè wa?» ");
INSERT INTO mcu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeésò ye bú a: «Gwàn gí Càŋ Nùà Dueè mé temé yeè mene, mé càŋ yeè mene, mé mùnò yeè mene dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sâ né dé koô mé jolo kela né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jomo seèn né cu dé hên, bɔ́ bú né felá; à dé seèn ye: Gwàn mbeí yeè faá wò gwaán né ŋgàŋ yoòr yeè nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dàm bɔ̀ sóù mé Músì bɔ́ bɔ̀ *sòn-Càŋ bɔ̀ lɔ naá giì feh dɔɔ́ŋ yila gi né teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sâ bɔ̀ *Farisiên née ka bècénè bilí den ye. Yeésò yeé ŋene aá ménâ, à bie njií ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Bí ye Nùà Cɔ̀ŋ né neì, à yuoô te gèh bɔ̀ neì wa?» Bɔ́ ye bú a: «À yuoô te gèh bɔ̀ Davîd.» ");
INSERT INTO mcu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeésò ye bɔ́ a: «Á, dé mé Cúcuí Ŋagâ lé naâ Davîd ceér feh, à yilá seér Nùà Cɔ̀ŋ sâ Nùà koô seèn doô nɔ? À lé ye: ");
INSERT INTO mcu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nùà Dueè ye Nùà koô nyî a: Dèn ndê ká te be gaâ nyî; kɔ nyí komó silí njií gi aá bɔ̀ bùnò bɔ̀ yeè doó, wò dobo kwaá bɔ́ gulè. ");
INSERT INTO mcu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hên mɔ Davîd mé feh seèn Nùà Cɔ̀ŋ sâ yilá né Nùà koô seèn, sâ Nùà Cɔ̀ŋ né cu ndùté ndùtù seèn wa?» ");
INSERT INTO mcu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yeé baá ménâ, nuaá mé nde né Yeésò sòn komo sɔm teèn yùò cú. Duɔɔ́m kaà loù sâ, nuaré déì njolo toò seèn kàgà nyì cú, ye nyí nde né bú njeré déì bieé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeé baá ménâ, Yeésò tueé njií mé bɔ̀ nùàr bɔ́ bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Seé bɔ̀ njí-sóù mé bɔ̀ Farisiên né sóú Músì se sɔɔ̂. ");
INSERT INTO mcu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mɔ né ménâ, sâ bí ŋgwé sòn bɔɔ̀n ŋgweè, bí bɔɔ́ ka nág faá bɔ́ né bí tueé nɔ. Njèh cén, bí té bɔ́ ŋá sér; bɔ́ dé bɔɔ̀n faá bɔ́ tueé nê nɔ bɔ́ bèh. ");
INSERT INTO mcu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bɔ́ né bɔ̀ seé tetarê kaga, bɔ́ né felè bɔ̀ nùàr mbiín kwaá njií, bɔ́ be teèn yí ŋgwéh, te gam bɔ̀ mbeí. ");
INSERT INTO mcu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Seé mé bɔ́ né gi bɔɔ́ dɔɔ́ŋ né gi seé njolò bɔ̀ nùàr. Bɔ́ ye te bɔ̀ nùàr keí bɔ́ keì. Bɔ̀ nùàr né yeé bɔ̀ lèmè déì te mvù Càŋe weh, bɔ́ né yoòr saá kwaá. Yeé baá dé bɔɔ̀n, bɔ́ sa hamé seér lòù, te yɔgɔ gi dé bɔ̀ mbeî. Né mene bɔ̀ yùràb cɔ̀gɔ̀ bɔɔ̀n né dé bɔ̀ mbeî dalé yɔgɔ́ gií, te bɔ̀ nùàr seén kela bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bɔ́ nde mene beré déì bèh kùrmò yieê, bɔ́ gwaán lom né bèh denè dé jejɔɔ̀. Né mene ké gwà sóù, bɔ́ gwaán kela né bèh denè dé njolò bɔ̀ nùàr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Né mene ké tan mé ké mbartɔgɔ̂, bɔ́ ye kɔ bɔ̀ nùàr gìbì bíé bɔ́ lòù; bɔ́ yílá yí cú bɔ́ bɔ̀ njí fèh-njèh teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mè tueé bí, bí té dé biì gwàn mé nuaré déì yilá nyi bí njí fèh-njèh. Lòù sam, bí né dé biì bɔ̀ dìm bɔ́ bɔ̀ bei, Nùà fèh-njèh biì né lom cén. ");
INSERT INTO mcu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bí té nuaré déì tele biì ká te wɔ́ŋe yílá, Tele biì né lom dé ké te vulúu, sâ gi aá. ");
INSERT INTO mcu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bí té gwàn mé nuaré déì yilá nyi bí Fehtoò ndɔ; bí kɔ́ɔ ye Nùà Cɔ̀ŋ né lom Fehtoò biì kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lètenè biì nùà seê biì nde seér né nùà koô biì kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mè tueé bí, nuaá mé né ter ŋgumó ŋaá dɔɔ́ŋ, bɔ́ nde né bú doó baá njií, te bɔ́ ter komo njií seér nùà dɔlê.» ");
INSERT INTO mcu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Bí nde né gèr ŋené, bí bɔ̀ njí-sóù mé bɔ̀ Farisiên; bí ŋene nde né gèr mé leba biì fî! Bí né bɔ̀ nùàr hin *Lò Càŋ ferá yiín. Bí mé feh biì teèn yílá ŋgwéh; bɔ̀ɔ́ mé gwaán né teèn yilâ, bí bɔ́ ceér kéh ŋgwéh ndɔ.  ");
INSERT INTO mcu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Bí nde né gèr mé leba biì ŋené kuú, bí bɔ̀ njí-sóù mé bɔ̀ Farisiên! Bí né njèh beè bɔ̀ ma kû horó weh bele; bí né Càŋ sònò mbaá dua tugó gɔ, te den faá bí né bɔ̀ gècên bɔ̀ nɔ. Mè tueé bí, ju sie kela nde né bí mé bɔ̀ déì. ");
INSERT INTO mcu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Mè jue né bí bɔ̀ njí-sóù mé bɔ̀ Farisiên, bí nde né gèr mé leba biì doô ŋené kuú; bí né *wɔ́ŋ dɔɔ́ŋ gɔlé gɔ, bí né dùà kelá, bí né cie kelá, né mene nùà cén, te bí kweéh seér kwa bú. Mɔ bí kweéh seér aá nùàrè kèn, bí doóm seér kela cu bú te mbeî fà, te à yila nde lom tuar mé gùm mene. Bí kwá biì. ");
INSERT INTO mcu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Mè tueé bí, bɔ̀ tácugó faá bí nɔ, bí ye bí né bɔ̀ mbeí ceér feh sé wa? Bí nde né mé gèr ŋené kuú. Bí ye, mɔ nùàr jege né *gwà Càŋ koô, jègè bú sìè ndé ŋgwéh; kɔ à jege seér né goó mé né ké gwò, jègè sie ye bú sé wa? ");
INSERT INTO mcu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bí né bɔ̀ tándugó, wanɔɔ́ŋ jolo kela né dé heè? Né goó wa, né gwà Càŋ mé nyeén né goó sâ kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","«Bí den cuù déì ye: mɔ nùàr jege mene kɔ, jègè bú sìè ndé ŋgwéh; kɔ à jege seér né mbe ké felè kɔɔ̀, sâ jègè sie ye bú sé wa? ");
INSERT INTO mcu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bí né bɔ̀ cùgò njolo bɔ̀, wanɔɔ́ŋ dé heè jolo kela né kɔɔ́? Jolo kela né mbe wa, né kɔ mé mbe sâ den né teèn te ŋguú-ŋgulì wa? ");
INSERT INTO mcu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mè tueé bí, nuaá mé jege kɔ, sâ à jege bilí né mé bɔ̀ njèh teèn mene dɔɔ́ŋ; ");
INSERT INTO mcu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","nuaá mé jege gwà Càŋ, jege bilí né gwà Càŋ mé Càŋ nùà gwà mene dɔɔ́ŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nuaá mé jege vulú, jege bilí né kɔgɔ Càŋ mé Càŋ nùà njèh felèbɔ̀ mene. ");
INSERT INTO mcu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Bí nde né gèr mé leba biì ŋené kuú, bí bɔ̀ njí-sóù mé bɔ̀ Farisiên! Bí kɔ lom né Càŋ mbe haâ; mɔ njèh baá yulà, bí né gi bú cécéné haá nyegé: bɔ̀ sìbì, bɔ̀ soó, bɔ̀ san, bí haá gi né ménâ dág. Njèh cén, bɔ̀ *sóú dé kokoô mé jolo kela né kɔɔ́, bí jòlò bèh; wanɔɔ́ŋ bí sé la né ju mé gècên mene tená kɔɔ́, bí sé la né bɔ̀ mbaábiì jere kɔɔ́, bí sé la né seé dɔɔ́ŋ teèn bɔɔ́ yií, te bí nde ye Càŋ mbe haá. ");
INSERT INTO mcu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mè tueé bí, bɔ̀ tácugó faá bí nɔ, bí né mbè sɔm seér, te támvùgòr teèn kélá cú, bí bɔɔ́ kuú né mbaá, bí ŋgelobà teèn mena keéh gi aá kèn. ");
INSERT INTO mcu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Bí ŋene nde né gèr mé leba biì fî, bí bɔ̀ njí-sóù mé bɔ̀ Farisiên! Bí né gi bɔ̀ ŋgàb mé bɔ̀ sɔɔ̀ yagá nyegé. Njèh cén, bí bɔ́ yaga seér né kèb cieè, kèb lè tena le môn, te bí teèn kurú kwaá seér yíb mé tuaá. ");
INSERT INTO mcu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tácugó bɔ̀ Farisiên ceré né bí! Wanɔɔ́ŋ bí sé la jɔ̀gɔ̀ yaga lɔgɔ́ naâ ŋgàb kèb lè, te kèb cieè ŋaga huɔm nyegé ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Bí nde né gèr mé leba biì ŋené kuú, bí bɔ̀ njí-sóù mé bɔ̀ Farisiên! Bí wula njerré den né faá sà nɔ: kèb cieè né ŋené nyagá huɔɔ́m, sâ kèb lè suɔm den né ndândaà kuú nùàr mé dàm bɔ̀ njèh fefɔɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bí ŋené huɔm nyegé né kèb cieè njolò bɔ̀ nùàr faá bèh ménâ ndɔ, sâ kèb lè biì yuú lom né léláŋ tánágá mé veên.» ");
INSERT INTO mcu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Bí nde né gèr mé leba biì fî ŋené, bí bɔ̀ njí-sóù mé bɔ̀ Farisiên! Bí né sà bɔ̀ *sòn-Càŋ bɔ̀ léí jɔ̀gɔ̀ meé, bí waá nyegé sà bɔ̀ didilî bɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bí né sònò tueé nyegé ye: mɔ bí sé lé yuoó naâ lè nàm bɔ̀ tele biì kɔɔ́, bí sé be te cio bɔ̀ sòn-Càŋ bɔ̀ yí ná ŋgwêh sé wa? ");
INSERT INTO mcu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ŋgweéh bí sâ tueé né kɔɔ́, ye bí né bɔ̀ ndùté ndùtù bɔ̀ɔ́ mé lé naâ bɔ̀ sòn-Càŋ bɔ̀ wulá giì sâ mà. ");
INSERT INTO mcu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Môn, bí wèh cú seé bɔɔ̀n weèh te ceré beè biì! ");
INSERT INTO mcu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Kɔ̀cɔ̀, bɔ̀ sàb, bí né bɔ̀ gèh ŋgòbò! Bí mbaá munó kuú né dé keì, ye ju bí sìè ndé ŋgwéh, bí tuar yílá ndé ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mè bí bɔ̀ sòn-Càŋ bɔ̀ déì tema njií cuù nde né dé cî, mè ndeè né bí bɔ̀ lo bɔ̀ mé bɔ̀ kɔ́-njèh bɔ̀ mene temá njií ndɔ. Bí nde né bɔ̀ déì lòù wulá, bí faga njií bɔ̀ déì te toû, bí nde né bɔ̀ déì núr te *gwà sóù biì tegé, bí nde né bɔ̀ déì te lɔɔ́ dé kàn mé dé kân bunó gɔ. ");
INSERT INTO mcu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sâ dɔɔ́ŋ bɔɔ́ né te húɔ́m bɔ̀ɔ́ mé lé naâ mé sòn fuû kuú dɔɔ́ŋ bie nyegé ye bí. Duɔɔ́m nde né mé húɔ́m Ábèl nùà dilî, nde wa mé húɔ́m dé Jakarî ŋunà Barákì. Bí lɔ bú wula lɔɔ̀ naâ lètenè caá gwà Càŋ, sâ mɔ̀ né yí toò, kɔ ká jomo mân. ");
INSERT INTO mcu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mè né tueé ye bí a: meì bɔ̀ gèr nde né mé bɔ̀ cafanê bɔ̀ doó kibí kelá. Kwá nɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Óè Jerusalem! Óè Jerusalem! Dàm bɔ̀ *sòn-Càŋ bɔ̀ wula gi né wò. Bɔ̀ɔ́ mé Càŋ lé naâ yoòr yeè temá njií dɔɔ́ŋ, wò bɔ́ mé taá tɔbé wula gi né kɔɔ́. Mè né mene gwaán, ye mè nde né bɔ̀ nùàr yeè ká ka mò koró bilí nyegé faá cuar kurú kwaá yeé bɔ̀ huaán ka bà nɔ, wò gwàn bèh. Baá mbei meèn wa, Jerusalem? ");
INSERT INTO mcu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mè tueé bí, gwà biì nde né ter le, ");
INSERT INTO mcu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","bí mè ŋéné ŋgwé ndé cú; kɔ cu mé bí ndeè baá mé sòn biì tueé ye: Càŋ Dueè a, kúlú nyégé nuaá mé ndeè né mé yilí seèn kulù, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeésò yuo kelà gwà Càŋ koô. À yeé nde aá ndeé, bɔ̀ mbɔ̀ŋ seèn ŋgoró nde kwarè seèn, te bɔ́ feh keéh bú bɔ̀ gwà hihiné mé bɔ́ me kwaá né te gwà Càŋ sâ. ");
INSERT INTO mcu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yeésò deên ndɔ, ye bɔ́ a: «Ŋgweéh bí né bɔ̀ gwà sâ dɔɔ́ŋ ŋené wa? Mè né tueé ye bí a: nde gi né dɔɔ́ŋ tɔbé yuo. Mè jue mene taá cén tà cén felè mbeî lè nyì ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeésò yeé baá ké te tòr Oliviê den den, bɔ̀ mbɔ̀ŋ léláŋ bɔɔ̀n ŋgoró ndeè kwarè seèn, bɔ́ ye bú a: «Bɔ̀ njií sâ bɔɔ́ nde né te cu dé heè wa? Túé yeè béh teèn. Béh ŋene kɔ nde né mé kei, ye wò baá ndeê, wɔ́ŋ nde aá ceré ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeésò ye bɔ́ a: «Bí kɔ́gɔ́n ká lòù; nùàr a té bí bèlè. ");
INSERT INTO mcu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mɔ sam, bɔ̀ nùàr kókoó mbaá nde né yilí mò ŋaá weh, te bɔ́ bele weh gi bɔ̀ nùàr mé njéh. Nùà kàn tueé nde né ye: nyí né *Nùà Cɔ̀ŋ kɔɔ́ ma. ");
INSERT INTO mcu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bí nde né bèmè taâb kwarè biì ŋgweé, bí ŋgweé njií njàgà bɔ̀ taâb déì te lò hihiné ndɔ. Mɔ bí baá ménâ ŋgweé, bí té lòù ndèrrè. Kɔ seèn bɔɔ́ ménâ. Mé njéh mene, wɔ́ŋ mé njéh cèrè ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Taáb nde né lètenè lɔɔ́ déì bɔ̂ mbeí kɔɔ́ die, lò déì nde né mbeí mé taáb ŋaár kwa; cùè nde né die; tàbè nde né te bèh hihinê jilí. ");
INSERT INTO mcu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sâ dɔɔ́ŋ née seèn jèrè ye, kar weh né faá nyer nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Te bɔ̀ nùàr ŋar yila ye bí yoòr: bɔ́ nde né bí lè gèr-e fulú, te bí kuú le teèn. Lò nùàr dɔɔ́ŋ nde né bí bunó, sâ dɔɔ́ŋ né gi felè mò. ");
INSERT INTO mcu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","«Sâ né cu mé bɔ̀ nùàr ŋgún sɔm gi nde né temé yoòr mò teèn ndɔ; bɔ́ nde né lètenè bɔɔ̀n suií kuú, bɔ́ né bunó kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bɔ̀ *sòn-Càŋ bɔ̀ dé nyenyenê nde né cie gɔlé ŋab yɔŋ bele, bɔ́ né bɔ̀ nùàr bele gɔ. ");
INSERT INTO mcu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dàm bɔ̀ veên nde né cie kulu su, temé nde né nùàr kókoó mbaá lè kuú gií, te bɔ́ bɔ̀ mbeí gwàn kòmò cú. ");
INSERT INTO mcu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mè tueé bí, nuaá mé nde né dɔɔ́ŋ yoló komo gií, nde né dé seèn yili yuo. ");
INSERT INTO mcu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Njàgà Bagaà felè *Lò Càŋ nde né wɔ́ŋ dɔɔ́ŋ ŋgulí yɔŋ, te nùà kàn ŋgweé mé tie seèn. Jomo sâ wɔ́ŋ ceré ye ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Bí nde né gègè veên ké te mɔ̀ Càŋe ŋené; njebá den nde né faá Daniel sòn-Càŋ lé naâ tueé nɔ. (Nuaá mé né ŋgòr hên jaŋé, bú a, ŋgwé nyégé bagasé). ");
INSERT INTO mcu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mɔ baá môn, sâ bɔ̀ Judê bɔ̀ a, dùrà ŋá gí ké te tòre. ");
INSERT INTO mcu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nuaá mé né ké felè gwà, bú a, fɔ́n lòm doò, à té ké gwò seèn felè bɔ̀ njèh seèn mbaá yílá kú cú. ");
INSERT INTO mcu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nuaá mé né ké ŋueh, bú a, té ká lɔ cû, ye te nyí weh sie cɔ̀gɔ̀ dùlù nyî beè. ");
INSERT INTO mcu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Loù sâ bɔ̀ véh mé lèì hueêh mé bɔ̀ ma vùlù nde né mé gèr ŋené kuú. ");
INSERT INTO mcu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","«Bí dùà lòm Càŋ, te cu sâ bí lè cu dùlù dùrà gɔ̀ cú; bú a, té mé *sóú yílá ndɔ; ");
INSERT INTO mcu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","wanɔɔ́ŋ gèr né teèn! Gèr dé loù sâ dé tueê sam. Bèh lɔ mé wɔ́ŋ lɔ naâ duɔɔ́m dɔɔ́ŋ, gèr déì lɔ née teèn faá gèr bú hên nɔ sam ŋgwéeh ye; déì ndeè ménâ wá ŋgwé ndé cû ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mɔ Càŋ jere kɔ́ ŋgwéh, à bɔ̀ cieé gèr sâ kèb déì sɔ̀m wàgà ŋgwéh, sâ nuaré déì seèn làŋ lè ndé ŋgwéh. Njua mé Càŋ lé naá giì ménâ taáŋ kwaá ndɔ, ye nyí nde né bɔ̀ cieé sâ kèb déì sɔm waga; nyí sɔm waga nde né felè bɔ̀ɔ́ mé nyí lé naâ balé weh doô. ");
INSERT INTO mcu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Sâ bí dèn dèn làŋ, wanɔɔ́ŋ nuaré déì sé den né mbaá ye bí a: Kè *Nùà Cɔ̀ŋ hên! Kè à yíê! Mɔ à baá ménâ tueé, bí té temé teèn kwá njí. ");
INSERT INTO mcu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bɔ̀ *Kristò dé kòkòb mé bɔ̀ *sòn-Càŋ bɔ̀ dé nyenyenê nde né cie bomó sue, bɔ́ nde né bɔ̀ fém tetarê bɔɔ́ bele, ye mɔ yieé né yieè, te bɔ́ bele weh bilí mé bɔ̀ɔ́ mé Càŋ lé balé kwaá naâ mene. ");
INSERT INTO mcu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mè bí tueé kwaá gi aá kèn, bí ŋgwé nyégé bagasé! ");
INSERT INTO mcu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Sa kènê, mɔ bɔ́ ye bí a: Ké ya dueè kíê né bú! bí té ké teèn ndé. Mɔ nuaré déì ye bí a: Hên leér den né bú sâ! bí té gwàn. ");
INSERT INTO mcu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gèh dé mé mbàn be njerré yeé ter, né gè Bà yuo, né nyiìb tehr ndeé doô, *Huaán Nùàr wa ndeè né ka môn nág. ");
INSERT INTO mcu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Komó né mene he, bɔ̀ jìè nde gi né teèn bilí ndeé.» ");
INSERT INTO mcu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Loù sâ, jomo gèr tètèì sam, lou nde né yilí, weéh nde né cib, bɔ̀ mbentò ndeè né ké te vulúu suelé suagâ, bɔ̀ njií mé né mé terreb ké te vulúu dɔɔ́ŋ nde gi né jilí. ");
INSERT INTO mcu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sâ baá cu mé njàgà Huaán Nùàr ŋagá yuo kela ndeè né ké te vulúu teèn ndɔ. Bɔ̀ nùàr mé gèh hihiné ká doó dɔɔ́ŋ nde gi né loù sâ yueé ŋgaré kuú, bɔ́ nde né Huaán Nùàr ŋené njií, à né te mvulu bège mé terreb mene *sum suagâ. ");
INSERT INTO mcu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Meì bɔ̀ tàŋ nde né tuagá, à nde né bɔ̀ cìlì seèn kàn mé kán wɔ́ŋ dɔɔ́ŋ temá njií, te bɔ́ nde koró bilí bɔ̀ɔ́ mé à lé naá giì balé kwaá.» ");
INSERT INTO mcu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Bí kè wèh yoòr toú túé-kùr. Mɔ bí ŋene à baá tɔɔ́, ŋgweéh sâ bí kɔ gi aá, ye jà baá dìdì mà. ");
INSERT INTO mcu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Loù mé Huaán Nùàr nde né teèn cuû né ménâ ndɔ. Mɔ bí ŋene bɔ̀ njèh kèkènè hèllè baá bɔɔ́ bele, sâ bí kɔ́ɔ ye: baá bú, à baá dìdì. ");
INSERT INTO mcu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mè né tueé ye bí a, mé bɔ̀ cafanê bɔ̀ nde dɔɔ́ŋ kuú gií, sâ bɔ̀ njèh hèllè bɔɔ́ gi aá. ");
INSERT INTO mcu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Vulú bɔ̂ tàbè nde né leér yuo; ndɔ́g bɔ̀ ŋgòr mò dé bɔɔ̀n nyímé ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Nuaá mé né cieé bú sâ kɔɔ́ teèn sam, nuaré déì cu sâ kɔ́ ŋgwéh ndɔ; bɔ̀ cìlì Càŋ cieé sâ kɔ́ ŋgwéh; né mene Huaán nùà njèh, à cieé bú sâ kɔ́ ŋgwéh ndɔ; gi cegé né Tele mé huún. ");
INSERT INTO mcu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Loù mé Huaán Nùàr cuù nde né teèn, njií mé lé kelà naâ te nàm Noê, nde cu né ménâ bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sâ te nàm Noê bɔ̀ nùàr lé kɔ loóm naâ yieê mé ŋueê, bɔ́ né véh suaá, bɔ́ né bèh siîb ndeé ndɔ. Bɔ́ né ka mé njéh méménâ bɔɔ́ ndeé den, tɔ́g nde wa loù mé Noê lé yilà naâ kɔm teèn. ");
INSERT INTO mcu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bɔ́ yeé táŋ cú, nu koô die, nòmò laga kum lɔ bɔ́ teèn ndɔ. Loù mé Huaán Nùàr cuù nde né teèn, nde cu né ka ménâ nág. ");
INSERT INTO mcu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nuaré déì bɔ̂ mbeí nde né ké ŋueh fà, bɔ́ nde né cén weh, cén le. ");
INSERT INTO mcu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma déì bɔ̂ mbeí nde né ké jomo nyèn, bɔ́ nde né cén weh, cén le. ");
INSERT INTO mcu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bí dèn lòm làŋ, wanɔɔ́ŋ bí cieé mé Fehtoò biì cuù nde né teèn kɔ́ ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","«Bí félá nyégé bagasé: mɔ nùà gwà sé né kɔɔ́ ye loù sâ cíbítenè yíb nde né nyí yilá, à sé naâ làŋ den, à mɔm ŋaga gwà seèn te yíb gwò yílá cú. ");
INSERT INTO mcu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sâ bí dèn dèn làŋ ménâ, wanɔɔ́ŋ Huaán Nùàr kar waà nde né, loù mé bí cí mùnò ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Kwá mè tueé bí felè nùà kɔ́gɔ̀n mé né seé tele seê seèn mé temé cén bɔɔ́. Né nuaá mé tele lé bɔ̀ seé bɔ̀ dɔɔ́ŋ haá kwaá naâ beè seèn, te à geé haá bɔ́ yáb, à geé faá né tueé nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mɔ tele seê seèn waà, à né seé seèn te ceér-e bɔɔ́ yií, à nde né beè teleè samé. ");
INSERT INTO mcu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mè né tueé ye bí a, tele beè seèn haá lɔ bilí nde né mé bɔ̀ njèh seèn mene dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","«Mɔ nùà seê cén sâ né seér nùà veên, à tueé seér nde né mé feh seèn ye: Tele seê nyî wágá cú ndé ŋgwêh; ");
INSERT INTO mcu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","à yila bɔ̀ mbaábɔn loboò, à né yáb yieé ndabé, bɔ́ bɔ̀ sèlà-mbè bɔ̀ né ŋueé ndabé gɔ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mɔ à sé baá ménâ bɔɔ́, ŋgweéh tele seê seèn nde né lòù kaár waâ, à weh bú seé wa? ");
INSERT INTO mcu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","À nde né bú kwɔgɔ́ sɔm, te bɔ́ bɔ̀ leba bɔ̀ den mé gèh nûr cên bèh kéŋ silî mé nyie yieé kuû.» ");
INSERT INTO mcu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Loù sâ *Lò Càŋ den nde né faá bɔ̀ mbò yàgà yulà mé lé naâ bɔ̀ lâm bɔɔ̀n weh, bɔ́ nde bèh siì fù ceér dueè kwa weèh nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lètenè bɔɔ̀n sâ, bɔ̀ kùlù bɔ̀ lé naâ teèn tîn, bɔ̀ kɔ́gɔ̀n bɔ̀ teèn tîn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bɔ̀ kùlù bɔ̀ doô weh lom lâm mé nòmò lè, bɔ́ nòmò kèb déì beè wèh sìè ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bɔ̀ kɔ́gɔ̀n bɔ̀ weh dé bɔɔ̀n lâm, bɔ́ weh sie nòmò lâm kèb déì beè. ");
INSERT INTO mcu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Siì fù yeé ŋgaga sela baá, bɔ́ duɔɔ́m lɔ́m yiì, jomo sâ bɔ́ lɔ́m kpɔ́g ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Yeé baá lɔgɔ̀tenè, bɔ́ ŋgweé gɔ̀gɔ̀ die aá ye: Siì fù waà baá kèn, bí ndé kwà wèllè bú ma! ");
INSERT INTO mcu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bɔ́ yulà dɔɔ́ŋ, bɔ́ nyimé kem wuo ter ndɔ, bɔ́ far njií lâm ter. ");
INSERT INTO mcu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bɔ̀ kùlù bɔ̀ doô ye bɔ̀ kɔ́gɔ̀n bɔ̀ a: Bí kɔ́ há béh nòmò lâm kèb déì teèn, lâm beèh nde aá nyimé. ");
INSERT INTO mcu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bɔ̀ kɔ́gɔ̀n bɔ̀ ye bɔ́ a: Háyè, mé dé biì mene wúlú ndé ŋgwéh, bí ndé ŋgè sér yí lètenè lɔɔ̂. ");
INSERT INTO mcu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bɔ̀ kùlù bɔ̀ doô fɔɔ́n gò ndɔ. Bɔ́ yeé nde aá, siì fù waà jomo bɔɔ̀n, bɔ́ bɔ̀ kɔ́gɔ̀n bɔ̀ tîn doô yila nde gwò, bɔ́ colo njií hin, bɔ́ ferá sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Te nde nde, bɔ̀ kùlù bɔ̀ tîn doô cu cuù ye. Bɔ́ yeé waà, sâ hin baá coló, bɔ́ yilá keéh ye bú a: Fehtoò beèh, Fehtoò beèh, gùlù kéh béh teèn! ");
INSERT INTO mcu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Siì fù deên ndɔ, ye bɔ́ a: Mè tueé bí, mè bí kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeésò den cuù ye bɔ̀ nùàr a: «Sâ bí dèn lòm làŋ, wanɔɔ́ŋ bí cieé mé cu kɔ́ ndé ŋgwéh ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","À den cuù ye bɔ́ a: «Den cu nde né loù sâ faá nuaá mé nde né bèh gò ndeé nɔ. À yeé baá mé gò, à yilá bilí bɔ̀ seé bɔ̀ seèn, te à haá kwaá bɔ́ bɔ̀ njèh seèn dɔɔ́ŋ beè. ");
INSERT INTO mcu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","À haá kwaá beè déì kám yuií tîn; beè déì, kám yuií fà; beè déì, kám yuií. Nùà kàn kwa keéh né ka bèh mé terreb seèn kelà né teèn. Jomo sâ à yuo gò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nùà seê dé mé kwaá naâ kám yuií tîn doô yila seé toôn mé njéh bɔɔ̂, à kwa cu nòmò teèn kám yuií tîn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dé mé kwaá naâ kám yuií fà doô bɔɔ́ cu ka ménâ, à kwa cu kám yuií fà ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dé mé kwaá naâ kám yuií cén doô nde kwe seér dé seèn tàbè, à leér kwaá kàgàlɔ̀ŋ teleè doô teèn. ");
INSERT INTO mcu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nde nde, loù sâ, tele cu cuù, bɔ́ bɔ́ yila bɔ̀ njèh seèn taáŋ nyegê. ");
INSERT INTO mcu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nùà seê dé mé lé kwaá naâ kám yuií tîn doô ŋgoró ndeè mé kám yuií tîn déì beè, ye bú a: Dé koô, wò lé haá naâ mè kám yuií tîn, mè kwa sagá cu aá kám yuií tîn déì teèn, hên nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tele ye bú a: Môn, wò né nùà gècên! Wò né teèn bɔɔ́ yií. Mɔ wò né njèh mbaâ mé temé cén mân bɔɔ́ huɔɔ́m, sâ mè nde né wò njèh kókoó mbaá beè haá kwaá gií. Ndê, há-re mè be, te bélɔ̀ samé fà dɔɔ́ŋ! ");
INSERT INTO mcu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Nùà seê dé mé lé kwaá naâ kám yuií fà doô ŋgoró ndeè ndɔ, ye bú a: Dé koô, wò lé haá naâ mè kám yuií fà, mè kwa sagá cu aá kám yuií fà déì teèn, hên nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tele doô ye bú a: Môn, wò né nùà gècên! Wò né teèn bɔɔ́ yií. Mɔ wò né njèh mbaâ mé temé cén mân bɔɔ́ huɔɔ́m, sâ mè nde né wò njèh kókoó mbaá beè haá kwaá gií. Ndê, há-re mè be, te bélɔ̀ samé fà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Jomo sâ nùà seê dé mé lé kwaá naâ kám yuií doô ŋgoró ndeè ndɔ, ye bú a: Dé koô, mè kɔ gi aá ye wò né yeé nùà yɔgɔ̂: wò mene kɔɔ́ dòbò bèh, wò né yeé mbaá keba njií. Wò mene kɔɔ́ hóbó ŋgwéh, wò kɔ lom yeé te mbáŋe mbaá kuúm kwaá njiî ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kàgàlɔ̀ŋ yeè hên, née ka faá wò lé haá naâ mè nɔ; mè lé leér kwaá naâ dòù, veéh lé naâ mè mé wò sie yɔgɔ́; wèh cú-re njèh yeè. ");
INSERT INTO mcu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tele doô ye bú a: Nùà seê veên léláŋ fùɔ̀b faá wò sam! Wò sé kɔɔ̀ naâ ye mè mene kɔɔ́ dòbò bèh, mè né yeé mbaá keba njií. Mè mene kɔɔ́ hóbó ŋgwéh, mè kɔ lom yeé te mbáŋe mbaá kuúm kwaá njiî ndɔ. Wò sé kɔɔ̀ naâ ménâ, ");
INSERT INTO mcu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","wò sé kwaá njií naâ mè kàgàlɔ̀ŋ mò te mbiîn, mè sé cuù, sâ né ŋar, te mè kwa mé nòmò mene. ");
INSERT INTO mcu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Yeé baá ménâ, tele ye bɔ̀ seé bɔ̀ a: bí ŋgà sɔ̀m bú kám yuií doô beè ŋgaà, bí há ságá njí mé nùà kám yuií tîn doô. ");
INSERT INTO mcu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lòù sam, nuaré déì nde gi né mé njèh beè, bɔ́ haá sagá cu bú déì teèn, te merré den bú beè lòù. Nuaré déì dé seèn mé njèh beè sam nde ŋgweéh, né mene dé maàn mé à né mé njéh dɔɔ́ŋ, bɔ́ nde né bú beè horó sɔm. ");
INSERT INTO mcu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dé nùà seê veên hên, bí sì njí bú ké cie te ndèndèŋ cibî, bèh kéŋ silî mé nyie yieé kuû.» ");
INSERT INTO mcu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Mɔ *Huaán Nùàr ndeè baá *sum cuû, nde né bɔ́ bɔ̀ cìlì Càŋ dɔɔ́ŋ, à nde né te kɔgɔ tàsùm mân ŋaá den. ");
INSERT INTO mcu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Cu sâ dàm bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ nde giì né toò seèn bilí ndeê, te à geí bɔ́ faá bɔ́ geí sɔm yeé sòrŋgaŋ lètenè bɔ̀ mbieè sòr nɔ; ");
INSERT INTO mcu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","à kwaá njií bɔ̀ sòrŋgaŋ kèb be gaâ, bɔ̀ sòr kèb be ŋgoù. ");
INSERT INTO mcu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Jomo sâ Nùà *Sùsùm tueé njií nde né mé bɔ̀ dé kèb be gaâ doô, ye bɔ́ a: Bí ndê dé biì, Tele mò kulu gi aá bí kèn; bí yílá ndê ká Mbàm; à lé nyegé kwaá naâ dé biì, sâ wɔ́ŋ duɔɔ́m née lòù ye. ");
INSERT INTO mcu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Lòù sam, cùè lé naâ mè sie, bí haá mè yáb; nyúá nòmò lé naâ mè sie, bí haá mè nòmò; mè lé naâ nùà kìn, bí ke nyegé mè ké lɔ biì; ");
INSERT INTO mcu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mè lé naâ luŋturu, bí su kwaá mè cɔ̀gɔ̀ yoòr; mè lé naâ baán, bí sie nyegé mè ndɔ; mè lé naâ ké gwà cibì, bí né mè yɔŋ ke. ");
INSERT INTO mcu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Bɔ̀ gècên bɔ̀ doô tueé nde né ye bú a: Nùà Dueè, béh lé wò ŋenè naâ he, wò né mé cùè, béh haá wò yáb wa? Mé nyúá nòmò, béh haá wò nòmò wa? ");
INSERT INTO mcu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Béh lé wò nùà kìn ŋenè naâ he, mé béh ke nyegé wò ké lɔ beèh wa? Wa béh lé wò luŋturu ŋenè naâ he, béh su wò cɔ̀gɔ̀? ");
INSERT INTO mcu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wò lé baàn naâ he, béh sie nyegé wò? Béh lé yɔŋ keé naâ wò te gwà cibì dé heè ndɔ? ");
INSERT INTO mcu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Nùà Sùsùm tueé nde né ye bɔ́ a: Mè tueé bí: bɔ̀ njií mé bí lé bɔɔ́ giì naâ mé bɔ̀ nùàr mò, né mene huaán maàn dé heè dɔɔ́ŋ, sâ bí lé bɔɔ́ giì naâ mé mè. ");
INSERT INTO mcu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Jomo sâ Nùà Sùsùm tueé njií nde né mé bɔ̀ kèb be ŋgoù bɔ̀, ye bɔ́ a: Bí yùò dé biì doó sâ nɔɔ́ŋ, bí baá duagásé! Bí ndé ké tuar te we mé nyímé ndé cû. Bɔ́ lé naá giì we sâ mé *Sátàn bɔ́ bɔ̀ cìlì seèn nyegé kwaá. ");
INSERT INTO mcu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","À den cuù ye bɔ́ a: Cùè lé naâ mè sie, bí mè yáb há ŋgwéh. Nyúá nòmò lé naâ mè sie, bí mè nòmò há ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mè lé naâ nùà kìn, bí mè ké lɔ biì kè nyégé ŋgwéh. Mè lé naâ luŋturu, bí mè cɔ̀gɔ̀ sù ŋgwéh. Mè lé naâ baán, mè lé naâ gwà cibì ndɔ, bí mè kè nyégé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Cu sâ bɔ́ tueé nde né ye bú a: Nùà Dueè, béh lé wò mé cùè ŋenè naâ he? Mé nyúá nòmò ndɔ? Béh lé wò nùà kìn ké lɔ beèh ŋenè naâ he? Béh lé wò luŋturu ŋenè naâ he wa? Á, béh lé wò te beén-e mé gwà cibì ŋenè naâ he, mé béh wò gàm ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Mgbè tueé lom nde né bɔ́ sòn cén, ye bɔ́ a: Mè tueé bí, bɔ̀ njií mé bí lé nomò naâ mé nùà cén lètenè bɔ̀ huaán memanè hên dɔɔ́ŋ, bí lé bɔɔ́ njií naâ mé mè.» ");
INSERT INTO mcu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yeésò den cuù ye: «Bɔ̀ sâ bɔ̀ nde né te gèr dé ndeèr yilá, te bɔ̀ gècên bɔ̀ yila nde dé bɔɔ̀n te yɔ̀ŋ tètàgà ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeésò yeé tueé gi aá mân, à tueé njií mé bɔ̀ mbɔ̀ŋ seèn ndɔ, ye bɔ a: ");
INSERT INTO mcu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Bí né kɔɔ́ ye, le aá cieé fà, sâ baá cieé koô *Páskà mé *Huaán Nùàr yila nde né beè teèn, bɔ́ faga njií bú ter te toû.» ");
INSERT INTO mcu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jomo sâ bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ kokoô bɔ̀ lɔɔ̂ bilí nde gi ké lɔ Kayîf nùà koô bɔ̀ ŋgàŋ sèmè. ");
INSERT INTO mcu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bɔ́ nyɔgɔ sòn ye bɔ́ nde né Yeésò filí sie, te bɔ́ wula bú. ");
INSERT INTO mcu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bɔ́ ye: «Sâ kɔ béh bú te cieé koô hên sìè ŋgwéh, wanɔɔ́ŋ bɔ̀ nùàr nde né ŋaáŋ.» ");
INSERT INTO mcu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sâ Yeésò baá ké Betanî gwò Simɔ̂ŋ. Simɔ̂ŋ lé naâ nùà beén veên. ");
INSERT INTO mcu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yeésò yeé baá ké gwò, ma déì ŋgoró nde kwarè seèn mé mbémbɔ́ŋ beè, kómó múmû mé keh tarê mân né lè deí. À komo yurú njií gi Yeésò felè, sâ Yeésò né te yábe. ");
INSERT INTO mcu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bɔ̀ mbɔ̀ŋ yeé nde ŋene njií ménâ, temé yulá bɔ́ lè, bɔ́ ye: «À kómó sâ ménâ bɔɔ́ beéh né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mɔ bɔ́ sé go sɔm nyegé naâ kómó mé keh tarê hên lòù nɔ, bɔ́ sé bɔ̀ saám bɔ̀ kàgàlɔ̀ŋ sâ há njí ná ŋgwêh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeésò yeé ŋene bɔ́ baá mân tueé kuú, à ye bɔ́ a: «Bí ma hên temé lè bɔɔ́ yulá né dé keì wa? Njií mé à né mè bɔɔ́ hên né lom njèh bagaà beè mò dé gècên. ");
INSERT INTO mcu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dé bɔ̀ saám bɔ̀, bí bɔ́ nde née cu dɔɔ́ŋ kɔɔ́ ye; á dé mò nɔ, béh bí nde cu née he wa? ");
INSERT INTO mcu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma hên mè kómó yoòr yurú njií né te nyegé bilí mé gò mò ké te sà mene. ");
INSERT INTO mcu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mè né tueé ye bí a, bèh mé Njàgà Bagaà nde né teèn ká lè wɔ́ŋe dɔɔ́ŋ ŋgulí ndeé, nde né mé njàgà ma hên mene ŋgulí bilí, te bɔ́ munó den bú teèn.» ");
INSERT INTO mcu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yeé baá ménâ, mbɔ̀ŋ cén déì yuo lètenè bɔ̀ yulà cùɔ̀b fà bɔ̀ doô, yilí seèn né Júdàs Iskariô, à nde kwa bɔ̀ *ŋgàŋ sèmè dé kokoô, ");
INSERT INTO mcu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ye bɔ́ a: «Bí haá nde né mè kei, te mè go haá bí Yeésò wa?» Bɔ́ kula weh kám yulà tagár ndɔ, bɔ́ haá njií bú. ");
INSERT INTO mcu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jomo sâ à yila lom baá-re ceér fɔɔ̂n, te à jɔgɔ yií Yeésò beè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yeé baá loù cieé koô mé bɔ́ yieé yeé breêd mé kulu teèn sam sâ, bɔ̀ mbɔ̀ŋ nde ye Yeésò a: «Wò ye béh nyégé kwá nyí bèh Páskà yieê he wa?» ");
INSERT INTO mcu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeésò ye bɔ́ a: «Bí ndé ké lɔ, bí kela nde ké lɔ nùà mân, bí ye bú a: Nùà fèh-njèh ye júée wò a: cu nyî wulu baá kèn, bɔ́ bɔ̀ mbɔ̀ŋ nyî yieé nde né Páskà ké lɔ yeè ma.» ");
INSERT INTO mcu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bɔ̀ mbɔ̀ŋ nde bɔɔ́ gi ka dɔɔ́ŋ faá Yeésò naâ bɔ́ tueé nɔ, bɔ́ nyegé kwaá gi yáb Páskà. ");
INSERT INTO mcu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yeé baá liyilì Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn yulà cùɔ̀b fà doô nde kaŋ yáb ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bɔ́ yeé baá yáb yieé, Yeésò ye bɔ́ a: «Mè né tueé ye bí a, nùà cén déì lètenè biì nde né mè go sɔm.» ");
INSERT INTO mcu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bɔ́ yeé ŋgweé aá môn, kuún curú gi bɔ́ toò dɔɔ́ŋ, nùà kàn duɔɔ́m mé Yeésò bieé njiî, ye bú a: «Ŋgweéh mè sam wa, Fehtoò mò?» Mɔ déì bie sɔm aá, déì bie keéh cu ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeésò ye bɔ́ a: «Né ka lè ŋgàb cên mé béh bí né teèn yieé bilí hên, nùà cén déì teèn mè go sɔm nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dé kuû, *Huaán Nùàr nde né kuú, nde né faá bɔ́ lé naá giì felè seèn nyagá kwaá nɔ. Njèh cén, nuaá mé yií keéh be teèn, jɔgɔ kwaá bú cie, nde né mé gèr mbiín kuú. Sâ, beè nùà sâ, huɔm kela né mé bɔ́ sé bú ŋàr ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Júdàs nuaá mé lé go sɔɔ́m naâ bú sâ yeé nde ŋgweé njií ménâ, à bie njií mé Yeésò ndɔ, ye bú a: «Ŋgweéh mè sam wa, Njí fèh-njèh?» Yeésò ye bú a: «Wò dé sâ tueé né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bɔ́ yeé baá yáb yieé, Yeésò weh breêd, à dua Càŋ teèn, à kɔlé haá mé bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: «Bí wèh, bí yíyieè, hên né ŋgàŋ yoòr mò.» ");
INSERT INTO mcu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","À jɔgɔ weh ŋgàb mbè ndɔ. À yeé vra gi aá Càŋ teèn, à haá njií bɔ́, ye bɔ́ a: «Bí wèh, bí ŋúé làrè dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hên né húɔ́m mò, húɔ́m ŋgɔ̀ŋ mé Càŋ kɔ kuú né, ye te nyí kulu sɔm bɔ̀ nùàr ŋgún veên mé njéh yoòr. ");
INSERT INTO mcu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mè tueé bí: mè ndeè mbè déì mân ŋúé ŋgwé ndé cú, kɔ ndeè baá dé feê ké Mbàm Tele mò, béh bí ŋueé kwaré cu ye.» ");
INSERT INTO mcu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jomo sâ bɔ́ de bené ndɔ, bɔ́ fɔɔ́n gò, bɔ́ ŋaá nde ké te tòr Oliviê. ");
INSERT INTO mcu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wa ké teèn, Yeésò tueé njií mé bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: «Lan cieé ŋágá ndé ŋgwéh, sâ bí durá si lɔ gi aá mè kèn. Te mvù Càŋe né ménâ nyagá den. Càŋ ye, nyí nde né nùà mbieè wulá sɔm. Bɔ̀ŋ bɔ̀ mbieè seèn nde né lòù durá ŋellé le. ");
INSERT INTO mcu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mɔ mè komo yuo cu aá lè cio, mè nde né ké Galilê ndeé; bí nde mè kwa nde né ké sâ.» ");
INSERT INTO mcu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","À yeé tueé gi aá mân, Piêr deên ndɔ, ye bú a: «Sâ mɔ bɔ̀ déì né mene wò durá si lɔɔ́, ndɔ́g mè dé mò wò dùlà sì lɔ́ ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeésò ye bú a: «Mè né tueé ye wò a, lan mé kwaá sé nde tuagá, sâ wò yaáŋ aá njó baá mbei tagár ye nyí mè kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piêr den cuù ndɔ, ye bú a: «Sâ mè sam; bélɔ̀ nde mene fà dɔɔ́ŋ kuú gií, mè túé nyì ndé ŋgwéh ye mè wò kɔ́ ŋgwéh.» Bɔ̀ mbɔ̀ŋ déì tueé gi ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn wa beré déì ndɔ, bɔ́ yilá né bèh sâ Gecemanè. Wa ké teèn, ye bɔ́ a: «Bí dèn ŋgɔ́gɔ̀ hên, mè nde aá kíê Càŋ dua weh.» ");
INSERT INTO mcu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","À weh lom Piêr mé bɔ̀ ŋunà Jebedê fà doô, bɔ́ bɔ́ nde, sâ feh baá bú ter ŋellé, à baá lom mé kú dé gècên. ");
INSERT INTO mcu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yeé baá môn, ye bɔ́ a: «Kú nde aá mè wulá. Bí dèn lè hên, bí té lɔ́m cèr, béh bí den ŋaga nde né làŋ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","À kwaá lɔ bɔ́ doó sâ ndɔ, à kela nde ser ké toò bèh ndɔ́ŋ-ndɔ̀ŋ mân. Wa ké teèn, à die mbab nde doó, à né Càŋ dua, ye bú a: «Tele mò, mɔ nde né yieé, ŋgòrò sɔ̀m yeè mè ŋgàb gèr hên kwarè teèn. Mè né mene ménâ gwaán, bɔ́ sér faá wò né gwaán nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","À yeé dua sɔm aá, à cu cuù ká yoòr bɔ̀ mbɔ̀ŋ, à waà, sâ bɔ́ baá gi lɔ́m, ye Piêr a: «Hên né mene be lɔ̂m cén, béh bí kɔɔ́ gó sɔ̀m cú wa? ");
INSERT INTO mcu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bí nyìmè dèn làŋ, bí né Càŋ dua, te *Sátàn bí mé veên táb sìè cú. Lòù sam, temé nùàr gwaán gi né njèh bagaà bɔɔ̂ dág; njèh cén, yo né yuaásé.» ");
INSERT INTO mcu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jomo sâ à kwaá lɔ bɔ́, à nde cu Càŋ dua, ye bú a: «Tele mò, mɔ ŋgàb gèr hên kwarè mò yùò ndé ŋgwéh, te mè bú ŋúé cú, sâ kwá den faá wò né gwaán nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","À cu cuù ká yoòr bɔ̀ mbɔ̀ŋ, à waà, sâ bɔ́ baá gi cu lɔ́m, dé goó keè sam cuú. ");
INSERT INTO mcu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeésò kwaá lɔ bɔ́, à nde cu ké bèh ndɔ́ŋ-ndɔ̀ŋ cén sâ, à dua Càŋ dé mbei tagâr, à dua ferré cu ka njèh cén sâ. ");
INSERT INTO mcu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","À yeé cu cuù aá, ye bɔ̀ mbɔ̀ŋ a: «Wa hên bí née lɔ́m ye wa? Bí cèr ká ceèr. Hên baá cu. Kènê *Huaán Nùàr nde aá beè bɔ̀ vevenê bɔ̀ yilá. ");
INSERT INTO mcu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bí wùò ter, béh nde kwa bɔ́! Kè hên baá giì nuaá mé go sɔm né mè sâ!» ");
INSERT INTO mcu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeésò née sònò mân tueé den, à yeé ke, Júdàs mbɔ̀ŋ cén déì lètenè bɔ̀ yulà cùɔ̀b fà bɔ̀ doô, kar waà ndɔ. À né mé nùàr kókoó mbaá jomo, bɔ́ né bele mé bòù beè-beè, bɔ́ né cu mé cùgò beè ndɔ. Bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ tema njií né bɔ́ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sâ Júdàs mé nde né Yeésò go sɔm doô naá giì bɔ́ njií mé à sé nde né bɔɔ́ tueé kwaá, te bɔ́ ŋene kɔ Yeésò mé njéh. Sâ à la ye bɔ́ a: «Mɔ bí ŋene mè baá nuaré déì kumó vra den, sâ né bú ma. Bí kèm ndê, te bí sie bú.» ");
INSERT INTO mcu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yeé baá môn, Júdàs ŋgoró nde yí kwarè Yeésò, ye bú a: «Mè né bieé, Njí fèh-njèh!» À vra kumó sie bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeésò ye bú a: «Mbeí mò, bɔ́ ká nág faá wò ndeè naâ bɔɔ́ sâ nɔ!» Jomo sâ, bɔ̀ nùàr kem sue Yeésò yoòr, bɔ́ sie bú. ");
INSERT INTO mcu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nùà cén déì lètenè bɔ̀ mbɔ̀ŋ Yeésò sua sɔɔ̂m bòù seèn ndɔ, mvur tena si njií nuaré déì tie doó; lé naâ tie nùà seê ŋgàŋ sèmè dé koô. ");
INSERT INTO mcu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeésò yeé ŋene aá ménâ, ye bú a: «Yí njí cú bòù yeè te kóre. Lòù sam, bòù wula cu nde né bɔ̀ sùà-bòù bɔ̀ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wò kɔ́ ŋgwéh ye mè sé la naâ Tele mò gàm bieé njií wa? À sé la mè bɔ̀ŋ bɔ̀ cìlì seèn yulà cùɔ̀b fà há yɔ́gɔ́ kéh ná ŋgwêh wa? ");
INSERT INTO mcu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Á, mɔ sé la baá cu ménâ, sâ nde né faá bɔ́ lé nyagá kwaá naâ lè mvù Càŋe nɔ, yuo wa? Né gi cie nyagá den, ye kɔ bɔɔ́ mân.» ");
INSERT INTO mcu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yeésò yeé tueé gi aá ménâ, à ye bɔ̀ nùàr a: «Den né faá bí mé bɔ̀ bòù mé cùgò beè-beè hên kem nde giì te bí sie nùà yîb nɔ. Ŋgweéh cieé dɔɔ́ŋ mè lé njèh feh den beéh ké *gwà Càŋ koô wa? Bí lé mè ké teèn sìè ná ŋgwêh dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mé njéh mene, hên bɔɔ́ gi né te yuo faá bɔ̀ *sòn-Càŋ bɔ̀ lé naá giì nyagá kwaá nɔ.» Jomo sâ bɔ̀ mbɔ̀ŋ durá si lɔ gi bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bɔ̀ɔ́ mé la sieé naâ Yeésò doô weh njií bú ké toò Kayîf ŋgàŋ sèmè dé koô, sâ bɔ̀ *njí-sóù mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ baá gi ké teèn bilí den. ");
INSERT INTO mcu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piêr né Yeésò jomo ké bèh ndɔ́ŋ-ndɔ̀ŋ naáb bele. Wa ké lɔ Kayîf, à yila nde yí cie lètenè caâ, à den nde kwarè bɔ̀ gô, à né njií mé nde né kelá ke den. ");
INSERT INTO mcu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sâ bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ dɔɔ́ŋ né lom ŋgòr fɔɔ́n, ye né mene nyeén, bɔ́ nde né Yeésò yoòr cɔré kwaá, te bɔ́ wula bú teèn. ");
INSERT INTO mcu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nyeén hèllè duɔɔ́m baá-re bú yoòr bomó sueè ndɔ; mé njéh mene, ka yíé ŋgwéh. Nde nde, nuaré déì bɔ̂ mbeí komó wuo ter toò bɔ̀ nùàr, ");
INSERT INTO mcu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ye bɔ́ a: «Nùà hên lé naâ tueé ye: nyí né mé terreb gwà Càŋ koô tulú sɔɔ̀m, te nyí me kwaá cu bú ter te cieé tagáre.» ");
INSERT INTO mcu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋgàŋ sèmè dé koô komo wuo ter ndɔ, ye Yeésò a: «Bɔ̀ nùà hên né wò yoòr tueé njií mân, wò sòn kòmò bèh wa? Bɔ́ ye naàn á?» ");
INSERT INTO mcu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mé njéh mene, Yeésò bú sòn kòmò ŋgwéh. Yeé baá ménâ, ŋgàŋ sèmè dé koô doô ye bú a: «Mé yilí Càŋ làŋ, wò nde né toò beèh jege ye, *Nùà Cɔ̀ŋ Ŋunà Càŋ né wò wa?» ");
INSERT INTO mcu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeésò ye bú a: «Wò bú tueé aá kèn. Mè tueé bí: kènê bí nde aá *Huaán Nùàr ŋené njií, à nde né ké te be gaâ Càŋ terrèb den den, à cu cuù nde né loù sâ njolò biì te mvulu bègè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Te ŋgàŋ sèmè dé koô yeé nde ŋgweé njií mân, à sie ŋa cɔ̀gɔ̀ seèn nùà njèh yoòr, à né sònò tueé ye: «Nùà hên né mé Càŋ ŋgeré. Sâ béh sònò bɔ̀ nùàr bie sɔɔ́ cu nde né kei wa? Ŋgweéh béh né gi mé tie mân ŋgweé wa? ");
INSERT INTO mcu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wa bí ye naàn?» Bɔ́ ye bú a: «À beè yila baá, kɔ bɔ́ wula bú wulà.» ");
INSERT INTO mcu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bɔ́ yila bú dèh njolò kulú su njiî, bɔ́ né bú teèn tulú yií. Bɔ̀ déì né bú dé bɔlê bɔlé, ");
INSERT INTO mcu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bɔ́ ye bú a: «Ŋéné kɔ́ cú-re ŋenè, Nùà Cɔ̀ŋ, jɔ̀gɔ̀ túé ke béh nuaá mé né wò lobo hên ye.» ");
INSERT INTO mcu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sâ Piêr née ka cu sâ ké lètenè caâ *ŋgàŋ sèmè dé koô den den ye. Ma seê déì njeba nde yí kwarè seèn, ye bú a: «Ŋgweéh bî Yeésò nùà Galilê hên né yeé kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piêr cam toò bɔ̀ nùàr doó sâ, ye ma doô a: «Wò jue né-re kei wa, mè dé sâ ŋgwé kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jomo sâ, à yuo doó sâ, à nde njebá den yí tùtúlù. Nùà seê dé vêh déì ŋene njií cu bú, tueé njií mé bɔ̀ nùàr, ye bɔ́ a: «Nùà hên bɔ̂ Yeésò nùà Najarêt né yeé kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piêr cam cu, à jege ye bɔ́ a: «Kà, mè nùà hên kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Den ser cu jomo sâ, bɔ̀ɔ́ mé naâ teèn njebá, ŋgoró nde kwarè seèn, ye bú a: «Mé gècên mene, wò né nùà cén déì lètenè bɔɔ̀n; leba yeè tueé ŋagá né ménâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piêr cam cu déì, ye bɔ́ a: «Mè sam, mɔ mè tueé né nyeén, Càŋ a dúágá mè a kà, mè nùà hên kɔ́ ŋgwéh lág!» À yeé tueé sɔm aá, kwaá tuaga ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","À munó ko cu baá-re dé mé Yeésò la ye bú a: «Mé kwaá cên sé nde tuagá wa, sâ wò yaáŋ aá njó baá mbei tagár, ye nyí mè kɔ́ ŋgwéh ma.» À yeé munó ko aá ménâ, à jeré yuo doó sâ, à nde yúé njegér. ");
INSERT INTO mcu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cieé yeé ŋaga baá, bɔ̀ *ŋgàŋ sèmè dé kokoô, mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ kaga lom aá kàgà-ndòn ye bɔ́ nde né Yeésò wulá. ");
INSERT INTO mcu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bɔ́ kaga bú ndɔ, bɔ́ weh nde mé bú ké toò ŋgɔ́mnà *Pilátò. ");
INSERT INTO mcu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Júdàs sàrnyé hèllè yeé ke bɔ́ nde aá Yeésò wulá, càŋ tené bú lè, à weh cu cuù mé kàgàlɔ̀ŋ kám yulà tagár hèllè, à haá njií cu mé bɔ̀ ŋgàŋ sèmè dé kokoô, bɔ́ bɔ̀ kokoô bɔ̀ dé lɔɔ̂, ");
INSERT INTO mcu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ye bɔ́ a: «Mè beè Càŋ kuú aá kèn; mè jɔgɔ yií aá nùà mé sòn fuû lè cio.» Bɔ́ ye bú a: «Dé sâ ju beèh sam, wò kɔ né mé njéh kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Júdàs su njií kàgàlɔ̀ŋ hèllè doó ké gwà Càŋ koô, à yuo kela; à nde ter segé kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɔ̀ ŋgàŋ sèmè dé kokoô domó sɔm kàgàlɔ̀ŋ hèllè, bɔ́ ye: «*Sóú beèh né yeé yiín, ye bɔ́ té gèh kàgàlɔ̀ŋ bú hên te fer gwà Càŋe kwá, né sòn húɔ̂m.» ");
INSERT INTO mcu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jomo sâ, bɔ́ colo sòn, bɔ́ nde ŋge weh ŋueèh nùà mé-sɔɔ̀ déì mé njéh, te bɔ́ furú beh bɔ̀ kìn teèn. ");
INSERT INTO mcu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wa hên, bɔ́ ŋueèh sâ “ŋueèh húɔ̂m” yilá den né dé cî. ");
INSERT INTO mcu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sâ dɔɔ́ŋ, bɔɔ́ gi né te yuo faá Jeremî *sòn-Càŋ lé naâ tueé nɔ, ye: «Bɔ́ weh baá kàgàlɔ̀ŋ kám yulà tagár kèn, né keh mé bɔ̀ huaán *Iserálà lé tena kwaá naâ felè seèn, ");
INSERT INTO mcu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bɔ́ ŋge weh baá ŋueèh nùà mé-sɔɔ̀, faá Nùà Dueè lé tueé naâ nyí nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yeésò yeé wa ké toò ŋgɔ́mnà, ŋgɔ́mnà bie ye bú a: «Mgbè bɔ̀ *Jûf né wò wa?» Yeésò ye bú a: «Wò dé sâ tueé né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ yeé baá mé bú sií njií den, à sòn kòmò cú. ");
INSERT INTO mcu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Te Pilátò nde cu ye mé bú tueé njií, ye bú a: «Bɔ́ né mé wò sií njií den, wò sòn kòmò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mé njéh mene, Yeésò bú sòn kòmò cú gùm dɔɔ́ŋ. Dé sâ hiím yɔgɔ́ cu ŋgɔ́mnà mbaá. ");
INSERT INTO mcu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sâ te cu *Páskà dɔɔ́ŋ, ŋgɔ́mnà né yeé nùà gwà cibì cén yi njií. Né yeé nuaá mé bɔ̀ lɔɔ́ bɔ̀ gwaán né kɔɔ́, ye yì bú yiì. ");
INSERT INTO mcu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yeé baá ménâ, nùà wúlá-feèh déì lé naâ cu sâ gwà cibì ndɔ, yilí seèn lé naâ Yeésò Barabâs. ");
INSERT INTO mcu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilátò bie njií baá-re mé cìlì nùàr, ye bɔ́ a: «Bí gwaán né ye mè yì njí bí neì wa? Yeésò Barabâs wa, Yeésò mé bɔ́ yilá né *Nùà Cɔ̀ŋ wa?» ");
INSERT INTO mcu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Lòù sam, à lé naá giì kɔɔ́, ye bɔ́ bunó né Yeésò lòù, wa bɔ́ bú ká beè nyî sie haá njií né dé cî. ");
INSERT INTO mcu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilátò yeé baá te ju sâ tétég ménâ, veèh seèn tema keéh njií ye bú a: «Té nùà hên njeré déì mbaá bɔ́, à bèh njèh kɔ́ ŋgwéh. Lan cíbítenè mè ŋene kuú yili mé gèr felè seèn mé vuú.» ");
INSERT INTO mcu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sâ bɔ̀ ŋgàŋ sèmè dé kokoô, mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ né lom bɔ̀ nùàr soób, ye bɔ́ a: «Bí júée Pilátò a: yì kéh bí Barabâs, à wula seér Yeésò ma.» ");
INSERT INTO mcu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jomo sâ ŋgɔ́mnà bie njií mé bɔ́, ye bɔ́ a: «Lètenè bɔ̀ fà bɔ̀ hên, bí gwaán né ye: yì njí bí dé heè wa?» Bɔ́ ye bú a: «Yì kéh béh Barabâs!» ");
INSERT INTO mcu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","À den cuù ye bɔ́ a: «Á, dé Yeésò mé bɔ́ yilá né *Nùà Cɔ̀ŋ hên nɔ, mè bɔɔ́ nde né mé bú kei wa?» Bɔ́ dɔɔ́ŋ ye bú a: «Bɔ́ fágá njí bú te toû.» ");
INSERT INTO mcu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilátò ye bɔ́ a: «À veên bɔɔ́ naâ kei wa?» Mé njéh mene, bɔ́ kɔ lom né ké ter lɔgɔ́ njiî, ye bú a: «Bɔ́ fágá njí lòm bú te toû dé fagâ.» ");
INSERT INTO mcu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilátò yeé ŋene bèmè baá ŋaá, wa nyí njeré déì bɔ́ kòmò ndé cú, ye bɔ́ kwè há nyí nòmò. Bɔ́ kwe haá njií bú, à yaga sɔm be seèn teèn toò bɔ̀ nùàr doó sâ, ye bɔ́ a: «Njó mò, mè te cio nùà hên yílá ŋgwéh; né ju biì.» ");
INSERT INTO mcu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cìlì nùàr gwaán laré doó dɔɔ́ŋ, ye bú a: «Nyea, kwá cio seèn sâ bie seèn béh ménâ; bú a, bíé bílí mé bɔ̀ ŋuna beèh mene, béh né gwaán!» ");
INSERT INTO mcu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yeé baá mân, Pilátò yi njií bɔ́ Barabâs hèllè ndɔ. Dé Yeésò, ye bɔ́ tégé bú núr, bɔ́ ndé fágá njí-re bú ké te toû sâ. ");
INSERT INTO mcu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bɔ̀ sɔ́jì ŋgɔ́mnà weh nde mé Yeésò ké lè bɔ̀gɔ̀ ŋgɔ́mnà, bɔ́ yilá bilí gi bɔ̀ mbaábɔn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bɔ́ huaré sɔm gi bú cɔ̀gɔ̀ yoòr, bɔ́ su seér bú cɔ̀gɔ̀ déì bèlèsé mân. ");
INSERT INTO mcu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bɔ́ nde fɔɔ́n wellê bɔ̀ ŋùàgà, bɔ́ beéh faá tàm nɔ, bɔ́ sulí kwaá bú felè, bɔ́ ye né tàm mgbè ma. Bɔ́ kwa haá bú gor beè, à weh sie mé be gaâ. Bɔ́ né doó toò seèn cemmé ndeé, bɔ́ né bú gbêg haá, bɔ́ ye bú a: «Sìè ŋgób, Mgbè bɔ̀ Jûf!» ");
INSERT INTO mcu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bɔ́ né bú dèh yoòr kulú njií, bɔ́ né bú mé gor hèllè felè lurú. ");
INSERT INTO mcu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bɔ́ yeé selé wulu aá bú, bɔ́ huar sɔm cu bú cɔ̀gɔ̀ hèllè yoòr, bɔ́ su cu bú cɔ̀gɔ̀ dé seèn. Jomo sâ bɔ́ weh nde baá-re mé bú ké bèh sâ, te bɔ́ faga wula bú. ");
INSERT INTO mcu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bɔ́ yeé baá yuo kelá, bɔ́ bɔ̀ nùà Sirên déì kwaré, yilí seèn né Simɔ̂ŋ; bɔ́ sie ba haá bú toú mé bɔ́ nde né Yeésò teèn fagá doô, à jɔgɔ sie. ");
INSERT INTO mcu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bɔ́ wa beré déì, bɔ́ yilá né bèh sâ Gɔ́lgɔ́tà, sâ tueé né ye: Gebá feèh. ");
INSERT INTO mcu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wa ké teèn, bɔ́ haá Yeésò mbè mé ndìèm né teèn jelá hualé den. À yeé naga ke aá, à berɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jomo sâ bɔ́ faga njií bú te toû, bɔ́ vu geé weh gi bɔ̀ cɔ̀gɔ̀ seèn mé bèì. ");
INSERT INTO mcu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bɔ́ yeé faga gi aá bú, bɔ́ den le teèn, bɔ́ né mɔɔ́m den. ");
INSERT INTO mcu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bɔ́ nyagá fagá kwaá njeré déì ké ter felè seèn, te se kwɔ̀m cioò seèn doô, ye: «Nùà hên né Yeésò, Mgbè bɔ̀ Jûf.» ");
INSERT INTO mcu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɔ́ lé naâ Yeésò bɔ̀ yíb bɔ̀ wúlá-feèh déì fà kwarè fagá kwaá ndɔ; dé kàn mé toú seèn, déì te be gaâ, déì te be ŋgoù, Yeésò lètenè. ");
INSERT INTO mcu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nuaá mé kela doó sâ dɔɔ́ŋ, né feh jilí, né bú teèn selé yií. ");
INSERT INTO mcu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nùà kàn ye bú a: «Ŋgweéh wò lé ye nyí nde né gwà Càŋ koô tulú sɔm, nyí bú ter me kwaá cu te cieé tagáre wa? Yìlì sɔ̀m-re feh yeè yilì. Mɔ wò né ka Ŋunà Càŋ sâ bɔ̀n, jɔ̀gɔ̀ súágà ke yí te toú sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɔ̀ ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ *njí-sóù mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ né bú gbêg ménâ haá taré ndɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«À kɔ cegé né bɔ̀ nùàr yili sɔɔ̀m, à feh dé seèn nùà njèh yìlì sɔ̀m kɔ́ ŋgwéh. Ŋgweéh né Mgbè bɔ̀ *Iserálà bɔ̀ wa? Sâ bú a, súágà-re yí te toú sâ mà, te béh kwaá njií temé yoòr seèn. ");
INSERT INTO mcu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ŋgweéh à temé seèn dɔɔ́ŋ kwaá lɔ gi né beè Càŋ mà, wa nyí né Ŋunà Càŋ ndɔ. Sâ béh jɔ̀gɔ̀ ke-re bèh mé Càŋ nde né bú yili sɔm sâ.» ");
INSERT INTO mcu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɔ̀ yíb bɔ̀ mé bɔ́ lé faga kwaá naâ kwarè seèn doô né taré bú ménâ selé keéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lou yeé dilí baá, lou cib cu. Cibí yili laré cu ká doó dɔɔ́ŋ, yili sɔɔ́ gùm yɔ̀ŋ loù tagâr. ");
INSERT INTO mcu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yeé baá mé lou lɔ̀ŋ tagár, Yeésò sɔm hueh mé terreb, ye: «Elî, Elî, lemá sàbátànî?» Sâ tueé né ye: «Càŋ mò, Càŋ mò, bɔɔ́ né naàn mé wò si lɔ né mè wa?» ");
INSERT INTO mcu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bɔ̀ nuaré déì lètenè bɔ̀ɔ́ mé né doó sâ yeé ŋgweé aá ménâ, bɔ́ ye: «À baá *Elî yilá.» ");
INSERT INTO mcu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cén déì lètenè bɔɔ̀n nde dula dɔm wellê fùlù, à yií njií te mbè déì tanésé mân, à feéh kwaá te toû, à tiím haá njií mé bú, te à njuar weh. ");
INSERT INTO mcu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bɔ̀ déì ye bú a: «Kwá lɔ́ môn, béh jɔ̀gɔ̀ ke ke, kɔ ŋgweé Elî sâ ndeè né waâ, à yili sɔm bú wa?» ");
INSERT INTO mcu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeésò ŋga cu mé terreb, jomo sâ à kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Cu sâ cɔ̀gɔ̀ *gwà Càŋ koô keér geé lèbɔ̂lé, yuoô ké ter, nde ba ké doó. Cɔ̀gɔ̀ sâ né kɔ̀ŋ. Né yeé mɔ̀ ké gwà Càŋ cií leér. Tàbè né jilí, bɔ̀ kweéh né kerré, ");
INSERT INTO mcu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bɔ̀ sà né komó lɔgɔ́ bele; bɔ̀ dùlà-Càŋ bɔ̀ mé lé naá giì kuú, komó yuo gi cuù dòù. ");
INSERT INTO mcu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yeésò yeé komo yuo aá lè cio, bɔ̀ dùlà-Càŋ bɔ̀ mé lé komó yuo giì naâ dòù sâ, yila nde gi ké lètenè lɔɔ́ joloò; bɔ̀ nùàr kókoó mbaá lé naá giì bɔ́ mé njolo ŋené. ");
INSERT INTO mcu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kwaá-taâb bɔ̀ Rɔ̂m bɔ̀ mé bɔ̀ sɔ́jì mé lé mɔm deèn naâ Yeésò doô, lé naâ bèh mé tàbè lé jilí naâ sâ ŋené, bɔ́ lé naá giì bɔ̀ njií mé lé bɔɔ́ belé naâ dɔɔ́ŋ ŋené ndɔ. Bɔ́ yeé ŋene aá ménâ, veéh bɔɔ́ lom bɔ́ njèh, bɔ́ ye: «Mé gècên mene nùà hên né ŋunà Càŋ bɔ̀n!» ");
INSERT INTO mcu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ké teèn sâ bɔ̀ véh lé naâ teèn kókoó mbaá, bɔ́ né ké bèh ndɔ́ŋ-ndɔ̀ŋ njebá ke den. Bɔ̀ sâ bɔ̀ lé yuoó naâ ké Galilê, bɔ́ né jomo Yeésò bele ndeé, te bɔ́ gam beh bú. ");
INSERT INTO mcu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lé naâ bɔ̀ Marî Magdalâ, bɔ̂ Marî meì Jâk bɔ̂ Josêf, mé meì bɔ̀ ŋunà Jebedê, mé bɔ̀ déì ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lou yeé yuɔm aá, nùà lieê déì waà, à né nùà Arimatê, yilí seèn né Josêf, à lé baá giì mbɔ̀ŋ Yeésò mé feh seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","À nde ké yoòr *Pilátò, à dua bú komó Yeésò. Pilátò ye bɔ́ há bú haà ma. ");
INSERT INTO mcu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josêf nde jɔgɔ weh komó Yeésò doô, à vuɔb nyegé bú mé cɔ̀gɔ̀ nyɔ́gɔ̀r feésé mân, ");
INSERT INTO mcu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","à jɔgɔ yií njií bú gè dòù lè sà feésé mân ndɔ. À lé sà sâ kweè naâ kweéh, ye te bɔ́ ndeè furú nyí teèn ma. Jomo sâ à teré ferá kwaá taá koósé mân sònòbɔ̀ ndɔ, à yuo. ");
INSERT INTO mcu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sâ Marî Magdalâ bɔ̂ Marî déì né doó, dɔɔ́ŋ lé naá giì njolò bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cieé sóù yeé ŋaga baá, bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *Farisiên nde bilí kwa Pilátò, ");
INSERT INTO mcu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bɔ́ ye bú a: «Dé koô, béh munó ko cu aá kèn, cu mé nùà nyeên doô lé naâ mé njolo, à lé ye: te cieé tagáre nyí nde né dòù komo yuo cuú! ");
INSERT INTO mcu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mɔ né mân, sâ témá njí bɔ̀ nùàr ké teèn, bɔ́ nde sà hèllè mɔɔ́m, kɔ baá cieé tagár sâ, sâ ye. Mɔ sam bɔ̀ mbɔ̀ŋ seèn sé nab waà né, bɔ́ ŋuɔb weh komó seèn, te bɔ́ ye bɔ̀ nùàr a, à naâ lè cio komo yuo. Sâ nyeén dé jomò hên nde né dé toò taré yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilátò ye bɔ́ a: «Bɔ̀ sɔ́jì né teèn. Bí ndé sà hèllè faá né tueé nɔ mɔɔ́m.» ");
INSERT INTO mcu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bɔ́ yuo ndɔ, bɔ́ nde baá-re ké teèn ménâ ke nyegé, bɔ́ duagá lieré nyegé gi sòn sà mé taá, ye te njeré déì bɔ́ cú, bɔ́ kwaá lɔ beè bɔ̀ sɔ́jì, te bɔ́ goó den teèn. ");
INSERT INTO mcu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jomo *cieé sóù sâ, loù sɔ́ndè toò cieê, Marî Magdalâ bɔ̂ Marî déì komo nde bèh sà ke wellê. ");
INSERT INTO mcu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wa ké teèn, bɔ́ ke, tàbè baá mé terreb mene jilí, cìlì Càŋ Nùà dueè déì suagà ké te vulúu, teré kwaá njií taá sònò sà doô yí jomo, den nde felèbɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","À né teèn wulá njerré den faá mbàn nɔ, bɔ̀ cɔ̀gɔ̀ seèn né lom yoòr ménâ wulá njerré den ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Càŋ tené bɔ̀ sɔ́jì doô lè. Veéh keré su njií bɔ́ doó, faá bɔ́ kuú gi aá nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Cìlì Càŋ tueé njií mé bɔ̀ véh doô ndɔ, ye bɔ́ a: «Bí té vèh, mè né gi kɔɔ́ ye bí ndeè naâ yoòr Yeésò mé bɔ́ lé naâ fagá wulá doô. ");
INSERT INTO mcu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","À doó hên sam cuú, à komo yuo aá lè cio faá à lé naâ tueé nɔ. Bí ndê, kè kú biì, bèh mé à naâ teèn cer hên nɔ. ");
INSERT INTO mcu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bí ndé lòm wúwágá, bí júée bɔ̀ mbɔ̀ŋ seèn a: à komo yuo aá lè cio, à nde né toò kelá, à nde ké Galilê; wa bí ndé ké teèn, bí nde ŋene nde né bú ké doó sâ ma. Mè ndeè naâ bí cí tueé weh.» ");
INSERT INTO mcu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bɔ́ yeé nde ŋgweé gi ménâ, bɔ́ feré yuo ké te sà mé vɔ́gɔ́-temé mene, mé veéh mene ndɔ, bɔ́ dula nde baá-re bɔ̀ mbɔ̀ŋ seèn ménâ tueé. ");
INSERT INTO mcu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bɔ́ yeé baá ceér dueè, Yeésò kar yuo kelà ndɔ, ye bɔ́ a: «Mè bie aá bí.» Te bɔ̀ véh doô yeé nde ŋene ŋgweé cu bú mân, bɔ́ ŋar nde yoòr seèn, bɔ́ sue cemmé nde doó, bɔ́ kumó sie bú gule ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeésò ye bɔ́ a: «Bí té njeré déì vèh. Bí ndé júée bɔ̀ nùàr mò a: bɔ́ ndé ké Galilê, bɔ́ nde ŋene nde né mè ké sâ ma.» ");
INSERT INTO mcu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bɔ̀ véh doô fɔɔ́n gò ndɔ. Cu sâ bɔ̀ sɔ́jì déì lètenè bɔ̀ɔ́ mé mɔm deén naâ sà doô, ŋellé cu cu ké lɔ, te bɔ́ nde bɔ̀ *ŋgàŋ sèmè dé kokoô njií mé la kelà naâ tueé weh. ");
INSERT INTO mcu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bɔ̀ ŋgàŋ sèmè dé kokoô yeé ŋgweé aá ménâ, bɔ́ yilá bilí bɔ̀ kokoô bɔ̀, bɔ́ bɔ́ colo sòn, bɔ́ weh kàgàlɔ̀ŋ kókoó mbaá, bɔ́ haá mé bɔ̀ sɔ́jì doô, ");
INSERT INTO mcu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bɔ́ ye bɔ́ a: «Bí júé lòm ye bɔ̀ nùàr a: bɔ̀ mbɔ̀ŋ seèn la waà naâ cíbíteèn, sâ bí baá gi lɔ́m, bɔ́ ŋuɔb weh komó seèn ma. ");
INSERT INTO mcu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mɔ ŋgɔ́mnà ŋgweé mene, béh nde né bú nagá yɔgɔ́, te bí gèr ŋéné cú.» ");
INSERT INTO mcu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yeé baá môn, bɔ̀ sɔ́jì doô weh kàgàlɔ̀ŋ hèllè ndɔ, bɔ́ yuo die teèn, bɔ́ né faá bɔ̀ kokoô bɔ̀ tueé naâ bɔ́ nɔ, tueé gɔ. Nyeén hèllè nde tum die yila lètenè bɔ̀ *Jûf dɔɔ́ŋ. Wa mene hên, née yaám ndeé den ye. ");
INSERT INTO mcu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bɔ̀ mbɔ̀ŋ dé yulà cùɔ̀b cén doô wa ké Galilê, bɔ́ ŋaá nde ké te tòr mé Yeésò lé tueé naâ bɔ́ sâ. ");
INSERT INTO mcu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bɔ́ yeé nde ŋene njií bú mân, bɔ́ sue cemmé nde gi doó toò seèn. Mé njéh mene, bɔ̀ déì né dé bɔɔ̀n lòù saán seér. ");
INSERT INTO mcu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeésò ŋgoró nde kwarè bɔɔ̀n ndɔ, ye bɔ́ a: «Terreb ké ter mé ká doó dɔɔ́ŋ lé baá giì beè mò jege den. ");
INSERT INTO mcu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sâ bí wùò ter, bí yila nde lètenè bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ, bí né bɔ́ bɔ̀ mbɔ̀ŋ mò sie kwaá bele: bí né bɔ́ nòmò Càŋ mé yilí Teleè, mé yilí Huaân mé yilí Cúcuí Ŋagâ ber bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ŋgòr mò mé bí naá giì sònò mò ŋgweé dɔɔ́ŋ, bí fèh lòm bɔ́ nág, te bɔ́ jolo ménâ. Bí kɔ́ɔ ye, cieé dɔɔ́ŋ béh bí né kɔɔ́, tɔ́g nde wa loù mé wɔ́ŋ gi nde né teèn.»");
INSERT INTO mcu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Njàgà Bagaà felè Yeésò *Kristò Ŋunà Càŋ duɔɔ́m né hên. ");
INSERT INTO mcu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Né te mvù Esáyà *sòn-Càŋ nyagá den ye: «Kè njí, mè toò yeè tema keéh né nùà tebê te à tɔɔ́ nyegé wò ceér. ");
INSERT INTO mcu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Né hueh nuaré déì; ké ya dueè ŋgulí den né cí, né tueé ye: Bí tɔ́ nyégé ceér Nùà Dueè tɔɔ̀, bí tɔ́ dìlì nyégé bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yeé baá mân Jâŋ Bàptîs ŋené yuo kelà ké ya dueè ndɔ, à né ŋgòr Càŋ se, ye bɔ̀ nùàr a: «Bí kwéh sér temé biì, bí ndê, bí weh nòmò Càŋ, te Càŋ kulu sɔm bí veên yoòr.» ");
INSERT INTO mcu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bɔ̀ Jerusalem bɔ̀ mé bɔ̀ nùàr te tàbè Judê dɔɔ́ŋ kem nde giì yoòr seèn, bɔ́ né veên bɔɔ̀n cie tueé sɔm, Jâŋ né bɔ́ dùà Jurdên kou den. ");
INSERT INTO mcu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Cɔ̀gɔ̀ seèn lé naâ mé yúlí ŋgelobà, à ké teneè cam tena né mé kàndá paàr mân; yáb seèn lé naâ kètàr mé nyuií. ");
INSERT INTO mcu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","À né ké ter tueé njií, ye bɔ̀ nùàr a: «Nuaré déì baá jomo mò ndeê, taré kela né bú mé mè. Né mene yuií débágâ seèn, mè wúlú ŋgwéh nuaá mé nde né toò seèn cemmé, te à se yuií débágâ seèn. ");
INSERT INTO mcu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Dé mò, mè bí kou lom né mé nòmò; dé seèn à bí kou nde né mé Cúcuí Ŋagâ.» ");
INSERT INTO mcu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Loù sâ Yeésò yuoô ké Najarêt te tàbè Galilê, à waà ké dùà Jurdên, Jâŋ kou bú nòmò Càŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","À yeé baá yí dùà yuo kelâ, à ŋene njií vulú gulu lɔgɔ́ aá ké ter, Cúcuí Ŋagâ né ké felè seèn faá vɔgɔb nɔ suagâ. ");
INSERT INTO mcu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hueh déì né ké jomo te vulúu ŋgulí, ye: «Wò né huaán yíé-temé mò; temé mò né lè mé wò nɔré.» ");
INSERT INTO mcu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tètèì sam, Cúcuí Ŋagâ lu njií bú ké ya dueè ndɔ, ");
INSERT INTO mcu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","à bɔɔ́ ké teèn cieé yulà nèà, à né ké lètenè bɔ̀ nyam cer den; *Sátàn né bú mé veên ké sâ taáb sɔɔ́; bɔ̀ cìlì Càŋ né bú yo taré gam. ");
INSERT INTO mcu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bɔ́ yeé yií njií aá Jâŋ gwà cibì, Yeésò fɔɔ́n gò ndɔ, à nde ké Galilê, à né Njàgà Bagaà mé yuoó naâ beè Càŋ se yɔŋ, ");
INSERT INTO mcu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ye bɔ̀ nùàr a: «Cu waà baá kèn. Càŋ baá mbàm seèn ká kwarè biì si njiî. Bí yúé fɔ́n feh biì yueè, bí kwéh sér temé, bí kwaá njií temé te Njàgà Bagaà.» ");
INSERT INTO mcu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeésò yeé baá ké sòn tub Galilê gɔ ndeé, à ŋene njií Simɔ̂ŋ bɔ̂ dìm seèn Andrê né ndoór dùà vuú den. Né bɔ̀ sìè-ŋgò bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","À ye bɔ́ a: «Bí bèlè mè; mè bí kènê sie kwaá nde aá bɔ̀ kòrò nùàr.» ");
INSERT INTO mcu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bɔ́ vu njií ndoór doó lè sòn Yeésò, bɔ́ yuo bele bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","À gɔ ser cu, à ŋene njií Jâk bɔ̂ dìm seèn Jâŋ bɔ̀ ŋunà Jebedê, bɔ́ né yí te kɔm bɔɔ̀n ndoór bɔɔ́ nyegé den. ");
INSERT INTO mcu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","À yilá njií cu bɔ́. Bɔ́ komo wuo ter kwar, bɔ́ kwaá lɔ tele bɔɔ̀n Jebedê te kɔme mé bɔ̀ seé bɔ̀ mene, bɔ́ yuo bele bú. ");
INSERT INTO mcu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn wa lè lɔɔ́ Kapernahûm ndɔ. Yeé baá loù sóù, à yila nde lè *gwà sóù, à né bɔ̀ nùàr njèh feh den. ");
INSERT INTO mcu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","À yeé baá feh, hiím seér bɔ̀ nùàr dé hiîm. Lòù sam, à lé bɔ́ feh loóm naâ faá nùà njèh nɔ, à lé bɔ́ faá bɔ̀ *njí-sóù nɔ fèh ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sâ lè gwà sóù sâ, nuaré déì lé naâ teèn, à né mé càŋ yoòr. ");
INSERT INTO mcu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","À lɔgɔ njií ké ter, ye: «Óè, Yeésò nùà Najarêt, wò ndeè né béh wulá sɔm wa? Béh bí né lè keé-re? Mè né gi ndègè yeè kɔɔ́, wò dé yeè né jolosé, Càŋ wò temà naâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeésò pam bú ndɔ, ye bú a: «Húné sòn yeè, yùò kélâ lè nùà hên wágácén.» ");
INSERT INTO mcu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tándulu jege si njií nùà hèllè doó, yuo kelà, né kéŋ sɔm. ");
INSERT INTO mcu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Geí laré bɔ̀ nùàr gwà dɔɔ́ŋ. Bɔ́ né lètenè bɔɔ̀n bieé kuú ye: «Hên né kei mân? Né lom njèh dé feê mé terreb mene. Kè kú, né mene bɔ̀ càŋ, à né tueé, bɔ́ né gi sòn seèn ŋgweé.» ");
INSERT INTO mcu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tètèì sam, ŋgɔ́g Yeésò ŋgulí sie aá tàbè Galilê dɔɔ́ŋ beè. ");
INSERT INTO mcu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bɔ́ yuo kelà lè *gwà sóù, tètèì sam, bɔ́ nde ké lɔ Simɔ̂ŋ bɔ̂ Andrê; bɔ́ bɔ̀ Jâk mé Jâŋ lé naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sâ gùnà Simɔ̂ŋ né baán, à né doó cer den, à né mé dùlù yoòr. Yeésò yeé yila kweêh, bɔ́ tueé keéh bú cí ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","À ŋgoró nde kwarè ma doô, à sie bú be, à komo sɔm bú ter; dùlù kem yuo ma doô yoòr ndɔ. Ma doô bɔɔ́ haá bɔ́ yáb. ");
INSERT INTO mcu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lou yeé yila baá, bɔ̀ nùàr weh waà mé bɔ̀ beén bɔ̀ bɔɔ̀n dɔɔ́ŋ, bɔ̀ déì né mé tándulu yoòr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Cìlì nùàr lɔ sâ dɔɔ́ŋ bilí nde giì ká tùtúlù gwà. ");
INSERT INTO mcu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","À né nùàr ŋgún te beén hihinê taré sɔm bele; à né cu bɔ̀ tándulu kókoó mbaá yoòr bɔ̀ nùàr kwɔgɔ́ sɔm bele ndɔ. À yiín bɔ́ sòn tueê. Lòù sam, bɔ́ lé naâ bú ŋené kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yeé baá toò cieê, Yeésò komo yuo kelà gwò, à nde ké bèh ndɔ́ŋ-ndɔ̀ŋ Càŋ dua. ");
INSERT INTO mcu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ̂ŋ bɔ́ bɔ̀ mbeí nde bú fɔɔ́n ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bɔ́ nde kwa bú, bɔ́ ye bú a: «Bɔ̀ nùàr dɔɔ́ŋ né wò fɔɔ́n.» ");
INSERT INTO mcu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","À tueé seér ye bɔ́ a: «Béh nde ser toò, te mè tueé ju Càŋ te bɔ̀ lɔɔ́ déì ndɔ. Lòù sam, mè ndeè naâ dé cî.» ");
INSERT INTO mcu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yeé baá môn, bɔ́ bɔ́ yɔŋ sie tàbè Galilê dɔɔ́ŋ beè. À né ŋgòr Càŋ te *gwà sóù se bele, à né bɔ̀ tándulu yoòr bɔ̀ nùàr kwɔgɔ́ sɔm bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nùà beén veên déì waà, cemmé nde toò Yeésò ndɔ, ye bú a: «Kúkùr yeè, mɔ wò né gwaán, wò nde né mè taré sɔm, mè den cu ŋagásé.» ");
INSERT INTO mcu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jere bɔɔ́ Yeésò njèh, à kema njií bú be yoòr, ye bú a: «Mè gwaán aá kèn, táré yùò tarè.» ");
INSERT INTO mcu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Beén nùà hèllè nyimé yuo doó sâ ndɔ, à taré yuo. ");
INSERT INTO mcu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yeésò yeé baá bú gò bieé, à luɔm bú, ");
INSERT INTO mcu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ye bú a: «Càŋ a bɔ́ wò tueé nuaré déì. Ndé lòm ké yoòr *ŋgàŋ sèmè, wò feh keéh bú yo yeè, wò haá bú gèh dàgà beén sâ, faá Músì lɔ naâ tueé nɔ, te bɔ̀ nùàr ŋene kɔ seér teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nùà hèllè yuo ndɔ. Njèh cén, à nde seér cu bɔ̀ nùàr tueé laré. Yeé baá ménâ, Yeésò lɔ́ŋ kwà cú mé à nde né ké lɔ bèsɔ́nè yuo kelá, à nde den seér cu aá ké ya bèh ndɔ́ŋ-ndɔ̀ŋ. Kàn né yuoô, kán né yuoô, bɔ́ né ké yoòr seèn ndeé. ");
INSERT INTO mcu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yeé cer weh baá, Yeésò cu cu ké Kapernahûm. Bɔ́ ŋgweé cu ye à baá ké gwò. ");
INSERT INTO mcu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Cìlì nùàr kem wa cuù ŋgún, faŋ yila gwò; bèh yuú gi, mé cie mene. À né bɔ́ ŋgòr Càŋ se den. ");
INSERT INTO mcu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bɔ̀ nuaré déì jɔgɔ waà mé nùà gule kuû déì ndɔ. Nùà nèà lètenè bɔɔ̀n lé jɔgɔ̀ naâ bú kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bɔ́ waà, sâ nùàr faŋ tena baá toò, ceér yí toò Yeésò waâ teèn sam cuú. Yeé baá ménâ, bɔ́ jɔgɔ ŋaá mé bú ké felè gwà ndɔ, bɔ́ komo feh gwà, bɔ́ sege yií keéh bú teèn mé tèb mene, bɔ́ kwaá njií doó toò Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yeésò yeé ŋene, ye temé bɔɔ̀n dɔɔ́ŋ né lom yoòr nyî ménâ, à ye nùà beên a: «Huaán mò, bɔ̀ veên yeè gi aá wò mé njéh kèn.» ");
INSERT INTO mcu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sâ bɔ̀ *njí-sóù déì lé naâ doó sâ teèn. Te bɔ́ yeé nde ŋgweé njií ménâ, bɔ́ yila lè bɔɔ̀n ndugó beleè, ");
INSERT INTO mcu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ye: «Nùà hên mân tueé né dé keì? Ŋgweéh à feh seèn weh né faá Càŋ mà. Nuaré déì né mé terreb veên nùàr kulú sɔɔ̀m wa? Né lom Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yeésò ŋene kɔ mùnò bɔɔ̀n ndɔ, ye bɔ́ a: «Bí ménâ munó né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Beè biì, taré kela né tueê ye nùà beên a: Bɔ̀ veên yeè gi aá wò mé njéh kèn, wa né: wùò ter, wèh tèb yeè, gègɔɔ̀ wa? ");
INSERT INTO mcu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bí kɔ́ɔ ye: *Huaán Nùàr né mé terreb veên ká doó dɔɔ́ŋ kulú sɔɔ̀m.» À den cuù baá-re, ye nùà gule kuû doô a: ");
INSERT INTO mcu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Mè ye wò a: wùò ter, wèh tèb yeè, ndé á lɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nùà hèllè komo wuo ter kwar ndɔ, weh tèb seèn, fɔɔ́n gò njolò bɔ̀ nùàr doó sâ. Geí laré bɔ̀ nùàr doó dɔɔ́ŋ, bɔ́ né Càŋ teèn seén yií, ye: «Béh née kèkènè dé hên ŋéné ŋgúŋgwéeh ye!» ");
INSERT INTO mcu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeésò yuo kela ndɔ, à nde cu ké sòn tub Galilê. Cìlì nùàr kem wa cuù ŋgún, à né bɔ́ njèh feh den. ");
INSERT INTO mcu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jomo sâ à nde ser toò. Wa beré déì, à ŋene njií Levî ŋunà Alfê, à né ké gwò bèh seé seèn den den, à né kàgàlɔ̀ŋ làmpɔ̂ŋ weh. Ye bú a: «Yùò bèlè mè!» Levî yuo bele bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","À nde ké lɔ Levî yáb yieé. Bɔ́ bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mé bɔ̀ vevenê bɔ̀ kókoó mbaá lé yieé bilí naâ kɔɔ́, mé bɔ̀ mbɔ̀ŋ seèn mene ndɔ. Lòù sam, bɔ̀ nùàr lé belé naâ jomo seèn ŋgún. ");
INSERT INTO mcu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te bɔ̀ njí-sóù mé né yeé lètenè bɔ̀ *Farisiên yeé nde ŋene njií Yeésò bɔ́ bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mé bɔ̀ vevenê bɔ̀ né yáb bècénè yieé bilí ménâ, bɔ́ ye bɔ̀ mbɔ̀ŋ seèn a: «Bɔ́ bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mé bɔ̀ vevenê bɔ̀ yáb bècénè yieé bilí né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeésò yeé ŋgweé aá ménâ, ye bɔ́ a: «Bɔ̀ beén bɔ̀ né yeé mé koró nùà lèh kɔɔ́, dèn ŋgwéh bɔ̀ tetarê bɔ̀. Mè hên nde kuú naâ bɔ̀ vevenê bɔ̀ ká yoòr mò yilá njiî, dèn ŋgwéh bɔ̀ didilî bɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cieé déì bɔ̀ mbɔ̀ŋ Jâŋ Bàptîs bɔ́ bɔ̀ *Farisiên lé naâ yáb jolo. Bɔ̀ nùàr ndeè ye Yeésò a: «Bɔɔ́ né naàn mé bɔ̀ mbɔ̀ŋ Jâŋ mé bɔ̀ mbɔ̀ŋ dé bɔ̀ Farisiên né yáb jolo, bɔ̀ mbɔ̀ŋ dé yeè yáb jòlò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeésò ye bɔ́ a: «Loù mé bɔ́ sua yeé véh, mé si né doó samé den, bɔ̀ mbeí nde né yáb jolo wa? Dé sâ ndɔ́g. Cu mé bɔ́ bɔ̀ si né kɔɔ́, bɔ́ yáb jòlò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mé njéh mene, bí kwá cieé déì, mɔ bɔ́ ŋgaá sɔm aá bɔ́ siì fù beè, bɔ́ ndeè jolo ye bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Nuaré déì beéh cɔ̀gɔ̀ feê felè cɔ̀gɔ̀ dé cuûm téná làb njí bèh. Mɔ sam, dé feê nde né dé cuûm doô komo ŋɔré sɔm. ");
INSERT INTO mcu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Bɔ́ tàgà mé kulu feê lè ŋguú cuúme sì kwá bèh ndɔ. Mɔ sam, tàgà nde né jelá, ŋguú keér, mbè ber nde doó. Bɔ́ vu be te mbè mé ŋguú mene fà dɔɔ́ŋ. Mɔ bɔ́ baá mbè mé kulu feê si, bɔ́ bú si kwaá yeé lè ŋguú feê.» ");
INSERT INTO mcu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Loù sóù déì, bɔ̀ Yeésò né te ŋueèh yolò gɔ kelá, bɔ̀ mbɔ̀ŋ né mé lùà ceceér kwalé yieé ndeé. ");
INSERT INTO mcu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bɔ̀ *Farisiên deên ndɔ, ye Yeésò a: «Ŋéné ká mé njolo yeè: Bɔɔ́ né naàn mé *sóú beèh né yiín, bɔ̀ mbɔ̀ŋ yeè né lùà loù sóù kwalé yieé wa?» ");
INSERT INTO mcu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Yeésò ye bɔ́ a: «Njií mé *Davîd nùà njèh lé naâ bɔɔ́ doô, bí née jáŋé kè ŋgwéeh ye wa? Lé naâ te nàm Abiata *ŋgàŋ sèmè dé koô. Loù sâ Davîd bɔ́ bɔ̀ nùàr seèn yeé nde aá mé cùè kuú, à lé naâ te gwà Càŋe yilá ndeé. Yáb mé bɔ́ lé kwaá lɔɔ̀ naâ toò Càŋ, à lé naâ jɔgɔ́ weh, à yieé, à haá njií bɔ̀ nùàr seèn kèb déì, bɔ́ yieé ndɔ. Sâ bí né kɔɔ́ ye né yeé jolo, bɔ̀ ŋgàŋ sèmè yieé cegé yeé kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeésò den cuù, ye bɔ́ a: «Càŋ lé *cieé sóù sou kwaá naâ ye te gam nùàr, à lé nùàr mé sér ná ŋgwêh ye te gam cieé sóù. ");
INSERT INTO mcu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sâ tueé né ye, *Huaán Nùàr né mé cieé sóù mene yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jomo sâ Yeésò nde cu ké *gwà sóù ndɔ. Sâ nùà be ŋemâ déì né ké gwò sâ. ");
INSERT INTO mcu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bɔ́ né Yeésò mé ju taáb, ye mɔ à taré sɔm nùà sâ loù sóù, bɔ́ nde né bú sie ma. ");
INSERT INTO mcu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeé baá ménâ, Yeésò ye nùà mé be ŋemâ doô a: «Wùò njébá ter njolò bɔ̀ nùàr.» ");
INSERT INTO mcu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","À den cuù, ye bɔ̀ nùàr a: «Sóú biì ye naàn wa? Ye loù sóù béh bɔ́ njèh bagaà wa, béh bɔ́ sér dé veên wa? Ye huɔm kela né nùàr loù sóù yili sɔɔ̀m wa, dé nùàr wulá seêr wa?» Bɔ́ sòn kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","À né bɔ́ doó dɔɔ́ŋ mé njèh mene ke laré, temé né bú lè mé jéré-temé bɔɔ̀n yulá. À tueé njií mé nùà hèllè ndɔ, ye bú a: «Nèbbè be yeè nebbè.» À nebbé be ndɔ, be seèn taré yuo. ");
INSERT INTO mcu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te bɔ̀ *Farisiên yeé nde ŋene njií ménâ, bɔ́ kem yuo kela gi cie, bɔ́ bɔ̀ nùàr *Herôde nde sòn nyɔgɔ, te bɔ́ wula sɔm Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yeésò fɔɔ́n gò ndɔ, bɔ́ bɔ̀ mbɔ̀ŋ seèn nde cu ké sòn tub Galilê. Bɔ̀ nùàr ŋgún né bú jomo kem bele: bɔ̀ déì né bɔ̀ Galilê bɔ̀, bɔ̀ déì yuoô Jerusalem ");
INSERT INTO mcu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mé te tàbè Judê sâ bèh hihiné. Bɔ̀ déì yuoô te tàbè Idumê bɔ̂ Jurdên kèb yágà, bɔ̀ déì lè lɔɔ́ hihinê kwarè Tîr bɔ̂ Sídɔ̀ŋ. Bɔ̀ nùàr hên dɔɔ́ŋ lé ŋgweé giì naâ njií mé Yeésò né yeé bɔɔ́, bɔ́ ndeè né bèh cî. ");
INSERT INTO mcu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeé baá ménâ, ye bɔ̀ mbɔ̀ŋ seèn a: «Bí wèh kwá mè kɔm ká kwarè, wanɔɔ́ŋ bɔ̀ nùàr nde aá mè baré wulá.» ");
INSERT INTO mcu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lòù sam, à né lom bɔ̀ nùàr taré sɔm dé gècên; bɔ̀ beén bɔ̀ dɔɔ́ŋ né ká yoòr seèn lege ndeê, ye te bɔ́ kema kwa bú kemà. ");
INSERT INTO mcu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bɔ̀ tándulu mé lé naá giì bú ŋené, suelé nde gi toò seèn, bɔ́ né ké ter tueé njií, ye bú a: «Ŋgweéh wò dé yeè né Ŋunà Càŋ mà.» ");
INSERT INTO mcu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","À né lom bɔ́ mé terreb luɔm, te bɔ́ ndègè seèn cie túé sɔ̀m cú. ");
INSERT INTO mcu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jomo sâ Yeésò ŋaá nde ké te tòre ndɔ. À yilá njií bɔ̀ nùàr ké yoòr seèn; lé naâ bɔ̀ɔ́ mé à né gwaân. Bɔ́ yeé waà baá, ");
INSERT INTO mcu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","à balé weh bɔ̀ yulà cùɔ̀b fà bɔ̀ déì teèn, te bɔ́ bɔ́ den beh, te à tema beh bɔ́, bɔ́ nde ŋgòr Càŋ se yɔŋ; ");
INSERT INTO mcu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","à haá bɔ́ terreb ndɔ te bɔ́ kwɔgɔ sɔm bele bɔ̀ nùàr càŋ tándulu yoòr. ");
INSERT INTO mcu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lé naâ Simɔ̂ŋ, ye yilí seèn déì baá cu Piêr ma. ");
INSERT INTO mcu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Déì né Jâk ŋunà Jebedê bɔ̂ dìm seèn Jâŋ; à yilá cu bɔ́ Boaneje, ye: bɔ́ né faá mbàn nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bɔ̀ déì né cu Andrê, Filîp, Bartelemî, Matíô, Tomâs, Jâk ŋunà Alfê, Tadê, mé Simɔ̂ŋ nuaá mé gwàn bèh dé mé bɔ̀ kìn den felè bɔ̀ lɔɔ́ bɔ̀ doô, ");
INSERT INTO mcu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mé Júdàs sàrnyé Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yeésò nde cu lɔ ndɔ. À yeé wa baá, bɔ̀ nùàr ŋgún bilí wa cuù, yɔgɔ́ bilí bɔ́ bɔ̀ mbɔ̀ŋ seèn mé yáb yieê mene. ");
INSERT INTO mcu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bɔ̀ nùàr seèn yeé ŋgweé aá ménâ, bɔ́ ndeè bú sie weh, ye: «À vera baá kèn.» ");
INSERT INTO mcu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bɔ̀ njí-sóù mé lé yuoó naâ ké Jerusalem ye: «À yila baá beè *Beljebu kèn. Mgbè bɔ̀ tándulù sâ haá né bú terreb kɔɔ́, à né bɔ̀ tándulu mé njéh kwɔgɔ́ den.» ");
INSERT INTO mcu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yeésò yilá njiî bɔ́ ká toò seèn ndɔ, à né bɔ́ njèh lè kàne tueé keéh, ye bɔ́ a: «Naàn naàn mé Sátàn nde né yo seèn nùà njèh kwɔgɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mè tueé bí, né mene lè lò mgbè dé heè, mɔ bɔ̀ nùàr né lètenè bɔɔ̀n kerré kuú, sâ lò sâ nde né ŋellé veé. ");
INSERT INTO mcu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Né mene te mbàgà dé heè ndɔ, mɔ bɔ̀ nùàr né lètenè bɔɔ̀n kerré kuú, sâ mbàgà hèllè nde né tɔb yuo. ");
INSERT INTO mcu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mɔ Sátàn hên lege kuú cu né mé yo seèn nùà njèh, te lò seèn kerré den hihiné, sâ terreb seèn toò ndé ndé ŋgwéh, nde né gií. ");
INSERT INTO mcu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Nuaré déì gwò nùà terrèb déì yílá kòmò ndé ŋgwéh, à ŋuɔb bú. Kɔ à nùà hèllè doó kaga si gi aá, à nde ye bú ŋuɔɔ́b. ");
INSERT INTO mcu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Mè tueé bí, nùàr a bɔ́ mene gèh veên dé heè, bú a: júé mene yilí Càŋ, Càŋ nde né dé sâ doó kulú njií. ");
INSERT INTO mcu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nuaá mé dé seèn jue seér né Cúcuí Ŋagâ, Càŋ veên seèn doó kúlú njí ndé ŋgwéh, veên bú yoòr gí ndé cú dé nyèmà mé nyèmà.» ");
INSERT INTO mcu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sâ bɔ́ la naâ tueé ye, Yeésò yoòr né seér mé càŋ tándulu. À bɔ́ ménâ tueé né dé cî. ");
INSERT INTO mcu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Meì Yeésò mé bɔ̀ dìm Yeésò waà ndɔ, bɔ́ njebá le yí cie, bɔ́ ye bɔ̀ nùàr a: «Yílá kêh béh Yeésò teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sâ nùàr ŋgún né kwarè seèn den kaáŋ yɔŋ, bɔ́ ye bú a: «Meí yeè bɔ́ bɔ̀ dìm yeè né yí cie, bɔ́ ye yílá kêh wò ma.» ");
INSERT INTO mcu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ye bɔ́ a: «Meí mò mé bɔ̀ dìm mò né bɔ̀ neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","À né bɔ̀ nùàr gwà dɔɔ́ŋ ke yɔŋ. À den cuù, ye bɔ́ a: «Meí mò mé bɔ̀ dìm mò né seér bɔ̀ hên bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bɔ̀ɔ́ mé né sòn Càŋ ŋgweé dɔɔ́ŋ, bɔ̀ meí mò, bɔ̀ dìm mò, bɔ̀ tie mò né bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeésò yila cu ŋgòr Càŋ ké sòn tub Galilê feèh. Cìlì nùàr ŋgún merré wa cuù, faŋ sie bú beè. Yeé baá yɔgɔ́, à nde ŋa den dé seèn yí dùà te kɔme, bɔ́ le ká cie sòn nòmò. ");
INSERT INTO mcu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","À lé bɔ́ njèh kókoó mbaá feh keéh giì naâ te kàne te kàne, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Bí ŋgwé! Nuaré déì lé ndeè naâ ké ŋueh bèh gèh vuû. ");
INSERT INTO mcu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","À yeé baá gèh vuú, kèb déì sue le ceér dueè. Bɔ̀ non waà gwaré yieé sɔm. ");
INSERT INTO mcu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kèb déì nde sue yila te kérré taâ, bèh sâ tàbè teèn màgà ŋgwéh. Ba yuoô wágácén ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lou yeé baá li, ŋema yuo cu. Lòù sam, bèh jɔgɔb yiî lé teèn ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kèb déì nde sue yila lètenè bɔ̀ ŋgobó deduanê, ba yuo ter. Yeé baá kulá, bɔ̀ ŋgobó deduanê hèllè lané wula sɔm bɔ́, bɔ́ tàb wá kwà cú. ");
INSERT INTO mcu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kèb déì nde dé seèn sue yila bèh tàbè bagaà, ba yuo kelà, kula, wa tàb: tab déì mvum teèn yulà tagár, tab déì yulà ténjén, déì yuií.» ");
INSERT INTO mcu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yeésò den cuù, ye bɔ́ a: «Nuaá né mé tie dé ŋgweê, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bɔ̀ nùàr yeé ŋellé gi aá, bɔ̀ɔ́ mé né kwarè seèn bɔ́ bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô bie bú bɔ̀ kàn sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","À ye bɔ́ a: «Dé biì, ŋgòr felè *Lò Càŋ mé Càŋ lɔ naâ lòù leér kwaá, né tieè biì. Dé bɔ̀ déì, kɔ bɔ́ né bɔ́ lè kàne ménâ si keéh, ");
INSERT INTO mcu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","te bɔ́ ke den dé keè, bɔ́ ŋéné cú; te bɔ́ felá den dé felâ, bɔ́ ŋgwé kɔ́ cú ndɔ. Mɔ sam, bɔ́ nde né temé kweh seér, Càŋ nde né veên bɔɔ̀n doó kulú njií.» ");
INSERT INTO mcu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeésò den cuù, ye bɔ́ a: «Bí kàn hên ŋgwé kɔ́ ŋgwéh wa? Sâ bí bɔ̀ déì ŋgweé kɔ nde né naàn wa? ");
INSERT INTO mcu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nùà vú-gèh né nuaá mé né ŋgòr Càŋ tueé. ");
INSERT INTO mcu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bɔ̀ nuaré déì né mapelîm mbaá faá kpɔŋ ceêr nɔ, gèh naá giì teèn sue. Bɔ́ yeé ŋgweé gi aá, tètèì sam, *Sátàn waà baá kèn, luaga sɔm cu bɔ́ lè. ");
INSERT INTO mcu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bɔ̀ déì kwa né dé bɔɔ̀n gèh faá bèh kérré taâ nɔ. Bɔ́ nde né ŋgòr Càŋ ŋgweé, bɔ́ gwaán nyegé mé vɔ́gɔ́-temé mene. ");
INSERT INTO mcu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Njèh cén, ŋgòr sâ jɔgɔb lè bɔɔ̀n yí ŋgwéh; bɔ́ gwaán lom né cuúr cén mbaá. Gèr sé yeé baá bɔ́ te ŋgòr Càŋe coró, bɔ̀ nùàr né bɔ́ mé njéh bunó, bɔ́ cuaré yuo wúwágá. ");
INSERT INTO mcu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bɔ̀ɔ́ mé né lètenè bɔ̀ ŋgobó deduanê sue yilá doô né bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, ");
INSERT INTO mcu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","njèh cén, bɔ́ né mé *wɔ́ŋ nyamé le, bɔ́ né te ŋgùlù wɔ́ŋe faá bɔ́ gwaán nê nɔ samé ndeé, bɔ̀ tuaá hihiné né mé bɔ́ bele ndeé ndɔ. Nde nde, bɔ̀ njèh hèllè karé wula sɔm njií ŋgòr Càŋ lè bɔɔ̀n, bɔ́ le cùr. ");
INSERT INTO mcu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bɔ̀ nuaré déì dé bɔɔ̀n né faá bɔ̀ gèh mé bɔ́ vuú né te tàbè bagaà nɔ. Bɔ̀ sâ bɔ̀ né ŋgòr Càŋ ŋgweé, bɔ́ né gwaán nyegé. Yeé baá ménâ, bɔ́ né tàb waá ndɔ; tab déì mvum teèn yulà tagár, tab déì yulà ténjén, déì yuií.» ");
INSERT INTO mcu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeésò den cuù ye bɔ́ a: «Mɔ bɔ́ mɔgɔ yilà baá mé lâm gwò, bɔ́ sulí kwaá seér nde né bú ka sɔɔ̀ wa? Bɔ́ nde né bú ka ndagâ sulí kwaá seér ndɔ wa? Ŋgweéh bɔ́ tuú njií nde né yí te súgo mà. ");
INSERT INTO mcu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mè tueé bí, bɔ̀ njií mé né bèh cibì dɔɔ́ŋ nde gi né cie ŋené le; bɔ̀ dé bèh lèrrèb ŋené yuo kela giì bèsɔ́nè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nuaá né mé tie dé ŋgweê, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","À den cuù, ye bɔ́ a: «Bí ŋgwé nyégé bɔ̀ njií mé bí né felá dɔɔ́ŋ bagasé. Bí kɔ́ɔ ye, mòù mé bí né bɔ̀ nùàr njèh teèn me haá dɔɔ́ŋ, Càŋ bí me haá cu nde né teèn, à haá sagá cu bí déì felèbɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nuaré déì nde gi né mé njèh beè, bɔ́ haá sagá cu bú déì teèn. Nuaré déì dé seèn mé njèh beè sam nde ŋgweéh, né mene dé maàn mé à né mé njéh dɔɔ́ŋ, bɔ́ nde né bú beè horó sɔm.» ");
INSERT INTO mcu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeésò den cuù, ye bɔ́ a: «*Lò Càŋ den né faá nùàr né gèh ké ŋueh vuú kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","À yeé vu kwaá baá, cíbíteèn à né lɔ́m cer, suútenè à né bèh seé seèn ndeé; gèh hèllè né jomo seèn kar, né noóm, nùà hèllè kèkènè dé sâ ŋgwé kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gèh bɔ̂ tàbè né ka bɔɔ̀n jueé den; à ba yuo kelà ndɔ, ŋa jìlì, velé sem, nde nde sie kèh. ");
INSERT INTO mcu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yeé ŋema gi aá, wulu dé kwaâ. Nùà ŋueèh doô kwaá sɔm ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeésò den cuù, ye bɔ́ a: «Béh Lò Càŋ me njií nde né mé kei wee? Den né faá kàn dé heè wa?» ");
INSERT INTO mcu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ye bɔ́ a: «Lò Càŋ den né faá mvum tàb làm nɔ. Mɔ bɔ́ baá bú dòù dobo yií, támbên lètenè bɔ̀ mvum dɔɔ́ŋ né bú. ");
INSERT INTO mcu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mɔ à kula baá, tàyàm lètenè bɔ̀ toû dɔɔ́ŋ né cu bú. Bɔ̀ béh seèn nde né bèh beè yaám sie; bɔ̀ non tieé beh fulu te yùm seène.» ");
INSERT INTO mcu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeésò lé bɔ̀ nùàr njèh kókoó feh giì naâ te kàne te kàne, faá bɔ̀ kàn dé hên nɔ. À lé si beéh bɔ́ dé mé bɔ́ nde né ŋgweé komo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","À ŋgòr déì lòù mbaá túé njí ŋgwéh, kɔ né lè kàne. Dé bɔ̀ mbɔ̀ŋ, mɔ bɔ́ baá léláŋ bɔɔ̀n, à né bɔ́ se gií. ");
INSERT INTO mcu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cu ka loù sâ liyilì, Yeésò ye bɔ̀ mbɔ̀ŋ seèn a: «Béh nde tub kèb yágà.» ");
INSERT INTO mcu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bɔ́ yuo kwaá lɔ cìlì nùàr ndɔ. Bɔ̀ mbɔ̀ŋ weh yuo mé bú te kɔm mé à né lè doô; sâ bɔ̀ kɔm déì né kwarè mân. ");
INSERT INTO mcu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wa beré déì, fu tarê kobo yilà dùà, né nòmò lè kɔme pieém njií den, kɔm baá yuú. ");
INSERT INTO mcu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sâ Yeésò baá ké jomo bɔɔ̀n lɔ́m, à né feh te kékèh cer kwaá den. Bɔ́ nyimé sɔm bú, bɔ́ ye bú a: «Nùà fèh-njèh, béh nde aá kum le, wò yúlá ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","À nyimé yuoô, à pam huné sɔm fu, ye nòmò a: «Húné nɔɔ́ŋ.» Fu hèllè nɔɔ́ŋ, pɔ́ŋ die dùà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","À ye bɔ̀ mbɔ̀ŋ a: «Bí veéh né dé keì wa? Bí temé mé mè kwá njí cú wa?» ");
INSERT INTO mcu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Veéh bɔɔ́ bɔ́ njèh. Bɔ́ né lètenè bɔɔ̀n bieé kuú ye: «Hên né neì, mé sòn seèn ŋgweé bilí né mé fu bɔ̂ nòmò mene wa?» ");
INSERT INTO mcu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bɔ́ wa yí sònò tuùb kèb yágà, te tàbè bɔ̀ Jerasénè bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yeésò suaga die doó. À yeé ke, nuaré déì yuoô ké màsou, baá ká yoòr seèn ndeê. Nùà hèllè lé naâ mé càŋ yoòr, ");
INSERT INTO mcu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","à lé cer beéh ké màsou ndɔ. Né mene mé yuií lɔ̀ŋ, nuaré déì lé bú kàgà kòmò ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sâ bɔ́ lé bú be kaga beéh lòù, bɔ́ yií bú fɔ̀gɔ̀ gulè ndɔ. Mé njéh mene, à lé naá beh tené sɔm. Nuaá mé nde né bú taré yɔgɔ́ sam. ");
INSERT INTO mcu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Suútenè mé cíbítenè mene à né ké lètenè bɔ̀ sà keéŋ sɔɔ́, mé te tòre mene ndɔ, à né yo mé taá tulú ŋerré. ");
INSERT INTO mcu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","À yeé nde ŋene njií Yeésò ké dàb mân, à sɔm doò, à dula ndeè ká toò seèn, à cemmé nde doó, ");
INSERT INTO mcu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","à né ké ter lɔgɔ́ njií, ye bú a: «Yeésò Ŋunà Càŋ terrèb, bélɔ̀ né lè keé-re wa? Mé yilí Càŋ, té mè gèr fèh.» ");
INSERT INTO mcu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sâ Yeésò la baá càŋ lè seèn paám, ye bú a: «Tándulu, yùò kélâ nùà hên lè nɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jomo sâ Yeésò ye bú a: «Yilí yeè né neì wa?» Ye Yeésò a: «Yilí nyî né Bilíbɔ́. Lòù sam, béh bilí den né lòù.» ");
INSERT INTO mcu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","À né Yeésò bɔŋ den, ye bú a: «Té béh te tàbè hên sɔ̀m.» ");
INSERT INTO mcu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sâ bɔ̀ŋ ŋguiâŋ né ké cueè tòr yieé den, bɔ́ né teèn ŋgún. ");
INSERT INTO mcu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bɔ̀ càŋ doô bɔŋ baá-re Yeésò, ye bú a: «Kwá béh nde yila den seér ké lè bɔ̀ ŋguiâŋ kíê.» ");
INSERT INTO mcu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeésò gwaán ndɔ. Bɔ́ durá yuo kela baá-re, bɔ́ nde yila nde lè bɔ̀ ŋguiâŋ hèllè. Bɔ̀ ŋguiáŋ kem suagà ké cueè, bɔ́ sue yila nde ké te tube. Bɔ́ lé naâ dɔɔ́ŋ kám fà. Bɔ́ kum le teèn. ");
INSERT INTO mcu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bɔ̀ tèŋ ŋguiâŋ durá yuo gi ndɔ; bɔ́ nde bɔ̀ nùàr ké lɔ mé kè kèbè mene tueé. Bɔ̀ nùàr né teèn kem ndeé, te bɔ́ nde ŋene mé njolo bɔɔ̀n ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bɔ́ yeé wa baá kwarè Yeésò, bɔ́ ŋene nuaá mé lé naâ mé tándulu yoòr doô, né doó den den, à su kwaá baá cɔ̀gɔ̀ yoòr, à taré yuo aá kèn. Veéh bɔɔ́ bɔ̀ nùàr njèh. ");
INSERT INTO mcu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bɔ̀ njií mé la kelà naâ felè nùà beên mé bɔ̀ ŋguiâŋ dɔɔ́ŋ, bɔ̀ɔ́ mé naâ ŋené, né bɔ̀ nùàr se nyegé. ");
INSERT INTO mcu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yeé baá ménâ, bɔ́ bɔŋ Yeésò, ye bú a: «Kúkùr yeè, yùò lè tàbè beèh yuoò.» ");
INSERT INTO mcu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yeésò yeé baá te kɔme yilá ndeé, nuaá mé la naâ mé càŋ yoòr doô bɔŋ bú, te bɔ́ bú nde. ");
INSERT INTO mcu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yeésò berɔ́ŋ ye bú a: «Ndé dèn sér á ké lɔ yeè, wò tueé bele bɔ̀ mbeí yeè njií mé Nùà Dueè la naâ felè yeè bɔɔ́ dɔɔ́ŋ, wò tueé bɔ́ jere mé à la naâ wò kɔɔ́ doô.» ");
INSERT INTO mcu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nùà hèllè fɔɔ́n gò ndɔ. Njií mé Yeésò naâ felè seèn bɔɔ́ keéh dɔɔ́ŋ, à né mé njéh lè lò Dèkàpòlî sâ saán ndeé. Bɔ̀ɔ́ mé lé naâ ŋgòr hên ŋgweé dɔɔ́ŋ geí laré gi. ");
INSERT INTO mcu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeésò yuo cuù kèb yágà te kɔme, à cu cuù kèb kân. Cìlì nùàr bilí wa cuù kwarè seèn ŋgún, sâ à né sòn nòmò njebá den. ");
INSERT INTO mcu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","À yeé ke, nùà koô *gwà sóù déì waà baá, yilí seèn né Jàrûs. À yeé nde ŋene njií Yeésò mân, à cemmé nde ka seèn, ");
INSERT INTO mcu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","à bɔŋ bú, ye bú a: «Huaán nyî dé vêh nde aá kuú dɔlé. Kúkùr yeè, ndê kèmà njí yeè bú be yoòr teèn, te à yili yuo, à kú cú.» ");
INSERT INTO mcu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeésò yuo bele bú ndɔ. Cìlì nùàr né Yeésò jomo kem bele, bɔ́ né lom bú dé barê baré ŋeí. ");
INSERT INTO mcu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sâ ma déì né doó sâ teèn; baá nyèmà yulà cùɔ̀b fà húɔ́m né bú yoòr yuo den. ");
INSERT INTO mcu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","À né bèh lèh dé kàn mé dé kân ndeé, à né gèr teèn mbaá ŋené kuú, kàgàlɔ̀ŋ né bú beè gií. Mé njéh mene, toò ndé ŋgwéh, à né seér gèr mé njéh lòù ŋené ŋeí. ");
INSERT INTO mcu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sâ ma hèllè lé naá baá njàgà Yeésò ŋgweé ndɔ. Yeé baá ménâ, à yila nde lètenè bɔ̀ nùàr, à ŋgoró nde yí jomo seèn, à kema weh cɔ̀gɔ̀ seèn. ");
INSERT INTO mcu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","À né ké lè tueé den ye: «Mɔ mè kema cegé mene léláŋ cɔ̀gɔ̀ seèn, nde né mè yili sɔm.» ");
INSERT INTO mcu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","À yeé baá kema, húɔ́m tené bú yoòr ndɔ. À ŋgweé kɔ ye nyí taré baá kèn. ");
INSERT INTO mcu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeésò ŋgweé kɔ yoòr dé seèn ndɔ, ye terreb nyî kèb déì naâ yuo. À bele seér lètenè bɔ̀ nùàr, ye: «Neì cɔ̀gɔ̀ nyî kema naâ kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bɔ̀ mbɔ̀ŋ seèn ye bú a: «Bɔ̀ nùàr baré sela baá ndɔ, wò ye neì nyí kemá naâ kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yeésò né ka kwarè seèn ke yɔŋ, ye te nyí ŋene nuaá mé la naâ nyí kema sâ. ");
INSERT INTO mcu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma doô yeé ŋgweé kɔ aá yoòr seèn ménâ, à ndelé ndeè mé veéh mene, à die nde ka Yeésò, à tueé komo bú gècên seèn dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeésò ye bú a: «Huaán mò, wò né lom temé cén yoòr mò kwaá njií, wò taré yuo aá kèn. Mvélé yùò teèn, ndé bá-re.» ");
INSERT INTO mcu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yeésò née seèn mé ma doô tueé den, tóm waà ndɔ, bɔ́ ye nùà koô doô a: «Ŋuna yeè kuú aá ma. Té yeè Nùà fèh-njèh mbaá kì kú cú.» ");
INSERT INTO mcu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeésò dé sâ táŋ ŋgwéh, à kɔ lom né nùà hèllè tueê, ye bú a: «Té vèh, kwá njí lòm ndèm mé mè.» ");
INSERT INTO mcu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","À gwàn cú dé nuaré déì bele bɔ́ jomo ndɔ, à weh lom aá Piêr mé Jâk bɔ̂ dìm seèn Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bɔ́ bɔ́ nde ké lɔ nùà koô gwà sóù doô. Bɔ́ wa ké teèn, bèmè né lom bɔgɔ́ faá cí nɔ, mbà né doó jɔgɔ́r ŋellé. ");
INSERT INTO mcu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","À yila nde yí gwò teèn, ye bɔ̀ nùàr a: «Gèh bèmè mé yúé mene hên né dé keì wa? Huaán njeré déì kú ŋgwéh, à cer né lɔ́m.» ");
INSERT INTO mcu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Te bɔ̀ nùàr yeé nde ŋgweé njií ménâ, bɔ́ kem sue bú yoòr mé séb. À sɔm keéh gi bɔ̀ nùàr cie ndɔ, à weh lom tele bɔ̂ meí mé bɔ̀ mbɔ̀ŋ seèn doô, bɔ́ bɔ́ yila nde ké mí yoòr huaân, ");
INSERT INTO mcu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","à sie njií bú be ter, à tueé bú mé ju bɔɔ̀n, ye bú a: «Tàlítà kúmì.» Sâ tueé né ye: «Huaán vêh, mè ye wò a, wùò ter.» ");
INSERT INTO mcu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Huaán doô komo wuo ter ndɔ, yila gò gɔɔ̀. Sâ à lé baá giì mé nyèmà yulà cùɔ̀b fà. Bɔ́ yeé nde ŋene njií mân, hiím laré bɔ́ doó dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeésò luɔm lom bɔ́ dé gècên ndɔ, ye bɔ́ a: «Càŋ a bɔ́ bí tueé nuaré déì. Bí há huaán yáb, à yieé.» ");
INSERT INTO mcu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeésò yuo bèh sâ ndɔ, à cu cu lè lɔɔ́ mé à lé kulà naâ teèn. Bɔ́ bɔ̀ mbɔ̀ŋ seèn lé naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yeé baá loù sóù, à yila nde ké *gwà sóù, à né bɔ̀ nùàr njèh teèn feh den. Bɔ̀ nùàr yeé ŋgweé aá, hiím gi bɔ́ doó dɔɔ́ŋ, bɔ́ ye: «À dé sâ kwaá naâ he wa? Hên né gèh kɔ́gɔ̀n kei mân, hên baá-re fém ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ŋgweéh hên né kób-toû ŋunà Marî doô wa? Ŋgweéh Jâk bɔ̂ Josês mé Jûde bɔ̂ Simɔ̂ŋ né gi bɔ̀ dìm seèn wa? Ŋgweéh lètenè beèh hên né gi bɔ̀ tie ndɔ wa?» Yeé baá ménâ, bɔ́ temé yoòr seèn kwá njí cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeésò deén baá-re, ye bɔ́ a: «Bèh dɔɔ́ŋ bɔ̀ nùàr né gi nuaá mé né *sòn-Càŋ veéh; sòn seèn ŋgeén seér yeé bɔ̀ lɔɔ́ bɔ̀ seèn, bɔ̀ nùàr seèn, né mene te mbàgà seèn, bɔ́ né yeé sòn seèn ŋgeén.» ");
INSERT INTO mcu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","À yeé ŋene bɔ́ temé teèn kwá njí ŋgwéh ménâ, à bèh fém bɔɔ́ keêh kwà cú ndɔ. Mé njéh mene, à kema taré sɔm cegé bɔ̀ beên bɔ̀ déì. ");
INSERT INTO mcu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Gèh temé mé bɔ̀ nùàr lé yoòr seèn kwá njí ná ŋgwêh sâ, lé naâ bú hiím yɔgɔ́. Jomo sâ Yeésò nde bèh ŋgòr Càŋ lelɔ feh bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","À yilá bilí bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô, à tema sɔm bɔ́ fèfà fèfà, à jege haá bɔ́ terreb te bɔ́ kwɔgɔ́ sɔm bele bɔ̀ nùàr càŋ tándulu yoòr, ");
INSERT INTO mcu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ye bɔ́ a: «Mɔ bí baá mé gò, bí té njeré déì beè wèh sìè, kɔ né cegé cùgò. Bí té yáb beè wèh sìè, né mene ba, né mene kàgàlɔ̀ŋ, bí té beè wèh sìè. ");
INSERT INTO mcu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bí yí lòm débágá, bí té cɔ̀gɔ̀ fà sù sìè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","À den cuù, ye bɔ́ a: «Mɔ bí wa baá lè lɔɔ́ déì, bɔ́ feh bí bèh cèrrè, bí dèn lòm gwò sâ, kɔ gò biì wulù baá, bí yuo ye. ");
INSERT INTO mcu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mɔ bí wa beré déì, bɔ́ bí wèh ŋgwéh, bɔ́ tie te ŋgòr biì félá njí ŋgwéh, bí yùò kwá lɔ́ bɔ́ nɔɔ́ŋ. Mɔ bí baá doó sâ yuo, bí kàrè sɔ̀m gí fùfú lɔɔ́ sâ gulè biì, te duɔɔ̂m bɔ́ toò tueé kwaâ.» ");
INSERT INTO mcu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bɔ̀ mbɔ̀ŋ fɔɔ́n gò ndɔ, bɔ́ né mé ŋgòr Càŋ se ndeé, ye bɔ̀ nùàr a: «Bí kwéh sér temé biì kweèh.» ");
INSERT INTO mcu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bɔ́ né nùàr ŋgún càŋ yoòr kwɔgɔ́ sɔm bele, bɔ́ né bɔ̀ beén bɔ̀ kókoó kómó bɔ, bɔ́ né bɔ́ mé njéh taré sɔm bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mgbè *Herôde ŋgweé njií njàgà Yeésò ndɔ. Lòù sam, ŋgɔ́g seèn lé baá bèh dɔɔ́ŋ ŋgulí ndeé. Sâ bɔ̀ déì lé ye: «Né Jâŋ Bàptîs dòù komo yuo cuù né kɔɔ́. À fém bɔɔ́ né mé terreb sâ.» ");
INSERT INTO mcu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bɔ̀ déì ye: «Né *Elî.» Bɔ̀ déì den cuù ye: «Né *sòn-Càŋ déì faá bɔ̀ sòn-Càŋ bɔ̀ dé léí toò nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herôde yeé ŋgweé aá ménâ, à sie lom aá dé seèn ye: «Né Jâŋ Bàptîs. Nyí lé naâ bú feh tená; à komo yuo cuù né dòù kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sâ Herôde lé seèn tueé naâ kɔɔ́, ye bɔ́ sìè kàgà njí Jâŋ gwà cibì. À lé bú môn bɔɔ́ kuú naâ felè Herodiâs, veèh Filîp dìm seèn. À lé naâ ma sâ gwò ŋgaá kwaá njií. ");
INSERT INTO mcu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sâ Jâŋ lé naâ bú teèn bèsɔ́nè tueé njií ndɔ, ye bú a: «Né jolo. Wò sé lé veèh dìm yeè gwò wèh kwá ná ŋgwêh!» ");
INSERT INTO mcu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yeé baá ménâ, Herodiâs sie kwaá lom aá Jâŋ lè, ye kɔ nyí bɔɔ́ wula sɔm aá bú ndɔ. Njèh cén, à lé lɔ́ŋ beè Herôde kwà ná ŋgwêh lòù. ");
INSERT INTO mcu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Lòù sam, Herôde lé naâ Jâŋ veéh, ye Jâŋ né lom nùà dilî, nùà gècên. À lé naá beéh Jâŋ cií ndɔ. Gwaán né mene bú ki, mé njéh mene ye kɔ nyí né tie te ŋgòr seèn felá njií. ");
INSERT INTO mcu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te cu sâ cieé mé bɔ́ lé ŋaár naâ bú teèn yɔŋ kwaré cu ndɔ. À yilá baá-re bɔ̀ nùàr, te bɔ́ nde teèn. À lé naâ bɔ̀ kokoô bɔ̀ seèn yilá, à yilá bɔ̀ kwaá-taâb, mé bɔ̀ kokoô bɔ̀ te tàbè Galilê mene, ye bɔ́ a, bɔ́ ndé gî teèn. Loù cieé koô sâ, Herodiâs kwa keéh baá-re lɔ́ŋ teèn. ");
INSERT INTO mcu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sâ ŋuna seèn dé vêh lé naâ bené ké gwò ŋgɔ. Yeé baá Herôde bɔ́ bɔ̀ nùàr yoòr huɔɔ́m, Herôde ye huaán a: «Njií mé wò né gwaán dɔɔ́ŋ, mɔ wò bie, mè nde né wò haá.» ");
INSERT INTO mcu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","À jege yií teèn ndɔ, ye bú a: «Né mene tàbè nyî, nyí nde né wò kèb déì kɔb haá.» ");
INSERT INTO mcu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Huaán vêh doô yuo kela ndɔ, nde ké yoòr meî, ye meí a, nyí júée bú a, há nyí kei wa? Meí ye bú a: «Júée bú a: há nyí feh Jâŋ Bàptîs ma.» ");
INSERT INTO mcu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Huaán doô ndɔr nde cu gè jomo yoòr mgbè, ye bú a: «Mè né feh Jâŋ Bàptîs te suúŋe kènê gwaán.» ");
INSERT INTO mcu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Te mgbè Herôde yeé nde ŋgweé njií mân, temé yili lom bú lè lég, à munó njií jègè mé à la naâ toò bɔ̀ nùàr jege doô, yɔgɔ́ bú dé berɔ̂ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","À yilá njiî sɔ́jì seèn cén déì ndɔ, ye bú a: «Ndé téná wèllè feh Jâŋ Bàptîs.» Sɔ́jì hèllè yuo ndɔ, nde ké gwà cibì, tena waà mé feh Jâŋ lè suúŋe, ");
INSERT INTO mcu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","haá njií mé huaán doô. Huaán doô nde mé meí haá njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bɔ̀ mbɔ̀ŋ Jâŋ yeé ŋgweé aá ménâ, bɔ́ nde furú njií kukuŋ dòù ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bɔ̀ mbɔ̀ŋ tebê cu cuù ndɔ, bɔ́ tueé Yeésò njií mé bɔ́ lé bɔɔ́ keéh naâ, mé bɔ́ lé feh keéh naâ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cu sâ nùàr ŋgún lé naâ waâ, bɔ̀ déì né ndeê, bɔ̀ déì né cuú. Né mene dé yáb yieê, Yeésò bɔ́ bɔ̀ mbɔ̀ŋ lɔ́ŋ kwà ŋgwéh. Yeé baá ménâ, ye bɔ̀ mbɔ̀ŋ seèn a: «Béh nde ser ké bèh ndɔ́ŋ-ndɔ̀ŋ, te bí ko weh teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bɔ́ yila kɔm ndɔ, bɔ́ fɔɔ́n gò, bɔ́ nde ké bèh ndɔ́ŋ-ndɔ̀ŋ léláŋ bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bɔ́ yeé baá ndeé, bɔ̀ nùàr kókoó mbaá lé naá giì bɔ́ ŋené kɔɔ́, bɔ́ né te lɔɔ́ dé kàn, mé dé kân kem yuoô, bɔ́ né teèn mé gule durá ndeé. Mé bɔ̀ Yeésò nde waá, sâ bɔ̀ nùàr baá gi cu doó. ");
INSERT INTO mcu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yeésò yeé suaga die aá doó, à ŋene njií cìlì nùàr né merré den. Jere bɔɔ́ bú njèh. Lòù sam, bɔ́ lé naâ faá bɔ̀ mbieè mé nùà njèh teèn sam nɔ. Yeé baá ménâ, à yila baá-re bɔ́ njèh feèh ndɔ, à feh lom bɔ́ njèh ŋgún. ");
INSERT INTO mcu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nde nde, lou yeé yuɔm aá, bɔ̀ mbɔ̀ŋ seèn ŋgoró nde kwarè seèn, bɔ́ ye bú a: «Cu nde aá kelá, bèh hên né ká jomo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wò sé la kwaá lɔ bɔ̀ nùà hên nde cu lelɔ yáb fɔɔ́n ŋge yieé.» ");
INSERT INTO mcu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yeésò ye bɔ́ a: «Bí há bɔ́ yáb kɔɔ́.» Bɔ́ ye bú a: «Wò ye béh ndé ŋgè há bɔ́ yáb lòù, te béh njèh kám yuií fà dɔɔ́ŋ weh ndeè né he wa?» ");
INSERT INTO mcu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","À den cuù, ye bɔ́ a: «Bí ndé jɔ̀gɔ̀ fɔ́n ke lètenè biì, bí né mé breêd beè meèn wa?» Bɔ́ yeé fɔɔ́n ŋene aá, bɔ́ ye bú a: «Beè beèh né breêd tîn mé ŋgò fà.» ");
INSERT INTO mcu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jomo sâ ye bɔ́ a: «Bí júée bɔ̀ nùàr a, dèn ndé gí doó te nyurè, bɔ́ dèn bílí mɔ̀gɔ̀ mɔ̀gɔ̀ ma.» ");
INSERT INTO mcu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bɔ̀ nùàr den nde doó ndɔ, bɔ̀ mɔ̀gɔ̀ déì mé nùàr teèn yuií, bɔ̀ déì yulà títîn. ");
INSERT INTO mcu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bɔ́ yeé den gi aá, Yeésò weh breêd tîn mé ŋgò fà doô, à ke njií njolo ké te vulúu, à dua Càŋ teèn, à kɔlé haá njií breêd mé bɔ̀ mbɔ̀ŋ, te bɔ́ geé haá bele bɔ̀ nùàr. À geé yɔŋ cu bɔ̀ ŋgò fà doô lètenè bɔɔ̀n dɔɔ́ŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nùàr dɔɔ́ŋ yieé fulu gi; ");
INSERT INTO mcu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ndilí le, breêd mene, ŋgò mene. Bɔ̀ mbɔ̀ŋ ŋuaán bilí, yuú sɔgɔ́ yulà cùɔ̀b fà. ");
INSERT INTO mcu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sâ lètenè bɔ̀ nùàr mé lé naâ yieé dɔɔ́ŋ, bɔ́ kula weh cegé né bɔ̀ siíb kám tîn. ");
INSERT INTO mcu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dèn sɔ́ ŋgwéh, Yeésò kou yií njií bɔ̀ mbɔ̀ŋ seèn lè kɔme, te bɔ́ sela kela toò, bɔ́ nde kela den bú yí Becaida; à le ŋgɔgɔ̂ dé seèn ká jomo, te à sɔm gi bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bɔ̀ nùàr yeé yuo gi aá, à ŋaá nde dé seèn ké te tòre bèh Càŋ duaà. ");
INSERT INTO mcu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cibí yili lɔ bú ké teèn. Sâ bɔ̀ mbɔ̀ŋ baá gi mé kɔm ké lètenè nòmò. À ká cie le lom aá mé huún. ");
INSERT INTO mcu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","À yeé ke, bɔ́ bɔ̀ fu tarê baá ké dùà kwaré, bɔ́ né gèr mé njéh ŋené, bɔ́ né mene kɔgɔ́, kɔm ndé kòmò cú. Nde nde, yeé baá mé be lɔ̂m nèà, à nde ké yoòr bɔɔ̀n ndɔ, à dé seèn gɔ nde seér felè nòmò felè nòmò, ye te nyí kela keéh bɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Te bɔ́ yeé nde ŋene njií, à baá felè nòmò gɔ ndeé ménâ, bɔ́ sɔm kéŋ, ye merré déì né càŋ tándulu. ");
INSERT INTO mcu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Lòù sam, bɔ́ lé naá giì bú dɔɔ́ŋ ŋené laré, veéh lé naâ bɔ́ njèh bɔɔ́ ndɔ. Tètèì sam, ye bɔ́ a: «Bí sìè temé, né mè; bí té vèh.» ");
INSERT INTO mcu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","À ŋaá yila nde yí te kɔme yoòr bɔɔ̀n; fu hèllè pɔ́ŋ ndɔ. Geí su njií bɔ̀ mbɔ̀ŋ doó. ");
INSERT INTO mcu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Lòù sam, bɔ́ lè né mé temé macùr; fém mé Yeésò lé naâ mé breêd bɔɔ́ doô, bɔ́ lé ŋgwé kòmò ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bɔ́ nde sela yuo kela tub kèb yágà. Bɔ́ wa te tàbè Jenesarétè, bɔ́ colo lɔ kɔm sònò nòmò. ");
INSERT INTO mcu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bɔ́ yeé suaga die aá doó, bɔ̀ nùàr ŋene kɔ cu Yeésò, ");
INSERT INTO mcu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bɔ́ durá nde bɔ̀ nùàr te tàbè sâ dɔɔ́ŋ tueé bele. Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ jɔgɔ wa belê mé bɔ̀ beên bɔ̀ te tèb-e. Bèh mé Yeésò né teèn dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","né mene te lɔɔ́ maàn, né mene te lɔɔ́ koô, né mene kè kèbè dɔɔ́ŋ, bɔ́ né mé bɔ̀ beên bɔ̀ teèn jɔgɔ́ ndeé, bɔ́ né bɔ́ ké mbartɔgɔ̂ jɔgɔ́ njií, bɔ́ né bú bɔŋ, ye bú a: «Mɔ bɔ̀ beén bɔ̀ kema weh cegé mene léláŋ sòn cɔ̀gɔ̀ yeè, bɔ́ nde né taré.» Bɔ̀ɔ́ mé lé naá belê kema dɔɔ́ŋ lé naá giì taré yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bɔ̀ *Farisiên mé bɔ̀ *njí-sóù déì yuoô ké Jerusalem, bɔ́ bilí ndeè ká kwarè Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Waà ká toò, bɔ́ ŋene, ye bɔ̀ mbɔ̀ŋ seèn déì né yáb yieé, bɔ́ be faá tabɔ́ né tueé nɔ yàgà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sâ bɔ̀ Farisiên mé bɔ̀ *Jûf déì né yeé dé bɔɔ̀n tabɔ́ jolo: mɔ bɔ́ be faá tabɔ́ né tueé nɔ yàgà ŋgwéh, bɔ́ yáb yíé bèh. ");
INSERT INTO mcu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mɔ bɔ́ cuù baá tan, kɔ bɔ́ yaga kellé gi aá yo, bɔ́ yieé ye yáb. Bɔ́ né cu tòù hihiné faá tabɔ́ tueé nê nɔ jolo ndɔ: gèh dé mé bɔ́ yaga yeé njèh mé njéh, né mene bɔ̀ ŋgàb, né mene bɔgɔ, né mene sɔɔ̀, né mene ndagá, bɔ́ né gi jolo. ");
INSERT INTO mcu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bɔ̀ Farisiên mé bɔ̀ njí-sóù hèllè yeé nde ŋene njií bɔ̀ mbɔ̀ŋ Yeésò né tabɔ́ ménâ kwaá, bɔ́ bie njií baá-re Yeésò ndɔ, ye bú a: «Bɔɔ́ né naàn mé bɔ̀ mbɔ̀ŋ yeè tabɔ́ bèlè ŋgwéh, bɔ́ né yáb mé be yilî yieé wa?» ");
INSERT INTO mcu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeésò deên ndɔ, ye bɔ́ a: «Esáyà lɔ jueè bɔ̀n, ye bí né bɔ̀ sòn fà bɔ̀! À yeé baá sòn-Càŋ tueé, à nyagá kwaá te mvù ménâ ndɔ, ye: Càŋ ye: Bɔ̀ nùà hên nyí seén kuú den né mé par sòn mbaá, temé bɔɔ̀n né bèh hiîn. ");
INSERT INTO mcu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Den né faá bɔ́ né nyí dua nɔ, sâ né dé lòù; bɔ́ kwaá lɔɔ̀ né tòù nyî, bɔ́ feh seér tòù bɔ̀ tele bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeésò den cuù, ye bɔ́ a: «Wanɔɔ́ŋ bí né tòù Càŋ kwaá lɔɔ́, bí feh seér tòù bɔ̀ tele biì nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yeésò den cuù baá-re, ye bɔ́ a: «Dé tòù Càŋ, bí né lom bú doó si njií kɔɔ́ dé gècên, te bí bele nyegé tòù biì. ");
INSERT INTO mcu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sâ Músì né gi tueé ye: Léb toò tele mé meí yeè, wò ŋgweé sòn bɔɔ̀n. À né cu tueé, ye nuaá mé duagá tele, wa né meí wa, bú a, kú táré lè teèn ŋgwán. ");
INSERT INTO mcu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mé njéh mene, bí ménâ fèh bèh. Bí den seér cu né ye: Mɔ nuaré déì tueé njií mé tele, wa mé meí wa, ye bú a: nyí sé la naâ wò gam; njèh cén, baá gi *sèmè, (sâ tueé né ye: baá gi dé Càŋ), ");
INSERT INTO mcu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","à né mene môn tueé seér, bɔɔ́ né naàn mé bí ye né baga wa? Ŋgweéh sâ bí ye bú a: Té tele mbaá gàm kú cú mà. ");
INSERT INTO mcu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ŋgweéh bí sâ bɔɔ́ ŋellé né ŋgòr Càŋ, te bí feh keéh tòù lɔɔ̂ biì wa? Bí né ménâ bɔɔ́, bí né cu mé bɔ̀ tòù ŋgún ménâ feh ndeé den.» ");
INSERT INTO mcu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jomo sâ Yeésò yilá bilí bɔ̀ nùàr ndɔ, ye bɔ́ a: «Bí dɔɔ́ŋ, bí ndɔ̀gɔ̀ gí tie, te bí ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mè tueé bí, njií mé yuo yeé kèb cieè, yila seér lè nùàr lòù, bú kɔɔ́ bɔ́ yílí bèh. Né seér dé mé yuo né ké lè te temê bɔɔ́ yili né nùàr kɔɔ́.  ");
INSERT INTO mcu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nuaá né mé tie, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yeésò yeé kwaá lɔ aá bɔ̀ nùàr, à baá ké gwò, bɔ̀ mbɔ̀ŋ seèn bie bú kàn sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","À ye bɔ́ a: «Mé bí mene, bí ŋgwé kòmò ŋgwéh ndɔ wa? Bí née kɔ́ ŋgwéeh ye: njií mé yuo yeé kèb cieè, yila lè nùàr lòù, bú kɔɔ́ bɔ́ yílí ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Lòù sam, dé sâ temé kèmà bèh, bele lom né tɔŋ, yuo kela nde ké cie.» Mé kàn hên, sâ Yeésò tueé lɔgɔ́ baá kèn, ye yáb dɔɔ́ŋ né gi dé yieê ma. ");
INSERT INTO mcu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","À deén baá-re, ye bɔ́ a: «Bí kɔ́ɔ ye, njií mé yuo yeé lè nùàr bɔɔ́ yili seér né nùàr kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lòù sam, mùnò veên dɔɔ́ŋ jeré yuo den né te temé nùàr: sár yɔɔ̀ŋ né sâ; yíb né teèn sâ, wúlá-feh né sâ; yàgà ndeê né teèn; ");
INSERT INTO mcu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","temé te njèh nùàre kwaá njiî né sâ; jélá-temé né sâ; nùàr beleè né sâ; tándabé né sâ; sà né teèn sâ; súí né sâ; hàm feh ceré né teèn mé kùlù mene, ");
INSERT INTO mcu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","dɔɔ́ŋ yuo giì né te temê, bɔ́ nùàr bɔɔ́ yili yeé kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jomo sâ, Yeésò yuo doó sâ ndɔ, à nde ser kwarè lɔɔ́ Tîr, à yila nde lè gwà déì, ye te nuaré déì kɔ́ cú ye nyí waà baá. Mé njéh mene, à lèr kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dèn sɔ́ ŋgwéh, ma déì ŋgweé ŋgɔ́g seèn, à waà, à cemmé nde doó toò seèn. Sâ ŋuna seèn dé vêh lé naâ mé tándulu yoòr. ");
INSERT INTO mcu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bú nùà njèh lé naâ nùà kìn, bɔ́ lé ŋaár naâ bú ké Fenisî te tàbè Sirî. À yeé cemmé nde aá doó, ye Yeésò a: «Kúkùr yeè, ndê kwɔ́gɔ́ sɔ̀m yeè huaán nyî càŋ yoòr teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeésò den seêr, ye bú a: «Kwá mè jɔ̀gɔ̀ koó lɔgɔ̂ bɔ̀ huaán lɔɔ̂ ye. Mɔ bɔ́ si njií yáb bɔ̀ huaân mé boór, húɔ́m ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma doô gwaán ndɔ, ye Yeésò a: «Né ka môn jég, dé koô. Á sâ, bɔ̀ boór domó yieé yeé tòmò yâb ka bɔ̀ huaân ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeésò deén baá-re, ye bú a: «Môn, mé ŋgòr yeè hên, ndé á yeè lɔ. Tándulu yuo aá ŋuna yeè yoòr kèn.» ");
INSERT INTO mcu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma doô cu cu lɔ ndɔ. À wa, sâ ŋuna baá te ndagáa cer den; càŋ bú yoòr yuo aá kèn. ");
INSERT INTO mcu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jomo sâ Yeésò yuo te tàbè Tîr ndɔ, à kela seér ké Sídɔ̀ŋ, à cu cu seêr te lò Dèkàpòlî lòù, ye te nyí yuo kelà te tub Galilê. ");
INSERT INTO mcu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bɔ́ weh waà bú mé nuaré déì ndɔ, tie né ndúg, sòn né tácobó. Bɔ́ ye bú a: «Kúkùr yeè kèmà njí yeè bú be yoòr teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeésò weh nde mé bú ké bèh ndɔ́ŋ-ndɔ̀ŋ, à fagá yií bú nyɔ̀gɔ̀ beè tieè. Jomo sâ à kulu kwaá dèh te nyɔ̀gɔ̀ beè, à kema njií bú te leba, ");
INSERT INTO mcu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","à ke njií njolo ké te vulúu, à homo, ye nùàrè a: «Efátà.» Sâ tueé né ye: «Lélɔgɔ̀!» ");
INSERT INTO mcu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tie fuŋ, leba weh yuo ter, nùà hèllè yila keéh sòn tueê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeé baá ménâ, Yeésò luɔm bɔ̀ nùàr, ye bɔ́ a: «Càŋ a bɔ́ bí tueé nuaré déì.» À né mene bɔ́ dé luɔɔ̀m luɔm, bɔ́ né dé tueê tueé ŋeí. ");
INSERT INTO mcu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gèh fém dé sâ lé naâ bɔ́ geí yɔgɔ́ dé gècên. Bɔ́ né lom tueé ye: «Seé seèn dɔɔ́ŋ né lom seé gècên! Né mene bɔ̀ tándúg, à né bɔ́ taré sɔm; bɔ́ ŋgweé cu tie, bɔ́ tueé sòn.» ");
INSERT INTO mcu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Cu sâ bɔ̀ nùàr kókoó mbaá bilí wa cuù. Bɔ́ yeé mé yáb beè sam cuú, Yeésò yilá njiî bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Jere né mè mé bɔ̀ nùà hên sie: kè kú lan baá cieé tagár, béh bɔ́ né lom kɔɔ́; bɔ́ mé yáb beè sam cuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mɔ mè yi njií bɔ́ lɔ mé lèì cùè, bɔ́ nde né ceér dueè die le; lòù sam, bɔ̀ déì yuoó naâ bèh dàb.» ");
INSERT INTO mcu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bɔ̀ mbɔ̀ŋ ye bú a: «Béh yáb ká ya dueè hên kwa caá nde né he, te béh koó laré bɔ́ mé njéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeésò ye bɔ́ a: «Bí beè né mé breêd meèn wa?» Bɔ́ ye bú a: «Né téhbeh.» ");
INSERT INTO mcu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yeésò ye bɔ̀ nùàr a: «Bí dèn ndé gí doó.» Jomo sâ à weh breêd téhbeh doô, à vra Càŋ teèn, à kɔlé haá njií bɔ̀ mbɔ̀ŋ, te bɔ́ geé haá bɔ̀ nùàr. Bɔ́ geé haá gi bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bɔ́ lé naá cuù mé ŋgò déì tetegér mân beè teèn. Yeésò weh, à dua Càŋ teèn, ye bɔ̀ mbɔ̀ŋ a: «Gè há cú bɔ́.» Bɔ́ geé haá gi bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bɔ́ yieé fulu gi; ndilí le. Bɔ̀ mbɔ̀ŋ ŋuaán bilí, yuú sɔgɔ́ téhbeh. ");
INSERT INTO mcu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bɔ̀ɔ́ mé lé yieé naâ yáb sâ dɔɔ́ŋ lé naâ kám nèà. ");
INSERT INTO mcu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bɔ́ yeé yieé gi aá, Yeésò yi njií ye bɔ́, à nde dé seèn kɔm yilá. Bɔ́ bɔ̀ mbɔ̀ŋ fɔɔ́n gò, bɔ́ nde te tàbè Dalemanútà. ");
INSERT INTO mcu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bɔ̀ *Farisiên waà ndɔ, bɔ́ duɔɔ́m Yeésò sòn fɔɔ̂n, te bɔ́ sie bú teèn. Bɔ́ ye bú a: «Jɔ̀gɔ̀ bɔ́ ke fém déì mé feh keéh né ye wò bɔɔ́ né seé mé terreb Càŋ ye.» ");
INSERT INTO mcu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Homo yɔgɔ́ Yeésò dé tueê, à den cuù ye bɔ́ a: «Bɔɔ́ né naàn mé bɔ̀ cafanê bɔ̀ ye: kɔ bɔ́ ŋene fém wa? Mè né tueé ye bí a, ndɔ́g bɔ́ ŋéné ndé cú!» ");
INSERT INTO mcu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jomo sâ à fɔɔ́n gò seèn, à yila cu kɔme, à sela nde tub kèb yágà. ");
INSERT INTO mcu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sâ bɔ̀ mbɔ̀ŋ lé naâ breêd nyen lɔɔ́; lè kɔɔ̀m lé gi cegé naâ breêd cén. ");
INSERT INTO mcu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeésò yeé baá bɔ́ luɔm, bɔ́ munó seér cí. Sâ à lé ye bɔ́ a: «Bí bɔ̀ŋ feh biì mé kulu bɔ̀ Farisiên, bí bɔŋ feh mé kulu Herôde.» ");
INSERT INTO mcu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bɔ̀ mbɔ̀ŋ duɔɔ́m baá-re lètenè bɔɔ̀n tueé kuû, ye: «À jue né breêd mé béh mé njéh beè sam doô.» ");
INSERT INTO mcu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeésò yeé ŋene aá ménâ, ye bɔ́ a: «Bí môn tueé den né dé keì, ye: mè jue né breêd mé bí mé njéh beè sam doô wa? Hên bí née ka njèh ŋgwé kòmò ŋgwéeh ye wa? Feh biì née ka ter ndegé den á? ");
INSERT INTO mcu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bí né gi mé njolo; dé ŋenê sam wa? Bí né gi mé tie; dé ŋgweê sam ndɔ wa? Bí mùnò kɔ́ cú, ");
INSERT INTO mcu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ye mè lé naâ breêd tîn kɔlé, koó bɔ̀ nùàr kám tîn mà. Bɔ̀ sɔgɔ́ ndilí yâb mé bí lé jɔgɔ́ sɔɔ́m naâ doô lé naâ meèn?» Bɔ́ ye bú a: «Lé naâ yulà cùɔ̀b fà.» ");
INSERT INTO mcu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","À den cuù, ye bɔ́ a: «Mè yeé kɔlé cu aá breêd téhbeh, te koó nùàr kám nèà, sɔgɔ́ ndilí yâb lé naá cuù meèn ndɔ wa?» Bɔ́ ye bú a: «Téhbeh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","À deén baá-re ye bɔ́ a: «Wa mene hên, bí née ŋgwé kòmò ŋgwéeh ye wa?» ");
INSERT INTO mcu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wa ké Becaida, bɔ̀ nùàr weh wa cuù mé tácugó déì toò seèn, bɔ́ ye bú a: «Kúkùr yeè, kèmà njí yeè bú be yoòr teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeésò sie weh tácugó doô be, weh nde mé bú ké jomo lɔɔ̂. Wa ké teèn, à kulu kwaá bú dèh njolò, à kema bú mé be, ye bú a: «Wò baá njeré déì ŋené wa?» ");
INSERT INTO mcu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tácugó sɔm njií njolo ter, ye bú a: «Mè baá bɔ̀ nùàr ŋené; bɔ́ den né faá toú nɔ. Njèh cén, bɔ́ gɔ seér né lòù.» ");
INSERT INTO mcu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeésò kema njií cu bú be njolò. Kènê tácugó ke njege njií lom aá ké toò seèn, à taré yuo, à ŋene ŋagá gi njèh dɔɔ́ŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeésò ye bú a: «Ndé lòm á lɔ yeè, té lètenè lɔɔ̂ kélá cú.» ");
INSERT INTO mcu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jomo sâ Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn fɔɔ́n gò, bɔ́ nde ser te bɔ̀ lɔɔ́ déì te tàbè Sesarê Filîp. Bɔ́ yeé baá ceér dueè, à bie ye bɔ́ a: «Bɔ̀ nùàr ye mè né neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bɔ́ ye bú a: «Bɔ̀ déì ye wò né Jâŋ Bàptîs, bɔ̀ déì ye wò né *Elî, bɔ̀ déì ye wò né *sòn-Càŋ cén déì.» ");
INSERT INTO mcu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ye bɔ́ a: «Á bí nɔ, bí ye mè né neì wa?» Piêr ye bú a: «Wò né *Nùà Cɔ̀ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeésò luɔm bɔ́ ndɔ, ye bɔ́ a: «Càŋ a bɔ́ bí tueé nuaré déì ménâ.» ");
INSERT INTO mcu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jomo sâ à yila bɔ̀ mbɔ̀ŋ seèn njèh feèh ndɔ, ye bɔ́ a: «Kɔ *Huaán Nùàr nde dàm bɔ̀ gèr ŋené laré. Bɔ̀ kokoô bɔ̀ lɔɔ̂, bɔ́ bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù dɔɔ́ŋ nde gi né bú ŋgɔɔ́n, te bɔ́ wula sɔm bú. Lè cieé tagáre à nde cu né lè cio komo yuo ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","À lé bɔ́ dé sâ tueé ŋagá loóm naâ bèsɔ́nè. Piêr yeé nde ŋgweé njií ménâ, à weh nde mé bú ké bèh ndɔ́ŋ-ndɔ̀ŋ, à yila bú teèn ndeè. ");
INSERT INTO mcu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeésò bele seér ndɔ, ke njií bɔ̀ mbɔ̀ŋ seèn, pam Piêr, ye bú a: «Máb *Sátàn, cú yo nɔɔ́ŋ! Wò faá Càŋ nɔ mùnò ŋgwéh, wò munó seér né faá bɔ̀ nùàr nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","À yilá njiî bɔ̀ nùàr mé bɔ̀ mbɔ̀ŋ seèn ndɔ, ye bɔ́ a: «Nuaá mé ye nyí gwaán né jomo mò beleè dɔɔ́ŋ, kɔ à ŋgɔn feh seèn, à nde mbin weh toú gèr seèn, à bele mè, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mè tueé bí: nuaá mé gwaán né yɔ̀ŋ seèn mé feh seèn yili sɔm, nde né bú leér lɔɔ́. Nuaá mé né dé seèn cio felè mò ŋgɔɔ́n seér, né mé Njàgà Bagaà beè kuú, nde né yɔ̀ŋ seèn yili sɔm. ");
INSERT INTO mcu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Njií mé gam nde né nuaá mé né njèh ká lè wɔ́ŋe dɔɔ́ŋ kwa laré te yɔ̀ŋ seèn leér le teèn, né kei wa? ");
INSERT INTO mcu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Njií mé nùàr nde né yɔ̀ŋ seèn mé njéh ŋaá sɔm né teèn wa? Ndɔ́g teèn sam. ");
INSERT INTO mcu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","«Sâ lètenè bɔ̀ cafanê bɔ̀ mé né veên bɔɔ́, mé temé yoòr Càŋ kwá njí cú, mɔ nuaré déì né mè teèn yaáŋ, à né ŋgòr mò yaáŋ, loù mé mè Huaán Nùàr cuù nde né teèn, mè *sum waà nde né lètenè bɔ̀ cìlì Càŋ, mé terreb Tele mò yoòr, loù sâ mè nde né nùà hèllè yaáŋ sɔm ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeésò den cuù, ye bɔ́ a: «Mè né tueé ye bí a, mé bí nde dɔɔ́ŋ kuú gií, sâ *Lò Càŋ mé terreb seèn mene ŋené yuo kelà baá cie, bɔ̀ déì lètenè biì hên ŋene mé njolo.» ");
INSERT INTO mcu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yeé kela baá cieé ténjén, mé téhbeh Yeésò weh Piêr bɔ̂ Jâk mé Jâŋ, bɔ́ bɔ́ ŋaá nde ké felè tòr mé huún bɔɔ̀n. Wa ké teèn, Yeésò kweéh seér yo njolò bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bɔ̀ cɔ̀gɔ̀ yoòr seèn ŋa seér bɔ̀ dé wuwulê, wula ŋuerré seér dé ŋuerrê, gèh wulâ dé sâ ká doó dɔɔ́ŋ, nuaá mé nde né bú bɔɔ́ komo teèn sam. ");
INSERT INTO mcu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bɔ̀ nuaré déì kar yuo kelà toò bɔɔ̀n ndɔ. Lé naâ *Elî bɔ̂ Músì. Bɔ́ bɔ̀ Yeésò né sòn tueé den. ");
INSERT INTO mcu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piêr ye Yeésò a: «Nùà fèh-njèh, kwá béh den le kɔ hên, béh sie pàgà tagár, dé yeè cén, dé Músì cén, dé Elî cén ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sâ Piêr tueé nderré weh né mbaá, veéh né bɔ́ njèh bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jomo sâ bègè déì suagà ter, ka sie bɔ́ beè. Hueh déì né yí lètenè-bɔ̀ ŋgulí den, ye: «Hên né Huaán yíé-temé mò; bí ŋgwé gí sòn seèn.» ");
INSERT INTO mcu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bɔ̀ mbɔ̀ŋ yeé ke cu, bɔ́ nuaré déì teèn ŋéné cú, le lom aá Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bɔ́ yeé baá ké te tòre suagá cuû, Yeésò luɔm bɔ́, ye bɔ́ a: «Càŋ a bɔ́ bí tueé nuaré déì njií mé bí ŋenè naâ hên. Bí kwá lɔ́ lè biì, kɔ loù mé *Huaán Nùàr komo yuo aá lè cio, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bɔ́ ŋgweé sòn seèn ndɔ. Mé njéh mene, bɔ́ né lètenè bɔɔ̀n bieé kuú, ye: «À ye nyí nde né te cio komo yuo; sâ ye naàn?» ");
INSERT INTO mcu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jomo sâ bɔ́ ye bú a: «Bɔ̀ *njí-sóù tueé né dé keì, ye Elî wa lɔgɔ́ ndeè né kɔɔ́ mé Nùà Cɔ̀ŋ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ye bɔ́ a: «Né bɔ̀n! Elî ndeè né kɔɔ́ waá lɔgɔ̂, te à sie nyegé cu bɔ̀ njèh dɔɔ́ŋ. Á, dé mé bɔ́ nyagá kwaá né te mvù Càŋe, ye né môn, Huaán Nùàr nde né gèr kókoó ŋené, wa bɔ́ nde né bú seb ndɔ nɔ? ");
INSERT INTO mcu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mé njéh mene, mè tueé bí, Elî lé naá giì waâ, bɔ̀ nùàr bú sie seér cu faá bɔ́ gwaán nê nɔ. Ŋgweéh sâ né faá bɔ́ lɔ naâ felè seèn te mvù Càŋe nyagá kwaá mà.» ");
INSERT INTO mcu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bɔ́ wa ké kwarè bɔ̀ mbɔ̀ŋ seèn déì, bɔ́ ŋene cìlì nùàr né kwarè bɔɔ̀n kaáŋ den. Bɔ́ bɔ̀ *njí-sóù né njèh saán den ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bɔ̀ nùàr yeé nde ŋene njií Yeésò mân, geí yɔgɔ́ bɔ́ mbaá. Bɔ́ sɔm doò, bɔ́ nde bú kwa weh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","À ye bɔ̀ mbɔ̀ŋ seèn a: «Bí bɔ̀ njí-sóù saán den né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nuaré déì deên yí lètenè bɔ̀ nùàr, ye bú a: «Nùà fèh-njèh, mè la weh ndeè naâ wò mé huaán mò; à né mé càŋ yoòr, né bú sòn sie huné. ");
INSERT INTO mcu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mɔ baá bú ŋaâ, né yeé bú doó jɔgɔ́ si, fuú né bú sònò yuo, à né nyie yieé, à né nab ndɔ. Mè la naâ bɔ̀ mbɔ̀ŋ yeè dua, te bɔ́ kwɔgɔ sɔm bú, né bɔ́ taré yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeésò deên ndɔ, ye bɔ́ a: «Jue ka bí bɔ̀ dúágá-tie bɔ̀! Hên béh bí née cu-re heèh wa? Mè bí seŋ den cu nde né heèh ndɔ wa? Wèh ndê mé huaán sâ kán.» ");
INSERT INTO mcu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bɔ́ weh ndeè mé huaán ká yoòr seèn ndɔ. Càŋ doô yeé nde ŋene njií Yeésò mân, à jilí komo si huaán hèllè doó mé terreb. Huaán né mé fuú sònò teré seér. ");
INSERT INTO mcu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeésò ye tele a: «Lé bú mân bɔɔ́ duɔɔ́m naâ heèh wa?» Tele ye bú a: «Lé naâ sâ à née huaán maàn ye. ");
INSERT INTO mcu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Né yeé bú tuar jɔgɔ́ si, jɔgɔ si cu bú dùà, ye te nyí wula bú. Mɔ wò nde né bɔɔ́ komo, kɔ́ yeè béh jere, wò gam béh teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeésò deên ndɔ, ye bú a: «Wò ye: mɔ mè nde né bɔɔ́ komo sé wa? Mɔ nùàr né temé cén yoòr Càŋ kwaá njií, dɔɔ́ŋ nde gi né bɔɔ́ komo.» ");
INSERT INTO mcu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tele huaân doô lɔgɔ njií ké ter ndɔ, ye bú a: «Mè né gi temé kwaá njií dág. Njèh cén, mè dɔɔ́ŋ kwá kòmò bèh; gàm yeè mè teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeésò yeé ŋene bɔ̀ nùàr baá ká yoòr bɔɔ̀n kem ndeê, à pam njií càŋ hèllè ndɔ, ye bú a: «Wò tándulu mé né nùàr sòn mé tie duagá hên, mè jue né wò, yùò kélà lè huaán hên nɔɔ́ŋ. Càŋ a bɔ́ wò yila ŋgweé cu teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Càŋ doô sɔm kéŋ ndɔ, jilí komo si huaán hèllè doó mé terreb, yuo kela sa. Huaán doô den lom faá komó nɔ. Bɔ̀ nùàr lé naá giì tueé ye: à kuú né lòù. ");
INSERT INTO mcu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yeé baá ménâ, Yeésò sie sɔm bú ter, à yuo njebá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn yeé baá ké gwò léláŋ bɔɔ̀n, bɔ́ ye bú a: «La bɔɔ́ naâ naàn mé béh bú kwɔ́gɔ́ kòmò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeésò ye bɔ́ a: «Gèh càŋ bú sâ, kɔ bɔ́ né lom Càŋ dua, bɔ́ kwɔgɔ ye bú.» ");
INSERT INTO mcu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bɔ́ yuo doó sâ. Bɔ́ yeé baá te tàbè Galilê kelá, Yeésò gwàn cú mé bɔ̀ nùàr kɔ bèh mé à né teèn. ");
INSERT INTO mcu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Lòù sam, à lé naâ bɔ̀ mbɔ̀ŋ seèn njèh feh, ye bɔ́ a: «*Huaán Nùàr nde né beè bɔ̀ nùàr yilá, bɔ́ wula sɔm bú. Mɔ bɔ́ wula sɔm aá bú, te cieé tagáre à nde cuù né lè cio komo yuo.» ");
INSERT INTO mcu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mé njéh mene, bɔ̀ mbɔ̀ŋ lé ŋgwé kòmò ná ŋgwêh. Bɔ́ mé Yeésò bíé njí ŋgwéh ndɔ, veéh lé naâ bɔ́ sie yɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bɔ́ wa ké Kapernahûm. Bɔ́ yeé baá ké gwò, Yeésò bie njií mé bɔ̀ mbɔ̀ŋ, ye bɔ́ a: «Bí la ceceér saán gɔɔ́ naâ kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bɔ́ sòn kòmò ŋgwéh. Sâ ceér dueè bɔ́ la naâ saán gɔ ye: «Dé koô lètenè beèh né neì wa?» ");
INSERT INTO mcu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeé baá ménâ, Yeésò den nde doó ndɔ, à yilá njiî bɔ̀ mbɔ̀ŋ dé yulà cùɔ̀b fà doô, ye bɔ́ a: «Nuaá mé gwaán né feh lètenè bɔ̀ mbeî deèn, bú a: dèn sér ka bɔ̀ mbeî dɔɔ́ŋ kɔɔ́, à ŋa seér kwer bɔɔ̀n dɔɔ́ŋ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jomo sâ à weh njebá kwaá huaán déì ká toò bɔɔ̀n, à kumó weh bú, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Nuaá mé né huaán déì faá bú hên nɔ sie nyegé, mɔ à bú sie nyegé né felè mò, sâ à sie nyegé né mè. Nuaá mé né mè sie nyegé, mè mé huún sìè nyégé lòm ŋgwéh, né bêh Tele mò mé lé temà naâ mè, fà dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jâŋ deên ndɔ, ye Yeésò a: «Nùà fèh-njèh, béh la naâ nuaré déì ŋené, à lè bɔ̀ŋ beèh sam, à né bɔ̀ tándulu kwɔgɔ́, à bɔ́ kwɔgɔ́ den né mé yilí yeè; béh la naâ bú yiín.» ");
INSERT INTO mcu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yeésò ye bú a: «Bí té bú yín. Mɔ nùàr né fém mé yilí mò bɔɔ́, sâ à yilí mò kɔɔ́ bɔ́ béh ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mɔ nùàr béh bùnò ŋgwéh, sâ à né jomo beèh. ");
INSERT INTO mcu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mè né tueé ye bí a, nuaá mé kwe haá cegé mene bí léláŋ nòmò, ye bí né bɔ̀ nùàr *Kristò dɔɔ́ŋ, nùà sâ nde né sàgà kwa.» ");
INSERT INTO mcu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Bɔ̀ huaán tetɔɔ̂r mé né temé yoòr mò kwaá njií hên, nuaá mé dɔr njií cén déì lè veéne, nde né mé gèr kwaré. Sâ nùà hèllè ye, mé sòn gèr hèllè bɔ́ wèh ndé mé nyí ké sòn nòmò koô, bɔ́ jɔ́gɔ́ kàgà kwá nyí nyèn tuagaà, bɔ́ vela si njií kɔ nyí dùà. ");
INSERT INTO mcu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","«Mɔ be yeè wò te veên dɔr yií né kɔɔ́, sâ cɔ̀ téná sɔ̀m bú lòù. Huɔm kela né yɔ̀ŋ mé be cén kwaà; wanɔɔ́ŋ mɔ wò né mé be fà seŋ den, gùm yeè dɔɔ́ŋ nde né tuar te we tarê die yila.  ");
INSERT INTO mcu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ké doó sâ, bí bɔ̀ ŋgu nde né cu dɔɔ́ŋ jueé den; we teèn nyímé bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","«Mɔ gule yeè wò te veên dɔr yií né kɔɔ́, sâ téná sɔ̀m bú tenà. Huɔm kela né yɔ̀ŋ mé gule cén kwaà; wanɔɔ́ŋ mɔ wò né mé gule fà seŋ den, bɔ́ nde né gùm yeè dɔɔ́ŋ tuar si njií.  ");
INSERT INTO mcu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ké doó sâ, bí bɔ̀ ŋgu nde né cu dɔɔ́ŋ jueé den; we teèn nyímé bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","«Mɔ njolo yeè wò te veên dɔr yií né kɔɔ́, lùàgà sɔ̀m bú luagà. Huɔm kela né *Lò Càŋ mé njolo cén yilâ, wanɔɔ́ŋ mɔ wò né mé njolo fà seŋ den, bɔ́ nde né gùm yeè dɔɔ́ŋ tuar si njií. ");
INSERT INTO mcu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ké doó sâ, bí bɔ̀ ŋgu nde né cu dɔɔ́ŋ jueé den; we teèn nyímé bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bɔ́ nde né nùàr dɔɔ́ŋ mé we temá, bɔ́ waá túɔ́m teèn. ");
INSERT INTO mcu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Túɔ́m né njèh bagaà. Á, mɔ túɔ́m cuaré baá, bɔ́ bú bɔɔ́ ŋgulí cu nde né naàn wa? Bí dèn beè bɔ̀ nùàr faá túɔ́m nɔ, bí dèn dèn cu dɔɔ́ŋ mé sòn cên.» ");
INSERT INTO mcu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeésò yuo doó sâ, à nde te tàbè Judê, à nde sela yuo kela Jurdên kèb yágà ndɔ. Cìlì nùàr bilí wa cuù ŋgún, à yila cu bɔ́ njèh faá bèh jomò nɔ feèh. ");
INSERT INTO mcu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sâ bɔ̀ *Farisiên déì né doó teèn, bɔ́ ŋgoró ndeè Yeésò sòn felá, bɔ́ ye bú a: «*Sóú beèh né yeé jolo mé nùàr sɔm véh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeésò ye bɔ́ a: «Músì lɔ ye bí a naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bɔ́ ye bú a: «À lɔ ye: mɔ nùàr nde aá véh sɔm, bú a: nyàgà há bú mvù beè, à sɔm ye bú ma.» ");
INSERT INTO mcu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeésò deén baá-re ndɔ, ye bɔ́ a: «Músì lɔ ménâ jue kuú naâ felè dúágá-tie biì; ");
INSERT INTO mcu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","wanɔɔ́ŋ ké bèh duɔɔ̂m, Càŋ yeé si gi aá wɔ́ŋ, à lé naâ nùàr meé, dé siîb cén, dé vêh cén. ");
INSERT INTO mcu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Né dé cî mé nùàr nde né tele mé meí si lɔɔ́, à nde kwa veèh, ");
INSERT INTO mcu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bɔ́ bú den te bɔ́ fà dɔɔ́ŋ ŋa lom cén. Sâ tueé né ye: kènê bɔ́ fà sam cuú, bɔ́ baá seér njèh cén. ");
INSERT INTO mcu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mɔ né mân, njií mé Càŋ nyɔgɔ́ bilí gi aá, ndɔ́g nùàr a, té gè sɔ̀m.» ");
INSERT INTO mcu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bɔ́ yeé baá ké gwò, bɔ̀ mbɔ̀ŋ bie cu bú njèh teèn. ");
INSERT INTO mcu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","À ye bɔ́ a: «Nuaá mé sɔm véh, jɔgɔ cu déì ká jomo, cum aá gwɔ̀m beè veèh kèn, à sâ kuú né yàgà. ");
INSERT INTO mcu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma mé yuo gwà siîb, nde cu déì jɔgɔ́ dɔɔ́ŋ, kuú taré né yàgà ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bɔ̀ nùàr né mé bɔ̀ huaán tetɔɔ̂r ká yoòr Yeésò weh ndeê, te à kema njií bɔ́ be yoòr. Bɔ̀ mbɔ̀ŋ nde seér cu dé bɔɔ̀n dé ndeè. ");
INSERT INTO mcu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeésò yeé nde ŋene njií ménâ, à deên ndɔ, ye bɔ́ a: «Bí kwá bɔ̀ huaán ndeè ká yoòr mò, bí té bɔ́ yín. Bí kɔ́ɔ ye, *Lò Càŋ né dé bɔ̀ɔ́ mé den né faá bɔ́ nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mè né tueé ye bí a, nuaá mé Lò Càŋ mé temé seèn mene faá huaán maàn nɔ wèh ŋgwéh dɔɔ́ŋ, teèn yílá ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jomo sâ à kumó bilí bɔ́ beè seèn, à ba bɔ́ be felè, à kulú bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yeésò yeé baá mé gò, nuaré déì dula waà, cemmé nde toò seèn, ye bú a: «Nùà fèh-njèh dé bagaà né wò. Hên, mè bɔɔ́ nde né naàn, te mè kwa ye yɔ̀ŋ dé tètàgà wa?» ");
INSERT INTO mcu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeésò ye bú a: «Wò mè nùà bagaà yilá né mé ŋgei wa? Nùà bagaà gi cegé né Càŋ. ");
INSERT INTO mcu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wò né gi *sóú kɔɔ́, ye: Té feh wúlá; té yàgà ndé; té yíb ŋúɔ́b; té nuaré déì nyeén yoòr cɔ̀ kwá, té nùàr njèh beè nágá wèh; ŋgwé sòn tele yeè mé meí yeè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nùà doô ye bú a: «Nùà fèh-njèh, mè lé jolo duɔɔ́m naâ ménâ, sâ mè née ndà ye, mè né yeé bɔ̀ dé sâ jolo gií.» ");
INSERT INTO mcu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sâ nùà hèllè né Yeésò yoòr yilá ndɔ. Yeésò ke njií bú, ye bú a: «Le cu née wò njèh cén ye; ndé gò sɔ̀m bɔ̀ njèh yeè, wò geé haá njií bɔ̀ saám bɔ̀ kàgàlɔ̀ŋ sâ, te wò kwa seér ŋgúlú dé ké ter te vulúu. Jomo sâ wò ndeè, wò bele mè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te nùà hèllè yeé nde ŋgweé njií dé sâ mân, à munó njií gi ŋgúlú seèn dɔɔ́ŋ, à curú kuún, à durú yuo seér aá doó sâ lòù. ");
INSERT INTO mcu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeésò bele seér ndɔ, à ke njií bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: «Nde né taré mé bɔ̀ lilieê bɔ̀ yila *Lò Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bɔ̀ mbɔ̀ŋ yeé nde ŋgweé njií mân, hiím su njií bɔ́ doó. Yeésò den cuù, ye bɔ́ a: «Bɔ̀ huaán mò, te Lò Càŋ yilâ né taré. ");
INSERT INTO mcu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ŋgweéh né taré mé ŋgelobà yila kela te lɔ́ŋ kɔ̀gɔ̀târ wa? Né ménâ mé nùà lieê ndɔ; te Lò Càŋ yilâ taré kela nde né dé seèn mé dé ŋgelobà.» ");
INSERT INTO mcu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Te ŋgòr hên hiím nyegé cu ye baá-re bɔ̀ mbɔ̀ŋ, bɔ́ né lètenè bɔɔ̀n bieé kuú ye: «Sâ, mɔ né mân, nuaá mé nde né yili yuo né neì?» ");
INSERT INTO mcu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeésò ke njií bɔ́ ndɔ, ye bɔ́ a: «Taré yɔgɔ́ né bɔ̀ nùàr, beè Càŋ táré ŋgwéh, njeré déì bú táré yɔ́gɔ́ bèh.» ");
INSERT INTO mcu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yeé baá môn, Piêr ye bú a: «Ŋgweéh béh hên vu lɔ gi aá bɔ̀ njèh beèh sâ, béh bele wò ma.» ");
INSERT INTO mcu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeésò ye bú a: «Mè né tueé ye bí a, mɔ nuaré déì vu lɔ gwà seèn wa, né bɔ̀ bei mé bɔ̀ dìm seèn wa, né bɔ̀ tie seèn wa, né mene tele bɔ̂ meí, né mene ŋuna mé bɔ̀ ŋueèh seèn, mɔ à bɔ́ vu lɔ né felè mò, à bɔ́ vu lɔ né felè Njàgà Bagaà, ");
INSERT INTO mcu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sâ à nde cu né méménâ te mbeí yuiî kwa yɔgɔ́ keéh, à kwa cu nde né bɔ̀ gwà o, bɔ̀ dìm bɔ́ bɔ̀ bei o, bɔ̀ tie o, bɔ̀ meí o, bɔ̀ huaán o, bɔ̀ ŋueèh o, dɔɔ́ŋ à nde gi né bɔ́ cafanê kwa gií, à teèn kwa bilí cu mé bùnò mene. Te à ndeè loù sâ kwa bilí cu mé yɔ̀ŋ tètàgà mene. ");
INSERT INTO mcu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mè tueé bí: nùàr kókoó lètenè bɔ̀ ké toò bɔ̀ nde gi né ké jomo kelá seér; nùàr kókoó lètenè bɔ̀ ké jomo bɔ̀ kela seér cu ké toò.» ");
INSERT INTO mcu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kènê bɔ́ baá ceér dueè, bɔ́ baá ké Jerusalem ŋaá ndeé. Yeésò né ké toò bɔ̀ mbɔ̀ŋ seèn kɔɔ́. Bɔ̀ mbɔ̀ŋ né lom mé veéh dé gècên. Bɔ̀ɔ́ mé né jomo bɔɔ̀n veéh gi né ménâ ndɔ. Yeé baá mân, Yeésò weh bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô, à tueé kwaá bɔ́ njií mé nde aá bú kwa ndɔ, ");
INSERT INTO mcu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ye bɔ́ a: «Hên béh bí ŋaá nde baá ké Jerusalem sâ. Wa ké teèn, bɔ́ nde né *Huaán Nùàr beè bɔ̀ *ŋgàŋ sèmè dé kokoô, mé bɔ̀ *njí-sóù jɔgɔ́ yií. Bɔ̀ sâ bɔ̀ nde né ju felè seèn tená, te bɔ́ wula bú wulà. Bɔ́ nde né bú beè bɔ̀ lòù bɔ̀ jɔgɔ́ yií. ");
INSERT INTO mcu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bɔ̀ lòù bɔ̀ nde né bú selé, bɔ́ kulu su bú dèh yoòr, bɔ́ nde né bú lobo, bɔ́ wula sɔm bú ndɔ. Kɔ baá cieé tagár, à komo yuo cu ye lè cio.» ");
INSERT INTO mcu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jomo sâ bɔ̀ ŋunà Jebedê Jâk bɔ̂ Jâŋ ndeè ye Yeésò a: «Nùà fèh-njèh, njií mé béh nde né wò dua hên, béh ye te wò gwaán ménâ.» ");
INSERT INTO mcu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeésò ye bɔ́ a: «Bí jue né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bɔ́ ye bú a: «Mɔ wò ndeè baá ké te kɔgɔ, wèh kwá béh kwarè yeè bèh *sùsùm ndɔ, déì den te be gaâ, déì den te be ŋgoù yeè.» ");
INSERT INTO mcu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeésò ye bɔ́ a: «Njií mé bí né bieé hên, bí kɔ́ ŋgwéh, wanɔɔ́ŋ bí nde né ŋgàb jelâ faá mè nɔ jɔgɔ́ ŋueé komo wa? Bí nde né nòmò Càŋ faá mè nɔ kou komo ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bɔ́ ye bú a: «Béh nde né bɔɔ́ komo.» Ye bɔ́ a: «Né bɔ̀n, bí nde né ŋgàb mò ŋueé, bɔ́ nde né bí nòmò Càŋ faá mè nɔ kou ndɔ. Dé sâ nde gi né ménâ dág. ");
INSERT INTO mcu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Njèh cén, dé te be gaâ mé be ŋgoù mò deèn, beè mò sam. Bɔ̀ɔ́ mé Càŋ lé nyegé kwaá naâ bèh denè sâ mé bɔ́, kwa nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bɔ̀ mbɔ̀ŋ dé yulà doô yeé nde ŋgweé njií ménâ, temé yulá gi bɔ́ lè mé Jâk bɔ̂ Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeésò yeé ŋene aá môn, à yilá njiî bɔ́ ká toò, ye bɔ́ a: «Bí né kɔɔ́ ye, bɔ̀ nùàr né bɔ̀ mgbèémgbè mé tàbè hihiné faá nùàr nɔ weh; bɔ̀ mgbèémgbè hèllè né bɔ́ lòù tuú; bɔ̀ kokoô bɔ̀ né bɔ́ ménâ tuú taré ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dé biì, bú a, té lètenè biì ménâ dèn. Nuaá mé gwaán né nùà koô lètenè biì ŋaâ dɔɔ́ŋ, bú a, ŋá sér nùà seê bɔ̀ mbeî kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nuaá mé gwaán né feh lètenè biì deèn, bú a, ŋá sér kwer bɔ̀ mbeí seèn dɔɔ́ŋ kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mè tueé bí, *Huaán Nùàr ndé ná ŋgwêh ye te bɔ́ bɔɔ́ kwaá nyí seé beè. À tétég nde seér naâ ye te nyí den nùà seê bɔ̀ nùàr, te nyí ŋa weh cio nùàr ŋgún mé húɔ́m nyî.» ");
INSERT INTO mcu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bɔ́ wa ké Jerikò ndɔ. Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn mé bɔ̀ nùàr ŋgún yeé baá lɔ sâ yuo cuú, sâ tácugó déì né te sòn ceêr njèh dua den. Yilí seèn lé naâ Bartimê, ŋunà Timê. ");
INSERT INTO mcu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","À yeé baá ŋgweé ye Yeésò nùà Najarêt kela né kɔɔ́ mân, à sɔm hueh, ye: «Yeésò Ŋunà *Davîd, kɔ́ yeè mè jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bɔ̀ nùàr kókoó yeé ŋgweé aá ménâ, bɔ́ nde seér bú lòù, bɔ́ ye bú a: «Máb sòn yeè doó sâ.» Mé njéh mene, à kɔ lom né méménâ ké ter lɔgɔ́ njiî, ye: «Ŋunà Davîd, kɔ́ yeè mè jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeésò njebá le ndɔ, ye bɔ́ yílá njî bú. Bɔ́ yilá baá-re bú, ye bú a: «Táré yo, wùò ter, à né wò yilá.» ");
INSERT INTO mcu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nùàrè yeé nde ŋgweé njií mân, à wa si njií cɔ̀gɔ̀ wagâ seèn doó, à lɔ wuo ter, à nde yoòr Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeésò ye bú a: «Wò ye mè a: gàm nyí naàn wa?» Ye Yeésò a: «Nùà fèh-njèh, bɔ́ yeè te mè ŋene njolo teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeésò ye bú a: «Wò né temé yoòr mò kwaá njií, wò yili yuo aá kèn. Ndé-re!» Njolo seèn kwɔgɔ yuo doó sâ ndɔ, à yuo bele Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bɔ́ né ka ndeé, bɔ́ wa lè lɔɔ́ Betafajê bɔ̂ Betanî, kwarè Jerusalem. Bɔ̀ lɔɔ́ sâ né ké te tòre, bɔ́ yilá yeé tòr sâ tòr Oliviê. Bɔ́ yeé nde aá Betafajê yilá, Yeésò tema keéh bɔ̀ mbɔ̀ŋ fà déì toò, ");
INSERT INTO mcu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ye bɔ́ a: «Bí ndé lè lɔɔ́ toò biì sâ. Mɔ bí baá teèn yilá, bí nde né huaán vuɔmndeè ŋené. Nuaré déì née teèn ŋá lɔ́gɔ́ ŋgwéeh ye, à né te yuiî. Bí sè ndê mé njéh. ");
INSERT INTO mcu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mɔ nuaré déì ye bí a, bí ménâ bɔɔ́ né dé keì wa, bí júée bú a: Nùà Dueè gwaán né bú kɔɔ́, te nyí haá njií cuù bí kènê.» ");
INSERT INTO mcu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bɔ́ fɔɔ́n gò ndɔ, bɔ́ wa, bɔ́ ŋene huaán vuɔmndeè né te yuiî coló den, à né tùtúlù gwà sòn ceêr mân. Bɔ́ se weh bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bɔ̀ɔ́ mé lé naâ doó sâ yeé ŋene aá ménâ, bɔ́ ye bɔ́ a: «Vuɔmndeè mé bí né se sâ, bí mé njéh bɔɔ́ nde né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bɔ́ tueé baá-re bɔ́ faá Yeésò la tueé naâ bɔ́ nɔ. Bɔ̀ nùà sâ kwaá lɔ bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bɔ́ weh haá njií Yeésò huaán vuɔmndeè doô, bɔ́ né bɔ̀ cɔ̀gɔ̀ suù bɔɔ̀n huaré weh, bɔ́ né bú ŋgètenè teé njií. Yeésò ŋaá den teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nùàr kókoó mbaá né bɔ̀ cɔ̀gɔ̀ bɔɔ̀n ceceér huaré teé njií, bɔ̀ déì né bɔ̀ cù ké ya kwa, bɔ́ né mé njéh ceceér teé ndeé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Léh né lom gè toò mé gè jomo mene sue, ye: «Càŋ né duesé. Kùsèm bú a, kúlú nyégé nuaá mé ndeè né mé yilí seèn hên kulù. ");
INSERT INTO mcu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bɔ̀gɔ̀ tele beèh *Davîd mé komo waà né hên, Càŋ a, kúlú nyégé bú kulù. Vulú a, sén Càŋ seèn.» ");
INSERT INTO mcu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeésò yila nde Jerusalem ndɔ, à kela nde ké gwà Càŋ koô. À yeé ke yɔŋ gi aá bɔ̀ njèh teèn dɔɔ́ŋ, bɔ́ bɔ̀ mbɔ̀ŋ seèn nde cu Betanî, sâ cu nde aá kelá. ");
INSERT INTO mcu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cieé ŋaga bɔ́ yuo cu Betanî, sâ cùè baá Yeésò sie. ");
INSERT INTO mcu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bɔ́ yeé baá beré déì, à ŋene njií toú déì né tɔɔ́, à nde ké teèn, ye kɔ ŋgweéh tàb né teèn wa? À wa ké teèn, à ter kwa lom léláŋ yùè. Lòù sam, cu tàb waâ lé née toò ye. ");
INSERT INTO mcu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","À deên ndɔ, ye toú hèllè a: «Ndɔ́g nuaré déì tàb yeè sònò nágá kéh ndé cú.» Sâ bɔ̀ mbɔ̀ŋ né ŋgweé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bɔ́ wa ké Jerusalem. Yeésò yila nde yí cie gwà Càŋ koô. À wa, sâ bɔ̀ nùàr né toón teèn bɔɔ́ den: bɔ̀ déì né go, bɔ̀ déì né ŋge, bɔ̀ déì né kàgàlɔ̀ŋ kwellé. À yeé nde ŋene njií ménâ, à yila bɔ́ cie kwɔgɔ sɔm keêh, à vela ŋellé sɔm gbàgà kàgàlɔ̀ŋ mé kɔgɔ bɔ̀ gò-vɔgɔb bɔ̀ mene. ");
INSERT INTO mcu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","À gwàn cú dé nuaré déì jɔgɔ kela mé njeré déì bèh sâ. ");
INSERT INTO mcu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jomo sâ à yila bɔ́ njèh feèh ndɔ, ye bɔ́ a: «Ŋgweéh né gi lè mvù Càŋe nyagá den ye: Bɔ́ yilá nde né gwà mò, gwà Càŋ duaà dé nùàr dɔɔ̂ŋ wa? Keí mé bɔɔ́, bí weh kwaá seér aá gùr yîb biì wa?» ");
INSERT INTO mcu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù yeé nde ŋgweé njií ménâ, bɔ́ duɔɔ́m ceér fɔɔ̂n, te bɔ́ wula sɔm bú. Lòù sam, njií mé à lé naâ feh doô lé naâ bɔ̀ nùàr yoòr yilá. Bɔ̀ kokoô bɔ̀ lé bú veéh naâ dé cî. ");
INSERT INTO mcu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yeé baá liyilì Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn yuo lɔ sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cieé ŋaga bɔ́ komo yuo, bɔ́ bele cu ceér. Bɔ́ yeé wa baá bèh sâ, bɔ́ ke njií toú hèllè ŋema yuo aá mé jɔgɔb mene. ");
INSERT INTO mcu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piêr munó ko cu njií mé lé kelà naâ, ye Yeésò a: «Nùà fèh-njèh, kè njí toú léílé mé wò lé duagá naâ hên ŋema yuo aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeésò deén baá-re ndɔ, ye bɔ́ a: «Mè né tueé ye bí a, mɔ bí temé kwaá njií né mé Càŋ, ");
INSERT INTO mcu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","né mene tòr hên, mɔ bí ye bú a: Ndé kòmò dìè ké dùà kíê, nde né te sòn biì bɔɔ́. Mɔ bí sàn ŋgwéh, bí temé kwaá njií lom né ye njèh mân nde né bɔɔ́, sâ nde né te sòn biì bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mè bí tueé né dé cî, ye bí a: mɔ bí baá Càŋ njeré déì dua, bí kwaá lom ndèm, ye bí kwa gi aá kèn, sâ Càŋ bí haá nde né ménâ. ");
INSERT INTO mcu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mɔ bí nde aá Càŋ dua, mɔ temé né bí lè mé nuaré déì yulá, bí jɔ̀gɔ̀ kúlú sɔ̀m gíi cí ye, te Tele biì ké te vulúu kulu sɔm gi veên biì lè seèn ménâ ndɔ. Jomo sâ bí dua ye bú. ");
INSERT INTO mcu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mɔ bí veên bɔ̀ mbeí biì doó kúlú njí ŋgwéh, Càŋ bɔ̀ veên biì lè seèn kúlú sɔ̀m ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bɔ́ wa cu ké Jerusalem. Yeésò yeé baá cie gwà Càŋ koô gɔ den, bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ njí-sóù mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ bilí ndeè kwarè seèn, ");
INSERT INTO mcu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bɔ́ ye bú a: «Wò bɔ̀ njií hên bɔɔ́ né mé gèh terrèb dé heè? Neì wò jegé naâ kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeésò ye bɔ́ a: «Mè nde né bí njeré déì bieé ndɔ: mɔ bí né tueé kɔɔ́, mè se ye bí kwɔ̀m dé mò hên. ");
INSERT INTO mcu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bí jɔ̀gɔ̀ túé ke mè ye, neì lé Jâŋ Bàptîs tema njií naâ kɔɔ́, ye bú a: ndé bɔ̀ nùàr kou bele wa? Lé naâ Càŋ wa, lé naâ nùàr wa?» ");
INSERT INTO mcu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bɔ́ yila mé njéh lètenè bɔɔ̀n fellé kuú, ye: «Hên, mɔ béh ye bú a: Càŋ lé Jâŋ temà naâ kɔɔ́, à nde né tueé ye béh a: béh lé temé yoòr seèn kwá njí ná ŋgwêh dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Á, mɔ béh ye bú a: bɔ̀ nùàr lé bú temà naâ kɔɔ́, sâ béh beè yila baá kèn.» Mé bɔ́ né ménâ tueé, sâ bɔ́ né bɔ̀ nùàr veéh. Sâ beè bɔ̀ nùàr Jâŋ lé naâ *sòn-Càŋ dé jéjêg. ");
INSERT INTO mcu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yeé baá ménâ, bɔ́ ye bú a: «Béh kɔ́ ŋgwéh.» Yeésò ye bɔ́ a: «Sâ mè bí nuaá mé jegé naâ mè túé ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jomo sâ Yeésò duɔɔ́m bɔ́ njèh te kàne si keêh ndɔ, ye bɔ́ a: «Nuaré déì lé kieè naâ ŋueèh seèn. À yeé dobo gi aá yab, à kaga sie ŋueèh sâ beè, à nde ke beré déì, à sio kwaá vua dé tàb dorô teèn, à sie kwaá gbàgà teèn ndɔ. Jomo sâ, à haá kwaá ŋgɔgɔ̂ beè bɔ̀ seé bɔ̀, te bɔ́ ke nyegé den jomo, à nde dé seèn bèh gò. ");
INSERT INTO mcu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Cu mé yab yeé baá bɔlé, à tema njií nùà seê seèn cén déì ké yoòr bɔ̀ kè-ŋueèh bɔ̀ doô, ye te nyí kwa yab teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nùà seê doô yeé wa ké teèn, bɔ́ cab sie bú, bɔ́ duún bú núr, bɔ́ kwɔgɔ njií bú lɔ be be. ");
INSERT INTO mcu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nùà ŋueèh doô tema njií cu nùà seê déì. Wa ké teèn, bɔ́ gera yií bú dé seèn felè, bɔ́ weh bú séb. ");
INSERT INTO mcu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nùà ŋueèh doô tema njií cu déì ndɔ. Dé sâ, wa ké toò, bɔ́ wula sɔm bú lòù. À né cu mene bɔ̀ déì ké teèn temá njií, bɔ́ né lom bɔ́ seé faá bɔ̀ mbeí bɔɔ̀n nɔ weh. Bɔ́ né bɔ̀ déì lobo, bɔ́ né bɔ̀ déì lòù wulá. ");
INSERT INTO mcu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Nde le cegé huaán yíé-temê seèn. Yeé baá ménâ, à tema ceré bú ndɔ, ye dé seèn bɔ́ nde né bú veéh. ");
INSERT INTO mcu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mé njéh mene, wa ké toò, bɔ̀ kè-ŋueèh bɔ̀ hèllè nyɔgɔ́ sòn lètenè bɔɔ̀n, bɔ́ ye: Hên né nuaá mé nde né nùà ŋueèh ŋaá sâ. Mɔ sam, kɔ béh wula sɔm bú lòù, te ŋueèh hên ŋa dé beèh. ");
INSERT INTO mcu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bɔ́ cab sie bú, bɔ́ wula sɔm bú, bɔ́ tulu si njií ké luaà ŋueèh.» ");
INSERT INTO mcu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeésò den cuù, ye bɔ̀ nùàr a: «Faá bèh mân, nùà ŋueèh doô bɔɔ́ nde né naàn wee? Mè tueé bí, à nde cu né bɔ̀ kè-ŋueèh bɔ̀ doô wulá sɔm gií ndɔ, à ŋueèh kwaá lɔ cu beè bɔ̀ nuaré déì. ");
INSERT INTO mcu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bí née dé mé né lè mvù Càŋe nyagá den doô jáŋé ŋéné ŋgwéeh ye wa? Bèh sâ né tueé ye: Taá mé bɔ̀ mé-gwà bɔ̀ lé naâ ké jomo komo si njií hên, taá dàn ŋa seér cu né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sâ dɔɔ́ŋ né seé Nùà Dueè. Ŋgweéh huɔm kela né cí mà. Béh kéí lòm mé gècên mene.» ");
INSERT INTO mcu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bɔ̀ kokoô bɔ̀ lètenè bɔ̀ *Jûf yeé ŋgweé aá ménâ, bɔ́ kɔ ye Yeésò tueé njií né mé bɔ́. Bɔ́ yila lom aá ceér fɔɔ̂n, te bɔ́ sie bú. Njèh cén, veéh né bɔ́ mé bɔ̀ nùàr sie yɔgɔ́. Yeé baá ménâ, bɔ́ kwaá lɔ bú, bɔ́ fɔɔ́n gò. ");
INSERT INTO mcu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jomo sâ bɔ́ tema njií bɔ̀ *Farisiên mé bɔ̀ nùàr *Herôde déì ké yoòr Yeésò, te bɔ́ nde bú sòn felá, bɔ́ sie bú teèn. ");
INSERT INTO mcu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bɔ́ yeé wa baá, bɔ́ ye bú a: «Nùà fèh-njèh, béh né gècên yeè kwaga. Bɔ̀ nùàr tueé mene felè yeè naàn dɔɔ́ŋ, wò dé sâ táŋ bèh, wò nùàr lòù bàlè bèh ndɔ, wò né bɔ̀ nùàr ceér Càŋ mé gècên mene feh dilí. Sâ jɔ̀gɔ̀ túé ke béh ye: *sóú beèh ye gwɔ̀m làmpɔ̂ŋ mgbè Rɔ̂m gwɔɔ̀m wa, té gwɔ̀m wa? Béh gùgwɔɔ̀m wa, béh gwɔ̀m ndé ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sâ Yeésò né gi leba bɔɔ̀n kɔɔ́, ye bɔ́ a: «Bí mè mân tab tena né dé keì wa? Bí jɔ̀gɔ̀ wèh kéh ke mè kàgàlɔ̀ŋ déì ye.» ");
INSERT INTO mcu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bɔ́ weh haá njií bú cén déì ndɔ. À ye bɔ́ a: «Feh nùàr mé yilí nùàr ká teèn hên nyagá den né dé neì wa?» Bɔ́ ye bú a: «Né gi dé mgbè Rɔ̂m.» ");
INSERT INTO mcu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","À deén baá-re, ye bɔ́ a: «Sâ bɔ̀ njií mé né dé mgbè dɔɔ́ŋ, bí gwɔ̀m njí cú mé mgbè. Bí bɔ̀ dé Càŋ há njí cú mé Càŋ ndɔ.» Hiím yɔgɔ́ cu bɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bɔ̀ *Sadusiên bilí ndeè ká yoòr Yeésò. Sâ bɔ́ né yeé tueé, ye mɔ nùàr kuú baá, sâ gi aá, à lè cio kòmò yùò ndé cú. Bɔ́ yeé waá baá, bɔ́ ye bú a: ");
INSERT INTO mcu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Nùà fèh-njèh, Músì lɔ naá giì ter nyagá kwaá, ye béh a: mɔ nuaré déì kuú kwaá lɔ véh mé huaán sam, dìm a, sàgà cú ma kû doô, à ŋar yilá cu bei ma. ");
INSERT INTO mcu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yeé baá ménâ, nuaré déì bɔ́ bɔ̀ dìm lé naâ téhbeh. Bei jɔgɔ véh, à kuú kwaá lɔ véh, huaán sam. ");
INSERT INTO mcu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dìm sagá weh ma kû doô, à kuú cu, huaán sam. Dìm bɔɔ̀n déì sagá weh keéh cu ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bɔ́ sagá laré bú téhbeh dɔɔ́ŋ, huaán sam. Jomo sâ ma hèllè kuú bele bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Á hên, mɔ loù sâ bɔ̀ komó ndeè baá te cio komo yuo, ma hèllè ŋa sɔm nde né veèh dé heè wa? Ŋgweéh lètenè bɔɔ̀n téhbeh dɔɔ́ŋ, bɔ́ lé naá giì bú sagá laré wa?» ");
INSERT INTO mcu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeésò ye bɔ́ a: «Dé sâ ndugó gɔ né bí. Bí ŋgòr Càŋ ŋéné kɔ́ ŋgwéh, bí terreb Càŋ ŋéné kɔ́ ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bí kɔ́ɔ ye, loù mé bɔ̀ komó nde né te cio komo yuo, bɔ̀ siíb bɔ́ bɔ̀ véh ndeè jɔ́gɔ́ kú ndé cú, bɔ́ den nde aá faá bɔ́ cìlì Càŋ ké te vulúu nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","«Dé mé nùàr nde né te cio komo yuoò, bí njií mé Músì lé naâ te mvù seèn nyagá kwaá doô jáŋé kè ŋgwéh wa? À lé mân nyagá naâ te lèmè mé à nyagá né ju jìlì ŋgémbèì teèn doô, wa Càŋ ye: Nyí né Càŋ mé bɔ̀ tele biì Abrahâm bɔ̂ Isâk mé Jakɔ̂b né yeé dua doô ma. ");
INSERT INTO mcu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mè tueé bí, Càŋ né Càŋ bɔ̀ lèlàŋ bɔ̀, à Càŋ bɔ̀ komô sam. Mɔ né mân, sâ bí né mé gècên mene saáb.» ");
INSERT INTO mcu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sâ *njí-sóù lé naâ doó, à lé naâ njií mé Yeésò bɔ́ bɔ̀ *Sadusiên né saán sâ ŋgweé. À yeé ŋene Yeésò né bɔ́ bagasé se nyegé, à ndeè ndɔ, ye bú a: «Sóú mé jolo kela né kɔɔ́ né dé heè wa?» ");
INSERT INTO mcu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeésò ye bú a: «Sóú mé jolo kela né kɔɔ́ né dé hên: Càŋ lé ye: Iserálà ŋgwé, Tele beèh Càŋ Dueè né lom Nùà Dueè mé huún, sâ gi aá. ");
INSERT INTO mcu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wò gwàn gí Càŋ Nùà Dueè mé temé yeè mene, mé càŋ yeè mene, mé mùnò yeè mene, mé terreb yeè mene dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sóú dé jomo mé bele né bú né cu dé hên: Gwàn mbeí yeè faá wò gwaán né ŋgàŋ yoòr yeè nɔ. Bɔ̀ sóú fà hên, sóú déì bɔ́ jòlò yɔ́gɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Njí-sóù doô deên baá-re, ye Yeésò a: «Môn, Nùà fèh-njèh, wò tueé yií né teèn, à né lom Càŋ mé huún, Càŋ déì toò sam. ");
INSERT INTO mcu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nùàr a, gwàn lòm bú mé temé seèn mene, mé càŋ seèn mene, mé terreb seèn mene dɔɔ́ŋ, à gwàn mbeí seèn faá à gwaán né ŋgàŋ yoòr seèn nɔ. Huɔm kela né cí mé dàm bɔ̀ *sèmè.» ");
INSERT INTO mcu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yeésò yeé ŋene à né ménâ tueé huɔɔ́m, ye bú a: «Môn, wò né kwarè *Lò Càŋ, mè tueé wò.» Jomo sâ nuaré déì njolo toò seèn kàgà nyì cú, ye nyí nde né bú njeré déì bieé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sâ Yeésò né njèh te *gwà Càŋ koô feh den, ye bɔ̀ nùàr a: «Bɔ̀ njí-sóù ye Nùà Cɔ̀ŋ né *ndùté ndùtù Davîd mé ŋgei wa? ");
INSERT INTO mcu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ŋgweéh Cúcuí Ŋagâ lé naâ Davîd nùà njèh ceér feh, à yilá Nùà Cɔ̀ŋ Nùà koô seèn ma. À lé ye: Nùà Dueè ye Nùà koô nyî a: Dèn ndê ká te be gaâ nyî; kɔ nyí komó silí njií gi aá bɔ̀ bùnò bɔ̀ yeè doó, wò dobo kwaá bɔ́ gulè. ");
INSERT INTO mcu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hên, mɔ Davîd mé feh seèn Nùà Cɔ̀ŋ sâ yilá né Nùà koô seèn, sâ Nùà Cɔ̀ŋ né cu ndùté ndùtù seèn wa?» Njií mé Yeésò lé tueé giì naâ dɔɔ́ŋ, cìlì nùàr lé naá loôm mé vɔ́gɔ́-temé dé gècên. ");
INSERT INTO mcu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","À né bɔ́ njèh feh, ye bɔ́ a: «Bí bɔ̀ŋ feh biì beè bɔ̀ njí-sóù. Bɔ́ gwaán lom né bɔ̀ cɔ̀gɔ̀ dé dèdàbe lètenè bɔ̀ nùàr su gɔɔ̀. Né mene ké tan mé ké mbartɔgɔ̂, bɔ́ ye kɔ bɔ̀ nùàr gìbì bíé bɔ́ lòù. ");
INSERT INTO mcu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ké *gwà sóù, bɔ́ gwaán né bèh denè dé kokoô njolò bɔ̀ nùàr. Bɔ́ nde mene bèh kùrmò lɔ nùàr dɔɔ́ŋ, né gi ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɔ́ né njèh beè bɔ̀ ma kû horó weh bele. Mɔ bɔ́ baá Càŋ dua, kɔ bɔ́ dua tugó lòù, te den faá bɔ́ né bɔ̀ gècên bɔ̀ nɔ. Mè tueé bí, ju sie kela nde né bɔ́ mé bɔ̀ déì.» ");
INSERT INTO mcu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jomo sâ Yeésò nde ké kwarè mvugó kàgàlɔ̀ŋ gwà Càŋ, à den nde doó. Bɔ̀ nùàr né kàgàlɔ̀ŋ teèn si. À né bɔ́ ke den. Bɔ̀ déì né kókoó ŋuaán yií. ");
INSERT INTO mcu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma kû déì waà ndɔ, à teèn si yií kɔ́bɔ̀ fà. Bɔ̀ kɔ́bɔ̀ fà sâ né sòn dálà cên. ");
INSERT INTO mcu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeésò yeé nde ŋene njií mân, à yilá bilí bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: «Mè né tueé ye bí a, ma kû hên si kela né kɔɔ́ mé bɔ̀ déì dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bɔ̀ nùàr dé bɔɔ̀n kabe si lom né wèllè kàgàlɔ̀ŋ. Dé ma kû hên môn sam, à dé seèn karé si sɔm né jèjègè cèr gwà seèn.» ");
INSERT INTO mcu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeésò yeé baá ké gwà Càŋ koô yuo kelá, mbɔ̀ŋ seèn cén déì ye bú a: «Nùà fèh-njèh, kè njí, sâ né gèh taá huɔmê kei mân? Sâ né gèh gwà dudueèr kei mân ndɔ?» ");
INSERT INTO mcu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeésò ye bú a: «Ŋgweéh wò né bɔ̀ gwà dudueèr hên ŋené wa? Nde gi né dɔɔ́ŋ tɔbé yuo. Mè jue mene taá cén tà cén felè mbeî lè nyì ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yeésò né ké te tòr Oliviê den den, sâ gwà Càŋ koô né kèb yágà. Bɔ́ bɔ̀ Piêr mé Jâk mé Jâŋ mé Andrê yeé baá léláŋ bɔɔ̀n, bɔ́ ye bú a: ");
INSERT INTO mcu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Bɔ̀ njií sâ bɔɔ́ nde né te cu dé heè wa? Túé yeè béh teèn. Béh ŋene kɔ nde né mé kei, ye hên baá cí wa?» ");
INSERT INTO mcu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeésò yila baá-re bɔ́ tueê ndɔ, ye bɔ́ a: «Bí kɔ́gɔ́n ká lòù; nùàr a té bí bèlè. ");
INSERT INTO mcu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mɔ sam, bɔ̀ nùàr kókoó mbaá nde né yilí mò ŋaá weh, te bɔ́ bele weh gi bɔ̀ nùàr mé njéh; nùà kàn nde né tueé, nùà kân ye: *Nùà Cɔ̀ŋ né nyí. ");
INSERT INTO mcu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mɔ bí baá njàgà taâb mé bɔ̀ bèmè hihiné ŋgweé njií, bí té lòù ndèrrè. Kɔ seèn bɔɔ́ ménâ. Mé njéh mene, wɔ́ŋ mé njéh cèrè ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Taáb nde né lètenè lɔɔ́ déì bɔ̂ mbeí kɔɔ́ die, lò déì nde né mbeí mé taáb ŋaár kwa; tàbè nde né te bèh hihinê jilí; cùè nde né die. Sâ née seèn jèrè ye, kar weh né faá nyer nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Mɔ né mân, sâ bí dèn lòm dé biì làŋ. Bí kɔ́ɔ ye, bɔ́ nde né bí te *mbàgà juù mé sòn fuû jɔgɔ́ njií, bɔ́ nde né bí ké *gwà sóù lobo, bɔ́ nde né bí toò bɔ̀ kokoô bɔ̀ mé bɔ̀ mgbèémgbè mgbɔmé njií, ye bí né bɔ̀ nùàr mò fí. Sâ dɔɔ́ŋ, mè ye te bí den nyegé cu ye baá-re bɔ̀ sòn mò teèn. ");
INSERT INTO mcu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mé njéh mene, kɔ Njàgà Bagaà ndeè wɔ́ŋ beè ka sie gi aá kèn, te wɔ́ŋ ceré ye. ");
INSERT INTO mcu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sâ mɔ bɔ́ baá mé bí te mbàgà juù sie ndeé, njií mé bí nde né sònò tueé, bí té nyàmè. Bí túé lòm cu sâ ŋgòr mé bɔ́ nde né bí sònò tueé kwaá. Bí kɔɔ́ túé ndé ŋgwéh, Cúcuí Ŋagâ tueé nde né sòn biì kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","À den cuù ye bɔ́ a: «Dìm bɔ̂ bei nde né yo bɔɔ̀n go kuú, te bɔ́ wula bɔ́ wulà. Bɔ̀ tele nde né bɔ̀ huaán go, bɔ̀ huaán nde né yoòr bɔ̀ teleè ŋaár die; bɔ́ go sɔm bɔ́, te bɔ̀ nùàr wula taré bɔ́ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nùàr dɔɔ́ŋ nde né bí bunó laré; sâ dɔɔ́ŋ né gi felè mò. Mè tueé bí, nuaá mé nde né dɔɔ́ŋ yoló komo gií, nde né dé seèn yili yuo.» ");
INSERT INTO mcu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Bí nde né gègè veên ŋené, à den seér nde né bèh mé à sé la teèn dèn ná ŋgwêh. (Nuaá mé né ŋgòr hên jaŋé, bú a, ŋgwé nyégé bagasé.) ");
INSERT INTO mcu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mɔ baá môn, sâ bɔ̀ Judê bɔ̀ a, dùrà ŋá gí ké te tòre. Nuaá mé né ké felè gwà, bú a, fɔ́n lòm doò, à té ké gwò seèn felè bɔ̀ njèh seèn mbaá yílá kú cú. ");
INSERT INTO mcu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nuaá mé né ké ŋueh, bú a, té ká lɔ cû, ye te nyí weh sie cɔ̀gɔ̀ dùlù nyî beè. ");
INSERT INTO mcu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Loù sâ bɔ̀ véh mé lèì hueêh mé bɔ̀ ma vùlù nde né mé gèr ŋené kuú. ");
INSERT INTO mcu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","«Bí dùà lòm Càŋ, te cu sâ bí lè cu dùlù kwà cú, ");
INSERT INTO mcu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","wanɔɔ́ŋ gèr né teèn. Gèr dé loù sâ dé tueê sam. Bèh lɔ mé Càŋ lɔ sií naâ wɔ́ŋ dɔɔ́ŋ, gèr déì lɔ née teèn faá gèr bú hên nɔ sam ŋgwéeh ye; déì ndeè ménâ wá ŋgwé ndé cû ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mɔ Càŋ Dueè jere kɔ́ ŋgwéh, à bɔ̀ cieé gèr sâ kèb déì sɔ̀m wàgà ŋgwéh, sâ nuaré déì seèn làŋ lè ndé ŋgwéh. Njua mé Càŋ lé naá giì ménâ taáŋ kwaá ndɔ, ye nyí nde né bɔ̀ cieé sâ kèb déì sɔm waga; nyí sɔm waga nde né felè bɔ̀ɔ́ mé nyí lé naâ balé weh doô. ");
INSERT INTO mcu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Sâ bí dèn lòm làŋ, wanɔɔ́ŋ nuaré déì sé den né mbaá ye bí a: Kè *Nùà Cɔ̀ŋ hên! Kè à yíê! Mɔ à baá ménâ tueé, bí té temé teèn kwá njí. ");
INSERT INTO mcu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bɔ̀ *Kristò dé kòkòb mé bɔ̀ *sòn-Càŋ bɔ̀ dé nyenyenê nde né cie bomó sue, bɔ́ nde né bɔ̀ fém bɔɔ́ bele, ye mɔ yieé né yieè, te bɔ́ bele weh gi bɔ̀ɔ́ mé Càŋ lé balé kwaá naâ mé njéh. ");
INSERT INTO mcu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mè bí tueé kwaá gi aá kèn, bí dèn lòm á làŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Loù sâ, jomo gèr hèllè, lou nde né yilí, weéh nde né cib, ");
INSERT INTO mcu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bɔ̀ mbentò ndeè né ké te vulúu suelé suagâ, bɔ̀ njií mé né mé terreb ké te vulúu dɔɔ́ŋ nde gi né jilí. ");
INSERT INTO mcu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jomo sâ bɔ̀ nùàr nde né Huaán Nùàr ŋené njií, à né te mvulu bège mé terreb mene *sum suagâ. ");
INSERT INTO mcu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","À nde né bɔ̀ cìlì seèn kàn mé kán wɔ́ŋ dɔɔ́ŋ temá njií, te bɔ́ nde koró bilí bɔ̀ɔ́ mé à lé naá giì balé kwaá.» ");
INSERT INTO mcu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Bí kè wèh yoòr toú túé-kùr hên. Mɔ bí ŋene, à baá tɔɔ́, ŋgweéh sâ bí kɔ gi aá, ye jà baá dìdì mà. ");
INSERT INTO mcu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Loù mé Huaán Nùàr ndeè né teèn cuû né ménâ ndɔ. Mɔ bí ŋene bɔ̀ njèh kèkènè hèllè baá bɔɔ́ bele, sâ bí kɔ́ɔ ye: baá bú, à baá dìdì. ");
INSERT INTO mcu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mè né tueé ye bí a, mé bɔ̀ cafanê bɔ̀ nde dɔɔ́ŋ kuú gií, sâ bɔ̀ njèh hèllè bɔɔ́ gi aá. ");
INSERT INTO mcu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Vulú bɔ̂ tàbè nde né leér yuo; ndɔ́g bɔ̀ ŋgòr mò dé bɔɔ̀n nyímé ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Nuaá mé né cieé bú sâ kɔɔ́ sɔm teèn sam; nuaré déì cu sâ kɔ́ ŋgwéh ndɔ. Bɔ̀ cìlì Càŋ cieé sâ kɔ́ ŋgwéh. Né mene Huaán nùà njèh, à cieé bú sâ kɔ́ ŋgwéh ndɔ; gi cegé né Tele mé huún. ");
INSERT INTO mcu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bí bɔ̀ŋ feh biì, bí té lɔ́m cèr, wanɔɔ́ŋ bí cu sâ kɔ́ ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Den nde né faá nuaá mé nde né bèh gò ndeé nɔ. À yeé baá mé gò, à geé kwaá gi bɔ̀ seê bɔ̀ seèn seé, nùà kàn mé seé seèn, nùà kân mé seé seèn; ye gó-lɔ́m a, dèn làŋ ma. ");
INSERT INTO mcu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mɔ né mân, sâ bí dèn làŋ ndɔ, wanɔɔ́ŋ bí cu mé nùà gwà cuù nde né teèn kɔ́ ndé ŋgwéh. Merré déì nde né liyilì, merré déì lɔgɔ̀tenè, merré déì toò cieê, merré déì maánjɔ̀gɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mɔ à kar yuo kelà mene lòù, bí té gwàn mé à waà, sâ bí né lɔ́m. ");
INSERT INTO mcu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Njií mé mè né bí tueé hên, mè tueé njií né mé nùàr dɔɔ́ŋ ndɔ, ye: Bí dèn dèn làŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sâ cieé koô mé bɔ́ yilá né *Páskà doô le aá cieé fà. Né cieé koô mé bɔ́ yieé yeé breêd mé kulu teèn sam. Sâ bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù né ceér fɔɔ́n, te bɔ́ sie Yeésò; bɔ́ ye, bɔ́ sie leér nde né bú lòù ndɔ, te bɔ́ wula sɔm bú. ");
INSERT INTO mcu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bɔ́ ye: «Sâ kɔ béh bú te cieé koô hên sìè ŋgwéh, wanɔɔ́ŋ bɔ̀ nùàr nde né ŋaáŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sâ Yeésò baá ké Betanî gwò Simɔ̂ŋ. Simɔ̂ŋ lé naâ nùà beén veên. Bɔ́ yeé baá yáb yieé, ma déì ŋgoró nde kwarè Yeésò mé mbémbɔ́ŋ beè, kómó múmû mé keh tarê mân né lè deí; bɔ́ yilá né kómó sâ “nâr”. Ma doô kɔ sɔm sòn mbémbɔ̂ŋ ndɔ, à yurú njií gi Yeésò kómó sâ felè. ");
INSERT INTO mcu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bɔ̀ nuaré déì yeé nde ŋene njií ménâ, temé yulá bɔ́ lè, bɔ́ duɔɔ́m lètenè bɔɔ̀n tueé kuû ye: «À kómó sâ ménâ bɔɔ́ beéh né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bɔ́ sé la go sɔm nyegé naâ lòù, bɔ́ kwa kám yuií tagár mé njeré déì teèn, bɔ́ haá bɔ̀ saám bɔ̀ nɔ.» Bɔ́ né ma doô teèn nde yií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yeésò deên ye bɔ́ a: «Bí kwá lɔ́ ma hên nɔɔ́ŋ ménâ, bí bú temé lè bɔɔ́ yulá né dé keì wa? Njií mé à né mè bɔɔ́ hên né lom njèh bagaà beè mò dé gècên. ");
INSERT INTO mcu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dé bɔ̀ saám bɔ̀, bí bɔ́ nde née cu dɔɔ́ŋ kɔɔ́ ye. Cu mé bí baá gwaán dɔɔ́ŋ, bí nde né bɔ́ bagaà teèn bɔɔ́. Á, dé mò nɔ, béh bí nde cu née he wa? ");
INSERT INTO mcu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bí kwá à bɔɔ́; hên né njií mé à bɔɔ́ komo né dé seèn. À mè kómó yoòr mân yurú njií né, te nyegé njií mé gò mò ké te sà mene. ");
INSERT INTO mcu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mè né tueé ye bí a, bèh mé Njàgà Bagaà nde né teèn ká lè wɔ́ŋe dɔɔ́ŋ ŋgulí ndeé, nde né mé njàgà ma hên mene ŋgulí bilí, te bɔ̀ nùàr munó den bú teèn.» ");
INSERT INTO mcu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yeé baá ménâ, Júdàs Iskariô mbɔ̀ŋ cén déì lètenè bɔ̀ yulà cùɔ̀b fà bɔ̀ doô, nde ké yoòr bɔ̀ ŋgàŋ sèmè dé kokoô ndɔ, ye te nyí go haá bɔ́ Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bɔ́ yeé nde ŋgweé njií mân, temé yila bɔ́ lè vɔgɔ̂, bɔ́ ye bɔ́ nde né bú kàgàlɔ̀ŋ teèn haá yií ma. À yila lom baá-re ceér fɔɔ̂n, te à jɔgɔ yií Yeésò beè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sâ cieé bú toò jɔ̀gɔ̀ mé bɔ́ yieé yeé breêd mé kulu teèn sam, waà baá kèn. Bɔ́ né yeé huaán sòrŋgaàŋ teèn ŋɔɔ́b, te bɔ́ yieé Páskà mé njéh. Cieé sâ yeé waà baá, bɔ̀ mbɔ̀ŋ ye Yeésò a: «Wò ye, béh ndé nyégé kwá nyí bèh Páskà yieê he wa?» ");
INSERT INTO mcu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yeésò tueé njií mé bɔ̀ mbɔ̀ŋ fà déì ndɔ, ye bɔ́ a: «Bí ndé ké lɔ, bí bɔ̀ nuaré déì nde né mé lɔ̀ nòmò felè kwaré, bí bèlè sìè bú. ");
INSERT INTO mcu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gwà mé à yila nde né teèn, bí júée nùà gwà sâ a: Nùà fèh-njèh ye júée wò a, bɔ́ bɔ̀ mbɔ̀ŋ nyî Páskà yieé nde né te gwà dé heè wa? ");
INSERT INTO mcu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","À nde né bí gwà dé koô mân feh, né ké ter felè mbeî; bɔ́ njèh dɔɔ́ŋ nyegé gi aá gwò kèn. Bí nyégé kwá béh yáb doó sâ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bɔ̀ mbɔ̀ŋ fɔɔ́n gò ndɔ, bɔ́ nde ké lɔ, bɔ́ kwa gi ka dɔɔ́ŋ faá Yeésò la naâ bɔ́ tueé nɔ. Bɔ́ nyegé kwaá baá-re yáb Páskà teèn. ");
INSERT INTO mcu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yeé baá liyilì, Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn yulà cùɔ̀b fà wa giì ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bɔ́ yeé baá yáb yieé, Yeésò ye bɔ́ a: «Mè né tueé ye bí a, nùà cén lètenè biì nde né mè go sɔm. Béh bɔ́ dɔɔ́ŋ mé ŋgàb cên yieé bilí den né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bɔ́ yeé ŋgweé aá môn, kuún curú gi bɔ́ toò, nùà kàn duɔɔ́m mé Yeésò bie njiî, ye bú a: «Ŋgweéh mè sam wa?» ");
INSERT INTO mcu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeésò ye bɔ́ a: «Né ka cén déì lètenè biì yulà cùɔ̀b fà hên, béh bɔ́ né mé ŋgàb cên yieé bilí. ");
INSERT INTO mcu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dé kuû, *Huaán Nùàr nde né kuú, nde né faá bɔ́ lé naá giì felè seèn nyagá kwaá nɔ. Njèh cén, nuaá mé yií keéh be teèn, jɔgɔ kwaá bú cie, nde né mé gèr mbiín kuú. Sâ, beè nùà sâ, huɔm kela né mé bɔ́ sé bú ŋàr ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bɔ́ yeé baá yáb yieé, Yeésò weh breêd, à dua Càŋ teèn, à kɔlé haá bɔ́, ye bɔ́ a: «Bí wèh, hên né ŋgàŋ yoòr mò.» ");
INSERT INTO mcu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","À jɔgɔ weh ŋgàb mbè ndɔ. À yeé vra gi aá Càŋ teèn, à haá njií bɔ́, bɔ́ ŋueé laré dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","À ye bɔ́ a: «Hên né húɔ́m mò, húɔ́m ŋgɔ̀ŋ mé Càŋ kɔ nê, ber kuú né felè bɔ̀ nùàr ŋgûn. ");
INSERT INTO mcu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mè né tueé ye bí a, mè ndeè mbè déì mân ŋúé ŋgwé ndé cú, kɔ ndeè baá dé feê ké te Lò Càŋe, mè ŋueé cu ye.» ");
INSERT INTO mcu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jomo sâ, bɔ́ de bené ndɔ, bɔ́ fɔɔ́n gò, bɔ́ ŋaá nde ké te tòr Oliviê. ");
INSERT INTO mcu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Wa ke teèn, Yeésò tueé njií mé bɔ̀ mbɔ̀ŋ seèn ndɔ, ye bɔ́ a: «Bí nde né mè durá si lɔɔ́ gií. Te mvù Càŋe né ménâ nyagá den. Càŋ ye, nyí nde né nùà mbieè wulá sɔm. Bɔ̀ mbieè seèn nde né lòù durá ŋellé le. ");
INSERT INTO mcu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sâ, mɔ mè komo yuo cu aá lè cio, mè nde né ké Galilê ndeé, bí nde mè kwa nde né ké sâ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","À yeé tueé gi aá mân, Piêr deên ndɔ, ye bú a: «Sâ mɔ bɔ̀ déì né mene wò durá si lɔɔ́, mè dé mò wò dùlà sì lɔ́ ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeésò ye bú a: «Mè né tueé ye wò a, lan mé kwaá dé jomò sé nde tuagá, sâ wò yaáŋ aá njó baá mbei tagár, ye nyí mè kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piêr den nyegé cuù ndɔ, ye bú a: «Sâ mè sam; bélɔ̀ nde mene fà dɔɔ́ŋ kuú gií, mè túé nyì ndé ŋgwéh ye mè wò kɔ́ ŋgwéh.» Bɔ̀ mbɔ̀ŋ déì tueé gi ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bɔ́ wa beré déì, bɔ́ yilá né bèh sâ Gecemanè. Wa ké teèn, Yeésò ye bɔ̀ mbɔ̀ŋ seèn a: «Bí dèn ŋgɔ́gɔ̀ hên, mè nde aá Càŋ dua weh.» ");
INSERT INTO mcu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","À weh lom Piêr mé Jâk bɔ̂ Jâŋ, bɔ́ bɔ́ nde kɔɔ́. Sâ feh baá bú ter ŋellé, à baá lom mé kú dé gècên, ");
INSERT INTO mcu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ye bɔ́ a: «Kú nde aá mè wulá. Bí dèn lè hên, bí té lɔ́m cèr.» ");
INSERT INTO mcu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","À kwaá lɔ bɔ́ doó sâ ndɔ, à kela nde ser ké toò bèh ndɔ́ŋ-ndɔ̀ŋ mân. Wa ké teèn, à die mbab nde doó, à né Càŋ dua, ye mɔ nde né bɔɔ́, te Càŋ nyí te gèr sâ yí cú. ");
INSERT INTO mcu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ye bú a: «Baá, Tele mò, njeré déì wò táré yɔ́gɔ́ bèh. Mɔ né mân, ŋgòrò sɔ̀m yeè mè ŋgàb gèr hên kwarè teèn. Mè né mene ménâ gwaán, mé njéh mene, bɔ́ sér faá wò né gwaán nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","À yeé dua sɔm aá, à cu cuù ká yoòr bɔɔ̀n, à waà, sâ bɔ́ baá gi lɔ́m; ye Piêr a: «Simɔ̂ŋ wò baá lɔ́m wa? Né mene be lɔ̂m cén, bélɔ̀ kɔɔ́ gó sɔ̀m cú wa? ");
INSERT INTO mcu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bí nyìmè dèn làŋ, bí né Càŋ dua, te *Sátàn bí mé veên táb sìè cú. Lòù sam, temé nùàr gwaán gi né njèh bagaà bɔɔ̂ dág; njèh cén, yo né yuaásé.» ");
INSERT INTO mcu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jomo sâ à kwaá lɔ bɔ́, à nde cu Càŋ dua, à dua cu ka bú faá à la naâ dua nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","À cu cuù ká yoòr bɔ̀ mbɔ̀ŋ, à waà, sâ bɔ́ baá gi cu lɔ́m, dé goó keè sam cuú. Yeé baá ménâ, bɔ́ bèh tueé keêh kwà cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","À yeé cu cuù aá dé mbei tagâr, ye bɔ́ a: «Wa hên, bí née lɔ́m ye wa? Bí cèr ká ceèr. Wulu baá kèn. Baá cu. Kènê *Huaán Nùàr nde aá beè bɔ̀ vevenê bɔ̀ yilá. ");
INSERT INTO mcu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bí wùò ter, béh nde kwa bɔ́. Kè hên baá giì nuaá mé go sɔm né mè sâ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeésò née sònò mân tueé den, Júdàs mbɔ̀ŋ cén déì lètenè bɔ̀ yulà cùɔ̀b fà bɔ̀ doô kar waà ndɔ. À né mé nùàr kókoó mbaá jomo, bɔ́ né bele mé bòù beè-beè, bɔ́ né cu mé cùgò beè ndɔ. Bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ *njí-sóù mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ tema njií né bɔ́ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sâ Júdàs mé nde né Yeésò go sɔm doô naá giì bɔ́ njií mé à sé nde né bɔɔ́ tueé kwaá, te bɔ́ ŋene kɔ Yeésò mé njéh. Sâ à la ye bɔ́ a: «Mɔ bí ŋene mè baá nuaré déì kumó vra den, sâ né bú ma. Bí kèm ndê, te bí sie yuo mé bú, bí sìè lòm bú tég.» ");
INSERT INTO mcu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Júdàs hèllè yeé waà baá, à ŋgoró nde yí kwarè Yeésò, à yilá bú, ye: «Njí fèh-njèh!» À vra kumó sie bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bɔ̀ nùàr kem sue baá-re Yeésò yoòr, bɔ́ sie bú. ");
INSERT INTO mcu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nuaré déì sɔɔ̂m bòù seèn, mvur tena si njií nuaré déì tie doó; lé naâ tie nùà seê ŋgàŋ sèmè dé koô. ");
INSERT INTO mcu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeésò deên ndɔ, ye bɔ̀ nùàr a: «Den né faá bí mé bɔ̀ bòù mé cùgò beè-beè hên kem nde giì né, te bí sie nùà yîb nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋgweéh cieé dɔɔ́ŋ mè lé njèh feh den beéh ké *gwà Càŋ koô wa? Béh bí lé naâ kɔɔ́, bí lé mè ké teèn sìè ná ŋgwêh dé keì wa? Mé njéh mene, bɔɔ́ né mân, te yuo faá né te mvù Càŋe nyagá den nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jomo sâ bɔ̀ mbɔ̀ŋ durá si lɔ gi bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huaán ndà déì né dé seèn Yeésò jomo bele ndeé. À lé yoòr naá cegê mé cɔ̀gɔ̀ wagâ. Bɔ́ yeé sie aá bú, ");
INSERT INTO mcu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","à se si lɔ cɔ̀gɔ̀ hèllè, à dula yuo doó sâ luŋturu. ");
INSERT INTO mcu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bɔ́ weh njií Yeésò ké toò ŋgàŋ sèmè dé koô ndɔ, sâ bɔ̀ ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ kokoô bɔ̀ dé lɔɔ̂ mé bɔ̀ njí-sóù baá gi ké teèn bilí den. ");
INSERT INTO mcu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piêr lé naâ Yeésò jomo bele ndɔ. Njèh cén, à lé dé seèn gɔ naâ gè jomo dàb. Wa ké lɔ ŋgàŋ sèmè dé koô, à yila nde yí cie lètenè caâ, à den nde kwarè bɔ̀ gô, à né we ŋuagá den. ");
INSERT INTO mcu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sâ bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ dɔɔ́ŋ né lom ŋgòr fɔɔ́n, te bɔ́ sie Yeésò mé njéh, bɔ́ wula bú teèn. Mé njéh mene, ka yíé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nùàr ŋgún né mene bú nyeén yoòr cɔré kwaá, nyeén hèllè nde yuo seér lètenè bɔɔ̀n mé sòn hihiné. ");
INSERT INTO mcu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bɔ̀ déì né ter komó wuo, bɔ́ né felè seèn lòù tueé gobó seér, ye: ");
INSERT INTO mcu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Béh lé naâ sònò seèn ŋgweé, à lé ye, gwà Càŋ dé koô mé bɔ̀ nùàr lé meè naâ kɔɔ́ hên, nyí nde né tulú sɔm. Lè cieé tagár wa, nyí nde cu né déì ter meé kwaá; wa dé sâ bɔ̀ nùàr bú kɔɔ́ mé ndé cú ma.» ");
INSERT INTO mcu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bɔ́ né mene ménâ tueé, dɔɔ́ŋ né gi mé sòn hihiné. ");
INSERT INTO mcu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋgàŋ sèmè dé koô komo wuo ter lètenè bɔ̀ nùàr ndɔ, ye Yeésò a: «Bɔ̀ nùà hên né wò yoòr tueé njií mân, wò sòn kòmò bèh wa? Bɔ́ ye naàn á?» ");
INSERT INTO mcu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mé njéh mene, Yeésò lom bú sòn kòmò ŋgwéh gùm dɔɔ́ŋ. Yeé baá ménâ, ŋgàŋ sèmè dé koô doô ye bú a: «*Nùà Cɔ̀ŋ Ŋunà Càŋ terrèb né wò wa?» ");
INSERT INTO mcu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeésò ye bú a: «Nyí né bú sâ. Kènê bí nde aá *Huaán Nùàr ŋené njií, à nde né ké te be gaâ Càŋ terrèb den den, à cu cuù nde né loù sâ njolò biì te mvulu bègè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Te ŋgàŋ sèmè dé koô yeé nde ŋgweé njií mân, à sie ŋa cɔ̀gɔ̀ seèn nùà njèh yoòr, à né sònò tueé ye: «Sâ béh sònò bɔ̀ nùàr bie sɔɔ́ cu nde né kei wa? ");
INSERT INTO mcu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ŋgweéh béh né gi mé tie ŋgweé ma. Nùà hên né mé Càŋ ŋgeré. Wa bí ye naàn?» Bɔ̀ nùàr gwaán laré dɔɔ́ŋ, ye à die aá ju kèn, bɔ́ wúlá bú wulà. ");
INSERT INTO mcu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bɔ̀ déì deên lètenè bɔɔ̀n sâ, bɔ́ né bú dèh yoòr kulú su njií, bɔ́ vuɔb bú njolo, bɔ́ né bú tulú, ye bú a: «Ŋéné kɔ́ cú-re ŋenè, bɔ̀ neì wò tulú né kɔɔ́?» Jomo sâ bɔ̀ sɔ́jì weh yuo mé bú ndɔ, bɔ́ né bú teèn bɔlé yií. ");
INSERT INTO mcu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sâ Piêr née ka cu sâ ké túno lètenè caâ ye. Ma seê *ŋgàŋ sèmè dé koô waà doó sâ, ");
INSERT INTO mcu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ŋene bú, à né we ŋuagá den, ke nyegé bú, ye bú a: «Ŋgweéh bî Yeésò nùà Najarêt hên né yeé kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piêr cam, ye ma doô a: «Mè dé sâ kɔ́ ŋgwéh. Wò jue né-re kei wa, mè ŋgwé kɔ́ ŋgwéh ndɔ.» Jomo sâ à yuo doó sâ, à nde njebá den yí tùtúlù. Kwaá cên tuaga ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma seê doô ŋene njií cu bú, ye bɔ̀ nùàr a: «Nùà hên né cén déì lètenè bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piêr cam cu. Den ser cu jomo sâ, bɔ̀ɔ́ mé naâ teèn njebá, ye bú a: «Mé gècên mene, wò né nùà cén déì lètenè bɔɔ̀n. Lòù sam, wò né nùà Galilê.» ");
INSERT INTO mcu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piêr cam cu déì, ye bɔ́ a: «Mè sam. Mɔ mè tueé né nyeén, Càŋ a dúágá mè a kà, mè nùà mé bí né tueé hên kɔ́ ŋgwéh gùm dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","À yeé tueé sɔm aá, kwaá dé jomò tuaga ndɔ. À munó ko cu baá-re dé mé Yeésò la ye bú a: «Mé kwaá dé jomò sé nde tuagá wa, sâ wò yaáŋ aá njó baá mbei tagár, ye nyí mè kɔ́ ŋgwéh ma.» À yeé munó ko aá ménâ, à yila yueê, à yueé yueé, njolo fulú gi. ");
INSERT INTO mcu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cieé ŋaga bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ kokoô bɔ̀ dé lɔɔ̂ bɔ́ bɔ̀ *njí-sóù mé gùm mbàgà juù sâ dɔɔ́ŋ komo yuo lòù, bɔ́ bilí nde ju Yeésò ke. Bɔ́ yeé taáŋ gi aá, bɔ́ kaga bú, bɔ́ weh nde mé bú ké toò Pilátò. ");
INSERT INTO mcu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilátò bieé njií mé bú ndɔ, ye bú a: «Mgbè bɔ̀ Jûf né wò wa?» Yeésò ye bú a: «Wò dé sâ tueé né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sâ bɔ̀ ŋgàŋ sèmè dé kokoô né lom njèh ŋgún mé bú sií njií. ");
INSERT INTO mcu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Te Pilátò nde cu ye mé bú tueé njií, ye bú a: «Bɔ́ né mé wò sií njií den, wò né ŋgweé, wò sòn kòmò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mé njéh mene, Yeésò sòn kòmò cú. Dé sâ hiím yɔgɔ́ cu Pilátò mbaá. ");
INSERT INTO mcu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sâ te cu *Páskà dɔɔ́ŋ, Pilátò né yeé nùà gwà cibì cén yi njií. Né yeé nuaá mé bɔ̀ lɔɔ́ bɔ̀ ye yì bú yiì. ");
INSERT INTO mcu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nuaré déì lé naâ teèn, yilí seèn né Barabâs. Bɔ́ bɔ̀ wúlá-feh bɔ̀ déì lé naâ bɔ̀ lɔɔ́ bɔ̀ soób, bèmè die teèn lɔɔ́ dɔɔ́ŋ, nùàr kuú teèn. Bɔ́ yií bɔ́ gwà cibì mé njéh. ");
INSERT INTO mcu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yeé baá môn, cìlì nùàr ŋaá nde baá-re ké yoòr Pilátò ndɔ, bɔ́ dua bú, te à bɔɔ́ cu bɔ́ faá bèh jomò nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilátò ye bɔ́ a: «Bí ye mè a, yì njí bí Mgbè bɔ̀ Jûf wa?» ");
INSERT INTO mcu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Lòù sam, à lé naá giì kɔɔ́, ye bɔ̀ ŋgàŋ sèmè dé kokoô bunó né Yeésò lòù, wa bɔ́ bú ká beè nyî sie haá njií né dé cî. ");
INSERT INTO mcu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","À yeé baá ménâ bieé, bɔ̀ ŋgàŋ sèmè dé kokoô soób seér cu bɔ̀ nùàr lòù, ye bɔ́ a: «Bí júée Pilátò a: yì njí sér bí Barabâs ma.» Bɔ́ tueé Pilátò ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilátò ye bɔ́ a: «Á, dé nuaá mé bí yilá né Mgbè bɔ̀ Jûf hên nɔ, mè bɔɔ́ nde né mé bú kei wa?» ");
INSERT INTO mcu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bɔ́ tueé bomo njií ké ter, ye bú a: «Fágá njí bú te toû!» ");
INSERT INTO mcu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilátò ye bɔ́ a: «À veên bɔɔ́ naâ kei wa?» Mé njéh mene, bɔ́ kɔ lom né ké ter lɔgɔ́ njiî, ye bú a: «Fágá njí lòm bú te toû dé fagâ!» ");
INSERT INTO mcu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yeé baá môn, Pilátò yi njií bɔ́ Barabâs ndɔ, ye te temé huɔm bɔ̀ nùàr lè. Jomo sâ ye bɔ́ tégé Yeésò núr, bɔ́ ndé fágá njí-re bú ké te toû sâ. ");
INSERT INTO mcu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bɔ̀ sɔ́jì weh nde mé Yeésò ké lè bɔ̀gɔ̀ ŋgɔ́mnà, bɔ́ yilá bilí gi bɔ̀ mbaábɔn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bɔ́ su bú cɔ̀gɔ̀ déì bèlèsé mân. Bɔ́ nde fɔɔ́n wellê bɔ̀ ŋùàgà, bɔ́ beéh faá tàm nɔ, bɔ́ sulí kwaá bú felè, bɔ́ ye né tàm mgbè ma. ");
INSERT INTO mcu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bɔ́ né bú mbaàn haá, ye bú a: «Sìè ŋgób, Mgbè bɔ̀ Jûf!» ");
INSERT INTO mcu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bɔ́ né bú mé gor felè lurú, bɔ́ né bú dèh yoòr kulú njií, bɔ́ né toò seèn cemmé ndeé, bɔ́ né ké doó leéb suagá. ");
INSERT INTO mcu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bɔ́ yeé selé wulu aá bú, bɔ́ huar sɔm cu bú cɔ̀gɔ̀ bèlè hèllè yoòr, bɔ́ su cu bú cɔ̀gɔ̀ dé seèn. Jomo sâ bɔ́ weh nde baá-re mé bú ké bèh sâ, te bɔ́ faga wula bú. ");
INSERT INTO mcu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bɔ́ yeé baá mé Yeésò weh ndeé, bɔ́ bɔ̀ nùà Sirên déì kwaré, yilí seèn né Simɔ̂ŋ, à né telè Alesándà bɔ̂ Rúfùs; sâ à naâ ŋueh. Bɔ́ bɔ́ yeé kwaré baá, bɔ́ sie ba haá bú toú mé bɔ́ nde né Yeésò teèn fagá doô. ");
INSERT INTO mcu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bɔ́ wa beré déì, bɔ́ yilá né bèh sâ Gɔ́lgɔ́tà. Sâ tueé né ye: Gebá feèh. ");
INSERT INTO mcu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bɔ́ ye te bɔ́ haá bú mbè mé lèh déì teèn faá nó nɔ, à berɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jomo sâ bɔ́ faga njií bú te toû, bɔ́ vu geé weh gi bɔ̀ cɔ̀gɔ̀ seèn mé bèì. ");
INSERT INTO mcu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bɔ́ lé bú fagà naâ sâ lou baá lɔ̀ŋ tárènèà maánjɔ̀gɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bɔ́ nyagá fagá kwaá njeré déì ké teèn, te se kwɔ̀m cioò seèn, ye: «Né Mgbè bɔ̀ Jûf.» ");
INSERT INTO mcu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɔ́ faga njií bɔ̀ yíb wúlá-feèh bɔ̀ déì fà kwarè seèn, dé kàn mé toú seèn, déì te be gaâ, déì te be ŋgoù, Yeésò lètenè.  ");
INSERT INTO mcu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sâ dɔɔ́ŋ yuo gi né faá né te mvù Càŋe nyagá den nɔ, ye: «Bɔ́ bú kulá yií keéh né lètenè bɔ̀ vevenê bɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nuaá mé kela doó sâ dɔɔ́ŋ né feh jilí, né Yeésò teèn selé yií. Nùà kàn ye bú a: «Cècàgà, ŋgweéh wò lé ye nyí nde né *gwà Càŋ koô tulú, te nyí me sɔm cu bú te cieé tagáre wa? ");
INSERT INTO mcu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yìlì sɔ̀m-re feh yeè yilì. Jɔ̀gɔ̀ súágà ke yí te toú sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù né bú gbêg ménâ haá taré ndɔ, bɔ́ né lètenè bɔɔ̀n tueé kuú, ye: «À kɔ cegé né bɔ̀ nùàr yili sɔɔ̀m, à feh dé seèn nùà njèh yìlì sɔ̀m kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","*Nùà Cɔ̀ŋ Mgbè bɔ̀ Iserálà bɔ̀ a: súágà-re kènê yí te toú sâ, béh ŋene njolò, te béh kwaá njií temé yoòr seèn.» Bɔ̀ɔ́ mé né kwarè seèn fagá den doô né taré bú ménâ selé keéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lou yeé dilí baá, lou cib cu. Cibí yili laré cu ká doó dɔɔ́ŋ, yili sɔɔ́ gùm yɔ̀ŋ loù tagâr. ");
INSERT INTO mcu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yeé baá mé lou lɔ̀ŋ tagár, Yeésò sɔm hueh mé terreb, ye: «Eloyî, Eloyî, lemá sàbátànî?» Sâ tueé né ye: «Càŋ mò, Càŋ mò, bɔɔ́ né naàn mé wò si lɔ né mè wa?» ");
INSERT INTO mcu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bɔ̀ nuaré déì lètenè bɔ̀ɔ́ mé né doó sâ yeé ŋgweé aá ménâ, bɔ́ ye: «Ŋgwé, à baá *Elî yilá.» ");
INSERT INTO mcu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cén déì nde dula dɔm wellê fùlù, à yií njií te mbè déì tanésé mân, à feéh kwaá te toû, à tiím haá njií mé bú, te à njuar weh, à né sònò tueé ye: «Bí kwá, béh jɔ̀gɔ̀ ke ke, kɔ ŋgweé Elî sâ ndeè né waâ, à mvelé sɔm bú te toú wa?» ");
INSERT INTO mcu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeésò ŋga cu mé terreb, jomo sâ à kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cu sâ cɔ̀gɔ̀ *gwà Càŋ koô keér geé lèbɔ̂lé, yuoô ké ter, nde ba ké doó. Cɔ̀gɔ̀ sâ né kɔ̀ŋ, né yeé mɔ̀ ké gwà Càŋ cií leér. ");
INSERT INTO mcu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sâ kwaá-taâb bɔ̀ Rɔ̂m bɔ̀ déì né kwarè Yeésò njebá den. À yeé ŋene Yeésò kuú aá ménâ, ye: «Mé gècên mene nùà hên né ŋunà Càŋ bɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ké teèn sâ bɔ̀ véh lé naâ teèn ndɔ, bɔ́ né ké bèh ndɔ́ŋ-ndɔ̀ŋ njebá ke den. Lé naâ bɔ̀ Marî Magdalâ bɔ̂ Marî meì Jâk dé maàn bɔ̂ Josê dìm Jâk; bɔ́ bɔ̀ Salomê mé bɔ̀ déì ŋgún lé naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Cu mé Yeésò lé naâ ké Galilê, bɔ́ lé naâ jomo seèn, bɔ́ né bú gam. Bɔ́ bɔ́ lé ká Jerusalem waà naâ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sâ lou yuɔm gi aá, lé naá cuù mé nàŋ *cieé sóù mene ndɔ. ");
INSERT INTO mcu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yeé baá ménâ, Josêf nùà Arimatê waà. À lé naâ nùà koô déì te *mbàgà juù, bɔ́ né yeé sòn seèn ŋgweé dé gècên, à né yeé njolo mé *Lò Càŋ ke den ndɔ. À yeé waà baá, à kaga njolo, à nde ké yoòr *Pilátò, à dua bú komó Yeésò. ");
INSERT INTO mcu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Te Pilátò yeé nde ŋgweé njií, ye Yeésò kuú aá kèn mân, geí yɔgɔ́ bú. À yilá njiî kwaá-taâb hèllè, ye bú a: «Yeésò naâ kuú wa?» ");
INSERT INTO mcu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","À yeé ŋgweé nyegé aá sònò kwaá-taâb doô, ye Josêf a: Ndé jɔ́gɔ́ wèh seèn komó sâ jɔgɔ̀ ma. ");
INSERT INTO mcu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josêf nde ŋge wellê cɔ̀gɔ̀ nyɔ́gɔ̀r mân ndɔ, à mvuale sɔm komó te toû, à vuɔb nyegé bú mé njéh, à jɔgɔ yií njií bú gè dòù lè sà. Bɔ́ lé sà sâ kweè naâ kweéh. À teré ferá kwaá taá sònòbɔ̀. ");
INSERT INTO mcu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sâ né njolò Marî Magdalâ bɔ̂ Marî meì Josê. Bèh mé bɔ́ lé naâ bú teèn yií njií, bɔ́ lé naâ ŋené kwaá. ");
INSERT INTO mcu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cieé sóù sâ yeé kela baá, Marî Magdalâ bɔ̂ Marî meì Jâk bɔ́ bɔ̀ Salomê nde ŋge wellê bɔ̀ kómó múmû, te bɔ́ nde komó Yeésò mé njéh waá nyegé. ");
INSERT INTO mcu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cieé ŋaga mé sɔ́ndè bɔ́ komo yuo, bɔ́ nde ké te sà, sâ lou baá ŋagá. ");
INSERT INTO mcu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bɔ́ né lètenè bɔɔ̀n tueé kuú, ye: «Te neì béh taá sònò sà teré sɔm nde né kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bɔ́ yeé wa, bɔ́ kwa tàgèrà taâ hèllè baá gi ké jomo komo den. ");
INSERT INTO mcu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bɔ́ yila nde gè dòù ndɔ, bɔ́ ŋene njií huaán ndà déì né kèb be gaâ den den, à né mé cɔ̀gɔ̀ wulésé mân yoòr. Bɔ́ yeé nde ŋene njií bú ménâ, veéh bɔɔ́ bɔ́ njèh. ");
INSERT INTO mcu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","À ye bɔ́ a: «Bí té vèh. Ŋgweéh bí fɔɔ́n né Yeésò nùà Najarêt mé bɔ́ lé naâ fagá wulá doô mà. À komo yuo aá lè cio, à doó hên sam cuú. Bí kè njí bèh mé bɔ́ lé naâ bú teèn cer kwaá hên nɔ. ");
INSERT INTO mcu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bí ndé túé bɔ̀ mbɔ̀ŋ seèn mé Piêr mene, bí júée bɔ́ a: à nde né toò kelá, à nde ké Galilê. Bí ndé ké teèn, bí nde ŋene nde né bú ké doó sâ. Né faá à lé naâ bí tueé nɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bɔ́ yuo kelà gè dòù ndɔ, bɔ́ fɔɔ́n doò, dùlù né bɔ́ yoòr su, bɔ́ né bené, bɔ́ nuaré déì túé ŋgwéh ndɔ. Lòù sam, veéh lé naá loôm bɔ́ njèh bɔɔ́ dé gècên.  ");
INSERT INTO mcu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yeésò yeé komo yuo aá lè cio mé loù sɔ́ndè toò cieê mân, à ŋené yuo kela lɔgɔ̂ toò Marî Magdalâ. À lé naâ Marî sâ càŋ téhbeh yoòr kwɔgɔ́ sɔm. ");
INSERT INTO mcu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Marî yeé ŋene aá bú ménâ, à nde mé bɔ̀ mbaábɔn tueé, sâ bɔ́ né mbà yueé. ");
INSERT INTO mcu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","À né mene bɔ́ tueé, ye bɔ́ a, Yeésò baá cu mé njolo, nyí naâ bú ŋené, mé njéh mene bɔ́ temé teèn kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jomo sâ Yeésò nde ŋené yuo kela cuù gèh déì toò bɔ̀ mbɔ̀ŋ déì fà, sâ bɔ́ né te lɔɔ́ maàn déì ndeé den. ");
INSERT INTO mcu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bɔ́ yeé ŋene aá bú, bɔ́ cu cuù, bɔ́ tueé cu mé bɔ̀ mbeí. Bɔ́ cu temé teèn kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yeésò nde ŋené yuo kelà baá-re toò bɔ̀ mbɔ̀ŋ dé yulà cùɔ̀b cên doô, sâ bɔ́ né yáb yieé. À né bɔ́ mé táré-feh bɔɔ̀n nde, ye bɔ́ a: «Bɔɔ́ né naàn mé bɔ́ né mene bí tueé, ye bí a, bɔ́ naâ mè mé njolo ŋené, bí temé teèn kwá njí ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jomo sâ à ye bɔ́ a: «Bí ndé Njàgà Bagaà mé bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ se yɔŋ. ");
INSERT INTO mcu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nuaá mé nde né temé teèn kwaá njií, bɔ́ kou bú nòmò Càŋ, nde né yili yuo. Nuaá mé dé seèn temé teèn kwá njí ndé ŋgwéh, nde né ju die. ");
INSERT INTO mcu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bɔ̀ɔ́ mé nde né temé yoòr mò kwaá dɔɔ́ŋ nde né fém bɔɔ́: bɔ́ nde né tándulu mé yilí mò kwɔgɔ́; bɔ́ nde né leba juù hihiné tueé. ");
INSERT INTO mcu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bɔ́ né mene sàb mé be sie, bɔ́ né mene kwɔbé naga, njeré déì bɔ́ bɔ́ ndé ŋgwéh. Bɔ́ nde né be felè bɔ̀ beén bɔ̀ baá, bɔ̀ beén bɔ̀ sâ nde né taré yuo ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Fehtoò beèh Yeésò yeé tueé gi aá bɔ́ mân, à komo ŋaá yuo ké te vulúu ndɔ, à nde den nde ké te be gaâ Càŋe. ");
INSERT INTO mcu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bɔ̀ mbɔ̀ŋ yuo nde baá-re bèh dɔɔ́ŋ, bɔ́ né Njàgà Bagaà se yɔŋ. Fehtoò beèh né be te seé bɔɔ̀ne kwaá, bɔ́ né fém mé terreb seèn bɔɔ́ bele, te feh keéh ye, njií mé bɔ́ né tueé dɔɔ́ŋ, né gi ŋgòr gècên.");
INSERT INTO mcu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tele mò Teofîl, kɔ́ɔ ye, bɔ̀ njií mé lɔ naâ ká lètenè beèh kelá dɔɔ́ŋ, nùàr ŋgún lɔ naá giì dèbbè sâ ter nyagá kwaá. ");
INSERT INTO mcu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bɔ́ dɔɔ́ŋ tueé gi né nénág faá bɔ̀ɔ́ mé lɔ naâ ké bèh duɔɔ̂m ŋené doô lé tueé naâ béh nɔ; Càŋ lɔ seé sâ haá naâ beè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mè yeé ŋene aá ménâ, mè nde cu ké jomo lè ndège fugo fɔɔ́n ndɔ. Kènê tele mò, kwá mè bɔ̀ njií sâ dɔɔ́ŋ nyagá kwaá bècénè te sòn mbeî, ");
INSERT INTO mcu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","te wò kɔ ye, bɔ̀ njií mé bɔ́ lé naá giì wò feh dɔɔ́ŋ né gi bɔ̀ ŋgòr gècên. ");
INSERT INTO mcu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cu sâ *Herôde lé mgbè te tàbè Judê ceér naâ kɔɔ́. Sâ nuaré déì né teèn, yilí seèn né Jakarî, à lé naâ *ŋgàŋ sèmè te bɔ̀ŋ bɔ̀ Abíà. Yilí veèh seèn lé naâ Elísábè; à dé seèn né ndùté ndùtù *Arɔ̂ŋ, ŋgàŋ sèmè dé koô. ");
INSERT INTO mcu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bɔ̂ veèh fà dɔɔ́ŋ lɔ naá giì bɔ̀ gècên bɔ̀ toò Càŋ, bɔ́ lé *sóú Càŋ mé ŋgòr Càŋ jolo ka beéh nág faá tueé nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bɔ̂ veèh fà dɔɔ́ŋ lé naá giì kulí, bɔ́ huaán ŋàr kwà ŋgwéh. Lòù sam, Elísábè lé naâ ŋgiín. ");
INSERT INTO mcu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cieé déì seé ŋgàŋ sèmè lé bɔɔ́ naâ bɔ̀ŋ bɔ̀ Jakarî. Lòù sam, lé naâ toò bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bɔ́ yeé nde aá san ŋgie, bɔ́ vu bèì faá gènnè bɔɔ̀n né tueé nɔ. Bɔ́ yeé vu cu aá bèì loù sâ, Jakarî yieé kɔɔ́. À komo wuo ter, à yila nde yí gwà Càŋ koô, bèh san ŋgieè. ");
INSERT INTO mcu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sâ te cu san ŋgieè sâ, cìlì nùàr né dé bɔɔ̀n ká cie, bɔ́ né Càŋ dua. ");
INSERT INTO mcu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jakarî yeé baá yí lè mɔ̀ san ŋgie, cìlì Càŋ Nùà Dueè ŋené yuo kelà kwarè kɔɔ̀, kèb be gaâ mân. ");
INSERT INTO mcu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jakarî ndɔɔ́. Veéh yeé baá bú sie, feh ŋellé bú ter. ");
INSERT INTO mcu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Cìlì Càŋ ye bú a: «Té vèh Jakarî, Càŋ ŋgweé aá duaà yeè: Elísábè veèh yeè nde né huaán dé siîb ŋar, wò yilá bú Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wò nde né mé bú sagár kelá, bɔ̀ nùàr nde né mé huaán sâ samé kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Lòù sam, à beè Càŋ Dueè nde né nùà dueè. À mbè kulù mé mbè tarê ŋúé ndé ŋgwéh. À dé seèn lè yuo lom ndeè né mé Cúcuí Ŋagâ yoòr. ");
INSERT INTO mcu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","À mé dàm bɔ̀ huaán *Iserálà ŋgún ká yoòr nùà Dueè Càŋ bɔɔ̀n weh cu cuù nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","À nde né toò Càŋ mé terreb Cúcuî yoòr faá *Elî nɔ gɔ. À nde né bɔ̀ tele bɔ́ bɔ̀ huaán mé sòn cên coró bilí. À feh dilí nyegé bɔ̀ dúágá-tie bɔ̀ ceér gècên, te bɔ́ ŋa bɔ̀ didilí bɔ̀, bɔ́ kɔ Càŋ. Sâ dɔɔ́ŋ, à nyegé kwaá gi né bɔ̀ nùàr, te bɔ́ kela den Fehtoò bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Cìlì Càŋ yeé tueé gi aá, Jakarî den seér cuù ye bú a: «Hên, mè mò baá gi kuúm, veèh mò kulí gi aá ndɔ. Mè mò kɔ nde né naàn ye né ŋgòr gècên wa?» ");
INSERT INTO mcu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Cìlì Càŋ ye bú a: «Mè né Gabriya, ké toò Càŋ seé bɔɔ́ yeé mè. Càŋ ye mè a, ndê wò ŋgòr bagaà hên tueé. ");
INSERT INTO mcu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mè yeé tueé aá wò, wò saán á? Wò sòn túé ndé cú; wò kènê den nde aá mùmúr, kɔ cu mé bɔ̀ njií hên dɔɔ́ŋ ndeè yuo gi aá ménâ, sâ ye. Mè tueé wò, yuo nde né ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sâ ká cie bɔ̀ nùàr baá lòù hiím seér, bɔ́ né Jakarî kela den, bɔ́ njií mé à bɔɔ́ den né yí gwò kɔ́ cú. ");
INSERT INTO mcu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jakarî yuo kelà ndɔ, à sòn túé cú. Bɔ̀ nùàr ŋene kɔ baá-re teèn ye, yí gwò njeré déì naâ bú njolò ŋené yuo kelâ. Sâ njèh dɔɔ́ŋ, Jakarî bɔ́ me lom aá mé be mé be, sòn baá kúb. ");
INSERT INTO mcu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nde nde, bɔ̀ cieé seê seèn yeé ceré baá, à nde cu ye lɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jomo sâ veèh seèn Elísábè tomo lèì ndɔ. Veèh yeé ŋene aá ménâ, à mé njéh leér gɔ seér lòù. Wa gi mene weéh tîn, à né ka lòù leér gɔ. À ye: ");
INSERT INTO mcu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kùsèm Càŋ Dueè Fehtoò mò, à ke njií aá mè njolo yoòr, à horó sɔm aá mè fegùlì beè bɔ̀ siîb kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lèì Elísábè yeé baá weéh ténjén, Càŋ tema njií cìlì seèn Gabriya ké Galilê, te lɔɔ́ Najarêt, ");
INSERT INTO mcu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","yoòr mbò yàgà déì, yilí seèn né Marî. Bɔ́ sua kwaá né bú lòù ye. Yilí si seèn né Josêf, à né lè gèh bɔ̀ nùàr mgbè *Davîd. ");
INSERT INTO mcu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Cìlì Càŋ wa ké teèn, yila nde gwò yoòr Marî, ye bú á: «Kùsèm mè né wò bieé, wò né mé fùgò beè Càŋ. Nùà Dueè né jomo yeè.» ");
INSERT INTO mcu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Te Marî yeé nde ŋgweé njií gèh njàb bú sâ, feh ŋellé bú ter; ye sâ né gèh bieê kei wa. ");
INSERT INTO mcu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Cìlì Càŋ ye bú a: «Té vèh Marî, njolo Càŋ né yoòr yeè. ");
INSERT INTO mcu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wò nde né ma mé lèì hueêh ŋaá, wò ŋar huaán dé siîb, wò yilá bú Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","À nde né nùà dueè kɔɔ́; bɔ́ bú dé seèn yilá nde né ŋunà Càŋ nùà njèh ké ter te vulúu. Càŋ Dueè nde né bú kɔgɔ jɔ̀gɔ̀ bɔ̀ seèn *Davîd haá. ");
INSERT INTO mcu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","À felè bɔ̀ huaán *Iserálà dé cu dɔɔ̂ŋ cer lom nde aá kɔɔ́; kɔgɔ dé seèn baá dé kèì cên ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marî ye cìlì Càŋ a: «Mè née mò siíb kɔ́ ŋgwéeh ye nɔ, gèh dé sâ bɔɔ́ seér nde né naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Cìlì Càŋ ye bú a: «Cúcuí Ŋagâ ka waà nde né felè yeè kɔɔ́, terreb Càŋ ké ter te vulúu nde né cemé felè yeè si. Huaán mé wò nde né ŋar sâ, né dé cî mé bɔ́ bú yilá nde né nùà joloò, Ŋunà Càŋ Dueè. ");
INSERT INTO mcu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elísábè meí yeè né mé lèì ndɔ. À baá gi mene kuúm, mé njéh mene lèì seèn kènê baá weéh ténjén, à nde né huaán dé siîb ŋar. Sâ bɔ̀ nùàr lɔ ye, ma ŋgiîn huaán ŋar nde cu né he wa? ");
INSERT INTO mcu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mè tueé wò, njií mé né Càŋ yɔgɔ́ sam.» ");
INSERT INTO mcu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yeé baá mân, Marî ye bú a: «Mè né nùà seê Càŋ Dueè. Bú a, bɔ́ felè mò faá wò tueé nê nɔ.» Cìlì Càŋ kwaá lɔ bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lè mbèh sâ, Marî wuo ter kwar ndɔ, à sɔm gò, à ŋaá nde lom aá ké te bɔ̀ tòre lè lò Judê, à wa lè lò sâ, te lɔɔ́ déì. ");
INSERT INTO mcu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","À kela nde ké lɔ Jakarî, à yila kweh gwò yoòr Elísábè, à bie bú. ");
INSERT INTO mcu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te à yeé nde bie njií Elísábè mân, huaán jilí toró Elísábè lè. Cúcuí Ŋagâ samé yila bú yoòr, ");
INSERT INTO mcu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","à sɔm hueh, ye Marî a: «Càŋ ká doó lètenè bɔ̀ vêh dɔɔ́ŋ kulu kela né wò. Huaán yí lè yeè sâ, Càŋ bú nyeén gi aá kèn. ");
INSERT INTO mcu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Á hên, kè cú-re ndɔ: meì Fehtoò mò ká yoòr mò kɔɔ́ nde seér cuù né dé keì? ");
INSERT INTO mcu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kè kú, wò yeé baá mè bieé, huaán samé toró gi mè ká lè. ");
INSERT INTO mcu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Njua yeè wa, wò né sòn Càŋ ŋgweé, wò né ndèm kwaá njií, ye njií mé Càŋ lé tueé naâ nyí dɔɔ́ŋ, à nde né bɔɔ́ gií ma.» ");
INSERT INTO mcu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marî deên ndɔ, ye: «Môn, mè né Nùà Dueè mé temé mò mene seén. ");
INSERT INTO mcu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Temé mò né mé Càŋ Yìlì-nùàr sagár dé gècên, à mè yili sɔm aá kèn. ");
INSERT INTO mcu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Lòù sam, mè mbátágà nùà seê seèn mbaá, ye nyí nde né njolo yoòr mò ke njií. Ŋgweéh kènê mbelèm nùàr hihiné nde aá mè bèh dɔɔ́ŋ keí laré mà. ");
INSERT INTO mcu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Lòù sam, Càŋ terrèb né be seèn felè mò sɔm keêh. Yilí seèn né jolosé. ");
INSERT INTO mcu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Cu dɔɔ́ŋ Càŋ nde né bɔ̀ ŋgwé-tie bɔ̀ jere kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Càŋ terrèb baá lè seé seèn mé be seèn. Bɔ̀ dúágá-tie bɔ̀ baá mé njéh lòù ndugó seér. ");
INSERT INTO mcu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ndègè bɔ̀ mgbè bɔɔ̀n calé baá kèn. Càŋ mò baá bɔ́ doó komó su njií. À ter sɔm njií seér bɔ̀ lòù bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bɔ̀ɔ́ mé cùè né bɔ́ sie, à né bɔ́ koó. À jomo be be kwɔgɔ njií seér bɔ̀ lilieê bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","À hên ndeè *Iserálà nùà seê seèn gam, à né bú munó, à né béh jere kɔɔ́, ");
INSERT INTO mcu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","faá à lɔ tueé kwaá naâ mé tele beèh Abrahâm bɔ́ bɔ̀ ŋuna seèn nɔ, ye nyí nde né bɔ̀ ndùté ndùtù bɔɔ̀n gam, nyí gam den nde né bɔ́ dé nyèmà mé nyèmà.» ");
INSERT INTO mcu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marî bɔ̂ Elísábè bɔɔ́ ké sâ weéh tagár, à nde cu ye lɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cu ŋaàr Elísábè yeé waà baá, à ŋar kwa huaán dé siîb. ");
INSERT INTO mcu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bɔ̀ nùàr seèn mé bɔ̀ mbeí seèn yeé nde ŋgweé njií gèh bagaà mé Càŋ Dueè naâ Elísábè bɔɔ́ sâ, bɔ́ kem nde gi teèn, bɔ́ bɔ́ samé gi dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Huaán yeé baá cieé téndelé, bɔ̀ nùàr ndeè bú *ŋgór ŋɔɔ́b, bɔ́ ye yilí seèn né cu Jakarî faá tele seèn nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Meí ye bɔ́ a: «Sam, yilí seèn né Jâŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bɔ́ ye bú a, sam ndɔ, Jâŋ yilí nùàr bɔɔ̀n déì sam. ");
INSERT INTO mcu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yeé baá ménâ, bɔ́ me bie njií Jakarî yilí huaân mé be. ");
INSERT INTO mcu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakarî me bieé njiî bɔ́ béh toû déì, à nyagá kwaá bɔ́ yilí huaân teèn, ye yilí seèn né Jâŋ. Bɔ́ hiím laré mé njéh doó dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sòn Jakarî komo lɔgɔ́ doó sâ ndɔ, à yila keéh Càŋ ké ter seén njiî. ");
INSERT INTO mcu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Veéh kwaá njií bɔ̀ nùàr be yoòr mé bɔ̀ nùàr te lɔɔ́ kukwarè mene. Ŋgɔ́g dé sâ ŋgulí yɔŋ cu lè lò Judê kèb dé ké te tòre bèh dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bɔ̀ɔ́ mé né ŋgòr hên ŋgweé dɔɔ́ŋ, né ké lè munó, ye huaán bú sâ ndeè nde né naàn wa? Mé gècên mene, à lé yoòr naâ mé terreb Nùà Dueè. ");
INSERT INTO mcu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cúcuí Ŋagâ samé yila Jakarî tele huaân yoòr ndɔ, à yila ŋgòr *sòn-Càŋ tueê, ye: ");
INSERT INTO mcu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Bí sén Nùà Dueè, Càŋ bɔ̀ huaán *Iserálà seèn; njolo seèn né yoòr bɔɔ̀n, à bɔ́ yili sɔm aá kèn. ");
INSERT INTO mcu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","À nùà terrèb mé nde né béh yili sɔm ŋagá sɔm keéh né lètenè bɔ̀ ndùté ndùtù mgbè *Davîd nùà seê seèn, ");
INSERT INTO mcu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","te yuo faá à lé naá giì sònò bɔ̀ sòn-Càŋ bɔ̀ léí toò tueé keéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","À lɔ ye, nyí nde né béh toò bɔ̀ bùnò bɔ̀ mvelé sɔm; wa bɔ̀ɔ́ mé né béh bar dɔɔ́ŋ terreb felè beèh kwà ndé ŋgwéh ma. ");
INSERT INTO mcu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sâ dɔɔ́ŋ ye te nyí kɔ bɔ̀ jɔ̀gɔ̀ bɔ̀ jere, te ŋgɔ̀ŋ nyî mboón faá jolo nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sâ lé naâ jègè seèn toò Abrahâm tele beèh dé koô, ");
INSERT INTO mcu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wa nyí ndé né béh beè bɔ̀ bùnò bɔ̀ mvelé sɔm, ye te béh bɔɔ́ seé nyî, béh vèh cú; ");
INSERT INTO mcu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","te cieé dɔɔ́ŋ béh beè nyî den lom jolosé, dilísé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dé yeè huaán mò, bɔ́ wò yilá nde né sòn-Càŋ, Càŋ mé terreb dɔɔ́ŋ né beè seèn. Lòù sam, wò nde né toò Nùà Dueè kelá, wò nyegé kwaá bú ceér. ");
INSERT INTO mcu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wò bɔ̀ nùàr seèn tueé nyegé nde né kɔɔ́, ye bɔ́ a, Càŋ nde né bɔ́ yili sɔm, à kulu sɔm gi bɔ́ veên yoòr ma. ");
INSERT INTO mcu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Lòù sam, Càŋ beèh né Càŋ húɔ́m-temê dé gècên, à nde né felè beèh faá ŋuerré loù nɔ baá den, ");
INSERT INTO mcu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","te bɔ̀ɔ́ mé né te cibi bèh cioò cer den yuo kela giì bèh ŋagâ, te à gule beèh lemé njií te ceér cɔ̀ŋe.» ");
INSERT INTO mcu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huaán né kulá ndɔ, temé né taré ndeé, à nde den seér ké ya dueè. Nde nde, cu yeé wulu baá, à yuo kela ye ké toò bɔ̀ huaán *Iserálà bèh ŋgòr Càŋ seè. ");
INSERT INTO mcu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lè nàm sâ Sesár Agûstè lé naâ nyàgà-nùàr dé wɔ́ŋ dɔɔ̂ŋ yie. ");
INSERT INTO mcu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lé naâ nyàgà-nùàr dé toò jɔ̀gɔ̀. Sâ mgbè te tàbè Sirî né Kirinûs. ");
INSERT INTO mcu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ye nùà kàn a, ndé yilí seèn lɔ seèn nyagá kwaá ma. Neì dɔɔ́ŋ né lɔ seèn yuo ndeé. ");
INSERT INTO mcu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josêf dé seèn yuoô ké Galilê lè lɔɔ́ Najarêt, à né te lò Judê ŋaá ndeé, à nde né ké Betelehem lɔ mgbè *Davîd tele bɔɔ̀n dé léí jɔ̀gɔ̀, ");
INSERT INTO mcu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","te bɔ́ nyagá yií bɔ̂ veèh seèn Marî jomo bɔɔ̀n. Sâ Marî né mé lèì. ");
INSERT INTO mcu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bɔ́ wa ké Betelehem ndɔ. Nde nde, cu yeé wulu baá, ");
INSERT INTO mcu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","à ŋar kwa ndoón seèn, à waga kwaá bú cɔ̀gɔ̀ yoòr, à cer kwaá njií bú te ŋgàb toû mé bɔ́ haá yeé bɔ̀ nyam nyure teèn. Sâ gwà mé bɔ̀ kìn cer yeé teèn yuú gi aá, bɔ́ bèh teèn kwà cú. ");
INSERT INTO mcu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sâ te lò Judê sâ, bɔ̀ tèŋ déì né yeé ké ya dueè ter den ŋagá, bɔ́ né bɔ̀ mbieè bɔɔ̀n ke. ");
INSERT INTO mcu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yeé baá loù sâ lètenè cibî, cìlì Càŋ Nùà Dueè déì ba kar suagà ter felè bɔ̀ tèŋ, *sùsùm Càŋ sie bɔ́, veéh kibí su bɔ́ yoòr. ");
INSERT INTO mcu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Cìlì Càŋ ye bɔ́ a: «Bí té vèh, mè ndeè bí njàgà bagaà tueé weh, nùàr dɔɔ́ŋ nde né mé njéh samé. ");
INSERT INTO mcu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lan ké lɔ *Davîd, bɔ́ ŋar aá nuaá mé nde né bí yili sɔm. Né *Kristò, *Nùà Cɔ̀ŋ, Fehtoò biì. ");
INSERT INTO mcu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bí nde né bú dé seèn ŋené kɔɔ́, né huaán mbɔgɔ̀, bɔ́ waga kwaá né bú cɔ̀gɔ̀ yoòr, à né lè ŋgàb mé bɔ́ haá yeé bɔ̀ nyam nyure teèn cer den.» ");
INSERT INTO mcu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bɔ̀ tèŋ yeé ke, bɔ̀ cìlì Càŋ ŋgún kem wa cuù aá kèn. Bɔ́ né Càŋ ké ter seén njií, ye: ");
INSERT INTO mcu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Càŋ ké ter te vulúu né duesé! Cɔ̀ŋ baá ká doó lètenè bɔ̀ yíé-temé bɔ̀ seèn.» ");
INSERT INTO mcu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bɔ̀ cìlì Càŋ yeé kem ŋagá cu aá ké te vulúu, bɔ̀ tèŋ ye: «Béh jɔ̀gɔ̀ nde ké Betelehem njií mé Càŋ Dueè né béh tueé hên ŋené wellê ye.» ");
INSERT INTO mcu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bɔ́ sɔm gò ndɔ, bɔ́ né ké lɔ ŋaá ndeé. Bɔ́ wa, bɔ́ kwa Marî bɔ̂ Josêf, bɔ́ ŋene njií tɔ́gɔtí né lè ŋgàb mé bɔ́ haá yeé bɔ̀ nyam nyure teèn cer den. ");
INSERT INTO mcu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bɔ́ yeé ŋene aá ménâ, njií mé cìlì Càŋ naâ bɔ́ felè huaân tueé dɔɔ́ŋ, bɔ́ se kwaá gi cie. ");
INSERT INTO mcu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bɔ̀ɔ́ mé lé naá giì ŋgweé dɔɔ́ŋ, geí laré bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marî bɔ̀ njií sâ dɔɔ́ŋ ŋgweé kwaá den né felè, à né teèn munó den. ");
INSERT INTO mcu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jomo sâ, bɔ̀ tèŋ fɔɔ́n cu gò, bɔ́ né ndeé, bɔ́ né Càŋ ceceér seén gɔ. Bɔ̀ njií mé bɔ́ la naâ ŋené mé bɔ́ naâ ŋgweé dɔɔ́ŋ, bɔ́ seén laré gi bú teèn. Né nág faá cìlì Càŋ la tueé naâ bɔ́ nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Huaán yeé baá mé cieé téndelé, bɔ́ *ŋɔb bú ŋgór ndɔ. Bɔ́ yilá bú yilí Yeésò faá cìlì Càŋ lɔ naá giì yilá kwaá te meí nde ye lèì seèn weh nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yeé baá te cieé mé bɔ́ *sené yeé bɔ̀ meí faá *sóú Músì lé naâ tueé nɔ, Josêf bɔ̂ Marî weh nde mé huaán ké Jerusalem te bɔ́ feh keéh bú toò Càŋ ndɔ, ");
INSERT INTO mcu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","faá né te mvù Càŋe tueé nɔ, ye bɔ̀ ndoón dé sisiîb dɔɔ́ŋ né gi bɔ̀ gà dé Càŋ ma. ");
INSERT INTO mcu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kɔ bɔ́ haá *sèmè faá sóú Càŋ tueé nê ndɔ: vɔgɔb fà, mɔ sam, kɔ́rkɔ́dɔg ma. ");
INSERT INTO mcu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sâ nuaré déì lé naâ ké Jerusalem teèn, yilí seèn né Simeɔ̂ŋ, né nùà dilî, nùà dùlà-Càŋ ndɔ. Cieé dɔɔ́ŋ, à né nuaá mé nde né *Iserálà yili sɔm kela sɔɔ́; à lé yoòr naâ mé Cúcuí Ŋagâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lé naá giì bú toò tueé kwaá, ye bú a: «Wò ndeè kú ndé ŋgwéh, kɔ wò ŋene aá *Nùà Cɔ̀ŋ mé Càŋ Dueè ndeè né temá njiî, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Loù sâ Cúcuí Ŋagâ jɔgɔ njií bú ke gwà Càŋ koô ndɔ. Josêf bɔ̂ Marî weh waà mé huaán te bɔ́ bɔɔ́ felè seèn faá sóú tueé nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeɔ̂ŋ yeé nde ŋene njií huaán mân, à jɔgɔ sie bú beè, à né Càŋ seén, ye bú a: ");
INSERT INTO mcu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Kùsèm Càŋ Dueè, kènê ndéb yeè jegé baá. Kwá nùà seê yeè yuo gò mé dɔlê mene. ");
INSERT INTO mcu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lòù sam, mè ceér cɔ̀ŋ mé njolo ŋene baá kèn. ");
INSERT INTO mcu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Wò bú nyegé kwaá né toò bɔ̀ nùàr dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Né ŋagâ mé lò nùàr wɔ́ŋ dɔɔ́ŋ nde né wò teèn ŋené kɔɔ́. Iserálà nùàr yeè be ter sɔm njií nde né mé bú ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tele bɔ̂ meí yeé nde ŋgweé njií Simeɔ̂ŋ baá felè huaân ménâ tueé, geí si njií bɔ́ doó. ");
INSERT INTO mcu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeɔ̂ŋ kulu bɔ́ ndɔ, ye Marî meí seèn a: «Càŋ huaán hên balé sɔm keêh né te ké Iserálà nùàr ŋgún dielé gi ju felè seèn; te ŋgún yili yuo gi mé bú ndɔ. À nde né cìè den. Mé njéh mene, nùà ŋgún nde né bú lòù bar seér. ");
INSERT INTO mcu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","À nde né mùnò bɔ̀ nùàr cie salé su gií. Dé yeè wò meí, loù sâ wò lè yulá nde né faá bòù taâb naâ wò sieé nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Sâ ma déì lé naâ teèn, yilí seèn né Ánà, à lé naâ *sòn-Càŋ ndɔ. Né ŋunà Fanuêl, tele bɔɔ̀n dé koô lé naâ Asêr. Ma sâ lé baá ma kuúm ndɔ, nyèmà seèn lé baá yulà téndelé cùɔ̀b nèà. À lé naâ siíb jɔgɔ́, bɔ̂ si bɔɔ́ cegé nyèmà téhbeh, si kuú kwaá lɔ bú. Ma sâ lɔ seé Càŋ bɔɔ́ beéh suútenè mé cíbítenè mene: à né gwà Càŋ yagá, à né yáb jolo, à sòn mé Càŋ duaà dù ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","À yeé nde cu aá gwà Càŋ loù sâ, à ŋene njií huaán mân, ye Càŋ a: «Kùsèm, mè vra baá wò.» Bɔ̀ɔ́ mé né cu dɔɔ́ŋ kela den, ye Càŋ nde né Jerusalem yili sɔm doô, à yila bɔ́ kùr huaân seè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josêf bɔ̂ Marî yeé bɔɔ́ gi aá faá *sóú Càŋ Dueè né tueé sâ, bɔ́ bɔ̀ huaán fɔɔ́n gò lɔɔ̂, bɔ́ cu cu ke Galilê, lè lɔɔ́ Najarêt. ");
INSERT INTO mcu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Huaán né kulá, à né taré ndeé, à né mé kékɔŋ mene kulá, à né Càŋ yoòr mé gècên mene huɔɔ́m. ");
INSERT INTO mcu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sâ nyèmà dɔɔ́ŋ bɔ̀ tele Yeésò né yeé bèh cieé koô *Páskà ké Jerusalem ndeé sɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nyèmà déì bɔ́ yeé baá cu mé gò, sâ Yeésò baá nyèmà yulà cùɔ̀b fà, à nde ké teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wa ké teèn, Páskà yeé gi aá, tele bɔ̂ meí nde cu lɔ, Yeésò le dé seèn ké sâ mé be, tele bɔ̂ meí kɔ́ ŋgwéh, ");
INSERT INTO mcu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","bɔ́ dé bɔɔ̀n ye, merré déì Yeésò bɔ́ bɔ̀ mbeí gɔ né kɔɔ́. Bɔ́ yeé baá ménâ munó, bɔ́ kɔ lom aá gò ndɔ, bɔ́ gɔ sɔɔ́ gùm cieê te bɔ́ nde ye bú lètenè bɔ̀ nùàr bɔɔ̀n fɔɔ́n, bɔ́ né bú lètenè bɔ̀ mbaábɔɔ̀n fɔɔ́n yɔŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bɔ́ yeé bú ŋéné cú, bɔ́ ŋaá nde cu bú ké Jerusalem fɔɔ́n ke. ");
INSERT INTO mcu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bɔ́ nde bú kwa baá ké *gwà Càŋ koô, sâ baá te cieé dé tagáre. À né yí lètenè bɔ̀ fèh-njèh bɔ̀ den den. Njií mé bɔ́ né feh dɔɔ́ŋ, à né felá, à né bɔ́ njèh bieé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Njií mé à lé naâ tueé dɔɔ́ŋ, lé naá giì bɔ̀ njèh nùà kɔ́gɔ̀n. Gèh kɔ́gɔ̀n bú sâ lé naâ bɔ̀ nùàr doó dɔɔ́ŋ geí laré. ");
INSERT INTO mcu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te tele bɔ̂ meí yeé nde ŋene njií bú ménâ, hiím yɔgɔ́ bɔ́ dé tueê. Meí deên ndɔ, ye bú a: «Huaán mò, sâ wò bɔɔ́ né béh kei? Kè kú, bêh tele yeè né wò ndio, béh né wò fɔɔ́n kán.» ");
INSERT INTO mcu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ye bɔ́ a: «Bí mè fɔɔ́n gɔ né mé ŋgei wa? Bí kɔ́ ŋgwéh ye, mè sé la né ká gwò Tele mò wa?» ");
INSERT INTO mcu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mé njéh mene, bɔ́ ŋgwé kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeé baá ménâ, à komo wuo ter ndɔ, bɔ́ bɔ́ fɔɔ́n gò, bɔ́ nde cu Najarêt. À ŋgweé den ka sòn bɔɔ̀n méménâ cu dɔɔ́ŋ. Bɔ̀ njií mé né kelá sâ dɔɔ́ŋ, meí né teèn munó den. ");
INSERT INTO mcu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeésò né kulá ndeé, à né kɔgɔ́n ŋaá, temé né Càŋ mé bú nɔré ndeé, né bɔ̀ nùàr mé bú nɔré ndeé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sâ mgbè dueè mé yilí né Tibér *Sesâr cer aá mgbè ké Rɔ̂m baá nyèmà yulà cùɔ̀b tîn. Cu sâ ŋgɔ́mnà ké Judê lé naâ Pɔ́nsè *Pilátò. Sâ *Herôde mgbè cer né dé seèn ké Galilê. Dìm seèn Filîp mgbè cer ké Itúrè bɔ̂ Trikonîk. Lisaniâs dé seèn lé naâ mgbè ké Abilên. ");
INSERT INTO mcu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bɔ̀ *ŋgàŋ sèmè dé kokoô cu sâ lé naâ *Hánà bɔ̂ Kayîf. Jâŋ ŋunà Jakarî né loù sâ ké ya dueè den, à ŋgweé Càŋ baá bú ŋgòr seèn sònò tueé kwaá. ");
INSERT INTO mcu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","À komo wuo ter ndɔ, à nde ké kwarè nòmò Jurdên, à né mé ŋgòr Càŋ te tàbè sâ se ndeé, ye bɔ̀ nùàr a: «Bí yúé fɔ́n feh biì yueè, bí kwéh sér temé, bí ndê, bí weh nòmò Càŋ, te Càŋ kulu sɔm bí veên yoòr.» ");
INSERT INTO mcu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hên yuo né faá Esáyà *sòn-Càŋ lé naá giì te mvù Càŋe nyagá kwaá nɔ, ye: «Hueh nuaré déì né ké ya dueè ŋgulí den, ye: Bí tɔ́ nyégé ceér nùà Dueè tɔɔ̀, bí tɔ́ dìlì nyégé bagasé! ");
INSERT INTO mcu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bí né ŋgɔbe cu yuú nyegé, bí né bɔ̀ tòr mé gbég doó legé njií, bɔ̀ ceér gogobô né tɔɔ́ dilí nyegé, bɔ̀ lùgò né ceér dueè furú nyegé, ");
INSERT INTO mcu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","te bɔ̀ nùàr ŋene kɔ gèh dé mé Càŋ ye te nyí yili sɔm bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Cìlì nùàr ŋgún kem wa giì ká yoòr Jâŋ bèh nòmò Càŋ koù ndɔ. Ye bɔ́ a: «Bí bɔ̀ gèh ŋgòbò, neì ye bí a, temé né Càŋ mé bí lè yulá, bí dùlà ndê, wanɔɔ́ŋ bí nde né gèr beè seèn ŋené wa? ");
INSERT INTO mcu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sâ bí bɔ́-re faá Càŋ gwaán nê ndɔ, te feh keéh ye, kènê bí kweéh seér aá temé kèn. Bí té mé huún biì mbaá túé kú ye: Abrahâm tele beèh dé koô né teèn. Bí kɔ́ɔ ye, Càŋ né mé terreb bɔ̀ taá hên kwellé seêr te ŋa bɔ̀ ndùté ndùtù Abrahâm. ");
INSERT INTO mcu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mè tueé bí, mbɔ̀gɔ̀ fa gi aá kèn, baá gi ka toû. Toú mé tàb dé bagaà wá ŋgwéh dɔɔ́ŋ, bɔ́ nde né bú tuar komo fuú njií.» ");
INSERT INTO mcu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Cìlì nùàr duɔɔ̂m mé bú bieé njiî ndɔ, ye bú a: «Á sâ, béh bɔ́ naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jâŋ ye bɔ́ a: «Nuaá mé cɔ̀gɔ̀ né bú beè fà, bú a, há nuaá mé njéh teèn sam cén. Mɔ né yáb, bú a, gè lòù ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bɔ̀ɔ́ mé weh yeé kàgàlɔ̀ŋ làmpɔ̂ŋ bilí wa giì, te Jâŋ kou bɔ́ nòmò Càŋ. Bɔ́ né Jâŋ ménâ bieé ndɔ, ye bú a: «Á béh nɔ, dé koô, béh bɔ́ naàn ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ye bɔ́ a: «Mɔ bí baá kàgàlɔ̀ŋ làmpɔ̂ŋ weh, bí wèh lòm ká faá *sóú tena kwaá nê nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bɔ̀ sɔ́jì né taré bú ménâ bieé ndɔ, ye: «Á dé beèh nɔ, béh bɔɔ́ nde né naàn ndɔ wa?» Jâŋ ye bɔ́ a: «Bí té bɔ̀ nùàr kàgàlɔ̀ŋ beè mbembaá wèh bèlè, bí té nuaré déì nyeén yoòr cɔ̀rè sù, bí kɔ́ lòm kàgàlɔ̀ŋ weêh biì, sâ gi aá.» ");
INSERT INTO mcu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sâ cìlì nùàr né yeé *Nùà Cɔ̀ŋ kela den ndɔ, bɔ́ ye merré déì Jâŋ baá Nùà Cɔ̀ŋ sâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jâŋ tueé ŋagá bɔ́ ndɔ, ye bɔ́ a: «Mè sam, mè dé mò bí kou lom né mé nòmò. Nuaré déì baá jomo ndeê, taré kela né bú mé mè. Né mene yuií débágâ seèn, mè wúlú ŋgwéh nuaá mé nde né yuií débágâ seèn se. À bí dé seèn kou nde né mé Cúcuí Ŋagâ bɔ̂ we. ");
INSERT INTO mcu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","À beè né mé suúŋ, à nde né mvum bɔ̂ tùlù mé njéh nyegé geé, te à kwaá mvum te mbèŋ seèn, à tùlù kobo su njií ké tuar te we mé nyímé bèh.» ");
INSERT INTO mcu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jâŋ tueé keéh baá-re bɔ́ Njàgà Bagaà te bɔ̀ ŋgòr hihiné faá bèh ménâ kókoó mbaá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sâ né bèh mé Jâŋ lé naâ mgbè *Herôde teèn nde kwa keéh. Lòù sam, Herôde lé naâ Herodiâs veèh dìm seèn Filîp gwò ŋgaá kwaá. À lé naá cuù bɔ̀ seé vevenê déì ŋgún bɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Te à nde cu ye baá-re dé koô déì saáb veé: à nde kela cu Jâŋ ké gwà cibì, à sie yií. ");
INSERT INTO mcu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cìlì nùàr yeé kou gi aá nòmò Càŋ, Yeésò yila kela ndɔ, Jâŋ kou sɔm bú. Yeésò yeé weh aá nòmò Càŋ, à yeé baá Càŋ dua, vulú gulu lɔgɔ́ ké ter, ");
INSERT INTO mcu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Cúcuí Ŋagâ yuo kelà ké teèn faá gùm vɔgɔɔ̀b nɔ, né ká felè seèn suagâ. Hueh déì né ké jomo te vulúu ŋgulí, ye: «Wò né huaán yíé-temé mò; temé mò né lè mé wò nɔré.» ");
INSERT INTO mcu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mé Yeésò lɔ nde seé duɔɔ́m, sâ à baá njèh nyèmà yulà tagár. Sâ bɔ́ lé naâ munó, ye à né ŋunà Josêf ndɔ. Josêf lé naâ ŋunà Hèlî. ");
INSERT INTO mcu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hèlî ŋunà Matatà; Matatà ŋunà Levî; Levî ŋunà Melkî; Melkî ŋunà Janayií; Janayií ŋunà Josêf; ");
INSERT INTO mcu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josêf ŋunà Matiâs; Matiâs ŋunà Amos; Àmôs ŋunà Nahûm; Nahûm ŋunà Èsèlî; Èsèlî ŋunà Naggáyì; ");
INSERT INTO mcu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggáyì ŋunà Maâtè; Maâtè ŋunà Màtàtíâs; Màtàtíâs ŋunà Semeyín; Semeyín ŋunà Josêk; Josêk ŋunà Jódà; ");
INSERT INTO mcu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jódà ŋunà Joanaàn; Joanaàn ŋunà Résà; Résà ŋunà Sorobábèl; Sorobábèl ŋunà Salatiêl; Salatiêl ŋunà Nerî; ");
INSERT INTO mcu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerî ŋunà Melkî; Melkî ŋunà Àdî; Àdî ŋunà Kósàm; Kósàm ŋunà Elmadâm; Elmadâm ŋunà Êr; ");
INSERT INTO mcu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Êr ŋunà Yeésò; Yeésò ŋunà Eliesêr; Eliesêr ŋunà Jorîm; Jorîm ŋunà Matâtè; Matâtè ŋunà Levî; ");
INSERT INTO mcu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levî ŋunà Simeɔ̂ŋ; Simeɔ̂ŋ ŋunà Júdà; Júdà ŋunà Josêf; Josêf ŋunà Jonâm; Jonâm ŋunà Elíákìm; ");
INSERT INTO mcu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elíákìm ŋunà Méléà; Méléà ŋunà Menâ; Menâ ŋunà Mátálà; Mátálà ŋunà Natân; Natân ŋunà Davîd; ");
INSERT INTO mcu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davîd né ŋunà Jésè, Jésè né ŋunà Jobêd; Jobêd ŋunà Bɔɔ̂s; Bɔɔ̂s ŋunà Salâ; Salâ ŋunà Násɔ̀ŋ; ");
INSERT INTO mcu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Násɔ̀ŋ ŋunà Aminádàb; Aminádàb ŋunà Admîn; Admîn ŋunà Arnî; Arnî ŋunà Eserɔ̂m; Eserɔ̂m ŋunà Farésà; Farésà ŋunà Júdà; ");
INSERT INTO mcu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Júdà ŋunà Jakɔ̂b; Jakɔ̂b ŋunà Isâk; Isâk ŋunà Abrahâm; Abrahâm ŋunà Tárà; Tárà ŋuna Nakɔ̂r; ");
INSERT INTO mcu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakɔ̂r ŋunà Serûk; Serûk ŋunà Rágò; Rágò ŋunà Falêk; Falêk ŋunà Èbèr; Èbèr ŋunà Salâ; ");
INSERT INTO mcu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salâ ŋunà Kayinâm; Kayinâm ŋunà Arfasâk; Arfasâk ŋunà Sêm; Sêm ŋunà Noê; Noê ŋunà Lamêk; ");
INSERT INTO mcu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamêk ŋunà Matusálà; Matusálà ŋunà Hénɔ̀k; Hénɔ̀k ŋunà Jarêd; Jarêd ŋunà Maleleêl; Maleleêl ŋunà Káyínàn; ");
INSERT INTO mcu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Káyínàn ŋunà Enôs; Enôs ŋunà Sêtè; Sêtè ŋunà Ádàm. Ádàm dé seèn né ŋunà Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bɔ́ yeé kou sɔm aá Yeésò nòmò Càŋ, à yuo kelà ké sòn nòmò Jurdên ndɔ, sâ Cúcuí Ŋagâ baá gi bú yoòr ŋgulí den, derré njií bú ké ya dueè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","*Sátàn né bú mé veên ké teèn cieé yulà nèà taáb sɔɔ́. À njeré déì sònò nágá kéh ŋgwéh. Bɔ̀ cieé sâ yeé gi aá, cùè yila bú sieè. ");
INSERT INTO mcu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sátàn ye bú a: «Mɔ wò né ka Ŋunà Càŋ bɔ̀n, jɔ̀gɔ̀ júé ke ye taá hên a, ŋá ke sér ye.» ");
INSERT INTO mcu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeésò ye bú a: «Né te mvù Càŋe nyagá den ye: Nùàr mé ndândaà sêr yìlì lòm ndé ŋgwéh ma.» ");
INSERT INTO mcu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sátàn nde weh ŋaá mé bú ké ter. Mvúár cén à feh laré bú lò nùàr ká doó dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ye bú a: «Mè terreb felè bɔɔ̀n dɔɔ́ŋ haá nde né mé wò; bɔ̀ njií mé né teèn dɔɔ́ŋ, mè haá gi nde né beè yeè ndɔ. Lòù sam, né dé mò, bɔ́ lé naâ mè haá njií. Mɔ mè gwaán né nùàr haá, né beè mò. ");
INSERT INTO mcu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sâ, mɔ wò cemmé né toò mò, bɔ̀ njií hên dɔɔ́ŋ nde gi né dé yeè.» ");
INSERT INTO mcu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeésò ye bú a: «Né gi te mvù Càŋe nyagá den ye: Cémmé cégé toò Càŋ Dueè Nùà koô yeè, wò die lom bú.» ");
INSERT INTO mcu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sátàn weh njií cu bú ké Jerusalem, à weh ŋaá mé bú ké te ndɔ́ŋ *gwà Càŋ koô, ye bú a: «Mɔ wò né ka Ŋunà Càŋ bɔ̀n, sâ lɔ́ súágá ké doó lòù; ");
INSERT INTO mcu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","né gi te mvù Càŋe nyagá den ye: Càŋ nde né bɔ̀ cìlì seèn felè yeè tueé, te bɔ́ ke nyegé wò; ");
INSERT INTO mcu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ye: bɔ́ nde né wò teter kwaá sie, te wò gule te taá déì cén cú ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeésò ye bú a: «Né te mvù Càŋe nyagá den ye: Té Càŋ Dueè Nùà koô yeè sòn félá.» ");
INSERT INTO mcu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sátàn yeé tab ke aá Yeésò mé veên bèh dɔɔ́ŋ ménâ, à jɔ̀gɔ̀ nde ŋgɔgɔ́ cuù ye. ");
INSERT INTO mcu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jomo sâ Yeésò sɔm gò, à nde cu ké Galilê; sâ Cúcuí Ŋagâ né bú yoòr ŋgulí. Ŋgɔ́g seèn ŋgulí yɔŋ baá-re lè lò sâ bèh dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","À né bɔ̀ njèh te bɔ̀ *gwà sóù feh bele. Bɔ̀ nùàr né bú bèh dɔɔ́ŋ seén ŋellé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Cieé déì Yeésò wa cu ké Najarêt, lɔɔ́ mé à lé kulà naâ teèn. Yeé baá loù sóù, à nde yila cu gwà sóù faá bèh jomò nɔ. À komo wuo ter bèh njèh jaŋê, ");
INSERT INTO mcu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","bɔ́ weh haá keéh bú mvù Esáyà *sòn-Càŋ ndɔ, à komo kwa beré déì mé né teèn nyagá den ye: ");
INSERT INTO mcu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Cúcuí Càŋ né felè mò, à balé sɔm aá mè, te mè tueé bɔ̀ saám bɔ̀ Njàgà Bagaà. À mè tema njií né ká yoòr bɔ̀ nuaá mé né lòù tené le, ye mè a, júée bɔ́ a: bɔ́ mvelé yuo aá ma. Mè nde né mé bɔ̀ cùgò njolo bɔ̀ tueé ndɔ, ye bɔ́ a: bɔ́ nde né njolo ŋené. Càŋ mè temà né te mè mvelé sɔm bɔ̀ cɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mè ye bɔ̀ nùàr a: Hên baá nyèmà mé Càŋ nde né bɔ́ jere teèn kɔɔ́ ma.» ");
INSERT INTO mcu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeésò yeé jaŋé gi aá ménâ, à cib mvù, à haá njií cu mé nùà seê, à den nde doó ndɔ. Bɔ̀ nùàr gwà dɔɔ́ŋ ke ŋgaga le mé bú. ");
INSERT INTO mcu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","À den cuù ye bɔ́ a: «Bɔ̀ njií mé bí né gi te mvù Càŋe ŋgweé hên dɔɔ́ŋ, lan mboón né cí.» ");
INSERT INTO mcu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bɔ̀ nùàr yeé nde ŋgweé njií bɔ̀ ŋgòr bebagaà mé Yeésò né tueé hên, bɔ́ seén ŋellé bú doó dɔɔ́ŋ, hiím yɔgɔ́ bɔ́, bɔ́ ye: «Ŋgweéh hên né ka ŋunà Josêf wa?» ");
INSERT INTO mcu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeésò ye bɔ́ a: «Né môn, mè né kɔɔ́ ye, bí nde né kàn si, ye mè a: Nùà lèh, lɔ̀ táré feh yeè mé be yeè. Bí tueé nde né ye: Bɔ̀ njií mé wò lé naâ ké Kapernahûm bɔɔ́ dɔɔ́ŋ, béh lé naá giì ŋgweé; ndê, bɔ́ dèn á môn ká lɔ yeè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","À den cuù, ye bɔ́ a: «Mè né tueé ye bí a, nuaá mé né *sòn-Càŋ a: dèn méné naàn, ndɔ́g à lɔ seèn líé ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Né gècên bɔ̀n, wanɔɔ́ŋ cu déì lé naâ ká lè tàbè *Iserálà teèn, lé naâ lè nàm *Elî, nom lé naâ gùm nyèmà tagár mé kwèh kelá. Cùè lé naâ die, ka yɔŋ wɔ́ŋ dɔɔ́ŋ. Sâ Elî né doó. Bɔ̀ ma kû ŋgún né mene kwarè seèn gèr ŋené, Càŋ lé bɔ́ táŋ ná ŋgwêh, ");
INSERT INTO mcu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","à Elî tema njií seér yoòr ma kû déì lè lɔɔ́ Saréptà, te tàbè Sídɔ̀ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lé naâ faá bèh ménâ lè nàm Elisê sòn-Càŋ déì ndɔ; ká lè tàbè Iserálà hên, bɔ̀ beén-veên bɔ̀ lé naâ teèn ŋgún. Càŋ lé Elisê ké yoòr bɔɔ̀n témá njí ná ŋgwêh, ye te à taré sɔm bɔ́. Nàmân nùà Sirî déì nde taré yuo seér kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Te bɔ nùàr ké *gwà sóù yeé nde ŋgweé njií mân, temé ŋaâ bɔ́ lè, ");
INSERT INTO mcu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","bɔ́ kem wuo ter, bɔ́ sie yuo kela mé Yeésò cie, bɔ́ tulu ŋa mé bú ké cueè tòr mé lɔɔ́ cer né teèn sâ, te bɔ́ nde bú ŋaár sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yeésò kar kela seér cu lètenè bɔɔ̀n, à fɔɔ́n gò. ");
INSERT INTO mcu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yeé baá môn, Yeésò nde lè lɔɔ́ Kapernahûm; né te tàbè Galilê sâ ndɔ. Loù sóù déì à duɔɔ́m cu bɔ̀ nùàr njèh feèh. ");
INSERT INTO mcu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","À yeé baá feh, hiím seér bɔ̀ nùàr dé hiîm. Lòù sam, à lé bɔ́ njèh feh loóm naâ faá nùà njèh nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sâ lè gwà sóù sâ, nuaré déì lé naâ teèn, à né mé càŋ tándulu yoòr. À lɔgɔ njií ké ter, ye: ");
INSERT INTO mcu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Óè! Yeésò nùà Najarêt, wò ndeè né béh wulá sɔm wa? Béh bí né lè keé-re? Mè né gi ndègè yeè kɔɔ́, wò dé yeè né jolosé, Càŋ wò temà né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeésò pam bú ndɔ, ye bú a: «Húné sòn yeè, yùò kélâ lè nùà hên wágácén.» Tándulu jege si njií nùà hèllè doó toò bɔ̀ nùàr, yuo kelà nɔɔ́ŋ, à bú njeré déì bɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Geí laré bɔ̀ nùàr gwà dɔɔ́ŋ. Bɔ́ né lètenè bɔɔ̀n bieé kuú, ye: «Hên né gèh ŋgòr dé heè? Kè kú, à né mé terreb mé felè bɔ̀ càŋ mene, à né tueé, bɔ̀ càŋ né sòn seèn ŋgweé, bɔ́ né lè bɔ̀ nùàr durá yuo kelá gií.» ");
INSERT INTO mcu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ŋgɔ́g Yeésò ŋgulí yɔŋ cu baá-re lè tàbè sâ bèh dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeésò komo wuo ter ndɔ, à yuo kelà lè *gwà sóù sâ, à nde ké gwò Simɔ̂ŋ. Sâ gùnà Simɔ̂ŋ né baán, á né mé dùlù kagâ. Yeé baá ménâ, bɔ́ bɔŋ Yeésò, te à taré sɔm bú teèn. ");
INSERT INTO mcu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeésò geér nde doó yoòr seèn ndɔ, à pam dùlù hèllè, dùlù kem yuo ma doô yoòr, à komo wuo ter doó sâ, à bɔɔ́ haá bɔ́ yáb. ");
INSERT INTO mcu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yeé baá liyilì, bɔ̀ nùàr weh waà mé bɔ̀ beên bɔ̀ feh hihiné ká yoòr Yeésò. À né bɔ́ be yoòr baá bele, à taré sɔm gi bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bɔ̀ tándulu durá yuo gi lè bɔ̀ nùàr ŋgún ndɔ, bɔ́ né ké ter lɔgɔ njií ye: «Ŋgweéh, wò dé yeè né Ŋunà Càŋ mà!» Yeésò pam bɔ́ ndɔ, à yiín bɔ́ sòn tueê. Lòù sam, bɔ́ lé naâ ŋené kɔɔ́ ye à dé seèn né *Nùà Cɔ̀ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cieé ŋaga maánjɔ̀gɔ̀ Yeésò komo yuo kela gwò, à nde ké ya bèh ndɔ́ŋ-ndɔ̀ŋ. Bɔ̀ nùàr yeé baá bú fɔɔ́n, bɔ́ nde kwa bú ndɔ, ye te bɔ́ bɔ́ den le, bɔ́ ye te à yùò cú. ");
INSERT INTO mcu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","À tueé seér ye bɔ́ a: «Kɔ mè nde lè bɔ̀ lɔɔ́ déì ndɔ, mè nde Njàgà Bagaà felè *Lò Càŋ se. Càŋ mè tema kuú naâ dé cî.» ");
INSERT INTO mcu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","À yeé tueé gi aá mân, à yuo ndɔ, à nde ké Judê ŋgòr Càŋ te *gwà sóù se yɔŋ bele. ");
INSERT INTO mcu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cieé déì Yeésò lé naâ ké sòn tub Jenesarétè njebá den, bɔ̀ nùàr né bú beè kaáŋ sie, ye te bɔ́ ŋgweé kwa ŋgòr Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","À ŋene njií bɔ̀ kɔm déì fà ndɔ, bɔ́ né ké sònò nòmò, bɔ̀ sìè-ŋgò bɔ̀ teèn sam, bɔ́ né yí dùà ndoór yaga den. ");
INSERT INTO mcu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","À ŋaá yila te kɔm dé Simɔ̂ŋ, à den nde doó, ye Simɔ̂ŋ a: «Ndê, kɔ̀gɔ̀ ndé sèr mé njéh yí dùà.» Bɔ́ yeé baá yí dùà, à duɔɔ́m bɔ̀ nùàr ŋgòr Càŋ tueê. ");
INSERT INTO mcu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","À yeé tueé gi aá, à tueé njií mé Simɔ̂ŋ ndɔ, ye bú a: «Kɔ̀gɔ̀ njí sèr cú yí bèh legeè, te bí bɔ̀ mbeí yeè jɔ̀gɔ̀ vu ke ke yí sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔ̂ŋ ye bú a: «Dé koô, hên né ka lè sòn yeè, wanɔɔ́ŋ béh naâ mé njéh vuú ŋagá, béh njeré déì kwà ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bɔ́ yeé nde vu njií mân, ŋgò yuú lè deí. Bɔ́ né tulu, ndoór duɔɔ́m aá tenê. ");
INSERT INTO mcu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bɔ́ né bɔ̀ mbeí mé kɔm déì ci yilá njiî, te bɔ́ ndeè gam bɔ́ teèn. Bɔ́ yeé waà baá, bɔ́ yila ŋgò sɔɔ̀m, bɔ́ sɔm sɔm sɔm, kɔm fà dɔɔ́ŋ yuú gi, ye kɔ nyí jiím yila dùà. ");
INSERT INTO mcu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔ̂ŋ Piêr yeé ŋene aá ménâ, à die cemmé nde toò Yeésò, ye bú a: «Fehtoò mò, té ká kwarè mò dèn ndê, mè né nùà veên.» ");
INSERT INTO mcu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simɔ̂ŋ né tueé, veéh né bú sie, sie bɔ́ bɔ̀ mbeí dɔɔ́ŋ mé gèh ŋgò sieè bú sâ. ");
INSERT INTO mcu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sâ bɔ̀ mbeí Simɔ̂ŋ déì lé naâ teèn, yilí bɔɔ̀n né Jâk bɔ̂ Jâŋ, né bɔ̀ ŋunà Jebedê, veéh lé naâ bɔ́ ménâ sie ndɔ. Yeésò ye Simɔ̂ŋ a: «Té vèh, wò kènê ŋa seér nde aá kòrò-nùàr.» ");
INSERT INTO mcu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yeé baá ménâ, bɔ́ kɔgɔ́ kwaá njií bɔ̀ kɔm yí cie ndɔ, bɔ́ vu lɔ gi njèh dɔɔ́ŋ, bɔ́ yuo bele bú. ");
INSERT INTO mcu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yeésò yeé baá lè lɔɔ́ déì, nùà beén veên déì waà ndɔ. À ŋene njií Yeésò, à die sulí nde toò seèn, ye bú a: «Kúkùr yeè, dé koô, mɔ wò né gwaán, wò nde né mè taré sɔm, mè den cu ŋagásé.» ");
INSERT INTO mcu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeésò kema njií bú be yoòr ndɔ, ye bú a: «Mè gwaán aá kèn, táré yùò tarè.» Beén nùà hèllè nyimé yuo doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeésò luɔm bú, ye bú a: «Càŋ a bɔ́ wò tueé nuaré déì. Ndé lòm ké yoòr *ŋgàŋ sèmè, wò feh keéh bú yo yeè, wò haá bú gèh dàgà beén sâ, faá Músì lɔ naâ tueé nɔ, te bɔ̀ nùàr ŋene kɔ seér teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yeésò né seèn nùà beén veên doô dé luɔɔ̀m luɔm den, ŋgɔ́g Yeésò né dé ŋgulî ŋgulí ŋeí. Yeé baá ménâ, cìlì nùàr ŋgún bilí waà, te bɔ́ ŋgweé ŋgòr seèn, te à taré sɔm bele bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","À né yeé bɔ́ taré sɔm, à né yeé ké ya bèh ndɔ́ŋ-ndɔ̀ŋ ndeé, à né Càŋ teèn dua. ");
INSERT INTO mcu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cieé déì Yeésò né njèh feh den, sâ bɔ̀ *Farisiên mé bɔ̀ *njí-sóù né doó. Bɔ́ lé yuo belé naâ lè lɔɔ́ hihiné te tàbè Galilê mé tàbè Judê; lé teèn nde bilí naâ mé bɔ̀ Jerusalem bɔ̀ mene. Càŋ né lom Yeésò terreb haá, à né bɔ̀ nùàr taré sɔm bele. ");
INSERT INTO mcu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bɔ̀ nuaré déì jɔgɔ waà mé nùà gule kuû déì; à né te ndagáa cer den. Bɔ́ né ceér fɔɔ́n te bɔ́ yila nde mé bú yí toò Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lɔ́ŋ sam mé bɔ̀ nùàr. Yeé baá môn, bɔ́ nde ŋaá komo lɔgɔ́ seér feh gwà; bɔ́ segé yií keéh bú teèn mé ndagá mene, bɔ́ kwaá njií bú doó toò Yeésò ké lètenè bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeésò yeé ŋene, ye temé bɔɔ̀n dɔɔ́ŋ né lom yoòr nyî ménâ, à ye nùà beên a: «Nùàr mò, bɔ̀ veên yeè gi aá wò mé njéh kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bɔ̀ njí-sóù mé bɔ̀ Farisiên munó baá-re ye: «Nùà hên ye nyí né neì wa? À feh seèn faá Càŋ nɔ weh né dé keì ndɔ wa? Nuaré déì né mé terreb veên nùàr kulú sɔɔ̀m wa? Né lom Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeésò yeé ŋene mùnò bɔɔ̀n né ménâ, ye bɔ́ a: «Bí ménâ munó né dé keì? ");
INSERT INTO mcu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Beè biì, taré kela né tueê ye: Bɔ̀ veên yeè gi aá wò mé njéh kèn, wa né: wùò ter, gègɔɔ̀ wa? ");
INSERT INTO mcu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bí kɔ́ɔ ye: ká doó dɔɔ́ŋ *Huaán Nùàr né mé terreb veên kulú sɔɔ̀m teèn.» À den cuù baá-re, ye nùà gule kuû doô a: «Mè ye wò a: wùò ter, wèh ndagá yeè, ndé á lɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nùà hèllè komo wuo ter toò bɔ̀ nùàr doó sâ, weh ndagá seèn, fɔɔ́n gò lɔɔ̂. À né gɔ, à né Càŋ seén. ");
INSERT INTO mcu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Geí laré bɔ̀ nùàr doó dɔɔ́ŋ. Veéh yila bɔ́ lè, bɔ́ né Càŋ teèn seén yií, ye: «Lan béh naâ mé njèh kèkènè ŋené kuú.» ");
INSERT INTO mcu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yeésò yuo kela ndɔ, à ŋene njií nuaré déì né ké gwò bèh seê seèn den den. Yilí seèn né Levî. À né yeé kàgàlɔ̀ŋ làmpɔ̂ŋ weh. Yeésò ye bú a: «Yùò bèlè mè.» ");
INSERT INTO mcu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","À vu lɔ bɔ̀ njèh seèn dɔɔ́ŋ, à yuo bele bú. ");
INSERT INTO mcu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jomo sâ Levî ne haá Yeésò kùrmò ndɔ. Dàm bɔ̀ mbeí mé weh yeé kàgàlɔ̀ŋ làmpɔ̂ŋ mé bɔ̀ nuaré déì lé naá giì teèn, bɔ́ bɔ́ né bècénè yieé den. ");
INSERT INTO mcu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bɔ̀ *Farisiên mé bɔ̀ njí-sóù bɔɔ̀n yeé ŋene aá ménâ, bɔ́ yila mé bɔ̀ mbɔ̀ŋ Yeésò ndugó njiî, ye bɔ́ a: «Bí bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mé bɔ̀ vevenê bɔ̀ yáb bècénè yieé bilí né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeésò yeé ŋgweé aá ménâ, à ye bɔ́ a: «Bɔ̀ beén bɔ̀ né yeé mé koró nùà lèh kɔɔ́, dèn ŋgwéh bɔ̀ tetarê bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mè hên nde kuú naâ bɔ̀ vevenê bɔ̀ ká yoòr mò yilá njiî, te bɔ́ kweéh seér temé, dèn ŋgwéh bɔ̀ didilî bɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bɔ̀ nuaré déì waà kwarè Yeésò ndɔ, ye bú a: «Bɔ̀ mbɔ̀ŋ Jâŋ né yeé yáb jolo, bɔ́ né Càŋ dua; bɔ̀ mbɔ̀ŋ dé bɔ̀ *Farisiên né yeé ménâ bɔɔ́ ndɔ. Bɔɔ́ né naàn mé bɔ̀ dé yeè kɔ lom né yieê mé ŋueê, bɔ́ jòlò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeésò ye bɔ́ a: «Loù mé bɔ́ sua yeé véh, mé si né doó samé den, bí nde né bɔ̀ mbeí tueé ye bɔ́ a, jòlò yáb wa? Dé sâ ndɔ́g. ");
INSERT INTO mcu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mé njéh mene, bí kwá cieé déì, mɔ bɔ́ ŋgaá sɔm aá bɔ́ siì fù beè, bɔ́ ndeè jolo ye bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","À den cuù mé kàn déì ndɔ, ye bɔ́ a: «Nùàr cɔ̀gɔ̀ feê ŋà wèh bèh, à lab dé cuûm mé njéh. Mɔ sam, à nde né cɔ̀gɔ̀ dé feê mbaá tená kuú; dé cuûm bú sìè kòmò ndé ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","«Bɔ́ tàgà mé kulu feê lè ŋguú cuúme sì kwá bèh ndɔ. Mɔ sam, tàgà nde né jelá, ŋguú keér, mbè ber nde doó. Bɔ́ nde né be te mbè vu, bɔ́ vu be te ŋguû ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mɔ bɔ́ baá mbè mé kulu feê si, bɔ́ bú si kwaá yeé lè ŋguú feê. ");
INSERT INTO mcu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Déì né cu teèn: mɔ nùàr ŋueé meh gi aá mbè lɔɔ̂ kèn, à mbè dé kìn gwàn ndé cú, à ye: beè nyî, mbè lɔɔ̂ huɔm kela né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Loù sóù déì bɔ̀ Yeésò yeé baá te ŋueèh yolò gɔ kelá, bɔ̀ mbɔ̀ŋ seèn yila lùà kwalé weèh, bɔ́ né segé yieé. ");
INSERT INTO mcu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bɔ̀ *Farisiên deên ndɔ, ye bɔ́ a: «Bɔɔ́ né naàn mé *sóú beèh né yiín, bí né lùà loù sóù kwalé yieé wa?» ");
INSERT INTO mcu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeésò ye bɔ́ a: «Njií mé *Davîd nùà njèh lé naâ bɔɔ́ doô, bí née jáŋé kè ŋgwéeh ye wa? Loù sâ cùè lé naâ bɔ́ bɔ̀ nùàr seèn sie, ");
INSERT INTO mcu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","à yila nde te gwà Càŋe, à nde jɔgɔ weh yáb mé bɔ́ lé kwaá lɔɔ̀ naâ ké toò Càŋ, à yieé, à haá njií bɔ̀ nùàr seèn kèb déì, bɔ́ yieé ndɔ. Sâ bí né kɔɔ́ ye, né yeé jolo, bɔ̀ *ŋgàŋ sèmè yieé cegé yeé kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeésò den cuù ye bɔ́ a: «Bí kɔ́ɔ ye, *Huaán Nùàr né cieé sóù yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yeé baá cu loù sóù déì, Yeésò yila nde lè *gwà sóù, à né njèh teèn feh den. Nuaré déì lé naâ gwò sâ teèn, be gaâ seèn né ŋemásé. ");
INSERT INTO mcu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sâ bɔ̀ *njí-sóù mé bɔ̀ *Farisiên né Yeésò mé ju taáb kwaá, ye mɔ à taré sɔm nùà sâ loù sóù, te bɔ́ sie bú teèn. ");
INSERT INTO mcu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sâ Yeésò né gi mùnò bɔɔ̀n kɔɔ́ ndɔ, ye nùà mé be ŋemâ doô a: «Wùò njébá ter njolò bɔ̀ nùàr.» À komo wuo ter ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeésò ye bɔ̀ nùàr a: «Mè bie njií né mé bí: Sóú biì ye naàn wa? Ye loù sóù béh bɔ́ njèh bagaà wa, béh bɔ́ sér dé veên wa? Ye huɔm kela né nùàr loù sóù yili sɔɔ̀m wa, dé nùàr wulá seêr wa?» ");
INSERT INTO mcu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","À né bɔ́ doó dɔɔ́ŋ ke laré. À tueé njií mé nùà be ŋemâ doô, ye bú a: «Nèbbè be yeè nebbè.» Nùà hèllè nebbé be ndɔ, be seèn taré yuo. ");
INSERT INTO mcu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Te bɔ́ yeé nde ŋene njií baá-re ménâ, temé ŋaâ bɔ́ lè, bɔ́ yila lètenè bɔɔ̀n bieé kuû, te bɔ́ kwa ceér felè Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lè cu sâ, Yeésò ŋaá nde ké te tòre bèh Càŋ duaà. À dua ŋagá mé Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yeé baá maánjɔ̀gɔ̀, à yilá njiî bɔ̀ mbɔ̀ŋ, à balé weh yulà cùɔ̀b fà lètenè bɔɔ̀n, à yilá bɔ́ bɔ̀ mbɔ̀ŋ tebê. ");
INSERT INTO mcu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lé naâ: Simɔ̂ŋ; ye yilí seèn déì baá cu Piêr ma. Lé naâ mé Andrê dìm Piêr ndɔ, Jâk bɔ̂ Jâŋ, mé Filîp bɔ̂ Bartelemî, ");
INSERT INTO mcu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matíô bɔ̂ Tomâs, mé Jâk ŋunà Alfê bɔ̂ Simɔ̂ŋ nuaá mé gwàn bèh dé mé bɔ̀ kìn den felè bɔ̀ lɔɔ́ bɔ̀ doô, ");
INSERT INTO mcu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","bɔ̂ Júdàs ŋunà Jâk mé Júdàs Iskariô sàrnyé Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bɔ́ bɔ́ yeé suaga cuù aá ké te tòre, bɔ́ waà te bela. Sâ bɔ̀ mbɔ̀ŋ seèn déì ŋgún mé cìlì nùàr né doó bilí den. Bɔ̀ déì yuoô ké Jerusalem mé bɔ̀ lɔɔ́ déì lè tàbè Judê. Bɔ̀ déì yuoô ké Tîr bɔ̂ Sídɔ̀ŋ kwarè nòmò koô. ");
INSERT INTO mcu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɔ́ nde giì bèh ŋgòr Càŋ sònò Yeésò ŋgweê, te à taré sɔm bɔ́ ndɔ. Bɔ̀ɔ́ mé lé naâ mé tándulu yoòr lé naá giì loù sâ taré yuo. ");
INSERT INTO mcu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nùàr dɔɔ́ŋ né lom lege ndeé te bɔ́ kema kwa bú. Terreb déì lé naâ yoòr seèn yuo, né bɔ́ dɔɔ́ŋ taré sɔm ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeé baá môn, Yeésò ke njií bɔ̀ mbɔ̀ŋ seèn ndɔ, ye bɔ́ a: «Samésé né bí bɔ̀ saâm bɔ̀; *Lò Càŋ né dé biì. ");
INSERT INTO mcu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Samésé né bí bɔ̀ɔ́ mé né kènê mé cùè; bí nde né yieé fulu. Samésé né bí bɔ̀ɔ́ mé né kènê yueé; bí nde né ja wa. ");
INSERT INTO mcu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Samésé né bí ndɔ, mɔ bɔ̀ nùàr baá bí bunó, bɔ́ né bí faá bɔ̀ mbaâ bɔ̀ nɔ ke njií, bɔ́ né bí selé, bɔ́ né bí seb, ye bí né bɔ̀ mbɔ̀ŋ Huaán Nùàr fí. ");
INSERT INTO mcu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mè tueé bí, bí sàmè sér dé biì cu sâ lòù, bí né tàbè dobo, ye sàgà biì né ké te vulúu ŋgún ma. Bí té njeré déì mùnò; né seé bɔɔ̀n, bɔ̀ tele bɔɔ̀n lé naâ bɔ̀ *sòn-Càŋ bɔ̀ faá bèh mân bunó ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bí bɔ̀ lilieê bɔ̀, dé biì né seér gèr. Sàgà biì gi né ŋgúlú sâ, bí sàgà déì ké toò kwà ndé cú. ");
INSERT INTO mcu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bí bɔ̀ɔ́ mé né jùjùɔ̀b kènê yieé, gèr né felè biì teèn, ké toò bí né bɔ̀ cùè bɔ̀. Bí bɔ̀ɔ́ mé né ja kènê kioó, gèr né felè biì teèn; ké toò bí nde né mé yúé kwaré, bí nde né mé kú vuagá kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Gèr né felè biì teèn, mɔ bɔ̀ nùàr dɔɔ́ŋ né bí lòù seén seér. Lòù sam, bɔ̀ tele bɔɔ̀n lé naâ bɔ̀ sòn-Càŋ bɔ̀ dé kòkòb ménâ seén ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yeésò ye bɔ́ a: «Bí bɔ̀ɔ́ mé né ŋgòr mò ŋgweé, bí gwàn bɔ̀ bùnò bɔ̀ biì gwaàn, bí bɔɔ́ seér bɔ́ bagaà. ");
INSERT INTO mcu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mɔ bɔ̀ nùàr né bí duagá, bí kúlú sér bɔ́ lòù. Mɔ bɔ́ né bí jamé, bí dùà sér Càŋ felè bɔɔ̀n lòù ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mɔ nuaré déì né wò geí mbaá bɔɔ́ weh, kéh cú bú geí kèb déì, à bɔ ndɔ. Mɔ nuaré déì né wò cɔ̀gɔ̀ wagâ ŋgaá weh, húár há bílí bú mé cɔ̀gɔ̀ suù yeè mene. ");
INSERT INTO mcu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mɔ nuaré déì né wò njeré déì dua, há bú teèn. Mɔ nuaré déì né wò njèh weh, té bú bíé. ");
INSERT INTO mcu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bí bɔ́ mé bɔ̀ nùàr faá bí ye bɔ̀ nùàr a, bɔ́ mé bí nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Mɔ bí gwaán lom né bɔ̀ɔ́ mé né bí gwaán, sâ neì seèn bí vra nde né kɔɔ́ wa? Ŋgweéh né mene bɔ̀ vevenê bɔ̀, bɔ́ né gi bɔ̀ mbeí bɔɔ̀n gwaán komo wa? ");
INSERT INTO mcu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mɔ bí bagaà bɔɔ́ njií lom né mé bɔ̀ɔ́ mé bɔɔ́ yeé bí bagaà, sâ beè biì né njèh kàm déì wa? Ŋgweéh né mene bɔ̀ vevenê bɔ̀, bɔ́ né gi ménâ lètenè bɔɔ̀n bɔɔ́ kuú ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mɔ bí hùà haá lom né mé bɔ̀ɔ́ mé nde cu né bí hùà haá, sâ beè biì né njèh kàm déì wa? Ŋgweéh né mene bɔ̀ vevenê bɔ̀, bɔ́ né gi dé sâ lètenè bɔɔ̀n haá kuú ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dé biì, bí gwàn sér bɔ̀ bùnò bɔ̀ biì lòù, bí né bɔ́ bagaà bɔɔ́ seér. Bí há bɔ̀ nùàr hùà teèn. Mɔ bí baá bɔ́ haá, bí sɔ̀m temé teèn. Bí kɔ́ɔ ye, bí nde né sàgà dé koô kwa. Càŋ mé né ké ter te vulúu, bí nde né bɔ̀ ŋuna seèn ŋaá. Lòù sam, à dé seèn né Càŋ húɔ́m-temê felè bɔ̀ɔ́ mé né be seèn seb, à né Càŋ húɔ́m-temê felè bɔ̀ jélá-temé bɔ̀ mene dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bí kɔ́ lòm bɔ̀ nùàr jere, faá Tele biì Càŋ né yeé bí jere kɔɔ́ nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Bí té ju felè bɔ̀ mbaábiì mbaá téná gɔ̀, te Càŋ ju felè biì téná cú. Bí té nùàr dúágá, te Càŋ bí dúágá cú. Bí kúlú njí veên bɔ̀ mbaábiì doó, te Càŋ kulu sɔm ye bɔ̀ veên biì lè seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bí há bɔ̀ mbaábi teèn, Càŋ nde cu né bí haá; bɔ́ me kwaá cu nde né bí kàŋ deí, bɔ́ né baá, kèb déì né doó sueé kelá. Mòù mé bí né bɔ̀ nùàr njèh teèn me haá dɔɔ́ŋ, Càŋ bí me haá cu nde né teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeésò si cu bɔ́ kàn déì, ye bɔ́ a: «Tácugó yeé mbeí be dèrrè bèh; mɔ sam bɔ̂ mbeí fà dɔɔ́ŋ nde né ké dòù lùgò vulú sue yilá.» ");
INSERT INTO mcu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","À ye bɔ́ a: «Mbɔ̀ŋ a, dèn méné naàn, à kɔɔ́ táré kélá ŋgwéh mé ŋgàŋ. Kɔ loù mé mbɔ̀ŋ weéh baá kèn, sâ à baá ye mé terreb faá ŋgàŋ nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","À den cuù ye bɔ́ a: «Mbeí mò, wò yeè tòmò nyurè dé njolò mbeí yeè ŋene keéh naâ he, mé gùm ndilí toû dɔɔ́ŋ né wò njolò ŋgelá den, wò cí ŋéné ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wò ye bú a: Mbeí nyî, kwá nyí ge sɔm wò tòmò nyurè njolò! Wò gùm ndilí toû njolò yeè ŋéné ŋgwéh, wò bú tòmò nyurè njolò ge sɔm nde né naàn wa? Nùà lòbò-kàŋ, jɔ̀gɔ̀ mvúá sɔ̀m lɔ́gɔ ndilí toû dé njolò yeè; mɔ njolo ŋagá baá, wò ge sɔm ye nyure dé njolò mbeí yeè.» ");
INSERT INTO mcu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Toú dé bagaà tàb dé veên wá bèh. Toú veên tàb dé bagaà wá bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bɔ́ toú dé kàn ŋene kɔ né mé tàb seèn. Mè tueé bí, kaáŋkaŋ máŋgɔ̀rè wá bèh. Nyie ŋgòbò màkpelâŋ wá bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nùà bagaà lè né mé bɔ̀ njèh bebagaà, à cie sɔm keéh yeé bɔ̀ njèh bebagaà. Nùà veên lè né mé bɔ̀ njèh vevenê, à dé seèn cie sɔm keéh yeé bɔ̀ njèh dé vevenê ndɔ. Bí kɔ́ɔ ye, sònò nùàr yuo kela yeé njií mé né lè seèn goón den.» ");
INSERT INTO mcu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Bí mè Nùà dueè, Nùà dueè, yilá kuú né dé keì mé bí sòn mò ŋgúŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nuaá mé né ká yoòr mò ndeê, né ŋgòr mò ŋgweé, né ménâ bɔɔ́ dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","mè bú me njií nde né mé nuaá mé nde aá gwà seèn meé. À lé naâ bèh cu, à si maàŋ te kweêh, à me gwà. Loù sâ nòmò yuo, né gwà luú, gwà hèllè lé naâ ter njebá le. Lòù sam, nùà doô lé naâ teèn meé yií. ");
INSERT INTO mcu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","«Nuaá mé né ŋgòr mò ŋgweé, à ménâ bɔ́ ŋgwéh, né faá nùà mé-gwà déì ndɔ; à dé seèn gwà me njií né te bàŋ tàbe mbaá, à maàŋ sì ŋgwéh. Nòmò yeé baá yuo, suú si njií gwà hèllè doó mvúɔ́b dé kèì cên.» ");
INSERT INTO mcu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeésò yeé tueé gi aá bɔ̀ nùàr njií hên dɔɔ́ŋ, à fɔɔ́n gò, à nde cu Kapernahûm. ");
INSERT INTO mcu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ké teèn sâ, nùà seê kwaá-taâb bɔ̀ Rɔ̂m bɔ̀ déì lé naâ baán, à nde aá kuú dɔlé, à né lom huaán yíé-temê kwaá-taâb hèllè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kwaá-taâb doô yeé nde ŋgweé njií njàgà Yeésò mân, à sɔm bɔ̀ kokoô bɔ̀ déì lètenè bɔ̀ *Jûf, à tema njií bɔ́ yoòr seèn; ye bɔ́ ndé júée Yeésò a: ndê táré sɔ̀m nyí nùà seê nyî teèn ma. ");
INSERT INTO mcu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bɔ́ wa, bɔ́ tueé Yeésò ndɔ, bɔ́ né bú bɔŋ, ye bú a: «Nùà sâ né nùàr, ndé gàm bú teèn, ");
INSERT INTO mcu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","à né yeé béh bɔ̀ Jûf gwaán, à lé bɔɔ́ naâ kɔɔ́, te bɔ́ me ye *gwà sóù beèh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeé baá mân, bɔ́ bɔ̀ Yeésò yuo gò. Bɔ́ yeé nde aá kwarè lɔɔ̂ waá, kwaá-taâb doô tema njií bɔ̀ mbeí seèn déì, ye bɔ́ ndé júée Yeésò a: «Dé koô, té yeè ká lɔ nyî mbaá ndé hómó kû, nyí nuaá mé wò nde né lɔ seèn yilá, wúlú ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wa nyí la ké yoòr yeè yùò kélá ná ŋgwêh dé cî ma. Kòmò njí cégé yeè léláŋ sòn, nde né nùà seê nyî taré sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nyí né kɔɔ́, ye bɔ̀ kokoô bɔ̀ né mé terreb teèn. Lòù sam, nyí né ka bɔ̀ déì, bɔ̀ déì né ka nyî. Nyí né mé bɔ̀ŋ bɔ̀ sɔ́jì beè. Mɔ nyí ye déì a: Ndé mân! à nde. Mɔ nyí ye cén déì a: Ndê! à ndeè. Mɔ nyí ye nùà seê nyî a: Bɔ́ mân! à bɔɔ́ ka ménâ nág ndɔ. Mɔ né mân, túé cégé yeè lòù, nùà seê nyî nde né taré yuo ma.» ");
INSERT INTO mcu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te Yeésò yeé nde ŋgweé njií mân, hiím lɔ bú mé kwaá-taâb doô mbaá. À bele seér, à tueé njií mé cìlì nùàr jomo seèn, ye bɔ́ a: «Mè tueé bí, ká te tàbè *Iserálà hên dɔɔ́ŋ, mè gèh ndèm hên teèn ŋéné ŋgúŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bɔ̀ tebé bɔ̀ doô cu cu jomo ndɔ; bɔ́ wa, sâ nùà seê doô taré yuo aá kèn. ");
INSERT INTO mcu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jomo sâ Yeésò nde lè lɔɔ́ déì, yilí lɔɔ́ sâ né Nàîn. Bɔ́ bɔ̀ mbɔ̀ŋ seèn mé bɔ̀ nùàr lé naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bɔ́ yeé nde aá lɔ yilá, bɔ́ bɔ̀ tèb komô kwaré; lé naâ ŋunà ma kû déì lé kuú naâ kɔɔ́. Sâ huaán gi lom né ka ma kû hèllè cén sâ. Bɔ̀ lɔɔ̂ bɔ̀ ŋgún né kwarè bilí den. ");
INSERT INTO mcu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Fehtoò beèh yeé ŋene aá ma kû doô, jere bɔɔ́ bú njèh, ye bú a: «Té yúé!» ");
INSERT INTO mcu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","À kela nde yí kwarè tèb ndɔ, à kema njií be teèn. Bɔ̀ɔ́ mé né tèb doô jɔgɔ́, njebá le. À tueé njií mé komó ye bú a: «Huaán ndà, mè né wò yilá; wùò ter.» ");
INSERT INTO mcu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Komó nyimé den ter ndɔ, duɔɔ́m cu sòn tueê. Yeésò haá njií bú mé meí. ");
INSERT INTO mcu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bɔ̀ nùàr yeé nde ŋene njií ménâ, veéh bɔɔ́ bɔ́ njèh, bɔ́ né Càŋ seén, ye: «Môn, *sòn-Càŋ dé koô baá ká doó lètenè beèh teèn.» Bɔ́ den cuù ye: «Càŋ baá bɔ̀ nùàr seèn yɔŋ ke.» ");
INSERT INTO mcu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ŋgɔ́g Yeésò kela baá-re te tàbè Judê dɔɔ́ŋ, ŋgulí nde mé bɔ̀ lɔɔ́ dé kukwarè mene. ");
INSERT INTO mcu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bɔ̀ mbɔ̀ŋ Jâŋ yeé ŋgweé aá bɔ̀ njií mé Yeésò né bɔɔ́ dɔɔ́ŋ, bɔ́ nde Jâŋ ménâ tueé njií ndɔ. Jâŋ yilá njií bɔ̀ fà déì teèn, ");
INSERT INTO mcu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","à tema njií bɔ́ yoòr Fehtoò beèh, ye bɔ́ ndé júée bú a: «Né bú mé béh né kela den doô wa, dé béh kèlà sèr nùà dé hiîn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bɔ́ wa ké yoòr Yeésò, bɔ́ ye bú a: «Jâŋ Bàptîs tema njií naâ ye béh ndé júée wò a: Né wò mé béh né kela den doô wa, dé béh kèlà sèr nùà dé hiîn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sâ loù sâ Yeésò né bɔ̀ beén bɔ̀ ŋgún taré sɔm. Bɔ̀ déì lé naâ mé yúlá yoòr, bɔ̀ déì yoòr mé càŋ, bɔ̀ déì njolo né cugó. Dɔɔ́ŋ bɔ́ lé naá giì taré yuo. ");
INSERT INTO mcu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yeésò tueé njií mé bɔ̀ mbɔ̀ŋ Jâŋ ndɔ, ye bɔ́ a: «Bɔ̀ njií mé bí né ŋené mé bí né ŋgweé dɔɔ́ŋ, bí ndé túé gí mé Jâŋ ménâ, bí júée bú a: bɔ̀ cùgò njolo bɔ̀ baá njolo ŋené, bɔ̀ gule kuú bɔ̀ baá gɔ, bɔ̀ beén veên bɔ̀ né taré yuo bele, bɔ̀ tándúg baá ŋgweé, bɔ̀ komó baá lè cio nyimé yuo bele, bɔ̀ saám bɔ̀ baá Njàgà Bagaà ŋgweé ma. ");
INSERT INTO mcu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nuaá mé temé yoòr mò sɔ̀m ŋgwéh wa, nde né samésé den ma.» ");
INSERT INTO mcu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bɔ̀ mbɔ̀ŋ Jâŋ sɔm gò ndɔ. Bɔ́ yeé nde gi aá, Yeésò duɔɔ́m ye bɔ̀ nùàr njèh felè Jâŋ tueé ŋagâ, ye bɔ́ a: «Bí lé ké ya dueè nde ŋenè naâ kei wa? Fu lé kobo jilí deén naâ gui wa? Háyè ndɔ! ");
INSERT INTO mcu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Á, bí lé ké sâ ke deén naâ kei wa? Bí lé ŋenè naâ nuaré déì mé cɔ̀gɔ̀ nyàgàm yoòr wa? Bɔ̀ɔ́ mé né cɔ̀gɔ̀ nyàgàm su, mé né *wɔ́ŋ yieé, bɔɔ̀n yuo yeé ké mbàm ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Á, ké ya dueè nɔ, bí lé nde ŋenè naâ kei wa? Lé naâ *sòn-Càŋ déì wa? Mè tueé bí, né sòn-Càŋ sâ bɔ̀n! Njèh cén, bí kɔ́ɔ ye, nùà dé sâ né sòn-Càŋ yɔgɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Lòù sam, Jâŋ dé seèn né nùà tebê mé bɔ́ lé naâ felè seèn nyagá kwaá ye: Càŋ ye, nyí nde né nùà tebê nyî toò yeè temá njií, te à tɔɔ́ nyegé wò ceér.» ");
INSERT INTO mcu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeésò den cuù ye bɔ́ a: «Mè tueé bí, bèh lɔ mé wɔ́ŋ lɔ deén naâ, bɔ́ lɔ née nùà koô déì faá Jâŋ nɔ ŋàr ŋgúŋgwéeh ye. Mé njéh mene, te *Lò Càŋe né mene huaán dé maàn, à ham kela seér cu né kɔɔ́ mé Jâŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bɔ̀ɔ́ mé weh yeé kàgàlɔ̀ŋ làmpɔ̂ŋ mé bɔ̀ nùàr kókoó mbaá yeé baá ménâ ŋgweé, bɔ́ gwaán ndɔ. Lòù sam, cu mé Jâŋ lé naâ bɔ́ ŋgòr Càŋ tueé, bɔ́ lé naá giì gècên Càŋ teèn ŋgweé kɔɔ́; Jâŋ lé naâ bɔ́ kou ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bɔ̀ *Farisiên mé bɔ̀ *njí-sóù lé ceér Càŋ berɔ́ŋ seér naâ kɔɔ́, bɔ́ nòmò Càŋ beè Jâŋ kòù ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeésò den cuù ye bɔ́ a: «Bɔ̀ cafanê bɔ̀ den né faá kei wee? Bɔ́ felá né bɔ̀ neì wa? ");
INSERT INTO mcu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mè tueé bí, bɔ́ den né faá bɔ̀ huaán mé né ké mbartɔgɔ̂ vɔgɔ́ den nɔ; bɔ̀ déì né mé bɔ̀ mbeí tueé njií, ye bɔ́ a: Béh né mé térèm mbaá tuagá kuú, bí ŋgɔ̀ ŋgwéh! Béh né mene bɔ̀ bené kú-jerè genné, bí yúé ŋgwéh ndɔ! Bí ye: bɔ́ sà bá naàn wa? ");
INSERT INTO mcu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wanɔɔ́ŋ Jâŋ Bàptîs yeé waà, à sér yíé ŋgwéh, à mbè ŋúé ŋgwéh, bí ye: À né mé tándulu yoòr. ");
INSERT INTO mcu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","*Huaán Nùàr yeé waà dé seèn, à yieé sér, à ŋueé mbè, bí den cuù ye: Nùà hên kɔ lom né yieê mé ŋueê; à né mbeí bɔ̀ vevenê bɔ̀ mé bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀ mene! ");
INSERT INTO mcu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mé njéh mene, mè tueé bí, bɔ̀ɔ́ mé né bɔ̀ ŋunà Càŋ dɔɔ́ŋ né gi dé bɔɔ̀n kɔ́ŋkɔŋ Càŋ ŋené kɔɔ́, ye yila né teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nùà Farisiên déì yilá njií Yeésò ké gwò seèn bèh yáb yieê. Yeésò wa ké teèn ndɔ, bɔ́ bɔ̀ nùàr baá yáb yieé. ");
INSERT INTO mcu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sâ ma yɔ̀ŋ yàgà déì né lɔ sâ teèn. Ma doô yeé ŋgweé ye Yeésò né te yábe ké gwò nùà Farisiên doô, à nde jɔgɔ sie mbémbɔ́ŋ kómó múmû beè, à nde ké teèn ndɔ, ");
INSERT INTO mcu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","à njebá nde mé kómó doô yí jomo Yeésò ké gulè seèn. À né yueé, à né bú yímé gulè yueé berré njií, à fɔ ŋemá sɔm mé yúlí feèh seèn. À kumó sie bú gule ndɔ, à waá njií bú kómó múmû jɔ̀gɔ̀ teèn. ");
INSERT INTO mcu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nùà Farisiên doô yeé nde ŋene njií ménâ, à duɔɔ́m ké lè seèn munó den ye: mɔ nùà hên sé la né *sòn-Càŋ dé gècên bɔ̀n, à sé la naâ gèh dé mé ma hên den nê ŋené kɔɔ́, ye né ma yɔ̀ŋ yàgà; à sé la gwàn ná ŋgwêh dé ma hên kema bú mé be. ");
INSERT INTO mcu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","À yeé baá ménâ munó den, Yeésò yilá bú ndɔ, ye: «Simɔ̂ŋ, mè nde né wò njeré déì bieé.» Simɔ̂ŋ ye bú a: «Bíbieè, Nùà fèh-njèh.» ");
INSERT INTO mcu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ye Simɔ̂ŋ a: «Nuaré déì lé naâ nùà fà hùà bele; déì kám yuií tîn, déì kám yulà tîn. ");
INSERT INTO mcu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bɔ́ fà dɔɔ́ŋ, bɔ́ gwɔ̀m kòmò ŋgwéh. Nùà doô yeé ŋene aá môn, à yilá njiî bɔ́ ká toò seèn fà dɔɔ́ŋ, à ye bɔ́ a: Bí kwá lɔ́ á hùà doô môn, bí té biì mè gwɔ̀m cú ma. Mɔ né môn Simɔ̂ŋ, beè yeè dé heè vra kela nde né nùà doô kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ̂ŋ ye bú a: «Mè ye kɔ ŋgweéh, nde né nuaá mé hùà dé seèn maga kela né kɔɔ́ doô wa?» Yeésò ye bú a: «Môn, wò tueé yií né teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yeésò bele seér ndɔ, ke njií ma doô, tueé njií mé Simɔ̂ŋ, ye bú a: «Wò né ma hên ŋené wa? Mè la naâ ká gwò yeè yilá, wò mè nòmò gule yagaà há ŋgwéh; ma hên yueé berré yaga mè gule mé yímé njolò seèn, à fɔ ŋemá cu mé yúlí feèh seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wò la yeè mè bíé nyégé ná ŋgwêh; à yeé waà dé seèn, à kɔ lom né mè gule kumó den, à né mè bieé nyegé. ");
INSERT INTO mcu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wò mè kómó felè túán njí ná ŋgwêh; à mè dé seèn gulè waá naâ kómó múmû. ");
INSERT INTO mcu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mè tueé wò: gèh gwaân mé ma hên né mè feh keéh hên né tueé ye bɔ́ naâ dàm bɔ̀ veên seèn dɔɔ́ŋ doó kulú njií. Mɔ bɔ́ veên nùàr kulu sɔm lom né kèb cén, nùà sâ bɔ́ gwaán lom nde né kèb cén ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","À yeé tueé gi aá mân, à tueé njií mé ma doô ndɔ, ye bú a: «Bɔ̀ veên yeè gi aá wò mé njéh kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bɔ̀ɔ́ mé bɔ́ bɔ́ naâ gwò sâ bèh yâb yila baá-re lè bɔɔ̀n ndugó beleè ye: «Nùà hên yuoô he, mé à ye nùàr a: bɔ̀ veên seèn gi aá bú mé njéh kèn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeésò tueé njií cu mé ma doô, ye bú a: «Wò né temé cén yoòr mò kwaá njií, wò yili yuo aá kèn. Ndé bá-re.» ");
INSERT INTO mcu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jomo sâ Yeésò nde bele lè lɔɔ́ kokoô mé lɔɔ́ tetɔɔ̂r ndɔ, à né ŋgòr Càŋ teèn tueé, à né Njàgà Bagaà felè *Lò Càŋ se. Bɔ́ bɔ̀ mbɔ̀ŋ seèn yulà cùɔ̀b fà lé naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bɔ̀ véh déì lé naâ bɔ́ jomo ndɔ. Bɔ̀ déì, à lé naâ bɔ́ càŋ yoòr kwɔgɔ́ sɔm, à taré sɔm bɔ̀ déì lòù. Lé naâ Marî mé bɔ́ yilá né Marî Magdalâ; bɔ̀ càŋ tándulu téhbeh lé dula yuo kelà naâ lè seèn. ");
INSERT INTO mcu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Déì lé naâ Sòsánà bɔ̂ Jâne veèh Cusâ; Cusâ sâ lé naâ nùà koô te seé mgbè *Herôde. Bɔ̀ véh kókoó mbaá lé naá cuù jomo bɔɔ̀n teèn ndɔ, bɔ́ né bele mé bɔ̀ njeré déì beè beè, te bɔ́ gam beh bɔ̀ Yeésò mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bɔ̀ nùàr né lè lɔɔ́ dé kàn mé dé kân yuoô, bɔ́ né ká yoòr Yeésò bilí ndeê. Cìlì nùàr yeé baá doó, à si bɔ́ kàn, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Nuaré déì lé ndeè naâ ké ŋueh bèh gèh vuû. À yeé baá vuú, kèb déì sue le ceér dueè. Bɔ̀ nùàr né gulè dobó keéh, bɔ̀ non né gwaré yieé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kèb déì nde sue yila te kérré taâ. Yeé ba baá, ŋema yuo cu. Lòù sam, nòmò lé bèh sâ ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kèb déì nde sue yila lètenè bɔ̀ ŋgobó deduanê, ba yuo ndɔ. Yeé baá kulá, bɔ̀ ŋgobó hèllè lané wula sɔm bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kèb déì nde sue yila dé seèn bèh tàbè bagaà, ba yuoô, kula, wa tàb ŋgún.» À yeé tueé gi aá ménâ, à lɔgɔ njií ké ter ye bɔ́ a: «Nuaá né mé tie dé ŋgweê, bú a, ŋgwé nyégé ŋgòr hên bagasé.» ");
INSERT INTO mcu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bɔ̀ mbɔ̀ŋ seèn bie bú kwɔ̀m kàn sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","À ye bɔ́ a: «Dé biì, ŋgòr felè *Lò Càŋ mé Càŋ lɔ naâ lòù leér kwaá doô, Càŋ né bí ceér feh te bí ŋgweé komo. Dé bɔ̀ déì, kɔ bɔ́ si keéh bɔ́ lè kàne, te bɔ́ ke den dé keè, bɔ́ ŋéné cú; te bɔ́ fela den dé felâ, bɔ́ ŋgwé kɔ́ cú ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yeésò ye bɔ́ a: «Kàn sâ né mân: Gèh yaàb né ŋgòr Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Gèh mé lé naâ lè kpɔŋ ceér-e sue le doô né bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, *Sátàn waà, luaga sɔm cu bɔ́ lè; te bɔ́ temé teèn kwá njí cú, te bɔ́ yìlì yùò cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bɔ̀ɔ́ mé né te kérré taâ doô, né bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, bɔ́ gwaán nyegé mé vɔ́gɔ́-temé mene. Njèh cén, jɔgɔb lè bɔɔ̀n yí ŋgwéh, bɔ́ gwaán lom né cuúr cén mbaá. Mɔ gèr baá bɔ́ kema, bɔ́ cuaré yuo cu. ");
INSERT INTO mcu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bɔ̀ɔ́ mé né lètenè bɔ̀ ŋgobó deduanê sue yilá doô né bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, njèh cén, bɔ́ né mé *wɔ́ŋ nyamé le, bɔ́ né ŋgùlù wɔ̂ŋ fɔɔ́n, bɔ́ gwaán seér né wɔ́ŋ yieê. Sé yeé baá môn, bɔ̀ njèh hèllè karé wula sɔm njií ŋgòr Càŋ lè bɔɔ̀n ndɔ, tàb le kɔŋ. ");
INSERT INTO mcu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bɔ̀ɔ́ mé né dé bɔɔ̀n bèh tàbè bagaà sue yilá, né bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, bɔ́ né mé temé cén sie huɔɔ́m, bɔ́ né yoló, tàb né teèn yuo.» ");
INSERT INTO mcu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeésò ye bɔ́ a: «Bɔ́ lâm mɔ̀gɔ̀ bèh, ye te bɔ́ kibí kwaá ka sɔɔ̀ mé ka ndagâ. Bɔ́ lâm mɔgɔ seér né te bɔ́ tuú njií yí te súgo, bɔ̀ nùàr yilà gwò, bɔ́ ŋene njolo mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mè tueé bí, bɔ̀ njií mé né bèh cibì dɔɔ́ŋ nde gi né cie ŋené le; bɔ̀ dé bèh lèrrèb ŋené yuo kela giì bèsɔ́nè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«Sâ mɔ bí baá ŋgòr Càŋ ŋgweé, bí ŋgwé nyégé bagasé. Bí kɔ́ɔ ye, nuaré déì nde gi né mé njéh lè deí, bɔ́ haá sagá cu bú déì teèn. Nuaré déì dé seèn mé njéh lè sam nde ŋgweéh; né mene dé maàn mé à né munó ye nyí né mé njéh dɔɔ́ŋ, bɔ́ nde né bú lè horó sɔm.» ");
INSERT INTO mcu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Meì Yeésò mé bɔ̀ dìm Yeésò lé naâ yoòr Yeésò ndeé, bɔ́ wa, sâ bɔ̀ nùàr yuú tena baá toò, bɔ́ ceér kwà ŋgweéh. ");
INSERT INTO mcu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bɔ̀ nùàr tueé keéh ye Yeésò a: «Meí yeè bɔ́ bɔ̀ dìm yeè né wò yí cie ke den.» ");
INSERT INTO mcu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeésò ye bɔ́ a: «Meí mò mé bɔ̀ dìm mɔ̀ né seér bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, mé né ménâ bɔɔ́ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cieé déì Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn nde yila lè kɔme, à ye bɔ́ a: «Béh nde tub kèb yágà.» Bɔ́ yuo gò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bɔ́ né ka ndeé, bɔ́ wa beré déì, lɔ́m sie bú. Tètèì sam, fu baá kobó taré, né nòmò lè kɔme pieém njií den, kɔm baá yuú. Yeé nde aá jiím, ");
INSERT INTO mcu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","bɔ́ ŋgoró nde yí kwarè seèn, bɔ́ nyimé bú, ye bú a: «Dé koô, dé koô, béh nde aá kum le!» À nyimé yuoô, à pam fu bɔ̂ nòmò; bɔ́ huné, pɔ́ŋ die dùà. ");
INSERT INTO mcu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","À ye bɔ̀ mbɔ̀ŋ a: «Ndèm biì baá he wa?» Veéh kwaá njií bɔ́ be yoòr ndɔ, hiím yɔgɔ́ bɔ́ dé tueê. Bɔ́ yila lètenè bɔɔ̀n tueé kuú ye: «Nùà hên né neì? Kè kú: né mene fu, né mene nòmò, bɔ́ né sòn seèn ŋgweé!» ");
INSERT INTO mcu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bɔ́ sela yuo kela te tàbè bɔ̀ Jerasénè, sâ Galilê né kèb kân. ");
INSERT INTO mcu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yeésò suaga die doó. À yeé ke, nùà lɔɔ̂ déì baá ká yoòr seên ndeê. Nùà hèllè yoòr né mé tándulu. Dàb baá teèn mé à né luŋturu mbaá yɔŋ gɔ, à gwò cèr ŋgwéh, à cer yeé ké màsou. ");
INSERT INTO mcu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","À yeé nde ŋene njií Yeésò mân, à si kéŋ, à komo die nde doó ka seèn, à tueé njií ké ter, ye bú a: «Yeésò Ŋunà Càŋ terrèb, bélɔ̀ né lè keé-re wa? Kúkùr yeè, té mè gèr fèh.» ");
INSERT INTO mcu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sâ Yeésò la baá càŋ yí lè seèn paám, ye te à yuo kelà lè seèn. Lòù sam, cu dɔɔ́ŋ tándulu né yeé nùà hèllè seé weh. Mɔ baá bú seé weh, kɔ bɔ́ kaga bú be mé yuií lɔ̀ŋ, bɔ́ colo kwaá bú lè fɔ̀gɔ; mé njéh mene à né yeé bɔ̀ yuií hèllè tené sɔm, bɔ̀ tándulu lu njií bú ya dueè. ");
INSERT INTO mcu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeésò yeé pam gi aá tándulu, ye nùàr hèllè a: «Yilí yeè né neì wa?» Ye Yeésò a: «Yilí mò né: Bilíbɔ́.» À yilá kwaá né yilí seèn ménâ felè bɔ̀ càŋ tándulù ŋgún mé bilí den né lè seèn doô. ");
INSERT INTO mcu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bɔ̀ càŋ hèllè bɔŋ Yeésò ndɔ, ye bú a: «Té béh ké te lege ŋgɔbè kùm njí.» ");
INSERT INTO mcu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Cu sâ bɔ̀ŋ ŋguiâŋ né yab ké cueè tòr yieé den; bɔ́ né teèn ŋgún. Bɔ̀ tándulu hèllè bɔŋ Yeésò te bɔ́ nde yila den seér ké lè bɔ̀ ŋguiâŋ. Yeésò gwaán ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bɔ́ durá yuo kela baá-re lè nùà hèllè, bɔ́ nde yila nde lè bɔ̀ ŋguiâŋ. Bɔ̀ ŋguiáŋ kem ŋar suagà ké cueè, bɔ́ sue yila nde ké te tube, bɔ́ kum le dùà. ");
INSERT INTO mcu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bɔ̀ tèŋ ŋguiâŋ yeé nde ŋene njií mân, bɔ́ fɔɔ́n doò ndɔ, bɔ́ nde bɔ̀ nùàr ké lɔ mé kè kèbè mene tueé wellê. ");
INSERT INTO mcu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ bilí nde teèn, ye te bɔ́ nde njií mé la naâ bɔɔ́ sâ ŋené ndɔ. Bɔ́ wa, sâ nuaá mé bɔ̀ càŋ la kem yuoó naâ lè seèn doô né ké ka Yeésò mé cɔ̀gɔ̀ yoòr den den. À taré yuo aá kèn. Veéh bɔɔ́ bɔ́ njèh. ");
INSERT INTO mcu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Njií mé la kelà naâ yoòr nùà hèllè te à nde ye taré, bɔ̀ɔ́ mé la naâ ŋené dɔɔ́ŋ tueé nyegé cu bɔ̀ mbeí. ");
INSERT INTO mcu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yeé baá ménâ, bɔ̀ nùàr te tàbè bɔ̀ Jerasénè dɔɔ́ŋ, veéh bɔɔ́ bɔ́ njèh, bɔ́ ye Yeésò a: «Kúkùr yeè, yùò lè tàbè beèh yuoò.» Yeésò ŋaá yila cu kɔm ndɔ. À yeé baá mé gò, ");
INSERT INTO mcu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","nùà mé bɔ̀ tándulu naâ bú lè doô bɔŋ bú, te bɔ́ bú nde. Yeésò berɔ́ŋ, ye bú a: ");
INSERT INTO mcu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ndé dèn sér á ké lɔ yeè, wò tueé bele bɔ̀ nùàr njií mé Càŋ la naâ felè yeè bɔɔ́ dɔɔ́ŋ.» Nùà doô yuo baá-re doó sâ ndɔ. Njií mé Yeésò naâ felè seèn bɔɔ́ keéh dɔɔ́ŋ, à né lɔɔ́ mé njéh beè yɔŋ sie, à né bɔ̀ nùàr saán gɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeésò yuo cuù kèb yágà, à cu cuù, sâ cìlì nùàr né bú kela den. À yeé waà baá, bɔ́ vra bú. ");
INSERT INTO mcu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nùà koô *gwà sóù déì waà ndɔ; yilí seèn né Jàrûs. À cemmé nde ka Yeésò, à bɔŋ bú, ye te à nde ké lɔ nyî. ");
INSERT INTO mcu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sâ huaán gi lom né ka bú cén sâ, né dé vêh, à baá mé nyèmà yulà cùɔ̀b fà, à nde aá kuú dɔlé. Yeésò yuo gò ndɔ. À né ndeé, bɔ̀ nùàr né bú baré ŋeí. ");
INSERT INTO mcu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sâ ma déì né doó sâ teèn; baá nyèmà yulà cùɔ̀b fà húɔ́m né bú yoòr yuo den. Nuaá mé né beén sâ lɔ komo teèn sam. ");
INSERT INTO mcu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yeé baá mân, à ŋgoró nde yí jomo Yeésò, à kema weh sòn cɔ̀gɔ̀ seèn. À yeé baá kema, húɔ́m tené bú yoòr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeésò bie njií ye bɔ̀ nùàr a: «Neì mè kema né kɔɔ́?» Nùà kàn ye nyí sam. Piêr ye bú a: «Dé koô, bɔ̀ nùàr faŋ sela baá, bɔ́ baré né wò lòù.» ");
INSERT INTO mcu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yeésò ye bú a: «Nùà sâ mè kema naâ mé be. Terreb mò kèb déì naâ yoòr mò yuo.» ");
INSERT INTO mcu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma doô yeé kɔ aá ye, nyí lèr kòmò ndé cú, à ndelé ndeè ká toò Yeésò ndɔ, à die nde ka seèn, à se bú kwɔ̀m mé à la kemá naâ bú mé njéh, à bú se gi toò bɔ̀ nùàr doó sâ, à tueé cu bú gèh dé mé beén seèn la naâ gií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeésò ye bú a: «Huaán mò, wò né lom temé cén yoòr mò kwaá njií, wò taré yuo aá kèn. Ndé bá-re.» ");
INSERT INTO mcu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yeésò née seèn mé ma doô tueé den, tóm waà ndɔ, ye Jàrûs a: «Ŋuna yeè kuú aá ma. Té yeè Nùà fèh-njèh mbaá kì kú cú.» ");
INSERT INTO mcu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeésò yeé ŋgweé aá ménâ, ye Jàrûs a: «Té vèh, kwá njí lòm ndèm mé mè; ŋuna yeè nde né taré.» ");
INSERT INTO mcu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bɔ́ yeé wa baá ké lɔ Jàrûs, Yeésò yiín bɔ̀ nùàr dɔɔ́ŋ gwò yilâ, gi cegé bɔ́ bɔ̀ Piêr, mé Jâŋ bɔ̂ Jâk, mé bɔ̀ tele bɔ̂ meì huaân. ");
INSERT INTO mcu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sâ bɔ̀ nùàr baá huaán yueé, bɔ́ né mbà genné den. Yeésò deên ndɔ, ye bɔ̀ nùàr a: «Bí té yúé. Huaán njeré déì kú ŋgwéh, à cer né lɔ́m.» ");
INSERT INTO mcu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Te bɔ̀ nùàr yeé nde ŋgweé njií ménâ, bɔ́ kem sue bú yoòr mé séb. Sâ bɔ́ kɔ gi aá ye huaán doô kuú aá kèn. ");
INSERT INTO mcu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeésò kɔ lom né dé seèn huaán be ter sie njiî, à né bú yilá, ye bú a: «Huaán mò, wùò ter!» ");
INSERT INTO mcu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Huaán doô nyimé yuo ndɔ, à yila cu hueè, à komo wuo ter. Yeésò ye: bɔ́ fɔ́n há bú yáb. ");
INSERT INTO mcu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Geí lɔ tele bɔ̂ meí mbaá. Yeésò luɔm bɔ́ ndɔ, ye bɔ́ a: «Bɔ̀ njií mé naâ kelá hên, Càŋ a bɔ́ bí tueé nuaré déì.» ");
INSERT INTO mcu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cieé déì Yeésò lé naâ bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà yilá bilí, à jege haá bɔ́ terreb, te bɔ́ kwɔgɔ sɔm bele bɔ̀ nùàr càŋ tándulu yoòr, te bɔ́ taré sɔm bele bɔ̀ beên bɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ye bɔ́ a: «Bí ndé *Lò Càŋ se, bí né bɔ̀ nùàr taré sɔm bele. ");
INSERT INTO mcu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bí té njeré déì beè wèh sìè: né mene cùgò mé ba, né mene yáb, né mene kàgàlɔ̀ŋ, bí té beè wèh sìè. Nùà kàn a, té cɔ̀gɔ̀ suù fà wèh sìè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bèh dɔɔ́ŋ mɔ bí wa, bɔ́ feh bí bèh cèrrè, bí dèn lòm gwò sâ, bí té beré déì ndé sèr. Mɔ bí cer wulu baá, bí yuo. ");
INSERT INTO mcu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mɔ bí wa beré déì, bɔ̀ nùàr bí wèh ŋgwéh, bí yùò kwá lɔ́ bɔ́ nɔɔ́ŋ. Mɔ bí baá lɔ sâ yuo, bí kàrè sɔ̀m gí fùfú lɔɔ́ sâ gulè biì karè, te duɔɔ̂m bɔ́ toò tueé kwaâ.» ");
INSERT INTO mcu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bɔ́ yuo gò ndɔ, bɔ́ nde bele lè lɔ mé lɔ, bɔ́ né Njàgà Bagaà se yɔŋ, bɔ́ né bɔ̀ beên bɔ̀ bèh dɔɔ́ŋ taré sɔm bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sâ njií mé né kelá dɔɔ́ŋ, mgbè Herôde lé naá giì ŋgweé, né bú seé weh. Lòù sam, bɔ̀ nuaré déì lé naâ tueé ye: né Jâŋ Bàptîs dòù komo yuo cuù né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bɔ̀ déì ye, né *Elî kar waà né kɔɔ́; bɔ̀ déì ye: né *sòn-Càŋ déì lètenè bɔ̀ léí jɔ̀gɔ̀ bɔ̀ dòù komo yuo kelà né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herôde dé seèn ye: «Dé Jâŋ, ŋgweéh mè lé naâ bú feh tená sɔm mà. Dé mé njàgà seèn né ŋgulí hên né cu neì?» À yila baá-re ceér fɔɔ̂n, ye kɔ nyí ŋene baá Yeésò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bɔ̀ mbɔ̀ŋ tebê Yeésò cu cuù ndɔ, bɔ́ tueé bú njií mé bɔ́ lé bɔɔ́ keéh naâ dɔɔ́ŋ. À yeé ŋgweé gi aá, à weh bɔ́ léláŋ bɔɔ̀n, bɔ́ bɔ́ nde lè lɔɔ́ déì, yilí lɔɔ́ sâ né Becaida. ");
INSERT INTO mcu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ kem bele bɔ́ jomo. Bɔ́ yeé waà baá, Yeésò sie nyegé bɔ́, à duɔɔ́m bɔ́ Lò Càŋ seè. À taré sɔm bele cu bɔ̀ beén bɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lou yeé yuɔm aá, bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô ŋgoró nde kwarè seèn, bɔ́ ye bú a: «Bèh hên né ká jomo kela. Wò sé la kwa lɔ bɔ̀ nùàr cu cu jomo bèh cèrrè lelɔ fɔɔ́n beleè, te bɔ́ fɔɔ́n yieé keéh yáb teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yeésò ye bɔ́ a: «Bí há bɔ́ yáb kɔɔ́.» Bɔ́ ye bú a: «Béh beè né cegé mé breêd tîn, mé ŋgò fà té fá. Wò ye te béh nde dàm nùàr hên dɔɔ́ŋ yáb lòù ŋge haá wa?» ");
INSERT INTO mcu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sâ lètenè bɔ̀ nùàr sâ dɔɔ́ŋ, bɔ̀ siíb lé naâ njèh kám tîn. À ye bɔ̀ mbɔ̀ŋ a: «Bí júée bɔ́ a: bɔ́ dèn ndé gí doó, bɔ́ dèn bèlè yulà títîn, yulà títîn ma.» ");
INSERT INTO mcu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bɔ̀ mbɔ̀ŋ tueé njií bɔ́ ndɔ, bɔ́ den bele baá-re méménâ. ");
INSERT INTO mcu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeésò weh breêd tîn mé ŋgò fà doô, à ke njií njolo ké te vulúu, à dua Càŋ teèn, à kɔlé haá njií mé bɔ̀ mbɔ̀ŋ, te bɔ́ geé haá mé cìlì nùàr. ");
INSERT INTO mcu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dɔɔ́ŋ bɔ́ yieé fulu gi, ndilí le. Bɔ́ ŋuaán, yuú cu sɔgɔ́ yulà cùɔ̀b fà. ");
INSERT INTO mcu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cieé déì Yeésò lé naâ ké bèh ndɔ́ŋ-ndɔ̀ŋ Càŋ dua; à lé naâ mé bɔ̀ mbɔ̀ŋ jomo. À bie njií ye bɔ́ a: «Bɔ̀ nùàr ye, mè né neì wa?» ");
INSERT INTO mcu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bɔ́ ye bú a: «Bɔ̀ déì ye wò né Jâŋ Bàptîs; bɔ́ déì ye wò né *Elî, bɔ̀ déì ye né *sòn-Càŋ léí jɔ̀gɔ̀ déì komo yuo cuù né dòù kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ye bɔ́ a: «Á bí nɔ; bí ye mè né neì wa?» Piêr ye bú a: «Wò né *Nùà Cɔ̀ŋ mé naâ beè Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeé baá môn, Yeésò luɔm bɔ́ ndɔ, ye bɔ́ a: «Càŋ a bɔ́ bí tueé nuaré déì.» ");
INSERT INTO mcu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","À den cuù, ye bɔ́ a: «Kɔ *Huaán Nùàr nde dàm bɔ̀ gèr ŋené laré. Bɔ̀ kokoô bɔ̀ lɔɔ̂ mé bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù dɔɔ́ŋ, nde gi né bú ŋgɔɔ́n, te bɔ́ wula sɔm bú wulà. Lè cieé tagáre à nde cu né lè cio komo yuo ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","À tueé njií mé bɔ̀ nùàr dɔɔ́ŋ ndɔ, ye bɔ́ a: «Nuaá mé ye nyí gwaán né jomo mò beleè dɔɔ́ŋ, kɔ à ŋgɔn feh seèn, cieé dɔɔ́ŋ à né toú gèr seèn mbiín weh, à né mè jomo bele, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mè tueé bí: nuaá mé gwaán né yɔ̀ŋ seèn mé feh seèn yili sɔm, nde né bú leér lɔɔ́; nuaá mé né dé seèn cio felè mò ŋgɔɔ́n seér, nde né yɔ̀ŋ seèn yili sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Njií mé gam nde né nuaá mé né njèh ká lè wɔ́ŋe dɔɔ́ŋ kwa laré te yɔ̀ŋ seèn nyoló le teèn, né kei wa? Ndɔ́g, teèn sam. ");
INSERT INTO mcu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mɔ nuaré déì yaáŋ mè, yaáŋ ŋgòr mò, sâ loù mé mè *Huaán Nùàr nde né teèn *sum waâ, mè sum waà nde né lètenè bɔ̀ cìlì Càŋ mé terreb Tele mò yoòr, loù sâ mè nde né nùà hèllè yaáŋ sɔm ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mè né tueé ye bí a, mé bí nde dɔɔ́ŋ kuú gií, sâ bɔ̀ déì lètenè biì hên ŋene aá *Lò Càŋ mé njolo.» ");
INSERT INTO mcu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yeésò yeé tueé sɔm aá, bɔɔ́ cu njèh cieé téhbeh, mé téndelé à weh Piêr mé Jâŋ bɔ̂ Jâk, bɔ́ bɔ́ ŋaá nde ké felè tòr bèh Càŋ duaà. ");
INSERT INTO mcu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","À yeé baá Càŋ dua, kuún seèn kweéh seér ndɔ, bɔ̀ cɔ̀gɔ̀ yoòr seèn dɔɔ́ŋ ŋa seér gi bɔ̀ dé wuwulê, wula ŋuerré seér lòù. ");
INSERT INTO mcu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bɔ̀ nuaré déì kar yuo kela toò seèn fà, bɔ́ bɔ́ né njeré déì tueé den: lé naâ Músì bɔ̂ *Elî. ");
INSERT INTO mcu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bɔ́ lé *sum yuo kelà naâ lòù. Bɔ́ bɔ́ tueé den né felè cioò mé à nde né ké Jerusalem kuú, te seé seèn jege doô. ");
INSERT INTO mcu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sâ Piêr bɔ́ bɔ̀ mbeí la kuú loóm aá dé bɔɔ̀n lɔ́m dé kuû. Bɔ́ yeé nde nyimé yuoô mân, bɔ́ ŋene njií lom aá Yeésò yí te *sùsùm seèn, mé bɔ̀ nuaré déì fà kwarè. ");
INSERT INTO mcu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bɔ̀ nùà fà doô yeé nde aá yuo, Piêr ye Yeésò a: «Dé koô, kwá béh den le kɔ hên, béh sie pàgà tagár, dé yeè cén, dé Músì cén, dé Elî cén ndɔ.» Sâ Piêr tueé nderré weh né mbaá. ");
INSERT INTO mcu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","À yeé baá sònò mân tueé den, bègè déì suagà ter, ka sie bɔ́ beè. Bɔ̀ mbɔ̀ŋ doô yeé surí le aá teèn ménâ, veéh bɔɔ́ bɔ́ njèh. ");
INSERT INTO mcu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hueh déì né yí lètenè bègè sâ ŋgulí den ye: «Hên né Ŋuna mò, mè sɔm kwaá né bú, bí ŋgwé gí sòn seèn.» ");
INSERT INTO mcu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hueh doô huné ndɔ. Bɔ́ yeé ke, Yeésò le cu aá mé huún. Bɔ̀ mbɔ̀ŋ huné lɔ lè bɔɔ̀n nɔɔ́ŋ ménâ; njií mé bɔ́ la naâ dɔɔ́ŋ ŋené gií, bɔ́ mé nuaré déì cu sâ túé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cieé ŋaga bɔ́ suaga cuù. Sâ bɔ̀ nùàr kókoó mbaá baá yoòr Yeésò ndeê, bɔ́ bɔ́ kwaré le ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nuaré déì lɔgɔ njií ké ter yí lètenè bɔ̀ nùàr, ye Yeésò a: «Kúkùr yeè, Nùà fèh-njèh, huaán gi lom né ka mè cén hên, kè njí yeè mè bú njolo yoòr teèn; ");
INSERT INTO mcu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","à né mé càŋ déì yoòr teèn, mɔ baá bú ŋaâ, à keéŋ gɔ mbembaá, né yeé bú jilí taré dé gècên, fuú né bú sònò yuo, càŋ hèllè né-re bú nu den. Kɔ huaán njɔgɔ́ gi aá, à yi ye bú. ");
INSERT INTO mcu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mè la naâ bɔ̀ mbɔ̀ŋ yeè bɔŋ, te bɔ́ kwɔgɔ sɔm bú, né bɔ́ taré yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeésò deên ndɔ́, ye: «Jue ka bí bɔ̀ dúágá-tie bɔ̀, mé jéré-temé biì sâ! Hên, béh bí née cu-re heèh wa? Mè bí seŋ den cu nde né heèh ndɔ wa? Wèh ndê mé huaán sâ kán.» ");
INSERT INTO mcu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huaán doô yeé nde aá kwarè Yeésò waá, tándulu hèllè nela si njií cu baá ye-re bú doó mé terreb. Yeésò pam kwɔgɔ sɔm bú yoòr huaán doô ndɔ, à taré sɔm bú, à haá njií cu bú mé tele. ");
INSERT INTO mcu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","*Sùsùm Càŋ sie laré bɔ̀ nùàr doó dɔɔ́ŋ, bɔ́ né teèn hiím den. Sâ bɔ̀ njií mé Yeésò lé bɔɔ́ giì naâ dɔɔ́ŋ née den ka bɔ̀ nùàr geí lɔɔ́ ye. À tueé njií cu mé bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Kènê bí ŋgwé nyégé bagasé: *Huaán Nùàr nde né beè bɔ̀ nùàr yilá.» ");
INSERT INTO mcu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bɔ̀ mbɔ̀ŋ ŋgwé kɔ́ ŋgwéh, njeré déì lé ndegé yɔgɔ́ naâ bɔ́ lòù. Bɔ́ mé Yeésò bíé njí ŋgwéh ndɔ, veéh lé naâ bɔ́ sie yɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bɔ̀ mbɔ̀ŋ duɔɔ́m baá-re lètenè bɔɔ̀n saán kuû, te bɔ́ ŋene kɔ nuaá mé né dé koô teèn. ");
INSERT INTO mcu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeésò yeé ŋene mùnò bɔɔ̀n né ménâ, à weh njebá kwaá huaán déì ká toò seèn, ");
INSERT INTO mcu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ye bɔ̀ mbɔ̀ŋ a: «Nuaá mé né huaán hên felè mò sie nyegé, sie nyegé né mè; nuaá mé né mè sie nyegé, sie nyegé né Tele mò mé lé temà naâ mè ndɔ. Bí kɔ́ɔ ye, lètenè biì nuaá mé né huaán maàn dɔɔ́ŋ, dé koô né seér bú.» ");
INSERT INTO mcu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jâŋ deên ndɔ, ye Yeésò a: «Dé koô, béh la naâ nuaré déì ŋené, à lè bɔ̀ŋ beèh sam, à né bɔ̀ tándulu kwɔgɔ́, à bɔ́ kwɔgɔ́ den né mé yilí yeè; béh la naâ bú yiín.» ");
INSERT INTO mcu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeésò ye bú a: «Bí té bú yín. Mɔ nùàr bí bùnò ŋgwéh, sâ à né jomo biì.» ");
INSERT INTO mcu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sâ cu mé Càŋ nde aá Yeésò ké te vulúu weh njií, ndeè aá wulú. Yeésò ye kɔ nyí wa baá ké Jerusalem ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","À tema keéh baá-re bɔ̀ tebé bɔ̀ toò. Bɔ́ yuo gò, bɔ́ wa lè lɔɔ́ déì te tàbè Samarî, te bɔ́ nyegé kwaá bú bèh teèn. ");
INSERT INTO mcu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bɔ̀ lɔɔ̂ bɔ̀ yeé ŋgweé aá ye, bɔ́ sâ nde né ké Jerusalem mân, bɔ́ bɔ́ sìè nyégé cú. ");
INSERT INTO mcu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bɔ̀ mbɔ̀ŋ seèn Jâk bɔ̂ Jâŋ yeé ŋene aá ménâ, bɔ́ ye Yeésò a: «Fehtoò beèh, kwá béh bie njií we suagà ké te vulúu ŋgie sɔm bɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeésò bele seér ndɔ, nde bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bɔ́ bɔ́ fɔɔ́n gò, bɔ́ nde ser lè lɔɔ́ déì. ");
INSERT INTO mcu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bɔ́ yeé baá ceér dueè, nuaré déì ndeè ye Yeésò a: «Wò nde mene he, bélɔ̀ nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeésò ye bú a: «Hên bɔ̀ nyam bɔɔ̀n né mé gbàŋ, bɔ̀ non mé fulu ndɔ. Kɔ́ɔ ye, *Huaán Nùàr dé seèn mé bèh cèrrè teèn sam.» ");
INSERT INTO mcu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jomo sâ, à tueé njií mé déì, ye bú a: «Bèlè mè.» Dé sâ ye bú a: «Dé koô, kúkùr yeè, kwá mè ndeè furú sɔm tele mò ye.» ");
INSERT INTO mcu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeésò ye bú a: «Kwá lɔ́ bɔ̀ komó nde furú bɔ̀ mbeí bɔɔ̀n kɔɔ́. Ndé dé yeè bɔ̀ nùàr *Lò Càŋ se nyegé.» ");
INSERT INTO mcu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Déì den cuù ye Yeésò a: «Dé koô, mè nde né jomo yeè bele. Kúkùr yeè, kwá mè nde jɔ̀gɔ̀ bie wellê bɔ̀ nùàr mò ye.» ");
INSERT INTO mcu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeésò ye bú a: «Mè tueé wò, nuaá mé né boór kieé, né njolo jomo ke tená njií, dé seèn nùà seê Lò Càŋ wúlú ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jomo sâ, Fehtoò beèh balé sɔm cu bɔ̀ mbɔ̀ŋ déì yulà téhbeh cùɔ̀b fà ndɔ, à tema keéh bɔ́ toò fèfà fèfà, te bɔ́ nde te lɔɔ́ hihinê mé à nde né teèn ndeé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ye bɔ́ a: «Yab bɔlé lom né ŋgún. Njèh cén, bɔ̀ seê bɔ̀ mé nde né ká lɔ kwaá bilí njiî màgà ŋgwéh. Bí bɔ̀ŋ nùà njèh bɔɔ̀ŋ, te à tema njií bɔ̀ seê bɔ̀ teèn, te bɔ́ kwa bilí njiî bú mé njéh ká lɔ. ");
INSERT INTO mcu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","«Bí ndé-re. Mè bí hên yi njií né faá bɔ̀ huaán sòrŋgaàŋ lètenè bɔ̀ ŋgùì nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bí té njeré déì beè wèh sìè: né mene kàgàlɔ̀ŋ, né mene ba, né mene débágá, bí té beè wèh sìè. Bí té nuaré déì ceér dueè njébá bíé gɔ̀. ");
INSERT INTO mcu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mɔ bí nde aá gwò nuaré déì yilá, bí jɔ̀gɔ̀ júée bɔ̀ gwà bɔ̀ a: Kùsèm, dɔlê a dèn mé bí ma! ");
INSERT INTO mcu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mɔ nùà bagaà déì né gwò sâ teèn, sâ dɔlê biì nde né felè seèn den. Mɔ sam, bí jɔ́gɔ́ yùò cú mé dɔlê biì. ");
INSERT INTO mcu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mɔ bí baá gwò sâ, bí dèn lè teèn, bí yíé, bí ŋúé dèn bɔ̀ njií mé bɔ́ haá né bí dɔɔ́ŋ gwò sâ. Bí kɔ́ɔ ye, nùà seê yieé né mé seé seèn. Bí té gùgwò lób ndé bèlè. ");
INSERT INTO mcu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Mɔ bí wa lè lɔɔ́ déì, bɔ́ né bí teèn sie nyegé, bí yíé lòm ká bɔ̀ njií mé bɔ́ né bí haá. ");
INSERT INTO mcu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bí táré sɔ̀m bèlè bɔ̀ beên bɔ̀ lɔ sâ tarè, bí júée bɔ̀ lɔɔ̂ bɔ̀ a: Càŋ baá mé Mbàm seèn ká kwarè bɔɔ̀n si ndeê ma. ");
INSERT INTO mcu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","«Mɔ bí wa lè lɔɔ́ déì, bɔ́ bí teèn wèh ŋgwéh, bí ndé ké mbartɔgɔ̂, bí júée bɔ̀ lɔɔ̂ bɔ̀ a: ");
INSERT INTO mcu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","fùfú lɔɔ́ bɔɔ̀n sâ ma, bú a, ndé cú mé bɔ́, à té béh gulè mbaá mègè lè. Bí júée bɔ́ a: Njèh cén, bɔ́ kɔ́ɔ ye, Càŋ baá mé Mbàm seèn kwarè bɔɔ̀n si ndeê ma. ");
INSERT INTO mcu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mè tueé bí, sâ loù téná-juù, gèr ŋene kela nde né lɔɔ́ hèllè mé *Sɔ́dɔ̀m.» ");
INSERT INTO mcu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yeésò deén baá-re ye: «Wò lɔɔ́ Korasêŋ, wò nde né meì bɔ̀ gèr ŋené! Becaida wò nde né gèr ŋené ndɔ! Mɔ gèh fém mé lé bɔɔ́ naâ lètenè biì hên sé bɔɔ́ naâ ké Tîr bɔ̂ Sídɔ̀ŋ, mè tueé bí, dàb mé bɔ̀ nùàr ké sâ sé lɔ temé kweéh seér gi aá kèn, bɔ́ den ka nde doó, bɔ́ yií wè, bɔ́ su tou, te feh keéh ye bɔ́ kweéh seér aá temé. ");
INSERT INTO mcu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mè tueé bí, loù ju tenâ, gèr dé biì taré kela nde né kɔɔ́ mé dé Tîr bɔ̂ Sídɔ̀ŋ hèllè. ");
INSERT INTO mcu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Déì né cu wò Kapernahûm; wò munó né ye, nyí nde né ké te vulúu ŋgulí waá wa? Ndɔ́g, mè tueé wò, bɔ́ wò ba njií seér nde né ké ndugo bɔ̀ càŋ; kwá yeè!» ");
INSERT INTO mcu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","À den cuù ye bɔ̀ mbɔ̀ŋ seèn a: «Mè tueé bí, nuaá mé né sòn biì ŋgweé dɔɔ́ŋ ŋgweé né sòn mò. Nuaá mé né bí ŋgɔɔ́n, ŋgɔn né mè ndɔ. Nuaá mé ŋgɔn mè, ŋgɔn né Nuaá mé lé temà naâ mè.» ");
INSERT INTO mcu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bɔ̀ tebé bɔ̀ yulà téhbeh cùɔ̀b fà doô cu cuù mé vɔ́gɔ́-temé, bɔ́ ye Yeésò a: «Fehtoò beèh, njií mé béh tueé naâ mé yilí yeè dɔɔ́ŋ, né mene bɔ̀ tándulu, bɔ́ naá giì sòn beèh ŋgweé.» ");
INSERT INTO mcu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeésò ye bɔ́ a: «Mè naâ *Sátàn ŋené njií, à die suagà naâ ter faá mbàn nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","À deén baá-re ndɔ, ye bɔ́ a: «Mè lé naâ bí terreb haá, te bí dobo keéh bɔ̀ sàb mé taŋtàŋ gulè; bí né Sátàn mé be terrèb seèn mene gulè dobo keéh, njeré déì bí bɔ́ ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Njèh cén, bí té vrà ye bɔ̀ tándulu ŋgweé aá sòn biì kèn. Yilí biì mé baá ké te vulúu nyagá den, bí jɔ̀gɔ̀ vrà sér cí.» ");
INSERT INTO mcu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Loù sâ Yeésò lé naá loôm mé vɔ́gɔ́-temé dé gècên. Lòù sam, Cúcuí Ŋagâ lé naâ bú yoòr ŋgulí. Yeé baá ménâ, à vra Càŋ, ye bú a: «È môn, Tele mò, vulú bɔ̂ tàbè né gi beè yeè, mè vra baá wò! Lòù sam, njií mé né njolò bɔ̀ kɔ́gɔ̀n bɔ̀ mé bɔ̀ lo bɔ̀ cibi mbaá leér den, njua yeè mé wò bɔ́ feh keéh seér né mé bɔ̀ huaán tetɔɔ̂r mân. È môn, Tele mò! Sâ né njií mé wò gwaán nê. ");
INSERT INTO mcu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Mè tueé bí, Tele mò njèh dɔɔ́ŋ kwaá lɔ gi né beè mò. Mé njéh mene nuaré déì kɔ́ ŋgwéh ye: hên né Huaán; gi cu né ka Tele. Nuaré déì kɔ́ ŋgwéh ye: hên né Tele ndɔ, gi cu né ka Huaán mé bɔ̀ɔ́ mé Huaán né bɔ́ Tele feh doô.» ");
INSERT INTO mcu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yeé gi aá, à bele seér, à tueé njií lom mé bɔ̀ mbɔ̀ŋ seèn, ye bɔ́ a: «Dé biì, njua biì wa. Lòù sam, bí ŋene né bɔ̀ njií hên mé njolo. ");
INSERT INTO mcu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mè tueé bí, dàm bɔ̀ *sòn-Càŋ bɔ̀ mé bɔ̀ mgbè kókoó mbaá lɔ ye te bɔ́ ŋene faá bí né ŋené hên, ndɔ́g; bɔ́ ye te bɔ́ ŋgweé kwa faá bí né ŋgweé hên, ndɔ́g ndɔ, dɔɔ́ŋ lé naá giì bɔ́ liím.» ");
INSERT INTO mcu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","*Njí-sóù déì ndeè Yeésò sòn felá weh, ye bú a: «Nùà fèh-njèh, mè bɔɔ́ nde né naàn, te mè kwa ye yɔ̀ŋ dé ndeèr wa?» ");
INSERT INTO mcu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeésò ye bú a: «Bɔ́ te sóu nyagá né kei wa? Wò teèn ŋgweé yeé naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nùà hèllè ye bú a: «Bɔ́ nyagá kwaá né ye: Gwàn gí Càŋ Nùà Dueè mé temé yeè mene, mé càŋ yeè mene, mé terreb yeè mene, mé mùnò yeè mene dɔɔ́ŋ ma; wò gwaán cu mbeí yeè faá wò gwaán né ŋgàŋ yoòr yeè nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeésò ye bú a: «Môn, wò tueé yií né teèn. Ndé bɔ́ dèn ká méménâ nág, te wò yili yuo ye.» ");
INSERT INTO mcu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nùà hèllè bie nyegé cu, te bɔ̀ nùàr ye nyí né nùà gècên, ye bú a: «Neì né cu mbeí mò kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeésò deên ndɔ, ye bú a: «Nuaré déì lé yuoó naâ Jerusalem, à né ké Jerikò suagá ndeé, à wa ceér dueè beré déì, à die yila beè bɔ̀ yîb bɔ̀ wúlá-feèh déì. Bɔ́ huaré gi bú cɔ̀gɔ̀ yoòr, bɔ́ lobo si lɔ bú ceér dueè, sâ à nde aá kuú dɔlé. ");
INSERT INTO mcu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","«*Ŋgàŋ sèmè déì naâ jomo seèn ndɔ, à waà, à né bú yí doó ŋené njií, à wɔɔ́ŋ kela sa. ");
INSERT INTO mcu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nùà *Levî déì wa cuù, ŋene njií bú yí doó, wɔɔ́ŋ kela cu ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Nùà *Samarî déì naâ bèh gò seèn, à waà jomo bɔɔ̀n, à ŋene njií nùà doô yí doó, jere bɔɔ́ bú njèh, ");
INSERT INTO mcu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","à suaga die doó, à se weh kómó mé mbè seèn lè baà, à berré njií bú lè nyer-e, à yaga nyegé, à kaga nyegé gi bú bɔ̀ nyer sâ dɔɔ́ŋ, à jɔgɔ kwaá bú ŋgètenè nyaàm, à derré njií bú ké lɔ, à nde gwɔm bèh cèrrè lòù, à ke nyegé bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cieé ŋaga, à sɔm kwaá lɔ nùà gwà kàgàlɔ̀ŋ déì, lé naâ kám fà, ye bú a: kè nyégé nyí nùà hên jomo mé njéh. Bɔ̀ njií mé wò nde cu né felèbɔ̀ sagá dɔɔ́ŋ, mɔ nyí cuù baá, nyí nde né wò gwɔm gií.» ");
INSERT INTO mcu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yeésò yeé tueé gi aá, ye njí-sóù doô a: «Beè yeè, lètenè bɔ̀ nùà tagâr hên, dé heè né mbeí nuaá mé lé die yilà naâ beè bɔ̀ yíb bɔ̀ doô kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Njí-sóù hèllè ye bú a: «Mbeí seèn né dé mé kɔɔ̀ naâ bú jere doô.» Yeésò ye bú a: «Mé wò mene, ndé ménâ bɔɔ́ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeésò bɔ́ bɔ̀ mbɔ̀ŋ né ka ndeé, bɔ́ wa lè lɔɔ́ déì; ma déì weh njií bɔ́ ké lɔ seèn; yilí ma sâ né Mártà. ");
INSERT INTO mcu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma sâ lé naâ mé dìm teèn ndɔ. Yilí dìm né Marî. Marî lé dé seèn ndeè naâ ké kwarè Fehtoò beèh, à den nde ka seèn, bɔ̀ njií mé Yeésò né tueé dɔɔ́ŋ, à né felá den. ");
INSERT INTO mcu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sâ Mártà né ké gwò mé seé yâb feh hihinê kwaré. À ŋar waà ndɔ, ye Yeésò a: «Fehtoò beèh, wò yúlá ŋgwéh mé dìm mò kwaá lɔ né mè seé yâb beè mé huún wa? Sâ júée bú a, ndê gàm mè teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Fehtoò beèh ye bú a: «Mártà, Mártà, wò dé yeè nyamé le né mé njèh ŋgún bɔɔ́ larê. ");
INSERT INTO mcu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kɔ́ɔ ye, dé bagaà né cén. Marî dé seèn ke sɔm né dé mé huɔm kela né kɔɔ́. Nuaré déì ndeè bú beè lùàgà sɔ̀m ndé cú.» ");
INSERT INTO mcu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cieé déì Yeésò naâ beré déì, à né Càŋ dua den. À yeé dua sɔm aá, mbɔ̀ŋ seèn déì ye bú a: «Fehtoò beèh, dùà fèh béh Càŋ teèn, dùà fèh béh faá Jâŋ lé dua feéh naâ bɔ̀ mbɔ̀ŋ seèn nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeésò ye bɔ́ a: «Mɔ bí baá dua, bí júée: Tele beèh, yilí yeè a: dèn beè bɔ̀ nùàr jolosé. Ndê kɔgɔ yeè ká lètenè beèh dilí kwaá. ");
INSERT INTO mcu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wò né béh yáb cieé dɔɔ́ŋ haá. ");
INSERT INTO mcu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kúlú njí bɔ̀ veên beèh doó faá béh né dé bɔ̀ mbeí beèh lè beèh kulú sɔm nɔ. Bèh mé veên né béh taáb dɔɔ́ŋ, té béh teèn njí.» ");
INSERT INTO mcu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeésò den cuù ye bɔ́ a: «Hên, den né faá mɔ lètenè biì nuaré déì kwa kìn lètenè cibî: à wuo ter, à nde ké lɔ mbeí seèn déì, ye bú a: Hùà há nyí yáb teèn; há nyí sér weh tagár ma. ");
INSERT INTO mcu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kìn kwa né nyí kɔɔ́; né mbeí nyî cén déì waà né kɔɔ́, à nde né bèh gò. Ké gwò nyî njií mé à nde né sònò yií njií, teèn sam. ");
INSERT INTO mcu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mɔ mbeí den seér cuù kèb gwò ye bú a: Té nyí kì, nyí colo gi aá hin kèn. Bɔ́ bɔ̀ huaán nyî cer gi aá doó, nyí ter wùò ndé cú te nyí haá wò sér. Té nyí kì ma.» ");
INSERT INTO mcu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yeésò den cuù, ye bɔ́ a: «Mɔ à né mene ménâ tueé, sâ à mbeí gàm ndé ŋgwéh wa? Mè tueé bí, à nde né ter wuo, à gam bú. Njèh cén, à ter wùò ndé cú, ye né mbeí nyî, baá seér dé te mbeí bú dùà kì dèn cú. Bɔ̀ njií mé mbeí gwaán keéh né dɔɔ́ŋ, à nde né bú haá gií. ");
INSERT INTO mcu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Mè tueé bí: Bí dùduaà, bɔ́ nde né bí haá; bí féfɔɔ̀n, bí nde né kwa; bí gɔ́ hin gɔɔ̀, bɔ́ nde né bí gulu keéh. ");
INSERT INTO mcu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lòù sam, nuaá mé né dua dɔɔ́ŋ, nde né kwa; nuaá mé né fɔɔ́n dɔɔ́ŋ, nde né ŋené; bɔ́ nde né nuaá mé né gɔɔ́ dɔɔ́ŋ gulu keéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Hên mɔ nuaré déì lètenè biì né tele, ŋuna dua bú ŋgò, à sie haá seér nde né bú sàb wa? ");
INSERT INTO mcu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mɔ sam, à sie haá seér bú taŋtàŋ, sâ ŋuna dua né bú gei cuaàr wa? ");
INSERT INTO mcu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bí, mé jéré-temé biì mene, bí né bɔ̀ ŋuna biì bɔ̀ njèh bebagaà haá komo; sé tagá Tele biì ké te vulúu wa? Bí kɔ́ɔ ye, bɔ̀ɔ́ mé né bú Cúcuí Ŋagâ dua dɔɔ́ŋ, à nde né bɔ́ haá.» ");
INSERT INTO mcu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Cieé déì, sâ Yeésò né tándulu yoòr nuaré déì kwɔgɔ́. Tándulu hèllè lé naâ nùà sâ sòn sie huné. Yeésò yeé kwɔgɔ sɔm aá bú, nùà hèllè yila sòn tueê ndɔ. Geí laré bɔ̀ nùàr doó dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bɔ̀ déì tueé seér ye: «*Beljebu mgbè bɔ̀ tándulù haá né bú terreb mân kɔɔ́, à bɔ̀ tándulu kwɔgɔ́ den né mé njéh.» ");
INSERT INTO mcu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bɔ̀ déì né bú sòn lòù felá seér, ye bú a: «Jɔ̀gɔ̀ bɔ́ ke fém cén déì te feh keéh ye wò seé hên bɔɔ́ né mé terreb Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yeésò kɔ gi mùnò bɔɔ̀n ndɔ, ye bɔ́ a: «Né mene lè lò mgbè dé heè, mɔ bɔ̀ nùàr né lètenè bɔɔ̀n kerré kuú, lò sâ nde né tɔb yuo, bɔ́ kum le mé gwà mene. ");
INSERT INTO mcu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hên mɔ Sátàn bɔ̂ ŋgàŋ yoòr seèn lege kuú cu né kɔɔ́, sâ lò seèn tɔ̀b yùò ndé ŋgwéh wa? Bí ye: mè bɔ̀ càŋ tándulu lòù kwɔ́gɔ́ ŋgwéh, mgbè bɔɔ̀n mè terreb haá né kɔɔ́ sé wa? ");
INSERT INTO mcu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mɔ sé né gècên, ye mè tándulu kwɔgɔ né mé terreb Sátàn, sâ, dé bɔ̀ ŋuna biì nɔ, neì bɔ́ terreb haá yeé kɔɔ́, bɔ́ kwɔgɔ tándulu mé njéh wa? Bí kwá biì nɔɔ́ŋ, bɔ̀ ŋuna biì sie nde né bí nyeén kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","À den cuù ye bɔ́ a: «Mè bɔ̀ tándulu kwɔgɔ né mé terreb Càŋ Dueè. Sâ bí kɔ́ɔ ye: Mbàm Càŋ die waà baá ká yoòr biì kèn. ");
INSERT INTO mcu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Mɔ nùà terrèb déì mɔm né gwà seèn kɔɔ́, à né gi mé bɔ̀ njèh salê beè, ndɔ́g yíb bɔ̀ njèh seèn kèmà ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mɔ siíb déì wa cuù felè seèn, né bú mé terreb yɔgɔ́, bú sâ nde né bú bɔ̀ njèh taâb mé temé seèn né gi teèn doô ŋgaá weh, à geé sɔm bilí mé ŋgúlú seèn mene ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","À den cuù ye bɔ́ a: «Nuaá mé jomo mò sam, né nùà bùnò mò. Nuaá mé mè nùàr teèn bílí gàm ŋgwéh, né nùà ŋéllé-nùàr ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Sâ càŋ tándulu déì lé naâ yoòr nuaré déì dula yuo kelá, à nde ké ya dueè; à né bèh cèrrè te hobó ŋemâ fɔɔ́n gɔ. Mé njéh mene, à bèh cèrrè kwà ŋgwéh. Yeé baá ménâ, ye: kènê nyí nde cu nde aá ké lɔ, lè nuaá mé nyí lé yuoó naâ teèn doô. ");
INSERT INTO mcu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","À wa, sâ ké gwò bɔ́ fɔ gi aá, bɔ́ te nyegé gi aá bèh denè gwò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","À yeé ŋene aá ménâ, à nde yilá fɔɔ́n cu bɔ̀ càŋ déì téhbeh mé né bú jelá yɔgɔ́; bɔ́ bɔ́ waà, bɔ́ bilí yila nde lè nùà hèllè. Nùà doô die cu péb; beén seèn taré yɔgɔ́ keéh cu dé jomò.» ");
INSERT INTO mcu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeésò yeé nde aá mân tueé gií, ma déì deên yí lètenè bɔ̀ nùàr, lɔgɔ njií ké ter, ye bú a: «Lèì njuaà jɔgɔ̀ naâ wò kɔɔ́; mbán njuaà koó naâ wò kɔɔ́ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yeésò ye bú a: «Nùà njuaà né seér bɔ̀ɔ́ mé né ŋgòr Càŋ ŋgweé, mé né ŋgòr Càŋ jolo ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cu sâ, bɔ̀ nùàr kɔ lom né ké kwarè Yeésò bilí ndeê. À yeé ŋene aá ménâ, à duɔɔ́m baá-re tueê ndɔ, ye bɔ́ a: «Bɔ̀ cafanê bɔ̀ né lom bɔ̀ jélá-temé bɔ̀ dé gècên. Kɔ bɔ́ ŋene aá fém, te bɔ́ ŋene kɔ ye terreb Càŋ. Mè tueé bí, bɔ́ ŋéné ndé cú, faga le aá te fém mé Càŋ lɔ bɔɔ́ naâ yoòr Jonâs doô. ");
INSERT INTO mcu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gèh fém mé bɔ̀ Ninivè bɔ̀ lɔ naâ yoòr Jonâs ŋené sâ, bɔ̀ cafanê bɔ̀ nde cu né ménâ yoòr Huaán Nùàr ŋené ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bí kɔ́ɔ ye, loù ju tenâ, mgbè dé vêh mé lɔ deén naâ ké túno, nde né ter komo wuo, à sie bɔ̀ cafanê bɔ̀ nyeén. Lòù sam, à lɔ yuoó naâ tɔ́g ké kunduŋ, bèh mé tàbè bɔ̂ vulú né teèn kwaré, à ndeè bèh ŋgòr kɔ́gɔ̀n sònò Salomɔ̂ŋ ŋgweê. Sâ, nuaá mé né Salomɔ̂ŋ yɔgɔ́ keéh, né gi kwarè bɔ̀ cafanê bɔ̀ teèn. Mé njéh mene, bɔ́ né lòù saán seér. ");
INSERT INTO mcu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Loù téná-juù, bɔ̀ Ninivè bɔ̀ nde né ter kem wuo, bɔ́ sie bɔ̀ cafanê bɔ̀ nyeén. Lòù sam, bɔ̀ Ninivè bɔ̀ lé naâ dé bɔɔ̀n ŋgòr Jonâs ŋgweé, bɔ́ kweéh seér temé. Sâ nuaá mé né Jonâs yɔgɔ́ keéh, né gi kwarè bɔ̀ cafanê bɔ̀ teèn ndɔ. Mé njéh mene, bɔ́ temé kwéh sér ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Bɔ́ lâm mɔ̀gɔ̀ bèh, ye te bɔ́ leér kwaá lòù, wa te bɔ́ kibí kwaá ka sɔɔ̀ ndɔ. Bɔ́ lâm mɔgɔ seér né te bɔ́ tuú njií yí te súgo, te bɔ̀ nùàr yilà gwò, bɔ̀ ŋene njolo mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Njolo yeè né yoòr yeè faá lâm nɔ: mɔ njolo yeè né ŋené, gùm yeè dɔɔ́ŋ nde né bèsɔ́nè ŋagá den. Mɔ njolo yeè baá nyimé, gùm yeè dɔɔ́ŋ den nde né bèh cibì. ");
INSERT INTO mcu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sâ kè keè, wanɔɔ́ŋ ŋagâ mé né yoòr yeè doô nde né cibi die. ");
INSERT INTO mcu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mɔ yoòr yeè ŋagâ né teèn, bèh cibì déì teèn sam, sâ gùm yeè dɔɔ́ŋ né bèh ŋagâ, ŋagá nde né yoòr yeè faá lâm ba den né kɔɔ́ nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeésò yeé tueé gi aá mân, nùà Farisiên déì yilá njií bú ké lɔ seèn bèh yâb ndɔ. Wa ké gwò, bɔ́ yeé baá yáb yieé, ");
INSERT INTO mcu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","hiím seér nùà Farisiên dé hiîm. Lòù sam, Yeésò né yáb yieé, à be faá tabɔ́ né tueé nɔ, yàgà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Fehtoò beèh deên ndɔ, ye bú a: «Kè kú-re bí bɔ̀ Farisiên kán: bí bɔ̀ ŋgàb mé bɔ̀ sɔɔ̀ biì dɔɔ́ŋ yaga seér né kèb cieè, kèb lè tena le môn, te bí teèn kurú kwaá yíb mé jéré-temé. ");
INSERT INTO mcu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bɔ̀ kùlù bɔ̀ faá bí nɔ sam! Bí ye Càŋ nuaá mé bɔɔ́ naâ kèb cieè, à kèb lè kɔɔ́ bɔ́ ná ŋgwêh wa? ");
INSERT INTO mcu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mɔ bí ye te huɔm, bí nyàmè sér kèb lè biì. Njií mé né lè ŋgàb biì dɔɔ́ŋ, bí há bɔ̀ saám bɔ̀ teèn. Mɔ bí né ménâ bɔɔ́, sâ njèh dɔɔ́ŋ nde gi né beè biì ŋagásé. ");
INSERT INTO mcu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Bí bɔ̀ Farisiên, bí nde né gèr ŋené! Bí kɔ lom né Càŋ mbe haâ; mɔ njèh baá yulà, bí né gi bú cécéné haá nyegé: bɔ̀ sìbì mé bɔ̀ san mé bɔ̀ nyure hihiné. Bí haá gi né bú mbe ménâ dág. Njèh cén, bí bɔ̀ *sóú dé kokoô jòlò kɔ́ ŋgwéh; wanɔɔ́ŋ bí sé la né ju mé gècên mene tená kɔɔ́, bí sé la né Càŋ mé temé cén gwaán, te bí nde ye bú mbe haá. ");
INSERT INTO mcu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Bí bɔ̀ Farisiên, bí nde né gèr ŋené! Lè *gwà sóù, bí gwaán lom né bèh denè dé kokoô. Né mene ké tan mé ké mbartɔgɔ̂, bí ye kɔ bɔ̀ nùàr gìbì bíé bèlè bí lòù. ");
INSERT INTO mcu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bí nde né gèr ŋené! Bí den né faá sà nɔ; bɔ̀ nùàr né teèn mbaá gɔlé kelá, bɔ́ ŋéné kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nuaré déì deên yí lètenè bɔ̀ *njí-sóù ndɔ, ye bú a: «Nùà fèh-njèh, gèh dé mé wò né tueé hên, wò seb bilí né mé béh mene.» ");
INSERT INTO mcu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeésò ye bú a: «Mé bí mene, bí nde né gèr ŋené, bí bɔ̀ njí-sóù. Bí né seé tarê felè bɔ̀ nùàr mbiín kwaá, bí be teèn yí ŋgwéh. Né mene nyɔ̀gɔ̀ beè cén, bí teèn cór njí bèh te gam bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Bí ŋene nde né gèr fî! Dàm bɔ̀ *sòn-Càŋ bɔ̀ ŋgíb, bɔ̀ tele biì lɔ wula giì naâ kɔɔ́. Bí ké toò bɔɔ́ nde den né mé seé bɔ̀ tele biì, bí né sà bɔ̀ sòn-Càŋ bɔ̀ meé nyegé, ");
INSERT INTO mcu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","bí mé njéh feh keéh né ye, bí bɔ̀ tele biì né mé seé cên, wa bɔ́ lɔ dé bɔɔ̀n wulà naâ dé wulâ, bí me dé biì sà ma. ");
INSERT INTO mcu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Né dé cî mé Càŋ lɔ naá giì mé kɔ́gɔ̀n seèn tueé, ye nyí nde né bɔ̀ sòn-Càŋ bɔ̀ mé bɔ̀ mbɔ̀ŋ tebê ké yoòr bɔɔ̀n temá njií, bɔ́ nde né bɔ̀ déì bunó, bɔ́ wula bɔ̀ déì lòù. ");
INSERT INTO mcu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bɔ̀ sòn-Càŋ bɔ̀ mé bɔ́ lé naá giì wulá sâ wɔ́ŋ duɔɔ́m nê lòù, tɔ́g nde wa mé nàm hên dɔɔ́ŋ, húɔ́m bɔɔ̀n nde gi né bɔ̀ cafanê bɔ̀ bieé. ");
INSERT INTO mcu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Duɔɔ́m nde né mé húɔ́m Ábèl, nde wa mé húɔ́m Jakarî. Bɔ́ lɔ bú dé seèn wula lɔɔ̀ naâ lètenè caá gwà Càŋ, sâ mɔ̀ né yí toò, kɔ ká jomo mân. Mè né tueé ye bí a, húɔ́m bɔɔ̀n dɔɔ́ŋ nde gi né bɔ̀ cafanê bɔ̀ bieé. ");
INSERT INTO mcu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Bí bɔ̀ njí-sóù, bí nde né gèr ŋené! Lòù sam, huaán kî mé komo yeé gwà kɔ́gɔ̀n, bí lé naâ sɔm weh. Bí mé feh biì gwò yílá ŋgwéh; bɔ̀ɔ́ mé gwaán né yilâ, bí né bɔ́ toò yiín tená ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jomo sâ Yeésò yuo ndɔ. À yeé yuo aá, temé fulu ŋaâ bɔ̀ njí-sóù mé bɔ̀ Farisiên lè. Bɔ́ duɔɔ́m baá-re bú bɔ̀ njèh mé yúlá-temé mene bieé baâ, ");
INSERT INTO mcu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","te bɔ́ fɔɔ́n keéh bú sòn teèn, bɔ́ sie bú mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sâ cìlì nùàr mgbɔ́ŋ né cu sâ doó ŋab den. Yeésò yeé ŋene aá ménâ, à jɔ̀gɔ̀ tueé njií lɔgɔ̂ mé bɔ̀ mbɔ̀ŋ seèn, ye bɔ̀ a: «Bí bɔ̀ŋ feh biì mé kulu bɔ̀ *Farisiên; mè jue né leba bɔɔ̀n doô. Bɔ́ ŋgòr dɔɔ́ŋ tueé gi né mé sòn fèfà. ");
INSERT INTO mcu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mè tueé bí, bɔ̀ njèh lèrrèb dɔɔ́ŋ nde gi né cie ŋené yuo; bɔ̀ njèh dé nénâb ŋené yuo kela giì bèsɔ́nè ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Njií mé bí né bèh cibì tueé dɔɔ́ŋ nde né bèh ŋagâ ŋgulí den. Bí yila mene gwò, bí ferá mene hin, bí né ké mí namé den, mé njéh mene bɔ́ nde né ké felè gwà ŋaá, bɔ́ yie den teèn, bɔ̀ nùàr ŋgweé laré dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Dé biì, bí bɔ̀ mbeí mò, mè né bí tueé: bí té bɔ̀ wúlá-nùàr bɔ̀ vèh. Bɔ́ wula lom né léláŋ ŋgàŋ yoòr, sâ gi aá, bɔ́ mé terreb déì toò sam cuú. ");
INSERT INTO mcu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mè tueé bí, nuaá mé bí nde né veéh né sér Càŋ. À dé seèn né mé terreb nùàr wulâ, à si njií tuar te we tarê. Mè tueé bí: bí vèh sér bú. ");
INSERT INTO mcu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Hên faá tásuagár doô, mɔ bɔ́ domó laáb mene bɔ́ tîn, bɔ́ go sɔm kɔ́bɔ̀ fà, nde né nùàr yulá wa? Mé njéh mene, Càŋ njolo mé cén déì lètenè bɔɔ̀n cì bèh, ");
INSERT INTO mcu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","sé tagá bí wa? Mè tueé bí, né mene bɔ̀ yúlí feèh biì dɔɔ́ŋ né gi njolò seèn. Bí té mbaá vèh kú; kela né bí te mbeî yuií mé dàm bɔ̀ tásuagár hèllè.» ");
INSERT INTO mcu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mè tueé bí, nuaá mé né mè cie toò bɔ̀ nùàr gwaán njií dɔɔ́ŋ, loù sâ *Huaán Nùàr nde né bú toò bɔ̀ cìlì Càŋ gwaán weh ndɔ, ye né nùàr nyî. ");
INSERT INTO mcu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nuaá mé né mè toò bɔ̀ nùàr ŋgɔɔ́n dɔɔ́ŋ, mè nde né bú toò bɔ̀ cìlì Càŋ ménâ ŋgɔɔ́n ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Nuaá mé né Huaán Nùàr jueé, bɔ́ nde né veên seèn doó kulú njií. Nuaá mé dé seèn jue seér né Cúcuí Ŋagâ, bɔ́ veên seèn lè kúlú sɔ̀m ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Bí kɔ́ɔ ye: bɔ̀ nùàr nde né bí sie, bɔ́ jɔgɔ njií bí ké *gwà sóù bèh juù, bɔ́ nde né bí ké toò bɔ̀ kokoô bɔ̀ dé lɔɔ̂ ménâ mgbɔmé njií ndɔ. Loù sâ njií mé bí nde né sònò tueé, bí té nyàmè. ");
INSERT INTO mcu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Loù sâ Cúcuí Ŋagâ bí ŋgòr sònò tueé kwaá nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nuaré déì lé naâ yí lètenè bɔ̀ nùàr teèn, ye Yeésò a: «Nùà fèh-njèh, tele beèh lé naâ béh ŋgúlú kuú kwaá lɔɔ́. Júé bei mò a, gè há mè dé mò ma.» ");
INSERT INTO mcu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeésò ye bú a: «Nùàr mò, kei mé yií keéh né mè teèn kɔɔ́ wa? Mè ndeè naâ bèh ju biì tenâ, mé ŋgúlú biì geê wa?» ");
INSERT INTO mcu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jomo sâ à ye bɔ̀ nùàr a: «Bí bɔ̀ŋ feh biì mé temé te ŋgúlú jɔgɔ kwaâ. Nùàr a, kwà gí méné njèh dɔɔ́ŋ, ndɔ́g, à yɔ̀ŋ teèn kwà kéh ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","À si baá-re bɔ́ kàn déì ndɔ, ye bɔ́ a: «Nùà lieê déì lé naâ mé ŋueèh teèn, yab lé naâ teèn yuo dé gècên. ");
INSERT INTO mcu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","À duɔɔ́m baá-re mé huún seèn munô ye: Hên bèh teèn sam; nyí yab hên dɔɔ́ŋ kwaá gi nde né he wa? ");
INSERT INTO mcu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","À den cu kaà mé be seèn ye: Nyí kɔ baá kèn: nyí nde né bɔ̀ mbáŋ nyî dɔɔ́ŋ ŋerré sɔm gií, nyí sie hamé seér bɔ́ lòù, te nyí bilí kwaá gi bɔ̀ yab mé bɔ̀ njèh nyî dɔɔ́ŋ teèn. ");
INSERT INTO mcu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jomo sâ nyí tueé nde aá ye yo nyî a: wò yab ŋgún bilí kwa baá kèn, baá dé nyèmà ŋgûn ndɔ; dù bá duù, yíé bá dé yieê, wò ŋueé lom dé ŋueê; dòbò njí bá tàbè mbaá. ");
INSERT INTO mcu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","À yeé tueé gi aá mé huún seèn mân, Càŋ ye bú a: Nùà kùlù faá wò nɔ! Wò kɔ́ ŋgwéh ye lan cíbítenè wò nde né kuú wa? Sâ, neì bɔ̀ njèh yeè hèllè yieé nde né kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeésò den cuù ye bɔ́ a: «Mè tueé bí, sâ nuaá mé ŋgùlù bilí kwaá lom né dé seèn, à dé Càŋ bílí ŋgwéh dɔɔ́ŋ, nde né bú faá nùà kùlù hèllè nɔ bɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","À den cuù ye bɔ̀ mbɔ̀ŋ seèn a: «Mè tueé bí, mɔ né mân, bí té mé yáb nyàmè lè, ye te bí koó feh biì. Bí té mé cɔ̀gɔ̀ nyàmè lè, ye te bí su kwaá yoòr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kela né yɔ̀ŋ nùàr mé yáb; gùm nùàr huɔm kela né kɔɔ́ mé cɔ̀gɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bí jɔ̀gɔ̀ kè njí ke bɔ̀ non ye; bɔ́ yab dòbò bèh, bɔ́ kwá bèh, bɔ́ mé be yolò sam, bɔ́ mé mbáŋ sam ndɔ. Mé njéh mene, Càŋ né gi bɔ́ koó laré; sé tagá bí wa? Ŋgweéh kela né bí mé non mà.» ");
INSERT INTO mcu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","À den cuù ye bɔ́ a: «Bí né mene nyamé, lètenè biì dɔɔ́ŋ, neì cieé déì felè bɔ̀ cieé seèn sagá komo nde né kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mɔ njèh dé maàn hên né bí yɔgɔ́, sâ bí dé jomò mbaá nyamé den né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Bí kè wèh yoòr bɔ̀ mvue nyurè mé né ké ŋueh baá: bɔ́ seé témá bèh, bɔ́ cɔ̀gɔ̀ cóló kɔ́ bèh ndɔ. Mé njéh mene, mè tueé bí, mgbè Salomɔ̂ŋ mé be ŋgùlù seèn mene dɔɔ́ŋ lé gèh nòmò cɔ̀gɔ̀ faá bɔ̀ mvue nɔ sù kwà ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mɔ Càŋ né nyure mbaá yàgà ménâ nyegé huɔɔ́m, à cɔ̀gɔ̀ mé bí há kélá ndé ŋgwéh wa? Ŋgweéh bɔ̀ nyure ké ya den weh né dé laàn, kwéh bɔ́ nde né saá sɔm wa? Temé kuú né bí lòù, mè tueé bí. ");
INSERT INTO mcu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Sâ bí té mé yáb bɔ̂ mbè mbaá nyàmè fɔ́n lè, bí té seé cer. ");
INSERT INTO mcu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dé sâ né seé bɔ̀ wɔ̂ŋ bɔ̀; bɔ́ né gi ménâ nyamé fɔɔ́n. Bí né dé biì mé Tele teèn; bɔ̀ njií mé saám né bí dɔɔ́ŋ, à né gi kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bí yúé fɔ́n sér *Lò Càŋ, Càŋ nde né bí bɔ̀ njèh dé jomò teèn haá keéh.» ");
INSERT INTO mcu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeésò den cuù, ye bɔ́ a: «Bí té vèh, bí mene màgà ŋgwéh, bí né bɔ̀ mbieè mò. Lò Càŋ né dé biì; Tele biì Càŋ haá né bí kɔɔ́, ye nyí gwaán né ménâ. ");
INSERT INTO mcu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sâ bí gò sɔ̀m bɔ̀ njèh biì, bí geé haá njií bɔ̀ saâm bɔ̀ kàgàlɔ̀ŋ sâ. Bí fɔ́n sér ŋgúlú mé nde né ter le, bí né ké te vulúu bilí njií. Dé sâ gí ndé cú, yíb ŋúɔ́b ndé cú, sueé yíé ndé cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bí kɔ́ɔ ye, temé nùàr né gi bèh mé ŋgùlù seèn né teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Bí dèn dene bɔ̀ siîb; bí góló nyégé cɔ̀gɔ̀ bagasé, bí mɔ̀gɔ̀ sìè lâm beè. ");
INSERT INTO mcu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bí dèn làŋ faá bɔ̀ seê bɔ̀ mé né tele seê bɔɔ̀n kela den nɔ. Te tele seê bɔɔ̀n cuù bèh kùrmò fù, à gɔ hin, bɔ́ gulu keéh bú wúwágá. ");
INSERT INTO mcu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bɔ̀ seê bɔ̀ mé tele bɔɔ̀n nde né bɔ́ ménâ kwa dɔɔ́ŋ, nde gi né samé. Mè né tueé ye bí a, mɔ à cu cuù baá, à nde né cɔ̀gɔ̀ goló nyegé, à feh bɔ́ bèh denè kwarè yâb, à bɔ́ yáb jɔgɔ haá seér kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","À cu cuù mene lɔgɔ̀tenè, né mene toò cieê, bɔ̀ɔ́ mé né lɔ́m goó dɔɔ́ŋ nde gi né njua beè seèn kwa. ");
INSERT INTO mcu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bí kɔ́ɔ ye, mɔ nùà gwà sé né kɔɔ́ ye loù sâ yíb nde né nyí yilá, à sé naâ làŋ den, à mɔm ŋaga gwà seèn, te yíb gwò yílá cú. ");
INSERT INTO mcu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sâ bí dèn dèn làŋ ménâ, wanɔɔ́ŋ Huaán Nùàr kar waà nde né loù mé bí cí mùnò ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piêr ye bú a: «Fehtoò beèh, wò kàn hên si njií lom né mé béh wa, né mé bɔ̀ nùàr dɔɔ́ŋ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Fehtoò beèh ye bú a: «Kwá mè tueé bí felè nùà kɔ́gɔ̀n mé né seé tele seê seèn mé temé cén bɔɔ́. Né nuaá mé tele nde né bɔ̀ seé bɔ̀ dɔɔ́ŋ haá kwaá beè seèn, te à geé haá bɔ́ yáb, à geé faá né tueé nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mɔ tele seê seèn waà, à né seé seèn te ceér-e ménâ bɔɔ́, à nde né beè teleè samé. ");
INSERT INTO mcu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mè né tueé ye bí a, tele beè seèn haá lɔ bilí nde né mé bɔ̀ njèh seèn mene dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","«Á, mɔ nùà seê cén sâ den seér cuù né mé feh seèn, ye: Tele seê nyî wágá cú ndé ŋgwêh, à né seér bɔ̀ seê bɔ̀ lobo, né mene bɔ̀ dé sisiîb, né mene bɔ̀ dé vévêh, à né bɔ́ lobo, à né yáb yieé ndabé, à né ŋueé sela; ");
INSERT INTO mcu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mɔ à né méménâ bɔɔ́, ŋgweéh sâ tele seê seèn nde né lòù kaár waâ, à weh bú seé wa? À nde né bú kwɔgɔ́ sɔm, te bɔ́ bɔ̀ dúágá-tie bɔ̀ den mé gèh nûr cên. ");
INSERT INTO mcu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Nùà seê mé né gi njií mé tele gwaán nê kɔɔ́, à ménâ bɔ́ ŋgwéh, à bú bɔ̀ njèh seèn nyégé ŋgwéh dɔɔ́ŋ, nùà sâ nde né mé núr beè teleè ŋené kuú. ");
INSERT INTO mcu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Njií mé tele seê gwaán nê, mɔ nùàr kɔ́ ŋgwéh lòù, à né mene veên bɔɔ́, sâ dé seèn bɔ́ bú kókoó lòbò ndé ŋgwéh. Bí kɔ́ɔ ye, nuaá mé bɔ́ lé naâ bú njèh ŋgún haá, bɔ́ beè seèn bie weh cu nde né ŋgún ménâ ndɔ; bɔ́ ŋgún bie weh kela nde né beè nuaá mé bɔ́ lé naâ ŋgún haá.» ");
INSERT INTO mcu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeésò ye bɔ́ a: «Mè ká doó beè waà né mé we. Mè né gwaán ye sé la baá ŋgie. ");
INSERT INTO mcu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mè nde né nòmò Càŋ weh ndɔ. Baá lom mè dé yieê yieé. ");
INSERT INTO mcu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bí té mùnò ye mè ká te wɔ́ŋe ndeè né bɔ̀ nùàr dɔlê haá. Mè tueé bí, mè ká lètenè biì nde seêr né bèh kèrrè siì. ");
INSERT INTO mcu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mɔ bɔ̀ nùàr né gwò tîn, kènê bɔ̀ tagár bɔ̀ déì nde né bɔ̀ fà bɔ̀ bunó; bɔ̀ fà bɔ̀ nde né bɔ̀ tagár bɔ̀ bunó ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tele nde né huaán bunó; huaán bunó cu tele ndɔ. Meí nde né huaán dé vêh bunó, huaán bunó cu meí ménâ ndɔ. Bɔ̀ makoò bɔ́ bɔ̀ veèh ŋuna bɔɔ̀n nde né méménâ lètenè bɔɔ̀n bunó kuú.» ");
INSERT INTO mcu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeésò tueé njií mé cìlì nùàr ndɔ, ye bɔ́ a: «Mɔ bí ŋene nu baá ter kèb nyiìb yilí komo ŋaá, bí ye: nu nde né neé. Ne ka ménâ. ");
INSERT INTO mcu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mɔ bí ŋene fu né lòù kobó ŋaá, bí ye: lan nde né salé; salé ka ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jue ka bí bɔ̀ leba bɔ̀! Bí né gi bɔ̀ njií sâ dɔɔ́ŋ ŋené kɔɔ́; né mene ká doó, né mene ké ter, né gi njolò biì ŋagásé. Seèn bɔɔ́ né naàn mé bɔ̀ njèh dé nàm biì hên, bí ŋéné kɔ́ ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Bɔɔ́ né naàn mé bí ceér gècên mé be biì ŋéné kɔ́ ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mɔ bî nuaré déì baá mé ju, à né wò sií, à ju sâ njií né ké toò nùà dueè; mɔ bí bú gɔ bilí né kɔɔ́, lègè lòm ceér dueè tég, te bí bú jɔ̀gɔ̀ den giì mé sòn cên ye; wanɔɔ́ŋ wò nde né ju beè seèn toò bɔ̀ kokoô bɔ̀ die, bɔ́ sie haá njií wò mé sɔ́jì; te sɔ́jì nde wò ké gwà cibì yií njií. ");
INSERT INTO mcu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mè tueé wò, bɔ́ sie kwaá nde né wò beè méménâ, tɔ́g kɔ bɔ̀ tomo njèh nùà hèllè yuo kela giì baá kèn, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Cu sâ bɔ̀ nuaré déì waà ndɔ, bɔ́ ndeè Yeésò njeré déì felè bɔ̀ Galilê bɔ̀ bieé. Bɔ́ ye bú a: «Cu mé bɔ̀ Galilê bɔ̀ lé naâ *sèmè ké toò Càŋ ŋɔɔ́b, *Pilátò lé ye ŋɔ́b bílí mé bɔ́ mene. Bɔ́ lé naâ mé bɔ́ mene ŋɔɔ́b bilí ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeésò ye bɔ́ a: «Beè biì, bí munó né ye gèh gèr mé bɔ̀ Galilê bɔ̀ hèllè lé naâ ŋené sâ, bɔ́ lé veên bɔɔ́ kelà naâ kɔɔ́ mé bɔ̀ mbeí wa? ");
INSERT INTO mcu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cí sam; mè tueé bí, mɔ bí temé biì kwéh sér ŋgwéh, bí kuú gi nde né ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ŋgweéh gwà tèb Siloê lé naâ ŋem, lobo wula lɔ bɔ̀ nùàr gwò yulà cùɔ̀b téndelé wa? Bí munó né ye lètenè bɔ̀ Jerusalem bɔ̀ dɔɔ́ŋ, bɔ̀ sâ bɔ̀ hèllè lé bɔɔ́ sabé kelà naâ kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Môn sam; mè tueé bí, mɔ bí temé biì kwéh sér ŋgwéh, bí nde né ménâ dɔɔ́ŋ kuú gií ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jomo sâ Yeésò si cu kàn déì, ye bɔ́ a: «Nuaré déì lé naâ toú déì ké ŋueh dobo kwaá. À né ké teèn ndeé, ye te nyí kwa tàb teèn, à njeré déì teèn kwà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Loù sâ, ye nùà seê seèn a: Baá nyèmà tagár, nyí né felè toú hên mbaá yagá kuú, tàb teèn sam. Kòmò sì njí bú doó, à né bèh dé lòù yiín kwaá den. ");
INSERT INTO mcu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nùà seê doô ye bú a: Tele mò, kwá lɔ́ cú yeè bú nyèmà hên ménâ; mè nde né ké kaà kweé yɔŋ, mè su yelle teèn. ");
INSERT INTO mcu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Merré déì nyèmà kwêh à nde né tàb waá. Mɔ sam, te béh komo sɔm ye bú.» ");
INSERT INTO mcu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Loù sóù déì sâ Yeésò né bɔ̀ nùàr njèh ké *gwà sóù feh den. ");
INSERT INTO mcu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma déì lé naâ gwò sâ teèn, à né mé tándulu yoòr; baá nyèmà yulà cùɔ̀b téndelé, càŋ doô né bú ŋgɔ̀gɔ̀ beè sie guú kwaá den. À bɔɔ́ mene naàn, à ter njébá dìlì kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeésò yeé ŋene aá bú, à yilá njiî bú, ye bú a: «Dé vêh, lan wò yili yuo aá lè beên yeè hên kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","À ba njií bú be felè; kwar cén ma doô njebá dilí yuo ndɔ, à yila keéh Càŋ seên. ");
INSERT INTO mcu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nùà koô gwà sóù yeé ŋene Yeésò taré sɔm aá nùà beên loù sóù, temé yulá bú lè, à tueé njií seér, ye bɔ̀ nùàr a: «Bɔ̀ cieé seê bɔɔ̂ né ténjén. Bí ndê bèh teèn, te bí taré yuo; dèn ŋgwéh loù sóù.» ");
INSERT INTO mcu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Fehtoò beèh deên ndɔ, ye bú a: «Jue ka bí bɔ̀ leba bɔ̀! Loù sóù cén sâ nùà kàn né yeé ndeé, à né nàgà seèn se weh, wa né vuɔmndeè wa, à derré njií bú bèh nòmò ŋueê. ");
INSERT INTO mcu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sâ, ma mé né ndùté ndùtù Abrahâm hên né gèr beè *Sátàn ŋené, Sátàn né bú mé yuií lané den, lan baá nyèmà yulà cùɔ̀b téndelé. Mè yeé yili sɔm aá bú, bí ye, wa loù sóù húɔ́m ŋgwéh mé mè se sɔm bú lè yuiî sé wa?» ");
INSERT INTO mcu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","À yeé tueé gi aá ménâ, fegùlì kibí kela mé bɔ̀ bùnò bɔ̀ seèn doó. Bɔ̀ nùàr dé bɔɔ̀n samé seér dé samê. Lòù sam, à lètenè bɔɔ̀n bɔɔ́ lom né bɔ̀ seé dé dudueèr. ");
INSERT INTO mcu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jomo sâ Yeésò ye bɔ́ a: «*Lò Càŋ fela né kei wee? Mè bú me njií nde né mé kei wa?» ");
INSERT INTO mcu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ye bɔ́ a: «Lò Càŋ den né faá mvum tàb làm mé nuaré déì lé naâ ké mbar seèn dobo kwaá nɔ. Yeé baá ter baá yuo, ŋa toú, bɔ̀ non tieé fulu teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeésò den cuù, ye bɔ́ a: «Mè Lò Càŋ me njií nde né mé kei wee?» ");
INSERT INTO mcu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ye bɔ́ a: «Lò Càŋ den né faá kulu nɔ. Ma déì lé naâ dɔɔ́m weh, à si ŋgàb tàgà ndètoón cùɔ̀b tîn mé njéh. Yeé baá jelá, fulu komo njií gùm tàgà dɔɔ́ŋ ter.» ");
INSERT INTO mcu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeésò né te lɔɔ́ kokoô mé lɔɔ́ tetɔɔ̂r ndeé, à né njèh teèn feh bele, ye te nyí yuo kela ké Jerusalem ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nuaré déì waà, ye bú a: «Dé koô, á hên bɔ̀ nùàr nde né kókoó yili yuo wa?» Yeésò tueé njií mé bɔ̀ nùàr ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Hin né baré, bí lègè lòù te bí yila kela ye. Mè tueé bí, bɔ̀ nùàr kókoó nde né lege ke; mé njéh mene bɔ́ yílá kwà ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nùà gwà nde né ter wuo, à colo hin seèn, à ferá tena lɔ bí cie. Bí nde né hin gɔré, bí né bú teèn yilá yií, ye: Fehtoò beèh gùlù kéh béh teèn. À nde né bí tueé ye bí a: Bí yuo naá-re he wa? Nyí bí kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Cu sâ bí nde né tueé ye bú a: Ŋgweéh béh bí lé yieé beéh kɔɔ́, béh ŋueé kɔɔ́ wa? Ŋgweéh wò lé naâ njèh ké lɔ beèh feh ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","À tueé lom nde né dé seèn ye bí a: Bí bɔ̀ vevenê bɔ̀ dɔɔ́ŋ, bí yùò doó sâ nɔɔ́ŋ, nyí bí kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","Yeésò den cu ye bɔ́ a: «Ké sâ kéŋ nde né silí, nyie nde né yieé. Bí nde né Abrahâm mé Isâk bɔ̂ Jakɔ̂b mé bɔ̀ *sòn-Càŋ bɔ̀ dɔɔ́ŋ ké te Lò Càŋe ŋené njií. Nùàr hihiné nde né ké teèn yilá laré; bɔ̀ɔ́ mé naâ kèb bà, kèb nyiìb, kèb fenê mé kèb túnò mene dɔɔ́ŋ, nde gi né teèn yilá, bɔ́ né kùrmò yieé. Sâ bí né dé biì kèb cieè. ");
INSERT INTO mcu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mè tueé bí, bɔ̀ déì lètenè bɔ̀ ké jomo bɔ̀ nde né ké toò kelá seér; bɔ̀ déì lètenè bɔ̀ ké toò bɔ̀ kela seér cu ké jomo.» ");
INSERT INTO mcu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cu sâ bɔ̀ *Farisiên déì bilí waà ndɔ, bɔ́ ye Yeésò a: «Yùò hên yuoò, ndé sèr toò; *Herôde gwaán né wò wulâ.» ");
INSERT INTO mcu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","À ye bɔ́ a: «Né sése! Bí ndé júée bú a: Mè né bɔ̀ nùàr tándulu yoòr kwɔgɔ́, mè taré sɔm bɔ̀ beên bɔ̀, wa mè nde né méménâ lan mé kwéh bɔɔ́; kulà mè bɔɔ́ sɔm ma. ");
INSERT INTO mcu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sâ mè nde né mé seé mò toò bɔɔ́ ndeé ser lan mé kwéh bɔ̂ kulà. Lòù sam, ye sòn-Càŋ déì a: té ké cie kú lè, wa bɔ́ ndé kú gí ké Jerusalem ma. ");
INSERT INTO mcu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Óè Jerusalem! Óè Jerusalem! Dàm bɔ̀ sòn-Càŋ bɔ̀ wula gi né wò. Bɔ̀ɔ́ mé Càŋ lé naâ yoòr yeè temá njií dɔɔ́ŋ, wò bɔ́ mé taá tɔbé wula gi né kɔɔ́. Mè né mene gwaán, ye mè nde né bɔ̀ nùàr yeè ká ka mò koró bilí, faá cuar kurú kwaá yeé bɔ̀ huaán ka bà nɔ, wò gwàn bèh. Baá mbei meèn wa, Jerusalem? ");
INSERT INTO mcu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mè tueé bí, gwà biì nde né ter le, bí mè ŋéné ŋgwé ndé cú; kɔ cu mé bí ndeè baá mé sòn biì tueé ye: Càŋ Dueè a, kúlú nyégé nuaá mé ndeè né mé yilí seèn kulù, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Loù sóù déì Yeésò nde ké gwò nùà koô bɔ̀ *Farisiên cén déì bèh yáb yieê. Bɔ̀ɔ́ mé lé naâ doó sâ dɔɔ́ŋ né Yeésò ke den. ");
INSERT INTO mcu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nuaré déì lé naâ doó sâ teèn ndɔ, à né mé beén fufulû mân yoòr; à né toò Yeésò njebá den. ");
INSERT INTO mcu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeésò yeé ŋene aá ménâ, à bie njií mé bɔ̀ *njí-sóù mé bɔ̀ Farisiên, ye bɔ́ a: «Mɔ bɔ́ taré sɔm nùàr loù sóù, né jolo wa, jòlò ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bɔ́ sòn kòmò ŋgwéh. Yeé baá môn, Yeésò taré sɔm nùàr beên hèllè ndɔ, yi njií bú. À tueé njií mé bɔ̀ nùàr ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","«Hên, mɔ lètenè biì ŋunà nuaré déì, wa nàgà seèn wa, die yila ké dòù loù sóù, à bú beè nomo lègè sɔ̀m ndé ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dé sâ gela yɔgɔ́ cu bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bɔ̀ɔ́ mé bɔ́ yilá njií naâ bèh yâb hèllè né bèh denè lòù balé fɔɔ́n. Yeésò yeé ŋene aá ménâ, à ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Mɔ nuaré déì sua véh, à yilá njií wò ké gwò seèn bèh kùrmò yieê, té bèh denè dé koô kè wèh; kɔ ŋgweéh à naâ nùà dueè mé né wò yɔgɔ́ teèn yilá keéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mɔ nùà koô doô waà, nùà gwà mé naâ bí fà dɔɔ́ŋ yilá doô nde né wò ter komo sɔm, nùà koô hèllè den keéh, wò nde seér ké jomo bɔ̀ nùàr mé fegùlì mene den ndeé. ");
INSERT INTO mcu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mɔ bɔ́ né wò yilá, ndé dèn sér ké jomo bɔ̀ nùàr, te nùà gwà ŋene ménâ, à yilá kwaá njií seér wò te bèh denè dé koô, te wò lie ye njolò bɔ̀ nùàr doó sâ dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","À den cuù ye bɔ́ a: «Bí kɔ́ɔ ye, nuaá mé né ter ŋgumó ŋaá dɔɔ́ŋ, bɔ́ nde né bú doó baá njií, te bɔ́ ter komo njií seér nùà dɔlê.» ");
INSERT INTO mcu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yeésò tueé njií mé nùà gwà ndɔ, ye bú a: «Mɔ wò né bɔ̀ nùàr bèh kùrmò yilá njiî, té bɔ̀ mbeí yeè mé bɔ̀ nùàr yeè bɔ́ bɔ̀ lilieê bɔ̀ teèn yílá kéh; mɔ sam, bɔ́ nde cu né wò sòn sâ yilá haá sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mɔ wò gwaán né bɔ̀ nùàr bèh kùrmò yílá njiî, yílá sér bɔ̀ saâm bɔ̀ mé bɔ̀ tácɔgɔ́, bɔ̀ɔ́ mé be sam gule sam, mé bɔ̀ cùgò njolo bɔ̀ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bɔ̀ sâ bɔ̀ mé terreb sam, bɔ́ wò sòn sâ yílá há sɔ̀m ndé cú; te Càŋ kulu seér wò kɔɔ́, à ndeè gwɔm wò loù mé bɔ̀ didilî bɔ̀ nde né te cio komo yuo gií.» ");
INSERT INTO mcu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bɔ̀ɔ́ mé né te yâb sâ yeé ŋgweé gi aá ménâ, cén déì lètenè bɔɔ̀n ye Yeésò a: «Njua né felè nuaá mé nde né yáb ké te *Lò Càŋe yieé teèn!» ");
INSERT INTO mcu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeésò deên ndɔ, ye bú a: «Nuaré déì lé naâ kùrmò neé, à yilá njií bɔ̀ nùàr kókoó teèn. ");
INSERT INTO mcu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cu yeé wulu baá, ye nùà seê seèn a: Ndé júée bɔ̀ nùàr a: yáb baá gi doó, bɔ́ ndê yíé bá yieè ma. ");
INSERT INTO mcu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bɔ́ dɔɔ́ŋ, nùà kàn ye bú a: Nyí kuún aá kèn. Nùà toò jɔ̀gɔ̀ ye nùà seê a: Nyí lé naâ ŋueèh ŋge, nyí jɔ̀gɔ̀ nde née yɔŋ ke ye; kúkùr yeè, té ndè. ");
INSERT INTO mcu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dé jomò ye bú a: Nyí lé naâ nàgà yulà ŋge, nyí nde née bɔ́ fèfà fèfà laáb, te bɔ́ kie ke boór ye; kúkùr yeè, té ndè. ");
INSERT INTO mcu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dé tagâr ye bú a: Nyí jɔgɔ baá véh, nyí teèn wá ndé cú. ");
INSERT INTO mcu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Nùà seê doô cu cuù, à tueé mé tele seê seèn ménâ ndɔ. Temé ŋaâ tele lè, à ye nùà seê seèn a: Gɔ̀ gɔɔ̀, ndé yílá wèh bèlè bɔ̀ nùàr ceceér, mé ké mbartɔgɔ̂ mene; yílá ndê bèlè mé bɔ̀ saâm bɔ̀, mé bɔ̀ tácɔgɔ́ bɔ́ bɔ̀ cùgò njolo bɔ̀ mé bɔ̀ɔ́ mé be sam gule sam dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Jomo sâ, nùà seê doô cu cuù ndɔ, ye bú a: Tele mò, mè yilá wa giì aá mé bɔ́ kèn; bèh née cu le ye. ");
INSERT INTO mcu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tele ye bú a: Ndé bèlè bá kènê ké jomo lɔɔ̂ mé yí fei ceceér, sìè ndê bèlè mé bɔ̀ nùàr lòù, te gwà mò yuú mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mè tueé bí: mè la naâ bɔ̀ toò jɔ̀gɔ̀ bɔ̀ mbaá yilá kuú, bɔ́ yáb mò sònò nágá kéh ndé cú.» ");
INSERT INTO mcu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cìlì nùàr ŋgún né Yeésò jomo kem bele. À bele seér ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nuaá mé gwaán né jomo mò beleè dɔɔ́ŋ, bú a: gwàn kélá mè mé bɔ̀ nùàr seèn, né mene tele bɔ̂ meí seèn; né mene veèh seèn mé bɔ̀ ŋuna seèn; né mene bei, né mene dìm, né mene tie seèn; dɔɔ́ŋ, bú a: gwàn kélá mè mé bɔ́. À gwaán kela cu mè mé yɔ̀ŋ seèn nùà njèh ndɔ. Mɔ sam, à mbɔ̀ŋ mò dèn kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nuaá mé toú gèr mé be seèn jɔ́gɔ́ ŋgwéh, à mè bèlè ŋgwéh dɔɔ́ŋ, mbɔ̀ŋ mò dèn kòmò ndé ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Sâ mɔ lètenè biì nuaré déì nde aá gwà sieé, bú a, dèn ndé doó, à taáŋ nyegé gi. Mɔ kàgàlɔ̀ŋ nde né wulú, à duɔɔ́m ye seé gwà hèllè. ");
INSERT INTO mcu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mɔ sam, à nde né léláŋ maàŋ gwà si cegé, kàgàlɔ̀ŋ gi yuo, gwà le toò. Sâ bɔ̀ nùàr nde né mé ja kuú den, ");
INSERT INTO mcu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ye: kè nùàr hèllè kán, à duɔɔ́m giì dág; ké jomo beè mvúâr. ");
INSERT INTO mcu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Déì né cu mân: Mɔ mgbè déì gwaán né taáb mé mbeí lieê, bú a, dèn cèrè doó, à taáŋ nyegé gi bɔ̀ nùàr seèn, ye bɔ̀ nùàr nyî né cegé kám yulà. Mɔ mbeí kem waà mé bɔ̀ nùàr kam ndètoón, nyí nde né mé bɔ́ lieé komo wa? ");
INSERT INTO mcu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mɔ sam, bú a, témá kóbó njí lòm mbeí be jɔ̀gɔ̀, te pɔ́ŋ die. ");
INSERT INTO mcu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","«Sâ, kɔ bí taáŋ nyegé ménâ ndɔ, wanɔɔ́ŋ nuaré déì seèn mbɔ̀ŋ mò mbaá ŋá kòmò ndé ŋgwéh, mɔ à bɔ̀ njèh seèn dɔɔ́ŋ ŋgɔ́n ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Túɔ́m né njèh bagaà. Á mɔ túɔ́m cuaré baá, bɔ́ bɔɔ́ ŋgulí cu nde né bú naàn wa? ");
INSERT INTO mcu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sâ gi aá kèn; à yelle sam, à tàbè gàm ndé cú ndɔ. Bɔ́ bú su njií nde aá cie mbaá. Nuaá né mé tie dé ŋgweê, bú a, ŋgwé nyégé bagasé.» ");
INSERT INTO mcu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bɔ̀ɔ́ mé weh yeé kàgàlɔ̀ŋ làmpɔ̂ŋ mé bɔ̀ vevenê bɔ̀ dɔɔ́ŋ bilí nde gi kwarè Yeésò bèh ŋgòr seèn ŋgweê. ");
INSERT INTO mcu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bɔ̀ *Farisiên mé bɔ̀ *njí-sóù yeé ŋene aá ménâ, bɔ́ duɔɔ́m lètenè bɔɔ̀n ndugô, ye: «Nùà hên bɔ̀ vevenê bɔ̀ kwarè seèn weh kwaá né dé keì? Bɔ́ bɔ́ mé ŋgàb cên yieé bilí né dé keì ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yeésò yeé ŋene aá ménâ, à si bɔ́ kàn, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Hên mɔ lètenè biì nuaré déì né mé mbieè yuií, cén déì nde leér le, à bɔɔ́ nde né naàn? À bɔ̀ dé yulà tárènèà cùɔ̀b tárènèà doô yí fei kwá lɔ́ ndé ŋgwéh, à nde dé cên doô fɔɔ́n wellê wa? ");
INSERT INTO mcu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mɔ à fɔɔ́n kwa baá bú, à ndeè né bú tuagaà mé vɔ́gɔ́-temé mene jɔgɔ́ sie, ");
INSERT INTO mcu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","à cu cuù mé njéh, à yilá bilí bɔ̀ mbeí seèn mé bɔ̀ nùàr kwarè seèn, ye bɔ́ a: Bí ndê vrà gàm mè teèn; sòrŋgaŋ mò lé naâ leér, mè bú fɔɔ́n kwa cu aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yeésò den cuù ye bɔ́ a: «Mè tueé bí, mɔ nùà veên cén kweéh seér temé lètenè bɔ̀ mbeî, vràb nde né ké te vulúu felè seèn ménâ ndɔ. Bɔ́ vra kela nde né bú mé bɔ̀ didilî bɔ̀ yulà tárènèà cùɔ̀b tárènèà mé mùnò ŋgwéh temé kweéh seêr doô.» ");
INSERT INTO mcu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yeésò den cuù ye bɔ́ a: «Mɔ ma déì né mé kàgàlɔ̀ŋ beè kám cén, yuií cén nde die leér teèn, à we mɔ̀gɔ̀ ndé ŋgwéh, à fɔ bilí gwà, à ŋalé fɔɔ́n teèn wa? ");
INSERT INTO mcu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mɔ à fɔɔ́n kwa cu aá, à nde né bɔ̀ mbeí seèn mé bɔ̀ nùàr kwarè seèn yilá bilí, ye bɔ́ a: Bí ndê vrà gàm mè teèn; kàgàlɔ̀ŋ mò lé naâ leér, mè kwa cu aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yeésò den cuù ye bɔ́ a: «Mè tueé bí, mɔ nùà veên cén kweéh seér temé seèn, vràb nde né lètenè bɔ̀ cìlì Càŋ felè seèn ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeésò den cuù ye bɔ́ a: «Nuaré déì lé naâ mé huaán fà. ");
INSERT INTO mcu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cieé déì dìm ndeè ye tele a: Gè bɔ̀ ŋgúlú yeè geè, wò kɔb haá mè dé mò. Tele geé haá bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tètèì sam, à go sɔm gi aá bɔ̀ dé seèn kèn, à weh kàgàlɔ̀ŋ hèllè, à fɔɔ́n gò, à nde lè lò déì, bèh dàb mân. Wa teèn, à yila kàgàlɔ̀ŋ doô yieé ndabê. ");
INSERT INTO mcu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nde nde, kàgàlɔ̀ŋ hèllè gi yuo. Cùè die lè lò sâ ndɔ. Sâ bú dɔɔ́ŋ, à mé njeré déì beè sam cuú. ");
INSERT INTO mcu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","«Yeé yɔgɔ́ baá, à nde yila seé beè nùà lɔɔ̂ déì. Nùà hèllè njií baá-re bú ké ŋueèh seèn bèh ŋguiáŋ beleè. ");
INSERT INTO mcu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huaán doô ye merré déì nyí nde né bɔ̀ tòmò yâb ŋguiâŋ teèn domó yieé kwa; ndɔ́g, nuaré déì bú teèn há ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yeé baá ménâ, à den cuù mé huún seèn ye: Mè nde aá mé cùè mbaá kuú. Hên ké lɔ tele mò, bɔ̀ seê bɔ̀ seèn né mé yáb beè tabe den. ");
INSERT INTO mcu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mè nde aá lɔ, mè nde tueé nde né ye tele mò a: Tele mò, mè bɔɔ́ aá veên mé Càŋ, mè bɔɔ́ njií mé wò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mè nuaá mé wò nde cu né ŋuna yeè yilá, wúlú ŋgwéh. Wèh kwá njí sér yeè mè faá nùà seê yeè déì nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","À yeé tueé gi aá ménâ, à komo wuo ter ndɔ, à sɔm gò, à cu cu ké yoòr teleè. «Loù sâ, tele ke njií yí dàb ŋuna baá ndeê, à ŋene njií bú mé jere mene, à komo wuo ter ndɔ, à dula nde ŋuna ké ceér dueè kumó sie. ");
INSERT INTO mcu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ŋuna ye bú a: Tele mò, mè bɔɔ́ aá veên mé Càŋ, mè bɔɔ́ njií mé wò ndɔ. Mè nuaá mé wò nde cu né ŋuna yeè yilá, wúlú ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tele dé sâ táŋ sɔ́ ŋgwéh, à kɔ lom né bɔ̀ seê bɔ̀ seèn yilá njiî, ye bɔ́ a: Bí ndé dùlà wèllè cɔ̀gɔ̀ nyàgàm déì, bí su kwaá bú yoòr; bí yí kwá bú lɔ̀ŋ beè, bí yií kwaá bú débágá gulè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bí ndé sìè wèllè nàgà cèllè, bí ŋɔb ne kwaá tuar, te béh yieé sɔm kùrmò. ");
INSERT INTO mcu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Huaán mò lé kuú gi aá kèn, à nyimé cuù aá; à lé naâ leér, mè kwa cu aá bú. Bené kùrmò die ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Sâ bei la naâ dé seèn ké ŋueh. À baá cuû, à ŋgweé njií bèmè ké lɔ, bɔ̀ nùàr né bené ŋgɔ. Waà kwarè lɔɔ̂, ");
INSERT INTO mcu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","à yilá njiî nùà seê cén déì, à bie ke mé bú. ");
INSERT INTO mcu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nùà seê doô ye bú a: Dìm yeè cu cuù né kɔɔ́. Tele yeè sie ŋɔb aá nàgà cèllè, te béh vra bú mé njéh, ye nyí kwa cu aá huaán nyî mé njolo. ");
INSERT INTO mcu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Bei yeé nde ŋgweé njií mân, temé ŋaâ bú, à nja le ké ceér dueè. Tele yeé ŋene aá ménâ, à nde bú bɔŋ wellê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ye tele a: Kè-re sâ nɔ! Bèh lɔ mé naâ-naà, mè né lom seé yeè bɔɔ́ den, mè sòn yeè ŋgén bèh. Mé njéh mene, né mene huaán mbieè déì, wò mè há ŋgúŋgwéh, te mè yilá bilí bɔ̀ mbeí mò, béh bɔ́ samé mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lan wò yeé ke, ŋuna yeè bɔ́ bɔ̀ huaán vêh seèn bɔɔ́ beéh gi aá wò bɔ̀ njèh, à yeé cu cuù, ŋgweéh hên wò ŋɔb aá bú nàgà cèllè wa? ");
INSERT INTO mcu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tele ye bú a: Huaán mò, dé yeè bélɔ̀ né den cu dɔɔ́ŋ kɔɔ́. Bɔ̀ njèh mò dɔɔ́ŋ né gi dé yeè. ");
INSERT INTO mcu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndê, béh sé la naá kaà dìm yeè mân vra, béh ŋgɔ bené. À lé kuú giì aá kèn, à nyimé cuù aá. À lé naâ leér, mè kwa cu aá bú.» ");
INSERT INTO mcu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeésò den cuù, ye bɔ̀ mbɔ̀ŋ seèn a: «Nùà lieê déì lé naâ mé nùà seê seèn déì teèn. Loù sâ bɔ̀ nùàr ndeè ye bú a: Nùà seê yeè né wò bɔ̀ njèh bɔɔ́ beéh. ");
INSERT INTO mcu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","À yilá njiî nùà seê doô ká toò seèn ndɔ, ye bú a: Bɔ́ ye wò bɔɔ́ beéh gi aá mè bɔ̀ njèh mò sé wa? Ndé bɔ̀ njèh mò dɔɔ́ŋ taáŋ gií, mè nde né wò seé sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","À yeé nde ŋgweé njií ménâ, ye: Tele mò mè seé sɔm aá kèn; mè kuú aá, wanɔɔ́ŋ mè mò boór kíé kòmò cú; beè mò njèh duaà né fegùlì ndɔ; te mè bɔɔ́ naàn? ");
INSERT INTO mcu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","À den cuù mé be seèn ye: Mè kɔ baá kèn! Mè nde né bɔ̀ nùàr boú; mɔ tele mò sɔm aá mè seé, te bɔ́ ndeè yií keéh bɔɔ̀n mè gwò teèn. ");
INSERT INTO mcu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«À yilá njiî bɔ̀ hùà bɔ̀ teleè ká toò seèn cécéné cécéné ndɔ. À bie njií mé dé toò jɔ̀gɔ̀, ye bú a: Bî tele mò né mé hùà meèn wa? ");
INSERT INTO mcu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ye bú a: Né bɔgɔ kómò yuií. Nùà seê ye bú a: Né ménâ; dèn ndé doó, wèh nyàgà sér á yulà tîn. ");
INSERT INTO mcu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","À bie njií cu mé déì, ye bú a: Dé yeè nɔ, bî tele mò né mé hùà meèn ndɔ wa? Dé sâ ye bú a: Dé mò né ba yolò yuií tîn. Ye bú a: Né ménâ; sìè, nyàgà sér á yuií nèà. ");
INSERT INTO mcu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Nùà lieê doô yeé ŋene nùà seê tánágà hèllè né feh seèn ménâ nyamé kɔɔ́, à vra seér cu bú lòù. Ye: bɔ̀ *wɔ́ŋ bɔ̀ nyamé kela né seé bɔɔ̀n kɔɔ́ mé bɔ̀ Càŋ bɔ̀. Lòù sam, bɔ̀ Càŋ bɔ̀ seé Càŋ ménâ nyàmè bèh.» ");
INSERT INTO mcu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeésò den cuù, ye bɔ́ a: «Mè tueé bí, mé ŋgùlù wɔ̂ŋ bí gàm bɔ̀ saâm bɔ̀ mé njéh gaàm. Mɔ ndeè gi aá beè biì, Càŋ ndeè né bí te dene dé nyèmà mé nyèmà yií keéh. ");
INSERT INTO mcu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Bí kɔ́ɔ ye, nùà gècên te njèh dé maàn né nùà gècên te njèh dé koô ménâ. Nuaá mé né nùà nyeên te njèh dé maàn, né cu nùà nyeên te njèh dé koô ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mɔ bí mân tueé nagá née te ŋgùlù wɔ́ŋe ye, sâ neì bí te njèh gècên yií keéh nde né kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mɔ bí njèh bɔ̀ nùàr vèh bèh, sâ neì bí njèh dé biì mbaá haá kuú nde né kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Nuaré déì seé nùà fà kèì cén bɔ́ kòmò ndé ŋgwéh. À nde né cén bunó, à gwaán déì. À beè déì den nde né nùà gècên, à seb déì. Bí seé Càŋ bɔ̂ seé kàgàlɔ̀ŋ fà dɔɔ́ŋ kèì cén bɔ́ kòmò ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Te bɔ̀ *Farisiên mé temé dɔɔ́ŋ né gi yoòr kàgàlɔ̀ŋ, yeé nde ŋgweé njií mân, bɔ́ yuo die Yeésò yoòr mé séb. ");
INSERT INTO mcu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeésò ye bɔ́ a: «Bí den né njolò bɔ̀ nùàr faá bɔ̀ gècên bɔ̀ nɔ. Sâ bí bɔɔ́ den né mbaá, Càŋ né gi temé biì ŋené. Bí kɔ́ɔ ye, bɔ̀ njií mé né dudueèr beè bɔ̀ nùàr dɔɔ́ŋ, né gi bɔ̀ njèh mbembaâ beè Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«*Sóú Músì bɔ́ bɔ̀ *sòn-Càŋ bɔ̀ lé naá giì mé terreb teèn, yuoô te cu sâ tɔ́g nde wa mé nàm Jâŋ Bàptîs. Sâ née mé terreb ye. Jomo sâ bɔ́ se waà mé Njàgà Bagaà felè *Lò Càŋ. Kènê nùà kàn né lom lege, ye te nyí yila teèn. ");
INSERT INTO mcu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Á, sóú nɔ? Mè tueé bí, vulú bɔ̂ tàbè nde gi né faá njèh mbaâ nɔ ŋellé yuo, sóú le ter. Gwaán njolo sóù a, jíé méné gèh dé heè, ndɔ́g à nyímé ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Nuaá mé mele sɔm veèh, nde jɔgɔ cu déì dɔɔ́ŋ, kuú né yàgà. Véh mé bɔ́ naâ lòù mele sɔm, nuaá mé jɔgɔ bú dɔɔ́ŋ kuú taré né yàgà ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Nuaré déì lé naâ teèn, lé naâ nùà lieê; à né bɔ̀ cɔ̀gɔ̀ bebagaà su, cieé dɔɔ́ŋ à né yáb bebagaà yieé, à né jùjùɔ̀b yieé. ");
INSERT INTO mcu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nùà saâm déì lé naâ teèn ndɔ, yilí seèn né Lasâr. Lasâr lé naâ mé nyer yo dɔɔ́ŋ. À lé cer den beéh ké tùtúlù nùà lieê hèllè, ");
INSERT INTO mcu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ye te nyí domó yieé kwa tòmò yâb ka seèn. Bɔ̀ boór né yeé ndeé, bɔ́ nagá bilí cu bú mé nyer mene. ");
INSERT INTO mcu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Loù sâ, nùà saâm doô kuú, bɔ̀ cìlì Càŋ nde jɔgɔ kwaá njií bú ké te vulúu kwarè Abrahâm. Nùà lieê hèllè kuú ndɔ, bɔ́ furú bú, ");
INSERT INTO mcu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","à yila nde ké dòù bèh dàm gèr ŋené kuû; sâ Abrahâm bɔ̂ Lasâr baá kɔɔ́, à ke njií den aá bɔ́ lòù. ");
INSERT INTO mcu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","À lɔgɔ njií ké ter, ye Abrahâm a: Tele mò, kɔ́ yeè mè jere teèn; témá njî yeè Lasâr, te à ndeè die kwaá mè nòmò ká te leba mé nyɔ̀gɔ̀ beè, mè ŋene kuú mé gèr ká tuar. ");
INSERT INTO mcu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahâm ye bú a: Huaán mò, mùnò kɔ́ cú munò, ye ké cie nyí lé naâ mé ŋgùlù sab, sâ Lasâr né mé gèr kwaré. Kɔ́ɔ ye, kènê temé Lasâr dɔlé baá; gèr baá seér felè yeè. ");
INSERT INTO mcu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Toòmá lètenè beèh béh bî jiím tena né ŋgɔbe. Né mene béh, né mene bí, bèh kelâ sam. ");
INSERT INTO mcu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ye Abrahâm a: Sâ mɔ né mân, kúkùr yeè tele mò, témá njí cú Lasâr ké gwò tele mò teèn. ");
INSERT INTO mcu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bɔ̀ dìm mò né ké gwò tîn; te Lasâr nde tueé nyegé bɔ́, wanɔɔ́ŋ bɔ́ nde cuù né ká lè gèr-e yilá kuú. ");
INSERT INTO mcu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahâm ye bú a: Ké jomo bɔ̀ dìm yeè né mé mvù Músì mé mvù bɔ̀ *sòn-Càŋ bɔ̀ beè; bɔ́ a, ŋgwé cí. ");
INSERT INTO mcu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ye Abrahâm a: Tele mò, dé sâ wúlú ndé ŋgwéh. Ŋgulí kela né dé nuaá mé naâ dòù komo yuo, te bɔ́ kweéh seér ye temé. ");
INSERT INTO mcu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahâm ye bú a: Mɔ bɔ́ sòn Músì mé bɔ̀ sòn-Càŋ bɔ̀ ŋgúŋgwéh, sâ nuaré déì komo yuo mene dòù, ndɔ́g bɔ́ kwéh sér ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeésò den cuù ye bɔ̀ mbɔ̀ŋ seèn a: «Njií mé nde né bɔ̀ nùàr te veên dɔɔ́r yií, lím ndé ŋgwéh. Bɔɔ́ mene naàn, nùàr a, te mbeí teèn dɔ́r yí. Nuaá mé dɔr yií mbeí teèn nde né mé gèr kwaré. ");
INSERT INTO mcu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","À dɔr yií cegé mene huaán maàn cén déì lètenè bɔ̀ huaán hên te veên, à nde né mé gèr kuú. Sâ, nùà hèllè ye, mé sòn gèr hèllè bɔ́ wèh ndé kɔ́ mé nyí ké sòn nòmò koô, bɔ́ jɔ́gɔ́ kàgà kwá nyí nyèn tuagaà, bɔ́ vela si njií kɔ nyí dùà. ");
INSERT INTO mcu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sâ, bí bɔ̀ŋ nyégé feh biì bagasé. «Mɔ mbeí yeè déì né wò veên bɔɔ́, túé nyégé bú lòù. Mɔ à kweéh seér aá temé, kúlú njí dèh doó. ");
INSERT INTO mcu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mɔ à né mene mbei téhbeh lè cieé sabé den, mɔ à né yoòr yeè ndeè ye wò a: kúlú njí doó, sâ kúlú njí dèn ménâ kulù.» ");
INSERT INTO mcu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bɔ̀ mbɔ̀ŋ tebê deên ye Yeésò a: «Fehtoò beèh, bɔ́ te béh kwaá ŋeí seér temé yoòr yeè lòù.» ");
INSERT INTO mcu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Fehtoò beèh ye bɔ́ a: «Mɔ ndèm biì sé la né faá mvum tàb làm nɔ ham waá, bí sé la naâ tueé ye toú hên a: ndé kòmò njébá dèn yí dùà yíê; à sé la naâ sòn biì ŋgweé.» ");
INSERT INTO mcu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yeésò den cuù ye bɔ́ a: «Hên mɔ lètenè biì nuaré déì né mé nùà seê seèn déì teèn; né nùà kíé-boór wa, tèŋ mbieè wa, mɔ à cu cuù ŋueh, tele nde né bú ká kwarè yâb lòù yilá kaár njiî wa? ");
INSERT INTO mcu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sam, à tueé seér nde né ye bú a: Ndé nyí yáb tuar neé kwaá. Mɔ bela baá, wò su cɔ̀gɔ̀, wò ndeè geé kwaá nyí. Mɔ nyí yieé gi aá, nyí ŋueé gi aá, wò nde ye dé yeè yieé. ");
INSERT INTO mcu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mɔ nùà seê bɔɔ́ gi aá ménâ kèn, tele seèn nde né bú lòù vra seér faá né njèh kàm déì beè seèn wa? ");
INSERT INTO mcu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Né felè biì faá bèh ménâ ndɔ: mɔ bí bɔɔ́ gi aá bɔ̀ njií mé né seé biì kèn, bí júée: Seé beèh né cí, béh né dé beèh bɔ̀ seê bɔ̀ mbaá.» ");
INSERT INTO mcu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sâ Yeésò née ka te gò Jerusalem ye, à né lètenè *Samarî bɔ̂ Galilê kelá. ");
INSERT INTO mcu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","À wa lè lɔɔ́ déì; sâ bɔ̀ beén veên bɔ̀ déì yulà baá ká yoòr seèn ndeê. Bɔ́ yeé ŋene njií aá bú, bɔ́ njebá le ké dàb, ");
INSERT INTO mcu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bɔ́ lɔgɔ́ njií ké ter ye bú a: «Yeésò, dé koô, kɔ́ yeè béh jere teèn!» ");
INSERT INTO mcu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeésò ye bɔ́ a: «Bí ndé ké yoòr bɔ̀ ŋgàŋ sèmè, bí feh keéh bɔ́ yo biì.» Bɔ́ sɔm gò ndɔ. Bɔ́ yeé baá ceér dueè, bɔ́ taré yuo gi. ");
INSERT INTO mcu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cén déì lètenè bɔɔ̀n yeé ŋene aá ménâ, à cu cuù dé seèn jomo. À né gɔ, à né Càŋ ké ter seén njií. ");
INSERT INTO mcu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","À waà, à die sulí njií njolo doó ka Yeésò, à né bú vra. À lé dé seèn naâ nùà Samarî. ");
INSERT INTO mcu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeésò yeé ŋene aá ménâ, à ye: «Ŋgweéh bɔ́ yulà dɔɔ́ŋ naá giì taré yuo mà. Hên, bɔ̀ tárènèà bɔ̀ déì né he wa? ");
INSERT INTO mcu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nuaá mé cu cuù né Càŋ vra weh, gi cegé né nùà kìn hên wa?» ");
INSERT INTO mcu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jomo sâ Yeésò ye bú a: «Kòmò wùò ter, wò né temé yoòr mò kwaá njií, wò yili yuo aá kèn. Ndé-re baga!» ");
INSERT INTO mcu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bɔ̀ *Farisiên ye Yeésò a: «*Lò Càŋ wa ndeè né heèh wa?» Ye bɔ́ a: «Lò Càŋ njolò biì bèsɔ́nè jɔ́gɔ́ wá ndé ŋgwêh, te bí nde ye ŋené kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bɔ́ túé ndé ŋgwéh ye bí a: kè, hên nɔ; kè yíê. Bí kékɔɔ̀ ye Mbàm Càŋ ká lètenè biì die wa giì aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","À yeé tueé gi aá ménâ, à tueé njií mé bɔ̀ mbɔ̀ŋ seèn ndɔ, ye bɔ́ a: «Cu déì nde né teèn, bí nde né gwaán, ye bí sé la naâ biì *Huaán Nùàr cieé cén ŋené ŋgweé nɔ. Mè tueé bí, bí bú ŋéné ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bɔ́ tueé nde né ye bí a: bí kè njí kán! bí kè njí kàn! Mɔ bɔ́ baá bí ménâ tueé, bí dèn lòm dé biì nɔɔ́ŋ, bí té teèn ndé. ");
INSERT INTO mcu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gèh dé mé mbàn né yeé ké te vulúu be terré doô, loù sâ Huaán Nùàr nde né ménâ ŋagá yuo kelâ. ");
INSERT INTO mcu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Njèh cén, kɔ bɔ̀ cafanê bɔ̀ jɔ̀gɔ̀ ŋgɔn keéh gi aá bú kèn, kɔ à ŋene sɔm aá dàm bɔ̀ gèr beè bɔɔ̀n kèn ndɔ, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Loù mé Huaán Nùàr cuù nde né teèn, bɔ̀ njií mé lé bɔɔ́ giì naâ lè nàm Noê dɔɔ́ŋ nde cu né ménâ bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sâ lè nàm Noê, bɔ̀ nùàr lé kɔ loóm naâ yieê mé ŋueê, bɔ́ né véh suaá, bɔ́ né bèh siîb ndeé ndɔ. Bɔ́ né ka mé njéh méménâ bɔɔ́ ndeé, tɔ́g nde wa loù mé Noê lé yilá naâ kɔm teèn. À yeé baá lè kɔm, nu koô die, nòmò laga kum lɔ bɔ́ teèn. ");
INSERT INTO mcu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Nde cu né faá lè nàm *Lɔ̂t bɔɔ́ ndɔ: bɔ̀ nùàr lé kɔ cegé naâ yieê mé ŋueé deèn, bɔ́ né ŋge, bɔ́ né go, bɔ́ né gèh dobo, bɔ́ né gwà sieé. ");
INSERT INTO mcu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Loù sâ, Lɔ̂t yuo lè lɔɔ́ *Sɔ́dɔ̀me, we lé naâ ter lè nyùm nàgàkèn bomo suagâ, ŋgie kum sɔm cu bɔ̀ nùàr dɔɔ́ŋ jomo seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Loù mé Huaán Nùàr ndeè né teèn ŋené yuo kelâ, nde cu né bɔ̀ nùàr ménâ bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Loù sâ kwa nde né nuaré déì, sâ à né ké felè gwà; bú a, fɔ́n lòm doò, à té gwò felè bɔ̀ njèh seèn mbaá yílá kú. Kwa lɔ nde né nuaré déì ké ŋueh ndɔ, à té ká lɔ mbaá cú kû. ");
INSERT INTO mcu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bí mùnò njí cú dé mé lɔ naâ veèh Lɔ̂t kwa doô! ");
INSERT INTO mcu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nuaá mé gwaán né yɔ̀ŋ seèn mé be seèn gagá kwaá, nde né bú leér lɔɔ́. Nuaá mé né dé seèn cio felè mò ŋgɔɔ́n seér, nde né yɔ̀ŋ seèn yili sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mè tueé bí: nuaré déì bɔ̂ mbeí nde né loù sâ te ndagá cén-e; bɔ́ nde né cén weh, déì le. ");
INSERT INTO mcu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ma déì bɔ̂ mbeí nde né nyèn bècénè gwo; bɔ́ nde né cén weh, déì le. ");
INSERT INTO mcu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nuaré déì bɔ̂ mbeí nde né ké ŋueh fà; cén nde né weh, déì le.» ");
INSERT INTO mcu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jomo sâ, bɔ̀ mbɔ̀ŋ ye bú a: «Fehtoò beèh, ndeè ménâ bɔɔ́ den nde né he wa?» Ye bɔ́ a: «Bèh mé komó né teèn dɔɔ́ŋ, bɔ̀ jìè nde gi né teèn bilí ndeé.» ");
INSERT INTO mcu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeésò si bɔ́ kàn déì, ye te bɔ́ dua den Càŋ cieé dɔɔ́ŋ, bɔ́ gùr cú; à ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Nùà téná-juù déì lé naâ lè lɔɔ́ koô déì teèn, à lé Càŋ dùlà bèh, à nùàr vèh ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma kû déì lé naâ lɔ sâ teèn ndɔ; cu dɔɔ́ŋ à né toò seèn yagá ndeé den, ye bú a: Téná sɔ̀m mè ju hên teèn, te bêh nùà bùnò mò geé. ");
INSERT INTO mcu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma kû doô né ka méménâ yagá den, nùà téná-juù hèllè bú mé njéh táŋ ŋgwéh. Yeé yɔgɔ́ baá, cieé déì à den kaà mé be seèn ye: Mè né kɔɔ́ ye mè Càŋ dùlà bèh, mè nùàr vèh bèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mé njéh mene, gèh dé mé ma kû doô né mè yoòr ŋeí hên, né mè ki. Kwá mè tena sɔm bú ju hên, te mè ŋgweé keéh tie.» ");
INSERT INTO mcu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Fehtoò beèh deén baá-re ndɔ, ye bɔ̀ nùàr a: «Bí ŋgwé nyégé ŋgòr nùà téná-juù hên bagasé. ");
INSERT INTO mcu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","À né ménâ bɔɔ́ komo, sé tagá Càŋ wa? Mè tueé bí, bɔ̀ nùàr Càŋ mé né toò Càŋ cu dɔɔ́ŋ yueé, Càŋ nde né bɔ́ gam, à ŋgágá ndé ŋgwéh gùm dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","à nde né kukwar bɔɔ́. Mé njéh mene, *Huaán Nùàr ndeè cuù, sâ bɔ̀ɔ́ mé né temé cén kwaá njií, née-re teèn ye wa?» ");
INSERT INTO mcu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeésò kàn hên si kuú né felè bɔ̀ɔ́ mé né munó ye bɔ́ dé bɔɔ̀n né bɔ̀ gècên bɔ̀ toò Càŋ, bɔ́ né bɔ̀ mbeí lòù seb seér doô. Ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nuaré déì bɔ̂ mbeí lé wuó naâ ter fà dɔɔ́ŋ, bɔ́ nde ké *gwà Càŋ koô bèh Càŋ duaà; déì né Farisiên, déì né nùà wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Farisiên doô njebá nde dé seèn ké toò gèbàkàg, ye: O, Càŋ! Mè né wò vra; mè nùà mbaâ faá bɔ̀ nuaré déì nɔ sam, bɔ́ né dé bɔɔ̀n yíb ŋuɔɔ́b, bɔ́ né veên bɔɔ́ bele, bɔ́ né yàgà ndeé; mè dèn ŋgwéh faá nùà wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ hên ndɔ, mè né cu wò mé dé sâ vra kókoó mbaá. ");
INSERT INTO mcu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dé mò, lè sɔ́ndè dɔɔ́ŋ, mè né yeé yáb teèn jolo cieé fèfà. Lè bɔ̀ njèh mò dɔɔ́ŋ, njií mé baá yulà dɔɔ́ŋ, mè né yeé mbe teèn cécéné sɔm, mè haá wò. ");
INSERT INTO mcu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Nùà wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ doô njebá sua le dé seèn ké jomo, à sulí njií njolo doó mé kú mene, ye Càŋ a: Óè Càŋ mò, mè né nùà veên, kɔ́ yeè mè jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeésò den cuù baá-re ye bɔ́ a: «Mè tueé bí, Càŋ lé kwaá lɔɔ̀ naâ sòn Farisiên hèllè ménâ, à ŋgweé seér dé nùà làmpɔ̂ŋ doô. Nùà làmpɔ̂ŋ doô nde cu lɔ ndeé, sâ à baá gi dé seèn beè Càŋ dilísé; nùà lòbò kàŋ hèllè le. Bí kɔ́ɔ ye, nuaá mé né ter ŋgumó ŋaá dɔɔ́ŋ, bɔ́ nde né bú doó baá njií, te bɔ́ ter komo njií seér nùà dɔlê.» ");
INSERT INTO mcu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jomo sâ bɔ̀ nùàr né mé bɔ̀ huaán ká yoòr Yeésò weh ndeê, bɔ́ weh nde bilî mé bɔ̀ dé mbembɔgɔ̀ mene, te à kema njií bɔ́ be yoòr. Bɔ̀ mbɔ̀ŋ yeé ŋene aá ménâ, bɔ́ nde seér cu bɔ̀ nùàr lòù. ");
INSERT INTO mcu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yeésò yilá njiî bɔ̀ huaán doô ká toò seèn ndɔ, ye bɔ̀ mbɔ̀ŋ a: «Bí kwá bɔ̀ huaán ndeè ká yoòr mò, bí té bɔ́ yín. Bí kɔ́ɔ ye, *Lò Càŋ né dé bɔ̀ɔ́ mé den né faá bɔ́ nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mè né tueé ye bí a, nuaá mé Lò Càŋ mé temé seèn mene faá huaán maàn nɔ wèh ŋgwéh dɔɔ́ŋ, teèn yílá ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nùà koô bɔ̀ *Jûf déì ndeè ye Yeésò a: «Nùà fèh-njèh dé bagaà né wò. Hên, mè bɔɔ́ nde né naàn, te mè kwa ye yɔ̀ŋ dé tètàgà wa?» ");
INSERT INTO mcu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeésò ye bú a: «Wò mè nùà bagaà yilá né mé ŋgei wa? Nùà bagaà gi cegé né Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wò né gi *sóú kɔɔ́, ye: té yàgà ndé; té feh wúlá; té yíb ŋúɔ́b; té nuaré déì nyeén yoòr cɔ̀ kwá; ŋgwé sòn tele yeè mé meí yeè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nùà doô ye bú a: «Mè lé jolo duɔɔ́m naâ ménâ, sâ mè née ndà ye, mè né yeé bɔ̀ dé sâ jolo gií.» ");
INSERT INTO mcu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeésò yeé ŋgweé aá ménâ, ye bú a: «Le cu née wò njèh cén ye: ndé gò sɔ̀m gí-re bɔ̀ njèh yeè dɔɔ́ŋ, wò geé haá njií bɔ̀ saám bɔ̀ kàgàlɔ̀ŋ sâ, te wò kwa seér ŋgúlú ké ter te vulúu. Jomo sâ wò ndeè, wò bele mè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nùà hèllè yeé nde ŋgweé njií faá bèh mân, à munó njií gi ŋgúlú seèn dɔɔ́ŋ, temé kuú yuo bú lè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeésò ke njií bú ndɔ, ye bɔ̀ nùàr a: «Né taré mé bɔ̀ lilieê bɔ̀ yila *Lò Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ŋgweéh né taré mé ŋgelobà yila kela te lɔ́ŋ kɔ̀gɔ̀târ wa? Né ménâ mé nùà lieê ndɔ; te Lò Càŋ yilâ taré kela nde né dé seèn mé dé ŋgelobà.» ");
INSERT INTO mcu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ ye: «Sâ, mɔ né mân, nuaá mé nde né yili yuo, né neì?» ");
INSERT INTO mcu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeésò ye bɔ́ a: «Njií mé né bɔ̀ nùàr taré yɔgɔ́, beè Càŋ táré ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piêr ye bú á: «Ŋgweéh béh hên vu lɔ gi aá bɔ̀ njèh beèh sâ, béh bele wò mà.» ");
INSERT INTO mcu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeésò ye bɔ́ a: «Mè né tueé ye bí a, mɔ nuaré déì vu lɔ gwà seèn wa, né veèh seèn wa, né mene bei mé dìm, né mene tele bɔ̂ meí, né mene ŋuna, mɔ à bɔ́ vu lɔ né felè Lò Càŋ, ");
INSERT INTO mcu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bú a: kɔ́ɔ ye, nyí nde cu né ménâ cafanê kwa yɔgɔ́ keéh, te nyí ndeè te *wɔ́ŋ dé feê kwa bilí cu ye mé yɔ̀ŋ tètàgà mene.» ");
INSERT INTO mcu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeésò weh bɔ̀ mbɔ̀ŋ seèn yulà cùɔ̀b fà, ye bɔ́ a: «Hên, béh bí ŋaá nde baá ké Jerusalem sâ. Njií mé bɔ̀ *sòn-Càŋ bɔ̀ lé naá giì felè mò *Huaán Nùàr nyagá kwaá dɔɔ́ŋ, nde gi né ké teèn mboón. ");
INSERT INTO mcu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bɔ́ nde né Huaán Nùàr beè bɔ̀ lòù bɔ̀ jɔgɔ́ yií. Bɔ̀ lòù bɔ̀ nde né bú seb, bɔ́ selé bú; bɔ́ nde né bú dèh yoòr kulú su, ");
INSERT INTO mcu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","bɔ́ lobo bú, bɔ́ wula sɔm bú. Lè cieé tagáre, à nde cu né lè cio komo yuo ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","À yeé tueé gi aá mân, bɔ̀ mbɔ̀ŋ ŋgwé kɔ́ ŋgwéh lág; njeré déì lé ndegé yɔgɔ́ naâ bɔ́ lòù. ");
INSERT INTO mcu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeésò yeé nde aá Jerikò waá, sâ tácugó déì né te sòn ceêr njèh dua den. ");
INSERT INTO mcu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nùà hèllè yeé ŋgweé bɔ̀ nùàr baá kem kelá, à bie kwɔ̀m. ");
INSERT INTO mcu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bɔ́ ye bú a: «Né Yeésò nùà Najarêt kela né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","À sɔm hueh ndɔ, ye: «Yeésò ŋunà *Davîd, kɔ́ yeè mè jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bɔ̀ gè toò bɔ̀ mé baá kwarè seèn yeé ŋgweé aá ménâ, bɔ́ nde seér bú lòù, ye bú a: «Máb sòn yeè doó sâ.» Mé njéh mene, à kɔ lom né méménâ ké ter tueé lɔgɔ́ njiî, ye: «Ŋunà Davîd, kɔ́ yeè mè jere teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeésò njebá le ndɔ, ye bɔ́ dèrrè ndê mé bú. À yeé baá ká kwarè Yeésò, Yeésò ye bú a: ");
INSERT INTO mcu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wò ye mè a: gàm nyí naàn wa?» Ye Yeésò a: «Fehtoò mò, bɔ́ yeè te mè ŋene njolo teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeésò ye bú a: «Ŋéné njolo ŋenè! Wò né temé yoòr mò kwaá njií, wò yili yuo aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Njolo seèn kwɔgɔ yuo doó sâ ndɔ. À yuo bele lom Yeésò nenɔɔ́ŋ, à né mé Càŋ teter seén ndeé. Bɔ̀ɔ́ mé lé naâ ŋené dɔɔ́ŋ seén gi Càŋ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeésò wa Jerikò ndɔ, à né lètenè lɔɔ̂ kelá. ");
INSERT INTO mcu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nuaré déì lé naâ lɔ sâ teèn, yilí seèn né Jasê, à né nùà koô felè bɔ̀ wèh-kàgàlɔ̀ŋ làmpɔ̂ŋ bɔ̀. Né nùà lieê. ");
INSERT INTO mcu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","À né ceér fɔɔ́n, ye te nyí ŋene kwa nuaá mé bɔ́ yilá né Yeésò sâ; lɔ́ŋ sam mé bɔ̀ nùàr, à lé naá cuù nùà tibî ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","À yeé ŋene aá ménâ, à dula kela nde gè toò bɔ̀ nùàr, à sie ŋaá toú déì, à né Yeésò teèn kela den, te à ŋene ŋgweé bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yeésò waà bèh sâ, à sɔm njií njolo ter, à ŋene njií bú; ye bú a: «Súágà ká doó wúwágá, Jasê; lan mè cer nde né ké gwò yeè.» ");
INSERT INTO mcu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jasê wur suagà, à weh njií Yeésò ké gwò seèn mé vràb mene. ");
INSERT INTO mcu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bɔ̀ nùàr yeé ŋene aá ménâ, bɔ́ duɔɔ́m ndugô, ye: Nùà hên nde ké gwò nùà veên cer seér né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jomo sâ Jasê komo wuo ter ndɔ, ye Yeésò a: «Fehtoò mò, mè nde né bɔ̀ njèh mò dɔɔ́ŋ fèfà kɔbé bele, mè geé haá njií bɔ̀ saâm bɔ̀ kèb déì. Mɔ mè lé naâ kàgàlɔ̀ŋ beè nuaré déì bele weh, mè nde cu né bú jomo méménâ mbei nèà haá cuú.» ");
INSERT INTO mcu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","À yeé tueé gi aá ménâ, Yeésò ye: «Nùà hên né ndùté ndùtù Abrahâm ndɔ; lan, cɔ̀ŋ yilà baá te mbàgà seèn kèn. ");
INSERT INTO mcu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bí kɔ́ɔ ye, bɔ̀ɔ́ mé né lòù leér le dɔɔ́ŋ, *Huaán Nùàr hên nde kuú naâ bɔ́ fɔɔ́n, te à yili sɔm bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bɔ̀ɔ́ mé naâ ŋgòr hên ŋgweé, Yeésò si cu bɔ́ kàn déì. Sâ, bɔ́ baá kwarè Jerusalem, bɔ̀ nùàr baá lom munó ye, doó sâ *Lò Càŋ nde aá ŋené ŋagá. ");
INSERT INTO mcu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","À ye bɔ́ a: «Nuaré déì lé naâ teèn, à né lè bɔ̀ŋ bɔ̀ huaán mgbè. À yeé nde aá mgbè cer, à nde lè lɔɔ́ déì bèh dàb mân, te bɔ́ lobo bú tì, à cuù, à cer ye mgbè. ");
INSERT INTO mcu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","«À yeé baá mé gò, à yilá bilí bɔ̀ seê bɔ̀ seèn yulà, à geé haá kwaá bele bɔ́ kàgàlɔ̀ŋ kám cécéné beè-beè, à ye bɔ́ a: Bí bɔ́ ŋgɔ́gɔ̀ toón mé njéh jomo; kɔ mè ndeè cuù aá. À yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","À wa toò, bɔ̀ lɔɔ́ bɔ̀ seèn bunó bú ká jomo, bɔ́ tema njií ye: Té bú tì lòbò, béh bú gwàn ŋgwéh, à mgbè beèh sam. ");
INSERT INTO mcu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mé njéh mene, bɔ́ lobo bú tì. À cu cuù ká lɔ lètenè bɔɔ̀n. À waà, à ye, bɔ́ yílá njî bɔ̀ seê bɔ̀ nyî doô, kɔ ŋgweé kàgàlɔ̀ŋ naâ jomo ŋar wa. ");
INSERT INTO mcu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Déì waà ye bú a: Dé koô, kám yeè cén doô ŋar aá kám yulà; hên nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mgbè doô ye bú a: Môn, wò né nùà gècên; wò né njèh memanè ke nyegé kɔɔ́, wèh bá bɔ̀ ndugo lɔɔ̂ yulà hên, wò cèr mgbè teèn. ");
INSERT INTO mcu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Dé jomò wa cuù, ye bú a: Dé koô, dé mò ŋar cu aá kám tîn déì ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mgbè doô ye bú a: Bɔ̀ ndugo lɔɔ̂ tîn hên baá dé yeè ndɔ; cèr á mgbè teèn kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Déì wa cuù ndɔ, ye bú a: Dé koô, wèh cú-re kàgàlɔ̀ŋ yeè. Mè lé naâ bú te cɔ̀gɔ̀ kaga nyegé, mè leér kwaá lòù. ");
INSERT INTO mcu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Wò yeè né nùà yɔgɔ̂; mè veéh naâ cí. Wò mene njeré déì kɔɔ́ kwá ŋgwéh, wò né yeé mbaá weh njií. Wò mene kɔɔ́ dòbò bèh, wò né yeé mbaá kwaá njií. ");
INSERT INTO mcu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Mgbè doô ye bú a: Nùà veên faá wò nɔ! Wò ju kènê beè mò die nde né mé ŋgòr yeè sâ. Wò lé naá giì kɔɔ́ ye mè né nùà yɔgɔ̂: mè mene kɔɔ́ kwá ŋgwéh, mè né yeé mbaá weh njií. Mè mene kɔɔ́ dòbò bèh, mè né yeé mbaá kwaá njií. ");
INSERT INTO mcu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lé bɔɔ́ naâ naàn mé wò lé mè kàgàlɔ̀ŋ mò ké te mbiîn kwá njí ná ŋgwêh te ŋar, mè cuù, sâ nòmò baá teèn wa? ");
INSERT INTO mcu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«À tueé njií mé bɔ̀ nùàr ndɔ, ye bɔ́ a: Bí ŋgà sɔ̀m bú kàgàlɔ̀ŋ sâ beè ŋgaà; bí ságá njí mé nùà kám yulà jɔ̀gɔ̀. ");
INSERT INTO mcu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bɔ́ ye bú a: Dé koô, á dé sâ baá gi dé seèn mé kám yulà beè nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ye bɔ́ a: Mè tueé bí, nuaré déì nde gi né mé njèh beè, bɔ́ haá sagá cu bú déì teèn. Nuaré déì dé seèn mé njèh beè sam nde ŋgweéh, né mene dé maàn mé à né mé njéh dɔɔ́ŋ, bɔ́ nde né bú beè horó sɔm. ");
INSERT INTO mcu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dé bɔ̀ bùnò bɔ̀ mò, bí sìè ndé gî mé bɔ́ ká toò mò; bɔ́ ye mè mgbè bɔɔ̀n sam, bí wúlá sɔ̀m gí bɔ́ wulà.» ");
INSERT INTO mcu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeésò yeé tueé gi aá ménâ, à gɔ kela nde gè toò bɔ̀ nùàr ndɔ, bɔ́ bɔ́ né Jerusalem ndeé. ");
INSERT INTO mcu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bɔ́ yeé wa kèbè Betafajê bɔ̂ Betanî, kwarè tòr mé bɔ́ yilá yeé tòr Oliviê, Yeésò tema keéh bɔ̀ mbɔ̀ŋ fà déì toò, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Bí ndé lè lɔɔ́ toò biì sâ. Mɔ bí yilá baá lɔ, bí nde né huaán vuɔmndeè ŋené. Nuaré déì née teèn ŋá lɔ́gɔ́ ŋgwéeh ye. À né te yuiî mân. Bí sè ndê mé bú. ");
INSERT INTO mcu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mɔ nuaré déì ye bí a, bí bú se né dé keì wa, bí júée bú a: Nùà Dueè gwaán né bú kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bɔ́ yuo gò ndɔ, bɔ́ wa, bɔ́ kwa gi ka dɔɔ́ŋ faá Yeésò tueé naâ bɔ́ nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bɔ́ yeé baá ménâ se den, bɔ̀ njèh bɔ̀ bie ye bɔ́ a: «Bí huaán vuɔmndeè sâ se den né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bɔ́ ye bɔ́ a: «Nùà Dueè gwaán né bú kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jomo sâ, bɔ́ se haá njií bú mé Yeésò ndɔ; bɔ́ né bɔ̀ cɔ̀gɔ̀ bɔɔ̀n huaré weh, bɔ́ né ŋgètenè vuɔmndeè teé njií, bɔ́ né Yeésò teèn jɔgɔ́ kwaá. ");
INSERT INTO mcu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","À yuo gò, à né ndeé, bɔ̀ nùàr né bɔ̀ cɔ̀gɔ̀ yoòr bɔɔ̀n huaré weh, bɔ́ né ceceér teé njií. ");
INSERT INTO mcu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","À né ké te tòr Oliviê doô suagá ndeé, à wa kwarè Jerusalem, sâ dàm bɔ̀ mbɔ̀ŋ né ceér dueè léláŋ vɔ́gɔ́-temê samé den, bɔ́ né Càŋ ké ter seén njií. Bɔ́ né bú felè bɔ̀ fém mé bɔ́ lé naá giì ŋené dɔɔ́ŋ seén laré. ");
INSERT INTO mcu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɔ́ ye: «Càŋ a, kúlú nyégé Nùà Dueè mé ndeè né mé yilí seèn hên kulù. Cɔ̀ŋ ké ter te vulúu mé *sùsùm né dé Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sâ bɔ̀ *Farisiên déì lé naâ lètenè bɔ̀ nùàr doó sâ teèn. Bɔ́ ye Yeésò a: «Júée bɔ̀ mbɔ̀ŋ yeè a, bɔ́ húné-re nɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeésò ye bɔ́ a: «Mè tueé bí ndɔ, mɔ bɔ́ huné mene nɔɔ́ŋ, bɔ̀ taá nde né ménâ seén den.» ");
INSERT INTO mcu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yeésò yeé baá kwarè Jerusalem, à ke njií lɔɔ́, à yueé velé, ");
INSERT INTO mcu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ye lɔɔ́ a: «Nuaá mé sé naâ wò dɔlê haá, wò sé naâ yeè bú keí mé né hên ŋené kɔɔ́ nɔ. Ŋgweéh kènê leér baá njolò yeè mà. ");
INSERT INTO mcu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kékɔɔ̀ ye, cieé déì nde né teèn, bɔ̀ bùnò bɔ̀ yeè nde né wò beè kaáŋ sie, bɔ́ kaga keéh wò yí lètenè, bɔ́ sané yilà nde né lètenè biì dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","bɔ́ kibí kela mé bɔ̀ nùàr yeè doó, bɔ́ kum sɔm bí. Taá déì felè mbeî lè ndé ŋgwéh. Lòù sam, Càŋ ndeè né ye te nyí yili sɔm wò. Mé njéh mene, wò ŋéné kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeésò yila nde yí cie gwà Càŋ koô ndɔ. À wa, sâ bɔ̀ nùàr né toón teèn bɔɔ́ den. À yeé nde ŋene njií ménâ, à yila bɔ́ cie kwɔgɔ́ sɔm keêh. ");
INSERT INTO mcu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","À né bɔ́ teèn tueé yií, ye bɔ́ a: «Né gi lè mvù Càŋe nyagá den ye: Gwà mò né lom gwà Càŋ duaà. Keí mé bɔɔ́ bí weh kwaá seér aá gùr yîb biì wa?» ");
INSERT INTO mcu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Cieé dɔɔ́ŋ Yeésò né bɔ̀ nùàr njèh ké gwà Càŋ feh den. Yeé baá môn, bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù, bɔ́ bɔ̀ kokoô bɔ̀ dɔɔ́ŋ duɔɔ́m aá ceér fɔɔ̂n, te bɔ́ wula sɔm bú. ");
INSERT INTO mcu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Njèh cén, bɔ́ bú sìè kwà ŋgwéh. Lòù sam, cìlì nùàr lé naâ doó, bɔ́ né ŋgòr seèn felá. ");
INSERT INTO mcu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cieé déì lé naâ teèn, Yeésò né bɔ̀ nùàr njèh ké *gwà Càŋ koô feh den, à né bɔ́ Njàgà Bagaà se. Bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ njí-sóù kar waà mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂ jomo, ");
INSERT INTO mcu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bɔ́ ye Yeésò a: «Wò bɔ̀ njií hên bɔɔ́ né mé gèh terrèb dé heè? Neì wò jegé naâ kɔɔ́ wa? Túé béh tueè.» ");
INSERT INTO mcu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeésò ye bɔ́ a: «Mè nde né bí ménâ bieé ndɔ: bí jɔ̀gɔ̀ túé ke mè ye: ");
INSERT INTO mcu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Neì lé Jâŋ Bàptîs tema njií naâ kɔɔ́, ye bú a: ndé bɔ̀ nùàr kou bele wa? Lé naâ Càŋ wa, lé naâ nùàr wa?» ");
INSERT INTO mcu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bɔ́ yila mé njéh lètenè bɔɔ̀n fellé kuú ye: «Mɔ béh ye bú a: Càŋ lé Jâŋ temà naâ kɔɔ́, à tueé nde né ye béh a: béh lé temé yoòr seèn kwá njí ná ŋgwêh dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Á, mɔ béh ye bú a: bɔ̀ nùàr lé bú temà naâ kɔɔ́, sâ bɔ̀ nùàr nde né béh tɔbé wulá. Lòù sam, beè bɔɔ̀n Jâŋ lé naâ *sòn-Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yeé baá ménâ, bɔ́ ye bú a: «Béh kɔ́ ŋgwéh nuaá mé lé temà naâ bú.» ");
INSERT INTO mcu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeésò ye bɔ́ a: «Sâ mè bí nuaá mé jegé naâ mè túé ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jomo sâ Yeésò si njií bɔ̀ nùàr kàn déì, ye bɔ́ a: «Nuaré déì lé kieè naâ ŋueèh seèn; à yeé dobo gi aá yab teèn, à haá kwaá ŋgɔgɔ̂ beè bɔ̀ nuaré déì te bɔ́ ke nyegé den jomo. À yuo dé seèn, à nde bèh gò dàb déì. ");
INSERT INTO mcu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","«Cu mé yab yeé baá bɔlé, à tema njií nùà seê seèn cén déì ké yoòr bɔ̀ kè-ŋueèh bɔ̀ doô, ye te nyí kwa yab teèn. Nùà seê doô yeé wa ké teèn, bɔ́ lobo kwɔgɔ njií cu bú jomo be be. ");
INSERT INTO mcu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nùà ŋueèh doô tema njií cu nùà seê seèn déì. Bɔ́ nde kem sue cu bú yoòr mé séb, bɔ́ lobo kwɔgɔ njií cu bú jomo be be ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lè njùg tagáre, à tema njií cu nùà seê seèn déì ndɔ; dé sâ yeé wa cu, bɔ́ duún ye baá-re bú núr, bɔ́ tulu si njií bú ké luaà ŋueèh. ");
INSERT INTO mcu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Nùà ŋueèh doô ye ŋene aá ménâ, ye nyí bɔɔ́ nde né naàn wee? À deên ndɔ, ye: Nyí kènê tema njií nde aá ŋuna nyî yíé-temê; merré déì dé seèn, bɔ́ nde né bú veéh. ");
INSERT INTO mcu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ŋuna nde ndɔ. Bɔ́ yeé nde ŋene njií baá-re bú mân, bɔ́ nyɔgɔ sòn ye: Hên né nuaá mé nde né nùà ŋueèh ŋaá sâ. Kɔ béh wula sɔm bú lòù, te ŋueèh hên ŋa dé beèh. ");
INSERT INTO mcu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bɔ́ tulu nde mé bú ké luaà ŋueèh, bɔ́ wula si lɔ bú ké teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yeésò den cuù, ye bɔ̀ nùàr a: «Faá bèh mân, nùà ŋueèh doô bɔɔ́ nde né bɔ́ naàn wee? Mè tueé bí, à nde cu né bɔ́ wulá sɔm gií ndɔ, à ŋueèh kwaá lɔ cu beè bɔ̀ nuaré déì.» Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ ye bú a: «Ndɔ́g gèh dé sâ ndeè seèn ménâ bɔ́ ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yeésò né bɔ́ njonjolò ke njegé, ye bɔ́ a: «Kàn mé bɔ́ né te mvù Càŋe nyagá kwaá hên tueé né kei? Ye: Taá mé bɔ̀ mé-gwà bɔ̀ lé naâ ké jomo komo si njií hên, taá dàn ŋa seér cu né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nuaá mé ceén die te taá sâ nde né teèn ŋerré le. Mɔ komo die seér né nuaré déì yoòr lòù, sâ nùà hèllè nde né faá fùfú nɔ nyoló den ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bɔ̀ *njí-sóù mé bɔ̀ *ŋgàŋ sèmè dé kokoô yeé ŋgweé aá ménâ, bɔ́ ŋgweé kɔ ye Yeésò kàn si njií den né mé bɔ́; bɔ́ gwaán lom aá Yeésò doó sâ sieè. Njèh cén, veéh né bɔ́ mé bɔ̀ nùàr sie yɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bɔ́ duɔɔ́m bú filî, bɔ́ tema njií bɔ̀ no ké kwarè seèn faá né bɔ̀ gècên bɔ̀ nɔ, te bɔ́ ŋgweé weh ŋgòr sònò seèn, bɔ́ jɔgɔ yií bú beè ŋgɔ́mnà. ");
INSERT INTO mcu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wa ké teèn, bɔ́ ye bú a: «Nùà fèh-njèh, njií mé wò né yeé tueé, wò né bɔ̀ nùàr feh dɔɔ́ŋ né teèn yilá, béh né kɔɔ́. Wò nùàr bàlè bèh, wò né bɔ́ ceér Càŋ mé gècên mene feh dilí. ");
INSERT INTO mcu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sâ jɔ̀gɔ̀ túé ke béh ye: *Sóú beèh ye gwɔ̀m làmpɔ̂ŋ mgbè Rɔ̂m gwɔɔ̀m wa, té gwɔ̀m wa?» ");
INSERT INTO mcu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yeésò ŋene kɔ ndɔ, ye ŋgòr hên né njɔ́g ŋgòr; à ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Bí kélé ke mè kàgàlɔ̀ŋ sâ cén déì ye.» Bɔ́ weh haá njií bú cén déì. Ye bɔ́ a: «Feh nùàr mé yilí nùàr ká teèn hên nyagá den né dé neì wa?» Bɔ́ ye bú a: «Né gi dé mgbè Rɔ̂m.» ");
INSERT INTO mcu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","À deén baá-re, ye bɔ́ a: «Sâ bɔ̀ njií mé né dé mgbè dɔɔ́ŋ, bí gwɔ̀m njí cú mé mgbè; bí bɔ̀ dé Càŋ há njí cú mé Càŋ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","À yeé tueé gi aá ménâ, hiím yɔgɔ́ bɔ́ dé tueê. Ŋgòr mé à lé naá giì toò bɔ̀ nùàr tueé dɔɔ́ŋ, bɔ́ bú teèn sìè kwà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bɔ̀ *Sadusiên déì bilí ndeè ká kwarè Yeésò. Sâ bɔ́ né yeé tueé ye: mɔ nùàr kuú baá, sâ gi aá, à lè cio kòmò yùò ndé cú. ");
INSERT INTO mcu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bɔ́ yeé waà baá, bɔ́ ye bú a: «Nùà fèh-njèh, Músì lɔ naá giì ter nyagá kwaá, ye béh a: mɔ nuaré déì kuú kwaá lɔ véh mé huaán sam, dìm a, sàgà cú ma kû doô, à ŋar yilá cu bei ma. ");
INSERT INTO mcu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yeé baá ménâ, nuaré déì bɔ́ bɔ̀ dìm lé naâ téhbeh. Bei jɔgɔ véh, à kuú kwaá lɔ véh sâ, huaán sam. ");
INSERT INTO mcu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dìm sagá weh ma kû doô, à kuú cu, huaán sam. ");
INSERT INTO mcu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dìm bɔɔ̀n déì sagá weh keéh cu ndɔ. Bɔ́ né ka mé bú méménâ sagá ndeé; bɔ́ sagá laré bú téhbeh dɔɔ́ŋ, bɔ́ huaán mé ma hèllè ŋàr kwà ŋgwéh, bɔ́ kuú gi. ");
INSERT INTO mcu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jomo sâ, ma hèllè kuú bele bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Á hên, mɔ loù sâ bɔ̀ komó ndeè baá te cio komo yuo, ma hèllè ŋa sɔm nde né veèh dé heè wa? Ŋgweéh lètenè bɔɔ̀n téhbeh dɔɔ́ŋ, bɔ́ lé naá giì bú sagá laré wa?» ");
INSERT INTO mcu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeésò ye bɔ́ a: «Bɔ̀ siíb bɔ́ bɔ̀ véh jɔgɔ kuú lom né ká cie. ");
INSERT INTO mcu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bɔ̀ɔ́ mé wulu gi aá dé *Lò Càŋ kèn, nde né te cio komó yuo, bɔ́ yila nde teèn. Ké Lò Càŋ sâ nùàr ndeè jɔ́gɔ́ kú ndé cú. ");
INSERT INTO mcu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ké sâ nùàr ndeè kú ndé cú ndɔ, bɔ́ den seér nde aá faá bɔ̀ cìlì Càŋ nɔ. Ŋgweéh bɔ́ lé naá giì te cio komó yuo mà, bɔ́ baá gi bɔ̀ ŋunà Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Músì te mvù Càŋe tueé taré né ménâ ndɔ, ye: bɔ̀ komó nde cuù né lè cio komo yuo gií ma. À lé mân nyagá naâ te lèmè mé à nyagá né ju jìlì ŋgémbèì teèn doô, ye Nùà koô nyî né Càŋ mé bɔ̀ tele nyî Abrahâm bɔ̂ Isâk mé Jakɔ̂b né yeé dua doô ma. ");
INSERT INTO mcu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mè tueé bí, Càŋ né Càŋ bɔ̀ lèlàŋ bɔ̀, à Càŋ bɔ̀ komô sam. Bí kɔ́ɔ ye, beè seèn nùàr dɔɔ́ŋ né gi bɔ̀ lèlàŋ bɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bɔ̀ *njí-sóù déì yeé ŋgweé aá ménâ, bɔ́ ye bú a: «Nùà fèh-njèh, wò tueé yií né teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yeé baá mân, nuaré déì njolo toò seèn kàgà nyì cú, ye nyí nde né bú njeré déì bieé. ");
INSERT INTO mcu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeésò ye bɔ́ a: «Bɔ́ ye Nùà Cɔ̀ŋ né *ndùté ndùtù Davîd, mé ŋgei wa? ");
INSERT INTO mcu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davîd mé feh seèn lé naá giì lè mvù benê tueé kwaá ye: Nùà Dueè ye Nùà koô nyî a: Dèn ndê ká te be gaâ nyî; ");
INSERT INTO mcu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kɔ nyí komó silí njií gi aá bɔ̀ bùnò bɔ̀ yeè doó, wò dobo keéh bɔ́ gulè. ");
INSERT INTO mcu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hên, mɔ Davîd mé feh seèn Nùà Cɔ̀ŋ sâ yilá né Nùà koô seèn, sâ Nùà Cɔ̀ŋ né cu ndùté ndùtù seèn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yeésò né mé bɔ̀ mbɔ̀ŋ seèn njolò cìlì nùàr tueé njií, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Bí bɔ̀ŋ feh biì beè bɔ̀ njí-sóù. Bɔ́ gwaán lom né bɔ̀ cɔ̀gɔ̀ dé dèdàbe lètenè bɔ̀ nùàr su gɔɔ̀. Né mene ké tan mé ké mbartɔgɔ̂, bɔ́ ye kɔ bɔ̀ nùàr gìbì bíé bɔ́ lòù. Ké *gwà sóù bɔ́ gwaán né bèh denè dé kokoô njolò bɔ̀ nùàr. Bɔ́ nde mene bèh kùrmò lɔ nùàr dɔɔ́ŋ, né gi ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɔ́ né njèh beè bɔ̀ ma kû horó weh bele. Mɔ bɔ́ baá Càŋ dua, kɔ bɔ́ dua tugó lòù, te den faá bɔ́ né bɔ́ gècên bɔ̀ nɔ. Me tueé bí, ju sie kela nde né bɔ́ mé bɔ̀ déì.» ");
INSERT INTO mcu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeésò né ke den, à ŋene bɔ̀ lilieê bɔ̀ né kàgàlɔ̀ŋ lè mvugó gwà Càŋ si den. ");
INSERT INTO mcu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","À ŋene njií ma kû déì baá kɔ́bɔ̀ fà teèn si yií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ye bɔ̀ nùàr a: «Mè né tueé ye bí a, ma kû hên si kela né kɔɔ́ mé bɔ̀ déì dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bɔ̀ nùàr dé bɔɔ̀n kabe si lom né wèllè kàgàlɔ̀ŋ. Dé ma kû hên môn sam, à dé seèn horó si sɔm né cèr gwà seèn.» ");
INSERT INTO mcu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sâ bɔ̀ nùàr baá lom gwà Càŋ koô keí; à lé naâ yàgà huɔɔ́m dé gècên. Bɔ́ lé bú meè naâ mé bɔ̀ taá bebagaà mân, bɔ́ bú yàgà nyegé cu mé bɔ̀ njèh há-be ndɔ. Bɔ́ yeé baá gwà ménâ keí, Yeésò ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Gwà mé bí né ŋené hên, cieé déì nde né teèn, à nde gi né dɔɔ́ŋ tɔbé yuo. Mè jue mene taá cén tà cén felè mbeî lè nyì ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bɔ́ ye bú a: «Nùà fèh-njèh, dé sâ ndeè ménâ bɔɔ́ nde né heèh wa? Mɔ ndeè nde aá ménâ bɔɔ́, bɔ́ ŋene kɔ nde né mé kei ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeésò ye bɔ́ a: «Bí kɔ́gɔ́n ká lòù; nùàr a, té bí bèlè. Mɔ sam, bɔ̀ nùàr kókoó mbaá nde né yilí mò ŋaá weh, nùà kàn nde né tueé ye bí a, Nùà Cɔ̀ŋ né nyí; nùà kân ye bí a, cu waà baá ndɔ. Mè tueé bí, bí té tie teèn félá njí. ");
INSERT INTO mcu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mɔ bí baá njàgà taâb mé bɔ̀ bèmè hihiné ŋgweé njií, bí té lòù ndèrrè. Kɔ seèn bɔɔ́ ménâ. Mé njéh mene, wɔ́ŋ mé njéh cèrè ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","À den cuù, ye bɔ́ a: «Taáb nde né lètenè lɔɔ́ déì bɔ̂ mbeí kɔɔ́ die. Lò déì nde né mbeí mé taáb ŋaár kwa. ");
INSERT INTO mcu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tàbè nde né jilí taré; cùè nde né te tàbè hihinê die; teèn yila bele cu mé fùà mene ndɔ. Bɔ̀ kèkènè njèh ndùàn feh hihiné nde né bɔɔ́ bele; bɔ̀ cìè feh hihiné ndeè né ké te vulúu ŋené yuo kelâ. ");
INSERT INTO mcu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Bɔ̀ nùàr jɔ̀gɔ̀ bunó nde née bí lòù ye, te waà ye. Bɔ́ nde né bí mé sòn fuû sie, bɔ́ sie njií bí ké *gwà sóù bèh juù, bɔ́ yií bí gwà cibì. Bɔ́ nde né bí ké toò bɔ̀ mgbè mé bɔ̀ kokoô bɔ̀ mgbɔmé njií, ye bí né bɔ̀ nùàr mò fí. ");
INSERT INTO mcu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mè tueé bí, toò bɔɔ̀n sâ baá cu ye-re bèh mé bí den nyegé nde né sòn mò teèn. ");
INSERT INTO mcu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mɔ bɔ́ baá bí ménâ bɔɔ́, bí njébá lòm tég, ye béh njeré déì toò nyàmè ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mè nde né bí kɔ́ŋkɔŋ haá, mè nde né bí ŋgòr sònò tueé kwaá gií ndɔ. Bɔ̀ bùnò bɔ̀ biì toò biì njébá ndé ŋgwéh, bɔ́ tueé komo njeré déì.» ");
INSERT INTO mcu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","À den cuù, ye bɔ́ a: «Né mene bɔ̀ tele biì, bɔ́ nde né bí go sɔm. Né mene bɔ̀ bei biì, bɔ̀ dìm biì, bɔ̀ nùàr biì mé bɔ̀ mbeí biì mene dɔɔ́ŋ, bɔ́ nde né bí go sɔm. Lètenè biì, bɔ́ nde né bɔ̀ nuaré déì teèn wulá. ");
INSERT INTO mcu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nùàr nde né bí bèh dɔɔ́ŋ bunó laré; sâ dɔɔ́ŋ né gi felè mò. ");
INSERT INTO mcu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mé njéh mene, yúlí feèh biì cén lèr nyì ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kɔ bí yolo lòù, te bí yili sɔm ye yɔ̀ŋ biì.» ");
INSERT INTO mcu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Mɔ bí ŋene taáb baá Jerusalem beè kaáŋ sie, sâ bí kɔ́ɔ ye, Jerusalem nde aá cim le. ");
INSERT INTO mcu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mɔ baá môn, sâ bɔ̀ Judê bɔ̀ a, dùrà ŋá gí ké te tòre; bɔ̀ Jerusalem bɔ̀ durá taré môn ndɔ. Bɔ̀ɔ́ mé né ké ŋueh dɔɔ́ŋ a, té ká lɔ mbaá dùlà ndé cû. ");
INSERT INTO mcu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Loù sâ né cieé njùŋ sɔɔ̀m, te yuo ka nág faá bɔ́ lé naâ lè mvù Càŋe nyagá kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Loù sâ bɔ̀ véh mé lèì hueêh mé bɔ̀ ma vùlù nde né mé gèr ŋené kuú. *Wɔ́ŋ nde né bɔ̀ nùàr loù sâ nyunò dulí. Mè tueé bí, Càŋ feh keéh nde né yúlá-temê seèn yoòr bɔ̀ nùàr loù sâ. ");
INSERT INTO mcu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɔ́ nde né bɔ̀ déì lòù kɔré wulá, bɔ́ nde né mé bɔ̀ déì lò nùàr dɔɔ́ŋ sie ŋellé ndeé. Loù sâ Jerusalem gule doró keéh nde né bɔ̀ cɔɔ́ŋ. Kɔ cu bɔɔ̀n wulu baá, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Loù mé Huaán Nùàr cuù nde né teèn, bɔ̀ njèh ndùàn nde né ké te vulúu feh hihiné bɔɔ́ bele: bɔ̀ déì nde né te lou, bɔ̀ déì te weêh, bɔ̀ déì te mbentòo. Ká doó, bɔ̀ nùàr nde né mé veéh ndɔré kuú: nòmò nde né naŋ, à nde né ŋgulí tulú. ");
INSERT INTO mcu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bɔ̀ njií mé né gi mé terreb ké ter nde gi né loù sâ jilí laré. Bɔ̀ njií mé nde né ká lè wɔ́ŋe bɔɔ́, veéh nde né bɔ̀ nùàr mé njéh sie, bɔ́ nde né seé cer. ");
INSERT INTO mcu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jomo sâ bɔ́ nde né Huaán Nùàr ŋené njií, à né te mvulu bège mé terreb mene *sum suagâ. ");
INSERT INTO mcu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mɔ bɔ̀ njií sâ ndeè baá ménâ bɔɔ́, bí sàmè wùò sér dé biì ter lòù; bí kɔ́ɔ ye, nùà gàm biì baá dìdì ma.» ");
INSERT INTO mcu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jomo sâ Yeésò si cu bɔ́ kàn déì, ye bɔ́ a: «Bí kè wèh yoòr bɔ̀ toú túé-kùr. ");
INSERT INTO mcu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mɔ bí ŋene, bɔ́ baá tɔɔ́, ŋgweéh sâ bí kɔ gi aá ye jà baá dìdì wa? ");
INSERT INTO mcu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nde né mé *Lò Càŋ ménâ ndɔ; mɔ bí ŋene bɔ̀ njèh kèkènè hèllè baá bɔɔ́ bele, sâ bí kɔ́ɔ ye, Lò Càŋ baá dìdì. ");
INSERT INTO mcu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mè né tueé ye bí a, mé bɔ̀ cafanê bɔ̀ nde dɔɔ́ŋ kuú gií, sâ bɔ̀ njèh hèllè bɔɔ́ gi aá. ");
INSERT INTO mcu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Vulú bɔ̂ tàbè nde né leér yuo; ndɔ́g, bɔ̀ ŋgòr mò dé bɔɔ̀n nyímé ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Bí dèn dèn làŋ cu dɔɔ́ŋ, bí té mé cieé koô tùgò lè; bí té mé mbè sèlà lè, bí té mé *wɔ́ŋ nyàmè lè ndɔ. Mɔ sam, ndeè né lòù kaár waâ, ");
INSERT INTO mcu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tena lɔ bí teèn. Kar waà nde né felè bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bí té lɔ́m cèr, bí dùà dèn Càŋ cu dɔɔ́ŋ, te à haá bí terreb, bí yolo komo njèh, bí mvelé yuo te gèr-e. Mɔ baá mene jueé, te bí njebá le ter toò *Huaán Nùàr.» ");
INSERT INTO mcu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Cieé dɔɔ́ŋ Yeésò né bɔ̀ nùàr ké gwà Càŋ koô feh sɔɔ́. Liyilì, à né ké te tòre ndeé, à cer le toò. Tòr sâ, bɔ́ bú yilá né tòr Oliviê. ");
INSERT INTO mcu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Maánjɔ̀gɔ̀ dɔɔ́ŋ bɔ̀ nùàr lé naâ beéh gwà Càŋ komo ndeé, bɔ́ né ŋgòr sònò seèn ŋgweé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sâ cieé koô mé bɔ́ yieé yeé breêd mé kulu teèn sam baá dìdì. Cieé koô sâ bɔ́ yilá yeé *Páskà. ");
INSERT INTO mcu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sâ bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù né ceér fɔɔ́n te bɔ́ nde Yeésò lòù wulá naáb sɔm. Lòù sam, bɔ́ né bɔ̀ nùàr veéh. ");
INSERT INTO mcu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sátàn yila Júdàs lè ndɔ. Yilí Júdàs déì né cu Iskariô; à né mbɔ̀ŋ cén déì lètenè bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô. ");
INSERT INTO mcu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yeé baá ménâ, à komo wuo ter ndɔ, à nde yoòr bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ gó gwà Càŋ bɔ̀, bɔ́ bɔ́ né ceér fɔɔ́n te à feh keéh bɔ́ Yeésò, bɔ́ sie bú. ");
INSERT INTO mcu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bɔ́ lé naá loôm mé vɔ́gɔ́-temé dé gècên, bɔ́ ye, bɔ́ nde né bú kàgàlɔ̀ŋ teèn haá yií ma. ");
INSERT INTO mcu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Júdàs gwaán ndɔ. À yila lom baá-re ceér fɔɔ̂n, te à feh nab kwaá bɔ́ Yeésò lòù. ");
INSERT INTO mcu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sâ cieé koô mé bɔ́ yieé yeé breêd mé kulu teèn sam, waà baá ndɔ. Bɔ́ né yeé huaán sòrŋgaàŋ teèn ŋɔɔ́b, te bɔ́ yieé Páskà mé njéh. ");
INSERT INTO mcu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Cieé sâ yeé waà baá, Yeésò ye Piêr bɔ̂ Jâŋ a: «Bí ndé nyégé kwá béh Páskà, te béh yieé.» ");
INSERT INTO mcu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bɔ́ ye bú a: «Wò gwaán né ye béh nde nyegé kwaá he wa?» ");
INSERT INTO mcu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ye bɔ́ a: «Bí ndé; mɔ bí wa baá ké lɔ, bí bɔ̀ nuaré déì nde né mé lɔ̀ nòmò felè kwaré; bí bèlè sìè bú. À nde né lè gwà déì yilá ndeé. ");
INSERT INTO mcu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bí júée nùà gwà sâ a: Nùà fèh-njèh ye júée wò a: bɔ́ bɔ̀ mbɔ̀ŋ nyî Páskà yieé nde né te gwà dé heè wa? ");
INSERT INTO mcu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","À nde né bí gwà dé koô mân feh, né ké ter felè mbeî, bɔ́ nyegé gi aá bèh denè gwò kèn. Bí nyégé kwá yáb doó sâ.» ");
INSERT INTO mcu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bɔ́ sɔm gò, bɔ́ nde kwa gi ka dɔɔ́ŋ faá Yeésò la naâ bɔ́ tueé nɔ; bɔ́ nyegé kwaá baá-re yáb Páskà teèn. ");
INSERT INTO mcu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cu yeé wulu baá, bɔ́ bɔ̀ mbɔ̀ŋ tebê nde kaŋ yáb ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","À ye bɔ́ a: «Mè lé gwaán kelà naâ faá bèh mân, ye kɔ béh bí yieé bilí baá Páskà, te mè ŋene ye gèr. ");
INSERT INTO mcu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mè tueé bí: ndɔ́g, mè ndeè Páskà yíé ŋgwé ndé cú, kɔ kwɔ̀m seèn ndeè baá ké te *Lò Càŋe ŋagá yuo kelá, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jomo sâ à weh ŋgàb mbè ndɔ, à vra Càŋ teèn, ye bɔ́ a: «Bí wèh, bí ŋúé téná lètenè biì. ");
INSERT INTO mcu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mè tueé bí: gi aá hên, mè ndeè mbè déì ŋúé ŋgwé ndé cú, kɔ loù mé Lò Càŋ ndeè baá bèsɔ́nè ŋené ŋagá, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jomo sâ à weh breêd, à vra Càŋ teèn, à kɔlé haá bɔ́, ye bɔ́ a: «Hên né ŋgàŋ yoòr mò; mè haá kuú né felè biì. Bí bɔ́ dèn mân, bí né mè teèn munó.» ");
INSERT INTO mcu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mé ŋgàb mbè à bɔɔ́ cu jomo yâb sâ ménâ ndɔ, ye bɔ́ a: «Ŋgàb hên né ŋgɔ̀ŋ dé feê mé Càŋ kɔ né mé húɔ́m mò; ber kuú né felè biì. ");
INSERT INTO mcu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Bí kɔ́ɔ ye, nuaá mé nde né mè go sɔm né ká lètenè beèh, béh bɔ́ yáb yieé den né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Dé kuû, *Huaán Nùàr nde né faá Càŋ lé tueé naâ nɔ kuú. Njèh cén, nuaá mé yií keéh be teèn, jɔgɔ kwaá bú cie, nde né mé gèr mbiín kuú.» ");
INSERT INTO mcu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bɔ́ yeé ŋgweé aá ménâ, bɔ́ duɔɔ́m baá-re lètenè bɔɔ̀n bieé kuû, ye: «Ká lètenè beèh hên neì seèn ménâ bɔɔ́ nde né kɔɔ́ wa!» ");
INSERT INTO mcu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bɔ̀ mbɔ̀ŋ duɔɔ́m baá-re lètenè bɔɔ̀n saán deèn, te bɔ́ ŋene kɔ nuaá mé né dé koô teèn. ");
INSERT INTO mcu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeésò deên ndɔ, ye bɔ́ a: «Bɔ̀ mgbèémgbè mé tàbè hihiné né bɔ̀ nùàr lòù tuú. Bɔ̀ kokoô bɔ̀ teèn ye te bɔ̀ nùàr keí bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bí té dé biì ménâ bɔ́. Dé biì, nùà koô lètenè biì a: dèn sér faá huaán maàn nɔ; nuaá mé né toò bɔ̀ nùàr a, dèn sér nùà seê bɔɔ̀n ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hên, mɔ bɔ̀ nùàr né fà, déì né yáb den kela, déì né yáb geé, sâ nùà koô lètenè bɔɔ̀n né dé heè wa? Ŋgweéh nùà koô né dé mé den kela yeé lòù doô wa? Sâ, bí kè cú-re kán! Ká lètenè biì, mè né seér nùà seê kɔɔ́! ");
INSERT INTO mcu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Dé biì, gèr mé mè lé naâ ŋené dɔɔ́ŋ, bí lé mè mé huún sì lɔ́ ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mè bí kɔgɔ ké te *Lò Càŋe nyegé kwaá gi aá kèn. Né faá Tele mò lé naá giì mè nyegé kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ké te Lò mò sâ, béh bí nde né yieé, béh ŋueé bilí kɔɔ́. Bí nde né te kɔgɔ mgbè den, bí tueé ju felè gèh bɔ̀ huaán *Iserálà yulà cùɔ̀b fà doô.» ");
INSERT INTO mcu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeésò den cuù, ye Simɔ̂ŋ Piêr a: «Simɔ̂ŋ, Simɔ̂ŋ, ŋgwé nyégé bagasé: *Sátàn bie aá kèn, ye nyí nde né bí jilí. À ceéh nde né bí faá bɔ́ ceéh yeé ŋgwàgàm, te bɔ́ kobo sɔm tùlù teèn nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mè né Càŋ felè yeè dua, te ndèm yeè toò cùàrè kélá ndé cú; mɔ wò ŋa cu aá nùàr mò, te wò haá cu bɔ̀ mbaábi terreb.» ");
INSERT INTO mcu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piêr deên ndɔ, ye bú a: «Fehtoò mò, né mene gwà cibì, né mene cio, mè kuú nde né jomo yeè.» ");
INSERT INTO mcu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","À yeé tueé gi aá ménâ, Yeésò ye bú a: «Mè jue né wò Piêr, lan kwaá túágá ndé ŋgwéh, sâ wò yaáŋ aá njó baá mbei tagár, ye nyí mè kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yeésò den cuù, ye bɔ́ a: «Mè lé naâ bí cu déì ké cie be-be temá njií, kàgàlɔ̀ŋ sam, ba sam, débágá sam ndɔ. Mé njéh mene, njeré déì lé naâ bí toò saám wa?» Bɔ́ ye bú a: «Njeré déì lé béh sám ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","À ye bɔ́ a: «Dé kènê môn sam nde cuú: nuaá né mé kàgàlɔ̀ŋ, bú a, wèh sìè beè; nuaá né mé ba, bú a, wèh sìè beè ndɔ; nuaá mé njèh salê sam, bú a, gò sɔ̀m cɔ̀gɔ̀ seèn déì, à ŋge sie bòù beè. ");
INSERT INTO mcu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mè tueé bí, kɔ mboón yuo kelà felè mò faá bɔ́ lé naâ te mvù Càŋe nyagá kwaá nɔ, ye: Bɔ́ kulá yií keéh aá bú yí lètenè bɔ̀ vevenê bɔ̀ teèn. Bí kɔ́ɔ ye, bɔ̀ njií mé bɔ́ lé naá giì felè mò nyagá kwaá dɔɔ́ŋ nde ye aá mboón.» ");
INSERT INTO mcu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bɔ̀ mbɔ̀ŋ ye bú a: «Bòù fà né béh beè teèn, hên nɔ.» À ye bɔ́ a: «Wulu baá kèn.» ");
INSERT INTO mcu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeésò yeé yuo kelà baá, à ŋaá nde cu ké te tòr Oliviê faá bèh jomò nɔ. Bɔ̀ mbɔ̀ŋ seèn ŋaá bele bú ké teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","À yeé baá ké teèn, ye bɔ̀ mbɔ̀ŋ a: «Bí dùà dèn Càŋ duaà, te *Sátàn bí mé veên táb sìè cú.» ");
INSERT INTO mcu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","À yeé tueé gi aá ménâ, à kwaá lɔ bɔ́ ndɔ, à nde ser ké toò bɔɔ̀n bèh ndɔ́ŋ-ndɔ̀ŋ mân. Wa ké teèn, à cemmé nde doó, à né Càŋ dua, ");
INSERT INTO mcu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ye bú a: «Tele mò, mɔ wò né gwaán, ŋgòrò sɔ̀m yeè mè ŋgàb gèr hên kwarè teèn. Mè né mene ménâ gwaán, bɔ́ sér faá wò né gwaán nɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","À yeé dua gi aá ménâ, cìlì Càŋ déì suagà ké te vulúu, ŋené yuo kelà toò seèn, bɔɔ́ taré bú yo. ");
INSERT INTO mcu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","À cer ŋeí cu seé dé ceèr. À né Càŋ dua njegé, lemè keér bú yoòr, né doó faá húɔ́m nɔ diené ndeé den. ");
INSERT INTO mcu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","À yeé dua gi aá, à komo wuo ter ndɔ, à cu cuù ká jomo yoòr bɔ̀ mbɔ̀ŋ. À waà, sâ bɔ́ homo baá mé kú, bɔ́ baá gi lɔ́m. ");
INSERT INTO mcu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ye bɔ́ a: «Bí lɔ́m ménâ cer né dé keì wa? Bí wùò dèn làŋ, bí né Càŋ dua, te Sátàn bí mé veên táb sìè cú.» ");
INSERT INTO mcu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","À yeé baá bɔ́ mân tueé den, bɔ̀ nùàr kókoó mbaá kem waà ndɔ. Ké toò bɔɔ̀n lé naâ Júdàs, mbɔ̀ŋ cén déì lètenè bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô. À yeé waà baá, à kela nde yí toò Yeésò, te à vra kumó sie bú. ");
INSERT INTO mcu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yeésò ye bú a: «Júdàs, wò bie feh seér cu aá Huaán Nùàr mé bɔ̀ nùàr lòù wa?» ");
INSERT INTO mcu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bɔ̀ɔ́ mé naâ jomo Yeésò yeé ŋene, ye njeré déì nde né bɔɔ́, bɔ́ ye Yeésò a: «Fehtoò beèh, béh kɔ̀rè mé bòù wa?» ");
INSERT INTO mcu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yeésò nde sòn komo, sâ cén déì lètenè bɔɔ̀n bòù ter sɔm aá, mvur tena si njií nuaré déì tie gaâ doó; lé naâ tie nùà seê *ŋgàŋ sèmè dé koô. ");
INSERT INTO mcu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yeésò yiín bɔ́ ndɔ, ye bɔ́ a: «Bí gè mé ceér sâ!» À kema njií nùà hèllè be tieè, tie seèn taré yuo cu. ");
INSERT INTO mcu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jomo sâ Yeésò tueé njií mé bɔ̀ ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ gó gwà Càŋ bɔ̀ mé bɔ̀ kokoô bɔ̀ dé lɔɔ̂. Sâ bɔ́ lé nde giì naâ yoòr seèn te bɔ́ sie bú; ye bɔ́ a: «Den né faá bí mé bɔ̀ bòù mé cùgò beè-beè hên kem nde giì né yoòr nùà yîb nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sâ, cieé dɔɔ́ŋ béh bí ké gwà Càŋ né yeé kɔɔ́ ndɔ. Cu sâ bí lé mè be yoòr njí ná ŋgwêh dé keì wa? Bí kɔ́ɔ ye: kɔ cibí baá mé terreb mân te bí nde ye mân bɔɔ́. Sâ hên baá cu biì sâ.» ");
INSERT INTO mcu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bɔ́ sie Yeésò ndɔ. Bɔ́ sie njií bú ké lɔ *ŋgàŋ sèmè dé koô. ");
INSERT INTO mcu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Piêr né bɔ́ jojomo ké bèh ndɔ́ŋ-ndɔ̀ŋ naáb bele. À wa, sâ bɔ́ fu kwaá baá we yí lètenè caâ, bɔ́ né ŋuagá den. À kela nde yí teèn ndɔ, à den nde doó kwarè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nùà seê dé veèh déì ŋene kɔ bú, à né ka bú yí kwarè weè sâ ke njege den. Jomo sâ, ye bɔ̀ nùàr a: «Hên né nùàr seèn déì!» ");
INSERT INTO mcu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piêr cam, ye ma doô a: «Njó mò, mè bú kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Den ser, nuaré déì wa cuù, ŋene njií bú, ye bú a: «Wò né yeé lètenè bɔɔ̀n ndɔ!» Piêr cam cu, ye bú a: «Nùàr mò, mè sam.» ");
INSERT INTO mcu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nde nde, lou kela sa gùm lɔ̀ŋ déì, nuaré déì waà, tueé ŋeí cu ye baá-re dé seèn mé terreb, ye bɔ́ a: «Mé gècên mene, nùà hên né nùà Galilê, bɔ́ bú né yeé kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piêr cam cu, ye bú a: «Nùàr mò, mè dé sònò yeè sâ ŋgwé kɔ́ ŋgwéh lág.» À yeé baá ménâ tueé den, kwaá tuaga lɔ bú mé njéh sònò. ");
INSERT INTO mcu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Cu sâ, Fehtoò beèh bele seér ndɔ, ke njií Piêr, bɔ́ bú ke kwaré. Piêr munó ko cu baá-re dé mé Fehtoò beèh la tueé naâ ye bú a: «Lan mé kwaá sé nde tuagá wa, sâ wò yaáŋ aá njó baá mbei tagár, ye nyí mè kɔ́ ŋgwéh ma.» ");
INSERT INTO mcu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piêr yeé munó ko aá ménâ, à jeré yuo doó sâ, à nde yúé njegér. ");
INSERT INTO mcu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɔ̀ɔ́ mé né Yeésò mɔɔ́m, né bú teèn selé yií, bɔ́ né bú lobó ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bɔ́ vuɔb bú njolo, bɔ́ ye bú a: «Ŋéné kɔ́ cú-re ŋenè, jɔ̀gɔ̀ túé ke nuaá mé né wò lobo hên ye.» ");
INSERT INTO mcu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bɔ́ né bú gbêg hihiné kókoó mbaá haá den. ");
INSERT INTO mcu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cieé yeé ŋaga baá, bɔ̀ kokoô bɔ̀ dé lɔɔ̂ mé bɔ̀ ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ *njí-sóù nde bilí den gi ké te *mbàgà juù. Bɔ́ ye: wèh ndê mé Yeésò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","À yeé waà baá, bɔ́ ye bú a: «*Nùà Cɔ̀ŋ né wò wa? Túé béh tueè.» Yeésò ye bɔ́ a: «Mè tueé kuú mene ménâ, bí biì temé teèn kwá njí ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mè bie mene bí njeré déì, bí biì sòn kòmò ndé ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Duɔɔ̂m lan *Huaán Nùàr nde aá ké te be gaâ Càŋ terrèb den ndeé.» ");
INSERT INTO mcu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bɔ́ deên dɔɔ́ŋ ndɔ, ye bú a: «Á sâ, Ŋunà Càŋ né ka wò mà.» Ye bɔ́ a: «Bí tueé né tueè, né mè.» ");
INSERT INTO mcu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bɔ́ deên baá-re ye: «Béh ŋgweé gi aá sònò seèn mé tie beèh kèn. Béh sònò bɔ̀ nùàr bie sɔɔ́ cu nde né kei?» ");
INSERT INTO mcu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dàm bɔ̀ nùàr dɔɔ́ŋ kem wuo ter ndɔ, bɔ́ weh nde mé Yeésò ké toò Pilátò. ");
INSERT INTO mcu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wa ké teèn, bɔ́ né bú nyeén yoòr cɔré su, bɔ́ ye Pilátò a: «Béh nde kwaá naâ nùà hên, sâ à né tàbè beèh soób, ye bɔ̀ nùàr a, té làmpɔ̂ŋ mgbè Rɔ̂m gwɔ̀m; ye nyí né cu *Kristò, wa nyí né mgbè mé feh nyî sé wa.» ");
INSERT INTO mcu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilátò bie njií ndɔ, ye Yeésò a: «Mgbè bɔ̀ Jûf né wò wa?» Yeésò ye bú a: «Wò dé sâ tueé né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilátò ye bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ nùàr a: «Mè bèh saâb nùà hên ŋéné ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bɔ̀ nùàr né mene dé sâ ŋgweé, bɔ́ né lom teèn tétég ŋeí seér, ye Pilátò a: «À né yeé bɔ̀ nùàr te tàbè beèh dɔɔ́ŋ soób; à lé bɔ́ feh duɔɔ́m naâ ké Galilê, à ndeè ká te tàbè Judê, à feh cu bɔ́ ménâ. Hên, à mé njéh waà baá kán.» ");
INSERT INTO mcu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilátò yeé ŋgweé aá mân, à bie cu bɔ́ ndɔ, ye bɔ́ a: «Nùà hên né nùà Galilê wa?» ");
INSERT INTO mcu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","À yeé ŋgweé aá ye Yeésò yuoó naâ lè tàbè mgbè Herôde mân, ye bɔ́ wèh njí bú ké toò Herôde ma. Bɔ́ weh njií bú ndɔ. Sâ, Herôde né loù sâ ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","À lé naâ ŋgɔ́g Yeésò ŋgweé, à né yeé ceér fɔɔ́n, dàb baá teèn, ye te nyí ŋene ŋgweé bú, nyí ŋene ŋgweé fém seèn cén déì ndɔ. À yeé ŋene aá bú ménâ, yo taré bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","À duɔɔ́m baá-re Yeésò bɔ̀ njèh ŋgún bieé beleè. Ndɔ́g, Yeésò bú sòn kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sâ bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ *njí-sóù né gi doó, bɔ́ né lom Yeésò nyeén yoòr cɔré su. ");
INSERT INTO mcu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herôde bɔ́ bɔ̀ sɔ́jì seèn né bú yoòr mé séb kem sue ndɔ, bɔ́ né bú seb, bɔ́ su kwaá bú cɔ̀gɔ̀ nyàgàm déì yoòr, bɔ́ weh cu cu mé bú ké yoòr Pilátò. ");
INSERT INTO mcu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sâ né loù mé Herôde bɔ̂ Pilátò lé naâ mé sòn cên den cuú. Lòù sam, kèrrè lé naâ lètenè bɔɔ̀n teèn. ");
INSERT INTO mcu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yeésò yeé baá cu ké toò Pilátò, Pilátò yilá bilí gi bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ kokoô bɔ̀ dé lɔɔ̂ mé bɔ̀ nùàr mene, ");
INSERT INTO mcu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ye bɔ́ a: «Bí la weh waà naâ mé nùà hên, ye mè a, à né yeé bɔ̀ nùàr soób sé wa! Hên, mè bú njèh dɔɔ́ŋ bie den né toò biì. Mè faá bí tueé nê nɔ ŋéné ŋgwéh. Beè mò nùà hên bèh njèh kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ké beè Herôde né cu ka mân ndɔ; à bú ká jomo yoòr beèh haá njií cuù né dé cî. Mè tueé bí, nùà hên te njií mé bɔ́ wula nde né bú teèn sáb yílá ŋgwéh gùm dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mɔ né mân, mè bɔɔ́ nde né, bɔ́ lobo cegé bú lòù, mè yi njií cu bú.»  ");
INSERT INTO mcu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sâ lè tòù bɔ̀ *Jûf, mɔ *Páskà waà baá dɔɔ́ŋ, kɔ Pilátò sɔm keéh nùà gwà cibì déì, à yi njií bú toò bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Yeé baá mân, bɔ̀ nùàr tueé keéŋ njií ké ter dɔɔ́ŋ ye bú a: «Bɔ́ wúlá sér nùà hên, wò yi njií béh Barabâs.» ");
INSERT INTO mcu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Sâ, cu déì Barabâs hèllè lé naâ bɔ̀ nùàr soób; bèmè lé naâ lɔɔ́ dɔɔ́ŋ die. Bɔ́ lé naâ bú gwà cibì teèn sie yií, bilí cu bú mé ju wúlá-nùàr mene ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bɔ̀ nùàr yeé baá tueé ye Pilátò a, yì njí Barabâs mân, Pilátò tueé njií cu mé bɔ́, sâ ye te nyí yi njií Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bɔ̀ nùàr kɔ lom né ké ter lɔgɔ́ njiî, ye bú a: «Fágá wúlá lòm bú fagà! Fágá wúlá lòm bú fagà!» ");
INSERT INTO mcu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilátò den cuù dé mbelèm tagâr, ye bɔ́ a: «À veên bɔɔ́ naâ kei wa? Mè dé mò veên mé bɔ́ nde né bú teèn wulá yoòr seèn kwà nyì ŋgwéh. Mè bɔɔ́ nde né bɔ́ lobo cegé bú lòù, mè yi njií bú.» ");
INSERT INTO mcu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bɔ́ yeé nde ŋgweé cu ménâ, bɔ́ lɔgɔ́ ŋeí njií ye baá-re ké ter mé terreb, ye bú a: «Fágá wúlá njí lòm bú dé fagâ.» Hueh bɔɔ̀n yieé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilátò ye bɔ́ a: nyí gwaán aá te sòn bɔɔ̀n ma. ");
INSERT INTO mcu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","À yi njií seér bɔ́ nùà veên doô. Sâ nùà hèllè lé bɔ̀ nùàr soób naâ kɔɔ́, bèmè lé dieé naâ mé bú, bɔ́ lé naâ bú gwà cibì teèn sie yií, bilí cu bú mé ju wúlá nùàr mene ndɔ. Pilátò yeé yi njií seér aá bú ménâ, à haá seér bɔ́ Yeésò ndɔ, ye bɔ́ ndé bɔ́ bá-re mé bú faá bɔ́ gwaán né sâ nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bɔ́ yeé baá mé Yeésò weh ndeé, bɔ́ bɔ̀ nùà Sirên déì kwaré, yilí seèn né Simɔ̂ŋ. Sâ à naâ ŋueh. Bɔ́ sie ba haá bú toú mé bɔ́ nde né Yeésò teèn fagá doô, à jɔgɔ bele Yeésò mé njéh jomo. ");
INSERT INTO mcu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bɔ̀ nùàr kókoó mbaá né bɔ́ jomo kem bele ndɔ. Bɔ̀ véh né felè Yeésò yueé ŋaáŋ. ");
INSERT INTO mcu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeésò bele seér ndɔ, ke njií bɔ̀ véh doô, ye bɔ́ a: «Véh Jerusalem bɔ̀, bí té dé mò yúé; bí yúé sér dé biì mé dé bɔ̀ ŋuna biì. ");
INSERT INTO mcu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Loù mé ndeè jueè né jueè, bɔ́ tueé nde né ye: Njua bɔ̀ ŋgiín bɔ̀ wa! Njua bɔ̀ véh mé huaán ŋàr ŋgwéh wa! Njua mé mbán ŋgiîn ndɔ wa! ");
INSERT INTO mcu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sâ né loù mé bɔ̀ nùàr tueé nde né teèn, ye bɔ̀ tòr a: Ndê ŋèm sùè kɔ́ béh yoòr; ye bɔ̀ tòr déì a: Ndê sùrì kéh béh dòù ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","À den cuù, ye bɔ́ a: «Mɔ we né yoòr toû ŋgie mân, sâ mɔ né yoòr jaâr nɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bɔ́ weh sie bɔ̀ vevenê bɔ̀ déì beè fà ndɔ, te bɔ́ nde faga njií bɔ́ ké kwarè Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wa beré déì, bɔ́ bèh sâ yilá né: Gebá feèh. Bɔ́ faga njií Yeésò ter; bɔ́ faga njií bɔ̀ vevenê bɔ̀ hèllè ter ménâ ndɔ, nùà kàn mé toú seèn, déì te be gaâ Yeésò, déì te be ŋgoù seèn. ");
INSERT INTO mcu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeésò deên ndɔ, ye Tele a: «Tele mò, kúlú njí veên bɔ̀ nùàr hên doó. Njií mé bɔ́ né bɔɔ́, bɔ́ kɔ́ ŋgwéh.» Jomo sâ bɔ̀ sɔ́jì vu geé weh bɔ̀ cɔ̀gɔ̀ seèn mé bèì lètenè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bɔ̀ nùàr kókoó mbaá né bú bilí ke den. Bɔ̀ kokoô bɔ̀ lɔ sâ né bú gbêg haá, bɔ́ ye: «À kɔ cegé né bɔ̀ nùàr yili sɔɔ̀m; mɔ à né ka Nùà Cɔ̀ŋ mé Càŋ balé njií naâ kɔɔ́ sâ, bú a: jɔ̀gɔ̀ yili yuo ke mé be seèn ye.» ");
INSERT INTO mcu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bɔ̀ sɔ́jì né bú teèn ménâ selé yií ndɔ, bɔ́ njebá nde yí ka seèn, bɔ́ tiím haá njií bú mbè déì tanésé mân, ");
INSERT INTO mcu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bɔ́ ye bú a: «Jɔ̀gɔ̀ yili yuo ke mé be yeè, mɔ wò né ka Mgbè bɔ̀ Jûf sâ bɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bɔ́ nyagá faga kwaá njeré déì ké ter felè seèn ye: «Nùà hên né Mgbè bɔ̀ Jûf.» ");
INSERT INTO mcu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nùà cén déì lètenè bɔ̀ vevenê bɔ̀ yí ter doô kuú ka dé seèn mé gbêg sònò ménâ ndɔ, ye Yeésò a: «Wò ye *Nùà Cɔ̀ŋ né nyí sé wa? Yìlì yùò-re yilì, wò yili sɔm keéh béh teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mbeí deên kèb déì, nde njií bú ndɔ, ye bú a: «Wò né taré lè gèr-e ménâ, wò Càŋ dùlà ŋgwéh wee? ");
INSERT INTO mcu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dé beèh bélɔ̀, yila né teèn, béh naâ veên bɔɔ́, béh gèr ŋene né sòn sâ. Dé nùà hên ménâ sam, à njeré déì bɔ́ ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jomo sâ, à tueé njií mé Yeésò ndɔ, ye bú a: «Yeésò, mɔ wò ndeè waà baá bèh mgbè ceèr, wò mùnò kéh yeè mè teèn.» ");
INSERT INTO mcu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeésò ye bú a: «Mè né tueé ye wò a, lan lan bélɔ̀ ŋaá wa nde né ké mbar Càŋ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Lou yeé dilí baá, lou cib cu. Cibí yili laré cu ká doó dɔɔ́ŋ, yili sɔɔ́ gùm yɔ̀ŋ loù tagâr. Yeé baá mé lou lɔ̀ŋ tagár, cɔ̀gɔ̀ gwà Càŋ dé koô keér geé lèbɔ̂lé. Cɔ̀gɔ̀ sâ lé naâ kɔ̀ŋ mé cií leér yeé mɔ̀ gwà Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeésò lɔgɔ njií ké ter ndɔ, ye: «Tele mò, mè yɔ̀ŋ mò kwaá lɔ aá beè yeè.» À yeé tueé aá ménâ, à kuú yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sâ kwaá-taâb bɔ̀ Rɔ̂m bɔ̀ déì lé naâ doó. À yeé ŋene aá ménâ, à seén Càŋ, ye: «Mé gècên mene, nùà hên kuú né mé sòn fuû.» ");
INSERT INTO mcu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bɔ̀ɔ́ mé lé kem ndeè naâ bɔ̀ njií hên ke weh dɔɔ́ŋ lé naá giì ŋené. Yeé gi aá, bɔ́ jomo vuaga cu cu mé kú. ");
INSERT INTO mcu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bɔ̀ mbeí Yeésò né dé bɔɔ̀n ké bèh ndɔ́ŋ-ndɔ̀ŋ njebá ke den. Bɔ̀ véh mé lé yuoó naâ Galilê, bɔ́ né jomo Yeésò bele doô, bɔ́ bɔ́ lé naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nuaré déì lé naâ teèn, yilí seèn né Josêf, né nùà Arimatê, lɔɔ́ déì lè tàbè bɔ̀ *Jûf mân. Nùà sâ né yeé nùà gècên, nùà húɔ́m-temê ndɔ. Né nùà koô déì te *mbàgà juù. ");
INSERT INTO mcu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Njií mé bɔ̀ déì lé taáŋ naâ felè Yeésò dɔɔ́ŋ, à lé be teèn yí ná ŋgwêh. À dé seèn njolo ke lom né mé *Lò Càŋ. ");
INSERT INTO mcu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yeé baá ménâ, à nde ké yoòr *Pilátò komó Yeésò dua. Pilátò yeé gwaán aá, ");
INSERT INTO mcu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","à nde mvualé weh, à vuɔb nyegé mé cɔ̀gɔ̀ nyɔ́gɔ̀r. Sâ sà déì feésé mân lé naâ doó, bɔ́ kwe né lè gbàŋ kweêh mân, bɔ́ lé née nuaré déì teèn fùrù ŋgwéeh ye. Bɔ́ nde teèn jɔgɔ yií lɔgɔ́ baá-re Yeésò. ");
INSERT INTO mcu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lé naâ loù nàŋ cieé koô bɔ̀ Jûf mân. Sâ cieé koô hèllè nde aá liyilì sâ duɔɔ́m ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bɔ̀ véh Galilê mé lé naâ jomo Yeésò doô yeé ŋene aá ménâ, bɔ́ yuo bele Josêf, bɔ́ ŋene sà, bɔ́ ŋene gèh dé mé bɔ́ né komó Yeésò teèn yií njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bɔ́ cu cuù, bɔ́ ne kwaá gi bɔ̀ kómó wá-yoòr mé kómó múmû, te bɔ́ nde komó Yeésò mé njéh waá. Yeé baá mé cieé koô sâ, bɔ́ jolo sɔɔ́ mé cieé koô faá *sóú tueé nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yeé baá loù sɔ́ndè toò cieê, bɔ̀ véh doô komo nde ké te sàa, mé bɔ̀ kómó múmû doô beè. ");
INSERT INTO mcu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bɔ́ wa ké teèn, taá baá ké jomo komo den, sà baá lɔŋ. ");
INSERT INTO mcu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bɔ́ yila nde gè dòù, bɔ́ komó Fehtoò beèh Yeésò teèn kwà cú. ");
INSERT INTO mcu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bɔ́ yeé baá-re munó den mân, bɔ́ ke, bɔ̀ nuaré déì fà kar yuo kelà baá yí toò bɔɔ̀n mé cɔ̀gɔ̀ wuwulê mân yoòr. ");
INSERT INTO mcu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Veéh bɔɔ́ bɔ́ njèh, bɔ́ sulí njií njolo doó. Bɔ̀ nùà fà doô ye bɔ́ a: «Bí nùà làŋ ká lètenè bɔ̀ komô fɔɔ́n né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","À doó hên sam cuú; à baá cu mé njolo. Bí mùnò kò cú dé mé à lé tueé naâ bí ké Galilê doô; ");
INSERT INTO mcu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","à lé ye: kɔ bɔ́ *Huaán Nùàr go haá njií mé bɔ̀ vevenê bɔ̀, te bɔ́ faga wula bú. Mɔ baá cieé tagár, à komo yuo cu lè cio.» ");
INSERT INTO mcu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bɔ́ munó ko cu baá-re dé mé Yeésò lé naâ bɔ́ tueé sâ. ");
INSERT INTO mcu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bɔ́ fɔɔ́n gò, bɔ́ nde bɔ̀ mbɔ̀ŋ dé yulà cùɔ̀b cên mé bɔ̀ nuaré déì ménâ tueé bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lé naâ Marî Magdalâ, mé Jâne, bɔ̂ Marî meì Jâk mé bɔ̀ véh déì. ");
INSERT INTO mcu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bɔ́ yeé baá bɔ̀ mbɔ̀ŋ tebê ménâ tueé, bɔ̀ mbɔ̀ŋ doô ke njií faá né ŋgòr kùlù nɔ, bɔ́ temé teèn kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piêr komo wuo dé seèn ter, à dula nde ké te sàa; à wa, à gimé ke njií gè dòù, à ŋene le mé bɔ̀ cɔ̀gɔ̀ mé lé naâ yoòr komô doô. À cu cu ké lɔ; bɔ̀ njií sâ dɔɔ́ŋ geí lɔ lom bú mbaá. ");
INSERT INTO mcu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka loù cên sâ, bɔ̀ mbɔ̀ŋ fà déì baá lè lɔɔ́ déì ndeé; yilí lɔɔ́ sâ né Emayûs, à né kwarè Jerusalem, njèh kílòmétà yulà cùɔ̀b cén mân. ");
INSERT INTO mcu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bɔ́ né felè bɔ̀ njií mé lé naâ kelá dɔɔ́ŋ tueé den. ");
INSERT INTO mcu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bɔ́ né ka tueé ndeé, bɔ́ né teèn saán yií ndɔ. Wa beré déì, Yeésò yila kwa bɔ́, bɔ́ bɔ́ né bècénè gɔ ndeé. ");
INSERT INTO mcu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Njèh cén, bɔ́ bú ŋéné kɔ́ cú, njeré déì lé naâ bɔ́ yiín. ");
INSERT INTO mcu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeésò bie njií bɔ́ ndɔ, ye bɔ́ a: «Bí ceceér saán gɔ né kei wa?» Bɔ́ njebá ke mierré njií gi bú fà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yilí déì lé naâ Kelopâs, à tueé njií mé Yeésò, ye bú a: «Wò né gèh nùà Jerusalem dé heè, mé à dé seèn kèkènè njií mé lé kelà naâ cieé fà hên kɔ́ ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ye bɔ́ a: «Lé naâ caâ gèh dé heè wa?» Bɔ́ ye bú a: «Béh jue né bɔ̀ njií mé lé kwaá naâ Yeésò nùà Najarêt doô. À lé naâ *sòn-Càŋ; à lé naâ mé terreb te seê teèn, te ŋgòr-e ménâ ndɔ. À lé naâ nùà tarê beè Càŋ, mé beè bɔ̀ nùàr mene. ");
INSERT INTO mcu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ beèh lé naâ bɔɔ́ te bɔ́ tena ju felè seèn, bɔ́ faga njií bú ter te toû, à kuú. ");
INSERT INTO mcu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sâ béh lé baá giì ndèm kwaá, ye à bɔ̀ huaán *Iserálà yili sɔm nde aá kɔɔ́. Sâ kè cú-re, bɔ̀ njèh sâ dɔɔ́ŋ bɔɔ́ baá lan baá cieé tagár. ");
INSERT INTO mcu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mé njéh mene, né béh mbaá hiím yɔgɔ́: bɔ̀ véh déì lètenè beèh naâ lan komo yuo, bɔ́ nde ké te sàa, ");
INSERT INTO mcu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bɔ́ wa, bɔ́ komó seèn ké teèn kwà cú. Bɔ́ cu cuù, bɔ́ ye béh a: bɔ̀ cìlì Càŋ déì naâ toò bɔɔ̀n ŋené yuo kelá, ye bɔ́ a: à baá cu làŋ ma. ");
INSERT INTO mcu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bɔ̀ mbeí beèh déì nde cu ké te sàa ménâ ndɔ, bɔ́ wa, dɔɔ́ŋ né gi ka faá bɔ̀ véh doô la naâ béh tueé nɔ, bɔ́ bú dé seèn kwà cú.» ");
INSERT INTO mcu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Te Yeésò deên baá-re ndɔ, ye bɔ́ a: «Bí mé feh felè sam. Bɔ̀ njií mé bɔ̀ sòn-Càŋ bɔ̀ lé tueé belé naâ dɔɔ́ŋ, bí ŋgweé faŋ njií den né lòù, ");
INSERT INTO mcu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","wanɔɔ́ŋ lé túé ná ŋgwêh ye kɔ *Nùà Cɔ̀ŋ ŋene gèr mân, te jomo sâ à lie ye wa?» ");
INSERT INTO mcu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","À yeé tueé gi aá ménâ, à se nyegé gi bɔ́ bɔ̀ njií mé bɔ́ lé naâ felè seèn nyagá kwaá dɔɔ́ŋ. À duɔɔ́m weêh ké jomo lè mvù Músì, à nde yuo kela mé njéh lè mvù bɔ̀ sòn-Càŋ bɔ̀ dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bɔ́ yeé nde aá lɔ waá, Yeésò bɔɔ́ faá à nde né dé seèn kelá sa nɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bɔ́ sie lɔ bú mé sòn ye bú a: «Lou yila baá, cibí nde aá yilí; kwá béh bí cer le.» Bɔ́ bɔ́ yila nde gwò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bɔ́ yeé kaŋ aá yáb, à weh breêd, à vra Càŋ teèn, à kɔlé haá njií bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Njolo ŋagá bɔ́, bɔ́ ŋene kɔ cu bú. À nyue leér yuo toò bɔɔ̀n doó sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Déì ye mbeí a: «Jɔ̀gɔ̀ mé à la naâ ké ceér dueè tueé, à né béh ŋgòr Càŋ se komo, ŋgweéh la naâ béh te temé njerré yilá wa?» ");
INSERT INTO mcu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bɔ́ cu ka ter komo wuoò, bɔ́ cu cu ké Jerusalem, bɔ́ wa, sâ bɔ̀ mbɔ̀ŋ yulà cùɔ̀b cén doô bɔ́ bɔ̀ mbeí déì né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bɔ́ né sònò tueé den ye: «Fehtoò beèh komo yuo aá bɔ̀n. Simɔ̂ŋ naâ bú ŋené.» ");
INSERT INTO mcu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bɔ̀ fà bɔ̀ doô tueé yií cu bɔ́ teèn ndɔ, bɔ́ tueé bɔ́ gèh dé mé la naâ ké ceér dueè kelá; bɔ́ tueé cu bɔ́ gèh dé mé à la naâ breêd kɔlé, mé bɔ́ ŋene kɔ bú mé njéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bɔ́ née sònò mân tueé den, sâ Yeésò mé feh seèn baá cu lètenè bɔɔ̀n ndɔ, à bie njií bɔ́, ye bɔ́ a: «Dɔlê a, dèn mé bí.» ");
INSERT INTO mcu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Veéh sie bɔ́, hèhèm sie bɔ́ ndɔ. Bɔ́ ye merré déì né càŋ tándulu. ");
INSERT INTO mcu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yeésò ye bɔ́ a: «Feh ŋellé né bí ter mé ŋgei wa? Bí lè biì saán den né kei ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bí jɔ̀gɔ̀ kè njí ke bɔ̀ be mé gule mò kán ye, né ka mè! Bí jɔ̀gɔ̀ kema ke ke ye; tándulu né yeé mé kuú bɔ̂ njeba yoòr faá ká yoòr mò hên wa?» ");
INSERT INTO mcu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","À né sònò ménâ tueé, à né bɔ́ be mé gule feh keéh bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bɔ́ yeé ŋene aá ménâ, vɔ́gɔ́-temé hiím yɔgɔ́ bɔ́ dé tueê, hiím yɔgɔ́ bɔ́ dé temé teèn kwaá njiî ndɔ. À deên baá-re ye bɔ́ a: «Bí né mé njèh yâb teèn wa?» ");
INSERT INTO mcu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bɔ́ weh haá bú ten ŋgò keê. ");
INSERT INTO mcu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","À yieé njolò bɔɔ̀n ndɔ. ");
INSERT INTO mcu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jomo sâ, ye bɔ́ a: «Hên baá njií mé mè lé naâ bí tueé sâ, lé naâ sâ béh bí née kɔɔ́ ye. Mè lé ye bí a: bɔ̀ njií mé bɔ́ lé naá giì felè mò nyagá kwaá dɔɔ́ŋ nde gi né ménâ bɔɔ́ ma. Né mene lè *sóú Músì, né mene lè mvù bɔ̀ sòn-Càŋ bɔ̀, né mene lè mvù benê *Davîd dɔɔ́ŋ, mè lé ye bí a, kɔ bɔɔ́ gi ménâ. Hên baá cí.» ");
INSERT INTO mcu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","À ndoón cu bɔ́ feh ndɔ, te bɔ́ nde ye bɔ̀ njií mé bɔ́ nyagá né sâ ŋgweé komo, ");
INSERT INTO mcu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ye bɔ́ a: «Hên baá dé mé bɔ́ lé naâ nyagá kwaá, ye: *Nùà Cɔ̀ŋ nde né gèr ŋené; wa lè cieé tagâr, à nde cu né lè cio komo yuo. ");
INSERT INTO mcu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wa nùàr nde né mé yilí seèn lò nùàr dɔɔ́ŋ se ndeé, ye bɔ̀ nùàr a: Bí kwéh sér temé biì, te Càŋ kulu sɔm bí veên yoòr. Wa jɔ̀gɔ̀ duɔɔ́m nde née ká Jerusalem ye ma. ");
INSERT INTO mcu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sòn mò ké teèn né bí. ");
INSERT INTO mcu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Terreb mé Tele mò lé naâ tueé kwaá sâ, mè ndeè né bí temá njií. Bí jɔ̀gɔ̀ bílí dèn ká lɔ ye, kɔ bí ndeè kwa baá terreb mé suagaà nde né ké te vulúu sâ, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jomo sâ, Yeésò weh nde mé bɔ́ ké jomo lɔɔ̂, lé naâ kèb Betanî. Wa ké teèn, à sɔm njií be ter, à kulu bɔ́. ");
INSERT INTO mcu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","À né bɔ́ kulú, à né ké te vulúu nyueé ŋaá ndeé. ");
INSERT INTO mcu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sâ bɔ́ né doó cemmé den, bɔ́ né bú keí. Jomo sâ bɔ́ cu cu ké Jerusalem mé vɔ́gɔ́-temé mene. ");
INSERT INTO mcu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cu dɔɔ́ŋ bɔ́ né ké *gwà Càŋ koô bilí ndeé, bɔ́ né Càŋ teèn seén den.");
INSERT INTO mcu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Càŋ lɔ ndeè wɔ́ŋ si, sâ Ŋgòr baá gi teèn; Ŋgòr bɔ̂ Càŋ lɔ naâ kɔɔ́, Ŋgòr lɔ naâ Càŋ nùà njèh. ");
INSERT INTO mcu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sâ tueé né ye Càŋ bɔ̂ Ŋgòr lɔ naâ ké bèh duɔɔ̂m kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Càŋ lɔ njèh dɔɔ́ŋ si giì naâ mé Ŋgòr; njií mé lɔ dieé naâ mbaá, mé Ŋgòr kɔɔ́ sì ŋgwéh, lɔ teèn ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te njolo Ŋgòr lɔ naâ yɔ̀ŋ. Ŋagâ lètenè bɔ̀ nùàr lɔ naâ yɔ̀ŋ sâ. ");
INSERT INTO mcu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ŋagâ doô né te cibi baá den, mé njéh mene cibi bú nyímé kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yeé baá ménâ, Càŋ tema njiî sòn seèn déì ká teèn, yilí seèn lé naâ Jâŋ, ");
INSERT INTO mcu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","te à ndeè bɔ̀ nùàr Ŋagâ sâ se, bɔ́ kwaá njií ye temé teèn. ");
INSERT INTO mcu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","À lé Ŋagâ sâ kɔɔ́ ná ŋgwêh, à lé tueé ŋagá loóm naâ felè seèn lòù. ");
INSERT INTO mcu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ŋgòr sâ lɔ naâ jéjég Ŋagâ kɔɔ́, à lé ká te wɔ́ŋe ndeè naâ felè bɔ̀ nùàr dɔɔ́ŋ baá ŋagá. ");
INSERT INTO mcu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","À lé naâ ká lè wɔ́ŋe; Càŋ lɔ wɔ́ŋ dɔɔ́ŋ si giì naâ mé bú. Mé njéh mene wɔ́ŋ bú ŋéné kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","À waà mene ká te tàbè seèn yoòr bɔ̀ dé seèn, mé njéh mene bɔ̀ dé seèn hèllè berɔ́ŋ seér cu bú lòù. ");
INSERT INTO mcu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bɔ̀ cécéné bɔ̀ lé bú gwaán cegé naâ kɔɔ́, bɔ́ kwaá njií temé yoòr seèn. À lé naâ bɔ̀ sâ bɔ̀ terreb haá, te bɔ́ ŋa dé bɔɔ̀n bɔ̀ ŋunà Càŋ. ");
INSERT INTO mcu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bɔ́ bɔ̀ ŋunà Càŋ faá huaán mé bɔ̀ nùàr ŋaár yeé lòù sam. Dé bɔɔ̀n, Càŋ nùà njèh haá né bɔ́ yɔ̀ŋ kɔɔ́, dèn ŋgwéh bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ŋgòr doô lé naâ nùàr ŋaá, à den ká lètenè beèh léláŋ húɔ́m-temê mé léláŋ gècên ndɔ. Béh lé naá giì *sùsùm seèn ŋené; né sùsùm mé gɔndɔŋ Ŋunà Càŋ lé kwaá naâ beè Tele seèn. ");
INSERT INTO mcu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jâŋ yeé ŋene aá bú ménâ, à tueé njií bèsɔ́nè, ye bɔ̀ nùàr a: «Hên baá nuaá mé mè lé naâ bí tueé sâ! Mè lé ye bí a: nuaré déì baá jomo mò ndeê, kela né bú mé mè, toò jɔ̀gɔ̀ lɔ naâ bú mé mè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Béh né gi mé gà te ŋgúlú seène, à béh kulu njií den né te mbeî mbaá. ");
INSERT INTO mcu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dé *sóù, Càŋ lé béh sóú taga keéh naâ sònò Músì. Yeésò *Kristò yeé waà baá, béh nde ye mé fùgò beè seèn kuú, béh ŋgweé ye gècên sònò seèn ndɔ; ");
INSERT INTO mcu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","wanɔɔ́ŋ nuaá mé lé naâ Càŋ njolò ŋené sam, gi cegé né gɔndɔŋ Ŋuna seèn. À kèkènè Càŋ ŋené sɔm keéh né kɔɔ́. Càŋ né bú; ké kwarè Teleè den yeé bú. ");
INSERT INTO mcu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hên né njií mé Jâŋ lé tueé naâ toò bɔ̀ kokoô bɔ̀. Cieé déì bɔ̀ *Jûf dé ké Jerusalem tema njií bɔ̀ *ŋgàŋ sèmè mé bɔ̀ *Levî bɔ̀ ké yoòr seèn, te bɔ́ nde bie ke ye bú a: «Né wò neì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jâŋ càm ŋgwéh ndɔ, à tueé njií bɔ́ bèsɔ́nè ye bɔ́ a: «Mè *Nùà Cɔ̀ŋ sam.» ");
INSERT INTO mcu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bɔ́ ye bú a: «Á sâ, wò né neì wa? Wò né *Elî wa?» Jâŋ ye bɔ́ a: «Mè bú sam ndɔ.» Bɔ́ ye bú a: «Wò né *sòn-Càŋ mé béh né kela den doô wa?» Jâŋ ye bɔ́ a: «Sam.» ");
INSERT INTO mcu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","«Á sâ, wò né neì, te béh nde bɔ̀ɔ́ mé temà naâ béh tueé, wanɔɔ́ŋ wò ye naàn?» ");
INSERT INTO mcu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jâŋ ye bɔ́ a: «Mè né hueh nuaá mé né ké ya dueè ŋgulí den, ye: Bí tɔ́ dìlì nyégé ceér Nùà Dueè tɔɔ̀, bí tɔ́ dìlì nyégé bagasé! Esáyà sòn-Càŋ lé naâ mân tueé ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sâ lètenè bɔ̀ɔ́ mé lé ndeè naâ ké yoòr Jâŋ doô bɔ̀ *Farisiên lé naâ teèn ndɔ, ");
INSERT INTO mcu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bɔ́ ye Jâŋ a: «Á, mɔ wò Nùà Cɔ̀ŋ sam, wò Elî sam, wò sòn-Càŋ sam ndɔ, sâ wò bɔ̀ nùàr nòmò Càŋ kou né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jâŋ ye bɔ́ a: «Mè bɔ́ dé mò kou lom né léláŋ nòmò. Nuaré déì né lètenè biì teèn, bí bú kɔ́ ŋgwéh, ");
INSERT INTO mcu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","à baá jomo mò ndeê. Mè tueé bí, né mene yuií débágâ seèn, mè wúlú ŋgwéh nuaá mé nde né yuií débágâ seèn se.» ");
INSERT INTO mcu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bɔ̀ njií hên dɔɔ́ŋ lé bɔɔ́ deén naâ ké Betanî, sòn nòmò Jurdên kèb yágà, bèh mé Jâŋ lé kou deén naâ bɔ̀ nùàr teèn doô. ");
INSERT INTO mcu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cieé ŋaga Jâŋ yeé ke, Yeésò baá ká yoòr seèn ndeê, à deên ndɔ ye: «Kè Mbieè Sèmè mé yuoó naâ beè Càŋ hên nɔ, à ndeè veên bɔ̀ nùàr ká lè *wɔ́ŋe ŋaá weh. ");
INSERT INTO mcu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hên baá nuaá mé mè lé naâ bí tueé sâ, mè lé ye bí a: nuaré déì baá jomo mò ndeê, kela né bú mé mè, toò jɔ̀gɔ̀ lɔ naâ bú mé mè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mè lé kèkènè nùà sâ kɔ́ ná ŋgwêh; mé njéh mene mè jéjég ndeè naâ bú mé dàm bɔ̀ *Iserálà bɔ̀ feh keéh; mè bɔ̀ nùàr nòmò hên kou den né dé cî.» ");
INSERT INTO mcu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jâŋ den cuù ye bɔ́ a: «Mè lé kaà nùà sâ ŋéné kɔ́ ná ŋgwêh. Càŋ nuaá mé lé ye mè a: ndé bɔ̀ nùàr nòmò kou, lé tueé naâ mè kɔɔ́, ye mè a: Wò nde né Cúcuí Ŋagâ ŋené, à suaga ndeè né ter, à njebá den felè nuaré déì; sâ né nuaá mé nde né bɔ̀ nùàr mé Cúcuí Ŋagâ kou sâ. Jomo sâ mè ŋene Cúcuí Càŋ sâ ndɔ, à né ké ter faá vɔgɔb nɔ suagâ, né felè seèn njebá den. ");
INSERT INTO mcu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mè yeé ŋene aá bú ménâ, mè tueé njií bèsɔ́nè, ye bɔ̀ nùàr a: hên né Ŋunà Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cieé ŋaga cu, Jâŋ wa cu ké teèn, à né mé bɔ̀ mbɔ̀ŋ fà jomo njebá den. ");
INSERT INTO mcu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","À yeé ke, Yeésò baá kelá sa, ye: «Kè *Mbieè Sèmè mé yuoó naâ beè Càŋ sâ nɔ!» ");
INSERT INTO mcu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bɔ̀ mbɔ̀ŋ mé lé naâ jomo seèn doô yeé ŋgweé aá môn, bɔ́ yuo bele gi Yeésò fà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeésò bele seér ndɔ, à ŋene njií bɔ́ jomo seèn, ye bɔ́ a: «Bí fɔɔ́n yeé kei wa?» Bɔ́ ye bú a: «Wò den yeé he wa, Rábì?» (Rábì tueé né ye: Njí fèh-njèh.) ");
INSERT INTO mcu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ye bɔ́ a: «Bí ndê, bí nde né ŋené.» Bɔ́ fɔɔ́n gò ndɔ, sâ baá njèh lou lɔ̀ŋ nèà liyilì mân, bɔ́ wa, bɔ́ ŋene bèh sâ, bɔ́ bɔ́ sɔɔ́ weéh baá-re ké doó sâ. ");
INSERT INTO mcu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bɔ̀ fà bɔ̀ mé lé ŋgweé naâ ŋgòr sònò Jâŋ, mé bɔ́ yuo bele Yeésò doô, cén déì lé naâ Andrê dìm Simɔ̂ŋ Piêr. ");
INSERT INTO mcu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bɔ́ yeé yuo baá ké sâ, Andrê nde kwa lɔgɔ̂ bei seèn Simɔ̂ŋ, ye bú a: «Béh kwa baá *Nùà Cɔ̀ŋ.» (Sâ tueé né ye *Kristò). ");
INSERT INTO mcu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","À weh njií bú ké yoòr Yeésò. Yeésò yeé ŋene aá bú, ye bú a: «Wò né Simɔ̂ŋ, ŋunà Jâŋ; wò nde cu né yilí Séfà ŋguú.» Yilí sâ tueé né ye: Taá. ");
INSERT INTO mcu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cieé yeé ŋaga cu aá, Yeésò kaga gò te tàbè Galilê. Bɔ̂ Filîp kwaré. Yeésò ye bú a: «Bèlè mè.» ");
INSERT INTO mcu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filîp lé naâ nùà Becaida, bɔ́ bɔ̀ Andrê mé Piêr né mé lɔɔ́ cên. ");
INSERT INTO mcu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jomo sâ Filîp bɔ̂ Natanaêl nde kwaré ndɔ, Filîp ye bú a: «Nuaá mé Músì bɔ́ bɔ̀ *sòn-Càŋ bɔ̀ lé naâ felè seèn te mvù Càŋe nyagá kwaá doô, béh ŋene aá bú. Né Yeésò ŋunà Josêf, nùà Najarêt.» ");
INSERT INTO mcu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaêl deên ndɔ, ye bú a: «Wò ye njèh bagaà déì ndeè né ké Najarêt yuoô wa?» Filîp ye bú a: «Ndê, kè kú yeè!» ");
INSERT INTO mcu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeésò yeé ke, Natanaêl baá ká yoòr seèn ndeê, à tueé weh njeré déì felè seèn teèn ye: «Hên baá ye nùà *Iserálà dé gècên sâ, à dé seèn mé nyeén yoòr sam.» ");
INSERT INTO mcu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaêl ye bú a: «Wò mè ŋene kɔɔ̀ naâ mé ŋgei wa?» Yeésò ye bú a: «Mè la naâ wò ké ka toû ŋené njií, te Filîp nde ye wò yilá.» ");
INSERT INTO mcu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yeé baá ménâ, Natanaêl ye bú a: «Njí fèh-njèh, wò né Ŋunà Càŋ, Nùà Dueè bɔ̀ Iserálà bɔ̀ né wò!» ");
INSERT INTO mcu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeésò ye bú a: «Mè yeé baá wò tueé ye wò a: mè naâ wò ké ka toû ŋené njií, wò gwaán né dé cî wa? Wò nde cu né bɔ̀ njèh dé bebagaà mân ŋené yɔgɔ́ keéh.» ");
INSERT INTO mcu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","À den cuù ye: «Mè né tueé ye bí a, vulú nde né gulu lɔgɔ́, bí ŋene bɔ̀ cìlì Càŋ, bɔ́ né ké ter ŋaá, bɔ́ né ká doó felè *Huaán Nùàr suagâ.» ");
INSERT INTO mcu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jomo sâ kela cieé fà mé tagár, kùrmò fù feí ké Galilê te lɔɔ́ Kánà. Meì Yeésò lé naâ teèn ndeé, ");
INSERT INTO mcu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","bɔ́ lé naâ Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn ké teèn yilá njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nde nde mbè gi. Mbè yeé gi aá, meì Yeésò ye Yeésò a: «Bɔ́ mé mbè teèn sam cuú.» ");
INSERT INTO mcu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeésò den seér cuù, ye bú a: «Ma, wò mè tueé nde aá kɔɔ́ te mè bɔɔ́ ye wa? Cu mò née wá ŋgwéeh ye.» ");
INSERT INTO mcu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yeé baá ménâ, meí ye bɔ̀ seé bɔ̀ a: «Bí bɔ́ gí faá à tueé nde né bí nɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sâ bɔ̀ ŋguú déì lé naâ doó sâ ténjén, né ŋguú mé bɔ́ kwe né taá, bɔ̀ *Jûf toò Càŋ vua tena yeé teèn. Bɔ̀ ŋguú sâ né yilá: bɔ̀ déì né bɔgɔ nèà, bɔ̀ déì bɔgɔ tîn mé ténjén. ");
INSERT INTO mcu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeésò tueé njií mé bɔ̀ seé bɔ̀, ye bɔ́ a: «Bí túé kwá bèlè nòmò lè bɔ̀ ŋguû hên dedeí.» Bɔ́ yeé tue yuú gi aá, ");
INSERT INTO mcu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","à deên baá-re ye bɔ́ a: «Kènê bí síó wèh nòmò sâ kèb déì, bí haá njií mé nùà koô.» Bɔ́ sio haá njií bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nùà koô doô yeé naga ke, à ŋgweé nòmò doô baá seér mbè, à bèh mé yuoó naâ teèn kɔ́ sɔ̀m ŋgwéh; sâ bɔ̀ seé bɔ̀ mé la tueè naâ nòmò sâ né gi dé bɔɔ̀n kɔɔ́. Nùà koô doô yilá njiî siì fù ndɔ, ");
INSERT INTO mcu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","à ye bú a: «Bɔ́ mbè sɔm lɔgɔ́ yeé dé njêŋ; mɔ bɔ̀ nùàr fulu gi aá, bɔ́ sɔm ye mbìèrrè. Wò nde leér seér dé yeè dé njêŋ, te wò sɔm ye kènê mà!» ");
INSERT INTO mcu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hên né fém Yeésò dé toò jɔ̀gɔ̀, à lé bɔɔ́ lɔgɔ́ naâ ké Galilê te lɔɔ́ Kánà, te terreb seèn ŋené yuo kelà teèn; bɔ̀ mbɔ̀ŋ lé naá giì temé yoòr seèn kwaá njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jomo sâ à yuo doó sâ, à nde Kapernahûm bɔ̂ meí mé bɔ̀ dìm mé bɔ̀ mbɔ̀ŋ mene. Wa ké teèn, bɔ́ kókoó cèr màgà ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sâ cieé koô bɔ̀ *Jûf mé bɔ́ yilá né *Páskà baá dìdì. Yeé nde aá feí, Yeésò nde ké Jerusalem ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","À wa ké gwà Càŋ koô, sâ bɔ̀ toón bɔ̀ né bɔ̀ nàgà bɔ́ bɔ̀ sòrŋgaŋ mé vɔgɔb go den. Bɔ̀ kwéh-kàgàlɔ̀ŋ bɔ̀ né ké te gbàgàa kàgàlɔ̀ŋ kweéh den ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yeésò yeé ŋene aá ménâ, à weh yuií, à far bilí ŋgágá, à lurú sɔm keéh gi bɔ́ cie mé njéh; à né bɔ̀ nàgà mé bɔ̀ mbieè cie lurú sɔm keéh; à né bɔ̀ kàgàlɔ̀ŋ mé gbàgà mene doó velá su njií, ");
INSERT INTO mcu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ye bɔ̀ gò-vɔgɔb bɔ̀ a: «Bí yùò mé njéh doó sâ nɔɔ́ŋ, bí té gwà Tele mò faá gwà toôn biì nɔ kwá sér!» ");
INSERT INTO mcu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bɔ̀ mbɔ̀ŋ seèn yeé ŋene aá ménâ, bɔ́ munó ko cu ye baá-re dé mé né te mvù Càŋe nyagá den, ye: «Càŋ mò, temé mò né lom ké gwò yeè; mɔ mè munó njií gwà yeè mân, temé bɔgɔ́ gi mè lè.» ");
INSERT INTO mcu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","À yeé kwɔgɔ sɔm aá bɔ́ cie ménâ, bɔ̀ Jûf bie bú ndɔ, bɔ́ ye bú a: «Wò bɔɔ́ feh nde né béh gèh fém dé heè, mé béh nde né teèn ŋené kɔɔ́ ye wò sé la naâ ménâ bɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeésò deên ndɔ, ye bɔ́ a: «Bí túlú sù njí gwà Càŋ koô hên doó, mè bú ter komo sɔm cu nde né te cieé tagáre.» ");
INSERT INTO mcu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bɔ̀ Jûf den cuù, ye bú a: «Gwà mé bɔ́ lé temà naâ seé teèn nyèmà yulà nèà cùɔ̀b ténjén hên, wò ye nyí nde né bú ter lè cieé tagáre komo sɔm cuú sé wa?» ");
INSERT INTO mcu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kàmbér gwà Càŋ koô mé Yeésò né bɔ́ tueé doô, à jue né gùm seèn nùà njèh. ");
INSERT INTO mcu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nde nde, à yeé komo yuo aá lè cio, bɔ̀ mbɔ̀ŋ seèn nde ye mân ŋgweé komo, ye à lé naá giì mân tueé. Bɔ́ kwaá njií ye baá-re temé te mvù Càŋe, bɔ́ né te ŋgòr seèn kwaá njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cu mé Yeésò lé naâ ké Jerusalem te cu Páskà sâ, bɔ̀ nùàr kókoó mbaá lé naâ fém seèn ŋené, bɔ́ kwaá njií lom temé yoòr seèn ŋgún mbaá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mé njéh mene, Yeésò njolo teèn kè njí ŋgwéh; lòù sam, à lé naá giì bɔ́ ŋené kɔɔ́ nyegé, ");
INSERT INTO mcu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","à lé túé ná ŋgwêh ye nuaré déì a, túé sɔ́ nyí njeré déì felè nuaré déì lòù; à lé naá giì temé nùà kàn ŋené kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nùà *Farisiên déì lé naâ teèn, yilí seèn né Níkòdêm, à né nùà koô lètenè bɔ̀ *Jûf. ");
INSERT INTO mcu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cieé déì, yeé baá cíbítenè mân, à nde ké yoòr Yeésò, ye bú a: «Njí fèh-njèh, béh kɔ baá ye Càŋ tema njií naâ wò ká yoòr beèh kɔɔ́, te wò feh nyegé béh, wanɔɔ́ŋ nuaré déì mé gèh terreb fém mé wò né bɔɔ́ hên sam, mɔ Càŋ mé bú sam ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeésò deên ye bú a: «Mè né tueé ye wò a, mɔ bɔ́ nùàr dé feê ŋàr sér ŋgwéh, à *Lò Càŋ mé njolo ŋéné ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Níkòdêm deên ndɔ, ye bú a: «Nuaá mé baá gi nùà koô, bɔ́ bú dé feê ŋar seér cu nde né naàn wa? À nde cu né lè meî yilá komo, te bɔ́ ŋar ferré cu bú ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeésò ye bú a: «Mè né tueé ye wò a, mɔ bɔ́ nùàr dé feê, te nòmò mé Cúcuí ŋàr sér ŋgwéh, à te Lò Càŋe yílá ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Njií mé ŋar né mé húɔ́m, né njèh húɔ̂m; dé mé Cúcuî Ŋagâ ŋar né kɔɔ́ né mé Cúcuí Càŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bú a, té wò mbaá ndègè kú, ye mè la ye nyí a: kɔ bɔ́ nùàr ŋàr sér cú dé feê. ");
INSERT INTO mcu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fu né mé feh seèn kobó, wò né gi bèmè ŋgweé; mé njéh mene wò bèh yuoô mé bèh ndeê seèn kɔ́ ŋgwéh. Beè nuaá mé nde né mé Cúcuí Càŋ kweéh seér, né yeé môn ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yeé baá môn, Níkòdêm ye bú a: «Dé sâ seèn ménâ bɔɔ́ nde né naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeésò ye bú a: «Wò gùm Nùà fèh-njèh dé koô déì lètenè bɔ̀ *Iserálà bɔ̀ dɔɔ́ŋ, wò bɔ̀ njií hên ŋgwé kòmò ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mè né tueé ye wò a, béh tueé né felè njií mé béh né kɔɔ́, felè njií mé béh naâ ŋené ndɔ; mé njéh mene bí ŋgòr beèh gwàn ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mè né mene felè bɔ̀ njií mé né ká te tabe tueé, bí temé teèn kwá njí ŋgwéh, sâ mɔ mè tueé mene bí bɔ̀ dé ké te vulúu, bí nde né temé teèn kwaá njií wa? ");
INSERT INTO mcu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nuaré déì née ké te vulúu ŋá ŋgúŋgwéeh ye; gi cegé né *Huaán Nùàr mé lé suagà naâ ké teèn! ");
INSERT INTO mcu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Ŋgweéh ké ya dueè Músì lé naâ lɔ̀ŋ weh, à bɔɔ́ sàb mé njéh, à sɔm njií ter wa? Bɔ́ nde né Huaán Nùàr ter ménâ sɔm njií ndɔ, ");
INSERT INTO mcu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te bɔ̀ɔ́ mé né temé yoòr seèn kwaá njií dɔɔ́ŋ, yili yuo gi mé yɔ̀ŋ tètàgà. ");
INSERT INTO mcu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Lòù sam, Càŋ né lom *wɔ́ŋ mé temé cén mene gwaán, à lé gɔndɔŋ Ŋuna seèn tema njií naâ dé cî, te bɔ̀ɔ́ mé kwaá njií né temé yoòr seèn dɔɔ́ŋ lèr lè cú, te bɔ́ kwa seér yɔ̀ŋ tètàgà. ");
INSERT INTO mcu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Càŋ lé Ŋuna seèn ká te wɔ́ŋe témá njí ná ŋgwêh ye te à nde ju felè wɔ̂ŋ tená. À lé bú tema njií naâ, ye te à yili sɔm seér bɔ̀ nùàr lòù. ");
INSERT INTO mcu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«Sâ, nuaá mé né temé yoòr Ŋunà Càŋ kwaá njií, dé seèn ju dìè ndé ŋgwéh; nuaá mé temé yoòr Ŋuna seèn kwá njí ŋgwéh, die gi aá ju kèn. Lòù sam, à temé yoòr gɔndɔŋ Ŋunà Càŋ kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mbòntí mbòntì ju dieè né mân: Ŋagâ lé naâ ká lè wɔ́ŋe yuo kelâ, bɔ̀ nùàr kwaá lɔɔ̀ ŋagâ, bɔ́ gwaán seér bèh cibì; né felè veên bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Né yeé môn, nuaá mé né veên bɔɔ́ dɔɔ́ŋ berɔ́ŋ yeé bèsɔ́nè gɔɔ̀ ménâ, à bèh ŋagâ gwàn bèh, ye veên nyî nde né cie ŋagá le. ");
INSERT INTO mcu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dé nùà gècên môn sam, à dé seèn seé bɔɔ́ den yeé bèh ŋagâ, te bɔ̀ nùàr ŋene ŋagá teèn, ye à bɔɔ́ né faá Càŋ tueé nê nɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jomo sâ Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn fɔɔ́n gò ndɔ, bɔ́ nde cu te tàbè Judê, bɔ́ cer weh ké sâ teèn, à né bɔ̀ nùàr kou bele. ");
INSERT INTO mcu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sâ Jâŋ né bɔ̀ nùàr ké Ayinɔ̂ŋ kwarè Salîm kou den ndɔ; ké bèh sâ nòmò lé naâ kókoó. Bɔ̀ nùàr kókoó mbaá kem wa giì teèn, Jâŋ kou gi bɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sâ bɔ́ lé née Jâŋ cu sâ gwà cibì yí ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yeé baá môn, jɔ́gɔ́ die lètenè bɔ̀ mbɔ̀ŋ Jâŋ bɔ́ bɔ̀ nùà *Jûf déì ndɔ, bɔ́ bɔ́ lé saán naâ felè tòù nòmò koù. ");
INSERT INTO mcu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bɔ́ ndeè ye Jâŋ a: «Njí fèh-njèh, nùà loù mé wò lé tueé naâ felè seèn, mé bí bú lé naâ yí sòn nòmò Jurdên kèb yágà doô, kè kú, à baá bɔ̀ nùàr kou den; bɔ́ baá gi yoòr seèn kem ndeé.» ");
INSERT INTO mcu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jâŋ deên ye bɔ́ a: «Nuaré déì njèh mbaá bɔ́ kòmò ndé ŋgwéh. Kɔ Càŋ bú terreb sâ haá naâ kɔɔ́, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bí mé feh biì tueé nde né sòn mò kɔɔ́, ye mè lé naá giì tueé, ye mè *Nùà Cɔ̀ŋ sam, mè né seér dé mò nùà tebê mé bɔ́ lé tema keéh naâ toò seèn. ");
INSERT INTO mcu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Siì fù né nùà fù kɔɔ́, mbeí nùà fù dé seèn njebá lom né kwarè, à né hueh seèn ŋgweé, à né lom mé vɔ́gɔ́-temé felè seèn. Mè né ménâ, kènê temé mò né lè gùm dɔɔ́ŋ sagár. ");
INSERT INTO mcu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mè tueé bí, kɔ à ter ŋaá seér kɔɔ́, mè dé mò njoró seér lòù.» ");
INSERT INTO mcu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nuaá mé lé suagà naâ ké te vulúu né dé seèn mé terreb felè njèh dɔɔ̂ŋ. Bɔ̀ɔ́ mé yuo né ká doó, dé bɔɔ̀n né bɔ̀ ká doó bɔ̀, bɔ́ tueé lom né bɔ̀ njèh dé ká doô ndɔ. Nuaá mé yuoó naâ ké te vulúu, felè bɔ̀ njèh dɔɔ̂ŋ né bú; ");
INSERT INTO mcu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","à dé seèn tueé né felè bɔ̀ njií mé à naâ ŋené, mé à naâ ŋgweé ndɔ. Mé njéh mene, nuaá mé gwaán sɔm ŋgòr seèn teèn sam ŋgweéh. ");
INSERT INTO mcu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nuaá mé né ŋgòr seèn gwaán, né dé seèn ŋené kɔɔ́ ye Càŋ tueé né gècên. ");
INSERT INTO mcu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nuaá mé Càŋ tema njií naâ kɔɔ́, tueé né sòn Càŋ; Càŋ bú Cúcuí seèn haá né faá cí nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tele né bú, à né Ŋuna seèn gwaán, à terreb dɔɔ́ŋ haá kwaá gi aá beè Ŋunà. ");
INSERT INTO mcu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nuaá mé né temé yoòr Ŋunà kwaá njií dɔɔ́ŋ baá mé yɔ̀ŋ tètàgà; nuaá mé né dé seèn sòn Ŋunà lòù ŋgeén, mé yɔ̀ŋ sam; Càŋ né seér njèh mé bú kwaá. ");
INSERT INTO mcu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Bɔ́ ye bɔ̀ *Farisiên a: Yeésò baá mbɔ̀ŋ ŋgún si, à né bɔ́ nòmò kou, wa bɔ̀ mbɔ̀ŋ seèn baá bɔ̀ dé Jâŋ maga yɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Á sâ, Yeésò bɔ́ mé be seèn kòù ŋgwéh ndɔ, né bɔ̀ mbɔ̀ŋ seèn kou den né bɔ́ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yeésò yeé ŋgweé aá môn, à yuo te tàbè Judê sâ, à cu cu Galilê. ");
INSERT INTO mcu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","À yeé baá mé gò, ye kɔ nyí kela seér nde né te tàbè Samarî. À yeé baá kelá ");
INSERT INTO mcu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","à wa kwarè lɔɔ́ déì te tàbè Samarî sâ, kèbè ŋueèh mé Jakɔ̂b lɔ haá naâ mé ŋuna seèn Josêf. Yilí lɔɔ́ sâ né Sikâr. ");
INSERT INTO mcu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lùgò nòmò mé bɔ́ yilá yeé nòmò Jakɔ̂b doô né ké bèh sâ ndɔ. Wa ké teèn, sâ lou dilí baá, Yeésò homo baá mé gò. Yeé baá ménâ, à den du nde kwarè lùgò nòmò hèllè. ");
INSERT INTO mcu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","À yeé ke, ma Samarî déì waà baá, à ndeè bèh nòmò tueê. Yeésò ye bú a: «Há mè nòmò ŋueê teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sâ bɔ̀ mbɔ̀ŋ seèn ŋellé nde gi aá ké lètenè lɔɔ̂ yáb ŋge fɔɔ́n. ");
INSERT INTO mcu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yeésò yeé tueé aá bú ménâ, ye Yeésò a: «Ŋgweéh wò né nùà Jûf mà! Wò mè ma Samarî nòmò dua seér nde né naàn wa?» Sâ bɔ̀ Jûf bɔ́ bɔ̀ Samarî bɔ̀ nyuùn kwàrè bèh. ");
INSERT INTO mcu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mé njéh mene, Yeésò ye bú a: «Njií mé Càŋ né haá, mɔ wò sé la né ŋené kɔɔ́, wò ŋene kɔ nuaá mé né wò nòmò dua hên ndɔ, wò sé la bɔŋ seér naâ bú kɔɔ́, te à wò nòmò haá seér dé yɔ̀ŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma doô ye bú a: «Dé koô, hên wò yeè mé njèh nòmò tueê beè sam, lùgò nòmò né yilá ndɔ; wò nòmò dé yɔ̀ŋ sâ weh ndeè né he wa? ");
INSERT INTO mcu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jakɔ̂b, tele beèh dé koô lɔ kwaá lɔɔ̀ naâ béh lùgò nòmò hên kɔɔ́, à lɔ tue ŋueé beéh teèn. Bɔ̀ ŋuna mé bɔ̀ nyam seèn dɔɔ́ŋ ŋueé gi teèn ndɔ. Wò ye nyí né Jakɔ̂b yɔgɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeésò ye bú a: «Bɔ̀ɔ́ mé né nòmò dé sâ ŋueé dɔɔ́ŋ, nyúá nde cu né bɔ́ sie. ");
INSERT INTO mcu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nuaá mé dé seèn ŋueé né nòmò mé yuo ndeè né beè mò, dé seèn nyúá ŋgwé ndé cú. Nòmò dé sâ nde né nduùn lè seèn si, haá bú yɔ̀ŋ tètàgà.» ");
INSERT INTO mcu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma doô den cuù, ye bú a: «Á sâ dé koô, há mè nòmò sâ teèn, te nyúá mè sìè ŋgwé cú, te mè ká dùà bèh nòmò tueê ndé dèn cû.» ");
INSERT INTO mcu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeésò ye bú a: «Ndé yílá ndê mé si yeè.» ");
INSERT INTO mcu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ye Yeésò a: «Mè mé siíb sam.» Yeésò den cuù ndɔ, ye bú a: «Wò tueé yií né teèn, mé wò ye nyí mé siíb sam. ");
INSERT INTO mcu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wò jɔgɔ baá siíb tîn; nùà dé jomo hên, si yeè sam, wò tueé né gècên.» ");
INSERT INTO mcu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yeé baá mân, ma doô ye bú a: «Wò né *sòn-Càŋ déì, mè ŋene né môn dé koô! ");
INSERT INTO mcu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bɔ̀ tele beèh léí jɔ̀gɔ̀ lɔ Càŋ dua beéh te tòr hên; bí bɔ̀ Jûf, bí den seér cuù, ye bèh Càŋ duaà kɔ né ké Jerusalem doô nɔ!» ");
INSERT INTO mcu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeésò ye bú a: «Ŋgwé yeè dé mò hên, dé vêh, kwá njí temé teèn: Cu déì ndeè né waâ, né mene ká te tòr hên, né mene ké Jerusalem, bí Càŋ Tele biì teèn dùà lòm ndé cú. ");
INSERT INTO mcu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bí bɔ̀ Samarî bɔ̀, bí nuaá mé bí né dua sâ kɔ́ ŋgwéh. Béh bɔ̀ Jûf, dé beèh nuaá mé béh dua né doô béh né bú kɔɔ́: nuaá mé nde né *wɔ́ŋ yili sɔm yuo né lètenè bɔ̀ Jûf. ");
INSERT INTO mcu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mé njéh mene, cu baá ndeê, hên baá cí, bɔ̀ jéjég dùà-Càŋ bɔ̀ nde né Tele bɔɔ̀n teèn mé cúcuí mene, mé gècên mene dua. Lòù sam, Tele bɔɔ̀n gwaán né bɔ̀ɔ́ mé né gèh dé sâ dua kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Càŋ né Cúcuí; kɔ bɔ̀ɔ́ mé né bú dua, dua lom bú mé cúcuí mene, mé gècên mene, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","À yeé tueé gi aá mân, ma doô ye bú a: «Mè né kɔɔ́ ye loró déì *Nùà Cɔ̀ŋ ndeè né waâ; sâ jue né *Kristò. Mɔ à ndeè waà baá, à nde né béh njèh dɔɔ́ŋ se ŋagá.» ");
INSERT INTO mcu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeésò deên baá-re ndɔ, ye bú a: «Né mè sâ, mè hên tueé den né wò kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sâ bɔ̀ mbɔ̀ŋ seèn baá cuù cuû ndɔ, bɔ́ waà; hiím yɔgɔ́ bɔ́ mé à né mé ma vêh déì tueé njií den. Mé njéh mene, bɔ́ bú njeré déì bíé ŋgwéh ye bú a: bí bú la naâ naàn wa? Wò bú sònò tueé den né kei ndɔ wa? Bɔ́ ménâ bíé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yeé baá môn, ma doô kwaá njií bɔgɔ nòmò doó, à cu cu ké lɔ, ye bɔ̀ nùàr a: ");
INSERT INTO mcu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Bí ndê kè kú biì nuaré déì, à tueé gi aá mè bɔ̀ njií mé mè lé bɔɔ́ naâ dɔɔ́ŋ, merré déì né Nùà Cɔ̀ŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ kem yuoô ké lɔ, bɔ́ né ká yoòr Yeésò ndeê. ");
INSERT INTO mcu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sâ bɔ̀ mbɔ̀ŋ né bú cu sâ bɔŋ den, te à yieé weh yáb, bɔ́ ye bú a: «Nùà fèh-njèh, jɔ̀gɔ̀ yíé kwá njeré déì lè ye!» ");
INSERT INTO mcu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","À den seér cuù, ye bɔ́ a: «Mè né mé yáb dé mé bí kɔ́ ŋgwéh teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bɔ̀ mbɔ̀ŋ duɔɔ̂m baá-re lètenè bɔɔ̀n bieé kuú deèn, ye: «Á sâ, nuaré déì naâ bú yáb haá wa?» ");
INSERT INTO mcu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeésò deên ndɔ, ye bɔ́ a: «Yáb dé mò né seér hiín; mè ŋgweé né dé mò sòn nuaá mé temà naâ mè, te mè bɔɔ́ weéh seé seèn, sâ né yáb dé mò. ");
INSERT INTO mcu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bí née dé biì tueé den ye: le ye aá weéh nèà te yab bɔlé ye. Mè dé mò ye bí a, bí jɔ̀gɔ̀ ke ke ŋueèh ye: yab bɔlé gi aá kèn, baá gi dé kwaâ. ");
INSERT INTO mcu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nuaá mé né yab sâ kwaá, baá gi mé sàgà seèn teèn, à né tàb bilí, te yab sâ den dé ndeèr ndɔ. Mɔ baá môn, te nùà doboò bɔ̂ nùà kwaâ sagár gi fà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sâ ŋgòr hên tueé né gècên, ye: déì nde né nùà doboò, déì nùà kwaâ. ");
INSERT INTO mcu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mè hên tema njií né bí te ŋueèh mé bí lé kɔɔ́ kíé ná ŋgwêh; bɔ̀ déì lé kieè naâ kɔɔ́, bí te njua seê bɔɔ̀n yila nde né lòù.» ");
INSERT INTO mcu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lɔ sâ bɔ̀ Samarî bɔ̀ kókoó mbaá kwaá njií gi temé yoòr Yeésò. Bɔ́ temé sâ kwaá njií né felè ŋgòr mé ma doô naâ bɔ́ tueé ye bɔ́ a: njií mé nyí lé naá giì bɔɔ́ dɔɔ́ŋ à la naâ nyí tueé ma. ");
INSERT INTO mcu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bɔ́ yeé waà baá, bɔ́ bɔŋ bú ndɔ, te bɔ́ bɔ́ den le. Yeésò cer ké sâ cieé fà. ");
INSERT INTO mcu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bɔ̀ déì ŋgweé cu bɔ̀ ŋgòr mé yuoó naâ sònò seèn nùà njèh, nùàr ŋgún kwaá njií gi temé yoòr seèn, ");
INSERT INTO mcu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","bɔ́ ye ma doô a: «Béh temé yoòr seèn mé léláŋ ŋgòr yeè kwá njí lòm cú; kènê béh ŋgweé baá mé tie beèh, béh kɔ baá ye, mé gècên mene nuaá mé ndeè né wɔ́ŋ yili sɔm né bú.» ");
INSERT INTO mcu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yeésò yeé cer aá cieé fà, à yuo doó sâ, à nde cu te tàbè Galilê, ");
INSERT INTO mcu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","wa mɔ *sòn-Càŋ né te tàbè seène, bɔ̀ nùàr bú sùmù ndé ŋgwéh. À lé naá menè mé sòn seèn ménâ tueé, ");
INSERT INTO mcu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","mé njéh mene, à yeé baá te tàbè Galilê sâ, bɔ̀ Galilê bɔ̀ lé naâ bú weh nyegé. Lòù sam, bɔ́ lé naâ ké Jerusalem te cieé koô teèn, bɔ́ lé naâ njií mé à lé bɔɔ́ giì naâ te cieé koô sâ ŋené ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeé baá ménâ, à cu cu ké Kánà dé Galilê, bèh mé à lé seér naâ nòmò ŋa mbè doô. À wa, sâ nùà koô déì te seé ŋgɔ́mnà né doó sâ, ŋuna seèn né ké Kapernahûm baán. ");
INSERT INTO mcu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","À yeé ŋgweé aá ye Yeésò yuoó baá ké Judê kèn, wa à baá ké Galilê ma, à nde ké kwarè seèn ndɔ, ye bú a: «Kúkùr yeè, huaán mò nde aá ké Kapernahûm kuú, ndê táré sɔ̀m yeè mè bú teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeésò deên ndɔ, ye bú a: «Mɔ bí fém mé cìè ŋéné ŋgwéh, bí temé yoòr mò kwá njí bèh.» ");
INSERT INTO mcu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nùà koô doô ye bú a: «Dé koô, ndê mè ké teèn ndeè, te huaán mò kú cú.» ");
INSERT INTO mcu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeésò ye bú a: «Ndé cú yeè lɔ, ŋuna yeè taré aá kèn.» Nùàrè kwaá njií temé te ŋgòr Yeésò ndɔ, à fɔɔ́n cu gò lɔɔ̂. ");
INSERT INTO mcu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","À yeé baá ceér dueè, bɔ́ bɔ̀ seé bɔ̀ seèn kwaré, bɔ́ ndeè bú tueé weh, ye bú a: «Ŋuna yeè baá cu mé yɔ̀ŋ!» ");
INSERT INTO mcu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ye bɔ́ a: «À taré naâ mé cu dé heè wa?» Bɔ́ ye bú a: «Dùlù lé bú yoòr keém naâ léílé mé lou lɔ̀ŋ cén.» ");
INSERT INTO mcu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tele munó kɔ njií ye né lè cu mé Yeésò lé naâ nyí teèn tueé, ye nyí a: ŋuna nyî taré aá kèn doô. Nùà koô doô temé yoòr Yeésò kwaá njií cu ye baá-re mé mbàgà seèn dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Bèh mé Yeésò lé yuoô naâ Judê, à ndeè Galilê dɔɔ́ŋ, hên baá ye fém seèn dé mbei fà te tàbè Galilê sâ. ");
INSERT INTO mcu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jomo sâ cieé koô bɔ̀ *Jûf déì feí ndɔ, Yeésò ŋaá nde ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sâ nduùn déì né ké Jerusalem sâ teèn, yilí seèn mé ju *hebreêh né Betsátà, à né kwarè hin mé bɔ̀ sòrŋgaŋ yila yeé ké lɔ teèn; bɔ́ sie kwaá né pàgà tîn teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bɔ̀ beên bɔ̀ kókoó mbaá né yeé teèn bilí cer den: bɔ̀ tácugó, bɔ̀ tácɔgɔ́ mé bɔ̀ tá-galé mene, bɔ́ né nòmò yí dùà kela den, mɔ baá jilí, te bɔ́ yila teèn. ");
INSERT INTO mcu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sâ cìlì Nùà Dueè déì né yeé cu déì te nduùn sâ suagá yilá, à jilí beh nòmò. Mɔ nòmò baá jilí, nùà beên mé nde né toò jɔ̀gɔ̀ yí dùà yilá lɔgɔ́, nde né taré yuo; né mene gèh beén dé heè, nde né taré. ");
INSERT INTO mcu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sâ nuaré déì lé naâ ké sâ teèn, à ban aá baá nyèmà yulà tagár cùɔ̀b téndelé. ");
INSERT INTO mcu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeésò wa kwa bú ké teèn ndɔ, à ŋene kɔ, ye nùà hên cer aá doó dàb baá teèn, à bie njií ye bú a: «Wò gwaán né taré yuoò wa?» ");
INSERT INTO mcu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nùà beên doô ye bú a: «Dé koô, mè mé nùàr sam. Mɔ nòmò baá jilí, nuaá mé nde né mè yí dùà jɔgɔ́ yií teèn sam. Mé mè sé nde yí teèn su waá, sâ nuaré déì mè toò tena baá kèn.» ");
INSERT INTO mcu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeésò ye bú a: «Wùò ter, wèh kè yeè, gègɔɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nùà hèllè taré yuo beè nomo ndɔ, à weh kè seèn, à yila gɔɔ̀. Sâ lé naâ loù sóù. ");
INSERT INTO mcu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bɔ̀ Jûf yeé ŋene aá nuaá mé Yeésò la naâ taré sɔm doô, bɔ́ ye bú a: «Lan né sóú, té kè jɔ́gɔ́, né jolo.» ");
INSERT INTO mcu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ye bɔ́ a: «Nuaá mé la naâ mè taré sɔm la tueé naâ mè kɔɔ́, ye mè a: Wèh kè mò, mè gègɔɔ̀ ma.» ");
INSERT INTO mcu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bɔ́ bie baá-re bú nuaá mé la ye bú a: wùò ter, wèh kè yeè, gègɔɔ̀ sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nùà hèllè yilí nuaá mé taré sɔɔ́m naâ bú doô kɔ́ ŋgwéh. Sâ Yeésò la naâ doó sâ yuo. Lòù sam, bɔ̀ nùàr la naâ doó sâ ŋgún. ");
INSERT INTO mcu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nde nde nùà doô bɔ̂ Yeésò nde kwaré cu ké gwà Càŋ koô. Yeésò deên baá-re ndɔ, ye bú a: «Félá nyégé bagasé: dé tarê, wò taré baá kèn, té veên déì fɔ̀gɔ̀ cú; mɔ sam, dé jomò hên nde né wò taré yɔgɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nùà hèllè njege nde bɔ̀ Jûf dé kokoô tueé, ye bɔ́ a: Yeésò taré sɔɔ́m naâ nyí kɔɔ́ ma. ");
INSERT INTO mcu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bɔ̀ Jûf duɔɔ́m baá-re Yeésò teèn sâ bunô ndɔ, ye à lé ménâ bɔɔ́ naâ loù sóù fí. ");
INSERT INTO mcu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeé baá ménâ, Yeésò ye bɔ́ a: «Tele mò né seé cu dɔɔ́ŋ bɔɔ́ den, mè seé bɔɔ́ den né cu dɔɔ́ŋ ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bɔ̀ Jûf yeé nde ŋgweé njií mân, bɔ́ Yeésò filí ŋeí cu lòù, te bɔ́ wula sɔm bú wulà; wa dé sóú kwaâ gí cégé cú, à la naá cuù tueé ye Càŋ né Tele nyî fí. À feh seèn mé Càŋ mân me njií né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeésò deên ndɔ ye bɔ́ a: «Mè né tueé ye bí a, Huaán njèh mé feh seèn mbaá bɔ́ wèh bèh; à bɔɔ́ yeé njií mé à né beè Tele seèn ŋené. Njií mé Tele né bɔɔ́ dɔɔ́ŋ, Huaán nde né ménâ bɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Lòù sam, Tele né Ŋuna seèn gwaán, à bú feh gi né njèh dɔɔ́ŋ. Bɔ̀ seé dé kokoô, mé né bɔ̀ dé hên yɔgɔ́ keéh, à nde cu né bú feh kwaá, te à bɔɔ́ beh. Bɔ̀ sâ bɔ̀ nde cu né bí kɔɔ́ hiím kelá, mè tueé bí. ");
INSERT INTO mcu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gèh dé mé Tele mò né bɔ̀ komó te cio komo sɔm, à haá bɔ́ yɔ̀ŋ doô, Huaán nde né bɔ́ yɔ̀ŋ ménâ haá ndɔ. Yɔ̀ŋ sâ, à haá né mé bɔ̀ɔ́ mé à gwaán nê. ");
INSERT INTO mcu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tele ju kɔɔ́ túé ndé ŋgwéh, à terreb ju tueê gùm dɔɔ́ŋ haá lɔ né beè Huaân, ");
INSERT INTO mcu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te bɔ̀ nùàr veéh ye Huaán faá bɔ́ veéh né Tele nɔ. Nuaá mé Huaán vèh ŋgwéh, sâ à Tele mé lé temà naâ bú vèh ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","À den cuù ye bɔ́ a: «Mè né tueé ye bí a, nuaá mé né ŋgòr mò ŋgweé, mé né temé yoòr nuaá mé tema njií naâ mè kwaá njií, né dé seèn mé yɔ̀ŋ tètàgà. À dé seèn ju dìè ndé cú, à kela keéh baá cio, à baá mé yɔ̀ŋ dé tètàgà. ");
INSERT INTO mcu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mè né cu tueé ye bí a, cu baá ndeê, hên baá giì cí, bɔ̀ komó nde né hueh Ŋunà Càŋ ŋgweé; bɔ̀ɔ́ mé né hueh sâ ŋgweé nde né yili yuo. ");
INSERT INTO mcu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Lòù sam, nùà njèh né Tele seèn, à haá yeé yɔ̀ŋ kɔɔ́. À Ŋuna haá né terreb yɔ̀ŋ haâ ndɔ; ");
INSERT INTO mcu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","à bú haá cu terreb ju tenâ. Lòù sam, Huaán né *Huaán Nùàr. ");
INSERT INTO mcu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bí té biì teèn mbaá hím dèn, cu baá ndeê, bɔ̀ komó nde né hueh seèn ŋgweé, bɔ́ komó yuo giì dòù. ");
INSERT INTO mcu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bɔ̀ɔ́ mé lé naâ baga bɔɔ́, nde gi né komó yuo, te bɔ́ kwa yɔ̀ŋ; bɔ̀ vevenê bɔ̀ komó yuo giì nde né ménâ ndɔ, te ju sie bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Mè njeré déì mé feh mò bɔ́ wèh bèh, mè ju tueé lom né faá Càŋ tueé né mè nɔ, ju mò né teèn yilá gií ndɔ. Lòù sam, mè mé feh mò túé bèh, mè tueé bele né sòn nuaá mé temà naâ mè. ");
INSERT INTO mcu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Hên mɔ mè sòn mò tueé cu né kɔɔ́, sâ bɔ̀ njií mé mè né tueé hên, bɔ̀ nùàr nde né gwaán ye né gècên wa? ");
INSERT INTO mcu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mè tueé bí, nuaré déì sòn mò tueé seér né kɔɔ́, mè né kɔɔ́ ye nùà sâ tueé lom né gècên ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Bí lé naâ bɔ̀ tebé bɔ̀ ké yoòr Jâŋ temá njií, à lé naâ gècên tueé ŋagá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dé mò, mè túé ŋgwéh ye nuaré déì a, jɔ̀gɔ̀ túé sɔ́ɔ sòn mò kɔɔ́, mè felè Jâŋ tueé lom né te bí yili yuo. ");
INSERT INTO mcu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jâŋ lé naâ faá lâm mé né baá ŋagá den nɔ. Bí yeé gwaán aá, bí nde ké te mɔgɔ́ seèn cuúr cén vɔgɔ́ weh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mé njéh mene, njií mé né sòn mò tueé ŋagá hên ham kela né kɔɔ́ mé dé Jâŋ. Bɔ̀ seé mé mè né bɔɔ́ hên, né bɔ̀ seé mé Tele mò haá naâ mè kɔɔ́, bɔ́ né sòn mò kɔɔ́ tueé ŋagá, ye Tele mò lé mè temà naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tele mò mé lé temà naâ mè kɔɔ́, né felè mò ménâ tueé den ndɔ. Bí née hueh seèn mé tie biì ŋgúŋgwéeh ye lòù, ndɔ́g bí née njolo seèn ŋéné ŋgwéeh ye ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bí ŋgòr seèn lè biì sìè kwá ŋgwéh. Lòù sam, nuaá mé à tema njií naâ hên, bí temé yoòr seèn kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Bí mvù Càŋ kwe nyegé gi né dág, ye te bí kwa yɔ̀ŋ tètàgà teèn. Bí kɔ́ɔ ye, bɔ́ jue né mè. ");
INSERT INTO mcu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mé njéh mene, bí gwàn ŋgwéh ká yoòr mò ndeê, te bí kwa yɔ̀ŋ sâ. ");
INSERT INTO mcu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mè *sùsùm beè nuaré déì bíé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mè kɔ cegé né njèh cén ye: bí mé gwaân Càŋ lè sam, ");
INSERT INTO mcu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","wanɔɔ́ŋ Tele mò yeé tema njiî aá mè ká yoòr biì, mè waà, bí mè gwàn ŋgwéh. Nuaré déì yeé waà, baá mé feh seèn tueé gɔ, bí gwaán seér cu bú. ");
INSERT INTO mcu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bí lɔɔ̀ né lieê dé gècên mé né beè Càŋ terrèb, bí lètenè biì fɔɔ́n kuú seér mé lieê dé bɔ̀ nùàr, sâ bí mè gwaán kɔ nde né naàn wa? ");
INSERT INTO mcu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Mé njéh mene, bí té mùnò ye mè nde né bí ké toò Tele mò sií. Músì mé bí né ndèm yoòr seèn kwaá njií, bí sií nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mé gècên mene, mɔ bí sé naâ temé te ŋgòr Músì kwaá njií, bí sé la naâ mè gwaán ndɔ. Lòù sam, Músì lɔ ŋgòr sâ nyagá kuú naâ felè mò. ");
INSERT INTO mcu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mɔ bí biì temé teèn kwá njí ŋgwéh, bí ŋgòr mò gwaán nde né naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jomo sâ Yeésò sela yuo kela yí sòn tub Galilê kèb yagâ. Yilí tub sâ déì né Tiberiâde ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bɔ̀ nùàr ŋgún kem bele cu bú jomo. Lòù sam, bɔ́ lé naâ fém seèn ŋené, à lé naâ bɔ̀ beén bɔ̀ taré sɔm. ");
INSERT INTO mcu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeésò wa, à ŋaá nde ké te kun tòre, bɔ́ bɔ̀ mbɔ̀ŋ seèn den nde doó. ");
INSERT INTO mcu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sâ *Páskà, cieé koô bɔ̀ *Jûf, nde aá feí. ");
INSERT INTO mcu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeésò yeé sɔm njií njolo ter, à ke bɔ̀ nùàr baá ká yoòr seèn kem ndeê, à tueé njií mé Filîp, ye bú a: «Yáb mé nde né bɔ̀ nùà hên koó laré, béh ŋge kwa nde né he wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sâ njií mé à nde né bɔɔ́, à né gi dé seèn kɔɔ́, à tueé ke né dé tueê, te à ŋgweé njií mé Filîp nde né bú tueé. ");
INSERT INTO mcu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filîp deên ndɔ, ye bú a: «Kàgàlɔ̀ŋ dé yáb ŋgeè, te koó bɔ̀ nùà hên la né mene kám yuií fà, wúlú ndé ŋgwéh, nùà kàn hàm njeré déì kwà nyì ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mbɔ̀ŋ seèn cén déì den cuù ndɔ, dé sâ yilí seèn né Andrê, dìm Simɔ̂ŋ-Piêr, ye bú a: ");
INSERT INTO mcu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Huaán déì né lètenè beèh hên teèn, à né mé breêd tîn bɔ̂ ŋgò fà beè. Á, dé sâ seèn mé bɔ̀ nùàr hên bɔɔ́ sɔm nde né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeé baá ménâ, Yeésò ye bɔ́ a: «Bí júée bɔ̀ nùàr a, bɔ́ dèn ndé gí doó.» Nyure lé naâ ké bèh sâ kókoó ndɔ. Bɔ́ den nde gi doó te sòn seèn. Bɔ̀ siíb lé ndeè naâ teèn njèh kám tîn mân. ");
INSERT INTO mcu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeésò weh bɔ̀ breêd doô ndɔ, à vra Càŋ teèn, à geé haá njií mé bɔ̀ɔ́ mé den ndeè naâ doó sâ; à geé haá cu bɔ́ ŋgò ménâ ndɔ. Bɔ́ yieé keéh bèh mé bɔ́ gwaán nê. ");
INSERT INTO mcu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bɔ́ yeé yieé fulu gi aá, ye bɔ̀ mbɔ̀ŋ seèn a: «Bí ŋùàn bílí cú bɔ̀ dé mé leé naâ doô dɔɔ́ŋ, te mbaá vù lè cú.» ");
INSERT INTO mcu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bɔ̀ mbɔ̀ŋ ŋuaán bilí bɔ̀ ndilí breêd tîn jɔ̀gɔ̀ hèllè, yuú sɔgɔ́ yulà cùɔ̀b fà. ");
INSERT INTO mcu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Te bɔ̀ nùàr yeé nde ŋene njií cu baá-re fém mé Yeésò bɔɔ́ naâ doô, bɔ́ tueé njií lom aá bèsɔ́nè mbaá, ye: «Mé gècên mene, nùà hên né *sòn-Càŋ mé bɔ́ lé ye à ndeè né ká lè wɔ́ŋe ndeê doô.» ");
INSERT INTO mcu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeésò ŋene kɔ ndɔ ye, bɔ́ nde né nyí dé terrèb weh, te bɔ́ lobo nyí tì ma. Yeé baá ménâ, à sua yuo lètenè bɔɔ̀n doó sâ mé huún, à ŋaá nde cu ké te kun tòre. ");
INSERT INTO mcu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yeé baá liyilì, bɔ̀ mbɔ̀ŋ seèn suaga nde ké sòn tuùb ndɔ, ");
INSERT INTO mcu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bɔ́ nde yila kɔm, te bɔ́ sela yuo kela tub kèb yágà te lèmè Kapernahûm mân. Sâ cibí yili gi aá kèn, Yeésò née bɔ́ kwà sìè ŋgwéeh ye ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bɔ́ né ka ndeé, fu né lom dùà mé terreb kobó taré yilá, né nòmò dùà dɔɔ́ŋ jilí ŋellé. ");
INSERT INTO mcu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bɔ́ né ka ndeé, bɔ́ kɔgɔ́ yɔŋ kílòmétà tîn mé ténjén, bɔ́ ŋene njií Yeésò, à né ká yoòr bɔɔ̀n felè nòmò gɔ ndeê, à ndeè ká kwarè kɔɔ̀m waâ, sâ bɔ̀ mbɔ̀ŋ nde aá mé veéh kuú. ");
INSERT INTO mcu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","À deên ndɔ, ye bɔ a: «Né mè, bí té vèh!» ");
INSERT INTO mcu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bɔ́ yeé nde aá bú te kɔme weh yií, sâ kɔm hèllè wa gi aá yí sòn ŋgɔ̀m bèh mé bɔ́ nde né teèn sâ. ");
INSERT INTO mcu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cieé ŋaga, bɔ̀ nùàr mé lé cer leé naâ dé bɔɔ̀n yí jomo sòn tuùb kèb yágà doô, ŋene kɔ ndɔ, ye kɔm lé naá cegê doó sâ cén; Yeésò lé teèn yílá ná ŋgwêh, bɔ̀ mbɔ̀ŋ seèn lé mé njéh kèb yágà yila ndeè naâ léláŋ bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sâ bɔ̀ kɔm déì waà baá ndɔ, bɔ́ yuoó naâ lè lɔɔ́ Tiberiâde, bɔ́ né njebá den. Sâ bèh mé bɔ̀ nùàr yieé naâ breêd mé Fehtoò beèh vra naâ Càŋ teèn doô né kèbè sâ. ");
INSERT INTO mcu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bɔ̀ nùàr yeé ke, bɔ́ Yeésò ŋéné cú, bɔ́ bɔ̀ mbɔ̀ŋ seèn ŋéné cú ndɔ, bɔ́ kem yila gi bɔ̀ kɔm dé sâ, bɔ́ nde bú ké Kapernahûm fɔɔ́n. ");
INSERT INTO mcu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bɔ́ wa tub kèb yágà, bɔ́ kwa Yeésò, bɔ́ ye bú a: «Njí fèh-njèh, wò la yeè kèb hên waà heèh ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeésò deên ndɔ, ye bɔ́ a: «Mè né tueé ye bí a, bí mè hên fɔɔ́n kuú né felè breêd mé bí lé naâ yieé doô, dèn ŋgwéh ye bí né fém mò ŋené kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yáb mé nde né mbaá vu yuo, bí té seé seèn bɔ́ dèn, bí bɔ́ sér seé yâb mé nde né ter le. Gèh yáb dé sâ *Huaán Nùàr bí haá nde né kɔɔ́. Lòù sam, Càŋ Tele seèn terreb dɔɔ́ŋ haá kwaá gi aá beè seèn.» ");
INSERT INTO mcu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yeé baá môn, bɔ́ ye bú a: «Béh bɔɔ́ nde né naàn, te yuo faá seé mé Càŋ gwaán nê wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeésò ye bɔ́ a: «Seé mé Càŋ né beè biì gwaán, né temé biì yoòr mò nùà tebê seèn kwaá njiî.» ");
INSERT INTO mcu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bɔ́ ye bú a: «Wò bɔɔ́ feh nde né béh gèh fém dé heè, te béh ŋene kɔ teèn, béh kwaá njií temé yoòr yeè wa? Wò bɔɔ́ weéh nde né gèh seé dé heè ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bɔ̀ tele beèh léí jɔ̀gɔ̀ lé bɔɔ̀n naá giì “*mánà” ké ya dueè yieé; bɔ́ lé nyagá kwaá naâ te mvù Càŋe ménâ, ye: À bɔ́ yáb haá né breêd mé lé yuoó naâ ké te vulúu.» ");
INSERT INTO mcu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeé baá ménâ, Yeésò ye bɔ́ a: «Mè né tueé ye bí a, yáb mé lé yuoó naâ ké te vulúu sâ, Músì lé bí kɔɔ́ há ná ŋgwêh, lé naá seêr Tele mò.» Jomo sâ à ye bɔ́ a: «Tele mò né bí yáb gècên mé yuo né ké te vulúu haá. ");
INSERT INTO mcu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yáb mé Càŋ haá né sâ, né nuaá mé suagà naâ ké te vulúu, à bɔ̀ nùàr yɔ̀ŋ haá né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yeé baá ménâ, bɔ́ ye Yeésò a: «Fehtoò beèh, sâ há dèn ká béh gèh yáb sâ môn.» ");
INSERT INTO mcu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","À deên ndɔ, ye bɔ́ a: «Yáb mé haá né yɔ̀ŋ sâ né mè. Nuaá mé ndeè ká yoòr mò, cùè bú dé seèn sìè ndé cú; nuaá mé né temé yoòr mò kwaá njií, nyúá bú sìè ndé cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mè tueé gi aá bí kèn, bí ŋene gi aá mè kèn ndɔ, mé njéh mene bí temé yoòr mò kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mè tueé bí ndɔ, bɔ̀ɔ́ mé Tele mò ye bɔ́ né bɔ̀ dé mò dɔɔ́ŋ, nde giì né ká yoòr mò ndeê. Bɔ̀ɔ́ mé né ká yoòr mò ndeê sâ, mè cén déì lètenè bɔɔ̀n bèrɔ̀ŋ ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mè ké te vulúu suaga kuú naâ te mè bɔɔ́ njií mé Tele mò mé temà naâ mè gwaán nê. Mè ndé sér ná ŋgwêh te mè bɔɔ́ faá mè gwaán nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nuaá mé temà naâ mè ye mè a: bɔ̀ɔ́ mé né beè mò dɔɔ́ŋ, cén déì a, té teèn lèr lè, wa mè kòmò nyìmè sɔ̀m sér bɔ́ lè cio te cieé cèrè jomò lòù. ");
INSERT INTO mcu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hên né njií mé Tele mò gwaán nê, ye te bɔ̀ɔ́ mé né mè ŋené, mé né gi temé yoòr mò kwaá njií dɔɔ́ŋ, kwa yɔ̀ŋ tètàgà; te mé cieé cèrè jomò mè komo sɔm gi bɔ́ lè cio ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Te bɔ̀ Jûf yeé nde ŋgweé njií mân, bɔ́ ndugó ŋellé doó dɔɔ́ŋ, wa Yeésò la tueé fí ye: nyí né yáb mé lé suagà naâ ké te vulúu. ");
INSERT INTO mcu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bɔ́ ye: «Ŋgweéh hên né ka Yeésò ŋunà Josêf wa? Béh né gi tele mé meí seèn kɔɔ́, à mân tueé né dé keì ye: nyí yuoó naâ ké te vulúu wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeésò tueé njií mé bɔ́ ndɔ, ye bɔ́ a: «Bí kwá lɔ́ ménâ lètenè biì ndugó deèn. ");
INSERT INTO mcu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nuaré déì ká yoòr mò mbaá ndé kòmò ndé ŋgwêh, kɔ Tele mò mé lé temà naâ mè yilá njií né bú ká yoòr mò kɔɔ́, te mé cieé cèrè jomò mè komo sɔm ye bú lè cio. ");
INSERT INTO mcu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bɔ̀ *sòn-Càŋ bɔ̀ lé naá giì te mvù Càŋe nyagá kwaá ye: bɔ́ dɔɔ́ŋ, Càŋ bɔ́ feh nde né kɔɔ́ ma. Sâ mè tueé bí, bɔ̀ɔ́ mé né ndéb Tele mò ŋgweé, mé né gwaán dɔɔ́ŋ, nde giì né ká yoòr mò ndeê. ");
INSERT INTO mcu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sâ túé ŋgwéh ye nuaré déì lé naâ Tele mò mé njolo ŋené ndɔ. Mè tueé bí, nuaá mé lé yuoó naâ dé seèn ké te vulúu Tele mò njolò ŋene cegé né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mé gècên mene: nuaá mé né temé teèn kwaá njií dɔɔ́ŋ baá dé seèn mé yɔ̀ŋ tètàgà. ");
INSERT INTO mcu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mè né yáb mé haá né yɔ̀ŋ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dé bɔ̀ tele biì léí jɔ̀gɔ̀, bɔ́ lé naá menè “*mánà” ké ya dueè yieé, mé njéh mene bɔ́ lé naá giì kuú. ");
INSERT INTO mcu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yáb bú hên dé seèn suagà né ké te vulúu; nuaá mé yieé né bú dé seèn kú ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mè né yáb dé làŋ mé lé suagà naâ ké te vulúu. Nuaá mé né yáb bú hên yieé, den nde né mé yɔ̀ŋ dé ndeèr. Yáb mé mè nde né haá sâ, né ŋgàŋ yoòr mò; mè haá nde né ménâ, te *wɔ́ŋ yili yuo mé njéh.» ");
INSERT INTO mcu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Te bɔ̀ Jûf yeé nde ŋgweé njií cu mân, bɔ́ ŋaáŋ ŋeí cu ye baá-re mé njéh lètenè bɔɔ̀n dé ŋaâŋ, ye: «Nùà hên béh ŋgàŋ yoòr seèn haá seér nde né naàn, te béh yieé wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Bɔ́ yeé baá ménâ bieé kuú den, Yeésò deên ndɔ, ye bɔ́ a: «Mè né tueé ye bí a, mɔ bí ŋgàŋ yoòr *Huaán Nùàr yíé ŋgwéh, bí húɔ́m seèn ŋúé ŋgwéh, sâ bí mé yɔ̀ŋ sam ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nuaá mé né dé seèn ŋgàŋ yoòr mò yieé, né húɔ́m mò ŋueé, né dé seèn mé yɔ̀ŋ tètàgà teèn; sâ lè cieé cèrè jomò mè nde né bú te cio komo sɔm. ");
INSERT INTO mcu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Lòù sam, núɔ́gɔ́ mò né yáb dé gècên, húɔ́m mò né mbè dé gècên ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nuaá mé né núɔ́gɔ́ mò yieé, né húɔ́m mò ŋueé, nyɔgɔ́ nde aá yoòr mò, sâ mè nyɔgɔ́ nde aá yoòr seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tele mò mé tema njií naâ mè né làŋ; ká yoòr mò hên né yɔ̀ŋ seèn. Né kèì cén mé nuaá mé yieé né mè, à né mé yɔ̀ŋ mò yoòr seèn ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yáb mé suagà naâ ké te vulúu né hên; à dé seèn faá dé mé bɔ̀ tele biì léí jɔ̀gɔ̀ lé yieé naâ doô sam, bɔ́ lé naâ kuú gií. Dé yáb bú hên, nuaá mé yieé bú nde né làŋ dé kèì cên yili den.» ");
INSERT INTO mcu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeésò lé ŋgòr hên dɔɔ́ŋ tueé deén naâ ké Kapernahûm, sâ à né bɔ́ njèh ké *gwà sóù feh. ");
INSERT INTO mcu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bɔ̀ mbɔ̀ŋ Yeésò kókoó mbaá yeé ŋgweé aá ménâ, bɔ́ ye: «Ŋgòr hên né taré; neì seèn dé sâ gwaán nde né kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sâ Yeésò kɔ gi aá, ye bɔ̀ mbɔ̀ŋ né mé ŋgòr hên ndugó ndɔ, à bie njií ye bɔ́ a: «Né bí sieé wa? ");
INSERT INTO mcu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Á, mɔ bí ndeè ŋene *Huaán Nùàr baá ké te bèh mé à lé yuoó naâ teèn ŋaá ndeé nɔ, den nde né naàn wa? ");
INSERT INTO mcu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Cúcuí Càŋ yɔ̀ŋ haá yeé kɔɔ́; núɔ́gɔ́ dé seèn né njèh mbaâ. Bɔ̀ ŋgòr mé la yuoó naâ sònò mò hên né gi bɔ̀ ŋgòr mé Cúcuí Càŋ né teèn, bɔ́ nùàr yɔ̀ŋ haá né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mé njéh mene, bɔ̀ déì lètenè biì temé teèn kwá njí ŋgwéh.» Sâ bèh lɔ mé yuoô ké bèh duɔɔ̂m, bɔ̀ɔ́ mé temé teèn kwá njí ŋgwéh dɔɔ́ŋ, Yeésò né gi bɔ́ ŋené kɔɔ́; né mene nuaá mé nde né bú cie sar kwaá, à né gi bú ŋené kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yeé baá ménâ, ye bɔ́ a: «Mè la bí hên tueé naâ dé cî, ye bí a: nuaré déì ká yoòr mò mbaá ndé kòmò ndé ŋgwêh; kɔ Tele mò haá né bú terreb kɔɔ́, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bɔ̀ mbɔ̀ŋ seèn kókoó yeé ŋgweé aá môn, bɔ́ suaré yuo gi, bɔ́ kwaá lɔ bú. ");
INSERT INTO mcu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeésò deén baá-re ndɔ, ye bɔ̀ mbɔ̀ŋ dé yulà cùɔ̀b fà doô a: «Mé bí mene, bí nde né yuo gií ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔ̂ŋ Piêr ye bú a: «Béh dé beèh toò nde ser cu nde né yoòr neì wa, Fehtoò beèh? Ŋgweéh bɔ̀ ŋgòr yɔ̀ŋ tètàgà né gi beè yeè mà. ");
INSERT INTO mcu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kènê béh dé beèh temé kwaá njií gi né yoòr yeè, béh né gi kɔɔ́ ye wò dé yeè né ŋagásé, wò yuoó naâ beè Càŋ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeésò ye bɔ́ a: «Mè lé bí bɔ̀ yulà cùɔ̀b fà bɔ̀ hên kɔɔ́ bàlè wèh ná ŋgwêh wa? Mé njéh mene, cén déì lètenè biì né táhòrò!» ");
INSERT INTO mcu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sâ à ménâ jue né Júdàs ŋunà Simɔ̂ŋ Iskariô. Lòù sam, gwaán Júdàs né mene lètenè bɔ̀ mbɔ̀ŋ yulà cùɔ̀b fà doô, à Yeésò cie sar sɔm nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jomo sâ Yeésò nde tàbè Galilê beè yɔŋ sie ndɔ, à gwàn cú te tàbè Judê yɔŋ deèn. Lòù sam, bɔ̀ *Jûf lé naâ bú ké teèn filí, ye te bɔ́ wula sɔm bú. ");
INSERT INTO mcu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sâ cieé koô bɔ̀ Jûf déì nde aá feí ndɔ; bɔ́ cieé koô sâ yieé yeé ka pàgà. ");
INSERT INTO mcu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yeé baá ndeê, bɔ̀ dìm ye bú a: «Yùò doó hên yuoò, ndé ké Judê, te bɔ̀ mbɔ̀ŋ yeè ŋene weh seé yeè teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nuaá mé gwaán né bèsɔ́nè ŋené yuo kelâ, njèh lòù bɔ́ lèr bèh. Sâ mɔ wò né fém bɔɔ́, bɔ́ ndé mé njéh bèh dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sâ né mene bɔ̀ dìm, bɔ́ lé temé yoòr seèn kwá njí ná ŋgwêh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bɔ́ yeé tueé aá ménâ, Yeésò ye bɔ́ a: «Cu mò née wúlú ŋgwéeh ye; dé biì cu dɔɔ́ŋ né gi beè biì. ");
INSERT INTO mcu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dé biì, *wɔ́ŋ bí bùnò ndé ŋgwéh, wɔ́ŋ bunó seér né mè; wɔ́ŋ ye mè la tueé ŋagá naâ bèsɔ́nè, ye seé nyî né seé veên fí. ");
INSERT INTO mcu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bí ndé dé biì cieé koô yieé, mè ké teèn ndé ndé ŋgwéh; cu mò née wá ŋgwéeh ye.» ");
INSERT INTO mcu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","À yeé tueé sɔm aá mân, à den le ŋgɔgɔ́ ké Galilê sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bɔ̀ dìm yeé nde aá bèh cieé koô sâ, Yeésò nde teèn ndɔ, à nab wa seér dé seèn ké teèn lòù, te bɔ̀ nùàr bú ŋéné cú. ");
INSERT INTO mcu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sâ bɔ̀ Jûf hèllè baá bú te cieé koô sâ fɔɔ́n ndɔ; bɔ́ né sònò bieé gɔ ye: à né he wee? ");
INSERT INTO mcu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bɔ́ né lom njèh felè seèn lètenè bɔ̀ nùàr bieé namé gɔ. Bɔ̀ déì ye: né nùà bagaà; bɔ̀ déì ye: sam, à bele den né bɔ̀ nùàr lòù. ");
INSERT INTO mcu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nuaá mé nde né felè seèn bèsɔ́nè tueé sɔm sam ndɔ, bɔ́ bɔɔ̀n né-re bɔ̀ Jûf dé kokoô veéh nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cieé koô yeé baá lèbɔ̂lé, Yeésò ŋaá yila ké *gwà Càŋ koô, à duɔɔ̂m njèh feèh. ");
INSERT INTO mcu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bɔ̀ Jûf yeé ŋgweé aá ménâ, bɔ́ geí seér lòù, bɔ́ ye: «Bí kè kú nùà hên kán, à lé *sóú jáŋé ná ŋgwêh, à sóú kɔ né mé ŋgei wa?» ");
INSERT INTO mcu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeésò ye bɔ́ a: «Mè mé lèì mò túé ŋgwéh, yuo né sònò Càŋ nuaá mé lé tema naâ mè, ye mè a, ndê bí mân feh. ");
INSERT INTO mcu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nuaá mé né faá Càŋ gwaán nê nɔ bɔɔ́, nde né mè ŋené kɔɔ́; né mene seé dé Càŋ, né mene seé kwaâ mò, à nde né dé seèn ŋené kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mè tueé bí, nuaá mé né ŋgòr kwaâ felè seèn tueé kwaá dɔɔ́ŋ, mé njéh fɔɔ́n né yilí seèn. Nuaá mé dé seèn ŋgòr kwaâ tueé njií seér né yoòr nuaá mé temà naâ bú, seé dé seèn né dilísé, né nùà jéjêg, à dé seèn ŋgòr kwaâ tueé kuú né dé nùà koô seèn. ");
INSERT INTO mcu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ŋgweéh Músì lé bí sóú taga lɔɔ̀ naâ kɔɔ́ wa? Hên nuaré déì né sóú sâ lètenè biì jolo ke wa? Á, dé bí gɔŋ né mè, te bí wula sɔm mè doô nɔ?» ");
INSERT INTO mcu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bɔ̀ nùàr yeé nde ŋgweé cu mân, bɔ́ ye bú a: «Wò né mé tándulu yoòr, wanɔɔ́ŋ neì feh yeè fɔɔ́n né kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeésò ye bɔ́ a: «Mè lé naâ seé cén bɔɔ́, lé naâ *cieé sóù, bí lé naá giì mé njéh ŋaáŋ ndɔ! ");
INSERT INTO mcu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ŋgweéh Músì lé naâ bí sóú taga lɔɔ́, ye bí ŋɔ́b bɔ̀ huaán dé sisiîb *ŋgór ŋɔɔ̀b wa? Sâ Músì hèllè lé kɔɔ́ sì ná ŋgwêh ndɔ, né ka tabɔ́ bɔ̀ tele biì léí jɔ̀gɔ̀. Bí yeé ŋgweé gi aá sóú sâ, ŋgweéh bí ye bɔ́ ŋɔ́b bílí bɔ̀ nùàr ŋgór mé cieé sóù mene wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mɔ bí nùàr ŋgór mé loù sóù mene ŋɔɔ́b bilí né, te bí sóú Músì ŋgén cú, sâ mè yeé yili sɔm gùm nùàr dɔɔ́ŋ loù sóù, bí mè yoòr furú kuú né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mè tueé bí, bí té njèh mé njolo kèb cieè mbaá ŋéné njí, bí tena ju cebâ; bí ŋá sér bɔ̀ gècên bɔ̀, bí tena yií ju teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yeé baá ménâ, bɔ̀ Jerusalem bɔ̀ déì yila lètenè bɔɔ̀n tueê ndɔ ye: «Ŋgweéh hên tueé den né nuaá mé bɔ́ jue bɔ́ nde né bú wulá doô wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kè cú-re, à né sòn mé feh seèn tueé den, bɔ́ bú njeré déì bɔ́ cú! Hên bɔ̀ kokoô bɔ̀ beèh né kɔɔ́ ye nùà hên né *Nùà Cɔ̀ŋ bɔ̀n wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Loù mé Nùà Cɔ̀ŋ wa ndeè né teèn, nuaré déì bèh yuoô seèn kɔ́ sɔ̀m ndé ŋgwéh. Ŋgweéh dé nùà hên béh né gi bèh yuoô seèn kɔɔ́ mà.» ");
INSERT INTO mcu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Te Yeésò yeé baá njèh ké *gwà Càŋ koô feh, à lɔgɔ njií ye baá-re ké ter, ye bɔ́ a: «Bí ye bí né gi mè kɔɔ́ á? Wa bí né gi bèh yuoô mò kɔɔ́ ndɔ sé wa? Mè mé feh mò ndé ná ŋgwêh, nùà gècên mè tema naâ kɔɔ́. Bí bú kɔ́ ŋgwéh lòù, ");
INSERT INTO mcu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","mè dé mò né bú kɔɔ́. Lòù sam, mè lé yuoó naâ ké beè seèn, à mè tema njií naâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yeé baá ménâ, bɔ́ yila lom baá-re bú gɔɔ̀ŋ, te bɔ́ sie bú. Njèh cén, cu seèn lé née wúlú ŋgwéeh ye, bɔ́ bú sìè kwà ŋgwéh mé njéh. ");
INSERT INTO mcu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sâ ké lètenè cìlì nùàr bɔ̀ɔ́ mé né temé yoòr seèn kwaá njií lé naâ ŋgún; bɔ́ né sònò tueé den ye: «Mɔ Nùà Cɔ̀ŋ sâ ndeè né mene waâ, à bɔɔ́ cu nde né gèh fém dé heè mé nùà hên née bɔ́ ŋgwéeh ye wa?» ");
INSERT INTO mcu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bɔ̀ nùàr yeé baá felè seèn ké lètenè cìlì nùàr mân namé den, nde die yila tieè bɔ̀ *Farisiên ndɔ. Bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ Farisiên tema njií baá-re bɔ̀ sɔ́jì ké teèn, te bɔ́ nde bú sie wellê. ");
INSERT INTO mcu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","À yeé ŋene aá bɔ́, ye bɔ̀ nùàr a: «Dé kènê béh bí dèn màgà ndé cú, sâ mè nde cu aá ké yoòr nuaá mé lé tema njií naâ mè. ");
INSERT INTO mcu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bí nde né mè fɔɔ́n; njèh cén, bí mè kwà ndé cú. Lòù sam, bí ké bèh denè mò wá kòmò ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bɔ̀ Jûf yila ké lètenè bɔɔ̀n bieé kuú, ye: «À nde cu né he, mé béh bú ŋéné kwà ndé cú wa? À dé sâ nde né bɔ̀ Jûf ké lètenè bɔ̀ Greêk kwa wa? À nde né bɔ̀ Greêk njèh feh ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wanɔɔ́ŋ sâ à tueé né kei, mé ye: béh nde né nyí fɔɔ́n, njèh cén, béh nyí kwà ndé cú? wa lòù sam, béh ké bèh denè nyî wá kòmò ndé ŋgwéh, sâ à jue né kei?» ");
INSERT INTO mcu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Loù mé cieé koô sâ ceré yeé teèn, kela seér yeé kɔɔ́. Loù sâ Yeésò lé naâ ter wuo njebá, à lɔgɔ njií ké ter ye bɔ̀ nùàr a: «Mɔ nuaré déì né mé nyúá, bú a, ndê ká yoòr mò, à ŋueé kwa nòmò. ");
INSERT INTO mcu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nuaá mé né temé yoòr mò kwaá njií dɔɔ́ŋ, nòmò yɔ̀ŋ nde né lè seèn kwaré yuo den, faá bɔ́ nyagá kwaá né te mvù Càŋe nɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sâ Yeésò ménâ jue né Cúcuí Càŋ; wa bɔ̀ɔ́ mé né temé yoòr nyî kwaá njií, nde né bú kwa ma. À lé ménâ tueé den née, sâ Càŋ lé née Cúcuí seèn témá njí ŋgwéeh ye; cu sâ terreb Yeésò lé née bèsɔ́nè ŋéné ŋágá ŋgwéeh ye ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cìlì nùàr yeé nde ŋgweé njií mân, bɔ̀ déì ye: «Mé gècên mene, nùà hên né lom *sòn-Càŋ bú sâ.» ");
INSERT INTO mcu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bɔ̀ déì ye: «Né *Nùà Cɔ̀ŋ!» Bɔ̀ déì den seér cuù ye: «Nùà Cɔ̀ŋ yuo seér ndeè né ké Galilê naàn? ");
INSERT INTO mcu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Né te mvù Càŋe nyagá den ye: Nùà Cɔ̀ŋ nde né *ndùté ndùtù Davîd, ye à yuo ndeè né ké Betelehem lɔ Davîd. Lɔɔ́ Davîd baá cu ké Galilê wa?» ");
INSERT INTO mcu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yeé baá mân, cìlì nùàr kɔb geé hihiné felè Yeésò. ");
INSERT INTO mcu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Teèn sâ, bɔ̀ déì ye, kɔ bɔ́ sie bú sieè; mé njéh mene, bɔ́ bú be yoòr njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bɔ̀ sɔ́jì cu cu ké jomo yoòr bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ *Farisiên ndɔ. Wa ké jomo, bɔ̀ kokoô bɔ̀ doô ye bɔ́ a: «Bɔɔ́ né naàn mé bí mé bú sìè wá ŋgwêh wa?» ");
INSERT INTO mcu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bɔ̀ sɔ́jì ye bɔ́ a: «Béh tueé bí, nuaá mé nde né faá nùà sâ tueé kɔɔ́ teèn sam gùm dɔɔ́ŋ!» ");
INSERT INTO mcu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bɔ̀ Farisiên ye bɔ̀ sɔ́jì a: «Bɔ́ ké teèn sâ bele weéh cu aá mé bí mene ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bí ŋene ŋgàŋ sèmè cén déì, wa né Farisiên cén déì lètenè beèh né temé yoòr seèn kwaá njií wa? ");
INSERT INTO mcu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Cìlì nùàr seér *sóú Músì kɔ́ ŋgwéh lòù, né bɔ̀ dúágá-tie bɔ̀!» ");
INSERT INTO mcu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Sâ Níkòdêm mé lé ndeè naâ cu déì ké yoòr Yeésò njèh bieé nyegé doô né doó sâ, à né Farisiên faá bɔ́ nɔ, à deên ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Né faá sóú beèh tueé yeé nɔ: ye mɔ bɔ́ née ju felè nùàr bàlè ŋgwéeh ye, béh té ju felè seèn mbaá téná.» ");
INSERT INTO mcu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bɔ́ deên ye bú a: «Wò né nùà Galilê ndɔ wa, né kei? Ndé mvù jaŋé nyegé, wò beré déì ŋéné ndé ŋgwéh ye sòn-Càŋ déì yuo ndeè né Galilê.»  ");
INSERT INTO mcu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jomo sâ nùà kàn fɔɔ́n gò gwò seèn. ");
INSERT INTO mcu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeésò dé seèn ŋaá nde ké te tòr Oliviê. ");
INSERT INTO mcu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cieé ŋaga maánjɔ̀gɔ̀ à komo cu cuù ká *gwà Càŋ koô. Cìlì nùàr bilí wa cuù kwarè seèn ŋgún. À den nde doó, á yila cu njèh feèh. ");
INSERT INTO mcu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bɔ̀ *njí-sóù mé bɔ̀ *Farisiên weh waà mé ma déì, bɔ́ njebá kwaá bú toò bɔ̀ nùàr, sâ bɔ́ la naâ ma hèllè te yàga sie lɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bɔ́ bie njií ye Yeésò a: «Nùà fèh-njèh, bɔ́ la naâ ma hên te yàga sie. ");
INSERT INTO mcu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Músì lé naâ béh sóú taga lɔɔ́, ye gèh bɔ̀ véh mé né mân bɔɔ́ dɔɔ́ŋ, béh tɔ̀bè wúlá bɔ́ tɔbè ma. Á wò nɔ, wò ye naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sâ bɔ́ Yeésò tab gi né lòù te bɔ́ sie bú teèn. À yeé ŋgweé aá ménâ, à geér nde doó, à né njií te tàbe mé nyɔ̀gɔ̀ beè nyagá den. ");
INSERT INTO mcu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bɔ́ yeé baá bú méménâ bieé ndeé den, à komo sɔm feh ter, ye bɔ́ a: «Lètenè biì, nuaá mé née dé seèn veên bɔ́ ŋgúŋgwéeh ye, bú a, ndé tɔ̀b njí lɔ́gɔ ma hên taá yoòr kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","À yeé tueé gi aá mân, à geér nde cu doó, à yila cu njèh te tàbe mé nyɔ̀gɔ̀ beè nyagâ. ");
INSERT INTO mcu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bɔ́ yeé ŋgweé aá mân, bɔ́ duɔɔ̂m cécéné cécéné suaré yuoò; duɔɔ́m mé bɔ̀ bei, nde ceré mé bɔ̀ dé memanè. Bɔ́ yuo gi ndɔ, Yeésò bɔ̂ ma doô le lom fà, à né toò Yeésò njebá den. ");
INSERT INTO mcu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeésò komo wuo cu ter, ye ma doô a: «Dé vêh, bɔ́ baá gi he wa? Nuaré déì wò sìè cú wa?» ");
INSERT INTO mcu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ye Yeésò a: «Mè jue mene nuaré déì, Nùà fèh-njèh!» Yeésò ye bú a: «Sâ mè wò sìè ndé ŋgwéh ndɔ, ndé cú njií yeè lɔ. Njèh cén, té veên bɔ́ cú». ");
INSERT INTO mcu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeésò tueé njií cu mé bɔ̀ nùàr, ye bɔ́ a: «Ŋagâ ká te wɔ̂ŋ né mè. Nuaá mé né jomo mò bele dé seèn bèh cibì gɔ̀ ndé cú, à gɔ seér nde né bèh ŋagâ. Lòù sam, ŋagâ né bú yɔ̀ŋ haá.» ");
INSERT INTO mcu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bɔ̀ *Farisiên yeé nde ŋgweé cu ménâ, bɔ́ ye bú a: «Wò sâ tueé den né sòn yeè mé be yeè, bɔ̀ njií mé wò né tueé sâ, né gi dé mbaâ.» ");
INSERT INTO mcu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeésò ye bɔ́ a: «Mè la né mene sòn mò mé be mò tueé dɔɔ́ŋ, mè tueé gi né bɔ̀ njèh dé gècên. Lòù sam, mè né dé mò bèh yuoô mò kɔɔ́, mè né bèh ndeê mò kɔɔ́ ndɔ. Bí bèh yuoô mò mé bèh ndeê mò kɔ́ ŋgwéh kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bí tueé den né ju faá bɔ̀ nùàr tueé yeé nɔ; mè dé mò ju felè nuaré déì téná bèh. ");
INSERT INTO mcu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Á, mɔ ye mè a, téná ju ndɔ, sâ mè nde né ju tená ŋgulí. Lòù sam, mè mé huún mò sam, bêh Tele mò mé lé temà naâ mè né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Né te mvù biì soú den ye: mɔ nùà fà bɔ̂ mbeí tueé gi né felè njeré déì mé sòn cên, sâ njií sâ né lom môn ma. ");
INSERT INTO mcu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mè né sòn mò mé be mò tueé; Tele mò mé lé temà naâ mè sòn mò tueé cu né ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bɔ́ ye bú a: «Tele yeè né he wa?» À ye bɔ́ a: «Bí mè kɔ́ ŋgwéh, bí Tele mò kɔ́ ŋgwéh ndɔ. Mɔ bí sé la né mè kɔɔ́, bí sé la né Tele mò kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeésò lé bɔ́ mân tueé deén naâ sâ à né ké *gwà Càŋ koô bèh mé fer kàgàlɔ̀ŋ né teèn, à né bɔ́ njèh feh. Mé njéh mene, nuaré déì lé bú sìè ná ŋgwêh. Lòù sam, cu seèn lé née wá ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeésò den cuù ye bɔ́ a: «Mè nde né ndeé. Mɔ mè nde aá, bí nde né mè fɔɔ́n, bí mè ŋéné ndé ŋgwéh, bí nde né mé veên biì mbaán kuú. Ké bèh denè mò bí wá kòmò ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bɔ̀ *Jûf duɔɔ̂m baá-re lètenè bɔɔ̀n tueé kuû ye: «Sâ à nde né feh seèn wulá, wanɔɔ́ŋ à ye, béh ké bèh denè nyî wá kòmò ndé ŋgwéh mé ŋgei?» ");
INSERT INTO mcu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeésò deên ndɔ, ye bɔ́ a: «Dé biì bí né bɔ̀ ká doô bɔ̀, mè dé mò lé yuoó naâ ké te vulúu. Bí né dé biì bɔ̀ *wɔ́ŋ bɔ̀, mè dé mò nùà wɔ̂ŋ sam. ");
INSERT INTO mcu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mè la jueè naâ dé cî, ye bí a: bí nde né mé veên biì mbaán kuú. Mɔ bí temé kwá njí ŋgwéh, ye né mè sâ, bí nde né mé veên biì mbaán kuú, mè tueé bí.» ");
INSERT INTO mcu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bɔ́ ye bú a: «Wò né neì wa?» Ye bɔ́ a: «Mè né mè, nuaá mé mè lé naâ bí ké bèh duɔɔ̂m tueé sâ. ");
INSERT INTO mcu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mè né mé njèh tueê felè biì mé ju mene kókoó. Bí kɔ́ɔ ye, nuaá mé lé temà naâ mè dé seèn né nùà gècên; mè bɔ̀ nùàr ká te wɔ̂ŋ hên tueé lom né njií mé mè né sònò seèn ŋgweé.» ");
INSERT INTO mcu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bɔ́ lom ŋgwé kòmò ŋgwéh, ye à sâ jue né Tele seèn. ");
INSERT INTO mcu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Te à den cuù ye baá-re, ye bɔ́ a: «Mɔ bí ndeè sɔm njií aá *Huaán Nùàr ter, bí nde né cu sâ kɔɔ́ ye né mè, nuaá mé né nùà sâ ma; bí nde né kɔɔ́ ye, mè njèh mé feh mò bɔ́ bèh; bí kɔ nde né ye, mè tueé lom né njií mé Tele mò lé naâ mè feh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","À lé mè temà naâ kɔɔ́, à mè mé huún kwá lɔ́ ŋgwéh, béh bú né kɔɔ́. Lòù sam, mè cu dɔɔ́ŋ bɔɔ́ lom né njií mé né bú yoòr huɔɔ́m.» ");
INSERT INTO mcu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","À yeé baá mân tueé, bɔ̀ nùàr kókoó mbaá kwaá njií gi temé yoòr seèn. ");
INSERT INTO mcu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeé baá ménâ, Yeésò tueé njií mé bɔ̀ Jûf mé né temé yoòr seèn kwaá njií, ye bɔ́ a: «Mɔ bí né ndéb mò jolo nyegé, sâ mé gècên mene bí né bɔ̀ mbɔ̀ŋ mò; ");
INSERT INTO mcu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","bí nde né gècên ŋené kɔɔ́, te bí ŋa seér bɔ̀ɔ́ mé den né mé feh bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bɔ́ ye bú a: «Béh né bɔ̀ ndùté ndùtù Abrahâm, ndɔ́g béh lé née kwer nuaré déì dèn ŋgúŋgwéeh ye. Naàn mé wò ye béh a: te béh ŋa seér bɔ̀ɔ́ mé den né mé feh bɔɔ̀n wa?» ");
INSERT INTO mcu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeésò ye bɔ́ a: «Mè né tueé ye bí a: nuaá mé né veên bɔɔ́ dɔɔ́ŋ né kwer veên. ");
INSERT INTO mcu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kwer dé seèn huaán lɔɔ̂ ŋá bèh, à mé bèh denè te mbàgà sam; bèh denè te mbàgà cu dɔɔ́ŋ né dé huaân. ");
INSERT INTO mcu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mɔ Huaán bí mé feh biì sɔm kwaá né kɔɔ́, sâ mé gècên mene bí baá mé feh biì. ");
INSERT INTO mcu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mè né gi kɔɔ́ ye bí né bɔ̀ ndùté ndùtù Abrahâm; mé njéh mene bí tie te ndéb mò félá njí ŋgwéh, bí gwaán seér né mè wulâ. ");
INSERT INTO mcu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mè dé mò tueé né njií mé Tele mò feh né mè; bí dé biì bɔɔ́ seér njií mé tele biì né bí tueé.» ");
INSERT INTO mcu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bɔ́ ye bú a: «Tele beèh né Abrahâm.» Yeésò deên ye bɔ́ a: «Mɔ bí sé né bɔ̀ ŋunà Abrahâm bɔ̀n, seé mé Abrahâm lé bɔɔ́ naâ doô, bí sé naâ cí bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wanɔɔ́ŋ mè né gècên sònò Càŋ ŋgweé, mè yeé tueé bí, bí ye, kɔ bí wula cu mè nɔ. Abrahâm lé naâ gèh dé sâ bɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mè tueé bí, bí nág bɔɔ́ cu né faá tele biì nɔ.» Bɔ́ ye bú a: «Dé beèh, béh bɔ̀ huaán cieè sam, tele beèh né lom cén, né Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeésò ye bɔ́ a: «Mɔ tele biì sé né Càŋ bɔ̀n, bí sé la né mè gwaán; mè yuoó naâ ké beè Càŋ, mè hên né te sòn seèn, mè lé mé feh mò ndé ná ŋgwêh, à mè tema njií naâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bí ŋgòr mò ŋgwé kòmò ŋgwéh dé keì? Bí yeé tie teèn félá njí cú, yɔgɔ́ baá-re bí ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dé biì, tele biì né *Sátàn, bí bɔɔ́ né seé mé tele biì hèllè gwaán né sâ. À né nùà wúlá-feèh, à mé njéh yuoó naâ ké bèh duɔɔ̂m. À te gècéne njébá nyì bèh, à mé gècên yoòr sam. Né nùà nyeên; nyeén né bú lè húɔ́me, dàm bɔ̀ nyeên dɔɔ́ŋ ceré né sâ. ");
INSERT INTO mcu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mè dé mò tueé lom né gècên, bí temé yoòr mò kwá njí ŋgwéh dé cî. ");
INSERT INTO mcu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Lètenè biì sâ nuaá mé nde né be ter sɔm njií, ye mè né mé veên yoòr ndɔ, né neì wa? Á, mɔ mè tueé né gècên, bɔɔ́ né naàn mé bí temé yoòr mò kwá njí ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuaá mé né beè Càŋ, né yeé dé seèn ŋgòr Càŋ ŋgweé. Bí dé biì te gà Càŋe sam, bí ŋgòr Càŋ ŋgúŋgwéh dé cî.» ");
INSERT INTO mcu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bɔ̀ Jûf deên ye bú a: «Béh naâ tueé, ye wò né nùà *Samarî, wò yoòr né mé tándulu, wò ye béh teèn túé yí ŋgwéh á?» ");
INSERT INTO mcu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeésò ye bɔ́ a: «Mè mé tándulu yoòr sam lág; bí mè seb seér né kɔɔ́, wanɔɔ́ŋ mè né Tele mò seén. ");
INSERT INTO mcu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mè túé ŋgwéh ye bɔ̀ nùàr a, sén mè seèn. Nuaá mé nde né mè seén né teèn, à ju tena nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mè né tueé ye bí a, nuaá mé né ŋgòr mò jolo, dé seèn kú ndé ŋgwéh ndɔ́g.» ");
INSERT INTO mcu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bɔ̀ Jûf yeé nde ŋgweé cu dé sâ mân, bɔ́ ye bú a: «La né bɔ̀n, béh kɔ nyegé baá kènê ye wò né mé tándulu yoòr, wanɔɔ́ŋ Abrahâm lé seèn naâ kuú, bɔ̀ *sòn-Càŋ bɔ̀ kuú gi ndɔ; wò yeé waà dé yeè kènê, wò ye: nuaá mé né ŋgòr nyî jolo, nùà sâ dé seèn kú ndé cú sé wa? ");
INSERT INTO mcu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wò ye nyí né Abrahâm tele beèh mé bɔ̀ sòn-Càŋ bɔ̀ yɔgɔ́ wa? Á, bɔ́ lé bɔɔ̀n naá giì kuú nɔ? Wò hên, wò feh yeè weh kwaá né faá neì wee?» ");
INSERT INTO mcu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeésò ye bɔ́ a: «Mɔ mè sé né yo mò mé be mò seén, sâ mè sé bú seén kuú né dé mbaâ. Nuaá mé né mè seén né teèn, né Tele mò; né nuaá mé bí né gi tueé ye: né Càŋ biì, ");
INSERT INTO mcu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","mé njéh mene, bí bú kɔ́ ŋgwéh doô. Mè né bú dé mò kɔɔ́. Mɔ mè sé ye, mè bú kɔ́ ŋgwéh, mè sé né nùà nyeên faá bí nɔ. Mè dé mò né bú kɔɔ́, mè né ŋgòr seèn jolo. ");
INSERT INTO mcu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abrahâm tele biì lé naá loôm mé vɔ́gɔ́-temé, ye nyí nde né cieé mò ŋené. À lé naâ cieé sâ ŋené, à vra lom mé gècên mene.» ");
INSERT INTO mcu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bɔ̀ Jûf deên ye bú a: «Wò née yeè nyèmà yulà tîn yíé ŋgwéeh ye, wò lé naâ Abrahâm ŋené ŋgweé wa?» ");
INSERT INTO mcu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeésò ye bɔ́ a: «Mè né tueé ye bí a: mé bɔ́ lɔ nde Abrahâm ŋar, sâ mè baá giì teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Te bɔ́ yeé nde ŋgweé njií cu dé sâ mân, bɔ́ duɔɔ̂m taá domô, te bɔ́ tɔbé bú mé njéh; à leér yuo, à yuo kela sa lè *gwà Càŋ koô sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yeésò yeé baá beré déì kelá, à ŋene njií tácugó déì, à lé mé njéh yuoó naâ lè. ");
INSERT INTO mcu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bɔ̀ mbɔ̀ŋ Yeésò yeé ŋene aá ménâ, bɔ́ ye Yeésò a: «Nùà fèh-njèh, hên bɔɔ́ né naàn mé nùà hên yuoô dé seèn lè mé njolo cugó wa? Né mé yìè veên seèn nùà njèh, wa né felè veên tele bɔ̂ meí seèn wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeésò ye bɔ́ a: «Mé yìè veên seèn sam, dé bɔ̀ tele bɔ̂ meî sam ndɔ. À cugó né mân, te seé Càŋ ŋené yuo kelà cie teèn. ");
INSERT INTO mcu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Keí mé née suútenè hên, kɔ béh bɔɔ́ mboón seé nuaá mé temà naâ mè. Cibí baá ndeê; mɔ waà baá, nuaré déì seé cíbíteèn bɔ́ ndé cú. ");
INSERT INTO mcu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Keí mé mè née ká te wɔ̂ŋ mân, ŋagâ teèn né mè.» ");
INSERT INTO mcu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","À yeé tueé sɔm aá, à kulu njií dèh doó, à huaán cà mé dèh, à luaré njií tácugó hèllè njolò, ");
INSERT INTO mcu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ye bú a: «Ndé njolo yí te nòmò Siloê vuaá njií.» Siloê tueé né ye: né yɔ́gɔ́ nòmò. Tácugó doô nde bèh njolo vuaá wellê ndɔ, à cu cuù, sâ à baá njolo ŋené. ");
INSERT INTO mcu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bɔ̀ mbeí seèn bɔ́ bɔ̀ɔ́ mé à lé dua beéh njèh njolò bɔɔ̀n, yeé nde ŋene njií bú ménâ, bɔ́ ye: «Ŋgweéh hên né nuaá mé lé dua den beéh njèh mé tií doô wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bɔ̀ déì ye: né bú; bɔ̀ déì ye: bú sam, felá né bú lòù. Nùà hèllè ye bɔ́ a: «Né ka mè.» ");
INSERT INTO mcu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bɔ́ ye bú a: «Bɔɔ́ naâ naàn mé njolo yeè komo cu wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ye bɔ́ a: «Nuaá mé bɔ́ yilá yeé Yeésò doô huaán naâ cà, à luaré njií mè njolò, ye mè a: ndé njolo yí te nòmò Siloê vuaá wellê ma. Mè nde baá-re ndɔ; mè yeé vua gi aá, mè ke, njolo baá ŋené.» ");
INSERT INTO mcu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bɔ́ ye bú a: «Nùà sâ né he wa?» Ye bɔ́ a: «Mè kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bɔ́ weh njií nuaá mé la taré yuoó naâ doô ké toò bɔ̀ Farisiên ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sâ Yeésò lé cà huaán naâ loù sóù, à taré sɔm bú mé njéh. ");
INSERT INTO mcu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bɔ́ yeé baá toò bɔ̀ Farisiên, bɔ̀ Farisiên bie ŋgweé nyegé mé sòn bɔɔ̀n ndɔ, ye nùà doô a: «Bɔɔ́ naâ naàn mé wò kwa njolo wa?» À ye bɔ́ a: «À luaré njií naâ mè cà njolò, mè vua sɔm njolo ndɔ; mè yeé ke, mè baá ŋené.» ");
INSERT INTO mcu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bɔ̀ Farisiên déì yila baá-re tueé deèn ye: «Nuaá mé bɔɔ́ naâ njií hên dé seèn beè Càŋ yùò ná ŋgwêh, wanɔɔ́ŋ à seèn *cieé sóù jòlò ŋgwéh nɔ.» Bɔ̀ déì ye: «Mɔ sé la né nùà veên, à sé la naâ gèh bɔ̀ fém bú hên bɔɔ́ komo ndɔ wa?» Yeé baá môn, kèrrè die lètenè bɔɔ̀n, bɔ́ kɔb geé fà. ");
INSERT INTO mcu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bɔ́ den cuù ye nuaá mé taré yuoó naâ doô a: «Á wò nɔ, wò ye nuaá mé taré sɔɔ́m naâ nyí doô né neì wa?» Ye bɔ́ a: «À né *sòn-Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kàmbér sâ bɔ̀ Jûf kuú taré cu né toò mé saân cúg ndɔ, ye: nuaá mé né njolo ŋené hên nùà cùgò njolò hèllè sam. Yeé yɔgɔ́ baá, bɔ́ yilá bie njií weéh mé tele bɔ̂ meí, ");
INSERT INTO mcu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ye bɔ́ a: «Hên né ka ŋuna biì doô wa? Bí ye mé gècên mene, à mé njéh cugó yuoó naâ lè á? Á sâ, kei mé bɔɔ́ naâ kɔɔ́, te njolo seèn ŋene cu mân wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bɔ̀ tele ye bɔ́ a: «Béh kɔ cegé né dé beèh ye hên né ŋuna beèh, à lé tácugó yuoó naâ lè. ");
INSERT INTO mcu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bɔɔ́ naá-re naàn mé à ŋene njolo wa, béh dé sâ kɔ́ ŋgwéh. Béh nuaá mé bɔɔ́ komó naâ bú njolo kɔ́ ŋgwéh ndɔ. Bí bíé njí ká mé bú, à wulu baá dé njèh tueê mé sòn seèn kèn.» ");
INSERT INTO mcu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sâ bɔ̀ tele né bɔ̀ Jûf veéh, bɔ́ bɔ́ ménâ tueé né dé cî. Sâ bɔ̀ Jûf wɔŋ kwaá gi aá doó, ye nuaá mé nde né tueé ye Yeésò né *Nùà Cɔ̀ŋ dɔɔ́ŋ, bɔ́ nde né bú ké gwà Càŋ kwɔgɔ́ sɔm keéh ma. ");
INSERT INTO mcu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bɔ̀ tele veéh naâ cí, te bɔ́ nde ye tueé ye bɔ́ a, bíé njí ká mé bú, à wulu baá dé njèh mé sòn seèn tueê. ");
INSERT INTO mcu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yeé baá ménâ, bɔ̀ Farisiên yilá cu tácugó doô, bɔ́ ye bú a: «Dùlà Càŋ, túé lòm dé gècên. Béh né dé beèh kɔɔ́ ye nùà hên né nùà veên.» ");
INSERT INTO mcu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nùà doô ye bɔ́ a: «À né-re nùà veên wa, à nùà veên sam wa, mè dé sâ kɔ́ ŋgwéh. Mè kɔ cegé né njèh cén, ye: mè lé naâ mé njolo cugó, kènê njolo mò baá njèh ŋené.» ");
INSERT INTO mcu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bɔ́ den cuù ye bú a: «À bɔɔ́ naâ naàn mé à komo lɔgɔ́ wò njolo wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ye bɔ́ a: «Mè naá giì bí tueé, bí temé teèn kwá njí ŋgwéh lòù. Bí ye mè a, túé cú naàn, te bí ŋgweé ye wa? Merré déì bí gwaán né bɔ̀ mbɔ̀ŋ seèn ŋaâ ndɔ?» ");
INSERT INTO mcu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bɔ́ yeé nde ŋgweé njií dé sâ mân, bɔ́ kem sue bú yoòr mé séb, bɔ́ ye bú a: «Wò né ka mbɔ̀ŋ seèn kɔɔ́, béh sam; béh né dé beèh bɔ̀ mbɔ̀ŋ Músì. ");
INSERT INTO mcu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Béh né kɔɔ́ ye Càŋ lé njèh tueé kwaá giì naâ sònò Músì. Dé nùà bú sâ, à yuoô-re he wa, béh kɔ́ ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nùà doô den cuù ye bɔ́ a: «Hên baá-re njèh kèkènè sâ: nùàr né gi mè njolo mân komo lɔgɔ́, bí bèh yuoô seèn kɔ́ ŋgwéh mà! ");
INSERT INTO mcu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Béh né gi kɔɔ́ ye, Càŋ beéh sòn bɔ̀ vevenê bɔ̀ ŋgwé bèh, à ŋgweé cegé né sòn bɔ̀ɔ́ mé né bú veéh, mé né sòn seèn ŋgweé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ndɔ́g, bɔ́ née beré déì ŋgwé sɔ̀m ŋgwéeh ye, ye nuaré déì lé yuoó naâ lè mé njolo cugó, bɔ́ lɔ taré bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mɔ nùà hên sé la beè Càŋ yùò ná ŋgwêh, à sé la njeré déì mân bɔ́ kòmò ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bɔ́ deén baá-re kènê ye bú a: «Nuaá mé jelág yuoó naâ lè léláŋ veên faá wò sam, wò sòn toò beèh weêh he wa?» Bɔ́ kwɔgɔ sɔm keéh bú te gwà Càŋe ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jomo sâ Yeésò nde fɔɔ́n kwa bú ndɔ, sâ à lé ŋgweé naâ ye bɔ́ lé naâ bú cie kwɔgɔ́ kwaá. À yeé ŋene aá bú, ye bú a: «Wò né temé yoòr *Huaán Nùàr kwaá njií wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nùà hèllè ye bú a: «Huaán Nùàr sâ né neì wa, dé koô, te mè kwaá njií temé yoòr seèn?» ");
INSERT INTO mcu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeésò ye bú a: «Wò né bú ŋené, à mé wò hên tueé njií den né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nùà doô ye bú à: «Mè kwaá njií aá temé yoòr seèn, Fehtoò mò!» À cemmé nde toò Yeésò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Te Yeésò deén baá-re, ye bɔ̀ nùàr a: «Mè ká te wɔ́ŋe ndeè né, te ju die: te bɔ̀ cùgò njolo bɔ̀ ŋene njolo, te bɔ̀ɔ́ mé né njolo ŋené cugó seér cu lòù.» ");
INSERT INTO mcu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sâ bɔ́ bɔ̀ Farisiên déì né kɔɔ́. Bɔ́ yeé ŋgweé aá môn, bɔ́ ye bú a: «Mé béh mene, béh né bɔ̀ tácugó ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","À ye bɔ́ a: «Mɔ bí sé né bɔ̀ tácugó, bí sé la mé ju felè ná cû. Á, bí biì ye, bí né ŋené; sâ ju né felè biì cu dɔɔ́ŋ teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Mè né tueé ye bí a: nuaá mé te hin kágá bɔ̀ mbieè yílá kélá ŋgwéh, à nde mar kela seér felè kágà bèh hiîn, né nùà yîb dé wúlá feèh. ");
INSERT INTO mcu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nuaá mé yila kela né dé seèn te hin kágà, né nùà mbieè kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Gó-lɔ́m nde né bú hin gulu keéh, bɔ̀ mbieè nde né hueh seèn ŋgweé kɔɔ́ ndɔ; à nde né bɔ̀ mbieè seèn te yilî yilá, à sɔm keéh bɔ́ cie. ");
INSERT INTO mcu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mɔ bɔ̀ mbieè seèn baá gi cie, à nde né toò bɔɔ̀n kelá, bɔ́ kem bele bú. Lòù sam, bɔ́ né hueh seèn ŋgweé kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dé nuaá mé bɔ́ bú kɔ́ ŋgwéh, môn sam, bɔ́ hueh seèn ŋgwé kɔ́ ndé ŋgwéh, bɔ́ yoòr seèn ndé ndé ŋgwéh ndɔ, bɔ́ bú dula seér nde né lòù.» ");
INSERT INTO mcu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeésò né mene bɔ́ ŋgòr te kàn mân si keéh, bɔ́ lom ŋgwé kɔ́ ŋgwéh ndɔ́g. ");
INSERT INTO mcu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeésò den cuù ye bɔ́ a: «Mè né tueé ye bí a: Mè né hin kágá bɔ̀ mbieè. ");
INSERT INTO mcu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bɔ̀ɔ́ mé lé kelà naâ toò mò dɔɔ́ŋ né gi dé bɔɔ̀n bɔ̀ yíb bɔ̀ dé wúlá-feèh. Bɔ̀ mbieè lé hueh bɔɔ̀n ŋgwé kɔ́ ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mè né dé mò hin kágà. Nuaá mé nde né teèn yilá kelá, nde né yili yuo. À nde né teèn yagá kelá den: à né yilá, à né yuo, à nde né yáb kwa ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dé nùà yîb môn sam, à ndeè né dé seèn lòù ŋuɔɔ́b, à ndeè né wulá ceré sɔm ndɔ. Mè ndeè né dé mò ye te bɔ̀ nùàr kwa yɔ̀ŋ mé gùm mene. ");
INSERT INTO mcu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Nùà mbieè dé bagaà né mè. Nùà mbieè dé bagaà kuú né dé seèn cio bɔ̀ mbieè seèn. ");
INSERT INTO mcu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dé tèŋ môn sam, à dé seèn bɔɔ́ lom né seé kàgàlɔ̀ŋ, à nùà njèh sam. Yeé baá môn, mɔ ŋgùì yila te bɔ̀ŋ mbieè, à dula yuo, à si lɔ bɔ̀ mbieè, bɔ́ bɔ̀ ŋgùì wulu den jomo, ŋgùì sie ŋellé sɔm gi bɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lòù sam, à dé seèn teèn bɔɔ́ lom né seé kàgàlɔ̀ŋ, à mé jere bɔ̀ mbieè sam, à bɔ́ dula si lɔ né mé njéh. ");
INSERT INTO mcu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Mè né dé mò nùà njèh. Mè né gi bɔ̀ mbieè mò kɔɔ́, bɔ́ né mè kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mè kɔ né bɔ́ faá Tele mò kɔ né mè nɔ, bɔ́ kɔ né mè faá mè kɔ né Tele mò ndɔ. Mè né nùà njèh, mè kuú né dé mò sòn bɔ̀ mbieè mò. ");
INSERT INTO mcu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mè né cu mé bɔ̀ mbieè déì teèn, bɔ́ dé bɔɔ̀n ká lè kágà hên sam. Kɔ mè yilá bilí njiî bɔ́, te bɔ́ bilí den lom te kágá cén-e, bɔ́ ŋgweé sòn mò, te nùà mbieè den lom teèn cén ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Temé Tele mò né lom yoòr mò. Lòù sam, mè nde né sòn bɔ̀ mbieè mò kuú, te mè ndeè komo yuo cuù dé feê. ");
INSERT INTO mcu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nuaré déì mè yɔ̀ŋ kɔɔ́ sɔ̀m ŋgwéh, mè yɔ̀ŋ mò si lom né mé be mò. Mè né mé terreb yɔ̀ŋ mò sɔɔ̀m teèn, mè né mé terreb dé feê kwa cuû teèn ndɔ. Tele mò mè terreb ménâ haá naâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Te bɔ̀ *Jûf yeé nde ŋgweé njií cu mân, bɔ́ kerré ŋeí cu ye baá-re dé kerrê. ");
INSERT INTO mcu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nùàr ŋgún tueé lom aá lètenè bɔɔ̀n, ye: «Nùà hên né mé tándulu yoòr, né nùà tì! Bí sònò seèn felá den né kei wa?» ");
INSERT INTO mcu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bɔ̀ déì ye: «Nùà tándulù déì lɔ mân tueé ŋgweé baá he ndɔ wa? Tándulu déì né mé terreb teèn mé nde né tácugó njolo mân kwɔgɔ ŋagá wa?» ");
INSERT INTO mcu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sâ ké Jerusalem te nyèmà dɔɔ́ŋ, gèh cieé koô mé bɔ́ lé komó naâ gwà Càŋ teèn sâ né yeé feí sɔɔ́; feí yeé sâ dùlù baá sie. Nyèmà hên cieé koô sâ yeé feí cu aá, ");
INSERT INTO mcu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeésò yila nde ké *gwà Càŋ koô, à né te kɔ̀ŋ déì gɔlé den, bɔ́ kɔ̀ŋ sâ yilá né Kɔ̀ŋ Salomɔ̂ŋ. ");
INSERT INTO mcu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bɔ̀ Jûf bilí nde cuù kwarè seèn, bɔ́ ye bú a: «Wò béh temé ter tab lɔ né dé keì wa? Mɔ wò né *Nùà Cɔ̀ŋ kɔɔ́, túé ŋágá béh tueè.» ");
INSERT INTO mcu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeésò ye bɔ́ a: «Mè lé naâ bí ménâ tueé gií, bí temé teèn kwá njí ŋgwéh lòù. Mé njéh mene, bɔ̀ seé mé mè né mé terreb Tele mò bɔɔ́ hên tueé nde né kɔɔ́, ye mè né Nùà Cɔ̀ŋ sâ. ");
INSERT INTO mcu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bí dé biì temé teèn kwá njí ŋgwéh. Lòù sam, bí te bɔ̀ŋ bɔ̀ mbieè mò sam. ");
INSERT INTO mcu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bɔ̀ mbieè mò né dé bɔɔ̀n hueh mò ŋgweé kɔɔ́; mè né bɔ́ ŋené kɔɔ́ ndɔ, bɔ́ né gi dé bɔɔ̀n jomo mò. ");
INSERT INTO mcu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mè né bɔ́ yɔ̀ŋ tètàgà haá; bɔɔ́ mene naàn, bɔ́ dé bɔɔ̀n kú ndé cú, nuaré déì bɔ́ beè mò ŋgà sɔ̀m ndé cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tele mò lé mè haá naâ kɔɔ́; mé terreb felè njèh dɔɔ̂ŋ né bú. Nuaré déì bɔ́ beè Tele mò ŋgà kòmò ndé cú. ");
INSERT INTO mcu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bêh Tele mò né lom cén.» ");
INSERT INTO mcu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Te bɔ̀ Jûf yeé nde ŋgweé njií mân, bɔ́ domó cu taá, te bɔ́ tɔbé bú mé njéh. ");
INSERT INTO mcu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","À deên ndɔ, ye bɔ́ a: «Mè bɔɔ́ baá seé bebagaà mé Tele mò lé feéh naâ mè ŋgún, bí ŋene gi aá kèn. Mè dé veên bɔɔ́ naâ dé heè mé bí ye, bí nde né mè teèn tɔbé wulá wa?» ");
INSERT INTO mcu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bɔ̀ Jûf ye bú a: «Béh wò mé seé bagaà tɔ̀bè ŋgwéh, béh ye te béh wò tɔbé wula mé Càŋ seèb. Wò nùàr mbaâ, wò feh yeè faá Càŋ nɔ weh né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeésò ye bɔ́ a: «Ŋgweéh bɔ́ nyagá kwaá gi né te mvù sóù biì, ye: Càŋ ye bí né bɔ̀ Càŋ wa? ");
INSERT INTO mcu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Béh né gi kɔɔ́ ye, njií mé Càŋ nyagá kwaá gi aá te mvù kèn, nuaré déì bú fɔ̀ kòmò ndé cú. Càŋ lé bɔ̀ Càŋ sâ yilá naâ bɔ̀ɔ́ mé né ŋgòr seèn ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sé tagá mè wa? Ká lè wɔ́ŋe, Tele mò Càŋ lé balé tema njií naâ mè. Sâ mɔ mè né mene feh mò Ŋunà Càŋ yilá, bí ye mè né feh mò faá Càŋ nɔ weh fí sé wa? ");
INSERT INTO mcu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mɔ mè seé Tele mò bɔ́ ŋgwéh, sâ bí té temé yoòr mò kwá njí bɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Á, mɔ mè bɔɔ́ né cí, mɔ bí mene temé mé ŋgòr mò kwá njí ŋgwéh, bí temé kwá njí biì te seé mò. Bí nde né teèn ŋené ŋagá, ye Tele mò né yoòr mò, mè né yoòr Tele mò ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bɔ́ yeé nde aá bú lòù sie weéh, à mvelé yuo bɔ́ beè. ");
INSERT INTO mcu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","À sela yuo kela nòmò Jurdên kèb yágà, bèh mé Jâŋ lé kou lɔgɔ́ naâ bɔ̀ nùàr nòmò teèn, à den den yí teèn. ");
INSERT INTO mcu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bɔ̀ nùàr ŋgún kem wa cuù toò seèn, bɔ́ né tueé ye: «Jâŋ lé mene fém déì bɔ́ ná ŋgwêh, kàmbér njií mé à lé tueé giì naâ felè nùà hên dɔɔ́ŋ lɔ né gi bɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yeé baá môn, bɔ̀ nùàr kwaá njií cu ye baá-re temé yoòr Yeésò kókoó. ");
INSERT INTO mcu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nùà Betanî déì lé naâ beén die, yilí seèn né Lasâr. Bɔ̀ tie seèn Marî bɔ̂ Mártà né te lɔɔ́ sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Marî sâ né ma mé lé naâ Fehtoò beèh kómó múmû gulè waá kwaá, à fɔ sɔm mé yúlí feèh doô. Bɔ́ yeé ŋene tie bɔɔ̀n Lasâr baá baán, ");
INSERT INTO mcu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","bɔ́ tema njií nuaré déì ye Yeésò a: «Fehtoò beèh, yíé-temé yeè baá baán ma.» ");
INSERT INTO mcu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yeésò yeé ŋgweé aá môn, à ye: «Beén Lasâr hên bú wúlá ndé ŋgwéh; bɔɔ́ né mân, te *sùsùm sie bɔ̀ nùàr mé Càŋ, te terreb Ŋunà Càŋ ŋené yuo kelà teèn ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ju Mártà bɔ̂ dìm mé Lasâr lé naâ Yeésò yoòr yilá dé gècên. ");
INSERT INTO mcu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","À yeé ŋgweé aá ju beên sâ, à cer cu ká jomo cieé fà, ");
INSERT INTO mcu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","jomo sâ ye bɔ̀ mbɔ̀ŋ a: «Béh nde cu ké Judê.» ");
INSERT INTO mcu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bɔ̀ mbɔ̀ŋ ye bú a: «Nùà fèh-njèh, née dàb sam mé bɔ̀ *Jûf lé naâ ceér fɔɔ́n, ye bɔ́ nde né wò tɔbé wulá. Wò hên baá cu mé gò ké teèn wa?» ");
INSERT INTO mcu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ye bɔ́ a: «Ŋgweéh yuoô maánjɔ̀gɔ̀, nde wa liyilì né suútenè mà. Sâ nuaá mé né suútenè gɔ dɔɔ́ŋ né ŋagâ mé né ká lè wɔ́ŋe ŋené, à gule cén ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nuaá mé gɔ né cíbíteèn dé seèn mé ŋagâ yoòr sam, à nde né gule ceén lɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","À den cuù ye bɔ́ a: «Mbeí beèh Lasâr cer né lɔ́m; mè nde né ké teèn ndeé, te mè nyimé sɔm bú.» ");
INSERT INTO mcu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bɔ̀ mbɔ̀ŋ ye bú a: «Fehtoò beèh, mɔ à né lɔ́m, sâ à nde né taré yuo.» ");
INSERT INTO mcu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sâ Yeésò ye te bɔ́ ŋgweé kɔ teèn, ye Lasâr kuú gi aá kèn. Mé njéh mene, bɔ́ ŋgwé kòmò ŋgwéh, bɔ́ dé bɔɔ̀n munó seér né ye Yeésò jue né lɔ́m dé gècên. ");
INSERT INTO mcu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeé baá môn, à tueé ŋagá bɔ́ ndɔ, ye bɔ́ a: «Lasâr baá komó ma.» ");
INSERT INTO mcu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jomo sâ à ye bɔ́ a: «Mè né mé vɔ́gɔ́-temé felè biì dé gècên. Lòù sam, mè lé ké doó sâ ná ŋgwêh. Bɔɔ́ gi né ménâ felè biì, te bí kwaá njií keéh temé yoòr mò teèn. Bí hin, béh nde ké kwarè seèn.» ");
INSERT INTO mcu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomâs, mé bɔ́ yilá né huaán feèh doô deên ndɔ, ye bɔ̀ mbɔ̀ŋ déì a: «Bí hin ké teèn, béh bɔ̀ Fehtoò beèh nde kuú dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bɔ̀ Yeésò wa ké Betanî, sâ bɔ́ lé furú sɔm aá Lasâr baá cieé nèà. ");
INSERT INTO mcu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanî sâ né kwarè Jerusalem mân, yuoô teèn nde Jerusalem kílòmétà tagár wá ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bɔ̀ Jûf ŋgún lé naá giì teèn kem ndeé, bɔ́ nde Mártà bɔ̂ Marî cio tie bɔɔ̀n bieé weh. ");
INSERT INTO mcu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mártà ŋgweé njií ndɔ, ye Yeésò baá ndeê, à nde bú ceér dueè kwa weh; Marî le dé seèn ké gwò. ");
INSERT INTO mcu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mártà wa ye Yeésò a: «Fehtoò mò, mɔ wò sé naâ doó, tie beèh sé lé kú ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mé njéh mene, mè né kɔɔ́ ye kènê, mɔ wò bie njií Càŋ njeré déì, à nde né wò haá.» ");
INSERT INTO mcu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeésò ye bú a: «Tie yeè nde cuù né lè cio komo yuoô.» ");
INSERT INTO mcu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mártà ye bú a: «Mè né kɔɔ́ ye, à nde né te cio komo yuo, dé sâ seèn né cieé cèrè jomò, loù mé bɔ̀ nùàr dɔɔ́ŋ nde gi né teèn komo yuo.» ");
INSERT INTO mcu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeésò ye bú a: «Mè te cio komo sɔm né nùàr kɔɔ́, mè haá bú yɔ̀ŋ. Nuaá mé né temé yoòr mò kwaá njií la kuú mene, à nde né komo yuo. ");
INSERT INTO mcu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nuaá mé né làŋ, mé né temé yoòr mò kwaá njií, dé seèn kú ndé cú ndɔ. Wò né temé teèn kwaá njií wa?» ");
INSERT INTO mcu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mártà ye bú a: «Nyea Fehtoò mò, mè né lom temé teèn kwaá njií, ye wò né *Nùà Cɔ̀ŋ, wò né Ŋunà Càŋ mé sé naâ ká te wɔ́ŋe mân ndeê.» ");
INSERT INTO mcu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jomo sâ Mártà nde mé dìm seèn Marî tueé naáb wellê ndɔ, ye bú a: «Nùà fèh-njèh beèh waà baá kèn, à né wò yilá.» ");
INSERT INTO mcu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te Marî yeé nde ŋgweé njií mân, à lɔ wuo ter kpar, à njege nde ké yoòr seèn. ");
INSERT INTO mcu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","À wa, sâ Yeésò née ké sònò lɔɔ̂ ye, à né bèh mé bɔ̂ Mártà la kwaré naâ teèn. ");
INSERT INTO mcu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bɔ̀ Jûf mé la naâ Marî ké gwò bilí bɔŋ den doô yeé ke, à tené nde aá mân, bɔ́ kem bele bú ndɔ, bɔ́ ye merré déì à nde cu né mbà ké felè sà yueé den. ");
INSERT INTO mcu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Marî yeé nde ŋene njií Yeésò ké bèh sâ mân, à die sulí nde doó gulè seèn, ye bú a: «Fehtoò mò, mɔ wò sé naâ doó, tie beèh sé lé kú ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yeésò yeé ke, Marî né yueé, bɔ̀ Jûf mé naá giì jomo seèn baá yueé, feh ŋellé bú ter, yili yuo bú lè. ");
INSERT INTO mcu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ye bɔ́ a: «Bí bú furú né he wa?» Bɔ́ ye bú a: «Ndê kè kú yeè hên nɔ, Fehtoò beèh.» ");
INSERT INTO mcu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeésò yila yueê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bɔ̀ Jûf duɔɔ́m baá-re tueê ye: «À lé kɔ ye nyí bú gwaán kum aá!» ");
INSERT INTO mcu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bɔ̀ déì den cuù lètenè bɔɔ̀n ye: «Ŋgweéh bú nuaá mé lé naâ tácugó njolo kwɔgɔ, sé naâ bɔɔ́ te Lasâr kú cú mà.» ");
INSERT INTO mcu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jere bɔɔ́ cu Yeésò njèh, à nde ké sòn sà ndɔ. Sà hèllè lé naâ gbàŋ, bɔ́ sònòbɔ̀ colo kwaá né tàmbàŋ taâ mân. ");
INSERT INTO mcu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeésò ye bɔ́ a: «Bí gùlù sɔ̀m taá sâ gulù.» Mártà tieè Lasâr deên ndɔ, ye bú a: «Á, à cer aá dòù baá cieé nèà nɔ, Fehtoò beèh, kènê à baá dulí.» ");
INSERT INTO mcu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeésò ye bú a: «Mè lé túé ná ŋgwêh, ye wò a: mɔ wò né temé yoòr mò kwaá njií, wò nde né terreb Càŋ ŋené wa?» ");
INSERT INTO mcu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bɔ́ gulu sɔm taá hèllè ndɔ. Yeésò ke njií njolo ké te vulúu, ye: «Tele mò, mè vra baá wò mé wò né sòn mò faá bèh mân ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mè né gi dé mò kɔɔ́ ye cu dɔɔ́ŋ wò né yeé sòn mò ŋgweé. Mé njéh mene, Tele mò, mè wò ké ter hên vra njií né te gam bɔ̀ɔ́ mé né kwarè mò kaáŋ den, te bɔ́ kwaá njií temé teèn, ye wò mè tema njií naâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","À yeé dua sɔm aá, à yilá lɔgɔ njií ké ter, ye: «Lasâr, yùò kélâ!» ");
INSERT INTO mcu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nuaá mé lé naâ kuú hèllè yuo kelà te sòn seèn ndɔ; sâ gule bɔ̂ be mé njolo née gi lè cɔ̀gɔ̀ vuɔb den ye. Yeésò ye bɔ́ a: «Bí sè sɔ̀m bú vùɔ̀b yoòr, bí keéh njií bú.» ");
INSERT INTO mcu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bɔ̀ Jûf mé ndeè naâ cio bieé doô yeé ŋene aá môn, nùàr ŋgún lètenè bɔɔ̀n kwaá njií gi temé yoòr Yeésò. ");
INSERT INTO mcu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bɔ̀ déì nde seér cu bɔ̀ *Farisiên kwa, bɔ́ tueé bɔ́ njií mé Yeésò la bɔɔ́ naâ sâ. ");
INSERT INTO mcu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bɔ̀ Farisiên bɔ́ bɔ̀ *ŋgàŋ sèmè dé kokoô yeé ŋgweé aá môn, bɔ́ yilá bilí *mbàgà ju tarê ndɔ, bɔ́ ye: «Nùà hên baá fém bɔɔ́ maga, kènê béh bɔɔ́ nde né naàn? ");
INSERT INTO mcu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mɔ à né mân bɔɔ́, béh né bú kwaá lɔɔ́, sâ bɔ̀ nùàr nde gi né temé yoòr seèn kwaá njií, sâ bɔ̀ Rɔ̂m bɔ̀ ndeè né ŋaár waâ, bɔ́ tɔb sɔm gwà Càŋ koô, mé lò beèh mene.» ");
INSERT INTO mcu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Cén déì lètenè bɔɔ̀n, yilí seèn né Kayîf, à lé naâ ŋgàŋ sèmè dé koô nyèmà sâ kɔɔ́, ye bɔ́ a: «Bí njeré déì kɔ́ ŋgwéh lòù. ");
INSERT INTO mcu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Huɔm kela né mé nùà cén sòn bɔ̀ mbeî kuú seér kɔɔ́, wanɔɔ́ŋ sâ lò nùàr nde né kɔɔ́ cim seér.» ");
INSERT INTO mcu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sâ ŋgàŋ sèmè dé koô nyèmà sâ lé naâ bú, à lé ŋgòr sâ mé feh seèn túé ná ŋgwêh, Càŋ lé sònò seèn tueé kwaá naâ kɔɔ́, ye Yeésò nde né felè bɔ̀ Jûf kuú. ");
INSERT INTO mcu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Gí cégé ŋgwéh léláŋ bɔ̀ Jûf, à koró bilí cu nde né bɔ̀ nùàr Càŋ wɔ́ŋ dɔɔ́ŋ bècénè kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sâ baá bèh mé bɔ̀ Jûf dé kokoô lé kagá naâ kàgà-ndòn veên teèn, ye bɔ́ nde lom né Yeésò wulá. ");
INSERT INTO mcu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yeé baá môn, Yeésò geé mé ceér lètenè bɔ̀ Jûf bèsɔ́nè yagâ ndɔ. À yuo te tàbè sâ, à nde ser ké ya dueè lè lɔɔ́ déì mân, bɔ́ bɔ̀ mbɔ̀ŋ seèn cer den ké teèn; yilí lɔɔ́ sâ né Efraîmà. ");
INSERT INTO mcu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sâ cieé koô bɔ̀ Jûf mé bɔ́ yilá yeé *Páskà doô baá dìdì. Yeé nde aá feí, bɔ̀ nùàr te tàbè lò sâ né kàn mé kán kem yuo kelâ, bɔ́ né ké Jerusalem ndeé, te bɔ́ *sené bɔ́, bɔ́ yieé yeé Páskà. ");
INSERT INTO mcu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wa ké teèn, bɔ́ né Yeésò bieé fɔɔ́n, bɔ́ né ké *gwà Càŋ koô lètenè bɔɔ̀n bieé kuú, ye: «Bí dé biì munó né naàn, bí ye hên à ndeè né bèh cieé koô ndeê wa?» ");
INSERT INTO mcu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sâ bɔ̀ ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ Farisiên lé wɔŋ kwaá gi aá, ye mɔ nuaré déì né bèh seèn kɔɔ́, bú a túé bɔ́ teèn, te bɔ́ nde sie wellê bú ma. ");
INSERT INTO mcu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","*Páskà yeé le aá cieé ténjén, Yeésò nde cu ké Betanî lɔ Lasâr mé à lé komo sɔɔ́m naâ lè cio doô. ");
INSERT INTO mcu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wa ké teèn, bɔ́ ne haá bú kùrmò. Mártà lé yáb sâ geé naâ kɔɔ́. Yeésò bɔ́ bɔ̀ mbeí mé Lasâr mene né yieé den. ");
INSERT INTO mcu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bɔ́ yeé baá yieé, Marî weh mbémbɔ́ŋ kómó múmû mé keh tarê mân, à waá Yeésò gulè mé njéh, à fɔ sɔm mé yúlí feèh seèn. Gwà dɔɔ́ŋ samé le gi léláŋ múmû sâ. ");
INSERT INTO mcu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sâ Júdàs Iskariô, mbɔ̀ŋ Yeésò mé nde né Yeésò go sɔm doô, lé naâ doó sâ. À yeé ŋene aá ménâ, ye: ");
INSERT INTO mcu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ŋgweéh kàgàlɔ̀ŋ kómó múmû hên né dé gùm cieé seê yuií tagár mà. Bɔɔ́ né naàn mé bɔ́ lòù gò sɔ̀m ŋgwéh, te bɔ́ weh kàgàlɔ̀ŋ sâ, bɔ́ geé haá mé bɔ̀ saám bɔ̀ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sâ lemá jere bɔ̀ saâm bɔ̀ hèllè ndɔ, Júdàs né seér yíb. À lé sie beéh mvugó kàgàlɔ̀ŋ bɔɔ̀n kɔɔ́, à né yeé be teèn yií, à ménâ tueé kuú né dé cî. ");
INSERT INTO mcu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeésò deên ndɔ, ye bú a: «Kwá lɔ́ ma hên den nɔɔ́ŋ! Kwá lɔ́ bú, à yurú njií né te cieé déì komó mò ndeè cer mé njéh dòù. ");
INSERT INTO mcu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Dé bɔ̀ saám bɔ̀, bí bɔ́ nde né cu dɔɔ́ŋ kɔɔ́; dé mò, béh bí kɔɔ́ dèn ndé cú.» ");
INSERT INTO mcu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bɔ̀ *Jûf kókoó mbaá ŋgweé njií ndɔ, ye Yeésò né ké Betanî, bɔ́ kem nde teèn, bɔ́ ké yoòr Yeésò ndé lòm cú, bɔ́ nde bilí baá mé Lasâr ke wellê mene. Lòù sam, Yeésò lé naâ bú te cio komo sɔm. ");
INSERT INTO mcu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bɔ̀ *ŋgàŋ sèmè dé kokoô yeé ŋene aá môn, bɔ́ kaga ndòn, ye bɔ́ nde né Lasâr wulá sɔm cuú, ");
INSERT INTO mcu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","wanɔɔ́ŋ bɔ̀ Jûf ŋgún baá bú ŋené, bɔ́ né ceér bɔɔ̀n kwaá lɔɔ́, bɔ́ temé kwaá njií seér yoòr Yeésò. ");
INSERT INTO mcu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Cieé ŋaga, cìlì nùàr mé wa giì naâ bèh *Páskà doô, ŋgweé njií ye Yeésò baá ká Jerusalem ndeê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bɔ́ nde ŋgéh-teêr tená, bɔ́ né mé njéh kem ndeé, bɔ́ nde bú mé njéh cɔɔ́ wellê, bɔ́ né ceceér leéh ndeé, ye: «Lieê né mé Càŋ! Bú a, kúlú nyégé nuaá mé ndeè né mé yilí seèn hên kulù! Nùà Dueè bɔ̀ *Iserálà bɔ̀ né bú!» ");
INSERT INTO mcu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeésò kwa mbò vuɔmndeè ndɔ, à né ŋgètenè ŋaá den. Den né faá bɔ́ lé nyagá kwaá naâ te mvù Càŋe nɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Té vèh, lɔɔ́ Siyɔ̂ŋ! Kè sâ ndeè né Nùà Dueè yeè. À né ŋgètenè mbò vuɔmndeè.» ");
INSERT INTO mcu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Njií mé Yeésò bɔ́ bɔ̀ nùàr né bɔɔ́ sâ, bɔ̀ mbɔ̀ŋ seèn lom cu sâ ŋgwé kòmò ŋgwéh gùm dɔɔ́ŋ. Be terrèb seèn yeé ŋené yuo kelà baá bèsɔ́nè, bɔ́ nde ye munó ko ye bɔ́ lé naâ felè seèn te mvù Càŋe ménâ nyagá kwaá, bɔ̀ nùàr bú hên bɔɔ́ né cí ma. ");
INSERT INTO mcu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bɔ̀ɔ́ mé lé naá giì doó cu mé Yeésò lé komo sɔɔ̀m naâ Lasâr te cio doô, lé naá giì fém sâ mé bɔ̀ nùàr tueé bele. ");
INSERT INTO mcu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Cìlì nùàr lé bú ceér dueè ndeè naâ cɔɔ́ wellê dé cî. ");
INSERT INTO mcu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Te bɔ̀ *Farisiên yeé baá-re faá bèh mân ŋené njií, bɔ́ yila lètenè bɔɔ̀n tueê ye: «Hèê dé hên baá dé mbaâ, béh bú njeré déì bɔ́ ndé cú, nùàr dɔɔ́ŋ bú kem bele gi aá kèn!» ");
INSERT INTO mcu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cieé koô yeé feí baá, bɔ̀ nùàr bilí gi ké Jerusalem bèh Càŋ duaà ndɔ. Lètenè bɔɔ̀n sâ, bɔ̀ Greêk déì lé naâ teèn, ");
INSERT INTO mcu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","bɔ́ ŋgoró nde yoòr Filîp dé ké Becaida te tàbè Galilê, bɔ́ ye bú a: «Dé koô, béh gwaán né Yeésò ŋenê.» ");
INSERT INTO mcu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filîp nde tueé keéh Andrê; bɔ́ bú fà dɔɔ́ŋ nde Yeésò ménâ tueé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeésò ye bɔ́ a: «Cu wulu baá kèn; kènê, be terrèb *Huaán Nùàr nde ye aá bèsɔ́nè ŋené ŋagá. ");
INSERT INTO mcu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mè né tueé ye bí a, mɔ bɔ́ mvum ŋgwàgàm dòù fùrù njí ŋgwéh te à vuaán, à nde né mé huún ménâ le den. Kɔ à kuú baá, te mvum yuo ye teèn ŋgún. ");
INSERT INTO mcu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nuaá mé né feh seèn gagá, nde né lòù leér seér; nuaá mé né dé seèn cio ká lè wɔ́ŋe ŋgɔɔ́n, nde né feh seèn yili sɔm, à kwa yɔ̀ŋ tètàgà. ");
INSERT INTO mcu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nuaá mé gwaán né seé mò bɔɔ̂, bú a, yùò bèlè mè; sâ te nùà seê mò wa ye ké te bèh denè mò. Mè tueé bí, Tele mò nde né nùà seê mò ter jɔgɔ́ njií.» ");
INSERT INTO mcu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yeésò den cuù ndɔ, ye: «Kènê feh mò ŋellé baá ter kèn, hên mè sònò tueé cu nde né-re kei? Cu mò wulù baá kɔɔ́; te mè tueé cu-re kènê ye Tele mò a: lùàgà sɔ̀m cú mè teèn lòù wa, wa naàn? Ŋgweéh mè ká lè wɔ́ŋe nde kuú né bèh gèr mân ŋenê mà. ");
INSERT INTO mcu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mè tueé nyegé nde né ye Tele mò a: Tele mò, kènê sɔ̀m kéh bá be terrèb yeè bèsɔ́nè.» Yeé baá môn, hueh déì ŋgulí ké te vulúu ndɔ, ye: «Mè lé naá giì be terrèb mò sɔm keéh, mè nde cu né bú sɔm keéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bɔ̀ɔ́ mé lé naá giì doó sâ dɔɔ́ŋ ŋgweé gi hueh doô, bɔ̀ déì ye: né nu gwaán né kɔɔ́. Bɔ̀ déì ye: né cìlì Càŋ tueé né bú njií. ");
INSERT INTO mcu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeésò deên ndɔ, ye bɔ́ a: «Hueh hên felè mò túé njí ŋgwéh, tueé njií né felè biì. ");
INSERT INTO mcu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kènê bɔ́ nde aá ju felè wɔ̂ŋ tená; bɔ́ nde né mgbè wɔ̂ŋ kènê kwɔgɔ́ sɔm. ");
INSERT INTO mcu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dé mò, mɔ bɔ́ jɔgɔ njií aá mè ter, mè nde né nùàr ŋgún ká yoòr mò tulu njiî.» ");
INSERT INTO mcu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sâ, à bɔ́ ménâ tueé keéh den né gèh cio mé à nde né kuú sâ. ");
INSERT INTO mcu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","À yeé baá mân tueé, cìlì nùàr ye bú a: «Bɔ́ nyagá kwaá né te mvù sóù beèh ye: Nùà Cɔ̀ŋ nde né cu dɔɔ́ŋ làŋ. Wò dé yeè môn tueé né dé keì, ye bɔ́ nde né *Huaán Nùàr ter jɔgɔ́ njií wa? Huaán Nùàr sâ né neì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeésò ye bɔ́ a: «Kènê, bí née mé ŋagâ lètenè biì teèn; njèh cén, le me aá lòù. Bí gɔ̀ cu mé née ŋagá hên, te cibí bí sìè cú. Mɔ sam, nuaá mé gɔ né te cibi ndugó nde den né mbaá, à lèmè kɔ́ bèh. ");
INSERT INTO mcu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sâ keí mé bí née ŋagâ ŋené hên, bí kwá njí temé teèn, te bí den bɔ̀ ŋeŋagâ bɔ̀.» Yeésò yeé tueé gi aá ménâ, à sɔm gò seèn ndɔ, à nde ké bèh ndɔ́ŋ-ndɔ̀ŋ leér den. ");
INSERT INTO mcu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","À né mene fém hihiné toò bɔ̀ Jûf bɔɔ́, mé njéh mene bɔ́ temé yoòr seèn kwá njí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá Esáyà *sòn-Càŋ lé naá giì léí jɔ̀gɔ̀ tueé kwaá nɔ, ye: «Nùà Dueè, neì seèn temé te ŋgòr beèh hên kwaá njií né-re kɔɔ́? Nùà Dueè terreb seèn mbaá feh kuú né mé neì?» ");
INSERT INTO mcu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sé bɔɔ́ mene naàn, bɔ́ sé bɔɔ̀n temé teèn kwá njí ná ŋgwêh; Esáyà sòn-Càŋ lé naá giì ménâ tueé ndɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Càŋ bele cugó seér aá bɔ́ njolo, te bɔ́ mé njolo ŋéné cú. À calé sɔm bɔ́ temé lè, te temé bɔɔ̀n njèh mùnò kòmò cú ndɔ; ye te bɔ́ ká jomo yoòr nyî cú kɔ́ cû, te nyí bɔ́ yìlì sɔ̀m cú ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mé Esáyà nde ménâ tueé, sâ à terreb Yeésò ŋene gi aá kèn, ");
INSERT INTO mcu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ye bɔ̀ nùàr nde né berɔ́ŋ. Mé njéh mene, né mene bɔ̀ kokoô bɔ̀ lètenè bɔ̀ Jûf, ŋgún lé naá giì temé yoòr Yeésò kwaá njií. Njèh cén, bɔ́ lé veéh seér yeé bɔ̀ *Farisiên: ye mɔ bɔ́ gwaán sɔm bú cie, bɔ̀ Farisiên nde né bɔ́ gwà Càŋ kwɔgɔ́ sɔm. Yeé baá mân, bɔ́ bú cie gwàn sɔ̀m cú. ");
INSERT INTO mcu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bɔ́ lé gwaán kela seér naâ dé bɔ̀ nùàr seén bɔ́ kɔɔ́, mé Càŋ. ");
INSERT INTO mcu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeésò tueé lɔgɔ njií ké ter ndɔ, ye bɔ́ a: «Nuaá mé né temé yoòr mò kwaá njií, à léláŋ yoòr mò kwá njí lòm ŋgwéh, à kwaá njií né yoòr nuaá mé temà naâ mè. ");
INSERT INTO mcu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nuaá mé né mè ŋené, ŋene né nuaá mé temà naâ mè. ");
INSERT INTO mcu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mè dé mò ká lè wɔ́ŋe ndeè né faá ŋagâ nɔ, te bɔ̀ɔ́ mé kwaá njií né temé yoòr mò te cibi dèn cú. ");
INSERT INTO mcu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nuaá mé né ŋgòr mò ŋgweé, à jòlò ŋgwéh, mè bú ju kɔɔ́ sì ndé ŋgwéh. Lòù sam, mè nde seér naâ dé mò *wɔ́ŋ yili sɔm, mè bú bèh ju siì ndé ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuaá mé ka si njií mè doó, à ŋgòr mò gwàn ŋgwéh, sâ baá ye bèh ju seèn dieè: bɔ̀ ŋgòr mò mé à tie teèn félá njí ŋgwéh doô, tena nde né ju seèn te cieé cèrè jomò kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mè mé feh mò túé bèh. Tele mò mé temà naâ mè tueé naâ mè kɔɔ́, à ye mè a, ndé ménâ tueé. ");
INSERT INTO mcu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mè né kɔɔ́ ye, ndéb Tele mò né yeé yɔ̀ŋ tètàgà ŋar. Sâ, njií mé mè né yeé tueé dɔɔ́ŋ, mè tueé yeé faá Tele mò tueé né mè kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sâ cieé ŋaga, baá *Páskà. Mé Páskà ndeè waâ, sâ Yeésò kɔ gi aá ye cieé nyî ká te wɔ́ŋe ceré baá, nyí baá cu mé gò ké yoòr Tele nyî ma. À lé naá loôm bɔ̀ dé seèn ká te wɔ́ŋe mé gècên mene gwaán, à bɔ́ gwaán nde den né ménâ, kɔ ndeè ceré baá kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeé baá mân, Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn yieé bilí ndɔ. Sâ *Sátàn lé naá giì kàgà-ndòn veên lè Júdàs ŋunà Simɔ̂ŋ Iskariô yií, ye kɔ à Yeésò go sɔm aá. ");
INSERT INTO mcu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mé njéh mene, Yeésò lé naá giì dé seèn kɔɔ́, ye nyí lé yuoó naâ ké beè Tele nyî Càŋ, nyí nde cu né beè Càŋ. Sâ, à né gi kɔɔ́ ye Càŋ njèh dɔɔ́ŋ haá kwaá gi né beè nyî ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bɔ́ bɔ̀ mbɔ̀ŋ seèn yeé baá yáb yieé, à komo wuo ter, à huar sɔm cɔ̀gɔ̀ seèn dé felèbɔ̀, à weh táhòrò, à cam njií tenè. ");
INSERT INTO mcu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","À ber kwaá nòmò te ŋgàb déì mân, à yila bɔ̀ mbɔ̀ŋ seèn gule beè yagaà. Táhòrò mé à cam kwaá naâ tenè doô, à né bɔ́ gule mé njéh fɔ ŋemá. ");
INSERT INTO mcu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","À yaga waà mé njéh toò Simɔ̂ŋ Piêr. Simɔ̂ŋ Piêr ye bú a: «Fehtoò mò, wò yaga seér cu nde aá mè gule beè kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeésò ye bú a: «Wò dé hên kènê ŋgwé kòmò ndé ŋgwéh, kɔ ndeè baá jomo.» ");
INSERT INTO mcu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piêr ye bú a: «Ndɔ́g, wò mè gule beè kɔɔ́ yàgà sér ndé ŋgwéh!» Yeésò den cuù, ye bú a: «Mɔ mè wò gule beè yàgà kwá ŋgwéh, sâ wò gà njeré déì beè mò kwà ndé cú ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔ̂ŋ Piêr deén baá-re ndɔ, ye bú a: «Á sâ, mɔ né mân, Fehtoò mò, sâ léláŋ gulè gí cégé ndé cú, wò yàgà bílí mè mé be bɔ̂ feh mene!» ");
INSERT INTO mcu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeésò ye bú a: «Nuaá mé kou ŋaga gi aá yo kèn baá ŋagásé, à yo mbei fà kòù dèn ndé cú, à yaga lom nde aá gule. Bí dé biì ŋaga gi né ŋagaà dág. Njèh cén, bí dɔɔ́ŋ sam.» ");
INSERT INTO mcu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sâ Yeésò né gi nuaá mé né sàrnyé lètenè bɔɔ̀n kɔɔ́. À lé ménâ tueé naâ dé cî, ye bɔ́ a: bí dɔɔ́ŋ sam. ");
INSERT INTO mcu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","À yeé yaga gi aá bɔ́ gule, à su cu cɔ̀gɔ̀ seèn, à nde cu yí kwarè yâb. Jomo sâ ye bɔ́ a: «Njií mé mè bɔɔ́ naâ bí hên, bí né ŋgweé komo wa? ");
INSERT INTO mcu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bí mè yilá né Nùà fèh-njèh, bí mè yilá Nùà Dueè, bí mè yilá yií né teèn, mè tueé bí, mè né cí. ");
INSERT INTO mcu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mɔ mè Nùà fèh-njèh, gùm Nùà Dueè dɔɔ́ŋ, né bí gule beè yaga, sâ bí lètenè biì yàgà kú bèh ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mè la hên bɔɔ́ feéh naâ bí, te bí bɔɔ́ kuú den lètenè biì mân. ");
INSERT INTO mcu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mè né tueé ye bí a, ndɔ́g nùà seê beéh tele seê seèn hàm yɔ́gɔ́ bèh; nùà tebê nùà temâ hàm yɔ́gɔ́ ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kènê, bí ŋgweé baá kèn; mɔ bí né ménâ bɔɔ́, bí nde né samésé den. ");
INSERT INTO mcu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Mè mò mé bí dɔɔ́ŋ túé njí ŋgwéh ndɔ. Bɔ̀ɔ́ mé mè lé naâ bɔ́ balé weh, mè né bɔ́ kɔɔ́. Naâ ye te den faá né te mvù Càŋe nyagá den nɔ, ye: Nuaá mé né yáb mò yieé, bele seér cuù né mé mè kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mè bí toò hên tueé kwaá gi né te ndeè waà ye. Mɔ ndeè waà baá, te bí kwaá njií ye temé yoòr mò, ye hên né mè nuaá mé né nùà sâ bɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mè né tueé ye bí a, nuaá mé né nùà tebê mò ke nyegé dɔɔ́ŋ, ke nyegé né mè; nuaá mé né mè ke nyegé, ke nyegé né nuaá mé lé temà naâ mè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yeésò nde tueé gií, sâ feh baá bú ter ŋellé, ye bɔ́ a: «Mè né tueé ye bí a, nùà cén lètenè biì mè sar nde né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bɔ̀ mbɔ̀ŋ duɔɔ̂m lètenè bɔɔ̀n ke kuû ndɔ, ye à sâ jue né-re neì wa? ");
INSERT INTO mcu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sâ mbɔ̀ŋ dé mé yila yeé Yeésò yoòr doô né kwarè Yeésò doó sâ cer den. ");
INSERT INTO mcu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔ̂ŋ Piêr me njií bú mé be, ye bú a: «Jɔ̀gɔ̀ bíé náb ke Yeésò nùà sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mbɔ̀ŋ doô geér nde yoòr seèn ndɔ, bie njií ye Yeésò a: «Sâ dé sâ né neì mân, Fehtoò?» ");
INSERT INTO mcu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeésò ye bú a: «Mè nde né dòù breêd te to cie weh, mè haá njií nuaré déì, sâ né nùà sâ.» À weh baá-re dòù breêd doô, à cie haá njií Júdàs ŋunà Simɔ̂ŋ Iskariô ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Júdàs mé dòù breêd beè Yeésò weèh, *Sátàn mé bú yoòr yilâ ndɔ. À yeé weh baá, Yeésò ye bú a: «Njií mé wò gwaán né bɔɔ̂ sâ bɔ́ lòm kukwar!» ");
INSERT INTO mcu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kwɔ̀m njií mé Yeésò né bú tueé den sâ, bɔ̀ɔ́ mé né gi kwarè yâb sâ dɔɔ́ŋ ŋgwé kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sâ mvugó kàgàlɔ̀ŋ né yeé beè Júdàs ndɔ; bɔ̀ déì munó baá-re ye merré déì Yeésò tema né bú bèh njèh cieé koô ŋge wellê, te gam bɔ́. Bɔ̀ déì ye merré déì Yeésò ye bú a: ndé bɔ̀ saám bɔ̀ njeré déì haá bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Júdàs yeé weh aá breêd beè Yeésò, à yuo kela sa. Sâ baá cíbítenè mân. ");
INSERT INTO mcu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Júdàs yeé nde aá, Yeésò ye bɔ̀ mbɔ̀ŋ a: «Kènê terreb Huaán Nùàr ŋené ŋagá baá kèn. Be terrèb Càŋ ŋené yuo kelà baá cie. ");
INSERT INTO mcu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Gèh dé mé Huaán Nùàr né bɔ̀ nùàr be terrèb Càŋ feh keéh hên, Càŋ mé feh seèn nde né bɔ̀ nùàr be terrèb Ŋuna seèn bèsɔ́nè feh keéh, nde né toò hên ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bɔ̀ huaán mò, béh bí dèn màgà ndé cú! Bí nde né mè fɔɔ́n. Mè tueé né mé bí faá mè lé tueé naâ mé bɔ̀ *Jûf nɔ, ye bɔ́ a: njèh cén, bí ké bèh denè mò wá kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","«Bí ŋgwé cú ndéb mò dé feê: bí gwàn kú lètenè biì mé temé cén. Bí gwaán kuú lètenè biì faá mè né bí mé temé cén gwaán nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mɔ bí né lètenè biì mân gwaán kuú, bɔ̀ nùàr nde né mé njéh ŋené kɔɔ́ ye bí né bɔ̀ mbɔ̀ŋ mò.» ");
INSERT INTO mcu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔ̂ŋ Piêr bie njií ndɔ, ye bú a: «Wò nde né he wa, Fehtoò beèh?» Yeésò ye bú a: «Dé kènê wò mè ké bèh denè mò sâ bèlè kòmò ndé ŋgwéh; kɔ ndeè baá jomo, wò ndeè ye teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piêr ye bú a: «Mè wò jomo kènê bèlè ndé ŋgwéh mé ŋgei wa, Fehtoò beèh? Mè baá gi hên, né mene cio felè yeè, mè nde lom né dé mò kuú.» ");
INSERT INTO mcu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeésò bie njií cu, ye bú a: «Wò ye né mene cio, nyí nde né felè mò kuú sé wa? Mè né tueé ye wò a, lan mé kwaá sé nde tuagá, sâ wò yaáŋ aá njó baá mbei tagár, ye nyí mè kɔ́ ŋgwéh ma.» ");
INSERT INTO mcu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeésò den cuù, ye bɔ́ a: «Bí té ndìò, bí temé kwá njí lòm yoòr Càŋ mé yoòr mò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bèh denè né ké gwò Tele mò teèn ŋgún, mè nde né bí bèh denè dé biì ké teèn nyegé kwaá ndɔ. Mɔ sé né nyeén, mè sé la bí mân túé ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mɔ mè wa ké teèn, mè nyegé gi aá bí bèh denè, mè ndeè né cuû, mè weh bí, bí nde den ké yoòr mò, béh bí den bècénè. ");
INSERT INTO mcu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bí né gi ceér mé nde né ké bèh sâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomâs ye bú a: «Fehtoò beèh, béh bèh ndeê yeè kɔ́ ŋgwéh, béh ceér kɔ nde né naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeésò ye bú a: «Ceér sâ né mè; gècên né mè, yɔ̀ŋ né mè ndɔ. Nuaá mé yoòr mò kélá ŋgwéh, à ké yoòr Tele mò wá ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mɔ bí né mè kɔɔ́, sâ bí kɔ baá Tele mò kèn. Á sâ, kènê bí baá Tele mò kɔɔ́, bí ŋene gi aá bú kèn.» ");
INSERT INTO mcu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filîp deên ndɔ, ye bú a: «Fehtoò beèh, fèh kéh yeè béh Tele yeè teèn, te temé die béh lè.» ");
INSERT INTO mcu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeésò ye bú a: «Hên baá dàb mé béh bí né kɔɔ́, wò mè ŋéné kɔ́ ŋgwéh wa, Filîp? Nuaá mé ŋene aá mè, ŋene né Tele mò sâ. Wò tueé den cu né kei, ye: fèh kéh béh Tele yeè teèn wa? ");
INSERT INTO mcu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wò née temé teèn kwá njí ŋgwéeh ye, ye mè né yoòr Tele mò, Tele mò né yoòr mò ndɔ wa? Bɔ̀ ŋgòr mé mè né gi bí tueé hên dɔɔ́ŋ lè mò yùò ŋgwéh; né Tele mò, mé né yoòr mò, bɔɔ́ den né seé seèn kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bí kwá njí lòm temé te ŋgòr mò tég, ye mè né yoòr Tele mò, Tele mò né yoòr mò ndɔ. Hên né cegé mene te bɔ̀ seé hên, bí ka teèn ŋéné kɔ́ ŋgwéh ye né môn wa? Bí kwá njí lòm temé te ŋgòr mò nɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Mè né tueé ye bí a, nuaá mé né temé yoòr mò kwaá njií dɔɔ́ŋ, nde né bɔ̀ seé hên faá mè nɔ bɔɔ́, à nde né mé bɔ̀ dé kokoô mene bɔɔ́ bilí. Lòù sam, mè nde aá ké yoòr Tele mò ndeé. ");
INSERT INTO mcu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bɔ̀ njií mé bí né gi mé yilí mò dua dɔɔ́ŋ, mè nde gi né bí ménâ bɔɔ́, te Huaán sɔm keêh terreb Tele seèn bèsɔ́nè. ");
INSERT INTO mcu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sâ, mɔ bí né mè njeré déì mé yilí mò dua, mè njií sâ bɔɔ́ nde né ménâ.» ");
INSERT INTO mcu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Mɔ bí né mè gwaán, bí nde né sòn mò ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Sâ mè nde né Tele mò dua, te à tema njií bí nùà gàm déì, né Cúcuí mé gècên yoòr, te bí bɔ́ den beh kɔɔ́; nde né dé kèì cên ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dé sâ bɔ̀ *wɔ́ŋ bɔ̀ bú kwà kòmò bèh; lòù sam, bɔ́ bú ŋéné bèh, bɔ́ bú kɔ́ ŋgwéh ndɔ. Bí né bú dé biì kɔɔ́; lòù sam, bí bɔ́ né kɔɔ́, à nde né lè biì den. ");
INSERT INTO mcu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mè bí mé huún sì lɔ́ ndé ŋgwéh, mè ndeè né ká yoòr biì cuû. ");
INSERT INTO mcu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Le aá maànjé sâ wɔ́ŋ mè ŋéné ndé cú, bí ŋene lom nde né mè kɔɔ́. Lòù sam mè nde né làŋ, bí nde né làŋ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mɔ baá loù sâ, bí nde né ŋgweé komo, ye mè né yoòr Tele mò, wa bí né yoòr mò, mè né yoòr biì ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nuaá mé né ŋgòr mò ŋgweé, né ménâ jolo, né nuaá mé gwaán né mè sâ. Nuaá mé gwaán né mè, Tele mò nde né bú gwaán, mè nde né bú gwaán ndɔ; mè ŋené yuo kela bilí ndeè né mé toò seèn mene.» ");
INSERT INTO mcu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sâ lètenè bɔ̀ mbɔ̀ŋ seèn, bɔ̀ Júdàs né fà, déì né Júdàs, déì Júdàs Iskariô. Bú mé né Júdàs doô ye bú a: «Fehtoò beèh, bɔɔ́ né naàn mé wò ŋené yuo kela cegé ndeè né toò beèh, wò toò bɔ̀ *wɔ́ŋ bɔ̀ ŋéné yùò kélá ndé ŋgwêh wa?» ");
INSERT INTO mcu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeésò ye bú a: «Nuaá mé gwaán né mè, nde né ŋgòr mò jolo. Sâ Tele mò nde né bú gwaán, bêh Tele mò fà dɔɔ́ŋ ndeè né ké yoòr seèn ndeé, béh bɔ́ den beh. ");
INSERT INTO mcu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nuaá mé mè gwàn ŋgwéh, ŋgòr mò jòlò ndé ŋgwéh ndɔ. Mè bɔ̀ ŋgòr hên mé feh mò túé ŋgwéh, né Tele mò nuaá mé lé temà naâ mè, tueé né bí kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Mé njéh mene, béh bí née kɔɔ́ ye, mè bí bɔ̀ ŋgòr hên tueé den né dé cî. ");
INSERT INTO mcu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Le aá maànjé nùà gàm biì nde aá waâ. Né Cúcuí Ŋagâ, Tele mò tema njií ndeè né bú mé yilí mò. Mɔ à waà baá, à nde gi né bí njèh dɔɔ́ŋ feh, à nde cu né bí bɔ̀ ŋgòr mò dɔɔ́ŋ feh ko cu ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Mè hên kwaá lɔ né bí dɔlê, né mboó mò. Njèh cén, mè bí lòù faá bɔ̀ nùàr lab yeé nɔ, làb ŋgwéh. Bí té njeré déì ndìò, bí té vèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bí la naá giì ŋgweé, mè la ye bí a: mè nde né yuo; mé njéh mene wa, mè nde cuù né ká yoòr biì ndeê ma. Mè tueé bí, mɔ bí sé la né mè gwaán, bí sé la né lòù samé seér, ye mè nde né ké kwarè Tele mò; à né nùà koô kɔɔ́ mé mè. ");
INSERT INTO mcu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mè bí toò hên tueé kwaá gi né te ndeè waà ye. Mɔ ndeè waà baá, te bí kwaá njií ye temé teèn. ");
INSERT INTO mcu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","«Kènê mè bí njèh kókoó túé màgà ndé cú; mgbè wɔ̂ŋ baá ndeê. Njèh cén, à mé terreb felè mò sam. ");
INSERT INTO mcu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","*Wɔ́ŋ a, kékɔɔ̀ ye mè né lom Tele mò gwaán faá cí nɔ; wɔ́ŋ a, kɔ́ɔ ye mè bɔɔ́ lom né faá Tele mò lé tueé naâ mè ndɔ.» À yeé tueé gi aá mân, ye bɔ́ a: «Bí wùò ter, béh yuo doó hên yuoò!» ");
INSERT INTO mcu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Mè né dé mò toú dé jéjêg. Tele mò né nùà njèh, à toú sâ kie né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bɔ̀ béh mò mé tàb wá ŋgwéh dɔɔ́ŋ, à né yeé bɔ́ kɔré sɔm. À mbellé nyegé bɔ̀ɔ́ mé né tàb waá, te bɔ́ wa sagá cu déì. ");
INSERT INTO mcu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bɔ̀ ŋgòr mò sie dilí nyegé gi aá bí dé biì kèn. ");
INSERT INTO mcu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bí dèn nyɔ̀gɔ̀ dèn yoòr mò, faá mè né yoòr biì den nyɔgɔ́ den nɔ. Mɔ béh toû te meí toû nyɔ̀gɔ̀ dèn ŋgwéh, à tàb wá kòmò ndé ŋgwéh. Mɔ bí yoòr mò nyɔ̀gɔ̀ dèn ŋgwéh, bí tàb wá ndé ŋgwéh ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Mè dé mò né meí toû, bí né béh mò. Nuaá mé né yoòr mò nyɔgɔ́ den, mè né yoòr seèn nyɔgɔ́ den dɔɔ́ŋ, tàb kókoó wa nde né kɔɔ́; wanɔɔ́ŋ bí njeré déì bɔ́ kòmò ndé ŋgwéh, kɔ mè né teèn, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nuaá mé dé seèn yoòr mò nyɔ̀gɔ̀ dèn ŋgwéh, ŋɔgɔ die gi aá ké doó faá béh toû, bɔ́ ŋuaán fu njií tuar, à ŋgie yuo. ");
INSERT INTO mcu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mɔ bí nyɔgɔ́ den né yoòr mò, bí né mé ŋgòr mò lè ŋgulí den, sâ bí dua mene njií mé bí né gwaán dɔɔ́ŋ, bí nde né kwa gií. ");
INSERT INTO mcu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mɔ bí né lom tàb mé gècên mene waá, bí né mé njéh feh keéh ye bí né bɔ̀ mbɔ̀ŋ mò sâ. Terreb Tele mò nde né teèn ŋené ŋagá. ");
INSERT INTO mcu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Mè bí gwaán lom né faá Tele mò né mè gwaán nɔ. Bí dèn nyɔ̀gɔ̀ ndé lòm yoòr mò nɔɔ́ŋ, bí kɔ́ lòm mè. ");
INSERT INTO mcu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mɔ bí né ŋgòr mò jolo, temé mò nde né yoòr biì le; faá mè né sòn Tele mò ŋgweé, temé seèn le yoòr mò nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mè bí ménâ tueé kuú né ye te bí den lom mé vɔ́gɔ́-temé faá mè nɔ, te bí samé gi mé gùm mene. ");
INSERT INTO mcu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Ndéb mò né mân: bí gwàn kú lètenè biì mé temé cén faá mè gwaán né bí nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gwaân dé koô mé nùàr nde né bèsɔ́nè sɔm keéh, né yɔ̀ŋ seèn felè bɔ̀ mbaábɔɔ̀n siì. ");
INSERT INTO mcu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mɔ bí né faá mè tueé nê nɔ bɔɔ́, sâ bí né bɔ̀ mbeí mò, ");
INSERT INTO mcu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","mè bí bɔ̀ seé bɔ̀ yílá ndé cú. Lòù sam, nùà seê beéh ndègè tele seê seèn kɔ́ bèh. Dé biì, mè feh keéh gi aá bí ndègè bɔ̀ njií mé mè né ké sònò Tele mò ŋgweé kèn. Bí kɔ́ɔ ye, bɔ̀ mbeí mò né bí. ");
INSERT INTO mcu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bí lé mè kɔɔ́ bàlè wèh lɔ́gɔ́ ná ŋgwêh, mè lé balé weh seér naâ bí kɔɔ́, mè jege haá bí seé beè, ye bí a, ndé wá tàb, te tàb biì sâ le ter. Sâ dɔɔ́ŋ né te Tele mò haá laré bí bɔ̀ njií mé bí dua né mé yilí mò. ");
INSERT INTO mcu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mè taga lom né bí gwaân: bí gwàn kú dèn lètenè biì cu dɔɔ́ŋ mé temé cén.» ");
INSERT INTO mcu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Mɔ wɔ́ŋ né bí bunó, bí kɔ́ɔ ye wɔ́ŋ lé bunó lɔgɔ́ naâ mè, te bunó ye bí ma. ");
INSERT INTO mcu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mɔ bí sé né bɔ̀ wɔ́ŋ bɔ̀, wɔ́ŋ sé naâ bí gwaán, ye bí né bɔ̀ nùàr nyî. Á seèn môn sam; mè bí balé weh gi aá kèn, bí bɔ̀ nùàr seèn sam cuú, à bí bunó né mé njéh. ");
INSERT INTO mcu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bí mùnò kɔ́ cú faá mè lé tueé naâ bí nɔ, mè lé ye bí a: ndɔ́g, nùà seê beéh tele seê seèn hàm yɔ́gɔ́ bèh ma. Mɔ bɔ́ lé naâ mè bunó, sâ bɔ́ bí bunó nde né ménâ ndɔ. Mɔ bɔ́ lé naâ ŋgòr mò jolo, sâ bɔ́ nde né dé biì ménâ jolo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mè tueé bí, bɔ́ bí bɔ̀ njií hên dɔɔ́ŋ bɔɔ́ gi nde né felè mò. Lòù sam, nuaá mé lé tema njií naâ mè, bɔ́ bú kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","«Mɔ mè sé ká yoòr bɔɔ̀n wá ná ŋgwêh, mè tueé bɔ́ ŋgòr Càŋ, ju sé bɔ́ mé veên bɔɔ̀n sìè ná ŋgwêh. Dé kènê, bɔ́ mé sòn sam cuú. ");
INSERT INTO mcu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mè tueé bí: nuaá mé né mè bunó, bunó bilí né mé Tele mò mene. ");
INSERT INTO mcu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Seé mé nuaré déì sé bɔ́ kòmò ná ŋgwêh, mɔ mè sé lètenè bɔɔ̀n bɔ́ ná ŋgwêh, bɔ́ sé mé ju yoòr ná ŋgwêh ndɔ. Á, bɔ́ ŋene gi aá kèn, bɔ́ mè bunó seér né lòù, bɔ́ né Tele mò bunó. Ŋgweéh sâ bɔ́ né mé ju yoòr wa? ");
INSERT INTO mcu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá bɔ́ lé nyagá kwaá giì naâ te mvù sóù bɔɔ̀n nɔ, ye: Bɔ́ bunó weh né mè mbaá, kwɔ̀m sam.» ");
INSERT INTO mcu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jomo sâ Yeésò den cuù, ye bɔ́ a: «Nuaá mé gam nde né bí baá ndeê: né lom Cúcuí jéjêg mé né ké beè Tele mò. Mè nde né bú temá njií, à yuo ndeè né ké yoòr seèn, à sòn mò tueé nde né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bí nde né sòn mò tueé ndɔ; lòù sam, ké bèh duɔɔ̂m béh bí lé naâ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mè bí ménâ tueé den né ye te ndèm biì yúá cú. ");
INSERT INTO mcu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bɔ́ nde né bí te *gwà sóù kwɔgɔ́ sɔm. Cu déì nde né teèn, bɔ́ nde né bí lòù wulá. Bɔ̀ɔ́ mé wula nde né bí sâ nde né munó, ye bɔ́ sâ bɔɔ́ né seé Càŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bɔ́ nde né môn bɔɔ́ gɔ. Lòù sam, bɔ́ Tele mò kɔ́ ŋgwéh, bɔ́ mè kɔ́ ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mè bí toò hên tueé kwaá né, ye mɔ ndeè baá bí cu sâ kwa, te bí kɔ ye, mè lé naá giì bí mân tueé.» À den cuù, ye bɔ́ a: «Mè lé bí mân ké bèh duɔɔ̂m túé ná ŋgwêh. Lòù sam, béh bí lé naá née kɔɔ́ ye. ");
INSERT INTO mcu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dé kènê baá gò mò, mè nde cu aá ké yoòr nuaá mé lé temà naâ mè. Bɔɔ́ né naàn mé lètenè biì nuaré déì teèn bíé kè ŋgwéh, ye mè a: wò nde né he wa? ");
INSERT INTO mcu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sâ tueé né ye, kú né bí njèh bɔɔ́; bɔɔ́ né bí mé ŋgòr mò. ");
INSERT INTO mcu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Á sâ, mè tueé lom né bí gècên ndɔ, ye bí a: dé biì, huɔm kela né dé mè nde ménâ. Mɔ mè môn ndé ŋgwéh, nùà gàm biì ká yoòr biì wá ndé ŋgwêh ndɔ. Kɔ mè nde, te mè tema njiî ye bú. ");
INSERT INTO mcu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Mɔ à ndeè waà baá, à nde né bɔ̀ nùàr ká te wɔ́ŋe feh keéh, te bɔ́ gwaán komo ye veên bɔɔ̀n né veên ma. Bɔ́ gwaán komo gècên mò ndɔ, bɔ́ ŋene kɔ gèh dé mé Càŋ nde né ju tená. ");
INSERT INTO mcu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Veên mé à nde né bɔ́ feh keéh sâ, ye bɔ́ temé yoòr mò kwá njí ŋgwéh ma. ");
INSERT INTO mcu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dé gècên mò, mɔ mè ŋaá nde cu aá ké yoòr Tele mò, mé bí mè ŋéné ndé cú doô, gècên mò nde né teèn ŋené ŋagá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dé ju tenâ, gèh dé mé ju né mgbè wɔ̂ŋ karé sie, bɔ́ nde né mé njolo ŋené. ");
INSERT INTO mcu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mè née cu bí mé bɔ̀ njèh tueê ká lè mò silí den ye. Njèh cén, bí bɔ́ kènê yóló kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mɔ Cúcuí Ŋagâ jéjég sâ ndeè waà baá, à nde né bí bèh gècên dɔɔ́ŋ feh gií. À ndeè mé feh seèn mbaá túé wèh ndé ŋgwéh ndɔ, à tueé lom nde né dé mé à ŋgweé naâ ké jomo; njií mé ndeè né waâ dɔɔ́ŋ, à nde né bí tueé kwaá. ");
INSERT INTO mcu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","À terreb mò cie sɔm keéh nde né kɔɔ́. Lòù sam, à ŋgòr ŋgweé nde né sònò mò, te à tueé ye bí. ");
INSERT INTO mcu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bí kɔ́ɔ ye, ŋgúlú Tele mò dɔɔ́ŋ né gi beè mò. Mè tueé né dé cî ye bí a, bɔ̀ njií mé Cúcuí Ŋagâ tueé nde né bí dɔɔ́ŋ yuo gi ndeè né sònò mò ma.» ");
INSERT INTO mcu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","À den cuù, ye bɔ́ a: «Le aá maànjé bí mè ŋéné ndé cú, te jomo sâ maànjé bí ŋene cu ye mè.» ");
INSERT INTO mcu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","À yeé tueé aá bɔ́ mân, bɔ̀ mbɔ̀ŋ seèn déì duɔɔ̂m lètenè bɔɔ̀n tueé beleè ndɔ, ye: «Dé sâ tueé né kei, mé à ye béh a: le aá maànjé béh nyí ŋéné ndé cú, te jomo sâ maànjé béh ŋene cu ye nyí wa? Mé à ye: lòù sam, nyí ŋaá nde cu aá ké yoòr Tele nyî doô ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bɔ́ den cuù ye: «Sâ tueé né gèh le aá maànjé dé heè? Dé mé à gwaán né tueê sâ, béh bú ŋgwé kòmò ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeésò ŋgweé kɔ ndɔ, ye bɔ́ gwaán né mé nyí bieé njiî, à tueé njií baá-re ye bɔ́ a: «Mè la ye bí a: le aá maànjé bí mè ŋéné ndé cú, te jomo sâ maànjé bí ŋene cu ye mè. Mè yeé tueé mân, bí bɔ̀ njèh lètenè biì hên bie kuú den né teèn wa? ");
INSERT INTO mcu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","«Mè né tueé ye bí a, dé biì bí nde né yueé; *wɔ́ŋ dé seèn samé seér nde né lòù. Temé nde né bí lè ŋgwerré; mé njéh mene yúlá-temé biì nde cu né vɔ́gɔ́-temé ŋaá seér. ");
INSERT INTO mcu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mɔ ma déì nde aá huaán ŋar, né yeé bú ménâ yulá; sâ lòù sam, à muno njií lom né núr nyeèr felè seèn. Mɔ huaán baá ká cie, à nde cu né núr nyeèr hèllè nyen njií. Nde né felè vɔ́gɔ́-temé ŋuna seèn mé à la ŋar kwaá naâ doô. ");
INSERT INTO mcu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nde ménâ mé bí ndɔ; kènê bí né mé yúlá-temé. Mé njéh mene, mɔ mè ndeè ŋene cu aá bí, temé biì nde né lòù vɔgɔ́ seér; nuaré déì ndeè bí vɔ́gɔ́-temé sâ beè lùàgà sɔ̀m ndé cú. ");
INSERT INTO mcu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Loù sâ, njèh dɔɔ́ŋ den nde né njolò biì ŋagásé, bí mè lòù bíé sɔ́ ndé cú. Mè né tueé ye bí a, bɔ̀ njií mé bí dua né mé yilí mò dɔɔ́ŋ, Tele mò nde né bí haá gií. ");
INSERT INTO mcu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ŋgweéh, wa hên bí née njeré déì mé yilí mò dùà ŋgwéeh ye wa? Bí dùduaà, bí nde né kwa, sâ te temé biì sagár gi ye lè.» ");
INSERT INTO mcu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mè bí njèh hên dɔɔ́ŋ tueé keéh gi yeé te kàne te kàne. Cu déì ndeè né waâ, mè bí njèh te kàne sì kéh ndé cú, mè tueé ŋagá seér nde aá bí felè Tele mò lòù. ");
INSERT INTO mcu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te loù sâ bí bɔ̀ njèh mé Tele mò bie njií lom aá mé yilí mò; mè bú felè biì lòù bɔ̀ŋ sɔ́ ndé cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","À né gi bí mé feh seèn gwaán. Lòù sam, bí né mè gwaán, bí né temé yoòr mò kwaá njií, ye mè lé yuoó naâ beè seèn. ");
INSERT INTO mcu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Né bɔ̀n, mè lé yuoó naâ ké te vulúu beè Tele mò, mè suagà ká te wɔ́ŋe. Kènê, mè kwaá lɔ cu nde aá wɔ́ŋ, mè nde cu ké yoòr Tele mò.» ");
INSERT INTO mcu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","À yeé tueé gi aá mân, bɔ̀ mbɔ̀ŋ seèn ye bú a: «Kè-re sâ nɔ, kènê wò tueé ŋaré njií lom aá juar, wò kàn sìlì sɔ́ cú. ");
INSERT INTO mcu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kènê béh kɔ gi aá kèn, ye wò né gi njèh dɔɔ́ŋ kɔɔ́, wò jɔ̀gɔ̀ naá giì njèh bieê beèh ŋgweé, te béh nde ye bieé den. Béh temé yoòr yeè hên kwaá njií né dé cî, ye wò lé yuoó naâ ké beè Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeésò deên ndɔ, ye bɔ́ a: «Bí baá ye gwaán sâ nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mè tueé bí: cu baá ndeê, hên baá giì cí. Cu mé bí nde gi né teèn durá ŋellé, waà baá; nùà kàn nde né gwò seèn dula yilá, mè le mé huún. Mé njéh mene, ndɔ́g, mè mé huún sam: bêh Tele mò né kɔɔ́! ");
INSERT INTO mcu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mè né bí mân toò tueé kwaá, ye te bí mban nde gi yoòr mò, temé die bí lè. Mè tueé bí, dé ká te wɔ́ŋe bí nde né mé gèr kwaré. Mé njéh mene, bí sìè lòm temé tég, mè yɔgɔ́ gi aá wɔ́ŋ kèn!» ");
INSERT INTO mcu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeésò yeé tueé gi aá mân, à ke njií ké te vulúu ndɔ, ye Tele a: «Tele mò, cu wulu baá kèn. Sɔ̀m kêh be terrèb Ŋuna yeè bèsɔ́nè, te Ŋuna yeè sɔm njií be terrèb yeè ter ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ŋgweéh wò lé terreb felè bɔ̀ nùàr dɔɔ́ŋ haá giì naâ beè seèn wa? Wò lé naâ tueé ye bú a, há yɔ̀ŋ tètàgà mé bɔ̀ɔ́ mé wò haá kwaá né beè seèn. ");
INSERT INTO mcu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mɔ bɔ́ kɔ baá wò, Càŋ jéjêg, bɔ́ kɔ cu Yeésò *Nùà Cɔ̀ŋ mé wò lé naâ tema njiî, sâ né yɔ̀ŋ tètàgà sâ. ");
INSERT INTO mcu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tele mò, mè feh gi aá bɔ̀ nùàr ká doó be terrèb yeè kèn, mè bɔɔ́ gi aá seé mé wò lé tueé naâ mè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sâ kènê Tele mò, kwá mè den yila cu te dene koô mò ké yoòr yeè doô; lɔ naâ bèh denè mò, sâ wɔ́ŋ née dùɔ̀m ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Mè feh keéh gi aá wò mé bɔ̀ɔ́ mé wò lé yilá kwaá naâ beè mò ká lè wɔ́ŋe kèn, kènê bɔ́ né gi wò kɔɔ́. Bɔ́ lé naâ bɔ̀ dé yeè, wò lé bɔ́ haá kwaá naâ beè mò, bɔ́ jolo kɔ gi aá ŋgòr yeè kèn. ");
INSERT INTO mcu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kènê bɔ́ né gi kɔɔ́ ye bɔ̀ njií mé né ká beè mò dɔɔ́ŋ né gi dé yeè; wò lé haá naâ mè kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Lòù sam, bɔ̀ ŋgòr mé wò lé ye mè a ndé bɔ́ tueé dɔɔ́ŋ, mè bɔ́ tueé gi aá kèn, bɔ́ gwaán gi aá ndɔ. Bɔ́ ŋene kɔ gi aá kènê ye, mé gècên mene, mè lé yuoó naâ ké beè yeè, bɔ́ né temé teèn kwaá njií, ye wò lé temà naâ mè kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Mè tétég dua né wò felè bɔ̀ sâ bɔ̀, Tele mò. Mè bɔ̀ *wɔ́ŋ bɔ̀ júé ŋgwéh, mè dua lom né wò felè bɔ̀ɔ́ mé wò lé haá naâ mè hên, bɔ́ né dé bɔɔ̀n bɔ̀ nùàr yeè. ");
INSERT INTO mcu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bɔ̀ njií mé né gi dé mò dɔɔ́ŋ né dé yeè; bɔ̀ dé yeè né gi bɔ̀ dé mò ndɔ; terreb mò cie ŋené yuo kelà né yoòr bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","«Kènê mè dé mò ká lè wɔ́ŋe sam cuú, mè nde cu nde aá ké yoòr yeè; dé bɔɔ̀n, bɔ́ née ká te wɔ́ŋe ye. Càŋ ŋagâ Tele mò, kúrú bílí kwá bɔ́ ka yeè mé terreb yeè mé wò lé haá naâ mè doô; kúrú bílí bɔ́, te bɔ́ ŋa bilí gi cén, faá bélɔ̀ né cén nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cu mé béh bɔ́ lé naâ kɔɔ́, mè lé kurú nyegé naâ bɔ́ kɔɔ́. Lé naâ mé terreb yeè mé wò lé haá naâ mè, cén déì lètenè bɔɔ̀n lèr lè ŋgwéh ndɔ. Gi lom né ka nuaá mé sé naá kaà dé seèn leér sâ, te yuo faá bɔ́ nyagá kwaá né te mvù Càŋe nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kènê mè baá ké yoòr yeè ndeê, mè ká te wɔ́ŋe mân tueé den cu née ye te bɔ́ den dé bɔɔ̀n mé vɔ́gɔ́-temé faá mè nɔ, te temé bɔɔ̀n gùm dɔɔ́ŋ sagár gi lè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","«Mè tueé gi aá bɔ́ ŋgòr yeè kèn. Wɔ́ŋ né bɔ́ bunó ndɔ. Lòù sam, wɔ́ŋ ye bɔ́ bɔ̀ nùàr nyî sam, faá mè nùà wɔ̂ŋ sam ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mè túé ŋgwéh ye wò a, yílá sɔ̀m bɔ́ ká te wɔ́ŋe yilà; mè tueé seér né ye wò a, kúrú nyégé bɔ́, te táhòrò bɔ́ kèmà cú. ");
INSERT INTO mcu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bɔ́ dé bɔɔ̀n bɔ̀ wɔ́ŋ bɔ̀ sam, faá mè nùà wɔ̂ŋ sam doô nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","*Sènè ŋágá kwá lòm bɔ́ mé gècên yeè bèsɔ́nè; gècên yeè sâ né ŋgòr yeè. ");
INSERT INTO mcu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mè tema njií né bɔ́ wɔ́ŋ dɔɔ́ŋ, faá wò lé tema njií naâ mè ká te wɔ́ŋe ndɔ nɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mè wò gùm mò hên *semé haá kuú né felè bɔɔ̀n, te bɔ́ den lom *senésé dé kèì cên. ");
INSERT INTO mcu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Mè wò felè bɔɔ̀n dùà lòm cú, Tele mò; mè dua cu né wò felè bɔ̀ɔ́ mé ŋgweé nde né ŋgòr yeè sònò bɔɔ̀n, bɔ́ kwaá njií temé yoòr mò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mè ye wò a, te bɔ́ dɔɔ́ŋ bilí ŋa lom cén, bɔ́ den ndeè yoòr beèh, faá wò né yoòr mò, mè né yoòr yeè nɔ. Te bɔ́ nyɔgɔ́ bilí bècénè, wɔ́ŋ kɔ ye wò lé tema njií naâ mè kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mè jɔgɔ njií né bɔ́ ter, faá wò né mè jɔgɔ́ njií nɔ; te bɔ́ ŋa cén faá bélɔ̀ né cén hên nɔ: ");
INSERT INTO mcu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mè né yoòr bɔɔ̀n, wò né yoòr mò, sâ te bɔ́ te yuo nyegé cén bagasé mân, te bɔ̀ wɔ́ŋ bɔ̀ ŋene môn, bɔ́ kɔ ye wò lé tema njií naâ mè kɔɔ́, wò gwaán né bɔ́ faá wò gwaán né mè ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Tele mò, wò lé bɔ́ haá kwaá naâ beè mò, mè né gwaán ye béh bɔ́ nde den ké bèh denè mò kɔɔ́, te bɔ́ ŋene kɔ be terrèb mò teèn. Wò mè gwaán né mé temé cén, wò lɔ mè terreb koô haá naâ ké yoòr yeè sâ wɔ́ŋ née dùɔ̀m ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Tele mò, kè njí kán, wò mé be gècên yeè mene, wɔ́ŋ wò ŋéné kɔ́ ŋgwéh, mè kɔ cegé né wò kɔɔ́; bɔ̀ hên bɔ̀ né ŋené kɔɔ́ ye wò lé tema njií naâ mè kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mè feh gi aá bɔ́ yilí yeè kèn; mè nde cu née bɔ́ yilí yeè ménâ feh den ye, te gèh gwaân mé wò né mè gwaán doô den lètenè bɔɔ̀n, te mè den lè bɔɔ̀n môn ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yeésò yeé tueé gi aá mân, à weh bɔ̀ mbɔ̀ŋ seèn ndɔ, bɔ́ bɔ́ sela yuo kela nòmò Kiderɔ̂ŋ kèb yágà. Sâ yí jomo nòmò sâ lé naâ ŋueèh sɔgɔ̀ déì. Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn lé yila ndeè naâ teèn. ");
INSERT INTO mcu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sâ Júdàs sàrnyé né gi bèh sâ kɔɔ́ ndɔ. Lòù sam, Yeésò bɔ́ bɔ̀ mbɔ̀ŋ seèn lé naá beéh teèn bilí ndeé. ");
INSERT INTO mcu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Loù sâ Júdàs kem sie bɔ̀ŋ bɔ̀ sɔ́jì beè; bɔ́ bɔ́ nde yí teèn. Bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ *Farisiên sɔm haá cu bú bɔ̀ sɔ́jì dé bɔɔ̀n ndɔ, bɔ́ bɔ́ kem nde ké teèn mé gwaga beè-beè, bɔ́ né mé we beè-beè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sâ Yeésò kɔ gi aá njií mé nde né felè seèn kelá ndɔ. À yeé ŋene aá ménâ, à gɔ ŋa yuo kelà ká toò bɔɔ̀n juar ndɔ, ye bɔ́ a: «Bí fɔɔ́n yeé neì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bɔ́ ye bú a: «Béh fɔɔ́n né Yeésò nùà Najarêt.» Ye bɔ́ a: «Mè hên.» Sâ bɔ́ bɔ̀ Júdàs sàrnyé né gi doó sâ dɔɔ́ŋ njebá den. ");
INSERT INTO mcu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te Yeésò yeé nde tueé njií ye bɔ́ a, nyí hên mân, bɔ́ kem cu cu gè jomo mágu mágu, bɔ́ né doó jɔgɔ́ dielé ndeé. ");
INSERT INTO mcu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","À den cuù, ye bɔ́ a: «Bí ye bí fɔɔ́n yeé neì á?» Bɔ́ ye bú a: «Béh fɔɔ́n né Yeésò nùà Najarêt.» ");
INSERT INTO mcu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ye bɔ́ a: «Ŋgweéh mè ye bí a, mè hên wa? Mɔ hên bí fɔɔ́n den né mè, sâ bí kwá lɔ́ bɔ̀ hên bɔ̀ cu cu dé bɔɔ̀n lɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kɔ seèn bɔɔ́ ka mân jéjég, te yuo ye faá à la tueé naâ ye Tele seèn a: bɔ̀ nuaá mé à lé haá kwaá giì naâ beè nyî dɔɔ́ŋ, nyí cén déì teèn lèr lɔ́ ŋgwéh ma. ");
INSERT INTO mcu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sâ Simɔ̂ŋ Piêr naâ mé bòù beè, à sua sɔɔ̂m ndɔ, à mvur tena si njií nuaré déì tie gaâ doó. Lé naâ nùà seê ŋgàŋ sèmè dé koô. Yilí nùà hèllè lé naâ Malkùs. ");
INSERT INTO mcu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeésò yeé ŋene aá môn, à yiín Piêr, ye bú a: «Yí njí cú bòù yeè lè kórè nɔɔ́ŋ. Wò né munó ye ŋgàb gèr mé Tele mò haá né mè doô, mè bú wèh ŋúé ndé ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bɔ̀ bɔ̀ŋ sɔ́jì bɔ́ bɔ̀ kwaá-taâb bɔɔ̀n mé bɔ̀ sɔ́jì dé bɔ̀ Jûf dɔɔ́ŋ kem sue gi Yeésò yoòr, bɔ́ sie kaga bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bɔ́ jɔ̀gɔ̀ bú weh njií lɔgɔ̂ ké lɔ Hánà. Né gùnà Kayîf mé né *ŋgàŋ sèmè dé koô te nyèmà bú sâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Sâ Kayîf lé feéh naâ bɔ̀ Jûf kɔɔ́, ye bɔ́ a: «Huɔm kela né dé mé nùà cén kuú seér te sòn bɔ̀ mbeî dɔɔ́ŋ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔ̂ŋ Piêr bɔ̂ mbɔ̀ŋ cén déì yuo bele Yeésò ndɔ. Mbɔ̀ŋ dé sâ, ŋgàŋ Càŋ dé koô lé naâ bú dé seèn kɔɔ́ nyegé; yeé baá ménâ, à wa dé seèn ké teèn, à yila bele Yeésò ké lè bɔ̀gɔ̀ ŋgàŋ sèmè sâ. ");
INSERT INTO mcu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piêr njebá le dé seèn ké tùtúlù bɔ̀gɔ̀. Te mbɔ̀ŋ dé mé ŋgàŋ sèmè dé koô né bú kɔɔ́ doô yeé cu cuù, tueé nyegé baá ma mé njebá tena né te hin doô, à yií keéh ye Piêr. ");
INSERT INTO mcu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ma mé njebá tena né te hin hèllè deên ndɔ, ye Piêr a: «Wò hên, wò mbɔ̀ŋ nùà hên sam wa?» Piêr ye bú a: «Ndɔ́g, mè sam!» ");
INSERT INTO mcu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sâ dùlù baá dɔlé ndɔ, bɔ̀ seé bɔ̀ bɔ́ bɔ̀ sɔ́jì la naâ we cie fuú kwaá, bɔ́ né njebá ŋuagá den. Piêr yeé ŋene aá ménâ, à njebá nde kwarè bɔɔ̀n we ŋuagá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yeé baá mân, ŋgàŋ sèmè dé koô duɔɔ́m Yeésò bɔ̀ njèh felè bɔ̀ mbɔ̀ŋ seèn bieê, à né bú felè bɔ̀ njèh feèh seèn bieé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeésò ye bú a: «Mè bɔ̀ nùàr njèh dɔɔ́ŋ tueé njií yeé ké ter; mè feh den yeé te *gwà sóù, bɔ̀ déì te *gwà Càŋ koô; bɔ̀ Jûf né yeé teèn bilí ndeé; mè njeré déì lòù túé lèr bèh. ");
INSERT INTO mcu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wò mè ménâ bie né dé keì wa? Bíé njí mé bɔ̀ɔ́ mé lé naá giì ŋgweé, bɔ́ nde né wò tueé, bɔ́ né gi kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yeésò yeé baá mé bú mân tueé njií, sɔ́jì déì naâ kwarè seèn, bɔ bú, ye bú a: «Wò mé ŋgàŋ sèmè dé koô mân tueé den né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeésò deên ndɔ, ye bú a: «Mɔ mè tueé né ve, fèh kéh mè bèh veên mò sâ. Á, mɔ mè tueé yií né teèn, wò mè bɔ né dé keì wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jomo sâ *Hánà ye bɔ́ há njí bú mé Kayîf ndɔ. Bɔ́ weh njií baá-re bú ké toò Kayîf, ŋgàŋ sèmè dé koô, sâ à née te yuiî ye. ");
INSERT INTO mcu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sâ Simɔ̂ŋ Piêr née ka dé seèn cu sâ we ŋuagá den ye. Bɔ́ bie njií ye bú a: «Wò hên, wò mbɔ̀ŋ nùà hên sam á?» Piêr cam cu, ye bɔ́ a: «Ndɔ́g, mè mbɔ̀ŋ seèn sam.» ");
INSERT INTO mcu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sâ nùà seê *ŋgàŋ sèmè dé koô cén déì né doó sâ, à né nùàr nuaá mé Piêr la kɔ tené sɔɔ̂m naâ bú tie doô; à ye Piêr a: «Ŋgweéh mè la ké ŋueh ŋenè naâ bí bú wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mé njéh mene, Piêr cam cu. À yeé baá ménâ cam, kwaá cên tuaga lɔ bú teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cieé yeé ŋaga baá, bɔ́ weh Yeésò ké toò Kayîf, bɔ́ njií bú ké lɔ ŋgɔ́mnà Pilátò. Wa ké teèn, bɔ̀ Jûf dé bɔɔ̀n ké lè bɔ̀gɔ̀ yílá ŋgwéh, ye te sóú bɔɔ̀n bɔ́ lóró cú, bɔ́ yieé kwa yáb *Páskà. ");
INSERT INTO mcu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilátò lé ŋenè naâ cí, te à yuo kela ye ké cie yoòr bɔɔ̀n, ye bɔ́ a: «Bí nùà hên sie né mé ŋgei wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bɔ́ ye bú a: «Mɔ sé la nùà veên ná ŋgwêh, béh sé bú ká toò yeè sìè njí ná ŋgwêh.» ");
INSERT INTO mcu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilátò ye bɔ́ a: «Sâ mɔ né mân, bí wèh yùò mé bú weèh, bí nde tena ju felè seèn mé feh biì faá *sóú biì tueé yeé sâ.» Bɔ̀ Jûf ye bú a: «Ndɔ́g, béh dé beèh mé terreb nùàr wulâ sam.» ");
INSERT INTO mcu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hên dɔɔ́ŋ bɔɔ́ gi né, te yuo faá Yeésò lé tueé naâ nɔ; sâ gèh cio mé à nde né kuú, à lé naá giì jɔ̀gɔ̀ tueé kwaá. ");
INSERT INTO mcu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yeé baá mân, Pilátò yila nde cu gè jomo ndɔ, à yilá njiî Yeésò, ye bú a: «Mgbè bɔ̀ Jûf né wò wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeésò ye bú a: «Wò mân munó né kɔɔ́, wa bɔ́ tueé né wò lòù wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilátò ye bú a: «Wò ŋene mè né nùà Jûf wa? Bɔ̀ɔ́ mé bí bɔ́ né mé tàbè cên, mé bɔ̀ ŋgàŋ sèmè dé kokoô teèn mene la sie waà naâ mé wò kɔɔ́. Wò bɔɔ́ naâ kei wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeésò ye bú a: «Bèh Mgbè ceèr mò dé ká te wɔ́ŋe sam. Mɔ bɔ̀gɔ̀ Mgbè mò sé la né dé ká lè wɔ́ŋe, bɔ̀ seé bɔ̀ mò sé naâ taáb lieé, te mè beè bɔ̀ Jûf yílá cú. Mè tueé wò: bèh Mgbè ceèr mò dé ká te wɔ́ŋe sam.» ");
INSERT INTO mcu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilátò ye bú a: «Á sâ, wò né mgbè mà?» Ye Pilátò a: «Wò tueé né tueè, mè né Mgbè. Mè lé ká te wɔ́ŋe ndeè naâ ceér gècên tueé ŋagá. Bɔ́ lé mè ŋaár naâ dé cî. Nuaá mé né nùà gècên dɔɔ́ŋ né gi dé seèn sòn mò ŋgweé.» ");
INSERT INTO mcu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilátò ye bú a: «Gècên sâ né kei wa?» Pilátò yeé bie gi aá bú mân, à yuo kela cuù ká cie, à nde ké yoòr bɔ̀ Jûf, ye bɔ́ a: «Njií mé béh nde né nùà hên teèn sie, mè dé mò ŋéné ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dé tòù biì, faá bèh jomò nɔ, mè nde né bele. Né yeé cu dɔɔ́ŋ, mɔ Páskà nde aá feí, mè né yeé bí nùà gwà cibì cén déì yi njií. Sâ bí gwàn ŋgwéh ye mè a, yì njí bí mgbè bɔ̀ Jûf hên wa?» ");
INSERT INTO mcu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bɔ́ ye bú a: «Hê ceè, té bú yì! Yì sér béh Barabâs!» Á sâ, Barabâs hèllè lé naá seêr nùà wúlá-feèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yeé baá môn, Pilátò ye bɔ́ wèh yùò mé Yeésò weèh, bɔ́ nde tegé bú núr. ");
INSERT INTO mcu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bɔ̀ sɔ́jì nde fɔɔ́n wellê bɔ̀ ŋùàgà, bɔ́ beéh faá tàm nɔ, bɔ́ sulí kwaá bú felè, bɔ́ ye né tàm mgbè ma. Bɔ́ weh su kwaá bú cɔ̀gɔ̀ bèlè jùm mân yoòr faá cɔ̀gɔ̀ mgbè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bɔ́ né ká yoòr seèn cɔɔ́ ndeê, bɔ́ né bú mbaàn gbêg haá, bɔ́ ye bú a: «Sìè ŋgób, Mgbè bɔ̀ Jûf!» Bɔ́ né bú teèn bɔlé yií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilátò yuo kela cuù déì, ye cìlì nùàr a: «Bí ŋgwé: mè nde cuù né bí nùà hên ká cie weh haá njiî, te bí ŋene kɔ teèn, ye mè dé mò kwɔ̀m mé béh nde né bú teèn sie ŋéné ŋgwéh gùm dɔɔ́ŋ ma.» ");
INSERT INTO mcu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeésò yuo kelà ndɔ; à né ka mé tàm ŋùŋùàgà doô felè ménâ den den, à né mé cɔ̀gɔ̀ bèlè jùm doô yoòr ndɔ. Pilátò ye bɔ́ a: «À baá hên!» ");
INSERT INTO mcu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ sɔ́jì bɔɔ̀n yeé nde ŋene njií bú mân, bɔ́ bɔm su lom mé sòn cên dɔɔ́ŋ, ye: «Fágá njí lòm bú te toû dé fagâ! Fágá wúlá lòm bú fagà!» Pilátò ye bɔ́ a: «Bí ndé wèh fágá ká bú mé feh biì; mè dé mò kwɔ̀m nùà hên sieè ŋéné ŋgwéh gùm dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bɔ̀ Jûf ye bú a: «Béh né mé sóú teèn; kɔ à kuú faá sóú beèh tueé nê nɔ: à lé tueé naâ dé keì ye nyí né Ŋunà Càŋ wa?» ");
INSERT INTO mcu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te Pilátò yeé nde ŋgweé cu dé sâ mân, veéh sie ŋeí cu bú dé sieè. ");
INSERT INTO mcu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","À yila nde cu ké lè bɔ̀gɔ̀, ye Yeésò a: «Wò yuoô he wa?» Mé njéh mene, Yeésò bú sòn kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","À den cuù, ye Yeésò a: «Wò mè sòn kòmò ŋgwéh wa? Wò kɔ́ ŋgwéh ye mè né mé terreb teèn wa? Mɔ mè ye yì njí wò, bɔ́ nde né wò yi; mɔ mè ye bɔ́ fágá wò fagà, bɔ́ nde né wò ter fagá njií ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeésò ye bú a: «Mɔ Càŋ sé wò terreb felè mò há ná ŋgwêh, wò sé mé ndɔ̀gɔ̀ terrèb déì felè mò teèn ná ŋgwêh ndɔ. Mɔ né mân, sâ nuaá mé sie haá njií naâ mè beè yeè, veên dé seèn maga kela né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yeé baá môn, Pilátò lege lom aá ye te nyí yi njií bú yiì. Njèh cén, bɔ̀ Jûf né lom ké ter tueé lɔgɔ́ njií, ye bú a: «Mɔ wò yi njií nùà hên, sâ wò mbeí mgbè *Sesâr sam. Ŋgweéh wò né kɔɔ́, nuaá mé tì felè seèn lobo né mé be seèn dɔɔ́ŋ, né yeé nùà bùnò Sesâr wa?» ");
INSERT INTO mcu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te Pilátò yeé nde ŋgweé njií aá dé sâ mân, à ye bɔ́ ndé sɔ̀m kéh njî Yeésò ká cie; à nde den nde bèh ju tenâ. Bèh sâ bɔ́ te kwaá né bɔ̀ taá mbembalê mân doó; bɔ́ yilá né bèh sâ: Gàbátà, te ju *hebreêh. ");
INSERT INTO mcu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lé naâ loù nàŋ Páskà; sâ lou dilí baá. Pilátò tueé njií baá-re mé bɔ̀ Jûf ndɔ, ye bɔ́ a: «Mgbè biì sâ!» ");
INSERT INTO mcu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bɔ́ yeé nde ŋene ménâ, bɔ́ tueé njií ké ter ye: «Wúwulà! Wúwulà! Fágá njí bú te toû!» Pilátò ye bɔ́ a: «Mè te toû fágá njí mgbè biì wa?» Bɔ̀ ŋgàŋ sèmè dé kokoô ye bú a: «Mgbè beèh gi lom né Sesâr.» ");
INSERT INTO mcu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yeé baá môn, Pilátò haá njií bɔ́ Yeésò, te bɔ́ nde bú fagá sâ. Bɔ́ cab sie bú ndɔ, bɔ́ yuo mé bú. ");
INSERT INTO mcu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yeésò jɔgɔ sie toú mé bɔ́ nde né bú teèn fagá ndɔ, bɔ́ bɔ́ nde mé njéh ké bèh mé bɔ́ yilá né: Geba feèh. Te ju *hebreêh né Gɔ́lgɔ́tà. ");
INSERT INTO mcu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wa ké teèn, bɔ̀ sɔ́jì faga njií Yeésò te toû ndɔ. Bɔ́ faga kwaá cu bɔ̀ nuaré déì kwarè seèn fà, dé kàn te toú seène, cén déì kèb déì, cén déì kèb déì ndɔ, Yeésò lètenè. ");
INSERT INTO mcu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilátò ye, bɔ́ nyàgà fágá kwá njeré déì teèn; bɔ́ nyagá kwaá baá-re teèn ye: «Yeésò nùà Najarêt, Mgbè bɔ̀ Jûf.» ");
INSERT INTO mcu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bɔ̀ Jûf kókoó mbaá jaŋé ŋene gi môn. Lòù sam, bèh mé bɔ́ lé fagà naâ Yeésò teèn sâ, lé naâ kwarè lɔɔ̂; bɔ́ lé nyagá naâ njií sâ mé ju hebreêh, ju latên, mé ju greêk. ");
INSERT INTO mcu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bɔ̀ *ŋgàŋ sèmè dé kokoô yeé ŋene aá ménâ, bɔ́ ye Pilátò a: «Té bú mgbè bɔ̀ Jûf nyàgà kwá; nyàgà sér ye: nùà hên ye nyí né mgbè bɔ̀ Jûf ma.» ");
INSERT INTO mcu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilátò ye bɔ́ a: njií mé nyí nyagá baá, nyagá gi aá kèn. ");
INSERT INTO mcu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bɔ̀ sɔ́jì yeé faga sɔm aá Yeésò, bɔ́ weh bɔ̀ cɔ̀gɔ̀ seèn, bɔ́ geé bèh nèà, sɔ́jì dé kàn weh cén. À lé naâ mé cɔ̀gɔ̀ suù déì teèn, bɔ́ bú lòù sá ŋgwéh, bɔ́ dé sâ colo né lòù. ");
INSERT INTO mcu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bɔ̀ sɔ́jì yila lètenè bɔɔ̀n tueé kuû ye: «Béh té bú lòù sìè ŋèrrè sɔ̀m, béh vú sér mé bèì, te nùà cén yieé weh lòù.» Sâ dɔɔ́ŋ bɔɔ́ gi né te yuo faá bɔ́ lé nyagá kwaá naâ te mvù Càŋe nɔ, ye: «Bɔ́ geé weh gi aá cɔ̀gɔ̀ mò lètenè bɔɔ̀n, bɔ́ vu yieé weh cu cɔ̀gɔ̀ mò déì mé bèì ndɔ.» Hên né njií mé bɔ̀ sɔ́jì lé bɔɔ́ naâ. ");
INSERT INTO mcu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Sâ meì Yeésò bɔ̂ bei mé Marî veèh Kelopâs, bɔ̂ Marî Magdalâ né ké kwarè toú fagâ doô njebá den. ");
INSERT INTO mcu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeésò ke njií meí ndɔ, à ŋene njií mbɔ̀ŋ dé mé temé seèn dɔɔ́ŋ né gi yoòr seèn doô yí kwarè meî, ye meí a: «Ma, ŋuna yeè baá sâ.» ");
INSERT INTO mcu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","À tueé njií mé mbɔ̀ŋ doô ndɔ, ye bú a: «Meí yeè sâ ndɔ.» Sâ baá bèh mé mbɔ̀ŋ doô weh kwaá njií baá bú yoòr teèn. ");
INSERT INTO mcu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kènê Yeésò yeé ke, njèh dɔɔ́ŋ mboón aá faá bèh ménâ, à tueé te yuo faá bɔ́ lé nyagá kwaá naâ te mvù Càŋe nɔ, ye: «Mè baá mé nyúá.» ");
INSERT INTO mcu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sâ sɔɔ̀ mbè tanê déì né kwarè sâ ndɔ. Bɔ̀ sɔ́jì déì yeé ŋene aá ménâ, bɔ́ weh fùlù, bɔ́ yií njií te mbè tanê doô, bɔ́ feéh kwaá te tapè, bɔ́ tiím cie njií bú ké sònò. ");
INSERT INTO mcu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","À yeé naga ke aá, ye: «Jegé baá!» À doóm njií feh doó, à kuú yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Loù sâ lé naâ nàŋ cieé sóù; sóú sâ lé naâ cieé koô dé gècên. Bɔ̀ *Jûf lé gwàn ná ŋgwêh mé bɔ́ né cieé koô yieé, bɔ̀ nùàr né ké te toû loù cieé koô sɔɔ́ den. Yeé baá ménâ, bɔ́ nde bie ye *Pilátò a: «Kwá bɔ́ nde kwalé sɔm bɔ̀ nùà ké te toú fagâ doô gule, te bɔ́ mvualé sɔm bɔ́ mvualè.» ");
INSERT INTO mcu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilátò yeé gwaán aá, bɔ̀ sɔ́jì nde ké teèn ndɔ. Bɔ́ jɔ̀gɔ̀ kwalé sɔm lɔgɔ̂ ŋgeéh nùà toò jɔ̀gɔ̀ mé bɔ́ faga kwaá naâ kwarè Yeésò doô, bɔ́ kwalé sɔm dé mbeî ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bɔ́ yeé nde aá dé Yeésò kwalé, bɔ́ ŋene à kuú aá, bɔ́ dé seèn kwálé cú. ");
INSERT INTO mcu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mé njéh mene, sɔ́jì cén déì lé naâ gwaga weh, à sie lɔgɔ́ bú kwar mé njéh. À yeé sie lɔgɔ́ aá, húɔ́m bɔ̂ nòmò kwaré yuo kelà teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hên tueé den né nuaá mé lé naá giì bɔ̀ njií sâ mé njolo ŋené, né ka nág faá bèh sâ nɔ. Nùà hên né kɔɔ́ ye nyí tueé lom né gècên; à tueé né bí ménâ te bí kwaá njií temé teèn, ye né lom môn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hên dɔɔ́ŋ bɔɔ́ gi né te yuo faá bɔ́ lé nyagá kwaá naâ te mvù Càŋe nɔ, ye: «Bɔ́ bú dé seèn kuú déì yoòr sìè kwá nyì ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Beré déì né cu te mvù Càŋe nyagá den ndɔ, ye: «Nuaá mé bɔ́ lé sie lɔgɔ́ naâ kwar doô, bɔ́ nde né bú bilí ke.» ");
INSERT INTO mcu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jomo sâ Josêf nùà Arimatê déì nde Pilátò komó Yeésò dua. Josêf sâ lé naâ mbɔ̀ŋ Yeésò cén déì ndɔ. Njèh cén, à lé leér gɔ beéh dé seèn lòù, à né bɔ̀ Jûf veéh. À yeé dua baá ménâ, Pilátò gwaán. Josêf nde jɔgɔ weh baá-re komó doô, à nde mé njéh. ");
INSERT INTO mcu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Níkòdêm, nuaá mé lé nab ndeè naâ ké yoòr Yeésò cíbíteèn doô, waà kwa Josêf ndɔ. À waà dé seèn mé bɔ̀ toú lèh beè ba deí, nde njèh kílò yulà tagár mân, bɔ́ bɔré hualé né bɔ̀ toú ŋgwɔ́bè mé bɔ̀ toú múmû déì. ");
INSERT INTO mcu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","À yeé waà baá, bɔ̂ Josêf bilí baá-re nùà fà, bɔ́ weh cɔ̀gɔ̀ wulésé mân, bɔ́ waga nyegé komó Yeésò mé njéh, bɔ́ né bɔ̀ lèh sâ teèn waá njií, faá bɔ̀ Jûf waá yeé nɔ. Mɔ bɔ́ nde aá nùàr furú, bɔ́ waá yeé ménâ. ");
INSERT INTO mcu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sâ ké bèh mé bɔ́ lé fagà naâ Yeésò teèn sâ, ŋueèh sɔgɔ̀ déì lé naâ teèn. Sà feésé mân lé naâ ké ŋueèh sâ ndɔ, bɔ́ lé née nuaré déì teèn fùrù lɔ́gɔ́ ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ŋueèh sâ né bèh dìdì mân. Bɔ́ yeé ke, cibí nde aá yilí, *Páskà bɔ̀ Jûf nde aá bɔ́ mé njéh beè kwa lɔɔ́, bɔ́ nde jɔgɔ furú njií Yeésò teèn. ");
INSERT INTO mcu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yeé baá mé sɔ́ndè toò cieê, Marî Magdalâ komo nde ké te sàa ndɔ. À wa, sâ taá mé bɔ́ lé colo kwaá naâ sònòbɔ̀ doô ŋgeré nde aá gè jomo. ");
INSERT INTO mcu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","À ŋar cu cuù ká jomo mé doò, à nde kwa Simɔ̂ŋ Piêr bɔ̂ mbɔ̀ŋ dé mé temé Yeésò né lom yeé yoòr seèn doô, ye bɔ́ a: «Bɔ́ mé komó Fehtoò beèh sɔm nde aá kèn, ké te sà sam cuú. Béh kɔ́ cú bèh mé bɔ́ kwaá né teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piêr bɔ̂ mbɔ̀ŋ doô nde ké te sà ndɔ; ");
INSERT INTO mcu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","bɔ́ dula nde den ka teter ménâ, te wa ké toò déì dula kela keéh ye mbeí; dé sâ wa lɔgɔ̂ ké te sà kɔɔ́ mé Piêr. ");
INSERT INTO mcu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","À wa ké teèn, à geér ke njií gè dòù, à ŋene njií bɔ̀ cɔ̀gɔ̀ wuwulê doô né doó gurú den, à gè teèn yílá ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔ̂ŋ Piêr dula waà jomo, à yila kela nde lom dé seèn gè dòù dé yilâ, à wa, à ke bɔ̀ cɔ̀gɔ̀ wuwulê doô baá gi doó den den, ");
INSERT INTO mcu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mé mbán cɔ̀gɔ̀ dé mé bɔ́ lé vuɔb kwaá naâ Yeésò sònò doô mene. Sâ dé sâ né dé seèn hiín keéh den. ");
INSERT INTO mcu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jomo sâ mbɔ̀ŋ dé mé la dula wa lɔgɔ́ naâ ké te sà kɔɔ́ doô, yila bele ye bú. À yeé ŋene aá ménâ, à kwaá njií ye temé teèn, ye Yeésò komo yuo aá kèn. ");
INSERT INTO mcu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sâ bɔ̀ mbɔ̀ŋ lé née bɔɔ̀n mvù Càŋ ŋgwé kòmò ŋgwéeh ndɔ, ye Yeésò nde cu né lè cio komo yuo. ");
INSERT INTO mcu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jomo sâ bɔ̀ mbɔ̀ŋ fà doô cu cu ké lɔ bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Marî né ka dé seèn ká cie sònò sà yueé den, à né yueé, á né gè dòù gimé ke njií. ");
INSERT INTO mcu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","À yeé ke, bɔ̀ cìlì Càŋ déì fà, mé cɔ̀gɔ̀ wuwulê mân yoòr, né gè dòù den den; déì ké felè, déì ké gulè bèh mé komó Yeésò la cer deén naâ teèn doô. ");
INSERT INTO mcu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bɔ̀ cìlì Càŋ doô bie njií ye bú a: «Dé vêh, wò yueé né kei wa?» Ye bɔ́ a: «Bɔ́ jɔgɔ weh aá Fehtoò mò, mè kɔ́ ŋgwéh bèh mé bɔ́ kwaá njií né bú teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","À yeé tueé sɔm aá mân, à bele seér, à ŋene njií Yeésò ndɔ, sâ Yeésò baá doó sâ njebá den; njèh cén, Marî ŋéné kɔ́ cú ye né bú. ");
INSERT INTO mcu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeésò bie njií cu ye bú a: «Dé vêh, wò yueé né kei wa? Wò fɔɔ́n yeé neì ndɔ wa?» Ma doô ye merré déì né nùà ŋueèh, à tueé njií mé bú ndɔ, ye bú a: «Dé koô, mɔ wò jɔgɔ sɔɔ́m naâ bú kɔɔ́, fèh mè bèh sâ teèn, te mè nde jɔgɔ weh bú.» ");
INSERT INTO mcu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeésò ye bú a: «Marî.» À bele seér, à ke njií bú ndɔ, ye bú a: «Rabúnì!» Mé ju *hebreêh sâ tueé né ye: Njí ndêb. ");
INSERT INTO mcu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeésò ye bú a: «Té mè sìè lɔ́; mè née ké yoòr Tele mò ŋá ŋgwéeh ye. Ndé júée bɔ̀ nùàr mò a: mè ŋaá nde aá ké yoòr Tele mò mé né Tele biì ndɔ ma, ké yoòr Càŋ mò mé né Càŋ biì ndɔ ma.» ");
INSERT INTO mcu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Marî Magdalâ nde lom baá-re bɔ̀ mbɔ̀ŋ ménâ tueé, ye bɔ́ a: «Mè ŋene aá Fehtoò beèh mé njolo!» Jomo sâ à tueé bele bɔ́ njií mé à tueé naâ bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Né cu ka loù sɔ́ndè cên sâ liyilì mân, sâ bɔ̀ mbɔ̀ŋ né te gwà déì bilí den, bɔ́ ferá né hin lòù, bɔ́ né bɔ̀ Jûf veéh. Bɔ́ yeé baá gwò den den, Yeésò ŋené yuo kelà lètenè bɔɔ̀n ndɔ, ye bɔ̀ a: «Dɔlê a, dèn mé bí!» ");
INSERT INTO mcu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","À yeé tueé sɔm aá dé sâ, à feh keéh bɔ́ be mé kwar seèn ndɔ. Bɔ̀ mbɔ̀ŋ yeé nde ŋene njií cu Fehtoò bɔɔ̀n mân, njií ye bɔ́ a, sàmè kú lòm mé vɔ́gɔ́-temé lòù. ");
INSERT INTO mcu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","À den cuù, ye bɔ́ a: «Dɔlê a, dèn mé bí! Mè tema né bí faá Tele mò lé temà naâ mè nɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","À yeé tueé gi aá ménâ, à fam njií bɔ́ cúcuí yoòr, ye bɔ́ a: «Bí wèh Cúcuí Ŋagâ. ");
INSERT INTO mcu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bɔ̀ɔ́ mé bí nde né veên bɔɔ̀n doó kulú njií, Càŋ nde né bɔ́ mé njéh kulú sɔm gií. Mɔ bí veên bɔɔ̀n doó kúlú njí ŋgwéh, Càŋ bɔ́ mé njéh kúlú sɔ̀m ndé ŋgwéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sâ cu mé Yeésò la waà naâ doô, cén déì lètenè bɔ̀ mbɔ̀ŋ la doó ná ŋgwêh. Naâ Tomâs mé bɔ́ yilá né Huaán feèh doô. ");
INSERT INTO mcu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bɔ̀ mbɔ̀ŋ déì yeé baá tueé ye bú a: béh la naâ Fehtoò beèh ŋené mân, à saán seér cu lòù, ye bɔ́ a: «Mɔ mè bú mé bàŋ kusà beè ŋéné ŋgwéh, mè mé be kèmà ŋéné ŋgwéh, mè bú kwar kèmà ŋéné ŋgwéh ndɔ, sâ mè temé teèn kwá njí ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sɔ́ndè cén yeé kela baá, bɔ̀ mbɔ̀ŋ seèn baá cu ké gwò bilí den. Mé loù sâ Tomâs baá teèn. Bɔ́ ferá cu né ka hin lòù ndɔ. Bɔ́ yeé ke, Yeésò ŋené yuo kela cuù aá lètenè bɔɔ̀n, ye bɔ́ a: «Dɔlê a, dèn mé bí!» ");
INSERT INTO mcu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","À tueé njií mé Tomâs ndɔ, ye bú a: «Kèmà njî nyɔ̀gɔ̀ beè yeè ká toò, kè be mò sâ hên; kèmà kè kwar mò sâ hên ndɔ. Kwá lɔ́ saân yeè doô ménâ, gwàn lòm dé gwaân!» ");
INSERT INTO mcu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomâs ye bú a: «Fehtoò mò, wò né Càŋ mò!» ");
INSERT INTO mcu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeésò ye bú a: «Ŋgweéh wò yeé ŋene aá mè, wò baá ye gwaán mà. Mè tueé wò, bɔ̀ɔ́ mé kwaá njií keéh né temé yoòr mò dé kwaâ, mé née mè ŋéné ŋgwéeh ye, bɔ̀ sâ bɔ̀ nde né samé.» ");
INSERT INTO mcu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sâ Yeésò lé naá cuù bɔ̀ fém déì toò bɔ̀ mbɔ̀ŋ seèn bɔɔ́ ndɔ; lé naá loôm ŋgún. Bɔ̀ sâ bɔ̀ te mvù hên nyàgà yùò kélá ŋgwêh lòù. ");
INSERT INTO mcu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Te mvù hên nyagá den lom né bɔ̀ hên bɔ̀, te bí kwaá njií temé teèn, ye *Nùà Cɔ̀ŋ né Yeésò, Ŋunà Càŋ né bú ndɔ; mɔ bí né temé ménâ kwaá njií, te bí kwa ye yɔ̀ŋ te yilí seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yeé cer weh aá, Yeésò nde ŋené yuo kela cuù toò bɔ̀ mbɔ̀ŋ seèn; lé naâ ké sòn tub Tiberiâde. ");
INSERT INTO mcu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sâ Simɔ̂ŋ Piêr bɔ̂ Tomâs mé bɔ́ yilá né Huaán feèh doô né kɔɔ́. Bɔ́ bɔ̀ Natanaêl nùà Kánà ké Galilê, mé bɔ̀ ŋunà Jebedê, bɔ́ bɔ̀ mbɔ̀ŋ Yeésò fà déì né kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔ̂ŋ Piêr ye bɔ́ a: nyí nde aá bèh ndoór vuû ma. Bɔ́ ye bú a: «Béh bí nde nde né kɔɔ́.» Bɔ́ yuo dɔɔ́ŋ, bɔ́ nde yila kɔm ndɔ. Njèh cén, bɔ́ nde koró ŋaga kuú mé ndoór dé lòù. ");
INSERT INTO mcu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cieé yeé baá kɔ ŋagá, Yeésò ŋené yuo kelà yí sòn nòmò; mé njéh mene bɔ̀ mbɔ̀ŋ ŋéné kɔ́ ŋgwéh ye né bú. ");
INSERT INTO mcu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","À tueé njií mé bɔ́ ndɔ, ye bɔ́ a: «Bí naâ ŋgò sie kwa wa, bɔ̀ ndà?» Bɔ́ ye bú a: «Béh njeré déì sìè kwà ŋgwéh gùm dɔɔ́ŋ.» ");
INSERT INTO mcu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ye bɔ́ a: «Bí vú njí sér ndoór sâ kwarè kɔɔ̀m, kèb be gaâ mân, te bí sie kwa bɔ́ teèn.» Bɔ́ vu njií môn ndɔ. Bɔ́ yeé tulu, dé tuluù sam cuú; sâ ŋgò yuú kela né lè lòù. ");
INSERT INTO mcu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mbɔ̀ŋ dé mé temé Yeésò né gi yeé yoòr seèn doô, ye Piêr a: «Né Fehtoò beèh.» Te Simɔ̂ŋ Piêr yeé nde ŋgweé njií, ye né Fehtoò bɔɔ̀n mân, à weh su njií lom cɔ̀gɔ̀ yoòr, à die lobo yila dùà. Sâ, à la naâ kèb déì luŋturu. ");
INSERT INTO mcu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bɔ̀ mbeí tulu nde mé ndoór ŋgò deí doô yí te kɔme ndɔ; sâ le aá njèh métà yuií, te wa yí sòn ŋgɔ̀m. ");
INSERT INTO mcu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bɔ́ wa yí teèn, bɔ́ suaga die doó, bɔ́ ŋene we né ŋgie den, ŋgò né tuar, mé breêd teèn. ");
INSERT INTO mcu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeésò ye bɔ́ a: «Bí wèh ndê mé ŋgò mé bí la sieé naâ sâ kèb déì teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔ̂ŋ Piêr ŋaá yila te kɔme, à tulu kwaá njií ndoór ŋgò deí doô ká cie ndɔ: ŋgò né lom bɔ̀ ŋgò kokoô, kokoô mân. Ŋgò sâ dɔɔ́ŋ lé naâ yuií mé yulà tîn cùɔ̀b tagár. Bɔ́ né mene kókoó, mé njéh mene, ndoór doô beré déì téné nyì ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeésò ye bɔ́ a: «Bí ndê yáb yíé.» Mbɔ̀ŋ dé mé nde cu né bieé nyi, ye bú a: né wò neì wa, lé teèn ná cû. Nùà kàn lé baá giì lè seèn kɔɔ́ ye né Nùà Dueè. ");
INSERT INTO mcu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeésò njebá nde yí teèn, weh breêd doô, haá njií bɔ́; à haá bɔ́ ŋgò doô ndɔ. ");
INSERT INTO mcu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hên baá dé mbei tagâr mé Yeésò yeé komo yuo aá te cio, à ŋené yuo kela cuù toò bɔ̀ mbɔ̀ŋ seèn teèn. ");
INSERT INTO mcu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bɔ́ yeé yieé gi aá, Yeésò ye Simɔ̂ŋ Piêr a: «Simɔ̂ŋ, ŋunà Jâŋ, wò gwaán kela né mè kɔɔ́ mé bɔ̀ hên bɔ̀ wa?» Simɔ̂ŋ ye bú a: «Né môn Fehtoò mò, wò né gi kɔɔ́, ye mè né nyí gwaán.» Yeésò ye bú a: «Kó nyégé bɔ̀ huaán mbieè mò bagasé» ");
INSERT INTO mcu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","À den cuù, ye bú a: «Simɔ̂ŋ, ŋunà Jâŋ, wò né mè gwaán wa?» Simɔ̂ŋ ye bú a: «Né môn Fehtoò mò, wò né gi kɔɔ́, ye mè né nyí gwaán.» Yeésò ye bú a: «Kè nyégé bɔ̀ mbieè mò bagasé.» ");
INSERT INTO mcu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","À den cuù dé mbei tagâr, ye bú a: «Simɔ̂ŋ, ŋunà Jâŋ, wò né mè gwaán wa?» Piêr gwaán mierré seér aá mé dé mbei tagâr hên lòù, ye bú a: «Fehtoò mò, hên njèh dɔɔ́ŋ seèn kɔ gi né wò, wò yeè kɔ gi né kpɔ̂g, ye mè né nyí gwaán!» Yeésò ye bú a: «Kó nyégé bɔ̀ mbieè mò bagasé.» ");
INSERT INTO mcu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jomo sâ, ye bú a: «Mè né tueé ye wò a, cu mé wò lé naâ ndà, wò lé tene cam beéh mé be yeè, wò né bèh mé wò né gwaán keéh ndeé ndɔ. Mɔ wò ndeè kulí baá kèn, wò sɔm njií nde aá mbagá ter lòù, nuaré déì cam kwaá wò beè; à derré njií wò bèh mé wò kɔɔ́ gwàn ndé ŋgwéh, wò nde seér teèn.» ");
INSERT INTO mcu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sâ Yeésò ménâ tueé kwaá né bú gèh cio mé à ndeè nde né kuú, te terreb Càŋ ŋené yuo kelà cie teèn. Jomo sâ à ye bú a: «Bèlè mè ndɔ!» ");
INSERT INTO mcu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piêr yeé ke njií njolo jomo bɔɔ̀n, à ŋene mbɔ̀ŋ dé mé temé Yeésò né gi yoòr seèn doô baá ndeê. Sâ né ka mbɔ̀ŋ dé mé lé geér ndeè naâ yoòr Yeésò, cu mé bɔ́ lé naâ yáb yieé doô; à lé bieè naâ Yeésò kɔɔ́, ye bú a: Fehtoò mò, neì sar nde né wò kɔɔ́? ");
INSERT INTO mcu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piêr yeé ŋene aá bú ménâ, à bie njií ndɔ, ye Yeésò a: «Á, dé mbɔ̀ŋ hên nɔ, Fehtoò mò, kei kwa nde né bú dé seèn kɔɔ́?» ");
INSERT INTO mcu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeésò ye bú a: «Mɔ mè gwaán mene ye bú a, dèn lè làŋ, kɔ mè ndeè cuù baá, dé sâ yulá né wò he wa? Bèlè lòm dé yeè mè!» ");
INSERT INTO mcu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Njàgà hèllè ŋgulí ka nde seér baá-re lètenè bɔ̀ mbeî hiín mbaá, ye: mbɔ̀ŋ dé sâ dé seèn kú ndé cú. Á sâ, Yeésò lé túé ná ŋgwêh ye Piêr a: mbɔ̀ŋ sâ dé seèn kú ndé cú. À lé tueé seér naâ ye bú a: mɔ nyí gwaán mene ye bú a, dèn lè làŋ, kɔ nyí ndeè cuù baá, dé sâ yulá né wò he wa? ");
INSERT INTO mcu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Né mbɔ̀ŋ bú sâ tueé né bɔ̀ njií mé lé kelà naâ sâ kɔɔ́, à nyagá kwaá gi aá bɔ́ ter ndɔ. Béh kɔ né ye, à tueé lom né njèh gècên. ");
INSERT INTO mcu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bɔ̀ njií mé Yeésò lé bɔɔ́ giì naâ née cu kókoó mbaá ye. Mɔ bɔ́ sé ye bɔ́ nyagá kwaá gi te mvù cécéné cécéné dɔɔ́ŋ, mè tueé bí, mvù sé naâ wɔ́ŋ dɔɔ́ŋ beè yuú berré sie.");
INSERT INTO mcu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tele mò Teofîl, lè mvù mò dé toò jɔ̀gɔ̀ mè lé naâ dɔ̀gɔ̀tì seé Yeésò, mé bɔ̀ njèh feèh seèn dɔɔ́ŋ teèn tueé, yuoô ké bèh duɔɔ̂m, ");
INSERT INTO mcu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","nde wa lè cieé mé à lé ŋaá cuù naâ ké te vulúu teèn. Cu mé à lé naâ ká lè wɔ́ŋe, à lé naâ kuú, à komo yuo cu. Jomo sâ à ŋené yuo kelà toò bɔ̀ mbɔ̀ŋ tebê mé à lé naâ balé kwaá. Te cieé yulà nèà à né toò bɔɔ̀n mé bèh hihiné ŋené yuo kelá bele, te bɔ́ kɔ nyegé bagasé ye nyí baá cu làŋ. À né bɔ́ ndéb mé terreb Cúcuí Ŋagâ leéb, à né bɔ́ felè *Lò Càŋ se. ");
INSERT INTO mcu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cieé déì bɔ́ bɔ́ yeé baá yáb yieé, à ye bɔ́ a: «Bí tée Jerusalem yùò ye. Bí kèlà dèn Cúcuí Ŋagâ mé Tele mò lé tueé kwaá naá bí sâ. Mè lé bí tueé den naâ cí ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bí kɔ́ɔ ye, Jâŋ lé bɔ̀ nùàr koú naâ mé nòmò. Cieé màgà ndé cú, mè kou seér nde né bí mé Cúcuí Ŋagâ.» ");
INSERT INTO mcu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bɔ́ bɔ́ yeé baá cu bècénè, bɔ́ ye bú a: «Fehtoò beèh, hên baá cieé mé wò bɔɔ́ nde né te béh bɔ̀ *Iserálà den cu mé feh beèh teèn wa?» ");
INSERT INTO mcu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeésò ye bɔ́ a: «Dé sâ ju biì sam, né ju Tele mò; né mene cieé, né mene cu, dɔɔ́ŋ né gi beè Tele mò. ");
INSERT INTO mcu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dé biì, Cúcuí Ŋagâ ndeè né ter suagâ, kema bí, te bí kwa ye terreb, bí nde tueé den sòn mò. Bí sòn mò tueé duɔɔ́m nde né ká Jerusalem, bí tueé nde mé njéh kukwarè te tàbè Judê dɔɔ́ŋ, bí né te tàbè *Samarî tueé, bí túé ndé mé njéh bèh mé tàbè bɔ̂ vulú né teèn kwaré dɔɔ́ŋ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","À yeé tueé gi aá, à yuo komo ŋaá ter ndɔ. Bɔ́ né bú ke, à né nyueé ndeé. Nde nde, bègè ka leér weh bú njolò bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bɔ́ né ké ter ke den. Bɔ̀ nuaré déì fà kar yuo kelà kwarè bɔɔ̀n mé cɔ̀gɔ̀ wuwulê yoòr, ");
INSERT INTO mcu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bɔ́ né sònò tueé ye: «Bí bɔ̀ Galilê bɔ̀, bí ké te vulúu njebá ke den né dé keì? Yeésò mé né ké te vulúu njolò biì komo ŋaá hên, suaga cuù nde né loù sâ, nág faá à la naâ njolò biì ŋaá nɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jomo sâ bɔ̀ mbɔ̀ŋ tebê suaga yila cu ké Jerusalem ndɔ. Yuoô ké te tòr mé bɔ́ yilá né tòr Oliviê sâ nde ké lɔ, bɔɔ́ né njèh kílòmétà cén. ");
INSERT INTO mcu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bɔ́ wa ké lɔ, bɔ́ ŋaá kela nde ké gwò te jèh gwà dé ké teèr, bɔ́ yila nde cu ké mí bèh dene bɔɔ̀n. Lé naâ bɔ̀ Piêr mé Jâŋ mé Jâk bɔ̂ Andrê; Filîp bɔ̂ Tomâs; Bartelemî bɔ̂ Matíô; Jâk ŋunà Alfê mé Simɔ̂ŋ nuaá mé gwàn bèh dé nùà kìn ŋaá bɔ́, mé Júdàs ŋunà Jâk. ");
INSERT INTO mcu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɔ́ bɔ̀ véh déì, mé Marî meì Yeésò mé bɔ̀ dìm Yeésò lé naâ kɔɔ́, bɔ́ né Càŋ cu dɔɔ́ŋ dua, bɔ́ bú dua lom mé sòn cên dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mé cieé déì lè gwèn sâ, Piêr komo wuo ter lètenè bɔ̀ Yeésò bɔ̀. Bɔ́ bɔɔ́ né njèh nùàr yuií mé ndètoón. Ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Bí ŋgwé bɔ̀ nùàr mò! Kɔ njií mé né te mvù Càŋe felè Júdàs nyagá den dɔɔ́ŋ sé naá kaà mân mboón, te yuo faá Cúcuí Ŋagâ lé naâ sònò *Davîd tueé kwaá nɔ. À lé Yeésò cie jɔgɔ kwaá naâ kɔɔ́, te bɔ́ nde ye bú mân sie. ");
INSERT INTO mcu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Á sâ, Júdàs lé naâ te bɔ̀ŋ beèh ndɔ, à lé naá giì mé seé seèn teèn. ");
INSERT INTO mcu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mé njéh mene, à lé Yeésò go sɔɔ́m naâ kɔɔ́, à nde ŋueèh mé kàgàlɔ̀ŋ hèllè ŋge. Yeé baá ménâ, à die doóm seér ké teèn ndɔ, komó seèn velé, lèì ŋellé sue cie. ");
INSERT INTO mcu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bɔ̀ Jerusalem bɔ̀ ŋgweé laré ménâ bèh dɔɔ́ŋ, bɔ́ yilá kwaá baá-re ŋueèh hèllè: Hakeldamà. Mé ju bɔɔ̀n sâ tueé né ye: né ŋueèh húɔ̂m.) ");
INSERT INTO mcu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sâ né gi lè mvù bené *Davîd nyagá den ye: Gwà seèn a, lè lòù; Nuaré déì a, té ké teèn cèr. Déì né cu nyagá den ndɔ ye: Nuaré déì a, dèn sér cú lè sòn dene seèn kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Piêr den cuù ye bɔ́ a: «Sâ kɔ nuaré déì ndeè, à yila kwa béh, te à den sòn Júdàs, à né bɔ̀ nùàr sòn Fehtoò beèh tueé nyegé ye bɔ́ a, Fehtoò beèh baá cu mé njolo ma. Kɔ né nuaá mé béh bɔ́ yɔŋ yeé jomo Yeésò Fehtoò beèh kɔɔ́ ndɔ, yuoô bèh mé Jâŋ lé koú naâ bú nòmò, nde wa loù mé à lé komo ŋaá naâ ké ter teèn. Kɔ nùà sâ né gi dɔɔ́ŋ kɔɔ́ gií, sâ ye.» ");
INSERT INTO mcu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Piêr yeé tueé gi aá, bɔ́ sie kwaá baá-re nùàr fà. Déì lé naâ Josêf; bɔ́ bú yilá cu né Barsabâs; yilí seèn déì né cu Jústùs. Bɔ́ sie kwaá cu Matiâs ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jomo sâ bɔ́ dua Càŋ teèn, ye bú a: «Fehtoò beèh, wò ŋene kɔ né temé bɔ̀ nùàr dɔɔ́ŋ kɔɔ́; lètenè bɔ̀ fà bɔ̀ hên, fèh sɔ̀m béh nuaá mé wò balé kwaá naâ mé be yeè, ");
INSERT INTO mcu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te nùà sâ ŋa cu nùà tebê yeè, à weh seér cu seé Júdàs kɔɔ́. Lòù sam, Júdàs bèh séná seèn nde aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bɔ́ yeé dua sɔm aá Càŋ, bɔ́ vu bèì felè bɔ̀ fà bɔ̀ sâ; bèì sie Matiâs, bɔ́ weh sagá yií bú felè bɔ̀ mbɔ̀ŋ tebê dé yulà cùɔ̀b cén doô. ");
INSERT INTO mcu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cieé Pàntèkɔ̂t waà, sâ bɔ̀ Yeésò bɔ̀ né gi bècénè ménâ bilí den. ");
INSERT INTO mcu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bɔ́ yeé ŋgweé, bèmè baá ké ter te vulúu faá fu tarê nɔ ŋgulí; waà, gwaán tulu yila kweh gwò yoòr bɔɔ̀n, yuú gwà deí. ");
INSERT INTO mcu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bɔ́ ŋene leba né teèn faá leba weè nɔ tená yuo bele, né bɔ́ yoòr cécéné cécéné labé ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Cúcuí Ŋagâ samé yila bɔ́ lè ndɔ, bɔ́ yila leba juù hihiné tueê faá Cúcuí Ŋagâ ye bɔ́ a, tútueè nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sâ bɔ̀ *Jûf mé né Càŋ dula yuoó baá lò nùàr wɔ́ŋ dɔɔ́ŋ, bɔ́ baá gi loù sâ ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bèmè yeé baá ŋgulí, bɔ̀ nùàr kem bilí ndɔ. Lò dé kàn mé dé kân yeé ŋgweé, bɔ̀ Yeésò bɔ̀ baá mé ju bɔɔ̀n tueé, hiím yɔgɔ́ bɔ́, ");
INSERT INTO mcu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","feh ŋellé gi bɔ́ ter. Bɔ́ deên ndɔ ye: «Ŋgweéh bɔ̀ɔ́ mé né ju beèh tueé hên né gi bɔ̀ Galilê bɔ̀ wa? ");
INSERT INTO mcu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kèkènè! Bɔɔ́ né naàn mé bɔ́ né ju beèh mé lò hihiné tueé, lò dé kàn mé dé kân né ŋgweé wa? ");
INSERT INTO mcu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Lò Pártà, lò Mèdíà, mé Elám, lò Mèsòpòtamî, lò Judê mé lò Kapadɔ̂s, lò Pɔ̂ŋ mé tàbè Asíà, ");
INSERT INTO mcu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","lò Frijî mé Pamfilî, tàbè Ejíptò mé kɔ̀b tàbè Libî dé ké kwarè Sirên; bɔ̀ɔ́ mé yuoô Rɔ̂m, ");
INSERT INTO mcu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","bɔ̀ déì né bɔ̀ huaán Jûf, bɔ̀ déì ŋa né bɔ̀ Jûf lòù; bɔ̀ Kreétà bɔ̀ mé bɔ̀ Arâb mene; dɔɔ́ŋ nùà kàn né bɔ́ mé ju seèn sònò ŋgweé, bɔ́ tueé den né be seê Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yeé baá ménâ, hiím yɔgɔ́ bɔ́, feh ŋellé gi bɔ́ ter, bɔ́ den cuù lètenè bɔɔ̀n ye: «Kèkènè dé sâ ye naàn?» ");
INSERT INTO mcu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bɔ̀ nuaré déì haá seér cu bɔ̀ mbɔ̀ŋ tebê gbêg ye, ŋgweéh bɔ́ sela tugó den né mbè mà. ");
INSERT INTO mcu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piêr yeé ŋgweé aá ménâ, à komo wuo ter mé bɔ̀ mbɔ̀ŋ tebê yulà cùɔ̀b cén mene, à lɔgɔ́ njií ké ter, ye bɔ̀ nùàr a: «Bí bɔ̀ huaán *Jûf, mé bɔ̀ kìn ká Jerusalem dɔɔ́ŋ, bí félá nyégé bagasé, bí kɔ́ɔ ye, ");
INSERT INTO mcu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","bɔ̀ nùà hên mbè faá bí tueé nê nɔ sèlà ŋgwéh. Bí ŋéné ŋgwéh ye née maánjɔ̀gɔ̀ ye wa? ");
INSERT INTO mcu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mboón seér né njií mé Joël *sòn-Càŋ lé naâ tueé kwaá ye: ");
INSERT INTO mcu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Càŋ ye: lè cieé cèrè-jomò nyí ndeè né Cúcuí nyî yoòr bɔ̀ nùàr dɔɔ̂ŋ faám njií. Bɔ̀ huaán biì dé siîb mé bɔ̀ dé vêh nde né bɔ̀ sòn-Càŋ bɔ̀ ŋaá gií; bɔ̀ mbò biì nde né njèh lè vuû mé njolo lòù ŋené; vuú nde né bɔ̀ kuúm kulu ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jue nyí Càŋ, loù sâ nyí nde né Cúcuí nyî yoòr bɔ̀ seê bɔ̀ nyî faám njií bele, te bɔ̀ dé siîb, mé bɔ̀ dé vêh mene ŋa gi bɔ̀ sòn-Càŋ bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Loù sâ nyí nde né bɔ̀ fém ké te vulúu mé ká doó mene bɔɔ́; húɔ́m nde né kwaár, we nde né bɔgɔ́, ju nde né jeré; ");
INSERT INTO mcu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","lou nde né cibí ŋaá seér, weéh bɔ faá húɔ́m nɔ, te cieé dé Fehtoò biì ndeè wa nyegé ye. Loù sâ né cieé *sùsùm. ");
INSERT INTO mcu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nyí tueé bí, nuaá mé né Nùà Dueè dua dɔɔ́ŋ nde né yili yuo.» ");
INSERT INTO mcu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piêr den cuù ye bɔ́ a: «Bí bɔ̀ *Iserálà bɔ̀, bí félá nyégé bagasé! Càŋ lé naâ terreb Yeésò nùà Najarêt lètenè biì feh keéh, à né bú fém hihiné beè haá kwaá, à né cìè hihiné mé bú bɔɔ́. Né ka faá bí né gi kɔɔ́ nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mé njéh mene, bí nde kela nùà hèllè beè bɔ̀ nùàr mbaá, bí jɔgɔ yií. Sâ Càŋ lé naá giì mé kàgà-ndòn seèn nyegé kwaá ndɔ, ye te yuo ménâ. Yeé baá ménâ, bí ye bɔ̀ vevenê bɔ̀ a, wúlá bú wulà, bɔ́ fagá njií bú ter ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Càŋ mé ŋgeér sam. À yeé kuú aá, Càŋ komo sɔm cu bú lè núr cioò. Lòù sam, cio sé bú sìè kòmò ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Né ka nág faá *Davîd lé naá giì felè seèn tueé nɔ, ye: Cu dɔɔ́ŋ nyí né Fehtoò nyî toò nyî ŋené den, à né te be gaâ nyî te nyí ndèrrè cú. ");
INSERT INTO mcu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Temé nyí lè sagár né dé cî; nyí ŋgòr tueé samé né dé cî ndɔ. Nyí né mene yuaásé, nyí kuú nde né mé ndèm beè. ");
INSERT INTO mcu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nyí kɔ né ye wò sé yeè càŋ nyî te ndugo bɔ̀ càŋ sì lɔ́ ndé ŋgwéh; wò sé yeè gwàn ndé ŋgwéh ye nùàr nyî a, fɔ̀ lè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wò lé naá giì nyí ceér yɔ̀ŋ njolò feh kwaá. Ké kwarè yeè nyí nde né mé vɔ́gɔ́-temé mene samé kuú.» ");
INSERT INTO mcu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piêr den cuù ye bɔ́ a: «Bɔ̀ nùàr mò, kènê mè kwa baá terreb, mè nde né bí njèh felè tele beèh Davîd tueé ŋagá: à lɔ naâ kuú, bɔ́ furú bú, sà seèn née ká lètenè beèh ye. ");
INSERT INTO mcu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","À lé naâ *sòn-Càŋ, à lé naá giì kɔɔ́ ye Càŋ lé naâ jege ye nyí a: lètenè bɔ̀ ndùté ndùtù nyî dɔɔ́ŋ, huaán déì ndeè nde né teèn yuo, à den te kɔgɔ nyî ma. ");
INSERT INTO mcu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sâ tueé né ye Davîd lɔ naá giì kɔɔ́, te ndeè ye ká jomo bɔɔ́ den. À lé môn tueé kuú naâ ye *Nùà Cɔ̀ŋ nde né lè cio komo yuo, wa Càŋ ndeè bú lètenè bɔ̀ komô sì lɔ́ ndé ŋgwéh, komó seèn ndeè lòù fɔ̀ ndé ŋgwéh ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Mè tueé bí: Yeésò mé bí lé naâ te toû fagá njií doô, Càŋ lè cio hên komo sɔm né bú. À baá cu làŋ, béh bɔ̀ nùàr seèn dɔɔ́ŋ, béh lé naá giì bú mé njolo ŋené, béh né sòn seèn. ");
INSERT INTO mcu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","À ŋaá nde aá ké te be gaâ Càŋe, à kwa baá Cúcuí Ŋagâ beè Tele seèn faá Tele seèn lé naâ tueé kwaá nɔ. À ká yoòr beèh hên fam njií den né Cúcuí Ŋagâ sâ. Bí ká yoòr beèh ŋene né cí, bí sònò beèh ŋgweé né cí ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","«Dé *Davîd, à lé ké te vulúu ŋá ná ŋgwêh, à lé tueé naâ lòù ye: Nùà Dueè ye Nùà Koô nyî a: Dèn ndê ká te be gaâ nyî; ");
INSERT INTO mcu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kɔ nyí komó silí njií gi aá bɔ̀ bùnò bɔ̀ yeè doó, wò dobo keéh bɔ́ gulè.» ");
INSERT INTO mcu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Piêr den cuù ye bɔ́ a: «Bí bɔ̀ huaán *Iserálà bɔ̀ lé Yeésò faga wulà naâ kɔɔ́. Mè né tueé ye bí a ndɔ ye, kènê Càŋ bú felè njèh dɔɔ̂ŋ sie kwaá né Nùà dueè; *Nùà Cɔ̀ŋ né bú.» ");
INSERT INTO mcu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bɔ̀ nùàr yeé nde ŋgweé njií mân, càŋ tené bɔ́ lè. Bɔ́ ye bɔ̀ Piêr a: «Á hên, béh kènê bɔɔ́ nde aá naàn, bɔ̀ nùàr beèh?» ");
INSERT INTO mcu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piêr ye bɔ́ a: «Bí kwéh sér temé biì. Nùà kàn a, ndê, bɔ́ kou bú mé yilí Yeésò *Kristò, te Càŋ kulu sɔm bú veên yoòr. Bí nde né Cúcuí Ŋagâ beè seèn kwa. ");
INSERT INTO mcu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lòù sam, à lé naá giì tueé kwaá, ye né dé biì, dé bɔ̀ ŋuna biì, mé bɔ̀ jomo bɔ̀ mene. Nuaá mé Tele beèh Càŋ Dueè né bú yoòr seèn yilá njií dɔɔ́ŋ, né dé seèn.» ");
INSERT INTO mcu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piêr tueé sagá cu baá-re bɔ́ ŋgòr mé nde né bɔ́ beè sie teèn ŋgún, à né bɔ́ teèn sɔgɔ́ yií, ye bɔ́ a: «Bí gè mé ceér bɔ̀ dúágá-tie bɔ̀ nɔɔ́ŋ, te bí yili yuo.» ");
INSERT INTO mcu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bɔ̀ nùàr kókoó mbaá gwaán gi ŋgòr Piêr, bɔ́ kou bɔ́. Loù sâ, bɔ̀ nùàr sagá yila cu felè bɔ̀ Yeésò bɔ̀ nde njèh kám tagár. ");
INSERT INTO mcu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bɔ̀ mbɔ̀ŋ tebê né bɔ́ ŋgòr Càŋ feh, bɔ́ né temé teèn kwaá njií, bɔ́ bɔ̀ mbeí né meh, bɔ́ né yáb bècénè yieé bilí, bɔ́ né Càŋ bècénè dua bilí ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Veéh waà bɔ̀ nùàr yoòr. Bɔ́ ŋene bɔ̀ mbɔ̀ŋ tebê né bɔ̀ fém hihiné bɔɔ́ bele. Bɔ́ né bɔ̀ cìè kókoó mbaá ŋené ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bɔ̀ Yeésò bɔ̀ dɔɔ́ŋ lé naá loôm mé sòn cên, njèh bɔɔ̀n dɔɔ́ŋ lé bilí den beéh ndàságá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bɔ́ né bɔ̀ ŋueèh mé bɔ̀ njèh feh hihiné go bele, bɔ́ né bècénè kwaá bilí, bɔ́ geé haá bɔ̀ɔ́ mé njèh beè sam teèn. ");
INSERT INTO mcu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cieé dɔɔ́ŋ, bɔ́ né lè *gwà Càŋ koô bilí ndeé, bɔ́ né yáb bècénè ké gwò bɔɔ̀n yieé bilí ndɔ, bɔ́ né teèn mé temé cén samé, ");
INSERT INTO mcu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bɔ́ né Càŋ teèn seén, bɔ́ né nùàr dɔɔ́ŋ yoòr yilá gií ndɔ. Fehtoò beèh né be teèn kwaá; bɔ̀ɔ́ mé baá yili yuo, cieé dɔɔ́ŋ à né bɔ́ lè mɔ̀gɔ̀ bɔ̀ nùàr seèn sagá yií. ");
INSERT INTO mcu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cieé déì, cu Càŋ duaà, mé lou lɔ̀ŋ tagár yeé waà baá, Piêr bɔ̂ Jâŋ nde ké *gwà Càŋ koô. ");
INSERT INTO mcu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bɔ́ yeé nde aá gwò yilá, bɔ́ ŋene nùà gule kuû déì né tùtúlù den den, à né kwarè hin cén déì, bɔ́ hin sâ yilá né: Hin nyàgàm. Nùà beên hèllè lé mé njéh yuoó naâ lè. Cieé dɔɔ́ŋ bɔ́ né yeé bú ké tùtúlù gwà Càŋ jɔgɔ́ kwaá njií, te à dua beh kàgàlɔ̀ŋ beè bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","À yeé ŋene Piêr bɔ̂ Jâŋ nde aá gwò yilá, à dua bɔ́ njèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piêr bɔ̂ Jâŋ ke njií bú, bɔ́ né bú ke njege, Piêr ye bú a: «Kè njî béh.» ");
INSERT INTO mcu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nùà hèllè ke njií bɔ́ ndɔ, ye te nyí kwa ke njeré déì beè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piêr ye bú a: «Mè mé kàgàlɔ̀ŋ beè sam. Njií mé né beè mò, mè haá seér nde né wò cí. Mé yilí Yeésò *Kristò Nùà Najarêt wùò ter, gègɔɔ̀.» ");
INSERT INTO mcu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","À yeé tueé gi aá mân, à sie sɔm bú ter mé be gaâ ndɔ. Doó sâ, bɔ̀ gule mé bɔ̀ kɔgɔ́ gulè seèn yila gi cu. ");
INSERT INTO mcu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","À lɔ wuo ter kpar, à njebá mé be seèn, à gɔ mé be seèn ndɔ. Bɔ́ bɔ̀ mbɔ̀ŋ tebê bilí yila nde gwà Càŋe mé gule cên, à né gɔ, à né ter lɔɔ́ ŋaá, à né Càŋ seén. ");
INSERT INTO mcu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bɔ̀ nùàr gwà dɔɔ́ŋ yeé ke, à baá seér ter mé be seèn gɔ, à né Càŋ seén den, ");
INSERT INTO mcu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bɔ́ ŋene kɔ gi ye né bú ndɔ, à njèh tùtúlù gwà kwarè hin nyàgàm dua den yeé kɔɔ́. Veéh yila bɔ́ lè, njií mé naâ nùà beên hèllè bɔɔ́, geí lɔ bɔ́ mbaá. ");
INSERT INTO mcu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nùà hèllè Piêr bɔ̂ Jâŋ kwá lɔ́ cú ndɔ. Bɔ́ bɔ́ nde lè kɔ̀ŋ Salomɔ̂ŋ; bɔ́ kɔ̀ŋ sâ yilá né ménâ. Bɔ̀ nùàr kem nde gi ké teèn ndɔ. Feh né bɔ́ ter ŋellé. ");
INSERT INTO mcu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piêr yeé ŋene aá ménâ, à ye bɔ́ a: «Bí bɔ̀ *Iserálà bɔ̀, njií hên bí ménâ geí né dé keì wa? Bɔɔ́ né naàn mé bí béh ke njií né faá béh nùà hên bɔɔ́ gɔɔ́ naâ mé terreb dé beèh wa? Bí ye béh bú taré sɔɔ́m naâ mé ŋágá-temé beèh nùà njèh wa? ");
INSERT INTO mcu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mè tueé bí, né Càŋ nùà njèh. Abrahâm lé naâ bú dua. Isâk bɔ̂ Jakɔ̂b mé bɔ̀ tele beèh dɔɔ́ŋ lé naá giì bú dua. À be terreb seèn ter sɔm njií né kɔɔ́, te terreb Nùà seê seèn Yeésò ŋené mé njéh. Ŋgweéh bí lé Yeésò beè bɔ̀ kokoô bɔ̀ jɔgɔ yií naâ kɔɔ́ wa? *Pilátò né mene tueé ye, nyí nde né bú yi njií, bí lé naâ berɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bí lé ŋgɔɔ̀n naâ Nùà gècên mé né ŋagásé, bí ye Pilátò a: sìè sér bú, à yi njií bí nuaá mé wula yeé feh ma. ");
INSERT INTO mcu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bí lé bɔɔ́ naâ mân, bí wula sɔm Nuaá mé yɔ̀ŋ dɔɔ́ŋ né gi beè seèn. Mè tueé bí, Càŋ mé ŋgeér sam. À yeé kuú baá, Càŋ komo sɔm cu bú teèn, à baá cu làŋ, béh lé naâ bú mé njolo ŋené, béh né sòn seèn. ");
INSERT INTO mcu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nùà beên hên, bí né bú ŋené, bí né gi bú kɔɔ́ ndɔ. Bí kékɔɔ̀ ye, à taré yuo né mé yilí Yeésò. Né temé yoòr Yeésò kwaá njiî taré sɔm né bú kɔɔ́. Né njolò biì ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Bɔ̀ nùàr mò, mè né kɔɔ́ ye, njií mé bí bɔ̀ mgbè biì lé bɔɔ́ giì naâ Yeésò dɔɔ́ŋ, bí lé bɔɔ́ cugó naâ lòù. ");
INSERT INTO mcu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sâ beè Càŋ né seér njií mé à lé naá giì sònò bɔ̀ sòn-seèn bɔ̀ dɔɔ́ŋ tueé keéh ye: Huaán nyî *Nùà Cɔ̀ŋ nde né gèr ŋené. Mè tueé bí, hên mboón né cí. ");
INSERT INTO mcu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kènê, bí kwéh sér á temé, bí bele ceér Càŋ, te Càŋ kulu sɔm gi bí veên yoòr. ");
INSERT INTO mcu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mɔ bí bɔɔ́ né mân, bí nde né dù beè Nùà Dueè kwa, bí kwa cu Nùà Cɔ̀ŋ mé à lé naâ bí sɔm kwaá. Sâ jue né Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","À kènê né ké te vulúu ye. Kɔ ndeè baá loù mé njèh dɔɔ́ŋ baá cu dé feê ŋaá seér, sâ ye. Bɔɔ́ nde né faá Càŋ lɔ naá giì sònò bɔ̀ sòn-seèn bɔ̀ tueé kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Músì lé naá giì tueé ŋagá ye: Càŋ Dueè ndeè né bí sòn seèn déì faá nyí nɔ tema njiî; nde né nùàr biì déì ndɔ. Bí nde né sòn seèn dɔɔ́ŋ ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nuaá mé ŋgeén sòn seèn, bɔ́ nde né bú lè bɔ̀ŋ bɔ̀ nùàr Càŋe kwɔgɔ́ sɔm.» ");
INSERT INTO mcu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Piêr den cuù ye bɔ́ a: «Nàm mé béh né teèn hên, bɔ̀ *sòn-Càŋ bɔ̀ lé naá giì njèh teèn tueé, duɔɔ̂m mé Samuel nde wa mé bɔ̀ déì. ");
INSERT INTO mcu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ndéb mé Càŋ lé tueé lɔɔ̀ naâ sònò bɔ̀ sòn seèn bɔ̀ dɔɔ́ŋ, né gi dé biì. Bí né mé ŋgɔ̀ŋ yoòr, faá Càŋ lé naâ mé bɔ̀ tele biì kɔ nɔ. À lé ye Abrahâm a: nyí gèh nùàr *wɔ́ŋ dɔɔ́ŋ kulú keéh gi nde né mé ndùté ndùtù seèn ma. ");
INSERT INTO mcu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yeé baá ménâ, Càŋ tema njií Nùà seê seèn ndɔ, à bú tema njií lɔgɔ̂ mé bí, ye te nyí kulu bí, te nùà kàn kwɔbé leba seèn, à veên bɔ́ cú.» ");
INSERT INTO mcu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piêr bɔ̂ Jâŋ yeé baá bɔ̀ nùàr njèh ménâ tueé den, bɔ̀ *ŋgàŋ sèmè mé nùà koô felè bɔ̀ gó gwà Càŋ bɔ̀ mé bɔ̀ *Sadusiên ");
INSERT INTO mcu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","furú waà, ye Piêr bɔ̂ Jâŋ la tueê ŋgòr Càŋ fí. Sâ Piêr bɔ̂ Jâŋ la naâ bɔ̀ nùàr ŋgòr Càŋ feh den, ye bɔ́ a: Yeésò komo yuo aá lè cio kèn. Sâ tueé né ye, bɔ̀ komó nde gi né ménâ komo yuo ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bɔ́ yeé waà baá, bɔ́ sie yií Piêr bɔ̂ Jâŋ gwà cibì, bɔ́ cer ŋgɔgɔ̂ teèn. Sâ baá liyilì. ");
INSERT INTO mcu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mé njéh mene, bɔ̀ nùàr kókoó mbaá lé ŋgòr Càŋ ŋgweé nyegé gi aá kèn, bɔ́ gwaán gi aá ndɔ. Loù sâ bɔ̀ Yeésò bɔ̀ dɔɔ́ŋ wa njèh kám tîn. ");
INSERT INTO mcu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Cieé yeé ŋaga baá, bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ déì bɔ́ bɔ̀ *njí-sóù bilí gi ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","*Hánà ŋgàŋ sèmè dé koô lé naâ teèn; Kayîf bɔ̂ Jâŋ mé Alesándà, mé bɔ̀ nuaré déì lè mbàgà ŋgàŋ sèmè dé koô dɔɔ́ŋ lé naá giì teèn. ");
INSERT INTO mcu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bɔ́ yeé bilí gi aá ménâ, bɔ́ sɔm waà mé Piêr bɔ̂ Jâŋ ndɔ, bɔ́ dilí kwaá bɔ́ toò bɔɔ̀n, bɔ́ ye bɔ́ a: «Bí ménâ jég bɔɔ́ naâ mé gèh terreb dé heè wa? Neì bí terreb sâ haá naâ kɔɔ́ ndɔ wa?» ");
INSERT INTO mcu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Piêr samé wuo ter mé Cúcuí Ŋagâ yoòr, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Mɔ bí bɔ̀ kokoô bɔ̀ béh njèh bie né felè seé bagaà mé naâ nùàr beên hên yili sɔm, ");
INSERT INTO mcu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","sâ bí bɔ̀ɔ́ mé né doó dɔɔ́ŋ, bí ŋgwé. Huaán *Iserálà lò nùàr dɔɔ́ŋ a, kɔ́ɔ ye, nuaá mé né toò biì njebá den hên, né yilí Yeésò *Kristò nùà Najarêt taré sɔm né bú kɔɔ́. Bí lé naâ Yeésò fagá njií, à kuú. Càŋ bú te cio komo sɔm cu aá kèn. ");
INSERT INTO mcu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","À kènê né faá taá mé ŋgòr Càŋ né felè seèn tueé nɔ, ye: Né taá mé bí bɔ̀ mé-gwà bɔ̀ lé naâ ké jomo komo si njií, taá dàn ŋa seér cu né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Piêr den cuù, ye bɔ́ a: «Nùàr yili yuo lom nde né mé Yeésò. Ndɔ́g, nuaré déì ká te wɔ́ŋe teèn sam mé nde né nùàr yili sɔm. Gi cegé né bú.» ");
INSERT INTO mcu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Piêr yeé tueé gi aá ménâ, bɔ̀ kokoô bɔ̀ hèllè ŋene kɔ ye bɔ̀ Piêr né ŋgòr tueé ŋgulí, wanɔɔ́ŋ bɔ́ né bɔ̀ lòù bɔ̀ mé njèh due kɔ́ ŋgwéh, bɔ́ sé la vèh ná ŋgwêh wa? Yeé baá ménâ, geí lɔ bɔ́ ndɔ. Bɔ́ ŋene kɔ ye baá-re, ye né bɔ̀ mbɔ̀ŋ Yeésò ma. ");
INSERT INTO mcu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sâ nuaá mé lé taré yuoó naâ doô né doó sâ njebá den; bɔ́ dé sâ njèh tueê sònò kwà cú. ");
INSERT INTO mcu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bɔ́ ye, mɔ né mân, sâ bɔ́ sɔ̀m kéh ŋgɔ́gɔ̀ bɔ̀ Piêr cie, bɔ́ sɔm keéh bɔ́ lè gwà juù. Bɔ́ duɔɔ́m ká jomo lètenè bɔɔ̀n tueê ");
INSERT INTO mcu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ye: «Béh bɔɔ́ nde né bɔ̀ nùà hên naàn wa? Ŋgweéh bɔ̀ Jerusalem bɔ̀ dɔɔ́ŋ né gi kɔɔ́ ye, fém felè nùà hên bɔɔ́ naâ bɔ́ wa? Seèn naá giì bèsɔ́nè mbaá, bèh caàm sam cuú. ");
INSERT INTO mcu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Njèh cén, mɔ béh ye te ŋgòr hên toò ŋgúlí ndé cú, kɔ béh pamé yiín seér bɔ́ lòù, béh ye bɔ́ a: Càŋ a bɔ́ bí saán feh cu nuaré déì yilí Yeésò hèllè.» ");
INSERT INTO mcu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bɔ́ yeé tueé gi aá ménâ, bɔ́ yilá njií cuù bɔ́ ndɔ, bɔ́ ye bɔ́ a: «Bí máb mé yilí Yeésò! Càŋ a bɔ́ bí feh cu nuaré déì njèh mé yilí seèn sâ.» ");
INSERT INTO mcu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piêr bɔ̂ Jâŋ deên ye bɔ́ a: «Bí jɔ̀gɔ̀ téná ke ju hên mé be biì ye. Beè Càŋ dilí kela né dé heè? Béh dùlà bí wa, béh dula nde né Càŋ wa? ");
INSERT INTO mcu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dé beèh, njií mé béh lé naá giì ŋgweé, béh lé naá giì ŋené, béh vu lɔ nde né naàn wa? Ndɔ́g, bɔɔ́ mene naàn, béh tueé den nde né cí.» ");
INSERT INTO mcu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bɔ̀ kokoô bɔ̀ yeé ŋgweé aá ménâ, bɔ́ luɔm ferré cu bɔ̀ Piêr, te bɔ́ nde ye bɔ́ yi njií. Lòù sam, njií mé bɔ́ nde né bɔ́ gèr teèn feh keéh, bɔ́ lé kwà ná cû, bɔ̀ nùàr kɔ lom aá Càŋ felè nùà beên doô vra deèn. ");
INSERT INTO mcu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nuaá mé lé taré yuoó naâ mé fém hèllè lé naâ nyèmà yulà nèà yɔgɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Piêr bɔ̂ Jâŋ yeé yuo kelà baá, bɔ́ nde cu ké yoòr bɔ̀ mbeí bɔɔ̀n, bɔ́ se bɔ́ njií mé bɔ̀ *ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ déì naâ bɔ́ tueé gií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bɔ̀ mbeí yeé ŋgweé gi aá, bɔ́ bilí dua Càŋ, ye Càŋ a: «Nùà Dueè, wò lé vulú bɔ̂ tàbè mé nòmò dɔɔ́ŋ bɔɔ́ naâ kɔɔ́; bɔ̀ njèh teèn dɔɔ́ŋ lé si kwaá giì naâ wò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","*Davîd tele beèh dé koô lɔ naâ nùà seê yeè. Wò lɔ naâ sònò seèn tueé keéh, te à nde ye mé terreb Cúcuí Ŋagâ tueé ye: Lò nùàr dɔɔ́ŋ gàgà mé Càŋ môn saán njií né dé keì wa? Bɔ́ mbaá bɔɔ́ kuú né dé keì ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bɔ̀ mgbè dé kokoô njebá wɔŋ kwaá gi aá taáb kèn. Bɔ̀ mgbè dé tetɔɔ̂r bilí gi aá ndɔ. Bɔ́ dɔɔ́ŋ taáb njebá njií gi né mé Càŋ Dueè bɔ̂ Ŋuna seèn *Nùà Cɔ̀ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bɔɔ́ ka nág faá Davîd lé naâ tueé ndɔ. Sâ *Herôde mé Pɔ́nsè Pilátò bɔ́ bɔ̀ kìn mé bɔ̀ huaán *Iserálà bɔ̀ lé naâ lɔ hên bilí gií, bɔ́ né Yeésò Nùà Cɔ̀ŋ gɔŋ. À né mene Nùà seê yeè dé ŋagâ, bɔ́ né bú gɔŋ. ");
INSERT INTO mcu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dɔɔ́ŋ bɔɔ́ gi né te mboón faá wò lé naá giì ké bèh duɔɔ̂m nyegé kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","«Tele beèh, ŋgwé njií mé bɔ̀ kokoô bɔ̀ né béh luɔm kán, bɔ́ ye, béh máb lɔ́ ŋgòr yeè ménâ. Mɔ né mân, béh né wò dua, kè njî béh bɔ̀ seê bɔ̀ yeè njolo yoòr teèn, há béh terreb te béh tueé ŋgòr yeè, béh vèh cú. ");
INSERT INTO mcu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kwá be teèn, te bɔ̀ beén bɔ̀ taré yuo bele mé yilí Yeésò Nùà seê yeè dé ŋagâ, te bɔ̀ fém mé bɔ̀ cìè ŋené yuo kela giì bèsɔ́nè ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bɔ́ yeé dua sɔm aá, gwà jilí. Bɔ́ dɔɔ́ŋ, Cúcuí Ŋagâ samé yila gi bɔ́ yoòr, bɔ́ yila baá-re ŋgòr Càŋ mé terreb mene tueê, bɔ́ vèh cú. ");
INSERT INTO mcu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bɔ̀ Yeésò bɔ̀ lé naá loôm mé sòn cên, temé cên ndɔ. Nuaré déì lɔ njèh seèn hiín gè kwá bèh. Lètenè bɔɔ̀n njèh dɔɔ́ŋ lé naá giì ndàságá. ");
INSERT INTO mcu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bɔ̀ mbɔ̀ŋ tebê ŋgòr Càŋ njebá lom mé terreb, bɔ́ ye bɔ̀ nùàr a, mé gècên mene, Yeésò Fehtoò beèh lé naâ te cio komo yuo ma. Húɔ́m-temé Càŋ lé naá giì nùàr dɔɔ́ŋ beè yaám sie ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Njeré déì lé nuaré déì lètenè bɔɔ̀n sám ná ŋgwêh. Bɔ̀ déì lé beè naâ mé ŋueèh, bɔ̀ déì mé gwà, bɔ́ né go sɔm bele, bɔ́ weh kàgàlɔ̀ŋ sâ, ");
INSERT INTO mcu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bɔ́ né beè bɔ̀ mbɔ̀ŋ tebê haá njií, te bɔ́ geé haá bɔ̀ nùàr. Mɔ njeré déì né nùàr saám, bɔ́ haá bɔ́ teèn. ");
INSERT INTO mcu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nuaré déì lé naâ teèn, yilí seèn né Josêf. Bɔ̀ mbɔ̀ŋ tebê bú yilá sagá cu né Bàrnàbâs; sâ tueé né ye, né dɔ̀gɔ̀ nùàr. Né bɔ̀ huaán *Levî, à lé yuoó naâ ké Sîpre. ");
INSERT INTO mcu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","À né mé ŋueèh teèn, à go sɔm ŋueèh sâ ndɔ, à kàgàlɔ̀ŋ sâ haá njií beè bɔ̀ mbɔ̀ŋ tebê. ");
INSERT INTO mcu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sâ nuaré déì lé naâ teèn ndɔ, yilí seèn né Ananíà, dé veèh né Safírà. Bɔ̂ veèh yeé nyɔgɔ aá sòn, à go sɔm ŋueèh bɔɔ̀n, ");
INSERT INTO mcu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","à kɔb leér kàgàlɔ̀ŋ kèb déì, sâ veèh né kɔɔ́, à weh dé jomò, à haá njií beè bɔ̀ mbɔ̀ŋ tebê. ");
INSERT INTO mcu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piêr ye bú a: «Ananíà, bɔɔ́ né naàn mé *Sátàn né wò lè yilá, wò bele Cúcuí Ŋagâ wa? Mɔ sam, wò yeé go sɔm aá ŋueèh hèllè, wò kàgàlɔ̀ŋ kèb déì kɔb leér né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ŋgweéh ŋueèh hèllè lé jɔ̀gɔ̀ naâ dé yeè wa? Wò yeé go sɔm aá, ŋgweéh kàgàlɔ̀ŋ sé né dé yeè ndɔ wa? Wò sâ goló caá né kei wa? Wò bele né Càŋ, wò nùàr bèlè lòm ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Ananíà yeé ŋgweé aá ménâ, à komo die nde doó nɔɔ́ŋ, à kuú. Bɔ̀ mbò wuo ter, bɔ́ weh cɔ̀gɔ̀, bɔ́ vuɔb bú, bɔ́ nde bú furú sɔm. Nuaá mé lé ŋgweé naâ ŋgòr hên dɔɔ́ŋ, veéh bɔɔ́ bú njèh. ");
INSERT INTO mcu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bɔ́ bɔɔ́ teèn yɔ̀ŋ loù tagár, veèh seèn yila kweêh ndɔ, à kɔ́ ŋgwéh dé mé la naâ toò kelá. ");
INSERT INTO mcu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piêr ye bú a: «Túé mè mé gècên mene, ŋgweéh kàgàlɔ̀ŋ ŋueèh mé bí lé goó naâ doô, gi lom né hên wa?» Ye bú a: «Gi né ka sâ.» ");
INSERT INTO mcu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piêr ye bú a: «Bɔɔ́ né naàn mé bî si yeè naâ sòn nyɔgɔ́, bí fela Cúcuí Nùà Dueè sòn wa? Kè njí yí tùtúlù yíê, yila cuù né bɔ̀ɔ́ mé naâ si yeè furú weh, bɔ́ nde cu né wò furú.» ");
INSERT INTO mcu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tètèì sam à komo die nde doó toò Piêr, à kuú. Bɔ̀ mbò yila kweêh, sâ à baá komó. Bɔ́ jɔgɔ cu bú, bɔ́ nde ké kwarè siì furú njií. ");
INSERT INTO mcu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bɔ̀ nùàr te mbàgà Càŋe hemé laré dɔɔ́ŋ. Bèh mé bɔ̀ nùàr ŋgweé ŋgòr hên dɔɔ́ŋ, dùlù su bɔ́ yoòr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bɔ̀ mbɔ̀ŋ tebê lé naâ bɔ̀ fém mé cìè kókoó mbaá lètenè bɔ̀ nùàr bɔɔ́ bele. Bɔ̀ Yeésò bɔ̀ lé bilí den beéh lè kɔ̀ŋ Salomɔ̂ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuaá mé née temé mé Yeésò kwá njí ŋgwéeh ye, lé yoòr bɔɔ̀n mbembaá ndé wèh ná ŋgwêh, bɔ́ lé bɔ́ seén njií beéh lòù. ");
INSERT INTO mcu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Cìlì nùàr né lom temé kweéh seér, bɔ́ né te bɔ̀ŋ bɔ̀ Yeésò bɔ̀ yilá ndeé, véh mene, siíb mene, né lom faá cí yaám ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bɔ́ né mé bɔ̀ beén bɔ̀ ká cie jɔgɔ́ yuo kelâ, bɔ̀ déì te ndagáa, bɔ̀ déì te kèe, ye mɔ Piêr baá kelá, mɔ né mene cecemé seèn, te cor kema déì ma. ");
INSERT INTO mcu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bɔ̀ nùàr kókoó mbaá lè lɔɔ́ hihinê kwarè Jerusalem lé naâ mé bɔ̀ beén bɔ̀ jɔgɔ́ ndeê. Dɔɔ́ŋ bɔ́ lé naá giì taré yuo; bɔ̀ɔ́ mé né mé tándulu yoòr taré yuo gi ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","*Ŋgàŋ sèmè dé koô yeé ŋene aá ménâ, temé ŋaâ bú lè. Bɔ̀ɔ́ mé né jomo seèn dɔɔ́ŋ, furu gi bɔ́ ménâ ndɔ. Bɔ̀ sâ bɔ̀ lé naâ lètenè bɔ̀ *Sadusiên. Temé yeé baá bɔ́ lè furú, bɔ́ tema njií nùàr, ye bɔ́ ndé bɔ̀ mbɔ̀ŋ tebê sie. ");
INSERT INTO mcu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bɔ́ nde bɔ́ gwà cibì dé koô sie yií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yeé baá lètenè cibî, cìlì Càŋ déì waà gulu sɔm hin gwà cibì hèllè, sɔm keéh bɔ̀ mbɔ̀ŋ cie, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Bí ndé dèn ké *gwà Càŋ koô, bí tueé né bɔ̀ nùàr kùr yɔ̀ŋ feê.» ");
INSERT INTO mcu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bɔ̀ mbɔ̀ŋ ŋgweé sòn seèn: yeé baá maánjɔ̀gɔ̀ bɔ́ komo nde ké gwà Càŋ koô ndɔ, bɔ́ né njèh teèn feh den. Jomo sâ ŋgàŋ sèmè dé koô, mé bɔ̀ɔ́ mé né gi jomo seèn dɔɔ́ŋ, yilá bilí bɔ̀ kokoô bɔ̀ lètenè bɔ̀ *Jûf, te bɔ́ bilí *mbàgà juù. Bɔ́ yeé baá gi doó dɔɔ́ŋ, bɔ́ tema njií baá-re ké gwà cibì, ye bɔ́ sɔ̀m ndê mé bɔ̀ mbɔ̀ŋ tebê ma. ");
INSERT INTO mcu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bɔ̀ sɔ́jì yeé wa, gwà baá mvúâr, mbɔ̀ŋ déì teèn sam cuú. Bɔ́ cu cuù, bɔ́ tueé bɔ̀ kokoô bɔ̀ ménâ, ");
INSERT INTO mcu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","bɔ́ ye bɔ́ a: «Béh wa ké teèn, hin dɔɔ́ŋ né gi lílíér ménâ. Nùà seê dé kàn né tùtúlù ndɔ. Béh yeé gulu hin, nuaré déì teèn sam.» ");
INSERT INTO mcu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nùà koô felè bɔ̀ gó gwà Càŋ mé bɔ̀ ŋgàŋ sèmè dé kokoô yeé nde ŋgweé njií ménâ, feh ŋellé bɔ́ ter, bɔ́ né lètenè bɔɔ̀n bieé kuú, ye sâ naâ gèh dé heè wa? ");
INSERT INTO mcu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jomo sâ, nuaré déì kar waà ndɔ, ye bɔ́ a: «Mɔ bí jue né bɔ̀ nuaá mé bí lé sie yií naâ gwà cibì doô, bɔ́ né bɔ̀ nùàr njèh ké gwà Càŋ feh den.» ");
INSERT INTO mcu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bɔ́ yeé nde ŋgweé njií ménâ, nùà koô felè bɔ̀ gó gwà Càŋ doô wuo ter, à weh nde mé bɔ̀ nùàr seèn ké teèn, te bɔ́ bɔ́ weh cu cuù mé bɔ̀ mbɔ̀ŋ hèllè. Wa ké teèn, bɔ́ njèh lòù bɔ́ ŋáŋ cú ndɔ, bɔ́ veéh lom aá ye, bɔ̀ nùàr nde né bɔ́ mé taá tɔbé. ");
INSERT INTO mcu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bɔ́ weh bɔ́, bɔ́ bɔ́ cu cuù. Bɔ́ yeé baá ké te mbàgà juù, *ŋgàŋ sèmè dé koô bie njií ye bɔ̀ mbɔ̀ŋ a: ");
INSERT INTO mcu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Béh lé naá giì bí luɔm ye bí a: máb lɔ́ njèh mé yilí nùà hèllè feèh ménâ. Bí hên bɔɔ́ den cu né kei wa? Ŋgweéh ká Jerusalem lɔɔ́ dɔɔ́ŋ ka yɔŋ cu né njèh mé bí né feh sâ mà. Bí ye te bí luar kwa béh cio nùà hèllè yoòr wa?» ");
INSERT INTO mcu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bɔ̀ Piêr ye bú a: «Kɔ béh dula kela Càŋ mé bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mè tueé bí, ŋgweéh bí lé Yeésò faga wulà naâ kɔɔ́ wa? Càŋ mé lé naâ bɔ̀ tele beèh léí jɔ̀gɔ̀ gam, komo sɔm cu aá bú te cio, ");
INSERT INTO mcu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","à bú weh kwaá njií ké te be gaâ seèn; ké te kɔgɔ né bú, Yìlì nùàr né lom bú ndɔ, te haá bɔ̀ huaán *Iserálà bɔ̀ terreb temé kweéh seêr, te Càŋ kulu sɔm gi bɔ́ veên yoòr. ");
INSERT INTO mcu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bɔ̀ njií sâ dɔɔ́ŋ lé bɔɔ́ deén naâ njolò beèh, béh né bɔ̀ sòn seèn; Cúcuí Ŋagâ né sòn seèn ndɔ. Càŋ lé bú tema njií naâ yoòr bɔ̀ɔ́ mé né tie ŋgweê.» ");
INSERT INTO mcu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Te bɔ̀ kokoô bɔ̀ hèllè yeé nde ŋgweé cu mân, temé ŋaá cuù bɔ́ lè, bɔ́ gwaán lom aá bɔ̀ mbɔ̀ŋ tebê bɔɔ́ wulâ. ");
INSERT INTO mcu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Càŋ mé ŋgeér sam. Nùà *Farisiên déì naâ lètenè bɔ̀ kokoô bɔ̀ sâ teèn, yilí seèn né Gamaliêl, à né *njí-sóù, bɔ̀ nùàr dɔɔ́ŋ né gi bú veéh. Nùà sâ komo wuo ter, ye bɔ́ a: «Bí jɔ̀gɔ̀ sɔ̀m kéh née bɔ́ cie ye.» ");
INSERT INTO mcu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jomo sâ, à tueé njií mé mbàgà juù, ye bɔ́ a: «Bɔ̀ huaán *Iserálà, bí kè nyégé ká njií mé bí nde né mé bɔ̀ nùà hên bɔɔ́ bagasé, mè tueé bí. ");
INSERT INTO mcu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bí kwá seé bɔɔ̀n ndeè sɔm fù mé beè seèn faá seé Teudâs nɔ. Lòù sam, dàb née sam mé Teudâs lé naâ mé nùàr yuií nèà jomo kar waà, ye te nyí junó lɔɔ́, wa nyí né nùà dueè ma. Ŋgweéh bɔ́ lé naâ bú wula sɔm wa? À yeé kuú baá, ŋgweéh bɔ̀ nùàr seèn lé naâ mbaá ŋellé le gií wa? ");
INSERT INTO mcu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","«Júdàs nùà Galilê lé naá cuù ménâ ndɔ. À lé naâ te cu nyàgà nùàre kar waà, à né lom bɔ̀ nùàr kókoó mbaá soób, te bɔ́ ŋa gi bɔ̀ nùàr seèn. Ŋgwéeh bɔ́ lé naá cuù bú ménâ wulá sɔm, bɔ̀ nùàr seèn durá leér gi ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kènê, bí lɔ̀gɔ̀ sɔ̀m á be biì yoòr bɔ̀ nùàr hên nɔɔ́ŋ, bí yì njí bɔ́. Bí kɔ́ɔ ye, mɔ bɔ́ baŋ né seé dé ká lè *wɔ́ŋe, nde né mé be seèn laga le. ");
INSERT INTO mcu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mɔ né dé Càŋ, sâ bí bɔɔ́ kuú né mbaá, ndɔ́g ŋéllé kòmò ndé ŋgwéh. Sâ bí kè nyégé keè, mɔ sam bí bɔ̀ Càŋ nde né taáb lieé liím.» Mbàgà juù dɔɔ́ŋ gwaán gi ŋgòr Gamaliêl. ");
INSERT INTO mcu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bɔ́ yilá yií cuù bɔ̀ mbɔ̀ŋ tebê, bɔ́ ye, dún bɔ́ núr. Bɔ́ yeé duún aá bɔ́, bɔ́ luɔm ferré cu, ye bɔ́ a: «Càŋ a bɔ́ bí saán feh cu bɔ̀ nùàr yilí Yeésò hèllè.» Jomo sâ bɔ́ yi njií bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bɔ̀ mbɔ̀ŋ samé yuo seér te mbàgà juù mé vɔ́gɔ́-temé mene, ye: «Béh naâ nùàr njolò Càŋ wulú. Béh gèr felè Yeésò ŋene né dé cî mà.» ");
INSERT INTO mcu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Cieé dɔɔ́ŋ bɔ́ né njèh ké gwà Càŋ feh, bɔ́ né gùgwò feh bele ndɔ. Bɔ́ né bɔ̀ nùàr Njàgà Bagaà se, ye *Nùà Cɔ̀ŋ né Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Cu mé bɔ̀ mbɔ̀ŋ Yeésò yeé baá tetoò maga ndeé, bɔ̀ɔ́ mé né ju greêk tueé, si tɔgɔ ye bɔ̀ mbɔ̀ŋ mé né ju *hebreêh tueé né yeé yáb geé, bɔ́ né bɔ̀ ma kû bɔɔ̀n seb ma. ");
INSERT INTO mcu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yeé baá ménâ, bɔ̀ mbɔ̀ŋ tebê yulà cùɔ̀b fà doô yilá bilí bɔ̀ mbɔ̀ŋ dɔɔ́ŋ, bɔ́ ye bɔ́ a: «Hên, mɔ béh kwaá lɔ ŋgòr Càŋ, béh nde bèh yáb geê, né dilí wa? ");
INSERT INTO mcu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mɔ ye te huɔm, belà, bí bàlè sɔ̀m sér bɔ̀ gècên bɔ̀ lètenè biì, bɔ̀ loò bɔ̀ téhbeh mé Cúcuí Ŋagâ né yoòr bɔɔ̀n ŋgulí, te béh haá bɔ́ seé sâ. ");
INSERT INTO mcu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Béh kɔ lom dé beèh Càŋ duaà, mé ŋgòr Càŋ tueê.» ");
INSERT INTO mcu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bɔ̀ nùàr doó dɔɔ́ŋ gwaán laré ménâ ndɔ. Bɔ́ balé sɔm baá-re Etiên, nùà mé Cúcuí Ŋagâ né bú yoòr ŋgulí, mé temé cén kwaá njií lom né mé Yeésò; bɔ́ bɔ̀ Filîp mé Prokôr bɔ̂ Nikanôr mé Timɔ̂ŋ mé Parmenâ mé Nikolâ nùà Antiôs; dé seèn à lé ŋaà naâ *Jûf lòù. ");
INSERT INTO mcu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɔ́ yeé balé sɔm aá bɔ́, bɔ́ weh njií bɔ́ ké toò bɔ̀ mbɔ̀ŋ tebê. Bɔ̀ mbɔ̀ŋ tebê dua Càŋ felè bɔɔ̀n, bɔ́ ba bɔ́ be felè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ŋgòr Càŋ kɔ lom baá-re tetoò yaám ndeé deèn. Ké Jerusalem bɔ̀ mbɔ̀ŋ né tetoò maga ndeé. Bɔ̀ *ŋgàŋ sèmè ŋgún kwaá njií gi temé yoòr Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Càŋ kulu Etiên ndɔ, à haá bú terreb. Etiên yila cu bɔ̀ fém tetarê lètenè bɔ̀ nùàr bɔɔ́ beleè. ");
INSERT INTO mcu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bɔ̀ Jûf déì yeé ŋene aá ménâ, bɔ́ berɔ́ŋ. Bɔ́ né dé bɔɔ̀n lè *gwà sóù mé bɔ́ yilá yeé gwà bɔ̀ɔ́ mé lé naâ kwer, mé kènê baá mé feh bɔɔ̀n doô. Né bele bɔ̀ Jûf mé naâ lè tàbè Sirên bɔ̂ Alesandrî; bɔ̀ déì naâ lè tàbè Silisî mé tàbè Asíà mene. Bɔ́ dɔɔ́ŋ taré gi sòn toò Etiên. ");
INSERT INTO mcu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Cúcuí Ŋagâ mé lé naâ yoòr Etiên ŋgulí doô né bú kɔ́gɔ̀n haá. Yeé baá ménâ, bɔ́ sòn toò Etiên kwà cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bɔ́ yeé ŋene aá ménâ, bɔ́ nde gwɔm nab seér bɔ̀ kòb bɔ̀ déì kàgàlɔ̀ŋ, te bɔ́ nde bɔ̀ nùàr tueé, ye bɔ́ a: «Béh naâ mé tie beèh ŋgweé, à naâ Músì bɔ̂ Càŋ selé.» ");
INSERT INTO mcu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bɔ́ soób baá-re bɔ̀ nùàr, bɔ́ soób bɔ̀ kokoô bɔ̀ mé bɔ̀ *njí-sóù mene. Temé ŋaâ bɔ́ ndɔ, bɔ́ sie njií Etiên ké te *mbàgà juù, ");
INSERT INTO mcu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","bɔ́ weh sie cu bɔ̀ nyeên bɔ̀ beè, bɔ́ wa, bɔ́ ye bɔ̀ nùàr a: «Cu dɔɔ́ŋ nùà hên né yeé njií felè gwà Càŋ beèh tueé beéh, à né *sóú Músì tueé cuaré ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Béh naâ mé tie beèh ŋgweé ye: Yeésò nùà Najarêt nde né gwà Càŋ tulú sɔm. Gènnè mé Músì lé feh lɔɔ̀ naâ béh, ye Yeésò nde né kweéh seér sé wa?» ");
INSERT INTO mcu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bɔ̀ nùàr yeé ŋgweé aá ménâ, bɔ́ su Etiên njolo yoòr gwà dɔɔ́ŋ. Bɔ́ ke, njolo Etiên den seér aá faá dé cìlì Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","*Ŋgàŋ sèmè dé koô bie njií mé Etiên ndɔ, ye bú a: «Né bɔ̀n wa?» ");
INSERT INTO mcu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiên ye bɔ́ a: «Bɔ̀ nùàr mò, bɔ̀ tele mò, bí ŋgwé! Càŋ Nùà *sùsùm lɔ naâ toò tele beèh Abrahâm ké Mèsòpòtamî ŋené yuo kelá, te Abrahâm nde ye ké Karân cer. ");
INSERT INTO mcu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","À yeé ŋené yuo kela baá, ye Abrahâm a: Wùò ter, kwá lɔ́ lò yeè mé mbàgà yeè ménâ, ndé sèr lè lò déì. Nyí nde né wò lò sâ feh ma. ");
INSERT INTO mcu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abrahâm bɔɔ́ ménâ, à kwaá lɔ lò bɔ̀ Kaldê bɔ̀, à nde den ké Karân. Jomo sâ tele seèn kuú ndɔ. Càŋ sɔm cu bú ké Karân, à kwaá ye bú lè lò mé béh née teèn hên. ");
INSERT INTO mcu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Càŋ bú tàbè teèn há ŋgwéh, à liím bilí bú mé bèh gule doboò mene, à tueé kwaá seér ye bú a: kɔ ndeè baá ké jomo, te bɔ̀ ndùté ndùtù seèn ndeè kwa ye tàbè ma. Sâ Abrahâm née seèn mé huaán sam ye. ");
INSERT INTO mcu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Càŋ tueé njií cu bú déì, ye bú a: Bɔ̀ ndùté ndùtù seèn ndeè te lò bɔ̀ nùàre den nde né kìn, bɔ́ nde né kwer ŋaá, bɔ́ gèr ŋene nde né fî. Nde né nyèmà yuií nèà, ");
INSERT INTO mcu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","te ju die ye felè bɔ̀ tú-kwer bɔ̀ sâ beè nyî, jueè nyí Càŋ. Jomo sâ bɔ̀ ndùté ndùtù seèn ndeè né teèn yuo, bɔ́ ndeè dua nyí kán. ");
INSERT INTO mcu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yeé gi aá, ye Abrahâm a: Bɔ́ bú baá mé ŋgɔ̀ŋ. Ŋgɔ̀ŋ sâ, kɔ à *ŋɔb ŋgór ma. Jomo sâ Abrahâm ŋar Isâk ndɔ. Yeé baá cieé téndelé, à ŋɔb baá-re bú ŋgór. Isâk yeé ŋar aá Jakɔ̂b, à ŋɔb cu bú ménâ ndɔ. Jakɔ̂b ŋar huaán yulà cùɔ̀b fà, bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh né bɔ́, Jakɔ̂b ŋɔbé gi bɔ́ ŋgór ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Jomo sâ, sà yila lètenè bɔ̀ ŋuna Jakɔ̂b. Bɔ́ bar Josêf, bɔ́ go njií bú te tàbè Ejíptò. Njèh cén, Càŋ lé naâ jomo seèn; ");
INSERT INTO mcu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gèr hihiné lé naá menè bú kwa laré, mé njéh mene, Càŋ lé naâ bú teèn dɔɔ́ŋ gam laré, à lé naâ bú kɔ́gɔ̀n haá. Josêf lé naâ *Farɔ̂ŋ mgbè Ejíptò yoòr huɔɔ́m. Yeé baá ménâ mgbè sie kwaá keéh bú ŋgɔ́mnà ndɔ, à sie kwaá bú te tàbè seèn dɔɔ́ŋ, à mbàm seèn kwaá lɔ beè seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Jomo sâ cùè die, cùè dueè yilà te tàbè Ejíptò mé tàbè Kanahân mene. Bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh ŋene gèr, bɔ́ yáb kwà cú. ");
INSERT INTO mcu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Cieé déì Jakɔ̂b ŋgweé njií ye ké Ejíptò yáb né teèn. À tema njií bɔ̀ ŋuna ké teèn, bɔ́ nde yáb ŋge wellê. ");
INSERT INTO mcu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","«Yeé baá gò dé jomò, Josêf sɔm keéh yo seèn toò bɔɔ̀n. Farɔ̂ŋ kɔ baá-re teèn ye bɔ́ né bɔ̀ bei Josêf ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yeé baá ménâ, Josêf ye bɔ́ ndé wèh ndê mé tele, mé mbàgà seèn mene ma. Sâ bɔ́ lé baá te mbàgà sâ dɔɔ́ŋ nùà yulà téhbeh cùɔ̀b tîn. ");
INSERT INTO mcu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bɔ́ yeé nde tueé njií Jakɔ̂b ménâ, à fɔɔ́n lom gò Ejíptò. Nde nde, Jakɔ̂b kuú le ké teèn. Jomo sâ bɔ̀ ŋuna seèn kuú le gi ké teèn ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bɔ́ jɔgɔ́ cu cuù mé bɔ̀ komó bɔɔ̀n ké Sikèm, bɔ́ bɔ́ furú gi lè sà mé Abrahâm lɔ ŋgeé naâ beè bɔ̀ ŋunà Hémôr. ");
INSERT INTO mcu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Nde nde, cu ndêb mé Càŋ lé naâ Abrahâm tueé kwaá yeé nde aá wulú, gèh bɔ̀ ndùté ndùtù seèn kar ndɔ, bɔ́ yam sie tàbè Ejíptò beè. ");
INSERT INTO mcu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jomo sâ, bɔ́ sie cu mgbè Ejíptò dé hiîn. Dé sâ lé Josêf kɔ́ ná ŋgwêh, ");
INSERT INTO mcu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","à felè bɔ̀ nùàr beèh bɔɔ́ sabé njií lom mbaá. Bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh gèr ŋene lom dé fî; à né bɔ́ baá, ye bɔ́ a: mɔ bɔ́ ŋar aá huaán, bɔ́ sìlì njí gí bɔ́ ya dueè te bɔ́ kuú ma. ");
INSERT INTO mcu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Sâ né nàm mé bɔ́ lé ŋaár naâ Músì teèn ndɔ. Huaán bú sâ lé naâ beè Càŋ bagasé. Tele leér kwaá bú gwò weéh tagár. ");
INSERT INTO mcu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yeé yɔgɔ́ baá, bɔ́ sɔm keéh bú gwò, bɔ́ nde leér njií bú yí dùà. Ŋunà *Farɔ̂ŋ dé vêh nde jɔgɔ kwa bú, à nde koó nyegé bú faá ŋuna seèn nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Músì né kulá ndeé, bɔ́ né bú lo bɔ̀ Ejíptò bɔ̀ dɔɔ́ŋ feh. Jomo sâ à kula jolo, à yuo nùàr toò bɔ̀ nùàr, seé seèn ŋgulí cu ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«À yeé baá mé nyèmà yulà nèà, à kaga ndòn ye nyí nde aá *Iserálà bɔ̀ nùàr nyî yɔŋ ke. ");
INSERT INTO mcu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","À yeé ke nùàr seèn déì nde cu aá mé gèr beè nùà Ejíptò déì ŋene kuú, à kela gàm, à bɔŋ njìè, à lobo wula sɔm nùà Ejíptò hèllè. ");
INSERT INTO mcu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","À munó lom aá ye te bɔ̀ nùàr nyî ŋgweé kɔ teèn, ye Càŋ kela keéh né gàm bɔɔ̀n beè nyî ma. Mé njéh mene, bɔ́ ŋgwé kòmò ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Cieé ŋaga, Músì kwa lɔ cu bɔ̀ Iserálà bɔ̀ déì fà, bɔ́ né lègè lege. À ye bɔ́ a: Bí né bɔ̀ cên bɔ̀, bí sà fɔɔ́n né dé keì wa? Sâ ye te nyí sie bilí cu bɔ́ mé sòn cên. ");
INSERT INTO mcu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dé mé taré yɔgɔ́ naâ mbeí doô berɔ́ŋ sòn Músì, ye bú a: Neì sie kwaá né wò nùà téná-juù felè beèh kɔɔ́ wa? ");
INSERT INTO mcu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wò gwaán cu né mè wulâ, faá wò lé wulà naâ nùà Ejíptò doô wa? ");
INSERT INTO mcu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Músì yeé nde ŋgweé njií ménâ, càŋ tené bú lè, à dula nde lè lò Màdínà, à ŋar kwa huaán fà ké sâ, ");
INSERT INTO mcu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","à cer ké teèn nyèmà yulà nèà. «Jomo sâ, à yeé baá ké ya dueè kwarè tòr Sinayî, cìlì Càŋ déì ŋené yuo kelà toò seèn te leba weè te jìlì ŋgémbèì. ");
INSERT INTO mcu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Músì yeé ŋene aá ménâ, geí seér bú lòù; à né yí teèn ndeé ser, te nyí ŋene nyegé, à ŋgweé hueh Càŋ Dueè baá ŋgulí ye bú a: ");
INSERT INTO mcu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Né nyí Càŋ bɔ̀ jɔ̀gɔ̀ bɔ̀ yeè. Nyí né Càŋ Abrahâm, Càŋ Isâk bɔ̂ Jakɔ̂b ma. Veéh sie Músì, à duɔɔ́m ndelê, à gwàn cú njolo yí teèn ke njiî. ");
INSERT INTO mcu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nùà Dueè den cuù, ye bú a: Húár sɔ̀m débágá gulè huaàr; wò né te bàŋ tàbè dé ŋagâ. ");
INSERT INTO mcu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ndê, nyí tema njií wò ké Ejíptò, wanɔɔ́ŋ nyí ŋene bɔ̀ nùàr nyî né mé gèr ké teèn kwaré. Bɔ́ baá cuané, nyí né hueh bɔɔ̀n ŋgweé njií, nyí hên suagà né bɔ́ yili sɔm. ");
INSERT INTO mcu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Sâ Músì cên sâ, bɔ̀ *Iserálà bɔ̀ lé naâ bú berɔ́ŋ, bɔ́ lé ye bú a: Neì sie kwaá né wò nùà téná-juù kɔɔ́ wa? Á sâ, Càŋ lé bú sie kwaá naâ kɔɔ́ ndɔ, ye te à den nùà koô felè bɔɔ̀n, à yili sɔm bɔ́. Càŋ lé bú ménâ tueé keéh naâ sònò cìlì seèn mé lé naâ ké te jìlì ŋgémbèì ŋené yuo kelá doô. ");
INSERT INTO mcu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Músì cên sâ lé Iserálà lè yuií kwer-e se sɔɔ́m naâ kɔɔ́. À lé naâ fém hihiné ké Ejíptò bɔɔ́ bele, à bɔɔ́ cu déì ké dùà Nòmò Bèlè. À bɔ̀ déì bɔɔ́ cu ké ya dueè lè nyèmà yulà nèà ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Músì cên sâ tueé cu ye bɔ̀ Iserálà bɔ̀ a: Càŋ ndeè né bí sòn seèn déì faá nyí nɔ tema njiî; nùà sâ yuo ndeè né lètenè biì ma. ");
INSERT INTO mcu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ké ya dueè felè bɔ̀ Iserálà bɔ̀ lé naá cuù Músì cên sâ; bɔ́ bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh lé naâ kɔɔ́. À lé naâ nàŋ lètenè bɔɔ̀n mé cìlì Càŋ. Njií mé cìlì Càŋ lé tueé naâ ké te tòr Sinayî dɔɔ́ŋ, à lé bɔ́ tueé keéh naâ kɔɔ́. Ŋgòr Càŋ mé baá ká beè beèh ŋgulí den hên, ké sònò Càŋ lé ŋgweé weéh naâ bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Mé njéh mene, bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh ŋgeén sòn seèn, bɔ́ mgbe njií bú yí jomo, ye bɔ́ nde lom cu ké Ejíptò ma. ");
INSERT INTO mcu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bɔ́ ye *Arɔ̂ŋ a: Bɔ́ kwá yeè béh cècàŋ teèn, te feh béh ceér, wanɔɔ́ŋ Músì seèn wá cû nɔ. À lé béh ké Ejíptò sɔm weéh naâ kɔɔ́, kènê béh kɔ́ cú njií mé kwa né bú. ");
INSERT INTO mcu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bɔ́ nde me kwaá baá-re cècàŋ déì faá huaán nàgà nɔ, bɔ́ né bú *sèmè ŋɔɔ́b haá. Yo né bɔ́ mé be seê bɔɔ̀n hèllè taré ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Càŋ yeé ŋene aá ménâ, à keéh seér bɔ́ mé ŋgɔ̀gɔ̀, te bɔ́ dua gɔ bɔ̀ mbentò. Sâ né gi te mvù bɔ̀ *sòn-Càŋ bɔ̀ ménâ nyagá den ndɔ, Càŋ ye: Iserálà, bí lé naâ ké ya dueè nyèmà yulà nèà bɔɔ́, bí né sèmè haá sɔɔ́. Mé gècên mene bí lé sèmè sâ haá beéh mè wa? ");
INSERT INTO mcu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ké gwò mò, bí lɔɔ̀ né mè, bí dua seér *Mòlɔ̀k. Bí né cècàŋ faá mbentò nɔ bɔɔ́ kwaá, bí ye né càŋ biì, bí bú yilá kwaá né Rafan, bí né bú dua den. Bí kwá nɔɔ́ŋ! Mè nde né bí ké jomo Babilɔ̂n domó su njií keéh.» ");
INSERT INTO mcu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiên den cuù ye: «Ké ya dueè sâ bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh lé naâ *gwà cɔ̀gɔ̀ sieé, te bɔ́ kwaá nyegé mvù sóù teèn. Bɔ́ lé sieè naâ faá Càŋ lé feéh naâ mé Músì nɔ, à lé ye bú a: Ndé síé kwá ká ménâ nág. ");
INSERT INTO mcu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","«Gwà sâ nde dɔgɔ yuo kela mé nàm Josúê, sâ nùà koô lètenè bɔ̀ tele beèh né bú. Bɔ́ bɔ́ jɔgɔ yilà mé njéh ká te lò mé Càŋ lé naâ bɔ́ tueé kwaá, Càŋ lé ye bɔ́ a, nyí nde né bɔ̀ lɔɔ̂ bɔ̀ toò bɔɔ̀n kwɔgɔ́ sɔm, te bɔ́ cer keéh ma. Bɔ́ den le baá-re mé gwà cɔ̀gɔ̀ hèllè teèn méménâ tɔ́g nde wa mé nàm *Davîd. ");
INSERT INTO mcu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davîd lé naâ Càŋ mé gècên mene yoòr yilá, à lé naâ bú dua, ye bú a, Càŋ Tele nyî Jakɔ̂b, kwá nyí me kwaá wò gwà ma. ");
INSERT INTO mcu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Njèh cén, Salomɔ̂ŋ nde gwà sâ me seér aá kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Mé njéh mene, gwà mé bɔ̀ nùàr me né mé be dɔɔ́ŋ, Càŋ terrèb ké te vulúu teèn cèr nyì bèh. Né faá sòn-Càŋ lé tueé naâ nɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Càŋ ye, vulú né kɔgɔ nyî, tàbè né bèh dòbò gulè nyî, jue nyí Càŋ Dueè. Bí nyí me komo nde né gèh gwà dé heè, te nyí du beh teèn wa? ");
INSERT INTO mcu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ŋgweéh njèh dɔɔ́ŋ bɔɔ́ giì naâ nyí mà.» ");
INSERT INTO mcu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiên den cuù ye bɔ́ a: «Kɔ̀cɔ̀! Bí bɔ̀ dúágá-tie bɔ̀ mé ndòn kuú lè! Bí né yeé sòn mé Cúcuí Ŋagâ taré! Bí saán cu né ka sòn-Càŋ faá bɔ̀ tele biì léí jɔ̀gɔ̀ nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","53","Sòn-Càŋ dé heè mé bɔ̀ tele biì lɔ bùnò ná ŋgwêh wa? Ŋgweéh bɔ̀ɔ́ mé lé tueé naâ ye Nùà gècên baá ndeê, bɔ̀ tele biì lɔ bɔ́ wula giì naâ kɔɔ́ wa? Bí bɔ̀ tele biì né cu ka nág! Bɔ́ lé ŋgweé naâ *sóú sònò bɔ̀ cìlì Càŋ, bí né mene sóú sâ ŋgweé, bí jòlò ŋgwéh. Nùà gècên sâ yeé waà baá, bí bú jɔgɔ kwaá seér cie. Ŋgweéh bí lé bú wula sɔɔ́m naâ kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Etiên tueé gi ndɔ. Bɔ̀ kokoô bɔ̀ yeé nde ŋgweé njií ménâ, temé yulá bɔ́ lè, bɔ́ né nyie yieé. ");
INSERT INTO mcu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Etiên mé Cúcuí Ŋagâ né yoòr ŋgulí, kɔ lom né njolo ké te vulúu ke njiî. À ŋene njií *sùsùm Càŋ, mé Yeésò ké te be gaâ Càŋe, à né ter njebá den. ");
INSERT INTO mcu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Etiên tueé njií bɔ̀ nùàr ndɔ, ye bɔ́ a: «Bí kè! Vulú gulu baá kèn! Mè ŋene njií aá *Huaán Nùàr ké te be gaâ Càŋe, à né ter njebá den.» ");
INSERT INTO mcu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bɔ́ bɔm bú, bɔ́ bɔm lɔgɔ njií ké ter, bɔ́ faga tie bɔɔ̀n ndɔ. Jomo sâ bɔ́ kem sue bú yoòr dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bɔ́ tulu yuo kela mé bú ké jomo lɔɔ̂. Bɔ̀ nyeên bɔ̀ hèllè huaré haá njií cɔ̀gɔ̀ bɔɔ̀n beè nuaré déì, yilí nùà sâ né Sɔ̂l, bɔ́ duɔɔ̂m Etiên tɔbê. ");
INSERT INTO mcu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bɔ́ yeé baá bú tɔbé, à né Càŋ sònò dua, ye: «Fehtoò mò Yeésò, wèh kéh yɔ̀ŋ mò.» ");
INSERT INTO mcu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jomo sâ, à cemmé nde doó, à lɔgɔ njií ké ter ye: «Fehtoò mò, té veên hên mé bɔ́ bíé.» À yeé tueé gi aá ménâ, à kuú. ");
INSERT INTO mcu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Temé Sɔ̂l lé naâ nɔré mé cio sâ ndɔ. Etiên yeé kuú aá, bɔ̀ dùlà-Càŋ bɔ̀ nde jɔgɔ furu bú. Bɔ́ yueé ŋellé mbà seèn doó dɔɔ́ŋ. Sâ né loù mé bùnò ké Jerusalem lé duɔɔ́m naâ teèn. Bɔ̀ Yeésò bɔ̀ durá ŋellé yila nde lè lò Judê mé lò *Samarî dɔɔ́ŋ. Bɔ̀ mbɔ̀ŋ tebê le lom ké Jerusalem kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sâ Sɔ̂l yuo die lom aá dé seèn bɔ̀ Yeésò bɔ̀ yoòr, te bɔ́ ŋeéŋellè. À né bɔ́ gùgwò yilá sie weh, véh mé siíb mene, à yií njií bɔ́ lè gwà cibì. ");
INSERT INTO mcu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bɔ̀ɔ́ mé lé naâ bèh dɔɔ́ŋ dula ŋellé ndeé, wa toò, bɔ́ yila ŋgòr Càŋ tueê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filîp dé seèn nde lè lɔɔ́ déì te tàbe Samarî, à né bɔ́ ŋgòr felè *Kristò tueé. ");
INSERT INTO mcu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bɔ̀ nùàr né ŋgweé, à né fém bɔɔ́, bɔ̀ nùàr né mé njolo ŋené, bɔ̀ nùàr kókoó mbaá kwaá njií gi tie teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tándulu keéŋ durá yuo lè bɔ̀ nùàr ŋgún, bɔ̀ gule-kuû bɔ̀ mé bɔ̀ tácɔgɔ́ taré yuo gi ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Bɔ̀ nùàr lɔɔ́ dɔɔ́ŋ samé lom mé njéh dé gècên. ");
INSERT INTO mcu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sâ nùà táhunò déì lé naá baá lɔ sâ táhuno lètenè bɔ̀ nùàr bɔɔ́ den, ye nyí né nùà koô; yilí nùà sâ lé naâ Simɔ̂ŋ. Bɔ̀ Samarî bɔ̀ dɔɔ́ŋ lé naá giì ŋené ye seé seèn né mé fém teèn, ");
INSERT INTO mcu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","bɔ́ né tie teèn felá njií, bɔ̀ kàm bɔ̀ mé ndà mene né gi tueé ye: Nùà hên né mé terreb Càŋ yoòr, né lom meì bɔ̀ terreb sâ. ");
INSERT INTO mcu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lòù sam, dàb baá teèn mé à né lètenè bɔɔ̀n ménâ bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filîp yeé baá Njàgà Bagaà se, à baá dene Lò Càŋ se, à né ŋgòr felè Yeésò *Kristò tueé, bɔ́ kwaá njií temé teèn; siíb mene, véh mene weh gi nòmò Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔ̂ŋ mé feh seèn kweéh seér temé, bɔ́ kou bú ndɔ. Bɔ́ yeé kou sɔm aá bú, à den le kwarè Filîp. Bɔ̀ fém gèh hihiné mé Filîp né bɔɔ́ bele dɔɔ́ŋ lé naâ njolò seèn, né bú mbaá geí yɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bɔ̀ mbɔ̀ŋ tebê ŋgweé njií ké Jerusalem ye, bɔ̀ Samarî bɔ̀ baá ŋgòr Càŋ gwaán. Bɔ́ tema njií Piêr bɔ̂ Jâŋ ké teèn. ");
INSERT INTO mcu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bɔ́ yeé wa baá, bɔ́ dua Càŋ felè bɔ̀ sâ bɔ̀ te bɔ́ kwa Cúcuí Ŋagâ. ");
INSERT INTO mcu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Lòù sam, bɔ́ lé bɔ́ kou kwaá loóm naâ mé yilí Yeésò Fehtoò beèh, bɔ́ lé née Cúcuí Ŋagâ kwà ŋgwéeh ye. ");
INSERT INTO mcu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bɔ́ yeé dua gi aá Càŋ, bɔ́ ba bɔ́ be felè ndɔ, bɔ́ kwa baá-re Cúcuí Ŋagâ. ");
INSERT INTO mcu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simɔ̂ŋ yeé ŋene bɔ̀ nùàr né Cúcuí Ŋagâ mé njéh kwa, à haá Piêr bɔ̂ Jâŋ kàgàlɔ̀ŋ, ");
INSERT INTO mcu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ye bɔ́ a: «Bí há mè gèh terrèb bú sâ teèn ndɔ, te mè ba bɔ̀ nùàr be felè mé njéh, bɔ́ kwa Cúcuí Ŋagâ.» ");
INSERT INTO mcu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piêr deên ndɔ, ye bú a: «Bî kàgàlɔ̀ŋ yeè a, cálé gí fà dɔɔ́ŋ, te wò kɔ ye, njií mé Càŋ haá né dé lòù, nùàr lòù ŋgè bèh! ");
INSERT INTO mcu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mè tueé wò, ndɔ́g gà dé yeè lè seé hên sam, temé yeè né lom beè Càŋ veénsé mân. ");
INSERT INTO mcu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kwéh sér temé yeè, wò kwɔbé leba, wò dua lom Nùà Dueè, te à kulu sɔm wò veên sâ yoòr, ");
INSERT INTO mcu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","wanɔɔ́ŋ temé yeè né lè jelásé, wò né kwer veên ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simɔ̂ŋ ye Piêr a: «Mɔ né mân, bí dùà Fehtoò beèh felè mò teèn, te njeré déì mè faá bí tueé naâ sâ kwà cú.» ");
INSERT INTO mcu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bɔ̀ mbɔ̀ŋ tebê fà doô yeé se gi aá sòn Fehtoò beèh, bɔ́ tueé gi aá ŋgòr Càŋ, bɔ́ cu cu ké Jerusalem ndɔ. Bɔ́ né gɔ, bɔ́ né mé Njàgà Bagaà lè lɔɔ́ hihiné te tàbè Samarî tueé ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jomo sâ cìlì Càŋ déì ye Filîp a: «Wùò ter, ndé sér kèb túnò, te ceér ya dueè mé suagà né ké Jerusalem nde Gàsà doô.» ");
INSERT INTO mcu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filîp wuo ter ndɔ, à nde, à wa ceér dueè, à ŋene nùà Etiopî déì teèn. À né nùà seê dé koô beè Kàndâse. Kàndâse né mgbè dé vêh felè bɔ̀ Etiopî bɔ̀. Bɔ̀ ŋgùlù lɔɔ̂ dɔɔ́ŋ né gi beè nùà koô sâ. À naâ ké Jerusalem bèh Càŋ duaà, ");
INSERT INTO mcu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","à nde cu aá lɔ. À né te màtúâ déì den den, à né mvù Esáyà *sòn-Càŋ jaŋé den. ");
INSERT INTO mcu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Cúcuí Ŋagâ ye Filîp a: «Ŋgòrò ndé yí kwarè màtúâ sâ.» ");
INSERT INTO mcu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filîp dula nde yí teèn ndɔ, à ŋgweé nùà doô né njeré déì lè mvù Esáyà jaŋé den. Filîp bie njií, ye bú a: «Wò né njií sâ ŋgweé kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nùà hèllè ye bú a: «Mɔ nuaré déì mè lòù sè ŋgwéh, mè ŋgweé komo nde né naàn wa?» Jomo sâ, ye Filîp a: «Ndê ŋá dèn ká kwarè mò.» Filîp den nde ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sâ nùà hèllè lé jaŋé deén naâ bèh mé bɔ́ nyagá kwaá né teèn ye: «À lé deén naâ faá sòrŋgaŋ mé bɔ́ derré njií né bèh ŋɔɔ̂b nɔ. Mé sòn kúb faá huaán sòrŋgaàŋ den né toò nuaá mé né bú hobó nɔ, à lé sòn kòmò nyì ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bɔ́ lé naâ ju nyeên felè seèn tená, bɔ́ bɔɔ́ gulí bú. Dene seèn ká lè wɔ́ŋe ceré baá kèn; gèh seèn ceré le aá mé bú ndɔ.» Sâ nùà hèllè lé jaŋé deén naâ bèh sâ. ");
INSERT INTO mcu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jomo sâ, ye Filîp a: «Kúkùr yeè, sè yeè mè teèn. Sòn-Càŋ hên tueé njií né felè neì wa? À tueé den né felè seèn nùà njèh wa, né felè nuaré déì wa?» ");
INSERT INTO mcu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filîp kwa baá-re ceér ndɔ. À yeé baá bú se, à tueé keéh bú Njàgà Bagaà felè Yeésò teèn. ");
INSERT INTO mcu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bɔ́ bú né ka ndeé, bɔ́ wa beré déì, bɔ́ kwa nòmò. Nùà koô doô ye Filîp a: «Kè nòmò hên. Kei yiín né mè kou sɔɔ̀m kɔɔ́ wa?»  ");
INSERT INTO mcu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filîp ye bú a: «Mɔ wò kwaá njií aá temé cén yoòr Yeésò *Kristò, mè kou wò mà.» Nùà hèllè ye bú a: «Mè kwaá njií aá temé mò yoòr Yeésò Kristò, ye à né Ŋunà Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","À yeé tueé gi aá ménâ, ye bɔ́ sìè njébá màtúâ njebà. Bɔ̂ Filîp suaga nde ké dùà fà dɔɔ́ŋ. Filîp kou sɔm bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bɔ́ yeé yuo kela baá yí dùà, Cúcuí Fehtoò beèh nyue leér sɔm Filîp. Nùà koô doô yeé Filîp ŋéné cú, à fɔɔ́n gò seèn mé vɔ́gɔ́-temé mene ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filîp nde yuo kela dé seèn ké Asótà. Jomo sâ, à tueé bele ŋgòr Càŋ te lɔɔ́ hihinê, à né bɔ̀ nùàr Njàgà Bagaà se, à mé njéh tɔ́g se yuo kela ké Sesarê. ");
INSERT INTO mcu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sâ Sɔ̂l née dé seèn mé bɔ̀ mbɔ̀ŋ Fehtoò beèh bunó ndeé ye, à bɔ́ bunó lom né dé cioò. À nde kwa *ŋgàŋ sèmè dé koô, ");
INSERT INTO mcu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ye bú a: Nyàgà jègè há nyí mvù beè, te nyí nde mé njéh ké Damâs lè *gwà sóù, bɔ́ haá nyí lɔ́ŋ, mɔ nyí kwa baá bɔ̀ɔ́ mé né ceér Yeésò ké teèn bele, siíb mé véh mene dɔɔ́ŋ, te nyí sie nde giì mé bɔ́ ká Jerusalem ma. ");
INSERT INTO mcu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Bɔ́ yeé jege haá baá bú, à fɔɔ́n gò Damâs ndɔ. À yeé baá kwarè lɔɔ̂, ŋagâ déì ba suagà ter, ka sie bú beè. ");
INSERT INTO mcu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","À jege die doó. À ŋgweé njií hueh déì né ŋgulí den, ye bú a: «Sɔ̂l, Sɔ̂l, wò mè ménâ bunó né mé ŋgei wa?» ");
INSERT INTO mcu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔ̂l ye bú a: «Né wò neì wa, Nùà Dueè?» Hueh doô ye bú a: «Né mè Yeésò mé wò né bunó den sâ. ");
INSERT INTO mcu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mé njéh mene, kòmò wùò yeè ter, wò yila nde ké lɔ. Mɔ wò baá ké lɔ, njií mé wò nde né bɔɔ́, bɔ́ nde né wò feh.» ");
INSERT INTO mcu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bɔ̀ɔ́ mé lé naá giì jomo Sɔ̂l dɔɔ́ŋ, njebá ndegé le gi, yɔgɔ́ bɔ́ dé tueê; bɔ́ né hueh ŋgweé, bɔ́ nùàr teèn ŋéné ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jomo sâ Sɔ̂l komo wuo ter ndɔ. À yeé wa njolo, njolo njeré déì ŋéné cú. Bɔ́ mé bú ké Damâs derré wa baá lòù. ");
INSERT INTO mcu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","À cugó sɔɔ́ cieé tagár. À yáb mé nòmò sònò yí ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Sâ mbɔ̀ŋ Yeésò cén déì né ké Damâs sâ teèn, yilí seèn lé naâ Ananíà. Fehtoò beèh lé naâ njolò seèn ŋené yuo kelá, ye bú a: «Ananíà!» À gwaán ye bú a: «Mè hên nɔ, Fehtoò mò.» ");
INSERT INTO mcu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Fehtoò beèh ye bú a: «Wùò ter, ndé ké te ceér mé bɔ́ yilá né Ceér Dilî doô, wò nde ké gwò Júdàs, wò bie nùà Târse déì ké teèn, yilí seèn né Sɔ̂l. À né mè kènê sònò dua den. ");
INSERT INTO mcu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wò Ananíà naâ njolò seèn ŋené yuo kelá, wò naâ bú be felè baá, te à ŋene cu njolo.» ");
INSERT INTO mcu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","À yeé tueé gi aá Ananíà ménâ, Ananíà ye bú a: «Fehtoò mò, bɔ̀ nùàr kókoó mbaá ye mè a, nùà sâ né lom nùà veên. Njií mé à né yeé bɔ̀ nùàr yeè ké Jerusalem bɔɔ́, mè ŋgweé gi aá kèn. ");
INSERT INTO mcu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","À ká lɔ hên nde kuû né felè bɔ̀ɔ́ mé né wò dua, ye te nyí kagá njií bɔ́ ké Jerusalem. Bɔ̀ ŋgàŋ sèmè dé kokoô jege haá gi aá bú terreb ké jomo kèn.» ");
INSERT INTO mcu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Fehtoò beèh ye Ananíà a: «Ndé yeè ndeè! Mè bú balé weh né kɔɔ́, kènê à baá seér nùà seê mò, à nde né mé yilí mò lò nùàr dɔɔ́ŋ tueé ndeé, à tueé bilí mé bɔ̀ mgbè bɔɔ̀n mene. À nde né bɔ̀ *Iserálà bɔ̀ ŋgòr mò se ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mè bú feh nde né mé feh mò ye bú a, gèr né teèn, à nde né gèr mé yilí mò fî ŋené ma.» ");
INSERT INTO mcu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yeé baá ménâ, Ananíà fɔɔ́n gò ndɔ. À wa ké gwò, à ba Sɔ̂l be felè, ye bú a: «Sɔ̂l nùàr mò, Yeésò Fehtoò beèh mé lé naâ ké ceér dueè yoòr yeè ŋagá yuo kelá, tema njiî né mè kɔɔ́, te wò ŋene cu njolo, wò kwa Cúcuí Ŋagâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananíà yeé tueé sɔm aá mân, bɔ̀ njeré déì kebá yuo bele Sɔ̂l njolò faá werrè mân, dielé nde doó, à ŋene cu njolo, à komo wuo ter. Bɔ́ nde kou bú nòmò Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","À yieé cu yáb, à kwa cu terreb faá bèh jomò nɔ. Sɔ̂l bɔ́ bɔ̀ mbɔ̀ŋ dé ké Damâs sâ cer weh cegé ŋgɔ́b. ");
INSERT INTO mcu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","À ŋar yila lom aá ŋgòr Càŋ te *gwà sóù tueé beleè, ye bɔ̀ nùàr a, Ŋunà Càŋ né Yeésò ma. ");
INSERT INTO mcu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bɔ̀ nùàr yeé ŋgweé cu aá sònò seèn ménâ, geí seér bɔ́ lòù; bɔ́ ye: «Ŋgweéh hên né nuaá mé lé bunó lom beéh bɔ̀ nùàr Yeésò ké Jerusalem dé kùm doô wa? Ŋgweéh à hên nde kuú naâ ye te nyí sie njií cu bɔ́ ké toò bɔ̀ ŋgàŋ sèmè dé kokoô wa?» ");
INSERT INTO mcu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mé njéh mene, Sɔ̂l ŋgòr Càŋ tueé seér cu mé terreb, à né lom bɔ̀ *Jûf dé ké Damâs sâ tueé, ye bɔ́ a, *Nùà Cɔ̀ŋ né Yeésò ma. Bɔ́ bèh tueê kwà cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cèr dè ŋgwéh, bɔ̀ *Jûf nyɔgɔ sòn, ye bɔ́ nde né Sɔ̂l wulá sɔm. ");
INSERT INTO mcu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nyɔ̀gɔ̀ sòn sâ nde ŋgulí kwa Sɔ̂l. Bɔ́ kwaá tena bele nùàr ké tùtúlù bɔ̀gɔ̀ lɔɔ̂ dɔɔ́ŋ, bɔ́ né bú teèn cíbí mé suútenè mene mɔɔ́m den, te bɔ́ wula bú wulà. ");
INSERT INTO mcu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bɔ̀ mbɔ̀ŋ Sɔ̂l yeé ŋene aá ménâ, bɔ́ nde cíbítenè, bɔ́ jɔgɔ yií bú te sɔgɔ̂, bɔ́ segé sɔm keéh te kùm bɔ̀gɔ̀, bɔ́ kwaá njií bú ké doó, à yuo. ");
INSERT INTO mcu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔ̂l cu cu ké Jerusalem. À wa ké teèn, ye te bɔ́ bɔ̀ mbɔ̀ŋ déì den bilí. Bɔ́ yeé ŋene njií bú, veéh sie yɔgɔ́ bɔ́ mé bú. Sâ bɔ́ née kɔ́ nyégé ŋgwéeh ye Sɔ̂l baá mbɔ̀ŋ Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bàrnàbâs yeé ŋene aá ménâ, à weh njií bú ké toò bɔ̀ mbɔ̀ŋ tebê, à nde se ŋagá nyegé bɔ́ naàn mé Sɔ̂l lé naâ Fehtoò beèh ké ceér dueè ŋené, à se bɔ́ njií mé Fehtoò beèh lé naâ bú tueé ndɔ. À tueé cu bɔ́ gèh dé mé Sɔ̂l lé naâ ŋgòr Càŋ mé yilí Yeésò ké Damâs se, ye bɔ́ a, à lé vèh ná ŋgwêh ma. ");
INSERT INTO mcu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Doó sâ Sɔ̂l yila nde lètenè bɔ̀ mbɔ̀ŋ doô ndɔ, à né ndeé, à né cuú, à né ŋgòr Càŋ lètenè lɔɔ́ Jerusalem mé yilí Yeésò se bele, à njeba lom teèn tég. ");
INSERT INTO mcu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Bɔ̀ *Jûf mé né ju Greêk ŋgweé, à né mé bɔ́ tueé njií, bɔ́ bɔ́ né saán kuú. Yeé baá ménâ, bɔ́ nyɔgɔ cu sòn, te bɔ́ wula bú wulà. ");
INSERT INTO mcu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bɔ̀ Yeésò bɔ̀ yeé ŋgweé aá ménâ, bɔ́ weh njií bú ké Sesarê, à nde cu Târse. ");
INSERT INTO mcu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jomo sâ, bɔ̀ Yeésò bɔ̀ lè tàbè Judê mé Galilê bɔ̂ *Samarî dɔɔ́ŋ ŋgweé fu ndɔ, bɔ́ né mé terreb Cúcuí Ŋagâ yaám ndeé den, bɔ́ né taré ndeé, bɔ́ né Fehtoò beèh teèn mé temé cén dula. ");
INSERT INTO mcu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piêr lé naâ lò beè yɔŋ sie, à lé naâ ké Lídà yoòr bɔ̀ Yeésò bɔ̀ dé ké doó sâ ndeé, ");
INSERT INTO mcu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","à nde kwa nùà gule-kuû déì ké teèn, yilí seèn né Enê, baá nyèmà téndelé à né lè ndagâ cer den. ");
INSERT INTO mcu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piêr ye bú a: «Enê, Yeésò *Kristò né wò taré sɔm! Wùò ter, nyégé ndagá yeè nyegè.» Enê komo wuo ter ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bɔ̀ Lídà bɔ̀ mé bɔ̀ nùàr ké te bela Sàrɔ̂ŋ dɔɔ́ŋ yeé ŋene aá ménâ, bɔ́ kweéh seér gi temé, bɔ́ bele ceér Fehtoò beèh. ");
INSERT INTO mcu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sâ mbɔ̀ŋ dé vêh déì lé naâ ké Jopê teèn, yilí seèn lé naâ Tàbítà. Yilí sâ lè ju Greêk né Dɔrékà. Sâ tueé né ye: mbélêm. Cu dɔɔ́ŋ à lé naá beéh bɔ̀ saâm bɔ̀ njolo yoòr ke njií, à né bɔ́ gam. ");
INSERT INTO mcu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Cu sâ Dɔrékà nde die beén teèn, à kuú. Bɔ́ ye kou sɔm aá bú, bɔ́ jɔgɔ njií komó seèn lè gwà dé ké teèr, bɔ́ yií njií ké mí. ");
INSERT INTO mcu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Sâ bɔ̀ mbɔ̀ŋ dé ké Jopê lé ŋgweé naâ ye Piêr né ké Lídà, kwarè Jopê doó sâ. Yeé baá ménâ, bɔ́ tema njií nùà fà ké yoòr seèn, ye bú a: Kúkùr yeè, jɔ̀gɔ̀ ndê béh kán ye, gɔ̀ ká gɔɔ̀ ma. ");
INSERT INTO mcu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piêr komo wuo ter ndɔ, bɔ́ bɔ́ fɔɔ́n gò. Bɔ́ yeé wa baá, bɔ́ weh njií bú ké mí, lè gwà dé ké teèr sâ. Bɔ̀ ma kû mé lé naâ teèn kem nde gi ké yoòr seèn, bɔ́ né yueé, bɔ́ né bú bɔ̀ cɔ̀gɔ̀ hihiné feh keéh bele, bɔ́ ye bú a: «Hên Dɔrékà lé saà naâ kɔɔ́, sâ à née mé njolo ye.» ");
INSERT INTO mcu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piêr sɔm keéh gi nùàr cie, à cemmé nde doó, à dua Càŋ. Jomo sâ, à bele seér, à ke njií komó, à ye: «Tàbítà, wùò ter!» À wa njolo ndɔ, à ŋene Piêr, à komo den ter. ");
INSERT INTO mcu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piêr sie gam bú be, à komo njebá cu ter. Piêr yilá njiî bɔ̀ mbɔ̀ŋ mé bɔ̀ ma kû doô, à haá njií cu bɔ́ nùàr bɔɔ̀n, sâ à taré yuo aá. ");
INSERT INTO mcu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ŋgɔ́g sâ ŋgulí yɔŋ Jopê dɔɔ́ŋ. Bɔ̀ nùàr ŋgún yeé ŋgweé aá ménâ, bɔ́ kwaá njií ye temé bɔɔ̀n yoòr Fehtoò beèh. ");
INSERT INTO mcu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piêr cer yií ké Jopê sâ kɔ́beè; lé naâ ké lɔ Simɔ̂ŋ nùà sá-paàr. ");
INSERT INTO mcu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nuaré déì lé naâ ké Sesarê teèn, yilí seèn né Kɔ̀rnê, à lé naâ kwaá-taâb te bɔ̀ŋ taâb bɔ̀ Rɔ̂m bɔ̀ mé bɔ́ yilá yeé bɔ̀ŋ Italî doô. ");
INSERT INTO mcu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","À né yeé Càŋ dula; mé mbàgà seèn mene, bɔ́ né bú cu dɔɔ́ŋ dua; à né bɔ̀ saám bɔ̀ lètenè bɔ̀ *Jûf kókoó mbaá gam ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cieé déì lou yeé geér aá, mé lɔ̀ŋ tagár, kulu bú faá vuú nɔ; à ŋene cìlì Càŋ déì yila kweêh ká gwò seèn, ye bú a: «Kɔ̀rnê!» ");
INSERT INTO mcu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","À ke njií bú mé veéh mene, ye bú a: «Né naàn wa, Nùà dueè?» Cìlì Càŋ ye bú a: «Càŋ ŋgweé aá duaà yeè kèn, à ŋene baá gàm mé wò gam yeé bɔ̀ saám bɔ̀ kèn ndɔ. Lan à munó baá wò. ");
INSERT INTO mcu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Témá njí nùàr kènê ké Jopê yoòr nuaré déì, yilí seèn né Simɔ̂ŋ, yilí seèn déì né cu Piêr, te bɔ́ yilá ndeè mé bú. ");
INSERT INTO mcu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","À cer né ké gwò nuaré déì, yilí seèn né Simɔ̂ŋ ndɔ; né nùà mé sa yeé par. Gwà seèn né ké sòn nòmò koô mân.» ");
INSERT INTO mcu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cìlì Càŋ yeé tueé gi aá bú ménâ, à yuo ndɔ. Jomo sâ Kɔ̀rnê yilá njiî bɔ̀ seê bɔ̀ seèn déì fà, mé sɔ́jì seèn déì; sɔ́jì sâ né taré nùà dùlà-Càŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","À se gi bɔ́ njií mé kelà naâ dɔɔ́ŋ, à tema njií baá-re bɔ́ ké Jopê. ");
INSERT INTO mcu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Cieé ŋaga, bɔ́ né ka ndeé. Bɔ́ yeé nde aá Jopê waá, lou dilí. Sâ Piêr la ŋaá baá ké ter felè gwà bèh Càŋ duaà. ");
INSERT INTO mcu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Cùè baá lom bú sie ndɔ. Bɔ́ yeé baá yáb neé, kulu bú faá vuú nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","À ŋene njií vulú gulu lɔgɔ́ baá, tàmbàŋ njeré déì faá cɔ̀gɔ̀ nɔ yuo kelà ké teèn, bɔ́ sie né bèh nèà te gou te gou; né ka felè seèn segé suagâ, waà, bɔ́ kwaá njií doó. ");
INSERT INTO mcu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lè teèn lé naâ bɔ̀ nyam mé bɔ̀ sàb, bɔ́ bɔ̀ non feh hihiné. ");
INSERT INTO mcu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hueh déì deên ye bú a: «Wùò ter Piêr, wúlá yíé bɔ̀ njií sâ wulà.» ");
INSERT INTO mcu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piêr berɔ́ŋ ye bú a: «Hɔ̂s Nùà Dueè! Mè gèh dé sâ yíé bèh, né yilísé, mè nde né mbaá fulá.» ");
INSERT INTO mcu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hueh doô tueé ferré cu, ye bú a: «Té njií mé Càŋ ye né ŋagásé jìnè, té túé ye nyí nde né mé njéh fulá.» ");
INSERT INTO mcu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yeé wa baá mbei tagár, cɔ̀gɔ̀ hèllè ŋaá yuo cu ké te vulúu. ");
INSERT INTO mcu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piêr yila baá-re kwɔ̀m vuú sâ munô. Cu mé à né ménâ munó den, sâ bɔ̀ tebé bɔ̀ Kɔ̀rnê bie ŋene baá gwà Simɔ̂ŋ kèn ndɔ, bɔ́ né ké tùtúlù njebá den. ");
INSERT INTO mcu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bɔ́ né yilá bieé den ye: «Simɔ̂ŋ cer yeé hên wa? Yilí seèn déì né cu Piêr.» ");
INSERT INTO mcu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sâ Piêr née ka dé seèn kwɔ̀m vuú hèllè munó den ye. Cúcuí Ŋagâ tueé njií bú ndɔ, ye bú a: «Ŋgwé, bɔ̀ nuaré déì tagár né wò hên fɔɔ́n den. ");
INSERT INTO mcu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wùò ter, súágá ké doó, bí bɔ́ nde, té njeré déì mùnò, mè tema njií naâ bɔ́ mân kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piêr wuo ter ndɔ, à suaga nde ké yoòr bɔɔ̀n, ye bɔ́ a: «Nuaá mé bí fɔɔ́n den né sâ né mè. Bí ndeè bèh keì wa?» ");
INSERT INTO mcu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bɔ́ ye bú a: «Kɔ̀rnê kwaá-taâb temà naâ béh kɔɔ́. Né nùà dilî, à né yeé Càŋ dula. Bɔ̀ *Jûf dɔɔ́ŋ né gi bú keí. Cìlì Càŋ déì lé naâ bú feh, ye bú a: Ndê, yílá njî wò ké lɔ seèn, te à ŋgweé njií mé wò nde né bú tueé ma.» ");
INSERT INTO mcu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bɔ́ yeé tueé gi aá ménâ, Piêr weh yií njií bɔ́ gwò, à feh bɔ́ bèh cèrrè. Cieé yeé ŋaga baá, bɔ́ bɔ̀ Piêr yuo bele ceér. Bɔ̀ Yeésò bɔ̀ déì lètenè bɔ̀ Jopê bɔ̀ njií lɔ bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Cieé ŋaga cu bɔ́ wa Sesarê, sâ Kɔ̀rnê né bɔ́ kela. Bɔ́ bɔ̀ nùàr seèn, mé bɔ̀ mbeí seèn mé à yilá njií belé naâ dɔɔ́ŋ, né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Te Piêr yeé nde aá lɔ Kɔ̀rnê yilá ndeé mân, Kɔ̀rnê ndeè ka gule seèn cemmé ndeé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piêr yeé ŋene aá ménâ, à sie sɔm bú ter, ye bú a: «Wùò ter, mè né ka nùàr faá wò nɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bɔ́ bú yila bieê. Jomo sâ bɔ́ yila nde gwò ndɔ. Sâ bɔ̀ nùàr ŋgún né gwò bilí den. ");
INSERT INTO mcu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Piêr ye bɔ́ a: «Bí né gi mé feh biì kɔɔ́ ye, né jolo, nùà Jûf bɔ́ bɔ̀ kìn bècénè dèn bílí bèh. Béh gwò bɔ̀ kìn yílá bèh ndɔ. Dé mò, cieé fà hên Càŋ mè feh seér naâ kɔɔ́, ye mè a: té nuaré déì kurú yílá. ");
INSERT INTO mcu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Bí yeé tema njiî, ye mè a, ndê, mè táŋ sɔ́ cú dé cî. Á, bí mè yilá naâ mé ŋgei wa?» ");
INSERT INTO mcu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔ̀rnê ye bú a: «Lé naá kaà faá cu kènê nɔ, lan baá cieé nèà, mè lé naâ Càŋ ká gwò mò dua den, sâ baá lou lɔ̀ŋ tagár. Mè yeé ke, nuaré déì baá toò mò njebá den. À né mé cɔ̀gɔ̀ wulésé mân yoòr. ");
INSERT INTO mcu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ye mè a: Kɔ̀rnê, Càŋ ŋgweé aá duaà yeè kèn, à ŋene aá gàm mé wò gam yeé bɔ̀ saám bɔ̀ ndɔ. Lan à munó baá wò. ");
INSERT INTO mcu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kènê témá njí nùàr ké Jopê yoòr Simɔ̂ŋ, yilí seèn déì né cu Piêr, te bɔ́ yilá njiî bú ká yoòr yeè. À cer né ké gwò nuaré déì, yilí seèn né cu Simɔ̂ŋ ndɔ. Né nùà mé sa yeé par; gwà seèn né ké sòn nòmò koô mân. ");
INSERT INTO mcu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mè yeé ŋgweé aá ménâ, mè tema njií baá-re, ye bɔ́ ndé yílá wèh wò ma. Wò waà baá ndɔ, wò bɔɔ́ huɔm aá dé gècên. Kènê béh dɔɔ́ŋ, béh baá gi ká toò Càŋ, te béh ŋgweé njií mé à nde né béh sònò yeè tueé keéh.» ");
INSERT INTO mcu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kɔ̀rnê yeé tueé gi aá mân, Piêr deên ye bú a: «Kènê mè kɔ baá ye né gècên, Càŋ nùàr lòù gèì bèh. ");
INSERT INTO mcu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sâ tueé né ye, nùà gècên mé né Càŋ dula, né mene lè lò dé heè dɔɔ́ŋ, né gi beè Càŋ dilí huɔɔ́m. ");
INSERT INTO mcu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tebé mé Càŋ lé tema njií naâ mé bɔ̀ huaán *Iserálà, bí né gi kɔɔ́. Né Njàgà Bagaà, né béh dɔlê beè Yeésò *Kristò haá keéh. Nùà Dueè felè njèh dɔɔ́ŋ né lom bú. ");
INSERT INTO mcu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","«Njií mé lé bɔɔ́ giì naâ lè tàbè Judê dɔɔ́ŋ bí né gi kɔɔ́, lé duɔɔ́m naâ ké Galilê, sâ Jâŋ tueé gi aá bɔ̀ nùàr ŋgòr Càŋ kèn, à bɔ́ nòmò Càŋ kou gi aá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gèh dé mé Càŋ lé fam njií naâ Cúcuí Ŋagâ felè Yeésò Nùà Najarêt, bí kɔ gi aá kèn. Yeésò lé naâ lò dɔɔ́ŋ beè yɔŋ sie, à né bagaà bɔɔ́ bele. Bɔ̀ɔ́ mé lé baá giì ka *Sátàn dɔɔ́ŋ, à né bɔ́ taré sɔm bele. Càŋ lé naâ mé bú, à lé naâ bú terreb haá, bí né gi ménâ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Mè tueé bí, béh né sòn seèn; njií mé à lé bɔɔ́ naâ ké Jerusalem mé lè tàbè bɔ̀ Jûf mene dɔɔ́ŋ, béh lé naá giì mé njolo ŋené. Bɔ́ lé naâ bú te toû fagá wulá. ");
INSERT INTO mcu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Càŋ mé ŋgeér sam. Yeé baá cieé tagár, à komo sɔm cuù bú lè cio, à ŋené sɔm keéh bú toò bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Dèn cú toò nùàr dɔɔ̂ŋ ndɔ, à bú ŋené sɔm keéh lom aá toò beèh. Lòù sam, à lé naá giì béh balé kwaá, ye béh né bɔ̀ sòn nyî. Béh bɔ́ yieé bilí cu, béh ŋueé cu bècénè faá bèh jomò nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","«À béh hên temà naâ kɔɔ́, ye béh ndé ŋgòr nyî bèh dɔɔ́ŋ tueé, béh té càm, béh júée bɔ̀ nùàr a: Càŋ sie kwaá baá nyí nùà téná-juù felè bɔ̀ làŋ bɔ̀ mé bɔ̀ komó mene ma. ");
INSERT INTO mcu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bɔ̀ *sòn-Càŋ bɔ̀ dɔɔ́ŋ lé naá giì felè seèn ménâ tueé ndɔ, ye nuaá mé né temé cén mé bú kwaá njií dɔɔ́ŋ, Càŋ nde né nùà sâ veên yoòr mé yilí seèn kulú sɔm ma.» ");
INSERT INTO mcu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piêr yeé baá sònò ménâ tueé, bɔ̀ɔ́ mé né ŋgòr seèn ŋgweé dɔɔ́ŋ, Cúcuí Ŋagâ ka suagà felè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Sâ bɔ̀ Yeésò bɔ̀ mé njií lɔɔ̀ naâ Piêr né bɔ̀ Jûf, bɔ́ né gi doó. Bɔ́ yeé ŋene bɔ̀ɔ́ mé Jûf sam kwa gi aá Cúcuí Ŋagâ ndɔ, geí yɔgɔ́ bɔ́ dé tueê. ");
INSERT INTO mcu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Lòù sam, Càŋ lé naâ bɔ̀ɔ́ mé Jûf sam doô leba bele seér. Bɔ̀ Jûf yeé ŋgweé, bɔ́ baá ju hihiné tueé, bɔ́ né terreb Càŋ mé njéh seén. Piêr yeé ŋene aá ménâ, à ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Kènê bɔ̀ nùàr hên Cúcuí Ŋagâ faá béh nɔ kwa gi aá kèn. Neì bɔ́ nòmò Càŋ koù yiín né kɔɔ́ wa?» ");
INSERT INTO mcu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jomo sâ ye, bɔ́ ndé kòù bɔ́ mé yilí Yeésò *Kristò koù. Yeé gi aá, bɔ́ ye Piêr a, sâ kɔ bɔ́ bɔ́ cer weh teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bɔ̀ mbɔ̀ŋ tebê mé bɔ̀ Yeésò bɔ̀ déì ké Judê ŋgweé njií ndɔ, ye bɔ̀ɔ́ mé *Jûf sam baá ŋgòr Càŋ gwaán. ");
INSERT INTO mcu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piêr yeé cu cuù aá ké Jerusalem, bɔ̀ Yeésò bɔ̀ nde bú. Bɔ̀ sâ bɔ̀ lé naâ bɔ̀ Jûf. ");
INSERT INTO mcu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bɔ́ ye bú a: «Lé seèn bɔɔ́ naâ naàn mé wò nde ké lètenè bɔ̀ kurû, bí bɔ́ yieé bilí wa!» ");
INSERT INTO mcu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piêr se bele bɔ́ kwɔ̀m ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Sâ mè né ké Jopê Càŋ dua den, kulu mè faá vuú nɔ, mè ŋene tàmbàŋ njeré déì faá cɔ̀gɔ̀ nɔ, baá ter segé suagâ, bɔ́ sie né bèh nèà te gou te gou. Yeé waà, njebá le. ");
INSERT INTO mcu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mè ke nyegé yí lè, né bɔ̀ nyam feh hihiné, mé bɔ̀ sàb bɔ́ bɔ̀ non. ");
INSERT INTO mcu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hueh déì né tueé ye mè a: Wùò ter Piêr, wúlá yíé bɔ́ wulà ma. ");
INSERT INTO mcu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mè ye bú a: Sam, Nùà Dueè! Mè gèh dé sâ yíé bèh, né yilísé, mè nde né mé njéh fulá. ");
INSERT INTO mcu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hueh doô tueé cu ké te vulúu, ye mè a: Té njií mé Càŋ ye né ŋagásé jìnè; té túé ye nyí nde né mé njéh fulá. ");
INSERT INTO mcu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yeé waà baá mbei tagár, cɔ̀gɔ̀ hèllè ŋaá yuo cu ké te vulúu. ");
INSERT INTO mcu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Sâ nùà tagár la baá mè tùtúlù gwà njebá den ndɔ, bɔ́ yuoó naâ ké Sesarê, bɔ́ tema njií naâ bɔ́ yoòr mò, bɔ́ ndeè mè yilá weh. ");
INSERT INTO mcu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Cúcuí Ŋagâ tueé naâ kɔɔ́, ye mè a: Béh bɔ́ ndé beèh ndeè, té njeré déì mùnò ma. Bɔ̀ Yeésò bɔ̀ ténjén hên njií lɔ mè ndɔ. Béh bɔ́ wa ké teèn, béh yila nde gi gwò Kɔ̀rnê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","À se bele béh dé mé cìlì Càŋ lé naâ bú gwò yilá kwa, ye bú a: Témá njí nùàr ké Jopê yoòr Simɔ̂ŋ, yilí seèn déì né cu Piêr, te bɔ́ yilá njiî bú ká yoòr yeè. ");
INSERT INTO mcu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","À tueé nde né wò ŋgòr mé nde né wò yili sɔm, te yili sɔm mé mbàgà yeè mene dɔɔ́ŋ ma. ");
INSERT INTO mcu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Mè yeé ŋgweé aá sònò Kɔ̀rnê ménâ, mè yila ŋgòr Càŋ tueê ndɔ. Tètèì sam Cúcuí Ŋagâ ka suagà felè bɔɔ̀n, faá lé ka suagà naâ felè beèh ké bèh duɔɔ̂m nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mè munó kɔ cu baá-re dé mé Fehtoò beèh lé ye: Jâŋ lé bɔ̀ nùàr kou kwaá naâ mé nòmò; dé biì, bɔ́ bí kou seér nde né mé Cúcuí Ŋagâ.» ");
INSERT INTO mcu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Piêr den cuù, ye bɔ́ a: «Mè yeé ŋene Càŋ bɔ́ Cúcuí seèn haá né mé temé yoòr Yeésò *Kristò Fehtoò beèh kwaá njiî faá à lé naâ béh haá nɔ, sâ mè né neì, mé nde né sòn Càŋ ŋgeén wa?» ");
INSERT INTO mcu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bɔ́ yeé ŋgweé aá mân, temé bɔɔ̀n die lè ndɔ, bɔ́ yila Càŋ seên, ye: «Càŋ haá taré baá bɔ̀ɔ́ mé Jûf sam terreb ndɔ, te bɔ́ kweéh seér temé, bɔ́ kwa yɔ̀ŋ tètàgà.» ");
INSERT INTO mcu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bùnò mé lé yuoó naâ lè cu mé bɔ́ lé wulà naâ Etiên teèn hèllè lé naâ bɔ̀ Yeésò bɔ̀ bɔɔ́ ŋellé sɔm. Bɔ̀ déì dula nde Fenisî, bɔ̀ déì nde Sîpre, bɔ̀ déì nde ké Antiôs. Bɔ́ ŋgòr Càŋ tueé njií lom aá mé bɔ̀ Jûf. ");
INSERT INTO mcu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lè cu sâ ndɔ, bɔ̀ mbɔ̀ŋ dé Sîpre mé bɔ̀ dé Sirên nde ké Antiôs, bɔ́ né mé bɔ̀ Greêk tueé njií ndɔ, bɔ́ né bɔ́ Njàgà Bagaà felè Yeésò Fehtoò beèh tueé. ");
INSERT INTO mcu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Càŋ lé naâ be teèn mé terreb mene kwaá njií, nùàr ŋgún kweéh seér gi, bɔ́ kwaá njií temé yoòr Fehtoò beèh. ");
INSERT INTO mcu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Bɔ̀ Yeésò bɔ̀ ké Jerusalem yeé ŋgweé aá ménâ, bɔ́ tema njií Bàrnàbâs ké Antiôs ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","À wa ké teèn, à ŋene gèh dé mé Càŋ né bɔ̀ Yeésò bɔ̀ kulú, temé samé lom bú lè dé gècên, à toó nyegé cu bɔ́, ye bɔ́ a: «Bí dèn lòm beè Fehtoò beèh nɔɔ́ŋ, bí dèn táré tég.» ");
INSERT INTO mcu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Sâ Bàrnàbâs toò naá giì nùà húɔ́m-temé ndɔ, temé seèn dɔɔ́ŋ né gi yoòr Yeésò, Cúcuí Ŋagâ né bú yoòr ŋgulí faá cí nɔ. À né ŋgòr Càŋ se. Yeé baá ménâ, nùàr ŋgún sagá yila cu lè mɔ̀gɔ̀ bɔ̀ Yeésò bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jomo sâ Bàrnàbâs nde ké Târse, à nde Sɔ̂l fɔɔ́n. ");
INSERT INTO mcu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","À yeé ŋene aá bú, à weh njií bú ké Antiôs. Bɔ́ bú fà dɔɔ́ŋ cer ké teèn gùm nyèmà. Bɔ́ né seé te mbàgà Càŋe bɔɔ́, bɔ́ né bɔ̀ nùàr ŋgún njèh feh bele. Bɔ̀ nùàr lé bɔ̀ mbɔ̀ŋ Yeésò «bɔ̀ *Kristò bɔ̀” yilá lɔgɔ́ naâ ké Antiôs sâ. ");
INSERT INTO mcu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Cu sâ bɔ̀ *sòn-Càŋ bɔ̀ déì lé naâ ké Jerusalem yuo, bɔ́ nde ké Antiôs. ");
INSERT INTO mcu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yilí cén déì lètenè bɔɔ̀n lé naâ Àgàbùs. Cúcuí Ŋagâ kema bú, à wuo ter, ye bɔ̀ nùàr a: «Cùè nde né wɔ́ŋ dɔɔ́ŋ die ma.» Cùè sâ lé naâ môn die ndɔ. Lé naâ te nàm mgbè Klôdè. ");
INSERT INTO mcu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Àgàbùs yeé tueé aá ménâ, bɔ̀ mbɔ̀ŋ bilí sòn lètenè bɔɔ̀n, ye njií mé nùà kàn né beè kwa keéh dɔɔ́ŋ, bú a, há njiî, te bɔ́ gam njií bɔ̀ Yeésò bɔ̀ dé ké Judê mé njéh ma. ");
INSERT INTO mcu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bɔ́ lé naá giì ménâ bɔɔ́ ndɔ, bɔ́ tema keéh baá-re beè Bàrnàbâs bɔ̂ Sɔ̂l, bɔ́ nde bɔ̀ kokoô bɔ̀ te mbàgà Càŋe ké Judê haá njií. ");
INSERT INTO mcu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lè cu sâ, mgbè *Herôde yuo die bɔ̀ Yeésò bɔ̀ déì yoòr mé bùnò. ");
INSERT INTO mcu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","À wula sɔm Jâk bei Jâŋ mé bòù. ");
INSERT INTO mcu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","À yeé ke, né bɔ̀ Jûf yoòr huɔɔ́m ménâ, à sie cu Piêr. Lé naâ lè cu *Páskà mé bɔ́ yieé yeé breêd, bɔ́ kulu teèn kwá ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herôde yeé sie aá bú ménâ, à yií bú lè gwà cibì, à weh kaŋ kwaá bú sɔ́jì bɔ̀ŋ nèà kwarè; bɔ̀ŋ cén sɔ́jì né teèn nèà. Bɔ́ né bú mɔɔ́m; ye mɔ Páskà kela baá, te nyí weh njií ye bú ké toò bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Cu mé Piêr lé naâ ké gwà cibì sâ, bɔ̀ Yeésò bɔ̀ lé Càŋ dua loóm naâ mé terreb mene. ");
INSERT INTO mcu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","7","Cieé mé Herôde njií nde aá bú ké toò bɔ̀ nùàr yeé baá faá kwéh nɔ, cíbíteèn sâ, cìlì Fehtoò beèh kar waà ké mí yoòr seèn, ŋagá sie gwà beè. Sâ Piêr baá lɔ́m, à né lètenè bɔ̀ sɔ́jì fà cer den. Bɔ́ kaga né bú be lòù. Sâ bɔ̀ɔ́ mé mɔm yeé gwà cibì né gi tùtúlù ndɔ. Cìlì Càŋ doô yeé waà baá, à kema Piêr kwar, à nyimé sɔm bú, ye bú a: «Wùò ter kwar.» Lɔ̀ŋ tené yuo bú be ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ye Piêr a: «Cóló njí kàndá yeè teneè, yí njí débágá gulè.» Piêr bɔɔ́ ménâ. Ye Piêr a: «Sù cɔ̀gɔ̀ dùlù yeè, béh nde, bèlè mè.» ");
INSERT INTO mcu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piêr ndaŋ bele bú, à kɔ́ ŋgwéh ye né dé gècên, ye merré déì vuú kulu né nyí kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bɔ́ kela keéh kɔ̀ŋ fà, mé bɔ̀ sɔ́jì né gi tùtúlù, bɔ́ wa lè hin déì, à sòn keéh njií né ké lɔ, né hin lɔ̀ŋ. Dé sâ komo weh ké toò bɔɔ̀n mé be seèn mbaá, bɔ́ yuo kela nde yí ceér dueè. Cìlì Càŋ kwaá lɔ bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Njolo yeé ŋagá baá bú, à ye: «Kènê mè ŋene kɔ baá ye né bɔ̀n, Fehtoò beèh naâ cìlì seèn ká yoòr mò temá njiî, à bú tema njií naâ, te à ndeè mè beè *Herôde se sɔm, te bɔ̀ Jûf kwè mò sén kwà cú.» ");
INSERT INTO mcu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","À yeé ŋgweé nyegé aá ménâ, à nde ké gwò Marî meì Jâŋ. Jâŋ sâ, yilí seèn déì né cu Mârk. Sâ, bɔ̀ nùàr né ké teèn ŋgún bilí den, bɔ́ né Càŋ dua. ");
INSERT INTO mcu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piêr waà, à gɔ hin ndɔ. Nùà seê dé vêh déì né teèn, yilí seèn né Rôdè, à nde yí tùtúlù gwà bèh hin guluù. ");
INSERT INTO mcu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","À yeé nde ŋgweé kèb cieè né hueh Piêr mân, vràb sela seér bú lòù, à lɔɔ̀ Piêr hin gulu keêh, à cu cu seér yí jomo bɔ̀ nùàr gwà dɔɔ́ŋ tueé wellê, ye bɔ́ a: «Piêr baá gè cie ma.» ");
INSERT INTO mcu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bɔ́ su bú sòn yoòr, bɔ́ ye bú a: «Wò né nùà kùlù wee!» À né teèn ŋgelá, ye bɔ́ a: «Né ka bú.» Bɔ́ den cuù, ye bú a: «Sâ né càŋ seèn.» ");
INSERT INTO mcu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Cu sâ hin née ka gɔɔ́ den ye. Bɔ́ gulu hin ndɔ, bɔ́ ŋene né ka Piêr bɔ̀n, geí laré bɔ́ gwà dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","À me njií bɔ́ mé be, ye bɔ́ a, bí húné nɔɔ́ŋ. À se bɔ́ gèh dé mé Fehtoò beèh la naâ bú lè gwà cibì sɔm keéh. Jomo sâ, ye bɔ́ a, bɔ́ túé kéh Jâk mé bɔ̀ déì ménâ ma. À yuo kela ndɔ, à nde ser toò. ");
INSERT INTO mcu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cieé yeé ŋaga baá, bèmè tarê mân kɔ die lètenè bɔ̀ sɔ́jì, bɔ́ munó kuú njií mé Piêr la naâ ŋaá seér, bɔ́ kwà ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","*Herôde ye, bɔ́ fɔ́n bú fɔɔ̀n. Bɔ́ fɔɔ́n kuú mene, bɔ́ bú kwà ŋgwéh ndɔ. À ye, bɔ́ bíé bɔ̀ sɔ́jì cécéné cécéné ma. À bie le mé bɔ́, ye wúlá bɔ́ wulà. Jomo sâ, à yuo ké Judê, à fɔɔ́n gò Sesarê ndɔ, à nde cer den ŋgɔgɔ́ ké sâ. ");
INSERT INTO mcu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herôde bar lom bɔ̀ Tîr bɔ̀, mé bɔ̀ Sídɔ̀ŋ bɔ̀ dé ndùàn. Yeé baá ménâ, bɔ́ kwaá sòn, bɔ́ nde sie gule nuaá mé ke yeé gwà cèrrè Herôde. Yilí nùà sâ né Blasta. Bɔ́ ye te bɔ́ bɔ́ nde ké yoòr Herôde, bɔ́ dua bú dɔlê lètenè bɔɔ̀n bɔ́bɔ̂ ma. Lòù sam, yáb bɔɔ̀n yuo yeé te tàbè seèn. ");
INSERT INTO mcu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Cieé mé bɔ́ lé sie kwaá naâ sâ yeé waà baá, Herôde su cɔ̀gɔ̀ mgbè seèn, à ŋaá den te kɔgɔ, à yila bɔ́ ndeè, à nde bɔ́ faá nùà koô nde yeé nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bɔ́ bɔm bú ye: «Dé hên hueh nùàr sam cuú, né hueh Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tètèì sam, cìlì Càŋ Dueè suagà ter, si bú ŋgwagán, sòn mé à la meé naâ Càŋ doô, à kuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ŋgòr Càŋ dé seén kɔ lom né bèh dɔɔ́ŋ yaám ndeê. ");
INSERT INTO mcu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bàrnàbâs bɔ̂ Sɔ̂l yeé bɔɔ́ sɔm aá seé bɔɔ̀n ké Jerusalem, bɔ́ fɔɔ́n gò, bɔ́ cu cu jomo, bɔ́ weh sie Jâŋ mé bɔ́ yilá cu né Mârk beè. ");
INSERT INTO mcu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bɔ̀ *sòn-Càŋ bɔ̀ mé bɔ̀ fèh-njèh bɔ̀ lé naâ lè bɔ̀ŋ bɔ̀ Yeésò bɔ̀ ké Antiôs teèn. Lé naâ bɔ̀ Bàrnàbâs mé Simeɔ̂ŋ; bɔ́ bú yilá né Nùà Yilî. Lùsiûs nùà Sirên lé naâ teèn ndɔ, bɔ̂ Manahên. Dé seèn, bɔ̂ mgbè *Herôde lé kulà naâ bècénè. Sɔ̂l lé naâ teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Cieé déì, bɔ́ yeé baá Càŋ dua, bɔ́ né yáb jolo, Cúcuí Ŋagâ ye bɔ́ a: «Bí sɔ̀m kwá Bàrnàbâs bɔ̂ Sɔ̂l hiín, mè né bɔ́ mé seé déì yilá.» ");
INSERT INTO mcu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bɔ́ yeé ŋgweé aá ménâ, bɔ́ jolo cu yáb, bɔ́ dua Càŋ, bɔ́ ba bɔ́ be felè, bɔ́ yi njií bɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Cúcuí Ŋagâ yeé tema njií aá Bàrnàbâs bɔ̂ Sɔ̂l ménâ, bɔ́ nde baá-re ké Selusî. Bɔ́ weh sie Jáŋ-Mârk jomò, te à nde gam bɔ́. Bɔ́ wa ké teèn, bɔ́ yila bàtô, bɔ́ nde lè tàbè Sîpre; tàbè sâ tena le né yí lètenè nòmò. Bɔ́ wa lè lɔɔ́ déì, yilí seèn né Sàlàmínà, bɔ́ yila ŋgòr Càŋ te gwà sóù bɔ̀ *Jûf seè. ");
INSERT INTO mcu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jomo sâ bɔ́ kela keéh lɔɔ́ sâ, bɔ́ yuo kela ké Pafôs. Bɔ́ wa teèn, bɔ́ kwa nùà táhunò déì, yilí seèn né Bar-Yeésò, né nùà Jûf, à né bɔ̀ nùàr bele den, wa nyí né sòn-Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Dene seèn lé naá loôm kwarè ŋgɔ́mnà Serjíù Polûs. Ŋgɔ́mnà sâ lé naâ mé feh teèn. À yeé ŋgweé aá njàgà Bàrnàbâs bɔ̂ Sɔ̂l, à yilá njiî bɔ́ ká toò seèn bèh ŋgòr Càŋ ŋgweê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nùà táhunò hèllè, yilí seèn lè ju lɔɔ̂ bɔɔ̀n né Elímà, à yeé ŋene aá ménâ, à furú kuú mé sà, à né kèkènè déì bɔɔ́, te ŋgɔ́mnà temé te ŋgòr Càŋe kwá njí cú. ");
INSERT INTO mcu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sâ Sɔ̂l mé yilí déì né cu Pɔ̂l, lé naâ mé terreb Cúcuí Ŋagâ yoòr, à yila nùà doô njolò ke njegeè, ");
INSERT INTO mcu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ye bú a: «Mè jue né wò ŋunà *Sátàn, wò bɔ̀ nùàr bele wula gi né kɔɔ́, nùà bùnò bɔ̀ gècên bɔ̀ né wò, nùàr veên. Wò nde né mé bɔ̀ njèh Fehtoò beèh ménâ bɔɔ́ gobó ndeé den wa? ");
INSERT INTO mcu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mè tueé wò, kènê Fehtoò beèh nde né wò lobo cugó sɔm, wò njolo loù ŋéné ndé cú, kɔ ndeè baá cu déì.» Njolo Elímà nyimé yuo ndɔ. À duɔɔ̂m lòù bobô, à né nùàr fɔɔ́n te derré bú be. ");
INSERT INTO mcu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ŋgɔ́mnà yeé ŋene aá ménâ, à kwaá njií temé yoòr Fehtoò beèh. Lòù sam, njií mé bɔ́ la naá giì bú mé yilí Fehtoò beèh tueé dɔɔ́ŋ naâ bú hiím yɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔ̂l bɔ́ bɔ̀ mbaábɔn yila cu bàtô, bɔ́ yuo Pafôs, bɔ́ nde ké Pêrgè te tàbè Pamfilî. Bɔ́ wa ké teèn, Jáŋ-Mârk si lɔ bɔ́ ké sâ, à cu cu dé seèn ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bɔ́ yuo cu Pêrgè, bɔ́ nde Antiôs lè tàbè Pisidî. Yeé baá mé *cieé sóù, bɔ́ yila nde ké gwà sóù, bɔ́ den nde doó nɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bɔ̀ nùàr né mvù *sóú Músì jaŋé, bɔ́ né dé bɔ̀ *sòn-Càŋ bɔ̀ jaŋé. Bɔ́ yeé jaŋé weh aá, bɔ̀ kokoô bɔ̀ gwà sóù bie njií, ye bɔ̀ Pɔ̂l a: «Beè biì njèh tueê né teèn wa, bí gàm bɔ̀ nùàr mé njéh teèn, te yo taré bɔ́ tarè.» ");
INSERT INTO mcu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔ̂l komo wuo ter ndɔ, à fɔ njií be ter, ye bɔ́ a: «Bí bɔ̀ *Iserálà bɔ̀, mé bɔ̀ dùlà-Càŋ bɔ̀ déì dɔɔ́ŋ, bí ndɔ̀gɔ̀ tie. ");
INSERT INTO mcu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Béh bɔ̀ Iserálà bɔ̀ dɔɔ́ŋ, Tele beèh Càŋ lé naâ bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh balé sɔm, à bɔɔ́ yam bɔ́ ké Ejíptò, sâ bɔ́ ké sâ né kìn. Nde nde, à sɔm cu bɔ́ ké teèn mé be terrèb seèn. ");
INSERT INTO mcu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mé njéh mene, à nde yolo sɔɔ́ bɔ́ ké ya dueè nyèmà yulà nèà. ");
INSERT INTO mcu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","«Jomo sâ à kum sɔm ndugo téhbeh te tàbè Kanahân felè bɔɔ̀n, te bɔ́ cer keéh. ");
INSERT INTO mcu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Bɔ̀ njií sâ dɔɔ́ŋ lé naâ nyèmà yuií nèà mé yulà tîn bɔɔ́, te jomo sâ à sie sɔm ye bɔ́ bɔ̀ téná-juù bɔ̀ teèn. Bɔ́ bɔɔ́ nde den ka mé njéh ménâ, tɔ́g nde yuo kela lè nàm Samuel sòn-Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Yeé wa baá te nàm Samuel, bɔ́ ye Càŋ a, há sér bɔ́ mgbè. Càŋ haá bɔ́ Sàwúlù ŋunà Kîs ndɔ; né bɔ̀ gèh Benjamên. Sàwúlù bɔɔ́ te kɔgɔ nyèmà yulà nèà. ");
INSERT INTO mcu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Càŋ yeé sɔm si njií aá bú doó, à haá keéh cu kɔgɔ mé *Davîd. À tueé kwaá bɔ̀ nùàr dene Davîd tieè ndɔ, ye bɔ́ a: Nyí ŋene Davîd ŋunà Jésè né nyí yoòr yilá, à nde né sòn nyî ŋgweé ma.» ");
INSERT INTO mcu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pɔ̂l den cuù, ye bɔ́ a: «Mè tueé bí, *ndùté ndùtù Davîd déì né Yeésò. Càŋ lé naâ bú Nùà dueè bɔ̀ Iserálà bɔ̀ sie kwaá, te à yili sɔm bɔ́. Né faá à lé naá giì bɔ́ tueé kwaá nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mé Yeésò ndeè waà, sâ Jâŋ baá bɔ̀ huaán Iserálà dɔɔ́ŋ tueé ye bɔ́ a, kwéh sér temé kweèh, te bɔ́ weh nòmò Càŋ ma. ");
INSERT INTO mcu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jâŋ yeé nde aá seé bɔɔ́ gií, à ye bɔ̀ nùàr a: Bí ye nyí né neì wa? Nyí tueé bí, nyí nuaá mé bí né kela den doô sam. À dé seèn baá jomo nyî ndeê, à né nyí mé terreb yɔgɔ́. Nyí wúlú ŋgwéh nuaá mé nde né bú débágá gulè sɔm.» ");
INSERT INTO mcu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pɔ̂l yeé tueé sɔm aá dé sâ, à den cuù ye bɔ́ a: «Bɔ̀ nùàr mò, né mene bí bɔ̀ ndùté ndùtù Abrahâm, né mene bí bɔ̀ dùlà-Càŋ bɔ̀ déì, bɔ́ ŋgòr hên tema njií kuú né felè beèh dɔɔ́ŋ, te yili sɔm béh. ");
INSERT INTO mcu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mé njéh mene, bɔ̀ Jerusalem bɔ̀ mé bɔ̀ kokoô bɔ̀ bɔɔ̀n mene lé ndègè Yeésò ŋéné kɔ́ ná ŋgwêh. Mé *cieé sóù dé kàn bɔ́ né mene felè seèn lè mvù bɔ̀ sòn-Càŋ bɔ̀ jaŋé, dɔɔ́ŋ né gi beè bɔɔ̀n ndúg. Mé njéh mene, bɔ́ yeé sií njií aá bú ju yoòr, mboón ye faá bɔ̀ sòn-Càŋ bɔ̀ lé naá giì tueé nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bɔ́ mene bú mé kwɔ̀m cioò yoòr ŋéné ŋgwéh, bɔ́ ye *Pilátò a, wúlá lòm bú wulà. ");
INSERT INTO mcu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bɔ̀ njií mé ŋgòr Càŋ tueé gi né felè seèn yeé mboón gi aá, bɔ́ mvualé sɔm ye bú te toú fagâ, bɔ́ nde jɔgɔ furu sɔm bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Càŋ mé ŋgeér sam, à yeé kuú aá, Càŋ komo sɔm cu bú lè cio. ");
INSERT INTO mcu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","À bɔɔ́ cu ká lè wɔ́ŋe cieé kɔ́beè, à dé sâ ŋené yuo kela lom aá njolò bɔ̀ mbɔ̀ŋ seèn. Bɔ̀ sòn seèn kènê né bɔ́. Bɔ́ bɔ̀ sâ bɔ̀ lé yuoó naâ Galilê kɔɔ́, bɔ́ njií lɔ bú ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Béh hên nde kuú naâ bí Njàgà Bagaà sâ tueé ndɔ. Béh tueé bí, ndéb mé Càŋ lé tueé lɔɔ̀ naâ mé bɔ̀ jɔ̀gɔ̀ bɔ̀ beèh dɔɔ́ŋ ");
INSERT INTO mcu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kènê mboón aá ká lètenè beèh, béh bɔ̀ ndùté ndùtù bɔɔ̀n. Càŋ lé naâ Yeésò te cio komo sɔm cu, faá bɔ́ lé nyagá kwaá naâ lè mvù bene *Davîd kɔ̀b fà nɔ, ye: Wò né Huaán mò, lan mè baá Tele yeè.» ");
INSERT INTO mcu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pɔ̂l den cuù ye bɔ́ a: «Càŋ lé ye, nyí nde né bú dé seèn te cio komo sɔm, te à dé seèn tàbè ŋá cú. À lé naá giì ménâ tueé ye: Njií mé nyí lé naá mé Davîd tueé kwaá, nyí nde né bí mé njéh kulú ŋagá nyegé. ");
INSERT INTO mcu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Davîd beré déì tueé cu né ménâ ndɔ, ye: Wò ndeè yeè gwàn ndé ŋgwéh dé nùàr yeè fɔ le dòù. ");
INSERT INTO mcu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Á sâ, Davîd lé bɔɔ́ naá kaà te nàm dé seèn sâ faá Càŋ gwaán nê ndɔ. Mé njéh mene, à kuú, bɔ́ furu yií bú lè sà mé bɔ́ lé furú naâ bɔ̀ tele seèn léí jɔ̀gɔ̀ teèn, à ŋa dé seèn tàbè. ");
INSERT INTO mcu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Dé nuaá mé Càŋ lé naâ lè cio komo sɔm, môn sam, à lé dé seèn lòù fɔ̀ ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Sâ bɔ̀ nùàr mò, bí kɔ́ɔ ye, Càŋ bí veên yoòr kulu sɔm lom nde né mé yilí nùà bú sâ. Né Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Bí kɔ́ cú kɔɔ̀ ye, bɔ̀ɔ́ mé né temé yoòr seèn kwaá njií dɔɔ́ŋ yili yuo nde né mé bú, dèn ŋgwéh mé *sóú Músì. Lòù sam, sóú Músì dé seèn nùàr yìlì kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Sâ bí bɔ̀ŋ feh biì. Mɔ sam, njií mé bɔ̀ sòn-Càŋ bɔ̀ lé naâ toò nyagá kwaá doô nde né bí kwa; bɔ́ lé ye: ");
INSERT INTO mcu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ménâ, bí kè fàŋ dèn mé njolo, bí bɔ̀ sèb-nùàr bɔ̀. Bú a, hím lɔ́ bí lòù, bí ŋéllé yùò ŋellè ndɔ! Te cafanê nyí Càŋ bɔɔ́ mboón seé nyî, seé mé bɔ́ sé tueé kuú mene bí, bí sé biì gwàn ná ŋgwêh doô.» ");
INSERT INTO mcu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔ̂l bɔ̂ Bàrnàbâs tueé gi ndɔ. Bɔ́ yeé baá cie yuo kelá, bɔ̀ gwà-sóù bɔ̀ bɔŋ bɔ́, ye bɔ́ a: «Bí cú cû mé sóú dé toò hên, te bí tueé ferré cu béh.» ");
INSERT INTO mcu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jomo bilî sâ, bɔ̀ *Jûf mé bɔ̀ɔ́ mé ŋa né Jûf lòù kókoó mbaá bele gi Pɔ̂l bɔ̂ Bàrnàbâs. Pɔ̂l bɔ̂ Bàrnàbâs né bɔ̀ nùàr tueé nyegé, te bɔ́ kuú nde den mé fùgò beè Càŋ tetoò. ");
INSERT INTO mcu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sóú sâ yeé waà baá, nùàr lɔɔ́ dɔɔ́ŋ kem waà ndɔ, bɔ́ bilí ndeè ŋgòr Càŋ ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bɔ̀ Jûf yeé nde ŋene njií cìlì nùàr ménâ, sà ŋaâ bɔ́ lè. Bɔ́ duɔɔ́m bɔ̀ njèh sònò Pɔ̂l tueé vurú beleè, bɔ́ né bú selé. ");
INSERT INTO mcu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔ̂l bɔ̂ Bàrnàbâs né lom tég te ŋgòr Càŋe njebá taré, bɔ́ ye bɔ̀ Jûf a: «Njua mé béh lé ŋgòr Càŋ duɔɔ́m naâ ká lètenè biì, te bí ŋgweé lɔgɔ̂ kɔɔ́. Mɔ bí né lòù berɔ́ŋ seér, ye bí yɔ̀ŋ tètàgà beè Càŋ gwàn ŋgwéh, wa bí wúlú ŋgwéh, sâ béh mé njéh nde ser nde aá yoòr bɔ̀ɔ́ mé Jûf sam, ");
INSERT INTO mcu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","te den faá Nùà Dueè naá giì béh tueé nɔ, à lé ye: Nyí lé naâ wò toò bɔ̀ɔ́ mé Jûf sam sie kwaá, te wò den faá ŋagâ nɔ, wò ŋagá nde mé njéh bèh dɔɔ́ŋ, te bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ yili yuo.» ");
INSERT INTO mcu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bɔ̀ɔ́ mé Jûf sam yeé nde ŋgweé njií mân, bɔ́ samé ŋellé doó dɔɔ́ŋ, bɔ́ né ŋgòr Fehtoò beèh seén. Bɔ̀ɔ́ mé Càŋ lé naâ dé yɔ̀ŋ tètàgà balé kwaá dɔɔ́ŋ kwaá njií gi temé mé Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ŋgòr Càŋ né ka yaám ndeé. Nde nde, laré sie lò sâ beè dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bɔ̀ Jûf yeé ŋene aá ménâ, bɔ́ soób bɔ̀ dùlà-Càŋ bɔ̀ lètenè bɔ̀ véh dé kokoô, mé bɔ̀ njonjolo bɔ̀ lɔ sâ, te bɔ́ bunó Pɔ̂l bɔ̂ Bàrnàbâs. Bɔ́ kwɔgɔ sɔm bɔ́ te tàbè sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔ̂l bɔ̂ Bàrnàbâs yeé baá mé gò, bɔ́ karé sɔm fùfú gulè, bɔ́ fulú njií bɔ́ yoòr, bɔ́ fɔɔ́n gò Ikoniûm. ");
INSERT INTO mcu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bɔ̀ mbɔ̀ŋ le ké Antiôs ndɔ. Sâ bɔ́ baá gi mé Cúcuí Ŋagâ yoòr ŋgulí den, temé lé naâ bɔ́ mé gècên mene vɔgɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔ̂l bɔ̂ Bàrnàbâs wa ké Ikoniûm, bɔ́ yila nde lè *gwà sóù bɔ̀ Jûf, bɔ́ né bɔ̀ nùàr ŋgòr Càŋ tueé. Bɔ̀ Jûf mé bɔ̀ɔ́ mé Jûf sam kókoó mbaá kwaá njií gi temé yoòr Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bɔ̀ dúágá-tie bɔ̀ lètenè bɔ̀ Jûf yeé ŋene aá ménâ, bɔ́ suií njií bɔ̀ɔ́ mé Jûf sam yoòr Pɔ̂l bɔ̂ Bàrnàbâs. ");
INSERT INTO mcu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yeé baá ménâ, Pɔ̂l bɔ̂ Bàrnàbâs cer ŋeí seér cu ké Ikoniûm lòù, bɔ́ né te ŋgòr Fehtoò beèh tég njebá taré, ye bɔ̀ nùàr a, Càŋ bɔ̀ nùàr yili sɔm yeé dé lòù. Fehtoò beèh lé naâ bɔ́ terreb haá, bɔ́ né bɔ̀ fém mé cìè teèn bɔɔ́ yií, te bɔ̀ nùàr ŋene kɔ mé njéh ye né ŋgòr gècên. ");
INSERT INTO mcu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yeé baá ménâ, lɔɔ́ ker fà: bɔ̀ déì bele bɔ̀ Jûf, bɔ̀ déì jomo bɔ̀ mbɔ̀ŋ tebê. ");
INSERT INTO mcu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jomo sâ, bɔ̀ Jûf mé bɔ̀ɔ́ mé Jûf sam bɔ́ bɔ̀ mgbè bɔɔ̀n dɔɔ́ŋ kaga taáb, te bɔ́ nde Pɔ̂l bɔ̂ Bàrnàbâs tɔbé wulá. ");
INSERT INTO mcu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bɔ́ yeé ŋgweé aá ménâ, bɔ́ dula leér nde ser te tàbè Likonî, lè lɔɔ́ Lîstrè mé Dérbè. Bɔ́ né kè kèbè ndeé bele, ");
INSERT INTO mcu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","bɔ́ se Njàgà Bagaà teèn. ");
INSERT INTO mcu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ké Lîstrè sâ, nuaré déì lé naâ teèn, gule né kuú, à lé mé njéh yuoó naâ lè, à gò gɔ̀ ŋgúŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nùà hèllè yeé ŋene Pɔ̂l baá njèh tueé, à felá njií tie teèn. Pɔ̂l né ka bú njolò ke njege den, à ŋene kɔ ye, nùà hên né temé te ŋgòr nyî kwaá njií te taré sɔm bú. ");
INSERT INTO mcu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","À tueé njií mé bú ndɔ, ye bú a: «Kòmò wùò ter, njébá mé gule yeè!» Nùà hèllè lɔ wuo ter kwar, gɔ keéh lom dé gɔɔ̀. ");
INSERT INTO mcu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Te bɔ̀ nùàr yeé nde ŋene njií mé Pɔ̂l bɔɔ́ naâ sâ, bɔ́ si gɔ̀gɔ̀ mé ju lɔɔ̂ bɔɔ̀n Likonî, bɔ́ ye: «Né bɔ̀ càŋ ŋa né nùàr kɔɔ́, bɔ́ suagà ká yoòr beèh.» ");
INSERT INTO mcu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bɔ́ yilá kwaá bɔ́ yilí bɔ̀ càŋ bɔɔ̀n yoòr. Dé Bàrnàbâs, bɔ́ yilá bú *Jeûs; bɔ́ yilá Pɔ̂l *Hermês, ye nùà njèh tueê né bú. ");
INSERT INTO mcu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ŋgàŋ Jeûs lé naâ teèn ndɔ. À yeé ŋene aá ménâ, à sie ndeè mé bɔ̀ tela nàgà mé njèh yàgà yoòr, à waà mé njéh ké tùtúlù bɔ̀gɔ̀ bâŋ, ye te bɔ́ bɔ̀ nùàr ŋɔb haá Bàrnàbâs bɔ̂ Pɔ̂l njèh *sèmè. Sâ mɔ̀ Jeûs hèllè né ké jomo lɔɔ̂ mân. ");
INSERT INTO mcu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bàrnàbâs bɔ̂ Pɔ̂l yeé nde ŋgweé njií mân, temé yulá bɔ́ mé njéh, bɔ́ sie ŋaré bɔ̀ cɔ̀gɔ̀ bɔɔ̀n, bɔ́ ŋar nde ké lètenè bɔ̀ nùàr, bɔ́ né ké ter lɔgɔ́ njií, ye bɔ̀ nùàr a: ");
INSERT INTO mcu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Bí béh mân bɔɔ́ né dé keì wa? Ŋgweéh béh né gi bɔ̀ nùàr faá bí nɔ wa? Béh ndeè naâ bí Njàgà Bagaà tueé, ye bí kwéh sér temé, bí sɔm be yoòr bɔ̀ cècàŋ mân, bí dua seér Càŋ dueè. À dé seèn né làŋ, vulú bɔ̂ tàbè lɔ sií naâ bú; nòmò mé bɔ̀ njèh dɔɔ́ŋ lɔ si giì naâ bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Léí toò, à lé bɔ̀ nùàr mé gèh hihiné kwaá lɔɔ̀ naâ mé feh bɔɔ̀n, gèh dé kàn né càŋ seèn dua. ");
INSERT INTO mcu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mé njéh mene, à né béh feh den, ye nyí né teèn: nyí béh bagaà bɔɔ́ den né kɔɔ́ ma. À né bí nu yi keêh, yab né yaám, dé kàn mé cu seèn, dé kân mé cu seèn, yab né bí beè merré den, bí né mé vɔ́gɔ́-temé mene samé, bí ménâ ŋéné kɔ́ ŋgwéh wa?» ");
INSERT INTO mcu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pɔ̂l né mene ménâ tueé, njií ye bɔ̀ nùàr a, há lòm bɔ́ *sèmè haà. Pɔ̂l bɔ̂ Bàrnàbâs nde bɔ́ lege yiín weéh baá lòù. ");
INSERT INTO mcu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jomo sâ, bɔ̀ Jûf kem yuoô ké Antiôs mé Ikoniûm, bɔ́ waà doó sâ, bɔ́ tueé seér maŋgo, bɔ̀ nùàr gwaán seér cu ŋgòr bɔɔ̀n, bɔ́ tɔbé si Pɔ̂l doó, bɔ́ tulu si njií bú ké jomo bâŋ, ye merré déì kuú baá kèn. ");
INSERT INTO mcu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bɔ̀ Yeésò bɔ̀ yuo bele jomo ndɔ. Bɔ́ yeé baá ké kwarè seèn kaáŋ den, à komo wuo ter, à yila nde cu ké lètenè lɔɔ̂. Cieé ŋaga, bɔ̂ Bàrnàbâs fɔɔ́n gò, bɔ́ nde ké Dérbè. ");
INSERT INTO mcu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔ̂l bɔ̂ Bàrnàbâs wa ké Dérbè, bɔ́ yila cu Njàgà Bagaà seè. Bɔ̀ nùàr kókoó mbaá ŋa gi bɔ̀ mbɔ̀ŋ ké doó sâ. Jomo sâ, bɔ̀ Pɔ̂l cu cu ké Lîstrè, bɔ́ cu cu ké Ikoniûm, mé Antiôs dé Pisidî, ");
INSERT INTO mcu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bɔ́ né bɔ̀ Yeésò bɔ̀ yo bɔɔ́ taré, bɔ́ né bɔ́ toó nyegé, ye bɔ́ a: «Bí dèn lòm te ŋgòr Càŋe tég; gèr né teèn. Béh gèr ŋene nde né feh hihiné, te béh nde ye *Lò Càŋ yilá.» ");
INSERT INTO mcu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bɔ́ wa mene te bɔ̀ŋ bɔ̀ Yeésò bɔ̀ dé kàn, bɔ́ né bɔ̀ nùàr teèn balé kwaá, te bɔ́ den bɔ̀ kokoô bɔ̀; bɔ́ bɔ́ jolo weh yáb, bɔ́ né Càŋ felè bɔɔ̀n dua, te bɔ́ kwaá lɔ bɔ́ beè Càŋ. Bɔ́ ndèm kwaá lom mé bú. ");
INSERT INTO mcu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bɔ́ lé naâ te lɔɔ́ hihiné te tàbè Pisidî kelá bele, bɔ́ yuo kela te tàbè Pamfilî. Bɔ́ yeé wa baá ké teèn, ");
INSERT INTO mcu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","bɔ́ duɔɔ́m cu ŋgòr Càŋ ké Pêrgè tueê. Jomo sâ, bɔ́ nde ké Atalî. ");
INSERT INTO mcu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bɔ́ yila cu bàtô doó sâ, bɔ́ nde Antiôs. Sâ né bèh mé bɔ̀ Yeésò bɔ̀ lé naâ bɔ́ teèn nyeén, bɔ́ kwaá lɔ bɔ́ beè Càŋ, Nùà húɔ́m-temê, te bɔ́ nde bèh seé seèn mé né kènê mboón hên. ");
INSERT INTO mcu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bɔ́ yeé wa baá ké Antiôs, bɔ́ yilá bilí cu bɔ̀ Yeésò bɔ̀, bɔ́ se bɔ́ njií mé Càŋ lé naâ beè bɔɔ̀n bɔɔ́ keéh dɔɔ́ŋ, bɔ́ se bɔ́ gèh dé mé à lé naâ bɔ̀ɔ́ mé Jûf sam ceér gulu keéh ndɔ, bɔ́ ye bɔ́ a, bɔ̀ɔ́ mé Jûf sam lé naâ temé yoòr Yeésò kwaá njií ma. ");
INSERT INTO mcu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bɔ́ bɔ̀ Yeésò bɔ̀ cer yií cu ké sâ kɔ́beè. ");
INSERT INTO mcu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bɔ̀ nuaré déì yuoô ké Judê, bɔ́ waà ké Antiôs, bɔ́ né bɔ̀ Yeésò bɔ̀ njèh feh, ye bɔ́ a: «Mɔ bí *ŋgór ŋɔ́b ŋgwéh, faá *sóú Músì tueé nê nɔ, bí yìlì yùò ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔ̂l bɔ̂ Bàrnàbâs yeé nde ŋgweé njií ménâ, bɔ́ bɔm bɔ́, bɔ́ bɔ́ kwaá njií saân tarê mân doó felè ŋgòr sâ. Yeé baá ménâ, bɔ̀ Yeésò bɔ̀ kaga ndòn ye, Pɔ̂l bɔ̂ Bàrnàbâs mé bɔ̀ mbeí déì nde né ké Jerusalem yoòr bɔ̀ mbɔ̀ŋ tebê mé bɔ̀ kokoô bɔ̀ ŋaá ndeé ma, te bɔ́ nde nyegé ju sâ. ");
INSERT INTO mcu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bɔ́ sɔm njií bɔ́ ndɔ. Bɔ́ né te tàbè Fenisî mé *Samarî kelá, bɔ́ né bɔ̀ nùàr saán gɔ, ye bɔ́ a, bɔ̀ɔ́ mé Jûf sam kènê baá ceér Càŋ bele ma. Bɔ̀ Yeésò bɔ̀ yeé ŋgweé aá ménâ, nɔré lom bɔ́ yoòr dé gècên. ");
INSERT INTO mcu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bɔ́ wa Jerusalem. Bɔ̀ mbɔ̀ŋ tebê bɔ́ bɔ̀ kokoô bɔ̀ mé bɔ̀ Yeésò bɔ̀ dɔɔ́ŋ vra weh bɔ́ ndɔ. Jomo sâ, bɔ̀ Pɔ̂l se bele bɔ́ bɔ̀ njií mé Càŋ lé naâ mé bɔ́ bɔɔ́ keéh dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bɔ̀ Yeésò bɔ̀ déì lètenè bɔ̀ *Farisiên yeé ŋgweé aá ménâ, bɔ́ komo wuo seér cu ter, bɔ́ ye: Ndɔ́g, bɔ̀ɔ́ mé Jûf sam, kɔ bɔ́ ŋɔb bɔ́ ŋgór ŋɔɔ̀b, bɔ́ taga cu bɔ́ sóú Músì ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bɔ̀ mbɔ̀ŋ tebê mé bɔ̀ kokoô bɔ̀ bilí, te bɔ́ taáŋ nyegé ŋgòr sâ. ");
INSERT INTO mcu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bɔ́ yeé baá saán taré, Piêr komo wuo ter, ye bɔ́ a: «Bɔ̀ nùàr mò, bí né gi kɔɔ́ ye, Càŋ lé naâ mè ká lètenè biì balé sɔm, baá dàb ndɔ. Sâ dɔɔ́ŋ, à lé ye te mè nde bɔ̀ɔ́ mé Jûf sam Njàgà Bagaà nyî se, te bɔ́ kwaá njií temé teèn. ");
INSERT INTO mcu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Càŋ mé né temé nùàr dɔɔ́ŋ ŋené laré lé béh Cúcuí Ŋagâ temá njií naâ kɔɔ́, à lé bɔ̀ɔ́ mé Jûf sam Cúcuí Ŋagâ cén sâ tema njií naâ kɔɔ́ ndɔ. Sâ ye nyí né bɔ́ gwaán faá nyí gwaán né béh nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","À gwèn lètenè beèh mé bɔ́ kwá nyì ŋgwéh. À bɔ́ temé bɔɔ́ ŋagá lom né mé temé yoòr seèn kwaá njiî. ");
INSERT INTO mcu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mɔ né mân, bí né Càŋ teèn me ke, wanɔɔ́ŋ bí bɔ̀ nùàr seèn seé felè mbiín kwaá né dé keì? Ŋgweéh né seé mé lé naâ bɔ̀ tele beèh léí jɔ̀gɔ̀ yɔgɔ́, lé naâ béh ménâ yɔgɔ́ ndɔ wa? Mɔ né mân, béh mé bɔ̀ déì mbin haá seér né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Béh né gi kɔɔ́ ye, Yeésò Fehtoò beèh lé béh yili sɔɔ́m naâ dé lòù. À bɔ́ yili sɔm né kèì cén ménâ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Piêr tueé sɔm. Sâ bɔ̀ nùàr né lom nɔɔ́ŋ huné den. Jomo sâ bɔ́ ŋgweé Bàrnàbâs bɔ̂ Pɔ̂l baá tueé ndɔ. Bɔ́ tueé bele bɔ́ bɔ̀ fém bɔ́ bɔ̀ cìè mé Càŋ lé naâ beè bɔɔ̀n lètenè bɔ̀ɔ́ mé Jûf sam bɔɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bàrnàbâs bɔ̂ Pɔ̂l yeé tueé gi aá ménâ, Jâk komo wuo ter, ye bɔ̀ nùàr a: «Bí ŋgwé, bɔ̀ nùàr mò. ");
INSERT INTO mcu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔ̂ŋ hên debbé kuú né felè bɔ̀ɔ́ mé Jûf sam, ye Càŋ lé duɔɔ́m naâ bɔ́ kwɔmê, ye te bɔ́ den bɔ̀ nùàr nyî, sâ bɔ̀ŋ beèh duɔɔ́m née lòù ye. ");
INSERT INTO mcu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ŋgòr bɔ̀ *sòn-Càŋ bɔ̀ die yila cu né ka teèn ménâ nág ndɔ, né lè mvù nyagá den ye: ");
INSERT INTO mcu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Né mè Càŋ Dueè. Gwà *Davîd mé lé naâ die, mè nde cu né bú ter komo sie kwaá, mvùr seèn nde cu né yilá gií, mè bɔɔ́ nyegé bú, ");
INSERT INTO mcu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","te bɔ̀ ndùté ndùtù seèn ŋene ménâ, bɔ́ fɔɔ́n ceér mò. Bɔ̀ɔ́ mé mè né lò nùàr dɔɔ́ŋ yilá, nde gi né ceér mò Càŋ Dueè fɔɔ́n ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Né Càŋ Dueè mân tueé né kɔɔ́, à lé naá giì bɔ̀ nùàr tueé, baá dàb ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jâk den cuù ye bɔ́ a: «Mɔ né beè mò, béh té bɔ̀ɔ́ mé Jûf sam mbaá kì cú, bɔ́ kweéh seér gi aá temé kèn. ");
INSERT INTO mcu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Béh bɔ́ nyàgà tágá njí lòm bɔ̀ njèh dé cècàŋ, bɔ́ té yàgà yɔ̀ŋ ndɔ, núɔ́gɔ́ nyaàm mé bɔ́ naâ lòù nei wulá, bɔ́ té yíé. Né mene húɔ́m dé heè, bɔ́ té sònò nágá njí. ");
INSERT INTO mcu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Lòù sam, dàb baá teèn mé bɔ́ né bɔ̀ sóú dé jomò lè *gwà sóù dé kàn feh sɔɔ́, bɔ́ né lè gwà sóù dé kân mé *cieé sóù dɔɔ́ŋ jaŋé ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yeé gi aá, bɔ̀ mbɔ̀ŋ tebê bɔ́ bɔ̀ kokoô bɔ̀ mé bɔ̀ Yeésò bɔ̀ dɔɔ́ŋ kaga ndòn, ye bɔ́ nde né bɔ̀ nuaré déì lètenè bɔɔ̀n sɔm, bɔ́ kwaá bɔ́ jomo Pɔ̂l bɔ̂ Bàrnàbâs, bɔ́ tema njií bɔ́ ké Antiôs ma. Bɔ́ balé weh baá-re Jûde, yilí seèn déì né cu Barsabâs, bɔ́ balé weh Silâs ndɔ. Bɔ́ fà dɔɔ́ŋ né gi bɔ̀ njonjolo bɔ̀ lètenè bɔ̀ mbeî. ");
INSERT INTO mcu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bɔ́ nyagá haá bɔ́ mvù beè, bɔ́ ye: «Bɔ̀ mbeí beèh, béh bɔ̀ mbɔ̀ŋ tebê mé bɔ̀ kokoô bɔ̀ mé bɔ̀ mbeí biì dɔɔ́ŋ né bí bɔ̀ɔ́ mé Jûf sam bieé. Bí né mene ké Antiôs, né mene ké Sirî, né mene ké Silisî dɔɔ́ŋ, béh né bí bieé. ");
INSERT INTO mcu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«Béh lé naâ ŋgweé ye, bɔ̀ nuaré déì lé naâ kán yuo, bɔ́ nde bí feh ter ŋellé kwaá sé wa? Bí té mùnò ye béh lé temà naâ bɔ́ kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Béh né seér ká lètenè beèh bilí taáŋ nyegé, te béh balé tema njií bí bɔ̀ nuaré déì teèn, te bɔ́ njií lɔ bɔ̀ mbeí beèh Bàrnàbâs bɔ̂ Pɔ̂l. ");
INSERT INTO mcu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Béh tueé bí, Bàrnàbâs bɔ̂ Pɔ̂l lé naâ cio lè seé Yeésò *Kristò liím. ");
INSERT INTO mcu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Béh bɔ̀ tebé bɔ̀ sâ balé sɔm né Jûde bɔ̂ Silâs. Mvù mé béh nyagá né hên, bɔ́ nde né mé sòn bɔɔ̀n tueé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Béh bɔ̀ Cúcuí Ŋagâ naâ ndòn kaga, ye bɔ́ té bí seé déì felè mbaá mbín kwá, béh tágá lòm bí bɔ̀ɔ́ mé né teèn yilá hên: ");
INSERT INTO mcu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bí té *sèmè dé cècàŋ yíé, bí té húɔ́m sònò nágá kéh, núɔ́gɔ́ nyaàm mé bɔ́ naâ lòù nei wulá, bí té yíé, bí té yàgà yɔ̀ŋ ndɔ. Mɔ bí né bɔ̀ njèh hên jolo, bí nde né bagasé den. Sâ bí dèn bá-re.» ");
INSERT INTO mcu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bɔ́ yeé nyagá sɔm aá, bɔ̀ tebé bɔ̀ fɔɔ́n gò Antiôs ndɔ. Bɔ́ wa ké teèn, bɔ́ yilá bilí bɔ̀ Yeésò bɔ̀ dɔɔ́ŋ, bɔ́ haá bɔ́ mvù hèllè, ");
INSERT INTO mcu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","bɔ́ jaŋé baá-re toò bɔ̀ nùàr. Bɔ̀ nùàr yeé ŋgweé aá, temé vɔgɔ́ bɔ́ lè, yo taré cu bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sâ Jûde bɔ̂ Silâs fà dɔɔ́ŋ toò naá giì bɔ̀ *sòn-Càŋ bɔ̀. Bɔ́ yila cu teèn tètèì tueé den, bɔ́ né bɔ̀ nùàr toó nyegé, bɔ́ né bɔ́ yo bɔɔ́ taré. ");
INSERT INTO mcu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bɔ́ bɔ́ cer weh ké doó sâ teèn. Jomo sâ bɔ́ bɔ̀ nùàr bie gò, bɔ́ yuo, te bɔ́ cu cu ké yoòr bɔ̀ɔ́ mé lé temà naâ bɔ̂.  ");
INSERT INTO mcu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Te Silâs nde ye tueé, ye nyí nde né ké sâ den le. ");
INSERT INTO mcu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Sâ Pɔ̂l bɔ̂ Bàrnàbâs né yeé ké Antiôs sâ ndɔ, bɔ́ bɔ̀ mbeí déì kókoó mbaá né bɔ̀ nùàr ŋgòr Fehtoò beèh feh, bɔ́ né bɔ́ se. ");
INSERT INTO mcu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nde nde, Pɔ̂l ye Bàrnàbâs a: «Ndê, béh nde bɔ̀ Yeésò bɔ̀ yɔŋ ke, kɔ ŋgweéh bèh mé béh lé naâ mé ŋgòr Fehtoò beèh te lɔɔ́ hihiné tueé kelá dɔɔ́ŋ, bɔ́ né gi taré wa?» ");
INSERT INTO mcu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bàrnàbâs ye te bɔ́ weh sie Jâŋ, mé bɔ́ yilá cu né Mârk beè. ");
INSERT INTO mcu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pɔ̂l berɔ́ŋ ye bú a: «À lé naâ béh ké Pamfilî si lɔɔ́, ye nyí bèh seê déì ndé cú.» ");
INSERT INTO mcu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Teèn sâ tɔgɔ kɔ die lètenè bɔɔ̀n, bɔgɔ́ ŋaá ter, bɔ́ geé le doó sâ. Bàrnàbâs weh Mârk, bɔ́ bú yila bàtô, bɔ́ nde ké Sîpre. ");
INSERT INTO mcu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔ̂l balé weh dé seèn Silâs. Bɔ́ bú yeé baá mé gò, bɔ̀ Yeésò bɔ̀ dua Càŋ felè bɔɔ̀n, bɔ́ kwaá lɔ bɔ́ beè Fehtoò beèh, te à gam bɔ́ mé húɔ́m-temé seèn. ");
INSERT INTO mcu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bɔ́ yuo ndɔ, bɔ́ nde yɔŋ laré tàbè Sirî mé Silisî mene, bɔ́ né bɔ̀ Yeésò bɔ̀ bèh dɔɔ́ŋ yo bɔɔ́ taré bele. ");
INSERT INTO mcu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔ̂l wa ké Dérbè, à nde ké Lîstrè ndɔ. Sâ mbɔ̀ŋ déì lé naâ ké sâ teèn, yilí seèn né Timotê. Meí seèn né *Jûf mé gwaán né ceér Yeésò. Tele dé seèn né nùà Greêk. ");
INSERT INTO mcu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bɔ̀ Yeésò bɔ̀ ké Lîstrè mé Ikoniûm mene né gi dene seèn keí. ");
INSERT INTO mcu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Yeé baá ménâ, Pɔ̂l ye nyí nde né bú jomo nyî weh sie; à weh bú ndɔ, à nde *ŋɔb bú ŋgór. Lé naâ felè bɔ̀ Jûf. Sâ bɔ̀ Jûf te tàbè sâ né gi kɔɔ́ ye, tele Timotê né nùà Greêk. ");
INSERT INTO mcu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Jomo sâ bɔ́ yuo, bɔ́ nde te lɔɔ́ hihinê kelá bele. Ndéb mé bɔ̀ mbɔ̀ŋ tebê bɔ́ bɔ̀ kokoô bɔ̀ lé naâ ké Jerusalem sagá doô, bɔ́ né bɔ̀ nùàr Yeésò tagá bele. ");
INSERT INTO mcu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bɔ̀ Yeésò bɔ̀ né cu terreb te ceér Càŋe kwa ŋeí; cieé dɔɔ́ŋ nùàr kɔ lom baá-re te mbeî sagá yilâ. ");
INSERT INTO mcu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Cúcuí Ŋagâ yiín bɔ́ ŋgòr Càŋ lè tàbè Asíà tueê. Yeé baá ménâ, bɔ́ kela keéh tàbè Frijî mé Galatî, ");
INSERT INTO mcu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","bɔ́ wa ké kwarè Misî, ye te bɔ́ yuo kela Bitinî. Lɔ́ŋ sam, Cúcuí Yeésò yiín cu bɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bɔ́ kela keéh Misî, bɔ́ suaga nde ké Troâs. ");
INSERT INTO mcu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yeé baá cíbíteèn, kulu Pɔ̂l faá vuú nɔ; à ŋene nùà Masedínà déì waà baá, né ter njebá den, ye bú a: «Kúkùr yeè, ŋá kélâ yeè ká Masedínà yoòr beèh, te wò gam béh teèn!» ");
INSERT INTO mcu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Vuú yeé kulu aá Pɔ̂l mân, béh yila ceér Masedínà fɔɔ̂n ndɔ. Sâ béh naâ mé njéh kɔɔ́ gií, ye Càŋ béh yilá njií né ké sâ, te béh nde Njàgà Bagaà ké lètenè bɔɔ̀n se. ");
INSERT INTO mcu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jomo sâ, béh yila bàtô, béh yuo Troâs, béh lemé nde Samoterâ; tàbè sâ né yí lètenè nòmò mân. Cieé ŋaga béh fɔɔ́n cu gò, béh nde Nìàpòlî. ");
INSERT INTO mcu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Béh yuo cu sâ, béh nde Filîp; lè tàbè Masedínà dɔɔ́ŋ ŋgɔ́mnà lé den lɔgɔ́ naâ teèn. Kɔ̀b tàbè sâ né dé seèn beè bɔ̀ Rɔ̂m bɔ̀. Béh cer yií lɔ sâ kɔ́beè. ");
INSERT INTO mcu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mé *cieé sóù, béh yuo ká lɔ, béh nde ké sòn nòmò, ye merré déì béh kwa nde né bèh mé bɔ̀ *Jûf dua yeé Càŋ teèn ké sâ. Béh wa ké teèn, béh den nde doó, béh bɔ̀ véh mé lé bilí deén naâ ké sâ né sòn tueé den. ");
INSERT INTO mcu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ma déì naâ lètenè bɔɔ̀n teèn, yilí seèn né Lídià; à lé yuoó naâ Tiatîr, à né yeé cɔ̀gɔ̀ nyàgàm go. Ma bú séná né nùà dùlà-Càŋ. Béh yeé baá tueé, Fehtoò beèh gulu lɔgɔ́ bú temé te à felá njií tie teèn. ");
INSERT INTO mcu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jomo sâ bɔ́ kou bú nòmò Càŋ mé mbàgà seèn mene ndɔ. À ye béh a: «Ŋgweéh bí né kɔɔ́ ye, mè baá nùà Fehtoò beèh mà. Sâ bí ndê cèr wèh ké lɔ mò teèn.» À yeé baá béh ménâ ŋeí, béh bɔ́ nde ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Cieé déì béh lé naâ bèh Càŋ duaà ndeé, béh bɔ̀ huaán vêh déì kwaré ceér dueè. À lé naâ mé tándulu yoòr. Mɔ baá bú ŋaâ, bɔ̀ njií mé nde né bɔɔ́ dɔɔ́ŋ, à né yeé cie tueé kwaá, à né kàgàlɔ̀ŋ teèn kókoó mbaá kwa, à né bɔ̀ tele seê seèn haá. ");
INSERT INTO mcu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","À yeé ŋene aá béh, à yuo bele béh, à né ké ter yie njií, ye bɔ̀ nùàr a: «Bɔ̀ nùà hên dé bɔɔ̀n bɔɔ́ né seé dé Càŋ terrèb. Bɔ́ ndeè naâ bí ceér feh keéh, te bí yili yuo mé njéh.» ");
INSERT INTO mcu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","À yie sɔɔ́ méménâ cieé kókoó mbaá. Yeé yɔgɔ́ baá, temé ŋaâ Pɔ̂l mé càŋ tándulu yoòr huaán doô, à bele seér, ye bú a: «Mé yilí Yeésò *Kristò, yùò kélâ yoòr huaán hên, mè tueé wò!» Tándulu hèllè yuo kela lè sòn seèn nɔɔ́ŋ ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bɔ̀ tele seê huaán doô yeé ŋene ye ceér kàgàlɔ̀ŋ bɔɔ̀n beè huaán doô surí baá kèn, bɔ́ sie mgbɔmé njií Pɔ̂l bɔ̂ Silâs ké cie yoòr bɔ̀ kokoô bɔ̀ dé lɔɔ̂. ");
INSERT INTO mcu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bɔ̀ sâ bɔ̀ weh njií ser cu bɔ́ ké toò bɔ̀ dé ŋgɔ́mnà, bɔ́ ye bɔ́ a: «Bɔ̀ fà bɔ̀ hên né lɔɔ́ beéh. Bɔ́ né Jûf, ");
INSERT INTO mcu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","béh né bɔ̀ Rɔ̂m bɔ̀; bɔ́ béh feh seér né *sóú bɔɔ̀n, ye béh bele cí. Ŋgweéh beè beèh né jolo mà.» ");
INSERT INTO mcu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Te bɔ̀ nùàr yeé nde ŋgweé njií mân, bɔ́ jeré ŋellé doó dɔɔ́ŋ. Bɔ̀ kokoô bɔ̀ sie ŋaré sɔm Pɔ̂l bɔ̂ Silâs cɔ̀gɔ̀ yoòr, ye te bɔ̀ nùàr tegé nyegé ye bɔ́ núr. ");
INSERT INTO mcu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bɔ́ yeé duún aá bɔ́ ménâ, bɔ́ nde si yií bɔ́ gwà cibì, bɔ́ taga lɔ kè-nùàr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Te kè-nùàr yeé ŋgweé njií ménâ, à nde weh ferá kwaá bɔ́ ké lè kɔ̀ŋ dé ké jomò, à yií bɔ́ fɔ̀gɔ̀ gulè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yeé baá lɔgɔ̀teèn, sâ Pɔ̂l bɔ̂ Silâs né Càŋ dua, bɔ́ né bú mé bené seén njií. Sâ bɔ̀ gwà cibì bɔ̀ né ŋgweé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bɔ́ yeé ŋgweé, tàbè baá jilí taré, né gwà cibì hèllè mé maàŋ mene teèn jilí keéh. Bɔ̀ hin né mé be bɔɔ̀n komó ndeé, fɔ̀gɔ̀ né bɔ̀ gwà cibì bɔ̀ dɔɔ́ŋ gulè koló yuo gií, né doó sue ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kè-nùàr nyimé yuoô, sâ bɔ̀ hin gwà cibì dɔɔ́ŋ baá gi lelɔŋ. Feh ŋellé bú ter, ye merré déì bɔ̀ gwà cibì bɔ̀ durá yuo gi aá. À sua bòù, ye te nyí nde aá yo nyî sieé wulá. ");
INSERT INTO mcu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɔ̂l pam njií ké ter, ye bú a: «Té feh yeè mbaá wúlá kú, béh né gi hên dɔɔ́ŋ ye!» ");
INSERT INTO mcu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kè-nùàr bie we ndɔ, à mɔgɔ dula yila nde ké gwà cibì, à ndelé cemmé nde doó gulè Pɔ̂l bɔ̂ Silâs mé veéh mene. ");
INSERT INTO mcu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jomo sâ à sɔm keéh bɔ́, ye bɔ́ a: «Bɔ̀ kokoô bɔ̀ mò, mè bɔɔ́ nde né naàn, te mè yili yuo wa?» ");
INSERT INTO mcu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bɔ́ ye bú a: «Kwá njí lòm temé mé Yeésò Fehtoò beèh, wò nde né yili yuo, mé mbàgà yeè mene.» ");
INSERT INTO mcu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bɔ́ tueé kwaá bú mé mbàgà seèn mene ŋgòr Fehtoò beèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Cíbítenè doó sâ kè-nùàr weh bɔ́, à nde bɔ́ nyer yaga nyegé. Bɔ́ kou sɔm bɔ́ nòmò Càŋ gwà dɔɔ́ŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","À ŋaá kwaá njií bɔ́ ké gwò seèn, à haá bɔ́ yáb. Yo nɔré bú mé mbàgà seèn mene. Lòù sam, à lé naá loôm mé vɔ́gɔ́-temé, ye nyí temé kwaá njií aá yoòr Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Cieé yeé ŋaga baá, bɔ̀ kokoô bɔ̀ dé ŋgɔ́mnà tema njií ye kè-nùàr a, yì njí bɔ̀ nùà sâ ma. ");
INSERT INTO mcu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kè-nùàr nde ké yoòr Pɔ̂l, ye bú a: «Bɔ̀ kokoô bɔ̀ tema njií naâ ye, yì njí bí yiì. Sâ bí ndé bá-re baga.» ");
INSERT INTO mcu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pɔ̂l deên ndɔ, ye bɔ̀ tebé bɔ̀ a: «Béh né bɔ̀ huaán Rɔ̂m; bɔ́ lé ju felè beèh túé ná ŋgwêh, bɔ́ ye bɔ̀ nùàr a, kɔ́ lòm béh núr duûn, bɔ́ ndé béh ká gwà cibì yií njií. Lé naâ njolò bɔ̀ nùàr. Yeé baá dé sɔɔ̀m, te bɔ́ sɔm leér béh lòù wa? Ndɔ́g ndɔ. Mɔ né ménâ, sâ bɔ́ ndê yì ká béh mé be bɔɔ̀n.» ");
INSERT INTO mcu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bɔ̀ tebé bɔ̀ nde cu bɔ̀ kokoô bɔ̀ ménâ tueé. Bɔ́ yeé nde ŋgweé njií ye Pɔ̂l bɔ̂ Silâs né bɔ̀ huaán Rɔ̂m mân, veéh bɔɔ́ bɔ́ njèh. ");
INSERT INTO mcu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bɔ́ nde bɔ́ be kobó. Jomo sâ, bɔ́ sɔm bɔ́ gwà cibì, bɔ́ ye bɔ́ a: «Kúkùr, bí yùò lɔ hên yuoò.» ");
INSERT INTO mcu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔ̂l bɔ̂ Silâs yeé yuo kelà baá gwà cibì, bɔ́ nde ké gwò Lídià. Bɔ́ yeé ŋene aá bɔ̀ Yeésò bɔ̀, bɔ́ toó nyegé cu bɔ́, jomo sâ bɔ́ fɔɔ́n gò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bɔ́ kela keéh Amfipolî mé Àpòlònî, bɔ́ wa ké Tesalonîk. Ké sâ *gwà sóù bɔ̀ Jûf né teèn. ");
INSERT INTO mcu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yeé baá mé *cieé sóù, Pɔ̂l yila nde cu teèn, faá à né yeé mé bɔ̀ gwà sóù déì bɔɔ́ nɔ. Bɔ́ bɔ̀ nùàr né felè ŋgòr Càŋ tueé kuú. À bɔɔ́ ké teèn sɔ́ndè tagár. ");
INSERT INTO mcu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","À né bɔ́ se, ye bɔ́ a: «Lé naá giì tueé ye, *Nùà Cɔ̀ŋ sé naá kaà gèr ŋené, te à nde ye lè cio komo yuo. Sâ jue né Yeésò mé mè né bí se hên, Nùà Cɔ̀ŋ né bú.» ");
INSERT INTO mcu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bɔ̀ déì lètenè bɔɔ̀n kwaá njií temé teèn, bɔ́ yuo bele Pɔ̂l bɔ̂ Silâs. Bɔ̀ dùlà-Càŋ bɔ̀ lètenè bɔ̀ Greêk, mé bɔ̀ véh dé kokoô ŋgún mbaá bɔɔ́ gi ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bɔ̀ Jûf yeé ŋene aá ménâ, sà ŋgwa ŋaá cuù bɔ́ lè, bɔ́ nde bɔ̀ vevenê bɔ̀ ceceér domó fɔɔ́n, te bɔ́ nde kɔ si bèmè lètenè bɔ̀ nùàr. Lɔɔ́ dɔɔ́ŋ jilí gi. Bɔ́ ŋar wa ké gwò Jásɔ̀ŋ, te bɔ́ sie njií Pɔ̂l bɔ̂ Silâs ké cie toò bɔ̀ nùàr. ");
INSERT INTO mcu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bɔ́ wa ké teèn, bɔ́ Pɔ̂l bɔ̂ Silâs kwà ŋgwéh, bɔ́ sie le mé Jásɔ̀ŋ bɔ́ bɔ̀ Yeésò bɔ̀ déì, bɔ́ tulu nde mé bɔ́ ké toò bɔ̀ kokoô bɔ̀, bɔ́ né sònò bɔm ye: «*Wɔ́ŋ dɔɔ́ŋ beéh gi né bɔ̀ nùàr hên, bɔ́ mé njéh ká lètenè beèh waà kèn! ");
INSERT INTO mcu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jásɔ̀ŋ bɔ́ ké gwò seèn weh kwaá né dé keì wa? Bɔ́ bɔ́ dɔɔ́ŋ né gi bɔ̀ táré-feh bɔ̀, bɔ́ sóú Mgbè Rɔ̂m dùlà cú, bɔ́ ye bɔ̀ nùàr a, mgbè dueè déì né teèn, wa yilí seèn né Yeésò sé wa!» ");
INSERT INTO mcu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bɔ̀ nùàr bɔ́ bɔ̀ kokoô bɔ̀ yeé nde ŋgweé njií mân, bɔ́ cer gi seé. ");
INSERT INTO mcu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bɔ́ ye Jásɔ̀ŋ bɔ́ bɔ̀ mbaábɔn a: «Kɔ bí gwɔ̀m sòn sâ lòù.» Bɔ́ yeé gwɔm aá, bɔ́ yi ye bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Cibí yeé yili baá, bɔ̀ Yeésò bɔ̀ sɔm njií ser Pɔ̂l bɔ̂ Silâs ké Bèrê. Bɔ́ yeé wa baá ké teèn, bɔ́ yila cu gwà sóù bɔ̀ Jûf. ");
INSERT INTO mcu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bɔ̀ Jûf dé sâ lé huɔm kelà naâ kɔɔ́ mé bɔ̀ dé ké Tesalonîk. Ŋgòr Càŋ mé Pɔ̂l lé naâ bɔ́ tueé dɔɔ́ŋ, bɔ́ lé naâ tie teèn felá njií, bɔ́ né mvù Càŋ cieé dɔɔ́ŋ ke sɔɔ́, te bɔ́ ŋene, njií mé Pɔ̂l né tueé doô kɔ ŋgweéh né teèn yilá wa? ");
INSERT INTO mcu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bɔ́ yeé ŋene nyegé aá, bɔ̀ nùàr kókoó mbaá kwaá njií gi temé teèn ndɔ. Lètenè bɔ̀ Greêk, bɔ̀ véh dé kokoô mé bɔ̀ siíb ŋgún mbaá kwaá njií gi temé lè ŋgòr Càŋe. ");
INSERT INTO mcu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bɔ̀ Jûf dé ké Tesalonîk ŋgweé njií cu, ye Pɔ̂l né ŋgòr Càŋ ké Bèrê tueé, bɔ́ kem fulu nde ké teèn, bɔ́ né bɔ̀ nùàr soób, bɔ̀ nùàr duɔɔ́m furû. ");
INSERT INTO mcu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Doó sâ bɔ̀ Yeésò bɔ̀ sɔm Pɔ̂l ndɔ, bɔ́ lemé njií bú ké sòn nòmò koô. Silâs bɔ̂ Timotê den le dé bɔɔ̀n ké Bèrê. ");
INSERT INTO mcu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bɔ̀ɔ́ mé lé njií lɔɔ̀ naâ Pɔ̂l wa ké Àtên, bɔ́ kwaá lɔ bú teèn, bɔ́ cu cu ké Bèrê, te bɔ́ tueé cu Silâs bɔ̂ Timotê tebé Pɔ̂l, ye bɔ́ a: «Pɔ̂l ye, júée bí a, bí yùò bèlè nyí, bí té ŋgágá sɔ́ ma.» ");
INSERT INTO mcu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔ̂l yeé wa baá ké Àtên, à kela den Silâs bɔ̂ Timotê ké teèn. À ŋene bɔ̀ Àtên bɔ̀ né càŋ gènnè hihiné dua, mɔ̀ né lom lɔɔ́ dɔɔ́ŋ merré ndeé. Pɔ̂l yieé kuú cu mé nyie. ");
INSERT INTO mcu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yeé baá ménâ, à nde ké *gwà sóù bɔ̀ Jûf. Bɔ́ bɔ̀ Jûf mé bɔ̀ dùlà-Càŋ bɔ̀ déì né njèh tueé. Cieé dɔɔ́ŋ à né ké mbartɔgɔ lètenè bɔ̀ nùàr ndeé, bɔ́ bɔ́ né njèh tueé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bɔ̀ nùà-tòù bɔ̀ déì lé naâ teèn; bɔ̀ déì lé naâ bɔ̀ *Èpìkuriên, bɔ̀ déì *Sitoyisiên. Bɔ́ yeé baá njèh sònò Pɔ̂l ŋgweé, bɔ̀ déì ye, à sâ tueé cugó den né kei wa? Bɔ̀ déì tueé seér ye, den né faá à tueé den né felè bɔ̀ càŋ dé hiîn nɔ. Sâ Pɔ̂l lé tueé deén naâ felè Yeésò, mé lé naâ lè cio komo yuo. ");
INSERT INTO mcu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yeé baá ménâ, bɔ́ weh njií bú ké te mɔ̀gɔ̀. Yilí mɔ̀gɔ̀ sâ né Areopáje, bɔ́ ye bú a: «Njèh feê mé wò né feh doô yuoô he wa? ");
INSERT INTO mcu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Béh sònò yeè ŋgweé né njèh kèkènè. Béh gwaán né ŋgweé nyegê.» ");
INSERT INTO mcu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sâ bɔ̀ Àtên bɔ̀ bɔ́ bɔ̀ kìn mé né lètenè bɔɔ̀n dɔɔ́ŋ né yeé doó sâ sɔɔ́, bɔ́ kɔ lom njèh fefeê lètenè bɔɔ̀n tueé kuû. ");
INSERT INTO mcu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yeé baá ménâ, Pɔ̂l komo wuo ter ké lètenè Areopáje ndɔ, ye bɔ́ a: «Mè né ŋené ye, mé gècên mene bí bɔ̀ Àtên bɔ̀ né mé temé bɔ̀ càŋ duaà lè. ");
INSERT INTO mcu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mè naâ lɔɔ́ biì beè yɔŋ sie, mè naâ bɔ̀ mɔ̀ càŋ biì hihinê ŋené. Mè nde kwa mɔ̀ déì teèn, à dé seèn née lòù ye. Bɔ́ teèn nyagá kwaá né ye: Càŋ dé hên, béh née bú dé seèn kɔ́ ŋgwéeh ye. Bí ŋgwé-re! Njií mé bí né bú mbaá dua den, mé bí kɔ́ ŋgwéh sâ, mè tétég hên ndeè naâ bí felè seèn tueé nyegé. ");
INSERT INTO mcu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Càŋ bú sâ lé wɔ́ŋ sií naâ kɔɔ́, bɔ̀ njèh teèn dɔɔ́ŋ lé si giì naâ bú. Né Nùà Dueè, à vulú bɔ̂ tàbè bɔɔ́ naâ kɔɔ́. Mɔ̀ mé bɔ̀ nùàr me né mé be, à dé seèn teèn cèr bèh. ");
INSERT INTO mcu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","À túé ŋgwéh ye nuaré déì a, há nyí njeré déì, à bɔ̀ nùàr dɔɔ́ŋ koó seér né kɔɔ́. À bɔ́ yɔ̀ŋ mé cúcuí mé njèh dɔɔ́ŋ haá gi né kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","«À lé bɔɔ́ naâ kɔɔ́, te gèh nùà cên nde ye wɔ́ŋ beè yaám sie, à bɔ́ kerré kwaá bele mé lò hihiné, nàm hihiné ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Sâ dɔɔ́ŋ ye te bɔ́ fɔɔ́n ceér nyî fɔɔ̀n; ye merré déì bɔ́ nde né nyí beré déì bobó kwa. Bɔ́ né kàn mé kán bobó ndeé, sâ Càŋ nùà njèh né gi kwarè beèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","«Mè tueé bí, den né faá bɔ̀ gɔ-njɔŋ lètenè biì lé naá giì tueé nɔ, bɔ́ lé ye: béh yɔŋ né mé bú, béh yieé yili né mé bú, béh den né mé bú. Bɔ́ lé naá cuù tueé ye, béh né bɔ̀ ŋunà Càŋ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Bɔ̀ mbeí mò, hên mɔ béh kɔ gi aá mân kèn, ye béh né bɔ̀ ŋuna seèn, sâ béh munó seér den né kei, ye kɔ Càŋ sé la den seér cu faá ŋgùlàmúr nɔ wa? Sâ tueé né ye, nùàr den cuù nde né mé lo seèn nùà njèh, à bɔré cu toú, à me lɔ̀ŋ, à gɔré taá, te ŋa Càŋ terrèb wa? Bɔ̀ nùàr bɔɔ́ yeé ménâ. ");
INSERT INTO mcu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mé njéh mene, Càŋ dé sâ táŋ cú, à tueé seér né ye, sâ dɔɔ́ŋ bɔ́ lé ndugó seér naâ lòù. Kènê à né mé nùàr wɔ́ŋ dɔɔ́ŋ tueé njií ye bɔ́ a, kwéh sér temé kweèh. ");
INSERT INTO mcu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lòù sam, Càŋ cieé ju tenâ ter sie kwaá gi aá kèn; nde né felè wɔ́ŋ dɔɔ̂ŋ. Nùà gècên ju sâ tena nde né kɔɔ́. À tena yií nde né teèn. Càŋ lé naá giì nùà sâ balé kwaá, à lé naâ nùà sâ te cio komo sɔm, te bɔ̀ nùàr ŋene kɔ teèn.» ");
INSERT INTO mcu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bɔ̀ nùàr yeé nde ŋgweé njií dé mé Pɔ̂l ye: nùàr lé naâ lè cio komo yuo mân, bɔ̀ déì tɔbé bú séb; bɔ̀ déì ye bú a: «Béh nde cu née ŋgòr hên sònò yeè cieé déì ŋgweé nyegé ye.» ");
INSERT INTO mcu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yeé baá mân, Pɔ̂l kwaá lɔ bɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sâ bɔ̀ déì ŋgòr seèn gwaán gi aá kèn, bɔ́ yuo bele bú. Ké lètenè bɔɔ̀n sâ lé naâ Denîs, nùà Areopáje, mé ma déì, yilí seèn né Damarîs, bɔ́ bɔ̀ mbaábɔn. ");
INSERT INTO mcu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Jomo sâ, Pɔ̂l yuo ké Àtên ndɔ, à nde ké Kɔrênt. ");
INSERT INTO mcu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Wa ké teèn, à kwa nùà *Jûf déì, yilí seèn né Akilâ, né bɔ̀ huaán lɔɔ́ Pɔ̂ŋ. Bɔ̂ veèh seèn Prisîl lé yuoô lè lɔɔ́ Rɔ̂m lè tàbè Italî, bɔ́ waà née ké Kɔrênt waà ye. Lòù sam, mgbè Klôdè lé ye bɔ̀ Jûf a, yùò gí ká Rɔ̂m dɔɔ́ŋ yuoò. Pɔ̂l ye wa baá, à yila kwa bɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Sâ bɔ̂ Akilâ né mé seé cên ndɔ. Seé bɔɔ̀n né gi *gwà cɔ̀gɔ̀ saâ. Pɔ̂l den baá-re ké lɔ bɔɔ̀n, bɔ́ bú né gwà cɔ̀gɔ̀ saá. ");
INSERT INTO mcu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mé *cieé sóù dé kàn, Pɔ̂l né ké *gwà sóù bɔ̀ Jûf ndeé, à né ŋgòr Càŋ teèn tueé, à né bɔ̀ Jûf mé bɔ̀ Greêk teèn dɔr kwa keéh. ");
INSERT INTO mcu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jomo sâ Silâs bɔ̂ Timotê mé lé naâ ké Masedínà waà ndɔ. Bɔ́ yeé waà baá, Pɔ̂l kɔ lom aá dé seèn ŋgòr Càŋ tueê, à né bɔ̀ Jûf tueé yɔŋ, ye bɔ́ a: «Yeésò né *Nùà Cɔ̀ŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bɔ̀ Jûf berɔ́ŋ, bɔ́ kem sue bú yoòr mé séb. À yeé ŋene aá ménâ, à ka cɔ̀gɔ̀ seèn, te fùfú lɔɔ́ bɔɔ̀n mvugo cu cu yoòr bɔɔ̀n; à ye bɔ́ a: «Mɔ bí leér le mene, né beè biì; bɔ́ mé mè bíé ndé cú. Kènê, mè nde seér nde aá yoòr bɔ̀ɔ́ mé Jûf sam, mè feh bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","À fɔɔ́n gò ndɔ, à nde ké lɔ nùà dùlà-Càŋ déì, yilí seèn né Títiùs Jústùs. Gwà seèn né kwarè gwà sóù hèllè. ");
INSERT INTO mcu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sâ Krispûs, nùà koô gwà sóù sâ dé seèn Fehtoò beèh gwaán gi aá kèn; bú mé mbàgà seèn mene. Bɔ̀ Kɔrênt bɔ̀ kókoó mbaá lé naâ ŋgòr Pɔ̂l ŋgweé, bɔ́ kwaá njií temé teèn ndɔ. Bɔ́ weh nòmò Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Cíbíteèn déì, kulu Pɔ̂l faá vuú nɔ, Fehtoò beèh ye bú a: «Té vèh, kɔ́ lòm tueê, té húné. ");
INSERT INTO mcu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mè né teèn; nuaré déì wò be veên yoòr kèmà njí ndé ŋgwéh. Bɔ̀ nùàr mò né lɔ hên ŋgún.» ");
INSERT INTO mcu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔ̂l bɔɔ́ ké Kɔrênt gùm nyèmà mé kwèh ndɔ, à né ŋgòr Càŋ tueé. ");
INSERT INTO mcu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Cu mé Gàliɔ̂ŋ, nùà Rɔ̂m, lé naâ ŋgɔ́mnà te tàbè Akayî, bɔ̀ Jûf lé naâ Pɔ̂l ké te *mbàgà juù bilí sie njií. ");
INSERT INTO mcu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bɔ́ wa, bɔ́ ye: «Nùà hên né bɔ̀ nùàr dɔɔ́r, te bɔ́ dua seér Càŋ faá sóú beèh né yiín nɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔ̂l yeé nde aá sòn komo, Gàliɔ̂ŋ ye bɔ̀ Jûf a: «Hên, mɔ sé né-re ŋgòr dùkàŋ déì, mè sé naá-re sòn biì ŋgweé. ");
INSERT INTO mcu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Á, gèh bɔ̀ saân dé mbembaâ hên seèn né felè bɔ̀ ŋgòr, mé bɔ̀ yilí nùàr, mé bɔ̀ sóú biì. Ŋgweéh dé sâ né ju biì wa? Mè teèn sam.» ");
INSERT INTO mcu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","À sɔm keéh bɔ́ cie. ");
INSERT INTO mcu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yeé baá ménâ, bɔ́ ŋar sie Sostên nùà koô ké *gwà sóù bɔɔ̀n, bɔ́ duún lɔ bú núr ké cie sâ; Gàliɔ̂ŋ sòn teèn yí ŋgwéh ménâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔ̂l cer yií cu ké Kɔrênt kɔ́beè. Jomo sâ, à kwaá lɔ bɔ̀ mbaábɔn, à yila bàtô, te à nde Sirî. Lé naâ bɔ́ bɔ̀ Prisîl mé Akilâ. Bɔ́ yeé baá mé gò, à bele sɔm feh ké Sênkrè, te à jolo tou. ");
INSERT INTO mcu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jomo sâ bɔ́ fɔɔ́n gò Efêse ndɔ. Bɔ́ yeé baá ké sâ, Pɔ̂l kwaá lɔ Akilâ bɔ̂ Prisîl, à nde dé seèn ké gwà sóù, bɔ́ bɔ̀ Jûf yila njèh teèn tueê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yeé baá ménâ, bɔ́ bɔŋ bú, te bɔ́ bɔ́ cer weh teèn. Pɔ̂l berɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ye bɔ́ a, mɔ Càŋ gwaán aá, nyí ndeè né cuû ma. Bɔ́ bɔ́ bie. À yila cu bàtô ké Efêse sâ, à fɔɔ́n gò. ");
INSERT INTO mcu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","À nde doó suaga ké Sesarê, à nde cu ké Jerusalem bɔ̀ Yeésò bɔ̀ bie weh, te à nde cu ké Antiôs. ");
INSERT INTO mcu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","À cer weh ké Antiôs sâ teèn, te à yuo cu ye ké sâ, à nde cu lè tàbè Galatî mé Frijî, à né cu bɔ̀ mbɔ̀ŋ dɔɔ́ŋ yo bɔɔ́ taré. ");
INSERT INTO mcu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nùà Jûf déì lé waà naâ ké Efêse, yilí seèn né Apɔlɔ̂s. À né bɔ̀ huaán Alesandrî. Nùà hèllè lé naâ njèh sònò tueé ŋgulí, à né mvù Càŋ kɔɔ́ nyegé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bɔ́ lé naâ bú ceér Fehtoò beèh Yeésò feh. À teèn tegé yila lom mé feh mene, à né bɔ̀ déì jéjég ménâ feh keéh. Njèh cén, à lé kɔ loóm naâ nòmò Càŋ dé Jâŋ. ");
INSERT INTO mcu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","À yeé wa baá, à yila keéh lom njèh te *gwà sóù feèh, à njeré déì vèh ŋgwéh. Prisîl bɔ̂ Akilâ yeé ŋgweé aá ménâ, bɔ́ weh njií bú ké jomo, bɔ́ se nyegé bú ceér Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jomo sâ à ye, nyí nde né te tàbè Akayî ndeé. Bɔ̀ mbeí yeé ŋgweé aá ménâ, bɔ́ gwaán, bɔ́ nyagá haá bú mvù beè te bɔ̀ Yeésò bɔ̀ te tàbè Akayî ŋene ménâ, bɔ́ sie nyegé bú. À yeé baá ké teèn, Càŋ bɔɔ́ bú baga ndɔ, à gam lom bɔ̀ Yeésò bɔ̀ dé tueê sam. ");
INSERT INTO mcu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Bɔ̀ Jûf sòn toò seèn túé kwà cú. À né bɔ́ cie toò bɔ̀ nùàr tueé sɔm, ye bɔ́ né feh sabé; à né bɔ́ te mvù Càŋe lemé njií, te bɔ́ ŋene kɔ teèn, ye *Nùà Cɔ̀ŋ né Yeésò. ");
INSERT INTO mcu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Te cu mé Apɔlɔ̂s né ké Kɔrênt sâ, Pɔ̂l lé naâ dé seèn te bɔ̀ lò tòre ŋaá kelá bele, à suaga nde ké Efêse. Wa ké teèn, à kwa bɔ̀ mbɔ̀ŋ déì, ");
INSERT INTO mcu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ye bɔ́ a: «Cu mé bí lé naâ temé mé Càŋ kwaá njií, bí lé naâ Cúcuí Ŋagâ kwa wa?» Bɔ́ ye bú a: «Ndɔ́g, nuaré déì béh túé ŋgúŋgwéh ye Cúcuí Ŋagâ né teèn.» ");
INSERT INTO mcu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔ̂l ye bɔ́ a: «Bɔ́ lé bí koú naâ mé nòmò Càŋ dé heè wa?» Bɔ́ ye bú a: «Lé naâ mé nòmò Càŋ dé Jâŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔ̂l ye bɔ́ a: «Jâŋ lé bɔ̀ nùàr kou belé naâ, te feh keéh ye bɔ́ kweéh seér aá temé. À lé naá giì bɔ́ tueé ye bɔ́ a, nuaré déì baá jomo nyî ndeê, bɔ́ kwá njí temé yoòr seèn ma. À lé sâ jueè naâ Yeésò.» ");
INSERT INTO mcu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bɔ́ yeé ŋgweé aá ménâ, bɔ́ weh nòmò Càŋ mé yilí Yeésò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔ̂l ba bɔ́ be felè, Cúcuí Ŋagâ waà felè bɔɔ̀n, kema bɔ́, bele seér bɔ́ leba, bɔ́ né ju bɔ̀ nùàr hihiné tueé, bɔ́ né *sòn-Càŋ tueé bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bɔ́ dɔɔ́ŋ lé waà naâ yulà cùɔ̀b fà. ");
INSERT INTO mcu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔ̂l bɔɔ́ ké doó sâ weéh tagár, à né ŋgòr te *gwà sóù tueé, à njeré déì vèh ŋgwéh, à né bɔ́ felè *Lò Càŋ tueé, à né ceér fɔɔ́n, ye te nyí dɔr keéh bɔ̀ nùàr teèn. ");
INSERT INTO mcu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mé njéh mene, bɔ̀ nuaré déì lé naâ berɔ́ŋ, bɔ́ duagá seér cu tie lòù, bɔ́ né ceér Fehtoò beèh toò bɔ̀ nùàr tueé beéh. Pɔ̂l yeé ŋene aá ménâ, à weh bɔ̀ mbɔ̀ŋ, bɔ́ bɔ́ yuo nde ser lè gwà jaŋendè Tiranûs, à né ŋgòr Càŋ teèn cieé dɔɔ́ŋ feh den. ");
INSERT INTO mcu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bɔ́ bɔɔ́ teèn nyèmà fà. Bɔ́ yeé bɔɔ́ baá ménâ, bɔ̀ Jûf mé bɔ̀ɔ́ mé Jûf sam te tàbè Asíà dɔɔ́ŋ ŋgweé laré gi ŋgòr Fehtoò beèh. ");
INSERT INTO mcu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Càŋ lé naâ bɔ̀ kèkènè fêm beè Pɔ̂l bɔɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bɔ̀ nùàr né bɔ̀ fùlù cɔ̀gɔ̀ beè seèn mé yoòr seèn weh bele, bɔ́ né bɔ̀ beên bɔ̀ mé njéh kemá bele, bɔ́ né taré yuo, bɔ̀ tándulu né bɔ́ yoòr durá yuo bele ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bɔ̀ Jûf mé né yeé teter yɔŋ gɔ lé naâ doó sâ teèn, bɔ́ né yeé tándulu kwɔgɔ́ ndɔ. Bɔ́ yeé ŋene aá ménâ, bɔ́ yegé weh yilí Yeésò Fehtoò beèh, bɔ́ nde tándulu mé njéh kwɔgɔ́ ndɔ. Dé kàn ye bɔ̀ tándulu a: Yeésò mé Pɔ̂l né tueé doô, nyí wò kwɔgɔ né mé yilí seèn ma. ");
INSERT INTO mcu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sâ lètenè bɔ̀ sâ bɔ̀, bɔ̀ huaán déì naâ teèn téhbeh. Bɔ́ né bɔ̀ ŋunà *ŋgàŋ sèmè dé koô déì. Yilí ŋgàŋ sèmè sâ né Seévà. Bɔ́ né yeé ménâ bɔɔ́ taré ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bɔ́ yeé baá ménâ bɔɔ́, tándulu ye bɔ́ a: «Mè né Yeésò kɔɔ́, mè né Pɔ̂l kɔɔ́ ndɔ. Á, dé biì nɔ? Bí né bɔ̀ neì wa?» ");
INSERT INTO mcu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nùà mé tándulu yoòr hèllè toró ŋgumó yila bɔ́ yoòr ndɔ, à né bɔ́ téhbeh dɔɔ́ŋ taré yɔgɔ́, à né bɔ́ nu, bɔ́ né cie luŋturu mé nyer yoyoòr durá yuo kelá. ");
INSERT INTO mcu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bɔ̀ Efêse bɔ̀ mé né Jûf mé bɔ̀ Greêk mene dɔɔ́ŋ yeé ŋgweé aá ménâ, veéh yila bɔ́ lè, bɔ́ yila yilí Yeésò Fehtoò beèh seên. ");
INSERT INTO mcu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bɔ̀ɔ́ mé baá temé mé Yeésò kwaá njií, né ká toò Pɔ̂l kem ndeê, bɔ́ né bɔ̀ veên bɔɔ̀n cie tueé sɔm. ");
INSERT INTO mcu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bɔ̀ táhuno bɔ̀ kókoó mbaá domó wa giì mé bɔ̀ mvù táhunò bɔɔ̀n, bɔ́ né toò bɔ̀ nùàr ŋgie sɔm. Mɔ bɔ́ sé naâ kàgàlɔ̀ŋ bɔ̀ mvù sâ dɔɔ́ŋ mberé, sé lé naâ kám yulà tîn waá. ");
INSERT INTO mcu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Yeé baá ménâ, ŋgòr Fehtoò beèh sɔm keéh terreb seèn cie; né lom tetoò yaám ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Jomo bɔ̀ njèh sâ, Pɔ̂l kaga ndòn, ye nyí nde né ké Masedínà mé Akayî kelá, te nyí nde cu ké Jerusalem. Ye, mɔ nyí baá ké sâ, kɔ nyí wa Rɔ̂m ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yeé baá ménâ, à tema keéh bɔ̀ gàm bɔ̀ toò fà, lé naâ Timotê bɔ̂ Herástà, ye bɔ́ a, bí ndé ké Masedínà ma. À dé seèn le ŋgɔgɔ̂ lè tàbè Asíà. ");
INSERT INTO mcu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Cu sâ bèmè tarê lé naâ kɔ die, lé naâ felè ceér Fehtoò beèh. ");
INSERT INTO mcu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Yìè lé naâ mé nùà lè déì, yilí seèn né Dèmeteriyû. Sâ ké Efêse mɔ̀ cècàŋ déì lé naâ teèn. Yilí cècàŋ hèllè né *Aretémì. Dèmeteriyû né yeé mɔ̀ sâ mé lɔ̀ŋ si seér, à nde go, bɔ́ bɔ̀ seê bɔ̀ seèn kwa nòmò teèn. ");
INSERT INTO mcu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ŋgòr Càŋ yeé baá tetoò yaám ndeé, à yilá bilí bɔ̀ seé bɔ̀ seèn, mé bɔ̀ɔ́ mé bɔ́ bɔ́ né mé seé cên ndɔ, ye bɔ́ a: «Belà, bí né kɔɔ́ ye, béh yieé yeé mé seé hên, béh ŋueé mé njéh. ");
INSERT INTO mcu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ŋgweéh bí né Pɔ̂l ŋené wa? À né cie tueé sɔm, ye bɔ̀ nùàr a, bɔ̀ càŋ mé bɔ́ bɔɔ́ né mé be dɔɔ́ŋ, Càŋ gècên déì sam. À né ménâ tueé, à né bɔ̀ nùàr dɔɔ́r weh. Kènê bɔ̀ nùàr kókoó mbaá yuo bele gi aá bú. Ká Efêse hên gí lòm cú, nde aá mé tàbè Asíà mene dɔɔ́ŋ beè laré sie. ");
INSERT INTO mcu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nde né seé beèh nyimé sɔm. Mɔ̀ Aretémì, càŋ beèh dé koô, nde né mé njéh calé yuo, te bɔ̀ nùàr ke njií terreb seèn faá njèh mbaâ nɔ. Bí ŋéné ŋgwéh ye bɔ̀ Asíà bɔ̀ mé bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ dua gi né bú wa?» ");
INSERT INTO mcu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Te bɔ̀ nùàr yeé nde ŋgweé njií mân, temé ŋaâ bɔ́ lè doó dɔɔ́ŋ, bɔ́ sɔm gi hueh ye: «Hê ceè, Aretémì bɔ̀ Efêse bɔ̀ kela né kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Lɔɔ́ dɔɔ́ŋ salé gi mé njéh. Bɔ́ sie kwa bɔ̀ mbeí seê Pɔ̂l déì fà. Né bɔ̀ Masedínà bɔ̀. Yilí bɔɔ̀n né Gayûs bɔ̂ Aristârk. Bɔ́ mgbɔmé nde mé bɔ́ ké gwà sɔ̀ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔ̂l yeé nde aá teèn ndeé, bɔ̀ Yeésò bɔ̀ yiín bú. ");
INSERT INTO mcu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bɔ̀ mbeí seèn mé né bɔ̀ kokoô bɔ̀ dé ŋgɔ́mnà lè tàbè Asíà, tema njií ye bú a, kúkùr seèn, à té ké gwà sɔ̀ŋ ndé ma. ");
INSERT INTO mcu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ké gwò bèmè lé dé tueê ná cû. Dé kàn né tueé, dé kân né tueé. Nùà ŋgún né lom mbaá ŋgaré njií, bɔ́ kwɔ̀m juù hèllè kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bɔ̀ nuaré déì yeé ŋene aá ménâ, bɔ́ se Alesándà dɔ̀gɔ̀tì. Sâ bɔ̀ Jûf lé bú toò lu keéh naâ kɔɔ́. Alesándà yeé ŋgweé nyegé aá dɔ̀gɔ̀tì, à me njií bɔ̀ nùàr mé be ndɔ, ye te nyí se bɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bɔ̀ nùàr yeé nde ŋene kɔ ye, à né nùà Jûf mân, bɔ́ bɔm njií cu ké ter mé sòn cên ye: «Hê ceè! Aretémì bɔ̀ Efêse bɔ̀ kela né kɔɔ́!» Bɔ́ mé njéh tum nde den ka tɔ́g gùm yɔ̀ŋ loù fà, bɔ́ né tum den. ");
INSERT INTO mcu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jomo sâ te nuaá mé nyagá yeé njèh lɔ sâ bɔɔ́ cemé ye bɔ́, ye bɔ́ a: «Bí bɔ̀ Efêse bɔ̀! Mɔ̀ Aretémì dé koô den né ká Efêse. Ŋgùlàmúr seèn lé naâ ké te vulúu die suagâ. Nuaá mé ménâ kɔ́ ŋgwéh, né neì wa? ");
INSERT INTO mcu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nuaré déì nde né saán ndɔ wa? Mɔ né ménâ, bí sé la née mbaá mbóró wèh ŋgwéeh ye. Bí sé la naâ nɔɔ́ŋ den. ");
INSERT INTO mcu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bí mé bɔ̀ nùà hên weh nde kuû né mbaá, bɔ́ njeré déì ké lè mɔ̀ beèh ŋúɔ́b ŋgwéh; bɔ́ càŋ beèh sèb ŋgwéh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mɔ Dèmeteriyû bɔ́ bɔ̀ seê bɔ̀ seèn gwaán né nuaré déì mé ju, bèh ju tueê né teèn, bɔ̀ kokoô bɔ̀ né teèn ndɔ. Mɔ né ménâ, kɔ bɔ́ nde lòù sií. ");
INSERT INTO mcu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mɔ bí né cu mé ju déì teèn, bɔ́ nde né ju sâ faá né yeé nɔ tená. ");
INSERT INTO mcu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mè tueé bí, njií mé né kelá hên, béh nde né njìè teèn jɔgɔ́. Lòù sam, bɔ́ sé ye «túé bá kùɔ̀m”, béh sè kòmò ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","À yeé tueé gi aá ménâ, ye bɔ́ a: «Bí ŋéŋellè!» ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Jomo sâ, bèmè hèllè huné ndɔ. Pɔ̂l yilá bilí cu bɔ̀ Yeésò bɔ̀, à toó nyegé bɔ́, te yo taré bɔ́ tarè. À yeé toó gi aá bɔ́, à bie bɔ́, à fɔɔ́n gò Masedínà ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","À wa ké teèn, à né bɔ̀ Yeésò bɔ̀ mé ŋgòr Càŋ toó ndeé den, te bɔ́ kwa bele terreb mé njéh. Jomo sâ à kela nde ser te tàbè Akayî. ");
INSERT INTO mcu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","À cer ké sâ weéh tagár, à ye nyí nde né bàtô yilá, te nyí nde cu ké Sirî ma. Sâ bɔ̀ Jûf lé baá cuù sòn felè seèn nyɔgɔ, te bɔ́ wula bú. À yeé ŋgweé aá ménâ, à kaga baá-re ndòn, ye nyí kela seér cu nde né Masedínà. À lé naâ ménâ bɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bɔ̀ nuaré déì lé naâ bú njií lɔɔ́. Lé naâ Sopátà ŋunà Pirûs nùà Bèrê, mé bɔ̀ Tesalonîk bɔ̀ déì fà, yilí bɔɔ̀n né Aristârk bɔ̂ Sekúndù. Déì naá cuù Gayûs nùà Dérbè bɔ̂ Timotê. Bɔ́ bɔ̀ Asíà bɔ̀ déì fà lé naâ kɔɔ́ ndɔ, yilí bɔɔ̀n né Tisîk bɔ̂ Trofîm. ");
INSERT INTO mcu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bɔ̀ sâ bɔ̀ lé naâ toò kelá, bɔ́ nde kela den béh ké Troâs. ");
INSERT INTO mcu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Cieé koô mé bɔ̀ Jûf yieé yeé breêd mé kulu teèn sam, yeé kela baá, béh nde ye dé beèh bàtô ké Filîp yilá, béh bɔɔ́ ceér dueè cieé tîn, béh nde ye bɔ́ ké Troâs kwa. Béh bɔ́ bɔɔ́ ké teèn cieé téhbeh. ");
INSERT INTO mcu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mé samedî liyilì, béh yeé nde aá yáb Càŋ yieé, béh bilí den bècénè. Pɔ̂l né bɔ̀ nùàr ŋgòr Càŋ tueé, sâ cieé ŋaga, à baá mé gò. À né tueé, à tueé den ka méménâ tɔ́g lɔgɔ̀teèn. ");
INSERT INTO mcu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Béh lé deén naâ ké gwò lè jèh gwà dé ké teèr, lâm lé naâ gwò kókoó mbaá. ");
INSERT INTO mcu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pɔ̂l né ka mé ŋgòr Càŋ tueé ndeé, sâ huaán ndà déì né lɔ́m yi den; à né yí kwarè kùm. Yilí seèn né Etikù. À yeé baá ménâ yi den, à yi yuo kela mé njéh toò, à die suagà, à kela keéh jèh gwà fà, à tɔb die doó, bɔ́ bú ter jɔgɔ sɔm baá komó. ");
INSERT INTO mcu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔ̂l suagà ndɔ, geér nde doó felè seèn, jɔgɔ sie bú beè, ye bɔ̀ nùàr a: «Bí té nyàmè, à né làŋ!» ");
INSERT INTO mcu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Te Pɔ̂l ŋaá cu ye ké ter, kɔlé yieé breêd, tueé ŋaga cu mé ŋgòr. Cieé yeé ŋaga baá, à fɔɔ́n ye gò. ");
INSERT INTO mcu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Sâ bɔ́ la naâ mé huaán ndà hèllè weh yuo ndɔ. À la baá cu làŋ. Temé die cu bɔ̀ nùàr dɔɔ́ŋ lè. ");
INSERT INTO mcu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Béh yuo gò, béh kela dé beèh toò. Béh weh bàtô, ye te béh ŋaá weh keéh Pɔ̂l ké Asô faá à lé tueé naâ nɔ. À lé dé seèn gɔɔ́ naâ mé gule. ");
INSERT INTO mcu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Béh bɔ́ yeé kwaré baá ké Asô, béh weh bú ndɔ, béh bɔ́ nde Mitilên. ");
INSERT INTO mcu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Béh yuo cu doó sâ mé bàtô. Cieé ŋaga béh wa kwarè Siô. Cieé ŋaga cu, béh yila Samósà. Cieé yeé ŋaga cu aá déì, béh wa ké Milê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Sâ béh lé naâ Efêse kelá keéh. Lòù sam, Pɔ̂l lé ye nyí ké teèn njébá ndé ŋgwéh, mɔ sam nyí nde né te tàbè Asíà ŋgagá kelá. À lé ye, mɔ nde né bɔɔ́, te nyí ké Jerusalem wa loù *Pàntèkɔ̂t. ");
INSERT INTO mcu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔ̂l tema njií ké Efêse, ye bɔ̀ kokoô bɔ̀ lètenè bɔ̀ Yeésò bɔ̀ a, bɔ́ ndê kwà nyí ká Milê ma. ");
INSERT INTO mcu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bɔ́ waà ndɔ. Pɔ̂l ye bɔ́ a: «Bí né gi dene mò ké lètenè biì kɔɔ́, yuoô loù mé mè lé naâ ká te tàbè Asíà waâ, nde mé ké toò mene. ");
INSERT INTO mcu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mè seé Fehtoò beèh bɔɔ́ lom né mé temé dɔlê, mé yímé njolò ndɔ. Bɔ̀ Jûf lé naâ sòn felè mò nyɔgɔ, mè gèr beè bɔɔ̀n ŋene lom dé fî. ");
INSERT INTO mcu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mé njéh mene, mè bí njeré déì lòù túé gúgó lɔ́ ŋgwéh, sâ mè ye te gam bí. Mè bí ŋgòr Càŋ feh gi aá kèn. Né mene cie, né mene gwò, mè lé naá giì bí feh. ");
INSERT INTO mcu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mè lé naá giì bɔ̀ Jûf mé bɔ̀ɔ́ mé Jûf sam dɔɔ́ŋ yilá, te bɔ́ kweéh seér temé, bɔ́ bele ceér Càŋ, bɔ́ kwaá njií temé yoòr Fehtoò beèh Yeésò *Kristò. ");
INSERT INTO mcu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Mè kènê baá mé gò Jerusalem. Cúcuí Ŋagâ mè ké sâ ba njií né lòù. Njií mé nde né mè ké teèn kwa, mè kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mè kɔ cegé né njèh cén, ye lè lɔɔ́ dé kàn dɔɔ́ŋ Cúcuí Ŋagâ né mè tueé ye mè a, gwà cibì né mè kela mé gèr mene. ");
INSERT INTO mcu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mè nde né mene kuú, mè mé nyàmè sam, mè kɔ lom né ké sònòbɔ̀ dula yuo kelâ, te seé mé Fehtoò mò Yeésò né beè mò haá kwaá hên mboón. À lé beè mò haá kwaá naâ Njàgà Bagaà, ye mè a, ndé bɔ̀ nùàr húɔ́m-temé Càŋ tueé ma. ");
INSERT INTO mcu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mè bí njèh felè *Lò Càŋe feh laré gi aá. Mè né kɔɔ́ ye, kènê bí mè ŋéné ndé cú. ");
INSERT INTO mcu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mè bí hên tueé komo né lan dé cî, ye bí a, mɔ nuaré déì baá mene lètenè biì leér, be mò teèn sam. ");
INSERT INTO mcu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Lòù sam, njií mé Càŋ lé naá giì nyegé kwaá dɔɔ́ŋ, mè bí feh gi aá, mè déì toò kwá lɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bí bɔ̀ŋ feh biì. Bɔ̀ŋ bɔ̀ nùàr mé Cúcuí Ŋagâ né beè biì kurú kwaá doô, bí gó lɔ́m teèn, bí né bɔ́ ke nyegé. Né mbàgà Càŋ, à lé naâ bú mé húɔ́m Ŋuna seèn ŋaá weh. ");
INSERT INTO mcu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","«Mè né kɔɔ́ ye, mɔ mè doó sam cuú, bɔ̀ ŋgùì nde né lètenè biì yilá, bɔ́ ŋellé sɔm mɔ̀gɔ̀ biì. ");
INSERT INTO mcu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Né mene lètenè biì, bɔ̀ nuaré déì ndeè né teèn yuo kelâ, bɔ́ né bèh hiîn tueé fɔɔ́ njií, bɔ́ né bɔ̀ mbɔ̀ŋ Yeésò mé njéh boú. ");
INSERT INTO mcu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bí dèn làŋ dé cî, bí té nyèn ye, lè nyèmà tagâr, mè lé sòn dù ná ŋgwêh, mè lé njèh ké lètenè biì feéh naâ cíbíteèn mé suútenè mene, mè né bí mé yímé njolò mene luɔm ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mè bí kènê kwaá lɔ né beè Càŋ. Ŋgòr húɔ́m-temê seèn a, ká sìè bí beè. À nde né bí terreb haá te bí temé kwaá yam njií gi mé bú, à haá bí ŋgúlú mé à lé naá giì dé bɔ̀ nùàr seèn dɔɔ́ŋ nyegé kwaá doô ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«Mè lé mé tuaá kàgàlɔ̀ŋ bɔ̂ cɔ̀gɔ̀ nuaré déì ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bí né gi kɔɔ́ ye, mè seé tema yeé mé be mò, mè né teèn kwa, mè koó bɔ̀ mbeí seê mò mé njéh. ");
INSERT INTO mcu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mè lé dɔɔ́ŋ bɔɔ́ giì naâ ye te bí ŋene weh teèn, bí seé tema mé be biì, bí né bɔ̀ saám bɔ̀ gam. Bí té ŋgòr Fehtoò beèh Yeésò nyèn. À lé ye: Ŋgulí kela né dé haâ mé dé weèh ma.» ");
INSERT INTO mcu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔ̂l yeé tueé gi aá, bɔ́ bɔ́ dɔɔ́ŋ cemmé nde gi doó, à dua Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bɔ́ si lɔ yúé teèn, bɔ́ né bú kumó sie, bɔ́ né bú gò bieé. ");
INSERT INTO mcu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bɔ́ doó sâ curú yuo baá mé kuún. Lòù sam, Pɔ̂l la naâ bɔ́ tueé ye bɔ́ a, bɔ́ nyí ŋéné ŋgwé ndé cú ma. Bɔ́ njií lɔ bú ké sòn nòmò te à yila bàtô. ");
INSERT INTO mcu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bɔ́ bɔ́ yeé geé aá, béh bɔ́ yila bàtô ndɔ, béh lemé nde ké Kɔ̂s. Cieé ŋaga béh wa Ródè; béh den cuù ké sâ, béh nde ké Pàtárà. ");
INSERT INTO mcu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Béh wa ké teèn, béh kwa bàtô mé nde né Fenisî, béh yila nde teèn ndɔ, béh fɔɔ́n cu gò. ");
INSERT INTO mcu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Béh wa kwarè Sîpre, béh wɔɔ́ŋ kela kèb túnò, te béh nde lè tàbè Sirî. Béh wa ké Tîr, béh suaga doó, te bàtô sɔm su seé. ");
INSERT INTO mcu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ké doó sâ, béh fɔɔ́n kwa bɔ̀ Yeésò bɔ̀ déì teèn, béh bɔ́ cer weh cieé téhbeh. Bɔ́ né Pɔ̂l tueé ye bú a: «Té ké Jerusalem ndé.» Sâ Cúcuí Ŋagâ lé naá giì bɔ́ tueé ye bɔ́ a, Pɔ̂l nde né gèr ké teèn ŋené ma. ");
INSERT INTO mcu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mé njéh mene, sɔ́ndè sâ yeé gi aá, béh fɔɔ́n cu gò. Bɔ́ njií lɔ béh ké jomo lɔɔ̂. Lé naâ bɔ́ bɔ̀ véh bɔɔ̀n, mé bɔ̀ huaán bɔɔ̀n mene. Béh bɔ́ yeé wa baá ké sòn nòmò, béh cemmé nde gi doó dɔɔ́ŋ, béh dua Càŋ. ");
INSERT INTO mcu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Béh bɔ́ bie gò ndɔ. Béh yila cu bàtô, béh fɔɔ́n gò; bɔ́ dé bɔɔ̀n cu cu lɔ. ");
INSERT INTO mcu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Béh yuo ké Tîr sâ, béh nde ké Tolemayîs; gò dé dùdùà ceré le ké sâ. Béh suaga doó, béh nde bɔ̀ Yeésò bɔ̀ dé ké sâ bieé weh, béh bɔ́ cer cieé cén. ");
INSERT INTO mcu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Cieé ŋaga, béh fɔɔ́n cu gò Sesarê. Béh wa ké teèn, béh kela nde ké lɔ Filîp. À né nùà ŋgòr Càŋ se yɔɔ̀ŋ. Béh cer ké lɔ seèn. Lètenè bɔ̀ téhbeh bɔ̀ mé bɔ́ lé naâ ké Jerusalem balé sɔm doô, cén déì lé naâ bú. ");
INSERT INTO mcu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","À né mé bɔ̀ huaán dé vêh nèà, bɔ́ né gi bɔ̀ *sòn-Càŋ bɔ̀. ");
INSERT INTO mcu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ké lɔ seèn sâ béh lé naâ teèn cer weh. Cieé déì sòn-Càŋ déì waà, yilí seèn né Àgàbùs, à lé yuoó naâ ké Judê, ");
INSERT INTO mcu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","à waà ká yoòr beèh, à dɔm weh kàndá Pɔ̂l, à né bɔ̀ gule bɔ̂ be mé njéh kaga bele, ye béh a: «Cúcuí Ŋagâ né tueé ye: Nuaá mé kàndá hên né dé seèn wa, bɔ̀ Jûf nde né bú ké Jerusalem mân kaga ma; wa bɔ́ nde né bú mé bɔ̀ kìn haá njií.» ");
INSERT INTO mcu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Béh yeé nde ŋgweé njií mân, mé béh mene, mé bɔ̀ dé ké Sesarê mene dɔɔ́ŋ, béh bɔŋ gi Pɔ̂l, ye bú a: «Kúkùr yeè, té ké Jerusalem ndé.» ");
INSERT INTO mcu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pɔ̂l den seér cuù, ye béh a: «Sâ né kei wa? Hên bí fɔɔ́n né ceér, te bí yueé tur sɔm mè temé lè! Mè tueé bí, mè baá hên. Ké Jerusalem né mene dé kagaà, né mene cio, mɔ né felè Yeésò Fehtoò mò, mè hên nɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Béh yeé ŋene, yíé ŋgwéh ménâ, béh kwaá lɔ ménâ ndɔ, béh tueé lom aá ye, Fehtoò beèh a, bɔ́ bá njií mé à gwaán nê ma. ");
INSERT INTO mcu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Béh yeé cer weh cu aá, jomo sâ béh nyegé njèh, béh fɔɔ́n gò Jerusalem ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bɔ̀ mbɔ̀ŋ ké Sesarê déì njií lɔ béh, bɔ́ weh njií béh ké lɔ Násɔ̀ŋ, nùà Sîpre, béh cer ké teèn. Né nùàr Yeésò baá dàb. ");
INSERT INTO mcu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Béh yeé wa baá ké Jerusalem, bɔ̀ Yeésò bɔ̀ samé weh lom béh mé vɔ́gɔ́-temé mene. ");
INSERT INTO mcu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Cieé ŋaga, béh bɔ̀ Pɔ̂l nde ké lɔ Jâk, bɔ̀ kokoô bɔ̀ te mbàgà Càŋe bilí gi ké teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔ̂l yeé bie aá bɔ́, à se bele bɔ́ dèbbè seê seèn mé Càŋ lé bɔɔ́ keéh naâ beè seèn lètenè bɔ̀ɔ́ mé Jûf sam dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bɔ́ yeé ŋgweé aá ménâ, bɔ́ yila Càŋ teèn seên. Bɔ́ den cuù ye Pɔ̂l a: «Wò ŋéné ŋgwéh bɔ̀ Jûf ŋgún baá gi bɔ̀ Yeésò bɔ̀ ndɔ wa? Bɔ́ né lom te *sóú joloò tétég. ");
INSERT INTO mcu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bɔ́ lé naá giì ŋgweé, ye wò né yeé bɔ̀ Jûf mé tàbè hihiné feh, ye bɔ́ a, té sóú Músì jòlò, bɔ́ té bɔ̀ huaán *ŋgór ŋɔ́b cú, bɔ́ té gènnè bɔ̀ Jûf bèlè ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Á hên, te béh bɔɔ́ nde né naàn? Béh kɔ né ye, bɔ́ nde né ŋgweé gií, ye wò waà baá kèn. ");
INSERT INTO mcu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mɔ né mân, kɔ wò kènê bɔɔ́ faá béh nde né wò tueé nɔ. Béh né mé bɔ̀ nùà nèà teèn, bɔ́ né yáb jolo. ");
INSERT INTO mcu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wèh sìè bɔ́ beè, bí bɔ́ nde te bɔ́ *sené bí, wò gwɔm sòn bɔɔ̀n, te bɔ́ bele sɔm tou yoòr. Mɔ baá mân, bɔ̀ njií mé bɔ́ né wò felè tueé kwaá dɔɔ́ŋ, bɔ̀ nùàr nde né faá njèh mbaâ nɔ ke njií, bɔ́ tueé seér ye, wò né sóú Músì jolo ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Dé ju bɔ̀ Yeésò bɔ̀ mé Jûf sam, béh lé naá giì bɔ́ kàgà-ndòn beèh nyagá njií, ye bɔ́ a: bɔ́ té *sèmè dé cècàŋ yíé, bɔ́ té húɔ́m sònò nágá kéh; núɔ́gɔ́ nyaàm mé bɔ́ nei wulà naâ lòù, bɔ́ té yíé, bɔ́ té yàgà yɔ̀ŋ ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pɔ̂l weh bɔ̀ nùà nèà sâ ndɔ. Cieé ŋaga, bɔ́ bɔ́ nde ké bèh *sènè sâ, bɔ́ kou bɔ́. Jomo sâ à nde ké *gwà Càŋ koô, à tueé kwaá bɔ́ cieé mé bɔ́ nde né teèn kou ceré, mé bɔ́ nde né sèmè dé nùà kàn haá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mé bɔ̀ cieé téhbeh hèllè nde gií, sâ bɔ̀ *Jûf mé lé yuoó naâ te tàbè Asíà ŋene gi aá Pɔ̂l ké gwà Càŋ koô kèn. Bɔ́ soób su Pɔ̂l dàm nùàr yoòr, bɔ́ sie bú. ");
INSERT INTO mcu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Kéŋ die, bɔ́ ye: «Bɔ̀ *Iserálà bɔ̀, bí ndê, bí yí be teèn! Nùà hên maŋgo felè dàm bɔ̀ Iserálà bɔ̀ tueé seér yeé kɔɔ́. À felè *sóú Músì bɔ̂ gwà Càŋ koô hên tueé gi né ménâ ndɔ. Hên ká gwà Càŋ à yií keéh bilí cu aá mé bɔ̀ kurú mene, à gwà Càŋ mé njéh bɔɔ́ yilí sɔm aá kèn.» ");
INSERT INTO mcu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sâ bɔ́ lé ŋenè naâ Pɔ̂l bɔ̂ Trofîm nùà Efêse, bɔ́ lé naâ ké lètenè lɔɔ̂, bɔ́ ye merré déì Pɔ̂l lé naâ bú ké gwà Càŋ yií keéh. ");
INSERT INTO mcu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Yeé baá ménâ, bèmè ka salé yɔŋ lɔɔ́ dɔɔ́ŋ. Bɔ̀ nùàr né kàn mé kán durá yuoô, bɔ́ né teèn ndeé. Bɔ́ né mé Pɔ̂l cie tulu yuo kelá, bɔ́ né bɔ̀ hin gwà Càŋ jomo coló njií. ");
INSERT INTO mcu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bɔ́ né ceér fɔɔ́n ye te bɔ́ wula Pɔ̂l wulà. Njàgà nde tɔb kwa kwaá-taâb bɔ̀ Rɔ̂m bɔ̀, ye bú a: Jerusalem baá jilí ma. ");
INSERT INTO mcu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","À yeé nde ŋgweé njií mân, à yilá weh bɔ̀ kokoô bɔ̀ lètenè bɔ̀ sɔ́jì, mé bɔ̀ sɔ́jì déì, bɔ́ bɔ́ dula suaga ké teèn. Bɔ̀ nùàr yeé ŋene njií aá kwaá-taâb bɔ́ bɔ̀ sɔ́jì seèn baá ndeê, bɔ́ vu lɔ Pɔ̂l núr loboò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kwaá-taâb doô waà njebá nde yí kwarè Pɔ̂l, ye bɔ́ cáb sìè bú sieè, bɔ́ yí bú fɔ̀gɔ̀ lɔ̀ŋ beè. Jomo sâ ye bɔ́ a: Pɔ̂l né neì wa? À bɔɔ́ naâ kei ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","À né mene ménâ bieé, bɔ̀ nùàr kɔ lom né ké ter lɔgɔ́ njií. Dé kàn ye mbeî kàn, dé kân ye kelà kán. Bɔ́ yeé baá tieè kwaá-taâb ménâ tueé vurú den, ye bɔ́ wèh njí bú ké te mbàn bɔ̀ sɔ́jì. ");
INSERT INTO mcu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mé bɔ́ nde ké ka cébbê waá, sâ Pɔ̂l nde aá mé núr beè bɔ̀ nùàr kuú dɔlé, bɔ̀ sɔ́jì ŋgaá jɔgɔ weéh baá bú lòù. ");
INSERT INTO mcu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bɔ̀ nùàr né lom jomo kem bele. Dé kàn ye wúlá bú wulà, dé kân ye wúlá bú wulà ma. ");
INSERT INTO mcu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Bɔ́ yeé nde aá mé Pɔ̂l ké te mbàne komo yuo kelá, à tueé njií kwaá-taâb mé ju Greêk, ye bú a: «Mè nde né lɔ́ŋ kwa, te mè tueé wò njeré déì wa?» Kwaá-taâb doô ye bú a: «Wò la né ju Greêk tueé nɔɔ́? ");
INSERT INTO mcu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Wò nùà Ejíptò loù doô sam wa? Nùà hèllè lé naâ bɔ̀ nùàr soób, lɔɔ́ jilí gi mé njéh, à lé naâ mé bɔ̀ wúlá-feh bɔ̀ kám nèà ké ya dueè ker yilá. Wò bú sam wa?» ");
INSERT INTO mcu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔ̂l ye bú a: «Mè né dé mò nùà *Jûf, bɔ́ lé ŋaár naâ mè ké Târse te tàbè Silisî. Né lɔɔ́ koô; mè teèn né huaán. Kúkùr yeè, kwá mè tueé weh mé bɔ̀ nùàr teèn.» ");
INSERT INTO mcu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kwaá-taâb ye bú a: «Túé yeè tueè.» Pɔ̂l wuo njebá ter ké te cébbée, me fɔ njií bɔ̀ nùàr mé be. Bɔ̀ nùàr nɔɔ́ŋ ndɔ. Pɔ̂l duɔɔ́m bɔ́ njèh mé ju *hebreêh tueé njiî, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Bɔ̀ nùàr mò, bɔ̀ tele mò, bí ŋgwé! Mè nde aá sòn mò tueé.» ");
INSERT INTO mcu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Te bɔ́ yeé nde ŋgweé njií bú mé ju hebreêh sònò mân, bɔ́ huné ŋeí cu baá ye-re nɔɔ́ŋ. À deén baá-re ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Mè né nùà Jûf; bɔ́ lé mè ŋaár naâ ké Târse te tàbè Silisî. Mè lé kulà naâ ká Jerusalem. Jéjég sóù bɔ̀ tele beèh léí jɔ̀gɔ̀, Gamaliêl lé mè feéh naâ kɔɔ́. Mè lé toò Càŋ bɔgɔ́ naâ faá bí né lan bɔgɔ́ sâ. ");
INSERT INTO mcu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Bɔ̀ɔ́ mé né ceér Yeésò bele dɔɔ́ŋ, mè lé naâ bɔ́ bunó, mè né bɔ́ wulá sɔm bele, mè né siíb mé véh mene gwà cibì sie yií. ");
INSERT INTO mcu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","*Ŋgàŋ sèmè dé koô mé bɔ̀ kokoô bɔ̀ dɔɔ́ŋ sòn mò tueé nde né kɔɔ́. Bɔ́ lé mè mvù beè nyagá haá naâ kɔɔ́, te mè nde ye terreb njolò bɔ̀ Jûf dé ké Damâs kwa. Mè lé naâ ké teèn ndeé ndɔ, ye mɔ mè wa baá ké teèn, mè ndeè né bɔ̀ Yeésò bɔ̀ ká Jerusalem sie turú ndeê, te bɔ́ ŋene gèr ma.» ");
INSERT INTO mcu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Pɔ̂l den cuù, ye bɔ́ a: «Mè fɔɔ́n gò Damâs ndɔ. Mè né ka ndeé, mè wa kwarè lɔɔ̂, sâ lou nde aá dilí. Te mè yeé ke, ŋagâ déì ba suagà ter, né kwarè mò wula njerré yɔŋ. ");
INSERT INTO mcu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mè jege die doó, mè né hueh déì ŋgweé njií, ye mè a: Sɔ̂l, Sɔ̂l, wò mè ménâ bunó né mé ŋgei wa? ");
INSERT INTO mcu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mè bie njií ye bú a: Né wò neì wa, Nùà dueè? Ye mè a: Né nyí Yeésò nùà Najarêt mé mè né bunó den sâ ma. ");
INSERT INTO mcu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bɔ̀ɔ́ mé lé naá giì jomo mò ŋene cegé ŋagâ, bɔ́ lé dé bɔɔ̀n hueh sâ ŋgwé ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mè ye: á hên, mè bɔɔ́ nde aá naàn wa, Nùà dueè? Nùà Dueè doô ye mè a: Kòmò wùò ter, ndé ké Damâs; ké teèn sâ, njií mé nyí ye wò a, bébɔɔ̀, bɔ́ nde né wò tueé. ");
INSERT INTO mcu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bɔ̀ɔ́ mé lé naâ jomo mò doô mé mè ké Damâs derré wa baá lòù. Sâ ŋagâ mè njolo cugó sɔm aá kèn. ");
INSERT INTO mcu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Sâ nùà dùlà-Càŋ déì né lɔ sâ teèn, yilí seèn né Ananíà, à né *sóú beèh bagasé jolo nyegé. Né nùà gècên beè bɔ̀ Jûf ké sâ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nùà sâ waà njebá ndeè kwarè mò, ye mè a: Sɔ̂l, nùàr nyî, njolo yeè a, kòmò cú wò mé njéh komò ma! À yeé cib sòn, njolo mò kwɔgɔ ŋagá ndɔ, mè ŋene njií bú. ");
INSERT INTO mcu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ye mè a: Càŋ mé né felè bɔ̀ tele beèh léí jɔ̀gɔ̀ lé wò balé sɔɔ́m naâ kɔɔ́, ye te wò ŋene kɔ njií mé nyí gwaán nê. À lé naâ wò Nùà dilî njolò feh gií, wò lé naâ bú ŋené, wò ŋgweé hueh seèn. ");
INSERT INTO mcu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Wò nde né sòn seèn toò bɔ̀ nùàr dɔɔ̂ŋ ŋaá. Njií mé wò lé naâ ŋené dɔɔ́ŋ, wò nde né bɔ́ feh, wò feh bɔ́ njií mé wò lé naâ ŋgweé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","À deén baá-re ye mè a: Sâ mè kela cu né kei wa? Wùò ter, bɔ́ kou sɔm wò nòmò Càŋ, te veên yeè yaga yuo mé yilí Fehtoò beèh ma.» ");
INSERT INTO mcu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Jomo sâ mè cu cuù ká Jerusalem. Mè yeé baá Càŋ ké *gwà Càŋ koô dua den, kulu mè faá vuú nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mè ŋene Nùà Dueè ye mè a: Wùò ter kwar, yùò ká Jerusalem nɔɔ́ŋ. Njií mé wò né felè mò tueé den hên, bɔ̀ nùàr gwàn ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mè ye bú a: Nùà Dueè, ŋgweéh bɔ́ né gi kɔɔ́ ye, mè lé naâ te bɔ̀ *gwà sóù ndeé bele, mè sie bɔ̀ɔ́ mé né temé yoòr yeè kwaá njií, mè nde bɔ́ gwà cibì yií njií, bɔ́ duún bɔ́ núr wa? ");
INSERT INTO mcu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ŋgweéh loù mé bɔ́ lé wulà naâ sòn yeè Etiên, mè lé naâ teèn ndɔ wa? Bɔ̀ɔ́ mé lé wulà naâ bú, mè lé naâ bɔ́ seén, bɔ́ lé cɔ̀gɔ̀ huaré kwaá lɔɔ̀ naâ beè mò. ");
INSERT INTO mcu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nùà Dueè tueé baá-re mè ndɔ, ye mè a: Ndé yeè ndeè, mè wò tema njií nde né ké bèh dàb, ké yoòr bɔ̀ɔ́ mé Jûf sam ma.» ");
INSERT INTO mcu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pɔ̂l yeé baá dé bɔ̀ɔ́ mé Jûf sam teèn tueé kwaá, bɔ̀ɔ́ mé lé naá giì ŋgweé dɔɔ́ŋ keéŋ njií ké ter, ye bɔ́ nyòlò sɔ̀m nùà hèllè mé cio; Càŋ a bɔ́ à hue cu ma. ");
INSERT INTO mcu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bɔ́ né ké ter geba njií, bɔ́ né cɔ̀gɔ̀ yoòr salé, bɔ́ né fùfú ter ŋuaán vuú njií. ");
INSERT INTO mcu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kwaá-taâb bɔ̀ Rɔ̂m bɔ̀ doô yeé ŋene aá ménâ, ye bɔ́ yí njí Pɔ̂l yí te mbàn bɔ̀ sɔ́jì, bɔ́ dún bú núr ma. Sâ ye, mɔ núr baá bú yoòr yilá, à nde né cie tueé sɔm, te nyí kɔ kwɔ̀m teèn, nyí kɔ njií mé bɔ́ nùàr né mé njéh ŋaáŋ doô. ");
INSERT INTO mcu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bɔ́ yeé kaga si aá Pɔ̂l doó, faá bɔ́ nde aá bú lobo nɔ, à deên ndɔ, ye nùà koô lètenè bɔ̀ sɔ́jì a: «Mɔ nùàr né bɔ̀ huaán Rɔ̂m, bɔ́ née ju túé ŋgwéeh ye, sóú biì ye lòbò kéh bú mbaá wa?» ");
INSERT INTO mcu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nùà koô hèllè yeé nde ŋgweé njií ménâ, à nde mé kwaá-taâb tueé njií ndɔ, ye bú a: «Wò jue te nyí bɔɔ́ naàn á? Nùà hên né bɔ̀ huaán Rɔ̂m.» ");
INSERT INTO mcu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kwaá-taâb yeé nde ŋgweé njií mân, à ndeè ká teèn mé be seèn, ye Pɔ̂l a: «Júe mè a, nyí né bɔ̀ huaán Rɔ̂m?» Pɔ̂l ye bú a: «Nyea!» ");
INSERT INTO mcu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kwaá-taâb hèllè den cuù ye: «Mè lɔ nde nùà Rɔ̂m ŋaá, mè lɔ gwɔɔ́m naâ kàgàlɔ̀ŋ kókoó.» Pɔ̂l deên ndɔ, ye bú a: «Dé mò, mè né huaán, bɔ́ lé mè ŋaár naâ ké teèn.» ");
INSERT INTO mcu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Te bɔ̀ɔ́ mé la ye bɔ́ nde aá bú lobo doô yeé nde ŋgweé njií mân, bɔ́ ŋellé nde gi gè jomo. Kwaá-taâb mé feh seèn yeé ŋgweé, wa nyí mé yuií kagá naâ bɔ̀ huaán Rɔ̂m mân, veéh bɔɔ́ bú njèh. ");
INSERT INTO mcu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Cieé ŋaga, kwaá-taâb kaga ndòn, ye njií mé bɔ̀ Jûf ye kɔ bɔ́ wúlá sɔ̀m Pɔ̂l mé njéh doô, kɔ nyí ŋgweé nyegé baá kwɔ̀m sâ. Yeé baá ménâ, à ye bɔ́ sè sɔ̀m bú seè. À yilá bilí bɔ̀ *ŋgàŋ sèmè dé kokoô mé gùm mbàgà juù sâ dɔɔ́ŋ, à weh suaga mé Pɔ̂l ké toò juù ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Wa ké teèn, Pɔ̂l ke dilí njií lom bɔ̀ túé-ju bɔ̀ njolo, ye bɔ́ a: «Bɔ̀ nùàr mò, bèh mé lé naâ-naà, mè njèh dɔɔ́ŋ ká lè mò bɔɔ́ gi né njolò Càŋ mé húɔ́m-temé mene; wa hên né den ka cí ye.» ");
INSERT INTO mcu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Te Ananíà *ŋgàŋ sèmè dé koô yeé nde ŋgweé njií ménâ, ye bɔ̀ɔ́ mé den né yí kwarè Pɔ̂l a, bɔ́ fágá yí Pɔ̂l be sònò. ");
INSERT INTO mcu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔ̂l ye bú a: «Wò nùà sòn fà, Càŋ lobo seér nde né wò! Wò te kɔgɔ den nyegé né, ye te nyí tena ju mò faá *sóú tueé nê nɔ, kàmbér wò sóú kwa seér cu nde né lòù, wanɔɔ́ŋ keí bɔɔ́ mé wò ye bɔ̀ nùàr a, lòbò mè lobò wa?» ");
INSERT INTO mcu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bɔ̀ɔ́ mé naá giì kwarè dɔɔ́ŋ su gi sòn, ye bú a: «Wò hên seí né ŋgàŋ sèmè dé koô!» ");
INSERT INTO mcu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔ̂l ye bɔ́ a: «Mè kɔ́ ná ŋgwêh ye, né ŋgàŋ sèmè dé koô, wanɔɔ́ŋ né te mvù Càŋe nyagá den ye: Té veên felè nùà dueè túé njí.» ");
INSERT INTO mcu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Sâ Pɔ̂l naá giì kɔɔ́ ye bɔ̀ téná-juù bɔ̀ kèb déì né bɔ̀ *Sadusiên, kèb déì bɔ̀ *Farisiên ndɔ. Yeé baá ménâ, à lɔgɔ́ njií ké ter ye bɔ́ a: «Bɔ̀ nùàr mò, mè né Farisiên, ŋunà Farisiên. Mè né ndèm kwaá, ye bɔ̀ komó nde cu né lè cio komo yuo. Mè ju hên yila kuú né dé cî.» ");
INSERT INTO mcu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pɔ̂l yeé nde tueé sɔm faá bèh mân, tɔgɔ kɔ die lètenè bɔ̀ Farisiên bɔ́ bɔ̀ Sadusiên, bɔ́ ker fà. ");
INSERT INTO mcu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Lòù sam, bɔ̀ Sadusiên ye bɔ̀ komó lè cio kòmò yùò ndé cú, wa cìlì Càŋ teèn sam, càŋ déì teèn sam ndɔ ma. Sâ dé bɔ̀ Farisiên dɔɔ́ŋ, bɔ́ né gi temé teèn kwaá njií. ");
INSERT INTO mcu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Yeé baá ménâ, bèmè ŋaáŋ seér cu lòù. Bɔ̀ *njí-sóù déì mé né jomo bɔ̀ Farisiên doô, wuo ter, ye: «Ndɔ́g, béh njèh veên déì beè nùà hên kwà ŋgwéh. Sâ merré déì càŋ déì naâ bú njeré déì tueé, mɔ sam né cìlì Càŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Yeé baá ménâ, tɔgɔ bɔgɔ́ ŋeí cu baá-re faá we nɔ. Kwaá-taâb veéh lom aá ye bɔ́ nde né Pɔ̂l sie ŋaré. À yilá njií baá-re bɔ̀ sɔ́jì seèn, te bɔ́ nde Pɔ̂l beè bɔ̀ nùàr ŋgaá weh, bɔ́ nde bú ké te mbàn bɔɔ̀n yií njií. ");
INSERT INTO mcu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Cíbíteèn sâ, Fehtoò beèh ŋené yuo kelà toò Pɔ̂l, ye bú a: «Môn, fágá feh! Wò sòn mò ká Jerusalem tueé sɔm aá kèn, kɔ wò nde cu sòn mò ké Rɔ̂m mân tueé ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Cieé yeé ŋaga baá, bɔ̀ Jûf déì nyɔgɔ sòn, bɔ́ jege ye, bɔ́ njeré déì sònò nágá ndé ŋgwéh, kɔ bɔ́ wula sɔm aá bú, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bɔ̀ sâ bɔ̀ lé naâ yulà nèà yɔgɔ́ keéh. ");
INSERT INTO mcu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yeé baá ménâ, bɔ́ nde kwa bɔ̀ *ŋgàŋ sèmè dé kokoô bɔ́ bɔ̀ kokoô bɔ̀ déì, bɔ́ ye bɔ́ a: «Kènê béh jege baá, ye béh nde né yáb felè Pɔ̂l jolo. Kɔ béh wula sɔm aá bú, sâ ye. ");
INSERT INTO mcu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mɔ né mân, bí bɔ̀ *mbàgà juù bɔ̀ ndé júée kwaá-taâb a, sɔ̀m kêh bí Pɔ̂l, faá bí nde cu née ju seèn taáŋ ye. Béh nde né beré déì njebá tená, béh wula lɔ bú, sâ à née ké te mbàgà juù wá ŋgwéeh ye.» ");
INSERT INTO mcu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kàmbér ŋunà tie Pɔ̂l déì né ŋgweé, à nde ké te mbàn bɔ̀ sɔ́jì, à tueé kwaá Pɔ̂l toò ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔ̂l yilá njiî nùà koô bɔ̀ sɔ́jì déì, ye bú a: «Wèh njí mbò ndà hên ké yoòr kwaá-taâb, à nde né bú njeré déì tueé.» ");
INSERT INTO mcu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nùà koô doô weh njií huaán sâ ké yoòr kwaá-taâb ndɔ. Wa ké teèn, ye bú a: «Pɔ̂l nùà gwà cibì ye mè a, njí lɔ̂ huaán ndà hên ká yoòr yeè, à nde né wò njeré déì tueé sé wa.» ");
INSERT INTO mcu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kwaá-taâb sie weh mbò ndà doô be ndɔ, bɔ́ bú nde ké bèh ndɔ́ŋ-ndɔ̀ŋ, ye bú a: «Wò ye naàn wa?» ");
INSERT INTO mcu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ye kwaá-taâb a: «Bɔ̀ Jûf wɔŋ kwaá gi aá kèn, ye bɔ́ nde né wò tueé ye wò a, kwéh, wèh ndé cû mé Pɔ̂l ké bèh juù, bɔ́ nde cu né ju seèn taáŋ nyegé ma. ");
INSERT INTO mcu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mè tueé wò, ndɔ́g té lòm gwàn. Bɔ́ né njèh yulà nèà yɔgɔ́ keéh, bɔ́ wɔŋ kwaá gi aá kèn, ye bɔ́ nde né beré déì leér den, te bɔ́ mɔm bú. Bɔ́ jege kwaá gi aá, ye bɔ́ nde né yáb felè seèn jolo, bɔ́ njeré déì sònò nágá kéh ndé ŋgwéh, kɔ bɔ́ wula sɔm aá bú, sâ ye. Bɔ́ kènê tab den né mân, bɔ́ kela lom aá te wò komo njií bɔ́ sòn.» ");
INSERT INTO mcu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kwaá-taâb yeé ŋgweé gi aá mân, à luɔm mbò ndà doô, ye bú a: «Té nuaré déì mân túé nyì wâ? Sâ ndé bá-re.» ");
INSERT INTO mcu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yeé baá ménâ, kwaá-taâb yilá njiî bɔ̀ sɔ́jì dé kokoô fà, ye bɔ́ a: «Bí bílí bɔ̀ sɔ́jì yuií fà, bɔ̀ ŋá-nyam bɔ̀ yulà téhbeh mé bɔ̀ gwaga bɔ̀ yuií fà ndɔ, bí nyegé kwaá gò. Liyilì mé lou lɔ̀ŋ tárènèà bí nde né Sesarê ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bí kàgà kwá gí bɔ̀ nyam mé Pɔ̂l nde né teèn ŋaá, te bí lɔgɔ weh bú lɔ̂ŋ, bí njií lɔ ké beè ŋgɔ́mnà Felísì.» ");
INSERT INTO mcu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","À nyagá kwaá tebé teèn ndɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Né mè Klôdè Lisiâs nyagá njií né nùà koô seèn ŋgɔ́mnà Felísì mvù hên kɔɔ́, ye bú a: ");
INSERT INTO mcu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","bɔ̀ Jûf lé naâ nùà hên beè ceéhr keéh, le man bɔ́ wula yili bú. Mè yeé ŋgweé aá ménâ, mè dula nde teèn mé bɔ̀ sɔ́jì beè, mè nde bú ŋgaá weh. Sâ mè naâ ŋgweé ye, né bɔ̀ huaán Rɔ̂m. ");
INSERT INTO mcu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yeé baá ménâ, mè yilá bilí *mbàgà juù bɔ̀ Jûf ndɔ, te mè kɔ kwɔ̀m mé bɔ́ né bú teèn bunó. ");
INSERT INTO mcu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mè ke njií dɔ̀gɔ̀tì juù hèllè né lom felè *sóú bɔɔ̀n. Gèh dé sâ seèn dé cioò mé dé gwà cibì sam bèh. ");
INSERT INTO mcu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Á, nùàr lé naâ waâ, ye mè a: bɔ̀ Jûf wɔŋ kwaá gi aá nɔ. Mè yeé ŋgweé aá ménâ, mè bɔɔ́ lom wúwágá, ye kɔ mè bú haá njií mé wò. Jomo sâ, mè tueé njií mé bɔ̀ Jûf ndɔ, mè ye bɔ́ a: bɔ́ ndé sí sèr bú ké toò yeè.» ");
INSERT INTO mcu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Jomo sâ bɔ̀ sɔ́jì bɔɔ́ faá bɔ́ ŋgweé naâ nɔ: bɔ́ weh Pɔ̂l cíbíteèn sâ, bɔ́ njií lɔ bú tɔ́g ké Àntìpàtrîs. ");
INSERT INTO mcu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Cieé ŋaga bɔ̀ sɔ́jì mé lé gɔɔ́ naâ mé gule cu cuù dé bɔɔ̀n ká te mbàne; bɔ̀ nyam bɔ̀ njií lom aá Pɔ̂l ké Sesarê kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bɔ̀ sâ bɔ̀ wa teèn, bɔ́ haá njií ŋgɔ́mnà mvù hèllè, bɔ́ haá njií bú Pɔ̂l ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ŋgɔ́mnà yeé jaŋé gi aá, ye Pɔ̂l a: «Wò né te kɔ̀b tàbè dé heè wa?» Pɔ̂l ye bú á, nyí né te kɔ̀b tàbè Silisî ma. ");
INSERT INTO mcu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","À den cuù ye Pɔ̂l a: «Kɔ bɔ̀ɔ́ mé lé naâ wò sií baá doó, mè bie ye wò njèh». Ye bɔ́ ndé kwá ŋgɔ́gɔ̂ bú ké lè bɔ̀gɔ̀ *Herôde ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Jomo sâ kela cieé tîn, Ananíà *ŋgàŋ sèmè dé koô bɔ́ bɔ̀ kokoô bɔ̀ déì mé nùà kélá-gàm bɔɔ̀n, wa ké Sesarê. Nùà kélá-gàm sâ, yilí seèn lé naâ Tèrtúlù. Bɔ́ yeé wa baá, bɔ́ nde ké toò ŋgɔ́mnà Felísì mé ju Pɔ̂l hèllè. ");
INSERT INTO mcu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bɔ́ yilá njiî Pɔ̂l ndɔ. Tèrtúlù duɔɔ́m Pɔ̂l siî; à ye ŋgɔ́mnà a: «Dé koô, béh pɔ́ŋ den né mé wò. Wò te kɔgɔ den né mé lo ndɔ. Wò né seér tàbè beèh bɔɔ́ nyegé, te den bagasé. ");
INSERT INTO mcu_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Né mene he, dé koô, béh bɔ́-bagaà yeè weh né mé be fà. ");
INSERT INTO mcu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mè sé ki né wò ndɔ, kúkùr yeè, gér njí tie te ŋgòr beèh teèn: ");
INSERT INTO mcu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Beè beèh dɔɔ́ŋ, meì bɔ̀ kì-nùàr faá nùà hên nɔ sam. Lètenè bɔ̀ Najarêt bɔ̀ dɔɔ́ŋ feh né bú. Bèh mé à né lètenè bɔ̀ Jûf kelá dɔɔ́ŋ bèmè né die. ");
INSERT INTO mcu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","À nde teèn kema bilí baá mé *gwà Càŋ koô mene; béh lé bú sieé naâ ké teèn. Béh ye te béh tena ju seèn faá *sóú beèh tueé nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kwaá-taâb Lisiâs bɔ́ bɔ̀ sɔ́jì seèn nde ta tena toò, bɔ́ ŋgaá weh bú beè beèh mé terreb, ");
INSERT INTO mcu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","à tueé njií mé bɔ̀ɔ́ mé né bú sií doô, ye bɔ́ a, bɔ́ ndé túé sèr ju seèn ká toò yeè ma. Mɔ sam, bíé kú yeè bú, wò nde né gècên beèh ŋené kɔɔ́, te wò kɔ ye béh bú sií yií né teèn.» ");
INSERT INTO mcu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","À yeé nde cib sòn mân, bɔ̀ Jûf gwaán yií teèn, te den ka faá né ménâ nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Jomo sâ ŋgɔ́mnà me njií Pɔ̂l mé be, te à tueé dé seèn ndɔ. Pɔ̂l ye bú a: «Mè kɔ né ye, baá nyèmà kɔ́beè nùà téná-juù felè bɔ̀ nùàr beèh dɔɔ́ŋ né wò. Mè sòn mò toò yeè tueé sɔm nde né mé vɔ́gɔ́-temé mene. ");
INSERT INTO mcu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mè tueé wò, mè lé naá cuù ké Jerusalem bèh Càŋ duaà ndeé, lan née cieé yulà cùɔ̀b fà yɔ́gɔ́ kéh ŋgwéeh ye. Mɔ wò né gwaán, bíé kú yeè. ");
INSERT INTO mcu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Né mene ké *gwà Càŋ koô, né mene ké *gwà sóù, bêh nuaré déì lé sàn kú ná ŋgwêh. Né mene ké lètenè lɔɔ̂, mè cìlì nùàr sób ŋgwéh. Ndɔ́g, nuaré déì lé mè teèn kwà ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bɔ̀ nùàr hên tueé né mbaá, njií mé bɔ́ né mè teèn sií, bɔ́ wò cí fèh kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«Mè dé mò toò yeè kɔ cegé né njèh cén, ye mè seé Càŋ bɔ̀ tele beèh léí jɔ̀gɔ̀ bɔɔ́ né mé ceér dé feê. Bɔ́ den seér cu né kɔɔ́, ye né nyeén. Sâ, né mene te mvù sóù, né mene te mvù bɔ̀ *sòn-Càŋ bɔ̀, njií mé né gi teèn nyagá den dɔɔ́ŋ, mè temé kwaá njií né teèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mè ndèm mé Càŋ kwaá njií né faá bɔ́ né mé bú kwaá njií nɔ. Béh bɔ́ né gi kɔɔ́, ye bɔ̀ gècên bɔ̀ mé bɔ̀ nyeén bɔ̀ nde gi né lè cio komo yuo ma. ");
INSERT INTO mcu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mè tég lege lom né dé cî, ye te ká lè mò, né mene njolò Càŋ, né mene njolò bɔ̀ nùàr, mè njèh dɔɔ́ŋ bɔɔ́ gi né mé húɔ́m-temé. ");
INSERT INTO mcu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Mè lé naâ cie nyèmà ŋgún bɔɔ́, mè lé ké Jerusalem cu cuù lòù. Mè ndeè kàgàlɔ̀ŋ mé bɔ̀ nùàr beèh haá njií, te gam bɔ́. Mè ndeè *sèmè dé mò ké toò Càŋ haá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bɔ́ lé mè ké *gwà Càŋ koô ŋenè naâ, sâ mè né mé tou yoòr. Bêh cìlì nùàr lé kɔɔ́ ná ŋgwêh, bèmè lé teèn ná ŋgwêh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Doó lé naâ bɔ̀ Jûf mé lé yuoó naâ lè tàbè Asíà. Bɔ̀ sâ bɔ̀ sé la ká toò yeè waà né kɔɔ́. Mɔ béh bɔ́ né mé njeré déì, bɔ́ tueé. ");
INSERT INTO mcu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mɔ sam, bɔ̀ hên bɔ̀ a, túé kwɔ̀m veên mò sâ. Loù mé bɔ́ lé naâ mè ké te *mbàgà juù njií, mè lé saàb naâ kei wa? Bɔ́ túé sɔ̀m cie. ");
INSERT INTO mcu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mè dé mò kɔ cegé né njèh cén, ye mè lé naâ ké ter lɔgɔ́ njií, ye mè né ndèm kwaá, ye bɔ̀ komó nde cu né lè cio komo yuo. Mè ju hên yila kuú né dé cî.» ");
INSERT INTO mcu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Sâ Felísì né ceér bɔ̀ Yeésò bɔ̀ kɔɔ́. À yeé ŋgweé aá ménâ, ye bɔ́ a: Ju kuún aá kèn; kɔ Lisiâs kwaá-taâb waà baá, nyí tena ye ju biì sâ ma. ");
INSERT INTO mcu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Jomo sâ ye nùà koô bɔ̀ sɔ́jì a: «Wèh njí cú Pɔ̂l ké gwà cibì, wò yi kwaá bú lòù, te bɔ̀ mbeí yɔŋ nde beh yoòr seèn, bɔ́ gam bú.» ");
INSERT INTO mcu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Yeé cer weh baá, Felísì bɔ̂ veèh seèn Drusílà waà. Veèh dé seèn né nùà *Jûf. Bɔ́ yeé waà baá, bɔ́ tema yilá njiî Pɔ̂l. Pɔ̂l waà ndɔ, à yila tueê, bɔ́ né felá. À tueé bɔ́ felè temé yoòr Yeésò *Kristò kwaá njiî. ");
INSERT INTO mcu_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","À tueé bɔ́ gèh dé dene dilî, à tueé bɔ́ gèh dé yo sieè ndɔ. À yeé baá bú dé ju beè Càŋ dieè tueé, veéh bɔɔ́ bú njèh, ye Pɔ̂l a: «Ndé cú ké gwò ye. Mɔ mè kwa cu aá lɔ́ŋ, mè yilá ye wò.» ");
INSERT INTO mcu_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","À lé beè Pɔ̂l kèb déì gwaán naâ kàgàlɔ̀ŋ ndɔ. À lé bú ká yoòr seèn yilá njií beéh dé cî. Bɔ́ bú né sòn tueé. ");
INSERT INTO mcu_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ka méménâ nyèmà fà yeé kela baá, Pɔrsiû Fésetù waà kweéh ŋgɔ́mnà Felísì. Sâ Pɔ̂l lé née gwà cibì ménâ den den ye. Lòù sam, Felísì lé gwàn ná ŋgwêh njolo mé bɔ̀ Jûf veê. ");
INSERT INTO mcu_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fésetù waà te tàbè sâ ndɔ. À yeé cer aá ké Sesarê cieé tagár, à nde ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Wa ké teèn, bɔ̀ *ŋgàŋ sèmè dé kokoô, mé bɔ̀ Jûf dé njonjolò bilí nde cuù ju Pɔ̂l toò seèn sií, bɔ́ ye bú a: ");
INSERT INTO mcu_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","«Há njí cû yeè béh Pɔ̂l ká Jerusalem teèn». Sâ bɔ́ lé naá giì wɔŋ kwaá, ye bɔ́ wula lɔ nde né bú ceér dueè, te à wa ye ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bɔ́ yeé dua baá Fésetù ménâ, à tueé seér ye bɔ́ a: «Pɔ̂l née ké Sesarê gwà cibì ye, mè nde né ké teèn cuú cuú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mɔ mè baá mé gò, kɔ béh bɔ̀ kokoô bɔ̀ biì nde bilí. Mɔ nùà hèllè lé naâ veên bɔɔ́, bɔ́ nde sií bú ké sâ.» ");
INSERT INTO mcu_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fésetù cer ké lètenè bɔɔ̀n sâ nde njèh cieé yulà, à cu cu ké Sesarê ndɔ. Cieé ŋaga à ŋaá yila te kɔgɔ ju tueê, ye bɔ́ yílá njî Pɔ̂l. ");
INSERT INTO mcu_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔ̂l yeé waà baá, bɔ̀ Jûf mé lé yuoó naâ ké Jerusalem hèllè kaŋ bú, bɔ́ né bú sií, bɔ́ né bú ŋgòr dùkàŋ yoòr cɔré su. ");
INSERT INTO mcu_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mé njéh mene, Pɔ̂l kɔ lom né sòn seèn cie tueé kwaâ, ye bɔ́ a: «Ndɔ́g, mè *sóú bɔ̀ Jûf déì kwá ŋgwéh, mè *gwà Càŋ koô sèb ŋgwéh, mè sóú mgbè Rɔ̂m kwá ŋgwéh ndɔ. Ndɔ́g be mò teèn sam.» ");
INSERT INTO mcu_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fésetù gwaán né bɔ̀ Jûf temé lè bɔɔ́ nɔrê. Yeé baá ménâ, à bie njií seér mé Pɔ̂l, ye bú a: «Wò gwaán né ké Jerusalem ndeê, te béh tena ju hên ké teèn wa?» ");
INSERT INTO mcu_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔ̂l ye bú a: «Mè kènê baá gi ká te mbàgà juù dé mgbè Rɔ̂m; mè njebá né teèn. Sâ né bèh mé bɔ́ tena nde né ju mò teèn. Ŋgweéh wò né gi mé feh yeè kɔɔ́, ye mè bɔ̀ Jûf veên déì bɔ́ nyì ná ŋgwêh mà. ");
INSERT INTO mcu_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mè naâ mene sóú kwaá, né mene njií mé bɔ́ wula yeé nùàr teèn dɔɔ́ŋ, mɔ mè naâ kema, mè cio bèrɔ̀ŋ ndé ŋgwéh. Mɔ bɔ́ mè sar kuú né sòn fuû ndɔ, sâ nùàr a, té mè beè bɔɔ̀n mbaá jɔ́gɔ́ yí.» À den cuù ye bɔ́ a: «Mè ju mò hên njií seér nde aá ké toò mgbè Rɔ̂m.» ");
INSERT INTO mcu_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Yeé baá ménâ, Fésetù bɔ́ bɔ̀ kokoô bɔ̀ nde kwaá sòn. Jomo sâ ye Pɔ̂l a: «Wò la ye nyí ju nyî njií seér nde aá ké toò mgbè Rɔ̂m. Sâ mgbè Rɔ̂m ju yeè tena nde aá kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Yeé cer weh aá, mgbè Agrípà bɔ̂ Berenîk ndeè ké Sesarê Fésetù bieé weh. ");
INSERT INTO mcu_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bɔ́ cer weh cu ké sâ teèn. Yeé baá cieé déì, Fésetù tueé Agrípà ju Pɔ̂l doô, ye bú a: «Felísì lé naâ nuaré déì te gwà cibì kwaá lɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Cieé déì mè yeé baá ké Jerusalem, bɔ̀ ŋgàŋ sèmè dé kokoô mé bɔ̀ kokoô bɔ̀ lètenè bɔ̀ Jûf lé naâ ké toò mò ndeê, bɔ́ sií bú teèn, bɔ́ ye mè a: túé sìè bú mé ju. ");
INSERT INTO mcu_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mè ye bɔ́ a: mɔ bɔ́ naâ nuaré déì sií, béh bɔ̀ Rɔ̂m bɔ̀ ju kèb cén téná bèh. Kɔ bɔ́ bɔ̀ɔ́ mé naâ bú sií baá gi doó dɔɔ́ŋ, à tueé gi aá sòn seèn, ju tena ye. ");
INSERT INTO mcu_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Yeé baá ménâ, béh bɔ́ ndeè kán ndɔ. Cieé ŋaga mè nde te kɔgɔ juù ŋaá yilá, mè ye, bɔ́ ndé yílá njî nùà hèllè. ");
INSERT INTO mcu_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bɔ̀ bùnò bɔ̀ seèn yeé salé gi aá bɔ̀ njií sâ, mè ŋgòr veên déì teèn faá mè naâ munó nɔ ŋéné ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Lé naá cegê bɔ̀ wèllè saân déì felè gènnè bɔɔ̀n, mé felè nuaré déì, yilí seèn né Yeésò. Nùà hèllè lé kuú baá ndɔ. Bɔ́ ye, Pɔ̂l lé ye, nùà sâ lé naâ lè cio komo yuo ma. ");
INSERT INTO mcu_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Gèh bɔ̀ njèh dé sâ né mè dé piì yɔgɔ́. Mè lé bú bieè naâ dé cî, ye bú a: Wò gwaán né ké Jerusalem ndeê, te béh nde ju yeè tená ké sâ wa? ");
INSERT INTO mcu_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ye mè a: bɔ́ yí kwá ŋgɔ́gɔ̀ nyí ké gwà cibì ye; wa mgbè Rɔ̂m ndeè ju nyî tena nde né kɔɔ́ ma. Jomo sâ mè ye: bɔ́ njí cú bú ké gwà cibì ndɔ, à den ŋgɔgɔ̂ teèn, te bɔ́ ndeè njií ye bú ké toò mgbè dé koô.» ");
INSERT INTO mcu_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrípà yeé ŋgweé gi aá ménâ, ye Fésetù a: «Mè gwaán né sònò nùà sâ mé tie mò ŋgweê ndɔ.» Fésetù ye bú a: «Kwéh wò nde né bú ŋené.» ");
INSERT INTO mcu_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Cieé ŋaga ndɔ Agrípà bɔ̂ Berenîk waà. Bɔ̀ kokoô bɔ̀ lɔ sâ, mé bɔ̀ kwaá-taâb, bilí cɔ njií bɔ́, bɔ́ yila nde ké gwò bèh ju tueê. Jomo sâ Fésetù ye: bɔ́ ndé yílá ndê mé Pɔ̂l. À waà ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fésetù deên ye: «Mgbè Agrípà mé bɔ̀ nùàr doó dɔɔ́ŋ, bí né nùà hên ŋené. Lé naâ mene ké Jerusalem, né mene kán, dàm bɔ̀ *Jûf lé naâ bú toò mò sií, bɔ́ lé naâ ké ter lɔgɔ́ njií, ye mè a: wúlá bú wulà. ");
INSERT INTO mcu_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Sâ bèh saâb mé bɔ́ nde né bú teèn wulá, mè dé mò ŋéné ŋgwéh. Bú nùà njèh yeé ŋene aá ménâ, ye ju nyî kènê nde aá ké toò mgbè Rɔ̂m ma. Mè nde né bú ménâ tema njií ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Njèh cén, kwɔ̀m teèn sam. Mè mé nùà dueè mò nyagá njií nde né kei? Mè bú ká toò biì hên yilá kwaá né dé cî, due né toò yeè mgbè Agrípà; te béh kwa kwɔ̀m, mè nyagá njií ye mé mgbè. ");
INSERT INTO mcu_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Lòù sam, njií mé bɔ́ lé naâ nùà gwà cibì teèn sií, mɔ mè kwɔ̀m hèllè sè kɔ́ ŋgwéh, mè njií weh bú mbaá, sâ seé kùlù sam wa?» ");
INSERT INTO mcu_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Jomo sâ Agrípà ye Pɔ̂l a: «Baá toò yeè.» Pɔ̂l me fɔ njií bɔ́ mé be ndɔ, à tueé sòn seèn, ye: ");
INSERT INTO mcu_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mgbè Agrípà, lan temé mò die baá lè, ye mè sòn mò tueé nde né toò yeè, te kwɔ̀m mé bɔ̀ Jûf né mè teèn sií dɔɔ́ŋ, wò ŋgweé mé tie yeè. ");
INSERT INTO mcu_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mè né kɔɔ́ ye, wò né gi tòù bɔ̀ Jûf kɔɔ́, wò né gi bɔ̀ njií mé bɔ́ kuú yeé saân teèn dɔɔ́ŋ kɔɔ́ ndɔ. Kúkùr yeè, kwá sèŋ, te wò ŋgweé gi bɔ̀ ŋgòr mò. ");
INSERT INTO mcu_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Dàm bɔ̀ Jûf né gi dene mò kɔɔ́. Mè lé naâ ké lètenè bɔ̀ nùàr mò kulá, mè nde kula weéh ké Jerusalem. ");
INSERT INTO mcu_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bɔ́ né mè kɔɔ́ dàb baá teèn. Mɔ bɔ́ né gwaán, bɔ́ nde gi né mé sòn bɔɔ̀n tueé, ye mè lé naâ te bɔ̀ŋ bɔ̀ *Farisiên teèn ma. Bɔ̀ɔ́ mé tòù bɔ̀ Jûf jolo lom né mé terreb lé naâ béh. Kɔ bɔ́ gwàn ŋgwéh gècên tueê, wanɔɔ́ŋ né ménâ. ");
INSERT INTO mcu_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","«Kènê ndéb mé Càŋ lɔ naâ mé bɔ̀ tele beèh léí jɔ̀gɔ̀ kwaá kwaá sâ, mè yeé baá ndèm teèn kwaá den, mè ju hên yila kuú né mé njéh. ");
INSERT INTO mcu_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Gèh bɔ̀ nùàr beèh yulà cùɔ̀b fà hên dɔɔ́ŋ ndèm mé ndéb Càŋ cên sâ kwá njí táré ŋgwéh ndɔ wa? Ŋgweéh bɔ́ Càŋ cibi mé suútenè mene dua den né dé cî mà. Mè tueé wò mgbè, bɔ̀ Jûf mè hên bunó seér cu né mé ndèm cên sâ. ");
INSERT INTO mcu_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kei bɔɔ́ né bí kɔɔ́? Bí gwàn ŋgwéh ye, Càŋ né nùàr lè cio komo sɔm dé keì? ");
INSERT INTO mcu_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Mè lɔ naá giì tég lege lom ndɔ, ye te nùàr yilí Yeésò nùà Najarêt sònò fèlà cú. ");
INSERT INTO mcu_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Seé mò ké Jerusalem lé naâ cí. Mè lé naâ ké yoòr bɔ̀ *ŋgàŋ sèmè dé kokoô ndeé, mè jege weh terreb teèn, mè nde bɔ̀ Yeésò bɔ̀ mé njéh te gwà cibì ŋuaán yií. Bɔ́ yeé nde aá bɔ́ wulá, mè lé naâ be ter sɔm njií taré ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mè lé naâ te bɔ̀ *gwà sóù ndeé bele; mè feh keéh bɔ́ gèr teèn, te bɔ́ selé seér yilí Yeésò lòù. Mè nde mé njéh jeré yuo kela bilí ké cie te tàbè bɔ̀ nùàr mene.» ");
INSERT INTO mcu_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Né ka ndeé, loù sâ mè nde bie cu terreb déì mé bɔ̀ *ŋgàŋ sèmè dé kokoô. Bɔ́ yeé jege haá baá mè, mè nde ké Damâs. ");
INSERT INTO mcu_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Wa ceér dueè beré déì, sâ lou baá dilí. Mè tueé wò mgbè, te mè yeé ke, ŋagâ déì ba suagà ter, né lou njerré yɔgɔ́, né kwarè mò njerré yɔŋ, né béh bɔ̀ɔ́ mé njií lɔ né mè beè kaáŋ sie. ");
INSERT INTO mcu_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Béh né gi doó jege dielé ndeé. Mè ŋgweé hueh déì né mé ju *hebreêh tueé, ye mè a: Sɔ̂l, Sɔ̂l, wò nyí ménâ bunó né mé ŋgei wa? Wò feh yeè lè gèr-e yií né mé be yeè. Den né faá nàgà teé yila né lè cùgò beè tele seèn nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mè bie njií ye: Né wò neì wa, Nùà Dueè? Nùà Dueè ye mè a: né nyí Yeésò nuaá mé wò né bunó den sâ. ");
INSERT INTO mcu_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ye mè a: Wùò njébá cú ter. Nyí njolò yeè mân ŋagá yuo kelà né te nyí sie seér wò nùà seê nyî. Wò nde né sòn nyî toò bɔ̀ nùàr den; gèh dé mé wò né nyí lan ŋené hên, te wò tueé bɔ́. Nyí nde né wò bɔ̀ njeré déì feh keéh cuú, te wò tueé cu bɔ́. ");
INSERT INTO mcu_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ye mè a, né mene beè bɔ̀ *Jûf, né mene beè bɔ̀ɔ́ mé nyí nde né mè teèn temá njií dɔɔ́ŋ, nyí nde né mè yili sɔm ma. ");
INSERT INTO mcu_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","«Nùà Dueè den cuù ye mè a, nyí nde né mè yoòr bɔɔ̀n tema njií, te mè nde bɔ́ njolo komo lɔgɔ́, mè sɔm keêh bɔ́ te cibi, bɔ́ den bèh ŋagâ; mè sɔm keêh bɔ́ beè *Sátàn, bɔ́ den beè Càŋ, bɔ́ kwaá njií temé yoòr nyî, nyí kulu sɔm bɔ́ veên yoòr, te bɔ́ kwa ye bèh dene lètenè bɔ̀ nùàr nyî ma.» ");
INSERT INTO mcu_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Mè tueé wò, mgbè Agrípà, njií sâ yeé ŋené aá toò mò faá bèh mân, mè nde cu né sòn seèn ŋgeén wa? ");
INSERT INTO mcu_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mè ŋar yila baá-re seé seèn ndɔ, mè ŋgòr Càŋ tueé duɔɔ̂m ké Damâs sâ, mè nde ye ké Jerusalem, mè né mé njéh kukwarè te tàbè Judê dɔɔ́ŋ tueé ndeé. Jomo sâ mè tueé nde mé njéh lètenè bɔ̀ɔ́ mé Jûf sam ndɔ, mè ye bɔ́ a, bɔ́ yúé fɔ́n feh bɔɔ̀n yueè, bɔ́ bèlè ceér Càŋ, bɔ́ bɔɔ́ seé mé nde né feh keéh ye, bɔ́ kweéh seér aá temé kèn. ");
INSERT INTO mcu_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","«Bɔ̀ Jûf lé mè sieé naâ dé cî, sâ mè né ké *gwà Càŋ koô, bɔ́ ye, kɔ bɔ́ wula sɔm mè wulà. ");
INSERT INTO mcu_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Càŋ mé ŋgeér sam, wa hên à née mè beè bɔɔ̀n yili sɔm den, te mè sòn seèn den toò bɔ̀ nùàr dɔɔ̂ŋ, huaán maân mé kàm bɔ̀ mene, mè né bɔ́ tueé. Mè hên tueé den cu né ka nág faá bɔ̀ *sòn-Càŋ bɔ̀ mé Músì lɔ tueé naâ nɔ, bɔ́ lɔ ye nde né bɔɔ́; ");
INSERT INTO mcu_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","wa *Nùà Cɔ̀ŋ nde né gèr ŋené, à nde né lè cio komo yuo ma; wa te cio komo yuo lɔgɔ́ nde né bú ndɔ. Mè tueé bí, ceér mé bɔ̀ nùàr nde né mé njéh yili yuo, ŋené ŋagá baá mé bú. À nde né dàm bɔ̀ nùàr beèh cí tueé, à né bɔ̀ɔ́ mé Jûf sam tueé ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Sâ Pɔ̂l née sòn seèn tueé den ye, Fésetù tueé njií ké ter ndɔ, ye bú a: «Wò né kùlù wa, Pɔ̂l! Wò maán kela baá njèh, feh yeè ŋellé né ter lòù.» ");
INSERT INTO mcu_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pɔ̂l ye bú a: «Mè kùlù sam dé koô, mè dɔɔ́ŋ tueé gi né ŋgòr gècên mé né teèn yilá. ");
INSERT INTO mcu_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mgbe Agrípà lɔ baá giì mé njéh tieè, mè ká toò seèn hueh lèr cú dé cî. Bɔ̀ njií mé lé naá giì felè Yeésò kelá dɔɔ́ŋ, mè né kɔɔ́ ye, mgbè lé naá giì ŋgweé. Lòù sam, bɔ̀ njií sâ lé bɔɔ́ deén naâ bèsɔ́nè.» ");
INSERT INTO mcu_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Pɔ̂l den cuù ye: «Mgbè Agrípà, wò nɔ, wò né temé yoòr bɔ̀ sòn-Càŋ bɔ̀ kwaá njií wa? Mè né kɔɔ́ ye, wò né temé yoòr bɔɔ̀n kwaá njií.» ");
INSERT INTO mcu_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrípà deên ndɔ, ye Pɔ̂l a: «Wò ye te nyí mè nùà *Kristò sie seér wúwágá mân wa?» ");
INSERT INTO mcu_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔ̂l ye bú a: «Né mene wúwágá, né mene jomo dɔɔ́ŋ, mè né Càŋ dua, te wò den faá mè nɔ. Wò mé huún gí lòm ŋgwéh ndɔ, te bí bɔ̀ɔ́ mé né lan felá dɔɔ́ŋ, den gi faá mè nɔ. Njèh cén, dé biì, fɔ̀gɔ̀ lɔ̀ŋ a, té bí kèmà.» ");
INSERT INTO mcu_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mgbè bɔ̂ ŋgɔ́mnà mé Berenîk, mé bɔ̀ɔ́ mé naâ kwarè bɔɔ̀n dɔɔ́ŋ komo wuo gi ter, bɔ́ nde ké bèh ndɔ́ŋ-ndɔ̀ŋ, ");
INSERT INTO mcu_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","bɔ́ né lètenè bɔɔ̀n tueé kuú, ye: «Nùà hên njeré déì sáb nyì ŋgwéh. Né mene dé wulâ, né mene dé gwà cibì yilâ dɔɔ́ŋ, dé seèn hên cí sam.» ");
INSERT INTO mcu_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrípà deén baá-re ye Fésetù a: «Mɔ nùà hên sé ju seèn ké toò mgbè dé koô njí ná ŋgwêh, kènê bɔ́ sé la naâ bú yi njií.» ");
INSERT INTO mcu_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Yeé baá môn, bɔ́ kaga ndòn ye, béh nde né bàtô yilá, béh nde te tàbè Italî ndɔ. Bɔ́ yeé nyegé gi aá gò, bɔ́ weh haá kwaá Pɔ̂l bɔ́ bɔ̀ gwà cibì bɔ̀ déì beè kwaá-taâb déì, yilí seèn né Julíù. À né kwaá-taâb te bɔ̀ŋ taâb mé bɔ́ yilá né bɔ̀ŋ dé mgbè koô. Bɔ́ yeé baá beè seèn, ");
INSERT INTO mcu_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","béh yila bàtô ndɔ, béh yuo gò. Bàtô sâ lé yuoó naâ Aderàmî, nde né lè bɔ̀ lɔɔ́ hihiné ké te tàbè Asíà kelá bele. Béh bɔ̀ nùà Masedínà déì lé naâ kɔɔ́, à lé yuoó naâ ké Tesalonîk, yilí seèn né Aristârk. Béh bɔ́ né ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Cieé ŋaga, béh wa ké Sídɔ̀ŋ. Julíù feh keéh lom Pɔ̂l húɔ́m-temé seèn mé gècên mene, à kwaá lɔ bú te à nde bɔ̀ mbeí dé ké sâ yɔŋ ke, à kwa bɔ̀ njií mé né bú saám beè bɔɔ̀n. ");
INSERT INTO mcu_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Jomo sâ béh yila cu bàtô, béh fɔɔ́n gò. Béh bɔ̀ fu tarê nde kwaré, béh cií kela seér tàbè Sîpre kèb jomò, ");
INSERT INTO mcu_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","béh wa kwarè tàbè Silisî mé Pamfilî, te béh nde ye ké Mírà te tàbè Lisî yuo kelá. ");
INSERT INTO mcu_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ké teèn sâ, kwaá-taâb kwa cu bàtô déì; dé sâ lé yuoó naâ ké Alesandrî, à baá mé gò Italî, à yií cu béh teèn, béh bɔ́ fɔɔ́n gò. ");
INSERT INTO mcu_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Cieé mé cieé béh né dùà lè ndèndèŋ nòmò lege den, fu tarê né béh seé weh. Béh nde ké kwarè lɔɔ́ Senidò lege yuo kela baá lòù. Béh yeé bèh toò ndeê kwà cú, béh nde seér cu kèb Salmɔnê, te béh cií kela seér tàbè Kreétà kèb jomò. ");
INSERT INTO mcu_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Cieé mé cieé béh dùà lege nde den né lòù. Béh nde lege yuo kela ké kwarè Lasê bèh mé mgbáŋ né teèn. Bɔ́ mgbáŋ sâ yilá né Mgbáŋ Bagaà. ");
INSERT INTO mcu_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Béh lé naâ cieé kókoó mbaá ceér dueè bɔɔ́. Dé toò ndeê sé bɔ́ ná cû. Lòù sam, cieé yáb joloò lé naâ kelá, bɔ́ lé naâ mé njéh ŋené kɔɔ́, ye cu dùà gɔɔ̀ kela baá, dé dùà gɔɔ̀ nde né yɔgɔ́. Pɔ̂l yeé ŋene aá ménâ, à tueé kwaá bɔ́ toò ndɔ, ye bɔ́ a: ");
INSERT INTO mcu_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Belà, mè né kɔɔ́ ye, béh nde né mé gèr te gò hên kwaré. Mɔ wulu, bàtô bɔ̂ seé seèn mene nde gi né dùà kum le, te béh liím nyegé ye dé beèh cio.» ");
INSERT INTO mcu_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Pɔ̂l né mene mân tueé, kwaá-taâb dé sâ táŋ ŋgwéh, à temé kwaá njií seér né te ŋgòr nùà fár-bàtô, bɔ̂ nùà bàtô. ");
INSERT INTO mcu_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nùàr ŋgún gwaán kela dé toò ndeê ndɔ. Lòù sam, cu veên baá ndeê, mɔ kwa lɔ bɔ́ ké te mgbáŋ sâ, bɔ́ nde né gèr ŋené. Bɔ́ ye, mɔ nde né bɔɔ́, te bɔ́ lege wa ké Fenîs te mgbáŋ bɔ̀ Kreétà bɔ̀ déì, te cu veên hèllè nde bɔ́ kwa seér ké teèn. Mgbáŋ sâ né seér kèb nyiìb mân. ");
INSERT INTO mcu_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Fu dɔlê yuoô kèb túnò ndɔ, yila kobô. Bɔ́ né mé njéh taáŋ ye, gò bɔɔ̀n nde né huɔɔ́m. Bɔ́ sɔm kùn ndɔ, bàtô yuo gò. Bɔ́ né Kreétà ke njií. ");
INSERT INTO mcu_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tètèì sam, fu tarê kobo yuoô kèb bà, tulu suagà yí te tòre, ");
INSERT INTO mcu_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","vela far seér bàtô, né béh dé lege keè taré yɔgɔ́, lu yuo mé béh. ");
INSERT INTO mcu_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Béh nde kela seér aá tàbè Kódà kèb túnò, te cií weh béh teèn. Sâ né bèh mé béh lé naâ mé gècên mene lege, te béh nde ye kɔm dé gàm mvelé sɔm. ");
INSERT INTO mcu_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bɔ́ tulu kaga kwaá njií ké ter sònò bàtô ndɔ. Bɔ́ né bàtô kaga nyegé, te ŋèrrè cú. Bɔ́ se si kwaá kùn dùà, te bàtô gɔ lie lòù, bɔ́ ye, mɔ sam, nde né te mbésebé ké kwarè Libî cu yilá ma. Fu mé béh kobo nde den baá-re méménâ. ");
INSERT INTO mcu_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Fu dé tarê hèllè béh yoòr ŋar yila cu ye baá-re dé gècên. Cieé yeé ŋaga baá, bɔ́ duɔɔ́m bɔ̀ seé dùà sɔm silí njiî. ");
INSERT INTO mcu_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Cieé ŋaga cu, bɔ́ yila njèh bàtô dùà mé be bɔɔ̀n sɔm su njiî. ");
INSERT INTO mcu_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Fu doô ye júée nyí ndɔ. Béh sɔɔ́ ké kunduŋ, béh cer; cieé mé cieé, lou bá ŋgwéh, nuaré déì mbentò mé njolo ŋéné cú ndɔ, dɔɔ́ŋ béh munó lom aá ye, béh kuú gi aá kèn. ");
INSERT INTO mcu_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Cieé kókoó mbaá, nuaá mé yieé sɔm yáb te bàtô teèn sam. Yeé baá ménâ, Pɔ̂l komo wuo ter toò bɔ̀ nùàr, ye bɔ́ a: «Belà, mɔ bí sé naâ sòn mò ŋgweé, béh sé naâ ké Kreétà den ŋgɔgɔ̂, béh sé gèr mé bɔ̀ njèh mân kùm lɔ́ ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mé njéh mene, mè né bí kènê tueé, bí táré sér yo. Lètenè beèh dɔɔ́ŋ nuaré déì kú ndé ŋgwéh, ŋerré lom nde né bàtô. ");
INSERT INTO mcu_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Cìlì Càŋ naâ mè cíbíteèn tueé; mè né beè Càŋ, mè hên bɔɔ́ yeé seé seèn ndɔ. Cìlì Càŋ naâ ká kwarè mò njebá ndeê, ");
INSERT INTO mcu_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ye mè a: Pɔ̂l, té vèh, kɔ wò wa ké toò mgbè Rɔ̂m waà. Bɔ̀ɔ́ mé né lè bàtô hên dɔɔ́ŋ, Càŋ mé húɔ́m-temé seèn nde né bɔ́ jomo yeè yili sɔm keéh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Pɔ̂l den cuù ye bɔ́ a: «Bí táré temé tarè belà! Mè né gi Càŋ mò kɔɔ́; à bɔɔ́ nde né faá à la naâ mè tueé nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Njèh cén, mɔ béh baá kwarè ten tàbè déì, béh nde né sòn nòmò karé sue le.» ");
INSERT INTO mcu_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Sâ béh ké dùà sâ bɔɔ́ baá cieé yulà cùɔ̀b nèà, fu né mé béh ké te ndèndèŋ nòmò faár ndeé den. Nòmò sâ bɔ́ yilá né Mediteranê. Te cieé yulà cùɔ̀b nèà sâ, yeé baá lɔgɔ̀teèn, bɔ̀ fár-bàtô bɔ̀ ŋgweé kɔ ndɔ, ye tàbè déì baá dìdì. ");
INSERT INTO mcu_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bɔ́ si yií mòù dùà, nde cor tàbè, sâ baá métà yulà tagár cùɔ̀b téhbeh. Bɔ́ né ka ndeé, wa berré déì, bɔ́ si yií cu mòù doô dùà, sâ yila le aá métà ndètoón cùɔ̀b téndelé. ");
INSERT INTO mcu_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bɔ́ yeé ŋene aá ménâ, bɔ́ se silí njií kùn dùà nèà, ye te gɔ den lilieé, wanɔɔ́ŋ bɔ́ nde né te kweéh déì ceén. Bɔ́ né cieé teèn lulú kela den ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Sâ né cu mé bɔ̀ fár-bàtô bɔ̀ lé fɔɔ́n naâ ceér teèn, ye te bɔ́ dula si lɔ bàtô. Yeé baá ménâ, bɔ́ se kwaá njií kɔm dé gàm dùà ndɔ, bɔ́ né bɔɔ́ faá bɔ́ nde né kùn ké te feh bàtô bɔɔ́ nyegé nɔ. ");
INSERT INTO mcu_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pɔ̂l yeé ŋene aá ménâ, ye kwaá-taâb mé bɔ̀ sɔ́jì a: «Mɔ bɔ̀ fár-bàtô bɔ̀ hên lè bàtô dèn lè ŋgwéh, bí nde gi né dùà kum le.» ");
INSERT INTO mcu_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bɔ̀ sɔ́jì nde kɔ tena sɔm yuií kɔɔ̀m ndɔ, kɔm hèllè kwar yuo. ");
INSERT INTO mcu_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Cieé yeé nde aá ŋagá, Pɔ̂l bɔŋ bɔ́, te bɔ́ yieé yáb, ye bɔ́ a: «Lan dɔɔ́ŋ baá cieé yulà cùɔ̀b nèà bí né mé lèì cùè den den. ");
INSERT INTO mcu_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bí yíé bá yáb yieè, te gam bí. Mè tueé bí, né mene yúlí feèh nuaré déì lèr nyì ndé ŋgwéh.» ");
INSERT INTO mcu_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔ̂l yeé tueé gi aá ménâ, à weh breêd ndɔ, à vra Càŋ teèn, à yila kɔlé yieê. ");
INSERT INTO mcu_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Yo taré cu ye bɔ́ dɔɔ́ŋ, bɔ́ yila baá-re yieê ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Béh lé naâ te bàtô nùà yuií fà mé yulà téhbeh cùɔ̀b ténjén. ");
INSERT INTO mcu_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Dɔɔ́ŋ bɔ́ yieé fulu gi, bɔ́ ŋuaán su njií yab dé jomò dùà, te bàtô líé cú. ");
INSERT INTO mcu_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Cieé ŋaga, bɔ́ ŋene tàbè ndɔ. Njèh cén, bɔ́ tàbè sâ ŋéné kɔ́ ŋgwéh. Bɔ́ ŋene njií mgbáŋ déì mé mbésebé mene, bɔ́ kaga lom aá ndòn ye, mɔ nde né bɔɔ́, bɔ́ lemé njií lom nde aá bàtô ké teèn ma. ");
INSERT INTO mcu_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yeé baá ménâ, bɔ́ kɔré tená sɔm yuií, bɔ̀ kùn sue le dùà, bɔ́ se yi pìlì ndɔ. Jomo sâ, bɔ́ daá kwaá cɔ̀gɔ̀ ké toò bàtô, te fu yila teèn, lu bàtô, bɔ́ lemé njií bú ké te mbésebê hèllè. ");
INSERT INTO mcu_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bɔ́ né ka ndeé, bɔ́ wa berré déì, mbésebé ŋgimé geé baá nòmò kpɔŋ fà, nòmò né bèh sâ kwar taré, kwar dɔm weh bàtô hèllè, feh nde cor nyue yila te mbésebê tég, gurú ŋgela le teèn, nòmò tulu ŋerré sɔm tií ké jomo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bɔ̀ sɔ́jì dé bɔɔ̀n ye, bɔ́ nde aá bɔ̀ gwà cibì bɔ̀ wulá sɔm, te bɔ́ gwágá dùlà yùò cú. ");
INSERT INTO mcu_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kwaá-taâb yeé ŋene aá ménâ, à yiín bɔ́, ye te nyí yili sɔm Pɔ̂l. Jomo sâ ye, bɔ̀ɔ́ mé né nòmò gwagá kɔɔ́ dɔɔ́ŋ a, lɔ́lé dìè gí dùà, bɔ́ gwagá kela toò ma. ");
INSERT INTO mcu_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bɔ̀ déì a, wèh béh-toû, bɔ́ gwagá mé njéh, bɔ̀ déì weh ten bàtô. Bɔ́ lé bɔɔ́ naâ ménâ, te béh nde ye dɔɔ́ŋ yili yuo. ");
INSERT INTO mcu_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Béh yeé yili yuo gi aá, te béh ŋgweé den ye yilí ten tàbè sâ, ye né Máltà. ");
INSERT INTO mcu_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bɔ̀ lɔɔ̂ bɔ̀ sâ weh lom béh mé vɔ́gɔ́-temé mene. Bɔ́ yeé ke, nu baá neé, dùlù baá dɔlé, bɔ́ fu kwaá béh we, bɔ́ bilí kwaá béh teèn, béh né ŋuagá den. ");
INSERT INTO mcu_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔ̂l nde kabe weh keém jaâr, à né tuar kwaá den. We yeé baá bɔgɔ́, ŋgòbò yuo kelà lè jaâr, à gwa sege le Pɔ̂l beè. ");
INSERT INTO mcu_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bɔ̀ lɔɔ̂ bɔ̀ yeé nde ŋene njií ménâ, bɔ́ duɔɔ̂m lètenè bɔɔ̀n tueé kuû, ye: «Nùà hên né lom nùà wúlá-feèh. À naá menè yí dùà mvelé yuo, à nde né kuú faá ndùàn Càŋ né bú yoòr nɔ.» ");
INSERT INTO mcu_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mé njéh mene, Pɔ̂l mele kaga si njií ŋgòbò hèllè tuar, njeré déì bú beè ŋgwèrrè nyì ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Sâ bɔ̀ lɔɔ̂ bɔ̀ dé bɔɔ̀n né lom kela, ye nde aá fulu; mɔ sam, Pɔ̂l nde aá mé njéh die kuú. Bɔ́ né ka ke den, bɔ́ ke ke, njeré déì Pɔ̂l bɔ́ ŋgwéh. Yeé baá ménâ, bɔ́ den cuù mé feh bɔɔ̀n, ye: «Nùà hên né càŋ.» ");
INSERT INTO mcu_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ké bèh sâ, lé naâ kwarè lɔɔ́ nùà koô te tàbè sâ, yilí seèn lé naâ Publiyûs. Nùà sâ feh béh bèh cèrrè ndɔ, béh cer ké teèn cieé tagár, à ke lom béh dé gècên. ");
INSERT INTO mcu_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Sâ tele seèn lé naâ baán ndɔ, à lé naâ mé dùlù yoòr, à lé naâ mbo sura ndɔ. Pɔ̂l yeé ŋgweé aá ménâ, à yɔŋ nde teèn, à dua Càŋ, à ba bú be felè, à taré sɔm bú. ");
INSERT INTO mcu_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Jomo sâ bɔ̀ beên bɔ̀ te ten tàbè sâ wa belê ndɔ, bɔ́ taré yuo gi. ");
INSERT INTO mcu_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","11","Béh cer ké sâ weéh tagár. Bɔ̀ lɔɔ̂ bɔ̀ né béh húɔ́m-temé bɔɔ̀n feh keéh. Béh yeé baá mé gò, bɔ́ bie béh gò mé njèh beè ŋgún. Jomo sâ béh yila cu bàtô déì, béh fɔɔ́n gò. Bàtô sâ lé yuoó naâ ké Alesandrî. Bɔ́ teèn nyagá kwaá né «Bɔ̀ càŋ huaán feèh”. À lé ké doó sâ du deén naâ, te cu dùlù gi. ");
INSERT INTO mcu_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Béh né ka ndeé, béh wa Sirakû, béh bɔɔ́ ké sâ cieé tagár. ");
INSERT INTO mcu_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Béh yuo cu ké sâ, béh nde Regiô. Cieé ŋaga fu déì kobo yuoô kèb túnò, weh sie béh beè; béh bɔɔ́ cegé cieé fà, béh yila Pùjɔ̂l. ");
INSERT INTO mcu_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Béh wa te lɔɔ́ sâ, béh kwa bɔ̀ Yeésò bɔ̀ déì teèn, bɔ́ yilá njií béh ké yoòr bɔɔ̀n, béh bɔ́ cer ké sâ cieé téhbeh. Jomo sâ béh fɔɔ́n gò Rɔ̂m. ");
INSERT INTO mcu_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Bɔ̀ Yeésò bɔ̀ dé ké Rɔ̂m yeé ŋgweé aá njàgà beèh, bɔ́ ndeè béh ceér dueè kwa weh. Bɔ̀ déì kela le béh ké bèh mé bɔ́ yilá né Gwà-mbè-tagár. Bɔ̀ déì ndeè kela béh ké tan Apiyû. Te Pɔ̂l yeé nde ŋene njií bɔ́ mân, à Càŋ vra lom mé be fà, yo taré cu bú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Béh yeé wa baá ké Rɔ̂m, bɔ́ ye Pɔ̂l a, ndé dèn bá dé seèn hiín, bɔ́ bú jomo kwaá lom aá sɔ́jì cén. ");
INSERT INTO mcu_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pɔ̂l cer cieé tagár, à yilá njií bɔ̀ *Jûf dé kokoô ké lɔ seèn. Bɔ́ yeé waà baá, ye bɔ́ a: «Bɔ̀ nùàr mò, mè ye te bí kɔ ye, bɔ́ lé mè ké Jerusalem sie kuú naâ dé lòù, bɔ́ haá njií mè beè bɔ̀ Rɔ̂m bɔ̀. Mè lé veên déì mé bɔ̀ nùàr beèh bɔ́ njí ná ŋgwêh, mè lé tòù bɔ̀ tele beèh kwá ná ŋgwêh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bɔ̀ Rɔ̂m bɔ̀ lé naá menè kwɔ̀m bieé, bèh saáb mé bɔ́ nde né mè teèn wulá, bɔ́ lé kwà ná ŋgwêh. Bɔ́ yeé nde aá mè yi njií, ");
INSERT INTO mcu_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","bɔ̀ Jûf ye, ndɔ́g ménâ bɔ́ ndé ŋgwéh ndɔ. Mè yeé ŋene aá ménâ, mè ye, mè ju mò njií seér nde né ké toò mgbè Rɔ̂m ma. Dèn ŋgwéh ye mè lé sâ sií naâ bɔ̀ nùàr beèh ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yeé baá mân, mè ye, kɔ mè yilá njiî bí ká toò, te bí kɔ ye, nùà mé dàm bɔ̀ *Iserálà bɔ̀ dɔɔ́ŋ né gi ndèm yoòr seèn kwaá njií doô, mè lè fɔ̀gɔ̀ lɔ̀ŋ hên cer kuú né felè seèn.» ");
INSERT INTO mcu_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bɔ̀ kokoô bɔ̀ hèllè ye bú a: «Bɔ̀ Judê bɔ̀ lé béh njeré déì felè yeè nyàgà njí ná ŋgwêh. Nuaré déì lé ké sâ yùò ná ŋgwêh, à ndeè béh ŋgòr veên déì felè yeè tueé ndɔ. ");
INSERT INTO mcu_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mɔ né mân, sâ béh gwaán né sònò yeè mé tie beèh ŋgweê. Lòù sam, béh né kɔɔ́ ye, bɔ̀ŋ dé mé wò né teèn sâ, bèh dɔɔ́ŋ bɔ́ né yeé bú bunó.» ");
INSERT INTO mcu_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bɔ́ bɔ̀ Pɔ̂l tena kwaá cieé ndɔ. Yeé baá loù sâ, bɔ́ komo waà ké gwò seèn kókoó mbaá, Pɔ̂l né bɔ́ njèh se, à se sɔɔ́ mé njéh tɔ́g wa liyilì. À né bɔ́ felè *Lò Càŋ tueé. Njií mé *sóú Músì tueé né felè Yeésò, à né bɔ́ se. Njií mé bɔ̀ *sòn-Càŋ bɔ̀ tueé né felè Yeésò, à né bɔ́ se ndɔ. À né ceér fɔɔ́n ye te nyí dɔr weh bɔ́ mé njéh. ");
INSERT INTO mcu_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","À yeé tueé gi aá, bɔ̀ déì kwaá njií temé teèn, bɔ̀ déì berɔ́ŋ seér lòù. ");
INSERT INTO mcu_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bɔ́ yeé baá lòù saán yuo ménâ, Pɔ̂l deên ndɔ, ye bɔ́ a: «Cúcuí Ŋagâ lɔ jue bɔ̀n. Cu mé à lé naâ bɔ̀ tele biì njèh sònò Esáyà sòn-Càŋ tueé keéh, ");
INSERT INTO mcu_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","à lé ye: Ndé yoòr bɔ̀ nùà hên, júée bɔ́ a: Dé felâ, bí nde gi né bagasé felá nyegé, bí seér ŋgwé ndé ŋgwéh lòù. Bí nde gi né bagasé ke den, ndɔ́g bí seér ŋéné kòmò ndé ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Lòù sam, temé bɔ̀ nùà hên baá gi lè maŋgwan, te bɔ́ mùnò kòmò cú. Bɔ́ duagá baá tie kèn, te bɔ́ mé tie ŋgwé cú. Bɔ́ lier aá njolo, te bɔ́ mé njolo ŋéné cú. Te bɔ́ ká yoòr mò ndé sér cû, te mè bɔ́ táré sɔ̀m cú ndɔ, jue mè Càŋ Dueè.» ");
INSERT INTO mcu_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔ̂l den cuù, ye bɔ́ a: «Bí kɔ́ɔ ye, Càŋ lé naâ bɔ̀ɔ́ mé Jûf sam ceér seèn feh keéh, te bɔ́ yili yuo. Dé bɔɔ̀n, bɔ́ nde né ŋgweé.»  ");
INSERT INTO mcu_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Te Pɔ̂l yeé nde tueé sɔm mân, bɔ̀ Jûf kem yuo, bɔ́ né lom mé njéh lètenè bɔɔ̀n ŋaáŋ ndeé. ");
INSERT INTO mcu_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔ̂l cer ké sâ nyèmà fà. À lé gwà sâ gwɔm beéh lòù ndɔ. Bɔ̀ nùàr lé naâ yoòr seèn ndeé, à né bɔ́ weh nyegé, ");
INSERT INTO mcu_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","à né bɔ́ felè *Lò Càŋ se, à né bɔ́ ŋgòr felè Yeésò *Kristò Fehtoò beèh feh. À bɔ́ njèh tueé ŋagá lom gùm dɔɔ́ŋ, à njeré déì vèh ŋgwéh.");
INSERT INTO mcu_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Né mè Pɔ̂l, nùà seê Yeésò *Kristò; mè né cu nuaá mé Càŋ lé balé weéh naâ ye te mè ŋa mbɔ̀ŋ tebê nyî, à jege haá mè Njàgà Bagaà seèn beè, ye mè a, ndé sè yɔ̀ŋ seè ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Càŋ lɔ naâ ndéb ter kwa kwaá, à tueé keéh sònò bɔ̀ sòn-seèn bɔ̀ ye nyí nde né Njàgà Bagaà sâ cie sɔm keéh; bɔ́ lé naâ te mvù nyagá kwaá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Né Njàgà Bagaà felè Ŋuna seèn, Fehtoò beèh Yeésò Kristò. À né *ndùté ndùtù Davîd kèb dé nùàr. ");
INSERT INTO mcu_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Kèb dé Cúcuî, à né Ŋunà Càŋ. Càŋ lé bú sie kwaá naâ kɔɔ́; à lé naâ bú te cio komo sɔm te feh keéh mé terreb mene ye, né Ŋuna nyî. ");
INSERT INTO mcu_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mè fùgò beè Càŋ hên kuú né mé yilí seèn; mè mbɔ̀ŋ tebê seèn ŋa né mé njéh ndɔ. Càŋ ye mè a: ndé ju seèn ké lètenè bɔ̀ nùàr mé gèh hihiné tueé bele, te bɔ́ kwaá njií lom temé cén yoòr seèn, bɔ́ ŋgweé sòn seèn, yilí seèn ŋgulí mé njéh. ");
INSERT INTO mcu_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","À jue né mé bí bɔ̀ Rɔ̂m bɔ̀ mene, Càŋ lé naâ bí yilá, te bí ŋa bɔ̀ nùàr Yeésò Kristò mân. ");
INSERT INTO mcu_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mè hên nyagá njií né mé bí bɔ̀ Rɔ̂m bɔ̀, bí bɔ̀ɔ́ mé temé Càŋ né yoòr biì dɔɔ́ŋ, à lé naâ bí yilá, te bí den bɔ̀ nùàr seèn. Càŋ Tele beèh bɔ̂ Fehtoò beèh Yeésò Kristò a, kúlú bí, bɔ́ haá bí dɔlê. ");
INSERT INTO mcu_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mè jɔ̀gɔ̀ felè biì dɔɔ́ŋ vra lɔgɔ́ née Càŋ ye; mè né bú jomo Yeésò Kristò vra keéh. Lòù sam, bí né temé yoòr Yeésò *Nùà Cɔ̀ŋ kwaá njií, ŋgɔ́g biì né wɔ́ŋ dɔɔ́ŋ ŋgulí ndeé. ");
INSERT INTO mcu_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bú Càŋ mé feh seèn né gi kɔɔ́, ye mè tueé né gècên, bú mé mè né seé seèn mé temé mò mene bɔɔ́, mè né Njàgà Bagaà felè Ŋuna seèn se doô: à né kɔɔ́ ye mè né yeé nyí felè biì cu dɔɔ́ŋ dua den. ");
INSERT INTO mcu_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mè né bú dua, ye bú a, mé húɔ́m-temé seèn, à há mè lɔ́ŋ mé be seèn, te mè ndeè ké yoòr biì ma. ");
INSERT INTO mcu_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Wanɔɔ́ŋ mè né mé tuaá biì kela, mè ndeè né bí gà seé Cúcuí Càŋ feh, te bí kwa nyegé terreb mé njéh. ");
INSERT INTO mcu_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mè tétég gwaán né ké lètenè biì deèn, te yo taré mè, taré bí, te yo taré gi béh bí felè temé cên mé béh né yoòr Càŋ kwaá njií hên dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Belà, mè ye te bí kɔ ye, cu dɔɔ́ŋ mè né gò ké yoòr biì gwaán sɔɔ́, mè lɔ́ŋ kwà ŋgwéh lòù. Mè ye te seé mò wa tàb ké lètenè biì, faá né lètenè bɔ̀ nùàr lè tàbè déì waá ndeé nɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kɔ mè né ménâ bèh dɔɔ́ŋ bɔɔ́ ndeé; seé mò né cí. Né mene lètenè bɔ̀ɔ́ mé cer yeé lɔ, mé ya dueè mene; lètenè bɔ̀ kɔ́gɔ̀n bɔ̀ mé bɔ̀ cùr mene, kɔ mè né ménâ bɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Mè gwaán né mé Njàgà Bagaà ké Rɔ̂m lètenè biì se waâ dé cî. ");
INSERT INTO mcu_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mè tueé bí, Njàgà Bagaà né mè yoòr sagár: à né mé terreb Càŋ yoòr, te à yili sɔm bɔ̀ɔ́ mé né temé yoòr Yeésò *Kristò kwaá njií; duɔɔ̂m né mé bɔ̀ Jûf, nde mé bɔ̀ɔ́ mé Jûf sam. ");
INSERT INTO mcu_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mɔ né mân, sâ Njàgà Bagaà né seé Càŋ cie feh kwaá; à feh kwaá né nùàr gèh dé mé Càŋ nde né bú nùà dilî teèn yilá keéh. Gèh dé sâ né lom temé yoòr Yeésò Kristò kwaá njiî, ceér déì toò sam cuú. Né te mvù Càŋe ménâ nyagá den ndɔ, ye: «Nuaá mé ŋa né nùà dilî beè Càŋ mé temé cén yoòr seèn kwaá njiî dɔɔ́ŋ, kwa nde né yɔ̀ŋ kɔɔ́.» ");
INSERT INTO mcu_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Bí kɔ́ɔ ye, Càŋ ké te vulúu baá bèsɔ́nè feh kwaá, ye nyí né mé yúlá-temé felè veên hihiné mé bɔ̀ nùàr né bɔɔ́ doô; bɔ́ né bɔ̀ seé vevenê bɔɔ̀n hèllè bɔɔ́, bɔ́ né gècên nyî mé njéh doó dobó baré njií, bɔ́ nyí vèh cú. ");
INSERT INTO mcu_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kèkènè seé Càŋ mé bɔ́ sé naâ Càŋ mé njéh ŋené kɔɔ́, Càŋ né mene bɔ́ bèsɔ́nè mé feh seèn feh keéh, mé njéh mene bɔ́ ŋéné kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Á sâ, bèh lɔ mé Càŋ lɔ sií naâ wɔ́ŋ, bɔ́ mene bú mé njolo ŋéné ŋgwéh, kèkènè seé seèn né yeé cie ŋené ŋagá, ye né Càŋ terrèb, Càŋ ndeèr ma. Mɔ bɔ́ mân gwàn ŋgwéh, sâ bɔ́ mé sòn toò seèn sam ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bɔ́ né mene Càŋ ŋené kɔɔ́, bɔ́ bú sén ŋgwéh, bɔ́ bú vrà ŋgwéh faá bɔ́ sé naâ bú vra ye à né Càŋ. Yeé baá môn, bɔ́ duɔɔ́m baá-re lòù munó ndegé seêr, bɔ́ né te cibi ndugó faáŋ ndeé. ");
INSERT INTO mcu_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wa bɔ́ né bɔ̀ kɔ́-njèh bɔ̀ sé wa, sâ kùlù mé bɔ́ lɔ jueè ceré né bɔ́. ");
INSERT INTO mcu_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bɔ́ lɔɔ̀ né gùm Càŋ Ndeèr Nùà *sùsùm duaà, bɔ́ nde cècàŋ bɔɔ́ kwaá, bɔ́ dua seér cí; bɔ̀ déì fela né nùàr, mé né ká lè wɔ́ŋe wàn mbaá; bɔ̀ déì fela né non, bɔ̀ déì fela nyam, bɔ̀ déì sàb; dɔɔ́ŋ bɔ́ né gi bɔ́ dua ndualé gɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Yeé baá mân, Càŋ sɔm be seèn yoòr bɔɔ̀n ndɔ, te bɔ́ teré yila kɔ te núlu, faá bɔ́ né gwaán sâ nɔ, te bɔ̀ dé kàn mé dé kân loró den mé fegùlì yoòr ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bɔ́ bɔɔ̀n naâ gècên Càŋ kwaá lɔɔ́, bɔ́ gwaán seér nyeén. Càŋ mé lɔ sií naâ njèh dɔɔ́ŋ, bɔ́ né bú kwaá lɔɔ́, bɔ́ né njií mé à lɔ sií naâ lòù dua seér. Ŋgweéh bɔ́ sé la dua seér né bú wa? È môn. ");
INSERT INTO mcu_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Càŋ yeé ŋene aá ménâ, à sɔm be yoòr bɔɔ̀n ndɔ, te bɔ́ loró kwaá nyegé bɔ̀ njèh fegùlì sâ mé njéh yoòr bagasé. Bɔ̀ véh bɔɔ̀n nde né mé feh bɔɔ̀n kweéh seér: bɔ́ bɔ̀ siíb kɔɔ́ cèr ndé cú, bɔ̀ véh cer seér nde aá bɔ̀ mbaábɔn kɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bɔ̀ siíb gwàn ndé cú bɔ̀ véh ceèr ndɔ, tuaá sie seér nde aá bɔ́ mé bɔ̀ siíb mbaábɔn ceèr. Bɔ̀ nùàr mân bɔɔ́ sabé gɔ né te bɔ̀ dé kàn mé dé kân loró le gi léláŋ fegùlì, bɔ́ tulu su dùkàŋ yoòr mé be bɔɔ̀n; né sòn veên mé bɔ́ né bɔɔ́ gɔ sâ. ");
INSERT INTO mcu_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Bɔ́ yeé berɔ́ŋ baá Càŋ ménâ, Càŋ sɔm be yoòr bɔɔ̀n ndɔ, à kwaá lɔ bɔ́ mé lo mapelîm bɔɔ̀n sâ, te bɔ́ bɔɔ́ seér njií mé bɔ́ sé lé bɔ́ ná ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Yeé baá ménâ, bɔ́ gela den baá-re mé gèh veên hihiné lè dedeí ndɔ: dene gogobô o, temé te njèh nùàre kwaá njiî o, jéré-temé o, huer o, wúlá-feh o, jɔ́gɔ́ o, tánágá o, jélá-temé o, dɔɔ́ŋ né seé bɔɔ̀n. Bɔ́ né sòn tuagá sar gɔ, ");
INSERT INTO mcu_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","bɔ́ né bɔ̀ njèh vevenê lètenè bɔɔ̀n yoòr tueé su kuú, bɔ́ né Càŋ bunó, bɔ́ né bɔ̀ mbaábɔn selé, bɔ́ né feh ham, bɔ́ né punó, bɔ́ né bɔ̀ veên dé fefeê munó fɔɔ́n gɔ, bɔ́ sòn bɔ̀ tele mé bɔ̀ meí ŋgwé cú ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bɔ́ baá gi mé ndòn kukuû mân, bɔ́ faá bɔ́ tueé kwaá yeé nɔ bɔ́ wá cú, bɔ́ baá gi bɔ̀ maŋgwan, bɔ́ jere bɔ̀ mbaábɔn kɔ́ cú. ");
INSERT INTO mcu_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bɔ́ né gi ndéb Càŋ kɔɔ́ nyegé, ye bɔ̀ɔ́ mé né gi gèh bɔ̀ njií hên bɔɔ́ wa, sàgà bɔɔ̀n né yeé cio ma. Bɔ́ né mene mân kɔɔ́, mé njéh mene bɔ́ né cu bɔɔ́ ŋeí. Nuaá mé né lòù bɔɔ́ sabé seér dɔɔ́ŋ, bɔ́ vela seér cu bú be lòù. ");
INSERT INTO mcu_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Mɔ né mân, sâ wò nuaá mé né ju felè bɔ̀ mbeî tená gɔ doô, wò né mene neì, wò né beè ndɔ. Wò yeè ju felè bɔ̀ mbeî tena né kɔɔ́. Wò yeé tena gi aá, wò né cu ménâ bɔɔ́ taré, sâ ju wò sìè ndé ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Béh né kɔɔ́ ye, bɔ̀ɔ́ mé né veên faá bèh ménâ bɔɔ́, Càŋ ju felè bɔɔ̀n tena lom yeé jéjég. ");
INSERT INTO mcu_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Sâ, wò nuaá mé né ju felè bɔ̀ déì tená sâ, wò né munó ye nyí nde né ju beè Càŋ mvelé wa? Ŋgweéh seé yeè né taré cí mà. ");
INSERT INTO mcu_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Mè tueé wò, wò né sèŋ mé bɔ́-bagaà Càŋ seb, wò né húɔ́m-temé seèn seb ndɔ. Wò kɔ́ ŋgwéh ye Càŋ nyí bagaà ménâ bɔɔ́ den né, te cieé déì nyí kweéh seér dene nyî wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kɔ̀cɔ̀, taŋgwan temê mé kwéh sér bèh. Wò meì bɔ̀ gèr felè yeè mé be yeè nyegé kwaá baá kèn. Loù mé ŋá-temé Càŋ nde né bèsɔ́nè yuo kelá, à nde né ju jéjêg tená, ju nde né wò sie. ");
INSERT INTO mcu_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","À sàgà nùà kàn mé nùà kân loù sâ gwɔm nde né mé seé seèn. ");
INSERT INTO mcu_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bɔ̀ɔ́ mé né be mé seé bagaà kwaá njií, ye bɔ́ né ŋgùlù Càŋ kela, wa bɔ́ gwaán né nùàr beè Càŋ ŋaâ, te bɔ́ kwa yɔ̀ŋ tètàgà doô, yɔ̀ŋ tètàgà loù sâ kwa nde né bɔ́. ");
INSERT INTO mcu_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Dé bɔ̀ taáb bɔ̀ seèn, à yúlá-temé seèn tieé su njií nde né yoòr bɔɔ̀n. Né bɔ̀ dúágá-tie bɔ̀ mé né ceér gècên kwaá lɔɔ́, bɔ́ sabé bele seér bɔ̀ njèh vevenê doô. ");
INSERT INTO mcu_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mé bɔ̀ vevenê bɔ̀ dɔɔ́ŋ, bɔ́ meì bɔ̀ gèr loù sâ ŋene nde né fî. Duɔɔ́m nde né yoòr bɔ̀ *Jûf, jomo sâ yoòr bɔ̀ɔ́ mé Jûf sam. ");
INSERT INTO mcu_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Dé bɔ̀ bebagaà bɔ̀, Càŋ nde né bɔ́ faá nùàr nɔ weh kwaá, à yií njií bɔ́ te ŋgùlù seène, à haá bɔ́ dɔlê. Duɔɔ́m nde né yoòr bɔ̀ Jûf, jomo sâ bɔ̀ɔ́ mé Jûf sam ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Lòù sam, Càŋ dé seèn nùàr lòù gèì bèh. ");
INSERT INTO mcu_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bɔ̀ɔ́ mé lé naá giì veên bɔɔ́, mé *sóú Músì kɔ́ ŋgwéh dɔɔ́ŋ, bɔ́ ju bɔɔ̀n mé sóú Músì téná ndé ŋgwéh; dé bɔɔ̀n veên bɔɔ̀n sie nde né bɔ́ kɔɔ́. Bɔ̀ɔ́ mé lé naâ veên mé sóú Músì lè bɔɔ́ dɔɔ́ŋ, bɔ́ ju bɔɔ̀n tena nde né mé sóú Músì ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Lòù sam, mɔ nùàr nde né nùà dilî beè Càŋ ŋaá, kɔ à sóú jolo komo mé gùm mene, dèn ŋgwéh mé sóú mbaá ŋgweé faáŋ njiî. ");
INSERT INTO mcu_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mɔ bɔ̀ɔ́ mé Jûf sam né sóú mbaá jolo weh, bɔ́ kɔ́ ŋgwéh ye né sóú Músì, sâ bɔ́ né gi feh keéh ye sóú sâ né bɔ́ lè húɔ́me. ");
INSERT INTO mcu_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Sâ bɔ́ teèn ménâ feh keéh né ye, njií mé sóú né taga doô né lè bɔɔ̀n nyagá den ndɔ ma. Ndòn bɔɔ̀n tueé den baá-re bɔ́ ménâ ndɔ; cu déì né bɔ́ lòù ki seér, cu déì à den seèn nɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Bí kɔ́ɔ ye, loù mé Càŋ kwaá lɔ nde né ju beè Yeésò *Kristò teèn, bɔ̀ njií hên dɔɔ́ŋ nde giì né cie ŋené yuo kelâ, ŋené yuo kela nde né faá Njàgà Bagaà sònò mò hên tueé den nê nɔ. Loù sâ Càŋ ju tena nde né mé felè bɔ̀ njií mé né lè nùàr leér den mene. ");
INSERT INTO mcu_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Wò nùà Jûf dé yeè, yilí yeè né Jûf, wò né gi sóú kɔɔ́, wò yieé né mé njéh, wò ŋueé mé njéh, yo yeè né gi mé yilí Càŋ sagár. ");
INSERT INTO mcu_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Njií mé Càŋ gwaán nê dɔɔ́ŋ, wò né gi kɔɔ́, sóú né gi wò feh, te wò ŋene kɔ njèh bebagaà. ");
INSERT INTO mcu_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Wò ye, wò né bɔ̀ tácugó ceér feh, wa wò né ŋagâ toò bɔ̀ cibi bɔ̀ ndɔ; ");
INSERT INTO mcu_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wò ye nyí bɔɔ́ dilí né bɔ̀ cùr ceér kɔɔ́, wa nyí né bɔ̀ huaán tetɔɔ̂r njèh feh, te bɔ́ ŋene kɔ ceér Càŋ. Ŋgweéh wò ye mé sóú sâ nyí kɔgɔ́n gi aá, nyí baá gi mé gècên teèn wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Sâ kè cú-re! Wò nuaá mé né bɔ̀ déì feh hèllè, kei mé bɔɔ́ wò yeè gùm yeè nùà njèh teèn fèh kéh ŋgwéh wa? Wò ye bɔ̀ nùàr a: té yíb ŋúɔ́b; wò dé yeè ŋuɔb né dé keì wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wò ye bɔ̀ nùàr a: té yàgà ndé; wò dé yeè yàgà nde né dé keì wa? Wò ye bɔ̀ nùàr a: cècàŋ duaà né lom ve. Bɔɔ́ né naàn mé wò né lè mɔ̀ bɔɔ̀n yilá ndeé, wò né njèh teèn kema wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wò né sagár nyegé ye nyí né mé sóú Càŋ lè, wò kɔ́ ŋgwéh ye, nyí né bú lòù kwaá seér wa? Wò sé yeé baá méménâ bɔɔ́, ŋgweéh sâ wò bɔɔ́ gulí né Càŋ nùà njèh wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Né te mvù Càŋe môn nyagá den ndɔ, ye: «Bɔ̀ nùàr yilí Càŋ hên dɔɔ́ŋ bɔɔ́ beéh keéh né mé yìè biì bɔ̀ Jûf.» ");
INSERT INTO mcu_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Bí ŋgwé mè tueé bí felè *ŋgór ŋɔɔ̂b. Mɔ bí né sóú jolo komo, sâ ŋgór ŋɔɔ̂b né njèh gàm. Mɔ bí né sóú kwaá, sâ mɔ bí ŋɔb mene ŋgór, bí née den ka faá kurú nɔ. ");
INSERT INTO mcu_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Cu sâ ndɔ, mɔ kurú déì né dé seèn sóú jolo kɔɔ́, sâ Càŋ bú faá nuaá mé ŋɔb aá ŋgór nɔ yílá ndé ŋgwéh wa? ");
INSERT INTO mcu_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mè tueé bí, nuaá mé né sóú jolo kɔɔ́, bɔ́ mene bú ŋgór ŋɔ́b ŋgwéh, nde né wò mé ju sie, wò nuaá mé sóú jòlò kòmò ŋgwéh hèllè. Wò né mene mé sóú yeè sâ beè, bɔ́ ŋɔb mene wò ŋgór, ju nde né wò sie den. ");
INSERT INTO mcu_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Mè tueé wò, nùà Jûf dé gècên, bɔ́ bú te léláŋ mvum njolò ŋéné lòm ŋgwéh. *Ŋgór ŋɔɔ̂b gí cégé ŋgwéh mé ŋgàŋ yoòr mbaá ŋɔɔ́b kuû ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nùà Jûf dé gècên né seér nuaá mé né Jûf yí lè, à dé seèn ŋgór ŋɔb seér né temé seèn. Gèh ŋgór dé sâ Cúcuí Càŋ ŋɔb né bú kɔɔ́, dèn ŋgwéh sóú mé bɔ́ nyagá né lòù. Nùà Jûf dé gècên sâ, Càŋ seén nde né bú kɔɔ́ ndɔ, dèn ŋgwéh nùàr. ");
INSERT INTO mcu_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Á sâ, mè né mene *Jûf, né cu gam wa? Ŋgór ŋɔɔ̂b né cu njeré déì gam ndɔ wa? ");
INSERT INTO mcu_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Gàm né lom ŋgún mbaá. Lòù sam, Càŋ lé ŋgòr seèn haá kwaá naâ beè bɔ̀ Jûf. ");
INSERT INTO mcu_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Á, mɔ lètenè bɔɔ̀n bɔ̀ déì teèn dìlì ŋgwéh nɔ, sâ béh tueé nde né naàn? Sâ Càŋ dé seèn dilísé dèn ndé cú wa? ");
INSERT INTO mcu_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ndɔ́g, dé sâ seèn môn bɔ́ ndé ŋgwéh! Dé Càŋ, à njebá taré lom nde né te gècên seèn-e tég, gwaán bɔ̀ nùàr a dèn gí léláŋ bɔ̀ nyeén bɔ̀. Né faá bɔ́ nyagá kwaá né te mvù Càŋe nɔ, ye: «Gwàn dé mé wò den nùà njêŋ faá wò tueé nê nɔ; mɔ bɔ̀ nùàr ye te ju sie wò, te wò yɔgɔ́ bɔ́.» ");
INSERT INTO mcu_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mɔ veên mé béh né bɔɔ́ hên feh seér cu né kɔɔ́, ye bɔ̀ nùàr a: Càŋ né dé seèn Nùà gècên, sâ béh sònò tueé cu nde né kei wa? Mɔ béh né veên bɔɔ́, Càŋ béh gèr feh keéh né mé njéh, sâ bí ye Càŋ teèn bɔ́ yí ŋgwéh wa? Bɔ̀ nùàr né ye mân bie seér; mè jue né cí. ");
INSERT INTO mcu_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Mè tueé bí, Càŋ bɔɔ́ yií né teèn. Mɔ sam, à sé la ju felè wɔ̂ŋ tena né naàn wa? ");
INSERT INTO mcu_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mɔ nyeén beèh hèllè feh den né ka gècên Càŋ kɔɔ́, te gam bɔ̀ nùàr, bɔ́ seén nyegé Càŋ mé njéh, sâ Càŋ seèn béh mé ju sie cu nde né dé keì? ");
INSERT INTO mcu_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Á sâ, kei mé yiín cu nde né béh veên bɔɔ̂ kɔɔ́ ndɔ wa? Sâ béh júée ye: béh bɔ́ lòm veên bɔɔ̀, nde né dé bagaà sâ ŋaá seér. Bɔ̀ déì né mè yoòr tueé kwaá, ye mè né yeé môn tueé sé wa. Kwá nɔɔ́ŋ, Càŋ nde né bɔ́ gèr feh keéh, à bɔ́ feh keéh nde né faá seé bɔɔ̀n tueé nê nɔ. ");
INSERT INTO mcu_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Mɔ né mân, béh bɔ̀ *Jûf, béh né cu bɔ̀ nuaré déì yɔgɔ́ wa? Ndɔ́g! Mè la naá giì tueé ŋagá ye: né mene Jûf, mene Jûf sam, dɔɔ́ŋ bɔ́ né gi kwer veên ma. ");
INSERT INTO mcu_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Né te mvù Càŋe môn nyagá den ndɔ, ye: «Nuaá mé né sɔm nùà dilî, ndɔ́g teèn sam. ");
INSERT INTO mcu_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nuaá mé né ŋgweé kɔɔ́, teèn sam. Nuaá mé né Càŋ fɔɔ́n, teèn sam ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bɔ́ sabé nde gi aá bèh dàbe, bɔ́ toò leér le gi aá kèn. Ndɔ́g nuaá mé né seé bagaà bɔɔ́, né mene cén tà cén, teèn yùò kélá ŋgwêh. ");
INSERT INTO mcu_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Bɔ́ né gi mé tɔgɔ lɔŋ faá sà lɔɔ̀ŋ nɔ; bɔ́ né mé leba fèfà; ŋgòr né lom bɔ́ sònò faá ndìèm sàb nɔ faám yuo ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Sòn den né bɔ́ beè faá nó nɔ, né lom léláŋ njèh duagâ. ");
INSERT INTO mcu_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Tètèì sam, bɔ́ baá feh wulá. ");
INSERT INTO mcu_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bèh mé bɔ́ né kelá dɔɔ́ŋ, bɔ́ né dùkàŋ bɔ̂ gèr teèn we su lɔɔ́. ");
INSERT INTO mcu_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bɔ́ ceér dɔlê ŋéné kɔ́ ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bɔ́ Càŋ vèh bèh ndɔ.» ");
INSERT INTO mcu_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Béh né kɔɔ́ ye njií mé mvù sóù né tueé dɔɔ́ŋ, à tueé njií né mé bɔ̀ɔ́ mé né ka sóù. Mɔ né ménâ, sâ nuaá mé nde né Càŋ tueé ye bú a, nyí ceér kɔ́ ŋgwéh teèn sam; te dàm bɔ̀ nùàr wɔ́ŋ dɔɔ́ŋ die gi ju beè seèn ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nùàr a, jòlò kɔ́ mene sóú gèh dé heè, Càŋ bú nùà dilî ké toò seèn mé njéh yílá ndé ŋgwéh. Sóú feh lom né dé seèn dé feèh, ye nùàr a: wò né mé veên yoòr ma. ");
INSERT INTO mcu_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kènê ceér dé feê ŋené yuo kelà baá cie kèn; né ceér mé béh ŋa gi nde né bɔ̀ didilî bɔ̀ beè Càŋ mé njéh. Ceér bú sâ dé seèn jomo sóù kélá sér ŋgwéh. Mvù sóù bɔ́ bɔ̀ *sòn-Càŋ bɔ̀ lé naâ toò mân tueé taré ndɔ, ye: ");
INSERT INTO mcu_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Càŋ bɔ̀ nùàr ké toò seèn bɔ̀ didilí bɔ̀ yilá lom né mé temé yoòr Yeésò *Kristò kwaá njiî. Bɔ̀ɔ́ mé né temé yoòr seèn kwaá njií dɔɔ́ŋ, à né gi bɔ́ yilá, à dé seèn mé gwèn sam, nùàr dɔɔ́ŋ né gi beè seèn kèì cén. ");
INSERT INTO mcu_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Nùàr dɔɔ́ŋ naá giì veên bɔɔ́. Yeé baá ménâ, bɔ́ kwarè Càŋ *sùsùm dèn cú. ");
INSERT INTO mcu_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Càŋ yeé ŋene cu aá môn, à yili sɔm bɔ́ mé Yeésò Kristò, à sie seér bɔ́ bɔ̀ didilî bɔ̀ mé húɔ́m-temé seèn, dé lòù ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Càŋ lé sɔm kwaá naâ Yeésò faá njèh *sèmè nɔ, te à kuú sòn beèh, te à yaga sɔm béh veên yoòr mé húɔ́m seèn. Càŋ ceér bú hên feh keéh né mé bɔ̀ɔ́ mé né temé yoòr Yeésò Kristò kwaá njií, te bɔ̀ nùàr ŋene kɔ, ye nyí né Càŋ mé né dilísé. Bɔ̀ɔ́ mé lé naâ veên léí toò bɔɔ́, à lé bɔ́ gèr mé njéh fèh kéh ná ŋgwêh, ");
INSERT INTO mcu_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","à lé yolo seér naâ dé yolô. Dé kènê à feh keéh né bèsɔ́nè ye: nyí né Càŋ mé né dilísé ma, te bɔ́ ŋene kɔ ye bɔ̀ɔ́ mé né temé yoòr Yeésò kwaá njií dɔɔ́ŋ, nyí né bɔ́ bɔ̀ didilí bɔ̀ sie seér ndɔ ma. ");
INSERT INTO mcu_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Sâ kènê bɔ̀ nùàr né cu mé ceér púnò déì toò teèn wa? Dé sâ ndɔ́g! Càŋ béh bɔ̀ didilí bɔ̀ yilá né felè temé cén mé béh né yoòr Yeésò kwaá njií doô; dèn ŋgwéh mé sóú beleè. ");
INSERT INTO mcu_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Béh kɔ né ye Càŋ nùàr nùà dilî ké toò seèn yilá lom né mé temé seèn yoòr Yeésò kwaá njiî, dèn ŋgwéh mé sóú bele komoò; ");
INSERT INTO mcu_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","wanɔɔ́ŋ sâ Càŋ sé la gi lom né dé bɔ̀ Jûf, à sé la dé bɔ̀ nuaré déì ná cû. Mè tueé bí, Càŋ né Càŋ, à né dé bɔ̀ nùàr dɔɔ̂ŋ, ");
INSERT INTO mcu_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Càŋ Dueè né lom cén, sâ gi aá. Mɔ bɔ̀ Jûf né temé yoòr Yeésò kwaá njií, sâ à nde né bɔ́ bɔ̀ didilí bɔ̀ ké toò seèn yilá. Nde cu né mé bɔ̀ɔ́ mé Jûf sam ménâ ndɔ; mɔ bɔ́ né gi temé kwaá njií taré, à nde né bɔ́ bɔ̀ didilî bɔ̀ ké toò seèn yilá ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Á sâ, sóú nɔ? Mɔ béh baá temé yoòr Yeésò kwaá njií, sâ béh ye, sóú njeré déì gàm cú wa? Môn sam; béh né kɔɔ́ ye, sóú né mé bèh seê dé seèn teèn. ");
INSERT INTO mcu_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Béh felè Abrahâm tele beèh léí jɔ̀gɔ̀ tueé nde né naàn wa? À lé beè Càŋ kwaá naâ kei wa? ");
INSERT INTO mcu_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Mɔ Abrahâm sé beè Càŋ nùà dilî ŋaà naâ mé seé seèn, à sé naâ mé lɔ́ŋ toò Càŋ punô teèn. Á, lé seèn môn ná ŋgwêh, sâ à mé lɔ́ŋ toò Càŋ punô sam gùm dɔɔ́ŋ. ");
INSERT INTO mcu_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Te mvù Càŋe né bèsɔ́nè nyagá den ye: «Abrahâm lé naâ temé cén yoòr Càŋ kwaá njií; Càŋ lé bú nùà dilî yilá naâ mé njéh.» ");
INSERT INTO mcu_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Béh né kɔɔ́ ye nùà seê nde né sàgà seé seèn kwa; dé sâ dé lòù sam, né ka sàgà seê. ");
INSERT INTO mcu_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Dé nuaá mé né ndèm mé Càŋ kwaá njií, ye Càŋ né ju felè bɔ̀ vevenê bɔ̀ mé jere mene tená, à seé bɔ́ ná ŋgwêh dɔɔ́ŋ, Càŋ nde né temé mé à né yoòr seèn kwaá njií doô ŋené, à bú nùà dilî yilá nde né mé njéh. ");
INSERT INTO mcu_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","*Davîd lé tueé naâ felè gèh nùà bú sâ, ye: ");
INSERT INTO mcu_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Samésé né bɔ̀ɔ́ mé Càŋ kulu sɔm gi aá bɔ́ veên yoòr kèn! Bɔ́ lé naá menè *sóú kwaá, à lé naâ dèh doó kulú njií. ");
INSERT INTO mcu_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Samésé né nuaá mé Nùà Dueè veên seèn lè sìè kwá ŋgwéh ndɔ!» ");
INSERT INTO mcu_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Á sâ, gèh samésê bú hên gi lom né dé bɔ̀ɔ́ mé naâ *ŋgór ŋɔɔ́b wa? À dé bɔ̀ kurû sam wa? Mè tueé bí, né mé bɔ̀ kurú mene. Béh la naâ jɔ̀gɔ̀ tueé ye, Càŋ lɔ Abrahâm nùà dilî yilá naâ mé temé yoòr seèn kwaá njiî. ");
INSERT INTO mcu_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Á sâ, lɔ naâ heèh wa? Lɔ naâ sâ bɔ́ ŋɔb gi aá Abrahâm ŋgór wa, sâ bɔ́ née bú ŋɔ́b ŋgwéeh ye wa? Mè tueé bí, lɔ naâ sâ bɔ́ née bú ŋgór ŋɔ́b ŋgwéeh ye, te jomo sâ bɔ́ nde ye bú ŋɔɔ́b den. ");
INSERT INTO mcu_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Bɔ́ lɔ ndeè Abrahâm ŋgór ŋɔɔ́b, sâ baá gi ká jomo mbaá, te feh keéh lòù, ye Càŋ lɔ bú nùà dilî yilá naâ mé temé seèn yoòr seèn kwaá njiî, sâ bɔ́ née bú ŋgór ŋɔ́b ŋgwéeh ye ma. Yeé baá ménâ, Abrahâm ŋa tele bɔ̀ɔ́ mé né gi temé yoòr Càŋ kwaá njií ndɔ, bɔ́ mene bɔ́ ŋgór ŋɔ́b ŋgwéh; Càŋ ye bɔ́ né gi bɔ̀ didilî bɔ̀ beè nyî ma. ");
INSERT INTO mcu_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abrahâm né cu tele bɔ̀ɔ́ mé ŋɔb gi aá ŋgór kèn ménâ ndɔ. Njèh cén, kɔ bɔ́ né temé cén yoòr Càŋ faá Abrahâm nɔ kwaá njií. Lòù sam, tele beèh Abrahâm lé naâ temé yoòr Càŋ kwaá njií, te bɔ́ nde ye bú ŋgór ŋɔɔ́b. ");
INSERT INTO mcu_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Càŋ lɔ kwa kwaá naâ Abrahâm bɔ́ bɔ̀ ndùté ndùtù seèn ndéb tieè, ye bɔ́ a: ŋgúlú bɔɔ̀n nde né wɔ́ŋ dɔɔ́ŋ ma. Càŋ lɔ ndéb sâ kwá ná ŋgwêh ye Abrahâm né *sóú bele komo. À lé ndéb kwa njií seér naâ felè temé mé Abrahâm lé kwaá njií naâ yoòr seèn, à ŋa nùà dilî mé njéh doô. ");
INSERT INTO mcu_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mɔ ŋgúlú sé kwa cegé né bɔ̀ɔ́ mé né sóú jolo kɔɔ́, ŋgweéh sâ temé mé béh né yoòr Càŋ kwaá njií hên sé né dé lòù, ndéb Càŋ sé né njèh mbaâ ndɔ mà. ");
INSERT INTO mcu_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bí kɔ́ɔ ye, sóú bɔɔ́ yeé kɔɔ́, te temé ŋaá Càŋ lè, ye bɔ̀ nùàr jéjég faá sóú tueé nê nɔ, bèlè bèh. Á sâ, mɔ sóú teèn sam, bɔ́ nde né sóú kwaá wa? ");
INSERT INTO mcu_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Càŋ lé ndéb kwa kwaá naâ felè temé yoòr seèn kwaá njiî, te ŋgúlú sâ ŋa njií mé nyí haá né dé lòù, te den njèh gàm dé bɔ̀ ndùté ndùtù Abrahâm dɔɔ́ŋ; dèn cégé ŋgwéh dé bɔ̀ɔ́ mé né sóú bele kɔɔ̂, te ŋa dé bɔ̀ɔ́ mé kwaá njií né temé yoòr Càŋ faá Abrahâm nɔ. Lòù sam, Abrahâm né tele beèh, béh dɔɔ́ŋ, ");
INSERT INTO mcu_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","faá né te mvù Càŋe nyagá den nɔ, ye: «Mè sie kwaá baá wò tele cìlì nùàr ŋgûn.» À né tele beèh ké toò Càŋ, Nuaá mé à lé kwaá njií naâ temé yoòr seèn doô; né Càŋ mé komo sɔm yeé bɔ̀ komó te cio kɔɔ́. Bɔ̀ njií mé lé teèn ná ŋgwêh dɔɔ́ŋ à lé si giì naâ bɔ́ kɔɔ́ ndɔ. ");
INSERT INTO mcu_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Mɔ lɔ den mene beè Abrahâm faá à ndéb Càŋ kwà ndé cú, mé njéh mene à lé naá loôm temé cén yoòr Càŋ kwaá njií. Yeé baá mân, à ŋa baá-re tele cìlì nùàr ŋgûn faá Càŋ lé tueé naâ nɔ; sâ Càŋ lé ye bú a: «Bɔ̀ŋ bɔ̀ ndùté ndùtù yeè maga nde né mân.» ");
INSERT INTO mcu_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abrahâm lé baá gi mene nyèmà yuií, à né mene ŋené kɔɔ́ ye yo nyî baá gi faá komó nɔ, à né mene kɔɔ́ ye Sará né ŋgiín, mé njéh mene à lé yúá ná ŋgwêh, ");
INSERT INTO mcu_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","à lé temé yoòr Càŋ sɔ̀m nyì ná ŋgwêh gùm dɔɔ́ŋ, à ndéb mé Càŋ lé kwa kwaá naâ bú tieè doô sàn ŋgwéh ndɔ; à kwaá njií ŋeí seér cu temé yoòr Càŋ dé kwaâ, à né bú teèn seén yií. ");
INSERT INTO mcu_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","À lé naá giì kɔɔ́ nyegé, ye Càŋ né lom mé terreb teèn, à nde né faá à lé tueé naâ nɔ bɔɔ́ komo. ");
INSERT INTO mcu_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Càŋ lé bú nùà dilî beè seèn yilá kuú naâ dé cî. ");
INSERT INTO mcu_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Njií mé bɔ́ nyagá kwaá né ye: Càŋ yilá baá bú nùà dilî beè seèn hên, bɔ́ dé seèn nyàgà lòm ŋgwéh. ");
INSERT INTO mcu_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Bɔ́ nyagá kuú né dé beèh, te béh kɔ ye, Càŋ