﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcr_vpl;
CREATE TABLE mcr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcr_vpl WRITE;
INSERT INTO mcr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kukŋuä tä, Jisasi Kraisi Iqueqä kaqä-kawäkauŋqe. Iqu häŋeqä Dewiti iquesaŋi, itaŋga Dewiti iqu häŋeqä Aprähamä iquesaŋi. ");
INSERT INTO mcr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aprähamä iqu, Aisakä iqueqä kanique. Itaŋga Aisakä iqu, Jekopä iqueqä kanique. Jekopä iqu, Jutä iqueqätä, käŋguäkauqätä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jutä iqu, Peresi iqueqätä, Sela iqueqätä kanique. Iŋgueqiyqä känai, Tema iiyi. Peresi iqu, Eslonä iqueqä kanique. Eslonä iqu, Lamä iqueqä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamä iqu, Aminätapä iqueqä kanique. Aminätapä iqu, Nasonä iqueqä kanique. Nasonä iqu, Salämonä iqueqä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salämonä iqu, Boasi iqueqä kanique. Kiqä känai, Leopä iiyi. Boasi iqu, Opeti iqueqä kanique. Kiqä känai, Rutqi iiyi. Opeti iqu, Jesi iqueqä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi iqu, ämaqä naqä Dewiti iqueqä kanique. Dewiti iqu, Solomonä iqueqä kanique. Kiqä känai, hiŋuiqänäŋi Yuraya iqueqä apäkä emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonä iqu, Leopamä iqueqä kanique. Leopamä iqu, Apiya iqueqä kanique. Apiya iqu, Asa iqueqä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa iqu, Jeosapatä iqueqä kanique. Jeosapatä iqu, Jeolamä iqueqä kanique. Jeolamä iqu, Yusiya iqueqä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yusiya iqu, Jotamä iqueqä kanique. Jotamä iqu, Ahasi iqueqä kanique. Ahasi iqu, Hesekiya iqueqä kanique. ");
INSERT INTO mcr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya iqu, Mänasa iqueqä kanique. Mänasa iqu, Amonä iqueqä kanique. Amonä iqu, Josiya iqueqä kaniquvi. ");
INSERT INTO mcr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya iqu, Joakinä iqueqätä, käta-käŋguäkauqätä kanique. Iŋgaŋi, mäkä-huŋqä hŋqua Israitqä iquauŋi, Bapilonä iuŋqä ätuma äwäpu, iquauqä yäpä imä äpmuatekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","I äpmapiyitaŋi, Joakinä iqu, Selatiyoli iqueqä kaniqu ekqe. Selatiyoli iqu, Serupapelä iqueqä kaniqu ekqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serupapelä iqu, Apiyutä iqueqä kaniqu ekqe. Apiyutä iqu, Eliyakimä iqueqä kaniqu ekqe. Eliyakimä iqu, Asolä iqueqä kaniqu ekqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asolä iqu, Satokä iqueqä kaniqu ekqe. Satokä iqu, Akimä iqueqä kaniqu ekqe. Akimä iqu, Eliyutä iqueqä kaniqu ekqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyutä iqu, Eliyasa iqueqä kaniqu ekqe. Eliyasa iqu, Matanä iqueqä kaniqu ekqe. Matanä iqu, Jekopä iqueqä kaniqu ekqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopä iqu, Josepä iqueqä kaniqu ekqe. Josepä iqu, Mäliyaqä qokique. Mäliyai, Jisasi Iqueqä känaiyi. Iquenyqe, qu tii ätätqäŋuwi. “Ämaqä Tqu, Iqu Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Iquvi.” ");
INSERT INTO mcr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iiŋä etaŋgi Jisasi Iqu Aprähamä iquesaŋä hueqä-himqä Ique. Iŋi Aprähamä iquesa, ämaqä 14 iquau eqiyämaŋguwitaŋi, Dewiti iqu ekqe. Itaŋga Dewiti iquesa, ämaqä 14 iquau inä eqiyämaŋguwitaŋi, mäkä-huŋqä iqua Israitqä iquauŋi Bapilonä iuŋqä ätuma äukuwi. Itaŋga Bapilonä iuŋqä äukuwitaŋi, ämaqä 14 iquau inä eqiyämaŋguwitaŋi, Jisasi Kraisi Ique ämikqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisasi Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Iqueŋi, Iqueqä känai ämikqeŋqä kukŋui, tiiŋi. Iqueqä känai Mäliya, qu Josepä iquenyqä tuwakŋä ae äunyqaŋguwäŋga, iqu mämeqä änä etaŋgaŋi, Dŋä Äŋguä Iqu iiyqä äwqä imda imäkqaŋgi, ii äwqä-täŋä emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iiyqä qokä Josepä iqu, ii äwqä-täŋi etaŋgi näqŋqä ämeqe, ämaqä jänäŋu eä, qokä-apäkä iquauqä hiŋuä iqiŋi, ii womba iŋqä meqäŋqe mäwiŋgaŋgi, hiŋuinä qunäwatmätä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iqu iiŋä imäkätŋqä kŋuä yqänä indqänätqätaŋga, wätqä iuŋi Goti Naqä Iqueqä eŋätqä hŋqu äwimeqe, tii ätukqe. “Josepä Dewiti iqueqä kawiquki, Mäliya matŋqä diŋqe, si kŋuä kuapänä mindqäŋqä panä. Ymeqä äwqä imä ämnäŋqä Iqu, Dŋä Äŋguä Iqu änyueqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Itaŋga ii Ymeqä Qokä Hŋqu nyuäŋqiyä. Iqu Iqueqä qokä-apäkä iuqä suqä quvqetaŋi, häŋä imäkäqumuatäniqeqä. Iŋi si Iqueqä yoqe, ‘Jisasi Iqukiyä’ nyuättŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nätmatqä eeqänäŋä tä ätimäukqe, Goti Naqä Iqueqä kukŋui, qäyunä imäkätŋqä ätimäukqe. Naqä Iqu hiŋuä-tqä hŋque kukŋui tiiŋä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“He qätä wipiyä. Apäkä, qokätä hiqaqä mäwiqä hui, äwqä-täŋä eätä, ymeqä qokä hŋque nyuäniqeqä. Qu iqueqä yoqe, ‘Imanueli iqueqä’ nyuätpnuwäŋqeqä. Yoqä tqueqä quati, tiinji. Goti Hanjuwä Iqu, nesä anä äpmenä.” ");
INSERT INTO mcr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Itaŋga Josepä iqu, hiqaqä äwämiŋqe ivatuwänäqe, Naqä Iqueqä ynaunjqä iqu ätukqä-pa imäkätä, iqueqä apäki qe ämakqe. ");
INSERT INTO mcr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iqu apäki ae ämakqä-qe, ii Ymeqä Qokä Ique ae nyquaŋgqäŋgaŋqä, iisä hiqaqä anä mäwiqä imiŋqe. Ga iqu Iqueqä yoqe, “Jisasi Iqukiyqä” änyuätkqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ämaqä naqä Heroti iqu qua Jutiya iu mitqätaŋga, Mäliya Jisasi Ique aŋä-himqä Betlemä iu ämikqe. Qänakndaŋi ämaqä mäptqä timäuqä mäŋgisaŋä näqŋqä-täŋä iqua, Jerusälemä iuŋqä äyappiyi, yatŋqä hiŋginäwa ikäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ymeqä, ämaqä Jutiya pmeqä iquau mitŋqä, täŋga änyquä Iqu, äŋgi winä? Ne Iqueqä qätäqueqä ique, mäptqä timäuqä mäŋgisa äqunätanä, Iquenyqä qoŋä woktatuŋquä äyapqunä.” ");
INSERT INTO mcr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ämaqä naqä Heroti iqu qätä iiŋä äwiyäqe, iqu kŋuä kuapänä indqänätä, änämiqä imiŋqe. Jerusälemä pmeqä iqua asä iiŋä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iiŋä hitaŋgi, Heroti iqu hiqäva-imäkqä naqä iquautä, kukŋuä-suqeŋqä näqŋqä iquautä, eeqänä tääqä ätuätumetä, yatŋqä tiiŋä äwikqe. “Kraisi, Goti Hanjuwä Iqu Iqueqä ämaqeu mitŋqä Ique atäuŋuä ikqä Iqu, aŋä äsqisa timäutŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iqu yatŋqä i vqaŋga, qu kimaŋi tii qe ätukuwi. “Iqu aŋä-himqä Betlemä, qua Jutiya iuta timäutŋqeqä. Hiŋuä-tqä hŋqu, Goti Hanjuwä Iqueqä kukŋui ätätä, bukä iu tiiŋä äqäkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Qua Jutiya iuŋi, aŋä-himqä Betlemä iquki, huizi iquauqä yäpakä iquki manä. Ämaqä sitaŋä hŋqu, huiziquau miqä timäuniqeqä. Iqu Ŋqä ämaqä Israitqä iquau miqäŋqä pmeniqeqä,’ ätätä äqäkqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Heroti iqu kukŋuä tä qätä äwiyäqe, ämaqä mäptqä timäuqä mäŋgisaŋä näqŋqä iquau tääqä maqŋqä ätuätumeqe, yatŋqä vqaŋga, qu, “Qätäqueqä iqu hea iŋga ätimäuqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Itaŋi iqu näqŋqä ämeqe, iquau ätäwqatkqe. “He Betlemäŋqä äwipu, Ymeqä Iquenyqä qävqä äŋguänä ipiyä. Itaŋga he hiŋuä ae äqumbiyi, nyi ndpŋqä aŋgumä quveppiyä. Nyi-pqe äpätmä, Ique qoŋä woktäumqänänyä.” ");
INSERT INTO mcr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Qu ique qätä äwipiyi, qe äukuwi. Wätqätaŋguwäŋgaŋi, qätäqueqä mäptqä timäuqä iŋgi äquŋguwä iqu, iquauŋi hiŋuiqä äwimamiŋqe. Itaŋga iqu äwätä, aŋä Ymeqä Iqu witaŋgqä iu, haqä yätqä äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iŋgaŋi iqua iiŋä äqumbiyi, yeeqä kiiŋä qe äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Itaŋga iqua aŋä yäpä iŋgisa äpaquväpu, Ymeqä Iquesä, Iqueqä känai Mäliyatäŋi äqumbiyi, iqua Iqueqä yoqä haqeqä ämamäupu, qoŋä äwoktäupu, hipeŋui qua bu ekuwi. Itaŋi iqua golqetä, eqä wetqä jinaŋä äŋguänäŋä weqetä, zä-wänuŋuä eqetä, quwqä qa iuta ätaupu, Ique qe äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iŋgaŋi Goti Hanjuwä Iqu wätqä ävätä, “Heroti iquenyqä aŋgumä mäwqä pambiyä” tquaŋga, iqua quwqä aŋämqä hänaqä hui-mända qe äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iqua ae uwqaŋguwäŋgaŋi, Naqä Iqueqä eŋätqä hŋqu, Josepä ique wätqeu äwimetä ätukqe. “Heroti iqu, Ymeqä Tquenyqä qävqä itä, päsätŋqä iqiyä. Iŋi si ävautnä, Ymeqä Iquesä, känäutä itmetnä, itaŋga Isipä iuŋqä zä ätuma äwätnä, pmatŋqeqä” ätukqe. “Nyi si aŋgumä ktqaŋgmdqäŋgaŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Itaŋi heatqäŋga, Josepä iqu ivatuwänäqe, Ymeqä Iquesä, känäutä Isipäŋqä qe ämitimäukqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iqu iu yqänä pmetaŋga, Heroti iqu qe äpäkoŋgqe. Nätmatqä tä ätimäukqe, Naqä Iqu Iqueqä hiŋuä-tqä hŋque ätukqä-pa, qäyunä ätimäukqe. “Ŋqä ymeqä ique, Isipä buta ätuma äpkqeqä” ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroti iqu, ämaqä mäptqä timäuqä mäŋgisaŋä iqua, ique awä mätquä, hänaqä hui-mända ämäwqätäukuwiŋqä näqŋqä ämeqe, iqueqä äwqe tnäŋä wiŋgaŋga, ämaqä hui Betlemäŋqä ändowatätä ätukqe. “Betlemä iutä, aŋä-himqä qäqiqi ämätnäŋqä iutäŋi, he ymeqä qokä quväukuä hŋquaqu mämäwqätäuqä iquauŋi, pizqä päkpiyä.” Iqu näqŋqe, ämaqä mäptqä timäuqä mäŋgisaŋä iquauta ämeqe, ymeqä quväukuä iiŋi mämäwqätäuqä iquauŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Qu ymeqä i äpäkkuwi, Goti Hanjuwä Iqu imäkätä, hiŋuä-tqä Järämai ique ätukqä-pa, qäyunä ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aŋä-himqä Lama iuŋi, Lesoqä kaqäua ymeqä iquauŋqe, kŋuä äqiyäpu pmapqä iqaŋguwäŋga, qu qätä äwikuwi. Ymeqe mäpmeqä itaŋguwiŋqä, qokä-apäkä huizi iqua iuauqä äwqe jänä iwimäkpŋqä diŋqe, mäwiŋqä imiŋqe.” ");
INSERT INTO mcr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroti iqu ae äyä päkoŋgaŋga, Isipä iuŋi, Naqä Iqueqä eŋätqä hŋqu, Josepä ique äwimetä tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ämaqä, Ymeqä Ique pizqä päsanä-tpu ikuwä iqua, ae äpäkoŋguwiqä. Iŋi si ävautnä, Ymeqä Iquesä känäutäŋi itmetnä, qua Israitqäŋqä aŋgumä upŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kukŋuä ii qätä äwiyäqe, iqu ävautä, imbaqi itmetä, qua Israitqä iuŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iu ätimäuqe, Akelausi iqu kanä Heroti iqueqä aŋä ämetä, Jutiya iu mitqätaŋgqeŋqä qätä äwiyäqe, iqu zä wiŋgaŋgi iuŋqä mäwqä ikqe. Iiŋä etaŋgi Goti Hanjuwä Iqu wätqeuta kŋuä vqaŋgi, iqu qua Galilisäŋä iŋgisaŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Iu ätimäuqe, iqu aŋä-himqä “Nasäretqävqä” ätmiŋuwä iu qe äpmakqe. Iqinyqä äukuwi, hiŋuä-tqä iquauqä kukŋui qäyunä qe ätimäukqe. “Qu iquenyqe, ‘ämaqä Nasäretqätaŋä-queqä’ tupnuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Itaŋi quväukuä hui ae äpäwqaŋga, Jonä asŋä-qäyqä iqu Jutiya iu änyä qe ätimäutä, aŋä avqŋqä iu äpme, ämaqeu kukŋuä awä tii ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Goti Qäukuä Yätutaŋä Iqunä miqe, qäukuä haqä yätuta qäqi täqi ae äquvepqeŋqe, hiqä kŋui äkunmäknäpu, suqä quvqe vquatämäupiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kukŋuä Goti Hanjuwä Iqu hiŋuä-tqä Asayä iqueqä maŋä iuta ätkqe, ii Jonä iquenyqe. Ii tiinji. “Aŋä avqŋqä imdaŋi, ämaqä hŋqueqä maŋi tääqä tii ätqiyä. ‘Naqä Iquenyqä hänaqe, näwinyä jänänä imäkepiyä.’” ");
INSERT INTO mcr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonä iqueqä qäki, kametqä aa äyäuä, itaŋga yaqueqä huiwi, aquvä ämuäsämäumiŋqe. Itaŋi peŋuätä, wiyä-makŋuä aŋitä ätetä äŋgmanmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iŋgaŋi ämaqä Jerusälemä pmeqä, qua Jutiya iu pmeqä, itaŋga eqä Jotänä iqueqä maŋä iu pmeqä iqua, qu eeqänä iquenyqä äpmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Qu i äpäpu, quwqä suqä quvqeŋqä awä tquaŋguwäŋgaŋi, Jonä iqu eqä Jotänä iu asŋä äwqämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Iŋgaŋi Jonä iqu, Parisi hŋquatä, Satyusi hŋquatä, asŋä mapŋqä kuapänä pqaŋgä äqunäqe, iqu tiiŋä ätukqe. “He qämakä quvqä iquauqä ymeqä-quenjqä. ‘Goti Hanjuwä Iqueqä äwqä tnäŋä äpäŋqiyä. He zä upiyä-qe,’ tqu hitqaŋgikä? ");
INSERT INTO mcr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hiqä kŋui äkunmäknäpu, suqä quvqe ae ävquatämäuqueqä äktmbu motquapiyä. Iiŋä imäkquwi, he zä hŋqu häukuä-täŋä eŋqä-paŋuenjqä. ");
INSERT INTO mcr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘Aprähamä iqu neqä awiqu hitaŋgqetaŋi, ne äŋguä äpmeŋunä-qe,’ matŋqä pambiyä. Nyi he etqänä. Goti Hanjuwä Iqu hikä tä, Aprähamä iqueqä kaqä-kawäka epŋqe, äŋguä imäkänä. ");
INSERT INTO mcr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Zä-häukuä äŋguä mäwiqaŋgutqä iquauŋi, tä täuvepŋqä diŋqe, japiŋi zä-quatä iqi ae äwinä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Hiqä kŋui äkunmäknäpu, ‘suqä quvqe ae ävquatämäuqueqä’ motquapŋqe, nyi asŋi eqetänä eqiyätqäŋä. Iiŋä etaŋgi Ämaqä nyi ämaŋqutäuŋqä Iqu, qänaki änä äpäŋqiyä. Nyi Iqueqä yukä ämuasmäŋqe mamqe, ämaqä äŋguä-qunä ma, quvqunji. Iqu asŋi, Goti Hanjuwä Iqueqä Dŋä Äŋguitä, tä itä heqiyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iqu pokä a äqätänä, kuä pa huätä ämatnämäutä, kuä naqe, aquvä äqiyätä kiqä aŋiu pŋqä maeniŋqeqä. Itaŋga kuä pai, tä maisquä du tnämäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iŋgaŋi Jisasi Iqu qua Galili iu ävämaŋi, Jonä iqu asŋä wuqiyätŋqä, ique eqä Jotänä du äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Itaŋga Jonä iqu, “Qäyä eenä. Asŋi, Si ŋqiyqänäŋä qäyuŋä-qe, nyi kqämqä äpŋi, änääŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","I tquaŋga Jisasi Iqu kimaŋi, “Qäyä eenä. Täŋgaŋi Nyi äktqä-pa, ii imäkiyä. Goti Hanjuwä Iqueqä äwiŋqä eeqänäŋi qäyunä timäutŋqe, ye suqä ii imäkeŋqeqä” ätukqe. Iŋgaŋi Jonä iqu kukŋuä duŋi qänaknä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisasi Iqu asŋä ae ämeqe, eqä bu äväma äyapqaŋga, maqänäŋi qäukui qŋqaŋä eŋqä-pa qe äutäŋgqe. Itaŋi Iqu, Goti Iqueqä Dŋä Äŋguä Iqu, yŋŋä-heeqä eŋqä-pa äquvepätä, Iqueä huiwä iu pmeqaŋgi hiŋuä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iŋgaŋi qäukuä yätutaŋi, maŋä hŋqu tiiŋä äqäŋgqe. “Ämaqä Tqu, Ŋqä Ymeqä Nyi kiiŋä änyinätŋqä Iqueqä. Ŋqä äwqä imdaŋi, Iquenyqä aquvänä änyinätqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iŋgaŋi Jisasi Iqueŋi, Dŋä Äŋguä Iqu, aŋä avqŋqä iuŋqä ätma äukqe. Ii, Setänä iqu Ique yamwiqä vätŋqä diŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iqiŋi Iqu hiunjitä, heatqetä 40, buayä maŋqä äpmeqe, buayäŋqä dä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iŋgaŋi dŋä quvqä yamwiqä vqä iqu, Ique äwimeqe, “Si Goti Hanjuwä Iqueqä Ymequki etaŋgutqe, hikä tqua buayä kunmäkmbŋqä, kukŋuä tuvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisasi Iqu kimaŋi, “Goti Hanjuwä Iqueqä kukŋui tii äqänä. ‘Qokä-apäki buayä dutanä pmeqä hmanjqä. Qu Goti Hanjuwä Iqueqä kukŋuä eeqänäŋä iutanä pmeqeqä,’ ätä äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iqu iiŋä tquaŋga, Setänä iqu Ique Jerusälemä Goti Hanjuwä Iqueqä aŋä-himqä iuŋqä ätuma äwäqe, hiqäva-imäkqä aŋä atääqä iu ätqäteqe, “Si Goti Hanjuwä Iqueqä Ymequki etaŋgutqe, qua mäŋi ikuapmävä” ätukqe. “Tiiŋä etaŋgi, Goti Hanjuwä Iqueqä bukä iuŋi, tii äqänä. ");
INSERT INTO mcr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","‘Goti Hanjuwä Iqu iqueqä eŋätqä iqua äŋguänä mikipŋqä ätuäŋqiyä. Tqä yuki hikä iu hui matävqä isŋqä diŋqe, iqua hipae hevqä mäkiqutäpŋqäuä.’ ” ");
INSERT INTO mcr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iwä Jisasi Iqu tii ätukqe. “Bukä iuŋi, kukŋuä tiiŋä-pqe inä äqänänä. ‘Si Goti Hanjuwä tqä Naqä Iqueŋi, yamwiqä mävqä panä.’” ");
INSERT INTO mcr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Itaŋi Setänä iqu aŋgumä, qoqoŋä haqä naqä ziimäŋä hŋquenyqä ätuma äyäqe, aŋä-himqä eeqänäŋä qua täuŋitä, iquauqä nätmatqä äŋguä eeqänäŋä itä ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ga iqu tiiŋä ätukqe. “Si qoŋä änäuktäutnä, nyaqä yoqe haqeqä manmäuqaŋgtqe, nyi eeqänäŋä tä Si ktapmqänä.” ");
INSERT INTO mcr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisasi Iqu tii ätukqe. “Setänä iquki, huätä päuvä! Goti Hanjuwä Iqueqä bukä iuŋi tii äqänä, ‘Si qoŋä äwoktäutnä, Goti Hanjuwä tqä Naqä Iqueä yoqenä haqeqä ämamäutnä, wäuŋui Iqueqenä iqaŋginyä.’” ");
INSERT INTO mcr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iŋgaŋi Setänä iqu Ique ävämeqaŋga, eŋätqä iqua äpäpu, Ique yätamäkqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","“Qu Jonä ique, guä ae äkiqiyäuquwiqä” tqaŋgä äwiyäqe, Jisasi Iqu qua Galili iuŋqä aŋgi äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Itaŋi Iqu aŋä-himqä Nasäretqä iuŋi ävämaŋi, aŋä-himqä Kapänamä buŋqä äwitä äpmakqe. Kapänamäŋi, eqä-huäŋä Galili-täŋä qäqiqi eä, Seplonä, Näptali gueqiyqä hueqä-himqä iquauqä qua iuvi. ");
INSERT INTO mcr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iqu e imäkätä, kukŋuä hŋqu Goti Hanjuwä Iqu hiŋuä-tqä Asayä iqueqä maŋä iu ätimekqeuŋi, qäyunä timäutŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Seplonä, Näptali gueqiyqä quae, hänaqä eqä-huäŋä duŋqä änyäwäŋqä qäqiqi eä, eqä Jotänä-täŋä iŋgi-mända, qua Galili-täŋä iŋgisayi. Itaŋga ämaqä Israitqä iquanä ma, huiziqua iqi anä äpmeŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ämaqä pisqukuä imä äpmeŋuwä iqua, qu we-huŋqä naqä ique hiŋuä ae äqunäŋäuä. Ga ämaqä ae äpäkoŋguwä iqua eŋqä-paŋä äpmeŋuwä iquauŋi, we ae äwiomäkqiyä” ätkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iŋgaŋi Jisasi Iqu, qokä-apäkä iu kukŋuä awä ätipäqiyätä, tiiŋä ätukqe. “Goti Qäukuä Yätutaŋä Iqunä miqe, qäukuä haqä yätuta qäqi täqi äwiŋqä-qae, hiqä kŋui äkunmäknäpu, suqä quvqe vquatämäupiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iqu eqä-huäŋä maŋä Galili iu qaŋä äwätäqäŋgaŋi, Saimonä, Endru gueqi hämapäkä-piqä qa ätnämäutqätaŋginyä äquŋgqe. Saimonä iqueqä yoqä huizi, Pitä ique. Iŋgueqi hämapäkä äpisinyä, mbqä ämamiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iqu iquaqui hiŋuä äqunäqe, “Nyi qänaki nyivänjinyqä. Ämaqä-piqeŋqe ämäqesquamqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","I tquaŋgaŋi, iŋgueqi hämapäkä qae, maqänä iqi emäŋi, Ique qänaki äwivändkiyi. ");
INSERT INTO mcr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iqisaŋi haqä nänä hmbu tii äwäqe, ämaqä hŋgueqi, Jemisi iquesä, Jonä iquesä hiŋuä äquŋgqe. Iquaqu Sepri iqueqä hikŋä-quaqu eänyä, imätqua yimba iu äpmapu, hämapäkä-piqä qae dakmäuqaŋgi anä imäkqämanmiŋuwi. Jisasi Iqu iŋgueqi hiŋuä äqunäqe, tääqä ätuätumakqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","I tuätumeqaŋgaŋi, iŋgueqi yimbaetä, kaniquesä maqänä ävämaŋi, Ique qänaki äwivändkiyi. ");
INSERT INTO mcr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iŋgaŋi Jisasi Iqu qua Galili iuŋi qaŋä ikitä, quwqä aŋä aquväqŋqä iuŋi näqŋqä ävätä, kukŋuä äŋguänäŋä Goti Iqunä qäukuä haqä yätuta miqeŋqä awä ätuätä, täŋä-yaqä huitaŋä-huitaŋä eeqänä äŋguä imäkätä ikämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iquenyqä kukŋui, qua Siliya iuŋi eeqänä im-imä qe äukqe. Ga ämaqe Jisasi Iqueŋqä, täŋä-yaqä huitaŋä-huitaŋä-täŋitä, dŋä quvqä-täŋitä, yaqä ppqä-täŋitä, yaqä ŋŋuä-täŋitä, eeqänä äma pqaŋguwäŋgaŋi, Iqu eeqänä äŋguä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Itaŋga ämaqä kuapänä qua Galilisaŋä iquatä, qua Dekapolisisaŋä iquatä, Jerusälemätaŋä iquatä, qua Jutiyataŋä iquatä, eqä Jotänä yätäqäŋgisa pmeqä iquatäŋi, qu eeqä Ique qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisasi Iqu ämaqä kuapänä pqaŋgä äqunäqe, qoqoŋä yätuŋqä ekqe. Iqu iqi quamä pmeqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Iqueŋqä äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iŋgaŋi Iqu iquau tiiŋä ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ämaqe, ‘Nyi ämaqä äwa iqunä eämä, Goti Iqueqä hiŋuä iqi qäyunäŋunä hmanjqä’ kŋuä indqänätqäŋuwä iqua, Goti Qäukuä Yätutaŋä Iqu ämaqä iiŋä iquau ämitqätaŋgqeŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ämaqä, suqä quvqeŋqä kŋuä äqiyätqäŋuwä iqua, Goti Hanjuwä Iqu äwqä haŋuä iwimäkätŋqä iiŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ämaqä, iquauqä yoqe mändi äkittqänätqäŋuwä iqua, qua tä quwqä heniqä iiŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ämaqä, suqä jänäŋiŋqä äwa ipu, ique mapŋqä kiiŋä äwinyätŋqä iqua, Goti Hanjuwä Iqu jänä imäkpŋqä qäyunä väniqä iiŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ämaqä, huizi iquauŋqä qeqä äwimänätä yätamäkqä ävätqäŋuwä iqua, Goti Hanjuwä Iqu quŋqe asä inä wimänäniqä iiŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ämaqä, qeqä-quuvqä ikikinyäŋä änyäŋuwä iqua, Goti Hanjuwä Ique hiŋuä qumbnuwäŋqe, qu äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ämaqä, äkasuwä-mäkä mändi kittqäpŋqä imäkätqäŋuwä iqua, Goti Hanjuwä Iqu iquauŋqe, ‘Ŋqä ymeqä-quaiqä’ tuäniqä iiŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ämaqä, suqä jänäŋä iu qänaki itqätaŋguwiuta, huizi iquauqä hipa iuta haŋä-iqä ämetqäŋuwä iqua, Goti Qäukuä Yätutaŋä Iqu ämaqä iiŋä iquau ämitqätaŋgqeŋqe, äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","He Nyaqä yoqä ämetqätaŋguwiŋqä, ämaqe kukŋuä quvqä etäpu, quvqä etquepu, henyqä quaŋgä tqaŋguwäŋgaŋi, he äwqä yeeqä ipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hiŋuä-tqä he mäpmeqäŋga äpmamiŋuwä iquauŋi, ämaqe suqä quvqä asä iiŋi itquamiŋuwiqä. Itaŋga he Nyaqä yoqä ämetqäŋuwitaŋi, nätmatqä äŋguänäŋi qäukuä haqä yätu henyqä näwi äwinä. Iiŋiŋqe, he äwqä yeeqä kiiŋä ipŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Qua täu qui maqänä mimäkŋqä, äpakänä witätŋqe, he hakä eŋqä-paŋuenjqä. Haki ätquäŋqä qäpu heqaŋgutqe, hakä ätquänätŋqe, aŋgumä äänä timäuniqiyä? Oeyqä. Aŋgi wäuŋuä miqä iqaŋguti, ämaqe bi ätnämäupu, qonjqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Qua täuŋi, he we-huŋqä eŋqä-paŋuenjqä. Aŋä-himqä hŋqu qoqoŋä iu ämätnäŋqe, zä mamätŋqä itäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Asä iiŋi, ämaqä aŋä iu pmetaŋguwä iquau we wunätŋqe, ämaqe hiqi-tä ämäsäupu häkä imä matqäteqä ipu, kiqä ätqäuqä iqinyä tqätepŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iiŋä etaŋgi heqä we-huŋqe, ämaqeu we wunätätŋqänänjqä. Iŋi iqua, he suqä äŋguänäŋä imäkätqätaŋgä eqämbiyi, Apiqu Qäukuä Yätu Äpmeŋqä Iqueqä yoqe haqeqä mamäupŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“He Nyinyqe, ‘Iqu kukŋuä-suqä Mosisi iqu äqäkqä itä, kukŋuä hiŋuä-tqä iqua äqäkuwä itä, huätä mamäutŋqä äpqeqä’ kŋuä mindqäŋqä pambiyä. Oeyä! Nyi huätä mamäumqä äpqä ma, qäyunä naqä-qakuä timäutŋqä äpqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nyi he naqä-qakuänä etqänä. Qäukuitä, quaetä, aaŋqä hiqaŋgaŋqe, kukŋuä-suqä iutaŋä wäŋqä hmbu aaŋqe, maeqä yäniqeqä. Oeyqä. Nätmatqä Goti Hanjuwä Iqu äwinyäŋqä eeqänäŋi ae ätimäuqaŋgaŋqe, hiqŋqä wäŋqä suqä iu äqäkuwi, eeqänäŋi äwitäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iŋäqe ämaqä hŋqu, suqä Mosisi iqu äqäkqä iutaŋä wäŋqä hmbi mändi äkittqiyätä, ämaqä hŋquau mända-pqä inä eyäqiyämetqe, suqä ipu huiziquauqä yäpä imä qäyä witaŋgqä-qe, Goti Qäukuä Yätutaŋä Iqunä miqä iuŋi, ämaqä tqueqä yoqe wäŋqäpu, huiziquauqä yäpä imä winiqeqä. Itaŋgi ämaqä hŋqu suqä iuŋi qänaknä itä, ämaqä iuŋi ämotquamitätqe, Goti Qäukuä Yätutaŋä Iqunä miqä iuŋi, iqu yoqä naqä meniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nyi he etqänä. He Goti Hanjuwä Iqueqä äwiŋqä iuŋi, jänänäŋä imäkäpiyäŋgaŋi, ämaqä kukŋuä-suqeŋqä näqŋqä iquauqätä, Parisi iquauqätä, suqä jänäŋä imäkqä iuŋi mämäwqätäuqä ipu qänaki iquwi, he Goti Qäukuä Yätutaŋä Iqunä miqä iuŋqe änä mäyqänäŋiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kukŋuä hiqä taqä-tawäkiqua qätä äwiyäpu ämakuwi, he qätä tiiŋä ae äyä äwiyätqäŋuwiqä. ‘Ämaqä pizqä mapäsqä ipŋqeqä.’ Itaŋga ‘Ämaqä hŋqu ämaqä hŋque pizqä äpäsätqe, iqueŋi kukŋuä wimeniqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Itaŋgi Nyi he tiiŋä etqänä. Ämaqä hŋqu ämaqä hŋququque äkasuwä ätuätqe, iqueŋi kukŋuä wimeniqeqä. Itaŋi, ämaqä hŋqu hŋquququeŋi, ‘Hiŋgiŋqukiyqä’ ätuätqä iqu, kukŋuä iwäsäuqä naqä iquau wimeniqeqä. Itaŋi ämaqä huizi ique-mända, ‘Si ämaqä kŋuä maeqä hŋgisanä iqä iqukiyqä’ ätuätqä iqu, tä quvqä iqu äsäŋqä iuŋqä wäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Iiŋiŋqe, si hiqäva äma äpätnä, hiqäva-imäkqä ttawä iu ätqäutŋäŋgaŋi, tqä sämaquenyqe, ‘Iqu nyitä kukŋuä-täŋueqä’ kŋuä indqäŋgŋi, tqä hiqäva iqi pŋqä eätnä, iquenyqä äwätnä, äwqä naqä-hŋqunä ganä nyiyŋqeqä. E ae imäknyiyi, si äwätnä, tqä hiqävae Goti Hanjuwä Ique iŋganä wisŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ämaqä hŋqu si kukŋuä miktätŋqä iqaŋgutqe, itaŋi iqutä sitä kukŋuä tqä aŋiuŋqä hänaqä iu qaŋä anä äwäsiyäŋgaŋi, si maqänäŋi ique äwqä haŋuä iwimäkätnä, iqutä jänä imäkiyŋqeqä. Si e mimäkqä iqaŋgtqe, iqu ämaqä jänä imäkqä iqueqä hipa iu kivqaŋguti, jänä imäkqä iqu guä kiqiyäueqä aŋä iu miqä iqueqä hipa iu kivqaŋguti, itaŋga iqu guä kiqiyäueqä aŋä iu mäqumuatekiyäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nyi siŋi naqä-qakuänä äktqänä. Mbqä qu si atäuŋuä äkipqä iuŋi qäyunä vätŋäŋgaŋqe, si guä kiqiyäueqä aŋiu mävämeqä yqänä pmettŋiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Qu tiiŋä ätätqäŋuwiŋqe, he qätä ae äyä äwiyätqäŋuwiqä. ‘Qokä-apäkä ämaŋqe, huizitä huiwi yaŋä mikiqä ipŋqeqä!’ ");
INSERT INTO mcr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Itaŋgi Nyi he tiiŋä etqänä. Ämaqä hŋqu apäkä hui hiŋuä äqunä, ‘Iisä hiqaqä anä womqe’ kŋuä ävqäqe, iqu iqueqä äwqä iutaŋi, suqä quvqe ae imäkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tqä hiŋuä ämuaŋgisaŋi suqä quvqeuŋqä äkiyqiyämeqaŋgutqe, huätä ätquätnä bi tnämävä. Si iiŋä imäkqaŋgtqe, tqä huiwitaŋä hmbu yuuwä ätänäŋqä-qe, suqä quvqä iiŋä mimäkqä iŋä-qae, saqä huiwi, tä quvqä iqu äsäŋqä iu matnämäuqä ipŋqäuä. Huiwä hmbi yuuwä ätänäŋqe, ii haŋä-iqä wäŋqäpiyqä. Tä duŋqä uwqe, haŋä-iqä naqänäŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Itaŋga tqä hipa ämuaŋgisaŋi suqä quvqeŋqä äkiyqiyämeqaŋgutqe, huätä ätävätnä bi tnämävä. Si iiŋä imäkqaŋgtqe, tqä huiwitaŋä hmbu yuuwä ätänäŋqä-qe, suqä quvqä iiŋä mimäkqä iŋä-qae, saqä huiwi, tä quvqä iqu äsäŋqä iu matnämäuqä ipŋqäuä. Huiwä hmbi yuuwä ätänäŋqe, ii haŋä-iqä wäŋqäpiyqä. Tä duŋqä uwqe, haŋä-iqä naqänäŋiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Qu tiiŋä ätätqäŋuwiqä. ‘Ämaqä hŋqu iqueqä apäki huätä ändowatätäqäŋgaŋi, iqu iiŋä imäkätqeŋqä ämotquetŋqe, iiŋi, tuwaŋuä hui äqiyätä vätŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Itaŋgi Nyi he etqänä. Ämaqä hŋqueqä apäki, huizitä huiwä yaŋä mävqä itqä qäyä etaŋgi, iqu ii huätä ändowatätqe, ämaqä iqu iqueqä apäki kukŋuä-suqä ävausätŋqä iuŋqä iwimäkqiyä. Kukŋuä tqueqä quati, tiiŋiqä. Ämaqä hŋqu apäkä iiŋi ämeqe, iqutä iisä, suqä qokä hŋqutä apäkä huisä hiqaqä anä mäwiqä iuŋi ävausqinyqä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kukŋuä hiqä taqä-tawäkiqua hiŋuiqänä qätä äwiyäpu ämakuwi, he qätä tiiŋä ae äyä äwiyätqäŋuwiqä. ‘Si nätmatqä hŋqu imäktŋqä diŋqä kukŋuä yäŋänäqŋqä ätätŋäŋgaŋi, quaŋgi matqä panä. Si ätätŋä-pa Naqä Iqueqä hiŋuä iqiŋi ii imäktŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","I etaŋgi Nyi he etqänä. Hiqä kukŋuä hŋqu yäŋänäqŋqä imäkpŋqä etaŋgutqe, he nätmatqä hŋqueqä yoqe matqä pambiyä. Oeyqä. Iiŋä imäkpŋqä etaŋgutqe, qäukuiŋqä matqä pambiyä. Ii tiiŋi. Qäukui, tqä ma, Goti Hanjuwä Iqueqä zä-hawä, Iqu äpme ämitŋqeyqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Itaŋga quaeŋqä matqä pambiyä. Ii tiiŋi. Qua iuŋi, Goti Hanjuwä Iqu Iqueqä yuki qutatä haqeqi äui äpmeŋqeyqä. Itaŋga Jerusälemäŋqä matqä pambiyä. Ii tiinji. Jerusälemäŋi, Ämiqä Kiŋganäŋä Iqueqä aŋä-himqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","I etaŋgi si kukŋuä hŋqu yäŋänäqŋqä imäktŋqä etaŋgutqe, tqä nyuäŋä iquenyqe matqä panä. Oeyqä. Si tqä nyuäŋä iuŋi, dä qaandätä nätqätä huitŋqe, mimäkqä isŋqinyä. ");
INSERT INTO mcr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hiqä kukŋui, ‘Auäqä’ ätäpu, ‘Oeyqä’ tpŋqeqä. Ii qäyuvqä. Kukŋuä haqä nändi ätätqäŋuwi, quvqä imäkqä iquesanjqä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Qu tiiŋä ätätqäŋuwiŋqe, he qätä ae äyä äwiyätqäŋuwiqä. ‘Ämaqä hŋqu huiziqueqä hiŋui qui imäkqaŋgutqe, he iqueqä-pqe, inä imäkpŋqeqä. Itaŋga ämaqä hŋqu hŋqueqä hiquaŋi ämisqiyqaŋgutqe, he iqueqe, inä misqäpŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iiŋä etaŋgi Nyi he tiiŋäŋqe etqänä. Hŋqu quvqä etqueqaŋgutqe, iqueŋi he kimaŋi mitqueqä pambiyä. Hŋqu saqä maŋgawä iu kpäsqaŋgutqe, si hŋgisa inä wisuätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hŋqu si kukŋuä ämiktätä, tqä gque metŋqä iqaŋgutqe, si tqä gquä quäuqä-pqe inä wisŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hŋqu iqueqä yquayä äma qäqi wisŋqä ktqaŋgutqe, si iqutäŋi kiŋä näŋi tii äma wisŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hŋqu si nätmatqäŋqä yatŋqä kiyqaŋgutqe, ique äwisŋqeqä. Itaŋga ämaqä hŋqu, ‘Si yakuä dapiyä’ ktqaŋgutqe, si ique tuwä mäwiyqä panä.” ");
INSERT INTO mcr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Qu tiiŋä ätätqäŋuwiŋqä, he qätä ae äyä äwiyätqäŋuwiqä. ‘Si sämaqä iquenyqe kiiŋä äkinyätä, tqä himä-wiuŋqä iquenyqe, äwqä quvqä imäktŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Itaŋgi Nyi he tiiŋä etqänä. He hiqä himä-wiuŋqä iquauŋqe kiiŋä enyätä, ä ämaqä suqä quvqä emäkquwä iquauŋqe, Goti Hanjuwä Iqu iquau äŋguä itquetŋqä tääqä tpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","He iiŋä ipqe, Hiniqu Qäukuä Yätu Äpmeŋqä Iqueqä ymeqä-quenä eäpu, Iqu imäkätŋqä-pa imäkpŋqeqä. Iqu Iqueqä mäptqe, ätimäutä ämaqä äŋguitä, quvqetä asänä tuätŋqä iwimäkätqänä. Itaŋga piyä-pqe, ämaqä jänäŋä iquauŋqätä, suqä qäyunä mimäkqä iquauŋqätä, qiyätŋqä imäkätqänä. ");
INSERT INTO mcr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyi kukŋuä iiŋä etqe, kiqä quati tiiŋiqä. He äwqe, ämaqä heŋqänä äwinyätŋqä iquauŋqänä hiŋgaŋgutqe, kimaŋi Goti Hanjuwä Iqu nätmätqä squä hitapäniŋqäwä? Ämaqä mbqä ämotautqäŋuwä iqua-pqe, Goti Hanjuwä Ique qätä mäwiyqä ipiyä-qe, asä inä imäkätqäŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iiŋä etaŋgqä-qe, he hiqä hita-hiŋguäkaunä yeeqä äväpu itmapqe, ämaqä huizi iquauŋi äänä mäwqätäupŋqäwä? Suqä käta-kŋguäkauŋqänä äwiŋqä ii, ämaqä Goti Hanjuwä Iquenyqä quuvqä maeqiyqä iqua-pqe inä imäkätqäŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iŋi Hiniqu Qäukuä Yätu Äpmeŋqä Iqu ikikinyäŋä äpmeŋqä-pa, he-pqe ikikinyäŋä iiŋä pmepŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“He äŋguänäŋä wimasipiyä. He suqä jänäŋi imäkpiyäŋgaŋi, ‘Hiŋuä naqämbŋqäuä’ kŋuä hiyqaŋguti, ämaqä iuqä hiŋuä iqisa mimäkqä ipŋqeqä. He iquauqä hiŋuä iqi imäkqaŋgpqe, Hiniqu Qäukuä Yätu Äpmeŋqä Iqu kimaŋi metapqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Iŋi si ämaqä nätmatqä maeqä iquau yätamäkqä wisŋqä itŋäŋgaŋi, ämaqä hääwä-tqä hŋqu hiŋuiqä äkimetä, ämaqe hiŋuä kqämbŋqä tuätumetŋqeŋqe, mändowatqä isŋqeqä. Ämaqä wopqä ipu, kukŋuinä tqä iqua, yoqe haqeqä muämäupŋqä aŋä aquväqŋqä iutä, hänaqä iutä, iiŋä itqäŋuwä iquaiqä. Nyi naqä-qakuänäŋä etqänä. Ämaqä tqua, iquauqä suqä iutaŋi kima ae ämeqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Iŋäqe si ämaqä nätmätqä maeqä hŋque yätamäkqä wisŋqä itŋäŋgaŋi, sämaqä iqua-pqä maqŋqä hipŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iiŋä etaŋgi suqä tqu zä witätŋqeqä. Iŋi tqä Tniqu zä wiqä imä hiŋuä äqunäŋqe, Iqu suqä iutaŋi kima ktapäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Itaŋga he tääqä ätäpiyäŋgaŋi, ämaqä wopqä ipu, kukŋuinä tqä iqua imäkätqäŋuwä-pa, mimäkqä pa iqäpŋqeqä. Ämaqe, iquau hiŋuä qumbŋqä diŋqä, aŋä aquväqŋqä yäpä iŋgisatä, hänaqä äuktäuqä iutatä pämä ätqäupu, tääqä tpŋqä äwinyätŋqä iquaiqä. Nyi naqä-qakuä etqänä. Ämaqä tqua, iquauqä suqä iutaŋi, kima ae ämeqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Iŋi si Goti Hanjuwä Iquenyqä tääqä ätätŋäŋgaŋi, aŋä hiqŋqä ämaqä maeqä iŋgisa äwätnä, qŋqaŋä ämäyeŋi, zä äpmanä tääqä tquätŋqe. Si iiŋä imäkqaŋgŋäŋgaŋi, tqä Tniqu zä wiqä imä hiŋuä äqunäŋqe, Iqu tqä suqä iutaŋi, kima ktapäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","He tääqä ätäpiyäŋgaŋi, tääqä kuapänä hiŋginäwa, ämaqä Goti Hanjuwä Iquenyqä quuvqä maeqiyqä iqua ätätqäŋuwä-pa, matqä iqäpŋqeqä. Ämaqä iqua kŋuä tiiŋä indqänätqäŋuwi. ‘Ne Iquenyqä tääqe, quäuqänä ätquque, Goti Iqu qätä neyäŋqiyä.’ Iŋäqe, oeyqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","He iquauqä suqä iuŋi qänaki miqä pambiyä. Ii tiiŋiqä. He yatŋqä mävqä änä etaŋgaŋi, hiqä Hiniqu nätmatqä eeqänäŋiŋqä äwa itqäŋuwiŋqe, Iqu näqŋqä ae eänä. ");
INSERT INTO mcr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iŋi he tääqe, tiiŋä tqäpŋqeqä. ‘Neqä Apä Qäukuä Yätu Äpmeŋä Iquki, Tqä yoqe huiziquau ämäwqätäuä, naqänäŋä äqonäŋinyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tqänä miqe, äpänä. Qu qäukuä haqä yätuŋi, Tqä äkinyäŋqeu qänaknä itqäŋuwä-pa, qua täuŋä-pqe, asä ii iqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Täŋgaŋi Si buayä hiunji tquenyqe, änätaptŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ämaqä quvqä inetqueqaŋguwä iquauŋqä ne äwqä haŋuä imäknätuŋquä-pa, Si nenyqä äwqä haŋuä imäknätnä, neqä suqä quvqe huätä mänamäutŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yamwiqä nemetŋqä itŋqä iuŋi, Si hiŋuinä mäquŋquä panä. Ämaqä quvqä imäkqä iqueqä hipa iuta aŋgu inätmetnä, metäuku neyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","He iiŋä ätquwi, ii tiiŋiqä. He ämaqeuqä suqä quvqeŋqä äwqä haŋuä imäkŋgaŋgpqe, hiqä Hiniqu Qäukuä Haqä Yätutaŋä Iqu äwqä haŋuä imäknätä, hiqä suqä quvqe huätä maitnämäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Iiŋä etaŋgqä-qe, he ämaqeuqä suqä quvqeŋqä äwqä haŋuä mimäkŋqä iqaŋgpqe, hiqä Hiniqu äwqä haŋuä mimäkŋqä itä, hiqä suqä quvqe huätä mämaitnämäuqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Itaŋga he hiqä tääqä yäŋänäqŋqä imäkpŋqeŋqä buayä pmua imäknäpiyäŋgaŋi, ämaqä wopqä ipu, kukŋuinä tqä iqua, hipeŋui iuismäknätqäŋuwä-pa, mimäkŋqä iqäpŋqe. Qu hipeŋuä quvqä iiŋä imäknätqäŋuwi, ämaqä huiziqua, qu buayä pmua imäkŋgaŋguwiŋqä näqŋqä mapŋqä imäkätqäŋuwi. Nyi kukŋuä naqä-qakuänäŋä etqänä. Ämaqä iqua, iquauqä suqä iutaŋä kimaŋi ae ämeqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Itaŋgi si buayi pmua imäknätŋi, eqä jinaŋä-weqe tqä nyuäŋä iu equatnätnä, tqä hipeŋuä iuŋi asŋä qändŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Si iiŋä imäkätŋi, buayä pmua imäknätqäŋiŋqe, ämaqe qu sinyqe maqŋqä iqaŋguwä-qe, tqä Tniqu si hiŋuä mäquŋquä eŋä Iqu kiqä-kiuänä näqŋqeqä. Itaŋi Iqu nätmatqä zä wiqä imä hiŋuä äqunäŋqe, tqä suqä iutaŋä kima ktapäniqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“He nätmatqä äŋguänäŋä, qua täuŋi aquvä maqiyqä ipŋqeqä. Nätmatqä qua täuŋi, imätaŋuä äquvätä, kukuiŋuä itä, itaŋga ämaqä quwä-meqä iqua täkŋi äpnasäpu mapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iiŋiŋqe he nätmatqä äŋguänäŋä aquvi, qäukuä yätutaŋi qäpŋqeqä. Yätuŋi, imätaŋuä maquvqä itä, kukuiŋuä miqä itä, itaŋga ämaqä quwä-meqe, täkŋä mäpnasqä ipu, quwä mämeqä da ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tqä kŋuä indqäŋqä imŋitä, äkiŋqä imŋitä nätmatqä äsquenyqe, ‘Ii äŋguiqä. Nyi ämamqänä’ kŋuä äkiyätŋqe, tqä kŋuä indqäŋqe, asä iunä witätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tqä hiŋui, huiwä iqueqä hiqi-tä eŋqä-paŋiqä. Tqä hiŋui äŋguä äqännä, si ämaqe yätamäkqä wiyquki hitaŋgutqe, tqä huiwä eeqänäŋä imŋi, we äŋguä äkunänä. ");
INSERT INTO mcr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Iŋäqe, tqä hiŋui quvqä äqännä yätamäkqä mävquki hitaŋgutqe, tqä huiwi eeqänäŋä imŋi hea äwinä. Iŋi we-huŋqä tqä huiwä imä äwiŋqä ii hea witaŋgutqe, pisqukuinänjqä. ");
INSERT INTO mcr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ämaqä hŋqu, ämiqä hŋquaquiyqä yäpä iŋgisa mäpmeqä yäŋqiyä. Iqu hŋquenyqänä äwinyätä, huiziquenyqä mäwiŋqä yäŋqiyä. Itaŋga iqu kukŋuä qäte, hŋquenyä äwiyätä, hŋqueŋi qätä mäwiyqä yäŋqiyä. Ämaqä hŋqu mbqäŋqä äwiŋqä iuŋi, yäpä iqi imitätqe, iqu Goti Hanjuwä Iqueqä yäpä iqiŋi mäpmeqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Iiŋiŋqä Nyi he etqänä. He ‘Ne ymisaŋitä, eqetä, squä natuŋquäwä?’ kŋuä indqänäpu, hiqä häŋä-pmeqä iuŋqä qundqändqä kiiŋä miqä pambiyä. Itaŋga ‘Qäki äki yäuatuŋquäwä?’ kŋuä indqänäpu, hiqä huiwä iuŋqe, äwäwa kiiŋä miqä pambiyä. Ymisaŋitä qäkitäŋi, huiwä iuŋitä häŋä-pmeqä iuŋitäŋi, mämäwqätäuqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","He yŋŋä iquauŋi hiŋuä qumbiyä. Qu ymisaŋä vowä mamäuqä ipu, aquvä mämaqiyqä ipu, buayä aŋä iu maeqä itqäŋuwä-qe, hiqä Hiniqu Qäukuä Yätu Äpmeŋqä Iqu iquauŋi buayi ävätqänä. Yŋŋä iqua ämaqä-quneŋi mämänaqutäuqä iŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Itaŋgi hesaŋä hŋqu iqueqä häŋä-pmeqeŋqä äwäwa kiiŋä itä, wiyä nändi iqa wäniqiyä? Oeyä. Änä maeqä inä. ");
INSERT INTO mcr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","He qäkä-gquä isuaŋqe, äwäwa suŋqä itqäŋäuä? Qätaqä hutqä hiŋginäwa ätäŋqä iuŋi, he hiŋuä äŋguänä qumbiyä. Qu hutqä tpŋqe, äänä imäkqäpiyä? Qu wäuŋuä yäŋänäqŋqä miqä ipu, qäkä ämuasmäŋqä mimäkqä itqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Itaŋgi Nyi he etqänä. Hiŋuiqänäŋi ämaqä miqä Solomonä iqu, iqueqä yoqä naqä motquetŋqä vä-yauqä äŋguä-täŋä qäyä etaŋgqä-qe, vä-yauqe, qätaqä iquauqä hutqe mämäwqätäuqä inä. ");
INSERT INTO mcr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Qätaqä hutqe, täŋga hiŋginäwa ätqäwäŋqe, awiŋgaŋi yäuä piqaŋguti, qu ätäupu tä du tnämäupŋqä iqaŋgpqä-qe, Goti Hanjuwä Iqu huvä-quayuŋuä iwimäkätqänä. Iqu heŋi asä inä emäkäŋqutiyä, memäkqä yäŋqutiyä? He Iquenyqä quuvqä wäŋqäpu eqiyätqäŋuwä iquenä, Iqu heŋi haqä nändi emäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iiŋiŋqe, ‘Ne ymisaŋitä, eqetä äkitaŋi natuŋquäwä? Ä, qäkä-gque äki yäuatuŋquäwä?’ ätäpu, äwäwa kiiŋä miqä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ii tiiŋiqä. Ämaqä Goti Hanjuwä Iquenyqä quuvqä maeqiyqä iqua, nätmatqä eeqänäŋä iiŋqe, äwäwa ipu qävqä itqäŋäuä. Itaŋgi he äŋguä pmapŋqeŋqe, nätmatqä ii mapŋqä diŋqe, hiqä Hiniqu Qäukuä Yätu Äpmeŋqä Iqu näqŋqä ae eänä. ");
INSERT INTO mcr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Itaŋgi kiŋganäŋi he Goti Hanjuwä Iqunä miqä iu äpmepu, Iqueqä suqä jänäŋi mapŋqe, qävqä ipŋqeqä. Itaŋgaŋi he nätmatqä huiziŋqä äwäwa itqäŋuwi, Iqu eeqänä inä hitapäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iiŋiŋqe he awiŋgaŋqe äwäwa miqä pambiyä. Hiunji iqu, äwäwa iqueqä-kiuäŋqä iquäŋqä. Haŋä-iqä hiunji hŋque ätimäuqe, ii hiunji iqueqe, qäyuvqä.” ");
INSERT INTO mcr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ämaqä hŋquauŋqe, ‘Ämaqä quvqä-quaiqä’ ätäpu, miwäsäuqä pambiyä. Goti Hanjuwä Iqu suqä asä iiŋä di, he-pqe inä emäkqäŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ii tiinjqä. He ämaqä hŋquauä suqe iwäsäutqäŋuwä-paŋä iiŋi, Goti Hanjuwä Iqu heyaqe, inä iwäsäutäqäŋgaŋi, asä e iwäsäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Si hinoqukuä wäŋqä hmbu tqä tta-tuŋgueqä hiŋuä iu witaŋgi äqunätŋä-qe, zä naqänäŋä tqä hiŋuä iu äwiŋqe, hiŋuä mäquŋquä iŋinyä. Ii suŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Zä naqänäŋä iqu, tqä hiŋuä iu yqänä witaŋguti, si tqä tta-tuŋgueŋi, ‘Hinoqukuä tqä hiŋuä iu änyäŋqe, huätä mäkmäumqänä-qe’ äänä tutŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Si wopqä itnä, kukŋuinä tqä iqukiyqä. Si zä tqä hiŋuä iu äwiŋqe, huätä ganä mamänyä. Itaŋi iŋganä hiŋuä äŋguänä äqänätnä, hinoqukuä huiziqueqä hiŋuä iu änyäŋqe, huätä mamäutŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","He nätmatqä Goti Hanjuwä Iquenyqä ätä äwiŋqä iuŋi ämepu, hiveqä quvqä iquau mävqä pambiyä. Iqua nätmatqä iiŋi, hiŋuinä ämäquŋgua hiquaŋä hitäpŋqäuä. Itaŋga wimŋä äŋguänäŋi, yaqueqä iquau matnämäuqä pambiyä. Iqua qonjqenä ipŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“He tääqä ätuäpu, Goti Hanjuwä Ique yatŋqä vqäpŋqeqä. Iqu etapäŋqiyä. He qävqä iqa uwqäpŋqeqä. Goti Iqu he ämäqumuapŋqeŋqä yätamäkqä hiyäŋqiyä. He qŋqaŋi ptqä qäyqäpŋqeqä. Goti Iqu qŋqaŋä euteyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ämaqä nätmatqäŋqä tääqä ätuäpiyä iqua, qu ämapŋqäuä. Ämaqä qävqä ipiyä iqua, ämäqumuapŋqäuä. Ämaqä qŋqaŋä ptqä qiyäpiyä iqua, Goti Iqu qŋqaŋä wuäteyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hesaŋä hŋqueqä ymeqä hŋqu, bretqäŋqä kiqä kanique yatŋqä vqaŋgutqe, iqu hiki muayäniqiyä? Oeyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Itaŋga ymeqä iqu kanique hämapäkäŋqä yatŋqä vqaŋgutqe, iqu qämakä quvqe muayäniqiyä? Oeyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kaniquenä, suqä quvqä kuapänä imäkäpiyä-qe, hiqä ymeqä iuŋi, nätmatqä äŋguänäŋi äyä ämuayätqäŋuwiqä. I etaŋgi hiqä Hiniqu Qäukuä Yätu Äpmeŋqä Iquenyqä näqŋqä äŋguänäŋi mapŋqeqä. Iquenyqä tääqä tquaŋguwä iquauŋi, nätmatqä äŋguänäŋi väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Itaŋi, suqä ämaqä huiziqua he emäkpŋqä eŋgaŋgutqe, he-pqe suqä asiqunä motquapiyä. Suqä iiŋä iqu, kukŋuä-suqä Mosisi iqu ätätä äqäkqetä, hiŋuä-tqä iqua äqäkuwitäŋi, kiqä quatiyqä.” ");
INSERT INTO mcr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hänaqä aŋä qui imäkŋqä iuŋqä änyäŋqä iqu, aaŋä hiqŋqä naqänäŋiqä. Iwä ämaqä hänaqä iu qänaknä itqäŋuwä iqua, kuapänäŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Iŋäqe hänaqä aŋä häŋä-pmeqä ämepu pmeqä iuŋqe, äpätäuqumäkqä änyä, änä mäwqänäŋiqä. Itaŋga hänaqä iuŋi, ämaqä hŋqunä-hŋqunä ämäqumuepu qänaknä itqäŋäuä. He hänaqä iunä uwqäpŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“He hiŋuä-tqä quaŋgä iquauŋi, äŋguänä wimasipiyä! He iquauŋqe, ‘Iqua sipsipqä eŋqä-pa äwqä haŋuä änyäŋäuä’ kŋuä eyätaŋgqä-qe, quwqä kŋuä indqäŋqe, hiveqä hiqiyqä iquauqä eŋqä-paŋä-qae, qui emäkpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","He zä hŋqueqä häukui iwäsäupu, iquenyqä näqŋqä ämetqäŋuwä-pa, ämaqä iiŋä iquauqä wäuŋui, iwäsäupu näqŋqä mapŋqeqä. Ämaqe, guä-wainqä häukui dupŋqe, guä yäŋä-täŋä iuŋqä upŋqätanä? Ä, zä-eaqä häukuä dupŋqe, qu qätaqä guaqä-täŋä iuŋqä upŋqätanä? Oeyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Zä äŋguä eeqänäŋä iqua, häukui äŋguä wiŋqiyä. Zä quvqä iqua, häukui quvqä wiŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Zä äŋguänäŋi, häukui quvqä maqiyqä yäŋqiyä. Zä quvqä iqua, häukui äŋguä maqiyqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Zä kiqä häukui äŋguä maqiyqä iqua, ätäupu tä du väupŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iitä asänäŋi. Hiŋuä-tqä quaŋgä iquauqä suqe, hiŋuä äqunäpu, iquauŋqe näqŋqä mapŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ämaqä Nyiŋi, ‘Naqä Iqukiyqä’ ändätqäŋuwä iquauŋqe, he kŋuä tiiŋä maeyqä pa inä, ‘Qu eeqänäŋi Goti Qäukuä Yätutaŋä Iqunä miqeuŋqä epnuwiqä.’ Ämaqä Nyaqä Apiqu Qäukuä Yätu Äpmeŋqä Iqueqä äwiŋqä iunä qänaknä imitpqä iquanä hipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hiunji Goti Iqueqä kukŋuä mitqä naqä iŋgaŋi, ämaqä kuapänäŋi tii dpnuwiqä. ‘Naqä Iqukiyä, ne hiŋuä-tqä wäuŋui imäkätanä, dŋä quvqä iquau huätä ändowatätanä, ämaqä mimäkqänäŋä iuŋi imäkätanäŋgaŋi, Tqä yoqetanä imäkmiŋqueqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iquauŋi, Nyi kimaŋi tii tumniqeqä. ‘Nyi tutqä qäpu henyŋqe änyä maqŋqä eäŋänä. He ämaqä suqä quvqä kuapänä imäkquenjqä. Huätä upiyä!’” ");
INSERT INTO mcr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nyi kukŋuä etqä tä, ämaqä hŋqu qätä änyiyätä qänaknä imitätqe, ii tiiŋiqä. Ämaqä kŋuä äŋguänäŋä indqänätä, aŋi hikä haqeu ämätqä-paŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Piyä äqiyätä, huakä äpätä, yuŋuä naqänäŋä äqunätä, aŋä ique hevqäŋgaŋgutqäŋga, hiki qua buta äknä, ique a yäŋänäqŋqä kiqätätaŋgi, qua iqä mäpnasqiyäuqä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","I etaŋgi, ämaqä hŋqu, Nyaqä kukŋuä iu qänaknä miqä imitätqe, ii tiiŋiqä. Ämaqä kŋuä mämeqä itä, aŋä weä haqeqi ämätqä-paŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Itaŋga piyä äqiyätä, huakä äpätä, yuŋuä naqänäŋä äqunätä, aŋä ique hevqäŋgaŋgutqäŋga, aŋä iqu äpisäutä, qui eeqänä imäknäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisasi Iqu kukŋuä ii qäpu tqaŋga, ämaqä Iqueqä kukŋuä qätä äwipiyä kuapänäŋä iqua, Iqueqä näqŋqä motquetqätaŋgqeŋqä yäuŋuä naqänäŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Quwqä ämaqä kukŋuä-suqeŋqä näqŋqä iqua ämotquamiŋuwä-pa, mämotqueqä itä, Yoqä-täŋä-qu eä, ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iqu qoqoŋä iuŋi äväma quveqeqaŋga, qokä-apäkä kuapänäŋi, Ique qänaki äwivändqa äquveqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iŋgaŋi ämaqä wänyimäŋqä-täŋä hŋqu Ique äwimeqe, qoŋä äwoktäutä ätukqe. “Naqä Iqukiyä. Si äkiŋgaŋgutqe, nyi äŋguä nyimäktŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","I tquaŋga, Iqueqä hipae, ämaqä iqueqä huiwiu itmaqiyätä, “Nyi änyiŋgiyä. Si äŋguä kimänänä” tquaŋga, maqänäŋi wänymäŋqe qäpu eätä, ämaqä iqu äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Itaŋi Jisasi Iqu iqueŋi, “Si äkimeqeŋqe, ämaqeu mätquä panä. Si äwätnä, tqä huiwi ämaqä Goti Iquenyqä hiqäva-imäkqä ique ämotquetnä, Mosisi iqu hiŋuiqänä ätkqä-pa hiqäva imäkiyä. Tqä yaqe qäpu eqeŋqe, ämaqe, näqŋqä iuta hipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisasi Iqu aŋä-himqä Kapänamäŋi yäŋgisa peyqaŋga, ämaqä Romätaŋä mäkä-iqä iutaŋä naqä hŋqu äwimetä, yatŋqä yäŋänäqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Naqä Iquki, nyaqä wäuŋuä-nyiyqä hŋqu yaqä vqaŋgi, aŋä du hiqaqä äwinä. Iqueqä yäŋi ŋŋuä itä, täŋä-huŋqä naqänäŋä ämetqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kimaŋi Jisasi Iqu, “Nyi äwätmä äŋguä iwimäkmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","E tquaŋga, ämiqä iqu kimaŋi, tiiŋä ätukqe. “Naqä Iquki, Si nyaqä aŋä täŋgisaŋqä yaptŋqe, nyi ämaqä äŋguänäŋä-qunä hmanjqä. Iŋi Si kukŋuinä tqaŋgti, nyaqä wäuŋuä-nyiyqä iqu äŋguä imänänä. ");
INSERT INTO mcr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nyi-pqe inänji. Nyi ämaqä yoqä-täŋä hŋqueqä yäpä imä äpmamä, ique qänaknä inä wimqänä. Nyaqä ämaqä mäkä-iqä nyi ämitŋqä iquauŋi, hŋque ‘Si uvä’ tquaŋgundqe, iqu äwäŋqiyä. Hŋque ‘Si biyä’ tquaŋgundqe, iqu äpäŋqiyä. Itaŋga ŋqä wäuŋuä-nyiyqä hŋque ‘Si tä imäkiyä’ tquaŋgundqe, iqu imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisasi Iqu kukŋuä ii qätä äwiyäqe, yäuŋuä itä, ämaqä Ique qänaki wivändätaŋguwä iu ätukqe. “Nyi he etqänä. Ämaqä yäpaqäŋgisaŋä tqueqä quuvqä eqiyätŋqä-paŋä iiŋi, Israitqä duŋi, Nyi hiŋuä mäquŋquä itŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tiiŋä-pqe etqänä. Ämaqä kuapänäŋi mäptqä yapqä iŋgisatä, mäptqä wiqä iŋgisaŋä iqua, qu Goti Qäukuä Yätutaŋä Iqunä miqeu ätimäupu, Aprähamä iqutä, Aisakä iqutä, Jekopä iqutä buayä anä bŋqä quamä pmapnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iŋäqe Israitqä, Goti Hanjuwä Iqunä miqeu pmepŋqä atäuŋuä kiŋganä ikqä iquauŋi, Goti Iqu hiawiqä iŋgisaŋqä huätä dowatäniqeqä. Iqiŋi qu kŋuä kuapänä äqiyäpu, hiquaŋä maŋgtäsqukuä mäuqäpnuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","E ätuäqetaŋi, Iqu ämiqä ique, “Si ätuŋqueqä. Nyi imäkmqeŋqä quuvqä ae eqŋä-pa timäuŋqiyä” ätukqe. Iiŋä tquaŋga, asäŋgaŋi ämiqä iqueqä wäuŋuä imäkqä iqu, äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","15","Iŋgaŋi Jisasi Iqu Pitä iqueqä aŋä yäpä iŋgisa äpaquväqe, Pitä iqueqä känemi huiwä tnäŋä wimäŋgaŋgi, iquvaŋä iu witaŋgi äqunäqe, kiqä hipa iu itmaqiyqaŋga, huiwä tnäŋä iqu ävämeqaŋga, ii ävautä Iquenyqä buayä näwenyä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mäptqä äwitŋqä iqaŋgaŋi, Jisasi Iquenyqä ämaqä peŋqä-täŋä kuapänäŋä ätuma äpkuwi. Iqu peŋqä iquau kukŋuä ätuätä huätä ändowatätä, yaqä-täŋä iquauŋi äŋguä qe imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iqu iiŋä imäkätä, Goti Hanjuwä Iqueqä kukŋui, hiŋuä-tqä Asayä iqueqä maŋä iuta ätkqä hŋque, qäyunä imäkqaŋgi ätimäukqe. “Iqueqä-kiuäŋi, neqä yaqä huitaŋä-huitaŋi ämetä, huätä ämamäuqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisasi Iqu, ämaqä kuapänäŋi Ique qäuiqä eŋqä-pa äkutäupu, pämä tqäutaŋgä äqunäqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “Ne eqä-huäŋä yätäqä näŋgisaŋqä äwanä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Iŋgaŋi ämaqä kukŋuä-suqeŋqä näqŋqä hŋqu äpäqe, Jisasi Ique tiiŋä ätukqe. “Ämotqueqä Iqukiyä, Si aŋä-himqä eeqänäŋä iuŋqä uwqaŋgtqe, nyi qänaknä kivändmqänä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisasi Iqu kimaŋi tii ätukqe. “Hiveqä hiqiyqä iqua, iquauqä aŋä-täŋiqä. Yŋŋä iqua, aŋä-täŋiqä. Iŋäqe, Ämaqeuqä Ymeqä Ekqä Iqu, Iqueqä aŋä hiqaqä wiqe, hmanjqä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Itaŋga wäuŋuäŋqä ämotquamiŋqä hŋquququ tii ätukqe. “Naqä Iquki, ŋqä apique ganä, qua qäyä mapteumqänä, hiŋuinä ŋqänäwqatiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","I tquaŋgaŋi, Jisasi Iqu kimaŋi tii ätukqe. “Qäyä eänä. Ämaqä ae äpäkombqä iqua, quwqä ämaqä pizqä iqueŋi, qua qäyä ptepŋqeqä. Si Nyi qänaki nyivändiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kukŋuä e ätmbiyitaŋi, Jisasi Iqu yimba iu tkamäuqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua anä ätkamäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Qu eqä-huäŋä Galili awä iqi wätqätaŋguwäŋga, yuŋuä naqänäŋä hŋqu ätimäutä, eqä änyuämäwa äpäyätä, yimba iqueŋi qui imäkätŋqä iqaŋgqä-qe, Jisasi Iqu hiqaqä yqänä äwämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iiŋqe qu äwäpu, Ique ämeŋä äväpu tii ätukuwi. “Naqä Iquki, ne qui imäknatŋqä iqunä. Yätamäkqä neyä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iwä Iqu, “Täukueqä! Hiqä quuvqä heqiyqe, wäŋqäpiyqä. He ze, suŋqä eŋgiyä?” ätukqe. Itaŋi Iqu yuŋuä iquesä, eqä iquesä, “Iiŋi miqä manyinyqä” tquaŋga, iquaqu ämŋäŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iŋgaŋi ämaqä iqua yäuŋuä ipu, tii ätŋguwi. “Ae! Ämaqä Tqu äkitaŋä änääŋukä? Yuŋuä iqutä, eqä iqutä, Iqueqä kukŋui qätä äwiyqiyiuä.” ");
INSERT INTO mcr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Itaŋi Jisasi Iqu eqä-huäŋä yätäqä näŋgisa ätimäuqe, qua Gatala iu iuäqämakqe. Iqiŋi ämaqä peŋqä-täŋä hŋquaqu hikä hovqä ämaqä pizqä emiŋuwä iuta äpäsinyä äwimakiyi. Iquaqu hiqi tqäutaŋginyiŋqä, ämaqe huäŋqä iuŋi mäwqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ique äwimayi, zääqä yäŋänäqŋqä ätukiyi. “Goti Hanjuwä Iqueqä Ymeqä Iquki, squä nemäktŋqäwä? Hea qäyuŋi matimäuqä qäyä etaŋgi, Si qui nemäktŋqä äpinyä?” ");
INSERT INTO mcr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yaqueqä kuapänäŋi kiŋä näŋi ätqäupu, ymisaŋä änmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Itaŋga peŋqä iqua yatŋqä yäŋänäqŋqä äväpu, “Si huätä nandowatqaŋgtqe, ne yaqueqä iquau-mända paquvatuŋquä hiŋuinä naqänyä!” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","I tquaŋguwäŋga, Iqu “He upuiyä” ätukqe. Itaŋi peŋqä iqua ämaqä iquaquiŋi äväma, yaqueqä iquauqä yäpä iŋgisa äpaqukuwi. Iŋgaŋi yaqueqä eeqänäŋä iqua tnäŋä äwäpu, iwaqä iuta eqä-huäŋä buŋqä äpäquveqäpiyi, eeqänäŋi eqä änyuäpätäkqe. ");
INSERT INTO mcr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ämaqä yaqueqä miqä iqua hiŋuä e äqumbiyi, zä aŋä-himqä iuŋqä äwäpu, iiŋä timäuqaŋgqeŋqätä, itaŋga ämaqä peŋqä-täŋä iquaqui äwimakqeŋqätäŋi, ämaqeu ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Itaŋga ämaqä aŋä iutaŋä eeqänäŋi, Jisasi Ique wimapŋqä äpkuwi. Qu Ique hiŋuä ae äqumbiyi, Iqu qua iu ävämetŋqä yatŋqä yäŋänäqŋqä äwimiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","I tquaŋguwäŋga, Jisasi Iqu yimba hŋque ätkapmäuqe, eqä-huäŋä yätäqäŋgisaŋqä aŋgumä äwätä, Iqueqä aŋä-himqä iu ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iŋgaŋi ämaqä hŋqua, yäŋä ŋŋuä-täŋä hŋque, iqueqä yquvaŋä iunä witaŋgi Iquenyqä ätuma äpkuwi. Itaŋi Iqu iquauqä quuvqä heqiyqe naqä-qakuänäŋä äqunäqe, ŋŋuä-täŋä iqueŋi tii ätukqe. “Ŋqä ymeqä iquki, tqä äwqe haŋuä äkinyänä. Nyi tqä suqä quvqe, huätä ae ämakmäuqänä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ämaqä kukŋuä-suqeŋqä näqŋqä hŋqua, Iqu e tquaŋgi äwipiyi, quwqä kŋuä indqäŋqä imnä tiiŋä indqäŋguwi. “Ämaqä Tqu Goti Hanjuwä Iqu eŋqä-pa timäutŋqä iqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisasi Iqu iquauqä kŋuä indqäŋqeuŋi näqŋqä eätä, tii ätukqe. “He heqä kŋuä indqäŋqä iutaŋi, kŋuä quvqe suŋqä indqänätqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nyi iqueŋi, ‘Tqä suqä quvqe huätä ämakmäuqänä’ ätuätmä imäkmqe, yäŋänäqŋqä-täŋunjqä. Itaŋga Nyi iqueŋi, ‘Si ävautnä qaŋä uvä’ ätuätmä imäkmqä-pqe yäŋänäqŋqä-täŋunjqä. Qäquaqu asänäŋi. ");
INSERT INTO mcr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iŋi Ämaqeuqä Ymeqä Ekqä Iqu, qua täuŋi suqä quvqe huätä mamäuŋqiyä-qe, he näqŋqä mapŋqä änyiŋgiyä.” E ätuäqetaŋi, yäŋä ŋŋuä-täŋä iqueŋi, “Si pämä ätqäutnä, yquvaŋä ämetnä, tqä aŋä iuŋqä uvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I tquaŋga ämaqä iqu ävauqe, iqueqä aŋä iuŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ämaqä iqua hiŋuä iiŋä äqumbiyi, zä ipu, Goti Iqu ämaqeuŋi yäŋänäqŋqä iiŋä vqaŋgqeŋqä, Iqueqä yoqe haqeqä ämamäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisasi Iqu aŋä ique äväma äwätäqäŋgaŋi, ämaqä hŋqu mbqä motauqä aŋä iu pmetaŋgi äquŋgqe. Iqueqä yoqe, Matiu ique. E äqunäqe, iqueŋi, “Qänaki nyivändiyä” ätukqe. Iŋi, Matiu iqu ivatuwänäqe, Ique qänaki qe äwivändkqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ga Jisasi Iqu, iiŋä iqueqä aŋä iu buayä änätä pmetaŋga, ämaqä mbqä motauqä kuapänäŋä hŋquatä, suqä quvqä imäkqä kuapänäŋä hŋquatä äpäpu, Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua-pqetä buayä anä äŋgmanmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi hŋqua hiŋuä e äqumbiyi, wäuŋuäŋqä ämotquamiŋqä iquau yatŋqä äwikuwi. “Hiqä Ämetqueqä Iqu buayi, ämaqä mbqä motauqä iquatä, suqä quvqä imäkqä iquatä, anä änätŋqe, äänä etaŋgiwä?” ");
INSERT INTO mcr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisasi Iqu qätä e äwiyäqe, tii ätukqe. “Ämaqä yaqä maeqä iqua, duuta iquauŋqe, mäwqä ipŋqäuä. Ämaqä yaqä-täŋä iquanä upŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nyi äpqe, ämaqä jänäŋä iquau tääqä tuätumamqä äpqä hmanjqä. Oeyä. Nyi ämaqä suqä quvqä imäkqä iquau tääqä tuätumamqä äpqeqä. Iiŋiŋqe he Goti Hanjuwä Iqueä bukä iu tiiŋä äqänäŋqe, näqŋqä mapiyä. ‘He hiqäva imäkätqäŋuwiŋqe, manyiŋqä iqiyä. He ämaqä iquauŋqä qeqä emäŋgaŋguti äŋguä itquapŋqä änyiŋgiyä.’” ");
INSERT INTO mcr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iŋgaŋi ämaqä Jonä iqu ämotquamiŋqä iqua, Jisasi Ique äwimepu yatŋqä äwikuwi. “Ii änääŋäŋqäwä? Nesä, Parisi iqua ämotquetqäŋuwä iquatä, tääqä yäŋänäqŋqä imäkatuŋquä diŋqä, buayä maŋqä imäknätanä yakuä äpmetuŋqueqä. Iŋäqe ämaqä Si ämotquetqäŋä iqua, iiŋä miqä itqäŋuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisasi Iqu kimaŋi, kukŋuä ktqä tii ätukqe. “Ämaqä apäkä metŋqä hŋqu, iqueqä käyämaqä iquatä yqänä pmetaŋga, qu äwqä haŋä iuta hipeŋuä iuismäknäpu pmapnuwäŋqätanä? Oeyä. Qänakndaŋi, huiziqua ique ätuma uwqaŋguwäŋga, iqueqä käyämaqä iqua iŋganä imäkmbu pmapnuwäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Itaŋga, gquä yäuä hŋqu äpkŋgqe, ämaqä hŋqu yuä änyä-häŋä hŋquesaŋä ätävätä, hovqä yäuä ique mapmävqä yäŋqiyä. Iqu e imäkätqe, asŋä äqiyätäqäŋgaŋi änyä-häŋä guä e äktäpitqä iqu, yäuä iqueŋi qui naqänäŋä imäkätä, hovqä naqä väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tiiŋi iinänjqä. Ämaqä hŋqu wainqä-eqä änyä-häŋä hui yaqueqä huiwä yäuä du mequatimäuqä yäŋqiyä. Iqu e imäkätqe, wainqä-eqä änyä-häŋi, yaqueqä huiwä yäuä iqueŋi äpisätä, qua bu hiquatäuŋqiyä. Yaqueqä huiwä-pqe, qui inä imäknäŋqiyä. Wainqä-eqä änyä-häŋi, qu yaqueqä huiwä häŋä iu iquatimepŋqäuä. Iŋi qäquaqu äŋguänäŋäŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisasi Iqu, ämaqä Jonä iqu ämotquamiŋqä iquau, kukŋuä ii yqänä tuätqätaŋga, ämaqä miqä hŋqu äpäqe, Ique qoŋä äwoktäutä tii ätukqe. “Ŋqä ymeqä apäkä ii, täŋga äpäkoŋgqä-qe, Si äpätnä Saqä hipae haqeqi wiyqaŋgti, häŋä vautŋqänänyä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iqu e tquaŋga, Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä pämä ätqäpiyi, ique äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","E äwäpiyä imdaŋi, apäkä hui Jisasi Iqueä tuwä-täŋä qäqiqi äpäqe, Iqueqä gquä iu itmaqäŋgqe. Ii hea ique-iqueŋi, qaŋuä yaqä e pmetaŋgi, quväukuä 12 ämäwqätäukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ii kŋui, “Nyi Iqueqä gquä iu itmaqänmqe, äŋguä nyimänäŋqiyä” indqänätä, iiŋä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ii Ique itmaqiyqaŋga, Iqu hiqumuaŋä äwiyäqe, ii hiŋuä äqunätä tii ätukqe. “Ŋqä ymeqä iiki, tqä äwqe haŋuä äkinyänä. Si Nyinyqä quuvqä eqäŋä-qae, äŋguä äyä ikimäkqänä.” Hea iŋgata-tiŋi, äŋguä äpmaka äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Itaŋgaŋi Jisasi Iqu ämiqä iqueqä aŋä iu äpaquväqe, ämaqä hŋqua hääwä ätäpu, qokä-apäkä kuapänäŋi kŋuä yäŋänäqŋqä qäkmanätqätaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Itaŋi Iqu tii ätukqe. “Ii mäpäkoŋqä iqeqä. Oeyä. Ii hiqaqenä äwinä. He huätä upiyä.” E tquaŋgqetaŋi, qu Iqueŋi tä äsukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Qu iquau yäpaqä mäŋgisa huätä dowatqaŋguwäŋga, Iqu hiqŋqä ii witaŋgqä iŋgisa äpäwäqe, iiyqä hipa iu a maqätqaŋga, ii ävaukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iŋi Iqu i imäkqaŋgqeŋqe, kukŋui hiŋginäwa im-imä ätqa äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisasi Iqu aŋä ique äväma wätqätaŋgaŋi, ämaqä hiŋuä pisqä hŋquaqu, Ique qänaki äwivändäsinyä, tääqäqä äumiŋiyi. “Dewiti iqueqä Kawiquki, Si yenyqä qeqä kimänänä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iqu äwätä aŋä iu paquvqaŋgaŋi, iquaqu Ique wimeqaŋgiyäŋga, Iqu yatŋqä äwikqe. “Nätmatqä iiŋi, Nyi qäyunä imäkmqeŋqe, qe quuvqä eqiyqinyqä?” Kimaŋi iquaqu, “Naqä Iquki, ye quuvqä eqiyqueä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Itaŋi Iqu iquaquiyqä hiŋuä iu itmaqiyätä, “Qe Nyinyqä quuvqä eqiyqiyä-paŋi, nätmatqä iiŋi äqemeŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I tquaŋga iquaquiyqä hiŋui äŋguä äqäŋgiyi. Itaŋga Jisasi Iqu kukŋuä yäŋänäqŋqä tiiŋä ätukqe. “Nätmatqä äqemeqeŋqe, ämaqä hŋque awä mätquä panyinyqä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iqu i tquaŋgqä-qe, iquaqu äwiyi, Iqu iwimäkqaŋgqeŋqe, ämaqä eeqänäŋiu awä ätuäkämiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ämaqä iquaqu Ique tii vämeqaŋgiyäŋga, qu ämaqä peŋqä-täŋä, kukŋuä matqä hŋque ätuma äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisasi Iqu peŋqä ique huätä mamäuqaŋga, ämaqä kukŋuä matqä iqu kukŋuä tqaŋga, ämaqe kŋuä kuapä indqänäpu, tii ätkuwi. “Israitqä täuŋi, nätmatqä huitaŋä tiiŋi, hiŋuiqänäŋi matimäuqä imiŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Itaŋgi Parisi iqua, “Iqu peŋqä iquau huätä ämamäuqe, peŋqä naqä iqueqä yäŋänäqŋqetä imäkqiyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisasi Iqu aŋä-himqä eeqänäŋä iu ikitä, aŋä aquväqŋqä iuŋi ämaqeu ämotquetä, Goti Iqunä ämitŋqä iuŋqä kukŋuä äŋgui awä ätuäkitä, yaqä huitaŋä-huitaŋä eeqänäŋi äŋguä iwimäkäkämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iqu qokä-apäkä kuapänä pmetaŋgä äqunätä, iquauŋqä huäqä kiiŋä äwunmiŋqe. Qu sipsipqä quwqä ämiqe hma etaŋgi, äwäwa kiiŋä ipu, qui imäkmbŋqä itqäŋuwä-pa pmetaŋgä äqunmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","E äqunäqetaŋi, Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, tiiŋä ätukqe. “Wäuŋuä iuŋi, ymisaŋä yäuä kuapänä iinä, iŋä etaŋgi ämaqä wäuŋuä iqe, hmbnänjqä. ");
INSERT INTO mcr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iiŋiŋqe ämaqä wäuŋuä iqä häŋä hŋqua, ymisaŋä aquvä ptpŋqä dowatätŋqä iiŋqe, he wäuŋuä Kaniquenyqä tääqä tupŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä 12 iquau tääqä ätuätumeqe, dŋä quvqe huätä ändowatäpu, täŋä-yaqä hiutaŋä-huitaŋä-täŋä iquau äŋguä wimäkpŋqä diŋqä, yäŋänäqŋqetä yoqä naqetä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ämaqä kukŋuä awä tuäkiqäpŋqä dowatätŋqä 12 iquauqä yoqe, tiinji. Kiŋganäŋi Saimonä, iqueqä yoqä huizi Pitä iquvi. Itaŋga käŋguequ, Endru iquvi. Itaŋi Sepri iqueqä hikŋä iquaqu, Jemisi iqutä Jonä iqutänji. ");
INSERT INTO mcr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","4","Itaŋga Pilipä ique, Batromi ique, Tomasi ique, Matiu mbqä motauqä ique, Jemisi Aläpiyasi iqueqä hikŋä ique, Tatiyusi ique, Saimonä ämaqä Selotqä iutaŋä ique, itaŋga Jutasi Iskarioti, ämaqä qänaknda Jisasi Ique ämaqä huiziuqä hipa iu qui imäkpŋqä väniqŋqä iquvi. ");
INSERT INTO mcr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ämaqä 12 iquauŋi, Jisasi Iqu wäuŋuäŋqä ändowatätä tii ätukqe. “Ämaqä Israitqä iqune qäyä etaŋgi huiziquauŋqä mäwqä pambiyä. Sämaliya pmeqä iquauqä aŋä-himqä iuŋi, mäpaquvqä pambiyä. Oeyqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","He Israitqä iquauŋqänä upŋqeqä. Qu sipsipqä, hänaqä qäyunäŋiŋqä maqŋqä eŋqä-paŋä-quai. ");
INSERT INTO mcr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","He äwäpu kukŋuä awi, ‘Goti Qäukuä Yätutaŋä Iqunä miqe, qäukuä yätuta qäqi täqi ae äquvepqeqä’ tupŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ämaqä täŋä-yaqä-täŋä iquau äŋguä iwimäkäpu, ämaqä ae äpäkoŋguwä iquau ävauqumuatäpu, ämaqä wänyimäŋqä-täŋä iquau äŋguä iwimäkäpu, dŋä quvqä peŋqä, ämaqä iquau ätqäuŋqe, huätä dowatäpu iqäupiyä. Nätmatqä he ämeŋuwi, mbqä mävqä ipu hiŋgi ämequwitaŋi, ämaqä iuŋi, hiŋgi wipiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“He qaŋä äwäpiyäŋgaŋi, mbqä-qatä, yquayä qa-mŋqetä, gquä tŋäŋqä hŋqutä, yukä iu ämuasmäuqetä, qaŋä uwqä yäkqetä, qäsä mämeqä pambiyä. Oeyä. Ii tiiŋä hitaŋgiyi. Ämaqä wäuŋuä iqaŋgpqä iquauŋi, ämaqä quwqä yätamäkqä ämetqäŋuwä iqua buayi äwipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","He aŋä-himqä hŋque äpaquväpiyäŋgaŋi, ämaqä suqä äŋguä-täŋä hŋquenyqä qävqä ipu, aŋä-himqä iu ävämepiyäŋgaŋqe, ämaqä iqueqä aŋiunä pmeqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","He iqueqä aŋiu äpaquväpiyäŋgaŋi, iqi pmamitpqä iquauŋi, ‘Goti Hanjuwä Iqu äŋguänä emäkäŋqiyä’ tquäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iqua aquvänä ipu he etmeqaŋgpqe, hiyaqä kukŋuä äŋgui, iquatä witäniqeqä. I etaŋgqä-qe, qu he etmapŋqe aquvänä miqä iqaŋgpqe, hiqä kukŋuä ii iquau yätamäkqä mävqä da yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ämaqä hŋqu he etmetä iqueqä aŋä iuŋqä etma mäwqä itä, hiyaqä kukŋui qätä maeyqä iqaŋgutqe, he aŋä-himqä ique ävämepiyäŋgaŋi, qua hinoqukuä yukä iu täka emäkmitätqe, ptä quväteqämä emä uwqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nyi naqä-qakuä etqänä. Hiunji Goti Hanjuwä Iqu ämaqä kukŋuä mitäniqäŋgaŋi, qokä-apäkä aŋä-himqä iquesaŋi iquauqä kimaŋi haŋä-iqe, Sotomä iutä Gomora iutä äpmamiŋuwä iquauqeuŋi, aaŋä ämäwqätäuniqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nyi endowatqe, tiinjqä. Sipsipqä iqua, hiveqä hiqiyqä iquauqä awä imä äwquwä eŋqä-paŋä iiŋä endowatqänä. Ämaqä hui he qui emäkpŋqä iqäpŋqäuä. Iŋi he qämakä iquauqä suqä iunä qänaknä ipu, kŋuä äŋguä ganä indqämbiyi imäkqäpŋqä. Iŋäqe yŋŋä-heeqe, suqä quvqä mimäkqä itqäŋuwä-pa, he-pqe asä ii iqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","He ämaqä iquauŋi äŋguänä wimasipiyä. Qu quwqä ämiqä iquauä hiŋuä iqiŋi kukŋuä metpnuwiqä. Quwqä aŋä aquväqŋqä iuŋi, täua hitäwipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Qu Nyi mändi äŋgittqiyäpu, ämiqä Romätaŋä iquauŋqätä, aŋä-himqä naqä ämiqä iquauŋqätä, heŋi eyqiyäma upnuwiqä. Iŋgaŋi he ämaqä naqä iiŋä iquautä, ämaqä Israitqä qäyä etaŋgi huizi iquautäŋi, kukŋuä äŋgui awä tupnuwäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Qu heŋi, kukŋuäŋqä eyqiyäma uwqaŋguwäŋgaŋi, ‘Ne kukŋui, äki taŋquatiyä? Ä kimaŋi, äänä tuaŋquatiyä?’ kŋuä mindqäŋqä pa iqäpŋqä. Oeyä. He kukŋuä tpŋqäŋgaŋi, Goti Hanjuwä Iqu he kukŋuä tupŋqe, ämetqueŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ii tiiŋiqä. Kukŋui, hiqä-hiuä matqä ipŋqäuä. Hiniqueqä Dŋä Äŋguä Iqu hiyaqä maŋä iuta awä tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ämaqä hui quwqä käta-käŋgueque, huiziqua ique pizqä päkpŋqä iiŋqe, quwqä hipa iu wipnuwiqä. Itaŋi kaniqukua, quwqä ymeqä iquauŋi-pqe, suqä asitaŋi itquapnuwiqä. Itaŋga ymeqä iqua, kunaqä-kunuŋuau-pqe, mäkä äunäpu asä inä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","He Nyaqä yoqä-täŋuenä etaŋgi, ämaqä eeqänäŋi äwqä quvqä emäkqäpnuwiqä. Iŋäqe qokä-apäkä haŋä-iqä qäpu etqäŋgaŋqä yäŋä äqämbu äpmamitpqä iqua, Goti Hanjuwä Iqu häŋä iqumuatäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ämaqä aŋä-himqä hŋquesaŋi quvqä etqueqaŋgpqe, he ävämepu, aŋä-himqä hŋquenyqä zä uwqäpŋqä. Nyi naqänä etqänä. He Israitqä iquauqä aŋä-himqä eeqänäŋä iuŋi änyä mikiqäŋga, Ämaqeuqä Ymeqä Ekqä Iqu äpäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ämaqä näqŋqä ämetqäŋuwä iqua, näqŋqä ävätŋqä iqueŋi, mämäwqätäuqä ipŋqäuä. Itaŋga ämaqä wäuŋuä imäkätqäŋuwä iqua, iquauqä naqä iqueŋi, mämäwqätäuqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Näqŋqä ämetqäŋuwä iqua, ämotquetŋqä iqutäŋi, asänäŋä eäŋuwi, ii qäyunjqä. Wäuŋuä imäkätqäŋuwä iqua, naqä iqutä asänä eäŋuwi, ii-pqe qäyunjqä. Iŋi ämaqä ämiqä iquenyqe, qu ‘Iqu dŋä quvqä Belsäpulä iqueqä’ ätpqe, iqueqä yäpä iqi itqäŋuwä iquauŋqe, yoqä quvqänäŋä asä inä tpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","He ämaqä iiŋä etqueqaŋgpqä iquauŋqe, zä miqä pambiyä. Nätmatqä eeqänäŋi huäqä äutnmitätqe, ätnäŋä iqi timäuŋqiyä. Nätmatqä eeqänäŋi zä äwämitätqe, ämaqe näqŋqä hipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kukŋuä Nyi ämaqeu mätquä henyä etätŋqe, he ätnäŋäqi tquäpŋqe. Kukŋuä Nyi qeiqinyä etqe, he ämaqeuqä hiŋuä iqi ätqäupu awä tquäpŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ämaqä hiqä huiwä iunä päsqä iquauŋqe, zä miqä pambiyä. Qu quuvqe, pizqä mapäsqä ipŋqäuä. Goti Hanjuwä Iqu, huiwitä, quuvqetä, tä iuŋqä dowatätä, qui Imäkqä-qu etaŋgi, he ze Iquenyqänä iqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","He näqŋqeqä. Yŋŋä wäŋqä isuauŋqe, ämaqe, qu hnjuaquinyqä mbqä wäŋqä hŋqunä itqäŋä. Iŋäqe hiqä Hiniqu, isuau äŋguä ämitäqetaŋi, Iqu hiŋuinä mäquŋquä iqaŋgutqe, isuautaŋä hmbu qua mäŋi mapäkŋqä iŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Goti Hanjuwä Iqueqä hiŋuä iqiŋi, he yŋŋä isuauŋi, ämäwqätäuŋäuä. Hiyaqä dä nyuäŋä iuŋi, Iqu a ae ätäuqeqä. Iiŋä etaŋgi he haŋä-iqä emeqaŋgutqeŋqä, zä miqä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ämaqä hŋqu, ämaqä iuŋi, ‘Nyi Jisasi Iquesaŋunjqä’ tquaŋgutqe, ga Nyi-pqe iqueŋqe, Apiqu Qäukuä Yätu Äpmeŋqä Iqueä hiŋuä iqiŋi, ‘Ämaqä tqu, Ŋqeqä’ tumniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Itaŋga ämaqä hŋqu, ‘Nyi Jisasi Iquesaŋunä manä’ tquaŋgutqe, ga Nyi-pqe iqueŋqe, Apiqu Qäukuä Yätu Äpmeŋqä Iqueä hiŋuä iqiŋi, ‘Ämaqä tqu, Nyitaŋu manä’ tumniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","He Nyinyqe, ‘Iqu mäkä eeqäpnäŋi, mändi kittqiyätŋqä äpqeqä’ kŋuä maeyqä pa inä. Oeyä. Nyi ämaqe, äwqä haŋuä iŋqä pmetpnuwä diŋqe, mäma mapqä, ipäqäyuŋä äma äpqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nyi tiiŋiŋqä äpqe. ‘Hikŋuiqu, kanique mäkäŋqä vqä iiŋqätä, meqi, känäu mäkäŋqä vqä iiŋqätä, hikŋueqä apäki, keeŋqä mäkäŋqä vqä iiŋqätä, äpqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Itaŋga ämaqä hŋqueqä käyämaqä iquautaŋä hŋqua, iqueŋi himä-wiuŋqä wipnuwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ämaqä hŋqu kaniquenyqätä, känäuŋqätä kuapänä äwinyätä, Nyinyqe wäŋqäpu äwinymitätqe, iqu Nyaqä näueqä-qu hmanjqä. Ämaqä hŋqu iqueqä ymeqä qokä iquauŋqätä, apäkä iuauŋqätä kuapänä äwinyätä, Nyinyqe wäŋqäpu äwinymitätqe, iqu Nyaqä näueqä-qu hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Itaŋga ämaqä hŋqu haŋä-iqä Nyaqä yoqeta wimeqaŋgutqe mämeqä itä, Nyinyqä qänaknä miqä imitätqe, iqu Nyaqä näueqä-qu manä. ");
INSERT INTO mcr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ämaqä häŋä-pmeqä äŋgui ämäqumuetä, a yäŋänäqŋqä äqätmitätqä iqu, iqueqä häŋä-pmeqe qui imäknäŋqiyä. Itaŋgi ämaqä Nyinyqä kŋuä indqänätä, iqueqä häŋä-pmeqe huätä ävquatämäumitätqä iqu, häŋä-pmeqä naqä-qakuänäŋi ämeniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ämaqä hŋqu, he etmetä äŋguänä emäkqaŋgutqe, iqu Nyi-pqe inä inyimäkqiyä. Ämaqä Nyi indmetqä iqu, Nyi änändowatkqä Ique-pqe inä itmeqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ämaqä hŋque, Goti Iqueqä kukŋuiŋqä hiŋuä-tqä hŋqu ique wimeqaŋga, iqu iquenyqe, ‘Hiŋuä-tqä-queqä’ kŋuä indqänätä, iqueŋi itmetä äŋguä iwimäkätqä iqu, Goti Hanjuwä Iqu ämaqä iqueŋi, nätmatqä äŋgui, hiŋuä-tqä iquau ävätŋqä-pa väniqeqä. Itaŋga ämaqä hŋque, ämaqä jänäŋä hŋqu ique wimeqaŋga, iqu iquenyqe, ‘Ämaqä jänäŋä-queqä’ kŋuä indqänätä, iqueŋi itmetä äŋguä iwimäkätqä iqu, Goti Hanjuwä Iqu ämaqä iqueŋi, nätmatqä äŋguä, ämaqä jänäŋä iquau ävätŋqä-paŋi väniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Itaŋgaŋi ämaqä hŋqu, Nyaqä ämaqä tquautaŋä yoqä naqä-täŋä maeqä hŋquenyqe, ‘Iqu Jisasi Iquenyqä qänaknä itŋqä-queqä’ kŋuä indqänätä, ique eqä isqä ävätqä iqu, Nyi iquenyqe, ‘Ämaqä tqueqä wäuŋuä äŋguä iutaŋä kimaŋi, ämeniqeqä’ naqä-qakuänäŋä etqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä 12 iquauŋi kukŋuä ii ae ämotqueqe, Iqu iqiŋi äväma, aŋä-himqä huizi, qua Galili iu äwiŋqä iu, ämaqeu ämotquetä, Goti Hanjuwä Iqueqä kukŋui awä ätuäkämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jonä iqu guä kiqiyäueqä aŋiu äpmeqäŋgaŋi, iqu wäuŋuä eeqänäŋi Kraisi Iqu imäkqaŋgqeŋqä qätä äwiyäqe, iqueqä wäuŋuäŋqä ämotquamiŋqä hŋquaqu, Jisasi Ique yatŋqä wiyŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iquaqu Ique äwimayi, yatŋqä tiiŋä äwikiyi. “Qu ‘Kraisi Iqu äpäŋqiyä’ ätätqäŋuwi, Si Qäqukitanä, ä hŋquenyqä hiŋuä inä äqänanä pmetuŋqutanä?” ");
INSERT INTO mcr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisasi Iqu kimaŋi, iquaqui tiiŋä ätukqe. “Qe nätmatqä hiŋuä äqunäsinyä qätä äwiyäŋiyiŋqe, äwäsinyä Jonä ique awä tiiŋä suinyqä. ");
INSERT INTO mcr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Ämaqä hiŋuä pisqä iqua, hiŋuä äŋguä äqäŋgäuä. Yukä quvqä iqua, qaŋä äŋguä äwqäuä. Wänyimäŋqä-täŋä iqua, äŋguä imäŋgäuä. Qätä äyqä iqua, qätä äwiyqäuä. Ae äpäkoŋguwä iqua, aŋgi ävauqäuä. Nätmatqä maeqä iqua, Goti Hanjuwä Iqueqä kukŋuä äŋgui qätä äwiyqäuä.’ ");
INSERT INTO mcr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ämaqe, qu Nyi imäkqaŋgqeŋqä kŋuä indqänäpiyä iqua, quwqä quuvqä heqiyqe qui mimäkŋqä iqaŋgutqe, qu aquvänä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jonä iqueqä ämaqä iquaqu ae uwqaŋgiyäŋga, Jisasi Iqu qokä-apäkä iuŋi, Jonä iquenyqä tii ätukqe. “He aŋä avqŋqä duŋqe, squä hiŋuä qumbŋqä äukuwäwä? Qoä-qamqä yuŋuä miqaŋgqe qumbŋqä äukuwätanä? Oeyä. ");
INSERT INTO mcr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Squä hiŋuä qumbŋqä äukuwäwä? He ämaqä qäkä äŋguänäŋä yäuqä pmetaŋgqä hŋque hiŋuä qumbŋqä äukuwätanä? Oeyä. Ämaqä qäkä äŋguä äyäuŋuwä iqua, ämiqä naqä iqueqä aŋä du pmetpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","He squä hiŋuä qumbŋqä äukuwäwä? Ämaqä hiŋuä-tqä hŋque hiŋuä qumbŋqä äukuwätanä? Ŋŋqä. Iiŋä sätäti, Nyi tiiŋä etqänä. Iqu, Goti Hanjuwä Iqueuä hiŋuä-tqä huizi iquauŋi ämäwqätäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Bukä iuŋi, Goti Hanjuwä Iqueqä tuwaŋui tii ätä äqänänä. ‘Qätä wipiyä. Ämaqä Nyaqä kukŋuä ämapqä hŋque, Si hiŋuiqä kimetŋqä ändowatqänä. Sinyqä hänaqä näwinyä imäuetŋqänänyä,’ ätä äqänänä. Kukŋuä ii, ämaqä tätquenyqä ätqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Itaŋgi Nyi he naqä-qakuä tiiŋä etqänä. Ämaqä eeqänäŋä iutaŋi, Jonä asŋä-qäyqä ique ämäwqätäutŋqe, aaŋqeqä. Iŋäqe Goti Qäukuä Yätutaŋä Iqunä miqä iuŋi, ämaqä yäpakä quvqä äpmeŋqä iqu, Jonä iqueŋi ämäwqätäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jonä asŋä-qäyqä iqu kukŋuä awä ätumiŋqäŋgaŋi, ämaqä yäŋänäqŋqä-täŋä iqua, Goti Qäukuä Yätutaŋä Iqunä miqä iu paqupŋqeŋqe, qu wäuŋuä yäŋänäqŋqä ipŋqä ipäqäkuwi. Täŋgaŋi qu wäuŋuä iiŋi yqänä imäkäpu, Goti Iqueqä miqeuŋi haŋä-iqä kuapänä ävätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jonä iqu ätimäukqäŋgaŋqe, ämaqe, Goti Hanjuwä Iqueqä kukŋuiŋqä näqŋqe, qu bukä hiŋuä-tqä iqua äqäkuwiutatä, Mosisi iqu kukŋuä-suqeŋqä äqäkqeutatä ämamiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Goti Iqueqä bukä iuŋi, ‘Hiŋuä-tqä Laisa iqu äpäŋqiyä’ ätätä äqänäŋqe, ii Jonä iquenyqänä äqänänä. He Nyaqä kukŋuä iiŋqe, quuvqä heqäpŋqäpiyä, maeqiyqä ipŋqäpiyä? ");
INSERT INTO mcr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","He qätä-täŋuenä epiyi, kukŋuä iiŋqe kŋuä äŋguänä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ämaqä täŋga äpmeŋuwä iuŋqe, Nyi änäänyä tmqäwä? Tiiŋuaiqä. Ymeqä ququawä aquväqŋqä iu quamä äpmapu, ymeqä huizi iquauŋqä tääqä tiiŋä ätätqäŋuwä-paŋä-quaiqä. ");
INSERT INTO mcr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ne henyqä hääwä qäyä ätqaŋgu, he himnuŋuä miqä iquwiqä. Ne pmapqä qäyä iqaŋgu, he kŋuä maqiyqä iquwiqä’ ätätqäŋuwiqä. Ämaqä täŋga äpmeŋuwä iqua, qu ymeqä tqua eŋqä-paŋä eäpu, suqä äsque-äsqueŋqä mäwiŋgaŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jonä asŋä-qäyqä iqu äpäqetaŋi, buayä änätä, wainqä-eqä maŋqä iqaŋga, qu ‘Dŋä quvqä-täŋä-queqä’ äyä ätkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iŋäqe Ämaqeuqä Ymeqä Ekqä Iqu äpäqetaŋi, buayätä eqätä gaŋgqäŋga, qu tii ätqäuä. ‘Ämaqä buayä eqä yaqäpiqä itä änätä, wainqä-eqä kuapä ŋqueqä. Itaŋga ämaqä mbqä motauqä iquauqätä, suqä quvqä imäkqä iquauqätä näueqä-queqä’ inä ätqäuä. Iŋäqe, Goti Hanjuwä Iqueqä ämaqä iquauqä wäuŋui, tiiŋä motquapnä. Iqueqä kŋuä indqäŋqe, ii aaŋä naqä-qakuiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","I ätuäqetaŋi, Iqu ämaqä aŋä-himqä hui-huiu äpmeŋuwä iquauŋi, äkasuwä ätukqe. Aŋä-himqä iuŋi, Iqu wäuŋuä ämaqä mimäkqänäŋä di kuapänä qäyä imäkqaŋgi, quwqä kŋui äkunmäknäpu, suqä quvqe mävquatämäuqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iquauŋi Iqu tiiŋä ätukqe. “Ämaqä Kolasinä pmeqä iquendä, Betsaitä pmeqä iquendä, hiqä haŋä-iqeŋqe, Nyi ‘Oänä’ etqänä. Tiiŋä etaŋgiyä. Nätmatqä ämaqä mimäkqänäŋä di, Nyi heyaqä awä iqisa imäkkqä-paŋi, ämaqä hŋqu Tayä pmeqä iquauätä, Saitonä pmeqä iquauätä awä iqisa imäkqä-säpi, qu qäŋganä tiiŋi ae pmeqäpniŋgä. Quwqä kŋui äkunmäknäpu, suqä quvqe ävquatämäupiyitaŋi, huäqä-huŋqä qäki ämäyäupu, tä wätakiu ae pmeqäpniŋgä. ");
INSERT INTO mcr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iiŋiŋqe Nyi he etqänä. Hiunji Goti Hanjuwä Iqu ämaqeuqä suqä iwäsäuniŋqä atäuŋuä ikqeuŋi, heyaqä haŋä-iqe, Tayä pmeqä iquauqätä, Saitonä pmeqä iquauqätäŋi, ämäwqätäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Itaŋga Kapänamä pmeqä iquenyä, Goti Iqu heŋi, qäukuä haqä yätuŋqä etma yäniqätanä? Oeyä, Iqu he ämaqä pizqä iquauqä aŋä buŋqä endowatäniqeqä. Nätmatqä ämaqä mimäkqänäŋä di, Nyi heyaqä awä iqisa imäkkqä eŋqä-paŋi, ämaqä hŋqu Sotomä pmeqä iquauä awä iqisa imäkqä-säpi, aŋä-himqä iqu yqänä witäninjqä. ");
INSERT INTO mcr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iiŋä etaŋgi hiunji Goti Hanjuwä Iqu ämaqeuqä suqä iwäsäuniŋqä atäuŋuä ikqeuŋi, heyaqä haŋä-iqe Sotomä pmeqä iquauqeuŋi ämäwqätäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iŋgaŋi, Iqu tii ätukqe. “Apä, Qäukuitä Quaetä Miqä Iquki, ämaqä näqŋqä kŋuä-täŋä iquauŋqä si nätmatqä tä zä äkittqiyeŋä-qe, ymeqä däŋä-sua eŋqä-pa äyä ämotquenyä. Si e imäkqaŋgnä, Nyi ‘äŋguiqä’ äktqänä. ");
INSERT INTO mcr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Auä, Apä, Si Tqä-täuä yeeqä imäkndŋqä diŋqä, imäkŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tiiŋä-pqä inä ätukqe. “Ŋqä Apiqu nätmatqä eeqänäŋi, Ŋqä hipa täu änjiyqeqä. Ämaqe, Ymeqä Iquenyqä näqŋqe, aaŋqeqä. Apiqunänjqä. Ämaqe, Apiquenyqä näqŋqe, aaŋqeqä. Ymeqä Iqutä, ämaqä Ymeqä Iqu ämotquetŋqä iquatänä, Apiquenyqä näqŋqä eäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ämaqä wäuŋuä tnäŋä ipu, haŋä-iqä ämepu, huiwä haŋuä enyätŋqä iquenä, he eeqänäŋuenä hapä hitapmqä Nyinyqä ppiyä. ");
INSERT INTO mcr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nyi Ŋqä-näuä äkittqänätmä, ämaqeuŋi haŋuä itquetŋqe. Iŋi, bulumäka iqua nätmatqä eyqiyämapŋqä, zä quavqä hiŋuä-qo iu guä ämäsäutqäŋuwä-paŋä iiŋi, he Nyaqä yäpä iqi äpmapu, Nyita näqŋqä meqäpŋqeqä. Itaŋga he haŋä-iqä naqänäŋä mämeqä, hapä pmepŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kukŋuä Nyi etmqe, haŋä-iqä naqä manä, he qeiqinyäŋä mapŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Qänakndaŋi, Sämbatqä hiunji hapä pmeqäŋgaŋi, Jisasi Iqu kuä-witqä wäuŋuä awä iu qaŋä ikämiŋqe. Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua buayä dä vqaŋga, qu kuä-witqä häukui, ätäkäpu änmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisi hŋqua hiŋuä iiŋä äqumbiyi, Jisasi Ique tiiŋä ätukuwi. “Hiŋuä qunyä! Suqä Tqä ämaqä wäuŋuäŋqä ämotquetqäŋä iqua iquwi, hiunji hapä pmeqäŋga imäkqeŋqe, pmua imäknänä.” ");
INSERT INTO mcr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","I tquaŋguwäŋga, Iqu kima tii ätukqe. “Änääŋgä? Hiŋuiqänäŋi neqä awiqu Dewiti iqutä, iqueqä ämaqä iquatä, buayä dä äpäkombiyi, Dewiti iqu imäkkqeŋqe, he kukŋuä iuŋi a matäuqä itqäŋuwätanä? ");
INSERT INTO mcr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewiti iqu Goti Hanjuwä Iqueqä aŋä yäpä yäŋgisa äpaquväqe, bretqä Goti Hanjuwä Iqueqä hiŋuä iqi äwämiŋqe, iqutä iqueqä ämaqä iquatäŋi, ämepu äŋguwiqä. Buayä Goti Hanjuwä Iqueqä hiŋuä iqi äwiŋqe, ämaqe ämepu ŋqäŋqe, pmua imäknänä. Hiqäva-imäkqä iquanä ämepu bŋqä inä äwinä. ");
INSERT INTO mcr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Änääŋäŋqäwä? Bukä Mosisi iqu kukŋuä-suqeŋqä äqäkqä iuŋi, he kukŋuä tä a matäuqä itqäŋuwätanä? Sämbatqä hiunji hapä pmeqäŋgaŋi, hiqäva-imäkqä iqua Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋä iu, Sämbatqäŋqä suqä ätä äwiŋqä iuŋi ävausäpiyä-qe, Goti Hanjuwä Iqueqä hiŋuä iqiŋi, qu suqä quvqä mimäkqä itqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","I etaŋgi Nyi he etqänä. Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋä ique Ämäwqätäuŋqä Hŋqu, täqi äwinä. ");
INSERT INTO mcr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iŋäqe, Goti Hanjuwä Iqueqä bukä iuŋi, kukŋuä hŋqu tiiŋä äqänänä. ‘He hiqäva imäkätqäŋuwiŋqe, manyiŋqä iqiyä. He ämaqä iquauŋqä qeqä emäŋgaŋguti äŋguä itquapŋqä änyiŋgiyä.’ He kukŋuä iiŋä iqueqä quatiŋqä näqŋqä meqä-säpi, he ämaqä suqä quvqä mimäkqä itqäŋuwä iquauŋi, haŋä-iqä mävqä iqäpniŋgä. ");
INSERT INTO mcr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iiŋä etaŋgi he iqueqä quatiŋqä maqŋqä epu, Nyaqä ämaqä iquauŋi haŋä-iqä hiŋgi ävätqäŋä. Nyi iiŋä etqe, tiiŋiqä. Ämaqeuqä Ymeqä Ekqä Iqu Sämbatqä hiunji hapä pmeqä iuŋi ämitqänä. Nyi tä qäqunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisasi Iqu iqiŋi äväma äwätä, iquauqä aŋä aquväqŋqä yäpä iŋgisa qe äpaqukqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iqiŋi, ämaqä hipa hŋgiŋi quvqä-täŋä hŋqu äpmamiŋqe. Iŋgaŋi Parisi iqua Jisasi Ique kukŋuä mitpnuwä diŋqä yatŋqä tiiŋä äwikuwi. “Sämbatqä hiunji hapä pmeqäŋgaŋi, ne ämaqä yaqä iquauŋi äŋguä imäkqe, ii äŋguätanä, ä änääŋgä?” ");
INSERT INTO mcr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iqu kimaŋi, tiiŋä ätukqe. “Ämaqä hiyaqä awä iqisaŋä hŋqu, sipsipqä-täŋä-qu eä, itaŋga Sämbatqä hiunji hapä pmeqäŋgaŋi sipsipqä iqu qua hovqä iu äpäwitqe, iqu äänä imäkäniqiyä? He näqŋqeqä. Ämaqä iqu sipsipqe a ämaqätätä, äkäka yäpaqä täŋgisa ätuma yapäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iŋi ämaqä di sipsipqä duŋi ämäwqätäutaŋgqeŋqe, Sämbatqä hiunji hapä pmeqäŋga suqä äŋguä imäkqe, ii äŋguänäŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","I ätuäqetaŋi, Iqu ämaqä hipa quvqä-täŋä iqueŋi, “Tqä hipa jänä imäkinyä” ätukqe. I tquaŋga ämaqä iqu hipa jänä i imäkŋgaŋga, hipae, äŋguäŋgisa änyäŋqä-pa, e iŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iŋgaŋi Parisi iqua aŋä iu äväma, hŋqäqi aquvä äqänäpu, Jisasi Ique pizqä päkpnuwä iiŋqä hänaqeŋqä qävqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisasi Iqu qu iiŋä iqaŋguwiŋqä näqŋqä eäqe, aŋä-himqä iuŋi qe äväma äukqe. Itaŋi qokä-apäkä kuapänäŋi Ique qänaki qe äwivändkuwi. Itaŋgaŋi iquautaŋä täŋä-yaqä-täŋä iquauŋi, Iqu eeqänäŋä äŋguänä qe iwimäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ii iwimäkätäqäŋgaŋi, Iqu iqua Iquenyqä kukŋuä awä matqä ipŋqänä pmua imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Suqä e imäkmiŋqe, Iqu kukŋuä Goti Hanjuwä Iqu hiŋuä-tqä Asayä iqueqä maŋä iuta ätkqä iunä naqä-qakuä timäutŋqä imäkkqe. Kukŋui, tiiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ämaqä tqu, Nyaqä wäuŋuä imäkqä iqueqä. Nyi ique atäuŋuä ikqeqä. Nyi iquenyqe, kiiŋä änyinätŋqeqä. Itaŋga Nyaqä äwqe, iquenyqä aquvänä kuapänä itqänä. Nyi Ŋqä Dŋä Äŋgui, ique wimqänä. Itaŋi ämaqä qua täutaŋä eeqänäŋä iuŋi, iqu suqä jänäŋiŋqä kukŋui awä tquätŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iqu kukŋuä äkasuwä ätätä maŋä tnäŋä matqä yätŋqänänyä. Iŋi hänaqä iutaŋi qokä-apäki, iqu maŋä yäŋänäqŋqä tqaŋguti qätä mäwiyqä ipŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tuuwä-hiyawä äukinymätä iqaŋgutqä iqua, iqu mäquasqä yäŋqiyä. Hiqi-tä hikui-hikui iqaŋgutqe, iqu maiqupisqä yäŋqiyä. Hea suqä jänäŋi, suqä quvqä iu ämäwqätäuniŋqäŋgaŋqe, iqu wäuŋuä yqänä iqämaŋguäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Itaŋi ämaqä qua täutaŋä eeqänäŋä iqua, iquenyqä quuvqä eqiyäpu, iqu yätamäkqä vätŋqä hiŋuä äqämbu pmepnuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hea iŋgaŋi qu ämaqä dŋä quvqä-täŋä hŋque, Jisasi Iquenyqä qe ätma äukuwi. Ämaqä iqu hiŋuä pisqä eä, maŋä matqä-que. Iŋgaŋi Jisasi Iqu iqueŋi äŋguä imäkqaŋga, hiŋuä äqänätä kukŋuä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","E äqumbiyi, qokä-apäkä iqua yäuŋuä ipu, “Täukueqä. Ämaqä Dewiti iquesaŋä ne hiŋuä äqunanä äpmeŋquä iqu, qäqutiyä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisitaŋä hŋqua kukŋuä tä qätä äwipiyi, tiiŋä ätkuwi. “Ämaqä Tqu, dŋä quvqä iquau huätä ändowatätŋqe, Iqu Belsäpulä, dŋä quvqä iquau miqä iqueqä yäŋänäqŋqä iutanänjqä.” ");
INSERT INTO mcr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisasi Iqu iquauqä kŋuä indqäŋqä iuŋi näqŋqä eä, tii ätukqe. “Ämaqä, qua naqä hŋquesaŋä iqua, iwäsänäpu mäkä huŋgaŋgpqe, ämaqä iqua qui imäkmbŋqäuä. Itaŋga ämaqä aŋä-himqä hŋquesaŋä-qe, hueqä-himqä huitaŋä-qe, qu awä äkutnäpu mäkä huŋgaŋgpqe, yäŋänäqŋqe änä matqäuqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iŋi tiiŋä-pqe inänji. Setänä iqu, iqueqä dŋä hŋque huätä ändowatätqe, ne näqŋqeqä, iqueqä ämaqä iqua awä äpatŋgäuä. Iŋi iqu qua täu ämitŋqe, äpakänä mämiqä yäniqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","He Nyinyqe, ‘Iqu Belsäpulä iqueqä yäŋänäqŋqeta dŋä quvqä iquau huätä ändowatätŋqeqä’ qäyunä tqaŋgpqe, hiqä ämaqä iqua dŋä quvqä huätä ändowatätqäŋuwi, yäŋänäqŋqä tqueqeta imäkätqäŋuwäwä? Hiqä ämaqä iiŋä imäkätqäŋuwä iqua, heyaqä kukŋuä iiŋi, ii qäyunä hma hitaŋgqeŋqä ämetquapŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","I etaŋgqä-qe, Nyi, Goti Iqueqä Dŋä Äŋguä Iqueqä yäŋänäqŋqä iquesa, dŋä quvqä iquau huätä dowatqaŋgundqe, iiŋqe he näqŋqä tiiŋä mapŋqeqä. ‘Goti Hanjuwä Iqunä miqe, ae emeqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Quwä-meqä hŋqu, ämaqä yäŋänäqŋqä hŋqueqä aŋä iu äpaquvätä, iqueqä nätmatqe metŋqä wiŋgaŋgutqe, iqu äänä imäkäniqiyä? Iqu ämaqä yäŋänäqŋqä iqueŋi, guä ganä äkiqiyäueqe, iqueqä nätmatqe hiŋgi iŋga meŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ämaqä hŋqu wäuŋuä yätamäkqä manyqä imitätqe, iqu Nyaqä himä-wiuŋqä-queqä. Ämaqä hŋqu, qokä-apäkä aquvä-qäyqeŋqä yätamäkqä manyqä imitätqe, iqu ämaqe im-imä ändowatqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iiŋiŋqe, Nyi he tiiŋä etqänä. Suqä quvqä eeqänäŋitä, kukŋuä quvqetä, qokä-apäkä iqua imäkmipqe, Goti Hanjuwä Iqu huätä mamäuŋqiyä. Iŋäqe, ämaqä hŋqu Dŋä Äŋguä Iquenyqä kukŋuä quvqä ätmitätqe, Goti Hanjuwä Iqu iqueqä suqä quvqe, huätäŋi änä mämamäuqä da iniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ämaqä hŋqu, Ämaqeuqä Ymeqä Ekqä Iquenyqä kukŋuä quvqä tqaŋgutqe, Goti Hanjuwä Iqu iqueqä suqä quvqä di, huätä mamäuŋqiyä. I etaŋgi ämaqä hŋqu, Dŋä Äŋguä Iquenyqä kukŋuä ququvqä di tqaŋgutqe, Goti Iqu, iqueqä suqä quvqä huätäŋi, täŋga mämamäuqä yäŋqiyä. Ga qänakndaŋä-pqe, mämamäuqä yäniqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ämaqe zä hŋquenyqä, ‘Zä tqu quvqätiyä, äŋguänäŋätiyä’ kŋuä indqänäpiyäŋgaŋi, kiqä häukui, hiŋuä ganä äqumbiyi, iŋgaŋi qu näqŋqä mapŋqäuä. Zä hŋqu äŋguänäŋä eäŋqe, kiqä häukuä-pqe, äŋguänäŋiqä. Iŋäqe zä hŋqu quvqä eäŋqe, kiqä häukuä-pqe, quvqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iŋi heŋi, qämakä quvqä iqua eämakuwänäŋä eqänäŋänä. He ämaqä quvqä eäŋuwi, kukŋuä äŋgui äänä tpŋqäwä? Ämaqä iquauqä kukŋuä tqe, ii iquauqä kŋuä indqäŋqä dutanjqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ämaqä äŋguänäŋä iqua, kŋuä äŋguänäŋä indqänäpu, suqä äŋguänäŋä dinä imäkpŋqäuä. Ämaqä quvqä iqua, kŋuä quvqä huitaŋä-huitaŋä indqänäpu, suqä quvqä imäkpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Itaŋgi Nyi he etqänä. Hiunji Goti Hanjuwä Iqu ämaqeu kukŋuä mitäniqäŋgaŋi, Iqu quwqä kukŋuä hiŋgi ätmitpqeŋqä kŋuä indqänätä, iuta iwäsäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Si kukŋuä äŋguä tquki etaŋgutqe, Goti Hanjuwä Iqu, ‘Si ämaqä jänänäŋukiyqä’ ktäniqeqä, ŋŋ si kukŋuä quvqä tquki etaŋgutqe, Goti Hanjuwä Iqu, ‘Si ämaqä quvqukiyqä’ ktäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iqu e tquaŋga, ämaqä kukŋuä-suqeŋqä näqŋqä hŋquatä, Parisi hŋquatä, Iqueŋi tiiŋä ätukuwi. “Ämotqueqä Iqukiyä, ne tiiŋiŋqä äneŋgiyä. Si Goti Hanjuwä Iqueqä Wäuŋuä Imäkquki eäŋi, ne ‘naqä-qakuä-queqä’ kŋuä neyätŋqe, mänätquayä.” ");
INSERT INTO mcr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iqu iquauqä kukŋui, kimaŋi tiiŋä ätukqe. “Qokä-apäkä täŋga äpmeŋuwä iquenä, he apäkä qokiqu äväma qaŋä hiŋgi qŋqä eŋqä-paŋä, quvqä eäpu, Goti Hanjuwä Iqueŋqe qänaknä miqä-quenjqä. He ‘Ne Sinyqä näqŋqä metuŋquä diŋqä, mänätquayä’ ändquwä-qe, Nyi iiŋi mimäkqä imqänä. He näqŋqä mapŋqe, hiŋuä-tqä Jona iqu qeyqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona iqu hiunji hŋquaqui-hŋque, heatqä hŋquaqui-hŋque, hämapäkä naqänäŋä iqueqä äwqä yäpä iŋgisa äpmakqä-pa, Ämaqeuqä Ymeqä Ekqä Iqu asä inänjqä. Hiunji hŋquaqui-hŋque, heatqä hŋquaqui-hŋque, qua yäpä iŋgisa pmeŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hiŋuiqänäŋi, ämaqä Ninipe äpmamiŋuwä iqua, Jona iqueqä kukŋui qätä äwipiyi, iquauqä kŋui äkunmäknäpu quwqä suqä quvqe huätä ävquatämäukuwiqä. Iŋäqe täŋgaŋi, ämaqä Jona ique Ämäwqätäuŋqä Iqu, täqi qäyä pmetaŋgi, ämaqe iquauqä kŋui äkunmäknäpu quwqä suqä quvqe mävquatämäuqä iquwiqä. Iiŋiŋqe, hiunji Goti Hanjuwä Iqu qokä-apäkä iwäsäutqäŋgaŋi, ämaqä Ninipe äpmamiŋuwä iqua ävaupu, ämaqä täŋga äpmeŋuwä iquauqä suqä quvqeŋqä awä tpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hiŋuiqänäŋi apäkä, qua hituŋuä nämä äwiŋqä iu miqä naqä ii, Solomonä iqueqä kukŋuä näqŋqe qätä wiyätŋqä äpkqeqä. Iŋäqe täŋgaŋi Ämaqä Solomonä ique Ämäwqätäuŋqä Iqu täqi qäyä pmetaŋgi, ämaqe Ique qätä mäwiqä itqäŋuwiqä. Iiŋiŋqe hiunji Goti Hanjuwä Iqu qokä-apäkä iwäsäutqäŋgaŋi, apäkä naqä ii, ävautä ämaqä täŋga äpmeŋuwä iquauqä suqä quvqeŋqä awä täniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Dŋä quvqä hŋqu ämaqä hŋque ävämaŋi, aŋä yeŋuä duŋqä äwäqe, iqu aŋä hapä pmeqä diŋqä qävqä ikiquäŋqiyä. Itaŋga hŋque mämäqumueqä iäqe, ‘Nyi aŋä hiŋuiqänä ävämakqä duŋqä aŋgu umqänä,’ täŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","I ätäqe, iqu äwäqe, ämaqä hŋqua aŋä iqueŋi siiyä äpipu äŋguä imäkepiyä-qe, mäpmetaŋgä qunäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iiŋä äqunäqe, iqu äwätä dŋä quvqä 7 hŋqua itmeŋqiyä. Dŋä iquauqä quvqe, dŋä kiŋganäŋä iqueqä quvqeu ämäwqätäuŋqiyä. Iquau itmetä, qu aŋä yäpä yäŋgisa äpaquväpu pmapŋqäuä. Ämaqä iqu hiŋuiqänäŋi iiŋänäŋä quvqä äpmamiŋqä-qe, täŋgaŋi aaŋä quvqä kuapänä pmeŋqiyä. Suqä quvqä asä iutaŋi, ämaqä quvqä täŋga äpmeŋuwä iquauŋi äwimeŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisasi Iqu qokä-apäkä iquau kukŋuä iiŋä yqänä tuätqätaŋga, Iqueqä känatä käŋgukuatä äpäpu, Iqutä kukŋuä anä tpŋqä yäpaqä mäŋgisa ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Itaŋi ämaqä hŋqu Iqueŋi, “Hueqä” ätukqe, “Tqä tnatä tuŋgukuatä, Sitä kukŋuä anä tpŋqä yäpaqä täŋgisa ätqäuŋäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ii ätukqä iqueŋi, Jisasi Iqu kima tii ätukqe. “Ŋqä nipatä guäkatäŋi, tqukuakä?” ");
INSERT INTO mcr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Itaŋi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau atäuŋuä ävätä, “Qätä nyipiyä” ätukqe. “Ŋqä nipatä guäkatäŋi, täsquakänä. ");
INSERT INTO mcr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ii tiinjqä. Qokä-apäkä, Nyaqä Apiqu Qäukuä Yätu Äpmeŋqä Iqueqä äwiŋqä iu qänaknä imitpqä iqua, qu Nyaqä tasi-guäka, nanyi-napqa, itaŋga nipaqätänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hiunji asä qäqueŋi, Jisasi Iqu aŋä iu ävämaŋi, yäpaqä mäŋgisa äwätä, eqä-huäŋä Galili iqueqä maŋä iqi quamä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","I pmetaŋga, ämaqä kuapänäŋi Iquenyqä pqaŋguwitaŋi, Iqu yimba hŋque ätkamäuqe, quamä qe äpmakqe. Itaŋi ämaqä eeqänäŋi, eqä-huäŋä maŋä iqi pämä tqäutaŋgä, Iqu yimba iu äpme näqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iqu iquauŋi kukŋuä ktqä ätuätä, näqŋqä kuapänäŋi äwikqe. Kukŋuä ktqä hŋqu tiiŋä ätukqe. “Ämaqä hŋqu kuä-witqä uwqä tnämäwäwätŋqä wäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iqu ätnämäwäwqaŋga, hui hänaqä iqi päknätqe, yŋŋä äpäpu ämambnä. ");
INSERT INTO mcr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Itaŋga hui qua kuapänä hma etaŋgi, hikä-täŋä qäsä äwitaŋgqä iu päknätqe, qua äŋgui äwa itaŋguti, kuä uwqä ii bakä maqänä hukauŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iŋi mäptqä haqä tiqä ae äyapätä tnäŋä tqaŋga, kuä kiqä tapiŋi wäŋqäpu etaŋgi, yäuä hämänä piŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Itaŋga kuä uwqä hui guä yäŋä-täŋä awä imä päknätqe, guä quvqä iqua qäsä naqä-huinyä epiyi, kuä-witqeuŋi, qua aowi äŋguä mävqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Itaŋga kuä uwqä hui qua äŋguänäŋä iu päknätqe, kiqä nääŋqe 100 huknänä, hui 60 huknänä, itaŋga hui 30 huknäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ämaqä qätä-täŋuenä etaŋgutqe, kukŋuä iiŋqe kŋuä äŋguänä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Qänakndaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äpäpu, Jisasi Iqueŋi yatŋqä äväpu, “Si qokä-apäkä iquauŋi, kukŋuä ktqä inä suŋqä tuätqäŋinyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iqu kimaŋi tiiŋä ätukqe. “Goti Qäukuä Yätutaŋä Iqunä miqeŋqä kukŋuä qakui zä witaŋgqä-qe, he näqŋqä mapŋqe, Iqu henyä etapqiyä. Iŋäqe ämaqä huizi iquauŋi, mävqä itŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ii tiiŋä etaŋgi. Ämaqä näqŋqä hui ae ämequwä iqua, Goti Hanjuwä Iqu hui inä ävätä, qu näqŋqä kuapänäŋä-täŋä-qua hipŋqä iwimäkänä. Iiŋä etaŋgqä-qe, ämaqä näqŋqä maeqä iqua, näqŋqä wäŋqä qu ämeŋuwi, Goti Hanjuwä Iqu huätä mamäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iŋitaŋi, Nyi ämaqä iquauŋi kukŋuä ktqenä ätuätŋqeqä. Qu hiŋuä äqunäpu qätä äwiyäpiyä-qe, näqŋqä maeqä-quayqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Qu iiŋä epu, kukŋuä hiŋuä-tqä Asayä iqu äqäkqä tqueŋi, ii naqä-qakuänäŋä ämotquetqäŋä. Iqu pmetaŋga äpmamiŋuwä iquauŋqe, tiiŋä ätätä äqäkqeqä. ‘He kukŋuä qätä äwika äwäpiyä-qe, kiqä quatiŋqe änyä maqŋqä hipnuwiqä. He hiŋuä äquŋgua äwäpiyä-qe, nätmatqä hŋquenyqe näqŋqä maeqä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ämaqä iiŋä iqua näqŋqä äŋguä mämeqäŋqe, quwqä nyuäŋi woyqä ae imaqundäŋgqeqä. Kukŋuä qätä äŋguä mäwiyqäŋqe, quwqä qäte, ae imaqundäŋgqeqä. Nätmatqä hiŋuä äŋguä mäquŋquä ipŋqe, quwqä hiŋuä-pqe, ae yämaqundi iŋgqeqä. Qu iiŋä mimäkqä-säpi, quwqä kŋui äkunmäknäpu, Nyinyŋqä aŋgumä quvepqaŋgpi, ga Nyi iquauŋi äŋguä iwimäkqäminjqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iŋäqe he Nyi nätmatqä imäkqaŋgqe hiŋuä äqunäpu, Nyaqä kukŋui qätä änyiyätqäŋuwitaŋi, Goti Hanjuwä Iqu äŋguä ae emäkqä iiŋqe, näqŋqä eŋä. ");
INSERT INTO mcr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nyi naqä-qakui tiiŋä etqänä. Nätmätqä he hiŋuä äqunätqäŋuwi, hiŋuä-tqä iquatä, ämaqä jänäŋä iquatä, qu kuapänäŋi hiŋuä quŋqäŋqä naqänäŋä winyätqätaŋgqä-qe, qu hiŋuä mäquŋquä imiŋuwiqä. Kukŋuä he qätä äwiyätqäŋuwi, qu qätä wiyqäŋqä naqänäŋä winyätqätaŋgqä-qe, qu qätä mäwiyqä imiŋuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisasi Iqu kukŋuä äpakänä yqänäŋi, tiiŋä ätukqe. “Goti Iqu he näqŋqä mapŋqä etapqetaŋi, täŋgaŋi kukŋuä ktqä ämaqä kuä-witqä wäuŋuä iu tnämäuqä-queŋqe, kiqä qakuiŋqä Nyi awä tqaŋgundi, he qätä nyipiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ämaqe, qu Goti Qäukuä Yätutaŋä Iqunä miqeuŋqä kukŋui qätä äwiyäpu, kiqä qakuiŋqä näqŋqä mämeqä itqäŋuwä iqua, qu kuä uwqä hänaqä iqi äpäkŋgqä-paŋä-quaiqä. Setänä iqu äwimetä, kukŋuä Goti Hanjuwä Iqu quwqä kŋuä indqäŋqeu hiqaŋgqe, huätä maqänä ämotautŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Itaŋga kuä uwqä qua hikä-täŋä iu äpäkŋgqä ii, tiinjqä. Ämaqä kukŋuä iiŋä ique qätä äwiyäpu, maqänä ämepu, aquvänä iquwä iquaiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iŋäqe iquauqä quuvqä heqiyqe, kuä tapiŋä wäŋqäpu uwqatätä, yäuä äpiqä i eŋqä-paŋiqä. Ämaqä Goti Hanjuwä Iqueuä kukŋui mändi kittqiyanä-tpu itqäŋuwä iqua, ämaqä tquauŋi haŋä-iqä äväpu quvqä itqueqaŋguwäŋga, iquauqä quuvqä heqiyqe, qui maqänä imäknänä. ");
INSERT INTO mcr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Itaŋga kuä uwqä guä yäŋä-täŋä awä imä äpäkŋgqä ii, tiiŋiqä. Ämaqä kukŋuä iiŋä ique qätä äwiyäpiyä-qe, qu nätmatqä qua täutaŋiŋqä äwäwa ipu, mbqä aquvä kuapänä qäpŋqeŋqä kŋuä kuapänä indqänätqäŋuwä iquaiqä. Goti Hanjuwä Iqueqä kukŋuiuŋi, suqä iiŋä iqu qŋqaŋä yeqaŋgi, qu suqä jänäŋä imäkpŋqe, yäŋänäqŋqä mävqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Itaŋga kuä uwqä qua äŋguä iu äpäkŋgqe, ii ämaqä kukŋuä iiŋä ique qätä äŋguä äwiyäpu, kiqä quatiŋqä näqŋqä ämetqäŋuwä iquaiqä. Iŋi, kukŋuä iqueqä nääŋqe, hui 100 huknänä, ga hui 60 huknänä, itaŋga hui 30 huknäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iqu ämaqeuŋi, kukŋuä ktqä huizi tiiŋä ätukqe. “Goti Qäukuä Yätutaŋä Iqunä miqe, ii ämaqä hŋqu iqueqä wäuŋuä iu kuä uwqä äŋguinä ätnämäwäwqä-paŋä iiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iŋäqe ämaqä iqi äpmamitpqä iqua hiqaqä witaŋguwäŋga, ämaqä iqueqä himä-wiuŋqä iqu ätimäutä, qätaqä quvqe, asä iu ätnämäwaŋi äwäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Qänakndaŋi kuä-witqä uwqä bakä ae äukaupu äpepiyi, nääŋqe äukŋgaŋgaŋi, wäuŋuä-wiyqä iqua, qätaqä quvqä hui anä tqäutaŋgä qumbnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iŋgaŋi iqua äwäpu, ämaqä wäuŋuä kaniqueŋi tiiŋä tupnuwiqä. ‘Ämaqä naqä iquki, ne si tqä wäuŋuä iuŋi, kuä uwqä äŋguinä ätnämäuqiyä-tanä ikque. Qätaqä quvqä hui anä ätqäuŋuwi, änääŋäŋqäwä?’ ");
INSERT INTO mcr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iqu iquau kimaŋi, ‘Suqä iqu, ämaqä himä-wiuŋqä hŋqu imäkkqeqä’ tuäniqeqä. Itaŋi iqua yatŋqä wipnuwiqä. ‘Ne äwätanä, qätaqä quvqe ekautanä, aquvä maqiyatuŋqueŋqä äkiŋgiyä?’ tupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Iŋgaŋi iqu iquauŋi kimaŋi tuäniqeqä. ‘Oeyä. He qätaqä quvqe ekaupiyäŋgaŋi, kuä-witqä itä qäsä hikauqŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kuä täkqäŋgaŋqä, qäquaqu qäyä ätqäunyqä. Kuä täkqäŋgaŋi, nyi ämaqä kuä täkpŋqä iquau tii tumniqeqä. “He qätaqä quvqe ganä ekaupu, aquvä äqiyäpu, tä väuepnuwäŋqä hatŋä äquqotäupu epiyä. Iŋgaŋi he kuä-witqe ätäupu, aquvä äqiyäpu nyaqä buayä pŋqä wiqä aŋä iu pŋqä hipiyä” tumniqeqä,’ tuäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iqu kukŋuä ktqä huizi tiiŋä ätukqe. “Goti Qäukuä Yätutaŋä Iqunä miqe, ii zä-guawä piikä, ämaqä hŋqu iqueqä wäuŋuä iu vowä ämäutŋqä eŋqä-paŋä iiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Zä iqueqä piiki, wäŋqänäŋä-sua etaŋgi, piikä huiziqua, ique ämäwqätäuŋäuä. Iŋäqe, kiqä baki äukautä naqä äpeyätäqäŋgaŋi, nätmatqä huizi wäuŋuä iu ätqäuŋqä iquauŋi ämäwqätäutaŋguti, yŋŋä iqua äpäpu, kiqä äpa iuŋi yuuwä imäkpŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Itaŋga Iqu kukŋuä ktqä hŋqu-mända inä ätukqe. “Goti Qäukuä Yätutaŋä Iqunä miqe, ii nätmatqä änyuämäuqä eŋqä-paŋiqä. Apäkä hui nätmatqä änyuämäuqe, hmbunä ämetä, kuä-witqä kuapänä ämetä naqä-huinyä imäkänä, buayä pälawä eeqänäŋi änyuämäutŋqä diŋqeuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kukŋuä eeqänäŋä Jisasi Iqu qokä-apäkä iu e ätumiŋqe, Iqu kukŋui ätnäŋä iqi matqä, ktqä dinä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kukŋuä, Goti Iqu hiŋuä-tqä hŋqueqä maŋä iuta ätimekqä hŋqu qäyunä timäutŋqe, Iqu iiŋä imäkmiŋqe. Ämaqä hiŋuä-tqä iqu tiiŋä ätkqe. Nyi kukŋuä ktqe etätmä, nätmatqä qua täu imäkkqäŋgatqä zä äwäka äpääŋqeŋqe, täŋga awä etmqänä. ");
INSERT INTO mcr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisasi Iqu ämaqä iu ävämaŋi, aŋä yäpä iŋgisa qe äpaqukqe. Itaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua Iquenyqä äpäpu ätukuwi. “Kukŋuä ktqä qätaqä quvqä wäuŋuä iuta äukautŋqeŋqe, Si ne kiqä quatiŋqä awä natiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iqu kimaŋi tii ätukqe. “Ämaqä kuä uwqä äŋguänäŋi tnämäwäwqä iqu, Ämaqeuqä Ymeqä Ekqä Iqueqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wäuŋui, ii qua tqueqä. Kuä uwqä äŋguänäŋi, qokä-apäkä Goti Qäukuä Yätutaŋä Iqunä miqä iutaŋä iquaiqä. Qätaqä quvqe, Setänä iqueqä ämaqä iquayqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Himä-wiuŋqä, qätaqä quvqä tnämäwäwqä iqu, Setänä iqueqä. Kuä täkqäŋgaŋi, qua täuŋi iqueqä yäpakäŋganjqä. Itaŋga kuä täkqä iqua, eŋätqä iquaiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Qu qätaqä quvqä aquvä ämaqiyäpu, tä väuepŋqä imäkätqäŋuwä-pa, qua täuŋi iqueqä yäpakäŋgaŋä-pqe asä iiŋä imäkpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ämaqeuqä Ymeqä Ekqä Iqu, Iqueqä eŋätqä iquau dowatqaŋga, Iqueqänä miqä iutaŋi, nätmatqä ämaqeuqä quuvqä heqiyqä qui iwimäkqä iutä, ämaqä suqä quvqä imäkqä iquautäŋi, eeqänäŋi huätä mamäupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Itaŋi qu tä naqänäŋä iu tnämäupnuwiqä. Tä iu tnämäuqaŋguwäŋga, qu kŋuä naqänäŋä äqiyäpu, hiquaŋä maŋgtäsqukuä mäuqäpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iŋgaŋi ämaqä jänäŋä iqua, iquauqä Kaniqunä ämitŋqä yäpä iŋgisa äpmepu, quwqä huiwitaŋi mäptqä eŋqä-pa we hunäniqeqä. He qätä-täŋuenä epiyi, kukŋuä iiŋqe kŋuä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Goti Qäukuä Yätutaŋä Iqunä miqe, mbqä pŋqä wiqä ipŋä imäkäpu, wäuŋuä iu qua zä äptekuwä eŋqä-paŋiqä. Ämaqä hŋqu mbqä ipŋä ique ämäqumuetä hiŋuä äqunäqetaŋi, iqu ‘Nätmatqä iiŋi mbqeuŋi ämäwqatäunä’ kŋuä indqänätä, hiŋuä qunämapenä yeeŋqiyä. Iŋgaŋi iqu aquvänä itä, iqueqä nätmatqä eeqänäŋi aquvä ämaqiyätä, ämaqä hŋquququa mbqä ipŋqä imäkäŋqiyä. Mbqä iiŋi ae ämeqe, iqu äwätä wäuŋuä iqueŋi mbqä iŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Aŋgumŋi, Goti Qäukuä Yätutaŋä Iqunä miqe, ämaqä hŋqu mbqä wäuŋuä imäkätä, wimŋä äŋguänäŋiŋqä qävqä ikitŋqä-paŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iqu äŋguänäŋä hŋque ämäqumueqe, iqu äwätä, iqueqä nätmatqä eeqänäŋi aquvä ämaqiyätä, ämaqä huiziqua mbqä ipŋqä imäkäŋqiyä. Mbqä iiŋi ae ämeqe, iqu wimŋi mbqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aŋgumŋi, Goti Qäukuä Yätutaŋä Iqunä miqe, ii tiiŋiqä. Hämapäkä qa, qu eqä-huäŋä bu ätnämäupu, hämapäkä huitaŋä-huitaŋä äqupuiquwä eŋqä-paŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hämapäkä qa mŋqä iuŋi maŋguä mŋgaŋga, qu hikä weä aaŋqä täŋgisa eyqiyäma äyapäpu, quamä äpmapu, itaŋga hämapäkä äŋguänäŋä iquauŋi häkiu ämimepu, hämapäkä quvqä iquauŋi bi tnämäupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Itaŋga qua tqueqä hiunji yäpakäŋgaŋi, asä iiŋäŋqeqä. Ynaunjqä iqua äpäpu, ämaqä quvqä iqua, jänäŋä iquauqä awä iqi pmetaŋguwä iquauŋi itmapnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Itaŋi qu tä naqänäŋä iu tnämäupnuwiqä. Tä iu tnämäuqaŋguwäŋga, kŋuä naqänäŋä äqiyäpu, hiquaŋä maŋgtäsqukuä mäuqäpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Itaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, yatŋqä tiiŋä qe äwikqe. “Kukŋuä tquauqä quatiŋqe, he näqŋqä ae ämequwätanä?” Qu “Auqä, ne näqŋqä ae ämeququeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","I ätuäqetaŋi, tiiŋä-pqe inä ätukqe. “Iiŋä etaŋgi ämaqä Goti Iqueqä kukŋuä-suqeŋqä näqŋqä iquataŋä hŋqua, qu Goti Qäukuä Yätutaŋä Iqunä miqeŋqä näqŋqä ämepu qänaknä imipqä iqua, qu aŋä naqä hŋqueqä kaniqu eŋqä-paŋä hipnuwiqä. Iqu iqueqä nätmatqä äŋguänäŋä pŋqä wiqä iu äpaquväqe, nätmatqä änyä-häŋitä yäuetä qäsä äma päŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisasi Iqu kukŋuä ktqä tä awä ae ätuäqe, aŋä-himqä iuŋi qe ävämakqe. ");
INSERT INTO mcr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Äväma äwäqe, Iqu kaniqueqä aŋä-himqä iu ätimäuqe, iquauä aŋä aquväqŋqä iu äpaquväqe, ämaqä iuŋi Goti Hanjuwä Iqueqä kukŋuiŋqä näqŋqä äwikqe. Qu Iqueqä kukŋui qätä äwipiyitaŋi, yäuŋuä ipu, “Ämaqä Tqu näqŋqä tä äŋgisa ämeqäwä? Itaŋga änääŋäŋqäwä, Iqu ämaqä mimäkqänäŋi imäkätŋqeuä?” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Ne Ämaqä Tquenyqe, näqŋqeqä. Iqu ämaqä aŋä imäkqä iqueqä Ymeqä Iqueqä. Itaŋga Mäliya ii, Iqueqä känaiyqä. Iŋi Jemisi ique, Josepä ique, Saimonä ique, Jutasi ique, iqua Iqueqä käŋgukuayqä. ");
INSERT INTO mcr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Täqiŋi Iqueqä känapqa, nesä anä äyä äpmeŋunä. Iŋi Iqu ii imäkätŋqe, näqŋqe äŋgisa ämeqäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Qu iiŋä ätnäpu, Iquenyqe äwqä quvqä ätimäukŋguwi. Iŋgaŋi Iqu iquauŋi tii ätukqe. “Hiŋuä-tqä iqua, aŋä-himqä eeqänäŋä iuŋi, yoqä-täŋuae. Etaŋgqä-qe, hŋqunä-hŋqunäŋi, iqueqä aŋä-himqä iutä, iqueqä aŋiu anä äpmeŋuwä iutäŋi, iqu yoqä maiqä-queqä.” ");
INSERT INTO mcr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iŋi Jisasi Iqu-pqe, Iqueqä aŋä-himqä iuŋi, qu Iquenyqä quuvqä maeqiyqä itqätaŋgä, Iqu wäuŋuä ämaqä mimäkqänäŋi, kuapänä mimäkqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hea iŋgaŋi ämaqä ämiqä Heroti iqu, qu Jisasi Iqu wäuŋuä imäkqaŋgqeŋqä tqaŋgä qätä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iwä, iqueqä wäuŋuä-wiyqä iquauŋi, tiiŋä ätukqe. “Ämaqä Tqu, Jonä asŋä-qäyqä iqueqä. Iqu qua äptekuwä iuta aŋgumä ävaukqä iqueqä. Iiŋiŋqe Iqu yäŋänäqŋqä-täŋu eä, wäuŋuä ämaqä mimäkqänäŋi, imäkqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kukŋuä iiŋä iqueqä quati, tiiŋiqä. Qäŋganäŋi Heroti iqueqä käta Pilipä iqu, apäkä Herotiyasi ämamiŋqe. Ii Pilipä ique ävämaŋi, Heroti ique ämuaŋgqe. Heroti iqu ii ämakqeŋqe, Jonä iqu iqueŋi tiiŋä ätumiŋqe. “Si apäkä täsi ämeŋi, ii qäyunä hmanjqä.” Iqu e tquaŋgqetaŋi, Heroti iqu iqueŋi a äkiqätätä, guä äkiqiyäutä, guä pmuateqä aŋiu äpmuatekqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Iqu iqueŋi pizqä päsqäŋqä kŋuä wiyqaŋgqä-qe, qokä-apäkä iqua, “Jonä iqu hiŋuä-tqä-queqä” kŋuä indqänätaŋguwiŋqä, iqu iquauŋqä zä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hiunji hŋqueŋi ämaqä hŋqua, Heroti iqueqä känai ique ämikqeŋqä kŋuä indqänäpu, iqutä buayä anä äŋguwi. Iŋgaŋi Herotiyasiyqä meqi ätimäuqe, iquauqä awä iqisa yeewä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Itaŋga Heroti iqu iiyqä yeewä iqaŋgqeŋqä kiiŋä wiŋgaŋgi, kukŋuä guä tiiŋä ämäsäukqe. “Si nätmatqä äkitaŋä äkiŋqä kiŋgaŋgi, yatŋqä nyisqe, nyi äktapmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iiŋä etaŋgi apäkä hitqiyqä kanai, meqiu kŋuä yändqäŋqä vqaŋgi, ii Heroti iqueŋi tiiŋä ätukqe. “Jonä asŋä-qäyqä iqueqä nyuäŋi, ätäväpu hevqä iu eqaŋgpi, si äma äpätnä, nyi dapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Heroti iqu qätä iiŋä äwiyäqe, iqueqä äwqe haŋä qäyä vqaŋgi, iqu kukŋuä guä ae ämäsäukqeŋqä kŋuä indqänätä, ämaqä iqutä buayä anä änmiŋuwä iquauqä hiŋuä iqi womba metŋqe mäwiŋgaŋgi, iqu “Apäkä hitqä ii ätqä-pa, ii imäkpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Iqu ämaqä hŋque guä kiqiyäueqä aŋä duŋqä dowatqaŋga, qu Jonä iqueqä hiiŋuä-qo iu häuä ätäväpu, iqueuä nyuäŋi hevqä hŋque ämiqutäwa äma äppiyi, hitqä ii äwikuwi. Ii äma äwätä, känäu äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iiŋä imäkqaŋguwäŋga, iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äppiyi, iqueqä huiwi äma äwäpu, qua äptekuwi. Iqua qua ae äptepiyi, äwäpu Jisasi Ique qe ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisasi Iqu Jonä ique pizqä äpäkkuwiŋqä qätä äwiyäqe, Iqu aŋä iuŋi äväma, yimba ikuapmäutä aŋä avqŋqä imqä äukqe. Iqutä Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatänä äukuwi. Itaŋgi qokä-apäki, “Jisasi Iqu äwqiyä” tqaŋgä qätä äwipiyi, qu quwqä aŋä-himqä äväma, Iqutä ämimbŋqä eqä maŋä iu qaŋä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iiŋä etaŋgi, Jisasi Iqu iuäqämetäqäŋgaŋi, qokä-apäkä kuapänäŋä pmetaŋgä äquŋgqe. Iqu iquauŋqä huäqä wuŋgaŋgi, iquautaŋä ämaqä täŋä-yaqä iquauŋi äŋguä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mäptqä äwitŋqä iqaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äpäupiyi, Jisasi Iqueŋi tiiŋä ätukuwi. “Mäptqe ae äquveqetŋqä iqiyä. Täqiŋi qua avqŋqäqiyä-qae, Si ämaqeuŋi aŋä-himqä ämätŋgäwäŋqä iuŋqä ymisaŋä mbqä ipu bŋqä dowatiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iqu kimaŋi, “Qu täqiŋi suŋqä äväma upŋqäwä? He hiqä-hiuä ymisaŋä wipiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iwä, qu Iqueŋi, “Ne ymisaŋi kuapänä hmanjqä. Bretqä hipa hŋgiŋitä, hämapäkä hŋquaqutänä ämeŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iŋgaŋi Iqu “Ymisaŋä iiŋi, Nyinyqä ämappiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Itaŋi Iqu ämaqeu, qätaqä iqi quamä pmapŋqä ätukqe. Quamä pmeqaŋguwäŋga, Iqu bretqä hipa hŋgiŋitä, hämapäkä iquaqutä ämeqe, hiŋuä haqä yätu äqänä, Goti Hanjuwä Iquenyqä “äŋguiqä” ätäqe, buayitä hämapäkitä äkutätä, Kiqä ämaqä iquau äwikqe. Iqua ämepu, ämaqä iu äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Qu buayä änäpu, äwqä puäsqaŋga, iqi änätqutekuwi, iqua qa naqä 12 ämamikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Qokä iqua buayä äŋguwi, kuapänäŋi 5,000. Apäkiutä ymeqeutäŋi, a matäuqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Qu iiŋi qäpu iqaŋguwäŋga, Jisasi Iqu wäuŋuäŋqä ämotquamiŋqä iquauŋi, “He yimba iu ätkamäupu, eqä yätäqä näŋgisaŋqä hiŋuiqä upuiyä. Nyi ämaqä täu dowatmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iqu ämaqeu ae ändowatäqetaŋi, Iqueqä-kiuänä qoqoŋä yätuŋqä Kaniquenyqä tääqä tätŋqä ekqe. Mäptqä ae äquvqaŋga, Iqu Iqueqä-kiuänä qoqoŋä iu yqänä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Iŋäqe yimbae kiiŋä näŋi ae äwqaŋga, yuŋui himäŋgisa yäŋänäqŋqä äqunätä, eqä änyämäwa äpeyätä, yimba iqueŋi ämäquvasämäuqänä itä, näŋgi-täŋgi ämimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Zä vätŋqä qäqiqiŋi, Jisasi Iqu eqä-huäŋä haqeqä iquau wimetŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iqua Iqu eqä-huäŋä haqeqi qaŋä quvepqaŋgi äqumbiyi, “Hiwiyqeqä” kŋuä indqänäpu, zä kiiŋä ipu, zä-zääqä, ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Itaŋgi maqänäŋi, Iqu iquauŋi ätukqe. “He zä miqä pambiyä! Yäŋänäqŋqä pmapiyä! Ii Nyinjqä.” ");
INSERT INTO mcr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","I tquaŋga, Pitä iqu kimaŋi, “Naqä Iquki, Si Qäquki etaŋgutqe, ‘Eqä haqeqi qaŋä biyä’ diyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Itaŋi Jisasi Iqu, “Si yqä biyä!” ätukqe. I tquaŋga Pitä iqu yimba iu ävämaŋi, eqä-huäŋä haqeqi Jisasi Ique wimetŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Itaŋi yuŋui yäŋänäqŋqä yqänä qunätqätaŋgi äqunäqe, iqu zä äwiŋgqe. Ga eqä-huäŋä yäpä iŋgisa quveqetŋqänä tii itäqäŋgaŋi, zääqä ätätä tiiŋä ätukqe. “Naqä Iquki, nyi yätamäkqä nyiyä!” ");
INSERT INTO mcr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Maqänäŋi Jisasi Iqu iqueŋi a äkiqätätä ätukqe. “Si ämaqä quuvqä wäŋqäpu heqiyä iqukiyqä. Kŋuä hŋquaquŋi, suŋqä indqänätqäŋinyä?” ");
INSERT INTO mcr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","E ätuäqetaŋi, iquaqu yimba iu ikuapmäuqaŋgiyäŋga, yuŋui qäpu qe ämŋäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iŋgaŋi ämaqä yimba iu äpmamiŋuwä iqua, qu Ique qoŋä äwoktäupu, Iqueqä yoqe, haqeqä ämamäupu tii ätkuwi. “Naqä-qakuiqä. Si Goti Hanjuwä Iqueqä Ymeqä Qäqukiyqä.” ");
INSERT INTO mcr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Itaŋga iqua eqä-huäŋä iuŋi qäyakämä ipiyi, qua Genesäretqä iu iuäqämakuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ämaqä aŋä iutaŋä iqua Ique hiŋuä äqunäpu, Jisasi Iqu iqi timäuqaŋgi näqŋqä epiyi, qu kukŋuä aŋä qäqiqiŋiuŋqä ändowatkuwi. Itaŋi qu ämaqä täŋä-yaqä-täŋä eeqänäŋä iquauŋi, Iquenyqä qe ätuma äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Äwimapiyi, qu Iqueŋi yatŋqä änäänä äväpu, tiiŋä ätukuwi. “Ämaqä yaqä-täŋä iqua hipae tqä gquä hämänäŋä iu qäyä itmaqämbŋqä hiŋuinä qunyä.” Itaŋi qokä-apäkä inyänä ipiyitaŋi, qu eeqänäŋi äŋguä imäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iŋgaŋi Parisi hŋquatä, ämaqä kukŋuä-suqeŋqä näqŋqä hŋquatä, qu Jerusälemä iu ävämaŋi, Jisasi Iquenyqä äquveppiyi, yatŋqä tii qe äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Äänä etaŋgikä? Tqä ämaqä wäuŋuäŋqä ämotquetqäŋä iqua, suqä atqä-awäka änätapukuwi, qu qui imäkätqäŋuwiuä. Qu buayä bŋqäŋgaŋi, hipa asŋi eqä akiyä iŋqä du, ganä maqŋqä, hipa kiyä mätqetä änätqäŋuwiuä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisasi Iqu iquauŋi kimaŋi tiiŋä ätukqe. “Änääŋäŋqäwä? Hiqä-hiuäŋi, he Goti Hanjuwä Iqueqä kukŋuä-suqä iuŋi ävasäupu, hiqä suqä iuŋi qänaknä itqäŋuwiuä. ");
INSERT INTO mcr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Goti Hanjuwä Iqu kukŋuä hŋquaqu tii ätkqeqä. ‘Si tqä tniquetä, tnäwqätä, kukŋuä qänaknä itnä, yäpä iqinyä isŋqeqä.’ Itaŋga ‘Ämaqä hŋqu kiqä kaniqueŋqätä, känäuŋqätä, kukŋuä quvqä ätätqe, qu iqueŋi pizqä päkpŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Goti Iqu iiŋä ätkqä-qe, he tii tquenjqä. Ämaqä hŋqu iqueqä käniquesä känäutäŋi, ‘Nätmatqä nyi yätamäkqä qemätmä ämeŋqe, nyi Goti Hanjuwä Ique wimqä a ae ätäuqeqä’ ätuätqe, ämaqä iqu kaniqueqätä känäwqätä, yäpä iqi itä mävqä yäŋqiyä. Suqä iiŋä dutaŋi, he Goti Hanjuwä Iqueqä kukŋui mändi äkittqiyäpu, hiqä taqä-tawäkauqä suqe, haqeqä ävauqumuatätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","He wopqä ipu, kukŋuinä tqä-quenjqä! Hiŋuä-tqä Asayä iqu hiqä suqä iiŋqe, atäuŋuä qäyunä itä, tiiŋä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ämaqä tä, qu Nyaqä yoqe, maŋitänä haqeqä ämamäutqäŋuwä-qe, quwqä qeqä-quuvqe, Nyinyqe kiiŋä nämä äwinä. ");
INSERT INTO mcr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Qu ämaqä iquauqä kukŋuä-suqä dinä awä ätäpiyä-qe, “Kukŋuä tä Goti Hanjuwä Iqueqe-qe” quaŋgä ätätqäŋä. Iiŋqe, qu Ŋqä yoqe haqeqä mamäupŋqä qoŋä änäuktäutqäŋuwi, hiŋginäwa itqäŋuwiqä.’” ");
INSERT INTO mcr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iqu iiŋä ätuäqetaŋi, qokä-apäkä iquauŋi, tääqä ätuätumetä tiiŋä ätukqe. “He qätä änyiyäpu, kŋuä äŋguänä indqämbiyä! ");
INSERT INTO mcr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nätmatqe ämaqä hŋqueqä maŋä iu äpaquvqe, ii ämaqä iqueŋi Goti Iqueqä hiŋuä iqiŋi kiyä mätqä mimäkqä iqiyä. Oeyqä. Ämaqä kiyä mätqä imäkqe, nätmatqä maŋä iuta ätimäutä awä ätqe, ii qäqunänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Qänakndaŋi wäuŋuäŋqä ämotquamiŋqä iqua äppiyi, Jisasi Ique tiiŋä ätukuwi. “Parisi iqua, Saqä kukŋui qätä äkipiyitaŋi, qu äwqä quvqä äwiŋgqeŋqe, Si näqŋqä ae eäŋätanä, änäändanä?” ");
INSERT INTO mcr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Itaŋi Iqu kimaŋi tiiŋä ätukqe. “Ŋqä Apiqu Qäukuä Yätu Äpmeŋqä Iqu wäuŋuä-täŋueqä. Itaŋga nätmatqä eeqänäŋä Iqu vowä mikqä ikqä iuŋi, hukä qäsä äyauniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ämaqä tquauŋqe, he äwäwa miqä pambiyä. Iqua hiŋuä pisqä epu, hiŋuä pisqä hŋquau-mända hänaqä ämotquetqäŋuwä-paŋiqä. Hiŋuä pisqä hŋqu, hiŋuä pisqä hŋque-mända hänaqä motquamätä itqe, qäquaqu qua hovqä iu quanŋä päkinyiyäŋqinyqä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Itaŋi Pitä iqu Jisasi Iqueŋi tiiŋä ätukqe. “Kukŋuä ktqä kiqä quatiŋqe, awä natiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisasi Iqu kimaŋi, “Iŋi suŋqäwä? He kŋuä mämeqä iquwätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Tiiŋiŋqä he maqŋqätanä? Nätmatqä eeqänäŋi, maŋä iu äpaquvätŋqe, ii tuqä iuŋqä äwitä, iqisaŋi zä-aŋä buŋqä äquveqänä. ");
INSERT INTO mcr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","I etaŋgi nätmatqe, maŋä iqu awä ätätŋqe, ii kŋuä indqäŋqä iutanjqä. Nätmatqä ämaqeu, Goti Iqueqä hiŋuä iqi kiyä mätqä imäkätŋqe, ii qäqunänjqä. ");
INSERT INTO mcr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nyi ‘kŋuä indqäŋqä iutanjqä’ etqe, ii suqä tiiŋiŋqä ätqä. Kŋuä indqäŋqä quvqä, suqä ämaqä pizqä päsqä, huiziqueqä apäkäŋqä iqä, huiwä yaŋä hiŋgi iŋqä, quwä-meqä, kukŋuä mitqeta quaŋgä-tqä, itaŋga hŋquauŋqä kukŋuä quvqä tqä, iquayi. ");
INSERT INTO mcr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Suqä tqua ämaqä iuŋi, Goti Hanjuwä Iqueqä hiŋuä iqiŋi kiyä mätqä imäkätqänä. Itaŋgi ämaqä hŋqu hipa asŋä maqŋqä buayä äŋgqäqe, suqä iiŋi, ique kiyä mätqä mimäkqä iqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisasi Iqu iqi ävämaŋi, aŋä-himqä Tayätä Saitonätä ämätnäŋqä-täŋä iŋginyqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Apäkä hueqä-himqä Kenanätaŋä iqi äpmamiŋqä hui, ii äpätä tääqä tiiŋä ätukqe. “Naqä Iqukiyä, Dewiti iqueqä kawiquki, dŋä quvqä hŋqu nyaqä ymeqä apäkä hmbi qui imäkätqäuä. Si nyinyqä qeqä kimänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Itaŋgi Iqu iiŋi, kimaŋi hui mätquä ikqe. Itaŋga Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äpäpu, Iqueŋi tii ätukuwi. “Apäkä ne änavändä, tääqä ätqapätŋqä täsiiŋi, huätä dowatiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Itaŋi Iqu kimaŋi tiiŋä ätukqe. “Goti Hanjuwä Iqu, Nyi Israitqä iquaunä yätamäkqä wimqä änändowatkqe. Qu sipsipqä hänaqä qäyunäŋiŋqä maqŋqä eŋqä-paŋä-qua etaŋgä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","I tquaŋgi äwiyäqe, apäkä ii Iqu-täŋä qäqi äpätä, qoŋä äusäuepätä, “Naqä Iqukiyä. Si nyi yätamäkqä nyiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iiyqä kukŋui, Iqu kima tii ätukqe. “Ne ymeqä iquauqä buayi ämetanä, hiveqä iquau-mända vatuŋque, ii qäyu manä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Itaŋgi apakä ii, “Naqä Iquki, Si naqä-qakuänä ätnyä” ätukqe. “Itaŋgi buayä hituŋuä hnjua, quwqä kaniqueqä hevqä iuta qua iqi ätiväutqe, hiveqä iqua pänaŋqä ipu, ämambŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisasi Iqu kukŋuä tä qätä äwiyäqe, Iqu kimaŋi tii ätukqe. “Tqä quuvqä heqiyqe, naqänäŋiqä. Nätmatqä si äkiŋgqe, äkimeŋqiyä.” Asäŋgaŋi iiyqä hitqä ii, äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisasi Iqu aŋä iuŋi ävämaŋi, eqä-huäŋä Galili maŋä iuŋqä äpäquveqäkqe. Iqisaŋi Iqu qoqoŋä yätuŋqä äyätä, iqi äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iqu iqi pmetaŋga, qokä-apäkä kuapänäŋi, qu yukä quvqä iquautä, hiŋuä pisqä iquautä, yukä ŋŋuä iquautä, maŋä matqä iquautä, itaŋga ämaqä täŋä-yaqä-täŋä kuapänäŋä iquauŋi, Iqueŋqä ätuma äpkuwi. Äwimapiyi, qu Iqueuä yukä-täŋä qäqi pmuateqaŋguwäŋga, Iqu iquauŋi äŋguä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Itaŋi ämaqe, qu maŋä matqä iqua kukŋuä tqaŋgä, yukä quvqä iqua äŋguä imäŋgaŋgä, yukä ŋŋuä iqua qaŋä uwqaŋgä, hiŋuä pisqä iqua hiŋuä qäŋgaŋgä, hiŋuä äquŋguwi. Hiŋuä iiŋä äqumbiyitaŋi, qu yäuŋuä ipu, “Täukueqä” ätäpu, Goti Hanjuwä Israitqä iquau Miqä Iqueqä yoqe, haqeqä ämamäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hiunji hŋquaqui-hŋque ae äpäwqaŋga, Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, tääqä ätuätumetä, tiiŋä ätukqe. “Nyi qokä-apäkä täuŋqe huäqä änuŋgiyä. Qu Nyitä hiunji hŋquaqui-hŋque äpmequwi, buayi hmayqä. Buayä dä qäsä dowatmqe, hänaqä awä ipe popo ipu päkŋqeŋqe, Nyi manyiŋqä iqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iqu e tquaŋga, iqua kimaŋi ätukuwi. “Täqiŋi aŋä avqŋqä eäŋqe, ämaqä kuapänäŋä tiiŋä du ymisaŋä vatuŋquä diŋqe, ne bretqe äŋgisa metuŋquäwä?” ");
INSERT INTO mcr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Itaŋga Iqu yatŋqä tii äwikqe. “He bretqe, äänä meŋäuä?” Itaŋi iqua, “Ne bretqe, 7 hŋquatä, hämapäkä wäŋqä hnjuatä ämeŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I tquaŋguwäŋga Iqu qokä-apäkä iquauŋi, “Qua iqi quamä pmapiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iŋgaŋi Iqu bretqetä, hämapäkitä ämeqe, Goti Hanjuwä Ique “äŋguiqä” ätuäqe, äkutätä, itaŋi wäuŋuäŋqä ämotquamiŋqä iquau qe äwikqe. Itaŋgaŋi iqua ämotaupiyi, ämaqä iu qe äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Qu eeqäŋi äwqä änäpäsäpu, iqi änätqutekuwi, iqua hiqokä-qa 7 ämamikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Qokä iqua buayä äŋguwi, kuapänäŋi 4,000. Apäkiutä ymeqeutäŋi, a matäuqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Itaŋi Jisasi Iqu qokä-apäkä iu ae ändowatäqe, Iqu yimba iu ätkamäutä, Makändanä iuŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi hŋquatä, Satyusi hŋquatä Jisasi Ique äwimapiyi, yamwiqä äväpu tii ätukuwi. “Si Goti Qäukuä Yätu Äpmeŋqä Iqueqä wäuŋuä imäkquki etaŋgutqe, si wäuŋuä ämaqä mimäkqänäŋä hŋqu imäkätnä mänätquayä.” ");
INSERT INTO mcr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Itaŋgi Iqu iquau kimaŋi, tiiŋä ätukqe. “Mäptqä äquveqetä, qäukui qua häŋesqä qäyqaŋgaŋi, he ‘Qäukui häŋesqä äqiyqe, ziŋuitäŋi mäptqä äŋguänä täŋqiyä’ tqä-quenjqä. ");
INSERT INTO mcr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Itaŋga ziŋuitäŋi, he tii tqä-quenjqä. ‘Qaquvqe hea äwitä, qäukui häŋesqä imäŋgqeŋqe, ii yuŋuä äqunätä piyä qiyäŋqiyä.’ Auqä, qäukuä iutaŋä hiqŋqe, he hiŋuä äqunäpu, iuta iwäsäupŋqeŋqe, näqŋqä äŋguänä ämeŋäuä. Iŋäqe Goti Hanjuwä Iqu täŋga imäkätŋqeŋqä hiqŋqe, he hiŋuä äqumbiyi, iuta iuwäsäupŋqä iiŋqe, he maqŋquenjqä. ");
INSERT INTO mcr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","He qokä-apäkä täŋga äpmeŋuwä iquenä, he apäkä qokiqu äväma qaŋä hiŋgi qŋqä eŋqä-paŋä, quvqä eäpu, Goti Hanjuwä Iqueŋi qänaknä miqä-quenjqä. He ‘Si Tquki eäŋiŋqä ämänätquetnä, wäuŋuä hui imäkiyä’ ändquwä-qe, Nyi wäuŋuä hui mimäkqä imqänä. He näqŋqä mapŋqä hiqŋqe, hiŋuä-tqä Jona iqu qeyqä” ätukqe. I ätuäqe, quŋi äväma äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisasi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua eqä-huäŋä-täŋä yätäqäŋgisaŋqä äukuwi. Iqua qaŋä äwäpiyäŋgaŋi, bretqe qäsä äma pqeŋqe, kŋuä hui imäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iŋgaŋi, Jisasi Iqu iquauŋi tiiŋä ätukqe. “Parisi iquauätä, Satyusi iquauätä, nätmatqä änyuämäuqä iiŋqe, he maŋitä ämäwqätäupu äŋguänä mimbiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iqu i tquaŋgqeŋqä kŋuä indqänäpu, quwqä-quwä tiiŋä ätŋguwi. “Ne bretqe äma mapqä iququeŋqä, i änatqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Qu kukŋuä iiŋä ätnmiŋuwiŋqe, Jisasi Iqu näqŋqä eä, tii ätukqe. “Hiqä quuvqä heqiyqe, wäŋqänäŋäpiyqä. ‘Ne bretqe hmanjqe’ suŋqä ätätqäŋäuä? Nyi bretqeŋqä maetqä da iqänä. ");
INSERT INTO mcr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","He Nyinyqätä, Nyaqä kukŋuiŋqätäŋi, näqŋqä änä mämeqä iquwätanä? Buayä hipa hŋgiŋinäŋi, ämaqä kuapänäŋä 5,000 äŋguwiŋqe, he hui imäuquwätanä? He qae squmä ämamikuwäwä? ");
INSERT INTO mcr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Itaŋga buayä hipa hiŋgi eeqä hŋgi hŋquaqunäŋi, ämaqä kuapänäŋä 4,000 iqua äŋguwiŋqä-pqe, he hui imäuquwätanä? Iŋgaŋi he qae squmä ämanyuequwäwä? ");
INSERT INTO mcr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","He iiŋiŋqä maqŋqä eäŋuwi, ii suŋqäwä? Nyi bretqeŋqä kŋuä nyiyqaŋgi maetqä da iqänä. Nyi Parisi iquauätä, Satyusi iquauätä, nätmatqä änyuämäuqä iiŋqe, ‘He maŋitä ämäwqätäupu äŋguänä mimbiyä’ etqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Qu kukŋuä tä qätä äwipiyitaŋi, näqŋqä tiiŋä ämakuwi. “Iqu nätmatqä bretqä änyuämäuqä iiŋqä mänatqä iqiyä. Oeyä. Iqu Parisi iquauätä, Satyusi iquauätä, kukŋuiŋqä änatqiyä-qe” näqŋqä ämakuwi. ");
INSERT INTO mcr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisasi Iqu aŋä-himqä Sisariya-Pilipai-täŋä iŋgisaŋqä äwäqetaŋi, Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, yatŋqä äwikqe. “Ämaqeuqä Ymeqä Ekqä Iquenyqe, qokä-apäki kŋuä äänä indqänätqäŋuwäwä? Iqu tqukä?” ");
INSERT INTO mcr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I tquaŋga iqua kimaŋi, “Hŋqua ‘Jonä asŋä-qäyqä iqueqä,’ hŋqua ‘Laisa iqueqä,’ itaŋga hŋqua ‘Järämai iqutiyä, hiŋuä-tqä hŋququtiyä?’ ätätqäŋuwiqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iqua e tquaŋguwäŋga, Iqu “Hiyaqä kŋuä duŋi, Nyi tquŋgä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimonä Pitä iqu kimaŋi, tii ätukqe. “Si Kraisi, Goti Hanjuwä Iqu ne äminesŋqä atäuŋuä äkikqä Iqukiyqä. Si Goti Häŋä Pmeqä-täŋä Iqueqä Ymeqä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Itaŋi Jisasi Iqu kimaŋi tiiŋä ätukqe. “Jona iqueqä ymeqä Saimonä iquki, Goti Hanjuwä Iqu äŋguä ikimäkqeqä. Ämaqä qua täutaŋä hŋqu, kukŋuä tä si mämäktqueqä iqeqä. Oeyä. Ŋqä Apiqu Qäukuä Yätu Äpmeŋqä Iqunä si ämäktqueqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Itaŋga Nyi si tiiŋä äktqänä. Si Pitä iqukiyqä. Itaŋgaŋi ämaqe, aŋä yäŋänäqŋqä hikä haqeqi ämätätqäŋuwä-pa, Nyi Ŋqä ämaqä iquau aquvä ämaqiyätmä, hikä tqueqä haqeqi pmuatemniqeqä. Itaŋgaŋi äpäkoŋqä iqueqä yäŋänäqŋqe, Nyaqä ämaqä aquväqŋqä tquauŋi, änä makittqiyqä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Goti Qäukuä Yätutaŋä Iqunä miqetaŋä qŋqaŋä hutäuqe, Nyi si ktapmniqeqä. Nätmatqe, si qua täuŋi pmua imäkqaŋgtqe, Goti Qäukuä Yätu Äpmeŋqä Iqu-pqä inä imäkäŋqiyä. Itaŋga nätmatqä qua täuŋi hiŋuinä quŋgaŋgtqe, Goti Qäukuä Yätu Äpmeŋqä Iqu-pqä asä e imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Itaŋi Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, pmua yäŋänäqŋqä iwimäkätä, tii ätukqe. “Ämaqä Goti Hanjuwä Iqu ämaqä miqeŋqä atäuŋuä ikqä Kraisi Iqu, Nyi Qäqunjqae, he ämaqeuŋi awä mätquä pambiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iŋgaŋi Jisasi Iqu wäuŋuäŋqä ämotquamiŋqä iquauŋi kukŋuä tiiŋä tuätŋqä ätipäqäkqe. “Nyi Jerusälemä iuŋqä umqe. Iqiŋi, ämaqeu miqä iquatä, hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatäŋi, qu haŋä-iqä naqänäŋä ändapäpu, Nyi pizqä bäkpnuwiqä. Iwä hea hŋquaqu-hŋque ae äpäwqaŋgaŋi, Goti Hanjuwä Iqu Nyi aŋgi änyivauqumuatäniqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitä iqu kukŋuä tä qätä äwiyäqe, Jisasi Ique maŋitä ätuma äwäqe, Ique äkasuwä tuätŋqä ätipäqäkqe. “Naqä Iquki, oeyä! Nätmatqä tä, Si mäkimeqä iŋqiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Itaŋi Jisasi Iqu hiqumuaŋä äwiyäqe, Pitä iqueŋi tiiŋä qe ätukqe. “Setänä iquki, wawiyä! Si hikä hänaqä iu äknänä, Nyi quanŋä päknmqä nyimäkŋä-paŋä iqukiyqä. Si qänaknäŋi, Goti Hanjuwä Iqueqä kŋuä indqäŋqä iunä miqä itnä, ämaqeuqä kŋuä iunä inyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iŋgaŋi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau tii ätukqe. “Ämaqä hŋqu Nyi qänaknä nyivändätŋqä wiŋgaŋgutqe, iqueqä äwiŋqä eeqänäŋi, kiuä mändi äkittqänätä, iqueqä zä-huätatä huŋqe ämetä, Nyi qänaki nyivändänä. ");
INSERT INTO mcr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ii tiiŋiqä. Ämaqä hŋqu, iqueqä häŋä-pmeqe a yäŋänäqŋqä äkiqätmitätqe, qui imäknäniqeqä. Iŋäqe ämaqä hŋqu, Nyinyqä kŋuä indqänätä, iqueqä häŋä-pmeqe ävquatämämitätqe, iqu häŋä pmetäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Itaŋga ämaqä hŋqu nätmatqä qua täuŋi eeqänä ämetä, iqueqä häŋä-pmeqe qui imäkŋgaŋgutqe, iqueqä nätmatqä eeqänäŋä iiŋi, yätamäkqä äänä väniqiyä? Itaŋga ämaqä hŋqu, iqueqä häŋä-pmeqe aŋgumä metŋqe, squä di väniqiyä? ");
INSERT INTO mcr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nyi iiŋä etqäqe, kiqä quati tiiŋiqä. Ämaqeuqä Ymeqä Ekqä Iqu Kaniqueqä yäŋänäqŋqe ämetä, Iqueqä eŋätqä iquatä quvepäniqeqä. Itaŋga Iqu ämaqä eeqänäŋä iuŋi, qu suqä imäkmitpqeŋqe, kimaŋi iŋga väniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nyi naqä-qakuänä etqänä. Ämaqä täqi pämä ätqäuŋuwä hŋqua, mapäkoŋqä änä yqänä pmetaŋguwäŋgaŋi, Ämaqeuqä Ymeqä Ekqä Iqu, ämiqä naqä eŋqä-paŋä-qu pqaŋgi qumbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hiunji 6 ae äpäwqaŋgaŋi, Jisasi Iqu, Pitä ique, Jemisi ique, itaŋga käŋgua Jonä ique itmeqe, qoqoŋä quäuqä hŋqueŋqä ätuma ekqe. Iqiŋi iquauqä-quwänä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iquauqä hiŋuä iqisaŋi, Jisasi Iqueqä huiwi huitaŋä änyätä, Iqueqä hipeŋui mäptqä eŋqä-paŋä ätätä, qäki qäpaiqänäŋä imänätä we äuŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iunä äqunäŋunä tpu ikuwi, Jisasi Iqutäŋi, Mosisi iqutä, Laisa iqutä, anä ätqäunyä kukŋuä tätqätaŋgä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ii äqunäpiyiŋqä, Pitä iqu, Jisasi Iqueŋi tiiŋä ätukqe. “Naqä Iqukiyä. Ne täqi äpmeŋque, ii äŋguänäŋiqä. Iŋi Si äkiŋgaŋgutqe, nyi ittäŋä aŋä hŋquaqui-hŋque mätmqänä. Hŋqu Tqäuä. Hŋqu Mosisi iqueqäuä. Itaŋga hŋqu Laisa iqueqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitä iqu kukŋuä änä tätqätaŋga, qaquvqä wenyä-huŋqä hŋqu iquauŋi qe äpatqäkqe. Itaŋi qaquvqä iqueqä yäpä imdaŋi, maŋä hŋqu tiiŋä ätukqe. “Tqu Ŋqä Ymeqä Nyi kuapänä änyinätŋqä Iqueyqä. Iquenyqe, Nyi aquvänä kiiŋä itqäŋänä. He Iqueqä kukŋui qätä wipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iqueqä ämaqä iqua kukŋuä tä qätä äwipiyi, qu zä kiiŋä wiŋgaŋgi qoŋä äusäukipu, hipeŋui qua bu ekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Itaŋi Jisasi Iqu iqua-täŋä qäqiqi äquvepäqe, iquauŋi itmaqiyätä, tii ätukqe. “He zä miqä pambiyä. Pämä tqäpiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Qu ätkimbu hiŋuä ämäquŋguwi, ämaqä huizi iquaqu aaŋqä etaŋgi, Jisasi Iqu Iqueqä-kiuänä tqäutaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Itaŋga qu qoqoŋä yätuta äpäwipiyäŋgaŋi, Jisasi Iqu iquauŋi yäŋänäqŋqä tiiŋä ätukqe. “Nätmatqä he hiŋuä äqunäŋuwiŋqe, ämaqä hŋque mätquä pambiyä. Ämaqeuqä Ymeqä Ekqä Iqu, qua äptepqetaŋi ävämetä, aŋgumä ävauqaŋgutqäŋgaŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","I tquaŋga, iqua Iqueŋi yatŋqä tiiŋä äwikuwi. “Laisa iqu täŋganä quvepqaŋgi äqunäŋunä. Iŋi ämaqä kukŋuä-suqeŋqä näqŋqä iqua tiiŋi, suŋqä ätätqäŋuwäwä? ‘Laisa iqu Kraisi Iqueŋi hiŋuiqä wimeŋqiyäqeuä.’” ");
INSERT INTO mcr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iqu kimaŋi, tii ätukqe. “Qu qäyunä ätätqäŋuwiqä. Laisa iqu äpätä, nätmatqä eeqänäŋi aŋgumä jänä imäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Itaŋgi Nyi tiiŋä hitmqeqä. Laisa iqu ae äquvepkqeqä. Itaŋga ämaqä iqua qu iquenyqä maqŋqä eäpu, iquauqä äwiŋqä dunä imäkäpu, suqä huitaŋä-huitaŋä itquamiŋuwiqä. Itaŋgi Ämaqeuqä Ymeqä Ekqä Iqu, iquauqä huiqä iutaŋi, asä iiŋä meŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iqu iiŋä tquaŋgqeŋqe, iqua näqŋqä tiiŋä ämakuwi. “Tä, Jonä asŋä-qäyqä iquenyqä ätqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iqua qoqoŋä yätuta äquveppiyi, qokä-apäkä kuapänä imänätaŋguwä iu äwimakuwi. Iŋgaŋi ämaqä hŋqu Jisasi Iqueŋqä äpäqe, qoŋä äusäuepätä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Naqä Iqukiyä. Nyaqä ymeqä qokä iqu ppqä-täŋä etaŋgi, Si iquenyqä qeqä äkimänänä. Iqu tä iu äpäknätä, ä eqä iu äpäknätä, qui kuapänä imäknätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Itaŋga nyi iqueŋi, Tqä wäuŋuäŋqä ämotquetqäŋä iquauŋqä ätuma äpqä-qe, iqua iqueŋi, äŋguä mimäkqä iquwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kimaŋi, Jisasi Iqu tii ätukqe. “Ämaqä täŋga äpmeŋuwä iquenä, he quuvqä maeqiyqä itqäŋuwiqä. Hiqä kŋuä indqäŋqetä, suqetäŋi, jänä hmanjqä. Nyi hesä anäŋi, squäŋgaŋqä pmamqäwä? Ä, hesaŋi haŋä-iqä squäŋgaŋqä meqämqäwä? Ymeqä iqueŋi, ätuma bpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Itaŋi Jisasi Iqu dŋä quvqä ique äkasuwä tquaŋga, dŋä quvqä iqu ymeqä iqueŋi ävämeqaŋga, maqänäŋi ymeqä iqu äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Qänakŋi wäuŋuäŋqä ämotquamiŋqä iqua, Jisasi Ique äwimepu, yatŋqä tiiŋä äwikuwi. “Ne dŋä quvqä ique huätä mämamäuqe, äänä hitaŋgikä?” ");
INSERT INTO mcr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Iqu kimaŋi tiiŋä ätukqe. “Hiqä quuvqä heqiyqe, aaŋä wäŋqänäŋäpu etaŋgi, he iiŋi änä mimäkqä ipŋqäuä. Nyi naqä-qakuä hitmqeqä. Hiqä quuvqä heqiyqe, zä-guawä piikä wäŋqä isua eŋqä-paŋä etaŋgutqe, he qoqoŋä tqueŋi, ‘Täqisaŋi, näŋiŋqä uvä’ tquaŋguwäŋgaŋi, iqu äwäŋqiyä. He eeqänäŋä iŋi, qeiqinyä imäkpŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisasi Iqutä wäuŋuäŋqä ämotquamiŋqä iquatä, qua naqä Galili iu aquvä äqämbiyi, Iqu iquauŋi tiiŋä ätukqe. “Hea hatŋä mäpäwqaŋga, qu Ämaqeuqä Ymeqä Ekqä Iqueŋi ämaqä iquauqä hipa iu wipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Itaŋi iqua Iqueŋi pizqä päkpŋqäuä. Ga hiunji hŋquaqui-hŋqueŋä iuŋi, Goti Hanjuwä Iqu Ique aŋgumä vauqumuatäŋqiyä.” Iqua qätä iiŋä äwipiyi, äwqä haŋä kiiŋä qe äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Qänakŋi iqua äwäpu, aŋä-himqä Kapänamä iu ätimäukuwi. Iqiŋi Goti Iqueqä hiqäva-imäkqä aŋä Jerusälemä iu ämätnäŋqä iiŋqe, mbqä motauqä hŋqua, Pitä iquenyqä äpäpu, yatŋqä tiiŋä äwikuwi. “Hiqä Ämetqueqä Iqu, hiqäva-imäkqä aŋiŋqe, mbqä ävätŋqätanä, ä mävqä itŋqätanä?” ");
INSERT INTO mcr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitä iqu “Ŋŋqä. Iqu ävätŋqeqä” ätukqe. Itaŋi iqu aŋä yäpä yäŋgisa äpaquväqe, kukŋuä hui matqäŋga, Jisasi Iqu yatŋqä tii äwikqe. “Saimonä iquki, si kŋuä äänä kiyqiyä? Ämaqä ämiqä qua täutaŋä iqua, mbqä huitaŋä-huitaŋi, tquesa ämotautqäŋuwäwä? Iquauqä ymeqä iquautatanä, ä ämaqä hŋquau-mändatanä?” ");
INSERT INTO mcr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kimaŋi iqu, “Ämaqä huizi iquaiqä” ätukqe. I tquaŋga, Jisasi Iqu iqueŋi tiiŋä ätukqe. “Iiŋitaŋi, ämaqä miqä iquauqä ymeqä iqua mävqä itqäŋuwä-pa, Goti Iqu Iqueqä ymeqä-quauta mämotauqä yänä. ");
INSERT INTO mcr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ii qäyä etaŋgqä-qe, ne iquau äwqä äkasuwä iwimäkqä iiŋqe, si äwätnä, eqä-huäŋä iuŋi hämapäkäŋqä guä quväyä. Hämapäkä kiŋganä äpiŋä iqueŋi, si iqueqä maŋi a hutamäkätnä, mbqä hŋqu yäpä iŋgisa witaŋgi qundŋqinyä. Si mbqä iqu ämetnä, Goti Iqueqä hiqäva-imäkqä aŋiŋqe, yeqä-yeuäŋqä iquau wisŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iŋgaŋi wäuŋuäŋqä ämotquamiŋqä iqua Jisasi Ique äwimepu, yatŋqä tii äwikuwi. “Goti Qäukuä Yätutaŋä Iqunä miqeu äpmeŋuwä iquautaŋi, huizi iquau mipŋqe, yoqä naqä tqukua mapnuwäŋqäwä?” ");
INSERT INTO mcr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","I tquaŋguwäŋga, Iqu ymeqä hmbi tääqä ätuätumeqe, iquauqä awä iqi pämä ämatqätetä, tii ätukqe. “Nyi naqä-qakuänä etmqänä. He hiqä kŋuä äkunmäknäpu, ymeqä täpu eŋqä-pa matimäuqä iqaŋgpqe, he Goti Qäukuä Yätutaŋä Iqunä miqeuŋi, mäpaquvqä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ämaqä hŋqu iqueqä-kiuä mändi äkittqänätä, ymeqä täpu eŋqä-pa ätimäutqe, iqu yoqä naqä ämetä, Goti Qäukuä Yätutaŋä Iqunä miqeuŋi, huizi iquau ämäwqätäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ämaqä hŋqu Nyinyqä kŋuä indqänätä, ymeqä täpu eŋqä-paŋä tiiŋä hmbi itmetä, äŋguänä iwimäkätqe, iqu Nyi-pqe asä iiŋä nyimäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ymeqä Nyinyqä quuvqä eqiyätŋqä täutaŋä hmbu, ämaqä hŋqueuä suqä imäkqaŋgqä du hiŋuä äqunätä, asä iiŋi imäkätä quanŋä päkŋgaŋgutqe, ämaqä iqueŋi, haŋä-iqä naqänäŋi wimenä. Ämaqä hŋqua hikä naqänäŋä hŋqu ämepu, iqueqä hiiŋuä-qo iu guä äkiqiyepu, eqä-huäŋä bu tnämäueqaŋgpqe, ii haŋä-iqä wäŋqäpiyqä. Haŋä-iqä ique wimeniqä iqu, tqueŋi aaŋä naqänäŋä ämäwqätäunä. ");
INSERT INTO mcr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Oänä, ämaqä qua täutaŋä eeqänäŋä iquenä. Naqä-qakuiqä. Ämaqe, qu suqä quvqä du quanŋä päkmbŋqeŋqe, nätmatqä huitaŋä-huitaŋi wimenä. Iŋäqe, ämaqä suqä quvqä iiŋä iqua äma äpätqä iqu, haŋä-iqä naqänäŋä meniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tqä hipaiŋä-qe, yukiŋä-qe suqä quvqeŋqä äkiyqiyämeqaŋgutqe, huätä ätävätnä bi tnämävä. Si iiŋä imäkqaŋgtqe, tqä huiwitaŋä hmbu yuuwä ätänätqä-qe, si suqä quvqä iiŋi mimäkqä iŋä-qae, häŋä-pmeqe ämatŋqinyä. Si iiŋä mimäkqä iqaŋgtqe, huiwä yuuwä matäŋqä-qe, qu si tä maisquä iŋqä iu ktnämäupnuwiqä. Huiwä hmbi yuuwä täŋqe, haŋä-iqä ii, wäŋqäpiyqä. Tä duŋqä uwqe, haŋä-iqä naqänäŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tqä hiŋui suqä quvqeŋqä äkiyqiyämeqaŋgutqe, huätä ätqoätnä bi tnämävä. Si iiŋä imäkqaŋgtqe, hiŋuä hŋqunä äqännä, häŋä-pmeqe ämatŋqinyä. Si iiŋä mimäkqä iqaŋgtqe, hiŋuä hŋquaqu yqänä qänätaŋgnä, qu si tä maisquä iŋqä iu ktnämäupnuwiqä. Hiŋuä hŋqunä qŋqe, haŋä-iqä ii, wäŋqäpiyqä. Tä duŋqä uwqe, haŋä-iqä naqänäŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ymeqä wäŋqä isuauä awä iqisaŋä hmbinyqe, ‘Ipu nätmatqä hiŋginäwaŋqeqä’ kŋuä miqä pambiyä. Kŋuä iquenyqe, he äŋguänä wimasipiyä. Nyi he tii hitmqeqä. Ynaunjqä qäukuä yätuŋä ymeqä tquau ämitqäŋuwä iqua, qu Ŋqä Apiqu Qäukuä Yätu Äpmeŋqä Iqueqä hiŋuä iqi ätqäuŋäuä.” ");
INSERT INTO mcr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“He kŋuä äänä heyqiyä? Ämaqä hŋqu sipsipqä kuapänäŋä 100 täŋä-qu emitätqe, ga iquautaŋä hŋqu imatnätqe, iqu qävqä miqä iniqiyä? Oeyä. Iqu kuapänäŋä 99 iquau qoqoŋä iu äpmuatemä äwätä, imatnätqä iquenyqä qävqä yäkiŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nyi naqä-qakuänäŋä etqänä. Iqu sipsipqä kuapänäŋä 99 mimatŋqä iquauŋqe yeeqä itäqä-qe, sipsipqä kiuänäŋä imatnätqä iqueŋi, aŋgi itmetqe, iŋgaŋi iqueqä yeeqä iiŋqe, aaŋä naqänäŋä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Asä iiŋi, hiqä Hiniqu Qäukuä Yätu Äpmeŋqä Iqu, ymeqä isua eŋqä-paŋä hmbu imatnätä qui imäknätŋqe mäwiŋqä inä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","I ätuätäqäŋgaŋi, Iqu kukŋuä hui-pqe inä ätukqe. “Tqä quuvqä anä heqiyqä iqu si quvqä ikitqueqaŋgutqe, si iquenyqä äwätnä, qeeqä-qeuänä äpmanyä, iqueqä suqä imäkätqeŋqä kukŋuä ätäsinyä, kukŋuä jänä imäkiyäŋqä yamwiqä inyqä. Iqu saqä kukŋui qätä kiyqaŋgutqe, si tqä näueqä iqueŋi aŋgumä itmenyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Iqu saqä kukŋui qätä makiyqä iqaŋgutqe, si Goti Hanjuwä Iqu kukŋuä ätkqä-pa qänaknä itnä, ämaqä hŋqunäŋä-qe, hŋquaquiŋä-qe itmetnä, iqutä kukŋuä anä tpŋqeqä. Goti Iqu tii ätkqe. ‘Ämaqä hŋquaquiŋä-qe, hŋquaqui-hŋqueŋä-qe kukŋuä asänäŋä dinä tqaŋgpqe, he qätä iunä wiyqäpnä.’ ");
INSERT INTO mcr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Itaŋgi iqu iquauqä kukŋui qätä mawiyqä iqaŋgutqe, si ämaqä Goti Hanjuwä Iqueqä yoqeŋqä aquvä äqänätqäŋuwä iquauŋi, iqueqä suqeŋqä tutŋqeqä. Itaŋi iqu iquau-pqe qätä mäwiyqä iqaŋgutqe, suqä si ämaqä quuvqä maeqiyqä iquautä, mbqä motauqä iquautä, itquetqäŋä-pa, ga si ique-pqe asä inä itquatŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nyi naqä-qakuänäŋä tii etmqänä. Nätmatqe he qua täuŋi pmua imäkqaŋgpqe, Goti Qäukuä Yätu Äpmeŋqä Iqu-pqä inä imäkäŋqiyä. Itaŋga nätmatqä qua täuŋi hiŋuinä quŋgaŋgpqe, Goti Qäukuä Yätu Äpmeŋqä Iqu-pqä asä e imäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Itaŋga Nyi kukŋuä hui inä hitmqeqä. Ämaqä hŋquaquŋä-qe, hŋquaqui-hŋqueŋä-qe Nyaqä yoqeŋqä aquvä qäŋgaŋgpqe, Nyi iquatä anä pmamqänä. Iiŋiŋqe, ämaqä hesaŋä qua täutaŋä hŋquaqu, iquaquiyqä kŋui nätmatqä hŋquenyqä naqä-hŋqunä indqänäsinyä tääqä siyqe, Nyaqä Apiqu Qäukuä Yätu Äpmeŋqä Iqu äväŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iŋgaŋi Pitä iqu Jisasi Iqu-täŋä qäqiqi äpäqe, yatŋqä tii äwikqe. “Naqä Iquki, ŋqä näueqä hŋqu suqä quvqä indqueqaŋgutqe, iqueqä suqä quvqeŋqe, nyi äwqä haŋui, squmä änä imäknmniŋqäwä? Hipa hŋgiŋi eeqä hŋgiŋi hŋquaquiŋi, ii äŋguätanä?” ");
INSERT INTO mcr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","I tquaŋga kimaŋi, tii ätukqe. “Suqä quvqeŋqä äwqä haŋuä imäkŋqeŋqe, Nyi hipa hŋgiŋi eeqä eäqe, hŋgiŋi hŋquaquŋä iuŋqe, maktqä da iqänä. Si suqä quvqeŋqä äwqä haŋui imäkŋga-imäkŋga äwätnä, aaŋä kuapänäŋä 490 iuŋi ämäwqätäutŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nyi e äktqe, Goti Qäukuä Yätutaŋä Iqunä miqe, kukŋuä ktqä tiiŋä etaŋgiyqä. Ämiqä naqä hŋqu, iqueqä wäuŋuä-wiyqä iqua mbqä hiŋginäwa ämequwi, aŋgi wipŋqä winyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iqu aŋgi metŋqä ipäqiyqaŋgaŋi, qu wäuŋuä-wiyqä hŋque iquenyqä ätuma ppŋqäuä. Iqueqä hiŋginäwa meqe, mbqä aaŋä kuapänäŋä 10,000,000 kinaiqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Iŋäqe, iqu kima vätŋqe hma etaŋgutqe, ämiqä iqu tii tuäŋqiyä. ‘He ämaqä tquesä, iqueqä ymeqä-apäkä iutä, iqueuä nätmatqä eeqänäŋä-pqe, ämaqä hŋqua mbqä ipŋqä qäsä ätuma upuiyä. Iŋi, imbqua ämaqä iquauqä wäuŋuä-wiyqä hiŋgiŋqä hipŋqänänyä. Itaŋga he mbqä kimaŋi, iuta mapŋqänänyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wäuŋuä-wiyqä iqu kukŋuä tä qätä äwiyäqe, iqu ämiqä iqu-täŋä qäqiqi äpäknätä, qoŋä äuktäuä, tii tuäŋqiyä. ‘Yää, si nyinyqä huäqä kuŋgaŋguti, hiŋuä äqännä pmayä. Itaŋga nyi si hiŋginäwa ämäktaukqe, kimaŋi äktapmqänä.’ ");
INSERT INTO mcr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Itaŋi ämiqä naqä iqu iquenyqä huäqä wuŋgaŋgi, iqueŋi ävquatäwatätä, iqueqä hiŋginäwa ämamiŋqä-pqe, pipa iuŋi, yoqe huätä kutäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Itaŋi wäuŋuä-wiyqä iqu yäpaqä mäŋgisa äpäwäqe, iqueqä wäuŋuä anä isinyä 10 kina hiŋginäwa ämotaukqä hŋque wimeŋqiyä. Iqu ique a äkiqätätä, hiiŋuä-qo iu a äkiyamäkätä, tii tuäŋqiyä. ‘Si hiŋginäwa ämakŋä eeqänäŋi, täŋga maqä dapiyä!’ ");
INSERT INTO mcr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Iutaŋi wäuŋuä anä imisiyqä iqu quanŋä äpäknätä, ‘Yää, nyinyqä huäqä kuŋgaŋguti, hiŋuä äqännä pmayä’ tuäŋqiyä. ‘Nyi si hiŋginäwa ämäktaukqe, kima ktapmqänä.’ ");
INSERT INTO mcr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","I tquaŋgaŋi, kiŋganäŋä iqu iiŋiŋqe mäwiŋgaŋgi, ‘Oeyqä’ ätuätä, iqueŋi guä pmuateqä aŋä iuŋqä ätuma wäŋqiyä. Iqueqä hiŋginäwa ämotaukqe, kimaŋi qäyunä äyä hiqaŋgaŋqe, iu yqänä pmetäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ämaqä wäuŋuä anä imipqä huizi iqua, ämaqä iqu i imäkqaŋgi äqumbiyi, qu äwqä haŋä wiŋgaŋguti äwäpu, iquauqä ämiqä naqä ique, suqä e timäuqaŋgi äqumbqeŋqä tupŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iŋgaŋi ämiqä naqä iqu, iqueŋi tääqä ätuätumetä, tiiŋä tuäŋqiyä. ‘Si wäuŋuä imäkqä ququvqä-qukiyqä. Kiŋganäŋi si zääqä dqaŋgnä, tqä hiŋginäwa naqänäŋä ämändaukŋi, nyi pipa iuŋi huätä äyä äkuteqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nyi sinyqä huäqä änuŋgqeqä. Iŋi suŋqäwä? Si tqä wäuŋuä anä imäkqä iquenyqä huäqä makuŋqä iqeuä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Itaŋi iqu äwqä tnäŋä wiŋgaŋguti, ämaqä täŋä-huŋqä vqä iquauqä hipa iu väniqeqä. Iqueqä hiŋginäwa ämotaukqe, kimaŋi qäyunä äyä hiqaŋgaŋqä, iu yqänä pmetäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","He hiqä näueqä hŋqu suqä quvqä etqueqaŋgaŋi, iqueqä suqä quvqeŋqä äwqä haŋuä mimäkŋqä iqaŋgpqe, Nyaqä Apiqu Qäukuä Yätu Äpmeŋqä Iqu-pqe, ämiqä iqu iqä-pa iiŋä emäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisasi Iqu kukŋuä tä qäpu ätuäqetaŋi, Iqu qua Galili iuŋi äväma, qua Jutiya eqä Jotänä ique yätäqä näŋgisaŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Itaŋi ämaqä aaŋä kuapänäŋä, Iqueŋi qänaki äwivändkuwi. Itaŋga iqiŋi, Iqu iquauqä yaqe äŋguä iwimäkmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Itaŋgaŋi Parisi hŋqua Ique äwimepu, “Iqu kukŋuä quvqä hui natqaŋgutqe, Ique kukŋuä mitquaŋqä” kŋuä ämapu, yatŋqä tiiŋä äwikuwi. “Ämaqä hŋqu iqueqä äwiŋqetanä apäki huätä dowatqe, näyaqä suqä iuŋi, äŋguätanä, quvqätanä?” ");
INSERT INTO mcr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kimaŋi, Iqu tii ätukqe. “He Goti Hanjuwä Iqueqä bukä iu äqänäŋqe, kukŋuä tiiŋi a matäuqä itqäŋuwätanä? Kiŋganäŋi, Goti Nätmatqä Eeqänäŋä Imäkqä Iqu, ämaqe imäkätäqäŋgaŋi, Iqu qokätä apäkätä imäkkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iiŋä imäkätäqetaŋi, tiiŋä ätkqeqä. ‘Qokä hŋqu, kandä-känatä ävämetä, iqueqä apäkisä guä ämänyinyä, huiwä naqä-hŋqunä änyinyä pmeqäŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Goti Hanjuwä Iqu iiŋä ätkqeŋqä, qäyaqu huiwi hŋquaqu miŋqä, hŋqunä änyinyä pmesiyäŋqeqä. Iiŋä etaŋgi nätmatqä Goti Hanjuwä Iqu naqä hŋqunä ämamonyetqe, ii ämaqä hŋqu mandumakqŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","E tquaŋga, Parisi iqua Iqueŋi, yatŋqä änyä-häŋä hŋqu tiiŋä äwikuwi. “Iŋi, Mosisi iqu suqä tiiŋi, änääŋqä änätapkqäwä? Iqu suqe, ‘Ämaqä hŋqu huätä dowatqä tuwaŋuä äqiyätä, apäki ävätä, ii huätä dowatätŋqeqä’ ätätä änätapkqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I tquaŋguwäŋga, Iqu kimaŋi tii ätukqe. “He ämaqä hŋgisanä iquendaŋgi, Mosisi iqu apäkä huätä qäyä dowatpŋqä hiŋuinä eqäŋgqeqä. Iŋäqe kiŋganäŋi suqä täutaŋi maeqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nyi tiiŋä hitmqeqä. Ämaqä hŋqueqä apäki, ii ämaqä hŋqutä miqä imitätqä, iiyqä qokiqu iiŋi hiŋgi huätä ändowatätä, apäkä hui-mända ämetqe, iqu suqä huiwä yaŋä ikiqe, imäkqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, qu kukŋuä tä qätä äwipiyi, Iqueŋi tiiŋä ätukuwi. “Täukueqä! Ämaqä hŋqu Si ätŋä täuŋi qänaknä itä, iqueqä apäkitä anä äpmamitätqe, iqu haŋä-iqä naqänäŋä ämattqiyenäŋqiyä. Suqä apäkä mämeqä iqe, ämäwqätäuänä.” ");
INSERT INTO mcr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Itaŋga Iqu tiiŋä ätukqe. “Kukŋuä ii meqe, ämaqä eeqänäŋä iuqä hmanjqä. Oeyqä. Ämaqä Goti Hanjuwä Iqu yäŋänäqŋqä ävqä iquanä mapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ämaqä kukŋuä ii ämetqä iqu, äŋguä meŋqiyä. Nyi e ätqäqe, ii tiiŋiqä. Ämaqä hŋqua, känai ämikqäŋgatqä huiwi qui imäknätä, apäkä mämeqä ipŋqäuä. Ämaqä hŋqua, hŋqua-mända ya äyitqätaŋgä, iqua apäkä mämeqä ipŋqäuä. Itaŋga hŋqua, Goti Qäukuä Yätutaŋä Iqunä miqeuŋqä kŋuä indqänäpu, quwqä-quwä pmua imäknäpu, apäkä mämeqä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iŋgaŋi ämaqe, Jisasi Iqu ymeqä isuau hipa haqeqi äwiyätä, Goti Hanjuwä Iqu äŋguä wimäkätŋqä tääqä tuätŋqä wiŋgaŋgi, quwqä ymeqä isuau ätuma äpkuwi. Iŋäqe, wäuŋuäŋqä ämotquamiŋqä iqua, “Ymeqe, ätuma mapqä pambiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","I tquaŋguwäŋga, Iqu “He ‘oeyä’ mätquä pambiyä. Isua änyimapŋqä qäyä äppiyä. Goti Qäukuä Yätutaŋä Iqunä miqeuŋi, ymeqä täsua eŋqä-paŋä iiŋä isuauqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Itaŋi Iqu ymeqä isuau äŋguä iwimäkätŋqä, hipa haqeqi äwiyäqetaŋi, iqiŋi äväma äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hea hŋqueŋi, hikŋä hŋqu Jisasi Iquenyqä äpätä, tii ätukqe. “Näqŋqä-vqä Iqukiyä. Nyi häŋä hea ique-ique pmeqä mamqe, suqä äŋgui äänä imqäwä?” ");
INSERT INTO mcr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","I tquaŋga, Iqu iqueŋi tiiŋä ätukqe. “Si suqä äŋguiŋqä suŋqä yatŋqä änyinyä? Äŋguänäŋi, Goti Hanjuwä Iqu kiqä-kiuänänjqä. Iŋäqe si häŋä hea ique-ique pmeqe matŋqä kiŋgaŋgutqe, si Goti Hanjuwä Iqueqä suqeuŋi qänaknä isŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iŋgaŋi ämaqä iqu yatŋqä tii inä äwikqe. “Si suqe, äkitaŋiŋqä tnyä?” Kimaŋi, Iqu “Suqä tiiŋä ätnäŋqä iquaŋqä ätqänä” ätukqe. “Si ämaqä pizqä mapäsqä panä. Qokä-apäkä ämaŋqe, huizitä huiwi yaŋä mikiqä panä. Quwä mämeqä panä. Kukŋuä jänä imäkqä iqueŋi, quaŋgä mätquä panä. ");
INSERT INTO mcr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tnaqä-tnuŋuau yäpä iqi qänaknä iqätŋqe. Itaŋga tqä-täuŋqä äkinyätŋqä-paŋi, ämaqä si-täŋä qäqiqiŋä iquauŋqe, asä ii kinyätŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jisasi Iqu i tquaŋga, hikŋä iqu tiiŋä ätukqe. “Suqä eeqänäŋä täuŋi, nyi qänaknä itŋqeqä. Ga nyi äwaŋi, nätmatqä äkiŋqä itqäŋänä?” ");
INSERT INTO mcr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Itaŋi Jisasi Iqu iqueŋi tiiŋä qe ätukqe. “Si jänänäŋukui hisŋqä kiŋqaŋgutqe, tqä nätmatqä eeqänäŋi, ämaqä hŋqua mbqä ipŋqä äma äwätnä, iuta mbqä ämatqe, ämaqä nätmatqä maeqä iquau yaŋä wisŋqeqä. Si iiŋä imäkqaŋgtqe, qäukuä yätutaŋä nätmatqä äŋguänäŋä-täŋukui hisŋqinyä. Ga si Nyi qänaki nyivändiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hikŋä iqu kukŋuä ii qätä äwiyäqe, nätmatqä kuapänäŋä-täŋu etaŋgi, iqueqä äwqä imdaŋi haŋä-iqä ämeqe, äväma äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iqu ae äväma uwqaŋga, Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, tiiŋä ätukqe. “Nyi naqä-qakuänä etqänä. Ämaqä mbqä kuapä-täŋä iqua, Goti Qäukuä Yätutaŋä Iqunä miqä iu paqupŋqe, qeiqinyä manä, yäŋänäqŋqeutanä paqupnuwi. ");
INSERT INTO mcr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nyi he aŋgumä etqänä. Kametqä hŋqu, qäkä guä ktäpiqä yäŋä hovqä iu wätŋqe, iqu yäŋänäqŋqeutanä wänä. Iŋäqe, ämaqä mbqä kuapä-täŋä iqua, Goti Iqueqä miqeuŋqä paqupŋqä yäŋänäqŋqe, kametqä iqueqeuŋi ämäwqätäunä.” ");
INSERT INTO mcr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wäuŋuäŋqä ämotquamiŋqä iqua kukŋuä ii qätä äwipiyi, qu yäuŋuä naqänäŋä ipu, tii ätkuwi. “Mbqä kuapä-täŋä iqua yäŋänäqŋqeuta paqupŋqä etaŋgutqe, ämaqä qui imäknätqäŋuwitaŋi, häŋä hea ique-ique pmeqe, tqu meniqiyä?” ");
INSERT INTO mcr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Itaŋi Jisasi Iqu iquauŋi hiŋuä jänä äqunä, tii ätukqe. “Ämaqe, iiŋi änä mimäkqä iqaŋgpqä-qe, Goti Hanjuwä Iqu nätmatqä eeqänäŋä imäkätŋqe, Yäŋänäqŋqä-täŋueqä.” ");
INSERT INTO mcr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iŋgaŋi, Pitä iqu kimaŋi, tiiŋä ätukqe. “Nenyäŋqe äänä etaŋgiwä? Ne nätmatqä eeqänäŋi ävämaŋi, Si qänaki äyä äkivändäŋunä. Iŋi ne nätmatqe, äkitaŋi metuŋquäwä?” ");
INSERT INTO mcr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Itaŋi Jisasi Iqu iquauŋi tiiŋä ätukqe. “Nyi naqä-qakuänäŋä etqänä. Hea nätmatqä eeqänäŋi änyä-häŋä ätimäutqäŋgaŋi, Ämaqeuqä Ymeqä Ekqä Iqu yoqä naqä-täŋä-qu eätä, zä-hawä aaŋä äŋguänäŋä iu pmeniqeqä. Iŋgaŋi he ämaqä Nyi qänaki änyivändäŋuwä iquenä-pqe, zä-hawä äŋguänäŋä huizi 12 iu äpmapu, Israitqä iquauqä hueqä-himqä 12 iquau mipnuwäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Itaŋga qokä-apäkä Nyaqä yoqeŋqä kŋuä indqänäpu, quwqä aŋä iutä, käta-käŋguäkautä, känanyi-känapqautä, kanuŋuautä, känaqautä, ymeqä iquautä, qua itä, ävämapqä iqua, qu eeqänäŋi, kuapänä 100 inä ämepu, häŋä hea ique-ique pmeqe, ämapnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ämaqä täŋga yoqä-täŋä äpmeŋuwä iutaŋi, kuapänäŋä hŋqua qänaki pmapnuwiqä. Itaŋga ämaqä täŋga yoqä maeqä äpmeŋuwä iutaŋi, kuapänäŋä hŋqua yoqä-täŋä pmapnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nyi kukŋuä ämaqä yoqä-täŋä pmapnuwä iquauŋqä i etqe, ii tiiŋä etaŋgi. Goti Qäukuä Yätutaŋä Iqunä miqe, tiiŋä eŋqä-paŋiqä. Ämaqä hŋqu qua kanä eä, ziŋuä quaesqäŋga 6 klokiuŋi ämaqä hŋquau, iqueqä wainqä wäuŋuä iu wipŋqä, itmewäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ämaqä wäuŋuä imipqä iqua, ‘Ne hiunji tque wäuŋuä itanä, mbqä huätäkŋqä metuŋqueqä’ tquaŋguwäŋga, ämaqä naqä iqu iquauŋi, iqueqä wainqä wäuŋuä iuŋqä dowatäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Hiunji ziŋuitäŋi 9 klokŋga, iqu äwätä, ämaqä hŋqua ququawä aquväqŋqä iu hiŋginäwa tqäutaŋgä äqunäqe, tiiŋä tuäŋqiyä. ‘He-pqe äwäpu, nyaqä wainqä wäuŋuä iu wäuŋuä iqaŋgpqe, nyi mbqe, qäyunä etapmqänä.’ ");
INSERT INTO mcr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","I tquaŋga, qu upŋqäuä. Hiunji quemisqä 12 klokŋgatä, äwiyqä 3 klokŋgatä, ämaqä naqä iqu ququawä aquväqŋqä iuŋqä aŋgi äwätä, suqä asitaŋinä imäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Itaŋi heatqä awiyqä 5 klokiuŋi, iqu äwätä, ämaqä huizi iquau-pqe, hiŋginäwa pämä tqäutaŋgä äqunäqe, yatŋqä tiiŋä väŋqiyä. ‘Äänä etaŋgikä? He hiunji tqueŋi, wäuŋuä maeqä hiŋgi, suŋqä tqäuŋäuä?’ ");
INSERT INTO mcr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Qu kimaŋi, ‘Ämaqä hŋqu, ne wäuŋuä mänätapqä iqeqä’ tupŋqäuä. Itaŋi iqu iquauŋi, ‘He-pqe äwäpu, nyaqä wainqä wäuŋuä iu, wäuŋuä nyipiyä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hiappkä ae äyä wiqaŋga, wäuŋuä kaniqu, iqueqä wäuŋuä-wiyqä iquau miqä ique, tiiŋä tuäŋqiyä. ‘Si ämaqä wäuŋuä imäkqä iquau tääqä ätuätumetnä, mbqä wiyä. Si mbqä wisŋqä ipäqiyätŋäŋgaŋi, qänaki ätimäupqä iquau ganä ävätnä, qu-ganä ätimäupqä iquauŋi qänaki wisŋäŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ga ämaqä wäuŋuä heatqä awiyqä 5 klokiu ipäqäpqä iqua äpäpu, hŋqunä-hŋqunä mbqä huätäkŋqä mapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Itaŋga ämaqä wäuŋuä qu-ganä ipäqäpqä iqua äpäpu, ‘Ne mbqä kuapänä meŋqunä’ kŋuä indqäŋgaŋgpqä-qe, oeyqä. Iqua-pqe hŋqunä-hŋqunä mbqä huätäkŋqä hŋqunä mapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Qu quwqä mbqä ämepiyä du hiŋuä äqumbiyi, wäuŋuä kaniqueŋi äkasuwä tiiŋä tupŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ämaqä qänaki ätimäuquwä iqua, wäuŋui wäŋqäpu qäyä iquwä-qe, si mbqe ne änätapŋä-paŋi, iquau-pqe asänä äwinyä. Ne wäuŋuä tnäŋä iqa pätqätaŋgu, mäptqä-pqä natätŋqe, täŋga täsuwänä.’ ");
INSERT INTO mcr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wäuŋuä kaniqu qätä iiŋä äwiyäqe, ämaqä iquautaŋä hŋqueŋi tiiŋä tuäŋqiyä. ‘Näueqä iqukiyä. Nyi siŋi, quvqä miktqueqä iqänä. Täŋga ziŋuitäŋi, ye mbqä huätäkŋqeŋqä “äŋguiqä” ätquee. Qäyutanä? ");
INSERT INTO mcr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Si tqä mbqe ämetnä, uvä. Ŋqä änyiŋqä dutanä, ämaqä yäpakä äpätqä iqueŋi mbqä asiqunä wimqänä. ");
INSERT INTO mcr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","I nätmatqä tqä ma, ŋqeqä. Nyaqä mbqe iwäsäuqaŋgaŋi, ŋqä änyiŋqä iuŋi, pmua tqu nyimäkätŋqäwä? Aaŋqeqä. Nyi ämaqä tquauŋi suqä äŋguä di iwimäkqaŋgqeŋqe, si äkasuwä suŋqä kmŋgiyä?’ tuäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Itaŋi Jisasi Iqu tii ätukqe. “Kukŋuä ktqä ämänätqueqä-pa, asä iiŋi, ämaqä täŋga yäpakä äpmeŋuwä iqua, hiŋuiqä pmapnuwiqä. Itaŋga ämaqä täŋga hiŋuiqä äpmeŋuwä iqua, qänaki pmapnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisasi Iqu Jerusälemäŋqä qaŋä äwätäqäŋgaŋi, Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä 12 iquaunä ämitmetä, qeiqi tiiŋä ätqäumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Qätä nyipiyä. Täŋgaŋi ne Jerusälemäŋqä äyätanä, äyä ätqeyqunä. Yäŋiŋi, Ämaqeuqä Ymeqä Ekqä Iqueŋi, qu hiqäva-imäkqä naqä iquauqätä, kukŋuä-suqeŋqä näqŋqä iquauqätä, hipa iunä wipŋqäuä. Itaŋga iqua Iqueŋi, kukŋuä ämitäpu, ‘Iqu äpäkonätŋqeqä’ tpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iŋgaŋi qu Iqueŋi, ämaqä Israitqä iqua qäyä etaŋgi huizi iquau-mända wipŋqäuä. Ämaqä iiŋä iqua, Iqueŋi ewiiqä kukŋuä ämitäpu, täuatätäu ipu, itaŋga zä-huätati äuepŋqäuä. Itaŋi hiunji hŋquaqui-hŋqueŋä iuŋi, Goti Hanjuwä Iqu Ique aŋgumä ävauqumuatäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Qänakŋi Sepri iqueqä ymeqä iŋgueqiyqä känai, Jemisi iquesä Jonä iquesä ätuma, Jisasi Ique äwimakuwi. Äwimapiyi, ii Iqu-täŋä iqi qoŋä äwoktäutä, “Nyi yatŋqä hŋqu kimqänänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Itaŋi Iqu iiŋi yatŋqe, “Si nätmatqä äkitaŋiŋqä kiŋgiyä?” ätukqe. Ii kimaŋi tii ätukqe. “Nyi Si ämaqä ämitŋäŋgaŋi, tii ttŋqeŋqä änyiŋgiyä. Ŋqä hikŋä tquaqu, hŋqu saqä hipa ämuaŋgisa pmeqaŋga, hŋquququ hipa qunamäuqäŋgisa pmeniŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iqu kima tiiŋä ätukqe. “Nätmatqä he yatŋqä änyiquwiŋqe, he änyä maqŋqä yqänä eŋäuä. Eqä-häkä Nyi nmqä änyäŋqe, qe-pqä inä nyiyŋqätanä?” Itaŋi iquaqu, “Ŋŋqä. Ye-pqä qäyu äneŋqueä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iqu iquaquiŋi tii ätukqe. “Qe naqä-qakuä ändqinyqä. Eqä-häkä Nyi nmqä änyäŋqe, qe nyiyŋqeqä. Iŋäqe Ŋqä hipa ämuaŋgisatä, qunamäuqäŋgisatä pmanyiyäŋqe, Nyi atäuŋuä miqä da imqänä. Nyaqä Apiqu ämaqä hŋquaqu atäuŋuä itä, zä-hawi ämaqä iquaquinyqä näwenyä ämaeqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wäuŋuäŋqä ämotquamiŋqä 10 iqua, iŋgueqi Ique tquaŋgiyiŋqä qätä äwipiyitaŋi, qu iquaqui himänä äwiyäpu, äwqä äkasuwä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iwä Jisasi Iqu iquau tääqä ätuätumeqe, tii ätukqe. “He näqŋqeqä. Ne Israitqä qäyä etaŋgi huizi iquau miqä iqua, yäŋänäqŋqetä, yoqä naqetä ämapu, quwqä ämaqeuŋi, äwiŋqä quwqä dunä qänaknä ipŋqä iwimäkätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Iŋäqe, hiyaqä awä iqiŋi, suqä tä mäwiqä itŋqeqä. Oeyqä. Ämaqä hŋqu, hiyaqä awä iqisaŋi hiqä ämeyätŋqä wiŋgaŋgutqe, iqu heqä wäuŋuä-eyqä-qu pmetŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Auä, ämaqä hŋqu, hiqä naqä pmetŋqä wiŋgaŋgutqe, iqu hiyaqä wäuŋuä-eyqä hiŋgäŋqä-qu pmetŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ämaqeuqä Ymeqä Ekqä Iqu suqä iiŋi asä inä imäkqiyä. Iqu äpkqe, ämaqe Ique wäuŋuä yätamäkqä wipŋqä äpkqä manä, oeyqä. Iqu äpkqe, iquau wäuŋuä yätamäkqä ävätä, Iqueqä häŋä-pmeqe ävätä, qokä-apäkä kuapänäŋä iquau aŋgu mbqä imetŋqä äpkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iqua aŋä-himqä Jeriko ävämeqaŋguwäŋga, qokä-apäkä kuapänäŋi Ique qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iŋgaŋi ämaqä hiŋuä pisqä, hänaqä maŋä iqi äpmeqäsmiŋiyä hŋquaqu, “Jisasi Iqu qaŋä äpqiyä” tqaŋgä äwiyitaŋi, tääqä yäŋänäqŋqä tiiŋä ätukiyi. “Naqä Iqukiyä. Dewiti iqueqä Ymeqä Iquki, Si yenyqä qeqä äkimänänä.” ");
INSERT INTO mcr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Qokä-apäki, qu iquaqu tääqä tqaŋginyä qätä äwipiyi, maŋä matqä iyŋqä yäŋänäqŋqä ätukuwi. Iiŋä qäyä ätquaŋguwä-qe, iquaqu aaŋä tääqä yäŋänäqŋqä ätkiyi. “Naqä Iqukiyä. Dewiti iqueqä Ymeqä Iqukiyä. Si yenyqä qeqä äkimänänä.” ");
INSERT INTO mcr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisasi Iqu qaŋä äumiŋqe, tääqä tqaŋginyä äwiyäqe, Iqu iqi ätqäuwäqe, iquaqui tääqä ätuätumetä, tii ätukqe. “Qeŋi, äänä qemäkmqä qeŋgiyä?” ");
INSERT INTO mcr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Itaŋi iquaqu kimaŋi, tiiŋä ätukiyi. “Naqä Iqukiyä. Yeyaqä hiŋui äŋguä qäneŋqä yemäktŋqä äyeŋgiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","I tquaŋgiyäŋga, Iqu iquaquinyqä huäqä wuŋgaŋgi, iquaquiuä hiŋuä iuŋi, a qe ämikqe. Maqänäŋi, äŋguä imänyiyi, hiŋuä äqänäsinyä, Ique qänaki äwivändqa äukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Itaŋga iqua, Jerusälemä-täŋä qäqi timäupŋqä ipiyäŋgaŋi, qoqoŋä Olipä iŋgisa aŋä-himqä Betäpake iu ätimäukuwi. Iŋgaŋi Jisasi Iqu Iqueqä ämaqä hŋquaqui ändowatätä, tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Qe aŋä-himqä näŋgisaŋqä winyqä. Ique äpaquväsiyäŋgaŋi, qe doŋgi hŋqu, guä äkiqiyäuequwä, kiqä meqä iqutä anä pmetaŋginyä, qunyiyäŋqinyqä. Iiŋä äqunyiyi, gue iwasqiyäsinyä, Nyinyqä ätuma binyqä. ");
INSERT INTO mcr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ämaqä hŋqu kukŋuä hui qesqaŋgutqe, ga qe tiiŋä tquinyqä. ‘Naqä Iqu iquaqui wäuŋuä vätŋqeqä.’ Qe i tquaŋgisqe, maqänäŋi iqu hiŋuinä qeqänäwqatäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nätmatqä ii ätimäukqe, Goti Hanjuwä Iqueqä kukŋui, hiŋuä-tqä iqueqä maŋä iuta ätkqe, qäyunä imäkätŋqä ätimäukqe. Hiŋuä-tqä iqu kukŋui tiiŋä ätääŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kukŋuä tä, ämaqä Sayonä äpmeŋuwä iu awä tii tuvä. ‘Hiŋuä qumbiyä! Hiyaqä ämeyqä naqä iqu, emetŋqä äpqiyä. Iqu ämaqä yoqä maeqä-qu eŋqä-pa, doŋgi haqeu pmeqä äyä äquvepqiyä. Iqu doŋgi iiyqä meqä iqueqä haqeu pmeqä äquvepqiyä.’” ");
INSERT INTO mcr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Itaŋga ämaqä wäuŋuä imäkqä iquaqu äwäsinyä, Jisasi Iqu ätukqä-pa iiŋä imäkkiyi. ");
INSERT INTO mcr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Iquaqu doŋgi känäutä meqä iquesä ätuma äpäsinyä, iquaquvqä gquä quäuqe, doŋgi iquaquiyqä haqeqi eqaŋgiyäŋga, Jisasi Iqu haqeu qe äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Itaŋi ämaqä kuapänäŋi quwqä gquä quäuqe, äquvätäpu, hänaqeu äqäqasäueqäkuwi. Ga ämaqä huiziqua zä-äpa ätäväpu, hänaqä iqi äqäqasäueqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Itaŋi qokä-apäkä Jisasi Ique hiŋuiqä äwimamiŋuwä iquatä, qänaki äwivändmiŋuwä iquatä, tääqä tii ätmiŋuwi. “Dewiti iqueqä Ymeqä Iqueqä yoqe, haqeqä ämamäunä. Naqä Iqueqä yoqeta äquvepätŋqä Iqueŋi, Goti Hanjuwä Iqu äŋguänäŋä iwimäkqiyä. Goti Haqä Yätu Äpmeŋqä Iqueqä yoqe, haqeqä ämamäunä.” ");
INSERT INTO mcr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisasi Iqu Jerusälemä yäpä iŋgisa peyqaŋga, ämaqä aŋä-himqä iutaŋä iqua, yäuŋuä ipiyi, yatŋqä hiŋginäwa, “Ämaqä Tqu, äsqukuä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Itaŋgaŋi qokä-apäkä Iqutä anä äpmamiŋuwi, kima tii qe ätukuwi. “Ii Jisasi Iqueqä. Iqu Hiŋuä-tqä aŋä-himqä Nasäretqä qua Galili iutaŋä Iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Itaŋga Jisasi Iqu hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa äpäyäqe, Iqu ämaqä mbqä wäuŋuä imäkätqätaŋguwä eeqänäŋi, huätä äpäsäwqatkqe. Itaŋga ämaqä mbqä huitaŋi tŋäŋqä imäkäpu vätqätaŋguwä iquauqä hevqetä, ämaqä yŋŋä-heeqe mbqä itqätaŋguwä iquauqä zä-hawitä ämäquvasqiyekqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iiŋä imäkäqe, tii ätukqe. “Goti Hanjuwä Iqueqä bukä iuŋi, tiiŋä äqänänä. ‘Nyaqä aŋiŋqe, qu “Aŋä tääqä dqä aŋiqä” tpnuwiqä. Iŋäqe, he ämaqä quwä-meqä iquauqä zä pmeqä aŋä eŋqä-paŋä imäkätqäŋäuä.’” ");
INSERT INTO mcr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iqu hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa yqänä äpme, ämaqä hiŋuä pisqä iquatä, itaŋga yukä quvqä iquatä, Ique wimeqaŋguwä iquauŋi, äŋguä qe imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Itaŋgi hiqäva-imäkqä naqä iquatä, ämaqä kukŋuä-suqeŋqä näqŋqä iquatä, Iqu nätmatqä ämaqä mimäkqänäŋi imäkqaŋgi äqumbiyi, itaŋga ymeqe, hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa äpmapu, “Dewiti iqueqä Ymeqä Iqueqä yoqe, haqeqä ämamäunä” ätäpu, tääqä tqaŋgä äwipiyi, äwqä quvqä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Itaŋi qu Jisasi Iqueŋi, yatŋqä tiiŋä qe äwikuwi. “Tääqä tä tqaŋguwi, Si qätenä äwiyätnä, hiŋuinä äqunäŋnä?” Kimaŋi Iqu tii ätukqe. “Auä, itaŋgi änääŋäŋqäwä? He kukŋuä Dewiti iqu Goti Ique ätukqä tä, a matäuqä itqäŋuwäta? Si ymeqä wäŋqänäŋä isua, Tqä yoqe haqeqä makmäupŋqä ämotquetqäŋiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Itaŋga Iqu iquau ävämeqe, aŋä-himqä naqä iuŋi, yäpaqä mäŋgisa äwäqe, aŋä-himqä Betani ätimäutä, heatqä iqueŋi iqi äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aaŋä ziŋuä matqäŋgaŋi, Jisasi Iqu aŋä-himqä naqä iuŋqä aŋgumä äwätäqäŋgaŋi, buayäŋqä dä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iqu zä-eaqä hŋqu, hänaqä maŋä iqi tqäutaŋgi äqunäqe, qäqiqi äwäqe, kiqä häukuä näŋqe aaŋqä, quwqenä nyätaŋgi äquŋgqe. Itaŋi Iqu zä-eaqä iqueŋi, tiiŋä qe ätukqe. “Si häukui aŋgumä maqiyqä isŋqinyä.” I tquaŋgqetaŋi, zä-eaqä iqu maqänä yäuä qe äpäkqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, hiŋuä iiŋä äqumbiyi, yäuŋuä ipu, “Änääŋäŋqäwä? Zä-eaqä iqu yäuä maqänäŋi, äänä itä piqiyä?” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iqu kimaŋi, tii ätukqe. “Nyi heŋi naqä-qakuänä etqänä. He kŋui, ‘Ŋqä änyiŋqe ätimäuŋqutiyä, matimäuqä yäŋqutiyä-qe?’ kŋuä hŋquaqu mindqäŋqä ipu, quuvqe yäŋänäqŋqä heqäpqe, he zä-eaqä tqueŋi, Nyi imäkqä-pa asä iiŋä imäkpŋqäuä. Itaŋga he imäkpŋqe, iquenyä ma. He qoqoŋä tqueŋä-pqe, ‘Goti Iqu si äkiyautä, eqä-huäŋä bu äktnämäunä’ ätupqe, ii ätimäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Asä iiŋi, he quuvqä eqiyäpu tääqä tupqe, nätmatqä eeqänäŋä he yatŋqä äwipqä iuŋi, ämapŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisasi Iqu hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa äpäyätä, ämaqeu ämotquetqätaŋga, hiqäva-imäkqä naqä iquatä, Israitqeu miqä iquatä Ique äwimepu, yatŋqä tiiŋä äwikuwi. “Wäuŋuä tä imäkätqäŋiŋqe, yoqä naqä äŋgisa ämeŋäwä? ‘Si ii imäktŋqe’ tqu ktkqäwä?” ");
INSERT INTO mcr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iqu kimaŋi tii ätukqe. “Nyi-pqe nätmatqä hŋquenyqe, yatŋqä inä heyqaŋgmdi, ga he kima qäyunä ändquwi, Nyi wäuŋuä tä imäkmqä yoqä ändapkqä Iqueŋqe, etmqänä. ");
INSERT INTO mcr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jonä asŋä-qäyqä iqu wäuŋuä imäkmiŋqe, äŋgisa ämetä imäkkqäwä? Iqu yäŋänäqŋqe, qäukuä haqä yätuta ämakqätanä, ä ämaqä iquauta ämakqätanä?” ätukqe. I tquaŋga, iquauqä-quwä kukŋuä tiiŋä qe ätŋguwi. “Ne kimaŋi, ‘Qäukuä haqä yätutaŋiqä’ tquaŋguatqe, Iqu tiiŋä natäŋqiyä. ‘He iquenyqä quuvqä maeqiyqe, suŋqä itqäŋuwäwä?’ ");
INSERT INTO mcr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iŋäqe, ne kimaŋi, ‘Ämaqä iquautaŋiqä’ ätuatque, änääŋqätiyä? Ämaqe, ‘Jonä iqu hiŋuä-tqä iqueqä’ kŋuä indqänätqäŋuwiŋqe, iquauŋqe ne zä äneŋgiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","E ätmbiyitaŋi, Jisasi Iqueŋi, “Ne maqŋqeqä” ätukuwi. Ga Iqu kimaŋi, “Nyi-pqe inänjqä. Nyi yoqä naqä-täŋä eämä, wäuŋuä e imäkätŋqeŋqe, he awä maetqä ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Itaŋga he kŋui äänä heyqiyä? Ämaqä hikŋä hŋquaqu-täŋä hŋqu, iqueqä ymeqä hitmqä ique äwimeqe, tuäŋqiyä. ‘Ymeqä iquki, täŋgaŋi si äwätnä wainqä wäuŋui iyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Itaŋi ymeqä iqu, ‘Nyi enyqä änyiŋgiyä’ ätuäqe, qänakndaŋi iqu tŋäŋqä imäkäqe, äwäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Itaŋga kaniqu iqueqä ymeqä käŋgueque-pqä inä äwimeqe, kukŋuä asä iqunä tuäŋqiyä. Ymeqä iqu, ‘Apä, nyi imäkmqänä’ ätuäqe, mäwqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Iŋi kaniqueqä äwiŋqä iu qänaknä itŋqe, ymeqä iquaquisaŋi, äsqutiyä?” Kimaŋi hiqäva-imäkqä naqä iquatä, Israitqeu miqä iquatä, “Hitmqä iqueqä” ätukuwi. Itaŋi Iqu tii ätukqe. “Nyi naqä-qakuä etqänä. Jonä iqu he emetä, suqä jänäŋi qäyä ämetqueqaŋgi, he iquenyqe quuvqä maeqiyqä äyä imiŋuwiqä. Itaŋgi ämaqä mbqä motauqä iquatä, apäkä qaŋä hiŋginäwa ikiqä iuatäŋi, qu iquenyqä quuvqä eqämiŋuwiqä. He iuŋi hiŋuä qäyä äqunäpiyä-qe, kŋuä indqäŋqe tŋäŋqä mimäkqä ipu, iquenyqä quuvqä maeqiyqä imiŋuwiqä. Iiŋiŋqe, ämaqä mbqä motauqä iquatä, itaŋga apäkä qaŋä hiŋginäwa ikiqä iuatäŋi, Goti Hanjuwä Iqunä ämitŋqä iuŋqe, qu-ganä hiŋuiqä hemapŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“He kukŋuä ktqä huizi tqu qätä nyipiyä. Ämaqä hŋqu guä-wainqä vowä ikqäwäqe, täkŋä äqäyäqe, kiqä häukui qonjqä itä, eqä päquveqätŋqä hikä huä ätäkätä iquqonmäuqe, ämaqä wäuŋuiuŋqä hiŋuä äqumbu pmeqä aŋä quäuqä ämätäqe, itaŋga wäuŋui, ämaqä mbqä meqä imäkpŋqä hŋquauqä hipa iu äwimä, aŋä kiŋä nämqä wäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Itaŋgaŋi guä-wainqä häukuä näŋqe äyä qäyqaŋgaŋi, iqu iqueqä wäuŋuä-wiyqä hiŋgiŋqä hŋquau, ämaqä wäuŋuä ämimitpqä iquauŋqä, häukui iqueqe mapŋqä dowatäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Itaŋgi iquauŋi, ämaqä wäuŋuä ämimitpqä iqua, a äkiqätäpu, hŋque häptqä äpäsäpu, huiziqueŋi pizqä hämänä äpäsäpu, itaŋga huiziqueŋi hikä päkpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aŋgiŋi kaniqu wäuŋuä-wiyqä kuapänäŋä hui inä dowatäŋqiyä. Iŋäqe ämaqä wäuŋuä ämimitpqä iqua, iquauŋä-pqe suqä asä iqunä iwimäkpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Qänakŋi iqu, ‘Qu nyaqä ymeqä iqueŋi qätä wipŋqäuä’ ätätä, iqueŋi iquauŋqä dowatäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Iŋäqe, ämaqä wäuŋuä ämimitpqä iqua, hikŋuqu äpqaŋgi äqumbiyi, tii tmbŋqäuä. ‘Wäuŋuä kaniqueqä hikŋuqu äpqiyä. Kaniqu äpäkoŋgaŋgaŋi, kanmä nätmatqä eeqänäŋi, iqu ämeniqeqä. Iiŋiŋqe ne ique pizqä äpäsätanä, wäuŋui neqä metuŋqueqä’ tmbŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Iiŋä ätmbiyi, qu ique a äkiqätäpu, wäuŋuä yäpaqä mäŋgisa ätnämäupu, pizqä päkpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Itaŋgaŋi he kŋui äänä heyqiyä? Qänakndaŋi wäuŋuä kaniqu äpäqe, wäuŋuä ämimitpqä iquauŋi suqä äänä iwimäkäŋqutiyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ga hiqäva-imäkqä naqä iquatä, Israitqeu miqä iquatä, Ique kima tii ätukuwi. “Iqu ämaqä quvqä tquauŋi, qui wimäkäŋqiyä. Itaŋga wäuŋui, iqu ämaqä hŋquau-mända muayäŋqiyä. Ämaqä ymisaŋä meqäŋgaŋi, ymisaŋä aquvä äqämipqe, ique-pqe wipnuwäŋqä iquau, muayäŋqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iŋi, Iqu yatŋqä tii äwikqe. “Goti Hanjuwä Iqueqä bukä iu äqänäŋqe, he a matäuqä itqäŋuwätanä? Kukŋuä tä, tiinjqä. Hikä-aŋä-mätqä iqua, hiki quvqä wäuŋuä maeqä hiŋuinä äquŋguwi, hikä iiŋä iqu, aŋä quea eŋqä-paŋä, aŋä yäŋänäqŋqä imäkqä-queqä. Nätmatqä tä ätimäuqe, Naqä Iqu Iqueqä-kiuä imäkqiyä. Itaŋi ne hiŋuä äqunani, ‘Äi, aaŋä äŋguänäŋiqä’ äyä ätqunä. ");
INSERT INTO mcr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iiŋä etaŋgi, Nyi he etqänä. Goti Hanjuwä Iqunä miqä yäpä iŋgisaŋqä uwqäŋqe, hiyaqä hipa iutaŋi huätä ämetautä, ämaqä hŋquau-mända muayäŋqiyä. Qu Iqueqä ämiqä iu äpmapu, kiqä häukui imäkpŋqä iquau muayäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Itaŋga ämaqä, Hikä Tqueqä haqeqi äpäknätqe, iqu qui imäknäŋqiyä. Ga Hikä Tqu haqä yätqä äwämitätqe, ämaqä hŋqueqä haqeqi äpäknätqe, iqueŋi guipäyäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","I tquaŋga, hiqäva-imäkqä naqä iquatä, Parisi iquatä, qu Jisasi Iqueä kukŋui qätä äwipiyi, Iqueä kukŋuä ktqe, iquauqä-quwäŋqä äyä äwqaŋgi näqŋqä ekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Qu näqŋqä iiŋä epiyi, a kiqätanä-tpu ipiyä-qe, ämaqä huizi iqua, “Jisasi Iqu hiŋuä-tqä hŋqueqä” kŋuä indqäŋgaŋguwiŋqä, zä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Asä qäŋgaŋi, Jisasi Iqu kukŋuä ktqä huiziqu, ämaqä naqä iquauŋi tiiŋä qe ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Goti Qäukuä Yätutaŋä Iqunä miqe, ämiqä naqä hŋqu imäktqä eŋqä-paŋiqä. Iqueqä ymeqä qokä iqu apäkä metŋqäŋgaŋi, ämaqä ämiqä iqu, ymisaŋä naqänäŋä imäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kiŋganäŋi iqu ämaqä hŋquauŋi, ‘Nyi ymisaŋä naqänäŋä imäkmqäŋgaŋi, he nyitä ymisaŋä anä natuŋquä ppnuwäŋqeqä’ tuäŋqiyä. Itaŋga hiunji ymisaŋä-ŋqä iqueŋi, iqu iqueqä wäuŋuä-wiyqä iquauŋi, tääqä tuätumapŋqä dowatqaŋga, qu äpqeŋqe, enyqä winyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Itaŋi iqu wäuŋuä imäkqä huiziquau-mända ändowatätä tii tuäŋqiyä. ‘He ämaqä nyi tääqä ätukqä iquauŋqä äwäpu, nyaqä kukŋui, tii jipiyä. “Qätä nyipiyä. Nyi ymisaŋi näwe ae imäkeqeqä. Bulumäka qokä iquautä, naŋuä äŋguänäŋitä äpäsätanä, nätmatqä eeqänäŋi näwenyä ae imäkequä äwinä. He ämaŋqä ymisaŋä täuŋqe, ppiyä” tupŋqä äupiyä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ämaqä wäuŋuä imäkqä iqua äupiyi, kukŋuä tä iquau tquaŋguwäŋga, ämaqä iqua qätä mäwiyqä ipu, hiŋginäwa wepŋqäuä. Hŋqu iqueqä wäuŋguwä-aŋguwiuŋqä wäŋqiyä. Hŋqu iqueqä mbqä wäuŋuä yätŋqä wäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ga huiziqua, wäuŋuä imäkqä iquau a äkiqätäpu, ämuamuapqä ämipu, pizqä päkpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iutaŋi, ämaqä ämiqä iqu, äwqä tnäŋä wiŋgaŋguti, iqueqä ämaqä mäkä-iqä iquau, ämaqä pizqä päsqä iquauŋqä dowatäŋqiyä. Qu äwäpu, iquau pizqä äpäsäpu, iquauqä aŋä-himqe tä qäyäväpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Iŋgaŋi ämiqä iqu, iqueqä wäuŋuä-wiyqä iquauŋi tuäŋqiyä. ‘Ämaŋqä ymisaŋi näwenyä witaŋgqä-qe, ämaqä nyi tääqä kiŋganä ätquäqä iqua, buayä täŋqä ppŋqe, äŋguä-qua manä. ");
INSERT INTO mcr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iiŋä etaŋgi, he hänaqä maŋä eeqänäŋä iuŋqä äwäpu, ämaqä iqi pmetaŋgä äqunäŋuwä iquau, ämaŋqä ymisaŋä tä bŋqä tääqä tuätumapiyä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ga iqua hänaqä eeqänäŋä im-imä äwäpu, qokä-apäkä quvqä iquautä, äŋguä iquautä äwindäpqä iquauŋi, aquvä maqäpŋqäuä. Itaŋi qu äpäpu, ämaŋqä ymisaŋä täu äpmepiyäŋgaŋi, aŋä iuŋi täptembŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Iŋäqe ämiqä iqu, yäpä iŋgisa iquau hiŋuä qunätŋqä äpäyäqe, ämaqä hŋqu ämaŋqä gque mipnätaŋgi qunäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iiŋä äqunäqe, iqueŋi, ‘Näueqä iqukiyä’ tuäŋqiyä. ‘Si ämaŋqä gque, mipŋga mäyapqä iŋi, äänä etaŋgikä?’ Iqu kimaŋi matqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Itaŋi ämiqä iqu iqueqä wäuŋuä imäkqä iquauŋi, tiiŋä tuäŋqiyä. ‘He iqueqä yukä hipa iuŋi hatŋä äququätäupu, hiawiqä imä pmetŋqä yäpaqä mäŋgisa tnämäupiyä. Aŋä hiawiqe, ii kŋuä äqiyäpu hiquaŋä maŋgtäsqukuä ämäutqäŋuwä ivqä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ii tiiŋä etaŋgiyqä. Goti Hanjuwä Iqu ämaqä kuapänäŋä iquauŋi, tääqä ätuätŋqeqä. Itaŋgi yäpä iŋgisa upŋqä iiŋqe, Iqu hŋqunä-hŋqunäŋi atäuŋuä itŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iŋgaŋi Parisi iqua äupiyi, “Jisasi Iqueŋi, kukŋuä äänä mitaniquäwä?” ätnäpu, kŋuä yaŋä änyäpu, iqueä kukŋuä quvqä hui tqaŋgutqe, äkäpŋqä kukŋuä guä ämäsäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Qu iquauqä wäuŋuäŋqä ämotquamiŋuwä hŋquautä, ämiqä naqä Heroti iqueŋqä äwinyämiŋqä hŋquautä Jisasi Ique tii tupŋqä ändowatkuwi. “Ämotqueqä Iquki, ne näqŋqä eäŋunä. Si kukŋuä naqä-qakuä Tqukiyqä. Itaŋga Goti Hanjuwä Iqueqä suqeŋqe, Si qokä-apäkä iquau naqä-qakuä ämotquetqäŋä qäyuŋä-qe, Si ämaqä hŋquenyqä zä miqä itnä, yoqä-täŋä iquautä, yoqä maeqä iquautäŋi, kukŋuä asänäŋi ätuätqäŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iŋi ne Romätaŋä ämiqä naqä Sisa ique mbqä takisi ävätuŋque, ii äŋguätiyä, quvqätiyä? Si kŋuä äänä äkiyäŋqe, ne natiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Itaŋgi Iqu iquauqä kŋuä indqäŋqä quvqä iuŋqe näqŋqä ae eätä, tiiŋä ätukqe. “He wopqä ipu, kukŋuinä tqä iquenä, suŋqä yamwiqä nyiyqäuä? ");
INSERT INTO mcr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","He mbqä takisi iunä ävätqäŋuwitaŋä hŋqu, Nyi mändquapiyä.” Iŋgaŋi qu mbqä hŋqu Iquenyqä äma äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Itaŋi Jisasi Iqu iquauŋi, “Ktqä itä, yoqä itä, ii tqueqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Qu “Sisa iqueqeqä” tquaŋguwäŋga, Iqu iquau tii ätukqe. “Iŋi, nätmatqä Sisa iqueqä etaŋgutqe, ii kaqäque wipŋqeqä. Ä nätmatqä Goti Hanjuwä Iqueqä etaŋgutqe, ii Goti Ique wipŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Qu kukŋuä tä qätä äwipiyi, eämepu, Iqueŋi äväma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hiunji iqueŋi Satyusi hŋqua, Jisasi Iquenyqä qe äpkuwi. Satyusi iqua, tii tqä-quae. “Ämaqä ae äpäkombqä iqua, aŋgumä mävauqä ipŋqäuä.” Itaŋi qu Jisasi Iqueŋi, yatŋqä tiiŋä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ämotqueqä Iquki, Mosisi iqu bukä iuŋi tiiŋä ätätä äqäkqe. ‘Ämaqä hŋqu apäkä ämetä, ymeqä maeqä äpäkonätqe, iquenyqä tŋäŋqe, käŋguequ apäqŋqe ämetä, ymeqä hemeŋqiyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hiŋuiqänäŋi, ämaqä 7 hŋguiqua, neyaqä awä iqi äpmamiŋuwiqä. Itaŋga iŋguiquautaŋi, kätequ apäkä ämeqetaŋi, äpäkoŋgqeqä. Iqu ymeqä meämeqäŋga äpäkoŋgaŋgi, apäqŋqä iiŋi, käŋguequ ämakqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Itaŋi käŋguequ-pqe, asä inä ikqeqä. Itaŋi käŋgua huiziqu-pqe, asä inyänä ikqeqä. Itaŋga inyänä-inyänä iqaŋi, käŋgua yäpakä iquenyqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Eeqäŋguiqua äpäkoŋgaŋguwäŋga, yäpaki, apäqŋqä ii inä äpäkoŋgqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Iŋi qänakndaŋi, ämaqä äpäkombqä iqua aŋgumä ävauqaŋguwäŋgaŋi, apäkä eeqäŋguiqua ämamiŋuwä ii, tqueqä heäniqäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kimaŋi Iqu tii ätukqe. “He Goti Iqueä bukä iu äqänäŋqeŋqätä, itaŋga Iqueä yäŋänäqŋqeŋqätä maqŋqä epu, kukŋuä iuŋqe qämä-qämä ipu ätqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Hea iŋgaŋi, ämaqä ae äpäkombqä iqua aŋgumä ävaupiyäŋgaŋi, qokä-apäkä mämaŋqä ipnuwiqä. Oeyä. Qu eŋätqä qäukuä yätuŋä iqua äpmeŋuwä-pa, iiŋä pmapnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Itaŋgi ämaqä äpäkombqä aŋgumä ävaupnuwäŋqe, Nyi yatŋqä hemqeqä. Kukŋuä Goti Hanjuwä Iqu etkqä bukä iu äqänäŋqe, he a matäuqä itqäŋuwätanä? ");
INSERT INTO mcr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nyi Aprähamä, Aisakä, ä Jekopä iquauqä, Goti Iqunjqä. Goti Iqu, ämaqä ae äpäkoŋguwä iquauqä manä. Ämaqä häŋä äpmeŋuwä iquauqä Goti Iqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Qokä-apäkä iqua i tqaŋgi äwipiyi, näqŋqä Iqu vqaŋgqeŋqä yäuŋuä kiiŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisi iqua, Jisasi Iqu Satyusi iquauŋi, qu kukŋuä matqä ipŋqä imäkqaŋgqeŋqä, qätä äwipiyi, iqua aquvä äqänäpu Iquenyqä äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iquautaŋä kukŋuä-suqeŋqä näqŋqä hŋqu, Jisasi Ique yamwiqä ävätä, yatŋqä tii äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ämotqueqä Iquki, kukŋuä-suqä naqänäŋä, huizi iquau ämäwqätäuŋqä iqu, äsqukuä?” ");
INSERT INTO mcr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Itaŋi Iqu kimaŋi tii ätukqe. “‘Goti Hanjuwä tqä Naqä Iqueŋi, si tqä äwqetä, qeqä-quuvqetä, kŋuä indqäŋqetä Ique äwinyätnä, Iquenyqänä kuapänä kiŋguätŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kukŋuä-suqä tqu, naqä kiŋganäŋä-qu eä, huizi iquau ämäwqätäunä. ");
INSERT INTO mcr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Itaŋga kukŋuä-suqä tqueqä tuwä iqiŋä iqu, asä tiiŋiqä. ‘Si tqä-täuŋqä äkinyätŋqä-paŋi, ämaqä si-täŋä iqi äpmeŋuwä iquauŋqä-pqe, inä kinyätŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosisi iqu ätätä äqäkqetä, hiŋuä-tqä iqua äqäkuwitäŋi, kukŋuä-suqä tquaqu, kiqä quatiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi iqua aquvä yqänä äqämbu pmetaŋguwäŋga, Jisasi Iqu iquau yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kraisi, Goti Hanjuwä Iqu Iqueqä ämaqä iquau ämitŋqä atauŋä ikqä Iquenyqe, he kŋui äänä hiyqiyä? Iqu tqueqä ymeqäwä?” Itaŋi qu Iqueŋi, “Dewiti iqueqä Ymeqä Iqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iiŋä tquaŋguwäŋga, Iqu iquauŋi tii ätukqe. “Iŋi änääŋäŋqäwä? Dŋä Äŋguä Iqu Dewiti ique kŋuä indqäŋqä vqaŋgi, ga iqu Kraisi Iqueŋi, ‘Ŋqä Naqä Iqueqä’ ätuätäqe, iŋi änääŋäŋqä äqäkqäwä? ");
INSERT INTO mcr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Naqä Hanjuwä Iqu, ŋqä Naqä Ique tii ätukqeqä, “Nyi Tqä himä-wiuŋqä iquauŋi, Saqä yäpä iqi pmuatekimniqäŋgaŋqe, Si Nyaqä hipa ämuaŋgisa pmatŋqinyä” ätkqeqä,’ ätätä äqäkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iŋi änääŋgä? Kraisi Iqueŋi, Dewiti iqu, ‘Ŋqä naqueä’ ätukqä-qe, ämaqe, iquenyqe, ‘Dewiti iqueqä ymeqeqä’ änääŋqä tätqäŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iqu e tquaŋga, qu kimaŋi änä mätquä ikuwi. Hiunji iquesaŋi, qu zä ipu, yatŋqä hui inä mävqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iŋgaŋi Jisasi Iqu qokä-apäkä iquautä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquautä, kukŋuä awä tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kukŋuä-suqeŋqä näqŋqä iquatä, Parisi iquatä yoqä naqä ämapu, suqä Mosisi iqu ätkqeŋqä näqŋqä äyä etapätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iiŋiŋqe, kukŋuä eeqänäŋi qu he hitqaŋgpqe, he qätä äwiyäpu qänaknä iqäpŋqeqä. Iŋäqe qu kukŋuinä kuapänä ätäpu, iquauqä-quwäŋi qänaknä miqä-qua etaŋgi, suqä qu imäkquwi, he qänaknä miqä iqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Quwqä suqe, ktqä tii eŋqä-paŋiqä. Nätmatqä hui aquvä äqiyäpu, qa eŋqä-ma maŋguä ämanyuäpu, ämaqä iquau haŋä-iqä ävätqäŋäuä. Iŋäqe iquauqä-quwäŋi, ämaqä haŋä-iqä metaŋguwä iquauŋi, yätamäkqä mävqä-quaiqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Suqä eeqänäŋä qu imäkätqäŋuwi, ii ämaqe qu hiŋuä äqumbu yoqä naqä wipŋqä iiyqä. Qu tääqä tpŋqä ipiyäŋgaŋi, wäpiqä-qatäwä, naqänäŋä imäkmbŋqäuä. Itaŋi qu Goti Iquenyqä qänaknä iqä iquaiqä motquapŋqä iiŋqe, quwqä gquä quäuqä maŋä iuŋi, ttiŋuä-täŋä quäuqe imäkmbŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ymisaŋä naqä imäkqäŋgaŋi, aŋä äŋguäqinyä pmapŋqä winyäŋqiyä. Aŋä aquväqŋqä iuŋä-pqe, zä-hawä äŋguänäŋä iqinyä pmapŋqä winyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ququawä aquväqŋqä iu pmetaŋguwäŋga, ämaqe iquauŋi, ‘hiunjiŋganjqä’ tupŋqätä, ‘Ämotqueqä naqä iqukiyä’ tupŋqätä, winyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Iŋäqe hiyaqä Ämetqueqä Naqe, Hŋqunänjqä. Ga he hiŋguiqueŋqä hiuänjqä. Iutaŋi, he hŋqunä-hŋqunäŋi, huiziqua, ‘Si ämotqueqä naqä iqukiyqä’ ktpŋqä iiŋqe, hiŋuinä mäquŋquä isŋqeqä. Oeyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Itaŋga hiqä Hiniqu Hŋqunä eä, qäukuä yätu äyä äpmenä. Iutaŋi, he ämaqä qua täutaŋä hŋque, ‘Apä-qä’ mätquä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ga heqä näqŋqä etapqe, Kiuänäŋä Hŋqunänjqä. Ii Kraisi, Goti Hanjuwä Iqu, Iqueqä ämaqeu ämitŋqä atäuŋuä ikqä Iquvqä. Iutaŋi he hŋqunä-hŋqunäŋi, huiziqua, ‘Näqŋqä nätapqä iqukiyqä’ ktpŋqä iiŋqe, hiŋuinä mäquŋquä isŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hesaŋä ämaequtäuŋqä iqu, hiqä wäuŋuä emäkiyqä pmeniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ämaqä hŋqu iqueqä yoqe haqeqä mamäŋgaŋgutqe, Goti Iqu iqueŋi mändi kittqiyäŋqiyä. Itaŋga ämaqä hŋqu iqueqä yoqe mändi äkittqäŋgqe, Goti Iqu iqueqä yoqe yäänä imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Kukŋuä-suqeŋqä näqŋqä iquendä, Parisi iquendäŋi, he wopqä ipu, kukŋuinä tqä-quenjqä. Haŋä-iqe, tiiŋiŋqä emeŋqiyä. Ämaqe, Goti Qäukuä Yätutaŋä Iqunä miqeuŋqä yäpä iŋgisa peyqeŋqe, he hoptäwä äyä ävätqäŋäuä. He hiqä-hiuäŋi yäpä iŋgisa mäyqä ipu, ämaqä yäpä iŋgisa yanä-tpu iqaŋguwä iquauŋi, hoptäwä äyä ävätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kukŋuä-suqeŋqä näqŋqä iquendä, Parisi iquendäŋi, he wopqä ipu, kukŋuinä tqä-quenjqä. Haŋä-iqe, tiiŋiŋqä emeŋqiyä. Ämaqä yäpaqäŋgisaŋä hŋqu, iqueqä kŋuä äkunmäknätä, Israitqä iqune Goti Hanjuwä Iqueqä yoqä haqeqä ämamäutuŋquä-pa mamäutŋqä iiŋqe, he eqä-huäŋä ätäutqutäŋqä iutä, qua hituŋuä äwitqutäŋqä iutä, qaŋä ikiquenjqä. He iiŋi äŋguänä imäkpiyä-qe, hŋqu kŋuä kunmäkŋgaŋgutqäŋgaŋi, he iqueqä suqä quvqe, hiqeuŋi ämäwqätäutŋqä iwimäkätqäŋäuä. Iŋi iqu-pqä tä maisquä iuŋqä wäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","He hiŋuä pisqä eäpu, huiziu hänaqä motquapŋqä itqäŋuwä-paŋuenji. He tiiŋä ätätqäŋuwitaŋi, haŋä-iqe emeŋqiyä. ‘Ämaqä hŋqu, “Iiŋä-iiŋä imäkmqänä” ätätäqäŋgaŋi, kukŋui naqä-qakuiqä tqe motquetŋqe, hiqäva-imäkqä aŋä iuŋqänä ätätqe, ii nätmatqä hiŋgiŋqeqä. Iŋäqe iqu golqä hiqäva-imäkqä aŋiu äwiŋqeŋqä ätätqe, iqu iiŋä ätätqä-pa imäkäŋqiyä’ ätätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","He hiŋuä pisqä qämä-qämä iqä-quenjqä. Golqä hiqäva-imäkqä aŋä iu äwiŋqä ii, hänaqä äkiutaŋgä, Goti Iqueqänä ätimäuqeuä? Ii, Iqueqä aŋä iutaŋiqä. Iutaŋi, Iqueqä hiŋuiqiŋi, nätmatqä kiŋganäŋi, äsqukä? Ii golqetanä, ä Iqueqä hiqäva-imäkqä aŋitanä? Ii Iqueqä hiqäva-imäkqä aŋiyqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ga he tiiŋä-pqä ätätqäŋäuä. ‘Ämaqä hŋqu “Iiŋä-iiŋä imäkmqänä” ätätäqäŋgaŋi, kukŋui naqä-qakuiqä tqe, ämotquetŋqe, hiqäva-qäyqä ttawiŋqänä ätätqe, ii nätmatqä hiŋgiŋqeqä. Iŋäqe, iqu naŋuä hiqäva-qäyqä ttawä haqeuŋiŋqä ätätqe, iqu iiŋä ätätqä-pa imäkäŋqiyä’ ätätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","He hiŋuä pisqä-quenjqä. Naŋuä hiqäva-imäkqäŋqä ii, hänaqä äkiutaŋgä, Goti Iqueqänä etŋqeuä? Ii Goti Hanjuwä Iquenyqä hiqäva-qäyqä ttawä iutanänjqä. Iutaŋi, Goti Iqueqä hiŋuiqiŋi, nätmatqä kiŋganäŋi äsqukä? Ii naŋuitanä, ä hiqäva-qäyqä ttawitanä? Ii ttawiyqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iiŋiŋqe, ämaqä, kukŋuä naqä-qakuiqä motquetŋqä, hiqäva-qäyqä ttawiŋqä ätätqä iqu, iqu hiqäva-qäyqä ttawiŋqätä, nätmatqä eeqänäŋä haqeqi äwiŋqä iŋqätä, ätqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Itaŋga ämaqä, kukŋuä naqä-qakuiqä motquetŋqä, hiqäva-imäkqä aŋiŋqä ätätqä iqu, iqu aŋä iqueŋqätä, Goti aŋä iu äpmeŋqä Iqueŋqätä ätqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Itaŋi ämaqä, kukŋuä naqä-qakuiqä motquetŋqä qäukuä yätuŋqä ätätqä iqu, iqu Goti Hanjuwä Iqueqä zä-hawiŋqätä, itaŋga Goti iu äpmeŋqä Iquenyqätä ätqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kukŋuä-suqeŋqä näqŋqä iquendä, Parisi iquendäŋi, he wopqä ipu, kukŋuinä tqä-quenjqä. Haŋä-iqe, tiiŋiŋqä emeŋqiyä. He kukŋuä-suqä hŋqueŋqä kŋuä indqänäpu, iwuneqätä, kuämiqätä, itaŋga andŋätä ämepu, iwäsäupu 10 imäkäpu, hŋqu Goti Hanjuwä Ique ävätqäŋuwiqä. I etaŋgi kukŋuä-suqä iutaŋä naqänäŋä, suqä wäŋqä iiŋä iqueŋi ämäwqätäuŋqä tiiŋä iquauŋi, he tuwä wiyquenjqä. Suqä ämaqä qäyunä itqueqetä, ämaqeuŋqä qeqä imäŋqetä, Goti Iquenyqä quuvqä hämänänä wiyqä itäŋi, he mimäkqä itqäŋuwiqä. Äŋguänäŋi, tiiŋiqä. Suqä he hiqä nätmatqä iwäsäupu, hŋqu Goti Ique vqe mävquatämäuqä ipu, suqä iquauŋä-pqe qänaknä iqaŋgpqe, ii äŋguä wäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","He ämaqä hiŋuä pisqä qäyä etaŋgi, huiziquau hänaqä motquapŋqä itqäŋuwä iquenä, he tiiŋä-quenjqä. Ämaqä hŋqu quinaŋuä meqä isua waŋä iu witaŋguti, hiŋuä äqunätä huätä ämatnämäutŋqä-qe, kametqä waŋä iu äwiŋqe, hiŋuä mäquŋquä, eqetä eeqänä äŋguneqäqä-paŋä-quenjqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kukŋuä-suqeŋqä näqŋqä iquendä, Parisi iquendäŋi, he wopqä ipu, kukŋuinä tqä-quenjqä. Haŋä-iqe, tiiŋiŋqä emeŋqiyä. Eqä-häkitä, hevqetä haqäŋgisaŋi asŋä äŋguänä äqiyäpiyä-qe, ymisaŋä wiqä iŋgisaŋi, suqä quwä meqetä, kŋuä hiqä-hiuäŋqänä indqäŋqetäŋi, maŋguä äyä imäkätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Si Parisi hiŋuä pisqä-qukiyqä. Kiŋganäŋi, si eqä-häkä yäpä iŋgisaŋi asŋä äŋguänä qäyqaŋgtqe, ga haqäŋgisaŋä-pqe asä iiŋä timäutŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kukŋuä-suqeŋqä näqŋqä iquendä, Parisi iquendäŋi, he wopqä ipu, kukŋuinä tqä-quenjqä. Haŋä-iqe, tiiŋiŋqä emeŋqiyä. He ämaqä qua äptepqä haqäŋgisaŋi, qätäqua äqiyequwä-paŋuenjqä. Qua äptepqä yäpaqä iŋgisaŋi, aaŋä äŋguänäŋä äqunätŋä-qe, yäpä iŋgisaŋi ämaqä pizqä iquauqä yäŋitä, nätmatqä kiyä mätqä eeqänäŋitä witaŋgi qundŋqinyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","He-pqe asä iiŋä-quenjqä. Ämaqä iqua, hiyaqä huiwi hiŋuä eqänäpiyi, qu he ämaqä jänäŋuayqä kŋuä indqänätqätaŋguwä-qe, hiqä yäpä iŋgisaŋi suqä wopqä ipu kukŋuinä tqetä, suqä hŋgisa mamäuqetäŋi, kuapänä emnänä. ");
INSERT INTO mcr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kukŋuä-suqeŋqä näqŋqä iquendä, Parisi iquendäŋi, he wopqä ipu, kukŋuinä tqä-quenjqä. Haŋä-iqe, tiiŋiŋqä emeŋqiyä. He hiŋuä-tqä qäŋganä äpäkoŋguwä iquauqä yäŋä qua äptekuwiu änyä-häŋä imäkäpu, itaŋga ämaqä jänänäŋä iqua qua äptekuwä iuŋi ätnäŋä imäkäpu äŋguänä imäkquenjqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","He iiŋä imäkäpu tiiŋä ätätqäŋäuä. ‘Ne atqä-awäkatä anä pmeqä-säpi, qu hiŋuä-tqä iquau pizqä päkpŋqe, yätamäkqä mävqä iquaniŋgä’ ätätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kukŋuä iiŋä ätätqäŋuwi, hiqä-hiuä tiiŋä äyä ämänätqueqäuä. He hiŋuä-tqä iquau pizqä äpäkkuwä iutaŋä ymeqä hueqä-himqä iquenjqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","I etaŋgi hiqä tawäka suqä quvqä imäkqätaŋuenjqae, he-pqe imäkqa qae upiyä. ");
INSERT INTO mcr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","He qämakä quvqä iqua eämakuwänäŋä iquenjqä. Goti Hanjuwä Iqu kukŋuä ämetätqäŋgaŋi, he äänä mäwqätäupnuwäŋqäwä? Oeyä! He tä maisquä iuŋqä upnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iiŋiŋqe, he qätä nyipiyä. Nyi hiŋuä-tqä hŋquautä, ämaqä kŋuä äŋguä-täŋä hŋquautä, itaŋga ämaqä kukŋuä-suqeŋqä näqŋqä hŋquautäŋi, henyŋqä dowatmqänä. Itaŋgi he hŋquauŋi pizqä äpäsäpu, zä-huätatä huepnuwiqä. Itaŋga hŋquauŋi aŋä aquväqŋqä iuŋi täuatätäu ipu, aŋä-himqä hŋqueŋqä päsäwatpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iiŋä etaŋgi qu ämaqä jänäŋä iquauŋi, qua täu pizqä äpäkka äpmiŋuwä iquauqä suqä quvqe, he kima eeqänäŋi ämapŋqäuä. Epo iquesa äpäsipäqäkaŋi, yäpaki Beläkiya iqueqä hikŋä Sakätiyasi ique äpäsätqutukuwiqä. He Sakätiyasi ique äpäkkuwi, hiqäva-imäkqä aŋä iuŋi, hiqäva-imäkqä ttawä iutä, hiqŋqä Goti Hanjuwä Iqunä pmeqä iutä, awä iqi äpäkkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nyi heŋi naqä-qakuä etqänä. Suqä quvqä eeqänäŋä iiŋqe, kiqä kimaŋi haŋä-iqe, qokä-apäkä täŋga äpmeŋuwi ämapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusälemä iquenyä, Goti Hanjuwä Iqu Iqueqä hiŋuä-tqä henyŋqä dowatqaŋgqä iquauŋi, hikä pizqä päsquenjqä. Hea kuapänäŋä iuŋi, Nyi heyaqä ymeqä iquauŋi, kukutakisqä kiqä meqä itmetä hikuwä yäpä iqi ämäqumuatetŋqä-pa, naqä hmbinyä i mäqumuatemätmä iqa äpätŋqeqä. Iiŋä etaŋgqä-qe, he iiŋqe maeŋqä enä. ");
INSERT INTO mcr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Qätä nyipiyä. Goti Hanjuwä Iqu heyaqä aŋi ae ävämeqaŋga, aaŋqä hiäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Itaŋga Nyi he tiiŋä etqänä. Täŋgata tiiŋi, he hiŋuä maŋqäŋqä ipŋqäuä. Qänakndaŋi he kukŋui, ‘Ämaqä, Goti Naqä Iqueqä kukŋuä awä tuätŋqä pätqätaŋgqä Iqueŋi, Goti Iqu äŋgui iwimäkäŋqiyä’ ätpqäŋgaŋi, he aŋgi hiŋuä ŋqämbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisasi Iqu hiqäva-imäkqä aŋi ävämetqätaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, hiqäva-imäkqä aŋä iqi mätnätaŋgqä iquauŋqä tupŋqä äwimakuwi. ");
INSERT INTO mcr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iqu iquauŋi, kima tiiŋä ätukqe. “He aŋä eeqänäŋä iquauŋi, hiŋuä qumbiyä! Iqua äŋguänäŋä-qe, Nyi naqä-qakuänä etqänä. Qänakndaŋi hikä hŋqu huizi iqueuä haqä yäŋi mäwiqä yäniqeqä. Qu eeqänäŋi ämisqiyäpu, qua mäŋi tnämäupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iqu qoqoŋä Olipäŋqä äwätä pmetaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquanä Iquenyqä äpäpu, yatŋqä tiiŋä qe äwikuwi. “Nätmatqä Si ne änatŋi, hea äkŋga timäuniqä iiŋqe, awä natiyä. Si aŋgumä quveptŋiŋqätä, qua tä qäpu hiäniqŋqätäŋi, ‘Täŋga timäuŋqiyä’ kŋuä neyätŋqä iiŋqe, ne hiqŋqä äkisque qunaniŋquäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yatŋqä e vqaŋguwäŋga, Iqu iquauŋi, “He yasämä mimbiyä, qu quaŋgä etäpu, hiqä kŋuä indqäŋqe, qui emäkqäpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Ii tiiŋiŋqä etqänä. Ämaqä kuapänä hŋqunä-hŋqunä ätimäuqisäpu, Ŋqä yoqe ätäqisäpu, ‘Kraisi ämaqä he ämeyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqe, nyi qäqunjqä’ ätäpu, ämaqä kuapänäŋä iuqä kŋuä indqäŋqe, qui iwimäkäqisqäpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Itaŋga he ämaqe mäkä naqänäŋä päuŋgeyqaŋguwi qätä äwiyäpu, ‘Ämaqä kiŋä daŋä hui mäkä äunätqäŋäuä’ tqaŋgä qätä äwiyäpiyäŋgaŋi, he zä ipu, yäuŋuä-yäuŋuä miqä pa iqäpŋqä. Nätmatqä iiŋi ätimäutäqä-qe, hiunji yäpaki änänjqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ämaqä huitaŋä iqua, hueqä-himqä huitaŋä iquatäŋi mäkä vauqumuatpnuwiqä. Ämaqä miqä hŋqueqä mäkä-iqä iqua, huiziqueqä iquatäŋi mäkä humbnuwiqä. Hŋqäqiŋi buayä dä naqänäŋä timäuniqeqä. Itaŋga hŋqäqiŋi qua ekä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Apäkä iua ymeqä änä ämipŋqä täŋä-huŋqä ämetqäŋuwä-paŋi, nätmatqä iiŋä iqua ganä timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hea iŋgaŋi, qu heŋi etmepu, huizi iquauqä hipa iu haŋä-iqä mapŋqä hiwipnuwiqä. Hesaŋä hui, qu pizqä hipäkipnuwiqä. Itaŋga he Nyinyqä quuvqä heqiyätqätaŋguwitaŋi, ämaqä eeqänäŋi, qu henyqä äwqä quvqä wiŋguäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hea iŋgaŋi, qokä-apäkä Nyinyqä quuvqä eqämipqä kuapänäŋi, quwqä quuvqä heqiyqe qui imäknäpu, quwqä-quwäŋqä äwqä quvqä wiŋgaŋguti, qutaŋä hŋquauŋi, mäkä-huŋqä iquauqä hipa iu wipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Itaŋga hiŋuä-tqä kuapänäŋi, qu quaŋgä ätuäpu, ämaqä kuapänäŋä iuqä kŋuä indqäŋqe, qui wimäkpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kukŋuä-suqeu yäpä imä mäpmeqä ii, naqänäŋä ätimäutä, ämaqä kuapänäŋi suqä ämaqeuŋqä wiŋqe ävquatämäupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iŋäqe ämaqä hiunji yäpakäŋgaŋqä Nyinyqä quuvqä yäŋänäqŋqä eqiyäpu äpmamitpqä iquauŋi, Goti Hanjuwä Iqu häŋä iqumuatäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Itaŋi Goti Hanjuwä Iqunä ämitŋqä iuŋqä kukŋuä äŋguänäŋi, qu qua äwitqutäŋqä-pa, awä tuäkiqäpnuwiqä. Ämaqä eeqänäŋiu tquaŋgä qätä ae äwiyqaŋguwäŋgaŋi, hiunji yäpaki, iŋga timäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Iŋi, tiinjqä. Hiŋuä-tqä Deniyäli iqu hiŋuiqänä nätmatqä qui imäkqä quvqänäŋä iquenyqä ätätä äqäkqe, nätmatqä iiŋä iqu Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋä iu pämä tqäutaŋgi qumbnuwiqä. (Ämaqä, hiŋuä-tqä iqu äqäkqä iu a ätäutqä iqu, kŋuä äŋguänä mequäŋqä.) ");
INSERT INTO mcr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","E äqumbiyäŋgaŋi, ämaqä qua Jutiya pmeqe, qoqoŋä iuŋqä zä maqänä uwqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ämaqä aŋä atääqä hevqä iu äpmamitätqä iqu, qua mäŋi ikuapmäutäqäŋgaŋi, iqu iqueqä nätmatqä aŋä yäpä iŋgisa witaŋgutqeŋqä kŋuä mindqäŋqä itä, hämänänä zä wäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ämaqä, iqueqä wäuŋuä iu äpmamitätqä iqu, iqueqä gquä quäuqä metŋqä aŋgumä mäwqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Itaŋga, apäkä äwqä-täŋä iuauŋqätä, ymeqä aŋuäŋqä-täŋä iuauŋqätäŋi, zä maqänä mäwqä iqaŋgpqeŋqe, huäqä kiiŋä huŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ga hiqä zä maqänä uwqe, yuŋuäŋgatä, Sämbatqä hiunji hapä pmeqäŋgatä, matimäuqä yätŋqä diŋqe, he Goti Hanjuwä Iqueŋqä tääqä tqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Itaŋga haŋä-iqä iŋga timäuniqe, naqänäŋä ämäwqätäuniqeqä. Qua änyä qe ipäqäkqäŋgatqä täŋga ti täuŋqe, haŋä-iqä tqutä asänäŋi matimäuqä imiŋqeqä. Qänakndaŋä-pqe, tqutä asänäŋi hŋqu-pqe matimäuqä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Haŋä-iqeŋqe, Naqä Iqu ‘Wäŋqäpu wäniqeqä’ ae ätkqeqä. Iqu iiŋä mimäkqä-säpi, ämaqä eeqänä qui imäkŋgäpäniŋgä. Iŋäqe Iqu qokä-apäkä Iqueqäŋqä atäuŋuä ikqä iquauŋqä kŋuä indqänätä, wäŋqäpu hiätŋqä imäkäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Iŋgaŋi ämaqä hui, ‘He hiŋuä qumbiyä! Kraisi ne ämineyätŋqä Goti Iqu ique atäuŋuä ikqä iqu täqi äpmenä,’ ä ‘Näŋi äpmenä’ etqaŋgpqe, he qätä mäwiyqä pa iqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ii tiiŋä etaŋgi. Ämaqä quaŋgä-tqä hui ätimäupu, ‘Nyi Kraisi he ämeyqäŋqä Goti Hanjuwä Iqu atäuŋuä änyikqä iqunjqä’ etäpu, ämaqe kŋuä iqä mapŋqeŋqä, nätmatqä ämaqä mimäkqänäŋä huitaŋä-huitaŋi imäkpnuwiqä. Quaŋgä iiŋä tqä iqua, ämaqä Goti Hanjuwä Iqu Iqueqäŋqä atäuŋuä ikqä iquauŋi, qäyasäqi ätuma wanä-tpu ipnuwiqä. Itaŋga ämaqä huizi, ‘Nyi hiŋuä-tqä iqunjqä’ ätäpu, asänäŋä imäkpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Qätä nyipiyä! Nätmatqä ii ätimäuniŋqeŋqe, Nyi ae äyä etätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Iŋi ämaqä hui, ‘He hiŋuä qumbiyä! Kraisi Iqu aŋä avqŋqä imä äpmenä,’ ä ‘Iqu aŋä yäpä iŋgisa äpmenä’ hitqaŋgpqe, qätä mäwiyqä pa iqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqäŋgaŋi, nyuauä itä qäukuä haqä yätuta we im-imä eeqänäŋä äunätŋqä-paŋi, Iquesaŋi, we asä iiŋä hunäniqeqä. Iŋi ämaqä eeqänäŋi hiŋuä qumbnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nätmatqä äpäkonä pizqä witaŋgqä iuŋi, yŋŋä quvqä iqua äpäpu, äpputmäupu äŋgpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Itaŋga, haŋä-iqä naqänäŋä ae etqä iqua qäpu hiqaŋgaŋi, maqänäŋi mäptqä iqu hea äwitä, qaŋuä iqu mäyäŋqä itä, qätäqueqä iqua qäukuä yätuŋi äväma, qua täu qiyäpäkŋgaŋguwäŋga, ga nätmatqä yäŋänäqŋqä qäukuä yätu äwiŋuwi, ämeŋä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iŋgaŋi Ämaqeuqä Ymeqä Ekqä Iqueqä hiqŋqe, qäukuä iu timäuqaŋga, hueqä-himqä eeqänä qua täu äpmeŋuwi, zä ipu zääqä ätäpu, hiŋuä tiiŋä qumbnuwiqä. Ämaqeuqä Ymeqä Ekqä Iqu qaquvqä iu äpme, Iqueqä yäŋänäqŋqetä, Iqueqä yoqä naqe motquetŋqetä pqaŋgi qumbnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Itaŋga hääwä naqänäŋä tqaŋga, Iqu Iqueqä eŋätqä iqua qua maŋä eqiyäŋqä-pa äwäpu, qokä-apäkä Iqueqäŋqä atäuŋuä ikqä iu, aquvä maqäpŋqä dowatäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Itaŋga he zä-eaqä iqu ämetquetŋqeŋqä näqŋqä mapiyä. Kiqä äpa iuŋi, eqä yqänä änyä, quwqä mŋi änyä-häŋä iŋgqäqe, näqŋqä tiiŋä iqäpŋqä. Yuŋuä äqunätŋqe qäpu eätä, mäptqä dŋä hinätŋqe, qäqi etaŋgiyqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Asä iiŋi, he nätmatqä Nyi etqäqä iiŋä ii timäwäwqaŋgi äqumbiyäŋgaŋi, he näqŋqä tiiŋä hipnuwiqä. Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqä aŋä hänaqä iu näwe tqäutaŋgiyqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nyi he naqä-qakuä etqä. Ämaqä hea iŋga pmapnuwä iqua, qu mapäkoŋqä yqänä pmetaŋguwäŋga, nätmatqä eeqänäŋi timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Qäukuitä, quaetä, qui imäknäniqeqä. I etaŋgi Nyaqä kukŋui, qui mimäkŋqä yäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Iŋäqe nätmatqä iiŋi äkŋga timäuniqä iiŋqe, ämaqä hŋqu änyä maqŋqä eänä. Ynaunjqä qäukuä yätutaŋä iquatä, Nyi Ymeqä Iqundäŋi, ne änyä maqŋqä eäŋunä. Apiqu Iqueqä-kiuänänjqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa iqu pmetaŋga, huakä naqänäŋä ätimäukqä-paŋä iiŋi, Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqäŋgaŋi, asä iiŋä timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Huakä naqänäŋi matimäuqä änä etaŋgaŋi, qu ymisaŋä änäpu, eqä änäpu, apäkä ämepu, apäkä yaŋä änyäpu, Noa iqu yimba paquvqaŋgaŋqä imäkqa äumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Qu nätmatqä timäutŋqä iiŋqe maqŋqä eäpu, iiŋä iqa wätqätaŋguwäŋga, huakä naqänäŋä ätimäutä, ämaqä eeqänäŋä iiŋä iuŋi pizqä äpäkkqeqä. Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqäŋgaŋi, asä iiŋä timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ämaqä hŋquaqu qeeqä wäuŋuä iu äpmamisiyqe, iwä Goti Hanjuwä Iqu hŋque itmetä, hŋqueŋi hiŋuinä qunäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Itaŋga apäkä hiuaqu sŋgumetqä quqowä äqämisiyqe, iwä Goti Hanjuwä Iqu hui itmetä, ga huiŋi hiŋuinä qunäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iŋi hiqä Naqä Iqu äŋga päniqätiyä maqŋqä eäŋuwitaŋi, he näwenyä imäknäpu äŋguänä mimbiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Itaŋga he tiiŋä-pqeŋqä kŋuä indqämbiyä. Ämaqä aŋä-täŋä hŋqu, ämaqä quwä-meqä hŋquenyqe, ‘Iqu heatqä äsqueti päŋqutiyä’ tä näqŋqä ae eätqe, iqu hiŋuä äŋguä äqunätä, quwä-meqä iqu iqueqä aŋi qäyäpnasqiyätä, yäpä yäŋgisa päyätŋqe, hiŋuinä mäquŋquä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iiŋiŋqe, he-pqe näwinyä imäkmbu pmapiyä! Hea hŋqueŋi, he ‘Täŋgaŋqe mapqä yäŋqiyä’ kŋuä indqänätqätaŋguwäŋgaŋi, Ämaqeuqä Ymeqä Ekqä Iqu äpäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wäuŋuä-wiyqä, kŋuä äŋguä äme, kiqä wäuŋui äŋguä imäkqä iquenyqe, Nyi awä etmqe. Ämaqä naqä iqu, ämaqä iiŋä iqueŋi, iqueqä wäuŋuä-wiyqä iquau ämitä, iquauqä ymisaŋä hea qayunäŋäŋga väniqä iiŋqe atäuŋuä väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naqä Iqu äpäqe, iqueqä wäuŋuä imitätqä di hiŋuä quŋgaŋgaŋi, iqu aquvänä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nyi naqä-qakuänä etqänä. Ämaqä naqä iqu, iqueqä nätmatqä eeqänäŋi ämitŋqeŋqe, ique atäuŋuä väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","I etaŋgqä-qe, wäuŋuä-wiyqä tqu, ‘Nyaqä naqä iqu maqänä mapqä yäŋqiyä’ kŋuä indqänätä, wäuŋuä-wiyqä huizi iquau äpäsätä, itaŋga buayätä eqätä ämaqä hiqiiyqä imitpqä iquatä änmitätqe, hea hŋqueŋi, iqu maqŋqä eätä näwenyä mimäkŋqä etaŋgaŋi, iqueqä ämaqä naqä iqu aŋgi äpäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Iqu quvqä e imäkqaŋgi äqunäqe, iqueŋi mŋä ätävätä, ämaqä wopqä ipu kukŋuinä tqä iquatä äpmamitpqä iuŋqä huätä dowatäniqeqä. Iqi äpmapiyäŋgaŋi, kŋuä naqänäŋä äqiyäpu, hiquaŋä maŋgtäsqukuä mäuqäpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ga Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqäŋgaŋi, Goti Qäukuä Yätutaŋä Iqunä miqe, apäkä hitqä hipa eeqäŋä iuauqä tiwiqä eŋqä-paŋi hiäniqeqä. Ämaqä apäkä metŋqä imäknätä äpätŋqä iqaŋgi, iua iqutä ämimbŋqä hiqi-tä ämäsäupu upnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Apäkä iuataŋä hipa hŋgiŋä iua, kŋuä maiqe. Itaŋga huizi iua, kŋuä äŋguä meqä iuai. ");
INSERT INTO mcr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Apäkä kŋuä maeqä iua hiqi-tä ämäsäupiyi, ga olipqä eqä aowä hiqi-tä aŋgi iquatimepu ämäsäuqe, qäsä mäma mapqä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Iŋäqe näqŋqä epiyä iua, eqä-häkä iu equatimepiyi, quwqä hiqi-tä mäsäuqetä qäsä äma ppnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ämaqä apäkä metŋqä iqu maqänä mapqaŋgi, iua hiŋuä hiqaqäŋqä ipiyi, hiqaqä wopnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Heatqä quaesqäŋgaŋi, tääqe, ‘Ämaqä apäkä metŋqä iqu äpqiyä. Iqutä mimbŋqä ppiyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Itaŋi apäkä hitqä iua eeqänäŋi ivatuwämbiyi, iuauqä hiqi-tä näwenyä imäkpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Apäkä maqŋqä iua näqŋqä iuau-mända tii tupnuwiqä. ‘Neyaqä hiqi-te esuätŋqä iqaŋgi, olipqä eqä aowä hui nätappiyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Iiŋä tquaŋguwäŋga näqŋqä iua kimaŋi, ‘Oeyqä’ tupnuwiqä, ‘Eqä tä, nenyqätä, henyqätä qäyunä maeqä eänä. Eqä miqä iquauŋqä äwäpu, hiqe mbqä ipiyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Itaŋi apäkä maqŋqä iua, eqä mbqä ipŋqä uwqaŋguwäŋga, apäkä metŋqä iqu ätimäuqaŋga, apäkä näwenyä imäknmipqä iua, aŋä yäpä iŋgisa iqutä anä ymisaŋä naqänäŋi bŋqä paquvqaŋguwäŋga, qu qŋqaŋä mäyepnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Qänakndaŋi apäkä hitqä huizi iua äppiyi, tupnuwiqä. ‘Naqä Iqukiyä. Si äpätnä, qŋqaŋä nauteyä.’ ");
INSERT INTO mcr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","I tquaŋguwäŋga, iqu kimaŋi tiiŋä tuäniqeqä. ‘Nyi henyqe, tutqä qäpu änyä maqŋqä eäŋänä.’” ");
INSERT INTO mcr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tiwiqä e ätuäqetaŋi tii ätukqe. “Iŋitaŋi, hiqä Naqä Iqu äkŋgati päniqeŋqe maqŋqä eäŋuwä-qae, he näwenyä imäknäpu äŋguänä mimbiyä.” ");
INSERT INTO mcr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Huizi, Goti Qäukuä Yätu Äpmeŋqä Iqunä miqe, ii tiiŋä eŋqä-paŋiqä. Ämaqä hŋqu kiŋämqä qaŋä wätŋqä imäknätäqäŋgaŋi, iqueqä wäuŋuä-wiyqä iquauŋi tääqä ätuätumetä, qu iqueqä nätmatqe miqäpŋqä iquauqä hipa iu väniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iqu wäuŋuä-wiyqä iquauqä näqŋqeŋqä iwäsäuqe, ga hŋqueŋi mbqä kuapänä 5,000 ävätä, hŋqueŋi iiŋänäŋä 2,000 ävätä, itaŋga yäpakä iqueŋi 1,000 äväqe, wäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ae uwqaŋga, maqänäŋi wäuŋuä-wiyqä mbqä 5,000 ämetqä iqu mbqä wäuŋuä imäkätä, mbqä haqeqiŋi, 5,000 inä meniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Itaŋga ämaqä mbqä 2,000 ämetqä iqu-pqe, mbqä wäuŋuä inä imäkäqe, 2,000 inä meniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Itaŋgi ämaqä mbqä 1,000 ämetqä iqu äma äwätä, iqueqä ämaqä naqä iqueä mbqe, qua hovqä äptätä, imä zä pteäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hea quäuqä ae äpäwqaŋgaŋi, ämaqä naqä iqu aŋgumä äpäqe, iqueqä mbqä ävätqeŋqä näqŋqä metŋqä, wäuŋuä imäkqä iquau tääqä tuätumeniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Itaŋga ämaqä mbqä 5,000 ämetqä iqu äpätä, mbqä 5,000 haqeqi hutäkŋä ämetqe, qäsä äma äpätä, tiiŋä tuäniqeqä. ‘Ämaqä naqä iqukiyä. Si mbqä 5,000 ändapkŋiqä. Hiŋuä qunyä. Nyi wäuŋuä imäkätmä, 5,000 haqeqi äyä ämeqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Itaŋi ämaqä naqä iqu tiiŋä tuäniqeqä. ‘Si ämaqä äŋguki eänä, wäuŋuä qäyunä imäkqukiyqä. Nätmatqä wäŋqä isua äŋguänäŋä ämitqäŋä-qae, si nätmatqä kuapä misŋqä atäuŋuä kimqänänjqä. Äpätnä, nyitä aquvänä yeŋqeqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ämaqä mbqä 2,000 ämetqä iqu inä äpätä, tiiŋä tuäniqeqä. ‘Ämaqä naqä iqukiyä. Si nyiŋi 2,000 äyä ändapkŋiqä. Hiŋuä qunyä. Nyi wäuŋuä ämitmä, kiqä haqeqiŋi 2,000 inä äyä ämeqeqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Itaŋi ämaqä naqä iqu tiiŋä tuäniqeqä. ‘Si ämaqä äŋguki eänä, wäuŋuä qäyunä imäkqukiyqä. Nätmatqä wäŋqä isua äŋguänäŋä ämitqäŋä-qae, si nätmatqä kuapä misŋqä atäuŋuä kimqänänjqä. Äpätnä, nyitä aquvänä yeŋqeqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Itaŋi ämaqä mbqä 1,000 ämetqä iqu-pqe äpätä, tii tuäniqeqä. ‘Naqä iquki, nyi sinyqe näqŋqeqä. Si ämaqä tnäŋänäŋä iqukiyqä. Ämaqä hŋqua wäuŋuä iu ymisaŋä vowä ämäuepqe ptqukiyqä. Ämaqä hŋqua kuä uwqä tnämäwäpqeuŋi, kiqä nääŋqe mequkiyqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Si suqä iiŋä iquki etaŋgi, nyi zä itmä, tqä mbqä 1,000 qua hovqä iu zä äptekqä-qae, ga täsuwänä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","I tquaŋga, naqä iqu kimaŋi tiiŋä tuäŋqiyä. ‘Si wäuŋuä-wiyqä quvqä enyqä iqukiyqä. Nyinyqe, si näqŋqä ae eäŋnä. Nyi ämaqä hŋqua wäuŋuä iu ymisaŋä vowä ämäuepqe ptqunjqä. Ämaqä hŋqua kuä uwqä tnämäwäpqeuŋi, kiqä nääŋqe mequnjqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Si näqŋqä iiŋä eäŋi, nyaqä mbqe, kiqä pŋqä wiqä iuŋi, suŋqä pŋqä maeqä ikŋäwä? Iiŋä imäkqä-säpi, nyi aŋgumä äpmqäŋgaŋi, ŋqä mbqä qäyunäŋitä kiqä haqeqiŋitä meqämiŋgä.’ ");
INSERT INTO mcr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Itaŋi wäuŋuä-wiyqä huizi iquauŋi, ‘He mbqä 1,000 ämotaupu, ämaqä mbqä 10,000-täŋä ique wipiyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Ii tiiŋä etaŋgi. Ämaqä nätmatqä-täŋä eeqänäŋä iquauŋi, nyi hui aŋgi vqaŋga, qu kuapänäŋä-täŋä hipnuwiqä. I etaŋgi, ämaqä nätmatqä maeqä eä wäŋqäpu ämeŋuwä iquauŋi, nyi aŋgi ämotaumqänä. ");
INSERT INTO mcr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Itaŋga wäuŋuä-wiyqä quvqä tqueŋi, he yäpaqä iŋgisa aŋä hiawiqä iŋgisaŋqä huätä dowatpiyä. Iqi äpmamipqä iqua, hiquaŋä maŋgtäsqukuä ämäupu, kŋuä qäkmaŋgpnuwiqä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ämaqeuqä Ymeqä Ekqä Iqu aŋgu äpätqäŋgaŋi, yoqä naqä-täŋä äpätä eŋätqä eeqänäŋä iquatä anä ppnuwiqä. Itaŋga Iqu Iqueqä yoqä naqe motquetŋqe, ämiqä iqueqä zä-hawä iu pmeniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iŋgaŋi hueqä-himqä eeqänäŋi Iqueqä hiŋuä iqi tqäuqaŋguwäŋga, Iqu iquauŋi iwäsäutä hŋquaqu mäqäqasäueniqeqä. Yaqueqä miqä iqu sipsipqä iquatä, meme iquatä ämäqäqasäuetŋqä-pa, i imäkäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iqu sipsipqä iquauŋi ämuaŋgisa, itaŋga meme iquauŋi qunamäuqäŋgisa, mäqäqasäueniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","I imäkäqetaŋi, Ämiqä Naqä Iqu ämaqä iqueqä hipa ämuaŋgisa tqäutaŋguwä iquauŋi tiiŋä tuäniqeqä. ‘Ŋqä Apiqu he äŋguä emäkätŋqä ae etkqeqä. Iqu nätmatqä äŋguänäŋi quae änä imäkätäqäŋga, henyŋqä näwenyä imäkekqe, he mapŋqe, Iqunä ämitŋqä yäpä täŋgisa yappiyä. ");
INSERT INTO mcr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ii tiiŋä etaŋgiyä. Nyi buayä dä pmetaŋgaŋi, he buayä äyä ändapmiŋuwiqä. Nyi eqä maŋqä pmetaŋgaŋi, he eqä äyä ändapmiŋuwiqä. Nyi ämaqä hueqä-himqä huitaŋunä etaŋga, he Nyiŋi hiqä aŋä iuŋqä ändma äumiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nyi qäkä mäyäuqä itaŋga, he qäkä äyä ändapmiŋuwiqä. Nyi yaqä witaŋgaŋi, he äyä äminyimiŋuwiqä. Nyi guä pmetaŋgaŋi, he äpäpu hiŋuä äyä ämaŋqänmiŋuwiqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","I tquaŋga, qokä-apäkä jänäŋä iqua kimaŋi tiiŋä tupnuwiqä. ‘Naqä Iqukiyä. Si buayä dä pmetaŋgnä hiŋuä äkqänätanä, äkŋga äktapmiŋquäwä? Si eqä maŋqä pmetaŋgnä, eqä äkŋga äktapmiŋquäwä? ");
INSERT INTO mcr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Si ämaqä hueqä-himqä huitaŋänäŋuki äkqänätanä, neqä aŋä iuŋqe, äkŋga äktma äumiŋquäwä? Si qäkä maiquki etaŋgnä, qäkä äkŋga äktapmiŋquäwä? ");
INSERT INTO mcr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Si yaqä witaŋgnä ä guä pmetaŋgnä, äpätanä hiŋuä äkŋga ämakqänmiŋquäwä?’ tupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Itaŋga Ämiqä Naqä Iqu kimaŋi tiiŋä tuäniqeqä. ‘Nyi aaŋä naqä-qakuänäŋä etqänä. Nätmatqä eeqänäŋi, he Nyaqä guäkautä, napqautä iwimäkmipqe, qu yoqä maeqä qäyä etaŋgqä-qe, iiŋi he Nyi nyimäkmiŋuwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Iŋgaŋi Iqu ämaqä hipa qunamäuqäŋgisa tqäutaŋguwä iquau tuäniqeqä. ‘Henyqe, Ŋqä Apiqu, “Qu qui imäkmbŋqäuä” ae ätkqeqä. He tä maiusqänäŋä äsäŋqeuŋqä huätä upuiyä. Tä äsäŋqä iqu, Setänä iqueŋqätä, iqueqä eŋätqä iquauŋqätä näwenyä äsänä. ");
INSERT INTO mcr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ii tiiŋä etaŋgiyä. Nyi buayä dä pmetaŋgaŋi, he buayä mändapqä äyä imiŋuwiqä. Nyi eqä maŋqä pmetaŋgaŋi, he eqä mändapqä äyä imiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nyi ämaqä hueqä-himqä huitaŋunä etaŋga, he Nyiŋi hiqä aŋä iuŋqä mändma mäwqä äyä imiŋuwiqä. Nyi qäkä mäyäuqä itaŋga, he qäkä mänyiyätqä äyä imiŋuwiqä. Nyi yaqä äwitmä ä guä-pqä pmetaŋgaŋi, he mäminyqä da äyä imiŋuwiqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","I tquaŋga iqua-pqe kimaŋi tiiŋä tupnuwiqä. ‘Naqä Iqukiyä. Si buayä dä pmetaŋgnä, ä eqä maŋqä pmetaŋgnä, ä, hueqä-himqä huitaŋänäŋuki etaŋgnä, ä qäkä maiquki etaŋgnä, ä yaqä witaŋgnä ä guä pmetaŋgnä, hiŋuä äkqänätanä yätamäkqä makiyqe, äkŋga imiŋquäwä?’ tupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Itaŋga Ämiqä Naqä Iqu kimaŋi tiiŋä tuäniqeqä. ‘Nyi aaŋä naqä-qakuänäŋä etqänä. Nätmatqä eeqänäŋi he Nyaqä guäkautä napqautä yoqä maeqä inäsquauŋi miwimäkqä imiŋuwi, iiŋi he Nyi-pqe mänyimäkqä äyä imiŋuwiqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ämaqä tqua äwäpiyi, haŋä-iqä qäpu maeqä eniqä di ämepu pmepnuwiqä. Iiŋä etaŋgi qokä-apäkä jänäŋä iqua, häŋä hea ique-ique pmeqe ämepu pmetpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisasi Iqu kukŋuä tä eeqänä qäpu ätuäqetaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“He näqŋqä äyuwänä. Hiunji hŋquaqu yqänä äwinä. Iŋgaŋi hiunji naqänäŋä Pasopa iqu timäuŋqiyä. Hiunji iqu ätimäuqaŋgaŋi, qu Ämaqeuqä Ymeqä Ekqä Iqueŋi, mäkä-huŋqä iqua zä-huätatä huepŋqä wipnuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hea asä qäŋgaŋi, hiqäva-imäkqä naqä iquatä, Israitqeu miqä iquatä, hiqäva-imäkqä naqä Käyäpasi iqueqä aŋä iqi aquvä äqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Iqua kukŋuä ätqämanäpu, “Ne Jisasi Ique maqŋqä itmetanä pizqä päsatuŋque, äänä imäkatuŋquäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Ämaqe hiŋuä änaqänäpu mäkä ipäqiyqeŋqe, ne suqä iiŋi, hiunji naqänäŋäŋga mimäkqä yatuŋqueqä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisasi Iqu aŋä-himqä Betani, Saimonä Wänyimäŋqueä aŋä iu äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iqu buayä gmanätqätaŋga, apäkä hui hikä häkä eqä jinaŋä-weqä iŋqä hŋqu, äma äwimetä, Iqueuä nyuäŋiu equatkqe. Häkitä, eqä jinaŋä-weqetä, kiqä mbqe naqänäŋi. ");
INSERT INTO mcr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua e äqumbiyi, äwqä tnäŋä imäkäpu, “Eqä jinaŋä-weqe, hiŋgi qui suŋqä imäkqiyä? ");
INSERT INTO mcr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ii eqä jinaŋä-weqe, mbqäŋqä imäkätä, mbqä naqänäŋä ämetä, ämaqä nätmatqä maeqä iquau mävqä suŋqä iqiyä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisasi Iqu iquauqä kukŋuiŋqä näqŋqä eä, iquauŋi tiiŋä ätukqe. “He apäkä täsiŋi, haŋä-iqe suŋqä vqäuä? Ii suqä äŋguänäŋi nyimäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ämaqä nätmatqä maeqä iqua hesä anäŋi, hea ique-ique äyä äpmeŋäuä. Itaŋgi Nyi hesä anäŋi, hea ique-ique mäpmeqä imqänä. ");
INSERT INTO mcr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Apäkä ii eqe änjiquatqe, ii Nyaqä huiwi qua ptnäniqä iiŋqä näwenyä inyimäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nyi naqä-qakuänä etqänä. Qu qua eeqänäŋä iuŋqä äwäpu, kukŋuä äŋguä we-huŋqä-täŋi awä ätuäkipiyäŋgaŋi, apäkä täsi inyimäkqeŋqe awä inä tqäpŋqeqä. Iŋi qu iiŋqä hui mimäuqä ipŋqeŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iŋgaŋi wäuŋuä imäkqä 12 iutaŋä Jutasi Iskarioti iqu, hiqäva-imäkqä naqä iquauŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Iquau äwimeqe, yatŋqä tiiŋä äwikqe. “Nyi Jisasi Ique he hitapmqe, he nätmatqe äkitaŋi dappŋqäwä?” Yatŋqä vqaŋgqäŋga, qu mbqä-hiki, 30 qe äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Itaŋi Jutasi iqu, Jisasi Iqueŋi ämaqä iquau vätŋqe, hänaqeŋqä qävqä yätŋqä ipäqäkqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hiunji bretqä yeŋuä qo matäuqä bŋqä iquauqä hiunji kiŋganäŋä iqueŋi, wäuŋuäŋqä ämotquamiŋqä iqua Jisasi Iquenyqä äpäpu, yatŋqä tiiŋä äwikuwi. “Si hiunji naqänäŋä Pasopa iutaŋä buayä dŋqe, ne näwenyäŋi, äsqi imäkekiyatuŋquäwä?” ");
INSERT INTO mcr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iiŋä tquaŋguwäŋga, Iqu tii ätukqe. “He aŋä-himqä yäpä iŋgisa äpaquväpu, ämaqä iiŋä ique hiŋuä äqumbiyi, tii tupiyä. ‘Ämotqueqä iqu “Tupiyä” ätätä änandowatqiyä. “Hea Apiqu Nyinyqä atäuŋuä ikqe, ae qäqiqi quvepqaŋgi, Nyitä Ŋqä ämaqä iquatä, hiunji naqänäŋä Pasopa iutaŋä ymisaŋä natuŋque, tqä aŋä iu naŋqunä” ätqiyä,’ tupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","I tquaŋga, iqua Jisasi Iqu ätukqä-pa, Pasopa iutaŋä ymisaŋi näwenyä qe imäkekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Awiyqä ae eqaŋga, Jisasi Iqutä, Iqueqä ämaqä 12 iquatä ymisaŋä bŋqä äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Qu ymisaŋä äŋgmanäpiyäŋgaŋi, “Nyi naqä-qakuä etqänä. Hesaŋä hŋqu Nyiŋi, himä-wiuŋqä iquau nyiväŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","I tquaŋgi äwipiyi, äwqä haŋä vqaŋga, qu hŋqunä-hŋqunä yatŋqä wipŋqä ipäqäkuwi. “Naqä Iquki, Si e ätŋi, ii nyi ma! Qäyutanä?” ");
INSERT INTO mcr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kimaŋi Iqu tiiŋä ätukqe. “Buayä hevqä täu, Nyitä anä ämeququä iquenä, ämaqä Nyi himä-wiuŋqä iquau nyivätŋqä iqu, heyaqä awä iqisaŋä hŋquvqä. ");
INSERT INTO mcr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ämaqeuqä Ymeqä Ekqä Iqu, Goti Hanjuwä Iqueqä bukä iuŋi äpäkonäŋqiyä ätkqä-pa, Iqu e päkonäŋqiyä. Itaŋgi Ique himä-wiuŋqä iquau vätŋqä iquenyqe, iqueŋi haŋä-iqä naqänäŋä wimeŋqiyä. Ämaqä iiŋä imäkätŋqä iqueŋi, känai maunyqä-säpi, ii äŋguä hitäninjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jutasi, ämaqä himä-wiuŋqä iquau vätŋqä ikqä iqu, Jisasi Iqueŋi, yatŋqä tiiŋä äwikqe. “Ämotqueqä iqukiyä. Si e ätŋi, nyi ma. Qäyutanä?” E tquaŋga kimaŋi, “Si e ätŋi qeyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iqua ymisaŋä äŋgmanäpiyäŋga, Jisasi Iqu bretqä hŋqu ämeqe, Goti Hanjuwä Ique “äŋguiqä” ätuäqe, äkutätä, wäuŋuäŋqä ämotquamiŋqä iquau ävqäwätä, ätukqe. “He ämepu biyä. Tä Ŋqä huiwiyqä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Itaŋi Iqu wainqä-eqä-häki ämeqe, Goti Hanjuwä Ique “äŋguiqä” ätuäqe, iquau ävätä ätukqe. “He eeqänäŋi, eqä tä bŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tä Ŋqä häŋeqä, he yätamäkqä heyätŋqä kukŋuä guä mäsäuŋqä iiyqä. Ämaqä kuapänäŋä iquauqä suqä quvqe, huätä mamäutŋqe, Nyaqä häŋeqe, iuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nyi he etqänä. Ŋqä Apiqunä miqä iu wainqä-eqä änyä-häŋä hesä anä naniquäŋgaŋqe, Nyi wainqä-eqä aŋgumŋi maŋqä imqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","I ätuäqetaŋi, qu apqä ätpiyi, aŋä-himqä iu äväma, qoqoŋä Olipä iuŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iŋgaŋi Jisasi Iqu iquauŋi ätukqe. “Täŋga heatqeuŋi, nätmatqä nyimeqaŋgutqetaŋi, heqä Nyinyqä quuvqä heqiyqe, mändi päwiŋqiyä. Ii Goti Hanjuwä Iqueqä bukä iuŋi, tiiŋä ätä äqänäŋqä-payqä. ‘Nyi sipsipqä-miqä ique päkmqänä. Iiŋä imäkqaŋgmdqäŋga, sipsipqä iqua zä im-imä wepnuwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Itaŋgi Goti Hanjuwä Iqu, Nyi aŋgi nyivauqumuatqaŋga, Nyi qua Galili iuŋqä hiŋuiqä emamniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","I tquaŋga Pitä iqu ämävauqe, “Iqua eeqänä nätmatqä kimeqaŋgutqeta quwqä quuvqä heqiyqä mändi qäyä äpäwiqaŋguti, nyi iiŋä miqä da ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","I tquaŋga Jisasi Iqu, “Nyi naqä-qakuänä äktqänä. Heatqä tqueŋi, kukutakisqä äkakä matqäŋga, si Nyinyqe, ‘Iquenyqä maqŋqeqä’ hŋquaqui-hŋque tutŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","I tquaŋga Pitä iqu ämävauqe, “Qäyä eänä. Si äpäkoŋgti, nyi-pqe anä päkoneŋqeqä. Nyi Sinyqe, ‘Iquenyqä maqŋqeqe’ matqä imqänä” ätukqe. Itaŋi wäuŋuäŋqä ämotquamiŋqä eeqänäŋä huiziqua-pqe, inyänä ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iŋgaŋi, Jisasi Iqutä, iquatä, ‘Gesemäniyqä’ ätmiŋuwä iu ätimäupiyi, Iqu iquauŋi tiiŋä qe ätukqe. “He täqi pmapiyä. Nyi tääqä tmqä, näŋiŋqä umqänä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I ätuäqe, Iqu Pitä iquesä, Sepri iqueqä hikŋä iquaquisä itmeqe, nänä qe äukuwi. Itaŋi Iqu änä mäwimäŋqä itä, Iqueqä äwqe haŋä kiiŋä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Iŋgaŋi Iqu iquauŋi, tiiŋä qe ätukqe. “Haŋä-iqä tqu, Nyaqä qeqä-quuvqä tämŋi imbätäumäkqä-qae, ae qäqi äpäkonmqä iqä. He täqi äpmapu, quvqä nemeqeŋqe äŋguä äminyanä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I ätuäqe, nändi ti äwäqe, Iqueqä hipeŋui qua bu eäqe, tääqä tiiŋä ätukqe. “Ŋqä Apiquki, hänaqä-pqä hui inä etaŋgutqe, häkä haŋä-iqä-täŋä tqu huätä mändavä. Iŋäqe änyiŋqä Nyaqeuŋi, qäyä etaŋguti, äkiŋqä Saqeunä isŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iiŋi ae ätuäqetaŋi, Iqu Iqueqä ämaqä iquauŋqä aŋgi äpäqe, hiqaqä witaŋgä äqunäqe, Pitä iqueŋi tii ätukqe. “Änääŋäŋqäwä? He Nyitä anäŋi, wäŋqäpu mämiŋqä iquwiuä? ");
INSERT INTO mcr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yamwiqä iqe, he mändi maekittqiyqä yätŋqä iiŋqe, he äminyäpu tääqä tupŋqeqä. Hiqä quuvqe, qäyunä imäkŋqäŋqä wiŋgaŋgutqä-qe, huiwi yäŋänäqŋqä maeqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iqu aŋgumä äväma äwäqe, tääqä tiiŋä ätukqe. “Ŋqä Apiquki, häkä haŋä-iqä-täŋä tqu, huätä mändautŋqä etaŋgutqe, kiqä haŋä-iqe, Tqä äkiŋqä iunä mamqänä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Itaŋga iquauŋqä aŋgumä äpäqe, iqua hiŋuä kukuäŋuä wiyqaŋgi hiqaqä witaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iqisaŋi Iqu iquauŋi aŋgumä ävämaŋi, tääqä yäpaki, kiŋganäŋä iquaqu ätkqä-pa, ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Qänakndaŋi Iqu Iqueqä ämaqä iquauŋqä aŋgu äpäwäqe, ätukqe. “He hiqaqä yqänä äwiŋuwi, hapä äpmeŋäuä? Qätä nyipiyä. Ämaqeuqä Ymeqä Ekqä Ique, ämaqä suqä quvqä imäkqä iquauqä hipa iu wipŋqe, ae qäqiyqä. ");
INSERT INTO mcr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","He pämä äpmepu äwanä! Hiŋuä qumbiyä. Huiziuqä hipa iu nyivätŋqä iqu, ae qäqi ätimäutŋqä iqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisasi Iqu kukŋuä ii yqänä tätqätaŋgaŋi, Jutasi ämaqä 12 iquautaŋä iqu äpkqe. Iqutäŋi, ämaqä kuapänäŋi, ipäqäyuŋätä, jävqätä a äqätqa äquvepkuwi. Ämaqä iquauŋi, hiqäva-imäkqä naqä iquatä, qokä-apäkä iu miqä huiziquatä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Qu änyä upŋqä imäknäpiyäŋgaŋi, täkqä-tqä iqu, huiziquauŋi tii ätukqe. “Nyi ‘Ämaqä Tqueyqä’ etätmi, kikiyä äwuŋgundi, he Iqueŋi a kiqätpŋqe.” ");
INSERT INTO mcr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Qu ätimäupiyi, Jutasi iqu Jisasi Ique maqänä äwimeqe, “Ämotqueqä Iqukiyä, heatqevqä” ätuätä, maŋgawiu kikiyä äwuŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Itaŋi Jisasi Iqu iqueŋi, “Näueqä iquki, nätmatqä si imäktŋqä äpŋi, imäkiyä” ätukqe. Iŋgaŋi ämaqä iqua äppiyi, Jisasi Ique a qe äkiqätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ique kiqätqaŋguwäŋga, Jisasi Iqueqä ämaqä hŋqu, iqueqä ipäqäyuŋi ämäkäqiyäqe, hiqäva-imäkqä naqä iqueqä wäuŋuä-wiyqä hŋque, qätä mŋä hämänä ätqavämäukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","I imäkqaŋga, Jisasi Iqu iqueŋi tii ätukqe. “Tqä ipäqäyuŋi, kiqä aŋä iu aŋgi qupuiseyä. Ämaqä ipäqäyuŋä itä mäkä äumbqä eeqänäŋä iqua, ipäqäyuŋä iutanä päkombnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Si tiiŋiŋqä maqŋqä eŋnä? Nyi Ŋqä Apique yatŋqä vqaŋgndqe, Iqu eŋätqä kuapänä 50,000 iquauŋi, yätamäkqä nyipŋqä ändowatäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Itaŋgqä-qe Nyi iiŋä imäkqaŋgndqe, kukŋuä Goti Hanjuwä Iqueqä bukä iu äqänäŋqe, qäyunäŋi äänä timäuniqätiyä? Iqueqä bukä iuŋi, ‘Nätmatqä tä, Nyi nyimeŋqiyä’ ätä äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ique a kiqätqaŋguwä iquauŋi, Iqu tiiŋä ätukqe. “He ipäqäyuŋätä, jävqätä a äqätqa äpquwi, ämaqä äpäsätä quwä-meqä hŋque a äkiqätätqäŋuwä-pa, Nyi-pqe, iiŋunä etaŋgä äŋgiqätqäuä? Hiunji eeqänäŋä iuŋi, Nyi hiqäva-imäkqä aŋä ququawä iu äpmamä, qokä-apäkä iu ämotquetqätaŋgaŋi, iŋga maŋgiqätqä, suŋqä itqäŋuwäwä? ");
INSERT INTO mcr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nätmatqä eeqänäŋä ii, hiŋuä-tqä iqua kukŋuä äqiyäpu ekuwä ii, qäyunä imäkätŋqä ätimäuqeqä” ätukqe. Itaŋi wäuŋuäŋqä ämotquamiŋqä eeqänäŋä iqua, Jisasi Ique zä äväma äwekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ämaqä Jisasi Ique a äkiqätukuwä iqua, Iqueŋi Käyäpasi hiqäva-imäkqä naqä iqueqä aŋä iuŋqä qe ätuma äukuwi. Iqiŋi, kukŋuä-suqeŋqä näqŋqä iquatä, ämaqeu miqä huiziquatä, aquvä äqämbu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitä iqu Jisasi Ique kiŋä-näŋi ti äwivändqa äpätä, hiqäva-imäkqä naqä iqueqä aŋä täkŋä yäpä iŋgisa äpaquväqe, “Jisasi Iqueŋi nätmatqä äkitaŋi wimeŋqutiyä” tä, ämayukä-imaŋqä iquatä anä äpme, hiŋuä äqunä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hiqäva-imäkqä naqä iquatä, Israitqä iquau miqä naqä huiziquatä, Jisasi Ique pizqä päkpŋqä diŋqe, quaŋgä tpŋqä hŋquau tääqä ätuätumepu, Iqu suqä quvqä hui imäkqäŋqä qävqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ämaqä kuapänä äpäpu, Iquenyqä quaŋgä täqisqaŋguwä-qe, ämiqä naqä iqua, Ique pizqä päkpŋqä iiŋqe, qakui mämäqumueqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Qänakŋi, ämaqä hŋquaqu äpäsinyä, tii ätukiyi. “Ämaqä Tqu, ‘Nyi Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋi äpnetmä, hiunji hŋquaqui-hŋquenyä aŋgi mätmqänä’ ätkqeqä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","I tquaŋgiyäŋga, hiqäva-imäkqä naqä iqu pämä ätqäuqe, Jisasi Ique yatŋqä tiiŋä qe äwikqe. “Iquaqu e ätqiyi, änääŋgä? Si kima matqä isŋqätanä?” ");
INSERT INTO mcr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Itaŋgi Jisasi Iqu kukŋuä hui matqä ikqe. Itaŋi hiqäva-imäkqä naqä iqu tii ätukqe. “Si kukŋuä naqä-qakuänäŋinä nattŋqä iiŋqe, nyi Goti Häŋä äpmeŋqä Iqueqä yoqä iutanä yatŋqä äkiyqänä. Si Goti Hanjuwä Iqueqä Ymeqä-quki eänä, ä Kraisi, Goti Iqu ne äminesŋqä atäuŋuä äkikqä Iqukitanä?” ");
INSERT INTO mcr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","I tquaŋga, Jisasi Iqueuä kimaŋi, “Si e ätŋi qeyqä. Nyi he etqänä. Qänakndaŋi, he Ämaqeuqä Ymeqä Ekqä Iqu, Yäŋänäqŋqä-täŋä Iqueqä hipa ämuaŋgisa pmetaŋgi hiŋuä qumbnuwiqä. Itaŋga Iqu qaquvqeu pmeqä qäukuä yätuta quvepqaŋgi, qumbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Käyäpasi iqu i tqaŋgi äwiyäqe, äwqä tnäŋä wiŋgaŋgi, iqueqä gquä quäuqä äpisätä, tii ätukqe. “Iqu Goti Hanjuwä Iqu eŋqä-pa timäutŋqä tqaŋgi, äyä äwiyäŋunä. Ne Ämaqä Tqueqä suqeŋqä awä natpŋqe, ämaqä hŋquauŋqä qävqä miqä yatuŋqueqä. ");
INSERT INTO mcr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ne Ique änä-änä imäkatuŋqueŋqe, he kŋuä äänä hiyqiyä?” ätukqe. I tquaŋga qu kimaŋi, “Iqu suqä quvqä-täŋu-qae, äpäkonätŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E ätupiyi, qu Iqueqä himä-hiqumuaŋä iu makukuä äqutäupu, aaŋä kuapänäŋä äpäkmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Iŋgaŋi iqua äpäsäpu tii ätukuwi. “Si Kraisi, Goti Hanjuwä Iqu atäuŋuä äkikqä Iquki, hiŋuä natiyä. Ämaqä tä äkpäsquwä iqua, tqukuakä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Asäŋgaŋi, Pitä iqu yäpaqä mäŋgisa, aŋä ququawä iqi äpmamiŋqe. Apäkä wäuŋuä imäkqä hui, iqu-täŋä qäqi äpätä, “Si Jisasi Galilisaŋä Iqutä anä äpmetqäŋiyiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Itaŋgi Pitä iqu ämaqä eeqänäŋä iquauqä hiŋuä iqisaŋi, “Oeyqä. Si kukŋuä tä ändŋi, nyi maqŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Itaŋi iqu äwäqe, täkŋä hävqä iu miqä iquauqä aŋä iu ätqäumiŋqe. Iqiŋi apäkä wäuŋuä imäkqä hui, ique hiŋuä äqunäqe, ämaqä qäqi pmetaŋguwä iquauŋi, “Ämaqä tqu, Jisasi Nasäretqätaŋä Iqutä anä äpmetqäŋiyiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","I tquaŋga, Pitä iqu aŋgumŋi, “Oeyä” ätukqe. “Nyi aaŋä naqä-qakuänäŋä ätqänä. Ämaqä Iquenyqe, änyä maqŋqä eäŋänä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Qänaki wäŋqäpŋi, ämaqä qäqi ätqäumiŋuwä iqua äpäpu, ique ätukuwi. “Naqä-qakuänänjqä. Si Ämaqä Iqutä anä äpmeŋuwä iquautaŋä iqukiyqä. Ne tqä quväki äkiyätanä, näqŋqä ämequnä.” ");
INSERT INTO mcr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","I tquaŋguwäŋga, Pitä iqu kukŋui, yäŋänäqŋqä tiiŋä ätukqe. “Aaŋä naqä-qakuä etqänä. Nyi Ämaqä Iquenyqe, maqŋqeqä. Nyi kukŋuä naqä-qakuä matqä iqaŋgndqe, Goti Hanjuwä Iqu haŋä-iqä qäyä dapänä.” Iqu kukŋuä qäpu ae tqaŋga, maqänäŋi kukutakisqä äkakä qe ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Asä qäŋgaŋi, Pitä iqu Jisasi Iqueqä kukŋui, “Kukutakisqä äkakä matqäŋga, si Nyinyqe, ‘Maqŋqeqä’ hŋquaqui-hŋque ttŋiqä” ätukqeŋqä kŋuä indqänäqe, yäpaqä mäŋgisa äwäqe, kŋuä naqänäŋä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Zä ae äveqaŋga, hiqäva-imäkqä naqä iquatä, Israitqeu miqä huiziquatä, Jisasi Ique pizqä päkpŋqä kukŋuä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Itaŋi qu Ique guä äkiqiyäupu, kiyapqä kiŋganäŋä Pailoti ique wipŋqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jutasi, ämaqä Jisasi Ique himä-wiuŋqä iquau äwikqä iqu, qu Jisasi Ique kukŋuä ämitäpu, “Iqu äpäkonäŋqiyä” tqaŋguwi näqŋqä ämeqe, iqu suqä ii ikqeŋqä womba ämetä, mbqä-hikä hiqäva-imäkqä naqä iquatä ämaqä miqä huiziquatä äwikuwi, aŋgi äma äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iquau äwimeqe, tiiŋä ätukqe. “Nyi suqä quvqä ae imäkqeqä. Ämaqä nyi he etapqä Iqu, suqä quvqä mimäkqä itŋqä-queqä.” I tquaŋga, qu kimaŋi, “Ii nätmatqä neqä hmanjqä. Tqä dutanänjqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Itaŋi Jutasi iqu mbqä-hiki, hiqäva-imäkqä aŋä iŋgisa ätnämäwaŋi, äväma äwäqe, iqueqä-kiuä guä äqupuäqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hiqäva-imäkqä naqä iqua mbqä-hikä iiŋi ämapiyi, ätkuwi. “Mbqä tä ämaqä pizqä päsqä iutaŋä-qae, ga ne mbqä hiqäva-imäkqä aŋitaŋitä pŋqä qäsä maeqä yatuŋqueqä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Itaŋi qu kukŋuä imäkpiyi, mbqä iqueŋi ämaqä qua qondä imäkqä iqueqä qua hŋqu, ämaqä kiŋä nändaŋä iquau qua ptepnuwäŋqä mbqä qe ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iiŋiŋqe, qu “Qua häŋeqeqä” änyuätmiŋuwi, täŋga-pqe inä ätqa äwätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Iiŋä etaŋgi, kukŋuä hŋqu Goti Iqu hiŋuä-tqä Järämai iqueqä maŋä iu hiŋuiqänä ätimäuekqe, ii naqä-qakuä ätimäukqe. Ii tiyi. “Mbqä hikä kuapänäŋi 30, Israitqä iqua ämaqä tque mbqä ipnuwäŋqä atauŋä ikuwi, qu ämepu, Naqä Iqu nyi ändkqä-pa, ämaqä qua qondä imäkqä iqueqä quae mbqä ikuwi.” ");
INSERT INTO mcr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasi Iqu Pailoti iqueqä hiŋuä iqi tqäutaŋga, Pailoti iqu Iqueŋi yatŋqä tiiŋä qe äwikqe. “Si Israitqä iquauqä Ämiqä Naqä Iqukitanä?” E tquaŋga kimaŋi, “Si e ätŋi qeyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Itaŋi hiqäva-imäkqä naqä iquatä, ämaqeu miqä huizi iquatä, qu Jisasi Iquenyqe, “Suqä quvqä iiŋä-iiŋä imäkätŋqeqä” tuätqätaŋguwäŋga, Iqu kukŋuä hui kimaŋi, mätquä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iiŋä etaŋgi Pailoti iqu Iqueŋi yatŋqä äwikqe. “Änääŋgä? Kukŋuä eeqänäŋä tä Sinyqä äquvepqe, qätä mäwiyqä iŋinyä?” ");
INSERT INTO mcr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yatŋqä i vqaŋga, Jisasi Iqu kimaŋi mätquä ikqe. Iiŋiŋqe, Pailoti iqu yäuŋuä itä, kŋuä kuapänä indqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Quväkuä ique-ique, Pasopa imäkäpiyäŋgaŋi, Israitqä iqua, ämaqä guä äkiqiyäuepqä hŋque atäuŋuä iqaŋguwäŋga, kiyapqä naqä iqu iqueŋi ewewqatmiŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jisasi Iqu Pailoti iqueqä hiŋuä iqi ätqäukqä quväukuä iqueŋi, ämaqä suqä quvqä huiziquau ämäwqätäuä, aaŋä naqänäŋä imäkqä hŋqu guä äpmamiŋqe. Iqueqä yoqe, Jisasi Baräpasi ique. ");
INSERT INTO mcr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Qokä-apäkä iqua aquvä ae äqänätaŋguwäŋga, Pailoti iqu iquau yatŋqä tiiŋä qe äwikqe. “Henyqä pätŋqä ewewqatmqä diŋqe, tquenyqä hiŋgiyä? Nyi Jisasi Baräpasi ique ewewqatmqätanä, ä Jisasi, ‘Kraisi Iqueqä’ ätätqäŋuwä Ique ewewqatmqätanä?” ");
INSERT INTO mcr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Israitqä iquau miqä iqua, Jisasi Iqu yoqä naqä metqätaŋgqeŋqä äwqä quvqä imäkäpu ätuma äpkuwiŋqe, Pailoti iqu näqŋqä eä, yatŋqä i äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailoti iqu zä-hawä iwäsäuqäŋqä iu pmetaŋga, iqueqä apäki kukŋuä iquenyqä tiiŋä ätätä ändowatkqe. “Nyi Ämaqä Jänäŋä Iqueŋi wätqä äqunäŋqä-qae, haŋä naqänäŋä änyiyqiyä. Iŋi si Iqueŋi, quvqä hui mitqueqä panä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iŋäqe hiqäva-imäkqä naqä iquatä, ämaqeu miqä iquatä, qu qokä-apäkiuqä kŋuä iuŋi hiŋi-hiŋi iwimäkäpu, “Baräpasi ique dowatätnä, Jisasi Ique pizqä päkiyä” tupŋqä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Itaŋi kiyapqä kiŋganäŋä iqu, iquauŋi yatŋqä aŋgumä, “Ämaqä tquaquisaŋi, nyi äkisque hewasqiyäwqatmqä hiŋgiyä?” tquaŋga, iqua maŋi tiiŋä ätukuwi. “Baräpasi iquenyqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","I tquaŋguwäŋga, Pailoti iqu yatŋqä tii äwikqe. “I etaŋgutqe, nyi Jisasi, ‘Kraisi Iqueqä’ ätätqäŋuwä Iqueŋi, äänä imäkmqeŋqä eŋgiyä?” I tquaŋga, iqua kimaŋi, “Iqueŋi, zä-huätatä hueyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ga Pailoti iqu ämävauqe, “Suŋqäwä? Iqu suqä quvqä äki imäkätŋqäwä?” ätukqe. Iiŋä ae ätquaŋga, qu aaŋä yäŋänäqŋqä ätkuwi. “Iqueŋi, zä-huätatä hueyä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailoti iqu qokä-apäki, iqueuä kukŋui qätä mäwiyqä ipu, mäkä naqä timäutŋqänäŋä ikutäŋgaŋgi näqŋqä eäqe, iqu eqä hui ämeqe, iqueqä hipae, qokä-apäkä iquauqä hiŋuä iqisa asŋä äqäŋgqe. Iiŋä itä, tiiŋä ätukqe. “Ämaqä Tqu äpäkonätä häŋeqä iuätŋqä iqe, ŋqä hmanjqä. Ii hiqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","I tquaŋga kimaŋi, qokä-apäkä eeqänäŋi, “Quvqä tä, nesä, näyaqä ymeqä-pqä iquatäŋi, qäyä witätŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","I tquaŋguwitaŋi, iqu Baräpasi iqueŋi, iquauŋqä hiŋuinä qe äqunäwatkqe. Itaŋga Jisasi Iqueŋi, mäkä-iqä iqua täuatätäu iqaŋguwäŋga, iqu ämaqä zä-huätatä huepŋqä iquau äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kiyapqä kiŋganäŋä iqueqä ämaqä mäkä-iqä iqua, Jisasi Iqueŋi, kiyapqäeqä aŋä iuŋqä ätuma äwäpu, mäkä-iqä huizi iquau-mända ique qäuiqä mamäupŋqä tääqä ätuätumakuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iŋgaŋi iqua Ique mändi äkittqiyäpu, quaŋgä ämiqä naqä eŋqä-pa hiätŋqä tii imäkkuwi. Iqueqä gquä quäuqä huätä äquvätäpu, häŋesqä hŋqu ämiqä naqä iqua ipnmiŋuwä itaŋi ämepu äwiptkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Itaŋga guä yäŋä-täŋi äkuiyäpu, nätmatqä ämiqä naqä iquauqä yŋŋa eŋqä-pa imäkäpu, Iqueqä nyuäŋiu ämuasmäwiyäpu, jävqä hŋqu ämepu Iqueqä hipa ämuaŋgisa a ämuätäpu, qoŋä äwoktäupu, “Israitqä iquauqä Ämiqä Iquki, ne haqeqä ämakmäuqunä” ätuäpu, tä sisäwqä äwimiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Qu quaŋgä e iwimäkäpiyitaŋi, Ique makukuä äwquväuqutäpu, jävqä iqueqä hipa iu a ämuätukuwi ämotaupu, Iqueqä nyuäŋiu äpäkmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Qu mändi e äkittqiyepiyitaŋi, gquä häŋesqe huätä äquvätäpu, Iqueqä qäki aŋgi äwiyätäpu, zä-huätatä huepŋqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Qu e äwäpiyäŋgaŋi, mäkä-iqä iqua, ämaqä aŋä-himqä Sairini iutaŋä Saimonä ique hiŋuä äqumbiyi, iqu Jisasi Iqu zä-huätatä hunätŋqe, äma wätŋqä kukŋuä ätuätumakuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Qu äupiyi, aŋä yoqä Golketa qunätaŋgqä iu ätimäukuwi. Yoqä iiŋi, kiqä quati, ‘Ämaqä nyuäŋä-yäŋiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iqiŋi, täŋä-huŋqe Iqueqä huiwiuŋi wipti iqiyätŋqe, qu Jisasi Iqu nätŋqä diŋqe, wainqä-eqetä, marasinqä zä iqetä yuqui-yaqui imäkäpu äwikuwi. Iqu mäŋgä-mäŋgäŋqä itä, maŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mäkä-iqä iqua Ique zä-huätatä ae äuepiyi, Iqueqä gquetä, ämuasmäŋqetä iwäsäupu, kikiŋä mapŋqä häŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Iqi häŋä ämiqämanäpu, ämaqä hui äpäpu, Ique yätamäkqä vqäŋqä hiŋuä äqumbu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iqueqä nyuäŋä haqeqäŋi, qu kukŋuä ämitkuwä iqu ätäpu äqiyekuwi. “Tä Jisasi, Israitqä iquauqä Ämiqä Naqä Iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasi Iqu-täŋä qäqiqiŋi, ämaqä äpäsäsinyä quwä-meqä hŋquaquiŋi, zä-huätatä äuekuwi. Hŋqueŋi, hipa ämuaŋgisa äuepu, hŋqueŋi qunamäuqäŋgisa äuekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ämaqä iqi äpäwäpiyi, qu nyuäŋä ptqä äqiyäpu, Iqueŋi tä sisäwqä äväpu, tii ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Si, ‘Nyi hiqäva-imäkqä aŋi äpnetmä, hiunji hŋquaqui-hŋquenyä aŋgi mätqunjqä’ tqä-qukiyqä. Iŋi Si Tqä-täuä yätamäkqä yqä inyä. Si Goti Hanjuwä Iqueqä Ymeqä Iquki etaŋgutqe, zä-huätatä äunäŋitaŋi, äyaqäsqäŋga biyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, qokä-apäkä miqä huiziquatäŋi, qu-pqe Ique tä sisäwqä inä äväpu, tii ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Iqu ämaqä huiziuŋi häŋä iqumuatätŋqä-qe, Iqueqä-kiuäŋi häŋä miqumuatŋqä iqiyä. Iqu Israitqä iquau Miqä Naqä-qu etaŋgutqe, ga zä-huätatä äunäŋqetaŋi, äyaqäsqäŋga pqaŋguti, ne Iquenyqä quuvqä hiqiyatuŋquänänyä. ");
INSERT INTO mcr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iqu ‘Nyi Goti Hanjuwä Iqueqä Ymeqä Iqunjqä’ ätätŋqeqä. Iŋi Iqu Goti Hanjuwä Iquenyqä quuvqä eqiyätŋqä Iquvqä. Goti Iqu Iquenyqä äwiŋgaŋgutqe, täŋga yätamäkqä vätŋqänänjqä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ämaqä quwä-meqä Jisasi Iqu-täŋä qäqiqi äuekuwä iquaqu-pqe inä itquesinyä, kukŋuä quvqä ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Itaŋi hiunji quemisqäŋgaŋi, qua eeqänäŋä iuŋi, hea äwäkqe. Mäptqä äwitŋqä qäqä ti pmetaŋga, we aŋgi äuŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mäptqä äwitŋqä qäqä ti pmetaŋgaŋi, Jisasi Iqu tääqä yäŋänäqŋqe, tii ätkqe. “Eli! Eli! Lema säpäktani?” Kiqä kukŋuä quati tiiŋi. “Ŋqä Goti Iqukiyä! Ŋqä Goti Iqukiyä! Si suŋqä nyivquatämäunyä?” ");
INSERT INTO mcr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ämaqä qäqiqi ätqäumiŋuwä hŋqua, kukŋuä tä qätä äwipiyi, “Ämaqä Tqu, Laisa iquenyqä tääqä ätqiyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Itaŋga maqänäŋi, ämaqä qutaŋä hŋqu tnäŋä äwäqe, yaaŋuä hŋqu ämeqe, wainqä-eqä iu äyeqe, wainqä maŋguä iŋgaŋga, iqu jävqä iu ävätäutä, Jisasi Iqu nätŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","I imäkätqätaŋga, huizi iqua Iqueŋi, “Qaiyä” ätukuwi. “Laisa iqu äpätä Iqueŋi yätamäkqä äväŋqutiyä, mävqä yäŋqutiyä? Hiŋuä äqänanä äpmenä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iŋgaŋi Jisasi Iqu tääqä yäŋänäqŋqä aŋgumä ätäqe, Iqueqä hindŋä-meqe äwquatämäuqe, äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Asä qäŋgaŋi, yuä naqänäŋä hiqäva-imäkqä aŋä yäpä iŋgisa imaknmiŋqä iqu, hituŋuä yätuta iŋgi-iŋgi äpkŋga äpäwiqe, hŋquaqu qe imäkŋgqe. Itaŋga quae yäuŋuä-yäuŋuä itä, hikä naqä hŋqua qe äqiyämisqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Itaŋi hikä hovqä ämaqä pizqä emiŋuwä iuŋi, Goti Iqu qŋqaŋä äutäutä, Iqueqä ämaqä ae äpäkoŋguwä hŋquau aŋgi ävauqumuatkqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Qu qua äptekuwä iu ävämapiyi, qänakndaŋi Jisasi Iqu aŋgumä ävauqaŋga, qu Goti Hanjuwä Iqueqä aŋä-himqä Jerusälemä yäpä iŋgisa äpaqukuwi. Iqiŋi, ämaqä kuapänäŋä iqua, iquauŋi hiŋuä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mäkä-iqä Jisasi Ique hiŋuä äqumbu äpmamiŋuwä iquatä, quwqä ämiqä iqutä, qua yäuŋuä-yäuŋuä iqaŋgqetä, nätmatqä ätimäuqaŋgqetä hiŋuä äqumbiyi, zä kiiŋä wiŋgaŋgi, tiiŋä ätŋguwi. “Naqä-qakuänänjqä. Ämaqä Tqu, Goti Hanjuwä Iqueqä Ymeqä Iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Qu Jisasi Ique i itqueqaŋguwäŋga, apäkä kuapänäŋä iua-pqe, kiŋä qäqiqi ätqäupu, hiŋuä inä äqunmiŋuwi. Qu Jisasi Iqu Galili iu ävämeqaŋgqetaŋi, Ique yätamäkqä äväpu, qänaki äwivändkuwä iuayi. ");
INSERT INTO mcr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iuauqä awä iqisaŋi, tä Mäliya aŋä-himqä Maktälataŋä iiyi. Itaŋga huizi, Mäliya Jemisi iqueqätä Josepä iqueqätä känaiyi. Itaŋga huizi, Sepri iqueqä ymeqä iquaquiyqä känaiyi. ");
INSERT INTO mcr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mäptqä äwitŋqä ti pmetaŋgaŋi, mbqä-täŋä hŋqu aŋä-himqä Arämatiya iutaŋä, iqueqä yoqe Josepä iqu äpkqe. Iqu Jisasi Iqueqä kukŋuä iu qänaknä iqä-que. ");
INSERT INTO mcr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iqu Pailoti iquenyqä äwäqe, yatŋqä ävätä, “Nyi Jisasi Iqueqä huiwi, äma umqä hiŋuinä ŋqinyä” ätukqe. I tquaŋga, Pailoti iqu iqueqä mäkä-iqä iqua, Jisasi Iqueuä huiwi ique wipŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Itaŋi Josepä iqu huiwi äma äwäqe, yuä äŋguänäŋä quäuqä hŋqu ämetä, huäqä äutäqe, iqueqä-kiuä ptŋqäŋqä mŋä häŋä ätäŋäkqä ique yäpä iŋgisa qe ekqe. Iiŋä ae eäqe, iqu hikä naqänäŋä hŋque, huaqä-huaqä ämiqa äpätä, hovqä maŋä iu äpmäveqa äukqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mäliya Maktälataŋä iisä, Mäliya huizi iisä, iuaqu ämaqä qua ptnätaŋgqä qäqiqi hiŋuä äqunyinyä äpmamiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hiunji nätmatqä Sämbatqä hapä pmeqäŋgaŋqä hukiki imäkqä iqu qäpu eäqetaŋi, awiŋgaŋi hiqäva-imäkqä naqä iquatä, Parisi iquatä, Pailoti iqutä kukŋuä tpŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Qu iqueŋi, tiiŋä qe ätukuwi. “Ämaqä naqä iqukiyä. Ne Ämaqä Quaŋgä-tqä Iqueqä kukŋuä hŋquenyqä kŋuä äneyqiyä. Iqu yqänä äpmeqäŋgaŋi, ‘Hiunji hŋquaqui-hŋque päwqaŋgaŋi, Nyi aŋgumä ävamniqeqä’ ätkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iŋi ämaqä qua ptŋqä täuŋi, hiunji hŋquaqui-hŋqueŋäŋgaŋqe, qu qŋqaŋä äŋguänä ptäuepŋqä tuätŋqeqä. Iqueqä wäuŋuäŋqä ämotquetŋqä iqua äpäpu, Iqueqä huiwi quwä äma äwäpu, qokä-apäkä iquauŋi, ‘Iqu qua iutaŋi aŋgumä ae ävauqeqä’ ätupqe, ii quvqeqä. Quaŋgä änyä-häŋä e ätpqe, qu Iqu kukŋuä quaŋgä hiŋuiqänä ätmiŋqä iuŋi, ämäwqätäupŋqäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kimaŋi Pailoti iqu iquauŋi, tiiŋä qe ätukqe. “Ämaqä qua äptnäŋqä iuŋi hiŋuä äqumbu tqäupŋqe, mäkä-iqä hŋquau itmepu, hovqä iu pmäukuä yäŋänäqŋqä ptäpŋqä hiqä eŋqä iunä imäkpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iqu e tquaŋga, iqua Ique qua äptekuwä iuŋqä äupiyi, hikä qua hovqä iu ptänätaŋgqä iqueŋi hiqŋqe pmua imäkäpu, mäkä-iqä iqua hiŋuä äqumbu tqäutpŋqä ätqätekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sämbatqä hiunji hapä pmeqä ae äpäwqaŋga, hiunji kiŋganäŋä iqueŋi, mäptqä timäutŋqä qäqä etaŋga, Mäliya Maktälataŋä iisä, Mäliya huizi iisä, iuaqu qua äptekuwiu hiŋuä qunyiyŋqä qe äpkiyi. ");
INSERT INTO mcr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I pätqätaŋgiyäŋga maqänäŋi, ekä naqänäŋä hŋqu ikqe. Ii tiiŋä etaŋgiyä. Naqä Iqueqä eŋätqä hŋqu qäukuä yätuta äquvepätä, hikä ique kunmä-kunmä ämiqe, hikä iqueqä haqeqi äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eŋätqä iquesaŋi we nyuauä iqäqä eŋqä-paŋä äuŋgqe. Itaŋga iqueqä gquä quäuqä, qäpaiqä hiwiyä-häukuä eŋqä-paŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mäkä-iqä, hiŋuä äqumbu ätqäumiŋuwä iqua, qu iquenyqä zä ipu, yäuŋuä-yäuŋuä ipu, ämaqä ae äpäkoŋguwä eŋqä-paŋä-qua ekuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Apäkä iuaqu äwimeqaŋgiyäŋga, eŋätqä iqu iuaquiŋi ätukqe. “Qe zä miqä panyinyqä. Nyi näqŋqeqä. Qe Jisasi, zä-huätatä äuequwä Iquenyqä qävqä iyŋqä äquvepqinyqä. ");
INSERT INTO mcr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iqu hiŋuiqänä ätkqä-pa, ae ävauqeqä. Täqi mäwiqä eänä. Iqu äwiŋqeu qunyiyäŋqä binyqä. ");
INSERT INTO mcr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Itaŋga qe maqänä äwäsinyä, Iqueqä wäuŋuäŋqä ämotquetŋqä iquau tiiŋä suinyqä. ‘Iqu qua äptequwä iutaŋi ae ävauqeqä. Tiiŋä-pqä inänjqä. Iqu heŋi hiŋuiqä eväma, Galili iuŋqä äwqiyä. He Ique hiŋui, iu qumbŋqäuä ätqiyä’ suinyqä. Nyi kukŋuä tä hitmqä äquvepqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iuaqu zä kiiŋä äwiŋgqä-qe, yeeqä naqänäŋä ikiyi. Maqänäŋi qua äptekuwä iu ävämaŋi, Iqueqä ämaqä iquau suiyŋqä tnäŋä qe äukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hänaqä awä iqiŋi, Jisasi Iqu iuaqui äwimeqe, “Ziŋuitänjqä” ätukqe. Itaŋi iuaqu Iqu-täŋä qäqiqi äwiyi, Iqueqä yukiu a äkiqätäsinyä, Ique qoŋä äwoktäukiyi. ");
INSERT INTO mcr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iŋgaŋi Jisasi Iqu iuaqui tiiŋä qe ätukqe. “Qe zä miqä panyinyqä. Äwäsinyä, Ŋqä guäkau suinyqä. Qu Galiliuŋqä äwäpu, iuŋi hiŋuä ŋqämbŋqeuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Apäkä iuaqu yqänä wätqätaŋgiyäŋga, mäkä-iqä, hiŋuä äqumbu ätqäumiŋuwä iutaŋä hŋqua, Jerusälemä yäpä iŋgisa äpepiyi, hiqäva-imäkqä naqä iquau, nätmatqä eeqänäŋä i timäuqaŋgqeŋqä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Itaŋi hiqäva-imäkqä naqä iquatä, ämaqeu miqä huiziquatä aquvä äqänäpu kukŋuä imäkpiyi, mäkä-iqä iquau mbqä kuapänäŋä äväpu, tii ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“He tiiŋä tquäpŋqe. ‘Iqueqä wäuŋuäŋqä ämotquetŋqä iqua heatqäŋga äpäpu, ne hiqaqä witauŋgua, Iqueqä huiwi quwä äma äwquwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Itaŋga kiyapqä kiŋganäŋä iqu kukŋuä tä qätä wiyqaŋga, haŋä-iqä memeqä yätŋqä, ne iqueŋi kukŋuä haŋuä ätuätanä imäkatuŋqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Itaŋi mäkä-iqä iqua mbqä ämapiyi, ämaqä naqä iqua ätukuwä-pa ikuwi. Iŋi Israitqä iquauqä awä iqisaŋi, qu kukŋuä tä ätqa äpätqäŋuwi, täŋga täsuänä. ");
INSERT INTO mcr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä 11 iqua, qua Galiliuŋqä qaŋä äwäpu, qoqoŋä Jisasi Iqu ätukqä iu ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iqiŋi qu Ique hiŋuä äqumbiyi, qoŋä äwoktäupu, Iqueqä yoqe haqeu ämamäukuwi. Iŋäqe qutaŋä hŋqua Iqueŋqe, kŋuä hŋquaqu indqänmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisasi Iqu qäqiqi äpätä, iquauŋi tiiŋä ätukqe. “Nätmatqä eeqänäŋä qäukuä iutä, qua täutä mimqe, Goti Hanjuwä Iqu Nyi yoqä naqetä, yäŋänäqŋqetä ändapqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iiŋiŋqe, he hueqä-himqä eeqänäŋä iuŋqä äwäpu, qokä-apäkä iuŋi, Nyaqä ämaqä hipŋqä motquapiyä. He iquauŋi, Apiqueqä yoqeu, Ymeqä Iqueqä yoqeu, Dŋä Äŋguä Iqueqä yoqeuta, asŋä qäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Itaŋga qu qänaknä ipŋqä diŋqe, kukŋuä eeqänäŋä Nyi ‘Iiŋä-iiŋä imäkpnuwäŋqeqä’ etqäqe, he ämotqueqäpŋqeqä. Kukŋuä tiiŋiŋqä kŋuä metpŋqänänyä. Qua tqu qäpu heniqeŋqe, Nyi hiunji eeqänäŋi, hesä anä pmetmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kukŋuä äŋguä we-huŋqä-täŋä tä, Goti Iqueqä Ymeqä Jisasi Kraisi Iqueŋqä kukŋuä nyuäŋiyi. ");
INSERT INTO mcr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Itaŋgaŋi Goti Iqueqä kukŋuä hiŋuä-tqä Asayä iqu, ätätä tuwaŋuä äqäkqä-panä ekqe. Iqu tii ätkqe. “Qätä wipiyä. Ämaqä Nyaqä kukŋuä ämapqä hŋque, Si hiŋuiqä kimetŋqä ändowatqänä. Sinyqä hänaqä näwinyä imäuetŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ämaqä hŋqu aŋä avqŋqä näunda maŋä yäŋänäqŋqä tii ätätqäuä. ‘Naqä Iqueqä hänaqe, näwinyä imäkpiyä. Itaŋga hänaqe, äŋguä jänä imäuepu, ga Iqu iu pätŋqänänyä!’” ");
INSERT INTO mcr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iiŋä etaŋgi Jonä iqu aŋä avqŋqä iunda ätimäuä äpme, ämaqä asŋä äqiyätä, qokä-apäkä iuŋi, kukŋuä tii ätumiŋqe. “Goti Iqu äwqä haŋuä imäknätä, heyaqä suqä quvqe huätä maemäutŋqä iiŋqe, heqä kŋuä äkunmäknäpu, hiqä suqä quvqe ävquatämäupu, asŋä mapiyä” ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Itaŋgaŋi ämaqä, qua Jutiyataŋä kuapänäŋitä, ä aŋä-himqä Jerusälemä pmeqetä, Jonä iqu kukŋuä tqaŋgqeŋqä äpäpu, qätä äwimiŋuwi. Iwä qu quwqä suqä quvqeŋqä awä tqaŋguwäŋga, Jonä iqu eqä Jotänäŋi, asŋä äwqäkqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jonä iqueqä qäki, kametqä aa äyäuä, itaŋga yaqueqä huiwi, aquvä ämuäsämäumiŋqe. Iqueqä ymisaŋi, awikätä wiyä-mäkŋuä aŋitä ätetä, änmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Itaŋgaŋi iqu kukŋuä awä tii ätumiŋqe. “Ämaqä nyaqä tuwiu qänaki pätŋqä Iqu, Naqä nyi ämaŋqutäuä yänäŋä Iquvi. Nyi Iqutä asänäŋä ma, oee. Ä nyi äŋguänäŋunä ma, qua iqi äpäwitmä, Iqueä yukä ämuasmäŋqä guä ämäsänäŋqe, huätä ewamqe, änä maeqä eŋä. ");
INSERT INTO mcr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nyi asŋi, qanyä eqetänä eqiyätŋqe. Mä Iqu asŋi, Goti Iqueqä Dŋä Äŋguitänä eqiyäniqeqä” ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Qu iiŋä itqätaŋguwäŋgaŋi, Jisasi Iqu aŋä-himqä Nasäretqä, qua Galili iuta äpkqe. Iqu äpqaŋga, Jonä iqu, Iqueŋi eqä Jotänäŋi, asŋä äwqäkqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisasi Iqu eqä mäunda ti iwuŋga äpeyätäqäŋgaŋi, Iqu qäukuä qŋqaŋä hutäŋgaŋgi äquŋgqe. Qŋqaŋä äutänäqe, Dŋä Äŋguä Iqu, Iquenyŋqä yŋŋä-heeqä eŋqä-paŋä pqaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iŋgaŋi kukŋuä qäukuä haqä yätutaŋi, “Si Ŋqä Ymeqä naqä-qakuä Iqukiyqä. Nyi Sinyŋqä aaŋä kuapänä änyinätqänä” tqaŋgi äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iŋga qäŋgaŋi, Dŋä Äŋguä Iqu, Jisasi Iqueŋi aŋä avqŋqä duŋqä ätuma äukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisasi Iqu nämŋi, hiunji 40 äpmakqe. Iqu hiunji e pmetaŋgaŋi, Setänä, Goti Iqueqä himä-wiuŋqä iqu, Jisasi Iqu suqä quvqä imäkätŋqä yamwiqä äwimiŋqe. Yŋŋä-täŋä hiveqä-yaqueqä hiqiyqä iquatänä pmetaŋgi, eŋätqä iqua äpäpu, yätamäkqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jonä iqu guä ae äpmetaŋga, Jisasi Iqu qua Galili ätimäuqe, Goti Iqueä kukŋuä we-huŋqä-täŋiŋqä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Goti Iqu kukŋuä ätätä ekqe, tä qäŋga qe ätimäuqiyä. Goti Iqunä miqe, qäqiqi äpqi. Heqä kŋuä äkunmäknäpu suqä quvqeŋqä ävquatämäupu, kukŋuä äŋguä we-huŋqä-täŋä täuŋqä quuvqä heqäpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","17","Jisasi Iqu, eqä-huäŋä Galili maŋä iu ikitä, ämaqä hämapäkä-piqä Saimonä, ä Endru gueqi äwindäukqe. Iŋgueqi hämapäkä qaetä hämapäkä pitqätaŋginyä äqunäqe, Iqu iŋgueqiŋi, “Nyitä anä äwätanä, ga Nyi qeŋi, ämaqä-piqeŋqä näqŋqä äqesapätmä, itaŋga ämäqesquamqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","I tquaŋganä, iquaqu, hämapäkä qae iqi esinyä, Jisasi Ique qänaki äwivändkiyi. ");
INSERT INTO mcr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Itaŋga Jisasi Iqu hmbu ti äwäqe, Sepri iqueqä hikŋä Jemisi, Jonä gueqi, imätquauqä yimba iu äpmanyä, hämapäkä-piqä qae guä ktäpitqätaŋginyä äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iqu iŋgueqiŋi iqi äwimetä, tääqä tquaŋga, iquaqu kaniquesä, itaŋga ämaqä mbqäŋqä wäuŋuä anä imiŋuwä iquautä, yimba iu ävämesinyä, Ique qänaki äwivändkiyi. ");
INSERT INTO mcr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iqua aŋä-himqä Kapänamä yäpä iŋgisa ekuwi. Itaŋga Jisasi Iqu, Sämbatqä hiunji hapä pmeqä iŋgaŋi, Goti Iqueä kukŋui, aŋä aquväqŋqä iuta näqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iqueä kukŋui, qokä-apäki qätä huitaŋänäŋä äwipiyi, kŋuä kuapänä ämepu, “Iqu, ämaqä Goti Iqueqä kukŋuä-suqeŋqä näqŋqä iqua eŋqä-pa matqä danä, yoqä naqä-täŋä-qu ätqiyä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iŋgaŋi, ämaqä dŋä quvqä-täŋä aŋä aquväqŋqä yäŋgisa äpmamiŋqä hŋqu ämävauqe, awqä tii ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisasi Nasäretqätaŋä Iquki, Si squä nemäktŋqäwä? Si ne qui nemäktŋqä äpŋätanä? Nyi Sinyqe näqŋqä eŋänä. Si Goti Hanjuwä Iqueqä Ämaqä Jänänäŋä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","I tquaŋga, Jisasi Iqu, dŋä quvqä iqu kukŋuä hui matqä yätŋqä, “Qäyä eänä!” ätuätä, “Ämaqä iquesaŋi, täŋgisa huätä timäuvä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I tquaŋgaŋi, dŋä quvqä iqu, ämaqä iqueŋi vänyqä yäŋänäqŋqä ämiqe, ‘zääqä’ ätäqe, ämaqä iquesaŋi huätä qe ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iiŋä timäuqaŋgqeŋqä yäuŋä ipu, “Tä änääŋqäwä? Ämaqä Tqu, squä-täŋä-qutiyä? Iqu yäŋänäqŋqä-täŋä-qu eä, kukŋui, änyä-häŋä huitaŋä hui änatqiyä. Iinä ma, Iqu dŋä quvqä-pqä duŋi, ‘Huätä timäupiyä!’ tquaŋgqe, qu Ique qätä äwiyqäuä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Itaŋi kukŋuä Jisasi Iquenyqä, “Ii iqiyä” ätnäkiqaŋguwitaŋi, qua Galili iuŋä-pqe, maqänänä qätä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Qu aŋä aquväqŋqä iuta ätimäwaŋi, Saimonä, Endru gueqiyqä aŋiuŋqä jänänä äukuwi. Itaŋga Jemisi, Jonä gueqi qutä anä äukiyi. ");
INSERT INTO mcr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Qu Jisasi Iqueŋi, “Saimonä iqueqä apäkiyqä känai, täŋä-yaqä, huiwä dŋä tnäŋä wiyqaŋgi äwinä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iqu qätä ii äwiyäqe, iinyqä äpeyäqe, hipa a ämäwqätätä, pämä ävauqumuatkqe. Iqu ii iqaŋga, täŋä-yaqe qäpu ekqe. Itaŋga ii quŋi, ymisaŋä häkiyä äyäwqikqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mäptqä ae äquvqaŋgaŋi, ämaqä täŋä-yaqä-täŋä, ŋŋ ämaqä dŋä quvqä huitaŋä-huitaŋä tqäuqe, Jisasi Iquenyŋqä ätuma ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iŋgaŋi ämaqä aŋä-himqä iutaŋi, eeqäpnä aŋä ququawä iqi ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iŋgaŋi, täŋä-yaqä-täŋä iquauŋi, Iqu äŋguä iwimäkätä, itaŋga dŋä quvqä iquauŋi, huätä ändowatkqe. Dŋä quvqä iqua, Iquenyqä näqŋqä epiyä dutaŋi, qu Ique kukŋuä hui mätquä danä ipŋqeŋqe, Iqu iquauŋi, “Qaimbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ziŋuä matqä, hea yqänä witaŋgaŋi, Jisasi Iqu ävamämä, ämaqä maeqä kiuänäŋä imŋqä äwäqe, Goti Iquenyqä tääqä ätmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Iqu e pmetaŋga, Saimonä iqutä, iqueqä käyämaqä iquatäŋi, Jisasi Iquenyqä qävqä ikäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Qu Ique äwimapiyi, “Ämaqä eeqänäŋi, Sinyŋqä qävqä ikitqäŋäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Qu ii tquaŋguwäŋgaŋi, Jisasi Iqu, “Nyi wäuŋuä tä qeŋqä äpqä-qae, aŋä-himqä huiuŋqä-pqä inä watuŋqueqä. Ga ämaqä aŋä iuŋä-pqe, Goti Iqueä kukŋuä awä inä tumqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iiŋä etaŋgi, Iqu, qua Galili iu ikitä, quwqä aŋä aquväqŋqä iuta, Goti Iqueä kukŋui awä ätuätä, dŋä quvqeuŋi, huätä ändowatmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ämaqä wänyimäŋqä-täŋä hŋqu, Jisasi Ique äwimeqe, qoŋä äwoktäutä, “Iyää! Jisasi Iquki, yätamäkqä nyisŋqä kiŋgaŋgutqe, nyi äŋguä nyimäktŋqinyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisasi Iqu, iquenyŋqä huäqä kiiŋä wuŋgaŋgi, Iqu ämaqä iqueä huiwiu a ämitä, “Nyi, si yätamäkqä kimqä iqe, si äŋguä esŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iqu i tquaŋganä, ämaqä iqueqä wänyimäŋqe äsätä, äŋguä qe ekqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Itaŋga Jisasi Iqu, ämaqä iqueŋi maqänä ändowatätä, kukŋuä yäŋänäqŋqä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Qätä nyi! Ämaqä-pqä hŋquauŋi, Nyi tä ikimäkqeŋqe, awä mätquä panä. Hiqäva-imäkqä iquenyŋqänä äwätnä, tqä huiwi ique ämotquetnä, ga si äŋguä ikimäkqaŋgä eŋiŋqe, Mosisi iqu, ‘Ii imäkpiyä!’ ätätä ekqä-pa, hiqäva qänyä. Iiŋä iqaŋgnä dutaŋi, ämaqä eeqänäŋi sinyŋqe, ‘Iqueqä täŋä-yaqe qäpu eqeqä’ kŋuä wiyätŋqänänyä.” ");
INSERT INTO mcr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iqu ii qäyä ätquaŋgi, ämaqä iqu äwäqe, ämaqä eeqänäŋä iu iqueqä-kiuä iwimäkkqeŋqä awä ätuäkämiŋqe. Iutaŋi Jisasi Iqu aŋä-himqeuŋi mikiqä, aŋä avqŋqä imä äpmamiŋqe. Ii qäyä etaŋgi, ämaqä iŋgi-iŋgisa ätimäupu, iqi äwimamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hiunji hatŋä hmbu äpmeqe, Jisasi Iqu Kapänamäŋqä aŋgumä äukqe. Itaŋga ämaqe, “Jisasi Iqu aŋä iqi aŋgi ätimäuqiyä” tqaŋgä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iŋi ämaqä kuapänäŋi, Iquenyqä aquvä äqänäpu, aŋä iuŋi näwinyä tä äptembiyi, aŋä huä, aŋä ququawä-pqä iqiŋi kiqä ämaqenä äpmakuwi. Iŋgaŋi Iqu quŋi, Goti Iqueä kukŋui awä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Itaŋga, ämaqä hŋquaqu-hŋquaquiŋä hŋqua, ämaqä täŋä-yaqä ŋŋuä-täŋä hŋque, Iquenyqä isuäŋä äqäŋga ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ämaqä kuapänä etaŋgä, Jisasi Iquenyŋqä änä mäma mäpeyqä ipiyi, aŋä atääqä, Jisasi Iqu pmetaŋgqä iutanä ätaqäkuwi. Ii ätaqäpiyi, ämaqä iqu isuäŋiu yqänä wiqä-que, Iquenyqä guä äqiyäŋguatkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iŋgaŋi Jisasi Iqu, quwqä Iquenyqä “täŋä-yaqä huätä mamäuŋqiyä” kŋui, yäŋänäqŋqä metaŋgä äqunäqe, Iqu ämaqä iqueŋi, “Ŋqä ämaqä iquki, saqä suqä quvqe, huätä ämakmäuqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","I tquaŋga, kukŋuä-suqeŋqä näqŋqä hŋqua, qätä äwipu äpmapiyäŋgaŋi, kŋuä tii indqänmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Äi! Iqu kukŋuä tä, qäyu matqä iqiyä. Iqu Goti Ique äkittqiyeqiyä. Suqä quvqä, huätä mamäutŋqe, tqukä? Naqä-hŋqunäŋi, Goti Iqunänjqä.” ");
INSERT INTO mcr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisasi Iqu, quwqä kŋuä zä indqänmiŋuwä imŋi, näqŋqä maqänä ämeqetaŋi, tii ätukqe. “He kŋuä iiŋä di, suŋqä indqänätqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ämaqä täŋä-yaqä ŋŋuä-täŋä ique äŋguä iwimäkmqe, ‘Tqä suqä quvqe huätä ämakmäuqänä’ tquä iquta? Ä, ‘Pämä äpmetnä, tqä isuäŋi ämetnä, qaŋä uvä!’ tquä iquta? Wäuŋuä haŋä mämiqä, qeiqinyäŋi, äkisque? ");
INSERT INTO mcr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Nyi he näqŋqä epŋqe, ämetquamqänä. Ämaqeuqä Ymeqä Ekqä Iqu, qua täutaŋä suqä quvqe huätä mamäuqeŋqe, yäŋänäqŋqä-täŋä Iquvqä.” Ii ätuäqetaŋi, ämaqä täŋä-yaqä ŋŋuä-täŋä iqueŋi, “Si pämä äpmetnä, tqä isuäŋi ämetnä, tqä aŋiuŋqä uvä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I tquaŋgqeŋqä, ämaqä eeqänä hiŋuä qunätaŋguwäŋgaŋi, iqu pämä äpmeqe, iqueqä isuäŋi maqänä ämetä, äukqe. Qu hiŋuä iiŋä äqumbiyi, näwi miiqä yäŋä ipu, tii ätukuwi. “Ne nätmatqä tiiŋä hui hiŋuä mäquŋquä ituŋqueqä” ätäpu, Goti Iqueä yoqe, haqeu ämamäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisasi Iqu aŋgumä, eqä-huäŋä Galili maŋä iu äukqe. Itaŋga ämaqä kuapänä Iqueŋqä pqaŋguwäŋga, Iqu quŋi, Goti Iqueqä kukŋuiŋqä näqŋqä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisasi Iqu qaŋä äwätäqäŋgaŋi, mbqä motauqä Lipai, Aläpiyasi iqueqä hikŋä iqu, mbqä motauqä aŋiu pmetaŋgi äqunäqe, “Lipai iquki, si Nyi qänaki nyivändiyä!” ätukqe. I tquaŋgaŋi, Lipai iqu pämä ätqäuqe, Jisasi Ique qänaki äwivändkqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Itaŋgaŋi Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, Lipai iqueä aŋiu buayä gaŋguwäŋgaŋi, ämaqä mbqä motauqä kuapänäŋä hui, ä suqä quvqä imäkqä kuapänäŋitäŋi, qutä buayä anä äŋguwi. Ämaqä iiŋä iqua, Ique qänaki äwivändmiŋuwi, qu aaŋä hävemnäqŋqä iquayi. ");
INSERT INTO mcr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parisi iquautaŋä, Goti Iqueqä kukŋuä-suqeŋqä näqŋqä hŋqua, Jisasi Iqu, mbqä motauqä iquatä, ä suqä quvqä imäkqä iquatä, buayä anä gaŋgi äqumbiyi, qu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau, yatŋqä tii äwikuwi. “Jisasi Iqu mbqä motauqä iquatä, suqä quvqä imäkqä iquatäŋi, buayä anäŋi, suŋqä äŋgiyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Qu yatŋqä ii vqaŋgä äwiyäqe, Jisasi Iqu tii ätukqe. “Ämaqä täŋä-yaqä maeqä äŋguä iqua, duuta iquauŋqä mäwqä ipnä. Ämaqä täŋä-yaqä-täŋä iquanä, iquauŋqä upnä. Iiŋä eŋqä-paŋi, Nyi ämaqä suqä quvqä mimäkqä iquaŋqä tääqä tmqä mapqä iqäqe. Nyi ämaqä suqä quvqä imäkqä iquauŋqä äpqe.” ");
INSERT INTO mcr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jonä iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, Parisi iquatä, Goti Iqueä kukŋuä-suqeu qänaknä ipu, ymisaŋä maŋqä pmetaŋgä, ämaqä hui Jisasi Iquenyqä äppiyi, yatŋqä tii äwikuwi. “Jonä iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, Parisi iquauqä iquatäŋi, ymisaŋä maŋqä äpmeŋäuä. Itaŋga saqä iqua, iiŋi miqe, suŋqäwä?” ");
INSERT INTO mcr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kimaŋi, Jisasi Iqu tii ätukqe. “Ämaqä hŋqu apäkä metŋqä itä, ämaqeŋqä tääqä tqaŋgi, ätimäupqe, qu ymisaŋä maŋqä pmeqätanä? Iqu anä epiyi, qu ii mimäkqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Qänakndaŋi, ämaqä apäkä ämetqä ique ätuma uwqaŋguwäŋgaŋi, qu ymisaŋä maŋqe, iŋganä pmapnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ii suqä tiiŋä eŋqä-paŋiyi. Ämaqe, yuä änyä-häŋi ämepu, yuä yäuä äpknätaŋgqeu, guä mäktäpiqä ipnä. Ii imäkpqä iuŋi, asŋä äqäpqä, ga ye itqaŋgaŋi, yuä häŋi äväumetä, yäuä duŋi naqänäŋä pknätŋqä imäkqa wäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tiiŋä-pqä inänji. Wainqä-eqä änyä-häŋi, yaqueqä huiwä häkä yäuä iu maŋguä mequatimäuqä danä ipnä. Qu qätäyqä equatimäupqe, wainqä-eqe maŋguä iŋga äpeyätä, yaqueqä huiwä iiŋi opnätä, ga eqetä, huiwitäŋi, qui imäknyinyiyi. Iiŋiŋqe, wainqä-eqä änyä-häŋi, kiqä yaqueqä huiwä häkä änyä-häŋä iunä equatimepnuwi.” ");
INSERT INTO mcr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, Sämbatqä hiunji hapä pmeqäŋga, kuä-witqä wäuŋuä iŋgäwätaŋgqä iu äukuwi. Itaŋga Iqueqä ämaqä iqua, kuä-witqä hui iwakkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ii iqaŋguwiŋqä, Parisi iqua Jisasi Iqueŋi, “Hiŋuä qunyä! Tqä ämaqä iqua, neyaqä Sämbatqä hiunji hapä pmeqä suqeu qänaki miqe, suŋqä iqäuä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","I tquaŋguwäŋga, Jisasi Iqu ämävauqe tii ätukqe. “Dewiti iqutä, iqueqä ämaqä iquatä, buayä dä vqaŋga imäkkuwiŋqe, he a matäuqä itqäŋuwätanä? ");
INSERT INTO mcr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tiiŋä etaŋgi. Apiata iqu, hiqäva-imäkqä naqä pmetaŋga, Dewiti iqu Goti Iqueä aŋiu äpeyätä, bretqä Goti Iqueä yoqe ätnä witaŋgqe ämetä, äŋgqe. Neqä suqä duŋi, ämaqä Goti Iquenyqä hiqäva-imäkqä iquanä äŋqe qäyä etaŋgi, iqu änätä, iqueqä ämaqä iquau-pqe inä äwikqe.” ");
INSERT INTO mcr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iŋgaŋi Jisasi Iqu tii ätukqe. “Sämbatqä hiunji hapä pmeqä iqu, Goti Iqu, ämaqeu yätamäkqä vätŋqä imäkkqä iiyi. Ä ämaqe, Sämbatqä ique yätamäkqä wipŋqä mimäkqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iiŋä etaŋgi, Ämaqeuqä Ymeqä Ekqä Iqu, Sämbatqeu Ämiqä Iquvi.” ");
INSERT INTO mcr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Itaŋga Jisasi Iqu aŋä aquväqŋqeu aŋgumä äpaqukqe. Aŋä iuŋi, ämaqä hipa hŋgiŋi ŋŋuä-täŋä hŋqu äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iŋgaŋi, Sämbatqä hiunji hapä pmeqäŋgayqae, ämaqä hui Jisasi Iquenyqe, “Iqu ämaqä hipa ŋŋuä-täŋä iqueŋi, äŋguä imäkäŋquti, ä mimäkqä yäŋqutiyä” tpu ikuwi. Iqu äŋguä wimäkqaŋgutqe, “Suqä quvqä imäkqiyä” ätäpu, kukŋuä mitpnuwäŋqeŋqä hiŋuä äqumbu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","4","Itaŋgaŋi Jisasi Iqu ämaqä hipa ŋŋuä-täŋä iqueŋi, “Si täqiŋqä biyä!” ätuäqetaŋi, ämaqeu yatŋqä tii äwikqe. “Neqä suqä Sämbatqäŋgaŋqe, äänä ätnä? Ämaqä huiu yätamäkqä vqäŋqä ätnä, ä qui imäkqäŋqä ätnä? Ämaqä hŋque häŋä iqumuatqäŋqä ätnä, ä pizqä päsqäŋqä ätnänä?” ätukqe. I tquaŋgqeŋqä, iqua kukŋuä hui matqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Qu kŋui, quwqä äwiŋqä dunä metaŋgä äqunätä yeeqä miqä, äwqä tnäŋitä hiŋuitänä hiŋuä äqunäkiqetaŋi, ämaqä iqueŋi, “Tqä hipae, hiyaepä iyä!” ätukqe. Itaŋi ämaqä iqu hipae hiyaepä iqaŋga, iqueqä hipae äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I äqumbiyi, Parisi iqua aŋä aquväqŋqä iutaŋi ävämapiyi, Jisasi Ique äpäkpŋqä diŋqä, ämiqä naqä Heroti iqueŋqä äwinyämiŋqä iquatä, kukŋuä ätipäqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Itaŋga Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, aŋä iuŋi äväma, eqä-huäŋä Galiliŋqä uwqaŋguwäŋga, ämaqä kuapänä, Ique qänaki äwivändkuwi. Qu qua Galili pmeqä, qua Jutiya pmeqä, aŋä-himqä Jerusälemä pmeqä, qua Itumeä pmeqä, eqä Jotänä yätäqä-hŋgisa pmeqä, aŋä-himqä Tayätä, Saitonätä qäqiqi pmeqe, kuapänäŋi, “Jisasi Iqu, nätmatqä iiŋä hui imäkqiyä” tqaŋgä qätä äwipiyiŋqä, ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ämaqä kuapänäŋä etaŋguwiŋqä, Jisasi Iqu, Iqueqä ämaqä iquauŋi tii atukqe. “Ämaqä kuapänäŋi, Nyi mambutmäuqä da ipŋqänä, he Nyinyqä yimba hŋqu-ganä näwi maepiyä. Ga qokä-apäkä kuapänä äkippisäŋgaŋgpqe, iwä Nyi yimbaeu ikuapmämi, kukŋui iuta tmniŋqänänyä.” ");
INSERT INTO mcr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iqu ämaqä täŋä-yaqä kuapänä äŋguä iwimäkqaŋgqeŋqä, ga täŋä-yaqä huizi iquauŋi, Ique itmaqämbŋqeŋqä, Iqu-täŋä iqi änäänä äkippisänmiŋuwi. Iiŋä äqunäqe, Iqu yimbaŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Itaŋga dŋä quvqä ämaqeu ätqäuŋuwä iqua, Jisasi Ique hiŋuä äqumbiyäŋgaŋi, qu qoŋä äwoktäupu, maŋä tii ätmiŋuwi. “Si Goti Iqueqä Ymeqä Iqukiyqä!” ");
INSERT INTO mcr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Itaŋga Jisasi Iqu dŋä quvqä iquauŋi, kukŋuä yäŋänäqŋqä tii ätukqe. “He Nyiŋqe, ‘Iiŋä Iqueyqe,’ awä matqä pambiyä!” ");
INSERT INTO mcr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Itaŋgaŋi Jisasi Iqu qoqoŋä yätuŋqä äyäqe, ämaqä hŋquau Iqueqä äwiŋqä iutanä, “Eä eänä” tquaŋga, qu Iqueŋqä ekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ique i wimeqaŋguwäŋga, Iqu ämaqä 12 iquaunä atäuŋuä ikqe. Itaŋga Iqu iquauŋi, yoqe, “Aposälqäuä” änyuätkqe. Yoqä iqueqä qakui tii etaŋgi, ‘ändowatqä iquae’. Iqua Iqutä anä ikipu äpmapu, itaŋga Iqu iquauŋi, wäuŋuä hŋquaquiŋqä ändowatätŋqä äwiŋgqe. Wäuŋuä hŋqu, iqua Goti Iqueä kukŋuä äma awä täkiqä iqueyi. ");
INSERT INTO mcr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wäuŋuä huiziqu, iqua yoqä naqä Iquesa ämepu, dŋä quvqeuŋi huätä mamäuqä iqueyi. ");
INSERT INTO mcr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Itaŋga tä, ämaqä 12, Iqu itmakqä iquayi. Saimonä iqueŋi, “Pitäuä” änyuätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Itaŋga Sepri iqueqä hikŋä Jemisi, Jonä gueqiŋi, yoqä “Bonäŋgesi” änyuätkqe. Yoqä iqueqä qakui, ‘käkaqä eŋqä-paŋä-quaquvi.’ ");
INSERT INTO mcr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Itaŋga Iqu, Endru ique, Pilipä ique, ä Batromi ique, Matiu ique, ŋŋ Tomasi ique, Aläpiyasi iqueqä hikŋä Jemisi ique, Tatiyusi ique, Saimonä Selotqä iquautaŋä ique, itaŋga Jutasi Iskariotitaŋä, Jisasi Iquenyqä täkqä ätukqä ique, iquayi. ");
INSERT INTO mcr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Itaŋga Jisasi Iqu aŋä hŋque äpaquvä pmetaŋga, ämaqä kuapänä aŋgumä aquvä qäŋgaŋguwitaŋi, Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatäŋi, buayä änä yasämä maŋqä da ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisasi Iqueqä känaisä, käŋguäkatä, Iqueŋqä iiŋä tqaŋgä qätä äwipiyi, qu, “Iqu qämä-qämä iqiyä” ätnäpu, itmapŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Itaŋga kukŋuä-suqeŋqä näqŋqä Jerusälemä iuta äpkuwä iqua, “Peŋqä iquauqä naqä Belsäpulä iqu, Jisasi Iqueŋi äminyasäuqaŋgi, dŋä quvqä huiziquau huätäŋi, iuta ändowatätqänä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Itaŋga Jisasi Iqu iquau tääqä ätuätumeqe, kukŋuä ktqä tii ätukqe. “Setänä, Goti Iqueqä himä-wiuŋqä iqu, iqueqä-kiuä huätä äänä dowatnätŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Itaŋga qua naqänäŋä hŋquesaŋä ämaqe, quwqä-quwä iwäsänäpu mäkä äuŋgpi, qu yäŋänäqŋqä matqäuqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Itaŋga hueqä-himqä hŋquesaŋä iwäsänäpu, quwqä-quwä mäkä äuŋgpi, qu yäŋänäqŋqä matqäuqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iŋi Setänä iqu, iqueqä-kiuä mäkä äpäkŋgqe, ga iqueqä dŋä iqua-pqe, ipipiyqä iwäsänäpu mäkä äuŋgpi, iutaŋi iqu yqänä mäpmeqä, qäpu hiänä. ");
INSERT INTO mcr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Itaŋga quwä-meqä hŋqu, ämaqä yäŋänäqŋqä hŋqueä aŋiuŋi otasqiyätä, iqueqä nätmatqä mämeqä da yänä. Ämaqä yäŋänäqŋqä iqueŋi, guä ganä äkiqiyeqe, iŋgaŋi ämaqä iqueä aŋiuŋi otasqiyätä nätmatqä ämenä. ");
INSERT INTO mcr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iiŋä etaŋgi, Nyi kukŋuä naqä-quäkuänäŋi, tii etmqe. Ämaqä suqä quvqä huitaŋä-huitaŋä imäkäpu, itaŋga ämaqeuŋqä kukŋuä quvqä ätämipqe, Goti Iqu äwqä haŋuä imäknätä, quwqä quvqe huätä muämäuniqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Itaŋga ämaqä hŋqu, Dŋä Äŋguä Iquenyqä qui kukŋuä ätätä, Ique äkittqiyemitätqe, Goti Iqu suqä quvqä iiŋi, äwqä haŋuä mimäkŋqä itä, huätä mämuämäuqä yäniqe. Suqä quvqä iiŋi, hea ique-ique yqänä i witäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisasi Iqu i ätkqe, iqua Iquenyqe, “Dŋä quvqä-täŋä-queqä” tätqätaŋguwiŋqä, ii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iŋgaŋi Jisasi Iqueqä känaisä, käŋguäkatä ätimäukuwi. Qu yäpaqä mäŋgisa ätqäpiyäŋga, ämaqä hŋque, Jisasi Iqueŋi, ätämäkäqäka pätŋqä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Itaŋga ämaqä kuapänäŋi, Jisasi Ique iŋgi-iŋgisa äwqäqämapiyä iqua, Ique ätukuwi. “Tqä tnatä, tuŋguäkatä, Sinyŋqä yäpaqä mäŋgisa äpmeŋäuä.” ");
INSERT INTO mcr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I tquaŋguwäŋga, Jisasi Iqu, “Ŋqä nipaisä, ä guäkatäŋi, tqukuawä?” ätuätä yatŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Itaŋgaŋi Iqu ämaqä qäqiqi pmetaŋguwä iu äqunä, “He hiŋuä qumbiyä! Ŋqä nipaisä, guäkatäŋi, täsä äpmeŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Ämaqä Goti Iqueä äwiŋqä dunä imäkätqäŋuwä iqua, ii Ŋqä guäka, ä napqa, itaŋga nipaqayqä.” ");
INSERT INTO mcr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aŋgumŋi, Jisasi Iqu eqä-huäŋä Galili maŋä iqisa, qokä-apäkä iu näqŋqä vätŋqä ipäqäkqe. Ämaqä aaŋä kuapänä Iquenyqä äpäpu, eqä-huäŋä maŋä iqi tqäutaŋguwitaŋi, Iqu yimba eqä-huäŋä näŋi pmetaŋgqä hŋque ikuapmäuqe, ique äpmeqäŋga kukŋuä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iŋgaŋi Jisasi Iqu kukŋuä ktqä kuapänä ätätä, näqŋqä ämotquamiŋqe. Iqu, quŋi tii ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nyi qätä nyipu! Hea hŋque ämaqä hŋqu, kuä-witqä uwqä tnämäwäwätŋqä wäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iqu ätnämäwäwqaŋgaŋi, hui hänaqä iqi päkmbqe, yŋŋä äppiyi, ämambnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Itaŋga hui qua kuapänä hma etaŋgi, hikä-täŋä qäsä witaŋgqä iu päkmbqe, qua äŋgui äwa itaŋguti, kuä uwqä ii bakä maqänä hukaupnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iŋi mäptqä haqä tiqä ae äyapätä tnäŋä tqaŋga, kuä kiqä tapiŋi wäŋqäpu etaŋgi, yäuä hämänä piniqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Itaŋga kuä-witqä hui, guä yäŋä-täŋä awä imä päkmbnuwi. Ga guä quvqä iqua, qäsä naqä-huinyä epiyi, kuä-witqeuŋi, qua aowi äŋguä mävqaŋguti, häukuä äŋguä maukŋqä danä ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Itaŋga kuä-witqä qua äŋguänäŋä iqi päkmbqe, bakä äukapu, äŋguänä epeyäpu, kuapänä, hui 30, hui 60, itaŋga hui 100 hukmbnuwi.” ");
INSERT INTO mcr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisasi Iqu i ätuäqe, tii ätukqe. “Ämaqä qätä-täŋuenä etaŋgutqe, kukŋuä iiŋqe kŋuä äŋguänä indqämbiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Itaŋga ämaqä kuapänäŋi ae äwqaŋguwäŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä, 12 iquatä, ä huizi iqi yqänä äpmamiŋuwä iquatäŋi, Jisasi Ique, “Kukŋuä ktqeŋqä, iiŋä-iiŋäŋqä ätqeqä ätätnä, awä natiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iqu iquauŋi tii ätukqe. “Goti Iqunä miqeuŋqä kukŋuä quati zä ekqe, he näqŋqä mapŋqe, Iqu ae qe ämetqueqi. Itaŋga ämaqä yäpaqäŋgisa äpmeŋuwi, qu kukŋuä ktqä dinä äwiyätqäŋä. ");
INSERT INTO mcr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ii tiiŋiŋqeyi. ‘Qu hiŋuä äqunäpu, qätä äwiyäpiyä-qe, näqŋqä maeqä-quayqä. Qu näqŋqä meqä-säpi, quwqä kŋui äkunmäknäpu, aŋgumä quvepqaŋgpi, Goti Iqu äwqä haŋuä imäknätä, quwqä suqä quvqe huätä mamäuquäninjqä.’ ");
INSERT INTO mcr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","He kukŋuä ktqä iiŋqe, änyä maqŋqä äyitanä? Ga kukŋuä ktqä huizi iquauŋqe, näqŋqä äänä hepŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Ämaqä kuä-witqä uwqä tnämäwäwqä iqu, Goti Iqueqä kukŋui, ämaqeuqä qeqä-quuvqä imä vowä eŋqä-pa ikeqä iiyi. ");
INSERT INTO mcr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Itaŋga, kuä-witqä, hänaqä iqi äpäknätqä ii, ämaqä Goti Iqueqä kukŋui qätä wiyqaŋguwäŋga, Setänä iqu, kukŋuä Goti Iqu iquauqä qeqä-quuvqä imä vowä iketqe, ga huätä maqänä mamäunä. ");
INSERT INTO mcr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Itaŋgaŋi, kuä-witqä, qua hikä-täŋä iqi äpäknätqä ii, ämaqä kukŋui qätä äwiyäpu, asä qäŋganä äwqä yeeqätä ämapiyi, hukä-tapiŋä yäŋänäqŋqä mamäsäuqä ipu, äpakä mäpmeqä da ipnä. Ämaqä Goti Iqueqä kukŋuiŋqä mäwiŋqä iqä iqua, quvqä iwitquepu, haŋä-iqä vqaŋguwäŋgaŋi, qu maqänä ävquatämäupnä. ");
INSERT INTO mcr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Itaŋga kuä-witqä, guä yäŋä-täŋä awä imä äpäknätqä ii, ämaqä kukŋuä qätä äwiyäpiyä-qe, mbqä, nätmatqä qua täutaŋä äwiŋqä iiŋqänä kŋuä kuapänä indqämbnuwi. Ga nätmatqä huitaŋä-hiutaŋäŋqä äwiŋqä ii, Goti Iqueqä kukŋui huäqä äkeutätä, häukuä mäwiqä yänä. ");
INSERT INTO mcr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Itaŋga kuä-witqä, qua äŋguänäŋä iqi äpäknätqä ii, ämaqä kukŋuä qätä äwiyäpu, qänaknä ipu, häukuä qäpŋqä iquayi. Itaŋga häukui, hui 30 huknänä, ä hui 60 huknänä, itaŋga hui 100 huknäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisasi Iqu kukŋuä tii-pqä inä ätukqe. “Ämaqe hiqi-te äma äpäpu, häkä yäpä imŋä-qe, ä hevqä imŋä-qe matqäteqä ipnä. Qu hiqi-tä-tqäuqä iqi tqätepŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iŋi nätmatqä hiawiqä imä zä äwämitätqe, ga we-huŋqä iqi äti winiqe. Iwä nätmatqä eeqänäŋä zä äwämitätqe, ätnäŋä iqi winiqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","I etaŋgi, ämaqä qätä-täŋuenä etaŋgutqe, kukŋuä iiŋqe kŋuä äŋguänä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iqu kukŋuä tii-pqä inä ätukqe. “Kukŋuä qätä äwiyäŋuwä iuŋi, kŋuä yasämä iwäsäupiyä. He kukŋuä ii iwäsäuquwi, itaŋga Goti Iqu he-pqä inä ewäsäutä, näqŋqä hui haqeqi inäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iiŋä etaŋgi, ämaqä näqŋqä hui ae ämeŋuwä iqua, Goti Hanjuwä Iqu hui inä väniqe. Itaŋga ämaqä näqŋqä maeqä iqua, näqŋqä wäŋqä qu ämeŋuwi, Goti Hanjuwä Iqu huätä mamäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Itaŋgaŋi Jisasi Iqu kukŋuä tii inä ätukqe. “Goti Iqunä miqeuŋi, ii ämaqä hŋqu, iqueqä wäuŋuä iu piikä ätnämäuqä-paŋä iiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Itaŋga ämaqä iqu hiunjiŋgatä, heatqäŋgatä hiqaqä äwitä, ävautä iqueqä wäuŋuä hui imäkäkiquänä. Itaŋga piiki bakä äukatä, naqä äänä-äänä equtiyä-qe, änyä maqŋqä eänä. ");
INSERT INTO mcr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Qua iqu kiqä-kiuä piiki naqä imänätŋqä imäkqaŋgi, bakä-ganä ätimäuqe, huizi kiqä näŋqeŋqä hutqä ätäqe, itaŋga häukuä winä. ");
INSERT INTO mcr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ga häukui, ae yäuä etaŋgaŋi, ique ätävqäŋqä qäyu äyä timäuqaŋgaŋi, ämaqä iqu, iqueqä hionaqä äkkapiŋqetä täväniqe.” ");
INSERT INTO mcr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Itaŋga Iqu aŋgumä tii inä ätukqe. “Goti Iqunä miqeuŋqe, ne äänä ätätanä, kukŋuä ktqä äki tatuŋquäwä? ");
INSERT INTO mcr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ii zä-guawä piikä eŋqä-paŋä iiŋi. Iwä piikä iiŋi, huizi iqua eŋqä-paŋä naqä ma. Isua aaŋä naqämatqä-sua, ga vowä mäuquänä. ");
INSERT INTO mcr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piikä iiŋä isua vowä ämäutqe, iwä naqä eätäqäŋgaŋi, huizi iquauŋi ämäwqätäunä. Itaŋga kiqä äpae nämä-tämä iqutäutaŋga, ga yŋŋi iu yuuwä äyäqäsqäpnä.” ");
INSERT INTO mcr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisasi Iqu kukŋuä ktqä asä iiŋi, qokä-apäki qätä äwiyäpu, quwqä kŋuä duŋi qäyu mapŋqä diŋqe, kuapänä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iqu quŋi, kukŋuä ätinyäŋä hŋqu mätquä, ktqenä ätumiŋqe. Iŋäqe Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatänä äpmapiyäŋgaŋi, quatä eeqänäŋiŋqe, “iinjqä-iinjqä” ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hiunji qäque, mäptqä ae äquvqaŋga, Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “Ne eqä-huäŋä yätäqä näŋgisaŋqä äwanä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I tquaŋga, iqua ämaqä kuapänäŋä iuŋi äväma, yimba Jisasi Iqu ae äpmetaŋgqeu ikuapmäupu, äukuwi. (Iŋgaŋi yimba huizi iqua-pqe anä äukuwi.) ");
INSERT INTO mcr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iŋgaŋi yuŋuä-isisqä naqänäŋä äqunätä, eqe yimbaeu ämevqunäqe, yimba yäpä yäŋgisa äpeyätä, maŋguä nymätä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisasi Iqu yimba tuwä mäŋgisa nyuäŋä ekuŋqetä nyuäŋä ekunä hiqaqä äwämiŋqe. Iqueqä ämaqä iqua itukuwatpiyi, “Näqŋqä-vqä Iquki, Ne qui imäknatuŋquä ituŋquä tä, Si hiŋuinä naqändŋqätanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I tquaŋguwäŋga, Jisasi Iqu ävauqe, “Yuŋuä iquki, yäŋänäqŋqä mäquŋquä panä. Eqä iquki, ämeŋä miqä panä” ätukqe. I tquaŋga, yuŋui äqänäutä, eqe ämeŋä-miqä ätuukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Itaŋga Iqu, ämaqä iquauŋi, “He zä suŋqä iqäuä? He quuvqä maeqiyqä itqäŋuwätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iqu ii imäkqaŋgqeŋqä, qu zä kiiŋä ipu, quwqä-quwä tii ätŋguwi. “Yuŋuitä, ä eqetäŋi, qätä äwiyäsinyä, qänaknä iqiyä tä, ämaqä tqu, tqukä?” ");
INSERT INTO mcr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Itaŋgaŋi qu eqä-huäŋä maŋä Galili yätäqäŋgisa, Gerasa pmeqä iquauqä qua iŋgisa ätimäupiyi, Jisasi Iqu yimba iuta ti timäuqaŋgaŋi, ämaqä dŋä quvqä-tqäuqä hŋqu, hikä himaŋä, ämaqä pizqä wiqä iuta, Jisasi Ique äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ämaqä iqu, ämaqä pizqä pŋqä witaŋgqä imä pmetaŋgaŋi, ämaqä-pqä hŋqu, iqueŋi guä änä makiqiyäueqä imiŋqe. Senqä-guä ii äkiqiyäuepqä-qe, hmayi. ");
INSERT INTO mcr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Itaŋga ämaqä iqueŋi yukä hipa iuŋi, senqä-guetä, kiqiyäuqaŋguwä-qe, äqiyändakmiŋqe. Iqueqä yäŋänäqŋqä di, aaŋä hävemnäqŋqä etaŋgi, ämaqä-pqä hŋqu iqueŋi a makiqätqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Itaŋga heatqäŋgatä, hiunjiŋgatäŋi, ämaqä pizqä wiqeu äpme, ä hipkä-qoqoŋiu ikitä, zääqä ätäkitä, itaŋga hikä ämetä, iqueqä huiwiu häuä äktänmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Itaŋga iqu, Jisasi Iqueŋi kiiŋä nämda hiŋuä äqunäqe, Iquenyqä tnäŋä äpäqetaŋi, qoŋä äwoktäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ga Jisasi Iqu, “Dŋä quvqä iquki, ämaqä iquesaŋi, täŋgisa huätä timäuvä” tquaŋga, dŋä quvqä iqu zääqä ätätä, maŋä yäŋänäqŋqä tii ätukqe. “Jisasi, Goti Haqä Yätutaŋä Iqueqä Ymeqä Iquki, nyi äänä nyisäŋqäwä? Nyi Goti Iqueä hiŋuä iqisaŋi, ‘Si qui minyimäkqä isŋqä’ yatŋqä äkiyqänä,” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Itaŋi Jisasi Iqu, “Tqä yoqe, äänä äqonäŋinyä?” ätuätä, yatŋqä äwikqe. Ga iqu kimaŋi, “Ŋqä yoqe, Hatŋuneyi. Ne aaŋä kuapänäŋune etaŋgqueŋqä ätqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Itaŋgaŋi iqu, Jisasi Ique, dŋä quvqä iquauŋi, qua iquesa huätä mändowatqä yätŋqä, yatŋqä yäŋänäqŋqä ävqa äukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Itaŋgaŋi hipkä-qoqoŋä iuŋi, yaqueqä aaŋä kuapänäŋä hui ymisaŋä änmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iŋi dŋä quvqä iqua, “Iyää! Ne yaqueqä näŋuau tquatuŋquänä nandowatiyä!” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","I tquaŋguwäŋga, Jisasi Iqu quŋi, “Yqänä!” ätukqe. Itaŋga dŋä quvqä iqua, ämaqä iquesa ätimäwaŋi, yaqueqä iquau ätqäukuwi. Yaqueqä eeqänäŋä 2,000 iqua, qaŋä tnäŋänä iwaqetaŋi, eqä-huäŋä bu äpäwipu, eeqäpnä eqä änyuäpätäkqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iŋgaŋi ämaqä yaqueqä miqä iqua, zä äupiyi, aŋä-himqä iutä, qua qäqi witaŋgqä isuautä awä ätuäkäkuwi. I tquaŋguwäŋga, qokä-apäki qätä äwipiyi, qu, “Ämaqä Iqu äänä iqaŋgi natqäpiyä” tpu, hiŋuäŋqä ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Qu Jisasi Ique äwimapiyi, dŋä quvqä kuapä-täŋä emiŋqä iqu, ämaqä äŋguä-qu, dŋä quvqä maeqä eä, qäkämä äŋguä imäkänä pmetaŋgi äqumbiyi, zä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Itaŋga ämaqä, Jisasi Iqu iiŋä imäkqaŋgi hiŋuä äquŋguwä iqua, huiziuŋi awä ätukuwi. Ämaqä, dŋä quvqä ävämakuwä iquenyqätä, ä yaqueqä iquauŋqätäŋi, “Iiŋä-iiŋä imäkqaŋgi äqunäŋqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iiŋä tquaŋgä äwipiyi, qu Jisasi Iqueŋi, “Iyää! Neqä aŋä täqisaŋi huätä uvä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","I tquaŋguwäŋga, Jisasi Iqu yimba yätu ti peyqaŋgaŋi, ämaqä dŋä quvqä ävämakuwä iqu, Jisasi Iqueŋi, “Iyää! Nyi sitä anä weŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","I tquaŋgaŋi, Jisasi Iqu, iqu anä uwqeŋqe mäwiŋgaŋgi, tii ätukqe. “Tqä aŋämqä aŋgumä äwätnä, Naqä Iqu siŋqä qeqä wimäŋgaŋgi, äŋguä ikimäkqeŋqe, sämaqeu awä tuvä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iiŋä etaŋgi, iqu qua Dekapolisi pmetaŋguwä iuŋi, “Jisasi Iqu, nyi äŋguä sä nyimäkqiyä” ätuätä, awä ätäkäkqe. Iqu iiŋä tqaŋgi äwipiyi, “Häwe! Si tä änääŋqä tnyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iŋgaŋi Jisasi Iqu, eqä-huäŋä yätäqä näŋgisaŋqä aŋgumä yimba äukqe. Iqiŋi, Iqu eqä maŋä iqi pmetaŋga, ämaqä aaŋä kuapänä, Ique iŋgi-iŋgisa äwimakuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Iŋgaŋi Jarusi, ämaqä iqi pmeqä iquauqä aŋä aquväqŋqeu miqä iquautaŋä hŋqu ätimäuqe, Jisasi Ique hiŋuä äqunäqe, Iqueä yukä iqi qoŋä äwoktäutä, “Iyää! Nyaqä ymeqä ii, yaqä quvqä, nawinyä äpäkonätŋqä äwinä. Si äpätnä, tqä hipaitä ymeqä ii a uwqätqaŋgti, iwä ymeqä ii, äŋguä häŋä pmetŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","I tquaŋga, Jisasi Iqu, Jarusi iqutä itmaŋga äukiyi. I uwqaŋgiyäŋga, ämaqä aaŋä kuapänäŋi, Jisasi Ique anä äpuputmäwa äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Apäkä, qaŋuä-yaqä qäpu maeqä, yqänä imiŋqä, quväkuä 12 ämäwqätäukqä-pqä hui, ämaqä kuapänä äumiŋuwä awä imä äumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Apäkä iiŋi, duuta kuapänäŋä iquauä hipaeutaŋi tmi-tmiqä-tqä naqä ämetä, iiyqä mbqä eeqänäŋi hiŋgi äwimiŋqe. Iwä, qäpu heqänäŋä di, yändi-yändi imäŋga äpemiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ii, Jisasi Iqueŋqä qätä äwiyäqe, kŋuä tii äwikqe. “Nyi Jisasi Iqueä ämuasmäŋqeu itmaqänmqe, ye änyiyätä äŋguä nyimänäŋqiyä.” Kŋuä iiŋä indqänäqe, ii ämaqä huizi ditä Iqueä tuwiu qänaki äwivändä, Iqueä ämuasmäŋqeu itmaqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iŋga qäŋganä, ye vqaŋga, ii näqŋqä tiiŋä ekqe. “Nyi äŋguä ae nyimäŋgiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ii iqaŋga, Jisasi Iqu, Iqueqä yäŋänäqŋqä hui ävämeqaŋgqeŋqä näqŋqä ämeqe, ämaqä anä äumiŋuwä iu hiqumuaŋä äwiyä, yatŋqä ävätä, tii ätukqe. “Nyaqä ämuasmäŋqä täuŋi, tqu indmaqäŋgiyä?” ");
INSERT INTO mcr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yatŋqä i vqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, “Si hiŋuä mäquŋquä danä iŋinyä? Ämaqä kuapänä si iŋgi-iŋgisa äkivändäŋuwi, ‘Tqu indmaqiyqiyä-qe,’ suŋqä tnyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iiŋä qäyä ätquaŋguwä-qe, Jisasi Iqu, “Tqutiyä” tä, hiŋuä qävqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iŋgaŋi apäkä ii, nätmatqä iiŋi wimeqaŋgqeŋqä näqŋqä ae eäqe, zä itä, yäŋuä-yäŋuäqä äpäyäqe, Jisasi Iqueä hiŋuä iqi qoŋä äwoktäutä, nätmatqä äwimakqeŋqä awä eeqäpnä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","I tquaŋga, Jisasi Iqu, “Ŋqä ymeqä iiki, tqä quuvqä eqiyqe, äŋguä ae qe ikimäkqiyä. Itaŋga äwqä haŋuä iŋqä äwätnä, täŋä-yaqä maeqä pmettŋiqä” atukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisasi Iqu apäkä iiŋi, kukŋuä yqänä tuätqätaŋga, ämaqä hŋqua Jarusi iqueqä aŋä iuta äwimapiyi, tii atukuwi. “Tqä meqi ae äpäkoŋgqeqä. Näqŋqä-vqä Iqueŋi, haŋä-iqä hui inä mävqä panä.” ");
INSERT INTO mcr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisasi Iqu, qu ii tquaŋguwiŋqä qätä mäwiyqä itä, iqueŋi, “Si iiŋqä äwäwa miqä, quuvqenä heqiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iŋgaŋi Jisasi Iqu, ämaqä eeqänäŋi iqi ätäqumuatätä, Iqutä anäŋi, Pitä ique, Jemisi, Jonä gueqi, iquatänä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iqua ämiqä iqueä aŋä iu ätimäupiyi, Jisasi Iqu, qokä-apäki näŋi-täqi äqutäukipu, kŋuä kiiŋä qiyätqätaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iqu ii äqunäqe, aŋä yäpä yäŋgisa äpeyätä, tii ätukqe. “He hääŋqä kuapä äkitmäkäpu, kŋuä tä suŋqä äqiyätqäŋäuä? Ymeqä täsi, hämä mapäkoŋqä iqi. Ii hiqaqä äwinä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","I tquaŋgqeŋqä, qu Iqueŋi tä äwisukuwi. Iŋgaŋi Iqu quŋi, yäpaqä mäŋgisa huätä ändowatäqe, ymeqä iiyqä kanä-känäu, itaŋga Iqutä anä äukuwä iquau itumetä, hiqŋqä ymeqä ii witaŋgqeuŋqä äpekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iqua äpepiyi, Jisasi Iqu ymeqä ipiyqä hipae a ämaqätäqe, iipiŋi, quwqä aŋä-kukŋuitäŋi, “Talita kumä” atukqe. Kukŋuä iqu, tiinji. “Ymeqä iiki, ‘Pämä vayä!’ äktqä.” ");
INSERT INTO mcr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I tquaŋga, ymeqä ii, asä qäŋganä pämä ävauqe, qaŋä ikäkqe. Iŋgaŋi iiyqä quväukui 12 etaŋganji. Iqu iiŋä iqaŋgqeŋqä, qu miqä yäŋä ipu, yäuŋuä naqänäŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ga Iqu quŋi, “Täŋqe, ämaqeuŋi awä mätquä pambiyä” ätuäqetaŋi, “Qe ymeqä täpiŋi, ymisaŋä hui nätŋqä winyqä,” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisasi Iqu aŋä iqiŋi äväma, aŋä-himqä Iqueqeuŋqä aŋgumä äukqe. Ii äwqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sämbatqä, hiunji hapä pmeqäŋgaŋi, Iqu aŋä aquväqŋqä iuŋqä äwäqe, Goti Iqueqä kukŋuiŋqä näqŋqä vätŋqä ätipäqäkqe. Ämaqä kuapänäŋi, qu Iqueŋi qätä äwipiyi, “Äänä ätqutiyä” tpu ikuwi. Iiŋä ipiyi, “Ämaqä tqu, kukŋuä tä äŋgisa ämeqäqäwä? Näqŋqä Iqu ämeŋqä ätqäqä tä, äkitaŋiwä? Itaŋga ämaqä mimäkqänäŋi imäkätŋqe, änääŋäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Itaŋga, “Ne näqŋqe, Iqu, aŋä Imäkqä Ique. Ä Mäliyaqä Ymeqä Iquvi. Itaŋga Jemisi, Josepä, Jutä, Saimonä, iquauqä Kätequvi. Ga qunapqa täqi nesä anä äpmeŋunä” ätŋguwi. Ii ätäpu, Iqueŋqä äwqä quvqä ätimäukŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iŋgaŋi Jisasi Iqu quŋi, ätukqe. “Hiŋuä-tqä iqua aŋä-himqä eeqänäŋä iuŋi, yoqä-täŋuae. Etaŋgqä-qe, hŋqunä-hŋqunäŋi, iqueqä aŋä-himqä iutä, iqueqä käyämaqä iutä, iqueqä aŋiu anä äpmeŋuwä iutäŋi, iqu yoqä maiqä-queqä.” ");
INSERT INTO mcr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Itaŋi Iqu, nätmatqä ämaqä mimäkqänäŋi hui, iqi mimäkqä danä ikqe. Mä Iqu ämaqä täŋä-yaqä-täŋä huiunä a uwqätätä, äŋguä imämbŋqä inä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iŋi Iqu, iqua qätä äwiyäpu quuvqä maeqiyqaŋguwiŋqä, yäuŋuä itä, kŋuä kuapänä indqäŋgqe. Iŋgaŋi Jisasi Iqu ämaqä aŋä-himqä pmetaŋguwä-pa äkoquväkitä, näqŋqä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iqu Iqueqä 12 iquauŋi, aquvä ämaqiyäqe, iŋgi-iŋgi hŋquaqu-hŋquaqu ändowatätŋqä ipäqäkqe. Iwä Iqu iquauŋi, dŋä quvqä qokä-apäkiu ätqäuŋuwi, huätä ändowatpŋqä yäŋänäqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iqu tii ätukqe. “He äwäpiyäŋgaŋi, yäkqä qaŋä huisäŋqenä a maqätqäpŋqä. Ä nätmatqä qaŋä qäsä äma uwqä hnjua, mämeqä iqäpŋqä. Tiiŋä isua, bretqä, yquayä qa-mŋqä, ŋŋ mbqeu. Iiŋqe, ‘aaŋä oeyqä’ ätqä. ");
INSERT INTO mcr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Itaŋga yukä-su dinä ämuasmäupu, gque hŋquaqu mipŋqä danä iqäpŋqä.” ");
INSERT INTO mcr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iqu tii-pqä inä ätukqe. “He aŋä himqä hŋque ätimäupiyäŋgaŋi, hiqaqe, aŋä du-täu mäwäyäkiqä, aŋä-himqä iuŋi ävämepiyäŋgaŋqe, aŋä hiqaqä äwipiyä iquenyä wiqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Itaŋga aŋä-himqä hŋqueŋi, qu yeeqä miqä danä ipu, qätä maeyqä iqaŋgpqe, he iqi ävämepiyäŋgaŋi, qua yukä iu emäkäŋqe, ptäquväteqämä imbnuwäŋqe. Suqä iiŋi, qu quwqä suqä quvqeŋqä näqŋqä mapŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Itaŋi iqua äupiyi, qokä-apäkiuŋi, quwqä kŋuä äkunmäknäpu, suqä quvqe huätä vquatämäupŋqä, awä ätuäkämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Iqua ii ätäkipiyäŋgaŋi, dŋä quvqä kuapänäŋi huätä ändowatäpu, itaŋga ämaqä täŋä-yaqä-täŋä etaŋguwä iuŋi, olipqä eqä aowätäŋi äwiquatäpu, äŋguä iwimäkmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","Jisasi Iqueä yoqe im-imä täkiqaŋgä, ämaqeu miqä naqä, Heroti iqu qätä äwikqe. Ämaqä hui, “Jonä asŋä-qäyqä iqu, pizqeuta aŋgi häŋä ävautä, yäŋänäqŋqä-täŋä eä, ämaqä mimäkqänäŋä di täwäsi imäkqiyä” tqaŋguwäŋga, hui, “Laisa iqueqä” tqaŋguwäŋga, itaŋga hui, “Ii, Goti Iqueqä kukŋui hiŋuä-tqä qäŋgatqä iqua eŋqä-paŋä iqueyqä” ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heroti iqu qätä ii äwiyäqäŋgaŋi, tii ätkqe. “Jonä, nyi nyuäŋä ätäwikqä iqu, täŋga aŋgi häŋä ävautänjqä.” ");
INSERT INTO mcr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tiiŋä etaŋgi. Heroti iqu, iqueqä-kiuä ämaqä hui dowatqaŋgi, ga qu Jonä ique itmepu, guä äkiqiyäupu, guä pmeqä aŋiu äpmuatekuwi. Iqu ii ikqe, käta, Pilipä iqueqä apäkä Herotiyasi iiŋi, iqu ämotautä, ämetäqeŋqä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jonä iqu Heroti iqueŋi, “Si tqä ttequeqä apäki ämotautnä ämeŋi, äŋguä miqä danä inyä” ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ii tuätqätaŋgqetaŋi, Herotiyasi, Jonä Iquenyqä wiwuŋgaŋgi, “Iqueŋi äpäkmä” kŋuä vqaŋgqä-qe, Heroti iquesa eqänmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heroti iqu, Jonä iqueŋqe, iqu ämaqä jänänäŋä-qu, Goti Iqueqä yäpä iqi pmetaŋgqeŋqä zä itä, äŋguänä ämimiŋqe. Iwä iqu Jonä iqueqä kukŋui qätä äwiyätäqäŋgaŋi, kŋuä mäwiyqä imiŋqe. Ii qäyä itä, Jonä iqueqä kukŋui qätä-wiyqäŋqe, yqänä äwinymiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Qänakŋi Herotiyasi, iiyqä äwinyätaŋgqä di imäkätŋqä hiunji iqu ätimäukqe. Hiunji Heroti iqu, iqueqä känai ämikqeŋqä kŋuä ämetä, ymisaŋä naqänäŋä hŋqu imäkkqe. Iqu ii imäkkqe, ii ämaqä naqä, iqueqä gapmanqä wäuŋuiu yätamäkqä wimiŋuwä iquauŋqätä, ä mäkä-iqä iquauqä ämiqä kiŋganäŋä iquauŋqätä, ŋŋ ämiqä qua naqä Galili iutaŋä iquatä anä bŋqeyi. ");
INSERT INTO mcr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iŋgaŋi Herotiyasiyqä meqi, yäŋgisa äpäyäqe, Heroti iquesä, iqutä anä pmetaŋguwä iquautä, himnuŋuä äwukoquvätä, yeeqä äwikqe. Iŋgaŋi ämiqä naqä iqu, hitqä iinyŋqä yeeqä itä, “Si nätmatqä hnjua matŋqä, nyi yatŋqä änyiyqaŋgtqe, ga äktapmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Heroti iqu kukŋuä guä yäŋänäqŋqä tii ämäsäukqe. “Hitqä iiki, naqä-qakuä äktqä. Nätmatqä tqä äkinyäŋqeŋqä yatŋqä änyiŋi, ga nyi äktapmqänä. Itaŋga qua nyi ämitŋqe, hŋquaqu ämisqiyätmä, hŋgiŋi si ktapmqä dqaŋgtqe, nyi kikiyaŋgu miqä ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iqu iiŋä tquaŋga, hitqi äwäqe, känäu yatŋqä äwikqe. “Nyi iqueŋi yatŋqe, nätmatqä äkiŋqä wimqäwä?” Ii i tquaŋga, känae, “Jonä asŋä-qäyqä iqueqä nyuäŋi ktapätŋqä tuvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Känai i tquaŋga, hitqi aŋgumä ämiqä naqä iqueŋqä tnäŋä äwäqe, “Nyi Jonä asŋä-qäyqä iqueqä nyuäŋi, täŋganä hevqä iqutäwa daptŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Qätä ii äwiyäqe, iqu äwqä haŋä naqänäŋä ämakqe. Iŋgaŋi, iqu hitqiŋi, iqueqä kukŋuä guä yäŋänäqŋqä ämäsäukqeŋqä kŋuä ämetä, ga iqutä ymisaŋä anä änmiŋuwä iquauqä hiŋuä iqisa womba meqäŋqe mäwiŋqä itä, iiyqä äwiŋqeuŋi hŋgisanä vqeŋqe mäwiŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Itaŋga iqu mäkä-iqä hŋque, Jonä iqueqä nyuäŋi äma pätŋqä maqänä ändowatkqe. Itaŋi iqu guä pmuateqä aŋä duŋqä äwäqe, Jonä iqueä nyuäŋi ätävätä, hevqeu äma äpätä, hitqä ii äwikqe. Ga hitqä ii äma äwätä, känäu äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Itaŋgaŋi Jonä iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, haŋä-iqä ii timäuqaŋgqeŋqä qätä äwipiyi, iqua ätimäupu, iqueä huiwi ämapiyi, hikä hovqeu pŋqä ekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Itaŋga ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, aŋgumä Jisasi Iqutä aquvä äqämbiyi, qu Iqueŋi, wäuŋuä imäkkuwiŋqätä, kukŋuä qokä-apäkiu ätukuwiŋqätä, tiwiqä eeqänä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iŋgaŋi ämaqä kuapänäŋi, iquauŋqä äpäpu, äwäpu iqaŋgä, iqua ymisaŋä änä maŋqä ipu, hapä äŋguä mäpmeqä ipiyä iutaŋi, Jisasi Iqu, “Hapä wäŋqä hmbu pmetuŋquä, neqä-neuänä hŋqäqinyqä watuŋqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","I etaŋgi, quwqä-quwänä yimba ikuapmäupu, aŋä avqŋqä imŋqä upŋqä ävämakuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iqua iiŋä iqaŋguwiŋqe, ämaqä aŋä-himqä eeqänäŋä iutaŋä kuapänäŋi, hiŋuä äqunäpu, “Tä iqua äyä mändanä-qe” näqŋqä ämapiyi, qaŋä maqä-maqä äwäpu, qu-ganä ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ga Jisasi Iqu yätäqä näŋgisa ae iuäqämeqe, ämaqä kuapänä pmetaŋgä äqunäqe, quŋqä huäqä kiiŋä äwuŋgqe. Huäqä äwuŋgqe, tiiŋä iutayi. Qu sipsipqä, quwqä ämiwiyqä iqu maeqä eŋuwä-paŋä iiŋä äquŋgqe. Ii äqunäqe, Iqu näqŋqä kuapänä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Qäŋga awiyqeuŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Jisasi Ique äwimapiyi, tii ätukuwi. “Täqiŋi aŋä avqŋqä eä, ga ae awiyqä äyä eqä-qae, ämaqä täuŋi, ymisaŋä mbqä ipu bŋqeŋqe, ämaqä aŋä qäqi täpe pmakäwätaŋguwä iuŋqä dowatiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","I tquaŋguwäŋga, Jisasi Iqu, “Ymisaŋi, hiqä-hiuä wipiyä” ätukqe. Iqua Iqueŋi, kima tii ätukuwi. “Ne mbqä 200 äma äwätanä, ymisaŋä mbqä itanä, iquau vatuŋquä änatnyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iqu, “He bretqe, äänä ämeŋä? Hiŋuä-ganä qumbŋqä upiyä!” Itaŋga qu näqŋqä ae ämapiyi, tii ätukuwi. “Bretqe, hipa hŋgi eeqä, ä hämapäkä hŋquaqu qäsä äqunäŋunä.” ");
INSERT INTO mcr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iŋgaŋi, Iqu ämaqeuŋi, “Iwäsämbu, qätaqä hioätqä äŋguä täqi pmakäupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Itaŋga qu iwäsämbiyi, hui 100, ä hui 50 äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Itaŋi, Jisasi Iqu bretqetä, hämapäkitä ämeqe, qäukuä yätu äqunä, Goti Ique, “äŋguiqä” ätuäqe, bretqe äkutätä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äma yaŋä väkäpŋqä äwikqe. Itaŋga hämapäkä iquaquiŋä-pqe, ämaqä eeqänäŋi bŋqe, inä iwäsäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Ämaqä eeqänäŋi äwqä änäpäkpiyi, iqi änätquteqaŋguwäŋga, wäuŋuäŋqä ämotquamiŋqä iqua, bretqätä, hämapäkitäŋi aŋgi aquvä ämaqäpiyi, qa naqä 12 ämamikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ämaqä qokä ymisaŋä äŋguwä iqua, 5,000. ");
INSERT INTO mcr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ymisaŋä qäpu ti ämbiyi, Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “He yimba ikuapmäupu, eqä-huäŋä yätäqä Betsaitä näŋgisaŋqä, hiŋuiqä upiyä” ätukqe. “Nyi qokä-apäkä täuŋi, quwqä aŋämqä dowatmqänä.” ");
INSERT INTO mcr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iŋgaŋi Iqu, ämaqä eeqänäŋä iuŋi ae ändowatäqe, Goti Iquenyqä tääqä tätŋqä qoqoŋä yätuŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Heatqä asä qäŋgaŋi, yimba eqä-huäŋä awä iqi äwätqätaŋga, Jisasi Iqu kiuänä näŋgisa yqänä ätqäumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","50","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, yimba iqueŋi wäuŋuä tnäŋä ämipiyä-qe, yuŋui aŋgumä ätakmä uwqänä itqätaŋgi äquŋgqe. Zä we-hunätŋqetäŋi, Jisasi Iqu, iquauŋqä eqä-huäŋä haqeqi qaŋä äukqe. Iqu iquauŋi jänä mäwqätäutŋqä pqaŋgi äqumbiyi, iqua ‘hikuapqeqä’ kŋuä wiyqaŋgi, zä ipu, zääqä ätukuwi. Jisasi Iqu maqänäŋi tii ätukqe. “Nyi tä Qäqunjqä. He zä miqä, pemä pmapiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ii ätuäqe, Iqu yimba iu äpeyätä, iquatä anä pmeqaŋga, yuŋui qe äqänäkqe. Yuŋuä ii iqaŋgqeŋqä, iqua, “Tä änääŋqä iqutiyä” tpu, miqä yäŋä ikäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Quwqä kŋui qŋqaŋä enätaŋgqetaŋi, Iqu bretqä äkutätä ämaqeu yaŋä ävqäkqueta, Iqueqä yäŋänäqŋqeŋqä kŋuä yasämä mämeqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Qu eqä-huäŋä maŋä näŋgisa, qua Genesäretqä iu iuäqämapiyi, yimba iqi guä äqäyekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Qu yimbaeta ti ätimäwa uwqaŋguwäŋgaŋi, ämaqe, tä Jisasi Iqu äyä hitaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iŋgaŋi qu qua ique äpmamiŋuwi, im-imä tnäŋä ikipu, ämaqä täŋä-yaqä-täŋi hevqä ämiqutäwa, Jisasi Iqu äkisqi pmetaŋgutqeu wimapŋqä ätŋgäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Itaŋga Iqu aŋä-himqä naqä iquau, ä wäŋqä isuau, ŋŋ aŋä hŋqunä-hŋqunäŋä iu ikiqaŋgqä-pa, ämaqe, qu täŋä-yaqä-täŋä iquau ququawä aquväqŋqä iqi ätuma äwätemiŋuwi. Itaŋga Jisasi Iqueŋi, “Iyää! Ämaqä täŋä-yaqä-täŋä tqua, saqä qäkä hituŋui qäyä itmaqämbŋqä, hiŋuinä qunyä” ätumiŋuwi. Iŋi, ämaqä Iqueä qäkä hituŋui itmaqänäpiyä iqua, quwqä täŋä-yaqe qäpu emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, Jerusälemäta äppiyi, Jisasi Iqutä aquvä äqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Itaŋga qu iŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋqua, quwqä hipae asŋi, eqä akiyä iŋqä ditä maqiyqä ipu, ymisaŋi qanyä gaŋgä äqumbiyitaŋi, Goti Iqueqä hiŋuä iqiŋi, quwqä hipae kiyä mätqä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tiiŋi. Parisi iquatä, Israitqä huizi iquatä, eeqänäŋi quwqä quwokiqua imiŋuwä iuŋi qänaknä ipu, maŋqä, quwqä hipae eqä akiyä iŋqä ditä asŋä-ganä äqämbiyi, iŋga änmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Itaŋga ququawä aquväqŋqä iuta äpäpiyäŋgaŋi, nätmatqä hnjua maŋqä, eqä akiyä iŋqä ditä asŋä-ganä äqämbiyi, iŋga änmiŋuwi. Itaŋga quwqä kaqä-kawäkauqä suqä, eqä-häkä, kuatä-häkä, häkiyä yäqiyqä hevqä iquau, hevqä äpmeqä iu, qu asŋä-ganä äqämiŋuwä iuŋi, a yäŋänäqŋqä äqätmiŋuwi.) ");
INSERT INTO mcr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iiŋä äqumbiyi, Parisi iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, Iqueŋi, “Suŋqäwä? Tqä ämaqä wäuŋuäŋqä ämotquetqäŋä iqua, suqä neqä awiqukua hipa eqä akiyä iŋqä ditä asŋä äqänmiŋuwä-pa, mimäkqä ipu, ymisaŋi hipa kiyä mätqetä äŋguwiuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I tquaŋguwäŋga, Iqu tii ätukqe. “He wopqä ipu kukŋuinä tqä iquenäŋqe, Asayä iqu, Goti Iqueqä kukŋui hiŋuä ätätä, naqä-qakuä tii äqäkqe. ‘Ämaqä tä, Nyi Goti Iqunäuä yoqe, maŋitänä haqeu ämandnämäutqäŋuwä-qe, quwqä qeqä-quuvqe, kiŋä nämä äwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Qu ämaqä iquauqä kukŋuä-suqä dinä awä ätäpu, “Kukŋuä tä Goti Hanjuwä Iqueqeqe” quaŋgä ätätqäŋä. Iiŋä ipiyitaŋi, qu Ŋqä yoqe haqeqä mamäupŋqä qoŋä änäuktäutqäŋuwi, hiŋginäwa itqäŋuwiqä,’ ätätä äqäkqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","He Goti Iqueqä kukŋuä-suqä duŋi ävquatämäupu, ämaqä iquauä suqä iunä qänaknä ipu, a yäŋänäqŋqä äqätäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iŋi Jisasi Iqu tii-pqä inä ätukqe. “He kŋui qeiqinyä indqänäpiyitaŋi, kukŋuä-suqä Goti Iqueqe, huätä ätnämäupu, itaŋga qänaknäŋi suqä heqä dunä itqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ii tiiŋi. Mosisi iqu, ‘Tniquesä, tnäutäŋi äŋguänä itqueqaŋgnyä!’ ätätä, ga ‘Ämaqä hŋqu kaniqueŋqätä, känäuŋqätä qui kukŋuä tqaŋgutqe, iqu häŋä mäpmeqä yäŋqiyä’ ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mosisi iqu e ätkqä-qe, he tii äyä ätätqäŋä. ‘Ämaqä hŋqu kanä-käna-yaquiŋqä yätamäkqä vätŋqä nätmatqä hui ämamitätqe, ga “Nätmatqä iiŋi, nyi Goti Ique ae ävqeqä” ätque, kanä-käna-yaquiŋi, yätamäkqä mävqä da yätŋqeqä,’ ätätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","“Heqä aeqä iquauqä suqä iunä imäkäpiyitaŋi, Goti Iqueä kukŋui, mändi äkittqiyätqäŋä. Itaŋga, he suqä iiŋä iquauŋi, kuapänäŋä imäkqa äwätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iŋgaŋi Jisasi Iqu ämaqä kuapänäŋä iuŋi, aŋgumä tääqä ätuätumeqe, “Eeqänäŋuenä, Nyaqä kukŋui qätä änyiyäpu, kŋuä mapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","“Nätmatqä ämaqä hŋqueä yäpä iŋgisa mäwitaŋgqä hui, ique äpaquvqe, ii Goti Iqueqä hiŋuä iqiŋi, kiyä mätqä miwimäkqä yänä. Nätmatqä iqueqä yäpä imä äwuwiŋqä ii, iqueŋi kiyä mätqä iwimäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iqu ämaqä iuŋi äväma, aŋä yämä peyqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua Iqueŋi, kukŋuä ktqä iquenyqä yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisasi Iqu kimaŋi, “He-pqe kukŋuä ktqä iqueŋqe, maqŋqä eqä? Tiiŋiŋqä etqä. Nätmatqä yäpaqäŋgisa äwiŋqe, ämaqeu yäpä yäŋgisa äpeyätä, kiyä mätqä miwimäkqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","“Nätmatqä iiŋi, qeqä-quuvqä imä mäpaquvqä, tuqä iuŋqä äwitä, iqisaŋi zä-aŋä buŋqä äquveqänä.” (Jisasi Iqu ii ätätä, tii ätkqe. “Goti Iqueqä hiŋuä iqiŋi, ymisaŋä eeqänäŋi, äŋguänäŋiqä.”) ");
INSERT INTO mcr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisasi Iqu ii ätuätä, tii ätukqe. “Nätmatqä ämaqeuta, yäpaqäŋgisa ätimäwa äpqäqe, ii kiyä mätqä iwimäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ämaqeuqä qeqä-quuvqä imdaŋi, tiiŋä iqua ätimäwa päŋqiyä. Kŋuä indqäŋqä quvqä, huiwä yaŋä hiŋgi iŋqä, quwä-meqä, ä ämaqä pizqä päsqä, ŋŋ huiziqueqä apäkäŋqä iqä, hiŋuä aowä quŋqä, quaŋgä tquä, ä hŋgisanä iqä, hŋqueŋqä äwqä äkasuwä imäkätä qui äkasuwä tquä, ä kiuä nyuätŋqä, kŋuä qäyasäqi ämetä imäkqä, itaŋga suqä quvqä huitaŋä-huitaŋä huizi-pqä imäkqä iquauŋqä ätqä. ");
INSERT INTO mcr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ga suqä quvqä iiŋä iqua, ämäqeuta ätimäwa äpqe, ämaqeuŋi, Goti Iqueqä hiŋuä iqiŋi, kiyä mätqä iwimäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisasi Iqu iqi äväma, aŋä-himqä Tayä-täŋä qäqiqinyqä äukqe. Iqiŋi Iqu, “Ämaqe, Nyi täqi pmetaŋgqeuŋqe, änyä maqŋqä epŋqäuä” kŋuä wiyqaŋgi, aŋä hŋque äpaqukqe. Iqu kŋuä ii äwikqä-qe, ämaqe, qu Iqu pmetaŋgqeuŋqe näqŋqä ämakuwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Apäkä hui, iiyqä meqi dŋä quvqä tqäutaŋgi, ii Jisasi Iquenyqä qätä maqänä äwiyäqe, äpäqe, Iqueä yukä-täŋä qäqiqi qoŋä äuktäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Apäkä ii Israitqä iquautaŋä ma, qua Siliya-Ponisiya iu imäŋgqe. Ii Iqueä yukä iqi qoŋä äuktäuqe, “Nyaqä meqe dŋä quvqä tqäutaŋgi, Si huätä dowatiyä” ätuätä, yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iqu kimaŋi, “Ne ymisaŋi, ymeqeu-ganä käyä ävanä” ätukqe. “Ymeqeuqä ymisaŋi ämotautanä, hiveqä iquauŋqä tnämäuqe, qäyu maeqä danä eänä.” ");
INSERT INTO mcr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I tquaŋga, apäkä ii, “Ämaqä Naqä Iquki, Si qäyu ätŋä-qe, ymeqä ymisaŋä änätquteqaŋguwi, hiveqä iqua ämambŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","I tquaŋga, Jisasi Iqu, “Si ii ätŋiŋqe, yqä uvä! Dŋä quvqe, tqä meqiŋi huätä ae ävämeqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iŋgaŋi, apäkä ii, iiyqä aŋä iqi ätimäuqe, meqä iiŋi, dŋä quvqe ae ävämeqaŋga, iiyqä yquvaŋä iu witaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisasi Iqu aŋä himqä Tayäŋi äväma, aŋä-himqä Saitonä-täŋä iu äwätä, qua Dekapolisi iu, eqä-huäŋä Galili ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iqi timäuqaŋga, qu ämaqä qätäyqä, kukŋuä wiŋuä änä maqŋqä hŋque, Iquenyqä ätuma äppiyi, “Iyää! Jisasi Iquki, Saqä hipae, ämaqä tque itmaqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I tquaŋguwäŋga, Jisasi Iqu, ämaqä iqueŋi kiuänä itmeqe, Iqueqä hipae ämaqä iqueä qätä hovqä iŋgi-iŋgisa ävätäqetaŋi, aŋgiŋi, Iqu makukuä äquteqe, ämaqä iqueä tewi itmaqäkqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ii iqe, Iqu hiŋui qäukuä haqä yätu äqunäqe, oänä ätätä, iqueŋi, “Epata” ätukqe. Kukŋuä iiŋi, kiqä quati tiinji “Qäte äkivänä!” ");
INSERT INTO mcr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iqu ii wimäkqaŋga, ämaqä iqueä qäte äutänäqe, itaŋga iqueä tewä-pqe äŋguä eätä, iqu kukŋui, iqueqä tqä-pa qe ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisasi Iqu ii iqetaŋi, Iqu quŋi, “Ämaqeuŋi awä mätquä pambiyä” ätukqe. Iqu ii qäyä tquaŋgi, qu awä ätäkäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Qätä äwiyäpiyä iqua, “Äänä imäkäqutiyä” tpu ikuwi. “Iqu nätmatqä eeqä äŋguä imäkqiyä. Qätäyqä-pqe, qätä äwiyqäuä. Kukŋuä matqä-pqe, kukŋuä tqä imäkqiyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Iŋgaŋi aŋgumŋi, ämaqä kuapänäŋi Jisasi Ique äwimepu, ymisaŋä äŋqeŋqe aaŋqä etaŋgä, Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau tääqä ätuätumeqe, tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ämaqä tä, Nyitä hiunji hŋquaqu-hŋque äpmeŋuwi, ga ymisaŋä bŋqä di aaŋqä etaŋgqeŋqä, Nyi quŋqä huäqä änuŋgiyä. ");
INSERT INTO mcr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iŋi Nyi, quwqä aŋämqä dä yqänä iqä ändowatmqe, hŋqua aŋä kiŋä-näunda äpquwä-qae, qaŋä änä mäwqä ipu, hänaqeuŋi dä päkombŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","I tquaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, “Aŋä avqŋqä täqiŋi, ämaqä eeqänäŋä tä ymisaŋä bŋqe, ne äŋgi ämetanä vatuŋquäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisasi Iqu iquauŋi, “He bretqe, äänä ämeŋäuä?” tquaŋga, qu kimaŋi, “Ne 7 ämeŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iŋgaŋi Iqu ämaqä eeqänäŋi, “Quamä pmapiyä!” ätuäqe, bretqä 7 iquau ämeqe, Goti Ique “äŋguiqä” ae ätuäqe, äqäyäkutätä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau äwikqe. Ävqaŋga, iqua ämaqeu yaŋä wipŋqä äma ikäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Itaŋga qu hämapäkä wäŋqä hnjua qäsä ämamiŋuwi. Jisasi Iqu isuauŋqä, Goti Ique “äŋguiqä” ae ätuäqe, “Hämapäkä-pqä tä, qäsä yaŋä wipiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iŋi ämaqä eeqäŋi äwqä änäpäsäpu iqi änätqutekuwi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, aquvä ämaqiyäpu, hiqokä-qa 7 ämamikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ymisaŋä ii änmiŋuwä iqua, 4,000 iquayi. Ga Jisasi Iqu, quwqä aŋämqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iqu ae ändowatäqe, iŋga qäŋga Iqueqä ämaqä iquatä yimbaeu ikuapmäupiyi, qua Dalämanuta iuŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi hŋqua, Jisasi Ique äwimapiyi, Iqueqä kukŋui mändi kittqäpŋqä ipäqiyäpu, yamwiqä äväpu, tii ätukuwi. “Si nätmatqä ämaqä mimäkqänäŋi imäkätnä, Tquki eŋiŋqe, mänätquayä.” ");
INSERT INTO mcr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","I tquaŋguwäŋga, Jisasi Iqueqä äwqä imŋi, quŋqä haŋä-iqä ämetä, haaqä ätätä, “Ämaqä täŋga äpmeŋuwä ii, wäuŋuä imäkätnä ämänätquayä-qe, suŋqä dqäuä?” ätukqe. “Nyi he naqä-qakuä etqä. Iqua nätmatqä hui hiŋuä mäquŋquä ipnä.” ");
INSERT INTO mcr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","I ätuäqe, Iqu quŋi äväma, aŋgi yimbaeu ikuapmäuqe, eqä-huäŋä yätäqäŋgisaŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, bretqä hui inä mämeqä, hui imäukuwi. Iutaŋi, qu yimbaeuŋi, bretqä hŋqunä ämapu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Itaŋgaŋi Jisasi Iqu, “Parisi iquauqätä, Heroti iqueqätä, bretqä änyuämäwa peyqeŋqe, äŋguänä äminyäpu, wimasäpiyä” ätuätä, näqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I tquaŋga, iqua quwqä-quwä, “Ne bretqä aaŋqä etaŋgqueŋqä änatqiyä” ätŋgäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iqu, qu iiŋä tŋgaŋguwiŋqä, näqŋqä ämeqe, iquau yatŋqä äwikqe. “He ‘Ne bretqä aaŋqeqä’ ätŋguwi, suŋqä tqauä? He näqŋqä-pqä, ä kŋuä-pqe, mämeqä iquwätanä? Heqä kŋuä indqäŋqä iuŋi, kŋuä wäuŋui yasämä miqä da iqiyä? ");
INSERT INTO mcr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","He hiŋuä-täŋä eŋuwi, hiŋuä mäquŋquä ipu, qätä-täŋä eŋuwi, qätä mäwiyqä ipu, kŋuä äpakänäŋi mämeqä iquwi, ii suŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nyi bretqä hipa hŋgi eeqä, 5,000 iquauŋqä äkutkqe, ga änätqutekuwi, he qa naqä maŋgui, äänä ämamikuwäwä?” ätukqe. Iqua, “Ne qa 12 ämamikqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Itaŋi Iqu, “Ga Nyi bretqä 7, ämaqä 4,000 iquauŋqä äkutkqä, änätqutekuwi, hiqokä-qa maŋgui, äänä ämamikuwäwä?” ätukqe. Qu, “Ne qa 7 ämamikqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ga Iqu, “He iiŋqe, näqŋqä mämeqä yqänä itqäŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Itaŋgaŋi iqua aŋä-himqä Betsaitä qe ätimäukuwi. Iqiŋi, qu ämaqä hiŋuä quvqä hŋque, Jisasi Iqueŋqä ätuma ätimäupiyi, “Iyää, Jisasi Iquki, tqä hipae itmaqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I tquaŋguwäŋga, Jisasi Iqu, ämaqä iqueŋi, a ämasqäŋga, aŋä himqä yäpaqä mängisa ätuma äwäqe, iqueqä hiŋuiu makukuä äwqutäqe, hiŋuä-huiwiu itmaqiyätä, yatŋqä äwikqe. “Si nätmatqä hui hiŋuä äqunäŋinyä?” ");
INSERT INTO mcr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iqu hiŋuä äqänäqe, “Ŋŋqä, nyi ämaqä hui qaŋä ikiqaŋgä äqunmä-qe, quŋi ätnäŋäqi mäquŋquä eŋänä. Qu zä eŋqä-paŋä-qua etaŋgä äqunäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I tqaŋga, Jisasi Iqu, Iqueqä hipae, ämaqä iqueä hiŋuä-huiwä iu itmaqiyqaŋga, iqueqä hiŋui hämänä äqänätä, äŋguä ätimäuqaŋga, iqu nätmatqä eeqänäŋi, ätnäŋäqi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Itaŋgaŋi Jisasi Iqu ämaqä iqueŋi, “Si aŋä-himqeuŋi mäpaquvqä, tqä aŋiuŋqä jänä uvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Itaŋi Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, aŋä wäŋqä, aŋä-himqä Sisariya-Pilipai iu mätnätaŋgqeuŋqä äukuwi. Hänaqä äwäpiyä nämŋi, Iqu quŋi yatŋqä äwikqe. “Ämaqe, Nyiŋqe, tqueqä ätätqäŋuwäwä?” ");
INSERT INTO mcr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iqu yatŋqä ii vqaŋga, iqua tii ätukuwi. “Ämaqä hui Sinyqe, ‘Jonä asŋä-qäyqä iqueqä,’ hui, ‘Laisa iqueqä,’ itaŋga hui, ‘hiŋuä-tqä-queqä,’ ätätqäŋuwiqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iqua iiŋä tquaŋguwäŋga, Iqu iquauŋi yatŋqä tii äwikqe. “Hiyaqä kŋuä duŋi, Nyi tquŋgä?” Iqu i tquaŋga, Pitä iqu, “Si Kraisi ne äminesŋqä, Goti Iqu atäuŋuä äkikqä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iŋgaŋi Iqu, quŋi, “He Nyiŋqe, ämaqeuŋi awä mätquä pampiyä” ätätä, kukŋuä yäŋänäqŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ii ätuäqetaŋi, Jisasi Iqu, iquau näqŋqä änyä-häŋä hui ävätä, tii ätukqe. “Ämaqeuqä Ymeqä Ekqä Iqu, haŋä-iqä kuapänä meniqeqä. Itaŋga ämaqeu miqä iquau, hiqäva-imäkqä naqä iquau, itaŋga kukŋuä-suqeŋqä näqŋqä-pqä iquau, Iqueŋi pizqä päsqaŋguwäŋga, Iqu hea hŋquaqui-hŋque äwiqe, aŋgumä vauniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisasi Iqu eeqäpnä ätnäŋä iqi tquaŋga, Pitä iqu Iqueŋi, haqä nänä ätuma äwäqe, “Si kukŋuä iiŋi, awä matqä panä. Ii quvqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pitä iqu i tquaŋga, Jisasi Iqu yakmbä iqe, Iqueqä ämaqä iquau äqunä, Pitä iqueŋi, maŋä mi äminyätä, “Setänä, Goti Iqutä mäkä-huŋqä iquki, hoptäwä manyqä, qänaki nyi! Tqä kŋuä indqäŋqe, Goti Iqueä ma, ämaqä iquauqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","E ätuäqe, Iqu, ämaqeutä, Iqueqä ämaqä iquautä tääqä ätuätumeqe, tii ätukqe. “Ämaqä hŋqu Nyi qänaki nyivändätŋqä etaŋgutqe, iqu, iqueqä-kiuäŋqä kŋuä mämeqä, iqueqä zä-huätati huŋqe ämetä, Nyi qänaki nyivändänä. ");
INSERT INTO mcr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ii tiiŋiqä. Ämaqä hŋqu, iqueqä häŋä-pmeqe a yäŋänäqŋqä äkiqätmitätqe, qui imäknäniqeqä. Iŋäqe ämaqä hŋqu, Nyinyqätä, kukŋuä äŋguä we-huŋqä-täŋiŋqätä, kŋuä indqänätä, iqueqä häŋä-pmeqe ävquatämämitätqe, iqu häŋä pmetäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Itaŋga ämaqä hŋqu, nätmatqä qua täutaŋi eeqä ämetä, äpäkoŋgqe, iqueqä nätmatqä eeqänäŋä iiŋi, yätamäkqä äänä väniqiyä? ");
INSERT INTO mcr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Itaŋga ämaqä hŋqu, iqueqä quuvqe aŋgumä metŋqe, squäsua väniŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Itaŋgaŋi, apäkä, qokique äväma qaŋä hiŋgi qŋqä eŋqä-paŋä iiŋi, ämaqä täŋga äpmeŋuwi, asä e imäkäpu, Goti Iqueŋi tuwä äväpu, suqä quvqä imäkätqäŋä. Iŋi, ämaqä hŋqu qutä anä äpme, Nyiŋqätä, Nyaqä kukŋuiŋqätä womba wiŋgaŋgutqe, Ämaqeuqä Ymeqä Ekqä Iqu, Kaniqueä yäŋänäqŋqä motqueqä di ämetä, Goti Iqueqä eŋätqä iquatä äppqäŋgaŋi, Iqu ämaqä iquenyqä womba yäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iŋgaŋi Jisasi Iqu quŋi, “Nyi naqä-qakuä etqä. Ämaqä täqi tä ätqäuŋuwä hŋqua, mäpäkoŋqä, häŋä yqänä äpmapiyäŋgaŋi, Goti Iqunä miqe, Iqueqä yäŋänäqŋqetä äpqaŋgutqe, hiŋuä qumbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hiunji 6 ae äpäwqaŋgaŋi, Jisasi Iqu, Pitä ique, Jemisi ique, itaŋga Jonä ique itmeqe, qoqoŋä quäuqä hŋqueŋqä ätuma ekqe. Iqiŋi iquauqä-quwänä äpmamiŋuwi. Iquauä hiŋuä iqisaŋi, Jisasi Iqu huiwä huitaŋä iŋgqäqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iqueqä qäki, we-huŋqä aaŋä qäpaiqänäŋä äyämiŋqe. Ämaqä qua täutaŋä hŋqu, ämuasmäŋqä qäpaiqä iiŋä eŋqä-pa timäutŋqe, änä mimäkqä yänä. ");
INSERT INTO mcr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iŋgaŋi iqua, Laisa iqutä, Mosisi iqutä, iquaqu, Jisasi Iqutä anä ätqäunyä, kukŋuä tätqätaŋgä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ii äqunäpiyiŋqä, Pitä iqu Jisasi Iqueŋi, “Ämotqueqä Naqä Iquki, ne täqi äpmeŋque, ii äŋguänäŋiqä. Ne ittäŋä aŋä hŋquaqu-hŋque mätatuŋqueqä. Hŋqu Tqäŋqä, ŋŋ hŋqu Mosisi iqueqäŋqä, itaŋga hŋqu Laisa iqueqäŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitä iqu kukŋuä ii ätukqe, iqua zä kiiŋä ipu, ga iqu kukŋuä äänä täniŋqe, kŋuä yasämä mäwimeqä iqaŋgi, ii ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Iŋgaŋi qaquvqä hŋqu äpäqe, iquauŋi äpatqäkqe. Iwä qaquvqä iqueuä yäpä imdaŋi kukŋuä hŋqu tii ätkqe. “Tä Ŋqä Ymeqä aaŋä kiiŋa änyinätŋqä Iqueyqä. Iqueqä kukŋui qätä wipiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I tqaŋgi äwipiyi, qu hiŋuä qävqä ikuwi, ämaqä aaŋqä eä, Jisasi Iqunä qutä tqäutaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Qu qoqoŋä yätuta äpäpiyäŋgaŋi, Jisasi Iqu iquauŋi, “Ämaqeuqä Ymeqä Ekqä Iqu häŋä vauniqäŋgaŋqe, hiqä hiŋuitä äqunäŋuwiŋqe, ämaqeuŋi, awä mätquä pambiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Qu, Iqu tquaŋgqä-pa, awä matqä ipu, yatŋqä tii iŋguwi. “Häŋä vauqe, ii squäwä?” ");
INSERT INTO mcr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Itaŋga qu Iqueŋi, yatŋqä tii äwikuwi. “Kukŋuä-suqeŋqä näqŋqä iqua, ‘Laisa iqu-ganä päŋqiyä-qe’ suŋqä tätqäŋäuä?” ");
INSERT INTO mcr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I tquaŋguwäŋga, Jisasi Iqu, “Ii naqä-qakuänäyi. Laisa iqu-ganä äpätä, nätmatqä eeqänäŋi, aŋgumä äŋguä imäkäŋqiyä. Iŋä-qe, Goti Iqueqä bukä iuŋi, ‘Ämaqeuqä Ymeqä Ekqä Iqueŋi, qu himä-wiuŋqä kiiŋä äväpu, täŋä-huŋqä kuapänä meniqeqe,’ tuwaŋuä iiŋi, suŋqä ätä äqänänä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“I etaŋgi Nyi he tiiŋä etmqe. Laisa iqu ae äpkqe. Ga Goti Iqueqä bukiu äqänäŋqä-pa, qu quwqä äwiŋqeunä ipu, suqä quvqä huitaŋä-huitaŋä itquakuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iqua äppiyi, Iqueqä wäuŋuäŋqä ämotquamiŋqä huizi iquau wimapŋqä ipiyäŋgaŋi, ämaqä kuapänäŋi, iquau äpputmäupu, ga kukŋuä-suqeŋqä näqŋqä hŋqua, iquauqä kukŋui mändi kittqäpŋqä itqätaŋgä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ämaqä eeqänäŋi, Jisasi Iqu äpqaŋgi äqumbiyäŋgaŋi, yäuŋuä ipu, Iquenyqä maqänä äupiyi, yeeqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iŋgaŋi Iqu quŋi, yatŋqä tii äwikqe. “He iquatäŋi, maŋä-mäkä suŋqä äunätqäŋäuä?” ");
INSERT INTO mcr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","I tquaŋga, ämaqä hŋqu ämävauqe, “Näqŋqä-vqä Iquki, ŋqä ymeqä dŋä quvqä ätqäuä kukŋuä matqä itqätaŋgi, Sinyŋqä ätuma äpqänä. ");
INSERT INTO mcr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dŋä quvqä iqu iqueŋi, ppqä yätŋqä imäkätä, qua iqi ämatnmäutŋqe. Ga, iqu makusewä kuä äsätä, hiquaŋi maŋgtäsqukuä ämäuqe, yukä hipa woä äwimäutŋqe. Iiŋä etaŋgi nyi, Tqä wäuŋuäŋqä ämotquetqäŋä iquauŋi, huätä mamäupŋqä yatŋqä vqaŋga, iqua iiŋi änä mimäkqä iqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","I äwiyäqe, Jisasi Iqu iquauŋi, “He ämaqä quuvqä maeqiyqä tquenä! Nyi hesä anäŋi, squäŋgaŋqä pmamqäwä? Ä, hesaŋi haŋä-iqe, squäŋgaŋqä meqämqäwä?” ätuätä, tii ätukqe. “Ymeqä iqueŋi, ätuma bpiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","I tquaŋga, qu ymeqä iqueŋi, Iquenyqä itmeqaŋguwäŋga, dŋä quvqä iqu, Ique hiŋuä äqunäqäŋgaŋi, ymeqä iqueŋi ppqä yätŋqä imäkqaŋga, ymeqä iqu qua iqi äpäknäqe, iqueqä maŋi makusewä kuä äsätä, qua iqi huaqä-huaqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","I iqaŋga, Jisasi Iqu kanique, yatŋqä tii äwikqe. “Ymeqä tqueŋi, äkŋgata ti äwimakqäwä?” Kimaŋi, “Däŋäŋga äwimakqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Dŋä quvqä iqu, ymeqä ique pizqä päsätŋqe, tä iu ämävetä, ä eqä du ämäyetä, ii iqa äwätŋqe. Itaŋgi Si nätmatqä hui yätamäkqä iqä-täŋä eŋi, yenyqä huäqä kuŋgaŋguti, yätamäkqä yeyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","I tquaŋga, Jisasi Iqu iqueŋi, “Si ‘Yätamäkqä iqä-täŋä eŋiuä’ ändŋi, suŋqä ändnyä? Quuvqä eqiyätquŋuwä iqua, nätmatqä eeqä timäutŋqä imäkpŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","I tquaŋganä, kaniqu maŋä yäŋänäqŋqe, “Nyi quuvqä eqiyäŋqä-qe, Si nyi äwa iqeuŋi, yätamäkqä nyisŋqä äktqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iŋgaŋi, Jisasi Iqu ämaqä kuapänäŋi tnäŋä pqaŋgä äqunäqe, Iqu dŋä quvqä iqueŋi, “Dŋä quvqä kukŋuä matqä, qätä mäwiyqä imäkqä iquki, nyi si, ymeqä iquesa täŋgi huätä ätimäutnä, ga aŋgi mäpaquvqä isŋqä äktqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I tquaŋga, dŋä quvqä iqu zääqä ganä ätäqe, ymeqä iqueŋi ppqä yäŋänäqŋqä yätŋqä iwimäkäqe, huätä ätimäukqe. Itaŋga ymeqä iqu pizqänäŋä-qu witaŋga, ämaqä kuapänäŋi, “Ymeqä iqu näwi äpäkonä äwinä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","I witaŋga, Jisasi Iqu iqueqä hipaeu a ämaqätätä, pämä vauqumuatqaŋga, iqu pämä ätqäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Qänakŋi, Jisasi Iqu aŋä iu pmetaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, quwqä-quwänä anä äpmapu, “Ne dŋä quvqä iqueŋi, huätä mandowatqe, suŋqä iququwä?” ätuäpu, yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iwä, Iqu iquauŋi, “Dŋä quvqä tiiŋi, nätmatqä huisä mändowatqä, kiqä Goti Iquenyqä tääqä ätäpiyä iutanänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Qu iqi ävämaŋi, qua Galili iuŋi jänä ämäwqätäukuwi. Iŋgaŋi Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquaunä näqŋqä vätŋqä wiŋgaŋgi, Iqu ämaqe, Iquenyqä “Iqiyqe” näqŋqä mapŋqä diŋqe, mawiŋqä ikqe. Iqu iquauŋi tii ätumiŋqe. “Ämaqeuqä Ymeqä Ekqä Iqueŋi, itumepu ämaqä iquauä hipa iu wipnuwiqä. Itaŋga qu Iqueŋi pizqänä päkpnuwiqä. Hiunji hŋquaqu-hŋque ae äpäwqaŋgaŋi, Iqu aŋgumä häŋä vauniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iqu kukŋuä ii tquaŋgqeŋqe, iqua näqŋqä mämeqä qäyä ipu, ga zä wiŋgaŋgqeutaŋi, Iqueŋi yatŋqä mävqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iqua Kapänamä ätimäupiyi, aŋiu äpmapiyäŋgaŋi, Jisasi Iqu iquauŋi, “He hänaqä dutaŋi suŋqä ätŋgapätqäŋuwäwä?” ätuätä, yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","I tquaŋga, iqua hänaqä dutaŋi, “Nyi naqeqä, nyi naqeqä” ätŋgapkuwä etaŋgqeŋqä, kukŋuä hui kima mätquä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iqu quamä ae äpmeqetaŋi, 12 iquau, “Eä-embiyä!” ätuäqe, tii ätukqe. “Ämaqä hŋqu naqä-pmeqäŋqä wiŋgaŋgutqe, iiŋä iqu eeqänäŋä iquauqä yäpakä, itaŋga iquauqä wäuŋuä-wiyqä hetŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","I ätuäqetaŋi, Iqu ymeqä wäŋqä hmbi itumeqe, iquauä awä iqi ätquteäqe, ymeqä iqueŋi atukuä ämaitä, iquau tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ämaqä hŋqu ymeqä wäŋqä hmbiŋi, Nyiŋqä kŋuä äme, yeeqä itumeqäqe, iqu Nyi indmeqiyä. Itaŋga Nyi indmeqäqe, ii iqu Nyinä mindmeqä iqiyä. Iqu Nyi änändowatkqä Ique, inä itumeqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","I tquaŋga, Jonä iqu Jisasi Iqueŋi, “Näqŋqä-vqä Iquki, ämaqä nesä anä mikiqä itŋqä hŋqu, saqä yoqeta dŋä quvqä huätä dowatqaŋgi äqunätanä, ne iqueŋi, ‘Iiŋi mimäkqä panä!’ ätukqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jonä iqu i tqaŋga, Jisasi Iqu, “He ique pmua mimäkqä pambiyä” ätukqe. “Ämaqä hŋqu, nätmatqä ämaqä mimäkqänäŋä di, Nyaqä yoqeta imäkqä iqu, Nyiŋqä kukŋuä quvqä di maqänä matqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ämaqä ne hŋgisa minetqueqä iquwä iqua, neyaqä-quayqä. ");
INSERT INTO mcr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nyi naqä-qakuä etqä. He Kraisi Ique qänaki vändqä-quenä etaŋguwiŋqä, ämaqe, he eqä-häki, ämbŋqä etapquwi, qu hiŋgi metapqä iqä. Qu Goti Iquesaŋi, äŋgui ämapnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ymeqä Nyinyqä quuvqä eqiyätŋqä täutaŋä hmbu, ämaqä hŋqueuä suqä imäkqaŋgqä iu hiŋuä äqunätä, asä iiŋä imäkätä quanŋä päkŋgaŋgutqe, ämaqä suqä ipäqiyqä iqueŋi, haŋä-iqä naqänäŋi wimenä. Ämaqä hŋqua hikä naqänäŋä hŋqu ämepu, iqueqä hiiŋuä-qo iu guä äkiqiyepu, eqä-huäŋä bu tnämäueqaŋgpqe, ii haŋä-iqä naqä-qe, huizique mämäwqätäuqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Tqä hipa hŋqu suqä quvqeuŋqä äkiyqiyäma uwqaŋgutqe, huätä täwisŋqe. Si iiŋä iŋi, häŋä hea ique-ique pmeqe ämatŋi. Iiŋä miqä isqe, hipa qäquaqu yqänä nyqä-quki, tä maisquä yäniqä äsäŋqeu äktnämäupnuwi. Hipa hŋqunä änyäŋi, ämäwqätäutŋi. ");
INSERT INTO mcr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Itaŋga tqä yukä hŋqu suqä quvqeuŋqä äkiyqiyäma uwqaŋgutqe, huätä täwisŋqe. Si iiŋä iŋi, häŋä hea ique-ique pmeqe ämatŋi. Iiŋä miqä isqe, yukä qäquaqu yqänä nyqä-quki, tä maisquä yäniqä äsäŋqeu äktnämäupnuwi. Yukä hŋqunä änyäŋi, ämäwqätäutŋi. ");
INSERT INTO mcr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ä tqä hiŋuä hŋqu suqä quvqeuŋqä äkiyqiyäma uwqaŋgutqe, huätä tquätŋqe. Si iiŋä iŋi, häŋä hea ique-ique pmeqä ämatŋi. Iiŋä miqä isqe, hiŋuä qäquaqu yqänä qŋqä-quki, tä maisquä äsäŋqeu äktnämäupnuwi. Ä hiŋuä hŋqunä äqänäŋi, Goti Iqunä miqeuŋi äpaqutŋi. ");
INSERT INTO mcr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tä iiŋä äsäŋqä iqueŋi, Piweqe mapäkoŋqä ipu, itaŋga te maisquä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Haki, nätmatqä äpakänä witpŋqä imäkätŋqä-pa, ämaqä eeqänäŋä iuŋi, te äpakänä e imäkäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Haki äŋguänä etaŋgqä-qe, kiqä ätquäŋqä di qäpu eqäqe, ga aŋgi ätquänätŋqeŋqe, äänä imäkpni? Hakä eŋqä-paŋuenä ätimäupu, itaŋga äwqä haŋuä iŋquenä pmapŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisasi Iqu aŋä-himqä iuŋi äväma, qua Jutiya iuŋqätä, itaŋga eqä Jotänä yätäqäŋgisaŋqätä äukqe. Iŋgaŋi ämaqä kuapänäŋä aŋgumä Ique wimeqaŋguwaŋga, ga Iqueqä suqä hea ique-ique imiŋqä-pa, Goti Iqueqä kukŋuiŋqä näqŋqä aŋgumä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iŋgaŋi Parisi hŋqua, Jisasi Ique äwimapiyi, yamwiqä äväpu yatŋqä tii äwikuwi. “Neqä suqä duŋi, ‘Ämaqä hŋqu iqueqä apäki huätä ändowatqäŋqä,’ ätnä, ‘ä mändowatqäŋqä’ ätnänä?” ");
INSERT INTO mcr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I tquaŋguwäŋga, Iqu tii ätukqe. “Mosisi iqu heŋi, suqä äki etapkqäwä?” ");
INSERT INTO mcr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iŋgaŋi qu tii ätukuwi. “Mosisi iqu, ‘Ämaqä hŋqu, iqueqä apäki huätä dowatätŋqä etaŋgutqe, iqu huätä dowatqä tuwaŋuä äqiyätä, huätä iŋga dowatätŋqeqä,’ ätkqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisasi Iqu, quŋi kima tii ätukqe. “Mosisi iqu suqä iiŋä imäkqäpŋqä ätätä tuwaŋuä äqäkqe, ii he nyuäŋä woyqä imbu, hŋgisanä iqä-quenä etaŋgqetanänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“I etaŋgi, aiŋgaŋi, Goti Iqu nätmatqä eeqänä ipäqiyätŋqä imäkätäqäŋgaŋi, ämaqe, ‘Iqu qokätä, apäkätä imäkkqe.’ ");
INSERT INTO mcr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Iiŋä imäkätäqetaŋi, tiiŋä ätkqeqä. ‘Qokä hŋqu, kandä-känatä ävämetä, iqueqä apäkisä guä ämänyinyä, huiwä naqä-hŋqunä änyinyä pmeqäŋqeqä.’ Goti Hanjuwä Iqu iiŋä ätkqetaŋi, qäyaqu huiwi hŋquaqu miŋqä, hŋqunä änyinyä pmesiyäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iiŋä etaŋgi nätmatqä Goti Hanjuwä Iqu naqä hŋqunä ämamonyetqe, ii ämaqä hŋqu mandumakqŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Itaŋga qu aŋiu äpmapiyäŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Jisasi Ique kukŋuä iiŋqä yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","I vquaŋguwäŋga, Iqu iquauŋi tii ätukqe. “Ämaqä hŋqu iqueqä apäki huätä ändowatätä, apäkä änyä-häŋä hui ämeqäqe, ämaqä iqu iqueqä apäkiŋi qui imäkätä, huizitä huiwä yaŋä hiŋgi ikiqä eŋqä-pa imäkqi. ");
INSERT INTO mcr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Itaŋga apäkä-pqä ii, iiyqä qoki äväma, qokä änyä-häŋä hŋque ämuaŋgqe, ii-pqe huizitä huiwä yaŋä hiŋgi ikiqä eŋqä-pa imäkqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ämaqä hui ymeqä wäŋqä isuauŋi, Jisasi Iqu hipa haqeqi wiyätŋqä, ätuma äwimakuwi. Ii ätuma wimeqaŋguwäŋga, wäuŋuäŋqä ämotquamiŋqä iqua, “Huätä ätuma upiyä!” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisasi Iqu hiŋuä ii äqunäqe, Iqu iquauŋi, upui-hiŋuä ämoqunätä, “Ymeqä wäŋqe, Nyinyqä qäyä äppiyä. Goti Iqunä miqeuŋi, täsua eŋqä-paŋä yäpäŋgisa epŋqä-qae, ‘Oeyqä’ matqä pambiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Nyi naqä-qakuä etqä. Ämaqä hŋqu Goti Iqunä miqä duŋi, ymeqä wäŋqä itmetqäŋuwä-pa mitmeqä da itqe, iqu Goti Iqunä miqä iuŋi, mäpaquvqä yäniqe.” ");
INSERT INTO mcr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ii ätuäqe, Iqu ymeqä hŋqunä-hŋqunä quvätäuku ämäqumuateqe, hipa nyuäŋä haqeqi äwiyätä, Goti Iqu äŋguä iwimäkätŋqä yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisasi Iqu qaŋä tii wätŋqä iqaŋga, ämaqä hŋqu Iquenyqä tnäŋä äpeyäqe, qoŋä äwoktäutä, Iqueŋi yatŋqä tii äwikqe. “Näqŋqä-vqä Äŋguä Iquki, nyi häŋä hea ique-ique pmeqe äänä itmä mamniqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","I tquaŋga, Jisasi Iqu, “‘Äŋguä Iqukiyqe’ suŋqä dnyä? Ämaqä äŋguänäŋi, Goti Hanjuwä Iqunänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Si kukŋuä-suqeŋqe, näqŋqä äyä eŋnä. Ii tiiŋä iquauŋqä, ‘Si ämaqä pizqä mapäsqä panä. Qokä-apäkä ämaŋqe, huizitä huiwi yaŋä mikiqä panä. Quwä mämeqä panä. Kukŋuä jänä imäkqä iqueŋi, tiwiqä quaŋgä mätquä panä. Ämaqeu quaŋgä ätuätnä, mämotauqä panä. Itaŋga tnaqä-tnuŋuau yäpä iqi qänaknä iqätŋqeqä’” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","I tquaŋga, ämaqä iqu, “Näqŋqä-vqä Iquki, ymeqäŋgatqä suqä iuŋi qänaknä iqa äpätŋqe, täŋga täsuwänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iŋgaŋi Jisasi Iqu, ique hiŋuä äqunäqetaŋi, Iquenyqä aaŋä kuapänä wiŋgaŋgi, “Nätmatqä hŋqu si äwa yqänä iŋinyä. Si nätmatqä ämeŋi, ga äwätnä, eeqänä mbqäŋqä imäkätnä, itaŋga ämaqä aaŋqä etaŋguwiu wisŋqeqä. Itaŋga si qäukuä yätuŋi yquayä-täŋä hesŋqänänyä. Ii ae imäkŋi, äpätnä, Nyi qänaki nyivändiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kukŋuä iiŋä qätä äwiyäqe, iqu yquayä kuapänäŋä-täŋu etaŋgqeŋqä, iqueqä äwqä imdaŋi haŋä-iqä ämetä, hipeŋui yäuä äpitä, ävämakqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","I uwqaŋga, Jisasi Iqu hiŋuä ipe-ipe äpäquŋgueyätä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau tii ätukqe. “Qua-yquayä kuapä-täŋä iqua, Goti Iqunä miqä duŋi, qeiqinyä ma, yäŋänäqŋqeuta paquvqeqä.” ");
INSERT INTO mcr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I tquaŋga, iqua Iqueä kukŋuiŋqä yäuŋuä ikuwi. Iiŋqe, Jisasi Iqu quŋi aŋgumä, “Ymeqä tquenä, Goti Iqunä miqeu paquvqe, qeiqinyä ma, yäŋänäqŋqeuta paquvqeqä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","“Kametqä hŋqu, qäkä guä ktäpiqä yäŋä hovqä iu wätŋqe, iqu yäŋänäqŋqä iutanä wänä. Iŋäqe, ämaqä mbqä kuapä-täŋä iqua, Goti Iqunä miqeu paqupŋqä yäŋänäqŋqe, kametqä iqueqeuŋi, ämäwqätäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iŋgaŋi iqua yäuŋuä naqänäŋä ipu, tii ätŋguwi. “Iŋi ämaqä qui imäknätqäŋuwitaŋi, häŋä hea ique-ique pmeqe, tqu meniqiyä?” ");
INSERT INTO mcr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisasi Iqu, iquau hiŋuä jänä äqunä, tii ätukqe. “Ämaqe, iiŋi änä mimäkqä iqaŋgpqä-qe, Goti Iqu äwa mämiqä yäŋqiyä. Nätmatqä eeqänäŋi, Iqu qäyunä imäkäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","I tquaŋga, Pitä iqu Jisasi Iqueŋi, “Hiŋuä qunä! Ne nätmatqä eeqänäŋi ävämaŋi, Si qänaki äyä äkivändäŋunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jisasi Iqu kimaŋi, “Nyi heŋi naqä-qakuä etqänä. Qua täuŋi, ämaqä tqu-tqu iqueqä aŋä, käta-käuŋgua, känanyi-känapqa, kanä-känäu, ymeqä, ä wäuŋuä-pqe, Nyiŋqätä, Ŋqä kukŋuä äŋguä we-huŋqä-täŋiŋqätä ävquatämäutqe, tŋäŋqe, asä iiŋä iqua, aaŋä hävemänäŋqe, inä ämeniqe. Itaŋga iqu haŋä-iqä qäsä mequänä. Iŋi hea yäpakäŋgaŋi, häŋä hea ique-ique pmeqä meniqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iŋäqe ämaqä, täŋga yoqä-täŋä eäŋuwä iutaŋä kuapänäŋä hŋqua, qänakŋi yoqä maeqäŋqe. Itaŋga täŋga yoqä maeqä eäŋuwi, iŋgaŋi yoqä naqä-täŋäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Qu Jerusälemäŋqä äyäpiyä iuŋi, Jisasi Iqu hiŋuiqä äwimamiŋqe. Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, yäuŋuä ipu, qänaki äymiŋuwi. Itaŋga huiziqua zä ipu, qänaki äwivändmiŋuwi. Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iquaunä itmeqe, Iqueqä-kiuä haŋä-iqä wimeniqä diŋqä, iquauŋi aŋgumä awä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Qätä nyipiyä. Täŋgaŋi ne Jerusälemäŋqä äyätanä, äyä ätqeyqunä. Yäŋiŋi, Ämaqeuqä Ymeqä Ekqä Iqueŋi, qu hiqäva-imäkqä naqä iquauqätä, kukŋuä-suqeŋqä näqŋqä iquauqätä, hipa iunä wipŋqäuä. Itaŋga iqua Iqueŋi, kukŋuä ämitäpu, ‘Iqu äpäkonätŋqeqä’ tpŋqäuä. Iŋgaŋi qu Iqueŋi, ämaqä Israitqä iqua qäyä etaŋgi, huizi iquau-mända wipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iŋi ämaqä iiŋä iqua, Iqueŋi ewiiqä kukŋuä ämitäpu, makukuä äwqutäpu, guä yäŋä-täŋi ämepu, täua ätäväpu, pizqä päkpnuwiqä. I etaŋgi hiunji hŋquaqu päwqaŋga, hŋquququeŋi ävauniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Itaŋi, Jemisi, Jonä, Sepri iqueqä hikŋä iquaqu, Jisasi Ique äwimayi, “Näqŋqä-vqä Iquki, Si yeqä äyeŋgaŋgi yatŋqä äkiyqueuŋi, imäktŋqeqä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","I tquaŋgiyäŋga, Jisasi Iqu iquaquiŋi, “Nyi qe squä qemäkmqä äqeŋgiyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I tquaŋga, iquaqu naqä pmanyiyäŋqä wiŋgaŋgi, Jisasi Iqueŋi, “Si yoqä naqä ämetnä, ämaqä ämitŋäŋgaŋi, ye hŋqu saqä hipa ämuaŋgisa, itaŋga hŋqu qunamäuqäŋgisa pmenyqueŋqä äyeŋgiyä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iiŋä tquaŋgiyäŋga, Jisasi Iqu iquaquiŋi, “Qe iiŋqä yatŋqä iqiyi, änyä maqŋqä eŋinyqä. Eqä-häkä Nyi nmqä änyäŋqe, qe-pqä inä änyiyäŋqätanä? Itaŋga, asŋä Nyi meqaŋgqä-pa, qe-pqe ämayäŋqä-tanä?” ");
INSERT INTO mcr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iŋi, “Ye imäkeŋqueuä” ätukiyi. Jisasi Iqu iquaquiŋi, “Eqä-häkä nyi nmqä iqeuŋi, qe-pqe inä änyiyäŋqeqä, itaŋga asŋä Nyi meqaŋgqeuŋi, qe-pqe inä mayäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","I etaŋgi, Nyaqä hipa ämuaŋgisatä, ä qunamäuqäŋgisatä pmanyiyäŋqe, Nyi atäuŋuä miqä da imqänä. Goti Iqu ämaqä hŋquaqu atäuŋuä itä, zä-hawi ämaqä iquaquinyqä näwenyä ämaeqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wäuŋuäŋqä ämotquamiŋqä 10 iqua, Jemisi, Jonä gueqi ii tquaŋginyä äwiyäpiyä iutaŋi, qu iquaqui himänä äwiyäpu, äwqä äkasuwä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iŋgaŋi Jisasi Iqu eeqäquau tääqä ätuätumeqe, tii ätukqe. “He näqŋqä äyuwä. Ne Israitqä qäyä etaŋgi, huizi iquau miqä epiyä iqua, yäŋänäqŋqetä, yoqä naqetä ämapu, quwqä ämaqeuŋi, äwiŋqä quwqä dunä qänaknä ipŋqä iwimäkätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Iiŋä etaŋgi, hiyaqä awä iqiŋi, suqä tä mäwiqä itŋqeqä. Oeyqä. Ämaqä hŋqu, hiyaqä awä iqisaŋi, hiqä ämeyätŋqä wiŋgaŋgutqe, iqu heqä wäuŋuä-eyqä-qu pmetŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Auä, ämaqä hŋqu, hiqä naqä pmetŋqä wiŋgaŋgutqe, iqu hiyaqä wäuŋuä-eyqä hiŋgäŋqä-qu pmetŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ii tii etaŋgqä dutayi. Ämaqeuqä Ymeqä Ekqä Iqu suqä iiŋi asä inä imäkqiyä. Iqu äpkqe, ämaqe Ique wäuŋuä yätamäkqä wipŋqä äpkqä manä, oeyqä. Iqu äpkqe, iquau wäuŋuä yätamäkqä ävätä, Iqueqä häŋä-pmeqe ävätä, qokä-apäkä kuapänäŋä iquau aŋgu mbqä imetŋqä äpkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Itaŋi Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, aŋä himqä Jeriko ätimäukuwi. Iquatä, ämaqä kuapänäŋitä ävämeqaŋguwäŋgaŋi, ämaqä hiŋuä pisqä, Batimiyasi, Timiyasi iqueqä hikŋä iqu, huäŋqä maŋä iqi äpme, mbqä nätmatqä isuauŋqä tquämanmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iqu, “Jisasi Nasäretqätaŋä Iqueqä” tqaŋgä äwiyäqetaŋi, aawqä yäŋänäqŋqä ätätä, tii ätkqe. “Jisasi, Dewiti iqueqä Ymeqä Iquki, Si nyiŋqä huäqä äkunänä.” ");
INSERT INTO mcr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","I tquaŋga, ämaqä kuapänäŋi, iqueŋi äminyäpu, “Aawqä matqä panä!” ätukuwi. Ii qäyä ätquaŋgä, iqu aawqä yäŋänäqŋqä yqänänä, “Dewiti iqueqä Ymeqä Iquki, nyiŋqä huäqä äkunänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisasi Iqu iqi ätqepäqe, “Ique tääqä tuätumapiyä” ätukqe. Iŋgaŋi qu hiŋuä pisqä iqueŋi, “Iqu siŋqä ‘Äpänä!’ ätqi. Mä pämä ätqätnä, tqä äwqe haŋuä äknätnä biyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","I tquaŋguwäŋgaŋi, iqueqä gquä quäuqä huätä äquvätämäuqe, ätkamäutä, Jisasi Iquenyqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iqu äwimeqaŋga, Jisasi Iqu, “Nyi äänä ikimäkmqäwä?” ätukqe. “Näqŋqä-vqä Iquki, nyi aŋgumä hiŋuä qänmqä nyimäkiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I tquaŋga, Jisasi Iqu “Si yqä uvä! Tqä quuvqä heqiyqe, äŋguä ikimäkqiyä” ätukqe. Asä qäŋgaŋi, iqu hiŋuä äŋguä äqänätä, Jisasi Ique hänaqeu qänaki äwivändkqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Itaŋga iqua, Jerusälemä-täŋä qäqi timäupŋqä ipiyäŋgaŋi, aŋä-himqä Betäpaketä, Betanitä, qoqoŋä Olipä iu ätimäukuwi. Iŋgaŋi, Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋquaqui, hiŋuiqä ändowatätä, tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Qe aŋä-himqä näŋinyqä winyqä. Qe yäpä iŋgisa äwäsiyäŋgaŋi, doŋgi hipkä hŋque guä äkiqiyequwä qunyinyä. Doŋgi iqueŋi, ämaqä hŋqu haqeqi mäpmeqä imiŋqä iquvi. Iqueŋi guä ewesinyä, ätuma äquvepinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Ämaqä hŋqu, ‘Qe doŋgi gue, suŋqä hiweqinyqä’ qesqaŋgutqe, qe kimaŋi, ‘Naqä Iqueqä wäuŋuä-täŋiqä. Ga Iqu ämaqä huisä aŋgumä maqänä dowatäŋqiyä,’ suinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","I tquaŋga, iquaqu äwiyi, doŋgi hipkä hŋqu, hänaqä iqi, aŋä qŋqaŋä-täŋä iqi guä qäyänätaŋgi äquŋgiyi. Iquaqu eweqaŋgiyäŋga, ämaqä iqi ätqäumiŋuwä hŋqua, iquaquiŋi, “Doŋgi iqueŋi suŋqä eweqinyqä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","I tquaŋguwäŋga, iquaqu quŋi, Jisasi Iqu ätukqä-pa ätukiyi. I tquaŋgiyäŋga, ämaqä iqua, iquaquiŋi, “Yqä ätuma winyqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Iŋgaŋi, iquaqu doŋgi, Jisasi Iquenyqä ätuma äpiyi, gquä quäuqä äquvätäsinyä, doŋgi iqueä haqeqi ipteqaŋgiyäŋga, Jisasi Iqu haqeu qe äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iŋgaŋi ämaqä kuapänäŋi, quwqä gquä quäuqe, äquvätäpu, hänaqeu äqäqasäueqäkuwi. Ga ämaqä huiziqua, zä-äpa wäuŋuiuŋi ätäväpu, hänaqä iqi äqäqasäueqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ämaqä hiŋuiqä äwäpiyitä, ä qänaki äwivändäpiyitä, pu-aawqä ätäpu, tii ätkuwi. “Goti Hanjuwä Iqueä yoqe haqeqä äwinä! Naqä Iqueqä yoqeta äquvepätŋqä Tqueŋi, Goti Hanjuwä Iqu äŋguänäŋä iwimäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Neqä awiqu Dewiti iquesaŋä äpätŋqä Tqu, Iqueqä ämaqeu miqe, Goti Iqu äŋguä itquenä. Goti Haqä Yätu Äpmeŋqä Iqueqä yoqe, haqeqä ämamäunä.” ");
INSERT INTO mcr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisasi Iqu Jerusälemä ätimäuqe, hiqäva-imäkqä aŋiu äpaquväqe, nätmatqä eeqä hiŋuä äqunäkäkqe. Ae hea äyä eqaŋga, Iqueqä ämaqä 12 iquatä, Betaniŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Awiŋgaŋi, qu Betanisa äpäpiyäŋgaŋi, Jisasi Iqu buayä dä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iŋgaŋi Iqu zä-eaqä hŋqu quwqä kuapänä nänyä änyä tqäutaŋgi äqunäqe, häukuä wiqäŋqä hiŋuäŋqä äukqe. Näŋi ätimäuqe, aaŋqä, quwqenä änyätaŋgi äquŋgqe. Iŋgaŋi zä-eaqä häukuä qäyqäŋga mayi. ");
INSERT INTO mcr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ii äqunäqe, tii ätukqe. “Zä iquki, ämaqe-pqä hui aŋgumä häukui äkndopu, makŋqä danä ipnuwiqä.” Iwä Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, iiŋä äyä tquaŋgi äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusälemä ätimäupiyi, Jisasi Iqu hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa äpäyäqe, Iqu ämaqä mbqä wäuŋuä imäkätqätaŋguwä eeqänäŋi, huätä äpäsäwqatkqe. Itaŋga ämaqä mbqä huitaŋi tŋäŋqä imäkäpu vätqätaŋguwä iquauqä hevqetä, ämaqä yŋŋä-heeqe mbqä itqätaŋguwä iquauqä zä-hawitä ämäquvasqiyekqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Itaŋga hiqäva-imäkqä aŋä ququawä iqiŋi, nätmatqä hui mbqä ipŋqä mäpeyqäŋqä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iqu ämaqä näqŋqä ävätä, “Goti Iqueä tuwaŋuiuŋi, tiiŋä äqänä. ‘Ŋqä aŋiŋqe, “Ämaqä eeqänä tääqä dqä aŋiqä” tpnuwiqä.’ Iŋä-qe, he quwä-meqä iquauqä zä-pmeqä aŋä eŋqä-paŋä imäkätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iŋgaŋi hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, qätä iiŋä äwipiyi, Iquenyqä zä ipu, Ique äpäkpŋqä diŋqä huäŋqä huiŋqä qävqä ikuwi. Qu zä ikuwi, ämaqä kuapänäŋi, Jisasi Iqueä näqŋqä vqaŋgqeŋqä yäuŋuä ipu, miiqä yäŋä iqaŋguwitanji. ");
INSERT INTO mcr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Heaetäŋi, Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, aŋä-himqeuŋi äväma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Awiŋga zä-hiŋuitäŋi, qu huäŋqeu äwäpiyäŋgaŋi, zä-eaqä hiŋuä äquŋguwi, quatä buta himqä yätuŋqä yäuä pitaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","I äqunäpiyiŋqä, Pitä iqu kŋuä indqänäqe, “Näqŋqä-vqä Iquki, Si hiŋuä qunyä! Zä-eaqä äkasuwä ätuŋä iqu, yäuä ae äpiqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","I tquaŋga Jisasi Iqu iquauŋi, “He Goti Iquenyqä quuvqä heqäpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Nyi naqä-qakuä etqä. Ämaqä hŋqu qoqoŋä hŋque, ‘Ävauätnä eqä-pŋä bu päkinyä’ ätque, iqueqä quuvqä mŋi, ‘Matimäuqä yäŋqiyä’ kŋuä mämeqä eä, ‘Iiŋi ätimäuŋqiyä’ kŋuä äme, ätquäqe, iqueqä ätqaŋgutqä dunä ätimäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Iiŋä etaŋgi Nyi he etqä, nätmatqä huiŋqä Goti Ique tääqä ätuäpu yatŋqä ävquwi, ‘Ne ämeŋqunä’ kŋuä ämapu quuvqä eqäpqe, he ämapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Itaŋga he Goti Iqueŋqä tääqä tpŋqä ätqäpiyäŋgaŋi, he hŋqutä äwqä äkasuwä-täŋä eäŋuwi, iŋi iqueqä suqä quvqä etquetŋqeŋqä äwqä haŋuä imäknäpu, hui imäuquwi, heqä Heniqu Qäukuä Haqä Yätuŋä Iqu, heqä suqä quvqe huätä ämaemäutä, äwqä haŋuä imäknäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Qu aŋgumä Jerusälemä ätimäupiyäŋgaŋi, Jisasi Iqu hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa ikitqätaŋga, hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, ämaqä naqä iquatä, Ique äwimapiyi, “Si nätmatqä tä imäktŋqe, yoqä naqe, äŋgisa ämeŋäwä? ‘Si ii imäktŋqe’ tqu äktkqäwä?” ätuäpu yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","I tquaŋguwäŋga, Jisasi Iqu, “Nyi yatŋqä hŋqu hemqänänjqä” ätukqe. “He Nyi yatŋqä eyqe awä dqäpi, Nyi wäuŋuä tä imäkmqä yoqä ändapkqä Iqueŋqe, etmqänä. ");
INSERT INTO mcr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Häe! He Nyi awä dpu. Jonä asŋä-qäyqä iqu wäuŋuä imäkmiŋqe, yoqä naqe, qäukuä haqä yätuta ämakqäta, ä ämaqä iquauta ämakqätanä?” ");
INSERT INTO mcr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iŋgaŋi quwqä-quwä tii ätŋguwi. “Ne ‘Qäukuä haqä yätutaŋiqä’ tquaŋguatqe, Iqu tiiŋä natäŋqiyä. ‘He iquenyqä quuvqä maeqiyqe, suŋqä itqäŋuwäwä?’ ");
INSERT INTO mcr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Iŋäqe, ne ‘Ämaqetanjqä’ tuatuŋquäta? I matqä yatuŋqueqä” ätŋguwi. Ämaqe, “Jonä iqu, hiŋuä-tqä-queqä” kŋuä indqänätaŋguwiŋqe, zä ipu, matqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iŋi qu kimaŋi, “Ne maqŋqeqä” ätukuwi. I tquaŋguwäŋgaŋi, Jisasi Iqu, “Nyi-pqe inänji. Nyi yoqä naqä-täŋä eämä, wäuŋuä e imäkätŋqeŋqe, he awä maetqä ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iŋgaŋi Jisasi Iqu quŋi, kukŋuä ktqä tii ätukqe. “Ämaqä hŋqu guä-wainqä vowä ikqäwätä, täkŋä äqiyäqe, guä-wainqä häukui qonjqä itä, eqä päquveqätŋqä, hikä huä ätäkätä iquqonmäuqe, ämaqä wäuŋuiuŋqä hiŋuä äqumbu pmeqä aŋä quäuqä ämätäqe, itaŋga wäuŋui, ämaqä mbqä meqä imäkpŋqä hŋquauqä hipa iu äwimä, aŋä kiŋä nämqä wäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iwä häukui yäuä änduqäŋgaŋi, iqu iqueqä wäuŋuä-wiyqä hŋque, wainqä häukui hui äpatäpu wipŋqä, wäuŋuä miqä iquauŋqä dowatäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iqu ätimäuqaŋgaŋi, wäuŋuä miqä iqua, iqueŋi a äkiqätäpu, ptqä äpäsäpu, nätmatqä hui a maqätqä aŋgumä dowatpnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iŋi wäuŋuä-wiyqä hŋque aŋgumä inä dowatäniqe. Wäuŋuä miqä iqua iqueŋä-pqe nyuäŋiu äpäsäpu womba-iŋqä itquapnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ii qäyä iqaŋgpi, Iqu hŋqu-pqä inä dowatäniqe. Iŋgaŋi qu iqueŋi pizqä päkpnuwi. Itaŋga kuapänäŋi, suqä asä ii itquapnuwi. Hŋquauŋi, ptqä äpäsäpu, itaŋga hŋquauŋi, pizqä päkpnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iŋgaŋi iqueqä ymeqä, iqueŋqä kuapänä äwinymitätqä iqunä yqänä pmetäniqe. Iwä yäpaki, ‘Wäuŋuä miqä iqua, nyaqä ymeqä iqueŋi, qätä wipŋqäuä’ ätätä, iqu, iqueqä ymeqä ique dowatäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","8","Iŋgaŋi wäuŋuä miqä iqua, ‘Kaqä ämeniqä-qu, täsqukuänä’ tmbnuwi. ‘Maqänänyä! Pizqä äpäsanä. Ga iqueqä wäuŋuä tä, neqä nemänätŋqänänyä’ ätnäpu, ique a äkiqätäpu, pizqä äpäkpiyi, iqueä huiwi wäuŋuä täkŋä yäpaqä mäŋgisa matnämäupnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iŋgaŋi kaqä wäuŋuä iutäŋä kawiqu, äänä yäniqe? Iqu äpätä, wäuŋuä miqä iquauŋi pizqä äpäsätä, wäuŋui huizi iqua mipŋqä väniqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iŋi he Goti Iqueä buki a matäuqä itqäŋuwäta? ‘Hikä-aŋä-mätqä iqua, hiki quvqä wäuŋuä maeqä hiŋuinä äquŋguwi, hikä iiŋä iqu, aŋä quea eŋqä-paŋä, aŋä yäŋänäqŋqä imäkqä-queqä. ");
INSERT INTO mcr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iŋi tä, Naqä Iqueqä imäkqaŋgi ne hiŋuä äqunätaqe, äŋguänäŋä äqunäŋu.’” ");
INSERT INTO mcr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iqu i tquaŋga, Israitqä iquauqä ämaqä naqä iqua, kukŋuä ktqä ii, iquauŋqä äyä tqaŋgqeŋqä näqŋqä ekuwi. Iŋgaŋi iqua, Iqueŋi guä qäyanätpu ikuwi, ämaqä kuapänä etaŋguwiŋqä zä wiŋgaŋgi qanyä äväma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ämaqä naqä iqua, Parisi hŋquatä, Heroti iqueŋqä äwinyämiŋqä hŋquatäŋi, Jisasi Iqu kukŋuä quvqä hui tqaŋgutqe äkäpŋqä, Ique yamwiqä wipŋqä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ique äwimapiyi, “Näqŋqä-vqä Iquki, ne Tqä suqeŋqä näqŋqä tii eŋu. Ämaqeuqä yoqeŋqätä, quwqä äwiŋqeŋqätä kŋuä mindqäŋqä itnä, suqä jänänäŋinä imäkätnä, Goti Iqueqä suqeŋqä qäyunä ämotquetqäŋnä. Iŋi Si kŋuä äänä äkiyqiyä? Romätaŋä ämiqä naqä Sisa iqueŋi, ne mbqä takisi ävquatuŋquätanä, mävqä iquatuŋquätanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iqua yatŋqä naqä-qakuä mävqä iqaŋguwiŋqe, Iqu näqŋqä eäqe, kima tii ätukqe. “He Nyi yamwiqe, suŋqä nyiyqä? Mbqä hikä hŋqu, Nyi hiŋuä qunmqä äma quveppu.” ");
INSERT INTO mcr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iqua hŋqu äma pqaŋguwäŋga, Iqu quŋi ämävauqe, “Ktqä tätä, ä yoqä tätäŋi, tqueqä pmenä?” ätukqe. Qu, “Romätaŋä naqä iqueqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iqu kimaŋi, “Iŋi, nätmatqä Sisa iqueqä etaŋgutqe, ii kaqä-que wipŋqeqä. Ä nätmatqä Goti Hanjuwä Iqueqä etaŋgutqe, ii Goti Ique wipŋqeqä” ätukqe. I tquaŋga, qu Iqueä kukŋuiŋqä miiqä hii imäkäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satyusi, ‘Ämaqä pizqä äpäkombqä iqua, aŋgumä häŋä mävauqä ipnuwiqä’ ätmiŋuwä iqua, Jisasi Ique äwimapiyi, yatŋqä tii äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Näqŋqä-vqä Iquki, Mosisi iqu bukä iuŋi, Israitqä iqunenyqä tiiŋä ätätä äqäkqe. ‘Ämaqä hŋqu apäkä ämetä, ymeqä maeqä äpäkonätqe, käŋguequ apäqŋqä ämetä, kätequenyqä tŋäŋqä hiätŋqe, ymeqä hemeŋqiyä.’ ");
INSERT INTO mcr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Itaŋga hiŋuiqänäŋi, ämaqä 7 hŋguiqua äpmamiŋuwi. Itaŋga iŋguiquautaŋi, kätequ apäkä ämeqe, ymeqä meämeqäŋga äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Itaŋi käuŋguequ apäqŋqä iiŋi ämeqe, ymeqä meämeqäŋga äpäkoŋgqe. Itaŋga käuŋgua huizi iqu, apäkä asä ii ämetä, äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iŋi eeqänäŋä iŋguiqua, apäkä iiŋi ämapiyi, qu ymeqä meämeqäŋga äpäkoŋguwi. Yäpaki, apäkä ii inä äpäkoŋgqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Iŋi, ämaqä äpäkombqä iqua äŋgumä ävauqaŋguwäŋgaŋi, apäkä eeqäŋguiqua ämamiŋuwä täsi, tqueqä heäniqäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iiŋä tquaŋguwäŋga, Jisasi Iqu tii ätukqe. “He Goti Iqueä bukiu äqänäŋqeŋqätä, itaŋga Iqueä yäŋänäqŋqeŋqätä maqŋqä, qämä-qämä ipu, ii ätqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hea iŋgaŋi, ämaqä ae äpäkombqä iqua aŋgumä ävaupiyäŋgaŋi, qokä-apäkä mämaŋqä ipnuwiqä. Oeyä. Qu eŋätqä qäukuä yätuŋä iqua äpmeŋuwä-pa, iiŋä pmapnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Itaŋgi ämaqä äpäkombqä aŋgumä ävaupnuwäŋqe, Nyi yatŋqä hemqeqä. He Mosisi iqueä tuwaŋuä zä-yäŋä-täŋi tä äŋgqeŋqä a matäuqä itqäŋuwenda? Iŋgaŋi Goti Iqu Mosisi iqueŋi, ‘Nyi Aprähamä, Aisakä, ä Jekopä iquauqä, Goti Iqunjqä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Goti Iqu, ämaqä ae äpäkoŋguwä iquauqä manä. Ämaqä häŋä äpmeŋuwä iquauqä Goti Iqueqä. Iiŋä etaŋgi, Aprähamä, Aisakä, Jekopä, iqua ae äpäkoŋguwä-qe, häŋä yqänä äpmeŋä. Iiŋä eŋqä di, he qämä-qämä kuapänä ipu ätätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iqua kukŋuä yqänä tätqätaŋguwäŋga, kukŋuä-suqeŋqä näqŋqä hŋqu äpäqe, qätä äwikqe. Jisasi Iqu quvaqä yatŋqeuŋi, kima äŋguänä äyä tquaŋgi äwiyäqe, iqu Jisasi Ique yatŋqä tii äwikqe. “Kukŋuä-suqä Goti Iqu Mosisi ique äwikqä, ga huizi iquau kiŋganä ämäwqätäuŋqe, äkisqukuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iqu yatŋqä ii vqaŋga, Jisasi Iqu kima tii ätukqe. “Suqä kiŋganäŋä iqu, tiinji. ‘Israitqä iquenä, kukŋuä tä qätä äŋguänä wipu. Goti neqä Naqä Iqu, Kiqä-kiuänäŋä Iquvqä. ");
INSERT INTO mcr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Itaŋga Goti Hanjuwä tqä Naqä Iqueŋi, si tqä äwqetä, qeqä-quuvqetä, kŋuä indqäŋqetä, yäŋänäqŋqetäŋi, Ique näwe äwinyätnä, Iquenyqänä kuapänä kiŋguätŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Itaŋi huizi iqu tiiyi. ‘Si tqä-täuŋqä äkinyätŋqä-paŋi, ämaqä si-täŋä iqi äpmeŋuwä iquauŋqä-pqe, inä kinyätŋqeqä.’ Suqä iquaquiŋi, huizi iqua mämäwqätäuqä eŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","I tquaŋga, kukŋuä-suqeŋqä näqŋqä iqu tii ätukqe. “Näqŋqä-vqä Iquki, Si naqä-qakuä qäyunä ätnyä. Goti hui aaŋqe! Iqu Kiqä-kiuänä äpme. ");
INSERT INTO mcr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Itaŋga ne neqä qeqä-quuvqe, kŋuä indqäŋqe, yäŋänäqŋqe, Goti Iqueŋi, ävätanä, Iquenyqä kiiŋä neŋguätŋqe. Itaŋga neqä-neuäŋqä änenyätŋqä-pa, ämaqä huizi iquauŋqä-pqe inä neŋguätŋqe. Ne iiŋä ituŋque, ii naŋuä, nätmatqä huitaŋä-huitaŋätä hiqäva äqiyätanä, Goti Iquenyqä tä ikeqeuŋi, suqä tquaqu ämäwqätäuŋinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisasi Iqu, ämaqä iqu kŋuä äŋguä indqänätä tquaŋgi äwiyäqe, iqueŋi tii ätukqe. “Si Goti Iqunä miqeuŋi, qäqiqi äpmeŋinyä” ätukqe. Iutaŋi, ämaqä eeqä zä ipu, Ique yatŋqä hui mävqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisasi Iqu hiqäva-imäkqä aŋä mätnätaŋgqä iqi näqŋqä ävätä, tii ätukqe. “Kukŋuä-suqeŋqä näqŋqä iqua, Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu Ique atäuŋuä ikqä Iquenyqe, ‘Dewiti iqueqä Ymeqä Iqueqe,’ iqua näqŋqä äänä epu tätqäŋä? ");
INSERT INTO mcr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dewiti iqunäŋi, Goti Iqueqä Dŋä Äŋguä Iqu, ique kŋuä vqaŋgi, tii ätkqe. ‘Naqä Hanjuwä Iqu, ŋqä Naqä Ique tii ätukqeqä. “Nyi Tqä himä-wiuŋqä iquauŋi, Saqä yäpä iqi pmuatekimniqäŋgaŋqe, Si Nyaqä hipa ämuaŋgisa pmettŋqinyä,” ätkqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Iŋi änääŋgä? Kraisi Iqueŋi, Dewiti iqunä, ‘Ŋqä naqueä’ ätukqä-qe, ämaqe, Iquenyqe, ‘Dewiti iqueqä ymeqeqä’ änääŋqä tätqäŋäuä?” ätukqe. Ämaqä kuapänäŋi, qu Jisasi Iqueqä kukŋui qätä äwiyäpiyäŋgaŋi, yeeqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisasi Iqu näqŋqä ävätäqä iŋgaŋi, Iqu tii-pqä inä ätukqe. “Kukŋuä-suqeŋqä näqŋqä iquauqä suqä quvqeŋqe, wa wipiyä. Qu suqä tquauŋqe, kiiŋä äwinyänä. Gquä quäuqä ipmbu qaŋä upŋqäuä. Ququawä aquväqŋqeuŋi, ämaqe iquauŋi, ‘Hiunjiŋganjqä’ tupŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aŋä aquväqŋqeuŋi, aŋä äŋguä iqinyä pmapŋqäuä. Ymisaŋä naqä imäkqäŋgaŋä-pqe, aŋä äŋguä iqinyä pmapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iŋi qu apäqŋqä iuauŋi, quaŋgä ätuäpu, quwqä aŋi quwä mapŋqäuä. Qu tääqä quäuqä ätäpu, Goti Hanjuwä Iquenyqä quaŋgä tquäpŋqäuä. Iqu suqä quvqä iwäsäuniqäŋgaŋi, ämaqä iiŋä iqua, quwqä haŋä-iqe, ämaqä huizi iquauqe, ämäwqätäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iŋgaŋi Jisasi Iqu, Goti Iquenyqä mbqä tnämäuqaŋguwä-täŋä iqi äpmeqe, ämaqä mbqä tnämäuqaŋguwi, hiŋuä äqunä äpmamiŋqe. Ga ämaqä mbqä hatŋä-täŋä kuapänäŋi, mbqä hävemnäqŋqä ätnämäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iŋgaŋi apäkä nätmatqä maeqä yawiqä hui äpäqe, mbqä wäŋqä hnjuaqunä ätnämäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iqu ii äqunäqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau, tääqä ätuätumetä tii ätukqe. “Nyi naqä-qakuä etqä. Apäkä nätmatqä maeqä yawiqä täsiyqä mbqä ätnämäuqe, ämaqä Goti Iquenyqä mbqä tnämäuqä täu ätnämäuquwi, iiyqe, eeqänäŋä iuqe, ämäwqätäuqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Itaŋga qokä-apäkä quwqä mbqä kuapä iutaŋi, wäŋqä hmbu ätnämäuqäuä. Apäkä täsi iiŋä ma, mbqäŋqä äwa itä iiyqä quuvqäŋqä äwiŋqepu, eeqänä qe ätnämäuqä-qae, aaŋqä pmeŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","I ätäqe, Jisasi Iqu hiqäva-imäkqä aŋiutaŋi yäpaqäŋgisa ätimäwa pqaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋqu, “Näqŋqä-vqä Iquki, Si hiqäva-imäkqä aŋi hiŋuä qunyä. Kiqä hikä naqetä, aŋä qeqätqetäŋi, äänä ämätukuwätiyä-qe, ne iiŋqä maŋä matqä yaŋqunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","I tquaŋga Jisasi Iqu iqueŋi, “Si aŋä naqä tä mätnätaŋgqä tquauŋi hiŋuä äqunäŋnä? Hikä iqua yäŋqä-mäŋqeu yqänä tii makŋqä, qäpu heniqeqä. Eeqäpnä qäpu äsisäupu, bi tnämäupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Jisasi Iqu qoqoŋä Olipä iu, hiqäva-imäkqä aŋä näŋgisa mätnätaŋgi äqunä pmetaŋgaŋi, Pitä ique, Jemisi ique, Jonä ique, itaŋga Endru ique, iqua quwqä-quwänä Jisasi Iqueŋi yatŋqä tii äwikuwi. “Nätmatqä iiŋi, äkŋga timäuniqä iiŋqä, natiyä. Itaŋga ne squä-ganä mänätqueqaŋguti, ga ne iutaŋi näqŋqä eätanä, ‘Ou, nätmatqä tiiŋä tqua timäuniqeŋqä äyä änatqiyä,’ kŋuä neyäniŋqäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Yatŋqä ii vqaŋguwäŋga, Iqu iquauŋi, tii ätukqe. “Qu quaŋgä etäpu, hiqä kŋuä indqäŋqä qui emäkqäŋqe, he mimbiyä. Ämaqä kuapänä hŋqunä-hŋqunä ätimäuqisäpu, Ŋqä yoqe ätäqisäpu, ‘Nyi qäqunjqä’ ätäpu, ämaqä kuapänäŋä iuqä kŋuä indqäŋqe, qui iwimäkäqisqäpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Itaŋga he ämaqe mäkä naqänäŋä päuŋgeyqaŋguwi qätä äwiyäpu, ‘Ämaqä kiŋä daŋä hui mäkä äunätqäŋäuä’ tqaŋgä qätä äwiyäpiyäŋgaŋi, he zä ipu, yäuŋuä-yäuŋuä miqä pa iqäpŋqä. Nätmatqä iiŋi ätimäutäqä-qe, hiunji yäpaki änänjqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ämaqä huitaŋä iqua, hueqä-himqä huitaŋä iquatäŋi, mäkä vauqumuatpnuwiqä. Ämaqä miqä hŋqueqä mäkä-iqä iqua, huiziqueqä iquatäŋi, mäkä humbnuwiqä. Hŋqäqiŋi, qua ekä yäniqeqä. Itaŋga hŋqäqiŋi, buayä dä naqänäŋä timäuniqeqä. Apäkä iua, ymeqä änä ämipŋqä täŋä-huŋqä ämetqäŋuwä-paŋi, nätmatqä iiŋä iqua-ganä timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Iiŋä etaŋgi, he yasämä mimbiyä. Ämaqä naqä kukŋuä mitqä iquauŋqä etma upnuwi. Itaŋga aŋä aquväqŋqä iu ptqä hepäkpnuwi. Itaŋga qu Nyi mändi äŋgittqiyäpu, he aŋä-himqeutaŋä ämaqä naqä iquauä hiŋuä iqi ekitqätepnuwi. Ii he iquau kukŋuä äŋguä we-huŋqä-täŋi, awä eeqä tupŋqeŋqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Itaŋga Ämaqä eeqänäŋä, qua äwitqutäŋqä-pa, qu kukŋuä äŋguä we-huŋqä-täŋiŋqe, qätä-ganä wipnuwäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Itaŋga qu etmepu, kukŋuäŋqä etma uwqaŋgpqe, ‘Ne kukŋuä äänä tatuŋquäwä?’ kŋuä maeyqä itä, zä miqä iqäpnä. Iŋgaŋi kukŋui, he matqä, Goti Iqueqä Dŋä Äŋguä Iqu täniqeqä. Iŋi, he kŋuä Goti Iqu etapqaŋgqenä tqäpnä. ");
INSERT INTO mcr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ämaqä hui quwqä käta-käŋgueque, huiziqua ique pizqä päkpŋqä iiŋqe, quwqä hipa iu wipnuwiqä. Itaŋi kaniqukua, quwqä ymeqä iquau-pqe, suqä asitaŋinä itquapnuwiqä. Itaŋga ymeqä iqua, kunaqä-kunuŋuautä-pqe, mäkä äunäpu asä ii ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","He Nyaqä yoqä-täŋuenä etaŋgi, ämaqä eeqänäŋi himä-wiuŋqä emäkqäpnuwiqä. Iŋäqe qokä-apäkä haŋä-iqä qäpu etqäŋgaŋqä yäŋä äqämbu äpmamitpqä iqua, Goti Hanjuwä Iqu häŋä iqumuatäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Ämaqä kukŋuä tä a ätäutäqä iqu, näqŋqä äŋguänä mequätŋqe.) “He nätmatqä qui imäkqä quvqänäŋä iqu aŋä pmua imäknäŋqä iqi tqäutaŋgi qumbnuwiqä. Iŋgaŋi qokä-apäkä qua Jutiya iu äpmeŋuwä iqua, ze, qoqoŋä yätuŋqä yqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ä ämaqä aŋä atääqä hevqä iu äpmamitätqä iqu, qua mäŋi ikuapmäutäqäŋgaŋi, iqu aŋä yäpä yäŋgisa mäpeyqä itä, iqueqä nätmatqä aŋä yäpä iŋgisa witaŋgutqeŋqä kŋuä mindqäŋqä itä, hämänänä zä uwquäŋqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ŋŋ ämaqä, iqueqä wäuŋuä iu äpmamitätqä iqu, iqueqä gquä quäuqä metŋqä aŋgumä mäwqä iquäŋqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Itaŋga, apäkä äwqä-täŋä iuauŋqätä, ymeqä aŋuäŋqä-täŋä iuauŋqätäŋi, zä maqänä mäwqä iqaŋgpqeŋqe, huäqä kiiŋä huŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nätmatqä quvqä iiŋi, yuŋuä quŋqäŋga matimäuqä yätŋqä diŋqe, he Goti Hanjuwä Iqueŋqä tääqä tqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Itaŋga haŋä-iqä iŋga timäuniqe, naqänäŋä ämäwqätäuniqe. Goti Iqu qua imäkkqäŋgata täŋga tiŋqe, haŋä-iqä tqutä asänäŋi matimäuqä imiŋqeqä. Qänakndaŋä-pqe, iiŋi matimäuqä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Haŋä-iqeŋqe, Naqä Iqu, ‘Wäŋqäpu wäniqeqä’ ae ätkqeqä. Iqu iiŋä mimäkqä-säpi, ämaqä eeqänä qui imäkŋgäpniŋgä. Iŋäqe Iqu qokä-apäkä Iqueqäŋqä atäuŋuä ikqä iquauŋqä kŋuä indqänätä, wäŋqäpu hiätŋqä imäkäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Iŋgaŋi ämaqä hui, ‘He hiŋuä qumbiyä! Kraisi ne ämineyätŋqä Goti Iqu ique atäuŋuä ikqä iqu täqi äpmenä,’ ä ‘Näŋi äpmenä’ etqaŋgpqe, he qätä mäwiyqä pa iqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ii tiiŋä etaŋgi. Ämaqä quaŋgä-tqä hui ätimäupu, ‘Nyi Kraisi he ämeyqäŋqä Goti Hanjuwä Iqu atäuŋuä änyikqä iqunjqä’ etäpu, ämaqe kŋuä iqä mapŋqeŋqä, nätmatqä ämaqä mimäkqänäŋä huitaŋä-huitaŋi imäkpnuwiqä. Quaŋgä-tqä iiŋä iqua, ämaqä Goti Hanjuwä Iqu, Iqueqäŋqä atäuŋuä ikqä iquauŋi, qäyasäqi ätuma wanä-tpu ipnuwiqä. Itaŋga ämaqä huizi, ‘Nyi hiŋuä-tqä iqunjqä’ ätäpu, asänäŋä imäkpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Iiŋä etaŋgi nätmatqä eeqä timäuniqeŋqä Nyi ganä awä näwi etqä. Iŋi he yasämä mimbiyä. ");
INSERT INTO mcr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Itaŋga, haŋä-iqä naqänäŋä ae etqä iqua qäpu hiqaŋgaŋi, maqänäŋi mäptqä iqu hea äwitä, qaŋuä iqu mäyäŋqä itä, qätäqueqä iqua qäukuä yätuŋi äväma qua täu qiyäpäkŋgaŋguwäŋga, ga nätmatqä yäŋänäqŋqä qäukuä yätu äwiŋuwi ämeŋä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iŋgaŋi qu, Ämaqeuqä Ymeqä Ekqä Iqu qaquvqä iu äpme, Iqueqä yäŋänäqŋqetä, Iqueqä we-huŋqä naqänäŋä itä pqaŋgi qumbnuwi. ");
INSERT INTO mcr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iŋgaŋi Iqu eŋätqä iquau ändowatätä, ämaqä ‘Ŋqeqä’ ätätä atäuŋuä ikqä iquauŋi, qäukuä-qua hituŋuä äwitqutäŋqä-pa, aquvä eeqänä maqiyäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Itaŋga zä-eaqä iqu ämetquetŋqeŋqä näqŋqä mapiyä. Kiqä äpa iuŋi, eqä yqänä änyä, quwqä mŋi änyä-häŋä iŋgqäqe, näqŋqä tiiŋä iqäpŋqä. Yuŋuä äqunätŋqe qäpu eätä, mäptqä dŋä hinätŋqe, qäqi etaŋgiyqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Asä iiŋi, he nätmatqä Nyi etqäqä iiŋä ii timäwäwqaŋgi äqumbiyäŋgaŋi, he näqŋqä tiiŋä hipnuwiqä. Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqä aŋä hänaqä iu näwe tqäutaŋgiyqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nyi he naqä-qakuä etqä. Ämaqä hea iŋga pmapnuwä iqua, qu mapäkoŋqä yqänä pmetaŋguwäŋga, nätmatqä eeqänäŋi timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Qäukuitä, quaetä qäpu heniqe. Mä Nyaqä kukŋui qäpu maeqä yäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iŋäqe nätmatqä iiŋi äkŋga timäuniqä iiŋqe, ämaqä hŋqu änyä maqŋqä eänä. Ynaunjqä qäukuä yätutaŋä iquatä, Nyi Ymeqä Iqundäŋi, ne änyä maqŋqä eäŋunä. Apiqu Iqueqä-kiuänänjqä. ");
INSERT INTO mcr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nätmatqä iiŋi äkŋga timäuniŋqeŋqä änyä maqŋqä eäŋuwä-qae, yasämä ätuäqämepu, hiŋuä äqumbu pmetpŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ii tiiŋä eŋqä-paŋi. Ämaqä hŋqu kiŋä hmqä wätŋqä, ga iqu, iqueqä wäuŋuä-wiyqä iqua, iqueqä aŋä mipŋqä ävqä-paŋä iiŋiyi. Ga wäuŋui, ique-iqueqä äpatätä, kikiŋä väniqe. Iŋi, hänaqä qŋqaŋä miqä iqueŋi, ‘Yasämä ätuäqämanä pmettŋqeqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Iiŋä etaŋgi, ‘Kaqä aŋä-täŋä iqu, heaetäŋä-qe, ä quaesqäŋgaŋä-qe, ä zäŋqä kŋuä duätqätaŋgaŋä-qe, ŋŋ zä we-huŋgaŋgaŋä-qe, äkŋga ti päniqätiyä-qe’ änyä maqŋqä eäŋäuä. Iiŋqe, he yasämä ätuäqämepu, ga hui, ‘Iqu iŋga päŋqiyä’ kŋuä maeyätaŋga, äpätqe, hiqaqä witaŋgä hiqäŋqä iiŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nyi kukŋuä etqe, qokä-apäkä eeqänäŋä iu ätquä. ‘Ga yasämä ätuäqämapu pmäpŋqä iiŋqä’ etqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hiunji naqänäŋä Pasopa ätätqäŋuwä iqutä, bretqä yeŋuä qo-matäuqä hiunji iquatä timäutŋqä, hiunji hŋquaqu änyä äwämiŋqe. Iŋgaŋi hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatäŋi, kukŋuä ätqämanäpu, “Ne Jisasi Ique maqŋqä itmetanä pizqä päsatuŋque, äänä imäkatuŋquäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Ämaqe hiŋuä änaqänäpu mäkä ipäqiyqeŋqe, ne suqä iiŋi, hiunji naqänäŋäŋga mimäkqä yatuŋqueqä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisasi Iqu aŋä-himqä Betani, Saimonä Wänyimäŋqueä aŋiu buayä gmanätqätaŋga, apäkä hui hikä häkä eqä jinaŋä-weqä iŋqä hŋqu, äma äwimetä, häkä pmäukui ikuväqe, eqä jinaŋä-weqe Jisasi Iqueä nyuäŋiu äwiquatkqe. Häkitä, eqä jinaŋä-weqetä, kiqä mbqe naqänäŋi. ");
INSERT INTO mcr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iŋgaŋi apäkä ii, ii imäkqaŋgqeŋqä, ämaqä iqi pmamiŋuwä ii, äwqä äkasuwä imäkpiyi, quwqä-quwä, “Eqä jinaŋä-weqe, suŋqä hiŋgi qui imäkqiyä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Eqä jinaŋä-weqe, mbqä 300 täuqä imäknäqe, mbqä ämanäqe, ämaqä nätmatqä maeqä iu winätŋqänänjqä.” Ii ätmbiyi, apäkä iiŋi äkasuwä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","I tquaŋguwäŋga, Jisasi Iqu ätukqe. “Iiŋi hiŋuinä qumbiyä. Suŋqä haŋä-iqä vqäuä? Ii Nyi suqä äŋguänäŋi inmäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ämaqä nätmatqä maeqe, hesä anäŋi, hea ique-ique pmetpŋqäuä. Iiŋä etaŋgi, ‘Yätamäkqä eanä’ kŋuä eyqe, yätamäkqä wipŋqe. Mä Nyi iiŋä maetqe, Nyi hesä anäŋi, hea ique-ique mäpmeqä itmniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","“Apäkä täsiyqe, ae äyä imäkqiyä. Ii eqä jinaŋä-weqä änjiquatqe, Nyaqä huiwi qua witŋqeŋqä näwi-ganä inmäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nyi naqä-qakuä etqä. Aŋä eeqänäŋä im-imä kukŋuä äŋguä we-huŋqä-täŋi awä ätäkipiyäŋgaŋi, apäkä täsi inmäkqeŋqä awä inä tqäpŋqeqä. Iŋi qu iiŋqe, hui mimäuqä iqäpŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Itaŋga Jutasi Iskarioti, Jisasi Iqueqä ämaqä 12 iquautaŋä hŋqu, Jisasi Iqueŋi, hiqäva-imäkqä naqä iquauä hipa iu vätŋqä, täkqä tuätŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Qu iiŋä qätä äwipiyi, yeeqä ipu, “Ne naqä-qakuä mbqä hui ktapaŋqunä” ätukuwi. Iŋgaŋi iqu, “Äkŋga ti itmetmä wimqändiyä” tä iqe, huäŋqäŋqä qävqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hiunji naqänäŋä bretqä yeŋuä qo matäuqä bŋqä iquauqä hiunji kiŋganäŋä iqu ätimäukqe. Quväukuä ique-ique hiunji iqueŋi, Israitqä iqua Pasopaŋqä kŋuä indqänäpiyäŋgaŋi, sipsipqä hui äpäsäpu gpnä. Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, “Si Pasopa iutaŋä ymisaŋä dŋqe, ne nätmatqä näwinyäŋi äŋgi kimäkiyatuŋquäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iŋgaŋi Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋquaqui, ändowatätä tii atukqe. “Qe aŋä-himqä yätuŋqä hinyqä. Ämaqä eqä-häkä meqä hŋqu äqemeŋqiyä. Ga iqueŋi, qänaki wivändqinyqä. ");
INSERT INTO mcr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iqu aŋä yäpä yäŋgisa paquvqaŋga, aŋä kaniqueŋi, ‘Ämotqueqä Iqu, si yatŋqä kiyeŋqä äyandowatqiyä’ suinyqä. ‘“Nyitä, Ŋqä ämaqä wäuŋuäŋqä ämotquetŋqä iquatä, hiunji naqä tque, buayä natuŋquä aŋä hiqŋqä äŋgikä?” äyatqiyä,’ suinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Qe ii tquaŋgiyäŋga, iqu aŋä hiqŋqä naqänäŋä haqä yätqä ämätnäŋqä iqueŋi ämäqesqueŋqiyä. Iquvaŋätä, buayä ŋqätä, näwenyä imäknänä. Qe iqiŋi, buayä näwenyä inemäkinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I tquaŋga, iquaqu eyi, aŋä-himqä yätu ätimäyi, nätmatqä eeqänä Jisasi Iqu ätukqä-pa imäknätaŋga äqunyiyi, Pasopa iutaŋä ymisaŋä bŋqeŋqä näwi imäkkiyi. ");
INSERT INTO mcr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Heaetäŋi, Jisasi Iqutä, Iqueqä ämaqä 12 iquatä, eeqäqua ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Qu ymisaŋä änäpu äpmapiyäŋgaŋi, Jisasi Iqu, “Nyi naqä-qakuä etqä. Hesaŋä hŋqu, Nyiŋqä täkqä tuänä. Ii ämaqä Nyitä ymisaŋä anä änätqäŋuwä iquendaŋä hŋquvqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","I tquaŋga, iqua äwqä-haŋä ämepu, hŋqunä-hŋqunäŋi, “Ii nyi ma! Qäyutanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I tquaŋguwäŋga, Jisasi Iqu, “He 12 iquendaŋä hŋqueyqä. Ämaqä Nyitä bretqä hevqä asiu äyämetä äŋgqäqä iqueyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Ämaqeuqä Ymeqä Ekqä Iqu, Goti Hanjuwä Iqueqä bukä iuŋi, ‘Äpäkonäŋqiyä’ ätkqä-pa, Iqu e päkonäŋqiyä. Itaŋgi Ique himä-wiuŋqä iquau vätŋqä iquenyqe, iqueŋi haŋä-iqä naqänäŋä wimeŋqiyä. Ämaqä iiŋä imäkätŋqä iqueŋi, känai maunyqä-säpi, ii äŋguä hitäniŋgä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Qu ymisaŋä änäpiyäŋgaŋi, Jisasi Iqu bretqä hŋqu ämeqe, Goti Ique “äŋguiqä” ätuäqe, äkutätä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau, ävqäwätä tii ätukqe. “He mändaupiyä. Tä Nyaqä huiwiyqä.” ");
INSERT INTO mcr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Itaŋi Iqu wainqä-eqä-häkä ämeqe, Goti Ique “äŋguiqä” ätuäqe, iquau ae äväqetaŋi, eeqäqua iuta äŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Itaŋi, Iqu tii ätukqe. “Tä Nyaqä häŋeqeqä, Goti Iqu kukŋuä guä mäsäueŋqe, yäŋänäqŋqä imäkätŋqä diŋqeqä. Nyi ämaqä kuapänäŋä iu yätamäkqä vätŋqe, ŋqä häŋeqe equatqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Nyi naqä-qakuä etqä. Nyi wainqä-eqe, Goti Iqunä miqäŋga häŋi nmniqäŋgaŋqe, aŋgumä maŋqä imqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iŋgaŋi qu apqä hŋqu ätpiyi, aŋä-himqä iu äväma, qoqoŋä Olipäŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ii äwäpiyäŋgaŋi, Jisasi Iqu iquauŋi, tii ätukqe. “Heqä Nyinyqä quuvqä heqiyqe, mändi päwiŋqiyä. Ii Goti Hanjuwä Iqueqä bukä iuŋi, tiiŋä ätä äqänäŋqä-payqä. ‘Nyi sipsipqä-miqä ique päkmqänä. Iiŋä imäkqaŋgmdqäŋga, sipsipqä iqua zä im-imä wepnuwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Itaŋgi Goti Hanjuwä Iqu, Nyi aŋgi nyivauqumuatqaŋga, Nyi qua Galili iuŋqä hiŋuiqä emamniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","I tquaŋga Pitä iqu, “Iqua eeqänä, quwqä quuvqä heqiyqe mändi qäyä äpäwiqaŋguti, nyi ii miqä ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","I tquaŋga Jisasi Iqu, “Nyi naqä-qakuä äktqänä. Heatqä tqueŋi, kukutakisqä äkakä hŋquaqu matqäŋga, si Nyiŋqe, ‘Nyi Iquenyqä maqŋqeqe,’ hŋquaqu-hŋque ttŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jisasi Iqu ii tquaŋga, Pitä iqu yäŋä äqänätä, “Qäyä eänä. Si äpäkoŋgti, nyi-pqe anä päkoneŋqeqä. Nyi Sinyqe, ‘Iquenyqä maqŋqeqe’ matqä imqänä” ätukqe. Itaŋi wäuŋuäŋqä ämotquamiŋqä eeqänäŋä huiziqua-pqe, inyänä ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iŋgaŋi iqua, aŋä yoqä ‘Gesemäni’ qonätaŋgqeu ätimäupiyi, Jisasi Iqu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau, “Nyi Goti Iqutä kukŋuä teŋqueä. He täqi pmapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I ätuäqe, Iqu Pitä ique, Jemisi ique, itaŋga Jonä ique itumeqe, iqua Iqutä anä äukuwi. Iŋgaŋi Iqu haŋä-iqä wimetŋqä iqaŋgqeŋqä, Iqueqä äwqä tämŋi änä mäwimäŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Iiŋqe, Iqu tii ätukqe. “Haŋä-iqä tqu, Nyaqä qeqä-quuvqä tämŋi imbtäumäkqä-qae, ae qäqi äpäkonmqä iqä. He täqiŋi yasämä äminyäpu, pmapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iŋgaŋi Iqu nänä hmbu äwäqe, qua iqi äqiyäpäknätä, haŋä-iqä wimeqaŋgqä iqueŋqä huäŋqä hui etaŋgutqe äwimasiyätŋqä, Goti Ique kukŋuä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iqu, “Aba, Apiqukiyä. Si nätmatqä äwa mämiqä imäkqä Iquki, häkä haŋä-iqä-täŋä tqu, huätä mändavä. Iŋäqe Nyaqä änyiŋqeuŋi qäyä etaŋguti, Tqä äkiŋqä dunä isŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I ätäqe, aŋgi äpäqe, ämaqä anä ätuma äukqä iqua hiqaqä witaŋgä äquŋgqe. Iwä Pitä iqueŋi, “Saimonä iquki, änääŋäŋqäwä? He Nyitä anäŋi, wäŋqäpu mämiŋqä iquwiuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Yamwiqä iqe, he mändi maekittqiyqä yätŋqä diŋqe, he äminyäpu, Goti Iqutä kukŋuä tpiyä. Hiqä quuvqe, nätmatqä qäyunä imäkqäŋqä äwinyätaŋgqä-qe, huiwi yäŋänäqŋqä maeqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I ätuäqe, aŋgumä äwäqe, Goti Ique kukŋuä asi, aŋgumä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ae ätuäqe, iquauŋqä aŋgumä äpäqe, iqua hiŋuä kukuäŋuä wiyqaŋgi, hiqaqä witaŋgä äquŋgqe. Ique kukŋuä äki-äki tupŋqe, änyä maqŋqä yqänä emiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hŋquaqu-hŋque äwimetäqäŋgaŋi, Iqu iquauŋi, “He hiqaqä äwäpu, hapä yqänä äpmeŋäuä?” ätukqe. “Ga qäpu qenji. Hiunji tä, qäŋga qe ätimäuqiyä. Hiŋuä qumbu! Ämaqeuqä Ymeqä Ekqä Iqueŋi, suqä quvqä imäkqä iquauä hipa iuŋi, täkqä tqä iuta ävqiyä. ");
INSERT INTO mcr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","He pämä äpmepu, äwanä! Hiŋuä qumbiyä. Huiziuqä hipa iu nyivätŋqä iqu, ae qäqi ätimäutŋqä iqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisasi Iqu kukŋuä ii yqänä tätqätaŋga, Jutasi ämaqä 12 iquautaŋä iqu ätimäukqe. Iqutäŋi ämaqä kuapänä, ipäqäyuŋä, ä jävqä a äqätqa ätimäukuwi. Ämaqä ii, hiqäva-imäkqä naqä iquatä, ä kukŋuä-suqeŋqä näqŋqä iquatä, itaŋga qokä-apäkä iu miqä iquatä dowatqaŋgä, ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Qu änyä upŋqä imäknäpiyäŋgaŋi, täkqä-tqä iqu huiziquauŋi, tii ätukqe. “Nyi ‘Ämaqä Tqueyqä’ etätmi, kikiyä äwuŋgundi, he Iqueŋi a äkiqätäpu, yasämä ätuma uwqäpnä.” ");
INSERT INTO mcr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Qu ätimäupiyi, iqu Jisasi Ique äwimeqe, Iqueŋi, “Näqŋqä-vqä Iqukiyä” ätuätä, Ique himä kikiyä äwutäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iŋgaŋi qu Jisasi Ique itumepu, a yäŋänäqŋqä äkiqätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iqua, Ique a kiqaŋguwäŋga, Iqutä qäqi anä tqäumiŋuwä hŋqu, iqueqä ipäqäyuŋä ämäkäqiyäqe, hiqäva-imäkqä naqä iqueqä wäuŋuä-wiyqä hŋque, qätä mŋä hämänä ätqavämäukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iŋgaŋi Jisasi Iqu, “He ipäqäyuŋätä, jävqätä a äqätqa äpquwi, ämaqä äpäsätä quwä-meqä hŋque a äkiqätätqäŋuwä-pa, Nyi-pqe, iiŋunä etaŋgä äŋgiqätqäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","“Hiunji ique-ique Nyi hesä anä äpmamä, hiqäva-imäkqä aŋä ququawä iu näqŋqä vätqätaŋgqä iŋga maŋgiqätqe, suŋqä itqäŋuwäwä? Iŋäqe, he tä iquwi, kukŋuä Goti Iqueqä bukiu ätnäŋqeuŋi, qäyunä ätätaŋgqeŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iŋgaŋi Iqueqä ämaqä iqua, eeqänä zä äväma äwekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Zä ii uwqaŋguwäŋga, hikŋä gquä hŋqunä huäqä hutŋqä hŋqu, Jisasi Ique qänaki ti äwivändqaŋga, qu iqueŋi a kiqätqaŋguwäŋga, iqu gque iqinyä iquvesemä, ipätäkqä zä äukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Qu Jisasi Iqueŋi, hiqäva-imäkqä naqä iquenyqä ätuma äukuwi. Iŋgaŋi hiqäva-imäkqä naqä iquau, ämaqeu miqä iquau, itaŋga kukŋuä-suqeŋqä näqŋqä iquatä, qu iqi aquvä äqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitä iqu, Jisasi Iqueŋqä, kiŋä-tämä qänaki äumiŋqe. Hiqäva-imäkqä naqä iqueqä aŋä ququawä iqi ätimäuqe, iqiŋi, iqu ämaqä ämayukä-imaŋqä iquatä äpme, tä-diyeqä inyimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iŋgaŋi, Jisasi Ique pizqä päkpŋqeŋqä, hiqäva-imäkqä naqä iquatä, Israitqä iquau miqä hiuzi iqua qäsäŋä, Jisasi Iqu suqä quvqä imäkätŋqeŋqä qävqä yanätpiyi, ämävqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ämaqä kuapänä Iquenyqä quaŋgä kukŋuä täqisqaŋguwä-qe, quvaqä kukŋui yamuätqäŋqä ikuwi, asänä mäwqaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iŋgaŋi ämaqä hŋqua pämä ämatqäupiyi, Jisasi Iquenyqä quaŋgä kukŋuä tii ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ne Ämaqä Tqu tii tqaŋgi äwikque. ‘Goti Iqueqä hiqäva-imäkqä aŋä, ämaqä-qua mätqe, Nyi äqiyäpnetmä, aŋgumŋi, hiunji hŋquaqu-hŋque mätmniqeqä. Iŋäqe Nyi hipaetä mamätqä imqänä’ tqaŋgi, äwikqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","I tqaŋguwä-qe, quvaqä kukŋui asänä mäwqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","I tqaŋguwäŋga, hiqäva-imäkqä naqä iqu, iquauä hiŋuä iqi ätqäuä, Jisasi Ique yatŋqä tii äwikqe. “Ämaqä tä kukŋui Siŋqä ätquwi, änääŋgä? Si kima hui matqä isŋqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","I tquaŋgqä-qe, Jisasi Iqu kima miqä, Iqueä kukŋuä hui mätquä da ikqe. Iŋi, hiqäva-imäkqä naqä iqu aŋgumä yatŋqä tii äwikqe. “Kraisi, Goti Iqu ne ämineyätŋqä atäuŋuä äkikqä Iqukita? Ä Yoqä haqä yätu ämaetuŋquä Iqueqä Ymeqä Iqukitanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","I tquaŋga, Jisasi Iqu, “Nyi qäqunjqä. Itaŋga Ämaqeuqä Ymeqä Ekqä Iqu, Yäŋänäqŋqä-täŋä Iqueqä hipa ämuaŋgisa pmetaŋgi hiŋuä qumbnuwiqä. Itaŋga Iqu qaquvqeu pmeqä qäukuä yätuta quvepqaŋgi qumbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iqu i tqaŋgqeŋqä, hiqäva-imäkqä naqä iqu äwqä tnäŋä wiŋgaŋgi, iqueqä gquä quäuqä äpisätä, tii ätukqe. “Iquenyqä kukŋuä hui inä natpŋqe, ne suŋqä qävqä yatuŋquäwä? ");
INSERT INTO mcr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Iqueä kukŋui, Goti Ique äkittqiyätä tqaŋgi, qätä äyä äwiyäŋunä. Ga heyaqä kŋuä imŋi, äänä eyqi?” Iŋgaŋi eeqänäŋi qu, “Iqu suqä quvqä imäkqä-qae, qäyä päkonätŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Itaŋi ämaqä hŋqua, Iqueŋi makukuä äwqutäpu, hiŋuä huäqä äkeuätäpu, hipa äpäsäpu, “Si tqu kpäsqiyä? Hiŋuä natiyä” ätumiŋuwi. Itaŋga ämayukä-imaŋqä iqua, Iqueŋi itmepu hipa äpäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pitä iqu täkŋä yäŋgisa ququawä mäŋi pmetaŋga, hiqäva-imäkqä naqä iqueqä wäuŋuä-wiyqä apäkä hui äpäqe, Pitä iqu tä diyeqä imäknätqätaŋgi äqunäqe, ique hiŋuä yqänä äqunä, “Si Jisasi Nasäretqätaŋä Iqutä anä äpmetqäŋiyä iqukuiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ii iiŋä tquaŋgqeŋqä, iqu, “Oeyqä, si ii ätŋi, nyi änyä maqŋqä eŋänä” ätuäqe, yäpaqäŋgisa äwätä, täkŋä hävqä qänätaŋgqä iqi ätqäukqe. Iŋgaŋi kukutakisqä hŋqu äkakä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wäuŋuä-wiyqä ii, iqueŋi iqi äqunäqe, aŋgumä ämaqä iqi tqäutaŋguwiuŋi, “Ämaqä tqu, qutä anä äpmetqäŋuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ii käyä ätquaŋgi, Pitä iqu aŋgumä “Oeyä” ätkqe. Iwä wäŋqä hmbu ti imäŋgaŋga, ämaqä iqi ätqäumiŋuwä iqua, “Si Galilisaŋä iqukiyqä. Iŋi si oeyä matqä pa. Si, qutä anä äpmetqäŋuwiqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ga iŋgaŋi iqu tii ätukqe. “Ämaqä tä ätätqäŋuwä Iquenyqe, nyi änyä maqŋqä eŋä. Nyi quaŋgä etqändi, Goti Iqu, nyi qui nyimäkäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iqu kukŋuä iiŋi ae ti tqaŋga, kukutakisqä äkakä huiziqu ätkqe. Iŋgaŋi Pitä iqu, Jisasi Iqu “Kukutakisqä äkakä hŋquaqu matqäŋga, si Nyiŋqe, ‘Nyi Iquenyqä maqŋqeqe,’ hŋqaqu-hŋque ttŋqinyä” ätukqeŋqä kŋuä äwikqe. Iŋgaŋi, iqu iiŋä imäkätäqeŋqä huäqä kiiŋä wuŋgaŋgi, kŋuä kuapänä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zä we-huŋgaŋgqetäŋi, hiqäva-imäkqä naqä iqua, kukŋuä-suqeŋqä näqŋqä iquautä, ŋŋ ämaqä naqä huiziquautäŋi, qu Israitqä iquau miqä eeqänäŋä iqua qäsäŋi, kukŋuä naqä-hŋqunä imäkkuwi. Itaŋi qu Jisasi Ique guä äkiqiyäupu, ätuma Pailoti ique äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Itaŋga Pailoti iqu, “Si Israitqä iquau Miqä Naqä Iqukitanä?” ätuätä, yatŋqä äwikqe. Jisasi Iqu ämävauqe, “Iiŋi, si qe ätnyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iŋgaŋi hiqäva-imäkqä naqä iqua, Jisasi Iquenyqe, “Iqu suqä quvqä iiŋä-iiŋä imäkätŋqeqä” ätqua äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Iiŋä etaŋgi Pailoti iqu Iqueŋi, “Si kukŋuä hui kima matqä isŋqätanä?” ätuätä, yatŋqä aŋgumä äwikqe. “Hiŋuä qunyä. Qu Sinyqe, ‘Suqä quvqä iiŋä-iiŋä imäkätŋqeqä’ äyä ätqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","I tquaŋga, Jisasi Iqu kukŋuä hŋqu mätquä ikqe. Iqu i iqaŋgqeŋqä, Pailoti iqu, “Kukŋuä hui matqä suŋqä iqutiyä” tä, kŋuä kuapänä ämakqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Quväkuä ique-ique, Pasopa imäkäpiyäŋgaŋi, Israitqä iqua, “Ne guä pmetaŋguwä iquautaŋä iquenyqä äneŋgiyä” tqaŋguwä iqueŋi, Pailoti iqu huätä äwiqutemiŋqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iŋgaŋi ämaqä hŋqua, ämiqä naqä iquau huätä mamanä-tpu ipu, huiu pizqä äpäkkuwiŋqä guä äpmamiŋuwi. Qutaŋä hŋqu, Baräpasi iquvi. ");
INSERT INTO mcr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Itaŋga ämaqä kuapä aquvä äqäŋguwä iqua, Pailoti ique äwimepu, “Hiŋuiqänä imäkmiŋä-pa, iiŋä imäkiyä” ätuäpu, yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Qu iiŋä tquaŋguwäŋga, Pailoti iqu, “Israitqä iquau Miqä Naqä Tqueŋi, huätä equtäutmä etapmqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hiqäva-imäkqä naqä iqua, Jisasi Iqu yoqä naqä metqätaŋgqeŋqä äwqä quvqä imäkäpu, Ique ätuma vqaŋguwiŋqä, Pailoti iqu näqŋqä yasämä eäqeŋqä, ii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pailoti iqu i tquaŋgqä-qe, hiqäva-imäkqä naqä iqua, qokä-apäkiuqä kŋuä iuŋi hiŋi-hiŋi iwimäkäpu, Pailoti iqueŋi, “Jisasi Iqu qäyä etaŋguti, Baräpasi Iquenyqeqä” tupŋqä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iŋgaŋi Pailoti iqu, “Iŋi, ‘Israitqä iquau Miqä Naqä Iqueqä’ ätätqäŋuwä Iqueŋi, nyi äänä imäkmqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iiŋä tquaŋga, qu kima tnäŋä tii ätukuwi, “Iqueŋi, zä-huätati hunätŋqä imäkiyä!” ");
INSERT INTO mcr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Iiŋä tquaŋguwäŋga, “Iiŋi suŋqe? Iqu suqä quvqä äki imäkätŋqäwä?” ätukqe. Kimaŋi, qu maŋä yäŋänäqŋqä ätäpu, “Zä-huätati hunätŋqä imäkiyä!” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","I tquaŋguwäŋga, iqu, qokä-apäkiu yeeqä iwimäkätŋqä wiŋgaŋgi, Baräpasi iqueŋi quŋqä huätä äwiqutekqe. Itaŋga iqu, Jisasi Ique ptqä päkpŋqä imäkätä, ämaqä mäkä-iqä iquau hipa iu zä-huätatä huepŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pailoti iqu, iquau vqaŋga, mäkä-iqä iqua, Jisasi Iqueŋi, kiyapqä iqueqä aŋä ququawä yäŋgisa ätuma äpeyäpiyäŋgaŋi, mäkä-iqä huizi iquauŋqä tääqä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iŋgaŋi iqua Ique mändi äkittqiyäpu, quaŋgä ämiqä naqä eŋqä-pa hiätŋqä tii imäkkuwi. Iqiŋi qu iqueŋi, qäkä ipisqä hämänäŋä hŋqu äwiyätpiyi, guä yäŋä-täŋi ämaqä naqä hŋqueä yŋŋa-näŋä äkuäquväpu, Iqueä nyuäŋiu ämuäkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","I imäkpiyi, qu iqueŋi, “Israitqä iquau Miqä Naqä Iquki! Hiunjiŋganjqä” ätuäpu, häsuäŋitä Iqueä nyuäŋiu äpäsäpu, Iqueŋi makukuä äwqutäpu, itaŋga suqä ämaqä naqä hŋqueŋqä ipqä-pa, Iqueŋi qoŋä äwoktäupu imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Qu Iqueŋi quvqä iiŋi qäpu itquapiyi, iŋgaŋi qäkä ipisqä iqu huätä ätäuquväpu, Iqueqä qäki aŋgumä äwiyätukuwi. Itaŋi Iqueŋi, zä-huätati huepŋqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ämaqä aŋä-himqä Sairinisaŋä, Aleksandä iqueqätä, Rupesi iqueqätä, iquaquiyqä kanä Saimonä iqu, aŋä-himqä yäpaqäŋgisa äpmamiŋqe, yäŋgisa paquvqaŋgaŋi, mäkä-iqä iqua, Jisasi Iqu zä-huätatä hunätŋqä ze, iqu metŋqä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Qu Jisasi Iqueŋi, aŋä yoqä Golketa qonätaŋgqeuŋqä ätuma äukuwi. Yoqä iiŋi, kiqä quati, ‘Ämaqä nyuäŋä-yäŋiqä.’ ");
INSERT INTO mcr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iqiŋi qu Jisasi Iqueŋi, wainqä-eqä duŋi marasinqätä qäsä imäkŋqe, täŋä-huŋqe Iqueqä huiwiuŋi wipti iqiyätŋqä wisäuqaŋga, Iqu mämotaŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Iŋgaŋi, mäkä-iqä iqua, Iqueŋi zä-huätati äuekuwi. Iqua, Iqueqä gquetä ämuasmäŋqetä iwäsäupu, kikiŋä mapŋqä häŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Qu Iqueŋi zä-huätatiŋi, mäptqä awänä mäpmeqä 9 klokŋga äuekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Quwqä suqä imäkmiŋuwä duŋi, kukŋuä ämitkuwä iqu, ätäpu tii äqiyekuwi. “Israitqä iquau Miqä Naqä Iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Itaŋga Iqu-täŋä qäqiqiŋi, ämaqä äpäsäsinyä quwä-meqä hŋquaquiŋi, zä-huätatä äuekuwi. Hŋqueŋi, hipa ämuaŋgisa äuepu, hŋqueŋi qunamäuqäŋgisa äuekuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Ämaqä iqi äpäwäpiyi, qu nyuäŋä ptqä äqiyäpu, Iqueŋi tä sisäwqä äväpu, tii ätukuwi. “Si, ‘Nyi hiqäva-imäkqä aŋi äpnetmä, hiunji hŋquaqui-hŋquenyä aŋgi mätqunjqä’ tqä-qukiyqä. Iŋi Tqä-täuä häŋä iqumuatnätnä, zä-huätatä äunäŋitaŋi, äyaqäsqäŋga biyä!” ätumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iŋi, hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, qu-pqä tä inä äsäpu, “Iqu ämaqä huiziuŋi häŋä iqumuatätŋqä-qe, Iqueqä-kiuäŋi häŋä miqumuatŋqä iqiyä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Kraisi ne ämineyätŋqä Goti Iqu, Ique atäuŋuä ikqä, Israitqeu Miqä Naqä Tqu, äyaqäŋga qua täqinyqä äpä. Ga ne hiŋuä äqunaqe, Iquenyqä quuvqä heqiyatuŋquänänyä” ätŋguwi. Iŋi, ämaqä zä-huätati anä äunmiŋiyä iquaqu-pqe, Iqueŋi kukŋuä quvqä inä ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Itaŋga hiunji quemisqä ae ätimäuqaŋga, qua eeqänäŋä iuŋi, hea äwäkqe. Awiyqä 3 klokŋgaŋi, we aŋgi äuŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Awiyqä 3 klokŋgaŋi, Jisasi Iqu maŋä yäŋänäqŋqä tii ätkqe. “Eloi, Eloi, lema sapatani.” Kukŋuä iqu, quati tiinji. “Ŋqä Goti Iqukiyä! Ŋqä Goti Iqukiyä! Si suŋqä nyivquatämäunyä?” ");
INSERT INTO mcr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ämaqä qäqiqi ätqäumiŋuwä hŋqua, kukŋuä tä qätä äwipiyi, “Qätä wipu! Iqu Laisa iquenyqä tääqä ätqiyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ga, ämaqä hŋqu tnäŋä äwäqe, yaaŋuä hui ämeqe, wainqä-eqä yäŋänäqŋqä iu äyämeqe, hätäkqeu ikätäutä, Jisasi Iqu änätŋqä äwisäukqe. Iiŋä itä, tii atukqe. “Laisa iqu äpätä, Iqueŋi zä-huätati äunäŋqe äyaqiyätä itumeŋqutiyä? Hiŋuä äqänanä äpmenä.” ");
INSERT INTO mcr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iŋgaŋi Jisasi Iqu maŋä yäŋänäqŋqä ätäqe, hindŋä-meqä äwquatämäuqe, äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iŋgaŋi yuä naqänäŋä, hiqäva-imäkqä aŋä yäpä iŋgisa imaknmiŋqä iqu, hituŋuä yätuta iŋgi-iŋgi äpkŋga äpäwiqe, hŋquaqu qe imäkŋgqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iŋi mäkä-iqä iquau miqä, Jisasi Ique hiqumuaŋä äwiyä ätqäumiŋqä iqu, Iqu äänä itä päkoŋgaŋgqe hiŋuä äqunäqe tii ätkqe. “Naqä-qakui. Ämaqä Tqu, Goti Iqueqä Ymeqä Iqueyqä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Itaŋga apäkä hiua, kiŋä näŋisa hiŋuä äqumbu ätqäumiŋuwi. Iuautaŋi, Mäliya, aŋä-himqä Maktälataŋä ii, itaŋga Mäliya, Jemisi hikŋä wäŋqä ique, ä Josepä gueqiyqä känäu, itaŋga Solomiyi. ");
INSERT INTO mcr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisasi Iqu qua Galili iu pmetaŋgaŋi, Ique qänaki äwivändäpu, yätamäkqä äwimiŋuwä iuae. Ga, apäkä kuapänäŋä, Jisasi Iqutä Jerusälemäŋqä anä äpkuwä iua-pqe, qäsä iqi ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Hiunji iqueŋi, ii Sämbatqä hapä pmeqä iqueŋqä, nätmatqä näwinyä imäkqäŋganji. Iutaŋi, mäptqä äwitŋqä ti pmetaŋgaŋi, Josepä Arämatiyataŋä iqu, Pailoti Iquenyqä zä-miqä, ique äwimeqe, “Jisasi Iqueä huiwi ämamqeqä” ätukqe. Ämaqä iiŋä iqu, Israitqä iquau miqä eeqänäŋä iquautaŋä, yoqä naqä inäŋä-täŋu eä, Goti Iqunä miqeuŋqä hiŋuä äqänä äpmamiŋqä iquvi. ");
INSERT INTO mcr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","“Jisasi Iqueä huiwi ämamqeqä” tquaŋga, Pailoti iqu yäuŋuä iqe, ämaqä mäkä-iqä iquau miqä ique tääqä ätuätumeqe, “Jisasi Iqu ae äpäkoŋgqätanä, ä änääŋgä?” ätuätä, yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ämaqä iquesa näqŋqä ae ämeqetaŋi, Pailoti iqu, Josepä iqueŋi, “Jisasi Iqueä huiwi, yqä mayä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iŋgaŋi, Josepä iqu yuä naqä hŋqu mbqä iäqe, Jisasi Iqueä huiwi zä-huätati äuekuwiuta äyaqiyätä, qua mäŋi ämaeqe, Iqueä huiwi huäqä äutäqe, ämaqä pizqä pŋqä heqäŋqä hikä ätäŋukuwä aŋä-näŋä imä pŋqä ekqe. Pŋqä ae eäqe, hikä qŋqaŋä naqä hŋqu, huaqä-huaqä ämiqa qŋqaŋä ämaptekqe. ");
INSERT INTO mcr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mäliya Maktälataŋä iisä, ŋŋ Mäliya Josepä iqueqä känaisä, Jisasi Ique pŋqä eqaŋgqe, hiŋuä äquŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hiunji Sämbatqe ae äpäwqaŋgaŋi, Mäliya Maktälataŋä iu, Mäliya, Jemisi iqueqä känäu, itaŋga Solomi, qu eqä jinaŋä-weqe mbqä ikuwi. Ii, qu äma äwäpu, Jisasi Iqueä huiwiu equatpŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hiunji kiŋganäŋä iqueuä zi-hiŋuä matqä, mäptqä ti eumäuqaŋgaŋi, apäkä iua, Jisasi Ique pŋqä ekqeuŋqä äwäpiyäŋgaŋi, tii ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“Ne Jisasi Iqu hikä hovqä äwiŋqä iqueqä hikä qŋqaŋä äptänäŋqe, huaqä-huaqä ämitä nauteyätŋqe, tqukä?” ");
INSERT INTO mcr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","E äwäpiyä iunda hiŋuä äqunäukuwi, hikä iiŋä iqu, kätanäŋä qäyä hitaŋgqä-qe, qŋqaŋä mäpmäwänätaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Itaŋga apäkä iua, Jisasi Ique pŋqä ekqä yämä äpaquväpiyäŋgaŋi, hikŋä gquä qäpaiqä hämänänäŋä imäkŋqä hŋqu, hipa ämuaŋgisa pmetaŋgi äqumbiyi, iŋgaŋi iua miiqä yäŋä ipu, äwäwa ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I iqaŋguwäŋga, iqu iuauŋi, “He yäuŋuä miqä pampiyä” ätukqe. “He Jisasi Nasäretqätaŋä, zä-huätati äuequwä Iquenyqä hiŋuäŋqä äpqäuä. Iqu ae ävauqäqe. Hiŋuä qumbiyä! Äwäteqä täqiŋi, aaŋqä suänä. ");
INSERT INTO mcr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Iiŋä-qae, he äwäpu, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau, (Pitä ique qäsä), tii tupiyä. ‘Iqu qua Galiliŋqä hiŋuiqä wäŋqiyä. Iqu ae etkqä-pa, he Ique iqi qumbŋqäuä’ tupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iŋgaŋi apäkä iua zä ipu, yäuŋuä-yäuŋuä wiŋgaŋga, ämaqä pŋqä wiqeuta yäpaqä mäŋgisa ätimäupiyi, iqisaŋi zä äväma äukuwi. Iua äwäpiyäŋgaŋi, zä yqänä iqäwäpu, ämaqeuŋi mätquä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisasi Iqu hiunji kiŋganäŋä iqueuä ziŋuä matqäŋga ävauqetaŋi, Mäliya Maktälataŋä ii-ganä äwimakqe. Iiŋi, dŋä quvqä 7 tqäutaŋgi, Iqu huätä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Itaŋi ii äwäqe, ämaqä, Iqutä anä ikämiŋuwä iqua, huäqä-huŋqä ämepu, kŋuä qiyätqätaŋguwä iu äwimetä, awä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ii, “Jisasi Iqu häŋä pmetaŋgi, äqunäŋänä” tquaŋgi äwiyäpiyä-qe, qu, “Ii quaŋgä ätqiyä” kŋuä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Itaŋi huizi, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋquaqu, aŋä-himqä iutaŋi äväma, qaŋä wätqätaŋginyäŋga, Jisasi Iqu, iquaquiŋi huitaŋä-qu imäknä äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iquaqu aŋgumä äwiyi, huizi iquauŋi, iquaqui wimeqaŋgqeŋqä ätukiyi. I tquaŋgiyä-qe, iqua, “Iquaqu quaŋgä ätqinyqä” kŋuä ämakuwi. ");
INSERT INTO mcr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Itaŋi Iqu, wäuŋuäŋqä ämotquamiŋqä 11 iqua, ymisaŋä änäpu pmetaŋguwäŋga äwimakqe. Iqu äwimeqe, ämaqä, Ique häŋä aŋgi pmetaŋgi hiŋuä äquŋguwiŋqä qäyä ätquaŋgä, ga “Qu quaŋgä änatqäuä” ätuäpu pmetaŋguwiŋqä, Iqu, “He nyuäŋä woyqä imbu, quuvqä maeqiyqe, suŋqä itqäŋäuä?” ätuätä, yäŋänäqŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Itaŋga Iqu iquauŋi, “He qua äwitqutäŋqä-pa kukŋuä äŋguä we-huŋqä-täŋi äma äwäpu, ämaqä eeqänäŋä iu awä tupŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","“Ämaqä quuvqä eqiyätä asŋä ämeqä iqueŋi, Goti Iqu häŋä iqumuatäniqe. Itaŋga ämaqä quuvqä maeqiyqä iqä iquenyqe, Goti Iqu, ‘Häŋä mäpmeqä yäŋqiyä’ täniqeqä. ");
INSERT INTO mcr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Ämaqä quuvqä eqiyquwä iqua, wäuŋuä ämaqä mimäkqänäŋä tiiŋi imäkäpnuwi. Nyaqä yoqeta, dŋä quvqä huätä ändowatpnuwi. Iqua kukŋuä änyä-häŋi ätpnuwi. Quwqä hipaitä qämakä a ämaqätpnuwi. Eqä quvqä ämbqe, qui mäwimäkqä yäniqe. Itaŋga ämaqä täŋä-yaqä witaŋgpqeuŋi, hipae haqeqi äwiyquwi, äŋguä imämbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Naqä Jisasi Iqu, iquauŋi kukŋuä qäpu tquaŋga, Iqueŋi qäukuä yätuŋqä ätuma ekqe. Itaŋga Iqu Goti Iqueä hipa ämuaŋgisa äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua im-imä äwäpu, kukŋuä awä ätuäkämiŋuwi. Kukŋuä naqä-qakuä hitaŋgqeŋqä motquapŋqe, Naqä Iqu yäŋänäqŋqä vqaŋgi, iqua ämaqä mimäkqänäŋi imäkäkämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jisasi Iqu nesä pmetaŋgi, Goti Hanjuwä Iqu imäkätä ekqeŋqe, Iqueqä kukŋuä awä-tqä iqua, nätmatqä eeqänäŋi hiŋuä äqunäpu qätä äwiyäpiyä iqua qaŋä ikipu, kukŋuä awä änatmiŋuwi. Itaŋga ämaqä kuapänäŋi, iqua qätä äwiyäpu, bukä yamwiqä äqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Nyi wäuŋuä ipäqäkqä duta, yatŋqä iqa äpqinjaqänmi, täŋgaŋi nyi nätmatqä eeqänäŋä ätimäuqaŋgqeŋqä kŋuä äŋguänäŋi ämeqänä. Tipilusi naqä iquki, qu nätmatqä eeqänäŋiŋqä ämäktquakuwä iiŋqe, si näqŋqä eätnä, “Ii naqä-qakuiqä” ttŋä diŋqe, täŋgaŋi nyi sinyqä bukä qäyunä äqiyätmä emqä di ktapmqänä. ");
INSERT INTO mcr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ämaqeu miqä naqä Heroti iqu Jutiya iu mitqätaŋgaŋi, hiqäva-imäkqä hŋqu äpmamiŋqe. Iqueqä yoqe Sakätiyasi ique. Ämaqä iqutä wäuŋuä anä iqe, iquauqä yoqe Äpaisa iquai. Sakätiyasi iqueqä apäkiyqä yoqe, Älisapetqi. Ii hiqäva-imäkqä iquauqä kaqä, Aronä iquesaŋä iiyi. ");
INSERT INTO mcr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iyaqu Goti Hanjuwä Iqueqä hiŋuä iqiŋi, Iqueqä kukŋuitä, suqetä, eeqänä qänaknä isinyä, jänänäŋä äpmamiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Älisapetqi qokitqä etaŋgi, iyaqu ymeqä maeqä enyä, qoyaŋä-äpäyaŋä äpmamiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hea hŋqueŋi, ämaqä Äpaisa iqua Goti Hanjuwä Iquenyqä hiqäva imäkätqätaŋguwäŋga, Sakätiyasi iqu, Goti Hanjuwä Iqueqä hiŋuä iqi wäuŋuä iqämanmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Iŋgaŋi iqua quwqä suqä iwäsäuqäŋqä imäkäpu, Sakätiyasi iqu Naqä Iqueqä aŋä hiqŋqä pmua iŋgisaŋqä äwätä, nätmatqä jinaŋä-weqä tä iketŋqä diŋqä, atäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iqu hiqŋqä pmua iuŋqä uwqaŋga, qokä-apäkä aquvä äqäŋguwi, qu yäpaqä mäŋgisa äpmapu, Goti Hanjuwä Iquenyqä tääqä ätqämanmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iŋgaŋi Iqu Goti Hanjuwä Iqueqä eŋätqä hŋqu, hiqŋqä yäpä iŋgisa jinaŋä-weqä ttawä iŋiu, hipa ämuaŋgisa tqäutaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Iqu ique hiŋuä e äqunäqe, änä mäwimäŋqä itä, zä kiiŋä ikqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iŋgaŋi eŋätqä iqu, “Sakätiyasi iquki, si zä miqä panä” ätukqe. “Goti Hanjuwä Iqu saqä tääqä ätŋi, qätä ae äkiyäŋqe. Tqä apäkä Älisapetqi, ymeqä qokä hŋqu nyuäŋqiyä. Iqueqä yoqe, ‘Jonäuä’ nyuätqätŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iŋgaŋi, saqä äwqe, aaŋä yeeqä kuapä kinyäniqeqä. Ämaqä kuapänäŋi, ymeqä iquenyqä aquvänä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aquvänä iqä qakui, tiinji. Iqu Goti Hanjuwä Iqueqä hiŋuä iqiŋi, ämaqä naqä-qu äpme, wainqätä, eqä ämaqä iquauqä kŋuä indqäŋqe qui wimäkqetä, maŋqä yäniqeqä. Ymeqä iqu känäwä äwqä imä yqänä mnätaŋgaŋi, Dŋä Äŋguä Iqu, iqutä anä pmetäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iqu iqueqä wäuŋuä imäkätqätaŋgi, Israitqä kuapänäŋi, iquauqä suqä hŋgisanäŋi huätä ävquatämäupu, Goti Hanjuwä Iqueqä kukŋui qätä äwiyäpu, qänaknä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iqu Laisa iqueuä suqetä, yäŋänäqŋqetä ämetä, Naqä Ique hiŋuiqä wimeniqeqä. Qunuŋuatä, ymeqä iquatä, äwqä naqä-hŋqunä imbŋqä imäkätä, ämaqä hŋgisanä itqäŋuwä iquauŋi, kŋuä äkunmäknäpu, iquauqä kŋuä indqäŋqe äŋguänäŋä metpŋqä imäkäniqeqä. Iqu ämaqä iquauŋi, Naqä Iqu äpätqäŋgaŋqä näwenyä e imäkäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakätiyasi iqu eŋätqä iqueŋi, “Saqä kukŋuiŋqe, naqä-qakuiqä kŋuä nyätŋqe, nyi näqŋqe äänä himqäwä? Nyitä ŋqä apäkisä, ye quväukuä kuapänä ae ämäyaqutäuqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eŋätqä iqu kimaŋi, “Nyi Gapleti iqunjqä. Nyi Goti Hanjuwä Iqueqä hipeŋuä iqi ätqäuŋänä. Iqu nyi kukŋuä äŋguä täŋqä awä ktmqä änändowatqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nyaqä kukŋuä tä hea qayunäŋäŋga, naqä-qakuänäŋä timäuniqeqä. Iŋäqe si nyaqä kukŋui qätä manyiyqä iŋä-qae, hea nätmatqä tä timäuqaŋgaŋqe, kukŋuä matqä isŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sakätiyasi iqutä, eŋätqä iqutä, iquaqu kukŋuä tqämanätqätaŋgiyäŋgaŋi, ämaqä yäpaqä mäŋgisa ätqäumiŋuwä iqua, Sakätiyasi iqu aŋä yäpä yäŋgisa äpakä pmetaŋgqeŋqä, iquenyqä hiŋuä äqumbu äpmapu, kŋuä kuapänä indqänmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iqu hŋgaŋqä imänjaqänäqe, hŋgaŋi yäpaqä mäŋgisa ätimäuqe, kukŋuä mätquä iqaŋga, qu iquenyqe, iqu aŋä pmua iŋgisa äpme, wätqä eŋqä-pa äqunätänjqe, näqŋqä ämakuwi. Iqu kukŋuä matqä itä, iqueqä hipa itänä wätqä eŋqä-paŋi imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Qänakndaŋi Sakätiyasi iqu, iqueqä wäuŋuä Goti Hanjuwä Iqueqä aŋä iuŋi qäpu iäqe, iqueqä aŋämqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iŋgaŋi iqueqä apäkä Älisapetqi, äwqä-täŋä eä, iiyqä aŋä yäpä yäŋgisa zä qaŋuä hipa hŋgi eeqä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Goti Hanjuwä Iqu huäqä äwunätä äŋguänä inyimäkqiyä. Nyi qokitqä äpmamä womba änyinmiŋqe, täŋgaŋi Goti Hanjuwä Iqu huätä ämanmäuqiyä” ätkqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Älisapetqi äwqä-täŋä qaŋuä 6 pmetaŋgaŋi, Goti Hanjuwä Iqu eŋätqä Gapleti iqueŋi, Galilisäŋä iŋgi aŋä-himqä Nasäretqäŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iqiŋi iqu apäkä hitqä, qokätä hiqaqä mäwiqä imiŋqä hui, iiyqä yoqe Mäliyau äwimakqe. Ii Josepä iquenyqä ätmiŋuwi. Josepä iqueqä kawiqu, ämaqä naqä Dewiti ique. ");
INSERT INTO mcr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eŋätqä iqu apäkä ii äwimeqe, “Si äŋguä äpmeŋinyä. Goti Naqä Iqu sinyqä kŋuä äŋguänäŋä indqänätä, sitä anä äpmenä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ii kukŋuä tä qätä äwiyäqe, änä-änä mäwimäŋqä itä, “Änääŋqä dqutiyä?” kŋuä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eŋätqä iqu, “Mäliya, si zä miqä panä!” ätukqe. “Goti Hanjuwä Iqu nätmatqä äŋguänäŋiŋqä, si atäuŋuä ae äkiyqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Si äwqä eätnä, Ymeqä Qokä Hŋque misiŋiqä. Iqueqä yoqe, ‘Jisasiuä’ nyuättŋäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iqu Naqä-qu etaŋguti, ämaqä iqua, ‘Goti Haqä Yätutaŋä Iqueqä Ymeqeqä’ tpnuwiqä. Goti Hanjuwä Iqu iwimäkqaŋguti, Iqu qokä-apäkä iuŋi, Kiqä kawiqu Dewiti iqu äpmetä ämimiŋqä-pa, e miniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iqu hueqä-himqä Jekopä iquesaŋä iquauqä Naqä-qu eä, hea ique-ique pmetäniqeqä. Iqueqä ämiqä iiŋi, qäpunä maeqä da, e witäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","I tquaŋga Mäliya eŋätqä iqueŋi, “Tä äänä timäutŋqä tnyä? Nyi qoki maeqinjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eŋätqä iqu kimaŋi, “Goti Haqä Yätutaŋä Iqueqä Dŋä Äŋguä Iqu si äkimetä, Iqueqä yäŋänäqŋqe äkpatqiyäŋqiyä. Ymeqä si änyuesqä Iqu, Goti Iqueqänä hiätaŋguti, qu Iquenyqe, ‘Goti Hanjuwä Iqueqä Ymeqeqä’ tpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Qätä nyiyä! Apäkä äpäyaŋä tqä sämaqi Älisapetqi-pqe, ymeqä hŋqu inä nyuäŋqiyä. Iinyqe, ämaqe, ‘Apäkä täsi qokitqeqä’ ätumiŋuwä-qe, qaŋuä 6 päwqaŋga, ii äwqä-täŋä äpmenä. ");
INSERT INTO mcr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Goti Hanjuwä Iqu nätmatqä ämaqä mimäkqänäŋä di imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iqu e tquaŋga Mäliya ämävauqe, “Nyi Naqä Iqueqä wäuŋuä-wiyqinjqä. Si tä ändŋä-maŋi, ätimäuŋqiyä” ätukqe. Ii iiŋä tquaŋga, eŋätqä iqu ävämakqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iŋgaŋi Mäliya, qoqoŋä Jutiya-täŋä iŋgiŋqä aŋä-himqä hŋquenyqä maqänä ekqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aŋä-himqä iu ätimäuqe, Sakätiyasi iqueqä aŋä yäpä yäŋgisa äpäyätä, Älisapetqiŋi, “Hiunjiŋganjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iŋgaŋi Älisapetqi, iuä maŋi qätä wiyqaŋgaŋi, ymeqä iqu äwqendaŋi ämeŋä iqaŋga, Dŋä Äŋguä Iqu Älisapetqiyqä äwqeuŋi kuapänä ämŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iŋgaŋi ii Mäliyau tääqä yäŋänäqŋqä tii ätukqe. “Apäkä eeqänäŋä iua äpmetaŋguwä-qe, Goti Hanjuwä Iqu si äŋguä ikimäkqiyä. Ymeqä si misŋqä Iqueŋi, Goti Hanjuwä Iqu Ique-pqe äŋguä iwimäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nyi änääŋäwä? Nyi apäkä naqinyä maeqä etaŋgqä-qe, ŋqä Naqä Iqueqä känaiki änyimenyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Qätä nyiyä. Si nyi tääqä ändŋäŋgaŋi, nyi qätä kiyqaŋga, ymeqä äwqä tämŋi aquvänä itä, ämeŋä iqäqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Si Goti Hanjuwä Iqu äktqeŋqä, ‘Naqä-qakuä, ätimäuŋqiyä’ kŋuä indqäŋgŋi, äwqä yeeqä iŋqikiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ii i tquaŋga, Mäliya tii ätukqe. “Nyaqä äwqe, Goti Hanjuwä Iqueqä yoqe haqeqä ämamäuqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nyaqä quuvqe, Goti Häŋä Inyimäkqä Iquenyqä yeeqä änyiŋgiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Nyi Iqueqä wäuŋuä-wiyqä apäkä hiŋgiŋqä-qenyä, Iqu nyinyqä kŋuä äŋguänäŋä indqäŋgi. Goti Yäŋänäqŋqä Iqu äŋguänäŋä nyimäkqeŋqe, ämaqä täŋga äpmeŋuwä iquatä, qänaknda pmapnuwä iquatä, ‘Apäkä täsiŋi, Goti Hanjuwä Iqu äŋguänäŋi iwimäkkqeqä’ tpnuwiqä. Goti Hanjuwä Iqueqä yoqe, aaŋä pmua äqonänä. ");
INSERT INTO mcr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ämaqä täŋga äpmeŋuwä iquautä, qänaknda pmapnuwä iquautä, Ique qätä wiyqä iquauŋqe, Iqu qeqä wimäŋgaŋgi äŋguä imäkqä-queqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iqu, hipa wäuŋuä yäŋänäqŋqä iqä-queqä. Ämaqä ‘Ŋqä-näuä äŋguä eäŋänä, nyi imäkmqänä’ kŋuä indqäŋqä iquauŋi, Iqu hiŋginäwa dowatqä-queqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ämaqä naqä iquauqä yäŋänäqŋqe huätä mamäuqä-queqä. Ämaqä yäpä iqiŋä iquauä yoqe, haqeqä vauqumuatqä-queqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ämaqä nätmatqäŋqä äwa iqaŋguwä iquauŋi, kuapänä vqä-queqä. Ämaqä nätmatqä kuapänä-täŋä iquauŋi, huätä qanyä dowatqä-queqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Iqu neqä atqä-awäkau kukŋuä guä ämäsäutä, ‘Aprähamä iqueŋqätä, iqueqä kaqä-kawäkauŋqätä, qeqä hea ique-ique nyimäŋguäniqeqä’ ätukqeqä. Iqu kukŋuä iiŋqe kŋuä indqänätä, Iqueqä wäuŋuä-wiyqä Israitqä iquau yätamäkqä vqä-queqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mäliya e ätuäqe, Älisapetqisä qaŋuä hŋquaqui-hŋque äpmeqe, kiqä aŋämqä aŋgi äpäwäkqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Älisapetqi iŋgaŋi ymeqä qokä hŋque ämikqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ämaqä iisä qäqiqi äpmamiŋuwä iquatä, iiyqä käyämaqä iquatä, qätä äwipiyi, Goti Hanjuwä Iqu qeqä äwutätä, yätamäkqä vqaŋgqeŋqä, iqua iisä aquvänä anä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Hea 8 päwqaŋga, qu ymeqä hayuqä-täŋä iqueqä huiwi häuä ktäupŋqä aquvä äqämbiyi, iqueqä kaniqueä yoqä, “Sakätiyasiuä” nyuätanä-tpu iqaŋguwäŋga, känai, “Oeyä, ne iqueqä yoqe, ‘Jonäuä’ nyuätatuŋqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iŋi, “Änääŋäŋqäwä? Ämaqä sitaŋä hui, yoqä iiŋi maqoŋqä iŋäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Iqua e ätupiyi, Sakätiyasi iqu iqueqä kŋui ämotquetŋqä diŋqä, ique atäuŋuä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Itaŋga iqu, iqua zä-heauqä muaepŋqä hipaitänä atäuŋuä äwikqe. Iqu zä-heauqä iuŋi, “Iqueqä yoqe, Jonäuä” äqäkqe. Iqu e qäyqaŋgqeŋqä iqua yäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iŋgaŋi, Sakätiyasi iqu kukŋuä matqä äpmamiŋqe, Goti Hanjuwä Iqu äŋguä iwimäkqaŋgi, iqu kukŋuä ätätä, Goti Hanjuwä Iqueqä yoqe haqeqä ämamäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nätmatqä huitaŋä e timäuqaŋgqeŋqä, ämaqä iqi äpmamiŋuwä iqua zä ikuwi. Iŋgaŋi ämaqä Jutiya iu qoqoŋä im-imä pmeqä iqua, kukŋuä kuapä ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ämaqä kukŋuä qätä e äwikuwä iqua, “Goti Hanjuwä Iqu ymeqä däŋä iqutäŋi, anä pmeŋqiyä” kŋuä e indqämbiyi, “Ymeqä iqu, änääqu heniqätiyä?” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dŋä Äŋguä Iqu, kaniqu Sakätiyasi iqutä kuapänä muŋgaŋgi, iqu hiŋuä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israitqä iquneqä Goti Hanjuwä Naqä Iqu, Iqueqä ämaqä iqune, haŋä-iqä-täŋä pmetaŋgu änemetä, yätamäkqä äneyätä aŋgi inätmeqeŋqe, ne Iqueqä yoqe haqeqä ämamäuanä. ");
INSERT INTO mcr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iqu imäkqaŋgi, Ämaqä Yäŋänäqŋqä Hŋqu häŋä inemäkätŋqä eqi. Iqueqä wäuŋuä-wiyqä Dewiti iqueqä hueqä-himqä iuqä awä iqisa eqi. ");
INSERT INTO mcr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iqu hiŋuiqänä hiŋuä-tqä iquauä maŋiuta ätkqä-pa, iiŋä ätimäuqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Neyaqä mäkä-huŋqä iquauqätä, himä-wiuŋqä iquauqätä, hipa iuta aŋgi inetmetŋqä e imäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Iqu atqä-awäkaŋqä qeqä äwutätä, awiqu Aprähamä iqutä kukŋuä guä äumäsäuekqeŋqä kŋuä indqänätä e imäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Neqä ämaqä mäkä-huŋqä iquauqä hipa iuta aŋgi inetmeqaŋga, ne zä mäneŋqä iqaŋguti Iqueuä wäuŋui wiyquatuŋqueqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iiŋä etaŋgi ne hea ique-iqueŋi, Iqueqä hiŋuä iqiŋi, suqä äŋguänäŋinä itanä, Iqueuä wäuŋui imäkquatuŋqueqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ga ŋqä ymeqä iquki, sinyqä tii tpnuwiqä. ‘Iqu Goti Haqä Yätutaŋä Iqueqä hiŋuä-tqä iqueqä.’ Quati tiinjqä. Si Naqä Iquenyqä hiŋuiqä äwätnä, hänaqä näwenyä imäktŋäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Si iiŋä imäktŋäŋqe, ii Goti Hanjuwä Iqueqä ämaqä iquauŋi, Iqu iquauqä suqä quvqe huätä ämamäutä, häŋä iwimäkäniqeŋqä näqŋqä wisŋäŋqä diŋqeyi. ");
INSERT INTO mcr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ämaqä iquauŋqä qeqä wimäŋgaŋgi, e imäkqe, qäukuä yätutaŋi we-huŋqä hŋque mäptqä ätätŋqä-paŋi, nenyqä iiŋä dowatäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ne aŋä hiawiqä imä pmetaŋgua, Iqu neqä huiwä zä iiŋqe ktqä namäuqaŋga, mäptqä ätätŋqä-paŋä iiŋi we-huŋqe ne naunätä hänaqä ämänätqueqaŋguti, ne äwqä haŋuä änyätanä qeiqinyä pmetaniqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ymeqä iqu naqä eätä, iqueqä quuvqe yäŋänäqŋqä ämeqe, qänakŋi, Israitqä iquauqä hiŋuä iqi tqäuniqäŋgaŋqe, iqu aŋä avqŋqä imä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Iŋgaŋi ämaqä naqä Romätaŋä iqu, ämaqä iqueqä ämimiŋqä eeqänäŋä iuqä yoqä ämepu a täupŋqä, kukŋuä yäŋänäqŋqä änyä-häŋä hui imäkkqe. Iqueqä yoqe, Sisa Okastusi ique. ");
INSERT INTO mcr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Iqu e tqaŋga, ämaqä eeqänäŋi, qu quwqä yoqä inä mapŋqänä, quwqä aŋä yäuä duŋqä aŋgumä äukuwi. Iŋgaŋi qu ämaqä iuqä yoqe änyä qe ämakuwi. Siliya iŋgisaŋi, Kuiliniyäsi iqu kiyapqä wäuŋuä itä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josepä iqu hueqä-himqä Dewiti iquesaŋä eä etaŋgi, iqu Nasäretqä iu ävämaŋi, Betlähemäŋqä ekqe. Ämiqä naqä Dewiti iqu hiŋuiqänäŋi, Betlähemä iu äpmamiŋqe. Nasäretqäŋi, qua Galilisäŋä iŋgisayi. Betlähemäŋi, qua Jutiya-täŋä iŋgisayi. ");
INSERT INTO mcr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mäliyaŋi, iquenyqä ätmiŋuwi, ii äwqä-täŋi etaŋgi, qu iyaquvqä yoqä mapŋqä, Josepä iqu iisä anä äukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iyaqu Betlähemä iu äpmayi, Mäliya ymeqä nyuätŋqä hiŋuä äwqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ga ii Ymeqä Qokä Hitmqä Ique änyuäqe, ämaqä iquauqä aŋä hiqaqä wiqe hma etaŋgi, yuä huäqä ätuätä, bulumäka iquauqä buayäŋqä hevqä iu äwätekqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Heatqä iqueŋi, Betlähemä-täŋä qäqiqiŋi, sipsipqä-miqä hŋqua iquauqä sipsipqä ämipu, qamqä iqi äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iŋgaŋi Naqä Iqueqä eŋätqä hŋqu, iquauqä hiŋuä iqi maqänä tqäuqaŋga, Goti Hanjuwä Iqueqä we-huŋqe, iquau we äwuŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Iqua iiŋä äqumbiyi, zä kiiŋä iqaŋguwäŋga, eŋätqä iqu, “He zä miqä pambiyä!” ätukqe. “Nyi henyqä kukŋuä äŋguänäŋi, ämaqä eeqänäŋi yeeqä naqä-qakuänäŋä ipŋqä äma äpqänä. ");
INSERT INTO mcr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Täŋgaŋi Dewiti iqueqä aŋä-himqä täutaŋi, Ymeqä Hŋqu eqiyä. Ymeqä Iqu, ämaqä eeqänäŋä hiqä haŋä-iqetaŋi, häŋä equmuatäniŋqä Iqueqä. Iqu Naqä-qu eä, Kraisi, he ämeyätŋqä Goti Hanjuwä Iqu ätekqä Iquvqä. ");
INSERT INTO mcr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","He Iqueŋi, hiŋuä tiiŋä äqumbiyitaŋi, näqŋqä mapŋqäuä. Iqu yuä huäqä äutnä, bulumäka iquauqä buayäŋqä hevqä iu witaŋguti qumbŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eŋätqä iqu e tquaŋga, eŋätqä kuapänäŋä iqua, qäukuä yätuta maqänä äquveppiyi, iqutä anä äpmamiŋuwi. Iqua Goti Hanjuwä Iqueqä yoqä haqeqä ämamäupu, tiiŋä ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Qäukuä haqä yätuŋi, Goti Hanjuwä Iqu yoqä naqä-täŋiyi. Iŋi qua buŋi, ämaqä, Goti Hanjuwä Iqu äŋguä wimäkätŋqä äwinyätŋqä iquauŋi, äwqä haŋuä di ävqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Iŋgaŋi eŋätqä iqua äväma, qäukuä haqä yätuŋqä aŋgumä äyqaŋguwäŋga, sipsipqä-miqä iqua kukŋuä tii ätŋguwi. “Naqä Iqu nätmatqä ae ämänätqueqä-qae, ga e ätimäuqä-qinyqä hiŋuä qunatuŋquä Betlähemä duŋqä jänänä äwanä.” ");
INSERT INTO mcr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","E ätmbiyi, maqänä äupiyi, iqua Mäliyautä, Josepä iquesä, Ymeqä Hayuqä-täŋä bulumäka buayäŋqä hevqä iu witaŋgi ämäqumuakuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iqua e äqumbiyi, nätmatqä eeqänäŋi, eŋätqä iqu Ymeqä Iquenyqä ätukqeŋqä awä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iqua awä e tquaŋgä qätä äwikuwä iqua, kŋuä kuapänä indqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mäliya nätmatqä eeqänäŋiŋqä kŋuä huätä mävquatämäuqä da, kŋuä yqänä indqänä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Iŋgaŋi sipsipqä-miqä iqua aŋgi äwäpiyäŋgaŋi, nätmatqä qätä äwiyäpu hiŋuä äquŋguwiŋqe, Goti Hanjuwä Ique yeeqä äväpu, Iqueqä yoqä haqeqä ämamäukuwi. Nätmatqä eeqänäŋä eŋätqä iqu ätukqä-pa, qäyunä qe ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ii Ymeqä ämikqä hiunji 8 ae äpäwqaŋga, Iqueqä huiwi häuä äktäupu, yoqä änyuätkuwi. Känai äwqä änyä etaŋga eŋätqä iqu ätukqä-pa “Jisasiuä” änyuätkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Iyaqu Mosisi iqu ätkqeuŋi qänaknä isinyä, hea 40 qanyä ae äpmayi, akiyä änyäsinyä Ymeqä Iqueŋi Naqä Ique wiyŋqä, Jerusälemäŋqä ätuma ekiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ii tiiŋiŋqe. Goti Hanjuwä Iqueqä kukŋuä-suqä iuŋi, ymeqä vqeŋqe, tiiŋä äqänätaŋgiyi. “Hiveqä-yaqueqä, ämaqä, ymeqä qokä hitmqä eeqänäŋä iquauŋi, Naqä Ique wipŋqä.” ");
INSERT INTO mcr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iyaqu yäŋiŋi, akiyä nyämänäsinyä, Goti Hanjuwä Iqueqä suqe qänaknä isinyä, hiqäva imäkiyŋqä ekiyi. Bukä iuŋi, tiiŋä qänätaŋgi, “Yŋŋä-heeqä hŋquaqu mapŋqti, ä yŋŋä-quaunyqä meqä hŋquaqu mapŋqti.” ");
INSERT INTO mcr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iŋgaŋi ämaqä hŋqu Jerusälemä iu äpmamiŋqe. Iqueqä yoqe, Simiyonä ique. Iqu suqä äŋguänäŋinä imäkätä, Goti Hanjuwä Iquenyqä qänaknä imiŋqe. Iqu Israitqä iquauqä yätamäkqä väniqä iqueŋqä hiŋuä äqänä pmetaŋgi, Dŋä Äŋguä Iqu, iqutä anä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Qäŋganäŋi Dŋä Äŋguä Iqu, “Si Kraisi Ämaqä he ämeyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Ique hiŋuä ganä äqunŋi, iŋga päkondŋäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Hiunji iqueŋi, Dŋä Äŋguä Iqu kŋuä vqaŋga, iqu hiqäva-imäkqä aŋä duŋqä äukqe. Iŋgaŋi Jisasi Iqueqä kaniqutä, känaisä, kukŋuä-suqä iu qänaki isinyä imäkiyŋqä, Ique äma pqaŋgiyäŋga, Simiyonä iqu atukuä ämaitä, Goti Hanjuwä Iquenyqä “äŋguiqä” ätätä, tiiŋä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Naqä Iquki, nyi Tqä wäuŋuä-kiyqunjqä. Si ändkŋä-ma, nyi äwqä haŋuä iiŋqetä umqä, hiŋuinä ŋqänäwqatiyä. ");
INSERT INTO mcr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nätmatqä Si imäkŋi, ämaqä iqune häŋä inemäkqä di etaŋgi, nyi hiŋuä ae äqunäŋänä. ");
INSERT INTO mcr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Si nätmatqä iiŋi, ämaqä huitaŋä-huitaŋä eeqänäŋä iquauqä hiŋuä iqisaŋi näwinyä ae imäkŋiqä. ");
INSERT INTO mcr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iqu Israitqä, Tqä sämaqä iquau, yoqä naqä ävätä, ämaqä huiziquau we-huŋqä vätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyonä iqu Ymeqä Iquenyqä e tquaŋgqeŋqä, kandä-känatä, kŋuä kuapänä indqäŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Iŋgaŋi iqu, Goti Iqu imbquau äŋguä iwimäkätŋqä tääqä ätäqetaŋi, känäu Mäliyauŋi tii ätukqe. “Ymeqä Tqueŋi, Goti Hanjuwä Iqu ae ätekqeqä. Iŋi Iquesaŋi, Israitqä hŋqua qui imäkŋgaŋguwäŋga, itaŋga huiziqua äŋguänä pmapnuwiqä. Iqu, nätmatqä Goti Iqu imäkäniqeŋqä hiqŋqä eŋqä-paŋä eqaŋgqeŋqä, ämaqä kuapänä kukŋuä quvqä tupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Itaŋga si ipäqäyuŋi tqä qeqä iu kiunjätäuqaŋgi, täŋä-huŋqä i matqä-paŋä iiŋä matŋiqä. Iiŋiŋqe, ämaqä kuapänäŋä iquauqä kŋuä zä indqänmipqe, ätnäŋäqi timäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Apäkä hui Goti Hanjuwä Iqueqä hiŋuä-tqä äpmamiŋqe. Iiyqä yoqe, Ana. Ii Panuelä iqueqä meqiyi. Panuelä iqu, Aseli iquesaŋäquvi. Ii äpäyaŋä ae ekqe. Ii hiŋuiqänäŋi quväukuä 7 kiqä qokä iqutä äpmamiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Qänakndaŋi kiqä qokiqu äpäkoŋgaŋga, apäqŋqä quväukuä kuapänä äpmamiŋqe. Iiyqä quväukuä eeqänäŋi, 84 äpäukqe. Ii hiqäva-imäkqä aŋä iuŋi mävquatämäuqä itä, buayä maŋqä äpme, Goti Hanjuwä Iquenyqä tääqä ätqämanätä, Iqueqä wäuŋui heatqäŋgatä hinjuiŋgatä itä, äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hiunji iqueŋi, Simiyonä iqu qäpu tqaŋga, Anai imbquau äwimeqe, Goti Hanjuwä Iquenyqä “äŋguiqä” ätkqe. Iiŋä ätätä, ämaqä Goti Hanjuwä Iqu Jerusälemä iuŋi aŋgi itmetŋqä diŋqä hiŋuä äqämbu pmetaŋguwä iquauŋi, ii Ymeqä Iquenyqä awi, iqisa ätipäqäkqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iŋgaŋi iyaqu Naqä Iqueqä bukä iu äqänäŋqä-pa eeqänä ae imäkiyi, iyaquvqä aŋä-himqä Nasäretqäŋqä, qua Galilisäŋä iŋginyqä äwäkiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ymeqä Iqu naqä eätä, näqŋqä kuapänä ämetä, yäŋänäqŋqä ekqe. Iŋgaŋi Goti Hanjuwä Iqu, Iquenyqä aquvänä itä, äŋguä iwimäkmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Quväukuä ique-iqueŋi, hiunji naqänäŋä Pasopaŋgaŋi, Jisasi Iqueqä känatä-kandä hiunji hiŋuä qunyiyŋqä, Jerusälemäŋqä iqäsmiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisasi Iqueqä quväukui hipa eeqäpnä eäqe hŋquaqu päwqaŋga, suqä iuŋi qänaknä ipu, Jerusälemäŋqä ekuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Qu hiunji yäpakä ique qäpu ae äqämbiyi, quwqä aŋämqä wiqäŋgaŋi, Hikŋä Jisasi Iqu Jerusälemä yätu yqänä äpmamiŋqe. Iiŋqe kaniqutä känaisä, “Iqu Jerusälemä yätu yqänä äpmenä-qe” kŋuä mindqäŋqä ikiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iyaqu, “Iqu ämaqä huizitä anä äpätqäŋäuä” kŋuä vqaŋgi, qu hiunji hŋque qaŋä äwämiŋuwi. E äwipiyäŋgaŋi, iyaqu Ique moqumuayŋqä, quvämaqä awä iu qävqä iyŋqä ipäqäkiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ique mämoqumueqä iyi, qävqä iyŋqänä Jerusälemäŋqä aŋgi ekiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hiunji hŋquaqui-hŋqueŋä iuŋi, iyaqu hiqäva-imäkqä aŋä iuŋi, Iqu näqŋqä-vqä iquauä awä iqi pmetaŋgi ämoqumuakiyi. Iqiŋi Iqu iquauqä kukŋui qätä äwiyätä, iquau yatŋqä inä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iŋgaŋi ämaqä iqueqä kukŋui qätä äwipu äpmapiyä iqua, Iqueqä näqŋqeŋqätä, Iqueqä kima tquaŋgqeŋqätä, qu eeqänä yäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iyaqu hiŋuä äqunyiyi, tä äktäuwänäsinyä, känai tii ätukqe. “Ŋqä Ymeqä Iquki, suqä iiŋi suŋqä yetquenyä? Tniqutä tnandäŋi, äwqä haŋä yeyqaŋgi, ye Sinyqä qävqä itqäŋueä.” ");
INSERT INTO mcr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","I tquaŋga, Iqu kimaŋi, “Qe Nyinyqä suŋqä qävqä itqäŋinyqä? Änääŋgä? Nyi Ŋqä Apiqueä aŋä täu pmetmqä diŋqe, qe maqŋqä eäŋinyqä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kukŋuä kima iiŋqe, iyaqu kiqä quatiŋqe, maqŋqä emiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iŋgaŋi Iqu iyaqutä Nasäretqäŋqä anä qe äwäkuwi. Ga Iqu iyaquiuä kukŋui, qänaknä äwimiŋqe. E äpmapiyäŋgaŋi, känai kukŋuä eeqänäŋi ämetä, iiyqä kŋuä indqäŋqä imä yäŋänäqŋqä ämaemiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisasi Iqu naqä eätä, Iqueqä näqŋqe äŋguänäŋä-täŋu ekqe. Goti Hanjuwä Iqu Iquenyqä kuapänä winyätaŋgi, ämaqä iqua-pqe inä äwinymiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taipiriyasi iqu, Romä pmeqä iquauqä naqä quväukui 15 pmetaŋgaŋi, Pondisi Pailoti iqu, qua Jutiya du kiyapqä pmetaŋga, Heroti iqu, qua Galili du ämimiŋqe. Itaŋga iqueqä käŋguequ Pilipä iqu, qua Ituriyä dutä, qua Tätakonitisi dutä ämimiŋqe. Itaŋga Lisaniyasi iqu, qua Apilene du ämimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Iŋgaŋi Anasi iqutä, Käyäpasi iqutä, iquaqu hiqäva-imäkqä naqä äpmamiŋiyi. Iŋgaŋi Sakätiyasi iqueqä ymeqä Jonä iqu, aŋä avqŋqä imä pmetaŋga, Goti Hanjuwä Iqueqä kukŋui iquenyqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I etaŋgaŋi, iqu aŋä eeqänäŋä eqä Jotänä-täŋä iu ikitä, awä tii ätumiŋqe. “Goti Hanjuwä Iqu hiqä suqä quvqe huätä maemäutŋqä diŋqe, hiqä kŋui äkunmäknäpu, suqä quvqe ävquatämäupu, asŋä mapiyä” ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iqu iiŋä imäkmiŋqetaŋi, hiŋuä-tqä Asayä iqueqä bukä iu äqänäŋqä-pa ätimäukqe. “Aŋä avqŋqä duŋi, ämaqä hŋqueqä maŋi tääqä tii ätqiyä. ‘Naqä Iquenyqä hänaqe näwinyä jänänä tiiŋä imäkepiyä. ");
INSERT INTO mcr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hänaqä ätŋnäŋqe, qua äptätnyäpu, itaŋga qoqoŋä ätqäuŋqe, yaquetä ipu, itaŋga ätuqä änyäŋqe, hii iwqatäpu, itaŋga äquvätä ätimäutä iqä änyäŋqe, äŋguä nyätŋqä imäkepiyä. ");
INSERT INTO mcr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iŋi ämaqä eeqänäŋi, qu Goti Hanjuwä Iqueqä suqä, ämaqä qui imäknätqäŋuwä iquau häŋä iqumuatqe, hiŋuä qumbnuwiqä’ ätqiyä” ätätä äqänä. ");
INSERT INTO mcr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iŋgaŋi qokä-apäkä kuapänä, Jonä iqu asŋä wuqiyätŋqä wimeqaŋguwaŋga, iqu tii ätukqe. “He qämakä quvqä iquauqä ymeqä-quenjqä. ‘Goti Hanjuwä Iqueqä äwqä tnäŋä äpäŋqiyä, he zä upiyä-qe’ tqu hitqaŋgikä? ");
INSERT INTO mcr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hiqä kŋui äkunmäknäpu, suqä quvqe ae ävquatämäuqueqä äktmbu motquapiyä. Iiŋä imäkquwi, he zä hŋqu häukuä-täŋä eŋqä-paŋuenjqä. Ga ‘Aprähamä iqu neqä awiqu hitaŋgqetaŋi, ne äŋguä äpmeŋunä-qe,’ matŋqä pambiyä. Nyi he etqänä. Goti Hanjuwä Iqu hikä tä, Aprähamä iqueqä kaqä-kawäka epŋqe, äŋguä imäkänä. ");
INSERT INTO mcr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Zä-häukuä äŋguä mäwiqaŋgutqä iquauŋi tä täuvepŋqä diŋqe, japiŋi zä-quatä iqi ae äwinä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jonä iqu e tquaŋga, qu yatŋqä äväpu, “Iiŋqe ne äänä imäkatuŋquäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I tquaŋguwäŋga iqu kimaŋi, “Ämaqä hŋqu gquä hŋquaqu-täŋu sätäti, ämaqä gquä maeqä ique väŋqiyä. Itaŋga ämaqä hŋqu buayä-täŋu eäqe, iqu-pqe asä e yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Itaŋga ämaqä mbqä motauqä hŋqua, asŋä mapŋqä äwimepu, tii ätukuwi. “Ämaqä ämänätqueqä iquki, ne äänä imäkatuŋquäwä?” ");
INSERT INTO mcr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kimaŋi iqu iquauŋi, “Heqä ämeyätqäŋuwä iqua etquwä-pa, iunä motaupŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Itaŋga ämaqä mäkä-iqä iqua-pqe yatŋqä äväpu, “Ne äänä imäkatuŋquäwä?” ätukuwi. I tquaŋguwäŋga iqu, “He ämaqeuŋi, ‘Mbqä nätappiyä’ ätuäpu, suqä quvqä mitqueqä pambiyä. Quŋi kukŋuä quaŋgä mämitqä pambiyä. Itaŋga ‘Mbqe, wäuŋuä iququeŋqe, tä qäyunjqä’ kŋuä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iŋgaŋi qokä-apäki, Kraisi ämaqeu mitŋqä Goti Hanjuwä Iqu ätekqä Iquenyqe hiŋuä äqämbu äpmamiŋuwä iqua, Jonä iquenyqe, “Tqu Kraisi Qäqutiyä?” kŋuä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Qu kŋuä e indqänätaŋguwiŋqe, Jonä iqu iquau tii ätukqe. “Nyi asŋi, eqä ditänä eqiyätqäŋä. Iiŋä etaŋgi, Ämaqä nyi ämaŋqutäuŋqä Iqu, qänaki änä äpäŋqiyä. Iqueqä yukä ämuasmäŋqä gue ewamqe, nyi ämaqä äŋguqunä manä, quvqunjqä. Iqu asŋi, Goti Hanjuwä Iqueqä Dŋä Äŋguitä, tä itä hiqiyäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iqu spetqä a äqätänä, kuä pa huätä ämatnämäutä, kuä naqe, aquvä äqiyätä Kiqä aŋiu pŋqä maeniŋqeqä. Itaŋga kuä pai, tä maisquä du tnämäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Iŋgaŋi Jonä iqu, ämaqä kŋuä äŋguä mapŋqä iuŋqä, kukŋuä hui inä ätuätä, Goti Hanjuwä Iqueqä kukŋuä äŋgui awä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Galilisaŋä ämaqä naqä Heroti iqu, iqueqä käŋguequeqä apäkä Herotiyasi ämetä, suqä quvqä huizi, kuapänä imäkqaŋgqeta, Jonä iqu äkasuwä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iutaŋi Heroti iqu suqä quvqä hŋqu aŋgu inä imäkätä, Jonä ique guä äkiqiyäuekqe. ");
INSERT INTO mcr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ämaqä eeqänäŋi, qu asŋä metqätaŋguwäŋgaŋi, Jisasi Iqu-pqe asŋä ämakqe. Iqu asŋä ae ämeqe, Goti Hanjuwä Iquenyqä tääqä tqämanätqätaŋga, qäukui qŋqaŋä äutänäqe, Dŋä Äŋguä Iqu, yŋŋä-heeqä eŋqä-pa, Iquenyqä äquvepkqe. Äquvepqaŋga, qäukuä yätutaŋi, maŋä tiiŋä ätukqe. “Si Ŋqä Ymeqä Nyi kiiŋä änyinätŋqä Iqukiyqä. Ŋqä äwqe, Sinyqä yeeqä änyiŋgiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Jisasi Iqu, Iqueqä quväukui 30 päwqaŋga, Iqueqä wäuŋuä ipäqäkqe. Iŋgaŋi qokä-apäki Iquenyqe, ‘Josepä iqueqä Ymeqeqä’ kŋuä indqäŋguwi. Kiŋganäŋi, Goti Hanjuwä Iqu Atamä ique imäkkqe. Atamä iqu Seti ique eämakqe. Seti iqu Inosi ique eämakqe. Inosi iqu Kenanä ique eämakqe. Kenanä iqu Mähaleli ique eämakqe. Mähaleli iqu Jareti ique eämakqe. Jareti iqu Inokä ique eämakqe. Inokä iqu Metusela ique eämakqe. Metusela iqu Lamekä ique eämakqe. Lamekä iqu Noa ique eämakqe. Noa iqu Semä ique eämakqe. Semä iqu Apäksati ique eämakqe. Apäksati iqu Kainanä ique eämakqe. Kainanä iqu Sela ique eämakqe. Sela iqu Epe ique eämakqe. Epe iqu Pelekä ique eämakqe. Pelekä iqu Reu ique eämakqe. Reu iqu Serukä ique eämakqe. Serukä iqu Neho ique eämakqe. Neho iqu Tera ique eämakqe. Tera iqu Aprähamä ique eämakqe. Aprähamä iqu Aisakä ique eämakqe. Aisakä iqu Jekopä ique eämakqe. Jekopä iqu Jutä ique eämakqe. Jutä iqu Peresi ique eämakqe. Peresi iqu Heslonä ique eämakqe. Heslonä iqu Ani ique eämakqe. Ani iqu Atäminä ique eämakqe. Atäminä iqu Aminätapä ique eämakqe. Aminätapä iqu Nesonä ique eämakqe. Nesonä iqu Salämonä ique eämakqe. Salämonä iqu Boasi ique eämakqe. Boasi iqu Opeti ique eämakqe. Opeti iqu Jesi ique eämakqe. Jesi iqu Dewiti ique eämakqe. Dewiti iqu Netenä ique eämakqe. Netenä iqu Mätati ique eämakqe. Mätati iqu Mena ique eämakqe. Mena iqu Melea ique eämakqe. Melea iqu Eliyakimä ique eämakqe. Eliyakimä iqu Jonamä ique eämakqe. Jonamä iqu Josepä ique eämakqe. Josepä iqu Jutä ique eämakqe. Jutä iqu Simiyonä ique eämakqe. Simiyonä iqu Lipai ique eämakqe. Lipai iqu Mätati ique eämakqe. Mätati iqu Jorimä ique eämakqe. Jorimä iqu Eliyesa ique eämakqe. Eliyesa iqu Josuwa ique eämakqe. Josuwa iqu Erä ique eämakqe. Erä iqu Elämatamä ique eämakqe. Elämatamä iqu Kosamä ique eämakqe. Kosamä iqu Ati ique eämakqe. Ati iqu Meläki ique eämakqe. Meläki iqu Neri ique eämakqe. Neri iqu Selatiyoli ique eämakqe. Selatiyoli iqu Serupapelä ique eämakqe. Serupapelä iqu Resa ique eämakqe. Resa iqu Joänanä ique eämakqe. Joänanä iqu Jota ique eämakqe. Jota iqu Josekä ique eämakqe. Josekä iqu Semenä ique eämakqe. Semenä iqu Mätatiyasi ique eämakqe. Mätatiyasi iqu Matä ique eämakqe. Matä iqu Näkai ique eämakqe. Näkai iqu Esäli ique eämakqe. Esäli iqu Nahumä ique eämakqe. Nahumä iqu Amosi ique eämakqe. Amosi iqu Mätatiyasi ique eämakqe. Mätatiyasi iqu Josepä ique eämakqe. Josepä iqu Jänai ique eämakqe. Jänai iqu Meläki ique eämakqe. Meläki iqu Lipai ique eämakqe. Lipai iqu Mätati ique eämakqe. Mätati iqu Heli ique eämakqe. Heli iqu Josepä ique eämakqe. Iŋi qokä-apäki, “Josepä iqu Jisasi Ique eämakqeqä” kŋuä indqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Iŋgaŋi Dŋä Äŋguä Iqu Jisasi Iqueqä äwqä imä kuapänä muŋgaŋga, Iqu aŋgu wätŋqä, eqä Jotänä iuŋi ävämakqe. Iqisaŋi Dŋä Äŋguä Iqu Jisasi Ique iwimäkqaŋgi, Iqu aŋä avqŋqä imä hiunji 40 äpmakqe. Iqu iu pmetaŋga, Setänä iqu, Jisasi Iqu suqä quvqä imäkätŋqä duŋqä yamwiqä äwimiŋqe. Imŋi Jisasi Iqu buayä maŋqä äpmenjaqänäqe, hiunji yäpakä iqueŋi Iqu buayä dä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iŋgaŋi Setänä iqu, “Si Goti Hanjuwä Iqueqä Ymequki etaŋgutqe, hikä tqu buayä kunmäknätŋqä, kukŋuä tuvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iŋäqe Jisasi Iqu kimaŋi, “Goti Hanjuwä Iqueqä kukŋui tii äqänä. ‘Ämaqe buayä dutanä pmeqä hmanjqä’” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","I tquaŋga, Setänä iqu ätuma äyäqe, aŋä-himqä eeqänäŋä qua täuŋi maqänä ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ämotquetä tii ätukqe. “Aŋä-himqä eeqänäŋä täuŋi, nyi Si misŋqä ktapmqänä. Itaŋi, Si yoqä naqä qondŋqinyä. Nätmatqä eeqänäŋi, ŋqä ae änyimäŋgqeqä. Itaŋgi nyi ämaqä hŋque wimqä etaŋgutqä di, nyi äwimqänä. ");
INSERT INTO mcr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iŋi Si qoŋä änäuktäutnä, nyaqä yoqe haqeu mamäuqaŋgtqe, eeqänäŋä tä Tqä hiäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","I tquaŋga Jisasi Iqu kimaŋi, “Goti Hanjuwä Iqueqä bukä iuŋi tii äqänä, ‘Si qoŋä äuktäutnä, Goti Hanjuwä tqä Naqä Iqueä yoqenä haqeqä ämamäutnä, wäuŋui Iqueqenä iqaŋginyä’ äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Itaŋi, Setänä iqu Jisasi Iqueŋi, Jerusälemäŋqä ätumä äwäqe, hiqäva-imäkqä aŋä atääqä yäŋgisa ätqäteqe, “Si Goti Hanjuwä Iqueqä Ymequki etaŋgutqe, qua mäŋi ikuapmäuvä. ");
INSERT INTO mcr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ii tiinjqä. Goti Hanjuwä Iqueqä bukä iuŋi tii äqänä. ‘Goti Hanjuwä Iqu Iqueqä eŋätqe, si äŋguä mikipŋqänä ätuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Iŋi tqä yuki, hikä iu hui matäveqä isŋqä diŋqe, iqua hipae hevqä mäkiqutäpŋqäuä,’ äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","I tquaŋga Jisasi Iqu kimaŋi tiiŋä ätukqe. “Bukä iuŋi tii äqänä. ‘Si Goti Hanjuwä tqä Naqä Ique, yamwiqä mävqä panä’ äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iŋgaŋi Setänä iqu, Jisasi Iqueŋi yamwiqä eeqänäŋi qäpu äväqe, hea hŋgaŋqä hiŋuä äqänä pmetŋqä diŋqä ävämakqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iŋgaŋi Dŋä Äŋguä Iqueqä yäŋänäqŋqä ditä qäsä, Jisasi Iqu Galili duŋqä aŋgumä äukqe. Ämaqä iqi pmeqe, Iquenyqä qätä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iqi äpme, iquauqä aŋä aquväqŋqä iu näqŋqä äväkiqe, ämaqä eeqänäŋä iuqä hiŋuä iqi, yoqä naqä täŋä-qu emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iqisaŋi Iqu Nasäretqäŋqä, aŋä Iqu hiŋuiqänä äpme naqä ekqä duŋqä ävämakqe. Iqi ätimäuqe, Iqueqä suqä dunä itä, Sämbatqä hiunji hapä pmeqäŋgaŋi, aŋä aquväqŋqä yäŋgisa äpeyätä, Goti Hanjuwä Iqueqä kukŋui a täutŋqä ätqäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ämaqä hiŋuä-tqä Asayä iqu bukä äqäkqe, ämaqä bukä miqä iqu ämetä, Jisasi Ique vqaŋga, Iqu ävatäqe, kukŋuä tiiŋä qänätaŋgi äqunätä a ätäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Dŋä Äŋguä Iqu nyaqä yäpä tämä äpmenä. Ii tiiŋiqä. Naqä Iqu nyi ätenjikqe. Qokä-apäkä nätmatqä maeqä du, Iqueqä kukŋuä äŋgui awä tumqätä, ämaqä guä pmetaŋguwä iquau, ‘Hiŋginä upŋqeqä’ tumqätä, ämaqä hiŋuä quvqä iquau-pqe, ‘Hiŋuä aŋgu qämbŋqeqä’ tumqätä, itaŋga ämaqä, huizi iqua mändi kittqiyätqätaŋguwä iquau, qanyä pmapŋqä iwimäkqämqä änändowatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Hea Naqä Iqu ämaqe äŋguä iwimäkäniqeŋqä äpätŋqe, qäqiqiyqä’ awä tquämqä änändowatkqeqä” qänätaŋgi a ätäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisasi Iqu a qäpu ätäuäqe, bukä ämuänyätä, aŋgi äväqe, quamä äpmakqe. Iŋgaŋi, ämaqä aŋä aquväqŋqä iu äpmamiŋuwä iqua, qu eeqänä Jisasi Ique hiŋuä yäŋänäqŋqä äqunmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iiŋä iqaŋguwäŋga, Iqu tii ätukqe. “Goti Hanjuwä Iqueqä kukŋuä bukä täu äqänäŋqä tä, he qätä äwiyäŋuwä iuŋi, täŋga ätimäuqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iqu i tquaŋga, eeqänäŋä iqua Iquenyqä yeeqä ipu, kukŋuä äŋguä ätpiyi, Iqu kukŋuä äŋguänäŋä tquaŋgqeŋqä kŋuä kuapä indqämbiyi, tiiŋä ätŋguwi. “Tä Josepä iqueqä Hikŋiqueqä. Kukŋuä tä, Iqu äŋgisa ämetä tqiyä?” ");
INSERT INTO mcr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisasi Iqu kimaŋi, tii ätukqe. “Ämaqe quamä äŋguänäŋä pmeqeuŋqä kukŋuä ätätqäŋuwä-paŋi, he ‘Si duuta iqukiyqä. Tqä-täuä äŋguä imäkinyä’ ändpiyi, itaŋga ‘Nätmatqä Si Kapänamä imäkŋiŋqe, ne qätä äwiyququeqä. Iŋäqe Tqä aŋä täqiŋi, asä i imäkiyä’ dpŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iŋgaŋi Iqu tiiŋä-pqe inä ätukqe. “Nyi naqä-qakuä etqänä. Ämaqe, hiŋuä-tqä quwqä aŋä-himqä iutaŋä iquenyqe, qu yeeqä miqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nyi naqä-qakuä tiiŋä-pqä etqänä. Kiŋganäŋi, Laisa iqu pmetaŋgaŋi, quväukui hŋquaqui-hŋque, qaŋui 6 iunä piyä maqiyqä itä, buayä dä naqänäŋä ätimäukqeqä. Iŋgaŋi apäqŋqä kuapänä hiua, Israitqä iu äpmamiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iŋäqe Goti Hanjuwä Iqu Laisa iqueŋi, apäqŋqä iuautaŋä huinyqä mändowatqä danä ikqeqä. Oeyä. Iqu iqueŋi, apäqŋqä yäpaqäŋgisaŋä aŋä-himqä Säläpatqä pmeqä huinyqä, aŋä-himqä naqä Saitonä iŋgisaŋqä ändowatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tiiŋä-pqä emiŋqe. Hiŋuä-tqä Elisa iqu pmetaŋgaŋi, qokä-apäkä wänyimäŋqä-täŋä kuapä Israitqä iu äpmamiŋuwiqä. Iŋäqe, eeqänäŋä iquauqä wänyimäŋqä qäpu maeqä da ikqe. Naimänä, qua Siliya pmeqä iqunä, äŋguä imäŋgqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisasi Iqu e tquaŋga, ämaqä aŋä aquväqŋqä iu äpmamiŋuwä iqua, kukŋuä qätä iiŋä äwipiyi, qu eeqänä äwqä tnäŋä naqänäŋä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Iiŋä ipiyi, iqua ävaupu, Iqueŋi aŋä-himqä yäpaqäŋgisa äkiwqatämäkuwi. E imäkäpiyitaŋi, qoqoŋä, aŋä-himqä iu mätnätaŋgqä yäŋgisaŋi, iwaqä bu ävqutäumanä-tpu, ätuma yqaŋguwäŋga, Iqu quvaqä awä iqisa äqupäwuŋga äwekqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iqisaŋi Iqu Kapänamä, aŋä-himqä Galilisäŋä iŋgisaŋqä äwäkqe. Sämbatqä hiunji hapä pmeqäŋgaŋi, Iqu ämaqä iquau näqŋqä äwimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iŋgaŋi Iqu, yoqä-täŋä-qu tquaŋgqeŋqä, qu qätä äwiyäpu, yäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iŋgaŋi, ämaqä dŋä quvqä-täŋä aŋä aquväqŋqä iu äpmamiŋqä hŋqu ämävauqe, maŋä yäŋänäqŋqä tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Äi! Jisasi Nasäretqätaŋä Iquki, Si squä nemäkätŋqäwä? Si ne qui nemäkätŋqä äpŋätanä? Nyi Sinyŋqe näqŋqä eŋänä. Si Goti Hanjuwä Iqueqä Ämaqä Jänänäŋä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","E tquaŋga, Jisasi Iqu yäŋänäqŋqä tii ätukqe. “Si kukŋuä matqä panä. Ämaqä iqueŋi huätä vämayä!” E tquaŋga, dŋä quvqä iqu, iqueŋi qu-täŋä awä iqi qua mäŋi äkimäuqe, ique qui mimäkqä itä ävämakqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ämaqe yäuŋuä ipiyi, tii ätŋguwi. “Kukŋui äkitaŋäwä? Iqueqä yoqetä yäŋänäqŋqä iutatä tquaŋga, dŋä quvqä iqua qätä äwiyäpu ävämeqäuä.” ");
INSERT INTO mcr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jisasi Iqu nätmatqä iiŋä imäkkqeŋqä tiwiqe, aŋä-himqä im-imä äwekqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisasi Iqu aŋä aquväqŋqä iuŋi ävämaŋi, Saimonä iqueqä aŋä iu äpaqukqe. Iqiŋi Saimonä iqueqä känemi, huiwä dŋä tnäŋä iqaŋgi witaŋgqeŋqä, qu Iqu yätamäkqä vätŋqä diŋqä yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I tquaŋguwäŋga, Iqu äwäqe, apäkä ii-säŋä qäqiqi ätqäuqe, yaqä huätä wätŋqänä kukŋuä yäŋänäqŋqä ätukqe. Iqu e tquaŋga, yaqä qäpu eqaŋgi, ii äŋguä maqänä imänäqe, ymisaŋä näwinyä imäkekqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Maptqä äqukunätŋqä itqätaŋga, qu ämaqä täŋä-yaqä huitaŋä-huitaŋä-täŋi, Jisasi Iquenyqä ätuma ätimäukuwi. Iiŋä iquauŋi, Iqu hŋqunä-hŋqunä hipa haqeqi äwiyätä, äŋguä iwimäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iqu e imäkätqätaŋga, dŋä quvqe ämaqä kuapänäŋä iuŋi ävämakuwi. Ävämepiyäŋgaŋi, qu Iqueŋi, “Si Goti Hanjuwä Iqueqä Ymeqä Iqukiyqä” ätukuwi. Qu, “Tqu Kraisi, Ämaqä mitŋqä Goti Hanjuwä Iqu ätekqä Iqueqä” näqŋqä etaŋguwitaŋi, Iqu, qu äkasuwä ätuätä, “He matqä pambiyä-qe,” yäŋänäqŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ziŋuäŋgaŋi, Jisasi Iqu aŋä avqŋqä duŋqä äväma äukqe. Iŋgaŋi ämaqe, qu Iquenyqä qävqä ikipu, ämäqumuapiyi, iquau mävämeqä yätŋqä, iqi ätäuqumuatekuwi. ");
INSERT INTO mcr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","E iqaŋguwiŋqä Iqu iquau tii ätukqe. “Henyä ma, aŋä-himqä huiuŋi, Goti Hanjuwä Iqunä miqeŋqä awä inä tumqeqä. Goti Hanjuwä Iqu iiŋiŋqä änändowatkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iqiŋi ävämaŋi, Iqu qua Jutiya iu ikitä, iquauqä aŋä aquväqŋqä iu awä ätuäkämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hiunji hŋqueŋi, Jisasi Iqu eqä Genesäretqä iqueqä maŋä iqi tqäutaŋga, ämaqä kuapänäŋä Goti Hanjuwä Iqueqä kukŋuä qätä wipŋqä, Iqu-täŋä qäqiqi ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisasi Iqu kukŋuä awä ätuätäqäŋgaŋi, hämapäkä-piqä hŋquauqä yimba hŋquaqu eqä maŋä iqi witaŋginyä äquŋgqe. Hämapäkä-piqä iqua yimba iu mäpmeqä, quwqä hämapäkä qa piunyqe, asŋä äqämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iŋgaŋi Iqu Saimonä iqueqä yimba ique hiŋuä äqunäqe, ätkamäutä, Saimonä ique, “Yimba nändi äma uvä” ätukqe. Itaŋi Iqu yimba iu quamä äpmeqe, qokä-apäkä iquau kukŋuä hui inä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iqu näqŋqä qäpu äväqe, Saimonä iqueŋi, “Si yimba eqä awä näŋi äma äwätnä, iqisaŋi he qae hämapäkiŋqä eqä-huäŋä bu tnämeqapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","I tquaŋga, Saimonä iqu kimaŋi, “Naqä Iquki, ne heatqä tqueŋi wäuŋuä yäŋänäqŋqä itqätaŋgu, zä aaŋqä änavqiyä. Ne hämapäkä tutqä qäpu mapiqä iqunä. Ga Si iiŋä ändiŋi, nyi qa ätnämäumqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Qu iiŋä ipiyi, hämapäkä kuapä piqaŋguwäŋga, qae ändakmäumätä ikqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iquauqä käyämaqä yimba huizi du äpmamiŋuwä iqua, yätamäkqä wipŋqä diŋqä hipa äuqueqä äwikuwi. Iqua äppiyi, hämapäki yimba hŋquaqui ämaikuwi. Iŋgaŋi yimba iquaqu eqä-huäŋä mämä quveqenyäsinyä ikiyi. ");
INSERT INTO mcr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimonä Pitä iqu, hämapäkä eeqänäŋä äpäkuwä iu äqunäqäŋgaŋi, iqu yäuŋuä naqänäŋä itä, Jisasi Iqueqä yukä yäpä iqi äpäknäqe, “Naqä Iquki, Si änyiväma uvä. Nyi ämaqä quvqunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iqunä ma. Ämaqä Saimonä iqutä anä äpmamiŋuwä iqua-pqe, yäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iqueqä wäuŋuä anä iqä, Jemisi iqutä, Jonä iqutä, Sepri iqueqä hikŋä iŋgueqi-pqe, yäuŋuä inä ikiyi. Saimonä iqu i tquaŋga, Jisasi Iqu kimaŋi, “Si zä miqä panä. Nyi, si ämaqe, hämapäkä eŋqä-pa, piqätŋäŋqä, ikimäkmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Qu yimba eyqiyämaŋi, eqä maŋä weä näŋinyqä äpäupiyi, quwqä nätmatqä eeqänäŋi hiŋuinä äquŋguaŋi, Jisasi Ique qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hea hŋqueŋi, Jisasi Iqu aŋä-himqä hŋque äpmamiŋqe. Aŋä-himqä iuŋi, ämaqä wänyimäŋqä kuapänäŋä-täŋä hŋqu äpmamiŋqe. Iqu Jisasi Ique hiŋuä äqunäqe, qoŋä äwoktäutä, hipeŋuä qua bu eätä, Jisasi Ique tii ätukqe. “Naqä Iquki, Si äkiŋgaŋgutqe, nyi äŋguä iqu nyimäkätninyä.” ");
INSERT INTO mcr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Itaŋga Jisasi Iqu hipa haqeqä äwiyäqe, tii ätukqe. “Nyi änyiŋgiyä. Si äŋguä imänyä.” I tquaŋga, ämaqä iqueqä wänyimäŋqe, äŋguä maqänä imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iiŋqe Jisasi Iqu tiiŋä ätukqe. “Nyi tä imäkqeŋqe, si ämaqä hŋque mätquä panä. Si hiqäva-imäkqä iquenyqä äyätnä, tqä huiwi ique motquayä. Mosisi iqu ätkqä-pa, tqä huiwä äŋguä ikimäkqeŋqä hiqäva imäkiyä. Iiŋqe, qu ‘ämaqä tqu iqueqä yaqe, äŋguä ae imäŋgqeqä’ kŋuä vätŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iqu, “Si ämaqä hŋque mätquä panä” qäyä ätukqä-qe, ämaqä im-imä äpmapiyä iqua, Jisasi Iquenyqä kukŋui qätä kuapänä äwimiŋuwi. Iŋgaŋi ämaqä kuapänä kukŋuä qätä wipŋqätä, iquauqä yaqä äŋguä iwimäkätŋqätä, Iquenyqä äpmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Qu iiŋä itqätaŋguwäŋga, hea kuapänäŋäŋgaŋi Iqu äväma, aŋä avqŋqä imqä äwätä, Goti Hanjuwä Iquenyqä tääqä ätuäqismiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hea hŋqueŋi Jisasi Iqu qokä-apäkiu näqŋqä vätqätaŋga, Parisitaŋä hŋquatä, kukŋuä-suqeŋqä näqŋqä hŋquatä aŋä-himqä eeqänäŋä Galilisaŋä, Jutiyataŋä, Jerusälemätaŋä iuta äppiyi, Jisasi Iqutä quamä anä äpmamiŋuwi. Goti Hanjuwä Iqueqä yäŋänäqŋqe, Jisasi Iqu ämaqä täŋä-yaqä iquau äŋguä iwimäkätŋqänä Iqutä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iŋgaŋi ämaqä hŋqua, ämaqä yäŋä-a quvqä hŋque hevqä ämiqutäwa äpäpu, aŋä yäpä yäŋgisa äma äpeyäpu, Jisasi Iqu-täŋä qäqiqi hianä-tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ämaqä kuapänä pmetaŋgä änä mäpeyqä ipiyi, aŋä haqä yätuŋqä äma äpepiyi, atääqä yäŋisa itäqäktäupu, ämaqä yäŋä-a quvqä iqueŋi, iqueqä hevqeu guä ämäsäupiyi, ämaqä pmetaŋguwä awä Jisasi Iqu tqäutaŋgqä buŋqä guä äyämäwatukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iqu quwqä quuvqä heqiyqä du hiŋuä äqunäqe, “Ŋqä näueqä iquki, tqä suqä quvqe, huätä ae ämakmäuqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iqu e iqaŋgqeŋqä, Parisi iquatä kukŋuä-suqeŋqä näqŋqä iquatä kŋuä tiiŋä indqäŋguwi. “Suqä quvqä huätä mamäuqe, Goti Hanjuwä Iqunänjqä. Iqueŋi äkittqiyetä, naqä timäutŋqä ätqäqä Tqu, ii Tqukä?” ");
INSERT INTO mcr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iquauqä kŋuä indqäŋqä imŋi, Jisasi Iqu näqŋqä ae eäqe, “He Nyinyqä kŋuä iiŋi, suŋqä indqäŋgäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Nyi qeiqinyä imäkätmä tmqe, kukŋui äkikä? ‘Tqä suqä quvqe huätä ämakmäuqänä’ tmqätanä ä, ‘Si ävautnä qaŋä uvä’ tmqätanä? ");
INSERT INTO mcr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tiiŋä eänä, Ämaqeuqä Ymeqä Ekqä Iqu, qua täuŋi suqä quvqe huätä mamäuŋqiyä. He iiŋiŋqe näqŋqä mapŋqe, Nyi ämaqä täŋä-yaqä iqueŋi tii ätquä. ‘Si ävautnä, tqä yquvaŋä a ämaqätätnä, aŋämqä uvä’ ätquänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jisasi Iqu e tquaŋga, iqu maqänä ävauqe, iqueqä yquvaŋi a ämaqätäqe, Goti Hanjuwä Iquenyqä “äŋguiqä” ätätä, iqueqä aŋämqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","E äqumbiyi, qu eeqänä yäuŋuä ipu, Goti Hanjuwä Iquenyqä “äŋguiqä” ätkuwi. Iiŋiŋqe, tiiŋä ätkuwi. “Täŋga ne nätmatqä huitaŋä yäŋänäqŋqe timäuqaŋgi hiŋuä äqunäŋunä” ätäpu, Goti Hanjuwä Iqueqä yäŋänäqŋqeŋqä kŋuä kuapänä indqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iqisaŋi Jisasi Iqu äwäqe, ämaqä mbqä motauqä hŋqu, mbqä motauqä aŋä iu pmetaŋgi äquŋgqe. Iqueqä yoqe, Lipai ique. Iqueŋi Jisasi Iqu, “Si qänaki nyivändiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","I tquaŋga, iqu nätmatqä eeqänäŋi iqi ävämetä, pämä ätqäuqe, Jisasi Ique qänaki äwivändkqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lipai iqu Jisasi Ique itmakqeŋqä, iqueqä aŋä du ymisaŋä naqänäŋä imäkkqe. Ämaqä kuapänä mbqä motauqä iquatä, ämaqä huizi-pqä iquatä, buayä anä änäpu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","I pmetaŋguwäŋga, Parisi iquatä, iquauqä ämaqä kukŋuä-suqeŋqä näqŋqä iquatä, Jisasi Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “He ämaqä mbqä motauqä iquatä, suqä quvqä imäkqä iquatä buayä anäŋi, suŋqä nätqäŋäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","I tquaŋguwäŋga, Jisasi Iqu kimaŋi, “Ämaqä yaqä maeqä iqua, duuta iquauŋqä mäwqä ipnä. Ämaqä yaqä iquanä upŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Iŋäqe, kŋuä äkunmäknäpu suqä quvqä vquatämäupŋqä diŋqe, Nyi ämaqä suqä äŋguä imäkqä iquau tääqä tumqä mapqä iqäqeqä. Ämaqä suqä quvqä imäkqä iquau tääqä tumqä äpqäqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iŋgaŋi qu Jisasi Ique, tiiŋä ätukuwi. “Ämaqä Jonä iqu wäuŋuäŋqä ämotquetŋqä iqua, buayä maŋqäŋqä imäkäpu, Goti Hanjuwä Iquenyqä tääqä ätätqäŋuwiqä. Itaŋga, Parisi iquauqä-pqä iqua, asänänjqä. Iŋäqe Saqä iqua, buayätä eqätä änätqäŋäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","I tquaŋguwäŋga, Jisasi Iqu tii ätukqe. “Ämaqä apäkä metŋqä hŋqu, iqueqä käyämaqä iquatä yqänä pmetaŋgaŋi, he iquauŋi, ‘Buayä maŋqä pambiyä’ tupŋqätanä? Oeyä! ");
INSERT INTO mcr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Qänakndaŋi, ämaqä hŋqua ique ätuma uwqaŋguwäŋga, iqueqä käyämaqä iqua buayä maŋqe, iŋganä pmapnuwäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","E ätuäqe, Iqu kukŋuä ktqä tii ätukqe. “Gquä yäuä hŋqu äpäkŋgqe, ämaqä hŋqu gquä änyä-häŋä dutaŋi, yäuä näŋuenyqä mapisqä yäŋqiyä. E äpisätqe, iqu änyä-häŋä ique qui imäkäŋqiyä. Itaŋga änyä-häŋitaŋitä, yäuä ditäŋi, asänäŋä maeqä etaŋgi, yäuä iqu äŋguä matimäuqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tiiŋi inänjqä. Ämaqä hŋqu wainqä-eqä änyä-häŋä hui, yaqueqä huiwä yäuä du mequatimäuqä yäŋqiyä. Iqu e imäkätqe, wainqä-eqä änyä-häŋi, yaqueqä huiwä yäuä iqueŋi äpisätä, qua bu iquasäunä. Yaqueqä huiwä-pqä qui inä imäknäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Iiŋiŋqe, qu wainqä-eqä änyä-häŋi, yaqueqä huiwä häŋä iu iquatimäupŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Itaŋga ämaqä wainqä-eqä yäuä äŋguwä iqua, änyä-häŋä duŋqe mäwiŋqä inä. ‘Yäuä iqu ämäwqätäunä’ ätätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sämbatqä hiunji hapä pmeqä hŋqueŋi, Jisasi Iqu kuä-witqä wäuŋuä iu ikämiŋqe. Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua anä ikipu, kuä-witqe ätäkäpu änmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iqua e iqaŋgä äqumbiyi, Parisi hŋqua tii ätukuwi. “Nätmatqä iiŋi, neyaqä suqä hiunji hapä pmeqäŋgaŋi, ne pmua imäkätuŋqueqä. He iiŋi suŋqä imäkqäuä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisasi Iqu kimaŋi tii ätukqe. “Hiŋuiqänäŋi, neqä awiqu Dewiti iqutä, iqueqä ämaqä iquatä buayä dä äpäkonäpiyäŋga imäkkqeŋqe, he kukŋui a matäuqä itqäŋuwätanä? ");
INSERT INTO mcr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iqu, Goti Hanjuwä Iqueqä aŋä yäpä yäŋgisa äpaquväqe, buayä Goti Hanjuwä Iqueqä hiŋuä iqi äwämiŋqe, ämakqe. Buayä iiŋi, hiqäva-imäkqä iquanä ämepu bŋqä äwämiŋqe. Huiziquauŋqe, ii pmuai. Iŋäqe, Dewiti iqu ämeqe, änätä, hui iqueqä ämaqä iquau äwikqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tiiŋä-pqe inä ätukqe. “Hiunji hapä pmeqeuŋi, Ämaqeuqä Ymeqä Ekqä Iqu ämitqänä.” ");
INSERT INTO mcr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hiunji hapä pmeqä huiziqueŋi, Jisasi Iqu aŋä aquväqŋqä hŋque äpaquväqe, näqŋqä äwimiŋqe. Qutä anäŋi, ämaqä hipa ämuaŋgisaŋi quvqä-täŋä hŋqu äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iŋgaŋi kukŋuä-suqeŋqä näqŋqä iquatä, Parisi iquatä kŋui, “Ämaqä Iqu ämaqä tqueŋi, hiunji hapä pmeqä täŋgaŋi, äŋguä iwimäkäŋqutiyä, ä äŋguä mäwimäkqä yäŋqutiyä?” vqaŋgi, Jisasi Ique kukŋuä mitpnuwäŋqä hänaqeŋqä qävqä ipu, hiŋuä äqumbu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Itaŋgi Jisasi Iqu iquauqä kŋuä indqäŋqä imŋiŋqe näqŋqe eäqe, Iqu ämaqä hipa quvqä ique ätukqe. “Si ävautnä, ämaqä iquauqä hiŋuä iqi pämä tqävä.” I tquaŋga, iqu ävautä e imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iqu e imäkqaŋga, Jisasi Iqu iquau ätukqe. “Nyi yatŋqä eyqänä. Neyaqä suqä duŋi, hiunji hapä pmeqäŋgaŋi, ne suqä äŋguä imäkatuŋquätanä, ä quvqä imäkatuŋquätanä? Ne ämaqä qui imäkmbŋqä pmetaŋguwä iquauŋi, yätamäkqä vatuŋquätanä, ä qui iwimäkatuŋquätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E ätuäqe, Iqu ämaqä eeqänäŋä iu hiŋuä äquŋgäwäqe, ämaqä hipa quvqä ique, “Si tqä hipae jänä väpäyä” ätukqe. Iqu tquaŋgqä-pa imäkqaŋga, iqueqä hipae äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iiŋä äqumbiyi, ämaqä kukŋuä-suqeŋqä näqŋqä iquatä, Parisi iquatä äwqä äkasuwä kuapänä muŋgaŋga, tii ätŋguwi. “Ne Jisasi Iqueŋi, äänä imäkatuŋquäwä?” ");
INSERT INTO mcr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Heatqä hŋqueŋi Jisasi Iqu, Goti Hanjuwä Iquenyqä tääqä tuätŋqä qoqoŋä yätuŋqä äyäqe, Goti Hanjuwä Iquenyqä tääqä tätqätaŋgi zä ävekqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mäptqä timäuqaŋga, Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau tääqä ätuätumeqe, qutaŋä 12 iquau atäuŋuä äväqe, “ämaqä wäuŋuäŋqä dowatqä” änyuätkqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ämaqä iiŋi, hŋqu iqueqä yoqe Saimonä ique. Iqueŋi, Jisasi Iqu “Pitä iqukiyqä” ätukqe. Hŋqu Endru, Saimonä iqueqä käŋgueque, hŋqu Jemisi ique, hŋqu Jonä ique, hŋqu Pilipä ique, hŋqu Batromi ique, hŋqu Matiu ique, hŋqu Tomasi ique, hŋqu Jemisi, Aläpiyasi iqueqä ymeqä ique, hŋqu Saimonä, ämaqä Selotqä iutaŋä-que, hŋqu Jutasi, Jemisi iqueqä ymeqä ique, hŋqu Jutasi Iskarioti ique. Ämaqä yäpakä tqu, qänakndaŋi Jisasi Ique ämaqä himä-wiuŋqä iquau väniŋqä ique. ");
INSERT INTO mcr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iqu iquau atäuŋuä ae äväqe, iquatä anä äppiyi, Iqu aŋä quauŋä hŋqäqi, ämaqä kuapänäŋä iquatä pämä anä ätqäukuwi. Iqutä anä ätqäumiŋuwä iqua, kuapänäŋä hŋqua, Iqueqä wäuŋuä ämotquamiŋqä iquai. Ämaqä huiziqua, hui qua Jutiya im-imä äpmakäwäŋuwä iutaŋi, hui aŋä-himqä Jerusälemä iutaŋi, hui eqä-huäŋä maŋä, aŋä-himqä Tayätä Saitonätä iŋgisaŋä-pqe anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iŋgaŋi qu Jisasi Iqueä kukŋui qätä wipŋqätä, iquauqä täŋä-yaqä äŋguä imämbŋqätä, äwimakuwi. Ga ämaqä dŋä quvqä iquauta qui imäknätqätaŋguwä iquauŋi, Jisasi Iqu äŋguä qe iwimäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ämaqä eeqänäŋi, qu Jisasi Iqueä yäŋänäqŋqä dutaŋi äŋguä imänäpiyä diŋqä, äwutmaqänanä-tpu imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iŋgaŋi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau hiŋuä äqunäqe, tii ätukqe. “Ämaqä nätmatqä maeqä iquenyä, he yeeqä enyänä. Tinjqä. Goti Hanjuwä Iqunä miqeuŋi, hiqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ämaqä täŋga buayä dä eyätŋqä iquenyä, yeeqä enyänä. Tinjqä. Qänakndaŋi he buayä kuapänä änäpu, äwqä äŋguä hipäsäniqeqä. Ämaqä kŋuä äqiyätqäŋuwä iquenyä, he yeeqä enyänä. Tinjqä. He qänakndaŋi, tä spnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Qänakndaŋi, he Ämaqeuqä Ymeqä Ekqä Iquenyqä quuvqä eqiyätqäŋuwä duta, qu äwqä äkasuwä kiiŋä etäpu, huätä endowatäpu, kukŋuä quvqä etäpu, hiqä yoqeŋqä ‘quvqeqä’ etäpu, qui imäkqaŋgpqäŋgaŋi, he yeeqä iqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hea iŋgaŋi, he aquvänä ipu, häukuä qutäqäpŋqä. Tinjqä. Nätmatqä äŋguänäŋä kuapänäŋi, qäukuä haqä yätu henyqä näwinyä äwinä. Suqä qu emäkpŋqä-paŋi, iquauqä kaqä-kawäka qäŋganäŋi hiŋuä-tqä iquauŋi iiŋä imäkmiŋuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Itaŋga ämaqä nätmatqä kuapä-täŋä iquenä, äŋguänä mimbiyä! Haŋä-iqä hemeŋqiyä! Nätmatqä hiqä äwqä äŋguä imäkmbŋqe, he ae ämeŋäuä. ");
INSERT INTO mcr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","He täŋga buayä änäpu, äŋguä äpmeŋuwä iquenä, äŋguänä mimbiyä! Haŋä-iqä hemeŋqiyä! Qänakndaŋi, he dä heyäniqeqä. He täŋga tä äsätqäŋuwä iquenä, he äŋguänä mimbiyä! Haŋä-iqä hemeŋqiyä! Qänakndaŋi, he ka ipu, kŋuä qäyqäpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ämaqä eeqänäŋi henyŋqä aquvänä iqaŋgpqäŋgaŋi, he äŋguänä mimbiyä! Haŋä-iqä hemeŋqiyä! Qäŋganäŋäŋgaŋi, hiŋuä-tqä quaŋgä iquauŋi, kaqä-kawäka iquauŋqä aquvänä asä e imiŋuwä-qe, iquauŋi haŋä-iqe, äwimakqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nyi he etqänä. Nyaqä kukŋuä qätä änyiyätqäŋuwä iquenä, he hiqä himä-wiuŋqä iquauŋqä, naqä-qakuänä heŋguätŋqeqä. Ämaqä henyqä mäwiŋqä itŋqä iquauŋi, he suqä äŋguänäŋä dinä iwimäkqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ämaqe, he qui imäkmbŋqä diŋqä tääqä ätätqäŋuwä iquauŋi, he iqua äŋguä pmapŋqä diŋqe, Goti Hanjuwä Iquenyqä tääqä tquäpŋqeqä! He ämaqä qui emäkätqätaŋguwä iquauŋi, Goti Hanjuwä Iqu iquau yätamäkqä vätŋqä tääqä tquäpŋqeqä! ");
INSERT INTO mcr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ämaqä hŋqu saqä maŋgawä iu kpäsqaŋqutqe, si hŋgisa inä wimäkqätŋqeqä. Ämaqä hŋqu saqä gquä quäuqä äquvätqe, gquetä qäsä qäyä ämequänä. ");
INSERT INTO mcr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ämaqä eeqänäŋi, nätmatqäŋqä yatŋqä kiyqaŋguwä iquauŋi, si äwisŋqeqä. Ämaqä hŋqu saqä nätmatqä meqaŋgutqe, si ‘Aŋgi dapiyäqe’ mätquä pa iqätŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Suqe, ämaqä qu he emäkpŋqä enyäŋqä-paŋi, he-pqe quŋi inä iwimäkpŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“He ämaqä henyqä äwinyätŋqä iquauŋqänä eŋgaŋgutqe, iiŋä itqäŋuwitaŋi, he nätmatqä äŋguänäŋä Goti Hanjuwä Iqueqä hipa iutaŋi, squä mapnuwäŋqäwä? Hmanjqä. Ii tiinjqä. Ämaqä suqä quvqä imäkqä iqua-pqe, iquauŋqä winyätqätaŋgqä iquauŋqänä äwinyätä, asä inä imäkqä-quaiqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","He ämaqä äŋguä emäkqaŋguwä iquaunä äŋguä iwimäkqaŋgpqe, he nätmatqä äŋguänäŋä Goti Hanjuwä Iqueqä hipa iutaŋi, squä mapnuwäŋqäwä? Hmanjqä. Ii tiinjqä. Ämaqä suqä quvqä imäkqä iquapqe, asä inä imäkqä-quaiqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","He ‘Iqu aŋgumä kima dapqoŋqä’ kŋuä indqämbu, ämaqä hŋque qanyinä vqaŋgpqe, he nätmatqä äŋguänäŋi squä mapnuwäŋqäwä? Hmanjqä. Ii tiinjqä. Suqä quvqä imäkqä iqua, ‘Iqu aŋgumä dapqoŋqä’ kŋuä indqämbu, suqä quvqä imäkqä huiziquau qanyinä wipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Itaŋga, hiqä himä-wiuŋqä iquauŋqä eŋgaŋguti, iquauŋi äŋguä iwimäkpŋqäuä. ‘Ämaqä tqu, aŋgumä mändapqä yäŋqiyä’ kŋuä qäyä indqänäpu, qanyinä wipŋqäuä. He suqä iiŋä imäkpqe, Goti Haqä Yätutaŋä Iqueqä ymeqä äpmepu, qänakndaŋi nätmatqä kuapänä Iqueqä hipa iutaŋi mapnuwiqä. Goti Hanjuwä Iqu, ämaqä qu Iquenyqä ‘äŋguiqä’ mätquä ipu, suqä quvqä imäkätqätaŋguwä iquauŋi, äŋguänä ämitqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Goti Hiqä Heniqu, ämaqeuŋqä wiuŋqä miqä, huäqä äwunätŋqä-pa, he-pqä huäqä heunätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“He ämaqä iquauqä suqeŋqä iwäsäupu, ‘Ämaqä quvqä-quaiqä’ matqä pambiyä. He iiŋä mimäkqaŋgpqe, Goti Hanjuwä Iqu heŋä-pqe memäkqä yäŋqiyä. Ämaqä hŋqu suqä quvqä imäkqaŋgqeŋqä, ‘Iqueŋi pizqä päkiyä’ mätquä pambiyä. He e mätquä iqaŋgpqe, Goti Hanjuwä Iqu henyqä e mätquä yäŋqiyä. He suqä quvqä qäyä etqueqaŋgpi, heqä äwqe haŋuä imäknäpu, hui enyänä. He iiŋä imäkqaŋgpqe, Goti Hanjuwä Iqu heŋi, iiŋä emäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“He nätmatqä ämaqeu vqaŋgpqe, Goti Hanjuwä Iqu nätmatqä tiiŋä hetapäŋqiyä. Iqu qa maŋguä ämanyuäqe, mändi äkisäutä, aŋgumä hui ämanyueqaŋga maŋguä ämnätä, hui qua mäŋi äpäkŋgqä-paŋä iiŋä hetapäŋqiyä. He nätmatqä qäyunä äwipqä-paŋä iiŋi, asä iiŋä hetapäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iwä Iqu iquauŋi, kukŋuä ktqe tiiŋä-pqe ätukqe. “Ämaqä hiŋuä quvqä hŋqu, hiŋuä quvqä hŋqueŋi, äŋguä itmetä hänaqeŋi äŋguä motqueniqiyä? Oeyä, qäquaqu qua hovqä bu päwäyŋqinyqä. ");
INSERT INTO mcr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ämaqä hŋqu näqŋqä ämetqe, iqueqä näqŋqä-vqä iqueŋi, mämäwqätäuqä yäŋqiyä. Ämaqä näqŋqä eeqänä qäpu ämapqä iqua, quwqä näqŋqä-vqä iqutäŋi, asänäŋä hipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Si tqä tta-tuŋgueqä hiŋuiu, hinoqukuä wäŋqä änyätaŋgqä ipi äqunätnä, tqä hiŋui zä naqänäŋä iqu qäyä witaŋgi kŋuä mindqäŋquki, suŋqä tutndi? ");
INSERT INTO mcr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iŋi äänä etaŋgikä? Tqä hiŋuiuŋi, zä naqänäŋä hŋqu qäyä witaŋgi hiŋuä änä mäquŋquä itnä, tqä tta-tuŋguequeŋi, ‘Tasi-guequkiyä, tqä hiŋuiuŋi, hinoqukui nyi huätä makmäumqänä-qe,’ äänä tutŋqäwä? Si wopqä itnä, kukŋuinä tqä-qukiyi. Zä naqänäŋä tqä hiŋuiu äwiŋqe, huätä ganä mamändŋqeqä. Iiŋä itŋi, si hiŋuä äŋguä äqänätnä, tqä tta-tuŋguequeä hinoqukui, huätä mamäutŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Zä äŋguä di, näŋqä ququvqä maqiyqä yänä. Itaŋga, zä quvqä di, häukuä äŋguä maqiyqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ämaqe, zä-häukuä hiŋuä äqunäpu, ‘äŋguätiyä, quvqätiyä?’ kŋuä indqämbŋqäuä. Qu zä-yäuŋguä maeqä guä yäŋä-täŋä iqiŋi, zä-eaqä häukui dupŋqe, mäwqä ipŋqäuä. Qu wainqäŋqänä kŋuä indqäŋga äupqe, guä yäŋä-täŋä iquauŋi, hiŋgi manduqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iiŋä eŋqä-paŋi, ämaqä äŋguänäŋä iqua, kŋuä äŋguänäŋä indqänäpu, suqä äŋguänäŋä di imäkpŋqäuä. Ämaqä quvqä iqua, kŋuä quvqä huitaŋä-huitaŋä indqänäpu, suqä quvqä imäkpŋqäuä. Ämaqä iquauqä kukŋui, ii iquauqä kŋuä indqäŋqä dutanjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Itaŋgi “He ‘Naqä Iqukiyä’ ändäpiyä-qe, Nyaqä kukŋuiŋqä qänaknä manyiyqä itqäŋuwi, suŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ämaqä Nyinyqä äpätä, Nyaqä kukŋuä qätä änyiyätä, qänaknä iqäqä iquenyqe, Nyi näqŋqä hitapmqänä. ");
INSERT INTO mcr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ämaqä iqu tiinjqä. Ämaqä hŋqu, qua mäŋqä mämä äptäqe, hikä iuŋi aŋä haqeqi yäŋänäqŋqä ämätqä-paŋä, iiŋiqä. Maqŋqä hitaŋgua, eqä huakä ätimäutä, aŋä du yäŋänäqŋqä äpäsqäqe, ämaqä iqu aŋä yäŋänäqŋqä ämätätqä-qae, aŋi ämeŋä miqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ämaqä hŋqu Nyaqä kukŋui qätä änyiyätä, qänaknä miqä iqä iqu, ii tiinjqä. Ämaqä qua mäqueqä aŋä hiŋginä ämätätqe, qänakndaŋi eqä huakä äpätä, aŋi qui imäkätä, qua iqi äpäkŋgqä-paŋä iiŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Itaŋga Jisasi Iqu qokä-apäkä iquau kukŋuä iiŋä qäpu ätuäqe, Iqu aŋä-himqä Kapänamäŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Iqiŋi Romätaŋä mäkä-iqä iquauqä naqä hŋqu äpmamiŋqe. Iqueqä wäuŋuä-wiyqä hŋqu, täŋä-yaqä ämetä, äpäkoŋqänä äwomiŋqe. Ämaqä naqä iqu, iquenyqä kuapänä wiŋgaŋgqetaŋi, iqu Jisasi Iquenyqä qätä äwiyäqe, ämaqä Israitqätaŋä naqä hŋquau, Jisasi Iqu äpätä, iqueqä wäuŋuä-wiyqä ique äŋguä iwimäkätŋqä diŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Qu Jisasi Ique äwimapiyi, kukŋuä aquvänä ätuäpu, “Iyääqä” ätukuwi. “Ämaqä naqä tqu, äŋguänäŋä-queqä. Si yätamäkqä wisŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Iqu Israitqä iquneŋqä äwinyätä, neqä aŋä aquväqŋqä änamäsikqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","E tquaŋguwäŋga, Jisasi Iqu qutä anä äukuwi. Qu äupiyi, ämaqä mäkä-iqä iquauqä naqä iqueqä aŋä-täŋä qäqiqi pätqätaŋgua, iqu iqueqä quvämaqä iquau, Jisasi Ique tii tupŋqä ändowatkqe. “Naqä Iquki, Si qae pmayä! Si nyaqä aŋä täŋgisaŋqä yaptŋqä diŋqe, nyi ämaqä äŋguänäŋä-qunä hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","‘Nyi ämaqä äŋguänäŋunä manä’ kŋuä nyiyqaŋgi, ŋqä-näuä mäkimeqä da iqänä. Iŋi, Si kukŋuinä tqaŋgti, nyaqä wäuŋuä-nyiyqä iqu äŋguä imänänä. ");
INSERT INTO mcr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nyi-pqe inänjqä. Nyi ämaqä yoqä-täŋä hŋqueqä yäpä imä äpmamä, ique qänaknä inä wimqänä. Nyaqä mäkä-iqä nyi ämitŋqä iquauŋi, hŋque ‘Si uvä’ tquaŋgmdqe, iqu äwäŋqiyä. Hŋque ‘Si biyä’ tquaŋgmdqe, iqu äpäŋqiyä. Itaŋga ŋqä wäuŋuä-nyiyqä hŋque, ‘Si tä imäkiyä’ tquaŋgmdqe, iqu imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iŋgaŋi Jisasi Iqu kukŋuä iiŋä qätä äwiyäqe, yäuŋuä itä, qänaki hiŋuä ämäqunäqe, ämaqä Ique qänaki wivändätaŋguwiu ätukqe. “Täukue! Ämaqä tqu quuvqä eqiyätŋqä-paŋä iiŋi, Israitqä duŋi, hiŋuä mäquŋquä itŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Iŋgaŋi ämaqä, mäkä-iqä naqä iqu ändowatkqä iqua, iqueqä aŋä iuŋqä aŋgi äupiyi, wäuŋuä-wiyqä iqu äŋguä pmetaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hiunji hui ae päwqaŋga, Jisasi Iqu aŋä-himqä, kiqä yoqe Nainqä iuŋqä äukqe. Iŋgaŋi iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, ämaqä kuapänä huizitä anä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Qu iqi ätimäupiyi, aŋä-himqä iqueqä täkŋä hävqä-täŋä qäqiqi uwqaŋguwäŋga, ämaqä aŋä-himqä iutaŋä kuapänäŋä iqua, ämaqä pizqä hŋque täkŋä yäpaqä mäŋgisaŋqä äma äukuwi. Hikŋä e äpäkoŋgqä iqueqä känai, apäqŋqä eä, ymeqä iqunäŋä-täŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naqä Iqu ii hiŋuä äqunäqe, huäqä wuŋgaŋgi, “Si kŋuä maqiyqä panä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E ätuäqe, qäqiqi äwäqe, isuäŋi a äqätkqe. I iqaŋga, ämaqä äma äpmiŋuwä iqua iqi tqäuqaŋguwäŋga, ämaqä pizqä iqueŋi, “Hikŋä iquki, ‘Si pämä vayä!’ äktqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","I tquaŋga, ämaqä ae äpäkoŋgqä iqu ävautä, kukŋuä ätipäqäkqe. Kukŋuä tqaŋga, Jisasi Iqu kiqä känäu aŋgi äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iŋgaŋi ämaqe, Goti Hanjuwä Iqueqä yäŋänäqŋqeŋqä zä ipu, Iqueqä yoqe haqeqä ämamäupu, “Hiŋuä-tqä Naqä Hŋqu ätimäuqiyä” ätkuwi. Itaŋga “Goti Hanjuwä Iqu, Iqueqä ämaqä yätamäkqä vätŋqä ätimäuqiyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisasi Iqu iiŋä imäkqaŋgqeŋqe, ämaqä Jutiyataŋätä, aŋä huiziutaŋä-pqetä, qu qätä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Ämaqä Jonä iqu wäuŋuäŋqä ämotquamiŋqä iqua, iqueŋi nätmatqä eeqänäŋä Jisasi Iqu imäkqaŋgqeŋqä awä ätukuwi. Jonä iqu qätä äwiyäqe, iqueqä ämaqä hŋquaqui tääqä ätuätumeqe, Naqä Jisasi Iquenyqä ändowatätä, tii ätukqe. “‘Ämaqä äpäŋqiyä ätätqäŋuwi, Si Qäqukitanä, ä hŋquenyqä hiŋuä inä äqänanä pmetuŋquätanä?’ qe yatŋqä e winyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Iquaqu Jisasi Ique äwimayi, tii ätukiyi. “Jonä asŋä-qäyqä iqu, ye Si yatŋqä kiyeŋqä äyändowatqiyä. Ämaqä äpäŋqiyä ätätqäŋuwi, Si Qäqukitanä, ä hŋquenyqä hiŋuä inä äqänanä pmetuŋquätanä?” ");
INSERT INTO mcr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iquaqu anä pmetaŋgua, Jisasi Iqu ämaqä kuapänäŋä, täŋä-yaqä-täŋä iquautä, dŋä quvqä-täŋä iquautä, hiŋuä pisqä iquautäŋi, äŋguä iwimäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iŋgaŋi iquaquvqä kimaŋi imäkätä, tiiŋä ätukqe. “Qe nätmatqä hiŋuä äqunäsinyä qätä äwiyäŋiyiŋqe, äwäsinyä, Jonä ique awä tiiŋä suinyqä. ‘Ämaqä hiŋuä pisqä iqua, hiŋuä äŋguä äqäŋgäuä. Yukä quvqä iqua, qaŋä äŋguä äwqäuä. Wänyimäŋqä-täŋä iqua, äŋguä imäŋgäuä. Qätäyqä iqua, qätä äwiyqäuä. Ae äpäkoŋguwä iqua, aŋgi ävauqäuä. Nätmatqä maeqä iqua, Goti Hanjuwä Iqueqä kukŋuä äŋgui qätä äwiyqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ämaqä, qu Nyi imäkqaŋgqeŋqä kŋuä indqänäpiyä iqua, quwqä quuvqä heqiyqe qui mimäkŋqä iqaŋgutqe, qu aquvänä ipŋqäuä’ suinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ämaqä Jonä iqueuä kukŋuä äma äpkiyä iquaqu ae uwqaŋgiyäŋgaŋi, Jisasi Iqu qokä-apäkä iuŋi, Jonä iquenyqä tii ätukqe. “He aŋä avqŋqä duŋqe, squä hiŋuä qumbŋqä äukuwäwä? Qoä-qamqä yuŋuä miqaŋgqe qumbŋqä äukuwätanä? Oeyä. ");
INSERT INTO mcr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Squä hiŋuä qumbŋqä äukuwäwä? He ämaqä hŋqu qäkä äŋguänäŋä yäuqä pmetaŋgqä ique, hiŋuä qumbŋqä äukuwätanä? Oeyä. Ämaqä qäkä äŋguä äyäupu, nätmatqä eeqänäŋä äŋguä imäkŋqä iqua, ämaqä miqä naqä iqueqä aŋä du pmetpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","He squä hiŋuä qumbŋqä äukuwäwä? Ämaqä hiŋuä-tqä hŋquenyqä hiŋuä qumbŋqä äukuwätanä? Ŋŋqä. Iiŋä sätäti, Nyi tiiŋä etqänä. Iqu, Goti Hanjuwä Iqueuä hiŋuä-tqä huizi iquauŋi ämäwqätäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","“Bukä iuŋi, Goti Hanjuwä Iqueqä kukŋui, tii äqänänä. ‘Qätä wipiyä. Ämaqä Nyaqä kukŋuä ämapqä hŋque, Si hiŋuiqä kimetŋqä ändowatqänä. Sinyqä hänaqä näwinyä imäuetŋqä iqueqä’ äqänänä. Kukŋuä iiŋi, ämaqä tquenyqä ätqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Itaŋgi Nyi he tiiŋä etqänä. Ämaqä qua täu pmeqä iqua, Jonä iqueŋi mämäwqätäuqä ipnuwiqä. Iŋäqe aŋä Goti Hanjuwä Iqunä miqä iuŋi, ämaqä yäpakä quvqä äpmeŋqä iqu, Jonä ique ämäwqätäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ämaqä eeqänäŋä iquatä, ämaqä mbqä motauqä iquatä qäsäŋi, qu kukŋuä iiŋä tqaŋgi äwipiyi, Jonä iquesa asŋä ämakuwitaŋi, iqua “Goti Hanjuwä Iqueqä suqä eeqänäŋi, jänänäŋiqä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Itaŋgi, Parisi iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, Jonä iqu asŋä uwqiyätŋqe mäwiŋqä ikqä iqua, qu hänaqä Goti Hanjuwä Iqu iquauŋqä näwinyä imäuekqeuŋiŋqä kukŋui, qätä mäwiyqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iŋgaŋi Jisasi Iqu tii ätukqe. “Ämaqä täŋga äpmeŋuwä iquauŋqe, Nyi änäänyä tmqäwä? Qu ämaqä änääŋuakä? ");
INSERT INTO mcr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Qu tiinjqä. Ymeqä ququawä aquväqŋqä iu äpmapu, ymeqä huizi iquauŋqä tääqä tiiŋä ätätqäŋuwiqä. ‘Ne henyqä hääwä qäyä ätqaŋgu, he himnuŋuä miqä iquwiqä. Ne pmapqä qäyä iqaŋgu, he kŋuä maqiyqä iquwiqä’ ätätqäŋuwiqä. Qu ymeqä tqua eŋqä-paŋä iiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jonä asŋä-qäyqä iqu äpäqetaŋi, bretqetä, wainqä-eqetä maŋqä iqaŋga, he ‘Dŋä quvqä-täŋä-queqä’ äyä ätkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iŋäqe Ämaqeuqä Ymeqä Ekqä Iqu äpäqetaŋi, buayä änätä eqä änätä iqaŋga, he tii ätqäuä. ‘Ämaqä buayä eqä yaqäpiqä itä änätä, wainqä-eqä kuapä ŋqueqä. Itaŋga ämaqä mbqä motauqä iquauqätä, suqä quvqä imäkqä iquauqätä näueqä-queqä’ inä ätqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iŋäqe, ämaqä Goti Hanjuwä Iqueqä kukŋuä näqŋqe ae ämapiyä iqua, tiiŋä motquapnä. Goti Hanjuwä Iqueqä näqŋqe, ii aaŋä naqä-qakuiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisitaŋä hŋqu Jisasi Iqu buayä anä nyiyŋqä tääqä ätuätumakqe. Tääqä tuätumeqaŋga, Iqu iqueqä aŋiuŋqä äwäqe, ymisaŋä nätŋqä yuki ipämäuä hiqoti äweukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Apäkä, ämaqe, “Ii suqä quvqä imäkqiyqä” ätmiŋuwä ii, aŋä-himqä iu äpmamiŋqe. Ii “Jisasi Iqu Parisi hŋqutä buayä anä änätqäŋinyqä” tqaŋgä qätä äwiyäqe, eqä-häkä jinaŋä-weqä äŋguänäŋä-täŋi äma äpkqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ii äwäqe, Jisasi Iqueä tuwä iqi, yukä-täŋä qäqiqi ätqäuqe, kŋuä äqäkqe. Iiyqä hiŋuä-eqe Jisasi Iqueqä yukä iu ioqaŋga, iiyqä detä ye imäkätä, Iqueä yukiu kikiyä kuapänä äwunätä, aowä jinaŋä-weqe equatekqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ii iiŋä imäkqaŋga, Parisi, Jisasi Ique itmakqä iqu, hiŋuä iiŋä äqunäqe, kŋuä tiiŋä indqäŋgqe. “Ämaqä Tqu hiŋuä-tqä-qu etaŋgutqe, apäkä Ique a äwqätqä iinyqe, ‘Ii suqä quvqä imäkqiyqä’ näqŋqä hiäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iqu kŋuä iiŋä indqäŋgaŋga, Jisasi Iqu, “Saimonä iquki, Nyi kukŋuä hŋqu ktmqeqä” tquaŋga, iqu, “Näqŋqä-vqä Iquki, Tqä kukŋui yqä tiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","I tquaŋga Jisasi Iqu tii ätukqe. “Ämaqä hŋqu nätmatqä kuapä-täŋä pmetäniqe. Iquesaŋi, ämaqä hŋquaqu nätmatqä aŋgu kima winyiyŋqä meqä-quaqu pmesinyiyiqä. Ämaqä aŋgu kima väniŋqä meqä hŋqu, kuapä-täŋue. Mä huiziqueqe, homänjqä. ");
INSERT INTO mcr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Itaŋgi iquaqu, ique kima vqä di hma hiätqätaŋgaŋi, iqu ‘qäyä eänä’ tuäniqeqä. Iŋi, Saimonä iquki, ämaqä tquaqu, ämaqä iquaquvqä kima vqeŋqä ‘qäyä eänä’ tqä iquenyqe, äwqä yeeqä iiŋqe, ämäwqätäuniqe, äsqukä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","I tquaŋga Saimonä iqu kimaŋi, “‘Ämaqä nätmatqä aŋgu kima väniŋqä, kuapänä meqä iqueqä’ kŋuä änyänä” ätukqe. Ga Jisasi Iqu, “Si qäyunä iwäsäunyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","I ätuäqe, Iqu tuwäŋgi hiŋui, apäkä ii ämäqunätä, Saimonä ique tii ätukqe. “Si apäkä täsiŋi hiŋuä äqunäŋinyä? Nyi saqä aŋä yäpä täŋgisa yapqaŋgaŋi, si Nyaqä yukiuŋqe, eqä mändapqä iŋi. Iŋäqe, apäkä täsi, iiyqä hiŋuä-eqe Nyaqä yuki ioqäqe, iiyqä detä yeŋuä imäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Itaŋga Nyi saqä aŋä täŋgisa äyapmä pmetaŋgaŋi, si himä kikiyä manuŋqä iqaŋgnä, ii Nyaqä yukiu kikiyä yqänä änunätqänä. ");
INSERT INTO mcr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Si olipqä eqä aowi, Nyaqä nuäŋiuŋi mänjiquatqä iqaŋgnä, ii aowä jinaŋä-weqe, Nyaqä yukiu änjiquatqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iiŋiŋqe Nyi si tii äktqänä. Ii Nyinyqä kuapänä äwinyätä, iiŋä nyimäkqaŋgqetaŋi, iiyqä suqä quvqä kuapänäŋä etaŋgqä-qe, huätä ae ämamäuqä. Iŋäqe, ämaqä hŋqu, suqä quvqä wäŋqäpu imäkqäqä eŋqe, Goti Hanjuwä Iqu iqueqä suqä iiŋi huätä ämamäuqe, iqu Iquenyqe, wäŋqäpu winyäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","I ätuäqe, apäkä iiŋi tii ätukqe. “Tqä suqä quvqe, huätä ae ämamäuqeqä.” ");
INSERT INTO mcr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","I tquaŋgqeŋqä, ämaqä buayä anä änäpu äpmamiŋuwä iqua, qätä äwipiyi, “Ämaqä, suqä quvqä huätä mamäuqäŋqä ätqäqä Tqu, Tqukä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iŋi, Jisasi Iqu apäkä iiŋi tii ätukqe. “Si qäqiqi qui imäknmätnä iqaŋgnä, tqä quuvqä heqiyqe yätamäkqä äkiyqiyä. Si äwqä qeiqi iŋqä uvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Qänakŋi, Jisasi Iqu aŋä-himqä wäŋqä iutä, naqä iutä, Goti Hanjuwä Iqunä miqä iuŋqä kukŋuä äŋgui awä ätuäkämiŋqe. Iŋgaŋi Iqueqä ämaqä 12 iqua-pqe, Iqutä anä ikämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Itaŋga apäkä, Jisasi Iqu iuauqä dŋä quvqetä, täŋä-yaqetä hiŋuiqänä huäta ändowatkqä iua, Iqutä qaŋä anä ikämiŋuwi. Apäkä huizqä yoqe, Mäliya ‘Maktälataŋä iiyqä’ ätmiŋuwi. Hiŋuiqänäŋi, Jisasi Iqu dŋä quvqä 7 huätä ämamäukqä iiyi. ");
INSERT INTO mcr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Itaŋga apäkä huiziyqä yoqe, Jonaiyi. Iiyqä qokiqueqä yoqe, Kusa, ämaqä naqä Heroti iqueqä aŋä ämimiŋqä ique. Itaŋga huiziyqä yoqe Susenayi. Apäkä kuapänäŋä hiua-pqe anänji. Iua iuauqä yquayä ämepu, Jisasi Iquesä, Iqueqä ämaqä iquautä yätamäkqä äväpu, anä ikämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ämaqä kuapänäŋi, aŋä-himqä im-imda äpäpu, Jisasi Ique wimeqaŋguwäŋga, Iqu kukŋuä ktqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ämaqä hŋqu kuä-witqä uwqä tnämäwäwätŋqä wänä. Iqu ätnämäwäwqaŋgaŋi, hui hänaqä iqi päkmbnä. Ii ämaqä qonjqä iqaŋguwäŋga, yŋŋä äpäpu ämambnä. ");
INSERT INTO mcr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hui qua hikä-täŋä iqi päkmbnä. Ii bakä äukaupqe, eqä ye etaŋgi, qänakndaŋi yäuä päpnä. ");
INSERT INTO mcr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hui guä yäŋä-täŋä awä imä päkmbnä. Kuä bakitä, guä yäŋä bakitä qäsä äukaupiyi, kuä baki qui imäkmbnä. ");
INSERT INTO mcr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hui qua äŋguä du päkmbnä. Bakä äukaupiyi, näŋqe kuapänä 100 hukmbnuwiqä” ätukqe. Jisasi Iqu e ätuäqe, Iqu maŋä yäŋänäqŋqä, “Ämaqä qätä-täŋuenä etaŋgutqe, kukŋuä iiŋqe kŋuä äŋguänä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iiŋä tquaŋga Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, kukŋuä ktqä iqueŋqä yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iqu iquauŋi tii ätukqe. “Goti Hanjuwä Iqunä miqeŋqä kukŋuä qakui zä witaŋgqä-qe, Iqu he näqŋqä mapŋqe, etapqiyä. Iŋäqe ämaqä huizi iqua, qu kukŋuä ktqenä äwiyätqäŋuwiqä. Qu hiŋuä äqunäpu qätä äwiyäpiyä-qe, näqŋqä maeqä-quayqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","E ätuäqe tiiŋä ätukqe. “Kukŋuä ktqä qakui, tiinjqä. Kuä-witqä uwqä iiŋi, Goti Hanjuwä Iqueqä kukŋuiŋqä atäuŋuä eänä. ");
INSERT INTO mcr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kuä-witqä uwqä hänaqä iqi päknätqe, ii tiinjqä. Qokä-apäkä Goti Hanjuwä Iqueqä kukŋui qätä äwiyäpu, quwqä äwqä imä manyueqaŋguwäŋgaŋi, Setänä iqu, ‘Qu quuvqä maeqiyqaŋgpi, Goti Hanjuwä Iqu quŋi aŋgi mitmeqä yäniqeqä’ kŋuä indqänätä äpätä, kukŋuä iiŋi huätä mamäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Itaŋga kuä-witqä uwqä qua hikä-täŋä iqi päknätqe, ii tiinjqä. Qu Goti Hanjuwä Iqueqä kukŋuä qätä äwipiyäŋgaŋi, aquvänä ipu ämapqe, kuä hukä tapiŋä maeqä eŋqä-paŋä iiŋiqä. Qu quuvqä eqiyäpiyä-qe, yamwiqä wimeqaŋga, qua iqi päkmbŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Itaŋga kuä-witqä uwqä guä yäŋä-täŋä iqi päknätqe, ii tiinjqä. Qu Goti Hanjuwä Iqueqä kukŋuä qätä äwipiyi, haŋä-iqeŋqätä, mbqeŋqätä, nätmatqä yeeqä iŋqä isuauŋqätä, kŋuä kuapä indqänäpu quuvqä heqiyqe yäŋänäqŋqä maeqä iäŋqiyä. Iŋi, qu kuä-witqä näŋqä naqe, maeqä eŋqä-paŋä iiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Itaŋga kuä-witqä uwqä qua äŋguä iu päknätqe, ii tiinjqä. Ämaqä Goti Hanjuwä Iqueqä kukŋui qätä äwiyäpu, kŋuä indqäŋqä imä äŋguänä ämaipu, quwqä qeqä-quuvqe jänänä imbu yäŋänäqŋqä ätqäŋuwi, näŋqä naqä äuknätŋqä-paŋä iiŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ämaqä hiqi-tä ämäsäupu, zä mäpatqiyeqä ipŋqäuä. Iquvaŋä yäpä imä maeqä ipŋqäuä. Ämaqä aŋä yäpä iŋgisa äyappiyä iqua, hiŋuä qumbŋqä diŋqe, qu hiqi-te, kiqä ätqäuqä ätnäŋä iqi tqätepŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ii tiinjqä. Nätmatqä eeqänäŋä zä äwämitätqe, ätnäŋäŋgisa witäniqeqä. Nätmatqä eeqänäŋä ämaqä iqua zä epqe, ätnäŋä iqi wiqaŋguti, qu hiŋuä äqunäpu näqŋqä hipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","He kukŋui qätä äŋguänä wipŋqä diŋqe, kŋui äŋguänä indqämbiyä. Ämaqä näqŋqä hui ae ämequwä iqua, Goti Hanjuwä Iqu hui inä väniqe. Itaŋga ämaqä näqŋqä maeqä iqua, näqŋqä wäŋqä qu ämeŋuwi, Goti Hanjuwä Iqu huätä mamäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iŋgaŋi Jisasi Iqueqä känaisä, käŋguäkatä ätimäupiyi, ämaqä kuapänä pmetaŋga, qu Iqu-täŋä qäqiqi mapqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","I iqaŋguwäŋga ämaqä hŋqu Jisasi Iqueŋi, “Tqä tnaisä, tuŋguäkatä Sinyqä hiŋuäŋqä äpquwi, yäpaqä täŋgisa ätqäuŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","I tquaŋga, Iqu kimaŋi tii ätukqe. “Ämaqä, Goti Hanjuwä Iqueqä kukŋuä qätä äwiyäpu qänaknä itqäŋuwä iqua, qu Ŋqä nipaqä, guäkayqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hiunji hŋqueŋi, Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, yimba ätkamäupu, Iqu iquauŋi, tiiŋä ätukqe. “Eqä-huäŋä yätäqä näŋgisaŋqä äwanä” ätukqe. I ätuäqe, iqua äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yimba iu qaŋä äwäpiyä iuŋi, Jisasi Iqu hiqaqä äwäkqe. Iŋgaŋi yuŋuä naqänäŋä hŋqu ätimäutä, eqe yimba iu huaquvämäqaŋga, eqä-huäŋä kuapänä ätuäqetaŋi, iqua qui imäkŋqänä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","I imäkqaŋga, qu Ique ävauqumuatäpu, “Naqä Iquki, Naqä Iqukiyä! Ne qui imäknatuŋquä iqunä!” ätukuwi. Iŋi Iqu ävauqe, yuŋuitä eqetä, “Qaiyä” ätukqe. E tquaŋga, yuŋuitä eqetä ämŋäŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jisasi Iqu iiŋä imäkäqetaŋi, ämaqä iquauŋi, “Hiqä quuvqä heqiyqe, äŋgikä?” ätukqe. Iŋgaŋi qu zä ipu, kŋuä kuapänä indqänäpu, quwqä-quwä kukŋuä ätŋguwi. “Yuŋuitä eqetä ‘qäyä enä’ ätuätä äminyeqäqä Tqu, Ämaqä Tqukä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iŋgaŋi Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, Gerasa iqua-täŋä hiqŋqä du ätimäukuwi. Gerasa, ii Galilisäŋä eqä-huäŋä näŋgisanji. ");
INSERT INTO mcr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Iqiŋi Jisasi Iqu yimba iutaŋi ätimäwa päwqaŋga, ämaqä aŋä-himqä iu pmeqä dŋä quvqä hui-täŋä hŋqu äwimakqe. Iqu ppqä itqätaŋgi, ämaqä iqua yukä hipa iu guä äkiqiyäupu, hiŋuä äqumbu, qäyä äpmetaŋgä, dŋä quvqä iqua, iqu guä ändakemä wätŋqä yäŋänäqŋqä iwimäkäpu, aŋä avqŋqä duŋqä wätŋqä iwimäkmiŋuwi. I imäkätqätaŋgua, ämaqä iqu tpqäyäqä ikitä, aŋiu mäpmeqä itä, hikä hovqä ämaqä pizqä wiqeu hiŋginäwa äwäyäkämiŋqe. Iqu Jisasi Ique hiŋuä äqunäqe, zääqä ätätä, Jisasi Iqueuä yukä iqi äpäknäqe, maŋi tiiŋä ätukqe. “Jisasi, Goti Haqä Yätutaŋä Iqueqä Ymeqä Iquki, Si äänä nyimäktŋqäwä? Nyi yatŋqä äkiyqänä, ‘Si qui minyimäkqä panä’” ätukqe. Iqu iiŋä ätukqe, ii Jisasi Iqu “Dŋä quvqe huätä äwänä” ae ätkqetanji. ");
INSERT INTO mcr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ämaqä iqu e tquaŋga, Jisasi Iqu yatŋqä ävätä, “Tqä yoqe, squkukä?” ätukqe. Ämaqä iqu kimaŋi, “Ŋqä yoqe ‘Hatŋunenjqä’” ätukqe. Tiiŋäŋqe, dŋä quvqä kuapänäŋi, iqueä äwqäŋgisa äpekuwiŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iŋgaŋi dŋä quvqä iqua, Jisasi Ique yatŋqä yäŋänäqŋqä äväpu, “Si ne qua hovqä aaŋä mämnäŋä väŋqä eŋqä-paŋä iuŋqä mänandowatqä panä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iŋgaŋi yaqueqä kuapänäŋä, hipkä hmbi buayä änäpu pmetaŋgä, dŋä quvqä iqua, Jisasi Ique yatŋqä yäŋänäqŋqä tii äwikuwi. “Ne yaqueqä iquauä äwqä yäpä duqumä paquvatuŋquä, hiŋuinä naqänäwqatiyä” ätukuwi. I tquaŋguwäŋga, Iqu hiŋuinä äqunäwatkqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iŋi, dŋä quvqä iqua, ämaqä ique ävämaŋi, yaqueqä iquauä äwqä imä qe äpaqukuwi. Iiŋä iqaŋguwäŋga, iqua iwaqä iu tnäŋä äwäpiyi, eqä bu quauqaŋguwäŋga, eqä qe änyuäpätäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","E iqaŋgä äqumbiyi, ämaqä yaqueqä miqä iqua zä äwäpu, kukŋui aŋä-himqä iutä, im-imä pmetaŋguwä iutä ätuäkäkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ämaqe qätä iiŋä äwipiyi, “Nätmatqä iiŋi äänä timäuqaŋgi tqäpiyä” tpu, hiŋuä qumbŋqä äpkuwi. Iqua Jisasi Ique äwimapiyi, ämaqä dŋä quvqä iqua ävämakuwä iqu, qäkä äyäuä, kŋuä äŋguä wimeqaŋga, Jisasi Iqueqä yukä-täŋä qäqiqi pmetaŋgi hiŋuä äquŋguwi. Iqua hiŋuä iiŋä äqumbiyi, zä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","“Dŋä quvqä-täŋä iqu, äŋguä äänä imäŋgutiyä” tpu kŋuä kuapä indqäŋgaŋguwäŋga, ämaqä, Jisasi Iqu imäkqaŋgi hiŋuä äquŋguwä iqua awä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iiŋä timäuqaŋgqeŋqä, ämaqä Gerasa pmeqä iqua, zä kuapänä äwinyätä, Jisasi Ique, “Nevämayä” ätukuwi. Iŋi, Jisasi Iqu yimba ätkamäuqe, aŋgi äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iqu äwätŋqä iqaŋga, ämaqä, dŋä quvqä iqua ävämakuwä iqu, Jisasi Ique yatŋqä yäŋänäqŋqä ävätä, “Nyi Sitä anä weŋqätanä?” ätukqe. Yatŋqä e vqaŋga Jisasi Iqu ämaqä iqueŋi, aŋgi ändowatätä, tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Si tqä aŋä duŋqä aŋgi äwätnä, kukŋuä eeqänäŋä Goti Hanjuwä Iqu si ikimäkqeŋqä, awä tuvä” ätukqe. I tquaŋga ämaqä iqu äwäqe, nätmatqä eeqänäŋä Jisasi Iqu iwimäkkqeŋqä, ämaqä aŋä himqä iu pmetaŋguwä iu awä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisasi Iqu iqi ävämetä, qua Galiliu aŋgi timäuqaŋga, qokä-apäkä Iquenyqä hiŋuä äqumbu äpmamiŋuwä iqua, yeeqä ipu itmakuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iqiŋi, ämaqä naqä aŋä aquväqŋqeu miqä hŋqu, Jisasi Ique äwimakqe. Iqueqä yoqe Jarusi, ique. Äwimeqe, iqu Jisasi Ique qoŋä äwoktäuqe, iqueuä aŋä duŋqä wiyäŋqänä yatŋqä yäŋänäqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Iqu ymeqä apäkä hmbnäŋä-täŋä-qu eeä, iipu äpäkonätŋqä qäqiqä etaŋgi, iiŋqä ätukqe. Iipiyqä quväukui 12 inji. Jisasi Iqu Jarusi iqutä itmaŋga äwätqätaŋgiyäŋga, qokä-apäkä kuapänäŋä-pqä Iqutä anä äwäpu, kukundä-kukundä äumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Quwqä awä iqiŋi, apäkä hui äumiŋqe. Ii hea ique-iqueŋi, qaŋuä yaqä e pmetaŋgi, quväukuä 12 ämäwqätäukqe. Ämaqä äŋguä iwimäkqäŋqe, hma emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ii Jisasi Iqueä tuwä-täŋä qäqiqi äpäqe, Iqueqä gquä quäuqä iu itmaqäŋgqe. Ii iiŋä iqaŋga, iiyqä yaqe, maqänä hma ekqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iiŋä iqaŋga Jisasi Iqu, “Tqu indmaqäŋgiyä?” ätukqe. Ämaqä eeqänäŋi qu hŋqunä-hŋqunä, “Nyi hmanjqä. Nyi hmanjqä” tqaŋguwäŋga, Pitä iqu tii ätukqe. “Naqä Iquki, ämaqä hävemä tä äpätuŋquä imda ikitmaqäŋgäuä.” ");
INSERT INTO mcr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","I tquaŋga Jisasi Iqu kimaŋi, tii ätukqe. “Ämaqä hŋqu Nyi indmaqäŋgiyä. Nyaqä yäŋänäqŋqä hui, änyivämeqaŋgi ätqänä.” ");
INSERT INTO mcr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iqu i tqaŋga, apäkä iiŋi, “Nyi zä mäpmeqä imä” kŋuä ämeqe, yäuŋuä itä, hipeŋui quamäŋi, Jisasi Iqu-täŋä qäqiqi eäqe, qokä-apäkä iuqä hiŋuiqisaŋi awä tiiŋä ätukqe. “Ii tiinjqä. Nyi täŋä-yaqä nyätaŋgi iktmaqäŋgänä. Nyi iiŋä imäkqaŋga, nyaqä täŋä-yaqe, qäpu maqänä eqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","I tquaŋga, Jisasi Iqu tii ätukqe. “Apäkä iiki, tqä quuvqä heqiyqe, äŋguä ikimäkqiyä. Si äwqä qeiqi iŋqä uvä.” ");
INSERT INTO mcr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisasi Iqu kukŋuä yqänä tätqätaŋga, ämaqä naqä aŋä aquväqŋqä iu miqä iqueqä aŋä iutaŋä hŋqu äpäqe, ämaqä naqä iqueŋi tii ätukqe. “Tqä ymeqe, ae äpäkoŋgiyä. Itaŋgi, Ämaqä Näqŋqä-vqä Iqueŋi, haŋä-iqä hui inä mävqä panä.” ");
INSERT INTO mcr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisasi Iqu kukŋuä ii qätä äwiyäqe, Jarusi iqueŋi, “Si zä miqä itnä, quuvqenä heqiyä. Ii aŋgi äŋguä imänäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iqisaŋi Jisasi Iqu, Jarusi iqueqä aŋä du ätimäuqe, qokä-apäkä huizi, aŋä yäŋgisa pepŋqe, hiŋuinä mäquŋquä ikqe. Pitä ique, Jonä ique, Jemisi ique, apäkä iiyqä kanä-käna-yaqutä, quwqä-quwänä pepŋqä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iŋgaŋi ämaqä aŋä yäŋgisa äpmapiyä iqua, kŋuä huäqä-huŋqä qiyätqätaŋguwäŋga, Jisasi Iqu, “He kŋuä maqiyqä pambiyä. Mäpäkoŋqä iqäqe, hiqaqä äwinä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iqu e tquaŋga, qu, hitqä ii pizqä witaŋgqeŋqä näqŋqä epiyi, tä äsukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Itaŋgi Jisasi Iqu, iiyqä hipa a ämaqätätä, “Ymeqä iiki, si pämä pmayä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iqu e tquaŋga, iiyqä quuvqe, aŋgi wimeqaŋga, maqänä ävaukqe. Ävauqaŋga, “Buayä winyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iŋgaŋi kaniqutä känaisä yäuŋuä kuapänä iqaŋgiyäŋga, Jisasi Iqu iyaquiŋi, yäŋänäqŋqä ätukqe. “Qe ämaqä hŋque nätmatqä tä timäuqaŋgi äqunäŋiyiŋqe, awä mätquä panyinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisasi Iqu Iqueqä ämaqä 12 iquau tääqä ätuätumeqe, dŋä quvqe huätä dowatäpu, täŋä-yaqä hiutaŋä-huitaŋä-täŋä iquau äŋguä wimäkäpŋqä diŋqä, yäŋänäqŋqetä yoqetä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iqu iquauŋi, Goti Hanjuwä Iqunä miqeuŋqä awä ätuäpu, täŋä-yaqä-täŋä iquau äŋguä iwimäkpŋqänä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ändowatätä tii ätukqe. “He yäkqätä, qatä, buayätä, mbqätä, gquä hŋquaqutä, mämeqä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","He aŋä-himqä hŋque äwimepu, ämaqä hŋqueqä aŋä iu äpaquväpiyi, aŋä-himqä ique vämapŋqäŋgaŋqe, iquenyä pmepŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aŋä-himqä hŋqueŋi, ämaqä yeeqä maeyqaŋgpqe, aŋä-himqä ique ävämepiyäŋgaŋi, qu quwqä suqä quvqeŋqä näqŋqä hipŋqänä, hinoqukuä heqä yukä iu täka emäkmitätqe, iqi ptä quväteqiyemä uwqäpŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iqu e tquaŋga, qu Goti Hanjuwä Iqueqä kukŋuä äŋguänäŋi awä ätuäpu, qokä-apäkä iuqä täŋä-yaqä quvqe, huätä ämamäupu, äŋguä iwimäkäpu, aŋä-himqä eeqänäŋä iu qaŋä ikäpŋqänä, Ique ävämakuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Iŋgaŋi ämaqä naqä Heroti, aŋä-himqä iu miqä iqu, Jisasi Iqu imäkqaŋgqeŋqätä, ämaqe Iquenyqä tqaŋguwiŋqätä qätä äwiyäqe, iqu kŋuä kuapänä indqäŋgqe. Hŋqua, “Jonä, qua äptekuwä iqu, aŋgi ävauqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hŋqua, “Laisa iqu ätimäuqiyä.” Hŋqua, “Hiŋuä-tqä hiŋuiqändqä hŋqu, aŋgu ävauqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Iiŋä äwiyäqe, Heroti iqu tii ätkqe. “Nyi Jonä iqueŋi, hiiŋuä ae ätäwikqeqä. Nyi qätä tä äwiyäŋqe, ii tquenyqä äwiyäŋänä?” Iiŋä äwiyäqetaŋi, iqu Jisasi Ique hiŋuä qunmätä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ämaqä Jisasi Iqu ändowatkqä iqua, aŋgu äppiyi, nätmatqä eeqänäŋä qu imäkkuwiŋqe, Jisasi Ique ätukuwi. Iŋgaŋi Jisasi Iqu, iquau ätuma äwäqe, quwqä-quwänä anä pmetanä-tpu, aŋä-himqä Betsaitä iŋgisaŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iŋäqe ämaqe, qu näqŋqä eäpu, iquau qänaknä äwivändkuwi. Qu Ique äwimeqaŋguwäŋga, Iqu yeeqä itmetä, Goti Hanjuwä Iqunä miqeuŋqä awä ätuätä, ämaqä täŋä-yaqä-täŋä iuŋi, äŋguä iwimäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hiaitäŋi, ämaqä 12 iqua Ique äwimapiyi, tii ätukuwi. “Si ämaqä iuŋi, qu aŋä-himqä iuŋqä äwäpu, buayäŋqätä, aŋäŋqätä qävqä ipŋqänä dowatiyä. Ne äpmeŋquä täuŋi, aŋä aaŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","I tquaŋguwäŋga, Iqu iquauŋi, “Hiqä-hiuä buayä wipiyä” ätukqe. Qu kimaŋi tii ätukuwi. “Ne buayi kuapänä mämeqä iäŋu. Ne bretqä hipa hŋgiŋi eeqätä, hämapäkä hŋquaqunä ämeŋunä. Ne ämaqä eeqänäŋä täuŋqe, buayä mbqä äŋgi yatuŋquäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iqiŋi ämaqä qokinäŋi, 5,000 äpmamiŋuwi. I tquaŋguwäŋga Iqu Iqueqä ämaqä iquauŋi tiiŋä ätukqe. “He iquauŋi, ‘He 50-50 iŋä, quamä pmakäupiyä’ tupiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iqua e tquaŋguwäŋga, qokä-apäkä iqua qätä äwiyäpu, quamä e äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Quamä pmeqaŋguwäŋga, Jisasi Iqu, bretqä hipa hŋgiŋi eeqä, hämapäkä hŋquaquŋitä ämeqe, hiŋuä haqä yätu äqänä Goti Hanjuwä Iquenyqä “äŋguiqä” ätäqe, buayitä hämapäkitä äkutätä, kiqä ämaqä iqua huiziu yaŋä wipŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Qu buayä qäpu änäpu, äwqä puäsqaŋga, iqi änätqutekuwi, iqua qa naqä 12 ämamikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hea hŋque Jisasi Iqu, Kiqä-kiuänä Goti Hanjuwä Iqutä kukŋuä anä ätqämanmiŋiyäŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Iqutä anä äpmapu, Iqu iquau yatŋqä tiiŋä äwikqe. “Qokä-apäkä iuqä kŋuä indqäŋqä duŋi, Nyi Tquŋgä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","I tquaŋga iqua kimaŋi, “Hŋqua, ‘Jonä asŋä-qäyqä iqueqä’ ätätqäŋuwiqä. Iŋäqe hŋqua, ‘Laisa iqueqä.’ Hŋqua, ‘Hiŋuä-tqä hiŋuiqändqä aŋgi ävauqä hŋqueqä’” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iqua e tquaŋguwäŋga, Iqu “Hiyaqä kŋuä duŋi, Nyi Tquŋgä?” ätukqe. Pitä iqu kimaŋi, tii ätukqe. “Si Goti Hanjuwä Iqueqä Kraisi, ne äminesŋqä ätekikqä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iŋgaŋi Jisasi Iqu, kukŋuä yäŋänäqŋqä tiiŋä ätukqe. “He täŋqe, ämaqä huiu awä mätquä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ämaqeuqä Ymeqä Ekqä Iqu, haŋä-iqä naqänäŋä meŋqiyä. Ämaqeu ämiqä iquatä, hiqäva-imäkqä naqä iquatä, ämaqä kukŋuä-suqeŋqä näqŋqä iquatä, qu Ique tuwä äwiyäpu äpäkpŋqäuä. Iŋi hea hŋquaqui-hŋqueŋäŋgaŋi, Goti Hanjuwä Iqu, Ique aŋgi ävauqumuatäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iŋgaŋi Jisasi Iqu eeqäpnäŋä iquau tii ätukqe. “Ii tiinjqä. Ämaqä hŋqu, Nyi qänaknä nyivändätŋqä wiŋgaŋgutqe, iqueqä äwiŋqä eeqänäŋi, kiuä mändi äkittqänätä, hiunji ique-iqueŋi, iqueqä zä-huätatä huŋqe ämetä, Nyi qänaknä nyivändänä. ");
INSERT INTO mcr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ii tiiŋiqä. Ämaqä hŋqu, iqueqä häŋä-pmeqe a yäŋänäqŋqä äkiqätmitätqe, qui imäknäniqeqä. Iŋäqe ämaqä hŋqu, Nyinyqä kŋuä indqänätä, iqueqä häŋä-pmeqe ävquatämämitätqe, iqu häŋä pmetäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Itaŋga ämaqä hŋqu, nätmatqä qua täuŋi eeqänä ämetä, iqueqä häŋä-pmeqe qui imäkŋgaŋgutqe, iqueqä nätmatqä eeqänäŋä iiŋi, yätamäkqä äänä väniqiyä? ");
INSERT INTO mcr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Itaŋga ämaqä hŋqu, Nyinyqätä, Nyaqä kukŋiŋqätä, womba wiŋgaŋgutqe, Ämaqeuqä Ymeqä Ekqä Iqu, yäŋänäqŋqä motqueqä Iqueqetä, Apiqueqetä, eŋätqä iquauqetä, ämetä äpätqäŋgaŋi, Iqu ämaqä iquenyqe, womba inä yäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Nyi naqä-qakuä tiiŋä etqänä. Ämaqä täqisaŋä hŋqua, qu mapäkoŋqä häŋä yqänä äpmamitpqe, Goti Hanjuwä Iqunä miqe hiŋuä qumbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisasi Iqu e ätukqeuŋi, wikä hŋqunä päwqaŋga, Iqu Pitä ique, Jonä ique, Jemisi iquesäŋi, qoqoŋä yätuŋqä ätuma, Goti Hanjuwä Iqutä kukŋuä anä siyŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iŋgaŋi Iqu Goti Hanjuwä Iqutä kukŋuä ätqämanäsiyäŋgaŋi, Iqueqä hipeŋui, huitaŋä änyätä, Iqueqä gque, qäpaiqänäŋä we-huŋqänäŋä iŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","E pmetaŋga, ämaqä hŋquaqu, Mosisi iqutä Laisa iqutä, ätimäusinyä, Iqutä kukŋuä anä ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iquaqu Goti Hanjuwä Iqueqä we-huŋqetä ätimävi, Jisasi Iqutä kukŋuä anäŋi, Goti Hanjuwä Iqu ätukqä-ma, Jerusälemä du imäkätä, qua täu ävämetŋqeŋqä ätnmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Iŋgaŋi Pitä iqutä, ämaqä huiziquaqutä quvaqä hiŋui haŋä ämipu hiqaqäŋqä iqämanmiŋuwi, yäuŋuä ipiyi, Jisasi Iqueqä huiwiuŋi we äunä, ämaqä hŋquaqu Iqutä tqäutaŋgä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","E äqumbiyi, iquaqu Jisasi Ique äväma wenyäsinyä tii itqätaŋgiyäŋga, Pitä iqu Jisasi Ique tii ätukqe. “Naqä Iquki, ne täqi äpmeŋque, ii äŋguiqä. Ne aŋä wäŋqä hnjua maqänä mätanä. Hŋqu Tqäŋqä, hŋqu Mosisi iqueqäŋqä, hŋqu Laisa iqueqäŋqäuä” ätukqe. Pitä iqu iiŋä ätuätäqä-qe, iqueqä-kiuäŋi kukŋui äkitaŋätiyä-qe, iqu maqŋqä emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitä iqu kukŋuä yqänä tätqätaŋga, qaquvqä hŋqu ätimäuqe, iquauŋi haqeqi äpatqäkqe. Iiŋä wimeqaŋga, iqua zä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iŋgaŋi qaquvqä yäpä imdaŋi, maŋä tii ätukqe. “Ämaqä Tqu, Nyaqä Ymeqeqä. Nyi ae ätekqä-queqä. He Ique qätä wipiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Maŋä qäpu tqaŋgqetäŋi, Jisasi Iqu kiqä-kiuänä äyä pmetaŋgi äquŋguwi. Iŋgata tiiŋi, iqua nätmatqä hiŋuä e äquŋguwiŋqe, ämaqä hŋque awä mätquä da imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Awiŋgaŋi, qu qoqoŋä iu ävämaŋi, qokä-apäkä kuapänä Jisasi Iqutä hänaqä awä iqi ämiŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ämimbiyi, quvaqä awä iqisaŋi, ämaqä hŋqu tääqä tii ätukqe. “Näqŋqä-vqä Iquki, nyi ymeqä kiuänäŋä-täŋunä etaŋgi, Si ique hiŋuä qundŋqä yatŋqä yäŋänäqŋqä äkiyqänä. ");
INSERT INTO mcr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dŋä quvqä hŋqu, iqueqä äwqä yäpä imä äpaquvätä, zääqä yäŋänäqŋqä ätätŋqeqä. Dŋä iqu imäkqaŋgi, iqu yäuŋuä-yäuŋuä itä, makusewä iqueqä maŋita ätimäutŋqeqä. Dŋä iqu ‘maqänä mävämeqä imä’ kŋuä vqaŋgi äpakänä äpme, iqueqä huiwiu quvqä imäkätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iiŋqe, nyi Tqä ämaqä wäuŋuäŋqä ämotquetqäŋä iquau, dŋä quvqä huätä dowatpŋqä yatŋqä yäŋänäqŋqä ae ävqeqä. Iŋäqe, iqua änä mimäkqä da iquwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","I tquaŋga, Jisasi Iqu kimaŋi, tii ätukqe. “Ämaqä täŋga äpmeŋuwä iquenä, he quuvqä maeqiyqä itqäŋuwiqä. Hiqä kŋuä indqäŋqetä, suqetäŋi, jänä hmanjqä. Nyi hesä anäŋi, squäŋgaŋqä pmetmqe? Hiqä quuvqä heqiyqe, yäŋänäqŋqe, squäŋga imäkmbnuwäŋqäwä? Tqä ymeqe, ätuma biyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Iŋgaŋi, ymeqä iqu äpätqätaŋga, dŋä quvqä iqu ique qua mäŋi mamäuqaŋga, ymeqä iqu yäuŋuä-yäuŋuä ikqe. E iqaŋga, Jisasi Iqu dŋä quvqä ique kukŋuä yäŋänäqŋqä ätuätä, ymeqä ique äŋguä iwimäkätä, kanique aŋgi äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iŋgaŋi, qokä-apäkä eeqänäŋi, Goti Hanjuwä Iqueqä yäŋänäqŋqeŋqä yäuŋuä ikuwi. Iiŋä ipiyi qu, Jisasi Iqu wäuŋuä eeqänäŋä imäkmiŋqeŋqä kŋuä kuapä indqänätqätaŋguwäŋga, Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau, tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“He kukŋuä tqueŋi, qätä äŋguänä nyipiyä. Ämaqe, qu Ämaqeuqä Ymeqä Ekqä Iqueŋi, ämaqä hŋquauqä hipa du wipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kukŋuä iqueqä qakuiŋqe, Iqueqä ämaqä iqua maqŋqä emiŋuwi. Kukŋuä qakui, iquauŋqä zä witaŋgi, iqua näqŋqä äŋguä mämeqä imiŋuwi. Ique yatŋqä vqäŋqe, iqua zä ipu, yatŋqä mävqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hea hŋqueŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, kukŋuä yäŋänäqŋqä, “Neyaqä awä iqisaŋi, yoqä naqä-täŋi tqukä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iiŋqe Jisasi Iqu, iquauqä kŋuä imŋi näqŋqä ae ämeqe, ymeqä wäŋqä hmbi ätuma äpäqe, Iqueqä-täŋä qäqiqi ätqätekqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","I iäqe, iquau tii ätukqe. “Ämaqä hŋqu Nyinyqä-pqe kŋuä indqänätä, ymeqä tqu pqaŋgi yeeqä ävätmeqä-paŋä iiŋi, yeeqä inä änyiyätmetŋqe. Itaŋga ämaqä hŋqu Nyi äpqaŋgä yeeqä änyiyätmeqäqe, iqu Nyi änändowatkqä Ique-pqe, yeeqä inä ävqiyä. Ii tiinjqä. Heyaqä awä iqiŋi, ämaqä hŋqu iqueqä yoqe mändi äkittqänätä äpmamitätqe, iqu yoqä naqä-täŋä-quvi.” ");
INSERT INTO mcr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iŋgaŋi Jonä iqu, Jisasi Iqueqä kukŋui qätä äwiyäqe, tii ätukqe. “Naqä Iquki, ämaqä hŋqu Tqä yoqä ätätä, dŋä quvqe huätä mamäuqaŋgi äqunanitaŋi, iqu ne qänaknä mäneyqä etaŋgi, ne iqueŋi, ‘Si iiŋi miqä panä’ ätququeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","I tquaŋga, Jisasi Iqu, “He ique pmua mimäkqä pambiyä. Ämaqä hŋqu hŋgisa metqueqä iqäqe, iqu hiqä-queqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hea Jisasi Iqu qäukuä haqä yätuŋqä aŋgu yäniŋqä qäqi pätqätaŋgaŋi, Iqu Jerusälemä duŋqä wätŋqä kŋuä yäŋänäqŋqä indqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iŋgaŋi, Iqu ämaqä kukŋuä äma uwqä hŋquau, hiŋuiqä ändowatkqe. Iqua äupiyi, Iquenyqä nätmatqä nawenyä imäkpŋqä diŋqä, Sämaliya pmeqä iquauqä aŋä-himqä hŋque äpaqukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Äwimeqaŋguwäŋga, ämaqä iqi äpmamiŋuwä iqua, Jisasi Iqu Jerusälemäŋqä wätŋqeŋqä näqŋqä ämapiyi, Iqu iquauqä aŋä du wimetŋqä diŋqe, mäwiŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","I iqaŋguwiŋqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquaqu, Jemisi iqutä Jonä iqutä, näqŋqä ämayi, Jisasi Ique tii ätukiyi. “Naqä Iquki, Si ye tääqä teŋqä äkiŋgiyä? Qäukuä haqä yätutaŋi, tä iwa äpätä, ämaqä täu tä nätŋqä diŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","I tquaŋgiyiŋqe, Iqu hiŋuä ämoqunätä, “Iiŋi matqä panyinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iiŋä tquaŋga, qu aŋä-himqä huiziuŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Qu hänaqä awä iqi qaŋä wätqätaŋguwäŋga, ämaqä hŋqu, Jisasi Ique tii ätukqe. “Si aŋä-himqä eeqänäŋä iuŋqä uwqaŋgtqe, Nyi qänaki kivändmqänä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisasi Iqu kimaŋi, tii ätukqe. “Hiveqä hiqiyqä iqua, iquauqä aŋä-täŋiqä. Yŋŋä iqua, aŋä-täŋiqä. I etaŋgi, Ämaqeuqä Ymeqä Ekqä Iqu, Iqueqä aŋä hiqaqä wiqe, hmanjqä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ämaqä hŋquququeŋi, Jisasi Iqu, “Si qänaki nyivändiyä” ätukqe. I tquaŋga, ämaqä iqu, “Naqä Iquki, apique ganä qua qäyä mapteumqä, Si hiŋuinä ŋqänäwqatiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","I tquaŋgaŋi, Jisasi Iqu kimaŋi, tii ätukqe. “Qäyä eänä. Ämaqä ae äpäkombqä iqua, quwqä ämaqä pizqä iqueŋi, qua qäyä ptepŋqeqä. Si äwätnä, Goti Hanjuwä Iqunä miqeuŋqä, awä tuäkätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Itaŋga ämaqä huiziqu, Jisasi Ique tii ätukqe. “Naqä Iquki, nyi qänaki kivändmqä etaŋgqä-qe, ŋqä ämaqä iquau yeeqä wimqä aŋämqä ganä umqe, Si hiŋuinä ŋqänäwqatiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iqueŋi, Jisasi Iqu tii ätukqe. “Ämaqä hŋqu wäuŋuä imäkätäqäŋgaŋi, hea ique-ique iqueqä aŋämqä kŋuä yqänä vqaŋguti imitätqe, iqu Goti Hanjuwä Iqunä miqeuŋi, yätamäkqä änä mävqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Qänakndaŋi Naqä Iqu, ämaqä 72 atäuŋuä itä, hŋquaqunä-hŋquaqunä ändowatkqe. Aŋä-himqä eeqänäŋä iuŋi, Iqu Iqueqä-kiuä äwäniŋqä diŋqä, iqua hiŋuiqä upŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iiŋä mimäkqäŋgaŋi, tii ätukqe. “Wäuŋuä iuŋi, ymisaŋä yäuä kuapänä iätaŋgqä-qe, ämaqä wäuŋuä itqäŋuwi, kuapänä hmanjqä. Iiŋiŋqe, wäuŋuä-täŋä Kaniquenyqä tääqä ätuäpu, Iqu ämaqä wäuŋuä iqä häŋä hŋquau ymisaŋä aquvä mipŋqä dowatätŋqä diŋqä tupuiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","E ätuäqe, “He upiyä. Nyi endowatqe, ii tiinjqä. Sipsipqä, hiveqä hiqiyqä iquauqä awä imä upŋqä endowatqänä. ");
INSERT INTO mcr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hiqä mbqä qaetä, hiqä yquayä qa-mŋqetä, itaŋga hiqä yukiu muasmäuqe, qäsä äma mäwqä pambiyä. Qaŋä äwäpiyä iuŋi, qokä-apäkä hui, hänaqä awä iqi äminäpiyi, ‘Hiunjiyqä’ mätquä pambiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“He aŋä hŋqua-hŋquau äpaquväpiyi, tii ganä tquäpŋqä. ‘Ämaqä aŋä täu äpmeŋuwä iquenä, he äwqe, haŋuä iŋqä pmapiyä.’ ");
INSERT INTO mcr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ämaqä äwqä haŋuä iŋqä hŋqu aŋä iu äpmamitätqe, hiyaqä kukŋuä äŋguänäŋi, iquenyqä wätŋqeqä. Iŋäqe ämaqä äwqä haŋuä iŋqä hŋqu, iu mäpmeqä imitätqe, hiqä kukŋuä äŋguänäŋi, hiqä-hiuäŋqä asuŋgumä quvepäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","He buayä-sua, eqä-sua hitapqaŋguwi, änäpu, aŋä iquenyä pmapŋqeqä. Quati tiinjqä. Ämaqä hŋqu wäuŋuä imitätqe, iqu iqueqä mbqe ämeniqä eäŋqe, ii äŋguiqä. I etaŋgi, he aŋä huizi du mäpmeqä pambiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","“Itaŋga he aŋä-himqä hŋqua-hŋquau timäuqaŋguwäŋgaŋi, qu henyqä aquvänä ipu, ymisaŋä iwäsäuqaŋgpqe, ämepu änäpu, ämaqä täŋä-yaqä-täŋä iqi pmetaŋgpqe, äŋguä iwimäkäpu, kukŋuä awä tiiŋä tupŋqeqä. ‘Goti Hanjuwä Iqunä miqe, hesäŋä qäqiqi ae äquvepqiyä.’ ");
INSERT INTO mcr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Iŋäqe, he aŋä-himqä hŋqua-hŋquau timäuqaŋguwäŋga, qu aquvänä miqä iqaŋgpqe, aŋä-himqä hänaqä iqi ätqäupu, tii tquäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Qua hinyaŋä heyaqä aŋä-himqä täutaŋä, neyaqä yukä täu ämäkäŋqe, ne ptä quväteqäma yaŋqunä, hiqä suqä quvqeŋqä ämetquetuŋquänänyä. Iŋi, he näqŋqä tiiŋä hipŋqäuä. Goti Hanjuwä Iqunä miqe, qäqiqi ae äquvepqeqä’ tquäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nyi he etqänä. Qänakndaŋi, hiunji Goti Hanjuwä Iqu suqä quvqeŋqä iwäsäuqäŋqä ätekqeuŋi, ämaqä aŋä-himqä iquesaŋä iquauqä haŋä-iqe, Sotomä äpmamiŋuwä iquauqä haŋä-iqe ämäwqätäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iqu tiiŋä-pqä inä ätukqe. “Ämaqä Kolasinä pmeqä iquendä, Betsaitä pmeqä iquendä, hiqä haŋä-iqeŋqä ‘Oänä’ etqä. Tiinjqä. Nätmatqä ämaqä mimäkqänäŋi, Nyi heyaqä awä iqisa imäkkqä-paŋi, ämaqä hŋqu Tayä pmeqä iquauätä, Saitonä pmeqä iquauätä, awä iqisa imäkqä-säpi, qu qäŋganä tiiŋi ae heqäpniŋgä. Quwqä suqä quvqeŋqä womba ipu, tuwä äwiyäpu, quwqä huäqä-huŋqä qäki ämäyäupu, tä wätakiu pmeqäpniŋgä. ");
INSERT INTO mcr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Iiŋiŋqe, hiunji Goti Hanjuwä Iqu suqä quvqeŋqä iwäsäuqäŋqä ätekqeuŋi, heyaqä haŋä-iqe, Tayä pmeqä iquauqätä, Saitonä pmeqä iquauqätäŋi, ämäwqätäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Itaŋga Kapänamä pmeqä iquenyä, he qäukuä haqä yätuŋqä hipnuwätanä? Oeyä, he ämaqä pizqä iquauqä aŋä buŋqä wäpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","I ätuäqe, ämaqä, Iqu ändowatätŋqä iquauŋi, Iqu tiiŋä ätukqe. “Ämaqä hŋqu heyaqä kukŋuä qätä eyqäqe, Nyaqä kukŋuä-pqe, qätä inä änyiyqiyä. Ämaqä hŋqu he tuwä eyqäqe, iqu Nyi-pqe tuwä inä änjiyqiyä. Ämaqä hŋqu Nyi tuwä änjiyqäqe, Nyi änändowatkqä Ique-pqe, tuwä inä äwiyqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Qänakŋi ämaqä, Jisasi Iqu ändowatkqä iqua, aquvänä ipu, aŋgumä äppiyi, tii ätukuwi. “Naqä Iquki, ne Saqä yoqe tquaŋgua, dŋä quvqä iqua, neyaqä kukŋuiu qänaknä iquwiqä.” ");
INSERT INTO mcr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iwä, Jisasi Iqu tii ätukqe. “Nyi hiŋuä äqunäŋqeqä. Setänä Goti Hanjuwä Iqutä himä-wiuŋqä iqu, qakuä haqä yätuta päkŋgaŋga, nyuauä eŋqä-pa iqaŋgi äqunäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Qätä nyipiyä! Qämakitä, qänjuakätaitä qo äkitäupu, Setänä iqueqä yäŋänäqŋqe, ämäwqätäupŋqä diŋqetäŋi, Nyi yoqä naqä ae etapqeqä. Iiŋiŋqe, nätmatqä qui emäkätŋqä di, aaŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Itaŋgi, ‘Dŋä quvqä iqua, neyaqä kukŋuiu qänaki iquwiqä’ ätäpu, aquvänä miqä pambiyä. Goti Hanjuwä Iqu heyaqä yoqe, qäukuä haqä yätu ae äqiyqäqeŋqä aquvänä ipiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iŋgaŋi, Dŋä Äŋguä Iqu yeeqä wimäkqaŋgi, Jisasi Iqu tii ätkqe. “Apä, qäukuitä quaetä Miqä Iquki, ämaqä näqŋqätä kŋuä-täŋä iquauŋqe, Si nätmatqä tä zä äkittqiyäŋä-qe, ymeqä däŋä-suau eŋqä-pa, äyä ämotquenyä. Si e imäkqaŋgnä, Nyi ‘äŋguiqä’ äktqänä. Auä, Apä, Si Tqä äkiŋqeu qänaknä itnä imäkinyä.” ");
INSERT INTO mcr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ämaqeuŋi, tiiŋä-pqä inä ätukqe. “Ŋqä Apiqu nätmatqä eeqänäŋi, Ŋqä hipa täu änjiyqeqä. Ämaqe, Ymeqä Iquenyqä näqŋqe, aaŋqeqä. Apiqunänjqä. Ämaqe, Apiquenyqä näqŋqe, aaŋqeqä. Ymeqä Iqutä, ämaqä Ymeqä Iqu ämotquetŋqä iquatä, iquanänjqä.” ");
INSERT INTO mcr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iŋgaŋi, Iqu tuwäŋgi hiŋuä ämoqunäqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquaunä tii ätukqe. “Ämaqä nätmatqä he hiŋuä äqunätqäŋuwiu hiŋuä qumbŋqä iqua, aquvänä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tiiŋä etqänä. Nätmätqä he hiŋuä äqunätqäŋuwi, hiŋuä-tqä iquatä, ämaqä naqä iquatäŋi, qu hiŋuä quŋqäŋqä kuapänä winyätqätaŋgqä-qe, hiŋuä mäquŋquä imiŋuwiqä. Kukŋuä he qätä äwiyätqäŋuwi, qu qätä wiyqäŋqä winyätqätaŋgqä-qe, qätä mäwiyqä imiŋuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ämaqä kukŋuä-suqeŋqä näqŋqä hŋqu, Jisasi Ique yamwiqä ävätä, tiiŋä ätukqe. “Näqŋqä-vqä Iquki, häŋä hea ique-ique pmeqä mamqe, nyi äänä imäkmqäwä?” ");
INSERT INTO mcr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","I tquaŋga Jisasi Iqu, “Kukŋuä-suqä iuŋi, äänä äqänänä? Si a äänä ätäutqäŋäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iqu kimaŋi, “‘Goti tqä Naqä Iqueŋi, tqä qeqä-quuvqetä, yäŋänäqŋqetä, kŋuitä, Ique äwitnä, itaŋga Iquenyqänä kuapänä kiŋguätŋqeqä.’ Tiiŋä inänjqä. ‘Si tqä-täuŋqä äkinyätŋqä-paŋi, ämaqä si-täŋä iqi äpmeŋuwä iquauŋqä-pqe, inä kinyätŋqeqä’” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ga Jisasi Iqu kimaŋi, “Ii qäyunä ätnyä. Si e imäkätŋi, hea ique-ique pmettŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Itaŋi, ämaqä kukŋuä-suqeŋqä näqŋqä iqu, qu iquenyqä, ‘Iqu suqä äŋguänäŋä iqä-queqä’ kŋuä mapŋqä wiŋgaŋgi, tii ätukqe. “Ämaqä nyi-täŋä iqi äpmeŋuwi, tqukuakä?” ");
INSERT INTO mcr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mä, Jisasi Iqu kimaŋi, tii ätukqe. “Ämaqä hŋqu Jerusälemä ävämaŋi, Jerikoŋqä quveqätqätaŋga, ämaqä quwä-meqä hŋqua, iqueqä yquayä eeqä ämotaupu, äpäseqa weqaŋguwäŋga, iqu äpäkonmätä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iqu e witaŋga, hiqäva-imäkqä hŋqu hänaqä asä iu äquveqätä, ique hiŋuä äqunäqe, hänaqä hŋgisa jänä mäwqätäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Itaŋi ämaqä Goti Hanjuwä Iqueqä aŋä iu wäuŋuä iqä hŋqu ätimäuqe, ique hiŋuä äqunäqe, hänaqä hŋgisa jänä inä mäwqätäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Itaŋga yäpaki, Sämaliyataŋä hŋqu-pqe qaŋä äpmitätqe, ique äwimeqe, hiŋuä äqunäqe, iquenyqä huäqä kiiŋä wunäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iiŋä itä, qäqiqi äwimeqe, olipqä eqä aowitä, wainqä-eqetä, ämaqä iqua äpäkpqeu equateqe, huäqä wotäniqeqä. Itaŋi, iqueqä doŋgi iu ämäqumuateqe, aŋä ämaqä hiqaqä äwiqismipqä iuŋqä ätuma äwäqe, ique äminiqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ziŋuitäŋi, iqu ämaqä aŋä miqä iqueŋi, mbqä kuapänä ävätä tii tuäniqeqä. ‘Si ämaqä tqueŋi, äŋguänä miyä. Itaŋga si mbqä saqä-pqä hui äwisqä etaŋgutqe, nyi aŋgi äquvepätmäŋgaŋi, nyaqä kima ktapqämqä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","I ätuäqetaŋi, ämaqä ique yatŋqä tiiŋä äwikqe. “Ämaqä tquaqui-tquenyqe, si kŋuä äänä kiyqiyä? Ämaqä quwä-meqä iqua äpäsekuwä iquenyqe, ‘Tqu nyi-täŋä iqi pmeqä-queqä’ kŋuä indqänätä, suqä qäyunä motqueniqe, tqukä?” ");
INSERT INTO mcr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","I tquaŋga, ämaqä iqu tii ätukqe. “Ämaqä qeqä äwimänätä, ique yätamäkqä väniqä iqueqä.” Iŋgaŋi, Jisasi Iqu, “Si äwätnä, suqä asänäŋi imäkiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, qu qaŋä äupiyi, aŋä-himqä hŋque ätimäukuwi. Iqi timäuqaŋguwäŋga, apäkä aŋä-himqä iutaŋä hui, Iquenyqä yeeqä itä, iiyqä aŋiuŋqä ätuma äukqe. Iiyqä yoqe, Mala. ");
INSERT INTO mcr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malai, känapi huisäŋiyi. Iiyqä yoqe, Mäliya. Ii Naqä Iqu-täŋä qäqiqi, Iqueä kukŋui qätä äwiyä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ii e pmetaŋga, Malai, ymisaŋä-sua näwinyä imäkätä, wäuŋuä kuapänä etaŋgi, kŋuä indqänmiŋqe. Iiŋqe, ii Jisasi Iquenyqä äwätä, “Naqä Iquki, ŋqä napi nyivämeqaŋgi, ŋqä-näunä ymisaŋä näwinyä imäkätqäŋänä. Si iiŋiŋqe, kŋuä äänä kiyqi? Si ŋqä napiŋi, tu. Ii äpätä, yätamäkqä nyiyätŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Iwä Iqu kimaŋi, tii ätukqe. “Ŋqä näueqä Malaiki, si nätmatqä kuapänäŋiŋqä kŋuä indqänätnä, haŋä-iqä ämetqäŋinyä. ");
INSERT INTO mcr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Iŋäqe nätmatqä hŋqu, huiziquau ämäwqätäunä. Mäliya nätmatqä qäyunäŋqä äwinyänä. Ye nätmatqä tä, huätä mämatnämäuqä yeŋqueä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hiunji hŋqueŋi, Jisasi Iqu hŋqäqi äpme, Goti Hanjuwä Iquenyqä tääqä ätqämanmiŋqe. Iqu tääqä ae ätqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋqu, tii ätukqe. “Naqä Iquki, Jonä iqu iqueqä wäuŋuäŋqä ämotquamiŋqä iquau näqŋqä äwimiŋqä-paŋi, ne-pqe neqä Goti Hanjuwä Iquenyqä tääqä tqeŋqe, Si mänätquayä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","I tquaŋga Jisasi Iqu, tii ätukqe. “He Goti Hanjuwä Iquenyqä tääqä ätäpiyäŋgaŋi, tii tqäpŋqä. ‘Apiquki, ämaqe, Tqä yoqe haqä yätqä äwi, pmua hitaŋgi qumbnä. Sinä miqe, äpänä. ");
INSERT INTO mcr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hiunji ique-ique, buayä nätapqaŋgnä. ");
INSERT INTO mcr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ämaqä quvqä inetqueqaŋguwä iquauŋqä, ne äwqä haŋuä imäknätuŋquetaŋi, Si nenyqä äwqä haŋuä imäknätnä, neqä suqä quvqe huätä mänamäutŋqe. Yamwiqä nemetŋqä itŋqä iuŋi, Si hiŋuinä mäquŋquä panä’ tqäpŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Iqu tiiŋä-pqä ätukqe. “Ämaqä hesaŋä hŋqu, iqueqä käyämaqä hŋque heatqäŋga äwimetä, ‘Nyämaqä iquki, ŋqä näueqä hŋqu qaŋä äpätŋqe, änyimeqaŋgi, nyi ique buayä wimqe hma etaŋgqeŋqä, si buayä hŋquaqui-hŋque dapiyä’ tuäŋqiyä. I tquaŋga, ämaqä aŋä yäpä yäŋgisa äpmamitätqä iqu kimaŋi, ‘Si wäuŋuä yäŋänäqŋqä mändapqä manä. Nyitä ŋqä ymeqä iquatä, ne qŋqaŋä ämeyätanä, hiqaqä ae äwiqueqä. Nyi ävautmä buayä mäktapqä ymqänä’ tuätŋqätanä? ");
INSERT INTO mcr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nyi tii etqänä. Iqu ‘Ŋqä nyämaqä-queqä’ kŋuä vqaŋguti, ävautä mavqä yäŋqiyä. Iŋäqe, ämaqä yäpaqäŋgisa ätqäuqä iqu, qŋqaŋä ptqä yqänä äqäyätä, ymisäŋiŋqä yatŋqä vätqätaŋgi, iqu enyqä qäyä wiŋgaŋguti, ävautä nätmatqä eeqänäŋi, iqu äwa iqaŋgutqe, äväŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Iiŋiŋqe, Nyi he etqänä. He Goti Hanjuwä Ique yatŋqä vqaŋgpqe, Iqu nätmatqä etapäŋqiyä. He qävqä ipiyi, he ämäqumuapŋqäuä. He aŋä qŋqaŋä ptqä päsqaŋgpqe, qŋqaŋi äutänäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ämaqä, Goti Hanjuwä Ique yatŋqä vqaŋgpqä iqua, nätmatqä ämapŋqäuä. Ämaqä qävqä ipiyä iqua, ämäqumuapŋqäuä. Ämaqä qŋqaŋä ptqä päsqaŋgpqä iquauŋi, Goti Hanjuwä Iqu qŋqaŋä äwuteyäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ii tiinjqä. Heyaqä ymeqetaŋä hŋqu, hämapäkäŋqä tqaŋgutqe, kaniqu qämakä quvqä momuayqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iqu yŋŋä quiŋqä tqaŋgutqe, kaniqu qänjuakäta momuayqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kaniquenyä, he suqä quvqä imäkqä-quenä etaŋgqä-qe, he nätmatqä äŋgui ämepu, hiqä ymeqä du inä ävätqäŋuwiqä. Iiŋqe he näqŋqä tiiŋä hipŋqäuä. Hiqä Hiniqu, Qäukuä Haqä Yätuŋä Iqu, ämaqä ‘Tqä Dŋä Äŋguä Ique dapiyä’ ätuäpu, yatŋqä vqaŋgpqä iquauŋi, Iqu äväŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hea hŋqueŋi dŋä quvqe, ämaqä hŋqueä äwqä imä ämnä, ique kukŋuä matqäŋqä imäkätqätaŋgi, Jisasi Iqu “Huätä uvä” ätukqe. Dŋä quvqä iqu ae ävämeqaŋga, ämaqä iqu kukŋuä tqaŋgi, ämaqe yäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Iiŋä ipiyitaŋi, ämaqä hŋqua tii ätkuwi. “Belsäpulä, dŋä quvqä iquauqä naqä iqu, yäŋänäqŋqä vqaŋgi, Iqu dŋä quvqä iquau huätä ändowatätqänä.” ");
INSERT INTO mcr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Itaŋga huiziqua, yamwiqä äväpu tii ätukuwi. “Si wäuŋuä hui imäkiyä. Ne Sinyqä, ‘Iqu Goti Iqueqä Wäuŋuä Imäkqä-queqä’ kŋuä neyätŋqänänyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisasi Iqu iquauqä kŋuä iuŋi, näqŋqä eä tii ätukqe. “Ämaqä aŋä-himqä hŋquesaŋä iqua, iwäsänäpu mäkä huŋgaŋgpqe, aŋä-himqä iqueŋi, qui imäknäŋqiyä. Itaŋga ämaqä hŋqueqä ymeqä iqua, iwäsänäpu mäkä huŋgaŋgpqe, iqua-pqe qui inä imäkmbŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iwä Setänä Goti Hanjuwä Iqutä mäkä-huŋqä iqu, iqueqä ämaqä iqua iwäsänäpu mäkä humbqe, iqua äänä pmapnuwäŋqäwä? He Nyinyqä tii ätquwiuä. ‘Belsäpulä iqu yäŋänäqŋqä vqaŋgi, dŋä quvqe huätä ändowatätqänä.’ Iiŋqe, Nyi yatŋqä eyqänä. ");
INSERT INTO mcr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","He Nyinyqe, ‘Iqu Belsäpulä iqueqä yäŋänäqŋqeta, dŋä quvqä iquau huätä ändowatätŋqeqä’ qäyunä tqaŋgpqe, hiqä ämaqä iqua, dŋä quvqä huätä ändowatätqäŋuwi, yäŋänäqŋqä tqueqeta, ändowatätqäŋuwäwä? Hiqä ämaqä iiŋä iqua, ämetquapŋqeqä. Heyaqä kukŋuä iiŋi, ii qäyunä hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","I etaŋgqä-qe, Goti Hanjuwä Iqu yäŋänäqŋqä dapqaŋgi, Nyi dŋä quvqä iquau huätä dowatqaŋgmdqe, he näqŋqä tiiŋä mapŋqeqä. Goti Hanjuwä Iqunä miqe, ae emeqeqä.” ");
INSERT INTO mcr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ämaqä yäŋänäqŋqä hŋqu, nätmatqä mäkä iqä-sua a äqätä, iqueqä aŋiu ämitqätaŋgutqe, iqueqä nätmatqä eeqänäŋi, äŋguänä witäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Itaŋgi qänakŋi, ämaqä aaŋä yäŋänäqŋqänäŋä hŋqu äpäqe, ämaqä iqueŋi ämäwqätäutä, iqueqä yäŋänäqŋqä isuatä e äpmamitätqä-qe, iqueqä nätmatqä eeqänäŋi ämotawaŋi, ämaqä hŋquau-mända väŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ämaqä hŋqu wäuŋuä yätamäkqä manyqä imitätqe, iqu Nyaqä himä-wiuŋqä-queqä. Qokä-apäkä aquvä qiyqeŋqä yätamäkqä manyqä imitätqä iqu, ämaqä huätä im-imä ändowatäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Dŋä quvqä hŋqu ämaqä hŋque ävämaŋi, aŋä yeŋuä duŋqä äwäqe, iqu aŋä hapä pmeqä iuŋqä qävqä ikiquäŋqiyä. Itaŋga hŋque mämoqumueqä iäqe, ‘Nyi aŋä hiŋuiqänä ävämakqä duŋqä, aŋgu umqänä’ tnäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","I ätnäqe, iqu äwäqe, aŋä iqueŋi siyä äpipu äŋguä imäkepqä qunäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iiŋä äqunäqe, iqu äwätä dŋä quvqä 7 yätmeŋqiyä. Dŋä iquauqä quvqe, dŋä kiŋganäŋä iqueqä quvqe, ämäwqätäuŋqiyä. Iquau yätmetä, qu aŋä yäpä yäŋgisa äpaquväpu pmapŋqäuä. Ämaqä iqu hiŋuiqänäŋi quvqä äpmamitätqe, täŋgaŋi aaŋä quvqänäŋä pmeŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisasi Iqu e tuätqätaŋga, apäkä hui, qokä-apäkä iuqä awä iqisaŋi, maŋä tiiŋä ätukqe. “Apäkä, Si äkinyuätä aŋuä äktapkqe, ii aquvänä yäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","I etaŋgi Iqu kimaŋi, tii ätukqe. “Si kukŋuä naqä-qakuä ätätŋä qayuä. Iŋäqe ne iiŋi, matqä yaŋqunä. Tiiŋä tatuŋqueqä. ‘Qokä-apäkä, Goti Hanjuwä Iqueqä kukŋuä qätä äwiyäpu, qänaknä itqäŋuwä iqua, qu aquvänä iqäpŋqäuä’ tatuŋqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Qokä-apäkä kuapänä timäuqaŋguwäŋga, Jisasi Iqu tiiŋä ätukqe. “Qokä-apäkä täŋga äpmeŋuwi, quvqä-quaeqä. Iqua, ‘Ne Sinyqä näqŋqä metuŋquä diŋqe, wäuŋuä hui imäkiyä’ ändquwä-qe, Nyi iiŋi mimäkqä imqänä. Iqua näqŋqä mapŋqä diŋqe, hiŋuä-tqä Jona iqu qeyqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ii tiinjqä. Ämaqä hiŋuiqänä, aŋä-himqä Ninipe äpmamiŋuwä iqua, Jona ique hiŋuä äqunäpu, näqŋqä ämakuwä-paŋä iiŋi, qokä-apäkä täŋga äpmeŋuwä iqua, Ämaqeuqä Ymeqä Ekqä Ique hiŋuä äqunäpu, näqŋqä asänäŋä iiŋä hipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hiŋuiqänäŋi, apäkä, qua hituŋuä nämä pmeqä ämiqä naqä ii, Solomonä iqu iqueqä näqŋqeŋqä awä tqaŋgi qätä wiyätŋqä äpkqeqä. Iŋäqe täŋgaŋi, Ämaqä, Solomonä ique ämäwqätäuŋqä Iqu, täqi qäyä äpmetaŋgi, ämaqe, Ique qätä mäwiyqä itqäŋuwi. Iiŋiŋqe hiunji Goti Hanjuwä Iqu qokä-apäkä iwäsäutqäŋgaŋi, apäkä naqä iiŋi ävautä, ämaqä täŋga äpmeŋuwä iquauqä suqä quvqeŋqä, awä täniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Asä iiŋi, ämaqä Ninipe äpmamiŋuwä iqua, Jona iqueqä kukŋuä qätä äwipiyi, iquauqä kŋuä äkunmäkŋguwiqä. Iŋäqe täŋgaŋi, Ämaqä Jona ique ämäwqätäuŋqä Iqu, täqi qäyä äpmetaŋgi, ämaqe, iquauqä kŋuä makunmäkŋqä iquwi. Iiŋiŋqe, hiunji Goti Hanjuwä Iqu qokä-apäkä iwäsäutqäŋgaŋi, ämaqä Ninipe äpmamiŋuwä iqua ävaupu, ämaqä täŋga äpmeŋuwä iquauqä suqä quvqeŋqä awä tpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","I ätuäqe, tiiŋä-pqä ätukqe. “Ämaqe, hiqi-tä ämäsäpiyi, qu aŋä yäpä imä-qe, ä häkä yäpä imŋä-qe, matqäteqä ipŋqäuä. Ämäsäpiyi, qu kiqä ätqäuqä ätnäŋä iqi tqätepŋqäuä. Ämaqä aŋä yäpä iŋgisa äyappiyä iqua, hiŋuä qumbŋqä diŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tqä hiŋuä iqu, huiwä iqueqä hiqi-tä eŋqä-paŋiqä. Tqä hiŋui äŋguä äqännä, si ämaqe yätamäkqä wiyquki hitaŋgutqe, tqä huiwä eeqänäŋä imŋi, we äŋguä äkunänä. Iŋäqe, tqä hiŋui quvqä äqännä yätamäkqä mävquki hitaŋgutqe, tqä huiwi eeqänäŋä imŋi hea äwinä. ");
INSERT INTO mcr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Itaŋga si äŋguänä miŋgaŋginyä, we-huŋqä si-täŋä yäpä imä äyänäŋqä di, hea mäwiqä yätŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iŋi tiinjqä. Tqä huiwä äwqä eeqänäŋi wenyä-huŋqä eä, hea mäwiqä etaŋgutqe, iŋi tqä huiwä eeqänäŋi we äunä, hiqi-tä eŋqä-pa yänätäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisasi Iqu kukŋuä qäpu tqaŋga, Parisi hŋqu, Iqu äpätä buayä anä nyiyäŋqä yatŋqä äwikqe. Itaŋga Jisasi Iqu aŋä yäpä iŋgisa äpaquväqe, buayä nätŋqä qua iqi eqäkŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisasi Iqu buayä nätŋqä itäqäŋgaŋi, eqä akiyä iŋqä du asŋä ganä maqŋqä iqaŋgi äqunäqe, Parisi iqu kŋuä kuapänä indqänmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iŋgaŋi Naqä Iqu tii ätukqe. “He Parisi iquenyä, eqä-häkitä hevqetä haqäŋgisaŋi, asŋä äŋguänä äqäyäpiyä-qe, hiqä yäpä iŋgisaŋi, quwä-meqetä suqä quvqä huitaŋä-huitaŋitä maŋguä äyä enyänä. ");
INSERT INTO mcr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","He kŋuä qäyunäŋi, mindqäŋqä-quenjqä. Ämaqeqä huiwä yäpaqäŋgisa imäkkqä Iqu, yäpäŋgisaŋä-pqe mimäkqä ikqätanä? Iqu inä imäkkqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","I etaŋgi, nätmatqä buayä hevqä yäpäŋgisaŋi, ämaqä äwa itqätaŋguwä iquau yätamäkqä inä wipŋqeqä. He e imäkqaŋgpqe, hiqä nätmatqä eeqänäŋi, Goti Hanjuwä Iqueqä hiŋuä iqiŋi äŋguänäŋä witäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“He Parisi iquenyä, haŋä-iqe tiiŋiŋqä emeŋqiyä. Iwuneqätä, kuämiqätä, nätmatqä isuaqu-täŋä asänäŋä huizitä ämepu, iwäsäupu 10 imäkäpu, hŋqu Goti Hanjuwä Ique ävätqäŋuwiqä. I etaŋgi suqä ämaqä qäyunä itqueqetä, Goti Hanjuwä Iquenyqä hiŋqetäŋi, he tuwä wiyquenjqä. Äŋguänäŋi, tiiŋiqä. Suqä he hiqä nätmatqä iwäsäupu, hŋqu Goti Ique vqe mävquatämäuqä ipu, suqä he tuwä äwiyätqäŋuwä iquaquiŋä-pqe qänaknä iqaŋgpqe, ii äŋguä wäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“He Parisi iquenyä, haŋä-iqe tiiŋiŋqä emeŋqiyä. Aŋä aquväqŋqä iuŋi, zä-hawä äŋguänäŋä iqinyä pmapŋqä kiiŋä hiŋquenjqä. Ga, ququawä aquväqŋqä iu pmetaŋguwäŋga, ämaqe, ‘hiunjiŋganjqä’ etpŋqä kiiŋä hiŋquenjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ga haŋä-iqe tiiŋiŋqä emeŋqiyä. He ämaqä qua maqŋqä äptepqä eŋqä-paŋuenjqä. Ämaqä qua maqŋqä äptepqe, ämaqä huiziqua maqŋqä epu qaŋä haqeqi äwäpiyitaŋi, Goti Iqueqä hiŋuä iqiŋi kiyä mätqä eäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iŋgaŋi kukŋuä-suqeŋqä näqŋqä hŋqu, kima ävätä, “Näqŋqä-vqä Iquki, Si kukŋuä iiŋä ätätqäŋäŋgaŋi, ne-pqä qäsä qui inemäkätqäŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iqu e tquaŋga, Jisasi Iqu tii ätukqe. “Kukŋuä-suqeŋqä näqŋqä iquenyä, haŋä-iqe he-pqe emeŋqiyä. Ii tiinjqä. He ämaqeu, yquayä haŋä änä mämeqäŋqä ävätqäŋuwenjqä. Iiŋä etaŋgi, he qu yätamäkqä wipŋqä diŋqe, hipa hui mävqä itqäŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mä haŋä-iqe tiiŋiŋqä emeŋqiyä. Hiŋuä-tqä, hiqä tawäka qäŋganä äpäkkuwi, he täŋgaŋi quwqä qua äptekuwä iuŋi, äŋguänä imäkätqäŋuwenjqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","He suqä ii imäkäpiyäŋgaŋi, tawäkauqä suqeŋqä ‘äŋguiqä’ ätätqäŋuwiqä. Ii tiinjqä. Hiŋuä-tqä, tawäka äpäkkuwä iquauŋqe, he quwqä huiwä pŋqä wiqä aŋi imäkätqäŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iŋi Goti Hanjuwä Iqu kŋuä jänäŋä äŋguänäŋä indqänätä tii ätkqeqä. ‘Hiŋuä-tqä iquautä, ämaqä Nyi wäuŋuäŋqä ändowatqä iquautä, ämaqä iquauŋqä ändowatmniqeqä. Itaŋga iqua hŋquau äpäsäpu, huizi iquau quvqä itquapnuwiqä’ ätkqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","I etaŋgi, Goti Hanjuwä Iqu qua tä änyä imäkqaŋga, ämaqä, hiŋuä-tqä iquau pizqä äpäkka äpmiŋuwä iquauqä suqä quvqetaŋä kimaŋi, ämaqä täŋga äpmeŋuwä iqua-mända mapŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hiŋuä-tqä iquauŋi, qu Epo iquesa äpäsipäqäkaŋi, yäpaki Sakätiyasi ique äpäsätqutukuwi. Sakätiyasi ique äpäkkuwi, Goti Hanjuwä Iqueqä aŋä iuŋi, hiqäva-imäkqä ttawä iutä, hiqŋqä Goti Hanjuwä Iqunä pmeqä iutä awä iqi äpäkkuwi. Nyi heŋi naqä-qakuä etqänä. Suqä quvqä eeqänäŋä iiŋqä kimaŋä haŋä-iqe, qokä-apäkä täŋga äpmeŋuwi mapŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Itaŋga, “Kukŋuä-suqeŋqä näqŋqä iquenä, haŋä-iqe tiiŋäŋqä-pqä inä emeŋqiyä” ätuätä, kukŋuä ktqä tiiŋä ätukqe. “Goti Hanjuwä Iquenyqä näqŋqä meqä aŋä hänaqä iutaŋä qŋqaŋä hutäuqe, he ae ämakuwiqä. Hiqä-hiuä näqŋqä mapŋqe, aŋä yäpä yäŋgisa mäpeyqä itqäŋuwiqä. I etaŋgi, qokä-apäkä yäŋgisa äpeyäpu näqŋqä menätpu iqaŋguwä iquauŋqe, he hänaqä qŋqaŋä äyätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iŋgaŋi Jisasi Iqu iqisaŋi ävämeqaŋga, ämaqä kukŋuä-suqeŋqä näqŋqä iquatä, Parisi iquatä äwqä quvqä wiŋgaŋga, qu nätmatqä huitaŋä-huitaŋä iuŋqä yatŋqä ävqa-ävqa äumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iqua täŋäŋqä guä äquväutqäŋuwä-pa, Iqu kukŋuä kimaŋi qäyunä mätquaŋgutqe, iqua Ique guä kiqiyäupŋqä ätuma wanä-tpu, iiŋqä ätumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Qokä-apäkä kuapänä ätimäupu, ätqäupu, quwqä yukä duŋi qo ktäupäumä änymiŋuwi. Iŋgaŋi Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, kukŋuä awä tiiŋi ganä ätukqe. “Parisi iquauä nätmatqä änyuämäuqä iiŋqe, he wa wipiyä. Quwqä suqä, wopqä ipu kukŋuinä tqeŋqä etqänä. ");
INSERT INTO mcr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nätmatqä eeqänäŋä huäqä äutnmitätqe, ätnäŋä iqi timäuŋqiyä. Itaŋga nätmatqä eeqänäŋä zä äwämitätqe, ämaqä iqua näqŋqä hipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iŋi, he kukŋuä eeqänäŋi, hiawiqä imda ätmipqe, ämaqe, hiunjiŋganä qätä wipŋqäuä. He aŋä hiqŋqä imda hiyäkakä ätmipqe, qu aŋä haqä yätqä ätqäupu, awä tpŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ŋqä näueqä iquenyä, ‘He ämaqä huiwä dunä päsqä iquauŋqä, zä miqä pambiyä’ sä etqänä. Iqua qänakndaŋi, nätmatqä hui mimäkqä ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","He zä tquenyqä ipŋqeŋqe, Nyi ämetquamqeqä. Goti Hanjuwä Iqu, ämaqä äpäsätäqäŋgaŋi, Iqu yäŋänäqŋqä-täŋu eä, ique tä hea ique-ique äsäŋqä du tnämäuŋqiyä. Auqä. Nyi he etqänä. ‘He ze, Goti Hanjuwä Iquenyqänä ipŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","He näqŋqeqä. Ämaqe, qu yŋŋä wäŋqä hipa hŋgiŋi eeqä hnjuauŋqe, mbqä wäŋqä hnjuaqu ipŋqäuä. Iiŋä etaŋgi, Goti Hanjuwä Iqu yŋŋä hmbinyqe, huäqä äumäkätä, kŋuä huätä mävquatämäuqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tiiŋä-pqe inänji. Goti Hanjuwä Iqu, hiyaqä dä nyuäŋä iuŋi, a ae ätäuqeqä. Iutaŋi, he zä miqä pambiyä. Goti Hanjuwä Iqu yŋŋä kuapänä isuauŋqe, huäqä wäŋqäpu äwunänä. Henyqe, huäqä aaŋä kuapänä äwunänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nyi tiiŋä etqänä. Ämaqä hŋqu, zä miqä itä, huizi duŋi, ‘Nyi Jisasi Iqueqä-qunjqä’ tqaŋgutqe, Ämaqeuqä Ymeqä Ekqä Iqu eŋätqä iquauŋi, ‘Iqu Nyaqeqä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iŋäqe ämaqä hŋqu, zä itä, ‘Nyi Jisasi Iqueqä-qunä manä’ tqaŋgutqe, Ämaqeuqä Ymeqä Ekqä Iqu eŋätqä iquauŋi, ‘Iqu Nyaqä hmanjqä’ tuäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ämaqä hŋqu, Ämaqeuqä Ymeqä Ekqä Iquenyqä kukŋuä quvqä tqaŋgutqe, Goti Hanjuwä Iqu iqueqä quvqä iiŋi, huätä mamäuŋqiyä. Iŋäqe ämaqä hŋqu, Dŋä Äŋguä Iquenyqä kukŋuä ququvqä di tqaŋgutqe, Goti Hanjuwä Iqu iqueqä quvqä iiŋi, huätä mämamäuqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ämaqä hŋqua he aŋä aquväqŋqeu miqä iquauŋqä-qe, ämaqä miqä naqä iquauŋqä-qe, ämaqä yoqä-täŋä iquauŋqä-qe, etma uwqaŋgpqe, ‘Ne kukŋuä kimaŋi, äki tuatuŋquäwä?’ kŋuä indqänäpu, zä miqä pa iqäpnä. ");
INSERT INTO mcr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dŋä Äŋguä Iqu kukŋuä tupŋqe, iŋganä ämetqueniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iŋgaŋi ämaqä hŋqu, ämaqä awä iqisa ämävauqe, Jisasi Iqueŋi, “Näqŋqä-vqä Iquki, ŋqä apiqu ae äpäkoŋgqeqä. Nyi Si ŋqä tasipeque, yeqä apiqueqä nätmatqe yewäsäutŋqä, tutŋqä änyiŋgiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","I tquaŋga Jisasi Iqu, “Ämaqä iquki, qe äqewäsäutmä, qeyaqä nätmatqe iwäsäumqe, tqu pmuatenjikqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iqu iiŋä ätuäqe, qokä-apäkä iuŋi tii ätukqe. “Nätmatqä eeqänäŋiŋqä hiŋuä aowä mäquŋquä ipŋqä diŋqe, he wa wipiyä. Ämaqä hŋqu yquayä kuapä-täŋu emitätqe, iqueqä yquayi häŋä-pmeqä mävqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","E ätuäqe, Iqu kukŋuä ktqe, tiiŋä ätukqe. “Ämaqä yquayä kuapä-täŋä hŋqueqä wäuŋuä iuŋi, ymisaŋä kuapänä witäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iŋgaŋi iqu, ‘Nyi aŋä naqä hma eŋqe, ymisaŋä pŋqä emqe, äänä imäkmqäwä?’ kŋuä indqäŋguäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iiŋä itä, tii tnäŋqiyä. ‘Nyi tiiŋä imäkmqänä. Ŋqä buayä pŋqä maeqä aŋä äpnakmi, aŋä naqänäŋä imäkätmä, ymisaŋä eeqänäŋi aquvä äqiyätmä, aŋä iuŋi pŋqä maemqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nyi ŋqä-näuä tiiŋä äyä ätŋgänä. “Nyi yquayä kuapä-täŋunjqä, quväukuä kuapänäŋä iuŋqäuä. Täŋgaŋi nyi hapä pmetmqeqä. Buayä eqä änätmä, yeeqä itmä pmetmqeqä” ätŋgänä,’ täŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iiŋä iqaŋgutqe, Goti Hanjuwä Iqu, ‘Si ämaqä qämä-qämänjqukiyqä’ tuäŋqiyä. ‘Täŋga hea tqueŋi, äpäkondŋqinyä. Itaŋga nätmatqä eeqänäŋä näwenyä imäkätqäŋä iqu, tqu maqutnätŋqäwä?’ tuäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisasi Iqu kukŋuä ktqä iiŋä ätuäqe, tii-pqä inä ätukqe. “Ämaqä hŋqu nätmatqä aquvä i äqäka äwätä, Goti Hanjuwä Iqueqe mävqä iqaŋgutqe, kukŋuä ktqä du ätimäukqä-paŋä iiŋi, äwimeŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, Iqu tii ätukqe. “Iiŋiŋqe, Nyi he tiiŋä etqänä. He ‘Ymisaŋä squä natuŋquäwä?’ ätäpu, häŋä pmapŋqä diŋqä kŋuä kuapänä mindqäŋqä pambiyä. ‘Ne gque, squä ipnatuŋquäwä?’ ätäpu, hiqä huiwiuŋqä kŋuä kuapänä mindqäŋqä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Häŋä-pmeqe, buayiŋqänä pmeqä manä. Huiwi nätmatqä gquä iuŋqänä manä. ");
INSERT INTO mcr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","He yŋŋä iquauŋqä kŋuä indqämbiyä. Qu ymisaŋä vowä mamäuqä ipu, ymisaŋä maptqä ipŋqäuä. Itaŋga qu aŋä ymisaŋä pŋqä hipŋqe, aŋi hmanjqä. Iŋäqe Goti Hanjuwä Iqu iquauqä ymisaŋi äväŋqiyä. Yŋŋä iquaŋqe, Goti Hanjuwä Iqu huäqä wäŋqäpu äwunänä. Henyqe, Iqu huäqä kuapänä äwunänä. ");
INSERT INTO mcr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Itaŋga ämaqä hesaŋä hŋqu, häŋä-pmeqeŋqä kŋuä kuapänä indqänätqe, iqueqä häŋä-pmeqe haqä nänä imäkäwatätŋqä di, hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","He nätmatqä wäŋqä iiŋä ipu, änä mimäkqä ipiyitaŋi, nätmatqä huiziŋqänäŋi, kŋuä kuapänä suŋqä indqänätqäŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“I indqänäpiyi, he qätaqä hutqeŋqä, ‘Äänä ätätätiyä?’ tpu, kŋuä indqämbiyä. Qätaqä isua, wäuŋuä ipu gquä mimäkäyäuqä ipŋqäuä. Itaŋgi Nyi he etqänä. Solomonä, ämaqä naqä hiŋuiqä äpmamiŋqä iqu, iqu gquä häŋä qeqätqä ii imäknmiŋqe, qätaqä hutqe, iqueŋi ämäwqätäunä. ");
INSERT INTO mcr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Täŋgaŋi qätaqe, yqänä ätqäuqä-qe, awiŋgaŋi ämaqä ätäväpu, tä du tnämäuqäpŋqäuä. Iiŋä etaŋgi, Goti Hanjuwä Iqu imäkqaŋgi, qätaqe hutqä äŋguänäŋä ätänä. Iiŋiŋqe, ämaqä quuvqä wäŋqäpu eqiyätqäŋuwä iquenyä, he näqŋqä tiiŋä hipŋqeqä. ‘Goti Hanjuwä Iqu ne-pqe gquä äneptätqänä’. ");
INSERT INTO mcr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Itaŋga ‘Ne buayä eqä squä natuŋquäwä’ kŋuä indqänäpu, qundqändqä miqä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ämaqä eeqänäŋä im-imä äpmeŋuwi, qu quuvqä maeqiyqä da, nätmatqä iu mapŋqeŋqä kŋuä indqänätqäŋuwiqä. I etaŋgi, he nätmatqä iiŋiŋqä äwa itqäŋuwiŋqe, hiqä Heniqu näqŋqä eänä. ");
INSERT INTO mcr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Itaŋi he Goti Hanjuwä Iqunä meyqeuŋqä qävqä ipŋqeqä. Iŋgaŋi Iqu nätmatqä iiŋä-pqe etapäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Iqu tiipqä ätukqe. “Sipsipqä iquenyä, he zä miqä ipŋqe. Hiqä Hiniqu, aquvänä itä Iqueqä-kiuänä miqe etapätŋqä, ae ätkqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nätmatqä he ämeŋuwi, eeqänäŋä mbqäŋqä imäkäpu, mbqä ämapiyi, ämaqä äwa itqäŋuwä iquau wipŋqeqä. Itaŋga qua täuŋi, he nätmatqä qui imäkŋqä di aquvä maqiyqä ipŋqe. Nätmatqä eeqänäŋi aquvi, qäukuä haqä yätuŋi qäpŋqeqä. Yäŋiŋi, nätmatqä eeqänäŋi qui mimäkŋqä itä, ämaqä quwä mämeqä ipu, imätaŋuä maquvqä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","He iqiŋi aquvä qäpŋqe, tiiŋä hitaŋgiyi. Ämaqe, aŋä quwqä nätmatqä äŋguänäŋä pŋqä witäŋgqä iuŋqänä wiŋguäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tiipqä inänji. “Hiqä wäuŋuä iqä gquä ipnäpu, hiqi-tä ämäsäupu, näwenyä e pmapiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tiiŋä eŋqä-paŋi. Ämaqä naqä hŋqu, apäkä ämetä ymisaŋä naqänäŋä iuta äpätŋqä iqaŋgi, iqueqä ämaqä iqua, iquenyqä hiŋuä äqumbu pmepnä. Iwä iqu äpätä, qŋqaŋä ptqä qäyqaŋgaŋi, iqua qŋqaŋä maqänä wätepŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ämaqä naqä iiŋä iqu äpäqe, iqua hiqaqä mawiqä äyä etaŋgä quŋgaŋga, iqua aquvänä ipŋqäuä. Nyi naqä-qakuänä etqänä. Ämaqä naqä iqu, gquä wäuŋuä imäkätŋqä näwe ipnätä, ‘He buayä bŋqä quamä pmapiyä’ ätuätä, buayä äma äpätä väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ämaqä naqä iiŋä iqu, heatqä quaesqäŋga äpätqä, ä zä vätŋqä qäqiqiŋiŋga äpätqä-qe, iqua hiqaqä mäwiqä etaŋgpi quŋgaŋga, iqua aquvänä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Itaŋga he tiiŋä-pqeŋqä näqŋqä inä mapiyä. Ämaqä aŋä-täŋä hŋqu, ‘Quwä-meqä hŋqu, hea iŋga ti päŋqiyä-qe’ näqŋqä eä äpmamitätqe, iqu quwä-meqä iqueŋi, iqueqä aŋä qäyä pänasqiyätä yäpä yäŋgisa päyätŋqe, hiŋuinä mäquŋquä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iiŋiŋqe, he-pqe näwinyä imäkmbu pmapiyä! Hea hŋqueŋi, he Ämaqeuqä Ymeqä Ekqä Iquenyqe, ‘Täŋga mapqä yäŋqiyä’ kŋuä indqänätqätaŋguwäŋgaŋi, Iqu äpäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitä iqu, kimaŋi, “Naqä Iquki, Si kukŋuä ktqä iiŋi, nenyä änatnyä ä, ämaqä eeqänäŋqä änatnyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","I tquaŋga, Naqä Iqu tii ätukqe. “Ämaqä wäuŋuä miqä kŋuä äŋguä ämetä, kiqä wäuŋui äŋguä imäkqä iquenyqe, awä etmqe. Ämaqä naqä iqu ämaqä iiŋä iqueŋi, iqueqä wäuŋuä-wiyqä iquau ämitä, ymisaŋä hea qayunäŋäŋga väniqä diŋqä atäuŋuä väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Naqä Iqu aŋgi äpäqe, iqueqä wäuŋuä imitätqä di hiŋuä quŋgaŋgaŋi, iqu aquvänä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nyi naqä-qakuänä etqänä. Ämaqä naqä iqu, iqueqä nätmatqä eeqänäŋi mitŋqeŋqe, iqueŋi atäuŋuä väŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","I etaŋgqä-qe, wäuŋuä miqä tqu, ‘Nyaqä naqä iqu maqänä mapqä yäŋqiyä’ kŋuä indqänätä, qokä-apäkä wäuŋuä-wiyqä huizi iquau äpäsätä, buayätä eqätä änätä, hiqiiyqä imitätqe, hea hŋqueŋi, iqu maqŋqä etaŋgaŋi, iqueqä ämaqä naqä iqu aŋgi päŋqiyä. Iqu quvqä imitätqä äqunäqe, iqueŋi mŋä ätävätä, kukŋuä qätä mawiyqä huiziqua pmetaŋguwä iuŋqä huätä dowatäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Wäuŋuä-wiyqä, iqueqä naqä iqueqä äwiŋqeŋqä näqŋqä qäyä eäqä-qe, nätmatqä näwenyä mimäkqä itä, naqä iqueqä äwiŋqeuŋi qänaknä miqä imitätqe, ämaqä naqä iqu yäŋänäqŋqä päsäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Itaŋga wäuŋuä-wiyqä huizi, naqä iqueä äwiŋqä duŋqä maqŋqä eä, suqä äŋguä miqä imitätqe, naqä iqu wäŋqäpu päsäniqeqä. Ämaqä nätmatqä kuapänä huizi iquauqä hipa iuta ämamipqä iqua, kimaŋi kuapänä wipnuwiqä. Qokä-apäki, ämaqä hŋque nätmatqä kuapänä äwimitpqe, iqu quŋi, kima kuapänä väniŋqä tupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nyi qua täuŋi, tä hänaqä ikävemqä äpqäqe. Tä iiŋi, hänaqä ae äsqä-säpi, Nyi aquvänä iqämiŋgä. ");
INSERT INTO mcr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nyi asŋä huitaŋä hui mamqänä. Asŋä iiŋi, mämeqä änyä etaŋgqeŋqe, haŋä änyiyqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","He Nyi äpqeŋqe, ‘Iqu ne ämaqä qua täu äpmeŋqu iqune, äwqä haŋuä nemäkätŋqä äpqeqä’ kŋuä eyqiyä? Oeyä. Nyi he etqänä. Ämaqe, Nyinyqä iwäsämbŋqä äpqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Täŋgaŋqätä, qänakŋqätä, ämaqä hipa hŋgiŋä hŋqua aŋä hŋqueu äpmamipqe, Ŋyinyqä iwäsänäpu, hŋquaqui-hŋqueŋä iqua, hŋquaquiŋä iquaqui äkasuwä tupnuwiqä. Hŋquaquŋä iquaqu, hŋquaqui-hŋqueŋä iquau äkasuwä suinyiyiqä. ");
INSERT INTO mcr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iqua Nyinyqä tiiŋä iwäsämbnuwi. Kaniqutä ymeqä qokä iqutä, äkasuwä tninyiyi, känaisä kiqä meqisä, äkasuwä tninyiyi, itaŋga ämaqä hŋqueqä känaisä, iqueqä apäkisä äkasuwä tninyiyiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iŋgaŋi, Jisasi Iqu qokä-apäkä kuapänäŋä iuŋi, tiiŋä ätukqe. “He qaquvqä, mäptqä quveqäqä mäŋgisa timäuqaŋgi, hiŋuä äqumbiyäŋgaŋi, ‘piyä qiyätŋqeqä’ ätätqäŋäuä. Ga, asä iiŋi ätimäutqänä. ");
INSERT INTO mcr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","He yuŋuä, ämaqä mäpmeqä mäŋgisa yapqaŋgi, hiŋuä äqumbiyäŋgaŋi, ‘mäptqä tnäŋä timäutŋqeqä’ ätätqäŋäuä. Ga, asä iiŋi ätimäutqänä. ");
INSERT INTO mcr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","He wopqä ipu, kukŋuinä tqä-quenjqä. He nätmatqä qäukuä haqä yätutatä, qua täutatä ätimäuqäqeŋqä, äŋguänä iwäsäutqäŋuwiqä. Nätmatqä täŋga ätimäuqäqä täŋqe, he miwäsäuqä iquwi, äänä etaŋgikä? ");
INSERT INTO mcr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hiqä-hiuänä, ‘suqä äŋgui äsqutiyä’ tpu, miwäsäuqä iquwi, ii suŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ämaqä hŋqu, si mändi äkikittqiyätä, guä kkiqäyäutŋqä, hänaqä awä iqi äwäsiyäŋgaŋi, si ämaqä iqutä kukŋuä jänä imäkiyŋqä diŋqä yamwiqä isŋqeqä. Ii, haŋä-iqä tiiŋi, mäkimeqä diŋqeyi. Iqu ämaqä jänä imäkqä iquenyqä äktäma uwqaŋga, jänä imäkqä iqu ämayukä-imaŋqä hŋqueqä hipaeu kivqaŋguti, iqu guä pmuateqä aŋä du pmuatekiyqä iŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nyi si kukŋui tiiŋä äktqänä. Mbqä qu atäuŋuä kipqä iqueŋi, eeqänä päsesŋqä diŋqe, guä pmeqä aŋiuŋi, mävquatämäuqä isŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iŋgaŋi ämaqä iqi äpmamiŋuwä hŋqua, Jisasi Iqueŋi, ämaqä Galili pmeqä hŋquauŋqä ätukuwi. Galili pmeqä iiŋä iqua, Goti Hanjuwä Iquenyqä hiqäva imäkätqätaŋguwäŋga, ämaqä naqä Pailoti iqu, “He iquauŋi pizqä päkpiyä” tquaŋga, qu iquau äpäsqaŋguwäŋga, iquauqä häŋeqetä, hiqäva iutaŋitä, naqä-huinyä imäkŋgqeŋqä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisasi Iqu kimaŋi tii ätukqe. “Nätmatqä quvqä Galili pmeqä iquau e äwimakqetaŋi, he ‘Ämaqä e äpäkoŋguwä iquauqä suqä quvqe, Galili pmeqä huiziquauqä suqeuŋi ämäwqätäunä’ kŋuä indqänätqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oeyä, kŋuä iiŋi mämeqä pambiyä. Nyi etqänä. He heqä kŋuä makunmäkŋqä ipu, suqä quvqä huätä mävquatämäuqaŋgpqe, hepqe qui inä imäkmbŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tiiŋä-pqe. Ämaqä 18 iquauŋi, hiŋuiqänäŋi Siloamä iuŋi, aŋä quäuqä iqu äpisäutä, ämaqä iu äpäkkqä iquauŋqe, he ‘Ämaqä e äpäkoŋguwä iquauqä suqä quvqe, ämaqä Jerusälemä iu iŋga äpmamiŋuwä huiziquauqe, ämäwqätäunä’ kŋuä indqänätqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oeyqä. Nyi he etqänä. Heqä kŋuä makunmäkŋqä ipu, suqä quvqä huätä mävquatämäuqaŋgpqe, he-pqe qui inä imäkmbŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iŋgaŋi Iqu kukŋuä ktqä tiiŋä hŋqu ätukqe. “Ämaqä hŋqu, zä-eaqä hŋqu, iqueqä wainqä wäuŋuä iqisa tqäutaŋgi, häukuä wiqäŋqä-tä qävqä äpätqe, aaŋqä qunäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","I äqunäqe, ämaqä wäuŋuä iu miqä iqueŋi, tiiŋä tuäniqe. ‘Quväukuä hŋquaqui-hŋqueŋä iquauŋi, nyi äpkqe, häukuä mäwitaŋgi aaŋqä äquŋgqeqä. Zä tqu, qua aowä hiŋginä ämetŋqä di, suŋqäwä? Si zä iqueŋi huätä tävä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","I tquaŋga wäuŋuä-wiyqä iqu tii tuäniqe. ‘Naqä Iquki, qäyä eänä. Quväukuä hŋqunä qäyä äpäwänä. Nyi kiqä hukä iqi qua mŋä yasäqi äuätmä, yaqueqä zä äkäka qakuä iqi qäyä emä. ");
INSERT INTO mcr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Qänakndaŋi häukuä winiqätiyä, mäwiqä yaniqätiyä? Häukuä mäwiqaŋgutqe, si huätä iŋga täumäuqätŋqä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sämbatqä hiunji hapä pmeqä hŋqueŋi, Jisasi Iqu qokä-apäkä iquau, aŋä aquväqŋqä hŋqueu näqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iŋgaŋi äpäkä dŋä quvqä-täŋä hui äpmamiŋqe. Dŋä quvqe, ii täŋä-yaqä vätqätaŋgi, quväukuä 18 ae äpäukqe. Iiyqä tuwä-hiiki qui imäknätaŋgi, pämä jänänäŋi matqäuqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisasi Iqu ii hiŋuä äqunäqe, tääqä ätuätumeqe, “Tqä yaqä quvqe, huätä ae äkivämeqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","E ätuäqe, hipa haqeqi wiyqaŋga, apäkä iiŋä ii, maqänä jänä pämä ätqäuqe, Goti Hanjuwä Iqueqä yoqe, haqeu qe ämamäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iiŋä etaŋgi, ämaqä naqä, aŋä aquväqŋqä iu miqä iqu, Jisasi Iqu Sämbatqäŋga, apäkä ii äŋguä wimäkqaŋgqeŋqä äwqä tnäŋä wiŋgaŋga, qokä-apäkiu tiiŋä ätukqe. “Hiunji wäuŋuä iqe, 6 inänjqä. Hiunji iquauŋi, Iqu yaqä äŋguä emäkätŋqä ppŋqeqä. Hapä pmeqäŋgaŋi, iiŋqe mapqä ipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kimaŋi, Naqä Iqu tii ätukqe. “He wopqä ipu, kukŋuinä tqä-quenjqä. Hiunji hapä pmeqäŋgaŋi, he eequenä, bulumäka aŋä duŋqä äwäpu, bulumäkatä doŋgitä eeqänäŋi, eqä bŋqä ätuma uwquenjqä. ");
INSERT INTO mcr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","I etaŋgi apäkä, Aprähamä iqueqä meqä täsi, Setänä Goti Hanjuwä Iqutä mäkä-huŋqä iqu a äkiqätä pmetaŋgi, quväukuä 18 ae äpäukqeqä. Itaŋga hiunji hapä pmeqäŋgaŋi, Nyi nätmatqä ii a äkiqätäŋqe, huätä mämamäuqä imqe, ii suŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iqu e tquaŋgaŋi, Iqueqä himä-wiuŋqä iqua womba naqänäŋä iqaŋguwä-qe, qokä-apäkä eeqänäŋi, Jisasi Iqu e imäkätqätaŋgqeŋqä yeeqä naqänäŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iŋgaŋi Iqu kukŋuä hui inä tii ätukqe. “Goti Hanjuwä Iqunä miqeuŋi, ii änääŋgä? Nyi kukŋuä ktqe, äkitaŋi tmqäwä? ");
INSERT INTO mcr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ii tiiŋiqä. Ämaqä hŋqu zä-guawä piikä wäŋqe ämetä, iqueqä wäuŋuä du vowä meŋqiyä. Qänakndaŋi, piikä iiŋä ipu, zä eŋqä-pa naqä tqäuqaŋgqäŋga, yŋŋä iqua äpäpu, äpa du yuuwä imäkpŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iqu tiiŋä-pqe inä ätukqe. “Goti Hanjuwä Iqunä miqeuŋqe, Nyi kukŋuä ktqe, äkitaŋi tmqäwä? ");
INSERT INTO mcr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ii tiinjqä. Ii nätmatqä änyuämäutŋqä imäkätŋqä eŋqä-panjqä. Apäkä hui pälawä kuapänä ämetä, eeqänäŋi änyuämäutŋqä diŋqe, nätmatqä änyuämäutŋqä imäkätŋqä hmbunä ämetä, naqä-huinyä imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Qänakŋi Iqu Jerusälemä timäutŋqä äwätäqäŋgaŋi, Iqu qokä-apäkä du näqŋqä ävätä, aŋä-himqä naqeutä wäŋqeutä ikämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iŋgaŋi ämaqä hŋqu, “Naqä Iqukiyä, mäpäkoŋqä ipŋqä häŋä iqumuatätŋqe, Goti Hanjuwä Iqu ämaqä hmbunä aŋgu itmeniqätanä?” ätukqe. I tquaŋga, Iqu ämaqeuŋi tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nyi he etqänä. Qänakŋi, ämaqä kuapänäŋi, Goti Iqunä miqeuŋqä yanä-tpu ipiyä di, änä mäyqä da ipnuwiqä. Iiŋiŋqe, he aŋä hänaqä wäŋqä iuta hipŋqeŋqä yäŋä qämbiyä. ");
INSERT INTO mcr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aŋä Kaniqu ävautä, qŋqaŋä ae ämäyeqaŋga, he yäpaqä mäŋgisa ätqäupu, qŋqaŋä ptqä äqiyäpu tääqä tupnuwiqä. ‘Naqä Iquki, Si qŋqaŋä nauteyä.’ Iŋäqe Iqu kimaŋi, tiiŋä hetäniqeqä. ‘He äŋgisa ti äpquwätiyä-qe, Nyi maqŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iŋgaŋi he tii tupnuwiqä. ‘Ne Sitä buayä eqä anä äyä änmiŋqueqä. Si neyaqä aŋä-himqä hänaqä näŋi ätqäunä, ne näqŋqä äyä änätapmiŋiqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Iŋäqe Iqu tii hetäniqeqä. ‘He äŋgisa ti äpquwätiyä-qe, Nyi maqŋqeqä. He ämaqä suqä quvqä imäkquenjqae, huätä upiyä’ hetäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","He Aprähamä ique, Aisakä ique, Jekopä ique, itaŋga hiŋuä-tqä iquau, Goti Hanjuwä Iqunä miqeu pmetaŋgä hiŋuä ae äquŋgaŋguwäŋgaŋi, Goti Hanjuwä Iqu henyä hŋqäqinyqä huätä hindowatäniqeqä. Iqiŋi he iiŋqe, kŋuä äqäyäpu, hiquaŋä maŋgtäsqukuä mäuqäpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iŋgaŋi ämaqä mäptqä timäuqä iŋgisaŋä, mäptqä quveqäqä iŋgisaŋä, yuŋuä yapqä iŋgisaŋä, yuŋuä quveqäqä iŋgisaŋä iqua, qu äppiyi, Goti Hanjuwä Iqunä miqä iu buayä bŋqä quamä pmapnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Qätä nyipiyä! Ämaqä täŋga qua täu yoqä maeqä äpmamipqä iquautaŋä hŋqua, qu yoqä naqä-täŋä timäupnuwiqä. Itaŋga ämaqä täŋga qua täu yoqä-täŋä äpmamipqä iquautaŋä hŋqua, qu yoqä maeqä timäupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iŋgaŋi, Parisi hŋqua äwimapiyi, “Heroti iqu äkpäsätŋqä itŋqä-qae, Si aŋä täuŋi äväma, aŋä huiuŋqä uvä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iqu kimaŋi tii ätukqe. “He täŋä hindqä iquenyqä äwäpu, Nyaqä kukŋuä tä awä tupiyä. ‘Täŋgatä äwiŋgatäŋi, Nyi dŋä quvqä iquau huätä ändowatätmä, ämaqä täŋä-yaqä-täŋä iquau äŋguä iwimäkmqänä. Iŋi hea hŋquaqui-hŋque päwqaŋgaŋi, Nyi Ŋqä wäuŋui qäpu imniqeqä’ tupiyä. ");
INSERT INTO mcr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iŋäqe tängatä, awiŋgatä, ä awiŋga-mändaŋi, Nyi asänä iqa umqänä. Ii tiinjqä. Ämaqe, Goti Hanjuwä Iqueqä hiŋuä-tqä iqueŋi aŋä hŋqäqi päsqe qäyä etaŋguti, Jerusälemä dunä päsqe qäyunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusälemä, Jerusälemä, Goti Hanjuwä Iqu Iqueqä hiŋuä-tqä sinyŋqä dowatqaŋgqä iquauŋi, hikä pizqä päsqukiyqä. Hea kuapänäŋi, Nyi saqä ymeqä iquauŋi, kukutakisqä kiqä ymeqä itmetä, hikuwä yäpä iqi ämoqumuatetäŋqä-pa, naqä hmbinyä i moqumuatemätmä itŋqeqä. Iiŋä etaŋgqä-qe, he iiŋqe maeŋqä enä. ");
INSERT INTO mcr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tiiŋä timäuniqeqä. Goti Hanjuwä Iqu, heyaqä aŋi ävämeqaŋga, ii aaŋqä hiäniqeqä. Itaŋga Nyi tiiŋä etqänä. He qänaknda hiŋuä äŋqänäpu, ‘Ämaqä Goti Hanjuwä Iqueqä yoqeta pqaŋgqä Iqueŋi, nätmatqä äŋgui äwimeŋqiyä’ ätäpiyäŋgaŋqe, hiŋuä maŋqŋqä iqäpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sämbatqä hiunji hapä pmeqä hŋqueŋi, Jisasi Iqu ämaqä naqä Parisitaŋä hŋqueqä aŋä iu buayä nätŋqä uwqaŋga, qu “Iqu änä-änä imäkäŋqutiyä” tpu, hiŋuä äŋguänä äqumbu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iŋgaŋi ämaqä huiwä ppkä päpmakeyqä hŋqu, Jisasi Iqu-täŋä qäqiqi äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisasi Iqu ique hiŋuä äqunäqe, ämaqä kukŋuä-suqeŋqä näqŋqä iquautä, Parisi iquautä, quwqä suqä du kimaŋi, yatŋqä tiiŋä äwikqe. “Hiunji hapä pmeqäŋgaŋi, ne ämaqä täŋä-yaqä-täŋä iquauŋi, äŋguä iwimäkatuŋquätanä, qäyä hiätŋqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iqu yatŋqä e vqaŋga, qu kima mätquä ipu äpmamiŋuwi. Iwä Iqu ämaqä ique a äwqätätä, äŋguä iwimäkäqe, hiŋuinä äqunäwatkqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iiŋä imäkäqetaŋi, iquauŋi tii ätukqe. “Ämaqä hesaŋä hŋqu hiunji hapä pmeqäŋgaŋi, iqueqä ymeqä-pqä, ä iqueqä bulumäka-pqä qua hovqä eqä-huäŋä täutaŋgqä bu äpäquveqätqe, iqu iqueŋi maqänä ioqäpimeŋqutiyä, ä hiŋuinä qunäŋqutiyä?” ");
INSERT INTO mcr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iqu e tquaŋga, qu kimaŋi änä mätquä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iŋgaŋi Jisasi Iqu, ämaqä buayä bŋqä ätimäukuwä iqua, zä-hawä äŋguä iuŋqä äyä wiŋgaŋgi äqunäqe, kukŋuä ktqä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Ämaqä hŋqu apäkä metŋqä itä, ymisaŋä naqänäŋä imäkätä, si hŋquki tääqä ktqaŋgutqe, zä-hawä kiŋganäŋä iqueu, mäpmeqä pa iqätŋqä. Si iu äpmeŋi, ämaqä yoqä naqä qoŋqä hŋqu ätimäuqaŋgutqe, ämaqä ymisaŋä imäkätqä iqu, ‘Zä-hawi, yoqä naqä qoŋqä ique wiyä’ ktäniqeqä. Iŋgaŋi si womba itnä, zä-hawä yäpakä bu pmatŋqä utuŋiqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ämaqä hŋqu si tääqä ktqaŋga äuŋi, zä-hawä yäpakä bu pmeqätŋqä. Itaŋga ämaqä ymisaŋä imäkätqä iqu, äpätä, ‘Nyämaqä iquki, si äpätnä zä-hawä kiŋganäŋä täu pmayä’ ktäniqeqä. Iŋgaŋi si ämaqä ymisaŋä anä änäpiyä iuqä hiŋuä iqisaŋi, yoqä naqä qondŋiqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Qakui tiinjqä. Ämaqä hŋqu iqueqä yoqe haqeqä mamäŋgaŋgutqe, Goti Iqu iqueŋi mändi kittqiyäŋqiyä. Itaŋga ämaqä hŋqu iqueqä yoqe mändi äkittqäŋgqe, Goti Iqu iqueqä yoqe, yäänä imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iŋgaŋi, ämaqä ymisaŋä imäkätä tääqä ätukqä iqueŋi, Jisasi Iqu tii ätukqe. “Si ymisaŋä hui aŋgu imäkätŋäŋgaŋi, tqä näueqä iquauŋqä, tta-tuŋguäkauŋqä, sämaqä iquauŋqä, ä tqä aŋä-täŋä qäqiqiŋä mbqä kuapänäŋä-täŋä iquauŋqä, tääqä matqä isŋäŋqeqä. Si iquau tääqä tquaŋgtqe, qänakŋi qu sinyŋqä tääqä äktpu, buayä saqä äwisqeŋqä, qu kima ktappnuwiqä. Iiŋiŋqe si iquauŋqä tääqä matqä ma iqätŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Si ymisaŋä naqänäŋä imäkätŋäŋgaŋi, ämaqä nätmatqä maeqä iquauŋqä, huiwä quvqä iquauŋqä, yukä quvqä iquauŋqä, hiŋuä quvqä iquauŋqä tääqä tquätŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ämaqä iqua, si kimaŋi änä mäktapqä ipnuwiqä. Iiŋiŋqe, si aquvänä iqätŋqä. Qakui tiinjqä. Ämaqä jänänäŋä iqua aŋgu vauqaŋguwäŋgaŋi, Goti Hanjuwä Iqu ymisaŋä iiŋqe, kima ktapäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iŋgaŋi ämaqä, Iqutä buayä anä änäpu äpmapiyä hŋqu, qätä iiŋä äwiyäqe, Ique ätukqe. “Qokä-apäkä, Goti Hanjuwä Iqunä miqeu buayä änäpu pmapnuwä iqua, qu aquvänä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iqu e tquaŋga, Jisasi Iqu kimaŋi tii ätukqe. “Ämaqä hŋqu ymisaŋä naqä imäkäniqä diŋqä kŋuä indqänätä, ämaqä kuapänä ätimäupu buayä bnuwä diŋqä tääqä tquäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hiunji atäuŋuä itqä iqu, äyä timäuqaŋgaŋi, iqueqä wäuŋuä-wiyqä iqueŋi, ämaqä, iqu ätuätqä iquauŋqä äwätä, ‘He bpiyä. Ymisaŋä näwinyänjqä’ tuäniqä diŋqä dowatäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“I etaŋgi ämaqä eeqänäŋä iqua, qu hŋqunä-hŋqunä, ‘Nyi mapqä ymqänä’ tupnuwiqä. Ämaqä hŋqu tiiŋä tuäniqeqä. ‘Huäqä kiiŋä änuŋgiyä. Nyi äpmqä etaŋgqä-qe, wäuŋuä hŋqu mbqä ae iqäqä etaŋgi, hiŋuä qunmqä umqänä.’ ");
INSERT INTO mcr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hŋqu, ‘Huäqä änuŋgiyä. Nyi äpmqä etaŋgqä-qe, bulumäka 10 wäuŋuäŋqä mbqä ae iqäqä etaŋgi, nyi iquauqä wäuŋuiŋqä yamwiqä wimqä umqänä.’ ");
INSERT INTO mcr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hŋqu, ‘Nyi apäkä ae ämeqä etaŋgi, mapqä ymqänä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Qu i tquaŋguwäŋgaŋi, wäuŋuä-wiyqä iqu äpäqe, iqueqä naqä iqueŋi, ‘“Mapqä yaŋqunä” ändqäuä’ tuäniqeqä. Iŋgaŋi naqä iqu äwqä tnäŋä wiŋgaŋga, wäuŋuä-wiyqä iqueŋi, ‘Aŋä-himqä täuŋi, hänaqä naqä iutä, wäŋqä iutä maqänä äwätnä, ämaqä nätmatqä maeqä iquau, huiwä quvqä iquau, hiŋuä quvqä iquau, yukä quvqä iquautäŋi, ätuma yapiyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Itaŋga qänakŋi, wäuŋuä-wiyqä iqu, ‘Naqä iquki, si ändŋä-paŋä iiŋi, nyi ae imäkqänä. I etaŋgi, aŋi yqänä iqänänä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Iŋgaŋi naqä iqu, ‘Aŋä-himqä täutaŋä yäpaqäŋgisaŋi, hänaqä naqeutä, wäŋqeutä äwätnä, qokä-apäki, qu äppŋqänä kukŋuä yäŋänäqŋqä tuvä. Ŋqä aŋä täuŋi, ämaqä kuapänä pmapŋqä änyiŋgiyä. ");
INSERT INTO mcr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nyi si äktqänä, ämaqä nyi tääqä ganä ätukqä iqua, qu nyaqä buayi mämeqä naqä-qakuänä ipŋqäuä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Qänakndaŋi qokä-apäkä kuapänäŋi, Jisasi Iqutä qaŋä anä äwäpiyä iuŋi, Iqu tuwäŋgi hiŋuä ämoqunäqe, iquau tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ämaqä Nyinyqä äpätäqä hŋqu, kunaqä-kunuŋuauŋqä, ymeqä-apäkiuŋqä, käta-käŋguäkauŋqä, känanyi-känapqauŋqä, iqueqä häŋä-pmeqä-pqeŋqä kŋuä kuapänä indqänätä, yqänä äpätŋqe, iqu Nyaqä wäuŋuä-nyiyqe, mäpmeqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Itaŋga ämaqä hŋqu, zä-huätatä huŋqä iqueqe mämiwäuqä itä, Nyi qänaki mänyivändqä itqe, iqu Nyaqä wäuŋuä-nyiyqe, mäpmeqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ämaqä hesaŋä hŋqu, aŋä quäuqä hŋqu mätätŋqä itqe, iqu änä imäkäniqiyä? Iqu ganäŋi, ‘Nyi aŋä iqueŋqä mbqe, qäyunä ämetmdiyä?’ kŋuä indqänätä, quamä äpme, aŋä ique mätätŋqä mbqe iwäsäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ii tiiŋiqä. Iqueqä mbqä homä etaŋgi, aŋä äteŋinä iqutetqä etaŋgutqe, ämaqä hiŋuä äqumbiyä iqua, qu ique tä äsuäpu, äkasuwä tii tpŋqäuä, ‘Ämaqä tqu aŋä ique imäkqe, iqu qäpunä mimäkqä iqeqä’ tpŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tiiŋä-pqe inänji. Ämaqä aŋä-himqä hŋquesaŋä miqä hŋqu, aŋä-himqä huiziquesaŋä miqä hŋquenyqä mäkä huinyiyŋqä wätŋqäŋgaŋi, iqu äänä imäkäniqiyä? Iqu quamä ganä äpme, ‘Nyaqä ämaqe, 10,000 inänjqä. Iqueui, 20,000 iquaiqä. Nyaqä ämaqä iquatä nyitä, ne ämäwqätaŋquatiyä, mämäwqätäuqä yaŋquatiyä?’ kŋuä indqänäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Itaŋga iqu tiiŋä yäŋqiyä. ‘Nyitä nyaqä ämaqä iquatäŋi, ne änä mämäwqätäuqä yaŋqunä’ kŋuä vqaŋgutqe, iqueqä mäkä-huŋqä iqua kiŋä nämä pätqätaŋguwäŋgaŋi, iqu ämaqä hŋquau kukŋuä yamwiqä ipu, mäki mändi kittqäpŋqä diŋqä dowatäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iŋäqe, heyaqä awä iqisaŋä hŋqu, iqueqä nätmatqä eeqänäŋiŋqä tuwä mäwiyqä iqäqe, iqu Nyaqä wäuŋuä-nyiyqä mäpmeqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","I ätuäqe, Iqu tiiŋä-pqe inä ätukqe. “Haki, äŋguiqä. Iiŋä etaŋgi kiqä ätquäŋqä qäpu heqaŋgutqe, hakä ätquänätŋqe, aŋgumä äänä timäuniqiyä? ");
INSERT INTO mcr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haki kiqä ätquäŋqe hma eqäqe, tä wätakä wäuŋuä iu ymisaŋä haqeqä äquvatetuŋquä-paŋi, mäquvateqä yaŋqunä. Itaŋga yaqueqä yäätä naqä-huinyä imäkätanä wäuŋuä iu buayä haqeqi mäquvateqä yaŋqunä. Hakä iiŋi, ne bi tnämaŋqunä. Ämaqä qätä-täŋä iqua, kukŋuä iiŋqe kŋuä äŋguänä indqämbiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hiunji hŋqueŋi, ämaqä mbqä motauqä iquatä, suqä quvqä imäkqä iquatä, Jisasi Iqu-täŋä qäqiqi kukŋuä qätä wipŋqä äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iŋgaŋi Parisi iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, Jisasi Iquenyqä maŋä qeiqi tii ätmiŋuwi. “Ämaqä suqä quvqä imäkqä iqua, Iqu-täŋä qäqiqi wimeqaŋguwäŋga, Iqu iquau yeeqä itmetä, buayä anä änätqäŋuwiqä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iiŋqe, Jisasi Iqu kukŋuä ktqä tqu ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hesaŋä hŋqu sipsipqä 100-täŋu emitätqe, hŋqu imatnätqe, iqu hiŋuinä qunäniqiyä? Oeyä, iqu huiziquauŋi qamqä änmipqä iqi äväma, kiuänäŋä ävämetqä ique ämoqumuetŋqä diŋqä, qävqäŋqä wäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iqu ämoqumueqe, quamä äkiwäwa äpätä, aquvänä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Iqueqä aŋä iqi ätimäutäqäŋgaŋi, iqu iqueqä näueqä iquauŋqätä, iqueqä aŋä-täŋä qäqiqiŋä iquauŋqätä, tääqä tii tuäniqeqä. ‘Nyaqä sipsipqä imatŋgqe, ŋqä-näuä ae ämoqumueqäqeŋqe, he nyitä aquvänä anä yatuŋqueqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nyi tiiŋä etqänä. Iiŋä iqua aquvänä kuapänä iquwä-paŋi, eŋätqä qäukuä yäŋiŋä iqua, ämaqä suqä quvqä imäkqä hŋqu, kŋuä äkunmäknätä, iqueqä suqä quvqe ävquatämäuqetaŋi, qu aquvänä kuapänä asä inä ipŋqäuä. Ämaqä suqä jänänäŋä imäkqä iqua, quwqä kŋuä makunmäkŋqä etaŋgä, kuapänäŋä qäyä etaŋgqä-qe, eŋätqä iqua iquauŋqe, aquvänä asänäŋi miqä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tiiŋä-pqä inänji. Apäkä hui iiyqä mbqä-hikä äŋguänäŋä 10 ämamitätqe, hŋqu ätivämäutqe, ii äänä yäniqiyä? Ii iiyqä mbqe aŋgi metŋqe, hiqi-tä ämäsäutä, tä äyäqunätä aŋi siyä äpitä, ique ämoqumuetŋqäŋgaŋqe, hiŋuä äŋguänäŋä qunäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iiyqä mbqe ae ämetqäŋgaŋi, ii kiqä käyämaqä iuauŋqätä, iiyqä aŋä iqiŋiuŋqätä, tääqä tiiŋä tuäniqe. ‘Nyaqä mbqä ätivämäuqä-qe, ae ämeqänä. He nyitä yeeqä anä yatuŋqueqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nyi he etqänä. Iiŋä iua aquvänä kuapänä iquwä-paŋi, eŋätqä qäukuä yäŋiŋä iqua ämaqä suqä quvqä imäkqä hŋqu kŋuä äkunmäknätä, iqueqä suqä quvqe ävquatämäuqetaŋi, qu aquvänä kuapänä asä inä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","12","I ätuäqetaŋi, kukŋuä ktqä hŋquququ tiiŋä-pqä inä ätukqe. “Ämaqä hŋqu ymeqä qokä hŋquaqu-täŋä emitätqe, ymeqä qänakŋä iqu kanmä tii tuäniqe. ‘Apä, saqä nätmatqe iwäsäutnä, ŋqe täŋga dapiyä.’ Iŋgaŋi kaniqu yquayi iwäsäutä, iqueqe äväniqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Iŋi hŋgaŋqä miqä, yquayä maqänä ämeqe, aŋä kiŋä nämqä äwäqe, suqä quvqä iuta, iqueqä mbqä maqänä-maqänä tnämäuniqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Iqueqä mbqä qäpu eequnäqe pmetaŋga, qua iuŋi buayä dä naqänäŋä timäuqaŋga, iqu nätmatqä eeqänäŋiŋqä äwa yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Iŋgaŋi iqu ämaqä iqisaŋä hŋqueqä wäuŋuä-wiyqä-qu hiätŋqä wimeqaŋga, ämaqä iqu iqueqä yaqueqä miquätŋqä dowatäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ämaqä, ique ymisaŋä wipŋqe, aaŋqä etaŋgi, iqu yaqueqä täpqä-pa nätqätaŋgä äqunäqe, iqu hui ämetä nmätä yäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iŋgaŋi iqu kŋuä jänäŋi indqänätä, iqueqä-kiuä tii tnäniqe. ‘Apiqueqä wäuŋuä-wiyqä eeqänäŋi, qu buayäŋqä äwa miqä ipu, kuapänä änätqäŋäuä. Iŋäqe nyi täu äpmamäŋgaŋi, buayä dä naqänäŋä äpäkonätqäŋänä. ");
INSERT INTO mcr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nyi täqiŋi äväma, ŋqä apiquenyqä aŋgi äumi, tii tumqeqä. “Apiquki, nyi suqä quvqe, Goti Hanjuwä Iqueuätä, saqätä hiŋuä iqiŋi ae imäkqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Täŋgaŋi nyi tqä ymeqä äŋguä-qunä hmanjqä. Iiŋiŋqe, ‘Si ŋqä ymequkiyä’ mandqä manä. Nyi tqä wäuŋuä-kiyqä hŋqunä-mända emqä pmuatenjitŋqeqä” tumqeqä’ tnäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","E ätnäqe, iqu aŋä-himqä iuŋi ävämaŋi, kiqä kaniquenyqä wäniqeqä. Iŋgaŋi ymeqä-qu kiŋä nämä yqänä pätqätaŋga, kaniqu hiŋuä äqunäqe, kiqä ymeqä iquenyqä huäqä kiiŋä wuŋgaŋguti, tnäŋä äwäqe, atukuä ämaitä, quneqä väniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iqu i iqaŋga, ymeqä iqu kanmŋi tii tuäniqeqä. ‘Apiquki, nyi suqä quvqe, Goti Hanjuwä Iqueuätä, saqätä hiŋuä iqiŋi ae imäkqeqä. Täŋgaŋi nyi tqä ymeqä äŋguä-qunä hmanjqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iiŋä iäqe, kaniqu iqueqä ämaqä wäuŋuä-wiyqä iquau tuäniqeqä. ‘He nyaqä gquä quäuqe, maqänä äma äpäpu, wiyätäpu, gue iqueqä hipa hitäuŋuä hŋque muasmepiyi, yukä qutatä huiqä bu hŋqu muasmepiyä. ");
INSERT INTO mcr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Itaŋi he äwäpu, bulumäka meqä yäŋänäqŋqä ique, ätma äpäpu päkpiyä. Ymisaŋä naqänäŋä imäkätanä, hääwä ätätanä, aquvänä yatuŋquänänyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‘Quati tiinji. “Nyaqä ymeqä tqu ae äpäkonäŋqeqä” tmä itŋqe, iqu aŋgu ävauqiyä. “Mämoqumueqäŋqä äukqeqä” tmä itŋqe, iqu aŋgi ätimäuqiyä’ tuäniqeqä. Qu iiŋä ipiyitaŋi, himnuŋuä ipu aquvänä ipnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Qu e imäkqaŋguwäŋgaŋi, ymeqä hitmqä iqu wäuŋuä imä äpmamitätqe, aŋgi äpätä kiqä aŋä-täŋä qäqi ätimäuqe, hääwä qätä äwiyätä, quvaqä himnuŋui qätä wiyäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","E äwiyäqe, iqu wäuŋuä-wiyqä hŋque tääqä ätuätumetä, iqueŋi tii tuäniqeqä. ‘Ii suŋqä imäkätqäŋäuä?’ ");
INSERT INTO mcr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","I tquaŋga, wäuŋuä-wiyqä iqu kimaŋi, tii tuäniqeqä. ‘Tqä tuŋguequ aŋgumä pqaŋgi, tniqu bulumäka meqä yäŋänäqŋqä ique äpäsqiyä. “Nyaqä ymeqä iqu äŋguä äpmeŋqä äpqiyä” kŋuä vqaŋgi, aquvänä itanjqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ymeqä hitmqä iqu qätä iiŋä äwiyäqe, äwqä tnäŋä wiŋgaŋguti, aŋä yäpä yäŋgisaŋi mäpeyqä yäniqeqä. Kaniqu yäpaqäŋgisa ätimäuqe, ymeqä-queqä äwqe, yuŋuä itmäketŋqe, kukŋuä äŋgui ganä tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Iŋäqe kaniqueŋi tiiŋä tuäniqeqä. ‘Änääŋgä? Quväukuä kuapänäŋi, nyi wäuŋuä-kiyqä heŋgŋqä eŋqä-paŋä äpmamä, saqä kukŋui huätä mämamäuqä itŋqeqä. Iŋäqe nyi ŋqä nyämaqä iquatä, ymisaŋä naqä imäkätanä himnuŋuä yatuŋque, si yaqueqä meme meqä hŋqu, mändapqä itqäŋiqä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","‘Täŋgaŋi tqä ymeqä näŋu, saqä nätmatqä eeqänäŋi, apäkä qaŋä ikiqä iquau qäpunä äväqe, aŋgu pqaŋga, si iquenyqä bulumäka yäŋänäqŋqä ique äyä päkinyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","I tquaŋga kaniqu tii tuäniqeqä. ‘Ymeqä iquki, hea ique-iqueŋi si nyitä anä äpmeŋiqä. Nyaqä nätmatqä eeqänäŋi, sitänä äyä äwinä. ");
INSERT INTO mcr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iiŋä etaŋgi täŋgaŋi, ne äwqä yeeqä itanä pmetuŋqueqä. Ii tiiŋiqä. Tqä tuŋguequ ae äpäkoŋgqe, aŋgu ae ävauqiyä. Iqu mämoqumueqäŋqä äukqe, aŋgi äpätä nesä anä äpmeqiyä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","I ätuäqetaŋi, Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, tii ätukqe. “Ämaqä nätmatqä kuapänäŋä-täŋä hŋqueqä nätmatqä iuŋi, ämaqä hŋqu ämitä pmetäniqeqä. Ämaqä hŋqua äquvepäpu, ämaqä naqä iqueŋi tii tupnuwiqä. ‘Ämaqä tqä nätmatqä eeqänäŋiu miqä iqu, hiŋginäwa eeqä änätqänä.’ ");
INSERT INTO mcr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iŋgaŋi ämaqä naqä iqu, iqueqä ämaqä iqueŋi tääqä ätuätumeqe, ‘Änääŋgä? Nyi sinyqä kukŋuä quvqä hui qätä äwiyäŋqeuä. Nyaqä nätmatqä eeqänäŋi, nyi saqä hipa iu ekqe, si äänä ämitqäŋiŋqe, äŋguänäŋä iwäsäutnä, pipa äqiyäma dapiyä. Nyi si quvqänäŋä äkqänäŋqä-qae, nyaqä nätmatqä eeqänäŋä iuŋi, ämiqä mäpmeqä isŋqinyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","I tquaŋga iqu kiqä-kiuä tiiŋä tnäniqeqä. ‘Naqä Iqu huätä nändowatätŋqä iqäqe, nyi äänä imäkmqäwä? Nyi qua ptmqe, yäŋänäqŋqe maiqunji. Nyi ämaqä hŋqua yätamäkqä nyipŋqä, yatŋqä imqe, womba nyinäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nätmatqä nyi täŋga imäkmqä diŋqe, näqŋqä ae ämeqä. Nyi nätmatqä hui imäkqaŋgmdqe, ŋqä naqä iqu nändowatqaŋgaŋi, ämaqä hŋqua indmepu, iquauqä aŋä duŋqä ändma upŋqäuä’ tnäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Näqŋqä ae ämeqetaŋi, iqu ämaqä quwqä naqä iqueqä nätmatqä hiŋginäwa ämakuwä iquauŋi, tääqä hŋqunä-hŋqunä tuätumeniqe. Ämaqä kiŋganä wimeqaŋgqä iqueŋi, ‘Si nätmatqä hiŋginäwaŋi, äänä ämakŋäwä?’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yatŋqä iiŋä vqaŋga, iqu kimaŋi, ‘Nyi nätmatqä hiŋgiŋi, kuatä-häkä olipqä eqä aowi, 100 täqä ämakqeqä’ tuäniqeqä. I tquaŋga iqu, ‘Si quamä maqänä äpmetnä, pipa nätmatqä hiŋginäwa meqaŋgnä äqiyäpu ekuwi, ämetnä, 50 qiyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Qänakndaŋi iqu hŋque-pqä yatŋqä inä ävätä, ‘Si nätmatqä hiŋginäwaŋi, äänä ämakŋäwä?’ tuäniqeqä. Iqu kimaŋi, ‘Nyi kuä-witqä qae, hiŋginäwa 100 ämakqeqä’ tuäniqeqä. I tquaŋga iqu, ‘Si pipa maqänä ämetnä, 80 qiyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Qänakndaŋi, ämiqä quvqä iqu kŋuä qeiqinyä indqänätä imäkqaŋgqeŋqä, iqueqä naqä iqu, iqueqä yoqe haqeqä vauqumuatäniqe. Ämaqä suqä qua täuŋiŋqä qänaknä itqäŋuwä iqua, kŋuä qeiqinyä indqänäpu imäkäpiyi, ämaqä qutäŋä asänäŋä iquau ämäwqätäutqäŋuwi. Ämaqä, suqä we-huŋqä-täŋiu qänaknä itqäŋuwä iqua, kŋuä qeiqinyä mindqäŋqä ipu, imäkätqäŋuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nyi he etqä. Mbqä quvqä qua täutaŋi ämapiyitaŋi, heqä näueqä imäkmbu. He iiŋä imäkpiyä dutaŋi, mbqä hma eqaŋgi, ga he aŋä hea ique-ique pmeqä yätu timäuqaŋguwäŋgaŋi, qu henyqä aquvänä ipnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ämaqä nätmatqä wäŋqä isuauŋi äŋguänäŋä ämitŋqä iqu, iqu nätmatqä naqänäŋä-pqä iuŋi, äŋguänäŋä miquänä. Ämaqä nätmatqä wäŋqä isuauŋi änä mämiqä iqu, iqu nätmatqä naqä-pqä iuŋi, änä mämiqä yänä. ");
INSERT INTO mcr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iŋi tiinji. He mbqä quvqä qua täutaŋä di änä mämiqä imipqe, nätmatqä äŋguänäŋä mipŋqe, tqu hitapäniŋqe? Aaŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","He ämaqä hŋqueqä nätmatqä äŋguä mämiqä imitpqe, nätmatqä hiqä hiätŋqä di, tqu hitapäniqäwä? Aaŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ämaqä kiuänäŋä hŋqu, ämaqä hŋquaquiŋi, wäuŋuä änä mäwiyqä yänä. Iqu iiŋä itäqe, hŋquenyqänä äwinyätä, huiziquenyqe, äkasuwä ätätä mäwiŋqä yänä. Hŋqueŋi, iqueqä kukŋui qätä äwiyätä, huiziqueŋi, tuwä wiyänä. Itaŋgi he Goti Hanjuwä Iquenyqä qänaknä ipiyi, mbqä iquenyqe qänaknä miqä ipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jisasi Iqu e tquaŋga, Parisi iqua, mbqeŋqä äwinymiŋqä etaŋgi, qu kukŋuä eeqänäŋi qätä äwipiyi, tä sisäwqä ipu, Iquenyqä äkasuwä ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iqu iquauŋi, “Ämaqä qu henyqe, ‘Ämaqä suqä jänänäŋi imäkqä-quaiqä’ kŋuä vätŋqeŋqe, he kiiŋä eŋgiyä. Iiŋä etaŋgi nätmatqä eeqänäŋä hiqä äwqä yäpä iŋgisatä, hiqä kŋuä indqäŋqä iutä äwiŋqeŋqe, Goti Hanjuwä Iqu näqŋqä eä. Nätmatqä ämaqä iqua ‘äŋguänäŋiqä’ kŋuä äväŋqe, Goti Hanjuwä Iqu quvqä äqunänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Hea Jonä iqu änyä mapqäŋgaŋqe, qu Goti Hanjuwä Iqueqä kukŋuä-suqeŋqätä, iqueqä hiŋuä-tqä iqua äqäkuwiŋqätä, awä ätqa äpmiŋuwi. Iiŋä etaŋgi Jonä iqu äpkqeta täŋgaŋqe, qu Goti Hanjuwä Iqunä miqä iuŋqä awä ätqa äpätqäŋuwi. Iŋi ämaqä eeqänäŋä iqua, aŋä Goti Hanjuwä Iqunä miqeuŋqä pepŋqä, yäŋä äqänätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Qäukuitä quaetäŋi, äwa yänä. Iiŋä etaŋgi Goti Hanjuwä Iqueqä kukŋuä-suqä iutaŋi, hui qui mimäkŋqä yäŋqiyä. Oeyä. ");
INSERT INTO mcr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ämaqä hŋqu iqueqä apäki ävquatämäuwa, apäkä hui-mända ämetqe, iqu suqä quvqä, huiwä yaŋä ikiqe imäkqi. Iŋi ämaqä hŋqu iqueqä apäki ävquatämäuqaŋga, qänakŋi ämaqä huizi hŋqu apäkä asä ii ämetqe, iqu-pqe asä inänji. Iqu suqä quvqä, huiwä yaŋä ikiqe, imäkqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","E ätuäqetaŋi, tii ätukqe. “Ämaqä nätmatqä kuapänäŋä-täŋä hŋqu äpmamiŋqe. Hea ique-iqueŋi, iqueqä ämuasmäŋqe, gquä ipisqetäqäkä äŋguänäŋitä imäknä äpme, buayä äŋguä dinä äŋgmanmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iqueqä aŋä qŋqaŋä-täŋä iqiŋi, ämaqä nätmatqä maeqä, wätaŋqä kuapänä-täŋä hŋqu äpmamiŋqeqä. Iqueqä yoqe, Lasarusi ique. ");
INSERT INTO mcr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iqueqä kŋuä iqä imŋi, ‘Ämaqä nätmatqä kuapänäŋä-täŋä tqu, ymisaŋä hituŋuä änänjuämäqaŋgutqe, ämetmä nmqeqä’ kŋuä vqaŋgi äpmamiŋqe. Iiŋä pmetaŋga, hiveqä iqua äpäpu, iqueä wätaŋqe tewä äpnmiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Qänakndaŋi Lasarusi iqu äpäkoŋgaŋga, iqueqä quuvqe, Goti Hanjuwä Iqueqä eŋätqä iqua ätuma äwäpu, Aprähamä iqutä anä äpmuatekuwi. Itaŋga qänakndaŋi, ämaqä nätmatqä kuapä-täŋä iqu äpäkoŋgaŋga, qu iqueä huiwi qua äptekuwi. ");
INSERT INTO mcr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iqueqä quuvqe, ämaqä pizqä iquauqä aŋä iu äpme, haŋä-iqä naqänäŋä ämakmanmiŋqe. Iqu iiŋä itäqä imdaŋi, hiŋuä haqä yätu äqunätä, Aprähamä iqu kiŋä yämä, Lasarusi iqutä anä äyä pmetaŋginyä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iŋgaŋi iqu, ‘Iyää apä Aprähamä iquki, nyi tä täu äpmami, täŋä-huŋqä naqänäŋä ämetqäŋä. Si nyinyqä huäqä kuŋgaŋguti, Lasarusi ique dowati, iqu iqueqä hipa hitäuŋuä hŋqu eqä du äyämetä, ŋqä tewä täu ptqiyenjiyätŋqäuä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Iiŋä tquaŋga Aprähamä iqu kimaŋi, tii ätukqe. ‘Ŋqä ymeqä iquki, änä äpmämiŋiyiŋqä kŋuä indqänä. Si qua bu äpmamiŋäŋgaŋi, nätmatqä äŋguänäŋi äŋgmanätqätaŋgŋäŋga, Lasarusi iqu nätmatqä quvqe ämanmiŋqe. Iiŋiŋqe täŋgaŋi, aŋä täuŋi, iqu äŋguä pmetaŋga, si täŋä-huŋqä naqänäŋä iiŋä makmaŋgtŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tiiŋä-pqe hiŋuä qunyä. Hesäŋä nesäŋä awä iqiŋi, suä naqänäŋä iqu äptnä, ämaqä täŋgisaŋä hŋqu henyŋqä pätŋqä wiŋgaŋgutqe, änä mapqä yänä. Itaŋga ämaqä iŋgisaŋä hŋqu nenyŋqä, änä mapqä yäŋqiyä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","I tquaŋga, iqu kimaŋi, ‘Apä, nyi si yatŋqä äkiyqä. Lasarusi iqu ŋqä apiqueqä aŋä duŋqä äwätä, ŋqä tatqä-guäka paipqä iquauŋi, kukŋuä tä awä tuätŋqä dowati. Iqua-pqe aŋä nyi äpmeŋqä täuŋqä äpäpu, huiwä täŋä-huŋqä meqä diŋqä ätqänä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ga, Aprähamä iqu, ‘Qu bukä Mosisi iqu äqäkqetä, bukä Goti Hanjuwä Iqueqä hiŋuä-tqä iqua äqäkuwitä ämeŋä. Qu kukŋuä ii qätä äwiyäpu, qänaknä ipŋqäuä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Iwä iqu tii ätukqe. ‘Apä Aprähamä iquki, iiŋi änä matimäuqä yänä. Ämaqä ae äpäkonätqä hŋqu, ävautä iquau wimeqaŋgutqe, iqua hiŋuä äqumbiyi, kŋuä äkunmäknäpu, quwqä suqä quvqe ävquatämäupŋqäuä.’ ");
INSERT INTO mcr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Iŋgaŋi Aprähamä iqu kimaŋi, ‘Ii tiiŋi. Iqua Mosisi iqueätä, Goti Hanjuwä Iqueqä hiŋuä-tqä iquauqätä, kukŋui qätä mäwiyqä iqaŋgpqe, ämaqä ae äpäkonätqä hŋqu qua duta ivatuwäŋgaŋga, qu quuvqä maeqiyqä ipŋqäuä’ ätukqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iŋgaŋi Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “Ämaqe, qu suqä quvqä du quanŋä päkmbŋqeŋqe, nätmatqä huitaŋä-huitaŋi wimeŋqiyä” ätukqe. “Iŋäqe, ämaqä suqä quvqä iiŋä äma äpätä ävätqä iqu, haŋä-iqä menä. ");
INSERT INTO mcr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Itaŋga ii tiiŋi. Ymeqä täutaŋä hŋqu, ämaqä hŋqueuä suqä quvqä imäkqaŋgqä du hiŋuä äqunätä, asä iiŋä imäkätä quanŋä päkŋgaŋgutqe, ämaqä suqä ipäqiyqä iqueŋi, haŋä-iqä naqänäŋi äwimenä. Ämaqä hŋqua, hikä naqänäŋä hŋqu ämepu, iqueqä hiiŋuä-qo iu guä äkiqiyepu, eqä-huäŋä bu tnämäupqe, ii haŋä-iqä asänäŋä hmanjqä. Iŋäqe haŋä-iqä ique äwimeniqä iqu, iqueŋi aaŋä naqänäŋä ämäwqätäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“He hiqä-hiuä hŋqunä-hŋqunä äŋguänä mimbiyä. Tqä tta-tuŋguequ suqä quvqä imäkqaŋgutqe, si, iqu iqueqä suqä quvqä imäkqeŋqä jänä imäknätŋqä tutŋqe. Iqu kŋuä äkunmäknätä, suqä quvqe hämänä ävquatämäuqaŋgutqe, si äwqä haŋuä imäknätnä, hui äkinyänä. ");
INSERT INTO mcr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ga hiunji hŋqueŋi, iqu suqä quvqä 7 ikimäkätä, 7 äkimetä, ‘Nyi kŋuä ae äkunmäkŋgänä’ ktqaŋgutqe, si iqueqä suqä quvqä kuapänäŋä iiŋqe, äwqä haŋuä imäknätnä, hui kinyätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, Naqä Iqueŋi, tii ätukuwi. “Si neqä quuvqä heqiyqe, yäŋänäqŋqänäŋä inemäkiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iqu kimaŋi, “Hiqä quuvqä heqiyqe, guawä piikä isua eŋqä-paŋä, wäŋqä iiŋä etaŋgutqe, he zä-yäŋä tqueŋi, tiiŋi äŋguä tupŋqäuä. ‘Si tqä hukä qäsä äyautnä, eqä-huäŋä buŋqä äwitnä, iqi tqävä’ tquaŋgpqe, qätä heyäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ämaqä hesaŋä hŋqueqä wäuŋuä-wiyqä hŋqu, wäuŋuä duta pqaŋga, iqueqä naqä iqu iqueŋi, ‘Si maqänä äptnä, quamä äpmetnä, buayä huinyä’ tuäniqiyä? ");
INSERT INTO mcr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oeyä, iqu iqueŋi, ‘Si nyinyqä ymisaŋi näwinyä imäketnä, tqä gquä yappä änyätnä, nmayäqäsiyä. Nyi buayätä, eqätä ganä gaŋga, si qänaki dŋqänänyä’ tuäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wäuŋuä-wiyqä iqu ätquaŋgqä-pa iqaŋgaŋi, naqä iqu ‘äŋguiqä’ tuäniqi, ä mätquä yäniqi? Iqu mätquä yänä. ");
INSERT INTO mcr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iiŋä etaŋgi he-pqe, he nätmatqä eeqänäŋä Goti Hanjuwä Iqu etätqä-pa imäkäpiyi, ‘Ne ämaqä wäuŋuä-wiyqä quvqä-quneyqä. Nätmatqä ne imäkätaqe, neqä Naqä Iqueqä kukŋuä dunä imäkätuŋqueqä’ tpŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iŋgaŋi Jisasi Iqu Jerusälemäŋqä wätŋqänä, qua Sämaliyatä, qua Galilisäŋä, awä iqi qaŋä äumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Iqu aŋä-himqä hŋque ti timäuqaŋga, ämaqä wänyimäŋqä-täŋä 10 hŋqua, Jisasi Iqutä äminanä-tpu äpmiŋuwi, kiŋä näŋi ätqeppiyi, Iquenyqä tääqä yäŋänäqŋqä, “Naqä Jisasi Iquki, Si nenyqä huäqä äkunänä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","I tquaŋguwäŋga, Iqu iquau hiŋuä äqunäqe, “He äwäpu, hiqä huiwi hiqäva-imäkqä iquau motquapiyä” ätukqe. Iqu iiŋä tquaŋgqe, qu qätä äwipiyi, qaŋä wätqätaŋguwäŋga, iquauqä huiwi äŋguä qe imäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","I ipiyitaŋi, ämaqä iquautaŋä hŋqu, iqueqä huiwä iu hiŋuä iqänäqe, tääqä yäŋänäqŋqä ätätä, Goti Hanjuwä Iqueqä yoqe haqeqä ämamäutä, aŋgi äpkqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iqu Jisasi Ique äwimeqe, hipeŋui Iqueä yukä-täŋä qua mäŋi eätä, Ique “äŋguiqä” ätukqe. Ämaqä iqu Sämaliyataŋä ique. ");
INSERT INTO mcr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","I iqaŋga, Iqu tii ätukqe. “Ämaqä 10 iqua äŋguä ae imäŋguwi, huiziqua äŋgikä? ");
INSERT INTO mcr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iqua aŋgi äpäpu, Goti Hanjuwä Iqueqä yoqe haqeqä mamäupŋqe, hmandanä? Ämaqä yäpaqäŋgisaŋä tqunä imäkqä-qeuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","I ätuäqetaŋi, Iqu ämaqä iqueŋi, “Si pämä ätqäutnä, qaŋä uvä. Tqä quuvqä heqiyqe, aŋgumä äŋguä ikimäkqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hea hŋqueŋi Parisi iqua, Jisasi Ique yatŋqä äväpu, “Goti Hanjuwä Iqunä miqe, äkŋga timäuniŋqäwä?” ätukuwi. I tquaŋguwäŋga, Jisasi Iqu kimaŋi, “Goti Hanjuwä Iqunä miqe timäuqaŋgaŋi, qokä-apäki, hiqŋqä hui atäuŋuä eä timäuqaŋgqe, hiŋuä mäquŋquä ipnä. ");
INSERT INTO mcr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iŋi, qu ‘Hiŋuä qumbiyä, täqi täsä äpmenä’ ä ‘Näŋi äpmenä’ matqä ipnä. Ii tiiŋi. Goti Hanjuwä Iqunä miqe, hesä ae äpmenä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iŋgaŋi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquau ätukqe. “Hea qänakndaŋi, he hea Ämaqeuqä Ymeqä Ekqä Iqu pmeniqä hŋquenyqe, hiŋuä qumbŋqä kiiŋä hinyänä. Iiŋä etaŋgi, he hiŋuä moquŋqä da ipnä. ");
INSERT INTO mcr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Qu ‘Hiŋuä qumbiyä! Iqu näŋi äpmenä’ ä, ‘Täqi täsä äpmenä’ hitqaŋguwäŋgaŋi, he iquau qänaki mäwivändqä pa iqäpnä. ");
INSERT INTO mcr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Iqu äpätŋqäŋgaŋi, nyuauä itä, qäukuä haqä yätuta we im-imä äunätŋqä-paŋi, Iquesa we asä inä hunäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iiŋä etaŋgi Iqu täŋä-huŋqä kuapänä ganä menä. Ämaqä hea täŋga äpmeŋuwä iqua, qu Iqueŋi tuwä wipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ämaqe, Noa iqu pmetaŋga imäkmiŋuwä-paŋä iiŋi, Ämaqeuqä Ymeqä Ekqä Iqu äpätŋqäŋgaŋi, suqä asiqu timäuniqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa iqu pmetaŋgaŋi, qu ymisaŋä änäpu, eqä änäpu, apäkä ämepu, apäkä yaŋä änyäpu, iqa wätqätaŋguwäŋga, Noa iqu yimba yätu äpaqukqe. Iŋgaŋi eqä huakä naqänäŋä ätimäutä, qokä-apäkä eeqänäŋä qui imäkŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Loti iqu-pqä pmetaŋgaŋi, asä inä ätimäukqe. Iŋgaŋi qu ymisaŋä änäpu, eqä änäpu, nätmatqä mbqä ipu, mbqäŋqä imäkäpu, ymisaŋä vowä ikäpu, aŋä ämätäpu imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Itaŋgi, Loti iqu aŋä-himqä Sotomä iu ävämeqaŋga, iŋga qäŋgaŋi, tätä hikätä qäukuä haqä yätutaŋi, piyä eŋqä-paŋä äquvepäqe, ämaqä eeqänäŋä pizqä äpäkkqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iiŋä etaŋgi, Ämaqeuqä Ymeqä Ekqä Iqu aŋä ätnäŋä iŋgisa timäuqaŋgaŋi, asä iiŋä timäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Hea Ämaqeuqä Ymeqä Ekqä Iqu aŋgi timäuqaŋgaŋi, ämaqä hŋqu iqueqä aŋä atääqä yätu äpmamitätqe, nätmatqä aŋä yäpä iŋgisa witaŋgqeŋqe, äpäkäwitä mämeqä yäniqe. Itaŋga ämaqä hŋqu iqueqä wäuŋuä imä äpmamitätqe, aŋiqinyqä mäwqä yäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","He Loti iqueqä apäkinyqe, kŋuä äŋguänä indqämbu. ");
INSERT INTO mcr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ämaqä hŋqu iqueqä häŋä-pmeqeŋqä äwinymitätqe, ga iqueqä quuvqe qui imäknäniqe. Ii etaŋgi, ämaqä hŋqu iqueqä häŋä-pmeqe ävquatämäutqe, iqueqä quuvqe, qui mimäkŋqä yäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nyi he etqä. Ämaqeuqä Ymeqä Ekqä Iqu heatqäŋga äpätqe, ämaqä hŋquaqu iquvaŋä naqä-huinyä witaŋgiyä-qe, Goti Hanjuwä Iqu, hŋque itmetä, hŋqueŋi hiŋuinä qunäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Itaŋga apäkä hiaqu sŋgumetqä quqowä qäyätqätaŋgiyä-qe, Goti Hanjuwä Iqu hui itmetä, huiŋi hiŋuinä qunäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","I tquaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua qätä äwipiyi, “Naqä Iquki, nätmatqä ii äkŋgi timäuniŋqäwä?” ätukuwi. Iqu kimaŋi, “Nätmatqä äpäkonä pizqä witaŋgqä iuŋi, yŋŋä quvqä iqua äpäpu, äpputmäupu äŋgpŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iqua Goti Hanjuwä Iquenyqä tääqä hea ique-ique tqäpnuwä diŋqätä, ‘Goti Hanjuwä Iqu qätä mäneyqä iqiyä’ ätäpu, enyqä miqä pa ipnuwä diŋqätä, Jisasi Iqu kukŋuä ktqä tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Aŋä-himqä hŋqueuŋi, ämaqä kukŋuä jänä imäkqä hŋqu pmetäniqe. Iqu Goti Hanjuwä Iquenyqä zä miqä itä, ämaqä huiuŋqä kŋuä mindqäŋqä-que. ");
INSERT INTO mcr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Apäkä apäqŋqä hui-pqä, aŋä-himqä iu pmetäniqe. Hea ique-iqueŋi, ii ämaqä iquenyqä äwätä, ‘Ämaqä nyinyqä wiuŋqä itäqä iqu, qui inyimäkätŋqä itqänä. Yätamäkqä nyiyä’ tuäqisquäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Kiŋganäŋi ämaqä jänä imäkqä iqu, qätä mäwiyqä da iquäniqe. Iŋi qänakndaŋi, iqu kŋuä tiiŋä indqänäniqe. ‘Nyi Goti Hanjuwä Iquenyqä zä miqä itmä, ämaqä iquauŋqä kŋuä mindqäŋqä qäyä pmetaŋgä, apäqŋqä täsi, nyi haŋä-iqä dapäqisqä-qae, täŋgaŋi, iiyqä kukŋui qätä äwimä. Nyi iiŋi miqä imqe, ii hea ique-ique ändäqisätä, enyqä nyimäkäŋqiyä’ kŋuä indqänäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iiŋqe, tiiŋä-pqä inä ätukqe. “Ämaqä kukŋuä jänä imäkqä quvqä iqueqä kukŋui, he qätä wipiyä. ");
INSERT INTO mcr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Qokä-apäkä, Goti Hanjuwä Iqu ‘ŋqeqä’ ätkqä iqua, qu Iqueqä yätamäkqeŋqä tääqä, hea ique-ique, hiunji ique-ique tätqätaŋguwäŋgaŋi, Iqu äpmaka äwäqe, iquauŋi, yätamäkqä maqänä mävqä yäniqätanä? ");
INSERT INTO mcr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nyi he etqä. Iqu yätamäkqä maqänä väniqe. Iŋäqe, Ämaqeuqä Ymeqä Ekqä Iqu äquvepätqäŋgaŋi, ämaqä qua täu äpmeŋuwi, quuvqä heqiyätqätaŋgä qunäniqätanä, quuvqä maeqiyqä itqätaŋgä qunäniqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ämaqä hŋqua, qu hŋqunä-hŋqunäŋi, kŋuä tiiŋä indqänmiŋuwi. “Nyi ämaqä huizi iqua eŋqä-paŋä hmanjqä. Nyi ämaqä äŋguä-qunjqä. Qu ämaqä quvqä-quaiqä.” Ämaqä iiŋä iquauŋi, Jisasi Iqu kukŋuä ktqe, tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ämaqä hŋquaqu, Goti Hanjuwä Iquenyqä tääqä siyŋqä, Iqueqä hiqäva-imäkqä aŋä yäpä iŋgisa penyiyi. Parisi hŋqutä, ämaqä mbqä motauqä hŋqutä. ");
INSERT INTO mcr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi iqu pämä ätqäuqe, Goti Iquenyqä tääqe, iqueqä-kiuäŋqä tii ätukqe. ‘Goti Hanjuwä Iquki, nyi ämaqä huiziqua eŋqä-paŋä-qunä hmanji. Iiŋiŋqe, nyi “äŋguiqä” äktqä. Quwä-meqä iquatä, suqä quvqä imäkqä iquatä, ämaqä hŋquauqä apäkitä ikiqä iquatä, mbqä motauqä näŋu-pqä eŋqä-paŋä-qunä, hmanjqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","‘Wikä eeqänäŋä iquauŋi, hiunji hŋquaquiŋi nyi buayä maŋqäŋqä imäkätŋqe. Nätmatqä eeqänäŋä nyi ämetŋqe, 10 iwäsäutmä, hŋqu Si äktapätŋqeqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Itaŋga, ämaqä mbqä motauqä iqu, kiŋä näŋi ätqäuqe, hiŋui qäukuä yätu moquŋqä da yäniqe. Iqu iqueqä suqä quvqeŋqä womba itä, quikuä ptqä äqänätä, tii tuäniqe. ‘Goti Hanjuwä Iquki, nyi ämaqä suqä quvqä imäk-qunji. Si nyinyqä qeqä äkimänänä.’ ");
INSERT INTO mcr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nyi tiiŋä etqä. Ämaqä tqu, aŋämqä aŋgi äwätäqäŋgaŋi, Goti Hanjuwä Iqueqä hiŋuä iqiŋi, aaŋä qäyunäŋä-qu hiäniqe. Itaŋga ämaqä huiziqu, hmanji. Quati tiinji. Ämaqä quwqä yoqe haqeu mamäŋgaŋguwä iquauŋi, Goti Hanjuwä Iqu mändi kittqiyeŋqiyä. Iŋäqe ämaqä iquauqä yoqe mändi kittqŋgaŋguwä iquauŋi, Goti Hanjuwä Iqu haqä iqä mamäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iŋgaŋi qokä-apäki, ymeqä wäŋqä iquautä, däŋä iquautä, Jisasi Iquenyqä ätuma äpkuwi. Ii, Jisasi Iqu iquauŋi hipa haqeqi wiyätŋqänä. Iŋäqe wäuŋuäŋqä ämotquamiŋqä iqua, hiŋuä e äqumbiyi, “Ätuma mapqä pambiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","I tquaŋguwäŋga, Jisasi Iqu ymeqä iquau tääqä ätuätumeqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, tii ätukqe. “Iqua änyimapŋqä qäyä äppu, ‘oeyä’ mätquä pambiyä. Goti Hanjuwä Iqunä miqeuŋi, ymeqä täsua eŋqä-paŋä isuauqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nyi naqä-qakuä etqä. Ämaqä hŋqu, ymeqä täsua eŋqä-paŋä eä, Goti Hanjuwä Iqunä miqe mämeqä imitätqe, iqu iuŋqe, mäwqä yäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ämiqä hŋqu Jisasi Iqueŋi, “Ämotqueqä Äŋguänäŋä Iquki, nyi häŋä hea ique-ique pmeqä mamqe, äänä imäkmqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","I tquaŋga Jisasi Iqu kimaŋi, “Si ‘Äŋguänäŋä Iqukiyqä’ suŋqä dnyä? Ämaqä äŋguänäŋi, Goti Hanjuwä Iqunänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Kukŋuä-suqeŋqe, si näqŋqä eäŋnä. ‘Qokä-apäkä ämaŋqe, huizitä huiwi yaŋä mikiqä panä. Ämaqä pizqä mapäsqä panä. Quwä mämeqä panä. Kukŋuä jänä imäkqä iqueŋi, quaŋgä mätquä panä. Tnaqä-tnuŋuauqä yäpä iqi qänaknä iqätŋqeqä’” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ga ämiqä iqu kimaŋi, “Nyi ymeqäŋgatqä suqä täuŋi qänaknä iqa äpätŋqe, täŋga täsuwänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisasi Iqu qätä iiŋä äwiyäqe, tii ätukqe. “Si nätmatqä hŋquenyqä äwa yqänä itqäŋinyä. Tqä nätmatqä eeqänäŋi, ämaqä hŋqua mbqä ipŋqä äma äwätnä, mbqä ämetnä, nätmatqä maeqä iquau iwäsäutnä, hmbunä-hmbunä wisŋqe. Si iiŋä imäkätŋi, qäukuä haqä yätuŋi nätmatqä äŋguänäŋi ämatŋi. Ii itnitaŋi, Nyi qänaknä nyivändiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ämiqä iqu iiŋä tqaŋgi äwiyäqe, iqueqä nätmatqä kuapänäŋä etaŋgqeŋqä, äwqä haŋä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iŋgaŋi Jisasi Iqu iiŋä äqunäqe, tiiŋä ätukqe. “Ämaqä nätmatqä kuapä-täŋä iqua, Goti Hanjuwä Iqunä miqä iu paquvqe, qeiqinyä manä, yäŋänäqŋqeuta paquvqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kametqä hŋqu, qäkä guä ktäpiqä yäŋä hovqä iu wätŋqe, iqu yäŋänäqŋqeutanä wänä. Iŋäqe, ämaqä mbqä kuapä-täŋä iqua, Goti Iqueqä miqeuŋqä paqupŋqä yäŋänäqŋqe, kametqä iqueqeuŋi ämäwqätäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","I tquaŋgi äwiyäpiyä iqua, “Mbqä kuapä-täŋä iqua yäŋänäqŋqeuta paqupŋqä etaŋgutqe, ämaqä qui imäknätqäŋuwitaŋi, häŋä hea ique-ique pmeqe, tqu meniqiyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ga Jisasi Iqu kimaŋi, “Nätmatqä ämaqä iqua änä mimäkqä iqaŋgpqe, Goti Hanjuwä Iqu qäyunä imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Iŋgaŋi Pitä iqu, “Qätä nyi. Ne neqä nätmatqä eeqänäŋi ae ävämetanä, Si äkivändqa äquvepqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","I tquaŋga, Jisasi Iqu kimaŋi, “Nyi naqä-qakuänäŋä etqä. Ämaqe, Goti Hanjuwä Iqunä miqä iuŋqä indqänäpiyä di, quwqä aŋä, ymeqä-apäkä, käta-käŋguäkau, kunaqä-kunuŋuau, ävämequwä iqua, qu qua täu yqänä äpmapiyäŋgaŋi, nätmatqä kuapänäŋä mapnä. Iiŋä ävquatämäupqä diŋqe, häŋä mapŋqä di ämäwqätäunä. Itaŋga hea qänakŋäŋgaŋi, häŋä hea ique-ique pmeqe mapnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iŋgaŋi Jisasi Iqu, Iqueqä ämaqä 12 iquau itmeqe, tii ätukqe. “Ne Jerusälemäŋqä watuŋqueqä. Itaŋga nätmatqä Goti Hanjuwä Iqueqä hiŋuä-tqä iqua, Ämaqeuqä Ymeqä Ekqä Iquenyqä ätukuwi, eeqänäŋi ätimäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Iŋi qu Iqueŋi, nokuiyqä iquauä hipa iu wipnuwiqä. Iŋgaŋi qu Ique ewiiqä kukŋuä ämitäpu, quvqä imäkäpu, makukuä äwuqutäpu, guä yäŋä-täŋi ämepu, täua ätäväpu, pizqä päkpnuwiqä. I etaŋgi hiunji hŋquaqu päwqaŋga, hŋquququeŋi ävauniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iiŋä etaŋgi wäuŋuäŋqä ämotquamiŋqä iqua, kukŋuä quatiŋqe, qu maqŋqä ekuwi. Kukŋuä ii iquauŋqä zä witaŋgi, qu iiŋqe näqŋqä äŋguänä miqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisasi Iqu, aŋä-himqä Jeriko timäutŋqä wätqätaŋga, ämaqä hiŋuä quvqä hŋqu, hänaqä maŋä iqi mbqäŋqä yatŋqä iqämanmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iqu ämaqä yukä äkakäqäqä pqaŋgä qätä äwiyäqe, yatŋqä ävätä, “He squä imäkätqäŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Qu kimaŋi, “Jisasi Nasäretqätaŋä Iqu äquvepqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iwä, ämaqä hiŋuä quvqä iqu tääqä yäŋänäqŋqä, “Jisasi Dewiti iqueqä Ymeqä Iquki, Si nyinyqä huäqä äkunänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","I tqaŋgi äwipiyi, ämaqä qaŋä hiŋuiqä äppiyä iqua, “Si maŋä matqä panä!” ätukuwi. Qu ii qäyä ätquaŋgä, iqu maŋä yäŋänäqŋqä, “Dewiti iqueqä Ymeqä Iquki, Si nyinyqä huäqä äkunänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Iŋgaŋi Jisasi Iqu äpmiŋqe, kiŋä nämä ätqäutä, “Ämaqä ique ätuma bpiyä” ätukqe. Ämaqä hiŋuä pisqä iqu, Iqu-täŋä qäqiqi pqaŋga, “Nyi äänä ikimäkmqä kiŋgiyä?” ätukqe. I tquaŋga iqu kimaŋi, “Naqä Iquki, ŋqä hiŋui äŋguä qänmqä änyiŋgiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","I tquaŋga Jisasi Iqu kimaŋi, “Tqä hiŋui äŋguä qändŋqinyä. Tqä quuvqä heqiyqe, äŋguä ikimäkqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iŋi maqänäŋi, iqueqä hiŋui äŋguä äqäŋgqe. Iŋgaŋi iqu Goti Hanjuwä Iqueqä yoqä haqeqä ämamäutä, Jisasi Ique qänaki äwivändqa äukqe. Qokä-apäkä hiŋuä iiŋä äqumbiyi, qu eeqänä Goti Hanjuwä Iqueä yoqe haqeqä ämamäukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iŋgaŋi Jisasi Iqu aŋä-himqä Jeriko iu yäpä iŋgisa äwäqe, jänänä hŋgisaŋqä wätŋqä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iqiŋi ämaqä hŋqu äpmamiŋqe. Iqueqä yoqe, Säkiyasi ique. Iqu ämaqä mbqä motauqä iutaŋä iquauqä ämiqä eä, mbqä kuapä-täŋä-que. ");
INSERT INTO mcr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","4","Iqu Jisasi Ique hiŋuä qunätŋqä winyätaŋgqä-qe, qokä-apäkä kuapänä etaŋguwiŋqä, ämaqä wäŋqäpu eä, Jisasi Iqueŋi hiŋuä änä mäquŋquä itä, hiŋuiqä tnäŋä äwiqe, hänaqä Jisasi Iqu pätŋqä iqaŋgqeu zä-eaqä haqeu äpäkekqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iŋgaŋi Jisasi Iqu, Säkiyasi iqu zä haqä yätu pmetaŋgqä-täŋä iqi ätimäuqe, hiŋuä haqä yätu äqunäqe, iqueŋi, “Säkiyasi iquki, si maqänä kapu. Täŋgaŋi Nyi saqä aŋä iu pmamqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Iŋgaŋi Säkiyasi iqu maqänä äkapäqe, aquvänä itä, Jisasi Iqueŋi, iqueqä aŋä duŋqä ätuma äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ämaqe, hiŋuä iiŋä äqumbiyi, qu eeqänä Jisasi Iquenyqä äkasuwi, tiiŋä ätkuwi. “Iqu ämaqä suqä quvqä imäkqä iqueqä aŋä du pmetŋqä, suŋqä uwqiyä?” ");
INSERT INTO mcr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Iquaqu aŋä du äpmayitaŋi, Säkiyasi iqu pämä ätqäuqe, “Naqä Iquki, qätä nyi. Ŋqä nätmatqä eeqänäŋi, hŋquaqu iwäsämi, hŋqu, ämaqä nätmatqä maeqä iquau wimqänä. Itaŋga nätmatqä huizi, ämaqeu quaŋgä ätuätmä ämotautŋqe, nyi hŋquaqui-hŋquaquiŋi iwäsäutmä, aŋgumä wimqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisasi Iqu kimaŋi, “Ämaqä tqu-pqe, iqu Aprähamä iqueqä ymeqeqä ämänätqueqetaŋi, täŋgaŋi Goti Hanjuwä Iqu, ämaqä aŋä täu äpmeŋuwä iquauŋi, aŋgu ae itmeqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ämaqeuqä Ymeqä Ekqä Iqu, ämaqä qui ae imäkŋguwä iquau qävqä itä, aŋgumä itmetŋqä äpkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iŋgaŋi qokä-apäkä, qu qätä iiŋä äwipu pmetaŋguwäŋga, Jisasi Iqu Jerusälemä timäutŋqä qäqiqi ti etaŋgi, ga qu, “Goti Hanjuwä Iqunä miqe, ätnäŋä iqi maqänä timäutŋqeqä” kŋuä indqänätqätaŋguwiŋqä, kukŋuä ktqä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ämaqä naqä hŋqu, qu ique ämaqä miqäŋqä teqaŋgä, ga iqu aŋgi äpätä, iqueqä qua iunä miniqä diŋqä, kiŋä nämqä ganä wätŋqä imäknäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Iŋi iqu äwätŋqä itäqäŋgaŋi, iqueqä wäuŋuä-wiyqä 10 iquau tääqä ätuätumeqe, mbqä-hikä naqä qu ‘minaqä’ ätmiŋuwi, hŋqunä-hŋqunä ävätä, tiiŋä tuäniqe. ‘He mbqä tä ämepu, nyi aŋgu äquvepmqäŋgaŋqä wäuŋuä mipiyä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Iiŋä etaŋgi ämaqä iqueqä aŋä-täŋä qäqiqisaŋä iquauqä äwqe, iquenyqä quvqä winyäniqe. Iutaŋi, iqu ae äwqaŋgaŋi, qu ämaqä hŋquau, ‘Ne ämaqä iqu ämineyätŋqä diŋqe, mäneŋqä iqiyä,’ tupnuwä diŋqä dowatpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Iiŋä qäyä itaŋguwä-qe, iqu iquau miqäŋqä heniqe. Itaŋga qänakndaŋi iqu aŋgu äpäqe, tiiŋä tuäniqe. ‘Ämaqä nyaqä wäuŋuä imäkpŋqä mbqä äwikqä iquauŋi, tääqä tupu. Nyi mbqä äwikqe, haqeqiŋi äänä imäsäumequwäti, nyi hiŋuä qunmqänänyä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ämaqä hiŋuiqä äpätqä iqu, ‘Ämiqä iquki, si mbqä mina hŋqunä ändapkŋi, haqeqiŋi mina 10 inä imäsäumeqeqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I tquaŋga, ämiqä iqu, ‘Täukue! Si nyaqä wäuŋuä-nyiyqä äŋguänäŋukiyi. Si nätmatqä wäŋqä täpiŋi äŋguänäŋä ämitqäŋiŋqe, nyi yoqä naqä, aŋä-himqä 10 hŋquau misŋqä ktapmqänä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Itaŋga wäuŋuä-wiyqä huiziqu äpäqe, ‘Ämiqä iquki, mbqä mina si ändapkŋi, haqeqiŋi mina 5 inä imäsäumeqeqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I tquaŋga, ämiqä iqu kimaŋi, ‘Si aŋä-himqä 5 hŋquauŋi ämisŋqeqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Itaŋga wäuŋuä-wiyqä huiziqu äyapäqe, ‘Ämiqä iquki, tqä mbqä täqi äwi. Nyi yutävqä huäqä äutätmä, imä zä ekqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ii tiinji. Si ämaqä qeiqinyä mimäkqukiyi. Ämaqä nätmatqä pŋqä epqe, ämequkiyi. Ämaqä buayä vowä ämäuepqe, äptqukiyi. Iutaŋi, nyi sinyqä zä nyiŋgaŋgi, imä zä ekqeqä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","I tquaŋga, ämiqä iqu kimaŋi, ‘Si wäuŋuä-nyiyqä quvqä iqukiyi. Si “Qeiqi mimäkqukiyqä” ändŋi, täŋgaŋi nyi si-pqe qeiqinyä mikimäkqä ymä. ");
INSERT INTO mcr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“Nyi ämaqä qeiqi mimäkqä-qunä, nätmatqä pŋqä epqe meqä-qunä, buayä vowä ämäuepqe ptqä-qunä” näqŋqä iiŋä enä etaŋgutqe, nyaqä mbqe, ämaqä ämiqä huiziquau mävqe, suŋqä ikŋäwä? Si iiŋä imäkqä-säpi, nyi aŋgu äpmqe, mbqä haqeqiŋi qäsä meqämiŋgä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","I ätuäqetaŋi, ämiqä iqu qokä-apäkä qäqiqi tqäutaŋguwä iuŋi, ‘He mbqä mina iqueqä hipa iuta ämotaupu, ämaqä mbqä 10-täŋä ique wipiyä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ga qu kimaŋi, ‘Ämiqä iquki, iqu mbqä mina 10 ae ämenä’ tupnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Iwä iqu kimaŋi, ‘Nyi he etqä. Ämaqä nätmatqä-täŋä eeqänäŋä iquauŋi, nyi hui inä wimniqe. I etaŋgi, ämaqä nätmatqä maeqä eä, wäŋqäpu ämeŋuwä iquauŋi, nyi aŋgi ämotaumqänä’ tuäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","‘I etaŋgi, nyiŋqä himä-wiuŋqä ipu, “Ämaqä tqu ne ämineyätŋqä diŋqe mäneŋqä iqiyä” ätukuwä iquauŋi, täqinyqä ätuma äpäpu, nyaqä hiŋuä täqi pizqä päkpiyä’ tuäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iŋgaŋi Jisasi Iqu kukŋuä ktqä iiŋä qäpu ätuäqe, Jerusälemäŋqä wätŋqä pämä ätqäuqe, qaŋä äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iŋgaŋi Jisasi Iqu aŋä-himqä Betäpake iutä, Betani iutä timäutŋqä äukqe. Iqu qoqoŋä, qu ‘Olipä’ ätämiŋuwä iŋgisa ätimäuqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋquaqui ändowatätä tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Qe aŋä-himqä näŋinyqä winyqä. Qe yäpä iŋgisa äwäsiyäŋgaŋi, doŋgi hikŋä hŋque guä äkiqiyequwä qunyinyä. Doŋgi iqueŋi, ämaqä hŋqu haqeqi mäpmeqä imiŋqä iquvi. Guä ewesinyä, täqinyqä ätuma binyä. ");
INSERT INTO mcr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","I iqaŋgiyäŋgaŋi, ämaqä hŋqu, ‘Qe doŋgi gue, suŋqä hiweqinyqä’ qesqaŋgutqe, qe kimaŋi, ‘Naqä Iqueqä wäuŋuä-täŋiqä’ tquinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ämaqä, Iqu ändowatkqä iquaqu äwiyi, nätmatqä eeqänäŋi, Iqu ätukqä-pa iiŋä witaŋgi äquŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iquaqu äwiyi, guä eweqaŋgiyäŋga, doŋgi iqueqä kawäkiqua iquaquiŋi, “Qe yaqueqä gue, suŋqä hiweqinyqä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iquaqu kimaŋi, “Naqä Iqueqä wäuŋuä-täŋiqä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iŋgaŋi, iquaqu doŋgi, Jisasi Iquenyqä ätuma äpiyi, gquä äquvätäsinyä, doŋgi iqueä haqeqi eiyi, Jisasi Iqu haqeqi pmetŋqä yätamäkqä äwikiyi. ");
INSERT INTO mcr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","I qäpu etaŋga, Iqu doŋgi iqueä haqeqä äpmeqe äwqaŋga, hŋqua quwqä gque äquvätäpu, hänaqä iqi ekuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hänaqä qoqoŋä Olipä-täŋä iuŋi ävquatämäutä, hänaqä mäŋgi nyeäqätaŋgqeu, ququawä iqi ätimäukqe. Iqiŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä kuapänäŋä iqua, Iqu wäuŋuä ämaqä änä mimäkqänäŋä di imäkqaŋgi äqunmiŋuwiŋqä kŋuä indqämbiyi, aquvänä ipu, Goti Hanjuwä Iqueqä yoqe, haqeu ämamäupu, tääqä yäŋänäqŋqä tii ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ämiqä Naqä, Goti Hanjuwä Iqueä yoqeu äpqäqä Iqu, Goti Hanjuwä Iqu äŋguä minä. Äwqä haŋuä iiŋqe, qäukuä haqä yätuta pänä. Itaŋga Goti Hanjuwä haqä naqä yämä äpmeŋqä Iqu, yoqe naqänäŋä äqonänä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","I iqaŋgä äqumbiyi, Parisi, ämaqä kuapänäŋä iiŋitä anä äpmamiŋuwä hŋqua, qu Jisasi Iqueŋi, “Näqŋqä-vqä Iquki, Si Tqä wäuŋuäŋqä ämotquetqäŋä iquauŋi, ‘Iiŋi mimäkqä pambiyä’ tuvä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iqu kimaŋi, “Nyi he etqänä. Iqua maŋä matqä iqaŋgpqe, hiki maŋä tpŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iqu aŋä-himqä Jerusälemä-täŋä qäqiqi ätimäuqe, aŋä-himqä iqueŋi hiŋuä äqunätä, kŋuä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kŋuä äqiyätä, tiiŋä ätukqe. “Aŋä-himqä Jerusälemä iquki, si täŋgaŋi nätmatqä äwqä qeiqi ikimäkqä diŋqe, näqŋqä hisŋqä änyiŋgiyä. Iiŋä etaŋgi nätmatqä iiŋi, zä witaŋgqe, si hiŋuä mäquŋquä itqäŋinyä. ");
INSERT INTO mcr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iŋi hea qänakndaŋi, tqä mäkä-huŋqä iqua äpäpu, qua pŋqä äkqumuatäpu, qäuiqä kktäupnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Qu äkqäyäpnasäpu, tqä ymeqä täkŋä yäpä iŋgisa äpmeŋuwä iquauŋi, qui imäkpnuwi. Itaŋga tqä hikä hui, huizi iqueqä haqä yäŋiŋi, mäwiqä yäniqe. Si Goti Hanjuwä Iqu äkimeqäqeŋqä maqŋqä etaŋgnä haŋä-iqe, ii kimeŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Itaŋga Iqu hiqäva-imäkqä aŋä täkŋä yäpä iŋgisa äpaquväqe, ämaqä nätmatqä mbqäŋqä imäkätqätaŋguwä iquauŋi, huätä päsäwqatätŋqä ipäqiyätä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Goti Hanjuwä Iqueqä bukä iuŋi, tiiŋä äqänänä. ‘Ŋqä aŋi, Goti Hanjuwä Iquenyqä tääqä tpŋqä mätnätätŋqeqä.’ Iiŋä etaŋgqä-qe, he quwä-meqä iquauqä aŋä zä pmeqä eŋqä-paŋä imäkätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iŋgaŋi Iqu hiunji ique-ique, Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋä iu, qokä-apäkä iquau näqŋqä äwimiŋqe. Iiŋä etaŋgi, hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, qokä-apäkä iu miqä hŋquatä, Ique pizqä päkpŋqä hänaqeŋqä qävqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Qävqä ipiyä-qe, qokä-apäkä eeqänäŋä iqua, Ique qätä tänä äwipu pmetaŋgä, hänaqe änä mämoqumueqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Hiunji hŋqueŋi Jisasi Iqu, qokä-apäkä iquau hiqäva-imäkqä aŋä iuŋi näqŋqä ävätä, kukŋuä we-huŋqä-täŋiŋqä awä tuätqätaŋga, hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, ämaqä naqä iquatä, Ique äwimapiyi, “Ne natiyä. Wäuŋuä Si imäkätqäŋiŋqe, yoqä naqä äŋgisa ämeŋäwä? ‘Si ii imäktŋqe’ tqu äktkqäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Qu yatŋqä ii vqaŋguwäŋga, Iqu kimaŋi, “Nyi-pqe, he kima dpŋqä, yatŋqä inä emqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonä asŋä-qäyqä iqu wäuŋuä imäkmiŋqe, yoqä naqe, qäukuä haqä yätuta ämakqäta, ä ämaqä iquauta ämakqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iqu kima ii tquaŋga, iqua, “Ne ‘Qäukuä haqä yätutaŋiqä’ tquaŋguatqe, Iqu tiiŋä natäŋqiyä. ‘He iquenyqä quuvqä maeqiyqe, suŋqä itqäŋuwäwä?’ ");
INSERT INTO mcr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Itaŋga ne, ‘Ämaqä iquautaŋiqä’ tquaŋguatqe, ämaqä eeqänäŋä iqua, ‘Jonä iqu hiŋuä-tqä-queqä’ näqŋqä yäŋänäqŋqä ämapiyitaŋi, hikä napäkpŋqäuä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","E ätmbiyitaŋi, Jisasi Iqueŋi, “Ne maqŋqeqä. Iqu äŋgisa ämakqätiyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","I tquaŋguwäŋga, Jisasi Iqu kimaŋi, “Nyi-pqe inänji. Nyi yoqä naqä-täŋä eämä, wäuŋuä e imäkätŋqeŋqe, he awä maetqä ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisasi Iqu ämaqä naqä iquau e ätuäqe, qokä-apäkä iquau kukŋuä ktqä tque ätukqe. “Ämaqä wäuŋuä itä, guä-wainqä vowä ikqä hŋqu, kiŋä nämqä näweqä wätŋqä, iqueqä wäuŋui, ämaqä hŋquau mbqä meqä imäkäpu, hui ique wipnuwäŋqä, yakuä äwimä wäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Qänakŋäŋgaŋi zä-häukuä mmqä iqaŋgaŋi, wäuŋuä kaniqu, iqueqä wäuŋuä-wiyqä hŋque, wäuŋuä miqä iqua, guä-wainqä häukuä hui iwäsäupu wipŋqä, dowatäniqe. Wäuŋuä-wiyqä iqu äwimeqaŋgaŋi, äpäsäpu, nätmatqä maeqä hiŋginäwa dowatpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","E imäkqaŋguwäŋga, wäuŋuä kaniqu, iqueqä wäuŋuä-wiyqä huizi hŋque, iquauŋqä inä dowatäniqe. Iqua iqueŋä-pqe quvqä itquepu, äpäsäpu, hiŋginäwa dowatpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Itaŋga qänakŋi, hŋque inä dowatqaŋga, iqu wäuŋuä miqä iquau äwimeqaŋga, qu ique ptqä äpäsäpu, ququawä mäŋgisa matnämäupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“I iqaŋgä äqunäqe, wäuŋuä kaniqu, ‘Nyi äänä imäkmqäwä?’ kŋuä vqaŋga, ‘Ŋqä ymeqä qokä, kiiŋä änyinätŋqä ique dowatmqänä. Qu iqueuä kukŋui, qätä wipŋqäpiyä?’ tnäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Iŋäqe, ymeqä iqu äpqaŋgaŋi, wäuŋuä miqä iqua hiŋuä äqumbiyi, tii tmbnuwi. ‘Wäuŋuä kaniqueqä ymeqä iqu äpqiyä. Kaniqu äpäkoŋgaŋgaŋi, nätmatqä eeqänäŋi, tätqu-qäqu meniqe. Iiŋiŋqe ne ique pizqä äpäsätanä, wäuŋui neqä nemänätŋqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Qu e ätmbiyi, iqueŋi wäuŋuä yäpaqä mäŋgisa ämatnämäupu, pizqä päkpnuwiqä. Iŋgaŋi wäuŋuä kaniqu, iquauŋi äänä imäkäniqäwä? ");
INSERT INTO mcr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iqu äpäqe, ämaqä iquauŋi, pizqä äpäsätä, wäuŋui, ämaqä hŋqua-mända väniqeqä” ätukqe. Itaŋga ämaqe, qu iiŋä äwipiyi, “Nätmatqä iiŋi, matimäuqä yäniqeqä. Oeyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kimaŋi e tquaŋguwäŋga, Jisasi Iqu hiŋuä yqänä äqunä, tiiŋä ätukqe. “He ‘oeyqä’ ätquwi, Goti Hanjuwä Iqueqä kukŋuä täu äqänäŋqe, qakui äkikä? ‘Ämaqä aŋä imäkqä iqua, “Hikä quvqeqä” ätäpu, huätä ämatnämäuquwi, hikä iqu aŋä quea eŋqä-paŋä, aŋä yäŋänäqŋqä imäkqä-queqä’ ätä äqänänä. ");
INSERT INTO mcr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Qokä-apäki, hikä iqueqä haqeqi päkmbqe, qui imäkmbŋqäuä. Hikä iqu haqä yätqä äwämitätqe, äpäqe, ämaqä pizqä päsäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","I tquaŋga, kukŋuä-suqeŋqä näqŋqä iquatä, hiqäva-imäkqä naqä iquatä, iiŋä äwipiyi, kukŋuä ktqe, iquauqä-quwäŋqä äyä uwqaŋgi näqŋqä ekuwi. Iŋgaŋi, qu Ique a maqänä kiqätanä-tpu ipiyä-qe, ämaqä huizi-pqä iquauŋqä kŋuä kuapänä indqänäpu, zä ipu, hiŋuinä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","21","Iŋgaŋi, kukŋuä-suqeŋqä näqŋqä iquatä, hiqäva-imäkqä naqä iquatä, Jisasi Iqueä kukŋui quwä mapŋqä diŋqä, hiŋuä äŋguänä äqumbu äpmamiŋuwi. Iŋgaŋi Ique yamwiqä äväpu, ämaqä naqä Romätaŋä iqueä hipa iqi wipnuwä diŋqä, iqua ämaqä tämaqä ipŋqä hŋquau ändowatkuwi. Tämaqä äukuwä iqua, quaŋgi, naqä-qakuä eŋqä-pa imäkäpu, yatŋqä tiiŋä äwikuwi. “Näqŋqä-vqä Iquki, ne näqŋqä ae ämequnä. Si kukŋui, jänäŋinä ätätnä, qokä-apäkiu naqä-qakuinä ämotquetqäŋinyä. Itaŋga iquau ämotquetŋäŋgaŋi, Si iquauqä yoqeŋqä kŋuä mindqäŋqä itnä, kukŋuä naqä-qakuinä ätätnä, Goti Hanjuwä Iqueqä suqeŋqä ämotquetqäŋinyä. ");
INSERT INTO mcr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","I etaŋgi Si kŋuä äänä kiyqiyä? Mbqä takisi, Romätaŋä iquauqä ämaqä naqä Sisa iqueŋi, ävquatuŋquätanä, mävqä iquatuŋquätanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Iqu, qu kukŋuä quaŋgä imäkäpu tquaŋguwiŋqä näqŋqä ae eäqe, kimaŋi, “He mbqä äma äpäpu, mändquapu. Mbqä iuŋi, ktqetänä, yoqetänä, tqueqäwä?” ätukqe. Qu kimaŋi, “Sisa Romätaŋä iqueqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ga, Iqu kimaŋi, “Nätmatqä Sisa iqueqä etaŋgutqe, ii ique wipŋqe. Iŋi, nätmatqä Goti Hanjuwä Iqueqä etaŋgutqe, Ique wipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iŋi, Iqu qokä-apäkä itä anä pmetaŋguwäŋgaŋi, ämaqä naqä iqua, Ique kukŋuä mitpŋqä diŋqe, kukŋui quwä mämeqä imiŋuwi. Iqu kukŋuä kimaŋi äŋguänäŋä dinä tquaŋgi äwipiyi, iqua yäuŋuä ipu, kukŋuä hui matqä ipu, qanyä äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Qänakndaŋi, ämaqä Satyusi hŋqua, Jisasi Iquenyqä äpkuwi. Satyusi iqua, “Ämaqä ae äpäkombqä iqua, aŋgumä mävauqä ipŋqäuä” tqä-quae. ");
INSERT INTO mcr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Iqua äppiyi, Jisasi Iqueŋi, “Ämotqueqä Iquki, Mosisi iqu bukä iuŋi, Israitqä iqunenyqä tiiŋä ätätä äqäkqe. ‘Ämaqä hŋqu apäkä ämetä, ymeqä maeqä äpäkonätqe, iquenyqä tŋäŋqe, käŋguequ apäqŋqä ämetä, ymeqä hemeŋqiyä,’ ätätä äqäkqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Itaŋga hiŋuiqänäŋi, ämaqä 7 hŋguiqua äpmamiŋuwi. Itaŋga iŋguiquautaŋi, kätequ apäkä ämeqe, ymeqä meämeqäŋga äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Itaŋga apäqŋqä iiŋi, käŋguequ ämeqe, iqu-pqä äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Itaŋga, käuŋgua huiziqu apäqŋqä asä iiŋi ämeqe, iqu-pqä inä äpäkoŋgqe. Ii tiiŋi. Eeqänäŋä iŋguiqua, apäkä iiŋi ämapiyi, qu ymeqä meämeqäŋga äpäkoŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Qänakndaŋi apäkä ii, inä äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Iŋi, ämaqä äpäkombqä iqua aŋgumä ävauqaŋguwäŋgaŋi, apäkä ämaqä iŋguiqua eeqä ämamiŋuwä täsi, tqueqä heäniqäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iqu kimaŋi, “Qokä-apäkä ämanätqäŋuwi, ii täŋganji. ");
INSERT INTO mcr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Itaŋgi qokä-apäkä, Goti Hanjuwä Iqu iquauŋqe, ‘Qu aŋgi ävaupu, Nyitä anä pmepŋqä qäyunäŋä iquaiqä’ täniqä iqua, qu iŋgaŋi mämaŋqä ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Goti Hanjuwä Iqu quŋi aŋgumä ae ävauqumuatätqä-qae, Iqueqä ymeqä eäpiyitaŋi, eŋätqä iqua eŋqä-paŋä eäpu, aŋgi mäpäkoŋqä da ipnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Iŋäqe, ämaqä ae äpäkombqä iqua, qua äptepqä duta aŋgi ävaupnuwä diŋqe, Mosisi iqu-pqä ae ämänätquakqe. Tiinji. Iqu kukŋuä, zä wäŋqä tä äsämiŋqeŋqä, bukiu äqiyätäqäŋgaŋi, tiiŋä äqäkqe. ‘Naqä Iqu, Aprähamä iqueqätä, Aisakä iqueqätä, Jekopä iqueqätä, iquauqä Goti Hanjuwä Iqueqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Itaŋgi Goti Hanjuwä Iqu ämaqä pizqä iquauqä ma, häŋä äpmeŋuwä iquauqä-quvi. Goti Hanjuwä Iqueqä hiŋuä iqiŋi, qokä-apäkä eeqänäŋi, awäka iiŋä iquatä qäsäŋi, häŋä äpmeŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","I tquaŋga, qu Iqueqä kimaŋiŋqä zä ipu, yatŋqä hŋqu inä mavqä ikuwi. Iutaŋi, kukŋuä-suqeŋqä näqŋqä hŋqua, “Ämotqueqä Iquki, Si kukŋui, äŋguänäŋä ätunyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iŋgaŋi Jisasi Iqu tii ätukqe. “Ämaqe, Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu Ique atäuŋuä ikqä Iquenyqe, ‘Dewiti iqueqä Ymeqä Iqueqe,’ näqŋqä äänä epu tätqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","I etaŋgqä-qe, apqä bukä iuŋi, Dewiti iqu tiiŋä ätkqeqä äqänänä. ‘Naqä Hanjuwä Iqu, ŋqä Naqä Ique tii ätukqeqä, “Nyi Tqä himä-wiuŋqä iquauŋi, Saqä yäpä iqi pmuatekimniqäŋgaŋqe, Si Nyaqä hipa ämuaŋgisa pmatŋqinyä” ätkqeqä’ äqänä. ");
INSERT INTO mcr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Iŋi änääŋgä? Kraisi Iquenyqe, Dewiti iqu ‘Ŋqä Naqä Iqueqä’ ätqeuä. Iŋi ämaqe, Iquenyqe, ‘Dewiti iqueqä Ymeqä Iqueqe,’ änääŋqä tätqäŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Itaŋga qokä-apäkä iqua qätä yqänä pänätaŋguwäŋga, Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kukŋuä-suqeŋqä näqŋqä iquauqä suqä quvqeŋqe, wa wipiyä. Qu suqä tquauŋqe, kiiŋä äwinyänä. Gquä quäuqä ipmbu qaŋä upŋqäuä. Ququawä aquväqŋqeuŋi, ämaqe iquauŋi, ‘hiunjiŋganjqä’ tupŋqäuä. Aŋä aquväqŋqeuŋi, aŋä äŋguä iqinyä pmapŋqäuä. Ymisaŋä naqä imäkqäŋgaŋä-pqe, aŋä äŋguä iqinyä pmapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iŋi qu apäqŋqä iuauŋi, quaŋgä ätuäpu, quwqä aŋi quwä mapŋqäuä. Qu tääqä quäuqä ätäpu, Goti Hanjuwä Iquenyqä quaŋgä tquäpŋqäuä. Iqu suqä quvqä iwäsäuniqäŋgaŋi, ämaqä iiŋä iqua, quwqä haŋä-iqe, ämaqä huizi iquauqe, ämäwqätäuniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iŋgaŋi Jisasi Iqu hiŋuä ämoqunäqe, ämaqä mbqä kuapä-täŋä iqua äpäpu, mbqä pŋqä-wiqä ipŋä iu mbqä tnämäuqaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iŋgaŋi apäqŋqä mbqä maeqä hui, mbqä wäŋqä hnjuaqu tnämäuqaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","E äqunäqe, tii ätukqe. “Nyi naqä-qakuä etqä. Apäqŋqä mbqä maeqä ii mbqä ätnämäuqe, qokä-apäkä eeqänäŋi, ämäwqätäuqi. ");
INSERT INTO mcr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ämaqä eeqänäŋä iqua, quwqä mbqä kuapä iutaŋi, wäŋqä hmbu ätnämäuqä. I etaŋgi ii äwa itä, ‘buayä mbqä iŋgmqä’ tä ämeŋqe, ätnämäuqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iŋgaŋi ämaqä hŋqua, hiqäva-imäkqä aŋä iuŋqä kukŋuä tii ätmiŋuwi. “Ämaqä aŋä ämätkuwä iqua, qu hikä äŋguänäŋitä, nätmatqä ämaqe Goti Hanjuwä Ique äwimiŋuwitä ämepu, aŋä tä äŋguänäŋä ämätkuwiqä” ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","I tqaŋgä äwiyäqe, Jisasi Iqu tii ätukqe. “Nätmatqä he hiŋuä äqunäŋuwä tä, qänakndaŋi hikä hŋqu, huizi iqueuä haqä yäŋi mäwiqä yäniqeqä. Qu eeqänäŋi ämisqiyäpu, qua mäŋi tnämäupnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iqu e tquaŋgaŋi, qu yatŋqä äväpu, “Näqŋqä-vqä Iquki, nätmatqä ii, hea äkŋga timäuniŋqäwä? Hiqŋqä äsque ganä timäuqaŋguti qunaniŋquwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iwä, Iqu kimaŋi, “Qu quaŋgä etäpu, hiqä kŋuä indqäŋqä qui emäkqäŋqe, he mimbiyä. Ii tiinjqä. Ämaqä kuapänä hŋqunä-hŋqunä äpäpu, Nyaqä yoqe etäpu, ‘Nyi ämaqä qäqunjqä’ hitpnuwiqä. Mä, ‘Hea qäqiqinjqä’ hitpnuwiqä. I etaŋgi he iquauŋi, qänaknä mäwivändqä iqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Itaŋga he, ‘Ämaqä qua huitaŋä-huitaŋä iutaŋi mäkä äuŋgäuä’ ä ‘Ämaqe, quwqä ämiqä iquau huätä dowatpŋqä mäkä itqäŋäuä’ tqaŋgä qätä äwiyäpiyäŋgaŋi, he zä ipu, yäuŋuä-yäuŋuä miqä pa iqäpŋqä. Nätmatqä tä ganä timäuniqä-qe, hea yäpaki maqänä matimäuqä yäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","I ätuäqetaŋi, tiiŋä ätukqe. “Ämaqä hŋqua, ämaqä huiziquatä mäkä humbŋqä ipäqäpnuwi. Itaŋga qua naqä iu miqä hŋqueqä ämaqe, huizi iqueqä iquatä mäkä humbŋqä ipäqäpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Qua huiuŋi, ekä itä, yäuŋuä-yäuŋuä naqänäŋä timäuniqe. Hŋqäqiŋi, buayä dä naqänäŋä timäuniqe. Hŋqäqiŋi, täŋä-yaqä naqänäŋä timäuniqe. Itaŋga qäukuä yätutaŋi, hiqŋqä naqänäŋä ätimäutä, he zä emäkäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","I etaŋgi nätmatqä iiŋi änyä etaŋgaŋi, qu a ekiqätäpu, quvqä emäkpnuwi. Qu Nyaqä yoqä mändi äkittqäpŋqä diŋqä indqämbu, aŋä aquväqŋqä iuŋi, kukŋuä ätäpu guä hikiqiyaupnuwiqä. Itaŋga etma äwäpu, ämaqä naqä huitaŋä-huitaŋä iquauqä hiŋuä iqi hekitqätepnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nätmatqä iiŋi emeqaŋgutqäŋgaŋi, ii hiqä kukŋuä äŋguä we-huŋqä-täŋi awä tpnuwäŋqä-ganji. ");
INSERT INTO mcr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Iiŋä emäkqaŋguwäŋga, he kukŋuä kima tupnuwä diŋqe, kŋuä ganä mindqäŋqä pa iqäpnä. ");
INSERT INTO mcr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nyi kukŋuitä, näqŋqetä, Ŋqä-näuä hitapmniqe. Ga ämaqä qui emäkätqäŋuwä eeqänäŋi, qu huätä ämaemäupu mändi maekittqiyqä ipnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Hiqä hinaqä-hinuŋuatä, hita-hiŋgukatä, itaŋga näueqä iquatä, qu hiqä mäkä-huŋqä iquauä hipa du hewipnuwi. Ga qu hesaŋä hŋquau pizqä päkpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","He Nyaqä yoqä-täŋuenä etaŋgä, ämaqä eeqänäŋi äwqä quvqä emäkpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iŋäqe heyaqä nyuäŋä iuŋi, dä hui qui näweqä mimäkŋqä yäniqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Iŋgaŋi he yäŋänäqŋqä äpmamipqe, he häŋä äŋguänä pmepnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","I ätuäqetaŋi tiiŋä-pqä inä ätukqe. “Jerusälemäŋi, mäkä-iqä iqua äpäpu, qäuiqä ktäuqaŋgä hiŋuä qumbiyäŋgaŋi, he näqŋqä tiiŋä hipnuwi. ‘Aŋä-himqe qui imäkpŋqä hea, qäqiqinjqä’ kŋuä heyquänä. ");
INSERT INTO mcr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iŋgaŋi qokä-apäkä qua Jutiya iu äpmeŋuwä iqua, ze, qoqoŋä yätuŋqä hipnuwi. Qokä-apäkä aŋä-himqä Jerusälemä iu äpmeŋuwä iqua, aŋä-himqä iuŋi äväma, huiuŋqä upnuwi. Itaŋga ämaqä Jerusälemä iu yäpaqäŋgisa äpmeŋuwä iqua, yäpäŋgisa mäpaquvqä ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Hea iŋgaŋi, Goti Hanjuwä Iqu, Iqueqä kukŋuä ätäŋqä-pa, naqä-qakuä iiŋä timäutŋqä diŋqe, iquauqä suqä quvqeŋqä iiŋä väniqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Itaŋga, apäkä äwqä-täŋä iuauŋqätä, ymeqä aŋuäŋqä-täŋä iuauŋqätäŋi, huäqä kiiŋä huŋqeqä. Ii tiinji. Haŋä-iqä naqänäŋä qua täu ätimäutä, Goti Hanjuwä Iqueqä äwqä tnäŋä iiŋqe, qokä-apäkä iŋga pmamipqä iquau wimeniqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Itaŋga hŋquauŋi ipäqäyuŋätä päkpnuwi, huiziquauŋi, ämaqä huiziquauqä wäuŋuä hiŋginäwa äwiyäpu pmepŋqä diŋqä, ätuma upnuwi. Itaŋga Jerusälemäŋi, Israitqä iquauqä nokuiyqä iqua, mändi äkittqiyäpu, hea Goti Hanjuwä Iqu iquauŋqä ätekqä iqu qäpu heqaŋgaŋqe, qui imäkqäŋqä pmetpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","I ätuäqetaŋi, tiiŋä-pqä inä ätukqe. “Hea iŋgaŋi, mäptqä iuta, qaŋuä iuta, qätäqueqä iuta, hiqŋqä huitaŋä-huitaŋä timäuniqe. Itaŋga qokä-apäkä qua täu im-imä äpmeŋuwä iqua, eqä-huäŋä äusuätä ämŋga peyqaŋgi äqumbiyäŋgaŋi, quwqä kŋuä indqäŋqe qui iwimäkqaŋguti, yäuŋuä-yäuŋuä ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Itaŋga nätmatqä qäukuä haqä yätutaŋi ävämapŋqä imäkqaŋgi äqumbiyi, qokä-apäki, ‘Qua täutaŋi squä timäutŋqätiyä?’ kŋuä indqänäpu, yäuŋuä-yäuŋuä ipu, hiŋuä qaŋä äma ikäpnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iŋgaŋi qu, Ämaqeuqä Ymeqä Ekqä Iqu qaquvqä iu äpme, Iqueqä yäŋänäqŋqetä, Iqueqä we-huŋqä naqänäŋä itä pqaŋgi qumbnuwi. ");
INSERT INTO mcr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hea nätmatqä tä änyä qe ipäqiyqaŋgaŋi, pämä yäŋänäqŋqä ätqäupu, hiŋuä haqä yätu quŋgpŋqä. Goti Hanjuwä Iqueqä etmetŋqe, qäqiqinjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","I ätuäqetaŋi, Iqu kukŋuä ktqä tiiŋä ätukqe. “He zä-eaqä iutä, zä huizi iquautä hiŋuä äqunäpu, näqŋqä mapiyä. ");
INSERT INTO mcr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","He zä-mŋä änyä-häŋä iŋgaŋgqe hiŋuä äqumbiyi, näqŋqä äyä etqäŋuwiqä. ‘Ii hea mäptqä äŋguä tätŋqäŋganjqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iŋi Goti Hanjuwä Iqunä miqä timäutŋqe, asä inänjqä. Nätmatqä Nyi täŋga etqe, ipäqiyqaŋgi hiŋuä äqumbiyäŋgaŋi, he näqŋqä hipnuwi. ‘Goti Hanjuwä Iqunä miqe, timäutŋqäŋganjqä.’ ");
INSERT INTO mcr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nyi he naqä-qakuä etqä, qokä-apäkä hea iŋga pmapnuwä iqua, qu mapäkoŋqä yqänä pmetaŋguwäŋga, nätmatqä eeqänäŋä iiŋi timäuniqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Qäukuitä, quaetä qui imäknäniqä-qe, Nyaqä kukŋui, qui mimäkŋqä yäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","I ätuäqetaŋi, tiiŋä-pqä inä ätukqe. “He äŋguänä mimbiyä. Eqä änäpu, hea ique-ique qämä-qämä iqe, ii quvqe. Nätmatqä hiqä huiwiŋqä kŋuä kuapä indqäŋqe, ii-pqe quvqe. He suqä iiŋä imäkqaŋgpqe, hea iqueŋi, guä eŋqä-pa maqänä heuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ii tiinji. Hea iŋgaŋi, nätmatqä Nyi etqe, qokä-apäkä qua täu äpmeŋuwä eeqänäŋä iquauŋi äwimeniqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Iŋi, nätmatqä eeqänäŋä iiŋä iqua, ämäequtäupnuwäŋqätä, Ämaqeuqä Ymeqä Ekqä Iqueuä hiŋuiqi tqäpnuwä diŋqetäŋi, he hea ique-ique äŋguänäŋä äminyäpu, Goti Hanjuwä Iquenyqä tääqä tqäpŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iŋgaŋi hiunji eeqänäŋä iuŋi, Jisasi Iqu, hiqäva-imäkqä aŋä ququawä iqi ämotquamiŋqe. Heatqäŋgaŋi Iqu qoqoŋä Olipä iu hiqaqä äwiqismiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Itaŋga qokä-apäkä eeqänäŋi, Iqueqä kukŋui qätä wipŋqe, ziŋuäŋga äquvepmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hiunji naqänäŋä qu “Bretqä yeŋuä qo matäuqä bŋqäŋganjqä” ätmiŋuwä iqu, ätimäutŋqä qäqi ekqe. Hiunji iquenyqe, qu Pasopa ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Iŋgaŋi hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, qokä-äpäkiuŋqä zä ipu, Jisasi Ique äpäkpnuwä diŋqä hänaqäŋqä qävqä ämävqänmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iŋgaŋi Setänä Goti Hanjuwä Iqutä mäkä-huŋqä iqu, Jutasi iqueqä äwqeu äpaqukqe. Qu iqueqä yoqe, “Iskarioti iqueqä” ätumiŋuwi. Iqu ämaqä 12 iquautaŋä ique. ");
INSERT INTO mcr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iqu äwäqe, hiqäva-imäkqä naqä iquautä, hiqäva-imäkqä aŋi qui mimäkqäŋqä miqä naqä iquautä, Jisasi Ique iquauqä hipa iu vätŋqä hänaqä diŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","I tquaŋga, iqua aquvänä ipu, “Mbqä hui ktapatuŋqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ita Jutasi iqu “äŋguiqä” ätuätä, Jisasi Iqueŋi iquauqä hipa iu vätŋqä diŋqä hea qäyunäŋäŋgaŋqä, qokä-apäki Jisasi Iqutä anä mäpmeqä etaŋguwäŋgaŋqä, hiŋuä äqunä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hiunji naqänäŋä bretqä yeŋuä qo matäuqä bŋqä iqu ätimäukqe. Quväukuä ique-ique hiunji iqueŋi, Israitqä iqua Pasopaŋqä kŋuä indqänäpiyäŋgaŋi, sipsipqä hui äpäsäpu gpnä. ");
INSERT INTO mcr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hiunji iqu ae ätimäuqaŋgaŋi, Jisasi Iqu, Pitä iquesä, Jonä iquesä ändowatätä, “Hiunji naqänäŋä tqueŋi, qe äwäsinyä, neyaqä buayi näwinyä nemäkinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","I tquaŋga, iquaqu yatŋqä äwikiyi, “Ye näwinyäŋi äŋgi imäkeŋqäwä?” ");
INSERT INTO mcr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mä Iqu kimaŋi, “Qe aŋä-himqä yäpä iŋgisa äyäsiyäŋgaŋi, ämaqä eqä-häkä qondä a qätqä hŋqu ämimbŋqäuä” ätukqe. “Qe ique qänaki wivändiyiŋqe. Aŋä iqu paquvqaŋgutqä iqueŋi, eequenä paqupiyä. ");
INSERT INTO mcr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Itaŋga aŋä kaniqueŋi, ‘Ämotqueqä Iqu, si yatŋqä kiyeŋqä äyandowatqiyä’ suinyqä. ‘“Nyitä, Ŋqä ämaqä wäuŋuäŋqä ämotquetŋqä iquatä, hiunji naqä tque, buayä natuŋquä aŋä hiqŋqä äŋgikä?” äyatqiyä’ suinyqä. ");
INSERT INTO mcr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iŋgaŋi iqu, aŋä hiqŋqä naqänäŋä haqä yätqä ämätnäŋqä iqueŋi ämäqesqueŋqiyä. Iquvaŋätä, buayä ŋqätä, näwenyä imäknänä. Qe iqiŋi, buayä näwenyä inemäkinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I tquaŋga, iquaqu äwiyi, nätmatqä eeqänäŋä Jisasi Iqu ätukqä-pa witaŋgi äqunyiyi, buayä näwenyä imäkkiyi. ");
INSERT INTO mcr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","15","Jisasi Iqutä, Iqueqä ämaqä wäuŋuäŋqä ändowatmiŋqä iquatä, buayä bŋqä äpmapiyäŋgaŋi, iquvaŋä iu äwi tii ätukqe. “Hiunji naqänäŋä tä ätimäuqä tqueŋi, Nyi buayä Pasopa tä, hesä natuŋqueŋqä kuapänä nyinätaŋgi äpmeŋänä. Buayä qäpu änani, Ŋqä huiwä täŋä-huŋqä mamqänä. ");
INSERT INTO mcr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nyi he etqä. Buayä Pasopa iqueqä quati, Goti Hanjuwä Iqunä miqä iuŋi naqä-qakuänäŋä timäuqaŋgaŋqe, Nyi ique aŋgu maŋqä iqämqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iŋgaŋi, Iqu wainqä-eqä-häkä ämeqe, Goti Hanjuwä Iquenyqä “äŋguiqä” ätuäqe, tii ätukqe. “He wainqä-eqä-häkä tä ämepu, wäŋqäpu-wäŋqäpu biyä. ");
INSERT INTO mcr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nyi he naqä-qakuä etqä. Täŋgata tiiŋi, Goti Hanjuwä Iqunä miqe äpqaŋgaŋqe, wainqä-eqä tä aŋgumä maŋqä iqämqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iiŋi qäpu ätuäqe, Iqu bretqä ämeqe, Goti Hanjuwä Iquenyqä “äŋguiqä” ätuäqe, äkutätä, iquau ävätä tii ätukqe. “Tä Ŋqä huiwä, he yätamäkqä hiyätŋqä etapqänä. Nyinyqä kŋuä indqänäpu, iiŋä imäkqäpŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Qu buayä qäpu gaŋguwäŋga, Iqu wainqä-eqä-häkä ämeqe, bretqeu imäkkqä-pa imäkäqe, tii ätukqe. “Wainqä-eqä-häkä tä, kukŋuä Goti Iqu hesä guä ämäsäuqä häŋiyi. Ii naqä-qakuä imäkätŋqe, Ŋqä häŋeqe, he yätamäkqä hiyquäniŋqä equatemqänä. ");
INSERT INTO mcr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iŋäqe qätä nyipiyä. Ämaqä, Nyi bäkpŋqä iquauqä hipa iu nyivätŋqä iqu, Nyitä iquvaŋä täuŋi anä äpmeŋue. ");
INSERT INTO mcr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ämaqeuqä Ymeqä Ekqä Iqu, hänaqä Goti Hanjuwä Iqu, Iquenyqä ätekqä iu wäŋqiyä. Iŋäqe ämaqä Nyi ämbäkpŋqä iquau nyivätŋqä iquenyqe, huäqä-huŋqe naqänäŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","I tquaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, iquauqä quwä yatŋqä änyäpu, “Suqä tä imäkäniŋqe, tqukiŋqä tqiyä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iŋgaŋi wäuŋuäŋqä ämotquamiŋqä iqua, “Neqä naqe, tqu pmeniqätiyä?” tpu, kukŋuä mäkä äunmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","E huŋgaŋguwäŋga, Jisasi Iqu tiiŋä ätukqe. “Ämaqä huizi iquauqä ämiqä naqä iqua, qokä-apäkiu wäuŋuä vqä iquaiqä. Iŋi naqä iquauŋqe, qu ‘Ämaqä yätamäkqä äŋguä vqä-quaeqä’ ätätqäŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","I etaŋgi he iiŋi mimäkqä pambiyä. Hiqä hitmqä iqu, hiŋgua yäpakä, yoqä maeqä-qu eŋqä-paŋä äpmenä. Hiqä ämeyqä iqu, wäuŋuä-eyqä-qu eŋqä-paŋä äpmenä. ");
INSERT INTO mcr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iŋi ämaqä buayä nätŋqä iquvaŋä iu äpmeŋqä iqu, ämaqä buayä meqisqä ique ämäwqätäunä. Iiŋä etaŋgi, Nyi hiqä wäuŋuä heyqä eŋqä-paŋä äpmeŋänä. ");
INSERT INTO mcr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Haŋä-iqä nyimeqaŋgaŋi, he manyivämeqä Nyitä anä äpmeŋquä iquenjqä. ");
INSERT INTO mcr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Iutaŋi Ŋqä Apiqu Nyi ämaqeu mimqä yoqä naqä ändapkqä-paŋi, asä iiŋi Nyi he etapqä. ");
INSERT INTO mcr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Iŋi Nyaqä ämaqeu miqä iuŋi, he Nyaqä iquvaŋä iu äpmapu, buayätä eqätä änäpu, itaŋga Israitqä iquauqä hueqä-himqä 12 iquau iwäsäupu, zä-hawä äŋguänäŋä iu pmeqäpŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","I ätuäqetaŋi, Iqu “Saimonä iquki, qätä nyiyä” ätukqe. “Setänä iqu, ämaqe kuä-witqä hinoqukuä huätä ämamäutqäŋuwä-pa, heqä quuvqä heqiyqe yamwiqä hiyätŋqeŋqä, Goti Hanjuwä Ique yatŋqä ae ävqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iiŋä etaŋgi, tqä quuvqä heqiyqe qui mimäkŋqä yätŋqe, Nyi Goti Hanjuwä Iquenyqä tääqä ae ätqeqä. Itaŋga si aŋgu äpätŋäŋgaŋi, tqä tta-tuŋguäkau yäŋänäqŋqä wisŋäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitä iqu kimaŋi, “Naqä Iquki, Sitä guäŋqä anä äwita, anä päkoneŋqä, näwinyä imäknmä äpmeŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","I etaŋgi Jisasi Iqu, “Pitä iquki, Nyi jänä äktqä. Heatqä tqueŋi, kukutakisqä äkakä matqäŋga, si Nyaqä yoqe, zä hŋquaqui-hŋque hisŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ita, eeqänäŋä iquauŋi, “Nyi hiqä mbqä qa mŋqetä, qa-pqetä, yukä ämuasmäuqetä, maeqä hendowatkqäŋgaŋi, he nätmatqeŋqä äwa ikuwätanä, äwa miqä ikuwätanä?” ätukqe. Iqua, “Äwa miqä ikqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ga Iqu tii inä ätukqe. “Iiŋä etaŋgi, täŋgaŋi, ämaqä mbqä-qa mŋqä-täŋä iqu, äma wätŋqe. Ämaqä qa-täŋä iqu, äma wätŋqe. Itaŋga ämaqä ipäqäyuŋä maeqä iqu, iqueqä gquä quäuqä ämetä, ämaqä hŋque mbqäŋqä imäkätä, ipäqäyuŋä mbqä yätŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ii tiinjqä. Goti Hanjuwä Iqueqä bukä iuŋi, ‘Qu iquenyqä “Ämaqä quvqueqä” ätkuwiqä’ ätä äqänänä. Nyi jänä etqä. Kukŋuä iiŋi, Nyinyqä aŋgi päŋqiyä. Kukŋuä eeqänäŋi, Goti Hanjuwä Iqueqä bukä iu Nyinyqä ätäŋqe, naqä-qakui täŋga ätimäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iŋgaŋi iqua, “Naqä Iquki, ipäqäyuŋä hŋquaqu täqiyqä” ätukuwi. Iqu kimaŋi, “Ii qäyunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iŋgaŋi, Jisasi Iqu aŋä-himqä iuŋi äväma, qoqoŋä Olipä, iŋga-iŋga iqismiŋqeuŋqä ekqe. Itaŋga Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iu ätimäupiyi, Iqu iquauŋi, “Yamwiqä iqe, he mändi maekittqiyqä yätŋqä diŋqe, Goti Iquenyqä tääqä tupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","E ätuäqetaŋi, äväma äwäqe, ämaqä hikä tnämäuqä-paŋä iiŋäqi ätqäwäqe, qoŋä äuktäutä, tääqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Apiquki, Si äkiŋgaŋgutqe, häkä haŋä-iqä-täŋä tqu huätä mändavä. Iiŋä etaŋgi Nyaqä änyiŋqeuŋi, qäyä enä. Tqä äkiŋqeu ätimäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","I tquaŋgaŋi, eŋätqä qäukuä haqä yätutaŋä hŋqu äwimeqe, Ique yäŋänäqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Itaŋga Jisasi Iqu haŋä-iqä naqänäŋä ämetä, tääqä yäŋänäqŋqä tquaŋga, Kiqä dŋi, häŋeqä eŋqä-paŋi, qua mäŋi iokqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Iqu tääqä qäpu ätuäqe, pämä ätqäutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋqä äukqe. Iquau äwimeqe, iqua äwqä haŋä naqänäŋä vqaŋgi, hiqaqä witaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E äqunäqe, “Suŋqä hiqaqä wiŋäuä? Ävaupu, yamwiqä iqe, he mändi maekittqiyqä yätŋqä, Goti Hanjuwä Iquenyqä tääqä tupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisasi Iqu kukŋuä yqänä tätqätaŋga, ämaqä kuapänä äpkuwi. Iqueqä ämaqä 12 iutaŋä hŋqu, iqueqä yoqä Jutasi, iqu iquau ätuma äpkqe. I ätuma äpäqe, Jisasi Iqu-täŋä qäqiqi, quneqä vätŋqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ii iqaŋgaŋi, Jisasi Iqu, “Jutasi iquki, si quneqä ävätnä, Ämaqeuqä Ymeqä Ekqä Iqueŋi ämaqä iuqä hipaeu wisŋqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ämaqä Iqutä anä äpmamiŋuwä iqua, nätmatqä ii timäuqaŋgi äqumbiyi, “Naqä Iquki, ne ipäqäyuŋitä ämaqä äpäsatuŋquätanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","E ätupiyi, iquautaŋä hŋqu, hiqäva-imäkqä naqä iqueqä wäuŋuä-wiyqä hŋqueŋi, ipäqäyuŋitä iqueqä qätä ämuaŋgisa mŋä hämänä ätqavämäukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","E iqaŋga, Jisasi Iqu “Qäyä enä” ätuäqe, qätä a ämaqätätä, aŋgu ämäqumuatekqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iŋgaŋi Iqu hiqäva-imäkqä naqä iquatä, hiqäva-imäkqä aŋä qui mimäkqäŋqä miqä naqä iquatä, Israitqä iquauqä ämaqä naqä iquatä, qu Ique a kiqätpŋqä äpkuwä iquauŋi, “He ipäqäyuŋitä, jävqätä a äqätqa äpquwi, ämaqä äpäsätä quwä-meqä hŋque a äkiqätätqäŋuwä-pa, Nyi-pqe, iiŋunä etaŋgi äŋgiqätqäuä? ");
INSERT INTO mcr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hiunji ique-ique Nyi hesä hiqäva-imäkqä aŋä ququawä iqi pmetaŋgaŋi, he a maŋgiqätqä itqäŋuwiqä. Iiŋä etaŋgi heatqä yäŋänäqŋqä ätimäuqäqe, ii hiqäŋganjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iqu i tquaŋga, iqua Ique a äkiqätäpu ätuma äupiyi, hiqäva-imäkqä naqä iqueqä aŋä yäpä iŋgisa ätuma ekuwi. E wätqätaŋguwäŋgaŋi, Pitä iqu kiŋä näŋi ti ätqawäwätä, qänaki äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Iŋgaŋi qu täkŋä yäpä yäŋgisa tä ikepu quamä pmeqaŋguwäŋga, Pitä iqu quvaqä awä iqi äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Qu e äpmetaŋguwäŋga, wäuŋuä iqä apäkä hui, Pitä iqu tä ttawä iqi pmetaŋgi äqunäqe, hiŋuä yäŋänäqŋqä äqunä, “Ämaqä tqu, Jisasi Iqutä anä äpmeŋiyiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","I tquaŋga Pitä iqu, “Apäkä iiki, nyi Iquenyqe, maqŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ga wäŋqäpu äpmapiyi, ämaqä hŋqu ique äqunäqe, “Si-pqä iquautaŋu-kiyqä” ätukqe. I tquaŋga Pitä iqu, “Ämaqä iquki, nyi hmanjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mä quäuqänä hmbu äpmapiyi, ämaqä huiziqu yäŋänäqŋqä ätukqe. “Ämaqä tqu, Galilisaŋä-qu hitaŋgi äqunätmä, ‘Iqu Jisasi Iqutä anä äpmeŋiyi-qe’ naqä-qakuä etqänä.” ");
INSERT INTO mcr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","I tquaŋga Pitä iqu, “Ämaqä iquki, si kukŋuä ii ätŋi, nyi maqŋqeqä” ätukqe. Iqu kukŋuä yqänä tätqätaŋga, kukutakisqä äkakä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Asä qäŋgaŋi, Naqä Iqu hiqumuaŋä äwiyätä, Pitä ique hiŋuä ämoquŋgqe. Iŋgaŋi Pitä iqu, Naqä Iqu, “Heatqä tqueŋi, kukutakisqä äkakä matqäŋga, si Nyinyqe, ‘Maqŋqeqä’ hŋquaqui-hŋque ttŋiqä” ätukqeŋqä kŋuä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iiŋä iqe, yäpaqä mäŋgisa äwätä, kŋuä naqänäŋä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Iŋgaŋi ämaqä Jisasi Ique a äkiqätkuwä iqua, Ique kukŋuä quvqä ätuäpu, jävqä äpäkkuwi. Ga, tapätapi Iqueqä hiŋuiu ktqä äpmuatepu, tiiŋä ätumiŋuwi. “Si ‘Iqu bäsqiyä-qe’ hiŋuä eŋqä-pa natiyä.” ");
INSERT INTO mcr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Itaŋga iqua kukŋuä quvqä huisä qäsä ätumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","I imäkätqätaŋguwäŋga, mäptqä timäuqaŋgaŋi, qokä-apäkä iquauqä ämaqä naqä iqua, qu eeqänä aquvä äqäŋguwi. Ii hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatänji. Aquvä e äqämbiyi, Jisasi Iqueŋi iquauqä aquväqŋqä iuŋqä ätuma äupiyi, “Si Kraisi ne äminesŋqä Goti Hanjuwä Iqu atäuŋuä äkikqä Iquki sätäti, ‘Nyi Qäqunjqä’ natiyä” ätukuwi. Iqu kimaŋi, “Nyi he etqaŋgmdqe, he quuvqä maeqiyqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nyi he yatŋqä heyqaŋgmdqäŋgaŋi, he kimaŋi mandqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iiŋä etaŋgi, täŋgata tiiŋi, Ämaqeuqä Ymeqä Ekqä Iqu Goti Hanjuwä Iqueqä hipa ämuaŋgisa pmetäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","I tquaŋga, ämaqä eeqänäŋä iqua yatŋqä tiiŋä äwikuwi. “Si Goti Hanjuwä Iqueqä Ymeqä Iqukitanä?” Iqu kimaŋi, “Hiqä-hiuä ae äyä ätqäuä. Nyi Qäqunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","I tquaŋga, iqua “Ne Iqueqä suqeŋqä awä-tqä hŋquauŋqä tääqä matqä yatuŋque. Iqueqä-kiuä, maŋiuta tqaŋgi qätä qe äwiyäŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Iŋgaŋi ämaqä naqä eeqänäŋä iqua ävaupiyi, Jisasi Iqueŋi, Pailoti iquenyqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Äwimapiyi, Ique kukŋuä mitpŋqä ipäqiyäpu, Pailoti iqueŋi tiiŋä ätukuwi. “Ne Ämaqä Tqu quvqä tiiŋä imäkätqätaŋgi äqunätuŋque. Neyaqä ämaqä iquauqä kŋuä indqäŋqe qui iwimäkätä, ‘He Romätaŋä ämiqä Sisa iqueŋi, mbqä takisi mävqä pambiyä’ ätuätä, itaŋga Iqueqä-kiuäŋqe, ‘Nyi Kraisi, Goti Hanjuwä Iqu he ämemqä atäuŋuä änyikqä Iqunä, hiqä Ämeyqä Naqä Iqunjqä’ ätuätŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","I tquaŋguwäŋga, Pailoti iqu Jisasi Iqueŋi, yatŋqä tiiŋä äwikqe. “Si Israitqä iquauqä Ämiqä Naqä Iqukitanä?” Ga Jisasi Iqu kimaŋi, “Si qe ätnyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Iŋgaŋi Pailoti iqu, hiqäva-imäkqä naqä iquautä, qokä-apäkä iquautäŋi, “Ämaqä Tque kukŋuä mitmqä diŋqe, Iqueqä suqä quvqe, hiŋuä mäquŋquä eäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Iŋäqe, qu kukŋuä yäŋänäqŋqä tiiŋä hui ätukuwi. “Iqu aŋä-himqä eeqänäŋä qua Jutiya iuŋi, qaŋä yäkenä itä, ämaqeu näqŋqä ävätä, quvaqä äwqe, ävauqumuatätqänä. Iqu qua Galili iu ganä iäqetaŋi, täqinyqä äpqäqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailoti iqu, ii tqaŋgä äwiyäqe, “Ämaqä Tqu, Galilisaŋä Iqutanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Qu “Ŋŋqä” tquaŋguwäŋga, iqu, “Jisasi Iqu Heroti iqueqä ämitŋqeuta äpqäqeqä,” kŋuä vqaŋgi, Heroti iquenyqä ändowatkqe. Hea iŋgaŋi, Heroti iqu Jerusälemä iu yakuä pmetaŋganji. ");
INSERT INTO mcr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroti iqu Jisasi Ique hiŋuä äqunäqe, iqu aquvänä ikqe. Ii tiinji. Hiŋuiqänäŋi Iqu ämaqä mimäkqänäŋä di imäkqaŋgi qätä äwimiŋqeŋqä, Ique hiŋuä qunätŋqä äwinyätä, “Iqu nyaqä hiŋuä iqi, ämaqä mimäkqänäŋä di imäkänä” kŋuä vqaŋgi äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ique äwimeqaŋga, nätmatqä kuapänäŋiŋqä yatŋqä vqaŋgqä-qe, Jisasi Iqu kimaŋi mätquä ikqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","E tuätqätaŋga, hiqäva-imäkqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, qäqi ätqäupu, Ique kukŋuä yäŋänäqŋqä ämitkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Iŋgaŋi Heroti iqutä, iqueqä mäkä-iqä iquatä, Ique quvqä imäkäpu, kukŋuä quvqä ätuäpu, gquä hämänäŋä äŋguänäŋä hŋqu ämepu äwiyätäpu, Pailoti iquenyqä aŋgu ändowatukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hiŋuiqänäŋi Heroti iqutä, Pailoti iqutä, himä-wiuŋqä äpmamiŋiyä-qe, hiunji iqueŋi, iquaqu näueqä imäkŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Ique aŋgi wimeqaŋga, Pailoti iqu hiqäva-imäkqä naqä iquauŋqätä, ämaqä naqä iquauŋqätä, qokä-apäkä iquauŋqätä, tääqä ätuätä aquvä ämaqiyäqe, tii ätukqe. “He Ämaqä Tquenyqä nyitä kukŋuä jänä imäkatuŋquä ätuma äpäpu, tii ändquwiqä. ‘Ämaqe, qu gapmanqä iquauŋi hŋgisanä itquapŋqe, Ämaqä Tqu quvaqä kŋuä indqäŋqe qui imäkätqänä.’ Iŋäqe, nätmatqä he ändquwiŋqe, nyi hiqä hiŋuä iqiŋi yatŋqä ämitmäŋgaŋi, Iqueqä suqä quvqe mämoqumueqä iqänä. ");
INSERT INTO mcr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Itaŋga Heroti iqu-pqe mämoqumueqä itä, nenyqä aŋgi ändowatqiyä. Ne Ique pizqä päsatuŋquä diŋqe, Iqueqä quvqe, hma etaŋgi äqunäŋueä. ");
INSERT INTO mcr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Iiŋiŋqe, nyi täŋä-huŋqenä äwimi, hiŋuinä qunäwatmqänä.” ");
INSERT INTO mcr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","I tquaŋga, qu eeqänäŋi, maŋä yäŋänäqŋqä ätäpu, “Ämaqä Tqueŋi, pizqä äpäsätnä, Baräpasi iqueŋi nenyqä vquatäwatiyä!” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baräpasi iqu, Jerusälemäŋi, gapmanqä iquatä mäkä äunäpu, ämaqä pizqä päsqaŋgi, guä äpmuatekuwä iquvi. ");
INSERT INTO mcr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Iŋgaŋi, Pailoti iqu Jisasi Ique ävquatäwatätŋqeŋqä wiŋgaŋgi, aŋgu ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Iŋäqe qu maŋä yäŋänäqŋqä tiiŋä ätukuwi. “Zä-huätatä hueyä! Zä-huätatä hueyä!” ");
INSERT INTO mcr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ga aŋguŋi, “Suŋqäwä? Iqu suqä quvqe, äki imäkätŋqäwä? Ne Ique pizqä päsatuŋquä di, nyi Iqueqä suqä quvqä hui mämoqumueqä iqä-qae, täŋä-huŋqenä ävätmä, hiŋuinä qunäwatmqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","I tquaŋgqä-qe, qu maŋä yäŋänäqŋqä, “Jisasi Iqueŋi pizqä päkiyä!” ätqua äupiyi, iqueqä maŋi mändi äkittqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iŋi Pailoti iqu, “Iquauä äwiŋqä dunä qänaknä wimqeqä” ätŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ämaqä, gapmanqä iquatä mäkä äunäpu, huizique äpäkkqä iquenyqä ätukuwiŋqe, Pailoti iqu iqueŋi ävquatäwatkqe. Itaŋga Jisasi Iqueŋi, iquauä äwiŋqä iu qänaknä itä, ämaqä päsqä iquauqä hipa iu äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Qu Jisasi Ique ätuma äwäpu, ämaqä Saimonä Sairinisaŋä iqu, aŋä-himqä iuŋqä tä pätqätaŋgi a äkiqätäpu, zä-huätatä huŋqe, ique quamä äwiwätäpu, “Jisasi Ique qänaki wivändiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Iqua Ique ätuma wätqätaŋguwäŋgaŋi, qokä-apäkä kuapänä Ique qänaki äwivändkuwi. Iquautaŋä apäkä kuapänäŋä hiua, pmapqä ipu, kŋuä äqiyäpu, qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Qu iiŋä iqaŋguwäŋga, Iqu qänaki hiŋuä ämoqunätä, “Apäkä Jerusälemätaŋä iuenä, Nyinyqä kŋuä maqiyqä pambiyä! Hiqä-hiuäŋqätä, hiqä ymeqäŋqätä qäpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","“Qakui tiinjqä. Hea qänakndaŋäŋgaŋi, qu tii tpnuwi. ‘Apäkä qokitqä iuatä, ymeqä manyquä iuatä, ymeqä aŋuä mävqä iuatä, qu quwqä-quwä aquvänä iqäuä.’ ");
INSERT INTO mcr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hea iŋgaŋi, ‘Qoqoŋä iquenä, he qua täqi äpäknäpu, ktqä naqumuätäpiyä’ tpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ii tiinjqä. Täŋgaŋi qu zä eqä-täŋä eŋqä-paŋä-qunä, suqä tä nyimäkätqäŋuwi, iŋi suqä quvqä imäkqä, zä yäuä äpitŋqä eŋqä-paŋä iquauŋi, suqä äki iwimäkpnuwäŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Itaŋga Iqutä anäŋi, qu suqä quvqä imäkqä hŋquaqui-pqe, pizqä päkpŋqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Qu äupiyi, hipkä ‘Ämaqä nyuäŋiqä’ ätmiŋuwä iu ätimäupiyi, Jisasi Iquesä, suqä quvqä imäkqä iquaquisä, zä-huätatä äuekuwi. Ämaqä hŋquququ, Iqueqä hipa ämuaŋgisa, huiziqueŋi, hipa qunamäuqäŋgisa äuekuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ae äueqaŋguwäŋgaŋi, Jisasi Iqu, “Apiquki, iquauqä suqä quvqe, huätä mamäuvä. Nätmatqä tä nyimäkquwiŋqe, qu maqŋqeqä” ätukqe. Iŋgaŋi qu Iqueqä gquetä ämuasmäŋqetä iwäsäupu, kikiŋä mapŋqä häŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jisasi Iqu zä-huätatä huŋgaŋgaŋi, qokä-apäki hiŋuä äqumbu ätqäumiŋuwi. Ämaqä naqä iqua, Ique äkasuwä ätuäpu, “Iqu ämaqä huiziuŋi häŋä iqumuatqä-queqä. Itaŋga Iqu Kraisi, ne mineyätŋqä Goti Hanjuwä Iqu Ique atäuŋuä ikqä Iqu etaŋgutqe, Iqueqä-kiuä häŋä iqumuatnänä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Itaŋga mäkä-iqä iqua-pqe, Iqu-täŋä qäqiqi äpäpu, äkasuwä ätupiyi, wainqä-eqä yäŋänäqŋqä äväpu, “Si Israitqä iquauqä Ämiqä Naqä Iquki etaŋgutqe, Tqä-täuä yätamäkqä inyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Itaŋi Iqueqä nyuäŋä haqä yäŋiŋi, tuwaŋuä tiiŋä äqäkuwi. “Ämaqä Tqu, Israitqä iquauqä Ämiqä Naqä Iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Itaŋga ämaqä quvqä Jisasi Iqutä zä-huätatä anä äuekuwä iquaqu, huiziqu äkasuwä tiiŋä ätukqe. “Si Kraisi, ne äminesŋqä Goti Hanjuwä Iqu atäuŋuä äkikqä Iqukitanä? Si Qäquki etaŋgutqe, yätamäkqe, Tqä-täuä änyätnä, ye-pqe inä yesŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","I tquaŋga, ämaqä huiziqu qätä äwiyäqe, äkasuwä tii ätukqe. “Haŋä-iqä Iqu ämeqä-pa, si-pqä inä ämenyä. Si iiŋä ätätŋäŋgaŋi, Goti Hanjuwä Iquenyqä zä makiŋqä iqiyä? ");
INSERT INTO mcr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yeqä suqä quvqä imäkqeuta, haŋä-iqä tä meqaŋgueetaŋi, qu qäyunä yemäkqäuä. Iŋäqe Ämaqä Tqu, suqä quvqä maiqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iqueŋi qäpu ätuäqe, “Jisasi Iquki, Si Ämiqä Naqä äpmetŋäŋgaŋi, nyinyqä kŋuä indqäŋgtŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ga, Jisasi Iqu kimaŋi, “Nyi naqä-qakuä äktqä. Täŋgaŋi, si Nyitä qäukuä yäŋiŋi anä pmeŋqueä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Hiunji quemisqeuta, awiyqä 3 klokŋgaŋqä, mäptqä we mauŋqä itä, qua eeqänäŋä iuŋi hea äwäkqe. Iŋgaŋi, yuä naqänäŋä hiqäva-imäkqä aŋä yäŋgisa imaknmiŋqe, iŋgi-iŋgi äpkŋga äpäwäkqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iŋgaŋi, Jisasi Iqu tääqä yäŋänäqŋqä ätätä, “Apiquki, Ŋqä quuvqe, Tqä hipa iqi eqänä” ätukqe. E ätuäqe, qe äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ae äpäkoŋgaŋga, mäkä-iqetaŋä naqä iqu, hiŋuä e äqunäqe, Goti Hanjuwä Iqueqä yoqe haqeu ämamäutä, “Ämaqä Tqueä suqä quvqä imäkqe, aaŋqeqä. Ämaqä Jänänäŋä-queqä” ätkqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ämaqä eeqäpnä hiŋuä qumbŋqä aquvä äqänmiŋuwä iqua, nätmatqä ii timäuqaŋgi äqumbiyi, huäqä kiiŋä wuŋgaŋgqetaŋi, quwqä quikuiu ptqä äpäknäpu, aŋämqä aŋgi äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iŋäqe Jisasi Iqueqä käyämaqä iquatä, apäkä ique Galilisa äwivändkuwä iuatä, qu nätmatqä tä timäuqaŋgqeŋqä kiŋä näŋisa hiŋuä äqumbu ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iŋgaŋi ämaqä hŋqu äpmamiŋqe. Iqueqä yoqe Josepä ique. Iqu Israitqä iquauqä aŋä-himqä Arämatiyataŋä ique. Iqu ämaqä jänä-ŋu eä, Goti Hanjuwä Iqunä miqeuŋqä hiŋuä äqänä äpmamiŋqe. Iqu Israitqä iquauqä ämaqä naqä iquautaŋä-que. Iŋäqe, ämaqä naqä huizi iqua, Jisasi Ique qui imäkpŋqeŋqä kŋuä indqänätqätaŋguwäŋga, iqu, “äŋguiqä” matqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jisasi Iqu ae äpäkoŋgaŋga, iqu Pailoti iquenyqä äwäqe, Jisasi Iqueä huiwiŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pailoti iqu, “Yqä mayä” tquaŋga, iqu Jisasi Iqueä huiwi zä-huätatä äuekuwiuta äma äpätä, yuä huäqä äutätä, ämaqä qua ptŋqä iu ekqe. Ämaqä wiqä iuŋi, hikä mŋä ae ätäpqiyäŋuwä-qe, iuŋi ämaqä hŋque pŋqä maeqä iŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hiunji iqueŋi, Sämbatqä hiunji hapä pmeqä näwenyä imäkqäŋganji. Mä Josepä iqu ii imäkqaŋgaŋi, Sämbatqä timäutŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Itaŋga apäkä Galilisa Jisasi Iqutä anä äpkuwä iua, “Josepä iqu, Jisasi Iqueä huiwi qua äkiu pŋqä eäŋqutiyä. Ä äänä itä eäŋqutiyä” tpu, hiŋuä qumbŋqä, Josepä ique qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hiŋuä ae äqumbiyi, äväma äwäpu, marasinqätä, wetqä jinaŋä-weqätä näwinyä imäkepiyi, hiunji hapä pmeqäŋgaŋi, suqä ätäŋqä duŋi qänaknä ipu, hapä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hiunji hapä pmeqä ae äpäwqaŋgaŋi, ziŋuä matqäŋgaŋi, apäkä iua nätmatqä näwinyä ae imäkekuwi ämapiyi, ämaqä qua ekuwä duŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","Qu iqi ätimäupiyi, hikä qua hovqä iuŋi mäpmäwänätaŋgi äqumbiyi, yäpä yäŋgisa äpeyäpu, Naqä Jisasi Iqueqä huiwi mäwiqä itaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Qu iiŋä äqumbiyi, kŋuä kuapänä indqänäpu pmetaŋguwäŋga, ämaqä hŋquaqu, gquä hämänäŋä we-huŋqä ipŋqä, qäqiqi maqänä ätqäukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","I tqäuqaŋgiyäŋga, apäkä iua zä ipu, hipeŋuä qua bu epu äpmakuwi. Itaŋga ämaqä iquaqu tii ätukiyi. “Ämaqä häŋä Iquenyqe, he ämaqä pizqä iqua wiqeuŋi, suŋqä qävqä itqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iqu täqi mäwiqä inä, ae ävauqeqä. Mä Galili du yqänä äpmeqäŋga, kukŋuä etkqeŋqä kŋui aŋgi hiyätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iqu tiiŋä äyä etkqeqä. ‘Qu Ämaqeuqä Ymeqä Ekqä Iqueŋi, suqä quvqä imäkqä iquauä hipa iqi wipnuwiqä. Itaŋga qu Ique zä-huätatä huepnuwiqä. Hea hŋquaqu äwitqe, hŋquququeŋi aŋgi vauniqeqä’” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","I tquaŋgiyäŋga, iua Jisasi Iqu ätukqeŋqä kŋuä äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Iua iuŋi äväma äupiyi, ämaqä 11 iquautä, ämaqä huizi iquautä, nätmatqä hiŋuä äquŋguwiŋqä awä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Apäkä, ämaqä Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau, kukŋuä ätukuwä iua, ii tiiŋi. Mäliya Maktälataŋä ii, Jonai, Mäliya Jemisi iqueqä känäu, itaŋga apäkä huizi iuautä anä äpmamiŋuwä iuatä, iuayi. ");
INSERT INTO mcr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apäkä iuauqä kukŋuiŋqe, ämaqä iqua, “Kukŋuä qämä-qämä iŋqä änatqäuä” kŋuä vqaŋgi, quuvqä maeqiyqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Quuvqä maeqiyqä ipiyitaŋi, Pitä iqu pämä ätqäuqe, qua ekuwä iuŋqä tnäŋä äwäqe, qoŋä äuktäutä, yuä huäqä äutäpu ekuwinä witaŋgi äquŋgqe. Iŋgaŋi iqu nätmatqä iiŋä äqunätäqŋqä kŋuä kuapänä indqänätä, aŋgi äukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Itaŋga hiunji asä iqueŋi, wäuŋuäŋqä ämotquamiŋqä hŋquaqu, aŋä-himqä hmbinyqä äumiŋiyi. Aŋä ipiyqä yoqe, Emiyasiyi. Jerusälemätaŋi, kiŋä namji (11 kilomita). ");
INSERT INTO mcr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iquaqu qaŋä äwäsiyäŋgaŋi, nätmatqä eeqänäŋä ii ätimäukqeŋqä kukŋuä ätqämuiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iquaqu yatŋqä iŋgäwätqätaŋgiyäŋga, Jisasi Iqu iquaqu-täŋä qäqiqi äpätä, qaŋä anä äumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iquaqu Jisasi Ique hiŋuä äqunyiyä-qe, “Tä, Jisasi Iqueqä” kŋuä mindqäŋqä ikiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iŋi Iqu iquaqui tii ätukqe. “Qe qaŋä äpäsiyäŋgaŋi, squä-suaŋqä tätqäŋinyqä?” Iqu yatŋqä e vqaŋga, iquaquvqä hipeŋui huäqä-huŋqä-quaqu ätqäukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Itaŋi, iquaquisaŋä hŋqu, iqueqä yoqe Keleopasi iqu, kukŋuä kimaŋi tii ätukqe. “Ämaqä, aŋä-himqä huitaŋä-huitaŋä Jerusälemäŋi kuapänä äpmeŋuwä iutaŋi, nätmatqä täŋga ätimäuqeŋqe, Sinä qätä mäwiyqä iŋätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iqu i tquaŋga, Jisasi Iqu, “Squä nätmatqäwa?” ätukqe. Iquaqu kimaŋi, “Nätmatqä Jisasi Nasäretqätaŋä Ique äwimeqeŋqä ätqueä” ätukiyi. “Iqu hiŋuä-tqä-qu eä, Goti Hanjuwä Iqueqä hiŋuä iqisä, qokä-apäkä iuqä hiŋuä iqisä, wäuŋuätä kukŋuätä, yäŋänäqŋqä imäkqä Iqueqä. ");
INSERT INTO mcr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Neyaqä hiqäva-imäkqä naqä iquatä, ämaqä naqä huizi iqua-pqätä, qu Ique päkpŋqä kukŋuä ämitäpu, ämaqä iquauqä hipa iu ävquwiŋqätä, Ique zä-huätatä äuequwiŋqätä, ätätqäŋueä. ");
INSERT INTO mcr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kiŋganäŋi ne Ämaqä Iquenyqe, kŋui tiiŋä indqänätuŋque. ‘Ämaqä Tqu, qokä-apäkä Israitqä iqune aŋgi inätumeqä Iquvqä.’ Itaŋgi kukŋuä hŋqu inänji. Qu Ique äpäsquwäŋgaŋi, hea hŋquaqu ae äpäwqe, hŋqu täsuänä. ");
INSERT INTO mcr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Iŋi täŋgaŋi, apäkä nesaŋä hnjua, yäuŋuä-yäuŋuä iŋqä inemäkqäuä. Zä-hiŋuä maqŋqäŋga, qua equwä duŋqä äwäpu, Iqueqä huiwi hiŋuä moquŋqä ipiyi, ne änemepu tii änatqäuä. ‘Ne Goti Hanjuwä Iqueqä eŋätqä hŋquaqunä äqunäŋunä. Iquaqu, “Iqu häŋä äpmenä” änatqinyqä’ änatqäuä. ");
INSERT INTO mcr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Itaŋga ämaqä nesaŋä hŋqua, qua equwä iuŋqä äupiyi, apäkä iua änatquwä-pa, e äqunäŋäuä. Iqua Iqueŋi hiŋuä mäquŋquä iqäuä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","I tquaŋgiyäŋga, Iqu kimaŋi, “Qeyaqä kŋuä indqäŋqe, hmanjqä” ätukqe. “Kukŋuä hiŋuä-tqä iqua ätkuwä eeqänäŋi, naqä-qakuä ätimäuqeŋqe, suŋqä maqŋqä eŋinyqä? Qu Kraisi, Goti Hanjuwä Iqu ämineyätŋqä ätekqä Iquenyqe, ‘Täŋä-huŋqä tä ganä ämeqe, qänakndaŋi yoqä naqä meniqeqä’ äqäkuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","I ätuäqe, Iqu kukŋuä Mosisi iqutä, hiŋuä-tqä eeqänäŋä iquatä, bukiu äqiyäuŋuwiŋqä ätipäqiyätä, awä ätukqe. Goti Hanjuwä Iqueqä bukä iu Iqueqä-kiuäŋqä ätä äqänäŋqeŋqä, qakuä eeqänäŋi ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Iŋgaŋi qu aŋä iquaqu pmayŋqä-täŋä qäqiqi ätimäupiyi, Jisasi Iqu äwätŋqä imäkŋgaŋga, iquaqu, “Mäptqä ae äwiqe, hea hiätŋqä iqäqä-qae, Si yesä anä pmetuŋqueqä” ätukiyi. I tquaŋgiyäŋga, Iqu iquaqutä anä pmapŋqänä, aŋä yäpä yäŋgisa äpaqukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Qänakŋi, Iqu buayä bŋqä, iquaqutä iquvaŋiu anä äpmapiyi, Iqu buayä ämeqe, Goti Hanjuwä Iquenyqä ‘äŋguiqä’ ätäqe, äkutätä, iquaqui vätŋqä ipäqäkqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iqu ävätŋqä iqaŋga, iquaquiyqä hiŋui äŋguä äqänyiyi, “Tqu, Jisasi Iqueqä” näqŋqä ämakiyi. Iŋgaŋi Iqu maqänä imatneqaŋga, iquaqu Iqueŋi, hiŋuä mäquŋquä ikiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","E imatneqaŋga, iquaqu, “Ne hänaqeu äpätaqäŋgaŋi, Iqu ye kukŋuä äyätapätä, Goti Hanjuwä Iqueqä bukä iuŋi kukŋuä qakui ämäyätqueqaŋgqäŋga, yeyaqä äwqe, tä hänaqä eŋqä-pa äyasqeqä” ätŋgiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","I ätniyi, iquaqu Jerusälemäŋqä aŋgumä maqänä äukiyi. Iqi ätimävi, wäuŋuäŋqä ämotquamiŋqä 11 iquatä, ämaqä huizi iquatä, aquvä äqämbu pmetaŋgä äwimakiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Äwimeqaŋgiyäŋga, qu iquaqui, “Naqä-qakuiqä. Naqä Iqu aŋgu ävautä, Saimonä ique äwimeqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Itaŋi, iquaqu nätmatqä eeqänäŋä hänaqä du äwimakqeŋqä awä ätukiyi. Itaŋga iquaqu, “Ye Iqueŋi, buayä yätapqaŋganä hiŋuä äqunäŋueä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Qu kukŋuä i tqämanätqätaŋguwäŋga, Jisasi Iqu iquauä awä iqi ätqäukqe. I ätqäuqe, “Heqä äwqä haŋuä enyänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","I tquaŋga iqua yäuŋuä ipu, ‘Hikuapqeqä’ ätäpu, zä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iwä Iqu tii ätukqe. “Äwqä haŋuä miŋqä, kŋuä kuapänä suŋqä indqänäpu pmeŋäuä? ");
INSERT INTO mcr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nyaqä hipaitä, yukitäŋi, hiŋuä qumbiyä. Ii nyinjqä. Nyaqä huiwiu a äminyiyäpu, näqŋqä mapiyä. Nyi guwä-täŋä, yäŋä-täŋunjqä. Hikuapqä iqua, iiŋäqua manä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iqu iiŋä ätuäqe, Iqueqä hipaetä, yukitä ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iqua aquvänä ipiyä-qe, “Naqä-qakuätiyä? Quaŋgitiyä?” kŋuä indqänätqätaŋguwäŋga, Iqu, “He buayä hui ämeŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iqu e tquaŋga, iqua hämapäkä häkiyä äyäqäkuwi, hŋgiŋi, Ique äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iqu ämotauqe, iquauqä hiŋuä iqisa äŋgqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iŋgaŋi, Iqu tii ätukqe. “Nyi hesä yqänä äpmamäŋgaŋi, ‘Kukŋuä eeqänäŋä Nyinyqä, bukä Mosisi iqu äqäkqeutä, hiŋuä-tqä iqua äqäkuwiutä, apqä tqä iqua äqäkuwiutäŋi, ii naqä-qakuinä timäuniqeqä’ äyä etmiŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iiŋä ätuäqetaŋi, iqua Goti Hanjuwä Iqueqä bukä iu äqänäŋqeŋqä qakuä eeqänäŋiŋqä näqŋqä mapŋqä yätamäkqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ga tiiŋä-pqä inä ätukqe. “Goti Hanjuwä Iqueqä bukä iuŋi, tiiŋä ätä äqänänä. ‘Kraisi, Goti Hanjuwä Iqu ämeyätŋqä ätekqä Iqu, täŋä-huŋqä meŋqiyä. Itaŋga qua äptepqä duŋi, hiunji hŋquaqu äwitqe, hŋquququeŋi, aŋgi ävauŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Itaŋga ämaqä eeqänäŋä iuŋi, qu Iquenyqä awä tpuŋqäuä. Ämaqe, quwqä kŋuä äkunmäkmbu, suqä quvqe ävquatämäuqeŋqätä, Goti Hanjuwä Iqu äwqä haŋuä imäknätä, quwqä suqä quvqe huätä mamäuqeŋqätä awä tpuŋqäuä. Kukŋuä awi, Jerusälemä iu ganä tpuŋqäuä’ ätä äqänänä. ");
INSERT INTO mcr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","He nätmatqä tä hiŋuä äquŋguwiŋqe, awä-tqä-quenä epŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nätmatqä äŋguänäŋä Apiqu etapäniŋqä ätkqe, Nyi henyqä ändowatmqänä. He, yäŋänäqŋqä qäukuä haqä yätutaŋi emetqäŋgaŋqä, aŋä-himqä täu pmetpŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, aŋä Betani iuŋqä ätuma äukqe. Iqi ätimäupiyi, Iqueqä hipa haqä yätqä eätä, Goti Hanjuwä Iqu, iquau äŋguä miwiyätŋqeŋqä tääqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iqu e ätuäqe ävämeqaŋga, Goti Hanjuwä Iqu qäukuä haqä yätuŋqä ätuma qe ekqe. ");
INSERT INTO mcr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iŋgaŋi iqua qoŋä äuktäupu, Iqueqä yoqe haqeu ämamäupiyi, aquvänä ipu, Jerusälemäŋqä aŋgi äukuwi. ");
INSERT INTO mcr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iŋgata-tiŋi, iqua hiunji ique-ique, hiqäva-imäkqä aŋä ququawiu äpmapu, Goti Iquenyqä “äŋguiqä” ätäpu, Iqueqä yoqe, haqeqä ämamäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qua tqu mimäkqä änyä etaŋgaŋi, Kukŋuä Iqu ganä äpmamiŋqe. Itaŋga Kukŋuä Iqu, Goti Hanjuwä Iqutä anä äpmamiŋqe. Kukŋuä Iqu, Goti Hanjuwä Inäŋä-quvi. ");
INSERT INTO mcr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aiŋga nätmatqä mimäkqä änyä etaŋgaŋi, Kukŋuä Iqu, Goti Hanjuwä Iqutäŋi anä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iiŋä etaŋgi, Goti Hanjuwä Iqu nätmatqä imäkätäqäŋgaŋi, nätmatqä eeqänäŋä Kukŋuä Iquesanä imäkkqe. Hänaqä huiziutaŋi, nätmatqä hui, mimäkqä pa ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iiŋä etaŋgi Kukŋuä Iqu, häŋä-pmeqä quatä Iquvi. Itaŋga häŋä-pmeqä tqu, qokä-apäkä iuqä We-huŋqä Vqä Iquvi. ");
INSERT INTO mcr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","We-huŋqä Iqu, hea witaŋgqeuŋi, we eumäkätqätaŋga, hea iqu, Iqueŋi mämäwqätäuqä itŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Goti Hanjuwä Iqu ämaqä hŋque ändowatkqe. Iqueqä yoqe, Jonä iquvi. ");
INSERT INTO mcr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jonä iqu iŋgaŋi, We-huŋqä Iquenyqä qokä-apäkiu awä tquaŋgi, qu iqueä kukŋui qätä äwiyäpu, We-huŋqä Iquenyqä quuvqä heqäpŋqeŋqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jonä iqu We-huŋqä Iqu maetqe, iqu We-huŋqä Iquenyqä awä tuätŋqä iquvi. ");
INSERT INTO mcr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I tätqätaŋgaŋi, We-huŋqä naqä-qakuä qokä-apäkä eeqänäŋä we wumäkquätŋqä Iqu, qua täuŋqä pätŋqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kukŋuä Iqu qua täu äpmeŋqe, qua tqu Goti Hanjuwä Iqu Kukŋuä Iquesanä qäyä imäkkqäŋqä, qua täu äpmapiyä iqua Kukŋuä Iquenyqe, yoqä mäwqueqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iqu Iqueqä quae qäyä timäuqaŋgi, quvämaqä iqua, Iqueŋi mitmeqä danä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iŋäqe, Iquenyqä quuvqä eqiyäpu, itmakuwä iquauŋi, Kukŋuä Iqu qu Goti Hanjuwä Iqueqä ymeqä timäupŋqä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Qu Goti Hanjuwä Iqueqä ymeqä ätimäuquwi, qu hiŋgi ämaqä qua täutaŋä hŋqu hemeqaŋgi ätimäuquwä maetqe, Kaniqu Goti Hanjuwä Iqu imäkqaŋgi ätimäuquwi. ");
INSERT INTO mcr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kukŋuä Iqu, täkä ämaqä ne eŋqä-paŋä-qu imänätä, neyaqä awä iqi äpmamiŋqe. Iqu ämaqeŋqä kuapä äwinyätä äŋguä Iwimäkqä-qu eä, itaŋga naqä-qakuänäŋiŋqä Motqueqä Iquvi. Itaŋga Ymeqä Kiuänäŋä Iqu, Iqueqä Kaniquesa yäŋänäqŋqä ämeqäqä di, ne hiŋuä äqunäŋque. ");
INSERT INTO mcr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iiŋä etaŋgi, Jonä iqu Iquenyqe awä-tqä-quvi. Maŋä yäŋänäqŋqä tii ätukqe. “‘Ämaqä nyaqä tuwiu qänaki pätŋqä Iqu, Iqueä yoqe, nyaqeuŋi ämäwqätäuŋqiyä’ etätŋqä Iqu, Iqu tä Qäquvi. I ätätŋqe, quati tiiŋä etaŋgiyi. Nyi nipai manyinyquäŋgaŋi, Iqu äpmamiŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iqu ämaqeuŋqä kuapä äwinyätä äŋguä Iwimäkqä-qu eä, neŋi nätmatqä äŋguänäŋi, tätä änätapätqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kukŋuä-suqeŋqä näqŋqe, ne Mosisi iquesa ämequä äyuwä. Goti Hanjuwä Iqueqä ämaqeŋqä äwinyätä äŋguä iwimäkqeŋqätä, Iqueqä suqä naqä-qakuiŋqätä näqŋqe, Jisasi Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Iquesa ämeque. ");
INSERT INTO mcr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ämaqä-pqä hui Goti Hanjuwä Iqueŋi hiŋuä ae äqunätqäŋuwä hmanji. Iŋi Iqu Goti eä, Ymeqä Hŋqunäŋä, Kaniqutä anä äpmanyä Iqu, neŋi Goti Hanjuwä Iquenyqä ämänätqueqi. ");
INSERT INTO mcr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä iqua, ämaqä Goti Hanjuwä Iquenyqä hiqäva-qäyqä hŋquatä itaŋga, Iqueqä aŋiu wäuŋuä imäkqä hŋquatä, Jonä iqueŋi, “Si tqukikä?” ätuäpu, ique yatŋqä wipŋqä, Jerusälemäta dowatqaŋguwäŋga, Jonä iqu awä tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iqu qätenä mäwiyqä itä, äti tii ätukqe. “Nyi Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä iqunä maetqenä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Iŋi si tqukikä? Si Laisa iquki maeqä enä?” ätuäpu yatŋqä äwikuwi. I tquaŋguwäŋga, Jonä iqu, “Nyi Laisa iqunä maetqenä” ätukqe. “Iŋi Mosisi iqu hiŋuä-tqä hŋquenyqä ätkqe. Si qäquki maeqä enä?” ätuäpu yatŋqä vqaŋguwäŋga, iqu “Oeyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Iqu “Oeyä” i tquaŋgaŋi, “Ämaqä ne änandowatquwä iquau aŋgumä äwätanä tuatuŋqueŋqe, si tqukiyi? Iŋi si tqä-täuŋqe, äänä ttŋqäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","I tquaŋguwäŋga, Jonä iqu kukŋuä hiŋuä-tqä Asayä iqu ätkqeuŋi, ämetä ätukqe. “Nyi ämaqä aŋä avqŋqä imda maŋä ätätmä, ‘Naqä Iqueqä hänaqe jänänä imäkpiyä’ tqä iqunjqä.” ");
INSERT INTO mcr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","I tquaŋguwäŋgaŋi, ämaqä i ändowatkuwä Parisi iqua, iqueŋi yatŋqä ämipu tii ätukuwi. “Si Kraisi Iquki maeqä eäŋnä, Laisa iquki maeqä eäŋnä, itaŋga hiŋuä-tqä iquki maeqä eäŋi, iŋi si ämaqä asŋi, suŋqä qäyätqäŋinyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I tquaŋguwäŋga Jonä iqu, “Nyi asŋi, eqetä äqäyätqäŋänä. Iŋäqe, heyaqä awä iqiŋi, hŋqu ätqäuä. Iquenyqe, he änyä maqŋqä eäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iqu nyaqä tuwiu qänaki pätŋqä Iquvi. Itaŋga Iqueä yukä muasmäŋqä quvätmŋqe, nyi äŋguänäŋunä maeqä iŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kukŋuä iiŋi, eqä Jotänä yätäqä näŋgisa aŋä-himqä Betani iu ätŋguwi. Iqiŋi, Jonä iqu ämaqä asŋä äqämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kukŋuä i ätŋguwä awiŋgaŋi, Jonä iqu, Jisasi Iqu iquenyqä pqaŋgi äqunäqe, “Goti Hanjuwä Iqueqä Sipsipqä Meqä, ämaqä qua täutaŋä iquauqä suqä quvqä huätä mamäuqä Iqu, Täsqukänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“‘Ämaqä nyaqä tuwiu qänaki pätŋqä Iqu, Iqueä yoqe nyaqeuŋi ämäwqätäunä’ ätätmä, itaŋga ‘Nyi nipai manyinyquäŋgaŋi, Iqu ganä äpmamiŋqeqä’ ätätŋqä Iqu, nyi Ämaqä Tquenyqä ätätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Ämaqä Tquenyqe nyi maqŋqä ekqä-qe, Israitqä iqua Iquenyqä näqŋqä hipŋqeŋqä äpätmä, eqetä asŋi i äqäyätqäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonä iqu iqueqä hiŋuitä hiŋuä äquŋgqeŋqä, “Qäukuä yätutaŋi, Dŋä Äŋguä Iqu yŋŋä-heeqä eŋqä-pa äpäqe, Iqutä pmeqaŋgi äqunäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Ämaqä Tquenyqe nyi änyä maqŋqä ekqä-qe, nyi asŋi eqetä qämqä änändowatkqä Iqu tii ändkqe. ‘Si tqä hiŋuitä Dŋä Äŋguä Iqu äpätä, ämaqä hŋqutä pmeqaŋgi äqunäŋi, Ämaqä ii Qäqu, ämaqeu Dŋä Äŋguä Iqutänä asŋä qiyäniŋqe, Qäqueyqä,’ ändkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","“Nyi ŋqä hiŋuitä hiŋuä äqunäŋqä etaŋgi, nyi he i etqä, ‘Tqu Goti Hanjuwä Iqueqä Ymeqä Qäquvqä’” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Aŋgumä awiŋga-mändaŋi, Jonä iqu iqueqä wäuŋuäŋqä ämotquamiŋqä hŋquaqutä ätqäupu, Jonä iqu, Jisasi Iqu sä mäwqätäuqaŋgi äqunäqe, “Goti Hanjuwä Iqueqä Sipsipqä Meqä Iqu, Näŋqiyqukuänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Itaŋi wäuŋuäŋqä ämotquamiŋqä iquaqu i tqaŋgi äwiyi, iquaqu Jisasi Ique qänaki äwivändkiyi. ");
INSERT INTO mcr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iŋgaŋi Jisasi Iqu qänaki hiŋuä ämamäukqe, iquaqu Ique qänaki äyä wivändätaŋginyä äqunäqe, “Qe suŋqä qeŋgaŋgikä?” ätukqe. I tquaŋga iquaqu, “Lapai iquki, si äŋgi äpmanä ikitqäŋinyä?” ätukiyi. Kukŋuä ‘Lapaiqä’ ätnäŋqä tqu, ‘Näqŋqä-vqä iqukiyä’ ätnä. ");
INSERT INTO mcr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I tquaŋgiyäŋga, Iqu iquaquiŋi, “Qe Nyi äpmeŋqeuŋi, hiŋuä qunyiyäŋqänä äwanä” ätukqe. I tqaŋgi äwiyi, 4 klokä iuŋi, iquaqu Iqutä äupiyi, Iqu äpmamiŋqeuŋi hiŋuä äqunäsinyä, hiunji iqueŋi Iqutä äpmakiyi. ");
INSERT INTO mcr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jonä iqu i tqaŋgi äwinyä Jisasi Ique qänaki äwivändkiyä iquaqu, hŋqu Endru iquvi, Saimonä Pitä iqueqä käta-käŋguequ. ");
INSERT INTO mcr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Endru iqu Jisasi Iqueŋi äväma, Saimonä iquenyqä ganä äwäqe, “Ne Mäsayä iqueŋi hiŋuä äqunäŋunä” ätukqe. Kukŋuä Mäsayä ätnäŋqä iqu, ‘Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä iqueqä’ ätnä. ");
INSERT INTO mcr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","I ätuäqe, Endru iqu iqueŋi Jisasi Iquenyqä ätuma äukqe. Äwimeqaŋgiyäŋga, Jisasi Iqu Saimonä ique äqunäqe, “Si Saimonä iqukiyqä. Tqä tniqueqä yoqe, ‘Jonäuä’ ätmiŋuwi. Tqä yoqe, ‘Sipasiuä’ qondŋqeqä” ätukqe. Yoqä iiŋi, Pitä-qe, asä qeyi. Yoqä iquaquvqä quati, hikä äknänä ätnä. ");
INSERT INTO mcr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Awiŋgaŋi, Jisasi Iqu Galiliŋqä wätŋqä itä, Iqu Pilipä iquenyqä qävqä äwäqe, iqueŋi, “Nyi qänaki nyivändiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipä iqu aŋä-himqä Betsaitä pmeqä-quvi. Iŋi Endrutä, Pitätä, aŋä asitaŋä iquaquvi. ");
INSERT INTO mcr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Itaŋga Pilipä iqu, Nataniyoli iqueŋqä qävqä äwäqe, tii ätukqe. “Mosisi iqu, bukä kukŋuä-suqeŋqä ätnä qänätaŋgqä iu, ämaqä hŋquenyqä äqäkqe. Itaŋga hiŋuä-tqä-pqä iqua, asä iquenyqä tuwaŋuä äqiyekuwi. Ämaqä iqueŋi ae ämäqumuequnä. Iqu Jisasi, Josepä iqueqä hikŋä, aŋä Nasäretqä-taŋä-queqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","I tquaŋga Nataniyoli iqu, “Änäändiyä? Aŋä Nasäretqätaŋi, nätmatqä äŋguä hui timäuŋqutiyä?” ätukqe. I tquaŋga, Pilipä iqu, “Si äpätnä hiŋuä qunyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisasi Iqu, Nataniyoli iqu Ique wimetŋqä iqaŋgi äqunäqe, Iqu iquenyqe, “Israitqä naqä-qakui täsqukänä. Iqu suqä quaŋgä di, mimäkqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","I tquaŋga, Nataniyoli iqu, “Iŋi Si nyinyqe, näqŋqä äänä ämanä tnyä?” ätuätä, Jisasi Iqueŋi yatŋqä äwikqe. Yatŋqä e vqaŋgaŋi, Jisasi Iqu iqueŋi, tii ätukqe. “Pilipä iqu si änyä äkimetŋqä iqaŋgaŋi, Nyi si zä-eaqä iqueä quatä iqi pmetaŋgnä äkqänäŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","I tquaŋgaŋi, Nataniyoli iqu, “Näqŋqä-vqä Iquki, Si Goti Hanjuwä Iqueqä Ymequki eänä, itaŋga Israitqä iquneqä Ämäneyqä Naqä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","I tquaŋga, Jisasi Iqu, “Nyi siŋi, ‘Zä-eaqä iqueä quatä iqi pmetaŋgnä äkqänäŋqeqä’ ktqaŋgqeŋqä, si quuvqä i eqinyä. Nyi iiŋä äktqe, ii wäŋqe. Nätmatqä naqänäŋä hŋquauŋi, si qänaki hiŋuä qundŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisasi Iqu i ätuäqe, tii-pqä inä ätukqe. “Nyi he naqä-qakuä etqä. Qäukuä qŋqaŋä äutänätä, Goti Hanjuwä Iqueqä eŋätqä iqua, Ämaqeuqä Ymeqä Ekqä Iqueä haqeqisa äyäpu, äpäpu itqätaŋgpi, qumbŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Awiŋgataŋä huiziuŋi, aŋä-himqä Kana, qua Galili iuŋi, qokä-apäkä hiyaqu ämanyiyŋqä iqaŋginyä, Jisasi Iqueqä känae iu äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Itaŋga Jisasi Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, i maŋgaŋginyä iuŋqä kukŋuä tquaŋgä, iqua-pqe iu anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wainqä-eqe qäpu hiqaŋga, Jisasi Iqueqä känae, “Qu wainqä-eqe qäpu äŋgäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","I tquaŋgaŋi, Jisasi Iqu, “Naye, si iiŋi suŋqä dnyä? Ŋqä ii imäkqeŋqe, änyänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iŋgaŋi Iqueqä känae wäuŋuä imäkqä iquauŋi, “He Iqu hetqaŋgutqeunä imäkpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä suqä hŋqu tiinji. Goti Iqueqä hiŋuä iqi äŋguä hipŋqä diŋqe, qu asŋä äqänäpu akiyä änymiŋuwi. Eqetäŋi, iiŋä imäkmbŋqe, hikiu iquqonämäupu, eqä-häkä imäkkuwä 6 iqi ätqäumiŋuwi. Eqä-häkä iiŋä hŋqu iomäupqe, ämaqä hŋqu kiqä-kiuänä mämeqe, 100 litä-quayi. ");
INSERT INTO mcr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Känae i tquaŋga, Jisasi Iqu wäuŋuä imäkqä iquauŋi, “He häkä tquau eqä equatimepiyä” ätukqe. I tquaŋga, iqua häkä iquauŋi, maŋguä equatimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Iqua eqä i iomeqaŋguwäŋga, Jisasi Iqu, “He täŋgaŋi eqä hui iopu, ämaqä ymisaŋä miqä ique äma wipiyä” ätukqe. I tquaŋga, iqua Iqu tquaŋgqä-pa ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iŋgaŋi aaŋä eqe, wainqä heqaŋgi, ämaqä ymisaŋä miqä iqu yamwiqä ikqe. Wäuŋuä iqä eqä iopiyä iqua, qu wainqä-eqä hiqaŋgqeŋqä näqŋqä etaŋguwä-qe, ymisaŋä miqä iqu maqŋqä eä, iqu ämaqä apäkä meqaŋgqä ique kukŋuä ätuätumeqe, tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Ämaqe tii iqe. Wainqä-eqä äŋguänäŋi, ganä maepnä. Itaŋga qu eqä kuapänä änäpu, hiqiiyqä heqaŋguwäŋga, wainqä-eqä huizi di iŋga mapŋqänänyä. Iiŋä qäyä etaŋgi, si wainqä-eqä äŋguänäŋä zä eŋi, täŋga äyä ämaenyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nätmatqä ämaqä hui mimäkqä imiŋuwi, Jisasi Iqu aŋä-himqä Kana, qua Galili iuŋi, i qe imäkätä, Iqueqä yäŋänäqŋqe ämotquetä ipäqäkqe. I äqumbiyi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jisasi Iqu i imäkäqetaŋi, Iqutä, känaisä, käŋguäkatä itaŋga Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatäŋi, qu aŋä Kapänamäŋqä äwäkuwi. Itaŋga qu iqiŋi, hiunji hatŋä hmbu äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä hiunji naqänäŋä, Pasopa ätätqäŋuwä iqu qäqi etaŋgi, Jisasi Iqu Jerusälemäŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Äyäqe, iqiŋi Iqu Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋä ququawä iqiŋi, ämaqe qu bulumäka-sua, sipsipqä-sua, itaŋga yŋŋä-heeqä-sua mbqäŋqä imäkäpu, ga hŋqua quamä äpmapu mbqä yaŋä nyätqätaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iiŋä äqunäqe, Iqu guä hui ämeqe, äqäyäkoquvätä jävqä imäkäqe, hiqäva-imäkqä aŋä iutaŋi eeqänäŋä huätä äpäsäwqatkqe. Bulumäka-pqä, sipsipqä-pqä qäsänji. Itaŋga ämaqä mbqä huitaŋi tŋäŋqä imäkäpu vätqätaŋguwä iquauä mbqe bi ämäquvatämäutä, mbqä hevqe yiwaŋä ämamäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","I itä, ämaqä yŋŋä-heeqä mbqäŋqä imäkätqätaŋguwä iquauŋi, “Täqiŋi huätä äma äupiyä. Ŋqä Apiqueä aŋi, he mbqä meqä aŋä mimäkqä pambiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisasi Iqu i imäkqaŋga, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Goti Hanjuwä Iqueqä bukä iuŋi, “Goti Hanjuwä Iquki, saqä aŋiŋqä kuapänä änyinätäqe, nyaqä yäpä tämŋi änä manyimäŋqä iqiyä” tnätaŋgqeŋqä kŋuä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisasi Iqu i imäkqaŋgqeŋqä, Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä iqua, Iqueŋi, “Si nätmatqä ämaqä mimäkqä di äki imäktŋqäwä? Si nätmatqä imäkŋä tä, yoqä naqe äkita ämanä imäkinyä, ne mänätquayä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I tquaŋguwäŋga, Jisasi Iqu ätukqe. “Hiqäva-imäkqä aŋä tque huätä äpnemäpqe, aŋgumŋi Nyi hiunji hŋquaqu-hŋquenyä mätmqänä.” ");
INSERT INTO mcr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","I tquaŋga, Israitqä iqua tii ätukuwi. “Hiqäva-imäkqä aŋä tque mätätqätaŋgä quväukuä 46 ämäwqätäukqä eŋqe, Si ‘Nyi aŋgumŋi hiunji hŋquaqu-hŋquenyä mätmqänä-qe,’ änääŋqä tnyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisasi Iqu, Goti Hanjuwä Iqueqä aŋä iquenyqä ätukqe, Iqu Iqueqä huiwiŋqä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, kukŋuä i ätukqä iquenyqe, hui äwinymiŋqä-qe, Jisasi Iqu qua buta häŋä vauqaŋga, qu kŋuä iŋga äwikqe. Iŋgaŋi iqua Goti Hanjuwä Iqueqä bukiu tnätaŋgqeŋqätä, Jisasi Iqu ätkqeŋqätäŋi, quuvqä eqiyäpu naqä-qakuä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Israitqä iqua hiunji naqä Pasopaŋga, ämaqä kuapänäŋi, Jisasi Iqu Jerusälemä iqi äpme, hiqŋqä ämaqä hui mimäkqe imäkätqätaŋgi äqumbiyi, Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","I iqaŋguwä-qe, Jisasi Iqu ämaqä eeqänäŋäŋqä näqŋqä äŋguänäŋä eäqä-qae, Iqu quŋqä quuvqä maeqiyqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jisasi Iqueŋi, ämaqä hŋqu-pqe ämaqä hŋqueŋqe, ‘Iinjqä-iinjqe’ mätquä yänä. Iqu ämaqeuqä suqä eeqänäŋiŋqe näqŋqä hiänä. ");
INSERT INTO mcr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisi iquautaŋä hŋqu, iqueqä yoqe Nekitimäsi iquvi. Iqu Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä ämiqä iquautaŋä hŋquvi. ");
INSERT INTO mcr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Iqu Jisasi Iquenyqä heatqäŋga äpäqe, “Näqŋqä-vqä Iquki, ne näqŋqe, si näqŋqä motqueqä Goti Hanjuwä Iqu äkndowatqä Iqukiyqä” ätuätä, tii ätukqe. “Ämaqä hŋqu nätmatqä ämaqä hui mimäkqänäŋi Si imäkätqäŋä-paŋä iiŋi, mimäkqä danä yänä. Goti Hanjuwä Iqu iqutä anä sätäti, i imäkäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","I tquaŋga, Jisasi Iqu ämävauqe, “Nyi naqä-qakuänäŋä ktmqeqä. Ämaqä hŋqu, aŋgumä ymeqä däŋä hayuqä ii eŋqä-paŋä mimäŋqä itqe, iqu Goti Hanjuwä Iqunä miqä duŋi, hiŋuä mäquŋquä danä iquäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Itaŋi Nekitimäsi iqu yatŋqä tii äwikqe. “Iqu ae ämaqä naqä qoyaŋä eŋqe, ymeqä däŋä hayuqä ii eŋqä-paŋi, äänä itä imänätŋqäwä? Iqu känai iqueŋi aŋgumä nyuetŋqä diŋqe, känäwä äwqä imŋi aŋgumä mamŋqä yäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ga Jisasi Iqu ämävauqe, “Nyi naqä-qakuänäŋä ktmqeqä” ätukqe. “Ämaqä hŋqu eqetä, itaŋga Dŋä Äŋguä Iquesatä, ymeqä däŋä hayuqä eŋqä-paŋä mimäŋqä itqe, iqu Goti Hanjuwä Iqunä miqä duŋi mäpeyqä danä iquäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ämaqä huiwiqu änyuetqe, iqu huiwä-quvi. Iŋäqe Dŋä Äŋguä Iqu änyuetqe, iqu quuvqä-quvi. ");
INSERT INTO mcr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Si Nyaqä kukŋui, ‘He aŋgumä ymeqä däŋä imämbŋqeqä’ tqaŋgqeŋqä, yäuŋuä miqä isŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yuŋuä kiqä äwinyätaŋgqä du äqunätä, huuwqä tqaŋgqenä äwiyätnäŋgaŋi, äŋgisa äpätä, äŋgi äwqutiyä-qe, si maqŋqä esnä. Iŋi ämaqä Dŋä Äŋguä Iqu änyueqäqe, qu eeqä asänäŋä iiŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ii tquaŋga, Nekitimäsi iqu, “Si e ätŋi, änääŋqä tnyä?” ätuätä yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yatŋqä i vqaŋga Jisasi Iqu ämävauqe, “Si Israitqä iquauqä näqŋqä motquequki eŋi, nätmatqä täŋqe näqŋqä mämeqe, äänä itnä inyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Nyi naqä-qakuänäŋä ktmqe. Ne näqŋqä eanä hiŋuä äqunätuŋquä duŋqä etätqäŋu. Iŋäqe he neyaqä kukŋuä duŋi, naqä-qakuä mimäkqä iqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nyi nätmatqä qua täuŋiŋqä tqaŋgqe, he quuvqä maeqiyqä iquwi, ga Nyi nätmatqä qäukuä yätuŋiŋqä hetqaŋgundqe, he quuvqe äänä ipu heqäpŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ämaqä hŋqu qäukuä yätuŋqä mäyqä iŋqe. Ämaqeuqä Ymeqä Ekqä Iqunä, qäukuä yätu äpme äpqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Iŋi ämaqä quuvqä eqämipqä eeqänäŋä iqua, häŋä hea ique-ique pmeqe mapnuwä diŋqe, ii tiinji. Aŋä avqŋqä imä, Mosisi iqu qämakä imäkätä, zä imasätä, äma äpekqä-pa, Ämaqeuqä Ymeqä Ekqä Iqueŋi, qu i äma pepŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Goti Hanjuwä Iqu ämaqä qua täuŋiŋqä huäqä kiiŋä wuŋgaŋgi, Iqu Iqueqä Ymeqä Kiuänäŋä Ique äwikqe. Ga iŋi, ämaqä tqu-tqu Iquenyqä quuvqä eqämipqe, qu eeqänä qui mimäkŋqä danä, häŋä hea ique-ique pmeqe mapnuwi. ");
INSERT INTO mcr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Goti Hanjuwä Iqu Iqueqä Ymeqä Iqueŋi, ämaqä qua täuŋä iuqä suqä quvqe iwäsäutŋqä ändowatkqä mäetqe, Iqu iquauŋi häŋä iqumuatätŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Itaŋga ämaqä tqu-tqu Goti Hanjuwä Iqueqä Ymeqä Iquenyqä quuvqä eqämitpqe, iquauŋi suqä quvqeŋqä miwäsäuqä yäniqe. Itaŋga ämaqä tqu-tqu Goti Hanjuwä Iqueqä Ymeqä Kiuänäŋä Iqueqä yoqeŋqä quuvqä maeqiyqä imitpqe, iquauŋi iuta suqä quvqeŋqä ae iwäsäuä. ");
INSERT INTO mcr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","We-huŋqä Iqu qua täuŋqä qäyä äpqaŋgqä-qe, ämaqe, suqä quvqä imäkäpiyiŋqä We-huŋqä Iqueŋi tuwä äwiyäpu, hiawiqä imqä äwinyä. Suqä iŋiuta iwäsäunä. ");
INSERT INTO mcr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ämaqä suqä quvqä imäkätqäŋuwä iqua, suqä quvqe ätnäŋäqi äti witŋqä etaŋgqeŋqä, qu eeqänäŋi, We-huŋqä Iquenyqä mäwiŋgaŋguti, Iquenyqä mapqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iŋäqe, Goti Hanjuwä Iqueä suqä naqä-qakuä iu qänaki itqäŋuwä iqua, quwqä wäuŋui Goti Hanjuwä Iquesa imäkqaŋgpqe, ätnäŋäqi äti timäutŋqänä, We-huŋqä Iquenyqe äppŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ii iqe, Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä qua Jutiya iuŋqä äupiyi, iqiŋi qu ämaqä asŋä äqiyäpu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Iŋgaŋi Jonä iqu guä änyä pmetŋqäŋga, iqu-pqe aŋä-himqä Ainonä, Salimä-täŋä qäqiqi, ämaqä asŋä äqämiŋqe. Iqiŋi eqä kuapä pätqätaŋgi, ämaqä kuapänä iquenyqä äpäpu asŋä ämamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hiunji hŋqueŋi, Jonä iqueqä ämotquamiŋqä hŋquatä, Israitqä huizi hŋqutä, suqä eqetä akiyä änymiŋuwä iquenyqä kukŋuä näŋi-täqi ämamäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iiŋä ipiyi, qu Jonä iquenyqä äpäpu, “Näqŋqä nätapqä iquki, eqä Jotänä ique yätäqä näŋgisa, Ämaqä sitä anä äpmanyä, itaŋga Iquenyqä ‘Iiŋä-iiŋäqueqä’ ätmiŋä Iqu, täŋgaŋi ämaqä asŋä qäyqaŋgi, ämaqä kuapänä Iquenyqä äwqäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","I tquaŋguwäŋga Jonä iqu, “Ämaqä hŋqu nätmatqä hui hiŋgi mämeqä danä yänä. Goti Hanjuwä Iqu ique vqaŋgutqenä ämenä. ");
INSERT INTO mcr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Nyi Kraisi, ämaqä mitŋqä Goti Hanjuwä Iqu Ique atäuŋuä ikqä iqunä maetqenä. Nyi Iquenyqä hiŋuiqä änändowatqä iqunjqä’ tqaŋgqe, hiqä-hiuä qätä äyä änyikuwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ämaqä hŋqu apäkä tuwakŋä änyuätqe, apäkä ii iqueqä apäkiyi. Iŋäqe ämaqä apäkä metŋqä iqueqä näueqä iqu, iqi ätqäutä apäkä meqaŋgqä iqueqä quväki qätä äwiyäqäŋgaŋi, iqu yeeqänäŋä yänä. Ga nyaqä yeeqä iqe, aaŋä naqänäŋä asä iiŋiqä. ");
INSERT INTO mcr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nyi yoqä maeqä quvqä hiqaŋga, Iqu ämaŋqutäutä, yoqä-täŋä hiäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ämaqä haqä yätuta äpqäqä Iqu, ämaqä huiziquauŋi ämäwqätäunä. Itaŋga ämaqä qua täutaŋä iqu, iqu täutaŋä-qu eä, kukŋui nätmatqä qua täutaŋiŋqä tänä. Iŋäqe qäukuä yätuta äpqä Iqu, eeqänäŋi ämäwqätäunä. ");
INSERT INTO mcr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iqu hiŋuä äqunätä, qätä äwiyätŋqä iu qäyä ätqaŋgi, qu Iqueä kukŋui naqä-qakuä mimäkqä danä itqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iŋäqe ämaqä Iqueqä kukŋuä qätä äwiyätä ämeqä iqu, iqu ämaqä huiziquauŋi, Goti Hanjuwä Iqueä kukŋui naqä-qakuänäŋä etaŋgi ämotquenä. ");
INSERT INTO mcr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Goti Hanjuwä Iqu, Ämaqä Iqu ändowatqäqä Iqueŋi, Iqueqä Dŋä Äŋguä Ique aaŋä kuapänäŋä vqaŋgqetaŋi, Iqu Goti Hanjuwä Iqueä kukŋui awä tänä. ");
INSERT INTO mcr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kaniqu, Iqueqä Ymeqä Iquenyqä kuapänä wiŋgaŋgi, ga Iqu nätmatqä eeqänäŋi Iqueä hipa iqi ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ämaqä tqu-tqu Ymeqä Iquenyqä quuvqä eqiyqäqe, häŋä hea ique-ique pmeqe äme. Iŋäqe ämaqä tqu-tqu Ymeqä Iquenyqä quuvqä maeqiyqä iqäqe, häŋä-pmeqe mämeqä, Goti Hanjuwä Iqueqä äwqä äkasuwi, iqutä hea ique-ique witäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Parisi iqua Jisasi Iquenyqe, “Iqu Jonä iqueŋi ämäwqätäutä, iqueqä wäuŋuäŋqä ämotquamiŋqä iqua kuapänäŋä eäpu, asŋi iqueqä hipa iuta ämetqäŋä” tqaŋgä äwikuwi. Iquenyqä iiŋä ätmiŋuwä-qe, ämaqe asŋi, Iqu maqiyqä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua äqämiŋuwi. I tqaŋgä qätä äwiyäqetaŋi, Iqu qua Jutiyaŋi äväma, aŋgumä qua Galili iuŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","I äwätäqäŋgaŋi hänaqe, qua Sämaliya, aŋä-täŋä iu wätŋqä indqänätä, äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iu äwätäqäŋgaŋi, Sämaliya pmeqä iquauä aŋä-himqä hŋqu, yoqe ‘Sikauä’ ätmiŋuwä ique ätimäukqe. Ii qua Jekopä iqu iqueqä hikŋä Josepä ique äwikqä-täŋä qäqiqiyi. ");
INSERT INTO mcr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Mäptqe awänä pmetaŋga, Jisasi Iqu hänaqe qaŋä imiŋqeŋqä yäŋä-a täŋäŋqä hapä äpmamiŋqe. Jekopä iqu eqäŋqä qua hovqä iqiyätä, eqä esquä imäkäŋqä iqi hapä äpmamiŋqe. Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, buayä mbqäŋqä aŋä-himqä duŋqä äukuwi. Iqu i pmetaŋgaŋi, apäkä Sämaliyataŋä hui eqä euätŋqä pqaŋga, Jisasi Iqu iiŋi, “Eqä hui nmqä dapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","I tquaŋga, ii ämävauqe, “Nyi Sämaliyataŋinyä etaŋgä, si Israitqä Jerusälemä iu hiqäva äqäyätqäŋuwä iutaŋä-quki eäŋi, si nyiŋi, ‘Eqä hui nmqä dapiyä’ ätätnä, yatŋqä änääŋqä nyinyä?” ätukqe. Kukŋuä iiŋi, Israitqä Jerusälemä iu Goti Iqueqä yoqe haqeu ämamäumiŋuwä iqua, Sämaliya iquatäŋi naqä-huinyä mäpmeqä imiŋuwä etaŋgi, i ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ii i tquaŋgaŋi, Jisasi Iqu iiŋi tii ätukqe. “Si nätmatqä Goti Hanjuwä Iqu qanyinä vqeŋqä maqŋqä eŋinyä. Itaŋga Ämaqä, ‘Nyi eqä hui nmqä dapiyä’ äktätŋqä Iquenyqä-pqe, maqŋqä eŋinyä. Si näqŋqä eänä, Ique yatŋqä vqaŋgtqe, Iqu eqä häŋä-pmeqe ktapäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","I tquaŋga ii, “Naqä Iqukiyä, quae kiŋä mämä äptnä, eqe mämä eŋqe, ga Si eqä-häkä-pqä mämeqä danä iŋi, eqä häŋä-pmeqe äkŋgisa iutŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I ätuätä tii ätukqe. “Neyaqä awiqu Jekopä iqu, eqä qua äptesqiyätä, ga eqä täu äŋgqe. Ga iqueqä ymeqä-pqä, hiveqä-yaqueqä-pqe, täu änmiŋuwi. Itaŋga kaqä-kawukäne änätapkqä Jekopä iqueŋi, si ämäwqätäunyä?” ");
INSERT INTO mcr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iŋgaŋi Iqu, “Ämaqe, eqä esquä täu iopu ämbqe, aŋgumä eqäŋqä quväkä ye vquäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Iŋäqe ämaqä, eqä Nyi vqaŋgundi änätqä iqu, aŋgumä eqäŋqä quväkä ye mävqä iquänä. Itaŋga eqä Nyi äwimqä iiŋi, ämaqä iquesaŋi eqä esquä eŋqä-pa, hea ique-ique esuätä, itaŋga häŋä hea ique-ique pmeqe vqäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","I tquaŋgaŋi, ii Iqueŋi, “Naqä Iquki, eqä ätŋi, yqä dapiyä. Nyi eqäŋqä quväkä ye manyiyqaŋguti, nyi aŋgumä eqä täu iumqe, mapqä iqämqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iŋgaŋi Iqu iiŋi, “Tqä qokique kukŋuä ätuätnä, asä täqinyqä ätuma ptŋqänä uvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","I tquaŋga, ii “Nyi qokä mäeqinjqä” ätukqe. Iwä Iqu, “Kukŋuä ii, si naqä-qakuä ätnyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Si ämaqä hipa hŋgiŋä eeqänäŋä iu ämuannä, itaŋga ämaqä täŋga anä äpmeŋiyä iqu, naqä-qakuä tqä qokiqu maeqä eäŋä-qae, iŋi si naqä-qakuänäŋä ätnyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","I tquaŋgaŋi apäkä ii, “Naqä Iquki, Si hiŋuä-tquki äkqänäŋänä. ");
INSERT INTO mcr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ne Sämaliyataŋä iquneqä awäkiqua, Goti Hanjuwä Ique qoŋä äwoktäupu, Iqueqä yoqe haqeqä mamäuqäŋqä aquvi, qoqoŋä tquesa qänätqätaŋgä, he Israitqä huiziquenä, ‘Goti Hanjuwä Ique qoŋä äwoktäupu, Iqueqä yoqe haqeqä mamäuqäŋqä aquvi, Jerusälemä iunä qäŋgpŋqä,’ ätätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ga Iqu iiŋi, “Apäkä iiki, si nyaqä kukŋui naqä-qakuänäŋä imäkiyä. Hiunji, ämaqe Apique qoŋä äwoktäupu, Iquenyqä aquvi, qoqoŋä tquesänä-pqä, itaŋga Jerusälemä dutänä-pqä maqŋqäŋqä iqu ätimäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“He Sämaliyataŋä iquenä, Goti, Ique qoŋä äwoktäutqäŋuwä Iquenyqe, näqŋqä maeqä ipu hiŋgi itqäŋuwiqä. Ne Israitqä iutaŋä, Jerusälemä iu ituŋquä iquneŋi, Goti, ne qoŋä äwoktäutanä, yoqe haqeu ämatnämäutuŋquä Iquenyqe, näqŋqä eanä itquŋunä. Äpäkoŋqä witaŋgi häŋä iqumuatqeŋqä hänaqe, Goti Hanjuwä Iqu Israitqä iqunesa imäuqäqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iŋäqe hiunji hŋqu timäutŋqä itŋqe, ae qe ätimäuqi. Iŋi ämaqä, Apique qoŋä äwoktäupu Iqueqä yoqe haqeu naqä-qakuänäŋä mamäupŋqä iqua, qu Iqueqä Dŋä Äŋguä Iqueä yäŋänäqŋqä ditä, suqä naqä-qakuänäŋitäŋi, iiŋä ipnä. Ämaqe, iiŋä iqäŋqe, Apiqu äwinyänä. ");
INSERT INTO mcr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Goti Hanjuwä Iqu huiwä maeqä, quuvqä-qu eŋqä-qae, ämaqä, Ique qoŋä äwoktäupu, Iqueqä yoqe haqeu mamäupŋqä iqua, qu Iqueqä Dŋä Äŋguä Iqueä yäŋänäqŋqetä, suqä naqä-qakuänäŋitä, iiŋä ipŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Iŋgaŋi apäkä ii Iqueŋi, “Nyi näqŋqä eäqä. Ämaqä Mäsayä Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Iqu äpäŋqiyä. Iqu äpätäqäŋgaŋi ‘Nätmatqä eeqänäŋä iiŋä-iiŋiqä’ natäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","I tquaŋgaŋi, Iqu iiŋi, “Kukŋuä äktätŋqä Tqunä, Nyi tä Qäqunä äktätqäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","I tuätqätaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua aŋgumä ätimäupiyi, Iqu apäkä huisä quea tätqätaŋginyä äqumbiyi, iqua yäuŋuä ipu, ‘Änäändiyä’ tpu ipiyä-qe, hŋqu-pqe, “Si suŋqä kiŋgaŋgikä-qe?” mätquä danä ipu, ä “Si apäkä iiŋi suŋqä tnyuä-qe?” ätuäpu, yatŋqä miqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iŋgaŋi apäkä ii, iiyqä eqä-häki iqi emä, aŋgumä aŋä-himqä duŋqä äwäqe, ämaqeuŋi tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ämaqä nätmatqä nyi imäkätŋqeŋqä eeqänäŋä ändqäqä Ique, hiŋuä qumbŋqänä äwanä! Iqu Kraisi ämaqeu ämitŋqä Goti Hanjuwä Iqu Ique atäuŋuä ikqä Iqu heqänäŋiqä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","I tquaŋgaŋi, qu aŋä dutaŋi äqiyätimäwa, Jisasi Iquenyqä äpäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Apäkä ii, i äväma uwqaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua Jisasi Iqueŋi, “Näqŋqä Motqueqä Iquki, buayä hui huinyä” qäyä ätuäpu, änäänä ätumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","I tquaŋguwäŋga, Jisasi Iqu iquauŋi, “Nyi buayä he änyä maqŋqä etaŋguwä hui-täŋunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ga iqua, “Iqueŋi, ämaqä hui buayä äma ävqäuä?” ätnäpu, iquauqä-quwä yatŋqä iŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yatŋqä i iŋgäwqaŋguwäŋga, Jisasi Iqu “Ŋqä buayi, Nyi änändowatkqä Iqueqä äwiŋqä iunä qänaknä itmä, itaŋga Iqueqä wäuŋuä ändapqäqe qäpu imäkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“He ymisaŋä yäuä iqaŋguti mapŋqe, tii ätätqäŋä. ‘Qaŋui hŋquaqu-hŋquaqu änänjqä.’ He i ätätqäŋuwä-qe, Nyi ‘He wäuŋuä iuŋi, hiŋuä yasämä qumbŋqä’ etqänä. Täŋgaŋi ymisaŋi ämapŋqe, ae yäuä iqäwänä. ");
INSERT INTO mcr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ymisaŋi yäuä etaŋgi, qanyä ämetä ämapqä iqu, mbqä menä. Itaŋga iqu ymisaŋä iiŋi, häŋä hea ique-ique pmeqä duŋqä aquvä äqiyänä. Ga ymisaŋä vowä qutqä iqutä, ymisaŋä meqä iqutä, qäquaqu yeeqänä inyiyiqä. ");
INSERT INTO mcr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iiŋä etaŋgi ämaqeuqä kukŋuä tqu, naqä-qakuä timäunä. ‘Ymisaŋä vowä ämaqä hŋqu iqaŋguti, itaŋga ämeqe, ämaqä hŋquvqä’ tpnä. ");
INSERT INTO mcr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nyi he wäuŋuä ipu tuwä-yawä tmimiqä mämeqä ikuwä iuŋqä ymisaŋä mapŋqä endowatkqeqä. Wäuŋui, ämaqä hŋqua dŋä-huqä ikuwä iu, he ymisaŋä qanyinä mapŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ämaqä Sämaliyataŋä aŋä-himqä Sika iu pmeqä kuapänäŋi, apäkä ii Jisasi Iquenyqe, “Iqu nätmatqä nyi imäkätŋqeŋqä eeqänäŋä ändqiyä” tqaŋgqeta, Jisasi Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iwä iqua Ique äwimapiyi, “Si nesä pmayä” tquaŋgä, Iqu qutäŋi hiunji hŋquaqu äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Iqu kukŋuä vqaŋgqetaŋi, ämaqä kuapänäŋä quuvqä inä eqiyäpu, apäkä iiŋi tii ätukuwi. “Si änatŋä iunä maetqe, täŋgaŋi neqä-neuä qätä äwiyätanä, quuvqä eqiyqunä. Ne näqŋqe, Iqu ämaqä qua täutaŋiu Häŋä Iqumuatqä Iquvqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisasi Iqu iqiŋi hiunji hŋquaqu ae äpmeqe, Iqueqä qua Galiliuŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iqu Iqueqä-kiuä awä äti tii ätkqe. “Ämaqe, hiŋuä-tqä quwqä aŋä-himqä iutaŋä iquenyqe, qu ‘äŋguä-queqä’ matqä ipŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iŋäqe hiunji naqä Pasopaŋga ymisaŋä imäkqaŋguwäŋgaŋi, Galili pmeqe Jerusälemä iu äpmapu, Jisasi Iqu nätmatqä iqi imäkätqätaŋgqe hiŋuä äquŋguwi. Iutaŋi, Iqu Galili du timäuqaŋgaŋi, qu Iqueŋi yeeqä itmakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galili duŋi, Jisasi Iqu aŋä-himqä Kanaŋi, aaŋä eqe wainqä imäkkqä iuŋqä äukqe. Iŋgaŋi, ämiqä naqä iqueqä wäuŋuä miqä hŋqueqä ymeqe, aŋä-himqä Kapänamäŋi, täŋä-yaqä äwämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ämaqä iqu Jisasi Iquenyqe, ‘Jutiyataŋi Galiliŋqä äpqiyä’ tqaŋgä äwiyäqe, iqu Iquenyqä äwäqe, yatŋqä tii äwikqe. “Si Kapänamäŋqä äwätnä, nyaqä ymeqä täŋä-yaqä qäyu äpäkonätŋqä äwiŋqä iqueŋi, äŋguä iwimäkiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","I tquaŋgaŋi, Jisasi Iqu iqueŋi, “He Nyi nätmatqä ämaqä mimikqänäŋi mimäkqä iqaŋgmdqe, he quuvqä maeqiyqä danä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iŋäqe ämaqä naqä iqu, “Naqä Iquki, nyaqä ymeqe qäyu äpäkonätŋqä etaŋgi, iyää, Si nyitä anä weŋqeqä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iŋgaŋi, Jisasi Iqu iqueŋi, “Tqä ymeqä iqu äŋguä häŋä äpmeŋqiyä. Aŋämqä mänä” ätukqe. I tquaŋga, ämaqä iqu Jisasi Iqueä kukŋuä du quuvqä eqiyätä, iqueqä aŋämqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iqu hänaqä tämä änä wätqätaŋga, iqueqä wäuŋuä-wiyqä hŋqua ämimbiyi, “Tqä ymeqä iqu ae äŋguä häŋä eqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iiŋä tquaŋguwäŋgaŋi, iqu iqueqä ymeqä iquenyqe, “Äŋguä äkŋga eqäwä?” ätuätä, yatŋqä äwikqe. Iqua kimaŋi, “Tqä ymeqä iqu yaqä dŋi qäpuŋi, huäqi awiyqeu wanä klokŋga eqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","I äwiyäqetaŋi, kaniqu, “Jisasi Iqu ‘Tqä ymeqä iqu äŋguä häŋä äpmeŋqiyä-qe,’ mäptqe i pmetaŋga äyä ändqäqätanä” kŋuä ämakqe. Iiŋqe, ämaqä iqutä iqueqä aŋä iu anä äpmamiŋuwä eeqänäŋi, qu Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jutiyata Galiliŋqä äpkqäŋgaŋi, Jisasi Iqu nätmatqä Iqueqä yäŋänäqŋqä ämotquetŋqä hŋqu ae imäkkqeu, tä huiziqu imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","I imäkätä äpmamiŋqetaŋi, Israitqä Jerusälemä iu hiqäva äqämiŋuwä iqua, Goti Iquenyqä ymisaŋä naqä bŋqä aquvä qŋgaŋgä, Jisasi Iqu Jerusälemäŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusälemäŋi, täkŋä hänaqä ‘sipsipqeuqeqä’ ätmiŋuwä-täŋä qäqiqiŋi, eqä-huäŋä aŋä mätävätiŋä hipa hŋgisaŋi eeqänäŋä-täŋä hŋqu itäumäkekuwä iqi ätumiŋqe. Israitqä iquauä kukŋuiuŋi, kiqä yoqe ‘Betesauä’ ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Iqiŋi ämaqä täŋä-yaqä huitaŋä-huitaŋä iqä iqua, kuapänä äwämiŋuwi. Täŋä-yaqä hiŋuä maqŋqä iquau, ä yäŋä quvqä iquau, ä ŋŋuä ämeŋä miqä iqua, äwämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jisasi Iqu timäuqaŋgaŋi, ämaqä täŋä-yaqä quväukuä 38 mäwqätäuqä hŋqu iqi äwämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisasi Iqu ämaqä iqu täŋä-yaqä aiŋgatqä witaŋgi äqunäqe, iqueŋi, “Si äŋguä imändŋqä äkiŋgiyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kimaŋi, ämaqä täŋä-yaqä-täŋä iqu “Naqä Iquki, eqä ämeŋä iqaŋgaŋi ämaqä hŋqu nyi änmetä eqä bu mäyenjiyqe, täqiŋi aaŋqe. Nyi eqä buŋqä wämätmä itqätaŋgaŋi, ämaqä hui ganä ae äpäwiqaŋga, nyi mäpäwiqä itŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E tquaŋgaŋi, Jisasi Iqu iqueŋi, “Pämä äpmetnä, tqä yquvaŋi ämetnä, qaŋä uvä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ätquaŋganä, iqueä täŋä-yaqe qäpu heqaŋgi, iqu äŋguä-qu, iqueqä yquvaŋi ämetä, qaŋä äukqe. Hiunji iqu, Sämbatqä hapä pmeqäŋganji. ");
INSERT INTO mcr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iŋgaŋi Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä iqua, ämaqä äŋguä imäŋgqä iqueŋi, “Tä hiunji hapä pmeqäŋga eŋqe, si yquvaŋä haŋä ämeŋätä, neyaqä suqä duŋi pmua imäknänä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","I tquaŋguwäŋgaŋi, iqu ämävauqe, “Ämaqä nyi äŋguä inyimäkätäqä Iqu, ‘Tqä yquvaŋi ämetnä qaŋä uvä’ dqaŋgiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","I tquaŋgi äwipiyi, iqueŋi, “Ämaqä ‘Tqä yquvaŋi ämetnä qaŋä uvä-qe’, tqu ktqiyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jisasi Iqu ique äŋguä iwimäkqaŋga, ämaqä kuapänäŋä iqi etaŋgä, Jisasi Iqu quvaqä awä imda maqŋqä äukqe. I iäqetaŋi, ämaqä täŋä-yaqä äŋguä i imäŋgqä iqu, Iquenyqä maqŋqe, “Nyi äŋgui, Tqu inyimäkqutiyä” tä itä, quvaqä yatŋqä kimaŋi, mätquä ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Qänakŋi, Jisasi Iqu iqueŋi hiqäva-imäkqä aŋä ququawä du ämäqumueqe, “Si äŋguä ae eŋä-qae, suqä quvqä hui imäkätqäŋi, aŋgumä mimäkqä panä! Nätmatqä quvqä naqänäŋä di kimeqäŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","I tquaŋgaŋi, ämaqä iqu aŋgumä äwäqe, ämaqä naqä iquauŋi, “Ämaqä nyi äŋgui, Jisasi Iqu inyimäkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisasi Iqu hiunji hapä pmeqäŋga wäuŋuä iiŋä di imäkätqätaŋgqeŋqä, ämiqä naqä iqua Iquenyqe, äwqä tnäŋä äwinyätä, haŋä-iqä ävqa upŋqä ipäqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iŋgaŋi Jisasi Iqu ämävauqe, Iquenyqä äwqä tnäŋä imäkqaŋguwä iquauŋi, “Ŋqä Apiqu wäuŋuä äŋguä tiiŋi, iqa äpätŋqe, hiunji tque timäuqaŋgi, ga Nyi-pqe wäuŋuä tiiŋi i imäkätqäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jisasi Iqu i tqaŋgaŋi, Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä iqua, Iqueŋi pizqä päsqä duŋqä itquaka upŋqä ipäqäkuwi. Iqu Sämbatqä hiunji hapä pmeqä miqä suqä duŋi mämiqä iqaŋgqä duŋqänä hmanji. Goti Hanjuwä Iquenyqe, “Iqu Ŋqä Apiqueqä” ätätä, Qämätaqi asänäŋä eyŋqä tqaŋgqeŋqä ipäqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iŋgaŋi Jisasi Iqu kimaŋi, “Nyi naqä-qakuänä etqä. Ymeqä Iqu nätmatqä hŋqu Iqueqä-kiuänäŋi, änä mimäkqä danä yänä. Iqu Kaniqu imäkqaŋgi äqunäqä dunä imäkänä. Nätmatqä äki-äkitaŋä Kaniqu imäkätŋqe, Ymeqä-pqä Iqu asä inä imäkätqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","“Kaniqu Ymeqä Iquenyqä wiŋgaŋgi, nätmatqä eeqänäŋä Iqu imäkätäqä di, Ymeqä-que ämotqueqiyä. Tä wäŋqeqä. Naqe änyä motqueqaŋga, he yäuŋuä ipu, miiqä yäŋä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kaniqu ämaqä pizqä duŋi ävauqumuatätä häŋä-pmeqä ävätŋqe, ga Ymeqä-pqä Iqu, Iqueqä äwinyätaŋgqä iquauŋi, häŋä-pmeqä asä inä ävätqänä. ");
INSERT INTO mcr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Iŋi Apiqu, ämaqä hŋqueŋi miwäsäuqä danä yänä. Ämaqä iwäsäuqä wäuŋuä eeqänäŋi, Ymeqä Iqueqä hipa iqi eqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Iiŋä eätqe, tiiŋäŋqeyi. Qu Kaniqueqä yoqe haqeu ämamäupu, Ique äŋguä itquetqäŋuwä-pa, Ymeqä Iqueŋä-pqe, asä iiŋä itquapŋqeqä. Ä Ymeqä Iqueŋi äŋguä mitqueqä ipu, Iqueqä yoqe haqeu mämamäuqä iquwä iqua, Kaniqu Ymeqä ändowatkqä Iqueqä yoqä-pqe, haqeu mämamäuqä danä ipu, äŋguä mitqueqä iqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nyi naqä-qakuänäŋä etqä. Ämaqä Nyaqä kukŋui qätä änyiyäpu, Nyi änändowatkqä Iquenyqä quuvqä eqiyquwä iqua, häŋä hea ique-ique pmeqä-täŋä iquayi. Iqua äpäkoŋqä duŋi ämäwqätäupu, häŋä hea ique-ique pmeqe ämequwä-qae, iquauŋi miwäsäuqä danä yänä. ");
INSERT INTO mcr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nyi naqä-qakuänäŋä etqä. Hiunji hŋqu timäutŋqä itŋqe, ae qe ätimäuqi. Ämaqä pizqä äpäkonätqäŋuwi, Goti Hanjuwä Iqueqä Ymeqä Iqueä maŋä tqaŋgqe, qätä wipŋqeqä. Itaŋga qätä i äwipiyä iqua, häŋä vaupŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Apiqu Iqueqä-kiuä häŋä-pmeqäŋqä Quati-quvi. Ga Iqu, Iqueqä Ymeqä Iqueŋä-pqe, häŋä-pmeqäŋqä Quati asä inäŋä-qu etaŋgi imäkkqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ymeqä Iqu, Ämaqeuqä Ymeqä Ekqä Iqu etaŋgi, Apiqu Iqueŋi, ämaqä iwäsäutŋqä yoqä naqä ävqäqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Kukŋuä täŋqe, he yäuŋuä ipu miiqä yäŋä miqä danä ipŋqeqä. Ämaqä qua äptnäŋuwä iqua, Ymeqä Iqueä maŋä tqaŋgi äwipiyäŋgaŋi, qua äptŋgäwäŋuwä iutaŋi, aŋgumä häŋä vaupŋqä hiunji iqu äpqiyä. Suqä äŋguä imäkätqäŋuwä iqua, aŋgumä häŋi, häŋä hea ique-ique pmeqeŋqä vauqaŋgpi, itaŋga suqä quvqä imäkätqäŋuwä iqua aŋgumä häŋi, iquauqä suqeŋqä iwäsäutä haŋä-iqä meqäŋqä vaupnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nyi nätmatqä hŋqu Ŋqä-näuänäŋi, mimäkqä danä ymä. Nyi Goti Hanjuwä Iqu dqaŋgqä dunä iwäsäutqäŋänä. Nyi änyiŋqä Ŋqä duta mimäkqä itmä, Nyi änändowatkqä Iqueqä äwiŋqä dunä imäkätŋqä-qae, Nyaqä ämaqä iwäsäuqe, waqiyä maitqenä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nyinä Ŋqä-näuäŋqe, ‘iinjqä-iinjqä’ etmqe, Nyaqä kukŋuä iiŋi, he naqä-qakuä mimäkqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iŋäqe Nyinä manä, Hŋqu-pqe Nyinyqe, ‘iiŋä-iiŋä-queqä’ inä ätätŋqe. Nyi näqŋqe, Iqu iiŋi, naqä-qakuänäŋä ätätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ämaqä naqä iquenä, he ämaqä hŋquauŋi, Jonä asŋä-qäyqä iqueqä kukŋui mapŋqä ändowatkuwi. Iqu Nyinyqe, naqä-qakuänäŋä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iqu iiŋä qäyä iqaŋgi, kukŋuä Nyaqä ätätŋqeuŋi, yäŋänäqŋqä nyimäkätŋqä diŋqe, ämaqä hŋqueqä kukŋuä tqaŋgqe, Nyi mämeqä ymä. Nyi Jonä iquenyqä tä etqe, he qui mimäkŋqä häŋä pmapŋqä diŋqä etqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonä iqu, tä äyänätä we äunätŋqä-paŋä iiŋä-quvi. He iqueä we-huŋqeŋqe, yeeqä hŋgaŋqä miqä danä, wäŋqänäŋäpu itqäŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Iiŋä etaŋgi, wäuŋuä Apiqu Nyi imäkmqä ändapkqe, Nyi wäuŋuä i itqäŋä. Ga wäuŋuä iutaŋi, Apiqu Nyi änändowatkqä Iquenyqe, he näqŋqä mapŋqäuä. Iŋi Nyaqä wäuŋui, Jonä iqueqä kukŋuä iuŋi ämäwqätäunä. ");
INSERT INTO mcr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Apiqu Nyi änändowatkqä Iqu kukŋuä ätätŋqe, Iqu Nyinyqä ‘iiŋä-iiŋä-queqä’ ätätqänä. He änändowatkqä Ique qätä mäwiyqä iqaŋgä, Nyi tii etqänä. ‘He Apiqueä maŋä-wiuŋui qätä mäwiyquenä, Iqueä himä-huiwä-a hiŋuä mäquŋqä-quenä ipu, itaŋga he Iqueqä kukŋui hiqä quuvqä imŋi mämaeqä danä itqäŋuwenjqä’ etqänä. ");
INSERT INTO mcr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Häŋä hea ique-ique pmeqe, Goti Iqueqä bukä iuta mapŋqä kŋuä heyqaŋgi, qävqä yasämänä äyä itqäŋäuä. Ga bukä iuŋä-pqe, kukŋui Nyiŋqä ätnänä. ");
INSERT INTO mcr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iŋäqe, he häŋä hea ique-ique pmeqe mapŋqä diŋqe, Nyinyqe mapqä danä itqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nyi yoqä naqe, ämaqä qua täutaŋä iuta meqäŋqe, kŋuä manyqä enä. ");
INSERT INTO mcr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iŋäqe henyŋqä di, Nyi näqŋqä äŋguänäŋä eŋä. ‘He Goti Hanjuwä Iquenyqä eŋqe, heyaqä quuvqä yäpä imŋi, aaŋqä etaŋgqe’ Nyi näqŋqä eŋä. ");
INSERT INTO mcr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nyi Ŋqä Apiqueä yoqä iuta qäyä äpqäŋqä, mindmeqä danä iqä. Ämaqä hŋqu yoqe, iqueqeta pqaŋgaŋi, he iqueŋi itmapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Goti Hanjuwä Kiuänäŋä Iqunä heyaqä yoqe haqä yätu maetŋqä diŋqe maeŋgaŋgi, yoqä naqe, ämaqeutanä ämetqäŋuwi, ga he quuvqe, äänä ipu heqäpŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","He Nyinyqe, ‘Iqu Kaniqueä hiŋuä iqisaŋi nenyqe, “Iqua suqä quvqä imäkqä-quaiqä” tuäŋqiyä’ kŋuä maeyqä pa eä. He Mosisi iquenyqe, ‘Iqu ne yätamäkqä neyäŋqiyä’ kŋuä ämaka äpäŋuwä-qe, iqu henyqe, ‘Iqua suqä quvqä imäkqä-quaiqä’ tqä-quvqä. ");
INSERT INTO mcr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosisi iqu Nyiŋqä ätätä tuwaŋuä äqiyekqä-qae, he iquenyä naqä-qakuä imäkqä-säpi, Nyinyqä-pqä naqä-qakuä imäkätqäpniŋgä. ");
INSERT INTO mcr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Iŋi Mosisi iqu tuwaŋuä äqiyätä ekqä duŋi, naqä-qakuä mimäkqä iquwi, ga nätmatqä Nyi tqaŋgqeŋqe, he naqä-qakui äänä ipu imäkpŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä hiunji naqänäŋä, Pasopa ätätqäŋuwä iqu qäqi emiŋqe. Iŋgaŋi, Jisasi Iqu eqä-huäŋä Galili, ‘Taipiriyasiuä’ ätmiŋuwä iqueŋi, äkitä näŋgisaŋqä äukqe. Ämaqä aaŋä kuapänäŋi, Jisasi Iqu nätmatqä ämaqä mimäkqänäŋi, ämaqä täŋä-yaqä-täŋä iu äŋguä imäkätqätaŋgi äquŋguwitaŋi, qu Ique qänaki äwivändkuwi. Jisasi Iqu qoqoŋä yätuŋqä äyäqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä quamä äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisasi Iqu ämaqä aaŋä kuapänäŋä Iquenyqä äyä pqaŋgä äqunäqe, Iqu Pilipä iqueŋi, “Ämaqä tä ymisaŋä bŋqe, ne ymisaŋä mbqe, äkŋgi yatuŋquäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisasi Iqu Iqueqä imäkätŋqä diŋqe, Iqueqä-kiuänä näqŋqä ämeqä-qe, Iqu Pilipä iqueqä quuvqä heqiyqe, yamwiqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Iwä Pilipä iqu ämävauqe, “Ämaqä eeqänäŋi, ymisaŋä meqä-meqäpu bŋqeŋqä, buayä mbqe, 200 duŋi ämäwqätäuqä iqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Iqueqä wäuŋuäŋqä ämotquamiŋqä Endru, Saimonä Pitä iqueqä käta-käŋgua iqu, Jisasi Iqueŋi, “Ymeqä hŋqu bretqä kuä-balitä äyäqiyquwä 5 eäqe, hämapäkä hŋquaqutä täqi eä pmetaŋgqä-qe, ga iiŋä ipu ämaqä kuapänäŋä täuŋi qäyunäŋqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iqiŋi qätaqä hioätqä äŋguänäŋäqi etaŋgi, Jisasi Iqu “‘quamä pmapiyä’ tupiyä” ätukqe. Ga iqua quŋi, “He quamä pmapiyä” tquaŋga, qu eeqänäŋä quamä äpmakuwi. Ämaqä qokä iquanäŋi, 5,000 äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisasi Iqu bretqä ämeqe, Goti Hanjuwä Ique ‘äŋguiqä’ ätuäqe, ämaqä iqi quamä pmetaŋguwä iu yaŋä ikqe. Hämapäkä-pqe i imäkätqä-pa imäkqaŋgi, qu eeqänä äŋguä kuapänäŋä äŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Qu äŋguä änäpu änätquteqaŋguwäŋgaŋi, Jisasi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “Änätqutequwi qui mimäkŋqä yätŋqä, he ämayäkäpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","I tquaŋgaŋi, iqua bretqä kuä-balitä äyäqäkuwä 5 isuataŋi änätquteqaŋguwi, qa naqä 12 maŋguä ämamikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jisasi Iqu nätmatqä ämaqä mimäkqänäŋä i imäkqaŋgi äqumbiyä iqua, “Ämaqä Tqu naqä-qakuä, ‘hiŋuä-tqä qua täuŋqä päŋqiyä’ ätnäŋqä Iqueqä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","I ätäpu, Iqu ‘oeyä’ qäyä ätqaŋguti, qu Ique a äkiqätäpu, ämaqä naqä ämiqäŋqä imäkpŋqä äyä iqaŋgä näqŋqä eäqe, Iqu quŋi aŋgumä äväma, qoqoŋä imä kuäquväkiquätŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Hea wiqaŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, eqä-huäŋä buŋqä äpäwäpiyi, yimba ätkamäupu, eqä-huäŋä yätäqä näŋgisa aŋä Kapänamäŋqä äväma äukuwi. Jisasi Iqu iquauŋi mäwimeqä änyä etaŋgi, hea qe ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iŋgaŋi yuŋuä yäŋänäqŋqä hŋqu äqunätä, eqe yäyäŋi qoqoŋä ätqäwa äpemiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, yimba iqu eqä iqi wätŋqe, iqua eqä buŋi ämiqa-ämiqa, awänäŋi (4 o 5 kilomita) tii äwäpiyäŋgaŋi, Jisasi Iqu yimba-täŋä qäqi, eqä haqeqä qaŋä pqaŋgi äqumbiyi, iqua zä kiiŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","E iqaŋguwäŋgaŋi, Jisasi Iqu iquauŋi “Tä Nyinjqä. He zä miqä pambiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iŋgaŋi iqua Iquenyqä yeeqä ipu, yimba iŋgisaŋqä itmakuwi. Iwä iŋgaŋi yimba aŋä-himqä iqua timäupŋqä äwäpiyä-täŋä iu, qäqi maqänä imäŋgaŋgi iuäqämakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hiunji buayä i änäpu äpmakuwä äwiŋgaŋi, ämaqä kuapänäŋä huäŋä yätäqä iŋgisa iqi yqänä äpmamiŋuwä iqua, “Täqiŋi yimba kiuänäŋä hmbunä pmetaŋgi, Iqueqä wäuŋuäŋqä ämotquetŋqä iqua, Jisasi Iqu maeqä, quwqä-quwänä yimba ipi äyä äwquwätanä!” kŋuä ämakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yimba huiziqua Taipiriyasitaŋi, Naqä Iqu buayä äŋguiqä tqaŋga, ämaqä kuapänä äŋguwä-täŋä qäqiqi iuäqämakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ämaqä kuapänäŋä iiŋi, Jisasi Iqutä Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä, iqiŋi heaqiyä äyä nyätaŋgä äqumbiyi, qu yimba iquau ätkamäupu, Jisasi Iquenyqä qävqe, aŋä Kapänamäŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ämaqä kuapänäŋä iiŋä iqua, qu Jisasi Iqueŋi huäŋä yätäqä näŋgisa ämäqumuapiyi, Iqueŋi, “Näqŋqä-vqä Iquki, Si täqinyqe, äkŋga äpŋäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","I tquaŋguwäŋgaŋi, Jisasi Iqu ämävauqe, “Nyi naqä-qakuänäŋä etqä. He Nyinyqä qävqä ikiquwi, Nyi nätmatqä ämaqä mimäkqänäŋi imäkqaŋgqeŋqä manä, Nyi buayä hetapqaŋgä äwqä äŋguä änäpäsäpiyiŋqänä ikiqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","He wäuŋui, ymisaŋä qui imäknätä pizqä iqä duŋqä miqä ipu, häŋä hea ique-ique wiqä duŋqä ipŋqeqä. Goti Hanjuwä Apiqu, Ämaqeuqä Ymeqä Ekqä Iqueqä yoqe, yäŋänäqŋqä witŋqä imäkkqe. Ga ymisaŋä iiŋi, Ämaqeuqä Ymeqä Ekqä Iqu hetapäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","I tquaŋga qu Iqueŋi, tiiŋä ätukuwi. “Goti Hanjuwä Iqu, ne squä wäuŋuä imäkatuŋquä äwinyätqänä?” ");
INSERT INTO mcr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ga qu iiŋä tquaŋguwäŋga, Iqu kimaŋi, “Goti Hanjuwä Iqu, he Ämaqä Iqu ändowatkqä Iquenyqä quuvqä heqäpŋqä äwinyänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Quvaqe, Iqueŋi tii ätukuwi. “Si nätmatqä ämaqä mimäkqänäŋi äki imäktŋqäwä? Ga ne iu äqunanä, Tqä kukŋui naqä-qakuä imäkatuŋque, äänä isŋqäwä? ");
INSERT INTO mcr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Neyaqä atqä-awäkiqua, aŋä avqŋqä maeqä duŋi, buayä mana Mosisi iqu äwikqeu äŋguwi. Goti Hanjuwä Iqueqä tuwaŋuä iuŋi, ‘Iqu buayä qäukuä yätutaŋi bŋqä äwikqeqä’ ätnäŋqä-panjqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","I tquaŋguwäŋga, Jisasi Iqu quŋi, “Nyi he naqä-qakuänäŋä etqänä. Qäukuä yätutaŋä buayä naqä-qakui, Mosisi iqu etapäŋqä maetqe, Nyaqä Apiqu etapätqänä. ");
INSERT INTO mcr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Buayä Goti Hanjuwä Iqu vqe, ii qäukuä yätuta äpätä, qua täuŋä iu Häŋä-pmeqä-vqä Iquvqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","I tquaŋgaŋi, qu Iqueŋi, “Iyää, Naqä Iquki, buayä iiŋi, Si ne hea ique-ique nätapqa uwqätŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iŋgaŋi, Jisasi Iqueä kimaŋi, “Nyi Buayä Häŋä-pmeqä Iqunjqä” ätukqe. “Ämaqä Nyinyqä äpätä quuvqä heqiyqä iqu, buayäŋqätä, eqäŋqätä dä mävqä itä, quväkä-ye, mävqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Iiŋä etaŋgqä-qe, Nyi tii etqänä. ‘He Nyi hiŋuä äŋqämbiyä-qe, Nyinyqä quuvqä maeqiyqä äyä itqäŋäuä.’ ");
INSERT INTO mcr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Apiqu Nyi ändapkqä iqua, qu eeqänäŋi, Nyinyqä ppŋqäuä. Nyi qäukuä yätuta qua täuŋqä äpqe, änyiŋqe, Ŋqä du imäkmqä manä, Nyi änändowatkqä Iqueqä dunä imäkmqä äpqä-qae, Nyinyqä i pqaŋguwä iquauŋi, hŋqueŋi bi mämamäuqä danä ymqänä. ");
INSERT INTO mcr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nyi änändowatqä Iqu, ämaqä Nyi ändapkqä iquauŋi, hiunji yäpakäŋgaŋi Nyi hŋqueŋi hiŋuinä mäquŋquä itmä, eeqänäŋä iuŋi häŋä vauqumuatmniqŋqä äwinyänä. ");
INSERT INTO mcr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nyaqä Apiqu tiiŋiŋqä äwinyä. Ymeqä Ique äqunäpu, Iquenyqä quuvqä eqämipqä iqua, häŋä hea ique-ique pmeqe, ämepu pmetaŋgpi, ga hiunji yäpakäŋgaŋi, Nyi quŋi häŋä vauqumuatmniqŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iŋgaŋi Israitqä Jerusälemä iu hiqäva äqämiŋuwä iqua, Jisasi Iqu “Nyi bretqä qäukuä yätuta äpqä Iqunjqä” tqaŋgqeŋqe, qu kukŋuä kuapänäŋä ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iiŋä ätäpu, “Ämaqä Tqu Josepä iqueqä hikŋä Jisasi Iqutanä, ä äsqukä? Iqueqä kaniquenyqätä, känäuŋqätäŋi, ne näqŋqä eäŋque. Iqu täŋgaŋi, ‘Nyi qäukuä yätuta äpqä Iqunjqe’ änääŋqä ätqiyä?” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iŋgaŋi, Jisasi Iqu ävauqe, “He kukŋuä kuapä matuwäŋqä pambiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","“Ämaqä hŋqu Nyinyqe, hiŋgi mapqä yänä. Apiqu Nyi änändowatkqä Iqu, ämaqä ique Nyinyqä pätŋqä ämäqipmeqaŋguti, iqu i pänä. Ga Nyi iqueŋi, hiunji yäpakäŋgaŋi, häŋä vauqumuatmniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hiŋuä-tqä iquauä tuwaŋuä iuŋi, ‘Qu eeqänäŋä iquauŋi, Goti Hanjuwä Iqu näqŋqä väŋqiyä’ ätä äqänänä. Ga ämaqä Ique qätä äwiyäpu, Iquesa näqŋqä ämepiyä iqua, qu eeqänäŋi Nyinyqä ppŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Iiŋä etaŋgi, ämaqä-pqä hui Goti Kanique hiŋuä ae äqunätqäŋuwä hmanji. Ämaqä Goti Hanjuwä Iquesa äpqäqä Iqunä, Kaniqueŋi, hiŋuä äqunätŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nyi naqä-qakuänäŋä etqänä. Ämaqä quuvqä eqiyätäqä iqu, häŋä hea ique-ique pmeqe, ämeŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bretqä häŋä-pmeqä iqu, ii Nyinjqä. ");
INSERT INTO mcr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Heyaqä hewäkiqua, aŋä avqŋqä duŋi, buayä mana äŋguwä-qe, qu äyä äpäkoŋguwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Iŋäqe bretqä qäukuä haqä yätuta äpqä tqueŋi, ämaqä hŋqu ique äŋgqe mapäkoŋqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Bretqä häŋä-pmeqä qäukuä yätuta äpqä iqu, ii Nyinjqä. Ämaqä hŋqu buayä ique äŋgqe, iqu häŋä hea ique-ique pmeniqeqä. Buayä Nyi ämaqä qua täu äpmeŋuwiu häŋä-pmeqä mapŋqä wimqe, ii Nyaqä huiwiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","I tquaŋgqeŋqä iqua quwqä-quwä, “Ämaqä Tqu, Iqueqä huiwi ne änatuŋque, äänä nätapätŋqäwä?” ätäpu, himänä ipu ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","I tŋgaŋguwäŋga, Jisasi Iqu ivatuwänäqe, tii ätukqe. “Nyi he naqä-qakuänäŋä etqänä. He Ämaqeuqä Ymeqä Ekqä Iqueä huiwitä, häŋeqetä maŋqä ipqe, häŋä-pmeqe hesäŋi aaŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Buayä naqä-qakuänäŋi, Nyaqä huiwiyi. Itaŋga eqä naqä-qakuänäŋi, Nyaqä häŋeqeyi. Iŋä-qae, ämaqä Nyaqä huiwitä, häŋeqetä änmipqä iqua, häŋä hea ique-ique pmetpnuwiqä. Itaŋga Nyi iquauŋi, hiunji yäpakäŋga häŋä vauqumuatmniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ämaqä tqu-tqu Nyaqä huiwitä, häŋeqetä änmitätqe, iqu Nyi nyinätaŋgi, Nyi ique änyäŋänä. ");
INSERT INTO mcr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nyiŋi, Apiqu häŋä-pmeqä Iqu änändowatqaŋgi, ga Nyi häŋi Iquesa äpmeŋqä-pa, ämaqä Nyi änmitätqä iqu, häŋi, Nyita pmeniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Buayä qäukuä yätutaŋä äpqäqä Tqunäŋi, Iqu buayä heyaqä taqä-tawäkiqua mana änäpu, äpäkoŋguwä ii eŋqä-paŋä manä. Ämaqä, Buayä Tqunä ännätqä iqu, häŋä hea ique-ique pmetäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisasi Iqu kukŋuä iiŋi, aŋä aquväqŋqä Kapänamä du näqŋqä ävätä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iqueqä wäuŋuäŋqä ämotquamiŋqä kuapänäŋä hui, Iqu i tqaŋgi äwipiyi, “Iqueqä kukŋuä, ne kŋuä änä mämeqänäŋä ätqäqe, qäte tqu wiyätŋqäwä?” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Qu kukŋuä kuapänä tqaŋguwiŋqä, Jisasi Iqu, Iqueqä-kiuä näqŋqä eäqe, tii ätukqe. “Kukŋuä tqu he qui emäkqiyä? ");
INSERT INTO mcr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ämaqeuqä Ymeqä Ekqä Iqu, aŋä änyäŋäŋga äpmamiŋqä yätuŋqä yqaŋgi äqumbqe, äänä ipnuwäwä? ");
INSERT INTO mcr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Häŋä-pmeqe, Dŋä Äŋguä Iqu ävätqänä. Ämaqeuqä yäŋänäqŋqä duta, maetqenä. Iiŋä etaŋgi Nyi kukŋuä etqä tä, quuvqä vqeŋqätä, häŋä-pmeqä vqeŋqätä etqänä. ");
INSERT INTO mcr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Iiŋä qäyä etaŋgi, hŋquenä quuvqä maeqiyqä itqäŋäuä. Ga Nyaqä kukŋuä ‘Ämaqä hŋqu Nyinyqe, hiŋgi mapqä yänä. Apiqu, ämaqä ique Nyinyqä pätŋqä ämäqipmeqaŋguti, iqu i päŋqiyä’ etqe, ii hŋquenä quuvqä maeqiyqä itqätaŋguwita etqeqä” ätukqe. Iiŋä ätukqe, ämaqä Iquenyqä quuvqä maeqiyqä ipnuwä iquauŋqätä, ä Iqueŋi ämaqä iquau täkqä ätuätä hipa iu väniŋqä iquenyqetä, Jisasi Iqu Iqueqä-kiuä änyäŋäŋga näqŋqä eä, i ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä kuapänäŋi, qu Ique tuwä äwiyäpu, Iqutäŋi anä mikiqä danä qe ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","I iqaŋguwäŋgaŋi, Jisasi Iqu Iqueqä ämaqä 12 iquauŋi, “He-pqe Nyi inä nyivämapŋqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Iwä Saimonä Pitä iqu, “Naqä Iquki, Si kukŋuä häŋä hea ique-ique pmeqe ämeŋnä. Ne tquenyqä watuŋquäwä? ");
INSERT INTO mcr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iŋi, ne näqŋqä ämenä quuvqä eqiyqu. Si Ämaqä äŋguä jänänäŋä Goti Hanjuwä Iqueqä atäuŋuä ekikqä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","I tquaŋga Jisasi Iqu ämävauqe, “Nyi heŋi, 12 etmakqeuŋi, hŋquki dŋä quvqä-täŋä äyqukitanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kukŋuä iiŋi ätkqe, Saimonä Iskarioti iqueqä hikŋä Jutasi iquenyqe. Iqu ämaqä 12 iutaŋä-qu qäyä eä, Jisasi Iquenyqe, täkqä tuäniqä etaŋgi, ii ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Itaŋi, Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä iqua, Jisasi Ique äpäkpŋqä iqaŋguwiŋqä, Iqu qua Jutiya iu ikiqäŋqä mäwiŋgaŋgi Galili dunä ikämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Hiunji naqänäŋä Israitqä Jerusälemä iu hiqäva äqämiŋuwä iqua, ittäŋä aŋiu yakuä äpmapu, yeeqä ipu aquväqŋqä hiunji iqua timäutŋqä qäqi etaŋgi, Jisasi Iqueqä käŋguäkiqua Iqueŋi, “Si aŋä täqiŋi äväma, qua Jutiyaŋqä uvä. Tqä ämaqä wäuŋuäŋqä ämotquetqäŋä iqua, Si nätmatqä imäkqaŋgtqe hiŋuä kqämbŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ämaqä hŋqu ämaqä eeqänäŋä im-imŋi, iquenyqä näqŋqä hipŋqä etaŋgutqe, iqu nätmatqä eeqänäŋi, ktqä nämä mimäkqä yänä. Si nätmatqä iiŋi imäkätqäŋi, ämaqä eeqänäŋi hiŋuä kqämbŋqänä ämotquatŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","I ätukuwi, Iqueqä käŋguäkiqua-pqe Iquenyqä quuvqä maeqiyqä ipiyitanji. ");
INSERT INTO mcr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iqua i tquaŋguwäŋga, Jisasi Iqu, “Hiunji Ŋqe, änänjqä. Henyqe, hiunji eeqänäŋä iqua, äŋguänäŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","“Nyi ämaqe, qu suqä quvqä imäkätqätaŋguwiŋqe, ‘Ii suqä quvqä imäkätqäŋäuä’ tuätqätaŋgqeŋqä, qu Nyinyqä wiuŋqä itqäŋä. Iiŋä etaŋgi, qu henyqe, iiŋi miqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ŋqä hiunji änyä eŋqä-qae, Nyi aquväqŋqä naqänäŋä iuŋqä mäyqä yimä. Henyä epiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iqu quŋi i ätuätä, mäwqä danä, Galili bu äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iŋäqe, Iqueqä käŋguäkiqua aquväqŋqä yätuŋqä ae äväma yqaŋguwäŋga, Jisasi Iqu qänaki maqŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aquväqŋqeuŋi, Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä naqä iqua Jisasi Iquenyqä, “Ämaqä Iqu äŋgi pmenä?” ätäpu, qävqä ikämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iŋgaŋi ämaqä kuapä äpmapiyä iuŋi, hiyäkakä ätŋgäukuwi. Hŋqua Iquenyqe, “Ämaqä äŋguänäŋueqä” tqaŋguwäŋga, hŋqua “Oeyä, Iqu ämaqä kuapänäŋä hänaqä huiu-mända ätuma äwqiyä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iŋgaŋi, qu iquauqä naqä iqua haŋä-iqä vqeŋqä zä wiŋgaŋgi, Iquenyqe, ätnäŋäqi äti matqä danä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Qu aquvä äqämbu hiunji hŋqua ae pmetaŋguwäŋgaŋi, Jisasi Iqu hiqäva-imäkqä aŋä mätnätaŋgqä ququawä yäŋgisa äpeyäqe, qokä-apäkiu kukŋuä näqŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","I iqaŋgaŋi, iquauqä naqä iqua yäuŋuä ipu, “Iqu näqŋqä-vqä hŋquenyqä mäwqä imiŋqe, näqŋqä ii, äänä itä ämeqätiyä” tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I iqaŋguwäŋgaŋi, Jisasi Iqu kimaŋi, “Kukŋuä tä ämetqueqe, kŋuä indqäŋqä Nyaqeta maetqe, Goti Nyi änändowatkqä Iquesayqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","“Ämaqä Goti Hanjuwä Iqueä äwiŋqe qänaknä yätŋqä itäqä iqu, Nyaqä kukŋuiŋqe, ii Goti Hanjuwä Iquesatiyä, ä kŋuä indqäŋqä Nyaqä iuta tqändiyä-qe näqŋqä hiänä. ");
INSERT INTO mcr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ämaqä kukŋui, kŋuä indqäŋqä iqueqä iuta ätqä iqu, yoqä iqueqe haqä yätu maenätŋqä wiŋgaŋgiyi. Iŋäqe ique ändowatkqä iqueqä yoqe haqä yätu maetŋqä äwiŋgqä iqu, suqä quaŋgi mämeqä, naqä-qakuänäŋä tqä-quvqä. ");
INSERT INTO mcr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosisi iqu kukŋuä-suqä metapqä iŋqäta? Iqu etapkqä-qe, he eeqänäŋi, suqä iuŋi, qänaknä miqä itqäŋäuä. Ga he Nyiŋi suŋqä pizqä bäkpŋqä itqäŋäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","I tquaŋgaŋi, ämaqä kuapänäŋä iiŋi, ämävaupiyi, “Peŋqä dŋä kinyasäuqaŋgi ätnyä. Siŋi, tqu kpäsätŋqä itqänä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kimaŋi, Jisasi Iqu ätukqe. “Nyi wäuŋuä naqänäŋä iqu imäkkqeŋqä, he miiqä yäŋä iŋqä ikuwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosisi iqu qokä iquauä huiwä häuä ktäupŋqä ätukqeuŋi, Sämbatqä hiunji hapäŋga qäyä etaŋgqä-qe, he ymeqä qokä hŋquauqä huiwi, häuä ktäupnä. Suqä iiŋi, Mosisi iqu mikutäuqä ikqe, atqä-awäka ikutäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","He Sämbatqäŋgaŋi, ymeqä hŋquauqä huiwä häuä äktäutqäŋuwi, ii he Mosisi iqu kukŋuä-suqä ekqä iqueŋi qui mimäkqä itqäŋuwi. Iŋi Nyi Sämbatqäŋga ämaqä iqueä huiwi, eeqänäŋä äŋguä iwimäkqaŋgqeŋqe, he Nyinyqe suŋqä äkasuwä tätqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ämaqeuqä suqe, hiŋuä äqumbiyä duŋqänä hiŋgi miwäsäuqä pambu. Suqä naqä-qakuä jänäŋänäŋä duta iwäsäupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iŋgaŋi ämaqä Jerusälemätaŋä hui, “Ämaqä neyaqä naqä iqua pizqä päkpŋqä itqäŋuwi, Tä Qäqu maendiyä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Hiŋuä qumbu. Iqu ätnäŋä iqi qäyä ätqäuä ätqaŋgi, qu Iqueŋi maŋä hui mätquä danä iqäuä. Ämaqä Kraisi Ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Iqu etaŋgi, qu näqŋqä ämapu maeqä inä? ");
INSERT INTO mcr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kraisi Iqu äpqaŋgaŋi ämaqä-pqä hui näqŋqä mämeqä ipu, ‘Iqu äkiuta päniqätiyä’ tpu ipnuwiqä. Iŋäqe Ämaqä Tqueqä äpqäqeŋqe, ne näqŋqä ämeŋunä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisasi Iqu hiqäva-imäkqä aŋä mätnätaŋgqä ququawä iqi ätqäuä näqŋqä ävätäqäŋgaŋi, maŋä yäŋänäqŋqä tii ätukqe. “He Nyinyqä näqŋqä epu itaŋga Nyi äpqeŋqä-pqä näqŋqä yasämä eäŋäuä. Ga Nyi kŋuä indqäŋqä Ŋqä duta mapqä iqäqe. Nyi änändowatkqä Iquenyqe, he änyä maqŋqä eäŋuwi. Iqu naqä-qakuänäŋä Iquvqä. ");
INSERT INTO mcr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nyi Iqu änändowatqaŋgi Iquesa äpqäqä-qae, Nyi näqŋqä Iquenyqä eäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","I tqaŋgqeŋqä, qu Jisasi Ique a äkiqätäpu itmenätpu ipiyä-qe, hiunji i imäkqä iqu, Jisasi Iqueŋi mäwimeqä änyä etaŋgi, ämaqä-pqä hui Iqueŋi hipa hui mitmaqiyqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iŋäqe, ämaqä iu äpmamiŋuwitaŋä kuapänäŋi, Jisasi Iquenyqä quuvqä eqiyäpu, “Kraisi Iqu äpätqäŋgaŋi, Iqu nätmatqä ämaqä mimäkqänäŋä, Ämaqä Tqu imäkätŋqeuŋi ämäwqätäuniqätanä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi iqua ämaqä kuapänäŋä Jisasi Iquenyqe, “Iiŋi-iiŋiqä” hiyäkakä tnätqätaŋgä qätä äwipiyi, iquatä, hiqäva-imäkqä naqä iquatä, Ique a äkiqätäpu itmapŋqe, ämayukä-imaŋqä hŋquau ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iŋgaŋi Jisasi Iqu, “Nyi hesäŋi quäuqä mäpmeqä danä wäŋqäpu äpmami, änändowatkqä Iquenyqä umqänä. ");
INSERT INTO mcr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","He Nyinyqä qävqä ikipiyä-qe, Nyi pmetaŋgqeuŋi änä mäwqä ipiyä-qae, Nyiŋi mämäŋqumueqä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","I tquaŋgaŋi, Israitqä iqua, “Ne Iqueŋi mämäqumueqe, Iqu äkŋginyŋqä uwqaŋguti yaŋquatiyä? Iqu Israitqä iquneqä neyämaqä im-imä äpmakäwäŋuwä iuŋqä äwätä, näqŋqe ämaqä Israitqä ma huizi iqi äpmeŋuwiu vätŋqä ätqutiyä? ");
INSERT INTO mcr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iqu neŋi, ‘He Nyinyqä qävqä ikipiyä-qe, Nyi pmetaŋgqeuŋi änä mäwqä ipiyä-qae, Nyiŋi mämäŋqumueqä ipŋqäuä’ ätqäqe, Iqu kukŋuä iiŋi änääŋqä tqiyä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hiunji yeeqä ipu aquväqŋqä yäpakä naqänäŋä iqueŋi, Jisasi Iqu pämä ätqäuqe, maŋä yäŋänäqŋqä, “Ämaqä tqu-tqu quväkä ye äwiyqäqe, eqä nätŋqänä Nyinyqä äpänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Ämaqä äsqu-äsqu Nyinyqä quuvqä eqiyqe, eqä esquä häŋä-pmeqä-täŋi iqueqä yäpä iunda pquänä. Iŋi Goti Hanjuwä Iqueä tuwaŋuä iu ätnäŋqä-pa pquäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisasi Iqu kukŋuä iiŋi, Dŋä Äŋguä Iquenyqä ätkqe. Dŋä Äŋguä Iqueŋi, ämaqä Jisasi Iquenyqä quuvqä eqiyäpiyä iqua mapnuwäŋqeyi. Iŋgaŋi, Goti Hanjuwä Iqu Jisasi Ique ätuma äyätä, yoqä naqä vqe änänjqae, Dŋä Äŋguä Iqu iquauŋi, wimeqäŋqä-pqe, änänji. ");
INSERT INTO mcr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisasi Iqu i tqaŋgi äwipiyäŋgaŋi, ämaqä iqi äpmamiŋuwi, “Ämaqä Tqu naqä-qakuä, Hiŋuä-tqä Qäqueqä” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","I tqaŋguwäŋga, hui “Kraisi Ne ämineyätŋqä Goti Hanjuwä Iqu atäuŋuä ikqä Qäqueqä” ätkuwi. Iŋäqe, huiziqua “Oeyqä” ätkuwi. “Kraisi Iqu Galilisa pqäŋqä hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Goti Hanjuwä Iqueqä tuwaŋuä iuŋi, ‘Kraisi Iqu Dewitiquesaŋä hueqä-himqä heniqe,’ itaŋga ‘aŋä-himqä Dewiti iqu äpmamiŋqä Betlemä iutaŋäqu heniqä’ ätkqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","I ipiyi, Jisasi Iquenyqe, quwqä-quwä iŋgi-iŋgi ändmäkŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iiŋä ipu, hui Iqueŋi a kiqätanä-tpu ipiyä-qe, ämaqä-pqä hui Iqueŋi hipa hui mitmaqiyqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ämayukä-imaŋqä iqua, Parisi iquautä, hiqäva-imäkqä naqä iquautä aŋgumä wimeqaŋguwäŋga, “He Iqueŋi ätuma mapqe, suŋqä iqäuä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","I tquaŋguwäŋga, iquauä kimaŋi, “Ämaqä-pqä hui kukŋui, Ämaqä Tqu ätätŋqä-pa, matqä itqäŋuwiqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Itaŋga, Parisi iqua iquauŋi, “Heŋä-pqe, Iqu qäyasäqi etuma äwqiyä? ");
INSERT INTO mcr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","He ämaqä naqä yoqä-täŋä-pqä hŋqu, itaŋga Parisi-pqä hŋqu, Iquenyqä quuvqä heqiyätqätaŋgi äqunäŋuwätanä? ");
INSERT INTO mcr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ämaqä kuapänäŋä tä, suqä Goti Hanjuwä Iqu Mosisi ique äwikqeŋqä änyä maqŋqä eŋuwä iquauŋi, Goti Hanjuwä Iqu qui iwimäkätŋqä ae ätkqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Iiŋä tquaŋguwäŋgaŋi, iquautaŋä hŋqu, iqueqä yoqe Nekitimäsi, hiŋuiqänäŋäŋga Jisasi Ique äwimakqä iqu, huizi iquauŋi tii ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Neyaqä suqä duŋi, ne ämaqä hŋqueä kukŋui qätä äwiyätanä, itaŋga iqueqä wäuŋuä imäkätŋqä duŋi, qävqä ganä iani, iŋga iwäsäuatuŋqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Quwqä kimaŋi, “Äi! Si-pqä Galilisaŋä iqukitanä? Goti Iqueqä tuwaŋuä iu qävqä äŋguänä itnä, näqŋqä tii esŋqe. Galilisaŋi, hiŋuä-tqä hŋqu mapqä yäŋqiyä. Hmanjqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iŋgaŋi ämaqä eeqänäŋi quwqä aŋiuŋqä ae äweqaŋguwäŋga, Jisasi Iqu qoqoŋä Olipä yätuŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ziŋuitäŋi Iqu iqi ävämetä, hiqäva-imäkqä aŋiuŋqä aŋgumä äukqe. Iqu ququawä iqi pmetaŋga, qokä-apäkä eeqänäŋi Iqueŋqä äpqaŋguwäŋga, Iqu quamä äpme näqŋqä motquetŋqä ipäqäkqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iqu i motquetqätaŋga, ämaqä kukŋuä-suqeŋqä näqŋqä iquatä, Parisi iquatäŋi, apäkä hui ätuma äpäpu, qokä-apäkä iuqä hiŋuä iqi äkitqätekuwi. Apäkä ii, qokä-täŋä eäqä-qe, ämaqä hŋqutä-mända huiwä yaŋä iŋgaŋginyä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iwä iŋgaŋi Jisasi Iqueŋi tii ätukuwi. “Ämotqueqä Iquki, apäkä qokä-täŋä täsi, qokä huizitä huiwä yaŋä inyätqätaŋginyä äqunäŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kukŋuä-suqä Mosisi iqu änätapkqä iuŋi, ‘Apäkä suqä iiŋä iqaŋguwä iuauŋi, hikä pizqä päsqäŋqä’ ätnäŋqe, si änäänyä ätnä?” ");
INSERT INTO mcr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Qu kukŋuä i ätukuwi, Iqu kukŋuä äänä ätätqä Iquesa ämapu, kukŋuä mitpnuwä iŋqä yamwiqä äwikuwi. Iiŋä tquaŋguwäŋga, Jisasi Iqu äuesäuä, Iqueqä hipaitä qua hiŋä bu tuwaŋuä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qu yatŋqä äpakänä vqaŋguwäŋga, Iqu pämä ätqäuqe, tii ätukqe. “Ämaqä hesaŋä hŋqu suqä quvqä mimäkqä itŋqä etaŋgutqe, iqu apäkä täsiŋi, hikä kiŋganäŋi, iqu-ganä äpäsänä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iwä Iqu kukŋuä iiŋä ätuäqe, aŋgi äuesäuqe, qua hiŋä bu tuwaŋuä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","I tqaŋgi äwipiyi, qu eeqänäŋi hŋqunä-hŋqunä iqiŋi äväma äukuwi. Ga ämaqä quväukuä kuapänäŋä-täŋä iqua hiŋuiqä äwqaŋguwäŋga, ämaqä huizi qänaki äukuwi. Mä Jisasi Iqu iqi yqänä äuesäutaŋgi, apäkä ii Iqueuä hipeŋuä iqi yqänä ätqäumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Itaŋi Iqu pämä ätqäuqe, tii ätukqe. “Apäkä iiki, ämaqä eeqänäŋä täqi ätqäuŋuwi, äŋgi uwqäuä? Si kukŋuä mikitätŋqe, hmanda?” ");
INSERT INTO mcr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","I tquaŋga, ii ätukqe. “Naqä Iqukiyä, oeyä, hŋqu hmanjqä.” Ga Jisasi Iqu iiŋi tii ätukqe. “Nyi-pqe kukŋuä mämiktqä da imqänä. Si äuŋi, qänakŋi suqä quvqe mimäkqä pa iqätŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aŋgumŋi Jisasi Iqu qokä-apäkä iuŋi tii ätukqe. “Qua täu we-huŋqä vqe, Nyi Qäqunjqä. Ämaqä Nyi änyuvändmitätqä iqu, qaŋi heawiqä du mäwqä itä, iqueqä quuvqeuŋi we-huŋqä-täŋä-queyqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","I tquaŋga, Parisi iqua qätä äwipiyi, Iqueŋi tii ätukuwi. “Si kukŋuä awi, Tqä-täuŋqänänä ätätqäŋinyä. Iiŋqe ämaqe, quuvqä makiqiyqä ipŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ga kimaŋi, tii ätukqe. “He ‘Si Tqä suqeŋqä änatnyä’ ändquwi, naqä-qakuänäŋä ändqäuä. I etaŋgi Nyi Ŋqä-näuäŋi, aŋä äväma äpqeŋqätä, ŋŋ aŋä äumqeuŋqe näqŋqä eŋänä. Nyi näqŋqä iiŋä ämeŋqetaŋi, ämaqe Nyaqä kukŋui quuvqä eqäpŋqe. Iŋäqe he Nyaqä aŋä qakuiuŋqetä äkiuŋqä-pqä uwqaŋgundqe, he änyä maqŋqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","He ämaqeu iwäsäupiyäŋgaŋi, suqä qua täutaŋiŋqänä näqŋqä epu, iwäsäuquenjqä. Iŋäqe Nyi ämaqä hŋqueŋi, miwäsäuqä danä itŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Iŋi Nyi ämaqä hŋqueqä suqeŋqä iwäsäuqaŋgundqe, he Nyaqä iwäsäuqä iiŋä iqueŋqe, quuvqä heqäpŋqänänji. Ii tiiŋä dutayi. Nyi Ŋqä-näuänä miwäsäuqä iqä. Apiqu änändowatkqä Iqu, Nyitä wäuŋuä anä itqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kukŋuä-suqä he Mosisi iquesa ämepu qänaknä itqäŋuwä iuŋi, kukŋui tii ätnä. ‘Ämaqä hŋquaqu kukŋui asitaŋinä ätqiyi, iquaquiyqä kukŋuiŋqe quuvqä heqäpŋqe!’ ");
INSERT INTO mcr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nyi Ŋqä-näuäŋqä awä ätätŋqä Iqunji. Itaŋga huiziqu, Apiqu Nyi änändowatkqä Iqu, Nyiŋqä awä inä ätätqäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iŋgaŋi Parisi iqua yatŋqä tii äwikuwi. “‘Ŋqä Apiqueyqä’ ätŋi, ga Iqu äŋgi pmenä?” Itaŋi Jisasi Iqu ivatuwänäqe, kima tii ätukqe. “He Nyinyqätä, Ŋqä Apiquenyqätäŋi, änyä maqŋqä yqänä eäŋäuä. Iŋäqe he Nyinyqä näqŋqä hiqä-säpi, Apiquenyqä-pqe näqŋqä inä iqäpniŋgä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hiqäva-imäkqä aŋä ququawä iqiŋi, Jisasi Iqu mbqä pŋqä witaŋgqä-täŋä qäqi äpme, qokä-apäkä iuŋi näqŋqä ävätä, kukŋuä iiŋi ätmuiŋqe. Iqu ätnäŋä iqi qäyä pmetaŋgi, iŋgaŋi Iqueqä haŋä-iqä meqe, qäyu matimäuqä änä etaŋgi, ämaqä hŋqu Iqueŋi, a makiqätqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aŋgumŋi Jisasi Iqu quŋi tii ätukqe. “Nyi eväma umqänä. Hŋga-mändaŋi, he Nyinyqä qävqä yanä-tpu ipqe, hiqä suqä quvqe yqänä äwiŋqä iutanä päkombnuwiqä. He aŋä Nyi umqä iuŋi, matimäuqä ipnuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Israitqä Jerusälemä iu hiqäva-imäkqä naqä iqua, ii tqaŋgi äwipiyi, quwqä-quwä tii ätŋguwi. “‘He aŋä Nyi umqä iuŋi, matimäuqä ipnuwiqä’ ätqe, äänä etaŋgi tqiyä? Iqueqä-kiuä päknätŋqä ätqutiyä?” ");
INSERT INTO mcr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Itaŋga Iqu tii ätukqe. “He qua butaŋuenä etaŋgä, Nyi haqä yätutaŋunjqä. He qua täutaŋä iquenä etaŋgä, Nyi qua täutaŋunä manä. ");
INSERT INTO mcr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iiŋä etaŋgi ‘Hiqä suqä quvqä yqänä äwiŋqä iutanä päkombnuwiqä’ ae etqeqä. Ii tiiŋä etaŋgiyi. Nyi Ŋqä-näuä äpmeŋqä Iqunäŋqä quuvqä manjiqiyqä iqaŋgpqe, he heqä suqä quvqe yqänä wiqä, äpäkombnuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iqu kukŋuä i tquaŋga, “Si Tquki natnyä?” ätuäpu, yatŋqä äwikuwi. Iwä Iqu, “‘Nyi Iqunjqä’, ae äyä etqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nyi heqä suqä quvqeŋqe, kukŋuä kuapänä ätätmä ewäsäumätmä, itmä-qe, Nyi änändowatkqä Iqu, aaŋä naqä-qakuinä Tqä-qu etaŋgi, Iqueqä kukŋui Nyi qätä äwiyätŋqenä, qokä-apäkä qua täuŋiu ätuätŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iqu Iqueqä Kaniquenyqä tuätqätaŋgqä iiŋqe, qu kŋui mämeqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iutaŋi Iqu tiiŋä ätukqe. “He Ämaqeuqä Ymeqä Ekqä Iqunä indmepu, haqeqä ämanjiyäpiyäŋgaŋi, he Nyiŋqe, Nyi Ŋqä-näuä äpmeŋqä Iqunäŋqä näqŋqä epŋqäuä. Ga tiiŋä-pqeŋqä näqŋqä inä epŋqäuä. Nyi nätmatqä hui Ŋqä kŋuä iutanä mimäkqä danä itŋqeqä. Oeyä. Nyi kukŋuä eeqänäŋi, Apiqu ämändquakqenä ätätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nyi änändowatkqä Iqu, Nyitä anä äpmenä. Nyi nätmatqä Iqueuä äwiŋqeu qäyunä imäktŋqä iutaŋi, Ŋqä-näuänä pmetmŋqä hiŋuinä maŋqäŋqä itŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisasi Iqu kukŋuä ii tätqätaŋga, kuapänäŋi Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iŋgaŋi Iqu Israitqä Jerusälemä iu hiqäva-imäkqä iquautaŋä Iquenyqä quuvqä heqiyqaŋguwä iquauŋi, tii ätukqe. “He Nyaqä kukŋui mävquatämäuqä, a yäŋänäqŋqä äkiqätpqe, ga he Ŋqä wäuŋuäŋqä ämetqueqä-quenä pmepŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ga inä ma, kukŋuä naqä-qakuiŋqä näqŋqä eäpu, itaŋga kukŋuä iiŋä iqu, he ämiqä huiziqueqä äwiŋqä iuta huätä ewewqatäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","I tquaŋga, qu kimaŋi tii ätukuwi. “Ne awiqu Aprähamä iqueqä hueqä-himqä iquneyqä. Hea hŋgaŋä-pqe, ämaqä hŋqueqä wäuŋuä-wiyqä hiŋgi eätanä, iqueqä äwiŋqä yäpä imä mäpmeqä danä ituŋqueqä. I hitaŋgi ‘Kukŋuä naqä-qakuä iqu, he ämiqä huiziqueqä äwiŋqä iuta huätä ewewqatäŋqiyä-qe,’ suŋqä natnyä?” ");
INSERT INTO mcr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iqu iquauqä kukŋui kimaŋi, tiiŋä ätukqe. “Aaŋä naqä-qakuänäŋä etqä. Ämaqä eeqänäŋä suqä quvqä imäkätqäŋuwi, qu suqä iqueqä äwiŋqeuŋi qänaki vqä iquaiqä. ");
INSERT INTO mcr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ga ämiqä hŋqueqä äwiŋqeuŋi qänaki vqä iqua, iquauqä ämiqä iqueqä aŋiuŋi näweqä mäpmeqä itqäŋuwiqä. Oeyqä. Ymeqenä pmetpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iŋäqe Ymeqä Iqu he ewewqatqaŋguti, he suqä quvqä iqueqä äwiŋqeuŋi qänaki mävqä pmetpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nyi näqŋqe. He Aprähamä iqueqä hueqä-himqä iquenä etaŋgqä-qe, Nyaqä kukŋui heyaqä äwqä yäpä iŋgisaŋi mäwiqä etaŋgi, he Nyi ämbäkpŋqä itqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nyi Ŋqä Apiqu ae ämändquakqeuŋi, kukŋuä awi nätmatqä iiŋqä ätätqäŋänä. Ŋŋ he heqä suqä Nyi ämbäkpŋqä itqäŋuwi, ii hiniqu tqaŋgi äwikuwiunä imäkätqäŋäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iŋgaŋi iqua kima tii ätukuwi. “Neqä awiqu, Aprähamä iqueqä.” Ga Jisasi Iqu iquauŋi ätukqe. “Iiŋi naqä-qakuä he Aprähamä iqueqä kawäkenä hiqä-säpi, suqä asänäŋä Aprähamä iqu imiŋqä-pa, ii itqäpniŋgä. ");
INSERT INTO mcr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kukŋuä naqä-qakuä Nyi Goti Hanjuwä Iquesa qätä äwikqe, eeqänäŋi qäyä etätŋqä-qe, täŋgaŋi he Nyi pizqä bäkpŋqä itqäŋäuä. Suqä iiŋä ii, Aprähamä iqueqä suqä manä. ");
INSERT INTO mcr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","He hiqä hiniqueqä suqä iunä imäkätqäŋäuä” ätukqe. Iwä qu Iqueŋi tii ätukuwi. “Ne neqä nipaqa qokitä hiŋgi hiqaqä äwäyäkipu mänanyquä ikuwiqä. Oeyqä. Neqä Apiqu, Goti Hanjuwä Iqunänjqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iŋgaŋi Iqu tii ätukqe. “Goti Hanjuwä Iqu heqä hiniqu etaŋgutqe, he Nyiŋqä eŋguänänjqä. Ii tiiŋiuta etqä. Nyi Goti Iqutä anä äpmamiŋueä, äyä äquvepkqeqä. Nyi änyiŋqä Ŋqä dutanä äquvepkqä ma, Goti Hanjuwä Iqu änändowatqaŋgi äquvepkqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ga kukŋuä Nyi tqaŋgqe, he näqŋqä äŋguänä maeqä iquwi, ii he Nyaqä kukŋui meqäŋqe, maeŋgaŋgqä iutayi. ");
INSERT INTO mcr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","He Setänä, heqä heniqueqä ymeqä-quenji. Ga he iqueqä äwiŋqeunä yäŋä äqänäpu qänaknä iquenjqä. Iŋgata tii täŋgaŋqe, iqu ämaqä päsqäŋqä äpmenä. Itaŋga iqu suqä naqä-qakuä iuŋi qänaknä miqe, tiiŋä dutayi. Suqä aaŋä naqä-qakuä di, iqutä mäwiqä imiŋqe. Kukŋuä quaŋgä ätmiŋqe, ii aaŋä iqueqä yäŋiyi. Iqu ämaqä quaŋgä kukŋuä tqä-qu eä, itaŋga iqu quaŋgä kukŋuä tqeutaŋä kaniquvi. ");
INSERT INTO mcr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Iiŋiŋqe Nyi kukŋuä aaŋä naqä-qakuänäŋä di etqaŋgqetaŋi, he Nyaqä kukŋui quuvqä maeqiyqä da äyä itqäŋä. ");
INSERT INTO mcr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","He ‘Iqu suqä quvqä imäkqä-queyqä’ kŋuä eyätŋqä etaŋgutqe, ga Nyaqä suqä quvqä imäkätŋqe, ätnäŋä iqi ätäpu, maepiyä. Ä Nyi kukŋuä awä naqä-qakuä dinä ätätŋqä etaŋgundqe, iŋi Nyaqä kukŋui quuvqä maeqiyqe, suŋqä itqäŋäuä? ");
INSERT INTO mcr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Goti Hanjuwä Iqueqä ymeqä iqua, Iqueä kukŋui qätä äwiyätqäŋuwi. Ä he Iqueä kukŋui qätä mäwiyqä iquwi, ii tiiŋä etaŋgiyi. He Iqueqä ymeqä-quenä maeqä epiyä dutanji.” ");
INSERT INTO mcr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","I tquaŋga, Israitqä Jerusälemä iu hiqäva-imäkqä naqä iqua, Iqueŋi kima tii ätukuwi. “Ne tii äktqunä. ‘Si ämaqä Sämaliyataŋä Iqukiyqä. Ga dŋä quvqä hŋqu äktqäunä.’ Iiŋi ne naqä-qakuä äktqu?” ");
INSERT INTO mcr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Itaŋi Jisasi Iqu kimaŋi tii ätukqe. “Nyi dŋä quvqä hŋqu mandqäuqä inä. Hmanjqä. Itaŋgi Nyi Apiqueä yoqenä haqeu mamäutqätaŋga, he Nyaqä yoqe mändi äŋgittqäyätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nyi Ŋqä yoqe, haqeu mämamäŋqä itqäŋänä. Ŋŋ, Nyi yoqä naqä mamqeŋqä äwinyäŋqe, Hŋqunänjqä. Iqu ämaqä eeqänäŋä iquau Iwäsäuqä Iqueyi. ");
INSERT INTO mcr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nyi aaŋä naqä-qakuänäŋä etqänä. Ämaqä hŋqu Nyaqä kukŋui qänaknä imitätqe, mapäkoŋqä hea ique-ique pmetäniqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iŋgaŋi iqua kima tii ätukuwi. “Si e änatŋä imŋi, täŋgaŋi, tiinji. Dŋä quvqä hŋqu Si äktqäuŋqä iiŋqe, ne näqŋqä ae equnä. Aprähamä iqu-pqä, Goti Iqueqä hiŋuä-tqä iqua-pqe, ae äpäkoŋguwä-qe, Si tii änatnyä. ‘Ämaqä hŋqu Nyaqä kukŋui qänaknä imitätqe, iqu mapäkoŋqä hea ique-ique pmetäniqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Änääŋgä? Si neqä awiqu Aprähamä, ae äpäkoŋgqä iqueŋi ämäwqätäutnä, änatnä? Ä Goti Iqueqä hiŋuä-tqä iqua-pqe ae äpäkoŋguwiqä. Si ‘“Nyi tqunä” ätqänä,’ kŋuä kiyqiyä?” ");
INSERT INTO mcr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisasi Iqu kimaŋi tii ätukqe. “Nyi Ŋqä yoqe haqeu ämamänmitmqe, ii nätmatqä hiŋgiŋqä eŋqä-paŋi. Iŋäqe Ŋqä Apiqu, Iqu Nyaqä yoqe haqeu ämanmäutqänä. Iquenyqe, he ‘Neqä Goti Hanjuwä Iqueqä’ äyä ätqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Iŋäqe he Iquenyqe maqŋqä epu ätqäuä. Nyi, Ŋqä-näuäŋi Iquenyqe näqŋqä eäŋänä. Ga ‘Nyi Iquenyqe maqŋqeqä’ etmqe, ii Nyi ämaqä quaŋgätqä he eŋqä-paŋunä emqänä. Itaŋgi Nyi Iquenyqä näqŋqä ae eämä, itaŋga Nyi Iqueqä kukŋuä iunä qänaknä itqäŋä. ");
INSERT INTO mcr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Heqä tawiqu Aprähamä iqu, Nyaqä hiunji hiŋuä qunäniqeŋqä kŋuä indqänätäqäŋgaŋi, iqu yeeqä äwinymiŋqeqä. Itaŋi iqu hiŋuä i äqunäqe, aquvänä ikqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iwä iqua qätä i äwipiyi, tii ätukuwi. “Si Tqä quväukui 50 änä qäyä etaŋgi, Aprähamä iqueŋi Si hiŋuä äquŋgŋätanä?” ");
INSERT INTO mcr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ga Jisasi Iqueä kimaŋi, “Nyi naqä-qakuänäŋä etqänä, Aprähamä iqu matimäuqäŋgaŋi, Nyi Ŋqä-näuä Äpmeŋqä Iqunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","I tquaŋgqeŋqä, qu hikä ämepu Ique päsanä-tpu iqaŋguwäŋga, Iqu zä imäknä hiqäva-imäkqä aŋä täkŋiuŋi äväma, yäpaqäŋgisa äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisasi Iqu qaŋä äwätäqäŋgaŋi, ämaqä hiŋuä maqŋqä hŋque äquŋgqe. Ämaqä iqu känäwqä äwqä imdaŋi, hiŋuä maqŋqä iiŋäqu ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua Iqueŋi, “Näqŋqä Motqueqä Iquki, ämaqä tqu hiŋuä maqŋqä imäŋgqe, suqä quvqe tqueqäwä? Iqueqä-kiuätanä, kanä-känaisändanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yatŋqä i vqaŋguwäŋga, Jisasi Iqu, “Ämaqä iqu hiŋuä maqŋqä iŋqe, suqä quvqe, iqueqä-pqä ä iqueqä kanä-känäwqä-pqä duta hmanji. Ämaqe, qu ämaqä tque hiŋuä äqunäpu, Goti Hanjuwä Iqueqä yäŋänäqŋqeŋqä näqŋqä mapŋqä diŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","We yqänä tii hunätaŋgaŋi, ne Nyi änändowatkqä Iqueä wäuŋui imäkatuŋque. Ämaqe wäuŋuä miqä ipŋqe, hea heätŋqe qäqinji. ");
INSERT INTO mcr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nyi qua täu äpmeŋqe, qua täu We-huŋqä Vqä-qunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Iiŋä ätuäqe, Iqu qua bu makukuä äquteqe, makukuitä quae ättäqe, ämaqä iqueä hiŋuiu qua äwqäyätä, iqueŋi, “Eqä-huäŋä Silomä du asŋä qänämändŋqä uvä” ätukqe. (Yoqä ‘Silomäuä’ ätnäŋqä iqu, ‘ändowatqäuä’ ätnä.) Iŋi iqu äwäqe, asŋä qänämäŋgaŋga, iqueä hiŋui äŋguä heqaŋgi, iqu hiŋuä äŋguä qŋqä-qu äpkqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iŋgaŋi ämaqä, iqutä aŋä asä iqi äpmamiŋuwitä, ämaqä, iqu hiŋuä maqŋqä äpme mbqäŋqä nätmatqä isuaŋqä täuŋuä tätqätaŋgi äqunmiŋuwitäŋi, qu, “Ämaqä tqu mbqäŋqä täuŋuä ätqämanätŋqä iqutanä?” ätäpu yatŋqä iŋgäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yatŋqä i iŋgaŋguwäŋga, ämaqä hui, “Auqä, ämaqä iqu qäqueqä” tqaŋguwäŋga, hui, “Oeyä, iqu maetqe. Ämaqä iqu eŋqä-paŋä hŋqueqä” ätkuwi. I tqaŋguwäŋga, ämaqä iqu iqueqä-kiuä, “Nyi ämaqä iqunä qäqunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Qu iqueä kimaŋi, “Si hiŋui äänä itnä qäŋginyä?” ätuäpu, ique yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yatŋqä i vqaŋguwäŋga, iqu, “Ämaqä ‘Jisasiuä’ ätätqäŋuwä Iqu, qua ättäqe, nyaqä hiŋuiu qua äŋqiyätä, ‘Asŋi, eqä-huäŋä Silomä du qänämändŋqä uvä’ dqaŋgi, nyi äumi, asŋä tii äqänämänätmäŋgaŋi, hiŋuä qe äqäŋgänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","I tquaŋgaŋi, qu, “Ämaqä Iqu äŋgiwä?” ätukuwi. Iqu, “Nyi änyä maqŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Iŋgaŋi qu ämaqä hiŋuä maqŋqä imiŋqä iiŋä iqueŋi, Parisi iquauŋqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisasi Iqu qua ättätä ämaqä iqueä hiŋuä äŋgui, Sämbatqä hiunji hapä pmeqäŋga iwimäkkqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iiŋqe, Parisi iqua-pqe, ämaqä iqueŋi, “Si hiŋui, änä itnä äqäŋginyä?” ätuäpu, yatŋqä ämikuwi. Iqu quŋi, tii ätukqe. “Iqu nyaqä hiŋuä täuŋi, qua ŋqäyqaŋgi, nyi asŋä äqänämänätmä, täŋgaŋi hiŋuä äŋguä sä äqänäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","I tquaŋgaŋi, Parisi hŋqua, “Ämaqä hiunji hapä pmeqä duŋqä suqe, qänaknä miqä iqäqä Tqu, Goti Hanjuwä Iquesaŋä-qu maetqenä” tqaŋguwäŋga, hŋqua, “Ämaqä suqä quvqä imäkqä-qu eäqe, nätmatqä ämaqä mimäkqänäŋä tiiŋi, äänä imäkätŋqäwä?” ätkuwi. I ätnäpiyitaŋi, naqä-hŋqunä mäpmeqä danä iŋgi-iŋgi äktqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iiŋä ipu, qu iqueŋi, aŋgumä yatŋqä tii äwikuwi. “Ämaqä saqä hiŋui, äŋguä ikimäkqä Iquenyqe, si ‘tqueqä’ ttŋqäwä?” Yatŋqä i vqaŋguwäŋga, ämaqä iqu tii ätukqe. “Iqu Ämaqä Hiŋuä-tqä-queqä.” ");
INSERT INTO mcr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iŋäqe, Israitqä Jerusälemä iu hiqäva imäkmiŋuwä iquauqä naqä iqua, “Ämaqä iqu hiŋuä maqŋqä-qu eŋqe, täŋgaŋi iqu hiŋuä äyä äqäŋgiyä” kŋuä mämeqä ipu, ämaqä iqueqä kaniquesä känäutä kukŋuä ätuätumepu, yatŋqä tii äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ämaqä tquenyqe, qe, ‘Yeqä ymeqä hiŋuä maqŋqä imäŋgqeqä’ ätqiyä iqutanä? Ga iqu täŋgaŋi hiŋuä äŋgui, äänä itä äqäŋgiyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Qu yatŋqä i vqaŋguwäŋga, ämaqä iqueqä kaniqutä känaisä ämävayi, “Ye näqŋqe. Iqu yeqä ymeqä-qu etaŋgi, iqu hiŋuä maqŋqä imäŋgqeqä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","“Iŋäqe, ye änyä maqŋqe. Iqu täŋgaŋi hiŋui, äänä itä äquŋguti. Ämaqä ique äŋguä imäkätä hiŋuä qänätŋqä imäkqä Iquenyqe, ye maqŋqeqä. Iqu ae naqä eŋqä-qae, yatŋqä iqueqä-kiuä wipu. Ga iqu ‘iinjqä-iinjqä’ hetätŋqänänyä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Iyaqu ii ätukiyi, ämaqä naqä iquauŋqä zä etaŋgiyi. Ämaqä iiŋä iqua, näwinyä pmua imäkäpu tii ätkuwi. “Ämaqä hui Jisasi Iquenyqe, ‘Iqu Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu Ique ätekqä Iqueyqä’ tqaŋgpqe, aŋä aquväqŋqeu aquvä äqänäpu, Goti Hanjuwä Iqueä yoqe haqä mämamäuqä ipŋqäuä.” Iiŋiŋqe, ämaqä iqueqä kaniqutä känaisäŋi zä isinyä, “Iqu ae naqä-queqä. Yatŋqe, iqueqä-kiuä wipiyä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Iqua ämaqä hiŋuä maqŋqä imiŋqä ique, aŋgumä kukŋuä ätuätumapiyi, “Ämaqä si äŋguä ikimäkqä Iquenyqe, ne näqŋqe. Iqu suqä quvqä Iqä-quvi. Iŋi, si Goti Hanjuwä Iqueqä yoqe, haqeqä ämamäutnä, naqä-qakuänäŋä natiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","I tquaŋguwäŋga, ämaqä iqu, “Nyi maqŋqe. Iqu suqä quvqä Iqä-quti, miqä-quti? Nyi ŋqä hiŋui, maqŋqä iŋqä-qe, täŋgaŋi nyi hiŋuä äqänmä, näqŋqe, iiŋqänä eqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","I tquaŋga, qu iqueŋi, “Si hiŋuä maqŋqä eäŋi, saqä hiŋui äŋgui, Iqu äänä itä ikimäkqiyä?” ätuäpu yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iŋgaŋi, “Nyi iqi ae etqaŋga, he qätä mänyiyqä iquwi. Iŋi, aŋgumŋi qätä suŋqä nyipŋqäwä? Iŋi he-pqe, Iquenyqä quuvqä heqäpŋqätanä?” ");
INSERT INTO mcr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","I tquaŋgqetaŋi, qu iqueŋi kukŋuä quvqä tii ätukuwi. “Ämaqä Iquenyqä quuvqä heqiyqe, si äyuwä. Ne quuvqe, Mosisi iquenyqä heqiyqä iquneyqä. ");
INSERT INTO mcr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ne näqŋqe, Mosisi iquenyqä eäŋu. Goti Hanjuwä Iqu iqueŋi kukŋuä ätumiŋqe. Iŋäqe, Ämaqä Tqu äkŋgisa äpqä-quti? Ne Iquenyqe, änyä maqŋqä eäŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Iŋgaŋi iqu, “Ämaqä Iqu nyaqä hiŋuä äŋguä änyimäkqeŋqe, he ‘Ne Iquenyqä änyä maqŋqä eäŋunä-qe,’ änääŋqä tqäuä? ");
INSERT INTO mcr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ne näqŋqä äyuwä. Goti Hanjuwä Iqu ämaqä suqä quvqä imäkqeuŋi, qätä mäwiyqä danä yänä. Ämaqä Ique qätä äwiyäpu, Iqueqä äwiŋqä du imäkqaŋguwä iunä wiyätŋqä äyuä. ");
INSERT INTO mcr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Qua tqu imäkkqetaŋi, täŋgaŋqe, ‘Ämaqä hŋqu, ämaqä hiŋuä maqŋqä imäŋgqä hŋque, äŋguä hiŋuä qänätŋqä imäkqeqä’ matqä itqäŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iŋi Ämaqä Tqu Goti Hanjuwä Iquesa mapqä-säpi, Iqu nätmatqä hui mimäkqä iquäniŋgä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","I tquaŋga qu, “Si suqä quvqä du imäŋgŋä, iunä yqänä äpmeŋi, iŋi si täŋgaŋi, ne näqŋqä mänätapqä isŋqeqä” ätuäpu, qu iqueŋi, aŋä aquväqŋqeutaŋi, huätä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisasi Iqu ämaqä iquenyqe, “Aŋä aquväqŋqä iutaŋi, huätä ändowatqäuä” tqaŋgä äwiyäqe, Iqu ämaqä iquenyqä qävqä ikitä, ique äwimeqe, “Si Ämaqeuqä Ymeqä Ekqä Iquenyqe quuvqä eqinyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I tquaŋgaŋi, ämaqä iqu ämävauqe, “Ämaqä Naqä Iquki, Ämaqä Iqu äsque, nyi di. Ga nyi Iquenyqä quuvqä heqämqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","I tquaŋga Jisasi Iqu ämaqä iqueŋi, “Si Ämaqä Iqueŋi hiŋuä ae äqunäŋinyä. Ämaqä Tä äktätŋqä Tqu, ii Qäqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iŋgaŋi ämaqä iqu, “Naqä Iquki, nyi quuvqä eqiyqänä” ätuätä, Jisasi Iqueä yukä iqi qoŋä äuktäutä, Iqueä yoqe haqeqä ämamäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iŋgaŋi Jisasi Iqu, “Nyi qua täuŋqe, ämaqeuqä suqä iwäsäuqäŋqä äpkqe. Iŋi ämaqä hiŋuä maqŋqä iŋuwi, hiŋuä qäŋgaŋgpi, hiŋuä äqänäŋuwi, hiŋuä maqŋqä ipŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi Jisasi Iqutä iqi anä ätqäpiyä iqua, i tqaŋgi äwipiyi, “Ne-pqe hiŋuä maqŋqä-qune etaŋgi ätätqäŋinyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","I tquaŋguwitaŋi Jisasi Iqu, “He hiŋuä maqŋqä hiŋuä pisquenä epqe, hiqä suqä quvqetaŋi haŋä-iqä mämeqäŋqe. Iŋäqe he, ‘Ne hiŋuä äqänäŋunä’ ätquwä-qae, hiqä suqä quvqe, täka yqänä himäkätäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisasi Iqu, “Nyi naqä-qakuänä tii etqänä. Ämaqä sipsipqä iquauqä täkŋä yäpä yäŋgisaŋi, hänaqeta mäpeyqä, awä hŋqäqisa äpäkeyätä äpeyqä iqu, quwä-meqä-quvi. ");
INSERT INTO mcr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ämaqä täkŋä hänaqeta äpeyqä iqu, iqu sipsipqä iquau miqä iquvi. ");
INSERT INTO mcr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Itaŋga ämaqä täkŋä hänaqä miqä iqu, iqueŋi qŋqaŋä wuteyqaŋguti, sipsipqä iqua ämiwiyqä iqueqä quväki, qätä wipnä. Ga iqu iquauqä yoqe, kikiŋä ätuätä, yäpaqä mäŋgisa ätuma wänä. ");
INSERT INTO mcr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Iŋi iqu iqueqe, eeqänä ätuma äwätä, hiŋuiqä wimenä. Sipsipqe, qu iqueä quväkiŋqä näqŋqä epiyä-qae, ique qänaki wivändpnä. ");
INSERT INTO mcr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ämaqä huitaŋä hŋqu tquaŋgutqe, qu iqueqä quväkiŋqä änyä maqŋqä epiyä-qae, iqueŋi qänaki mävändqä danä zä upŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisasi Iqu kukŋuä ktqä iqu tquaŋgqe, qu kŋuä äŋguä mämeqä ipu, “Iqu suŋqä ätqutiyä” tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Qu näqŋqä äŋguänä mämeqä iqaŋguwiŋqä, Iqu aŋgumŋi, “Nyi naqä-qakuänäŋä etqä, Nyi sipsipqä iquauqä Täkŋä-hänaqä Iqunjqä. ");
INSERT INTO mcr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ämaqä Nyi änyä etaŋga hiŋuiqä äpätqäŋuwi, qu quwä-meqä-qua etaŋgi, sipsipqä iqua quŋi qätä mäwiyqä danä itqäŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nyi Täkŋä-hänaqä Iqunji. Ämaqä hŋqu Nyita äpeyätqe, häŋä äŋguä iqumuatnä äpme, iqu täŋgisa äyapätä mäŋgisa äwätä itä, itaŋga iqu qätaqä näqisquäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Quwä meqe äpquwi, quwä ämepu, pizqä äpäsäpu, itaŋga qui imäkqä dinänji. Nyi iiŋä maetqe. Nyi äpkqe, qu häŋä-pmeqeŋqe äwa miqä, kuapänä mapŋqä diŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nyi Sipsipqä-miqä Äŋguänäŋä-qunji. Iŋi ämaqä sipsipqä äŋguänä miqä iqu, sipsipqeuŋqä yäŋä winä. ");
INSERT INTO mcr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ämaqä mbqä metŋqä sipsipqä qanyinä yakuä miqä iqu, hiveqä hiqiyqä pqaŋgi äqunäqäŋgaŋi, iqu sipsipqä-miqä naqä-qakuä-qu hma etaŋgi, itaŋga sipsipqe, iqueqä maeqä etaŋgä, iŋi iqu quŋi äväma zä wänä. Ga hiveqä hiqiyqä iqu äpäqe, quŋi ändämiqaŋguti, qu näŋä-täqi upnä. ");
INSERT INTO mcr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ämaqä iqu mbqä metŋqänä wäuŋuä itä, sipsipqeŋqä kŋuä mämeqä iqä-qae, zä wänä. ");
INSERT INTO mcr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nyi Sipsipqä-miqä Äŋguänäŋä-qunji. Apiqu Nyinyqä näqŋqä etaŋgi, ga Nyi Apiquenyqä-pqä näqŋqä eŋä. Asä iŋi, Nyi Ŋqä sipsipqeŋqä näqŋqä etaŋgä, qu-pqe Nyinyqä näqŋqä eŋä. Iŋi Nyi sipsipqä yätamäkqäŋqä päkonmä. ");
INSERT INTO mcr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Täkŋä huiziuŋi, Nyaqä sipsipqä hui-pqe äpmeŋä. Ga Nyi quŋi ätuma pmqänä. Iŋi Nyi ‘daanä’ tquaŋgaŋi, qu Nyaqä quväki qätä änyiyäpu äppŋqäuä. Ga sipsipqä iiŋi, naqä-hŋqunä etaŋgpi, ga quwqä Ämiqe, Hŋqunä hiäniqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nyaqä häŋä-pmeqe aŋgumä mamniqä etaŋgi, Nyi sipsipqeuŋqä yäŋä wämä. Ga iiŋä imqä itqätaŋgqetaŋi, Apiqu Nyinyqä äwinyä. ");
INSERT INTO mcr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nyaqä häŋä-pmeqe, ämaqä hui hiŋgi quwqä äwiŋqä dutanä, qui mimäkqä ipnä. Nyi änyiŋqä Ŋqä duta, yäŋä wämqe. Nyi Ŋqä häŋä-pmeqe ävätmä, itaŋga aŋgumä meqäŋqe, yäŋänäqŋqä ämeŋä. Ŋqä Apiqu Nyi iiŋä imäkmqä ändkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisasi Iqu i tqaŋgqeŋqä, Israitqä Jerusälemä iu hiqäva imäkmiŋuwä iqua aŋgumä iŋgi-iŋgi äktqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kuapänäŋä hui, “Iqu dŋä quvqä-täŋu eä, qämä-qämä itä i ätqi. He Iqueŋi qätä suŋqä wiyqäuä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Itaŋga hui, “Ämaqä dŋä quvqä-täŋä hŋqu, kukŋuä tiiŋi matqä danä yänä. Dŋä quvqe, ämaqä hiŋuä maqŋqä itaŋguwä iuŋi, hiŋuä qämbŋqe äänä imäkäniqiyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iŋgaŋi qu hiunji naqä, hiqäva-imäkqä aŋi Goti Iqueŋi aŋgi imäkkuwiŋqä kŋuä indqänäpu, yeeqä ipŋqä Jerusälemäŋi aquvä äqäŋguwi. Iŋi hiunji dŋä maeŋqä, isqäŋga imäkmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisasi Iqu Goti Hanjuwä Iqueä hiqäva-imäkqä aŋä täkŋä yäŋgisa, Solomonä iqueqä aŋä mätävätiŋiqä ätmiŋuwä iu ikämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","I ikitqätaŋga, Israitqä iqi hiqäva imäkmiŋuwä hŋqua, Ique aquvä äwqämbiyi, “Ne Sinyqä kŋuä qämä-qämä iŋqä ämetuŋque, Si awi äkŋga nattŋäŋqäwä? Si Kraisi Ämaqä ne ämineyätŋqä Goti Hanjuwä Iqu ätekikqä Iquki eäŋi, Si kukŋuä ktqä matqä, naqä-qakuänäŋä natiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","I tquaŋguwäŋga, Iqu kimaŋi, “Nyi ‘Iinjqä-iinjqä’ etqaŋga, he Nyi tqaŋgqä duŋi, qätä mänyiyqä ipu, quuvqä maeqiyqä äyä itqäŋä. Nyi nätmatqä Apiqueä yoqeta imäkätŋqe, ga ii Nyinyqe, qe ämetquetqänä. ");
INSERT INTO mcr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","I metqueqaŋga, he Nyaqä sipsipqä-quenä maeqä ipu, Nyinyqe quuvqä maeqiyqä äyä itqäŋä. ");
INSERT INTO mcr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsipqä Nyaqä di, qu Nyaqä quväki qätä nyiyqaŋgä, Nyi quŋqä näqŋqä eŋä. Iŋi qu Nyi qänaki nyivändpnä. ");
INSERT INTO mcr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ga Nyi quŋi, quuvqä hea ique-ique pmeqe vqaŋgmdi, qu mapäkoŋqä danä iqäŋqe. Itaŋga ämaqä-pqä hui, Nyaqä hipa iutaŋi huätä mämändauqŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Apiqu sipsipqä Nyi ändapkqä Iqu, Yäŋänäqŋqä-qu eä, eeqänäŋi ämäwqätäuä. Iŋi ämaqä-pqä hui, Apiqueä hipa iutaŋi mämotauqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nyitä Apiqutäŋi, Ye naqä-hŋqunäyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","I tqaŋgqeŋqä, Israitqä iqua aŋgumä hikä ämepu, Ique päsanä-tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","I iqaŋguwäŋga, Jisasi Iqu quŋi, “Nyi wäuŋuä äŋguänäŋä Apiqu ändapkqe, heyaqä hiŋuä iqisa kuapänä imäkätŋqe. He hiki, wäuŋuä iquautaŋä äkisqueŋqä bäkpŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","I tquaŋga qu, “Ne Siŋi, hiki wäuŋuä äŋguänäŋä imäkätqäŋiŋqä kpäsatuŋquä miqä iqu. Si Ämaqä hiŋgäŋquki qäyä eänä, Goti Hanjuwä Iqu eŋqä-pa etnä, Ique äkittqiyqaŋgŋiŋqä ii kpäsatuŋquä iqunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iŋgaŋi Jisasi Iqu quŋi, “Heqä kukŋuä-suqeŋqä tuwaŋuä äqänäŋqeuŋi, Goti Hanjuwä Iqueqä kukŋui tii äqänä. ‘Nyi henyqe, “goti-quenjqä” ätkqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Goti Hanjuwä Iqueqä kukŋuä tuwaŋuä äqänäŋqe, hea ique-ique naqä-qakuänäŋä äqänä äwi. Iŋi Goti Hanjuwä Iqu ämaqä Iqueqä kukŋuä äwikqä iquauŋi, ‘he goti-quenjqä’ ätukqe. Iŋäqe Nyi Ämaqä Goti Hanjuwä Iqu atäuŋuä ändeetä, qua täuŋqä änändowatkqä Iqunä, ‘Goti Hanjuwä Iqueqä Ymeqä-qunjqä,’ tqaŋgqeŋqä he, ‘Si Goti Hanjuwä Iqu eŋqä-pa etnä, Iqueŋi äkittqiyenyä’ ätquwi, äänä etaŋgi ätqäuä? ");
INSERT INTO mcr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nyi wäuŋui, Apiqueä di mimäkqä-säpi, he Nyinyqe quuvqä maeqiyqä iqäpninji. ");
INSERT INTO mcr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Iŋäqe, Nyi imäkqe, he Nyaqä kukŋui naqä-qakuä mimäkqä ipiyäqe, Nyi wäuŋuä imäkätŋqeuŋi quuvqä heqäpŋqe. Iiŋä iutaŋi he näqŋqä ämepu, Apiqu Nyi nyinätaŋgi, Nyi Ique änyäŋqä iuŋqe, näqŋqä äŋguänäŋä epŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iŋgaŋi qu aŋgumä Iqueŋi a kiqätanä-tpu iqaŋgä, Iqu quvaqä hipa iuta äutakŋga äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iqisaŋi, Iqu aŋgumä eqä Jotänä ique näŋgisaŋqä äwäqe, Jonä iqu änyäŋäŋga ämaqä asŋä äqämiŋqä iqi äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Iqiŋi, ämaqä kuapänäŋi, “Jonä iqu nätmatqä ämaqä mimäkqänäŋä di mimäkqä qäyä itä, Ämaqä Tquenyqä ätkqe, eeqänäŋi naqä-qakuiqä” ätäpu, Ique äwimakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iŋgaŋi ämaqä kuapänäŋi, Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iŋgaŋi, ämaqä aŋä-himqä Betani pmeqä hŋqu, yoqä Lasarusi, iqu täŋä-yaqä ämakqe. Betani, Mäliya Mala näsuaqiyqä aŋä-himqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Apäkä Mäliyai, qänakŋi eqä sisnyaŋä-weqe ämetä, Naqä Iqueä yukä bu äwiquatätä, iiyqä detä yemä iwimäkkqä iiyi. Lasarusi täŋä-yaqä ämakqä iqu, iiyqä kasiqä-quvi. ");
INSERT INTO mcr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Iŋgaŋi iqueqä kasiqä-uaqu Jisasi Iquenyqä, “Naqä Iquki, Tqä näueqä Si kiiŋä äkinyätŋqä iqu, täŋä-yaqä äwinä” ätäsinyä, kukŋuä ändowatkiyi. ");
INSERT INTO mcr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","I äwiyäqe, Jisasi Iqu, “Täŋä-yaqe, näwinyä päkoŋqäŋqä maetqe, Goti Hanjuwä Iqu yoqä naqe, iuta meqaŋguti, ga Iqueqä Ymeqä-pqä Iqu inä meŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iqu Mala, Mäliya, Lasarusi näsquaŋqä kiiŋä äwinymiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jisasi Iqu Lasarusi iquenyqe, “Täŋä-yaqä äwinä” tqaŋgä äwiyäqe, Iqu mäwqä danä hiunji hŋquaqu, iqi inä äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","I äpmeqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi, “Ne aŋgumä qua Jutiyaŋqä äwanä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","I tquaŋga iqua, “Näqŋqä-vqä Iquki, Israitqä Jerusälemä iu hiqäva-qäyqä iqua, qu hikä kpäsanä-tpu iquwi, hŋga hma eŋqe, Si aŋgumä asä duŋqä utŋqä inyä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iqu kimaŋi, “Hiunji ique-iqueŋi, weŋi hŋgaŋqä äuŋga mäwqä iqä maeqä inä?” ätukqe. “Iŋi ämaqä äsqu-äsqu we hunätaŋga äwqe, iqu we-huŋqä ique äqunä äwqi. Näŋi-täqi äqutäutä, quanŋä mapäkŋqä danä iquänä. ");
INSERT INTO mcr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Iŋäqe, hea witaŋga äwqä iqu, iquesaŋi we mauŋqä etaŋguti, näŋi-täqi qutäuquäniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","I ätuäqetaŋi, tii ätukqe. “Neqä neyämaqä Lasarusi iqu hiqaqä äwinä. Iŋäqe Nyi ique ävauqumuatmqä diŋqä umqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","I tquaŋgaŋi iqua, “Naqä Iquki, iqu hiqaqä äwiŋqe, äŋguä heŋqiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisasi Iqu Lasarusi iqu pizqä etaŋgqeŋqä tquaŋgi, iqua, “Qanyä hiqaqä witaŋgi ätqiyä” tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","I iqaŋguwäŋga Iqu awä jänä tii ätukqe. “Lasarusi iqu ae äpäkoŋgqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Iŋäqe, he Nyinyqä quuvqä heqäpŋqä diŋqä indqänätmä, Nyi iqutäŋi mäpmeqä iqeŋqä yeeqä iqä. Täŋgaŋi ne iquenyqä yqä äwanä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","I tquaŋgaŋi, Tomasi “Ymeqä Qäyawiqä” ätumiŋuwä iqu, wäuŋuäŋqä ämotquamiŋqä huizi iquauŋi, “Ne-pqe, neqä Naqä Iqutä anä päkonatuŋquänä äwanä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisasi Iqu ätimäutäqäŋgaŋi, “Qu Lasarusi iqueä huiwi, hikä himaŋiu equwi, hea hŋquaqu-hŋquaqu ae äpäwqiyä” tqaŋgä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanisaŋi Jerusälemäŋqe, kiŋämä maetqe, qäqiqinji (3 kilomita). ");
INSERT INTO mcr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Iiŋä etaŋgi, Israitqä kuapänäŋi, Malaqätä Mäliyaqätä kasiqäqu pizqä etaŋgqeŋqä, “aueqä” ätuäpu, äwqä haŋuä iwimäkpŋqä äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Malai “Jisasi Iqu äpqiyä” tqaŋgä äwiyäqe, Mäliya aŋä yäpä yämä qäyä äpmetaŋgi, ii Ique wimetŋqä ätimäwa äpäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ii Jisasi Ique äwimeqe, “Naqä Iquki, Si täqi pmeqä-säpi, nyaqä nyiqäqu mapäkoŋqä iquäniyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","“Iŋäqe, nyi näqŋqe. Täŋgaŋä-pqe, Si Goti Hanjuwä Ique, nätmatqä hnjuaŋqä yatŋqä vqaŋgtqe, Iqu äktapäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","I tquaŋga, Iqu Malaŋi, “Tqä siqäqu häŋä vauŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ii kimaŋi, “Nyi näqŋqe, hiunji yäpakä qokä-apäkä aŋgumä vauqaŋguwäŋgaŋi, iqu ävauniqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iŋgaŋi, Iqu iiŋi, “Nyi ämaqeu aŋgi ävauqumuatätmä, Häŋä-pmeqä Iqunjqä” ätukqe. “Ämaqä Nyinyqä quuvqä eqämitätqä iqu, äpäkonätqä-qe, häŋä pmeniqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Itaŋga ämaqä häŋä äpmapu Nyinyqä quuvqä eqämipqe, mapäkoŋqä danä iqäŋqe. Iŋi si kukŋuä täŋqe quuvqä eqänä?” ");
INSERT INTO mcr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","I tquaŋga ii, “Naqä Iquki, nyi quuvqä eqiyqänä” ätuätä, “Si Goti Hanjuwä Iqueqä Ymeqä-quki eänä, ga Kraisi ne äminesŋqä atäuŋuä äktekqä Iquki eänä, itaŋga Goti Hanjuwä Iqu, ‘Qua täuŋqä äpäŋqiyä’ ätkqä Iqukiyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mala ii ae ätuäqetaŋi, Iqueŋi äväma, Mäliyaŋqä äwäqe, kukŋuä ätuätumetä, iiŋi qeiqinyä, “Näqŋqä-vqä Iqu näŋisa sinyqä ätqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mäliyai iiŋä äwiyäqe, äpakä miqä Jisasi Ique wimetŋqä maqänänä äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisasi Iqu aŋä-himqä Betanisaŋi, näŋgisa Mala äwimakqä iqi yqänä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ämaqä Mäliya ‘aueqä’ ätuäpu, iisä aŋiu anä äpmamiŋuwi, ii häuququenyä itä, ätimäwa uwqaŋgi äqumbiyi, qu, “Ii kŋui, qua equwä duta qäyätŋqä äwqiyä” kŋuä vqaŋgi, ii qänaki äwivändkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mäliya Jisasi Iqu pmetaŋgqä iqi ätimäutä, Ique äqunäqe, Iqueqä yukä iqi qoŋä äwoktäutä, “Naqä Iquki, Si täqi pmeqä-säpi, nyaqä nyiqäqu mapäkoŋqä iquniŋgä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","34","Jisasi Iqu Mäliyatä, ämaqä iisä anä äpmapiyitä, qu ka ipu kŋuä qäyqaŋgä äqunäqe, Iqu äwqä tnäŋä imäkätä, quvepki hikänä uwqiyqaŋgi, Iqu änä miqä itä, “He iqueŋi quae äkŋgi equwäwä?” ätukqe. I tquaŋgaŋi, “Naqä Iquki, Si hiŋuä qundŋqä äwanä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iŋgaŋi, Jisasi Iqu kŋuä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iiŋqe Israitqä iqua tii ätŋguwi. “Hiŋuä qumbu. Iqu Lasarusi iquenyqä kiiŋä wiŋgaŋgiyi.” ");
INSERT INTO mcr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","I tqaŋguwäŋga, hŋqua, “Ämaqä hiŋuä maqŋqä ique äŋguä imäkqä Tqu, Lasarusi iqu mapäkoŋqä yätŋqä yäŋänäqŋqä maeqätanä?” ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iŋgaŋi, Jisasi Iqu aŋgumä äwqä tnäŋä imäkätä, quvepki hikänä uwqiyqaŋga, hikä himaŋä iqueqä huiwi pŋqä ekuwä iuŋqä äukqe. Hikä himaŋä iuŋi, hikä hŋqu qŋqaŋä äptänmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iqi ätimäuqe, “Hiki huätä hutepiyä” ätukqe. I tquaŋgaŋi, Mala, pizqä iqueqä kasiqi, “Naqä Iquki, hea hŋquaqu-hŋquaqu ae äpäwqe, pizqä piyaŋä qäyäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ga, Iqu iiŋi, “Nyi tii äyä äktqe. ‘Si quuvqä eqiyqäti, Goti Hanjuwä Iqueä yäŋänäqŋqe hiŋuä qundŋqinyä.’” ");
INSERT INTO mcr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Qu iŋgaŋi, hikä qŋqaŋi huätä äutekuwi. I huteqaŋguwäŋgaŋi, Iqu hiŋuä haqä yätu äqänä, “Apiquki, Si Nyi qätä nyiyqaŋgŋiŋqä, Nyi ‘äŋguiqä’ äktqä. ");
INSERT INTO mcr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nyi näqŋqe. Si hea ique-ique qätä änyiyätqäŋä-qe, ämaqä täqi ätqäuŋuwä tä, Si änändowatkŋiŋqä qu näqŋqä hipŋqeŋqä i äktqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iqu i ätuäqe, tääqä yäŋänäqŋqänä, “Lasarusi iquki, täŋgisa biyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","I tquaŋgaŋi, iqu yukä-hipa-himiu, yuä huäqä huätŋqä-qu, täŋgisa äpkqe. I pqaŋgaŋi, Jisasi Iqu quŋi, “Yuä huäqe, huätä vasqiyäwqatpiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iŋgaŋi ämaqä Mäliyatä äpkuwi, Iqu i imäkqaŋgi äqumbiyäŋgaŋi, kuapänäŋi, Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Iŋäqe, hŋqua aŋgumä äwäpiyäŋgaŋi, Parisi iquau äwimepu Jisasi Iqu i imäkqaŋgqeŋqä awä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","I äwipiyi, hiqäva-imäkqä naqä iquatä, Parisi iquatäŋi, ämaqä yoqä-täŋä huizi iquau aquvä qämbŋqä itmakuwi. Aquvä äqämbiyi, “Ämaqä nätmatqä ämaqä mimäkqänäŋä du imäkätŋqä Tquenyqe, ne äänä yatuŋquäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Iqu i qäyä iqaŋguti ne hiŋuinä äqunatqe, ämaqä eeqänäŋä Iquenyqä quuvqä heqiyqaŋgpi, ämaqä Romätaŋä iqua äpäpu, neyaqä hiqäva-imäkqä aŋitä ämaqetäŋi, qui inemäkpŋqäuä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iquautaŋä hŋqu, iqueqä yoqe, Käyäpasi iquvi. Quväukuä iqueŋi, hiqäva-imäkqä naqä iquau miqä äpme, quŋi, “He kŋuä maeqä itqäŋä. ");
INSERT INTO mcr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ämaqä eeqänäŋi qui mimäkŋqä ipŋqä diŋqe, ämaqä hŋqunä quŋqä päkoŋqe, äŋguiqä. He iiŋqe maqŋqä eäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Iqu iiŋi, kŋuä indqäŋqä iqueqeta ätkqä hmanji. Iqu quväukuä iqueŋi hiqäva-imäkqä naqä iquau miqä äpmeqä-qae, Jisasi Iqu Israitqä iquauŋqä päkonätŋqä etaŋgqeŋqä, hiŋuä ätätä i ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Itaŋga Jisasi Iqu iquauŋqänä päkonätŋqä maetqe, Goti Hanjuwä Iqueqä ymeqä im-imä äpmakäwoŋuwi, aquvä naqä-hŋqunä maqiyätŋqeŋqä päkonätŋqä etaŋgqeŋqä, Käyäpasi iqu hiŋuä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hiunji iquesaŋi, iqua Jisasi Ique päkpŋqeŋqä hänaqäŋqä qavqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Qu i iqaŋguwiŋqä, Jisasi Iqu Israitqä iquauqä hiŋuä iqi äti mikiqä danä imiŋqe. Iqu iqiŋi äväma, aŋä avqŋqä iqueqä hituŋuä iqi aŋä-himqä hmbu, kiqä yoqe Eplaimŋqä äukqe. Iqiŋi Iqu Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israitqä Jerusälemä iu hiqäva äqämiŋuwä iquauqä hiunji naqänäŋä Pasopa ätätqäŋuwä iqu qäqi timäutŋqä ikqe. Ga Israitqä im-imä äpmakäumiŋuwä kuapänäŋi, qu suqä piyaŋä-weqä imäkmiŋuwi, jänä imäkŋqä du imäkäpu hiunji iŋgaŋqe jänä imäkmbŋqä, Jerusälemä yätuŋqä ekuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Qu Jisasi Iquenyqä hiŋuä aaŋqä äqumbiyi, hiqäva-imäkqä aŋä täkŋä yäŋgisa äpeipiyi, quwqä-quwä, “Si Iquenyqe, hiunji aquväqŋqä naqä täuŋqe, ‘ätimäuŋqiyä’ kŋuä äkiyqiyä, äänä äkiyqiyä?” ätŋgäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Iŋgaŋi, hiqäva-imäkqä naqä iquatä, Parisi iquatä, Jisasi Ique a kiqätpŋqeŋqe, “Hesaŋä hŋqu Iqu pmetaŋgqeuŋqä näqŋqä eäŋqe, awä natänä” ae ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hiunji naqänäŋä Pasopa ätätqäŋuwä iqu timäutŋqe, hea 6 änyä etaŋgi, Jisasi Iqu Betaniŋqä äukqe. Betani, Lasarusi, Jisasi Iqu qua buta aŋgumä häŋä ävauqumuatkqä iqueqä aŋä-himqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ämaqä Betani pmeqe, Jisasi Iquenyqä yeeqä ipu, ymisaŋä imäkkuwi. Malai ymisaŋä ämetä vqaŋga, Lasarusi iqu ämaqä Jisasi Iqutä pmetaŋguwitä anä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iŋgaŋi Mäliyai eqä sisnyaŋä-weqä mbqä naqä iqä häkä maŋguä iŋqä hui ämeqe, Jisasi Iqueqä yukä bu äwiquatätä, yemäŋi iiyqä detä iwimäkkqe. Sisnyaŋä iiŋi, aŋä imŋi iqunä a änduekqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","I imäkqaŋgqeŋqä, Jisasi Iqueqä wäuŋuäŋqä ämotquamiŋqä hŋqu, Jutasi Iskarioti, Jisasi Iquenyqä täkqä tuätŋqä iqu, “Eqä sisnyaŋä-weqä tä, mbqä 300 ämetä, mbqe ämaqä nätmatqä maeqeu yätamäkqäŋqä mimäkqe suŋqäwä?” ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iqu iiŋi, naqä-qakuä ämaqä nätmatqä maeqeuŋqä kŋuä äme ätkqä ma, iqu quwä-meqä-qu eä, i ätkqe. Mbqä qae iqu imanäqä-qae, iqu mbqä iuŋi hui quwä ätamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","I tqaŋgqäŋga, Jisasi Iqu ämävauqe, “Nyi qua jipqäŋgaŋqä ämeqä di, iiŋi hiŋuinä qunyä. ");
INSERT INTO mcr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ämaqä nätmatqä maeqe, hiunji eeqänäŋä iuŋi hesä pmepnä. Nyi hesä äpakänä mäpmeqä imqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iŋgaŋi Israitqä Jerusälemä iu hiqäva imäkmiŋuwä iquautaŋä kuapänä, “Jisasi Iqu Betani äpmenä” tqaŋgä äwipiyi, qu iqinyqä äukuwi. Qu iqinyqe, Jisasi Iquenyqänä mäwqä ikuwi. Lasarusi Jisasi Iqu qua buta aŋgumä häŋä ävauqumuatkqä iquenyqä hiŋuäŋqätä qäsä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lasarusi iquesa, Israitqä kuapänäŋä iqua hänaqä yäue ävämepu, Jisasi Iquenyqä quuvqä heqiyqaŋguwitaŋi, hiqäva-imäkqä naqä iqua, Lasarusi iqueŋä-pqe, qäsä päsqäŋqä kukŋuä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Awiŋgaŋi, ämaqä kuapänäŋä hiunji naqä iquenyqä aquvä äqäŋguwä iqua, “Jisasi Iqu Jerusälemäŋqä äpqiyä” tqaŋgä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","E äwipiyi, qu haapqä-quwqä ämepu, Jisasi Iqutä mimbŋqä äukuwi. “Goti Hanjuwä Iqueä yoqe haqeqä äwinä! Itaŋga Ämaqä naqä Israitqä iqune ämineyqä Iqu, Goti Hanjuwä Iqueqä yoqeta äpätqäuä. Goti Hanjuwä Iqu Iqueŋi, äŋguä iwimäkqiyä” ätäpu, awqä ätqa äumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Jisasi Iqu doŋgi änyä hipkä hŋqu ämeqe, Goti Hanjuwä Iqueqä tuwaŋuiu ätnäŋqä-pa, iqueu pmeqä äukqe. “Aŋä-himqä Sayonä pmeqä iquenä, zä miqä pambu! Hiqä ämiqä naqä iqu, doŋgi änyä hipkä iqueu pmeqä äpätqäuä” ätnäŋqä-pa äpkqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, iiŋqe kŋui, qäŋga mämeqä ikuwi. Iqua, Goti Hanjuwä Iqu Ique häŋä ävauqumuatätä, yoqä naqä vqaŋga, tuwaŋuä Iquenyqä ätnäŋqä-pa, qäyunä ätimäukqeŋqä kŋui, iŋganä ämakuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisasi Iqu, Lasarusi iqu qua witaŋga tääqä ätuätumetä häŋä vauqumuatqaŋgi äquŋguwä iqua, ämaqä huiziquauŋi, “Iqu iiŋä imäkqaŋgi äqunäŋqueqä” ätumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","“Nätmatqä ämaqä hui mimäkqänäŋi, Jisasi Iqu imäkqiyä” tqaŋgä äwipiyitaŋi, ämaqä kuapänäŋi Iqutä ämimbŋqä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iŋgaŋi Parisi iqua e äqumbiyi, “Hiŋuä qumbu! Ämaqä eeqänäŋi, Ique qänaknä äyä äwivändqäuä. Ne ‘I yaŋqunä’ ätätanä equque, matimäuqä yätŋqänä äyä iqiyä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Qu Goti Hanjuwä Ique qoŋä äwoktäupu, Iqueqä yoqä haqeu mamäupŋqä hiunji naqänäŋäŋgaŋi, ämaqä Grikä iquautaŋä hŋqua, aquvä anä qämbŋqä ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ämaqä iiŋi, qu Pilipä aŋä-himqä Betsaitä, qua Galili iu pmeqä ique äwimepu, “Naqä iquki, ne Jisasi Ique hiŋuä qunatuŋquä äneŋgiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipä iqu qätä i äwiyäqe, äwätä, Endru ique tquaŋgi, iquaqu äwiyi, Jisasi Ique ämaqä iquauqä äwiŋqeŋqä ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iŋgaŋi Jisasi Iqu kimaŋi, “Ämaqeuqä Ymeqä Ekqä Iqu yoqä naqetä, yäŋänäqŋqetä metŋqe, hiunji tä qäŋga qe ätimäuqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Nyi naqä-qakuänä etqänä. Kuä-witqä uwqä hŋqu qua bu mapäkŋqä itä mapäkoŋqä itqe, iqu kiqä-kiuänäŋqe. Iŋäqe, uwqä iqu qua bu äpäknätä äpäkoŋgqe, iquesaŋi kuapänäŋä qäyänä. ");
INSERT INTO mcr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ämaqä tqu-tqu häŋä-pmeqä iqueqe a kiqätnämitätqe, i äpäkoŋqäŋqe. Itaŋga ämaqä tqu-tqu qua täu äpme, häŋä-pmeqä iqueqe a makiqätŋqä imitätqe, iqu häŋä hea ique-ique pmeqe ämenä. ");
INSERT INTO mcr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ämaqä äsqu-äsqu wäuŋuä nyiyätŋqä äwinyäŋqä iqu, Nyi qänaki nyivändätŋqe. Iŋi Nyi pmetaŋgqeuŋi, Ŋqä wäuŋuä-nyiyqä iqu, iqi anäŋqe. Ämaqä tqu-tqu Nyaqä wäuŋuä änyiyätŋqä iqueä yoqe, Apiqu haqeu muämäuŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Täŋgaŋi Nyi Ŋqä qeqä-quuvqä tämŋi, haŋä naqänäŋä ämeqä. Iŋi Nyi Apiqueŋi, ‘Haŋä-iqä änyimeqä tquesaŋi, häŋä iŋqumuatiyä’ tmqäta, ä änäänyä tmqe? Iŋäqe, Nyi haŋä-iqä tä ämeqäqä tqu qäqu mamqä äpqäqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Iŋi Apiquki, Tqä yoqe haqä yätu mayä!” ätukqe. I tquaŋgaŋi, kukŋuä hŋqu qäukuä yätutaŋi, “Nyi Ŋqä yoqe haqä yätu ae ämaeŋgqäqe. Itaŋga Nyi aŋgumä maenmqänä” ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ämaqä häukuä qäsäŋi iqi ätqäpiyi, kukŋuä i tqaŋgi äwipiyä iquenyqe, “Mmqä käkaqä ätqiyä” tqaŋguwäŋga, hui, “Eŋätqä hŋqu kukŋuä ätquiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","I tqaŋguwäŋga, Jisasi Iqu ämävauqe, “Kukŋuä iqu yätamäkqä Nyi nyiyätŋqä matqä iqi. He heyätŋqä ätqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Qua täu äpmeŋuwiu iwäsäuqe, täŋga qe ätimäuqi. Goti Hanjuwä Iqu, Iqueqä himä-wiuŋqä vqä qua täu ämitŋqä iqueŋi, täŋgaŋi huätä qe mamäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nyiŋi, qu qua täutaŋi haqä yätqä änma peyqaŋgpqäŋgaŋi, ämaqä eeqänäŋi Nyi ämäqepmamqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kukŋuä iiŋi, Jisasi Iqu Iqueqä äpäkoŋqe, iiŋä päkonätŋqä etaŋgi, i ämotquetä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iwä, qu tii ätukuwi. “Neyaqä kukŋuä-suqä iuŋi, ‘Kraisi ne ämineyätŋqä Goti Hanjuwä Iqu ätekqä Iqu, hea ique-ique pmequeqä’ tnätaŋgi äwiyätuŋque, ‘Ämaqeuqä Ymeqä Ekqä Iqu haqä yätqä äma pepŋqäuä-qe’ änä-änäŋqä tnyä?” ätuäpu, “Ämaqeuqä Ymeqä Ekqä Iqu tqukä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisasi Iqu, “We-huŋqä Iqu hesäŋi äpakänä mäpmeqä yänä. He We-huŋqä Iqu-täŋä epiyä täŋgaŋi, heawiqä iqu mämaequtäuqä danä yätŋqe, we-huŋqä äwquwä iunä upiyä. Heawiqä imä äwätŋqä iqu, ‘äkŋgi wäŋqutiyä?’ änyä maqŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","We-huŋqä iqu-täŋä epiyä täŋgaŋi, Iqueqä ymeqä epŋqe, Iquenyqä quuvqä heqäpiyä” ätukqe. Iqu kukŋuä iiŋi qäpu ätqua äwäqe, qu Iqueŋi hiŋuä mäquŋquä ipŋqe, zä imäknä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisasi Iqu nätmatqä ämaqä hui mimäkqänäŋi, quvaqä hiŋuä iqisa qäyä imäkqaŋgi, qu Iquenyqä quuvqä maeqiyqä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hiŋuä-tqä Asayä iqu kukŋuä tii ätätä äqäkqe. “Naqä Iquki, neyaqä kukŋuä tquaŋgque, ‘naqä-qakuiqä’ kŋui tqu meqiyä? Naqä Iqu imäkqaŋgi äqunäqe, Iqueqä yäŋänäqŋqeŋqe, näqŋqä tqu meqiyä?” Ämaqe Jisasi Iquenyqä quuvqä maeqiyqä äpmamiŋuwi, Asayä iqueqä kukŋui, naqä-qakuä ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Asayä iqu kukŋuä-pqä hŋqu tii ätkqe. “Naqä Iqu, ‘Qu hiŋuä maqŋqä danä ipu, kŋuä mämeqä danä ipu, Nyi äŋguä iwimäkmqeŋqä mapqä danä ipŋqeqä’ ätätä, Iqu quvaqä hiŋui hea iwimäkätä, kŋuä indqäŋqe, qŋqaŋä äyekqeqä.” Iŋä-qae, qu quuvqä maeqiyqä ipŋqä etaŋgi, quuvqä maeqiyqe i äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asayä iqu, Jisasi Iqu yoqä naqätä, yäŋänäqŋqä-täŋä-qu etaŋgi äqunäqetaŋi, iqu Iquenyqänäŋi i ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iŋäqe, Israitqä Jerusälemä iu hiqäva-imäkqä iquauqä naqä iquautaŋi, hui-pqe Iquenyqä quuvqä eqiyäpiyä-qe, qu Parisi iquauŋqä zä ipu, awä matqä imiŋuwi. Qu ze, Parisi iqua aŋä aquväqŋqeutaŋi, aquvä qämbŋqe mapqäŋqä huätä mamäupŋqä etaŋgi, i imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Qu i imiŋuwi, quvaqä yoqä haqä yätuŋi, Goti Hanjuwä Iqu maetŋqä miqä da, ämaqe maepŋqä duŋqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisasi Iqu maŋä haqeqäta tii ätkqe. “Ämaqä Nyinyqä quuvqä heqiyqä iqu, Nyinyqänä maeqiyqä iqi. Nyi änändowatkqä Iquenyqä-pqätä qäsä eqiyqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nyi hiŋuä äŋqänäŋqä iqu, Nyinä maŋqänätqenä, Nyi änändowatkqä Iqueŋä-pqe, kekutäuku äyaqänänä. ");
INSERT INTO mcr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nyinyqä quuvqä eqiyquwi, qu eeqänäŋi heawiqä imä yqänä mäpmeqä danä ipŋqä iiŋqe, Nyi qua täu äpmeŋuwä iuŋi, we weumäkmqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nyi qua täu äpmeŋuwä iu iwäsäumqä maetqe, quŋi häŋä iqumuatmqä äpkqe. Iŋi, Nyaqä kukŋuä qätä änyiyätäqä-qe, qänaknäŋi miqä danä iqäqe, Nyi iqueŋi miwäusqä danä iqä. ");
INSERT INTO mcr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nyitä Nyaqä kukŋuitä tuwä äwiyätä mämeqä itŋqä iqueŋi, hiunji yäpakäŋgaŋi, Nyaqä kukŋuä ätätŋqä iqu, iqueŋi iwäsäutä qui imäkäniqe. ");
INSERT INTO mcr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ii tiiŋä etaŋgiyi. Nyi iiŋi, kŋuä Ŋqä duta matqä iqä. Apiqu Nyi änändowatkqä Iqu, ‘kukŋuä ii ätätnä awä tiyä’ dqaŋgi iutanji. ");
INSERT INTO mcr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iŋi Nyi näqŋqe, Iqueä kukŋui häŋä hea ique-ique pmeqä vqätäŋi. Iiŋä etaŋgi, Nyi kukŋui, Apiqu ändapqä dunä ätätqäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Israitqä iquauqä hiunji naqänäŋä Pasopa ätätqäŋuwä iqu timäutŋqäŋganji. Iŋgaŋi, Jisasi Iqu qua täu äväma, Iqueqä Kaniquenyqä yqä äyä etaŋgqeŋqä näqŋqä emiŋqe. Iqu Iqueqä ämaqä qua täu pmetaŋguwä iquauŋqe, Iqueqä qua täu pmeqe qäpu etŋqäŋgaŋä-pqe, kiiŋä yqänä äwinymiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Heaitäŋi, Jisasi Iqutä Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatä buayä bŋqä pmetaŋguwäŋgaŋi, Setänä Goti Hanjuwä Iqutä mäkä-huŋqä iqu, Jutasi iqu Jisasi Iqueŋi, ämaqä huiziquauä hipa iqiŋi, täkqä tuätŋqeŋqä kŋuä iqä äwikqe. Jutasi iqu Saimonä Iskariotitaŋä iqueä hikŋä iqueyi. ");
INSERT INTO mcr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisasi Iqu, Kaniqu nätmatqä eeqänäŋi, Iqueä hipa iqi ämitŋqä eqäqä etaŋgqeŋqe, näqŋqä emiŋqe. Ga Iqu Goti Hanjuwä Iquesa äpkqeŋqätä, Iquenyqä aŋgumä yätŋqeŋqetä, näqŋqä inä emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Iiŋä etaŋgi Iqu pämä ätqäuqe, Iqueqä qäkä quäuqä haqäqiŋiqu huätä äquväteqe, huiwä ye imäkqe ämetä, äwqä iqi guä ämäsäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Itaŋi Iqu eqä hevqä equatiquteqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauä yukä bu asŋä äwqäkäuwätä, huiwä ye imäkqetä, yeemä iwimäkqäumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","I imäkqaŋi, Saimonä Pitä ique wimeqaŋga, iqu, “Naqä Iquki, Si nyaqä yukä bu asŋä ŋqätŋqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisasi Iqu ämävauqe, “Nyi täŋga imäkqä täŋqe, si täŋgaŋi näqŋqä änä mämeqä inyä. Si näqŋqe, iŋga matŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ga Pitä iqu “Si nyaqä yukä buŋi, asŋä maŋqiyqä danä iqätŋqinyä” ätukqe. Iwä Jisasi Iqu ämävauqe, “Nyi si asŋä makqiyqä imqe, si Nyaqä ämaquki maetqenä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","I tquaŋgaŋi iqu, “Iiŋä sätäti, Naqä Iquki, yukä bunä maŋqiyqä panä. Nyuäŋä-hipa qäsäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisasi Iqu kimaŋi, “Ämaqä asŋi, qäsä ae äqäŋgqä iqu, kiyä maeqä näwinyä äŋguänäŋä eŋqä-qae, asŋä aŋgumŋi, yukä bunä qänätŋqeqä. He kiyä maeqä näwinyä äŋguänäŋuenä epiyä-qe, eeqänäŋuenä maetqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisasi Iqu ämaqä Iquenyqä täkqä tuätŋqä iquenyqe ae näqŋqä eäqetaŋi, quŋi, “He kiyä maeqä näwinyä äŋguänäŋi, eequenä maetqenä-qe,” iiŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yukä asŋi qäpu äwqäyäqe, Iqueqä qäkä quäuqä imäknätä, aŋgumä quamä äpmeqe, “Nyi tä emäkqä täŋqe, he näqŋqä ämeqäuä?” ätuätä yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yatŋqä i äväqetaŋi, “He Nyiŋi, ‘Näqŋqä-vqukiyqä’ ändäpu, ‘Naqä Ämiqukiyqä’ ändätqäŋuwi, iiŋi qäyunjqae, Nyi Iŋunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","“Nyi Naqä Ämiqä-qunä eämä, ga näqŋqä Vqä-qunä qäyä emä-qe, heyaqä yukä buŋi asŋä eqiyqä-qae, he-pqe hiqä yuki asä ii qäŋgäwqäpŋqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Nyi tä imäkqe, he Nyi imäkqä-pa imäkqäpnuwäŋqä ämetquetmä i imäkqä. ");
INSERT INTO mcr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iŋi Nyi naqä-qakuänäŋä etqä. Wäuŋuä-wiyqä hŋqu, iqueqä naqä ämiqä iqueŋi mämäwqätäutqe, itaŋga kukŋuä äma uwqä hŋqu, ‘kukŋuä äma uvä’ ätuätä dowatqä iqueŋi mämäwqätäuqä yänä. ");
INSERT INTO mcr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Täŋgaŋi, he Nyi imäkqeŋqä ae näqŋqä äŋguänä equwä-qae, he asä ii imäkpqe, yeeqä iqäpnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nyi he eequenŋqä matqä iqä. Ämaqä Nyi atäuŋuä eyätmä etmeqä iquenŋqe, näqŋqe ae eŋä. Iŋäqe, Goti Hanjuwä Iqueä tuwaŋuiu ätnäŋqe, naqä-qakuä ätimäutŋqä iŋqä imäkmä. Kukŋui, ‘Ämaqä Nyaqä buayi anä änätqäŋueä iqu, Nyi qonjqä nyätŋqä yukä äyawa äpeyqiyä’ äqänä. ");
INSERT INTO mcr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iiŋi ätimäutŋqä änyä etaŋgi, Nyi täŋga näwi etqä. Iwä ätimäuqaŋgaŋi, he Nyiŋqä näqŋqe, Nyi hea ique-ique Pmequnä äyä etaŋgqeŋqe, epŋqeyi. ");
INSERT INTO mcr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Naqä-qakuänäŋä etqä. Ämaqä tqu-tqu, ämaqä Nyi ändowatqaŋgundqä hŋque yeeqätä itmeqe, Nyi-pqä qäsä indmeqi. Itaŋga tqu-tqu Nyi indmetqe, iqu Nyi änändowatkqä Ique-pqä inä itmeqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iiŋä ätuäqetaŋi, Iqueqä qeqä-quuvqä imŋi, änä mäwimäŋqä iqaŋgi, Iqu iŋgaŋi ätnäŋäqi äti, tii ätukqe. “Nyi naqä-qakuänäŋä etqä. Hesaŋä hŋqu Nyinyqä täkqä tuäŋqiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","I tquaŋgaŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, “Iiŋi tquenyqä tqutiyä” tpu ipu, iqua quwqä-quwä hiŋuä ämiqäŋgäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","I ipiyitaŋi, iquautaŋä Jisasi Iqu iquenyqä kuapänä äwinymiŋqä iqu, Jisasi Iqutä qäqiqi äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ga Saimonä Pitä iqu, “Tquenyqä tqutiyä” tä itä, ämaqä iqueŋi, Jisasi Ique yatŋqä vätŋqä himitä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iwä iqu Jisasi Iqueŋi qäpisa, “Naqä Iquki, Si iiŋi, tqueŋqä tnyä?” ätuätä, yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yatŋqä i vqaŋga, Jisasi Iqu ämävauqe, “Ämaqä Nyi bretqä tä hevqä bu äyämetmä wimqä iqu, qäquvqä” ätukqe. Iwä Iqu bretqe hevqeu äyämeqe, Jutasi Saimonä Iskariotitaŋä iqueqä hikŋä ique äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jutasi iqu bretqe tii motauqaŋgaŋi, Goti Hanjuwä Ique himä-wiuŋqä vqä Setänä iqu, Jutasi ique äpaqukqe. Iiŋä itaŋgi, Jisasi Iqu iqueŋi, “Si nätmatqä hui imäktŋqä etaŋgutqe, maqänä imäkiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iqu kukŋuä tquaŋgi äwipiyä iqua, “Kukŋuä ii, suŋqä tqutiyä” tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mbqä qae, Jutasi iqu mitqätaŋgqä-qae, hŋqua “Ymisaŋä imäkqäŋqä nätmatqä aaŋqä etaŋgi hui mbqä yätŋqä tqutiyä, ä ämaqä nätmatqäŋqä äwa iqaŋguwä iu vätŋqä tqutiyä” tpu ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Itaŋgi, Jutasi iqu bretqe ämotauqe, yäpaqä mäŋgisa äukqe. Ii heatqäŋgayi. ");
INSERT INTO mcr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jutasi iqu ätimäwa uwqaŋgaŋi, Jisasi Iqu tii ätukqe. “Ämaqeuqä Ymeqä Ekqä Iqueä yoqä naqe, täŋga ätnäŋäqi wiŋqiyä. Ga Ymeqä Iquesaŋi, Goti Hanjuwä Iqueqä yoqä naqä-pqe, ätnäŋäqi inä wiŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Goti Hanjuwä Iqueä yoqä naqe, Ymeqä Iquesa ätnäŋäqi wiqaŋgutqe, Iqu Iqueqä-kiuä Ymeqä Iqueä yoqä naqe, ätnäŋäqi maqänä imäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ŋqä ymeqä iquenä, Nyi hesäŋi äpakä mäpmeqä imqänä. Nyi äwqaŋgaŋi, he Nyinyqä qävqä ikäpnuwi. Nyi Israitqä iquauqä naqä iquau ätukqe, täŋgaŋi he etqä. ‘Nyi umqä iuŋi, he mäwqä danä ipnuwi.’ ");
INSERT INTO mcr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Täŋgaŋi Nyi kukŋuä-suqä änyä-häŋä tiiŋä etapqä. He hŋqunä-hŋqunä hiqä-hiuäŋqä eŋqä di, aaŋä kiiŋä heŋguätŋqe. Nyi henyqä änyiŋqe, aaŋä kiiŋä änyinyätŋqä-pa, he-pqe hiqä-hiuäŋqä aaŋä kiiŋä heŋguätŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","He iiŋä iqaŋgpqe, ämaqä eeqänä qu näqŋqe iuta hepŋqäuä. He Nyaqä wäuŋuä yätquakä-quenä äyä etaŋgi heqämbŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","I tquaŋga, Saimonä Pitä iqu, “Naqä Iquki, Si äkŋgiŋqä utŋqäwä?” tquaŋga, Jisasi Iqu, “Nyi umqä iuŋi, täŋgaŋi si qänaki mapqä isŋqinyä. Si Nyiŋqä iŋga ptŋiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kimaŋi, Pitä iqu tii ätukqe. “Naqä Iquki, nyi Siŋi täŋgaŋi qänaki makivändqe, suŋqä imqäwä? Nyi Siŋqä yäŋä wämqä näwi äpmeŋänä.” ");
INSERT INTO mcr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","I tquaŋga, Jisasi Iqu, “Si naqä-qakuä Nyinyqä yäŋä wätŋqätanä? Nyi naqä-qakuä tii äktqä. Kukutakisqä äkaki, änyä ätätŋqä etaŋga, si Nyinyqe, ‘Nyi Iqueŋqe änyä maqŋqeqä,’ hŋquaqui-hŋque ttŋqinyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisasi Iqu tii-pqä inä ätukqe. “He iiŋqä äwqä haŋä heyqaŋguti, qundqändqä miqä ipu, Goti Hanjuwä Iquenyqätä, Nyinyqätä quuvqä heqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nyaqä Apiqueä aŋiuŋi, hiqŋqe, kuapänä imäknänä. Iiŋä naqä-qakuä maetaŋgutqe, Nyi heŋi, ‘Henyqä aŋä näwi imäkmqä umqe-qe,’ maetqä iqämninji. ");
INSERT INTO mcr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nyi äwätmä, henyqä aŋi näwi imäkemi, aŋgumä äpmqe, he Nyitä anä pmetuŋquä etma umniqeqä. Iwä aŋä Nyi äpmeŋqä iuŋi, he-pqe anä pmeniqueqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aŋä Nyi umqä iqäqä iuŋqe, he huäŋqeŋqe näqŋqä ae äyä ämeŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","I tquaŋga, Tomasi iqu, “Naqä Iquki, si utŋqä iuŋqe, ne änyä maqŋqä equnä. Iŋi ne huäŋqeŋqe, näqŋqe, äänä heatuŋquäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisasi Iqu kimaŋi tii ätukqe. “Nyi Ŋqä-näuä Huäŋqä-qunä, Naqä-qakuä-qunä, itaŋga Häŋä-pmeqä Iqunjqä. Apique wimeqe, huäŋqä hŋqu miŋqä inä. Oeyqä. Nyitanänji. ");
INSERT INTO mcr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","He Nyinyqä näqŋqä äŋguä eäŋuwi, ga Ŋqä Apiquenyqä-pqe näqŋqä äŋguä asä ii hipŋqäuä. He Iquenyqe näqŋqä täŋga qe eäpu, Iqueŋi hiŋuä äyä äqunäŋäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","I tquaŋga, Pilipä iqu, “Naqä Iquki, neyaqä äneŋqä qäpu hiätŋqeŋqe, Apiqueŋi mänätquayä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisasi Iqueä kimaŋi, “Pilipä iquki, Nyi hesäŋi hŋgaŋqä äpmaka äpätŋqe, Si Nyinyqä maqŋqe, äänä heŋinyä?” ätukqe. “Ämaqä Nyi hiŋuä äŋqänäŋuwi, Apique-pqe inä äqunäŋäuä. Iŋi si ‘Apique mänätquayä-qe,’ änääŋqä tnyä? ");
INSERT INTO mcr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nyi Apique nyätaŋgä, Iqu Nyi änyinyä äpmeŋqä iiŋqe, si quuvqä maeqiyqä äyä itqäŋäta? Nyi etätŋqe, Ŋqä kŋuitanä maetqä itŋqe. Oeyä. Apiqu Nyi änyinyäŋqä Iqu, Kiqä-kiuä Iqueqä wäuŋuinä äyä imäkätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","He kukŋuä täŋqe quuvqä heqäpŋqeqä. Nyi Apique nyätaŋgä, ga Apiqu Nyi änyinyänä. Nyaqä kukŋui quuvqä maeqiyqä iqaŋgpqe, he wäuŋuä Iqu Nyita imäkätŋqä iuŋqä kŋuä indqänäpu, ga iuta quuvqä heqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nyi aaŋä naqä-qakuänäŋä etqänä. Ämaqä Nyinyqä quuvqä eqiyätŋqä iqu, iqu-pqe wäuŋuä huitaŋä-huitaŋä Nyi imäkätŋqä-pa imäkquätŋqe. Wäuŋuä iqu iiŋä imäkquätŋqe, Nyi Apiquenyqä uwqaŋgqetaŋi, wäuŋuä Nyi imäkätŋqeuŋi ämäwqätäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Itaŋga nätmatqä eeqänäŋiŋqä, Nyaqä yoqeta yatŋqä iquwi, Nyi imäkmqänä. Iutaŋi Apiqu, Hikŋuesa yoqä naqä meŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","I etaŋgi, nätmatqä eeqänäŋiŋqä Nyaqä yoqeta yatŋqä nyiyqaŋgpqe, ga Nyi imäkmqänä.” ");
INSERT INTO mcr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“He Nyinyqä aaŋä kiiŋä hinyätqätaŋgutqe, ga Nyi, ‘He iiŋä-iiŋä imäkpiyä’ etmqä iuŋi, qänaknä iqäpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iwä Nyi Apique yatŋqä vqaŋgundi, Iqu heŋi Yätamäkqä Eyqä Huiziqu, hesä hea ique-ique anä äpme, yäŋänäqŋqä emäkätŋqä iiŋqä etapätŋqänänyä. ");
INSERT INTO mcr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yätamäkqä Eyqä Iiŋä Iqu, kukŋuä naqä-qakuänäŋä iutaŋä Dŋä Iquvi. Qokä-apäkä qua täutaŋi, qu Ique hiŋuä mäquŋquä ipu, Iquenyqä änä maqŋqä ipiyitaŋi, Iqueŋi mämeqä ipŋqäuä. Iŋäqe, Iqu hesä anä äpmaka äpätŋqe, qänakŋi heyaqä yäpä iŋgisa inyäniqeqä. Iutaŋi he Iquenyqe, näqŋqä äyä eäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nyi he ymeqä kanä-käna maeqä eŋqä-paŋä, änä mevquatämäuqä imqänä. Oeyä. Nyi he emamniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hea wäŋqäpu päwqaŋgaŋi, ämaqä qua iutaŋi hiŋuä maŋqäŋqä ipnuwiqä. Iŋäqe, Nyi häŋä yqänä pmetaŋgumdqetaŋi, he hiŋuä äŋqämbu, häŋä yqänä pmetpnuwi. ");
INSERT INTO mcr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hiunji iqueŋi he näqŋqä tiiŋä hipnuwi. Nyi Apiqueu nyätaŋgundi, he Nyi nyinätaŋgpi, ga Nyi he hinyätmniqe. ");
INSERT INTO mcr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Itaŋga ämaqä hŋqu, Nyi ‘He iiŋä-iiŋä imäkpiyä’ etmqä iu qänaki imitätqä iqu, Nyinyqe aaŋä kiiŋä äwinyätŋqä iquvi. Ga ämaqä Nyinyqä kuapänä äwinyäŋqä iquenyqe, Ŋqä Apiqu kuapänä äwinyäŋqiyä. Itaŋga Nyi-pqe iquenyqä kuapänä nyiŋgaŋguti, Nyi Ŋqä-näuä ique ämitquatnmqänä.” ");
INSERT INTO mcr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisasi Iqu kukŋuä iiŋä tquaŋga, Jutasi huizi Iskariotitaŋä matimäuqä ikqä iqu, Jisasi Ique yatŋqä tii äwikqe. “Naqä Iquki, änääŋäŋqäwä? Si Tqä-täuä nenyä mänetquatnätnä, ga qokä-apäkä qua iutaŋä iuŋi, mämitquatŋqä isŋqätanä?” ");
INSERT INTO mcr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iwä Jisasi Iqu kimaŋi tii ätukqe. “Ämaqä Nyiŋqä kiiŋä äwinyätŋqä iqu, Nyaqä kukŋuä iuŋi qänaknä äŋguänä iqaŋguti, Ŋqä Apiqu iqueŋqe kiiŋä winyäŋqiyä. Itaŋga Yämätqäye iquenyqä äpäta, iqutä näweqä pmetenyue. ");
INSERT INTO mcr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ämaqä tqu-tqu Nyinyqä mäwiŋqä iqä iqu, Nyaqä kukŋui qänaki miqä yäŋqiyä. He kukŋuä qätä tä äwiyquwi, ii Nyaqä manä. Ŋqä Apiqu Nyi änändowatkqä Iqueqä kukŋuiqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nätmatqä iiŋqe, Nyi hesä yqänä äpmamä, awä äyä etätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","I etaŋgi Yätamäkqä Eyqä Iqu, Dŋä Äŋguänäŋä Iqu eä, itaŋga Ŋqä yoqetaŋi, Apiqu Iqueŋi ändowatämepäniqeqä. Iqu nätmatqä eeqänäŋiŋqä ämetquetä, heqä kŋuä evauqumuatqaŋguti, kukŋuä eeqänäŋä Nyi he etmiŋqe, kŋuä heyäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nyi he äwqä haŋuä iŋqä pmeqaŋgpi evämamqä iqänä. Nyi äwqä haŋuä iŋqä äpmeŋqä-pa, he asä iiŋä iŋqä pmapŋqä etapqänä. Itaŋga Nyi äwqä haŋuä iŋqä etapqe, ii ämaqä qua iutaŋä iuqä ävätqäŋuwä itäŋi asänäŋä manä. I hitaŋgi he äwqä haŋä eyätä kŋuä kuapä indqänäpu, zä miqä pambiyä. ");
INSERT INTO mcr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Nyi he eväma äumi, aŋgi emamniqeqä’ etqaŋgä ae äyä änyiyäŋuwi. He Nyinyqä aaŋä kuapänä hiŋgaŋgutqe, Nyi Ŋqä Apiquenyqä umqä iqaŋgqeutaŋi, he äwqä yeeqä hiŋguätŋqeqä. Ii tiiŋä iutanji. Apiqu Nyi ämaŋqutäuä äyä äpmenä. ");
INSERT INTO mcr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nätmatqä iiŋi matimäuqäŋga, Nyi-ganä ae äyä etqänä. I etaŋgi qänakŋi, iqu ätimäuqaŋgaŋi, he Nyaqä kukŋuä etätŋqä iiŋqe, quuvqä heqiyqäpŋqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ga ämaqä nyuäŋä qua täu ämitŋqä iqu änyimetŋqä pätqätaŋgi, Nyi he kukŋuä kuapänä maetqä imqänä. Iqu Nyi squä nyimäkätŋqe, yäŋänäqŋqä maequeqä. ");
INSERT INTO mcr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Iŋäqe, qokä-apäkä qua iutaŋi, qu Nyi Ŋqä Apiquenyqä kiiŋä änyinäŋqeŋqä näqŋqä ipŋqe, Nyi nätmatqä eeqänäŋä Apiqu ändkqä iuŋi imäkätqäŋä. Iŋäqae, he ävaupu, ga ne eeqänäŋi äwatuŋquänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Itaŋi Iqu tii ätukqe. “Nyi Ŋqä-näuäŋi Guä-wainqä Naqä-qakuä Iqunjqä. Itaŋga Ŋqä Apiqu, wainqä wäuŋuä iu miqä Iqueqä. ");
INSERT INTO mcr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nyaqä hutäkŋä iuŋi, häukuä mäwiqä iŋqä iqua, Ŋqä Apiqu huätä ätävämäuniqe. Ŋŋ hutäkŋä eeqänäŋä häukuä äqäyäŋqä iqua, häukui aaŋä kuapänä qäyätŋqe, Apiqu quwqä-hutäkŋä quvqä iqua huätä ätävämäutä, äŋguänäŋä imäkäniqe. ");
INSERT INTO mcr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kukŋuä Nyi etapqe, heyaqä quvqe huätä emamäutä, äŋguänäŋä ae emäkqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","He Nyi nyinätaŋgpi, Nyi he hinyätmqeqä. I etaŋgi guä-wainqä hutäkŋi kiqä känäu mauqŋqä eŋqe, hutäkŋä iiŋi, häukui maqäyqä yäŋqiyä. Ga asä iinji, he Nyi manuqŋqä iŋuwi, häukui maqäyqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nyi Ŋqä-näuäŋi guä-wainqä iqunä etaŋgi, he hutäkŋä iquenjqä. Ämaqä tqu-tqu Nyi nuqänätaŋguti, Nyi ique äuqänmitmqe, iqu häukui, kuapänä qäyäŋqiyä. Iwä he Nyi änyivquatämäuquwi, nätmatqä hŋqu he änä mimäkqä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ga ämaqä hŋqu Nyi manuqŋqä iŋqä iqu, guä hutäkŋä huätä tävämäuqaŋgä yäuä äpiqä-paŋä iquvi. Iwä hutäkŋä e ätävämäpqä iquauŋi, ämepu tä bu tnämäuqaŋgpi, tä näŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","He Nyi nuqänätaŋgä, Nyaqä kukŋui he euqänäŋqe, ga he hiqä eŋqeta yatŋqä iquwi, ii i timäuŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","He Nyaqä wäuŋuä yätquakä iquenŋqä motquapŋqä diŋqe, häukuä kuapänä qäyqäpŋqe. Iwä suqä iiŋä iutaŋi, Ŋqä Apiqu yoqä naqä meŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ŋqä Apiqu Nyinyqä kuapänä äwinyätŋqä-pa, ga suqä asä iiŋiutaŋi, Nyi henyŋqä-pqe inä änyinätqänä. He Nyaqä änyiŋqeunä pmetpŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nyi Ŋqä Apiqueuä suqä ändkqä iu qänaki yasämä itmä, ga Iqueqä Nyinyqä äwiŋqä iu äpmeŋqä-pa, He Nyaqä suqeŋqä etätŋqä iu qänaknä ipu pmamitpqe, iiŋändi Nyaqä henyqä änyiŋqä iunä pmapŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yeeqä Nyi änyinätŋqä-paŋi, he-pqe inä hiŋguätŋqe. Ga yeeqä iŋqä iiŋi, inä imänämäutŋqeqä. I etaŋgi Nyi kukŋuä ae etätŋqä iuŋqä aŋgi etqänä. ");
INSERT INTO mcr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nyi suqä tiiŋi äyä etapätŋqe. Nyi henyŋqä kiiŋä änyinmiŋqä-paŋi, he hŋqunä-hŋqunäŋä iquenä, hiqä-hiuäŋqe asä inä hiŋguätŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ämaqä hŋqu käyämaqä iquauŋqä äwinymitätqä iuta äpäkoŋgqe, suqä äwiŋqä iiŋä iqu, ii suqä äwiŋqä huizi iquauŋi ämäwqätäuä. ");
INSERT INTO mcr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Itaŋga he Nyi ‘suqä i imäkqäpŋqeqä’ etätŋqä-pa ii ipqe, iiŋä dutaŋi he Nyaqä nyämaqä-quenä hiätätpnä. ");
INSERT INTO mcr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wäuŋuä imäkqä iqua nätmatqä quwqä naqä iqu imäkqaŋgutqeŋqe, maqŋqä ipnä. Iŋäqe, kukŋuä eeqänäŋä Ŋqä Apiquesa qätä äwiyqe, Nyi ae äyä etqäqe. Iiŋä iutaŋi Nyi, ‘He wäuŋuä imäkqä-quenjqä’ maetqä, ‘Ŋqä nyämaqä-quenjqä’ etqä. ");
INSERT INTO mcr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","He Nyi atäuŋuä manyqä ikuwiqä. Oeyä. Nyi he atäuŋuä eyqäqeqä. Itaŋga Nyi he wäuŋuä etapkqe, he äwäpu häukuä äpakänä witäniŋqä qäpŋqeqä. Iiŋä ipiyä iutaŋi, he Nyaqä yoqeta, Apique nätmatqä hŋqueŋqä yatŋqä vqaŋgpqe, Iqu hämä etapäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nyi kukŋuä-suqä tiiŋä ae äyä etapätqäŋä. He hŋqunä-hŋqunäŋä iquenä, hiqä-hiuäŋqä aaŋä kiiŋä heŋguätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","I ätuätäqäŋgaŋi, tii-pqe inä ätukqe. “Ämaqä qua iutaŋä iqua he himä-wiuŋqä heyqaŋgpqe, ‘Neqä Naqä Iqueŋä-pqe, himä-wiuŋqä äyä äwikuwä mändanä’ kŋuä heyquäŋqä. ");
INSERT INTO mcr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ŋŋ he ämaqä qua täutaŋä iqua eŋqä-paŋä pmeqä-säpi, ämaqä qua täutaŋi, quwqä käyämaqä iuŋqä aaŋä kuapänä äwinyätŋqä-pa, henyqä-pqe inä winyätqätäninji. Iŋäqe, he qua täutaŋuenä manä. Oee. Nyi he suqä qua täutaŋi, huätä vquatämäupŋqä diŋqe, ae atäuŋuä äyä ekqe. Iiŋä iutaŋi, qokä-apäkä qua täutaŋi, he himä-wiuŋqä eyätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nyi, ‘Wäuŋuä-wiyqä hŋqu, iqueqä ämaqä naqä iqueŋi mämäwqätäuqä yäŋqiyä’ etqeŋqe, kŋuä äŋguänä metaŋgpiyä. Iŋi ämaqä Nyi quvqä indquequwä iqua, he-pqe asä i etquapŋqäuä. Ŋŋ Nyaqä kukŋuiunä qänaknä iquwä iqua, heyaqä-pqe qänaknä ipŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iiŋä iquwä iqua, Apiqu Nyi änändowatkqä Iqueŋqä änyä maqŋqä epiyä-qae, he Nyaqä yoqe metaŋguwitaŋi, suqä ququvqä eeqänäŋi emäkqäpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iŋi Nyi äpätmä iquau kukŋuä hui mätquä-säpi, quwqä suqä quvqeŋqe, äwqä yäpä imŋi haŋä mävqä iquäninji. I etaŋgi Nyi iiŋä ae ikqä-qae, iqua, ‘Ne suqä quvqä imäkätuŋqueŋqä maqŋqä equeqä’ matqä ipnuwi. ");
INSERT INTO mcr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ga ämaqä hŋqu Nyi himä-wiuŋqä indquetŋqe, Ŋqä Apiqueŋä-pqe inä itquetqä. ");
INSERT INTO mcr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nyi iquauä awä iqiŋi, wäuŋuä yäŋänäqŋqä ämaqä hŋqu qäŋganä mimäkqä imiŋqä di, ae imäkkqe. Nyi iiŋä mimäkqä-säpi, qu quwqä suqä quvqeŋqe, äwqä yäpä imŋi haŋä mävqä iquäninji. I etaŋgi qu Nyaqä wäuŋui hiŋuä ae äqunäpu, Qämätqiye himä-wiuŋqä äyekuwi. ");
INSERT INTO mcr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Suqä ii imäkkuwi, kukŋuä hŋqu quwqä kukŋuä-suqä iu äqänäŋqe, naqä-qakuä timäutŋqä iiyi. Kukŋui tiiŋä iquvi. ‘Ämaqe, qu Nyi hiŋgi himä-wiuŋqä änyiyätqäŋäuä.’ ");
INSERT INTO mcr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Dŋä Yätamäkqä Eyqä Iqu Apiqutä äpmeŋqe, Nyi Iqueŋi henyŋqä dowatmniqe. Iqu kukŋuä naqä-qakuänäŋä iutaŋä Dŋä Iqu eä, ga Apiqutä äpmeŋqä-qae äquvepänä. Iwä äquvepätä, Nyaqä wäuŋuiŋqätä, suqeŋqätä awä ätnäŋä iqi täniqe. ");
INSERT INTO mcr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Itaŋga he-pqe kukŋuä awä inä tqäpŋqänänji. Tiiŋä duta. Nyi wäuŋuä ipäqäkqeta, he Nyitä anä äpmaka äpätuŋque, täŋga täsuwänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nyi kukŋuä iiŋi, heqä quuvqä heqiyqe ävquatämäuqäŋqä iiŋqä etqä. ");
INSERT INTO mcr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ga Israitqä Jerusälemä iu hiqäva-imäkqä iqua henyqe, quwqä aŋä aquväqŋqä iuŋqä matimäuqä ipŋqä ‘oeyqä’ etpnuwiqä. Iwä qänakndaŋi, suqä tiiŋä-pqä iqua timäuniqe. He pizqä epäsäpiyäŋgaŋi, qu kŋuä tii väniqe. ‘Ne Goti Iqueqä wäuŋui, äŋguä imäkätquŋunä.’ ");
INSERT INTO mcr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Qu Apiqueŋqätä, Nyiŋqätäŋi, änyä maqŋqä epiyä dutaŋi, suqä iiŋä ii imäkpnuwi. ");
INSERT INTO mcr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","I etaŋgi Nyi nätmatqä ii timäuniŋqeŋqe, ae etqäqe. Itaŋga qänakŋi qu suqä du emäkqaŋguwäŋgaŋi, kukŋuä Nyi tä etqäqeŋqe kŋuä eyquänä. Qäŋganäŋi Nyi hesä yqänä pmetmqä etaŋgi, nätmatqä iiŋqe maetqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ga täŋgaŋi Apiqu, Nyi änändowatkqä Iqueŋqä umqe. Iŋi, ‘Si äŋgiŋqä utŋqäwä-qe?’ hesaŋä hŋqu yatŋqä manyqä iqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kukŋuä Nyi täŋga tä etqäqeŋqe, heyaqä äwqe, haŋä kiiŋä äyä eyqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Itaŋgi naqä-qakuänäŋi, tii hetmŋqe. Nyi he evämeqe, ii yätamäkqä heyätŋqeyi. Itaŋga Nyi mäwqä iqäqe, Dŋä Yätamäkqä Eyqä Iqu mapqä yäŋqiyä. Ŋŋ Nyi äwqäqe, Iqueŋi henyqe, ändowatmä. ");
INSERT INTO mcr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Täŋgaŋi, ämaqä qua täutaŋä iqua, suqä quvqeŋqä, suqä jänänäŋiŋqä ä kukŋuä mitqeŋqä, kŋuä quvqä indqänätqäŋuwi, Dŋä Äŋguä Iqu äpäqe, quwqä kŋuä quvqä iiŋi, jänä iwimäkäniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ämaqä Nyiŋqä quuvqä maeqiyqä itqäŋuwitaŋi, Dŋä Äŋguä Iqu suqä quvqeŋqä awä täniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nyi Ŋqä Apiquenyqä umqe, ga he hiŋuä maŋqäŋqä ipnuwä hitaŋgqetaŋi, Dŋä Äŋguä Iqu suqä jänänäŋä imäkqeŋqä awä etäniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Itaŋga peŋqä qua täu ämitŋqä iquenyqe, Goti Iqu Iqueqä kukŋuä mitqeuŋi, ‘Homä iqäŋqä’ ae iwäsäukqetaŋi, Dŋä Äŋguä Iqu kukŋuä mitqeŋqä awä täniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nyi kukŋuä hävemnäqŋqä etmqä etaŋgqä-qe, kukŋuä etmqeuŋi he änä mämeqä ipnä. ");
INSERT INTO mcr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","I hitaŋgi kukŋuä naqä-qakuänäŋä iutaŋä Dŋä Iiŋä Iqu äquvepätä, kukŋuä ätätqe, Iqueqä kŋuä iutanä matqä, kukŋuä Apiquesa qätä äwiyätqä inä awä ätätä, nätmatqä qänaki timäuniŋqeŋqä-pqä inä täniqe. Iutaŋi, kukŋuä naqä-qakuä eeqänäŋä iiŋqe ämetqueniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ga Iqu Nyaqä kukŋui ämetä awä etätäqäŋgaŋi, Nyaqä yoqä naqetä, ä yäŋänäqŋqetäŋi, ätnäŋä iqi maeniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iqu kukŋuä Nyaqe ämetä etäniqeŋqä ätqäqe, ii Apiqueqä nätmatqä eeqänäŋi, Iqueqänä ma, Qämätqiyeqä etaŋgqä dutayi. ");
INSERT INTO mcr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hea quäuqä maeqä wäŋqä hmbu tii päwqaŋga, he hiŋuä maŋqäŋqä ipnuwi. Itaŋga, hea quäuqä maeqä wäŋqä hmbu tii inä päwqaŋgaŋi, hiŋuä aŋgi ŋqämbnuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","I tquaŋga, Iqueqä wäuŋuä yätquakä iquautaŋä hŋqua, quwqä-quwä tii ätŋguwi. “Iqu ne ‘Hea quäuqä maeqä wäŋqä hmbu tii päwqaŋgaŋi, hiŋuä maŋqäŋqä ipnuwiqä’ ätqeŋqätä, ä, ‘Hea quäuqä maeqä wäŋqä hmbu tii inä päwqaŋgaŋi, hiŋuä aŋgi ŋqämbnuwiqä’ ätqeŋqätä, ŋŋ ‘Iiŋä dutaŋi, Nyi Ŋqä Apiqueŋqä himqänä-qe’ inä äyä ätqe. Ga kukŋuä tquauqä qakuiŋqä tä ätquque, äki etaŋgi ätqu?” ");
INSERT INTO mcr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Itaŋga quwqä-quwä yatŋqä aŋgi inä tii iŋguwi. “Iqu, ‘Hea quäuqä maeqä wäŋqä hmbiyqä’ ätqe, nätmatqä äkiŋqä ätqäwä? Iqu ätqeŋqe, näqŋqä mämeqä äyä iqunä.” ");
INSERT INTO mcr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisasi Iqu, qu yatŋqä wipŋqä iqaŋgä äqunäqe, tii ätukqe. “He ‘Hea quäuqä maeqä wäŋqä hmbu tii päwqaŋga, hiŋuä maŋqäŋqä ipnuwiqä’ etqeŋqätä, ä ‘Hea quäuqä maeqä wäŋqä hmbu tii inä päwqaŋgaŋi, hiŋuä aŋgi ŋqämbnuwiqä’ etqeŋqätäŋi, hiqä-hiuä yatŋqe iiŋqä änyätqäŋä? ");
INSERT INTO mcr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nyi naqä-qakuänäŋä tii etqä. He kŋuä naqänäŋä äqäyäpu, huäqä-huŋqä kiiŋä metqätaŋguwäŋga, qokä-apäkä qua täuŋi yeeqä iqäpnuwiqä. Heqä äwqe haŋä eyätqä-qe, aŋgiŋi yeeqä enyäniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Itaŋga apäkä hui, iiyqä ymeqä änyque qäqi quvepqaŋgaŋi, täŋä-huŋqä meŋqiyä. Itaŋi ymeqä ae änyuäqe, täŋä-huŋqä ymeqä änyuätŋqäŋga wimetqeŋqe, kŋuä mäwiyqä, ymeqä qua täu timäuqaŋgqeŋqe, yeeqä yäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ii eŋqä-paŋä di, he täŋgaŋi, äwqä haŋä-iqä ämeqäuä. Iŋäqe aŋgiŋi, Nyi hiŋuä eqäŋgaŋgundqäŋga, heqä äwqe yeeqä kiiŋä enyäniqeqä. Heqä äwqä yeeqä iŋqä iiŋi, ämaqä hŋqu änä mämetauqä yäniqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Asä qäŋgaŋi, he Nyi yatŋqä manyqä ipnuwiqä. Nyi naqä-qakuänäŋä tii etqä. He Ŋqä Apiqueŋi nätmatqä huiŋqä, Nyaqä yoqeta yatŋqä ävquwä di etapäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Qäŋgatqä näŋgisati täŋga tiŋqe, he Nyaqä yoqetaŋi, nätmatqä huiŋqä yatŋqä miqä itqäŋuwiqä. Iŋäqe täŋgaŋi, he yatŋqä vqaŋgpu. Ga he ämepiyitaŋi, yeeqä iŋqä iqu, heqä äwqeuŋi maŋguä emnätätŋqä mapŋqänänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Iiŋä ätuätäqäŋgaŋi tii ätukqe. “Nyi kukŋuä ktqä dunä etqa äpätŋqä-qe, qänakŋi asä iiŋi, awä maetqä imniqeqä. Naqänä etqänä. Nyi Apiqueŋqe, awä ätnäŋä iqi etmniqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Hiunji iqueŋi he Apiqueŋi, Nyaqä yoqeta nätmatqäŋqä yatŋqä wipnuwiqä. Itaŋga he Nyinyqä enymiŋqä iiŋqätä, ä Nyi Goti Ique äväma äquvepkqeŋqä quuvqä eqäkuwä iiŋqätä, iutaŋi Apiqu Kiqä-kiuä henyqä äwiŋgqetaŋi, he yätamäkqä heyänä. Iŋi Iqu yätamäkqä heyätŋqe, ii Nyi Iquenyqä tääqä tqeta ma, Iqueqä äwiŋqä iutanänji. ");
INSERT INTO mcr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Qäŋganäŋi, Nyi Ŋqä Apiqutä äpmamiŋqetaŋi, ävämaŋi qua täuŋqä äquvepkqeqä. Ga täŋgaŋi, Nyi qua täu äväma, Apiqueŋqä aŋgi ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iŋgaŋi Iqueqä wäuŋuäŋqä ämotquamiŋqä iqua, Jisasi Iqueŋi tii atukuwi. “Si täŋgaŋi, kukŋuä ktqä hui mänatqä itnä, ätnäŋä iqinyä änatnyä. ");
INSERT INTO mcr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Täŋgaŋi Si nätmatqä eeqänäŋiŋqä näqŋqä eänä, ämaqä hŋqu yatŋqä makiyqäŋga, Si ganä ätätqäŋiŋqe, ne näqŋqä ae ämequnä. Iiŋä itqäŋä iutaŋi, ne Si Goti Iquesa äpŋiŋqe näqŋqä eätanä, quuvqä eqiyqunä.” ");
INSERT INTO mcr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","I tquaŋguwäŋga, Jisasi Iqu kimaŋi tii ätukqe. “He täŋgaŋi quuvqä ae eqiyqä? ");
INSERT INTO mcr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Qätä nyipiyä! Ämaqe he, heqä aŋiuŋqä im-imä zä upŋqä emäkpŋqe, hea iqu ae qe ätimäuqiyä. He täqi Ŋqä-näuänä pmamŋqä änuväma weqaŋguwäŋgaŋi, Nyi Ŋqä-näuänä mäpmeqä danä imä. Apiqu Nyitä pmetaŋgi ii pmamä. ");
INSERT INTO mcr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","He Nyinyqä quuvqä eqiyätqäŋuwitaŋi, heqä äwqe haŋuä imbu pmepŋqä diŋqe, Nyi kukŋuä tä iiŋqä etqänä. Iwä he qua tque äpmapiyäŋgaŋi, haŋä-iqä qäyä emeqaŋguti, zä miqä, pemänä tqäuqäpnä. Nyi qua tqueqä yäŋänäqŋqeuŋi, ae ämäwqätäuqe.” ");
INSERT INTO mcr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisasi Iqu kukŋuä iiŋi, ae ätuäqetaŋi, Iqu hiŋuä qäukuä haqä yätu äqunäqe, tii ätkqe. “Apiquki, Si ätkŋi, täŋga täsuänä. Yoqä naqe, Tqä Ymeqä Iqunä dapiyä. Iutaŋi Ymeqä Iqunä, asä ii ktapmqänänyä. ");
INSERT INTO mcr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Si Tqä Ymeqä Iqunŋi, ämaqä eeqänäŋä iu ämimqŋqä yäŋänäqŋqe ändapkŋä-pa, yoqä naqä-pqe, inä dapiyä. Yäŋänäqŋqä ändapkŋi, ii, Nyi qokä-apäkä Si Ŋqäŋqä ändapkŋä iquauŋi, häŋä hea ique-ique pmeqäŋqä iwimäkmqeyi. ");
INSERT INTO mcr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Itaŋga häŋä hea ique-ique pmeqe, ii tiinji. Ämaqä eeqänäŋi, häŋä-pmeqä ique ämequwi, qu ‘Si Goti Tqä-täuänänjqe’ näqŋqä hepŋqäuä. Itaŋga Jisasi Kraisi, Si änändowatkŋä iqunŋqä-pqe, näqŋqä inä epŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wäuŋuä Si ändapkŋi, qäpu ae imäkqetaŋi, Nyi qokä-apäkä qua täuŋi, Tqä yoqä naqe ae ämotqueqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Apiquki, qua tä mimäkqä ikŋäŋgatqä, Nyi Sitä yqänä äpme, yoqä naqä ämamiŋueä-pa, täŋgaŋi Nyi Sitä aŋgi pmeŋqä yoqä naqä dapiyä. ");
INSERT INTO mcr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ämaqä qua täutaŋä Tqä emiŋuwä ändapkŋä iquauŋi, Nyi Saqä yoqe, awä ae ätuätŋqeqä. Ga iqua Tqä kukŋuä iunä qänaknä itqäŋä. ");
INSERT INTO mcr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Täŋgaŋi natmatqä eeqänäŋä Si Nyi ändapkŋiŋqe, ‘Ii Sitanä äpqiyä-qe’ näqŋqä ae eqäuä. ");
INSERT INTO mcr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tqä kukŋuä Nyi awä tmqä ändapkŋi, Nyi ätquaŋgä, ga qu ae ämequwiqä. Iŋi Nyi Sita ätimäukqeŋqe, näqŋqä naqä-qakuä ämepu, itaŋga Si Nyi änändowatkŋiŋqe, qu quuvqä ae eqiyquwi. ");
INSERT INTO mcr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nyi qu yätamäkqä wisŋqeŋqä tääqä äktqänä. Nyi tääqä äktqä ii, qokä-apäkä eeqänäŋä qua täuŋiŋqä manä. Oeyä. Tqä Nyi ämimqä ae ändapkŋä iqua, ga Tqä yqänä etaŋgqeŋqä, iquauŋqänä iqänä. ");
INSERT INTO mcr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Eeqänäŋä Ŋqä eäŋuwi, qu Tqeqä. Itaŋga eeqänäŋä Tqä eäŋuwi, qu Ŋqä-pqä inänjqä. Itaŋga iiŋä iqua, Ŋqä yoqä naqe, huizi iquau ämotquetqäŋä. ");
INSERT INTO mcr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nyi täŋgaŋi qua täu äpakä mäpmeqä, Siŋqä yapmqä iqänä. Iŋäqe, qu qua täu yqänä pmapŋqäuä. Ga Apiquki, Si aaŋä ikikinyäŋi, itaŋga hŋqu Si eŋqä-paŋä asänäŋä manä, Si iquauŋi Tqä yoqä naqetaŋä yäŋänäqŋqetä miyä. Yoqä naqä iiŋi, Ye naqä-hŋqunä ämuäŋna äpmeŋueä-pa iqua-pqä pmapŋqä iiŋqä Nyi ändapkŋiqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iwä Nyi qutä äpmamäŋgaŋi, Nyi quŋi Saqä yoqä naqä ändapkŋitaŋä yäŋänäqŋqetä ämitŋqeqä. Nyi hŋqu imä ändakŋga äwetä qui imäkŋqäŋqä, yatäukuä itŋqeqä. Iŋi qutaŋi, hŋqu qui mimäkŋqä iqe. Ämaqä tä du qui imäknäniŋqä äwätŋqä iqunä, qui imäkŋgqe. Ii kukŋuä Tqä bukiu ätnäŋqe, naqä-qakuä timäutŋqeyqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Täŋgaŋi Nyi Siŋqä äyapmqä itmä iutaŋi, qua täu yqänä äpmamä tääqä tä äktqe, Ŋqä yeeqä iiŋqe, quvaqä äwqeu maŋguä munätŋqä äktqänä. ");
INSERT INTO mcr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Saqä kukŋui, Nyi ae ätquaŋgä, ga qu quuvqä eqiyätqäŋuwiqä. Itaŋga qokä-apäkä qua täutaŋi, quŋqe himä-wiuŋqe tiiŋä duta wiyätqäŋäuä. Nyi qua täutaŋänäŋä-qunä maeqä imä, ga Nyinyqä quuvqä eqiyätqäŋuwä iqua-pqe, qua täutaŋä hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nyi Si quŋi, qua tquesaŋi, yäpaqäŋgisa ätuma utŋqä yatŋqe, ii makiyqä iqä. Oeyä. Ämaqä quvqä iqä iqu, quŋi qui imäkqä diŋqä, Si ämisŋqä äkiyqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nyi Ŋqä-näuäŋi, qua täutaŋänäŋä-qunä hma eŋqä-qae, ga asä qu-pqe, qua täutaŋänäŋä-qua hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tqä kukŋui quaŋgä maeqä, aaŋä naqä-qakuänäŋä-qae, quvaqä äwqä yäpä iŋgisa mŋgaŋguti, itaŋga qu Tqä ämaqä epŋqä ikikinyäŋä iwimäkiyä. ");
INSERT INTO mcr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Si Nyiŋi ämaqä qua täu äpmeŋuwä iuŋqä änändowatkŋä-maŋä iiŋi, Nyi quŋi asä ii ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Itaŋga, qu yätamäkqä wimqe, Nyi Ŋqä-näuäŋi, Si äktapŋgä. Ga asä iiŋi, Tqä kukŋuä naqä-qakuä iutaŋi, qu-pqä Tqä ämaqä ikikinyäŋä epŋqänänji. ");
INSERT INTO mcr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ga Nyi tääqe, ämaqä tquaunä yätamäkqä wisŋqänä maktqä iqä. Oeyä. Qokä-apäki, tqua kukŋuä awä tqaŋgä qätä äwiyäpu, Nyinyqä quuvqä eqiyqaŋguwä iquauŋä-pqe, yätamäkqä wisŋqä äktqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nyi tääqä tä äktqe, qu naqä-hŋqunä ämuäŋmbu pmapŋqä iiŋqä äktqä. Tiiŋä duta, Si Apiquki Nyi nyinätaŋgnä, ga Nyi Si äkinyäŋqä-paŋä iiŋi, qu-pqe, Ye ii yemämbŋqä iiŋqä äktqä. Itaŋga qu e pmetaŋguwitaŋi, qokä-apäkä qua täutaŋi, Si Nyi änändowatkŋiŋqe, quuvqä heqäpŋqe, yätamäkqä wisŋqä äktqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Itaŋga qu naqä-hŋqunä Ye ämuäŋna äpmeŋueä-pa pmapŋqä iiŋqe, Si Nyi yoqä naqetä, yäŋänäqŋqetä ändapkŋi, Nyi qu ae ävqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nyi qu nyätaŋgmdi, ga Si Nyi nyinätaŋgti, iwä suqä iiŋä iutaŋi, qu naqä-hŋqunä aaŋä yäŋänäqŋqä ämuäŋmbu pmapŋqänänyä. Itaŋga qu e pmetaŋguwitaŋi, qokä-apäkä qua täutaŋi, näqŋqä tiiŋä hepŋqä. Si Nyi änändowatkŋiŋqetä, ä Si Nyiŋqä kuapänä äkinyäŋqä-paŋä iiŋi, Ŋqä ämaqä iiŋä iuŋqä-pqe, inä äkinyätŋqä. ");
INSERT INTO mcr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apiquki, Si qua tä mimäkqäŋgaŋi, Nyiŋqä kiŋgaŋgi, yoqä naqetä, yäŋänäqŋqetä, äyä ändapkŋiqä. Iŋi, ämaqä Si ändapkŋä iqua, qu yoqä naqetä, yäŋänäqŋqetä, hiŋuä qumbuŋqä diŋqe, Nyi äkisqi pmetaŋgundqe, qu anä pmeqäŋqä änyiŋgiyä. ");
INSERT INTO mcr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Apiqu jänänäŋä imäkqä Iquki, qokä-apäkä qua täutaŋi, Siŋqe änyä maqŋqä etaŋguwä-qe, Nyi Siŋqe näqŋqä eŋä. Itaŋga ämaqä Nyisä äpmeŋuwä iqua, Si änändowatkŋiŋqe näqŋqä ae eäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Itaŋga Nyi Saqä yoqe, qu näqŋqä epŋqä ämotquamiŋqe, ga inä motqueqämqe. Ga Tqä suqä Nyinyqä äkinyätŋqä-paŋä iiŋi, qu ämeqaŋgpi, ga Nyi-pqe qu inyätmqänänyä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisasi Iqu tääqä ae ätäqetaŋi, Iqutä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatäŋi yäpaqäŋgisa ätimäupiyi, eqä Kitronä äkipu, yätäqä näŋgisaŋqä äukuwi. Eqä yätäqä iŋgisaŋi, wäuŋuä hŋqu nyätaŋgi, Iqutä Iqueqä wäuŋuäŋqä ämotquamiŋqä iquatäŋi, wäuŋuä yäpä iŋgisa äpekuwi. ");
INSERT INTO mcr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Qu wäuŋuä iuŋi kuapänä äpmeqäsmiŋuwä iiŋqe, Jutasi, Jisasi Ique mäkä-huŋqä iquauqä hipaeu ävätŋqä iqu, wäuŋuä iqueŋqe näqŋqä emiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ga qu iqi pmetaŋguwäŋga, Jutasi iqu ämaqä hävemnäqŋqä hŋquau, ätuma äpkqe. Ämaqä iiŋä iquauta kuapänäŋi, ämaqä Romätaŋä mäkä-iqä iquayi. Huiziqua, ämayukä-imaŋqä, hiqäva-imäkqä naqä iquatä, Parisi iquatä ändowatkuwä iquayi. E äpäpiyäŋgaŋi, hiqi-tä suatä, ä nätmatqä mäkäŋqä iqetäŋi, a äqätqa äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisasi Iqu nätmatqä eeqänäŋä Ique wimetŋqeŋqe, näqŋqä ae ekqä iuŋi, Iqu qutäŋä qäqiqi äwäqe, yatŋqä tii äwikqe. “He tqueŋqä qävqä itqäŋäuä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Qu Iqueŋi kima tii atukuwi. “Ne Nasäretqätaŋä Jisasi Iqueŋqä qävqä äpqunä.” I tquaŋguwäŋga, Iqu kima tii ätukqe. “Nyi qe äpmeŋänä Iqunä. Nyi Qäqunjqä.” (Jutasi, mäkä-iqä iquauqä hipa iu ävätŋqä iqu, qutä anä ätqäumiŋuwi.) ");
INSERT INTO mcr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisasi Iqu, quŋi, “Nyi qe äpmeŋänä. Nyi Qäqunjqä” tquaŋga, qu nändi ätqepuiyi, qua ipe äqäyäpäkŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aŋgi ävawäwqaŋguwäŋga, Jisasi Iqu yatŋqä aŋgi äwikqe. “He tqueŋqä qävqä äpquwäwä?” Qu aŋgumä tii ätukuwi. “Nasäretqätaŋä Jisasi Iqueŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Itaŋga Jisasi Iqu, aŋgi kima tii ätukqe. “Nyi tä Qäqunjqe, ae etqäqeqä. He Nyiŋqä qävqäŋqä äpquwä-qae, Nyitä anä äpmeŋquä tquauŋi hiŋuinä äqunäwatpiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iqu iiŋä ätukqe, Iqueqä kukŋuä qäŋganä tii ätätä äyä ekqe. “Ämaqä Nyi ämimqä ändapkŋä tqua, qutaŋä hŋqu qui mimäkŋqä eänä-qe.” ");
INSERT INTO mcr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Qu Ique a kiqätqaŋguwäŋga, Saimonä Pitä iqu, iqueqä näpqä-hionaqe ämäkäqäyäqe, hiqäva-imäkqä iquau miqä iqueqä wäuŋuä-wiyqä, Maläkusi iqueqä qätä ämuaŋgisaŋi, huätä ätävämäkqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pitä iqu i iqaŋga, Jisasi Iqu tii ätukqe. “Tqä näpqä-hionaqe, kiqä qa mŋqeu aŋgi nyueyä. Si iiŋi suŋqä inyä? Si Nyi, Ŋqä Apiqu eqä-häkä imäŋqä ändapkqe, änmqeŋqä makiŋqä iqi?” ");
INSERT INTO mcr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iŋi ae iqaŋga, Romätaŋä mäkä-iqä iquatä, quwqä naqä ämiqä iqu anä, ä Israitqä iquauqä ämayukä-imaŋqä iquatäŋi, Jisasi Iqueŋi a äkiqätpiyi, guä äkiqiyäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Guä ae äkiqiyepiyi, Anasi iqueŋqä ganä ätuma äukuwi. Anasi iqu, Käyäpasi, quväukuä ique hiqäva-imäkqä iquau miqä iqueqä känequvi. ");
INSERT INTO mcr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Käyäpasi iqu, Israitqä iquau tii ätukqä iquvi. “Qokä-apäkä eeqänaŋä iuŋqe, ämaqä hŋqunänä päkoŋqe, äŋguiqä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Qu Anasi iqueqä aŋiuŋqä ätuma uwqaŋguwaŋga, Saimonä Pitä iqutä, Jisasi Iqu wäuŋuäŋqä ämotquamiŋqä huiziqutäŋi, quŋqä qänaki äukiyi. Huiziquenyqe, hiqäva-imäkqä iquau miqä Anasi iqu näqŋqä etaŋgqä-qae, iqu Jisasi Iquenyqä, täkŋä yäpä yäŋgisaŋä ququawä iqinyqä qänaki äpaqukqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitä iqu, täkŋä-hänaqä-täŋä qäqiqi yqänä ätqäumiŋqe. Iutaŋi, wäuŋuä yätquakä täkŋä yäpä yäŋgisa äpekqä iqu, aŋgi äpäqe, apäkä täkŋä-hänaqä miqä ii kukŋuä näqŋqä ganä ätuäqe, Pitä ique yäpä yäŋgisa ätuma äpekqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pitä iqu ae ämäwqätäuqaŋga, apäkä täkŋä-hänaqeu ämimiŋqä ii, iqueŋi tii ätukqe. “Si Ämaqä Näŋueqä wäuŋuä yätquakä iqukitanä?” Iŋgaŋi Pitä iqu tii ätukqe. “Oeyä, nyi qäqunä ma!” ");
INSERT INTO mcr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iiŋä iŋgaŋi, iiqä naqänäŋä tätqätaŋgi, ämaqä aŋiu wäuŋuä imiŋuwä iquatä, ämayukä-imaŋqä iquatäŋi, tä änyuasepu, huiwä dŋä imäkmbŋqä ktämäti äqämiŋuwi. Iŋgaŋi, Pitä iqu-pqe, huiwi diyeqä änyätä, anä ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","I itqätaŋguwäŋga asä qäŋgaŋi, hiqäva-imäkqä iquau miqä iqu, Jisasi Ique, qokä-apäkä Iqueqä kukŋuä qätä äwimiŋuwä iquauŋqätä, kukŋuä äki-äki ätumiŋqeŋqätäŋi, yatŋqä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","I tquaŋga, Jisasi Iqu, kimaŋi tii ätukqe. “Nyi qokä-apäkä iu kukŋuä ävätmäŋgaŋi, zä maeqä, ätnäŋä iqinyä ätuätŋqeqä. Iŋga-iŋga Nyi qokä-apäkä kukŋuä ävätmäŋgaŋi, aŋä aquväqŋqä im-imä ämätŋgäwäŋqä iutä, hiqäva-imäkqä aŋä Israitqä eeqänäŋä iqua aquvä äqänäqäsätqäŋuwä yäpä yäŋgisa ävätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Iiŋä eŋqä-qae, si suŋqä yatŋqä nyinyä? Nyi kukŋuä ätumiŋqe, qu qätä ae änyimiŋuwä-qae, yatŋqä qu wiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisasi Iqu i tquaŋga, ämayukä-imaŋqä iqi ätqäuqä hŋqu, Ique hipa äpäsätä, tii ätukqe. “Si hiqäva-imäkqä iquau miqä iqueŋi, kima iiŋä di ätuŋi, äänä etaŋgiwä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iŋgaŋi Jisasi Iqu kima tii ätukqe. “‘Nyi kukŋuä tä quvqä ätqiyä’ kŋuä kiyqaŋgutqe, ga si ‘e tiyä’ mandqe, waqiyäŋi ‘äkiumända ätnyä’ ändätnä, diyä. Ä kukŋuä qäyu tqaŋgundqe, ga Nyi suŋqä bäkinyä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jisasi Iqu kukŋuä iiŋi ae ätqaŋga, Anasi iqu, Iqueŋi guä yqänä qiyäuŋqu-que, hiqäva-imäkqä iquau miqä Käyäpasi iqueŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jisasi Ique iiŋä imäkätqätaŋguwäŋgaŋi, Saimonä Pitä iqu tä ttawiu ätqäuä, diyeqä imäknmiŋqe. Iqu qutä ätqäuä diyeqä nyätqätaŋga, qu iŋgaŋi tii ätukuwi. “Si Ämaqä Näŋueqä wäuŋuä yätquakä iqukitanä?” Ga iqu tii ätukqe. “Oeyä. Nyi qäqunä manä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","I tqaŋga, hiqäva-imäkqä naqä iqueqä wäuŋuä-wiyqä, ämaqä Pitä iqu qätä mŋä ätävämäukqä iqueqä käyämaqä iqu, tii ätukqe. “Nyi si Iqutä wäuŋuä du anä pmetaŋgnä äkqänäŋqe, tä qäqukiyqä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitä iqu aŋgi “Oeyä” tqaŋgqe-täŋi, kukutakisqe äkakä ätkqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Zi-hiŋuä pisqäŋgaŋi, iqua Jisasi Iqueŋi, Käyäpasi iqueqä aŋiuŋqä ätuma äukuwitaŋi, aŋgiŋi, ätuma, ämaqä Romätaŋä qua Jutiya iu ämiqä iqueqä aŋä naqä hiqŋqä-täŋä iuŋqä äukuwi. Qu, “Ne Goti Iqueä hiŋuä iqiŋi kiyä mätqä ätimäutanä, itaŋga neqä hiunji naqänäŋä Pasopa iutaŋä naŋui, maŋqä yaŋqunä” kŋuä wiyqaŋgi, ämiqä iqueqä aŋiuŋi mäpeyqä, yäpaqä mäŋi yqänä ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Qu iqi yqänä tqäutaŋguwäŋga, ämiqä Pailoti iqu quŋqä äpäqe, yatŋqä tii äwikqe. “He Ämaqä Tqueŋi, kukŋui, äkiŋqä mitpŋqäwä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Iŋgaŋi qu ämävaupiyi, iqueä kukŋui kima tii ätukuwi. “Iqu suqä quvqä hui mimäkqä-säpi, ne Iqueŋi ätuma mapqä iquaniŋgä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Iwä Pailoti iqu tii ätukqe. “He Ique ätuma, heqä kukŋuä-suqä änäänä äwiŋqä iuta mitpiyä.” I tquaŋga Israitqä iquauqä naqä iqua tii ätukuwi. “Ne ämaqä hŋque pizqä päsqäŋqe, hiqä kukŋuä-suqe pmua inemäkänä.” ");
INSERT INTO mcr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Suqä ii iwimäkkuwi, Jisasi Iqu “Iiŋä nyimäkqaŋgpi äpäkonmniqeqä” ätätä ätmiŋqä iuŋi, naqä-qakuä hiätŋqä ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","I tquaŋguwäŋga, Pailoti iqu, iqueqä aŋä iu aŋgi äpaquväqe, Jisasi Ique tääqä ätuätumetä, yatŋqä tii äwikqe. “Si Israitqä iquauqä Ämiqä Iquki, äyitanä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iwä Jisasi Iqu tii ätukqe. “Si tqä kŋuä iutanä indqänätnä ätnyä, ä ämaqä hŋqua Nyinyqä äktquwätanä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ga iqu kimaŋi, tii ätukqe. “Änääŋqä tnyä? Nyi Israitqä pmequndanä? Tqä sämaqä Israitqä iquatä, hiqä hiqäva-imäkqä naqä iquatäŋi, nyiŋqä ii äktma äpqäuä. Si squä iqaŋgnäŋgä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","I tquaŋga, Jisasi Iqu kima tii ätukqe. “Nyi ämaqä mimqä yäŋänäqŋqe, qua täuta mämeqä iqäqe. Nyi qua täuta ämeqä-säpi, Nyaqä wäuŋuä imäkqä iqua mäkä iqaŋgpi, itaŋga ämaqä hŋqu Nyi Israitqä iquauqä hipaeu manyivqä iquäninji. Iŋäqe, Nyi ämaqä mimqä yäŋänäqŋqe, qua täuta mämeqä iqäqe.” ");
INSERT INTO mcr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ga, Pailoti iqu tii ätukqe. “Ae! Si Ämiqä Naqä Iquki, äyämända?” Kimaŋi, Jisasi Iqu tii ätukqe. “Kukŋuä si ‘Ämiqukiyqä’ ätŋä iqu, ii tqä kukŋuiqä. Ŋqä nipai Nyi kukŋuä naqä-qakui awä tumqänä änmikqe. Itaŋga Nyi qua täu wäuŋuä asänä imäkmqä äquvepkqe. Qokä-apäkä, kukŋuä naqä-qakuiŋqä äwinyätŋqä iqua, qu eeqänäŋi Nyaqä kukŋui qätä änyiyätqäŋuwiyi.” ");
INSERT INTO mcr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ämiqä iqu tii ätukqe. “Kukŋuä naqä-qakui, ii squäwä?” Ii ae ätuäqetaŋi, Israitqä iquauŋqä yäpaqä mäŋgisaŋqä ätimäwa äpäwätä tii ätukqe. “Nyi suqä quvqä hui Iqu imäkkqe, mämäqumueqä iqänä. ");
INSERT INTO mcr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Iŋäqe, nyi suqä itŋqeŋqe, he näqŋqä äyä etqäŋuwiqä. Quväukuä eeqänäŋä hiunji naqä Pasopaŋgaŋi, nyi ämaqä guä kiqiyäueqä aŋiu äpmeŋuwä iquauŋi, hŋque hiŋgi qäyä wätŋqä atäuŋuä täupŋqä hiŋuinä äyä eqänätŋqeqä. I etaŋgi, Israitqä iquau Miqä Tqueŋi, nyi he etapmqä diŋqe eŋgiyä?” ");
INSERT INTO mcr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","I tquaŋga, qu aŋgi maŋä yäŋänäqŋqä ätäpu, “Iqueŋqe, hmanjqä. Si Baräpasi ique hiŋuinä qunäwatiyä” ätukuwi. Ämaqä iqu, mäkäŋqätä, quwäŋqätä iqä-quvi. ");
INSERT INTO mcr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Itaŋga iiŋä tquaŋguwäŋgaŋi, Pailoti iqu tquaŋgi, mäkä-iqä iqua, Jisasi Iqueŋi ätuma äwäpu, hiqokä äpäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Itaŋga qu ämiqä iquauqä yŋŋa nyuäŋiu ämuasmäuqä eŋqä-pa guä yäŋä-täŋi äkoqupiyi, Jisasi Iqueä nyuäŋiu ämuasmekuwi. Ga gquä ipisqä quäuqä hŋqu-pqe inä äwiputkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iŋi ipiyi, qu Iqu-täŋä qäqiqi äquvepäpu, “Israitqä iquauqä Ämiqä Iquki, hiunjiyqä!” ätuäpu, hipa äqäyäpäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Itaŋi Pailoti iqu ätimäwa äpäwäqe, Israitqä iquauŋi tii ätukqe. “Nyi Iqueŋi suqä hui imäkqe, mämäqumueqä iqä-qae, he iiŋqä näqŋqä hepŋqeŋqe, ätuma pmqänä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iŋi ätquaŋga, Jisasi Iqu yŋŋa guä yäŋä-täŋä äkoqukuwitä, ä gquä ipisqetäŋi yqänä ämuasmäuqä-qu yäpaqäŋgisa pqaŋgqäŋga, ämiqä iqu, “He hiŋuä qumbŋqe, täsuänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Iqu i tquaŋga, hiqäva-imäkqä naqä iquatä, ämayukä-imaŋqä iquatäŋi, Ique hiŋuä äqumbiyi, maŋä yäŋänäqŋqä tii ätukuwi. “Si zä-huätatä äuetnä, pizqä päkiyä! Zä-huätatä äuetnä, pizqä päkiyä!” Iŋgaŋi ämiqä iqu tii ätukqe. “Nyi Iqueŋi suqä quvqä hui mämäqumueqä iqä-qae, hiqä-hiuä itmepu, zä-huätatä äuepiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Iiŋä tquaŋga, Israitqä iquauqä naqä iqua, iqueŋi kima tii ätukuwi. “Neqä kukŋuä-suqä iuŋi tii ätnänä. Iqu, ‘Nyi Goti Iqueqä Ymeqä-qunjqä’ ätätŋqä-qae, äpäkonätŋqänänjqä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","9","Pailoti iqu qätä iiŋä äwiyäqetaŋi, aaŋä zä kuapänä wiŋgaŋgi, iqueqä aŋä yäpä iŋgisa aŋgi äpaquväqe, Jisasi Ique yatŋqä äwikqe. “Si äŋgi pmeqä-qukiyi?” I tquaŋga, Jisasi Iqu, iqueŋi kima hŋqu mätquä ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Iwä ämiqä iqu, “Äänä etaŋgiwä? Si nyaqä yatŋqe, kima mandqä iŋiuä” ätukqe. “Nyi Si hiŋuinä kqänäwatqeŋqätä, ŋŋ zä-huätati hukiyqeŋqätäŋi, yäŋänäqŋqe nyi ämeŋänä. Äyoo, Si iiŋqe änyä maqŋqä eŋinyä?” ");
INSERT INTO mcr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Itaŋi Jisasi Iqu tii ätukqe. “Goti qäukuä yätu äpmeŋqä Iqu, si yäŋänäqŋqä mäktapqä yätqe, si Nyi qua iqiŋi änä mämänuŋguatqä isinä. I etaŋgi ämaqä Nyi saqä hipaeu äktapqä iqu, iqueqä suqä quvqe, aaŋä naqänäŋä, saqä duŋi ämäwqätäunä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailoti iqu qätä iiŋä äwiyäqe, Jisasi Ique hiŋuinä qunäwatätŋqe, huäŋqä huiŋqä qävqä imiŋqe. I indqänätqätaŋga, Israitqä iqua maŋä yäŋänäqŋqä ätkuwi. “Ämaqä hŋqu kiqä-kiuä ‘Ämiqunjqä’ änyuätŋgqe, iqu Sisa iqueqä mäkä-huŋqä iqueyqä. Si ämaqä tqueŋi, hiŋuinä äqunäwatätŋqä etaŋgutqe, si Sisa iqueqä näueqä maeqä, iqueqä mäkä-huŋqä esŋqinyä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ämiqä iqu qätä iiŋä äwiyäqe, Jisasi Ique yäpaqäŋgisa ätuma äpäukqe. Itaŋga iqu ququawä qu ‘Hikä Ququawiqä’ änyuätmiŋuwä iqi ätqepäqe, kukŋuä iwäsäutŋqä zä-hawä iu qe äpmakqe. (Israitqä iquauqä aŋä-kukŋuä iuŋi, ququawä iquenyqe, ‘Gapätauä’ ätmiŋuwi.) ");
INSERT INTO mcr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hiunji iqueŋi, Pasopa iutaŋä Sämbatqäŋqä näwinyä imäkqäŋganji. Ga hiunji quemisqäŋgaŋi, Pailoti iqu Israitqä iquauŋi tii ätukqe. “Heqä Ämeyqä Iqu täsuwänä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Qu iŋgaŋi maŋä tnäŋä tii ätumiŋuwi. “Iqueŋi ätuma äwätnä, zä-huätatä oeyä.” I tquaŋguwäŋga iqu tii ätukqe. “He nyi heqä Ämeyqä Iqueŋi, zä-huätatä huemqä eŋgiyä?” Itaŋga hiqäva-imäkqä naqä iqua kima tii ätukuwi. “Neqä ämineyqä naqe hŋquququ hmanjqä. Sisa iqu kiqä-kiuänänjqä!” ");
INSERT INTO mcr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","I tquaŋguwä iutaŋi, Pailoti iqu, qu Jisasi Ique zä-huätati huepŋqänä, quwqä hipaeu äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Quwqä hipaeu vqaŋga, qu Jisasi Iqueŋi ätuma äukuwi. E ätuma äwäpiyäŋgaŋi, Iqueqä zä-huätati hunäniŋqe, Iqueqä-kiuä quamä iwäwa, aŋä-himqä iqi äväma, qua kiqä yoqe, ‘Ämaqä nyuäŋä-yäŋiqä’ änyuätmiŋuwä iuŋqä äukuwi. (Israitqä iquauqä aŋä-kukŋuä iuŋi, ‘Golketayqä’ änyuätmiŋuwi.) ");
INSERT INTO mcr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Iqi ätimäupiyi, Jisasi Iqueŋi zä-huätatä äuekuwi. Iqu zä-huätati awä iqi hunätaŋgi, ämaqä hŋquaqui-pqe, iŋgi-iŋgisa äuekuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Itaŋga Pailoti iqu tqaŋgi, qu kukŋuä hŋqu äqiyäpu, Jisasi Iqu unätaŋgqä ique äqiyämasekuwi. Kukŋuä iiŋä iqu, tii ätäpinji. ‘Jisasi Nasäretqätaŋä, Israitqä iquauqä Ämiqä Iqueyqä.’ ");
INSERT INTO mcr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kukŋuä iqueŋi, Israitqä kuapänäŋä iqua a ätäuqäsmiŋuwi. Ii tiiŋä etaŋgiyi. Iqueŋi zä-huätatiŋi, quwqä aŋä-himqä ique qäqiqi äuekuwi. Itaŋga kukŋuä iiŋi, Israitqä iquauqä aŋä-kukŋuä itä, Romä iquauqä itä, itaŋga Grikä iquauqä itäŋi, hŋquaqu-hŋque äqäkuwi. Qakuä iquaquisaŋi, Israitqä kuapänäŋä iqua a ätäuqäsmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Itaŋi Israitqä iquautaŋä hiqäva-imäkqä naqä iqua, Pailoti iqueŋi tii ätukuwi. “Si ‘Israitqä iquauqä Ämiqä Iqueyqä’ maqiyqä panä. Häe! Si tuwaŋui, ‘Ämaqä Tqu, “Nyi Israitqä iquauqä naqä Ämiqä Iqunjqä” ätätŋqeqä’ ätätnä äqiyeyä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","I tquaŋguwäŋga, ämiqä iqu “Qäyä enä” ätukqe. “Tuwaŋuä nyi äqiyqä tänä, qäyä äqänänä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ämaqä mäkä-iqä iqua, Jisasi Iqueŋi zä-huätati ae äuepiyi, Iqueqä ämuasmäŋqe ämapiyi, kikiŋä mapŋqä, hŋquaqui-hŋquaqui iwäsäupu, hŋqunä-hŋqunä ämakäukuwi. I ipiyäŋgaŋi, Iqueqä gquä quäuqä, nyuäŋä yätuta yukä buŋqänä ipŋŋqä iqu-pqe inä ämakuwi. Ämaqä gquä iiŋi ique guä äktäpäkqä iqu, yuä hui ämetä guä maktäpiqä, yuä iquesanänä imäkkqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Iiŋä äqumbiyi, mäkä-iqä iqua, tii ätŋguwi. “Ne gquä tqueŋi, mapisqä ianä. Qäyä enä. Ne tqueŋi, nesaŋä hŋqunä metŋqänä, häŋä iatuŋqueqä.” E ätmbiyi, iiŋä ikuwi, Goti Iqueqä bukiu ätnäŋqeuŋi naqä-qakuä timäutŋqä imäkkuwi. Kukŋuä iiŋi iqu tii ätnä. “Qu nyaqä ämuasmäŋqe hŋqunä-hŋqunä yaŋä änyäpu, ämapiyi, itaŋga nyaqä gquä quäuqe metŋqe, häŋä ipu imeqäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mäkä-iqä iqua i itqätaŋguwäŋga, Jisasi Iqueqä känäu, känäwqä känapi, ä Kelopasi iqueqä apäkä, Mäliya, itaŋga Mäliya, aŋä Maktälataŋä ii-pqe, qu eeqä Jisasi Iqu zä-huätati hunätaŋgqä qäqiqi ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iqi tqäutaŋguwäŋga, Jisasi Iqu Kiqä känatä, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquautaŋä, aaŋä kuapänä äwinymiŋqä iqutäŋi, qäqiqi tqäutaŋginyä äquŋgqe. Itaŋi Iqu Kiqä känäuŋi tii ätukqe. “Apäkä iiki, ämaqä iqu, tqä ymeqä iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I ätuäqe, aŋgiŋi, Iqueqä wäuŋuäŋqä ämotquamiŋqä iqueŋi ätukqe. “Apäkä ii, tqä tnaiyqä.” I tquaŋga, ämaqä iqu iiŋi, iqueqä aŋiuŋqä ätuma äwätä, äŋguänä ämimiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Itaŋi Jisasi Iqu näqŋqä tii ekqe. “Ŋqä wäuŋuä eeqänä imäkätŋqe, ae qäpu eqiyä.” I indqänäqe, tii ätkqe. “Ŋqä quväki, yäkäŋä nyiyqiyä.” Iqu i ätkqe, ii Goti Iqueqä bukiu ätnä äwiŋqä iqueŋi, naqä-qakuä ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jisasi Iqu “Quväki yäkäŋä änyiyqiyä” tqaŋga, mäkä-iqä iqua, qondä-häkä hŋqu wainqä-eqä mäkä iqe, maŋguä iŋqä tqäutaŋgi, ga yaaŋui ämepu, wainqä-eqä bu äyämepu, iwä yaaŋui eeqänänä piiyqä äyä iqaŋga, hisopqä äpa iu äkoqupiyi, Jisasi Iqu kiqä eqe, hiiqä ätänätŋqä maŋä iu äwisäukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisasi Iqu wainqä-eqä ae änäqe, “Täŋgaŋi ae qäpu eqiyä” ätäqe, nyuäŋi ikuopäqe, Iqueqä quuvqe qe äwquatämäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jisasi Iqu i äpäkoŋgqä iŋgaŋi, hiunji Sämbatqä hapä pmeqä iqueŋqä nätmatqä näwinyä imäkqä iŋganji. Sämbatqä iiŋä iqu, hiunji naqänäŋäŋga etaŋgi, Israitqä iquautaŋä naqä iqua huiwä iquauŋi, zä-huätatiuŋi yqänä uŋqeŋqe mäwiŋqä ikqe. Itaŋi, qu Pailoti iqueŋi, “Quwqä yuki äquasqiyä. Ga maqänä päkoŋgaŋgpi, quwqä huiwi huätä manätŋqänänyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","I tquaŋguwäŋga, mäkä-iqä iqua äupiyi, ämaqä Jisasi Iqutä anä äuekuwä iquaquiyqä yuki äquasqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Itaŋi Jisasi Iqueui äquasqiyanä-tpu indqäŋga äpäukuwi, Iqu ae äpäkoŋgqä äqunäpu, Iqueqä yuki mäquasqiyqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Qu iiŋi qäyä ipu, qutaŋä hŋqu Jisasi Iqueä mäwqä hŋgisa zi äuqaŋga, maqänäŋi häŋeqetä, eqetäŋi, naqä-huinyä äkapkqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ämaqä tä hiŋuä äquŋgquä iqu, nätmatqä timäuqaŋgi äquŋgqeŋqe, ae awä ätqiyä. Itaŋga kukŋuä iqu awä ätqäqä ii, quaŋgä manä, naqä-qakuänäŋi. Ga iqu kiqä-kiuä-pqe, ‘Nyi näqŋqe, kukŋuä ätqäqä tä, ii naqä-qakuänäŋi ätqänä,’ ätkqe. Iiŋiŋqe he quuvqä heqiyqäpŋqe.) ");
INSERT INTO mcr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nätmatqä ätimäukqä ii, Goti Hanjuwä Iqueqä bukiu ätnä äwiŋqeuŋi, naqä-qakuä imäkätŋqä ätimäukqe. Itaŋga kukŋuä iiŋi tiinji. “Iqueqä yäŋi hui mamisqiyqä ikuwi.” ");
INSERT INTO mcr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Itaŋga kukŋuä Goti Iqueä bukiu huizi ätnä äwiŋqä iqu, tiinjqä. “Ämaqe, qu zi äukuwä iunä qumbuŋqäuä.” ");
INSERT INTO mcr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Qu iiŋi ae iqaŋguwäŋga, Josepä Arämatiyataŋä iqu, “Jisasi Iqueqä huiwi ämamqeqä” ätätä, Pailoti iquenyqä äukqe. Josepä iqu, Jisasi Iquenyqä quuvqä eqämiŋqä-qe, Israitqä Jerusälemä iu hiqäva imäkmiŋuwä iquautaŋä naqä iquauŋqä zä wiŋgaŋgi, iqueqä quuvqä heqiyqe, zä emiŋqe. Iqu iqueŋi i tquaŋga, Pailoti iqu “Ŋŋqä, si Jisasi Iqueqä huiwi yqä mayä” tquaŋga, Josepä iqu äwäqe, Iqueä huiwi ämakqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Itaŋga Nekitimäsi, ämaqä qäŋganä heatqäŋga äpätä, Jisasi Ique hiŋuä äqunätä, kukŋuä anä ätkiyä iqu-pqe, inä äpkqe. Iqu zä hŋquaquisaŋä aowä imäkäpu yuqui-yaqui ikuwä, jinaŋä äŋguänäŋä weqe äma äpkqe. Zä eqä aowä iiŋi, kiqä haŋä-iqe, aaŋä naqänäŋä, 30 kilokremqä. ");
INSERT INTO mcr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jisasi Iqueä huiwiuŋi, Josepä iqutä, Nekitimäsi iqutä, ämesiyäŋgaŋi, iquaqu Israitqä iqua ämaqä pizqä iu imäkmiŋuwä-pa, zä eqä aowä yuqui-yaqui imäkkuwi, Iqueä huiwiu eä isinyä, itaŋga, yuä äŋguänäŋä hui äpisäsinyä, huäqä äutkiyi. ");
INSERT INTO mcr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisasi Ique zä-huätati äuekuwä-täŋä qäqiqiŋi, wäuŋuä hŋqu änyimiŋqe. Wäuŋuä iqueŋi, hikä hovqä änyä-häŋä, ämaqä pizqä pŋqä maeqä imiŋuwä hŋqu omiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hikä hovqä iqu qäqiqi vätaŋgqetaŋi, iquaqu Jisasi Iqueä huiwi maqänä äma äwiyi, iqi pŋqä ekiyi. Maqänäŋi tiiŋä iutayi. Hiunji qäqueŋi, Israitqä iquauqä Sämbatqä hapä pmeqä iqueŋqä nätmatqä näwinyä imäkqäŋgayi. ");
INSERT INTO mcr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wikä iqueqä hiunji kiŋganäŋä iqueŋi, Mäliya Maktälataŋä ii zä we mauŋqä, hea yqänä witaŋgqeuŋi, Jisasi Ique pŋqä ekuwä iuŋqä äpkqe. Ii äpäqe, hikä qŋqaŋä pmäukui mäpmäwänätaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iiŋä äqunäqe, ii Saimonä Pitä iqueŋqätä, Jisasi Iqueqä wäuŋuä yätquakä huizi, Iqu iqueŋqä kiiŋä äwinymiŋqä iqueŋqätä tnäŋä äwäqe, iquaquiŋi tii ätukqe. “Qu Naqä Iqueqä huiwi, hikä hovqä duta ämepu, äkisqi-mända ämaequwätiyä? Ne änyä maqŋqä equnä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mäliyai i tquaŋga, Pitä iqutä, wäuŋuä yätquakä huiziqutäŋi, iquaqu iqiŋi äväma, hikä hovqä duŋqä äukiyi. ");
INSERT INTO mcr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Qäquaqu tnäŋä qäqasä-qäqasä äwiyi, Pitä iqueŋi, huiziqu ämäwqätäuäqe, Jisasi Ique pŋqä ekuwä duŋi, iqu ganä ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iqu hikä hovqä yämä hämä mäyqä, yäpaqä mäŋisanä nyuäŋä quapi eäqe, hiŋuä äqunaeŋgqe, yuä huiwiu huäqä äutkiyä iunä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Iqu i itqätaŋga, Saimonä Pitä iqu qänaki äpäqe, hikä hovqä yämä hämänä äpaquväqe, yuinä iqi witaŋgä äqunäqä-qe, mä Jisasi Iqueä nyuäŋiu huäqä äutäsinyä ekiyä iqu, huizi iquatäŋi mäwitaŋgi äquŋgqe. Yuä iqu huizi iquatä mäwiqä, kiqä-kiui aaŋqä näŋi äkmäknäqäŋga äwämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iŋgaŋi, wäuŋuä yätquakä kiŋganä ätimäukqä iqu, qänaki äpaquväqe, yuinä iqi witaŋgi äqunäqe, quuvqä eqäkqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Goti Hanjuwä Iqueä bukiuŋi qäyä ätnä äwitaŋgi, qu iŋgaŋi, Jisasi Iqu äpäkonätqeta aŋgumä vauqeŋqe, näqŋqä mämeqä ikuwi.) ");
INSERT INTO mcr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ii äqunyiyi, wäuŋuä yätquakä iquaqu qeqä äpmanyä äquvepkiyiuŋqä aŋgumä äukiyi. ");
INSERT INTO mcr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Wäuŋuä yätquakä iquaqu i itqätaŋgiyäŋga, Mäliya Maktälataŋä ii, Jisasi Ique qua äptekiyä yäpaqä iqi ätqäuä kŋuä äqämiŋqe. Ii kŋuäqäqä nyuäŋä quapi eäqe, hiŋuä äqunaeŋgqe, eŋätqä ämuasmäŋqä qäpaiqä-täŋä hŋquaqu, hŋqu Jisasi Iqueä nyuäŋä emiŋqä iŋgi pmetaŋga, ä hŋquququ yukä ipmiŋqä iŋgi pmetaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Iquaqu Mäliyaŋi yatŋqe, “Apäkä, si suŋqä kŋuä qäyätqäŋinyä?” ätukiyi. Ii iquaquiŋi tii ätukqe. “‘Qu ŋqä Naqä Iqueqä huiwi ämepu, äkŋgi ämaequwätiyä’ tmä, änyä maqŋqä emä, kŋuä äqäyätqäŋänä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ii iquaqui i ätuäqe, hŋgisa äkunmäuqe, Jisasi Iqu tqäutaŋgi äquŋgquä-qe, ‘tä Jisasi Iqueyqe’, näqŋqä maeqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ii kŋuä yqänä qäyätqätaŋga, Jisasi Iqu yatŋqä äwikqe. “Apäkä, si suŋqä kŋuä qäyätqäŋinyä? Ä si tqueŋqä qävqä imätŋgä?” Mäliyai, ‘Tqu ämaqä wäuŋuä täu ämitŋqä iqu ändqiyä’ kŋuä wiyqaŋga, tii ätukqe. “Naqä Iquki, Si Iqueä huiwi ämetnä, hŋqäqi eŋä hitaŋgutqe, mändquayä. Ga nyi ämamqänänyä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Itaŋi Jisasi Iqu, “Mäliyauä” ätukqe. Ga ii hiqumuaŋä äwiyäqe, Israitqä iquauä aŋä-kukŋuiu, “Laponai” ätukqe. Yoqä Laponai, kiqä qakui tiinji, “Näqŋqä-vqä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iŋgaŋi Jisasi Iqu tii ätukqe. “Ŋqä Apiquenyqe mäyqä änänjqae, si mindmaqŋqä panä. Si äwätnä, Ŋqä guäkauŋi tii tuvä. ‘Iqu Iqueqä Kaniquenyqätä, heqä Heniqueŋqätä, ä asä Iqueqä Goti Iqueŋqätä, ä heqä Goti Iquenyqätä, yäŋqiyä.’” ");
INSERT INTO mcr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","I tquaŋga, Mäliya Maktälataŋä ii äwäqe, Iqueqä wäuŋuäŋqä ämotquamiŋqä iquauŋi tii ätukqe. “Nyi Naqä Iqueŋi hiŋuä ae äqunäŋänä.” Itaŋga ii kukŋuä Jisasi Iqu ätukqe, awä äsuikqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wikä iqueqä hiunji kiŋganäŋä qäque, heatqeuŋi, Iqueqä wäuŋuä yätquakä iqua, Israitqä Jerusälemä iu hiqäva imäkmiŋuwä iquauqä naqä iquauŋqä zä ipu, quwqä aŋä äpmamiŋuwä iuŋi, aŋä qŋqaŋi ämatäkutepiyäŋga äpmamiŋuwi. Iqua i pmetaŋguwäŋga, Jisasi Iqu quvaqä awä iqi maqänä ätimäuqe, pämä ätqäuä, “Heqä äwqe, haŋuä enyänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iqu e ätuätä, Iqueqä hipa yuŋguitä, ä mäwqä yuŋguitä ämotquakqe. Itaŋga, wäuŋuä yätquakä iqua, quwqä Naqä Ique hiŋuä äqumbiyi, yeeqä naqänäŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Itaŋi Jisasi Iqu aŋgi tii ätukqe. “Heqä äwqe, haŋuä enyänä. Apiqu Nyi änändowatkqä-pa, asä iiŋi, Nyi he endowatqänä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iqu e ätäqetaŋi, Iqueqä mandŋi iquau äwqatämäutä, “He Goti Iqueqä Dŋä Äŋguänäŋi mapiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“He ämaqä hŋquauqä suqä quvqe äwivquatämäuquwi, ga iquauqä suqä quvqe qäpu eqi. Itaŋga he hŋquauqä suqä quvqe huätä mämuämäuqä iquwi, quwqä suqä quvqe, yqänä winiqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisasi Iqu wäuŋuä yätquakä iquau äwimakqä iŋgaŋi, Iqueqä ämaqä 12 iquautaŋä Tomasi, iqueqä yoqä huizi, ‘Qäyawiqueqä’ ätumiŋuwä iqu, qutäŋi anä mäpmeqä da imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Iiŋqe, huizi iqua Tomasi iqueŋi, “Ne Naqä Iqueŋi hiŋuä ae äqunäŋqueqä” tquaŋguwä-qe, iqu quŋi tii ätukqe. “Naqä-qakuä tii tmqeqä. Nyi Iqueqä hipa yuŋgui hiŋuä äqunätmä, itaŋga ŋqä huiqetä wätaŋqä yuŋguiu a ämitmä, ä ŋqä hipaetä mäwqä iŋgisa zi äukuwä yuŋguä-pqe a ämiqäqe, nyi quuvqe iŋga heqämqänä. Nyi iiŋä miqä imqe, quuvqä maeqiyqä danä imqänä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wikä hŋqu ae äpäwqaŋga, Iqueqä ämaqä iqua aŋä asä ique, Tomasi iqutä anä äpmamiŋuwi. Qu aŋä qŋqaŋiuŋi ae ämatäkutekuwä imŋi, Jisasi Iqu quvaqä awä iqi maqänä ätimäuqe, pämä ätqäuä, “Heqä äwqe haŋuä enyänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","I ätuätäqäŋgaŋi, Tomasi iqueŋä-pqe tii ätukqe. “Tqä huiqe, Nyaqä hipa täu ätutuväutnä, a ämitnä, hiŋuä qunyä. Itaŋga, tqä hipae, Nyaqä mäwqä täuŋi änunjutäutnä, kŋuä hŋquaqu-hŋquaqu mämeqä itnä, quuvqenä heqiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Iqu i tquaŋga, Tomasi iqu tii ätukqe. “Si ŋqä Naqä eänyä, ŋqä Goti Iqukiyqä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ga Jisasi Iqu ämävauqe tii ätukqe. “Si Nyi hiŋuä ae äŋqänätnä, quuvqä eqinyä? Ämaqä Nyi hiŋuä maŋqäŋqä ipu quuvqenä eqämipqä iqua, qu yeeqä iqäpŋqä.” ");
INSERT INTO mcr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisasi Iqu nätmatqä ämaqä mimäkqänäŋä di, Iqueqä wäuŋuä yätquakä iquauä hiŋuä iqi kuapänä imäkmiŋqe. Iiŋä imäkmiŋqeŋqe, bukä tqueŋi eeqänä ätätmä, maqiyqä iqe. ");
INSERT INTO mcr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ŋŋ, nyi kukŋuä tä äqiyqe, he Jisasi Iqueŋqe, quuvqä tii heqäpŋqe. Iqu Kraisi ne ämineyätŋqä Goti Iqu Ique atäuŋuä ätekqä Iqu eä, Goti Hanjuwä Iqueqä Ymeqä Iqueyqä. Itaŋga he quuvqä e eqiyäpu, Iqueqä yoqetaŋi, häŋä-pmeqä mapnuwäŋqä iiŋqä äqiyqä. ");
INSERT INTO mcr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Qänakŋi Jisasi Iqu, Iqueqä wäuŋuä yätquakä iquau eqä-huäŋä Taipiriyasi maŋä iqi aŋgumä äwimakqe. Iŋgaŋi Iqu tii imäkätä, Kiqä-kiuä iquau ämitquatŋgqe. ");
INSERT INTO mcr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimonä Pitä ique, Tomasi, iqueqä yoqä huizi, ‘Qäyawiqueqä’ ätumiŋuwä ique, ä Nataniyoli, aŋä-himqä Kana, qua Galili iutaŋä ique, ä Sepri iqueqä hikŋä iŋgueqi, ŋŋ wäuŋuä yätquakä huiziquaqui, eqä-huäŋä maŋä iqi anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Itaŋi, Saimonä Pitä iqu, quŋi tii ätukqe. “Nyi hämapäkäŋqä imqä umqänä.” Ga huizi iqua, “Ne-pqe anä watuŋqueqä” ätukuwi. I ätmbiyi, yimba hŋqueŋqä äupiyi, ikuapmäupu äukuwi. Heatqä qäqueŋi, qu hämapäkä tutqä qäpu hmbu mapiqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Zä vqaŋga, Jisasi Iqu eqä-huäŋä weä näŋi tqäutaŋgaŋi, wäuŋuä yätquakä iqua Ique hiŋuä äqunäpiyä-qe, ‘Di, Jisasi Iqu ätqäunä-qe,’ näqŋqä mämeqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisasi Iqu ätqäuqä näŋisa quŋi yatŋqä tii äwikqe. “Ŋqä nyämaqä iquenä, he hämapäkä hui äpiquwätanä?” Ga qu “Aaŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iwä Iqu aŋgiŋi tii ätukqe. “He heqä hämapäkä-piqä qae, yimba iqueqä ämuaŋgisa tnämäupqe, hämapäki kuapänä päpŋqäuä.” Iŋi, qu Iqu tquaŋgqä-pa ätnämäukuwi, hämapäkä aaŋä hävemnäqŋqä qaeu mŋgaŋgä, qu qa mŋqe eyqiyäpu yimba yätu maenätpiyi, hämeqä ämikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iiŋä äqunäqe, wäuŋuä yätquakä Jisasi Iqu, iqueŋqä kiiŋä äwinymiŋqä iqu, Saimonä Pitä iqueŋi tii ätukqe. “Di, Naqä Iqueyqä.” Iŋgaŋi, Pitä iqu qätä i äwiyäqe, iqueqä gquä naqä hämapäkäŋqä itŋqä äquvätekqe, ämipnätä, eqä-huäŋä bu ikuapmäuqe, äŋgua Ique wimetŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Itaŋga wäuŋuä yätquakä huizi iqua yimba iu äpmapu, hämapäkä qae eyqiyäma äpkuwi. Eqä weä näŋisati quwqä imiŋuwä täqiŋqe, kiŋä haqiqi ma, 100 mitäyi. ");
INSERT INTO mcr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Qu iqi ae euqämapiyi, tä hŋqu sätaŋgi, hämapäkä hui tä iqi tätaŋgi äqumbiyi, bretqä-pqe aaŋqäqi witaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Itaŋi Jisasi Iqu tii ätukqe. “He hämapäkä täŋga äpiquwi, hui ämappiyä.” ");
INSERT INTO mcr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","I tquaŋga, Saimonä Pitä iqu yimbaeu ikuapmäuqe, hämapäkä qa mŋqe eyqiyäma hikä weä iqiŋqä äpekqe. Hämapäkä naqänäŋä ämnmiŋuwä iqua, kuapänäŋä 153 ämnmiŋuwä-qe, qa mŋqe mändakmäuqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iŋgaŋi Jisasi Iqu, quŋi tii ätukqe. “He ymisaŋä bŋqä ppiyä.” I tquaŋga, wäuŋuä yätquakä iqua ‘Tä Naqä Iqueqe’ näqŋqä ae epiyä-qe, qundqändqä ipu “Si tqukikä-qe?” yatŋqä vanä-tpu ipiyä-qe, pemä miqä ipu, yatŋqä mävqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iŋi, Iqu ävauqe, bretqetä, hämapäkä huisä ämetä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iqu iiŋä ikqe, ae äpäkonätä, aŋgi ävautä, Kiqä-kiuä iquau hŋquaqu ae ämitquatŋgqetaŋi, ii huizi iqueyi. ");
INSERT INTO mcr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iqua ymisaŋä ae ämbiyitaŋi, Jisasi Iqu Saimonä Pitä iqueŋi yatŋqä tii äwikqe. “Jonä iqueqä ymeqä, Saimonä iquki, tqä Nyiŋqä äkiŋqä di, huizi iquauqeuŋi ämäwqätäuŋinyä?” Ga Pitä iqu ämävauqe ätukqe. “Auäqä, Naqä Iquki, ŋqä Siŋqä änyinätŋqe, näqŋqä äyä eŋinyä.” I tquaŋga, Jisasi Iqu tii ätukqe. “Si Ŋqä sipsipqä meqeuŋi, ymisaŋä äŋguä bŋqä miqätŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aŋgumŋi, iqueŋi yatŋqä tii äwikqe. “Jonä iqueqä ymeqä Saimonä iquki, si Nyiŋqe kiiŋä äkinyätqänä?” Ga iqu, “Ŋŋqä, Naqä Iquki, ŋqä änyiŋqä Siŋqä änyinätŋqe, näqŋqä ae eŋinyä” tquaŋga, Jisasi Iqu kima tii ätukqe. “Si Ŋqä sipsipqe, äŋguänä miqätŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Itaŋi, yatŋqä huiziqu tii äwikqe. “Jonä iqueqä ymeqä, Saimonä iquki, si Nyiŋqe äkinyätqänä?” Iqu, “Si Nyiŋqä äkinyätqänä-qe?” hŋquaqu-hŋque vqaŋgqeŋqä, Pitä iqu äwqä haŋä ämeqe, tii ätukqe. “Naqä Iquki, Si nätmatqä eeqänäŋiŋqe näqŋqä eŋinyä. Iŋä-qae, ŋqä Siŋqä änyinätŋqeŋqe, näqŋqä ae äyä eŋinyä.” I tquaŋga, Jisasi Iqu iqueŋi tii ätukqe. “Si Ŋqä sipsipqe, ymisaŋä äŋguä bŋqä miqätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nyi kukŋuä naqä-qakuänäŋi, tii ktmqe. Si hikŋä yqänä äpmanäŋgaŋi, tqä qäkä kitokutäuqe, ätokutäunätnä, itaŋga aŋä äkiuŋqe tqä äkiŋqä iutanä imäknätnä äyä äumiŋi. Iwä si qoyaŋä etnäŋgaŋi, tqä hipae haqä etnä, itaŋga ämaqä hŋqu guä äkikiqiyäutä, aŋä si mäwqä imätnä imitätqä iuŋqä äktma wäniqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisasi Iqu kukŋuä i ätukqä ii, Pitä iqu äpäkonätä, Goti Ique yoqä naqä väniŋqä iiŋqe, qu suqä äki-äkitaŋi motquapnuwä diŋqä kŋuä äme ätukqe.) I ätuäqetaŋi, Iqu Pitä iqueŋi, “Si qänaki nyivändqätŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Iŋgaŋi Pitä iqu tuwäŋgi hiŋuä ämäquŋgqe, wäuŋuä yätquakä Jisasi Iqu iquenyqä kiiŋä äwinymiŋqä iqu, iquaquiŋqä qänaki äquvepqaŋgi äquŋgqe. (Ämaqä iqu, qu buayä änäpiyäŋga iqueqä nyuäŋi Jisasi Iqueqä quikuä-täŋä qäqi eä, Ique yatŋqä tii äwikqä iquvi. “Naqä Iquki, mäkä-iqä iquauqä hipa iuŋi, ämaqä äkisqu kiväniqäwä?”) ");
INSERT INTO mcr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitä iqu ique hiŋuä äqunäqetaŋi, Jisasi Ique yatŋqä äwikqe. “Naqä Iquki, ämaqä näŋueŋqe, änääŋqäwä?” ");
INSERT INTO mcr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Itaŋi Jisasi Iqu, iqueŋi kima tii ätukqe. “Nyi iqu aŋgi äquvepmqäŋgaŋqä qäyä pmetŋqä nyiŋgaŋgutqe, ii nätmatqä tqätanä? Si qänaki dinä nyivändqätŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iiŋä etaŋgi, wäuŋuä yätquakä iquenyqe, kukŋui im-imä tii äwekqe. “Jisasi Iqueqä wäuŋuä yätquakä iqu mapäkoŋqä yäniqeqä.” I etaŋgqä-qe, Jisasi Iqu, iqueŋqe, “Mapäkoŋqä yäniqeqä” ätätä, matqä ikqe. Ii ma. Iqu tii ätkqe. “Nyi iqu aŋgi äquvepmqäŋgaŋqä qäyä pmetŋqä nyiŋgaŋgutqe, ii nätmatqä tqä manä.” ");
INSERT INTO mcr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ii wäuŋuä yätquakä, nätmatqeŋqä täŋga awä ätätä, kukŋuä tä äqäkqä iqu, ii qäqueqä. Ga ne näqŋqä tii eŋu. Kukŋuä iqu awä ätqäqä tä, ii naqä-qakuänäŋi. ");
INSERT INTO mcr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Itaŋga nätmatqä hui-hui-pqä di, Jisasi Iqu inä imäkmiŋqe. Iŋäqe qu nätmatqä iiŋi hŋqunä-hŋqunä äqäpqe, ga qua täuŋi bukä pŋqä eqäŋqe, hiqŋqe etäti, maeqä etäti? ");
INSERT INTO mcr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tipilusi iquki, nyi bukä huiziqu äqäkqä iuŋi, Jisasi Iqu imäkmiŋqeŋqätä, näqŋqä äwimiŋqeŋqätä, hiunji Goti Hanjuwä Iqu, Ique ätuma ekqäŋgaŋqe, eeqänäŋi ae äqäkqe. Goti Hanjuwä Iqu, Ique änyä mätuma mayqäŋga, Iqu ämaqä, kukŋuä awä tuäkiqäpŋqä dowatätŋqä atäuŋuä ikqä iquauŋi, qu wäuŋuä imäkpnuwäŋqä diŋqe, Dŋä Äŋguä Iquesa ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iqu täŋä-huŋqe qäpu ae ämeqe, qänakndaŋi, ämaqä iquau äwimeqe, iqua, “Iqu ävautä, häŋä äpmenä” kŋuä vätŋqä diŋqe, nätmatqä kuapänäŋi imäkkqe. Hea 40 iuŋi, Iqu äwimeqisätä, Goti Hanjuwä Iqunä miqä iuŋqä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hea hŋqueŋi, Iqu iquatä buayä anä änäpu, tiiŋä ätukqe. “He Jerusälemäŋi, mävämeqä iqäpŋqä. He nätmatqä äŋguänäŋä, Apiqu ‘Äwimniqeqä’ ätkqeŋqä, hiŋuä äqämbu pmeqäpŋqä. Hiŋuiqänäŋi Nyi iiŋqä awä ae etkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ii tiinjqä. Jonä iqu ämaqe, eqetä asŋä äqämiŋqe. I etaŋgi hiunji kuapänäŋä maeqäŋga, he asŋi, Dŋä Äŋguä Iquesä mapŋqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iqua aquvä äqämbu anä äpmapiyi, Ique yatŋqä tii äwikuwi. “Naqä Iquki, täŋgaŋi Si Israitqä iqua, Romätaŋä iquauä yäpä imä mäpmeqä ipŋqä, aŋgi yäŋänäqŋqä iwimäktŋqätanä?” ");
INSERT INTO mcr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kimaŋi, Iqu tiiŋä ätukqe. “Hiunji Apiqu ätekqeŋqe, he näqŋqä maeqä ipŋqäuä. Näqŋqe, Apiqu Kiqä-kiuänä enä. ");
INSERT INTO mcr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iŋäqe Dŋä Äŋguä Iqu emeqaŋga, qänakndaŋi, he yäŋänäqŋqä ämepu, Nyaqä kukŋuä awi, Jerusälemä iutä, qua Jutiya aŋä eeqänäŋä iutä, qua Sämaliya aŋä eeqänäŋä iutä, qua eeqänäŋä hituŋuä äwiŋqä-ma, tuäkiqäpnuwäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iqu iiŋä ätuäqe, iquauqä hiŋuä iqisa yändi-yändi peyätqätaŋga, qaquvqä hŋqu Ique itmakqe. Itmeqaŋga, iqua Iqueŋi, hiŋuä mäquŋquä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iqu äyätqätaŋgqä yätu, iqua hiŋuä yqänä qunätaŋguwäŋga, ämaqä qäpaiqä imäkŋqä hŋquaqu, iquatä maqänä qäqi anä ätqäukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Iŋgaŋi iquaqu tii ätukiyi. “Ämaqä Galilisaŋä iquenä, he qäukuä yätuŋi, suŋqä hiŋuä äqumbu tqäuŋäuä? Goti Hanjuwä Iqu, Jisasi Iqueŋi, hesa haqä yätuŋqä itmeqaŋgi ii äqunäŋuwä-pa, aŋgumŋi iiŋä päniqeqä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iŋgaŋi iqua qoqoŋä Olipä iu ävämaŋi, Jerusälemäŋqä aŋgi äukuwi. Kiqä qaŋä uwqe, wanä kilomita. ");
INSERT INTO mcr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Qu iqi ätimäupiyi, aŋä hiqŋqä haqä yätqä imäknätaŋgi, äpmamiŋuwä-täŋä ique äpaqukuwi. Pitä ique, Jemisi ique, Jonä ique, Endru ique, Pilipä ique, Tomasi ique, Batromi ique, Matiu ique, Jemisi, Aläpiyasi iqueqä hikŋä ique, Saimonä, Selotqä iquautaŋä ique, Jutasi, Jemisi iqueqä hikŋä ique, iqua iqi äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Qu äwqä naqä-hŋqunä imbu, Goti Hanjuwä Iqutä kukŋuä anä ätqämanmiŋuwi. Iŋgaŋi apäkä hiuatä, Mäliya Jisasi Iqueqä känaisä, Iqueqä käŋguäkatä, anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","I pmeqisätqätaŋguwäŋga, hea hŋqueŋi, ämaqä Jisasi Iquenyqä quuvqä eqämiŋuwä kuapänäŋä iqua, aquvä äqäŋguwi. Ämaqä 120 iŋi. Iŋgaŋi Pitä iqu, iquauqä awä iqi pämä ätqäuqe, “Ŋqä nyämaqäuä, kukŋuä Dŋä Äŋguä Iqu vqaŋgi, Dewiti iqu ätätä, Goti Hanjuwä Iqueqä tuwaŋuä iu äqäkqe, ae ätimäuqeqä” ätukqe. “Iqu Jutasi, Jisasi Ique a kiqätpŋqä iquau hänaqä motqueqä iquenyqä ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iqu nesaŋä-qu eä, wäuŋuä anä ituŋqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Jutasi iqu, mbqä iqueqä suqä quvqeuŋqä äwikuwi, iqu ämeqe, qua hŋqu mbqä ikqe. Qänakndaŋi iqu qua iqi päkŋgaŋga, iqueqä äwqe äpkmäutä yäpaqäŋgisa ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iiŋiŋqe, ämaqä Jerusälemätaŋä eeqänäŋä iqua, näqŋqä e ämapiyi, quwqä aŋä-kukŋuä iu, qua iuŋqe yoqä ‘Akätamäuä’ änyuätkuwi. Kukŋuä iqueqä quati, ‘Qua häŋeqä-täŋiqä.’) ");
INSERT INTO mcr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ii apqä bukä iuŋi, tuwaŋuä tiiŋä äqänäŋqä-payi. ‘Iqueqä aŋi, ämaqä hŋqu mäpmeqä etaŋgqä, aaŋqä iqi ämätnänä.’ Itaŋga tiiŋä-pqä inä äqänänä. ‘Ämaqä hŋqu-pqe iqueuä yoqä naqetä, wäuŋuitä, ämeŋqiyä.’ ");
INSERT INTO mcr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kukŋuä ii äqänäŋqetaŋi, Naqä Jisasi Iqu aŋgi ävaukqeŋqä kukŋuä awi, nesä anä tuaniŋqueŋqä, ämaqä hŋque atäuŋuä yatuŋqueqä. Ämaqä iiŋä iqu, hea Jonä iqu asŋä äwikqä iutati, Jisasi Iqu ne äneväma ekqäŋgaŋqä, Jisasi Iqu wäuŋuä imäkätqätaŋgqä iu nesä anä äpmeŋquä iutaŋä hŋque, atäuŋuä iatuŋqueqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iŋgaŋi iqua hŋquaqui atäuŋuä ikuwi. Hŋqu Josepä Basäpasi, iqueqä yoqä huizi, Jastusi iquvi. Hŋquququeqä yoqe, Matiyasi ique. ");
INSERT INTO mcr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Qu ii imäkäpu, Goti Hanjuwä Iqutä kukŋuä tiiŋä ätukuwi. “Naqä Iquki, ämaqä eeqänäŋä qua täutaŋä tqune, neyaqä qeqä-quuvqeŋqä näqŋqä Iqukiyi. Ämaqä tquaquiŋi, äsque ätekŋiŋqä, mänätquayä. ");
INSERT INTO mcr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Iŋi, Jisasi Iqu, ne Iqueqä kukŋui awä tuäkiquatuŋquä änändowatkqä iutaŋä wäuŋui, ämaqä iiŋä iqu, Jutasi iquenyqä tŋäŋqä pmetŋqä. Jutasi iqu wäuŋuä ii äväma, iqueqä aŋä näweqä iuŋqä äukqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","E ätpiyi, ‘yoqe hiŋuiqäŋi tqueqä timäuŋqutiyä’ tpu, hikä hŋquaqu zä ekuwi. I etaŋgi, hikä, Matiyasi iqueqä yoqä-täŋi, ätimäukqe. Qu iqueŋi, ämaqä 11, kukŋuä awä tuäkiqäpŋqä ändowatkqä iquatä, anä äpmuatekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hiunji hapä pmeqä naqänäŋä, qu ‘Pendikosiŋganjqä’ ätmiŋuwi, ätimäukqe. Iŋgaŋi qokä-apäkä Jisasi Iquenyqä quuvqä heqiyqä iqua, aŋä hŋque äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Iŋgaŋi qäukuä haqä yätutaŋi, hääŋqä ätäqe, yuŋuä yäŋänäqŋqä eŋqä-paŋä maqänä äpäqe, aŋä qu pmetaŋguwä iqueŋi kuapänä äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iiŋä iäqetaŋi, tä hänaqä eŋqä-paŋi äququeqäkaŋi, iquauqä haqeqä äpmakäwqaŋgi iqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iŋgaŋi Dŋä Äŋguä Iqu, qokä-apäkä iquauŋi kuapänä muŋgaŋgi, qu aŋä-kukŋuä huitaŋä-huitaŋä ätipäqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","6","Ämaqä Goti Hanjuwä Iqueqä kukŋuä qätä wiyqä Israitqä hŋqua, qua eeqänäŋä iuta ätimäupu, Jerusälemä iu äpmamiŋuwä iqua, nätmatqä iiŋi qätä äwipiyi, äpäpu aquvä äqäŋguwi. Jisasi Iqueqä ämaqä iqua kukŋui, quwqä aŋä-kukŋuä iu tqäwqaŋguwiŋqe, qu yäuŋuä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Qu yäuŋuä ipiyi, tiiŋä ätŋguwi. “Ämaqä kukŋuä tä ätätqäŋuwä tqua, eeqänäŋi Galilisaŋä-quaeqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iŋi änääŋäwä? Ne hŋqunä-hŋqunäŋi, qu neyaqä aŋä-kukŋui qäyunä tqaŋgä äwiyqueuä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","“Ne ämaqä Patiya pmeqä, Mindiya pmeqä, Elamä pmeqä, Mesäpotemiya pmeqä, Jutiya pmeqä, Kapatosiya pmeqä, Pondusi pmeqä, Eesiya pmeqä, Päleŋgiya pmeqä, Pambiliya pmeqä, Isipä pmeqä, Limbiya iuŋi aŋä-himqä Sairini iŋgisa pmeqä, aŋä-himqä Romä pmeqä, Kritä pmeqä, Arepiya pmeqä iqune, ne ämaqä Israitqä iqunesä, ämaqä huizi, Goti Hanjuwä Iquenyqä qoŋä anä äuktäutuŋquä iquatä, äpätanä äpmeŋunä. Iiŋä etaŋgi Goti Hanjuwä Iqu, wäuŋuä yäŋänäqŋqä imäkätŋqeŋqe, qu awi, neyaqä aŋä-kukŋuä huitaŋä-huitaŋi tqaŋgä qätä äwiyqunä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iŋgaŋi qu yäuŋuä ipu, kŋuä kuapänä indqänäpu, tiiŋä ätŋguwi. “Nätmatqä tä ätimäuqäqe, quati änääŋgä?” ");
INSERT INTO mcr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iiŋä etaŋgqä-qe, ämaqä hŋqua, quuvqä heqiyqä iquauŋqä tä äsäpu, tiiŋä ätkuwi. “Tä qu wainqä-eqä kuapänä änäpu, hiqiiyqä iqäuä.” ");
INSERT INTO mcr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iŋgaŋi Pitä iqutä, 11 iquatä, pämä ätqäpiyi, iqu maŋä yäŋänäqŋqä ätätä, qokä-apäkä iuŋi tii ätukqe. “Qua Jutiya iutaŋä iquendä, ämaqä kiŋä imdaŋä äpäpu, Jerusälemä täu äpmeŋuwä iquendä, nyi kukŋuä tä tmqä iqäqe, he qätä äŋguänä änyiyäpu, nätmatqä täŋqe, näqŋqä äŋguänä mapŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","‘Qu wainqä-eqä änäpu hiqiiyqä iqäuä’ kŋuä maiyqä pa inä, oeyä! Ziŋuitä, 9 klokŋganjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Tä ätimäuqäqe, hiŋuä-tqä Joeli iqu, ätkqä-panjqä. Iqu tiiŋä äyä ätkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Goti Hanjuwä Iqu tiiŋä ätätqänä. “Hea yäpakäŋgaŋi, Nyi qokä-apäkä eeqänäŋä iuŋi, Ŋqä Dŋä Äŋguä Ique äwiquatmniqeqä. Itaŋi hiqä ymeqä qokä iquatä, ymeqä apäkä iuatä, hiŋuä tpnuwiqä. Hiyaqä hikŋä iqua-pqe, wätqä eŋqä-paŋä qumbnuwiqä. Itaŋga hiyaqä qoyaŋä iqua wätqä qumbnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tiiŋä-pqä inänji. Nyi qokä-apäkä wäuŋuä-nyiyqä iquau-pqe, Ŋqä Dŋä Äŋguä Ique äwiquatmniqeqä. Iŋi qu-pqe hiŋuä tpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","He hiunji iqueŋqä näqŋqä hipŋqeŋqe, qäukuä yätutä, qua butäŋi, Nyi nätmatqä hiutaŋä-huitaŋä tii imäkmniqeqä. Häŋeqätä, tä suakä naqänäŋätä timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Itaŋga mäptqe hea äwitä, qaŋui häŋeqä eŋqä-paŋä imäkŋgaŋga, iŋgaŋi Naqä Iqueqä hiunji, Iqueqä yäŋänäqŋqetä, we-huŋqä naqänäŋitä, ämaqe yäuŋuä wimäkqäŋqä timäuniqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iŋi iŋgaŋi, qokä-apäkä, Naqä Iqu yätamäkqä vätŋqä tääqä tquaŋgqä eeqänäŋä iqua, Iqu aŋgu itmetä häŋä iqumuatäniqeqä” ätätqänä’ ätkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ämaqä Israitqä iquenä, nyi Jisasi Nasäretqätaŋä Iquenyqä hetmqä iqäqe, qätä nyipiyä. Goti Hanjuwä Iqu, Ique yäŋänäqŋqä iwimäkqaŋgi, Iqu ämaqä mimäkqänäŋä huitaŋä di heyaqä awiqisa imäkqaŋgqe, he hiŋuä äyä äqunäŋäuä. Hiŋuä iiŋä äqumbiyi, ‘Iqu Goti Hanjuwä Iquesa äquvepqiyä’ kŋuä äyä ämeqäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“Goti Hanjuwä Iqu, hiŋuiqänä kŋuä indqänätä ‘imäkmniqeqä’ ätkqä-pa, Ämaqä Tqueŋi hiyaqä hipa iu äyä etapkqeqä. Iŋi he Iqueŋi, ämaqä ququvqänäŋä iquauqä hipa iu äväpu, zä-huätatä äuepu, pizqä ae äpäkkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Iiŋä etaŋgi Iqueŋi, äpäkoŋqe a makiqätqä iqaŋgi, Iqu äpäkonätä täŋä-huŋqä meqaŋga, Goti Hanjuwä Iqu hiŋuinä mäquŋquä itä, aŋgu ävauqumuatkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Ii äwimakqe, Dewiti iqu iquenyqä tiiŋä ätkqäqä-paŋiqä. ‘Naqä Iqu, nyaqä hiŋuä iqi hea ique-ique pmetaŋgi äqunäŋänä. Iqu nyaqä ämuaŋgisa äpmeŋqe, nyi yäuŋuä-yäuŋuä miqä ymqänä. ");
INSERT INTO mcr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","I etaŋgi nyi äwqä yeeqä itmä, ŋqä kukŋuä ätätmi, yeeqä iiŋqe, Iquenyqänä tqämqänä. ");
INSERT INTO mcr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nyi ämaqä, Si “Ŋqeqä” ätätnä ätenjikŋä iqunä etaŋgä, nyi ämaqä ae äpäkoŋguwä iquauä aŋä iuŋi äpmetmä, piyaŋä wamqe hiŋuinä maŋqäŋqä isiŋiqä. Iŋi nyi nätmatqä Goti Hanjuwä Iqu iiŋä inyimäkäniqä iiŋqä, kŋuä ganä indqänätmä, äŋguänä pmamqänä. ");
INSERT INTO mcr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Häŋä-pmeqeuŋqä hänaqe, Si ae ämändquakŋiqä. Itaŋga nyi Sitä anä äpmetayitaŋi, Si yeeqä iiŋqe daptŋiqä’ ätkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Tatqä-guäkenä, nyi kukŋuä awi qäyunä tiiŋä hetmqänä. Neqä awiqu Dewiti iqu ae äpäkoŋgaŋga, qu ique qua äptekuwi. Itaŋga ique qua äptekuwi, täŋgaŋä-pqe neyaqä awä täqi äyä äptnänä. ");
INSERT INTO mcr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iiŋä etaŋgi Dewiti iqu hiŋuä-tqä-qu eä, iqu näqŋqä tiiŋä emiŋqe. Goti Hanjuwä Iqu, ‘Qänakndaŋi Nyi tqä tawäkataŋi, ämaqä naqä si eŋqä-paŋä hŋqu imäkmniqeqä’ ätätäqäŋgaŋi, Iqu naqä-qakuä ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Iutaŋi, Goti Hanjuwä Iqu, Kraisi neyaqä Ämineyqä Ique, aŋgu vauqumuatäniqä diŋqe, Dewiti iqu, hiŋuä ganä äqunätä, tii ätkqe. ‘Ämaqä ae äpäkoŋguwä iquauqä aŋiu äpmetmä, piyaŋä wamqe hiŋuinä maŋqŋqä yäniqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iiŋä etaŋgi Jisasi Iqueŋi, Goti Hanjuwä Iqu qua äptekuwä iuta ae ävauqumuatkqe. Ne eequne hiŋuä iiŋä äquŋgqueŋqä awä tquä-neyi. ");
INSERT INTO mcr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Täŋgaŋi Iqu qäukuä haqä yätuŋqä äyätä, Goti Hanjuwä Iqueuä hipa ämuaŋgisa äpme. Iŋi Goti Hanjuwä Iqu hiŋuiqänä ätukqä-pa, Iqu Dŋä Äŋguä Ique, Kaniqueqä hipa iuta ämetä, nätmatqä tä he hiŋuä äqunäpu qätä äwiyätqäŋuwi, ae äyä änequatqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Dewiti iqu, qäukuä haqä yätuŋqä mäyqä itäqä-qe, iqu tiiŋä ätkqe. ‘Naqä Iqu nyaqä Naqä Iqueŋi, “Nyi Tqä himä-wiuŋqä iquauŋi, mändi äkittqäyätmä, Saqä yäpä iqi pmuatemqäŋgaŋqe, Si Nyaqä hipa ämuaŋgisa pmayä,” ätukqeqä’ ätkqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Iiŋä etaŋgi Israitqä eeqänäŋä iquenä, he näqŋqä äŋguänäŋä mapiyä. Jisasi he zä-huätatä äuekuwä Iqueŋi, Goti Hanjuwä Iqu iwimäkqaŋgi, Iqu neqä Naqä-qu etä, Kraisi ne Ämineyqä-qu ekqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Qokä-apäkä iqua, Pitä iqu kukŋuä tqaŋgqe qätä äwipiyi, quwqä äwqä haŋä kiiŋä vqaŋga, yäuŋuä ipu, kŋuä kuapänä indqäŋguwi. Iiŋä ipiyi, qu Pitä iquesä, ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä huizi iquautä, yatŋqä tiiŋä äwikuwi. “Tatqä-guäkenyä, ne äänä imäkatuŋquäwä?” ");
INSERT INTO mcr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Iqu kimaŋi tii ätukqe. “Goti Hanjuwä Iqu hiqä suqä quvqe huätä maemäutŋqä diŋqe, he eeqänäŋä hŋqunä-hŋqunäŋi, kŋuä äkunmäknäpu, hiqä quvqe ävquatämäupu, ga Jisasi Kraisi ne ämineyqä Iqueuä yoqeta, asŋä mapiyä. He iiŋä imäkqaŋguwäŋgaŋi, Goti Hanjuwä Iqu Dŋä Äŋguä Ique etapäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ii, tiiŋi. Hiŋuiqänäŋi, Goti neqä Naqä Iqu, Dŋä Äŋguä Ique hitapäniŋqä kukŋuä quti ämäsäutäqäŋgaŋi, Iqu qokä-apäkä, Iquenyqä ppŋqä tääqä ätuätumeniqä eeqänäŋä iuŋqä, kŋuä indqänätä ämäsäukqe. Qu hesaŋätä, hiqä ymeqä iquautaŋätä, itaŋga qokä-apäkä eeqänäŋä kiŋä nämä äpmeŋuwitaŋätä, iquayqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ga Pitä iqu kukŋuä kuapänäŋi inä ätuätä, itaŋga, “Suqä quvqä imäkqä täqi äpmeŋuwä iquatä, qui anä imäkŋqä diŋqe, hiqä-hiuä äŋguänäŋä mimbiyä-qe,” yäŋänäqŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iŋgaŋi Pitä iqueqä kukŋui, qokä-apäkä iquauqä äwqeuŋi, äŋguänäŋä ämuŋgqä iqua, qu asŋä ämakuwi. Hiunji iqueŋi, qokä-apäkä 3,000, Jisasi Iquenyqä quuvqä eqiyäpu, quuvqä eqämiŋuwä huiziquau äwimakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Itaŋga qu eeqänäŋä iqua, kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, näqŋqä vqaŋgä qätä äwiyäpu, yätamäkqä änyäpu, buayä anä änäpu, Goti Hanjuwä Iquenyqä tääqä ätäpu, äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iŋgaŋi qokä-apäkä iqua, Goti Hanjuwä Iquenyqe, “Iqu aaŋä yänänjqä” kŋuä indqänäpu zä imiŋuwi. Itaŋga Goti Hanjuwä Iqu ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau iwimäkqaŋgi, qu nätmatqä ämaqä mimäkqänäŋä di kuapänä imäkmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Qokä-apäkä Jisasi Iquenyqä quuvqä eqiyäpiyä iqua, äwqe naqä-huinyä imbu, nätmatqä eeqänäŋiŋqä “Ŋqeqä” matŋqä ipu, “Neyaqeqä” ätnmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Quwqä quaetä, nätmatqä quwqä ämamiŋuwitä, mbqäŋqä imäkäpu, mbqä ämapiyi, iwäsäupu, ämaqä äwa iqaŋguwä iquau äwimiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Qu hiunji ique-iqueŋi, äwqä naqä-huinyä imbu, hiqäva-imäkqä aŋä iŋgisa aquvä äqänäqisäpu, ga ymisaŋi “ŋqänänjqä” matqä ipu, yeeqänä ipu, aŋä hŋque-hŋque buayä anä änäkämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Qu iiŋä imäkäkipiyäŋgaŋi, Goti Hanjuwä Iqueqä yoqe haqeu ämamäumiŋuwi. Ämaqä huiziqua ii iqaŋgä äqumbiyi, qu “Ii äŋguiqä” ätmiŋuwi. Itaŋga hiunji ique-iqueŋi, Naqä Iqu qokä-apäkä qui imäknätqätaŋguwä hui aŋgumä inä itmetä, quuvqä eqämiŋuwä iquatä anä äpmuatemiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Hiunji awiyqä hŋqueŋi, Israitqä iqua quwqä tääqä tqäŋga etaŋgi, Pitä iqutä Jonä iqutä, hiqäva-imäkqä aŋä iuŋqä äukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Iŋgaŋi ämaqä hui, yukä quvqä-täŋä hŋque isuäŋä äqäŋga äpkuwi. Ämaqä iqu, känai yukä quvqä iiŋäque änyuekqe. Qu iqueŋi, hiunji ique-iqueŋi hiqäva-imäkqä aŋä hänaqä hŋqu, “Qeqätqeqä” äqonätaŋgqä-täŋä qäqiqi, qokä-apäkä aŋä yäpä yäŋgisa peyqaŋguwä iquau, mbqäŋqä tääqä tqämaŋguätŋqä, äpmuatemiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iŋgaŋi ämaqä iqu, Pitä iqutä, Jonä iqutä, hiqäva-imäkqä aŋä yäŋgisaŋqä peyiŋqä iqaŋginyä äqunäqe, “Mbqä hui dapinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iqu i tquaŋga, Pitä iqutä Jonä iqutä, ique hiŋuä yäŋänäqŋqä äqunyiyi, Pitä iqu, “Si hiŋuä yaqänyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iwä ämaqä iqu, “Iquaqu nätmatqä hui dapiyŋqeqä” kŋuä vqaŋgi, iquaqui hiŋuä yäŋänäqŋqä äqunmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","I iqaŋga, Pitä iqu tiiŋä ätukqe. “Nyi mbqä maiqunjqä. Itaŋga nätmatqä nyi ämeŋqe, äktapmqänä. Iŋi Jisasi Kraisi Nasäretqätaŋä Iqueqä yoqetaŋi, nyi si äktqänä. Pämä ätqäutnä, qaŋä uvä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","E ätuäqe, iqu iqueqä hipa ämuaŋgisa a ämäwqätätä, pämä ävauqumuatkqe. Ii iwimäkqaŋga, iqueqä yukitä, qoiqetä, maqänäŋi äŋguä wimäŋgaŋgi, pämä yäŋänäqŋqä ätqäutä, qaŋä ikäkqe. Iŋgaŋi iqu qaŋä tkamä-tkamä äwätä, Goti Hanjuwä Iqueqä yoqe haqeqä ämamäutä, iquaqutä hiqäva-imäkqä aŋä yäpä yäŋgisa anä äpekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Qokä-apäkä eeqänäŋä iqua, iqu qaŋä äwätä, Goti Hanjuwä Iqueqä yoqe, haqeqä mamäuqaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","E äqumbiyi, qu näqŋqä tiiŋä ekuwi. “Ämaqä tqu, hea ique-ique hiqäva-imäkqä aŋä hänaqä qeqätqä iu äpme, mbqäŋqä tääqä änatqämanätŋqä iquvqä.” Itaŋga qu, yäuŋuä ipu, “Tä änääŋätiyä” tpu ipu, kŋuä kuapänä indqänmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Qu iiŋä ipiyi, maqänä äpäpu, ‘Solomonä iqueqä aŋä mätävätiŋiqä’ ätmiŋuwä iqi ätimäupiyi, yukä quvqä iqu, Pitä iqueätä, Jonä iqueätä, hipa a äqätä tqäutaŋgi äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pitä iqu i iqaŋgä äqunäqe, “He Israitqä iquenyä, nätmatqä tä timäuqaŋgqeŋqä yäuŋuä ipu, hiŋuä yäŋänäqŋqä suŋqä yaqänäŋäuä?” ätukqe. “He kŋuä tiiŋä maeyqä pa inä! ‘Ämaqä tqu qaŋä äwqäqe, iquaquvqä yäŋänäqŋqä iutatä, suqä jänänäŋä imäkqä iutatä, imäkqinyqä.’ Oeyä! ");
INSERT INTO mcr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ii tiinji. Aprähamä iqueqä, Aisakä iqueqä, Jekopä iqueqä, neqä awäkaqä Goti Hanjuwä Iqu, Iqueqä Wäuŋuä-wiyqä Jisasi Iqueŋi, yoqä naqä äyä äwikqeqä. Iqueŋi, he pizqä päsqä iquauä hipa iu vqaŋguwäŋgaŋi, Pailoti iqu, Ique hiŋuinä qunäwatmätä iqaŋga, he Ique tuwä äwiyäpu, Pailoti ique, ‘Ne Jisasi Iquenyqe, mäneŋqä iqiyä’ ätukuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ämaqä Iqu, Goti Hanjuwä Iqueqä yäpä iqinyä äpme, suqä jänäŋinä imäkqä-qu qäyä etaŋgqä-qe, he Iqueŋi tuwä äwiyäpu, ‘Ämaqä päsqä iqueŋi, hiŋuinä qunäwatiyä’ ätukuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I etaŋgi he Ämaqä, häŋä-pmeqä mitimäuqä Iqueŋi, äpäsqaŋguwäŋga, Goti Hanjuwä Iqu Iqueŋi aŋgu ävauqumuatkqeqä. Ye, iiŋä timäuqaŋgi hiŋuä äquŋgueetaŋi, awä-tqä-qoyeyi. ");
INSERT INTO mcr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ye Ämaqä Iqueqä yoqeŋqä quuvqä eqiyäŋueä-qae, ga ämaqä, he hiŋuä äqunäpu näqŋqä equwä iqu, yäŋänäqŋqä ätimäuqe, ii Qäqueqä yoqetanji. I etaŋgi, iqu äŋguä imäŋgaŋgi äqunäŋuwi, ii Jisasi Iqu yeqä quuvqä heqiyqe yäŋänäqŋqä yemäkqaŋgqä iutanjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ŋqä nyämaqäuä, hesä heyaqä ämaqä naqä iquatä, he änyä maqŋqä epu, Jisasi Ique ii iwimäkkuwiŋqe, nyi näqŋqä eŋänä. ");
INSERT INTO mcr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Iŋäqe Goti Hanjuwä Iqu, Iqueqä hiŋuä-tqä iquau kŋuä iqä vqaŋgi, iqua ‘Kraisi ne ämineyqä atäuŋuä ikqä Iqu, haŋä-iqä meniqeqä’ ätäpu hiŋuä ätmiŋuwi. Ga Iqu, he Jisasi Ique päsqaŋgä hiŋuinä eqänätä, Iqueqä kukŋuä iiŋi, qäyunä äyä ätimäukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Goti Hanjuwä Iqu hiqä suqä quvqe huätä maemäutŋqä eŋgaŋgutqe, hiqä kŋui äkunmäknäpu, suqä quvqe ävquatämäupu, Iqu-täŋä qäqiqinyqä aŋgi bpiyä. Iiŋä iquwi, Naqä Iqu hiqä hapä pmeqä änyä-häŋä etapätä, Jisasi Kraisi hiqä ämeyätŋqä ätekqä Iqueŋi, aŋgu dowatäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","I etaŋgi täŋgaŋi, Goti Hanjuwä Iqu nätmatqä eeqänäŋi, aŋgu änyä-häŋä imäkätqäŋgaŋqä, Jisasi Iqu qäukuä haqä yätu pmetätŋqe. Hea iŋgaŋqe, Goti Hanjuwä Iqu, hiŋuä-tqä, Iqueqä wäuŋuäŋqä ätekqä iqua, awä tpŋqä hiŋuiqänä ätuäŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hiŋuiqänäŋi Mosisi iqu tii ätkqeqä. ‘Hiqä Goti Naqä Hanjuwä Iqu, heyaqä awiqisaŋä hŋque, hiŋuä-tqä nyi eŋqä-paŋä-qu hiätŋqä atäuŋuä yäniqeqä. Iŋi iqueä kukŋuä eeqänäŋi, he qänaknä iqäpŋqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","‘Itaŋga hiŋuä-tqä iqueŋi, qätä mäwiyqä imipqe, qui imäknäpu, Goti Hanjuwä Iqueqä ämaqetäŋi, anä mäpmeqä ipnuwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","I etaŋgi Samueli iqutä, huizi iquatä, hiŋuä ätqa äpmiŋuwä iqua, Goti Hanjuwä Iqueqä kukŋui awä ätäpu, nätmatqä täŋga tä ätimäuqeŋqä ätmiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kukŋuä hiŋuä-tqä iqua ätmiŋuwitä, kukŋuä Goti Hanjuwä Iqu hiqä hewukauŋqä kukŋuä quti ämäsäukqetä, emeqiyä. Kukŋuä quti ämäsäutä, Aprähamä iqueŋi tii ätukqeqä. ‘Tqä taqä-tawäkataŋi, qokä-apäkä qua täu pmapnuwä eeqänäŋä iquauŋi, Nyi äŋguä iwimäkmniqeqä’ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Iŋi he hŋqunä-hŋqunä, suqä quvqä huätä vquatämäupŋqä yätamäkqä eyätä, äŋguä emäkätŋqä iuŋqä, Goti Hanjuwä Iqu, Iqueqä Wäuŋuä-wiyqä Ique ävauqumuatäqetaŋi, henyqä ganä ändowatkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitä iqutä, Jonä iqutäŋi, qokä-apäkiu kukŋuä yqänä tuätqätaŋgiyäŋga, hiqäva-imäkqä iquatä, hiqäva-imäkqä aŋiutaŋä ämayukä-imaŋqä iquauqä naqä iqutä, Satyusi iquatä äwimakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iŋgaŋi iquaqu qokä-apäkiu näqŋqä äväsinyä, “Jisasi Iqu ävaukqä-paŋä iiŋi, ämaqä ae äpäkoŋguwä iqua-pqe aŋgi i vaupnuwiqä” tquaŋginyä äwipiyi, qu äwqä tnäŋä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Iiŋä ipu, Pitä iquesä, Jonä iquesä a äkiqätpiyi, mäptqä äwitŋqä qäqä etaŋgi, hea awiŋgaŋqä guä äkiqiyekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iiŋä etaŋgi qokä-apäki, qu iquaqu awä tqaŋginyä qätä äwipiyi, kuapänäŋi, Jisasi Iquenyqä quuvqä eqäkuwi. Qokä, quuvqä eqäka äpmiŋuwä iqua, eeqänäŋi 5,000. ");
INSERT INTO mcr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hea awiŋgaŋi, Israitqä iquauqä ämiqä iquatä, ämaqä naqä iquatä, kukŋuä-suqeŋqä näqŋqä iquatä, Jerusälemä iu aquvä äqäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi hiqäva-imäkqä naqä ique, Käyäpasi ique, Jonä ique, Aleksandä ique, Anasi iqueqä käyämaqä huizi iqua-pqe, anä äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pitä iquesä, Jonä iquesä, iquauqä hiŋuä iqi ämatqätepiyi, yatŋqä tii äwikuwi. “Qe wäuŋuä huäqi imäkqiyi, yäŋänäqŋqe äkita pqaŋgi imäkqiyäwä? Tqueqä yoqeta imäkqiyäwä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","10","Iŋgaŋi Pitä iqu, Dŋä Äŋguä kuapänä muŋgaŋgi, tii ätukqe. “Israitqä iquau miqä iquendä, ämaqä naqä iquendä, ye suqä äŋguänäŋä, ämaqä yukä quvqä hŋque iwimäkqueŋqe, ‘Iqu äŋgui äänä imäŋgutiyä’ tpu, näqŋqä mapŋqä etaŋgutqe, hesä, Israitqä eeqänäŋä iquatä, näqŋqä tiiŋä hipŋqeqä. Jisasi Kraisi neqä ämineyqä, Nasäretqätaŋä Iqueä yoqeta, ämaqä yukä quvqä äŋguä imäŋgqä tqu, heyaqä hiŋuä täqi äyä ätqäunä. Jisasi Iqueŋi, he äpäsäpu zä-huätati äuekuwi, Goti Hanjuwä Iqu aŋgi ävauqumuatkqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Bukä iuŋi, tiiŋä äqänänä. ‘Aŋä imäkqä iquenä, hikä “quvqeqä” ätäpu huätä ämamäukuwi, aŋä quea eŋqä-pa, aŋä yäŋänäqŋqä imäkqä iqueqä.’ Hikä iqu, Jisasi Iqueqä. ");
INSERT INTO mcr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne aŋgu inätmeqe, ämaqä hŋqu hmanjqä. Jisasi Iqunänjqä. Qua täuŋi, Goti Hanjuwä Iqu ämaqä hŋqueqä yoqe, mämänätqueqä enä, Jisasi Iqueqenänjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pitä iqutä, Jonä iqutä, zä miqä kukŋuä awä yäŋänäqŋqä tqaŋginyä qätä äwikuwä iqua, ämaqä iquaqu, näqŋqä mayŋqä mäwqä-quaqu äyä etaŋgi äqumbiyi, kŋuä kuapä indqänäpu, näqŋqä tiiŋä ämakuwi. “Hiŋuiqänäŋi, iquaqu Jisasi Iqutä anä äyä äpmamiŋuwiqä.” ");
INSERT INTO mcr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ämaqä yukä quvqä äŋguä imäŋgqä iqu, iquaqutä anä tqäutaŋgä äqumbiyitaŋi, qu kukŋuä matqä, qanyinä äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Itaŋi qu iquaqui aŋä aquvä äqänäpu, kukŋuä iwäsäuqä iutaŋä yäpaqä mäŋgisa ändowatpiyi, kukŋuä tii ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ämaqä tquaquiŋi, ne äänä imäkatuŋquäwä? Ämaqä mimäkqänäŋi imäkqaŋginyä, qokä-apäkä Jerusälemä pmeqä eeqänä näqŋqä ae eqäuä. Iiŋqe, ne ze, änä maeqä yaŋqunä. ");
INSERT INTO mcr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Iiŋä etaŋgi qokä-apäkä huizi iqua, qätä mäwiyqä ipŋqä diŋqe, ne iquaquiŋi, ‘Qe yoqä iqueŋi, ämaqä hŋquau-pqe awä mätquä panyinyä-qe’ yäŋänäqŋqä tuatuŋqueqä” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","E ätmbiyi, qu iquaqui tääqä ätuätumepu, qokä-apäkä iuŋi, Jisasi Iqueqä yoqe ätuäsinyä näqŋqä mämotqueqä iyŋqä, pmua imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Iŋgaŋi Pitä iqutä, Jonä iqutä, iquauqä kukŋui kimaŋi, tiiŋä ätukiyi. “Goti Hanjuwä Iqueqä hiŋuä iqiŋi, suqä jänäŋi äkikä? Hiqä-hiuä iwäsäupiyä! Ye qänaknäŋi, heyaqä kukŋuiu yeŋqätanä, ä Goti Hanjuwä Iqueqeu yeŋqätanä? ");
INSERT INTO mcr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Suqä qäyunäŋi, tiinjqä. Ye kukŋuä awä mätquä pa, miqä yenyqueä. Nätmatqä eeqänäŋi, ye hiŋuä äqunäta qätä äwiyätqäŋueŋqe, kukŋuä awä tenyqueä” ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Ämaqä änä mimäkqänäŋä iuta äŋguä imäŋgqä iqu, iqueqä quväukui 40 ae ämäwqätäukqe. Iiŋiŋqe, qokä-apäkä eeqänäŋä iqua, Goti Hanjuwä Iqu imäkqaŋgqeŋqä, Iqueä yoqe haqeqä mamäuqaŋgä, ämaqä naqä iqua, iquaqui quvqä imäkpŋqe, änä maeqä ikqe. Iŋi qu iquaquiŋi, kukŋuä yäŋänäqŋqä dinä ätupiyi, qe ävquatäwatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","I ävquatäwatqaŋguwäŋga, iquaqu quvämaqä iquauŋqä aŋgumä äwiyi, kukŋuä hiqäva-imäkqä naqä iquatä, Israitqä iquau miqä iquatä, kukŋuä ätukuwiŋqä awä ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","I tquaŋginyä äwipiyi, äwqä naqä-hŋqunä imbu, Goti Hanjuwä Iquenyqä tääqä tiiŋä ätukuwi. “Naqä Iquki, Si qäukuitä, quaetä, eqä-huäŋitä, itaŋga nätmatqä eeqänäŋä iu äwiŋqä-pqe, imäkkŋiqä. ");
INSERT INTO mcr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hiŋuiqänäŋi, Si Dŋä Äŋguä Ique tquaŋgnä, Iqu neqä awiqu Dewiti, Saqä wäuŋuä-kiyqä ique tquaŋgi, iqu tuwaŋuä tii ätätä äqäkqe. ‘Qokä-apäki, qua eeqänäŋä iuŋi, äwqä tnäŋä suŋqä imäkqäuä? Huiwä huitaŋä-huitaŋä änyäŋuwä iqua, suqä quvqä imäkpŋqä, kukŋuä hiŋginäwa suŋqä tqäuä? ");
INSERT INTO mcr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ämaqä aŋä-himqä eeqänäŋä iu miqä iquatä, quwqä ämaqä naqä huiziquatä, mäkäŋqä näwe imäkmbu, Goti Naqä Iquesä, Kraisi ämaqeu mitŋqä ätekqä iquesä, mändi äkittqäpŋqä, aquvä äqäŋgäuä’ äqänänä. ");
INSERT INTO mcr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tiiŋi, naqä-qakuiqä. Jisasi, Tqä Wäuŋuä-kiyqä Ique, äkittqiyepŋqä diŋqe, Heroti iqutä, Pondisi Pailoti iqutä, Israitqä iquatä, ämaqä Israitqä qäyä hitaŋgi huizi iquatä, aŋä-himqä täu aquvä äqäŋguwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Qu iiŋä imäkkuwi, Si Tqä yäŋänäqŋqä dutatänä, Tqä äkiŋqä dutatänä, hiŋuiqänä ätkŋä-pa, qänaknä ipu imäkkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naqä Iqukiyä, qu kukŋuä zä inemäkpŋqä änatquwiŋqä kŋuä indqänyä! Itaŋga Tqä wäuŋuä-kiyqä iqu-ne, Tqä kukŋui awä qäyunä tuatuŋquä diŋqe, yäŋänäqŋqä inemäkiyä. ");
INSERT INTO mcr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iyää, Si ämaqä täŋä-yaqä iquau, a äwqätätnä, äŋguä iwimäkiyä. Jisasi, Tqä wäuŋuä-kiyqä Iqueqä yoqeta, ämaqä mimäkqänäŋä huitaŋä-huitaŋi, imäkiyä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Qu tääqä qäpu tquaŋguwäŋga, aŋä qu äpmamiŋuwä iqu, yäuŋuä-yäuŋuä qe ikqe. Iŋgaŋi qu eeqänäŋi, Dŋä Äŋguä Iqu kuapänä muŋgaŋgi, zä miqä ipu, Goti Hanjuwä Iqueqä kukŋui, awä yäŋänäqŋqä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Qokä-apäkä Jisasi Iquenyqä quuvqä eqäkuwä iqua, qu qeqä-quuvqä naqä-hŋqunä imbu äpmamiŋuwi. Qu nätmatqä eeqänäŋä iiŋqe, “Ŋqänänjqä” matqä ipu, eeqänäŋi quvaqä awä iqi äwämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Itaŋga ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, yäŋänäqŋqä-täŋä epu, Naqä Jisasi Iqu äpäkonätä, aŋgu ävaukqeŋqä, kukŋuä awä ätumiŋuwi. Iiŋi Goti Hanjuwä Iqu iquauŋqä äwinyätä, äŋguä iwimäkmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ii tiinji. Ämaqä qua-täŋä, aŋä-täŋä iquatä, ämaqä mbqä ipŋqä imäkäpu, iuta mbqä ämepu, ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau äwimiŋuwi. Iqua iwäsäupu, ämaqä äwa iqaŋguwä iquau vätqätaŋguwä iutaŋi, quvaqä awä iqisaŋä hŋqu, nätmatqäŋqä äwa miqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iŋgaŋi ämaqä hŋqu äpmamiŋqe, iqueqä yoqe Josepä ique. Iqu hueqä-himqä Lipai iutaŋä-qu etaŋgi, känai, Saplusi, qua eqä-pŋä awä iqi äwiŋqä iu ämikqe. Itaŋga ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, Josepä iqueqä yoqä huizi, “Banäpasiuä” änyuätmiŋuwi. Ii tiinji. “Ämaqeu yäŋänäqŋqä iwimäkqä iqueqä.” ");
INSERT INTO mcr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Iqu iqueqä qua hui, ämaqä mbqä ipŋqä imäkätä, iuta mbqä ämetä, äma äpätä, kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau äwikqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ämaqä hŋqutä, iqueqä apäkisä äpmamiŋiyi. Iyaquiyqä yoqe, Anänasi iqutä, Sapiraisänji. Iqu iqueqä qua hui, ämaqä mbqä ipŋqä imäkätä, mbqä ämakqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iyaquiyqä äwiŋqä iutaŋi, iqu mbqä iiŋi, hui kiqä-kiuäŋqä pŋqä etä, itaŋga hui äma äpätä, ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau äwikqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iqu iiŋä imäkqaŋga, Pitä iqu tii ätukqe. “Anänasi iquki, iiŋi änääŋqäwä? Setänä, Goti Hanjuwä Iqutä mäkä-huŋqä iqu ikimäkqaŋgi, tqä quaeŋqä mbqä ämeŋi, hui zä etnä, Dŋä Äŋguä Iqueŋi suŋqä quaŋgä ätunyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","“Si quae mbqäŋqä mimäkqäŋgaŋi, ii tqänäŋä eäŋqeqä. Itaŋga mbqäŋqä imäkätnä mbqä ämeŋäŋgaŋi, mbqe tqä-täuä ämitqäŋä-qae, tqä äkiŋqä iunä imäktnä. Si kŋuä quvqä indqänäŋi, äänä etaŋgiyi? Iŋi si suqä quaŋgi, ämaqä iqune minetqueqä inyä, Goti Hanjuwä Ique itquenyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iŋgaŋi Anänasi iqu kukŋuä ii qätä äwiyäqe, qua iqi äpäknäqe, pizqä qe äpäkoŋgqe. Itaŋga ämaqä nätmatqä tä timäuqaŋgqeŋqä qätä äwipiyä iqua, qu eeqänäŋä zä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Hikŋä iqua pämä ätqäumä äppiyi, iqueqä huiwi yuä huäqä äutäpu, yäpaqä mäŋgisa äma äwäpu, qua äptekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hmbu ti äpmapiyi, Anänasi iqueqä apäki nätmatqä iiŋi timäuqaŋgqeŋqä maqŋqä eä, aŋä yäpä iŋgisa qe äpekqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ii äpeyqaŋga, Pitä iqu yatŋqä tiiŋä äwikqe. “Si diyä. Qeeqä quaeŋqä mbqä ämeqiyi, tä qesanä?” Ii kimaŋi, “Auqä! Ii qeyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ii e tquaŋga, Pitä iqu tii ätukqe. “Qe kŋuä naqä-hŋqunä indqänäsinyä, Dŋä Äŋguä Iqueŋi suŋqä yamwiqä vqinyqä?” E ätuäqetaŋi, “Qätä nyiyä! Ämaqä tqä qokique qua äptequwä iqua äpäpu, aŋä hänaqä iqi äyä ätqäuŋäuä. Iqua si-pqe inä äkma upuŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","I tquaŋganä, ii Pitä iqueqä yukä-täŋä iqi äpäknäqe, pizqä qe äpäkoŋgqe. Hikŋä iqua äppiyi, pizqä witaŋgi äqumbiyi, yäpaqä mäŋgisa äma äwäpu, qokique äptepiyä iqi, äptekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iŋgaŋi qokä-apäkä quuvqä heqiyqä iquatä, ämaqä suqä e timäuqaŋgqeŋqä qätä äwipiyä iquatä, zä kiiŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ämaqä Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, wäuŋuä ämaqä mimäkqänäŋä huitaŋä-huitaŋä, qokä-apäkä iuqä awä iqi imäkmiŋuwi. Ämaqä quuvqä eqäkuwä iqua, äwqä naqä-hŋqunä änyäpu, Solomonä iqueqä aŋä mätävätiŋä iqi, aquvä äqänäqismiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ämaqä huizi, qutä aquvä anä maqŋqä ipiyä iqua, quwqä yoqe haqeqä ävauqumuatäpiyä-qe, zä wiŋgaŋgi, anä mäpmeqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iŋi qokä-apäkä kuapänäŋi, Naqä Iquenyqä quuvqä eqiyäpu, Iqueqä ämaqä iquau äwimepu anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iiŋä timäuqaŋgqeŋqä, qu ämaqä täŋä-yaqä iquauŋi, iquauqä aŋiuta, yquvaŋiu yäpaqäŋgisa äma äpäpu, hänaqä iqi äwätemiŋuwi. Ii imiŋuwi, ii Pitä iqu ämäwqätäutäqäŋgaŋi, iqueqä ktqe, ämaqä yaqä iquau ktqä ämuämä mäwqätäuqaŋguti, äŋguä imämbŋqä diŋqeyi. ");
INSERT INTO mcr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ämaqä aŋä-himqä Jerusälemä-täŋä qäqiqi pmeqe, qu-pqe aquvä äqänäpu, ämaqä täŋä-yaqä-täŋä iquautä, dŋä quvqä-täŋä iquautä ätuma äpmiŋuwi. Iŋgaŋi ämaqä iiŋä eeqänäŋä iqua, äŋguä imäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hiqäva-imäkqä naqä iqutänä, iqutä näueqä imäknmiŋuwä iquatänä, äwqä quvqä äwiŋgqe. Iqua Satyusitaŋä iquayi. ");
INSERT INTO mcr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Iqua äwqä quvqä wiŋgaŋga, ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iquauŋi, ämaqeuqä hiŋuä iqi a äkiqätäpu, guä äpmuatekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Heatqä iqueŋi, Naqä Iqueqä eŋätqä hŋqu äpäqe, guä pmuateqä aŋiuŋi qŋqaŋä äwuteyäqe, iquauŋi yäpaqäŋgisa ätuma äpätä, tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“He äwäpu, hiqäva-imäkqä aŋä ququawä iu ätqäupu, qokä-apäkä iuŋi häŋä-pmeqä änyä-häŋiŋqä awä eeqäpnä tupiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iqua qätä e äwipiyi, ziŋuä matqäŋga, hiqäva-imäkqä aŋä duŋqä äupiyi, ämaqeu näqŋqä wipŋqä ipäqäkuwi. Iŋgaŋi hiqäva-imäkqä naqä iqutä, iqueqä näueqä iquatä, aquvä äqämbiyi, Israitqä iquau miqä naqä eeqänäŋä iquau, tääqä qe ätuätumakuwi. Aquvä äqämbiyi, ämayukä-imaŋqä hui, kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau ätuma ppŋqä, guä pmeqä aŋä duŋqä qe ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Iqi ätimäupiyi, ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, mäpmetaŋgä äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","E äqumbiyi, aŋgu äupiyi, “Ne aŋä qŋqaŋi, yäŋänäqŋqä yqänä hinätaŋgi äqunäŋunä” ätukuwi. “Itaŋga ämaqä guä pmuateqä aŋä iu miqä iqua, aŋä qŋqaŋä eeqänäŋä iuŋi, hiŋuä äqumbu tqäutaŋgä äqunäŋunä. Iŋäqe ne qŋqaŋä äutäuquque, ämaqä aŋä yäpä yäŋgisaŋi mäpmetaŋgä äqunäŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hiqäva-imäkqä aŋiutaŋä ämayukä-imaŋqä iquauqä naqä iqutä, hiqäva-imäkqä naqä iquatänä, kukŋuä ii qätä äwipiyi, qu kŋuä kuapänä indqänäpu, “Squä timäutŋqäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iŋgaŋi ämaqä hŋqu äwimeqe, tii ätukqe. “He qätä nyipiyä! Ämaqä he guä äpmuatequwä iqua, täŋgaŋi qu hiqäva-imäkqä aŋä ququawä iu ätqäupu, qokä-apäkä iu näqŋqä ävätqäŋäuä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","I tquaŋga, ämayukä-imaŋqä iquauqä naqä iqutä, iqueqä ämaqä iquatä äwäpu, ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iquauŋi, qeiqinyä ätuma äpkuwi. Qokä-apäkä iqua hikä ämepu, pizqä puäsqä diŋqä zä wiŋgaŋgi, iqua iquauŋi, quvqä hui miwimäkqä da, qanyä ätuma äpkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iquau ätuma äppiyi, Israitqä iquau miqä naqä eeqänäŋä iquauä hiŋuä iqi äkitqätekuwi. Itaŋi hiqäva-imäkqä naqä iqu, iquau tiiŋä qe ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“He ämaqeuŋi, Ämaqä iiŋä Iqueqä yoqe ätuäpu, näqŋqä mävqä ipŋqe, ne pmua emäkqueqä. Iŋäqe he näqŋqä yqänä vätqätaŋgä, ämaqä Jerusälemä pmeqä eeqänäŋi, heyaqä kukŋui qätä ae eyquwiqä. Ne Ämaqä Ique pizqä äpäkkqueŋqe, he quaŋgä hiŋgi änanyuätquwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Iqu iiŋä tquaŋga, Pitä iqutä, ämaqä Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä huizi iquatä, kukŋuä kimaŋi, tiiŋä ätukuwi. “Goti Hanjuwä Iqueqä kukŋuitä, ämaqeuqä kukŋuitä, asänäŋä maeqä eqaŋgaŋi, iŋi ne Goti Iqueqenä qänaknä yaŋqunä. ");
INSERT INTO mcr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","He Jisasi Iqueŋi, zä-huätatä äuepu, pizqä päsqaŋguwäŋga, atqä-awäkauqä Goti Hanjuwä Iqu, Ique aŋgumä äyä ävauqumuatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Iqueŋi, Goti Hanjuwä Iqu ätuma äyätä, Iqueqä hipa ämuaŋgisa, äyä äpmuatekqeqä. Iŋi Iqu neyaqä hänaqä Ämänätqueqä-qu eä, aŋgumä Inätmeqä-qu eä, äpmakqeqä. Ga e äpmeqetaŋi, Israitqä iqune, neqä kŋui äkunmäknatuŋquä yätamäkqä äneyätä, neqä suqä quvqä huätä mänatnämäuquätŋqä diŋqeyi. ");
INSERT INTO mcr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ne nätmatqä iiŋä timäuqaŋgi äqunani, awä ätätuŋqueqä. Itaŋga Dŋä Äŋguä Iqu-pqe awä inä ätätqänä. Dŋä Äŋguä Iqueŋi, Goti Hanjuwä Iqu, qokä-apäkä qätä äwiyäpu, qänaknä itqäŋuwä iquauŋi, ae ävqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ämaqä miqä iqua kukŋuä tä qätä äwipiyi, quwqä äwqe tnäŋä wiŋgaŋgi, iquauŋi pizqä päkpŋqä äwiŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iiŋä ipiyitaŋi, ämaqä miqä hŋqu pämä ätqäukqe. Iqueqä yoqe, Gämeliyoli ique. Iqu Parisi iutaŋä-qu eä, ämaqeu kukŋuä-suqeŋqä ämotqueqä ique. Iqueqä yoqe, qokä-apäki ävauqumuatmiŋuwi. Iqu pämä ätqäuqe, “Ämaqä tquauŋi, yäpaqä mäŋgisa wäŋqäpu pmapŋqä ätuma upiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Qu yäpaqä mäŋgisa ae äwqaŋguwäŋga, Gämeliyoli iqu, ämaqä miqä huiziquau tii ätukqe. “Israitqä iquenyä, he ämaqä iiŋä iquau quvqä iwimäkpŋqä eŋgaŋgutqe, kŋuä äŋguänä ganä indqämbiyä. ");
INSERT INTO mcr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Quväukuä kuapänä mäpäwqäŋga, Teutasi iqu ätimäuqe, ‘Nyi ämaqä naqä, yoqä-täŋunjqä’ tquaŋga, ämaqä 400, iquenyqä qänaknä ikuwiqä. Qua miqä iqua, ique pizqä äpäsäpu, ga iquenyqä qänaknä imiŋuwä iquauŋi, äpäsändqiyäwqatqaŋguwäŋga, iquauqä wäuŋui qui imäkŋgqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iiŋä ätimäukqeuŋi, gapmanqä iqua ämaqeuqä yoqä meqaŋguwäŋgaŋi, Jutasi Galilisaŋä iqu ätimäuqe, ämaqä hŋqua qua miqä iquatä mäkä humbŋqä äwqä äwivauqumuatkqe. Iqueŋä-pqe, qu pizqä äpäsäpu, ga iquenyqä qänaknä imiŋuwä iquauŋi, äpäsändqiyäwqatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Täŋgaŋi nyi he etqänä. He ämaqä tquauŋi, nätmatqä hui miwimäkqä ipu, hiŋuinä qumbiyä. Ii tiinjqä. Ne maqŋqe. Wäuŋuä tä, iquauqä kŋuä indqäŋqä duta timäuquti, ä Goti Hanjuwä Iqueqä duta timäuqutiyä? Qu quwqä kŋuä indqäŋqä duta imäkqaŋgpqe, qui imäknäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Iiŋä etaŋgi, Goti Hanjuwä Iqu Iqueqä-kiuä imäkqaŋgutqe, he a änä makiqätqä ipŋqäuä. Iiŋi, he Goti Hanjuwä Iqutä mäkä-huŋqä eŋqä-paŋä epŋqäuä” ätukqe. Iŋgaŋi, naqä iqua, Gämeliyoli iqueä maŋi qänaknä ipu, tiiŋä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Qu ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iquau tääqä ätuätumapiyi, ämaqä hŋqua, iquau jävqä päkpŋqä ätukuwi. E imäkpiyitaŋi, qu iquauŋi, Jisasi Iqueä yoqe aŋgu matqä ipŋqä pmua imäkäpu, hiŋuinä äqunäwatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iŋgaŋi ämaqä Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, ämaqä miqä iquau ävämaŋi, aquvänä ipu yäpaqä mäŋgisa äpäukuwi. Goti Hanjuwä Iqu, iqua Jisasi Iqueqä yoqä duta womba mapŋqä, hiŋuinä äquŋgqeŋqä aquvänä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Itaŋi hiunji ique-ique, qu hiqäva-imäkqä aŋiutä, ämaqä hŋquauqä aŋiutä, näqŋqä äväkämiŋuwi. Qu mävquatämäuqä ipu, kukŋuä äŋguä we-huŋqä-täŋi, awä tiiŋä ätumiŋuwi. “Kraisi ne mineyätŋqä Goti Hanjuwä Iqu ätekqä Iqu, Jisasi Iqu Qäqueqä.” ");
INSERT INTO mcr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Iŋgaŋi ämaqä Jisasi Iquenyqä quuvqä heqiyqä iqua, kuapänä timäutqätaŋguwäŋgaŋi, ämaqä kiŋä nämdaŋä, Grikä iquauqä aŋä-kukŋuä tqä iqua, ämaqä Israitqä iquauqä aŋä-kukŋuä tqä iquau, äkasuwä tiiŋä ätukuwi. “Hiunji ique-iqueŋi, he qokä-apäkä buayäŋqä äwa iqaŋguwä iquau, yätamäkqä äväpiyäŋgaŋi, nesaŋä apäqŋqä iuauŋi, mävqä itqäŋäuä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iŋgaŋi ämaqä, Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, quuvqä heqiyqä eeqänäŋä iquau tääqä ätuätumapiyi, tiiŋä ätukuwi. “Ne Goti Hanjuwä Iqueqä kukŋui, hiŋuinä äqunätanä buayinä iwäsäumitatque, ii äŋguä hmanjqä. ");
INSERT INTO mcr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Iŋi, tatqä-guäka iquenä, hiyaqä awä iqiŋi ämaqä suqä äŋguänäŋä iqä 7 iquau atäuŋuä ipiyä! Qu yoqä äŋguänä äqombu, Dŋä Äŋguä Iqu iquau kuapänä munätaŋgi epu, ä näqŋqä äŋguä kuapä-täŋä iquauŋi, atäuŋuä ipiyä. Iŋi ämaqä iqua, buayä iwäsäuqäpŋqäuä. ");
INSERT INTO mcr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iŋäqe ne neqä-neuäŋi, hea ique-ique Goti Hanjuwä Iquenyqä tääqä ätuätanä, qokä-apäkä iquau, Iqueqä kukŋui awä tquauŋqunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Qu e tquaŋguwiŋqe, qokä-apäkä eeqänäŋi kiiŋä qe äwiŋgqe. Iŋi qu Stipenä iqu, quuvqä heqiyqä yäŋänäqŋqä-täŋä-qu eä, Dŋä Äŋguä Iqu kuapänä ämunätaŋgqä ique, atäuŋuä ikuwi. Iqutäŋi, qu Pilipä ique, Plokolusi ique, Nikanolä ique, Timonä ique, Pamnasi ique, Nikolasi ique, iquau atäuŋuä ikuwi. Nikolasi iqu Andiyokätaŋä eä, Israitqä iquautaŋä hma etaŋgqä-qe, Goti Hanjuwä Ique qänaknä iqä-qu qäŋganä ätimäukqe. ");
INSERT INTO mcr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Qu iquau atäuŋuä ipiyi, kukŋuä awä tuäkiqäpŋqä ändowatkqä iquauqä hiŋuä iqi ätqätekuwi. Iŋgaŋi ämaqä kukŋuä awä tuäkiqäpŋqä ändowatkqä iqua, qu wäuŋuä tä imäkpŋqä ätepu, hipa haqeqi äwiyäpu, Naqä Iquenyqä tääqä ätkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iŋgaŋi Goti Hanjuwä Iqueuä kukŋui, im-imä äukqe. Itaŋi Jerusälemä iuŋi, qokä-apäkä quuvqä heqiyqä iqua, kuapänä ätimäukuwi. Hiqäva-imäkqä iquautaŋä kuapänäŋä-pqe, quuvqä eqiyäpu, Goti Hanjuwä Iqueqä kukŋuiŋqä qänaknä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Goti Hanjuwä Iqu Stipenä iqueŋi, äŋguä iwimäkätä yäŋänäqŋqä vqaŋgi, iqu wäuŋuä ämaqä mimäkqänäŋä huitaŋä-huitaŋä di, qokä-apäkä awä iqisa imäkmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iŋgaŋi ämaqä hŋqua, Stipenä iqutäŋi, kukŋuä mäkä eŋqä-pa äunmiŋuwi. Ämaqä iiŋi, Israitqä iquauqä aŋä aquväqŋqä hŋquesaŋä iquae. Aŋä iqueŋqe, “ämaqä qäŋganä wäuŋuä hiŋginä äwimiŋuwä iquauqä aŋä aquväqŋqeqä” ätmiŋuwi. Aŋä iqueŋi, ämaqä aŋä-himqä Sairinisaŋä iquatä, aŋä-himqä Aleksandiyataŋä iquatä, itaŋga qua naqä Silisiyataŋä iquatä, qua naqä Eesiyataŋä iquatä äpaqumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kukŋuä mäkä i huŋgaŋguwä-qe, Stipenä iqueŋi Dŋä Äŋguä Iqu näqŋqä äŋguänäŋi vqaŋgi, qu iqueuä kukŋui mändi makittqiyqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Iŋgaŋi iqua, ämaqä hŋquau-mända kukŋuä zä tquaŋgä, iqua kukŋuä quaŋgi, “Ne Stipenä iqu, Mosisi iquenyqätä, Goti Hanjuwä Iquenyqätä, kukŋuä quvqä tätqätaŋgi äwiyäŋunä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iŋgaŋi ämaqä, Stipenä iqutä äkasuwä ätŋguwä iqua, qu ämaqeuqätä, ämaqä naqä iquauqätä, kukŋuä-suqeŋqä näqŋqä iquauqätä, äwqe, äwivauqumuatkuwi. Iŋi qu äupiyi, Stipenä ique a äkiqätäpu, ämaqä miqä naqä eeqänäŋä iquauŋqä ätuma äukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Iqi ätimäupiyi, qu ämaqä quaŋgä-tqä hui ätuma pqaŋguwäŋga, qu Stipenä iquenyqä tiiŋä ätukuwi. “Ämaqä tqu, tiiŋä tqaŋgi äwiyäŋunä. ‘Ämaqä Jisasi Nasäretqätaŋä Iqu, aŋä tqueŋi qui imäkätä, suqä Mosisi iqu hiŋuiqänä änätapkqeuŋi, hui-mända iwäsäuniqeqä.’ Iqu iiŋä ätqa äpätŋqe, hiqäva-imäkqä aŋiuŋqätä, neqä kukŋuä-suqeŋqätä, kukŋuä quvqä ätätŋqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","I tqaŋguwäŋga, ämaqä iqi äpmapiyä iqua, qu eeqänäŋi, Stipenä ique hiŋuä yäŋänäqŋqä äqunäpiyi, iqueqä hipeŋuä iuŋi, eŋätqä hŋqueqä hipeŋuä eŋqä-pa äquŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Iŋgaŋi hiqäva-imäkqä naqä iqu, Stipenä ique yatŋqä tii äwikqe. “Ii naqä-qakuätanä, quaŋgätanä?” ");
INSERT INTO mcr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Iqu e tquaŋga, Stipenä iqu, “Tatqä-guäkendä apiqukuendä, qätä nyipiyä” ätukqe. “Neyaqä awiqu Aprähamä iqu, aŋä-himqä Harenä iuŋqä mäwqä, qua Mesäpotemiya iu yqänä pmetaŋga, Goti We-huŋqä Kuapä-täŋä Iqu, ique äwimetä, ‘Si tqä qua täutä, tqä näueqä täutä ävämetnä, qua Nyi ämäktquamqä duŋqä uvä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iŋgaŋi Aprähamä iqu, Kaländiya iquauqä qua iu ävämaŋi, iqu äwätä aŋä-himqä Harenä iu äpmakqeqä. Iqisaŋi, iqueqä kaniqu äpäkoŋgaŋga, Goti Hanjuwä Iqu ique qua he äpmeŋuwä täuŋqä ändowatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Iqu täqi timäuqaŋga, qua näweqä metŋqe, Goti Hanjuwä Iqu qua hui mävqä itä, ‘Qänakndaŋi Nyi qua tä tqätä, tqä taqä-tawäkauqätä hetapmniŋqeqä,’ ätukqeqä. Goti Hanjuwä Iqu, Aprähamä iqu ymeqä maeqä pmetaŋga, kukŋuä iiŋi, iŋga ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Itaŋga iqueŋi, tiiŋä-pqä inä ätukqeqä. ‘Tqä taqä-tawäka epqä iqua, qu äwäpu, qua ämaqä hŋquauä-täŋä iqi pmapnuwiqä. Ämaqä iqiŋä iqua, iquauŋi, quwqä wäuŋuä-wiyqä hiŋgiŋqä-qua pmapŋqä iwimäkäpu, quvqä itqueqäpnuwiqä. Inyänä wimetqätaŋguti, quväukuä 400 e pmetpnuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Qänakndaŋi ämaqä suqä quvqä e itquamipqä iquauŋi, Nyi haŋä-iqä wimniqeqä. Iŋgaŋi tqä taqä-tawäka iqua, qua iuŋi ävämapiyi, täqinyqä äpäpu, Nyaqä yoqe, haqeqä ämamäupu, pmapnuwiqä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Iiŋä ätuäqetaŋi, tiiŋä ätukqeqä. ‘Nyi kukŋuä ätätmä eqäqä tä, i witäniŋqä, Nyi si suqä huiwä häuä ktäuqe ktapmqänä.’ Aprähamä iqu näqŋqä iiŋä ämeqe, apäki Aisakä ique ämikqeuŋi, hiunji 8 päwqaŋga, ymeqä iqueqä huiwi häuä äktäukqeqä. Iŋi Aisakä iqu, Jekopä iqueŋi asänä imäkkqeqä. Itaŋi Jekopä iqu neyaqä awäka 12 iquauŋi, asänä imäkkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Jekopä iqueqä ymeqä iqua, qu käŋgua Josepä iquenyqä wiuŋqä ipu, ique, ämaqä huiziquau, mbqä mapŋqä vqaŋguwäŋga, iqu Isipä iuŋi, wäuŋuä-wiyqä hiŋgiŋqä-qu äpmamiŋqeqä. Iŋgaŋi Goti Hanjuwä Iqu, iqutä anä äpme, haŋä-iqä eeqänäŋi huätä ämätnämäutä, yätamäkqä äwimiŋqeqä. Iqu ique näqŋqä äŋguänäŋi vqaŋgi, ämiqä naqä Isipä iutaŋä iqu, iquenyqä wiŋgaŋgi, ique atäuŋuä äwikqeqä. Iqu Isipä iu ämaqä naqä äpmetä, ämiqä naqä iqueqä nätmatqä eeqänäŋä aŋä iuŋä-pqe, ämimiŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Qänakndaŋi qua eeqänäŋä Isipä iuŋitä, Kenanä-pqä iuŋitä, buayä dä naqänäŋä timäuqaŋgi, ämaqä-pqe haŋä-iqä naqä meqaŋguwäŋga, neyaqä atqä-awäka-pqe, buayä mämoqumueqä imiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iŋgaŋi Jekopä iqu, ‘Kuä-witqä Isipä du äwinä’ tqaŋgä äwiyäqe, iqu neyaqä awäkauŋi, Isipä iuŋqe kiŋganäŋi ändowatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Qu aŋguŋi Isipä iuŋqä uwqaŋguwäŋgaŋi, Josepä iqu qutaqauŋi, ‘Nyi Josepä iqunjqä’ ätukqeqä. Ämaqä miqä naqä iqu, Josepä iqueqä kanmqätä, kutaqä-käŋguäkauŋqätäŋi, iŋganä näqŋqä ekqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iŋgaŋi Josepä iqu, kaniquenyqä kukŋuä ändowatätä, iqu iqueqä ämaqä iquatä, Isipä iu anä pmapŋqä itumakqe. Qokä-apäkä eeqänäŋi, 75 äwokuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Iŋgaŋi Jekopä iqu, Isipäŋqä e äquveqäkqe, qänakndaŋi äpäkoŋgqeqä. Itaŋga neyaqä awiqukua-pqe, inä äpäkoŋguwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iquauqä huiwi, aŋä-himqä Sekemäŋqä aŋgu äma äpäpu, qua äptekuwiqä. Ämaqä qua ptŋqä Sekemä iuŋi, hiŋuiqänäŋi Aprähamä iqu, Hamo iqueqä ymeqä iquau mbqä ikqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nätmatqä tä, Goti Hanjuwä Iqu, Aprähamä ique qäŋgiŋga ätukqä-pa timäutŋqä itqätaŋga, Isipä iuŋi, ämaqä Israitqä iqua kuapänä eqiyämaŋguwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iŋgaŋi, ämiqä naqä, Josepä iquenyqä maqŋqä hŋqu, Isipä iu äpmakqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Iqu neyaqä atqä-awäkau quaŋgä eŋqä-paŋä imäkätä, suqä quvqä itquetä, yäŋänäqŋqä tquaŋgi, iqua ymeqä däŋä iquauŋi, yäpaqä mäŋgisa äpäkombŋqä ämatnämäumiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hea iŋgaŋi, Mosisi iqueqä känai, ique ämikqeqä. Goti Hanjuwä Iqu, ‘ymeqä tqu äŋguiqä’ kŋuä äwikqeqä. Qu iqueŋi, qaŋuä hŋquaqui-hŋque päwqaŋgaŋqä, kaniqueqä aŋä iuŋi, äŋguänäŋä ämimiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Qänakŋi, qu yäpaqäŋgisa matnämäuqaŋguwäŋga, ämiqä naqä iqueqä meqi ämetä, iqueŋi iiyqä ymeqä eŋqä-pa ämimiŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Isipä pmeqä iqua, iquauä näqŋqä eeqänäŋi ique ämotqueqaŋguwäŋga, iqu naqä-qu eätä, kukŋuä äŋguänäŋä tqä-qu eätä, wäuŋuä yäŋänäqŋqä imäkqä-qu ekqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Iqueqä quväukui 40 ae äpäwqaŋgaŋi, iqu, iqueqä käyämaqä Israitqä iquauŋqä kŋuä indqänätä, hiŋuä qunätŋqä äukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Iqu äwäqe, ämaqä Isipätaŋä hŋqu, Israitqä hŋque quvqä itquetqätaŋgi äqunäqe, Israitqä ique yätamäkqä ävätä, Isipä pmeqä ique quvqä kima ävätä, pizqä äpäkkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Iqu e imäkätäqäŋgaŋi, kŋuä tiiŋä äwimiŋqeqä. ‘Israitqä iqua nyinyqe, näqŋqä tiiŋä mapŋqäuä. “Goti Hanjuwä Iqu Mosisi iquesa, ne änewewqatäŋqiyä.”’ Iŋäqe qu iiŋqe, maqŋqä emiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Hiunji awiŋgaŋi, iqu Israitqä hŋquaqu mäkä hunätqätaŋginyä äqunäqe, iquaqu äwqä naqä-hŋqunä nyiyŋqä itamäkätŋqä äwinyätä, ‘Äi, suŋqä mäkä hunätqäŋinyqä? Qeŋgueŋgiyqä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","I tquaŋga, huizique quvqä itquamiŋqä iqu, Mosisi ique ävqutäwqatätä, ‘Si, ne ämineyätnä, jänä inemäktŋqeŋqe, tqu äktqäwä? ");
INSERT INTO mcr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Huäqiŋi si ämaqä Isipä pmeqä ique äpäkŋä-pa, täŋgaŋi nyi-pqe pizqä bäktŋqätanä?’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ii tquaŋgqeŋqe, Mosisi iqu Isipä äväma, qua Mitiyanäŋqä zä äwäqe, qua huitaŋä-qu eä, iqi äpmamiŋqeqä. Iqu iqi äpme, ymeqä qokä hŋquaqu eämakqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Iŋgaŋi quväukuä 40 ae äpäwqaŋga, eŋätqä hŋqu, Mosisi ique wimetŋqä äquvepätä, aŋä avqŋqä imä, qoqoŋä Sänai iuŋi, zä wäŋqä hmbiyqä äpa iuta, tä hänaqä sätqätaŋgqä yäpä iŋgisa äpmakqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosisi iqu hiŋuä iiŋä äqunäqe, kŋuä kuapänä indqäŋgqeqä. Iqu hiŋuä äŋguänä qunmätä qäqiqi päwqaŋga, Goti Hanjuwä Naqä Iqu, iqueŋi tiiŋä ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nyi tqä tawäka, Aprähamä iqueqä, Aisakä iqueqä, ä Jekopä iqueqä, Goti Hanjuwä Iqunjqä.’ I tquaŋga, Mosisi iqu yäuŋuä-yäuŋuä itä, hiŋuä quŋqäŋqe zä äwiŋgqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Iqu i imäkqaŋga, Naqä Iqu tii ätukqeqä. ‘Qua si pämä ätqäuŋiŋi, ii Ŋqeqä. Iiŋiŋqe, si tqä yukä ämuasmäŋi huätä hiquveyä. ");
INSERT INTO mcr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nyaqä ämaqä iqua, Isipä iuŋi, haŋä-iqä ämepu tääqä dqaŋguwi, Nyi hiŋuä äqunätmä, qätä ae äwiyäŋänä. Iiŋä etaŋgi, Nyi, Isipä pmeqä iquauqä hipa iuta, aŋgu itmamqä äpqänä. Täŋgaŋi si Isipäŋqä aŋgu utŋqä äkndowatqänä,’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mosisi iqueŋi, Israitqä iqua kiŋganäŋi hŋgisanä itquepu, ‘Si ne ämineyätnä jänä inemäktŋqeŋqe, tqu äktqäwä?’ ätukuwä-qeŋä-qe, Goti Hanjuwä Iqu iqueŋi, iquau ämitä, aŋgumä ätuma päniŋqä ändowatkqeqä. Eŋätqä, zä wäŋqä iu ätqäukqä iqu, Mosisi iqu wäuŋuä imäkätŋqä yätamäkqä vquätŋqä, Iqu ändowatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Isipä iutä, eqä-pŋä häŋesqä iutä, aŋä avqŋqä iutä, Mosisi iqu wäuŋuä huitaŋä-huitaŋä ämaqä mimäkqänäŋä di imäkätä, ämaqä iquau ämitimäukqeqä. Aŋä avqŋqä iuŋi, qu quväukuä 40 äpmamiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ämaqä iiŋä iqunä, Israitqä iquau tii ätukqe. ‘Ämaqä hiŋuä-tqä nyi eŋqä-paŋä-qu hiätŋqeŋqe, Goti Hanjuwä Iqu, hiqä hita-hiŋgua hŋque, atäuŋuä väniqeqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Itaŋga neyaqä atqä-awäkiqua, aŋä avqŋqä iuŋi, aquvä äqämbu pmetaŋguwäŋgaŋi, Mosisi iiŋä iqunä iquatä anä äpmamiŋuwiqä. Ga qoqoŋä Sänai yätuŋi, iqutä, eŋätqä hŋqutä, kukŋuä ätkiyiqä. Goti Hanjuwä Iqueuä kukŋuä häŋä-pmeqä-täŋi ämakqe, ne awä änatqa pqäpnuwäŋqä ämakqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","Iqueŋi neyaqä awäkiqua, qätä wiyqäŋqä mäwiŋqä itä, hŋgisanä itquepu, Isipä iuŋqä aŋgu upŋqä kiiŋä äwinyätä, Aronä ique tiiŋä ätukuwiqä. ‘Ne maqŋqeqä. Mosisi, ne Isipä du inetmakqä iqueŋi, squä wimequtiyä? Iŋi hiŋuiqä nemepu, hänaqä duta näquatäupŋqä, si, nenyqä goti hŋqua imäkiyä’ ätukuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iŋgaŋi qu golqä hui ämepu, goti quaŋgä bulumäka meqä eŋqä-paŋä hŋque imäkäpu, iquenyqä hiqäva äqiyäpiyitaŋi, goti iquauqä hipaetä imäkkuwiŋqä aquvänä imiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iiŋiŋqe Goti Hanjuwä Iqu, iqua mäptqä iquenyqätä, qaŋuä iquenyqätä, qätäqueqä iquauŋqätä, aquvänä ipu, qoŋä qäyä woktäpŋqänä tuwä äwiyätä, hiŋuinä äquŋgqeqä. Ii ätimäukqeŋqe, hiŋuä-tqä iquauqä bukä iuŋi, Goti Hanjuwä Iqueqä kukŋui tiiŋä äqänänä. ‘Israitqä iquenä, he aŋä avqŋqä du, quväukuä 40 äpmapiyäŋgaŋi, he bulumäka, sipsipqä, meme, tä ikepu, hiqäva äqämiŋuwi, Nyinyqä äyä äqämiŋuwätanä? Ii oeyqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","He goti quaŋgä iquaquinyqä qoŋä woktäupŋqe, Molekä iquenyqä namnä aŋä ämätäpu, Repanä iquenyqä qätäqueqä eŋqä-paŋä ktqä imäkkuwiqä. Nätmatqä iquaquiŋi, he qäsä äma ikämiŋuwiqä. Iiŋä iqaŋguwiŋqe, Nyi Bapilonä-täŋä iŋgisaŋqä huätä hendowatmniqeqä,’ äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Neqä awäkiqua, qu aŋä avqŋqä iu äpmapiyäŋgaŋi, Goti Hanjuwä Iqueqä namnä aŋä kuiŋä-täŋä äpmamiŋuwiqä. Namnä aŋä iqueŋi, Goti Hanjuwä Iqu iquauŋi, kukŋuä naqä-qakui äwimiŋqeqä. Qu aŋä ique ämätäpiyäŋgaŋi, nätmatqä eeqänäŋi Goti Hanjuwä Iqu, Mosisi ique ämotquakqä-pa imäkmiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Qänakndaŋi iquauqä ymeqä iqua, aŋä iqueŋi ämapiyi, qu Josuwa iqutä, ämaqä hŋquauä qua mapŋqä qäsä äma äpkuwiqä. Iŋgaŋi Goti Hanjuwä Iqu, ämaqä qua iu äpmamiŋuwä iquau huätä väqiyqaŋga, qu aŋi ii ämätkuwi, ämiqä naqä Dewiti iqu äpmetäqäŋgaŋqä ämimiŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dewiti iqu, Goti Hanjuwä Iqu äŋguänäŋä iwimäkätqätaŋgqeŋqä, iqu Iqueŋi, ‘Jekopä iqueqä Goti Hanjuwä Iquki, nyi Sinyqä aŋä äŋguänäŋä hŋqu mätmqänä, hiŋuinä ŋqänyä,’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dewiti iqu iiŋä ätukqä-qe, Solomonä iqu-mända Goti Hanjuwä Iqueqä hiqäva-imäkqä aŋi, qe ämätkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Iiŋä etaŋgqä-qe, ämaqä iqua aŋä ämätpqä iuŋi, Goti Haqä Yätutaŋä Naqä Iqu mäpmeqä yänä. Ii hiŋuä-tqä iqu, Goti Hanjuwä Iqueqä kukŋuä äqäkqä-paŋiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ämaqä naqä iqua, zä-hawä iu quamä äpmeŋuwä-pa, Nyaqä zä-hawi, qäukuiqä. Itaŋga quae, Ŋqä yuki qutati haqeqi äumä äpmeŋänä. He Nyinyqä aŋi, äkitaŋi mätpŋqäwä? Ŋqä aŋä hapä pmeqäŋqe, äŋgi mätnänä? ");
INSERT INTO mcr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nätmatqä eeqänäŋi Nyaqä hipaetänä imäkkqeqä,’ ätätä äqänänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Iŋgaŋi Stipenä iqu, ämaqä miqä naqä iquauŋi, tiiŋi inä ätukqe. “He ämaqä hŋgisanä iquenjqä. He Goti Hanjuwä Iquenyqä quuvqä maeqiyqä ipu, Iqueqä kukŋui qätä mäwiyqä iquenjqä. Ii tiinjqä. Hiqä tawäkiqua hiŋuiqänä imäkmiŋuwä-pa, he Dŋä Äŋguä Iqueŋi, hea ique-ique hŋgisanä itquetqäŋuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hiqä tawäkiqua, hiŋuä-tqä hiŋuiqänä äpmamiŋuwä iquauŋi, eeqäpnä quvqä iwimäkmiŋuwiqä. Itaŋga ‘Ämaqä Jänänäŋä Iqä Iqu, äpäniqeqä’ ätmiŋuwä iquauŋä-pqe, qu pizqä äyä äpäkkuwiqä. Iŋi Ämaqä Jänänäŋä Iquenyqe, he täkqä ämaepu, pizqä ae äpäkkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","He Goti Hanjuwä Iqueuä kukŋuä-suqe, eŋätqä iquauqä hipa iutaŋi, ae qäyä ämakuwäŋqä, qänaknäŋi miqä itqäŋuwenjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","I tquaŋgi äwipiyi, ämaqä miqä naqä eeqänäŋä iqua, iquenyqä äwqä quvqä äwinyätä, hiquaŋi maŋgtäsqukuä ämäukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ii iqaŋguwäŋga, Dŋä Äŋguä Iqu Stipenä iqueŋi kuapänä muŋgaŋga, iqu hiŋui, qäukuä haqä yätu ämäqunäqe, nätmatqä, Goti Hanjuwä Iqueqä yäŋänäqŋqä motqueqä witaŋgqätä, Jisasi Iqu Goti Hanjuwä Iqueqä hipa ämuaŋgisa tqäutaŋgqätä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I äqunäqe, “Hiŋuä qumbiyä! Nyi qäukuä qŋqaŋä äutänätaŋgqätä, Ämaqeuqä Ymeqä Ekqä Iqu, Goti Hanjuwä Iqueqä hipa ämuaŋgisa tqäutaŋgqätä, hiŋuä äqunäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","I tquaŋga, iqua maŋä yäŋänäqŋqä ätäpu, qätä a äpmuäknäpu, pämä ätqäupu maqänä äupiyi, Stipenä ique a äkiqätkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ique a äkiqätpiyi, aŋä-himqä yäpaqä mäŋgisa ätuma äpäwäpu, hikä pizqä äpäkkuwi. Qu iiŋi mimäkqäŋga, ämaqä häŋäŋgatqä quaŋgä ätukuwä iqua, iquauqä gquä quäuqe äquvätäpu, hikŋä hŋqueqä yukä-täŋä qäqiqi ekuwi. Iqueqä yoqe, Soli ique. ");
INSERT INTO mcr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Qu Stipenä ique hikä pizqä päsätqätaŋguwäŋga, iqu tääqä ätätä, “Ŋqä Naqä Jisasi Iquki, ŋqä quuvqe indmayä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","I ätuäqetaŋi, iqu qoŋä äuktäutä, tääqä yäŋänäqŋqä, “Naqä Iquki, Si iquauqä suqä quvqeŋqe, kima mävqä panä!” ätukqe. E ätuäqetaŋi, äpäkoŋgqe. Qu Stipenä ique suqä tä iwimäkqaŋguwäŋgaŋi, Soli iqu, “Qäyunä äyä imäkqäuä” kŋuä äwikqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Hiunji Stipenä ique äpäkkuwäŋgaŋi, Jerusälemä iuŋi, ämaqä, Naqä Iqueqä yoqeu aquväqŋqä iquau, quvqä itquapŋqä ipäqäkuwi. Quvqä e iwitqueqa uwqaŋguwäŋga, qu eeqäpnä, qua Jutiya iuŋqätä, qua Sämaliya iuŋqätä, zä im-imä äwekuwi. Ämaqä Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iquanä zä mäwqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Qu Stipenä ique pizqä päsqaŋguwäŋga, ämaqä suqä Goti Hanjuwä Iqu äwinyätaŋgqä iunä qänaknä iqä hŋqua, iqueä huiwi qua äptepiyi, kŋuä naqänäŋä äqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iŋäqe Soli iqu, ämaqä, Naqä Iqueqä yoqeu aquväqŋqä iquauŋi, quvqä itquetŋqä ipäqäkqe. Iqu iquauqä aŋä eeqänäŋä iu äwimayäkitä, yäpä iŋgisa äwätä, qokä iquautä, apäkä iuautä, eyqiyäma äwätä, guä äkiqiyämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Qokä-apäkä zä äwekuwä iqua, kukŋuä äŋguänäŋi awä ätuäkämiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Iquautaŋä Pilipä iqu, aŋä-himqä Sämaliya iuŋqä äwiqe, Kraisi Iquenyqä kukŋuä äŋgui, iqi awä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Qokä-apäkä kuapänäŋi, qu Pilipä iqueuä kukŋuä qätä äwiyäpu, iqu nätmatqä ämaqä mimäkqänäŋä di imäkqaŋgi äqumbiyiŋqe, iqueuä kukŋui, qätä äŋguänä äwipu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ii tiinji. Dŋä quvqä kuapänäŋä iqua, ämaqä iuta zääqä ätäpu ävämeqauŋgua, ämaqä yäŋä-a quvqä iquatä, yukä quvqä iquatä, äŋguä qe imäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","E imäŋgaŋgä äqumbiyi, ämaqä aŋä-himqä iutaŋi, aquvänä qe ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aŋä-himqä iuŋi, ämaqä hŋqu äpmamiŋqe. Iqueqä yoqe, Saimonä ique. Pilipä iqu matimäuqäŋgaŋi, iqu paaqä huitaŋä-huitaŋä imäkätä, Sämaliya pmeqe yäuŋuä ipŋqä iwimäkätä, “Nyi ämaqä naqunjqä” ätmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","E imäkätqätaŋgqeŋqä, ämaqä naqä iquatä, ämaqä hiŋgiŋqä iquatä, qu, “Ämaqä tqu, Goti Iqueuä yäŋänäqŋqeqä” ätnäpu, iqueqä kukŋui qätä äŋguänä äwimiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iqu paaqä hŋgaŋqä imäkqa wätqätaŋgqeŋqe, qu iiŋä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pilipä iqu, kukŋuä äŋguä Goti Hanjuwä Iqunä miqä iuŋqätä, Jisasi Kraisi Iqueuä yoqeuŋqätä, awä tuätqätaŋgqeŋqä, qokä-apäkä qäsäŋi, qu ‘naqä-qakuiqä’ kŋuä indqämbiyi, quuvqä eqiyäpu, asŋä ämakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Itaŋga Saimonä iqu-pqe, “Naqä-qakuiqä” kŋuä indqänäqe, asŋä ämetä, Pilipä iqutä qaŋä anä ikämiŋiyi. E ikisiyäŋgaŋi, Pilipä iqu nätmatqä ämaqä mimäkqänäŋä huitaŋä-huitaŋä imäkqaŋgi äqunäqe, iqu yäuŋuä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ämaqä, Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä, Jerusälemä iu yqänä äpmamiŋuwä iqua, “Sämaliya pmeqä iqua, Goti Hanjuwä Iqueuä kukŋui ae ämeqäuä” tqaŋgä äwipiyi, qu Pitä iquesä, Jonä iquesä, iquau wimayŋqä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Sämaliya pmeqä iqua, Jisasi Iqueuä yoqeta asŋä meqaŋguwäŋga, Dŋä Äŋguä Iqu mäwimeqä yqänä etaŋgi, Pitä iqutä, Jonä iqutä ätimäyi, Dŋä Äŋguä Iqu iquau munätŋqä, Goti Hanjuwä Ique tääqä ätukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Iquaqu tääqä äsuiyi, hipae ämaqä iquauqä nyuäŋä haqeqä hiqaŋgiyäŋga, Dŋä Äŋguä Iqu iquau qe äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimonä iqu, iquaqu i iqaŋginyä, ämaqä Dŋä Äŋguä Ique äyä meqaŋgä äqunäqe, iqu iquaqui mbqä wimätä ikqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Iqu iiŋä itä, tiiŋä qe ätukqe. “Nyi ämaqä hŋque hipae haqeqä eqaŋga, iqu Dŋä Äŋguä Ique meniqä diŋqe, qe yäŋänäqŋqä tä, nyi-pqe inä dapinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","I tquaŋga, Pitä iqu kimaŋi, “‘Nätmätqä Goti Hanjuwä Iqu ävätŋqe, nyi mbqä imqänä’ kŋuä äkiyqetaŋi, tqä mbqetä, tqä-täuätä, qui anä imäknyiyŋqinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","“Goti Hanjuwä Iqueqä hiŋuä iqiŋi, tqä kŋuä indqäŋqe, jänä hma etaŋgi, Goti Hanjuwä Iqueqä wäuŋuä ne imäkätuŋqueuŋi, si anä mäpmeqänäŋiqä. ");
INSERT INTO mcr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tqä kŋui äkunmäknätnä, suqä quvqä tqueŋi, ävquatämäutnä, Naqä Iqueuä yätamäkqeŋqä yatŋqä wiyä! Si ii imäkŋi, Iqu tqä kŋuä indqäŋqä quvqe, huätä makmäuŋqutiyä, mämakmäuqä yäŋqutiyä? ");
INSERT INTO mcr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Si yäŋänäqŋqeŋqä hiŋuä aowä qänätqätaŋgnä äkqänmä, ii äktqänä. Suqä ii, marasinqä quvqä eŋqä-pa, saqä kŋuä indqäŋqe qui ikimäkätqänä. Suqä quvqe, guä eŋqä-pa kikiqäyäutaŋgi äkqänäŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","I tquaŋga, Saimonä iqu kimaŋi, “Nätmatqä qe ändqiyi mänyimeqä yätŋqe, Goti Hanjuwä Iqu haŋuä nyimäkätŋqä, tääqä suinyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Iŋgaŋi ämaqä kukŋuä awä siyŋqä ändowatkqä iquaqu, Pitä iqutä, Jonä iqutä, nätmatqä hiŋuä äqunmiŋiyiŋqätä, Goti Hanjuwä Iqueqä kukŋuiŋqätä, awä qäpu äsuiyi, iquaqu Jerusälemäŋqä aŋgi wiyŋqä ävämakiyi. Qaŋä äwäsiyäŋgaŋi, Sämaliya pmeqä iuqä aŋä-himqä kuapänäŋä iuŋi, kukŋuä äŋgui awä ätqäumiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Naqä Iqueqä eŋätqä hŋqu, Pilipä ique tiiŋä ätukqe. “Si pämä ätqäutnä, Sämaliyataŋä mäwqä iŋgisaŋqä äwitnä, hänaqä Jerusälemätaŋi, aŋä-himqä Gasa buŋqä änyeaqŋqeu ätimäutnä quveqäyä!” ätukqe. Hänaqä iqu, qua aväqŋqä-täŋä iu änyeaqenä. ");
INSERT INTO mcr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I tquaŋga, Pilipä iqu pämä ätqäutä qe äukqe. Hänaqä iqi ätimäuqe, iqu Itopiya pmeqä ämaqä naqä hŋque äquŋgqe. Ämaqä iqu apäkä Itopiya iu miqä naqä iiyqä wäuŋuä miqetaŋä ique. Ämaqä iu pmeqe, quwqä apäkä naqä iinyqe, “Ii kandisiyqä” ätmiŋuwi. Ämaqä tqu ya äyäŋqä-qu eä, iiyqä mbqä eeqänäŋi miqä ique. Iŋgaŋi iqu Goti Hanjuwä Ique qoŋä äwoktäutä, Iqueqä yoqä haqeqä mamäutŋqä Jerusälemäŋqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jerusälemä iu ae äpmeqetaŋi, aŋgu wätŋqä imäknätä, iqueqä kalisi haqeqi äpme, hiŋuä-tqä Asayä iqu bukä äqäkqe, a täuqämanmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iŋgaŋi Dŋä Äŋguä Iqu Pilipä iqueŋi tiiŋä ätukqe. “Si kalisi-täŋä qäqiqi äwätnä, qaŋä anä winyqä.” ");
INSERT INTO mcr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","I tquaŋga, Pilipä iqu, iqu-täŋä qäqi maqänä äwäqe, ämaqä iqu, hiŋuä-tqä Asayä iqu bukä äqäkqe, a täutqätaŋgi äwiyäqe, “Kukŋuä iuŋi kiqä quatiŋqe, si näqŋqä ae ämenyä, ä mämeqä inyä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ga, ämaqä iqu kimaŋi, “Ämaqä hma eätqe, kukŋuä quatiŋqe, nyi näqŋqä äänä himqäwä? Si äyapätnä, kalisi täu, nyitä quamä anä äpmeyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iqu bukä a ätäukqä iuŋi, tiiŋä tnätaŋgiyi. “Sipsipqä äpäkpŋqä ätuma äwquwä-paŋi, qu iqueŋi, asä iiŋä ätuma äukuwi. Itaŋga sipsipqä meqä kiqä ae, ätävätqätaŋguwäŋga zääqä matqä iqäqä-pa, iqu kukŋuä matqä e ikqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Qu iqueŋi, mändi äkittqiyäpu, kukŋui qäyunä mämitqä ikuwi. Iqu ymeqä maeqäŋga aaŋqä imäkqaŋguwitaŋi, iqueqä kaqä-kawäkauŋqe, matqä ipnuwiqä” ätä äyä äqänänä. ");
INSERT INTO mcr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ämaqä iqu kukŋuä tä a qäpu ätäuqe, Pilipä ique tiiŋä ätukqe. “Nyi yatŋqä äkiyqänä. Ämaqä hiŋuä-tqä iqu, tquenyqä ätkqäwä? Iqueqä-kiuäŋqä ätkqätanä, hŋquenyqä ätkqätanä?” ");
INSERT INTO mcr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Itaŋi, Pilipä iqu, Jisasi Iquenyqä kukŋuä äŋguiŋqä awä ätukqe. Iqu kukŋuä, ämaqä iqu a ae ätäukqä quatiŋqä ganä ätuäqe, kukŋuä huiziŋqä-pqä inä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Iquaqu hänaqeu äwqinjaqänyiyi, eqä hŋque ätimäyi, ämaqä iqu, “Hiŋuä qunyä! Eqä täqinjqä. Nyi asŋi, ämamqätanä, mämeqä imqätanä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","I ätuäqetaŋi, iqu kalisi miqä iqueŋi, “Si hosi eyqiyämetnä, iqi pmetŋqä imäkiyä” ätukqe. Iŋgaŋi Pilipä iqutä, ämaqä iqutä, eqä buŋqä äwäyi, ämaqä iqueŋi, Pilipä iqu asŋä qe äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Iquaqu eqä mämdaŋi äyapätqätaŋgiyäŋga, Naqä Iqueqä Dŋä Äŋguä Iqu, Pilipä iqueŋi, maqänä ätuma äwekqe. Ämaqä iqu aquvänä itä, iqueqä hänaqeu äwäqe, iqueŋi aŋgumä hiŋuä mäquŋquä ikqe. ");
INSERT INTO mcr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Iŋgaŋi Pilipä iqu, “Tä nyi aŋä-himqä Asändotä iu ätqäuäŋänä” kŋuä ämakqe. Iqisaŋi, iqu aŋä-himqä eeqänäŋä iuŋi, Jisasi Iquenyqä kukŋuä äŋguänäŋi, awä ätuäkämiŋqe. Iqu awä e ätquaŋi, aŋä-himqä Sisariya du ätuäqitimäukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Iŋgaŋi Soli iqu Naqä Iquenyqä quuvqä heqiyqä iquau qui imäkätä pizqä päsätŋqä kukŋuä yäŋänäqŋqä yqänä ätmiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Itaŋi, iqu hiqäva-imäkqä naqä iquenyqä äwäqe, “Si, Israitqä, aŋä-himqä Dämaskasi iu pmeqä iquauqä, aŋä aquväqŋqä iu miqä naqä iquenyqä, pipa äqiyätnä dapiyä” ätukqe. Iqu iiŋä tquaŋga, iqu pipa iuŋi, kukŋui tiiŋä äqiyätä äwikqe. “Soli iqu, qokä-pqä apäkä-pqä Jisasi Iqueqä hänaqä iu wätqätaŋguwä iquau ämoqumuetäqe, guä äkiqiyäutä, Jerusälemäŋqä ätuma päniqeqä” ätätä äqäkqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iŋgaŋi Soli iqu, Jerusälemä iu äväma äwäqe, Dämaskasi iu timäutŋqä qäqi wätqätaŋga, maqänäŋi qäukuä haqä yätutaŋä we-huŋqe, nyuauä eŋqä-paŋi, ique äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wimeqaŋga, iqu qua iqi äpäknäqe, ämaqä hŋqueqä maŋitaŋi, “Soli iquki, Soli iquki, si Nyi suŋqä qui nyimäkätqäŋinyä?” tquaŋgi äwikqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Iiŋä äwiyäqe, “Naqä Iquki, Si Tqukikä?” tquaŋga, kimaŋi, “Nyi Jisasi Iqunjqä. Ämaqä si qui imäkätqäŋi, ii Nyinjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Iŋäqe si pämä ätqäutnä, aŋä-himqä yäpä iŋgisa paquvä! Iqiŋi nätmatqä si imäktŋiŋqe, ämaqä hŋqu si awä ktäŋqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ämaqä, Soli iqutä anä äumiŋuwä iqua, qu ämaqä-que, hiŋuä mäquŋquä maŋinä tqaŋgi äwipiyi, kukŋuä matqä ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Iŋgaŋi Soli iqu ivatuwänäqe, hiŋuä äqänäqä-qe, iqueqä hiŋui hea äwäkqe. Iiŋä wimeqaŋga, qu ique Dämaskasi iuŋqä, a qe ämäusqäŋga äukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Iqiŋi, iqueqä hiŋui hea yqänä witaŋgi, iqu buayätä, eqätä, maŋqä, hiunji hŋquaqui-hŋque äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dämaskasi iuŋi, ämaqä Jisasi Iquenyqä quuvqä heqiyqä hŋqu äpmamiŋqe. Iqueqä yoqe, Anänasi ique. Iqu wätqä eŋqä-paŋä äqunätä, Naqä Iqu, “Anänasi iqukiyä” tquaŋgi äwiyäqe, “Nyi täqi äpmeŋänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","I tquaŋga, Naqä Iqu, “Si pämä ätqäutnä, hänaqä qu, ‘Jänäŋiqä’ ätätqäŋuwä iuŋqä uvä” ätukqe. “Iqiŋi, ämaqä, Jutasi iqueqä aŋiu pmetaŋgqä hŋquenyqä qävqä itnä wimayä! Iqu aŋä-himqä Tasusi iutaŋu eä, iqueqä yoqe, Soli iquvi. ");
INSERT INTO mcr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Iqu Goti Hanjuwä Iquenyqä tääqä ätätä, wätqä eŋqä-paŋi tiiŋä äquŋgqeqä. Ämaqä hŋqu, iqueqä yoqe Anänasi iqu, yäpä yäŋgisa äwimetä, iqueqä hiŋui aŋgumä äŋguä qänätŋqä, hipae haqeqi wiyätqätaŋgi äquŋgqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","14","I tquaŋga, Anänasi iqu, “Naqä Iqukiyä, ämaqä iquenyqe, nyi, ämaqä kuapänäŋä iqua, tiiŋä tqaŋgä äwiyäŋqeqä. ‘Iqu Jerusälemäŋi, Tqä ämaqä iquauŋi, suqä quvqä itquakaŋi, itaŋi täqinyqä pätŋqe, hiqäva-imäkqä naqä iqua, “äŋguiqä” tqaŋgä, äpäqe, ämaqä, Tqä yoqeŋqä quuvqä eqiyäpu, haqeqä äkivauqumuatätqäŋuwä iquau, guä kiqiyäutŋqä äquvepqeqä’ tqaŋgä, äwiyäŋqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Iwä, Naqä Iqu, “Si qaŋä uvä” ätukqe. “Ämaqä iiŋä iqu, Nyaqä wäuŋuä-nyiyqä hiäniŋqä, Nyi atäuŋuä ae iqäqeqä. Iqu, ämaqä Israitqä iqua qäyä etaŋgi huizi iquautä, aŋä-himqä iutaŋä miqä iquautä, Israitqä iquautäŋi, Nyaqä yoqeŋqä awä tquätŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iqu Nyaqä yoqeŋqä awä ätuätäqetaŋi, haŋä-iqetä, täŋä-huŋqetä mequätŋqä etaŋgi ämotquamqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iŋgaŋi, Anänasi iqu äwäqe, aŋä yäpä iŋgisa äpaquväqe, iqueqä hipae, Soli iqueqä haqeqi äwiyätä, tiiŋä ätukqe. “Tasi-gua Soli iquki, Naqä Jisasi, hänaqä si pätqätaŋgŋä iu äkimeqä iqu, sinyqä änändowatqi. Si hiŋuä aŋgumä qŋgaŋgti, Dŋä Äŋguä Iqu kuapänä kimetŋqä diŋqä änändowatqiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Iqu iiŋä tquaŋga, maqänäŋi, nätmatqä hiŋuä hea iwomäkmiŋqe, qua mäŋi päkŋgaŋga, iqu hiŋuä aŋgumä äŋguä qe äqäŋgqe. Iŋgaŋi iqu pämä ätqäuqe, asŋä qe ämakqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iiŋä iäqetaŋi, iqu ymisaŋä änätä, iqueqä yäŋänäqŋqe, aŋgumä qe äwimakqe. Soli iqu hiunji hŋquauŋi, quuvqä heqiyqä iquatä, Dämaskasi iu anä äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Iqu äpakänä mäpmeqä maqänä ikitä, Israitqä iquauqä aŋä aquväqŋqä iu äpaquvätä, “Jisasi Iqu, Goti Hanjuwä Iqueqä Ymeqeqä” ätuäkämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ämaqä qätä äwiyäpiyä iqua, qu eeqänäŋi yäuŋuä ipu, tiiŋä ätmiŋuwi. “Jerusälemäŋi, ämaqä, Jisasi Iqueqä yoqeŋqä quuvqä eqiyäpu, haqeqä mamäuqä iquau, qui imäkätŋqä iqu, ämaqä tä, qäqueqä. Itaŋi täqinyqä aŋgumŋi, täqisaŋä hŋquau guä äkiqiyäutä, hiqäva-imäkqä naqä iquauŋqä ätuma womätä, äquvepqiyä” ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Iŋgaŋi, Soli iqueqä kukŋuä tqe, yäŋänäqŋqä ätimäutä, Jisasi Iquenyqe, “Iqu Kraisi ämaqä mitŋqä Goti Hanjuwä Iqu ätekqä Iquvqä,” awä jänä ii ätumiŋqe. Iqu e tquaŋgqeŋqe, Israitqä Dämaskasi iu äpmamiŋuwä iquauä kŋuä indqäŋqe, änä mindqäŋqä ipu, kukŋuä matqä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Hiunji kuapänä ae äpäwqaŋga, Israitqä iqua aquvä äqänäpu, Soli ique pizqä päkpŋqä kukŋuä naqä-hŋqunä imäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nätmatqä iiŋqe, Soli iqu näqŋqä ämakqe. Hiunjiŋgatä, heatqäŋgatä, Israitqä iqua, ique pizqä päkpŋqeŋqe, aŋä-himqä iuŋi, hänaqä eeqänäŋä iu, wiwä äqiyäqämamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iiŋä etaŋgi, ämaqä, Soli iqu ämotquamiŋqä iqua, iqueŋi heatqäŋga aŋä-himqä täkŋä quäuqänäŋä yätuŋqä ätuma epiyi, iqu hiqokä-qa naqänäŋä iu mŋgaŋga, guä äqiyäpiyi, täkŋä yäpaqä mäŋgisa äqiyäumäwatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Qänakndaŋi, Soli iqu, Jerusälemä iu ätimäuqe, iqu ämaqä Jisasi Iquenyqä quuvqä heqiyqä iquatä, aquvä anä qämbŋqä imäkmiŋqe. Iqu iiŋä itqätaŋga, iqua, “Iqu quuvqä eqiyqiyä” tqaŋgä äwiyäpiyä-qe, eeqänäŋi, “Quaŋgiqä” kŋuä vqaŋgi, iquenyqä zä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","I etaŋgi, Banäpasi iqu, ique, ämaqä Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iquauŋqä, ätuma äwäqe, iqu iquauŋi, Soli iquenyqä kukŋuä awä ätukqe. Iqu hänaqä iqi äwätäqäŋga, Naqä Ique hiŋuä äquŋgqeŋqätä, Naqä Iqu ique kukŋuä ätukqeŋqätä, itaŋga Dämaskasi iu äpmeqäŋga, Jisasi Iqueqä yoqeŋqä kukŋuä awä yäŋänäqŋqä ätumiŋqeŋqätä, ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iŋgaŋi Soli iqu, iquatä Jerusälemä iu anä äpmapu, qaŋä ikipiyäŋgaŋi, iqu zä miqä, Jisasi Iqueqä yoqeŋqä kukŋuä awä ätumiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iqu Israitqä Grikä iquauä kukŋuinä tqä iquatä, kukŋuä mäkä äunmiŋuwi. Iiŋä ipiyitaŋi, qu ique pizqä päkpŋqä imiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Käta-käŋguäkiqua, qu iiŋiŋqä näqŋqä ämapiyi, ique aŋä-himqä Sisariya buŋqä ätuma äwäpiyi, iqisaŋi aŋä-himqä Tasusi iuŋqä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iŋgaŋi qua Jutiya pmeqä, qua Galili pmeqä, qua Sämaliya pmeqä, Jisasi Iqueqä yoqeŋqä aquväqŋqä iquauŋi, ämaqä huizi iqua haŋä-iqe mävqä iqaŋgä, qu äwqä haŋuä imbu, äŋguä äpmamiŋuwi. Dŋä Äŋguä Iqu, iquauqä äwqeuŋi, yäŋänäqŋqä iwimäkqaŋgi, qu suqä Naqä Iquenyqä qänaknä iqä iunä, äpmaka äumiŋuwi. Itaŋga ämaqä kuapänä quuvqä eqiyäpu, huizi iquatä aquvä anä äqänmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitä iqu, eeqänäŋä iu äkoquväkiqinjaqänäqe, aŋä-himqä Linda iu ätimäuqe, Goti Hanjuwä Iqueqä ämaqä iqi äpmamiŋuwä iquau äwimakqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aŋä iuŋi, iqu ämaqä hŋqu, iqueqä yoqe Aniyasi iqu, pmetaŋgi äwimakqe. Iqu yuki ŋŋuä-täŋä eä, iqueqä yquvaŋä iunä pmetaŋgi, quväukuä 8 ämäwqätäukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitä iqu ique äwimeqe, tiiŋä ätukqe. “Aniyasi iquki, Jisasi Kraisi Iqu si aŋgu äŋguä ikimäkqiyä. Si ävautnä, tqä yquvaŋi, jänä imäkiyä.” I tquaŋgaŋi, iqu maqänä qe ävaukqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iŋgaŋi ämaqä eeqänäŋä, aŋä-himqä Lindataŋä iquatä, quauŋuä Salonä pmeqä iquatä, Aniyasi ique hiŋuä äqumbiyi, qu kŋuä äkunmäknäpu, Naqä Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Aŋä-himqä Jopa iuŋi, apäkä Jisasi Iquenyqä quuvqä heqiyqä hui äpmamiŋqe. Iiyqä yoqe, Tapita. Yoqä iiŋi, Grikä iquauqä aŋä-kukŋuiu, qu “Dokasiyä” ätmiŋuwi. Hea ique-iqueŋi, ii suqä äŋguänäŋi imäkätä, ämaqä nätmatqäŋqä äwa iqaŋguwä iuŋi, yätamäkqä vqä iiyi. ");
INSERT INTO mcr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pitä iqu, Linda iu yqänä pmetaŋga, ii täŋä-yaqä äwimeqe, qe äpäkoŋgqe. Itaŋga qu iiyqä huiwi, asŋä äqiyäpu, aŋä hiqŋqä haqä imä ekuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Aŋä-himqä Jopa ii, aŋä-himqä Linda-täŋä qäqiqiyi. Ämaqä quuvqä heqiyqä iqua, “Pitä iqu Linda iu äpmenä” tqaŋgä äwipiyi, qu ämaqä hŋquaqui, “Linda pmeqä iqua, ‘Iyää, si äpakä miqä, nenyqä maqänä biyä’ ätqäuä” suiyŋqä diŋqä, ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","I tquaŋgiyäŋga, Pitä iqu ivatuwänätä, iquaqutä qe äukuwi. Iqu äwimeqaŋga, qu aŋä hiqŋqä yätuŋqä ätuma äpekuwi. Yätqäŋi apäqŋqä eeqänäŋä iua, Pitä iqu-täŋä iqi pämä ätqäupu, kŋuä äqiyäpu, gquätä, ämuasmäŋqätä, Dokasi häŋä äpmeqäŋga imäkkqe, ämotquakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Qu i iqaŋguwäŋga, Pitä iqu eeqänäŋä iquauŋi, yäpaqä mäŋgisa ändowatäqe, qoŋä äuktäutä, Goti Hanjuwä Iquenyqä tääqä ätukqe. Iŋgaŋi iqu apäkä pizqä i witaŋgqä iŋgi, hiqumuaŋä äwiyäqe, “Tapitauä, si vayä” ätukqe. I tquaŋga, ii hiŋuä äqänäqe, ique hiŋuä äqunätä, pämä qe äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ii pmeqaŋga, iqu hipae a maqätqaŋga, ii pämä ätqäukqe. E tqäuqaŋga, iqu Goti Hanjuwä Iqueqä qokä-apäkä iquautä, apäqŋqä iuautä, tääqä ätuätumeqetaŋi, Tapitai häŋä pmetaŋgi ämotquakqe. ");
INSERT INTO mcr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iiŋqe, Jopa pmeqä eeqänäŋi, qätä äwipiyi, kuapänäŋi Naqä Iquenyqä quuvqä eqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iŋgaŋi Pitä iqu Jopa iuŋi, hiunji kuapänä, ämaqä, yaqueqä huiwiu wäuŋuä imäkqä hŋqu, iqueqä yoqe Saimonä iqutä äpmamiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Iŋgaŋi ämaqä hŋqu, iqueqä yoqe Koniliusi iqu, aŋä-himqä Sisariya iu äpmamiŋqe. Iqu Romätaŋä mäkä-iqä, qu “Italisaŋä iquayqä” ätmiŋuwä, ämaqä 100 iquau miqä naqä iquvi. ");
INSERT INTO mcr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iqutä, ämaqä iqueqä aŋä iu anä äpmapiyä iquatä, qu Goti Hanjuwä Iqueqä äwinyäŋqeuŋi qänaknä ipu, Goti Hanjuwä Iqueqä yäpä iqinyä äpmamiŋuwi. Ämaqä nätmatqäŋqä äwa iqaŋguwä iquauŋi, iqu yätamäkqä kuapänä ävätä, Goti Hanjuwä Iquenyqä tääqä hea ique-ique ätätä äpmamiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Hiunji hŋqueŋi, mäptqä äwitŋqä ti pmetaŋga, iqu wätqä eŋqä-paŋä iuŋi, Goti Hanjuwä Iqueqä eŋätqä hŋqu ätnäŋäqinyä quvepqaŋgi äquŋgqe. Eŋätqä iqu ique äwimeqe, “Koniliusi iqukiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","I tquaŋga, Koniliusi iqu zä itä, hiŋuä yäŋänäqŋqä äqunäqe, “Naqä Iqukiyä, änääŋqäwä?” ätukqe. Kimaŋi, “Si Goti Hanjuwä Iquenyqä tääqä ätätnä, ämaqä nätmatqäŋqä äwa iqaŋguwä iquau yätamäkqä ävätqätaŋgŋi, Iqu hiŋuä äkqänätä, sinyqä kŋui ae ämenä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Täŋgaŋi si ämaqä hŋquau, aŋä-himqä Jopaŋqä dowatiyä. Iŋi iqua, ämaqä hŋque, iqueqä yoqe Saimonä ique, iqueqä yoqä huizi Pitä ique, ätuma ppŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iqu Saimonä yaqueqä huiwiu wäuŋuä imäkqä iqueqä aŋiu äpme. Iqueqä aŋi, eqä-pŋä maŋä iqi ämätnänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Eŋätqä e ätukqä iqu vämeqaŋga, Koniliusi iqu, iqueqä aŋiu wäuŋuä iqä iquautaŋä hŋquaquisä, mäkä-iqä, ique yätamäkqä vqä iquautaŋä hŋquesä, tääqä ätuätumakqe. Mäkä-iqä iiŋä iqu, Goti Hanjuwä Iqueqä äwinyäŋqeuŋi qänaknä iqä-quvi. ");
INSERT INTO mcr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Koniliusi iqu iquauŋi, nätmatqä eeqänäŋi, timäuqaŋgqeŋqä awä ätuäqe, Jopa iuŋqä ändowatkqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Iqu iquauŋi dowatqaŋga, itaŋga awiŋgaŋi, qu qaŋä äwqinjaqämbiyi, hiunji quemisqäŋga, aŋä-himqä Jopa-täŋä qäqi wätqätaŋguwäŋga, Pitä iqu, aŋä atäuqä haqä yätqä, Goti Hanjuwä Iquenyqä tääqä tuätŋqä ekqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Iqu e iqetaŋi, buayä dä vqaŋga, iqu buayä nmätä ikqe. Qu buayä näwenyä imäkätqätaŋguwäŋga, wätqä eŋqä-pa äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Qäukuä haqä yätuŋi qŋqaŋä äutäŋgaŋgi äquŋgqe. Iŋgaŋi nätmatqä hŋqu, yuä naqänäŋä eŋqä-paŋä, kiqä hituŋuä hŋquaqui-hŋquaquiŋä iuŋi, qua täuŋqä pätŋqä ävquatäwatŋgaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yuä iqueqä vawä iuŋi, hiveqä-yaqueqä, yŋŋä-täŋä, iwomä-qänakukuiqä, huitaŋä-huitaŋä iiŋi, vawä hiknätaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","E äqunäqe, maŋitaŋi kukŋui tiiŋä tqaŋgi äwikqe. “Pitä iquki, si ävautnä, naŋui äpäsätnä huinyä!” ");
INSERT INTO mcr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Iqu kimaŋi, “Ae! Naqä Iquki, nätmatqä Tqä hiŋuä iqi kiyä mätqä eäŋqe, nenyŋqä pmua imäknäŋqe, nyi maŋqä itŋqä-qae, oeyä maŋqä ymqänä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","E tquaŋga, maŋä aŋgi tii ätukqe. “Nätmatqä Goti Hanjuwä Iqu, kiyä maeqä imäkqeŋqe, si ‘kiyä mätqeqä’ matqä panä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hŋquaqui-hŋque e ätäqetaŋi, yuä vawä iqueŋi maqänäŋi, qäukuä haqä yätuŋqä aŋgi äma ekqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pitä iqu, “Nyi wätqä eŋqä-pa äqunäŋqe, quati änääŋgä?” kŋuä kuapänä indqänätqätaŋgaŋi, ämaqä Koniliusi iqu ändowatkqä iqua, “Saimonä iqueqä aŋi äŋgikä?” ätuäpu, yatŋqä ävqa äppiyi, iqueqä aŋä hänaqä iu ätimäukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Qu iqi ätqäpiyi, tääqä ätäpu, “Saimonä iqueqä yoqä huizi Pitä iqu, täqisanä?” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitä iqu kŋuä yqänä indqänätqätaŋga, Dŋä Äŋguä Iqu tiiŋä ätukqe. “Hiŋuä qunyä. Ämaqä hŋquaqui-hŋque, sinyqä qävqä iqapätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Iŋäqe, si pämä ätqäutnä, äquveqesŋqeqä. Nyi iquau ändowatqaŋgä äquvepquwiŋqe, si iquatä anä upŋqeŋqe, kŋuä kuapänä mindqäŋqä panä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","I tquaŋga, Pitä iqu, iquauŋqä äquveqäqe, tiiŋä ätukqe. “Ämaqä he qävqä iqapätqäŋuwä iqu, ii nyinjqä. He suŋqä quvepqäuä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Iqu i tquaŋga, qu kimaŋi, “Koniliusi, mäkä-iqä 100 iquau miqä naqä iqu, änandowatqaŋgi äquvepqunä” ätukuwi. “Iqu ämaqä jänäŋä-qu eä, Goti Hanjuwä Iqueqä yäpä iqinyä pmetaŋgi, Israitqä eeqänäŋä iqua, ‘Ämaqä äŋguänäŋueqä,’ ätätqäŋuwiqä. Goti Hanjuwä Iqueqä eŋätqä hŋqu, ique tquaŋgqetaŋi, iqu tqä kukŋui qätä kiyätŋqä diŋqe, ne ikitmetanä, iqueqä aŋä iuŋqä watuŋquä änandowatqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iŋi, Pitä iqu aŋä yäpä yäŋgisa ätuma äpeyäqe, hea iqueŋi, iquau ämimiŋqe. Ziŋuitäŋi, iqu ävautä, iquatä, käta-käŋguäka, Jopa iu pmeqä hŋquatä, anä äukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Äwqinjaqämbiyi, hiunji huizi iqueŋi, Sisariya iu ätimäukuwi. Iqua qaŋä pätqätaŋguwäŋgaŋi, Koniliusi iqu iquauŋqä hiŋuä äqunä äpme, iqueqä häŋeqä asä qäyutaŋä iquautä, iqueqä näueqä naqä-qakuänäŋä iquautä, tääqä ätuätumakqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","26","Pitä iqu aŋä yäpä yäŋgisa peyqaŋga, Koniliusi iqu, iqu-täŋä qäqi äpeyäqe, iqueuä yoqä haqeu mamäutŋqä, iqueqä yukä-täŋä qäqi qoŋä äwoktäuqaŋgi, Pitä iqu ique ävauqumuatätä, “Nyi ämaqä, si eŋqä-paŋä iqunjqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ii iäqe, iqu iqutä yäpä iŋgisa kukŋuä ätqäyäsiyäŋgaŋi, qokä-apäkä kuapänäŋi, aquvä äqämbu pmetaŋgä äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Iŋgaŋi, iqu iquauŋi, tiiŋä ätukqe. “He Israitqä iquneqä kukŋuä-suqeŋqä näqŋqä ae äyä eäŋäuä. Israitqä iqune qäyä etaŋgi huizi iquatäŋi, ne nätmatqä hui imäkätanä iquatä pmeqe, ii pmua imäknänä. Iiŋä etaŋgi, nyi ämaqä hŋquenyqe, ‘Iqu kiyä mätqä-queqä. Nyi iqutäŋi, anä mäpmeqä yenyqueqe’ matqä imqä diŋqe, Goti Hanjuwä Iqu nyi ämändqueqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iiŋiŋqe, he tääqä dqaŋguwiŋqe, nyi ‘oeyqä’ matqä itmä, äquvepqänä. Iŋi nyi yatŋqä eyqänä. He nyinyqe, suŋqä ändowatquwäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","I tquaŋga Koniliusi iqu, “Hiunji hŋquaqui-hŋque päwqaŋgqeuŋi, mäptqä äwitŋqä ti iqaŋga, nyi nyaqä aŋä täu äpmamä, Goti Hanjuwä Iquenyqä tääqä ätqäqeqä” ätukqe. “Nyi i pmetaŋga, maqänäŋi, ämaqä hŋqu, iqueqä qäkitaŋi tä naqänäŋä yäŋqä-qu, nyaqä hipeŋuä iqi ätqäuŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Änyimeqe, iqu ‘Koniliusi iqukiyä’ ändqeqä. ‘Goti Hanjuwä Iqu, saqä tääqä ätätqäŋi, qätä ae äkiyätä, ämaqä nätmatqäŋqä äwa iqaŋguwä iquau, yätamäkqä ävätqäŋiŋqe, kŋuä indqänänä. ");
INSERT INTO mcr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Täŋgaŋi si ämaqä hŋquau, aŋä-himqä Jopaŋqä dowatiyä. Iŋi iqua ämaqä hŋque, iqueqä yoqe Saimonä ique, ätuma ppŋqänänyä. Iqueqä yoqä huizi, Pitä iqueqä. Iqu Saimonä huizi, ämaqä yaqueqä huiwiu wäuŋuä imäkqä iqueqä aŋiu äpmenä. Iqueqä aŋi, eqä-pŋä maŋä iqi ämätnänä,’ ändqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","I dqaŋga, nyi maqänäŋi ämaqä hŋquau, sinyqä dowatqaŋga, si suqä äŋguä inemäkätnä, äyä äpnyä. Iŋi täŋgaŋi, ne eeqänäŋi äpätanä, Goti Hanjuwä Iqueqä hiŋuä täqi äpmeŋqutä, kukŋuä Naqä Iqu äktqäqe, eeqänä qätä äwiyanä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kimaŋi, Pitä iqu tiiŋä ätukqe. “Naqä-qakui, nyi näqŋqä tiiŋä eqänä. Goti Hanjuwä Iqu, qokä-apäkä iquauqä häŋeqäŋqä kŋuä mämeqä itä, eeqänäŋä iquauŋi, suqä asitaŋi Iwimäkqä Iqueqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ämaqä häŋeqä äkitaŋä äsqu, Naqä Iqueqä yäpä iqinyä äpme, suqä jänäŋinä imäkqaŋgutqe, Goti Hanjuwä Iqu iqueŋi itmeŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Goti Hanjuwä Iqu, Israitqä iqune, kukŋuä äŋguä we-huŋqä-täŋi änätapkqeŋqe, he näqŋqä ae äyä eŋä. Ii tiiŋiqä. Jisasi Kraisi Iqu, ämaqä eeqänäŋä iuqä Naqä-qu eä, ne Goti Hanjuwä Iqutä, äwqä naqä-hŋqunä änyanä pmetatuŋquä, inemäkäŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nätmatqä eeqänäŋi, qua Jutiya iu ätimäukqä-pqeŋqe, he näqŋqeqä. Jonä iqu, asŋä qŋqeŋqä awä ae ätukqäŋga, nätmatqä iiŋi qua Galili iu ganä ipäqäkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iŋi Jisasi Nasäretqätaŋä Iqueŋi, Goti Hanjuwä Iqu ätetä, Dŋä Äŋguä Iquesä, yäŋänäqŋqetä ävätä, Iqutä anä pmetaŋgi, Iqu ämaqä iu yätamäkqä ävätä, ämaqä Setänä iqu qui imäkkqä iquauŋi, äŋguä iwimäkätä, aŋä-himqä eeqänäŋä iu ikämiŋqeŋqe, he näqŋqä ae äyä eŋäuä. ");
INSERT INTO mcr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nätmatqä eeqänäŋä, Iqu Israitqä iquauqä qua iutä, Jerusälemä iutä imäkätqätaŋgi, ne hiŋuä äqunmiŋqueŋqätä, ique zä-huätatä äuepu, pizqä äpäkkuwiŋqätä, awä-tqä-quneyqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iqueŋi, hiunji hŋquaqui-hŋque päwqaŋga, Goti Hanjuwä Iqu, aŋgumä ävauqumuatäqe, qokä-apäkiuqä hiŋuä iqi timäutŋqä äyä iwimäkkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Iqu ämaqä eeqänäŋä iquau mäwimeqä itä, ne, Goti Hanjuwä Iqueqä kukŋuä awä tquatuŋquä, atäuŋuä ae änekqä iqunenyä änemakqeqä. Iqu qua äptekuwä iuta ävauqe, buayätä, eqätä anä äŋgqueqä. ");
INSERT INTO mcr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iŋgaŋi Iqu, ne ämaqä iuŋi, kukŋuä tiiŋä iqu, ätnäŋä iqi awä tquatuŋquä änatkqeqä. ‘Goti Hanjuwä Iqu, Ämaqä Qäqueŋi, ämaqä häŋä äpmeŋuwä iutä, pizqä ae äpäkonätqäŋuwä iutä, iwäsäuqäŋqä ätekqäqä Iquvqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hiŋuä-tqä eeqänäŋä iqua, Iquenyqä awä tiiŋä ätmiŋuwiqä. ‘Ämaqä, Iquenyqä quuvqä heqiyqä iqua, Goti Hanjuwä Iqu, Iiŋä Iqueqä yoqetaŋi, äwqä haŋuä imäknätä, iquauqä suqä quvqe, huätä mamäuŋqiyä’ ätmiŋuwiqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitä iqu, kukŋuä yqänä tätqätaŋga, Dŋä Äŋguä Iqu, ämaqä kukŋuä qätä wiyätqätaŋguwä eeqänäŋä iquauŋqä äquvepätä, maŋguä ämuŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Itaŋi, qu aŋä-kukŋuä huitaŋä-huitaŋä ätäpu, Goti Hanjuwä Iqueqä yoqä haqeqä ämamäukuwi. Israitqä quuvqä heqiyqä, Pitä iqutä anä äpkuwä iqua, qätä e äwipiyi, yäuŋuä ipu, tiiŋä ätkuwi. “Ämaqä Israitqä iqune qäyä etaŋgi huizi iquauŋi, Goti Hanjuwä Iqu Iqueqä Dŋä Äŋguä Ique, iquau qanyä äyä ävqiyä.” ");
INSERT INTO mcr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Iŋgaŋi Pitä iqu tiiŋä ätukqe. “Ämaqä huizi iqua-pqe, Dŋä Äŋguä Iqueŋi, ne ämakqu-paŋä asä iiŋi ämeqäuä. Iiŋä etaŋgi ne eqätä asŋä qiyatuŋqueŋqe, ‘Iiŋi miqä pambiyä-qe’ tqu natätŋqäwä?” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","I ätuäqetaŋi, iqu, “Ne iquauŋi, Jisasi Kraisi Iqueä yoqeta, asŋä uwqiyatuŋqueqä” ätukqe. Qu asŋä ae ämapiyi, Pitä iqueŋi, “Si hiunji hui, nesä anä pmayä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ämaqä, Jisasi Iqu kukŋuä awä tuäkiqäpŋqä ändowatkqä iquatä, käta-käŋguäka, qua Jutiya iu äpmamiŋuwä iquatäŋi, “Ämaqä Israitqä qäyä etaŋgi huizi iqua-pqe, Goti Hanjuwä Iqueuä kukŋui ae ämequwiqä” tqaŋgä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iiŋiŋqe, Pitä iqu, Jerusälemäŋqä uwqaŋga, ämaqä quuvqä heqiyqä suqä huiwä häuä ktäuqäŋqä yäŋänäqŋqä imäkäpiyä iqua, Pitä iqueŋi, kukŋuä ämitäpu, äkasuwä tiiŋä ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Si ämaqä huiwä häuä maktäŋqä iquauqä aŋiuŋqä äwätnä, iquatä buayä anä änätqäŋuwä iqukiyqä.” ");
INSERT INTO mcr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","I tquaŋguwäŋga, iqu nätmatqä eeqänäŋä, ique äwimakqeŋqä awä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nyi aŋä-himqä Jopa iu, Goti Hanjuwä Iquenyqä tääqä ätuätmä äpmamäŋgaŋi, wätqä eŋqä-paŋä tiiŋä äquŋgqe. Nätmatqä hŋqu, yuä naqänäŋä eŋqä-paŋä, kiqä hituŋuä hŋquaqui-hŋquaquiŋä iuŋi, guä qäukuä haqä yätuta qäyämäwatŋgaŋgi äquŋgqe. Ii qäyämäwatnäqe, nyinyqä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nyi näqŋqä äŋguänä mamqä, hiŋuä äŋguänä äqunäŋqeqä. Vawä iuŋi, hiveqä-yaqueqä, yŋŋä-täŋä, iwomä-qänakukuiqä, huitaŋä-huitaŋä iiŋi, vawä hiknätaŋgi äquŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iŋgaŋi, nyi maŋä hŋqu, tiiŋä tqaŋgi äwikqe. ‘Pitä iquki, si ävautnä, naŋui äpäsätnä, huinyä.’ ");
INSERT INTO mcr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kimaŋi nyi, ‘Naqä Iquki, nätmatqä Tqä hiŋuä iqi kiyä mätqä eäŋqe, nenyŋqä pmua imäknäŋqe, nyi maŋqä itŋqä-qae, “oeyä” maŋqä ymqänä,’ ätukqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Nyi kimaŋi e tquaŋga, maŋä qäukuä haqä yätutaŋi, aŋgi ändkqeqä. ‘Nätmatqä, Goti Hanjuwä Iqu kiyä maeqä imäkqeŋqe, si “kiyä mätqeqä” matqä panä,’ ändkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hŋquaqui-hŋque e ätäqetaŋi, nätmatqä eeqänäŋi, qäukuä haqä yätuŋqä aŋgi äma ekqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Asä qäŋgaŋi, ämaqä hŋquaqui-hŋqueŋä, ämaqä aŋä-himqä Sisariyataŋä hŋqu nyinyqä ändowatkqä hŋqua, aŋä ne pmetaŋgquä iqi ätimäukuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Iŋgaŋi Dŋä Äŋguä Iqu, ‘Si kŋuä kuapänä mindqäŋqä pa, iquatä anä upŋqeqä’ dqaŋgi, nyitä, neqä tatqä-guäka 6 täqi äpmeŋuwä tquatä, Sisariyaŋqä anä äwani, ämaqä iqisaŋä, Koniliusi iqueqä aŋä yäpä iŋgisa, qe äpaqukqueqä. ");
INSERT INTO mcr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ique wimeqauŋgua, iqu, eŋätqä hŋqu, iqueqä aŋä yäpä iŋgisa pämä tqäutaŋgi äquŋgqeŋqä, änatkqeqä. Eŋätqä iqu, iqueŋi, tii ätukqeqä. ‘Si ämaqä hŋquau, Jopaŋqä, ämaqä Saimonä, iqueqä yoqä huizi Pitäuä ätmiŋuwä ique, ätuma ppŋqä dowatiyä. ");
INSERT INTO mcr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ämaqä iqu, kukŋuä Goti Hanjuwä Iqu, sitä, ämaqä tqä aŋä iu anä äpmeŋuwä iquautä, he häŋä equmuatäniŋqä diŋqe, ktäŋqiyä’ ätukqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Koniliusi iqu iiŋqä qäpu natqaŋga, nyi kukŋuä ti tipäqiyqaŋgaŋi, Dŋä Äŋguä Iqu, nenyqä äpätä änamŋgqä-paŋä asä iiŋi, iquau-pqä maŋguä inä ämuŋgqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iŋgaŋi nyi, kukŋuä Naqä Iqu hiŋuiqänä ätkqä tiiŋiŋqe, kŋuä aŋgumä änyimakqeqä. ‘Jonä iqu asŋi, eqä ditänä äqämiŋqä etaŋgutqe, qänakŋi he asŋi, Dŋä Äŋguä Iquesä mapnuwiqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ne Jisasi Kraisi, neqä Naqä Iquenyqä quuvqä heqiyqauŋgua, Goti Hanjuwä Iqu Dŋä Äŋguä Ique änätapkqe. Hea täŋgaŋi Iqu iquau asä iiŋä äwikqeqä. Goti Hanjuwä Iqu iquau wäuŋuä ii iwimäkkqä iuŋi, a kiqätmqä iqundi? Oeyqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pitä iqu e tquaŋga, ämaqä iqua, äwqä haŋuä imbu äpmapiyi, Goti Hanjuwä Iqueqä yoqä haqeqä ämamäupu, tiiŋä ätkuwi. “Täukue! Kŋui äkunmäknäpu, häŋä-pmeqä di meqe, Goti Hanjuwä Iqu, ämaqä Israitqä iqune qäyä etaŋgi huizi iquau-pqe, inä äwikqeqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Qu Stipenä ique äpäsäpu, quuvqä heqiyqä huizi iquau, quvqä itqueqaŋguwäŋga, kuapänäŋi aŋä-himqä hui-huiuŋqä im-imä äwekuwi. Hui qua Ponisiyaŋqä, hui qua eqä-pŋä awä iqi äwiŋqä Saplusiŋqä, hui aŋä-himqä Andiyokäŋqä äukuwi. Qu äwäpiyäŋgaŋi, kukŋuä äŋguä we-huŋqä-täŋi, ämaqä Israitqä iquaunä awä ätqäumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","I etaŋgqä-qe, iquautaŋi, ämaqä, Saplusi iutaŋä hŋquatä, aŋä-himqä Sairini iutaŋi hŋquatä, Andiyokäŋqä äwipu, Naqä Jisasi Iquenyqä kukŋuä äŋgui, awä ätuäpiyäŋgaŋi, ämaqä Israitqä iquautaŋä ma, Grikä iquauä aŋä-kukŋuä tqä iquau-pqe awä inä ätumiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Iŋgaŋi Naqä Iqueqä yäŋänäqŋqe, iquatä pmetaŋgi, qokä-apäkä kuapänäŋä iqua, Naqä Iquenyqä quuvqä eqiyäpu, Iquenyqä qänaknä ipŋqä äkunmäkŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Quuvqä heqiyqä, Jerusälemä iu äpmamiŋuwä iqua, iiŋqä qätä äwipiyi, qu Banäpasi ique, Andiyokäŋqä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Iqu ämaqä äŋguänäŋu eä, iqueqä quuvqä heqiyqe yäŋänäqŋqä etaŋgi, Dŋä Äŋguä Iqu iqueŋi, kuapänä ämunmiŋqe. Iŋi iqu äwäqe, Goti Hanjuwä Iqu, iquau ämitä, äŋguä iwimäkqaŋgi äqunäqetaŋi, aquvänä itä, qu Goti Hanjuwä Iquenyqä quuvqä yäŋänäqŋqä eqiyäpu pmepŋqä iiŋqe, iquauqä kŋuä indqäŋqe, äwivauqumuatkqe. Iŋgaŋi ämaqä kuapänä, Naqä Iqutä guä ämäŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Iŋgaŋi Banäpasi iqu, aŋä-himqä Tasusiŋqä, Soli iquenyqä qävqä ikitŋqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ämoqumueqe, iqu Andiyokäŋqä ätuma äpätä, quväukuä hŋqueŋi, ämaqä Jisasi Iqueqä yoqeŋqä aquvä iqi äqänmiŋuwä iquatä, anä äpmamiŋuwi. Iqi äpmayi, iquaqu Goti Hanjuwä Iqueqä kukŋui, ämaqä kuapänäŋä iu ämotquamiŋiyi. Andiyokä pmeqä iqua, ämaqä quuvqä heqiyqä iquauŋqe, “Kraisi Iqueqä yoqä-täŋä-quayqe” iqua-ganä ätipäqäkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Iŋgaŋi hiŋuä-tqä hŋqua, Jerusälemä iu äväma, Andiyokä iuŋqä äwokuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iu ätimäupiyi, iquataŋä hŋqu, iqueqä yoqe, Akipasi iqu, pämä ätqäuqe, Dŋä Äŋguä Iqu kŋuä vqaŋgi, aŋä-himqä eeqänäŋä iu, buayä dä naqänäŋä timäuniqeŋqä awä ätukqe. (Buayä dä naqänäŋi, Klotiusi iqu qua eeqänäŋä iu miqä pmetaŋga, ätimäukqe.) ");
INSERT INTO mcr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Quuvqä heqiyqä iqua, Akipasi iqueqä kukŋui qätä äwipiyi, kukŋuä naqä-hŋqunä tii ätkuwi. “Tatqä-guäka Jutiya iu äpmeŋuwä iquauŋi, ne yätamäkqä ävätanä, mbqä väwqatatuŋquä, aquvä qiyatuŋqueqä.” E ätpiyi, qu hŋqunä-hŋqunäŋi, iquauqä mbqä iwäsäupu, äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","E imäkäpiyitaŋi, Banäpasi iquesä, Soli iquesä, äväwatkuwi. Iquaqu äma äwiyi, quuvqä heqiyqä iu miqä iquau, äwikiyi. ");
INSERT INTO mcr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Iŋgaŋi, hiunji naqänäŋä, bretqä qo matäuqäŋgaŋi, qua Jutiya iu miqä Heroti iqu, ämaqä, Jisasi Iqueqä yoqeŋqä aquväqŋqä hŋquau, quvqä itquetŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iqu tquaŋgi, qu Jemisi, Jonä iqueqä käta-käŋguequeŋi, ipäqäyuŋitä pizqä qe äpäkkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Heroti iqu, Israitqä iqua, iqu ii imäkqaŋgqeŋqä aquvänä iqaŋgä äqunäqe, Pitä ique-pqe a kiqätpŋqä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Iqu iiŋä imäkäqe, ique guä äkiqiyäutä, qu iqueŋi, ique-iqueqä ätqäuqisäpu mipŋqä, mäkä-iqä 16 iquauqä hipa iu äwikqe. Heroti iqu, kŋuä tiiŋä indqäŋgqe. “Hiunji naqänäŋä Pasopa iqu timäuŋqiyä. Hiunji iqu, ae äpäwqaŋgaŋi, nyi, Pitä ique itmetmä, qokä-apäkä iquauqä hiŋuä iqi, kukŋuä mitmqeqä.” ");
INSERT INTO mcr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iŋgaŋi Pitä iqu, aŋiu guä pmetaŋga, ämaqä Jisasi Iqueqä yoqeŋqä aquväqŋqä iqua, Goti Hanjuwä Iqu, ique yätamäkqä vätŋqä, tääqä ätqämanmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hiunji Heroti iqu, Pitä ique kukŋuä mitätŋqä iqu timäutŋqäŋgaŋi, heatqäŋgaŋi, Pitä iqu mäkä-iqä hŋquaquiyqä awä iqi, hiqaqä guä hipa iŋgi-iŋgisa äqäyänä witaŋga, mäkä-iqä huiziquaqu, aŋä hänaqeu hiŋuä äqunyinyä, yäpaqä mäŋgisa ätqäumiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Iŋgaŋi maqänäŋi, Naqä Iqueqä eŋätqä hŋqu ätimäuqaŋga, guä kiqiyäueqä aŋä yäpä iŋgisaŋi, we qe äuŋgqe. Eŋätqä iqu, Pitä iqueqä yawä iqi ptqä äpäsätä ävauqumuatäqe, tiiŋä ätukqe. “Si pämä maqänä tqävä!” I tquaŋga, guä iquaqu iqueqä hipa iu äqiyänmiŋqe, qua mäŋi ewasqiyäukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Iŋgaŋi eŋätqä iqu, “Tqä aquvä ämäyätnä, tqä yukä ämuasmäŋqe, muasmävä” ätukqe. Iqu iiŋä imäkqaŋga, eŋätqä iqu, “Tqä gquä quäuqe, ämipnätnä, nyi qänaki nyivändiyä!” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","I tquaŋga, Pitä iqu, aŋä hiqŋqä iqueŋi ävämaŋi, eŋätqä ique qänaki qe äwivändkqe. Nätmatqä eŋätqä iqu imäkkqeŋqe, “Ii naqä-qakuiqä” kŋuä mämeqä itä, “Tä, wätqä äqunäŋänä” kŋuä indqäŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iquaqu, qŋqaŋä hŋquaquiŋi, mäkä-iqä hiŋuä äqämbu ätqäumiŋuwä iquau maqŋqä ämäwqätäyi, täkŋä qŋqaŋä yäŋänäqŋqä, guä kiqiyäueqä iuta, aŋä-himqä duŋqä uwqäŋqä ique timäuqaŋgiyäŋgaŋi, qŋqaŋä iqu kiqä-kiuä äutäŋgqe. Iquaqu yäpaqä mäŋgisa äwiyi, hänaqä hŋqueu äwiyi, maqänäŋi eŋätqä iqu, Pitä ique äväma äukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iŋgaŋi Pitä iqueqä kŋuä indqäŋqe, ätnäŋä iqi wimeqaŋga, iqu tiiŋi ätŋgqe. “Nyi näqŋqä täŋganä eqänä. Ii naqä-qakuiqä. Naqä Iqu, Iqueqä eŋätqä ique ändowatätä, nyi Heroti iqueqä hipa du pmetaŋga aŋgumä indmeqiyä. Nätmatqä, Israitqä iqua inyimäkpŋqä kŋuä indqäŋguwi, mänyimeqä yätŋqä diŋqä, indmeqiyä” ätkqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iqu näqŋqä e ämeqe, Mäliya, Jonä Makä iqueqä känäwqä aŋä iuŋqä äukqe. Iŋgaŋi iiyqä aŋä iuŋi, ämaqä kuapänäŋi, Naqä Iquenyqä tääqä ätäpu äpmamiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pitä iqu yäpaqäŋgisa ätqäuä, aŋä qŋqaŋä ptqä qäyätqätaŋga, apäkä wäuŋuä imäkqä hui, iiyqä yoqe Rota, ii qŋqaŋä wutemätä äpkqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ii Pitä iqueqä maŋi qätä äwiyätä, aquvänä itäqä-qe, qŋqaŋä mäwuteyqä itä, aŋgu maqänä äyäqe, “Pitä iqu äpätä, aŋä qŋqaŋä-täŋä täqi ätqäunä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kimaŋi qu, “Si qämä-qämä inyä” ätukuwi. Ga, ii yäŋänäqŋqä qe ätukqe. “Naqä-qakuänä etqänä. Iqu täqi ätqäunä.” Ga qu, “Ii, iqueqä eŋätqä iqueqä” ätukuwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Qu e tätqätaŋguwäŋga, Pitä iqu aŋä qŋqaŋä ptqä yqänä äqämiŋqe. Qu aŋä qŋqaŋä äwuteyäpiyäŋgaŋi, ique hiŋuä äqumbiyi, yäuŋuä naqä-qakuänä ikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Iŋgaŋi iqu, qu kukŋuä matqä qanyä pmapŋqä hipaetänä imäkätä, tiiŋä ätukqe. “Guä äkiqiyäuenjiyquwä aŋä duta, Naqä Iqu iiŋä-iiŋä imäkätä, ändma äpqiyä. He Jemisi iquesä, tatqä-guäka iquautä, awä tupŋqeqä” ätukqe. Iiŋä ätuäqe, Pitä iqu iquau ävämaŋi, hŋqäqinyqä äukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ziŋuitäŋi, Heroti iqueqä ämaqä mäkä-iqä iqua, Pitä iqu aaŋqä äqumbiyi, yäuŋuä ipu, “Tä änääŋäwä?” ätŋguwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Iŋgaŋi Heroti iqu, Pitä iquenyqä qävqä ipŋqä ätukqe. Qu iqueŋi, mämäqumueqä iqaŋguwäŋga, iqu ämaqä Pitä ique guä kiqiyäueqä aŋä iu ämimiŋuwä iquau, kukŋuä ämitätä, “Iquauŋi, pizqä päkpiyä” ätukqe. Qänakndaŋi, Heroti iqu qua Jutiya äväma, aŋä-himqä Sisariya iuŋqä äquveqätä, iu äpmakqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Iŋgaŋi Heroti iqu, ämaqä, aŋä-himqä Tayä pmeqä iuŋqätä, Saitonä pmeqä iuŋqätä, äwqä tnäŋä äwinymiŋqe. Qu, qua Heroti iqu ämimiŋqä iutaŋä ymisaŋä ämepu änmiŋuwiŋqä, kŋuä indqämbiyi, aquvä äqänäpu, iqutä kukŋuä tpŋqä äpkuwi. Qu ätimäupiyi, Blastusi, Heroti iqueqä aŋä hiqaqä wiqä iu miqä iqutä, äwqä naqä-hŋqunä imbŋqä kukŋuä ganä ätukuwi. E imäkpiyi, qu Heroti iquenyqä äwäpu, iqu iquauŋqä äwqä haŋuä winyätŋqä yatŋqä äwikuwi. ");
INSERT INTO mcr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Iŋgaŋi hea, Heroti iqu atäuŋuä ikqeuŋi, iqu ämaqä miqä iquauqä gquä äŋguänäŋi ipnätä, zä-hawä äŋguänäŋä iqueqänä pmeqeu äpmeqe, ämaqä iuŋi, kukŋuä naqänäŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","I tquaŋgaŋi, qu maŋä tiiŋä ätkuwi. “Maŋä tä, ämaqä hŋqueqä manä, goti hŋqueqeqä.” ");
INSERT INTO mcr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Qu e tätqätaŋguwäŋgaŋi, Heroti iqu qätä äwiyäqe, Goti Hanjuwä Iqueqä yoqe haqeqä mämamäuqä iqaŋgqeŋqä, maqänäŋi, Naqä Iqueqä eŋätqä hŋqu, ique qui imäkkqe. Qui e imäkqaŋga, piweqä hui, ique äŋgaŋguwäŋga, iqu qe äpäkoŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Naqä Iqueqä kukŋui, wäuŋuä yäŋänäqŋqä itŋqänä imäknätä, aŋä-himqä im-imä wätŋqä imäkŋgqe. ");
INSERT INTO mcr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Iŋgaŋi Banäpasi iqutä, Soli iqutä, iquaquiyqä wäuŋuä Jerusälemäŋi qäpu iyi, iqi ävämaŋi, aŋä-himqä Andiyokä iuŋqä, aŋgumä qe äukiyi. Iqi ävämesiyäŋgaŋi, iquaqu Jonä Makä ique, anä ätuma äukiyi. ");
INSERT INTO mcr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ämaqä, Jisasi Iqueqä yoqeŋqä Andiyokä iu aquvä äqänmiŋuwä iquauqä awä iqiŋi, Goti Iqueqä kukŋui hiŋuä-tqä hŋquatä, näqŋqä-vqä hŋquatä, anä äpmamiŋuwi. Hŋqu, Banäpasi ique. Hŋqu, Simiyonä, ‘Hiawiqueä’ ätmiŋuwä ique. Hŋqu, Lusisi, aŋä-himqä Sairini iutaŋä ique. Hŋqu, Mänainä, Heroti iqutä ymeqäŋga anä ikämaŋqä imiŋiyitaŋi, näueqä yqänä imäkŋga äumiŋiyä ique. Itaŋga hŋqu, Soli ique, iquayi. ");
INSERT INTO mcr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hiunji hŋqueŋi, iqua, Naqä Iqueqä yoqä haqeqä ämamäupu, buayä maŋqä pmetaŋguwäŋgaŋi, Dŋä Äŋguä Iqu, iquau tiiŋä ätukqe. “Nyi, Banäpasi iquesä, Soli iquesä, wäuŋuiŋqä äteqeqä. Wäuŋuä tä imäkiyŋqä, he iquaqui atäuŋuä inä ipiyä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iŋgaŋi, iqua buayä maŋqä ipu, Goti Hanjuwä Iquenyqä tääqä ätuäpu, iquaqui hipa haqeqä äwiyäpu, wäuŋuäŋqä ändowatkuwi. ");
INSERT INTO mcr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iŋi Dŋä Äŋguä Iqu, iquaqui dowatqaŋgi, iquaqu aŋä-himqä Selusiya iuŋqä äquveqäkiyi. Iqi ätimäyi, yimba ätkamäusinyä, qua eqä-pŋä awä iqiŋä hŋquenyqä, kiqä yoqe Saplusi, iuŋqä äquveqäkiyi. ");
INSERT INTO mcr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Qua iuŋi, aŋä-himqä Salamisi iu ätimäupiyi, iquaqu, Israitqä iquauqä aŋä aquväqŋqä iu ikisinyä, Goti Hanjuwä Iqueqä kukŋui, awä ätuäkämiŋiyi. Iquaqui yätamäkqä vätŋqe, Jonä Makä ique ätuma ikämiŋiyi. ");
INSERT INTO mcr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Saplusi iuŋi, iqua, qua eeqänäŋä iu qaŋä ikipu, aŋä-himqä Paposi iuŋqä äukuwi. Iqiŋi iquaqu, ämaqä Israitqä paaqä huitaŋä-huitaŋä imäkätä, hiŋuä quaŋgä-tqä hŋque äwimakiyi. Iqueqä yoqe, Banjisasi ique. Iqu paaqä imäkmiŋqeŋqe, Grikä iquauqä aŋä-kukŋuä tqä iqua, iquenyqe, “Elimasiuä” ätmiŋuwi. ");
INSERT INTO mcr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ämaqä iqu, ämaqeu miqä kiŋganäŋä Seŋgius-Paulusi iqutä, anä äpmamiŋiyi. Iqu ämaqä kŋuä äŋguä dinä indqäŋqä ique. Iŋgaŋi iqu, Goti Hanjuwä Iqueqä kukŋui qätä wiyätŋqä wiŋgaŋgi, Banäpasi iquesä, Soli iquesä, tääqä ätuätumakqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iiŋä etaŋgi, paaqä imäkqä Elimasi iqu, ämaqeu miqä iqu Jisasi Iquenyqä quuvqä heqiyätŋqä mäwiŋgaŋgi, iqu Banäpasi iqueqätä, Soli iqueqätä, wäuŋuä qui imäkätŋqä ikqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iŋgaŋi Dŋä Äŋguä Iqu, Soli iqueŋi, kuapänä ämuŋgqe. Iqueqä yoqä huizi, Poli ique. Dŋä Äŋguä Iqu, kuapänä muŋgaŋga, iqu Elimasi ique, hiŋuä yäŋänäqŋqä äqunä, tiiŋä ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Suqä quvqä eeqänäŋitä, quaŋgitä, maŋguä äkmnänä. Si suqä äŋguä eeqänäŋä iuqä mäkä-huŋqä-quki eäŋä-qae, Setänä iqueqä ymeqä iqukiyqä. Naqä Iqueqä hänaqä jänäŋä iuŋi, qui imäktŋqä itqäŋinyä. Suqä iiŋi mävquatämäuqe, suŋqä itqäŋinyä? ");
INSERT INTO mcr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Qätä nyiyä! Täŋgaŋi Naqä Iqu kima ktapätä, tqä hiŋui hea kuwimäkqaŋga, si mäptqe, hiŋuä mäquŋquä yakuinä pmatŋqinyä” ätukqe. Poli iqu iiŋä tquaŋga, maqänäŋi, qaquvqä eŋqä-paŋi, Elimasi iqueqä hiŋuä iuŋi, hea qe iwimäkkqe. Iŋgaŋi ique a ämasquämbŋqä asusua ikämiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ämiqä naqä iqu, nätmatqä tä timäuqaŋgi hiŋuä äqunäqe, iŋgaŋi iqu, Naqä Iqueqä kukŋuiŋqä, kŋuä kuapänä indqänätä, iquenyqä quuvqä eqäkqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iŋgaŋi Poli iqutä, ämaqä, iqutä anä äpmakuwä iquatä, Paposi ävämaŋi, qua Pambiliya-täŋä iŋginyqä, aŋä-himqä Peeka iuŋqä yimba äukuwi. Iqisaŋi Jonä Makä iqu, iquau ävämaŋi, Jerusälemäŋqä aŋgumä äukqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Qu Peeka ävämaŋi, qaŋä äupiyi, qua Pisindiya-täŋä iu, aŋä-himqä Andiyokä ätimäukuwi. Sämbatqä hiunji hapä pmeqäŋgaŋi, qu, Israitqä iquauqä aŋä aquväqŋqeu äpaquväpu, quamä qe äpmakuwi. ");
INSERT INTO mcr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Qu e pmetaŋguwäŋga, hŋqu, bukä, kukŋuä-suqeŋqä äqäkqeuta a täuqaŋga, ga hŋqu, bukä, Goti Iqueqä kukŋui hiŋuä-tqä iqua äqäkuwä iuta a ätäukqe. Iŋgaŋi aŋä aquväqŋqeu miqä iqua, ämaqä hŋque, Poli iquesä, ämaqä iqutä anä äpmamiŋuwä iquautä, tiiŋä tuätŋqä ätukuwi. “Ŋqä nyämaqäuä, he ämaqä iuqä äwqe, yäŋänäqŋqä imäkpŋqä kukŋuä-täŋuenä etaŋgutqe, he awä tpŋqeqä.” ");
INSERT INTO mcr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Iŋgaŋi Poli iqu pämä ätqäuqe, qu kukŋuä matqä pmapŋqä, hipa itä ämeŋä ämitä, tiiŋä ätukqe. “He ämaqä Israitqä iquendä, ämaqä huizi, Goti Hanjuwä Iqueqä yäpä iqi äpmeŋuwä iquendä, qätä nyipiyä. ");
INSERT INTO mcr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israitqä iquauqä Goti Hanjuwä Iqu, neqä atqä-awäkauŋi, Iqueqä ämaqä hipŋqä ätekqeqä. Qu Isipä iuŋi, ämaqä yakuä pmeqä eŋqä-paŋä pmetäŋguwäŋga, Iqu imäkqaŋgi, qu kuapänä eqiyämaŋguwiqä. Qänakndaŋi Isipä iutaŋi, Iqueqä yäŋänäqŋqä iuta itmakqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Iqu e itmeqaŋga, qu quväukuä 40, aŋä avqŋqä iu pmetaŋguwäŋga, Iqu iquauqä suqä hŋgisanä iqetaŋi, haŋä-iqä ämakmanmiŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Iŋgaŋi qua Kenanä iuŋi, hueqä-himqä kui-kui 7 äpmakäwätaŋguwä iuŋi, Goti Hanjuwä Iqu qui imäkätä, iquauqä quae Israitqä iquauqä wimänätŋqä qe äwikqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nätmatqä eeqänäŋi e imäkätqätaŋga, quväukuä 450 inä äpäukqeqä. Iqu qua ae äväqe, qänakndaŋi Iqu ämiqä naqä yakuinä mipŋqä iquau äteqa äumiŋqe. Iqu iiŋi, Iqueqä kukŋui hiŋuä-tqä Samueli iqu pmetqäŋgaŋqä imiŋqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iŋgaŋi qu Samueli iqueŋi, tii ätukuwiqä. ‘Ne ämiqä naqä hŋqueqä yäpä iqi näweqä pmetatuŋquänä, si ämaqä hŋque atäuŋuä isŋqeqä.’ Qu e tquaŋguwäŋga, Goti Hanjuwä Iqu, Soli ique ätekqeqä. Iqu Kisi iqueqä ymeqä eä, awiqu Benjämenä iquesaŋä ique. Soli iqu iquauŋi, quväukuä 40 iuŋi ämimiŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Goti Hanjuwä Iqu Soli iqueqä ämiqe, huätä ämamäutä, iqueqä aŋä metŋqe, Dewiti ique-mända ätekqeqä. Iquenyqe, Goti Hanjuwä Iqu awä tiiŋä ätukqeqä. ‘Nyi Dewiti, Jesi iqueqä ymeqä iqueŋi, hiŋuä ae äqunäŋqeqä. Iqueqä qeqä-quuvqä iuŋi, Nyaqä eŋqä-paŋä eä, iqu Nyi änyinäŋqä dunä imäkquäniqeqä,’ ätukqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Iqu hiŋuiqänäŋi kukŋuä guä ämäsäutä ätkqä-pa, Israitqä-qune häŋä aŋgu inemäkäqumuatetŋqä diŋqe, Dewiti iqueqä hueqä-himqä ekuwä iutaŋä hŋque ändowatkqeqä. Ämaqä Iqu, Jisasi Iqueqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisasi Iqu wäuŋuä mipäqiyqä änä etaŋgaŋi, Jonä iqu Israitqä eeqänäŋä iquauŋi, kŋuä äkunmäknäpu, asŋä qämbŋqä awä ätumiŋqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jonä iqu, iqueqä wäuŋui qäpu imäkätŋqä itäqäŋgaŋi, iqu tiiŋä ätukqeqä. ‘He kŋui, äänä hiyqiyä? Nyi tquŋgä? Nyi ämaqä, he hiŋuä äqämbu äpmeŋuwä iqunä, hmanjqä. Iŋäqe, he qätä nyipiyä! Ämaqä Hŋqu, nyinyqä qänaki änä äpäniqeqä. Iqueqä yukä ämuasmäŋqä gue, nyi meweqä yimniqeqä. Nyi ämaqä äŋgunä hmanjqä,’ ätukqeqä” ätukqe. ");
INSERT INTO mcr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Poli iqu tiiŋä inä ätukqe. “Ŋqä nyämaqäuä. He Aprähamä iquesa eqiyämaŋguwä iquendä, itaŋga he ämaqä huizi, Goti Hanjuwä Iqueqä yäpä iqi äpmeŋuwä iquendä, kukŋuä häŋä aŋgu inemäkäqumuatetŋqä iqu, Goti Hanjuwä Iqu nenyqä ändowatqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jisasi Iqu qua iu pmetaŋgaŋi, ämaqä Jerusälemä iu pmeqä iquatä, iquauqä ämaqä naqä iquatä, Iquenyqe näqŋqä äŋguänäŋi maeqä imiŋuwiqä. Itaŋga Goti Iqueqä kukŋui hiŋuä-tqä iquauqä bukä iuta, hiunji hapä pmeqä ique-ique a ätäumiŋuwä-qe, qu iiŋqä-pqe näqŋqä äŋguänäŋi maeqä imiŋuwiqä. Iiŋä dutaŋi, qu ‘Ämaqä Tqu äpäkonätŋqeqä’ ätukuwä iuŋi, Goti Iqueqä kukŋui hiŋuä-tqä iqua äqäkuwi, naqä-qakuä imäkkuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Qu Ique pizqä päkpŋqe, Iqueqä suqä quvqä hui, mämäqumueqä ipiyä-qe, ämaqä naqä kiŋganäŋä Pailoti iqueŋi, iqu äpäkonätŋqä diŋqä kiqutätmä äwikuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Qu nätmatqä eeqänäŋi, Goti Iqueqä kukŋui hiŋuä-tqä iqua, Iquenyqä hiŋuiqänä äqäkuwä-pa imäkpiyi, Iqueuä huiwi zä-huätatä hunätaŋgqeta ämepu, äma äwäpu, qua äptekuwiqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Iqu ae äpäkoŋgqä-qe, Goti Hanjuwä Iqu aŋgu ävauqumuatkqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Huinji kuapänäŋä iuŋi, ämaqä, Galili äväma Jerusälemäŋqä Iqutä anä äukuwä iquauŋi, Iqu äwimeqismiŋqeqä. Täŋgaŋi ämaqä iqua, Israitqä iquauŋi, Iquenyqä kukŋuä awä ätuätqäŋäuä. ");
INSERT INTO mcr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Kukŋuä äŋguä we-huŋqä-täŋi, ne awä tiiŋä etqunä. Kukŋuä, Goti Hanjuwä Iqu guä ämäsäutä, awiqukuau ätukqeuŋi, iiŋi naqä-qakuä imäkätä, awiqukuautaŋä hueqä-himqä iqune yätamäkqeŋqä, Jisasi Ique aŋgumä ävauqumuatkqe. Iiŋqe, apqä hŋquaquŋä iuŋi, Goti Hanjuwä Iqueqä kukŋui tiiŋä äqänänä. ‘Ŋqä Ymeqä Iqukiyqä, Nyi täŋgaŋi Tqä Tniqunä eqänä.’ ");
INSERT INTO mcr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Goti Hanjuwä Iqu, Jisasi Ique qua pteqeuta aŋgu ävauqumuatkqetaŋi, Iqu aŋgi mäwqä itä, pizqä miqä iquänä. Iiŋqe Goti Hanjuwä Iqu tiiŋä ätätä äqäkqeqä. ‘Nyi ämiqä naqä Dewiti ique äŋguä wimäkmqä ätukqä-pa, Nyi heŋi-pqä inä etätqäŋänä. Kukŋuä iiŋi, huizi iquau ämäwqätäutä, qäyunä timäuŋqiyä.’ ");
INSERT INTO mcr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iqu apqä huiziuŋi, tiiŋä-pqe ätätä äqäkqeqä. ‘Ämaqä, Si ätekŋä Iqu, pizqä yätŋqä hiŋuinä maquŋgä isŋiqä.’ ");
INSERT INTO mcr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dewiti iqu qua täu äpme, Goti Hanjuwä Iqueqä äwiŋqeunä qänaknä iqänjaqänäqe, äpäkoŋgaŋga, qu iqueqä huiwi, kawäkiqua qua äptnäŋuwä iu pteqaŋguwäŋga, pizqä qe ikqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Iŋäqe Ämaqä, Goti Hanjuwä Iqu qua iuta aŋgu ävauqumuatkqä Iqueŋi, Iqueqä huiwi pizqä miqä ikqeqä. ");
INSERT INTO mcr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ŋqä nyämaqäuä, iiŋqe he näqŋqä äŋguänäŋä tiiŋä hipŋqeqä. Ämaqä Iiŋä Iqueqä wäuŋuä dutaŋi, ämaqeuqä suqä quvqe huätä mamäuqä iuŋqe, ne awä etätqäŋunä. Tiiŋä-pqeŋqä näqŋqä äŋguänäŋä hipŋqeqä. Goti Hanjuwä Iqu henyqe, ‘ämaqä jänänäŋuaiqä’ täniqä diŋqe, kukŋuä-suqä Mosisi iqu ätätä äqäkqeu qänaknä iquwi, hiyaqä suqä quvqe huätä mämaemäuqä yäŋqiyä. Iŋäqe, Ämaqä Iiŋä Iqu, ämaqä, Iquenyqä quuvqä heqiyqaŋgpqe, Iqu iquauqä suqä quvqä eeqänäŋi, huätä ämamäutä, ‘ämaqä jänäŋuaiqä’ täŋqiyä. ");
INSERT INTO mcr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iŋi Goti Iqueqä kukŋui hiŋuä-tqä iqua, nätmatqä quvqänäŋiŋqä, ‘Äpäŋqiyä’ ätkuwi, he emeqäŋqä, hiŋuä äŋguänä äqunäpu wimasipiyä. ");
INSERT INTO mcr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Qu tiiŋä ätkuwiqä. ‘He ämaqä äkasuwä tqä iquenä, hiŋuä qumbiyä! Nyi nätmatqä huitaŋi, hiyaqä awä iqi imäkmqänä. Nyi nätmatqä imäkmqä iqaŋgmdqeŋqä, ämaqä hŋqu etqaŋgutqe, 