﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcq_vpl;
CREATE TABLE mcq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcq_vpl WRITE;
INSERT INTO mcq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hehakaho Jesu Keriso oni amuhija vejajina. Jesuho Teviti ꞌee Eparahami puni amuja. ");
INSERT INTO mcq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eparahamiho Aisiki oni oma. Aisikiho Jekapi oni oma. Jekapiho Jutaho ꞌee ꞌuꞌuhwaha ꞌahoꞌijihipuni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jutaho Jera upuni oma kaivo puni ohijaho Tema. ꞌEnakaivo Peresiho Hesarani oni oma kaivo Hesaraniho Rama oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ꞌEnakaivo Ramaho Amenatapu oni oma. Amenatapuho Nasioni oni oma. Nasioniho Saramani oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramaniho Poasi oni ome ꞌee Rehapiho Poasi oni oha. Poasiho Opeti oni oma. ꞌEne Rutiho huni oha Opetiho Jesi oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesiho Kini Teviti oni oma. Tevitiho Saramani oni oma. Huni oha marakoꞌa Uraia oni napara. ");
INSERT INTO mcq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ꞌEnakaivo Saramaniho Rehapoami oni oma. ꞌEne Rehapoamiho Apaija oni oma. ꞌEne Apaijaho Aisa oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ꞌEne Aisaho Jihosapati oni oma. ꞌEne Jihosapatiho Jorami oni oma. ꞌEne Joramiho Usaia oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiaho Jotami oni oma. ꞌEne Jotamiho Ehasi oni oma. ꞌEne Ehasiho Hesakaia oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ꞌEne Hesakaiaho Manase oni oma. ꞌEne Manaseho Emani oni oma. ꞌEne Emaniho Josaia oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ꞌEne Josaiaho Jekanaiane ꞌee ꞌuꞌuhwaha puni oma. Ijihuni vea kaji aneja rene pu ꞌeke Paparania tipurai vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ꞌEne ijí Paparania pu tipurai ꞌeka vaꞌari túnaꞌijaho Jekanaiaho Sieritieri oni oma renana. ꞌEjume Sieritieriho Jerupaparu oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerupaparuho Apaiuti oni oma. Apaiutiho Iraiakimi oni oma. ꞌEne Iraiakimiho Aisori oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ꞌEne Aisoriho Setaka oni oma. ꞌEne Setakaho Ekimi oni oma. ꞌEne Ekimiho Eriuti oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ꞌEne Eriutiho Eriesa oni oma. ꞌEne Eriesaho Mateni oni oma. ꞌEne Mateniho Jekapi oni oma. ");
INSERT INTO mcq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ꞌEne Jekapiho Josapi kaꞌene Meri oni paruijihuni oma. ꞌEnaꞌomo Merira Jesu kaꞌene Kerisona ꞌwavujaho nahenana. ");
INSERT INTO mcq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ꞌEnakaivo ea kaꞌene Eparahami oniji rena roe Teviti oniji ꞌeꞌunajaho amuja iropu ropu noꞌona noꞌona ijá hijara. ꞌEjumakame Teviti oniji rena roe Juapo aneja vene Paparani tipurai hijaji ꞌeꞌunajaho amuja kúꞌo ija iropu ropu noꞌona noꞌona ijá hijara. ꞌEne vukúꞌo ijí Juapo Paparania aneja vene tipurai hijaji rena roe Jesu Kerisora roani veiji ꞌeꞌunaji ꞌuꞌo amuja iropu ropu noꞌona noꞌona ijá hijara. ");
INSERT INTO mcq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ikaho Jesu Keriso ꞌunama icháꞌina kaꞌene nahejajina. Meri kaꞌene Jesuni ohijaho Josapira mwamuna kaivo pu maiꞌo paꞌwaꞌaraꞌeme Godoni ꞌAveni vejume hu hariꞌi nenana. ");
INSERT INTO mcq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ꞌEnakaivo hu mwaviꞌinijaho Josapina kaivo Josapiho hu nihoꞌo ꞌunama arira ꞌuraha onunaꞌomo Meri juhunijihunaꞌe masuani ranama vaꞌiro vwihanana. ");
INSERT INTO mcq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hu hine ijí vwihanani vea kajino Natohwi jihuni ona ojiꞌini roe navahi ijá ꞌwama Josapi kaꞌene Teviti oni harihakera a Meri aheve oni napara rehunijaho pajuꞌamana. Ijí hu hariꞌi nena kajaho Godoni ꞌAveni vejume hariꞌi nenana. ");
INSERT INTO mcq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ꞌEnaꞌomo hu naheja kamareje ara Huni ihijaho ꞌimareje Jesuna ꞌwaꞌamana kaivo Hura ehwahaka mapokijihi puni siseijaho niꞌajihe paꞌarehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ike iviamaa raka kaꞌene renukaho nitama Natohwi jihuni poropetijara ꞌwaramajara rene ikaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Heha! ꞌAsúri hariꞌi nenareje hariha naheꞌamajaho Huni iha ꞌimareje Imanueruna ꞌwahuna. Ijihuni maijaho Godi nú puꞌúmo hinu ꞌwaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ꞌEjume Josapi tatama ꞌurine Natohwi jihuni ona ojiꞌini ꞌwaramaja venarena napara kajaho ahemana. ");
INSERT INTO mcq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ꞌEnakaivo hu napara kajiꞌi paꞌuraha oꞌeme hu hina apena vaꞌo vaꞌo huni hariha amura kajaho nahejumakaviꞌi hu iha ꞌime Jesuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Vea kaꞌene Jesu Petirihemi Juta vaji nahejari veijaho Herotiho Kinia rena hinana. ꞌEꞌeme ea hami hami vwihajiꞌina vea ajimujaꞌi hijurepo Jerusaremi roara. ");
INSERT INTO mcq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pu aporama ijá ꞌiava Jua puni Kinia ichí nahejare? Nú Huni china kamaꞌi vea ajimujaꞌi kamareja ijihunaꞌe nú Hu oja mahareꞌe kaꞌi rou. ");
INSERT INTO mcq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Vea kaꞌene Kinia Heroti ijí henajaho oja hwaꞌusunahana. ꞌEjume Jerusaremi ora kaꞌene hu huꞌúmo hijajija ꞌuꞌo oja hwaꞌusunahara. ");
INSERT INTO mcq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ꞌEjumakame Herotira ꞌwaravume pirisitia mamaꞌina ꞌee Sikuraipi puꞌúmo ahuma roume hu pu aporama ijá ꞌiama ꞌÚ ichihi Keriso nahehune? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ꞌEjume pu hu ijá ꞌwava Poropetijara heha ꞌahi venajaho Petirihemi Jutia vajina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ja Petirihemi ora kaꞌene Jutia puni kwaa vaji hijujija ja nihoꞌo túchamaa parehuna kaivo joni ei pini maiꞌo ꞌajohiꞌina niꞌimaꞌura renareje Isureri ora ꞌajohahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Heroti ea kaꞌene hami hami vwihajiꞌiniji nesi aporame ijá ꞌiama Vea rakijiano ike chinakaho ajimane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ꞌEnarena hu pu irechamie ijá ꞌiama Ja vaꞌe Petirihemi ike Harihakaho samu vaꞌo kamare ona ranave nuni roe na ꞌuꞌo vuꞌe Hu oja mahuma ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ꞌEjume pu kini huni vuꞌa hejume parajume vaꞌeme china kaꞌene vea ajimujaꞌi ajima roajaho ajima roe asitaha ruvaꞌe ijí Hariha ꞌuꞌua kajara hinani huriji naminana. ");
INSERT INTO mcq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ꞌEjumakame pu ijí china kaji kamareja pu nihoꞌo mariꞌuma paravara. ");
INSERT INTO mcq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ꞌEne pu vaꞌe ijí niꞌúha kaji aruviꞌi kavajaho Hariha ꞌuꞌua kajaho oaha Meriꞌi hinana. ꞌEjumakame pu nitupari same oja Hu mahara. ꞌEne pu puni tuja usee swara korutia ꞌee senisia ꞌee ꞌwerua vajahara. ");
INSERT INTO mcq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ꞌEjume Godira navahi ꞌwaravume pu kúꞌo paꞌuname Herotira hinujaho vaꞌi kaivo pu ꞌunama ani vaꞌe puni ari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ꞌEꞌeme Natohwi jihuni ona ojiꞌini roe Josapi navahi ijá ꞌwama A iviamaa ꞌurine Hariha ꞌuꞌuakaho apene ꞌee oaha aheme aseha Ijipiti vaꞌamana. ꞌEnareje ijí hiꞌeje Nara kúꞌo ꞌwarava henareje ijiꞌa ꞌunama roꞌamana. Ijihuni maijaho Herotira Hariha ꞌuꞌua kaji ꞌanaꞌi ꞌahauꞌukamareꞌe saꞌiro venukúnina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ꞌEjume ijí naꞌia kajiano hu ꞌurine Hariha ꞌuꞌua kajaho apene ꞌee oaha aheme Ijipiti vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ꞌEnarena pu ijino Ijipiti hiꞌeme Heroti kwamana. ꞌEjumakame Natohwijara nitama poropeti ijá ꞌwaramana Nuni Hariha Ijipiti vaji Nara Hu ꞌumejuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ꞌEꞌeme Heroti hina ajihana ea hami hami vwihajiꞌinijija hua pisiviaraꞌe henarena nihoꞌo ajivume ea ꞌahoꞌa irechamie ijá ꞌiama Vaꞌe Petirihemi kasima kaꞌene maiꞌo juara noꞌoheꞌi papaꞌarejiꞌinijihi ꞌaniha ꞌiavume vaꞌara. Ea kaꞌene hua pisimiajipo ꞌwaravume henajaꞌinaꞌe vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ikaho nitama poropeti Jeramaiara ꞌwaramajara roe nimai renana. Hu ikaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ꞌEjume pu Rama vaji heꞌejuꞌe virisia vejiꞌi niramarume ꞌee eahura niꞌimaꞌura veꞌejuꞌe Recheru harihwapumu venana vo ea ꞌahopo hu oja somahuna areria pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ꞌEꞌejume ijiꞌa Heroti kwavumakaviꞌi Natohwi jihuni ona ojiꞌinijara roe ijí Ijipiti Josapi navahi ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ea kaꞌene ike Hariha ꞌuꞌuake ꞌanaꞌi venajaho nikwamanakúne a kúꞌo ꞌurine Hariha ꞌuꞌuakaho apene ꞌee oaha aheme ꞌunama Isureri vaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ꞌEjume hu ꞌurine ijí Hariha ꞌuꞌua kajaho apene oaha aheme Isureri vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ꞌEnakaivo Akireasira Heroti kaꞌene huni omijihuni tinia apene Jutia ꞌajohuma henarena Josapiho jumana. ꞌEjume Godira navahi ijá ꞌwama Karari vaꞌa ꞌwavume hu ijí Karari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ꞌEnarena hu vaꞌe ara iha Nasareti hinana. Hu ijá venajihuni maijaho poropetiepo raka kaꞌene ꞌwaravajija nimai reꞌavarono avanana. Pu ikaꞌina ꞌwaravara Hu Nasareti ora ꞌwahuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ijí vea kajino Joni Papitisita Jutia puni nechiꞌi riri ea Godoni vuꞌa najaha roana. ");
INSERT INTO mcq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hu ijá ꞌwaramana Taꞌaroha joni sisea amairie arira renama. Godoni arijihuni ꞌunama niroe tuꞌu renukúnina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Poropeti Aisea ꞌwavujara Hu rone ikaꞌina ꞌwaramana Hu nechiꞌi riri namine ijá ꞌumenu Natohwi jihuni ꞌunama amairie Huni ꞌunamijija arira reꞌavara ꞌumenu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ꞌEnakaivo Joni oni atehijija kameru huni sapasi vejaraꞌomo hu ijí same ꞌee huni ꞌaha muꞌoi charia apúsame ꞌee huni ꞌirumijaho pújúha ꞌee aneura rihijiꞌi inuna. ");
INSERT INTO mcq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ꞌEꞌeme ijihuni vea kajino ea kaꞌene Jerusaremi ora ꞌee Jutia ora ꞌee eaka mapoka kaꞌene Jotani rori hiju kajija niꞌaha kwino huni roara. ");
INSERT INTO mcq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ꞌEnareja pu puni sisea vwihane nahama Godi ꞌwaraꞌi kaivo aremamaa arevajihunaꞌe hu pu Jotani ꞌunirame toi samana. ");
INSERT INTO mcq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ꞌEꞌeme Hu kivume Parasia ꞌee Sajusia hura toi samaꞌamarono rouma kimarena hu pu ijá ꞌiama Ja tapara kaꞌene sisesa jihipuni harihija joni eha sisea niꞌimaꞌura kaꞌene túnaꞌi roujaho irara ja ꞌwaravukame ja juhame iki roajivare? ");
INSERT INTO mcq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ꞌIna rukina reꞌavara. Joni ꞌunama sahasijaho taꞌarohareje niareꞌi kaivo ea maiuꞌina reꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ja vwiha ikaꞌina pavwihaꞌavara. Nú Eparahami oni harihijaꞌomo nú areri rena hiju paroꞌavara kaivo Godira areri veje ike muna ikihipo Eparahami oni harihija rehuna. Ijihunaꞌe nú areri rena hiju paroꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iviamai taupa icha aneji namunaꞌomo icha kajija ꞌina maa pareꞌavajaho ꞌumareje ꞌuhue veni atoꞌaruhuna. ");
INSERT INTO mcq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na ja toa vaji samaume ꞌurijajihuni maijaho ja joni sisea vwihane temukavume nahama Godi ꞌwaraꞌikaꞌi aremama arevaji najaharejo ijihunaꞌe toa vaji samauta kaivo Ea kaꞌene nuni túnaꞌi roujara Godoni ꞌAvena ꞌee harurijiꞌi samahuna. Na Hu Huꞌúmo areria pana ꞌee nara Huni mumora hwana jahenahuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ꞌEnakaivo icha kaꞌene ꞌwitia aruma sirikuvujaho Huni ija tahi namunaꞌomo Hura ꞌwitia mutuuri ruhijijino mutuareje maijaho nianaꞌikaꞌi siseijijahija vena kaꞌene pautaruti saꞌikaꞌi namujiano atoꞌaruhuna. ");
INSERT INTO mcq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesuho Karari rene roe Jotani Jonira apene toi apúsamaꞌamarono roana. ");
INSERT INTO mcq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ꞌEnakaivo Joni rarene ijá ꞌwama Ara na toi apúsamiꞌamajaho areri reꞌena. ꞌÚ nara A toa vaji apúsamaꞌurono roane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ꞌEjume Jesura eha vene ijá ꞌwama Nú iviamaa ijá vehunijihuni maijaho ijá vejakame ꞌunama arimai rene mamai reꞌamarono avaꞌeja ꞌwamana. ꞌEjume Joniho Huni ira hene avamana. ");
INSERT INTO mcq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ꞌEꞌeme Jesuho toi apúsavume ꞌurijiꞌi kavume kahi akúpi ꞌahi vwicha reꞌeme Godoni ꞌAvena marahoꞌora punaꞌi jaima ꞌariha roe Huni haha ꞌahi ajimana. ");
INSERT INTO mcq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ꞌEꞌeme ira kahi akúpa ꞌahi rena roe ijá ꞌiama Ikaho Nuni Hariha kaꞌene Na oja mahujina. Na Hunijihunaꞌe nihoꞌo teamanimu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ꞌEꞌeme Godoni ꞌAveni vejume Jesuho vaꞌe nechiꞌi hiꞌeje ꞌavena sisei roe vena kaꞌamarono vaꞌana. ꞌEnakaivo Jesu ijí ꞌaura arema ");
INSERT INTO mcq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","hiꞌeme naꞌia mapoka (40) paꞌareꞌeme matumana. ");
INSERT INTO mcq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ꞌEꞌeme ꞌavena sisei roe ijá ꞌwama A Godoni Hariha reꞌamajaho veje munakaho puretia renama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ꞌEjume Jesura eha vene ijá ꞌwama Godoni ira vaji ijá ꞌwaramana Ea puretiapo reje majama hihuna pana kaivo ira kaꞌene Godira ꞌwaramujara reje majama hihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ꞌEjumakame ꞌavena sisea kajara Hua ahema ajima vaꞌe Temiporu atahuri ranamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ꞌEnarena hu ijá ꞌwama Areri Godoni ira vaji ꞌwaramajaꞌinaꞌe A Godoni Hariha reꞌamajaho mwamapene kami mweꞌi ꞌonava kavuma. Godoni ona ojiꞌinijipo A iji ꞌunarama apena ꞌariha vaꞌe kami ranamaakame muna A paninama kavuma ꞌwame ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ꞌEjumakame Jesura ijá ꞌwama Godoni ira vaji kúꞌo ikaꞌina ꞌwaramana. A oni Godi paapene vena kaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ꞌEjume kúꞌo ꞌavena sisea kajara Jesuho ahema vaꞌe huriꞌa kaꞌene nihoꞌo jopatuꞌuriji ajima vaꞌe kahi huri namiꞌi kaivo kwaa araka mapokakija ꞌee puni mamaijaho nahana. ");
INSERT INTO mcq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ꞌEnarena ꞌavena sisea Jesu ijá ꞌwama A nitupari same nuana vetie na oja miꞌamajaho ike uneunechaka mapokakija niꞌaha kwino nara A vajaꞌeju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ꞌEjume Jesura ꞌavena sisea kajaho ijá ꞌwama ꞌAvena sisea karera! Karori vaꞌa! Godoni ira vaji ꞌwarumajaho Natohwa kaꞌene oni Godijiru oja mahe Hunaru venaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ꞌEjume ꞌavena siseijaho Jesu ranaꞌikaꞌi vaꞌeme ona ojiꞌinapo roe Hu niꞌajahara. ");
INSERT INTO mcq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ꞌEnakaivo Jesuho hejume Joniho tipurai ranavuma hejiꞌi Hu Karari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ꞌEnarena Hu vaꞌe Nasareti areꞌikaꞌi vaꞌe Kapeniami hinana. Ijí ara kajaho soha rorina. Ara kajaho Sepurani ꞌwame ꞌee Napatarai ꞌwavuri vajina. ");
INSERT INTO mcq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ijaho Poropeti Aisea oni vaji ꞌwaramajara roe nimai nimai renu. Hu ikaꞌinaꞌe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ara kaꞌene Sepurani ꞌwame ꞌee Napatarai ꞌwavujija soha rori Jotani ona karaꞌi Karari kaꞌene Jenitaruepo hijujina. ");
INSERT INTO mcq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ea kaꞌene ijí nutuviꞌini hijujija hanajiꞌina niꞌimaꞌura kavara. ꞌEne ea kaꞌene nutuviꞌinaka nikwamasahujaꞌina rena hijujihi hanajiꞌina kajara hananiu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Vea kajiano Jesuho aneja vene vuꞌa ꞌwaramarena ijá ꞌiama Taꞌarohe joni sisea vwihane teamukave aremamai areꞌi kaivo ea maiuꞌina reha! Ijihuni maijaho Godoni ara niroe rori roa paranukúnina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ꞌEnarena Jesuho Karari soha rora kaji kahi vaꞌi kivume ea iha Saimani kaꞌene Pitana ꞌwavujiꞌo huni ꞌuꞌua kaꞌene Enituruna ꞌwavujiꞌo hine úa vesamapene roara. Ijihuni maijaho pu úa vesaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ꞌEjumakame Jesura pu ijá ꞌiama Nuni roajivakame jara ꞌúa vesavu kajaꞌinaꞌe Na ja najahe ja ea aheraꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ꞌEjume pu niꞌaha kwino puni namea irecha ꞌoꞌi kaivo pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ꞌEjume pu vaꞌi kivume vu ea ꞌahoꞌa Sepati oni harihija Jemisina ꞌwavujiꞌo Joni kaꞌene huni ꞌuꞌuijiꞌi emahwa puꞌúmo puni sisima vaji hine puni namea hwearikara. ꞌEjume Hu pu ꞌumenaana. ");
INSERT INTO mcq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ꞌEjume pu niꞌaha kwino puni sisima raname ꞌee omaha ranaꞌi kaivo pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ꞌEnarena Jesura vaꞌe Karari vaja kaji ꞌuraha ojiꞌi puni Sinakoku vaji Godoni arijihuni vuꞌa mai maiuꞌina najahana. ꞌEjiꞌi eaka mapokijihi atama ani aniꞌina kaꞌene renaꞌe ꞌee ꞌuniravajija vejume sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ꞌEjumakame Huni pinani ꞌurina vaꞌe Siria vaji vaꞌuma henarene eaka mapokijipo hahapo hianame ꞌee hahapo siseranie ꞌee ea kaꞌene ꞌavena sisei ajimaꞌe ꞌee ea kaꞌene mweꞌi ꞌarihe simaviꞌi name ꞌee ea kaꞌene irimaꞌina ꞌeka Huni roume Hura vejume maranie ꞌee sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ꞌEjumakame ijihunaꞌe ea nihoꞌo mapoka mapoka Hu tamatihara. Ara kaꞌene Hu tamatihajaho Karari ora ꞌee Jerusaremi ora ꞌee Jutia ora ꞌee ara kaꞌene Jotani toa one karaꞌi hijujija ꞌee Tikaparasi hijujija niꞌaha kwinu Hua tamatiha ojara. ");
INSERT INTO mcq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hu kimajaho ea mapoka mapoka Hua ꞌararihae ojuma kimarena vaꞌe huriꞌi ajime hiꞌeme Huni tisaiporua Huni roara. ");
INSERT INTO mcq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ꞌEjume Hu ijí aneja vene pu najaha ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ea kaꞌene puni ꞌavena pivusahujija iviꞌa teamanamama. Ijihuni maijaho Godoni arijaho iviꞌa puna renu. ");
INSERT INTO mcq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ꞌEne ea kaꞌene temukaꞌikaꞌi pasonahiiꞌinijija iviꞌa teamanamama. Ijihuni maijaho pu nihoꞌo oja sonahihuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ꞌEne ea kaꞌene masuani hijiꞌinijija teamanava. Ijihuni maijaho mweꞌa kakaho pumai rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ꞌEne ea kaꞌene ꞌunama mai matuname ꞌee toa punaꞌi huanavujija iviꞌa teamanava. Ijihuni maijaho pu nihoꞌo sonahihuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ꞌEne ea kaꞌene ea ꞌahoꞌa numiravujija teamanava. Ijihuni maijaho Godira pu ꞌuꞌo numirahuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ꞌEne ea kaꞌene puni oja ariramaa rejajija teamanava. Ijihunaꞌe pu Godi kahuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ꞌEne ea kaꞌene ea ꞌahoꞌa venauꞌe pu puꞌúmo matauviꞌinijija teamanava. Ijihuni maijaho Godira pu Huni harihija ꞌiꞌena. ");
INSERT INTO mcq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ꞌEne ea kaꞌene ꞌunama ariramaa ꞌuraha oꞌejuꞌe ea ꞌahopo siseꞌi ꞌahiujija pu teamanava. Ijihuni maijaho Godoni arijaho puna renukúne. ");
INSERT INTO mcq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nunijihunaꞌe erapo ja ira sisea ꞌwarame ꞌararihie vuꞌa sisea ani aniꞌina ꞌwarame ijá veja kiꞌavajaho ja teamanaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ja nihoꞌo teamaname ꞌee mariꞌuꞌavara. Ijihuni maijaho joni eha natohwa kahino akúpa ꞌahi namu. Ea ꞌahoꞌa nimarako poropetia kaꞌene hijajija siseꞌi ꞌahiajaꞌinaꞌe ja ꞌuꞌo siseꞌi ꞌahihuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ja areri mweꞌa kehuni misa. ꞌEnakaivo misa kajihuni vweijara paꞌareꞌipisa icháꞌinaꞌe veje kúꞌo vwea rejaꞌe? Misa ijaꞌinijija vwea paꞌanaꞌomo usekujukame emaapo momori tautiura. ");
INSERT INTO mcq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ja mweꞌa kehuni hanajiꞌina ara huriꞌa ꞌahi vejujija nihoꞌo vaja panavura. ");
INSERT INTO mcq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ꞌEne emaapo naheha ꞌejujaho pu paꞌeka vaꞌe siꞌuara vaja irechavura kaivo samai irechavura. ꞌEjuꞌe ea kaꞌene sea vaji hijujija hananiura. ");
INSERT INTO mcq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ijaꞌinaꞌe joni hanajiꞌinijara ea mapoka puni unaꞌi hananiꞌamana. ꞌEjakame pu kive maaru vejakame pu joni Oma kaꞌene kahi akúpa ꞌahi hinuji taꞌarohuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ja nihoꞌo ikaꞌina pavwihaꞌavara. Nara roukaho varapa tamana ꞌee poropetia hoꞌo veje paꞌareꞌamarono routa roꞌava. Na pu atoꞌarumaꞌi rohuna pana kaivo ijihipuni maiji veꞌi ꞌahiume routa. ");
INSERT INTO mcq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na nimai nimai ja ꞌwaravu ike akúpa mweꞌakaho niꞌaha kwino ijá paꞌarehuna. ꞌEnakaivo unenuꞌu pina maꞌuparitumaa ho maꞌuꞌua Godoni Iri jihuni vaji navujaho nihoꞌo papaꞌarehuna kaivo ijá naꞌeje uneunechaka mapokijija roe areri rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ea irara ike varapa tamana maꞌuꞌua ꞌene ꞌee ea ꞌahoꞌa najahe pu ꞌuꞌo ijaꞌinaꞌe veꞌavajaho hu Godoni ara nihoꞌo maꞌuꞌua ꞌiahuna. ꞌEnakaivo ea irara hene vene ea tamana kaji najaꞌavajaho hu Godoni ara ea natohwa ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na nimai nimai ja ꞌwaravu jara ꞌunama arira kaꞌene ojujara nihoꞌo arimai parenareje Sikuraipi ꞌee Parasi paasitaꞌamajaho ja nihoꞌo Godoni ara pavahuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nitama sahu jona ꞌwaramajaho ja nihejara. Ea paꞌanaꞌe kwaꞌamana. Ea irara ea ꞌanaa kwaꞌamajaho ꞌotua vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na nihoꞌo nimaa nimai ja ꞌwaravu. Ei pini napuraha ꞌajime ꞌee seꞌamajaho ea kajaho ꞌotua vetihuna. ꞌEe ea irara vweaha húmata paꞌana ꞌwaꞌamajaho hu ꞌuꞌo ꞌotua niꞌinijino vehuna. ꞌEe ea irara a ꞌvwiha paꞌana ꞌwaꞌamajaho hu veni vahuna arerina. ");
INSERT INTO mcq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ꞌEꞌeje a swara Godi maꞌiro vejiꞌi a vweuna siseꞌi ꞌahaaji vwihaꞌamajaho ");
INSERT INTO mcq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","swara kajaho ijá ranaꞌikaꞌi vukúꞌo ꞌunama vaꞌe vweuneꞌi ꞌwame amairiarejaꞌe ijiꞌa roe Godi swara maꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ꞌEne ei pini a ꞌotua apenaare ꞌotua vetaꞌiro veja kaꞌamajaho ja noꞌo ꞌunamu toi vaiꞌi a hu huꞌúmo vuꞌa ꞌwame amairiꞌavara. Ijihuni maijaho hu a apena vaꞌe ꞌotua vejiꞌina natohwi jihuni ija tahi ranamaa veꞌenakúne. ꞌEjakame ijí ꞌotua vejiꞌina natohwa kajara hirisima mihakame pu apena vaꞌe tipura ranama veꞌejakúne ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na nimaa nimai a ꞌwaravu a ijí tipurai hinuvaꞌo monia túchamaa ijaho maharene ro ꞌeꞌuhuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ikaꞌina ꞌwaramajaho a nihenana. A nihoꞌo ea pipuni napara paturaꞌamana ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ꞌEnakaivo Na ikaꞌina ꞌwaravu. Ei pini napara kame huni oja vaji ituꞌamajaho hu areri ijí napara kajaho nituramana rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ꞌEne oni nia manaꞌinijara venaꞌe a sisea veꞌamajaho nia kuha kajaho tajahena piꞌonave vaꞌamana. Ijihuni maijaho oni haha kwisu kajara veje oni haha kajaho mahoꞌo veni vahuna sisea. ");
INSERT INTO mcq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ꞌEne oni ija manaꞌinijara veje a sisea veꞌamajaho ijí ija kajaho ꞌuhua piꞌonave vaꞌamana. Ijihuni maijaho oni ija ꞌuhua apene piꞌonaꞌamajiana vo oni haha mahoꞌo veni vaji vahuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ꞌEne vu pina ijá ꞌwarumana. Ei pini huni napara ranaꞌamajaho hu niranamani heha vena mahuna ꞌwarumana. ");
INSERT INTO mcq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ꞌEnakaivo Na nimai a ꞌwaravu. Ea pipuni naparaꞌe parui pini ahemoꞌamajaho paruaha kajara areri naparaha kajaho ranahuna. ꞌEnajihunaꞌe parua kaꞌene huni napara kaji ranamajara veje hu parua pina veꞌamajaho hu sisea vehuna. ꞌEe ea irara napara kaꞌene ranaviꞌiniji ꞌwaꞌamajaho hu ꞌuꞌo sisea vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ꞌEne pinijaho nitama emaapo ꞌwaruvajaho ja nihejiꞌina. A raka nahama ꞌwaramajaho patuꞌamana kaivo Natohwi jihuni unaꞌi nahama ꞌwaraꞌamajaho veꞌamana ꞌúmara. ");
INSERT INTO mcq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na nimai a ꞌwaravu. A ikaꞌina paꞌwaraꞌamana Ichutoa pikiva hejuma paꞌwaꞌamana. Ijihuni maijaho ijaho Godoni ruhaꞌomo Godi ijí hinukúne paꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ꞌEne vukúꞌo ikaꞌina paꞌwaꞌamana. Mweꞌa ikenaꞌomo nimai ꞌwaravu paꞌwaꞌamana. Ijihuni maijaho ike mweꞌakaho Godira Huni mumora ijihuni toi irechamuna. ꞌEne vukúꞌo ikaꞌina paꞌwaꞌamana Jerusareminaꞌomo nimai ꞌwaravu paꞌwaꞌamana. Ijihuni maijaho Jerusaremi Kini Natohwi jihuni arakúne ijaꞌina paꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ꞌEnakúne a ikaꞌina paꞌwaraꞌamana Nuni húmata ikenaꞌomo nimaa nimai ꞌwaravu paꞌiaꞌamana. Ijihuni maijaho a nihoꞌo oni húmata kaji veje sajasaꞌina rene ꞌee aja rehuna nihoꞌo areria pana. ");
INSERT INTO mcq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ijaho ꞌavena siseijarahara a venauꞌe ira kajaho ꞌwaramukúne ijaꞌina paꞌwaraꞌamana kaivo manimaa ꞌiame ꞌee pana ꞌiꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nitama vuꞌa kaꞌene rena roajaho ikaꞌina ꞌwaruvara. Ei pini ea pinaꞌe ꞌanae nia kuha suꞌamajaho eha ꞌuꞌo ꞌanae nia kuha suꞌamana. ꞌEe ei pini ea pinaꞌe ꞌanae ea pipuni upaja hijaꞌusaꞌamajaho hu ꞌuꞌo ꞌanae upaja hijaꞌusaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ꞌEnakaivo na ja ꞌwaravu. Ei pini siseꞌi ꞌahiꞌiro veja kaꞌamajaho a eha pavetiꞌamana kaivo hu a noanu tahijiha kaꞌamajaho a vu taꞌarohe ropunaꞌi mahe ꞌaniꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ꞌEne ei pini oni setia apeꞌiroreje ꞌotui vetaꞌamajaho oni tapuka ꞌuꞌo tajahene maꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ꞌEne ei pini ja noꞌo maꞌuako ꞌaha josu vaꞌavarono ꞌejahaꞌamajaho ja noꞌo vaꞌareje nihoꞌo hura ꞌwaramajaho asima vaꞌe jopatuꞌura vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ꞌEne ei pini a unenuꞌu pina hu maꞌamarono ꞌwarava heꞌamajaho maꞌamana. ꞌEne ei pini oni unenuꞌu pina apena venareje vukúꞌo maꞌiro ꞌwarava heꞌamajaho maꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ꞌEne ja nihejara nitama vuꞌa kaꞌene ꞌwaravara. A ehuanaru oja miꞌi kaivo oni nakijihija senaꞌamana ꞌúvara. ");
INSERT INTO mcq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ꞌEnakaivo Na ijá ꞌiavo Ja joni naka oja miꞌavara. ꞌEne ea ꞌahopo ja siseꞌi ꞌahia kiꞌavajaho puni siporua ꞌonaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ꞌEnareje ja joni Oma kaꞌene akúpa ꞌahi hinujihuni harihija reꞌavara. Hu Huni vea vejuꞌe ea kaꞌene siseijihipuna rine ꞌee maijihipuna ꞌuꞌo rinuna. ꞌEne Hu vejuꞌe neha pine ea maijihipuna marane ea sisea vejiꞌini jihipuna ꞌuꞌo maranuna. ");
INSERT INTO mcq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ꞌEne ja ea kaꞌene oja ja mihujiru oja miꞌavajaho ja eha iraka apehune? Ea kaꞌene takisia apejiꞌinijija ꞌuꞌo ijaꞌina vejura. ");
INSERT INTO mcq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ꞌEne ja vwehu jonaru ꞌajoravujaꞌinaꞌe ꞌú ja ea ꞌahoꞌa ijaꞌinaꞌe asitahe ꞌajoravure? ꞌÚ Jenitarua ꞌuꞌo ijaꞌina pavejure? ");
INSERT INTO mcq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ijihunaꞌe joni Omi kahi akúpa ꞌahi ariramaa hinujihunaꞌe ja ꞌuꞌo ariramaa hiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ja hami vwihaꞌavara ea ꞌahopuni nia ꞌahi pu kiꞌavarono ja joni ꞌunama kaꞌene arimaiji veꞌava. Ja ijá veꞌavajaho joni Oma kaꞌene kahi akúpa ꞌahi hinujaho ja eha pamihuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ja ura ea uneunecha paꞌamaiji swara vajiꞌirono veꞌavajaho ja ea mapoka niꞌi niꞌi kiꞌavaroreje nipia apena hwasiꞌava. Ijihuni maijaho ea kaꞌene iraꞌasinijipo Sinakoku vaja ꞌee maꞌahi riri kaji ani ani vejakame ea ꞌahopo pu taꞌaroraꞌavarono ijaꞌina vejura. Na nihoꞌo nimaa nimai ja ꞌwaravu. Pu puni eha niapejara. ");
INSERT INTO mcq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ꞌEnakúne ja ea swara vajiꞌi veꞌavajaho paveje joni manaꞌinijara raka kaꞌene venujaho joni aniꞌinijaho kaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ꞌEnakúne ja ea uneunecha paꞌamaiji swara vajiꞌiro veꞌavajaho hemi vajihakame joni Oma kaꞌene hemi kimujara eha vajiꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ꞌEnakúne ja siporua ꞌoꞌi veꞌavajaho ja ea kaꞌene iraꞌasinijipo vejujaꞌinaꞌe paveꞌavara. Pu nihoꞌo Sinikoku vaja ꞌee maꞌaha riri namine siporua ꞌojura. Ruha kaꞌene ea mapoka niꞌi niꞌi kihuni tinijiano namine ojura. Na nihoꞌo nimaa ja ꞌwaravu pu puni eha niapejara. ");
INSERT INTO mcq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ꞌEnakúne ja siporua ꞌoꞌiro veꞌavajaho vaꞌe joni sei vaji vaꞌe vwicha kuꞌi kaivo joni Omijihuni siporua ꞌoꞌavara. Ijihuni maijaho ja ijí ruha hemi siporua ꞌojuꞌe kimujara Hu joni eha mihuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ꞌEnakúne ja siporua ꞌoꞌavajaho ja hine vuꞌa nikwinuꞌina kaji hura hara paꞌojiꞌi naꞌavara. Jenitaruepo Hu henarena rojiꞌi vuꞌa nikwinuꞌina kaji apena hura hara ꞌojiꞌi navura. ");
INSERT INTO mcq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ja ijí ea kajipo vejujaꞌinaꞌe paveꞌavara. Ijihuni maijaho ja raka pivusahareꞌe Amo jariꞌiro vejujija ja maiꞌo pajariviꞌini Hu nihena kimuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","13","ꞌEnakúne siporua ikaꞌina ꞌoꞌavara. Amo akúpi ꞌahi hino ese. Oni iha nihoꞌo nimaa nimaiꞌomo A veje nú Oni iha taꞌaroraha. A roa nú ꞌajohua hina. ꞌEne oni ura ijara akúpa ꞌahi venujaꞌinaꞌe mweꞌa ꞌuꞌo ijaꞌinaꞌe venama. ꞌIruma iviasi areri ihuniji vajúha. Ea nú siseꞌi ꞌahúuꞌe nú vwihana ꞌarevujaꞌinaꞌe nú ꞌuꞌo A siseꞌi ꞌahaukúne A vwihana ꞌarema. Nú nihoꞌo sisea vwihanareꞌe oja ꞌurinukúne A ꞌajohue niꞌajúhe nú sisea paveja. A ꞌajohuꞌina. A ajira rukina. Oni iha niꞌimaꞌura. A majama ijaꞌina. Amo ese. Nijina. ");
INSERT INTO mcq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ijihunaꞌe ja ea ꞌahopuni sisea vwihana areꞌavajaho joni Oma kaꞌene akúpa ꞌahi hinujara jona ꞌuꞌo vwihana arehuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ꞌEnakaivo ja ea ꞌahopuni sisea pavwihana areꞌavajaho joni Omiji ꞌuꞌo joni sisea pavwihania arehuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ꞌEnakúne jara ꞌaura areꞌavajaho era kiꞌavarono ura nia paajurasahe oꞌavara. Areri ea kaꞌene iraꞌasinijipo vejujaꞌinaꞌe paveꞌavara. ꞌEjuꞌukame eaka mapokijipo kima henareje pu ꞌaura arevara roꞌavarono avajura. Na nihoꞌo nimai ja ꞌwaravu. Pu puni eha niapejara. ");
INSERT INTO mcq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ꞌEnakúne ja ꞌaura areꞌavajaho joni ura nia some tuvaria pijahe matausahe oꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ꞌEjakame jara ꞌaura kaꞌene arevajaho ea hena kiꞌavara. ꞌEjakame joni Amo kaꞌene uneunecha mapoka hemi kimujara eha samai vajihuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ꞌEne uneunecha kaꞌene mamaijija ikaho mweꞌa paahuma irechama hiꞌavara. Ijihuni maijaho soapo ine ꞌee kapurapo ꞌuhusame ꞌee ea kaꞌene nesa apejiꞌinijipo nesi tirasame aruma vaꞌe nesi ꞌekahuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ꞌEnakúne joni uneunecha maa kajija kahino akúpa ꞌahi ahume irechava naꞌavara. ꞌEjakame soa ꞌee kapura paꞌuhusame ꞌee ea nesa paꞌekahuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ꞌEjakame joni uneunecha mamaa kajipo ruha kaꞌene navu kajino joni oja ꞌuꞌo ijí nahuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ꞌEnakaivo joni niijaho areri joni hahaka mapoka kajihi hananiiꞌina. ꞌEnaꞌomo joni nia kajara marana paranujaho joni hahaka mapokijaho hanana paranu. ");
INSERT INTO mcq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ꞌEnakaivo joni nia siseraꞌamajaho joni hahaka mapokijija nihoꞌo nutuma namu. ꞌEjakame ijí hanajiꞌina kaꞌene joni vaji namujara nutuꞌamajaho nihoꞌo niꞌimaꞌura nutuhuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ea kwinuꞌwi huni mamaꞌina noꞌoheꞌi rehuna nihoꞌo areri pana. Hu ea pina oja maꞌi kaivo ea pina siseꞌi ꞌahahuna. ꞌEne ea pina nihoꞌo ura rena paraꞌi kaivo ea pina kaꞌamajaho sema parahuna. Godi oja mahe ꞌee monia oja ꞌuꞌo ahuma mahuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ijihunaꞌe Na ja ꞌwaravukúne jara icháꞌina kaꞌene hihunijaho pavwihaꞌavara. Ja ikaꞌina pavwihaꞌavara nú ꞌiruma ꞌee toa iraki iꞌeja paꞌwaꞌavara. ꞌEnakaivo nú ꞌiruma ꞌee toa iraki iꞌeja pavwihaꞌavara. ꞌÚ ꞌirumijara niꞌina kaivo hiijaho pana raka? ꞌEe atehijipo niꞌina kaivo hahijaho pana raka? ");
INSERT INTO mcq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ꞌEnakúne ikaho vwihaha. Uka kaꞌene jaijasaha oju kivujija pu nihoꞌo puni ꞌina paꞌone ꞌee puni ꞌiruma paꞌeke rira kwino ahuma irechavura kaivo joni Oma kaꞌene kahi akúpa ꞌahi hinujara ꞌiruma vajihu. ꞌEnakaivo ja Godoni unaꞌijaho uka nihoꞌo asitaha parajara. ");
INSERT INTO mcq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A ea irara hine vwihananaviꞌi temuka apeꞌamajaho ꞌú ijí temuka kajara veje oni hia vea pina kúꞌo huri ranave hivaꞌena? ");
INSERT INTO mcq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ja rakijihunaꞌe ateharu vwihajo? Ike vwihaha! Sinara kaꞌene nechi ꞌurijajija ma opuipo ꞌurijura kaivo pu opuꞌina paharura vene ꞌee opuꞌina majikaria pamarasahura. ");
INSERT INTO mcq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ꞌEnakaivo na nimaa nimaa ja ꞌwaravu. Saramani oni pinana ichutoi namajaho huni haha sarira ꞌenana kaivo ijí hura sarira kaꞌene ꞌenajaho areri sinara puni nia vajaꞌe kimujaho paasimana. ");
INSERT INTO mcq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ike sinarakija iviasi rena navu. ꞌEnaꞌomo niari uhakiviꞌi ꞌekareje veni jae rehuna. Sinara kaꞌene nia vaja ijaꞌina kivujija Godira vejuꞌe niijaꞌina rejura. ꞌEnakaivo Godira vejuꞌe sinara marasahu kajaꞌinaꞌe ꞌú Hu areri jona ijaꞌina paveꞌena? Ea kaꞌene joni nimairoa maꞌuꞌumai kihije? ");
INSERT INTO mcq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ꞌEnakúne ja hine icháꞌinaꞌe hihuni ꞌunamiji saravujaho areꞌavara. Nú iraki iꞌeja? ꞌEe toa iraki iꞌeja? ꞌEne ateha iraki samoꞌeja? ꞌEne atehaka apúsahunijaho ichihi rena rohunijaho pavwihaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ike uneunecha kijahija Jenitaruepo vwihana vejura. ꞌEnakaivo joni Oma kaꞌene kahi akúpa ꞌahi hinujara uneunechaka mapoka kaꞌene ja pivusahujija nihe paranuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ꞌEnakaivo ja marakuꞌa Huni ara ꞌunamiji ꞌee Huni ꞌunama kaꞌene ariramaiji saravakame ijiꞌa uneunecha kaꞌene mweꞌakaki jara pivusahujaho Hura vajihuna. ");
INSERT INTO mcq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Niari raka kaꞌene rehunijaho pavwihaꞌavara. Ijihuni maijaho niara huni ahijijaho niarahuna. Vea kwinu kwinu puni ahija ꞌoiꞌoi navu. ");
INSERT INTO mcq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ja nihoꞌo ea ꞌahoꞌa panamahakame pu ja ꞌuꞌo panamahuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ijihunaꞌe Godira ꞌunama kaꞌene jara ea ꞌahoꞌa namahu kajaꞌinaꞌe Godi ja ꞌuꞌo ijaꞌinaꞌe namahuna. ꞌEje jara icháꞌina kaꞌene ea vajiꞌavajaho ijaꞌinaꞌe Godi ja vajihuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","A rakijihunaꞌe vweu puni nia vaji taura kaꞌene namujaho kama ꞌwaraꞌi kaivo oni nia vaji natohwaka namujaho marako pakama amairio? ");
INSERT INTO mcq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A raka vene oni nia titi taura kaꞌene namu kahaꞌajaho papiꞌonaꞌi kaivo napuru puni nia vaji taura kaꞌene namujaho kama ꞌwaramo? ");
INSERT INTO mcq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ꞌEnakúne iraꞌasinakere marakuꞌa oni nia vaji taura kaꞌene namu kahaꞌajaho piꞌonaꞌi kaivo ijiꞌa napuru puni nia titi taura kajaho ape piꞌonaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ꞌEne ja uneunecha kaꞌene ariramaijija ꞌua pavajiꞌavara. Ijihuni maijaho pu taꞌarohareje mwatumiꞌejakúne pavajiꞌavara. ꞌEne joni uneunecha mamaijijahija maha pavajiꞌavara. Ijihuni maijaho pu maꞌeka tautiꞌejakúne pavajiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ꞌEnakúne ja Godoni siporua ꞌone jarima apena vaꞌakame Hu ja vajihuna. ꞌEne ja sarama apena vaꞌavajaho ja kihuna. ꞌEne ja vwicha ꞌanaꞌanaa apena vaꞌavajaho Hu tirasahuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ꞌEne ea irara siporua ꞌone jarima apene vaꞌamajaho hu ijihuni mai ꞌekahuna. ꞌEje ea irara ꞌunama kaji sarama apene vaꞌamajaho hu piunahuna. ꞌEje ea irara vwicha kaji ꞌanaꞌanaa apena vaꞌamajaho vwicha tatiranamahuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ea irara harihuni puretiaꞌe ꞌwaraꞌipisa hu muni mahaꞌe? ");
INSERT INTO mcq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ꞌEne hu kija jariraꞌipisa hu tapari mahaꞌe? ");
INSERT INTO mcq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ꞌEnakaivo ja ea siseakija joni harihija uneunecha mamairu vajihuraꞌe reꞌavajaho ꞌú joni Oma kaꞌene akúpi ꞌahi hinuji jariꞌavajaho Hu uneunecha mamairu pavajihuna raka? ");
INSERT INTO mcq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ꞌEne ja ura ea ꞌahopo jona venaꞌavarono ura renaujaꞌinaꞌe ja ura renaꞌeje ea ꞌahopuna venaꞌavara. Ikehuni maijaho varapa tamana ꞌee poropetiepo najuhara. ");
INSERT INTO mcq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ꞌEnakúne vwicha kaꞌene ira mwahatitijino vaha. Ijihuni maijaho vwicha kaꞌene natohwijaho ꞌunama niꞌimaꞌura kaꞌene veni vaꞌujina. ꞌEjuꞌe ea mapokaꞌe ijihuna kajino vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ꞌEnakaivo vwicha maꞌuꞌua kajaho ꞌunama kaꞌene majama hihunijina ꞌee kikisimaꞌuraꞌomo ea kwinu kwino piunavura. ");
INSERT INTO mcq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ꞌEnakúne poropetia iraꞌata najahiꞌinijija hami kiꞌavara. Pu joni roujaho sipia puni atehi same rohuna. ꞌEnakaivo puni vajijaho nihoꞌo ꞌua neꞌa saꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ꞌEnaꞌomo puni ꞌinijino samai kihuna. ꞌÚ ea ꞌwija ajina ꞌahi ꞌekure? ꞌEne ea mitota vaji matakina nitehure? ");
INSERT INTO mcq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ꞌEnajihunaꞌe icha kaꞌene maijija ꞌina maa rejura. ꞌEjuꞌe icha kaꞌene siseijija ꞌina sisea rejura. ");
INSERT INTO mcq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ꞌEjuꞌe icha kaꞌene maijija ꞌina sisea parejuꞌe icha kaꞌene siseijija ꞌina maa parejura. ");
INSERT INTO mcq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ꞌEne icha kaꞌene ꞌina maa parejujija ꞌuma veni jaura. ");
INSERT INTO mcq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ꞌEne puni ꞌinijino samai kihuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ꞌEnakaivo ea mapoka kaꞌene Na Natohwe Natohweru ꞌwivujija Godoni ara pavahuna kaivo ea kaꞌene Nuni Oma kaꞌene akúpa ꞌahi hinujara raka kaꞌene Hu ura renujiru veꞌavajipo vahuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ꞌEnaꞌomo ijihuni vea kajara roꞌejaꞌe ijiꞌa ea mapoka Na ikaꞌina ꞌwarihuna Natohwe Natohwe ꞌú nú Oni ihi vuꞌa ꞌwaravure? ꞌEne Oni ihi ꞌurahiꞌi ꞌavena sisea ajimaꞌinijija siomahure? ꞌEne uneunecha mapoka ea areri pavehuna nú vejure? ꞌwihuna. ");
INSERT INTO mcq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ꞌEjakame Na ikaꞌina samamai pu ꞌwarahuna Na nihoꞌo ja pakivurakúne usema vaꞌaha ea sisea vejiꞌinakije! ");
INSERT INTO mcq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ꞌEnaꞌomo ea irara ike Nuni vuꞌake hene veꞌamajaho hu areri ea kaꞌene vwiha mamai vwihajiꞌinijara araꞌe muna ꞌahi vena hinujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ꞌEnaꞌomo nehi pine sai hirame ꞌee puri hiramujaho ara kajaho ninavume patiraꞌusahuna. Ijihuni maijaho ara kajaho muna ꞌahi vejajihunaꞌe patiraꞌusunahana. ");
INSERT INTO mcq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ꞌEnakaivo ea irara Nuni vuꞌa henareje paveꞌamajaho hu areri ea kaꞌene hami pavwihajiꞌina kaꞌene huni ara ajara ꞌahi venajaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ꞌEnajihunaꞌe neha pine sai hirame puuri ꞌeꞌune ara kajaho ꞌanaume ꞌonajaho maijihi nihoꞌo aniꞌina tiraꞌusunaha ꞌonana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ijí vuꞌa kaji Jesura ꞌwarame paꞌarejume ea mapoka mapoka ijí Hura najaha kaji hejajaho oja hwaꞌusunahara. ");
INSERT INTO mcq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ijihuni maijaho Hu nihoꞌo harurijiꞌi pu najahana areri Sikuraipiepo najahujaꞌina pana. ");
INSERT INTO mcq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ꞌEnarena Hu kahi huriꞌi rena roe ariꞌeme ea nihoꞌo mapoka mapoka Hu ꞌarariha vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ꞌEꞌeme ea pina reporosia rukini roe Huni unaꞌi nitupari same ijá ꞌwama Natohwe A ura renaꞌamajaho venie na maraniama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ꞌEjume Hu ija ea kaꞌene reporosia rukina kajihuni haha ꞌahi ija ranaꞌi kaivo ijá ꞌwama Na ura reniunaꞌomo maranahuna ꞌwavume reporosia kajaho niꞌaha kwino paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ꞌEnakaivo vaꞌe oni haha Pirisiti nahe ꞌee Mosisira nitama najaha jaꞌinaꞌe swasa veje ea mapoka oni reporosia paꞌarenajaho hena kaꞌavara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ꞌEꞌikaivo Hu vaꞌe Kapeniami ꞌeꞌuꞌeme sorutia puni namiki kajara roe Hua piuname niꞌajaꞌamarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ꞌEne hu ijá ꞌwama Natohwe nuni pwea pina atami niꞌimaꞌuri ꞌunavuꞌe nihoꞌo areri pavarime ꞌee haha natohwa hiꞌejuꞌe namu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ꞌEjume Jesura ijá wama Nara vuꞌareje veje marahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ꞌEjume sorutia namikia kajara eha vena ijá ꞌwama Natohwe na ea sisea ijihunaꞌe Ara nuni sei vuhunijaho nihoꞌo areri panakúne ma iri ꞌwaraꞌeje nuni pwea kajaho maranama. ");
INSERT INTO mcq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na sorutia kaivo na ea kaꞌene na ꞌajohiꞌini jihipuni harina. ꞌEne na ꞌuꞌo sorutia puni natohwaꞌomo nara ea pina vaꞌa ꞌwavujaho hu vaꞌuna. ꞌEne vukúꞌo ea pina roa ꞌwavujaho hu rouna. ꞌEne na nuni pweaꞌe a ike vena ꞌwavujaho hu venuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ꞌEjume Jesuho ijí henarena teamaꞌeme ea kaꞌene Hua ꞌarariha vaꞌajija ijá ꞌiama Na nimaa nimaa ja ꞌwaravu. Ike Isureri opuni vajakino ei pini ijaꞌina nimaa rohuna nihoꞌo areri paꞌana kavu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ikaho vwihaꞌavara. Ea nihoꞌo mapoka mapoka veaꞌe ajimujaꞌi rena roe ꞌee vea vaꞌonujaꞌi rena roavajipo Godoni ara kaꞌene Eparahami ho Aisiki ho ꞌee Jekapi ho ijano ruha kaꞌene hijujaho pu puꞌúmo ahuma hihuna. ");
INSERT INTO mcq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ꞌEnakaivo ea iki mweꞌi hiꞌavajija samai atoꞌarumaꞌe nutuviꞌinijino vaꞌe niramarume upaja jaꞌiꞌujiꞌi nahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ꞌEjume Jesura sorutia puni namikia kaji ijá ꞌwama Raka kaꞌene a nimai ronujara veje oni pwea maraꞌenakúne vaꞌa ꞌwamana. ꞌEjume ijí huni pwea niꞌaha kwinu sonanana. ");
INSERT INTO mcq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ꞌEꞌeme Jesuho Pita oni sei vaiꞌi kavume Pita oni jura paranahijaho atama niꞌimaꞌuri ꞌuname haha ohoa reꞌeme namana. ");
INSERT INTO mcq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ꞌEjume Hura iji ꞌunama apene ꞌurijume niꞌaha kwinu huni atama kaꞌene haha ohoa kajaho paꞌarejume hu ꞌurine mataume ꞌiruma amairia vajihume ijara. ");
INSERT INTO mcq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ꞌEꞌeme ijihuni nusireijino ea kaꞌene ꞌavena siseapo ajimaꞌinijija aherame ꞌeka Jesuni roume Hura ꞌavena sisea kajija ꞌwaraviꞌi sioma atoꞌarumana. ꞌEne ea kaꞌene atama ꞌuniraviꞌinijija venaume puni atama paꞌarenaana. ");
INSERT INTO mcq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nitama Godira poropetia Aisea oni vaji ꞌwaramajaho nimaa nimaa renu. Hura núni atama ani aniꞌina ꞌee haha hiana ꞌekana ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ꞌEnarena Jesura eaka mapoka kaꞌene Huni rori hija kaji kimarena Hu toa ropunaꞌi vaꞌiro ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ꞌEjume Sikuraipi pini ijá ꞌwama Najuhuꞌine na A huꞌúmo A ichihichihi vaꞌamajaho na vuhuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ꞌEjume Jesura ijá ꞌwama Achimina mweꞌi vaji ahejura ꞌene uka nesa rukina kaivo Ema Puni Harihijara ruha kaꞌene Huni húmata ranave siheria vehuna paꞌana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ꞌEjume Huni tisaiporu pini ijá ꞌwama Natohwe ijinakúne asinamie na marako vaꞌe nuni oma apene kwananavuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ꞌEnakaivo Jesura ijá ꞌwama Na ꞌararihia roꞌi kaivo ea kaꞌene kwaviꞌina kajaho makaꞌeje opu apena vaꞌe ranava ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ꞌEꞌikaivo Hu vaꞌe sisima vaji ajivume Huni tisaiporu pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ꞌEꞌeme soha kajaho nihoꞌo ajira amenarena sisima kajaho siseraꞌi venana kaivo Jesuho nenana. ");
INSERT INTO mcq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ꞌEjumakamarena Huni tisaiporuepo ꞌurina vaꞌe saiꞌi ijá ꞌwava ꞌUrina! Núni Natohwe nú kwamasaꞌi vejukúne ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ꞌEjume Hu ijá ꞌiama Nimairoa maꞌuꞌu maikije ja rakijihunaꞌe juvo? ꞌiꞌi kaivo ijiꞌa ꞌurina ꞌwaravume puura kaꞌene hirame ꞌee soha kaꞌene amenajaho mahoꞌo paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ꞌEjumakame pu oja hwaꞌusunahaꞌeme ijá ꞌwava Hu ea iraka saꞌinaꞌomo Hu ꞌwaravume puura ꞌee soha Huni ira hejare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ꞌEꞌejume sisima kajaho roe toa ropunaꞌi Katarini roiꞌi kivume ea noꞌoheꞌi ꞌavena sisei ajimaukame pu vaꞌe euchi hinone pu nihoꞌo ajisimaꞌora ꞌee ani ani vejukame ea ꞌunama kajihuna kajaho paojuraꞌomo Hu vaꞌe ijihi piunimana. ");
INSERT INTO mcq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ꞌEjume ea kajipo ajira emaavajiꞌi ijá ꞌwava Godoni Harihe A raka nú vetúꞌena? Vea kaꞌene Ara núa ruruhunijaho maiꞌo paroꞌeme A nú ruruꞌirono roane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ꞌEnakaivo ijiha kajakaru maha mapoka namijara. ");
INSERT INTO mcq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ꞌEjumakame ꞌavena sisea kajipo Jesu jarime ijá ꞌwava A ura nú sioma atoꞌarumuhunaꞌe reꞌamajaho atoꞌarumuꞌe nú vaꞌe maha kahehi ajima ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ꞌEjume Jesura ijá ꞌiama Vaꞌajiha ꞌiavume pu niꞌaha kwinu ariha vaꞌe mahaka mapoka kajija ajimaume pu niꞌaha kwinu vaꞌe rarahi arihe toi imwasamiara. ");
INSERT INTO mcq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ꞌEjumakame ea kaꞌene ijí maha kaji ꞌajohiꞌinijipo ninukujaha vaꞌe ari useme ijí maha kajihipuni vuꞌa ꞌwarame ꞌee ea kaꞌene noꞌoheꞌi ꞌavena sisei ajimaꞌini jihipuni vuꞌa ꞌuꞌo ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ꞌEjumakame eaka mapoka kaꞌene ara kajiꞌurijipo niꞌaha kwinu niana roe ijí Jesuho kamareja ꞌejahae ijí puni kwaa kajaho areꞌi kaivo ꞌurine ani vaꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ꞌEjumakame Jesuho vaꞌe sisima vaji ajime vaꞌe toa one karaꞌi Huni ari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ꞌEꞌejume ea ꞌahopo ea pina atami ꞌunamarena huni ꞌata nihoꞌo ajuarananaꞌomo pu huni suhijiꞌi apene Jesuni roume Hu kimajaho pu nihoꞌo nimaa nimaa rojuma kimarena Hu ijí ea kajaho ijá ꞌwama Nuni harihe oja pahianaꞌamana. Oni sisea nipaꞌarenukúne ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ꞌEjumakame Sikuraipiepo ijí ꞌwamapene ojiꞌi ijá ꞌwava Hu hine Godi mataha ꞌwaramu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ꞌEjume pu raka kaꞌene vwihaja kaji Jesura kimarena Hu pu ijá ꞌiama Ja raka vene hine ꞌunama sisea ani ani vwihajo? ");
INSERT INTO mcq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ꞌÚ ꞌunama icháꞌinijara samaumaaꞌe a oni sisea niparanu ꞌwaꞌeju ho a ꞌurine namina vaꞌa ꞌwaꞌejo? ");
INSERT INTO mcq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ꞌEnakaivo jara ijí hena kaꞌavarono ijihunaꞌe Ema Puni Harihijara iki mweꞌi roe sisea vwihana arehuni harurijiꞌi roana ꞌiꞌi kaivo ea kaꞌene ꞌata ajuarajiꞌina kajaho ijá ꞌwama ꞌÚrine oni suha apene ari vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ꞌEjume hu ꞌurine huni sei vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ꞌEjumakame ea mapoka ijí Godoni harura kaji kamareja Godi taꞌarohara. Ijihuni maijaho Godira harura kajaho emaa vajihana. ");
INSERT INTO mcq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ꞌEꞌeme Jesuho ijí ara kaji rene vaꞌi kavume ea pina kaꞌene huni iha Matiuna ꞌwavujaho takisia apejuri seijino hinana. ꞌEjume Hu ijá ꞌwama Na ꞌararihie roa ꞌwamana. ꞌEjume hu ꞌurina ꞌarariahae Hu huꞌúmo vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ꞌEnarena Jesuho Huni tisaiporu puꞌúmo sei vaji hiꞌeme ea mapoka kaꞌene takisia apejiꞌina ꞌee ea kaꞌene sisea vejiꞌinijija roe pu puꞌúmo ahuma ꞌiruma ijara. ");
INSERT INTO mcq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ꞌEꞌeme Parasiepo kamareja pu Huni tisaiporu aporame ika ꞌiava Irakijihunaꞌe joni Najahiꞌinakaho ea kaꞌene takisia apejiꞌinijija ꞌee ea kaꞌene sisea vejiꞌinijihi puꞌúmo ꞌiruma ijiꞌi hino? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ꞌEjume Hu ijí henarena ijá ꞌiama Ea kaꞌene atama paꞌuniraviꞌinijija juketa pasaravura. ꞌEnakaivo ea kaꞌene atama ꞌuniraviꞌinijipo pupusu saravura. ");
INSERT INTO mcq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ja ma vaꞌajimareje Godoni ira vaji ikaꞌinaka ꞌwaramaji sama kaꞌavara. Na emaapo temukivu kaivo Na swasa vehuna senimu. Ijihuni maijaho Na ea mamaaꞌe ꞌekaꞌi rohuna pana kaivo ea sisea punijihunaꞌe Na routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ꞌEꞌejume Joni oni tisaiporu Jesuni roe ijá ꞌwava Irakijihunaꞌe núa ꞌee Parasia ꞌaura arevu kaivo Oni tisaiporu ꞌaura paarevo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ꞌEjume Hu ijá ꞌiama ꞌÚ ei pini napasi neꞌi ꞌahaꞌeje hu ehwa puꞌúmo hiꞌipisa ijihunaꞌe chora hija raka? Nihoꞌo pana. ꞌEnakaivo ea kaꞌene ijí napasi nena kaji apena vaꞌe hu kúꞌo pu puꞌúmo pahija kamareje ijiꞌa pu ꞌaura arehuna. ");
INSERT INTO mcq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ꞌEne ea ꞌahoꞌa ateha sahasapo napavujaho pu ateha maiuꞌina puni pwina paꞌeke suhura. Ijihuni maijaho ijí suhakaviꞌi ijí niꞌajahe niꞌimaꞌura napaꞌamarono pasuhura. ");
INSERT INTO mcq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ꞌEne vukúꞌo ꞌwainia maiuꞌina hanuha sisa sahasa vaji veriꞌavajaho hanuha sisa sahasa kajaho napama arihuna. ꞌEje hanuha sisa sahasa kaji ꞌuꞌo siserahuna. ꞌEnakaivo hanuha sisa maiuꞌina vaji ꞌwainia maiuꞌina veriꞌamajaho marahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ꞌEꞌeme Jua puni ꞌajohiꞌina natohwijaho roarene Huni unaꞌi nitupari saviꞌi ijá ꞌwama Nuni ꞌapaja iviamajai kwamanakúne roe Oni ija huni haha ꞌahi ranave ꞌurinama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ꞌEjume Jesuho ꞌurine hu huꞌúmo vaꞌume Huni tisaiporu ꞌuꞌo pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ꞌEꞌeme napara pina ꞌaa vuraviꞌina juara iropu ropu noꞌoheꞌi paꞌarenanaꞌomo Jesuho vaiꞌi pakaꞌeme hu túnaꞌi rou vaꞌo ija joranajaho vaꞌe Huni ateha uri vwemana. ");
INSERT INTO mcq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ijihuni maijaho hu huhusu ijá rona Na Huni ateha ura kaji vweꞌujaho na maraniꞌena ronarena ijihunaꞌe vwemana. ");
INSERT INTO mcq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ꞌEjume Jesura aroma napara kajaho kaviꞌi ijá ꞌwama Nuni ꞌapajakera oja pahianaꞌamana. Ijihuni maijaho ara nimai ronajara vejuꞌe maranaukúnina ꞌwamana. ꞌEjume napara kajaho niꞌaha kwinu maranana. ");
INSERT INTO mcq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ꞌEjumakaviꞌi Jesuho ijiꞌa vaꞌe ea natohwa kajihuni sei vaiꞌi kivume ea mapoka hine hurisia hwasihe ꞌee hine irunoꞌa apejiꞌi kúrúhwa ani rejara. ");
INSERT INTO mcq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ꞌEꞌeme Hu ijí va ajime ijá ꞌiama Ariha vaꞌaha! Ike napaiseakaho pakwamana kaivo hu nenu ꞌiamana. ꞌEjume ea mapoka Hu ijahara. ");
INSERT INTO mcq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ꞌEjumakiviꞌi eaka mapoka kajaho vejume maꞌahi vaꞌeme Hu ijí aruma vaꞌajino ijí napaisea kajihuni iji ꞌunamapene ꞌurijume hu ꞌurinana. ");
INSERT INTO mcq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ꞌEjumakame ijihuni pinana kajara renapene arara kajiano vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ꞌEꞌeme Jesuho ijí ara kajaho areꞌi kaivo vaꞌeme ea noꞌoheꞌi nia supaviꞌinapo Hua ꞌararihaiꞌi ijá ꞌumeja Teviti oni harihakera nú numiruma ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ꞌEjume Jesuho vaꞌe sei ajiꞌeme ea kaꞌene nia supaviꞌina kajija noꞌoheꞌi ijí vaꞌume Jesura ijá ꞌiama Nara ike veje maranihunijaho ja nimai rojo? ꞌiamana. ꞌEjume pu ijá ꞌwava Natohwe nú nimai roju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ꞌEjume Hu puni nia ꞌaha kajino ija ꞌuniraviꞌi ijá ꞌiama Jara nimai rojujara venauꞌe maraniu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ꞌEꞌeme puni nia niꞌaha kwino jaraume niriara. ꞌEjume Jesura ira kisi ijá ꞌiama Ja ea ꞌahoꞌa paꞌwaraꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ꞌEnakaivo pu noꞌo vaꞌajimareja ea mapoka ꞌwaramapena ojumakame Jesuni vuꞌa kajaho rausahapene vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ꞌEjume pu vaꞌeme ea pina ira paꞌana ꞌavena siseapo ajivuraꞌomo pu apene Huni roara. ");
INSERT INTO mcq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ꞌEjumakame ꞌavena sisea kajaho ꞌeꞌuna vaꞌeme ea kajaho ira ꞌwaravumakame ea mapoka ijí kamareja oja hwaꞌusunahaꞌeme ijá ꞌwava Nú ea ikaꞌina Isureri opuni vaja pakivura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ꞌEjumakame Parasi ijá ꞌwava ꞌAvena siseijihipuni natohwijara niꞌajahuꞌe ꞌavena sisea atoꞌarumau ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ꞌEꞌeme Jesuho vaꞌe ara mamaꞌina ꞌee ara maꞌuꞌumaa ijino puni Sinakoku kaꞌene namijujino Godoni vuꞌa mai maiuꞌina kaꞌene Huni ara rona ꞌwaramaji najahana. ꞌEjiꞌi ea kaꞌene atama ꞌuniraviꞌina ꞌee unenuꞌu ꞌahoꞌa aniꞌina renaujija vejume sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ꞌEjiꞌi Hu kimajaho ea mapoka ijí ani rejara kaivo pu majikari areri sipiepo sipia ꞌajohaiꞌina paꞌa ojujaꞌinaꞌe vejume Hu nihoꞌo temumana. ");
INSERT INTO mcq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ꞌEjumakame Hu Huni tisaiporu ijá ꞌiama Juara mapokaꞌe tuma navu kaivo ea kaꞌene juara sahunijaho kwinu kwinuna. ");
INSERT INTO mcq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ꞌEnajihunaꞌe juara savuri Natohwiji jarivakame Hura ea kaꞌene juara sahunijaho irechamiꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ꞌEjume Hu Huni tisaiporu iropu ropu noꞌo ꞌumenaume Huni roumakiviꞌi pura ꞌavena sisea atoꞌarumaꞌe ꞌee atama veje sonahie ea kaꞌene haha siseraniꞌina amairia Huni harurijaho mihana. ");
INSERT INTO mcq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ijí Huni tisaiporu iropu ropu noꞌoheꞌi kajihipuni ihijaho ikihina. Saimani kaꞌene Pitana ꞌwavujine ꞌee huni ꞌuꞌua Eniturune ꞌee Jemisina ꞌwavujaho Sepati oni hariha ꞌee huni ꞌuꞌua Jonina ꞌwavujaho ");
INSERT INTO mcq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ꞌee Piripu ho ꞌee Pataramiu ho Tomasi ho Matiu kaꞌene takisia apejiꞌinijaho ꞌee Jemisi kaꞌene Apiasi oni harihijaho ꞌee Tariasiho ");
INSERT INTO mcq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ꞌee Saimani Kenani orijaho ꞌee Jutasi Isikariatika kaꞌene Jesu nahamahajina. ");
INSERT INTO mcq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ike iropu ropu noꞌoheꞌi Jesura irechamiana. ꞌEꞌikaivo ijá ꞌiama Ja Jenitaru puna pavaꞌe ꞌee Sameria opuni ara vaja pavaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ꞌEnakaivo arira vaꞌe Isureri opuni sipia kaꞌene pivusahu jihipuni vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ꞌEnareje vaꞌe najahareje ijá ꞌwaraꞌavara Godoni arijihuni ꞌunama niturana roanaꞌomo maiꞌo piunahuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ꞌEnakaivo ea kaꞌene atama ꞌuniraviꞌinijija veje sonahie ꞌee ea kaꞌene kwamasahiꞌinijija veje ꞌurine ꞌee ea kaꞌene reporosia rukinijija venaꞌe reporosia paꞌarenaꞌe ꞌee ꞌavena sisea ea ajimaꞌinijija siomaꞌavara. Ja maapejarakúne mavajiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ꞌEnakaivo ja ijí vaꞌi veꞌavajaho korutia ho siriva ho kapa monijaho pina joni tuja vaja nihoꞌo panaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ꞌEne joni tuja paꞌeke ateha noꞌo paꞌeke ꞌee joni mumora hwana paꞌeke ꞌee pijuha paꞌekavara. Ijihuni maijaho ea irara ea ꞌahoꞌa niꞌajihujaho ijí ea kaꞌene pu niꞌajihu kajipo ꞌiruma pu vajihuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ꞌEnakúne ja vaꞌe taunuina ho ari useꞌavajaho hami aporama henu vaꞌo ea mamaijihi puꞌúmo hinu vaꞌo vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ꞌEne ja vaꞌe sei ajiviꞌi ea kaꞌene sea kaji hijujija ꞌajoraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ꞌEjiꞌi kive pu ja ꞌajorava kiꞌavajaho pu puꞌúmo matauꞌavara kaivo pu paꞌajorava kiꞌavajaho pu puꞌúmo pamatauꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ꞌEꞌeje ara kajiꞌu puna ho ei pini joni vuꞌa pahene pataaroraha kaꞌavajaho joni mumora hari saina kaꞌene namujaho taireꞌi kaivo vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ꞌEnakaivo Na nimaa nimaa ꞌwaravu vea kaꞌene ꞌotua veꞌavari veijaho eakijahija nihoꞌo sisea aniꞌina renahuna. Kwaa kaꞌene Satami Kamora renajaho asimareje nihoꞌo aniꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ꞌEnakúne hami heha. Na ja irechamiujaho areri sipiaꞌe ꞌua neꞌa puni vaji irechamiu jaꞌinaꞌe irechamiu. ꞌEne ja raka veꞌiro veꞌavajaho marakuꞌa vwihana areri taparapo vejujaꞌinaꞌe veꞌavara. ꞌEnakúne ja marahuꞌorapo ajuarasaha ojujaꞌinaꞌe oꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ꞌEne hami kiꞌavara. Erapo ja ꞌeke namahareje ꞌeka vaꞌe kanisoru puni nini vaꞌe ꞌee pu ja ꞌekaꞌe puni Sinakoku vaji hijihahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ꞌEne Nuni hahijihunaꞌe pu ja ꞌekaꞌe ea mamaꞌina kaꞌene kwaa ara ꞌajohiꞌini jihipuni unaꞌi vaꞌe ꞌee kamatia epuni una ꞌuꞌo vahuna. ꞌEnakúne ja Nuni vuꞌakaho pu ꞌwarame ꞌee Jenitaru ꞌwaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ꞌEꞌeje pu ja ꞌekaꞌe namaꞌirono vaꞌa kiꞌavajaho ja pajumareje ikaꞌina vwihaꞌavara. Na vina vuꞌa icháꞌinaꞌe ꞌwaraꞌejo? paroꞌamana. Ijihuni maijaho vea kaꞌene ara ꞌwaraꞌi veꞌamajino raka kaꞌene ara ꞌwarahunijaho vajahe ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ꞌEnajihunaꞌe ijí vuꞌa kajaho a pana kaivo Amo oni ꞌAvenijara oni vaji ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ꞌEnareꞌe ei pini huni poka ꞌotu vetiakame erapo apene ꞌanaa kwahuna. ꞌEje omahi huni hariha ijaꞌina ꞌahahuna. ꞌEjakame kasihwapo emahwaha namahe ꞌanie tirahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ꞌEnakaivo Nuni hahijihunaꞌe ea ja senahuna. ꞌEne ea irara ꞌata kairane hiꞌeje mweꞌakaho paꞌareꞌamajara marana parahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ꞌEnakúne ari pini ja ruaraha kiꞌavajaho marakoꞌa juhaha vaꞌe ari pini vaꞌavara. ꞌEnakaivo Na nimai ja ꞌwaravu ja joni kaukara kaꞌene ike Isureri opuni ara kwaa vajakino vejujaho maiꞌo pave paraꞌeje Na Ema Puni Harihijaho kúꞌo ꞌunama rohuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ꞌEne tisaiporu ijaho huni tisa paasimana ꞌee pweijaho huni natohwa paasimuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ꞌEnakaivo tisaiporu ijara huni tisa ijí vareꞌinaꞌe reꞌipisa areri reje ꞌee pweijara huni natohwiji vareꞌinaꞌe reꞌipisa areri rejaꞌa. ꞌEnakaivo pu ijí sea anesura kajaho Pierisiparu ꞌwaꞌavajaho pu ijí sea kaji hijujija ꞌuꞌo niꞌaha kwino sisea ꞌwavaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ꞌEnajihunaꞌe ja ea ꞌahoꞌa pajuhaꞌavara. Ijihuni maijaho uneunecha mapoka kaꞌene vaji navuꞌe ea mapoka pakivuraꞌomo túnaꞌi sama hirahuna. ꞌEne ea mapoka niꞌi niꞌi hemi navujaho hena kihuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Vuꞌa kaꞌene sei vaji Nara ja masuani ꞌwaravukaho ja samaumai ꞌwaraꞌavara. ꞌEne vuꞌa kaꞌene Na atai koravuꞌe ja hejukaho ja maꞌaha riri namine ꞌwaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ꞌEnakaivo ike haha huriji erapo ꞌanaa kwahuniji ja pajuꞌavara. Pu joni ꞌavenijaho paꞌanaa kwahuna. ꞌEnakaivo Godira haha ꞌee ꞌavena ijiꞌi ꞌaniareje atoꞌarumaꞌe vena vaji vaꞌajime rehunakúne ijí juꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ꞌEne ea uka ꞌuꞌumai noꞌo ꞌwani toia ꞌimejura. ꞌEnaꞌavo joni Omijara ijí uka ꞌuꞌua kajara mweꞌi ꞌonujaho Hu kama henuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ꞌEne ijí joni húmata ꞌahi sapasa icharo namujaho Hu nihena kimuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ꞌEnakúne ja pajuꞌavara. Ijihuni maijaho jara uka ꞌuꞌua mapoka kajaho asitahara. ");
INSERT INTO mcq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ꞌEnaꞌomo ea irara Na ronareje ea mapoka puni unaꞌi ꞌwaraꞌamajaho Na ꞌuꞌo ea kaji rone kahino akúpa ꞌahi Nuni Omijihuni unaꞌi nahama ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ꞌEnakaivo ea irara Na hemihareje ea ꞌahoꞌa panajaꞌamajaho Na ꞌuꞌo ea kajaho kahi akúpi ꞌahi Nuni Omijihuni unaꞌijaho hemahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ꞌEnakúne ja ikaꞌina pavwihaꞌavara. Na iki mweꞌi matauviꞌina paapena routa kaivo Na ea soꞌwi ahaaꞌi routa. ");
INSERT INTO mcq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nara roujihuni maijaho Na veje harihwapo omahwaha chichahie ꞌee ꞌapajahi oaha chichahae ꞌee hariahoni naparijara sasaha chichahaꞌamarono routa. ");
INSERT INTO mcq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ꞌEnakaivo emahuni nakijaho huni kachiꞌipo rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ꞌEje ea irara omaha oaha ijihi oja miha paraꞌi kaivo Na oja pamihujaho Nuni tisaiporua areri parehuna. ꞌEne ea irara hu huni hariha ꞌapahija ijihi oja miꞌi kaivo Na oja hami pamihujaho Nuni ea areri parehuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ꞌEne ea irara huni korosia paapene Na ꞌararihiꞌamajaho hu Nuni ea areri parehuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ꞌEa irara huni hiiji ori niꞌajaraꞌamajaho huni hiijaho ranahuna. ꞌEne ea irara huni hiiji Nunijihunaꞌe Godoni vuꞌa maa maiuꞌini jihunaꞌe ranamajaho hu huni hia ꞌonanahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ea irara ja hami ꞌahiujaho pu Na ꞌuꞌo hami ꞌahiu. ꞌEne ea kaꞌene Na hami ꞌahiujaho pu Godi kaꞌene Na ranamiume rouji ꞌuꞌo hami ꞌahau. ");
INSERT INTO mcq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ei pini kaꞌeje poropeti pini roa kamareje hu ꞌajohaꞌamajaho Godira eha Huni poropeti miꞌamajaꞌinaꞌe ea kajaho eha areri mahuna. ꞌEnaꞌomo ei pini kaꞌeje ea ariramaa roa kamareje hu ꞌajohaꞌamajaho Godira eha ea ariramaa miꞌama jaꞌinaꞌe ea kajaho eha areri mahuna. ");
INSERT INTO mcq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na nihoꞌo nimaa nimaa ꞌwaravu. Nuni tisaiporu ijihunaꞌe ea maꞌuꞌumaakihi toa huanava kimareje toa ꞌe miꞌavajaho ea kajaho eha maa paasihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ꞌEnarena Jesuho Huni tisaiporu iropu ropu noꞌoheꞌi kajipo raka kaꞌene vehunijaho ꞌwaravume paꞌarejume Hu ijí rene vaꞌe puni ari najahe vuꞌa ꞌwaraꞌirono vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ꞌEꞌeme Joni tipurai hijiꞌi Kerisora raka kaꞌene venajaho henarena hu huni tisaiporua noꞌo irechamiume Huni roara. ");
INSERT INTO mcq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ꞌEnareja pu Hu apoma ijá ꞌwava ꞌÚ A ea kaꞌene rohunaka ꞌwaruvajina ho nú ea pina saꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ꞌEjume Jesura ijá ꞌiama Ja iviamaa ꞌunama vaꞌajimareje ja raka kaꞌene hena kavajaho Joni ꞌwaraha. ");
INSERT INTO mcq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ea kaꞌene nia supamaꞌinijija nia niriuꞌe ea kaꞌene irimaꞌinijija ꞌurahe matauma ojuꞌe ea kaꞌene reporosia rukina paꞌarenauꞌe ea kaꞌene ataa paꞌajija hejuꞌe ea kaꞌene kwamasahiꞌinijija niꞌurine maiꞌo hiju. ꞌEjuꞌe Godoni vuꞌa mai maiuꞌinijaho ea kaꞌene pivusahiꞌiniji najahu. ");
INSERT INTO mcq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ꞌEnaꞌomo ea irara Nuni hahijihunaꞌe pajuꞌamajaho nihoꞌo hu merajahiꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ꞌEjume Joni oni pwehijijija vaꞌeme Jesura eaka mapoka kajihi Joni rona ꞌwaramarena ijá ꞌiama Ja vaꞌe nechiꞌa riri vaꞌajaho ja iraka kavare? Ja vi hwaꞌoha rakaꞌe hwasisiꞌi ninamarena variviꞌi navumakame ja ijí kaꞌi vaꞌara raka? ");
INSERT INTO mcq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ja ijino vaꞌajaho ja rakaꞌe kaꞌi vaꞌare? ꞌÚ ei pini ateha kaꞌene mavarasaꞌinijino apúsavumakame ja kaꞌi vaꞌara raka? Heha! Ea kaꞌene ateha mamai savujaho kini huni sei hijura ");
INSERT INTO mcq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","kaivo ijí jara raka kaꞌene kaꞌi vaꞌa kajaho ꞌwariva hejuma. Ja poropeti kaꞌi vaꞌare? Iꞌa Na ijaho ja niꞌwaravume hejara. Hura poropeti ꞌahoꞌakija asitahu. ");
INSERT INTO mcq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ikaho nitama ea kaji Godoni ira vaji rona ꞌwaramajina. Heha! Na Nuni vuꞌa ꞌwaraviꞌina ranave Oni unaꞌi vuꞌakame hu Oni ꞌunama amairiahuna ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na nihoꞌo nimaa nimaa ja ꞌwaravu Joni Papitisita eaka mapoka kaꞌene mweꞌa kakino hijujaho hura asitahana. ꞌEnakaivo Godoni ehija maꞌuꞌumaijipo Joni asivu. ");
INSERT INTO mcq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ꞌEnakaivo veaka Joni Papitisita aneja vene ea najahaji rena roe iviamaa ꞌeꞌunukino renareja ea mapoka Godoni ara piꞌonaꞌiroreja harura niꞌina veju kaivo ea kaꞌene ajisinijipo nihoꞌo Godoni ara kajaho harura vene apeꞌi veju. ");
INSERT INTO mcq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ꞌEnakaivo nitama Godoni poropeti ꞌee ea kaꞌene Godoni tamana vaji ꞌwarama apena rou vaꞌo roe iviamaa Jonira roani veakino ꞌeꞌunakena. ");
INSERT INTO mcq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ꞌEnakúne ja ura ijí hena nimai roꞌi ꞌahiꞌamajaho Joniho Iraijana. Hu ea kaꞌene rohuna ꞌwaruvajina. ");
INSERT INTO mcq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ea irara areri ataa jaraaꞌe heꞌi veꞌamajaho ataa apúsame henama. ");
INSERT INTO mcq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ea kaꞌene iviasi hijukija Na iraki apene manura vetiꞌejo? Ijihuni maijaho pu areri sesamaapo maketi hine sesamaa ꞌahoꞌaꞌe ꞌumenai hijujaꞌinaꞌe veju. ");
INSERT INTO mcq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nú jonaꞌe hurisia hwasihihura kaivo ja pajavavura. ꞌEne nú virisi vejura kaivo ja paniramaruvura ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ꞌEnakaivo Jonira roarena ꞌaura areme ꞌiruma paine ꞌee toa paijumakame ea mapoka ijá ꞌwava Hu ꞌavena siseapo ajivuꞌe avanu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ꞌEnakaivo Ema Puni Harihijara roajaho Hu ꞌiruma ine ꞌee toa inana. ꞌEnajihunaꞌe pu ikaꞌina ꞌwavu Kaha! Hu ꞌiruma arisi isaꞌora ꞌee Hu arisi toa sisea isaꞌora Hu ea kaꞌene takisia apejiꞌinijihija ꞌee ea kaꞌene sisea vejiꞌinijihi puni napura. ꞌEnakaivo ea kaꞌene vwiha mamaa rukinijija pura icháꞌina kaꞌene vejujara najahujaho pu hena kaviꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ꞌEjumakame kwaa ara ꞌahoꞌa uneunecha kaꞌene ea areri pavehunijija venana kaivo ea mapoka puni sisea paarevumakame Hu pu ꞌuraraharena ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ja ea kaꞌene Koresini hine ꞌee Petasaita hijujija eha sisea apehuna. Ijihuni maijaho Na joni ari uneunecha ea areri pavejura vejuꞌukame ja panimai roju kajihunaꞌe ja eha sisea apehuna. Na Taia ꞌee Sairani ijaꞌinaꞌe veꞌipisa pu nihoꞌo marakuꞌa puni sisea niaremamaa arevaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ꞌEnaꞌomo na nimai ja ꞌwaravu. Vea kaꞌene Godira mweꞌakaki ꞌotua venuni veijaho kwaa iha Taia ꞌee Sairani ijija jara eha kaꞌene niꞌimaꞌura apeꞌavajaꞌinaꞌe papehuna. ");
INSERT INTO mcq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ꞌEnakaivo ꞌú ja Kapeniami orakija ja ma joni haha kakino ꞌeka kahino Godoni ari vaꞌiro avajo? Ja nihoꞌo kwa kaꞌene veni renuni kwaijino vahuna. Ijihuni maijaho Nara uneunecha kaꞌene ea areri pavejuraka joni vaji vejuꞌukame ja panimai rojuke Satami ijaꞌina veꞌipisa ijí ara kajaho iviasa ijí navaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ꞌEnakaivo Na nimaa ja ꞌwaravo. Vea kaꞌene Godira ꞌotua veꞌamani veijaho Satami opo eha maꞌuako mihuna kaivo ja nihoꞌo eha niꞌimaꞌura mihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ꞌEꞌikaivo ijihuni vea kajino Jesura eha vene ijá ꞌwama Amo kaꞌene akúpa mweꞌa ijihuni Natohwijiꞌo Na teimani ꞌwavujihuni maijaho Ara uneunechakija ea kaꞌene vwiha mamaa vwihajiꞌinijija ꞌee hena kaviꞌini jihipuni unaꞌa pavejume samaa renana kaivo kasimaaru najahana. ");
INSERT INTO mcq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nimai Amo A ijaꞌina venajara teamanamu. ");
INSERT INTO mcq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ꞌEnakaivo uneunecha mapokijija Amora Nuni ija tahi irechamana. Ijihunaꞌe eaka mapokijija Godoni Harihijaho hami pakama pahejura kaivo Amora huhusu hami hena kamuna. ꞌEjuꞌe eaka mapokijija Amoho hami pakama pahejura kaivo Hariahi huhusu hami hena kamuna. ꞌEnakaivo Hariahi ea irá ura renajiru Omahaꞌe nahume hu ꞌuꞌo Omaha hena kamuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ꞌEne Hu pu ijá ꞌiama Ja ea kaꞌene ahija apene oja vaja sirua paꞌarenaujija Nuni roajive Nara venaꞌe joni ahija paꞌareje ojuta hwena hiha. ");
INSERT INTO mcq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ꞌEne Nuni ꞌunama kaꞌene kisimaꞌurijaho jonaꞌe apene Nuni ꞌunamiji kama heha. Ijihuni maijaho Na matauviꞌina ꞌee masuani hijiꞌina. ꞌEne veje joni oja masuani sonama namama. ");
INSERT INTO mcq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ijihuni hahi Nuni ꞌunamijaho samaumaa. ꞌEne Nuni ahijijaho nimaa nimai nasina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ꞌEꞌeme ijihuni túnaꞌi Sapati veijino Huni tisaiporu puꞌúmo konesa juari ꞌuraha vaꞌeme pu matunavume konesa ꞌeka ijara. ");
INSERT INTO mcq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ꞌEjume Parasiepo kame Jesu ijá ꞌwava Jua puni varapijaho Sapatia juasiꞌi ꞌiruma paꞌekura kaivo Oni tisaiporu hine ꞌiruma ꞌeka iju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ꞌEjume Jesura ijá ꞌiama ꞌÚ ja Godoni ira vaja pataha kavure? Naꞌia pini Tevitira pwehwa puꞌúmo matunavumakame vejajaho ja patahare? ");
INSERT INTO mcq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pu ijí Temiporu kajino vaꞌe arumareja ijí puretia kaꞌene ea mapoka paijura kaꞌene hu pwehwa puꞌúmo ꞌeke ijajaho pirisitiapo pupuso ijuraꞌe ja patahare? ");
INSERT INTO mcq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ꞌEne Mosisi oni tamanijara ea kaꞌene Godoni kaukara ꞌajohiꞌinijihi rona ꞌwaramajaho ja pataha hejara raka? Pu ijí tamana Sapatia vea kajaho pu Temiporu vaji pirisitia varapi ꞌwaramajaꞌina pavejura kaivo pu sisea pavejara. ");
INSERT INTO mcq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ꞌEnakaivo na nimai ja ꞌwaravu Ea kaꞌene ike Temiporua asima paranajaho iviamaa ikeho naminu. ");
INSERT INTO mcq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ꞌEnaꞌomo jara ijí Godoni ira vaji raka kaꞌene ꞌwarama kajihuni maiji hena kaꞌipisa Na ema kime temukavujara ura renu kaivo jara Nuni swasa vejujaho Na ura pareniaꞌa. ꞌEnakaivo ja ea kaꞌene sisea pavejajihi punaꞌi sisea pavejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ꞌEnakaivo Ema Puni Harihijaho ijí Sapatia kajihuni Natohwa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ꞌEnarena Jesuho ijí ruha kajaho areꞌi kaivo sinakoku naminujino vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ꞌEnakaivo ijino ea pina ija uꞌurajiꞌina hinunaꞌomo ea ꞌahopo Jesu namaꞌi ꞌahiumakame Hu apome ijá ꞌwava ꞌÚ ea ꞌahoꞌaꞌe Sapatia vei venaꞌe maraniꞌamajaho arerinaꞌaho pane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ꞌEjume Jesura ijá ꞌiama ꞌÚ joni ei pini sipia rukina reꞌiraꞌomo Sapati kajino maꞌoa vaji ꞌoꞌipisa ja paꞌena apene ꞌajiva raka? ");
INSERT INTO mcq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nú emaakipo sipia asitaharaꞌomo nú Sapati kakino ꞌunama mai veꞌavajaho areri rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ꞌEꞌikaivo ea kaꞌene ija sisea kajaho ijá ꞌwama Ija ahasirima ꞌwavume hu ija ahasirimajaho huni ija kajaho niꞌaha kwino maranarena ija ropuna ijí vareꞌi renana. ");
INSERT INTO mcq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ꞌEjumakame ijí Parasia kajipo vaꞌe ahuma hine icháꞌinaꞌe Jesu ꞌanahuniji ꞌwaviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ꞌEjumakamarena Jesuho ijí henarena Hu ijí sea kajaho areꞌi kaivo ariha vaꞌume ea nihoꞌo mapokaꞌe Hu ꞌarariha vaꞌume Hura ea kaꞌene atama rukinijija vejume maraniara. ");
INSERT INTO mcq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ꞌEjumakame Hura raka kaꞌene vena kajaho ea ꞌahoꞌa paꞌwaraꞌavarono Hu pu ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ꞌEnakaivo raka kaꞌene nitama Godoni ira vaji poropeti Aiseara ꞌwaramajaho nimai renana. ");
INSERT INTO mcq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Godira ijá ꞌwarumana Ikaho Nuni pwea kaꞌene Nara iji pijahujina. Na Hu oja mahu. ꞌEne Na Hu nihoꞌo kavujaho teamanima paranunaꞌomo Na Nuni ꞌAvena Hu samahuna. ꞌEjakame Hura Jenitaru ꞌotua arira vetihuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ꞌEne Hu ea paꞌurarahune ꞌee Hu ira ajira ea paꞌananajihune ꞌee Huni ira maꞌaha rira majikari pahehuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ꞌEnakaivo hwaꞌohapo irasahe navujaho Hu paveje tuꞌusunaha arihuna. ꞌEne vena kaꞌene utahu vaꞌo maꞌuakuꞌwi renujaho Hu paveje utahuna. Ijihuni maijaho Hura veje ariramaa rene asitaha parahuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ꞌEjukame Jenitaru Huni ihijihuni vajijino maranihuniji nimai rojiꞌi hiju ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ꞌEnakaivo ea ꞌahopo ea kaꞌene ꞌavena siseꞌi ajimarena ira paꞌwarame ꞌee nia paniriꞌinijaho ahema apene Jesuni roume Hura vejume ea kajaho nia nirie ira ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ꞌEjumakamareja eaka mapoka kajija oja hwaꞌusunahaꞌeme ijá ꞌwava ꞌÚ Hu Teviti Oni Hariha pana raka? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ꞌEjumakame Parasiapo ijí henareja ijá ꞌwava Hura ꞌavena sisea pasioma kaivo Pierisiparu kaꞌene ꞌavena siseijihipuni natohwijara siomau ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ꞌEjume Jesura puni vwihaiji kimarena Hu pu ijá ꞌiama Ara ꞌahosupo riri ahaame araꞌipisa nihoꞌo ꞌaha josu pahijaꞌa. ꞌEje kwaa ꞌahosupo riri ahaame pu hina ꞌarahiꞌi hiꞌipisa nihoꞌo paꞌarejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ꞌEnaꞌomo Setanira ꞌurine ꞌoriꞌini riri ahaꞌipisa hu icháꞌinaꞌe areri namijaꞌe? ");
INSERT INTO mcq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ꞌEnavo jara vwihajujaho Nara ꞌavena sisea kaꞌene siomahujaho Pierisiparura rejuꞌe siomahu ꞌwavu kaivo irahuni harurijara rejakame joni harihija ꞌavena sisea kajaho siomaꞌeja? Ijihuni hahi joni harihija kajipo ja nahamahuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ꞌEnajihunaꞌe Na Godoni ꞌAvenijara veje ꞌavena sisea siomaujaho Godoni arijaho nikino joni vaji roana. ");
INSERT INTO mcq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Icháꞌine ea pina vaꞌe ea kaꞌene harusini jihuni sea ajime Huni ꞌiruma ꞌeka vaꞌena? Hu maijaho marakuꞌa ea ajisina kajaho kamomapi ninaꞌi kaivo ijiꞌa huni ꞌiruma kajaho nesi ꞌeka vaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ea kaꞌene Na huꞌúmo parenujaho hu Nuni pwina pana. ꞌEne ea na huꞌúmo parene ea nianaujaho hu vejuꞌe pu jirijiri va ranavura. ");
INSERT INTO mcq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ꞌEnakaivo Na nimaa nimai ja ꞌwaravu. Ea kaꞌene sisea vene ꞌee ea ronaꞌavajaho Hu vwihania arehuna. ꞌEnavo Godoni ꞌAveniji ronaꞌavajaho Hu nihoꞌo pavwihane arehuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ꞌEne ea irahipo Ema Puni Harihijihunaꞌi ira sisea ꞌwaꞌavajaho puni sisea vwihanie arehuna kaivo Godoni ꞌAveni jihunaꞌi sisea ꞌwaꞌavajaho Hu nihoꞌo puni sisea iviamaa pavwihanie areme ꞌee vea kaꞌene pu kwamasaꞌavari túnaꞌijaho pavwihanie arehuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ꞌEnakaivo icha maijara mamai reꞌamajaho huni ꞌina ꞌuꞌo mavarasaꞌina rehuna. ꞌEne icha kajara sisea reꞌamajaho huni ꞌinijaho nihoꞌo sisea rehuna. Ichaꞌina punijino icha irakijija kima hehuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ꞌEnakaivo ja iviamaa hijujija tapara sisesa ijina. ꞌEnaꞌomo ja icháꞌinaꞌe unenuꞌu pina kaꞌene maijaho ꞌwahune? Irijija raka kaꞌene oja vaji rarejujiru ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ꞌEnakaivo ea kaꞌene puni oja vaja ariramaaru navujija vwiha maaru vwihana ꞌwaravura. ꞌEjuꞌe ea kaꞌene puni oja vaja sisearu navujija sisearu ꞌwaravura. ");
INSERT INTO mcq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ꞌEnavo Na ja ꞌwaravu. Ira sisea mapoka kaꞌene emaapo majikarino ꞌwavukija vea kaꞌene Godira mweꞌakaki ꞌotua veꞌamani veijino ijaho aporuhuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ꞌEnakaivo ijí ira kaꞌene ara ꞌwaramu kajara rejakame Godi ja ea arira ꞌiꞌena ꞌee joni ira kajara rejakame Godi ja namahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ꞌEjumakame ijí Sikuraipia ꞌee Parasi ijipo Jesu ijá ꞌwava Najuhiꞌine nú ura Ara unenuꞌu pina kaꞌene ea areri pavejiꞌiniji veja kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ꞌEjume Hu eha vene ijá ꞌiama Ea kaꞌene nihoꞌo sisea ani ani vejiꞌinakije Nara ea areri pavejuri uneunechiji najaꞌurono ꞌwarivu. Na unenuꞌu pina ea areri pavejujaho panajahuna vo poropeti Jona renajiru najahuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ijí ea kaꞌene Jonana ꞌwavu kajaho naꞌia noꞌopisune vea noꞌopisu ijano kija natohwa huni tei vaji namanaꞌomo Ema Puni Harihiji ꞌuꞌo ijaꞌina naꞌia noꞌopisune vea noꞌopisu ijano mweꞌi vaji nahuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ꞌEnakaivo vea kaꞌene Godira ꞌotua veꞌamani veijino ea kaꞌene Niniva orijija pu Godoni unaꞌi ja puꞌúmo namine ja namahuna. Ijihuni maijaho Jonara najahaji pu hene nimai ronareja puni sisea arevara. ꞌEnakúne heha! Ea kaꞌene Jona asimani Eijaho nimaa iki joni vaji hinu. ");
INSERT INTO mcq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ꞌEne vukúꞌo vea kaꞌene Godira ꞌotua veꞌamani veijino vea vaꞌe ꞌonu karoꞌi puni kwinia kaꞌene hinujara Godoni unaꞌi ja puꞌúmo namine ja namahuna. Ijihuni maijaho ike kwinia karoꞌi kwaa jori hinujaho roe Saramanira kora mamaiji ꞌwaravume henana. ꞌEnakúne heha! Ea kaꞌene Saramani asimani Eijaho iviamaa iki joni vaji hinu. ");
INSERT INTO mcq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Vea kaꞌene ꞌavena sisea emahuni haha ꞌahi hinujara ruꞌeꞌunujaho hu vaꞌe kwaa toa paꞌajino vaꞌe ojuta hwehuna samujaho pakamuna. ");
INSERT INTO mcq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ꞌEnareꞌe hu ijá rohuna Na kúꞌo ꞌunama vaꞌe ruha kaꞌene nara hijujino vaꞌuma. Hu ꞌunama vaiꞌi kavuꞌe ruha kajaho ea pahiju kaivo túa ꞌanae amairiana. ");
INSERT INTO mcq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ꞌEnareje hu vaꞌe napuhwaha ꞌavena sisea ꞌahoꞌa iropu noꞌo ajisinijija aherama roe ijí hihuna. ꞌEnaꞌavo marakuꞌijaho eakaho siseꞌi hinana vo iviamaa hami sisemai hina parahuna. ꞌEnajihunaꞌe ja ea kaꞌene siseaka iviamaa hijukija ijaꞌina renahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesuho maiꞌo hine eka mapoka kajihi vuꞌa ꞌwarama apena vaꞌeme oaha ꞌee ꞌuꞌuhwaha maꞌahi namijiꞌi Hu vuꞌa ꞌwaraꞌirono savara. ");
INSERT INTO mcq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ꞌEjumakame ea pini henarena Jesu ijá ꞌwama Ike hena ohuna ꞌee ꞌuꞌuhuana maꞌahi namine A vuꞌa ꞌwaraꞌi veju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ꞌEjumakame Jesura hu eha vene ijá ꞌwama Nuni oha irane? ꞌEe Nuni ꞌuꞌuhija irahije? ");
INSERT INTO mcq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ꞌwaꞌi kaivo Hu Huni tisaiporu iji pijihiꞌi ijá ꞌiama Ike kima! Nuni ohija ꞌee ꞌuꞌuhija ikena. ");
INSERT INTO mcq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ea kaꞌene Nuni Oma akúpa ꞌahi hinujara ura renujiru venujaho Nuni vwee ꞌee maꞌine ꞌee oha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ijí veaka nikwinuꞌina kajiano Jesuho ijí sea kajaho areꞌi kaivo vaꞌe soha rori hinana. ");
INSERT INTO mcq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ꞌEꞌeme nihoꞌo ea mapoka rarena jihunaꞌe Hu vaꞌe sisima vaji ajima asuma hinana. ꞌEꞌejume ea mapoka ijí soha rori namijara. ");
INSERT INTO mcq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ꞌEjumakiviꞌi Hu sisima vaji namine uneunechaka mapokijija hai najahana. ꞌEnarena ijá ꞌiama Ea pina vaꞌe ꞌina ꞌoꞌiro vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ꞌEꞌeme ꞌina ꞌahoꞌa ꞌunamu ꞌahi arihume ukapo ro ijara. ");
INSERT INTO mcq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ꞌEjume ꞌina ꞌahoꞌa muna ꞌahi mweꞌa maꞌuako namaji arihajija marakoꞌa riavara kaivo chinuma jojora parejara. Ijihuni maijaho muna ꞌaha mweꞌa maꞌuako namana. ");
INSERT INTO mcq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ꞌEꞌeme vei ꞌeꞌuna rena ijaho chinuma jojora paꞌanaꞌomo ꞌanie sarasahara. ");
INSERT INTO mcq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ꞌIna ꞌahoꞌa ija sisei vaji arihajija riame ajivara kaivo ija sisea kaꞌene oma rukina kajipo raorihume siserasahe ꞌina parejara. ");
INSERT INTO mcq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ꞌEnakaivo ꞌina ꞌahoꞌa mweꞌa mai ꞌojajaho riame marasahe ꞌina ꞌahoꞌa mapoka (30) rejume ꞌahoꞌa mapoka mapoka (60) rejume ꞌahoꞌa nihoꞌo mapoka mapoka (100) rejara. ");
INSERT INTO mcq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ꞌEnakúne irara ataa rukina reꞌamajaho ataa apúsame heꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ꞌEjumakame Huni tisaiporuepo roe Jesu apome ijá ꞌwava A iraka vene pu vuꞌa ꞌwaramujaho haaru ꞌwaramo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ꞌEjume Hura pu ijá ꞌiama Ja Huni arijihuni hemijaho najahume ja nihena kavara kaivo pu maiꞌo pahene pakaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ea pina hu ꞌahoꞌa naꞌeje ꞌahoꞌa ꞌuꞌo ꞌekuna. ꞌEje ea pina huna poku panaꞌavajaho mahoꞌo ꞌetujahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ꞌEnakaivo Nara haa kaꞌene ꞌwaravujihuni maijaho ikena. Pu kavu kaivo ijihuni maijaho pakavu. ꞌEne pu heju kaivo ijihuni maijaho pahene pakavu. ");
INSERT INTO mcq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nitama poropetia kaꞌene Aiseana ꞌwavujara Godoni ira vaji pu rona ꞌwaramajaho nimai renu. Ja hehuna kaivo ijihuni maijaho pahehuna. ꞌEne ja kahuna kaivo ijihuni maijaho pakahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ijihuni maijaho ea kehipuni ojijaho nihoꞌo kisina rejara. ꞌEne puni ataijaho tanumajihunaꞌe pu hami paheju. ꞌEne puni niijaho tanurihuꞌe pu pakivu. Ijihuni maijaho pu vejuroꞌi puni nia ꞌee ataa jarae ꞌee puni oja jarae hene veje pu taꞌarohakame Nara veje pu sonahihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ꞌEnakaivo joni nia merajihukame niriara. Ijihunaꞌe ja kihuna. ꞌEne joni ataa jaraajihunaꞌe ja heju. ");
INSERT INTO mcq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ꞌEnakúne hami vwihananaꞌavara. Poropetia ꞌee ea arira mapokaꞌe ura jara uneunechaka kima hejujihi kima heꞌi ꞌahiara kaivo pu pakima pahejara. ");
INSERT INTO mcq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ꞌEnakúne ꞌina huni haijihuni maijaho heꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ꞌIna kaꞌene ꞌunamu toi arihajihuni maijaho ikena. Pu Godoni arijihuni vuꞌa hejura kaivo ijihuni mai pahejura. ꞌAvena siseijara roareꞌe Godoni ira kaꞌene puni oja vaji namujaho ꞌetujiha ꞌatoꞌarumuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ꞌEnakaivo ꞌina kaꞌene muna ꞌahi arihajija ea hu Godoni vuꞌa iviamaa kakaro henujaho hu nihoꞌo teamaꞌejuꞌe ꞌekuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ꞌEnakaivo ꞌinijaho nihoꞌo oja vaja chinuma pasamanaꞌomo Godoni iriji nimai rojujihuni hahi unenuꞌu pini sisea puni haha ꞌahi renaujaho pu marako rana ꞌoꞌujuꞌe ani vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ꞌEne ꞌina kaꞌene ija sisea vaji arihajaho ea hu Godoni vuꞌa henu kaivo uneunecha kaꞌene mweꞌa kehunijiru vwihane ꞌee monia ꞌekahuni ꞌunamijara pisiviuꞌe Godoni vuꞌa kajaho veurahuꞌe maa parenuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ꞌEnakaivo ꞌina kaꞌene mweꞌa mai arihajija ea hu Godoni irakaho hene ꞌeka venuna. Ea ꞌahoꞌa nihoꞌo mapoka mapoka (100) rejuꞌe ea ꞌahoꞌa nihoꞌo mapoka (60) rejuꞌe ea ꞌahoꞌa mapoka (30) rejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Vukúꞌo Jesura haa pina ꞌwaramarena ijá ꞌiama Godoni arijihuni maijaho areri ei pini ꞌina kaꞌene mamaiji ꞌeka vaꞌe ꞌonujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ꞌEnakaivo ea mapoka noturanaꞌeme huni naki pini ꞌina sisea ꞌeka roe ꞌwitia vaja kajiano atoꞌaruma vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ꞌEꞌeme ijí ꞌwitia kajaho ritati ꞌanae maa reꞌeme ijiꞌa ijihuni vaji ija sisea kajihuni ꞌina ꞌuꞌo ꞌurina samaahiramana. ");
INSERT INTO mcq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ꞌEjumakame ea kajihuni pwehipo roe ea kajaho ijá ꞌwava Natohwe! A ꞌina maaru juasiꞌa kajaho ꞌonana kaivo ꞌú ija siseakaho ichá rene roe ijaho ꞌurijare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ꞌEjume hura ijá ꞌiama Nuni nakapo raki ꞌeka roe ꞌojara ꞌiamana. ꞌEjume pu hu apome ijá ꞌwava ꞌEnaꞌomo núra vaꞌe ija sisea kajaho jahekuhuna ura renau ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hu eha vene ijá ꞌiama Oo ja iviamaa ija sisea kaji jaheju rojiꞌi ꞌwitia kaji jaheꞌavarono pajaheꞌeja. ");
INSERT INTO mcq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ꞌEnakúne makaꞌeje ꞌina kajaho ajive ija sisea kaji ꞌuꞌo ajimuvaꞌo ꞌina kajaho tuvakaviꞌi ijiꞌa nara ea ꞌahoꞌa ꞌekakame ijipo ija sisea kajaho jahejiꞌi useakame ꞌeka vaꞌe veni jahuna kaivo ꞌwitia kajija taireviꞌi irechahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ꞌEꞌikaivo Jesura vukúꞌo haa pina ijá ꞌiama Godoni arijaho areri kwava ꞌina saꞌina. ꞌEnaꞌomo emai apena vaꞌe huni juasiꞌi ꞌonamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ꞌInakaho nihoꞌo maꞌuꞌumaa. ꞌEnaꞌomo riamareꞌe nihoꞌo icha natohwaꞌe rejuꞌe ukapo roe ijihuni anuama ꞌahijino nesa vene hijura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ꞌEne vukúꞌo Jesuho haa pina ꞌwaramana. ꞌEnarena ijá ꞌiama Godoni arijaho areri napari isitia kaꞌene harava ꞌeke puretia venareꞌe ꞌonahukame hwena ajivujaꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesura uneunechaka mapokijija ea mapoka haaru ꞌwaramana. ꞌEnakaivo Hu ea kajija vuꞌa pina nihoꞌo ma maha paꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hura ijaꞌina venajihuni maijaho nitama poropeti raka kaꞌene ꞌwaramajara nimai nimai reꞌamarono avanana. Ikaꞌina ꞌwaramana Na vuꞌa ꞌwaravuri veijaho haaru ꞌwarahuna. ꞌEne Nara vuꞌa kaꞌene ꞌwaraꞌujaho nitama akúpa mweꞌa maiꞌo pavejiꞌini hemi ea pahena pakivajihijaꞌe ꞌwarahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ꞌEnarena Jesuho ea mapokijija irechamiꞌi kaivo sei vaji vaꞌumakame Huni tisaiporu vaꞌe apome ijá ꞌwava ꞌIna kaꞌene juasiꞌi ꞌoꞌeme ija siseijiꞌi ꞌurijajihuni maiji ꞌwaruma ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ꞌEjume Hu ijá ꞌiama Ea kaꞌene ꞌina maa ꞌona ꞌonujaho Emaa Puni Harihijina. ");
INSERT INTO mcq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ꞌEnakaivo juasiꞌijaho ike mweꞌakena. ꞌEne ꞌina kaꞌene mamaijija ea kaꞌene Godoni eijihina. ꞌEnakaivo ija siseijaho ꞌavena siseijihuni ehijijihina. ");
INSERT INTO mcq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ꞌEnakaivo naka kaꞌene roe ija sisea ꞌonajaho ꞌavena siseijina. ꞌEne ꞌina kajara tuame areri reꞌamajaho mweꞌakara paꞌarehuni urijina. ꞌEne juara kajaho ona ojiꞌinapo sahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ꞌEnaꞌomo ija sisea nianae veni jaujaꞌina mweꞌakara paꞌareꞌamani veijino ijaꞌinaꞌe jahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Emaa Puni Harihijara Huni ona ojiꞌina irechamie ijipo mweꞌa kakino ea kaꞌene emaa venauꞌe sisea vejujihija ꞌee sisea vejiꞌina kajija nianae ꞌekahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ꞌEjakame ꞌeke atoꞌarumaꞌe vena kaꞌene nihoꞌo aniꞌina vajijino renareje niramarume kuchikuchiviꞌi upaja chanichaniviꞌi nahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ꞌEꞌeje Godoni eijija puni Omijihuni ari vea punaꞌi risaꞌeje hihuna. ꞌEnakúne ea kaꞌene ataa rukinijija ataa apúsame heha. ");
INSERT INTO mcq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Godoni arijaho areri moniaꞌe ea ꞌahopo juasiꞌi apúrinanavuꞌe namujaꞌina. ꞌEnaꞌomo ei pini vaꞌe kamarena vukúꞌo apene ani apúrinanaꞌi kaivo hu nihoꞌo teamaꞌejuꞌe vaꞌe huni uneunecha mapokijijahija ea ꞌahoꞌaꞌe ꞌimena ranavume hu monia kajino apena vaꞌe juara kajaho ꞌimenana. ");
INSERT INTO mcq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ꞌEne kúꞌo Godoni arijaho areri ea kaꞌene perua saramujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ꞌEnuvaꞌo kwinuꞌwi kamareꞌe vaꞌe huni uneunecha mapokijija ea ꞌahoꞌa ꞌimena ranavume hu monia kajino apene perua kajaho ꞌimenana. ");
INSERT INTO mcq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ꞌEne Godoni arijaho areri nameaꞌe soha vaji ꞌonamareꞌe kija ani aniꞌina siriravujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ꞌEnareꞌe namea kajaho ituꞌoꞌujukaviꞌi unama tairia roe rori ranaꞌi kaivo kija kaꞌene mamaijija nianae katija vena useꞌi kaivo siseijija atoꞌaruvara. ");
INSERT INTO mcq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ꞌEnaꞌomo vea kaꞌene mweꞌakara paꞌareꞌamani veijino Godoni ona ojiꞌinapo roajimareje ea sisea kaꞌene Godoni eijihipuni vaji hijujija ahaahuna. ");
INSERT INTO mcq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ꞌEne ꞌeka vaꞌe vena kaꞌene renujino atoꞌaruve ijí renareje kuchikuchime ꞌee niramarume upaja chanichaniviꞌi nahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ꞌEꞌikaivo Jesura pu aporama ijá ꞌiama Ja ike uneunecha kaꞌene Nara ꞌwaravukehi puni maijaho ja niheju ꞌiavume pu ijá ꞌwava ꞌIꞌa nú niheju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ꞌEnajihuni hahi Sikuraipia kaꞌene Godoni arijihuni tisaiporua rejajija areri aachia anesuraꞌomo ijí puni aachiꞌa vaja kajino uneunecha maiuꞌina ꞌee sahasa ꞌeka rouna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ꞌEjume Hu haa kajaho ꞌwaravume paꞌarejume ijí ruha kajaho areꞌi kaivo ꞌurina vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ꞌEnarena Hu vaꞌe Huni ari ꞌeꞌune ijino puni Sinakoku vaji pu najahumakame Hura vuꞌa kaꞌene ꞌwaramaji ea henareja nihoꞌo oja hwaꞌusunahara. ꞌEjuma kamareja pu ijá ꞌwava ꞌÚ ike vuꞌa anejakaho Hu ichihi apenane? Hura uneunecha kaꞌene ea areri pavejura kaꞌene venajaho ichihi apenane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ꞌÚ Hu kapinita ijihuni Hariha pana raka? ꞌEne Meriho Huni oha pana raka? ꞌEne Jemisi ho Josapi ho Saimani ho Juta ho ijá Huni ꞌuꞌuhija pana raka? ");
INSERT INTO mcq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ꞌEne Huni maꞌipija mapokaꞌe iki hijura raka? ꞌÚ ea ikaho ichihicha harura kajaho apenane? ");
INSERT INTO mcq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ꞌwaꞌi kaivo pu Hu pataarohara. ꞌEjumakame Jesura ijá ꞌiama Poropetijaho eaka mapoka kaꞌene kwaka mapokakino hijujija Huni ira hena taꞌarohuna kaivo ea kaꞌene Huni ara anemai hijujipo hena pataarohura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ꞌEjume Huni arijino uneunecha kaꞌene ea areri pavejura kaꞌene ijí mapoka pavenajihuni maijaho pu panimai rojumakame ijihunaꞌe avanana. ");
INSERT INTO mcq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ꞌEꞌeme vea kajino ea kaꞌene Karari ara kwaa ꞌajohiꞌina kaꞌene Herotina ꞌwavujaho Jesuni pinana henana. ");
INSERT INTO mcq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ꞌEnarena hu huni pwehwaha Jesu rona ijá ꞌiama Ijaho Joni Papitisita kwamanaꞌomo kúꞌo ꞌurina jihunaꞌe Huni harura niꞌimaꞌura rene ꞌee emaa areri pavehuna venu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herotira Joniho kamoma ranavume tipurai hinana. Hu ijaꞌina kaꞌene venajihuni maijaho Herotiasiho Piripu kaꞌene Heroti oni ꞌuꞌuijihuni naparaꞌomo ijí ꞌwaravumakame tipurai ranamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ijihuni maijaho Jonira Heroti ijá ꞌwama Ara hu ꞌwahajaho nihoꞌo ꞌunama maa pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ꞌEjumakame Herotira Joni ꞌanaa kwaꞌamarono ura renana kaivo hu eaka mapokijihijaꞌe juhamana. Ijihuni maijaho pu ea mapokijija Joniho poropeti rojujihunaꞌe paꞌanaara. ");
INSERT INTO mcq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ꞌEnakaivo vea kaꞌene Heroti nahejari veijara rejuma kamarena Herotiasi oni ꞌapajijara eaka mapokijihi puni unaꞌi javavumakame Heroti nihoꞌo teamama paranana. ");
INSERT INTO mcq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ꞌEjumakame Herotira ijí napara kajaho nahama ꞌwaramarena ijá ꞌwama Na ura a iraki ura renaꞌamajaho nahama ꞌwarivakame na maꞌuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ꞌEjume oahi ꞌapajaha nimarako ꞌwarama jihunaꞌe hu ijá ꞌwama Iviamajai Joni Papitisita oni húmatiji tevua ꞌahi ranama miha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ꞌEnakaivo Herotiho ijí henarena temumana kaivo hura ea mapoka puni unaꞌi nahama ꞌwarama jihunaꞌe apena roe maꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ꞌEjume hu ea irechamiume vaꞌe Joni oni húmataꞌe tipura ari vaji ꞌuhuara. ");
INSERT INTO mcq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ꞌEnareja pu ꞌuhue tevua ꞌahi raname apena roe napara kaji mahume hura apena vaꞌe oaha mahana. ");
INSERT INTO mcq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ꞌEjume huni tisaiporuepo roe huni hahijaho apena vaꞌe kwananaꞌi kaivo vaꞌe Jesuho ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ꞌEjumakame Jesuho ijí vuꞌa kaji henarena Hu kwaa kajaho areꞌi kaivo sisima ꞌahi huhusumano kwaa ea paꞌajino vaꞌana. ꞌEjumakame ea mapoka ijí henareja pu Hu ꞌarariha vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ꞌEjumakame Hu sisima vaji rena arihiꞌi eaka mapoka kaji kimarena oja turaꞌi ꞌahaana. ꞌEjumakame Hu puni ea kaꞌene atami ꞌuniraviꞌinijija vejume sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ꞌEꞌeme ijihuni nusireijino Huni tisaiporuepo roe Hu ijá ꞌwava Vea nipaꞌarena paranukúne eakija irechamie pu ari vaꞌe puni ꞌiruma opuipo ꞌimeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ꞌEjume Jesura ijá ꞌiama Pu pavahunakúne jara ꞌiruma vajihakame pu ija ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ꞌEjume pu Hu ijá ꞌwava Núra ꞌiruma kaꞌene irechama hijujaho puretia iropune ꞌee kija noꞌoheꞌineruna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ꞌEjume Jesura ijá ꞌiama ꞌEka Nuni roha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ꞌEjume Hura eaka mapoka kajija ꞌwaravume mweꞌi hijasavara. ꞌEꞌeme Hu puretia iropune ꞌee kija noꞌo ꞌeke kahi ichutoi niriꞌi Godi teimani ꞌwaviꞌi tuchame Huni tisaiporua vajihume pu ꞌeke ea mapoka kajija vajihara. ");
INSERT INTO mcq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ꞌEjumakame ea mapoka kajija ijume túꞌama parajumakame Huni tisaiporuepo ijí pwina kaꞌene irechavajaho ꞌekareja katija iropu ropu noꞌoheꞌi vejume itusahara. ");
INSERT INTO mcq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vea kajino parua kaꞌene ꞌiruma kaji ijajija nihoꞌo mapoka mapoka (5,000) kaivo napara ꞌee kasima patahara. ");
INSERT INTO mcq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ꞌEꞌeme Jesuho eaka mapoka kajihi irechamia vaꞌavaro ijí hiꞌi kaivo Huni tisaiporu irechamiume pu sisima ꞌahi ajime toa ropunaꞌi urana vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ꞌEꞌeme Hu eaka mapoka kajija irechamiume vaꞌeme Hu Huhusu vaꞌe huriꞌi ajime hine siporua ꞌoꞌi vaꞌana. ꞌEnarena vea nutui venajaho Jesuho ijino Huhusu hinana. ");
INSERT INTO mcq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ꞌEꞌejume ijihuni vea kajakaro sisimaijaho vaꞌu vaꞌume toa rira karohi areri pavaꞌi kaivo ijí apene karohi kahi ruvaꞌeme puuri hiramarena nihoꞌo siseraꞌi venana. ");
INSERT INTO mcq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ijá renajihuni veijaho nitunituhaꞌomo Jesuho puni roꞌi ꞌahaume toa ꞌaha kajino mumori roana. ");
INSERT INTO mcq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ꞌEjumakame Huni tisaiporuepo kaꞌeme Hu toa ꞌaha kajino mumori rouma pu kamareja oja hwaꞌusahume ijá ꞌwava ꞌAvena sisei rou kavu ꞌwamareja pu nihoꞌo juma emaavaravara. ");
INSERT INTO mcq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ꞌEjume niꞌaha kwino Jesura pu ijá ꞌiama Naranakúne juvujaho areha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ꞌEjumakame Pitara ijá ꞌumena Natohwe ijaho nimaae Arana reꞌamajaho ꞌwarive na toa ꞌahakino vuꞌuma ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ꞌEjume Jesura ijá ꞌwama Ijinakúne roa ꞌwamana. ꞌEjume Pitaho niꞌaha kwino sisima vaja kaji rene arihe toa ꞌaha kajino Jesuni vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ꞌEnarena vaꞌe Huni rori vaiꞌi puura kaꞌene hiramaji kamarena jumajaho niꞌaha kwino ijí toa vaji tusama ꞌonana. ꞌEnarena hu ijá ꞌumena Natohwe niꞌajiha ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ꞌEjume Jesura niꞌaha kwino ija joranajaho ꞌunaviꞌi ijá ꞌwama A maꞌuako nimaa ronana kaivo irakijihunaꞌe ara nimaa ronajaho aremane? ");
INSERT INTO mcq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ꞌEne pu noꞌo sisima vaji ajiꞌeme puura kaꞌene hiramajaho aremana. ");
INSERT INTO mcq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ꞌEjumakame ea kaꞌene sisima vaji hijajipo Hu oja mahiꞌi ijá ꞌwava A nimaaꞌe Godoni Hariha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ꞌEꞌikaivo pu sua vaꞌe karaꞌi Jenesarati usevara. ");
INSERT INTO mcq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ꞌEjume parua mapoka ara kajiupo Hua hena kamareja ꞌona vejume ara rora kajino atakina mapoka kaꞌene hijujaho aherama Huni roara. ");
INSERT INTO mcq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ꞌEnareja Hu pu makiꞌeje Huni ateha urijino ꞌunave atama sonahiꞌamarono pu jariravara. ꞌEnareja ea irahipo Huni ateha kaji ꞌunavajaho atama puna mahoꞌo sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ꞌEꞌeme Parasi ꞌee Sikuraipi Jerusaremi rena roajime Jesu apoma ijá ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Irakijihunaꞌe Oni tisaiporu núni tamana ꞌiruma iꞌi vejujaho ija some ijura kaivo pu núni tamana kaji pataarohe ija pasoꞌi kaivo ꞌiruma maijo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ꞌEjume Hu eha vene ijá ꞌiama Ja irakijihunaꞌe Godoni ira pataaroꞌi Noinkaivo ja joni tamana vejo? ");
INSERT INTO mcq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ꞌEjume Godira ikaꞌina ꞌwarumana. Ja omahu jona ꞌee ohu jopuna ira hene veꞌavara. ꞌEnakaivo ea kaꞌene oahona ꞌee omahoni ira pataaroꞌamajaho ꞌanaa kwaꞌamana ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ꞌEnakaivo jara ikaꞌina ꞌwavura Ea irara omaha ꞌee oaha ika ꞌwamujaho nuni unenuꞌu pina kaꞌene nara a niꞌajahune saꞌinijaho na Godi nimahuta ");
INSERT INTO mcq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ꞌwamujara vejuꞌe omaha ꞌee oaha puni hura pavenu jihunaꞌe Godoni irijaho tauvo joni tamaneru vejura. ");
INSERT INTO mcq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ꞌEnakaivo ja nihoꞌo ea iraꞌasimaꞌura. Poropeti Aisea ja ronarena ikaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ea kijahija iraru Nuni iha taꞌarohura kaivo puni oja pamihura. ");
INSERT INTO mcq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ꞌEꞌavajihunaꞌe pu majikari oja mihura. ꞌEne pura najahujaho ema puni tamaneru najahura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ꞌEꞌikaivo Hu ea mapoka ꞌwaramarena ijá ꞌiama Hami ataa apúsame hene veha. ");
INSERT INTO mcq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Uneunecha kaꞌene ema puni ira vaji vaꞌe kamaa ꞌarihujipo venaꞌe pu sisea rehuna pana kaivo emaapuni ira titi iki kahi ajima roe ꞌwaramujara rejuꞌe pu sisea rejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ꞌEjumakame Huni tisaiporu Huni roe apoma ijá ꞌwava Parasiepo Ara vuꞌa kaꞌene ꞌwaramu kaji henareꞌe oja ajinamujaho A vi heno? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ꞌEjumakame Jesura eha vena ijá ꞌiama Uneunecha kaꞌene Nuni Oma kaꞌene akúpa ꞌahi hinujara pavenajijahija nihoꞌo túnaꞌi jahena atoꞌaruve parahuna. ");
INSERT INTO mcq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Makiha! Pu nia supaviꞌinapo nia supaviꞌina aherama vaꞌu. ꞌEnaꞌomo ea nia supaviꞌina pini ei nia supaviꞌini pini ahema vaꞌamajaho pu noꞌo vaꞌe maꞌoi arihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ꞌEjume Pitara eha vene Hu ijá ꞌwama Ike haa kehuni maiji ꞌwaruve heja ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ꞌEjume Jesura ijá ꞌiama Ja ꞌuꞌo nihoꞌo maiꞌo pahejo? ");
INSERT INTO mcq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ja nikiꞌejuꞌe uneunecha kaꞌene iri titi vaꞌujaho vaꞌe tea vaji vaꞌareꞌe vaꞌe kamaꞌi usevure? ");
INSERT INTO mcq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ꞌEnakaivo uneunecha kaꞌene kamino oja vaji rena roe ira titi usemujara vejuꞌe ea sisea renuna. ");
INSERT INTO mcq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ijí oja vaja kajino rena rou kajara vejuꞌe sisea vwihane ꞌee ea ꞌaniu kwamasahe ꞌee ꞌuasa vene ea ꞌahopuni napara turame ꞌee nesa apene iraꞌata vene ꞌee ira sisea karokaha ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ijipo venaukame ea sisea rejura. ꞌEnakaivo ija pasoꞌi kaivo ja ꞌiruma iju kajara reje ea sisea vehuna nihoꞌo paꞌamaa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ꞌEꞌikaivo ijiꞌa Jesuho ara kajaho areꞌi kaivo ꞌurine vaꞌe Taia ꞌee Sairani vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ꞌEjumakame napara pina Kenani oraꞌomo roe Jesu ijá ꞌwama Natohwa kaꞌene Teviti oni Hariha karera numirima! Ijihuni maijaho ꞌavena sisei nuni ꞌapaja ajime apene siseꞌi ꞌahaunakúne ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ꞌEnakaivo Jesuho nihoꞌo eha pina paꞌwaramana. ꞌEꞌeme Huni tisaipuru roe ꞌejahae ijá ꞌwava Hu roe núni túnaꞌakino ꞌumena apene onukúne ꞌwarave vaꞌama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ꞌEjume Hu eha vene pu ijá ꞌiama Na ranamiume iki roujihuni maijaho Na Jua punijihunaꞌe routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ꞌEꞌeme ijí napara kajaho niꞌaha kwino roe Huni mumora rora kajino nitupari saviꞌi ijá ꞌwama Natohwe niꞌajiha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ꞌEjume Hu eha vene ijá ꞌwama Nú kasima puni puretia paꞌeke ꞌua puni atoꞌaruvura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ꞌEjume napara kajara ijá ꞌwama Natohwe nimaaꞌe ꞌua ꞌuꞌo emahwapo ꞌiruma iꞌejuꞌe sahurapo arihujaho ijura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ꞌEjume Jesura eha vene ijá ꞌwama Naparakera ara raka kaꞌene nimaa ronujihunaꞌe a raka kaꞌene ura renaujaho maraꞌenakúnina ꞌwavume niꞌaha kwino huni ꞌapaja kajaho maranana. ");
INSERT INTO mcq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ꞌEjumakaviꞌi Jesuho ijí Karari soha rora kaji vaꞌe huriꞌa ꞌahi asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ꞌEꞌeme ea mapoka mapoka ea puna kaꞌene mumora sisea ꞌee nia supaviꞌina ꞌata ꞌajoasahiꞌina ira paꞌana ꞌee ꞌahoꞌa kajihi puꞌúmo ꞌeka roe Jesuni mumora rori useume Hura vejume maraniara. ");
INSERT INTO mcq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ꞌEjumakame ea mapoka nihoꞌo oja hwaꞌusahara. Ijihuni maijaho pu kaꞌeme ea kaꞌene mumora siseraniꞌina maraniume nia supamaꞌina niriume ira paꞌana ira ꞌwaravumakame ijihunaꞌe pu Isureri opuni Godiji taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ꞌEꞌejume Jesura Huni tisaiporu ꞌumenaume pu Huni roume ijá ꞌiama Na nihoꞌo natohwa temukimu jihuni maijaho ea kakija ikino nú puꞌúmo unenuꞌu pina paiꞌi kaivo mahiꞌeme naꞌia noꞌopisu paꞌarenanaꞌomo Na pu irechamie matunaꞌeje vahunijaho Na ura pareniu. Ijihuni maijaho pu puni ari useꞌiroreje vaꞌeje nihoꞌo matuname nii hwerave ohuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ꞌEjume Huni tisaiporupo Hu ijá ꞌwava ꞌÚ nú nechi rirakaho ꞌiruma ichihi areri eaka mapokakipo ije areri renahunijaho ꞌekaꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ꞌEjume Jesura ijá ꞌiama Núni puretia icharu navo? ꞌiavume pu ijá ꞌwava Iropu noꞌona. ꞌEne kija maꞌuꞌumaa makwinu kwinu navu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ꞌEjume Jesura eaka mapoka kajija ꞌwaravume mweꞌi hijasavara. ");
INSERT INTO mcq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ꞌEjumakiviꞌi Hu puretia iropu noꞌone ꞌee kija kajihi puꞌúmo Godi teimani ꞌwaꞌikaꞌi tuachame Huni tisaiporu vajihume pura ꞌeke eaka mapoka kajija vajihara. ");
INSERT INTO mcq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ꞌEjume pu ijume túꞌama paraꞌeme pwinaꞌa kaꞌene navajija Huni tisaiporupo katija iropu noꞌo ꞌeke vejume ituꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ꞌEnakaivo parua kaꞌene ꞌiruma kaji ijajija ea nihoꞌo mapoka mapoka (4,000) ijara kaivo napara ꞌee kasima patahara. ");
INSERT INTO mcq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ijiꞌa Jesura eaka mapoka kajija irechamiume vaꞌeme Hu sisima ꞌahi ꞌajime Makatani vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parasi ꞌee Sajusiapo roareja Jesu vena kaꞌi ꞌahiume Hura kahi akúpi ꞌahi uneunecha kaꞌene ea areri pavejujihi veꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ꞌEjume Hu eha vene pu ijá ꞌiama Ja vea nusireꞌejuꞌe vea kaꞌene apirauji ronareꞌe iviamaa vea maraꞌena rojura. ");
INSERT INTO mcq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ꞌEnakaivo vu súꞌu súꞌuhijaho ja ijá ꞌwavure Vea nituꞌejuꞌe vea ꞌaaꞌejuꞌe nutumujaho neha puurijiꞌi ꞌeꞌuhuna ꞌwavura. Ijihuni maijaho ja ijí vea mwapuna kajihi kimareꞌe ja ijaho ꞌwavura. ꞌEnakaivo iviamaakaho ja vea mwapuna kaꞌene joni vaji iviamaa renujaho pakame paheju raka? ");
INSERT INTO mcq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ea sisea ꞌuasa vejiꞌinapo uneunecha kaꞌene ea areri pavejiꞌinijija najaꞌavarono ꞌwaravura. ꞌEnakaivo unenuꞌu pina najahuna pana kaivo Jonara raka kaꞌene renajiru ꞌwaraꞌikai vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ꞌEꞌeme Huni tisaiporua karaꞌi toa ropunaꞌi vaꞌara kaivo pu runamiume puretia paꞌekara. ");
INSERT INTO mcq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ꞌEnaꞌomo Jesura Huni tisaiporua ijá ꞌiama Hami kiꞌavara! Parasi ꞌee Sajusia ijihipuni isitia arumaꞌenakúne hami kiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ꞌEjume pu piraꞌarame ijá ꞌwava Ijihuni maijaho núra puretia paꞌeka roajina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ꞌEjumakame Jesura pura piraꞌaravume henarene ijá ꞌiama Joni nimaaroa maꞌuꞌua. Ja irakijihunaꞌe nú puretia paꞌana ꞌwame nakaravo? ");
INSERT INTO mcq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ja majaa pahene pavwihajo? Puretia iropune ea mapoka mapoka (5,000) ijajaho ꞌee katija icharo itusahajaho pavwihajo? ");
INSERT INTO mcq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ꞌEne vukúꞌo puretia iropu noꞌone ea mapoka mapoka (4,000) ijajaho ꞌee katija icharo itusahajaho pavwihajo? ");
INSERT INTO mcq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ja ichá venareja Nara puretia parone ꞌwaravujaho pahejare? ꞌEnakaivo ja Parasia ꞌee Sajusia ijihipuni isitia hami kiꞌavarono ronarejo ꞌwaravuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ꞌEjumakame pu ijiꞌa hena kavara. Hu ijí puretia parone ꞌwaramana vo ea Parasia ꞌee Sajusia ijipo najahuji rona ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ꞌEnareja Jesuho ꞌurina Sesaria Piripai roarena Hu ijino Huni tisaiporu aporaviꞌi ijá ꞌiama Ea mapokakija Ema Puni Harihijaho irane ꞌwavure? ꞌiavume pu ijá ꞌwava ");
INSERT INTO mcq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ea ꞌahoꞌa Joni Papitisita ꞌwavume ꞌee ea ꞌahoꞌa Iraijane ꞌee ea ꞌahoꞌa Jeramaia ꞌee ea ꞌahoꞌa poropetia pinina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ꞌEjume Hu ijá ꞌiama Ja Na ea irane ꞌwiꞌeja? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimani Pitara eha vene ijá ꞌwama A Kerisona. A Godi kaꞌene maiꞌo hijiꞌinijihuni Hariha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ꞌEjume Jesura eha vene ijá ꞌwama Saimani kaꞌene Pajona oni hariha karera nimerajahajaho aana. Ijihuni maijaho emaa haha ꞌee ꞌaa rukini jipuhipo a panajahara kaivo Nuni Oma kaꞌene akúpi ꞌahi hinujara a najahana. ");
INSERT INTO mcq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ꞌEnaꞌomo Na kúꞌo pina ꞌwaravu. A Pitana. ꞌEnaꞌomo ike muna anesina toakino Nuni sosia vehuna. ꞌEje vena huni harurijaho paniname ꞌee paasitahuna. ");
INSERT INTO mcq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nara Godoni ara huni kiijaho vajahuna. ꞌEjakame ara iki mweꞌi kamoꞌamajaho akúpa ꞌaha ꞌuꞌo kamohuna. ꞌEne ara iki mweꞌi rasaꞌamajaho akúpa ꞌaha ꞌuꞌo rasahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hu Kerisona kaivo tisaiporua ea paꞌwaraꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ꞌEnarena ijihuni vea kaji rene Jesu Kerisoho uneunecha mapoka kaꞌene Hu Jerusaremi vaꞌakame ea mamaꞌina pirisiti mamaꞌina Sikuraipi uneunecha ani ani vene hu siseꞌi ꞌahaꞌe ꞌanaa kwamareje naꞌia noꞌopisu paꞌareje ꞌurihuna Huni tisaiporu najahana. ");
INSERT INTO mcq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ꞌEjumakame Pitara Hu ahema apene vaꞌe karaa rori hine ꞌurarahe ijá ꞌwama Natohwe nihoꞌo pana! Nihoꞌo ijaꞌina parenahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ꞌEjumakame Jesura taꞌarohe Pita ijá ꞌwama Setanikera túnaꞌi rovaꞌa ꞌwamana. A Na apene tanuꞌurihu jaꞌinaꞌe venu. A oni vwihijaho nihoꞌo Godoni urijaꞌina pana kaivo emaa puni vwihijaꞌina vwihanu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ꞌEnarena Jesura Huni tisaiporu ijá ꞌiama Ei pini Nuni túnaꞌi roi veꞌamajaho hu huni oja makaꞌi kaivo huni korosia apene Na ꞌararihiꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ꞌEnakaivo ea irara huni hiiji ori niꞌajaraꞌamajaho huni hiijaho ranahuna. ꞌEne ea irara huni hiiji Nunijihunaꞌe hiꞌamajaho huni hia ꞌunanahuna. ");
INSERT INTO mcq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ꞌEnakaivo ei pini uneunecha kaꞌene mweꞌa kakehunijaho huna reranaꞌeje hia nimaa nimai iji asinaꞌipisa hu maa iraka apejaꞌe? ");
INSERT INTO mcq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ema Puni Harihijara roꞌamajaho Amoni hanajiꞌina ꞌee Huni ona ojiꞌina puꞌúmo rohuna. ꞌEne ea kwinu kwino pura iraka kaꞌene vejujaho eha ijaꞌina apehuna. ");
INSERT INTO mcq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Emaa Puni Hariha Hura ꞌajohuni kwaijaho ea kaꞌene ike namiju kijahija maiꞌo pakwamasaꞌeje roe kahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naꞌia iropu kwinu paꞌareꞌeme Jesura Pitane ꞌee Jemisine ꞌee huni ꞌuꞌua Joni ijá pupusu aherame huriꞌa jopatuꞌura ꞌahi ajima vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ꞌEnareja pu hine Jesu kaꞌeme puni unaꞌi Huni haha taꞌarohe nihoꞌo aniꞌina reꞌeme Huni nia urijaho nihoꞌo hanane vea punaꞌi riꞌeme Huni atehijija nihoꞌo sajasaꞌina rene hanajara. ");
INSERT INTO mcq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ꞌEjume pu kiꞌeme Mosisiꞌo Iraijaꞌo Jesui puꞌúmo hina vuꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ꞌEjumakame Pitara Jesu ijá ꞌwama Natohwe nihoꞌo mamaa venareja nú iki roaraꞌomo A ura renaꞌamajaho nú ikakaro ara pina Onaꞌe vene ꞌee pina Mosisi onaꞌe vene ꞌee pina Iraija onaꞌe vejava ꞌwaꞌeme ");
INSERT INTO mcq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","niꞌaha kwino ꞌimitia hanajiꞌina puni hura kajaho saꞌeme ꞌimitia vaja kajino ira roe ijá ꞌwama Ikaho Nuni Hariha kaꞌene Na nihoꞌo ura renia parajuꞌe oja mahiꞌinijinakúne ja Huni ira hami heꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ꞌEjumakame tisaiporu ira kaji henareja nihoꞌo tea junama parajume pu puni urania mweꞌi aruhara. ");
INSERT INTO mcq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ꞌEjumakame Jesura puni roe ija ꞌuniraviꞌi ijá ꞌiama Juvujaho areꞌi kaivo ꞌuriha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ꞌEjume pu ꞌurine nia ahasirima niriajaho ea ꞌahoꞌa pakivara kaivo Jesu huhuso kavara. ");
INSERT INTO mcq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ꞌEnareja pu huriꞌa kaji rene ariha roiꞌi Jesura pu ijá ꞌiama Jara iviamajai raka kaꞌene kavakaho nihoꞌo ja ea pina paꞌwaraꞌavara. ꞌEꞌeje Emaa Puni Harihijara kwamareje kúꞌo ꞌurija kamaꞌe ijiꞌa nahama ꞌwaraꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ꞌEjumakame Huni tisaiporuepo Jesu apoma ijá ꞌwava Irakijihunaꞌe Sikuraipi Iraijara marakuꞌa rohuna ꞌúvare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ꞌEjume Jesura eha vene ijá ꞌiama Iraijara marakuꞌa urana roe uneunechaka mapokijija amairihuna. ");
INSERT INTO mcq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ꞌEnakaivo Na nimaa nimaaꞌe ꞌwaravu Iraijana ꞌwavujaho nimarako roana. ꞌEjume pu hu pahena pakavara kaivo pu apene raka kaꞌene pu ura renau jaꞌinaꞌe ꞌahaara. ꞌEnaꞌomo ijaꞌinaꞌe Emaa Puni Hariha ꞌuꞌo pura puni ijijino siseꞌi ꞌahahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ꞌEjumakame Huni tisaiporuepo hejajaho Hu Joni Papitisita rona ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ꞌEnareja pu ijiꞌa roe ea mapoka hijajino roume ea pini roe Huni unaꞌi nitupari saviꞌi ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Natohwe nuni hariha numima. Ijihuni maijaho hu naꞌia mapoka húmata siserajuꞌe nanamareꞌe ꞌone veni rene ꞌee toi ꞌonuna. ");
INSERT INTO mcq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ꞌEjuꞌe na apene Oni tisaiporue puni routa kaivo pu pavejume maranana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ꞌEjume Jesura eha vene ijá ꞌiama Ike panimaa rojiꞌina kaꞌene sisemakije Na naꞌia icharo ja puꞌúmo hiꞌejo? ꞌEne naꞌia icharo Na ja najahapena vaꞌejo? Ahema iki Nuni roha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ꞌEjume Jesura ꞌavena sisea kajaho ꞌurarahume ariha vaꞌeme niꞌaha kwino ijakaru kasimaa kajaho maranana. ");
INSERT INTO mcq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ꞌEꞌejume Huni tisaiporuapo hemi roajimareja ijá ꞌwava Irakijihunaꞌe nú ꞌavena sisea areri pasiomaho? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ꞌEjumakame Hu ijá ꞌiama Ijihuni maijaho ja hamia panimaa rojujihunaꞌe areria parenau. ꞌEnakaivo Na nimaa ja ꞌwaravu joni nimaa roijaho areri kwava ꞌina saꞌinaꞌe reꞌamajaho ja ꞌwarave huriꞌa karaho tajahena vaꞌe kamakaru namina ꞌwaꞌavajaho huriꞌa kajaho tajahene kamakaru vahuna. ꞌEne unenuꞌu pina jonunaꞌa kisina parehuna. ");
INSERT INTO mcq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ꞌEnakaivo ꞌavena sisea ikakajija pava usevura kaivo ꞌaura areme siporua ꞌojujari rejuꞌe va usevura. ");
INSERT INTO mcq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ꞌEne pu Karari ahuma hijumakiviꞌi Jesura ijá ꞌiama Emaa Puni Harihijaho emaa puni ija tahi vahuna nituꞌu renu. ");
INSERT INTO mcq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ꞌEje pu ꞌanaa kwamareje naꞌia noꞌopisu vaji namareje kúꞌo ꞌurihuna ꞌiavume pu nihoꞌo temukavara. ");
INSERT INTO mcq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ꞌEjume pu vaꞌe Kapeniami useꞌeme ea kaꞌene Temiporu takisia apejiꞌinijipo roe Pita apome ijá ꞌwava ꞌÚ joni Najahiꞌina kajaho Temiporu takisi venuna raka? ꞌwavara. ꞌEjume Pitara eha vene ꞌIꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ꞌEne hu ijiꞌa sei ajima roajaho Jesura marakoꞌa ira ꞌwarame ijá ꞌwama ꞌÚ Saimani a ichá vwihano? Mweꞌa kehuni kinijihija ea irahipo puni takisia venahure? ꞌÚ puni takisia ehwapo venahura ho ea ꞌahopo venahure? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ꞌEjume Pitara eha vene ijá ꞌwama Ea ꞌahopuna ꞌwamana. ꞌEjume Jesura eha vene ijá ꞌwama Ijihuni hahi ehwaha takisia pavenahura. ");
INSERT INTO mcq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ꞌEnakaivo vejuroꞌi pu ajinaꞌejakúne vaꞌe sohi kimai oname kija amura kaꞌene eꞌama jihuni ira jaraꞌamajaho monia tita apene Nuna ꞌee onajiꞌi takisia veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ꞌEnareja ijihuni vea kajino Huni tisaiporuepo roe Jesu apoma ijá ꞌwava Godoni arijino ea natohwijaho irane ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ꞌEjumakame Jesura kasimaa pina ꞌumejume Huni roumakame Hu apenapi puni unaꞌi ranavume naminana. ");
INSERT INTO mcq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ꞌEne ijá ꞌiama Na nimai ja ꞌwaravu ja pataꞌarohe roe kasima saꞌina pareꞌavajaho ja Godoni ara nihoꞌo pakahuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ea irara masuani ajuarane areri ike kasima kaꞌina renujara Godoni arijaho ea niꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ꞌEnakaivo ea irara Nuni iha ꞌahi kasima ikaꞌinaꞌe hami apenujaho hu Na apeniuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ꞌEnakaivo kasimakipo Na nimai roꞌeje ei pini veje amaaresume taꞌarohe ani ro vaꞌamajaho maijaho ja muna kaꞌene natohwijino apene huni uroa ꞌahi vevahamareje piꞌonave vaꞌe sohi vaji ꞌoꞌamajaho ja mamai vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ꞌEnakaivo iki mweꞌi sisea namujihunaꞌe ijihuni eha namu kaivo ike mweꞌa kehuni eijipo vejuꞌe ea ꞌahoꞌa sisea vejuraꞌomo ea kajihipuni eha kaꞌene mihunijaho namu. ");
INSERT INTO mcq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ꞌEnakaivo oni ijina ho mumori venaꞌe a sisea veꞌamajaho ijaho ꞌuhua atoꞌaruve vaꞌamana. Maijaho a núpúviꞌi onareje majama hihuna apehuna. ꞌEnakaivo a ija mumora noꞌo noꞌo reꞌamajaho a vaꞌe vena kaꞌene pautaruti saviꞌinijino rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ꞌEne oni niijara venaꞌe sisea veꞌamajaho tajahene apena ꞌonave vaꞌamana. ꞌEnaꞌavo maijaho a nia kwinu apene majama hihuni kwaijaho vaꞌe marahuna kaivo nia noꞌo reꞌamajaho vena kaꞌene majama rejiꞌi namujino piꞌonamahuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ꞌEnakúne ja hami vwihaha. Kasima ikaꞌina nihoꞌo pasenaꞌavara. Na nimaa nimaa ja ꞌwaravu. Puni ona ojiꞌina kaꞌene kahi akúpa ꞌahi hijujipo naꞌia mapokaꞌe Nuni Omijihuni unaꞌi vaꞌa roura. ");
INSERT INTO mcq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ꞌEnakaivo Ema Puni Harihijara roajaho ea kaꞌene pivusaha ojuji niꞌajiꞌi roana. ");
INSERT INTO mcq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ꞌEnaꞌomo ja icháꞌina vwihajo? Ei pini huni sipia mapoka mapoka (100) namiꞌiraꞌomo kwino pakaꞌipisa hu ichá vejaꞌe? ꞌÚ hu ꞌahoꞌa kaꞌene (99) ijija huriꞌi irechamiꞌi kaivo vaꞌe kwinuꞌwi sava raka? ");
INSERT INTO mcq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na nihoꞌo nimaa ja ꞌwaravu hu (99) ijí kiꞌamajaho teamavaꞌa kaivo kwisuꞌwi pivunonaji piunaꞌamajaho nihoꞌo teamama parahuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Areri ijaꞌinaꞌe joni Oma kaꞌene kahi akúpa ꞌahi hinujaho kasimapo kwinuꞌwi ani ro vaꞌe pivuhuna ura parenu. ");
INSERT INTO mcq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ꞌEnakúne oni ei pini a siseꞌi ꞌahaa kaꞌamajaho aꞌasu hemi vaꞌe hu huꞌúmo ꞌwama amairiꞌamana. ꞌEje hu oni ira heꞌamajaho mamaa vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ꞌEnakaivo hu oni ira paheja kaꞌamajaho a ea noꞌona ho noꞌopisu raki aherama pu puꞌúmo vaꞌamana. ꞌEꞌirakúne hu ja ichá ꞌahiꞌamajaho pura kama heꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ꞌEnakúne hu joni ira paheja kaꞌavajaho jara sosi nahama ꞌwaraꞌavara. ꞌEje hu ijí paheja kaꞌavajaho ijiꞌa makaꞌeje Jenitaru rene ꞌee takisi apejiꞌina reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ꞌEnakaivo Na nimaa nimaa ja ꞌwaravu uneunecha kaꞌene jara iki mweꞌi kamoꞌavajaho akúpa ꞌaha ꞌuꞌo kamohuna. ꞌEne jara iki mweꞌi rasaꞌavajaho akúpa ꞌaha ꞌuꞌo rasahuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ꞌEna vukúꞌo na pina ꞌwaraꞌi veju. ꞌEne ja ea noꞌo ahume iki mweꞌi nimaa veꞌi kaivo siporua ꞌone unenuꞌu pinaꞌe jariꞌavajaho Nuni Oma kaꞌene akúpa ꞌahi hinujara eha vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ꞌEne ichihi ichihi ea noꞌuna ho noꞌopisu Nuni iha ꞌahi ahuꞌavajaho Na ijino puni vaji hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ꞌEꞌeme Pitara Jesuni roe ijá ꞌwama Natohwe nuni vwei na siseꞌi ꞌahiꞌamajaho ꞌaha icharu na vwihana areꞌejo? ꞌAha iropu noꞌo vwihana areꞌejo? ꞌwavume ");
INSERT INTO mcq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesura ijá ꞌwama Na ꞌaha iropu noꞌoheꞌina paꞌwavu kaivo ꞌaha mapoka mapoka (70 x 7) vwihana areꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ikehuni hahi Godoni arijaho areri kini pini huni pwehipunaꞌi huni monia hura vajihaji piuhiꞌamajaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ꞌEjumakame vea kaꞌene hu pwehwaha piuhiani veijaho ea pina monia mapoka mapoka (K10,000,000) pukini maꞌekana. ");
INSERT INTO mcq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ꞌEnaꞌomo huni monia eha vajahuna areri parejukame huni natohwijara pikinaviꞌi ijá ꞌwama Na a oni napara ꞌee sesahuana ꞌee uneunecha ona kaꞌene navujaho ijá ꞌeka vaꞌe nuni monia eha ꞌimena ꞌekahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ꞌEjumakame huni pwea huni unaꞌi aruha arihe jarime ijá ꞌwama Natohwe a ꞌajiꞌeje nara uneunecha mapoka eha venahuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ꞌEjakame huni natohwijaho nihoꞌo ijara teamuma parajume monia pukini venajaho vwihana areꞌi kaivo makavuma vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ꞌEnarena pwea kajaho ꞌeꞌuna vaꞌe huni napura pwea pina kaꞌene hununaꞌi monia (K20) pukini naminajaho piuname uroi ꞌena apene musaviꞌi ijá ꞌwama Ara nuni monia kaꞌene pukini vene inajihuni ehiji vajiha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ꞌEjumakame pwea kajara huni unaꞌi ꞌone naviꞌi jarime ijá ꞌwama A na ajiha na ijiꞌa eha vajahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ꞌEnakaivo hu huni ira paheꞌi kaivo apene tipura ranavume ijí monia kajihuni ehiji vajahumakaviꞌi ijiꞌa ranamana. ");
INSERT INTO mcq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ꞌEjakame pwea pwina ijipo hura venaji kamareja pu nihoꞌo temukavume vaꞌe puni natohwa iraka kaꞌene renajaho nahama ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ꞌEjumakame hu pwea kajaho ꞌumejume ijí roume ijá ꞌwama A nihoꞌo pwea sisea. Nuni chimua kaꞌene onunaꞌi namajaho na vwihanaꞌe arevuta. Ijihuni maijaho a na jaririvumakame na vwihanae areꞌikaꞌi makavume Noina vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ꞌEnaꞌomo na a numiravu jaꞌinaꞌe a oni napura numiꞌipisa areri rejaꞌa? ");
INSERT INTO mcq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ꞌEꞌikaivo ea natohwijaho ajivume huni pwea kajaho apena vaꞌe tipurai raname monia kajihuni ehijaho vajihakamaꞌe ijiꞌa ranahuna. ");
INSERT INTO mcq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ꞌEnaꞌomo a vweupuni sisea pavwihana areꞌamajaho Nuni Oma kaꞌene kahi akúpa ꞌahi hinujara a ꞌuꞌo pavwihanae arehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesura vuꞌa kajaho ꞌwaravume paꞌarejume Hu ijiꞌa Karari areꞌi kaivo ꞌurine Jotani one karaꞌi Jutia vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ꞌEjume ea nihoꞌo mapoka mapoka Hu tamatiha vaꞌumakame Hu ijino venaume maraniara. ");
INSERT INTO mcq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ꞌEjumakame Parasiepo Jesu vena kamareja pu Hu ijá ꞌwava ꞌÚ ea pina huni napara varapa paꞌa mají ranaꞌipisa areri rejaꞌe? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ꞌEjume Hu eha vene ijá ꞌiama Ja nitama ea kaꞌene parua napara aneja venajaho ja pataha kavare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ꞌEne Hu vukúꞌo ijá ꞌiama Ijihunaꞌe ea omaha oaha ranaꞌi kaivo hu napara ꞌwaꞌamani veijaho noꞌo naparaheꞌi nikwinuꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ꞌEnajihuni hahi pu majaa noꞌoheꞌi pana kaivo haha nikwinuꞌina rejara. ꞌEnaꞌomo Godira raka kaꞌene ahuma venaume nikwisuꞌina rejajija veje ea paturiamae ani irechamiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ꞌEjume pu Jesu ijá ꞌwava Irakijihunaꞌe Mosisiho huni tamana vaji ei pini huni napara ranave paꞌareꞌamajaho paruaha kajara asura venapi maꞌi kaivo ranave ani vaꞌamana ꞌúma ꞌwaramane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ꞌEjume Jesura ijá ꞌiama Ijihuni maijaho joni ojijija kisimaꞌura ijihunaꞌe Mosisiho ijihunaꞌe ꞌwaramana kaivo nitama anejijaho ꞌunama ijaꞌina pana. ");
INSERT INTO mcq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ꞌEnakaivo Na ja ꞌwaravu. Ea pipuni napara parui pini ahemoꞌamajaho parua kajara areri napara kajaho ranahuna. ꞌEnajihunaꞌe parua kaꞌene huni napara kaji ranamajara napara pina ꞌwaꞌamajaho sisea vehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ꞌEjume Huni tisaiporuepo ijá ꞌwava Parua naparaheꞌo puni hia ijaꞌina reꞌamajaho maijaho napara pasame parua pavejaꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ꞌEnakaivo Jesura pu ijá ꞌiama Ike vuꞌakaho eaka mapokakija pana kaivo ea kaꞌene Godira Huni harura pu mihajipo pupuso vuꞌa kajaho hena kahuna. ");
INSERT INTO mcq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ꞌEnakaivo ea ani aniꞌina nihoꞌo napara pasavura. Ijihuni maijaho ea ꞌahoꞌa ohwapo nahenauji rene nijaꞌina rejura. ꞌEjuꞌe ea ꞌahoꞌa emaapo tanuvuꞌe napara pasavura. ꞌEjuꞌe ea ꞌahoꞌa Godoni ꞌunamiji vwihanareꞌe pu maopuipo puni ura ijine napara pasaꞌi ꞌahiuꞌe pasavura. ꞌEnakúne ei pini ike vuꞌake heꞌiro veꞌamajaho hami heꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ꞌEnakaivo ea ꞌahoꞌapo kasima aherame ꞌeka roume Jesura Huni ija puni húmata ꞌahi irechamihe siporua ꞌonaꞌavarono roajivara kaivo Huni tisaiporuepo eaka mapoka kajija ꞌurarahara. ");
INSERT INTO mcq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ꞌEnakaivo Jesura ijá ꞌiama Kasima kajija makiꞌeje Nuni roajiva kaivo ja patanuꞌuriha. Ijihuni maijaho kasima ikaꞌina Godoni arijihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ꞌEnarena Hu Huni ija puni húmata ꞌahi irechamarena Hu ijiꞌa vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ꞌEꞌeme ei pini roe Jesu ijá ꞌwama Najuhiꞌine na unenuꞌu pina maa icháꞌinaꞌe venareje majama hihunijaho apeꞌejo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ꞌEjume Jesura ijá ꞌwama A iraka vene unenuꞌu pina kaꞌene maijaho aporimo? Godira nikwinuꞌwi mamaana. ꞌEnakúne a ura majama hihuniji apeꞌi veꞌamajaho a Godoni tamaneru veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ꞌEjume hu Jesu ijá ꞌwama Godoni tamana ichihunichi veꞌejo? ꞌwavume Jesura ijá ꞌwama A ea paꞌanae kwaꞌamana. Ea ꞌahopuni napara paturiꞌamana. ꞌEe nesa paapeꞌamana. ꞌEe a ea iraꞌatijino panamaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ꞌEne emahuapuni hura veꞌamana. Oni ea kaꞌene oni rori hijujija oja miꞌamana. Areri ara oni haharu oja mahujaꞌinaꞌe miꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ꞌEjume ea kajara ijá ꞌwama Na ike tamanakija nani ijá vesihura kaivo vu ꞌahoꞌa na raka vehune? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ꞌEjume Jesura ijá ꞌwama A nihoꞌo ariramaa kajara ura rena paraꞌamajaho vaꞌe oni uneunecha kaꞌene navujija niꞌaha kwino ꞌeke ꞌimé raname oni monia ꞌeke ea kaꞌene uneunecha paꞌajihi vajiha. Ijaꞌina veꞌamajaho oni uneunecha mapoka kahino akúpa ꞌahi navakiviꞌi ijiꞌa túnaꞌi Na ꞌararihie roꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ꞌEjumakame ea kajaho hu ijí henarena hu nihoꞌo temuma paraꞌeme vaꞌana. Ijihuni maijaho hu uneunecha nihoꞌo mapoka rukini jihunaꞌe avanana. ");
INSERT INTO mcq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ꞌEꞌeme Jesura Huni tisaiporu ijá ꞌiama Na nimaa nimaa ja ꞌwaravu ea kaꞌene uneunecha mapoka rukinijipo Godoni ꞌunami vahunijaho nihoꞌo kisina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ꞌEne Na vukúꞌo ja ꞌwaraꞌi veju. Maha nitirua huni titi vaji aruma vahuna samaa kaivo ea kukua uneunecha rukimaꞌurijara Godoni ari vahunijaho kikisimaꞌura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ꞌEjumakame Huni tisaiporuepo ijí vuꞌa kaji henareja pu nihoꞌo oja hwaꞌusahaꞌeme pu Hu ijá ꞌwava Ea irara areri Godoni ea reꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ꞌEjumakame Hu pu niimaru kiviꞌi ijá ꞌiama Eaka mapokakipo ijaꞌina vehuna nihoꞌo areria pana kaivo Godira Huhuso ijá kajaho vehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ꞌEjumakame Pitara eha vene ijá ꞌwama Nú uneunecha kaꞌene mapokijija Onijihunaꞌe niareꞌi kaivo nú A ꞌarariha ojaraꞌomo nú iraka ꞌekahune? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ꞌEjume Jesura pu ijá ꞌiama Na nimaa nimaa ja ꞌwaravu. Vea kaꞌene mweꞌa maiuꞌina veꞌavari veijino Ema Puni Harihijara Huni ruha hanajiꞌina kaꞌene asuma hiꞌamajino ja ea kaꞌene nú puꞌúmo ojukija ruha iropu ropu noꞌoheꞌi ijí asuma hinareje Isureri opuni ituha iropu ropu noꞌo navujija ꞌotua vetihuna. ");
INSERT INTO mcq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ꞌEjakame ea kaꞌene Nuni ihijihuni hahi puni ara irechame puni ꞌuꞌua poka irechame ꞌee maꞌipija irechame oha oma irechamie ꞌee puni mweꞌa irechame hariha irechamiu ijija pu nihoꞌo eha mai mapoka mapoka ꞌekahuna ꞌee majama hihuna apehuna. ");
INSERT INTO mcq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ꞌEnakaivo ea kaꞌene iviamaa urana vaꞌujija túnaꞌi rehuna kaivo ea kaꞌene masuani túnaꞌi vaꞌujija urasahuna. ");
INSERT INTO mcq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ꞌEnakaivo ijí Godoni arijihuni ꞌunamijaho areri ei pini kwai huni ajina juara naꞌiraꞌomo hu ninaꞌi arihe pwehwaha aherame ijino kaukara veꞌiro vaꞌujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ꞌEjukame hu teamama paraꞌejuꞌe pwehwaha ijá ꞌiama Ja kaukara iviasi veꞌavajaho monia tita vajihuna ꞌiamana. ꞌEjume pu kaukara veꞌi vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ꞌEjumakame hu súꞌu súꞌu vea ajiru naminu kamino namiꞌeme vaꞌi kimajaho maketia kwai ea ꞌahoꞌa onekajaho paveꞌi kaivo maijino namimaravuma kimana. ");
INSERT INTO mcq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ꞌEjumakame hu pu ijá ꞌiama Ja ꞌuꞌo vaꞌe aja ꞌina juasiꞌi kaukara vejakame na ja eha areri renahuna vajiꞌuta ꞌiavume pu vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ꞌEꞌeme hu vea ꞌuꞌarirakano naminajaho nijaa venanaꞌomo vukúꞌo vea hareha ꞌaha karo karu naminaji ꞌuꞌo ijá venana. ");
INSERT INTO mcq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ꞌEnarena vukúꞌo vea niꞌoꞌirono veꞌeme vaiꞌi kivume ea ꞌahoꞌa niiji ruha kajino namina ojara. ꞌEjuma kimarena hu pu ijá ꞌiama Ja iraka vene roe maꞌuraha ikino namina ojo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ꞌEjume pu hu ijá ꞌwava Ijihuni maijaho ea pina nú kaukara pamúhuꞌe avaju ꞌwavara. ꞌEjume hu pu ijá ꞌiama Ijinakúne ja ꞌuꞌo vaꞌajime juasiꞌa kajino kaukara veha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ꞌEꞌeme vea nusirevume ea kaꞌene juara anesurijara roe namikia ꞌwaravume hura ea kaꞌene kaukara vejiꞌinijija ꞌumenaume niana roumakiviꞌi ea kaꞌene túchamai roajivajino marakuꞌa eha vajiharenaꞌe ijiꞌa ea kaꞌene urasaha roajaho vajihana. ");
INSERT INTO mcq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ea kaꞌene nusire mai aneja vene kaukara vejajija eha monia tita apejara. ");
INSERT INTO mcq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ꞌEjumakame ea kaꞌene nimarako roe vejajipo vwihajajaho pu monia niꞌina apeꞌeja rojara kaivo pu ꞌuꞌo eha nijaꞌina monia tita vajihana. ");
INSERT INTO mcq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ꞌEjumakame pu ijí puni monia kajaho ꞌekareja ijiꞌa ea kaꞌene juara anesurijaho chichahaara. ");
INSERT INTO mcq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ꞌEnakaivo ea kaꞌene túchamai roajija vea maꞌuako kaukara vejara kaivo nú ea kaꞌene nimaraku roajivajija vea niꞌina ꞌeꞌune ꞌanúe kaukara harura vejara kaivo eha kaꞌene nú múha kajaꞌinaꞌe pu mihana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ꞌEjume ijí ea kaꞌene juara anesurijara ea kwino ijá ꞌwama Ea nune ike hena na ja pasiseꞌi ꞌahiu kaivo nú ja puꞌúmo nimaraku ꞌwavajaho ja monia tita iviasi kaukara vehuna avacharavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ꞌEnakúne joni eha ꞌekareje joni ari vaꞌavara. Nara eaka túchamai roaji eha areri ja mihu kajaꞌinaꞌe vajiꞌujaho nara nuni ura ijino nijaꞌina vajiꞌejukúne pavwihaꞌavara vo vaꞌajiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ꞌÚ nuni monijaho nara ura reniujaꞌinaꞌe vehuna arerine? Na mamaa kaivo ja na kivujaho sisea kivo? ");
INSERT INTO mcq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ꞌEnajihunaꞌe ea kaꞌene urasahujija túnaꞌi reje ꞌee ea kaꞌene túnaꞌi rejujija urasahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ꞌEꞌikaivo Jesuho Jerusaremi vaꞌi ꞌahaume Hu Huni tisaiporu iropu ropu noꞌo ijá aherama ro vaiꞌi ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Hami heha nú iviamaaja kahino Jerusaremi vaꞌakame pirisiti mamaꞌina Sikuraipia mamaꞌinijipo Emaa Puni Harihijaho apene namahe ꞌanae kwaꞌamarono vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ꞌEne pu Hu apene Jenitaru mihe pu apene sipana asutie ꞌee hijahe ꞌee icha ꞌahi raname nerui ꞌanahuna. ꞌEjakame naꞌia noꞌopisu paꞌareꞌeje vukúꞌo ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ꞌEjumakame Sepati oni harihija noꞌoheꞌi jihipuni ohijara harihwaha noꞌoheꞌi aherame roe Jesuni unaꞌi nuana vetie unenuꞌu pina Hu jarimana. ");
INSERT INTO mcq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ꞌEjume Jesura hu ijá ꞌwama A iraki ura renao? ꞌwamana. ꞌEjume napara kajara ijá ꞌwama Vea kaꞌene Ara ea mapokakehi ꞌajohaꞌamani veijino ike nuni harihijakija pina Oni ija manaꞌinijaꞌi asumahije ꞌee vu pina Oni ija anaꞌinijaꞌi asuma hihuniji nahama ꞌwarima ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ꞌEjumakame Jesura pu ijá ꞌiama Ja nihoꞌo raka kaꞌene jara jaririvu kajihuni maijaho pahene pakaviꞌi maiji avaju ꞌiamana. ꞌEjiꞌi Hu ꞌijá ꞌiama ꞌÚ ja Nara kapusia kaꞌene maiꞌo ihunijaho ja areri ijaꞌina iꞌeja ꞌiavume pu ijá ꞌwava ꞌIꞌa nú areri iꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ꞌEjume Jesura ijá ꞌiama Ja nimaa Nuni kapusia vaja areri iꞌeja kaivo maiꞌo ea kaꞌene Nuni ija manaꞌinijaꞌi asuma hine ꞌee anaꞌinijaꞌi asuma hihunijaho Na ijija areri ijá pavajihuna. Ijí ruha kaꞌene Nuni Omijara amairiujaho ea irahijaꞌe iji pijiha jihipunaꞌe amairiahana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ꞌEjumakame Huni tisaiporu ꞌahoꞌa kaꞌene iropu ropu ijija ijí vuꞌa kaji henareja pu ijí ꞌuꞌuaheꞌo pokaheꞌo punaꞌi nihoꞌo ajinavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ijihunaꞌe Jesura pu ꞌumenaume nianae Huni roume Hu ijá ꞌiama Ja nihena kivura. Jenitaru puni ꞌajohaꞌina mamaꞌina ꞌahoꞌijija vu ajisina ꞌahopo ꞌajoahaura. ");
INSERT INTO mcq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ꞌEnakaivo ijí ꞌunama kaꞌene ijáꞌinijija joni vaja kajaho panahuna. ꞌEnakaivo ea irara ura joni vaji natohwa reꞌi veꞌamajaho hu joni pwea reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ꞌEne ijí joni vaji ei pini ꞌuraꞌi veꞌamajaho hu joni pwea reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ema Puni Harihijara roujaho ea mapoka Huni pwea pareꞌavarono roana kaivo Hu puni pwea reꞌi ꞌahaume roana. Hu Huni hia ea mapokaꞌe mihana. Areri ema ꞌimenaana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ꞌEjume Jesu ijí Jeriko rene vaꞌeme ea mapoka puaꞌe ꞌararihie vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ꞌEꞌejume ea noꞌoheꞌi nia supamaꞌinapo ꞌunamu toi hiꞌeme Jesuho vaꞌe puni rori vaꞌuma henareja pu Hu jarime ijá ꞌwava Natohwe Teviti oni Harihakera nú numiruma ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ꞌEjumakame eaka mapoka kajipo pu ꞌurarahe ijá ꞌiava Irunoꞌa areha ꞌiavara. ꞌEjumakame ea kajipo noꞌo ira ajira ijá ꞌumeja Natohwe Teviti oni Harihakera numiruma ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ꞌEjumakame Jesu areme ijá namijiꞌi pu ꞌumenae ijá ꞌiama Ja ura Na joni raka venaꞌejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ꞌEjume pura ijá ꞌwava Natohwe nú ura Ara nuni nia venuhe niriꞌirono ꞌwaravu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ꞌEjumakame Jesura pu numiramarena Huni ija puni nia ꞌahi irechamihume puni nia maraniume pu Jesui puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ꞌEnareja pu vaꞌe Jerusaremi rori Petapeje Arivi huriꞌi ꞌuseviꞌi Jesuho Huni tisaiporua noꞌoheꞌi irechamiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Hu pu ijá ꞌiama Ja noꞌo vaꞌe ara ropunaꞌi va ꞌuseviꞌi kave tonikia kaꞌene iꞌivananave ꞌuꞌuijiꞌi namija kaꞌavaji aherame Nuni roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ꞌEꞌeje ea ꞌahopo unenuꞌu pina ja ꞌwarava heꞌavajaho ijá ꞌwaraꞌavara Natohwijara ura rejukame nú roe ikaho apeju ꞌiꞌi kaivo apejakame pu ja mihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ijí Hura ijá venajihuni maijaho nitama poropeti vuꞌa kaꞌene ꞌwaramajara nimaa nimaa reꞌamarono avanana. ");
INSERT INTO mcq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ja Saiani oni ꞌapajiji ijá ꞌwaraꞌavara. Joni Kinia joni rou. Hu masuani tonikia ꞌahi hiꞌejuꞌe rou. Hu ijí tonikia ꞌuꞌua kaꞌene kúchini ꞌahi hiꞌejuꞌe rou ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ꞌEjumakame tisaiporua kajija vaꞌe raka kaꞌene Jesura ꞌwaramajaho ijá vejara. ");
INSERT INTO mcq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ꞌEnareja pu vaꞌe tonikijaho ahema roumakame ꞌuꞌua hunijaho ijí hu huꞌúmo roana. ꞌEjume pu ijí huni ꞌahi ateha risaremahume Jesuho ajima ijihuni ꞌahi hinana. ");
INSERT INTO mcq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ꞌEꞌeme ea mapoka puni atehi jahena Huni unaꞌi ꞌunama toi risarema apena vaꞌume ꞌee ea ꞌahoꞌa icha anumi ꞌuhue ꞌeke ꞌunama toi Hura ijihuni ꞌahi vaꞌamaroreja risarevara. ");
INSERT INTO mcq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ꞌEjiꞌi ea mapoka kaꞌene Huni unaꞌi vaꞌe ꞌee túnaꞌi vaꞌajipo ira ajira mwasiriviꞌi ijá ꞌumeja Teviti oni Hariha taꞌaroha Natohwi jihuni iha ꞌahi ea kaꞌene roujaho merajaho. Hu taꞌarohe Huni iha ꞌunama apene ichu toi ahasiriha ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ꞌEꞌeme Jesuho vaꞌe ijí Jerusaremi vaꞌuma kamareja ea mapoka kajipo oja hwaꞌusunahaꞌeme ijá ꞌwava Ikaho ea irarane ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ꞌEjumakame eaka mapoka kajipo ijá ꞌwava Eakaho Jesu kaꞌene poropetia Nasareti Karari vaji rena roana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ꞌEꞌeme Jesura vaꞌe ijí Temiporu kajino arumarena ea kaꞌene ijí arume ꞌimearavajaho arukunie ꞌee ꞌararihie ꞌee pura ꞌaijua kaꞌene hine monia senisu vene ꞌee hine uka ꞌimearava kajaho ꞌunirame ꞌeka arohume ꞌuseusahara. ");
INSERT INTO mcq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ꞌEjumakiviꞌi Hu pu ijá ꞌiama Godoni ira heha ꞌahi ikaꞌina ꞌwarumana. Nuni seijaho nikwinu siporuaru ꞌohuni sea ꞌwavura kaivo jara iviamajai apena vejuꞌe nesa apejuri sea renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ꞌEꞌejume ea kaꞌene nia supaviꞌina ꞌee ea kaꞌene irimaꞌinijipo ijí Temiporu vaja kajino Huni roumakame Hura vejume maraniana. ");
INSERT INTO mcq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ꞌEjumakame pirisitia mamaꞌinijija Sikuraipia ijí Hura uneka mamai kaꞌene venaji kiꞌeme sesamai kaꞌene ijí Temiporua vaja kajino hijajipo mwasiriviꞌi ijá ꞌumeja Teviti oni Hariha taꞌaroha ꞌumejara. ꞌEjume pu nihoꞌo ajinavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ꞌEjumakame pu Jesu ijá ꞌwava ꞌÚ ijí pura ira kaꞌene ꞌwaravu kajaho A niheno? ꞌwavara. ꞌEjume Jesura ijá ꞌiama ꞌIꞌa ijaꞌinaꞌomo ja vina nitama Godoni ira vaji ikaꞌina ꞌwarumajaho kasima ꞌee musia ijihipu irijaho ja raka kame pura Natohwiji taꞌarohunijaho ja pataha kavara raka? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ꞌEꞌikaivo Hu pu irechamiꞌi kaivo ara kajaho areme Petani vaꞌe hinana. ");
INSERT INTO mcq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ꞌEnaꞌomo ijihuni súꞌuhijino Hu vukúꞌo ꞌunama ari natohwi vaꞌeme ꞌunamutoi matumana. ");
INSERT INTO mcq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ꞌEꞌeme roi kavume matakijaho ꞌunamu rori namijuma kamarena maa rena namu roꞌi kaivo vaiꞌi kamajaho ꞌina paꞌana kamarena ijá ꞌwama A nihoꞌo vukúꞌuha maa pareꞌena ꞌwavume niꞌaha kwino saranana. ");
INSERT INTO mcq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ꞌEjumakame Huni tisaiporuepo ijí mataka kaji kaꞌeme sarajumakame oja hwaꞌusunahaꞌeme aposarama ijá ꞌwava Ichá vene ike matakakaho iviamaa Huni iri ꞌahi sarano? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ꞌEjume Jesura ijá ꞌiama Na nimaa nimaaꞌe ja ꞌwaravu Ja ꞌunama nikwinu nimaa roꞌavajaho ja areri ike iviamaa matakake renajaꞌineru pavehuna kaivo jara huriꞌake ikaꞌina ꞌwarave hu tajaheuna ꞌurina vaꞌe sohi ꞌona ꞌwave ijá rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ꞌEne ja nihoꞌo nimaa nimai roꞌi kaivo unenuꞌu ꞌahoꞌa Godi jariꞌavajaho ja ꞌekahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hu vaꞌe Temiporu vaji hine ea najaꞌeme pirisiti mamaꞌina ꞌee Jua puni emakinepo roe Jesu apoma ijá ꞌwava A harura irakijara rejuꞌe uneunechakija veno? ꞌÚ ea irara harurakaho mahuꞌe avano? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ꞌEjume Jesura ijá ꞌiama Na ꞌuꞌo ja aporave ja ijihuni maa ꞌwariꞌavajiꞌa Na ꞌuꞌo harura kaꞌene raki rejuꞌe Na vejujaho ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ꞌÚ Joni Papitisita kahi akúpi ꞌahi rena roana ho ema puni rena roane? ꞌiamana. ꞌEjumakame pu hine ꞌwama apene puni vaja kaji ꞌojiꞌi ijá ꞌwava Nú akúpi ꞌahi rena roana ꞌwaꞌavajaho Hu ijá ꞌúhune ja rakijihunaꞌe ijí Jonira raka kaꞌene ꞌwaramajaho panimai rojo? ꞌúꞌena. ");
INSERT INTO mcq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ꞌEne nú emaapuni rena roana ꞌwaꞌavajaho nú eaka mapokijihi juhavu. Ijihuni maijaho eaka mapokijipo hena kavajaho hu poropetia vwihajara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ꞌEnareja pu Jesu ijá ꞌwava Nú puruva renu ꞌwavara. ꞌEjume Jesura ijá ꞌiama ꞌEnaꞌomo Na harura iraki apene uneunechakaho vejujaho paꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ꞌÚ ja ichá vwihajo? Ea pina huni harihija noꞌoheꞌinaꞌomo hu pokijihuni vaꞌe ijá ꞌwama Harihavuro! A iviasa vaꞌe ajina juari kaukara veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ꞌEjume Hu ijá ꞌwama Na vahuna ꞌwamana kaivo hu pavaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ꞌEjume hu vukúꞌo vaꞌe ꞌuꞌuijihuni vaꞌe vuꞌaka nikwinuꞌina kajaho ꞌwaramana. ꞌEjume Hu ijá ꞌwama Na pavahuna ꞌwaꞌi kaivo hu ijiꞌa areme túnaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ꞌEnakaivo ea iraka saꞌinijara omahoni ira hene venane? ꞌiamana. ꞌEjume pu ijá ꞌwava ꞌUꞌuijarana ꞌwavara. ꞌEjume Jesura ijá ꞌiama Na nimaa nimaa ja ꞌwaravu. Ea kaꞌene takisia apejiꞌina ꞌee ea kaꞌene ꞌuasa vejiꞌinijipo asitahe urasahe Godoni ara vahuna. ");
INSERT INTO mcq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Joni roe ꞌunama kaꞌene arimaiji ja najahana kaivo ja panimai roꞌeme ea kaꞌene takisia apejiꞌina ꞌee ea kaꞌene ꞌuasa vejiꞌinijipo nimaa rojara. ꞌEnakaivo ja túnaꞌi ijaho kavara vo ja joni oja pataarohe panimai rojara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ꞌEꞌikaivo vukúꞌo Jesura ijá ꞌiama haa pinake heha. Ea pina mweꞌa anesura ajina juara mene ajina ꞌone ijikano uja pimena raname ꞌee vera iramapi tauhuhe ꞌee ꞌwainia tautahuni ruha ꞌume amairie ꞌee ijí juasiꞌa kajino namine aiha vehuni tinia vene ijí juara kajaho ea kaꞌene moni juara vejiꞌini jihipuni ija tahi ranaꞌi kaivo hu kwaa jopatuꞌuri vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ꞌEnaꞌomo vea kaꞌene ajina marasahuni vea niturajumakaviꞌi hu huni pwehija irechamiume ijí ea kaꞌene juasiꞌa ꞌajohu kajihipuni ajina ꞌekaꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ꞌEjumakame ea kaꞌene juara kaji ꞌajohujipo pwea pina hijahe pina ꞌanaume kwavume pina muni one hijahume kwamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ꞌEjume hu kúꞌo pwehwaha ꞌahoꞌa ꞌuꞌo irechamiume vaꞌume vukúꞌo marako ahia kajaꞌinaꞌe ꞌaniume kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ꞌEjumakamaꞌe ijiꞌa túnaꞌi hu huni hariha pina ranavume vaꞌeme hu ijá rona Pu nuni hariha kehuni hura veꞌeja ronana. ");
INSERT INTO mcq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ꞌEjumakame ea kaꞌene ijí juara kaji ꞌajohajipo hariha kaji kamareja pu kosarama ika ꞌwava Eakara roareje omahoni uneunecha mapoka ꞌekaꞌenakúne roe ꞌanaa kwamama. ꞌEjakame huni aachikaho núna renama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ꞌEnareja pu hu apene piꞌonavume samai vaꞌumakaviꞌi ꞌanauma kwamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ꞌEnaꞌomo ijí juara anesura kajara roꞌamajaho ea kaꞌene juara kaji ꞌajohujija ichá ꞌahihune? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pu Hu ijá ꞌwava Hu pu nihoꞌo eha sisea niꞌimaꞌura mihe ꞌanie tirahakiviꞌi vu juara kajaho ea ꞌahoꞌaꞌe mihe ꞌajohe hiꞌiraꞌomo vea kaꞌene ahaja ihuni veijara roakaviꞌi pura ꞌiruma eiria vajahuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Vukúꞌo Jesura pu ijá ꞌiama ꞌÚ ja nitama Godoni ira vaji ꞌwaramajaho pataha kavure? Hu ikaꞌina ꞌwaramana. Ijí muna kaꞌene ara vejiꞌinapo piꞌonava kajara iviamaikaho ara kajihuni kúrúti tukeja natohwaꞌe rena naminu. ꞌEnajihunaꞌe Natohwijara uneunecha kaꞌene mamaijija vejuꞌe roe samaahiravuꞌe nú kivo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ijihunaꞌe Na nimai ja ꞌwaravu. Godira Huni ara kaꞌene ikino joni vaji namujaho apene ea ꞌahoꞌa mihe pu hami ꞌajohakame ꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ꞌEꞌeje ei pini ꞌone muna ꞌaha kajino ninaꞌamajaho hu nihoꞌo puꞌusahe maꞌuꞌumai rehuna kaivo muna kajara ꞌone emai ꞌahi ninaꞌamajaho ea kajaho nihoꞌo puꞌusahe túa rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ꞌEjumakame pirisitia mamaꞌinijija ꞌee Parasia Jesuni haa kaji hejajaho pua rona ꞌwaravuma hejara. ");
INSERT INTO mcq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ꞌEnareja pu ꞌunama same Jesu ꞌanaꞌi ꞌahiara kaivo ea mapoka kajipo vwihajujaho Hu poropetia rojujihunaꞌe jumareja makavara. ");
INSERT INTO mcq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ꞌEꞌejume vukúꞌo Jesura eha vene haa ꞌwaramarena ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Godoni arijaho areri kinia natohwijara hariahi napasineꞌi vejuꞌe ꞌiruma vei venujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ꞌEnarena hu huni pwehija irechamiume pura ꞌona apene ara ꞌahosupuni vaꞌe ꞌwarave pura roe ꞌiruma kajaho iꞌavarono ꞌwaravume vaꞌe ꞌwaravara kaivo pu uchaꞌasahe paroara. ");
INSERT INTO mcq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ꞌEjume hu vukúꞌo huni pwehija ꞌahoꞌa irechamie ijá ꞌiama Vaꞌe ea kaꞌene nara ꞌumenaujija ika ꞌwaraꞌavara. Núni ꞌiruma amairie ꞌee maha amene ꞌee hanuha ꞌeka roe amairie uneunechaka mapokijija niareri rena hijukúne roajiha iꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ꞌEjume ijí huni pwehija kajipo vaꞌe ꞌwaravara kaivo pu uchaꞌasahe ea pwinaꞌa puni juasiꞌi vaꞌume ea pwinaꞌa puni moni kaukara vejara. ");
INSERT INTO mcq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ꞌEjumakiviꞌi ea ꞌahoꞌijipo ijí pwehija kajija ꞌeke hijihaꞌe ꞌee ꞌaniuma kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ꞌEjumakame kinia natohwa kajaho henajaho ijara ajivume hu huni amia irechamiume pura roe ea kajija ꞌanii raname ꞌee puni ara kwaa kajaho veni jaume reranamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ꞌEjume hu pwehwaha ijá ꞌiama Ike napasi nejari ꞌirumakaho niamairia irechavara kaivo ea kaꞌene ꞌwaravajija paroara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ꞌEnakúne iviamajai ma ꞌunamaka mapokakino vaꞌajimareje eaka mapokijihi piuniꞌavajaho ꞌwarave pura roe ike napasi nejuri ꞌirumakaho iꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ꞌEjumakame pwehwaha kajijahija ꞌunamutoi vaꞌe ea kaꞌene piuniva kajaho aherama roe ahumu vaꞌume ea sisea ea mai ijiꞌi aherama roume napasi nejuri sea kajaho hijume ituꞌoꞌunana. ");
INSERT INTO mcq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ꞌEꞌejume kinia natohwa kajara vaꞌe ijí vaji arume kiꞌiro vaiꞌi kamajaho ea kwino ijí ateha maa paapúsamana kamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ꞌEjumakame kinia kajara ea kajaho ijá ꞌwama Ea nune a ichá vene napasi nejuri ateha paapúsaꞌikaꞌi roane? ꞌwavume ea kajaho huni vwiha paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ꞌEjumakame kinijara pwehwaha ꞌwaravume pura eakaho apene ija mumora kamome apene piꞌonavume maꞌahi nutuma namajino vaꞌarena nirame ꞌee upaja chanichaniviꞌi namana. ");
INSERT INTO mcq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ꞌEnajihunaꞌe Godira ea mapoka ꞌumenau kaivo ea makwinu kwinu iji pijihana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ꞌEjumakame Parasi ijí henareja vaꞌe kanisorua puꞌúmo ahuma hine ꞌunama icháꞌina venareje Jesura ꞌwarama kajihuni ꞌahi pataꞌaroꞌi kaivo tanuꞌuraꞌirono ꞌunama savara. ");
INSERT INTO mcq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ꞌEnareje pu puni pwehija ꞌee Heroti oni pwehijijihi puꞌúmo irechamiume Jesuni vaꞌareja pu ijá ꞌwava Najuhiꞌine nú nihena kavu A vuꞌa nimaaru ꞌwaramuna. ꞌEne Godoni ꞌunama kaꞌene aririjiru ea mapoka najahuna. ꞌEne A ea kwinuru pavwihanuna. ꞌEne eaka mapokijija ira nikwinu ꞌwaramuna. ");
INSERT INTO mcq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ꞌEnakúne Ara vwihana ꞌwaruva heja A vwihanujaho nú ea iha Sisa oni takisia veꞌeja ho pane ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ꞌEjumakame pura Jesu pisiviꞌiro vejajaho Hu nikima henarena ijá ꞌiama Ea kaꞌene iraꞌasinakije ja raka vena Na vena kivo? ");
INSERT INTO mcq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Iviamajai monia kaꞌene takisia apejujaho najiha kavume ꞌiavume pu oma kwinu nahara. ");
INSERT INTO mcq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ꞌEjumakame Hura pu aporama ijá ꞌiama Ikaho irahuni ihe ꞌee ikaho irahuni pikisaꞌe ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ꞌEjume pu Hu ijá ꞌwava Ikaho Sisa ona ꞌwavara. ꞌEjume Hu ijá ꞌiama Ijinakúne Sisa oni uneunechijaho Sisa vajaha kaivo Godoni uneunechijaho Godi vajaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ꞌEjumakame pu ijí henareja oja hwaꞌusuna-haume pu Hu raname ani vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ꞌEꞌeme veaka nikwinuꞌina kajino Sajusia kaꞌene kwamasahiꞌinijija kúꞌo paꞌurihuna rojuraꞌomo hu Huni roe Hu apovara. ");
INSERT INTO mcq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ꞌEne Najuhiꞌina Mosisi oni tamana vaji ꞌwarumajaho ei pini napasi nenareje naparaha hariha panaheꞌeje hu kwaꞌamajaho huni ꞌuꞌuijara napara kajaho ahemareje huni hariha nahesamahuna ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ꞌEnaꞌomo nuni vajakino nú ea iropu noꞌoheꞌinaꞌomo pokijara marako napara ꞌwahumakame naparaha hariha panaheꞌeme hu kwamana. ꞌEjume vu ijihuni niꞌajahijara napara kajaho ahemana. ");
INSERT INTO mcq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ꞌEnarena vu ijí pokijihuni nijahijara ꞌuꞌo ahevume kame ijá vene apena vaꞌe túchamai ꞌuꞌuijihuni usevara. ");
INSERT INTO mcq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ꞌEꞌeme ijiꞌa napara kaji ꞌuꞌo kwamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ꞌEnaꞌomo vea kaꞌene vukúꞌo ea kwamasahiꞌinijipo ꞌuriꞌavari veijaho hu irahuni napara reꞌena? Eaka mapoka kajihi puni napara renana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ꞌEjumakame Jesura eha vene ijá ꞌiama Ja hami paꞌwaravu. ꞌEe Godoni irijaho pahena pakavu. ꞌEe ja Godoni harura pakavuraꞌomo ja hine ira sisea ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ea kaꞌene kwamasahiꞌinijipo ꞌurimaraꞌavajaho vukúꞌo panapasi nehuna kaivo niareri ona ojiꞌina kaꞌene kahi akúpa ꞌahi hijujipo hijujaꞌinaꞌe hihuna. ");
INSERT INTO mcq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ꞌÚ ja Godoni ira vaji ea kaꞌene kwamasahiꞌinijipo ꞌurimarahuna kaꞌene Godira ikaꞌina ꞌwarumajaho ja pataha kavare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Hu ijá ꞌiama Na Eparahami oni Godi ꞌee Aisiki oni Godi ꞌee Jekapi oni Godia. Na kwamasahiꞌini jihipuni Godi pana kaivo Na majama hijiꞌinijihipuni Godi ꞌúmana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ꞌEjumakame ea mapoka ijí Hura najaha kaji henareja pu oja hwaꞌusunahara. ");
INSERT INTO mcq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ꞌEjume Parasiepo hejajaho Jesura Sajusia puni vuꞌa tanuvuma henareja pu niꞌaha kwino nianaa roe huni rori ahuvara. ");
INSERT INTO mcq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ꞌEꞌeme puni vaja kajino Jua puni ꞌotua ꞌajohiꞌinijara Jesu vena kaꞌi ꞌahaume apoma ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Najuhiꞌine Mosisi oni tamana irakijara tamanaka mapokijaho asitaha paranane ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ꞌEjume Hu ijá ꞌwama Nihoꞌo niꞌimaꞌurijaho Godi kaꞌene joni Natohwiji joni oja mahoꞌo niꞌaha kwino mahe ꞌee joni vwiha mahoꞌo niꞌaha kwino mahe joni harurijiꞌi mahoꞌo niꞌaha kwino Hu mahuna. ");
INSERT INTO mcq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tamana ijara kwino niꞌinane ꞌee ijara kwino urana namu. ");
INSERT INTO mcq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ꞌEnakaivo vu tamana pina kaꞌene ijihuni rorijaho niareri ijaꞌina jara joni hahaꞌe vwihajujaꞌina ea kaꞌene joni rori hijujija oja miꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ike tamana noꞌoheꞌikipo tamanaka mapokijija ꞌee poropetia puni vuꞌijaho ꞌuninamie navu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ꞌEꞌikaivo Parasia kajija ahuvumakiviꞌi Jesura ikaꞌinaꞌe aporamana ");
INSERT INTO mcq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ꞌÚ ja Kerisoho icháꞌina vwihajo ꞌee Hu irahuni Hariha rojo? ꞌiavume pu Hu ijá ꞌwava Teviti oni Hariha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ꞌEjume Hu pu ijá ꞌiama ꞌEne ꞌunama irakijino Godoni ꞌAveni vejume Tevitiho Hu Natohwijiꞌo ꞌwamane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ꞌEjume Natohwijara ijá ꞌwamana Nuni Natohwe Nuni manaꞌinikaꞌi asuma hija kamareje Nara oni nanaꞌejiꞌina oni mumora hari irechamahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ꞌÚ ꞌunama icháꞌinijino Tevitiho Hu rone nuni Natohwe ꞌwamana reꞌamajaho Hu ꞌunama icháꞌiniji Huni Hariha renane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ꞌEjume ea pina nihoꞌo Jesuni vuꞌa kajaho areri eha paꞌwaravara. Ijihuni vea kaji rene ijí kahi ijaho Hu juhamareja vukúꞌo túnaꞌa unenuꞌu pina paapovara. ");
INSERT INTO mcq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ꞌEjume Jesura ea mapoka ꞌee Huni tisaiporua ijihi puꞌúmo ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Sikuraipia ꞌee Parasia vwihajujaho pu Mosisi oni tamana nihena kama parajiꞌina rojura. ");
INSERT INTO mcq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ja pura raka kaꞌene ꞌwaravujija vejurakúne pura ꞌunama kaꞌene vejujijahija paveꞌavara. Ijihuni maijaho pu manajahura vo ijihipuni maijijahija pu pavejura. ");
INSERT INTO mcq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pu uneunecha kaꞌene ahisinijijahija iramareꞌe ꞌeka ꞌurine ea ꞌahopuni sireha ꞌahi nahuchamihura kaivo ijí pura maꞌuakuꞌwi ꞌunama niꞌajihe ꞌunira ꞌurihuna nihoꞌo pavejura. ");
INSERT INTO mcq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Uneunecha kaꞌene pura vejujijahija emaapo kiꞌavaroreꞌe pu ijá vejura. Pu era kiꞌavaroreꞌe túkua kaꞌene Godoni ira ijihuni vaji naviꞌinijaho ꞌeke ꞌee ateha aniꞌiniji same ꞌurahojura. ");
INSERT INTO mcq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ꞌEne vea kaꞌene ahaja ijuri veijaho pu ura eaka mapoki jihipuni unaꞌi hiꞌirono ura rena parahuna. ꞌEne pu Sinakoku ijikano eaka mapokijipo kiꞌavaroreꞌe ꞌunaꞌi kama hijura. ");
INSERT INTO mcq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ꞌEne pu maketia vaji emaapo pu ꞌajorahunaꞌe ura renaura. ꞌEe emaapo najahiꞌina iꞌeje ohuna ura renaura. ");
INSERT INTO mcq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ꞌEnakaivo ja paveje ea ꞌahoꞌa ja najahiꞌina ꞌiꞌavara. Ijihuni maijaho joni Najahiꞌinijaho kwinuꞌwina. ꞌEnakaivo ja Huni vwehija. ");
INSERT INTO mcq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ꞌEnakúne ja mweꞌakino ea pinaꞌe nuni Ome ꞌwaꞌava. Ijihuni maijaho joni Oma kwinuꞌwi kahino akúpa ꞌahi hino. ");
INSERT INTO mcq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ꞌEnakúne ja paveje ea ꞌahoꞌa ja rone núni mamaꞌinijihije ꞌiꞌava. Ijihuni maijaho joni Natohwijaho kwinuꞌwi Kerisona. ");
INSERT INTO mcq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ꞌEnakaivo joni ei pini hu ura natohwa reꞌi ꞌahaꞌamajaho hu joni pwea rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ea irara oriꞌini huni pinana ahasiriꞌamajaho Godira vetie hu ajuarana ohuna. ꞌEnakaivo ea irara oriꞌini ajuarana oꞌamajaho Godira vetie huni pinana ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ꞌEnakaivo Sikuraipi ꞌee Parasia kaꞌene iraꞌasinakije joni eha sisea namu. Ijihuni maijaho eaka mapokijipo ꞌunama kaꞌene Godoni ari vahuniji jara hina tanuꞌurihu. Jara Godoni ara kajaho pavaꞌi ꞌahiuꞌe ea ꞌahopo pavaꞌavaroreꞌe ja ijihunaꞌe tanuꞌurihura. ");
INSERT INTO mcq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Sikuraipi ꞌee Parasia kaꞌene iraꞌasinakije joni eha sisea namu. Ijihuni maijaho ja amuna pisivisaviꞌi puni aachia nesi ꞌeke ꞌee ea pisivisame siporua jojora ꞌojura. Ijihunaꞌe ja nihoꞌo niꞌimaꞌuraꞌe namahuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Sikuraipi ꞌee Parasia kaꞌene iraꞌasinakija joni eha sisea namu. Ijihuni maijaho ja soha ꞌaha ꞌee mweꞌa ꞌaha vaꞌajimareꞌe are ea kwisu apeje taꞌarohe jaaꞌina renama ronareꞌe vaꞌura. ꞌEnakaivo vea kaꞌene hu roe jaaꞌina renujaho ja hu vejuꞌe hura eha kaꞌene veni vaꞌe apehunijaho joni ehijaho asimareje kehi apehuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Joni eha sisea namu. Nia supaviꞌina kaꞌene ea ꞌahoꞌa aherame vaꞌukera. Ja ea irara Temiporu ꞌurahiꞌi ichutoa pikivajaho unenuꞌu pina pana. ꞌEnakaivo ja ea irara Temiporu huni korutia ꞌurahiꞌi ichutoa pikiꞌamajaho hu raka kaꞌene ꞌwaramajaho ꞌararihaꞌe vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nanamie nia supaviꞌinakije irakijarahara nihoꞌo niꞌimaꞌure? Korutijarana ho Temiporu kaꞌene rejume korutia kaji akuamahuna renane? ");
INSERT INTO mcq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ꞌEne ea irara swasa vejuri ꞌaijua ꞌurahiꞌi ichutoa pikivajaho unenuꞌu pina pana. ꞌEnakaivo ea irara ꞌaijua ꞌahi swasa kaꞌene namuji ꞌurahiꞌi ichutoa pikiꞌamajaho hu iraka kaꞌene ꞌwaramajaho ꞌararihaꞌe vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nanamie nia supaviꞌinakije irakijarahara nihoꞌo niꞌimaꞌure? Swasijarana ho ꞌaijua kaꞌene vejume swasa kaji akuamahuna renajarane? ");
INSERT INTO mcq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ijihunaꞌe ea irara swasa vejuri ꞌaijua ꞌurahiꞌi ichutoa pikimujaho hu swasa vejuri ꞌaijua ꞌee uneunecha kaꞌene ijihuni ꞌahi navuji ꞌurihiꞌi ichutoa pikima avanu. ");
INSERT INTO mcq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ꞌEne ea irara Temiporu ꞌurahiꞌi ichutoa pikimujaho hu Temiporu ꞌee Godi kaꞌene vaji hinujihuni ihi ꞌurahiꞌi ichutoa pikima avanu. ");
INSERT INTO mcq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ꞌEne ea irara akúpi ꞌurahiꞌi ichutoa pikimujaho hu Godira hinuni tinia ꞌee Godi kaꞌene ijihuni toi hinujihuni ihi ꞌurahiꞌi ichutoa pikima avanu. ");
INSERT INTO mcq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Sikuraipi ꞌee Parasia kaꞌene iraꞌasinakije joni eha sisea niꞌimaꞌura namu. Ijihuni maijaho ja joni taisi kaꞌene Godi vajahajaho senisia suraka paareha ꞌee imaria vajahura kaivo ja varapa mamaꞌina kaꞌene arira vwihane numisarame ꞌee nimai rojuji ja pavejura. Ja ikihi mahoꞌo vehune saꞌina vo ja pavejura. ");
INSERT INTO mcq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ja nia supaviꞌina kaꞌene ea ꞌahoꞌa aherame vaꞌukije ja kuta maꞌuꞌumaijaho kima sirira atoꞌaruvu vo maha kaꞌene natohwijaho iꞌúsavura. ");
INSERT INTO mcq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Sikuraipia ꞌee Parasia kaꞌene iraꞌasinakije joni eha sisea namu. Ijihuni maijaho ja joni kapusia ꞌee tevua huraru sovura kaivo vajijaho nesa ani rene sisea itunavujara itusaha navu. ");
INSERT INTO mcq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parasia nia supaviꞌinakije marakoꞌa kapusia ꞌee tevua vajiji sovakame hura ꞌuꞌo maraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Sikuraipia ꞌee Parasia kaꞌene iraꞌasinakije joni eha niꞌimaꞌura namu. Ijihuni maijaho ja nihoꞌo areri eucha saꞌinaꞌomo hura kahaꞌajaho ꞌeke sinara ꞌone amairia nirisame meruma amairia nihoꞌo mavarasaꞌimaa rena navu kaivo kame vaja kamaho ea ꞌata nihoꞌo chire ꞌwame ꞌee sakaha nihoꞌo amajaraꞌejuꞌe navujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ꞌEnajihunaꞌe ja ꞌuꞌo areri ijaꞌina. Ea ꞌahopuni unaꞌijaho ja ea arira kaivo joni vajijaho iraꞌata mamaꞌina ꞌee sisea ani rena navu. ");
INSERT INTO mcq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sikuraipia ꞌee Parasia kaꞌene iraꞌasinakije joni eha sisea namu. Ijihuni maijaho ja poropeti kwamasaha jihipuni arijijahija vene amairie mavarasaꞌina venu vaꞌuꞌe irechavuꞌe navu. ");
INSERT INTO mcq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ꞌEne ja ijá ꞌwavure Nú vea kaꞌene emahunupo hijari veijino hiꞌipisa nú poropetia paꞌaniaꞌa ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ꞌEnakaivo poropetia kaji ꞌania jijahija sahu jopo avajara ꞌwivu hejujihunaꞌe ja areri joni sahipu vareꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ꞌEne pura sisea kaꞌene vejajihuni pwinijaho jara veje ituꞌoꞌumama. ");
INSERT INTO mcq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ꞌEne ja nihoꞌo tapare ꞌee tapara kajihipuni ꞌuꞌuhija. ꞌÚ ja veni vahuni ꞌunamijaho icháꞌina asima vaꞌeja? ");
INSERT INTO mcq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ꞌEnaꞌomo na nimaa nimaa ja ꞌwaravu. Nara poropetia ꞌee ea kaꞌene vwiha arira vwihajiꞌina ꞌee Sikuraipia irechamiuꞌe joni roajivu. ꞌEnakaivo ja ea ꞌahoꞌa ꞌanie kwamasahune ꞌee ea ꞌahoꞌa nerui icha ꞌahi ꞌanie kwamasahuna. ꞌEe ea ꞌahoꞌa joni Sinakoku ajivajijahija ja hijihae ꞌee ara ara kaji sarame ruarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Joni ehijijipo ea arira kaꞌene iki mweꞌi hijajihi ꞌania jihipuni ꞌaa joni ꞌahi ariha jihunaꞌe ja eha apehuna. Eporu kaꞌene ea aririjihuni ꞌaa arihaji rena roe Sakaraia kaꞌene Perakaia oni harihijihuni ꞌaa kaꞌene Temiporu ꞌee swasa vejuri ꞌaijua riramoꞌoa kaji ꞌanaaji ro ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na nimaa nimaa ja ꞌwaravo. Uneunechakija roe ea kaꞌene iviamaija hiju jihipuni haha ꞌahi rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusaremi ore Jerusaremi ore jara Poropetia kaꞌene Na irechamiume joni vuꞌajijahija ꞌaniume kwamasahare ꞌee ea ꞌahoꞌaka maijijahija muni ꞌaniume kwamasahara. Naꞌiaka mapokakikano Na ura ja nianaa roe rira kwinu irechamiꞌirono areri ꞌuꞌorapo ꞌuꞌuhwahaꞌe nianaa roe puni sarapariji irechame ahuma hijujaꞌinaꞌe veꞌiro vejujaho ja nihoꞌo ura parenaura. ");
INSERT INTO mcq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Heha! Joni seijaho jonaꞌe ranavuꞌe iraꞌarama namu. ");
INSERT INTO mcq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na ja ꞌwaravu. Ja iviasi rene ikikahia pakimu vaꞌo ijiꞌa ijá ꞌwahune ea kaꞌene Natohwi jihuni iha ꞌahi roujaho merajahu ꞌwahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuho Temiporui vaji rene ro ꞌeꞌune vaꞌeme Huni tisaiporuepo roajime Temiporua kaji kama ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ꞌEnakaivo Jesu pu eha vene ijá ꞌiama Ike uneunecha mapoka kija nikivo? Na nimaa nimaaꞌe ja ꞌwaravu. Ike araka kehuni toi ja kivu kijahija niꞌaha kwino tiraꞌusahe arira naꞌeja vo muna pina nihoꞌo pihuna toa pamakave nahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ꞌEꞌikaivo pu vaꞌe Arivi huriꞌi hiꞌeme Huni tisaiporu pupusu roe Hu ijá ꞌwava Vea vecha ijá kajaho reꞌena? Mweꞌakara paꞌareꞌiro veꞌamani urijaho marakoꞌa iraki rejakame nú kamareje A iviꞌa roꞌiro venu ꞌwaꞌeje A roꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ꞌEjume Jesura pu eha vene ijá ꞌiama Ja hami kivakame ea ꞌahoꞌa ja papisimisaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ea ani aniꞌina mapoka Nuni iha ꞌahi roajimareje ja pisimia Na Kerisonakúne Nuni roha ꞌiꞌi kaivo ja aherama ꞌunama ani vahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ꞌEnakúne ja heꞌeje kwaa araka mapokakija ajira vene ꞌee ijí ajira vehuni pinana kajaho ꞌurina rohuna. Ijaꞌinijaho reꞌeja vo ijaho maiꞌo ura paruꞌeꞌunukúne patea junaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ijihuni maijaho kwaa ara mamaꞌini jipuhipo vu ara mamaꞌina ꞌahoꞌijihi puꞌúmo ajira veje ara ꞌahosupo vu ara ꞌahosu puꞌúmo ajira vehuna. ꞌEne ora vea rene ꞌee mwe varivura rohuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ꞌEnaꞌomo ikipuhipo aneja reꞌavajaho areri napapo hariha naheꞌiro haha hejujaꞌinaꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ꞌEnajihunaꞌe ea ꞌahopo ja ꞌeka siseꞌi ꞌahie ꞌee ꞌanie kwamasahuna. Ijihunaꞌe kwaa araka mapoka kijahija Nuni ihijihuni hahi ja nihoꞌo senama paranihuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ꞌEnareje eaka mapoka kaꞌene Nuni ꞌunama ꞌurahojujijahija ijaho areꞌi kaivo taꞌarohe ani vahuna. ꞌEne ea ꞌahoꞌa ea ꞌaho puꞌúmo sena vetiarahune ꞌee siseꞌi vetiarahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ꞌEne poropetia iraꞌasipo mapoka roajimareje ijipuhipo najahakamaꞌe ea mapoka pisimisame ꞌunama ani vahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ꞌEne sisea nihoꞌo niꞌimaꞌura rena paraꞌama jihunaꞌe erapo oja ꞌekaravujaho roe paꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ꞌEnakaivo ea kaꞌene Nuni ꞌunami jihunijikano kirasaha hiꞌavajipo pu nihoꞌo maranihuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ꞌEꞌeje ijí Godoni arijihuni vuꞌa maa maiuꞌiniji kwaka mapoka kakino najahapene ohuna. ꞌEjakame kwaaka mapokakino ea kaꞌene hijujijahija ijaho hina kaꞌejaꞌe ijiꞌa mweꞌakara paꞌarehuni urijaho rohuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ꞌEa irara ike taꞌamajaho hami heꞌamana. Poropeti Tanerura ꞌwarama jaꞌinaꞌe vei pini nihoꞌo sisemai pakaviꞌinijara akuavuri tiniji namija kaꞌavajaho ");
INSERT INTO mcq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ea kaꞌene Jutia hijujijahija niꞌaha kwinu juhahareje huriꞌi va ranaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ꞌEje ea kaꞌene ꞌahutoi hiꞌavajija paariha vaꞌe puni sea vaja kukua ꞌekaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ꞌEje vu ea kaꞌene juasiꞌi ꞌurahoꞌamajaho paꞌunama roe huni ateha ꞌekaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ꞌEnakaivo vea kajara nituꞌamani veijaho naparaka hariꞌinijija ꞌee hariha musa ijiꞌinijijahija nihoꞌo sisesei hihuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Vea kaꞌene ijaꞌinijija siporua ꞌojakame jara juhahunijaho sapatia ꞌee neha rija pareꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ijihuni vea kajino sisemai kaꞌene rehunijaho nitama mweꞌa akúpa vejume hinapena roajino sisea ijaꞌina parenajara rehuna. ꞌEnareje ijiꞌa túnaꞌa vu ijaꞌina parehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Natohwijara vea kaji patuꞌua veꞌamajaho ea pina areri maiꞌo pahihuna. Ea kaꞌene Hura iji pijihajihi puni hahi Hu veje vea kajaho tuꞌua rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ei pini ja ijá ꞌiꞌamajaho Keka! Keriso ikena karena ꞌiꞌamajaho ja nihoꞌo panimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Túnaꞌi ea ꞌahopo iraꞌatijino na Kerisona ꞌiave vu ea ꞌahopo iraꞌatijino na poropeti ꞌiahuna. Pu ijaꞌina venareje uneunecha mapoka veje ea mapoka oja hianava kiviꞌi pisivie ea mapoka nimaa rohuna. Pu ea kaꞌene Hura iji pijihajihija pisivihuna vo areri parehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hami heha! Maiꞌo raka kaꞌene rehunijaho Na niꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ꞌEnajihunaꞌe ea ꞌahopo ika ꞌiava heꞌavajaho Hu karohu nechiꞌina ꞌiava heꞌavajaho nihoꞌo pava kaꞌavara. ꞌEne kare sea vajina ꞌiava heꞌavajaho nihoꞌo panimai roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ꞌEnakaivo vea kaꞌene Ema Puni Harihijara roꞌamani veijaho aresi vei ajimujaꞌi piꞌime vaꞌe vea ꞌonujaꞌi ꞌeꞌunujaꞌinaꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Unenuꞌu pini kwama naꞌamajaho púrúha ijá emoꞌeja. ");
INSERT INTO mcq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sisemai reꞌavari túnaꞌi niꞌaha kwinu vea naꞌive masapa pahanahuna. China jaheꞌusahe ariha akúpa puni harurijihija ꞌunirama usihuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ꞌEꞌeje ijá reꞌeje ijihuna vaja kajino Ema Puni Harihijihuni aacha kaꞌeje ijí ꞌimitia vaja kajino harura niꞌimaꞌura hanajiꞌinijiꞌi roakame eaka mapoka kaꞌene mweꞌakaki hijujijahija pu kamareje nihoꞌo niramaruma parahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ꞌEꞌeje Hura Huni ona ojiꞌina irechamiakame ijipuhipo tauja hwasihakame Huni ehijaka mapoka kaꞌene kwaka mapokakino hijujijahija niꞌaha kwinu nianae aherame roe rira kwinu rohuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ꞌEnajihunaꞌe Na iviamajai tavoꞌa puniji apúsamareꞌe haa ꞌwaraꞌejukúne hami heꞌavara. Ijí tavoꞌa kajara ꞌanaareꞌe vukúꞌo nahenareꞌe sisira apúsamujaho ja nihena kivujaho vei mai maraꞌi venu ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ꞌEnaꞌomo ja uneunecha kajipo aneja vene reje kiꞌavajaho Hu iviamaa ijí vwicha jiami namine roi venu roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na nimaa nimaaꞌe ja ꞌwaravu. Ea kaꞌene iviamajai maiꞌo hijukijahija pakwamasaꞌeje ikaho rehunaꞌe ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ike akúpa mweꞌa ijaho niꞌaha kwinu paꞌarehuna vo ike Nuni irijija nihoꞌo papaꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ijarahara rehuni veijaho eaka mapoka kijahija pahena pakavuꞌe ona ojiꞌina kaꞌene akúpi ꞌahi hijujijahija ꞌuꞌo pahena pakavuꞌe Harihiji ꞌuꞌo pahena pakamu kaivo Omijara Huhusu hena kamu. ");
INSERT INTO mcq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Vea kaꞌene Ema Puni Harihijara roꞌi veꞌamani veijaho areri Noara hinani veijaꞌinaꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Vea kaꞌene toa kajarahara paituꞌoꞌunani veijaho pu hine ahaja inareja javamareja toa sisea inareja napara pina ꞌwaha raname pina ꞌwaha raname pina ꞌwaha raname apene vaꞌo vaꞌume vaꞌe vea kaꞌene Noara sisima vaji ajimaji ꞌeꞌujara. ");
INSERT INTO mcq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pu pahena pakaꞌeme toi ituꞌoꞌune imwasamia jaꞌinaꞌe Emaa Puni Harihijara roꞌamajaho ijaꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Vea kaꞌene Hura roꞌamani veijaho ea noꞌoheꞌi puni juasiꞌi hine kaukara veꞌira ꞌomo ea pina apeꞌi kaivo pinijaho makahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ꞌEje napara noꞌoheꞌi sei vaji pu hine kaukara puna veꞌiraꞌomo ea pina apeꞌi vo pinijaho makahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ijihuni hahi vea kaꞌene joni Natohwijara rohunijaho ja pakame pahejiꞌinakúne amairiarame areri rena parajiꞌi hiha. ");
INSERT INTO mcq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ꞌEnakaivo ja niheju. Sea anesurijara heꞌeje nesa apejiꞌinijara vea irakiji roe nesa apeꞌi roꞌipisa hu ꞌajohe tanurahakame hu paroe huni sea ruarahe nesa apejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ijihuni hahi amairiarame nirisame areri rena paraꞌeje ꞌajaha hiꞌavara. Vea muka kaꞌene ja paꞌana rone matauvajino Ema Puni Harihijaho rohuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ꞌÚ pwea irara paseviꞌine ꞌee vwiha hami vwihajiꞌine huni natohwijara huni sea ꞌajohe ꞌee ꞌiruma vea ꞌahi areri vajihunaꞌe ranamane? ");
INSERT INTO mcq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Vea kaꞌene huni natohwijara roiꞌi kave huni pwea kaukara vejiꞌi hiꞌamajaho hu merajahuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na nimaa nimaaꞌe a ꞌwaravu. Hu huni kukua mapoka kajija mahoꞌo huni ija tahi ranave hura ꞌajohuna. ");
INSERT INTO mcq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ꞌEnakaivo ea kaꞌene pwea siseijaho hu oja vaji ika ronu Nuni natohwijaho paroꞌejuꞌe ꞌaha jora renu roꞌikaꞌi ");
INSERT INTO mcq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aneja vene hu huni napuhija hijihaꞌe hu ꞌiruma maina hine ꞌee toa sisea ijiꞌinijihi puꞌúmo toa inonana. ");
INSERT INTO mcq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ꞌEne vea kaꞌene pwea kajihuni natohwijara roꞌamani veijaho hu pakame paꞌajoꞌeje rohuna. Vea kaꞌene Hura rohunijaho pakame pahejiꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ꞌEnareje hura eha mahareje ranave ea kaꞌene iraꞌasinijipo tinia kaꞌene niramarume ꞌee upaja jaꞌiꞌujiꞌi hijuri tinijino vahuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Godoni arijaho areri ikaꞌina manura vehuna. ꞌAsúra ea iropu ropu puni naheha ꞌeke napasiniji piunaꞌirono vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ꞌAsúra iropu nihoꞌo vwiha paꞌane ꞌee iropu vwiha arira vwihajiꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ꞌAsúra kaꞌene vwiha paꞌajija puni naheha ꞌekara kaivo pu puni karesinia paꞌekara. ");
INSERT INTO mcq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ꞌEnakaivo ea kaꞌene vwiha aririjija pu puni naheha ꞌeke ꞌee puni karesinia ꞌeka vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ꞌEjume napasinejiꞌina kajaho paroume pu ajaha hinuvaꞌo ninanavume ariha notuara. ");
INSERT INTO mcq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ꞌEꞌeme naꞌia riramoꞌoi emaavajara. Heha! Ea kaꞌene napasinijaho ikehunakúne usema roe hu kame ꞌajoho ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ꞌEjume ꞌasúra mapoka kajija ꞌurimarame puni naheha amairiara. ");
INSERT INTO mcq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ꞌEjume ꞌasúra kaꞌene vwiha paꞌajipo ꞌurina ꞌasúra kaꞌene vwiha rukinijija ijá ꞌiava Areꞌi kaivo joni karesinia ꞌahoꞌa ꞌusé vajúha. Ijihuni maijaho núni naheha utaꞌirono vejukúna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ꞌEnakaivo ꞌasúra kaꞌene vwiha mamaijipo ijá ꞌiava Pana. Ijihuni maijaho núra ja userimihuna areri panakúne vaꞌe sitovai ojono jona ꞌimeha ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ꞌEnakaivo pu ꞌimeꞌirono vaꞌeme napasina kajaho roana. ꞌEjume ꞌasúra kaꞌene amairiarame ꞌajoha hijajija pu puꞌúmo ijí napasinejuri niꞌúhi vaji sora kaꞌene vejajino vaꞌeme vwicha kuvara. ");
INSERT INTO mcq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Josu pareꞌeme ꞌasúra ꞌahoꞌijija ꞌuꞌo ꞌunama roara. Natohwe! natohwe! Vwicha tirasamúha! ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ꞌEnakaivo hu eha vene ijá ꞌiama Na nimaa nimaae ja ꞌwaravu. Na nihoꞌo ja pakivura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hami ꞌajohe nia niriꞌi hiha! Ijihuni maijaho ja maiꞌo vea vechana ho vea muka irakijaho pahena pakaviꞌinakúne ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ꞌEne kúꞌo areri ei pini kwa ari pini vaꞌi ꞌahaume pwehwaha ꞌumenaume roumakiviꞌi huni kukua pura ꞌajoꞌavarono vajihajaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hu ea pina monia K5,000 vajahe ꞌee ea pina monia K2,000 vajahe ꞌee ea pina monia K1,000 vajahana. Ea kwinu kwino pura kaukara kaꞌene areri vehuni jaꞌinaꞌe vajihana. ");
INSERT INTO mcq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ꞌEjume ea kaꞌene monia K5,000 ꞌekajaho niꞌaha kwino ꞌekavaꞌe kaukara vene monia kúꞌo K5,000 huri venana. ");
INSERT INTO mcq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ꞌEjume ꞌunama nikwinuꞌina kajino ea kaꞌene monia K2,000 ꞌekajaho monia kúꞌo huri K2,000 venana. ");
INSERT INTO mcq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ꞌEnakaivo ea kaꞌene monia K1,000 ꞌekajaho hu ꞌekavaꞌe mweꞌa ꞌume iji vaji huni natohwi jihuni monijaho rijume navara. ");
INSERT INTO mcq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ꞌAha joraꞌe paꞌareꞌeme ijí pwea kajihi puni natohwijaho monia kajihi puni ꞌunamiji roe pu puꞌúmo piuhiha amairiana. ");
INSERT INTO mcq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ꞌEjume ea kaꞌene monia K5,000 ꞌekajara roe monia kúꞌo K5,000 kaꞌene hura venajaho ꞌeka roe ijá ꞌwama Natohwe a monia K5,000 vajihana kaivo na huri monia kúꞌo K5,000 vejuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ꞌEjumakame huni natohwijara ijá ꞌwama Mamaaꞌe venana. A nuni pwea mamaa kaꞌene vene ihajinanaviꞌinakera a nuni kukua maꞌuꞌuakaho areri venajihunaꞌe na ranamae nuni kukua mamaꞌina ꞌajohihe ijihuni húmata reꞌena. ꞌEnakúne oni natohwi jihuni temara vaji ro aruma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ꞌEꞌejume vukúꞌo ea kaꞌene monia K2,000 vajahajara roe ijá ꞌwama Natohwe kima. A na monia K2,000 vajihana kaivo na kúꞌo K2,000 huri vejuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ꞌEjume huni natohwa kajara ijá ꞌwama Mamaaꞌe venana. A nuni pwea mamaa kaꞌene vene ihajinanaviꞌinakera. A nuni kukua maꞌuꞌumaakaho areri venajihunaꞌe na ranamae nuni kukua mamaꞌina ꞌajohihe ijihuni húmata reꞌena. ꞌEnakúne oni natohwi jihuni temara vaji ro aruma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ꞌEꞌejume ea kaꞌene monia K1,000 vajahajara roe ijá ꞌwama Natohwe na nihene kavujaho a ea kisinaꞌomo soa kaꞌene a pasamajaho a juara samuna ꞌee a oni ija paꞌonajaho a menuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ꞌEnajihunaꞌe na tea junivume monia K1,000 kaꞌene a vajihajaho na apena vaꞌe mweꞌa ꞌume apúrinanavutaꞌomo ike onakúne apena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ꞌEjume huni natohwijara eha vene ijá ꞌwama Ike nihoꞌo pwea kaꞌene uchaviꞌina kaꞌene ea siseakera a nikime henujaꞌinaꞌe na juara kaꞌene ea ꞌahopo savujaho nara ahaja ꞌuvure ꞌee ea ꞌahopo juara kaꞌene ꞌojujaho nara mejura. ");
INSERT INTO mcq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A monia kajaho ꞌeka vaꞌe panikai irechave namareje monia ꞌahoꞌa huri vejaꞌa. ꞌEꞌiraꞌomo na roareje mahoꞌo ijá ꞌekuꞌu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ijihuni hahi ijí monia K1,000 kajaho apene ea kaꞌene monia K10,000 venaji vajahana. ");
INSERT INTO mcq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ꞌEnajihunaꞌe ea irahipo kukua rukinijaho mapoka huri vajihuna. ꞌEnakaivo ea irara kukua paꞌanaꞌe reꞌamajaho huni kukua icharu navujaho ꞌetujahuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ꞌEjakame ijí pwea sisea kajaho piꞌonave vaꞌe ruha kaꞌene nutuviꞌiniji vaꞌe nirame ꞌee upaja jaꞌiujiꞌi hihuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ꞌEnakaivo vea kaꞌene Emaa Puni Harihijara Huni harurijiꞌi ꞌee ona ojiꞌina ariramaa mahoꞌo ijihi puꞌúmo roꞌamajaho Hu roe Huni ruha hanajiꞌina ꞌahi asuma hihuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ꞌEꞌeje eaka mapoka ijijahija niꞌaha kwinu nianaa roe Huni unaꞌa kaji roakiviꞌi Hura ꞌeka ꞌahaume ea ꞌahoꞌa ani irechame ea ꞌahoꞌa ani irechahuna areri ea kaꞌene sipi ꞌajohiꞌini jipuhipo sipia ꞌeke ani irechame ꞌee kotia ijija ꞌeke ani irechavu jaꞌinaꞌe vehuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ꞌEjakamareje ijí sipi ijijahija Huni ija manaꞌinijaꞌi irechamie ꞌee kotia ijijahija Huni ija anaꞌinijaꞌi irechamihuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ꞌEꞌeje Kinijara ijí ea kaꞌene Huni manaꞌinijaꞌi hiꞌavajijahija ijá ꞌwarahuna Roajiha Núni Omijara ja merajiharena nitama ike mweꞌakaho maiꞌo parejiꞌini joni kwaa kaꞌene amairihaji apeha. ");
INSERT INTO mcq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ijihuni maijaho Na matuniꞌeme jara Na ꞌiruma vajihara. ꞌEne Na toa huaniꞌeme jara Na toa ꞌe vajihara. ꞌEne Na joni ea sujaꞌe vo jara Na apeniara. ");
INSERT INTO mcq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ꞌEne Na ateha paꞌareniajaho jara ateha samihara. ꞌEne Na atama navujaho jara ro kivara. ꞌEne Na tipurai hijuti veijaho ja roe Na kivara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ꞌEjakamareje ea maijipuhipo Hu ijá ꞌwarahuna Natohwe A vecha matunavume nú A ꞌiruma vajahare? ꞌEne A vecha toa huanavume nú A toa ꞌe mahare? ");
INSERT INTO mcq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ꞌEnareja A vecha núni ea suja rejumakame nú A ꞌajoahare? ꞌEne A vecha ateha paranaume nú A ateha vajahare? ");
INSERT INTO mcq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ꞌEne A vecha tipura hijume nú vuꞌe A kavare? ꞌEne A vecha atama ꞌunaravume nú vuꞌe A kavare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ꞌEjakame Kinijara pu eha vene ijá ꞌihune Na nimaa nimaa ja ꞌwaravo. Ikejahija ja Núni ehijijihi vajihara vo ja nimaa pu pavajihara kaivo Na vajihara ꞌiahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ꞌEjakame vu Hu taꞌarohe Huni ija anaꞌinijaꞌiji rone ijá ꞌiahuna Núni nina kakaho areꞌi kaivo ani vaꞌajiha. ꞌEnareje vaꞌe vena kaꞌene ꞌavena siseijaho ꞌee huni ona ojiꞌinijihi punaꞌe vena ranavuꞌukame namujino vaꞌajiha. ");
INSERT INTO mcq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ijihuni maijaho vea kaꞌene Na matunimani veijaho ja ꞌiruma na pavajihare ꞌee Na toa huanimani veijaho ja Na toa pae mihara. ");
INSERT INTO mcq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ꞌEne Na ateha paꞌareniajaho ja Na ateha pamihara. Na sujaꞌe rejujaho ja Na paaherivara. Na atama ꞌunirimani veijaho ja paroe na kivara. Na tipura hijuti veijaho ja paro Na kivara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ꞌEjakame pu Hu ijá ꞌwarahuna Natohwe A vea vecha toa huaname ꞌee matuname ꞌee suja renane ꞌee ateha paꞌarenane ꞌee atama ꞌunaramane ꞌee tipura hijumakame nú A paniꞌajahare? ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ꞌEjumakame Hura pu ijá ꞌiahuna Na nimaa nimaaꞌe ja ꞌwaravo. Jara Nuni ehija kaꞌene paniꞌajihajija ja Naꞌe paniꞌajihe avajara ꞌiahuna. ");
INSERT INTO mcq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ꞌEjakame pu vaꞌajime vaꞌa vena kaꞌene majama rejiꞌi namujino vahuna. ꞌEnakaivo vu ea kaꞌene ariramaa ijijahija vaꞌe majama hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ꞌEjumakame Jesura Huni tisaiporua vuꞌa kaꞌene ꞌwaramajaho paꞌarejumakaviꞌi Hu ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ja nihena kavu. Naꞌia noꞌoheꞌi paꞌareꞌeje Pasova vea reꞌamajino Ema Puni Harihijaho pu apenareje icha ꞌahi nerui ꞌanahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ꞌEꞌeme pirisitia mamaꞌina ꞌee ema puni mamaꞌinijija vaꞌe pirisitia natohwa kaꞌene Kaiapasina ꞌwavujara hinujino ahuma hijara. ");
INSERT INTO mcq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ꞌEnareja pu ahuma hine hemi vuꞌa ꞌwama pirahe Jesu icháꞌinaꞌe nesi apena ꞌanaa kwahuniji ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ꞌEnakaivo pu ijá ꞌwava Oo nú ike ahaja ijuri veakino ijá veꞌavajaho eaka mapokakipo ꞌaraꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ꞌEnakaivo Jesuho Peteni vaꞌe Saimani kaꞌene reporosia rukinijihuni sei hinana. ");
INSERT INTO mcq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ꞌEꞌeme napari pini huni roe kavapwa kaꞌene muni vejaraꞌomo ijihuni vaji senisia kaꞌene monia niꞌimaꞌura ꞌimehunijaho apena roe Jesuho ꞌiruma ijiꞌi hiꞌeme hu Huni húmata ꞌahi usetiana. ");
INSERT INTO mcq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ꞌEjumakame Huni tisaiporua ijí kamareja ajinaꞌeme ijá ꞌwava Irakijihunaꞌe ike senisiakaho manisamo? ");
INSERT INTO mcq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ike senisiakaho apena vaꞌe ea ꞌahopuni moni aneja niꞌimaꞌura ꞌimenareje ea kaꞌene uneunecha paꞌajihi vajihaꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ꞌEjumakame Jesura ijá ꞌiama Ja iraka vene naparakaho ꞌuraraho? Hu nihoꞌo unenuꞌu pina mamaa Nununaꞌi vene avanu. ");
INSERT INTO mcq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ꞌEnakaivo ja ea kaꞌene uneunecha paꞌajijahija naꞌiaka mapokakaho ja puꞌúmo hihuna kaivo Na ikaho ja puꞌúmo majama pahihuna. ");
INSERT INTO mcq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ike hura senisia kaꞌene Nuni haha ꞌahi usetiakaho Nuni haha kaꞌene kwananahuniji amairia avanana. ");
INSERT INTO mcq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ꞌEnakaivo Na nimaa nimaa ja ꞌwaravu Mweꞌi kwaaka mapokakino ike Godoni vuꞌake ichihi chihi najaꞌavajaho ike naparakara raka kaꞌene Nunaꞌe venukaho pu ꞌwaviꞌi hu vwihahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ꞌEꞌeme ijí pu ea iropu ropu noꞌoheꞌina vaja kajino ea pina huni iha Jutasi Isikariatina ꞌwavujara pirisitia mamaꞌinijihi puni vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ꞌEnarena ijá ꞌiama Nara Hu najahe nahama ja ꞌwaraꞌujaho ja raka na vajiꞌeja? ꞌiamana. ꞌEjume pu niꞌaha kwino monia siriva mapoka (30) tahe vajahara. ");
INSERT INTO mcq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ijihuni vea hu aneja venarena Huaꞌe nahamahuni ꞌunamijaho samana. ");
INSERT INTO mcq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ꞌEꞌeme puretia isitia paajihuni vea amurijino Huni tisaiporuepo roe Jesu ijá ꞌwava ꞌÚ A ura nú ichihichano Pasova veijino ihunijaho Onaꞌe amairiaꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ꞌEjume Hura pu ijá ꞌiama Ja ara natohwiji vaꞌajimareje ea pina piunaꞌavajaho ijá ꞌwaraꞌavara Núni Najahiꞌinijara ijá ꞌwarumane Vea niroe tuꞌu rejukame Pasova veakaho oni sei Nuni tisaiporu puꞌúmo vehuna ꞌúmana ꞌwaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ꞌEjume Huni tisaiporua kajija Jesura ꞌwarama kaja venareja pu Pasova amairiara. ");
INSERT INTO mcq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ꞌEnaꞌomo vea nusireꞌeme Hu Huni tisaiporua iropu ropu noꞌoheꞌijihi puꞌúmo ꞌaijua rori hijasama hijara. ");
INSERT INTO mcq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ꞌEne hine ꞌiruma ijiꞌi Hu ijá ꞌiama Na nimaa nimaa ja ꞌwaravu Joni vajakino ei pini Na nahamihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ꞌEjumakame mapokijija nihoꞌo temukama paraꞌeme ꞌurine ea kwinu kwinu Hu apome ijá ꞌwava ꞌWi! Natohwe Na pane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ꞌEjume Hu eha vene ijá ꞌiama Ea kaꞌene Na huꞌúmo huni ija tevui vaji apúsamukara Na nahamihuna. ");
INSERT INTO mcq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ijí Emaa Puni Hariha kajaho areri nitama Godoni Ira vaji Huaꞌe rone ꞌwarama jaꞌinaꞌe vahuna kaivo ea kaꞌene ijí Hu nahama ea ꞌahoꞌa ꞌwaramajaho vi eha nihoꞌo sisea apeꞌena. Maijaho ike ea kaꞌene Emaa Puni Hariha nahamahuna kajaho panaheꞌipisa mamaaꞌe vejaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ꞌEjumakame Jutasi kaꞌene Hu nahamahuna kajara eha vene ijá ꞌwama ꞌWi! Najuhiꞌine na pana ꞌwamana. ꞌEjume Jesu ijá ꞌwama Ara orono ꞌwaramana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ijí pu hine iꞌeme Jesura puretia kajaho apenarena Godoni siporua ꞌone teamani ꞌwaꞌikaꞌi ijiꞌa túchamaa Huni tisaiporua vajihiꞌi ijá ꞌiama Ikaho Nuni hahakúne ꞌeke iha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ꞌEnarena vukúꞌo kapusia kaꞌene toa rukinijaho apene Godoni siporua ꞌone teamani ꞌwaꞌikaꞌi pu vajihiꞌi ijá ꞌiama Ja mahoꞌo ikaho iha! ");
INSERT INTO mcq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ijihuni maijaho ikaho Nuni ꞌaa kaꞌene eaka mapoki jihipuni siseijihunaꞌe ꞌarihakame puni sisea paꞌarehunaka nimaa vena ꞌwaramajina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ꞌEnakaivo ike heha! Na vukúꞌo ike ajaꞌina riha kakaho ja puꞌúmo paahume hina ihuna vo vaꞌe vea kaꞌene jara Nuni Omijihuni ari roꞌavajiꞌa vukúꞌo ja puꞌúmo maiuꞌinaꞌe ahuma ihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ꞌEꞌeme pu javaa vene paꞌarejume usema Arivi huriꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ꞌEjumakame Jesura pu ijá ꞌiama Ja iviasi naꞌiakino Nuni hahi ja juhahuna. Ijihuni maijaho nitama Godoni ira vaji ikaꞌina ꞌwarumana. Nara ea kaꞌene sipia ꞌajohiꞌina kajaho ꞌanaakame ijí sipia kajijahija juhaha jirijiri va ranaꞌeja ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ꞌEnakaivo Na kwamareje vukúꞌo ꞌuriꞌuti veijaho Na urane kami Karari vaꞌeju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ꞌEjumakame Pitara eha vene Hu ijá ꞌwama Eaka mapokakija pu Oni hahi kame niꞌaha kwinu varanahuna vo na nihoꞌo A papataaroraꞌeju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ꞌEꞌeme Jesura Pita ijá ꞌwama Na nimaa nimaa a ꞌwaravu. Iviasi naꞌiakikano ijiꞌa ꞌuꞌora ꞌumeꞌavarono a ꞌaha noꞌopisu Na hemiꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ꞌEjume Pitara ijá ꞌwama Na A Huꞌúmo kwahuna vo na pahemaꞌeju ꞌwamana. ꞌEjume Huni tisaiporu ꞌuꞌo mahoꞌo ijaꞌina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ꞌEne Jesuho Huni tisaiporu aherama roarena roe kwaa iha Ketasimani pu ijá ꞌiama Ja ikano hiꞌeje Na vaꞌe karohi siporua ꞌojuma ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ꞌEꞌeme Jesura Pita aheme ꞌee Sepati oni harihijaho noꞌoheꞌi aherame pu puꞌúmo vaꞌejume Hu nihoꞌo temumarena oja turaꞌi ꞌahaa paranana. ");
INSERT INTO mcq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ꞌEjume Hu pu ijá ꞌiama Nuni ojakaho nihoꞌo temukimareꞌe oja sui ꞌahiukúne ja ika maiꞌo hine ꞌaiha vejiꞌi hiha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ꞌEꞌeme Hu maꞌuakuꞌwi kahakaru vanamarenaꞌa ijiꞌa mweꞌi ꞌone siporua ꞌone ijá ꞌwama Amo ike kapusia ikaho makaꞌeje asitiha ruvaꞌama kaivo ikaho Nuni ura pana ꞌavo Oni urijara renama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ꞌEjume Hu kúꞌo ꞌunama Huni tisaiporu puni vaiꞌi kivume pu nejuma kimarena Hu Pita ijá ꞌwama ꞌEnaꞌomo ja vea muka kwinu Na huꞌúmo maiꞌo hine ꞌaiha paveꞌeja? ");
INSERT INTO mcq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ꞌEne ꞌaiha vejiꞌi siporua ꞌoha. ꞌEꞌirakúne ja siseijihuni harurijaho pavaꞌe aruꞌavara. Joni ꞌavenijaho ura rena paranu kaivo joni hahijaho nihoꞌo ajuarana paranu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ꞌEnarena Hu kúꞌo pu irechamiꞌi kaivo siporua ꞌoꞌi vaꞌarena siporua ꞌone ijá ꞌwama Amo ike kapusia ikaho makaꞌeje asitiha ruvaꞌama vo paꞌana reꞌamajaho Na ihuna. ꞌEnakúne Oni ura ijara renama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ꞌEjumakame Hu kúꞌo ꞌunama roiꞌi kimajaho pu nihoꞌo nia vahima parajume notuara. ");
INSERT INTO mcq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ꞌEjumakame Hu pu makiꞌi kaivo Hu ꞌaha noꞌopisuji siporua ꞌoꞌi ꞌunama vaꞌarena Hura kúꞌo nisúꞌu ꞌwarama kajaꞌinaꞌe vukúꞌo ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hu kúꞌo ꞌunama roarena Huni tisaiporua ijá ꞌiama ꞌÚ ja maiꞌo hina notue ꞌee ojuta hwejo? Iviamaa vea muka nituranu. Ema Puni Harihijaho emaapo nahamahareje ea sisea puni ija tahi ranahuna. ");
INSERT INTO mcq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ꞌEe ꞌurija nú vaꞌa. Ea kaꞌene Na nahamihunijaho nikaraꞌi rou. ");
INSERT INTO mcq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ꞌEjumakame Hu ijá ꞌwaraꞌejume Jutasi kaꞌene Huni tisaiporua pinijaho ea mapoka juha hajaa soꞌwa ꞌekiꞌinijija emaapuni ea mamaꞌina ꞌee pirisitia mamaꞌinapo irechamiume roajivara. ");
INSERT INTO mcq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ꞌEjume Jutasira nimarako ikaꞌina ꞌwaramana. Nara vaꞌareje ea kaꞌene Hu ꞌajoviꞌi ura mina veja kiꞌavaji apeꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ꞌEnaꞌomo hu ajiru Jesuni nini ꞌeꞌunarena Jesu ijá ꞌwama Ese Najuhuꞌine ꞌwaꞌi kaivo ura mina venana. ");
INSERT INTO mcq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ꞌEjumakaviꞌi Jesura ijá ꞌwama Ea nuna a iraka veꞌirono roaji vena ꞌwaꞌeme eaka mapoka kajipo usevajino Jesuho ijija ꞌunavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ꞌEꞌeme Jesuni tisaiporua pini ija jora rova kajikano soꞌwa apene ꞌanaumakame pirisitia natohwi jihuni pweijaho ꞌataa ꞌuhusahana. ");
INSERT INTO mcq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesu ijá ꞌwama Oni soꞌwa huni ruhi ranama. Ijihuni maijaho ea irahipo soꞌwa ꞌekujaho pu soꞌwa ꞌaha kajino kwamasahuna. ");
INSERT INTO mcq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A maiꞌo Na pakimunaꞌe kavu! Nara Nuni Omiji ꞌumeꞌipisa Hu Huni ona ojiꞌina iviamaa 72,000 asisame irechavakame Nuni roaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ijaꞌina veꞌipisa Godoni ira vaji nitama ꞌwaramajaho iviamaa ijaꞌina pareja vo ikaꞌina rehuna ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ꞌEjume ijihuni vea kajino Jesura eaka mapoka kaji ijá ꞌiama Na ea nesa apejiꞌinaꞌomo ja juha soꞌwa ꞌee hajaa vena Na apeniꞌiro roare? Na naꞌiaka mapoka kame Temiporu vaji hine ja najahura vo ja Na paapeniura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ijaꞌinaꞌe rejumakame nitama Godoni Ira vaji raka kaꞌene ꞌwaramajaho nimaa nimaaꞌe renuna ꞌiamana. ꞌEꞌejume Huni tisaiporua mapokijija Hu raname juhahe varanavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ꞌEꞌeme ijí ea kaꞌene Jesu apeja kajipuhipo Jesu apena vaꞌe pirisitia natohwa kaꞌene Kaiapasina ꞌwavujihuni sei vaꞌara. ꞌEꞌeme Sikuraipia ꞌee emakinijija ijino pu puꞌúmo ahuma hijara. ");
INSERT INTO mcq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ꞌEnakaivo Pita hu ijino Huni túnaꞌi makameri roi ꞌararihaa vaꞌe pirisitia natohwi jihuni apirunijino vaꞌana. ꞌEne aruma vaꞌe hirisima kaꞌene hijajija kimarena ijihipuni vaji hijiꞌi kiꞌeje pu ichá veje kiꞌi ꞌahaume roe ijí hinana. ");
INSERT INTO mcq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ꞌEjumakame ijí pirisitia mamaꞌina ꞌee kanisorua mahoꞌo kajipo vuꞌa iraꞌata ꞌekarene Jesu namahareje apena vaꞌe ꞌanaa kwaꞌamarono saravara. ");
INSERT INTO mcq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ꞌEnakaivo ijí iraꞌata mapoka nipiunivara vo ijí pura vuꞌa kaꞌene ꞌwamareje Jesu namahunijaho areri nihoꞌo parenana. ꞌEnakaivo ijihuni túnaꞌi ea noꞌoheꞌi usema roara. ");
INSERT INTO mcq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ꞌEꞌeme ijí ea kajipo ijá ꞌiava Ike Ea ikarahara ijá ꞌwarumana Godoni Temiporukaho Nara veje tirausahakame vukúꞌo veje naꞌia noꞌopisu vajijino niꞌaha kwinu ꞌurinareje namiꞌena ꞌúmana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ꞌEjumakame ijí pirisitia natohwijara ꞌurina namiꞌi kaivo ijá ꞌwama ꞌÚ A eha paꞌwaruꞌena? ꞌÚ ea ikija irakaꞌe hine A ronahe ikaho ꞌwaruvo? ꞌwame ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ꞌEnakaivo Jesuho nihoꞌo ira paꞌwaramana. ꞌEjumakame pirisitia natohwa kajara ijá ꞌwama Godi kaꞌene maiꞌo hijiꞌinijinakúne ꞌwaruma. A Keriso kaꞌene Godoni Harihiji reꞌamajaho ꞌwaruma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ꞌEjumakame Jesu ijá ꞌwama A niꞌwarimu kajina. Ema Puni Harihijaho kaꞌeje ija manaꞌini harurijaꞌi asuma hine ꞌee ꞌimitia vaji akúpa ꞌahi rena rohuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ꞌEjumakame ijí pirisitia natohwa kajara huni ateha kajija ꞌunirame puachaviꞌi ijá ꞌumena Ea kakaho hine Godi matahooo nú nihoꞌo ei pina Hu panamahu kaivo Hura Godi matahajaho ja nihejara. ");
INSERT INTO mcq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ꞌEnaꞌomo ja icháꞌinaꞌe vwihajo? ꞌEjume pu eha vene ijá ꞌwava Hu kwahuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ꞌEjumakame pu Hu cheri niuri ꞌotie ꞌee haisi ꞌanae ꞌee ea ꞌahopo nonu tahijahara. ");
INSERT INTO mcq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ꞌEjiꞌi pu Hu sivaa ijá ꞌwava A Kerisonakúne iviꞌa raka kaꞌene renuji ꞌwarume ꞌee ea irahipo A ꞌanaujaho ꞌwaruve heja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ijá veꞌeme Pitaho ijí ara rori hiꞌeme napara pwea pini roarena hu ijá ꞌwama A ꞌuꞌo Jesu kaꞌene Karari orijiꞌi ꞌurahonuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ꞌEnakaivo hu puni unaꞌa kajino hema ijá ꞌiama Ara raka kaꞌene rone ꞌwarimujaho na nihoꞌo puruva retiu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ꞌEꞌeme Pita hu ijiꞌa kami vwicha jiami vaꞌeme vu napara pwea pini kamarena ijí ea kaꞌene vwicha jiami namijaji ijá ꞌiama Ike ea kakaho Jesu kaꞌene Nasareti orijiꞌi ꞌurahonuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ꞌEjumakame Pitara kúꞌo hemarena ichutoa pikiviꞌi ijá ꞌiama Na nihoꞌo ea kajaho pahena pakavura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ijihuni túnaꞌa kajakaru ea kaꞌene ijí manamija kajipo roareja Pita ijá ꞌwava Nimaꞌe a ꞌuꞌo puni ea pina. Ijihuni maijaho ara ira kaꞌene ꞌwarumujara samaa renu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ꞌEjume hu aneja vene ira sisea ꞌwaraviꞌi ichutoa pikime ijá ꞌiama Ea ikaho na nihoꞌo pahena pakaviꞌina ꞌiꞌeme niꞌaha kwino ꞌuꞌora ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ꞌEꞌeme ijiꞌa Pita Jesura ira kaꞌene ꞌwaramajaho vwihanana. ꞌUꞌora maiꞌo ꞌumeꞌi veꞌeje a Na ꞌaha noꞌopisu hemiꞌena. ꞌEjume hu va ꞌeꞌune nirame nihoꞌo oja turaꞌi ꞌahaana. ");
INSERT INTO mcq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ijihuni súꞌuhijino pirisitia mamaꞌina ꞌee ꞌemapuni mamaꞌina mapokaꞌe ahuma Jesu icháꞌinaꞌe venareje ꞌanaa kwahuniji piraꞌarame hina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ꞌEnareja pu Hu kamomareja ahema vaꞌe kwaa ara kaji ꞌajohiꞌina kaꞌene Pairati mahara. ");
INSERT INTO mcq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ꞌEjumakame Jutasi kaꞌene nahamahajaho kiꞌeme pu Jesu sisea namahe ꞌee siseꞌi ꞌahaumakime hu nihoꞌo temuma parajume ijí monia siriva (30) kaꞌene hu ꞌekajaho vukúꞌo ꞌuname ꞌeka roe pirisitia mamaꞌina ꞌee emaapuni ea mamaꞌinijihi vajihana. ");
INSERT INTO mcq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ꞌEne ijá ꞌiama Na nihoꞌo Ea kajaho ꞌaa sisea paꞌamaaꞌe na Hu nahamahuta ꞌiamana. ꞌEjume pu hu ijá ꞌwava Ijaho núni rake? Aꞌasu ijaho kama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ꞌEjume hu monia kajaho ijí Temiporu vaja kajino atoꞌaruꞌi kaivo va ꞌeꞌuna vaꞌe jasi kwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ꞌEnakaivo pirisitia mamaꞌina kajipo monia kajaho nianaiꞌi ijá ꞌwava Varapijara ꞌwaramujaho ike moniakaho nú Temiporu moni ijiꞌi paahuma irechahuna. Ijihuni maijaho monia kakaho emaapuni ꞌaa ꞌimejara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ꞌEjume pu ꞌwama pirahe monia kajaho ꞌeke ea kaꞌene siꞌuara vejiꞌini jihuni mweꞌa ꞌimenareja apiopuni euchaꞌe vejara. ");
INSERT INTO mcq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ijihuni hahi mweꞌa sisa kajaho ꞌAa Mweꞌa ꞌwama roe iviasi usevu. ");
INSERT INTO mcq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ꞌEjumakame poropetia Jeramaiara ꞌwaramajaho nimaa renana. Hu ikaꞌina ꞌwaramana ꞌEne Isureri opo Huni haha ꞌimehuni aneja monia siriva 30 ranavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pu monia kajaho ꞌeke ea kaꞌene siꞌuara vejiꞌini jihuni mweꞌa ꞌimejara. Natohwijara najiꞌeme na ꞌwaravuta. Godira na ꞌwarimana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ꞌEꞌeme Jesuho ijí kwaa ara ꞌajohiꞌina kajihuni unaꞌi namijume hura apome ijá ꞌwama ꞌÚ A Jua puni kinie? ꞌwamana. ꞌEjume Jesura ijá ꞌwama A niꞌwarimu kajina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ꞌEnakaivo pirisitia mamaꞌina ꞌee ema puni mamaꞌinijihi puꞌúmo Huaꞌe namahajaho Hu ira paꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ꞌEjumakame Pairatira Hu ijá ꞌwama Uneunecha raka raka pu A namahujaho A nihino? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ꞌEnakaivo Hu nihoꞌo ira pina maꞌuakuꞌwi paꞌwaravumakame ijí kwaa ara ꞌajohiꞌina natohwa kajaho nihoꞌo puruva rena paranana. ");
INSERT INTO mcq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ꞌEne vea kaꞌene ahaja ijuri veijino ara kwaa ꞌajohiꞌina niꞌinijihuni tamanaꞌomo ea kaꞌene tipurai hijujaho ea mapoka kajipo ea ira ura renauji ranavuꞌe samai vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ꞌEnakaivo ea pina huni iha Parapasiho nihoꞌo sisemaa ea mapoka nihena kaviꞌina hu tipura hinana. ");
INSERT INTO mcq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ꞌEnaꞌomo vea kajino ea mapoka mapoka roe ahuvumakiviꞌi Pairatira pu ijá ꞌiama Na ea irá ranave va ꞌeꞌuꞌena? Parapasina ho Jesu kaꞌene Kerisone ꞌwavujine? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pu Jesu ꞌotua vetihuni jihuni maijaho Pairati nihena kamana. Ea mapoka Jesu ura renajihunaꞌe pu sena vena avajara. ");
INSERT INTO mcq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ꞌEꞌeme Pairatiho ruha kaꞌene ꞌotua venajino asuma hiꞌeme naparahi ona vene ijá ꞌwama Ea kaꞌene ariramaa kajihunaꞌi majihiꞌa unenuꞌu pina paveꞌamana. Ijihuni maijaho ivisi naꞌi kakino na navahi Huaꞌe kamarejo pivujuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ꞌEnakaivo pirisitia mamaꞌinijija ꞌee puni ea mamaꞌina ijipuhipo eaka mapoka kajijahija ꞌejahie ꞌwarave Parapasi ranaꞌikaꞌi Jesu ꞌanaa kwaꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ꞌEnarena ijiꞌa vukúꞌo kwaa kajihuni natohwijara eha vene ijá ꞌiama Ea iraka saꞌiniji na ranave vaꞌena? ꞌiamana. ꞌEjume pu ijá ꞌwava Parapasina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ꞌEjume Pairatira pu ijá ꞌiama ꞌEnaꞌomo Jesu kaꞌene Kerisona ꞌwavujaho na Hu ichá veꞌejo? ꞌiamana. ꞌEjume pura mahoꞌo hu ijá ꞌwava Icha ꞌahi ꞌanaa! ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ꞌEjume hu ijá ꞌiama Irakijihunaꞌe? Hu sisea iraka venane? ꞌiamana. ꞌEnakaivo pu nihoꞌo ijí ꞌumejajaho pasonananamie Icha ꞌahi ꞌanaa ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ꞌEjumakame Pairatira kimajaho pu puni vwiha ijaho aniꞌina pavwihajara vo nikwinuꞌwi vwihajiꞌi ꞌaraꞌiro vejuma kimarena hu toi ꞌene apene puni unaꞌi ija soviꞌi ijá ꞌiama Ea kakaho nihoꞌo sisea maꞌuakuꞌwi pavenanaꞌomo ja Hu ꞌanaꞌavajaho Huni ꞌaa ijaho nuni ahija panakúne ja ojono kaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ꞌEjume pu ea mahoꞌo eha vene ijá ꞌwava Nijinakúne makave Huni ꞌaa núni haha ꞌahi arihe ꞌee sesahu núpuni haha ꞌahi ariha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ꞌEꞌejume hu Parapasi ranavume vaꞌeme hura ꞌwaravume Jesu apene hijahe ꞌee apene ranavume icha ꞌahi ꞌanaꞌavarono vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ꞌEꞌejume ea kwaa ara ꞌajohiꞌina natohwa kajihuni sorutia kajipo Jesuho ahema kamati puni niꞌúhi vaꞌe aruꞌeme sorutia mahoꞌo Huaꞌe ꞌoutihara. ");
INSERT INTO mcq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ꞌEnareja pu Huni ateha kajijahija ꞌunirama jaheꞌi kaivo ateha amapuꞌura kaꞌene kwaa ara ꞌajohiꞌini jipuhipo savujikano apene apúsamahara. ");
INSERT INTO mcq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ꞌEe ꞌwija kaꞌene ehima piranavaji apenapi húmata ꞌahi apúsamahe ꞌee pijuha ija manaꞌinijaꞌi mahuma ꞌunama namijumakaviꞌi pu nitupari satie nuana vetiꞌi matahe taꞌarohe ijá ꞌwava Ese! Jua Puni Kinie ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ꞌEne ijá vejiꞌi pu Hu cheri ꞌotie ꞌee pijuha kajino apene ꞌuitejara. ");
INSERT INTO mcq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pu Hu matahume paꞌarejume ijiꞌa ateha kaꞌene jopatuꞌuraka apúsamaha kajaho ꞌunama apene tasiomaꞌi kaivo ijí Huni ateha kaꞌene Hu marakoꞌa samajaho samahe ijiꞌa icha ꞌahi ꞌanaꞌiro apene vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ꞌEjumakame pu vaiꞌi ꞌunamutoi ea pina Saimani Sairini orijaho piunamareja ꞌejahaume hura korosia kaꞌene Jesu ꞌanahuna kajaho tapana vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ꞌEjumakame pu Hu apena vaꞌe kwaa iha Korukata ꞌwavujino vaꞌara. Ijí Korukata ꞌwavujihuni maijaho Húmata ꞌAta ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ꞌEjumakame pu ijino ajina riha kisinaꞌe icha maritajiꞌi ahume amairiu vaꞌume Jesu mahume Hu maꞌuako ina henarena pataarorahana. ");
INSERT INTO mcq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ꞌEjumakame pu ijiꞌa ichi ꞌahi ꞌanaara. ꞌEne Huni ateha pipi vene ꞌekara ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ijá vejuma parajumakaviꞌi pu asuma hine ꞌaiha vejiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pu Hu namaha jihuni maijaho Huni húmata huri icha ꞌaha kajino asura venareja ikaꞌina ꞌwaravara. Ikaho Jesu kaꞌene Jua puni Kinijina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ꞌEnareja vea nikwinuꞌina kajino ea noꞌoheꞌi nesa apejiꞌina Jesuni manaꞌinajaꞌi ꞌanae ꞌee pina anaꞌinijaꞌiji ꞌanaara. ");
INSERT INTO mcq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ꞌEjumakame ea kaꞌene ijí rora kaji ro vaꞌajijahija Hu kame nuana achiachihiꞌi ira sisea kajino Hu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ꞌEjiꞌi ijá ꞌwava ꞌÚ A ike Jua puni vuꞌa ꞌwavuri sea kakaho veje tiraꞌusahakaviꞌi naꞌia noꞌopisu vajijikano veje kúꞌo ꞌurine namiꞌena ꞌiame ijá ꞌwarumana. ꞌEnakúne A Godoni Hariha reꞌamajaho iviꞌa orono niꞌajarame korosia ꞌaha kajino rene ariha roa kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ꞌEjumakame ꞌunama nikwisuꞌina kajino pirisitia mamaꞌina ꞌee Sikuraipia ꞌee emaapuni ea mamaꞌina ꞌuꞌo matahiꞌi ijá ꞌwava ");
INSERT INTO mcq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Hu areri ea ꞌahoꞌa niꞌajiꞌena vo Hu oriꞌini niꞌajarahuna nihoꞌo areria paꞌamaa. Hu nimai Isureri Puni Kini ijí reꞌamajaho makaꞌeje ijí korosi ꞌaha kaji ariha roakame nú ijiꞌa kamareja Hu nimaa roja. ");
INSERT INTO mcq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hu Godi nimaa ronunakúne areꞌeje Hu ura reꞌamajaho Hura niꞌajahe ijí rena ariha roa kava. Ijihuni maijaho Hu ijá ꞌúmune Na Godoni Hariha ꞌúmuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ꞌEjume ea nesa rukina kaꞌene Hu huꞌúmo ꞌania kajipo pu ꞌuꞌo ira sisea ani ani Hu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ꞌEꞌeme veꞌiriꞌa kajino mweꞌa kakaho niꞌaha kwino nutuma naꞌima namana. ꞌEꞌeme naꞌima nama apena vaꞌu vaꞌume vaꞌe vea tahunaname hareha ꞌaha karakaro naminuji ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Vea hareha ꞌaha karakaro ariha vaꞌe namiꞌeme Jesura ira ajira ijá ꞌumena Irai Irai rama sapakatani ꞌumenana. Ijaho Nuni Godi Nuni Godi A Rakijihunaꞌe Na Pataaroriho? ꞌwama avanana. ");
INSERT INTO mcq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ꞌEjumakame ea kaꞌene Huni rori namija kajipo ijí hinareja ijá ꞌwava Ooo ea kajaho Iraija ꞌumenu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ꞌEjumakame ea kwinuꞌwi ninuma vaꞌarena icha kaꞌene ꞌoasuna ijihuni toi amairiꞌinijaho apena roe ajina riha kisina vaji apúsame ꞌenapene Hura iꞌamarono apena mahana. ");
INSERT INTO mcq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ꞌEnakaivo ea ꞌahopo ijá ꞌwava Areꞌeje Iraijara roareje Hu niꞌajahe kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ꞌEjumakame Jesuho ira ajira ꞌumeꞌi kaivo ijiꞌa kwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ijá veꞌeme niꞌaha kwinu Temiporu vaji ateha kaꞌene rira muꞌoijano pu uranavujaho niꞌaha kwinu kahe huriji rene ro vaꞌe kame hariji ꞌonarene rira kaja puchaꞌusaharena ronu ronu ro vaꞌara. ꞌEꞌeme mwevarivuri roarena muna kakija niꞌaha kwinu mutuusahe ronu ronu vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ꞌEꞌeme euchi jaraꞌeme Godoni ea nimaa nimaa kaꞌene kwamasahajija ꞌurijara. ");
INSERT INTO mcq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Vea kaꞌene Hura kwama ꞌurinani veiji ea kaꞌene nitama kwamasahajija ijí pu puꞌúmo ꞌurinareja akuavuri ari ea mapoka puni unaꞌi vaꞌume kivara. ");
INSERT INTO mcq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ꞌEjumakame amia natohwa ꞌee ea ꞌahoꞌa kaꞌene pu puꞌúmo Jesu ꞌajoha namijajipo mwevarivura ꞌee uneunecha ꞌahoꞌa kaꞌene rejajija kimareja tea junavume ijá ꞌwava Nimaa! Ikaho Godoni Hariha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ꞌEꞌeme napara mapoka kaꞌene Karari Jesu niꞌajahura kaꞌene Hu ꞌararihaa roajija kamakaru hinareja kaviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ꞌEne napara ꞌahoꞌa kaꞌene ijihipuni vaji hijajijahija Meri Matarini ꞌee Meri kaꞌene Jemisiho ꞌee Josapiho puni ohijaho ꞌee Sepati oni harihiji jihipuni ohijaho ijá hijara. ");
INSERT INTO mcq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ꞌEa pina kukua rukimaꞌura Josapina hu ꞌuꞌo Jesuni tisaiporuaꞌomo Arimatia rene nusireꞌeme roana. ");
INSERT INTO mcq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ea ikara hu Pairati oni vaꞌe Jesuni haha apeꞌiro jarimana. ꞌEjume Pairatira hu mahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ꞌEjumakame Josapira vaꞌe ateha kaꞌene maiuꞌimaijino apene Jesuni haha kajaho mwamana. ");
INSERT INTO mcq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ꞌEnarena Hu apena vaꞌe Huni muna ara maiuꞌina kaꞌene amairiajikano haha kajaho ranaꞌikaꞌi hu muna niꞌimaꞌura tahuma apena vaꞌe ira kajikahi kunaꞌikaꞌi hu ijiꞌa vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ꞌEꞌeme napara kaꞌene Meri Matarini ꞌee vu Meri pinijaho ijano eucha ropunaꞌijaꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pura Pasova amairiaravari súꞌuhwijino pirisitia mamaꞌina ꞌee Parasia Pairati puꞌúmo vaꞌe rira kwinu ahuvara. ");
INSERT INTO mcq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ꞌEnareja pu Pairati ijá ꞌwava Natohwe nú iviꞌa vwihaju. Hu pakwaꞌikaꞌi maiꞌo hinani veijino pisivisaviꞌinakara ijá ꞌúmane Naꞌia noꞌopisu paꞌareꞌeje Na kúꞌo ꞌuriꞌeju ꞌúmana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ꞌEnajihunaꞌe ꞌwarave ea ꞌahoꞌa irechamiakame vaꞌajimareje ijí eucha kajaho hami ꞌajohe tanuma paraha. ꞌEꞌeje vaꞌe naꞌia noꞌopisu paramama. Vejuroꞌi Huni tisaiporuepo roe Hu nesi apena vaꞌi kaivo pu ea ijá ꞌwarahuna Hu kwamajaho niꞌurinana ꞌiavakame Hura iviamaa pisimisamakara marakoꞌa pisimúsumajaho asisama paraꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ꞌEjumakame Pairatira pu ijá ꞌiama Joni ea ꞌajohaꞌina ijí hiju. Ja icháꞌina vehunijaho nivwihaju. Vaꞌe tanume kuma pijuha paraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ꞌEjumakame pu vaꞌe eucha kajaho nihoꞌo tanume kuma kisimaꞌura vene ꞌee ea ijí ꞌajoha namihuna irechamie muna tanuvume paranana. ");
INSERT INTO mcq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ꞌEjume Sapati paꞌarejume Hurapoki súꞌu súꞌu vea nituꞌejuꞌe Meri Matariniꞌo vu Meri kaꞌene napara pina ijiꞌi pu noꞌo vaꞌe ijí eucha kaji kaꞌi ꞌahiume roara. ");
INSERT INTO mcq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ꞌEꞌeme mweꞌa varivura nihoꞌo niꞌimaꞌura roꞌeme Natohwi jihuni ona ojiꞌini kahi akúpa ꞌahi rena roarena muna kajaho tahumapene rori rovaꞌikaꞌi ijihuni toi asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ꞌEꞌeme ijí Huni hahijara hananajaho areri veapo piꞌivu kivujaꞌinaꞌe rene ꞌee huni atehijaho nihoꞌo sajasaꞌimai renana. ");
INSERT INTO mcq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ꞌEjumakame ea kaꞌene ijí ꞌajoha namijajija nihoꞌo simarame tea junama paraꞌeme areri kwamasahu jaꞌinaꞌe renaara. ");
INSERT INTO mcq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ꞌEjumakame ona ojiꞌina kajara eha vene napara kajija ijá ꞌiama Juvujaho areha. Na nihena kivu. Ja Jesu kaꞌene pura icha ꞌahi ꞌanaaji kaꞌi ꞌahiume roajivara. ");
INSERT INTO mcq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ꞌEnakaivo Hu nihoꞌo ikaho pahinu. Hu nimarakuꞌa ja ꞌwaravume hejajaꞌinaꞌe Hu niꞌurinana. ꞌEnakúne roe Hura tinia kaꞌene namajaho kaha. ");
INSERT INTO mcq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ꞌEnareje marako vaꞌajime Huni tisaiporua ijá ꞌiha Hu kwamajaho niꞌurinana. Heha! Hu urana Karari vaꞌunaꞌomo ja ijí Hu kahuna. Heha! Na ja ꞌwaravu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ꞌEjumakame pu euchi rene tea juname ꞌee teamanama paraꞌeme oharoharu ninukujaha vaꞌe Huni tisaiporua ꞌwaraꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ꞌEne heha! Jesuho ꞌeꞌuru piunime ꞌajoramana. ꞌEjume pu Huni mumora ꞌuname Hu oja mahara. ");
INSERT INTO mcq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ꞌEjume Jesu pu ijá ꞌiama Ja nihoꞌo pajuꞌi kaivo ninukujaha vaꞌe Nuni vwehija ꞌwaravakame pu kami Karari vuꞌe Na kiha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ꞌEjume pu maiꞌo vaꞌeme ꞌunamutoi vaiꞌi niꞌaha kwinu kivume ea kaꞌene eucha ꞌajoha namijajija roe ari pirisitia mamaꞌina iraka kaꞌene renajaho hoꞌo ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ꞌEjumakame pu roe emaapuni ea mamaꞌina ahuma hine vuꞌa ꞌwame monia niꞌimaꞌura sorutia kaꞌene ꞌajoha kaji vajihara. ");
INSERT INTO mcq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ꞌEne ja ikaꞌina ꞌwaraꞌavara. Huni tisaiporuepo naꞌii nú notui pakiꞌeme roe Hu nesi apena vaꞌara ꞌiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ꞌEnareje ijí vuꞌa kajara rena apena vaꞌe kwaa ara ꞌajohiꞌina natohwi jihuni atahuri aruꞌamajaho núra hu hami ꞌwarama amairiakame jonunaꞌa unenuꞌu pina pareꞌenakúnina ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ꞌEjumakame monia kajija ꞌeke pura ꞌwarava jaꞌinaꞌe vejara. ꞌEne ike vuꞌakaho raꞌusaha apenaji Jua puni vaja kajaho ꞌona apena rou vaꞌo iviamaa iki ꞌeꞌunu. ");
INSERT INTO mcq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ꞌEꞌejume ijí tisaiporu kajija ea iropu ropu kwinu ijá vaꞌe kami Karari huriꞌa kaꞌene Hura pu ijí vaꞌavarono ꞌwaramajino vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ꞌEjumakame pu ijí Hu kamareja pu Hu oja mahara. ꞌEnakaivo ꞌahoꞌa pu maꞌuaku panimai rojara. ");
INSERT INTO mcq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ꞌEjumakame Jesura puni roarena Hu pu ijá ꞌiama Harura kaꞌene mweꞌakaki namuna ꞌee kahi akúpi ꞌahi namuna ijaho niꞌaha kwinu Na mihana. ");
INSERT INTO mcq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ꞌEnakúne kwaka mapokakino vaꞌajimareje najahakame Nuni tisaiporu reꞌavara. ꞌEne Amo Hariha ꞌAvena ijihipuni ihi ꞌahi ꞌunirama toi samaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ꞌEne pu najahakame iraka kaꞌene Nara ja ꞌwaravujija pu ija kisi apena veꞌavara. Parunamiꞌavara. Na ja puꞌúmo naꞌia mapoka mapoka hina apena vaꞌu vaꞌu vaꞌe mweꞌa paꞌareꞌamani uriji ꞌeꞌuhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesu Keriso kaꞌene Godoni Harihijihuni vuꞌa maijihuni aneja. ");
INSERT INTO mcq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Poropetia Aisea nitama ikaꞌinaꞌe heha vaji venana. Heha! Na Nuni ꞌona ojiꞌina oni unaꞌi ranave hu oni ꞌunama amairihuna. ");
INSERT INTO mcq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hu nechiꞌi namine ajira ꞌumeꞌena Ja Natohwijara rohunijihunaꞌe Huni ꞌunama amairie ariraꞌe renama ꞌumehuna. ");
INSERT INTO mcq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Joni Papitisita nechiꞌi ꞌwaravume ea puni sisea vwihane temukavume areva jihunaꞌe Joni pu ꞌunirame toa vaji samaume ꞌurijara. ");
INSERT INTO mcq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ꞌEne ea mapoka Jutia ora ꞌee Jerusaremi ora vaꞌe toa iha Jotani puni sisea nahama ꞌwaravume Jonira ꞌunirama toi samaume ꞌurijara. ");
INSERT INTO mcq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ꞌEꞌeme Joni kameru sapasi ateha vene ꞌee huni sisijino charia vejaraꞌomo ijí same aneura riha ꞌee pújúharu inuna. ");
INSERT INTO mcq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jonira najahe ijá ꞌiama Ea pina kaꞌene nuni túnaꞌi roujaho Hu nihoꞌo natohu kaivo na natohwa pana. ꞌEnajihunaꞌe na Huni mumora hwana aja rasahuna areri pareniu. ");
INSERT INTO mcq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na ja toi vaji samauta kaivo Hu ja Godoni ꞌAvenijino samahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ijí vea kajino Jesuho Nasareti Karari vaji rene roume Jotani Jonira ꞌunama toa vaji apúsamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hu niꞌaha kwino toa vaji rene ꞌurijiꞌi kavume akúpa jaraꞌeme Godoni ꞌAvena marahuꞌora punaꞌi ariha Huni roana. ");
INSERT INTO mcq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ꞌEꞌeme ira kahi akúpa ꞌahi rena roe ijá ꞌwama A Nuni Harihaꞌomo Na A oja mahu. ꞌEne Na A kavujaho nihoꞌo teamanimu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ꞌEjume niꞌaha kwino Godoni ꞌAveni ꞌejahae Jesuho nechi ahema vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hu naꞌia mapoka (40) nechiꞌi hiꞌeme Setanira roe Hu vena kamana. Hu hanuha nea puꞌúmo hiꞌeme ꞌona ojiꞌinapo roe Hu ꞌajoahara. ");
INSERT INTO mcq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Joniho tipura vaji hiꞌeme Jesuho Karari roe Godoni vuꞌa ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hu ijá ꞌiama Vea niapejume ja ꞌajohaꞌinijaho Godi niranavume roana. Joni sisea vwihane areꞌi kaivo Godoni vuꞌa mamaa nimai roꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ꞌEjume Jesu Karari rori vaiꞌi kavume Saimaniho ꞌee huni ꞌuꞌua Enituruꞌo úa vesaviꞌinaꞌomo puni namea soha vaji ꞌoname hijara. ");
INSERT INTO mcq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ꞌEjume Jesu ijá ꞌiama Ja Na ꞌararihie roe Nara ja najahe jara kijaꞌe ꞌekujaꞌinaꞌe ea aheraꞌejakúna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pu niꞌaha kwino namea puna irechaꞌi kaivo ꞌurina Huaꞌe ꞌararihae vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ꞌEjume Hu toa kajihuni rora kaji vaiꞌi kivume Jepati huni harihija Jemisi huni ꞌuꞌua Joni sisima ꞌahi hine puni namea turamanaꞌomo pu ijí hine hwearikara. ");
INSERT INTO mcq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hu pu niꞌaha kwino ꞌumenaume oma puna Jepatiho sisima vaji pwehwa puꞌúmo irechamiꞌi kaivo pu Hu ꞌarariha vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ꞌEjume pu vaꞌe Kapeniami usevajaho Sapatia veaꞌomo Jesuho aruma vaꞌe Sinakoku vaji hine najahana. ");
INSERT INTO mcq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hu pu najahume pu hene oja hwaꞌusahara. Ijihuni maijaho Hu nihoꞌo harurijiꞌi pu najahana. Areri Sikuraipiepo najahu jaꞌina pana. ");
INSERT INTO mcq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ꞌEꞌeme ijí Sinakoku vaji ea ꞌavena sisei ajiviꞌini ꞌurine chiriviꞌi ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jesu Nasareti orikera ꞌú A iraka vetúꞌena? ꞌÚ A núaꞌe ruaru ꞌahaume roane? A ea iraho na nikavu. A Godoni arira maijina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesura hu ꞌurarahe ijá ꞌwama Irunoꞌa areꞌi kaivo ariha vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ꞌEjume ꞌavena sisea kajara ea kajaho ꞌanaa piꞌonavume mweꞌi nama kuchikuchivuma kaviꞌi ꞌavena sisea kajaho eruhiꞌi ro ꞌeꞌume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ꞌEjume ea mapoka oja hwaꞌusahaume ꞌurina piraꞌarame ijá ꞌwava Ikaho irake? ꞌUnama maiuꞌina harusinaꞌe najuhu. Hu he parajiꞌina ijihuni hahi ꞌavena sisea ꞌuꞌo ꞌwaravuꞌe pu Huni ira hena veju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hu ijá venajihuni vuijaho Karari vaja marako he parajara. ");
INSERT INTO mcq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ꞌEjume pu Sinakoku areꞌikaꞌi Saimaniꞌo Enituru puni sei Jemisiꞌo Joni puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ꞌEꞌeme Saimani oni jura paranahijaho atama ꞌuname haha ohoa reꞌeme namajaho Hu ꞌwaravume henana. ");
INSERT INTO mcq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hu iji ꞌunama apena ꞌurijume atama niꞌaha kwinu paꞌareꞌeme hu ꞌurine mataume ꞌiruma amairia vajihume ijara. ");
INSERT INTO mcq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ijí nusirea kajino pu aneja vene atakina ꞌee ea kaꞌene ꞌavena sisesapo ajimaꞌina mapokaꞌe aherame Jesuni roara. ");
INSERT INTO mcq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ꞌEꞌeme ijí nusirea kajino ea kaꞌene ara kajino hijujija ijí vwichajiama kajaho nihoꞌo rarene namana. ");
INSERT INTO mcq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesura vejume ea kaꞌene atama naviꞌinijaho atama puna niꞌaha kwino paꞌarejara. Hu ea kaꞌene ꞌavena siseapo ajimaꞌinijija venaume niꞌaha kwino vaꞌara. Hu ꞌavena sisesa ꞌwaravume ira paꞌwaraꞌi ariha vaꞌara. Ijihuni maijaho pu Jesu kamareja arihara. ");
INSERT INTO mcq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesuho súꞌu vea maiꞌo aharasama kamino Huhusu ꞌurine vaꞌe ruha pini ea paꞌajino siporua ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ꞌEꞌeme Saimaniho napuhwa puꞌúmo Hu sama ojara. ");
INSERT INTO mcq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ꞌEnuvaꞌo pu Hu piuname ijá ꞌwava Ea mapokaꞌe A sarama oju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu ijá ꞌiama Roe nú vaꞌe ara ꞌahoꞌa mapoka kaꞌene ikehuni rori navuji ꞌuꞌo Na ira najahuma. Ijihuni maijaho Na ijihunaꞌe routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ꞌEjume Hu Karari araka mapoka kajino Sinakoku vaji vuꞌa najahe ꞌee ꞌavena siseapo ea ajimaꞌiniji sioma atoꞌarumana. ");
INSERT INTO mcq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ꞌEjume ea reporosia rukini roe Jesuni unaꞌi nitupari saviꞌi ijá ꞌwama A ura renaꞌamajaho venie na haha maaꞌe reniama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesuho nihoꞌo natohwaꞌe temuꞌeme ija hahi ꞌahi ranaviꞌi ijá ꞌwama Na ura reniunaꞌomo oni hahakaho maranaꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Niꞌaha kwinu ijí reporosia kajaho paꞌareꞌeme huni haha maranana. ");
INSERT INTO mcq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ꞌEjume Jesu ajira ijá ꞌwama A viheno! A nihoꞌo ea pina paꞌwaraꞌamana! ");
INSERT INTO mcq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ꞌEnakaivo vaꞌe oni haha pirisiti nahe ꞌee Mosisira nitama kaꞌene najaha jaꞌinaꞌe swasa veje ea mapoka oni reporosia paꞌarenajaho hena kaꞌavara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ꞌEnakaivo Hu vaꞌe ea mapoka ꞌwarama ape onajihunaꞌe Jesu araka mapoka kajaho paꞌurahonana kaivo Hu nechiꞌi rori hiꞌeme ea mapoka nianaapene Huni roara. ");
INSERT INTO mcq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma vea icharu paꞌareꞌeme Jesu kúꞌo ꞌuname Kapeniami ari roajaho hejara. ");
INSERT INTO mcq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ꞌEjume ea mapokaꞌe Huni vwichia kajaho ruha ituꞌona paꞌareꞌeme Jesuho pu hine ira najahana. ");
INSERT INTO mcq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ꞌEjume ea kaꞌene iriviꞌinijaho ea noꞌona noꞌona ijipo kima apena roara. ");
INSERT INTO mcq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ꞌEjume pura ꞌunama kaꞌene apene vaꞌe aruhuna areri parejumakame pu apene kahi ata huri tita napamareja ea iriviꞌina kajaho kichijiꞌi ijino apúsavume arihana. ");
INSERT INTO mcq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pu Jesu nimaa roja kaji Hu kimarena iriviꞌina kajaho ijá ꞌwama Nuni harihe oni sisea vwihanae arevuꞌe paꞌarenu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ꞌEjume Sikuraipia ꞌahoꞌa pu puꞌúmo hijajipo henareja oja vaji vwihajiꞌi ijá roja. ");
INSERT INTO mcq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Hu ea ikaho iraka vene ijaꞌina ꞌwarumo? Hu Godi mataha avanu kaivo Godira Huhusu sisea vwihanúa arehuna rojara. ");
INSERT INTO mcq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuho pura raka kaꞌene vwihajujaho Hu nimarako Huni ꞌavena vaji henarena ijá ꞌiama Ja iraka vene oja ijaꞌina vwihajo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na icháꞌinaꞌe iriviꞌinakaho ꞌwaraꞌejo? Na huni sisea vwihana areꞌeju ho Na ꞌwave ꞌurina huni kicha apene vaꞌena? ");
INSERT INTO mcq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ꞌEnakaivo Ema Puni Harihijaho iki mweꞌi emaapuni sisea vwihania arehuni harura apenana. ");
INSERT INTO mcq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Hu iriviꞌinijaho ijá ꞌwama Na a ꞌwaravu. ꞌUrine oni suha apene ari vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ꞌEjume pu kaꞌeme hu ꞌurina huni suha apena vaꞌume ea mapoka kame oja hwaꞌusahume pu Godi taꞌaroha ijá ꞌwava Nú unenuꞌu pina ijaꞌina pakivuri renu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hu kúꞌo soha rori vaꞌeme ea mapoka Huni roume Hu hine najahana. ");
INSERT INTO mcq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hu ro vaiꞌi kavume Aripiasi oni hariha Rivaiho takisiaꞌe vejuri sei vaji hijume Jesu ijá ꞌwama A Na ꞌararihie roa ꞌwavume hu ꞌurine Hu ꞌararihae vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesuho tisaiporuepo puꞌúmo Rivai oni sei ꞌiruma iꞌirono hiꞌeme takisia apejiꞌina ꞌee ea sisesa mapoka roe pu puꞌúmo ꞌiruma ine ꞌee Hu ꞌararihaara. ");
INSERT INTO mcq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Vea kaꞌene Sikuraipi Parasi ijipo kaꞌeme Hu takisia apejiꞌina ꞌee ea sisea puꞌúmo ꞌiruma ijume pu Huni tisaiporu ijija aporame ijá ꞌiava Hu iraka vene ea nihoꞌo takisia apejiꞌina ꞌee ea sisea vejiꞌinijihi puꞌúmo ꞌiruma ino? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu ijí henarena ijá ꞌiama Ea kaꞌene atama paꞌajaho pu juketa paura renaura kaivo ea kaꞌene atama rukinijipo juketa ura renaura. ꞌEnajihunaꞌe Na ea mamaa ijihipunaꞌe parouta kaivo ea sisei jihipunaꞌe routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naꞌia pina Joniho ꞌee Parasi puni tisaiporu ijija ꞌaura aremareja hiꞌeme ea ꞌahopo roe Jesuho ijá ꞌwava Irakijihunaꞌe Joniho ꞌee Parasi puni tisaiporu ijija ꞌaura areꞌejuꞌe oni tisaiporu ijija ꞌiruma paarevure? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu eha vene ijá ꞌiama ꞌUnama irakijino parua kaꞌene napara samajaho sora save naꞌeje ea kaꞌene ijí iꞌirono roavajaho ꞌiruma ꞌaura areme hiꞌeja? Parua kajara ijí hiꞌamajaho pu areri ꞌiruma ꞌaura paꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ꞌEnakaivo túnaꞌi parua kajaho apena vaꞌe paꞌareꞌeje ijiꞌa pu ꞌiruma ꞌaura arehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hu ijá ꞌiama Ei pini huni ateha sahasa napaꞌamajaho hu maiuꞌina paꞌuhua anehuna. Hu maiuꞌini aneꞌamajaho ateha kúꞌo napamareje tita natohwa rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ꞌEnakaivo ei pini ꞌwainia maiuꞌina hanuha sisa sahasa vaji paverimuna. Hu ijaꞌinaꞌe veꞌamajaho napamareje ꞌwainia kajaho arihuna. Ijihuni hahi ꞌwainia maiuꞌina hanuha sisa maiuꞌina vaji verivura. ");
INSERT INTO mcq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesuho Sapati veijino konesa juari ꞌuraha vaꞌeme tisaiporuhwapo konesa tuvara. ");
INSERT INTO mcq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ꞌEjume Parasiapo Jesu ijá ꞌwava Ike kiha! Pu iraka vene Jua puni varapi Sapati vei pavehuna kaꞌene ꞌwaravajaho vejo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hu ijá ꞌiama ꞌÚ Tevitira pwehwa puꞌúmo vea kaꞌene matuvume iraka kaꞌene venajaho ja vi taha kavare? ");
INSERT INTO mcq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apaiatara pirisitia rena hinani veijino Tevitiho pwehwa puꞌúmo matuvumakame Godoni sei vaji varapaꞌomo pirisitiepo pupusu ijuraꞌe ꞌeka ijajaho ja vi hejare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sapatijaho ema punaꞌe venana. ꞌEnakaivo emaijaho Sapati huna pana. ");
INSERT INTO mcq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ijihuni hahi Emaa Puni Harihijaho ꞌuꞌo Sapati huni Natohwa. ");
INSERT INTO mcq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesu Sinakoku kúꞌo vaiꞌi kavume ea kaꞌene ija ajuarajiꞌinijaho ijí hinana. ");
INSERT INTO mcq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ꞌEjume pu Jesu Sapati vei iraka veja kaꞌi ꞌahiume Hu ea ija ajuarajiꞌinijaho veje maraꞌena ꞌaho pamaraꞌena ronareja hina kanavara. Jesu veje maraja kamareje pu nama ꞌahiume avajara. ");
INSERT INTO mcq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu ea ija ajuarajiꞌinijaho ijá ꞌwama A ꞌurina namina roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesu pu ijá ꞌiama ꞌÚ nú Sapati uneunecha mamaa vehuna ho sisea vehune? Ea niꞌajihuna ho ea ꞌanie kwamasaꞌeja ꞌiavume pu varirareasahe mahina nii ma kame ira paꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu pu kimajaho Hu oja ajimana kaivo pu Jesu pataꞌarohajara Hu temumana. ꞌEjume Jesu ea ija ajuarajiꞌiniji ijá ꞌwama Oni ija ahasirima ꞌwavume hu ahasirivume maranana. ");
INSERT INTO mcq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parasi ijipo Heroti oni kanisoruepo puꞌúmo marakoꞌa maꞌahi vaꞌajime ahuma hina Pu icháꞌina Jesu ꞌanaa kwahunaꞌe ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu tisaiporuhwa puꞌúmo sohi vaꞌeme ea mapoka Karari ora ꞌee Jutia ora Hu ꞌararihaara. ");
INSERT INTO mcq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ea mapoka Jerusaremi ora Itumea ora Jotani ona karaꞌi hijura ꞌee Taia Saitoni orapo Jesura raka kaꞌene venaji hejajaho pu kaꞌiro roara. ");
INSERT INTO mcq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesu tisaiporuhwaha ijá ꞌiama Vaꞌajime sisima kame apena roe ranave naꞌeje emaapo Na mwavahinamiꞌavajaho Na ijí ajime vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hu ea mapoka vejuꞌe marania jihuni hahi ea puni haha siseijipo Jesu iji ꞌunaꞌi ꞌahiume tacharavara. ");
INSERT INTO mcq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ꞌAvena siseapo vea kaꞌene Jesu kavujaho mweꞌi arihiꞌi A Godoni Hariha ꞌumejura. ");
INSERT INTO mcq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ꞌEjume Jesu pu ira kisi ꞌwaravume Hu ea irana parone ꞌwarahuna ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ꞌEjume Jesu va kahi huriꞌa ꞌahi vaꞌiro vaiꞌi ea kaꞌene Hu ura rejajija ꞌwaravume pu ꞌurine pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ꞌEjume Hu ea iropu ropu noꞌo iji pijihe pu puꞌúmo ꞌurahojujija Hu irechamie ea najaha apenohuna. ");
INSERT INTO mcq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ꞌEne Hu harura mihe pu ꞌavena sisea siomahuna. ");
INSERT INTO mcq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hu ea iropu ropu noꞌo ꞌeka irechamia kajihipuni iha Saimani iha pina Pita ꞌiamarena ");
INSERT INTO mcq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemisiꞌo Joniꞌo Sepati oni harihija Jesu pu ea noꞌona kaivo iha nikwinuꞌina kaji Poanejisi ahuma ꞌuriha ꞌwaramana. Ihaka Poanejisina ꞌwavujihuni maijaho Akúpi ꞌAnúu Harihija ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Enituru ho Piripu ho Pataramiu ho Matiu ho Tomasi ho Jemisi ho Aripiasi oni harihaꞌo Tariasi ho Saimani ho Kenani ora ");
INSERT INTO mcq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jutasi Isikariati Jesu nihoꞌo nahamahajina. ");
INSERT INTO mcq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ꞌEjume pu vaꞌe sei ꞌiruma iꞌiro veꞌeme ea mapoka mapoka kúꞌo ani rejume pu ꞌiruma paijara. ");
INSERT INTO mcq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ea mapoka ꞌwamapenonu vaꞌume ijá ꞌwava Jesu nanamukúne ꞌwavajihunaꞌe Huni ehijijipo vaꞌe aheꞌiro vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ꞌEjume Sikuraipijipo Jerusaremi rena roajiviꞌi iraꞌatiji ijá ꞌiava ꞌAvena sisea Pierisiparu kaꞌene ꞌavena sisea ꞌajohaꞌinijara Jesu ajiviꞌinaꞌomo ꞌavena sisea kajara Jesu niꞌajahuꞌukame ea ꞌavena sisea ajimaꞌinijija siokunia atoꞌarumauna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu pu ꞌumenaume Huni roume Hu haa ꞌwarama ijá ꞌiama Icháiꞌinaꞌe Setaniho Setani siokuꞌena? ");
INSERT INTO mcq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ara ahaama hina ꞌarahiꞌi hiꞌipisa areri paꞌarejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kachiꞌinapo ꞌuraiꞌi hiꞌipisa pu ahaame hijaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ꞌEje Setani oni pwehija ꞌavena siseaꞌomo pu puꞌúmo ꞌarahiꞌi hiꞌipisa pu ahaama hinareje paꞌarejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ꞌEne ea roe ea ajisimaꞌori jihuni sei ajima kukua ꞌekaꞌiro roꞌipisa hu marako ajisina kajaho kamoꞌi kaivo ijia huni kukua ꞌetujahaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Heha! Na nimaa ja ꞌwaravu. Na emaa puni sisea mapokaꞌe vwihanie arehuna. ꞌEe sisea nihoꞌo mapoka ani aniꞌina ea ronaꞌavajaho Godi vwihanie arehuna. ");
INSERT INTO mcq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ꞌEnakaivo Godi oni ꞌAveniji ronaꞌavajaho Hu pavwihana arehuna kaivo majama eha sisei mahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hu ijaꞌinaꞌe ꞌwarama jihuni maijaho pu ijá ꞌwava Jesuho ꞌavena sisei ajiviꞌina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ꞌEꞌejume oaha ꞌuꞌuhwa puꞌúmo roe maꞌahi namiꞌi kaivo Hu roꞌamarono ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ea kaꞌene Jesuni rori namijajipo Jesu ijá ꞌwava Hena! Ohona ꞌuꞌuhuana roe maꞌahi A saravu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu pu ijá ꞌiama Nuni ohija ꞌee ꞌuꞌuhija irahije? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hu ꞌurina ea kaꞌene Huni rori hija kaji kimapenojiꞌi ijá ꞌiama Ike kiha! Nuni oha ꞌuꞌuhija ikena. ");
INSERT INTO mcq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ea irahipo Godoni ira hena vejiꞌinijija Nuni ꞌuꞌuhije ꞌee Nuni maꞌipija ꞌee Nuni oha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ꞌEjume Jesu kúꞌo vaꞌe soha rori ea najahana. ꞌEꞌeme ea mapoka rouma kimarena Hu sisima ꞌahi ajima soha toi va hiꞌeme ea mapoka soha rori hijara. ");
INSERT INTO mcq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ꞌEne Hu uneunecha mapoka hai najahe ikaꞌinaꞌe ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Heha! Ei pini ꞌina ꞌeka ꞌoꞌiro vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ꞌEꞌeme ikaꞌinaꞌe renana. ꞌIna ꞌahoꞌa ꞌunama ahi arihume ukapo ro ijara. ");
INSERT INTO mcq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ꞌEjume ꞌina ꞌahoꞌa muna ꞌahi mweꞌa maꞌuako namaji arihajija marako riavara kaivo chinuma jojora parejara. Ijihuni maijaho muna ꞌaha mweꞌa maꞌuako namana. ");
INSERT INTO mcq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ꞌEꞌeme vei ꞌeꞌunarena ijaho chinuma jojora paꞌanaꞌomo ꞌanae sarajara. ");
INSERT INTO mcq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ꞌIna ꞌahoꞌa ija sisea vaji arihajija riama ajivara kaivo ija sisea kaꞌene oma rukina kajipo raorihume siserane ꞌina parejara. ");
INSERT INTO mcq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ꞌEnakaivo ꞌina ꞌahoꞌa mweꞌa mai arihajaho riama marasahe ꞌina ꞌahoꞌa mapoka (30) rejume ꞌahoꞌa mapoka mapoka (60) rejume ꞌahoꞌa nihoꞌo mapoka mapoka (100) rejara. ");
INSERT INTO mcq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hu ijá ꞌiama Ea irara areri heꞌiro veꞌamajaho hu ataa apúsaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hu tisaiporuhwaha ꞌee ea ꞌahoꞌa puꞌúmo hiꞌeme pu apoma ijá ꞌwava Haa ijihuni maa irake ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hu ijá ꞌiama Godoni hema ijihuni maijaho Hu ja mihu kaivo ea ꞌahoꞌa pu haaru heju kaivo ijihuni maa paheju. ");
INSERT INTO mcq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ijihunaꞌe pu kaꞌavajaho pu kahuna kaivo pu maa pavwihajura. Hehunijaho pu hejura kaivo ijihuni maijaho pahejura. Pu ijihuni maiji heꞌipisa Godi pu vwihanie arevaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ꞌEjume Hu pu ijá ꞌiama ꞌÚ ja haa kajaho pahejo? Ja haa kaji paheꞌavajaho ꞌú ja icháꞌina haa ꞌahoꞌa heꞌeja? ");
INSERT INTO mcq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Heha! ꞌIna kaꞌene ei ꞌonajaho Godoni Ira. ");
INSERT INTO mcq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ꞌIna kaꞌene ꞌunama toi arihajihuni maijaho ea Godoni Ira hejuꞌukiviꞌi Godoni Ira puni oja vaji navujaho marako Setanira ꞌetujihuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ꞌIna kaꞌene muna ꞌahi arihajihuni maijaho ea Godoni Ira marako hene teamanavura. ");
INSERT INTO mcq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ꞌEnakaivo puni vaja chinuma pasama jihunaꞌe marako paꞌarenuna. Ijihuni maijaho Godoni Irijihuni hahi ea ꞌahopo siseꞌi ꞌahiura ho hami pahiꞌavajaho marako arevura. ");
INSERT INTO mcq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ꞌIna kaꞌene ijí oma rukini vaji arihajaho ea Godoni Ira hehuna kaivo ");
INSERT INTO mcq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","karokaha vehuniji vwihanune ꞌee monia icháꞌinaꞌe ꞌekahuna ijí vwihanuna ꞌee uneunecha mapoka kima ura rena paraꞌavajara oja vaja rareje Godoni Ira puni oja vaji marako paꞌarenuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ꞌIna kaꞌene mweꞌi mai ꞌojajaho areri ea Godoni Ira hena pu ꞌeka oja vaji irechame veju. Ea pina hami (30) venune ꞌee ea pina hami hami (60) venune ꞌee ea pina nihoꞌo hami hami (100) venuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hu pina ijá ꞌiama Ea naheha enujaho ꞌú hu siꞌuari vahanamune? ꞌO suha hari ranamune? Pana hu samaumai ranavuꞌe hananuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Uneunecha kaꞌene pakiꞌeju vaji navujijahija túnaꞌi samaumaa rehuna. Uneunecha ꞌahoꞌa a vahanamiuꞌe navuraꞌomo túnaꞌi samaumaa rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ea irara areri heꞌiro veꞌamajaho ataa apúsama heꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ꞌEne Hu pina ijá ꞌiama Ja raka kaꞌene heꞌavajaho vwihaꞌavara. A ꞌunama icháꞌinaꞌe ea ꞌahiꞌama jaꞌinaꞌe nikwinuꞌina kajaꞌinaꞌe a ꞌuꞌo hurahara ijaꞌinaꞌe ꞌahahuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ea pina hu ꞌahoꞌa naꞌavajaho ꞌahoꞌa ꞌuꞌo ꞌekuna. ꞌEje ea pina huna poku panaꞌavajaho mahoꞌo ꞌetujahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hu pina ijá ꞌiama Godoni arijihuni ꞌunamijaho areri ikaꞌina. Ei juasiꞌi soa samujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ea hu soa samareꞌe hu ro ꞌurahonujaho matauma onuna kaivo ꞌunamaka marajujaho hu pahena pakamuna kaivo hu nena ꞌurina vaꞌejuꞌe ꞌurine marasahura. ");
INSERT INTO mcq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ꞌEꞌejuꞌe riama ajima aꞌa rasamareꞌe túnaꞌi ꞌina rejura. ");
INSERT INTO mcq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ꞌEnareꞌe tuma marasahukiviꞌi ijí mena ijura. Ijihuni maijaho juara savuri veijara roana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ꞌEjume Hu pina ijá ꞌiama ꞌÚ Godoni ꞌunama icháꞌina najahune? ꞌÚ haa iraki areri Godoni arijihuni ꞌunamijaho najuhune? ");
INSERT INTO mcq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Godoni ꞌunamijaho areri kwava ꞌina punaꞌi maꞌuꞌumaaꞌomo mweꞌi ꞌahi ꞌojura. ");
INSERT INTO mcq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ꞌEnakaivo ꞌina kají mweꞌi vaji ꞌonavujaho riama icha niꞌimaꞌura renuna. Anuama ataukaviꞌi uka roe ajime nesa vene ichaꞌa vaja kaji hijura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hu Godoni vuꞌa mapoka hai emaapo hehuni jaꞌinaꞌe Hu ꞌwaramuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hu ea haaru ꞌwaramuna kaivo tisaiporuhwa puꞌúmo hine haa kajihuni maijaho najahuna. ");
INSERT INTO mcq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Veaka nikwinuꞌina kajihuni nusirei Hu Huni tisaiporu ijá ꞌiama Nú karoꞌi toa ropunaꞌi vaꞌukúna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ꞌEjume pu ea mapoka toa rori irechamiꞌi kaivo pu Hu aheme sisima ꞌahi ajime toi ropunaꞌi vaꞌiro vaiꞌi kivajaho sisima ꞌahoꞌa pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pu vaꞌeme puura niꞌimaꞌura hirame toa amenarena sisima kajaho toa ituꞌoꞌiro veꞌeme ");
INSERT INTO mcq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hu sisima vipunaꞌijaꞌi ohaha vene neꞌeme tisaiporuhwapo saa ijá ꞌwava Najuhiꞌinikera A pavwihanúꞌeje nú kwamasaꞌeje? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ꞌEjume Hu ꞌurine ira ajiraꞌe puura ꞌee toa kajaho areha ꞌiamana. ꞌEjume niꞌaha kwinu Huni ira ꞌahi areme ꞌee soha mamaa rena namana. ");
INSERT INTO mcq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ꞌEjume Hu pu ijá ꞌiama Ja rakijihunaꞌe juvo? ꞌÚ ja panimaa rojo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ꞌEnakaivo pu nihoꞌo tea junama parajume pu ꞌwamapenojiꞌi ijá ꞌwava Ea iranaꞌomo vejuꞌe puura ꞌee soha Huni ira hejare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ꞌEjume pu soha sue ropunaꞌi kwaa iha Kerasinisi usevara. ");
INSERT INTO mcq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hu sisima vaji ariha roꞌeme ea kaꞌene ꞌavena sisei ajiviꞌinijaho euchi hinunaꞌomo roe piunamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ea kajaho euchi hinunaꞌomo ea hu nihoꞌo senia areri pakamovura. ");
INSERT INTO mcq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Naꞌia mapokaꞌe ea kajaho anikuroa ꞌee senia kamovujaho hu turama useunaꞌomo ei pini hua ꞌajoahuna areri pana. ");
INSERT INTO mcq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hu naꞌia veiriꞌa euchia ꞌee huriꞌa vaji emaavajiꞌi muna ꞌeke huni haha puaviꞌi hinuna. ");
INSERT INTO mcq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ꞌEjume hu kahakaro namijiꞌi Jesu kamarena ninuma roe Huni unaꞌi nitupari samana. ");
INSERT INTO mcq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Hu ira ajira emaavajiꞌi ijá ꞌwama Jesu Godi nihoꞌo Natohwi jihuni Hariha A iraka na vetiꞌena? Na jarirama ꞌwaravukúne A na pasiseꞌi ꞌahiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ꞌAvena siseijara ꞌwarama jihuni maijaho Jesura ꞌavena siseakera eakaho ranaꞌi kaivo ꞌeꞌuna ꞌwamajihunaꞌe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ꞌEjume Hu ijá ꞌwama Oni iha irane? ꞌwamana. Hu eha vena ijá ꞌwama Nuni iha Rijani. Ijihuni maijaho nú ꞌavena mapoka ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hu hina miꞌimiꞌiviꞌi Hu kwaa pina pairechamúe vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Maha mapoka kahe ꞌiruma ijiꞌi huriꞌa hari hiju. ");
INSERT INTO mcq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ꞌEjume pu miꞌimiꞌiviꞌi Hu ijá ꞌwava A irechamúe nú vaꞌe maha kahehi puni vaji vaꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ꞌEjume Jesu pu irechamiume ꞌavena sisesa kajija ariha vaꞌe maha ajimaume maha mapoka mapoka (2,000) niꞌaha kwinu ꞌurina ninukujaha vaꞌe rarahi arihe soha vaji niname imwasamiume kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Emaa kaꞌene maha ꞌajohiꞌinijija kimareja juhaha ninuma vaꞌe ari oraꞌe ꞌwaramapenojume ea mapoka raka kaꞌene renaji kiꞌi ꞌahiume roara. ");
INSERT INTO mcq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pu Jesuni roi kavume ea kaꞌene ꞌavena sisei ajiviꞌinijaho ateha iruhe húmata maraꞌeme masuani hijuma pu kamareja nihoꞌo tea junamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ea kaꞌene kavajipo ꞌavena sisei ajiviꞌini jihuni vuꞌa ꞌee maha puni vuꞌa niꞌaha kwino ari ora ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ꞌEjume ari ora kajipo aneja vene ꞌejahae ijá ꞌwava A núni kwaa areꞌi kaivo vaꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ꞌEjume Hu ꞌurina sisima ajima vaꞌiro vejumakaviꞌi ea kaꞌene ꞌavena sisei ajiviꞌina kajara Hu huꞌúmo vaꞌirono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hu tanurahe pavaꞌamarono ꞌwaramana. ꞌEnakaivo Hu ijá ꞌwama Ehuapuni vaꞌe raka kaꞌene Godira vetae niꞌajahajaho ijá ehuana ꞌwaraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ꞌEjume hu ꞌurina vaꞌe Tikaparasi Jesura raka kaꞌene huaꞌe vetiajaho ijá najahume pu ea mahoꞌo hena oja nihoꞌo hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sisima ꞌaha kajino Jesu kúꞌo sue toa ropunaꞌi vaꞌeme ea mapoka toa rora kajino nianaa roara. ");
INSERT INTO mcq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairasi Sinakoku kaukara ꞌajohiꞌina pinaꞌomo roe Jesu kame nitupari satiana. ");
INSERT INTO mcq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ꞌEne nihoꞌo ꞌejahae ijá ꞌwama Nuni ꞌapaja nihoꞌo kwaꞌiro venu. A huni roe ija ꞌunave maraje hinama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ꞌEjume Jesu hu huꞌúmo vaꞌeme ea mapoka roajime ꞌunama tanuꞌurahara. ");
INSERT INTO mcq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Napara pina juara iropu ropu noꞌo ꞌai vuaravuꞌe hinuna. ");
INSERT INTO mcq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ꞌEjukamareꞌe hu juketapo naꞌia mapoka amairiahura kaivo hu pamaranuna. Hu monia mapoka ꞌúsia ꞌimenuna kaivo venahujaho pamarane ꞌee nihoꞌo siserana paranuna. ");
INSERT INTO mcq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ijá veꞌeme napara kajaho hijiꞌi hejume ea ꞌahopo Jesura raka kaꞌene venuji ꞌwavuma henarena ꞌurina ea vaja kajino ꞌuraha ruvaꞌuvaume Jesuni túnaꞌi namijiꞌi Huni ateha ꞌunamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hu ijá rona Na Huni atehake ꞌunaꞌujaho sonahiꞌena ronana. ");
INSERT INTO mcq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ꞌEꞌikaivo hu ateha Huna kajaho uri ꞌunama kajino niꞌaha kwino ꞌaa huna kajaho paꞌarenana. ꞌEjume napara kajaho henajaho huni haha vaja sonanana. ");
INSERT INTO mcq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ijá veꞌeme Jesuni harura maꞌuako paꞌarejuma henarena Jesu taꞌarohe nia niriapenojiꞌi aporama ijá ꞌiama Irara Nuni ateha ꞌunamane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ꞌEjume tisaiporu epo ijá ꞌwava Ea mapoka ani reja kajihipuni vaji A naminanaꞌomo pura ꞌunaravara. ꞌEnakaivo A raka vena Irara ꞌunirimana ꞌúmo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesu kúꞌo nirie napara kaꞌene ateha ꞌunamajaho samapenonana. ");
INSERT INTO mcq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ijá veꞌeme ijí napara kajaho henajaho huni haha nisonavuma henarena juma simaviꞌi niꞌaha kwino Jesuni unaꞌi ojiꞌi nahama Jesu ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hu napara kajaho ijá ꞌwama Naparakera a iraka kaꞌene nimaa rona ijarahara vejume a maranaana. A sonahaanakúna teamanaꞌeje vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hu hina vuꞌa ꞌwaraꞌeme ea ꞌahoꞌa Sinakoku natohwijihuni sei rena roe ijá ꞌwava ꞌApajuna nikwamana kaivo rakijihunaꞌe Najahiꞌina ꞌwaraviꞌi hino? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ꞌEnakaivo ea kajipuhipo vuꞌaka ꞌwaravajaho Jesu henarena Hu Sinakoku natohwa ijá ꞌwama A patea junamana kaivo nimaa roꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ꞌEjume Jesu ea mapoka ruravume hijumakiviꞌi Pita ho Jemisi ho ꞌee ꞌuꞌua huna Joninaꞌomo ijihi puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ꞌEjume pu vaꞌe Sinakoku natohwi jihuni sei useviꞌi hejume pu niramaruma piraname nihoꞌo natohwa temukavara. ");
INSERT INTO mcq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ꞌEjume Hu ijí sei vaji ajima vaꞌarena ijá ꞌiama Ja raka venareꞌe niramaruvo? Napaiseakaho pakwamana kaivo hu nenu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ꞌEjume pu ijahume Hu pu maꞌahi irechamiuma vaꞌara. ꞌEjume Jesu Huni tisaiporu noꞌopisune oaha omaha aherame napaisea kajara namajino vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesu napaisea ija ꞌunaviꞌi Arameka opuni iri ijá ꞌwama Tarita Kumi ꞌwamana. Tarita Kumi ijihuni maijaho napaiseakera ꞌurina! ");
INSERT INTO mcq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ꞌEjume niꞌaha kwinu napaisea kajaho ꞌurina ꞌurahonana. Napaisea kajaho juara iropu ropu noꞌo paꞌarenana. Ijá vejuma kamarena ea kaꞌene ijí hijajaho nihoꞌo natohwa oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu pu ajira ijá ꞌiama Ja ike Nara vejukaho ea ꞌahoꞌa paꞌwaraꞌavara kaivo napaiseakaho ꞌiruma iꞌimaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hu kwaa kajaho arema ꞌurine Huni kwaa anejijino tisaiporuhwa puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapati veijino Hu vaꞌe Sinakoku ea najahana. Ea mapoka sea kajaho ani reꞌeme Hu ꞌwaramaji pu henareja oja hwaꞌusahara. Pu ijá ꞌwava Hura ꞌwaramu kajaho ichi apenane? Hu ichi kamane? Irara Hu nahane? ꞌEne ijí unekajihuni harura Hu icháꞌina veno? ");
INSERT INTO mcq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ꞌÚ Hu kapinita? ꞌÚ Hu Meri oni Harihe? ꞌÚ Jemisi ꞌee Josisi ꞌee Jutasi ꞌee Saimani Huni ꞌuꞌuhije? ꞌÚ Huni maꞌipija iki hijo? ꞌwavara. ꞌEnajihunaꞌe pu Jesu pataarohara. ");
INSERT INTO mcq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu pu ijá ꞌiama Ea kaꞌene poropeti ijihuni araneji hijujija ꞌee huni kachiꞌina huni amuhija ꞌee huni kwai ea kaꞌene hijujija huni hura pavejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kwaa kajaho Huni harura panajahana kaivo ea kwinu kwino atama navajaho Hu niꞌaha kwino ija puni haha ꞌahi irechavume maraniara. ");
INSERT INTO mcq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pu Jesu kamareja panimaa rojajaho Hu nihoꞌo puruva renana. Túnaꞌi Jesu vaꞌe arara kajino ea mapoka najahapene onana. ");
INSERT INTO mcq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesu Huni tisaiporu iropu ropu noꞌo ꞌwaravume roumakiviꞌi irechamiume kwaaka mapokakino ea najahapene oꞌirono noꞌo noꞌo vaꞌiro vejumakiviꞌi Hu Huni harura tisaiporu mihe ꞌee ꞌavena sisea siomahuni harura ꞌuꞌo mihana. ");
INSERT INTO mcq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hu najaharena ijá ꞌiama Ja uneunecha mapoka paꞌekaꞌavara kaivo pijuharu ꞌekaꞌavara. ꞌIruma paꞌeke suvaikia paꞌeke monia tuja vaji paꞌekaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ꞌEnakaivo siripasieru same ꞌee ateha noꞌo paꞌekaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hu pu ijá ꞌiama Ja ara pini useme sea pini ajiꞌavajaho sea kaji hinuvaꞌo ara kaji areꞌirono areꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ja ara pini vaꞌe pu ja pataarorahe joni vuꞌa paheꞌi ꞌahie veja kiꞌavajaho nijinakúne joni mumora hari túa taireve ariha kimareje ea mapoka hene kimareje ijá ꞌwahune Ea kajija puni vuꞌa paheju kamareꞌe avaju ꞌwahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ꞌEjume pu vaꞌajime ea najahe pu sisea areꞌavarono najahoꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pu ꞌuꞌo ꞌavena sisea ajiviꞌinijaho ꞌavena siomahe ꞌee ea atama naviꞌinijaho ꞌwerui ꞌonahuma sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kini Heroti Jesu oni pinana niꞌimaꞌura rena onajaho hinarena hu ijá ꞌiama Joni Papitisita kwamanaꞌe hura ꞌurinanaꞌomo ike harurakaho huni vaji renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ꞌEjume ea ꞌahoꞌa Hu Iraijana ꞌwavura. ꞌEe ea ꞌahoꞌa Hu poropeti pina ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ꞌEnakaivo Heroti hu henarena ijá ꞌiama Joni kaꞌene nara uroa ahatumahujara vukúꞌo ꞌurinana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herotiasi oni hahi Herotira huni iri ꞌwaravume Joni kamome tipurai ranamana. Herotiasiho ꞌuꞌuaha Piripu oni naparaꞌe ꞌwahana. ");
INSERT INTO mcq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ijihuni hahi Jonira Heroti ijá ꞌwama Ara oni ꞌuꞌuijihuni napara kaꞌene Herotiasi ꞌwahajaho areri parenu. ");
INSERT INTO mcq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ꞌEnajihunaꞌe Herotiasi Joniꞌi sena venana. ꞌEne hu ꞌanae kwahuna ura renana kaivo hu areri parenana. ");
INSERT INTO mcq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herotiho Joni juhamana. Ijihuni maijaho hu henajaho hu ea nihoꞌo mamaa ꞌee arira ijihunaꞌe hu Joni ꞌajoahana. Heroti Jonira iraka kaꞌene ꞌwaramujaho hu ura heꞌi ꞌahauna kaivo hu hene nihoꞌo natohwaꞌe haha henuna. ");
INSERT INTO mcq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ꞌEne Herotiasira vea kaꞌene ura renajaꞌini nituꞌeme Heroti nahejari vea rejume hu ꞌiruma nihoꞌo mapoka mapoka vene irechaꞌeme ea kwaa ꞌajohiꞌinijijahija ꞌee Heroti oni namikia ꞌee Karari opuni ea mamaꞌina Heroti oni roara. ");
INSERT INTO mcq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ꞌEjume Herotiasi oni ꞌapaja roe javavume Herotiho ea kaꞌene Heroti oni roajijahija kame nihoꞌo ura rena paranana. ꞌEjume Heroti napara kajaho ijá ꞌwama A iraki ura renaꞌamajaho na ijí mahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Heroti nahama ꞌwarama ijá ꞌwama Godira na kimunaꞌomo a iraka ura renaꞌamajaho na nuni ara kwaa pwinanaꞌa mahoꞌo a maꞌeju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ꞌEjume napara kajara oahoni vaꞌe ijá ꞌwama Na iraka hu ꞌwarahune? ꞌwamana. ꞌEjume hu ijá ꞌwama A Joni Papitisita oni húmata ꞌuhua miha ꞌwaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Napara kajara vea panisaꞌikaꞌi ninuma vaꞌe Heroti ijá ꞌwama Joni Papitisita oni húmata tevua ꞌahi ranamareje apena ro miꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ꞌEjume Heroti nihoꞌo natohwa temumana. ꞌEnakaivo hu ea mapoka puni unaꞌi nahama ꞌwarama jihunaꞌe hu napara kajaho papataarohana vo venana. ");
INSERT INTO mcq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ꞌEne niꞌaha kwinu Hu huni pwea ranama ijá ꞌwama Vaꞌe Joni oni húmata ꞌuhue apena roa ꞌwamana. ꞌEjume pwea kajara vaꞌe tipura ara vaji Joni oni húmata ꞌuhuana. ");
INSERT INTO mcq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hu tevua ꞌahi apena roe napara kaji mahume napara kajara apena vaꞌe oaha mahana. ");
INSERT INTO mcq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Joni oni tisaiporu epo henareja roe huni haha apena vaꞌe kwananavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apasorua kúꞌo nianae roajime pura raka kaꞌene vene ꞌee najahajaho Jesu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hu pu ijá ꞌiama Ja roajive nú kwaa pina ea pahijujino maꞌuako siheria veja. Ijihuni maijaho ea mapoka roi vaꞌuma kimareja pu ꞌiruma ihuni vea parenana. ");
INSERT INTO mcq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pu sisima ꞌahi ajime kwaa kaꞌene ea pahijiꞌinijino vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pu vaꞌajiꞌeme ea nihoꞌo mapoka kimareja Jesu sisima ꞌahi vaꞌume pu mumori ninukujaha arara kaji roe useme hiꞌeme Jesu roume piunavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu roe ꞌeꞌujiꞌi kimajaho nihoꞌo temume oja turaꞌi ꞌahaana. Ijihuni maijaho pu sipi ꞌajohiꞌina paꞌanepo hina ojujaꞌinaꞌe vejara. ꞌEjumakame Hu ijiꞌa uneunecha mapoka najahana. ");
INSERT INTO mcq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Vea ꞌoꞌiro vaꞌeme Huni tisaiporuepo Jesuni rori vaꞌareja ijá ꞌwava Kwaa ikaho ea paꞌana kaivo vea iviamaa nipaꞌareꞌi venukúna ");
INSERT INTO mcq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ea mapoka irechamie ara arakino vaꞌajime uneunecha ꞌimena ija ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesu eha vene ijá ꞌiama Jara pu uneunecha vajiꞌavara ꞌiamana. Pu ijá ꞌwava ꞌÚ nú vaꞌe monia mapoka mapoka (200 kina) puretia ꞌimenareje pu vajihe iꞌeje ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu aporama ijá ꞌiama Joni puretia icharo navo? Vaꞌa kiha ꞌiamana. Pu saramapene onu vaꞌume ijiꞌa ijá ꞌwava Iropune ꞌee kija noꞌona ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesu ꞌwaravume ea mapoka vaꞌe karasi ꞌahi niku niku hijasavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nia ꞌahoꞌa ea mapokaꞌe (100) hijume nia ꞌahoꞌa ea mapoka (50) hinape ojara. ");
INSERT INTO mcq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu puretia iropune ꞌee kija noꞌo ꞌeke akúpi ꞌahi nia nirii Godoni siporua ꞌojiꞌi merajahana. ꞌEjume puretia tuachame Huni tisaiporu vajihume pu ꞌeke ea kajaho vajihapene ojara. ꞌEne kija kaji ꞌuꞌo ijaꞌina venana. ");
INSERT INTO mcq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ꞌEjume pu ijume tea hianavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ꞌEjume puretia ꞌee kija pwina kaꞌene navajaho nianae katija iropu ropu noꞌo vejume itusahara. ");
INSERT INTO mcq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Parua kaꞌene puretia kaji ijajijahija ea mapoka (5,000). ");
INSERT INTO mcq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hu Huni tisaiporu ijá ꞌiama Ja marako sisima vaꞌajimareje kami toi ropunaꞌi ara iha Petasaita vaꞌeje Na ea irechamiꞌi kaivo vuꞌejukúna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hu ea ꞌajorame irechamiuma vaꞌumakiviꞌi va kahi huriꞌi hine siporua ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Vea nusireꞌejuꞌe sisima soha riri naꞌejuꞌe Jesu Huhusu kari amari hinana. ");
INSERT INTO mcq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hu kimajaho sisima veje vahuni ꞌunamijaho pu puruva renana. ꞌEjume asiasia ijiki ninaꞌeje ijikari vahunijaho areri parenana. Nitunituhi puni roꞌi ꞌahaume Hu toi ꞌahi roana. ꞌEnarena Hu pakiviꞌi asitahu jaꞌina venana. ");
INSERT INTO mcq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Vea kaꞌene pu kavume Hu soha ꞌahi namina roajaho pu vwihajajaho ꞌavena sisea raka ꞌwaꞌikaꞌi emaavajara. ");
INSERT INTO mcq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pu ea mapoka Hu kame nihoꞌo tea junava jihunaꞌe Hu marako ijá ꞌiama Naranakúne masuani hiꞌi kaivo juvujaho areha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ꞌEjume Hu roe ijí sisima vaji ajiꞌeme asiasia kaꞌene hwasihajaho paꞌarejume pu oja nihoꞌo hwaꞌusahaꞌeme hina vwihajara. ");
INSERT INTO mcq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Puni oja kaisini jihunaꞌe Hura puretia kaꞌene tuachama vajiha jihuni maijaho pu nihoꞌo pahena pakavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pu toa ropunaꞌi vaꞌe Kenesareti useme sisima puna anika vena hijara. ");
INSERT INTO mcq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pu sisima vaji rena rarihumakiviꞌi ea mapoka kajija marako Hu samai kavara. ");
INSERT INTO mcq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ꞌEjume niꞌaha kwino arara kajino ninukujaha vaꞌajime atakina kichame Jesura hinujihija kichijiꞌi irechavara. Kwaaka mapoka kajino Hu vaꞌujaho pu nijaimaru vejura. ");
INSERT INTO mcq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ꞌEjume Hura ara mamaꞌina maꞌuꞌumai ara rora kajino ea atakina ꞌeka roe maketi tinia irechaviꞌi Huni ateha uri ꞌunahuniji jarima ꞌwaravara. ꞌEjume ea mapoka Hu ateha uriji ꞌunavajaho sonahiara. ");
INSERT INTO mcq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parasi ꞌee Sikuraipi ijihi puꞌúmo ahuma Jerusaremi rena Jesuni roara. ");
INSERT INTO mcq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ꞌEjume Huni tisaiporu kivume ija pasoꞌi kaivo hina ꞌiruma ijara. ");
INSERT INTO mcq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parasi ꞌee Jua mapoka emahwapuni tamanaꞌomo pu ija soꞌavajiana kaivo pasoꞌavajija ꞌiruma paijura. ");
INSERT INTO mcq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pu vea kaꞌene maketi rena roujaho pu ꞌiruma paijura kaivo ija somareꞌe ijiꞌa ijura. ꞌEne pu sahwapuni tamana ijí venareꞌe puni tevua some siꞌuara some ꞌee kapusia some ijá vejura. ");
INSERT INTO mcq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parasi ꞌee Sikuraipiepo Jesu apome ijá ꞌwava Rakijihunaꞌe tisaipuruhuana ema tamapo vejujaꞌina pavejure? Pu ꞌiruma iꞌi vejujaho ija pasoꞌi kaivo maijura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hu eha vena ijá ꞌiama Ja nihoꞌo iraꞌasimaꞌura Aisea nitama heha ꞌahi ja rona ijaꞌina ꞌwaramana. Aisea ijá ꞌiama Ea kijahija iraru hohovura kaivo oja punijaho ani vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pu mairiji Na taꞌarorihura kaivo pu Nuni tamana ura paveꞌi ꞌahiura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pu vwihajujaho emaa puni tamanijaho Godoni tamana ꞌwaꞌi kaivo ijí ea najahura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ꞌEne Hu pu pina ijá ꞌiama Ja Godoni tamanijaho ani ranaꞌi kaivo joni tamanijino ea najahura. ");
INSERT INTO mcq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosisi nitama ijá ꞌiama Ohuneꞌo omuneꞌo puni hura vetiꞌamana. Ea irara oaheꞌo omaheꞌo siripaꞌamajaho hu ꞌanaa kwaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ꞌEnakaivo ja ani najaha ijá ꞌwava Ea pini unenuꞌu pina naꞌeje Godoni katua iꞌi kaivo omaheꞌo oaheꞌo paniꞌajihareje miꞌamajaho ja ijaho mamaa ꞌwahuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ja ijaꞌina ꞌwarava jihunaꞌe ja hu ruha paꞌaremahuꞌe omaheꞌo oaheꞌo puni unenua ꞌahoꞌa pavenu. ");
INSERT INTO mcq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ja ijaꞌina najahujaho Godoni ira ꞌuhuꞌi kaivo joni tamana ranavu. Uneunecha mapoka iviamaa ja vejujaꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hu kúꞌo ea mapoka ꞌumenaume Huni rouma ijá ꞌiama Nuni vuꞌa hena vwihaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ea uneunecha samai rena vaji vaꞌujipo vejuꞌe hu siserahuna pana kaivo huni vaji rena roa usevujara vejuꞌe hu sisea renuna. ");
INSERT INTO mcq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ea irara areri heꞌiro veꞌamajaho ataa apúsaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesu eaka mapoka kajaho irechamiꞌi kaivo sei vaji vaꞌume tisaiporuepo haa ijihuni maijaho apovara. ");
INSERT INTO mcq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hu aporama ijá ꞌiama ꞌÚ ja ꞌuꞌo pahejo? ꞌÚ ja pahena pakavujaho ea uneunecha samai rena vaji vaꞌujipo vejuꞌe hu siserahuna pane? ");
INSERT INTO mcq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ijihuni maijaho ꞌiruma ijujaho oja vaja pavaꞌuna kaivo tei vaji vaꞌuna. ꞌEnaꞌomo túnaꞌi vaꞌe tihejuꞌe paꞌarenuna. ꞌEnajihunaꞌe ꞌiruma mapoka nihoꞌo mamaa ꞌiamana ");
INSERT INTO mcq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hu ijá ꞌiama Irakijara emaapuni vaji rena roa usevujara vejuꞌe hu sisea renuna. ");
INSERT INTO mcq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ijihuni maijaho uneunecha mapoka sisea oja vaji navujihunaꞌe ijí sisea vwihaꞌejuꞌe oja ꞌurinauꞌukamareꞌe napara turame ꞌasúra aheramone ea ꞌania kwamasahe ");
INSERT INTO mcq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nesa apene ea pipuni uneunecha kiꞌeje ituname uneunecha sisea vene pisivie majikari karokaha vehuna vwihanune nia sisea kime jarika orahone iraꞌatiji namahe iraꞌata vene jarika rene ꞌuraha ojura. ");
INSERT INTO mcq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ꞌEne ike mapoka sisea kaji oja vaji rena roa usevujara vejuꞌe ea sisea rejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu kwaa kajaho areꞌi kaivo Taia opuni kwai vaꞌana. Hu ijí vaꞌe sei pini ajime Hu ura ea pakaꞌavarono venana kaivo ijí tanuhuni ꞌunama paꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ꞌEꞌeme patetapaꞌa napara pipuni ꞌapaja ꞌuꞌua ꞌavena sisei ajiviꞌinaꞌomo Jesu henarena Huni unaꞌi mweꞌi ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Napara kajaho Jenitaru Sairopinisia ora. Hu jarima ijá ꞌwama Nuni ꞌapaja ꞌavena sisea ajiviꞌinakúne A ꞌavena sisea tasioma piꞌonamaha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ꞌEne Hu ijá ꞌwama Marako sesamai ꞌiruma vajihe pu ine túꞌavara. Sesamaa puni ꞌiruma pwina ꞌeka vaꞌe ꞌua vajihuna nihoꞌo areria paꞌana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Napara kajara Hu eha vene ijá ꞌwama Iꞌa. Natohwe ꞌUa ꞌuꞌo teporu hara sesamaa puni ꞌiruma túa ijura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hu ijá ꞌwama A ijá ꞌwarima jihunaꞌe oni ꞌapaja ꞌavena sisea ariha vaꞌana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Napara kajaho huni sei vaꞌi kavume ꞌapajaha ꞌavena sisea kaꞌene ajimajaho ariha vaꞌeme mamaa nenana. ");
INSERT INTO mcq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu kúꞌo ꞌurine kwaa iha Taia areꞌi kaivo Saitani ꞌeꞌune vaꞌe Karari Tikaparasi vaji vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ꞌEjume ea ꞌahopo ea ira hami paꞌwaraviꞌinijiꞌo ataa paꞌarejiꞌinijiꞌo aherame Jesuni vaꞌara. Pu ꞌejahae ijá ꞌwava Oni ija huni húmata ꞌahi ranama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ꞌEjume Jesura ea mapoka kajija irechamiꞌi kaivo ahema ꞌurina vaꞌe ani hijiꞌi Huni ijijino ea kajihuni ataa vajijino ronu ronu irechame ꞌee kúꞌo Huni cheriji ꞌene ea kajihuni mitari ꞌahi tanihana. ");
INSERT INTO mcq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ꞌEꞌikaꞌi Hu nia akúpi ꞌahi nirie siporua ꞌojiꞌi ijá ꞌwama Epata ꞌwamana. Epata ijihuni maijaho jaraꞌusaha. ");
INSERT INTO mcq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ꞌEꞌeme niꞌaha kwino huni ataa mitara jaraume marajume ira hami ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ꞌEjume Hu ira kisina ijá ꞌiama Nara iraka kaꞌene vejujaho ja ea paꞌwaraꞌavara. Hu ꞌwaramajaho pu ira tumaꞌi kaivo kehi kehi ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pu oja nihoꞌo hwaꞌusahaꞌeme ijá ꞌwava Hu uneunecha mapoka mapoka hami ve paranu. ꞌEne Hu ea ataa paꞌana venauꞌe vuꞌa hene ꞌee ira paꞌwaraviꞌinijija venauꞌe ira ꞌwaravu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kúꞌo ijipini ea mapoka vaꞌe ahuma hijara kaivo pura ꞌiruma kaꞌene ihunijaho paꞌana. ꞌEjume Jesu Huni tisaiporu ꞌumenaume rouma ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ea kaꞌene nú puꞌúmo hijukaho hiꞌeme naꞌia noꞌopisu paꞌarejara kaivo ꞌiruma kaꞌene pu ihunijaho paꞌajihunaꞌe Na punijihunaꞌe temuka apeju. ");
INSERT INTO mcq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ea ꞌahoꞌa kwaa jojori rena roajihuni hahi Na irechamie vaꞌavajaho pu vaꞌe vwamu toi matunave kwamasaꞌeja ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tisaiporuepo Jesu eha vena ijá ꞌwava Kwaakaho ꞌiruma paꞌane ꞌimejuri tinia paꞌajihunaꞌe nú ichihi ꞌiruma ꞌeke eakaho areri vajihe iꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu aporame ijá ꞌiama Puretia icharo navo? ꞌiavume pu ijá ꞌwava Iropu noꞌo navu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hu ea mapoka kajaho ꞌwaravume mweꞌi hijasavara. Hu puretia iropu noꞌo ꞌeke siporua ꞌone teimani ꞌwaꞌi kaivo ijiꞌa tuachame Huni tisaiporua vajihume pu ꞌeke ea mapoka kajaho ijá vajihapenojara. ");
INSERT INTO mcq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ꞌEjume kija kwinu kwino navaraꞌomo Hu ꞌeke ijí ꞌuꞌo siporua ꞌona teimani ꞌwaꞌi kaivo ꞌwaravume ꞌeke ea mapoka vajihara. ");
INSERT INTO mcq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ꞌEjume ea mapoka kajaho ina tea hianavumakiviꞌi puretia paijiꞌinijaho ꞌeka katija iropu noꞌo vejume ituꞌoꞌujume irechavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ꞌEnakaivo ea mapoka mapoka (4,000) ijaraꞌomo irechamiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ꞌEjumakaviꞌi Hu tisaiporuhwa puꞌúmo sisima ꞌahi ajime Taramanuta opuni kwai vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parasiapo roajime Jesui ninakarame vena kaꞌi ꞌahiume ijá ꞌwava A aacha pina akúpi ꞌahi najuha kavava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu oja areri pareꞌeme ijá ꞌiama Ea iviamaa urijakihija rakijihunaꞌe aacha pina veje kaꞌi ꞌahiuꞌe ꞌwarivu? Na nimaa nimaa ja ꞌwaravu Na aacha pina nihoꞌo ea kaꞌene iviamaa urijakihija panajahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hu pu irechamiꞌikaꞌi ꞌurine sisima ajime toa ropunaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ꞌEjume tisaiporu harava runamiꞌeme paꞌeki kaivo kwinuꞌwi apena sisima vaji ranama roara. ");
INSERT INTO mcq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu pu nahama ꞌwarama ijá ꞌiama Ja hami hena kaha. Parasi puni isitia ꞌee Heroti oni isitia hami kiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pu ꞌurine piraꞌarame apenojiꞌi ijá ꞌwava Hu ijaꞌina ꞌwarumu ijihuni maijaho nú puretia paꞌana rone ꞌwarumu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pura ꞌwava kaji Jesu henarena aporama ijá ꞌiama Ja irakijihunaꞌe nú puretia paꞌana ꞌwame piraꞌaravo? Na ꞌwaravujaho ꞌú ja pahejo? ꞌÚ ja hami pavwihajo? ꞌÚ joni oja majaa kaisina rena navo? ");
INSERT INTO mcq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ja nia rukina vo pakivo? Ja ataa rukina vo pahejo? Ja ira kaꞌene kivajaho pavwihajo? ");
INSERT INTO mcq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Vea kaꞌene Na puretia iropu tuachavumakame ea mapoka mapoka (5,000) ijajaho ja vi vwihajo? Ea puretia ijuma tuaꞌeme puretia pwinanaꞌa kaꞌene navajaho katija icharo vejume itusahare? ꞌiamana. ꞌEjume pu eha vena ijá ꞌwava Iropu ropu noꞌona ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Vea kaꞌene Na puretia iropu noꞌo tuachame vajihume ea mapoka mapoka (4,000) ijajaho katija icharo pwinana vejume itusahare? ꞌiamana. ꞌEjume pu eha vena ijá ꞌwava Iropu noꞌona ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ꞌEjume Hu ijá ꞌiama Ja majama pavwihaju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pu Petasaitai roꞌeme ea ꞌahopo ea pina nia supaviꞌinijaho apena roe ꞌejahae Huni iji ꞌunaꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ꞌEjume Jesu huni ija ꞌunavume apene ari uri vaꞌana. Hu cheri nia ꞌahi pisotiꞌi kaivo ija nia ꞌahi ranama ijá ꞌwama A uneunecha vikimo ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hu nia ahasirime nirie ijá ꞌwama Na ea kivujaho icha punaꞌi ꞌurahoju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu kúꞌo Huni ija ea kajihuni nia ꞌahi irechavume hu nia niriajaho marane ea nia hami kimana. ");
INSERT INTO mcq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ꞌEjume Hu huni sei vaꞌumakaviꞌi ijá ꞌwama A ara vaja pavahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu Huni tisaiporu puꞌúmo vaꞌe ara iha Sesaria Piripai vaꞌiro vaiꞌi Jesu Huni tisaiporu aporama ijá ꞌiama Ea pu vwihajujaho Na rarane ꞌwavure? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pu eha vena ijá ꞌwava Ea ꞌahopo vwihajujaho A Joni Papitisita ꞌwavuꞌe ꞌahopo vwihajujaho A Iraija ꞌwavuꞌe ꞌahopo vwihajujaho A poropeti pina rojura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ꞌEjume Jesu ijá ꞌiama ꞌEnakaivo ja vwihajujaho Na rarane? ꞌiamana. ꞌEjume Pita ijá ꞌwama A Kerisona ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ꞌEjume Jesu ijá ꞌiama Ja ijaho ea paꞌwaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesu Huni tisaiporu najaha ijá ꞌiama Ea maiꞌo Emaa Puni Harihijaho ꞌunama sisesa ani aniꞌina ꞌahahuna. ꞌEne emakina ꞌee pirisiti ꞌee Sikuraipijipo pataarohuna. ꞌEne pu Hu ꞌanae kwahuna kaivo naꞌia noꞌopisu paꞌareꞌeje kúꞌo ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hu samaumai najahumakame Pita Jesu ahema ro vaꞌe ꞌurarahana. ");
INSERT INTO mcq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hu taꞌarohe Pita túchahaꞌikaꞌi Huni tisaiporu kiviꞌi Pita ꞌuraraha ijá ꞌwama Setani, Nuni túnaꞌi ruvaꞌa! Oni vwihijaho Godoni vwiha pana kaivo ema puni vwiha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesu ea mapoka ꞌumenaume roe Huni tisaiporu puꞌúmo Huni nini ahuma hijumakiviꞌi Jesu ijá ꞌiama Ja ea pini Nuni túnaꞌi roꞌi veꞌamajaho huni ojijihuni urijaho makaꞌikaꞌi huni korosi tapane Nuni túnaꞌi ꞌararihie roꞌama. ");
INSERT INTO mcq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ea irara huni hiiji ori niꞌajaraꞌamajaho huni hiijaho ranahuna. ꞌEne ea irara huni hiiji Nunijihunaꞌe Godoni vuꞌa maa maiuꞌini jihunaꞌe ranamajaho hu huni hia ꞌunanahuna. ");
INSERT INTO mcq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ei pini uneunecha kaꞌene mweꞌa kakehunijaho huna reranaꞌeje hia nimaa nimaiji asinaꞌipisa hu mamaa iraka apejaꞌe? ");
INSERT INTO mcq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ꞌEne ea iraka vejujihunaꞌe majama hihuna asinahune? ");
INSERT INTO mcq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ea mapoka kaꞌene iviamaa iki hijukija Godi pataarohe ꞌee sisea ꞌunama ani ani vejiꞌi hiju. Ea irara Nunijihunaꞌe Na pataarorihe ꞌee Nuni ira pataaroꞌamajaho vea kaꞌene Ema Puni Harihijara ꞌona ojiꞌina arimaa ꞌee Amoni hanajiꞌinijiꞌi roꞌamajaho hu ꞌuꞌo pataarohuna. ");
INSERT INTO mcq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu ijá ꞌiama Na nimaa nimaa ꞌwaravu. Ea ꞌahoꞌa ike namijukija pu marakoꞌa Godira harurijiꞌi ꞌajohaꞌi roa kamarejaꞌe túnaꞌi kwamasahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vea iropu kwino paꞌareꞌeme Jesura Pitane Jemisine Jonine ijá aherama vaꞌe huriꞌi ajima vaꞌume pu Huni haha kavajaho taꞌarohe aniꞌina renana. ");
INSERT INTO mcq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Huni atehijija ahaniha sajasaꞌimaa rejara. Ei pini mweꞌi súhui sovuꞌe rejujaꞌina paꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ijaꞌina reꞌeme Iraijaꞌo Mosisiꞌo Jesu puꞌúmo hina vuꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ꞌurina Jesu ijá ꞌwama Najuhiꞌine mamaa vene nú ja puꞌúmo hiju. Nú joni sosura ara venahuna. Pina Ona vene pina Mosisi ona vene pina Iraija ona vehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pu tea junava jihunaꞌe hu puruva reꞌeme ijaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ꞌImitia satuꞌuriꞌeme ira ꞌimiti vaji ijá ꞌiama Ikaho Nuni Hariha Na Hu oja mahu. ꞌEnajihunaꞌe Huni ira heꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Niꞌaha kwinu ijá reꞌeme nia niriapenojajaho ea ꞌahoꞌa pakiꞌeme Jesu Huhusu kavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pu huriꞌi rene ariha roiꞌi Jesu ijá ꞌiama Ja iraka kaꞌene kavajaho ea paꞌwaraꞌavara kaivo Ema Puni Harihijara kwamareje kúꞌo ꞌuriꞌeje ijiꞌa ꞌwaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hura ꞌwaramajaho pu hena puni vaji irechavara kaivo pu hina kwama ꞌurihuni jihuni maijaho irake ꞌwamareje pu piraꞌaraviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pu Jesu apoma ijá ꞌwava Irakijihunaꞌe Sikuraipiepo ꞌwaravajaho Iraija marako rohuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu ijá ꞌiama Nimaa Iraija nimarako roareꞌe ꞌunama arira amairiu. Irakijihunaꞌe nitama Godoni heha ꞌahi venarena ijá ꞌiama Ema Puni Harihijaho siseꞌi ꞌahaareje Hu nihoꞌo ura parenahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ꞌEnakaivo Na ja ꞌwaravu Iraija niroana kaivo pu iraka siseꞌi ꞌahaꞌi vejajaho pu vejaraꞌomo heha ꞌahi ijaꞌina namu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesu ꞌurina tisaiporuhwa puni roarena ruꞌeꞌujiꞌi ea mapoka ahuma hiꞌeme kivume Sikuraipijijahija hina Jesuni tisaiporu epuꞌúmo ninakaraviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ꞌEꞌeme ea mapoka kajijahija Jesu kame tatoviꞌi ninuma vaꞌe ija apena ꞌajovara. ");
INSERT INTO mcq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesura Sikuraipijija aporama ijá ꞌiama Ja raka pu puꞌúmo ninakaraviꞌi hijo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ꞌEjume ea mapoka puni vaja kajino ei pini ijá ꞌwama Najuhiꞌina na nuni hariha Oni apena roujihuni maijaho ꞌavena sisea ajimarena ira paꞌarena jihunaꞌe apena routa. ");
INSERT INTO mcq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ichihi chihi ꞌavena sisea kajara ajimujaho ꞌunamapena mweꞌi ranavuꞌe irasapa ani rene upaja niiꞌi haha tanuka apeꞌasahe haha kaisimaꞌura renuna. Na Oni tisaiporujija ꞌwarave ꞌavena sisea ꞌararihihunijaho areri parenu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu ijá ꞌiama Ja iviama ike ꞌurina hijukija nihoꞌo panimaa rojiꞌina. ꞌÚ Na naꞌia icharu ja puꞌúmo hijo? Na naꞌia icharo masuani ja puꞌúmo hina apena route? Sesamaa kajaho ahema Nuni roha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ꞌEjume pu sesamaa kajaho aheme Huni roume ꞌavena kajara Jesu kamarena sesamaa kajaho apena piꞌonavume mweꞌi ꞌona kuchikuchiviꞌi ira sapa ani renana. ");
INSERT INTO mcq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu omaha apoma ijá ꞌwama Naꞌia icharo ijaꞌina renane? ꞌwamana. Omahi ijá ꞌwama Nitamatama sesamuꞌuru nijaꞌina renana. ");
INSERT INTO mcq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Naꞌia mapokaꞌe ꞌavena sisea kajarahara ꞌunama piꞌonavuꞌe veni rene ꞌee toi ꞌona kwaꞌamarono venuna. A areri rene ꞌee temukaꞌamajaho niꞌajúhe veje maraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu hu ijá ꞌwama A nimaa roꞌamajaho arerina. Ea irara nimaa roꞌamajaho uneunecha ani aniꞌina hununaa areri rehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ꞌEjume sesamaa kajihuni omijara ꞌurina ijá ꞌwama Na nimaa rojukúne na nimaa parojujaho niꞌajiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu kiꞌeme ea mapoka kaꞌene hina vuꞌa heja kajipuhipo nianaa apene ronuronu roajivuma kiviꞌi Jesu ꞌavena sisea kajaho ꞌurarahiꞌi ijá ꞌwama ꞌAvena sisea kaꞌene ira paꞌa ataa paꞌakera ariha vaꞌamana kaivo a túnaꞌi kúꞌo paꞌunama roꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ꞌEjume ꞌavena sisea kajaho kúꞌo emaavajiꞌi sesamaa kajaho apene piꞌonamana. Ijiꞌa ijá venarena areꞌi kaivo hu vaꞌana. Sesamaa kajaho kwamujaꞌina rejume ea mapoka ijá ꞌwava Hu nikwamana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesu sesamaa kajaho iji ꞌunamapena ꞌurijume ꞌurina naminana. ");
INSERT INTO mcq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ꞌEjume Jesu sei vaꞌe tisaiporuhwa puꞌúmo pupusu hijiꞌi pu Hu ijá ꞌwava Irakijihunaꞌe ꞌavena sisea kajaho nú areri patasiomahare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu eha vene ijá ꞌiama ꞌAvena sisea ijaꞌina siomahunijaho ꞌunama nikwinuꞌwi siporui reje siomahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pu kwaa kajaho areꞌi kaivo ꞌurina Karari vaji usema vaꞌara. Kwaa kaꞌene Hura hinuji erapo kame hehunijaho Hu ura parenana. ");
INSERT INTO mcq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ijihuni maijaho Hu tisaipuruhwaha najaharena Noinijá ꞌiama Emaa Puni Harihijaho ea ꞌahopo apene ea ꞌahoꞌa mihe pu Hu ꞌanaa kwamareje vea noꞌopisu mweꞌi vaji namareje kúꞌo ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ꞌEnakaivo Hu pu ꞌwarama jihuni maijaho pahenareja pu Hu apohunijaho junavume paapovara. ");
INSERT INTO mcq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pu ꞌurine Kapeniami vaꞌajime Hu sei vaji hiꞌi kaivo Hu pu aporama ijá ꞌiama Ja vwama toi roajaho iraka ꞌwamapena roare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ꞌEnakaivo pu eha paꞌwarava jihuni maijaho pu ꞌunama toi piraꞌaramareja Irara natohwana ꞌwavajihunaꞌe eha paꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ꞌEjume Jesu asuma hiꞌi kaivo tisaiporuhwaha iropu ropu noꞌo ꞌumenauma roumakiviꞌi ijá ꞌiama Ea irara amura reꞌi veꞌamajaho hu túchamai rehune ꞌee ꞌeka mapoki jihipuni pwea rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesu sesamaa pina ꞌwaravume puni unaꞌi namijumakaviꞌi Hu ija haha ꞌunaviꞌi ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ea irara sesamaa ijaꞌina Nuni iha ꞌahi niꞌajaꞌamajaho hu Na niꞌajihe avahuna. Ea irara Na apeniꞌamajaho hu nimaa Godi kaꞌene ranamiume Na roaji apeꞌena ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joni Jesu ijá ꞌwama Najuhiꞌine nú ea pina kavume hu Oni ihi ꞌurahiꞌi ꞌavena sisea siomahume kavara. Hu núni pwina paꞌajihunaꞌe nú hu roturahara. ");
INSERT INTO mcq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ꞌEnakaivo Jesu ijá ꞌiama Ja hu paroturaꞌavara. Ea irara Nuni ihi ꞌurahiꞌi mamaa veꞌamajaho hu túnaꞌi Nununaꞌi sisea paꞌwaraꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ea irara nú puꞌúmo paninakaramujaho hu núni ea. ");
INSERT INTO mcq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ea irara a Keriso onijihunaꞌe kapusi toa ꞌe maꞌamajaho Na nimaa nimaa ꞌwaravu hu huni ea paasinahuna. ");
INSERT INTO mcq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sesamaa pini Na nimaa roꞌeje ei pini sisei veje hu nimaa roꞌamaji areꞌamajaho maijaho ja aji apene muna ahisimaꞌuri huni oroi vevahame soha vaji piꞌonave oꞌipisa ja mamaa vejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Oni iji veje a Godoni ꞌunama pataaroꞌamajaho a ꞌuhunaꞌamana. Maijaho a ija rona kwinu apene hia mamaa apehuna kaivo ija noꞌoheꞌi reꞌamajaho veni renuni kwaa kaꞌene vena paꞌutarotisaviꞌini ijino vaꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ara kajaho hucha pakwamasahiꞌine ꞌee vena paꞌutarotisaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Oni mumori veje a Godoni ꞌunama pataaroꞌamajaho ꞌuhunaꞌamana. Maijaho a mumora kwinu apene hia mamaa apehuna kaivo mumora noꞌoheꞌi reꞌamajaho veni renuni kwaa kaꞌene vena paꞌutarotisaviꞌina ijino vaꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ara kajaho hucha pakwamasahiꞌine ꞌee vena paꞌutarotisaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Oni nii veje a Godoni ꞌunama pataaroꞌamajaho a oni nia ꞌanae supaꞌamana. Maijaho a nia kwinu apene hia mamaa apehuna kaivo nia noꞌoheꞌi reꞌamajaho veni rehuni kwaa kaꞌene vena paꞌutarotisaviꞌina ijino vaꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ara kajaho hucha pakwamasahiꞌine ꞌee vena paꞌutarotisaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Godi ea mapoka veni vena kihuna. ");
INSERT INTO mcq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Misa mamaa kaivo misa kajihuni vweijara paꞌareꞌipisa ꞌú nú icháꞌina veje kúꞌo vwea rejaꞌe? Emaa misa punaꞌi vwea rukina reꞌavajaho ja joni oja hami ꞌajohe ꞌunama maa vejajihunaꞌe ja ea mapoka puꞌúmo hami hihuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu kwaa kajaho areꞌi kaivo ꞌurina Jotani ꞌona karaꞌi Jutia vaꞌana. Ea mapoka kúꞌo nianaa Huni roume Hu najahu jaꞌinaꞌe najahana. ");
INSERT INTO mcq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ꞌEjume Parasipo Jesuni roe vena kaꞌi ꞌahiume apoma ijá ꞌwava Ei pini napara huna ranaꞌipisa areri rejaꞌe? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hu eha vene aporame ijá ꞌiama Mosisi hu ja raka vehuna ꞌwaramane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pu ijá ꞌwava Mosisira ꞌwarumajaho ea napara ranahuna asura ve maꞌi kaivo ranave vahunaꞌe ꞌwarumana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ꞌEnakaivo Jesu ijá ꞌiama Hu nitama heha ꞌahi ijaꞌina ꞌwarama jihuni maijaho joni oja kisimaꞌuri jihunaꞌe hu venana. ");
INSERT INTO mcq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ꞌEnakaivo nitama anejijaho Godira uneunecha mapoka vene ꞌee parua vene ꞌee napara venana. ");
INSERT INTO mcq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Ijihuni hahi parui napara ꞌwaꞌamajaho opwaha irechamiꞌi kaivo pu noꞌo nikwino rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Godi raka kaꞌene ihenamiajaho ea pina paturaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pu kúꞌo sei vaji vaꞌajimareja huni tisaiporu ijí vuꞌa kajaho apovara. ");
INSERT INTO mcq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ꞌEjume Hu ijá ꞌiama Parua irara huni napara ranaꞌi kaivo napara pini ꞌwaꞌamajaho hu huni napara kaꞌene amuriji nihoꞌo siseꞌi ꞌahaa avahuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Napara irara huni parua ranaꞌi kaivo parua pina veꞌamajaho hu nihoꞌo siseꞌi ꞌahaa avahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ꞌEjume ea ꞌahoꞌa sesamaa ꞌeka Jesuni roume Hu iji ꞌunirame merajiꞌiro venana kaivo tisaiporuepo ea kajija ꞌurarahara. ");
INSERT INTO mcq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesu kimarena nihoꞌo sevuma ijá ꞌiama Sesamaa paroturiꞌavara kaivo makiꞌeje Nuni roꞌavara. Ijihuni maijaho Godoni arijaho ea kaꞌene sesamaa punaꞌi vejujihipuni ara. ");
INSERT INTO mcq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na nimaa ja ꞌwaravo. Ea irara Godoni ariji sesamaa punaꞌi paapeꞌamajaho hu ijaho pavahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ꞌEnarena Hu sesamaa kajaho mwachame Huni ija puni haha ꞌahi irechaviꞌi merajihana. ");
INSERT INTO mcq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu vaꞌi ꞌahauma vaꞌeme ea pina ninuma roajino Huni unaꞌi nitupari saꞌi kaivo apoma ijá ꞌwama Najuhiꞌina Mamaaꞌe na icháꞌinaꞌe vene majama hihunijaho apeꞌejo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu ijá ꞌwama Irakijihunaꞌe a Na mamaa ꞌwimo? Eaka mapokakaho mamaa pana kaivo nikwino Godira mamaa. ");
INSERT INTO mcq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A Godoni tamana nihenuna. A ea paꞌanaa kwaꞌamana ꞌee a napara paturaꞌamana. A nesa paapeꞌamana. A ea pina panamaꞌamana. Ohuna omuna ijihipuni hura veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ꞌEjume hu ijá ꞌwama Najuhiꞌine na nitama sesamuꞌuru rene tamana kajaho hami venapena routa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ꞌEnakaivo Jesu hu kamajaho Hu oja mahe ijá ꞌwama A unenuꞌu pina kwino maiꞌo areri paꞌana. A vaꞌe oni uneunecha mapoka ꞌeke ꞌimenarejaꞌe monia ona ꞌeke ea uneunecha paꞌaji vajihakame oni eha maa akúpi ꞌahi naꞌeje roe Na ꞌararihiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hu ijí henajaho nihoꞌo temume oja turaꞌi ꞌahaꞌeme vaꞌana. Ijihuni maijaho hu uneunecha mapoka rukina. ");
INSERT INTO mcq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ꞌEꞌeme Jesu niriapenojiꞌi Huni tisaiporua kima ijá ꞌiama Ea kaꞌene uneunecha mapoka rukina reꞌavajihunaꞌe pu Godoni ari vahuna kisina rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesu ꞌwaravume Huni tisaiporua hena oja hwaꞌusahana. ꞌEjume Jesu kúꞌo eha vene pu ijá ꞌiama Sesahu Nune ea pu nimaa rohuna kaivo pu uneunecha mapoka rukina reꞌavajihunaꞌe pu Godoni ari vahuna kisina rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maha nitirua titi aruꞌipisa areri rejaꞌa kaivo ea hu nimaa rohuna kaivo hu uneunecha mapoka rukina reꞌamajihunaꞌe hu Godoni ari vahuna kisina rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pu ijí henareja oja nihoꞌo hianaꞌeme ijá ꞌwava ꞌÚ Godi ea irá niꞌajaꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu pu kiviꞌi ijá ꞌiama Emapo areri vehuna paꞌana kaivo Godiho arerina. Godira areri uneunecha ve paranuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita Hu ijá ꞌwama Ike hena nú uneunecha mapoka irechaꞌi kaivo A ꞌararihae roara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu ijá ꞌiama Na nimaa ja ꞌwaravo. Nuna ꞌee Godoni vuꞌijihunaꞌe ei pini huni mweꞌa ara omaha oaha pokaha ꞌuꞌuaha maꞌinaha sesahwaha irechamiꞌamajaho ");
INSERT INTO mcq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hu túnaꞌi areri mweꞌa mapoka mapoka ara mapoka mapoka oma mapoka mapoka oha mapoka mapoka poka mapoka mapoka ꞌuꞌua mapoka mapoka maꞌina mapoka mapoka sesamaa mapoka mapoka rehuna. Ea hu siseꞌi ꞌahaꞌeja kaivo hu Godoni ari vaꞌe majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ꞌEnakaivo ea irahipo urasaꞌavajaho pu túchamai rehuna kaivo ea irahipo túchamai reꞌavajaho pu urasahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pu Jerusaremi vaꞌiro vaꞌeme Jesu urana vaꞌeme Huni tisaiporu túnaꞌi vaꞌajimareja oja hianamana. ꞌEe ea kaꞌene pu ꞌararihia vaꞌajaho tea junamana. ꞌEne Hu kúꞌo ea iropu ropu noꞌo aherame ani ro vaꞌe iraka kaꞌene Hua rehunijaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hu ijá ꞌiama Ja heha! Nú Jerusaremi vaꞌajive ea ꞌahopo Ema Puni Harihijaho apene pirisiti mamaꞌina ꞌee Sikuraipi ijihi mihe pu apena ꞌanae kwahuna ꞌwaꞌikaꞌi pu Jenitaru mihuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pu Hu matahe chera pisotie hisi hijahe ꞌanae kwahuna kaivo vea noꞌopisu mweꞌi vaji namareje ijiꞌa kúꞌo ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ꞌEjume Jemisiꞌo Joniꞌo Sepati oni harihijaꞌomo ijí pu roajime Jesu ijá ꞌwava Najuhiꞌina nú unenuꞌu pina rakaꞌe A ꞌwaraꞌavajaho A veꞌamana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ꞌEjume Hu ijá ꞌiama Ja ura iraka Na jona venaꞌejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pu ijá ꞌwava Naꞌia pini a ea mapoka ꞌajohaꞌamajino nú ea pina Oni ija manaꞌinijaꞌi hije ꞌee ei pini anaꞌinijaꞌi hiꞌejakúne ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ꞌEnakaivo Jesu pu ijá ꞌiama Oneka kaꞌene ja Na ꞌwarivu kajihuni maijaho ja paheju. ꞌÚ ja areri Na kapusi toa kaꞌene ihunijaho iꞌeja? ꞌEne Na toa apúsamie ꞌuriujaꞌinaꞌe ja ꞌuꞌo toi samae ꞌuriꞌeja? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pu ijá ꞌwava Nú arerina ꞌwavara. Jesu ijá ꞌiama Nara kapusi toa kaꞌene ihunijaho ja nimaa ihuna. ꞌEne ꞌuꞌo Na toi apúsamie ꞌurihuni jaꞌinaꞌe ja nimaa toi samae ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ꞌEnakaivo ea pina Nuni manaꞌini hije ꞌee ea pina Nuni anaꞌini hihunaka ꞌwarivujaho Nara vajihuna pana kaivo emaa punaꞌe iji pijiha amairie irechavu navu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ꞌEjume ea iropu ropu ijí henareja pu Jemisi Joni punaꞌi sena vena ꞌurarahara. ");
INSERT INTO mcq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ꞌEjume Jesu ꞌumenaume pu rouma ijá ꞌiama Ja niheju. Jenitaru ea mamaꞌina rejajaho pu majikari ꞌajoahura. Puni ea mamaꞌina ꞌwaravuꞌe ea mapoka puni ira hena vejura. ");
INSERT INTO mcq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ꞌEnakaivo ja ijaꞌina pana kaivo ea irara ura joni natohwa reꞌi veꞌamajaho hu joni pwea reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ea irara uraꞌi veꞌamajaho hu ea mapoka puni pwea reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ema Puni Harihijara roajaho ea mapoka Huni pwea pareꞌavarono roana kaivo Hu puni pwea reꞌi ꞌahauma roana. Hu Huni hia ea mapokaꞌe mihana. Areri emaa ꞌimenaana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ꞌEjume pu Jeriko ro ꞌeꞌune usema vaꞌiro vaiꞌi Jesuho Huni tisaiporu ꞌee ea mapoka ꞌee Patimeasi nia supaviꞌina kaꞌene Timiasi oni harihaꞌomo vwama rori jariraviꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hu hejume Jesu Nasareti oraꞌomo roume hu ijí heꞌikaꞌi ijá ꞌumena A Teviti Oni Hariha A na temukaꞌamana ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pu hu ijá ꞌumeja Irunoꞌa ꞌarema ꞌumejara kaivo hu nihoꞌo pasonananaviꞌi ijá ꞌumena Teviti Oni Harihaꞌomo A na numiriꞌamana ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu henarena masuani namijiꞌi ijá ꞌiama ꞌUmeje roꞌama ꞌiamana. ꞌEjume pu ea nia supaviꞌina kajaho ijá ꞌumeja Teamanaꞌeje ꞌurina Hu a ꞌumenaukúne ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ꞌEjume hu marako huni ateha irecha ꞌoꞌi kaivo ꞌurina Jesuni roana. ");
INSERT INTO mcq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu hu apoma ijá ꞌwama A ura rakaꞌe Na vetaꞌejo? ꞌwamana. ꞌEjume ea nia supaviꞌinijara ijá ꞌwama Najuhiꞌina A veje na kúꞌo nia niriuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu hu ijá ꞌwama A nimaa ronajara vejuꞌe maranaukúna vaꞌa ꞌwamana. ꞌEꞌeme niꞌaha kwino huni nia marajume hu Jesuꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pu Jerusaremi rori roe Petapejeꞌo Petaniꞌo puni rori huriꞌa Arivi useme Jesu Huni tisaiporu noꞌoheꞌi irechamiuma vaꞌumakiviꞌi Hu ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ja vaꞌe ara pina kamaꞌaji useviꞌi kave tonikia ꞌuꞌua ea ijihuni toi pahijiꞌina kaꞌeje aji iꞌivananave namija kaꞌavajinakúne rasamapene roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ꞌEꞌeje ea pina ja aporamareje ijá ꞌiava Ja rakijihunaꞌe tonikia ꞌuꞌua apejo? ꞌiꞌamajaho ja ijá ꞌwaꞌavara Nú apena vaꞌe núni Natohwijara unenuꞌu pina venarejaꞌe ijiꞌa kúꞌo marako ranave roꞌena ꞌwaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ꞌEjume pu noꞌo vaiꞌi kavume tonikia ꞌuꞌua vwicha rori iꞌivananava jaho kamareja rasavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ꞌEꞌeme ea ꞌahoꞌa kaꞌene namija kajipo ijá ꞌiava Ja noꞌo raka vene tonikia ꞌuꞌua kajaho rasavo? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ꞌEjume Jesura raka kaꞌene ꞌwaramajaho pu ijá ꞌwaravume pu makiꞌeme pu noꞌo apena vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ꞌEjume pu tonikia ꞌuꞌua apene Jesuni roume pu puni atehiji tonikia ꞌahi irechame Jesu ijihuni ꞌahi hinana. ");
INSERT INTO mcq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ꞌEꞌeme ea mapoka kajipuhipo puni ateha ꞌee icha tuame ꞌunama kajino tahitavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ea mapoka urasaha vaꞌume ea ꞌahoꞌa túnaꞌi vaꞌa kajipuhipo mwasiriviꞌi ijá ꞌumeja Hosana A Godoni iha ꞌahi roajihunaꞌe Hu A merajahu. ");
INSERT INTO mcq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nuni oma Tevitira kwaa ara ꞌajohuna kaꞌene rohunijaho Godi merajaho Hosana nihoꞌo ichutoa mai hinu ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu roe Jerusaremi Temiporu ajimarena vea nipaꞌarena jihunaꞌe maniriapenonu vaꞌume ꞌurine Huni tisaiporua iropu ropu noꞌo aherama Petani vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","ꞌEnaꞌomo súꞌo Petani rena ꞌunama roajiꞌeme ꞌunama toi Hu matumana. Hu niriꞌi kamajaho mataka kamarena Hu vwihanajaho ꞌina ijí navu roꞌi kaivo vaiꞌi kamajaho ꞌina pakiꞌeme aꞌaru rena namana. Ijihuni maijaho mataka kajara ꞌina rehuni vea pana. ");
INSERT INTO mcq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ꞌEjume Hu icha kajaho ijá ꞌwama Ea kúꞌo oni ꞌina paihuna ꞌwamana. Hu ijá ꞌwaravume Huni tisaiporu hejara. ");
INSERT INTO mcq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pu Jerusaremi vaꞌajimareja Jesu Temiporu aruma vaiꞌi kivume ea mapoka hina ꞌiruma ꞌimejiꞌi hijumakiviꞌi Hu vaꞌaji ea monia senisu vejiꞌini jihipuni ꞌaiju ꞌunama pitaꞌarohe ea uka ꞌimejiꞌinijijahija ꞌee ea mapoka arukunie ꞌararihiume pitapa juhahara. ");
INSERT INTO mcq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hu ea ꞌahoꞌa Temiporu vaja uneunecha ꞌahoꞌa paꞌeke roe aruma vahunaꞌe Hu tanumana. ");
INSERT INTO mcq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hu ea mapoka najahiꞌi ijá ꞌiama Godira heha vaji ijá ꞌúma Nuni seijaho eaka mapokijihipo Nuni siporua ꞌohuni sea kaivo ja vejume seakaho nesapejuri sea renana ꞌúmana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ꞌEjume Sikuraipia ꞌee pirisitia mamaꞌinapo Jesu ꞌanaa kwahuni ꞌunamiji savara. Pu Jesu ꞌanaa kwahuna kaivo ea mapoka Hu najahuꞌe Huni túnaꞌi vaꞌujihunaꞌe pu Hu juhavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Vea nusireꞌeme pu Jerusaremi arema vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Súꞌu ꞌurine vaiꞌi kavume mataka sarana paranana. ");
INSERT INTO mcq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ꞌEjume Pita kama vwihana ijá ꞌwama Najuhiꞌine kare kama. Mataka kaꞌene Ara sirimajaho nihoꞌo saranana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu ijá ꞌiama Ja Godi nimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nimaa Na ja ꞌwaravu Ea irara huriꞌa kare ijá ꞌwaꞌamajaho ꞌauma vaꞌe sohi ꞌona ꞌwaꞌi kaivo huni oja vaja papuruva retiꞌi kaivo nimaa roꞌamajaho iraka kaꞌene hura ꞌwaramujaho rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ijihuni hahi Na ja ꞌwaravu Iraka ja siporua ꞌona ꞌwaravajaho nimaa rojiꞌi nú niꞌeku rojakamareje ja ꞌekaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Vea kaꞌene a ꞌurina siporua ꞌoꞌamajaho ara ea ꞌahoa siseꞌi ꞌahiajaho vwihania arevakame oni Oma kaꞌene akúpi ꞌahi hinujaho oni sisea vwihana areꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ꞌEnakaivo erapo ja siseꞌi ꞌahie ja puni sisea pavwihana areꞌavajaho joni Oma kaꞌene akúpi ꞌahi hinuji ꞌuꞌo joni sisea pavwihania arehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ꞌEjume pu kúꞌo ꞌuname Jerusaremi roajime Jesu Temiporu vaji ꞌurahoꞌeme pirisiti mamaꞌina ꞌee Sikuraipi ꞌee emaipo niꞌaha kwino Huni roajivara. ");
INSERT INTO mcq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Pu Hu apoma ijá ꞌwava Irara ꞌwaravume ijaꞌina venane ꞌee Irara harura mahume A ijaꞌina venane? ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu pu eha ijá ꞌiama Na ja aporaꞌejukúna ja eha ꞌwarivakame ijiꞌa Na harura irakijino vejujaho Na ja ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Irara ꞌwaravume Joniho ea toi samauma ꞌurijare? Godira ꞌwaramana ꞌaho ei pini ꞌwaramane? Ja eha ꞌwariha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pu hina ira kukari ijá ꞌwava Nú akúpi ꞌahi rena roana ꞌwaꞌavajaho Hu ijá ꞌúhune Irakijihunaꞌe ja hu panimaa vetiare? ꞌúꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ꞌEnakaivo nú ema puni rena roana ꞌwaꞌeja vo pu ea mapokaꞌe juhavara. Ijihuni maijaho ea mapokaꞌe vwihajujaho Joniho nimaaꞌe poropetia. ");
INSERT INTO mcq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ꞌEne pu eha vene Jesuho ijá ꞌwava Nú puruva retúu ꞌwavara. ꞌEjume Jesura pu ijá ꞌiama Ijinaꞌomo Na ꞌuꞌo harura iraki apene uneunechake vejujaho paꞌwaraꞌeju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hu aneja vene pu haa ꞌwarame ijá ꞌiama Ei pini juara menarena ajina ꞌone vera irame núꞌúha vene hu ea ꞌahoꞌa irechamiume juara kajaho ꞌajoha hiꞌeme hu kwaa pini vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ꞌIruma kajara maranani veijino huni pwea ranavume vaꞌe ajina ꞌekaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ꞌEjume ea kaꞌene juara kaji ꞌajohujipo ꞌurina ꞌanau vaꞌo piranavume maisu vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Vu kúꞌo huni pwea pina ranavume vaꞌume ea kaꞌene juara kaji ꞌajoha kajipo muni ꞌeka huni húmati ꞌahi ꞌanaume hijaꞌaravumakaviꞌi pu apena siseꞌi ꞌahau vaꞌume piranavume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hu pina ranavume pu ꞌanauma kwamana. ꞌEjume hu vu kúꞌo pwehwaha ꞌahoꞌa irechamiume vaꞌume pu ꞌahoꞌa hijihaꞌe ꞌee ꞌahoꞌa ꞌaniuma kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ꞌEꞌeme hu ea kwino ranave vahuna hinana. Huni hariha kaꞌene nihoꞌo oja mahiꞌinijina. Hu túchamaijaho raname ijá ꞌiama Pu nuni hariha kehuni hura veꞌeja ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ꞌEnakaivo ea kaꞌene juara kaji ꞌajohujipo ꞌwamapenojiꞌi ijá ꞌwava Ea kaꞌene kahe rou kahehunakúne roe ꞌanae kwaꞌeje núni aachiaꞌe reꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ꞌEjume pu hu ꞌanauma kwavume piꞌonavume vera hanaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ꞌEjumakame juara anesura kajaho icháꞌina veꞌena? Hu roe ea kaꞌene huni juara ꞌajohiꞌina kajija ꞌanie kwamasaꞌeje hu ea ꞌahoꞌa juara kajaho mihuna. ");
INSERT INTO mcq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ja nihejara Godoni heha vaji ijá ꞌiama Ea kaꞌene ara vejiꞌinijipo kuteja kaꞌene piꞌonavajara ara kajihuni kúrúti kuteja kaji rena naminana. ");
INSERT INTO mcq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ikaho Natohwi jihuni rena roajihunaꞌe nú kivujaho mavarasaꞌina rejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hura haa kaꞌene puaꞌe ronarena ꞌwaramaji ꞌwaramana. Pu ura henareja Hua apeꞌirono savara kaivo pu emaaꞌe juhamareja arema vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pu Parasi ꞌee Heroti oni pwehijijihi puꞌúmo irechamiume vaꞌe Jesu ꞌwaraviꞌi pisiviꞌi ꞌahiuma vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pu vaꞌajimareja ijá ꞌwava Najuhiꞌine nú niheju A nimaa nimaa. A eakaho natohwa ꞌee eakaho maꞌuꞌua ijaꞌina paronu jihunaꞌe A ea mapoka areri kwinuꞌwi kaivo A Godoni ꞌunamaru arira najuhuna. Nú unenuꞌu pina aporavu. ꞌÚ nú Sisa takisi vajaꞌavajaho areri reꞌena ꞌaho pane? ");
INSERT INTO mcq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ꞌÚ nú veꞌeja ꞌaho nú paveꞌeja? ꞌwavara. ꞌEnakaivo Hu henajaho pu iraꞌata vejuma henarena ijá ꞌiama Ja rakijihunaꞌe Na vena kivo? Monia oma kwino miha Na kavuma ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ꞌEjume pu mahume Hu moni kama ijá ꞌiama Ikaho irahuni pikisaꞌe ꞌee asuri namo? ꞌiamana. ꞌEjume pu Hu ijá ꞌwava Sisa ona ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ꞌEjume Jesu ijá ꞌiama Sisa oni uneunechijaho Sisa vajaha ꞌee Godoni uneunechijaho Godi vajaha ꞌiavume pu ijí hene oja hwaꞌusunahana. ");
INSERT INTO mcq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ꞌEne Sajusi ꞌahopo ea kaꞌene kwamasahiꞌinijipo kúꞌo ꞌurijujaho panimaa rojura. Jesu apoma ijá ꞌwava ");
INSERT INTO mcq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Najuhiꞌine Mosisira vuꞌa pina heha ꞌahi vena ijá ꞌúma Ei pini napara ꞌwahe naparahijaho amuja paveꞌeje hu kwaꞌamajaho ꞌuꞌuahi aheva kamareje ijara pokahoni hariha nahehuna ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nitama ea pipuni hariha iropune noꞌonaꞌomo pokijara napara ꞌwahana kaivo huni napara amuja paveꞌeme hu kwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ꞌEjume huni nijahijara ahevume amuja paveꞌeme hu ꞌuꞌo kwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ꞌEjume ijihuni nijahijara ahevume amuja paveꞌeme hu ꞌuꞌo kwamana. Ijaꞌina vena apena vaꞌo vaꞌume túchamai jara ahevume amuja paveꞌeme parua kajaho kwavume napari ijí ꞌuꞌo kwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vea kaꞌene ea mapoka kwamasahajipo kúꞌo ꞌuriꞌavajaho hu irahuni napara reꞌena? Ijihuni maijaho ea iropune noꞌo hu ꞌwahara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesura eha vena ijá ꞌiama Ja pahejujihunaꞌe Godoni ira pahene ꞌee Godoni harura ꞌuꞌo paheju. ");
INSERT INTO mcq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vea kaꞌene kwamasahiꞌina kajipo kúꞌo ꞌuriꞌavajaho napara pasahuna kaivo areri Godoni ꞌona ojiꞌinapo akúpa ꞌahi hijujaꞌinaꞌe hihuna. ");
INSERT INTO mcq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ea kaꞌene kwamasahiꞌinijipo kúꞌo ꞌurihuni jihuni vuꞌa kaꞌene Mosisi oni heha vaji vejajaho patahara raka? Vuꞌa kaꞌene icha renani vaji Godira Mosisi ijá ꞌwama Na Eparahami oni Godi ꞌee Aisiki oni Godi ꞌee Jekapi oni Godi ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hu Godi kaꞌene kwaviꞌinijaho pana kaivo Hu Godi kaꞌene maiꞌo hijiꞌini jihipuna. Ja vuꞌa iraꞌata ꞌwavura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sikuraipi kwino ro hiꞌeme ea mapoka kajipo vuꞌa kaꞌene Jesu ꞌwaravajaho hu henana. ꞌEꞌeme Jesu pu eha hami ꞌwaravume hu Jesu aporama ijá ꞌwama Godoni tamana mapokijaho ichara natohwe? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu eha vene ijá ꞌwama Godoni tamana natohwijaho ikena. Isureri ora ja hami heha. Núni Godijaho Natohwe ꞌee nikwinuꞌwina. ");
INSERT INTO mcq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Joni Natohwa Godiho ꞌavenijiꞌi mahoꞌo oja mahe ꞌee vwihajiꞌi mahoꞌo oja mahe ꞌee harurijiꞌi mahoꞌo oja mahe ꞌee ojijiꞌi mahoꞌo oja maꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ikaho ijihuni nijahijina. Ja ojono oja maꞌaravu jaꞌinaꞌe joni rori ea kaꞌene hijujija ꞌuꞌo oja miꞌavara. Tamana ꞌahoꞌa ike noꞌoheꞌi ikija paasitahara ꞌwamana ");
INSERT INTO mcq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ꞌEjume Sikuraipijara Jesu ijá ꞌwama Najuhiꞌine ijaho nimaa nimaa ꞌwarimu. Oni vuꞌa ariramaa. Godi kwinuna kaivo pina pana Hu Huhusuna. ");
INSERT INTO mcq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ꞌEjume ja Hu ojijiꞌi mahoꞌo oja mahe ꞌee joni vwihajiꞌi mahoꞌo oja mahe ꞌee harurijiꞌi mahoꞌo oja mahe ꞌee ea kaꞌene oni rori hijujija oja mihe areri ja ojono oja maꞌaravu jaꞌina. Ijipo swasa kaꞌene ꞌeka roe swasa vejujaho mahoꞌo asitahana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu kamajaho hu eha arira vene Huni vuꞌa arira hejuma kamarena Hu ijá ꞌwama A kwaa jora pahinu kaivo a Godoni ara rori hinu ꞌwamana. ꞌEjume ijá rene ea ꞌahoꞌa kúꞌo paapovara. ");
INSERT INTO mcq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ꞌEnakaivo Jesu Temiporu vaji hina najaha ijá ꞌiama Rakijihunaꞌe Sikuraipi Kerisoho Teviti oni Hariha ꞌwavure? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Teviti oriꞌini Godoni ꞌAvena vaji ika ꞌwaramana Natohwijara nuni Natohwiji ijá ꞌwama A Nuni ija manaꞌinikaꞌi asuma hiꞌeje Na Oni nanaꞌejiꞌina Oni mumora hari irechavuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tevitira huhusu Hu Natohwa ꞌiamana. ꞌEnaꞌomo ꞌunama icháꞌinijino Hu Teviti oni Harihe? ꞌiamana. Hu ꞌwaravume ea mapoka hena teamanavara. ");
INSERT INTO mcq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu najahiꞌi ijá ꞌiama Ja Sikuraipi hami kiꞌavara. Pu ura emaapo kime puni hura vene ꞌajoraꞌavarono ateha jojora same maketi vaꞌe ꞌurahojura. ");
INSERT INTO mcq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ꞌEne pu ura Sinakoku vaji unaꞌi asuma hiꞌi ꞌahie ꞌee erapo ahaja ijuri veijino tinia mamaꞌinijino hihuna ura renaura. ");
INSERT INTO mcq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pu amuna pisimisame puni ara ꞌeke ꞌee emaapo kiꞌavarono siporua jojora ꞌojuraꞌomo ea ijá kajija túnaꞌi nihoꞌo eha sisemaa ꞌekahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu vaꞌe katua savuri tevua rori ijí hina ea mapokapo monia kaꞌene savaji kiviꞌi hiꞌeme ea kaꞌene monia puna ani rejiꞌina kajipo puni monia mapoka ꞌeka roe savara. ");
INSERT INTO mcq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ꞌEꞌeme amuna kaꞌene uneunecha paꞌamaa kaivo monia sahura oma noꞌo maꞌuꞌumai areri monia toia oma noꞌo erusamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ꞌEjume Jesu Huni tisaiporu ꞌumenaume pu Huni roume Hu ijá ꞌiama Nimaa Na ja ꞌwaravu amuna kajarahara uneunecha paꞌamai monia eaka mapoka kajipo roe katua kaꞌene savajaho asita ranamana. ");
INSERT INTO mcq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ea pu monia mapoka vajahajihuni maijaho pu monia rukini jihuni hahi avajara kaivo amuna kajaho uneunecha paꞌajihunaꞌe huna kaꞌene areri navuji samana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu Temiporu rena va ꞌeꞌuꞌeme Huni tisaiporu kwinu ijá ꞌwama Najuhiꞌine ike kiama! Muna ikijahija ꞌee sea ikijahija nihoꞌo mavarasaꞌina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ꞌEjume Jesu ijá ꞌwama Sea kaꞌene kimukaho túnaꞌi tiraꞌusaha paraꞌeje kutejaru namiꞌeja ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesu vaꞌe huriꞌa Arivi Temiporu ropunaꞌijaꞌi Pitaho Jemisiho Joniho Enituruho ijá pu puꞌúmo hijiꞌi hemi apoma ijá ꞌwava ");
INSERT INTO mcq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Vea raki uneunechakija ijaꞌina reꞌeja? A aacha pina najuꞌirakúne nú ijí kaꞌavajaho sisea kaꞌene rehunaka ꞌwarumajaho nituꞌu renu ꞌwaꞌejakúnina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","ꞌEjume Jesu ijá ꞌiama Ja hami kiꞌavara. Ea ꞌahopo pisimia veꞌejakúne ꞌee ea ꞌahopo Nuni ihiji ꞌurahiꞌi Na Jesuna iꞌi kaivo ea mapoka pisimihuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Vea kaꞌene ja ajira vehuna hene ꞌee erapo ajira vehuni pinana ꞌwarava heꞌavajaho oja pahianaꞌavara. Ajira rena vuꞌa ani ani reꞌena kaivo maiꞌo ꞌurijaho paroa tuꞌu rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwakwa mapokakija maiꞌo araꞌeja ꞌee ararakija maiꞌo araꞌeja. Ara kwaa ꞌahoꞌa mwevarivura roe ꞌee ora vea reꞌena. Ike uneunechakija ea hianahuni jihuni aneja. ");
INSERT INTO mcq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ꞌEnakaivo ja ojono hami ꞌajoꞌavara. Ijihuni maijaho pu ꞌeka vaꞌe hirisima puni nini vaꞌe ꞌee Sinakoku majikari hijihahuna. Ja Nuni eijihunaꞌe pu ja kamatia kaꞌene ꞌajohiꞌini jihipuni nini ꞌeka vaꞌakiviꞌi raka kaꞌene ja kima hejujaho pu najahuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ꞌEnakúne Godoni vuꞌa maiuꞌina kwaa ara mapokakino najaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pu ja ꞌeke ꞌotua veꞌiro vaꞌavajaho ja vaꞌe uné raka kaꞌene ꞌwarahuniji pavwihaꞌavara. ꞌEnakaivo ja ꞌotua veꞌiro veꞌeje vuꞌa pina vwihaꞌavajaho ja pavwihahuna kaivo Godoni ꞌAveni vajiꞌenakúne ꞌwaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Popwapo ꞌwarave erapo ꞌuꞌuhwaha ꞌanie kwamasahe omahwapo ꞌwarave erapo sesahwaha ꞌanie kwamasahe sesahwapo ꞌwarave erapo opwaha ꞌanie kwamasahuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ja Nuni eijihunaꞌe ea mapoka ja nihoꞌo kiꞌavajaho senahuna. ꞌEnakaivo ea irara ija kisi ꞌunama vaꞌe uri ꞌeꞌuꞌamajaho hu marahuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Vei pini Sinakoku nihoꞌo sisemaa pakaviꞌinijara tinia kaꞌene panamihunijine namija kaꞌavajaho ea kaꞌene Jutia hiꞌavajaho vekaji niꞌaha kwino juhaha huriꞌi ꞌahi vaꞌavara. Ijihuni hahi ea irara ike taꞌamajaho hami vwihaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ei pini atahuri hiꞌamajaho hu paariha vaꞌe sei vaji uneunecha paꞌekaꞌamana kaivo aseha vaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ei pini juasiꞌi hiꞌamaji ꞌuꞌo paꞌunama vaꞌe ari huni ateha ꞌekaꞌamana kaivo aseꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ꞌEnakaivo vea kaji ea kaꞌene hariꞌina ꞌee hariha musa ijiꞌinijija nihoꞌo pivusahuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ꞌEnakaivo siporua ꞌoꞌirakúne siseakaho atuata veijaho pareꞌamana. ");
INSERT INTO mcq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vea kajino sisemaa kaꞌene rehunijaho nitama Godira mweꞌa ꞌee akúpa vejume hinapena roajino sisea ijaꞌina parenajara rehuna. ꞌEnareje ijiꞌa túnaꞌa kúꞌo ijaꞌina parehuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Natohwijara vea kaji patuꞌua veꞌamajaho ei pina maiꞌo pahihuna. Ea kaꞌene Hura iji pijihajihi puni hahi Hu veje vea kajaho tuꞌu rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ei pini ja ijá ꞌiꞌamajaho Keka! Keriso ikena karena ꞌiꞌamajaho ja nihoꞌo panimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Túnaꞌi ea ꞌahopo iraꞌatijino na Kerisona ꞌiave vu ea ꞌahopo iraꞌatijino na poropeti ꞌiahuna. Pu ijaꞌina venareje aacha mapoka veje ea mapoka oja hianava kiviꞌi pisivie ea mapoka nimaa rohuna. Pu ea kaꞌene Hura iji pijihajihija pisivihuna vo areri parehuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hami heha! Maiꞌo raka kaꞌene rehunijaho Na niꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sisemaa kajaho paꞌareꞌeje vea naꞌive ꞌee masapa pahanahuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","China jaheusunahe arihe akúpa puni harurijihija ꞌunirama usihuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ꞌEꞌeje pu Emaa Puni Hariha kaꞌeje Hu ꞌimitia vaji harura niꞌimaꞌura nihoꞌo hanana paraꞌeje rohuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ijaꞌina veꞌeje Hu Huni ꞌona ojiꞌinijihija irechamia kamareje pu roe ea kaꞌene Hura iji pijihajihija arara mapokijaho akúpa ꞌaha mweꞌa vaja ichihichihi hijujija eparahuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na ja haa ꞌwaravu. Ja tavoꞌa nahejuꞌe kivujaho vea maraꞌi venu ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ijihunaꞌe vea kaꞌene ike uneunechakipo reja kiꞌavajaho Hu niroe vwicha jiami rou roha. ");
INSERT INTO mcq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na nimaa ja ꞌwaravu. Eaka kijahija mahoꞌo pakwamasaꞌeje uneunecha ikijahija rehuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Akúpa mweꞌijaho paꞌarehuna kaivo Nuni Irijaho papaꞌareꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Vea vecha rehunijaho ea pahena pakavuꞌe Godoni ꞌona ojiꞌinijija pahena pakavuꞌe Godoni Harihiji ꞌuꞌo pahena pakamu kaivo Amora vea kajaho Huhusuma hena kamuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Heha! Vea kajaho ja pahena pakaviꞌini jihunaꞌe hina ꞌajihiꞌi kaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Vea kajaho areri ei pini epuni ari vaꞌi kaivo huni ara raname huni pwehija irechamiuꞌe kaukara raka raka kaꞌene vehunijaho najahe ꞌee vwicha ꞌajohiꞌina hami nia niriꞌi ꞌajohunaꞌe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nia hami niriꞌi hiꞌavara. Ijihuni maijaho sea anesurijara ꞌunama rohunijaho nusireina ho naꞌia ririna ho ꞌuꞌora ꞌumenujina ho vea nituꞌeje rohuna. ");
INSERT INTO mcq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vejuroꞌi ja neꞌeje hu roe tatatia veꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ja ꞌwaravu jaꞌinaꞌe ea mapoka ꞌuꞌo ꞌwaravo. Hami nia niriꞌi hiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Vea noꞌo paꞌareꞌeje Pasova ꞌee puretia isitia paꞌaji ijihipuni vea reꞌamarono pirisiti mamaꞌina ꞌee Sikuraipi jihipo ꞌunama icháꞌina Jesu pisimie ꞌanaa kwahuniji savara. ");
INSERT INTO mcq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pu ijá ꞌwava Nú iviamaa vea natohwa ikaho paveꞌeja. Vejuroꞌi ea mapokapo sena vene ꞌaraha veꞌavarono paveꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Vea kaꞌene Jesu Petani Saimani kaꞌene reporosia rukini jihuni sei ojuta hwene hijara. ꞌEꞌeme napara pini kavapwa senisia rukina monia niꞌina ꞌimenanaꞌomo apena roe jarae Jesuni húmata ꞌahi usetiana. ");
INSERT INTO mcq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ea ꞌahoꞌa kaꞌene ijí hijajipo ijí kamareja nihoꞌo ajinavume ijá ꞌwava Irakijihunaꞌe senisiakaho nisamo? ");
INSERT INTO mcq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nú monia maha húmata noꞌopisu ꞌimene ea kaꞌene ꞌiruma paꞌajihi niꞌajihuna saꞌinaꞌe avanu ꞌwame ꞌurarahara. ");
INSERT INTO mcq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ꞌEnakaivo Jesu ijá ꞌiama Makaha! Ja ichá vena hu ꞌuraraho? Hu Nununaꞌi mamaa venana. ");
INSERT INTO mcq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ea uneunecha paꞌajijahija ja puꞌúmo majama iki hihunaꞌomo ja ura pununaꞌi mamaa veꞌi veꞌavajaho veꞌavara. ꞌEnakaivo Na ja puꞌúmo majama pahiꞌeju. ");
INSERT INTO mcq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Naparakaho unenuꞌu pina hu areri renajaho hu nivenana. Nara kwahuniji hu Nuni haha amairihana. ");
INSERT INTO mcq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na nihoꞌo nimaa nimaa ja ꞌwaravu. Kwaaka mapokakino Godoni vuꞌa maa maiuꞌina ichihichihi ꞌwaꞌavajaho ijí napara kajara venaji ꞌuꞌo pu ꞌwame vwihahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ijiꞌa Jutasi Isikariati kaꞌene ea iropu ropu noꞌo ijihipuni ea pinaꞌomo vaꞌe pirisiti mamaꞌina kajihi puꞌúmo ꞌwame nimaa vene Jesuho nahame mihunijaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ꞌEjume pirisiti mamaꞌina kajija ijí hejajaho nihoꞌo teamanama parajumakame monia hu vajaꞌiro nahama ꞌwaravume hu aneja vene Jesu pu mihuni ꞌunama samana. ");
INSERT INTO mcq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Puretia isitia paꞌajihuni vea rejumakaviꞌi pu Pasova sipi ꞌuꞌua ꞌanae Godoni swasa veꞌeme Huni tisaiporu Jesu ijá ꞌwava Nú ichihi vaꞌe Pasova ꞌiruma amairiakame A iꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hu tisaiporu noꞌoheꞌi irechamie ijá ꞌiama Va ari natohwi useꞌeje ei pini toata apena ro piuniva kaꞌavajaho pu puꞌúmo sea kaꞌene hu vaꞌamajino ꞌarariha vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ꞌEnareje sea kaꞌene hura ajiꞌamajihuni sea anesurijaho apome ijá ꞌwaha Najuhiꞌini aporame ꞌwaravarono ꞌwarumanaꞌomo ꞌwaravu. Ea suja puni ruha kaꞌene Nara Nuni tisaiporu puꞌúmo Pasova ꞌiruma ihunijaho ichine? ꞌwame apoꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ꞌEje sea anesuri ruha natohwa kaꞌene ichuto uneunecha areri rene naviꞌiniji najahakame ja ijí ꞌiruma amairiaraꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ꞌEjume Huni tisaiporu ara natohwi vaꞌe Jesura ꞌwarama kajaꞌina rejume kamarena ꞌiruma kajaho amairiaravara. ");
INSERT INTO mcq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nusiremai Jesuho Huni tisaiporu iropu ropu noꞌo puꞌúmo sea kají vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pu ahuma ojuta hwene ꞌiruma ijiꞌi Jesu ijá ꞌiama Na ja nimaa nimaa ꞌwaravu ja ei pini Na nahamihuna Na huꞌúmo ꞌiruma inu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ꞌEjume pu temukaꞌeme aposarame ijá ꞌwava Ei pini narane ꞌiavume ei pini narane ꞌiavume ꞌwamapene ojara. ");
INSERT INTO mcq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hu ijá ꞌiama Ja ea iropu ropu noꞌokipo ea kwino Na nahamihuna. Ea kaꞌene puretia apene Na huꞌúmo tevua vaji apúsama inu karahara Na nahamiꞌena. ");
INSERT INTO mcq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Emaa Puni Harihijaho kwahuna. Areri Godoni ira vaji ꞌwarama jaꞌinaꞌe kaivo ea kaꞌene Na nahamihunijaho eha sisea apehuna. Maijaho oaha hu panahejaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pu ꞌiruma ijiꞌi hiꞌeme Jesu puretia apene Godoni siporua ꞌona teamani ꞌwaꞌi kaivo tuama Huni tisaiporu vajihiꞌi ijá ꞌiama Ikaho areri Nuni hahakúne ꞌeka iha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ꞌEne Hu kapusi apene kúꞌo Godoni siporua ꞌone teamani ꞌwaꞌi kaivo vajihume pu ijumakiviꞌi ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ikaho areri Godira nitama nahama ꞌwaramanaꞌomo Nuni ꞌaa kaꞌene ea mapokijihi punaꞌe arihunijina. ");
INSERT INTO mcq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na nihoꞌo nimaa nimaa ꞌwaravu. Na ajina riha kúꞌo paihuna kaivo Na Godoni ara vaꞌarejaꞌe kúꞌo maiuꞌina ihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pu javaa vejuma parajume pu Arivi huriꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ꞌEjume Jesu ijá ꞌiama Ja Nunijihunaꞌe oja hene ranamie vahuna areri Godoni iri vaji ꞌwarama jaꞌinaꞌe Nara sipia ꞌajohiꞌina ꞌanae ꞌee sipia juhaha ani ani vaꞌeja ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ꞌEnakaivo Na kwama vea noꞌopisu namarejaꞌe ijiꞌa Na kúꞌo ꞌurina Karari marako vaꞌeje ja ijiꞌa vuhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ꞌEjume Pita ꞌurina Jesu ijá ꞌwama Ea mapoka ranamaa vaꞌavajaho na maiꞌo A paranamaa vahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ꞌEjume Jesu Pita ijá ꞌwama Na a nimaa nimaa ꞌwaravu. Iviasi naꞌii a ꞌaha noꞌopisu hemareje Na pakimuna iꞌeje ꞌuꞌora ꞌaha noꞌoheꞌi ꞌumehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ꞌEjume Pita oja ꞌurina paraꞌejume ira ajira ijá ꞌwama Na A huꞌúmo kwahuna reꞌujaho na A pahemahuna ꞌwamana. Pitara ꞌwarama jaꞌinaꞌe tisaiporu ꞌuꞌo mahoꞌo ijaꞌina ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pu Ketasimani vaꞌajimareja Jesu Huni tisaiporu ijá ꞌiama Ja iki hiꞌeje Na siporua ꞌojuma ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ꞌEꞌikaivo Jesu Pita ho Jemisi ho ꞌee Joni ijá aherama vaꞌeme Jesu oja paꞌareꞌeme nihoꞌo temuma paranana. ");
INSERT INTO mcq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ꞌEjume Hu pu ijá ꞌiama Na temukimu. Nuni oja turame kwaꞌi ꞌahiu. ꞌEnakúne iki Na ꞌajiha niriꞌi hiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hu kahá irechamiꞌi kaivo mweꞌi one siporua ꞌona ijá ꞌwama Oni ura reꞌamajaho veje Na vea mukakaho asinavuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hu ijí siporua ꞌone ijá ꞌwama Amo Amo A uneunecha mapoka areri vejiꞌina. ꞌEnakúne veje ike kapusia kaꞌene Nununai namuji ape vaꞌa. ꞌEne Nuni ura ijaho pana kaivo oni ura ijara renama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hu siporua ꞌone ꞌunama roiꞌi kimajaho pu notuma kime Hu Pita ijá ꞌwama Saimani a nejiꞌi hino? A vea muka maꞌuako areri niriꞌi hiꞌena ho pane? ");
INSERT INTO mcq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ja niriꞌi siporua ꞌojiꞌi hiꞌirakúne vwiha sisesa pairisamiꞌamana. ꞌAvenijaho ura rena paranu kaivo hahijaho ajuaranu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hu kúꞌo ꞌunama vaꞌe siporua marako ꞌonajaꞌinaꞌe ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hu kúꞌo ꞌunama roe kimajaho pu majama hine notuiꞌi navara. Ijihuni maijaho puni nia nihoꞌo vahima paranana. ꞌEjume pu eha iraka ꞌwarahuna puruva renana. ");
INSERT INTO mcq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ꞌEjume Hu ꞌaha noꞌopisuji ꞌunama roe kime ijá ꞌiama Ja siheria vena notuu raka? Vea muka niroa apenana. Emaa Puni Hariha ei pini nahamahe ea siseijihi mihuna. ");
INSERT INTO mcq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ꞌUrija nú vaꞌava. Ea kaꞌene Na nahamahunijaho nirou ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu ijá ꞌwaraꞌejuꞌe pirisiti mamaꞌina Sikuraipi ꞌee emakinepo ꞌwaravume Jutasi ea iropu ropu noꞌo ijihipuni ea pinaꞌomo hura ea mapoka aherame soꞌwa hajaa vene roara. ");
INSERT INTO mcq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ea kaꞌene Hu nahamahunijaho hu pu maraku ꞌwaramana. Ea kaꞌene na ura mina veja kaꞌavajaho ijinakúne apena vaꞌi kaivo hami ꞌajoꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ꞌEjume Jutasi vea panisaꞌikaꞌi vaꞌe Jesuni nini vaꞌi kaivo ijá ꞌwama Najuhiꞌine ꞌwaꞌi kaivo ura mina venana. ");
INSERT INTO mcq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ꞌEjumakaviꞌi pu ijiji ꞌunama apejara. ");
INSERT INTO mcq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ijá veꞌeme ea kaꞌene ija naminajara niꞌaha kwino huni haha ꞌahi soꞌwa mavana apene ꞌanaume sosia ꞌajohiꞌina niꞌinijihuni pwea ataa ꞌuhuꞌusunahana. ");
INSERT INTO mcq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu ijá ꞌiama ꞌÚ ja ea nesa apejiꞌina apeꞌiro ꞌahiume soꞌwa hajaa vena roare? ");
INSERT INTO mcq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naꞌia mapokaꞌe Na ja puꞌúmo Temiporu vaji hina najahujaho ja Na paꞌunirivara. ꞌEnakaivo iviamaa iraka kaꞌene renukaho Godoni ira vaji ꞌwaramajara renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ꞌEjume Huni tisaiporu Hu ranaꞌikaꞌi juhaha vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Kivasa pina ateharu raananame haha maisu Jesu ꞌararihae vaꞌume pu hu ꞌuꞌo aharu ꞌonavume huni ateha tajaheꞌune ꞌoꞌeme maisu aseha vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ꞌEjume pu Jesu apena vaꞌe pirisiti niꞌini jihuni vaꞌumakiviꞌi pirisiti mamaꞌina ꞌee Sikuraipija ꞌee emainijihi puꞌúmo nianaa ijí roara. ");
INSERT INTO mcq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ꞌEꞌeme Pitaho Jesu túnaꞌi ꞌararihia vaꞌe pirisiti niꞌini jihuni sei vaꞌana. ꞌEne hu pirisiti kajihuni pwehijijihi puꞌúmo vena iruha hinana. ");
INSERT INTO mcq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pirisiti mamaꞌina kanisoru epo puꞌúmo ea irahipo Jesu namaha kamareje apena ꞌanaꞌi ꞌahiume ijihuni ꞌunama savajaho papiunavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ea mapoka ira ꞌatijino namahara kaivo puni vuꞌa ani ani renarena nimaa parejara. ");
INSERT INTO mcq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ea ꞌahoꞌa ꞌurina namijiꞌi Jesu iraꞌatijino namaha ijá ꞌwava ");
INSERT INTO mcq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nú hejuma Hu ijá ꞌwaramana Temiporukaho emaapo vejaraꞌomo Na veje tiraꞌusunaꞌiraꞌomo naꞌia noꞌopisu paꞌareꞌeje Na pina veje maꞌori rena namiꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ꞌEnakaivo puni vuꞌa ani ani renarena nimaa parejara. ");
INSERT INTO mcq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ꞌEjume pirisiti niꞌinijara Jesu apoma ijá ꞌwama ꞌÚ A ea pina eha paꞌwaramo? A iraka sisea vejume pu kavaraꞌomo ꞌwaravo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ꞌEnakaivo Jesu masuani hiꞌi kaivo ira paꞌwaravume pirisiti niꞌinijara kúꞌo apoma ijá ꞌwama ꞌÚ A Keriso kaꞌene Nimerajaha jihuni Harihe? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu ijá ꞌwama Iꞌa Na ijina. Ema Puni Harihijaho kaꞌeje harura rukimaꞌuri jihuni manaꞌinijaꞌi asuma hiꞌeje ichutoi ꞌimitijiꞌi rena rohuna. ");
INSERT INTO mcq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ꞌEjume pirisiti niꞌinijaho ijí henarena Huni ateha isokujiꞌi ijá ꞌiama Ja pakiꞌeje ea ꞌahoꞌa kúꞌo vuꞌa ꞌahoꞌa ꞌeka roava. ");
INSERT INTO mcq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ja nihejare Jesu Godi mataha avanana. Ja ichá vwihajo? ꞌiamana. Pu mahoꞌo namahe Hu kwahuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ꞌEjume ea ꞌahoꞌa Hu cheri ꞌotie ꞌee urania hwamahe haisi ꞌanaiꞌi ijá ꞌwava Irahipo ꞌanaukúne ꞌwaruva heja ꞌwavara. ꞌEjiꞌi sorutiapo ninu tahijahara. ");
INSERT INTO mcq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita majaa ara hari namiꞌejume pirisiti niꞌinijihuni pweijaho naparaꞌomo roana. ");
INSERT INTO mcq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ꞌEnarena hu kamajaho Pitaho ijí vena iruhiꞌi hijumakame nihoꞌo nia hami kaviꞌi ijá ꞌwama Ea ikere a ꞌuꞌo Jesu kaꞌene Nasareti orijiꞌi ꞌuraha ojiꞌina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ꞌEnakaivo Pitaho nihoꞌo hema parana ijá ꞌwama Pana! A uneka kaꞌene ꞌwarimu kajaho na nihoꞌo pahejura ꞌwaꞌikaꞌi samai vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Napara kajara Pita kamarena hu ea ꞌahoꞌa kaꞌene ijá namijajija kúꞌo ijá ꞌiama Ea ikaho Jesuni ea ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ꞌEnakaivo Pita kúꞌo hemana. ꞌEjume maꞌuako hinareje ea pina Pita oni rori naminajara ijá ꞌwama A nimaa nimaa puni ea pina. ꞌEne a ꞌuꞌo nimaa nimaa Karari ora ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ꞌEnakaivo hu sirikaraviꞌi ichutoa pikime ꞌurarahiꞌi ijá ꞌwama Na nihoꞌo ea kaꞌene ja rona ꞌwarivu kajaho pakavura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ꞌEꞌeme ijakaru ꞌuꞌora ꞌaha noꞌo ꞌumenana. ꞌEꞌeme ijiꞌa Pitaho Jesura vuꞌa kaꞌene ꞌwaramajaho vwihanana. ꞌUꞌora maiꞌo ꞌaha noꞌo paꞌumeꞌeje a ꞌaha noꞌopisu Na pakimuna iꞌena ꞌwamajaho vwihanarena nihoꞌo niꞌimaꞌura niramana. ");
INSERT INTO mcq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Súꞌu súꞌu vea maiꞌo ahara saꞌeme pirisiti mamaꞌina ꞌee emaina ꞌee Sikuraipia ꞌee kanisorua mahoꞌo pu puꞌúmo hina vuꞌa ꞌwame areri renareja pu Jesu kamome apene Pairati mahara. ");
INSERT INTO mcq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ꞌEjume Pairati Hu apoma ijá ꞌwama ꞌÚ A Jua puni Kinie? ꞌwamana. Hu eha vene ijá ꞌwama A niꞌwaramu kajina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ꞌEjume pirisiti mamaꞌinapo aneja vene sisemaija Jesu namahara. ");
INSERT INTO mcq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ꞌEjume Pairati kúꞌo apoma ijá ꞌwama Ea mapoka A namahu kaivo ꞌú A eha pu paꞌwaramo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ꞌEnakaivo Jesu vuꞌa pina eha paꞌwaravumakame Pairati nihoꞌo vwiha paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jua puni tamanaꞌomo sora ijuri vea rejukaviꞌi tipurea irá ea mapokaꞌe ura renaujaho ranavuꞌe samai vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nimarako kamati puꞌúmo Parapasi ꞌarahareja ea ꞌaniuma kwamasahume tipura hijara. ");
INSERT INTO mcq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eaka mapokijipo roe rora kaji namiꞌi kaivo ijá ꞌumeja Pairati a nitama venujaꞌinaꞌe iviamaa ꞌuꞌo ijaꞌina vena ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ꞌEjume Pairati eha vena ijá ꞌiama Ja ura na Jua puni Kiniji ranaꞌejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pairati henajaho pirisiti mamaꞌina Jesunaꞌi senama parania jihunaꞌe hu mahara. ");
INSERT INTO mcq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ꞌEnakaivo pirisiti mamaꞌina vejume ea mapoka Pairatira Parapasi ranahunaꞌe ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ꞌEjume Pairati kúꞌo eha vena ijá ꞌiama Ja ea kaꞌene Jua puni Kinia ꞌúvukaho na Hu ichá veꞌejo ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pu ajira ijá ꞌumeja Icha ꞌahi nerui ꞌanaa ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ꞌEjume Pairati ijá ꞌiama Rakijihunaꞌe? Hu iraka sisea venane? ꞌiamana. ꞌEnakaivo pu nihoꞌo ajira ijá ꞌumeja Icha ꞌahi nerui ꞌanaa! ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pairatira ea mapoka teamanaꞌamarono Parapasi ranavuma vaꞌana. Hu ꞌwaravume pwehwapo Jesu hijahe ꞌee hirisima mihume pu apena vaꞌe korosia ꞌahi ꞌanahuna. ");
INSERT INTO mcq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ꞌEjume sorutiapo Jesu apena vaꞌe ea natohwijihuni sei ranaꞌi kaivo sorutia mapoka ꞌumenaume nianaa roara. ");
INSERT INTO mcq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ꞌEnareja ijiꞌa pu ateha jopatuꞌumaꞌura kaivo aviꞌina nihoꞌo mavarasaꞌina apúsamahe ꞌwija ehima apene húmata ꞌahi apúsamahara. ");
INSERT INTO mcq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ꞌEjume pu ꞌijahareja ꞌajoma ijá ꞌwava Esi A Jua puni Kinia ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pu puapi ꞌuhua apene húmata ꞌahi ꞌanae cheri ꞌotie Huni unaꞌi nitupari same nuana vetiara. ");
INSERT INTO mcq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pu Jesu matahareja ijiꞌa ateha aviꞌina jopatuꞌumaꞌura kajaho tasiomaꞌi kaivo Huni ateha sahasa samahara. Ijá venareja ijiꞌa Jesu apena vaꞌe icha ꞌahi nerui ꞌanaꞌiro vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Saimani Sairini ora hu Arekisanitaꞌo Rupasiꞌo puni omaꞌomo nechiꞌi rena roe vwama rori namijuma kamareja sorutia kajipo hu ꞌejahae Jesuni korosia tapana vaꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ꞌEnareja pu Jesu apena vaꞌe Korukata vaꞌara. Korukata ꞌwavajihuni maijaho Húmata Ata ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ꞌEjume pu ajina riha kisini ꞌúsijiꞌi ahuma amairiareja Jesu mahara kaivo Hu painana. ");
INSERT INTO mcq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ijiꞌa pu Hu korosia ꞌahi ꞌanaareja Huni ateha ꞌeke pipi vejume ea ani ani ꞌekara. ");
INSERT INTO mcq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Súꞌu vea ajima roꞌeme pu Jesu korosia ꞌahi ꞌanaara. ");
INSERT INTO mcq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pu korosiaka Hu ꞌanaari ꞌahi huriji asura ikaꞌina vejara Ikaho Jua Puni Kinia ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ea noꞌo ea ꞌanie nesa apeju jihunaꞌe Jesu puꞌúmo korosia ꞌahi pina Huni anaꞌinijaꞌi ꞌanae pina Huni manaꞌinijaꞌi ꞌanaara. ");
INSERT INTO mcq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nitama Godoni irijara ꞌwaramarena Hu ea sisea puꞌúmo icha ꞌahi ꞌanaꞌeja ꞌiamajara roe nimaa renana. ");
INSERT INTO mcq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ea kajija korosia aneja kaji ruvaiꞌi matahe nuana achihe ijahiꞌi ijá ꞌwava Eeee! Ara Temiporu veje auꞌiraꞌomo naꞌia noꞌopisu paꞌareꞌeje A ꞌwarave ara kajaho kúꞌo veꞌena ꞌúmanakúna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Orono korosi ꞌaha kaji niꞌajarame ariha roe kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ꞌUnama nikwinuꞌina kajino pirisiti mamaꞌina ꞌee Sikuraipiepo Hu matahareja ijá ꞌwava Hu ea ꞌahoꞌa niꞌajihu jaꞌinaꞌe Hu oriꞌina areri paniꞌajaramu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A nimaa Keriso Isureri opuni Kiniakúna A iviamaa orono ariha roa kamareje nú A nimaa roja ꞌwavara. Ea kaꞌene korosia ꞌahi pu puꞌúmo ꞌaniajija ꞌuꞌo Jesu sivaa ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Vei riri kwaaka mapoka kajaho naꞌima namapena vaꞌo vaꞌume nusirei vea tiria koroku apenana. ");
INSERT INTO mcq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ꞌEꞌeme nusirei vea tiria korokuijino Jesura ajira ijá ꞌumena Eroi Eroi rama sapakatani ꞌumenana. Jesu ijaꞌina ꞌwarama jihuni maijaho Nuni Godi Nuni Godi iraki jihunaꞌe A Na pataaroriho? ");
INSERT INTO mcq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hura ꞌumena kaji ea kaꞌene rori namija kajipo henareja ijá ꞌwava Heha! Hu Iraija ꞌumenu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ea kwino ninuma vaꞌe ꞌoasuni apene icha ꞌahi vevahaꞌikaꞌi ajina riha kikisimaꞌura vaji apúsame iꞌamarono apena maꞌiro veꞌikaꞌi hu ijá ꞌiama Ja mareꞌe Iraijara ro ꞌunaa mweꞌi ranava kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ꞌEꞌeme Jesu nihoꞌo ajira ꞌumeꞌi kaivo kwamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Temiporu vaji ateha kaꞌene uranavujaho rira muꞌoi kahi huri rene isome vaꞌe kami tihi ꞌeꞌune noꞌoheꞌi rejara. ");
INSERT INTO mcq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sorutia puni namikii Jesuni unaꞌi namijiꞌi kavume Jesu oja suavuma kamarena hu ijá ꞌiama Nihoꞌo nimaa nimaa Ea ikaho Godoni Hariha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Napara ꞌahoꞌa ꞌuꞌo Karari namijiꞌi kavara. Ijihipuni vajijaho Meri Matarini Saromine ꞌee napara pina Meri kaꞌene Josisi huni ꞌuꞌua Jemisi puni ohaꞌomo napara kajihi puꞌúmo namijara. ");
INSERT INTO mcq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Vea kaꞌene Jesura Karari hinajaho napara kajija Hu ꞌararihae one ꞌee Huni ira hene vene ꞌee niꞌajahura. ꞌEe napara ꞌahoꞌa mapoka kaꞌene pu puꞌúmo Jerusaremi roajija ꞌuꞌo ijí namijara. ");
INSERT INTO mcq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sapati vea reꞌavarono amairiaraꞌeme nusiremana. ");
INSERT INTO mcq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josapi kaꞌene Aramatia ora kanisorua pina ea mapoka hu hena kavuraꞌomo hu Godoni arijara rohuniji ꞌajaha hijiꞌinaꞌomo hu roe pajuviꞌi Pairati oni vaꞌe Jesuni hahiji apeꞌi ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pairati Hura marako kwamaji henarena nihoꞌo puruva renana. ꞌEjume sorutia puni namikia apoma ꞌwaramana ꞌÚ Jesuho nikwamana ho pane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ꞌEjume namikia kajara Jesu nikwamana ꞌwavume Pairati henarena Josapi ꞌwaravume hu apena vaꞌe kwananaꞌiro vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ꞌEjume Josapi vaꞌe ateha ꞌimene roe hu Jesu korosi ꞌahi apene ateha kaji mwame apene vaꞌe muna ara kaꞌene maiꞌo ꞌuhuajihuni vaji ranaꞌikaꞌi muna tahuma apene ira tanunanamana. ");
INSERT INTO mcq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Napara pina huni iha Meri kaꞌene Matarini ꞌee pina Meri kaꞌene Josisi oni ohaꞌomo pu noꞌo Jesuni ruha kaꞌene ranavajaho hami kavara. ");
INSERT INTO mcq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapati vea nipaꞌareꞌeme Meri Matarini ꞌee Meri kaꞌene Jemisi oni oha ꞌee Saromi ijipo senisia amua rukina ꞌimene Jesuni haha ꞌonaꞌiro ꞌahiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hurapoka nihoꞌo súꞌu súꞌumai pu muna ari ea ranavaji ro ꞌeꞌuꞌeme vea ajimana. ");
INSERT INTO mcq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pu vaiꞌi ijá ꞌwava Muna kaꞌene vwicha kunavajaho irara tahuma apena ruvaꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ꞌEnakaivo pu vaiꞌi kavajaho muna niꞌimaꞌ ura kajaho nitatiraha ruvaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ꞌEjume pu vaꞌe muna ara kajihuni vaji aruma vaiꞌi kavajaho kivasa pina ateha jopatuꞌura saja saꞌina apúsame manaꞌinijaꞌi asuma hijume pu kama tatavara. ");
INSERT INTO mcq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ꞌEjume hu pu ijá ꞌiama Juvujaho areha. ꞌÚ ja Jesu Nasareti ora kaꞌene pu korosi ꞌahi ꞌanauma kwamaji savo? Hu kúꞌo ꞌurinana. Hura namajaho ikena kaivo Hu ikaho pahinu. ");
INSERT INTO mcq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ꞌEnakúne vaꞌe Huni tisaiporua ꞌee Pita ho ijá ꞌwaraha. Hu ja niꞌwarama jaꞌinaꞌe Hu Karari urana vaꞌukúne ja ijí Hu piunaha iha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pu muna ari vaji rene juhaha useme vaꞌajime simarame ꞌee oja hwaꞌusahaume ea ira paꞌwarava jihuni maijaho pu tea junavara. ");
INSERT INTO mcq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesura Hurapoki súꞌu súꞌu ꞌurinajaho Meri Matarini kaꞌene ꞌavena sisea iropu noꞌo siomahaji huni unaꞌi marako samaahiramana. ");
INSERT INTO mcq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ꞌEjume hu vaꞌe ea kaꞌene Hu Huꞌúmo ojura kaꞌene niramaruviꞌi choraꞌe hijajihi ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hu kúꞌo ꞌurina hinuji kama roe ꞌwaramaji hejajaho pu panimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ijihuni túnaꞌi ea noꞌoheꞌi rori vaꞌiro vaꞌeme Hu ꞌunamutoi haha aniꞌina apúsarame roe pu piunime pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pu ꞌuname vaꞌe napuhwaha ꞌahoꞌijija ꞌwaravara kaivo pu ꞌuꞌo nihoꞌo panimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ꞌEne ijihuni túnaꞌi ea iropu ropu kwinu hina ꞌiruma iꞌeme Hu puni roume pu kavumakiviꞌi Hu pu ꞌuraraha jihuni maijaho Hu ꞌurina hinaji ea mapoka Hu kama ꞌwaravara kaivo puni oja kisimaꞌura rejumakame pu panimaa rojajihunaꞌe avanana. ");
INSERT INTO mcq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hu ijá ꞌiama Ja kwaaka mapokaki vaꞌajime eaka mapokakihi Godoni vuꞌa maa maiuꞌina ꞌwaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ea irara nimaa roje toi apúsave ꞌuriꞌamajaho hu majama hihuna. ꞌEnakaivo ea irara panimaa roꞌamajaho hu ꞌotua vene eha sisea apehuna. ");
INSERT INTO mcq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ea irahipo nimaa roꞌavajaho aachakipo najahuna. Eje pu Nuni ihi ꞌahi ꞌavena sisesa siomahe ꞌee ira maiuꞌina ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ꞌEne pu tapara iji ꞌunirame ꞌee toa atama rukina iꞌavajaho pu sisea parenaꞌa. ꞌEne ea atama rukina pu iji ꞌuniraꞌavajaho maranihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesu kaꞌene Natohwijara pu ꞌwaravuma paꞌarejume Jesu apejume akúpa ꞌahi vaꞌe Hu Godoni ija manaꞌinijaꞌi asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ꞌEjume pu kwaaka mapoka kino ea mapoka najaꞌeme Natohwijara pu puꞌúmo vaꞌe pu niꞌajihe vejume pu aacha ani aniꞌina najahumakame Huni ira nimaa renana. ");
INSERT INTO mcq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ea niꞌina Tiapirasi ese. Ea mapokaꞌe uneunecha mapoka kaꞌene núni vajakino nimaa renajaho heha ꞌahi nivejara. ");
INSERT INTO mcq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nú raka kaꞌene pu ꞌwaravaji pu heha ꞌahi vejare ꞌee raka kaꞌene nitama aneji ea ꞌahopo puni nii kiꞌeme rejaji ꞌwaravaraꞌomo pu heha ꞌahi vejare ꞌee raka kaꞌene vuꞌa ꞌwaraviꞌinijipo ꞌwaravaji pu heha ꞌahi vena apena roara. ");
INSERT INTO mcq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na vwihajujaho mamaijaho na heha ꞌahi uneunecha iraka kaꞌene kahi aneji rene vena apene roaji veꞌipisana ronareꞌe veju. Ijihuni maijaho ijí iraka nimaa kaꞌene rejajija na hami hami kime hejuta. ");
INSERT INTO mcq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na ike vuꞌakaho onaꞌe vejujihuni maijaho pu raka maa kaꞌene a najahaji he parahuni jihunaꞌe veju. ");
INSERT INTO mcq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Vea kaꞌene Herotira Jutia opuni kinia renani veijino pirisitia pina Jakaraiasi ꞌwavujaho hu Apaijara pirisitia kaꞌene renajaꞌinaꞌe renana. ꞌEnakaivo huni naparijaho Eroni oni amuja. Huni ihijaho Irisapetina. ");
INSERT INTO mcq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pu Godoni unaꞌi nihoꞌo arira ꞌurahe ojure ꞌee Natohwi jihuni tamanijara ꞌwaramu jaꞌinaꞌe ojura. ");
INSERT INTO mcq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pu noꞌo amuja paꞌana. Ijihuni maijaho Irisapetiho amuja pavejiꞌinaꞌe renana ꞌee pu noꞌo ni ema paranahaꞌe rejara. ");
INSERT INTO mcq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Naꞌii pini Jakaraiasi huni ehi puꞌúmo kaukara vehuni vei rejume pirisitiepo Godoni unaꞌi vejujaꞌinaꞌe venana. ");
INSERT INTO mcq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pirisitia puni tamanaꞌomo pu pipia vene hu iji pijaha jihunaꞌe hu Temiporu vaji vaꞌe Natohwi jihuni inisenisia jaana. ");
INSERT INTO mcq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Vea kaꞌene inisenisi jaari veijaho ea mapoka kaꞌene samai hijajija hine siporua ꞌojara. ");
INSERT INTO mcq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ꞌEꞌeme Natohwi jihuni ꞌona ojiꞌina huni roe inisenisia jauri ꞌaijua rori manaꞌinijaꞌi naminana. ");
INSERT INTO mcq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Vea kaꞌene Jakaraiasi hua kamajaho nihoꞌo tea juma paranana. ");
INSERT INTO mcq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ꞌEnakaivo ꞌona ojiꞌina kajara ijá ꞌwama Jakaraiasi tea junamujaho arema. Godiho oni siporua henanaꞌomo oni napara Irisapetiho oni hariha nahehuna. ꞌEnajihunaꞌe a huni iha Joni ꞌiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Vea kaꞌene hu naheꞌamajaho a nihoꞌo teamaname mariꞌuhuna ꞌee ea mapoka teamanahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hu nihoꞌo Godoni rori ea niꞌimaꞌura mavarasaꞌinaꞌe ꞌurihuna. Hu nihoꞌo ꞌwainia ꞌee toa kikisina paihuna. Hu naheꞌavari anejijino rene Godoni ꞌAveni samahe tinia apena parahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hura kúꞌo Isureri oni harihija aherama taꞌarohe Godi kaꞌene puni Natohwi jihuni rohuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ꞌEnajihunaꞌe hura Iraija oni oja ꞌee harura ijí same Huni unaꞌi vahuna. ꞌEne emahwa puni ojijija taꞌarohe harihwaha ꞌee ea kaꞌene vuataa pahejiꞌinijija veje ea arira maa rehuna. ꞌEe ea aherame veje Natohwi jihuni ꞌunama amairiarahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ꞌEjume Jakaraiasira ꞌona ojiꞌina kajaho ijá ꞌwama Na ikaho icháꞌinaꞌe hena kaꞌejo? Na ni emamaa ꞌee nuni napara ꞌuꞌo ni paranamaa renu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ꞌEjume ꞌona ojiꞌinijara eha vena ijá ꞌwama Na Kepireruna. Na Godoni rori namijuraꞌomo Hura ranamiume na aaꞌe vuꞌa maiuꞌina mamaake ꞌwaraꞌi routa. ");
INSERT INTO mcq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ꞌEnakúne hena! Vea kaꞌene nuni vuꞌijara nimaa rena roe ꞌeꞌuꞌamajaho nimaa reꞌena kaivo a nuni vuꞌa panimaa ronujihunaꞌe a iviamaa ira paꞌwaraꞌikaꞌi hiꞌeje vea kaꞌene hariha naheꞌamajino ira ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ꞌEꞌeme ea mapoka Jakaraiasi Temiporu vaji ꞌajaha hijajaho ꞌaha jopatuꞌumaꞌura reꞌejuꞌe hu iraka vene marako parou ronareja vwihajara. ");
INSERT INTO mcq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ꞌEnakaivo vea kaꞌene hu roꞌeꞌunajaho hu ira areri paꞌwaramana. ꞌEjume pu marako kaꞌikaꞌi ijá ꞌwava Hu visoni Temiporu vaji kamareꞌe ijihunaꞌe avanu ꞌwavara. Hu ira pu paꞌwaraꞌikaꞌi ijaru ꞌwaraviꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Huni kaukara parajumakame kúꞌo ꞌunama huni sei vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ijihuni túnaꞌijino naꞌii pini huni napara Irisapetiho hariꞌi nena searu hiꞌeme masapa iropu paꞌarejara. ");
INSERT INTO mcq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ꞌEjume hu ijá rona Iviamai Natohwijara na túchamai ikaꞌina vwihaniana. Na hariha panaheju jihunaꞌe eriri nuni vahiꞌa apena vaꞌana ronana. ");
INSERT INTO mcq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ꞌEnakaivo iviꞌa masapa iropu kwinu paꞌareꞌeme ꞌona ojiꞌina Kepireriho Godira ranavume Karari vaji ara natohwa kaꞌene Nasaretina ꞌwavuji roana. ");
INSERT INTO mcq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hu Josapi kaꞌene Teviti oni amujijara ꞌasúra kaꞌene ꞌwahuni jihuni vuꞌa apena roana. ꞌAsúra kajihuni ihijaho Merina. ");
INSERT INTO mcq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ꞌEjume ꞌona ojiꞌinijara huni roe ijá ꞌwama Esi. A maiji aniꞌinaꞌe vwihanaajina. ꞌEne Natohwijaho a huꞌúmuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hu vuꞌa kaꞌene ꞌwaramaji henajaho nihoꞌo puruva rene teajuvume huni vwiha vaji ijá rona Iraki reniꞌamarono ꞌajorime ꞌwarimu ronana. ");
INSERT INTO mcq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ꞌEjumakame ꞌona ojiꞌinijara ijá ꞌwama Meri tea junamujaho arema! Godiho a maiji aniꞌinaꞌe vwihanaana. ");
INSERT INTO mcq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ꞌEnakúne hena! A hariꞌi nenareje hariha nahene huni ihijaho ꞌime Jesuna ꞌwaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hu nihoꞌo Natohwa rene ꞌee Hu mahoꞌo Ichuto Maijihuni Hariha ꞌwahuna. ꞌEne Godi kaꞌene Natohwijara Teviti oni ruhijaho Hu mahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ꞌEje Hu Jekapi oni amuhi puni Natohwaꞌe majama rehuna ꞌee Hura kwaa ara kaꞌene ꞌajoꞌamajaho nihoꞌo majama nahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ꞌEjume Merira ꞌona ojiꞌiniji ijá ꞌwama Ijaho icháꞌinaꞌe reꞌena? Ijihuni maijaho na ꞌasúra ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ꞌEjume ꞌona ojiꞌinijara eha vene ijá ꞌwama Godoni ꞌAveni samahuna. ꞌEe harura kaꞌene mahoꞌo Ichuto Maijihunijara raorahuna. Ijihuni hahi Hariha kaꞌene arira maiji naheꞌamajaho Godoni Hariha ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ꞌEnakúne hena! Oni vwina kaꞌene Irisapetiho amuja paꞌana ꞌwavura vo hu iviamaa niparanaha rejiꞌi hariꞌi nena hiꞌejuꞌe masapa iropu kwinu paꞌarenu. ");
INSERT INTO mcq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ijihuni maijaho unenuꞌu pini Godi oni unaꞌi kisina paꞌana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ꞌEjume Merira ijá ꞌwama Na niheju. Na Natohwi jihuni pweakúne ara iraka kaꞌene ꞌwarimu jaꞌinaꞌe veje reniama ꞌwamana. ꞌEꞌeme onaꞌojiꞌinijaho ijiꞌa ranama vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ijí vea kajino Meriho marako ꞌurine ara natohwa Juta vaji kwaa kaꞌene huriꞌa rukiniji vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hu Jakaraiasi oni sei vaꞌe arume Irisapeti ꞌajomana. ");
INSERT INTO mcq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Vea kaꞌene Merira ꞌajomaji Irisapeti heꞌeme hariha huni tea vaja kají pipijukuꞌeme Godoni ꞌAveni Irisapeti oni vaja ruha apenana. ");
INSERT INTO mcq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ꞌEjume hu ira ajiraꞌe ijá ꞌwama A napapuni vajijino nihoꞌo merajaha paranana. ꞌEe Hariha kaꞌene oni hahi vaji hinujaho nimerajahana. ");
INSERT INTO mcq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ꞌÚ irakijihunaꞌe nuni Natohwi jihuni ohakaho na uvaniꞌi roane? ");
INSERT INTO mcq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ike hena! A ꞌajorivume na heꞌeme harihaka nuni tea vaji hinujaho teamavume pipijukumana. ");
INSERT INTO mcq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Natohwijara raka kaꞌene huaꞌe rone ꞌwaramajara roe nimai rehuniji hu nimaa ronajihunaꞌe merajahana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ꞌEjume Meri ijá ꞌwama Nuni oja Natohwiji taꞌarohu. ");
INSERT INTO mcq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nuni ꞌavenijaho Godi kaꞌene na niꞌajiha jihunaꞌi temaranu. ");
INSERT INTO mcq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ijihuni maijaho huni pweijara masuani ajuarana hinajihunaꞌe Hu huni hura venana. Heha! Iviasi rene amuja amuja na rone merajihana ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ijihuni maijaho Natohwijara uneunecha mapoka mamaꞌina nunaꞌe venana. ꞌEne Huni ihijaho nihoꞌo aririjina ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ijihuni maijaho amuja amuja kwinu kwinu irahipo Huni hura vejujaho Hu numirama apena rouna. ");
INSERT INTO mcq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hu Huni iji uneunecha mamaꞌina vene ꞌee ea kaꞌene kehi kehi ojiꞌini jihipuni oja vwiha vejuꞌe ani ani vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hura ea mamaꞌina vejuꞌe puni ruha mamaꞌinijija paꞌarejura ꞌee Hu ea kaꞌene masuani hijiꞌinijihi ꞌunirame ahasirimauna. ");
INSERT INTO mcq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hu ea kaꞌene matunaviꞌinijija uneunecha mamaa areri vajihuna. ꞌEne ea kaꞌene uneunecha ani rejiꞌinijija irechamiuꞌe ija maisu vaꞌajivura. ");
INSERT INTO mcq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hu huni pwea Isureri niꞌajahuna. ꞌEne Hura pu numiramuji vwihaꞌamarono niꞌajahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ꞌEne opunúnaꞌe Eparahamiho ꞌee huni sesahwahiji ꞌwarama jaꞌinaꞌe majama ꞌwaramu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ꞌEne Meriho masapa noꞌopisu hinarena kúꞌo ꞌunama huni ari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Iviꞌa Irisapetira hariha nahehuni vea roume hu hariha nahenana. ");
INSERT INTO mcq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ꞌEjume huni amuja ea kaꞌene huni rori hijura ꞌee huni vwea vwina Natohwijara hu numimarena venaji henareja pu puꞌúmo temarasahara. ");
INSERT INTO mcq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ꞌEnarena vea oma iropu noꞌopisu paraꞌeme pu hariha kajaho sisa ꞌuhuaꞌirono apena roara. ꞌEnareja pu omahoni iha Jakaraiasi ꞌiꞌi ꞌahiume vejara. ");
INSERT INTO mcq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ꞌEnakaivo huni ohijara ijá ꞌiama Pana. Huni iha Jonina ꞌwaꞌeja ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ꞌEjume pu hu ijá ꞌwava Ijaho oni vwea vwina pina iha ijaꞌina ꞌuraha ꞌwahuna pana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ꞌEjume pu huni omijaho ijaru ijá ꞌwava A iha irá ꞌihuna ura renao? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakaraiasi heha ꞌwaravume mahume hu ikaꞌina venamana. Huni iha Joni venana. ꞌEjumakame pu ea mapoka nihoꞌo oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ijihia kajakaro rena Jakaraia oni ira kaꞌene paꞌarenajaho ira ꞌwarame ꞌee Godi taꞌarohana. ");
INSERT INTO mcq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ꞌEjumakame ea kaꞌene rora rora kají hijujija nihoꞌo tea junama paranana. ꞌEꞌeme Jutia huriꞌa vaja kajaho raka kaꞌene renaji ꞌwamapenojara. ");
INSERT INTO mcq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ea kaꞌene ijí hejajija piraꞌarame ijá ꞌwava Sesamaakaho icháꞌinaꞌe reꞌena? Ijihuni maijaho Natohwijara Hu ꞌajohau ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Huni oma Jakaraiasiho Godoni ꞌAveni tinia apejume raka kaꞌene ijiꞌa rehunijaho ikaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Natohwa kaꞌene Isureri opuni Godi ijí taꞌaroha. Hu ehwahaꞌe uvanie ꞌee kúꞌo ꞌunama ꞌimenae ꞌekaꞌi roana. ");
INSERT INTO mcq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Huni pwea Teviti oni amuja vajijino núni Niꞌajúhiꞌina Natohwa vejume ꞌurinana. ");
INSERT INTO mcq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ikaho Hura nitama iraka kaꞌene Huni poropetia arimaijihi puni vaji ꞌwaruvara. ");
INSERT INTO mcq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hu núni naka ꞌee ea kaꞌene nú kúme senaviꞌinijihi puni vaji niꞌajúꞌi roana. ");
INSERT INTO mcq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ijihuni maijaho Hu opunúna numirame ꞌee Hura nahama ꞌwaramaji vwihanuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Hu nimaa nimaa núni oma Eparahami nahama ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ꞌEne Hu núni nakapuni vaji Hu nú niꞌajúhuna nahama ꞌwarumana. ꞌEjakame nú pajuhaviꞌi Huni kaukara vehuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ꞌEne Huni unaꞌi arimaa ꞌee nimaa nimaa núra hiꞌavari veijaho hina vena apene vahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ꞌEne harihakere a poropetia kaꞌene mahoꞌo Ichuto Maijihuna ꞌwahuna. Ijihuni maijaho a urana vaꞌe Natohwi jihuni ꞌunamiji amairiahuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A Huni ehija kaꞌene Hura niꞌajihuniji najahakame puni sisea vwihane arehuniji kama hehuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ijihuni hahi Godi kaꞌene swasi maꞌurijara nú numirume vea kahi ichutoi ranave rina roe hananúhuna. ");
INSERT INTO mcq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ꞌEne ea kaꞌene nutuviꞌini hijujija ꞌee ea kaꞌene nikwamasaꞌiro vejujihija hananihuna. ꞌEne Hu núni mumora ꞌajohuakame nú matauma hihuni ꞌunamiji vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ꞌEjume hariha ꞌuꞌua kajaho emarena ajime ꞌee huni vwiha ꞌuꞌo emarena paranana. ꞌEꞌeme hu nechiꞌeru hinonu vaꞌu ijiꞌa amura Isureri puni unaꞌi sama hiramana. ");
INSERT INTO mcq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ijí vea kajino kamati Sisa Aukasitasira ꞌwaravume ea kaꞌene hura kwaa ara kaꞌene ꞌajohaujija iha taꞌirono ea mapoka nianae vaꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Vea kaꞌene Kwiriniasi Siria opuni ꞌajohaiꞌina renani vajijino iha amuraꞌe aneja vene tahara. ");
INSERT INTO mcq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ea mapoka puni aranejijino iha veꞌirono vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ꞌEjume Josapi ꞌuꞌo Nasareti Karari vaji rene Jutia ara natohwa Petirihemi kaꞌene Teviti oni araneji vaꞌana. Ijí hu vaꞌajihuni maijaho hu Teviti oni amuji jihunaꞌe vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pu noꞌo Meri kaꞌene hura ꞌwahunaꞌe nahama ꞌwaravara kaꞌene hariꞌi nenajiꞌi puni iha veꞌirono vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ꞌEne pu ijí hijari vea kajino hura hariha nahehuni vea niroa apenana. ");
INSERT INTO mcq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ꞌEjumakame hu ijí huni Hariha kaꞌene amurijaho nahenana. ꞌEnareja hu apena ateha hwame ꞌee hanupo ꞌiruma ijuri ruhi ranavume hinana. Ijihuni maijaho pura ruha kaꞌene hihunijaho paꞌajihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ꞌEjumakame ea kaꞌene sipia ꞌajohiꞌina ꞌahoꞌa kwaa kajino vea kajihuni naꞌiijino puni sipiaꞌe ꞌajohiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ꞌEꞌeme Natohwi jihuni ꞌona ojiꞌini roe puni unaꞌi namiꞌeme Natohwi jihuni hanajiꞌinijara pura namija kajaho hanana apene tauhuhana. ꞌEjume pu nihoꞌo natohwaꞌe tea junama paraniana. ");
INSERT INTO mcq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Onaꞌojiꞌinijara ijá iama Juvujaho areꞌikaꞌi heha! Na joni vuꞌa maiuꞌina mamaaꞌe apena routa. ꞌEe ijara veje ja ꞌee ea mapoka kaꞌene kwaa araka mapoka kakino hijukija teamanama parahuna. ");
INSERT INTO mcq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ike iviasi naꞌiakino Teviti oni ara natohwijino joni Niꞌajihiꞌina nahejara. Hu Keriso kaꞌene Natohwijina. ");
INSERT INTO mcq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jara ijí hena kahunijaho ja vaiꞌi kave pu atehi apene Hariha ꞌuꞌua kajaho hwame hanupo ꞌiruma ijuri ruhi ranavuꞌe hinunaꞌomo ja ijí kahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ijá veꞌeme niꞌaha kwino ꞌona ojiꞌina kajaho ꞌee ꞌona ojiꞌina ꞌahoꞌa mapoka mapoka kahi akúpi ꞌahi Godi taꞌarohe javaa vejara. ");
INSERT INTO mcq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Pu javaa ikaꞌina vejara Godi kaꞌene nihoꞌo Ichuto Maiji huni pinana ꞌurinu. ꞌEne ea kaꞌene Godira iki mweꞌi kime teamanamujihi matauviꞌinijaho mihu ꞌwame taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Onaꞌojiꞌinijija akúpa ꞌahi vaꞌumakiviꞌi sipia ꞌajohiꞌinijipo ijá ꞌwava Roe ma ariraꞌe Petirihemi vaꞌe ike unekaka rejuꞌukame Natohwijara roe nú ꞌwarumuke kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ꞌEjume pu marako vaiꞌi kivume Meri ho Josapi ho Hariha ꞌuꞌua kajaho ijano ijí hanuhapo ꞌiruma ijuri ruha kajino hijara. ");
INSERT INTO mcq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vea kaꞌene sipia ꞌajohiꞌini jipuhipu Hariha ꞌuꞌua kaji kavajaho raka kaꞌene Hariha ꞌuꞌua kaji rona ꞌwaravajaho pu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ea mapokaꞌe sipia ꞌajohiꞌinijipo vuꞌa kaji ꞌwaravume hejajaho nihoꞌo oja hwaꞌusunahara. ");
INSERT INTO mcq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ꞌEnakaivo Merira ijí henarena huni oja vaji vwihananama apena vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipia ꞌajohiꞌina kajija ꞌunama vaiꞌi uneka kaꞌene pu kame hejaji Godi taꞌarohe Huni pinana ꞌunama ahasirivara. ");
INSERT INTO mcq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Naꞌia iropu noꞌo pisu paꞌarejume ijiꞌa sisa ꞌuhuꞌavarono iha ꞌiame Jesuna ꞌwavara. Hu ijiꞌa maiꞌo tei vaji munaꞌamarono onaꞌojiꞌinijara iha kajaho mahana. ");
INSERT INTO mcq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Vea kajara apejume Josapiꞌo Meriꞌo Mosisi oni tamani iraka kaꞌene ꞌwaramaji vene ꞌee hariha ara hinajaho paꞌareꞌeme pu Sesamaijaho isinara iramahe Jerusaremi Natohwiji maꞌi ꞌahiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ikaho Natohwi jihuni tamana vaji ikaꞌina ꞌwarumana. Hariha kaꞌene amurijihi nahenaꞌavajija Godi vajahuna ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ꞌEne Natohwi jihuni tamana vaji ꞌwarama jaꞌinaꞌe marahuꞌora noꞌoheꞌina ꞌaho unea noꞌoheꞌi ꞌeka vaꞌe swasa vejura. ");
INSERT INTO mcq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Heha! Ea pina huni ihijaho Simionina hu Jerusaremi vaji hinuna. Hu ea arira ꞌee huni kaukara oja mahiꞌinaꞌomo hu Isureri opuni Mesaia ꞌajaha hinuna. ꞌEnaꞌomo Godoni ꞌAvena hu samahana. ");
INSERT INTO mcq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ꞌEjume Godoni ꞌAvenijara hu nahama ꞌwaramajaho hu pakwaꞌikaꞌi hiꞌeje Natohwi jihuni Kerisora roa kahuna ꞌwavume hinana. ");
INSERT INTO mcq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hu ꞌAveni vaji Temiporu roana. Vea kaꞌene emahwapo Hariha Jesu aheme roajaho varapa tamana veꞌi roara. ");
INSERT INTO mcq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni Hariha kajaho tapane apene huni ija ꞌahi ranaꞌikaꞌi Godi teimani ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Hu ikaꞌina ꞌwaramana Natohwe iviamaa Ara Oni ira vaji nahama ꞌwarumajaho renu. ꞌEnakúne A Oni pwea veje matauma vaꞌama. ");
INSERT INTO mcq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ara Oni Niꞌajúhiꞌina kaꞌene ea mapokakihi puni unaꞌi amairiaramajaho na nuni niakino kavu. ");
INSERT INTO mcq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hu ira kaꞌene Jenitaru hananie najahunijina ꞌee Hu Oni ehija Isureri opuni Hananiꞌinijina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Emahwapo vuꞌa kaꞌene Hua rone ꞌwaravaji hejajaho oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionira pu merajihe ꞌee Meri Huni ohijaho ijá ꞌwama Hena! Ike Harihakaho Isureri opuna pijahana. Hu Isureri ora ꞌahoꞌa veje arihe ꞌahoꞌa ajihuna. ꞌEne Hu aachaꞌomo ea mapoka ijí kame Hu ninahuna. ");
INSERT INTO mcq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ꞌEje ja temukaꞌamajaho areri soꞌwa ꞌusa rukina joni oja ꞌahi naminau jaꞌinaꞌe rehuna. Ijihuni maijaho oja vaji hema vwiha roe samaumaa rehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Napara poropeti Ana Panueri oni ꞌapaja ꞌee Asa oni amuja. Hu paranamaa paruaheꞌi hinajaho juara iropu noꞌo paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ꞌEꞌeme hu amuna hinajaho juara mapoka mapoka (84) paꞌarenana. Hu nihoꞌo Temiporu paranamuna ꞌee veiriꞌa naꞌia rira ꞌaura areme ꞌee siporua ꞌonuna. ");
INSERT INTO mcq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nijihijakura hu roe Godi teimani ꞌwamana ꞌee ea kaꞌene Jerusaremi puni Niꞌajihiꞌina ꞌajoha hijajihi majaa Hu rone ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ꞌEjume pu Natohwi jihuni tamanijara ꞌwaramajaho ve paranareja vukúꞌo ꞌunama Karari puni ara natohwa Nasareti vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ꞌEꞌeme Sesamaa kajaho harurijiꞌi emarena ajime ꞌee Huni vwiha ꞌuꞌo emarene ꞌee Godoni maiji vwihaniiꞌinijaho Hu huꞌúmo majama namana. ");
INSERT INTO mcq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Juara kwinu kwino paꞌareꞌejuꞌe emahwaha Jerusaremi Pasova sora iꞌi vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Vea kaꞌene Hu juara iropu ropu noꞌo renajino pu kúꞌo tamanijara veꞌavarono ꞌwaramu jaꞌinaꞌe sora iꞌiro kahi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pura naꞌia icharu hihuni veijaho nipaꞌarejume pu kúꞌo ꞌunama ari puni vaꞌeme Jesuho Jerusaremi hinana kaivo Huni emahwahijija ijaho pahena pakavara. ");
INSERT INTO mcq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pu vwihajajaho Hu ea mapoka kajihipuni vaji vaꞌu ronareja pu ꞌurina kwaa joraꞌe naꞌia kwino vaꞌareja ijí pakamareja aneja vene puni napuhija ꞌee vwea vwina puni vaja kajino savara. ");
INSERT INTO mcq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pu Hu pakamareja kúꞌo ꞌunama Jerusaremi sama vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vea noꞌopisu paꞌareꞌeme pu Hu Temiporu vaji najahiꞌinijipo najahaji hene ꞌee aporaviꞌi hiꞌeme piunavara. ");
INSERT INTO mcq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ea mapoka Hura eha mavarasaꞌina kaꞌene ꞌwaramaji hejajaho pu nihoꞌo oja hwaꞌusunahara. ");
INSERT INTO mcq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pu ijí kame hejajaho pu ꞌuꞌo oja hwaꞌusunahara. ꞌEe oahi ijá ꞌwama Hariha nuna A iraka vene ꞌunama ikaꞌina ꞌahúane? Nú omuneꞌi nihoꞌo oja hianuꞌeme Aaꞌe sarame apenojara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hu pu ijá ꞌiama ꞌÚ ja raka vena Na sarivo? ꞌÚ Na Oma Nunijihuni sei hihunijaho ja pahejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ꞌEnakaivo Hura raka kaꞌene ꞌwarama jihuni maijaho pu pahejara. ");
INSERT INTO mcq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ꞌEjume Jesuho pu puꞌúmo ꞌuname Nasareti vaꞌana. ꞌEnarena Hu emahwapuni ira hene venana. Oahi raka kaꞌene hena kamajaho oja vaji vwihajiꞌi hinonana. ");
INSERT INTO mcq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ꞌEjume Jesuho ꞌurine emakina rene ꞌee vwiha vaji emarene ꞌee Godiho ꞌee emaa Hu ura rejura. ");
INSERT INTO mcq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa kaꞌene Taipiriasina ꞌwavujara natohwa rena hinajaho juara iropu ropuꞌa mumora rona kwinu rejume Ponachasi Pairati Jutia puni natohwa rejume ꞌee Herotira Karari ora ꞌajohauꞌe ꞌee huni ꞌuꞌua kaꞌene Piripura Ituria ꞌee Tekonaitasi ꞌajohauꞌe ꞌee Raiseniasira Apirini ora ꞌajohauna. ");
INSERT INTO mcq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ꞌEjume Anasiꞌo Kaiapasiꞌo pirisitia mamaꞌina rejari vea kajino Godoni vuꞌa Joni kaꞌene Jakaraiasi oni harihaka nechiꞌi hinonu jihuni roana. ");
INSERT INTO mcq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ꞌEjuꞌe hu Jotani rori ara kaꞌene hijuji roe emaapo puni sisea vwihana areꞌeje toi samahuni vuꞌa ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Poropetia Aiseara ikaꞌina huni heha vaji venana. Ea pina nechiꞌi hine ꞌumeꞌena Natohwi jihuni ꞌunama amairie ꞌee veje arira renama. ");
INSERT INTO mcq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Isoha same ꞌee huriꞌa veje amara reja ꞌee ꞌunama kaꞌene ꞌajoviꞌinijaho veje arira reja. ꞌUnama kaꞌene ꞌonajiviꞌinijaho amara renama. ");
INSERT INTO mcq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ꞌEje ea mapoka Godi oni niꞌajúhiꞌinijaho kavava ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ea mapoka huni roajivakame hura ꞌunirame toi vaji samaꞌe ꞌuriꞌavarono roajivajihi ijá ꞌiama Ja tapara kaꞌene siseijihipuni harihija. Joni eha sisea niꞌimaꞌura kaꞌene túnaꞌi roujaho irara ja ꞌwaravukame ja juhame iki roajivare? ");
INSERT INTO mcq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ꞌIna rukina reꞌavara! Joni ꞌunama sahasijaho taꞌarohareje niareꞌi kaivo ea maiuꞌina reꞌavara Ja vwiha ikaꞌina pavwihaꞌavara. Eparahami núni omaꞌomo nú areri rena hiju paroꞌavara kaivo Godira areri veje ike muna ikihipo Eparahami oni harihija rehuna. Ijihunaꞌe nú areri rena hiju paroꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iviamai taupa icha aneji namunaꞌomo icha kajija ꞌina maa pareꞌavajaho ꞌumareje ꞌuhue veni atoꞌaruhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ꞌEjume ea mapoka kajipo apoma ijá ꞌwava ꞌEnaꞌomo nú icháꞌinaꞌe veꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ꞌEjume hu eha vene pu ijá ꞌiama Ea irara setia noꞌoheꞌi reꞌamajaho ea pina kaꞌene paꞌaji pina maꞌamane ꞌee ea irara ꞌiruma rukinaꞌe reꞌamajaho ꞌuꞌo ijá veꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ꞌEjume ea kaꞌene takisia apejiꞌina ꞌuꞌo hu ꞌunirame toi samaꞌavarono roaraꞌomo ijipo apoma ijá ꞌwava Najahiꞌine nú ichá veꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hu ijá ꞌiama Ja takisiaꞌe apeꞌavajaho icharu ꞌekaꞌavarono ꞌwaravajiru ꞌekaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ꞌEjume sorutia ꞌahopo apoma ijá ꞌwava ꞌEnakaivo núa. ꞌÚ nú icháꞌinaꞌe veꞌeja? ꞌwavara. Hu ijá ꞌiama Ea ꞌahopuni monia pamajikari ꞌejahie ꞌetujiꞌavara. ꞌEe ea pina pamajikari namaꞌavara. ꞌEe joni anejijaho teamanaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ea mapoka kajija ꞌajohe vwihajiꞌi hijuraꞌomo pu Joni kavari veijaho puni oja vaji ijá roja Vejuroꞌi Kerisora reꞌama rojara. ");
INSERT INTO mcq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ꞌEne Joni eha vene ijá ꞌiama Na ja toa vaji samauta kaivo Ea kaꞌene nuni túnaꞌi roujara samahunijaho Godoni ꞌAvena ꞌee harurijiꞌi samahuna. Na Hu Huꞌúmo areria pana ꞌee nara Huni mumora hwana jahenahuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ꞌEnakaivo soa Huni ija tahi namunaꞌomo Hura ꞌwitia mutuuri ruhijino mutuareje maijaho nianaꞌikaꞌi siseijijahija vena kaꞌene pautaruti saꞌikaꞌi namujiano atoꞌaruhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Naꞌia mapokaꞌe hu vuꞌa maa maiuꞌina ea najahe ꞌee vuꞌa ꞌahoꞌa aniꞌina niꞌajihe najahana. ");
INSERT INTO mcq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ꞌEnakaivo hu ea natohwa kaꞌene Heroti ꞌuraraha ꞌwaramana. Ijihuni maijaho hu Herotiasi huni ꞌuꞌuijihuni napara turame ꞌee uneunecha sisea mapokaꞌe Heroti venajihunaꞌe ꞌuraraha ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hu kúꞌo sisea pina kaꞌene huri venajaho Joni apene tipurai ranamajina. ");
INSERT INTO mcq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ꞌEnakaivo ea mapokaꞌe toa vaji samauma paraꞌeme ijiꞌa Jesu ꞌuꞌo toa vaji apúsavume ꞌurinana. Hu hine siporua ꞌoꞌeme akúpi ꞌahi vwicha jaraana. ");
INSERT INTO mcq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ꞌEꞌeme Godoni ꞌAvena areri marahuꞌora punaꞌi jaima ariha roe huni haha ꞌahi ajimana. ꞌEꞌeme ira akúpa ꞌahi rene roe ijá ꞌwama A Nuni Hariha kaꞌene Na oja mahujina. Na A nihoꞌo teamanimu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuho juara mapoka mapoka (30) paꞌareꞌeme ijiꞌa Hu Huni kaukara aneja venana. Ea mapoka Jesuho Josapi oni Hariha ꞌwavura. Josapi oni oma Iraina Irai oni oma Matatina ");
INSERT INTO mcq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matati oni oma Rivaina Rivai oni oma Merikaina Merikai oni oma Jenaina Jenai oni oma Josapina Josapi oni oma Matataiasina ");
INSERT INTO mcq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matataiasi oni oma Emasina Emasi oni oma Nehamina Nehami oni oma Esirina Esiri oni oma Nekaina Nekai oni oma Meatana ");
INSERT INTO mcq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Meata oni oma Marataiasina Marataiasi oni oma Semainina Semaini oni oma Josekina Joseki oni oma Jutana Juta oni oma Joananina ");
INSERT INTO mcq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanani oni oma Resana Resa oni oma Jerapaparina Jerapapari oni oma Setiarina Setiari oni oma Nerina Neri oni oma Merikaina ");
INSERT INTO mcq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Merikai oni oma Atina Ati oni oma Kosamina Kosami oni oma Erimatamina Erimatami oni oma Erina Eri oni oma Josuana ");
INSERT INTO mcq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josua oni oma Eriesana Eriesa oni oma Jorimina Jorimi oni oma Matatina Matati oni oma Rivaina Rivai oni oma Simianina ");
INSERT INTO mcq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simiani oni oma Jutana Juta oni oma Josapina Josapi oni oma Jonamina Jonami oni oma Iraiakimina Iraiakimi oni oma Mereana ");
INSERT INTO mcq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Merea oni oma Menana Mena oni oma Matatana Matata oni oma Netanina Netani oni oma Tevitina Teviti oni oma Jesina ");
INSERT INTO mcq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesi oni oma Operina Operi oni oma Poasina Poasi oni oma Sarimonina Sarimoni oni oma Nasionina Nasioni oni oma Aminatapuna ");
INSERT INTO mcq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminatapu oni oma Ataminina Atamini oni oma Ramana Rama oni oma Hesiranina Hesirani oni oma Peresina Peresi oni oma Jutana Juta oni oma Jekapina ");
INSERT INTO mcq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jekapi oni oma Aisikina Aisiki oni oma Eparahamina Eparahami oni oma Terana Tera oni oma Nehorina Nehori oni oma Serukina ");
INSERT INTO mcq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruki oni oma Reuna Reu oni oma Perekina Pereki oni oma Hiparuna Hiparu oni oma Sirana Sira oni oma Kenanina ");
INSERT INTO mcq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenani oni oma Aripakasarina Aripakasari oni oma Semina Semi oni oma Noana Noa oni oma Ramekina Rameki oni oma Metusarana ");
INSERT INTO mcq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusara oni oma Inakina Inaki oni oma Jeratina Jerati oni oma Mahararina Maharari oni oma Kenanina Kenani oni oma Inosina ");
INSERT INTO mcq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Inosi oni oma Setina Seti oni oma Atamuna Atamu Godoni hariha. ");
INSERT INTO mcq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesuho Jotani rene Godoni ꞌAveni ruha apena paraꞌeme ꞌAvena kajara aheme nechiꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hu ijino naꞌia mapoka mapoka (40) hiꞌeme Setani Hu vena kamana. Hu vea kajija ꞌiruma painajihunaꞌe Hu matuma paranana. ");
INSERT INTO mcq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ꞌEjume Setanijara Hu ijá ꞌwama A Godoni Hariha reꞌamajaho muna ike veje puretia rejakame ina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ꞌEjume Jesura eha vene ijá ꞌwama Godoni Irijara ija ꞌúma Ema maiꞌo puretieru reje hihuna pana ꞌúmana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ꞌEjume hu Jesu ahema vaꞌe huriꞌa ꞌahi namine kwaa ara mapoka kajaho niꞌaha kwinu nahana. ");
INSERT INTO mcq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ꞌEne Setanira Hu ijá ꞌwama Na harura ꞌee kwaa ara mapokakaho vajahuna. Ikaho naaꞌe miharaꞌomo nara ea kaꞌene na ura reniꞌamaji mahuna. ");
INSERT INTO mcq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","A na oja miꞌamajaho ike mapokakaho Onaꞌe rehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ꞌEjume Jesura eha vene ijá ꞌwama Godoni Irijara a Natohwa kaꞌene oni Godi ijiru oja mahe Hunaru venaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ꞌEjume hu Hu ahema vaꞌe Jerusaremi Temiporu ꞌahi ranavume namijumakaviꞌi ijá ꞌwama A Godoni Hariha reꞌamajaho iki kami mwama piꞌonama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Godoni Ira vaji ꞌwaramajaho Hura Huni ꞌona ojiꞌina irechamie pu A ꞌajohahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pura puni iji ꞌahiꞌenae A Oni mumora muna ꞌaha paꞌanaarahuna ꞌúmana ꞌwamana. Noin ");
INSERT INTO mcq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesura eha vene ijá ꞌwama Godoni Ira vaji ijá ꞌúma A Oni Godi Natohwijaho pavena kaꞌamana ꞌúmana ꞌwamana. Noin ");
INSERT INTO mcq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setaniho Jesuho ꞌunama ani ani vena kamajaho ijiꞌa areꞌi kaivo maꞌuaku ranama ruvaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ꞌEjume Jesuho kúꞌo ꞌunama Godoni ꞌAveni jihuni harurijiꞌi Karari vaꞌana. ꞌEjume Huni pinanijaho ꞌurijume kwaa ara mapoka kajaho he parajara. ");
INSERT INTO mcq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ꞌEne Hu aneja vene puni Sinakoku vaji najahume ea mapokaꞌe Hu taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ꞌEnarena Hu ꞌuname Nasareti Huni araneji Hura emakinaꞌe renajino vaꞌana. Sapati hu nivenu jaꞌinaꞌe Sinakoku vaji Hu heha taꞌiro ꞌurinana. ");
INSERT INTO mcq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Heha kaꞌene poropetia Aisea onijaho Huni ijatahi ranavume Hu rasame ikaꞌina kama tahana. ");
INSERT INTO mcq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Natohwi jihuni ꞌAvenijaho Na huꞌúmo hinu. Hura Na ea kaꞌene uneunecha paꞌajihi vuꞌa kaꞌene mamaiji najaꞌurono ranamiana. Ea kaꞌene iꞌivaniꞌinijihi rasamie ꞌee ea kaꞌene nia supaviꞌiniji veje niriꞌavarono routa. ꞌEne ea kaꞌene sisei hijiꞌinijihi niꞌajihe hanasina apeꞌavarono routa. ");
INSERT INTO mcq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Juara kaꞌene Natohwijara niꞌajihuniji ꞌwaraꞌi routa ꞌúmana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ꞌEjume heha tahuhe ea kaꞌene naminaji maꞌikaꞌi asuma hinana. ꞌEꞌeme ea mapoka kaꞌene Sinakoku vaji hija kajija nia tajahena apene Huaꞌe mahara. ");
INSERT INTO mcq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ꞌEjume Hu aneja vene ikaꞌina ꞌwaramana Joni atai heꞌeme heha kaꞌene Na tahujaho iviamaa nimaa renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ea mapoka kaꞌene ijí hijajaho nihoꞌo oja hianame ꞌee vuꞌa kaꞌene Huni iri vaji rena roe arihume hejajaho nihoꞌo teamanavara. ꞌEjume pu ijá ꞌwava ꞌÚ eakaho Josapi oni Harihijine? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hu pu ijá ꞌiama Na niheju. Ja Na areri juketakúne orono veje maranaama ꞌwihuna. Ja Na ijá ꞌwihune Ara Kapeniami uneka kaꞌene vejume nú pinana kaꞌene hejuji ikine oni ari veja kava ꞌwihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na nimaa nimaa ꞌwaravu ea kaꞌene poropetia huni ara vajijaho hami paapene ꞌajovura. ");
INSERT INTO mcq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na ja nimaa ꞌwaravo. Nimai Iraija oni veijaho amuna mapokaꞌe Isureri vaji ani reꞌeme juara noꞌopisune masapa iropu kwinu neha papiꞌeme kwaa ara kajaho ora vea reꞌeme matuna hijara. ");
INSERT INTO mcq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ꞌEnavo Iraijaho maiꞌo amuna mapoka ijí hijara kaivo hu puna pavaꞌana kaivo hu Saitoni vaji ara iha Sarepatina ꞌwavujino amuna kwinuꞌwi ijí hinunaꞌomo ijí niꞌajaꞌiro vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Poropetia Iraisa oni veijaho ea mapoka reporosia rukina Isureri vaji hijura vo nihoꞌo ea pina marahuna pana kaivo Nemani kaꞌene Siria orijiru huhusu maranana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ea kaꞌene Sinakoku vaji hija kajipo ijí hejajaho pu nihoꞌo ajinamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pu ꞌurimarame Hu tairie apene maꞌahi ꞌuseme aheme vaꞌe huriꞌa kaꞌene puni ara ijihuni toi vejari ꞌahi rarahi apúsaꞌi ꞌahiume vejara. ");
INSERT INTO mcq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ꞌEnakaivo Hu puni rira kajino ro ꞌeꞌune vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ꞌEjume Hu Kepeniami Karari vaji vaꞌe Sapati vei ea najahana. ");
INSERT INTO mcq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pu Huni vuꞌa kaꞌene nihoꞌo harura rukiniji hejajaho oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ijí Sinakoku vaja kajino ea pina ꞌavena sisei ajiviꞌina hinanaꞌomo hu nihoꞌo ira ajiraꞌe emaavanana. ");
INSERT INTO mcq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Haee! Jesu kaꞌene Nasareti orakere A nú irakaꞌe vetúꞌirono roane? ꞌÚ A núaꞌe ꞌeka ruaru ꞌahaume roane? Na A nihena kavu. A Godoni arira maijina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ꞌEnakaivo Jesu ꞌuraraha ijá ꞌwama Iranoꞌa areꞌi kaivo ema kajaho ranaꞌi kaivo ariha vaꞌa ꞌwamana. ꞌEjume ijí ꞌavena sisea kajaho hu unenuꞌu pina paveꞌikaꞌi ema kajaho piꞌonavume ea mapoka kajihipuni unaꞌi ꞌojumakaviꞌi ro ꞌeꞌuna vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ea mapoka ijí kamareja nihoꞌo oja hwaꞌusunahara. ꞌEjume pu ijá ꞌwava Ike vuꞌakaho icháꞌine? Harura ꞌee ajira rukinaꞌomo ike eakara ꞌananajihe ꞌee pikinakaviꞌi ꞌavena sisea ꞌwaravuꞌe usevura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ꞌEjume ijí Huni vuꞌa kajaho kwaa ara rora rora kajaho marako reꞌunana. ");
INSERT INTO mcq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ꞌEjume Hu ꞌurina Sinakoku kajaho areꞌikaꞌi Saimani oni arijino vaꞌana. Saimani oni jura paranahijaho haha ohoa natohwaꞌe rejume pu Jesura niꞌajaꞌamarono huni iha ꞌahi ꞌona vejara. ");
INSERT INTO mcq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ꞌEjume Hu vaꞌe Huni ruha rorijino namiꞌi ijí haha ohoa kajaho ꞌararihaana. ꞌEjume haha ohoa kajaho paꞌareꞌeme hu ꞌurine ꞌiruma amairia pu vajihana. ");
INSERT INTO mcq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nusirei vea va ꞌoꞌi veꞌeme ea mapoka kaꞌene atama ani aniꞌina ꞌekajija aherame Jesuni roume Hu ea kwinu kwino puni haha ꞌahi Huni ija irechavume pu maraniara. ");
INSERT INTO mcq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ꞌEjume ꞌavena sisea mapokaꞌe Hura vejume useviꞌi ijá ꞌumejare A Godoni Hariha ꞌumejara. ꞌEjume Hu ꞌararihie vejume pu ira paꞌwaravara. Ijihuni maijaho Hu Kerisoho pu nihena kavura. ");
INSERT INTO mcq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Vea nitumajino Hu kwaa kajaho areꞌikaꞌi vaꞌe kwaa kaꞌene ea pahijujino vaꞌana. ꞌEjume ea mapoka kajipo hina samuvaꞌo piuname pu ura Hu ꞌunanavakame paranamie vaꞌamarono vejara. ");
INSERT INTO mcq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ꞌEnakaivo Hu pu ijá ꞌiama Na vaꞌe ara ꞌahoꞌa Godoni ara rona ꞌwaramaji najahuna. Ijihuni hahi Na ranamiume Na ikaho routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ꞌEnarena Hu majaa Jutia Sinakoku mapoka vaja najahana. ");
INSERT INTO mcq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Naꞌia pini Hu Jenesareti soha rorijino namine vuꞌa ꞌwaraꞌeme ea mapoka Godoni vuꞌa kaji heꞌi ꞌahiume ijí kahi piijaraviꞌi roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hu kivume sisima noꞌoheꞌi soha rori naꞌeme ea kaꞌene úa vesaviꞌinijija puni namea ꞌeke arihe soviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ꞌEjume Hu Saimani oni sisima pini vaji ajiꞌikaꞌi ꞌwaravume piijahume maꞌuako karokaro soha riri va namana. Hu ijihuni vaji hijiꞌi ea mapoka kajija najahana. ");
INSERT INTO mcq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hu vuꞌa ꞌwara paraꞌikaꞌi Hu Saimani ijá ꞌwama Oni sisima piijahe úa riri vaꞌe joni namea same kija siriraha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ꞌEjume Saimani eha vene ijá ꞌwama Natohwe nú iviasi naꞌiakaho hine ojuta pahweꞌi nú úa kaji vesavara vo nihoꞌo kija pina paꞌejara kaivo A ꞌwarimu jihunaꞌe na namea sahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pu puni namea samareja kija nihoꞌo mapoka mapoka siriravume namea aneja vene turamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ꞌEjume pu napuhwaha kaꞌene sisima pina ꞌahi hijajija ꞌumenaume pu roe niꞌajihara. Pu roajime puni sisima noꞌoheꞌi vejume itusahe sisima kajija aneja vene tusaꞌi vejara. ");
INSERT INTO mcq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimani Pitaho ijí hura uneka kaꞌene vena kaji kamarena Jesuni unaꞌi nitupari saꞌikaꞌi ijá ꞌwama Natohwe na ea sisea vejiꞌinakúne nuni rori roujaho areꞌi kaivo ani vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ijihuni maijaho Hua ꞌee ea ꞌahoꞌa kaꞌene pu puꞌúmo hijajipo ijí kija mapoka kaji kivajaho nihoꞌo oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimani oni napuhija Joniꞌo Jemisi kaꞌene Jepati oni harihija noꞌo ꞌuꞌo oja hwaꞌusahara. ꞌEjume Jesura Saimani ijá ꞌwama Tea junamujaho arema. Iviamaikano rene a emaa sirirahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ꞌEjumakame pu puni sisima ꞌeka roe amari irechame ꞌee puni uneunecha mapoka areꞌikaꞌi Hu ꞌararihaa vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Naꞌii pini Hu ara pini vaꞌeme ea pina reporosia rukina Jesu kamarena Huni unaꞌi mweꞌi ꞌojiꞌi jarima ijá ꞌwama Natohwe A ura renaꞌamajaho veje na maraniama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesura ija jorane ꞌunaviꞌi ijá ꞌwama Na ura reniukúne maranaꞌama ꞌwavume niꞌaha kwino ea kajihuni reporosia paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesura ijá ꞌwama Ikaho ea ꞌahoꞌa paꞌwaraꞌamana kaivo vaꞌe pirisiti nahareje ijiꞌa vaꞌe Mosisira ꞌwarama jaꞌinaꞌe Godoni swasa veꞌamana. ꞌEjakame ea mapoka oni reporosia kaꞌene paꞌarenajaho hena kaꞌavara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ꞌEnakaivo Huni pinanijaho ara mapoka henareja ea mapokaꞌe Huni vuꞌa hene ꞌee atama puna veje paꞌareꞌamaro roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ꞌEnakaivo Hu naꞌia ꞌahoꞌa vaꞌe ea pahijuri kwai siporua ꞌonuna. ");
INSERT INTO mcq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naꞌia pini Hu hine najaꞌeme ijihuni vaja kajino Parasia ꞌee ea kaꞌene tamana najahiꞌinijija ijí hijara. Pu ara kwinu kwino Karari vaja ꞌee Jutia vaja ꞌee Jerusaremi vaji rena roe ijí hijara. ꞌEjume Natohwi jihuni harurijaho ijí vea kajaho Jesura eaꞌe veje maraniꞌamarono namana. ");
INSERT INTO mcq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ꞌEꞌeme ea ꞌahopo ea pina haha ajuaraviꞌina apene kime Jesuni unaꞌi ranaꞌi ꞌahiume apene sei roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ꞌEnakaivo ea mapokaꞌe ituꞌona namajihuna pura huaꞌe apena vahuna ꞌunama paꞌarenana. ꞌEnajihunaꞌe pu ea kajaho apene atahuri vaꞌe tita napame ea kajaho huni kicha ꞌahi naꞌeme apúsavume ꞌonu vaꞌo Jesuni unaꞌi ea rira kajino namana. ");
INSERT INTO mcq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hu icháꞌinaꞌe pu nimaa rojuji kimarena ema kaji ijá ꞌwama Napura nunakera Oni sisea Na vwihana arevu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parasia ꞌee Sikuraipia pu aposarame ijá ꞌwava Ikaho ea iranaꞌomo Hu Godi matahareꞌe avano? Ea irara sisea vwihane arehune? Godira Huhusuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesuho pura iraka kaꞌene aposaravajaho nikimarena ijá ꞌiama ꞌÚ ja iraka vene joni oja vaja aposaravo? ");
INSERT INTO mcq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na icháꞌinaꞌe ꞌwaraꞌejo? Na huni sisea vwihana areꞌeju ho Na ꞌwave ꞌurina vaꞌena? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ꞌEnakaivo jara Ema Puni Harihijihuni harura kaꞌene iki mweꞌi ea vwihanie arevuji hena kaꞌavarono Hu haha ajuarajiꞌinijaho ijá ꞌwama Na a ꞌwaravukúne ꞌurine oni suha apene ari vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ꞌEjume niꞌaha kwino ea kajaho puni una kajino ꞌurine iraka kaꞌene hura ijihuni toi namajaho apene ari Godiho taꞌarohiꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pu nihoꞌo oja hwaꞌusahaume Godi taꞌarohe tea junaꞌeme ijá ꞌwava Nú iviasi uneunecha mavarasaꞌina kivara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ijihuni túnaꞌijino Hu vaiꞌi kavuꞌe ea kaꞌene takisia apejiꞌina iha Rivaiho takisia apejuri seijino asuma hinana. ꞌEjume Hu ijá ꞌwama ꞌArarihie roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hu huni uneunecha mapoka makiꞌikaꞌi ꞌurine Hu ꞌararihaa vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ꞌEnarena Rivaira huni sei ꞌiruma natohwa Jesunaꞌe vejume ea kaꞌene takisia apejiꞌinijija ꞌee ea ꞌahoꞌa mapokaꞌe pu puꞌúmo ꞌiruma ijara. ");
INSERT INTO mcq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parasia ꞌee Sikuraipia ijipo aneja vene Huni tisaiporu ꞌuraraha ijá ꞌiava Ja iraka vene ea kaꞌene takisia apejiꞌina ꞌee ea sisea puꞌúmo ꞌiruma ijo? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesura eha vene ijá ꞌiama Ea kaꞌene atama paꞌajija juketaija ura parenaura kaivo ea atakinijipo juketaija ura renaura. ");
INSERT INTO mcq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na ea arira maa vejiꞌinijihipuni parouta vo Na ea sisea kaꞌene puni sisea vwihane temukaviꞌini jihipuni routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ea ꞌahopo Jesuho ijá ꞌwava Joni oni tisaiporujija naꞌia kwinu kwino ꞌaura areme ꞌee siporua ꞌojuꞌe Parasi puni tisaiporu ijija ꞌuꞌo ijaꞌinaꞌe vejura kaivo Oni tisaiporu ijija ꞌiruma toa ma ijí ijura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesura ijá ꞌiama Ja vwihajujaho ea kaꞌene napasi nejujihipuni ꞌiruma vejujaho huni napuhija kaꞌene ijí kiꞌiro roajivujijahija ꞌaura arevura araka? ");
INSERT INTO mcq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ꞌEnakaivo vea kaꞌene napasi nejiꞌina kajara ijí pu puꞌúmo pahiꞌi kaivo ani vaꞌakamaꞌe pu ijiꞌa ꞌaura arehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hu haa ꞌwaramarena ijá ꞌiama Ea maiꞌo ateha maiuꞌina isome sahasijiꞌi pasuhura. ꞌEnakaivo ijaꞌinaꞌe veꞌavajaho ateha kajija isome aniꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ꞌEne vukúꞌo ꞌwainia maiuꞌina ꞌeke hanuha sisa sahasa vaji veriꞌavajaho hanuha sisa sahasa kajaho napame ꞌwainia arihuna. ");
INSERT INTO mcq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ꞌEnakaivo ꞌwainia maiuꞌina hanuha sisa maiuꞌina vaji verivura. ");
INSERT INTO mcq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ea ꞌwainia sahasa ijujaho ꞌwainia maiuꞌina ura parenaura. Pu ijá ꞌwarahuna Sahasijaho arerina ꞌwahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vei pini Sapati veijino Hu konesa juasiꞌa ꞌuraha vaꞌeme Huni tisaiporua konesa tuame iji tanihiꞌi ꞌinijaho ijara. ");
INSERT INTO mcq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ꞌEꞌeme Parasia ꞌahoꞌa ijá ꞌiava ꞌÚ ja iraka vene varapijara Sapati veijino paveꞌavarono ꞌwarumajaho vejo? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesura eha vene ijá ꞌiama ꞌÚ ja Tevitira huni ehi puꞌúmo matuvumakame iraka kaꞌene vejajaho ja pataha hejare? ");
INSERT INTO mcq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hu Godoni sei vaꞌe puretia kaꞌene Godi vajahajaho ꞌeke huna iꞌikaꞌi ꞌahoꞌa ehwaha vajihana. ꞌEnavo ijaho tamanaꞌomo ea mamaha paijura kaivo pirisitiepo pupusu ijura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ꞌEjume Hu ijá ꞌiama Ema Puni Harihijaho Sapati huni Natohwa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Naꞌii pini Sapati veijino Hu vaꞌe Sinakoku vaji najahana. Ema pina ijí hinajaho huni ija manaꞌinijaho ꞌiriviꞌina. ");
INSERT INTO mcq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sikuraipi ꞌee Parasia Hu ea pina ijí Sapatia vea kajino veje marajakame namaꞌi ꞌahiume nii vevirinavara. ");
INSERT INTO mcq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ꞌEnakaivo Hu pu raka kaꞌene vwihajajaho Hu kimarena ea kaꞌene ija iriviꞌina kajaho ijá ꞌwama ꞌUrine iki unaꞌi roa ꞌwamana. ꞌEjume hu ꞌurine ijino vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ꞌEnarena Jesura pu ijá ꞌiama Na ja aporavu Joni tamanijaho Sapati veijaho nú mamaa veꞌeja ho sisea veꞌeja? Ea niꞌajiꞌeja ho ea ꞌanae kwaꞌena? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hu ꞌurine namiꞌi kaivo ea kwinu kwino kima apena vuꞌu vaꞌume iriviꞌinijaho ijá ꞌwama Oni ija nipima ꞌwamana. ꞌEjume hu ijaꞌinaꞌe vejume huni ija maranana. ");
INSERT INTO mcq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pu nihoꞌo ajinavume pu hine Jesu iraka kaꞌene vetihuniji ꞌwama apenojara. ");
INSERT INTO mcq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vea kajino Hu vaꞌe huriꞌa ꞌahi siporua ꞌoꞌi vaꞌana. Hu naꞌia kajaho Godoni siporua hine ꞌoꞌeme vea nitumana. ");
INSERT INTO mcq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Vea nituvumakaviꞌi Hu Huni tisaiporu ꞌumenaume rouma ea iropu ropu noꞌo iji pijiharena iha ihame Apasorua ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Puni ihijaho Saimani kaꞌene Pitana ꞌwavujaho ꞌee huni ꞌuꞌua Enituruho ꞌee Jemisi ho ꞌee Joni ho ꞌee Piripu ho ꞌee Pataramiu ho ꞌee Matiu ho ꞌee Tomasi ho ꞌee Jemisi kaꞌene Apiasi oni harihijaho ꞌee Saimani kaꞌene Seratina ꞌwavujaho ꞌee Jutasi kaꞌene Jemisi oni harihijaho ꞌee Jutasi Isikariati kaꞌene Jesu nahamahunaijina. ");
INSERT INTO mcq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hu pu puꞌúmo ariha roe amari namijiꞌi kivume Huni tisaiporu nihoꞌo mapoka mapoka kajihija ꞌee ea nihoꞌo mapoka mapoka Jutia rori hijura ꞌee Jerusaremi rori hijura ꞌee ara kaꞌene soha rori Taia ꞌee Saitani roara. ");
INSERT INTO mcq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pu roajime Huni vuꞌa hene ꞌee puni atama veje paꞌareꞌamarono roara. ꞌEne ea kaꞌene ꞌavena sisea ajimaꞌinijija ꞌuꞌo roume Hu vejume maraniara. ");
INSERT INTO mcq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ꞌEjumakame ea mapoka Huni haha ꞌunaꞌiro vejara. Ijihuni maijaho Huni harura niꞌimaꞌura Huni vaji rena roe ea mapoka vejume maraniara. ");
INSERT INTO mcq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hu ꞌarohe Huni tisaiporu kiviꞌi aneja vene ijá ꞌiama Ja ea kaꞌene pivusahujija iviꞌa tea manamama. Ijihuni maijaho Godoni arijaho iviꞌa jonaꞌe renu. ");
INSERT INTO mcq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ꞌEne ja ea kaꞌene iviamaa matunavujaho iviꞌa teamanamama. Ijihuni maijaho Godira veje ja túꞌahuna. ꞌEne ja ea kaꞌene niravujija iviꞌa tea manamama. Ijihuni maijaho ja ijasahuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ja Emaa Puni Harihijihuni hahi emaapo kima sename ꞌee pataarorahe ꞌee ira sisea namahe erapo ira sisea ꞌwarame ja ꞌararihie vuꞌa sisea ani aniꞌina ꞌee joni iha ꞌurihiꞌi sisea vwihaja kiꞌavajaho ja teamanamama. ");
INSERT INTO mcq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Vea kajaho ja nihoꞌo teamanama paraꞌeje mariꞌuviꞌi ohurikusaha. Ijihuni maijaho joni eha mamaa kahino Godoni ara akúpa ꞌahi namu. Puni sahipo nijano poropetia kaꞌene marako hijajija siseꞌi ꞌahiajaꞌinaꞌe ja ꞌuꞌo siseꞌi ꞌahihuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ja ea kaꞌene iviamaa uneunecha mapoka ani reꞌejuꞌe hijujaho nihoꞌo sisea piunahuna. Ijihuni maijaho ja iviamaa hami hihunijaho mahoꞌo apeju. ");
INSERT INTO mcq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ja ea kaꞌene iviamaa túavujaho nihoꞌo sisea piunahuna. Ijihuni maijaho ja matunahuna. Ja iviamaa ea kaꞌene hine ijasahujaho sisea piunahuna. Ijihuni maijaho ja chora hine niramaruhuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ja ea kaꞌene iviamaa joni vuꞌa mamairu ꞌwavujaho sisea piunahuna. Ijihuni maijaho nitama puni sahipo niareri ijaꞌinaꞌe poropetia kaꞌene iraꞌasinijija ꞌahiara. ");
INSERT INTO mcq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ꞌEnakaivo Na ja ea irahipo hejuji Na ꞌwaravu. Joni naka oja mihe ꞌee ea irahipo jaaꞌe senavujija hami ꞌahie ");
INSERT INTO mcq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ꞌee ea kaꞌene jaaꞌe siripaꞌavajija merajihe ꞌee ea kaꞌene ja siseꞌi ꞌahiꞌava jihipuni siporua ꞌoꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ea pini a noa ꞌahi tahijahaꞌe kaꞌamajaho makaꞌeje ropunaꞌa ꞌuꞌo ꞌanaꞌamana. Ea ꞌahopo oni kosetia apeꞌavajaho makiꞌikaꞌi oni setia ꞌuꞌo miꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ea irara uneunecha jarirave kaꞌamajaho maꞌamana. ꞌEne oni kukuaꞌe ei pini apeꞌamajaho kúꞌo paapeꞌi ꞌahae ꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ea ꞌahopo jonaꞌe venaꞌavarono ja ura renujaꞌinaꞌe ja ea ꞌahopuna venaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ja ea kaꞌene jaaꞌe oja mihujiru oja miꞌavajaho ja maa iraka vejare? Ijihuni maijaho ea sisea ꞌuꞌo ea kaꞌene pu oja vajihujiru oja mihura. ");
INSERT INTO mcq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ꞌEne ja ea kaꞌene jaaꞌe hami ꞌahiujiru hami ꞌahiꞌavajaho ja irakaꞌe maa vejare? Ijihuni maijaho ea kaꞌene sisea vejiꞌina ꞌuꞌo ijaꞌinaꞌe vejura. ");
INSERT INTO mcq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ꞌEne ja ea kaꞌene eha vajihunijiru uneunecha vajaꞌavajaho ja iraka maa vejare? Nihoꞌo maa pavenana. Ea kaꞌene sisea vejiꞌina kúꞌo eha areri ꞌekahuna vwihajiꞌi ea kaꞌene sisea vejiꞌinijaho vajihura. ");
INSERT INTO mcq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ꞌEnakúne joni naka oja mihe ꞌee pununaꞌi hami vene ꞌee eha ꞌekahuna pavwihajiꞌi vajiꞌavara. Ijihuni maijaho ja eha natohwaꞌe kahi akúpi ꞌahi apene ꞌee ja Godi kaꞌene nihoꞌo Ichuto Maijihuni harihijaꞌe rehuna. Godiho ea kaꞌene Hu patea manaviꞌinijija ꞌee ea kaꞌene sisea niꞌimaꞌura vejiꞌinijija hami ꞌahiuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Joni Omijara ea ꞌahoꞌa numiramu jaꞌinaꞌe ja ea ꞌahoꞌa numirahuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ja ea ꞌahoꞌa panamaꞌirakúne Godi ja panamahuna. Ja ea ꞌahoꞌa paronaꞌirakúne Godi ja ꞌuꞌo paronaꞌamana. Ea ꞌahopuni sisea vwihane areꞌirakúne Godira joni sisea vwihana areꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ja ea vajiꞌavajaho ja ꞌuꞌo vajihuna. Ja hami swara veꞌavajaho areri ijaꞌinaꞌe nihoꞌo nipia nirisame tihitihivajame ajima roe ameurahe arihiꞌinaꞌe ja vajihuna. Ja ea ꞌahoꞌaꞌe vajiha jaꞌinaꞌe ja ꞌuꞌo vajihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ꞌEnarena Hu haa ꞌuꞌo ikaꞌinaꞌe pu ꞌwaramana. Ea kaꞌene nia supaviꞌinijaho ea pina kaꞌene nia supaviꞌinijaho areri ahema vaꞌena raka? Pu noꞌo areri maꞌoa paarihuna raka? ");
INSERT INTO mcq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sikuru pwea huni najahiꞌinijaho paasimuna. ꞌEnakaivo ea irara nahuꞌe hena kamareꞌe ijiꞌa huni najahiꞌina kajihu vareꞌina renuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","A irakaꞌe vene oni nia vaji taura niꞌimaꞌura kaꞌene navujaho pakama ꞌwaꞌi kaivo vweu puni nia vaji taura maꞌuꞌua kaꞌene namujaho kame ꞌwaramo? ");
INSERT INTO mcq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A ꞌunama icháꞌinijino oni vwea ijá ꞌwaꞌena Vwee veje na oni nia vaji taura kaꞌene namujaho ꞌeꞌonavuma. ꞌEnakaivo vu oni nia vaji taura kaꞌene namujaho a pakamo? A nihoꞌo iraꞌasinakúne oni nia titi taura niꞌimaꞌura kaꞌene namujaho marako ꞌeꞌonaꞌi kaivo areri hami niriareje ijiꞌa vweu puni nia titi taura kaꞌene namujaho ꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ꞌEnajihunaꞌe icha mamaijija maiꞌo ꞌina sisea parejura. ꞌEne icha siseijija maiꞌo ꞌina mamaa parejura. ");
INSERT INTO mcq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ꞌEne icha mapokakipo ꞌina kaꞌene rejujaho nú icha raka saꞌinijija ꞌina kaji kima hejura. Ja mataka ꞌwija ꞌahi rena navuꞌe ja vaꞌe mene roe ijure? Manuꞌa mitota ꞌahi rena navuꞌe ja vaꞌe mene ro ijura raka? ");
INSERT INTO mcq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ea kaꞌene oja mamai ijaho uneunecha mamaa puni oja vaji rena roe ajima arihura. ꞌEnakaivo ea siseijijahija puni oja vaja sisea kaꞌene namujiru roe ajima arihura. Ira vaja kakino raka kaꞌene roa ajima arihujija puni oja vaji icháꞌina kaꞌene navujipo roe ajima arihura. ");
INSERT INTO mcq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ja iraka vene Natohwe Natohwe ꞌwiꞌi kaivo Nara raka kaꞌene ꞌwaravujaho pavejo? ");
INSERT INTO mcq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ea kaꞌene roe Nuni ira hena venujaho hu ea icháꞌinijaho Na jaaꞌe najahuna. ");
INSERT INTO mcq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hu areri ei araꞌe venujaꞌina. Hu mweꞌa ꞌuma ariha vaꞌu vaꞌu muna ꞌahi aneja vene tukeja kikisina samuna. Neha niꞌina pine sai natohwi hiramarena ara kajaho ninamana kaivo nihoꞌo pavarimana. Ijihuni maijaho ara kajaho nihoꞌo hami hami muna ꞌahi rena vejara. ");
INSERT INTO mcq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ꞌEnakaivo ea kaꞌene Nuni ira henareꞌe pavenujaho areri ea kaꞌene huni ara tukeja hami hami pasamujaꞌina. ꞌEnaꞌomo vea kaꞌene sai hirame ninamujaho niꞌaha kwino ꞌaumuna. Nihoꞌo majikari umatematu ꞌonana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesuho ijaho emaa ꞌwaravume paꞌarejumakaviꞌi ꞌurine Kapeniami vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ꞌEꞌeme vea kajikano sorutia natohwijihuni pwea mamaijaho atama ꞌunama rena kwaꞌi ꞌahauma venana. ");
INSERT INTO mcq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Vea kaꞌene hu hejume Jesuho rou ꞌwavuma hejiꞌi hu Jua ꞌahoꞌa irechamiume roe Hu jarime ꞌwarave vuꞌe huni pwea kaji veje maraꞌamarono irechamiume roara. ");
INSERT INTO mcq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pu Jesuni roe jarime ijá ꞌwava Eakaho nimaa nimaaꞌomo Ara hu niꞌajaꞌipisa A mamaa vejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hu ehu núna oja miharena huhuso Sinakoku núna venuhana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ꞌEjume Jesuho aneja vene pu puꞌúmo vaꞌana. Hu ara rori samatuꞌu reꞌeme ijí sorutia natohwa kajara napuhwaha ꞌahoꞌa irechamiume roara. Pura roe Hu ijá ꞌwava Natohwe haha paahinaꞌamana. Ara nuni sei rohuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ijihuni hahi na vwihajujaho na ea siseaꞌomo nara Oni vuhuna areria pana. Ara ma iraru ꞌwarave nuni pwea kajaho maranama. ");
INSERT INTO mcq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na ꞌuꞌo harura rukinaꞌomo sorutia ꞌahoꞌa nuni harura hari hijura. Nara ea ꞌahoꞌa ijá ꞌiavure Vaꞌa! ꞌiavuꞌe pu vaꞌura. ꞌEne pina Roa! ꞌwavuꞌe hu rouna. Na nuni pwea kaꞌene kaukara vejiꞌinijaho ike vena ꞌwavujaho hu venuna ꞌwama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesura ijí henajaho oja hwaꞌusahume aroma ea mapoka kajija ijá ꞌiama Eakara nimaa ronujaꞌinaꞌe ike Isureri opuni kwaa vajakaho ea huaꞌina papiunavuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ea kaꞌene ona apena roa kajijahija sei ꞌunama vaiꞌi kavajaho huni pwea kaꞌene atami ꞌunamajaho nimaranana. ");
INSERT INTO mcq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ijihuni túnaꞌijino Jesuho ara iha Naini vaꞌeme Huni tisaiporua ꞌee ea mapoka pu puꞌúmo vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hu ijí ara kajihuni vwichajiami va ꞌeꞌuꞌeme pu eaꞌe kwananaꞌi ꞌahiume apena roara. Ijí ea kaꞌene kwamajaho amuna pipuni hariha kwinunaꞌomo ijara kwavume ea mapoka pu puꞌúmo roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ꞌEjume vea kaꞌene Natohwijara hu kamajaho Hu nihoꞌo temuvume ijá ꞌwama Niramujaho arema ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ꞌEnarame hu vaꞌe ea kaꞌene suhi mwaviꞌinijaho iji ꞌunavume ea kaꞌene kima vaꞌajaho arema namijara. ꞌEjume Hu ijá ꞌwama Kivasakera Na ꞌwaravukúne ꞌurina! ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ꞌEjume ea kaꞌene kwama kajaho kúꞌo ꞌurine asuma hijiꞌi vuꞌa ꞌwaravume Hu apenapi kúꞌo oahaꞌe mahana. ");
INSERT INTO mcq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ea mapoka nihoꞌo tea junavume pu Godiho taꞌaroha ijá ꞌwava Núni vajakino poropetia niꞌimaꞌura núni roana ꞌee Godiho ehwaha ura vetiꞌi roana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ꞌEjume ike Huni pinana kajaho ꞌwama apene vaꞌe Jutia useme ꞌee ijí ara rora kajaho he parajara. ");
INSERT INTO mcq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Joni oni tisaiporuepo uneunecha mapoka kaꞌene rejume pu kivajaho Joni niꞌwara parajara. ");
INSERT INTO mcq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ꞌEjume Jonira huni tisaiporua noꞌoheꞌi ꞌumenaume roume irechamiume Natohwiji apoma heꞌi vaꞌara. Pu vaꞌe ijá ꞌwava ꞌÚ A ea kaꞌene rohunaꞌe ꞌwaruvajina ho nú ea pinaꞌe saꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pu roe Jesuho piuname apoma ijá ꞌwava Joni Papitisitara irechamúume nú aporaꞌi ꞌahúume roara. ꞌÚ A ea kaꞌene Jonira rohunaꞌe ꞌwarumajina ho nú ea pina ꞌajahe hiꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Vea ijiha kajaho Hu ea mapoka vejume atama sonahie ꞌee haha hianaviꞌina vejume sonahie ꞌavena sisea siomahe ꞌee ea mapoka vejume nia niriara. ");
INSERT INTO mcq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ꞌEjume Hu eha vene ijá ꞌiama ꞌUnama vaꞌe uneka kaꞌene ja kime ꞌee hejajaho Joni ꞌwaraꞌavara. Ea kaꞌene nia supaviꞌina nia niriuꞌe ꞌee irimaꞌina namina ojuꞌe ꞌee ea reporosia rukina maraniuꞌe ꞌee ataa paꞌana vejuꞌe maraniuꞌe ꞌee ea kaꞌene kwamasahiꞌina vejuꞌe ꞌurina hijuꞌe ꞌee Godoni vuꞌa mamaa kaꞌene ea pivusahiꞌina najahuji ꞌwaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ea irara Nuni hahijihunaꞌe pajuꞌamajaho nihoꞌo hu merajahiꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Joni oni tisaiporu vaꞌumakiviꞌi Hu Joni ronarena ea mapoka kajija ꞌwaramana. Hu ijá ꞌiama Vea kaꞌene ja nechiꞌi vaꞌajivajaho ja irakaꞌe kaꞌi vaꞌare? ꞌÚ kurika asiasia ꞌanae varivarimuji kaꞌi vaꞌare? ");
INSERT INTO mcq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ja ijaho irakaꞌe kaꞌirono vaꞌare? Ea pini uneunecha mamaa sama hija kaꞌi ꞌahiume vaꞌara raka? Heha! Ea kaꞌene ijaꞌinaꞌe hijujija ateha mavarasaꞌini same ꞌee ara mamaa kaꞌene kiniepo hijujino hijura. ");
INSERT INTO mcq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ja ijino vaꞌajaho irakaꞌe kaꞌirono vaꞌare? ꞌÚ poropetia kavare? Kaena. Na ja ꞌwaravu. Hu poropetia asitaha hunanuna. ");
INSERT INTO mcq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hua ronarena heha vaji ikaꞌinaꞌe vejara. Heha! Na nuni ꞌona ojiꞌina ranave hu mako Oni unaꞌi vaꞌe Oni ꞌunama amairiꞌena ꞌúmana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na nihoꞌo nimaa nimaa ja ꞌwaravu Ea kaꞌene napapo nahenaari vajijaho ei pini Joni asihuna areria pana. ꞌEnakaivo ea kaꞌene iviamajai Godoni ari maꞌuꞌua renujara nihoꞌo Joni asima paranuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ea kaꞌene takisiaꞌe apejiꞌina ꞌee ea mapoka kajija Godoni ꞌunama mamaa aririji hene vejume Jonira ija ꞌunirame toa vaji samahana. ");
INSERT INTO mcq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ꞌEnakaivo Parasia ꞌee roia Godoni maiji pataarohume Joniho toa pasamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu ijá ꞌiama ꞌÚ Na ea kaꞌene iviamaa urijakihija iraki manura vene pu ea icháꞌinijaho kiꞌejo? ");
INSERT INTO mcq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pu areri sesamaapo maketi vaji hine umaꞌaraviꞌi hijujaꞌina. Pu ijá ꞌumejure Nú hurisia jonaꞌe hwasihajaho ja pajavavara. Nú virisia vejura kaivo ja paniravura. ");
INSERT INTO mcq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Joni Papitisita roe ꞌiruma ꞌaura areme ꞌee toa kisina paijume ja kame ijá ꞌwava ꞌAvena sisei ajimana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ꞌEjume Emaa Puni Hariha roe ꞌiruma ine ꞌee toa ijuꞌe ja ijá ꞌwavo Ea ike kaha. Hu ꞌiruma huhuso maha punaꞌi ine ꞌee toa kisina mapoka ina nanamuna ꞌee ea kaꞌene takisiaꞌe apejiꞌinijija ꞌee ea sisesa puꞌúmo napura venuna ꞌwavu. ");
INSERT INTO mcq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na nimaa nimaaꞌe vwihanareꞌi ꞌwaravu. Ea kaꞌene hena vwiha rukinijija pura icháꞌina vejujara najahujaho pu hena kaviꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ꞌEnakaivo Parasia pini Hu vaꞌe huni sei ꞌiruma iꞌamarono ꞌwamana. ꞌEjume Hu Parasi ijihuni sei ꞌiruma iꞌi ꞌahaume vaꞌe asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ijí ara natohwa vaja kajino napara pina sisea vejiꞌi hinuna. Hu hejume Jesuho roe Parasia kajihuni sei ꞌiruma inu ꞌwavume henarena senisia kavapwa rukina apene roana. ");
INSERT INTO mcq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ꞌEne roe Jesuni túnaꞌi mumora rora Hunijino namine niraviꞌi Huni mumora ꞌaha huni nitua ariha ꞌaruvume huni húmata sapasa kajikano ijaho ukunahiꞌi Huni mumora tituhiꞌi senisia ꞌonahana. ");
INSERT INTO mcq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ꞌEjume Parasia kaꞌene Jesuni ona vejume roajara kamarena ijá rona Eakaho poropetia reꞌipisa Hu naparakaho irane ꞌee ea icháꞌinijara Hu ꞌunamujaho hena kavaꞌa. Ijihuni maijaho hu ea sisea vejiꞌina ronana. ");
INSERT INTO mcq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesura ijá ꞌwama Saimani Na ura unenuꞌu pina a ꞌwaraꞌi ꞌahiu ꞌwamana. ꞌEjume hu ijá ꞌwama Najahiꞌine ꞌwarima ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesura ijá ꞌwama Ea noꞌoheꞌi ea moniaꞌe vajihiꞌini jihuni monia ꞌekara. Ea pina monia mapoka (K100) ꞌekume ꞌee pina monia mapoka (K10) ꞌekana. ");
INSERT INTO mcq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pu noꞌo ijí monia kajaho eha areria pavenahume hu pu niꞌajihe ꞌwaravume pu eha pavajahara. ꞌÚ ea iraka saꞌinijara hu oja nihoꞌo natohwaꞌe mahane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimanira eha vene ijá ꞌwama Na vwihajujaho ea kaꞌene monia natohwaꞌe ꞌekajarana ꞌwamana. ꞌEjume Hu ijá ꞌwama Oni eha ijaho nimaa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ꞌEjume Hu aroma napara kaji kaviꞌi Saimani ijá ꞌwama ꞌÚ a naparakaho nikamo? Na oni sei routa vo a Nuni mumora kehuni toa pamihana kaivo hu huni nitui Nuni mumora some ꞌee huni húmata sapasi Nuni mumora sirua ukunana. ");
INSERT INTO mcq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A Na paꞌajorime ura manura veniana kaivo Na iki rouji rene hu hine Nuni mumora tituhiꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A senisia paapena Nuni húmatakaho onihana kaivo hu Nuni momora senisiꞌi ꞌonihana. ");
INSERT INTO mcq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na nimaa nimaa ꞌwaravo Huni sisea mapokijaho nihoꞌo vwihajume paꞌarenana. Ijihunaꞌe hu Na oja natohwaꞌe mihana. Ea irahuni sisea maꞌuako paꞌarenajaho hu maꞌuakuꞌwi oja mihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ꞌEjume Jesura napara kajaho ijá ꞌwama Oni sisea vwihane arevu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ꞌEjume ea ꞌahoꞌa kaꞌene ijí asuma hija kajipo kosarame ijá ꞌwava Eakaho iranaꞌomo sisea ꞌuꞌo vwihane aremo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ꞌEnakaivo Jesura napara kajaho ijá ꞌwama Ara nimaa ronujara vejume maranaanakúne matauma vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naꞌii pini Hu ara mamaꞌina ꞌee ara maꞌuꞌumaa kajino ꞌurahe ojiꞌi Godoni vuꞌa maa maiuꞌina kaꞌene Godoni ariji huni vuꞌa najahana. Huni tisaiporu iropu ropu noꞌo pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Napara ꞌahoꞌa kaꞌene ꞌavena sisea ajimahiꞌina ꞌee ꞌahoꞌa puni atama vejume maraniꞌinijihi puꞌúmo vaꞌara. Meri kaꞌene Matarinina ꞌwavujihuni haha ꞌaha kajino ꞌavena sisea iropu noꞌo hiꞌeme siomahana. ");
INSERT INTO mcq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ꞌEne Chusa kaꞌene Heroti oni kukua ꞌajohiꞌini jihuni napara Joanaho ꞌee Susana ꞌee napara ꞌahoꞌa kajipuhipo puni monijikano pu niꞌajihara. ");
INSERT INTO mcq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ea mapoka ara ꞌoiꞌoi vaji roe Hu kaꞌi ꞌahiuꞌe roajivume Hu haa ikaꞌinaꞌe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ea pina huni ꞌina ꞌoꞌi ꞌahaume vaꞌana. Hu ꞌina kajaho atoꞌaruvume ꞌahoꞌa arihe ꞌunamutoi navume emaapo tautiume ꞌee ꞌahoꞌa ukapo roe ijara. ");
INSERT INTO mcq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ꞌAhoꞌa muna ꞌahi arihara ꞌee pu riama ajivara kaivo sirua paꞌajihunaꞌe sarasahara. ");
INSERT INTO mcq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ꞌAhoꞌa ija sisea oma rukina vaji arihe riavara kaivo ija kajara ꞌurine raurihume pamarasahara. ");
INSERT INTO mcq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ꞌEnakaivo ꞌahoꞌa mweꞌa mavarasaꞌina ꞌahi arihe riame maa mapoka mapokaꞌe (100) rejara ꞌiamana. ꞌEe Hu ijá ꞌiama ja ataa rukina reꞌavajaho heha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ꞌEjume Huni tisaiporu apoma ijá ꞌwava Ike haa ikehuni maijaho irakaꞌe rona ꞌwarumo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ꞌEjume Hu ijá ꞌiama Godoni ira kaꞌene vaji namujaho ja samaumai ꞌwaravuꞌe ja hena kavu kaivo ea ꞌahoꞌakija hai ꞌwaravuꞌe ijihuni maijaho pahena pakavu. ");
INSERT INTO mcq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ike haa ikehuni maijaho ikena. ꞌInijaho Godoni Irakena. ");
INSERT INTO mcq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ꞌIna kaꞌene ꞌunamutoi arihajihuni maijaho ea pu Godoni ira heju kaivo ꞌavena siseijara roareꞌe ijí vuꞌa kajaho oja vaja puna kajino ꞌetujiha vaꞌuna. Vejuroꞌi pu Noinnimaa roje Godira pu niꞌajiꞌamarono avanuna. ");
INSERT INTO mcq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ꞌIna kaꞌene muna ꞌahi arihajihuni maijaho ea Godoni ira hene teamanaꞌejuꞌe apejura kaivo ira kajaho maiꞌo hamia oja vaja puna chinuma pasamuna. Pu maꞌuako nimaa rojura kaivo vea kaꞌene sisei puni haha ꞌahi renujaho pu marako rana vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ꞌIna kaꞌene ija sisea oma rukina vaji arihajihuni maijaho ea Godoni ira hejura kaivo puni temuka vwihane ꞌee uneunecha ꞌee moniaꞌe vwihane ꞌee temarijara rarejuꞌe pataarohura. ꞌEjuꞌe puni ꞌina renuna vo maiꞌo patuvura. ");
INSERT INTO mcq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ꞌIna kaꞌene mweꞌa mamai arihajihuni maijaho ea Godoni ira hene puni oja vaji irechavukame pu hina vena apena vaꞌu vaꞌuꞌe vaꞌe pu ꞌina nihoꞌo maa rejura. ");
INSERT INTO mcq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ea maiꞌo ira ꞌene siꞌuara vaji paapúrinanavura ꞌaho puni suha harijino ranavuꞌe namuna kaivo Hu ira kajaho iraꞌe irechavuꞌe navujino navukame pu ea ijino kaviꞌi roajivura. ");
INSERT INTO mcq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ꞌEne unenuꞌu pina apúrinanavuꞌe namujaho roe samaahirahuna ꞌee unenuꞌu pini hemi nave pakahuna kaivo mapoka kajija samaahirave kihuna. ");
INSERT INTO mcq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ꞌEnakúne hami heha! Ea irara mapoka rukinaꞌe reꞌamajaho kúꞌo mapoka huri vajahuna. ꞌEnakaivo ea irara paꞌanaꞌe reꞌamajaho huna kaꞌene maꞌuako navujaho ꞌetujahuna ꞌee kukua ꞌahoꞌa ꞌekaꞌiro vwihajiꞌi hiꞌamajaho ꞌetujahuna. ");
INSERT INTO mcq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Huni oha ꞌee ꞌuꞌuhwaha roara kaꞌi ea nihoꞌo ani rejumakame pu paroe Huni roara. ");
INSERT INTO mcq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ea ꞌahopo Hu ijá ꞌwava Ohuna ꞌee ꞌuꞌuhuana kameho maꞌahi Aaꞌe kaꞌirono ꞌúviꞌi namiju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hu eha vene ijá ꞌiama Nuni oha ꞌee Noinꞌuꞌuhija ea kaꞌene Godoni ira hene vejiꞌinijina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naꞌii pini Hu Huni tisaiporu puꞌúmo sisima ꞌahi ajima ijá ꞌiama Roe ja puꞌúmo karaꞌahuni vaꞌa ꞌiavume pu aneja vene vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pu vaꞌajiꞌeme Hu ariha vaꞌe sisima vaji nenana. ꞌEꞌeme puura natohwa ijí soha ꞌaha kajino hiramarena soha kajara ameurahe sisima vaji ariharena ituꞌoꞌiro ꞌahaume vejumakame pu nihoꞌo vahuna areri parenana. ");
INSERT INTO mcq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ꞌEjume pu ꞌurina vaꞌe Hu sae ijá ꞌwava Natohwe! Natohwe! Nú nikwamasaꞌi veju ꞌwavara. ꞌEjume Hu ꞌurine puura kajaho ꞌurarahume areme ꞌee soha kaꞌene amenajaho paꞌareꞌeme soha kajaho nihoꞌo mavarasa renana. ");
INSERT INTO mcq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ꞌEnarena Hu pu ijá ꞌiama ꞌÚ jara nimaa rojujaho ichine ꞌiamana kaivo pu nihoꞌo oja hwaꞌusahe tea junavume aposarame ijá ꞌwava ꞌÚ ikaho Ea irane? Hu puura ꞌee soha ꞌuꞌo ꞌwaravuꞌe Huni ira hene veju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ꞌEnareja pu vaꞌe Kekasinisi puni kwai Karari ropunaꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hu karino amari varihajaho ara kajiꞌura ea pina ꞌavena sisei ꞌaha jora ajiviꞌina piunamana. Hu vwiha paꞌa ꞌuraha one ꞌee ara pahinuna vo vaꞌe euchi hinonuna. ");
INSERT INTO mcq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ꞌEnaꞌomo vea kaꞌene Jesu kamajaho hu ꞌona arihe mweꞌa ꞌahi Huni unaꞌi ninaviꞌi ira ajira ijá ꞌumena Jesu kaꞌene Godi nihoꞌo Natohwijihuni Harihakera A na icháꞌina ꞌahiꞌiro ura renao? Na A jariravukúne paruarihe siseꞌi ꞌahiꞌamana ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hu ijaꞌina ꞌwarama jihuni maijaho Jesura ꞌavena sisea kaꞌene huni haha vaji hijajaho ꞌejahie ariha ꞌiamana. Naꞌia mapokaꞌe ea kajaho jihevuꞌukame ea ꞌahoꞌa hu apene kamome ranavuꞌe namuna kaivo hu ꞌurine senia kajaho turame irechaꞌikaꞌi nechiꞌi vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesura apoma ijá ꞌwama Oni iha irane ꞌwavume hu ijá ꞌwama Nuni iha Mapoka ꞌwamana. Ijihuni maijaho ꞌavena sisea mapokaꞌe hua ajivara. ");
INSERT INTO mcq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ijí ꞌavena sisea kajipo Hu jarimaa ijá ꞌwava Paatoꞌarumuꞌe nú maꞌoa vaji vaꞌavara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Maha mapokaꞌe puni rori hareha ꞌaha kajino ꞌiruma ine ꞌurahojaraꞌomo ijí ꞌavena sisea kajipo Hu jarimaa ijá ꞌwava Nú irechamúe kare maha karehi súmaha ꞌwavara. ꞌEjume Hu pu irechamiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ꞌEjume ꞌavena sisea kajija useme maha kajihipuni vaji vaꞌume maha kajija hareha ꞌaha kajino ninukujaha vaꞌe rarahi arihe úi imwasamiume kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ea kaꞌene ijí maha ꞌajoha hija kajipo uneka kaꞌene rena kaji kamareja vaꞌajime ea kaꞌene ari hijujija ꞌwarame ꞌee ea kaꞌene ijino rori hinojajija ꞌuꞌo ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ea mapoka Hura raka kaꞌene vejume renaji kaꞌi ꞌahiume vaꞌajivara. ꞌEjume pu roiꞌi kavuꞌe ea kaꞌene ꞌavena sisei súmahiꞌinaka Jesura vejume maranajaho Jesuni mumora rora kajino vwiha irame asuma mavarasaꞌinaꞌe hijume pu ijí kavajihunaꞌe tea junamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ea kaꞌene ꞌavena sisei ajiviꞌiniji vejume maranaji kavajipo ea mapokijija ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kekasinisi ora ea mapoka kajija tea junavume Hu vaꞌamarono ꞌwaravara. ꞌEjume Hu sisima ꞌahi ajima toa ropunaꞌi ꞌunama vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ꞌEjume ea kaꞌene Hu vejume ꞌavena sisea usevajara Hu huꞌúmo vaꞌi ꞌahaume jarima ijá ꞌwama ꞌWarive na A huꞌúmo vuꞌuma ꞌwamana kaivo Jesura hu raname ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ꞌUnama ari vaꞌe Godira iraka kaꞌene a vetaaji ea ꞌwaraꞌamana ꞌwamana. ꞌEjume ea kajaho ara mamaꞌina mapoka vaja kajino vaꞌe Jesura iraka kaꞌene huaꞌe vetiajaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ꞌEꞌeme Jesuho toa ꞌona karaꞌi va ꞌeꞌujume ea mapoka kaꞌene ijí Huaꞌe ꞌajaha hijajipo Hu ꞌajovara. ");
INSERT INTO mcq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","ꞌEꞌeme heha! Ea pina Jairasina ꞌwavura. Hu Sinakoku ꞌajohiꞌina natohwaꞌomo roe ijí ꞌeꞌunana. ꞌEne hu mweꞌi ꞌona arihe Jesuni mumora rori naviꞌi jarime ijá ꞌwama Nuni ꞌapaja juara huni iropu ropu noꞌona vo kwaꞌi venukúne nuni sei roe veje maranama ꞌwamana. Jesuho vaꞌejuꞌe ea mapoka Huni rora kajaho ani rejara. ");
INSERT INTO mcq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ꞌEꞌeme napara pina juara iropu ropu noꞌo ꞌai vurajukame hu vaꞌe juketa puni naꞌia mapoka amairiahura kaivo hu pamaranuna. Hu monia mapoka ꞌúsia ꞌimenuna kaivo venahujaho pamaranuna. ");
INSERT INTO mcq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hu ea vaja kajino Huni túnaꞌi rou vaꞌo Huni ateha ꞌunavume huni ꞌaa kaꞌene vuramajaho niꞌaha kwino paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesura ijá ꞌiama Ea irara Na vwenimane? ꞌiavume pu ea mapokaꞌe hevara. ꞌEjume Pitara ijá ꞌwama Natohwe ea mapoka Oni rori ani rejujihunaꞌe puruva renu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ꞌEnakaivo Jesura ijá ꞌiama Oo ea pini Na vwenimana. Ijihuni maijaho Nuni harura va ꞌeꞌunu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Napara kajaho nikavuma kimareme tatoviꞌi roe Jesuni unaꞌi ariha ninamana. ꞌEjume ijí ea rira kajino nahame irakijihunaꞌe Hu vwevumakame icháꞌinaꞌe niꞌaha kwinu maranajaho nahama ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ꞌEjume Hu ijá ꞌwama Nuni ꞌapaje ara nimaa ronujara vejume maranaana. ꞌEnakúne matauma vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hu ijí hine ꞌwaraꞌeme ea pina Sinakoku ꞌajohiꞌini jihuni sei rene ro ijá ꞌwama A hine Najuhiꞌina apene iha vetiuna arema. Oni ꞌapaja nikwamanakúna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ꞌEnakaivo Jesura ijí henarena Jairasi ijá ꞌwama Jumujaho areꞌi kaivo nimaa rojakame oni ꞌapaja maraꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pu va ijí usemareja Hu sea vaji vaꞌi ꞌahaume ea ꞌahoꞌa tanurihume pu vaja pavaꞌara kaꞌi Pita ho Jemisi ho Joni ho ꞌee huni oma ꞌee oaha ijano ꞌwaravume vaji vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ea kaꞌene ijino hijajaho chora hijiꞌi niramaruvara. ꞌEjume Jesura ea kajija ijá ꞌiama Niramaruvujaho areha. Napaiseakaho maiꞌo pakwamana kaivo manenukúna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pu Hu nihoꞌo apena ꞌijahara. Ijihuni maijaho pu hena kavajaho hu nikwama jihunaꞌe pu Hu ꞌijahara. ");
INSERT INTO mcq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ꞌEnakaivo Jesura Huni ija kajino ꞌunama apene ꞌurijiꞌi ijá ꞌumena Napaisekera ꞌurina ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Huni ꞌavena kúꞌo ꞌunama roume hu niꞌaha kwino ꞌurijume Jesura ijá ꞌiama ꞌIruma vajaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Huni oha ꞌee oma nihoꞌo oja hianavara kaivo Jesura ea ꞌahoꞌa iraka kaꞌene renajaho paꞌwarahunaꞌe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Hu Huni tisaiporu ꞌumenaume harura kaꞌene ꞌavena sisea siomahuna ꞌee atamaꞌe veje sonahihunijaho mihana. ");
INSERT INTO mcq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ꞌEnarena Hu irechamiume pu vaꞌe Godoni arijihuni maijaho ea mapokaꞌe ea ꞌahoꞌa najahe ea atama rukiniji veje sonahiꞌavarono vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesura ijá ꞌiama Ja vaꞌajiꞌavajaho uneunecha paꞌeka vaꞌavara. Pijuha kaꞌene pijumojujaho paꞌekaꞌavare joni tuja paꞌekaꞌavare joni ꞌiruma paꞌekaꞌavare joni monia paꞌekaꞌavare ꞌee setia ꞌahoꞌa paꞌekaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ja vaꞌajiꞌeje ea irahipo ja hami ꞌajorave kiꞌavajaho puni sea kajiru hinuvaꞌo ara kajaho areꞌi kaivo ꞌurine ara pini vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ꞌEnakaivo ea irahipo ja paꞌajorame vuꞌakake paheꞌavajaho ara kajaho areꞌi kaivo joni mumora ꞌahi túa kaꞌene navujaho taireve ariꞌamana. ꞌEjakame ijara pu namahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pu arename vaꞌajime arara kajino Godoni Ira mamaa kaji najahe ꞌee ea atama ꞌuniraviꞌinijijahija vejume maraniara. ");
INSERT INTO mcq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heroti kaꞌene ꞌajohaꞌinijara uneka kaꞌene renuji henajaho ea ꞌahopo ijá ꞌwava Joni kúꞌo ꞌurinana ꞌwavuma henarena hu puruva rejumakame nihoꞌo jumana. ");
INSERT INTO mcq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ea ꞌahoꞌa ijá ꞌwavare Iraija kúꞌo ꞌunama roana ꞌwavume ꞌahoꞌa ijá ꞌwava Poropeti nitama ꞌwaraviꞌinijara kúꞌo ꞌurina roana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herotira ijá ꞌiama Nara Joni oni húmata ahatumahuta kaivo Ea kaꞌene iviamaa pinana ꞌurijuꞌe na hejukaho irarane? ꞌiamana. ꞌEnarena hu Jesu kaꞌi ꞌahauꞌe niriꞌi hinuna. ");
INSERT INTO mcq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ꞌEnarena apasoru ꞌunama roe Jesu pura raka kaꞌene vejajaho ꞌwaravara. ꞌEjume Hu pu aherame ara kaꞌene Petasaita ꞌwavujino pu pusumano vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ꞌEjumakame ea mapoka kajipo henareja pu ꞌararihia vaꞌajivara. Hu pu ꞌajorame ꞌee aneja vene Godoni arijihuni vuꞌa ꞌwarame ꞌee ea kaꞌene venae maranihuna ura renajija vejume maraniara. ");
INSERT INTO mcq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Vea vaꞌoꞌirono veꞌeme Huni ea iropu ropu noꞌo roe ijá ꞌwava Ea ikija irechamie arara ijino vaꞌe ꞌiruma sarame ine ꞌee notua. Ijihuni maijaho ike kwaakaho savasakúna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ꞌEnakaviꞌi Jesura ijá ꞌiama Jara ꞌiruma vajihe ija ꞌiamana. Pu eha vene ijá ꞌwava Nú kija noꞌone ꞌee puretia iropu ijano navu. A ura renaꞌamajaho nú vaꞌe ꞌiruma ꞌimene roe ea kija vajihe ija ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Parua nihoꞌo mapoka mapokaꞌe (5,000) hijara. Hu Huni tisaiporu ijá ꞌiama ꞌWarave pu nia ani ani ea mapoka (50) ruha pini hije vu ruha pini ea mapoka (50) hina apena vaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Huni tisaiporu Hura ꞌwarama jaꞌinaꞌe vene ꞌwaravume pu asuma hijara. ");
INSERT INTO mcq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesura puretia iropune kija noꞌo ꞌeke akúpi ꞌahi nia niriꞌi Godiho teamani ꞌwaꞌi kaivo tuachame Huni tisaiporua vajihume pu ꞌeke ea kaji vajihara. ");
INSERT INTO mcq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pu ijume túꞌamana. ꞌEjume pu pwina kaꞌene túꞌavume irechavajaho tuja iropu ropu noꞌo ꞌeke vejume ituꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naꞌii pini Jesuho huhusu Huni tisaiporua puꞌúmo hine siporua ꞌonana. ꞌEnuvaꞌo Hu pu aporama ijá ꞌiama Ja vwihajujaho ea mapokakija Na ea irane ꞌwavure? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pu Hu ijá ꞌwava Ea ꞌahoꞌa A Joni Papitisitana ꞌwavume ea ꞌahoꞌa A Iraijana ꞌwavuꞌe ea ꞌahoꞌa A poropetia nitama hijajipo kúꞌo ꞌurine hinu ꞌwavura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ꞌEnakaivo Hu pu aporama ijá ꞌiama Ja icháꞌina vwihajo? Ja Na irana rojo ꞌiamana. Pitara ijá ꞌwama A Keriso kaꞌene Godoni rena roajina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ꞌEjume Hu rurame ea paꞌwaraꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hu pu ijá ꞌiama Ema Puni Harihijaho ea mamaꞌina ꞌee Sikuraipia epo veje haha niꞌimaꞌura hiame ꞌee pu pataaroꞌeja. ꞌEne pu Hu ꞌanae kwame naꞌia noꞌopisu namareje kúꞌo ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ꞌEnarena Hu pu ijá ꞌiama Ea irara Nuni túnaꞌi roꞌi veꞌamajaho hu huni oja makame mweꞌa kakino huni uneunecha mapoka makiꞌi kaivo hu huni korosia apene Nuni túnaꞌi roꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ea irara huni hiiji ori niꞌajaraꞌamajaho huni hiijaho ranahuna. ꞌEne ea irara huni hiiji Nunijihunaꞌe Godoni vuꞌa mai maiuꞌini jihunaꞌe ranaꞌamajaho hu huni hia ꞌunanahuna. ");
INSERT INTO mcq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ei pini uneunecha kaꞌene mweꞌaka kehunijaho huna reranaꞌeje hia nimaa nimai ijí asinaꞌipisa hu maa iraka apejaꞌe? ");
INSERT INTO mcq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ea irara Nunijihunaꞌe Na pataarorihe ꞌee Nuni ira pataaroꞌamajaho vea kaꞌene Emaa Puni Harihijara Huni harura ꞌee ꞌona ojiꞌina arira maijihipuni harura ꞌee Amoni harura vaji roꞌamajaho hu ꞌuꞌo pataarohuna. ");
INSERT INTO mcq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na nimaa nimaa ja ꞌwaravu. Ea kaꞌene ja ike namijukija ꞌahoꞌa maiꞌo pakwamasaꞌeje Godoni Ara roe kahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hura ꞌwaramajaho naꞌia iropu noꞌopisu paꞌareꞌeme Jesura Pita ho Joni ho ꞌee Jemisi ho ijano aherame huriꞌa ꞌahi siporuaꞌe ꞌoꞌi ꞌahaume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hu hine siporuaꞌe ꞌoꞌeme Huni niura nihoꞌo taꞌarohe aniꞌina rene ꞌee Huni ateha nihoꞌo sajasaꞌinaꞌe ꞌee hanajiꞌinaꞌe renana. ");
INSERT INTO mcq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Niꞌaha kwino ea noꞌoheꞌi pu puꞌúmo namine vuꞌa ꞌwavara. Ea kajija Iraijaꞌo Mosisi una. ");
INSERT INTO mcq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pu nihoꞌo hanana paraꞌeme namine Hu huꞌúmo Hura raka kaꞌene maiꞌo Jerusaremi venareje vahunijihuni vuꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ho napuhwa puꞌúmo nii vahivume notuaraꞌomo ꞌurine nia niriuniꞌeme Huni hanajiꞌina ꞌee ea noꞌoheꞌi pu puꞌúmo namijajija kivara. ");
INSERT INTO mcq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ea kajija Hu raname vaꞌejuꞌe Pitara Jesuho ijá ꞌwama Natohwe nú mamaa vena ro hijara. Nú ara vene pina One pina Mosisi one pina Iraija onaꞌe vehuna ꞌwamana. ꞌEnakaivo hu nimaa raka kaꞌene ꞌwaramajaho pavwihajiꞌi ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hu ijí ꞌwaraꞌeme ꞌimiti puni huri saturihume Huni pwehija nihoꞌo tea junamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ꞌEꞌeme ijí ꞌimitia vaja kajino ira rena rouma heꞌeme ijá ꞌiama Ikaho Nuni Hariha kaꞌene Nara iji pijahujinakúne Huni ira heꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ꞌEꞌeme vuꞌa kaꞌene hejajaho paꞌareꞌeme Jesuho Huhusu ijí naminana. Ijihunaꞌe pu iranoꞌa areme ira parasahareja uneka kaꞌene vea kajino pu kavajaho ea ꞌahoꞌa paꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ijihuni súꞌuha kajino huriꞌa areꞌi kaivo arihe roꞌeme ea mapoka kajipo roe Hu piunavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Heha! Ea pina ea rira kajino namine ijá ꞌumena Najuhiꞌine na A jariravukúne nuni hariha ike kama. Hu nuni hariha nikwinuꞌwina. ");
INSERT INTO mcq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ike kama! ꞌAvena sisei kajara ajivuꞌe emaavajiꞌi ꞌunama apene onavuꞌe mweꞌi ꞌone kuchikuchiviꞌi ira sapa ani reꞌejuꞌe namuna. Hu majamano vejuꞌe hu hiamuna kaivo naꞌia kwinu kwino paajima rurahuna. ");
INSERT INTO mcq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na Oni tisaiporua jarirame pura veje useꞌavarono ꞌwaravura kaivo pu areri pavejara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesura eha vene ijá ꞌiama Panimaa rojiꞌina kaꞌene ea sisemaakije panimaa rojo? Na naꞌia icharu ja puꞌúmo hiꞌejo? ꞌEne Na naꞌia icharu ja najaha apene vaꞌejo? ꞌiamana. ꞌEꞌikaivo vu ijiꞌa ea kajaho ijá ꞌwama Oni hariha ikino ahema roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hu sesamaa kajaho roꞌeme ꞌavena sisea kajara ꞌanaa piꞌonavume mweꞌi ꞌone kuchikuchimana. ꞌEjume Jesura ꞌavena sisea kajaho ꞌwaravume ꞌariha vaꞌume sesamaa kajaho marajumakaviꞌi omaha mahana. ");
INSERT INTO mcq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ea kajipo ijí Godoni harura natohwa kaji kavajaho oja hwaꞌusahana. Pu ea mapoka ijí Hura uneunechaka mapoka kaꞌene venaji kamareja oja hwaꞌusahaꞌeme Hu Huni tisaiporua ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Nara ꞌwaravujaho nihoꞌo parunamiꞌavara. Emaa Puni Hariha apena ea ꞌahopuni ija tahi ranahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ꞌEnakaivo Hura ꞌwarama jihuni maijaho maiꞌo pahejara. Pura hehunijaho vaji namujara juvumakame pu pahejara. ꞌEnakaivo pu tea junavume paapovara. ");
INSERT INTO mcq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ꞌEnarena Huni tisaiporu puni vaja kajaho ea irara niꞌina ꞌwamareja hine nakaravara. ");
INSERT INTO mcq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesura pu iraka kaꞌene vwihajujaho kimarena sesamaa pina apena roe Huni rori ranavume namiꞌeme ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ei pini Nunijihunaꞌe sesamaa ikeraꞌina hami ꞌahaꞌamajaho hu Naaꞌe hami ꞌahihuna. ꞌEne ea irara Naaꞌe hami ꞌahiꞌamajaho Godi kaꞌene Naaꞌe ranamiume rouji ꞌajome hami ꞌahaa avahuna. Ea irara maꞌuꞌua rena joni vajakino hiꞌamajara ea natohwa rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jonira eha vena ijá ꞌwama Natohwe nú kaꞌeme ea pina Oni ihi ꞌurahiꞌi ꞌavena sisea siomahume nú hu areꞌamarono ꞌwaravara. Ijihuni maijaho hu nú puꞌúmo paꞌurahe onuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesura hu ijá ꞌwama Ja pakiꞌeje tanuꞌuraꞌava. Ijihuni maijaho ea irara ja puꞌúmo paninakaramujaho hu ja puꞌúmo renuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hura vahuni vea nituraꞌeme ꞌurine aneja vene Jerusaremi vahuna vwihajiꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hu ijí vaꞌamarono ea nimako irechamiume pu vaꞌe Sameria opuni ari uneunecha ꞌeke amairiꞌirono vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ꞌEnakaivo ara kajiꞌurijija pataarohara. Ijihuni maijaho Hu Jerusaremi vaꞌujihunaꞌe pu pataarohara. ");
INSERT INTO mcq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ꞌEjume pu ijí kamareja Huni tisaiporu Jemisiꞌo Joniꞌo ijá ꞌwava Natohwe A ura renaꞌamajaho nú ꞌwarave vena kahi akúpa ꞌahi rena ariha roe pu renaꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ꞌEjume Hu aromakiviꞌi pu ꞌuraraha ijá ꞌiama ꞌAvena iraka saꞌinijara avanujaho ja maiꞌo pahena pakavu? ");
INSERT INTO mcq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ijihuni maijaho Ema Puni Harihijara roajaho emaa puni hia patirakuꞌi ꞌahaume roana kaivo emaaꞌe niꞌajiꞌi roana ꞌiamana. ꞌEnareja pu ari pini vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ꞌEjume pu ꞌunama toi vaꞌeme ea pini Jesu ijá ꞌwama Kwaa ichihichihi vaꞌamajaho na A huꞌúmo vuhuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ꞌEjume Jesura ijá ꞌwama Achiꞌa mweꞌi vaji ahejure ꞌee uka nesa rukina kaivo Ema Puni Harihijara ruha kaꞌene nene ꞌee siheria vena hihuna paꞌana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ꞌEjume Hu ei pina ijá ꞌwama ꞌArarihie roa ꞌwamana. ꞌEnakaivo hu ijá ꞌwama Natohwe ijinakúne asinamie na marako vaꞌe nuni oma apene kwananavuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ꞌEnakaivo Hu ijá ꞌwama Ea kaꞌene kwaviꞌina kajaho makaꞌeje kwamasahuna kajipo apena vaꞌe ranava kaivo a vaꞌe Godoni arijihuni vuꞌa ea ꞌahoꞌa ꞌwaraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ꞌEjume ea pina ꞌuꞌo ijá ꞌwama Natohwe na ꞌararihaꞌejakúne ꞌwive na vaꞌe kachihu nuna marakoꞌa ꞌajorame rouma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ꞌEjume Jesura ijá ꞌwama Ea irahipo aneja vene juara mejiꞌi hine majamano aroma niriujija nihoꞌo Godoni ꞌunamijino vahuna areri pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ijihuni túnaꞌi Natohwijara ea mapoka mapoka (70) iji pijihe ea noꞌo noꞌo irechamiume pu urasahe Hura ara ꞌee kwaa kaꞌene rohunijino vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hu pu ijá ꞌiama ꞌIruma mapoka marana navu kaivo ea kaꞌene ijihi ꞌeke ahuma usehunijaho nihoꞌo kwinu kwinuna. ꞌEnajihunaꞌe ja Natohwa kaꞌene ꞌiruma anesuri jihuni siporua ꞌojakame Hura ea ꞌahoꞌa irechamie ijí ꞌiruma kaji ꞌeka ahuma useꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Heha! Vaꞌajiha! Na ja irechamiujaho areri sipia ꞌuꞌua ꞌuanea puni vaji irechamiu jaꞌinaꞌe irechamiu. ");
INSERT INTO mcq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ja pausia paꞌeke tuja paꞌeke mumora hwana paꞌeke ꞌee ea ꞌunamutoa paꞌajoraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ja vaꞌajime ea ꞌahopuni sei vaꞌavajaho marakuꞌa ꞌajorame ijá ꞌiꞌavara Matauviꞌinijaho seikino ja puꞌúmo naꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ea kaꞌene sea kajino hinujaho matauma hijujaho oja mahiꞌinaꞌe reꞌamajaho ara ꞌuꞌo matauma hihuna kaꞌene ꞌajomajaho makave ijino hu huꞌúmo naꞌamana. ꞌEnakaivo paꞌanaꞌe reꞌamajaho oni matauviꞌinijaho kúꞌo apene vaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ijí sea kajino hijiꞌi ꞌiruma iraka kaꞌene vajiꞌavajaho iꞌavara. Ijihuni maijaho ea kaꞌene kaukaraa vejiꞌina puni eha apejura. ꞌEne ja paarihe sei pini ajima ariha ajima ariha oꞌavara kaivo sea nikwinu hiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ja ari vaꞌeje ea irahipo ꞌajorame ꞌiruma irakaꞌe joni unaꞌi irechave kiꞌavajaho iꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Atakina kaꞌene ara kajino hijujija veje maranie ꞌee ea kajija ijá ꞌwaraha Godi oni arijaho joni romai roana ꞌiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ꞌEnakaivo ja ara pini vaꞌeje pu ja paꞌajorave kiꞌavajaho vaꞌe maꞌaha riri naminareje ijá ꞌiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Núni mumora hari saina kaꞌene amama navujija taireve ariꞌeje Godoni ara nimaa nimai joni rori roana kaivo ja pataarohu ꞌiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ꞌEnakaivo Na nimaa nimaa ꞌwaravu. Vea kaꞌene ꞌotua veꞌavari veijaho ea kijahija nihoꞌo niꞌina aniꞌina rehuna. Kwaa kaꞌene Satami ꞌwavujino renajaho asimareje nihoꞌo aniꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ja ea kaꞌene Korasini hine ꞌee Petasaita hijujija eha sisea apehuna. Ijihuni maijaho Na joni ari uneunecha ea areri pavejura vejuꞌukame ja panimaa roju kajihunaꞌe ja eha sisea apehuna. Na Taia ꞌee Sairani ijaꞌinaꞌe veꞌipisa pu nihoꞌo marakuꞌa puni sisea niaremamaa arevaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ꞌEnaꞌomo na nimai ja ꞌwaravu. Vea kaꞌene Godira mweꞌakaki ꞌotua venuni veijaho kwaa iha Taia ꞌee Sairani ijija jara eha kaꞌene niꞌimaꞌura apeꞌavajaꞌinaꞌe paapehuna. ");
INSERT INTO mcq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ꞌEnakaivo ꞌú ja Kapeniami orakija ja ma joni haha kakino ꞌeka kahino Godoni ari vaꞌiro avajo? Ja nihoꞌo kwaa kaꞌene veni renuni kwaa ijino (Hetisi) vahuna. ");
INSERT INTO mcq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ea irahipo joni ira heꞌavajaho pu Nuni ira hene avahuna. Ea irahipo jaaꞌe pataaroraꞌavajaho Naaꞌe pataarorihe avahuna. Ea irara Naaꞌe pataaroriꞌamajaho hu Godi kaꞌene Naaꞌe ranamiume rouji pataarohe avahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ea mapoka mapoka (70) kaꞌene irechamiume vaꞌajija ꞌuname mariꞌuviꞌi ijá ꞌwava Natohwe Oni ihi rejume ꞌavena sisesa núni ira nihoꞌo hene vejara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ꞌEjume Hu ijá ꞌiama Na kaꞌeme Setani kahino akúpa ꞌahi vea punaꞌi piꞌiꞌeme ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ike heha! Nara ja harura mihujihunaꞌe ja tapara ꞌee suaka sisea kaꞌene amari hiju jihipuni ꞌahi namihuna kaivo pu pavenae kwamasahune ꞌee naka mapoka kaꞌene hijujija maiꞌo ja paruarahihuna. ");
INSERT INTO mcq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ꞌEnakaivo ꞌavena siseapo joni ira hene vejajihunaꞌe ja patea manaꞌavara kaivo joni iha kaꞌene kahi akúpa ꞌahi vejuꞌe namujihunaꞌe teamanaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ijí vea kajino Godoni ꞌAvenijara vejume Hu teamaꞌeme siporua ꞌone ijá ꞌwama Amo kaꞌene akúpa mweꞌa ijihuni Natohwijiꞌo Na teimani ꞌwavujihuni maijaho Ara uneunechakija ea kaꞌene hene vwihajiꞌinijihija nuhiume vaji navume pu pakavumakiviꞌi kasimaaru najahana. Amo Oni ura ijaho ijara ura renana. ꞌEjumakame A avanana. ");
INSERT INTO mcq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ꞌEnakaivo uneunecha kaꞌene mapokijija Amora Nuni ija tahi irechamana. Ijihunaꞌe eaka mapokijija Godoni Harihijaho pakama pahejura kaivo Amora hena kamuna. ꞌEjuꞌe eaka mapokijija Amoho pakama pahejura kaivo Hariahi kama henuna. ꞌEnakaivo Hariahi ura renujiru Omaha najahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ꞌEnarame Jesuho aroma Huni tisaiporu kiviꞌi hemi ijá ꞌiama Nia kaꞌene jara kivuke kihunijija merajihana. ");
INSERT INTO mcq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ꞌEnajihunaꞌe nitama poropetia ꞌee kinia mapoka pu ura jara kivujaꞌinaꞌe pu kiꞌiro ꞌahiara vo pu nihoꞌo areri pakivara. ꞌEne pu jara heju kajaꞌinaꞌe heꞌiro ꞌahiara vo pu nihoꞌo areri pahejara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ꞌEnakaivo heha! Roia pini roe Hu vena kaꞌi ꞌahaume ijá ꞌwama Najahiꞌine na icháꞌinaꞌe vene majama hihuna apeꞌejo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hu ijá ꞌwama Varapa vajijaho irakaꞌe vejare? A icháꞌina taha kamo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ꞌEjume ijí ea kajara eha vena ijá ꞌwama A oni Natohwa kaꞌene Godiho niꞌaha kwinu oni oja ꞌee oni ꞌavena ꞌee oni harura ꞌee oni vwihaijaho mahoꞌo vajaꞌamana. ꞌEne ara oni hahaꞌe vwihanu jaꞌina ea kaꞌene oni rori hijujija oja miꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hu ijá ꞌwama Oni ehijaho nihoꞌo nimaikúne ijá venareje a majama hihuna apeꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ꞌEnakaivo ea kajara huni ꞌunamaꞌe amairia ꞌahaume Jesuho apoma ijá ꞌwama ꞌÚ nuni rori hinujaho irane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesura eha vene ijá ꞌwama Ea pini Jerusaremi rene Jeriko vaꞌeme anuamejiꞌinapo piunamareja hu apene ꞌanae ꞌee ateha isokunahe ꞌanauvaꞌo ranavume ijino kwame ojaru ꞌojiꞌi namana. ");
INSERT INTO mcq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hu ijaꞌina veꞌeme pirisiti pina ꞌunama kajihuna kajino vaiꞌi kavuꞌe ea kajaho navu kaviꞌi rori tatumahe vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ꞌUnama kwinuꞌina kajino ea kaꞌene Rivai ꞌwavujaho ijihuna kajino roe ea kajaho kamarena hu ꞌuꞌo nii tihi kakaviꞌi tatumahe rori vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ꞌEnakaivo Sameria ora ea pini ꞌunama kajihuna kajino roe ea kajaho kame hu nihoꞌo temume oja turaꞌi ꞌahaana. ");
INSERT INTO mcq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hu huni vaꞌe ꞌweru ꞌee ꞌwainia usetie ꞌee panesia hwamaharena apene huni tonikia ꞌahi raname vaꞌe núꞌúha pini raname ꞌajoaha hinana. ");
INSERT INTO mcq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ijihuni súꞌuhijino hu monia oma noꞌoheꞌi sirirame ijí ea kaꞌene araꞌe ꞌajohiꞌina kaji vajahana. Hu ijí ea kaꞌene ara kaji ꞌajohiꞌiniji ijá ꞌwama A eakaho ꞌajoha hiꞌamana. ꞌEꞌeje na kúꞌo ꞌunama roe ara huni hahi oni monia kaꞌene atoꞌaruꞌamajaho na eha mahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ijiꞌa ijá ꞌwama A vwihanujaho ijí ea noꞌopisu vaja kajino irara huni romaijahune? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ꞌEne hu ijá ꞌwama Ea kaꞌene hu numimajina ꞌwamana. ꞌEjume Jesura ijá ꞌwama Vaꞌe ijaꞌina veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pu vaꞌajime vaꞌe ara pini useꞌeme napara iha Matara ꞌajorame huni sei aherame vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Huni ꞌuꞌua iha Merinaꞌomo hu Natohwi jihuni mumora rori asuma hine ataa apúsame Huni vuꞌa henana. ");
INSERT INTO mcq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mataho kaukara mapoka kaꞌene hu venajara túkiravume roe Hu ijá ꞌwama Natohwe nuni ꞌuꞌua kaukara mapokakija makiꞌejuꞌe na nanasumano vejujaho A ichá vwihano? A hu ꞌwarave roe na niꞌajihama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Natohwijara eha vena hu ijá ꞌwama Mata Mata a uneunecha nihoꞌo mapokaꞌe hine vwihanareꞌe oja hianavu kavu. ");
INSERT INTO mcq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ꞌEne uneunecha kwinu kwino mamaꞌina navu. ꞌEnakaivo nimaijaho nikwinuꞌwina. Ijihunaꞌe Meriho ꞌunama nimaiji piunamanaꞌomo nihoꞌo paapena ruvahuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naꞌia pina Hu kwaa pini hine siporuaꞌe ꞌonana. Hu ꞌojume paꞌareꞌeme Huni tisaiporu pini roe ijá ꞌwama Natohwe areri Jonira huni tisaiporu najaha jaꞌinaꞌe siporuaꞌe ꞌohuniji najuha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hu ijá ꞌiama Ja siporua ikaꞌina ꞌoꞌavara. Amo Oni iha nihoꞌo nimaa nimaaꞌomo A roa nú ꞌajohua. ");
INSERT INTO mcq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vea kwinu kwinu ꞌiruma kaꞌene areri ihuniji vajúha. ");
INSERT INTO mcq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Núni sisea vwihanúa arema. Ijihuni maijaho nú ꞌuꞌo ea ꞌahopo sisei ꞌahúujaho nú vwihanie arevura. ꞌEne paaherume vena kivuri vajijaho vaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hu pu ijá ꞌiama Ja ei pini napura rukinaꞌe reꞌiraꞌomo naꞌia rira muꞌoi vaꞌe ijá ꞌwavaꞌe napura nune puretia noꞌopiso vajiꞌirakúne na túnaꞌi oni puretia eha vajahuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ijihuni maijaho nuni napura kwaa jori rene roe iviamaa nuni sei roana kaivo nara unekaka mahuna paꞌajihunaꞌe ꞌwaravu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ꞌEꞌeje oni napura kajara kahino sea vaji eha vene ijá ꞌwaꞌipisa Siuna arema na vwicha nikume sesahu nu puꞌúmo ninejuraꞌomo na paꞌurine uneunecha ꞌeka vajahuna ꞌwavaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na jaaꞌe ꞌwaravu. Hu paꞌurine pureti pamaha kaivo a huni napuri roe pajuꞌikaꞌi hine jarimujihunihahi hu ꞌurine uneunecha mapoka kaꞌene hu icháru ura renujaho vajahaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ꞌEnajihunaꞌe Na jaaꞌe ꞌwaravu. Ja hine jariꞌavajaho vajihuna. Ja hine saraꞌavajaho piunihuna. Ja hine ꞌanaꞌanaꞌavajaho tirausahuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ꞌEne ea irara jarimujaho hu ꞌekuna. ꞌEne ea irara samujaho hu piunimuna. ꞌEne ea irara ꞌanaꞌanaujaho jaraꞌusahuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ꞌÚ ja omahwaha harihu jopo roe kijaꞌe jariraꞌipisa ja taparaꞌe vajihaꞌe? ");
INSERT INTO mcq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ꞌEnavo pu ꞌuꞌora kuhaꞌe jariraꞌipisa ja suaka vajihaꞌe? ");
INSERT INTO mcq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ꞌEnakaivo ja ea siseakija joni harihija swara mamai vajiꞌavajaho joni Oma kaꞌene akúpa ꞌahi hinuji jariꞌavajaho Hura Huni ꞌAvena mihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hu ꞌavena sisea kaꞌene ira paꞌwaraviꞌinijaho ꞌwaravume ꞌeꞌuna vaꞌeme ema kajaho aneja vene ira ꞌwaramana. ꞌEjume ea mapoka kajija nihoꞌo oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ea ꞌahoꞌa ijá ꞌwava Ea ikaho Pierisaparu ꞌavena sisea puni natohwijara harura mahuꞌe ꞌavena sisea ꞌwaravuꞌe usevu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ꞌEjume ea ꞌahoꞌa Hu vena kaꞌi ꞌahiume ꞌejahae ijá ꞌwava Veje aacha pina akúpa ꞌahi rene roa kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ꞌEnakaivo Jesura iraka kaꞌene pura vwihajajaho nikimarena ijá ꞌiama Kwaa ara irahipo irecharame vaꞌe nia ani ani hine ꞌarahiꞌi hiꞌipisa paꞌarejaꞌa. ꞌEne ara irahipo ahaama hiꞌipisa ariha paꞌarejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ꞌEnajihunaꞌe Setanira ahaama hiꞌipisa huni kwaa arijaho icháꞌinaꞌe namijaꞌe? Ijihuni maijaho ja ijá ꞌwavo Na Pierisiparu oni iha ꞌahi ꞌavena sisea ꞌwaravuꞌe usevu ꞌwavu. ");
INSERT INTO mcq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ꞌEnakaivo ja vwihajujaho Nara Pierisiparu oni iha ꞌahi ꞌwaravuꞌe ꞌavena sisea usevu ꞌwavu kaivo joni harihija irahuni iha ꞌahi ꞌwaravuꞌe usevure? Ijihuni hahi pura joni ꞌotua vehuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ꞌEnakaivo Nara ꞌavena sisea kaꞌene ꞌwaravuꞌe usevujaho Godoni ijijara rejuꞌe avaujaho Godi oni arijaho ni joni roana. ");
INSERT INTO mcq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ea kaꞌene harura rukinijara huni ara juha hajaa vene ꞌajohujaho huni kukua mamaa navura. ");
INSERT INTO mcq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ꞌEnakaꞌi ea ajisina huni ajira asimajara roe ꞌanae huni juha hajaa kaꞌene hura ꞌeke tarera vejiꞌi hinujaho ꞌetujahe huni kukua vajúsarama ꞌekura. ");
INSERT INTO mcq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ꞌEnakaivo ea kaꞌene Na huꞌúmo parenujaho hu Nuni pwina pana. ꞌEne ea Na huꞌúmo parene ea nianaujaho hu vejuꞌe pu jirijiri varanavura. ");
INSERT INTO mcq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Vea kaꞌene ꞌavena sisea emahuni haha ꞌahi hinujara ruꞌeꞌunujaho hu vaꞌe kwaa toa paꞌajino vaꞌe ojuta hwehuna samujaho pakamuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ꞌEnareꞌe hu ijá rohune Na kúꞌo ꞌunama vaꞌe ruha kaꞌene nara hijujino vaꞌuma. Hu ꞌunama vaiꞌi kavuꞌe ruha kajaho ea pahiju kaivo túa ꞌanae amairiana. ");
INSERT INTO mcq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ꞌEnareje hu vaꞌe napuhwaha ꞌavena sisea ꞌahoꞌa iropu noꞌo ajisinijija aherama roe ijí hihuna. ꞌEnaꞌavo marakuꞌijaho eakaho siseꞌi hinana vo iviamaa sisei maa hina parahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesuho ijá ꞌwarame paꞌareꞌeme napara pini ea rira kajino ꞌurina ira ajira ijá ꞌumena Napara kaꞌene Aaꞌe nahenae ꞌee A musa vajahajaho Godi merajahana ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ꞌEnakaivo Hu ijá ꞌwama Ea kaꞌene Godoni vuꞌa hene vejujaho ijihija Godi merajihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ea mapoka kajija Huni rora kajano ani reꞌeme Hu aneja vene ijá ꞌiama Ja ea kaꞌene iviamaa ꞌurijakija nihoꞌo sisea. Ja aacha sarama ꞌwarivu kaivo aacha pina pamihuna kaivo Jona oni aachajiruna. ");
INSERT INTO mcq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Areri Jonara Ninava opuni aacha renajaꞌinaꞌe Ema Puni Harihijaho iviamai ea kaꞌene hiju jihipuni aacha rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ꞌEne vukúꞌo vea kaꞌene Godira ꞌotua veꞌamani veijino vea vaꞌe ꞌonu karoꞌi puni kwinia kaꞌene hinujara Godoni unaꞌi ja puꞌúmo namine namahuna. Ijihuni maijaho ike kwinia karoꞌi kwaa jori hinujaho roe Saramanira kora mamaiji ꞌwaravume henana. ꞌEnakúne heha! Ea kaꞌene Saramani asimani eijaho iviamaa iki joni vaji hinu. ");
INSERT INTO mcq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ꞌEnakaivo vea kaꞌene Godira ꞌotua veꞌamani veijino ea kaꞌene Ninava orijija pu Godoni unaꞌi ja puꞌúmo namine ja namahuna. Ijihuni maijaho Jonara najahaji pu hena nimaa ronareja puni sisea arevara. ꞌEnakúne heha! Ea kaꞌene Jona asimani eijaho iviamaa iki joni vaji hinu. ");
INSERT INTO mcq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ea pina naheha paꞌene siꞌuara vaja irechavuꞌe navura kaivo pu icha kaꞌene nahehaꞌe ꞌunamiuji ꞌunavuꞌe ea mapoka kaviꞌi roa ajivura. ");
INSERT INTO mcq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hahijihuni naheha ijaho niijina. ꞌEnaꞌomo joni nia kajara marana paranujaho joni hahaka mapokijaho mahoꞌo hanana paranuna. ꞌEnakaivo joni nia siseraꞌamajaho joni hahaka mapokijija mahoꞌo nutuma nahuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Joni haha vaji hanajiꞌina kaꞌene namujaho paveje nutuviꞌina reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Joni haha mapokijaho hanana naꞌi kaivo pina panutuꞌipisa nihoꞌo natohwaꞌe hanajaꞌa areri ja naheha ꞌena irechavuꞌe namareꞌe hanana paraju jaꞌinaꞌe rejaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hu ijaho ꞌwaravume paꞌareꞌeme Parasia pini vaꞌe huni sei ꞌiruma iꞌamarono ona ꞌwaramana. Hu vaꞌe ꞌaijua rori asuma hine ꞌiruma iꞌi ꞌahaume venana. ");
INSERT INTO mcq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ꞌEꞌeme Parasia Jesu kaꞌeme Hu Huni ija pasoꞌi ijume kamarena hu nihoꞌo tatamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ꞌEjume Natohwi hu ijá ꞌwama Parasia kapusia ꞌee tevua huraru sovura kaivo joni vajijaho nihoꞌo nesa ꞌee sisei ani rene navura. ");
INSERT INTO mcq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Vwiha paꞌakije ꞌú Godi kaꞌene hura venajaho vaja ꞌuꞌo pavenane? ");
INSERT INTO mcq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ꞌEnakaivo joni vaji iraka kaꞌene navujaho ea kaꞌene uneunecha paꞌajihi vajihakame joni uneunecha mapokakija mamai reja. ");
INSERT INTO mcq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ꞌEnakaivo Parasia joni eha sisea nihoꞌo niꞌimaꞌura namu. Ijihuni maijaho ja taisia kaꞌene Godi vajahajaho senisia ꞌee siaa ani aniꞌina juasiꞌi navujija vajihura kaivo ja ꞌunama maijaho pataarohe ꞌee Godi oja pamahura. ꞌEnakaivo ikaho uneka kaꞌene ja vejiꞌi ea ꞌahoꞌa paasinamihune saꞌina avajura. ");
INSERT INTO mcq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ja Parasia joni eha sisea nihoꞌo niꞌimaꞌura namu. Ijihuni maijaho ja Sinakoku vaji unaꞌi ikikami hihuni tiniji ura renaura. ꞌEne ja maketia vaji emaapo pu ja ꞌajorahunaꞌe ura renaura. ");
INSERT INTO mcq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Joni eha nihoꞌo sisei namu. Ijihuni maijaho ja areri eucha kaꞌene ea savaji pahena pakiꞌi kaivo ijihuni toi ꞌurahoju jaꞌina veju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ꞌEjume roia pini eha vene ijá ꞌwama Najahiꞌine A ijaꞌinaꞌe ꞌwarumujaho núaꞌe ꞌuraruhe avanu? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ꞌEnakaivo Hu ijá ꞌiama Ja roia ꞌuꞌo joni eha sisea nihoꞌo niꞌimaꞌura namu. Ijihuni maijaho ja ea ahija mamaꞌina vajiꞌi kaivo niꞌajihe iji ꞌunira ꞌurihuna pana. ");
INSERT INTO mcq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Joni eha nihoꞌo niꞌimaꞌura namu. Ijihuni maijaho ja eucha mavarasaꞌina poropeti epuna vejura kaivo emahu jopo ꞌaniume kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Joni amuhipo poropetia kaꞌene ꞌaniajaho ja nihena kimareꞌe pura raka kaꞌene veja kajaho nijina ꞌwavu. Ijihuni maijaho ja hine puni eucha amairie veju. ");
INSERT INTO mcq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ijihuni hahi Godira Huni vwiha vajijino ikaꞌina ꞌwarumana. Nara Nuni poropetia ꞌee apasoru irechamie vuꞌakame ea ꞌahoꞌa pu ꞌanie kwamasahe ꞌee ea ꞌahoꞌa ruarahuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ꞌEnajihunaꞌe ea kaꞌene iviamaa ꞌurijajipo vea kaꞌene mweꞌaꞌe aneja vejajino rene poropetia ꞌaniajihuni eha apehuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eporu kaꞌene ea aririjihuni ꞌaa arihaji rena roe Jakaraia oni ꞌaa kaꞌene Temiporu ꞌee swasa vejuri ꞌaijua rira muꞌoa kaji ꞌanaji ro ꞌeꞌunana. Na ja ꞌwaravu. Ijihuni eha ijaho eaka iviamai hijukipo apehuna. ");
INSERT INTO mcq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ja roia joni eha sisea nihoꞌo niꞌimaꞌura namu. Ijihuni maijaho hena kahuni kiijaho ja apena ruvaꞌara kaivo ja ꞌuꞌo pava aruvara. ꞌEe ea ꞌahoꞌa kaꞌene vaꞌe aruꞌi vejajaho ja tanuvara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ꞌEꞌeme Hu ara kajaho areꞌi vaꞌajaho Sikuraipia ꞌee Parasia Jesuho nihoꞌo apene ꞌurarahe uneunecha mapokaꞌe ani aniꞌina apovara. ");
INSERT INTO mcq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ijihuni maijaho Hura unenuꞌu pina sisea ꞌwaravakame Huaꞌe apena namaꞌirono avajara. ");
INSERT INTO mcq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ea mapokaꞌe Huni rora kajaho ani rene ajime ateji tautaꞌaraviꞌi hiꞌeme Hu Huni tisaiporu amura Peresi rone ijá ꞌiama Ja hami Parasia puni isitia kiꞌavara. Ijihuni maijaho pu iraꞌasina. ");
INSERT INTO mcq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Uneunecha mapoka kaꞌene vaji navuꞌe ea mapoka pakivuraꞌomo túnaꞌi samahirahuna. ꞌEne ea mapoka hemi navujaho niꞌi niꞌi hena kihuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Vuꞌa iraka kaꞌene nututi jahejajaho ja samaumai ꞌwaraꞌavara. ꞌEne vuꞌa kaꞌene sei vaji koravajaho ja ata huri namine ꞌumeꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ehu nune Na nimaa ja ꞌwaravu. Ike haha huriji erapo ꞌanaa kwahuniji ja juꞌava. Pu areri ijihuni túnaꞌijaho unenu pina pavehuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ꞌEnakaivo ja irá juhahunijaho Na ja ꞌwarahuna. Godi kaꞌene areri ꞌanaa kwavakaviꞌi piꞌonamaꞌe veni vahuniji juhaꞌavara. Iꞌa Na ja ꞌwaravu. Huaꞌe juhaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ꞌEnakaivo ꞌú ea uka iropu maꞌuꞌu maa toia noꞌo ꞌimejure? ꞌEnaꞌavo Godira ijí uka maꞌuꞌu maa kajija hena kiꞌejuꞌe hijura. ");
INSERT INTO mcq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ꞌEne ijí joni húmata sapasa icharo namujaho Hu nihena kamu. ꞌEnakúne ja pajuꞌavara. Ijihuni maijaho jara uka maꞌuꞌu maa kajija asitahara. ");
INSERT INTO mcq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ꞌEnaꞌomo Na nimaa ja ꞌwaravu. Ea irara Na ronareje ea mapoka puni unaꞌi ꞌwaraꞌamajaho Emaa Puni Harihijara ꞌuꞌo ea kaji rone kahino akúpa ꞌahi Godoni ꞌona ojiꞌini jihipuni unaꞌi nahama ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ꞌEnakaivo ea irara Na hemihareje ea ꞌahoꞌa panajaꞌamajaho ea kaji ꞌuꞌo Godoni ꞌona ojiꞌini jihipuni unaꞌijaho panahama ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ꞌEne ea irahipo Emaa Puni Harihi jihunaꞌi ira sisea ꞌwaꞌavajaho puni sisea vwihanie arehuna kaivo Godoni ꞌAveni jihunaꞌi sisea ꞌwaꞌavajaho Hu nihoꞌo puni sisea pavwihana arehuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ꞌEꞌeje pu ja ꞌeka vaꞌe Sinakoku ꞌajohiꞌina ꞌee ea mamaꞌini jihipuni unaꞌi namaꞌiro vaꞌa kiꞌavajaho vuꞌa raka kaꞌene ꞌwarahunijaho oja pahianaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ijihuni maijaho ijí vea muka kajino iraka kaꞌene jara ꞌwarahunijaho Godoni ꞌAvenijara najaꞌeje ꞌwarahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ea pini ijí ea rira kajino ijá ꞌwama Najahiꞌine nuni poka ꞌwave nuni aachia kaꞌene nuni omijara irechamaji ahaama nuna vajihama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hu ijá ꞌwama Ea ikera! Ea irara Na joni ꞌotuae hehuna iji pijihane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hu pu ijá ꞌiama ꞌUnama ani aniꞌina kaꞌene nihoꞌo ituname urarena parajujija hami ꞌajohe kiꞌavara. Ijihuni maijaho ema ijihuni hiijaho kukua mapoka kaꞌene huni navujipo reje hihuna pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ꞌEnarena Hu ike haakaho ꞌwaramarena pu ijá ꞌiama Ea ꞌiruma nihoꞌo mapoka ani rejiꞌini jihuni mweꞌi soa savuꞌe juara ꞌurina paranana. ");
INSERT INTO mcq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hu hine hu husumano vwihanu vaꞌo ijá rona Nara nuni ꞌirumaꞌe irechahuni ruha ituꞌona parananaꞌomo na ichá veꞌeju ronana. ");
INSERT INTO mcq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hu ijá rona Na ikaꞌinaꞌe veꞌeju. Na nuni ara tirasame mamaꞌinaꞌe vene ijino nuni ꞌiruma ꞌee kukua ꞌahoꞌa irechaꞌeju ronana. ");
INSERT INTO mcq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ꞌEnarena hu oriꞌini ijá rona Na nihoꞌo ea teamanima parajiꞌina renareje na hiꞌeju. Na uneunecha kaꞌene juara mapokijino ura renia parahunijaho ꞌekuta. ꞌEnajihunaꞌe masuani hine ꞌiruma ine ꞌee toa kisina ine teamaniꞌeje hiꞌeju ronana. ");
INSERT INTO mcq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ꞌEnakaivo Godira ijá ꞌwama Ike nihoꞌo vwiha paꞌakera. A iviasi naꞌiakino kwaꞌamajaho ea irara ike kukua kaꞌene ara irechama hinujaho ꞌekaꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ꞌEnajihunaꞌe ea kaꞌene mweꞌa kakino uneunecha mapoka rukina renujaho hu Godoni unaꞌijino areri uneunecha paꞌanaꞌe renuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ꞌEnarena Hu Huni tisaiporu ijá ꞌiama Na ja ꞌwaravukúne jara icháꞌina hihunijaho pavwihaꞌavare ꞌee ikaꞌina pavwihaꞌavara. Nú ꞌiruma iraki iꞌeja pavwihaꞌavara. ꞌEne joni haha ikaꞌina pavwihana ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nú iraki núni haha nuhaꞌaraꞌeja? paꞌwahuna kaivo ijí ꞌiruma kajara venuakame majama hihuna pane ꞌee ateha kajara venuakame majama hihuna pana. ");
INSERT INTO mcq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ꞌEnakúne ikaho vwihaha. Uka kaꞌene jaijasaha oju kare kiha. Pu nihoꞌo puni ꞌina paꞌone ꞌee puni ꞌiruma paꞌeke rira kwino ahuma irechavu kaivo Godira ꞌiruma vajihu. ꞌEnakaivo jara uka nihoꞌo asitaha parajara. ");
INSERT INTO mcq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ja ea irahipo hine vwihananaviꞌi temuka apeꞌavajaho ꞌú ijí temuka kajara veje joni hia vea pina kúꞌo huri ranave hi vaꞌeja? ");
INSERT INTO mcq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ja uneunecha maꞌuꞌumai areri paveꞌavajaho ja irakijihunaꞌe uneunecha ꞌahoꞌakija vwihajo? ");
INSERT INTO mcq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ike heha sinara kaꞌene nechi orijija maꞌopuipo ꞌurijura kaivo pu opuina harura pavene ꞌee opuina majikaria pamarasahura. ꞌEnakaivo Na nimaa nimai ja ꞌwaravu. Saramaniho nitama huni haha sarira ꞌenana kaivo ijí hura sarira kaꞌene ꞌenajaho areri sinara huni nia vajaꞌe kimujaꞌina paasimana. ");
INSERT INTO mcq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ꞌEnaꞌomo Godira sinara kaꞌene iviasi maiꞌo navuraꞌomo niari atoꞌuve veni rehunijija ꞌajohaꞌamajaho Hu icháꞌinaꞌe ja ꞌajohahuna vwihajo? Ema kaꞌene joni nimairoa maꞌuꞌumaakije! ");
INSERT INTO mcq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ꞌEnakúne jara ꞌunama kaꞌene ꞌiruma ꞌeka ine ꞌee toa ihunijaho pahine sarame vwihaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ike uneunecha kijahija ea kaꞌene kwaa ara mapokakino hijujija hina saravura. ꞌEnakaivo joni Oma kaꞌene kahi akúpa ꞌahi hinujara uneunechaka mapoka kaꞌene ja pivusahujija nihe paranuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ꞌEnakaivo ja marakuꞌa Huni ara ꞌunamiji ꞌee Huni ꞌunama kaꞌene arimaiji saravakame ijiꞌa uneunechaka mweꞌakaki jara pivusahujaho Hura vajihuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ꞌEnakúne eakije nihoꞌo patea junaꞌavara. Ijihuni maijaho joni Omijaho ura rene teamama paraꞌejuꞌe Huni arijaho ja mihu. ");
INSERT INTO mcq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Joni uneunecha ꞌeke ꞌimenareje monijaho ea kaꞌene ꞌiruma paꞌajihi vajiha. Ja ojono tuja kaꞌene panapaviꞌiniji ꞌekaꞌavara. ꞌEe joni uneunecha kahino akúpa ꞌahi irechave ea panesi eke kapura paꞌuhusaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Joni uneunechaka mamaa kajipo naꞌavari tinijikano joni oja ꞌee vwihijaho ꞌuꞌo ijí nahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ja joni kukua same amairiarama parane joni naheha ꞌena pijinamie hanaꞌeje hiha. ");
INSERT INTO mcq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ꞌEne areri pwehwapo puni natohwijara ea maiꞌo napasi nejujihipuni sori vaꞌanaꞌe roꞌamarono ꞌajoha hijujaꞌina. Hu roe vwicha ꞌanaꞌanaꞌamajaho pu vwicha niꞌaha kwino tirasamahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pwea kaꞌene puni natohwijara kúꞌo ꞌunama roꞌamarono amairiarame ꞌajaha hijujija nihoꞌo teamanaꞌejuꞌe hiju. Na nimaa nimai ja ꞌwaravu. Hu huni ateha apúsame ꞌwarave asuma hiꞌeje hura ꞌiruma ꞌeke vajihe ihuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ꞌEnaꞌomo Hu naꞌia rimai roꞌena ꞌaho súꞌusúꞌu vea aharasaꞌamaji roꞌamajaho pwehwaha kaꞌene niamairiarame areri rena hijajija teamanahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ꞌEnakaivo ja niheju sea anesurijara heꞌeje nesa apejiꞌinijara vea muka irakiji roe nesa apeꞌiroꞌipisa hu tanurahakame hu paroe huni sea ruarahe nesa apejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ijihuni hahi amairie nirisave areri rena paraꞌeje ꞌajaha hiꞌavara. Vea muka kaꞌene Ema Puni Harihijara rohunijaho ja pakame pahejiꞌinakúne ijá veꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitara ija ꞌwama ꞌÚ Natohwe A núaꞌe haakaho ꞌwarumu ꞌuho eaka mapokakihi ꞌwaramo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Natohwijara ijá ꞌwama ꞌÚ pwea irara paseviꞌina ꞌee vwiha hami vwihajiꞌine huni natohwijara huni pwea ꞌajohe ꞌiruma vea ꞌahi areri vajihunaꞌe ranamane? ");
INSERT INTO mcq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ꞌEnareje pwea irara kaukaraa kaji hine vejiꞌi hiꞌeje vea kaꞌene huni natohwijara ro kaꞌamajaho hu merajahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na nimaa nimai ja ꞌwaravu. Hu ranave huni kukua mapoka kajija mahoꞌo hura ꞌajohuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ꞌEnakaivo pwea siseijaho hu oja vaji ika ronu nuni Natohwijaho paroꞌejuꞌe ꞌaha jora renu roꞌikaꞌi aneja vena huni pwea parui napari ꞌanie ꞌee ꞌiruma ma ina hine ꞌee toa sisea ine nanaꞌena. ");
INSERT INTO mcq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ꞌEne Hu hine ijí veꞌi kaivo pavwihane paveꞌeje Huni Natohwijaho ro ꞌeꞌuhuna. Vea muka kaꞌene Hura rohunijaho pakame pahejiꞌina. ꞌEnareje Hura heha eha mahareje ranave ea kaꞌene iraꞌasini jihipuni tini ijino vahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pwea kaꞌene huni Natohwijara ꞌwaramujaho henareje paamairiarava ꞌaho huni natohwijara iraka kaꞌene ꞌwaramuji pavenajaho nihoꞌo ꞌaha mapoka hijahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ꞌEnakaivo pwea irara uneka sisea kaꞌene hu puruva reꞌeme venana reꞌamajaho eha maꞌuako apehuna. Ea irahijaꞌe uneunecha mapoka vajiꞌamajaho hu areri vajiha kajaꞌinaꞌe ꞌekahuna. Ea irara nihoꞌo mapoka mapokaꞌe vajihujaho ea kajaho areri vajiha kajaꞌinaꞌe mapoka mapoka ꞌekahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na mweꞌakake veni ꞌena apena jae reꞌamarono routa. ꞌEnakaivo iviamai kakaro reꞌipisa areri rena parajaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na vea kisini vaji va aruhuna namu. ꞌEnajihunaꞌe ijí hine vwihajujaho nuni oja ahisinaꞌe renunaꞌomo ijara ro paꞌarehuniji kaviꞌi hiju. ");
INSERT INTO mcq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ja vwihajujaho Na matauma hihuniji apene iki mweꞌi route? Na nimai ja ꞌwaravu. Matauviꞌina pana kaivo Na ahaama hihuniji apena routa. ");
INSERT INTO mcq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iviamaikaka renareje kachiꞌina iropu reꞌavajaho noꞌopisu ꞌurine noꞌoheꞌi irechamia vaꞌe noꞌoheꞌi ꞌurine noꞌopisu irechamia vaiꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Omahi hariaha ninave ꞌee hariahi omaha ninave ꞌee oahi ꞌapajaha ninave ꞌapajahi oaha ninave sasahi sasaha ninahuna. ꞌEje pu ahaama hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hu ea mapoka kajija ijá ꞌiama Ja ꞌimitia kaꞌejuꞌe vea ꞌonujaꞌi savuꞌe kavujaho ja niꞌaha kwino ijá neha piꞌi venu ꞌwaꞌejuꞌe neha pinuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ꞌEnakaivo ja heꞌejuꞌe asiasia kamaꞌahuni rene ikikahi ꞌanauꞌe hejujaho vea ꞌeꞌui venu ꞌwaꞌejuꞌe vea ꞌeꞌununa. ");
INSERT INTO mcq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ja iraꞌasinakije! Ja akúpa ꞌee mweꞌa kimareꞌe ijihuni maijaho ꞌwaravura kaivo ꞌú ja iviamaa iraka kaꞌene rejujaho pakivo? ");
INSERT INTO mcq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ja irakijihunaꞌe ojono irakijara nimaijaho paꞌeke mina vene kivo? ");
INSERT INTO mcq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ꞌEne ei pini a ꞌotua vetaꞌiro vejakame ja noꞌo ꞌunama toi vaꞌavajaho ja hu huꞌúmo ꞌwame amairiꞌavara. Ijihuni maijaho hu a apena vaꞌe ꞌotua vejiꞌina natohwi jihuni ija tahi ranamaa veꞌenakúne. ꞌEjakame ijí ꞌotua vejiꞌina natohwa kajara hirisima mihakame pu apena vaꞌe tipura ranamahuna. ");
INSERT INTO mcq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na nimai ja ꞌwaravu. Ja ijí pu puꞌúmo paꞌwame amairiꞌavajaho ja ijí tipura kajino hinu vaꞌo ꞌimeja paꞌareꞌeje ijí roe samai usehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Vea kajino ea ꞌahoꞌa ijino hijaraꞌomo pu Jesuho ijá ꞌwava Karari ora ꞌahoꞌa hine Godoni swasaꞌe veꞌeme Pairatira ꞌanie puni ꞌaa swasa kaꞌene pura vejajihuni toi ahumana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ꞌEjume Hu eha vene ijá ꞌiama Ja vwihajujaho Karari ora ikihi puni siseijara vu Karari ꞌahoꞌa puni sisea asitaha raka? ");
INSERT INTO mcq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ꞌEnakaivo Na ja ijá ꞌiavo Pana! Ja joni sisea pavwihane taꞌarohe nahama ꞌwaraꞌavajaho ja ꞌuꞌo ijaꞌinaꞌe kwamasahuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ꞌEnakaivo ja vwihajujaho ea ꞌahoꞌa (18) kaꞌene Sairoami ari ꞌaume ꞌaniume kwamasaha jihipuni siseijara ea kaꞌene Jerusaremi hijujihipuni siseijaho asitahane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ꞌEnakaivo Na ja ijá ꞌiavo Pana! Ja joni sisea pavwihane taꞌarohe nahama ꞌwaraꞌavajaho ja ꞌuꞌo ijaꞌinaꞌe kwamasahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ꞌEnarena Hu haakaho ꞌwaramarena ijá ꞌiama Ea pina tavoꞌa huni juasiꞌi ꞌonavume naminunaꞌomo hu vaꞌe maa ꞌeka amena iꞌi ꞌahauꞌe vaꞌujaho mai parenuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ꞌEnaꞌomo hu huni juaraꞌe ꞌajohiꞌiniji ijá ꞌwama Na juara noꞌopisu ꞌina ꞌekaꞌirono saravuta kaivo pina paapejuta. Ijihuni hahi mweꞌaꞌe nisamukúne vwina piꞌonama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ꞌEnakaivo ea kaꞌene juara kaji ꞌajohiꞌinijara ijá ꞌwama Natohwe! Makaꞌeje juara kwinu namijakame Nara ꞌúsia aneja kajino irechavakame maraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ꞌEjakame juara pinijino tavoꞌakara maa reꞌamajaho mavarasaꞌinaꞌe rehuna kaivo maa pareꞌamajaho vwiꞌeju ꞌwamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Naꞌia pina Jua puni Sapatia veijino Jesu Jua puni Sinakoku vaji hine najahana. ");
INSERT INTO mcq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ꞌEꞌeme napara pina juara mapoka (18) ꞌavena sisei vejume huni túpa nivunama navukame arini namina ohuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ꞌEjume vea kaꞌene Jesura kamarena ꞌumejume roume ijá ꞌwama Napara karere oni atama iviamaa maranau ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ꞌEnarena Huni ija haha ꞌahi ranavume niꞌaha kwino huni túpa ariraꞌe rejume Godi taꞌarohana. ");
INSERT INTO mcq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ꞌEjumakame ea natohwa kaꞌene Sinakoku ꞌajohiꞌinijaho Jesura ea vejume Jua puni Sapatia veijino marajumakame ajimana. ꞌEjume Hu ea kajihi ijá ꞌiama Ja naꞌia iropu kwinu vajijino kaukaraa vehunakúne ijino roajivakame veje maraniaꞌa kaivo Jua puni Sapati veijaho paro veꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ꞌEjume Natohwijara eha vene ijá ꞌwama Ea iraꞌasinakera ja ea kwinu kwino Sapati veijino joni toniki ꞌee purumakau toa huꞌipisa ja Sapatia veaꞌomo parasame ahema apene vaꞌe toa maha ijaꞌa raka? ");
INSERT INTO mcq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ꞌEnaꞌomo iviamaa ike Eparahami oni ꞌapajakaho Setani rosavuꞌe juara mapoka (18) paꞌarenajaho hu areri Sapati veakaho paveje maraꞌena? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ꞌEnakaꞌi Hura eha kaꞌene ꞌwaramajara vejume ea kaꞌene Huni nakijija junamana kaivo ea mapokaꞌe Hura uneunecha kaꞌene venajihi kimareja teamanavume mariꞌuvara. ");
INSERT INTO mcq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ꞌEnajihunaꞌe Hu ijá ꞌiama Godoni arijaho icháine? ꞌÚ Na Godoni arijaho irakijino mina vejiꞌi ꞌwarahune? ");
INSERT INTO mcq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Godoni arijaho areri kwava ꞌina saꞌina. ꞌEnaꞌomo emai apena vaꞌe huni juasiꞌi ꞌonamana. ꞌEnaꞌomo riamareꞌe nihoꞌo icha natohwaꞌe rejuꞌe ukapo roe ijihuni anuama ꞌahijino nesa vene hijura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hu kúꞌo ijá ꞌiama Na Godoni arijaho irakijino mina vejiꞌi ꞌwarahune? ");
INSERT INTO mcq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ijaho areri napari isitia kaꞌene harava ꞌeke puretia venareꞌe ꞌonahukame hwena ajivujaꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hu ara mamaꞌina ꞌee maꞌuꞌumaa ijino najahiꞌi Jerusaremi vaꞌi ꞌahaume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ꞌEꞌeme ea ꞌahopo ijá ꞌwava Natohwe ea makwinu kwino majama hihuna apehuna raka ꞌwavara. ꞌEjume Hu ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Na nimai ja ꞌwaravukúne hami hami vena kamareje vwicha kaꞌene nihoꞌo maꞌuatituijaho vaꞌe aruꞌavara. Ea mapokaꞌe aruꞌi ꞌahie vehuna kaivo maiꞌo areri parenahuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ꞌEjume sea anesurijara ꞌurine vwicha kunaꞌeje ja maꞌahi namine vwicha ꞌanaꞌanae ijá ꞌwahune Natohwiji vwicha tirasamúha ꞌwave anesurijara ijá ꞌiahune Na ja suja. Ja ichihi rene roajivajaho na pahena pakivurakúne ꞌiahuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ꞌEjakame ja ijá ꞌwahune Nú oni unaꞌi ꞌiruma ine ꞌee toa ijura. ꞌEe a roe nuni ari maꞌahi vuꞌa najuhuna ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ꞌEjakame Hu kúꞌo ijá ꞌiahune Ja ichí rene roꞌajaho Na suja. ꞌEnakúne ike sisea vejiꞌinikije usema vaꞌajiha. ");
INSERT INTO mcq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja ruha kaꞌene niramarume upaja jaꞌiꞌujiꞌi nahunijino hijiꞌi Eparahami ho Aisiki ho Jekapi ho ꞌee poropeti kiꞌeje Godoni ari ꞌuraha oja kihuna kaivo jajasu atoꞌarumaꞌe usehuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ea kaꞌene vea ajimujaꞌi hijura vea ꞌonujaꞌi hijura kamaꞌi hijura ꞌee kahaꞌi hijujipo roe Godoni ari ꞌiruma ine hihuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Heha! Ea kaꞌene iviamaa túchamai rejujija urasahuna ꞌee ea kaꞌene urasahujija túchamai rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Vea nikwinuꞌina kajino Parasia ꞌahoꞌa Jesuni roe ijá ꞌwava A iviamaa ikaho areꞌi kaivo kwai pini vaꞌamana. Ijihuni maijaho Herotiho A ꞌanaꞌi ꞌahaukúna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ꞌEjume Hu ijá ꞌiama Vaꞌe ꞌua nea kajaho ijá ꞌwaraha. Na ꞌavena sisea siome atoꞌarumaꞌe ꞌee atama ani aniꞌinaꞌe iviasi ea vejuꞌe maranie ꞌee niara ꞌuꞌo venareje nitui Nuni kaukaraa paꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ꞌEnakaivo iviasi aneja vene vaꞌiraꞌomo niari ꞌunamutoi vaꞌiri nitui va ꞌeꞌuhuna. Ijihuni maijaho poropetia kajaho samaumaa paꞌanaahuna kaivo Jerusaremi vaji ꞌanae kwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oo Jerusaremi ore Jerusaremi ore jara poropeti kaꞌene irechamiume joni vuꞌajija ꞌaniume kwamasahare ꞌee ea ꞌahoꞌaka irechamiuꞌe joni vaꞌajaho muni ꞌaniume kwamasahara. Naꞌiaka mapoka kikano Na ura joni sesamaa aherame rira kwino irechaꞌi ꞌahiuna. Areri ꞌuꞌorapo ꞌuꞌuhwahaꞌe huni taha vaji irechavuꞌe ahuma hijujaꞌinaꞌe veꞌiro vejujaho ja nihoꞌo ura parenaura. ");
INSERT INTO mcq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Heha! Joni ara kajaho josu pareꞌeje ranave savasa rehuna. Na ja ꞌwaravu. Ja Na nihoꞌo pakimu vaꞌuꞌe ijiꞌa ja ikaꞌina ꞌwahuna. Natohwijihuni iha ꞌahi ea kaꞌene roujaho merajaho ꞌwahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sapati vea kwino Jesuho Parasia ea natohwa pipuni sei ꞌirumaꞌe iꞌi ꞌahaume vaꞌeme ea mapokaꞌe Hu ꞌajohareja vevirinavara. ");
INSERT INTO mcq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ꞌEꞌeme ea pina kaꞌene haha hwejiꞌinijara Huni unaꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesura eha vene roia ꞌee Parasia ijá ꞌiama Mosisi oni tamana ea Sapatia vei veje maranihunijaho areri rehuna ꞌwarumana ho pane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ꞌEnakaivo pu ira paꞌwaravume Hu ea kajaho vejume marajumakaviꞌi ranavume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ꞌEnarena Hu pu ijá ꞌiama Ea pipuni harihina ho purumakaui Sapati vei ꞌmaꞌoi oꞌipisa ja ea pina pavaꞌe ꞌenapi ranavaꞌa raka? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ꞌEnakaivo pu ijihuni eha areri paꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Vea kaꞌene Hu kivume ea kaꞌene ꞌwaravume roajipo ruha mamaa kaꞌene ea mamaꞌinapo hijuri ruhiji ꞌeke hiꞌirono nirie ꞌojuma kimarena Hu aneja vene haa ikaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ea ꞌahopo ja napara maiꞌo ꞌwahajihuni sori vaꞌavajaho ruha kaꞌene ea mamaꞌinapo hijuri ruhijija paꞌeke hiꞌavara. Ijihuni maijaho ea niꞌina pina kaꞌene hura ꞌwaramajara roꞌamajaho a ꞌuriꞌeje eakara ruhakaho hinama. ");
INSERT INTO mcq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ꞌEa kaꞌene ja noꞌo ꞌwaravuma roajara roareje a ijá ꞌwahune Ruhakaho ea ike aremaha ꞌwave a nihoꞌo junaꞌeje va túnaꞌi hiꞌena. ");
INSERT INTO mcq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Vea kaꞌene ea a ꞌwarave vaꞌamajaho vaꞌe ruha kaꞌene túchama ijí apena hiꞌamana. ꞌEꞌirakúne ea kaꞌene a ꞌwaravume vaꞌajara roꞌamajaho hu ijá ꞌwahune Napura nune kahakaro ruha maa kahi va hina ꞌwave ijiꞌa ea mapoka kaꞌene ꞌaijua rori hijujija a kame taꞌarorahuna. ");
INSERT INTO mcq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ea irara oriꞌini huni pinana ahasiriꞌamajaho vetie hu ajurana ohuna. ꞌEnakaivo ea irara oriꞌini ajuarana oꞌamajaho vetie huni pinana ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ꞌEnarena Hu ea kaꞌene huni sei ꞌwaravume vaꞌajaho ijá ꞌwama A ea ꞌahoꞌaꞌe ꞌiruma vajiꞌi veꞌamajaho oni napuhija vwehija amuhija ꞌee ea kaꞌene ꞌiruma ani rejiꞌinaka oni rori hijujija vejuroꞌi pu a eha vetaꞌejakúne paꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A ahaja iꞌi ꞌahae veꞌamajaho ea kaꞌene uneunecha paꞌana iriviꞌina nia supaviꞌina ꞌee atama ꞌuniraviꞌina ꞌumenaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ꞌEꞌirakúne a merajaꞌamana. Ijihuni maijaho pu oni eha areri pavehuna. Vea kaꞌene ea mamaa kaꞌene kwamasahajipo ꞌuriꞌavajino a eha vajahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ea pina ijino pu puꞌúmo hinanaꞌomo ijara henarena Hu ijá ꞌwama Ea irahipo Godoni ari ꞌiruma ihunijaho nimerajihane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ꞌEjume Hu ijá ꞌwama Ea pini ahajaꞌe iꞌi ꞌahaume ea mapoka ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ꞌIrumaꞌe ihuni veijino ea kaꞌene ahaja anesurijara huni pwea ranavume ea kaꞌene puni onaꞌe vejajihi aheraꞌirono vaꞌe ijá ꞌiama Roha! Uneunecha amairiaravarakúne roajiha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ꞌEnakaivo pu ea kajija nihoꞌo ꞌunama ani aniꞌina mapokaꞌe saravara. Ea pini pwea kajaho ijá ꞌwama Na mweꞌa maiuꞌinaꞌe ꞌimejutaꞌomo ijí kaꞌi ꞌahiuꞌe vaꞌukúne makiꞌeje vaꞌuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ꞌEjume pini ijá ꞌwama Na purumakaua iropu ꞌimejutaꞌomo na ijí ꞌeka irechama kiꞌi vaꞌukúne makiꞌeje vaꞌuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ꞌEjume ei pini ijá ꞌwama Na iviamaakano napara ꞌwahutaꞌomo ijihunaꞌe na pavuhuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ꞌEjume pweijaho ꞌunama vaꞌe huni natohwijaho ijá ꞌwaramana. ꞌEjume huni natohwijaho ajivume huni pwea ijá ꞌwama Marako vaꞌe ꞌunamutoi ꞌee ara mamaꞌina puni utorijino ea kaꞌene ꞌiruma paꞌana ꞌee iriviꞌina ꞌee nia supaviꞌinijihi aherame roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ꞌEnarena ijí pwea huna kajara ijá ꞌwama Ara ꞌwarimajaho na nivejuta kaivo ruha mapokaꞌe navu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ꞌEjume natohwijara ijá ꞌwama Vaꞌe ꞌunamutoa ꞌee juara arijino ea kimareje ꞌwarave roa kame nuni sea ituꞌonama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na nimaa ꞌwaravutaꞌomo ea kaꞌene nara marako ona vejume paroajija ꞌiruma ikehuni sahura paihuna ꞌwamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ea mapoka Hu tamatihe vaꞌeme Hu taꞌarohe ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ea irara Nuni roꞌi ꞌahae veꞌamajaho hu omaha oaha huni napara harihwaha maꞌipwaha ꞌee huni haha ꞌuꞌo oriꞌina paseꞌamajaho hu Nuni tisaiporua areri parehuna. ");
INSERT INTO mcq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ea irara Naꞌe ꞌararihie sisea piunamareje nihoꞌo pakisina rene namiꞌamajaho hu Nuni pwea rehunijaho areria pana. ");
INSERT INTO mcq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ea irara araꞌe veꞌi ꞌahaujaho ꞌú hu marako asuma hine monia icharo ꞌimene ꞌee monia areri reje ꞌimé parahuniji vwihanune? ");
INSERT INTO mcq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vejuroꞌi hararu veꞌikaꞌi pavesirihe ea mapoka kama ꞌijahareje ijá ꞌwahuna ");
INSERT INTO mcq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Eakaho namiꞌune veꞌirepunaꞌi venana kaivo hu pave paraꞌejuꞌe namu kaji kaha ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ꞌEnaho kini irara kini pinaꞌi ꞌaraꞌi venujaho ꞌú hu marako paasuma hine piraꞌaramuvaꞌo huni ea mapoka (10,000) ijaho ꞌee pipuni ea mapoka (20,000) kaꞌene hu huꞌúmo ꞌaraꞌiro roujaho hu areri rehunijaho kama henareꞌe ijiꞌa vaꞌune? ");
INSERT INTO mcq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hu areri harura pareꞌamajaho ea irechave pura vaꞌe ea natohwa pina maiꞌo kwaa jori roꞌeje piuname ruramareje areꞌikaꞌi mataume hiha ꞌihuna. ");
INSERT INTO mcq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ꞌEnajihunaꞌe ja ea irara huni uneunecha mapoka kaꞌene navujipo paseꞌamajaho hu Nuni tisaiporu areri parehuna. ");
INSERT INTO mcq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Misa nihoꞌo mamaa kaivo vea kaꞌene ijihuni vwea paꞌareꞌamajaho ꞌú ichá veje vwea vukúꞌo reꞌena? ");
INSERT INTO mcq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ijí misa kajara mweꞌa usetie mweꞌa marahuna pane ꞌee teachaha usetie teamarahuna pana. ꞌEnakúne ea irara ataa rukina reꞌamajaho ataa apúsame heꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Naꞌia kwino ea kaꞌene takisia apejiꞌina ꞌee ea sisea mahoꞌo roe Huni rori vuꞌa heꞌi roara. ");
INSERT INTO mcq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ꞌEjume Parasia ꞌee Sikuraipi nihoꞌo hine suiꞌi ijá ꞌwava Ea ikaho ea sisea aherame pu puꞌúmo ꞌiruma inuna. ");
INSERT INTO mcq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ꞌEjumakame Hu ike haakaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ꞌEnaꞌomo ja icháꞌina vwihajo? Ei pini sipia mapoka mapoka (100) namiꞌiraꞌomo kwinu pakaꞌipisa hu ichá vejaꞌe? ꞌÚ hu ꞌahoꞌa kaꞌene (99) ijija huriꞌi irechamiꞌi kaivo vaꞌe kwinuꞌwi savaꞌa raka? ");
INSERT INTO mcq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Vea kaꞌene hu piunamujaho teamavuꞌe apene twaitoi raname rouna. Vea kaꞌene ari roujaho napuhwaha ꞌee ea kaꞌene huni ara rori hijujija ijá ꞌiama Na nuni sipia kaꞌene ranama savujaho nipiunavutakúne nú puꞌúmo mariꞌuha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ea arira kaꞌene (99) ijija pana kaivo ea kwinuꞌwi huni sisea nahama ꞌwarame taꞌarohujaho akúpa ꞌaha nihoꞌo niꞌimaꞌura mariꞌuvura. ");
INSERT INTO mcq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ꞌEnaho napara pina monia siriva iropu ropu naꞌiraꞌomo oma kwino ꞌoꞌipisa hu icháꞌinaꞌe vejaꞌe? Hu ira ꞌene túa anasaviꞌi masuanuꞌwi sea vajaka mapoka kajino tinuvaꞌo kame apejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hu ijí kama apeꞌama jihunaꞌe huni napuhija ꞌee ehwaha ꞌumenae roajima ahuma hijakiviꞌi hu pu ijá ꞌiava Nú puꞌúmo mariꞌuha! Ijihuni maijaho na nuni monia kwinu ranavujaho na nikame apejuta. ");
INSERT INTO mcq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ꞌUnama nikwinuꞌina kajino Na ja ꞌwaravu. Ea sisea kwinu huni sisea vwihane temuvume nahama ꞌwarama jihunaꞌe nihoꞌo Godoni onaꞌojiꞌina puni unaꞌi teamarasahe mariꞌuvura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ꞌEjume Hu ijá ꞌiama Ea pina harihwaha noꞌoheꞌina. ");
INSERT INTO mcq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ꞌEnaꞌomo ꞌuꞌuijara omaha ijá ꞌwama Amo nuni aachiꞌijaho iviamai vajiha ꞌwavume omahi aachia punijaho ahaame pwinaꞌa ꞌuꞌuaꞌe vajahe ꞌee pwina pokaꞌe vajahana. ");
INSERT INTO mcq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ꞌEjume naꞌia josua paꞌareꞌeme ꞌuꞌuijara ꞌurinajaho huni kukua mapoka kajaho ꞌeke kwaa jori vaꞌe hine huni kukua mapoka kajaho majikarino hine atoꞌaruvume paranana. ");
INSERT INTO mcq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hu monia mapoka kaꞌene hununaꞌi navajaho nihoꞌo atoꞌaruma paranana. ꞌEꞌeme kwaa ara kajaho ora vea niꞌimaꞌura rejumakame matunaꞌe hijara. ꞌEjume hu matupunaꞌe pivunanamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ꞌEjume hu vaꞌe aea pihuni kaukaraꞌe veꞌi ꞌahaume ꞌwaravume hu ranavume vaꞌe huni maha mapoka ꞌajohaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ꞌEjume hu ijí asuna kaꞌene mahaꞌe vajihaji kimajaho nihoꞌo mamaaꞌe rejume iꞌi ꞌahaana. Ijihuni maijaho ea hu ꞌiruma ihuna pavajahara. ");
INSERT INTO mcq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ꞌEjumakame hu hine vwihanu vaꞌo ijá rona Ea kaꞌene nuni omijihuni kaukaraꞌe vejujija ꞌiruma mapokaꞌe iꞌejuꞌe na iviamai ike matupunaꞌe kwaꞌi ꞌahiuꞌe veju. ");
INSERT INTO mcq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ꞌEnaꞌomo na iviamaa ꞌurina vaꞌe amoho ijá ꞌwahune Amo na Godiho siseꞌi ꞌahaꞌe ꞌee A siseꞌi ꞌahauta. ");
INSERT INTO mcq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ꞌEnakúne na oni hariha paꞌwiꞌamana kaivo ara ea kaꞌene oni kaukaraꞌe vejujihi ꞌahiu jaꞌinaꞌe ꞌahiꞌamana ꞌwahuna ronana. ");
INSERT INTO mcq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ꞌEnarena hu ꞌurine omahoni ꞌunama vaꞌana. Hu maiꞌo kwaa jori roꞌeme omahi kamarena natohwaꞌe temuvume ariha ninuma vaꞌe hariaha aharu ꞌoname ura mina vene nirisamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ꞌEjume hariahi ijá ꞌwama Amo na Godiho siseꞌi ꞌahae ꞌee a siseꞌi ꞌahauta. ꞌEnaꞌomo na oni hariha ꞌwihunijaho maiꞌo areri parenu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ꞌEnakaꞌi omahi pwehwaha ijá ꞌiama Mamako vaꞌe ateha mavarasaꞌinijino apena roe apúsamaha. ꞌEne rinia apena roe arinamahe ꞌee mumora hwana hwanamaha. ");
INSERT INTO mcq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ꞌEnareje purumakau ꞌuꞌua poma parajiꞌinijino ꞌanae ijiꞌi temarasaha. ");
INSERT INTO mcq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ijihuni maijaho hariha nunakaho nikwamana kaivo ꞌurina roana ꞌee hu niranavuma vaꞌe paranana vo vukúꞌo piunavuta ꞌiamana. ꞌEjume pu aneja vene ahaja ijiꞌi nihoꞌo temarasaha parajara. ");
INSERT INTO mcq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pu hine ꞌirumaꞌe iꞌeme hariha kaꞌene pokijaho juasiꞌi ꞌurahonana. ꞌEnaꞌomo hu ꞌuname ara rori roiꞌi chaja irumuna kaꞌene javavajaho henana. ");
INSERT INTO mcq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ꞌEjume hu pwea pina ꞌumejume roume apoma ijá ꞌwama Kahaho irakaꞌe vejo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ꞌEjume pwea kajara ijá ꞌwama Oni ꞌuꞌuijara unenuꞌu pina pareꞌeme ꞌunama roajihunaꞌe omuni purumakau ꞌuꞌua poma parajiꞌina ꞌanae inareꞌe ijihunaꞌe iranoꞌa apeju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ꞌEjumakame hariaha pokijaho nihoꞌo ajima parajume sei vahuna ura parejume omahi ariha roe pokijara vaꞌe sea vaji ajiꞌamarono ꞌejahaana. ");
INSERT INTO mcq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ꞌEjume hu omaha eha vene ijá ꞌwama Na juara mapokaꞌe ikino a huꞌúmo hine oni pwea punaꞌi kaukaraa vejura. ꞌEne maiꞌo naꞌia kwinu a papataarorahuta. ꞌEnakaivo a irakaꞌe na mihane? A nihoꞌo kotia kwinuꞌwi pamihume na napuhu nú puꞌúmo ꞌiruma vene ijuta. ");
INSERT INTO mcq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ꞌEnakaivo ike oni hariha kajaho ara kukua kaꞌene vajahajaho ꞌeka vaꞌe paranahaꞌe saraviꞌi atoꞌaruma parane kúꞌo ꞌunama rouꞌe a purumakau ꞌuꞌua poviꞌinakaho hunaꞌe ꞌanaana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ꞌEnakaivo omahi ijá ꞌwama Nuni harihe a ikino nú puꞌúmo hinujihunaꞌe uneunecha mapokakija nunijaho ona. ");
INSERT INTO mcq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ꞌEnakaivo nú iviamaa ꞌiruma ine teamanuhuni jihuni maijaho oni ꞌuꞌuijaho nikwamana kaivo vukúꞌo ꞌurine ꞌee niranavuma vaꞌe paranana vo iviamaa kúꞌo kavara ꞌwamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hu Huni tisaiporu ijá ꞌiama Ea pina kukua ani rejiꞌini ea pina apene huni moniaꞌe ꞌajoꞌamarono ranamana kaivo hu heꞌeme ea ꞌahopo ijá ꞌwava Ea kaꞌene oni monia ꞌajohiꞌinijaho monia majikarino atoꞌarumu ꞌwavume henana. ");
INSERT INTO mcq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ꞌEnarena hu ꞌumejume roume ijá ꞌwama Vuꞌa kaꞌene ike ꞌwavuꞌe na hejukaho nimaae? Na a ranamaꞌiro vejukúne iviamaa vaꞌe nuni monia kaꞌene ichihichihi vaꞌajihuni ꞌunamijaho amairiu vaꞌo apena ro najiha kavuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hu ijá rona Nuni natohwijaho naꞌe ranamiꞌi venunaꞌomo na vi ichá veꞌeju ronana. Na harura panaꞌomo na mweꞌa areri paꞌuhune ꞌee na vaꞌe eaꞌe jarirahuna junimu. ");
INSERT INTO mcq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na kaukara ranamiꞌeje nara iraka kaꞌene vehunijaho na nivwinimu. Na kaukara ranamiꞌavajaho napuhu nupo ꞌajorime puni sei aherima ajihuna. ");
INSERT INTO mcq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ꞌEnarena hu ea kaꞌene huni natohwiji monia vajahunijija ꞌumenaume roajivara. ꞌEjume ea pina apoma ijá ꞌwama A ꞌweru icharo nuni natohwa vajahane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hu ijá ꞌwama Na ꞌweru mapoka mapoka (100) ꞌekuta ꞌwamana. ꞌEne hu ijá ꞌwama Ara moni icharo vehuni heha ijaho ikenakúne asuma hine (50) vena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hu ea pina apoma ijá ꞌwama A nuni natohwijaho icharo vajahane? ꞌwamana. Hu ijá ꞌwama Na ꞌwitia pekia mapoka (100) ꞌekuta ꞌwamana. ꞌEjume ea kaꞌene ijí kaukara ꞌajohiꞌinijara napusaꞌi ꞌahauma ijá ꞌwama Ara moni icharo vehuni heha ijaho ikenakúne asuma hine (80) vena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ea kaꞌene kukua anesurijarahara ea kaꞌene kaukara ꞌajohuji kamarena ijá rona Nihoꞌo pisivie paraju kavu ronana. ꞌEnarena hami vwihaha. Areri ijaꞌinaꞌe ea kaꞌene mweꞌa ikino hijujaho ꞌunama ijaꞌinaꞌe ea pisimiura kaivo ea kaꞌene hanajiꞌini hijujija ijaꞌina pavejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ꞌEnarena Na ja ꞌwaravu. Monia puni ꞌunama ariri jihuniji napura veꞌirakúne ijara niꞌajihe sisea paveꞌavara. Ijihuni maijaho ꞌunama ijaꞌinaꞌe vene niꞌajihareje ara kaꞌene majama hihunijino vahuna. ");
INSERT INTO mcq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ea irara uneunecha maꞌuꞌumaa hami vene ihajinanamujaho hu uneunecha mamaꞌina ꞌuꞌo hami vene ihajinanamiuna. ꞌEnakaivo ea irara uneunecha maꞌuꞌuma ꞌeke arira pavenujaho hu mamaꞌina ꞌuꞌo arira pavenuna. ");
INSERT INTO mcq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ijihuni hahi ja monia kaꞌene ꞌunama sisei jihunijaho arira paꞌajoꞌavajaho ea irara monia kaꞌene aririjaho ja vajiꞌena? ");
INSERT INTO mcq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ꞌEne ja uneunecha ea ꞌahopunijija hamia paꞌajoꞌavajaho irara vu jona rehunijaho vajiꞌena? ");
INSERT INTO mcq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pwea pina maiꞌo mamaꞌina noꞌoheꞌi puni kaukara pavehuna. Hu ea pina oja maꞌikaꞌi pina sehuna. ꞌEe ea pina teamaꞌi kaivo pina sehuna. Ijihuni hahi ja Godi oja mahe ꞌee monia oja mahuna areria parehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ꞌEjume Parasia ijí henareja Hu apene ꞌijahara. Ijihuni maijaho pu moniaꞌe oja mihuni jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ꞌEjume Hu pu ijá ꞌiama Ja emaapo kiꞌejuꞌe hami ꞌurahe oju kaivo Godira joni oja vaja nihe parajiꞌina. Ijihuni maijaho iraka kaꞌene emaapo vwihajuꞌe mamaꞌina rejujaho Godira kimujaho ijijahija nihoꞌo sisemaa. ");
INSERT INTO mcq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nitama rene varapa tamana ꞌee poropetiapo ꞌwaramape rouvaꞌo roe Jonira hinaji ꞌeꞌujara. Vea kaji rene Godoni arijihuni vuꞌijaho najahukame ea mapokakaho ijí ꞌunama kajino vaꞌaruꞌiro piijaravu. ");
INSERT INTO mcq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mweꞌa ꞌee akúpakaho paꞌarehuna kaivo Godoni ira nihoꞌo papaꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ꞌEnajihunaꞌe parua kaꞌene huni napara kaji ranamajara veje hu parua pina veꞌamajaho pu sisea vehuna. ꞌEe ea irara napara kaꞌene ranaviꞌiniji ꞌwaꞌamajaho hu ꞌuꞌo sisea vehuna. ");
INSERT INTO mcq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nitama ea pina ateha nihoꞌo mavarasaꞌini same ꞌee uneunecha mapoka ani reꞌejuꞌe ara mavarasaꞌini ꞌiruma mamai ijiꞌi hinuna. ");
INSERT INTO mcq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","ꞌEꞌejuꞌe ea pina pivujiꞌina huni iha Rasarasina ꞌwavujaho nihoꞌo ꞌiruma paꞌana ꞌee matana rejiꞌinaꞌomo roe ea kaꞌene ꞌiruma ani rejiꞌina kajihuni vwicha jiami ꞌiruma sahura kaꞌene arihuji iꞌi ꞌahauꞌe roe hinuna. ꞌEꞌejuꞌe ꞌuapo roe huni matana sihura. ");
INSERT INTO mcq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ꞌEnuvaꞌo ea kaꞌene ꞌiruma paꞌajaho kwavume Godoni ꞌona ojiꞌinapo apene vaꞌe Eparahami oni rori ranaꞌeme ea kaꞌene ꞌiruma ani rejiꞌinija ꞌuꞌo kwavume kwananavara. ");
INSERT INTO mcq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hu vena kaꞌene pautarutusaviꞌinijino rejiꞌi aꞌama kavume Eparahami oni rori Rasarasiho hinana. ");
INSERT INTO mcq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ꞌEjume hu ijá ꞌumena Nuni oma Eparahami na numirime Rasarasi ranave roe ija toi apúsame nuni mitara ꞌahi ranave ohoa kaꞌene renujaho paha renama. Ijihuni maijaho na nihoꞌo niꞌimaꞌura hianiꞌejuꞌe vena rirakino hijukúne ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ꞌEnakaivo Eparahamira ijá ꞌwama Harihe a mweꞌi hinajaho vwihaꞌamana. A mariꞌuviꞌi hinana. ꞌEne uneunecha mamaa ꞌekana kaivo Rasarasiho siseaꞌe piunama jihunaꞌe hu iviamaa mamaa piuname teamaꞌejuꞌe a haha niꞌimaꞌura hianamu. ");
INSERT INTO mcq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ꞌEne nú areri ea kaꞌene ikaꞌahuni hijukija karaꞌahuna pavuꞌe ꞌee karahuni hijujija ikaꞌahuna parohuna. Ijihuni maijaho raraha natohwa ronu ronu rejaraꞌomo ijí apúsama karaꞌi ajihuna nihoꞌo areria pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","ꞌEjume ea kaꞌene uneunecha mapoka ani rejiꞌinijara ijá ꞌwama Oma nune na jarirame ꞌwaravukúne Rasirasiho ranave nuni omijihuni sei vaꞌamana. Ijihuni maijaho popu nuna iropu hijukúne ꞌwarave pu ike ara kaꞌene haha hianaviꞌinakaho ea pina paroꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eparahamira ijá ꞌwama Popuana Mosisiho ꞌee poropeti ꞌwaraviꞌinijija hijukúne ijipo ꞌwarave heja ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ꞌEjume hu ijá ꞌwama Pana. Nuni oma Eparahami ijaho maiꞌo areri pareniꞌena kaivo ei pini kwamani ꞌurina vaꞌe ꞌwaraꞌipisa pu areri puni sisea taꞌarohaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pu areri Mosisiho ꞌee poropeti panimaa rojujiꞌhunaꞌe ei pini kwamani ꞌurina vaꞌe ꞌwaramajaho pu panimaa rohuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesura Huni tisaiporu ijá ꞌiama Siseijaho naꞌia mapoka namuna. ꞌEnakaivo ea kaꞌene ijí vejuꞌe ea sisea vejujaho túnaꞌi eha sisea niꞌimaꞌura apehuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ea kaꞌene vejuꞌe sesamakihi sisea vejujaho muna natohwa apene oroa ꞌahi vevahame soha vaji piꞌonave kwaꞌipisa areri rejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ꞌEnakúne ojono hami hami ꞌajoꞌavara. ꞌEne joni ei pini sisea veꞌamajaho ꞌurarahe hu huni sisei temuꞌamajaho vwihane areꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ꞌEnareje hu vea nikwinuꞌina vaja kajino ꞌaha iropu noꞌo ja sisea vetiareje hu roe siseaka vena kajara temuve areꞌirono nahama ꞌwarava kaꞌavajaho vwihana areꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apasorupo Natohwijaho ijá ꞌwava Núni nimaaroiji veje natohwaꞌe renama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Natohwijara ijá ꞌiama Jara nimaa rojujaho kwava ꞌina saꞌinaꞌe reꞌipisa ja maraa ꞌwarave joni ira hene tanapi tajahene vaꞌe sohi vaji namijaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pwea joni pini juasiꞌi soa samoja ho sipiaꞌe ꞌajohoꞌiraꞌomo roꞌipisa ja ijaꞌina paꞌwavaꞌa Marako roe hine ꞌiruma ona ina paꞌwavaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ꞌEnakaivo ja ijá ꞌwavaꞌa Marako nuni ꞌiruma amairie ꞌaijua ꞌahi irechamihe na ꞌiruma ija kamaꞌe ijiꞌa túnaꞌi oni ꞌiruma iꞌamana ꞌwavaꞌa. ");
INSERT INTO mcq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ꞌEjakame huni natohwijaho maiꞌo pweaha kajaho patea mani ꞌwavaꞌa. Ijihuni maijaho ijaho huni kaukara ijihunaꞌe hu venuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijaꞌinaꞌe ja Nara ꞌwarauti Nuni ira ꞌahijiru veꞌi kaivo ja ojono joni oji paꞌene veꞌavajaho nú pwea sisea ꞌwaha ꞌee nú núni kaukara ijihunaꞌe vejara ꞌwaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hu Jerusaremi vaꞌi ꞌahaume Sameria ropua navume Karari ropunaꞌi naꞌeme Hu riri vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ꞌEnarena Hu ara pini vaꞌe ꞌeꞌuꞌeme ea iropu ropu reporosia rukina piunimajaho pu karori namijara. ");
INSERT INTO mcq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ꞌEne pu ira ajira ijá ꞌumeja Jesu kaꞌene Natohwijiꞌo nú numiruma ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ꞌEjume Hu kima ijá ꞌiama Ja vaꞌe pirisiti joni haha najaꞌavara ꞌiamana. ꞌEjume pu ꞌunamutoi vaꞌeme puni reporosia niꞌaha kwino paꞌarenaara. ");
INSERT INTO mcq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ꞌEꞌeme ea kwino huni hahaꞌe kamajaho huni reporosia paꞌarenana kamarena ꞌuname roiꞌi Godiho nihoꞌo ira ajiraꞌe taꞌarohana. ");
INSERT INTO mcq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ꞌEna hu roe Huni unaꞌi kajino ona apena arihe niname Jesuho teimani ꞌwamana. Ea kaꞌene ijá venajaho Sameria ora. ");
INSERT INTO mcq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ꞌEjume Jesura eha vene ijá ꞌwama Ea ja iropu ropu maraniana kaivo ea iropu noꞌona noꞌo ijano ichihune? ");
INSERT INTO mcq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iraka vene ike ea apiorakara huhuso ꞌunama roe Godiho taꞌaroꞌi roane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ꞌEnarena Hu hu ijá ꞌwama ꞌUrine vaꞌa! Ara nimaa ronujara venaume maranaana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parasia Hu apoma ijá ꞌwava Vea vecha Godoni arijaho roe aneja reꞌena ꞌwavara. ꞌEjume Hu ijá ꞌiama Godoni arijaho aacha ani aniꞌina pareꞌeje rohuna. ꞌEjakame ja pakahuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ea maiꞌo ijaꞌina paꞌiahuna. Heha! Ikena karona paꞌiahuna. Ijihuni maijaho Godoni arijaho ijí joni vajina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ꞌEnarena Hu Huni tisaiporu ijá ꞌiama Maiꞌo naꞌia pini Emaa Puni Hariha kahuna ura renahuna kaivo ja Hu ikaho pakahuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ꞌEjakame ea ꞌahopo ijá ꞌiahuna Karohunakúne kaha ꞌee ikehunakúne kaha ijá ꞌiava heꞌavajaho ja pausema vaꞌe kiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Areri vei akúpi ꞌahi kamaꞌi piꞌima ro vaꞌe karoꞌi ꞌonu kajaꞌinaꞌe Ema Puni Harihijihuni veijaho ijaꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ꞌEnakaivo Hu marakuꞌijaho haha natohwa hiame ꞌee ea kaꞌene iviamai hijujija Hu kame pataarohuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Vea kaꞌene Emaa Puni Harihijihuni veijaho ea kaꞌene iki mweꞌi hiꞌavajaho areri ea kaꞌene Noara mweꞌi hiꞌeme hijajaꞌinaꞌe hihuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa oni veijino ea mapokakija hine ꞌirumaꞌe ine ꞌee toa sisea ine ꞌee napasinene ꞌee napara same areme apene vaꞌeme Noaho huni sisima vaji vaꞌeme sai hirame ea mapoka kajija ꞌaniume kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Vukúꞌo areri Rati oni veijino ea kaꞌene hijajaꞌinaꞌe hihuna. Ea mapoka kajija hine ꞌiruma ine ꞌee toa sisea ine uneunecha ꞌimene ꞌee ea ꞌahoꞌa ꞌimenae ꞌee soa same ꞌee ara vejiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ꞌEꞌeme vea kaꞌene Ratira ara iha Satami arema vaꞌeme vena kahino akúpa ꞌahi rena roe ea mapoka kajija re paranana. ");
INSERT INTO mcq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijaꞌinaꞌe vea kaꞌene Emaa Puni Harihijara roꞌamani veijaho ijá rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Vea kajaho ea pina atahuri namiꞌamajaho hu kúꞌo paariha vaꞌe huni kukua ekahune ꞌee ea pina juasiꞌi oꞌamajaho hu paꞌunama ara vahuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rati oni napari venaji vwihaha. ");
INSERT INTO mcq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ꞌEje ea irara huni hiiji ori niꞌajaraꞌamajaho huni hiijaho ranahuna. ꞌEne ea irara huni hiiji ori ranaꞌamajaho hu huni hia ꞌunanahuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na ja ꞌwaravu. Naꞌia kaji ea noꞌo ahuma noturaꞌomo ea pina apena vaꞌeje ea pina ranahuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ꞌEne napara noꞌo hine ahuma kaukara veꞌiraꞌomo pina apena vaꞌeje pina ranahuna. ");
INSERT INTO mcq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ea noꞌo juasiꞌi ꞌurahe oꞌiraꞌomo pina apene vaꞌeje pina ranahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ꞌEjume pu Hu eha vene ijá ꞌwava Natohwe vea vecha ijaho reꞌena ꞌwavara. ꞌEjume Hu ija ꞌiama Unenuꞌu pini kwama naꞌamajaho púrúha ijá ꞌemojura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ꞌEnarena Hu ike haakaho ꞌwaramana. Ijihuni maijaho Hu ura renajaho pu majamano hine siporua pasenaꞌeje ꞌoꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ara natohwa pini ea ꞌotua hejiꞌina pina Godiho pajuhame ꞌee ea ꞌahopuni hura pavejiꞌi hinuna. ");
INSERT INTO mcq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ꞌEnaꞌomo amuna pina ꞌuꞌo ijí ara kajino hinunaꞌomo hu naꞌia mapokaꞌe vaꞌe ꞌotua veꞌi ꞌahauꞌe pasonananamuna. Napara kajara hu ijá ꞌwamune Ea pini na hine sisei ꞌahiukúne niꞌajiha ꞌwamuna. ");
INSERT INTO mcq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ꞌEnakaꞌi nitama rene hu hine napara kajaho pataarohana kaivo naꞌia kwino hu ijá rona Na Godiho pajuhame ꞌee ea ꞌahopuni hura pavejura. ");
INSERT INTO mcq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ꞌEnakaivo amunakaho majama roe ꞌwarimu jihunaꞌe hura ura renuji na vehuna. Ijihuni maijaho hura pasonanavakame na siseranihuni jihunaꞌe na niꞌajahuna ronana. ");
INSERT INTO mcq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ꞌEnarena Natohwijara ijá ꞌiama Ea kaꞌene ꞌotua hejiꞌina siseijara iraka kaꞌene ꞌwaramaji heha! ");
INSERT INTO mcq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ꞌÚ Godiho Huni ehija kaꞌene Hura iji pijihajipo iraka kaꞌene veiriꞌa naꞌia ijikano siheria paveꞌi kaivo jariviꞌi navujaho Hu arimaa pamihuna raka? ꞌÚ Hu hine tetamu vaꞌuꞌe ijiꞌa vajihuna raka? ");
INSERT INTO mcq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na nimai ja ꞌwaravu. Iraka kaꞌene arira maijino Hu pu marako vajihuna. ꞌEnakaivo vea kaꞌene Emaa Puni Harihijara roꞌamajaho ea vi icharo iki mweꞌi nimaa rojiꞌina hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ꞌEnarena Hu haa ike ꞌuꞌo ea kaꞌene pu pusumano arira maa roꞌikaꞌi ea ꞌahoꞌa senavujihi ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Naꞌia pini ea noꞌo kahi Temiporu vaji siporuaꞌe ꞌoꞌi ꞌahiume vaꞌara. Ea pina Parasia ꞌee ea pinijaho takisiaꞌe apejiꞌina. ");
INSERT INTO mcq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ea kaꞌene Parasi ijaho huhusu namijiꞌi siporua ikaꞌinaꞌe ꞌonana. Godi teimani ꞌwavujaho na ea ꞌahoꞌa kaꞌene pu pusumano vwihane ꞌee iraꞌata apene ꞌee napara hurichavu jaꞌina pana. Na A teimani ꞌwavu. Ijihuni maijaho na ea kaꞌene takisiaꞌe apejiꞌina kaꞌene kame naminu kaji vareꞌina pana. ");
INSERT INTO mcq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na hura kwino vaji ꞌaha noꞌo ꞌaura areme ꞌee uneunecha kaꞌene na ꞌekujaho ꞌahoꞌa taisia vejiꞌi hijura ꞌuáme ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ꞌEnakaivo ea kaꞌene takisia apejiꞌinijaho karori namine huni niura akúpa ꞌaha paniriꞌi kaivo túra ꞌahi ꞌanaiꞌi ijá ꞌwama Godi na ea siseakúne numirima ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ꞌEnajihunaꞌe Na ja nimaa ꞌwaravu. Ea kajaho arira rena huni sei vaꞌana kaivo pinijaho pana. ꞌEnaꞌomo ea irara oriꞌini huni pinana ahasiriꞌamajaho Godira vetie hu ajuarana ohuna. ꞌEnakaivo ea irara oriꞌini ajuaraꞌamajaho Hu vetie huni pinana ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ꞌEnakaivo ea ꞌahoꞌapo kasimaa aherame ꞌeka roume Hu Huni ija puni húmata ꞌahi irechamiꞌamarono roajivara kaivo Huni tisaiporuepo eaka mapoka kajija ꞌurarahara. ");
INSERT INTO mcq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ꞌEnakaivo Jesura ijá ꞌiama Kasima kajija makiꞌeje Nuni roajiva kaivo ja patanuꞌuriha. Ijihuni maijaho Godoni arijaho kasimaa ikipo vejujaꞌinaꞌe vejujihipuni ara. ");
INSERT INTO mcq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na nimaa nimai ja ꞌwaravu. Ea irara sesamapo Godoni ara apeju jaꞌinaꞌe paapeꞌamajaho Godoni ara pavahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jua puni ea natohwi Hu apoma ijá ꞌwama Najuhiꞌina mavarasaꞌine na unenuꞌu pina maa icháꞌinaꞌe venareje majama hihunijaho apeꞌejo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ꞌEjume Jesura ijá ꞌwama Irakijihunaꞌe a Na mamaa ꞌwimo? Godira nikwinuꞌwi Huhuri mamaana. ");
INSERT INTO mcq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A Godoni tamana nihenuna. A napara paturaꞌamane ꞌee ea paꞌanaa kwaꞌamane ꞌee nesa paapeꞌamane ꞌee a ea pina sisea panamaꞌamana. ꞌEne omuna ꞌee ohuna ijihipuni ira hena veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ꞌEjume hu ijá ꞌwama Na nitama sesamuꞌuru rene tamana kajaho hami venapena routa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ꞌEnakaivo Jesu ijí henarena Hu ijá ꞌwama A unenuꞌu pina kwinu maiꞌo areri paꞌana. A vaꞌe oni uneunecha mapoka ꞌeke ꞌimenarejaꞌe monia ona ꞌeka ea uneunecha paꞌaji vajiꞌamajiꞌa oni uneunecha mamaa akúpa ꞌaha nahuna. ꞌEꞌeje ijiꞌa roe Na ꞌararihiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ea kajaho ijí henarena temumana. Ijihuni maijaho hu nihoꞌo kukua mapoka rukini jihunaꞌe avanana. ");
INSERT INTO mcq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ꞌEꞌeme Jesura ea kajaho kaviꞌi ijá ꞌiama Ea kaꞌene uneunecha mapoka rukinijipo Godoni ꞌunami vahunijaho nihoꞌo kisina. ");
INSERT INTO mcq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ꞌEnakaivo mahi nitirua huni titi vaji aruma vahuna samaa kaivo ea kukua uneunecha rukimaꞌurijara Godoni ari vahunijaho kikisimaꞌura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ea ꞌahoꞌa ijí henareja ijá ꞌwava Ea irahipo majama hihuna apeꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ꞌEnakaivo Hu ijá ꞌiama Emapo ijaꞌina vehuna nihoꞌo areria pana kaivo Godira Huhuso ijá kajaho vehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ꞌEjume Pitara ijá ꞌwama Hena! Nú núni ara areꞌi kaivo A ꞌararihae oju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ꞌEjume Hu ijá ꞌiama Na nimaa nimai ja ꞌwaravu. Ea pina maiꞌo huni ara napara vwehwaha emahwaha ꞌee sesahwaha Godoni arijihunaꞌe irechamiajara ");
INSERT INTO mcq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hu nihoꞌo iviamaa iki ꞌaha mapoka ꞌekareje túnaꞌi majama hihuna apehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ꞌEnarena Hu ea iropu ropu noꞌo aherame ani vaꞌarame ijá ꞌiama Heha! Nú Jerusaremi vaꞌiro vejuraꞌomo poropeti nitama Ema Puni Harihiji uneunecha kaꞌene rehunaka vejajaho nimaaꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ꞌEne pu Hu apene Jenitaru mihe pu apene sipana asutie ꞌee siseꞌi ꞌahae ꞌee chera pisotihuna. ");
INSERT INTO mcq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ꞌEe hisi vene hijahe ꞌee pu Hu ꞌanae kwahuna kaivo vea noꞌopisu mweꞌi vaji namareje ijiꞌa kúꞌo ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ꞌEne pu nihoꞌo maꞌuako pina pahejara. Ijihuni maijaho iraka kaꞌene ꞌwaramajaho ijihuni maa vaji navumakame pu pahejara. ");
INSERT INTO mcq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hu Jeriko rori roꞌeme ea pina nia supaviꞌina ꞌunamutoi asuma hine ea jariraviꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hu hejume ea mapokaꞌe ruvaꞌume henarame aporame ijá ꞌiama Ikaho irakaꞌe vejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ꞌEjume pu ijá ꞌwava Jesu kaꞌene Nasareti orijara roa ruvaꞌu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ꞌEjume hu ijá ꞌumena Jesu kaꞌene Teviti oni Harihakere numirima ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ea kaꞌene urasahe vaꞌajipo ꞌurarahe iranoꞌa areꞌamarono ꞌwaravara. ꞌEnakaivo hu ira ajiraꞌe ijá ꞌumena Teviti oni Harihe numirima ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ꞌEjume Jesuho areme namiꞌikaꞌi ꞌwaravume pu ahema apene Huni roꞌavarono ꞌwaramana. Hu Jesuni rori roꞌeme Hu apoma ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Na irakaꞌe a vetaꞌurono a ura renao? ꞌwamana. ꞌEjume hu ijá ꞌwama Natohwe na ura kúꞌo nia niriꞌi ꞌahiu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ꞌEjume Jesura ijá ꞌwama Ara nimaa ronujara vejuꞌe maranaukúne nia niria ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hu niꞌaha kwinu nia nirie Jesu ꞌararihae ojiꞌi Godiho teimani ꞌwamana. ꞌEjume ea mapoka kajija ijí kamareja Godiho taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hu Jeriko ari maꞌaha rira kajino vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ea pina takisiaꞌe apejiꞌina niꞌine ꞌee monia nihoꞌo ani rejiꞌina iha huna Sakiasinaꞌomo ara kajino hinuna. ");
INSERT INTO mcq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ꞌEnakaivo ea kajaho ea tuꞌumaaꞌomo Jesu kaꞌi ꞌahaume venana kaivo eaka mapokijipo nuhaume pakamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ꞌEnarena hu urane ninuma vaꞌe turipa ꞌahi Jesura vahuni jihuniji vaꞌe kaꞌi ꞌahaume hinana. ");
INSERT INTO mcq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ꞌEꞌeme Jesura roe hura hinani hari namiꞌikaꞌi aꞌame kamarena ijá ꞌwama Sakiasi mamako ariha roa. Ijihuni maijaho Na iviasa oni sei vuꞌe hiꞌejukúne ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ꞌEjume hu mamako ariha roe Hu ꞌajomana. ");
INSERT INTO mcq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ꞌEjume pu ea mapoka ijí kamareja suꞌaraviꞌi ijá ꞌwava Hu ea ikaho ea sisea ikehuni sei vaꞌu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ꞌEjume Sakiasira ꞌurine Natohwijaho ijá ꞌwama Hena! Natohwe na nuni kukua pwinanaꞌa ea kaꞌene uneunecha paꞌajihi vajihe ꞌee nara ea ꞌahopuni nesaꞌe apejujaho na ꞌaha noꞌona noꞌona ijano huri eha venahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ꞌEjume Jesura ijá ꞌwama Godoni Niꞌajihiꞌinijaho iviasi sea ikino roana. Ijihunaꞌe ea ike ꞌuꞌo Eparahami oni hariha renana. ");
INSERT INTO mcq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ijihuni maijaho Ema Puni Harihijara ea kaꞌene ꞌunama puruva renauꞌukame pivusaha ojujihi sarame nianae niꞌajiꞌi ꞌahaume roana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ꞌEnarena Hu ea kaꞌene Huni vuꞌa kaji hejajihi ike haakaho ꞌwaramana. Pu vwihajajaho Godoni ara niroꞌi venu ꞌwavara. Ijihuni maijaho Hu Jerusaremi rori vaꞌajiva jihunaꞌe pu vwihana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ꞌEnarena Hu ijá ꞌiama Ea pina ara pini vaꞌe ea natohwa renareje ꞌunama roꞌi ꞌahaume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hu ijiꞌa vaꞌi ꞌahaume huni pwehija ea iropu ropunaꞌomo ꞌumenaume roajivume ea kwinu kwinu monia (K20) vajiha ijá ꞌiama Na vaꞌeje monia ikaho ꞌeka vaꞌe unenuꞌu ꞌahoꞌa veꞌeje na ꞌunama routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ꞌEꞌeme huni aea hura puni natohwaꞌe rehunijaho senavume pu ea irechamiume onaꞌe apena vaꞌe ijá ꞌwava Nú ara núni natohwaꞌe rehunijaho senumu ꞌwaꞌi ꞌahiume vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ea kajaho natohwa renarena hu kúꞌo ꞌuname roana. ꞌEnarena hu niꞌaha kwino huni pwea kaꞌene hu monia vajihajaho pu monia icháꞌinaꞌe vejaji kiꞌi ꞌahaume ꞌumenaume roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ꞌEjume ea pini ijá ꞌwama Natohwe ara monia (K20) kaꞌene na vajiha jaꞌinaꞌe na kúꞌo areri ijaꞌina huri (K200) ꞌekuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Hu pwea kajaho ijá ꞌwama A nihoꞌo mamaaꞌe venajihunaꞌe a pwea mamaa. A uneunecha maꞌuꞌumaa hami ꞌajoha jihunaꞌe nara ara mamaꞌina iropu ropu vajahe ara ijaho ꞌajoꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ea pini roe ijá ꞌwama Ara monia (K20) kaꞌene mihajino na apene huri vahame (K100) ꞌeka routa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hu ea kaji ijá ꞌwama A ara mamaꞌina iropu ꞌajohuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ea pini roarena ijá ꞌwama Natohwe oni monia na akisi mwama ranavutakúne apena. ");
INSERT INTO mcq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A ea ajisinaꞌomo soa kaꞌene a pasamajaho a juara samuna. ꞌEe a oni ija paꞌonajaho a menuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ꞌEjume ijí ea kajara ijá ꞌwama Ike nihoꞌo pwea kaꞌene ea maa paꞌakera ara icháꞌina ꞌwarama jihuni toi na eha mahuna. ꞌÚ a pahena pakimune? Na ea kisinaꞌomo na raka kaꞌene pairechavujaho na ꞌekure? ꞌEne na nuni iji paꞌojujaho ꞌú na pamejure? ");
INSERT INTO mcq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iraka vene monia kajaho paꞌeka vaꞌe panika vaji irechaꞌiraꞌomo na roe ijaho ꞌeke ꞌee ꞌahoꞌa ijí huri ꞌekuꞌe? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ꞌEnarena hu ea kaꞌene ijá namijaji ijá ꞌiama Monia kaꞌene nara vajahaji kúꞌo ꞌeka vaꞌe ea kaꞌene monia (K200) venaji maha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ꞌEnakaivo pu hu ijá ꞌwava Natohwe huni monia (K200) namu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na ja ꞌwaravu. Ea irara uneunecha rukinijaho mapoka huri vajahuna. ꞌEnakaivo ea irara paꞌana reꞌamajaho raka kaꞌene hununaꞌi navujaho ꞌetujahuna. ");
INSERT INTO mcq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ꞌEnakúne iviamaa nuni naka kaꞌene nara puni natohwaꞌe rehunijaho ura parenajija aherame roe nuni unaꞌi ꞌania kwamasaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesuho ijá ꞌwaravume paꞌareꞌeme Hu urane Jerusaremi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hu roe huriꞌa iha Arivi ꞌwavuraka ara iha Petapeje Petani ꞌwavujihuni roriji vaiꞌi Huni tisaiporu noꞌoheꞌi irechamiꞌikaꞌi ikaꞌina ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ja vaꞌe ara pini useviꞌi kave tonikia pirona iꞌivananave namija kaꞌavajaho ea maiꞌo ijihuni toi paꞌojiꞌinakúne rasame apene roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ea ꞌahopo aporame ijá ꞌiava heꞌavajaho Ja irakaꞌe vene rasavo? ꞌiava heꞌavajaho ijá ꞌiaꞌavara. Nuni Natohwijara ura rejuꞌe ijihunaꞌe avaju ꞌiaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ꞌEjume pu vaiꞌi kivume uneunecha mapoka kajija areri Hu ꞌwarama kajaꞌinaꞌe rejara. ");
INSERT INTO mcq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pu tonikia pirona kaji rasaꞌeme ea anesuri aporame ijá ꞌiama Ja irakaꞌe veꞌirono tonikia pirona kajaho rasavo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ꞌEjume pu ijá ꞌwava Núni Natohwijara ura rejuꞌe rasavu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ꞌEne pu tonikia pirona kajaho apene Jesuni roajivara. ꞌEne ateha ijí tonikia ꞌaha kajino risaremu vaꞌo Jesuho niꞌajaha apene ranavume ajime asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ꞌEne Hu vaꞌejuꞌe pu ateha ꞌeke ꞌunamutoi risarevara. ");
INSERT INTO mcq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pu vaꞌajime huriꞌa Arivi rori vutuijino tisaiporu mapokaꞌe piunime Godira uneunecha mavarasaꞌina kaꞌene vejume pu kivajihunaꞌe teimani ꞌwame ꞌee taꞌarohiꞌi vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pu ijá ꞌumeja Kinia kaꞌene Natohwi jihuni iha ꞌahi roujaho merajaha! Matauviꞌina ꞌakúpi ꞌahi name ꞌee Godi Ichutomaijí taꞌaroha ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ꞌEjume Parasia ꞌahopo ea rira kajino Hu ijá ꞌwava Najuhiꞌine Oni tisaiporu ꞌuraraha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ꞌEjume Hu eha vene ijá ꞌiama Na ja ꞌwaravu. Pu iranoꞌa areꞌavajaho muna ikipo ꞌurine mwasirihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hu ara natohwi jihuni rori roi kamarena niramana. ");
INSERT INTO mcq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hu ijá ꞌwama A iviamaa uneka kaꞌene venae matauma hihuniji apeꞌipisa nimaa rojaꞌa kaivo iviamaa a areri pakahuna. ");
INSERT INTO mcq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Vea ijihunijara roꞌeje oni nakapo roe a júhone rora rora kaji rene roajiꞌeje a ꞌeꞌuꞌamajaho pu tanuꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pu a nihoꞌo tirakunahe ꞌee oni sesamaa puꞌúmo ea kaꞌene ijihuni vaji hijujaho atoꞌarumahe parane ꞌee muna pina oni ruha panahuna. Ijihuni maijaho Godira a niꞌajaꞌi ꞌahaume roꞌajaho a pakama jihunaꞌe avahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hu Temiporu vaji vaꞌe ea kaꞌene ijí ꞌimeꞌaraviꞌi hijajihija ꞌararihiana. ");
INSERT INTO mcq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hu pu ijá ꞌiama Godira Huni ira vajijino ikaꞌina venana. Nuni sea Nuni siporuaꞌe ꞌohuni ara. ꞌEnakaivo ja apene nesa apehuni araꞌe veju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hu veku veku Temiporu vaji vaꞌe najahuna. ꞌEjuꞌe pirisitia mamaꞌina ꞌee Sikuraipia ꞌee emaa puni mamaꞌinijipo ꞌanaꞌi ꞌahiuꞌe vejura. ");
INSERT INTO mcq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ꞌEnakaivo pu areri parenauna. Ijihuni maijaho ea mapoka roe Hura vuꞌa kaꞌene ꞌwaramujaho nihoꞌo ira avwanamie hejura. ");
INSERT INTO mcq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Naꞌia pini Hu Temiporu vaji hine najahe Godoni vuꞌa mamaiji ꞌwaraꞌeme pirisitia mamaꞌina ꞌee Sikuraipia ꞌee ea mamaꞌinapo ");
INSERT INTO mcq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hu ijá ꞌwava A harura irakijara rejuꞌe ꞌee irara harura ikaho mahuꞌe A uneunecha ikaꞌina venujaho ꞌwaruve heja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","ꞌEjume Hu eha vene ijá ꞌiama Ijinakúna ja mareꞌeje Na ꞌuꞌo ja aporave ja eha vene ꞌwarihuna. Jonira ea toi samajaho akúpi ꞌahi rena roana ꞌaho ema puni rena roane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pu hine aposarame ijá ꞌwava Nú ika ꞌwaꞌavajaho akúpi ꞌahi rena roana ꞌwaꞌavajaho Hu ijá ꞌúꞌena ꞌEne ja ichá vene panimaa rojare? ꞌúꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ꞌEnakaivo nú ꞌemaa punina ꞌwaꞌavajaho ea mapoka ikipo muni nú ꞌanúhuni jihunaꞌe paꞌwarahuna. Ijihuni maijaho pu Joniho poropetia nimaa rojura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ꞌEnajihunaꞌe pu eha vene ijá ꞌwava Harura kajara ichihi rena roajaho nú puruva renu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ꞌEjume Jesura ijá ꞌiama Nijinaꞌomo harura irakijara rejume avajujaho Na paꞌwarahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ꞌEjume Hu ea mapokaꞌe haa ikaho ꞌwaramana. Ea pina juara mene ea ꞌahoꞌaꞌe aremaꞌi kaivo hu kwaa jori vaꞌe ꞌaha jopatuꞌura hinana. ");
INSERT INTO mcq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ꞌEꞌeme juaraꞌe sahuni vei roumakaviꞌi hu huni pwea ranavume vaꞌe ꞌiruma hunaꞌe ꞌeka roꞌi ꞌahaume vaꞌana. ꞌEnakaivo ea kaꞌene ijí juara ꞌajoha hijajipo ape hijahuvaꞌo ranavume ija maisu vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ꞌEjume pwea pina ranavume vaꞌume pu apene hijahe ꞌee vejume hu vahiꞌa apejumakaviꞌi ranavume ija maisu vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ꞌEjume hu huni pwea pina kúꞌo ranavume ijí ea kaꞌene juasiꞌi hiju kajipo ꞌanae piꞌonavume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ꞌEjume eaka juara anesurijara ijá rona Na icháꞌina veꞌejo? Na nuni hariha ranave vaꞌakame pu huni ira hena veꞌeja ronana. ");
INSERT INTO mcq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ꞌEnakaivo ea kaꞌene ijino juasiꞌi hijujipo kavume ariha roumakame piraꞌarame ijá ꞌwava Ea kajara juarakaho túnaꞌi ꞌajoꞌenakúne roe ꞌanaa kwaꞌirakúne juasiꞌakaho núnaꞌe reꞌenakúna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ꞌEnarame pu hu apena piꞌonavume samai vaꞌumakaviꞌi ꞌanaume kwamana. ꞌEnajihunaꞌe juara anesurijaho pu ichá ꞌahiꞌena? ");
INSERT INTO mcq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hu roareje ea kaꞌene juara ꞌajohajija ꞌanie kwamasahe ꞌee juara kajaho apene ea ꞌahoꞌaꞌe mihuna ꞌiamana. ꞌEjume ea kajipo henareja ijá ꞌwava Nihoꞌo areri pana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ꞌEjume Hu kimuvaꞌo ijá ꞌiama Ike Godoni ira vaji vuꞌa kaꞌene ꞌwaruma jihuni maijaho irake? Ijí muna kaꞌene ara vejiꞌinapo piꞌonava kajara iviamaikaho ara kajihuni kúrúti tukeja natohwaꞌe rena namino? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ea kaꞌene ijihuni toi ariha ninavujaho nihoꞌo puꞌusahura ꞌee muna kajara ea irahuni toi ꞌoꞌamajaho hu túa rene va ranahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ꞌEne Sikuraipia ꞌee pirisitia mamaꞌinijipo Hu nijihijakaro apeꞌi vejara. Ijihuni maijaho ijí haa kajaho puaꞌe ronarena ꞌwaravume henareja apeꞌi vejara kaivo ea mapoka kajihi juhamareja arevara. ");
INSERT INTO mcq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pu Hu hami kaviꞌi ea ꞌahoꞌa ea mapoka puni vaji iraꞌatijino ea arira rene puni vaji ꞌurahojara. Hura ira icháꞌina ꞌwaravakame ꞌunama apene roe kavana ijí maꞌirono ꞌurahojara. ");
INSERT INTO mcq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ijí ea kajipo Hu apoma ijá ꞌwava Najuhiꞌine uneunecha kaꞌene Ara ꞌwarume najuhujaho nimaa. Nú nihena kavu. A ea kwinuꞌwi vwihanuna pana kaivo Godoni ꞌunama nimaiji najuhu. ");
INSERT INTO mcq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ꞌÚ nú Sisa oni takisia vehunijaho varapa ho pane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ꞌEnakaivo Hu pura iraꞌata kaꞌene vejajaho kimarena ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Monia oma pina najiha kavuma. Ijihuni toijaho irahuni húmatijiꞌo ihijiꞌo navo? ꞌiamana. ꞌEjume pu Hu ijá ꞌwava Sisa ona ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ꞌEjume Hu pu ijá ꞌiama Sisa oni kukuijaho Sisa vajaꞌi kaivo Godoni kukuijaho Godi vajaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ꞌEjume pu emaa puni vaja kajino Jesu pisimihuna areri parenana. Pu Huni eha kaji henareja oja hianavumakame iranoꞌa paꞌarejara. ");
INSERT INTO mcq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sajusi eaka kwamasahiꞌinijipo kúꞌo ꞌurihunijaho panimaa rojiꞌinaꞌomo Huni roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ꞌEnaꞌomo pu Hu apome ijá ꞌwava Najahiꞌine Mosisira tamana ikaꞌinaꞌe venana. Ei pini kwaꞌi kaivo naparaha hariha paꞌanaꞌe ranamana. ꞌUꞌuahi napara kajaho ꞌwahareje pokaha kaꞌene kwamajihunaꞌe hariha sarahuna. ");
INSERT INTO mcq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ea ꞌuꞌua poka iropu noꞌo hijara. ꞌEnaꞌomo amurijara napara ꞌwahe napara hariha paapeꞌeme hu ꞌuꞌo kwamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","ꞌEjume huni ninahijara ꞌwahana kaivo hu ꞌuꞌo napara kajaho amuja paveꞌeme kwavume huni niijahijara ꞌwahana kaivo hu ꞌuꞌo kwamana. Ea iropu noꞌo napara nikwinuꞌina kaji ahevara kaivo hu amuja paveꞌeme pu kwamasa ranavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ꞌEꞌeme napara kajaho ijí túnaꞌi kwamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ꞌEnaꞌomo vea kaꞌene ea kwamasahajipo ꞌuriꞌavajaho hu irahuni napara reꞌena? Ea iropu noꞌo hu ꞌwahara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Jesura eha vene ijá ꞌiama Ea kaꞌene ikino mweꞌi hijujipo napasi nehuna kaivo ea kaꞌene kwamasahe ꞌurine majama hijujija panapasi nehuna. ");
INSERT INTO mcq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pu areri Godoni ꞌona ojiꞌina saꞌine ꞌee pu Godoni harihija. Ijihuni maijaho pu Godoni ehije ꞌee pu kúꞌo ꞌurihuni jihuni harihija. ");
INSERT INTO mcq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ꞌEnakaivo nitama Mosisira najuha jaꞌinaꞌe kwamasahiꞌinijija ꞌurijura. Ijihuni maijaho vea kaꞌene veni icha vaji rejiꞌi namajino Mosisira Natohwijaho ijá ꞌwama A Eparahami oni Godi ꞌee Aisiki oni Godi ꞌee Jekapi oni Godia ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ijihuni hahi Hu iviamaa kwamasahiꞌina puni Godi pana kaivo Hu maiꞌo hiju jihipuni Godi. ꞌEnakaivo Godira kimuni ꞌunamijaho ea mapoka maiꞌo hiju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ꞌEjumakame Sikuraipia ꞌahoꞌapo pu eha vene ijá ꞌwava Najahiꞌine Oni eha nihoꞌo mamaa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ꞌEnareja pu unenuꞌu ꞌahoꞌa kúꞌo apohuna harura paꞌarenaume paapovara. ");
INSERT INTO mcq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hu pu ijá ꞌiama Ichá vene Kerisoho Teviti oni Harihe ꞌúvo? ");
INSERT INTO mcq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ijihuni maijaho Tevitira oriꞌini heha kaꞌene Samusi vaji ꞌwaramana. Natohwijara nuni Natohwiji ijá ꞌwama A Nuni ija manaꞌinikaꞌi asuma hiꞌeje Na Oni naka Oni mumora hari irechavuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tevitira Hu Natohwa ꞌwamu kaivo icháꞌina vene Hu huni Hariha renane? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ea kaꞌene mapoka kajija hine heꞌeme Hu Huni tisaiporu ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Sikuraipia hami kiꞌavara. Pu ateha jojora same ꞌee pu maketi ea ꞌahoꞌapo pu kimareje oja mihe hura puna vene ꞌee hami ꞌajorame ꞌee Sinakoku vaji ruha kaꞌene mamaꞌinijihi ꞌeke unaꞌi kama hijura. ꞌEe ahaja ijuri veijaho pu ura kahe eaka mapoki jihipuni unaꞌa kahi hiꞌirono ura rena parajura. ");
INSERT INTO mcq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ꞌEne pu amuna pisivisaviꞌi puni sea nesi ꞌeke ꞌee pisivisame erapo kiꞌavarono siporua jojora ꞌojura. Ijihunaꞌe ja nihoꞌo niꞌimaꞌura namahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Hu ꞌurine katua tevua rori ijí hina ea kaꞌene uneunecha ani rejiꞌinijija roe puni swara savu kaji kiviꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ꞌEꞌeme amuna kaꞌene uneunecha paꞌamaijaho urupa vaꞌaa noꞌo (tu toia) eru samana. ");
INSERT INTO mcq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ꞌEjume Hu ijá ꞌiama Na nimai ja ꞌwaravu. Amuna uneunecha paꞌamaa kajarahara moniaka ea mapoka kajipo roe katua kaꞌene savajaho asita ranamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ea pu monia mapoka vajaha jihuni maijaho pu monia rukini jihuni hahi avajara kaivo amuna kajaho uneunecha paꞌajihunaꞌe huna kaꞌene areri navuji samajihunaꞌe hura eaka mapoka monia rukinijaho asita ranamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pu ea ꞌahoꞌa Temiporu kaji kame ꞌee muna mavarasaꞌini ꞌeka vene ꞌee swasa kaꞌene icháꞌinaꞌe vejuji hine ꞌwaꞌeme Jesura ijá ꞌiamana ");
INSERT INTO mcq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ike uneunecha kaꞌene ja kivukaho vea ijihunijara maiꞌo roꞌeje muna mapokakija tiraꞌusunahe ꞌarii paraꞌeje muna nihoꞌo kwinu huni ruha panahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ꞌEjume pu Hu apoma ijá ꞌwava Najuhiꞌine ikaho vea vecha reꞌena? ꞌEe vea kakara paꞌareꞌiro veꞌamani urijaho marakoꞌa aacha iraki reja kaꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ꞌEjume Hu ijá ꞌiama Ja hami kaꞌavara. ꞌEjakame pu ea ja papisimiꞌavara. Ijihuni maijaho ea mapokaꞌe Nuni iha ꞌahi roe ijá ꞌiahune Na Kerisonaꞌomo vea niapeꞌi venu ꞌiava heꞌavajaho nihoꞌo paꞌararihiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ꞌEjakame ja heꞌeje kwaa araka mapokija ajira vehune ꞌee ijí ajira vehuni pinana kajaho ꞌurina rohuna. Ijaꞌinijaho reꞌena vo urijaho maiꞌo pavaꞌa ꞌeꞌuꞌenakúne ja nihoꞌo pajuꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ꞌEnarena Hu kúꞌo ijá ꞌiama Kwaa ara ꞌahopo ꞌurine ꞌahoꞌa ninamahune ꞌee ara ꞌahopo ꞌurine ara ꞌahoꞌa ninamahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kwaa ara mapoka mwevarivura mamaꞌina rohuna. ꞌEne sisemaapo roe ꞌee kwaa ara mapoka ꞌora vea rene ꞌee atama siseapo kwaa ara mapokakaho ani rene ꞌee aacha mamaꞌina aniꞌina mapoka sisea akúpi ꞌahi kihuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Uneunecha mapoka ikija maiꞌo reꞌi veꞌeje Nuni ihijihunaꞌe ja aherama vaꞌe siseꞌi ꞌahie ꞌee tipurai irechamie ꞌee aherama vaꞌe Sinakoku vaji aporame ꞌee aherame kinia ꞌee kavana epuni unaꞌi vahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ja vea kajino areri Godoni vuꞌa mamaijaho pu najahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ꞌEnajihunaꞌe ja nimarako vwihanareje jara vuꞌa iraka kaꞌene ꞌwarahunijaho pavwihaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ijihuni maijaho Nara vuꞌa kaꞌene ara ꞌwarahuna vajahakame oni naka ara vuꞌa kaꞌene ꞌwaraꞌamajaho hene pu areri patanuꞌurahe ꞌee pu nihoꞌo unenuꞌu pina areri paꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ꞌEnakaivo emahu jona vwehu jona ehu jona napuhu jonapo nahamahe ea ꞌahopo ja ꞌanie kwamasahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nuni ihijihunaꞌe ea ꞌahopo ja senahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ꞌEnakaivo joni húmata sapasa kwisu patausiuhuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ꞌEnajihunaꞌe ata kirasahe naminareje ja majama hihuna apeꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ja kave Jerusaremiho amiapo outihe nava kaꞌavari veijaho ja ika roꞌavara. Ara kajara tiraꞌusahuni vea nikehuna roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ꞌEjakame ea kaꞌene Jutia hijujija juhahe nahari ꞌahi vaꞌe ꞌee ea kaꞌene ara natohwa kajino hijujija ꞌusema vaꞌajiꞌavare ꞌee ea kaꞌene nechiꞌi hijujija ara natohwa kajaho paroꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ijihuni maijaho eha kaꞌene mihunaꞌe Godoni heha vaji ꞌwaramajara nimaa rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Napara kaꞌene hariꞌinijija ꞌee napara kaꞌene hariha musa ijiꞌinijija vi icháꞌinaꞌe veꞌeja? Vea kajaho kwaa arakaho ea mapoka ajirijara siserana parajakame ea ikija niꞌimaꞌura siseisei temukaꞌeje hihuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pu soꞌwi pijihe kwamasahe ꞌee tipurai aherame kwaa ara ani aniꞌini vahuna. ꞌEꞌeje Jenitaruepo Jerusaremiho ajima tautia apena vaꞌeje Jenitairu puni vea paꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ꞌEꞌeje masapa ꞌee china ꞌee vea ꞌee akúpa ꞌahi aacha aniꞌina kihuna. ꞌEꞌeje ea mapoka kaꞌene mweꞌi hijukija soha kaꞌene sisea aniꞌinaꞌe amenareje ira aniꞌina ꞌumeꞌamaji henareje tea juname ꞌee nihoꞌo puruva retiꞌeje hihuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Emaa ijí uneka kaꞌene iki mweꞌi reꞌamaji kamareje nihoꞌo juma paranareje kwapihuna. ꞌEne uneunecha kaꞌene akúpa ꞌahi navujija akúpa kakara varivarimareje ꞌunirame usimahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ꞌEꞌeje Ema Puni Harihijaho ꞌimitia vaji Huni harura ꞌee Huni hanajiꞌinijiꞌi mahoꞌo roe ea mapoka kahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Vea kaꞌene uneunecha kajipo ikaꞌinaꞌe reja kiꞌavajaho ꞌurine nuana ahasirime aꞌama niriꞌi hiꞌavara. Ijihuni maijaho jara matauma hihuni vea nituꞌu rena paranu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ꞌEnarena Hu haa ikaho ꞌwaramana. Ja kaha! Mataka ꞌee icha ꞌahoꞌijihi kiha! ");
INSERT INTO mcq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ijipo ꞌanauraꞌomo maiꞌo nahejiꞌi sisira apúsavuꞌe kimareꞌe vea maraꞌi venu. ");
INSERT INTO mcq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vea kaꞌene ijí aneja kiꞌavajaho Godoni ari rohunijaho tuꞌu rehuna roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na nimai ja ꞌwaravukúne vwihaꞌavara. Eaka kijahija mahoꞌo pakwamasa ranaꞌeje ijaꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Akúpa mweꞌijaho paꞌarehuna kaivo Nuni Ira kakaho papaꞌareꞌena. ");
INSERT INTO mcq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ja hami hami ꞌajohareje pahine joni kaukararu vene ꞌee toa sisea ine ꞌee jara iviamaa ꞌunama kaꞌene icháꞌinaꞌe hami hihuna pavwihajiꞌi hiꞌavara. Ijihuni maijaho ja ijaꞌina hiꞌeje vea kajaho areri niꞌaha kwino kwavaha punaꞌi asuma va hihuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vea kajara reꞌamajaho ea mahoꞌo mapoka kaꞌene mweꞌa ꞌahakino hijujija renahuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ꞌEnakúne veku veku hine ꞌajohe nia nirie siporua ꞌojiꞌi hiꞌirakúne ja areri harura renaꞌeje uneka kaꞌene reꞌiro vejujaho asima vaꞌe Emaa Puni Harihijihuni unaꞌi namiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hu veiriꞌijaho hine Temiporu vaji najahuvaꞌo naꞌivukaviꞌi vaꞌe huriꞌa kaꞌene Arivina ꞌwavujihuni ꞌahi vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ꞌEjuꞌe ea mapokaꞌe súꞌusúꞌu arihe vaꞌe Temiporu vaji Huni vuꞌa heꞌi ꞌahiuꞌe vaꞌajivura. ");
INSERT INTO mcq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Puretia isitia paꞌana kaꞌene Pasova ꞌwavujihuni sora ꞌehuni vea roe turanana. ");
INSERT INTO mcq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ꞌEjume pirisitia mamaꞌina ꞌee Sikuraipia Hu ꞌanae kwahuni ꞌunama savara. Ijihuni maijaho pu ea mapokijihi juhavara. ");
INSERT INTO mcq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ꞌEjume Huni tisaiporu pina kaꞌene Jutasi Isikariatina ꞌwavujaho Setanira rosamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ꞌEjume Jutasira vaꞌe hura icháꞌinaꞌe Jesu nahamahuniji pirisitia mamaꞌina ꞌee sorutia puꞌúmo ꞌunama amairiara. ");
INSERT INTO mcq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pu nihoꞌo teamanavume eha monia vajaꞌi ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jutasi puni ira hene teamavumakame ꞌunama kaꞌene Hu nahamahuniji hami hema parajakame ea nihoꞌo areri pahehuniji samana. ");
INSERT INTO mcq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Puretia isitia paꞌajihuni vea aneja rejumakaviꞌi pu sipi ꞌuꞌua ꞌanae swasa vehuna. ");
INSERT INTO mcq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ꞌEjume Hu Pitaꞌo Joniꞌo irechamie ijá ꞌiama Vaꞌe Pasova ihuniji amairie nú ija ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ꞌEjume pu apoma ijá ꞌwava Nú vaꞌe ichihi ꞌiruma amairiꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hu ijá ꞌiama Ike heha. Ja ari vaꞌeje ea pina toa ꞌene vuꞌe piuniꞌena. ꞌEjakame ja hu ꞌarariha vaꞌe sea kaꞌene hu ajiꞌamajino vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ꞌEne ja ikaꞌina sea anesura ꞌwaꞌavara Najahiꞌinijara ikaꞌinaꞌe a ꞌwaramana. ꞌÚ ꞌiruma ijuri tinia kaꞌene Nara Nuni tisaiporu epuꞌúmo Pasova ihunijaho ichine? ꞌwaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ꞌEjakame hura ruha kaꞌene ichuto niamairiarame namuji najahakame ijino amairiaraꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ꞌEjume pu vaꞌajime uneunecha mapoka areri Hura ꞌwarama kajaꞌinaꞌe rejume pu Pasova kaꞌene ihunijaho amairiaravara. ");
INSERT INTO mcq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Vea kaji apejume Hu Huni apasorua puꞌúmo roe ꞌaijua rori asuma hijara. ");
INSERT INTO mcq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ꞌEjume Hu pu ijá ꞌiama Na ja puꞌúmo Pasovakaho inareje ijiꞌa haha hiana apehuna ura reniu. ");
INSERT INTO mcq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ꞌEnajihunaꞌe Na nimai ja ꞌwaravu Na kúꞌo ꞌiruma painu vaꞌuꞌe Godoni ari jara roe nimaae rejakame ijiꞌa ihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ꞌEnarena Hu kapusia apene Godiho teimani ꞌwaꞌikaꞌi ijá ꞌiama Ike apene vajúsarame iha. ");
INSERT INTO mcq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ijihuni maijaho ajina riha ikaho Na painuvaꞌo vea kaꞌene Godoni arijara roꞌamaji ihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ꞌEnarena Hu puretia apene Godi teimani ꞌwaꞌikaꞌi tuame vajihiꞌi ijá ꞌiama Ikaho Nuni hahaꞌe jonijihunaꞌe vajihukúne ina vejiꞌi Na vwihaniꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Areri puretia ijaꞌinaꞌe Hu toa kapusi rukina mihiꞌi ijá ꞌiama Ike kapusia toa rukinakaho Nuni ꞌaa kaꞌene jonijihunaꞌe arihunaꞌe maiuꞌinaka nahama ꞌwaramajina ꞌiaviꞌi mihana. ");
INSERT INTO mcq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ꞌEnakaivo heha! Ea kaꞌene Naaꞌe nahamihunijaho iviamaa ikino nú puꞌúmo ꞌaijua rori hinu. ");
INSERT INTO mcq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ijihuni hahi Ema Puni Harihijaho Godira vwihana jaꞌina vehuna kaivo ea kaꞌene Hu nahamahunijaho nihoꞌo eha sisea niꞌimaꞌura apehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ꞌEjume pu pusumano ea kaꞌene nahamahunijaho ea irarana ꞌwarahuniji kaꞌi ꞌahiume ꞌwamareja puni vaja kajino piraꞌaravara. ");
INSERT INTO mcq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ea irara natohwaꞌe rehuniji puni vaja kajino hine piraꞌaravara. ");
INSERT INTO mcq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ꞌEjume Hu pu ijá ꞌiama Jenitaru puni kinia kaꞌene iki mweꞌi hijujija ea ꞌajohahuna harura rukina. ꞌEe ꞌajohiꞌina kajija swara rukinijina ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ꞌEnakaivo ja ijaꞌina parehuna kaivo ea irara joni vaji natohwaꞌe reꞌi ꞌahaꞌamajaho hu areri sesamaa punaꞌi rene ꞌee areri pwea saꞌinaꞌe reꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ꞌÚ ea icharo natohwane? Ea kaꞌene asuma hine ꞌiruma inujarana ho ea kaꞌene namine ꞌirumaꞌe ꞌeka roe vajahujarane? Ea kaꞌene asuma hine ꞌirumaꞌe inujaho natohwa kaivo Na ea kaꞌene arini namine jaae ꞌiruma vajihujina. ");
INSERT INTO mcq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vea kaꞌene Na sisei hijujaho ja nú puꞌúmo Nuni rori namijara. ");
INSERT INTO mcq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nuni omijara Na Nuni kwaa ꞌajohuna mihajaꞌinaꞌe Na ꞌuꞌo ja mihu. ");
INSERT INTO mcq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ꞌEnajihunaꞌe Nara ja pijihakame ja Nú puꞌúmo Nuni ari ꞌaijua ꞌahi ahuma toa ꞌiruma ine ꞌee ja Isureri puni amuja kaꞌene iropu ropu noꞌo ruha kaꞌene puaꞌe ꞌotua vetihunijino hine ꞌotua vetihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ꞌEjume Hu Saimani ijá ꞌwama Saimani hena! Setani aaꞌe apenaꞌe areri ꞌwitia ruarahu jaꞌinaꞌe ruaraꞌi ꞌahauꞌe ura rejuꞌe ro ꞌejahie ꞌwarimana. ");
INSERT INTO mcq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ꞌEnakaivo Na oni siporua ꞌojuraꞌomo ara nimaa ronujaho paꞌohuna. ꞌEnareje a kúꞌo ꞌuname Nuni roꞌamajaho ara Nuni ehijakija najahakame pura nimaa rojujaho ija kisi apena puni unaꞌi saname vehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ꞌEjume Pitara ijá ꞌwama Natohwe na niareri rena hijuraꞌomo A tipurai vaꞌamajaho na A huꞌúmo vahuna. ꞌEe A kwaꞌamajaho na A huꞌúmo kwahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ꞌEjume Hu ijá ꞌwama Pita Na nimaa aaꞌe ꞌwaravu. ꞌUꞌora iviasa maiꞌo paꞌumeꞌeje a ꞌaha noꞌopisu Na pakimuna ꞌiaꞌeje ijiꞌa ꞌuꞌora ꞌumehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ꞌEnarena Hu pu ijá ꞌiama Vea kaꞌene Na ja irechamiume pausia ꞌee tuja ꞌee mumora sisa paꞌa vaꞌajaho ja vi pivusahara raka? ꞌiamana. Pu ijá ꞌwava Nihoꞌo pana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ꞌEnakaivo Hu pu ijá ꞌiama ꞌEnakúne iviamaa ea irahuni pausia ꞌee tuja naꞌamajaho ꞌeka vaꞌamana. ꞌEne ea irara soꞌwa paꞌanaꞌe reꞌamajaho huni ateha ꞌeka vaꞌe ꞌimenareje monia ꞌeke huni soꞌwa ꞌimeꞌamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ijihuni maijaho heha vaji venareje Naaꞌe ronarena ꞌwaramajaho rehuna. Hu ꞌuꞌo ea sisea vejiꞌina puꞌúmo tahuna ꞌúmajaho iviamai Nuni vaji nimaa roe rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ꞌEjume pu ijá ꞌwava Natohwe kama! Soꞌwa noꞌoheꞌi ikenakúne kima! ꞌwavara. ꞌEjume Hu pu ijá ꞌiama Ijaho arerina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ꞌEnarena ruꞌeꞌune nikúꞌo Hu venujaꞌinaꞌe huriꞌa Arivi vaꞌume Huni tisaiporu Hu ꞌararihae vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hu vaꞌe ruha kajino ꞌeꞌunarena Hu pu ijá ꞌiama Ja Godoni siporua ꞌojiꞌi hijakame ja pavena kiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ꞌEꞌikaꞌi Hu pu irechamiꞌikaꞌi vaꞌe karokaro muna piꞌonave vaꞌe ꞌohune saꞌinijakaru nitupari same hijiꞌi siporua ꞌonana. ");
INSERT INTO mcq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hu ijá ꞌwama Amo A ura renaꞌipisa kapusiakaho Nuni rora apena ruvaaꞌa. ꞌEnakaivo Nuni ura pana kaivo Oni ura ijaꞌinaꞌe veꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ꞌEꞌeme ꞌona ojiꞌina akúpa ꞌahi rena roe Hu harura mahana. ");
INSERT INTO mcq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hu hine oja hiaꞌeme siporua ꞌojumakame haha natohwaꞌe hiame huni piropa ꞌaa muka saꞌinaꞌe mweꞌa ꞌahi arihana. ");
INSERT INTO mcq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hu siporua ꞌonuvaꞌo ꞌurine Huni tisaiporu puni vaꞌi kimajaho pu hine temuki ꞌaninamiume notuara. ");
INSERT INTO mcq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ꞌEjume Hu pu sie ijá ꞌiama Ja iraka vene notuiꞌi navo? ꞌUrine siporua ꞌoꞌirakúne ja pavena kiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hu maiꞌo hine ijí ꞌwaraꞌeme niꞌaha kwinu Jutasi kaꞌene iropu ropu noꞌo pinijara ea mapokaꞌe aherame roe hu Jesu ura mina veꞌi ꞌahaume roana. ");
INSERT INTO mcq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ꞌEjume Jesura hu ijá ꞌwama ꞌÚ Jutasi a Na Emaa Puni Hariha nahamahareꞌe ura mina vena avano? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ꞌEjume ea kaꞌene pu puꞌúmo namijajipo uneka kaꞌene reꞌi venaji kimareja pu ijá ꞌwava ꞌÚ Natohwe nú núni soꞌwi pijiꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ꞌEnarena ea pini huni soꞌwi mavane ꞌurine pirisiti niꞌinijihuni pwea pinijihuni ataa kaꞌene manaꞌinijaho ꞌanaume ꞌuhuꞌusahana. ");
INSERT INTO mcq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ꞌEnakaivo Jesura eha vene ijá ꞌwama Ijá kajaho arema ꞌwaꞌikaꞌi Hu huni ataa iji ꞌunavume maranana. ");
INSERT INTO mcq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ꞌEnarena Jesura pirisitia mamaꞌina ꞌee sorutia Temiporu ꞌajohiꞌinijija ꞌee emakina kaꞌene Hua apeꞌi roajihi ijá ꞌiama ꞌÚ Na ea nesa apejiꞌinaꞌomo ja soꞌwa hajaa ꞌeke Naaꞌe apeniꞌi ꞌahiume roare? ");
INSERT INTO mcq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na veku veku ja puꞌúmo Temiporu vaji hijura kaivo ja Na paapeniura. ꞌEnakaivo iviamaa ike vea mukakaho ꞌee mweꞌa ike nutuviꞌina kehuni harurijaho jona ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pu Hu kamome apene pirisitia niꞌinijihuni sei vaꞌume Pitaho ma kameri naminakiviꞌi ꞌarariha vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ꞌEꞌeme vena núꞌúha riri jaumakame Pitaho pu puꞌúmo asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ꞌEꞌeme hu ijino asuma hijume napara pwei pini Pita nia kanaviꞌi ijá ꞌiama Ea ike ꞌuꞌo Hu huꞌúmo onuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ꞌEjume hu heme ijá ꞌwama Napare nihoꞌo na Hu pahene pakaviꞌina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hu ꞌaha josu pareꞌeme emai pini kamarena ijá ꞌwama A ꞌuꞌo Huni ea pina ꞌwamana kaivo Pitara ijá ꞌwama Parue na nihoꞌo pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hu vea muka kwinu paꞌareꞌeme ea pini roe pasonananaviꞌi ijá ꞌiama Na nimaa ꞌwaravu. Ea ika ꞌuꞌo Hu huꞌúmo ꞌurahe onuna. Ijihuhi maijaho hu Karari ora ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ꞌEnakaivo Pitara ija ꞌwama Parue ara iraka kaꞌene ꞌwarimujaho na maiꞌo suja ꞌwamana. Hu ijí ꞌwaraꞌeme niꞌaha kwino ꞌuꞌora ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","ꞌEꞌeme Natohwijara aroma Pita kaꞌeme Pitaho ijiꞌa Natohwijara iraka kaꞌene ꞌwaramajaho vwihanana ꞌUꞌora maiꞌo ꞌumeꞌi ꞌahae veꞌeje a ꞌaha noꞌopisu Na pakimuna ꞌiꞌena ꞌwamana. ꞌEjume Pitaho ijí vwihanarena samai vaꞌeꞌune nihoꞌo natohwaꞌe niramana. ");
INSERT INTO mcq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ea kaꞌene Jesu ꞌajoha hijajipo apene ꞌijahe ꞌee hijahara. ");
INSERT INTO mcq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pu Hu apene nia hwamahe ꞌanaiꞌi ijá ꞌwava A unenuꞌu ꞌahoꞌa kaꞌene vaji navujija hena kimuna ꞌúmunakúne ea irara A ꞌanaajaho ꞌwaruva nú heja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ꞌEne pu uneunecha nihoꞌo mapokaꞌe Hu niname ꞌee ꞌurarahe ira sisea ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vea nituvume emaa puni mamaꞌina ꞌee pirisitia mamaꞌina ꞌee Sikuraipia roe kanisoru puni núꞌúhi ahuma hiꞌeme Jesuho puni unaꞌi aheme roajivara. ");
INSERT INTO mcq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pu apoma ijá ꞌwava ꞌÚ A Keriso reꞌamajaho ꞌwaruma ꞌwavara. Hu ijá ꞌiama Na ja ꞌwaraꞌujaho ja panimaa rohuna. ");
INSERT INTO mcq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ꞌEne Na jaaꞌe aporaꞌujaho ja eha pavene ꞌwariꞌeja. ");
INSERT INTO mcq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ꞌEnakaivo iviamaa rene Emaa Puni Harihijaho ija manaꞌina kaꞌene Godoni harurijaꞌi asuma hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pu Hu apome ijá ꞌwava ꞌÚ A Godoni Harihe? ꞌwavara. ꞌEjume Hu pu ijá ꞌiama Ja Na ꞌwarivu kajaho Na nimaa ijina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ꞌEjume pu ijá ꞌwava Nú ea ꞌahopo Huaꞌe ronareje namahuji hehuna pana. Ijihuni maijaho nú onúno Huni irijaho núni ataa ikino hejara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ꞌEnarena ea mapoka kajipo ꞌurine Hu aheme Pairati oni vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pu aneja vene Hu namahiꞌi ijá ꞌwava Nú kaꞌeme ea ikaho ehu núnakija pisimie ꞌee Sisa oni takisia pavehunaꞌe ꞌwarume ꞌee Hura ꞌwarumujaho Hu Keriso kaꞌene Kinijina ꞌúmuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ꞌEjume Pairatira Hu apoma ijá ꞌwama A Jua puni Kinie? ꞌwamana. ꞌEjume Hu eha vene ijá ꞌwama Ara ꞌwarimu kajaꞌina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ꞌEjume Pairatira pirisitia mamaꞌina ꞌee ea mapoka kajihi ijá ꞌiama Na ea ikehuni vaja sisea maiꞌo papiunavu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ꞌEnakaivo pu hina pasonananaviꞌi ira ajiraꞌe ijá ꞌwava Hu ikaho ea mapokakihi najahuꞌe oja ꞌurinauna. Hu Karari rene najahe vaꞌe Jutia vaja mahoꞌo najahe onuvaꞌo kwaa ike ꞌuꞌo iviamaa roana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pairatira ike henarena aporame ijá ꞌiama ꞌÚ ea ikaho Karari ore? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hu henajaho Jesuho Herotira kwaa kaꞌene ꞌajohujino rena roana henarena hu ranavume Heroti oni vaꞌana. Ijihuni maijaho Heroti roe Jerusaremi hinana. ");
INSERT INTO mcq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herotiho Jesu kamajihunaꞌe nihoꞌo natohwaꞌe teamamajihuni maijaho Hura raka kaꞌene venuji henujihunaꞌe Hu aacha pina veja kaꞌi ꞌahaume avanana. ");
INSERT INTO mcq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ꞌEjume Herotira ꞌaha joraꞌe Hu apomana kaivo Hu eha pavenana. ");
INSERT INTO mcq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ꞌEjume pirisitia mamaꞌina ꞌee Sikuraipiepo ijí namine nihoꞌo natohwaꞌe ajinaꞌeme Jesuho namahara. ");
INSERT INTO mcq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ꞌEnarena Herotiho ꞌee huni sorutia puꞌúmo Jesuho apene ꞌurarahe ꞌee siseꞌi ꞌahae ꞌee ateha nihoꞌo mavarasaꞌina apúsamahe ranavume Pairati oni ꞌuname vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Marakuꞌijaho Herotiꞌo Pairatiꞌo naka vejura kaivo vea kajino pu noꞌo napura vejara. ");
INSERT INTO mcq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ꞌEjume Pairatira pirisitia mamaꞌina ꞌee emaapuni ea mamaꞌina ꞌee ea mapoka ꞌwaravume ahuvara. ");
INSERT INTO mcq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ꞌEjume ijá ꞌiama Ja ea ikaho apene nuni roara. Hura vejuꞌe ea oja ꞌurinauꞌe ea sisea vejura ꞌwaꞌi ahema roara. ꞌEnakaivo na joni unaꞌi vena kavujaho na ea ikehuni vaja sisea maiꞌo papiunavu kaivo jara Huaꞌe namahujiruna. ");
INSERT INTO mcq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroti ꞌuꞌo vena kamajaho Hu sisea pavenanaꞌe kamarena nuni ꞌunama kúꞌo roana. Heha! Ea ikaho unenuꞌu pina sisea pavena jihunaꞌe Hu areri pakwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ꞌEnajihunaꞌe na hijahareje ranave vaꞌena ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Puni tamani jihunaꞌe sora ijuri vea rejuꞌukaviꞌi tipura ea kwinu ranavuꞌe samai vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ea mapoka kajipo niꞌaha kwinu ahuma ijá ꞌumeja Ea ike apeꞌi kaivo Parapasi ranave samai ro ꞌeꞌunama ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parapasiho ara natohwa vaja kajino hine ꞌarahe ꞌee eaꞌe ꞌaniume kwamasaha jihunaꞌe ranavume tipurai hinana. ");
INSERT INTO mcq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pairatira ura renajaho Jesu ranave vahunaꞌe ura rejume ea mapokijihi kúꞌo ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ꞌEnakaivo pu ira ajiraꞌe ijá ꞌumeja Icha ꞌahi ꞌanaa! Icha ꞌahi ꞌanaa! ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ꞌEjume hu ꞌaha noꞌoheꞌi niꞌwaramanaꞌomo kúꞌo ꞌaha pina ijá ꞌiama Irakijihunaꞌe ꞌanaꞌuro ꞌumejo? Hu unenuꞌu pina sisea irakaꞌe venane? Hu unenuꞌu pina veꞌiraꞌomo na ꞌanae kwahuna na pakavu. ꞌEnaꞌomo na ꞌwarave pu hijaha ranave vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ꞌEnakaivo pu hine majama pasonananaviꞌi icha ꞌahi ꞌanae kwaꞌamarono ꞌumenu vaꞌo pura harura vene rarejara. ");
INSERT INTO mcq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ꞌEjume pura raka kaꞌene ura renajaho Pairatira veꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ꞌEjume Pairati ea kaꞌene ara natohwa vaji ꞌarahe ꞌee ea ꞌaniuꞌe kwamasahiꞌina kaꞌene tipurai hinana kaꞌene pura ranaꞌamarono ura renaji ranaꞌikaꞌi Jesuho puni ura ijino veꞌavarono mihana. ");
INSERT INTO mcq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ꞌEjume pu Jesuho ahema vaꞌeme Saimani kaꞌene Sairini orijaho huni ari rene roꞌeme pu iji ꞌuname icha kajaho apena pimahe ꞌejahaume apene Jesuni túnaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ea nihoꞌo mapoka mapokaꞌe vaꞌajiꞌeme napara ꞌahoꞌa puni rira kajino virisia vene niramaruviꞌi ꞌararihia vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ꞌEjume Jesura taꞌarohe ijá ꞌiama Napara kaꞌene Jerusaremi orakije Nunijihunaꞌe niramaruvujaho areꞌi kaivo joni harihija ꞌee ojono niraꞌahusaraha. ");
INSERT INTO mcq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ijihunaꞌe heha! Vea maiꞌo nituma roe saꞌeje ja ika ꞌwaꞌeja Napara kaꞌene hariha paꞌeke ꞌee panahenaꞌe ꞌee hariha paꞌajohaiꞌinijija teamanahuna ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ijaho vea kaꞌene emaapo aneja vene naharaꞌe ikaꞌina jarima ꞌwarahunijina ꞌAuma arihe ninamuha ꞌee huriꞌa roe vahúha ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ꞌEnajihunaꞌe pu icha maiuꞌina vajijiano uneunecha ijaꞌinaꞌe veꞌavajaho vu pu icha sahasa vajijaho ichá veꞌeja? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pu ea sisea noꞌoheꞌi Jesu puꞌúmo ꞌania kwamasaꞌavarono aherame vaꞌajivara. ");
INSERT INTO mcq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ꞌEjume pu roajime kwaa kaꞌene Húmatata ꞌwavujino useme Jesuho icha ꞌahi ꞌanae ꞌee ea sisea pina manaꞌinijaꞌi ꞌanae ꞌee pina anaꞌinijaꞌi ꞌanaara. ");
INSERT INTO mcq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ꞌEjume Jesura ijá ꞌwama Amo pu raka kaꞌene vejukaho puruva retiꞌejuꞌe vejukúne Noinvwihanie areꞌamana ꞌwamana. ꞌEꞌeme pu pipia vene Huni ateha swara vena ꞌekara. ");
INSERT INTO mcq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ea mapoka kajija namine kiꞌejuꞌe puni mamaꞌinijipo Jesuho apene ꞌijahe ijá ꞌwava Hu ea ꞌahoꞌa niꞌajihu jaꞌinaꞌe makaꞌeje Hu Keriso kaꞌene Godira iji pijahaji reꞌamajaho Hu oriꞌini niꞌajaraꞌamama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ꞌEjume sorutia ijija ꞌuꞌo Jesu apene ꞌijahe toa sisea ꞌeka roe vajahiꞌi ");
INSERT INTO mcq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","pu ijá ꞌwava A Jua puni Kinia reꞌamajaho orono niꞌajarama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ira ikaꞌinaꞌe Huni hurijino vejara. Ikaho Jua Puni Kinijina. ");
INSERT INTO mcq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ꞌEꞌeme ea sisea pina kaꞌene ropunaꞌi ꞌanaume namajara vuꞌa sisea Hu ꞌwarame ijá ꞌwama ꞌÚ A nimaa Keriso reꞌamajaho A orono niꞌajarame nú ꞌuꞌo niꞌajúha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ꞌEnakaivo ea pina kaꞌene ronunaꞌi namajara ꞌurarahe ijá ꞌwama ꞌÚ a Godiho pajuhamo? Nú ꞌuꞌo iki pu puꞌúmo areri ahume kwamasahu. ");
INSERT INTO mcq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nú eha apejujaho nijina. Ijihuni maijaho nú siseaꞌe vejajihunaꞌe eha apeju kaivo Hu unenuꞌu pina sisea pavenana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ꞌEnarena hu ijá ꞌwama Jesu vea kaꞌene Ara Oni ari vaꞌeꞌumajaho A na vwihaniꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ꞌEjume Hu ijá ꞌwama Nara nimaa a ꞌwaravu jihunaꞌe a iviasi Na huꞌúmo Parataisi hihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ijaꞌinaꞌe veꞌeme vea vaꞌe riri namiꞌeme kwaa mapokakaho vea naꞌima namuvaꞌo vea vaꞌe hareha ꞌaha karohi naminana. ");
INSERT INTO mcq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ꞌEꞌeme vea naꞌiꞌeme Temiporu vaji ateha natohwa kaꞌene ꞌuranavume namajaho rira muꞌoi kajino isome noꞌoheꞌi renana. ");
INSERT INTO mcq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ꞌEꞌeme Jesura ira ajiraꞌe ijá ꞌumena Amo Oni ija ꞌahi Na Nuni ꞌAvena ranavu ꞌwaꞌikaꞌi oja sumana. ");
INSERT INTO mcq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ꞌEjume sorutia puni Natohwijara iraka kaꞌene renaji kamarena Godi taꞌarohiꞌi ijá ꞌwama Ea ikaho nimaa ariramaa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ꞌEjume ea mapoka kaꞌene ijí kaꞌi ꞌahiume ahuvajija Jesura kwavumakame tea junavume túrata puna ꞌanaiꞌi ꞌuname ari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ꞌEꞌeme Huni napuhija mahoꞌone ꞌee napara kaꞌene Karari rene Hu tamatihe roajija kameri namina raka kaꞌene rena kajaho kaviꞌi namijara. ");
INSERT INTO mcq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ꞌEꞌeme ea pina iha huna Josapina Hu kanisorua pine ꞌee hu ea mamaa ꞌee arimaa. ");
INSERT INTO mcq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hu pura vuꞌa kaꞌene amairie ꞌee raka kaꞌene vejajaho hu panimaa venana. Hu Juapuni ara natohwa kaꞌene Arimatia ꞌwavujino rena roanaꞌomo Godoni arijara rohuniji ꞌajaha hinuna. ");
INSERT INTO mcq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ꞌEnajihunaꞌe ea ikara vaꞌe Pairati jarime Jesuni hahaꞌe apeꞌirono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ꞌEne hu roe Jesuni haha apene atehi mwame apena vaꞌe muna ara maiuꞌina kaꞌene ea maiꞌo pairechaviꞌinijino ranamana. ");
INSERT INTO mcq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Vea kajaho Sapati amairiaravuri veijina. ꞌEne Sapatia maiꞌo aneja veꞌi ꞌahaume vejajina. ");
INSERT INTO mcq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ꞌEjume napara kaꞌene Karari rena roajija pu puꞌúmo vaꞌe eucha kajaho kame ꞌee Huni haha icháꞌinaꞌe mwame ranavajaho kavara. ");
INSERT INTO mcq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ꞌEjume pu ꞌunama vaꞌe ari senisia ꞌee iona amairiarame Sapatiaꞌomo puni tamanijara ꞌwarama jaꞌinaꞌe vene ojuta hwejara. ");
INSERT INTO mcq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hura natohwi súꞌusúꞌu napara kajija senisia kaꞌene pura amairia irechavajaho ꞌeke muna ara kajino roara. ");
INSERT INTO mcq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pu vaiꞌi kavajaho muna kaꞌene vwichaꞌe kunavajaho tahuma apene ruvaꞌara kavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ꞌEnakaivo pu vaꞌe vaji aruvajaho Jesu kaꞌene Natohwi jihuni haha pakavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pu puruva renaume ijá namiꞌeme niꞌaha kwino ea noꞌoheꞌi ateha sajasaꞌimaa saviꞌina puni nina kajino namijara. ");
INSERT INTO mcq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Napara kajija nihoꞌo tea junaꞌeme nuana vetiume parua kajipo ijá ꞌiava Ja ichá vene ea kaꞌene kwamasahiꞌina kihipuni vaji ea kaꞌene maiꞌo hijiꞌinijaho savo? ");
INSERT INTO mcq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hu ikaho pana kaivo Hu niꞌurinana. Hu Karari hijiꞌi ja ꞌwaramajaho ja pavwihajo? ");
INSERT INTO mcq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hu ja ijá ꞌiamane Ema Puni Harihijaho apene ea sisea vejiꞌinaꞌe mihe icha ꞌahi ꞌanaa kwama namuvaꞌo naꞌia noꞌopisu paꞌareꞌeje kúꞌo ꞌurihuna ꞌiamajaho ja pavwihajo? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ꞌEjume napara kajija ijiꞌa Huni vuꞌa vwihajara. ");
INSERT INTO mcq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ꞌEne eucha areꞌi ꞌunama vaꞌe ea iropu ropu kwinu ꞌee ea ꞌahoꞌiji ꞌuꞌo uneunecha mapoka kajaho ijano ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Napara kajija Meri Matarini ho Joana ho Meri kaꞌene Jemisi oni ohijaho ꞌee napara ꞌahoꞌa kaꞌene pu puꞌúmo ꞌurahe ojujipo apasorua uneunechakaho ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ꞌEnakaivo vuꞌa kaꞌene pura ꞌwaraꞌavajaho mavumaa saꞌina rejume pu panimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ꞌEnarena Pitara ꞌurine ninuma vaꞌe muna ari ꞌeꞌune aruhi kamajaho ateharu navume kimana. ꞌEnarena hu ꞌuname huni ari vaiꞌi uné raki renana ronarena vwihajiꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Vea nikwinuꞌina kajino ea noꞌoheꞌi ara iha Emeasi vaꞌara. Ara kajaho Jerusaremi rena vaꞌujaho kwaa joraꞌomo (11 kiromita) ");
INSERT INTO mcq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","pu vaiꞌi uneunecha mapoka kaꞌene renaji ꞌwama apena vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pu ijí ꞌwaviꞌi vaꞌeme Jesuho roarena pu puꞌúmo vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ꞌEjume puni nia nuhiume pu kavara kaivo pahena pakavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ꞌEnarena Jesura pu ijá ꞌiama Ja noꞌo jajasumano vuꞌa irakaꞌe ꞌwaviꞌi vaꞌajivo? ꞌiavume pu noꞌo nina kajaꞌa ajuarasaꞌeme namijara. ");
INSERT INTO mcq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ꞌEjume ea iha Kariopasira eha vene Hu ijá ꞌwama ꞌÚ A Asumano ikaho Jerusaremi ura vene roanaꞌomo uneka kaꞌene vea ikino rejajaho A pahenane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ꞌEjume Hu pu ijá ꞌiama ꞌÚ uné raki renane? ꞌiamana. ꞌEjume pu Hu ijá ꞌwava Uneka kaꞌene Jesuka Nasareti oraꞌe renajaho A vi henane? Ea ikaho poropetia ꞌee ea uneunecha aniꞌina mapokaꞌe mamaꞌina vene ꞌee Godiho ꞌee ea mapokaꞌe ikihipuni unaꞌi vuꞌa mamaꞌina ꞌwaramuna. ");
INSERT INTO mcq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ꞌEnakaivo núni pirisitia mamaꞌina ꞌee ea ꞌajohaꞌina mamaꞌinijipo apene ꞌanaa kwaꞌamarono mihume pu Hu icha ꞌahi ꞌanaume kwamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ꞌEjume nú vwihajajaho Hu roe Isureri ora ꞌimena ꞌekaꞌi ꞌahaume roana. ꞌEnakaivo ijiru pana vo uneunechakipo rejajaho iviasi naꞌi noꞌopisu paꞌarenu. ");
INSERT INTO mcq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ꞌEnakaivo napara ꞌahoꞌa kaꞌene nú puꞌúmo ahuma ojiꞌinijipo súꞌo euchi vaꞌe roe tatatúara. ");
INSERT INTO mcq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pu Huni haha pakamareja roe ijá ꞌúva Pu ꞌona ojiꞌina visoni vaji kivume pu Hu maiꞌo hinu ꞌúvara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ꞌEjume ea ꞌahoꞌa kaꞌene nú puꞌúmo ahuma hijajipo eucha kaji vaꞌara kaivo niareri napapo ꞌwaruva jaꞌinaꞌe Hu pakavara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ꞌEjume Hu pu ijá ꞌiama Ea kaꞌene nihoꞌo pavwihajiꞌinakije uneunecha mapoka kaꞌene poropetiepo ꞌwaravajaho ja marakoꞌa panimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kerisoho uneunecha mapoka sisea Huni haha ꞌahi marako rejakamaꞌe ijiꞌa Huni ara kaꞌene hanajiꞌiniji vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ꞌEnarena Mosisi oni aneja rene roe poropetia mahoꞌo puni vaji Godoni irijara Huaꞌe rone ꞌwaramaji mahoꞌo najahana. ");
INSERT INTO mcq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Puni ara kaꞌene pu vaꞌiro vaꞌajaho usehuna nituranana. ꞌEjume Jesuho Hu maihename vaꞌi ꞌahaume venana. ");
INSERT INTO mcq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ꞌEnakaivo pu ijá ꞌwava Vea nusirevuꞌe vea nipaꞌarenukúne nú puꞌúmo hina ꞌwavara. ꞌEjume Hu pu puꞌúmo vaꞌe hinana. ");
INSERT INTO mcq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ꞌEjumakame Hu pu puꞌúmo ahuma ꞌirumaꞌe iꞌi ꞌahaume puretia apene siporua ꞌone teimani ꞌwamarena tuama vajihana. ");
INSERT INTO mcq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ꞌEjume puni nia kaꞌene nuhiajaho jaraume pu Hu kavara kaivo Hu puni rora kajano vaꞌume pakama arevara. ");
INSERT INTO mcq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ꞌEnareja pu hine piraꞌarame ijá ꞌwava Hu ꞌunamutoi ꞌwarume ꞌee Godoni ira vaji namuji najuꞌejuꞌe núni oja vaja hianuma parajara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ꞌEnarena pu vea muka kajino ꞌurine Jerusaremi ea iropu ropu kwinu ꞌee ꞌahoꞌa kaꞌene pu puꞌúmo ahuma hijujino ꞌunama vaꞌe ijá ꞌiava ");
INSERT INTO mcq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Natohwijaho nimaa nimaa ꞌurinanaꞌomo Saimani oni unaꞌi samaahiravume Noinkamana ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ꞌEnarena ea noꞌoheꞌi kajipo iraka kaꞌene ꞌunamutoi vene ꞌee pu icháꞌinaꞌe Jesu marako kavajaho pahena pakavara kaivo Hu puretia tuaꞌeme niꞌaha kwinu pu Hu kavaji rone ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pu hine ijí ꞌwaraꞌeme niꞌaha kwino Jesuho puni rira kajino naminana. ");
INSERT INTO mcq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pu nihoꞌo tea junaꞌeme ijá roja Pu ꞌavena kavu rojara. ");
INSERT INTO mcq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ꞌEnarena Hu pu ijá ꞌiama Ja irakaꞌe vene puruva retio? ꞌEe ja ichá vene joni oja vaja maꞌuako panimaa rojo? ");
INSERT INTO mcq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nuni ija momorakake piuhiha kiha! Naranakúne! ꞌEne haha ꞌunirime kiha. Ijihuni maijaho ꞌavena haha ꞌee ata areri Nuna ikaꞌina pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hu ijaꞌina ꞌwaramarena Huni ija mumora najahana. ");
INSERT INTO mcq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ꞌEnakaivo pu hina teamanama parajara kaivo pu maꞌuako panimaa ronareja hine vwihajara. ꞌEjume Jesu aporame ijá ꞌiama ꞌÚ ja unenuꞌu ꞌahoꞌa ihuna vi navo ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","ꞌEjume pu kija rejiꞌina mahume Hu apene puni unaꞌa kajino inana. ");
INSERT INTO mcq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ꞌEnarena Hu pu ijá ꞌiama Uneunecha ikehija Na ja puꞌúmo hijujino ꞌwaravuta. Uneunecha kaꞌene Mosisiho poropetiapo ꞌee Samusi vaji Na rona ꞌwaravajara nimaa iviamaa renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ꞌEnarena Hu puni vwiha ijija Godi oni iriji hami heꞌavarono jaraana. ");
INSERT INTO mcq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ꞌEjume Hu pu ijá ꞌiama Ikaho iraka kaꞌene Godoni ira vaji vejajina Keriso siseꞌi ꞌahae ꞌanae kwamareja naꞌia noꞌopiso paꞌareꞌeje kúꞌo ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ꞌEne Huni iha ꞌahiji Jerusaremi rene vaꞌe eaka mapoka kaꞌene kwaaka mapokakino hijujija najahe pu puni sisea vwihane temukave aremamaa arevakame Godira puni sisea vwihanie arehuna. ");
INSERT INTO mcq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ꞌEnajihunaꞌe ja uneunecha mapokakipo rejajija ja nihene kivara. ");
INSERT INTO mcq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Heha! Na Nuni Omijara raka kaꞌene nahama ja ꞌwaramajaho Nara ranave joni roꞌenakúne ja ara natohwa ikino hiꞌeje Godoni harura kahino akúpa ꞌahi rene roe ja samaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ꞌEnarena Hu aherame ara kajaho areꞌi kaivo vaꞌe Petani rori hiꞌeme ija ahasirime merajihana. ");
INSERT INTO mcq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hu pu hine merajiharena irechamie vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","ꞌEjume pu ꞌuname Jerusaremi nihoꞌo teamanama paraꞌeme mariꞌuviꞌi roareja naꞌia mapoka kajaho Temiporu vaji hine majamano Godi teamani ꞌwama taꞌarohiꞌi hijura. ");
INSERT INTO mcq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nitamatama anejijaho Irijina. Irijaho Godi ahuma hinana. ꞌEne Irijaho Godina. ");
INSERT INTO mcq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hu nitama anejijaho Godi ahuma hinana. ");
INSERT INTO mcq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ꞌEne uneunecha mapoka kaꞌene mahoꞌo iki mweꞌi navujaho Hura venana. Uneunecha mapoka kaꞌene iki mweꞌi navujaho Hununaꞌi parena rohuna pana. ");
INSERT INTO mcq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Majama hihunijaho Huni vaji rena roane ꞌee majama hihunijaho emaa puni hanajiꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hanajiꞌina kajara nututa hananuna. Nutumujara hanajiꞌina kaji utahuna areri pana. ");
INSERT INTO mcq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ea pina Godira ranavume roana. Huni ihijaho Jonina. ");
INSERT INTO mcq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hu Ira kaji rone ꞌwaraꞌi roana. ꞌEjakame ea mahoꞌo huni vaji hena nimaa rohuna. ");
INSERT INTO mcq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hu Hanajiꞌinijaho pana kaivo hu Hanajiꞌina kaji rone ꞌwaraꞌi ꞌahauma roana. ");
INSERT INTO mcq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ijí Hanajiꞌina nimaa kajaho iki mweꞌi roanaꞌomo ea mapoka hananiuna. ");
INSERT INTO mcq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hu iki mweꞌi roe hinana. ꞌEne mweꞌakaho Hura venana kaivo eaka mapokaka mweꞌi hijukija Hu pahena pakavara. ");
INSERT INTO mcq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hu ehwapuni roana kaivo Huni ehija Hu hami paapejara. ");
INSERT INTO mcq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ꞌEnakaivo ea mapoka irahipo Hu hami apejajija nimaa Hu pu harura mihume Godoni harihija rejara ꞌee ea kaꞌene Huni ihiji nimaa rojajija ꞌuꞌuna. ");
INSERT INTO mcq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Godoni harihija rejujijahija emaa puni ꞌai tuhuna pane ꞌee hahijihuni ura ijino nahehuna pane ꞌee ei pini save nahehuna pana kaivo Godira Huni ura ijino venauꞌe Huni harihija rejura. ");
INSERT INTO mcq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ꞌEjume Irijaho roe haha apene nú puꞌúmo ahuma hijume nú Huni hanajiꞌina kavara ꞌee Huni Hariha nikwinuꞌwi maa kajihuni hanajiꞌinijaho Amo kaꞌene maiji vwihanúe ꞌee nimaijihuni rena roana. ");
INSERT INTO mcq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joniho Huaꞌe rone ijá ꞌiama Ea kaꞌene na ja ꞌwaravujaho Ea kaꞌene túnaꞌi roujaho Hu nihoꞌo Natohwaꞌomo na asitihana. Ijihuni maijaho na maiꞌo panaheniꞌini Hu niiji hinana. ");
INSERT INTO mcq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hu nú maiji vwihanúiꞌina kaꞌene ituꞌona parana jihuni vajiji nú mahoꞌo hura hara maiji vwihanúujaho ꞌekura. ");
INSERT INTO mcq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Varapa tamana Mosisi oni vajijino múhana kaivo maiji vwihanúe ꞌee nimaijaho Jesu Keriso oni vaji rena roara. ");
INSERT INTO mcq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Vei pini emai Godi kahuna nihoꞌo pana kaivo Huni Hariha nikwinuꞌwi kaꞌene Omahoni vaji hinujara Hu kame ea ꞌahoꞌa najahe ꞌwaramuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ikaho Jonira ea ꞌwaramajina. Jua kaꞌene Jerusaremi hijujipo pirisitia ꞌee Rivai irechamiume vaꞌe Joni apoꞌi vaꞌara. A irarane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ꞌEjume hu pahekajihana kaivo nahama ijá ꞌiama Na Kerisoho pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pu apoma ijá ꞌwava ꞌEnaꞌomo a irarane? A Iraijarane? ꞌwavara. Hu ijá ꞌiama Na hu pana iamana. ꞌEjume pu kúꞌo apoma ijá ꞌwava A poropetie? ꞌwavara. ꞌEjume hu eha vene ijá ꞌiama Pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ꞌEjume pu hu ijá ꞌwava A irarane? Ea kaꞌene nú irechamúume roajihijaꞌe eha kaꞌene ꞌwarahuniji múha. ꞌÚ a orono a ea irane ꞌimune? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hu ijá ꞌiama Na ea ira anuka kaꞌene kahi nechi riri namina ira ajiraꞌe ikaꞌinaꞌe ꞌumenajina Natohwi jihuni ꞌunama veje arira renama ꞌúmana kaꞌene poropetia Aiseara ꞌwaramajina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pu Parasipo irechamiume roara. ");
INSERT INTO mcq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pu hu apoma ijá ꞌwava A Keriso ho pana ꞌee Iraija ho pana ꞌee poropetia paꞌana reꞌamajaho a rakijihunaꞌe ea toi vaji samane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ꞌEjume Jonira eha vene pu ijá ꞌiama Na toi vaji samauta kaivo Ea kaꞌene ja puꞌúmo ahuma naminu kajaho ja pahena pakavura. ");
INSERT INTO mcq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ea kaꞌene nuni túnaꞌi roujaho nara Huni mumora hwana rasamahuna areria pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ijaho Petani Jotani ona karaꞌi Jonira ea toi samajino avajara. ");
INSERT INTO mcq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ijihuni súꞌuhijino hu kaꞌeme Jesuho roe huni nini roume ijá ꞌiama Heha! Ikaho Godoni Remua kaꞌene mweꞌa kehuni sisea apehunijina. ");
INSERT INTO mcq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ea kaꞌene nuni túnaꞌi roume nara ꞌwaravujaho ikena. Na panaheniꞌinijaho Hu ijí hinana kaivo na Hu huꞌúmo areria pana. ");
INSERT INTO mcq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na Hu pakavura kaivo Isureri opo kama hehuni jihunaꞌe na ea toi samauta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ꞌEjume Jonira kamaji ijá ꞌiama Na kaꞌeme Godoni ꞌAvena kahi akúpi ꞌahi rene marahuꞌora punaꞌi ariha roe Huni haha ꞌahi hinana. ");
INSERT INTO mcq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na Hu pakavura kaivo Godia kaꞌene na ranamiume roe ea toi samaujara ijá ꞌwima A kaꞌeje Godoni ꞌAvena kahi akúpi ꞌahi rena ꞌariha roe Huni haha ꞌahi hija kaꞌamajaho ijara ea Godoni ꞌAvenijino samahuna. ");
INSERT INTO mcq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na kavuji ja ꞌwaravu. Ikaho Godoni Hariha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kúꞌo súꞌuhijino Joniho huni tisaiporu noꞌo puꞌúmo naminana. ");
INSERT INTO mcq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ꞌEjiꞌi hu kavume Jesuho vaꞌumakame hu ijá ꞌiama Kaha! Godoni Remuijaho karehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ꞌEjume pu ijí hene tisaiporuhwaha noꞌo ꞌurine Jesu ꞌararihae vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ꞌEjume Jesu aroma kimajaho pu Hu ꞌararihae vaꞌara. ꞌEjume Hu aporama ijá ꞌiama Ja iraka savo? ꞌiamana. ꞌEjume pu eha ijá ꞌwava Rapai (ijihuni maijaho Najahiꞌina) A ichihi hinune? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hu pu ijá ꞌiama Roe kaha ꞌiavume pu pu puꞌúmo vaꞌe Hura hinujaho kavara. ꞌEe pu vea kajaho ijí pu puꞌúmo hijara. Vea karohi va ꞌoꞌirorena hareha ꞌahi naminajaho pu ijí hijara. ");
INSERT INTO mcq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ea noꞌoheꞌi kaꞌene Jonira ꞌwaravume henareja Hu ꞌararihae vaꞌajija pina Enituruna Saimani Pita oni ꞌuꞌua. ");
INSERT INTO mcq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hu makuꞌijaho huni poka Saimani piuname ijá ꞌwama Nú Masaia piunavara ꞌwamana (Masaiaho Keriso rona ꞌwavura). ");
INSERT INTO mcq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hu Saimani aheme Jesuni roana. ꞌEjume Jesu kame ijá ꞌwama Saimani kaꞌene Jona oni harihakera oni iha Sipasi reꞌena ꞌwamana. Sipasina ꞌwavujaho Pita rona ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ijihuni súꞌu Jesu Karari vaꞌe Piripuho piuname ijá ꞌwama Na ꞌararihie roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piripuho Petasaita ora kwaa kaꞌene Enituruꞌo Pitaꞌo rena roajiꞌura. ");
INSERT INTO mcq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piripura Nataneru piunama ijá ꞌwama Mosisiho ꞌee poropetiepo nitama heha ꞌahi vejajaho nú nipiunavara. Ijaho Jesu Nasareti ora kaꞌene Josapi oni Harihijina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanerura hu ijá ꞌwama ꞌÚ unenu pina mamaa Nasareti rena roane? ꞌwamana. ꞌEjume Piripu ijá ꞌwama Orono ro kama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu kaꞌeme Nataneru Huni roume hu rone ijá iama Kaha! Ikaho nihoꞌo Isureri ora nimaa nimaijina. Hu nihoꞌo iraꞌata paꞌa mai ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataneru Jesu ijá ꞌwama A icháꞌina na hena kimane? ꞌwamana. ꞌEjume Jesura eha vene ijá ꞌwama Piripura maiꞌo ꞌumenaꞌi veꞌeme Na mataka hari a kavuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ꞌEjume Nataneru eha vene Hu ijá ꞌwama Najuhiꞌine A Godoni Hariha ꞌee A Isureri opuni Kinia ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesura eha vene hu ijá ꞌwama Nara a mataka hari kavuji ꞌwaravuꞌe a Na nimaa rono? A túnaꞌi uneunecha mamaꞌina areri ike asivara kihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hu hu ijá ꞌwama Na nimaa nimaa a ꞌwaravu. A kiꞌeje ꞌona ojiꞌina kahi akúpa ꞌahi vwicha reꞌeje Emaa Puni Harihijihuni ꞌahi ariha roe ajima vaiꞌi hihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Naꞌia noꞌopisu paꞌareꞌeme Kena Karari vaji napasi nejume Jesuni oha ꞌuꞌo ijí hinana. ");
INSERT INTO mcq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuho Huni tisaiporu puꞌúmo ea kaꞌene napasi neja kajipo ꞌwaravume roaraꞌomo ijí hijara. ");
INSERT INTO mcq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ꞌEjume pu ꞌwainia isi parajara. ꞌEjume Jesuni ohi Jesu ijá ꞌwama Puni ꞌwainia nipaꞌarenana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ꞌEjume Jesura ijá ꞌwama Napare Na ona iraka venaꞌejo? Nuni vea maiꞌo paroiꞌina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesuni ohi pwea kajija ijá ꞌiama Hura raka ꞌwaramujaho veha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Toata kaꞌene muni vejajija iropu kwino Juapo puni sosia tamana vene ija sovujija ijá navara. Ijí toata kajija areri rita mapoka (100). ");
INSERT INTO mcq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ꞌEjume Jesu pu ijá ꞌiama Toata kajino toa eje ituꞌusaꞌavara ꞌiavume pu toa ꞌejuma ituꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ꞌEnarena Hu pu ijá ꞌiama Ja iviamaa ꞌene apena vaꞌe ea kaꞌene ahaja anesuriji maꞌavara ꞌiavume pu ijá vejara. ");
INSERT INTO mcq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ꞌEꞌejume pu toa kaꞌene ꞌwainia rena kajaho ꞌeka vaꞌume ahaja anesurijara usea ina henana. ꞌEnarena ijí ꞌwainiakaho ichihi rena roajaho hu pahenana kaivo pwea kaꞌene toa kaji ꞌejajipo hejara. Ijihunaꞌe ahaja ijiꞌina ꞌajohiꞌinijara napasi nejiꞌina ꞌumejuma rouma ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ea ꞌahoꞌa puni ꞌwainia mamai marakoꞌa inareꞌe ijiꞌa sisea ijura kaivo a marakoꞌa sisei inareꞌe iviamaa maa inu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kwaa iha Kena Karari vaji Jesu aneja vene emaa areri pavehuni aacha ꞌee harura najahana. ꞌEjume Huni tisaiporua pu kame Hu nimaa vetiara. ");
INSERT INTO mcq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ꞌEꞌeme Hu ijihuni túnaꞌi Jesuho oaha ꞌee ꞌuꞌuhwaha ꞌee Huni tisaiporu puꞌúmo Kapeniami vaꞌe naꞌia tuꞌu hijara. ");
INSERT INTO mcq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jua puni Pasova aneja reꞌi veꞌeme Jesu Jerusaremi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hu vaꞌe Temiporu vaiꞌi kimajaho pu ea hine uka ꞌimene purumakau ꞌimene sipia ꞌimene monia senisu vejiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ꞌEjumakiviꞌi Hura vaꞌe ijí arumajino hisi vene hijihaume purumakaua ꞌee sipia ꞌuseme maꞌahi vaꞌara. ꞌEne puni monia ꞌunirame ꞌusekunihe ꞌee puni ꞌaijua ꞌunamapi ꞌaronamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ꞌEne Hu ea kaꞌene uka ꞌimejajija ijá ꞌiama Uneunecha kija ꞌeka vaꞌajiha! Nuni Omijihuni seijaho paveje ꞌimejuri ara renama ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesu hina ijaꞌina venaji Huni tisaiporua iraka kaꞌene nitama Godoni ira vaji vejajaho vwihajara. Na Oni vuꞌa ꞌwavuri sei ura renia paranu jihunaꞌe oja Nuna ꞌurina paranu ꞌiamaji pu vwihajara. Noin ");
INSERT INTO mcq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ꞌEjume Juapo Jesu ijá ꞌwava A ijaꞌina venajihunaꞌe aacha pina najuha kava ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ꞌEjume Jesura pu eha ijá ꞌiama Temiporua veje tiraꞌusunaha kamareje naꞌia noꞌopisu Na kúꞌo veje ꞌurina namihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ꞌEjume Juapo ijá ꞌwava Nú ijí Temiporu kajaho juara mapoka (46) paꞌareꞌeme ve parajara kaivo ꞌú A naꞌia noꞌopisu paꞌareꞌeje ve parahuna ꞌúmo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ꞌEnakaivo Hu Temiporua kaꞌene Huni hahiji rona ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ꞌEnaꞌomo vea kaꞌene Hu kwama ꞌurinajino Huni tisaiporuepo vwihanareja Godoni ira nimaa rone ꞌee Jesura ira raka kaꞌene ꞌwaravume pu hejajaho nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hu Jerusaremi Pasova vea rejume hijiꞌi Jesura aacha kaꞌene venaji pu ea mapoka kamareja Huni iha nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ꞌEnakaivo Jesu pu panimaa vetiana. Ijihuni maijaho Hu ea mapoka nihena kimuna. ");
INSERT INTO mcq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ijihuni maijaho Hu emaapuni vaja nihena kimujihunaꞌe ei pini emaa icháꞌiniji rone Hua ꞌwarahuna areri pana. ");
INSERT INTO mcq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ꞌEne Parasi pina huni iha Nikotimasiho hu Jua puni natohwa. ");
INSERT INTO mcq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ꞌEnaꞌomo Nikotimasi naꞌii roe Jesu ijá ꞌwama Najuhiꞌine nú niheju A Godoni rene roajihunaꞌe Ara venujaꞌinaꞌe ei pini areri vehuna pana. ꞌEnakaivo Godira Hu huꞌúmo hiꞌamajarana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu eha vene ijá ꞌwama Na nimaa nimaa a ꞌwaravu. Ea kúꞌo panaheꞌavajaho hu Godoni ara pakahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikotimasira Hu ijá ꞌwama Icháꞌinaꞌe ea kaꞌene niemakina renajaho kúꞌo nahehune? ꞌÚ hu ꞌuname oahoni tea vaji vaꞌe kúꞌo nahehune? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesura eha vene ijá ꞌwama. Na nimaa nimaa a ꞌwaravu. Ea toa ꞌee Godoni ꞌAvenijara naheꞌamajiana vo hu Godoni ara pavahuna. ");
INSERT INTO mcq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hahi jihuniji nahenaujaho hahi jihuna kaivo Godoni ꞌAvenijara nahenaujaho ꞌAveni jihuna. ");
INSERT INTO mcq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","A nihoꞌo kúꞌo nahenahunaꞌe ꞌwavujaho maiꞌo oja pahwaꞌusahaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ꞌAsiasiapo pu ura renau jaꞌinaꞌe hwasihuꞌe nú nihijura. ꞌEne nú nikivura kaivo ijaho ichihi rene roe ꞌee vaꞌujaho nú pahena pakavura. ꞌUnama nikwinuꞌina kajaꞌinaꞌe Godoni ꞌAvena vaji kúꞌo nahenaujaho ijaꞌina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikotimasira eha vene ijá ꞌwama Ijaho icháꞌina reꞌeja ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesura eha vene ijá ꞌwama A nihoꞌo Isureri opuni najahiꞌina kaivo ꞌú a ijija nihoꞌo pahejiꞌine? ");
INSERT INTO mcq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na nihoꞌo nimaa nimaa a ꞌwaravu nú raka kaꞌene hena kivujiru ꞌwaravu kaivo a nihoꞌo núra ꞌwaravujaho pahenuhu. ");
INSERT INTO mcq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na iki mweꞌi uneunechaka navuji rone ꞌwaravuꞌe a panimai ronujaho vu Na kahi akúpa ꞌahi navuji rone ꞌwaraꞌipisa a icháꞌina nimaa rojaꞌa? ");
INSERT INTO mcq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ike heha! Ea pina akúpa ꞌaha nihoꞌo pavaꞌana kaivo Emaa Puni Harihijara Huhusu ijí akúpa ꞌahi rena roana. ");
INSERT INTO mcq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosisira nechiꞌi tapara ichi ꞌahi raname apena sanama jaꞌinaꞌe Emaa Puni Harihijaho ichi ꞌahi raname apena sanahuna. ");
INSERT INTO mcq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ea irara Hu nimaa ronujaho hu majama hihuna apenu. ");
INSERT INTO mcq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Godi mweꞌa kakaho oja nihoꞌo mahajihunaꞌe Huni Hariha nikwinuna kaivo Hu múhanaꞌomo ea irara Hu nimaa ronujaho hu papaꞌarehuna kaivo hu majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Godi Hariaha ranavume iki mweꞌi ꞌotua paveꞌi roana kaivo mweꞌakara huni vaji maraꞌamarono roana. ");
INSERT INTO mcq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ea irara Hu nimaa ronujaho hu ꞌotua pavehuna kaivo ea irara Hu panimaa ronujaho hu eha niapenana. Ijihuni maijaho hu Godoni Hariha nikwinu jihuni iha panimaa ronajihunaꞌe avanana. ");
INSERT INTO mcq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ikaho ꞌotua vehuni jihuni ꞌunamijina. Hanajiꞌina iki mweꞌi roana kaivo ea pu nutuviꞌina oja mahajihunaꞌe pu hanajiꞌinijaho pataarohara. Ijihuni maijaho puni ꞌunama kaꞌene pura vejajija sisea. ");
INSERT INTO mcq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ea irahipo sisea vejujaho pu nihoꞌo hanajiꞌina senavura. Pu hanajiꞌini parohuni jihuni maijaho vejuroꞌi pura sisea kaꞌene vejujipo samaa hiraꞌavarono paroura. ");
INSERT INTO mcq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ꞌEnakaivo ea irara nimaa nimaiji venujaho hu hanajiꞌini hinu. Ijí hanajiꞌina kajara vejuꞌe hura iraka kaꞌene venajaho Godoni vaji venanaꞌe kivura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ijihuni túnaꞌi Jesuho Huni tisaiporu puꞌúmo kwaa iha Jutia vaꞌara. Naꞌia pina Hu ijí pu puꞌúmo hiꞌeme pu ea ꞌunirame toi samaara. ");
INSERT INTO mcq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Joni ꞌuꞌo ea toi samaume ꞌurijara. Kwaa iha Enani Serimi rori ijihuni maijaho ijí kwaa kajaho toa mapoki jihunaꞌe ea mapoka ijí vaꞌuma hu toi samaana. ");
INSERT INTO mcq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Joniho maiꞌo tipura paranavume hinana. ");
INSERT INTO mcq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jua Joni oni tisaiporu epuꞌúmo tamana kaꞌene ija sovuji ꞌwame nakaravara. ");
INSERT INTO mcq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ꞌEjume pu Joni oni vaꞌe ijá ꞌwava Najuhiꞌine Hena! Ea kaꞌene karaꞌahuni Jotani naꞌijaꞌi a Hu rone nú ꞌwarumajaho Hu ea toi samauꞌe ea mapokaꞌe Huni nianaa rou ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ꞌEjume Joni eha vene ijá ꞌiama Ea pina uneunecha pamajikari ꞌekuna kaivo kahi akúpa ꞌahi rene vajihujiruna. ");
INSERT INTO mcq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ja niheꞌeme na ja ꞌwaravujaho na Kerisoho pana ꞌivuta kaivo Hu maiꞌo paroꞌeme ranamiume urana roujina. ");
INSERT INTO mcq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ea irara napara rukinijaho hu napasina. ꞌEnaꞌomo napasina napuhwa puꞌúmo ahuma hine napasi neju kaji Hura ꞌwaramuji pu hene nihoꞌo teamanama paraju. Ijihuni hahi na Huni ira hejujaho nihoꞌo teamanima paranu. ");
INSERT INTO mcq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ijihunaꞌe Hu natohwa reꞌeje na maꞌuꞌua rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ea irara kahi akúpa ꞌahi rena roajaho Hu nihoꞌo niꞌimaꞌura. ꞌEnakaivo ea irara iki mweꞌi rena roajaho hu mweꞌa kehuna. Ijihuni hahi hu mweꞌa kehuneru ꞌwarahuna kaivo Ea irara kahi akúpa ꞌahi rene roajaho Hu niꞌimaꞌura. ");
INSERT INTO mcq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ijihunaꞌe Hu raka kaꞌene kima henujaho ꞌwaramuna kaivo pu pahene vejura. ");
INSERT INTO mcq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ea irara Huni ira hene apenujaho hu kamujaho Godiho nimaa nimai. ");
INSERT INTO mcq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ea kaꞌene Godira ranavume roajara Godoni irijaho ꞌwaramuna. Ijihunaꞌe Hu Huni ꞌAvena mina paveꞌikaꞌi mamahuna. ");
INSERT INTO mcq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Omahi Hariaha oja maharena uneunecha mapoka mahoꞌo Huni ija tahi vajahana. ");
INSERT INTO mcq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ea irara Godoni Hariha nimaa ronujaho hu majama hihuna kaivo ea irara Godoni Harihijihuni ira henareꞌe pavenujaho hu majama pahihuna. ꞌEjukame Godoni sena huni haha ꞌahi namu. ");
INSERT INTO mcq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Vea kaꞌene Natohwijara heꞌeme Parasiapo Jesura tisaiporua mapoka vene ꞌee toi samaujara Jonira samajaho ꞌasimaji hejajaho henana. ");
INSERT INTO mcq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ꞌEnakaivo Jesuho Hu ea toa pasamaana kaivo Huni tisaiporuepo samaara. ");
INSERT INTO mcq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ijiꞌa Hu ijí Jutia areꞌikaivo kúꞌo ꞌurine Karari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ꞌEne Hu vaꞌe Sameria ꞌeꞌune vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ꞌEnarena Hu roe Sameria puni ara niꞌina kaꞌene Saika ꞌwavujino mweꞌa kaꞌene Jekapira hariaha Josapi mahajihuni rori vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ijí ꞌunama kajaho jopatuꞌuraꞌomo Hu roꞌeme haha sevume roe Jekapi oni toúja roraꞌomo ijí ꞌojuta hweꞌeme vea rira renana. ");
INSERT INTO mcq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Napara pina Sameria ora toa kaji ꞌeꞌi roana. ꞌEjume Jesu ijá ꞌwama Toa ꞌe mihe Na ijuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ijihuni maijaho Jesuni tisaiporu Hu raname ari natohwi ꞌiruma ꞌimeꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sameria napara kajara Jesu ijá ꞌwama Na Sameria ore A Jua kaivo A irakijihunaꞌe toa na maꞌurono jaririmo? ꞌwamana. Napara kajara Hu ꞌwarama jihuni maijaho Jua Sameriaꞌo puꞌúmo uneunecha paahuma vejura. ");
INSERT INTO mcq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesura eha vene hu ijá ꞌwama A Godira eaꞌe swara kaꞌene mihaji hene ꞌee ea irara a toa jarirame toa miha ꞌwamuji hena kaꞌipisa a Hu toa jarivakame Hu toa kaꞌene majama hihunijaho mahaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ꞌEjume ijí napara kajara Hu ijá ꞌwama Ijihuni maijaho toa újakaho vamaijihunaꞌe Ara toa ꞌehuna areri pana. ꞌÚ A ichihi toa kaꞌene majama hihunijaho ꞌehune? ");
INSERT INTO mcq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ꞌÚ A nuni oma Jekapi asimane? Ijaho hura toa úja núa múhana. ꞌEnareꞌe hu oriꞌina ꞌee harihwaha ꞌee huni purumakaua ijipo ijara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ꞌEjume Jesura eha vene hu ijá ꞌwama Ea irara toake iꞌamajaho hu kúꞌo huahuna. ");
INSERT INTO mcq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ꞌEnakaivo ea irara toa kaꞌene Nara mahuji iꞌamajaho hu kúꞌo toa pahuahuna. Ijí toa kaꞌene Nara hu maꞌujara huni oja vaji namareje toa úja ajime arihareje ijara vejakame majama hihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ꞌEjume napara kajara Hu ijá ꞌwama Nimaakúne toa kaji miꞌirakúne na toa pahuanive paꞌunama roe toakaho ꞌeꞌejukúne ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hu napara kají ijá ꞌwama A vaꞌe paruuna ꞌumenareje iki kúꞌo ꞌunama roꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ꞌEjume napara kajara eha vene ijá ꞌwama Na parua paꞌana ꞌwamana. ꞌEjume Jesura hu ijá ꞌwama A nimaa ꞌwarimareꞌe na parua paꞌana ꞌwimu. ");
INSERT INTO mcq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ꞌEnakaivo a parua iropu venana. ꞌEnavo ea kaꞌene iviamaa a huꞌúmo nenujaho oni parua panaꞌomo a nimaa ꞌwarimana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ꞌEjume napara kajara Hu ijá ꞌwama Na kavujaho A nimaa poropetia. ");
INSERT INTO mcq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Emahu núna Godiho ike huriꞌa ꞌahakino oja mahe taꞌarohura. ꞌEnakaivo jara ꞌwaruvujaho Godiho Jerusaremi oja mahe ꞌee taꞌarohuna ꞌúvura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ꞌEjume Jesu hu ijá ꞌwama Naparakere Na nimaa vetiꞌamana. Vea maiꞌo rounaꞌomo rosaꞌeje ja Amoho ike huriꞌa ꞌahakaho ꞌee Jerusaremiru paoja mahe ꞌee taꞌarohuna. ");
INSERT INTO mcq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ja raka kaꞌene oja mahe ꞌee taꞌarohujaho ja pahejura kaivo nú raka kaꞌene oja mahe ꞌee taꞌarohujaho nú hejura. Ijihuni maijaho ea niꞌajihiꞌinijaho Jua punaꞌi rena rou. ");
INSERT INTO mcq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Vea rounaꞌomo rosaꞌena iviamaa vea ikaho ea Amo nimaa oja mahe taꞌarohunijipo Amoho oja ꞌAvena ꞌee nimaijino oja mahe taꞌarohuna. Ijihuni maijaho Amoho ea ijakajipo oja mahe taꞌaroꞌavarono saramu. ");
INSERT INTO mcq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Godiho ꞌAveni jihunaꞌe ea irahipo Huaꞌe oja mahe taꞌaroꞌavajaho oja ꞌAvena ꞌee nimaijino oja mahe taꞌarohuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ꞌEjume napara kajara Hu ijá ꞌwama Na hejujaho Masaiaho rohuna. Huni iha Kerisona. Vea kaꞌene ijara roꞌamajaho Hu uneunecha mapoka mahoꞌo nú najuhuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesura ijá ꞌwama Ea kaꞌene ara rone ꞌwarimujaho Nana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hu ijí napara kaji ꞌwaraꞌeme Huni tisaiporu ro useme kamareja pu nihoꞌo oja hwaꞌusunahara. ꞌEnakaivo ea pina Hu paijá ꞌwama A raka samo? A rakijihunaꞌe hu huꞌúmo hine vuꞌa ꞌwaviꞌi hino paꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ꞌEjume napara kajaho toata huna ijí ranaꞌikaꞌi vaꞌe parua kaꞌene ari hijajija ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Roe ea pina nara raka kaꞌene mahoꞌo vejujihijaꞌe nahama ꞌwarimaji kaha! Vi ea kajaho Kerisona rakakúne ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ꞌEjume pu niꞌaha kwino ara natohwa areꞌikaivo Huni roara. ");
INSERT INTO mcq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ꞌEꞌeme ijihiꞌa kajano Huni tisaiporuepo ꞌiruma iꞌiro ꞌejahae ijá ꞌwava Najuhiꞌine ꞌiruma ina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ꞌEnakaivo Hu ijá ꞌiama ꞌIruma kaꞌene Nara ihunijaho ja pahene pakivura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ꞌEjume pu piraꞌarame apenojiꞌi ijá ꞌwava ꞌÚ ea ꞌahoꞌa vi ꞌiruma ꞌeka roahare? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu ijá ꞌiama Nuni ꞌirumijaho Godi kaꞌene Na ranamiume roujihuni uriji vene ꞌee Huni kaukara ijí veje parahuna. ");
INSERT INTO mcq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ja ꞌwarivujaho masapa noꞌone noꞌo ijá paꞌareꞌeje juara sama ihuna ꞌwarivu kaivo ike heha! Iviamajaa ja rora rora ikine nia ahasirime kiha! Iviamai juara nituma sahe areri rena navu. ");
INSERT INTO mcq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ea kaꞌene vaꞌe juara samujaho eha niapenana ꞌee hu ꞌina majama hihunaꞌe nianae irechamu ꞌee ea kaꞌene ijí soa samujine ꞌee ea kaꞌene ijí juara samajiꞌo ahuma teamarasahuna. ");
INSERT INTO mcq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ijihuni hahi ikaꞌina ꞌúvujaho nimaa ei pini soa savuꞌe ꞌee ea pini juara samuna. ");
INSERT INTO mcq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na ja juara saꞌavarono irechamiukúne vaꞌajime juara kaꞌene ja soa pasavaji saꞌavara. Ea ꞌahopo ni soa savarakúne ja mavaꞌe ijí uramaraꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ꞌEjume ea mapoka kaꞌene Sameria ora kajijahija Hu nimaa rojara. Ijihuni maijaho napara kajara raka kaꞌene venaji Hu nahama ꞌwarama jihunaꞌe pu nimaa rojara. Hu uneunecha mapoka kaꞌene nara vejujaho nahama ꞌwarimana. ");
INSERT INTO mcq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hu ijí hiꞌeme Sameria opo roajime jarima pu puꞌúmo hiꞌamarono ꞌwavara. ꞌEjume Hu pu puꞌúmo naꞌia noꞌo hinana. ");
INSERT INTO mcq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ꞌEjiꞌi ea ꞌahoꞌa mapoka ꞌuꞌo Hura ira kaꞌene ꞌwaramaji henareja nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ꞌEjume pu napara kají ijá ꞌwava Ara raka kaꞌene ꞌwarumajaho pana kaivo nú nimaa rojujihuni maijaho nú onúno Hura raka kaꞌene ꞌwarumaji hejajihunaꞌe nimaa roju. Nú nihejujaho Hu nimaa eaka mapokakihi Niꞌajihunijina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Naꞌia noꞌo paꞌareꞌeme ijiꞌa Hu ijí rene Karari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesura ori hena kamajaho poropetia huni ara kwaa ijaho huni hura pavejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ꞌEjume Hu Karari roume Karari opo Jerusaremi Pasova veijino uneunecha mapoka kaꞌene Hura vejume pu kavajihunaꞌe hami apejara. ");
INSERT INTO mcq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ꞌEjume Hu kúꞌo vaꞌe Kena Karari vaji Hura toa vejume ꞌwainia renaji vaꞌana. ꞌEꞌeme Kapeniami ea natohwa pipuni hariha atami ꞌunamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ꞌEjume hu henajaho Jesu Jutia rene Karari roume ijí Huni vaꞌe jarima ꞌwarave ro arihe huni hariha veje sonaꞌamarono vaꞌana. Ijihuni maijaho hura kwahuna nihoꞌo nituꞌu renana. ");
INSERT INTO mcq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ꞌEjume Jesu ijihuna ijá ꞌwama Na aacha pina aniꞌina ja panajaꞌipisa ja unenu pina nimaa parojaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ꞌEjume ea natohwa kajara Hu ijá ꞌwama Nuni harihi kwama veꞌenakúne maraku roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesura hu ijá ꞌwama Oni hariha pakwamu kaivo maiꞌo hinukúne vaꞌa ꞌwamana. ꞌEjume ea kajaho Jesuni ira nimaa venarena aneja vene vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hu maiꞌo vaꞌeme huni pwehipo roe piuname ijá ꞌwava Oni hariha niꞌurina hinu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ꞌEjume hu pu aporama ijá ꞌiama Hu vea oma raki ꞌurinane? ꞌiamana. ꞌEjume pu ijá ꞌwava Niari vea karaa tahunanaꞌeme huni haha uhoa paꞌarenana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ꞌEjumakamarena omahi henajaho vea oma kaꞌene Jesura hu ꞌwaramarene Oni hariha maiꞌo hinukúne ꞌwamani vea omiji henana. ꞌEnarena Hua ꞌee huni kachiꞌina mahoꞌo nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesu kwaa Jutia rene Karari roajino Huni aacha pinakaho kúꞌo ea najahana. ");
INSERT INTO mcq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Uneunecha ikeja vejume paꞌareꞌeme ijihuni túnaꞌi Jua puni vea natohwa rejume Jesu Jerusaremi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ijí Jerusaremi sipia maketia vejuri vwicha jiami toa pina nahúna namuna. ꞌEnaꞌomo ijí Hipuru opuni iri ꞌurahujaho Patesita ꞌwavura. Ijihuni rora ruha iropu navura. ");
INSERT INTO mcq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ijí sea kajihipuni urotijino ea atami ꞌuniraviꞌina mapoka ijí hijuꞌe ea nia paꞌana mumora sisea ꞌee ꞌahoꞌa ija mumora irimaꞌina niꞌaha kwino toa kajara sisupa tuava kaꞌi ꞌahiuꞌe ꞌajaha hijura. ");
INSERT INTO mcq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Naꞌi ꞌahoꞌi Natohwi jihuni ꞌona ojiꞌini vea apeꞌejuꞌe ijí toa vaja kaji vaꞌe arihareꞌe vejuꞌe nivavukaviꞌi ea pina kaꞌene toa vaja kaji marako urane va ꞌonajaho marajuꞌe roe ajimuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ea pina atami ꞌunavume naꞌejume juara mapoka (38) paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ꞌEnaꞌomo Jesura kamajaho hu ijí namana. ꞌEꞌeme Hu henajaho ea kajaho atama majama namunaꞌe henana. ꞌEnarena Hu ijá ꞌwama ꞌÚ a atama kajaho sonahahuna ura renao? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ꞌEjume ea kaꞌene atakina kajara eha vene ijá ꞌwama Toakara nivamuni veijaho ea kaꞌene na apenia vaꞌe toa vaja kaji apúsamihunijaho panaꞌomo na ꞌurina vaꞌejuꞌe ei pini marako tatiha ꞌojuꞌe na arema hijura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ꞌEjume Jesu ijá ꞌwama ꞌUrine oni suha apene namina vaꞌa ꞌwavume ");
INSERT INTO mcq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","niꞌaha kwino ea kajaho sonajume hu ꞌurine huni suha apene aneja vene namina vaꞌana. Ijí vea kajaho Sapati avanana. ");
INSERT INTO mcq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ꞌEjume Juapo ea kaꞌene maranaji ijá ꞌwava Iviasa Sapatiaꞌomo ijaꞌina pavehune saꞌinaꞌe a raka vene oni suha apena vaꞌo ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ꞌEnakaivo hu eha vene ijá ꞌiama Ea kaꞌene na veniume sonahiajara ijá ꞌwima A ꞌurine oni suha apene vaꞌa ꞌwivume na ijihunaꞌe ꞌurine nuni suha apene rou ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ꞌEjume pu hu apoma ijá ꞌwava Ea iraka saꞌinijara a oni suha apene ꞌurina vaꞌamarono ꞌwamane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ꞌEnakaivo ea kajaho irara hua vejuma sonanajaho puruva renana. Ijihuni maijaho Jesuho eaka mapoka kajihipuni taurura kajino vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Túnaꞌi Jesu ea kajaho Temiporu vaji piunamarena ijá ꞌwama Hena! A iviꞌa maranaanakúne a kúꞌo sisea paveꞌamana. ꞌEjakame unenu pina sisemaa kúꞌo oni haha ꞌaha parenaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ꞌEjume ea kajaho vaꞌe Jua ijá ꞌiama Jesura vejume maraniana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesura Sapati vei ea vejume sonana jihunaꞌe Juapo Jesuho siseꞌi ꞌahae ruarahara. ");
INSERT INTO mcq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ꞌEjume Hu eha vene pu ijá ꞌiama Nuni Omijaho naꞌia mapokaꞌe kaukara venujihunaꞌe Na ꞌuꞌo veju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ijí Hu ijá Noinꞌwarama jihunaꞌe Jua Hua ꞌanaꞌi ꞌahiara. Hura Sapati vea kaꞌene paakumajiru pana kaivo Godi Huni oma ꞌiame Hu areri Godia ꞌiamajihunaꞌe pu Hu ꞌanae kwaꞌamarono ꞌunama savara. ");
INSERT INTO mcq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ꞌEjume Jesu eha vene ijá ꞌiama Na nimaa nimai ja ꞌwaravu. Godoni Hariha Hu Huni vwiha ijaho nihoꞌo pavenu kaivo raka kaꞌene Hu kaꞌejuꞌe Omahi venujiru venuna. Uneunecha mapoka kaꞌene Omahi venujaho Hariaha ꞌuꞌo ijaꞌina venuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ꞌEnaꞌomo Omaha Hariaha oja mahareꞌe Hura uneunecha mapoka kaꞌene venujaho nahuna. ꞌEnareꞌe uneunecha mamaꞌina kaꞌene vehunijaho nahuna. ꞌEjukame ja ijí kame oja hwaꞌusahau. ");
INSERT INTO mcq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Areri Omahi vejume kwamasahiꞌina hijujaꞌinaꞌe Hariahi ea kaꞌene Hu ura renujija ꞌuꞌo majama hihuna mihuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ijihuni maijaho Omaha ꞌotua pavetihuna kaivo Hu Hariahi ea ꞌotua vetihuni harura mahoꞌo mahana. ");
INSERT INTO mcq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ꞌEjakamareje ea mapoka Omaha taꞌarohu jaꞌinaꞌe Hariaha ꞌuꞌo taꞌarohuna. Ea irara Jesu paaromahujaho Hu Omaha kaꞌene Hua ranavume roajaho pataꞌarohu. ");
INSERT INTO mcq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na nihoꞌo nimaa nimai ja ꞌwaravu. Ea irara Nuni ira hene nimaa rone Godi kaꞌene Na ranamiume rouji nimaa ronujaho hu majama hihuna niapenana. Ijihunaꞌe hu ꞌotua pavehuna kaivo Hu kwahunijaho niareꞌikaꞌi majama hihuni ruhijino roana. ");
INSERT INTO mcq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na nimaa nimai ja ꞌwaravu vea maiꞌo rou kaivo iviamaa nituꞌu renu. ꞌEnaꞌomo ea kaꞌene kwamasahiꞌinijija Godoni Harihijihuni ira heꞌavajaho kúꞌo ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ijihuni maijaho Omahi majama hinujaꞌinaꞌe Hariaha ꞌuꞌo majama hihuna mahana. ");
INSERT INTO mcq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ꞌEne Hu Emaa Puni Harihijihunaꞌe Hu harura kaꞌene ea ꞌotua vetihunijaho mahana. ");
INSERT INTO mcq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ja ike heꞌavajaho oja pahwaꞌusunahaꞌamana. Ijihuni maijaho vea maiꞌo roujihunaꞌe ea kwamasahiꞌina kaꞌene euchi navujaho Huni ira hehuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ꞌEjakame pu ijí euchi rene ꞌurihuna. ꞌEnareje ijí ea kaꞌene mamaa vejiꞌinijija ꞌurina majama hihuna. ꞌEnakaivo ea kaꞌene sisea vejujija ꞌurinareje ꞌotua vehuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na Nuni vwiha ijaho majikaria unenu pina pavehuna kaivo Na hejujaꞌinaꞌe Na ea eha mihura. ꞌEne Nara eha kaꞌene mihujaho nihoꞌo arira. Ijihuni maijaho Na Nuni ura ijaho pavejura kaivo Godi kaꞌene Na ranamiume roujara ura renujiru vejura. ");
INSERT INTO mcq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na onuno raka kaꞌene vejuji rone ꞌwaraꞌujaho nimaa pana. ");
INSERT INTO mcq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ea pini Na rona ꞌwaramujaho Na niheju. Hu Na rona ꞌwaramujaho nimaa nimaa. ");
INSERT INTO mcq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ja ea irechavume vaꞌe Joni apovumakame Na iraho Hu nimaa nimai nahama ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ꞌEnakaivo Nara emaa punaꞌi hejutaꞌe ꞌwarahuna pana. ꞌEnakaivo Na uneunecha ike ꞌwaravujaho jara hene nimaa rone maraniꞌamarono ꞌwaravo. ");
INSERT INTO mcq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Hu ira kaꞌene rena ea hananiajina. ꞌEjume ja ura renaꞌeme temarasahiꞌi huni hanajiꞌina vaji hijara. ");
INSERT INTO mcq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ꞌEnakaivo Jonira raka kaꞌene Na rone ja ꞌwaravume hejajaho Nara uneunecha kaꞌene veꞌujarahara ijaho asihuna. Kaukara kaꞌene Na veꞌurono Amora vajihajaho Na ijí veje ja kime nimaa nimaa Amora ranamiume routa ꞌwahuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Amo kaꞌene Na ranamiume roujara Huhusumano Na rona ꞌwaramana. ꞌEnakaivo ja Huni ira nihoꞌo pahejure ꞌee Hu icháꞌinijaho pakavura. ");
INSERT INTO mcq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ꞌEnajihunaꞌe Huni Ira joni oja vaja panamu. Ijihuni maijaho Ea kaꞌene Hu ranavuma roajaho ja panimaa roju. ");
INSERT INTO mcq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ja Godoni Ira tahe saravu jihuni maijaho ja vwihajujaho ijihuni vaji majama hihunijaho apeꞌeja roju. ꞌEnakaivo ijí ira kajaho Naaꞌe rone ꞌwaramuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ꞌEnakaivo ja Nuni roareje majama hihuniji apehunijaho ja ura parenau. ");
INSERT INTO mcq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Emapo Nuni pinaniji ꞌunama ahasirivujaho Na panimaa vetiu. ");
INSERT INTO mcq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ꞌEnakaivo Na ja nihena kivu. Godoni oja kaꞌene ea oja mihujaho joni vaja maiꞌo panamu. ");
INSERT INTO mcq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Nuni Omijihuni iha ꞌahi roujaho ja Na paapeniu vo vu ea pini huni iha toi roꞌamajaho ja hu hami apehuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ja ojono taꞌarosaraꞌi kaivo Godi kaꞌene nikwinuꞌwi maijara ja taꞌarorahunijaho pasaraꞌavajaho ja icháꞌinaꞌe nimaa roꞌeja? ");
INSERT INTO mcq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nara Amo oni unaꞌi namahuna pavwihaꞌavara. Ja Mosisi nimaa rojujihunaꞌe ea ja namahuna. ");
INSERT INTO mcq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ꞌEnakaivo ja Mosisi nimaa roꞌipisa ja Na ꞌuꞌo nimaa rojaꞌa. Ijihuni maijaho hu Na rone heha ꞌahi vena najahana. ");
INSERT INTO mcq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ꞌEnakaivo ja Mosisira heha ꞌahi vena najahaji panimaa rojajaho vu ja icháꞌinaꞌe Nuni vuꞌijija nimaa roꞌeja? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Uneunecha ikija vejume paꞌareꞌeme ijihuni túnaꞌi Jesuho vaꞌe toa Karari ꞌona ropunaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ꞌEꞌeme ea mapokaꞌe Hua ꞌarariha vaꞌara. Ijihuni maijaho aacha kaꞌene Hura ea mapoka kaꞌene atama ꞌuniraviꞌini jihipuni haha ꞌahi vejuꞌe maraniuji kimareja vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ꞌEjume Jesuho Huni tisaiporu puꞌúmo ajima vaꞌe huriꞌi hinana. ");
INSERT INTO mcq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ijaho Pasova Jua puni sora ijuri vea nituranana. ");
INSERT INTO mcq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesuho Huni nia ahasirima kivume ea mapoka mapoka Huni rouma kimarena Piripu ijá ꞌwama ꞌÚ nú ichihi puretia ꞌimene roe ea ikija vajihe iꞌeja? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ijaho Hu huaꞌe vena kama avanana. ꞌEnakaivo Hura iraka kaꞌene vehunijaho Hu nikamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ꞌEjume Piripura eha vene Hu ijá ꞌwama Nú monia mapoka mapoka (K200) puretia ꞌimeꞌavajaho ea mapoka mapoki jihunaꞌe pu nihoꞌo sahuraru ijakame areria parenahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ꞌEjume Huni tisaiporu pina Enituru Saimani Pita oni ꞌuꞌuijara Hu ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Sesamaa kaꞌene ike hinukara pari vejari puretia iropune ꞌee kija noꞌona ijá irechama hinu kaivo ijaho icháꞌinaꞌe ea mapokakija vajiꞌeja? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesura ijá ꞌiama Ea ikija ꞌiave asuma hija. Ijaho karasia niꞌina ꞌurinanaꞌomo ea mapoka mapoka (5,000) ijihuni ꞌahi asuma hijara. ");
INSERT INTO mcq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ꞌEꞌeme Jesu puretia ꞌeke Godi teimani ꞌwaꞌikaꞌi ijiꞌa ea kaꞌene asuma hija kajija vajihana ꞌee ꞌunama nikwinuꞌina kajino kija ꞌuꞌo ijaꞌina vejume pu ine areri rejara. ");
INSERT INTO mcq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ꞌEjume pu ijume túꞌavara. ꞌEjumakimarena Hu Huni tisaiporu ijá ꞌiama Ja ꞌurina vaꞌajime ꞌiruma pwinaka navu kajija nianae sahura túa pina nihoꞌo paasinaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Puretia kaꞌene pari iropuna kaivo ijume areri renana. ꞌEꞌikaivo sahura túaka navajaho katija iropu ropu noꞌo vejume ituꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ꞌEjume ea mapoka Hura aacha kaꞌene najahaji kamareja ijá ꞌwava Ikaho Poropetia nimaa kaꞌene iki mweꞌi rohunaꞌe ꞌwaruvajina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pu túnaꞌi roe Jesuho harura vene ꞌejahae puni Kiniaꞌe rehuniji hena kimarena Hu kúꞌo irechamie huriꞌa ꞌahi Huhusu vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ꞌEꞌeme nusirevume Huni tisaiporu kami soha rori vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ꞌEne vea va ꞌoꞌeme pu Kapeniami vaꞌiro sisima ꞌahi vaꞌeme Jesuho maiꞌo puni paroꞌeme vea nutuꞌoꞌunana. ");
INSERT INTO mcq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ꞌEꞌeme pu ijí sohi ꞌahi hiꞌeme puuri niꞌimaꞌuri hiramarena soha ajira ꞌurinana. ");
INSERT INTO mcq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ꞌEꞌeme pu toa ꞌahi kwaa jopatuꞌura vaiꞌi kavume Jesuho toa ꞌahi puni roꞌi ꞌahaume roe sisima rori roꞌeme pu Hu kamareja nihoꞌo juvara. ");
INSERT INTO mcq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ꞌEjume Hu ijá ꞌiama Ikaho Naranakúne juvujaho areha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ꞌEjume pu Hu sisima ꞌahi ajiꞌamarono ura renaara. ꞌEjume Hu ro ajiꞌeme niꞌaha kwino sisima ijaho vaꞌe kwaa kaꞌene pura vaꞌiro vaꞌaji naminana. ");
INSERT INTO mcq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ijihuni súꞌuhijino ea mapoka kaꞌene ijí soha ropunaꞌi hijajija nihejara. Ijí sisima kaꞌene Huni tisaiporuepo hijajihuni vajijaho Jesu pahinana kaivo sisima ꞌahoꞌa ijihiꞌa panavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ꞌEjume pu ea mapoka kiꞌejuꞌe sisima maꞌuꞌumaa ꞌahoꞌa Taiperiasi rene vaꞌe ruha kaꞌene Natohwijara puretia ꞌeke Godi teimani ꞌwaꞌikaꞌi vajihume pu ijajine rene roume kivara. ");
INSERT INTO mcq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Vea kaꞌene ea mapoka kajipo Jesuho Huni tisaiporua ijí sisima ꞌaha kaji pakimareja pu sisima maꞌuꞌumaa ꞌaha kajino ajima Jesu sama Kapeniami vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ꞌEnareja soha ꞌona karaꞌi pu Hu piunavara. ꞌEnareja pu ijá ꞌwava Najuhiꞌine A vecha ika roane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ꞌEjume Jesu eha vene pu ijá ꞌiama Na ja nimaa nimaa ꞌwaravu. Ja Na sarivajihuni maijaho Nara Nuni aacha kaꞌene najahuji kimareje sarihuna pana kaivo ja puretia ijume túꞌava jihunaꞌe Na sarivu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ja ꞌiruma kaꞌene paꞌarehuni jihipuni kaukara paveꞌavara kaivo ꞌiruma kaꞌene majama nahuni jihipuni kaukara veꞌavara. Ijaho Emaa Puni Harihijara ja vajihuna. Huni haha ꞌahi Amo kaꞌene Godiho Huni tatua ranamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pu ijihunaꞌe ijá ꞌwava Nú irakaꞌe veꞌavajino Godi oni kaukara venaꞌeja? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu eha vene pu ijá ꞌiama Godoni kaukara ikena. Ea kaꞌene Hura ranavume roaji ja Hu nimaa nimaa roꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ijihunaꞌe pu Hu ijá ꞌwava A aacha pina irakaꞌe najuha kamareje nú nimaa roꞌeja? ꞌEne A kaukara iraka veꞌena? ");
INSERT INTO mcq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Emahu núna puretia kaꞌene mana ꞌwavujaho nechi riri ijara kaꞌene nitama heha Noinꞌahi vejajaho Hu puretia akúpa ꞌahi rene vajihume pu ijara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ꞌEjume Jesu pu ijá ꞌiama Na nimaa nimai ja ꞌwaravu. Puretia kaꞌene akúpi ꞌahi rena roajaho Mosisiho ja pavajihana kaivo Nuni Omijara Puretia nimaa nimaa akúpi ꞌahi rena roajaho mihana. ");
INSERT INTO mcq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Godira Puretia kaꞌene mihajaho kahi akúpi ꞌahi rene roana. Hu majama hihuniji ea mapoka mihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ꞌEjume pu ijá ꞌwava Natohwe naꞌia mapoka puretia kaji vajúha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu ꞌija ꞌiama Na Puretia kaꞌene majama hihunijinaꞌomo ea irara Nuni roꞌamajaho hu kúꞌo pamatuhune ꞌee ea irara Na nimaa nimaa roꞌamajaho hu kúꞌo toa pahuahuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ꞌEnakaivo Na ikaho ja ꞌwaravu ja Na nikivu kaivo maiꞌo panimaa roju. ");
INSERT INTO mcq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ea kaꞌene Amora Na vajihajija Nuni roajihuna. ꞌEjakame ea irahipo Nuni roꞌavajaho Na nihoꞌo pamakihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na kahi akúpi ꞌahi rene roujaho Na Nuni ura paveꞌi routa kaivo Godi kaꞌene Na ranamiume roujara ura renujiru veꞌi routa. ");
INSERT INTO mcq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ikaho Nuni Oma kaꞌene Na ranamiume roujara ura renujina. Ea kaꞌene Hura vajihajijahija Na kwinu paranahuna kaivo mweꞌakara maiꞌo paareꞌamani veijaho Na veje pu niꞌaha kwinu ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ikaho Nuni Oma kaꞌene Na ranamiume roujara ura renujina. Ea irara Hariaha kame nimaa nimaa ronujaho hu nihoꞌo majama hihuna. Ijihuni hahi mweꞌakara maiꞌo paꞌareꞌamani veijino Na onuno veje pu niꞌaha kwinu ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jua ajinava jihuni maijaho Hura ikaꞌina ꞌiama jihunaꞌe Na puretia kaꞌene kahi akúpi ꞌahi rena roujina ꞌiama jihunaꞌe ajinavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pu ijá ꞌwava ꞌÚ Hu Jesu kaꞌene Josapi oni hariha ꞌee oaheꞌo omaheꞌo nú kiviꞌinijija pane? ꞌEnakaivo Hu iviamaa raka vene Na akúpa ꞌahi rena routa ꞌúmo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu eha vene pu ijá ꞌiama Ja nihoꞌo pakukari suꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ea pina Nuna pamajikari rohuna kaivo Amo kaꞌene Na ranamiume roujara hu tairie Nuni rohuna. ꞌEꞌiraꞌomo vea túchamaijino Na veje hu niꞌaha kwinu ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nitama poropetiepo ikaꞌina heha ꞌahi vejara. Pu ea mahoꞌo ijá ꞌiava Ea mapoka Godira najahuna ꞌiavara. NoinꞌEje ea mapoka kaꞌene Amo unaꞌi hene vejajija Nuni roura. ");
INSERT INTO mcq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ea pini Amo kahuna pana kaivo ea kaꞌene Godoni rene roajara Amoho kamuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na nimaa nimai ja ꞌwaravu Ea irara nimaa ronujaho hu majama hihunijaho apenana. ");
INSERT INTO mcq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na puretia kaꞌene majama hihunijina. ");
INSERT INTO mcq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Emahu jona nechiꞌi mana inareja kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ikaho puretia kaꞌene akúpi ꞌahi rena roajinaꞌomo ijí ei pini iꞌamajaho hu pakwahuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na majama hihuni puretia kaꞌene kahi akúpi ꞌahi rena roajina. Ea irara puretia kaji iꞌamajaho majama hihuna. Nara puretia vajihujaho Nuni haha iki ea mapoka mihuna. ꞌEjakame pu majama hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pu Jua nihoꞌo ajinavume nakaraviꞌi ijá ꞌwava Icháꞌinaꞌe Hu Huni haha múhe nú ihuna ꞌwarumo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ꞌEjume Jesu ijá ꞌiama Na nimaa nimai ja ꞌwaravu ja Emaa Puni Hariha kajihuni haha paine ꞌee Huni ꞌaa paiꞌavajaho ja majama hihuna joni vaja paꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ea irara Nuni haha ine ꞌee ꞌaa iꞌamajaho hu majama hihuna. ꞌEꞌiraꞌomo vea túchamaijino Nara veje hu niꞌaha kwinu ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nuni hahijaho puretia nimaa nimaa ꞌee Nuni ꞌaijaho toa nimaa nimaa. ");
INSERT INTO mcq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ea irara Nuni haha ine ꞌee Nuni ꞌaa iꞌamajaho hu Nuni vaji hije ꞌee Na huni vaji hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Oma kaꞌene majama hijiꞌinijara Na ranamiume routa. Nara hijujihuni maijaho Amora hinujihunaꞌe hiju. Ea irara Na iniꞌamajaho Nara rejujihunaꞌe hu majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ike puretiakaho kahi akúpi ꞌahi rena roajina areri emahu jopo inareja kwamasaha jaꞌina pana kaivo ea irara puretia ike iꞌamajaho hu majama hihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hu uneunechakihi ronarena Kapeniami Sinakoku vaji najahana. ");
INSERT INTO mcq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Huni tisaiporu ijí henareja ijá ꞌwava Ijí vuꞌa kajaho nihoꞌo kisina. ꞌEnaꞌomo ea irara ijaho heꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ꞌEnakaivo Jesu henajaho Huni tisaiporu hine kukaraviꞌi hijara. ꞌEjume Hu pu ijá ꞌiama ꞌÚ Nara vuꞌa kaꞌene ꞌwaravujara veje ja pitachinamiꞌeja? ");
INSERT INTO mcq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ꞌEnakaivo ja kaꞌeje Emaa Puni Harihijara kúꞌo ajima vaꞌe kwaa kaꞌene Hura marako hinaji vaꞌipisa ja ichá vejaꞌe? ");
INSERT INTO mcq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godoni ꞌAvenijara majama hihuna mihuna kaivo hahakara unenu pina vehuna nihoꞌo pana. ꞌEnakaivo Nara vuꞌa kaꞌene ꞌwaravujaho Godoni ꞌAvenijinaꞌomo majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ꞌEnakaivo ja ea ꞌahoꞌa panimaa roju ꞌiamana. Nitama anejijino ea irahipo Hu panimaa rohunijaho Hu nihena kime ꞌee ea irara Huaꞌe nahamahunijaho Hu nihena kamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ꞌEjume Hu ijá ꞌiama Ea pina nihoꞌo mají Nuni rohuna pana kaivo Amora venauꞌe roajivu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ꞌEjume ijihunaꞌe Huni tisaiporu ijí henareja ꞌahoꞌa ani vaꞌikaꞌi kúꞌo pu puꞌúmo pavaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ꞌEjume Jesu ea iropu ropu noꞌo ijí ijá ꞌiama Ja ꞌuꞌo ijihunaꞌe Na ranamie ani vaꞌeja? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ꞌEjume Saimani Pitara Hu eha vene ijá ꞌwama Natohwe nú irahuni vaꞌeja? Oni vaji majama hihuni vuꞌijaho namu. ");
INSERT INTO mcq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ꞌEnaꞌomo iviamaa nú nihene ꞌee nimaa rojujaho A ariramaa kaꞌene Godoni rena roajina. ");
INSERT INTO mcq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu eha vene pu ijá ꞌiama ꞌÚ Na onuno ja ea iropu ropu noꞌo iji papijihute? ꞌEnakaivo joni vajaki ea kwinu ꞌavena sisea ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jutasi Isikariati kaꞌene Saimani oni harihiji rone ꞌwaramana. Ijihuni maijaho hu ea iropu ropu noꞌo puni vaji ea kaꞌene Huaꞌe nahamahunijina. ");
INSERT INTO mcq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ijihuni túnaꞌi Jesuho Karari ꞌurahonana kaivo Hu Jutia pavaꞌajihuni maijaho Juapo Hu ꞌanaꞌi savajihunaꞌe pavaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iviamai Jua puni harai ara vejuri veijaho niroe turanana. ");
INSERT INTO mcq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ꞌEjumakame Huni vwehipo Hu ijá ꞌwava Ike kwaa kakaho areꞌikaꞌi roe Jutia vaꞌa. ꞌEjakamareje oni tisaiporu ꞌuꞌo raka kaꞌene Ara venujaho pu hena kahuna. ");
INSERT INTO mcq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ea irara ea mapokaꞌe hena kahunaꞌe ura renujaho hu hema uneunecha pavenuna. ꞌEnakúne Ara iraka kaꞌene venujaho ea mapokakija najaha ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ijihuni maijaho Huni vwehija ꞌuꞌo nihoꞌo Hu panimaa rojajihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ꞌEjume Jesu pu ijá ꞌiama Nuni vea maiꞌo paroiꞌina kaivo joni vea niroana. ");
INSERT INTO mcq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mweꞌa kakaho ja kimujaho pasemu kaivo Na semu. Ijihuni maijaho Na hine ꞌwaravujaho raka kaꞌene hura venujaho sisea ꞌwavukame avanu. ");
INSERT INTO mcq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nuni vea maiꞌo paroiꞌini jihunaꞌe ijí ahaja iju kajaho Na iviamai pavuꞌejukúne jajasu vaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hu ijá ꞌwaraꞌi kaivo Hu ijí Karari hinana. ");
INSERT INTO mcq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ꞌEnakaivo Huni vwehija ijí ahaja ija kaji vaꞌumakiviꞌi Hu ꞌuꞌo huhusu ijí hemi ꞌaji ꞌeꞌune vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ꞌEꞌeme Jua Hu sora ijari vaja kajino samapene ojiꞌi ijá ꞌwava Hu ichihune? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ea mapoka Hunijihunaꞌe rone natohwa suꞌarama apene ojara. ꞌEjumakiviꞌi ea ꞌahoꞌa ijá ꞌiava Hu ea maa maa ꞌiavara. ꞌEjume ea ꞌahoꞌa ijá ꞌwava Pana Hu ea mapokaꞌe aherame pisivie ani vaꞌu ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ꞌEnakaivo ea ꞌahoꞌa Jua juhamareja nihoꞌo samaumai Hu parona ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ahaja niꞌina rira reꞌeme Jesu vaꞌe Temiporu vaji aneja vene najahana. ");
INSERT INTO mcq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jua Hura ꞌwarama kaji pu henareja oja hianaꞌeme ijá ꞌwava Ike eakaho Hu sikurua pavenana kaivo Hu icháꞌina he paranane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ꞌEjume Jesu ijihuni hahi puni eha vene ijá ꞌiama Nara uneka kaꞌene najahujaho Nuna pana kaivo Godi kaꞌene Na ranamiume roujihuna. ");
INSERT INTO mcq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ea irara Huni ura ijí veꞌi veꞌamajaho Na raka kaꞌene najahu jihuni maijaho hu hehuna. Ijí Nara najahu kajaho Godoni rena roanaꞌe reꞌamajaho ijá hehune ꞌee nuni vwihaꞌe ꞌwaraꞌujaho ijá hehuna. ");
INSERT INTO mcq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ea pina hu huni vwiharu ꞌwaramujaho hu ura ea natohwa reꞌi ꞌahauꞌe avanu. ꞌEnakaivo ea irara Godi kaꞌene Na ranamiume rouji taꞌarohujaho hu nihoꞌo nimaa ariramaaꞌe ꞌee sisea paꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ꞌÚ Mosisi tamana ja pavajihane? ꞌEjuꞌe ꞌú ja ea pina nihoꞌo tamana kajaho pavenune? ꞌEnakaivo ja irakijihunaꞌe Na ꞌaniꞌiro sarivo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eaka mapoka kajipo eha vene ijá ꞌwava ꞌAvena sisei A ajimanaꞌe kavu. Irara A ꞌanaꞌiro veno? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ꞌEjume Jesu eha vene ijá ꞌiama Nara unenuꞌu pina natohwa vejume ja kavajihunaꞌe ja oja hwaꞌusahauna. ");
INSERT INTO mcq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosisira ja joni harihija sisa ꞌuhuaꞌavarono ꞌwaramana. Ijaho Mosisi nihoꞌo pamihana kaivo emahu jopuna. ꞌEne Sapati veijaho ja ea sisa ꞌuhuahura. ");
INSERT INTO mcq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ja Sapati ea sisa ꞌuhuahujaho nijina ꞌwavuri jihuni maijaho Mosisi oni tamani jihunaꞌe avajura kaivo ijí ea kaji Sapati Na vejume sonanajaho ja rakijihunaꞌe ajinamo? ");
INSERT INTO mcq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ja pamajikari namaꞌavara kaivo nimaa nimaijiru namaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ꞌEjume Jerusaremi ora ꞌahopo ijá ꞌwava ꞌÚ ikaho Ea kaꞌene ꞌanaꞌirono savujine ꞌwavare? ");
INSERT INTO mcq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Irakijihunaꞌe Hu samaumai namina ꞌwaramo? ꞌEjuꞌe ea pina unenuꞌu pina pavetio? ꞌÚ núni ea mamaꞌina ikaho nimaa Keriso pu nihena kavu raka? ");
INSERT INTO mcq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ꞌEnakaivo ea ikara kwaa kaꞌene rena roajaho nú nihejura. ꞌEnakaivo Kerisora roꞌamajaho Hu ichá rena roujaho ea ꞌahoꞌa nihoꞌo pahehuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ꞌEjume Jesu ajira Temiporu vaji najahe ꞌumejiꞌi ijá ꞌiama Ja Na nihena kime ꞌee Nara rena roujaho ja niheju. ꞌEnakaivo Na Nunaꞌe ꞌwaraꞌi ꞌahie rohuna pana kaivo Godi kaꞌene Na ranamiume roujaho nimaa nimai ja Hu pahene pakavura. ");
INSERT INTO mcq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na Hu hena kavura. Ijihuni maijaho Hura Na ranamiume Na Huni rena routa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pu ꞌunama kaꞌene Hu ape ꞌanahuniji savara kaivo ea pina huni ija Huni haha ꞌaha paranava jihuni maijaho Huni vea maiꞌo paroa jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ꞌEjumakame ea mapoka Hu nimaa rojara. ꞌEne pu ijá ꞌwava Vea kaꞌene Kerisora roꞌamajaho Hu uneunecha mapoka Eakara venujaho asima kahaꞌaja veꞌena raka? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parasi ijipo hijiꞌi heꞌeme ea mapoka hine Hu rona ꞌwavara. ꞌEjumakame Parasi ꞌee pirisiti mamaꞌinijipo sorutia irechamiume Hu apeꞌiro vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ꞌEjume Jesu ijá ꞌiama Na ja puꞌúmo maꞌuako hinareje Na kúꞌo Godi kaꞌene Na ranamiume roujihuni vahuna. ");
INSERT INTO mcq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ja Na sariꞌavajaho pakihuna. ꞌEne Nara hiꞌujaho ja pavuꞌajihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ꞌEjumakame Juapo ijí ꞌwama apenojiꞌi ijá ꞌwava Hu ichihi vaꞌakame nú pakahuna ꞌúmo? ꞌÚ Hu vaꞌe Jua kaꞌene Kuriki puni vaji hijujihipuni vaꞌareje Kurikia najaꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pu ijá ꞌwava Vuꞌa kaꞌene Hu ijá ꞌwarumajaho ja Na sarihuna kaivo pakihuna ꞌee kwaa kaꞌene Na vaꞌujaho ja pavuhuna ꞌúmujihuni maijaho irake? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ahaja ijari vea niꞌina kaꞌene túchamaijaho paꞌareꞌiro veꞌeme Jesu namiꞌikaꞌi ajira ꞌumena ijá ꞌiama Ea irara toa huaꞌamajaho hu Nuni roe Na mahe iꞌamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Godoni iri nitama ijá ꞌwarumana. Ea irara Na nimaa ronujaho huni oja vaji toa kaꞌene majama hihunijaho hirame arihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ijaho Hu Godoni ꞌAvenijiꞌi rone ꞌwarama avanana. Ea irahipo Hu nimaa nimaa roꞌavajipo pu Godoni ꞌAvena kajaho apehuna. ꞌAvena kajaho maiꞌo paroiꞌina. Ijihuni maijaho Jesu maiꞌo pavaiꞌini jihunaꞌe paroana. ");
INSERT INTO mcq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ea mapoka kajihipuni vaja kaji ea ꞌahopo heꞌeme ijí ꞌwaravuma henareja pu ijá ꞌwava Nimaa Ea ikaho Poropeti ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ꞌEjume ea ꞌahoꞌa ijá ꞌwava Hu Kerisona ꞌwavara. ꞌEjume ꞌahoꞌa ijá ꞌwava Keriso icháꞌinaꞌe Hu Karari rena roꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ꞌEjume ei pini ijá ꞌiama ꞌÚ nitama Godoni Irijara ikaꞌinaꞌe paꞌwaramane? ꞌÚ Kerisoho Teviti oni amujaꞌomo Petirihemi Teviti oni arijino nahehune? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ꞌEjume ea mapoka Huni hahijihunaꞌe ahaama hijara. ");
INSERT INTO mcq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pu ea ꞌahoꞌapo ura Huaꞌe ape ꞌanaꞌi ꞌahiara kaivo ea pina Hu ija paꞌunavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ꞌEjume hirisima pu kúꞌo ꞌuname Parasi ꞌee pirisiti mamaꞌini jihipuni vaꞌume pu ijá ꞌiava Ja rakijihunaꞌe Hu paapena roare? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hirisimapo eha vene ijá ꞌiava Ea pina ike Ea ikara ꞌwarumu kaꞌina paꞌwarumuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ijí Parasi kajipo eha vene ijá ꞌiava Hu ja ꞌuꞌo papisimiane? ");
INSERT INTO mcq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ꞌÚ ea mamaꞌina ꞌahoꞌa ꞌee Parasi ꞌahoꞌa Hu nimaa rojure? ");
INSERT INTO mcq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ꞌEnakaivo ike ea kijahija Mosisi oni tamana pahena pavejuraꞌomo ijihuni hahi pu eha sisea apehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikotimasiho ea pina kaꞌene naꞌi vaꞌe Jesuho kamajina. ꞌEnaꞌomo hura pu ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Núni tamana ea unekaka hu venujaho maraku huni ira hene hu raka kaꞌene venujaho kamareꞌe ijiꞌa túnaꞌi ꞌotua vetiura ꞌaho ichá vejure ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ꞌEjume pu eha vene hu ijá ꞌwava A ꞌuꞌo Karari ore? Ijinakúne vaꞌe Godoni ira vaji rasama taha kaꞌamana. Poropetia pina Karari paꞌurihuna ꞌwarumana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ꞌEjume ea mapoka kajija ꞌuname puni ari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ꞌEjume Jesuho Arivi huriꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ꞌEnaꞌomo súꞌo vea maiꞌo ahara sama kamino kúꞌo ꞌunama vaꞌe Temiporu vaji vaꞌeme ea mapoka nianaa roume Hu asuma hine najahana. ");
INSERT INTO mcq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sikuraipia ꞌee Parasiapo napara pina parua turavumakame aheme apene roe puni rira muꞌoi ranavume naminana. ");
INSERT INTO mcq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pu Hu ijá ꞌwava Najahiꞌine naparakaho parua turame ꞌoꞌeme nú piunavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosisi oni tamana ijaꞌina ꞌwarumana. Napara ijaꞌinijija muni ꞌeke ꞌanie kwamasahuna ꞌúmana. Nú icháꞌina vehunaꞌe A vwihano? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pu Hu ꞌwarava jihuni maijaho pu vena kave Hu icháꞌina veja kaꞌavajaho ijihuni ꞌahi namijiꞌi Huaꞌe namaꞌi ꞌahiume avajara. ꞌEnakaivo Hu sarasaru hine mweꞌahi Huni iji asura venana. ");
INSERT INTO mcq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ꞌEꞌeme pu ijá namine apoma pasonananavume Hu ahasirima ꞌurijiꞌi ijá ꞌiama Ja namijuri vajaki ea pini sisea nihoꞌo pavenuna vwiꞌamajara marakoꞌa muna apene hu ꞌanaꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ꞌEꞌikaꞌi Hu kúꞌo sarasaru hijiꞌi mweꞌa ꞌahi asura venana. ");
INSERT INTO mcq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ꞌEꞌeme pu ijí henareja ea kwinu kwino emakiniji rene vaꞌe va ranaꞌikaꞌi Jesu Huhusu napara kaꞌene rira muꞌoi hu huꞌúmo namina kajiꞌi irechamia va ranavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ꞌEjume Jesu ꞌurijiꞌi napara kajaho ijá ꞌwama Napare ea kaꞌene a namahujija ichihune? ꞌÚ ea pina pahine a namahane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hu ijá ꞌwama Natohwe ea pina pana ꞌwamana. ꞌEjume Jesu ijá ꞌwama Na ꞌuꞌo a panamahunakúne vaꞌa. ꞌEnakaivo iviamaa rene kúꞌo sisea paveꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesu kúꞌo ijá ꞌiama Na mweꞌa kehuni hanajiꞌina. ꞌEnaꞌomo ea irara Na ꞌararihiꞌamajaho hu nututa nihoꞌo areri paohuna. ꞌEnakaivo hu ira kaꞌene majama hihunijaho apehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ꞌEjume Parasijipo ijá ꞌwava A orono ronareꞌe ꞌwarumajaho nihoꞌo nimaa pana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu eha vene ijá ꞌiama Pana Na onuno ronareꞌe ꞌwaravujaho nimaa nimai. Ijihuni maijaho Nara ichihi rena roujaho Na nihene ꞌee Nara ichihi vahunijaho niheju kaivo ja nihoꞌo Nara ichihi rena roujaho pahejiꞌine ꞌee Nara ichihi vahunijaho ja pahejiꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ja haha huni ꞌunamiji namahura kaivo Na ea pina panamahu. ");
INSERT INTO mcq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ꞌEnakaivo Na ea namaꞌujaho Nara namahujija nimai. Ijihuni maijaho Nanasu pana kaivo Nuni Oma kaꞌene Na ranamiume roujiꞌi Nú rene namahura. ");
INSERT INTO mcq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Joni tamana heha ꞌahi asura ikaꞌina vejara. Ea noꞌo kavaraꞌe reꞌamajaho nimaa ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na onuno hena kavuji rone ꞌwarame ꞌee Amo kaꞌene Na ranamiume roujara hena kimunaꞌe ꞌwaravu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ꞌEjume pu Hu ijá ꞌwava Omuna ichihune? ꞌwavara. ꞌEjume Jesu eha vene ijá ꞌiama Ja Na pahene pakivu jihunaꞌe Nuni Oma ꞌuꞌo pahene pakavura. Ja Na hena kiꞌipisa ja Nuni Oma ꞌuꞌo hena kavaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Temiporu vaji ruha kaꞌene katua irechavujino ira ikijahija najahajaho ea haha ꞌaha ija paranavara. Ijihuni maijaho Huni vea maiꞌo paapenana. ");
INSERT INTO mcq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ꞌEnarena Hu kúꞌo pu ijá ꞌiama Na vahuna. ꞌEꞌeje ja Na sarihuna kaivo ja joni sisei jihunaꞌe kwamasahuna. Ja Nara kwaa kaꞌene vaꞌujaho pavuhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ꞌEjume Juapo ijá ꞌwava Hura ijá ꞌúmujaho Nara kwaa kaꞌene vaꞌujaho ja pavuhuna ꞌúmujaho ꞌú Hu oriꞌini ꞌanaꞌarahunaꞌe ꞌwarumo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hu pu ijá ꞌiama Ja mweꞌa harake ora kaivo Na ichutohuna. ꞌEne ja mweꞌa kehuna kaivo Na mweꞌa kehuna pana. ");
INSERT INTO mcq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ijihunaꞌe Na ijá ꞌiavujaho ja joni sisei jihunaꞌe kwamasahuna. Ja Na panimaa roꞌavajaho Na ea Ijinaꞌomo ja joni sisei jihunaꞌe kwamasahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ꞌEjume pu ijá ꞌwava A irarane? ꞌwavara. ꞌEjume Jesu ijá ꞌiama ꞌÚ Na kami aneji rene iraka ꞌwarame apene route? ");
INSERT INTO mcq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na uneunecha mapoka ja ꞌwarame namahuna kaivo Godi kaꞌene Na ranamiume roujaho nimaa nimaaꞌomo Na raka kaꞌene Huni hejujiru mweꞌaki ꞌwaravu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hu Omaha rona ꞌwaramajaho pu pahejara. ");
INSERT INTO mcq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ꞌEjume Jesura ijá ꞌiama Vea kaꞌene ja Emaa Puni Harihiji ꞌunama apena ahasiriꞌavajino ja Na Ea iraho hena kihuna. Nara unenuꞌu pina Nuni vwihai vehuna pana kaivo Amora najihajiru Na veju. ");
INSERT INTO mcq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Godi kaꞌene Na ranamiume roujaho Nú huꞌúmo hinuna. Hu nihoꞌo Na paranamie ani vaꞌu. Ijihuni maijaho uneunecha kaꞌene Nara naꞌia mapoka vejujara Hu teamamuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hu uneunecha kaji ꞌwaravumakame ea mapoka roe nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ꞌEjume Jesura Jua kaꞌene Hu nimaa rojajija ijá ꞌiama Nuni Ira kaꞌene joni oja vaji namuji ja venapene vaꞌavajaho ja nimaa nimaa Nuni tisaiporua. ");
INSERT INTO mcq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ijihuni hahi ja nimaa nimaiji heꞌavajaho nimaa nimaa kajara veje ja sisea huni harura hara pahihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ꞌEjume pu eha vene Hu ijá ꞌwava Nú Eparahami oni amuhijaꞌomo nú ea ꞌahopuni pwea parejara. ꞌEnaꞌe a ichá vene ja sisea huni harura hara pahiha ꞌúmo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ꞌEjume Jesu eha vene pu ijá ꞌiama Na nimaa nimai ja ꞌwaravu. Ea kaꞌene sisea vejujaho sisea kajihuni pwea rejura. ");
INSERT INTO mcq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ꞌEnakaivo pwea ea kachiꞌina puꞌúmo majama pahinuna kaivo hariha ijara sea vaja majama hinuna. ");
INSERT INTO mcq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ꞌEnaꞌomo Harihijara veje ja sisea huni harura hara pahiꞌavajaho ja nimaa nimaa sisea huni harura hara pahiju. ");
INSERT INTO mcq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na nihejujaho ja Eparahami oni amuhija. ꞌEnakaivo Nuni ira joni oja vaji panamu jihunaꞌe ja ura Na ꞌaniꞌiro ꞌahiuꞌe sarivu. ");
INSERT INTO mcq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na raka kaꞌene Amo oni unaꞌi kivuji ꞌwaravu kaivo ja ꞌuꞌo joni omijara vejume ja kivaji veju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ꞌEjume pu Hu ijá ꞌwava Eparahamiho núni oma ꞌwavara. ꞌEjume Jesu ijá ꞌiama Ja Eparahami oni amuhija reꞌipisa ja Eparahamira venujiru vejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na ea kaꞌene Godinaꞌi nimaiji hena ꞌwaravujina. ꞌEnaꞌomo ja Na ꞌaniꞌirono sarivu. Eparahami ijaꞌina pavejaꞌa. ");
INSERT INTO mcq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ja joni omijara raka kaꞌene venuji veju ꞌiamana. ꞌEjume pu Hu ijá ꞌwava Nú Oma paꞌana pana kaivo núni Oma Godina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ꞌEjume Jesu pu ijá ꞌiama Godiho joni Oma reꞌipisa ja Na oja mihaꞌa. Na Godoni rena routa. Ijihuni maijaho Na Nuni oja paꞌene routa kaivo Godira ranamiume routa. ");
INSERT INTO mcq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ja rakijihunaꞌe Nara raka kaꞌene ꞌwaravujaho pahejare? Ijihuni maijaho ja Nuni ira pahejura. ");
INSERT INTO mcq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ja oma jona kaꞌene Setani oni harihija. Ijihuni hahi ja ura oma jona kajara venujaꞌina veꞌiro ꞌahiu. Nitama anejijino rene hu ea ꞌaniuna. ꞌEnakaivo hu ꞌunama nimaa nimaijaho nihoꞌo pahihuna. Ijihuni maijaho nimaa nimaijaho huni oja vaja panamuna. ꞌEjuꞌukame huni vaja iraꞌati rarena jihunaꞌe hu iraꞌataru ꞌwaramuna. Ijihuni maijaho hu iraꞌasine ꞌee iraꞌasine puni oma. ");
INSERT INTO mcq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na nimaa nimaa ꞌwaravuꞌukame ijihunaꞌe ja Na panimaa roju. ");
INSERT INTO mcq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ja ea irara iviamaa Nuni sisea ꞌwariꞌena? Na nimaiji ꞌwaravu kaivo ja irakijihunaꞌe Na panimaa rojo? ");
INSERT INTO mcq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Godoni eijija pu Godoni iraru hejura. Ja Godoni ira paheju jihuni maijaho ja Godoni ea pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ꞌEjume Juapo eha vene Hu ijá ꞌwava Nú A Sameria ora ꞌwame ꞌee ꞌavena sisea A ajimaiꞌina ꞌwavujaho nimaaꞌe ꞌwavure? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu eha vene ijá ꞌiama Na ꞌavena sisea paꞌajimiꞌina kaivo Nara Amoni iha taꞌarohu kaivo ja vejuꞌe Na junimu. ");
INSERT INTO mcq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na Nuni iha onuno pataꞌarosaravura kaivo Godira Nuni iha taꞌarohe ꞌee mina vena kimuna. ");
INSERT INTO mcq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na nimaa nimai ja ꞌwaravu. Ea irara Nuni ira ike ija kisi ꞌuname huni vaji ranaꞌamajaho hu kwahuna pakahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ꞌEjume Juapo ijá ꞌwava Nú nihejujaho A ꞌavena sisei ajimana. Eparahami kwavume ꞌee poropetia ꞌuꞌo kwamasahara kaivo A ijá ꞌúmo Ea irara Nuni ira hene venujaho nihoꞌo pakwaꞌena ꞌúmu. ");
INSERT INTO mcq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ꞌÚ A Eparahami kaꞌene natohwijaho ꞌee poropetia kaꞌene kwamasahajija asitahane? A ea rana rone avano? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesura pu eha vene ijá ꞌiama Na Onuno Nuni pinana ꞌuname ahasiriꞌipisa Nuni pinana maa paꞌanaꞌe rejaꞌa kaivo Nuni Omijara Nuni pinana ꞌunama ahasirimu. ꞌEjuꞌe ja ijá ꞌwavo Hu núni Godia ꞌwavu. ");
INSERT INTO mcq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ja maiꞌo Hu pahejiꞌina kaivo Na Hu hejiꞌina. Nara ijá ꞌwaraꞌipisa Na Hu pahejura ꞌiꞌipisa jara iraꞌata vejujaꞌina vejuꞌu. ꞌEnakaivo Na Hu nihene ꞌee Huni Irijaho vejura. ");
INSERT INTO mcq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Joni oma Eparahamiho Nuni veiji kahuni jihunaꞌe nihoꞌo teamama parananaꞌomo hu kamarena teamamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ꞌEjume Juapo Hu ijá ꞌwava A maiꞌo Oni juara mapoka (50) papaꞌarena kaivo ꞌú A Eparahamiho nikamane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ꞌEjume Jesu ijá ꞌiama Na nimaa nimai ja ꞌwaravu. Eparahamiho maiꞌo panahejiꞌini Na ni ijí hijuta ꞌiavume ");
INSERT INTO mcq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","pura muni ꞌeka ꞌanaꞌiro vejara kaivo Jesu Temiporu vaja kajino taname nesi pakaꞌeme puni vaja kajino va ꞌeꞌune vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hu asima ro vaꞌi kavume ea pina oahoni tei vaji rene nia supama roajaho kamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ꞌEjume Huni tisaiporuepo apoma ijá ꞌwava Najuhiꞌine ea irahuni sisei rejume hu nia supaviꞌinaꞌe nahejare? ꞌÚ ea ikehunina ho emahwapunine? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ꞌEjume Jesu eha vene ijá ꞌiama Eakaho pane ꞌee emahwaha ꞌuꞌo sisea pavejara kaivo Godira Huni haruriji ea kehuni vaji najaꞌirono avanana. ");
INSERT INTO mcq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nú Godia kaꞌene ranamiume roujihuni kaukara iviamaa vea nituma namukeno vehuna. Ijihuni maijaho naꞌia rounaꞌomo ea areri kaukaraa pavehuna. ");
INSERT INTO mcq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ꞌEnakaivo Na iki mweꞌi hijujihunaꞌe Na mweꞌa kehuni hanajiꞌina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hu ijí ꞌwaravume paarejume Hu mweꞌaki chera pisoꞌikaꞌi tanihu vaꞌume saina kaji ꞌene ea kajaho nia ꞌahi ꞌonahana. ");
INSERT INTO mcq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ꞌEꞌikaꞌi ea kajaho ijá ꞌwama Vaꞌe oni nia toa iha Sairoami soma ꞌwavume hu vaꞌe Noinsomarena nia marajume niriiꞌi kúꞌo ꞌunama roana. ");
INSERT INTO mcq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ꞌEjumakame ea kaꞌene huni rori hijajija marakoꞌa hu nia supavuꞌe hine jariraviꞌi hijuꞌe kavuraꞌomo ijá ꞌwava ꞌÚ eakaho jarisaraviꞌi hinujina raka? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ꞌEjume ea ꞌahopo ijá ꞌwava Ijaho hurana ꞌiavara. ꞌEjume vu ea ꞌahopo ijá ꞌwava Hu pana kaivo areri huaꞌina ꞌiavara. ꞌEnakaivo hu majama ijá ꞌiama Narana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ꞌEjume pu hu ijá ꞌwava A ichá vejume oni nia jaraane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ꞌEjume hu eha vene ijá ꞌiama Ea kaꞌene Jesuna ꞌwavujara saini ꞌene nuni nia ꞌahi ꞌoniꞌikaꞌi ijá ꞌwima Vaꞌe toa iha Sairoami soma ꞌwivume na vaꞌe ijí sovume maraniana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ꞌEjume pu ijá ꞌwava Hu ichihune? ꞌwavara. Hu ijá ꞌiama Na puruva reniu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ꞌEjume pu ea kaꞌene marako nia supaviꞌina kajaho apene Parasi puni roara. ");
INSERT INTO mcq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ijaho Sapati vei Jesura ea mweꞌi vejume huni nia jaraana. ");
INSERT INTO mcq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ijí Parasi kajipo kúꞌo ea kaꞌene marako nia supaviꞌina kajaho apovara. Hu icháꞌina vejume huni nia maranaji apovara. ꞌEjume hu ijá ꞌiama Hu saini ꞌene nuni nia tanihiume na vaꞌe toi somarejo nia niriuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ꞌEjume ijihunaꞌe Parasi ꞌahopo ijá ꞌwava Hu Sapati vea paakumu jihunaꞌe Godona parena roana ꞌwavara. ꞌEjume vu ea ꞌahopo ijá ꞌwava Icháꞌina ea sisea vejiꞌina aacha ijaꞌina venane? ꞌwamareja pu puruva rejumakame puni vaja kajino ahaavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ꞌEjume pu kúꞌo nia supaviꞌinijaho ijá ꞌwava Hu oni nia vejume maranaajaho a Hu irana ronane? ꞌwavume hu ijá ꞌiama Hu Poropetia rojuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jua ijí ea kaji nimarako nia supamanaꞌe vejume maranajaho pu panimaa ronareja oaheꞌo omaheꞌo ꞌumenaara. ");
INSERT INTO mcq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ꞌEjume pu ijí emahwaha aporama ijá ꞌiava ꞌÚ ike joni harihakaho nijaa nia supaviꞌina nahejare? ꞌEnakaivo hu iviamaa ichá vene nia nirio? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ꞌEjume emahwapo eha vene ijá ꞌiava Nú heju hu nuni harihakaho nijaa nia supaviꞌina nahejara. ");
INSERT INTO mcq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ꞌEnakaivo hu iviamaa icháꞌina vene nia niriajaho nú pakama pahejara. Ea irara vejume huni nia kaꞌene maranajaho nú pakavara. Hu emakinakúne apove ori ꞌwaramama ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ijaꞌina emahwapo ꞌwarava jihuni maijaho pu Jua juhama avajara. Ijihuni maijaho Juapo ika ꞌiava jihunaꞌe ea irara Keriso rone ꞌwaraꞌamajaho hu Sinakoku tanuꞌurahe pavuꞌe aruhuna ꞌiava jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ijihuni hahi emahwapo ijá ꞌiava Hu emakinakúne apoma heha ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ea kaꞌene nia marako supaviꞌiniji pu kúꞌo ijá ꞌwava Iviamai Godi a venaume maranaa jihunaꞌe a Hu taꞌaroꞌamana. Nú niheju ea kajaho sisea vejiꞌinakúna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ꞌEjume hu eha vene pu ijá ꞌiama Hu sisea vejiꞌina ho paꞌajaho na pakama pahejiꞌina. ꞌEnakaivo na hena kavujaho na nii supamiana vo na niriu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ꞌEjume pu ijá ꞌwava Hu a iraka vetaane? Hu icháꞌinaꞌe vejume oni nia jaraane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hu eha vene ijá ꞌiama Na ja niꞌwaravuta kaivo ja pahejara. Rakijihunaꞌe na kúꞌo ꞌwaraꞌejo? Ja Huni tisaiporua rehuna ura renau raka? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pu hu ira sisea ꞌwaramareja ijá ꞌwava A Huni tisaiporua kaivo nú Mosisi oni tisaiporu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Godira Mosisi ꞌwaramajaho Nú niheju. Ijí ea kajaho Hu ichihi rena roajaho nú pahejura ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ea kajara eha vene ijá ꞌiama Ja ea kajaho ichí rene roana ꞌwivuji na hejujaho nihoꞌo aniꞌinaꞌe rejuꞌe heju. ꞌEnakaivo Hu nuni nia vejume jaraiana. ");
INSERT INTO mcq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nú niheju. Godi ea kaꞌene sisea vejiꞌinijipo ꞌwaravujaho Hu pahenu kaivo ea kaꞌene Godi juhaviꞌina ꞌee Hura ura renujaꞌinaꞌe vejujipo ꞌwaravujaho Hu henu. ");
INSERT INTO mcq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nitama mweꞌakara aneja renajine ei pini ike mweꞌaki ea kaꞌene nia supaviꞌina nahenaji veje marahuna nihoꞌo paꞌamaa. ");
INSERT INTO mcq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ike eakaho Godoni parena roꞌipisa Hu unenu pina areri pavejaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ꞌEjume pu eha vene ijá ꞌwava A nihoꞌo sisea vaji nahenana kaivo a nú najuho? ꞌwaꞌikaivo hu ranavume samai vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesura henajaho pu ranavume hu samai vaꞌanaꞌe henanaꞌomo piunamarena ijá ꞌwama ꞌÚ a Emaa Puni Harihijaho nimaa rono? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ꞌEjume hu eha vene ijá ꞌwama Natohwe Hu ea irane? ꞌwariva henareje na Hu nimaa rojuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ꞌEjume Jesu ijá ꞌwama A Ea kajaho nikamanaꞌomo Hu iviamaa a huꞌúmo ꞌwaviꞌi naminu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Natohwe na nimaa nimaa roju ꞌwaꞌi kaivo hu oja mahana. ");
INSERT INTO mcq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu ijá ꞌwama Na mweꞌaki eha miꞌi routa. Ijihunaꞌe ea nia supaviꞌina nia nirihune ꞌee nia niriiꞌina veje nia supahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ꞌEjume Parasi ꞌahoꞌa ijí pu puꞌúmo ahuma namijaraꞌomo ijipo vuꞌa kaji henareja Hu ijá ꞌwava ꞌú nú nia supaviꞌina raka? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu ijá ꞌiama Ja nia supaviꞌina reꞌipisa ja sisea paꞌana rejaꞌa kaivo ja nia niriꞌina ꞌwivujihunaꞌe joni sisea majaa navu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Na nimaa nimaa ꞌwaravu. Ea irara sipi epuni vwichi paaruꞌikaivo ani ajima arihujaho hu areri nesa apejiꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ꞌEnakaivo ea kaꞌene vwichi arume vaꞌujija pu sipi ꞌajohiꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ꞌEjuꞌukame ea kaꞌene vwicha ꞌajohiꞌina kajara vwicha tirasaꞌejuꞌe hu huni sipi ihi ꞌuriha ꞌumenauꞌe pu huni ira hene kavukiviꞌi hu aherame samaumai vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ꞌEjukiviꞌi hu huni sipia irechavuꞌe usevukiviꞌi hu urane vaꞌejuꞌe huni sipia huni ira hene ꞌararihaura. ");
INSERT INTO mcq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pu nihoꞌo ea aniꞌina puni túnaꞌa paꞌararihie vaꞌura kaivo pu juhama juhaha vaꞌura. Ijihuni maijaho pu ea ꞌaniꞌinijihipuni ira paheju jihunaꞌe avajura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesura haa ikaho ꞌwaramana kaivo Hu raka kaꞌene ꞌwaramajaho pu pahejara. ");
INSERT INTO mcq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ꞌEjumakame Jesu kúꞌo ꞌwaramarena ijá ꞌiama Na nimaa nimaa ꞌwaravu Na sipia epuni vwicha. ");
INSERT INTO mcq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ea mahoꞌo kaꞌene nimaraku roajija nesa apejiꞌini jihunaꞌe sipi puni ira pahejura. ");
INSERT INTO mcq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na vwichaꞌomo ea irara roe Nuni vaji aruꞌamajaho Na hu niꞌajahuna. ꞌEjakame hu roe arume ꞌee va ꞌeꞌujiꞌi ꞌiruma piunihuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ea nesa apejiꞌinijara roujaho hu nesa apeꞌi roe ꞌee ea ꞌanie kwamasahe karokaha vehunijiru roana kaivo Na iviamaa roujaho majama hihuna apena routa. Ea nihoꞌo nimaa nimaa majama hina vahuna areri rena paranihuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na nihoꞌo sipi ꞌajohiꞌina mamaa. Sipia ꞌajohiꞌina mai huni oja sipia kajihi mihujihunaꞌe ijí sipia kajihipuni jihunaꞌe Hu kwaꞌena. ");
INSERT INTO mcq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ea hu eha apehunijiru vwihajiꞌi kaukara venujaho hu sipia paꞌajohiꞌinaꞌe ꞌee hu sipia anesura pana. ꞌEnaꞌomo ꞌua neapo roajivuꞌe kimujaho hu aseha vaꞌikaꞌi sipia irechamiuꞌe ꞌua kajipo sipia kajija mwatumiuꞌe juhaha ani ani vaꞌajivura. ");
INSERT INTO mcq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ea eha apehunijiru vwihajiꞌi kaukara venujihunaꞌe hu sipia puni oja hami pavwihanuna kaivo aseha vaꞌuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Na sipia ꞌajohiꞌina mamaa ꞌee Na Nuni sipia hena kivuꞌe pu Na hena kivura. ");
INSERT INTO mcq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Areri Amora Na hena kimujaꞌinaꞌe Na Amo hena kavuraꞌomo Na sipia punijihunaꞌe kwahuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ꞌEe Nuni sipia ꞌahoꞌa kaꞌene iki maiꞌo pahijujaho ꞌuꞌo Na aherama roakame pu Nuni ira hehuna. ꞌEjakame pu ahuma hije sipia ꞌajohiꞌina kwinu rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na Nuni haha ranave paꞌarejakaviꞌi kúꞌo ꞌunama apehuni jihunaꞌe Amo Na oja mihu. ");
INSERT INTO mcq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ei pini Na apenie vaꞌa ꞌanihuna pana kaivo Na Nuni ura ijino pu mihakame pu ꞌanihuna. Nuni harura areri namunaꞌomo Na pu mihe ꞌanihuna kaivo Nuni harura areri namujihunaꞌe Na kúꞌo ꞌunama apehuna. Ike vuꞌakaho Amounaꞌi apejuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ijí Huni vuꞌa kaji henareja Juapuni vaja kúꞌo ahaamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ea mapoka pu ijá ꞌwava Hu ꞌavena sisei ajivukame nanamu. Rakijihunaꞌe ja Huni vuꞌa hejo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ꞌEnakaivo ea ꞌahopo ijá ꞌwava Ea kaꞌene ꞌavena sisei ajimaꞌinijija vuꞌa ijaꞌina areria paꞌwaruvura. ꞌÚ ea kaꞌene ꞌavena sisei ajimaꞌinijija ea kaꞌene nia supamaꞌinijija areria venauꞌe maraniure? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ijí vea kajaho Jerusaremi sosi vea renana. ");
INSERT INTO mcq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ꞌEne atuatahuni vea reꞌeme Jesuho Temiporu kaꞌene Saramani oni ꞌurotiji ꞌurahonana. ");
INSERT INTO mcq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ꞌEꞌeme Juapo roe outihe namiꞌi kaivo ijá ꞌwava A vea icharo nú pisimúe A rane paꞌúmo? ꞌÚ A Keriso reꞌamajaho nahama samai ꞌwaruma ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ꞌEjume Jesu eha vene pu ijá ꞌiama Na ja niꞌwaravuta kaivo ja nihoꞌo panimaa roju. Uneunechaka Nara Nuni Omijihuni iha toi vejujipuhipo Na Ea iraho najahu. ");
INSERT INTO mcq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ꞌEnakaivo ja panimaa rojujihuni maijaho ja Nuni sipi paꞌajihunaꞌe avaju. ");
INSERT INTO mcq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nuni sipia Nuni ira hejura. ꞌEjuꞌe Na pu hejuꞌe pu Nuni túnaꞌi ꞌararihie ojura. ");
INSERT INTO mcq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na pu majama hihuna vajihu jihunaꞌee pu papaꞌarehuna. ꞌEe pu Nuni ija tahi hijujihunaꞌe ea ꞌahopo ꞌetujihuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ijihuni maijaho Amora pu Na vajiha jihuna. Hu nihoꞌo harura rukinaꞌomo ea pina Hu nihoꞌo paasimana. Ea kaꞌene Amoni ija tahi hijujijahija nihoꞌo ei pini areri paꞌetujahuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","31","Na Amoꞌi nikwinuna ꞌiavume Juapo muni ꞌeke kúꞌo Hu ꞌanaꞌi vejara. ");
INSERT INTO mcq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu eha vena ijá ꞌiama Amounaꞌi uneunecha mapoka mavarasaꞌi rena roume Na najahuta kaivo uné rakijihunaꞌe ja Na muni ꞌaniꞌiro vejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ꞌEjume Juapo eha vena ijá ꞌwava Nú A uneunecha mamai kaꞌene venajihunaꞌe nú muni ꞌanaꞌi vehuna pana kaivo A emaa kaivo A Godi ꞌúmujihunaꞌe avaju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu eha vena ijá ꞌiama Joni tamana vaji ikaꞌina vejara Na ja godia ꞌiavute? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Hu pu godia ꞌiaꞌamajaho Godi oni Ira pununaꞌi rena roajihunaꞌe Godi oni Ira areri paruarahuna. ");
INSERT INTO mcq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ja Ea kaꞌene Amora iji pijaharena ranavume iki mweꞌi roaji ꞌijaha avajo? Ijihuni maijaho Na Godoni Hariha ꞌiavu jihunaꞌe avajo? ");
INSERT INTO mcq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na Nuni Omijihuni kaukara paveja kiꞌavajaho ja Na panimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ꞌEnakaivo Na Huni kaukara veja kiꞌavajaho ja Na panimaa roꞌavajaho nijina kaivo kaukara mapoka kaꞌene Na vejujaho hene kimareje nimaa roꞌavara. ꞌEnareje Amoho Nuni vajine Na Amo oni vajijaho hena kiha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ꞌEjume ijihuni hahi pu kúꞌo apene ꞌanaꞌiro vejara. ꞌEnakaivo pu Hu apeꞌi vejumakiviꞌi puni vaja kaji naminu vaꞌo asitaha vaꞌume nihoꞌo pakame paapeꞌeme ꞌe vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ꞌEꞌikaivo kúꞌo vaꞌe Jotani toa ona karaꞌi ruha kaꞌene Jonira ea maraku toi samaajino vaꞌe hinana. ");
INSERT INTO mcq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ꞌEꞌeme ea mapoka Huni roara. ꞌEjiꞌi ijá ꞌwava Joni uneunecha aniꞌina ikaꞌina pavenana kaivo Jonira Ea kake rona ꞌwarumajaho nimaa nimaa ꞌúmana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ꞌEne ea mapokaka ijí hijajija nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ea pina huni iha Rasarasi hu Petani ora atami ꞌunamana. Ijaho Meriꞌo Mataꞌo puni ara. ");
INSERT INTO mcq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ijaho Meri kaꞌene Jesuni mumora senisi ꞌonahe huni húmata sapasi ꞌumaha jihuni maꞌina Rasarasi atami ꞌunamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ꞌEjume pu ea pina ranavume vaꞌe Hu ijá ꞌwama Natohwakera Hena! Oni napura kaꞌene A oja mahiꞌinijaho atami ꞌunamu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ꞌEjume Jesuho ijí henarena Hu ijá ꞌiama Hu ma atami ꞌunamunaꞌomo hu pakwahuna kaivo ijaho Godi taꞌarohe avanu. Ijara reje ea mapoka Godoni Hariha taꞌarohuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu Mataho ꞌee pokaha ꞌee Rasarasi ijá oja mihana. ");
INSERT INTO mcq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hu ijí Rasarasi atami ꞌunama kaji henarena Hu ijí kwaa kaꞌene Hu hina kaji naꞌia noꞌo huri hinana. ");
INSERT INTO mcq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ꞌEnarena Huni tisaiporu ijá ꞌiama Roe kúꞌo ꞌuname Jutia vaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ꞌEjume Huni tisaiporuepo ijá ꞌwava Najuhiꞌine ahuꞌukakaru Juapo A muni ꞌanaꞌiro saravara. ꞌEnavo ꞌú A kúꞌo ꞌuname ijí vaꞌi ꞌúmo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ꞌEjume Jesu eha vena ijá ꞌiama ꞌÚ veiriꞌa vea oma iropu ropu noꞌona raka? Ea hu veiriꞌi ꞌurahonujaho hanajukame mumora papituma ꞌohuna. Ijihuni maijaho mweꞌa kehuni irijara hanavukame hu papituma ꞌonuna. ");
INSERT INTO mcq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ꞌEnakaivo hu naꞌii vea Noinnutuma naꞌeje vaꞌipisa mumora pitumareje ꞌojaꞌa. Ijihuni maijaho irijaho huni vaja paꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ꞌEjume Hu ijá ꞌwaravume parajume Hu pu ijá ꞌiama Na iviamai vaꞌareje Nuni napura Rasarasiho nenunaꞌomo sae ꞌurihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ꞌEjume Huni tisaiporu ijá ꞌwava Natohwe hu maneꞌamajaho hu maraꞌena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesuho hu kwamaji rona ꞌwaramana kaivo Huni tisaiporu vwihajaho hu manenu rojara. ");
INSERT INTO mcq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ꞌEjumakame Jesuho pu samaumai nahama ꞌwarama ijá ꞌiama Rasarasiho nikwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na ijí pahiꞌeme hu kwamajaho Na jonijihunaꞌe nihoꞌo teamanimu. Ijihuni maijaho Nara veje marajakame ja Na nimaa rohuni jihunaꞌe avajuta. ꞌEnakúne iviamaa ꞌurije ijí huni vaꞌajiva ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi kaꞌene Titimasina ꞌwavujara tisaiporu ꞌahoꞌa ijá ꞌiama Roe vaꞌajime Hu Huꞌúmo kwamasaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ꞌEꞌejume Jesuho ijí va ꞌeꞌunajaho Rasirasi kwavume naꞌia noꞌona noꞌo ijá muna ari vaji ranavaraꞌe henana. ");
INSERT INTO mcq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petaniho Jerusaremi rorina kaivo kwaa jora pana. ");
INSERT INTO mcq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ꞌEnaꞌomo puni maꞌini kwamajihunaꞌe Jua mapoka roe Meriꞌo Mataꞌo chora kivara. ");
INSERT INTO mcq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ꞌEꞌeme Mataho Jesura rouma henarena hu vaꞌe ꞌunamutoi piunamana. ꞌEnakaivo Meriho ijí sei hinana. ");
INSERT INTO mcq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ꞌEꞌeme Mataho Jesu piuname ijá ꞌwama Natohwe A iki hiꞌipisa nuni maꞌina pakwavaꞌa. ");
INSERT INTO mcq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ꞌEnakaivo na niheju. Iviamai hu nikwamana kaivo A raka Godi jarima ꞌwaramajaho Godi A vajahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ꞌEjume Jesura hu ijá ꞌwama Oni maꞌina kúꞌo ꞌuriꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ꞌEjume Mata ijá ꞌwama Na niheju. Vea túchamaa kaꞌene ea mapoka kúꞌo ꞌuriꞌavari vea kajino hu ꞌurihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ꞌEjume Jesu ijá ꞌwama Na ea kaꞌene kwamasahiꞌina venaꞌe kúꞌo ꞌurihunijina ꞌee Na majama hihunijina. ꞌEnaꞌomo ea irara Na nimaa ronujaho hu kwahuna vo majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ꞌEnakaivo ea kaꞌene Na nimaa rojiꞌi hijujaho pu pakwamasahuna. ꞌÚ a ijaho nimaa rono? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ꞌEjume hu ijá ꞌwama Iꞌa Natohwe na nihoꞌo nimaa nimaa roju. A Keriso Godoni Harihaꞌomo A iki mweꞌi roana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ꞌEꞌeme hu ijí ꞌwaramarena ꞌurine vaꞌe pokaha Meri ꞌumenana. ꞌEne hemi ijá ꞌwama Najuhuꞌini roana. ꞌEnareꞌe Hu aaꞌe aporimu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ꞌEjume hu ijí henarena marako ꞌurine Huni vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuho maiꞌo paꞌurine ara vaꞌi kaivo ijí ruha kaꞌene Matara piunama kaji hinana. ");
INSERT INTO mcq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ꞌEꞌeme Jua kaꞌene ijí Meriꞌi puꞌúmo chora hija kajija kaꞌeme Meri ꞌurina vaꞌuma kamareja pu vwihajajaho hu muna ari vaꞌe niraꞌi ꞌahau vaꞌu roꞌi kaivo pu ꞌurine huni túnaꞌi ꞌarariha vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ꞌEꞌeme Meriho vaꞌe ruha kaꞌene Jesura hinaji vaꞌana. ꞌEne hu Jesu kamarena Huni unaꞌi nitupari samana. ꞌEꞌikaꞌi hu ijá ꞌwama Natohwe A iki hiꞌipisa nuni maꞌina pakwavaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ꞌEꞌikaivo hu niravume Jua ꞌahoꞌa kaꞌene pu puꞌúmo roajivajija ꞌuꞌo niramaruvara. ꞌEjumakamarena Hu nihoꞌo oja turaꞌi ꞌahae ꞌee oja henana. ");
INSERT INTO mcq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ꞌEjumakame Hu ijá ꞌiama Ja hu ichihi ranavare ꞌiamana. ꞌEjume pu ijá ꞌwava Natohwe roe kama ꞌwavume ");
INSERT INTO mcq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu niramana. ");
INSERT INTO mcq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ꞌEjumakame Juapo ijá ꞌwava Kaha! Hu nihoꞌo oja maha parajiꞌina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ꞌEnakaivo ea ꞌahopo ijá ꞌwava Hura ea kaꞌene nia supaviꞌinijaho vejume maranana ꞌomo Hu ea ike ꞌuꞌo veje pakwavaꞌa raka? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ꞌEjume Jesuho vu kúꞌo oja turaꞌi ꞌahaꞌeme ijí muna ara kaji roana. ꞌEnarena ijí muna ara kajaho muni tanuma namana. ");
INSERT INTO mcq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesura ijá ꞌiama Ijí muna kajaho apene ruvaha ꞌiamana. ꞌEꞌeme Mataho ea kaꞌene kwamajihuni maꞌinaꞌomo hu ijá ꞌwama Natohwe iviamai hu niamuꞌumu. Ijihuni maijaho hu naꞌia noꞌona noꞌona ijá namana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu ijá ꞌwama ꞌÚ a nimaa rojakame Godoni haruriji kahunijaho Na paꞌwaravuta raka? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ꞌEjume pu muna tahuma apene ani ruvaꞌeme Jesu Huni nia ichutoi niriꞌi siporua ꞌojiꞌi ijá ꞌwama Amo A Nuni ira henujihunaꞌe Na teamani ꞌwavu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ꞌEnaꞌomo Na niheju A naꞌia mapoka Nuni ira henuna. ꞌEnakaivo Na ike ꞌwaravu jihuni maijaho ea mapoka kaꞌene ike nuni rori namijukipo henareje A Na ranamiume rouji pu nimaa rohuni jihunaꞌe ꞌwaravu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hu ijá ꞌwarama areꞌi kaivo ira ajira ijá ꞌumena Rasarasi ꞌeꞌuna roa! ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ꞌEjume ea kaꞌene kwama kajaho ro ꞌeꞌunana. Jesu ijá ꞌiama Huni mumora ija ꞌee ateha kaꞌene tahuhahajaho ꞌee huni niuri ateha kaꞌene ranama vejajiꞌi sioꞌeje vaꞌama ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jua mapoka kaꞌene roe Meri puꞌúmo chora hija kajipo Hura rakaka vena kaji kamareja nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ꞌEnakaivo ea ꞌahoꞌa vaꞌe Parasi ijihija Jesura raka kaꞌene venaji ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ꞌEjume pirisiti mamaꞌina ꞌee Parasia ꞌee kanisorua ijipo ahuma ijá ꞌwava Nú ichá veꞌeja? Eakaho hine aacha mapoka ea areri pavejujaho venu. ");
INSERT INTO mcq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nú makaꞌeje Hu hine ijí vena apene vaꞌamajaho pu ea mahoꞌo nimaa rojakame Romu opo roareje núni ara kwaa apeꞌeja ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ꞌEnakaivo juara kajaho Kaiapasi pirisiti natohwa pinaꞌomo ijara ijá ꞌiama Ja unenuꞌu pina pahena pakaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ꞌEne ja nihoꞌo ikaꞌina pavwihaju. Ei pini nú eaka mapokakehi niꞌajúhareje kwaꞌipisa ijara núnunaꞌi mamaa rejaꞌa. ꞌEjakame nú ea mapoka areri papaꞌarehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hu ijaho huni vwiha ijiru paꞌwaramana. Ijihuni maijaho hu juara kajaho pirisiti Natohwi jihunaꞌe poropetia puni iri Jesura ea kaꞌene mapokijihi punaꞌe túnaꞌi kwahuniji rona nahama ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hu Jua punijiru pakwaꞌena kaivo kwaaka mapokaki Godoni eaka hinojujija Hu veje pu niꞌaha kwinu kachiꞌina kwinu rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ijí vea kaji rene pu Hu ꞌanaꞌirono ꞌwame amairiaravara. ");
INSERT INTO mcq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ijihunaꞌe Jesuho Jua puni vaja samaumaa paꞌurahonana. ꞌEꞌikaivo Hu vaꞌe nechiꞌi ara iha Ipiremi ijino Huni tisaiporu puꞌúmo hinana. ");
INSERT INTO mcq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Vea kaꞌene Jua puni Pasova nituꞌu rejume kame puni ea mapokaꞌe ara areꞌikaꞌi vaꞌe Jerusaremi Pasova ijihunaꞌe puni haha amairiaravara. ");
INSERT INTO mcq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ꞌEnareja pu Jesu samapene ojiꞌi Temiporu vaji namijiꞌi opuipo aposarame ijá ꞌwava ꞌÚ ja ichá vwihajo? Hu ike ahaja ijuri veakaho roꞌena ho paroꞌene? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pirisiti mamaꞌina ꞌee Parasi ijihi puꞌúmo ijá ꞌiava Ja ea ꞌahopo Hu kaꞌeje hiꞌamajaho ꞌwaruve nú Hu apeja ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesuho Pasova rehuna naꞌia iropune kwino naꞌeme Petani roana. Ijaho Rasarasi kaꞌene Jesura vejume kúꞌo ꞌurinajaho ijí hinuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ꞌEjume pu Huni ꞌiruma iꞌí vejara. ꞌEꞌeme Mataho ꞌiruma ꞌeꞌejuꞌe Rasarasiho Hu huꞌúmo ꞌaijua kaꞌene ꞌiruma ihunijino asuma hijara. ");
INSERT INTO mcq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Merira senisia kaꞌene iha Natia huni ahija monia natohwi ꞌimejara kaivo nihoꞌo mavarasaꞌina ꞌomo apene usee Jesuni mumora ꞌahi ꞌonaꞌi kaivo huni húmata sapasa kajino mumora ꞌukunahana. ꞌEjumakame senisia amua kajara sea vaja rarenana. ");
INSERT INTO mcq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Huni tisaiporu pina Jutasi Isikariati kaꞌene túnaꞌi Hu nahamahunijara ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Rakijihunaꞌe senisia kajaho paapena vaꞌe moni natohwa (K300) ꞌimene ea kaꞌene uneunecha paꞌajihijaꞌe niꞌajihe vajihunijaho avajo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ꞌEnakaivo hu ijaꞌina ꞌwarama jihuni maijaho hu ea kaꞌene uneunecha paꞌajihi vwihanie ꞌwarahuna pana kaivo hu nesa rukina ꞌee hu moni panika ꞌajohe ꞌee monia kaꞌene ijí savujaho hu nesi ꞌekuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ꞌEjume Jesu ijá ꞌwama Makama! Nara kwave ranamihuni jihunaꞌe Nuni haha amairiihe avanukúne. ");
INSERT INTO mcq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ea kaꞌene uneunecha paꞌajija naꞌia mapoka ja puꞌúmo hijura kaivo Na naꞌia mapoka pahihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesu ijí hinaji pu henareja Jua ea mapoka roara. Huhusu pana kaivo Rasarasi kaꞌene kwavume Hura vejume ꞌurina kaji kaꞌi ꞌahiume roara. ");
INSERT INTO mcq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ꞌEjume ea kaꞌene Jua puni pirisitia mamaꞌinijipo ura Rasarasi ꞌuꞌo ꞌanae kwaꞌamarono ꞌwame amairiaravara. ");
INSERT INTO mcq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ijihuni maijaho hu ꞌurina kaji henareja Jua mapoka Jesu nimaa rojumakame ijihunaꞌe ꞌanaꞌi ꞌahiara. ");
INSERT INTO mcq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ijihuni súꞌu ea mapoka kaꞌene ahaja ijume vaꞌajipo Jesura Jerusaremi rohunijaho hejara. ");
INSERT INTO mcq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ꞌEjume pu ea mapoka harajaꞌa ꞌeke ninukujaha piunaꞌi vaiꞌi ijá ꞌumeja Hosana! Kinia kaꞌene Natohwi jihuni iha ꞌahi roujaho merajahu! ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu tonikia ꞌuꞌua piuname ijihuni toi ajime hinana. Nitama Godoni irijaho ikaꞌina ꞌwarame ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Saiani ꞌapahije ja pajuha kaivo Heha! Joni Kinia iviamai tonikia ꞌuꞌua ꞌahi asuma hine rou ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Huni tisaiporu ikaho marakuꞌa pahejara kaivo Jesura kwamarena ꞌurina vaꞌeme ijiꞌa túnaꞌi pu vwihajara. Ijí uneunecha kaꞌene pura Hununaꞌi vejara ꞌee Godi oni ira vaji marako Huaꞌe rone nahama ꞌwaramajaho ijiꞌa pu vwihajara. ");
INSERT INTO mcq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ꞌEꞌeme ea mapoka vea kaꞌene Hura Rasarasi muna ari vaji naꞌeme ꞌumejume ꞌurijume ea mapoka kajipo kavaraꞌomo ijí rone ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hu Huni aacha ike najahume hejajihuna ea mapoka vaꞌe Hu piunavara. ");
INSERT INTO mcq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ꞌEnareja Parasiapo iji ꞌwamapene ojiꞌi ijá ꞌwava Ijaho ja nikavo nú unenuꞌu pina areria paveꞌejuꞌe ea mapoka Huni túnaꞌi va ranavara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kuriki ora ea ꞌahoꞌa ahaja ija kajino Godi taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ꞌEnareja pu roe Piripuho Petasaita oraꞌomo Karari vaji pu aneja vene apoma ijá ꞌwava Nú ura Jesu kaꞌi ꞌahúu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ꞌEjume Piripu roe Enituru ꞌwaravume pu noꞌo vaꞌe Jesuho ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ꞌEjume Jesu eha vene pu ijá ꞌiama Emaa Puni Harihi jihuni pinana ꞌurihuni vea niroana. ");
INSERT INTO mcq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na nimaa nimai ja ꞌwaravu. ꞌWitia ꞌina mweꞌi vaji paꞌoꞌeje naꞌavajaho manavu kaivo mweꞌi vaji ꞌonavajaho ꞌina mapoka rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ea irara huni hiiji oja maꞌamajaho hu ranave paꞌarehuna kaivo ea irara huni hia kaꞌene mweꞌi hinuji seꞌamajaho hu ꞌajoha vaꞌe majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ea irara Nuni kaukara veꞌamajaho makaꞌeje Na ꞌararihiꞌamana. ꞌEꞌirakúne kwaa kaꞌene Nara hiꞌujino hu ꞌuꞌo hiꞌamana. Ea irara Nuni kaukara veꞌamajaho Amora huni iha ꞌunama ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iviamai Nuni oja turaꞌi ꞌahiu. Na ichá ꞌwaraꞌejo? Amo vea iviamai roujaho niꞌajihe ꞌajohia Na paareꞌuta kaivo ike vea kaꞌene rou kehuni maijihunaꞌe Na routa. ");
INSERT INTO mcq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Amo veje Oni iha huni pinana ꞌurinama. Ijihunaꞌe ira kahi akúpa ꞌahi rena roa ijá ꞌwama Na Nuni iha huni pinana vejuꞌe ꞌurinunaꞌomo Na kúꞌo veje ꞌurihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ea mapoka kaꞌene ijá namijajipo hejajaho akúpi ꞌonuja renana. ꞌEjume ea ꞌahopo ꞌwavajaho Godoni ꞌona ojiꞌini Hu ꞌwaramu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ꞌEjume Jesu eha vene ijá ꞌiama Ijí ira kajaho Nunijihunaꞌe paꞌwaramu kaivo jonijihunaꞌe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Iviamaakaho vea kaꞌene mweꞌa kehuni ꞌotua vehuni vei nirenu. Iviamai mweꞌa kehuni natohwijaho piꞌonahuna vei renu. ");
INSERT INTO mcq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Vea kaꞌene ea Na apenie ichutoi ahasirimiꞌavajino Na ea mapoka aherame Nuni rohuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hu ijí ꞌwarama jihuni maijaho ꞌunama kaꞌene Hura kwahuniji rona ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ꞌEjume ea mapoka kajipo eha vene ijá ꞌwava Nú hejajaho Godoni ira ijá ꞌwarumane Keriso majama hihuna ꞌúmana kaivo A icháꞌina ꞌwarumo? Emaa Puni Hariha apena ichutoi ahasirihuna ꞌúmo? ꞌÚ ike Emaa Puni Harihijaho irane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ꞌEjume Jesu pu ijá ꞌiama Hanajiꞌinijaho ja puꞌúmo ꞌaha josuꞌa pahihuna. Iviamai hananukino ꞌurahe oꞌavara. ꞌEꞌirakúne nututijaho ja areri panaꞌiratiꞌamana. Ijihunaꞌe ea irara nutuviꞌini ꞌurahonujaho hura ꞌunama kaꞌene ichá vahunijaho puruva renu. ");
INSERT INTO mcq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hanajiꞌina iki hinukúne nimaa ronareje ja Hanajiꞌina kajihuni harihija reha. ꞌEne Jesuho uneunechakija ꞌwaramarena Hu vaꞌe tanumana. ");
INSERT INTO mcq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hu nihoꞌo aacha mapoka mapoka puni unaꞌi najahana kaivo pu panimaa rojura. ");
INSERT INTO mcq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ijihuni maijaho poropeti Aisea nitama ꞌwaramajara roe nimaaꞌe reꞌamarono ijá ꞌiama Natohwe ea irahipo núra vuꞌa kaꞌene ꞌwaravajaho nimaa rojare? A ea irahijaꞌe Natohwi jihuni harura najahane? ꞌiamana. Noin ");
INSERT INTO mcq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pu nihoꞌo panimaa rojajihuni maijaho Aisea kúꞌo ikaꞌina ꞌiama jihunaꞌe panimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Hu puni nia supamahana ꞌee Hu puni oja vejume kisimaꞌuraꞌe renana. Vejuroꞌi pu puni niiji kime ꞌee puni ojijino vwihane nimaa roje Nara veje maranihuni jihunaꞌe avajuta ꞌiamana. Noin ");
INSERT INTO mcq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisea nitama ijí ꞌwarama jihuni maijaho hu Huni pinanijaho nihena jihunaꞌe hu ijí rona ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ꞌEnakaivo ea mapoka kaꞌene ea ꞌajohaꞌina mamaꞌina pu Hu nimaa rojara kaivo pu Parasi juhamareja pu panahama ꞌwavara. Pu panahama ꞌwarava jihuni maijaho Sinakoku vaji roturihuni jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pu nihoꞌo emaapo taꞌarorahuniji oja vwihajujaho teamanamuna kaivo Godira pu taꞌarora hunijaho pavwihajura. ");
INSERT INTO mcq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ꞌEjume Jesu ajira ijá ꞌiama Ea irara Na nimaa roniujaho hu Nanaru pana kaivo Godi kaꞌene Na ranamiume rouji ꞌuꞌo nimaa ronu. ");
INSERT INTO mcq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ea irara Na kimujaho hu Godi kaꞌene Na ranamiume rouji kamu. ");
INSERT INTO mcq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na mweꞌa kehuni hanajiꞌina rena routa. ꞌEnaꞌomo ea irara Na nimaa ronujaho hu nutuviꞌina pahinuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ea irara Nara ꞌwaravujaho heꞌikaꞌi panimaa roꞌamajaho Na iviamaa hu ꞌotua pavetihuna. Ijihuni maijaho Na mweꞌakino ꞌotua veꞌi rohuna pana kaivo mweꞌake niꞌajaꞌi routa. ");
INSERT INTO mcq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ea irara Nara ꞌwaravuji pataꞌarorihe ꞌee Nuni Ira pahenihujaho ijara hu namahe ꞌotua vetihuna. Ike raka kaꞌene Nara ꞌwaravukipo vea túnaꞌi ꞌotua vetihuna. ");
INSERT INTO mcq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na Nuni vwihaijaho ja paꞌwaravu kaivo Nara raka kaꞌene ꞌwaravukaho Amo kaꞌene ranamiume Na roujara raka kaꞌene ꞌwaraꞌurono ꞌwarimaji ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na niheju. Hura raka kaꞌene ꞌwaramajara veje majama hihuna. Nara raka kaꞌene ꞌwaravujaho Amora Na ꞌwarima jaꞌinaꞌe ꞌwaravu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova vea maiꞌo paapeꞌeme Jesu henajaho Huni vea kaꞌene kúꞌo Omahoni vaꞌikaꞌi mweꞌake arehunijaho niroe apenana. ꞌEnaꞌomo Hu Huni ea Humaa kaꞌene mweꞌi hijuji oja miha apene vaꞌu vaꞌo vaꞌe ꞌurí ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pu hine ꞌiruma iꞌeme ꞌavena siseijara Jutasi Isikariatiho Saimani oni harihi jihuni oja vaji Hu nahama ꞌwarahuni vwiha niranamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Amoho uneunecha mapoka Huni ija ꞌahi irechame ꞌee Hu Godi oni rena roanaꞌomo Hu kúꞌo ꞌunama Godi oni vahunijaho nihena kamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ꞌIruma i parane ꞌurine Huni ateha jaheꞌikaꞌi taverui ꞌahi iramana. ");
INSERT INTO mcq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ꞌEnarena Hu toa tevua vaji usearena Huni tisaiporu puni mumora somahiꞌi taverua kaꞌene Hura ꞌahi iramajino sirua ꞌumahana. ");
INSERT INTO mcq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ꞌEnarena Hu Saimani Pita oni roume Pitara ijá ꞌwama ꞌÚ Natohwe A nuni mumora somiꞌena? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ꞌEjume Jesu eha vene ijá ꞌwama Nara veju kehuni maijaho a iviamaa pahenu. ꞌEnaꞌomo a túnaꞌi hena kahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ijá ꞌwama A nihoꞌo nuni mumora pasomihuna ꞌwamana. ꞌEjume Jesura eha vene hu ijá ꞌwama Na oni mumora pasomaꞌujaho a Nuni pwina pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ꞌEjume Saimani Pitara ijá ꞌwama Natohwe nuni mumoraru pana kaivo nuni ija ꞌuꞌo somihe ꞌee húmata somiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ꞌEjume Jesu hu ijá ꞌwama Ea kaꞌene toa nirúhiꞌinijija kúꞌo toa parúhura kaivo mumoraru sovura. ꞌEnakaivo ja chiha paꞌana kaivo ja ea mahoꞌo ijaꞌina pana. ");
INSERT INTO mcq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ea kaꞌene Hu nahamahunijaho Hu nihenana. Ijihunaꞌe Hu ijá ꞌiama Joni vaja kaji ea kwinuꞌwi chiha rukina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hu puni mumora somahume paꞌarejume Hu Huni ateha apúsame vaꞌe ꞌaiju ꞌahi kúꞌo asuma hijiꞌi Hu ijá ꞌiama ꞌÚ Nara raka kaꞌene vetiujaho ja nihena kavo? ");
INSERT INTO mcq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jara Na natohwa ꞌwime ꞌee Najuhiꞌina ꞌwivujaho ja nimaa ꞌwaravu Na ijaꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na joni Najahiꞌine ꞌee Natohwa. ꞌEnaꞌomo Na ja mumora somahuta. ꞌEnakúne ja ꞌuꞌo napuhu jopuni mumora somaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jara ijaꞌina veꞌavarono Na ja najaha avajuta. ꞌEnakúne ja ꞌuꞌo Nara vejujaꞌina veꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na nimaa nimai ja ꞌwaravujaho pwea huni Natohwijiꞌi areri pana. ꞌEnaꞌomo ea kaꞌene ranavuꞌe roujaho ea kaꞌene huaꞌe ranavume roajaho paasimuna. ");
INSERT INTO mcq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ja uneka kehi hena kime veꞌavajaho ja teamanahuna. ");
INSERT INTO mcq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na ja eaka mapokakaho parona ꞌwaravu kaivo Nara iji pijihujaho Na nihena kivu. ꞌEnakaivo Godoni ira vaji ikaꞌina kaꞌene ꞌwaramajara roe nimaa renu. Ea kaꞌene puretia Nunaꞌe inujara huni ateja tajahene Na ninamiana. ");
INSERT INTO mcq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ike Na iviamaa ꞌwaravukaho maiꞌo parejiꞌina. ꞌEnakúne ijara reja kaꞌavajaho Na Hurana ronareje nimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na nimaa nimai ja ꞌwaravu. Ea irara ea kaꞌene Nara irechamiuji ꞌekaꞌamajaho hu areri Na apenihu ꞌee ea irara Naaꞌe apeniꞌamajaho hu Godi kaꞌene Na ranamiume rouji apenu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu ijí ꞌwaramajino Hu oja turaꞌi ꞌahaume Hu ijá ꞌiama Na nimaa nimai ja ꞌwaravu. Ja ei pini Na nahamihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ꞌEjume Huni tisaiporua aneja vene kakaraviꞌi ijá ꞌwava Hu irá rone ꞌwarumo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Huni tisaiporua kwinu Jesura oja mahiꞌinaꞌomo hu Huni haha ꞌahi mena hinana. ");
INSERT INTO mcq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ꞌEꞌeme Saimani Pita ea kaji iji ꞌwarame ijá ꞌwama Hu ea irá rona ꞌwarumukúne a maapoma hena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ꞌEjumakame ea kaꞌene Jesuni ꞌahi mina hina kajara irana vaꞌe Jesu apoma ijá ꞌwama Natohwe ijaho ea irarane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ꞌEjume Jesu eha vene ijá ꞌiama Ea kaꞌene Nara puretia tuamareje apúsame mahunijina. Hu puretia kajaho tuame apúsame apene Jutasi Isikariati Saimani oni hariha mahana. ");
INSERT INTO mcq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hu puretia ape iꞌeme Setani hu ajimana. ꞌEjume ijihunaꞌe Jesura ijá ꞌwama A raka veꞌi ꞌahaꞌamajaho mamako vena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ea kaꞌene ꞌiruma ijuri ꞌaijua rori asuma hijajija Hu rakijihunaꞌe hu ꞌwaramajaho pu puruva retiana. ");
INSERT INTO mcq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pu ea ꞌahopo vwihajajaho Jutasira moni panika ꞌajohu jihunaꞌe pura ahaja iꞌi vejajihunaꞌe ꞌiruma ꞌimeꞌamarono ꞌwaramu rojara. ꞌEe ea kaꞌene uneunecha paꞌajihi vajihunaꞌe ꞌimeꞌamarono ꞌwaramu rojara. ");
INSERT INTO mcq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ꞌEꞌeme hu puretia kajaho ape inarena naꞌimaa naꞌeme niꞌaha kwinu samai va ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Hu maꞌahi va ꞌeꞌuꞌeme Jesu ijá ꞌiama Iviamai Emaa Puni Harihijihuni pinana ꞌuriꞌeje Godoni pinana Huni vaji ꞌurinu. ");
INSERT INTO mcq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Godoni pinana Huni vaji ꞌuriꞌamajaho Godira Jesuni pinana ꞌuꞌo veje Huni vaji ꞌurihuna. ꞌEje niꞌaha kwino Jesura Godi oni pinana ꞌunama ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sesahu Nune Na ja puꞌúmo maꞌuako hinareje vaꞌe ja Na pakima sarihuna. Nara Jua ꞌwaravu jaꞌina Na ja ꞌuꞌo ꞌwaravu. Nara vaꞌukaho ja pavuhuna. ");
INSERT INTO mcq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na tamana maiuꞌina ꞌuꞌo ja mihu. Oja maꞌaraꞌavara! Nara ja oja mihujaꞌinaꞌe ja ꞌuꞌo oja maꞌaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ꞌEjakamareje ea mapoka hena kiꞌavajaho ja Nuni tisaiporua ꞌwahuna. Ja ojono oja maꞌarava jihunaꞌe ea mapoka hene kiꞌavajaho ja Nuni tisaiporua ꞌwahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimani Pitara Hu ijá ꞌwama Natohwe A ichihi vaꞌo? ꞌwamana. ꞌEjume Jesura eha vene ijá ꞌwama Na vaꞌu kajaho a iviamaa pavuhuna kaivo túnaꞌi a ijí vuhuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ꞌEjume Pitara ijá ꞌwama Natohwe rakijihunaꞌe na iviamaa Ona pavuhune? Na nihoꞌo Onijihunaꞌe kwahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ꞌEjume Jesu ijá ꞌwama ꞌÚ a nimaa Nunijihunaꞌe kwaꞌena? Na nimaa nimaa a ꞌwaravu a ꞌaha noꞌopisu Na pakimuna ꞌiꞌeje ijí túnaꞌi ꞌuꞌora ꞌumehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Joni oja paveje turaꞌavara kaivo ja Godi nimaa rone Na ꞌuꞌo nimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nuni Omijihuni ara ruha mapoka navu. Ijaꞌina panaꞌipisa Na ijaꞌina paꞌwaravuꞌu. Na vaꞌe joni ruha amairiꞌi vaꞌu. ");
INSERT INTO mcq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na vaꞌe joni ruha amairiareje Na vukúo roe onuno ja aherama vahuna. ꞌEje Nara hiꞌujano ja ꞌuꞌo hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ꞌUnama kaꞌene Nara vaꞌuji vuhuni ꞌunamijaho ja niheju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ꞌEjume Tomasi ijá ꞌwama Natohwe Ara kwaa kaꞌene vaꞌu kajaho nú paheju. ꞌEnaꞌomo nú icháꞌina ꞌunama kajaho heꞌeja? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ꞌEjume Jesura ijá ꞌwama Na ꞌuname ꞌee nimaa nimaa ꞌee majama hihunijina. ꞌEnaꞌomo ei pini ꞌunama aniꞌina venareje Amo uni rohuna areri pana kaivo nikwisu Nuni vajaruna. ");
INSERT INTO mcq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ja Na hena kiꞌipisa ja Amo ꞌuꞌo hena kavaꞌa. Ja iviamaa Hu nikame ꞌee heju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ꞌEjume Piripura ijá ꞌwama Natohwe Amo najuha. ꞌEje ijara nú areri renuama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu hu ijá ꞌwama Piripu Na ja puꞌúmo jora hijuta kaivo rakijihunaꞌe ja maiꞌo Na pahejo? Ea kaꞌene Na kivujija Amo nikavu kaivo rakijihunaꞌe a Amo najuha ꞌwimo? ");
INSERT INTO mcq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Amoho Nuni vaji hijuꞌe Na Amoni vaji hijujaho ja panimaa rojuꞌu raka? Vuꞌa kaꞌene Nara ja ꞌwaravujaho Nuni vwihajaho pana kaivo Amo kaꞌene Nuni vaji hinujara Huni kaukara vene avanu. ");
INSERT INTO mcq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na Amo oni vaji hijuꞌe Amora Nuni vaji hinujaho nimaa roꞌavara. ꞌEnakaivo ja ike panimaa roꞌavajaho kaukara kaꞌene Nara vejujija nimaa veꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na nimaa nimai ja ꞌwaravu. Ea irara Na nimaa roniꞌamajaho kaukara raka kaꞌene Na vejujaꞌina hu ꞌuꞌo vehuna. ꞌEne kaukara kaꞌene Nara vejukija asitahareje mamaꞌina vehuna. Ijihuni maijaho Na Amo oni vaꞌujihunaꞌe ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ꞌEnaꞌomo ja raka Nuni ihi ꞌurahe jaririꞌavajaho Na vehuna. Ijihunaꞌe Amo uni pinana Hariahoni vaji ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ja uné raka Nuni ihi ꞌurahiꞌi jaririꞌavajaho Na vehuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ja oja Na miꞌavajaho ja Nuni tamana vejiꞌi hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ꞌEje Na Amo jarivakame Hura joni Niꞌajihiꞌina pina mihe Hu ja puꞌúmo majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Godoni ꞌAvena kaꞌene nimaa nimaijaho mweꞌakaho Hu nihoꞌo paapehuna. Ijihuni maijaho mweꞌakaho Godi pahene pakavu jihunaꞌe paapehuna. ꞌEnakaivo Hu ja puꞌúmo joni oja vaji hinujihunaꞌe ja Hu niheju. ");
INSERT INTO mcq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na ja ꞌoja epunaꞌi pairechamihuna vo Na joni rohuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ꞌEnakaivo Na iki maꞌuako hihuna kaivo ea kaꞌene mweꞌaki hijujija pakimamaa pakihuna kaivo ja Na kihuna. Ijihuni maijaho Na majama hijujaꞌinaꞌe ja ꞌuꞌo ijaꞌina majama hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Vea kajino ja hehuna. Na Amo oni vaji hijuꞌe ja Nuni vaji hijuꞌe Na joni vaji hiju. ");
INSERT INTO mcq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ea kaꞌene Nuni tamana hena venujaho hu Na oja miha avanana. Ea kaꞌene Na oja mihujaho Amora hu oja mahe Na ꞌuꞌo hu oja mahuna. Na icháꞌinijaho hu nahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ꞌEnaꞌomo Jutasi Isikariati pana kaivo Jutasi pinijara ijá ꞌwama Natohwe rakijihunaꞌe A icháꞌinijaho nú najuꞌi kaivo eaka mapoka kaꞌene mweꞌaki hijujaho panajaho? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ꞌEjume Jesura eha vene ijá ꞌwama Ea irara Na oja miꞌamajara Nuni ira hena vehuna. ꞌEje Amora hu oja mahuna. ꞌEje Nú huni roe pu puꞌúmo hihuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ea kaꞌene Na oja pamiꞌamajaho hu Nuni ira pahena pavehuna. Ijí ira kaꞌene ja hejakaho Nuni ira pana kaivo Amo kaꞌene Na ranamiume roujihuni ira. ");
INSERT INTO mcq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na ikijahija ja puꞌúmo iviamaa hijiꞌi ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ꞌEnakaivo joni Niꞌajihiꞌinaka Godoni ꞌAvenijaho Amora ranave Nuni iha ꞌahi roꞌamajara uneunecha mapoka najahune ꞌee Hura Nara ꞌwaravujaho veje ja vwihahuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na matauviꞌinijaho jonunaꞌi ranavu. Nuni matauviꞌinijaho Na ja mihu kaivo mweꞌakara ja vajihu jaꞌina pana. ꞌEje ja paveje joni oja turaꞌi ꞌahiꞌavara ꞌee pajuꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ja niheꞌejuꞌe Na ijá ꞌivo Na vaꞌuraꞌomo Na kúꞌo joni rohuna. Ja Na oja miꞌipisa ja teamanavaꞌa. Ijihuni maijaho Na Amo oni vaꞌu. Amoho natohwa kaivo Na Hu paasivuta. ");
INSERT INTO mcq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ijaho maiꞌo reꞌiro venu kaivo Na niꞌwaravuta. Ijihuni maijaho ijara reꞌamajaho ja kama nimaa rohuna. ");
INSERT INTO mcq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na ꞌaha josuꞌa ja puꞌúmo vuꞌa paꞌwahuna. Ijihuni maijaho mweꞌa kehuni natohwa rou. ꞌEnakaivo huni harura pina Nuni vaja paꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ꞌEnakaivo Amora ꞌwarima jaꞌina Na vejura. Ijihuni hahi mweꞌakara henujaho Na Amo oja mahu. ꞌEnakúne ꞌurija vaꞌajiva ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Na aja nimaa nimaa ꞌee Nuni Omijaho juara anesura. ");
INSERT INTO mcq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nuni anuama kaꞌene ꞌina parejajaho Hu ꞌeke atoꞌarumuna. Nuni anuama kaꞌene ꞌina rehunijija Hu hami ꞌuhue amairie ꞌajohukame ꞌina huri nihoꞌo mapoka mapoka rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nara vuꞌa kaꞌene ꞌwaravujara vejume joni mwina nipaꞌarejara. ");
INSERT INTO mcq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ja Nuni vaji hije Na joni vaji hijuma. Areri anuama kaꞌene aja ꞌaha kaji naminuji taurinaꞌipisa ꞌina parejaꞌa kaivo ijí aja ꞌaha kaji namina naꞌamajiꞌa rehuna. ꞌEnaꞌomo ja Nuni vaji hiꞌavajina vo ja ꞌina parehuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Na aja kaivo ja anuama. Ea kaꞌene Nuni vaji hije ꞌee Na huni vaji hiꞌujaho hu ꞌina mapoka rehuna. Na paꞌa ja unenu pina areri pavehuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ea irara Nuni vaji pahinujaho hu areri anuama atoꞌaruve sarasahukame nianae ꞌeke veni jauꞌe rejujaꞌina. ");
INSERT INTO mcq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ja Nuni vaji hije Nuni ira joni vaji naꞌamajaho ja raka ura renauji jaririꞌavajaho Hu jona venahuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ꞌEjakamareje ja ꞌina mapoka reꞌavajaho ijara Amo oni pinana ꞌurihuna. ꞌEꞌavajihunaꞌe ijara najaꞌamajaho ja Nuni tisaiporu. ");
INSERT INTO mcq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Areri Amora Na oja mihajaꞌinaꞌe Na ja ꞌuꞌo oja mihutakúne Nuni oja mihuri vajijino hiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ja Nuni tamana vejiꞌi hiꞌavajaho ja Nuni oja mihuri vajijino hihuna. Areri Nara Amo oni tamana hene venareꞌe Huni oja mihuri vajijino hijujaꞌinaꞌe hiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ike uneunechakija Na ja niꞌwaravu jihunaꞌe Nuni temarijaho joni vaji nahuna. ꞌEje joni temari nihoꞌo rarena parahuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ikaho Nuni tamanijina Nara ja oja mihujaꞌinaꞌe ja ea ꞌaho puꞌúmo oja maꞌaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ja napuhu jona nimaa nimaa oja miha paraꞌavajaho ja puni hahijihunaꞌe kwamasaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ja raka kaꞌene Na ꞌwaravuji veꞌavajaho ja napuhu Nuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na ja kúꞌo pwea paꞌiahuna. Ijihuni maijaho pwea huni Natohwi venujaho pakamu jihunaꞌe pahehuna. ꞌEnakaꞌi Na ja napuhu Nune ꞌiahuna. Ijihuni maijaho raka kaꞌene Amo unaꞌi hejujaho Na ja niꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ja Na iji papijihara kaivo Nara ja iji pijihuta. ꞌEne Na ja irechamiu. ꞌEnakúne ja vaꞌe ꞌina mapoka reꞌavara. ꞌEjakame joni ꞌina kajija majama hihunaꞌe reꞌavara. ꞌEꞌiraꞌomo ja Nuni ihi ꞌurahe raka Amo jariꞌavajaho Hu ja vajihuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ikija Na ja ꞌwaravukúne ea ꞌaho puꞌúmo oja maꞌaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mweꞌakaki eaka hijujipo ja senaꞌavajaho ja niheju jaꞌinaꞌe pu Na nimarakuꞌa seniva jihunaꞌe avaju. ");
INSERT INTO mcq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ja mweꞌa kehuna reꞌipisa ja hunijihunaꞌe hu ja oja mihaꞌa. Ja mweꞌa kehuni vajakino Nara ja iji pijihe ꞌekauta. Ijihunaꞌe mweꞌakaho ja senavu. ");
INSERT INTO mcq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nara vuꞌa kaꞌene ꞌwaravujaho vwihaꞌavara. Pwea huni Natohwijiꞌi areria pana. Pu Na sisei ꞌahia jaꞌinaꞌe ja ꞌuꞌo sisei ꞌahihuna. ꞌEnakaivo pu Nuni ira hena vejajija joni ira hena vehuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ꞌEnakaivo Nuni ihijihunaꞌe pu ijaꞌina ꞌahihuna. Ijihuni maijaho pu Godi kaꞌene Na ranamiume roujaho paheju jihunaꞌe avahuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na paroareje pu paꞌwaraꞌipisa pu sisea pavejaꞌa. ꞌEnakaivo iviamai pu puni sisea areri pavahahuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ea kaꞌene Na semujaho hu Nuni Omiji ꞌuꞌo semuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na puni unaꞌi ike ea areri pavehuni jaꞌina kaꞌene vejujaho Na ijaꞌina paveꞌipisa pu sisea pavejaꞌa. ꞌEnakaivo pu kiꞌeme Na ijí vejujihunaꞌe pu Na sename ꞌee Nuni Omiji ꞌuꞌo senavu. ");
INSERT INTO mcq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pu ikaꞌina kaꞌene vejajihuni maijaho Godi oni ira vaji ꞌwaramajara roe nimaa reꞌamarono aranana. Ijaho ikaꞌinaꞌe ꞌwaramana Pu Na vuꞌa paꞌa senamana. ");
INSERT INTO mcq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ꞌEnakaivo joni Niꞌajihiꞌina kaꞌene Nara Amo unaꞌi rene ranave roꞌamajaho Godoni ꞌAvena kaꞌene nimaijina. Hu Amo unaꞌi rena rohuni jihunaꞌe Hu Na rone ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ꞌEje ja ꞌuꞌo Na rone ea ꞌahoꞌa najahuni jihuni maijaho ja nú puꞌúmo kami aneji rene hina apene roajihunaꞌe najahuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Na uneunechakija ja ꞌwaravu jihunaꞌe ja ani paruvaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pu ja Sinakoku vaja roturihuna. Vea nituma rounaꞌomo rosaꞌeje ea irara ja ꞌaniꞌamajara vwihaꞌamajaho hu Godoni kaukaraꞌe vene avanu roꞌena. ");
INSERT INTO mcq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pu Amo pahena kame Na pahena pakivu jihunaꞌe pu ja ijá ꞌahihuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ꞌEnakaivo Na uneunechake ja ꞌwaravu jihunaꞌe puni vei roꞌamajaho pu ijá vehuna. ꞌEjakamareje ja Nara ꞌwaravukaho vwihahuna. Na anejijaho uneunechaka ja paꞌwaravuta. Ijihuni maijaho Na ja puꞌúmo hijujihunaꞌe avajuta. ");
INSERT INTO mcq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ꞌEnakaivo Na iviamaa Godi kaꞌene Na ranamiume roujihuni vaꞌu. ꞌEjuꞌe ja ea pina A ichihi vaꞌo? paꞌwivu. ");
INSERT INTO mcq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ꞌEnakaivo Na uneunechakihi ja ꞌwaravu jihunaꞌe joni oja vaja temuki rarenu. ");
INSERT INTO mcq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na ja nimaa ꞌwaravu. Ja maranihuni jihunaꞌe vaꞌu. Ijihuni maijaho Nara pavaꞌujaho joni Niꞌajihiꞌina parohuna. ꞌEnakaivo Na vaꞌujaho Na Hu ranave joni rohuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hura roꞌamajaho Hura vejakame mweꞌa kehuni ea pu sisei jihuni maa hehuna ꞌee arira maijaho hehune ꞌee ꞌotua vehuni ꞌunamijaho hehuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sisea puniji najahuni jihuni maijaho pu Na panimaa rojura. ");
INSERT INTO mcq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Arimaiji najahuni jihuni maijaho Na Amo oni vaꞌuraꞌomo ja Na kúꞌo pakihuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ꞌOtua vehuniji najahuni jihuni maijaho mweꞌa kehuni natohwijaho niꞌotua vetiara. ");
INSERT INTO mcq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na uneunecha mapoka ꞌwarahuna ura reniu kaivo ja iviamaa areria paꞌekahuni jihunaꞌe paꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Godoni ꞌAvena kaꞌene nimaa nimai ijara roꞌamajaho Hura nimaa nimai jihunijaho mahoꞌo najahuna. ꞌEe Hu Huni vwiha ijaho paꞌwarahuna kaivo raka kaꞌene Hu henujiru ꞌwarame ꞌee raka kaꞌene maiꞌo rehuniji najahuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hu Nara raka kaꞌene naꞌuji ꞌeke ja ꞌwaraꞌama jihunaꞌe Nuni pinana ꞌurihuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Uneunecha mahoꞌo kaꞌene Amo Onijaho Nuna. Ijihuni hahi raka kaꞌene Nunijija Hu ꞌeke ja najahuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ꞌAha josu pareꞌeje ja Na pakihuna. ꞌEnareje kúꞌo ꞌaha josuꞌa pareꞌeje ja Na kihuna. Ijihuni maijaho Na Amo oni vaꞌujihunaꞌe ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ꞌEjume Huni tisaiporu ꞌahopo ꞌahoꞌa ijá ꞌiava Hu ꞌwarumu kajihuni maijaho irake? Na ꞌaha josuꞌa pareꞌeje ja Na pakihuna. ꞌEnareje ꞌaha josuꞌa pareꞌeje kúꞌo ja Na kihuna. Ijihuni maijaho Na Amo oni vaꞌujihunaꞌe ꞌwaravu ꞌúmujaho rakijihunaꞌe ꞌwarumo? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ꞌEjume pu ijá ꞌwava ꞌÚ ikaho irakaꞌe rone ꞌwarumo? Ikaho irakaꞌe rone ꞌaha josuna ꞌúmo? Hura raka kaꞌene rona ꞌwarumujaho nú puruva renu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu kimajaho pu Hu apohuna kimarena Hu pu ijá ꞌiama Na ijá ꞌiavuta Na ꞌaha josuꞌa paꞌareꞌeje ja Na pakihuna. ꞌEnareje ꞌaha josuꞌa paꞌareꞌeje ja kúꞌo Na kihuna ꞌiavuta. ꞌEnaꞌomo ijí ja hina aposaravu raka? ");
INSERT INTO mcq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na ja nimaa nimaa ꞌwaravu. Ja niramarume hine ꞌúchia ꞌehuna. ꞌEꞌeje mweꞌakaho hu mariꞌuhuna. ꞌEꞌeje ja nihoꞌo temukama paranihuna. ꞌEnakaivo joni temuka kajaho taꞌarohe temaraꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Napari vea kaꞌene hariha naheꞌi venujaho hu nihoꞌo haha hiamuna. Ijihuni maijaho hu vea kaꞌene haha hihunijara roukame avanuna. Hu hariha nahejuꞌe paꞌarenujaho hura haha kaꞌene hiamajaho pavwihanuna kaivo hariha kaꞌene hura nahejume ikino mweꞌi roajihunaꞌe temaranuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ijihuni hahi ja iviamaa ijaꞌina temukamu. ꞌEnakaivo Na ja kúꞌo kive joni oja sonahihuna. ꞌEje ea pina joni vaji temara ijaho paapena ruvahuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ijí vea kajaho ja Na unenuꞌu pina paaporihuna. Na nimaa nimai ja ꞌwaravu. Ja unenuꞌu ꞌahoꞌaꞌe Nuni ihi ꞌurahiꞌi Amo jariꞌavajaho Hu vajihuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ja marakoꞌa unenuꞌu pina Nuni iha paꞌurahiꞌi jaririvara. ꞌEnaꞌomo ja jaririvakame Na vajihuna. ꞌEje joni vaja temari nihoꞌo rarena parahuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Na uneunecha ikijahija ja hai ꞌwaravu kaivo vea maiꞌo rounaꞌomo rosaꞌeje Na kúꞌo ja haa paꞌwarahuna kaivo Na Amo oni vuꞌa samaumai ja ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ijí vea kajara roꞌamajaho ja Nuni ihi ꞌahi jarihuna. ꞌEnakaivo Na ja ikaꞌina paꞌiavu Nara Amo jonijihunaꞌe ꞌwarahuna paꞌiavu. ");
INSERT INTO mcq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Amora ja oja mihu. Ijihuni maijaho ja Na oja mihe ꞌee nimaa rojujaho Na Amo oni rena routa. ");
INSERT INTO mcq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na kahi Amo oni rena roe iki mweꞌi routa. ꞌEnaꞌomo Na iviamai ike mweꞌakaho areme kúꞌo kahi Amo oni vaꞌu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ꞌEjume Huni tisaiporu ijá ꞌwava Hena! A iviamaa haa paꞌwaruꞌikaꞌi samaumai ꞌwarumu. ");
INSERT INTO mcq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nú iviamaa heju. A uneunecha mahoꞌo nihe parana jihunaꞌe ei pini unenuꞌu pina Aaꞌe aporahuna areria paꞌana. Nú ike henareꞌe A Godoni rena roaji nimaa roju ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ꞌEjume Jesu eha vene pu ijá ꞌiama ꞌÚ ja iviamaa nimaa rojo? ");
INSERT INTO mcq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Heha! Vea muka kaꞌene roujaho iviamaa niro ꞌeꞌunana. Ijihunaꞌe ja ea mapoka niꞌaha kwinu juhahe ani ani joni ara aneji va ranahuna kaivo ja Nanasu piranamihuna kaivo Na Nanasu pahihuna. Ijihuni maijaho Amora nú huꞌúmuna. ");
INSERT INTO mcq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na uneunecha mapoka ikija ja niꞌwaravu jihunaꞌe ja Nuni vaji matauviꞌina apehuna. Ja iki mweꞌi hijujaho ja sisei hiju kaivo ata kairasaꞌavara. Ijihuni maijaho mweꞌakaho Nara ni asivuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu uneunechake ꞌwaravume paarejume Hu nia ahasirime akúpi ꞌahi niriꞌi ijá ꞌwama Amo vea niroukúne A veje Harihu puni pinana ꞌurinama. Harihuni vejuꞌe Oni pinana ꞌurinukúne. ");
INSERT INTO mcq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A Hu harura ea mapoka asitahuna mahana. ꞌEnajihunaꞌe A ea kaꞌene Hu vajahajija Hu pu majama hihuna mihuna. ");
INSERT INTO mcq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ikaho majama hihunijina. Pu A Godi kaꞌene nikwinuꞌwi nimaa nimaiji hena kame ꞌee Jesu Keriso kaꞌene Ara ranavume roaji hena kahuna. ");
INSERT INTO mcq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na iki mweꞌi kaukara kaꞌene A mihajaho nive paraju jihunaꞌe Oni pinana natohwa ꞌurinu. ");
INSERT INTO mcq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ꞌEnakúne Amo veje Nuni pinana natohwa ꞌurinama. Nú noꞌo nitama mweꞌakaho paꞌajiri vejume Nuni pinana ꞌurina jaꞌinaꞌe ꞌurinama. ");
INSERT INTO mcq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ea kaꞌene Ara Na mweꞌi vajihajija Na A rone pu najahuta. Pu Oni ea kaivo A Na vajihajija pu Oni ira hena veju. ");
INSERT INTO mcq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pu iviamaa niheju. Uneunecha kaꞌene A vajihajaho Oni rene roara. ");
INSERT INTO mcq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ara Oni ira kaꞌene Na vajihajija Na pu ꞌwaravuꞌe pu hena vejara. ꞌEne pu ijí hejujaho nimaa nimaa Na Oni rena routa. ꞌEe Ara Na ranamiume roujaho pu nimaa nimaa roju. ");
INSERT INTO mcq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na puni siporua ꞌoju kaivo Na mweꞌa kehuna paꞌoju. Ea kaꞌene A Na vajiha jihipunaꞌe ꞌoju. Ijihuni maijaho pu Oni eijihunaꞌe Na puni siporua ꞌoju. ");
INSERT INTO mcq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nunijijahija mahoꞌo One ꞌee Onijijahija mahoꞌo Nuna. Ijihunaꞌe pura vejuꞌe Nuni pinana ꞌurinu. ");
INSERT INTO mcq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na iviamaa mweꞌakaho kúꞌo pahihuna. ꞌEnakaivo pu pupuso iki mweꞌi hiꞌejuꞌe Na Oni vuꞌu. Amo arimai ea kaꞌene Ara vajihajija Oni iha ꞌahi hami ꞌajohaꞌamana. ꞌEjakame Nú nikwinuꞌini jaꞌinaꞌe pu ꞌuꞌo nikwinuꞌwi reja. ");
INSERT INTO mcq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na pu puꞌúmo hijuti veijino Na Oni iha ꞌahi pu ꞌajohauta. Ea kaꞌene Ara vajihajija Na pu hami ꞌajohauta. ꞌEjume ea pina nihoꞌo paranamia vaꞌana kaivo ea kwinuꞌwi sisemaa ijara vaꞌume paꞌarenana ꞌEjume Godoni irijarahara ꞌwaramajaho ro nimaaꞌe renana. ");
INSERT INTO mcq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ꞌEnakaivo Na iviamaa Oni vuꞌu. Vuꞌa ikejahija Na iki mweꞌi ꞌwaravu jihunaꞌe puni vajijaho Nú temarijara rarena parahuna. ");
INSERT INTO mcq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na Oni ira pu niꞌwaravuta. Ijihuni hahi mweꞌakaho pu senamu. Ijihuni maijaho pu mweꞌa kehuna pana. ꞌEne Na ꞌuꞌo areri mweꞌa kehuna pana. ");
INSERT INTO mcq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A mweꞌakino pu ꞌeka ani vahuna paꞌwaravu kaivo ꞌavena sisei ruaraꞌenakúne ꞌajohaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Areria Na mweꞌa kehuna pana. Ijaꞌina pu ꞌuꞌo mweꞌa kehuna pana. ");
INSERT INTO mcq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Oni ira nimaakúne A Oni ira apena venaꞌe pu ea arira reꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ara Na ranamiume Na iki mweꞌi roujaꞌinaꞌe Na pu ꞌuꞌo mweꞌa ikino irechamiu. ");
INSERT INTO mcq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Puni hahijihunaꞌe Na Nuni haha pu mihuta. Ijihuni maijaho Oni ira kaꞌene nimaijino veje pu ea arira reꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na punaru siporua paꞌoju kaivo pura raka kaꞌene ꞌwarave ea ꞌahopo hene Na nimaa ronihunijihipuna ꞌuꞌo ꞌoju. ");
INSERT INTO mcq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ꞌEnajihunaꞌe Na siporua ꞌojukúne pu mahoꞌo nikwinu reꞌavara. Amo pu nikwinu nú puꞌúmo reꞌavara. Areri Ara Nuni vaji hijuꞌe Nara Oni vaji hijujaꞌinaꞌe pu ꞌuꞌo Núni vaji hihuna. ꞌEjakame mweꞌakaho Ara Na ranamiume rouji nimaa roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ara pinana kaꞌene mihajaho Na pu nimihuta. ꞌEnajihunaꞌe pu nikwinu rehuna. Areri nú nikwinuꞌina rejajaꞌinaꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na puni vaji hijuꞌe A Nuni vaji hinu. ꞌEjukame pu nihoꞌo nikwinu rena paraꞌavara. ꞌEjakame mweꞌakaho Ara Na ranamie ꞌee oja kaꞌene Na mihajaꞌinaꞌe A pu ꞌuꞌo oja mihujaho pu hena kaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Amo A pu Na vajihajaho Nara hiꞌujino pu ꞌuꞌo hihuna ura reniu. ꞌEjakame pu Nuni pinana kaꞌene Ara mihajaho kaꞌavara. Nitama mweꞌakaho maiꞌo pavejajiri A oja mihana. ");
INSERT INTO mcq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Amo A arimaa mweꞌakaho A pahena pakamu kaivo Na A nihene kavura. Ara Na ranamiume roujaho ea ikipo niheju. ");
INSERT INTO mcq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na A icháꞌinijaho pu najahuta. Na majama A rone najaha apena vahuni jihunaꞌe Ara Na oja kaꞌene mihajaho puni vaja nave Na puni vaji hiuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu ikaho ꞌwaravume paꞌarejume Hu ꞌurine vaꞌe Kitironi isoha ona karaꞌi juasiꞌaꞌomo Huni tisaiporue puꞌúmo ijí vaꞌara. Noin ");
INSERT INTO mcq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jutasi kaꞌene Hua nahamahunijaho hu ruha kajaho nihena kamuna. Ijihuni maijaho Jesu naꞌia mapoka Huni tisaiporu puꞌúmo ijí vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pirisiti mamaꞌina ꞌee Parasi ijipo Jutasi Romu puni sorutia ꞌee hirisima vajahume aherame naheha ꞌee tosia ꞌee juha hajaa vene roara. ");
INSERT INTO mcq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ꞌEjumakame Jesu uneunecha mahoꞌo kaꞌene Hu reꞌiro vejajaho nihenana. ꞌEnarena Hu ro ꞌeꞌune vaꞌe pu ijá ꞌiama Ja irá savo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ꞌEjume pu eha vene Hu ijá ꞌwava Jesu kaꞌene Nasareti ora nú savu ꞌwavara. ꞌEjume Hu ijá ꞌiama Ijaho Nana ꞌiamana. ꞌEjume Jutasi kaꞌene Hu nahama ꞌwaramajaho pu puꞌúmo naminana. ");
INSERT INTO mcq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ꞌEjume Jesu ijá ꞌiama Ijaho Nana ꞌiavume pu henarame hiruꞌoꞌusaha kahakaro vaꞌikaꞌi mweꞌi arihara. ");
INSERT INTO mcq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesu Hu kúꞌo aporama ijá ꞌiama Ja irá sama ojo? ꞌiamana. ꞌEjume pu ijá ꞌwava Jesu kaꞌene Nasareti orijina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu eha vene ijá ꞌiama Na Huna ꞌiamana. ꞌEnajihunaꞌe ja Na sariꞌavajaho eakija irechamie vaꞌa ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Godoni iri nitama marako ꞌwaramajaho iviamaa roe nimaa renu ꞌwaꞌikaꞌi ijá ꞌwama Ara ea kaꞌene Na vajihajijahija pina ani ani pavaꞌara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimani Pita soꞌwa rukinaꞌomo Marakasiho pirisiti natohwijihuni pweaꞌomo soꞌwi ꞌanaume manaꞌinijaꞌi ataa ꞌuhuꞌusunahana. ");
INSERT INTO mcq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ꞌEjume Jesura Pita ijá ꞌwama Oni soꞌwa suta vaji ranama. ꞌÚ Na kapusia kaꞌene Amora mihajaho paiꞌejo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Romu puni sorutia ꞌee puni mamaꞌina ꞌee Jua puni hirisimapo Jesuho ꞌuname ija kamovara. ");
INSERT INTO mcq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Marakoꞌa pu Hu apena vaꞌe Anasi oni vaꞌara. Ijihuni maijaho Anasiho Kaiapasi oni jurijihunaꞌe. Juara kajihuni vajijaho Kaiapasira pirisiti niꞌina renana. ");
INSERT INTO mcq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapasiho ea kaꞌene Jua ea mapoka marakoꞌa ika ꞌwaramajina Ea kwinu ea mapoka punijihunaꞌe kwahuna. Ijaho nihoꞌo mamaa vena avahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimani Pita kaivo tisaiporu pinaꞌi Jesu ꞌararihae vaꞌara. Tisaiporu pina kajaho pirisiti natohwijaho hu nihena kaviꞌinaꞌomo hu Jesuꞌi ahuma vaꞌe pirisiti natohwijihuni sei vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ꞌEꞌeme Pitaho vwicha jiami namiꞌeme tisaiporu pina kajaho pirisiti niꞌinijaho hena kaviꞌina ꞌomo hu Pita ahema roꞌirono napara kaꞌene vwicha ꞌajohajaho ꞌwaraꞌikaꞌi ahema vaji roana. ");
INSERT INTO mcq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ꞌEjume napara kaꞌene vwicha ꞌajohajara Pitaho ijá ꞌwama ꞌÚ a ea karehuni tisaiporu pina raka? ꞌwamana. ꞌEjume hu napara kajaho ijá ꞌwama Na pana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ꞌEꞌeme pwea ꞌee hirisima ꞌahoꞌa atuatavume vena jae iruhe hijara. ꞌEꞌeme Pita ꞌuꞌo ijí pu puꞌúmo namine vena iruana. ");
INSERT INTO mcq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pirisiti niꞌinijara Jesuni pwehija rone Jesu apome ꞌee Hura raka kaꞌene najahuji rone apomana. ");
INSERT INTO mcq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ꞌEjume Jesu hu eha vene ijá ꞌwama Na samaumai ea mapoka vuꞌa ꞌwaravuta. Sinakoku ꞌee Temiporu vaji Jua ahuma hiꞌejuꞌe Na najahura. Na nihoꞌo vuꞌa pina nesa paꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ꞌEnakaivo rakijihunaꞌe a Na aporimo? Ea kaꞌene Na ꞌwaraꞌejuꞌe hejujihijaꞌe aporame hena. Na raka kaꞌene ꞌwaravujaho pu nihejura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hu ijá ꞌwaraꞌeme hirisima kwino Jesuni rori naminanaꞌomo ijara Hu tahijahiꞌi ijá ꞌwama ꞌÚ ꞌunama ijaꞌina pirisiti niꞌinijaho ꞌwaraꞌeja? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ꞌEjume Jesu ijá ꞌwama Na vuꞌa sisea ꞌwaravuta reꞌamajaho a iviꞌa kúꞌo ꞌwariva hejuma. ꞌEnakaivo Na vuꞌa maa ꞌwaravuta reꞌamajaho a ichá vene ꞌanio? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ꞌEjume Anasira Hu kamoma ranavume Kaiapasi pirisitia niꞌini jihuni vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimani Pitaho vena irua namiꞌeme pu ijá ꞌwava ꞌÚ a Huni tisaiporu pina raka? ꞌwavara. ꞌEjume hu hema ijá ꞌwama Na nihoꞌo pana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pirisiti niꞌini jihuni pwea kaꞌene Pitara ꞌanaume ataa ꞌuhuꞌusunaha jihuni ea pini ijá ꞌwama ꞌÚ a Hu huꞌúmo juasiꞌi kavute? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ꞌEjume Pita kúꞌo heꞌeme niꞌaha kwino ꞌuꞌora ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Súꞌu vea kaꞌene uka ꞌumenajino pu Jesuho apene Kaiapasi oni sei vaꞌe ꞌotua vejuri sei vaꞌara. Jua pu ꞌotua vejuri sea vaja pavaꞌara kaivo maꞌahi namijara. Ijihuni maijaho pu puni tamana ruarahareje Pasovaꞌe paihuni jihunaꞌe ꞌotua vejuri sea pava aruvara. ");
INSERT INTO mcq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ꞌEjume Pairatira vaꞌe pu ijá ꞌiama Eakaho irakaꞌe ja namahareja apene roare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pu eha vene hu ijá ꞌwava Ea ikaho Hu sisea pavejiꞌina reꞌipisa nú ijaꞌina paapena roa mahaꞌa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ꞌEjume Pairati ijá ꞌiama Ja joni tamani jihuni ꞌunamijino Hu ꞌotua vetiꞌavara ꞌiamana. ꞌEjume Jua kajipo ijá ꞌwava Varapi jihunaꞌe nú ea paꞌanie kwamasahuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ꞌEnajihunaꞌe Jesura icháꞌinaꞌe kwahuna kaꞌene nimarako ꞌwaramajara roe nimaaꞌe renana. ");
INSERT INTO mcq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ꞌEjume Pairati kúꞌo ꞌunama vaꞌe ꞌotua vejuri ari vaꞌe Jesu ꞌumena ijá ꞌwama ꞌÚ A Jua puni Kinie? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ꞌEjume Jesu eha vene ijá ꞌwama ꞌÚ a ikaho oni vwihai vwihana ꞌwarimu ꞌuho ea ꞌahopo Na rone ꞌwaravaraꞌe ꞌwarimo? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pairati eha vene ijá ꞌwama ꞌÚ na Jue? Oni ehija ꞌee pirisitia mamaꞌinijipo A apene roe na mihara. Ijaho A raka vejumakame pu A apena roe na mihare? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ꞌEjume Jesu eha vene ijá ꞌwama Nuni ara kwaa ikaho mweꞌa pana. Nuni ara kwaa iki mweꞌi reꞌipisa Nuni pwehija pu areri ajira vejaꞌa. ꞌEjakamareje pu Juakija Na nihoꞌo paapeniaꞌa. ꞌEnakaivo Nuni ara kwaa ikaho panamu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ꞌEjume Pairati Hu ijá ꞌwama ꞌÚ A Kinie? ꞌwavume Jesu ijá ꞌwama A Na Kinia ꞌwimujaho Na ijí rehunaꞌe naheniara. ꞌEe ijihunaꞌe Na iki mweꞌi routa. Na iki roujihuni maijaho ea mapoka kaꞌene iki mweꞌi hijujihijaꞌe raka kaꞌene nimaa nimaiji ꞌwaraꞌiro routa. Ea kaꞌene nimaijihunijija Nuni ira hejura ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ꞌEjume Pairati Hu ijá ꞌwama Nimaa nimaijaho irake? ꞌwaꞌikaꞌi hu ꞌuroti vaꞌe Jua kúꞌo ijá ꞌiama Na Ea ikehuni vaja sisea pina pakavu. ");
INSERT INTO mcq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ꞌEnakaivo joni tamana ja Pasova vea rejuꞌukiviꞌi na ea kaꞌene tipura hijujaho pina ranavuꞌe vaꞌura. ꞌEnaꞌomo na Eake Jua puni Kinia ranahuna ja ura renao? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ꞌEjume pu ira ajira ijá ꞌumeja Ea kajaho pana vo Parapasi ranama ꞌumejara. ꞌEnavo Parapasiho hu nesa apejiꞌinijina. ");
INSERT INTO mcq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pairatira Jesuho apene hijahana. ");
INSERT INTO mcq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ꞌEꞌeme sorutiapo ꞌwiji ehimapi Huni húmata ꞌahi apúsamahara. ꞌEne pu kini epuni ateha mavarasaꞌina aviꞌini apúsamahara. ");
INSERT INTO mcq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ꞌEnareja pu ꞌijahe ꞌajoma ijá ꞌwava Esi A Jua puni Kinia ꞌwavara. ꞌEjiꞌi puni iji varinu tahijahara. ");
INSERT INTO mcq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hu Pairati kúꞌo ꞌuroti roe pu ijá ꞌiama Heha! Na Hu ahema roujihuni maijaho na Huni vaja sisea pina pakama ahema rou ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ꞌEꞌejume Jesuho ꞌwija ꞌee ateha aviꞌina kaꞌene samahajiꞌi roe ꞌuroti samai ꞌeꞌunana. ꞌEꞌeme Pairati ijá ꞌiama Eake kaha! ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ꞌEjume pirisitia mamaꞌina ꞌee Jua puni hirisima pu Hu kaviꞌi ijá ꞌumeja Icha ꞌahi ꞌanaa! Icha ꞌahi ꞌanaa! ꞌumejara. ꞌEnakaivo Pairatira ijá ꞌiama Na Huni sisea pina pakavukúne jara ojono apena vaꞌe icha ꞌahi ꞌanaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ꞌEjume Juapo eha vene hu ijá ꞌwava Núni tamana ikaꞌina ijihunaꞌe núni tamanijara ꞌwaramu jaꞌinaꞌe Hu kwahuna. Ijihuni maijaho Hu Godoni Hariha ꞌúmujihunaꞌe nú Hu ꞌanaa kwahuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ꞌEjume Pairatiho ijí vuꞌa kaji henarena nihoꞌo tea juma paranana. ");
INSERT INTO mcq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ꞌEꞌikaꞌi hu kúꞌo ꞌotua vejuri sei vaꞌe arume Jesuho apoma ijá ꞌwama A ichi rena roane? ꞌwamana kaivo Jesuho huni eha pavenana. ");
INSERT INTO mcq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pairati ijá ꞌwama A irakijihunaꞌe na paꞌwarimo? Nuni harura namunaꞌomo na areri A ranamae vahuna ho na A icha ꞌahi ꞌanahunijaho A paheno? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ꞌEjume Jesu eha vene hu ijá ꞌwama A maiꞌo Nuni harura areri paasimana kaivo Godira a harura maꞌamajiana vo a Nuni harura paasimana. Ea kaꞌene Na apenie roe a mahajija pu sisea niꞌimaꞌura vejara ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pairati ijí henarena ꞌunama same Hu ranaꞌiro venana. ꞌEnakaivo Juapo ijá ꞌumeja A eake ranave vaꞌamajaho a Sisa oni napura parehuna. Ea irara oriꞌini hu kinia ꞌiamujaho Sisaꞌi ninakarame avanu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pairati heꞌeme pu ijí ꞌwaravume henarena Jesuho apena roe maꞌahi ꞌotua vejuri ruhi ranaꞌikaꞌi hu asuma hiꞌeme Jesu huni unaꞌi naminana. Ijí ruha kajaho Hipuru puni iri Kapata ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Vea kaꞌene Pasova amairiaravari vea kaji veiriꞌi hu Jua ijá ꞌiama Joni Kinia kaha! ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ꞌEjume pu ira ajira ijá ꞌumeja Hu apena vaꞌa! Hu apena vaꞌa! Icha ꞌahi ꞌanaa! ꞌumejara. ꞌEjume Pairati ijá ꞌiama Ja ura na joni Kinia icha ꞌahi ꞌanaꞌejo? ꞌiamana. ꞌEjume pirisitia mamaꞌinijipo eha vene ijá ꞌumeja Nú kinia pana vo Sisarana ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ꞌEjume hu Hu apene icha ꞌahi ꞌanaꞌavarono mihana. ");
INSERT INTO mcq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ꞌEjume pu Hu ahema va usevume Jesu ichaka Hu ꞌanahunijaho tapana vaꞌe kwaa iha Korukata ꞌwavuji vaꞌana. Ijaho Hipuru puni iri Húmata Ata ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pu ijí Hu icha ꞌahi ꞌanaara. ꞌEne ea noꞌoheꞌi pina ronuꞌi ꞌanae pina ꞌuꞌo ronuꞌi ꞌanaara kaivo Jesuho riri ꞌanaara. ");
INSERT INTO mcq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ꞌEꞌeme Pairati asura ira ikaꞌina vene korosia huri ꞌananamana Jesu Nasareti Ora Jua Puni Kinia ꞌwame venana. ");
INSERT INTO mcq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Asura kaꞌene hura venajaho Hipuru Ratini ꞌee Kuriki puni iri venana. ꞌEnavo kwaa kaꞌene Jesu ꞌanaajaho ara natohwa rorinaꞌomo Jua mapoka vaiꞌi asura kajaho kama tahiꞌi vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ꞌEnareja Jua puni pirisitia mamaꞌinijipo Pairati ijá ꞌwava A Jua puni Kinia venujaho arema kaivo Hura Na Jua puni Kinia ꞌiamanakúne ijihuni toi veꞌamana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ꞌEjume Pairati ijá ꞌiama Raka kaꞌene nara vejujaho na nivejume paꞌarenana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sorutia mapoka Jesu icha ꞌahi ꞌanaume paꞌarejume sorutia Huni ateha jahene ahaame nia noꞌona noꞌo irechavara. Areri sorutia kwinu kwino ea noꞌona noꞌo ijá ꞌekahunaꞌe irechame ꞌee Huni ateha mamaa kaꞌene huri apúsamonujaho pasuhara kaivo iji kahi rene hwena vaꞌe kami usevara. ");
INSERT INTO mcq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ijí pu ijá ꞌwava Roe nú Huni atehakaho paisova kaivo roe pipi vene kava. Ea irara mai apeꞌamajaho hura apeꞌenakúne ꞌwavara. Ijí veja kajaho Godoni Ira nitama ijá ꞌwaramajaho nimaa renana. Pu Nuni ateha ꞌeke ahaame vajúsarahuna. ꞌEne Nuni ateha apene pipi vehuna ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ꞌEjume sorutiapo uneunechakija vejara. ꞌEnakaivo Jesu icha kaꞌene ꞌanaari anejijino ea kaꞌene namijajaho Huni oha ꞌee Huni ohijihuni ꞌuꞌua ꞌee Meri kaꞌene Karopasi oni napara ꞌee Meri Matarini ijá namijara. ");
INSERT INTO mcq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu oaha kame ꞌee Huni tisaiporu pinaka Hu oja mahujaho kaviꞌi ijá ꞌwama Napara karere oni Hariha kama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ꞌEne Hu Huni tisaiporua ijá ꞌwama Oni oha kama ꞌwavume hu ijí hene túnaꞌi napara kajaho aheme huni ari vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ijihuni túnaꞌi Jesu henajaho uneunecha mapoka kaꞌene Hura veꞌiro roajaho iviamaa nivesihana. ꞌEnavo Godoni iri nitama ꞌwaramajaho ro nimaa renana. ꞌEjume ijá ꞌiama Na toa huanimu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ꞌEꞌeme siꞌuara ajina riha kisina rukina ijí namanaꞌomo pu ꞌoꞌasuni ichi mwavahame ꞌena ape ꞌurine Hu iri vwevara. ");
INSERT INTO mcq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ꞌEjume Jesuho ijí ajina riha kisina kajaho inarena ijá ꞌiama Nipaꞌarenu ꞌiꞌikaꞌi húmata aruha arihajaho niꞌaha kwinu oja sumana. ");
INSERT INTO mcq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ꞌEjume Juapo Pairati apoma ijá ꞌwava Nú ea kaꞌene icha ꞌahi navu karaho ꞌanie mumora túachamihe kwamasahakiviꞌi ꞌeke mweꞌi irechava ꞌwavara. Pu ijá vejajihuni maijaho puni Sapati jihuni vea natohwijara rehuni jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ꞌEjume sorutiapo roe urana namajihuni mumora ꞌania tuamahe ꞌee ea pina kaꞌene ropunaꞌi Hu huꞌúmo icha ꞌahi ꞌanaajihuni mumora ꞌania tuamahara. ");
INSERT INTO mcq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ꞌEnakaivo pu Jesuni roiꞌi kavajaho Jesuho nikwamana kavara. ꞌEnareja pu Huni mumora patumahara. ");
INSERT INTO mcq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ꞌEꞌeme sorutia kwino juha apena roe iana hari pijahume niꞌaha kwinu ꞌaa ꞌee toa ijiꞌi arihana. ");
INSERT INTO mcq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ea kaꞌene ijí reꞌeme kamajara ijí rone ꞌwaramu. Ijí hura rone ꞌwaramujaho nimaa. ꞌEne hu nihena kiviꞌini jihunaꞌe hu nimaa ꞌwaramu jihunaꞌe ja ꞌuꞌo hena nimaa rohuna. ");
INSERT INTO mcq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ijí uneunecha kajaho vejuma paꞌareꞌejumaꞌe nitama Godoni ira ijá ꞌwarumajaho Huni ata pina paveje ꞌauꞌena ꞌúmajaho nimaa renana. ");
INSERT INTO mcq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Vukúꞌu nitama Godoni iri ijá ꞌwarumane Pura Hu pijahajaho pu kahuna ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ijihuni túnaꞌi Josapi kaꞌene Arimatia orijaho Jesuni tisaiporu pina kaivo Jua juhamareꞌe pasama hiramunaꞌomo hu roe Pairati Jesuni haha apeꞌirono apoma ꞌwaramana. ꞌEjume Pairatira nijina ꞌwavume hu roe Huni haha apena vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotimasi kaꞌene nitama naꞌii Jesu vaꞌe kamajara ꞌuꞌo senisia mú ꞌee aroi vejara kaꞌene ahija rukinijaho apena roana. ");
INSERT INTO mcq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pu Jesuni haha apene ateha senisia ijiꞌi mwavara. Jua puni tamana ea kwamasahiꞌina ijá vejura. ");
INSERT INTO mcq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kwaa kaꞌene Jesu icha ꞌahi ꞌanaari rorijaho juasiꞌa. ꞌEnaꞌomo juasiꞌa kajino mutita namuna kaivo ea ꞌahoꞌa maiꞌo ijaho pairechamiara. ");
INSERT INTO mcq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mutita kajaho samatuꞌunaꞌomo Juapo Pasova hunaꞌe amairiarahuni jihunaꞌe pu ijí Jesuho ranavara. ");
INSERT INTO mcq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Hura natohwi súꞌu súꞌo vea maiꞌo paahara saꞌeme Meri Matarini ijí mutita kaji vaiꞌi kamajaho muna kaꞌene vwicha kunavajaho tatiraha apene ruvaara kamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ꞌEnarena hu ninuma vaꞌe Saimani Pitaho ꞌee tisaiporu pina kaꞌene Jesura oja mahujiꞌi puni vaꞌe ijá ꞌiama Pu núni Natohwijaho mutita vaja niapene ani ranavaraꞌomo pu ichihi ranavajaho nú puruva renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ꞌEjume Pitaꞌo Huni tisaiporu pina kajiꞌo mutita kaji vaꞌiro vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ea noꞌo ninukujahara kaivo tisaiporu pinijara Pita ninuma asima urana vaꞌe marako mutita rora kaji ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hu vaꞌe aruha amanena niriajaho ateha ijí navara kaivo hu vaja paaruma vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ꞌEꞌeme Saimani Pita ꞌuꞌo túnaꞌi va ꞌeꞌunarena ijí mutita vaji aruma vaꞌi kamajaho ateharu navara. ");
INSERT INTO mcq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ꞌEnakaivo ateha pina kaꞌene Jesuni húmata mwavajaho ateha ꞌahoꞌapo navajaho panamana kaivo hunano mwama vaꞌe namana. ");
INSERT INTO mcq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ꞌEjume tisaiporu pina kaꞌene urana mutiti roaji ꞌuꞌo ijí aruma vaꞌe ateha kajaho kime nimaa ronana. ");
INSERT INTO mcq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ꞌEnakaivo pu Godoni vuꞌa kaꞌene Hu kwama ꞌurihunijaho pu maiꞌo majaa pahejara. ");
INSERT INTO mcq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ꞌEnareja tisaiporu kajija ꞌuname puni ari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ꞌEꞌeme Meriho ijí mutita rori namine niraviꞌi aruha arihe mutita vaja kaji niriana. ");
INSERT INTO mcq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ꞌEjiꞌi kivume ꞌona ojiꞌina noꞌoheꞌi ateha sajasaꞌini same Jesu ranavari tinijino pina húmanaꞌi asuma hijume pina mumonaꞌi asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ꞌEjume pu hu ijá ꞌwava Napara karera a raka vene niramo? ꞌwavara. ꞌEjume hu ijá ꞌiama Erapo nuni Natohwa apena vaꞌe ani ranavukame na puruva reniuꞌe ijihunaꞌe avaju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hu ijá ꞌwaraꞌikaivo ura taꞌarohiꞌi kamajaho Jesuho ijá naminana kaivo Jesura naminu paronana. ");
INSERT INTO mcq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ꞌEjumakamarena Jesura hu apoma ijá ꞌwama Napare A rakijihunaꞌe niramo? A irá samo? ꞌwamana. ꞌEjume hu vwihanajaho Hu juara anesura roꞌikaivo ijá ꞌwama Ara reha Hu apena vaꞌe ani ranamanaꞌe reꞌamajaho a ichá ranamajaho ꞌwarive na vaꞌe Hu apejuma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ꞌEjume Jesu ijá ꞌwama Meri ꞌwamana. ꞌEjume hu taꞌarohiꞌi Jua puni iri ijá ꞌwama Raponai ꞌwamana. Ijihuni maijaho Najuhiꞌine ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu ijá ꞌwama A Na paꞌuniriꞌamana. Ijihuni maijaho Na maiꞌo Amo oni pavaiꞌinakúne a vaꞌe vwehu Nuna ꞌwaraꞌamana. Na Nuni Oma ꞌee joni Oma Nuni Godi ꞌee joni Godi ijihuni vaꞌu ꞌiꞌama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ꞌEjume Meri Matarini roe hura núni Natohwiji kamajaho Huni tisaiporua ꞌwaramana. ꞌEne Hura vuꞌaka ꞌwarama kaji ꞌuꞌo ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hura Natohwa nusirei tisaiporu mapoka ahuma sei vaji vwicha kume hijara. Ijihuni maijaho pu Jua juhamareja avajara. ꞌEꞌeme Jesuho roe pura ahuma hija kaji rira muꞌoi namiꞌi kaivo ijá ꞌiama Matauviꞌinijaho ja puꞌúmuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hu ijá ꞌwaramarena ijiꞌa Huni ija najahe ꞌee iana ꞌuꞌo najahana. ꞌEjume Huni tisaiporua Natohwiji kamareja teamanama parajara. ");
INSERT INTO mcq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ꞌEjume Jesu kúꞌo ijá ꞌiama Matauviꞌinijaho ja puꞌúmuna. Amora Na ranamia jaꞌinaꞌe Na ꞌuꞌo ijaꞌinaꞌe ja irechamiu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hu ijá ꞌwaramarena Hu iruhoa vetie ijá ꞌiama Godoni ꞌAvena apeha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ja ea ꞌahopuni sisea vwihanie areꞌavajaho puni sisea vwihana arevume paranana. ꞌEnakaivo ja ea ꞌahopuni sisea pavwihanie areꞌavajaho puni sisea maiꞌo paparanana. ");
INSERT INTO mcq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ꞌEnakaivo Tomasi kaꞌene Titimasiho ea iropu ropu noꞌo ijihi puni ea pinaꞌomo vea kaꞌene Jesura roajaho hu ijaho pahinana. ");
INSERT INTO mcq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ꞌEnaꞌomo tisaiporu ꞌahopo hu ijá ꞌwava Nú Natohwijaho nikavara ꞌwavara kaivo hu pu ijá ꞌiama Na nuni nii Huni ija kaꞌene nerui ꞌaniajija kime ꞌee nuni ija ranave nerui vaꞌani ꞌunamiji vaꞌe ꞌee nuni ija Huni iana hari ranaꞌujiana vo na panimaa roju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Naꞌia iropune noꞌupisu paꞌareꞌeme Huni tisaiporua vwicha kume vaji Tomasiꞌi puꞌúmo hiꞌeme Jesuho kúꞌo roe puni rira muꞌoi namijiꞌi ijá ꞌiama Matauviꞌinijaho ja puꞌúmuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ꞌEnarena Hu Tomasi ijá ꞌwama Oni ija miha. ꞌEne Nuni ija kiama. Oni ija miha. ꞌEnareje iana hari isama. Panimaa ronujaho areꞌikaꞌi nimaa rona ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ꞌEjume Tomasi eha vene ijá ꞌwama Nuni Natohwe ꞌee nuni Godi ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ꞌEjume Jesu ijá ꞌwama A Na kimajihunaꞌe nimaa ronu kaivo ea kaꞌene Na pakiꞌeja vo nimaa rojajaho Na merajihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu aacha ꞌahoꞌa ea areri pavejura Huni tisaiporu puni unaꞌi vejume kavara kaivo ike puka vajakaho pavejara. ");
INSERT INTO mcq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ꞌEnakaivo vuꞌa ike vejajihuni maijaho Jesuho Kerisone ꞌee Hu Godoni Harihijina ꞌomo ijí nimaa roꞌavajaho Huni iha ꞌahi majama hihuna apehuna. ");
INSERT INTO mcq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ijihuni túnaꞌi soha iha Taipiriasi ꞌwavujino Jesuho Hu icháꞌinijaho kúꞌo Huni tisaiporua najahana. ꞌUnama ikaꞌinaꞌe Hu icháꞌinijaho najahana. ");
INSERT INTO mcq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimani Pitane ꞌee Tomasi kaꞌene Titimasina ꞌwavujaho ꞌee Nataneru kaꞌene Kena Karari orijine ꞌee Jepeti oni harihija ꞌee Huni tisaiporu noꞌoheꞌi ijihi puꞌúmo ahuma hijara. ");
INSERT INTO mcq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimani Pita ijá ꞌiama Na vaꞌe úa vesaꞌi vaꞌu ꞌiamana. ꞌEjume pu ijá ꞌwava nú ꞌuꞌo vuꞌajivu ꞌwavara. ꞌEjume hu pu puꞌúmo vaꞌe sisima ꞌahi ajivara kaivo ijí naꞌia kajaho pu kija pasiriravara. ");
INSERT INTO mcq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Súꞌu súꞌo vea maiꞌo ahasioꞌejuꞌe Jesuho ora samai naminana kaivo tisaiporua Jesura naminu parojara. ");
INSERT INTO mcq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ꞌEjume Jesu pu ijá ꞌumena Sesa karijee ja vi kija siriravooo? ꞌiavume pu eha vene ijá ꞌwava Pana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ꞌEjume Hu pu ijá ꞌiama Joni namea sisima ropunaꞌi manaꞌinijaꞌi apúsamareje ja kija siriraha ꞌiamana. ꞌEjume pu namea ꞌene ropunaꞌi apúsavara. ꞌEꞌikaivo pu tairiajaho areri parenana. Ijihuni maijaho kija mapoka mapoka ijí puni namea vajijaho ani renajihunaꞌe areria parenaara. ");
INSERT INTO mcq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesura tisaiporu kaꞌene oja mahajara Pita ijá ꞌwama Ijaho Natohwi jarana ꞌwamaji Saimani Pita henajaho hu maisu kaukara venonanaꞌomo ateha ape apúsame mwamapi soha vaja kaji vajamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ꞌEꞌeme tisaiporu ꞌahoꞌa sisima maꞌuꞌua ꞌahi roe kija kaꞌene namea vaji ituꞌoꞌunana nama kajaho tairia karohi rori vaꞌara. (Ijihuni maijaho rori vahuna mina areri 100 mita.) ");
INSERT INTO mcq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pu roe rori arihiꞌi kavume vena reꞌeme kija ꞌee puretia ijihuni toi rejiꞌi navara. ");
INSERT INTO mcq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ꞌEjume Jesura ijá ꞌiama Kija kaꞌene iviamaa jara sirirava kajaho ꞌahoꞌa ꞌeka roha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ꞌEjume Saimani Pitara vaꞌe ajime namea kajaho tairi apene iki samai roiꞌi kavume kija mapoka mapoka mamaꞌina (153) ijihuni vaji navara kaivo namea paturamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ijiꞌa Jesu ijá ꞌiama Roe ꞌiruma ija ꞌiamana. ꞌEjume pu nihena kavajaho Hu Natohwiji kamareja pu ea pina paapome A Ea irarane? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ꞌEnarena Jesura roe puretia ꞌeke tuama vajihe ꞌee kija ꞌuꞌo ijá venana. ");
INSERT INTO mcq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ijaho Jesura kwama ꞌurinani túnaꞌijaho Hu ꞌaha noꞌopisu Huni tisaiporu najahajina. ");
INSERT INTO mcq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pu ꞌiruma ijume paꞌarejumakaviꞌi Jesu Saimani Pita ijá ꞌwama Saimani Joni oni harihe a Na oja mihujara ikija asitahane? Hu ijá ꞌwama Iꞌa Natohwe na A oja mahujaho A nihena kimu ꞌwamana. ꞌEjume Hu ija ꞌwama Nuni sipia ꞌuꞌua piiraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hu kúꞌo ꞌaha noꞌu ijí ijá ꞌwama Saimani Joni oni harihe A Na oja miho? ꞌwamana. ꞌEjume hu ijá ꞌwama Iꞌa Natohwe Na A oja mahujaho A nihena kimu ꞌwamana. ꞌEjume Hu ijá ꞌwama Nuni sipia ꞌajohaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ꞌEne Hu ꞌaha kúꞌo noꞌupisu ijí ijá ꞌwama Saimani Joni oni harihe a nimaa Na oja miho ꞌwavume Pitaho temumana. Ijihuni maijaho Hu ꞌaha noꞌopisu ijá ꞌwama A Na oja miho ꞌwamajihunaꞌe hu temuvume ijá ꞌwama Natohwe uneunecha mahoꞌo A nihena kimuna Na A oja mahujaho A nihenu ꞌwamana. ꞌEjume Jesu ijá ꞌwama Nuni sipi ꞌiruma vajiꞌamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na a nimaa nimaa ꞌwaravu a vea kaꞌene kivasa hinajaho a orono vwiha irame a ura ichihichihi vaꞌi ꞌahaujaho ijí vaꞌuna kaivo a emaa reꞌamajaho a ichihichihi ura vaꞌi ꞌahaꞌamajaho pu iji ꞌunaramone vwiha iramahe a kwaa kaꞌene pavaꞌi ꞌahaꞌamaji pu aherame vahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Hu ikaꞌinaꞌe ꞌwarama jihuni maijaho hura icháꞌinaꞌe kwavakame Godoni pinana ꞌurihuniji rone ꞌwaramana. Hu ijá ꞌwaramarena ijiꞌa ijá ꞌwama Na ꞌararihia ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ꞌEjume Pita ura taꞌarohiꞌi kamajaho tisaiporu kaꞌene Jesura oja mahujaho ꞌararihie roana. Ea kajaho vea kaꞌene Jesu puꞌúmo ꞌiruma ijari veijino Huni túra ꞌahi mena hinanaꞌomo apoma ijá ꞌwama Natohwe ea irara A nahamaꞌena? ꞌwamajina. ");
INSERT INTO mcq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitara ea kaji kaviꞌi Jesu ijá ꞌwama Natohwe eakaho ichá rehune? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu ijá ꞌwama Na ura eakaho hina apena vaꞌeje Na kúꞌo rohuna reꞌipisa ijaho oni kaukara panakúne Na ꞌararihia roa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pu vwehwaha ijí henareja ꞌwama apene ojiꞌi ijá ꞌwava Ike tisaiporuakaho pakwaꞌena ꞌwavara. ꞌEnakaivo Jesu hu pakwaꞌena paꞌiamana. ꞌEnakaivo Na ura eakaho hina apene vaꞌeje Na kúꞌo rohuna reꞌipisa ijaho Nuni kaukara ꞌwamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ike tisaiporu kaꞌene vuꞌake venukaho hu hena kimujihunaꞌe najahe ꞌee asurakaho venu. ꞌEnakaivo nú niheju Hura raka kaꞌene ꞌwarumujaho nimaa nimaa. ");
INSERT INTO mcq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ꞌEnakaivo uneunecha mapoka kaꞌene Jesura venaji mahoꞌo heha ꞌahi veꞌipisa mweꞌa ikaho puka kajihi irechahuna nihoꞌo areri parejaꞌa. Nijina. ");
INSERT INTO mcq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiapirasi ese. Nimarako pasia pina kaꞌene na vejujaho Jesura raka kaꞌene aneja vene ꞌee ea najaha ");
INSERT INTO mcq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","apene vaꞌu vaꞌo vaꞌe vea kaꞌene Hura kahi akúpa ꞌahi vaꞌaji va ꞌeꞌujuta. Hu vaꞌamarono Godoni ꞌAveni vaji Huni apasorua kaꞌene Hura iji pijihajija raka kaꞌene pu vehunijaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ꞌEne Hu kwama ꞌurinarena naꞌia mapoka (40) Huni haha ꞌahi icháꞌina renaji pu najahana. Hu nimaa ꞌurinana roꞌavarorena ꞌunama ani ani vejiꞌi Godoni ariji rona najaha ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ꞌEne pu ahuma hiꞌeme Hu ijá ꞌiama Ja nihoꞌo Jerusaremi paareme vaꞌavara kaivo ijí ꞌajaꞌeje Amora raka kaꞌene ja miꞌiro nahama ꞌwaravume Na ꞌwaravujaho mihakamaꞌe ijiꞌa vaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ijihuni maijaho Joniho ja toi vaji samaume ꞌurijara kaivo naꞌia josuꞌa pareꞌeje ja Godoni ꞌAveni samahuna. ");
INSERT INTO mcq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ꞌEjume pu roe ahuma hijiꞌi apoma ijá ꞌwava Natohwe A vea kajino kúꞌo kwaa kakaho Isureri ora miꞌena? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ꞌEjume Hu pu ijá ꞌiama Amora ijí vea kajaho Hu henu ꞌee Huni harurijino irechamana kaivo ijihijaꞌe jara hena kahuna pana. ");
INSERT INTO mcq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ꞌEnakaivo Godoni ꞌAveni roe ja samahakame ja harura apenarejaꞌe ijiꞌa Jerusaremi ꞌee Jutia ꞌee Sameria Na rone najahuna. ꞌEne ike mweꞌakaho mahoꞌo najahuna. ");
INSERT INTO mcq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ijija ꞌwaravume paꞌareꞌeme pu ijá kaviꞌi namiꞌeme Hu apene ꞌimita vaji vaꞌume ꞌimiti tanuꞌurihume pakavara. ");
INSERT INTO mcq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Heha! Hura vaꞌukame pu nia kaꞌene akúpi ꞌahi nirinamie nava kajaho paꞌareꞌeme ea noꞌoheꞌi ateha sajasaꞌini savajija ijá puni rori namijara. ");
INSERT INTO mcq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ꞌEnareja ea kajipo ijá ꞌiava Karari orakije ja raka vene namina hine akúpa ꞌaha nirinama navo? Ijí Jesuho iki joni rene apene akúpi ꞌahi vaꞌukaho Hu kúꞌo ꞌunama roꞌamajaho ꞌunama nikwinuꞌina kaꞌene jara Hu kaꞌejuꞌe vaꞌu kajaꞌina rohuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ꞌEjume pu huriꞌa Arivi rene Jerusaremi roara. Arivi rena roe kamino Jerusaremi usevujaho naꞌia kwinuna kwaa jora pana. ");
INSERT INTO mcq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pu ijí Jerusaremi roareja pura seaka huri hijujino vaꞌara. Pita ho Joni ho Jemisi ho Enituru ho Piripu ho Tomasi ho Pataramiu ho Matiu ho Jemisi kaꞌene Apiasi oni harihijaho ꞌee Saimani kaꞌene Jerati ꞌwavujaho Jutasi kaꞌene Jemisi oni harihijaho ijá vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pu ijí rira kwino napara ꞌee Meri kaꞌene Jesuni ohijaho ꞌee Huni ꞌuꞌuhijijihi puꞌúmo ahuma vwiha kwisu rene siporua ꞌojiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ijá vejari veijino ea kaꞌene Godi nimaa rojujijahija mapoka (120) ahuma hiꞌeme Pitara puni rira kaji ꞌurine arini namijiꞌi ijá ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Vwehu nune Godoni ꞌAvenijara Teviti oni ira vaji Jutasi rone ꞌwaramajaho iviꞌa Godoni irijaho nimaꞌe renana. Jutasira ea aherama roe najahume Jesuho apejara. ");
INSERT INTO mcq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hu nú puꞌúmo hinone ꞌee kaukara kaꞌene núra vejukehuni pwinanaꞌa renana. ");
INSERT INTO mcq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ike ea ikaho monia kaꞌene sisea vejuꞌe vajahajino apena mweꞌa sisa pina ꞌimenanaꞌomo ijí unaꞌi ꞌone huni tea jahausahume kwamana. ");
INSERT INTO mcq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ijihunaꞌe ea mapoka kaꞌene Jerusaremi hijujija kwaa kajaho iha Hakeratama ꞌwavura. Puni iri Hakeratama ꞌwavujihuni maijaho ꞌAa Mweꞌa ꞌwama avajura. ");
INSERT INTO mcq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Godoni ira kaꞌene Samusi vaji ikaꞌinaꞌe vejara. Veje huni ara kwaa savasaꞌe renama. ꞌEje ea pina pahinama ꞌee huni kaukara ijaho ei pini huni tinia apena venama ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ijihuni hahi nú ea pina kaꞌene naꞌia mapokaꞌe núni Natohwa Jesui puꞌúmo ꞌajúha ojiꞌiniji apehuna. ");
INSERT INTO mcq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ijaho vea kaꞌene Jonira ea toi samajino rene rou vaꞌo Hu apena vaꞌaji ꞌeꞌunaji ea pina apejakame Hura kwama ꞌurinaji ronareje ea ꞌahoꞌa ꞌwaraviꞌinaꞌe rehuna. ");
INSERT INTO mcq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ꞌEjume pu Josapi kaꞌene Pasapasi kaꞌene Jasitasina ꞌwavujiꞌo Mataiasiꞌo ꞌeka roajivara. ");
INSERT INTO mcq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ꞌEnaꞌomo pu siporua ꞌone ijá ꞌwava Natohwe A eaka mapoki jihipuni oja vaja nihenunakúne Ara ea kaꞌene iji pijahaji najuha. ");
INSERT INTO mcq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ꞌEjakame hura kaukara ikehuni vaja tinia apene ꞌee apasoru huni kaukara kaꞌene Jutasira areꞌi huni ruhi vaꞌajaho venama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ꞌEnareja ijihuni túnaꞌi pu pipia venareje Mataiasira tinia apenana. ꞌEjumakame hura apasoru iropu ropu kwinu ijihi niꞌajinamiana. ");
INSERT INTO mcq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jua puni Penitikosi vea natohu rejume pu mahoꞌo rira kwinu ahuma hijara. ");
INSERT INTO mcq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ꞌEꞌeme niꞌaha kwinu akúpa ꞌahi ꞌoꞌivajamajaho areri puurapo hiravujaꞌina rena roꞌeme sea kaꞌene pura hija kajaho ꞌahíꞌahí vajamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ꞌEꞌeme pu kiꞌeme ira kaꞌene vena saꞌinijipo rene roariharene ea kwinu kwino puni haha ꞌahi tirohara. ");
INSERT INTO mcq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Godoni ꞌAveni ruha apene paranarena venaume pu ea mahoꞌo aneja vene ira ani aniꞌina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ꞌEjume Jua kaꞌene Godi oja mahiꞌina kaꞌene kwaa ani ani rena roajija ijí Jerusaremi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ꞌEnaꞌomo vea kaꞌene ꞌoa kaji henareja ea mapoka kajija ahuma roe nihoꞌo puruva retiana. Ijihuni maijaho ea ꞌoiꞌoi heꞌejuꞌe puni imaijino hine ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ꞌEjumakame pu oja paꞌarenaꞌe ꞌee oja hwaꞌusahaume ijá ꞌwava Ikaho ichá vejo? ꞌÚ ea kaꞌene ike ꞌwavukija Karari ora pane? ");
INSERT INTO mcq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pu icháꞌina vene núni imaa kaꞌene nú nahenuajino ꞌwavujaho nú hejo? ");
INSERT INTO mcq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Núa Patiani ore Miria ore Irami ore Mesopotemia ore Kapatosia Ponitasi ore Jutia ore Esia ore ");
INSERT INTO mcq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirijia ore Pamipiria Ijipiti vajinaꞌomo ijí ore Ripia opuni kwaa Sairini rorine ea ꞌahoꞌa Romu ora ꞌee Jua ꞌee Jua puni tamana hene vejujihunaꞌe roajivara. ");
INSERT INTO mcq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nú ea ꞌahoꞌa Kuriti ore ꞌee Arapia ora ꞌavo pu hine núni imai Godira uneunecha mamaꞌina kaꞌene venaji rone ꞌwavu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ꞌEnareja pu oja hwaꞌusaha nihoꞌo puruva renaume aposaramapene ojiꞌi ijá ꞌwava Ijaho iraki reno? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ꞌEnakaivo ea ꞌahoꞌa pu ijí matihe ijá ꞌwava Ike eakija ꞌwaini vwea rukinaꞌe ine nanamiu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ꞌEjume Pitara ꞌurine ea iropu ropu kwinu puni rira kajino namiꞌi kaivo ira ajira ijá ꞌumena Jutia ora ꞌee ea mahoꞌo Jerusaremi hijukije ataa apúsame nuni ira ike heha. Nara raka kaꞌene ꞌwaraꞌi vejukaho ja ea ꞌahoꞌa ijá ꞌwavo. ");
INSERT INTO mcq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ja vwihajujaho ea ikija nanamiu roju kaivo pana. Iviamai súꞌu súꞌu vea hareha ꞌaha karakaro namijujaho ea pananamiura. ");
INSERT INTO mcq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ikaho iraka kaꞌene poropeti Joerura rone ꞌwarumajina. ");
INSERT INTO mcq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mweꞌakara maiꞌo paꞌareꞌi veꞌeje raka kaꞌene rehuniji Godira ikaꞌina ꞌwaramana. Nara Nuni ꞌAvena ea mapoka samahakame joni harihija ꞌapahija Godoni ꞌwaraviꞌina rehuna ꞌee joni kivasa raka kaꞌene túnaꞌi rehunijaho visoni kihuna ꞌee joni ema ijija maiꞌo túnaꞌi raka kaꞌene rehunijaho navahi kihuna. ");
INSERT INTO mcq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nara Nuni pwea kaꞌene napara parua ijija Nuni ꞌAveni samahakame ijí vea kajaho pu Nuni vuꞌa ꞌwaraviꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nara uneunecha aniꞌina akúpa ꞌahi vehuna ꞌee aacha ani ani mweꞌi najahuna ꞌee ꞌaa ꞌee vena ꞌee venuꞌa ani rehuna. ");
INSERT INTO mcq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Vea naꞌime nutuma nave masapa nihoꞌo amapuꞌura reꞌeje ꞌaa punaꞌi rena nahuna. Ijá reꞌamani túnaꞌijino Natohwijaho rohuna. ");
INSERT INTO mcq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Vea kajino ea irara Natohwi jihuni iha ꞌuraha ꞌumeꞌamajaho Hu niꞌajahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ꞌEnakúne Isureri orakije ike vuꞌakaho hami heha. Jesu kaꞌene Nasareti ora kaꞌene Godira nimaa vene iji pijahe ranavume roajihuni vaji huni aacha ani aniꞌina ea areri pavejujija joni vaji venajaho ja ojono nihena kavu. ");
INSERT INTO mcq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ike eakaho nitama Godira hena kamarena ni amairiaramana ꞌomo ja Hu ea sisesa mihume pu korosia ꞌahi ꞌanaume kwamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ꞌEnakaivo Godira vejume Hu kúꞌo ꞌurinana. ꞌEnarena kwamasahe haha kaꞌene hehunijaho paꞌarenana. Kwamasahuri harurijara Hu ꞌunanahuna areri pana. ");
INSERT INTO mcq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ꞌEnakaivo Tevitira nitama Hu rone ꞌwaramarena ijá ꞌiama Na kaꞌejuꞌe Natohwijaho nuni unaꞌi naꞌia mapoka hinu. Hu nuni ija manaꞌinijaꞌi hinujihunaꞌe na oja pahianihuna. ");
INSERT INTO mcq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ijihuni hahi nuni oja vajakaho nihoꞌo teamanivuꞌe ꞌee nuni mitara mariꞌumu. ꞌEjuꞌe nuni haha ꞌuꞌo ꞌojuta hami hwehunaꞌe vwihajiꞌi hiju. ");
INSERT INTO mcq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Na niheju. A Nuni ꞌavena paranave vaꞌe ruha kaꞌene veni renujaho vahuna. Oni Ariramaijaho pamakaꞌeje sakaraꞌena. ");
INSERT INTO mcq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ꞌEnakaivo A majama hihunijaho najihana. ꞌEne na Oni unaꞌi hiꞌujara veje teamanima paranihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Vwehu nune makiꞌeje na núni sasa rone ꞌwaravuma. Tevitira kwavumakame ranava jihuni húijaho ikeho majama núni rori namo. ");
INSERT INTO mcq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Hu poropetiaꞌomo Godira raka kaꞌene nahama ꞌwaramajaho hu he parajiꞌina renana. Godira nahama ꞌwaramajaho Hu vejakame Teviti oni amuhiji pini huni ruha apene hihuna ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Teviti túnaꞌi raka kaꞌene rehunijaho hu nihena kamarena hu Kerisora kwama ꞌurihuniji ronarena ijá ꞌiama Huni ꞌAvena paranave vaꞌe ruha kaꞌene veni renujaho vahuna. Huni haha pasakarahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Godira vejume Jesura ꞌurinaji nú mahoꞌo nihena kavajihunaꞌe ja ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Godira vejume Hu Godoni ija manaꞌinijaꞌi hinu. ꞌEjuꞌukame Amora Huni ꞌAvena kaꞌene nahama ꞌwaramaji Hu mihuꞌukame jara raka kaꞌene iviamaa hena kavujaho Hura Huni ꞌAvena kaji usesamaana. ");
INSERT INTO mcq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tevitiho nitama maiꞌo akúpa ꞌaha pavaiꞌini hu ijaho ꞌwaramarena ijá ꞌiama Natohwijara nuni Natohwa ijá ꞌwama Nuni ija manaꞌinikaꞌi asuma hiꞌeje ");
INSERT INTO mcq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nara Oni naka venaꞌe Oni omora hari hija ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ijihunaꞌe ꞌwarave ea mapoka kaꞌene Isureri hijujaho nihoꞌo hami hami he paraꞌavara. Godira Jesu vejume Natohwa rene ꞌee Keriso renana kaꞌene jara icha ꞌahi ꞌanaajina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ꞌEjume pu ea kajipo ijí henareja pu oja ꞌurina parajume Pitaho ꞌee apasorua ꞌahoꞌijija ijá ꞌiava Nú icháꞌina veꞌeja? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Joni sisea vwihane aremamaa areꞌi kaivo taꞌarohe Jesu Keriso oni iha ꞌahijino toi samaꞌe joni sisea paꞌareꞌamana. ꞌEꞌeje ja swara kaꞌene Godoni ꞌAveniji apeha. ");
INSERT INTO mcq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ijí nahama ꞌwarama kajaho jone ꞌee joni harihipune ꞌee ea kaꞌene kwaa jojori hiju jihipune ꞌee areri ea mapoka kaꞌene núni Godi Natohwijara Hunaꞌe ꞌumena ijihipuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ꞌEjume Hu vuꞌa ꞌahoꞌa ꞌuꞌo ꞌwaramarena hu ꞌejahie ijá ꞌiama Mweꞌa kehuni siseijaho asinamie ruvaꞌeje maraniama. ");
INSERT INTO mcq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ea kaꞌene vuꞌa kaji hene vejajija toi samahara. ꞌEne ea kaꞌene nimaa rojiꞌina mapoka (3,000) vea kajino huri rejara. ");
INSERT INTO mcq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ꞌEnareja ijí apasorua kajipo najahajaho henareja pu veku veku ahuma hine siporua ꞌone ꞌee puretia tuachame ijiꞌi hijura. ");
INSERT INTO mcq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ꞌEjume Godira apasoru puni vaji aacha ani aniꞌina kaꞌene ea areri pavejujipo rejumakame ea mapoka kaꞌene hija kajija oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ea kaꞌene ijí nimaa nimaa rojiꞌina kajija oja kwinu vwihane uneunecha mapokaka punijaho vajúsaraviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ꞌEjume pu aneja vene puni kukua ꞌee aachia ꞌeke ꞌimene ea kaꞌene pivusahiꞌinijihi niꞌajihara. ");
INSERT INTO mcq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ꞌEnareja veku veko Temiporui vaji ahuma hine vwiha kwino vwihane ꞌee sea sea ijí vaꞌe puretia tuachame ine ꞌee ꞌiruma temarasahiꞌi oja kwisu rejiꞌi ijura. ");
INSERT INTO mcq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pu Godi taꞌarohe ea ꞌahopo pu kivajaho teamanavura ꞌee Natohwijara vejuꞌe ea veku veko nimaa rojujija huri ꞌumanamiꞌi namana. ");
INSERT INTO mcq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nusirea apeꞌejuꞌe pu siporua ꞌona ꞌojuraꞌomo Pitaꞌo Joniꞌo ajima vaꞌe Temiporui siporua ꞌoꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ea pina oahoni tea vaji iriviꞌinaꞌe roanaꞌomo erapo kima apena vaꞌe veko veko Temiporu sea vwicha jiami ranavura. Vwicha jiami ruha kajaho Mavarasaꞌina ꞌwavura. ꞌEnaꞌomo ea kaꞌene mumora siserajiꞌina kajaho ijí vwicha jiama kajino hiꞌejuꞌe erapo ijí Temiporu kajino vaꞌiro vaꞌukiviꞌi moni jariramuna. ");
INSERT INTO mcq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ꞌEnaꞌomo Pitaꞌo Joniꞌo vaꞌareja Temiporu vaji arui vejumakiviꞌi hu pu moni jariramana. ");
INSERT INTO mcq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ꞌEjumakaviꞌi Pitaꞌo Joniꞌo niima kanaviꞌi ijá ꞌwava Nú kúma ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ꞌEjume hu unenuꞌu pina pununaꞌi apehuna vwihaji ꞌurí ahasirima kimana. ");
INSERT INTO mcq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ꞌEnakaivo Pitara ijá ꞌwama Na siriva ꞌee korutia paꞌana kaivo raka kaꞌene núnunaꞌi namuji na mahu. Jesu Keriso kaꞌene Nasareti orijihuni ihiji ꞌurahiꞌi ꞌwaravukúne ꞌurina namina vaꞌa. ");
INSERT INTO mcq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Huni ija manaꞌinijaꞌi ꞌunama apene ꞌurijume niꞌaha kwinu ꞌurina kajino huni mumora ꞌee atoka kajija marasahe harura rejara. ");
INSERT INTO mcq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ꞌEjume hu ohurikune namine aneja vene pu puꞌúmo Temiporu vaji ohurikuna ꞌuraha ojiꞌi Godi taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ꞌEne ea mapoka mahoꞌo kaꞌeme hu ꞌuraha ojiꞌi Godi taꞌarohana. ");
INSERT INTO mcq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hu ea kaꞌene mumora siserajiꞌina kaꞌene Temiporu vwicha jiami Mavarasaꞌina ꞌwavuji hine moniaꞌe jariraviꞌi hinujina kaivo iraki hu renaji kame puruvaretiume oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ꞌEꞌejume Pitaꞌo Joniꞌo aharu ꞌonamie namiꞌeme ea mapoka ninukujaha roe ijí Saramani oni sea kajihuni orota ꞌwavuji namina kame oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ꞌEjume Pitara ijí kime eaka mapoka kajija ijá ꞌiama Isureri ore ja rakijihunaꞌe hine oja hwaꞌusahuꞌe niimaru kúnamúo? Núra núni harurijino vejuꞌe eakaho marajuꞌe ꞌuraha onu rojare? ");
INSERT INTO mcq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ijaho Eparahami oni Godi ꞌee Aisiki oni Godi ꞌee Jekapi oni Godi ꞌee núni sahiji jihipuni Godijara vejume Huni pwea Jesuni pinana ꞌurinana. Ea kaꞌene ja apena Pairati oni unaꞌi vaꞌume hu ranaꞌi vejume ja Hu pavavara. ");
INSERT INTO mcq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ꞌEne ja Ea kaꞌene arimaijaho pataarohara kaivo ea kaꞌene ea ꞌaniuꞌe kwamasahiꞌiniji mihuna ura renana. ");
INSERT INTO mcq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ꞌEjume ja Ea kaꞌene majama hihuni anesurijaho ꞌanaara. ꞌEnakaivo Godira vejume kúꞌo ꞌurinaji kavaraꞌomo nú ijí rone nimaa ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ꞌEnaꞌomo nú Huni ihiji nimaa rojujihunaꞌe nú ijí Jesuni iha kaji ꞌurahiꞌi ꞌwaravume ea kaꞌene ja kame hejukaho maranana. ꞌEne nimairoa kaꞌene Huni vaji rena roajara vejume ea ikaho mahoꞌo joni unaꞌi marana paranana. ");
INSERT INTO mcq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ꞌEnaꞌomo vwehu nune ja puruva renaꞌeme ijaꞌina vejara. Areri joni ea mamaꞌinapo vejajaꞌinaꞌe vejara. ");
INSERT INTO mcq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ꞌEnakaivo ikija Godi nitama poropetia ꞌwaramarena ijá ꞌiamana. Huni Kerisora roe sisei hihunaka ꞌwarumajaho iviamaa ijaho Hu vejume nimaa renana. ");
INSERT INTO mcq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Joni sisea are mamaaꞌe areꞌi kaivo taꞌarohe roha. ꞌEje Godira joni sisea ꞌeke atoꞌarumama. ꞌEjakame Natohwi jihuni unaꞌi vea kaꞌene joni oja sonahunijaho rena roama. ");
INSERT INTO mcq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ꞌEjakame Hu Jesu Keriso kaꞌene jonijihunaꞌe iji pijahajaho ranave joni roama. ");
INSERT INTO mcq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hu ijí akúpa ꞌahi hiꞌeje Godira uneunecha mahoꞌo kaꞌene Huni poropetia arimaijihi puni ira vaji nitama ꞌwaramajija veje marasaha parahuna. ");
INSERT INTO mcq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosisira nitamatama ema ijá ꞌwaramana. Joni Godi Natohwijara poropetia areri naꞌina pina joni vwehipuni vaja kajino veje ꞌurihuna. ꞌEnakúne Hura raka ꞌwarava heꞌavajaho hami heꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ea irara Poropetia kajihuni ira paheꞌamajaho hu emaa puni vaja kajino ꞌanae paꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ijaho ijaꞌinaꞌe poropetia mahoꞌo Samueri oni rene ijí kahi roa ijipo iviamaa raka kaꞌene rena roe ꞌeꞌunukaho ꞌwaruvara. ");
INSERT INTO mcq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ja poropetia kajihipuni harihija. ꞌEne Godira vehuna kaꞌene emahu jonaꞌe nahama ꞌwarama jaꞌinaꞌe iviamaa jona ꞌuꞌo venu. Hu Eparahami ꞌwaramajaꞌina Oni amuhipuni vajijino kachiꞌina mahoꞌo mweꞌakino hijujija merajihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ꞌEnajihunaꞌe Godira Huni pwea vejume ꞌurine amura joni roanaꞌomo merajihakame ea mapoka joni ꞌunama siseijaho taꞌarohe aré ranahuna. ");
INSERT INTO mcq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitaꞌo Joniꞌo vaꞌa hine ea mapoka kajihi puꞌúmo vuꞌa ꞌwaviꞌi hiꞌeme pirisiti ꞌee hirisima kaꞌene Temiporu ꞌajohiꞌinijine ꞌee Sajusi ijija puni roajivara. ");
INSERT INTO mcq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ꞌEnareja pu nihoꞌo niꞌimaꞌura senavara. Ijihuni maijaho Pitaꞌo Joni ꞌo ea najahareja Jesuni vaji ea kaꞌene kwamasaꞌavajija kúꞌo ꞌurihuna ꞌiavumakame senavara. ");
INSERT INTO mcq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ꞌEjumakame vea naꞌí venajihunaꞌe pu ꞌunirame ꞌeka vaꞌe tipurai irechamiume hiꞌeme súꞌo nitumana. ");
INSERT INTO mcq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ꞌEnakaivo ea kaꞌene puni vuꞌa kaji hene nimaa rojajaho parua mapoka (5,000) nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ijihuni súꞌuhijino puni emaina ꞌee Sikuraipi ꞌee puni mamaꞌinijija Jerusaremi roe rira kwino ahuvara. ");
INSERT INTO mcq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi kaꞌene pirisiti natohwijaho ꞌee Kaiapasiho Joni ho ꞌee Arekisanita ho ꞌee pirisiti natohwijihuni ituha puꞌúmo ahuma hijara. ");
INSERT INTO mcq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pu noꞌo aherame roe puni unaꞌi irechamiꞌi kaivo pu aporama ijá ꞌiava Rakijihuni haruri vejare? Irahuni ihi ꞌurahume ijaho aranane? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ꞌEjume Pitaho Godoni ꞌAvenijara ruha apena parajumakame emaina ꞌee puni mamaꞌina ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ja nú iviasi ꞌotui irechamúꞌirono avaju. Ijihuni maijaho nú ea kaꞌene mumora siserajiꞌina vejume icháꞌina maranaji heꞌirono avaju? ");
INSERT INTO mcq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ja ea mapoka ꞌee Isureri orakije ike heꞌavara! Ijaho Jesu Keriso Nasareti ora kaꞌene jara icha ꞌahi ꞌanaume kwamanaꞌomo Godira vejume kúꞌo ꞌurina jihuni ihijara vejume ea kaꞌene joni unaꞌi naminukaho maranana. ");
INSERT INTO mcq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hu muna kaꞌene ja ea kaꞌene ara vejiꞌinijipo ura parenajina kaivo ijaho muna ahisimaꞌura kaꞌene ara ꞌunanahuniji rena naminu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Godoni ari vahuni ꞌunamijaho Iha nikwinu reje nú vahuna. Ei pini mweꞌaki nú niꞌajúhakame Godoni vahuna pana kaivo Godira Jesuho ea mapoka ikehipuni niꞌajihiꞌina mihanaꞌomo ijara niꞌajihakame Godoni vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Emaa kajipo kivume Pitaꞌo Joniꞌo puni unaꞌi namine pajuꞌi kaivo ajira ꞌwaravara. ꞌEjumakame pu ea kajija sikurua pakaviꞌina ꞌee ea mamahaꞌomo ea najahaji kimareja nihoꞌo oja hwaꞌusahura. ꞌEjume emaa kajipo hejajaho pu Jesu puꞌúmo ꞌurahojura hejara. ");
INSERT INTO mcq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ꞌEjumakame ea kaꞌene pu vejuma maranajaho ijí pu puꞌúmo namijumakame emaa kajipo ꞌwarahuna areri parenana. ");
INSERT INTO mcq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ꞌEjume ema kajipo pu noꞌo irechamiume maꞌahi vaꞌeme pu hine ꞌwama apene piraꞌaravara. ");
INSERT INTO mcq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ꞌEnareja pu ijá ꞌwava Eakija nú icháꞌina veꞌeja? Pu noꞌo unenuꞌu pina vejume ea mapoka kaꞌene Jerusaremi hijujija nikivara. ꞌEnaꞌomo núra ijí hekajihuna areria parenu. ");
INSERT INTO mcq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ꞌEnakaivo ike vuꞌakara parausahe emaapuni vaja vahuna reꞌamajaho roe ira kisimaꞌuraꞌe ꞌwaravakame pu ijí Huni iha kajaho kúꞌo paꞌurahiꞌi ea ꞌahoꞌa ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pu ꞌumenaume vaꞌumakiviꞌi ijá ꞌiva Ja kúꞌo Jesuni iha kajaho paꞌurahiꞌi ea ꞌwarahune ꞌee najaꞌavara ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ꞌEjume Pitaꞌo Joniꞌo eha vene pu ijá ꞌiava Ja vwihajujaho ꞌunama ariramaa raki jarane? Joni ira hena vehunijina ho Godoni ira hena vehunijine? ");
INSERT INTO mcq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nú raka kaꞌene kame hejajaho areri paꞌarehuna kaivo nú ꞌwarahuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ꞌEjume emaa kajipo pu noꞌo juvu vuꞌa ira ajira ꞌwaramareja irechamiume vaꞌara. Ea kaꞌene mapokijaho pura raka kaꞌene vejaji kame Godi taꞌaroha jihunaꞌe pura puaꞌe siseꞌi ꞌahihuni ꞌunama paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ea kaꞌene ijí pu vejume marana kajaho juara mapoka mapoka (40) paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pu irechamiajaho napuhwa puni vaꞌara. ꞌEnareja pirisitia mamaꞌina ꞌee emainijipo raka kaꞌene pua ꞌwaravajaho ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ꞌEjume pu ijí henareja ahuma hine siporua ꞌone Godi ijá ꞌwava Natohwa kaꞌene akúpa vene mweꞌa vene soha vene uneunecha kaꞌene ijihuni vaji hijujija venajiꞌo ");
INSERT INTO mcq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","nitama Oni ꞌAveni vuꞌa pina apene núni oma Oni pwea kaꞌene Teviti oni ira vaji rene roa ijá ꞌúma Irakijihunaꞌe Jenitarua hina sena vejo? ꞌEne emaa ꞌunama aniani maa paꞌajija vejo? ");
INSERT INTO mcq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kinia ꞌee ea ꞌajohaiꞌina ahuma namijiꞌi Natohwijaho ꞌee Huni Kerisoho ninavara ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nimae ike arakino Heroti ho Ponachasi Pairati ho ꞌee Jenitarua ꞌee Isureri ora ahume Oni pwea ariramaa Jesu kaꞌene Ara iji pijahaji ninavu. ");
INSERT INTO mcq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pura iraka kaꞌene vejajaho Ara nitama vwihane amairiarama jaꞌinaꞌe vejara. ");
INSERT INTO mcq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oo Natohwe iviamaa pura juha vuꞌa kisina kaꞌene ꞌwavujaho vwihana. ꞌEnareje nú Oni pwehijakaho niꞌajúha. ꞌEjakame nú haruraꞌe Oni ira ꞌwaraꞌavajaho pajuꞌikaꞌi nú ea najaha. ");
INSERT INTO mcq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Oni ija jorane ea veje maranie ꞌee aacha ani aniꞌina oni pwea ariramaa kaꞌene Jesuni iha ꞌahi vena ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pu siporua ꞌojume paꞌareꞌeme ijí sea kaꞌene pura hija kajaho variꞌeme Godoni ꞌAveni puni vaji ruha apenana. ꞌEjume ijiꞌa Godoni vuꞌa pajuꞌi kaivo aneja vene najahara. ");
INSERT INTO mcq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ea mapoka kaꞌene nimaa rojiꞌina kajija puni oja ꞌee vwiha nikwinu vwihajara kaivo ea pina unenuꞌu pina nuna paꞌiamana kaivo pu uneunecha mapoka ꞌeke totari ꞌojura. ");
INSERT INTO mcq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pu apasorua kajija harurijiꞌi Jesu kaꞌene Natohwijara kwama ꞌurinaji ꞌwaravume Godi pu niꞌimaꞌuraꞌe maiji vwihaniana. ");
INSERT INTO mcq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Puni vaja kajaho ea pina unenuꞌu pina panupiviꞌi hinana. Ijihuni maijaho ea kajija mahoꞌo mweꞌa ꞌee sea rukinaꞌomo ꞌimenareja ijí monia kajija ꞌeke roara. ");
INSERT INTO mcq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ꞌEjumakame pu monia kajija ꞌeka roe apasoru epuni unaꞌi irechavume pu ꞌeke ea kaꞌene uneunecha paꞌajihi pura pivusahuji kiviꞌi ꞌoiꞌoi vajihara. ");
INSERT INTO mcq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ea pina huni iha Josapina kaivo Jesuni pwehipo iha pina ꞌiame Panapasina ꞌwavura. Ijí Panapasi ꞌwavu kajihuni maijaho Niꞌajihiꞌina ꞌwavura. Hu Rivai oni amuja ꞌee kwaa iha Saiparasi nahejara. ");
INSERT INTO mcq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ꞌEnaꞌomo hu huni mweꞌa pwina ea ꞌahoꞌa ꞌimenae monia ꞌekana. ꞌEnarena hu monia kajaho ꞌeka roe Jesuni apasoru puni unaꞌi irechamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ꞌEnakaivo ea iha Ananaiasiꞌo naparaha kaꞌene Sapairana ꞌwavujiꞌo puni mweꞌa ꞌimejara. ");
INSERT INTO mcq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ꞌEnareja Ananaiasiho ijí monia kajaho ꞌahoꞌa hu ꞌekaꞌi kaivo ꞌahoꞌa ꞌeka roe Jesuni apasorua pisivia vajihumakame naparaha hena kamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ꞌEjumakame Pitara ijá ꞌwama Ananaiasiꞌo a irakijihunaꞌe Setani oni oja ruha apejumakame a oni mweꞌaka ꞌimenarena monia pwinanaꞌa a ꞌekivo Godoni ꞌAveni jihuni unaꞌi iraꞌata venane? ");
INSERT INTO mcq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Marakuꞌijaho mweꞌakaho omaa ꞌwa? ꞌEne iviamaa monia ꞌimejake ꞌuꞌo omaa ꞌwa? ꞌEnakaivo a rakijihunaꞌe oni oja vaji ikaꞌinaꞌe vwihanane? A nú emaa papisimúu kaivo a Godoni unaꞌi iraꞌata venana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ꞌEjume Ananaiasi ijí henarena niꞌaha kwino mweꞌi ꞌone kwamana. ꞌEjume pu ea ijí hene tea junamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ꞌEꞌeme kivapo roe huni haha apene mwame apena vaꞌe kwananavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ꞌEꞌeme vea oma noꞌopisu paꞌareꞌeme nusirei huni napara roe raka kaꞌene huni parua renajaho pahena pakaviꞌi roana. ");
INSERT INTO mcq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ꞌEnaꞌomo Pitara ijá ꞌwama ꞌÚ jara mweꞌa kajihuni monia ehaka apejajaho ijarune ꞌwavume hu Iꞌa nijana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ꞌEnajihunaꞌe Pita ijá ꞌwama Irakijihunaꞌe ja noꞌo paruuneꞌi ꞌwame Natohwi jihuni ꞌAvena vena kavare? Hena! Kivasa kaꞌene iviamai roe vwicha jiami namiju kajija paruuna apena vaꞌe kwananaꞌi vaꞌaraꞌomo pu a ꞌuꞌo apena vahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ꞌEjume hu niꞌaha kwino ꞌone huni mumora rora kajano kwama namana. ꞌEjume kivasa kajipo roe aruviꞌi kavajaho napara kajaho kwamana kamareja pu apene vaꞌe paruahoni rori kwananavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ꞌEjumakame sosia kajaho mahoꞌone ꞌee ea kaꞌene ijí hejajija nihoꞌo niꞌimaꞌuraꞌe tea junamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apasoru ahuma Saramani oni oroti hijiꞌi ea mapoka puni vaji aacha ani aniꞌina ꞌee uneunecha kaꞌene ema areri pavehunijaho vejara. ");
INSERT INTO mcq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ꞌEjuꞌukame panimaa rojiꞌina ꞌahoꞌa paroe pu puꞌúmo hiju kaivo pu apasorua kajihipuni pinana hena ꞌee pu taꞌarorahara. ");
INSERT INTO mcq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ꞌEnakaivo ea mapoka mapoka parui napari Natohwiji nimaa rojajija roe ijí huri ahumahume ajima vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ea pu atama ꞌuniraviꞌina mapoka puni suha ateha ꞌeka roe ꞌunamu toi kajino irechama apene vaꞌejuꞌe Pitara puni rori vaꞌe huni ꞌavenijara atami ꞌuniraviꞌina kajihi puni hura kaji niha rene raurihuna. ");
INSERT INTO mcq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ea mapoka Jerusaremi rori hijujipo ea puna kaꞌene atami ꞌuniraviꞌina ꞌee ꞌavena sisea ajimaꞌina aherama roume pu ꞌuꞌo vejume mahoꞌo maraniara. ");
INSERT INTO mcq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ꞌEꞌeme pirisiti natohwa ꞌee ea kaꞌene Sajusia puꞌúmo nihoꞌo ajinamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ꞌEjumakame pu ꞌurine apasorua ꞌunirame ꞌeke vaꞌe tipurai irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ꞌEnakaivo naꞌii Natohwi jihuni ꞌona ojiꞌini roe tipura ara kajihuni vwicha tirasaꞌi kaivo aherama roe maꞌahi irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ꞌEꞌikaꞌi ijá ꞌiava Ja vaꞌe Temiporu vaji namine ea mapoka majama hihuni vuꞌa kaji najaꞌavara ꞌiavume ");
INSERT INTO mcq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","pu ijí hene ꞌurijajaho súꞌu súꞌu vea maiꞌo ahara sama kamino vaꞌe Temiporu vaji najahara. ꞌEꞌeme pirisitia natohwa ꞌee puni ehijijipo Isureri opuni emaa ꞌumenaume roe rira kwino ahuma hiꞌi kaivo ea irechamiume tipurai hiju roꞌikaꞌi aheraꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ꞌEnakaivo ea kaꞌene tipura ꞌajohiꞌinijipo vaꞌe kivara tipura vaja pakimareja roe ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ꞌEnareja ijá ꞌiava Nú kavajaho vwicha roku vene kisimaꞌura vejume naꞌeme ea kaꞌene tipura ꞌajohiꞌinijija vwicha jiama kajino namijara kaivo nú vwicha tiraha aruma vaꞌajaho ea pina nihoꞌo ijaho vaja pahinana ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ꞌEjume pirisiti mamaꞌinijija ꞌee Temiporu puni hirisima vuꞌa kaji henareja pu vwihajume puruva rejume ijaho ichá rene aranane ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ꞌEꞌeme ea kwino roe ijá ꞌiama Heha! Ea kaꞌene jara tipurai irechamiajaho Temiporu vaji namine vuꞌa ea najahu ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ꞌEjume hirisima natohwijaho ꞌee huni hirisima vaꞌe pu aheramana kaivo pu ea mapoka juhamareja harura pavene irisava jihuni maijaho ea mapoka kaꞌene puni vuꞌa heja kajipo muni ꞌeke ꞌanihuna vwihanareja ijihunaꞌe masuanuꞌwi aheravara. ");
INSERT INTO mcq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ꞌEnakaivo pu aherama roe kanisoru puni unaꞌi irechamiume namijumakiviꞌi pirisiti ꞌajohiꞌina natohwi jihipuni unaꞌi irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nú ja tanuꞌurihe ja Iha Ikaho paꞌurahiꞌi ea najahuna ꞌwaravara kaivo kaha! Jara najahu kajara Jerusaremi rarena parananaꞌomo nú Ea kajaho ꞌanaume kwamana ꞌwame namuhu ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pitaho ꞌee apasoru ijipo eha vene ijá ꞌiava nú Godoni iraru hene vehuna kaivo emaapuni ira pahehuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Núni omijihipuni Godijara ja Jesu kaꞌene korosi ꞌahi ꞌanaume kwavume Hu vejume ꞌurinana. ");
INSERT INTO mcq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ꞌEnarena Hu Godira ꞌunama apene Huni ija manaꞌinijaꞌi ranavuꞌe Natohwa rene niꞌajihiꞌinaꞌe renanaꞌomo Isureri ora puni sisea taꞌarohe aremamaa areꞌavajaho Hu vwihania arehuna. ");
INSERT INTO mcq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ꞌEnaꞌomo nú raka kaꞌene Hu venuji kama hejaji rone ja najahu. Godoni ꞌAveniji ꞌuꞌuna. ꞌEnaꞌomo Godira ea irahipo Huni ira hene vejuji Hu mihuna. ");
INSERT INTO mcq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Vea kaꞌene kanisoruepo ijí hejajaho nihoꞌo oja vaja ꞌuhusamiume pu apasorua kajija ꞌania kwamasaꞌavarono vejara. ");
INSERT INTO mcq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ꞌEnakaivo Parasia pina huni iha Kamerieriho tamanaꞌe najahiꞌinaꞌomo ea mapokaꞌe huni hura vejiꞌina. ꞌEnaꞌomo ijara ꞌurí arini namiꞌikaꞌi ijá ꞌiama Pu irechamie maꞌahi maꞌuako vaꞌava ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ꞌEjume hu ijá ꞌiama Ja Isureri orakúne hami hami vwihaje areri reꞌeje ijiꞌa ja unenuꞌu pina pu vetiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ja nitama nihejara ea iha Tutasi oni pinana ꞌurine ijá ꞌiama Na harura rukina ꞌiꞌi kaivo ea mapoka mapoka (400) aherama vaꞌana kaivo ea ꞌahopo hu ꞌanaume kwamana. ꞌEjume ea kaꞌene hua nimaa rojajaho juhaha ani va ranavara. ꞌEꞌeme kaukara kaꞌene pura vejajaho paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ijihuni túnaꞌi ea tahari veijino Jutasi Karari orijihuni pinana ꞌurinana. ꞌEnarena hu ea mapoka aherama vaꞌana kaivo ea ꞌahopo hu ꞌuꞌo ꞌanaume paꞌarenana. ꞌEjumakame ea kaꞌene hu nimaa rojujaho juhaha ani va ranavara. ");
INSERT INTO mcq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ijá vejaraꞌomo iviamaa na ja ꞌwaravu. Ja ea ikihi puni rora paruvaꞌavara kaivo makiꞌeje pu pupuso hija. Ijihuni maijaho pura raka kaꞌene vwihane vejujaho ema puni rena roanaꞌe reꞌamajaho roe paꞌarehuna. ");
INSERT INTO mcq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ꞌEnakaivo ijaho Godona reꞌamajaho jara ei pini tanuhuna areria paꞌana. Ijihuni maijaho vejuroꞌi ja Godiꞌi puꞌúmo ꞌaraha veꞌejakúne ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ꞌEjume pu huni vuꞌa kaji henareja ijiꞌa ꞌumenaume apasorua kajija roara. ꞌEjume pu hijihaꞌi kaivo ira kisinaꞌe ꞌwarame tanuꞌurihe ijá ꞌiva Ja kúꞌo Jesuni ihijaho paꞌurahiꞌi ea najaꞌavara ꞌiꞌi kaivo irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pu kanisoru puni unaꞌi areꞌi kaivo arihe temarajiꞌi vaꞌajihuni maijaho pu Jesuni ihijihunaꞌe ea pu siseꞌi ꞌahie ꞌee juha apeja jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ꞌEjumakame pu veku veko Temiporu vaja ꞌee sea sea ijino Jesuho Kerisona ꞌiaviꞌi najahe ꞌee ꞌwarame apene ojara. ");
INSERT INTO mcq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ijiha kajaho tisaiporua mapoka rena ajima vaꞌeme Kuriki Jua ꞌee Hipuru Jua chicharavara. Ijihuni maijaho puni amuniji na veku veku ꞌiruma swara vejujaho vene asitahu jihunaꞌe avajara. ");
INSERT INTO mcq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ꞌEjume ea iropu ropu noꞌo ijipo ꞌumenaume tisaiporu ꞌahoꞌa roume ijá ꞌiava Nú Godoni ira paꞌwaraꞌikaꞌi hine ꞌiruma vajihiꞌi hihuna areria pareꞌena. ");
INSERT INTO mcq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ꞌEnakúne vwehu núne joni vaja kajino ea iropu noꞌo ea kaꞌene Godoni ꞌAveni ruha apena parajiꞌina ꞌee iha mamaa ꞌee hami hami vwihajiꞌinijino pijihakame ijipo ike kaukara ikaho ꞌajoꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ꞌEjakame nú onúno naꞌia mapoka siporua ꞌoꞌone Godoni vuꞌa ꞌwarahunakúne ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ꞌEjume ea mapoka ijí vuꞌa kajaho ura renana. ꞌEjumakame pu Sitivini iji pijahara. Hu nimaa rona parajiꞌine ꞌee Godoni ꞌAveni huni oja vaja rarena parajiꞌinaꞌe pijahara. Ea pina Piripune ꞌee Pokorasine ꞌee Nikenorine ꞌee Timonine ꞌee Paramenasine ꞌee Nikorasina. Nikorasiho Enitioki ora kaivo hu va Jua renarenaꞌomo Godoni ea rene ijí Jua puꞌúmo hinana. ");
INSERT INTO mcq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ea kija aherama roe apasoru puni unaꞌi irechamiume pu ea kajihipuni siporua ꞌone ꞌee ija húmata ꞌahi irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ꞌEnajihunaꞌe Godoni ira rausaha apene kwaa ara mapoka vaꞌana. ꞌEjume pirisitia mapoka ꞌuꞌo nimaa rojara. ꞌEne ea kaꞌene Jerusaremi hijujija nimaa nimaa rojiꞌina mapoka mapoka rejara. ");
INSERT INTO mcq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiviniho maiji vwihaniiꞌina rarena parane ꞌee harura rarena parana jihunaꞌe Hu aacha ani aniꞌina vene ꞌee uneunecha kaꞌene ea areri pavehunijija epuni vaji vejume rejara. ");
INSERT INTO mcq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ea ꞌahoꞌa Sinakoku Kaꞌene Ripotini ꞌwavuraꞌomo pu Sairini ora ꞌee Arekisanituria ora ꞌee Sirisia ora ꞌee Esia rene roajipo ꞌurine Sitivini puꞌúmo nakaravara. ");
INSERT INTO mcq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Godoni ꞌAveni vejume Sitiviniho ꞌwaramana. ꞌEjume huni vwiha mamaa kaꞌene hura oja ꞌavenijiꞌi ꞌwaramajaho pu areri rarena ꞌwarahuna areri parejara. ");
INSERT INTO mcq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ꞌEjume pu ea ꞌahoꞌa ꞌimenae ꞌwaravume pu ijá ꞌiava Nú heꞌejuꞌe hu hine Mosisiꞌo Godiꞌo matihana ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ꞌEjumakame pu eaka ijihipuni oja ijumakame ea mamaꞌina ꞌee Sikuraipia ijipo roe hu ꞌunama tairia apene kanisoru puni unaꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ea ꞌahoꞌa vuꞌa iraꞌata ꞌwaraꞌavarono irechamiume vaꞌe ijá ꞌiava Ea ikaho Mosisi oni tamaneꞌo ꞌee ruha akuaviꞌinikaho naꞌia mapoka mapoka hine matihuna. ");
INSERT INTO mcq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ꞌEnareꞌe nú hejuꞌe hu ijá ꞌwaramuna Jesu kaꞌene Nasareti orijara ijí arakaho tirakune ꞌee Mosisi oni tamana kaꞌene hu nú vajúhajaho ꞌeka arohe ani ꞌwaramu ꞌiamuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kanisoru kaꞌene hija kajipo kavume huni ura niijaho areri onaꞌojiꞌina puni urania kivuja renana. ");
INSERT INTO mcq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ꞌEjume ea kaꞌene pirisiti natohwijara ijá ꞌwama ꞌÚ ikaho nimaae? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ꞌEjume hu ijá ꞌiama Heha! Vwehu nuna ꞌee emahu nunakije ja nuni irake hami heha. Nitama Eparahami kaꞌene núni omijaho maiꞌo Herani pavaꞌikaꞌi Mesopotemia hinajiri Godi kaꞌene hanajiꞌinijaho huni roana. ");
INSERT INTO mcq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Hu ijá ꞌwama Oni amuhija irechamie ꞌee oni kwaa areꞌi kaivo ꞌurine vaꞌe kwaa kaꞌene Nara najaꞌujino hiꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ꞌEjume hu Karutia opuni kwaa areꞌi kaivo vaꞌe Herani hinana. ꞌEꞌeme Eparahami oni oma kwavumakaviꞌi Godira hu vejume ꞌurina roe iviamaa kwaake nú hijukino hinana. ");
INSERT INTO mcq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ꞌEnakaivo Hu mweꞌa pina nihoꞌo humaa pamahana. ꞌEnakaivo hu mají apehuna pana. ꞌEnakaivo Godi túnaꞌi humaa mahuna nahama ꞌwaramana. ꞌEnaꞌomo Hu huni amuhi jihipuni rehuna kaivo Eparahamiho maiꞌo amuja pavenana. ");
INSERT INTO mcq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ꞌEne Godi ikaꞌina ꞌwaramana. Juara mapoka mapoka (400) vaja kajino oni amuhijijija ea ꞌahopuni pwea rene ꞌee sisei hihuna. ");
INSERT INTO mcq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ꞌEnakaivo túnaꞌi ara irahipuni pwea ja reꞌavajaho Na ꞌotua vetihuna. ꞌEnakaivo maiꞌo túnaꞌi pu kúꞌo ꞌunama roe kwaa ikino hine Na oja mihe Nuni kaukara vehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Godira hu sisa ꞌuhuahuna maka nahana. ꞌEnaꞌomo Eparahami Aisiki oni oma renana. ꞌEne hu naꞌia iropu noꞌopisu paꞌareꞌeme hu huni sisa ꞌuhuahana. ꞌEjume Aisikiho Jekapi oni oma renana. ꞌEne Jekapi ea mamaꞌina iropu ropu noꞌo puni oma renana. ");
INSERT INTO mcq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Amuhu núna ea mamaꞌina kajipo Josapi siseꞌi ꞌahae apena vaꞌe ea ꞌahoꞌa ꞌimenaara. ꞌEjume pu apene Ijipiti vaꞌara kaivo Godi hu huꞌúmo hinana. ");
INSERT INTO mcq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Hu sisei hinajaho Godira niꞌajahana. ꞌEjume Godira vejume Josapi vwiha maa vwihajiꞌina rejume Perora Josapi ura renajihunaꞌe Ijipiti opuni ꞌajohiꞌina reꞌamarono Pero iji pijahana. ꞌEnareje Perora oni sei uneunecha mapoka kaꞌene navuji ꞌajohiꞌina reꞌamarono iji pijahana. ");
INSERT INTO mcq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ꞌEꞌeme Ijipiti kwaa ꞌee Kenani kwaa ꞌoravea renarena ꞌiruma paꞌare ranamana. ꞌEjumakame amuhu núna kwaa kaꞌene ꞌiruma ꞌekahunijaho nihoꞌo paꞌarejumakame sisesei hijara. ");
INSERT INTO mcq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ꞌEjume Jekapi henajaho ꞌiruma Ijipiti navuma henarena marakuꞌa omahu núna irechamiume ijí vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ꞌEnaꞌomo vukúꞌo ꞌaha pini vaꞌajino Josapi popwaha hu nahama ꞌwaramana. ꞌEnarena Pero roume ꞌwaravumakame hu Josapi oni vwehija hena kimana. ");
INSERT INTO mcq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ꞌEjume Josapi ꞌona ꞌwaramana. Huni oma kaꞌene Jekapi ona ꞌwaravakame huni kachiꞌina mapoka kajaho ijá nianae Ijipiti roꞌavarono ꞌwaramana. Pu ijaho ea niꞌaha kwino mapoka mapoka (75). ");
INSERT INTO mcq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ꞌEnaꞌomo Jekapi Ijipiti vaꞌe hu amuhu núnijihi puꞌúmo kwamasahara. ");
INSERT INTO mcq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ꞌEjume puni hahijaho ꞌeka vaꞌe kwaa iha Sekemi irechavara. Ijí muna ara kajaho Sekemi Eparahamira Hemori oni harihijihi puni ꞌimena apenana. ");
INSERT INTO mcq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Godira Eparahami nahama ꞌwaramajaho roa tuꞌu reꞌeme Isureri ora Ijipiti ea mapoka tuamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ꞌEꞌeme kinia pina kaꞌene Josapi pahena pakaviꞌini Ijipiti opuni kinia renana. ");
INSERT INTO mcq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ijí ea kajara núni amuhija pisiviꞌi rurahana ꞌee hu emahu núna siseꞌi ꞌahie ꞌee venaume sesahwaha samai kwamasaꞌavarono irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ijihuni vea kajiri Mosisiho nahejara. Hu nihoꞌo hariha ꞌuꞌua mamai jihunaꞌe Godi hu ura renana. ꞌEjumakame emahwapo puni seijino nesi hami ꞌajoꞌeme masapa noꞌopisu paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ꞌEjumakaviꞌi pu apena vaꞌe samai ranavajaho Pero oni ꞌapajijara kama apene vaꞌe huni hariha vena pimana. ");
INSERT INTO mcq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hu ijí sikurua vene ꞌee Ijipiti opuni henakaꞌa mapoka kajaho he parane ꞌee hura raka kaꞌene ꞌwarame venujaho harurijiꞌi venuna. ");
INSERT INTO mcq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ꞌEꞌeme hu juara mapoka mapoka (40) reꞌi veꞌeme hu ehwaha kaꞌene Isureri oni harihija kiꞌi ꞌahaume vwihanana. ");
INSERT INTO mcq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ꞌEnarena hu vaiꞌi kimajaho huni ea pina Ijipiti ori vuꞌa paꞌa apene rurahuma kamana. ꞌEjumakame hu ijara sevume ꞌurine hua vahame Ijipiti ora kajaho ꞌanauma kwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Godi hu iji pijahume ehwaha kaji niꞌajiꞌi roaji pu heꞌavarono ea kajaho hu ꞌanaana kaivo pu nihoꞌo ijaꞌina pavwihajara. ");
INSERT INTO mcq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ꞌEꞌikaivo Mosisi ijihuni súꞌuhijino Isureri ora noꞌoheꞌi ꞌaraꞌeme hu ijí vaꞌana. ꞌEnarena hu vaꞌe areꞌavarorena rurame ijá ꞌiama Ja noꞌo vweꞌuneꞌi raka vene ꞌaraho? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ꞌEnakaivo ea noꞌo ꞌaraha kajipo ea kwinu Mosisi vajama piꞌonaꞌikaꞌi ijá ꞌwama Irara a venaume a roe nú ꞌajohue ꞌee namui roane? ");
INSERT INTO mcq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A niari Ijipiti ora ꞌanaajaꞌinaꞌe na ꞌaniꞌiro avano? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ꞌEjume Mosisi ijí hene Ijipiti opuni kwaa areꞌi kaivo aseha vaꞌe Miriani opuni kwai hinana. ꞌEnarena hu ijí hiꞌeme harihwaha noꞌoheꞌi rejara. ");
INSERT INTO mcq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Hu ijí hiꞌeme juara mapoka mapoka (40) paꞌareꞌeme Godoni onaꞌojiꞌina huni roe huriꞌa Sainai nechiꞌi icha oma rukina veni reꞌejuꞌe hu ijihuni vaji naminana. ");
INSERT INTO mcq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ꞌEjume Mosisi ijí kamarena Vi ijaho rakina? ronarena nihoꞌo niꞌimaꞌura oja hwaꞌusahana. ꞌEnarena hu ura vaꞌe nini kaꞌi ꞌahaume vaꞌeme Natohwi jihuni ira roana. Hu ijá ꞌwama ");
INSERT INTO mcq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Na oni opijijihi puni Godia. Na Eparahami oni Godi ꞌee Aisiki oni Godi ꞌee Jekapi oni Godia ꞌwamana. ꞌEjume Mosisiho simame ꞌee tea juvume ijaho nia pakamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ꞌEjume Natohwijara hu ijá ꞌwama Oni mumora hwana jahena. Ijihuni maijaho ara ruha kaꞌene naminujaho akuavuri mweꞌa sisa ꞌahi naminu. ");
INSERT INTO mcq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Pu Nuni ehija kaꞌene Ijipiti opo siseꞌi ꞌahiajaho Na nikivuta. Pu niramaruvaji ꞌuꞌo Na nihejuta. ꞌEnarejo ijihunaꞌe Na pu niꞌajiꞌi routa. ꞌEnakúne a roe Na ranamae Ijipiti vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ike Mosisiho pura hu pataꞌarohe ijá ꞌwava Ea irara ꞌwaravume a roe nú ꞌajohue ꞌee namui roane ꞌwavajina. ꞌEnaꞌomo Godira hu kúꞌo ranavume vaꞌe Isureri ora ꞌeke ꞌajoꞌamarono Huni ꞌona ojiꞌina kaꞌene nechiꞌi icha vaji Godira vejume vena rejumakaviꞌi ranavume ijihuni vaji naminajara niꞌajahana. ");
INSERT INTO mcq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ꞌEjume ea ikara Ijipiti vaꞌe vejume aacha ani ani ꞌee ea areri pavejujija vejiꞌi Isureri ora aherama vaꞌe soha kaꞌene iha Aviꞌina ꞌwavujaho vejume ꞌunama reꞌeme pu vaꞌe juara mapoka mapoka (40) nechiꞌa kaji hina ojara. ");
INSERT INTO mcq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ike Mosisi ikara Isureri oni harihija ijá ꞌiama Godira poropetia naaꞌina joni vwehipuni vaji veje rene roajihuna. ");
INSERT INTO mcq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ꞌEjume ike ea ikara ea mapoka pu puꞌúmo nechiꞌi ahuma hiꞌeme huriꞌa Sainai ꞌona ojiꞌini vuꞌa ꞌwaramana ꞌee hu emahu nú puꞌúmo hine ꞌee hu vuꞌa kaꞌene majama hihuna ja vajihunaꞌe vajahana. ");
INSERT INTO mcq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ꞌEnakaivo núni amuhijihija pu Huni vuꞌa paheꞌi kaivo pu Hu vajama piꞌonavara. Pu Ijipiti oja vwihanareja pu ura Ijipiti ꞌunama vaꞌi ꞌahiara. ");
INSERT INTO mcq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ꞌEꞌikaivo pu Eroni ijá ꞌwava Núni godi ꞌahoꞌa vejakame pura uranúhe aheruma vaꞌa. Mosisi nú aheruma Ijipiti arema roara kaivo hu iraki renajaho nú puruva renúu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ijihuni vea kajino pu unenuꞌu pina apene purumakau ꞌuꞌua punaꞌi vene swasa ꞌeke ijí godi iraꞌata kajihuni roara. ꞌEne pura puni iji veja kaji kimareja nihoꞌo mariꞌuvara. ");
INSERT INTO mcq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ꞌEjumakame Godi pu túchahie pataaroraꞌi ija irechamiume pu china masapa vea ijihi oja mihara. ꞌEjumakame areri poropetiepo heha vaji vena ꞌwarava jaꞌinaꞌe renana. ꞌÚ Isureri ora ja juara mapoka mapoka (40) nechiꞌi hinojajino swasa kaꞌene vejajaho núnaꞌe vejare? ");
INSERT INTO mcq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pana kaivo ja Moraki opuni harai ara vene china kaꞌene Romapa joni godi rene unenuꞌu ꞌahoꞌa ꞌeke vejuꞌe unenuꞌu ꞌahoꞌa punaꞌi rejuꞌukiviꞌi nuana vetie ijihipuni swasa vejujihunaꞌe Na ja irechamie ja Papirani asima hanaꞌi vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ꞌEnaꞌomo emahu núpo harai ara kaꞌene nechiꞌi vejajaho ea najahareje Godira ijihuni vaji vuꞌa ꞌwaramuna. Areri Hura Mosisi naharena veꞌamarono ꞌwamajaꞌinaꞌe venana. ");
INSERT INTO mcq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ꞌEne emahu núpuni vea rejume pu Josua puꞌúmo apene roꞌeme Godira ara ꞌahosura kajija emahu núpuni unaꞌi atoꞌarumaume useꞌeme ijí nama apene rou vaꞌo roe Teviti oni vei usevara. ");
INSERT INTO mcq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Godi Teviti kamareꞌe teamama paranuna. ꞌEnaꞌomo Tevitira Jekapi oni Godi ijihuni harai ara veꞌirono Godi apomana. ");
INSERT INTO mcq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ꞌEnakaivo Saramanira arijaho venana. ");
INSERT INTO mcq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ꞌEnakaivo Natohwa kaꞌene ichuto maijaho emaapo ara kaꞌene iji vejujaho pahinuna. Areri poropetijara ꞌwaramajina. ");
INSERT INTO mcq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Akúpa ꞌahijaho Nuni asuma hijuri ruhijina kaivo mweꞌijaho Nuni mumora ranavuri ruhijina. ꞌEnaꞌomo ja ara icháꞌina Nuna veniꞌeja? Natohwijara ijá ꞌiama Nuni ruha kaꞌene Nara ꞌojuta hwehunijaho ichine? ");
INSERT INTO mcq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nuni ija uneunecha kihija mahoꞌo pavejuta raka? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ja nihoꞌo vuꞌataa pahejiꞌina ꞌee joni oja kisimaꞌuri jihunaꞌe ja nihoꞌo pahena paraju. Emahu jopo Godoni ꞌAvena pataaroha jaꞌinaꞌe ja ꞌuꞌo pataarohu. ");
INSERT INTO mcq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Poropetia ea irahijaꞌe emahu jona sisei paꞌahiare? ꞌEjume pu Ea kaꞌene arimaijara rohuniji ꞌwaravajija ꞌaniume kwamasahara. Ja Ea kaji nahamahe ꞌanaume kwamajihina. ");
INSERT INTO mcq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ja ea kaꞌene tamana ꞌekujihi Hu Huni ꞌona ojiꞌinaꞌe vajihuꞌe ꞌeka roura kaivo ja panimaa rone ꞌee vejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ꞌEjume pu ijí henareja Sitivini ajinama oja ꞌuhusamia paraꞌejume upaja jaꞌiujume chanichani vajaꞌeme kavara. ");
INSERT INTO mcq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ꞌEnakaivo Sitiviniho oja vaja Godoni ꞌAveni ruha apena parajumakame akúpa ꞌahi nia nirinama kavume Godoni hanajiꞌina kame ꞌee Jesuho Godoni manaꞌinijaꞌi naminana. ");
INSERT INTO mcq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ꞌEjume hu ijá ꞌiama Kaha! Na kaꞌejuꞌe akúpa ꞌaha vwicha jaraꞌejuꞌe Emaa Puni Hariha Godoni manaꞌinijaꞌi naminu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ꞌEnajihunaꞌe pu ira ajira ananajaꞌikaꞌi ataa pijuturame niꞌaha kwinu ꞌurimaravajino ninukujaha vaꞌe pu hu ija ija ꞌunavara. ");
INSERT INTO mcq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pu hu ꞌunama piijahe apene samai vaꞌareje muni ꞌeke ꞌanaꞌeme kivasa kwinu ijí puni rori namiꞌeme pu puni ateha jahene huni una kaji irechavara. Ea kajihuni ihijaho Soruna. ");
INSERT INTO mcq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sitivini muni ꞌanaumakiviꞌi hu Natohwiji ꞌurahe ijá ꞌumena Natohwa Jesu nuni ꞌavena apeꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ꞌEꞌikaivo hu aruha arihiꞌi ira ajira ijá ꞌumenane Natohwe pu na siseꞌi ꞌahiukúne A pu eha pavetia ꞌumeꞌi kaivo kwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ꞌEjume hu ꞌanaume kwamajaho Soru oja vaja teamama paranana. Ijí vea kajaho sosia kaꞌene Jerusaremi hijujaho ruarahume sisei hijara. ꞌEjume pu ꞌoiꞌoi ea ꞌahoꞌa Jutia vaji vaꞌume ꞌee ea ꞌahoꞌa Sameria vaꞌeme apasoru eru irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ꞌEꞌeme ea kaꞌene Godi oja mahiꞌinapo Sitivini oni haha apena vaꞌe ranavara. ꞌEnareja pu nihoꞌo huamu vene niramaruvara. ");
INSERT INTO mcq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ꞌEꞌeme Soruho aneja vene sosi ruarahiana. ꞌEne sea sea kaji ajime napara parui irisame ꞌeka vaꞌe tipurai irechamiana. ");
INSERT INTO mcq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ꞌEꞌeme ea kaꞌene ani ani vaꞌa kajija hine Godoni vuꞌa ea najahara. ");
INSERT INTO mcq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ꞌEꞌeme Piripuho Sameria vaꞌe aneja vene Keriso rone najahana. ");
INSERT INTO mcq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ea mapoka kaꞌene ijí Piripu ipuꞌúmo hija kajija pu oja ꞌee vwiha kwisu rene hura ꞌwarama kaji hene aacha ꞌee uneunecha kaꞌene hura vejume ani ani reja kaji pu kivara. ");
INSERT INTO mcq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ea ꞌavena sisea ꞌajimaꞌina mapoka ijí hijaraꞌomo Hura venaume ijí ꞌavena sisea kajipo nihoꞌo ajira emaavaraꞌi kaivo ariha vaꞌara. Ea ꞌahoꞌa irimaꞌina ꞌee haha ajuaraniꞌina vejume marasahara. ");
INSERT INTO mcq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ꞌEꞌeme kwaa kajaho nihoꞌo niꞌimaꞌuraꞌe temarasahara. ");
INSERT INTO mcq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ea pina huni iha Saimaninaꞌomo hu nimako atama vejiꞌina ea niꞌina iaviꞌi ara kajino hijuꞌe Sameria ora oja hwaꞌusahura. ");
INSERT INTO mcq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ꞌEjume pu mahoꞌo sesamai rene vaꞌe emakini hu taꞌarohe ijá ꞌwavure Hu Godoni harura niꞌimaꞌura ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Hu nitama rene atama ani ani vejuꞌe pu kavujihunaꞌe pu hami huni vuꞌa hejura. ");
INSERT INTO mcq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ꞌEnakaivo vea kaꞌene Piripura Godoni vuꞌa maiuꞌina kaꞌene Godoni arijihuna ꞌee Jesu Keriso oni ihiji rone ꞌwaramajaho pu nimaa rojara. ꞌEjume hu parui napari ahuma toi samahara. ");
INSERT INTO mcq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ꞌEjume Saimani ꞌuꞌo nimaa ronajihunaꞌe hu toa apúsavume Piripui ahuma ꞌuraha ojiꞌi hura aacha ꞌee uneunecha kaꞌene ea areri pavehuna mamaꞌina venaji kimarena oja hwaꞌusahana. ");
INSERT INTO mcq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apasoru kaꞌene Jerusaremi hijajipo hejajaho ea mapoka kaꞌene Sameria hijajija Godoni ira hene apejuma henareja pu Pitaꞌo Joniꞌo irechamiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ꞌEnareja pu noꞌo vaꞌe ijí ea kaꞌene Godoni ira hene nimaa roja kajipo Godoni ꞌAvena apeꞌavarono pu puni siporua ꞌojara. ");
INSERT INTO mcq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Hu maiꞌo puni vaja ruha paapenana kaivo pu Natohwa Jesuni iha ꞌahijino toaru samaara. ");
INSERT INTO mcq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ꞌEnajihunaꞌe pu aneja vene puni ija ea kajihipuni húmata ꞌahi irechamiume Godoni ꞌAvena apejara. ");
INSERT INTO mcq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimani hina kiꞌeme apasoru kajipo ija irechamiꞌeme Godoni ꞌAvena ea samahuma kimarena hu monia ꞌeka roe ꞌimeꞌi ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ꞌEꞌikaivo ijá ꞌiama Harura kaji na ꞌuꞌo miha ꞌeꞌirakúne na ea irahijaꞌe ija irechamiujaho pu Godoni ꞌAvena apeꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ꞌEjume Pitara hu ijá ꞌwama Oni monia kajiꞌi kwaꞌena. Ijihuni maijaho a vwihanajaho Godoni swarijaho moni ꞌimejura ronuna. ");
INSERT INTO mcq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A ikehuni pwina pana. Ijihuni maijaho oni oja maiꞌo Godoni unaꞌa arira pana. ");
INSERT INTO mcq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ꞌEnakúne oni sisea kaꞌene oni oja vaji namujaho vwihane aremamaa areꞌi kaivo taꞌarohe Natohwi jihuni siporua ꞌojakame Hura vwihanae areꞌamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na kavuꞌe oni oja vaja kamaꞌajaho nihoꞌo sisea namunaꞌomo ijara a kamoramu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ꞌEjume Saimanira eha vene ijá ꞌiama Ijinakúne ja Natohwi jihunaꞌi nuni siporua ꞌoniha! ꞌEjakame uneunecha kaꞌene jara ꞌwarivu kajaho nihoꞌo pina nuni haha ꞌaha pareniꞌama ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pu noꞌo Natohwi jihuni vuꞌa ꞌwaravume paꞌarejume pu kúꞌo ꞌunama Jerusaremi vaꞌiro vaiꞌi Sameria opuni araka mapoka kajino Godoni vuꞌa kajaho najaha apene vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ꞌEꞌeme Natohwi jihuni ꞌona ojiꞌinijara Piripu ijá ꞌwama ꞌUrine iki kami nechunama kaꞌene vaꞌe Jerusaremi ꞌuseme vaꞌu kajino ariha Kasa vaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ꞌEjume Piripuho ꞌurine vaꞌu vaꞌume ꞌunamutoi Uniki pina Itiopia ora piunamana. Ea kajaho Kanitasi kaꞌene Itiopia opuni kwinijihuni moni ꞌajohiꞌinaꞌomo hu Jerusaremi Godi oja maꞌirono roana. ");
INSERT INTO mcq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ꞌEnaꞌomo hu kúꞌo huni ari vaꞌirono huni chariati vaji asuma hijiꞌi poropeti Aisea oni puka tahana. ");
INSERT INTO mcq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ꞌEꞌeme Godoni ꞌAveni Piripuho ijá ꞌwama Vaꞌe chariati ꞌaha kajino hu huꞌúmo ahuma hina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ꞌEjume Piripu ninuma ajima vaꞌi hejume hu poropetia Aisea hine tahume hu ijá ꞌwama ꞌÚ a raka kaꞌene tahu kajihuni maijaho a niheno? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ꞌEjume hu ijá ꞌwama Na icháꞌina heꞌejo? Ea ꞌahopo najiharaꞌomo na ijihuni maa heꞌejo? ꞌwaꞌi kaivo Piripuho ꞌwaravume ajima vaꞌe hu huꞌúmo asuma hinana. ");
INSERT INTO mcq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ijí puka vaja kajino hura Godoni ira kaꞌene tahajaho ikena. Hu sipia ꞌaniꞌirono ꞌeka vaꞌujaꞌinaꞌe ahema vaꞌara ꞌee areri sipia ꞌuꞌua sapasa usimahiꞌini jihuni unaꞌi ira paꞌarene naminu jaꞌinaꞌe Hu ira paꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hu juha natohwaꞌe apenana. Ijihuni maijaho pu Huni ꞌotua hamia pahejara. ꞌEnajihunaꞌe Huni ei pini hene huni vuꞌa kaji ꞌwarahuna paꞌana. Hu ikino mweꞌi hinujaho pu niꞌanaume kwama vaꞌume paꞌarenana vejaraꞌe tahana. ");
INSERT INTO mcq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ꞌEnarena ijí Unikia kajara Piripu eha vene ijá ꞌwama Poropetia kajaho hu hunaꞌe rone ꞌwaramana ꞌaho ea pina rone ꞌwaramane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ꞌEjume Piripuho Godoni vuꞌaka taha kaji aneja vejiꞌi Jesu rona ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ꞌEnareja pu ꞌunamutoi vaꞌari vaja kajino roe toa rori useviꞌi Unikia kajara ijá ꞌwama Kama! Toa karena kaivo rakijara tanuꞌurihuꞌe na toa paapúsamiꞌena? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ꞌEjume Piripu ijá ꞌwama A oni ojijiꞌi nimaa rona paraꞌamajaho a arerina. ꞌEjume hu eha vene ijá ꞌwama Na nimaa roju. Jesu Kerisoho Godi Oni Hariha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ea kajara ꞌwaravume chariati namiꞌeme pu noꞌo Piripui ariha vaꞌume ea kajaho toi ꞌunamape apúsamana. ");
INSERT INTO mcq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ꞌEnareja pu kamino toa vaji rene ajiru useꞌeme Natohwi jihuni ꞌAvenijara Piripuho apene vaꞌana. ꞌEjume Uniki kajaho kúꞌo Piripuho pakamana. ꞌEnarena hu temarajiꞌi huni ꞌunama vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ꞌEꞌeme Piripuho oriꞌini kakaramajaho hu Asotasi naminana. ꞌEnarena hu araka mapoka kajino Godoni vuꞌa najaha apene onu vaꞌume ijiꞌa Sesaria roana. ");
INSERT INTO mcq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ꞌEjume Soruho majama hine Natohwi jihuni tisaiporua juvu vuꞌa ꞌwarame ꞌee ꞌanie kwamasaꞌavarono vaꞌe pirisitia niꞌinijaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ꞌEjumakame hu pasia vene vajahe ꞌeka vaꞌe Tamasikasi Sinakoku mapokiji vajihe pu hu niꞌajahareje ea kaꞌene ꞌUnama ikehunake vejiꞌina parui napari piuniꞌavajaho pu ꞌeke Soru vajahe kamorame hura ꞌeka Jerusaremi rohuna. ");
INSERT INTO mcq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ꞌEjume hu Tamasikasi rori roꞌeme niꞌaha kwino akúpa ꞌahi rene hanane huni haha ꞌaha ꞌee huni rora kajaho hanana paranana. ");
INSERT INTO mcq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ꞌEjume hu mweꞌi ꞌojiꞌi hejume irijara ijá ꞌwama Soru Soru a rakijihunaꞌe Na siseꞌi ꞌahiu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ꞌEjume hu ijá ꞌwama Natohwe A rarane ꞌwavume Hu ijá ꞌwama Na Jesu kaꞌene ara siseꞌi ꞌahaujarana. ");
INSERT INTO mcq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ꞌEnakúne ꞌurinareje ari vaꞌa. ꞌEꞌeje ara iraka kaꞌene vehunijaho ijí ꞌwaraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ꞌEjume ea kaꞌene pu puꞌúmo vaꞌa kajija ijí ira paꞌwanamaꞌikaꞌi namine irijaho hejara kaivo ea haha pakavara. ");
INSERT INTO mcq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ꞌEꞌeme Soruho ꞌurinana kaivo huni niijaho nihoꞌo nutuvumakame uneunecha pakimana. ꞌEjume ea kajipo huni iji ꞌunama apena vaꞌe Tamasikasi ranavara. ");
INSERT INTO mcq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ꞌEjume hu naꞌia noꞌopisu nia panirie ꞌee ꞌiruma paine ꞌee toa painana. ");
INSERT INTO mcq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ꞌEnakaivo tisaiporu pina iha Ananaiasi ijino Tamasikasi hinanaꞌomo Natohujara visoni vaji ijá ꞌwama Ananaiasiꞌo ꞌwavume Ananaiasi ijá ꞌwama Natohwiji na ikeho hiju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ꞌEjume Natohwijara ijá ꞌwama A ꞌurine ꞌunama kaꞌene Arira ꞌwavujihunijiano vaꞌu vaꞌo vaꞌe Jutasi oni sei ea pina iha Soruho Tarasasi oraꞌomo hu ijí hine siporua ꞌojiꞌi hinu. ꞌEnakúne a vaꞌe kaꞌamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Hu ꞌuꞌo visoni kaꞌeme ea pina huni iha Ananaiasi ꞌwavujaho vaꞌe ijí arume huni ija huni haha ꞌahi irechavumakame huni nia kúꞌo niriana. ");
INSERT INTO mcq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ꞌEjume Ananaiasi eha vene ijá ꞌwama Natohwe na nihejuta. Ike ea kehuni vuꞌijaho hura Oni ehija kaꞌene Jerusaremi hijujihi ꞌeke siseꞌi ꞌahiajaho na nihejuta. ");
INSERT INTO mcq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hu ea kaꞌene pirisiti mamaꞌinapo harura mahume hu ea kaꞌene oni iha ꞌurahujihi kamorai roana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ꞌEnakaivo Natohwijara ijá ꞌwama Ijí ea kajihuni vaꞌa Nara hu Nuni kaukara veꞌamarono iji pijahutaꞌomo hu Nuni iha apene Jenitaru ꞌee kinia ꞌee Isureri oni harihija najahuna. ");
INSERT INTO mcq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nara Nuni ihijihunaꞌe hura haha niꞌimaꞌura kaꞌene hiahunijaho nahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ꞌEjume Ananaiasi sea kajino vaꞌe arumana. ꞌEnarena huni ija haha ꞌahi ranamahiꞌi ijá ꞌwama Soru vwea nunakera. Jesu Natohwa kaꞌene ara ꞌunamutoi kamajara na ranamiume routaꞌomo a kúꞌo nia niriꞌena. ꞌEje Godoni ꞌAvena oni oja vaja ruha apena parahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ꞌEjume Soruho niꞌaha kwino unenuꞌu pina kaꞌene huni nia ꞌahi namajaho ꞌoꞌeme hu ꞌurine nia kúꞌo niriana. ꞌEnarena hu ꞌurijume toi apúsavara. ");
INSERT INTO mcq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ꞌEnarena hu ꞌiruma ine harura apenana. ꞌEjume Soruho ijino Tamasikasi tisaiporu puꞌúmo naꞌia noꞌonaho noꞌopisu hinana. ");
INSERT INTO mcq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ꞌEnarena hu vaꞌe Sinakoku vaji aneja vene Jesu rone najahe ijá ꞌiama Hu nimaa nimaa Godoni Hariha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ꞌEjume pu ea ijí hene oja hwaꞌusunahaꞌeme pu ijá ꞌwava ꞌÚ ikaho ea kaꞌene Jerusaremi ea kaꞌene Jesu nimaa rojuꞌukame hu pu ruarahu jarane? Hu iviamaa iki roe ea kaꞌene Jesu nimaa rojiꞌinijihi kamorame vaꞌe Pirisiti mamaꞌini jipuni irechaꞌi roajaho ikene ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ꞌEnakaivo Soruho huni haha harura reꞌejume aneja vene Jua kaꞌene Tamasikasi hijujihi Jesuho Kerisona ꞌiavume pu nihoꞌo puruva retiara. ");
INSERT INTO mcq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ꞌEjumakame naꞌia mapoka paꞌareꞌeme Jua mapoka Soruho ꞌanaꞌirono ꞌwamapene ojara. ");
INSERT INTO mcq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ꞌEnakaivo pura raka kaꞌene veꞌiro vejajaho Soruho nihenana. ꞌEjuꞌukame pu hu ꞌanaꞌi ꞌahiuꞌe naꞌia veiriꞌa ijaho ara vwichia kajino ꞌajoha ojura. ");
INSERT INTO mcq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ꞌEjumakame Huni Tisaiporuepo apene namea vaji niarikara. ꞌEnareja ea kaꞌene vwicha ꞌajoha namija kajihi juhame apene vera ꞌaha kaji ajima vaꞌe karoꞌahuni apúsavume vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Vea kaꞌene hu Jerusaremi roajaho tisaiporu puꞌúmo ahui venana kaivo pu tea junamana. Ijihuni maijaho hura tisaiporuaꞌe renajaho pu panimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ꞌEjume Panapasira hu ahema apene apasoru puni roe hura Natohwiji ꞌunamutoi icháꞌina kaꞌene kavume Hura vuꞌa ꞌwaramana ꞌee Tamasikasi Jesuni iha ꞌahi pajuꞌikaꞌi ꞌwaramajaho ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ꞌEjume hu ijí pu puꞌúmo mataume Jerusaremi pajuꞌikaꞌi Natohwi jihuni iha ꞌahi vuꞌa ꞌwarame ojara. ");
INSERT INTO mcq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ꞌEnarena hu Jua kaꞌene Kuriki opuni iri ꞌwaravujihi puꞌúmo hina nakaravara. ꞌEjumakame pu hu ꞌunama kaꞌene ꞌanahuniji savara. ");
INSERT INTO mcq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ꞌEjume vwehwapo ijí henareja pu hu ahema kami Sesaria vaꞌara. ꞌEnareja pu hu ranavume Tarasasi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ꞌEꞌeme sosia kaꞌene Jutia hine Karari hine ꞌee Sameria hijujija matausaha hijiꞌi emarene ꞌee Natohwiji juhaviꞌi hijara. ꞌEjume Godoni ꞌAvenijara pu somaꞌejuꞌe ea mapoka rena ajima vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ꞌEꞌeme Pitaho ara ara kajino nimaa rojiꞌina kaꞌene hina apene oja kajihi kima apena onuvaꞌo Godoni ehija ꞌahoꞌa ijí Rita hijaraꞌomo kiꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ꞌEnarena hu ijí vaꞌe ea pina huni iha Eniasiho paꞌuraha oꞌi kaivo ijí sei vajaru hiꞌeme juara ija ronu noꞌopisu paꞌarenanaꞌomo ijaho piunamana. ");
INSERT INTO mcq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ꞌEnarena Pitara hua ijá ꞌwama Eniasi! Jesu Kerisora vejuꞌe sonahaukúne ꞌurina oni suha mwama ꞌwavume hu niꞌaha kwino ꞌurinana. ");
INSERT INTO mcq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ꞌEjumakame Rita ora ꞌee Sarani ora hua marana kaji kamareja pu niꞌaha kwinu mahoꞌo Natohwiji huni taꞌarohe ro ranavara. ");
INSERT INTO mcq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ara kaꞌene Japana ꞌwavujino tisaiporua pina Tapitana. ꞌEnakaivo Kuriki puni iri ꞌurahujaho Tokasina ꞌwavura. ꞌEnaꞌomo ike naparakaho hu ea hami ꞌahie ꞌee ea kaꞌene uneunecha paꞌajihi niꞌajihuna. ");
INSERT INTO mcq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ijí vea kajiha kajano hu atami ꞌunavume kwamana. ꞌEjume pu huni hahijaho apene toi rúrahareja ichutoi ruha pini ranavume namana. ");
INSERT INTO mcq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ꞌEnakaivo Japaho Rita rorinaꞌomo tisaiporu ꞌahopo Pitara Rita hinaji henareja pu ea noꞌo irechamiume vaꞌe mamako nú puꞌúmo roa ꞌwaꞌirono vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ꞌEjume Pitaho ꞌurine pu puꞌúmo vaꞌana. ꞌEnarena hu vaꞌe ꞌeꞌujume pu ahema ichutoi ruha pipunijino vaꞌara. ꞌEjumakame ijí amunaka mapoka kaꞌene Pita oni rori namija kajija ateha kaꞌene Tokasira hu maiꞌo hinani veijino vena useaji kima hine niramaruvara. ");
INSERT INTO mcq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ꞌEjume Pitara ꞌwaravume maꞌahi vaꞌumakiviꞌi hu atoki same siporua ꞌonana. ꞌEnarena hu ijiꞌa taꞌarohe napara kajihuni hahi namajaꞌi kaviꞌi ijá ꞌwama Tapita ꞌurina ꞌwavume hu nia jarae Pita kamajaho hu niꞌaha kwino ꞌurine arini hinana. ");
INSERT INTO mcq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ꞌEjumakaviꞌi hu huni ija mahume ꞌunama apena ꞌurijume hu niꞌaha kwinu ꞌuri arini naminana. ꞌEjumakaviꞌi hu ea kaꞌene nimai rojiꞌina ꞌee amuna ꞌumenaume roume hu ea maiꞌo hijiꞌina kajaho pu mihana. ");
INSERT INTO mcq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ꞌEjumakame Japa ea kaꞌene hijujija hene kavara. ꞌEnareja pu ea mapokaꞌe Natohwijaho nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ꞌEnarena Pitaho ijí Japa Saimani kaꞌene hanuha sisa amairiꞌinijiꞌi naꞌia mapoka hinana. ");
INSERT INTO mcq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ea pina Sesaria hinuna kaivo huni ihijaho Koniriasina. Hu Itari opuni amia puni natohwa. ");
INSERT INTO mcq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ꞌEnaꞌomo hu ea mamaa ꞌee hu kachihwa puꞌúmo Godi juhame naꞌia mapoka Jua kaꞌene uneunecha paꞌamai ijija niꞌajihuna. ꞌEnareꞌe hu naꞌia mapoka Godoni siporua ꞌonuna. ");
INSERT INTO mcq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ꞌEnaꞌomo naꞌi pini tiria koroku navaha punaꞌi samai kavume Godoni ꞌona ojiꞌina huni roe Koniriasiꞌo ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ꞌEjume hu oja hwaꞌusahe ꞌee tea juvume niimaru kaviꞌi ijá ꞌwama Natohwe irake ꞌwamana. ꞌEjume Godoni ꞌona ojiꞌina kajara ijá ꞌwama Koniriasi ara siporua kaꞌene ꞌone ꞌee ea kaꞌene uneunecha paꞌajihi niꞌajihareꞌe vajihujaho ni ajima vuꞌe kahino Godoni unaꞌi navukame Hu nihena a vwihanau. ");
INSERT INTO mcq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ꞌEnakúne ea ꞌahoꞌa irechamie vaꞌe Japa Saimani kaꞌene Pitana ꞌwavuji kamareje ahema roꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hu soha rori Saimani kaꞌene hanuha sisa amairiꞌini jihuni sei hinu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ꞌEnarena Godoni ꞌona ojiꞌina kajaho vuꞌa ꞌwaravume paꞌarejume hu vaꞌana. ꞌEꞌeme Koniriasiho huni pwea noꞌone ꞌee sorutia pina kaꞌene Godi juhaviꞌini ijihi puꞌúmo ꞌumenaume roara. ");
INSERT INTO mcq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ꞌEnarena uneunecha mapoka kajaho ꞌwaramarena irechamiume Japa vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ꞌEnaꞌomo ijihuni súꞌuhijino pu nivaꞌe ari ꞌuseꞌi vaꞌeme Pitaho vea rira muꞌoi namiꞌeme ajima ata huri siporua ꞌoꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pu ꞌiruma amairiara. ꞌEjuꞌe hu matume ꞌiruma iꞌi ꞌahaꞌeme hu navaha punaꞌi kamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ꞌEꞌeme hu kavume akúpa vwicha jaraꞌeme unenuꞌu pina ateha saꞌina natohwa nupiꞌijino ꞌunaꞌeme ariha iki mweꞌi roana. ");
INSERT INTO mcq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ijihuni vajijaho hanuha aniꞌina mweꞌi namine ojura ꞌee tirohe ojura ꞌee uka ichutoi jaijasahe ojura. Ijihuni toi ani rene namana. ");
INSERT INTO mcq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ꞌEꞌeme irijara ijá ꞌwama Pita ꞌurine ꞌania ina! ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ꞌEjume Pita ijá ꞌwama Natohwe nihoꞌo pana. Na uneunecha mapoka chiha rukina paine ꞌee pasoviꞌina paihuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ꞌEjume kúꞌo irijara ijá ꞌwama Uneunecha kaꞌene Godira vejuꞌe mamaaꞌe rejujija a pakaꞌeje sisea roꞌama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ijá ꞌaha noꞌopisu renareja uneka kajaho kúꞌo ichutoi apena vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ꞌEꞌeme Pitaho hu hine hura navaha punaꞌi kama kajihuni maiji vwihaꞌeme ea kaꞌene Koniriasira irechamiume vaꞌa kajija vaꞌe ea Saimani oni sea aporaviꞌi vaꞌe rou vaꞌo roe vwicha jiami namijara. ");
INSERT INTO mcq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ꞌEꞌikaivo pu aporama ijá ꞌiava Saimani kaꞌene Pitana ꞌwavujaho ijí hinu ho paꞌaniji heꞌirono aporavara. ");
INSERT INTO mcq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ꞌEjume Pitaho maiꞌo hura navaha punaꞌi kamaji vwihaꞌeme Godoni ꞌAveni ijá ꞌwama Kima! Ea noꞌopisu a saravu. ");
INSERT INTO mcq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌEnakúne ꞌurine ariha maꞌahi vaꞌa. Nara irechamiume roarakúne pu puꞌúmo pavwihaꞌi kaivo vaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ꞌEjume Pitaho ariha vaꞌe ijá ꞌiama Heha! Ea kaꞌene ja savujaho nana. ꞌEne ja irakijihuni maijihunaꞌe ikaho roare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ꞌEjume pu hu ijá ꞌwava Koniriasiho amia puni natohwaꞌomo hu ea arira ꞌee Godi juhamuna. ꞌEjuꞌukame Jua mapoka hu taꞌarohuraꞌomo Godoni ꞌona ojiꞌina natohwijara nahumakame nú roe a aherama huni sei vaꞌe ara vuaꞌe ꞌwarave hu heꞌirono ꞌwaruvume nú roara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ꞌEjume hu pu ijí ruha aremahume notuaraꞌomo súꞌu ꞌurine pu puꞌúmo vaꞌeme Japa ora vwehwaha ꞌahoꞌa pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ijihuni súꞌuhijino hu Sesaria ꞌeꞌunana. ꞌEꞌeme Koniriasiho pu ajiha ehwaha ꞌee huni napuhija ꞌwaravume pu nianaa roe pu puꞌúmo ahuma ajiha hijara. ");
INSERT INTO mcq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ꞌEꞌeme Pitaho vaꞌe ijino vaji aruvumakaviꞌi Koniriasi ꞌurine Pita oni unaꞌi aruha arihe nuana vetiana. ");
INSERT INTO mcq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ꞌEjumakaviꞌi Pitara hu iji ꞌunama apene ꞌurijiꞌi ijá ꞌwama Na ꞌuꞌo emaa aaꞌinakúne ꞌurina ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ꞌEjume hu huhuꞌúmo vuꞌa ꞌwaraviꞌi aruma vaꞌi kimajaho ea mapoka ijí ahuma hijara. ");
INSERT INTO mcq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ꞌEjumakame hu ijá ꞌiama Nú Jua ea ꞌahoꞌa puꞌúmo ahuma pahine ꞌee puni kwaa paꞌurahojura. Ijihuni maijaho núni varapa ijaꞌina kaivo Godi na ꞌwarimajaho na ea pina sisea chiha rukina paꞌwaꞌurono ꞌwarimana. ");
INSERT INTO mcq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ꞌEjume na matauma pavwihaꞌikaꞌi routa. ꞌEnakúne a maa irakijihunaꞌe pu irechamiume vuꞌare? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ꞌEjume Koniriasi ijá ꞌwama Nara vea noꞌona noꞌo nipaꞌarejajino ike vea mukakino na nuni sei tiria korokui siporua ꞌojiꞌi navaha punaꞌi vaji kaꞌeme ea pina ateha hanajiꞌini saviꞌina nuni unaꞌi namiꞌi kaivo ijá ꞌwimana ");
INSERT INTO mcq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Koniriasiꞌo Godiho ara siporua ꞌonujaho Hu nihenuna. ꞌEne ara ea kaꞌene uneunecha paꞌajihi vajihujaho Hu vwihanu. ");
INSERT INTO mcq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ꞌEnakúne a ea ꞌahoꞌa irechamie vaꞌe Japa Saimani kaꞌene Pitana ꞌwavujaho ꞌwarave roꞌama. Hu Saimani kaꞌene hanuha sisa amairiꞌini jihuni sea soha rori naminujino hu hinuna ꞌwimana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ꞌEjume pu a aheraꞌavarono na vea panisavuta vo irechamiuta. ꞌEjume a nihoꞌo mamaa vene roana. ꞌEnaꞌomo nú ja puꞌúmo ahuma Godoni unaꞌi hijukino Natohwijara vuꞌa kaꞌene a ꞌwaramaji ꞌwaruma ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ꞌEjume Pitara ira ahasirime ijá ꞌiama Na nimai ja ꞌwaravu na hejujaho Godiho ea ronu kwino parenuna. ");
INSERT INTO mcq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ꞌEnakaivo ea irahipo Godi juhame ꞌunama ariramaa vejujaho Hu ura renu. ");
INSERT INTO mcq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Hura Isureri oni harihijihi punaꞌe vuꞌa kaꞌene ranamajaho matauhuniji Jesu Keriso oni vaji najahuna. Hu eaka mapokijihi puni Natohwa. ");
INSERT INTO mcq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jonira toi samani túnaꞌijine uné raka kaꞌene renajaho ja nihena kavu. Karari aneja rene vaꞌe Jutia vaja vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ja nihejara Jesu kaꞌene Nasareti Godira Huni ꞌAvena mahe ꞌee Huni harura ijiꞌi mahana. ꞌEjumakame Godi hu huꞌúmo hinujihunaꞌe Hu kwaaka mapokakino vaꞌe mamaa vene ea kaꞌene ꞌavena sisea ajimaiꞌina siomahuna. ");
INSERT INTO mcq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ꞌEnaꞌomo nú uneunecha mapoka kaꞌene Jua puni kwaa ꞌee Jerusaremi venaji ꞌuꞌo kavara. ꞌEne pu Huaꞌe apene korosia ꞌahi ꞌanaume kwamajaho ꞌuꞌo kavara. ");
INSERT INTO mcq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ꞌEnakaivo vea noꞌopisu paꞌareꞌeme Godira vejume kúꞌo ꞌurinana ꞌee samaahiravume kavara. ");
INSERT INTO mcq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ꞌEjumakame Hu kúꞌo ꞌurinajaho pu ea mapoka pakavara. ꞌEnakaivo nú Hu kama hejiꞌinijija Godira marako nú iji pijúha jihunaꞌe Hu nú puꞌúmo ꞌiruma ine ꞌee toa inana. ");
INSERT INTO mcq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ꞌEjumakame Hu ꞌwaruma jihunaꞌe nú Huni vuꞌa ea mapoka samaumai najahu. Jesu kaꞌene Godira iji pijahume ea kaꞌene maiꞌo hijura ꞌee kwamasahiꞌina ijihipuni ꞌotua vehuni jihuni vuꞌa nú ꞌwaravura. ");
INSERT INTO mcq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Poropetia mahoꞌo Hu rone ꞌwaramareja ijá ꞌiava Ea irahipo nimaa roꞌavajaho puni sisea Huni iha vajijino vwihanie areve parahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitaho ijí hine ꞌwaraviꞌi hiꞌeme Godoni ꞌAveni ariha roe ea kaꞌene hine huni vuꞌa heja kajihipuni oja vaji samahana. ");
INSERT INTO mcq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ꞌEjumakame Jua nimaa rojiꞌina kaꞌene Pitaꞌi puꞌúmo roajivajija oja hwaꞌusunahara. Ijihuni maijaho Godoni swara kaꞌene Huni ꞌAvenijaho Jenitarua ꞌuꞌo samaha jihunaꞌe oja hwaꞌusahara. ");
INSERT INTO mcq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ꞌEjume pu heꞌeme pu ira ani ani ꞌwaviꞌi hine Godi taꞌarohara. ꞌEꞌeme Pitara eha vene ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Núra Godoni ꞌAvena apeja jaꞌinaꞌe pu ꞌuꞌo apejaraꞌomo puaꞌe toi samahunijaho irara tanuꞌena? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ꞌEjume hu ꞌwaravume pu Jesu Keriso oni iha ꞌahi toi samahunaꞌe ꞌwaramana. ꞌEnareja hu pu puꞌúmo ijí naꞌia noꞌuna ho noꞌupisu hiꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ꞌEjumakame apasorua ꞌee vwehwaha ꞌahoꞌa kaꞌene Jutia hijajipo hejajaho Jenitarua ꞌuꞌo Godoni vuꞌa hena apejajaho hejara. ");
INSERT INTO mcq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ꞌEꞌeme Pitaho ꞌuname Jerusaremi vaꞌume Jua mapoka sisa ꞌuhuahiꞌinijipo hu namaha ꞌurarahara. ");
INSERT INTO mcq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ꞌEnareja pu hu ijá ꞌwava A vaꞌe ea kaꞌene sisa paꞌuhuaiꞌinijihi puꞌúmo ꞌiruma inana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pitaho aneja vene hami nirisame ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ꞌEnarena ijá ꞌiama Na kwaa Japa hine siporua ꞌojiꞌi visoni kaꞌeme unenuꞌu pina ateha saꞌina kajaho kahi akúpi ꞌahi rene nupia nupiijino ꞌunaꞌeme arihe nuni roana. ");
INSERT INTO mcq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ijihuni vajijaho hanuha ani aniꞌina mweꞌi namine ojura ꞌee tirohe ojura ꞌee uka kaꞌene ichutoi jaijasahe ojura. Ijihuni toi ani rene namana. ");
INSERT INTO mcq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ꞌEꞌeme na ira heꞌeme ijá ꞌwarimana Pita ꞌurina ꞌanie ina ꞌwimana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ꞌEjume na ijá ꞌwavo Natohwe nihoꞌo pana. Na uneunecha chiha rukina mapoka paine ꞌee pasoviꞌina nuni ira vaja pavaꞌe arihura ꞌwavuta. ");
INSERT INTO mcq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ꞌEjume kúꞌo ira kahi akúpi ꞌahi rene roe ijá ꞌwima Uneunecha kaꞌene Godira vejuꞌe mamaa rejujija a pakaꞌeje sisea roꞌama ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ijaho ꞌaha noꞌopisu renarena kúꞌo apene ichutoi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ꞌEne heha ijiha kajano ea noꞌopisu Sesaria rena irechamiume naꞌe aheriꞌi roe sea kaꞌene núra hijajino usevara. ");
INSERT INTO mcq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ꞌEjume Godoni ꞌAveni ꞌwarimarena ijá ꞌwima A unenuꞌu pina pavwihaꞌamana kaivo vaꞌamana ꞌwivume ea iropu kwinu vwehu nú puꞌúmo roe Sesaria ea kajihuni sei vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ꞌEjume hu ꞌwarumajaho hu Godoni ꞌona ojiꞌina kaꞌeme ijara ijá ꞌwama A ea ꞌahoꞌa irechamie pu vaꞌe Japa Saimani kaꞌene Pitana ꞌwavujaho aheme roa. ");
INSERT INTO mcq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ꞌEje hura vuꞌa ꞌwarave a ꞌee oni kachiꞌinijihija mahoꞌo maraniama ꞌwamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na ijí vuꞌa kaji aneja vene ꞌwaraꞌeme Godoni ꞌAvena ariha roe pu samahana. Areri amuraꞌe nú samuha jaꞌinaꞌe samahana. ");
INSERT INTO mcq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ꞌEꞌeme na Natohwijara raka kaꞌene ꞌwarumajaho vwihajuta. Joniho hu ja toa vajaru samaume ꞌurijara kaivo ja Godoni ꞌAvenijiꞌi samahuna ꞌúmajaho vwihajuta. ");
INSERT INTO mcq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ꞌEjume nú Natohwa kaꞌene Jesu Keriso nimaa rojumakame Godira swara kaꞌene nú múhaji pu nikwinuꞌina kaji miꞌamajaho na ea iranaꞌomo Huni ꞌunama tanuꞌejo? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pu vuꞌa kaji henareja pu irunoꞌa areꞌi kaivo mataume Godi taꞌarohiꞌi ijá ꞌwava Oo nijina Godira vejume Jenitaru ꞌuꞌo puni sisea areꞌi kaivo taarohe majama hihuna apehuna. ");
INSERT INTO mcq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nimarako Sitivini ꞌanaume kwaꞌeme ea ꞌahoꞌa kaꞌene nimaa rojiꞌinijija pu siseꞌi ꞌahiume juhaha vaꞌe Ponisia vaꞌe ꞌee Saiparasi vaꞌe ꞌee Enitioki vaꞌara. ꞌEnakaivo pu vuꞌa kajaho ea ꞌahoꞌa paꞌwaravara kaivo Juaru ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ꞌEnakaivo ea nimaa rojiꞌina ꞌahoꞌa Saiparasi ore ꞌee ea ꞌahoꞌa Sairini oraꞌomo pu vaꞌe Enitioki roe aneja vene Kuriki ꞌuꞌo Jesu kaꞌene Natohwi jihuni vuꞌa maa najahara. ");
INSERT INTO mcq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ꞌEjume Natohwi jihuni harura pu puꞌúmo navumakame ea mapoka nimaa ronareja taꞌarohe Natohwi jihuni roara. ");
INSERT INTO mcq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ꞌEjume ijí vuꞌa kajara rena roe Jerusaremi sosiji rouma henareja pu Panapasi ranavume Enitioki vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ꞌEnarena hu ijí vaꞌeꞌujiꞌi Godoni maiji vwihaniiniji kamajaho nihoꞌo teamama parajume hu pu niꞌajihe ijá ꞌiama Natohwiji nimaa rojiꞌi hiꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Hu ea mamae ꞌee nimaa rojiꞌine ꞌee Godoni ꞌAveni ruha apena parajiꞌinaꞌomo ea mapoka Natohwi jihuni ea rejara. ");
INSERT INTO mcq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ꞌEjume Panapasiho vaꞌe Tarasasi Soru sama vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ꞌEnarena hu vaꞌe kame ahema apene Enitioki vaꞌana. ꞌEnarena pu noꞌo juara kwino ijí hijara. ꞌEne ijino sosia epuꞌúmo piunaꞌarame ea mapoka najahara. ꞌEꞌeme tisaiporu ijija amuraꞌe Enitioki Keriso oni ehija ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ꞌEꞌeme ijihuni vea kajino poropetia ꞌahoꞌa Jerusaremi rene kami Enitioki vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ꞌEꞌeme poropetia pina huni iha Akapasiho Godoni ꞌAveni niꞌajahumakame hu ꞌurine namiꞌi kaivo mweꞌa kakino ꞌoravea natohwa rehuna ꞌwaramana. ꞌEnaꞌomo túnaꞌi Karautiasira ꞌajohani veijino ꞌoravea renana. ");
INSERT INTO mcq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ꞌEne tisaiporu ura renajaho pu ea kwino kwino Jutia vwehwaha kaꞌene hijujihi niꞌajihe uneunecha ꞌahoꞌa irechamihe vaꞌavarono ura renaara. ");
INSERT INTO mcq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ꞌEjume pu ijá venareja Panapasiꞌo Soruꞌo puni ija tahi irechavume pu ꞌeka vaꞌe eruta vajihara. ");
INSERT INTO mcq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ijihuni vea kajino kini Heroti ea ꞌahoꞌa kaꞌene sosi kaji hijujihija nihoꞌo niꞌinaꞌe siseꞌi ꞌahiuna. ");
INSERT INTO mcq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ꞌEne hu Jemisi kaꞌene Joni oni ꞌuꞌuiji soꞌwa pijahume kwamana. ");
INSERT INTO mcq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ꞌEjiꞌi kimajaho Jua ijí kame teamanavuma kimarena hu vaꞌe Pita ꞌuꞌo kamohuna vwihanana. Ijaho puretia isitia paꞌajihuni vea reꞌeme hu ijá veꞌiro venana. ");
INSERT INTO mcq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ijihuni túnaꞌi hu Pitaho apene tipurai ranamana. ꞌEjume sorutia mapokaꞌe (16) irechamiume pu ruha kaꞌene Pita ranamaji ꞌajoha hijara. Pasova vea paꞌarejakaviꞌi hu Pitaho apena vaꞌe ea mapoki jihipuni unaꞌi ꞌotua vetiꞌi ꞌahaume ranavuma hinana. ");
INSERT INTO mcq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ꞌEnakaivo Pitaho ijino tipurai hiꞌeme sosiepo hine hunaꞌe Godoni siporua ꞌojiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ijihuni súꞌuhijino Heroti vaꞌe Pitaho apene ꞌotua vetiꞌi ꞌahaume vaꞌana. ꞌEꞌeme naꞌia kajino Pitaho sorutia noꞌo ijihipuni riri neꞌeme pu hua senia noꞌo ija mumora kamomapi ranavume namana. ꞌEꞌeme sorutia mapoka ijí vwicha jiami naminareja hine tipura ara kajaho ꞌaiha vejara. ");
INSERT INTO mcq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Heha! Natohwi jihuni ꞌona ojiꞌini niꞌaha kwino huni rora kajano namiꞌeme ijí tipura ara vaja kajaho hananana. ꞌEꞌeme hu Pita oni rorijano ꞌanaꞌanaiꞌi saa ijá ꞌwama Mamako ꞌurina ꞌwamana. ꞌEjume senia kaꞌene huni ija kamovajaho niꞌaha kwino ijá arihana. ");
INSERT INTO mcq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ꞌEjumakaviꞌi Godoni ꞌona ojiꞌina kajara ijá ꞌwama Oni ateha apúsame mumora hwana sama ꞌwavume Hu ijá vejumakaviꞌi ijá ꞌwama Oni ateha apúsamareja ꞌararihie roꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ꞌEjume hu ijí Godoni ꞌona ojiꞌina kaji ꞌarariha va ꞌeꞌunana. ꞌEnakaivo raka kaꞌene Godoni ꞌona ojiꞌinijara venajaho hu pahena pavwihanana kaivo hu vwihanajaho visoni kavu ronana. ");
INSERT INTO mcq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ꞌEꞌikaivo pu noꞌo vaꞌe ea kaꞌene ꞌaiha amura vejajaho asitahe ꞌee vaꞌe ijihuni rori ꞌaiha vejajija asitahe roe kami ajani vwicha kaꞌene ari maꞌahi vaꞌujino roꞌeme vwicha kajaho maꞌori tirausahume pu noꞌo roe samai usevara. ꞌEnareja niꞌaha kwino ꞌona ojiꞌinijaho Pitaho raname vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ꞌEꞌeme Pitaho ijiꞌa hena kamajaho nimaa Natohwijara Huni onaꞌojiꞌina ranavume hura roe na Heroti oni ija ꞌahi aherimana. Ijihuni maijaho Juaka mapokijaho Heroti puꞌúmo na siseꞌi ꞌahihuni jihunaꞌe aherimana roana. ");
INSERT INTO mcq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ꞌEnarena hu ijá vwihaꞌikaꞌi ijiꞌa vaꞌe Joni kaꞌene Makana ꞌwavujihuni oha Merina ꞌwavujihuni sei vaꞌana. Ijí ea mapoka ahuma hine siporua ꞌojiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ꞌEꞌeme hu roe ijí vwicha jiama kajino ꞌanaꞌanaume napara pina huni iha Rotanaꞌomo ijara roe vwicha tirasaꞌiro venana. ");
INSERT INTO mcq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ꞌEjiꞌi henajaho Pita oni ira henarena hu tatomajihuna vwicha patirasaꞌi kaivo ninuma vaꞌe karohi sei vaji arume ijá ꞌiama Pitaho karoho maꞌahi naminu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ꞌEjume pu hu ijá ꞌwava A nihoꞌo nanama avanu ꞌwavara. ꞌEjume hu ira ajira pu ijá ꞌiama Nimaa nimaa hu karoho maꞌahi naminu ꞌiamana. ꞌEnakaivo pu ijá ꞌwava Ijaho huni ꞌona ojiꞌinina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ꞌEnakaivo Pitaho majama hine vwicha ꞌanaꞌanauma henareja pu vwicha tirasaviꞌi kavajaho Pita kavara. ꞌEnareja pu nihoꞌo oja hwaꞌusaha parajara. ");
INSERT INTO mcq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ꞌEjuma kimarena Pitaho iji hararajihe irunoꞌa areꞌavarono ruramana. ꞌEꞌikaivo hu Natohwijara hua apene roe samai ranamaji ꞌwaramana. ꞌEne hu ijá ꞌiama Vaꞌe Jemisiho ꞌee vwehu nuna kaꞌene nimaa rojiꞌinijihija ijá ꞌwaraꞌavara ꞌiꞌi kaivo kwaa pini vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ꞌEꞌeme vea nituꞌeme Pitara ichiꞌi vaꞌajaho sorutia puruva rejumakame iranoꞌa natohwaꞌe vejiꞌi piraꞌaravara. ");
INSERT INTO mcq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ꞌEꞌeme Herotiho hu samana kaivo hu papiunamana. ꞌEnarena hu ꞌaiha vejiꞌinijija ꞌotua vetie ꞌania kwamasahuna ꞌwaramana. ꞌEnarena Pitaho Jutia areꞌi kaivo hu kami Sesaria vaꞌe hinana. ");
INSERT INTO mcq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ꞌEnarena Herotiho Taia ora ꞌee Sairani ora kiꞌeme hu ajimana. ꞌEjumakame pu vwiha kwisu rene ahuma nianaa huni roara. Pu Parasitasiho kini huni ara ꞌajohiꞌinaꞌomo pu puni mamaꞌinijihi puꞌúmo vaꞌe matauma hihuni vuꞌa ꞌwame amairiara. Ijihuni maijaho pu puni ꞌiruma kinijihuni ara kwai ꞌekuraꞌomo avajara. ");
INSERT INTO mcq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ꞌEjumakame Heroti pu vuꞌa ꞌwaraꞌirono naꞌia kwino iji pijaha ranamana. ꞌEnaꞌomo ijí vea kajino hu huni kini huni ateha same vaꞌe kini huni ruha ꞌahi hinana. ꞌEnarena hu vuꞌa niꞌimaꞌura pu ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ꞌEjume ea kajipo majama ijaho godoni ira heju kaivo emaapuna pana ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ꞌEꞌeme niꞌaha kwino Natohwi jihuni ꞌona ojiꞌini hu ꞌanaume huchapo apene ijuma kwamana. Ijihuni maijaho hu Godoni pinana paꞌunama ꞌurina jihunaꞌe avanana. ");
INSERT INTO mcq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ꞌEnakaivo Natohwi jihuni irijaho nihoꞌo rausaharena natohwa rena vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ꞌEꞌeme Panapasiꞌo Soruꞌo Jerusaremi hijiꞌi kaukara vejuma paꞌarejume pu kúꞌo ꞌunama vaꞌe Joni kaꞌene Makana ꞌwavujaho aheme pu puꞌúmo roara. ");
INSERT INTO mcq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Enitioki sosia vajijaho poropetia ꞌee najahiꞌinijija ijí hijara. Panapasiho Simiani kaꞌene ea ajijaho ꞌee Rusiasi kaꞌene Sairini orijaho Manaini kaꞌene Heroti oni napurijaho ꞌee Soru ꞌuꞌo ahuma ijihi puꞌúmo hijara. ");
INSERT INTO mcq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ꞌEꞌeme pu Natohwiji oja vwihanareja pu ꞌiruma aura areme siporua ꞌojiꞌi hiꞌeme Godoni ꞌAveni ijá ꞌiama Panapasiꞌo Soruꞌo irechamie kaukara raka kaꞌene Na pura veꞌavarono ꞌumenauji veja ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ꞌEjume pu ꞌiruma aura areme ꞌee siporua ꞌonareja pu ꞌurine puni ija húmata ꞌahi irechamiume pu noꞌo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ꞌEne pu Godoni ꞌAveni irechamiume vaꞌe Serusia useme ijino sisima ajima Saiparasi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ꞌEnareja pu vaꞌe Saramisi useme Jua puni Sinakoku vaji aneja vene Godoni vuꞌa najahara. ꞌEne Joniho pu niꞌajihunaꞌe ahevara. ");
INSERT INTO mcq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ꞌEnareja pu ijí Saiparasi opuni ara kwaa kajaho ꞌuraho paranareja pu vaꞌe ara iha kaꞌene Pepasi ꞌwavuji ea pina piunavara. Ijí ea kajihuni ihijaho Pajesuna. Hu poropetia iraꞌasina. Hu atama ani aniꞌina mapoka vejiꞌina. ");
INSERT INTO mcq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ꞌEnaꞌomo hu ea natohwa kaꞌene ꞌajohiꞌinijiꞌi hinuna. Hu nihoꞌo hami vwihajiꞌina. Hu Godoni vuꞌa heꞌirono Panapasiꞌo Soruꞌo ꞌumenaume roara. ");
INSERT INTO mcq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ꞌEnakaivo Erimasi kaꞌene atama vejiꞌinijara kanisoru nimaa roꞌamarono ꞌunama same tanumana. ");
INSERT INTO mcq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ꞌEjumakame Soru kaꞌene Poruna ꞌwavujaho Godoni ꞌAveni huni oja vaja rarena parajumakame hu niimano kanaviꞌi ");
INSERT INTO mcq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ijá ꞌwama A nihoꞌo ꞌavena sisei jihuni hariha. A uneunecha kaꞌene mamaijihipuni nanaꞌejiꞌina. ꞌEne iraꞌata uneunecha kaꞌene siseijipo oni oja vajijaho rarejara. Ijihunaꞌe naꞌia mapoka a Natohwijihuni ꞌunama ariramaijaho a ꞌeke siseimaa venujaho vecha areꞌena? ");
INSERT INTO mcq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ijihunaꞌe Natohwijara Huni ija oni haha ꞌahi ranamahe a nihoꞌo nia supamaꞌena. ꞌEje a naꞌia ꞌahoꞌa vea pakame pavehuna ꞌwaꞌeme huni nia vaji ꞌimitia samarena nutuma naꞌeme huni nia kwino supamana. ꞌEjumakame hu ꞌurahe ijino napapanama apene ijí ojiꞌi ea ꞌahopo iji ꞌunama apene vaꞌavarono hu ea saramana. ");
INSERT INTO mcq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ꞌEjumakame kanisorua ijí kamarena hu nimaa ronana. ꞌEnarena hu Natohwiji rone najahaji henarena oja hwaꞌusahana. ");
INSERT INTO mcq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ꞌEꞌeme Poruho ꞌee huni napuhija kaꞌene pu puꞌúmo vaꞌa kajihija Pepasi rene sisima ꞌahi Peka Pamipiria vaji useꞌeme Joniho pu irechamiꞌi kaivo ꞌunama Jerusaremi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ꞌEꞌeme Peka raname vaꞌe Pisitia Enitioki vaji usevara. ꞌEꞌeme ijí Sapati rejume pu vaꞌe Sinakoku vaji hijara. ");
INSERT INTO mcq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ꞌEjumakame ea kaꞌene Sinakoku ꞌajohiꞌinijipo tamana ꞌee poropetia tahume paꞌarejume ijá ꞌiava Vwehije ja vuꞌa ꞌahoꞌa ea ikihi niꞌajihe ꞌwarahunaꞌe reꞌavajaho ꞌwaraha ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ꞌEjume Poru ꞌurine arini namiꞌi kaivo iji hararajihiꞌi ijá ꞌiama Isureri ora kaꞌene Godi juhaviꞌinakije ataa apúsama ike heha. ");
INSERT INTO mcq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Godikara amuhu núna kaꞌene Isureri orijija iji pijihana. ꞌEnajihunaꞌe pu Ijipiti hiꞌeme Hura vejume pu ea mapoka rejara. ꞌEnareja Hu Huni harurijino pu aherame ro samai roana. ");
INSERT INTO mcq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pu juara mapoka (40) nechiꞌi roajaho Godi pu mají ꞌajoahaꞌeme roara. ");
INSERT INTO mcq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ꞌEjume Hura ijino Kenani opuni kwaa ara kajino ara iropu noꞌoheꞌi ea mapoka ꞌaniume tiraa ranavara. ꞌEꞌeme Hu Huni ehijaꞌe ijí mweꞌa kajaho ahaame ꞌoiꞌoi vajihana. ꞌEne pu ijí hijajaho Hu ꞌajohaꞌeme juara mapoka (450) paarenana. ");
INSERT INTO mcq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ꞌEꞌeme ijihuni túnaꞌijino Hu puni ꞌotua hejiꞌina irechamiume pu hinona apena vaꞌu vaꞌu vaꞌe Samueri kaꞌene poropeti ijihuni veijino ꞌeꞌujara. ");
INSERT INTO mcq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ꞌEnareja ijihuni túnaꞌijino pu kiniaꞌe jarivume Godira Soru kaꞌene Kisi oni harihiji mihana. Hu Penijimani oni ituhaꞌomo ijara ꞌajohaꞌeme juara mapoka (40) paarenana. ");
INSERT INTO mcq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ꞌEjume Hu hu ranaꞌi kaivo Teviti vejume roe puni kiniaꞌe renana. Huaꞌe rone Hu ijá ꞌwaramana Na Teviti kaꞌene Jesi oni harihiji kavuta. Ea kaꞌene Nuni ojijara ura renujaho ijina. Hura Nuni ura ijaho vehuna. ");
INSERT INTO mcq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ninahama ꞌwarama jaꞌinaꞌe ea ikehuni amuja vaji Godira Isureri opuni niꞌajihiꞌina Jesuho mihana. ");
INSERT INTO mcq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ꞌEnaꞌomo Hu maiꞌo roꞌamarono Joniho Isureri ora mahoꞌo puni sisea vwihane areme taꞌarohakame toi samahuna ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Joni oni kaukara maiꞌo paareꞌi veꞌeme hu eaka mapoka kajihi ijá ꞌiama Ja vwihajujaho na rana rojo? Na Ea kaꞌene ja hine ꞌajahujaho pana kaivo heha! Hu nuni túnaꞌi rou nara Huni mumora hwana jahehuna areria pareniu. ");
INSERT INTO mcq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Vwehu nunakije ja Eparahami oni harihi jihipuni kachiꞌina ꞌee ea kaꞌene Godi juhaviꞌinaka iki ja puꞌúmo hijujija Hu nú niꞌajúharena Hu Huni vuꞌa nú múhana. ");
INSERT INTO mcq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ea kaꞌene Jerusaremi hijujija ꞌee puni ꞌajohaiꞌina Hua ꞌee poropetiepo ꞌwaravara kaꞌene naꞌia mapokaꞌe Sapati rejukaviꞌi tahujaho pu maiꞌo pahena pakavuraꞌomo ijara nimaa reꞌamarono pu Hu apene ꞌotua vetiara. ");
INSERT INTO mcq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ꞌEnakaivo pu ꞌunama kaꞌene venareje Hu ꞌanahuniji savujaho pakamareja Pairatira ꞌanaꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ꞌEnareja Hu rone ꞌwaravaji pu Hu korosi ꞌahi namajaho apene arihe vaꞌe muna ari ranavara. ");
INSERT INTO mcq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","31","ꞌEnakaivo Godira vejume Hu kúꞌo ꞌurinana. Naꞌia mapoka ea kaꞌene pu puꞌúmo Karari rene Jerusaremi roajihipuni roana. ꞌEnaꞌomo ijí ea kajipo iviama Huni ꞌwaraviꞌina rejara. ");
INSERT INTO mcq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ꞌEnaꞌomo nú vuꞌa maa maiuꞌina kaꞌene emahu núna nahama ꞌwaramaji ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Godira raka kaꞌene nahama ꞌwaramajaho iviamaa sesahu núpuni veakino Jesuho vejume ꞌurinana. Areri Samusi 2 vaji vejajaꞌina. Nara A saravu jihunaꞌe A iviasi Nuni Hariha renu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Godira vejume Hu kúꞌo ꞌuriꞌeme ikaꞌina ꞌwarumana. Hu kúꞌo paꞌunama vaꞌe mweꞌa vaja pasakarahuna. Na Teviti merajahu jaꞌinaꞌe ja ꞌuꞌo merajihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ijihunaꞌe hu Samusi vaji kúꞌo ijaꞌina ꞌwaramana. A Oni Ea kaꞌene ariramaijaho ranave mweꞌa vaja pasakaraꞌamana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tevitiho Godoni ura ijaho hura hinani veijino ehwa punaꞌe vejiꞌi hinu vaꞌo kwamana. ꞌEjumakame pu apene vaꞌe huni amuhija irechamiajino ranavume sakaranana. ");
INSERT INTO mcq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ꞌEnakaivo Godira Hu vejume ꞌurinajaho pasakaranana. ");
INSERT INTO mcq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ijihunaꞌe vwehu nune sisea vwihana arehuna kaꞌene Huni vaji rena roana kaꞌene ꞌwaravujaho heha! ");
INSERT INTO mcq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ja niheju ea mapoka kaꞌene Huaꞌe nimaa rojujaho ariramaa renauna. Mosisi oni tamanijara ijaꞌina veje ariramaa rehuna areria pana. ");
INSERT INTO mcq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ꞌEnakúne poropetiepo raka kaꞌene ꞌwaravajaho ja hami hami ꞌajohakame ijija joni haha ꞌaha pareꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Pu ijá ꞌiava Ja ea kaꞌene Godoni ira matihiꞌinijija ijí vwihajiꞌi kwamasaꞌavara. Na joni veijino kaukara pina veju kaivo kaukara kajaho ea ꞌahopo nirisajihe ꞌwarahuna kaivo ja nihoꞌo taina pina panimaa rohuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Poruꞌo Panapasiꞌo ꞌwaravume paarejume maꞌahi va useꞌi vaꞌeme eaka mapoka kajipo hura hara jarirame ijá ꞌiava Ja noꞌo Sapati piniji ꞌuꞌo roe vuꞌa kajihuna kajaho ꞌwaruꞌavara ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ꞌEꞌikaivo ea mapoka kaꞌene ijí Sinakoku hija kajija niꞌaha kwino maꞌahi usemareja Jua mapokaꞌe ꞌee ea ꞌahoꞌa kaꞌene Jua rejara kaꞌene Godi juhaviꞌinijija Poruꞌo Panapasiꞌo ꞌararihie vaꞌara. ꞌEjume pu ꞌejahie ijá ꞌiava Ja Godira maiji vwihanúana vajijino ꞌurahoꞌavara ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ijihuni túnaꞌi Sapati reꞌi vejuma kamareja araka natohwa kajaho ahuma hine Godoni vuꞌa heꞌiro roara. ");
INSERT INTO mcq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ꞌEꞌeme pu ea mapoka ahuma hijuma kimareja Jua nihoꞌo senama parajara. ꞌEjumakame pu Poru oni vuꞌijaho apene arohe ani ꞌwarame Poru ira sisea ꞌwarame matahara. ");
INSERT INTO mcq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ꞌEjume Poruꞌo Panapasiꞌo ira pajuꞌikaꞌi ijá ꞌiava Nú mamaa vene Godoni ira ikaho ja marako ꞌwaravara kaivo ja majama hihuna apehunijaho nihoꞌo sename hweꞌi ꞌahiu jihunaꞌe ijaho ja ojono kaꞌeje nú Jenitarua puni vau. ");
INSERT INTO mcq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ikaho raka kaꞌene Natohwijara nú veꞌavarono ꞌwarumajina. Nara ja Jenitaru puni ira saꞌinaꞌe irechamiu ꞌee ea niꞌajihuni vuꞌa apene mweꞌa kehuni urakino vaꞌavara ꞌúmana. ");
INSERT INTO mcq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ꞌEjakame ijí Jenitaru kajija pu vuꞌa kaji henareja temarasahe ꞌee Natohwi jihuni vuꞌijaho taꞌarohara. ꞌEne ea kaꞌene majama hihunaꞌe Godira iji pijihajija nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ꞌEnarena Natohwi jihuni irijaho kwaaka kajino mahoꞌo rausaha vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ꞌEnakaivo Juapo vejume napara kaꞌene iha rukina ꞌee parua kaꞌene ara kaji ura niꞌina pisimie oja inaume Poruꞌo Panapasiꞌo rurahe ꞌararihiume kwaa puna kajaho areꞌi kaivo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pu ꞌurine puni mumora hari saina kaꞌene navajaho puaꞌe siseꞌi ꞌahie tairevume arihumakiviꞌi pu Aikoniami vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ꞌEjumakame tisaiporua Godoni ꞌAveni ruha apena parajukame nihoꞌo teamanaꞌejuꞌe hijura. ");
INSERT INTO mcq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ꞌEjume pu vaꞌe Aikoniami Jua puni Sinakoku vaji ahume hine vuꞌa ꞌunama aniꞌinijino ꞌwaravume ea mapoka Jua ꞌee Kuriki nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ꞌEnakaivo Jua ꞌahoꞌa panimaa rojara. ꞌEnaꞌomo ijipo vejume Jenitaru ea kaꞌene nimaa rojiꞌinijija nihoꞌo senavara. ");
INSERT INTO mcq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pu noꞌo ꞌaha jora ijino hine pajuꞌikaꞌi najahume Natohwijara niꞌajihe Hura maiji vwihaniaji najaharena aacha ꞌee uneunecha ani aniꞌina kaꞌene ea areri pavehunijaho vajihume pu vejume rejara. ");
INSERT INTO mcq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ꞌEjumakame ea mapoka kaꞌene ara kajiꞌurijija ea ꞌahoꞌa Jua punaꞌi rejume ea ꞌahoꞌa apasorua punaꞌi rejara. ");
INSERT INTO mcq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ꞌEjume Jenitarua ꞌee Jua ꞌee puni mamaꞌinijipo niꞌaha kwino ꞌurine apasorua kajihi ruarahe ꞌee muni ꞌeke ꞌaniꞌirono vejara. ");
INSERT INTO mcq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ꞌEjumakame pu noꞌo ijí henareja juhaha vaꞌe kwaa iha Raikonia vaꞌareja ara iha Risitara Tepi ꞌwavuji vaꞌara. ꞌEe ijí ara kajihipuni rori ara ꞌahoꞌa kajino vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ꞌEnareja pu ijino Godoni vuꞌa mai najahara. ");
INSERT INTO mcq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ea pina Risitara hinuna kaivo huni mumora iriviꞌina ꞌomo oahoni tei vaji nijaꞌina rene roajihunaꞌe hu panamina onuna. ");
INSERT INTO mcq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ꞌEnaꞌomo eakaho Poru oni vuꞌa hami henana. ꞌEjume Porura hu kanamarena nia paꞌahatihiꞌi kanamajaho hu nimaa ronujihunaꞌe hu marahunaꞌe kamana. ");
INSERT INTO mcq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ꞌEnarena hu ajira ijá ꞌwama ꞌUri arini namina ꞌwavume hu ohurikune ꞌuri arini namina ꞌuraha onana. ");
INSERT INTO mcq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ꞌEjume eaka mapoka kajipo ijí Porura raka kaꞌene vena kaji pu kamareja pu Raikonia opuni iri ijá ꞌumeja godiepo emaa rene núni roa karihi kiha ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ꞌEnareja pu Panapasiho iha pina Suusi ꞌwame ꞌee Poruho ꞌwaraviꞌina ijihunaꞌe Hemisi ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Suusi oni Temiporua ijí ara kajihuni rori naminanaꞌomo Pirisitia purumakau ꞌeke ea mapoka kajihi puꞌúmo sinara siaaviꞌina ꞌeke swasa veꞌi ꞌahiume vwicha jiami roara. ");
INSERT INTO mcq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Vea kaꞌene apasorua Panapasiꞌo Poruꞌo hejajaho punaꞌe vehuna henareja pu noꞌo puni ateha ꞌunirame isokuꞌi kaivo pu ninukujaha vaꞌe ea mapoka kajihi puni vaji vaꞌe ijá ꞌumejara ");
INSERT INTO mcq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ea ikije ja irakaꞌe veꞌirono vejo? Nú ꞌuꞌo emaa areri jaaꞌina. ꞌEnakaivo nú Godoni vuꞌa maa maiuꞌina ja ꞌwaravu jihunaꞌe ja ikija nimaa panakúne pataꞌaroraꞌikaꞌi taꞌarohe Godi nimaa kaꞌene maiꞌo hijiꞌina kaꞌene akúpa vene mweꞌa vene soha vene uneunecha kaꞌene ijí navujaho venajihuni roha. ");
INSERT INTO mcq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ꞌEne amuja kaꞌene kamaꞌahuni hina apene roajija Hu makiꞌeme eaka kwaa mapokakino hijajija Godi pataarorahe pu raka kaꞌene ura veꞌi ꞌahiajaho vejara. ");
INSERT INTO mcq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hu nimaa paranamia vaꞌa paranana kaivo Hu mamaa ꞌahie niꞌajihe neha akúpi ꞌahi vejuꞌe pine ꞌiruma vejuꞌe marajuꞌukame ꞌiruma ine teamanavura. ");
INSERT INTO mcq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pu noꞌo raka kaꞌene ꞌwaravajaho ijí eaka mapoka kajipo swasa puna kaꞌene veꞌiro vejaji tanuhuna nihoꞌo kisina renana. ");
INSERT INTO mcq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ꞌEꞌeme Jua ꞌahoꞌa kaꞌene Enitioki ꞌee Aikoniami rene roajipo roe ea mapoka ꞌwaravume pu niꞌaha kwino muni ꞌeke Poruho ꞌanaara. ꞌEne nikwamu roꞌikaꞌi pu tairia apene vaꞌe ara uri ranavara. ");
INSERT INTO mcq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ꞌEꞌeme Tisaiporuepo roe huni rora kajino tauhuhe namiꞌeme hu ꞌurine ari vaji vaꞌana. ꞌEnaꞌomo ijihuni súꞌuhijino pu noꞌo Panapasiꞌi ara iha Tepi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ꞌEnareja pu ijino Godoni vuꞌa maa maiuꞌina ea najahume ea mapoka tisaiporuaꞌe rejara. ꞌEꞌeme pu ꞌunama Resitira ꞌee Aikoniami ꞌee Enitioki vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ꞌEjume pu vaꞌe ijino ea kaꞌene tisaiporua niꞌajihe puni nimairoa ija kisi ꞌuname hina vahunaꞌe ꞌwarame ijá ꞌiava Haha natohwaꞌe hianame ꞌee ea siseꞌi ꞌahúꞌeje nú ja puꞌúmo Godoni ara vahuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pu sosia kwinu kwinu puni eruta pijihume paarejumakiviꞌi ꞌiruma ꞌaura areme ꞌee siporu ꞌojume paarejume ꞌeke Natohwa kaꞌene pura nimaa rojujihuni ija tahi irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ꞌEjume pu vaꞌe Pisitia useme ꞌee Pamipiria vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ꞌEnareja pu Peka Godoni vuꞌa najahareja ijiꞌa Ataraia vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ꞌEnareja pu kúꞌo ꞌuname sisima ꞌahi ajima Enitioki roara. Nimarako iji pijihe Godoni maiji vwihaniaji huni kaukara vehunaꞌe irechamiume vaꞌaraꞌomo venareja kúꞌo ꞌunama roara. ");
INSERT INTO mcq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pu ꞌunama roe Enitioki useme ꞌwaravume sosia roe ahuma hiꞌeme Godira pu puꞌúmo uneunecha kaꞌene venajaho ꞌwarame ꞌee Jenitaruepo icháꞌinaꞌe nimaa rohuni vwicha kaꞌene tirasamajaho ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pu ꞌaha joraꞌe ijí tisaiporu puꞌúmo hijara. ");
INSERT INTO mcq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ꞌEꞌeme ea ꞌahoꞌa Jutia rene aneja vene vwehwaha kajihi najahe ijá ꞌiava Ja Mosisi oni tamani jaꞌinaꞌe sisa ꞌuhuꞌavajina vo ja pamaranihuna ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Poruꞌo Panapasiꞌo pu puꞌúmo naꞌia mapoka niꞌimaꞌuraꞌe ninakaravume ꞌee ea kaꞌene Godi nimaa rojiꞌinijipo Poru ho Panapasi ho ꞌee ea ꞌahoꞌa kaꞌene nimaa rojiꞌinijihi puꞌúmo iji pijihume Jerusaremi apasoru ꞌee ea eruta ꞌahoꞌa kaꞌene hijajihipuni nini ike ꞌwama amairiꞌirono vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ꞌEjume ijí sosia kajara irechamiume pu vaꞌe Ponisia ꞌee Sameria ijino usevara. Pu icháꞌinaꞌe Godi Jenitaru vejume Godoni ea rejaji nirisajihe ꞌwaravume Godoni ehija henareja teamanamana. ");
INSERT INTO mcq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ꞌEjume pu vaꞌe Jerusaremi usevume sosia ꞌee apasorua ꞌee erutapo pu ꞌajorame aheravara. ꞌEjume pu Godira pu puꞌúmo uneunecha raka kaꞌene vejajaho pu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ꞌEjume Parasia ꞌahoꞌa kaꞌene nimaa rojiꞌinijipo ꞌurine arini namiꞌi kaivo ijá ꞌiava Ja pu sisa ꞌuhuahe ꞌee ꞌwarave pu Mosisi oni tamana veꞌavara ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ꞌEꞌikaivo apasoru eruta ijipo vuꞌa kaji ꞌwama heꞌirono roe ahuvara. ");
INSERT INTO mcq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pu natohwa ꞌwame nakaraꞌeme Pitara ꞌurine arini namiꞌi kaivo ijá ꞌiama Vwehu nunakije ja nihejara. Nitama Godira joni vaji na iji pijihume nuni irijino Jenitaru Godoni vuꞌa maa maiuꞌina najahume pu hene nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Godira eaka mapoki jihipuni oja vajijaho nihena ki paranarena puaꞌe najaharena Huni ꞌAvena nú múhajaꞌinaꞌe pu mihana. ");
INSERT INTO mcq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hu kúmujaho núa ꞌee pua aniꞌina kaivo nimaa roijara puni oja vaji sisea soma amairiahana. ");
INSERT INTO mcq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ꞌEnakaivo ja rakijihunaꞌe Godi venakame ꞌee tisaiporua ahija miho? ꞌEne emahu nuna ꞌee núa areri paapehunijaho miho? ");
INSERT INTO mcq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ꞌEnakaivo Jesu kaꞌene Natohwi jihuni maiji vwihanúajara rejume nú maranúa jaꞌinaꞌe pu ꞌuꞌo ꞌunama nikwisuꞌina kajino vejume maraniana. ");
INSERT INTO mcq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Eaka mapoka kaꞌene ijí hija kajija pu masuani varirareasaha Panapasiꞌo Poruꞌo Godira raka kaꞌene pu puꞌúmo Jenitaru puni aacha ꞌee ea areri pavehuna kaꞌene vejaji ꞌwaravume hejara. ");
INSERT INTO mcq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pu vuꞌa ꞌwaravume paarejume Jemisira ꞌurine namine eha vene ijá ꞌiama Vwehu nunakije ike heha! ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimani ja niꞌwaravume ja nihejara. Godiho Jenitaru puni vaji ea ꞌahoꞌa Huni ihijihunaꞌe iji pijihe ꞌekana. ");
INSERT INTO mcq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ꞌEjukame ike ira ikara poropetia puni irijiꞌi nimaaꞌe renu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ike uneunecha kihipuni túnaꞌi Na kúꞌo ꞌunama roareje Teviti oni harai ara kaꞌene auma tirausahe paranajaho kúꞌo vene amairihuna. ");
INSERT INTO mcq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ijaꞌina vejakame ea ꞌahoꞌaka mapokijija Natohwijaho sahuna. ꞌEne Jenitaru kaꞌene Nuni ihijara ꞌumenajija ꞌuꞌo sarihuna. ");
INSERT INTO mcq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nitama Natohwijara ike vuꞌakaho ꞌwaramanaꞌomo Hu iviamai ijaꞌina kúꞌo ꞌwaramu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ꞌEnajihunaꞌe na vwihajujaho Jenitaru puni vaji Godoni taꞌarohe roujija nú ahija pamihuna. ");
INSERT INTO mcq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ꞌEnakaivo roe nú puni pasia vene ꞌwarave godi iraꞌata puni ꞌirumaka vajiꞌavajaho paine ꞌee ꞌuasa pavene hanuha ꞌaa rukina paiꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ꞌEnajihunaꞌe naꞌia mapokaꞌe Sapati veijino Mosisi rone Sinakoku vaji tahujaho ja nihejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ꞌEꞌeme apasorua ꞌee eruta ꞌee sosia mahoꞌo hejume nimaaꞌe rejume pu ea puni vaja kajino Panapasiꞌo Porui puꞌúmo Enitioki vaꞌavarono Jutasi kaꞌene Pasapasiꞌo Sairasiꞌo nimaa rojiꞌina puni vaja kajino ea uraniiꞌinaꞌomo ijí ija pijihara. ");
INSERT INTO mcq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pu pasikaho apena vaꞌara. Apasorua ꞌee vwehu nuna kaꞌene eruta ijipo vwehu nuna kaꞌene Enitioki ꞌee Siria ꞌee Sirisia Jenitarua kaꞌene hijujihi ꞌajorame Esuꞌua ꞌiavu. ");
INSERT INTO mcq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nú nihiꞌejuꞌe núni vajakino ea ꞌahopu nú paꞌwaraꞌejuꞌe vuꞌajime ira ani ꞌwaravuꞌe ja iviamaa joni vwiha puruva retiu. ");
INSERT INTO mcq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ꞌEnajihunaꞌe nú ahuma hine ꞌwama amairiuꞌe mamaa rejuꞌe ea iji pijihe irechamiuꞌe Panapasiꞌo Porui puꞌúmo joni vuꞌu. ");
INSERT INTO mcq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ea ikija puni hia núni Natohwa kaꞌene Jesu Keriso oni ihijihunaꞌe hami pahijura. ");
INSERT INTO mcq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nú ijihunaꞌe Jutasiꞌo Sairasiꞌo irechamiume joni vuꞌuraꞌomo ijipo pura puni irijino vuꞌa nikwinuꞌina kajaho ꞌwarahuna. ");
INSERT INTO mcq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nú Godoni ꞌAvenijihi puꞌúmo vwihajujaho nú unenuꞌu pina ahisina joni haha ꞌaha paranavu. ꞌEnakúne ja ikeru veꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ja godi iraꞌata puni ꞌiruma kaꞌene vajihujaho paine ꞌee ꞌaa paine ꞌee hanuha kaꞌene ꞌaa rukina paine ꞌee ꞌuasa paveꞌavara. Ijaꞌina veꞌavajaho ja mavarasaꞌina vena avahuna. Esuꞌua ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pu ea kajija irechamiume kami Enitioki vaꞌara. ꞌEnareja pu sosia ꞌivume roa ahuvume pasia kajaho mihara. ");
INSERT INTO mcq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ꞌEjumakame pasia ꞌaha kajino vuꞌa kaꞌene niꞌajihe ꞌwaravaji taha kamareja pu nihoꞌo teamanama parajara. ");
INSERT INTO mcq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jutasiꞌo Sairasiꞌo poropetiaꞌomo pu noꞌo vuꞌa ꞌahoꞌa ijá kajihipuni nimaa rojujara kisinaꞌe reꞌamarono niꞌajihe ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ꞌEnareja pu noꞌo ijino ꞌaha josu hinareja ijiꞌa vwehwapo irechamiume ꞌuname ea kaꞌene pu irechamiume roajihipuni vaꞌi vejumakiviꞌi pu ꞌajoravume pu noꞌo vaꞌiro vejara vo ");
INSERT INTO mcq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sairasiho hu ura ijino hiꞌiro ꞌahaume hinana. ");
INSERT INTO mcq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ꞌEnakaivo Poruꞌo Panapasiꞌo ijino Enitioki naꞌia ꞌahoꞌa hine ea ꞌaho puꞌúmo hine Natohwi jihuni vuꞌa najahe ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ꞌEnaꞌomo naꞌia pini Poru Panapasi ijá ꞌwama Roe vaꞌe araka mapokakino Natohwi jihuni ira kaꞌene nú noꞌo najahajija vwehu núna icháꞌina vejiꞌi hijukúne kiva ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ꞌEjume Panapasira ura renajaho Joni kaꞌene Makana ꞌwavujara pu puꞌúmo vahunaꞌe ura renana. ");
INSERT INTO mcq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ꞌEnakaivo Porura vwihanajaho maiꞌo areria parenana. Ijihuni maijaho hu naꞌi pini pu puꞌúmo vaꞌu vaꞌo vaꞌe Pamipiria rene ranamúe ꞌunama roꞌi kaivo hu pu puꞌúmo kaukara pavena vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ꞌEjumakame pu panimaa vetiarame ranaꞌarame Panapasira Makaho aheme sisima ajime Saiparasi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ꞌEjume vwehwapo ꞌurine Natohwi jihuni maiji vwihaniuni vajijino irechamiume Porura Sairasi aheme vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ꞌEjume hu vaꞌe Siria ꞌeꞌune ꞌee vaꞌe Sirisia vaꞌana. ꞌEne sosia kaꞌene ijino hijujija ata kisi namiꞌavarono vuꞌa niꞌajihe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ꞌEnarena hu Tepi ꞌee Risitara ꞌuꞌo roana. ꞌEꞌeme tisaiporua pina ijí hinuna. Huni ihijaho Timotina. Huni ohijaho Jua ꞌee hu nimaa rojiꞌina kaivo huni omijaho Kuriki. ");
INSERT INTO mcq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ea kaꞌene nimaa rojiꞌinaka Risitara hine Aikoniami hijujija Timoti taꞌarohareꞌe hu ea maa ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ꞌEjumakame Jua mapoka kaꞌene ijino hijujipo hejajaho huni omijaho Kuriki orijihunaꞌe Poruho ura Timotira hu huꞌúmo vaꞌamarono hu apene sisa ꞌuhuahara. ");
INSERT INTO mcq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ꞌEꞌeme pu vaꞌe arara kajino vaiꞌi raka kaꞌene Jerusaremi apasorua ꞌee emakinijipo ꞌwarahunaka ꞌwama amairiajaho veꞌavarono ꞌwarama apena ojara. ");
INSERT INTO mcq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ꞌEjume hu sosia niꞌajihume puni nimairoa kisina reꞌeme veku veku ea roe ahumahiꞌi namana. ");
INSERT INTO mcq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ꞌEnareja pu Esia vuꞌa paꞌwaraꞌavarono Godoni ꞌAveni rarejume pu vaꞌe Pirijia useme ꞌee Karesia usevara. ");
INSERT INTO mcq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ꞌEjume pu vaꞌe Maisia vaꞌareja pu ura Pitinia vaꞌi ꞌahiana kaivo Jesuni ꞌAveni tanuꞌurihana. ");
INSERT INTO mcq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ꞌEjume Maisia asime pu kami Turoasi roara. ");
INSERT INTO mcq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ꞌEnarena ijino naꞌi Poruho visoni kavume ea pina Mesatonia ori arini namijiꞌi ijá ꞌwama A Mesatonia roe nú niꞌajúha ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Poruho visoni kajaho kavume paꞌareꞌeme niꞌaha kwino ꞌurine ꞌunama kaꞌene Mesatonia vahuniji samana. ꞌEnaꞌomo Godi ura nú vaꞌe Huni vuꞌa maa maiuꞌina ea kaꞌene Mesatonia hijuji najahuna ura rejuꞌe nú ꞌumenuu. ");
INSERT INTO mcq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ꞌEnaꞌomo nú vaꞌe sisima ꞌahi ajime Turoasi rena arira vaꞌe Samataresi usevaraꞌomo ijihuni súꞌu kajino vaꞌe Niaparisi usevara. ");
INSERT INTO mcq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ꞌEjaraꞌomo ijí rena vaꞌe Piripai usevara. Ijaho Mesatonia opuni kwaa niꞌinaꞌomo nitama Romuupo ꞌajoharaꞌomo nú ijino naꞌia makacharo hijara. ");
INSERT INTO mcq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sapati veijino nú ari vwicha asima tohurori vwihajajaho siporua ꞌohuni tinia namu roꞌikaꞌi vaꞌara. ꞌEne nú vaꞌe asuma hine napara kaꞌene ijino ahuvajihi vuꞌa ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ꞌEnakaivo napara pina huni iha Ritiane ꞌee hu Taiataira ora kaivo hu ateha aviꞌina vene ea ꞌahoꞌa ꞌimenauna ꞌee Godi oja mahiꞌinaꞌomo Natohwijara huni oja jaraume Porura ꞌwaramajaho hene venana. ");
INSERT INTO mcq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hua ꞌee huni kachiꞌina toi samaume ꞌurinareja ijá ꞌiama Ja na kive na Natohwi jihuni ea nimaaꞌe kiꞌavajaho roe nuni sei hiha ꞌiamana. Nú huni sei vaꞌe hiꞌavarono hu nihoꞌo ꞌejahúana. ");
INSERT INTO mcq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Naꞌi pini nú vaꞌe siporua ꞌojuri ruhijino vaꞌiro vaꞌi kavume napara pina ea pipuni pweaꞌomo hu piunúmana. Ijí napara kajaho ꞌavena sisea ajiviꞌinaꞌomo ijí ꞌavena sisea kajara hu vejuꞌe hu vuꞌa kaꞌene maiꞌo rehunijija ꞌwarame ꞌee huni natohwijihuni monia mapokaꞌe venahuna. ");
INSERT INTO mcq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ike napara kajara nú Poruꞌi puꞌúmo ꞌararihua roiꞌi ajira ijá ꞌumena Ike ea kijahija Godia kaꞌene Ichuto Maijihuni pwehija pu nú Godira niꞌajihuni ꞌunamiji najuhu ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hu naꞌia mapoka ijaiharu vejume Poru hene sevume hu taꞌarohe ꞌavena sisea kajaho ijá ꞌwama Na Jesu Keriso oni ihi ꞌurahiꞌi ꞌwaravukúne ro ꞌeꞌuna ꞌwamana. ꞌEjume nijakaru roe ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vea kaꞌene huni mamaꞌinijipo kavume pura moniaꞌe kúꞌo ꞌekahuni ꞌunama paꞌarejumakame pu Poruꞌo Sairasiꞌo iji ꞌunirame irisamie maketia vejuri tinijino vaꞌe emakipo hijari unaꞌijino irechamiara. ");
INSERT INTO mcq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ꞌEnareja pu ꞌeka vaꞌe ꞌotua hejiꞌina mamaꞌini jihipuni vaꞌe ijá ꞌiava Ike Juakipo núni ara ikaho vejuꞌe nihoꞌo puruva rene namu. ");
INSERT INTO mcq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pu noꞌo tamana kaꞌene nú Romu ora pavejuji nú veꞌavarono pu roa ꞌwaruvara ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ꞌEjukame ea mapoka kaꞌene ijí ahuma hija kajija pu ꞌuꞌo namahara. ꞌEjuꞌukame ꞌotua hijiꞌina ea mamaꞌina kajipo ꞌurine ateha jahenahe isokuniꞌi ꞌwaravume hisi apene hijihara. ");
INSERT INTO mcq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ꞌEnareja pu hijihareja ijiꞌa pu tipurai irechamiareja ea kaꞌene tipura ꞌajohiꞌinijara hami ꞌaiha venahuna ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Hu ijí hinarena hu pu noꞌo irechamiume tipura ara kaꞌene vamaa kahino hijara. ꞌEjumakiviꞌi hu ꞌeke puni mumora kamorame irechamiume hijara. ");
INSERT INTO mcq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ꞌEjaraꞌomo naꞌia rimai Poruꞌo Sairasiꞌo hine siporua ꞌone ꞌee javaa vene Godi taꞌarohiꞌi hiꞌeme tipura ea ꞌahoꞌijaho hine hejiꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ꞌEꞌeme niꞌaha kwino mwe varivura niꞌimaꞌuri roarena ijí tipura ara kajaho nihoꞌo erapo ꞌunamapene ꞌusivuja reꞌeme vwichaka mapoka kajaho niꞌaha kwino tirausahe ꞌee senia kaꞌene mumora ꞌahi kamoravajaho niꞌaha kwino rausahe arihara. ");
INSERT INTO mcq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ꞌEꞌeme ea kaꞌene ijí tipura ara kaji ꞌajohiꞌinijaho ꞌurijiꞌi kamajaho vwicha mapokijaho tiraꞌusunaha navuma kimarena hu vwihanajaho eaka mapoka kaꞌene tipura ea kajija ni useme juhaha vaꞌara ronarena hu ꞌurine huni soꞌwa taꞌarohe apene oriꞌini pijaꞌaraꞌi venana. ");
INSERT INTO mcq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ꞌEnakaivo Porura ajira ijá ꞌumena A orono paꞌanaaraꞌamana. Nú ikeho hijukúnina ꞌumenana. ");
INSERT INTO mcq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ꞌEjume tipura ara ꞌajohiꞌina kajara ajira ijá ꞌumena Ira ape roa ꞌumejume ape roumakiviꞌi ninuma vaji vaꞌe hu jume simaviꞌi ꞌona apene arihe Poruꞌo Sairasiꞌo puni nini namana. ");
INSERT INTO mcq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ꞌEnarena hu pu noꞌo aherame vaꞌe maꞌahi ꞌeꞌune ijá ꞌiama Eakije! Na icháꞌina veje Godi na niꞌajihe maraniama ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ꞌEjume pu hu ijá ꞌwava Jesu kaꞌene Natohwiji nimaa rojakamaꞌe aaꞌe oni kachiꞌina ꞌuꞌo niꞌajihe maraniama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ꞌEnareja pu Natohu ijihuni vuꞌa hua ꞌee ea ꞌahoꞌa kaꞌene huni sei hijajija najahara. ");
INSERT INTO mcq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ꞌEjumakame ijí naꞌia rira kajino hu pu noꞌo aherama vaꞌe puni túpa ꞌaha ꞌai sama nama kajaho somahana. ꞌEjume pu niꞌaha kwinu hua ꞌee huni kachiꞌina kajihi puꞌúmo ꞌunirame toi samaara. ");
INSERT INTO mcq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ꞌEjume hu pu noꞌo aherame huni sei vaꞌe ꞌiruma vajihume pu ijara. ꞌEjume hu ꞌee huni kachiꞌina puꞌúmo Godi nimaa rojajihunaꞌe pu niꞌimaꞌura teamanavara. ");
INSERT INTO mcq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ꞌEꞌeme vea nituvume súꞌo ea kaꞌene ꞌotua hejiꞌina ꞌajohaujipo hirisima irechamiume pu roe ijá ꞌiava Ike eakija irechamie vaꞌa ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ꞌEjume ea kaꞌene tipura ara ꞌajohiꞌinijara vuꞌa kajaho hene roe Poru ꞌwaramarena ijá ꞌwama Ea kaꞌene ꞌotua hejiꞌina ꞌajohujipo nú ja irechamie vaꞌavarono ꞌwaruvara. ꞌEnakúne ike tipura arakaho areꞌi kaivo ꞌurine vaꞌaha. ꞌEjakame joni oja masuani naꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ꞌEnakaivo Poru pu ijá ꞌiama Nú Romu ora kaivo pu nú unenuꞌu pina sisei veje ꞌotu vetúhuna pana. Pu majikari nú ꞌanúara. Eaka mapoki jihipuni nia ꞌahi. ꞌEnareja pu ꞌekua roe tipurai samuara. ꞌEnaꞌomo iviamaa pu nesi ꞌwamonu vaꞌo nú irechamúꞌirono avajo? Nihoꞌo areri parenu. Pu opuipo roe nú aheruma vaꞌe maꞌahi irechamúhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ꞌEjume hirisima kajipo vuꞌa kajaho roe ea kaꞌene ꞌotua hejiꞌina puni ꞌajohaꞌinijihi ꞌwaravara. Pu ijá ꞌiava Pu Romu ora ꞌiavume hejajaho pu nihoꞌo tea junavara. ");
INSERT INTO mcq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ꞌEjume pu temukavume vaꞌe ꞌajorame nirisamu vaꞌume irechamiume pu maꞌahi vaꞌara. ꞌEjume pu ijá ꞌiava Nijinakúne vaꞌajiha ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ꞌEjume pu tipura rene usema Ritia oni sei vaꞌara. ꞌEjiꞌi kivume ea kaꞌene nimaa rojiꞌinijija ijino hijuma kimareja pu vuꞌa niꞌajihe ꞌwaramareja ijiꞌa vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ꞌEnareja pu vaꞌe Emipiporisi asima vaꞌe Aparonia asima vaꞌe Tesaronaikai Jua puni Sinakoku naminunaꞌomo ijí usevara. ");
INSERT INTO mcq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ꞌEjume Poru oni tamanaꞌomo hu puni vaꞌe Sapati noꞌopisu pu puꞌúmo Godoni ira vaji tahe piraꞌaravara. ");
INSERT INTO mcq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ꞌEnarena hu pu Godoni vuꞌijihuni maiji najaharena hu ijá ꞌiama Godira vejume Keriso kajaho siseꞌi ꞌahaume kwamarena kúꞌo ꞌurinana. ꞌEnarena ike Jesu kaꞌene na ja ꞌwaravu kajaho Kerisona ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pu ea ꞌahoꞌa nimaa ronareja Poruꞌo Sairasi punaꞌi rejara ꞌee Kuriki mapoka kaꞌene Godi juhaviꞌina ꞌee napara uraniiꞌina kaꞌene ijí hijujija pununaꞌi rejara. ");
INSERT INTO mcq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ꞌEnakaivo Jua pu nihoꞌo senavumakame pu maketi ea sisea aherame ahuma hina ara vaja kajaho karokaha vejara. ꞌEne Jesani oni sei pu sarame aherame emaapuni vaꞌirono roara. ");
INSERT INTO mcq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ꞌEnakaivo pu papiunimareja pu Jesaniho ꞌee ea ꞌahoꞌa kaꞌene nimaa rojiꞌinijija pu irisama vaꞌe ara kajihuni ea mamaꞌina puni nini vaꞌara. ꞌEnareja pu ijá ꞌumeja Ea kaꞌene mweꞌakake ꞌunama apene taꞌarohujija ꞌuꞌo iki roara. ");
INSERT INTO mcq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jesanira Sisa oni varapa ꞌenareꞌe ea ikija aherame ijá ꞌúvu Kinia pina Jesuna ꞌúvu ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ꞌEjumakame eaka mapoka kaꞌene ara kajino hijura ꞌee ara kajihuni ea mamaꞌina ijí henareja pu nihoꞌo ꞌurimaravume ani renana. ");
INSERT INTO mcq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ꞌEnareja pu Jesaniho ꞌee ea ꞌahoꞌa kajihi puni moni ꞌekaꞌi kaivo pu irechamiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ꞌEnareja ijihuni naꞌi kajino ea kaꞌene nimaa rojiꞌinijipo Poruꞌo Sairasiꞌo irechamiume Peria vaꞌara. ꞌEnareja pu vaꞌe usevajaho Jua puni Sinakoku vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ꞌEjume ea kaꞌene ijí hijujaho puni vwiha mamaa vwihajiꞌinaꞌomo pura Tesaronaika ora asitahara. Ijihuni maijaho pu Godoni irijaho ura rena paraniꞌeme apene ꞌee naꞌia mapoka tahe ꞌee ꞌeka manura vene kivura. ");
INSERT INTO mcq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ꞌEnareja ea mapoka ijihunaꞌe nimaa rojume ꞌee Kuriki napara ꞌee parua ꞌahoꞌa kaꞌene iha rukinijija ꞌuꞌo nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ꞌEjumakame Jua kaꞌene Tesaronaika hijujipo hejajaho Poruho Godoni vuꞌa Peria ꞌuꞌo najahuma henareja pu vaꞌe eaka mapoka kajihipo varapa veꞌavarono oja inaara. ");
INSERT INTO mcq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ꞌEjumakame niꞌaha kwino ea kaꞌene nimaa rojiꞌina kajipo Poruho ranavume soha rori vaꞌana. ꞌEꞌeme Sairasiꞌo Timotiꞌo ijino hijara. ");
INSERT INTO mcq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ꞌEꞌeme ea ꞌahoꞌa Poru ahema apene vaꞌe Etenisi usevume hu ona vene ijá ꞌiama Sairasiꞌo Timotiꞌo marako nuni roꞌavara ꞌiavume pu vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ꞌEꞌikaivo Poruho ijino Etenisi pua ajiha hinajaho huni oja nihoꞌo areri parenana. Ijihuni maijaho ijí ara kajaho godia kaꞌene iji vejajipo nihoꞌo ani rena navara. ");
INSERT INTO mcq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ꞌEjumakame hu vaꞌe Sinakoku vaji vaꞌe Jua ꞌee Jenitarua kaꞌene Godi juhaviꞌinijihi puꞌúmo piraꞌarame ꞌee maketi vaji ea irahipo roe ijí hijujihi puꞌúmo piraꞌaravara. ");
INSERT INTO mcq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikuriani ora ꞌee Sitoika ora kaꞌene hena kaviꞌinijipo Poru piuname pu puꞌúmo nakaravara. ꞌEjume ea kajihuni ea ꞌahoꞌijipo ijá ꞌwava Ike eakaho iraka vene hina kasiꞌuamo ꞌwavara. ꞌEjume ea ꞌahopo ijá ꞌiava Nú vwihajujaho hu ea ꞌahopuni Godi rona ꞌwaramu. Ijihuni maijaho Jesuni vuꞌa ꞌee Huni ꞌurinaji rone ꞌwarumu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ꞌEnareja pu Poruho ahema Eriopakasi puni roara. ꞌEnareja pu hu apoma ijá ꞌwava A raka maiuꞌina kaꞌene najahujaho nú ꞌwaruva heja? ");
INSERT INTO mcq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ijihuni maijaho a uneunecha aniꞌina kaꞌene ꞌwaruvuꞌe nú hejujihi puni maiji heꞌi ꞌahúu ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ꞌEjume pu ea mapoka kaꞌene Etenisi hijujaho ꞌee ea ꞌahoꞌa kaꞌene ara ꞌahoꞌi rena roe ijino hijujija naꞌia mapoka pu mahine vuꞌa maiuꞌina hene ꞌee ꞌwaviꞌi hijura. ");
INSERT INTO mcq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ꞌEjume Poru ꞌurine Eriopakasi puni riri namijiꞌi ijá ꞌiama Etenisi orakije na kivujaho ja ꞌunama jaa jaa akuma parajiꞌina kivu. ");
INSERT INTO mcq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na iki joni ara vaji hina ꞌurahojiꞌi ja uneunecha mapoka kaꞌene vejuꞌe unenuꞌu ꞌahoꞌa punaꞌi rejiꞌinijaho na nikivu kaivo ruha pinaka ja asura vejajaho Godi pina kaꞌene nú pakavu jihuni ruha ꞌwavaraꞌe kavuta. Ja Godi kajaho pahejura kaivo ja oja mahu kaji na Hu rone ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Godira mweꞌa vene uneunecha mapoka kaꞌene ijihuni toi navujaho venana. Hu akúpa mweꞌa ijihuni Natohwaꞌomo Temiporua kaꞌene emaapo iji vejujihi puni vaja pahinuna. ");
INSERT INTO mcq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Emapo uneunecha kaꞌene iji vejuji Hunaꞌe venahuna pane ꞌee unenuꞌu pina Hua ura rehuna pana. Ijihuni maijaho Hura Huhusu hia ꞌee uruhoa ꞌee uneunecha mahoꞌo vajihuna. ");
INSERT INTO mcq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hu ea mapoka kaꞌene kwaaka mapokaki hijujija vejume ea kwinu huni rena roara. ꞌEnarena Hu vejume ea mapoka kwaaka mapokakino vaꞌajime hijara. Hu pura mweꞌa iki hihuni vea raname kwaa kaꞌene hina apena ohunijaho mweꞌa sisa ꞌuhua vajihana. ");
INSERT INTO mcq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ꞌEnajihunaꞌe Hu ea mapoka Huni rohunijara ura renu. ꞌEne pu ura renakame Godi saꞌavajaho pu nimaa kahuna. Ijihuni maijaho Hu núni romai hinuna. ");
INSERT INTO mcq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ijihuni maijaho Huni vajiji nú hine ꞌee ꞌurahone ꞌee hina apena vaꞌu. Areri joni ea ꞌahoꞌa kaꞌene vuꞌa ꞌwaraviꞌinijipo ꞌwaramareja ijá ꞌúvare Nú Huni amuhija ꞌúvara. ");
INSERT INTO mcq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nú nimaa Godoni amuhijaꞌomo nú ijaꞌina pavwihahuna. Huni kara ijaho areri korutia ꞌee siruva ꞌee muna ijino emaapo iji vejara parohuna. ");
INSERT INTO mcq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ꞌEne Godi nitama kamaꞌahuni emaapo pahena pakavajaho pavwihanu kaivo Hu ꞌwaramajaho eaka mapokake mweꞌa kakino hijujija mahoꞌo sisea aremamaa areꞌi kaivo taꞌarohunaꞌe ura renu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ijihuni maijaho Hura mweꞌake ꞌotua arimaa ea kaꞌene iji pijaha jihuni vaji vetihunijaho vea niranamana. Hu ijí ea mahoꞌo najaharena Hu vejume kwamajaho ꞌurinana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pu heꞌeme ijí kwama ꞌurina kaji ꞌwaravume hejajaho ea ꞌahoꞌa ijasahume ꞌee ea ꞌahoꞌa ijá ꞌwava Nú kúꞌo vuꞌa ikaho heꞌi ꞌahúu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ꞌEjume Poruho puni vaja areꞌikaꞌi samai vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ea ꞌahoꞌa pu puꞌúmo rene nimaa rojara. ꞌEꞌeme puni vaja kajino Taionisiasi Eriopakite opuni ea ꞌee napara pina huni iha Tamarisi ꞌee ea ꞌahoꞌa ꞌuꞌunaꞌomo pu nimaa rojara. ");
INSERT INTO mcq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ikihi puni túnaꞌi hu Etenisi areme ꞌurine Koriniti vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ꞌEnarena hu ijino Jua pina huni iha Akwiraho piunamana. Ea kajaho Ponitasi nahejara. ꞌEnaꞌomo hu naparaha Pisiraꞌi Itari rene roara. Ijihuni maijaho Korotiasira Jua mahoꞌo Romu areꞌavarono ꞌwaramana. ꞌEnaꞌomo hu puni roana. ");
INSERT INTO mcq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ꞌEjume hu pura kaukara kaꞌene vejujaꞌinaꞌe hu ꞌuꞌo venunaꞌomo hu pu puꞌúmo ahuma hine kaukara vejara. Ijihuni maijaho pu harai ara vejiꞌina. ");
INSERT INTO mcq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ꞌEnareꞌe Sapati vea mapoka kajija hu vaꞌe Sinakoku vaji Jua ꞌee Kuriki epo hununaꞌi roꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ꞌEꞌeme Sairasiꞌo Timotiꞌi Mesatonia rene roara. Poruho naꞌia mapoka huni vea natohwa Godoni ira toi raname hine Jua najahe ijá ꞌiama Jesuho Kerisona ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ꞌEjume Jua kajija pu huni ira pataarohe pu hine ira sisea ꞌwaravara. ꞌEjume hu huni ateha túa taireviꞌi ijá ꞌiama Joni ꞌaa ijaho joni húmata ꞌahinaꞌomo na ahija paꞌana. ꞌEnaꞌomo na iviasi rene Jenitaru puni vahuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ꞌEnarena hu ijaho areꞌikaꞌi vaꞌe ea pina huni iha Taitasi Jasitasi kaꞌene Godi oja mahiꞌini jihuni sei vaꞌana. Huni seijaho Sinakoku romaina. ");
INSERT INTO mcq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ꞌEnakaivo ea pina huni iha Karisipasina hu Sinakoku ꞌajohiꞌinaꞌomo hu Natohwijaho nimaa ronana. ꞌEjumakame huni kachiꞌina noꞌone ꞌee Korinitia ora mapoka hene nimaa rojara. Ijihunaꞌe pu toi samaara. ");
INSERT INTO mcq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ꞌEꞌeme naꞌii Natohwijara Poru visoni vaji ijá ꞌwama A nihoꞌo pajuꞌamana kaivo siheria paveꞌikaꞌi ꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Na a huꞌúmunaꞌomo ea pina nihoꞌo a pasiseꞌi ꞌahahuna. Ijihuni maijaho Nuni ea mapokaꞌe ara ikino hiju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ꞌEjume Poruho juara kwinune masapa iropuꞌa kwino ijí hine Godoni vuꞌa pu najahana. ");
INSERT INTO mcq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ꞌEnakaivo vea kaꞌene Kario Akaia opuni ea Natohwa renajihuni vea kajino Juapo ꞌurine Porunaꞌi sena vejara. Pu hu apena ꞌotua asúki vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ꞌEnareja pu hu namahe ijá ꞌwava Ike eakaho nuni tamana pataarohe ea ꞌwaravuꞌe pu Godi aniꞌina oja mahu ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ꞌEjume Poruho maiꞌo ꞌwaraꞌi veꞌeme Kariora Jua ijá ꞌiama Ikaho unenuꞌu pina sisea reꞌipisa na joni ira hene vejuꞌu. ");
INSERT INTO mcq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ꞌEnakaivo ja joni ira ꞌee iha ꞌee joni tamana ijihuna aporiꞌavajaho na paheꞌejukúne vaꞌe ojono kaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ꞌEꞌikaivo hu ꞌotua asúka ꞌararihiume pu usema vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ꞌEnareja Sositanisi Sinakoku kajihuni ea niꞌinaꞌomo pu ꞌunama apena ꞌotua asúka unaꞌi hijahara kaivo Karioho kima pataarorahana. ");
INSERT INTO mcq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ꞌEjume hu Poruho ijino ꞌaha joraꞌe hinarena ea kaꞌene nimaa rojiꞌinijihija irechamiꞌi kaivo sisima ajime Pisiraho ꞌee Akwirai puꞌúmo Siriai vaꞌara. ꞌEne Senikeria ꞌeꞌune huni húmata sapasa ꞌuhuana. Ijihuni maijaho hu varapa areme hinana. ");
INSERT INTO mcq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ꞌEnareja pu vaꞌe Epasasi usemareja hu pu ijí irechamiꞌi kaivo hu vaꞌe Sinakoku vaji arume vaꞌe pu puꞌúmo hine ꞌwame piraꞌaraviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ꞌEnareja pu hu ijí ꞌaha jora hiꞌamarono pu jarivara kaivo hu rarenana. ");
INSERT INTO mcq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ꞌEnarena hu pu irechamie ijá ꞌiama Godira kúꞌo na iki roꞌurono ura reꞌamajaho na rohuna ꞌiꞌi kaivo hu Epasasi rene sisima ꞌahi ajima vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ꞌEne vaꞌe Sesaria ꞌeꞌune ajima vaꞌe Keriso oni ea ꞌajoramarena Enitioki vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ꞌEnarena hu ijino naꞌia ꞌahoꞌa hinarena hu ijiꞌa vaꞌe Karesia ꞌee Pirijia opuni ara ara kajino vaꞌana. ꞌEnarena hu ea kaꞌene nimaa rojiꞌinijija niꞌajihe ꞌata kisi namiꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jua ea pina huni ihijaho Aparasina. Hu Arekisanituria nahejara ꞌee vuꞌa arira ꞌwaraviꞌinaꞌomo hu roe Epasasi hinana. ꞌEne hu Godoni ira hena kaviꞌina. ");
INSERT INTO mcq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Hu Natohwi jihuni ꞌunama naharaꞌomo huni oja vaja venakaka reꞌejuꞌe hu Jesu rone ꞌwarame ꞌee arira najahuna kaivo hu Jonira ea toi samaajiru henuna. ");
INSERT INTO mcq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ꞌEnaꞌomo hu vaꞌe Sinakoku vaji pajuꞌikaꞌi najahuna. ꞌEjume Akwiraꞌo Pisiraꞌo henareja hu ahema vaꞌe Godoni ꞌunama huri kúꞌo hami nahara. ");
INSERT INTO mcq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ꞌEjume hu Akea vaꞌiro ura rejume ea nimaa rojiꞌina kaꞌene ijino hijujipo niꞌajahe tisaiporuapo roe hu ꞌajahe ahehunaꞌe vejara. Hu vaꞌe ijí ꞌeꞌunarena ea kaꞌene maiji vwihaniꞌina vaji nimaa rojajija niꞌimaꞌuraꞌe niꞌajihana. ");
INSERT INTO mcq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Hu ea mapoka kajihi puni unaꞌi Jua ninamaꞌe Godoni irijino najahiꞌi ijá ꞌiama Jesuho Kerisona ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aparasiho Koriniti hiꞌeme Poruho ꞌunama hurunami Epasasi roe tisaiporua ꞌahoꞌa piunimana. ");
INSERT INTO mcq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ꞌEnarena pu ijá ꞌiama ꞌÚ veaka ja nimaa rojajaho ja Godoni ꞌAvena niapejare? ꞌiavume pu hu ijá ꞌwava Pana. Nú Godoni ꞌAvena ijino hinu ho paꞌajaho puruva renu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Hu ijá ꞌiama Ea irara toa samahajihunijino samahare? ꞌiamana. Pu ijá ꞌwava Jonira toa samahajihunijina ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ꞌEjume Porura ijá ꞌiama Jonira ea samajaho emaapo puni sisea areꞌi kaivo taꞌaroꞌavarono samaiꞌi ijá ꞌiama Ea kaꞌene nuni túnaꞌi rouji nimaa roꞌavara ꞌiamana. Ijaho Jesuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ꞌEjume pu ijí henareja Jesu kaꞌene Natohwi jihuni iha ꞌahi toi samaara. ");
INSERT INTO mcq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ꞌEjume Porura huni ija puni húmata ꞌahi irechaꞌeme Godoni ꞌAvena ariha roe pu samahume ira ani ani ꞌwame ꞌee túnaꞌi raka kaꞌene rehunijaho ꞌwaravara. ꞌEjume pu Godoni vuꞌa ea ꞌahoꞌa ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pu ea kaꞌene ijaꞌina vejajaho ea iropu ropu noꞌo avajara. ");
INSERT INTO mcq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ꞌEꞌeme hu vaꞌe Sinakoku vaji Godoni vuꞌa hine pajuꞌikaꞌi najaꞌeme masapa noꞌopisu paꞌarenana. Hu venae pu Godoni ariji nimaa roꞌavarono hu pu puꞌúmo hine piraꞌaramana. ");
INSERT INTO mcq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ꞌEnakaivo ea ꞌahoꞌa kirasaha parane ꞌee vuꞌa pahene ꞌee ira sisea ꞌUnama kaji rone ea mapoka puni unaꞌi ꞌwaravumakame Poruho pu irechamiꞌikaꞌi tisaiporua aherame vaꞌe Tiranasi oni sikuru ari najahe ꞌee piraꞌaraviꞌi hijara. ");
INSERT INTO mcq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ꞌEjumakame juara noꞌo vaja kajino Jua ꞌee Kuriki ora kaꞌene Esia vaji hijujija Natohwi jihuni vuꞌa hejara. ");
INSERT INTO mcq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ꞌEjume Poruho Godira harura mahume hu uneunecha mapokaꞌe ani ani ea areri pavehuna venana. ");
INSERT INTO mcq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ꞌEnareꞌe pu hununaꞌi akisia ꞌee ateha hasa ijino ea kaꞌene atama ꞌuniraviꞌinaꞌe ꞌee ꞌavena sisea ꞌajimaꞌina vajihuꞌe atama sonahiuꞌe ꞌee ꞌavena sisea ariha vaꞌura. ");
INSERT INTO mcq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ꞌEjuꞌukame Jua ꞌahoꞌa kaꞌene kwaaka mapoka kajino ꞌurahojiꞌi ea marirama apena ojujipo Jesu kaꞌene Natohwi jihuni ihi ꞌurahiꞌi ea kaꞌene ꞌavena sisei ajimahiꞌinijihi siomahe ijá ꞌiava Jesu kaꞌene Porura najahu jihuni ihi ꞌurahiꞌi ꞌwaravukúne useha ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ijaho Jua puni pirisitia niꞌinijaho Sivanaꞌomo harihwaha ea iropu noꞌo ijipo ijaꞌina vejara. ");
INSERT INTO mcq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ꞌEnakaivo ꞌavena sisea kajara eha vene ea kajihi ijá ꞌiava Nú Jesuho nihene kame ꞌee Poruho nihene kavura kaivo ja irahipune? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ꞌEjume ea kaꞌene ꞌavena sisei ajiviꞌina kajara ohurikune puni haha ꞌahi ajime rarene ꞌanie haha puachamie ꞌee ateha isokuniume maisu sea kajaho areme juhaha samai vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ꞌEjumakame ea kaꞌene Jua ꞌee Kuriki ora kaꞌene Epasasi hijajipo ijí vuꞌa kaji henareja pu tea junavara. ꞌEjumakame pu Jesu kaꞌene Natohwijaho taꞌarohara. ");
INSERT INTO mcq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ꞌEjumakame ea kaꞌene nimaa rojiꞌinijipo puni roajime pu raka kaꞌene sisea vejuji samai nahama ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ꞌEꞌeme ea mapoka kaꞌene atama rukina ꞌee ꞌúsia vejiꞌinijihipo pu puni puka kaꞌene ꞌúsia icháꞌina vejujija mapoka niꞌaha kwinu ꞌeke eaka mapoki jihipuni unaꞌi veni jaara. Uneunecha ikija monia mapoka mapoka (50,000 kina) ꞌimejara. ");
INSERT INTO mcq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ꞌEjume Natohwi jihuni vuꞌa emarene ꞌee rausahe ꞌee kisinaꞌe renana. ");
INSERT INTO mcq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ꞌEꞌeme ijihuni túnaꞌijino Poruho hina oja vaji vwihana ijá rona Na vaꞌe Mesatonia ꞌeꞌune vaꞌe Akea ꞌeꞌune vaꞌe Jerusaremi vahuna. ꞌEnareje ijihuni túnaꞌi na vaꞌe Romu ꞌuꞌo kahuna ronana. ");
INSERT INTO mcq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ꞌEnarena hu Timotiꞌo Irasitasiꞌo hu niꞌajahiꞌinaꞌomo nimarako irechamiume Mesatonia vaꞌara. ꞌEꞌeme hu ijino Esia vea maꞌuako hinana. ");
INSERT INTO mcq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ꞌEꞌeme ijihuni vea kajino ea ꞌahoꞌa Epasasi hijujija Natohwi jihuni ꞌunama senavumakame pu hine nihoꞌo niꞌimaꞌura ꞌuraara. ");
INSERT INTO mcq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ꞌEꞌeme ea pina huni iha Timiturisi ꞌwavuraꞌomo ijaho sirivaꞌi ꞌwavuji uneunecha venunaꞌomo huni kaukara siriva kajino godia naparaꞌe Aritimisi ꞌwavuji vesamuna. ꞌEjuꞌe ea mapokaꞌe kaukara kajaho vejura. ");
INSERT INTO mcq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ꞌEnarena hu ea kaꞌene kaukara nikwinuꞌina hura venu kajaꞌina vejiꞌinijihija ꞌumenaume ahuma roume hu ijá ꞌiama Ehu nune ja niheju. Nú ike kaukara iki venareꞌe nú hami mamaa hijura. ");
INSERT INTO mcq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ja nikama hejujaꞌinaꞌe Epasasieru pana kaivo Esia mahoꞌo ike Poru ikara venauꞌe ea mapoka ijá ꞌwavo godia kaꞌene iji vejujija godia pana ꞌúvu. ");
INSERT INTO mcq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ike núni kaukara ikara paꞌarene ꞌee varapi rehuneru pana kaivo napara godia iraꞌata natohwa kaꞌene Aritimisi oni Temiporua maa paꞌana reje ꞌee Esia ꞌee mweꞌa ikino hua oja mahe ꞌee huni pinanaka mamaijaho nihoꞌo paꞌarena vaꞌu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Vea kaꞌene pu ijí hejajaho nihoꞌo ajinama parajume ira ajira ijá ꞌumeja Aritimisiho Epasasi opuni niꞌina ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ꞌEnareja pu ea mapoka kaꞌene ara kajiꞌura kajija pu urimaravume ani rejumakaviꞌi Keasiꞌo Arisitakasiꞌo irisame ꞌeka vaꞌe ꞌotua vejuri sei vaꞌara. Pu noꞌo Mesatonia ora kaivo pu Poru oni napuhijaꞌomo hu ꞌajahe ojura. ");
INSERT INTO mcq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ꞌEnaꞌomo Poruho hu ura eaka mapoka kajihipuni vaji vaꞌi ꞌahaana kaivo ea kaꞌene nimaa rojiꞌinijipo tanuꞌurahara. ");
INSERT INTO mcq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ꞌEjume Esia ora mamaꞌina ꞌahoꞌa kaꞌene huni napuhijijipo hura hara tanuꞌurahe nuꞌúha vaja pavaꞌe aruꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ea mapoka kaꞌene ijí hija kajija puni vwiha ijaho puruva rene ani ani vwihajara. Ea ꞌahoꞌa vuꞌa kwino vwihajume ea ꞌahoꞌa pu vuꞌa ꞌahoꞌa ꞌumejara kaivo pura roe ahuma hija kajihuni maijaho pahejara. ");
INSERT INTO mcq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ꞌEnareja Juaka mapoka kajipo Arekisanitaho tairia apena vaꞌe raname ꞌejahaume hu vaꞌarena pu niꞌajiꞌirono ija ahasirime ruramana. ");
INSERT INTO mcq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ꞌEnakaivo eaka mapokijipo kama hejajaho hu Jua ora hejara. ꞌEnareja pu vea muka noꞌoheꞌi ea mapoka ꞌurina pakame ajira ijá ꞌumeja Aritimisiho Epasasi opuni niꞌinaꞌe ꞌumejiꞌi navara. ");
INSERT INTO mcq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ꞌEꞌeme Epasasi opuni ara huni karaka ijara ea mapoka ruramarena ijá ꞌiama Epasasi orakije! Ja ea irara Aritimisi kaꞌene niꞌini jihuni Temiporua ꞌee emaa saꞌina kaꞌene kahi akúpa ꞌahi rene ꞌonajiꞌi Epasasi opo ꞌajohaujaho pahejure? ");
INSERT INTO mcq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ꞌEnaꞌomo ea pina nú ike pavejura ꞌiahuna areria panakúne pavwihaꞌikaꞌi masuani hine ꞌohura paapeha. ");
INSERT INTO mcq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ja ea kaꞌene aherama roakija pu unenuꞌu pina joni Temiporua vaja kajaho nesi paapejara ꞌee pu ira sisea pina muni napara godia kehunaꞌa paꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ꞌEnakaivo ike ꞌotua vejuri ruhakaho vwicha tatiranavuꞌe ea kaꞌene ꞌotua vejiꞌinijaho ijí hinunaꞌomo Timitiriasiho ꞌee pwehwa puꞌúmo ea irahijaꞌe ꞌotua vetihuna reꞌavajaho roe ꞌotua vetia. ");
INSERT INTO mcq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ꞌEnakúne joni vuꞌa ꞌahoꞌa naꞌavajaho kanisoruapo vea kaꞌene pu ahuma hiꞌavaji ꞌwama amairihuna. ");
INSERT INTO mcq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nú iki hine ani ani vejujihuni maa panamunaꞌomo kamati maiꞌo ꞌotua niꞌimaꞌura nú vetúhuna. ꞌEje nisi ike nú roe ahuvukaho maa paꞌanaꞌe rehuna ꞌiamana. Noinnisi ike nú roe ahuvukaho maa paꞌanaꞌe rehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ꞌEjume hu ijá ꞌwaraꞌi kaivo ea kaꞌene ahuma hija kajija irechamiume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ea kajipo iranoꞌa kaꞌene apejajaho paꞌareꞌeme Porura tisaiporu ꞌwaravume nianaa roume pu vuꞌa niꞌajihe ꞌwaramarena irechamiꞌikaꞌi hu Mesatoniai vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ꞌEnarena hu ijí ara ara kajino ea kaꞌene nimaa rojiꞌina kaꞌene hinapene oju kajihi vuꞌa niꞌajihe ꞌwarame roe Kurisi ꞌeꞌunana. ");
INSERT INTO mcq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ꞌEnarena hu ijino masapa noꞌopisu hinarena hu ꞌurine sisima ꞌahi Siria vaꞌi veꞌeme Juapo hu ꞌanae kwahuna ꞌwavuma henarena hu areme ꞌuname Mesatonia ꞌunami vahuna vwihanana. ");
INSERT INTO mcq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ea ꞌahoꞌa Sopata ho Peria ora kaꞌene Pairusi oni harihijaho ꞌee Arisitakasi ho ꞌee Sekunitasiꞌo Tesaronaika ora ꞌee Keasi ho Tepi ora ꞌee Timoti ho Tichikasi ho Turopimasi ho ijano Esia oraꞌomo pu puꞌúmo vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ꞌEꞌeme ikeja pu urasaha vaꞌe Turoasi ꞌajúha hijara. ");
INSERT INTO mcq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Puretia kaꞌene isitia paꞌajihuni vea paꞌarejumakaviꞌi nú sisima ꞌahi ajime Piripai rena vaꞌeme naꞌia iropu paraꞌeme pu Turoasi hiꞌeme nú ro ijí usevara. ꞌEnareja nú ijí hiꞌeme hura kwino paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hura Natohwijino nú ahuma hine puretia tuachama iꞌi veꞌeme Poruho hu niari vahuni jihunaꞌe huni vuꞌa ꞌaha joraꞌe ꞌwarama apene vaꞌe naꞌia rimai aremana. ");
INSERT INTO mcq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ꞌEꞌeme ijí huri núra hija kajaho naheha mapokaꞌe navara. ");
INSERT INTO mcq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ꞌEꞌeme Poruho hine vuꞌa ꞌwaramapene vaꞌeme ea pina huni iha Utikasiho ichutoi ꞌwitu ꞌahi hina vuꞌa henanaꞌomo nihoꞌo nii nama parajume ijino nisunama namu vaꞌume ꞌona apena arihe kamino mweꞌi ꞌahi ninamana. ꞌEjume pu hu ꞌunama apene ꞌurijiꞌi kavajaho nikwamamaa kavara. ");
INSERT INTO mcq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ꞌEjume Porura ariha vaꞌe raurahe namiꞌikaꞌi apene tahurine ꞌurijiꞌi ijá ꞌiama Hu maiꞌo hinukúne ja pajume ꞌee pavwihaha ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ꞌEnarena Poru kahi icha toi ajima vaꞌe puretia tuchama ine vuꞌa ꞌwaviꞌi hiꞌeme vea aharajume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ꞌEꞌeme pu paruisea kajaho maiꞌo hijumakame pu niꞌimaꞌuraꞌe oja sonahiana. ");
INSERT INTO mcq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Poruho mumori vuhunaꞌe vwihana jihunaꞌe nú sisima ꞌahi urasahe ajima vaꞌa kami Esosi ꞌajaꞌeje hu ijino ajivakame vahunaꞌe amairiaramana. ");
INSERT INTO mcq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Esosi roe piunúvume nú hu aheme sisima ꞌahi ajime pu puꞌúmo Mitarini roara. ");
INSERT INTO mcq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ꞌEnaꞌomo ijihuni súꞌuhijino nú vaꞌe Kaiasi karaꞌi naꞌeme ropunaꞌi usevaraꞌomo ijihuni súꞌuhijino nú Semasi usevaraꞌomo ijihuni súꞌuhijino kúꞌo vaꞌe Mairitasi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Porura Esiai hihuna ura parejume hu Epasasi asima roana. Ijihuni maijaho hu marako Jerusaremi ꞌeꞌuꞌeje Penitikositi vea rehunaꞌe ura renana. ");
INSERT INTO mcq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ꞌEnakaivo nú Mairitasi hiꞌeme Poruho ꞌona ranavume vaꞌe Epasasi sosi huni eruta puni ꞌona vene roꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ꞌEjume pu roume hu pu ijá ꞌiama Vea kaꞌene na Esia roujino ja na kivara. Na icháꞌina hine na icháꞌina ꞌurahone ꞌee icháꞌina vejujaho ja nikivara. ");
INSERT INTO mcq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ja niheju. Juaka mapokijipo na siseꞌi ꞌahiujaho na pavwihajura kaivo na Masuani ajuarana nituajiꞌi Natohwi jihuni kaukara vejura. ");
INSERT INTO mcq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ja niheju. Na nihoꞌo vuꞌa kajaho paranaꞌoꞌujuta kaivo maiji najaha apena vaꞌu. Na uneunecha mapoka kaꞌene ja niꞌajihunijaho ꞌwaramareꞌe na samaumai ꞌee sea seakino najaha apena ojuta. ");
INSERT INTO mcq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naꞌia mapoka vuꞌaka rona ꞌwaravujaho nikwinuꞌinake Jua ꞌee Kuriki puni sisea aremamaa areꞌi kaivo taꞌarohe Godoni roe ꞌee núni Natohwa Jesu Keriso nimaa roha ꞌiavura. ");
INSERT INTO mcq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ꞌEnaꞌomo heha! Na iviamaa nuni oja ahisinaꞌe reꞌejuꞌe Godoni ꞌAveni na apeniuꞌe Jerusaremi vaꞌu. ꞌEnakaivo ijino iraki renihunijaho na pahena pakavu. ");
INSERT INTO mcq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ꞌEnakaivo ara ara ikino na vaꞌujaho Godoni ꞌAveni ꞌwarimareꞌe ijá ꞌwimuna A tipurai hihuna ꞌee ahisina apehuna ajaha navu ꞌwimuna. ");
INSERT INTO mcq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ꞌEnakaivo na nuni hiijaho natohwa pakavura kaivo Godira maiji vwihanúani vuꞌa mamaa kaꞌene ea najaꞌurono Natohwa Jesura mihaji na ve parahuniji kavu. ");
INSERT INTO mcq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Heha! Na niheju. Ea kaꞌene na huꞌúmo ꞌurahe oꞌejuꞌe na Godoni ariji najahujaho ja nuni varira kúꞌo pakihuna. ");
INSERT INTO mcq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ꞌEnakaivo ea mapoka kehi puni ꞌaijaho nuni ija ꞌaha panamu. ");
INSERT INTO mcq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Na nihoꞌo Godoni ura ijí ꞌwaraꞌirono vejujaho na pajuvuta kaivo na ꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ꞌEnakúne hami ojono ꞌajoarame ꞌee ea kaꞌene jara ꞌajohaꞌavarono Godoni ꞌAveni ja ꞌajohaiꞌinaꞌe irechamie ꞌee Godoni sosia kaꞌene Hura Huni ꞌaijino ꞌimenajaho ꞌajohaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na niheju. Na vaꞌeje nuni túnaꞌi ꞌuaneapo joni vaja iki roareje ja rurahareje nihoꞌo pina paranahuna. ");
INSERT INTO mcq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ꞌEje joni ehija ꞌahoꞌakipo ꞌurine ira ani ani ꞌwarame tisaiporua aherame puni túnaꞌi vahuna. ");
INSERT INTO mcq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ꞌEnajihunaꞌe ꞌaiha vejiꞌi vwihaꞌavara. Juara noꞌopiso vajijino naꞌi veiriꞌa nituijiꞌi ihajinaname ea kwinu kwino nimaiji najahe ꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Godoni ija tahi irechamie ꞌee Huni ira kaꞌene mai ijí vaji irechamiuraꞌomo ijara areri niꞌajiꞌeje ja emarene ꞌee Godoni ehipuni vaji ja joni aachia ꞌekahuna. ");
INSERT INTO mcq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ꞌEnajihunaꞌe na nihoꞌo siriva ꞌee korutia ꞌee ateha ea ꞌahopuna paitunivura. ");
INSERT INTO mcq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ja niheju. Na nuni ija ikino uneunecha onuno vene ꞌee ea kaꞌene na huꞌúmo ojujija niꞌajihura. ");
INSERT INTO mcq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nara uneunecha mapoka kaꞌene vejujaho jara ijaꞌinaꞌe venareje ea kaꞌene pivusahuji niꞌajiꞌavarono najahuta. ꞌEne Natohwa Jesura Huni iri ꞌwaramaji vwihaꞌavara. ꞌEkujaho mamaa kaivo vajihujaho mavarasaꞌina vejura ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ꞌEnarena ꞌwaravume paꞌarejumakaviꞌi hu nitupari same pu puꞌúmo siporua ꞌojara. ");
INSERT INTO mcq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ꞌEnareja pu Poruho aharu ꞌoname niramaruviꞌi apene ura mina vetiara. ");
INSERT INTO mcq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ꞌEjume niramarume úchia ꞌejajihuni maijaho ira kaꞌene hura ꞌwaramarena ja nuni urania kúꞌo pakaꞌeja ꞌiamajara temukama paraniana. ꞌEꞌejume pu hu ahema vaꞌe sisima ꞌahi ranavara. ");
INSERT INTO mcq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ꞌEjume nú pu ꞌajoramareja irechamie vaꞌara. Nú vaꞌe sisima ꞌahi ajime arira vaꞌe Kasi usevara. ꞌEnaꞌomo ijihuni súꞌuhijino ꞌurina vaꞌe Rotesi usemareja vaꞌe Patara vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ꞌEnareja nú ijino sisima kaꞌene Ponisia vahunijaho piunamareja ijihuni toi ajima vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ꞌEnareja nú Siria vaꞌiro vaiꞌi Saiparasi ꞌanaꞌinijaꞌi kaviꞌi vaꞌe Taia Siria vaja kajinaꞌomo vaꞌara. Sisima kukua ꞌahoꞌa irechaꞌirono vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ꞌEnareja ijino tisaiporuepo ijí hiꞌava ronareja sarama kimareja hura kwino ijí pu puꞌúmo hijara. ꞌEjumakame Godoni ꞌAvenijara ꞌwaravume pu Poruho Jerusaremi pavaꞌamarono ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ꞌEꞌeme veijaho paareꞌi vejume pu ꞌurine vaꞌe pu puꞌúmo napahwaha ꞌee sesahwaha ijihi puꞌúmo ara kajaho areꞌi kaivo vaꞌe soha rori nitupari same pu puꞌúmo hine siporua ꞌojara. ꞌEnareja ea kwinu kwinu ija ꞌekaꞌe ꞌajoravume vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ꞌEnareja nú pu puꞌúmo ꞌajosarame nú vaꞌe sisima ꞌahi ajivume pu kúꞌo ꞌunama ari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ꞌEnareja ijino Taia rene vaꞌe kehi hijajaho Tarimeisi useviꞌi kivajaho ea kaꞌene nimaa rojiꞌinijija ꞌajorame naꞌia kwino pu puꞌúmo ijí nejara. ");
INSERT INTO mcq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ijihuni súꞌuhijino nú ꞌurina roe Sesaria usevara. ꞌEnareja Piripu kaꞌene Ivenijarisi jihuni sei vaꞌara. Hu ea iropu noꞌo pijihara vajijino ea pina kaꞌene pijahajina. ");
INSERT INTO mcq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ea ikehuni ꞌapahija noꞌona noꞌona parua pavejiꞌina kaivo pu poropetia. ");
INSERT INTO mcq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nú ijino naꞌia mapokaꞌe hiꞌeme ea pina huni iha Akapasina ꞌwavujaho Jutia rena roana. Hu ꞌuꞌo poropetia. ");
INSERT INTO mcq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ꞌEnaꞌomo hu núni roana. ꞌEnarena hu Poru oni charia kaꞌene hu ꞌahi iramajaho rasame huni ija mumorajiꞌi vevahaviꞌi ijá ꞌiama Godoni ꞌAvena na ijá ꞌwima Ike charia kehuni omijaho Juapo kahino Jerusaremi apene ikaꞌina vevahame apene Jenitarua mihuna ꞌwimu ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ꞌEjume núa ꞌee ea mapoka kaꞌene ijino hijajija Poruho Jerusaremi pavaꞌamarono rarejara. ");
INSERT INTO mcq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ꞌEjume Porura eha vene ijá ꞌiama Ja raka vene niramaruvuꞌukame nuni oja turaꞌi ꞌahio? Na Natohwa Jesuni ihijihunaꞌe Jerusaremi vaꞌe tipura vahune ꞌee kwahunijaho pavwihaju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ꞌEjumakame núra ijí rarehuna areri parenana. ꞌEjume nú ijá ꞌwava Makaꞌeje raka kaꞌene Natohwijara ura renujaꞌina venama ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nú ijihuni túnaꞌi ꞌurine núni uneunecha ꞌeka Jerusaremi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ꞌEjumakame tisaiporu ꞌahoꞌa Sesaria ora nú puꞌúmo vuꞌajivaraꞌomo pu nú aherume Nesani kaꞌene Saiparasi orijihuni sei vaꞌara. Hu nihoꞌo nitama tisaiporua rene hinapene roajihuni sei hijara. ");
INSERT INTO mcq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nú vaꞌe Jerusaremi usevume vwehu núna nihoꞌo teamanaꞌeme nú ꞌajorume aheruvara. ");
INSERT INTO mcq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ꞌEnaꞌomo ijihuni súꞌuhijino Poruho nú puꞌúmo vaꞌe Jemisi kaꞌi vaiꞌi kivajaho sosi puni eruta ijí hijara. ");
INSERT INTO mcq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ꞌEnarena hu pu ꞌajoramarena Hura kaukara kaꞌene venana vaji Godi raka kaꞌene Jenitaru ijihipuni vaji venajaho hine kwinu kwino tahe ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ꞌEjume pu ijí henareja Godi taꞌarohara. ꞌEne pu ijá ꞌwava Vwea núne Jua mapoka mapoka nimaa rojura. ꞌEnakaivo pu Mosisi oni tamana vehuniji nihoꞌo harura veju. ");
INSERT INTO mcq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Pu ijá ꞌwava Ara Jenitaru puni ari hina ꞌonujiꞌi najahukame pu Mosisi oni tamana pataarohu. ꞌEne pu puni harihija sisa paꞌuhuꞌavarono ꞌwaravu. ꞌEne Jua puni tamana paveꞌavarono ꞌwaramuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ara roajaho pu nimaa heꞌeja. ꞌEnaꞌomo nú ichá veꞌeja? ");
INSERT INTO mcq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nú raka a ꞌwarava heꞌamajaho ijá veꞌamana. Ike ea noꞌona noꞌo ikija ꞌaura arevara. ");
INSERT INTO mcq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ara pu puꞌúmo vaꞌe pura raka kaꞌene veꞌavajaho a ꞌuꞌo ijá veꞌamana. Ara oni húmata ꞌusimareje ea noꞌona noꞌo ikihi ꞌusimahakiviꞌi a puni eha veꞌamana. ꞌEjakame pu ea mapoka hena kamareje oni vuꞌa kaꞌene hejajaho iraꞌata reꞌamana. ꞌEnakaivo a ꞌuꞌo tamana kajaho ꞌajohe vejiꞌinaꞌe kaꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ꞌEnakaivo Jenitaru kaꞌene nimaa rojiꞌini jihipuni pasi vene ijá ꞌwaravara Pu ꞌiruma kaꞌene godi iraꞌatiji vajiꞌavajaho paine ꞌee ꞌaa paine ꞌee hanuha ꞌaa rukina paine ꞌee ꞌuasa paveꞌavara ꞌiavara ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ijihuni súꞌuhijino Poru ꞌurine ea kajija aherame tamana kajaho ijá vejara. ꞌEnareja pu vaꞌe Temiporu vaji arume ꞌaura areꞌiraꞌomo vea kaꞌene kúꞌo ꞌaura kaji ihunijaho ijaꞌina nahama ꞌwaravara. ꞌEnareja pu ea kwinu kwino puni swasa venahara. ");
INSERT INTO mcq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Hura kwinu paꞌareꞌi veꞌeme Jua kaꞌene Esia orijipo kavume hu Temiporu vaji hijume kama pu aneja vene ea mapoka puni oja inaume pu hu iji ꞌunavara. ");
INSERT INTO mcq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ꞌEnareja pu ira ajiraꞌe ijá ꞌumeja Isureri orakije roe niꞌajúha. Eakara kwaaka mapokijino eaka mapokijija ehu núna ꞌee núni tamana ꞌee ruhakaho ninama ꞌwaramujiru pana kaivo hu Kuriki aherame núni Temiporua vaji rouꞌe akuavuri ruhakaho nihoꞌo siseranu. ");
INSERT INTO mcq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Pu ijá ꞌwavajihuni maijaho pu kiꞌeme Turopimasi kaꞌene Epasasi orijiꞌo Poruꞌo ijino ari ꞌurahojara. ꞌEnareja pu vwihajajaho Porura hu aheme ijino puni Temiporu vaja kaji aruma vaꞌana roꞌikaꞌi avajara. ");
INSERT INTO mcq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ꞌEꞌikaivo pu ea mapoka ajinama parajume niꞌaha kwino ninukujaha roe ahumareja pu aruma vaꞌe Temiporu vaji Poruho ꞌuname tairie apena roe maꞌahi roꞌeme vwicha kajaho marako kuvara. ");
INSERT INTO mcq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pu hu ꞌanaꞌirono ꞌunama saꞌeme vuꞌarena vaꞌe Romu puni sorutia niꞌini jihuni vaꞌana. ꞌEjume Jerusaremi nihoꞌo miꞌija punaꞌi tamui namana. ");
INSERT INTO mcq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hu niꞌaha kwino sorutia ꞌee puni mamaꞌina ꞌahoꞌa aherame ninukujahe puni vaꞌume pu sorutia ꞌee puni natohwiji kimareje Poru ꞌanaajaho arevara. ");
INSERT INTO mcq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ꞌEjumakame ea niꞌinijara vuꞌe iji ꞌunaꞌi kaivo ꞌwaravume pu seni noꞌoheꞌi ꞌeke kamome aneja vene hu irane ꞌee hu irakaꞌe venaji apovara. ");
INSERT INTO mcq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pu ea ꞌahoꞌa ꞌurine ani ꞌwaravume pu ea ꞌahoꞌa ani ani ꞌwaravara. ꞌEjumakame ijí ea natohwa kajaho ꞌunama kaꞌene icháꞌina venareja ijí vejajaho puruva renana. ꞌEjumakame hu huni ehija ꞌwaravume pu Poruho aheme kahino huni sea kaꞌene amiapo hijujino vaꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Hu Poruho pu puꞌúmo ꞌurina vaꞌe kami vwicha jiami vaꞌume amia kajipo apene pikima ichutoi ꞌunama vaꞌara. Ijihuni maijaho eaka mapokijipo ꞌanaꞌiro vejumakame avajara. ");
INSERT INTO mcq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ꞌEjumakame ea mapoka puni túnaꞌi vaiꞌi ꞌanae kwamama ꞌumenapene vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ꞌEnareꞌe ijí sorutia kajipo Poruho apene puni sei vaji vaꞌi vejumakiviꞌi hu iji amia epuni ea natohwa kajaho ijá ꞌwama ꞌÚ na unenuꞌu pina a ꞌwaraꞌejo? ꞌwamana. ꞌEjume hu ijá ꞌwama ꞌÚ a Kuriki puni ira henune? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Iviꞌa a Ijipiti ora kaꞌene niꞌahuka ea mapoka mapoka (4,000) kaꞌene ea ꞌaniuꞌe kwamasahiꞌina oja inaꞌe aherame nechiꞌi vaꞌajaho pane? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ꞌEjume Poru ijá ꞌwama Na Jua Tarisasi ora Sirisia vajina kaivo ara kajaho natohu varesimaꞌura. ꞌEnajihunaꞌe na ura ea mapoka vuꞌa ꞌwaraꞌi ꞌahiu. ꞌEnajihunaꞌe na ura jarirame ꞌwaravukúne ruha aremie na ea ikija vuꞌa ꞌwaravuma. ");
INSERT INTO mcq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ꞌEjume hu ruha aremahe nijina ꞌwavume Poruho ijí siasa ꞌaha kajino namiꞌi kaivo huni iji hararajihana. ꞌEjume ea mapoka irunoꞌa areꞌeme hu Hipuru puni iri ꞌwaramarena ijá ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Vwehu nuna ꞌee emahu nuna. Nuni vuꞌake ataa apúsama heha. Nara raka kaꞌene vejuji iviamaa joni unaꞌi namine ꞌwaraꞌi veju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ꞌEjume hu huni vuꞌa Jua puni ira ꞌwaravuma henareja pu nihoꞌo areme varira reꞌasahe hina hejara. ");
INSERT INTO mcq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ꞌEjume Poru ijá ꞌiama Na Jua nuni ohijara Tarisasi Sirisia vaji naheniana kaivo ike arakino renarejo Kamerieri oni hari emahu nupuni tamana hena ka parajuta. ꞌEnaꞌomo ja iviasi Godoni jihunaꞌe sena veju kajaꞌinaꞌe na ꞌuꞌo ijaꞌina vejuta. ");
INSERT INTO mcq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ꞌEnareꞌe na ea kaꞌene ꞌUnama ikehunake vejajaho siseꞌi ꞌahiura. ꞌEne na ura pu ꞌanie kwamasaꞌavarono vejura. ꞌEne na parui napari ꞌeke tipurai irechamiura. ");
INSERT INTO mcq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ꞌEne ea kaꞌene pirisiti natohwa ꞌee emakina kaꞌene kanisoru ijija vuꞌaka na iviamaa ja ꞌwaravukaho pu nihena kavara. Ijihuni maijaho pura pasi kaꞌene veja kajara harura mihume na vaꞌe Jua kaꞌene Tamasikasi hiju jihipuni vaꞌe ea puna kaꞌene ijí hijujihijaꞌe kamorame aherama Jerusaremi siseꞌi ꞌahiꞌi vaꞌuta. ");
INSERT INTO mcq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ꞌEnarejo na vaꞌe Tamasikasi va ꞌeꞌuꞌirono vaꞌeme vea rira muꞌoi namiꞌeme niꞌaha kwino kahino akúpi ꞌahi rene hanana tauhuhiana. ");
INSERT INTO mcq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ꞌEne na niꞌaha kwino ꞌona apena arihe mweꞌi ninaviꞌi hejume ira kahi akúpa ꞌahi rena roe ijá ꞌwima Soru Soru a raka vena Na siseꞌi ꞌahiu? ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ꞌEjume na eha vene Hua apome ijá ꞌwavo Natohwe A rarane? ꞌwavume Na Jesu kaꞌene Nasareti orijinaꞌomo a Na siseꞌi ꞌahiu ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ꞌEjumakame ea kaꞌene nú puꞌúmo vuꞌa kajija ijí hanana kajaho kavara kaivo ira kaꞌene ea irara na ꞌwarimajaho pahejara. ");
INSERT INTO mcq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ꞌEjume na apoma ijá ꞌwavo Natohwe iviamaa na ichá veꞌejo? ꞌwavuta. ꞌEjume Hu ijá ꞌwima ꞌUrine Tamasikasi vaꞌe ea kaꞌene ijí hinujara ara raka kaꞌene veꞌamarono Nara iji pijahujaho hu a ꞌwarava heꞌamana ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ꞌEꞌeme ijí hanana kajara vejume na paniriarejo pivujume ea kaꞌene nú puꞌúmo roa kajipo na iji ꞌunirimapene Tamasikasi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ꞌEjume ea pina huni iha Ananaiasiho puni tamana hami hami vejukame Jua mahoꞌo kaꞌene ijino hijujija hua ea mamaa ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ꞌEnaꞌomo ijara roe nuni rori namiꞌi kaivo ijá ꞌwima Vwea nuna Soru oni nia niria ꞌwivume nuni nia kúꞌo maranana. ꞌEjume na hu kavuta. ");
INSERT INTO mcq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ꞌEjume hu ijá ꞌwima Emahu nupuni Godijara a Huni ura ijí hena kame ꞌee ea kaꞌene arimaa ijí hena kame ꞌee Huni irititi vuꞌiji heꞌamarono iji pijahana ꞌwimana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ꞌEnaꞌomo a raka kaꞌene kama ꞌee henajaho Hu rone ea mahoꞌo najahuna. ");
INSERT INTO mcq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ꞌEnakaivo a irakijihunaꞌe tetama hino? ꞌUrije Huni ihijino ꞌurahiꞌi toi apúsamaꞌe oni sisea somaꞌe paꞌarenama ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ꞌEjume na kúꞌo ꞌunama Jerusaremi roarejo ijino Temiporu vaji hine siporua ꞌojiꞌi navaha rojuta. ");
INSERT INTO mcq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ijí navaha kajino na kavume Hu ijá ꞌwima Mamako Jerusaremi areꞌi kaivo ꞌurine vaꞌa. Ijihuni maijaho a Nuni vuꞌa iki najaꞌamajaho pu paheꞌejakúne ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ꞌEjume na ijá ꞌwavuta Natohwe pu na nihejura. Nitama na vaꞌe Sinakoku pina aruma ꞌeꞌune ꞌee pina aruma ꞌeꞌujiꞌi ea kaꞌene Aaꞌe nimaa ronaujija ꞌeke hijihae ꞌee tipurai irechamiuta ꞌwavuta. ");
INSERT INTO mcq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ꞌEjume ea kaꞌene oni vuꞌa ꞌwaraviꞌina hena kaviꞌina huni iha Sitivini oni ꞌaa kaꞌene arihajaho na ijí nimaa vejiꞌi ea kaꞌene huaꞌe ꞌanaajihipuni ateha ꞌajoha namijuta. ");
INSERT INTO mcq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Hu ijá ꞌwima Nara a kwai natohwi Jenitaru puni kwai ranamaukúne vaꞌa ꞌwimana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pu hine huni vuꞌa kajaho henapena vaꞌu vaꞌu hu ijí ꞌwaravuma hejiꞌi pu ira ajira ijá ꞌumeja ꞌAnaa kwamama! Ea ijaꞌina ikaho mweꞌa pahihunakúne pamakaꞌeje hinama ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Pu ijano ꞌumena apene ojiꞌi puni atehi ꞌeke atoꞌarume ꞌee útiti ꞌene icha toi atoꞌaruvara. ");
INSERT INTO mcq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Sorutia puni natohwijara apene puni kwai roe hijahiꞌi apomakame irakijihunaꞌe pu hu mwasiritia jihuni maijaho hu ꞌwaramaro avajara. ");
INSERT INTO mcq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ꞌEjume pu hu kamoꞌeme Porura sorutiaꞌe ꞌajohaꞌiniji ijá ꞌwama ꞌÚ ja Romu ora areri ꞌotua pavene heꞌi kaivo hijihaure? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ꞌEjume ea kaꞌene ꞌajohiꞌinijara ijí vuꞌa kajaho hene vaꞌe ea kaꞌene Natohwijaho ijá ꞌwama Eakaho Romu oraꞌomo a irakaꞌe veꞌi veno? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ꞌEjume ea Natohwa kajara huni roe ijá ꞌwama ꞌÚ a Romu ora reꞌamajaho ꞌwarima ꞌwavume hu Iꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ꞌEjume ea Natohwa kajara ijá ꞌwama Na roe Romu opuni ea reꞌi vejujaho monia eha niꞌimaꞌura vejuta ꞌwamana. ꞌEjume Porura ijá ꞌwama Na iki nahenia jihunaꞌe na Romu ora rejuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ꞌEꞌeme ea kaꞌene ijí hu apome ꞌee hua hijaꞌi ꞌahiume roajivajija niꞌaha kwinu jumareja arevara. ꞌEjume ea Natohwa kajara vwihanajaho hu Poruho Romu ora ꞌee majikari kamomana ronarena hu tea jumana. ");
INSERT INTO mcq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ijí ea Natohwa kajaho hu irakijihunaꞌe pu Jua Poru namahu ronarena ijihuni maiji hami heꞌi ꞌahaana. ꞌEjume ijihuni súꞌuhijino senia kaꞌene hu kamovajaho rasamaꞌi kaivo ꞌona ranavume ea kaꞌene pirisiti mamaꞌina ꞌee kanisorua mahoꞌo roe hiꞌeme hu Poru ahema apene roe puni unaꞌi roana. ");
INSERT INTO mcq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ꞌEjumakame Poruho nia ajira kanisoru kajija kiviꞌi ijá ꞌiama Vwehu nunakije na Godoni unaꞌi hami hinuvaꞌo roe iviasi ꞌeꞌuju ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananaiasi kaꞌene pirisitia niꞌinijara ꞌwaravume ea kaꞌene huni rori namijajipo hu inu tahijahara. ");
INSERT INTO mcq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ꞌEjume Porura huaꞌe ijá ꞌwama Godira a ꞌanahuna. Kare ea kaꞌene aroaroti namijiꞌina karera. A oni tamana ꞌahakino namine na ꞌotua vetiꞌi kaivo vu a oni varapa orono tuama rena ꞌiavuꞌe na ꞌaniare? ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ꞌEjume ea kaꞌene huni rori namija kajipo ijá ꞌwava A Godoni pirisitia natohwijaho ira sisea ijaꞌina ꞌwaramune? ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ꞌEjume Porura ijá ꞌiama Vwehu nune hu pirisiti natohwijaho na pahejuta. ꞌEnakaivo Godira Huni ira vaji ꞌwarumajaho nú ira sisea ea ꞌajohaꞌina paꞌwaraꞌavarono ꞌwarumana ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Hu kimajaho ea ꞌahoꞌa Sajusi ꞌee ea ꞌahoꞌa Parasia kimarena hu kanisorua kajija ijá ꞌumena Vwehu nune na Parasia ꞌee Parasi puni hariha kaivo ea kaꞌene kwamasahujipo kúꞌo ꞌurihuniji na nimaa rojujihunaꞌe na ꞌotua vaja namiju. ");
INSERT INTO mcq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Hu ijá ꞌwaravumakame Parasia ꞌee Sajusi puni vaji nakaramareje ea mahoꞌo kajaho ahaama namana. ");
INSERT INTO mcq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ꞌEjume Sajusiapo ꞌwaravajaho ea kwamasahajija kúꞌo paꞌurihune? ꞌEe ꞌona ojiꞌina paꞌana ꞌee ꞌavena paꞌana kaivo Parasia ike noꞌopisukija nimaa rojura. ");
INSERT INTO mcq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ꞌEnajihunaꞌe pu iranoa apeꞌeme Sikuraipi ꞌahoꞌa Parasijihi puni ehijaꞌomo pu ijá naminareja ira ajira ijá ꞌiava Nú ea ikehuni vaja unenuꞌu pina sisea pakavuraꞌomo vi ꞌavenina ho ꞌona ojiꞌini hu ꞌwaramana raka? ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ꞌEjumakame pu nihoꞌo niꞌimaꞌura nakaravume Poru ija ꞌunave haha puachama usehunaꞌe kimarena ea natohwijaho tea juvume huni sorutia irechamiume pu haruri vene apene puni tinii vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ijihuni naꞌia kajino Natohwijara roe huni rori namiꞌi kaivo ijá ꞌwama Pajuꞌamana kaivo a icháꞌinaꞌe rone a iki Jerusaremi ꞌwarama jaꞌinaꞌe Romu ꞌuꞌo ꞌwaraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ꞌEꞌeme vea nituvume pu Jua mapoka nesi ahuma hine ꞌwame ꞌiruma toa paiꞌikaꞌi hinuvaꞌo Poru ꞌanaareje ijiꞌa ihuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ea kaꞌene Poru ꞌanae kwahuna kosarama ojajaho ea mapoka (40) asima hunaꞌina. ");
INSERT INTO mcq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ꞌEjume pu vaꞌe pirisiti mamaꞌinijija ꞌee ea mamaꞌini jihipuni vaꞌe ijá ꞌiava Nú vuꞌa nimaae vejaraꞌomo nú uneunecha ꞌahoꞌa paina apene vaꞌu vaꞌu vaꞌe vea kaꞌene Poru ꞌanaaꞌavajino ihuna. ");
INSERT INTO mcq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ꞌEnakúne iviamaja ja kanisoru puꞌúmo ꞌona ranave vaꞌe ea natohwijara Poruho aheme joni roꞌamana. Ja ijá ꞌwaraꞌavara Nú ura huni vuꞌijihuni maiji heꞌi ꞌahúu ꞌwaꞌavara. ꞌEnareje ja iki ahema roꞌiro roꞌeje nú vuꞌe ꞌunamutoi ꞌajohe ꞌanaa kwaꞌena ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ꞌEjume Poru oni maꞌini jihuni harihijara ijí pura júhi hine ꞌanahuni vuꞌiji henarena hu vaꞌe sorutia puni tinii vaꞌe Poru ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ꞌEjume Porura ea kaꞌene ꞌajohiꞌina pina ꞌumene ijá ꞌwama Ike kasimaa kaho unenuꞌu pina ꞌwarahuna ura renukúne aheme ea natohwa karohuni vaꞌa ꞌwaramama ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ꞌEjume ea natohwa kajara hu aheme apena vaꞌe ea natohwa pinijihuni vaꞌana. ꞌEnarena hu ijá ꞌwamana Poru kaꞌene tipura eijara ike kasimaa ike nara aheme oni roꞌurono ꞌwarivume na ahema routa. ");
INSERT INTO mcq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ꞌEjume ea natohwa kajara ea kajaho iji ꞌunama apena vaꞌe kara rori pu noꞌo pu pusumano namiꞌi kaivo hu apoma ijá ꞌwama A raka na ꞌwarihuna ura renao? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ꞌEjume hu ijá ꞌwama Jua ꞌwama nimaa venareja ꞌwarave ja Poru niari aheme kami kanisoru puni vaꞌe pu iraꞌatijino huni vuꞌiji heꞌirono ꞌwaviꞌi ꞌwaraꞌeja. ");
INSERT INTO mcq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ꞌEnakúne a puni ira paheꞌamana. Puni ea mapoka (40) pu maraku hu ꞌanaa kwavakaviꞌi pu ijiꞌa ꞌiruma ine toa iꞌiroreja pu vua ꞌwama nimaa vene iviamaa ꞌajoha hijiꞌi ara ꞌwarave heꞌirono ꞌajahu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ꞌEjume ijí ea natohwa kajara kasimaa kajaho rana ꞌahaume ijá ꞌwama Ike vuꞌa kaꞌene ara na ꞌwarimukaho a pavaꞌe ea ꞌahoꞌa ꞌwaraꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ꞌEjume ijí ea natohwa kajara ea ꞌajohiꞌina noꞌo ꞌumenaume roume hu pu ijá ꞌiama Ja noꞌo sorutia ea mapoka (200) ꞌeke ꞌee hosi rukina 70 aherame ꞌee ea juha rukina mapoka (200) aheraꞌavara. Iviasi naꞌi naina koroki Sesaria vahuna amairiaraꞌavara. ");
INSERT INTO mcq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ꞌEne Porura hosi kaꞌene ijihuni toi ajihunijaho amairiꞌavara. ꞌEnareje ja hu hami hami ahema apene vaꞌe ea Pirikisi kaꞌene kavana ijihuni nini vaꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ꞌEꞌikaivo hu pasia ikaꞌina venahana. ");
INSERT INTO mcq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Pirikisi kaꞌene kavana natohwijiꞌo esi. Na Karotiasi Risiasira ike pasikaho veju. ");
INSERT INTO mcq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Juapo ea ikaho apene ꞌanae kwaꞌamarono veꞌeme na vaꞌe nuni sorutia puꞌúmo hu niꞌajahe ꞌee hejujaho hu Romu oraꞌe hejuta. ");
INSERT INTO mcq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Na ura pu irakaꞌe vene hu namahu jihuni maiji heꞌirono ahema apene puni kanisoru ijihuni vaꞌuta. ");
INSERT INTO mcq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ꞌEjume na hejujaho pu puni tamani ihunaꞌe hu namahara kaivo huaꞌe ꞌanae kwame ꞌee tipurai ranahuna areri pana. ");
INSERT INTO mcq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Iviamai puni vuꞌa kajaho rene roume na hejuta. Pu nesi vuꞌa ꞌwamareja ea kaji ꞌanae kwahuna ꞌwavara. ꞌEjukame ijihunaꞌe na hu ranavuꞌe oni vuꞌu. Na ea mapoka kaꞌene Poru namahu kajihija pu vuꞌe oni nini ꞌotua vene raka kaꞌene Poru venaji a ꞌwaraꞌavarono na ꞌwaravu. ꞌEnakúne pu oni unaꞌi vuꞌa kajaho amairiakame a heꞌamana. Pirikisi ese ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ꞌEjume ijí naꞌia kajino sorutia kajipo Poruho apene Anitipatirisi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ꞌEꞌeme vea nituvume sorutia ꞌahoꞌa ꞌunama puni ari vaꞌara kaivo ea kaꞌene hosi ꞌahi vaꞌajipo Poruho aheme Sesaria vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ꞌEnareja pu vaꞌe Sesaria usemareja pu Poruho aheme kavana ijihuni unaꞌi ranaꞌi kaivo pasi mahara. ");
INSERT INTO mcq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ꞌEjumakame kavana kajara pasia kajaho taharena hu apoma ijá ꞌwama A ara ichiꞌure ꞌwavume hu ijá ꞌwama Na Sirisia ora ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ꞌEjume hu ijá ꞌwama Namahiꞌinijipo ro useꞌavajiꞌa na oni vuꞌa heꞌeju ꞌwamana. ꞌEjume hu ꞌwaravume pu Heroti oni sei raname ꞌajoha hijara. ");
INSERT INTO mcq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ꞌEjume hu hiꞌeme naꞌia iropu paꞌareꞌeme pirisitia natohwa kaꞌene Ananaiasina ꞌwavujaho ꞌee puni emakina ꞌee ea kaꞌene ꞌotua arimai ꞌwaraviꞌina ꞌajohiꞌina huni iha Taturiasi ꞌwavujihi puꞌúmo roe kavana ijihuni unaꞌi Poru ꞌotua vetiꞌi roara. ");
INSERT INTO mcq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ꞌEjuꞌe ea natohwijara Poruho ꞌumejume roume Taturiasi hine ꞌotua vetiꞌi ꞌahaume aneja vene hu namahe ijá ꞌwama Kavana! Ara nú niꞌajúhuꞌe kame nú mamaa hina rou. Ara oni vwiha kaꞌene mamaijino nitama núni ehija niꞌajihuꞌe ararakino vejuꞌe siserasahujaho marasahara. ");
INSERT INTO mcq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ꞌEjuꞌukame nú nihoꞌo ꞌunama jajaa ꞌee kwaa mapokakino ijaho ꞌwamareꞌe teamanuma parajura. Ijihunaꞌe nú a Pirikisi kaꞌene ea mamaakere teimani ꞌwavu. ");
INSERT INTO mcq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ꞌEnakaivo na hine veje a túkirahuna senumu. ꞌEnaꞌomo a icháꞌina vehuniji ꞌwaruꞌamarono jariravukúne a núni vuꞌake hena. ");
INSERT INTO mcq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nú kavujaho eakaho nihoꞌo ani ani vene ꞌee ruaruhuna. ꞌEjuꞌe Poruho vejuꞌe Juaka mapoka kaꞌene kwaaka mapokakino hina apenojujijahija ajinama parajura. Hu ea sisea kaꞌene Nasareti ꞌwavujihipuni húmatijina. ");
INSERT INTO mcq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hu Temiporu vejume chiha renana. ꞌEjuꞌukame nú hu ꞌuname nuni tamanijara ꞌwarumu jaꞌinaꞌe ꞌotua vetihunaꞌe ura veju. ");
INSERT INTO mcq_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ꞌEjuꞌukaviꞌi Risiasiho Romu opuni sorutia puni natohwijara roe harura vene núni ija tahi apetujúha vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ꞌEjuꞌukame hu ea mapoka ꞌwaravuꞌe ea irahipo hu namahujaho oni unaꞌi roe ꞌotua vetihuna ꞌwamana. ꞌEnaꞌomo ara ea kajaho apovakame hura huni irijino ꞌwarave a hehuna. Núra raka kaꞌene hu namahareꞌe ꞌotua veti vejujaho hu ꞌwarave a hehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ꞌEjumakame Jua ꞌahoꞌa vuꞌa kaji henareja pu ꞌuꞌo ijaho nimaa ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ꞌEjume kavanaijara Porura ꞌwaraꞌamarono ꞌwaramana. ꞌEjume Porura ijá ꞌwama Na niheju. A juara mapoka ꞌotua vejiꞌinaꞌomo na teamaniꞌejuꞌe vuꞌa ikaho ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ꞌEnakaivo nara vuꞌa nimaa kaꞌene ꞌwaravuke hena. Naꞌia iropu ropu noꞌo paꞌareꞌeme na Jerusaremi Godi oja maꞌi vaꞌuta. ");
INSERT INTO mcq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ꞌEnakaivo Temiporu vajina ho Sinakoku vajina ho ara vaja kakino na ea ꞌahopuꞌúmo ꞌurae varapa vehuna pana. ");
INSERT INTO mcq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ꞌEnaꞌomo iviamaa pura vuꞌa kaꞌene na ꞌotua vetihuni jihuni maijaho pura a najahuna nihoꞌo areri parenau. ");
INSERT INTO mcq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ꞌEnakaivo na ura vuꞌa kwinu a ꞌwaraꞌi veju. ꞌUnama kaꞌene ea mapoka nimaa rojujihunijaho pu sisea nimarako a ꞌwarava kaji na a ꞌwaraꞌi veju. ꞌEnareja emahu nupo Godi kaꞌene nimaa rojuji na oja mahuta. ꞌEne vuꞌa kaꞌene tamana vaji navujija na nimaa rojura. ꞌEne vuꞌa kaꞌene poropetiepo vejajija ꞌuꞌo nimaa rojura. ");
INSERT INTO mcq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Na nimaa rojujaho ea kaꞌene kwamasahiꞌinaka ea ariramaa ꞌee ea siseijipo kúꞌo ꞌurihunaka pura nimaa rojajaꞌinaꞌe na ꞌuꞌo nimaa rojura. ");
INSERT INTO mcq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ꞌEnajihunaꞌe na naꞌia mapoka harura vejukame nuni vwiha vejuꞌe Godoni unaꞌa ꞌee emaapuni ꞌunaꞌi ariraꞌe navuꞌe na namihuna areri parenuna. ");
INSERT INTO mcq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ꞌEjume juara ꞌahoꞌa paꞌareꞌeme na swara ꞌeke nuni ara kwaa kúꞌo nuni ehijaꞌe vajiꞌirono routa. ");
INSERT INTO mcq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na Temiporu vaji maraniꞌama tamanaꞌe vejujaho ijihiꞌa ea mapoka pane ꞌee iranoꞌa pana kaivo Jua kaꞌene Esia rena roajipo kivara. ");
INSERT INTO mcq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ꞌEnaꞌomo ijipo iviamaa oni unaꞌi namine unenuꞌu ꞌahoꞌa na namihe ꞌee ꞌotua vetihuna reꞌamajaho ꞌotua vetia. ");
INSERT INTO mcq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ꞌEnakúne ea kaꞌene ike namijukehi aporave na kanisoru puni ꞌunaꞌi sisea rakaꞌe veje kivaraꞌe reꞌavajaho pupusu ꞌwarave hena. ");
INSERT INTO mcq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ꞌEne unenuꞌu pina kwinu puni unaꞌi namijiꞌi ꞌumejujaho ikena. Na ea kaꞌene kwamasahiꞌinijipo kúꞌo ꞌurihuniji nimaa rojujihunaꞌe ja na iviasi joni nini ꞌotua vetiu ꞌiavuta ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pirikisiho ꞌUnamijaho hami hena kaviꞌini jihunaꞌe tanuma ijá ꞌiama Risiasi kaꞌene sorutia puni natohwijara roe arihakame hura joni ꞌotujihuni ehijaho vwihane mihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ꞌEnakaivo hu ea kaꞌene ꞌajohiꞌiniji ꞌwaravume Poruho apene ꞌajohaiꞌi ranave ꞌurahoje Poru oni napuhija roe uneunecha hu niꞌajaꞌi veꞌavajaho patanuꞌuriꞌavara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pirikisi oni naparijaho Jua. Huni ihijaho Turusiranaꞌomo Porura roe Jesu Keriso nimaa rojuji ꞌwarave heꞌirono roanaꞌomo ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ꞌEjume Porura ꞌunama ariramaaru vehuna ꞌwarame ꞌee hia hami ꞌajohuna ꞌee Godira ꞌotua túnaꞌi niꞌimaꞌuraka vehunijaho ꞌwaravume Pirikisiho ijí henarena tea juvume raname ijá ꞌwama Va hinoꞌeje nara kúꞌo ꞌumena hejiꞌi roꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ꞌEne veaka nikwinuꞌina kajino Pirikisira vwihanajaho Porura huaꞌe monia vajaꞌeje ranava vaꞌamarorena hu naꞌia mapoka Poru ꞌumejuꞌe hu vaꞌe hu huꞌúmo vuꞌa ꞌwavura. ");
INSERT INTO mcq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ꞌEꞌeme juara noꞌo paꞌarejume Posiasi Pesitasira Pirikisi oni tinijaho apenana. ꞌEꞌeme Pirikisiho Jua teamanaꞌavarono hu Poru tipurai ranaꞌikaꞌi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pesitasiho huni kwai roe hiꞌeme vea noꞌopisu paꞌarejume hu Sesaria rene Jerusaremi vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ꞌEjume pirisiti mamaꞌinijija ꞌee Jua uraniꞌinijija Poru namahareja ꞌejaha hu ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ꞌEne pu ea Natohwa kajaho ꞌejahae ijá ꞌwava A nú niꞌajúhareje a vaꞌikaꞌi Poru ranava Jerusaremi roe nú ꞌotua veꞌavara ꞌwavara kaivo pu vwihajajaho hu roꞌamajaho pu ꞌunama toi ꞌanaa kwahuna vwihajara. ");
INSERT INTO mcq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ꞌEjume Pesitasi eha vene ijá ꞌiama Poruho Sesariaꞌi tipura ranavuꞌe hinunaꞌomo hu maiꞌo túnaꞌi vuhuna. ");
INSERT INTO mcq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ꞌEnakúne joni ea mamaꞌina irechamie nú puꞌúmo vaꞌe heje ea kajara sisea venana heꞌavajaho ja ijiꞌa hu apene nuni nini ꞌotua vetihunakúnina ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ꞌEꞌikaivo hu naꞌia ija ropune noꞌopisuna ho ironu ronu raki ijí pu puꞌúmo hinarena ijiꞌa kúꞌo Sesaria vaꞌana. ꞌEnarena hu nenanaꞌomo súꞌu ꞌurine vaꞌe ꞌotua vejuri sei hiꞌi kaivo Poruho ꞌumejume pu aheme roajivara. ");
INSERT INTO mcq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ꞌEjumakaviꞌi Jua kaꞌene Jerusaremi rena roajivajipo huni rori namiꞌikaꞌi apene iraꞌata kajino namahara. ꞌEnakaivo pura Poru namahajaho maiꞌo nimaa parenana. ");
INSERT INTO mcq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ꞌEjume Porura eha vene ijá ꞌiama Na nihoꞌo sisea pavejuta. Jua puni tamana ho Temiporu vajina ho ea natohwa kaꞌene Sisa ho na nihoꞌo siseꞌi paꞌahiuta ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ꞌEnakaivo Pesitasira Jua teamanaꞌavarono hu eha vene Poru ijá ꞌwama A ura Jerusaremi vaꞌe nuni unaꞌi ꞌotua vehuna ura renao? ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ꞌEnakaivo Poruho ijá ꞌwama Na Sisa oni unaꞌi ꞌotu vetihuna. Ijihuni maijaho na Jua puni unenuꞌu pina sisea pavejujaho a nihenu. ");
INSERT INTO mcq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Na unenuꞌu pina sisea vejuta reꞌipisa nijinaꞌomo na ꞌanie kwahuna parareꞌeju kaivo vuꞌa kaꞌene pura na ꞌotua vetihuna nimaa paꞌana reꞌamajaho ea pina na areri paapenie mihuna. ꞌEnaꞌomo na Sisa ꞌwarave hura nuni ꞌotuijaho hehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ꞌEjume Pesitasira hine kanisoru puꞌúmo ꞌwamuvaꞌo ijá ꞌwama A ura Sisara oni ꞌotua hehuna reꞌamajaho a Sisa oni vaꞌamana ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Vea ꞌahoꞌa paꞌareꞌeme Kini Akuripaꞌo Penisiꞌo Pesitasi ꞌajoꞌi ꞌahiume roajivara. ");
INSERT INTO mcq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ꞌEjumakame pu ijino naꞌia mapoka hiꞌeme Pesitasira Poru oni vuꞌijaho kiniji ijá ꞌwama Ea pina Pirikisira hinajiri tipurai ranavume hinana. ");
INSERT INTO mcq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ꞌEnaꞌomo na Jerusaremi vaꞌume ea kaꞌene pirisiti mamaꞌina ꞌee Jua puni ea mamaꞌinapo nara ea kaji ape mihakame ꞌotua vene namaꞌirono ꞌwarivara. ");
INSERT INTO mcq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ꞌEjume na ijá ꞌiavo Romu opuni tamana nú ea majikari pairechamiura kaivo ea kaꞌene varapa rukinijihi puni vuꞌa hene ꞌee ea kaꞌene pu namahu jihipuni vuꞌa henareꞌe ijí tipurai irechamiura. ");
INSERT INTO mcq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ꞌEjumakame ijihunaꞌe pu nianaa ro ikino ahuvara. ꞌEjume na patetavuta kaivo ijihuni súꞌuhijino na vaꞌe ꞌotua vejuri ruhijino hiꞌikaꞌi pu ꞌwaravume hu ahema roara. ");
INSERT INTO mcq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eaka hu ꞌotui ranavajipo ꞌurine namiꞌikaꞌi namahara kaivo sisea kaꞌene nara vwihaju jaꞌina pu panamahara. ");
INSERT INTO mcq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ꞌEnakaivo pu vuꞌa ꞌahoꞌa pura icháꞌinaꞌe nimaa rojuji rone ꞌwame ꞌee Ea pina kwaviꞌina kaꞌene Jesuho Porura ijino maiꞌo hinu ꞌiavume panimaa vetiara. ");
INSERT INTO mcq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ꞌEnakaivo ijá vejumakame nara ꞌunama kaꞌene ꞌwarahunijaho puruva rejume na roe apoma hejuta. Hu Jerusaremi vaꞌe ꞌotua ikija kúꞌo veꞌena ho paꞌaji heꞌirono apovuta. ");
INSERT INTO mcq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ꞌEnakaivo Poru ura renajaho hu Sisa oni nini ꞌotua veꞌi ꞌwimana. ꞌEjuꞌe huni vwiha ijí heꞌirono hijiꞌi ranavuꞌe hinunaꞌomo na ranave Sisa oni vahuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Akuripara Pesitasiho ijá ꞌwama Na ura ea kajihuni vuꞌa heꞌi ꞌahiu ꞌwamana. ꞌEjume Pesitasira ijá ꞌwama A niari heꞌena ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ꞌEjume nenanaꞌomo súꞌu ꞌurine Akuripaho noꞌo Penisiꞌi vaꞌe ꞌotua vejuri ruhijino vaꞌiro vaꞌajaho ea ꞌajorame kehi kehi ꞌotua asúki vaꞌana. ꞌEꞌeme sorutia puni natohwijija ꞌee ea mamaꞌina kaꞌene ara kaji orijija pu puꞌúmo ijí ahuma aruma vaꞌumakiviꞌi Pesitasira ꞌwaravume pu Poruho ahema puni roara. ");
INSERT INTO mcq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ꞌEjume Pesitasira Akuripaho ꞌee ea ꞌahoꞌa kaꞌene pu puꞌúmo hija kajija ijá ꞌiama Ea kaꞌene nú puꞌúmo hijukije Jua kaꞌene Jerusaremi hine ꞌee iki hijujipo eakaho apene nuni unaꞌi ꞌotua vetiara. ꞌEnareja pu ajira ijá ꞌumeja Eakaho ꞌanaa kwahuna! ꞌumejara. ");
INSERT INTO mcq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ꞌEnakaivo na kavujaho hura unenuꞌu pina veꞌiraꞌomo hura kwahuni ꞌunamijaho na pakavuta. ꞌEnakaivo hu oriꞌini Sisa ꞌwarave huni vuꞌa hehuna ꞌwimana. Ijihuni hahi nara hu ranave vahunijaho ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ꞌEnakaivo na maiꞌo huni vuꞌa pini samaumai rejakame nara venareje nuni ea natohwijihuni ranava vahunijaho papiunavuta. ꞌEnajihunaꞌe nara eakaho ja ea mapoka ikehipuni unaꞌi apena routa kaivo kini Akuripa na nimaa a najaꞌirono apena routa. ꞌEnakúne jara henu vaꞌo nara vuꞌaka maa kaꞌene veja vahunijaho sama kavakame na veuta. ");
INSERT INTO mcq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nara tipurearu ranave vaꞌeje vuꞌa maa kaꞌene hu ꞌotua vetiajihuni maa paranave hu huꞌúmo vaꞌamajaho pamarahuna. ");
INSERT INTO mcq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ꞌEjume Akuripara Poruho ijá ꞌwama Iviꞌa a oni vuꞌa ꞌwaruma ꞌwamana. ꞌEjume Porura ꞌurine huni ija ahasiriꞌi kaivo hu huni vuꞌa aneja vene ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Uneunecha mapoka kaꞌene Juapo na namihujija na onuno vwihajujaho mamaa vene Kini Akuripa na iviasi oni unaꞌi ꞌwaraꞌeju. ");
INSERT INTO mcq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ijihuni maijaho a tamana ꞌee aposaraa kaꞌene Jua puni vaji navujaho a nihoꞌo he parajiꞌina. Ijihuni hahi na jarirame ꞌwaravukúne masuani hine heꞌamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ꞌEnaꞌomo Jua hia icháꞌina kaꞌene nara sesamuꞌuru rene hina apene roe iviasi ꞌeꞌujijaho nihene kivura. Na anejijaho ehu nu puꞌúmo ike nuni kwaa Jerusaremi vajakino hijuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Pu marako ꞌaha joraꞌe na hena kivajihunaꞌe pu ura na rone ꞌwaraꞌi ꞌahiꞌamajaho pu ꞌwarahuna kaivo na Parasiꞌe hijujaho nuni nimaa roijihuni tamanijaho nihoꞌo kikisimaꞌura. ");
INSERT INTO mcq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Godira emahu nunaꞌe nahama ꞌwaramajara roe nimaa rehuni jihuniji kaviꞌi hijujihunaꞌe iviamaa ꞌotua vaji namiju. ");
INSERT INTO mcq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Núni ituha iropu ropu noꞌo nahama ꞌwaravajara roe nimaa reꞌamarono ꞌajaha hijiꞌi naꞌia veiriꞌa siporua ꞌojiꞌi hijura. Oo kini ijaꞌinaꞌe na ꞌuꞌo nimaa rojujihunaꞌe Juakaho na namihe avaju. ");
INSERT INTO mcq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ja rakijihunaꞌe Godira ea kwamasahiꞌina veje ꞌurihunijija joni vaja panimaa rojo? ");
INSERT INTO mcq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nitama na ijaꞌina vwihajuta. Na uneunecha mapoka sisea areri parehuna venareje Jesu kaꞌene Nasareti orijihuni iha ruarahunaꞌe vwihajuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ikaho iraka kaꞌene Jerusaremi nara vejujina. Na ea kaꞌene nimaa rojiꞌinijija tipurai samahunaru pana kaivo pirisitia mamaꞌinapo harura mihume ea ꞌahoꞌa ꞌaniume kwamasahajaho na ꞌuꞌo nimaa vene ꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ꞌEne naꞌia mapoka na Sinakoku mapoka vajijino pu siseꞌi ꞌahiura ꞌee ira sisea ꞌwaraꞌavarono ꞌejahiura. ꞌEne nihoꞌo ajinima paranujaho vaꞌe apiopuni kwaa kajino ꞌanie ruarahura. ");
INSERT INTO mcq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ꞌEnaꞌomo pirisiti mamaꞌinijipo harura mihe ranamiume na Tamasikasi vaꞌiro vaꞌuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Oo kinia vea uariri namiꞌeme ꞌunamu toi na vaꞌi kavume akúpa ꞌahi niꞌimaꞌura hanaꞌeme nuni haha hanana. Ijara hananajaho veakara rinujaho asimana. ꞌEꞌeme ea kaꞌene nú puꞌúmo vaꞌajija ꞌuꞌo hananiana. ");
INSERT INTO mcq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ꞌEꞌeme nú niꞌaha kwinu mweꞌi apúsama naviꞌi na hejume ira kahi akúpi ꞌahi rene roe Hipuru puni iri ijá ꞌwima Soru Soru a irakijihunaꞌe Na siseꞌi ꞌahiu? Ijí usa rukimaꞌura ꞌaha kajino ꞌanahuna areri pana ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ꞌEjume na ijá ꞌwavo Natohwe A irarane ꞌwavuta. ꞌEjume Natohwijara ijá ꞌwima Na Jesu kaꞌene a siseꞌi ꞌahaujarana. ");
INSERT INTO mcq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ꞌEnakúne ꞌurine namina. Nara oni roujihuni maijaho a Nuni kaukara vejiꞌina rene raka kaꞌene Nara vejume a kamaji najahe ꞌee Nara najaꞌuji ꞌwaraꞌamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ꞌEne Nara Jua punaꞌijaho ꞌajoahe ꞌee Jenitaru puni Na a ranamauꞌe vaꞌujaho ꞌajoahuna. ");
INSERT INTO mcq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ꞌEjakame a veje puni nia jaraahuna. ꞌEne pu nututi hijujaho areꞌi kaivo taꞌarohe hanajiꞌiniji roajihuna ꞌee Setani oni harura hari hijujaho areꞌikaꞌi Godoni rohuna. ꞌEjakamareje sisea vwihanie arevujaho apene ꞌee ea kaꞌene nimaa rojajihuna Na iji pijihujipo aachia kaꞌene ꞌekahunijaho pu ꞌuꞌo ijihuni vaji ꞌekahuna ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ꞌEnajihunaꞌe O kini Akuripa akúpa huni visoni kaꞌene kavujaho na pauchavuta vo vejuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ꞌEnakaivo na marako Tamasikasi najahuta. ꞌEnarejo ijiꞌa roe Jerusaremi najahe vaꞌe Jutia puni ara kwaa vaja najahuta. ꞌEne Jenitaru ꞌuꞌo najahuta. ꞌEnarejo Na ikaꞌina ꞌwaravuta Pu puni sisea niarevarepo hine ojujaꞌinaꞌe oꞌavarono ꞌiavuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ijihuni hahi Jua ꞌahopo Temiporu vaji apene ꞌanie kwaꞌurono vejara. ");
INSERT INTO mcq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ꞌEjuꞌe Godira niꞌajiha apene rou vaꞌo roe iviamaa ꞌeꞌunukena. Ijihunaꞌe Godira niꞌajihukame na iviamaa ikino ea maꞌuꞌumae ꞌee ea mamaꞌina puni nii ꞌahi vuꞌa ꞌwaravu. Ijí nara ꞌwaravu kajaho ea kaꞌene poropetia ꞌee Mosisi puꞌúmo raka kaꞌene rehunaꞌe ꞌwaravaji na rone ꞌwaravuta. ");
INSERT INTO mcq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Pu ikaꞌina ꞌwaravara. Kerisoho Hu siseꞌi ꞌahae kwamareje kúꞌo ꞌurihuna kaivo Jua ꞌee Jenitaru Hura amuraꞌe vuꞌa kaꞌene hanajiꞌiniji najahe ꞌwaraꞌena ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Poruho huni vuꞌiji vahame ꞌwaravume Pesitasira ira ajira ijá ꞌwama Poru! Oni henaka niꞌinijara venauꞌe a nanamu ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ꞌEjume Porura ijá ꞌwama Pesitasi kaꞌene ea natohwakera na nihoꞌo pananavu kaivo na vuꞌa nimaa ꞌwaravu. ");
INSERT INTO mcq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kinijaho ike raka kaꞌene rejajaho nihene kimuna. ꞌEnajihunaꞌe na rakaꞌe hu ꞌwaraꞌi veꞌuji ꞌuꞌo matauma ꞌwarahuna. Na nihejura raka kaꞌene rejajaho hu nihena kiviꞌina. Ijihuni maijaho ijí vuꞌa kajaho nesi parejara. ");
INSERT INTO mcq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ꞌÚ kini Akuripa a poropetia nimaa vetiune? Ara ijaꞌina kaꞌene venujaho na niheju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ꞌEjume Akuripara eha vene ijá ꞌwama Poru iviamaa vea tuꞌuakino a na venie na Keriso oni ea reꞌi veju ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ꞌEjume Porura ijá ꞌwama Ike senia kaꞌene nuni haha ꞌahi namujina vo Na vea tuꞌua ꞌwaraꞌeju ꞌuho jora ꞌwaraꞌujaho nijina. Na Godi jarivu jihunaꞌe na ura aꞌasu pana vo ja ea mapoka kaꞌene hina nuni vuꞌa iviamaa heju kijahija nara rejujaꞌinaꞌe ja rehuna ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ꞌEjume kinijine kavana ijine Penisine ꞌee ea kaꞌene ijí pu puꞌúmo asuma hijajija ꞌurijara. ");
INSERT INTO mcq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ꞌEne pu ꞌurina kararu vaꞌi aneja vene ijá ꞌwava Eakaho unenuꞌu pina sisea veꞌiraꞌomo kwahuna ho tipurai apehuna pana ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ꞌEjume Akuripara Pesitasi ijá ꞌwama Ea kara Sisa oni vaꞌe ꞌotua veꞌirono ꞌwaramajaho paꞌareꞌipisa a hu ranave vaꞌa ꞌwamana. ");
INSERT INTO mcq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ꞌEnareja nú vea kaꞌene Itari sisima ajima vaꞌiro vejajino Poruho ꞌee tipura ea ꞌahoꞌa Juriasi kaꞌene Aukasitani opuni sorutia niꞌinijihuni ija ꞌahi irechamiana. ");
INSERT INTO mcq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aturamitiami opuni sisima kaꞌene Esia vaꞌiro venajino ea pina huni iha Arisitakasi kaꞌene Tesaronaika vaji Mesatonia orijaho nú puꞌúmo vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ꞌEnaꞌomo ijihuni súꞌuhijino nú kwaa iha Sairani usevara. ꞌEjume Juriasi hu Porunaꞌi hami venarena hu ranavume napuhwaha kiꞌi vaꞌana. Uneunecha kaꞌene hu areria paꞌajihi vajaꞌavarono vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nú ijí rena vaꞌeme puuri hiravumakame Saiparasi hanaꞌijaꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ꞌEnareja nú vaꞌe Sirisia ꞌee Pamipiria puni soha rori vaꞌe Mara Risia vaji usevara. ");
INSERT INTO mcq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ijí ara kajino sorutia puni ꞌajohiꞌina kajara Arekisanituria opuni sisima Itari vai vejume kame hu nú ijihuni toi irechamúana. ");
INSERT INTO mcq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ꞌEjume nú hine masuani vaiꞌi hiꞌeme naꞌia mapoka ijí paꞌarejara. ꞌEnareja nú harura niꞌimaꞌura vejume vaꞌe Naitusi usevara. ꞌEꞌeme puuri hirama rena tanuꞌu rúhumakame nú kaha pavaꞌara kaivo nú vaꞌe Kuriti Saramoni hanaꞌi vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nú vea kisina soha ꞌaha apejiꞌi asima roe Rasia ara niꞌinijaho Pea Heveni rorinaꞌomo ijí usevara. ");
INSERT INTO mcq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Vea niꞌinijaho manisame paꞌareꞌeme núra sisima ꞌahi vaꞌajaho nihoꞌo varapa piunahuni ꞌunama renana. Ijihuni maijaho vea kaꞌene ꞌaura arevujaho ꞌuꞌo niroe paꞌarena jihunaꞌe Poruho pu nahame pavaꞌavarono ꞌwaramana. ");
INSERT INTO mcq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ꞌEjumakaviꞌi Porura pu rurame ijá ꞌiama Ea kije na kavujaho nú iviamaa vaꞌukaho sisea piunahune kukua ꞌee sisima ꞌuꞌo paꞌareꞌeje ꞌee nú ꞌuꞌo kwamasahiꞌi veꞌeja ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ꞌEnakaivo sorutia ijaho sisima anesura ꞌee kaputini ijihipuni vuꞌa nimaa roꞌikaꞌi Porura raka kaꞌene ꞌwaramajaho pavejara. ");
INSERT INTO mcq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ruha kajaho sisei jihunaꞌe sisima naꞌia mapoka nahunijaho areri parenana. ꞌEnajihunaꞌe ea mapokijipo ꞌwame nimaa vejajaho ijí ruha kaji areme vahuna ura renaara. ꞌEnakaivo pu ura renajaho mamako vaꞌe Pinikisi Kuriti vajinaꞌomo useme ijino hihuna ura renajihuni maijaho ijí sisimapo namijuri ruhijaho puura karoꞌahuni vea ꞌonujaꞌi parene ꞌeꞌununa. ");
INSERT INTO mcq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ꞌEnajihunaꞌe hwasisia kamaꞌi ikikahi masuani ninavume pu vwihajajaho sisima vahuni ꞌunama maranu roꞌikaꞌi sisima anika tajahene apena vaꞌe Kuriti soha romai ijikari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ꞌEꞌeme ꞌaha josu pareꞌeme niꞌaha kwinu puura niꞌimaꞌura kaꞌene Urakwiro ꞌwavujara hiramana. ");
INSERT INTO mcq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ꞌEjume nú puura vaja kajino vaꞌajaho areri parejume nú ijá areꞌeme maiji soha rira kajino vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ꞌEnareja sisima ninuma vaꞌe mutumutua iha Karota rori vaꞌana. ꞌEnareja nú nihoꞌo harura niꞌimaꞌura vene eaha maꞌuꞌua kaꞌene sisima ꞌahi namajaho vevahanavara. ");
INSERT INTO mcq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Pu nihoꞌo jumareja sisima niꞌajaꞌamarono aja niꞌimaꞌura apene sisima ꞌaha muꞌoa kaji vevahavara. Pura juvajihuni maijaho Seritisi ajataki ajimareje kirana nahuniji vwihanareja avajara. ꞌEnareja pu sisima kajihuni aja kaꞌene ateha vevahivajaho rasaꞌi sisima kajaho mapirana ꞌoꞌojume mají vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ijihuni súꞌuhijino puura kajara majama hiramarena apena karohi kahi vejumakame pu ꞌiruma kaꞌene ijino sisima vaji navajaho ꞌeka atoꞌaruvara. ");
INSERT INTO mcq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ꞌEjaraꞌomo naꞌia noꞌopisu paareꞌeme ijihuni súꞌuhijino sisima kajihuni aja ꞌee ateha pu puni iji ꞌeke atoꞌaruvara. ");
INSERT INTO mcq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Naꞌia mapoka nú vea pakame ꞌee china pakivara. ꞌEꞌejuꞌe puurijara natohwa majama hine hiravume nú vwihajajaho núni iha nipaꞌarehuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ꞌEꞌeme ea mapoka ꞌiruma paiꞌi kaivo hiꞌeme naꞌia mapoka paꞌarenana. ꞌEjume Porura ꞌurine puni rira kajino namiꞌi kaivo ijá ꞌiama Eakije nuni irake heha. Nitama nú Kuriti hijaji ja nuni ira hene veꞌipisa uneunecha mapoka pasiserasahaꞌa. ");
INSERT INTO mcq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ꞌEnakaivo na iviamaa ja ꞌwaravukaho ja nihoꞌo teamanaꞌavara. Ja ea pina pakwahuna vo sisima ijara huhusu parahuna. ");
INSERT INTO mcq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Iviasi naꞌiakino Godi kaꞌene na Huni kaukara vene ꞌee na Huni ea rejujihuni ꞌona ojiꞌini roe nuni ꞌunaꞌi naminana. ");
INSERT INTO mcq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ꞌEnarena ijá ꞌwima Poru jumujaho arema. ꞌEnakaivo vaꞌe Sisa oni unaꞌi namine ꞌotua veꞌamana. ꞌEne hena! Ea mapoka kaꞌene ike sisima vaji hiju kakihija Godira a vajaha jihunaꞌe pu pakwamasahuna ꞌwimana. ");
INSERT INTO mcq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ꞌEnakúne ea kije ja teamanaꞌavara. Na Godi nimaa roju. Ijihuni maijaho Hura raka kaꞌene rehuna ꞌwarimajaho ijaꞌina rehuna. ");
INSERT INTO mcq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ꞌEnaꞌomo nú vaꞌe mutumutua pina ꞌahi ninama sisima siseraꞌena. ");
INSERT INTO mcq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Naꞌia iropu ropu noꞌona noꞌo ijino nú aherume Eturiatiki soha ꞌahi vaꞌara. ꞌEꞌeme naꞌia riri sisima kaukara vejiꞌinijipo vwihajajaho pu niroe amari ꞌahi rou rojara. ");
INSERT INTO mcq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ꞌEnareja pu mina vene kavajaho toa jopatuꞌumaꞌura (40 mita) kavara. ꞌEnareja pu maꞌuako vanamareja ijiꞌa kúꞌo mina vene kavajaho toa maꞌuako arii roe (30 mita) rejume kavara. ");
INSERT INTO mcq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ꞌEnareja pu veju roꞌi kaivo vaꞌu vaꞌo muna ꞌaha reha ninama veꞌena ronareja juvara. Pu niꞌaha kwinu anika noꞌona noꞌo ijá saꞌi kaivo pu hine vei nituꞌamarono ura rena parajara. ");
INSERT INTO mcq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ꞌEnareja ijí sisima kaukara vejiꞌinijija sisima kajaho ranaꞌikaꞌi vaꞌi ꞌahiumakame pu hine ꞌunama savara. ꞌEnareja pu eaha kajaho maꞌuako ape karokaru ranavumakame ea ꞌahoꞌa kaꞌene hija kajipo kivajaho pu anika apúsavu rojara kaivo pu nesi apena vaꞌi ꞌahiumakame avajara. ");
INSERT INTO mcq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ꞌEjume Porura sorutia ꞌee sorutia puni natohwijihi puꞌúmo ijá ꞌiama Ea karipo sisima vajaki pahiꞌavajaho ea pina nihoꞌo pahihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ꞌEjume sorutia kajipo eaha kaꞌene sisima ꞌaha kajino vevahavajija aja ꞌuhusavume ꞌona toa vaji vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Súꞌo vea ajiru ꞌeꞌuꞌi veꞌeme Poru ea mahoꞌo ꞌejahie ijá ꞌiama Jara ꞌiruma paiꞌi kaivo hiꞌeme vea iropu ropu noꞌona noꞌo ijá paꞌarenanakúne ꞌurine ꞌiruma ꞌekaha! ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ijihuni hahi na ja ꞌwaravukúne ja areme ꞌiruma ꞌeka iha. ꞌEjakame ꞌiruma kajara reje joni harura namama. Ijihuni maijaho ja ea kwinu nihoꞌo joni húmata sapasa kwinu patausiuhuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Hu ijá ꞌwaravume paꞌareꞌeme puretia apene puni unaꞌi Godi teimani ꞌwaꞌikaꞌi tuachame aneja vene inana. ");
INSERT INTO mcq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ꞌEjumakame ea mapoka kajija nihoꞌo teamanaꞌeme pu ꞌiruma ꞌahoꞌa ꞌeka ijara. ");
INSERT INTO mcq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nú ea kaꞌene sisima vaji hijajaho ea mapoka mapoka (276) hijara. ");
INSERT INTO mcq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ꞌEnareja pu ijume eaka mapoka kajija túꞌama parajara. ꞌEjume ꞌwitia kaꞌene ijí sisima vaji navajaho niꞌaha kwinu atoꞌaruvume sohi vaꞌara. Ijihuni maijaho sisima kajara nasina reꞌamarono avajara. ");
INSERT INTO mcq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ꞌEꞌeme vea ajiru ꞌeꞌuꞌejume pu kwaa kaji kavajaho puruva renaana. ꞌEnakaivo pu tohwira ora sama kamareja pu ura vaꞌe ijihunijino vaꞌi ꞌahiara. ");
INSERT INTO mcq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ꞌEjumakame pu puni anika sirirame ꞌee aja kaꞌene sisima vevahavajaho rasavara. ꞌEjume sisima kajaho ꞌurina vaꞌe asiasia roe sisima vaji ariha vejume sisima kajaho ijiꞌa vaꞌe kari ora rori vaꞌiro vaꞌana. ");
INSERT INTO mcq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ꞌEnuvaꞌo vaꞌe toa kahaꞌa roe tohwira rejume kamaꞌa sohi amena roe piunaravajaho muna navaraꞌomo ijihuni toi ajimarena kirana namana. ꞌEꞌeme soha kaꞌene ajira amena roajara vipunaꞌijaꞌi ninamarena nihoꞌo mutuusaha paranana. ");
INSERT INTO mcq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ꞌEjume sorutia tipuraepo ariha isume juhaha vaꞌajiꞌeja ronareja ꞌania kwamasahunaꞌe kosarame ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ꞌEnakaivo sorutia puni ea natohwijara Poru niꞌajaꞌi ꞌahaume ruravume pu areꞌeme ea kaꞌene areri isuaviꞌinijija ijá ꞌiava Ja marako mwama atoꞌarume isuama vaꞌa ꞌiavara. ");
INSERT INTO mcq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ꞌEꞌeme ea ꞌahoꞌa kaꞌene ijí hijajija ꞌurimarame sisima kaꞌene ijí mutuꞌusaha jihuni hasijaho ꞌekume ea ꞌahopo icha hasa ꞌeke ijihuni toi isuama vaꞌara. ꞌEnareja ea pina nihoꞌo unenuꞌu pina parenana kaivo nijaa ihena vaꞌe kari amari vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ꞌEjume pu mamaa roe amari ajivara. Nú ijiꞌa hena kavajaho ijí mutumutua kajihuni ihijaho Morutana ꞌwavuraꞌe hejara. ");
INSERT INTO mcq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ꞌEjume ijí ara kajiꞌurijipo nú hami hami ꞌahúara. ꞌEne nehi pina atuatuma jihunaꞌe pu vena jae roe nú aheruma vaꞌume nú ijí rori hijara. ꞌEjume pu nú ꞌajoruvara. ");
INSERT INTO mcq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Porura vena mwene iramanaꞌomo tapara ijihuni vaji hiꞌeme apena vaꞌe veni aporuvume vena kajihuni ohoi rejuma aseha ruꞌeꞌune Poru oni ija ꞌahi mwatuma utiha namana. ");
INSERT INTO mcq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ꞌEjumakame ara kajiupo kaꞌeme tapara kajara Poru oni ija ꞌahi mwatunanama kurima navuma kamareja pu aneja vene ijá ꞌwava Nimaa eakara ea ꞌaniuꞌe kwamasahara kaivo hu soha vaji roakaho unenuꞌu pina pareꞌeme hami roana kaivo mamaijaho pamakaꞌeje hu maiꞌo hihuna ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ꞌEnakaivo hu tapara kajaho ahaijiuvume vaꞌe veni renana kaivo hu unenuꞌu pina parenana. ");
INSERT INTO mcq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ꞌEjumakame pu vwihajajaho hu kwaꞌena ronareja pu ꞌajoha hina apene vaꞌajaho huni ija pahwene ꞌee paꞌona kwamana. ꞌEjumakame pu vwihajajaho hu godi ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kwaa kaꞌene núra useva kajaho ea natohwa kaꞌene Pupiriasina ꞌwavujihuni mweꞌa. ꞌEnaꞌomo hura nú aheruma vaꞌe huni sei irechamúe hami ꞌajohuꞌi hiꞌeme naꞌia noꞌopisu paꞌarenana. ");
INSERT INTO mcq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ꞌEnakaivo ijí ea kajihuni omijaho atami ꞌuname huni haha ohoa ani rene tea arihe ijá venana. ꞌEꞌeme Porura vaꞌe huni siporua ꞌone ꞌee huni ija ea kajihuni húmata ꞌahi ranamahume ea kajaho maranana. ");
INSERT INTO mcq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ꞌEjumakame ea mapoka kaꞌene mutumutua kajiꞌura kaꞌene atami ꞌuniraviꞌinijija nianaa apene huni roume maraniara. ");
INSERT INTO mcq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ꞌEnajihunaꞌe pu núni hura vene ꞌee mavarasa vejiꞌi hinuvaꞌo sisima pina roume nú vaꞌiro vejumakaviꞌi raka kaꞌene núra pivusahajija mahoꞌo vajúhara. ");
INSERT INTO mcq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ꞌEnakaivo nú masapa noꞌopisu ijí ara kajino hiꞌeme vea kaꞌene asiasia ꞌanauni veijino nú Arekisanituria opuni sisima kaꞌene hwaharisina puni urania naviꞌinijaho ijí mutumutua kajino namanaꞌomo ijihuni ꞌahi ajima vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nú vaꞌe ara iha Serakusi usevara. ꞌEnareja nú ijino naꞌia noꞌopisu hijara. ");
INSERT INTO mcq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ꞌEnareja nú Serakusi areꞌi kaivo ꞌurina vaꞌe Rijiami vaꞌara. ꞌEnaꞌomo ijihuni súꞌuhijino asiasia kamaꞌi ikiki hwasihumakaviꞌi nú ꞌurine Putiori vaꞌiro vaꞌeme naꞌia noꞌo paꞌarejara. ");
INSERT INTO mcq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ꞌEnareja ijí ara kajino Godoni ea ꞌahoꞌa piunivara. ꞌEnareja nú ijino pu puꞌúmo naꞌia iropuꞌa noꞌoheꞌi hiꞌavarono ꞌwaruvume hijara. ꞌEnareja ijiꞌa Romu vaꞌara. ");
INSERT INTO mcq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ꞌEjume Godoni ea kaꞌene Romu hijajijahija ijí henareja Apiasi oni maketia ꞌee Hoteru noꞌopisu namijuji rene nú piurihe roara. ꞌEjume vea kaꞌene Porura pu kimajaho nihoꞌo Godi teimani ꞌwame oja sonanana. ");
INSERT INTO mcq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nú vaꞌe Romu usevajaho Poruho huhusumano sorutia pini ꞌajohaꞌeje hihunaꞌe ꞌwaravara. ");
INSERT INTO mcq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ꞌEꞌeme vea noꞌopisu paꞌareꞌeme Porura Jua puni ea kaꞌene uraniꞌinijija ꞌumenaume pu roe ahuma hijumakiviꞌi hu aneja vene ijá ꞌiama Ehu nunakije na ehu nuna ea ꞌahoꞌa pasiseꞌi ꞌahiuta. ꞌEe emahu núpuni tamana ꞌahoꞌa papataarohuta kaivo pu na Jerusaremi tipura apenie Romu puni ija ꞌahi ranamiara. ");
INSERT INTO mcq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Pu na apenia Romu mihumakame pu hejajaho nara unenuꞌu pina sisea vejakame pu na ꞌania kwahuna pahenareja ranamie vahuna ura renaara. ");
INSERT INTO mcq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ꞌEnakaivo Jua kajija Romu opuni ira pataꞌarohumakame nuni ꞌunama paꞌarenana. Ijihunaꞌe na Sisa ꞌwaravakame hura nuni vuꞌa kaji heꞌena ꞌiavuta. ꞌEnakaivo nara ehu nunijihi unenuꞌu pina vetihuna pana. ");
INSERT INTO mcq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ijihuni hahi na ja kiviꞌi vuꞌa ijí ꞌwaraꞌiro ꞌwaravume ja iviasakaho roajivara. Isureri opo raka kaꞌene túnaꞌi reje kahuna kaꞌene vwihajiꞌi hijujihuni hahi senia ikaho na kamorivara ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ꞌEjume pu hu ijá ꞌwava Jutia ea ꞌahopo oni vuꞌa rone pasi veja rohuna pane ꞌee núni ehija ꞌahopo iki roajimareje nahama ꞌwaruhuna paꞌane ꞌee oni vuꞌa sisea rone ꞌwarahuna pana. ");
INSERT INTO mcq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nú ea ikihi puni vuꞌa aniꞌinaꞌe ꞌwamape ojukame nú ura oni vwiha ijí heꞌi ꞌahúu ꞌwavara. ");
INSERT INTO mcq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ꞌEꞌikaivo vea kaꞌene vuꞌa kaji ꞌwahunijaho iji pijaharaꞌomo vea kaji apejumakaviꞌi ea mapoka nianae apena roe sea kaꞌene hura hinaji roara. Hu Godoni arijihuni maiji najahe ꞌee Mosisi oni tamana tahe najahe ꞌee poropetia puni vuꞌa taha vejakame pu Jesu nimaa roꞌavarono ꞌwarama avanana. Hu vea súꞌu súꞌu rene vuꞌa ꞌwarama vaꞌe vea nutu ꞌoꞌunaji aremana. ");
INSERT INTO mcq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ꞌEjume ea ꞌahoꞌa nimaa rojume ea ꞌahoꞌa nimaa parojara. ");
INSERT INTO mcq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Pu paavacharame vai veꞌeme Poru ijá ꞌiama Godoni ꞌAvenijara vejume poropeti Aisea oni vaji nimaa amuhu núna ꞌwarama ijá ꞌiama ");
INSERT INTO mcq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Vaꞌajime eakihi ijá ꞌwarahuna. Ja nihoꞌo hehuna kaivo ijihuni maa pahena pakahuna. ꞌEne ja nihoꞌo hine kihuna kaivo ijihuni maa pakihuna. ");
INSERT INTO mcq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ijihunaꞌe eakija puni oja kisina rene puni ataa paꞌarenaꞌe ꞌee nia paꞌareja jihunaꞌe pu pahehune pakihune pavwihanareje taꞌarohe roe Nara veje pu maranihuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ꞌEnaꞌomo na ura ja hami hami ataa apúsame hehuna. Godoni vuꞌa kaꞌene ea niꞌajihunijaho Hu iviamaa ranavuꞌe Jenitaru puni vaja ꞌuꞌo vaꞌunaꞌomo pu ꞌuꞌo hehuna ꞌiamana. ");
INSERT INTO mcq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Hu ira kaji ꞌwaravume paꞌarej