﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcp_vpl;
CREATE TABLE mcp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcp_vpl WRITE;
INSERT INTO mcp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sə́ mə́ zə́ tɔ̧́ɔ̧lə impáámbə́ í Yésus-Krîst, mbyɛ̂l mə́ *Dávid, mbyɛ̂l mə́ *Abʉraham. ");
INSERT INTO mcp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abʉraham nyə a byâ *Izaag. Izaag mú byâ *Yákwab. Yákwab mú byâ Yúda bə́nɔ̂ŋ omínyɔŋʉ̂ bɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yúda mú byâ Farɛs bá Zára, nyɔɔŋgʉ́ wáŋ wə́ Tamar. Farɛs mú byâ Ɛsrom. Ɛsrom byâ Aram. ");
INSERT INTO mcp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram byâ Aminadab. Aminadab byâ Naáson. Naáson byâ Salʉmon. ");
INSERT INTO mcp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salʉmon bá Ráhab bwə́ mú byâ Bowaz. Bowaz bá Rut bwə́ mú byâ Obɛd. Obɛd mú byâ Yése, ");
INSERT INTO mcp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yése ka byâ Dávid. Njwú-buud Dávid bá kúsə́ mə́ Uri bwə́ mú byâ Sə́lʉmun. ");
INSERT INTO mcp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sə́lʉmun mú byâ Robwam. Robwam byâ Abiya. Abiya byâ Azaf. ");
INSERT INTO mcp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azaf byâ Zhwozafat. Zhwozafat byâ Zhworam. Zhworam byâ Oziyas. ");
INSERT INTO mcp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyas byâ Yótam. Yótam byâ Akwaz. Akwaz byâ Ezekyas. ");
INSERT INTO mcp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekyas byâ Manase. Manase byâ Amon. Amon byâ Zhwoziyas. ");
INSERT INTO mcp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zhwoziyas músə byâ Zhekoniyas bə́nɔ̂ŋ omínyɔŋʉ̂ bɛ́. Ja jɔɔŋgʉ̂ wə́ buud ɔ́ *Izʉrəyɛ̂l bwə́ á kə míkwám mí dɔ́ɔ́mb dɨ́ *Babilɔn yí. ");
INSERT INTO mcp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nûŋ Babilɔn, Zhekoniyas músə byâ Salátiyɛl. Salátiyɛl mú byâ Zorobábɛl. ");
INSERT INTO mcp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobábɛl byâ Abyûd. Abyûd byâ Eliyakim. Eliyakim byâ Azor. ");
INSERT INTO mcp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor byâ Sadog. Sadog byâ Ashim. Ashim byâ Eliyud. ");
INSERT INTO mcp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud byâ Elyazar. Elyazar byâ Mátan. Mátan byâ Yákwab. ");
INSERT INTO mcp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yákwab byâ Yósɛb, ŋgwúm mə́ Maríya. Maríya wɔɔŋgʉ̂ wə́ nyə a byâ Yésus, bwə́ dʉ jɔ̂w nə́ Krîst, Cʉgye buud Zɛmbî nyə á bwey kaag yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ntɔ́ ikala í búúd í á byɛ̂l wûm nə inɔ̧̂, tɛ́ɛ́dʉ́lə wə́ Abʉraham kə jé wə́ Dávid. Í á bə wûm nə inɔ̧̂ wúlə wə́ Dávid kə jé ja buud ɔ́ Izʉrəyɛ̂l bwə́ á kə míkwám mí dɔ́ɔ́mb dɨ́ Babilɔn yí. Bíl wûm nə inɔ̧̂ í á nyiŋgə byɛ̂l tɛ́ɛ́d ja bwə́ á kə míkwám dɨ́ yí kə jé wə́ Krîst. ");
INSERT INTO mcp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Byélé mə́ Yésus-Krîst í á bə ntʉ́ga: Nyɔɔŋgʉ́ yé Maríya bá Yósɛb bwə́ á bə nə cɛ̧ɛ̧lá bâ. Njɨ bwə́ kú fwo mpúya, Maríya mú ŋwa bum nə ŋkul mə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yósɛb nyɛ mú tə́dʉga nə́ a wɛ̂ny cɛ̧ɛ̧lá bâ wɔɔŋgʉ̂. Njɨ nda nyə á bə tʉ́təlí muud nə́ nyə á cɛɛl béégya nə Maríya shwoó, kú wá nyə shwôn. ");
INSERT INTO mcp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A ŋgə́ tə́dʉga ntɔ́, *éŋgəles mə́ Yawé mú zə lésha nə nyə ntámə́d nə́: «Yé Yósɛb Mwân mə́ *Dávid, wo kú fúndə bálə Maríya, nəcé mwán jɨ́ nyə mwɔ̧́ dɨ́ ɛ́nɛ ŋgə zhu wə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A bá byâ mwámudûm, wo bá gwiid nyə nə́ Yésus, nəcé nyə wə́ mə́ bá cʉg kúl búúd jé nə *misə́m.» ");
INSERT INTO mcp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sɔ́ɔ́lʉ́gʉ́ nɨ wɛ̂sh í á bwəma nə ciyá Zɛmbî nyə á bwey cɨ mpu mə́ *múúd micúndə́ yé dɨ́ yí, nə́: ");
INSERT INTO mcp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Sás lʉ́ mudá njúl ná ncwíyɛ̂ í bá ŋwa bum, í mú byâ mwámudûm. Bwə́ bá dʉ jɔ̂w nyə nə́ Imanuwɛ̂l. Jínə́ dɔɔŋg í kə́ nə́ Zɛmbî jisə sə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ja Yósɛb mə́ juum yí, a mú sá nda éŋgəles mə́ Yawé nyə ámə cɨ nə nyə nə́. Nyə á shwal bá Maríya, ");
INSERT INTO mcp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","njɨ bá bwə́ kú sɛɛŋgya, kə jé ja Maríya mə́ byâ mwámudûm yí. Yósɛb mú nə́mə́ gwiid Mwân wɔɔŋg nə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yésus nyə a byɛ̂l ŋgwə́la á Betʉlehɛm, shí á Yudéa, Herod ŋgə́ jwú nə lɔɔm. Ja Yésus mə́ shîn byɛ̂l yí, bɔ́ɔ́l búúd bwə́ á zhu ŋgɛɛ kɔ́ɔ́mb jwɔ̂w í dʉ cúwo yí, zə jé Yurʉ́səlɛm. Buud bɔɔŋgʉ́ bwə́ á bə məma ómpuye ɔ́ ísâ, bwə́ á dʉ bigas wəacén-cénî. ");
INSERT INTO mcp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bwə́ á ka ŋgə jî nə́: «Njwû *Oyúdɛn ŋgə́ kúnɔw byɛ̂l yɛ́, jɨ́ ŋgow? Sə́ á dʉ́g acén-céní yé kɔ́ɔ́mb jwɔ̂w í dʉ cúwo yí. Sə́ mə́ ká zə yə nyə gúmə́.» ");
INSERT INTO mcp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lâŋ nɨ í á ka zə tɨ̂ Njwú-buud Herod məkuú shí, bə́nɔ̂ŋ buud wâ Yurʉ́səlɛm bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ntɔ́ a mú jɔ̂w mílúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ wâ kúl búúd *Izʉrəyɛ̂l. A mú jî bwo nə́ bwə́ jááwʉg nyə kʉ́l í á bə nə́ *Krîst mə bá byɛ̂l yí. ");
INSERT INTO mcp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bwə́ nə nɛ́ nə́: «Betʉlehɛm, ŋgwə́la á Yudéa.» Sâ jɔɔŋgʉ̂ wə́ *múúd micúndə́ nyə á cilə yí, nə́: ");
INSERT INTO mcp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yé Betʉlehɛm, ŋgwə́la á Yudéa, Wo kú dʉ́g nə́ wo wə́ mə́ búl cwáágʉwo míŋgwə́la myâ Yudéa myɛ̂sh dɨ̂, nəcé wúl mbyágá wô í bá bə cî ánʉ́nɨ̂. Nyə wə́ mə́ bá wɨ́ɨl kúl búúd jâm Izʉrəyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ntɔ́ Herod mú jɔ̂w ómpuye ɔ́ ísâ ɔ́nɨ shwoó, nə́ bwə́ mpúg jaaw nyə baan ácén-céní wɔɔŋgʉ̂ nyə á tɛ́ɛ́d nyínʉ́lə joŋ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nə́ ndɛɛ́ nyə mú kənd bwo Betʉlehɛm. Nyə nə́: «Kagâ. Bɨ kə́g mpu wámbʉlə kʉ́l Mwân wɔɔŋg jísə́ yí. Bɨ́ mə́ ká kwey nyə, bɨ músə zə jaaw mə, mə bâg nə́mə́ kə yə nyə gúmə́.» ");
INSERT INTO mcp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ja bwə́ mə́ shîn gwágʉlə njwú-buud yí, bwə́ mú kyey. Bwə́ mú kwo dʉ́g ácén-céní bwə́ á fwo dʉ́g kɔ́ɔ́mb jwɔ̂w í dʉ cúwo yɛ́, a ŋgə́ kə bwo shwóg. A mú kə nə́ ndɛɛ́, kə jé kʉ́l mwân nyə á bə yí, a mú shigʉla cínɔŋg gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ja bwə́ mə́ dʉ́g ntɔ́ yí, bwə́ mú bul shwas. ");
INSERT INTO mcp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bwə́ mú nyíi njɔ́w, dʉ́g mwân bá nyɔɔŋgʉ́ yé Maríya. Bwə́ mú kúd mə́mpwoombʉ́ shí, yə mwân gúmə́. Nə́ ndɛɛ́ bwə́ mú juw íwɔ́lɛ byáŋ, ŋwa ísâ í gúmə́ bwə́ á zə nə ndɨ̂ yí, cwámbʉlə nyə. Isâ byɔɔŋg í á bə, nə or, nə *cáá nə *mîr. ");
INSERT INTO mcp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nə́ ndɛɛ́, Zɛmbî mú kɛ́wʉli bwo ntámə́d nə́ bwə́ kú ná kwo kə wə́ Herod. Ntɔ́ bwə́ mú kyey zhɨ́ɨ́ shúsʉ́d, nyiŋgə́lə kə bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ja ómpuye ɔ́ ísâ bwə́ mə́ shîn kyey yí, *éŋgəles mə Yawé mú zə lésha nə Yósɛb ntámə́d. Nyə nə́: «Wɔɔlʉ́g, wo ŋwág Mwân bá nyɔɔŋgʉ́, wo wúg nə bwo wa, bɨ kyéyʉg, kə shwaaw shí á Igîpten, nəcé Herod nyə e sɔ̧́ nə́ a gwú mwân. Bɨ́ é kə ji nûŋ, kə wɔ́ɔ́s ja mə́ bá cɨ nə́ bɨ nyíŋgəg zə yí.» ");
INSERT INTO mcp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yósɛb mú wɔɔl, ŋwa Mwân bá nyɔɔŋgʉ́ nə́mə́ búlú nɨɨ́d, bwə́ mú kyey kə shwaaw shí á Igîpten. ");
INSERT INTO mcp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bwə́ á ji wu, kə jé ja Herod nyə á yə yí. Sɔ́ɔ́lʉ́gʉ́ nɨ wɛ̂sh í á bwəma nda Yawé nyə á bwey lás wə́ *muud micúndə́ yé nə́, nə́: «Mə a jɔ̂w Mwân wáam, nə́ a wúg shí á Igîpten.» ");
INSERT INTO mcp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ja Herod mə́ dʉ́g nə́ ompuye ɔ́ ísâ bwə́ mə́ shɨɨg nyə yí, a mú jág gwág bɔ̂w. A mú kənd buud bɛ́ Betʉlehɛm nə mə́nd mâ kúnə́-kúnə, nə́ bwə́ kə́g gwú bwábudûm bɛ̂sh, tɛ́ɛ́d ikény kə jé bɔɔŋg wâ mimbû mímbá. Nyə a fɛ́ɛ́sh ntɔ́ bɛ̧ɛ̧́lə baan ómpuye ɔ́ ísâ bwə́ á jaaw nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ntɔ́ sâ múúd micúndə́ Zheremî nyə á bwey cɨ yí í mú zə bwəma. Nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Buud bwə́ á gwág oŋkwiimbyê ŋgwə́la á Rama nə məyə̂ nə mimbʉ́gú mí áyíyáág. Rashɛl nyə á ŋgə jɨɨ bwân bɛ́, a ŋgə́ ban nə́ muud kú cweel nyə mpimbə, nəcé bwân bwə́ cúgɛ́ ná. ");
INSERT INTO mcp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mpʉ́sə shwɨy mə́ Herod, Yósɛb njúl ná shí á Igîpten, éŋgəles mə Yawé mú kə lésha nə nyə ntámə́d. ");
INSERT INTO mcp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nyə nə nɛ́ nə́: «Tɔ́wʉ́g! Ŋwaŋg Mwân bá nyɔɔŋgʉ́, wo nyíŋgəg nə bwo, kə shí á *Izʉrəyɛ̂l, nəcé buud bwə́ á ŋgə cɛɛl gwú Mwân wá, bwə́ mə́ shîn yə.» ");
INSERT INTO mcp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yósɛb mú tɔ̂w, ŋwa Mwân bá nyɔɔŋgʉ́, a mú nyiŋgə nə bwo, kə shí á Izʉrəyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Njɨ a mú gwág nə́ Mwân mə́ Herod bwə́ á dʉ jɔ̂w nə Arkeláwos yɛ́ wə́ mə́ shúgʉla nə icî yâ Yudéa. A mú fúndə kə̌lə wu. Zɛmbî nyə á zə kɛ́wʉli nyə ntámə́d, a mú kə shí á Galilê, ");
INSERT INTO mcp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","kə ji ŋgwə́la á Nazarɛ̂t. Í á sɨ̂y ntɔ́ shú nə́ bwə́ bâg dʉ jɔ̂w nyə nə́: «Muud á Nazarɛ̂t». Ntɔ́, sâ búúd ɔ́ mícúndə́ bwə́ á bwey cɨ yí, í músə bwəma. ");
INSERT INTO mcp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na dúl fwála dɨ́, Yuánɛs Nduu-buud nyə á wɔ́ɔ́s shí a shwééshá á Yudéa. A mú ŋgə cúndə nə́: ");
INSERT INTO mcp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Cɛ́ndʉ́gá mitə́dʉ́gá nəcé Faan á gwɔ́w mú kúnə́-kúnə.» ");
INSERT INTO mcp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Muud micúndə́ Izayí nyə á shí bwey jaaw lâŋ mə́ Yuánɛs nɨ nə́: Muud ŋgə cúndə shí a shwééshád, a ŋgə cɨ nə́: «Kwambʉləgá zhɨ́ɨ́ mə́ Cwámba, bɨ́ sá íkwûŋ byé nə́ səndôŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Káándə́ Yuánɛs nyə á dʉ bwáád yí, í á bə sɨ́yá nə mimyɔ̧ɔ̧́ mí *shamô, kandá yé á kug nə kúúdú cúdú. Nyə á dʉ də ikájalá nə kwaan. ");
INSERT INTO mcp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ntɔ́ buud ɔ́ Yurʉ́səlɛm nə bɔɔŋg wâ shí á Yudéa tɔɔ bɔɔŋg wâ fuundú ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂ bɛ̂sh bwə́ á dʉ kə nyə́dɨ́, ");
INSERT INTO mcp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","kə́ dʉ magʉlə *mísə́m tâm buud, Yuánɛs músə ka dʉ duu bwo ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂. ");
INSERT INTO mcp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nə́ ndɛɛ́, nə *Ofarizyɛ̂ŋ nə *Osadwisyɛ̂ŋ bwə́ á dʉ zə ŋkí bulya nə́ Yuánɛs dúúg bwo. Nda nyə á dʉ́g ntɔ́ nə́, nyə á ka ŋkáánd nə bwo nə́: «Yé iyəlʉkag íga! Bɨ mə́ bə́lɛ fúndə mpimbə Zɛmbî mə́ bá lwóya yí? Zə́ ámə kɛ́wʉli bɨ́ ɛ́nɛ? ");
INSERT INTO mcp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wúmə́gá fwámɛ́ mpúmə́, í lwágʉ́lə́ nə́ bɨ mə́ cɛ́nd mítə́dʉ́gá yí. ");
INSERT INTO mcp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kúgá bɛ̧ njɨ dʉ́lə tə́dʉga nə́: “Sə́ bâŋ sə́ bɨ́ mpwoŋ buud mə́ *Abʉraham” nəcé mə mpú jaaw bɨ́ nə́ Zɛmbî jɨ nə ŋkul shwɔ̧́ɔ̧la mə́kwóógʉ́ mə́ga, sá mwo bwân ɔ́ Abʉraham. ");
INSERT INTO mcp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mpugá nə́ zʉ̂ŋ í wál zə sámb míkɔ̧ɔ̧lə́ mí ílɨ́ɨ́ mə́shugʉd. Bwə́ é cal lɨ́ɨ́ jɛ̂sh í ádɛ́ wúmə fwámɛ́ mpúmə́ yí, bwə́ kʉl gwo kudad. ");
INSERT INTO mcp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mɛɛ mə ŋgə duu bɨ́ nə məjúwó shú lwólə nə́ bɨ́ mə́ cɛ́nd mítə́dʉ́gá. Njɨ ŋgwɔ́l múúd ŋgə zə mə mpʉ́sə. A jɨ nə mpífə́ cɔ̧́ mə. Mə ampíyáyɛ́ nə́ mə yílʉ́g nyə məŋgwub mə́kuúd. Nywáá mə́ bá duu bɨ́ nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə kuda. ");
INSERT INTO mcp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A mbid fyafʉga mbwə́d. A bá zə bɛ́ɛ́g búúd nda bwə́ dʉ fyaf ŋkwáándə́ nə́. A ŋwa fwámɛ́ mpúmə́ nyɛ́ wá ŋkundád; a yîl ílwáásə́, shwu kuda jɨ́ kú bwɛlɛ jímə yííd.» ");
INSERT INTO mcp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ntɔ́ Yésus nyə a wú shí á Galilê, kə ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂ wə́ Yuánɛs shú nə́ Yuánɛs dúúg nyə. ");
INSERT INTO mcp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Njɨ Yuánɛs kú magʉlə. Nyə nə Yésus nə́: «Í yida jəla nə́ wo wə́ dúúg mə, kú bə nə́ mə wə́ dúúg wo.» ");
INSERT INTO mcp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yésus mú bɛ̧sa nə́: «Magʉləg nə́ í yídag bə nda mə́ ŋgə́ cɨ nə́, nəcé í jəla nə́ sâ jɛ̂sh í sɨ́yʉ́g nda Zɛmbî mə́ cɛ́ɛl nə́.» Yuánɛs músə magʉlə. ");
INSERT INTO mcp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Njɨ Yuánɛs nyə á shîn duu Yésus yí, Yésus ŋgə́ ná wú mə́júwó dɨ, joŋ í mú bâŋ. A mú dʉ́g Shíshim mə́ Zɛmbî í ŋgə́ shulə nda faf, zə ji nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nə́mə́ wəla dɔɔŋgʉ́, kə́l í mú cúwo joŋʉd, í ŋgə́ cɨ nə́: «Mwân waamə̂ alâm wə́ ɛ́ga. Nyə́dɨ́ wə́ lâm wâm wɛ̂sh wúsə́ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Shíshim mú kə nə Yésus shí a shwééshád nə́ Njwû məjamb kə́g bwɔ́wʉlə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yésus mú ci ídʉ̂w wu tâŋ mwɔ̂w məwûm mə́nɔ̧̂, nə mwásə́ nə bulû. A mú ka gwág zha. ");
INSERT INTO mcp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mása məbwə́bʉ́lán mú zə wɔ́ɔ́s nyə́dɨ́. Nyə nə nɛ́ nə́: «Ŋkí wo jɨ *Mwân mə́ Zɛmbî, cɨɨ́g nə məkwóógʉ́ mə́ga nə́ mə́ nyɛ́ɛ́g idʉ̂w.» ");
INSERT INTO mcp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yésus mú yidá bɛ̧sa nə nyə nə́: «Jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: Muud cugɛ́ nə ŋkul cʉgə njɨ nə idʉ̂w. Njɨ muud mə́ cʉgə nə ciyá jɛ̂sh í wú mpu mə́ Zɛmbî dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Njwû məjamb mú kə nə nyə ŋgwə́la mə́ Zɛmbî. A mú kə tə̂l nyə zhwááŋgɛ̂ *Mpáánzə́ Zɛmbî dɨ́ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nyə nə nɛ́ nə́: «Ŋkí wo jɨ Mwân mə́ Zɛmbî, bɨ́dʉ́g nyúul, kə kud shí. Nəcé jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: Zɛmbî mə bá lésha nə *wəéŋgəles bɛ́ shú dwô. Bwə́ é ŋkɛ̂ny wo mə́bwə́d shú nə́ kuú wô í nda bwɨɨm bɔɔgʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yésus mú bɛ̧sa nə nɛ́ nə́: «Jɨ́ nə́mə́ cilyá nə́: “Wo ajə́láyɛ́ nə bwɔ́wʉlə Zɛmbî woó Yawé.”» ");
INSERT INTO mcp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Njwû məjamb mú nyiŋgə ŋwa nyə, kə nə nyə wúl məma mbʉ́ŋ dɨ́ gwɔ̂w. A mú lwágʉlə nyə məfaan mɛ̂sh mâ shí nə gúmə́ jáŋ. ");
INSERT INTO mcp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nyə nə nɛ́ nə́: «Ŋkí wo kúd mpwoombʉ́ shí wa mə́dɨ́ míshʉ́d, yə mə gúmə́, mə yə wo isâ ínɨ byɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yésus mú bɛ̧sa nə nyə nə́: «*Sátan, wúg mə míshʉ́d! Jɨ́ nə́mə́ cilyá nə́: Dʉgʉ́ kúd mpwoombʉ́ shí njɨ wə́ Zɛmbî woó Yawé. Njɨ nyə wə́ wó dʉ́g yə gúmə́ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ja Njwû məjamb mə́ gwág ntʉ́nɨ yí, a mú bɨ́d Yésus. Wəéŋgəles bwə́ mú wɔ́ɔ́s, bwə́ mú ka zə sɛ̂y nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ja Yésus nyə a gwág nə́ bwə́ mə́ wá Yuánɛs mímbwug dɨ́ yí, nyə á kə shí á Galilê. ");
INSERT INTO mcp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Njɨ nyə a shígɛ́ ná kwo kə ŋgwə́la á Nazarɛ̂t. Nyə á yida kə ji ŋgwə́la á Kapɛrnawûm wúsə mâŋ dɨ́ koogʉ́, mpwəmá məshí mâ Zabulon nə Nɛftali yí. ");
INSERT INTO mcp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yésus nyə á kə ji nûŋ shú nə́ iciyá í Izayí *muud micúndə́ í bwə́mag. Izayí nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Məshí mâ Zabulon nə Nɛftali, mɔɔŋg mɨ́ ŋgɛɛ́ mâŋ dɨ́ má, mə́sə́ nə́mə́ fuundú ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂ má, kɔ́ɔ́mb Galilê íkûl ishús í njúl yí. ");
INSERT INTO mcp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Buud ɔ́ mə́shí mɔɔŋgʉ̂, bwə́ á dʉ ji yídʉ́gʉ́d. Bwə́ mə́ dʉ́g mə́ŋkɛnya! Bwə́ á dʉ cʉgə shwagə́ shwɨy dɨ̂. Məŋkɛnya mə́ mə́ kwan bwo. ");
INSERT INTO mcp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja Yésus nyə á shîn jé Galilê yí, nyə a tɛ́ɛ́d ŋgə́lə cúndə nə́: «Cɛ́ndʉ́gá mitə́dʉ́gá nəcé Faan á gwɔ́w í mú kúnə́-kúnə.» ");
INSERT INTO mcp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dúl jwɔ̂w, Yésus ŋgə́ kyey ncindye mâŋ mâ Galilê, nyə a dʉ́g omínyɔŋʉ̂ óbá, Shímun, bwə́ dʉ jɔ̂w nə́ Pyɛ̂r yɛ́, bá mínyɔŋʉ̂ yé Andrê bwə́ ŋgə́ wusə wód mə́júwód. Bwə́ á dʉ julə oshû nə məwód. ");
INSERT INTO mcp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A mú cɨ nə bwo nə́: «Bɛ̧gá mə, mə é sá nə́ bɨ́ dʉ́g julə búud.» ");
INSERT INTO mcp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nə́mə́ cé nə cé, bwə́ mú lʉ́gə mə́wód, bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bwə́ mú cɔ̧́ kə shwóg. Yésus mú nyiŋgə dʉ́g bɔ́ɔ́l ómínyɔŋʉ̂ óbá, Yuánɛs bá Zhâk, bwân ɔ́ Zhébedé. Bə́nɔ̂ŋ sɔ́ɔ́ŋgʉ́ wáŋ bwə́ á bə byɔ́ɔ́lʉ́d, bwə́ ŋgə́ kwambʉlə məwód máŋ. Yésus mú jɔ̂w bwo. ");
INSERT INTO mcp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cé nə cé, bwə́ mú lʉ́gə byɔ́ɔl dáŋ, nə sɔ́ɔ́ŋgʉ́ wáŋ, bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nə́ ndɛɛ́ Yésus nyə á ŋgə kyey shí á Galilê nyɛ̂sh, a ŋgə́ jɨ́ɨ́gʉli buud *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ́, a ŋgə́ cúndə Jɔ̧jɔ̧ Kɛ́ɛ́l á Faan mə́ Zɛmbî, a ŋgə́ nə́mə́ lwag buud məbwas mímbií myɛ̂sh, tɔɔ ijâm. ");
INSERT INTO mcp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lâŋ yé í á jwɔ̧ shí á Sirî nyɛ̂sh. Buud bwə́ mú zə nyə nə mimbə̂l myɛ̂sh, buud bwə́ á bə nə məváál mə́ mə́bwas mɛ̂sh nə məváál mə́ ófimâl mɛ̂sh, tɔɔ mimbúmbwúgʉ́, tɔɔ wəáfudə ibwúg, tɔɔ bɔɔŋg bwə́ á ŋgə lwáf nə məjamb wá. A mú lwag bwo. ");
INSERT INTO mcp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Buud bwə́ mú ka zə bɛ̧ Yésus áncuncuma, bɔ́ɔ́l bwə́ ŋgə́ wú shí á Galilê, bɔ́ɔ́lʉ́gá shí á Dekapwôl. Bɔ́ɔ́lʉ́gá bwə́ mú wú Yurʉ́səlɛm nə shí á Yudéa, nə nyɔɔŋg shí nyísə́ ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂ faŋwíny yí. ");
INSERT INTO mcp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ja Yésus mə́ dʉ́g áncuncuma buud ɛ́nɛ yí, a mú bád mbʉ́mbʉ́ŋʉ́d, kə ji shí. *Ompwíín bɛ́ bwə́ mú shísh nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A mú tɛ́ɛ́d jɨ́ɨ́gʉ́lílə ntʉ́ga: ");
INSERT INTO mcp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Buud bwə́ ŋgə́ mpu nə́ *mishíshim myáŋ mísə nə məbúwa wə́ Zɛmbî wá, bwə́ mə́ jəla, nəcé bwə́ wə́ bʉ́sə búúd wâ Faan á gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Buud bɨ́ nə məcɛy mílámʉ́d wá, bwə́ mə́ jəla, nəcé Zɛmbî mə bá cweel bwo milâm. ");
INSERT INTO mcp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Buud bwə́ ádɛ́ *búgʉla məŋkul máŋ wá, bwə́ mə́ jəla, nəcé bwə́ bá lʉ́g nə shí ga. ");
INSERT INTO mcp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Buud bwə́ ŋgə́ gwág cʉg á tʉ́təlí zha nə yɛ̂sh wá, bwə́ mə́ jəla, nəcé bwə́ bá jílə. ");
INSERT INTO mcp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Buud bwə́ ŋgə́ gwág búúd ŋkúŋkwóŋʉ́lə wá, bwə́ mə́ jəla, nəcé Zɛmbî mə bá nə́mə́ gwág bwo ŋkúŋkwóŋʉ́lə. ");
INSERT INTO mcp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Buud bɨ́ nə mílâm fúbán wá, bwə́ mə́ jəla, nəcé bwə́ wə́ bwə́ bá dʉ́g Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Buud bwə́ dʉ sá nə́ buud bwə́ cʉ́gəg nə́ shɛɛ wá, bwə́ mə́ jəla, nəcé bwə́ bá jɔ̂w bwo nə́ «Bwân ɔ́ Zɛmbî». ");
INSERT INTO mcp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Buud bwə́ ŋgə́ bwəma nə cúwʉ́lí nəcé otʉ́təlí ɔ́ Zɛmbî wá, bwə́ mə́ jəla, nəcé bwə́ wə́ bʉ́sə búúd wâ Faan á gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Ja buud bwə́ lwîy bɨ̂, bwə́ lwágʉlə bɨ̂ cúwʉ́lí, bwə́ lás nə bɨ́ ilɨ́s-lɨ́s nəcé mə yí, bɨ mə́ jəla. ");
INSERT INTO mcp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gwágʉ́gá məshusʉg, bɨ́ kɔɔs, nə́ bɨ mə bá kə bə nə məma myə́na gwɔ̂w. Nəcé ntʉ́nɨ nə́mə́ wə́ bwə́ á sá nə *buud ɔ mícúndə́ bwə́ á tɛ́ɛ́d zə nə bɨ́ wá; bwə́ á lwágʉlə bwo cúwʉ́lí.» ");
INSERT INTO mcp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Bɨ bɨ́ nə buud nə́mə́ nda ca dʉ́sə́ nə idʉ̂w nə́. Ŋkí ca í cwâl, ye bɨ bɨ́ nə ŋkul kwo sâ nə í gwámʉ́g? Mbɔ̂, í cúgɛ́ nə ŋkul nyiŋgə sɛ̂y. Bwə́ yida shwu dwo shí, buud jee nyaal.» ");
INSERT INTO mcp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Bɨ bɨ́ məŋkɛnya shú búúd ɔ́ shí ga. Ŋgwə́la wúsə́ mbʉ́mbʉ́ŋ dɨ́ gwɔ́w yí, í cúgɛ́ nə ŋkul bə kú nyîn. ");
INSERT INTO mcp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mbií ŋgwúd nə lámba, ja bwə́ dʉ jida dwo yí, bwə́ ádɛ́ kúd dwo mpɨ́ɨ́d. Bwə́ yida dʉ tə̂l dwo cé lámba dɨ́, í ŋgə́ faan, buud ɔ njɔ́w bɛ̂sh bwə́ dʉ́g mə́ŋkɛnya. ");
INSERT INTO mcp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ntɔ́, məŋkɛnya mʉ́n mə́ jəlá nə nyîn búúd dɨ̂. Bwə́ dʉ́gʉ́g jɔ̧jɔ̧ mísɔ́ɔ́lʉ́gʉ́ mín, bwə́ mú ságʉsə Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Bɨ kú ŋgə tə́dʉga nə́ mə mə́ zə nyaal Mə́cɛ̧ɛ̧ mə́ Moyîz nə minjɨ́ɨ́gʉ́lá mí *búúd ɔ mícúndə́. Mə azə́yɛ́ nyaal myo, mə á yida zə sá nə́ mí bwə́mag. ");
INSERT INTO mcp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, té wɛ̂sh gwɔ̂w nə shí í ŋgə́ ná bə yí, tɔɔ kaŋgá ŋgwúd á *mbwoomb mə́cɛ̧ɛ̧ ŋkí cúcwán í ábʉ́lɛ́ bwɛlɛ wû, kə jé jwɔ́w byɛ̂sh í bá fwo bwəma yí. ");
INSERT INTO mcp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ntɔ́ wə́ jɨ́ nə́, múúd mə ká mpyêny cʉ́cɛ̧ɛ̧́ ŋgwúd, ŋkí nə́ á julə búúd nə́ bwə́ sáág ntɔ́, muud wɔɔŋgʉ̂ mə bá bul bə bíbíyá Faan á gwɔ́wʉ́d. Njɨ muud mə bá bɛ̧ mə́cɛ̧ɛ̧, a julə búúd nə bwə́ sáág ntɔ́ yɛ́, a bá bə fwámɛ́ múúd Faan á gwɔ́wʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mə́ mpú jaaw bɨ́ nə́ Zɛmbî jɨ nə ŋkul magʉlə múúd Faan dɛ́d njɨ muud tʉ́təlí yé mə cɔ̧́ nyɔɔŋg á *Ofarizyɛ̂ŋ nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Bɨ a shí gwág nə́ bwə́ á cɨ nə odá nə́: “Muud kú gwú múúd. Muud mə ká gwú múúd, bwə́ tə̂l nyə kɔɔdʉd.” ");
INSERT INTO mcp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Njɨ mɛɛ mə́ cɨ nə bɨ́ nə́ múúd mə ká gwág mpimbə nə mínyɔŋʉ̂ yé, a tɔ̂w nə́mə́ kɔɔdʉd. Múúd mə ká lwîy mínyɔŋʉ̂ yé, bwə́ kə nə nɛ́ *Mpáánzə́ milə́sʉ́ á Zɛmbî. Múúd mə ká jɔ̂w mínyɔŋʉ̂ yé nə́ mpúfú, á jəlá nə kə *Gehɛ̂n kuda á kandʉgəd. ");
INSERT INTO mcp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Í ká wɔ́ɔ́s nə́ wo ŋgə́ kə *alatâr dɨ́ nə́ wo kə́ yə́ Zɛmbî gúl sâ, wo ka tə́dʉga nə́ ŋgwɔ́l mínyɔŋʉ̂ woó ŋgə gwág wo mpimbə, ");
INSERT INTO mcp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lʉ́gə́g sâ jɔɔŋgʉ́ na kúnə́-kúnə nə alatâr, wo tɛ́ɛ́d fwo kə kwambʉlə nə mínyɔŋʉ̂ woó. Cínɔŋgʉ́, wo mú ka tɛɛm zə yə́ Zɛmbî sá wó yə́ nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Ŋkí wo mə́ byaagʉlə nə ŋgwɔ́l múúd nə́ ndɛɛ́ á cɛɛl kə nə wo mpáánzə́ milə́sʉ́, lɛɛlʉg kwambʉlə nə nɛ́ té bɨ́ bɨ́ ná zhɨ́ɨ́d ŋgə́lə kə yí. Nəcé nyə a bá kənd wo wə́ sémbye milə́sʉ́, sémbye milə́sʉ́ mú kənd wo wə́ fulísh, fulísh kə wá wo mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bʉ́bə́lɛ́ mə́ jaaw wo nə́, wo cugɛ́ nə ŋkul wú mímbwug myɔɔŋgʉ́d, té wɛ̂sh wo afwóyɛ́ shîn jə́na tâŋ nyɛ̂sh, fáda ŋgwúd kú lʉ́g yí.» ");
INSERT INTO mcp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Bɨ a shí gwág nə́ bwə́ á cɨ nə́: “Muud kú sá minɔɔmb.” ");
INSERT INTO mcp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Njɨ mə́ jaaw bɨ́ nə́ múdúm mə́ ká dʉ́g múdá ŋkán mədʉ́gya mâ wɨ́ɨ́mbʉ́lə nyə, a mə́ bwey sá minɔɔmb nə mudá wɔɔŋg nyə́dɨ́ lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nə́ ndɛɛ́, í ká bə nə́ jús dwô á məncwûm í dʉ sá nə́ wo sáág *sə́m, tɨ́ɨ́g dwo, wo wusə dwo shwóg-shwóg. Nəcé í bul jəla nə́ wo jímbálʉ́g gúl kʉ́l nyúul gwô, ntɔ̧ nə́ bwə́ wúsəg nyúul nywô ncindî kuda á kandʉgəd. ");
INSERT INTO mcp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ntɔ́ ŋkí mbwə̂ wô á məncwûm í dʉ sá nə́ wo sáág sə́m, sámbʉ́g wə, wo wusə wə shwóg-shwóg. Nəcé í bul jəla nə́ wo jímbálʉ́g gúl kʉ́l nyúul gwô, ntɔ̧ nə́ nyúul nywô ncindî í kə́g kuda á kandʉgəd.» ");
INSERT INTO mcp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Gúl ciyá jɨ́ nə́mə́ nə́: “Ŋkí mudûm mə́ cɛɛl yîl mudá yé bâ, á jəlá nə yə́ mudá wɔɔŋgʉ̂ fə́b lʉ́ məgwú mə́ bâ.” ");
INSERT INTO mcp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Njɨ mɛɛ mə́ jaaw bɨ́ nə́, muud yɛ̂sh mə yíl múdá yé báád, mudá kú fwo sá mínɔɔmb yɛ́, mudá wɔɔŋg mə ká kə́ dúl báád ɨɨ́, ŋgwúm yé wə́ mə́ cíndal nyə nə́ a sáág minɔɔmb. Múúd mə́ ká bá múdá bwə́ ámə yîl bâ yɛ́, muud wɔɔŋg mə́ sá nə́mə́ mínɔɔmb.» ");
INSERT INTO mcp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Bɨ a shí nə́mə́ gwág nə́ bwə́ á cɨ nə odá nə́: “Wó ká kɛɛn Zɛmbî gúl sâ dɨ́, ság sâ jɔɔŋgʉ̂ kú bɨ́d.” ");
INSERT INTO mcp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Njɨ mɛɛ mə́ jaaw bɨ́ nə́ bɨ kú ná dʉ kɛɛn tɔɔ sâ. Bɨ kú kɛɛn joŋ lʉ gwɔ̂w nəcé dʉ́sə *caaŋgə́ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bɨ kú kɛɛn shí nəcé cínɔŋg wə́ á dʉ tə̂l məkuú yɛ́. Bɨ kú kɛɛn Yurʉ́səlɛm nəcé jísə də́nd mə́ Zɛmbî, Njwú-buud ánʉ́nɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wó kú kɛɛn lúú wô, nəcé wo cúgɛ́ nə ŋkul shwɔ̧́ɔ̧la tɔɔ ntand shilú ŋgwúd nə́ í fúməg ŋkí nə́ í yíndə́g. ");
INSERT INTO mcp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ntɔ́ jɨ nə́ wó ká cɨ nə́ wo sá gúl sâ, cɨɨ́g njɨ nə́: “Haaw, mə é sá”. Wó ká cɨ nə́ wo asáyɛ́ gúl sâ, cɨɨ́g njɨ nə́: “Mbɔ̂, mə asáyɛ́”. Ciyá jɛ̂sh wó kwádʉlə na gwɔ́w yí, í zhu wə́ Mbʉ́wʉ́lú múúd.» ");
INSERT INTO mcp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Bɨ a shí gwág nə́ bwə́ á cɨ nə́: “Jús í cé jús, jə í cé jə”. ");
INSERT INTO mcp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Njɨ mɛɛ mə́ cɨ nə́, muud kú kə nə lal lúu wə́ sɔ́ɔ́l məbɔ̂w. Ŋkí muud mə nyífə́ wo bɔ́ɔ́nz mbáŋ á məncwúmʉ́d, yə́g nə́mə́ nyə wúl mbáŋ. ");
INSERT INTO mcp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ŋkí muud mə kə́ nə wo njɔ́w mílə́sʉ́ nə́ a mánda wo nə wáma gwô á cwû, bɨ́dʉ́g a kə́g nə́mə́ nə kúúd. ");
INSERT INTO mcp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Múúd mə ká zə nə mpə̂l zə yɨ́ɨ́mbʉli wo nə́ wo ŋkɛ́nyʉ́g nyə mbag, cé kílomáda ŋgwúd, wɛɛ kaág nə nyə okílomáda óbá. ");
INSERT INTO mcp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Múúd mə ká gwáámb wo sâ, yə́g nyə; nyɔɔŋg mə zə́ kwalád wódɨ́ yɛ́, wo kú ban.» ");
INSERT INTO mcp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Bɨ a shí gwág nə́ bwə́ á cɨ nə́: “Wó jəlá nə cɛɛl múúd yɛ̂sh jísə́ wo kúnə́-kúnə yɛ́, wo mpii zhízhíŋ wô”. ");
INSERT INTO mcp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Njɨ mɛɛ mə́ cɨ nə bɨ́ nə́ cɛɛlʉgá mizhízhíŋ mín, bɨ́ jəgʉla nə Zɛmbî shú bɔɔŋg bwə́ ŋgə́ lwágʉlə bɨ́ cúwʉ́lí wá. ");
INSERT INTO mcp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ntɔ́ í é mpûy nə́ bɨ bʉ́sə bwân ɔ́ Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́. Nəcé Zɛmbî mə́ dʉ sá nə́ yásə́ í fáánʉg shú buud bɛ̂sh, tɔɔ bɔɔŋg ɔ́ ányunywaâ tɔɔ bɔɔŋg ɔ́ abʉ́bɔ̂w. A dʉ nə́mə́ sá nə́ mpú nywɔ̧́g shú búúd bɛ̂sh, tɔɔ bɔɔŋg ɔ́ átʉ́təlí tɔɔ bɔɔŋg bwə́ cúgɛ́ tʉ́təlí wá. ");
INSERT INTO mcp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ŋkí bɨ́ mə́ cɛɛl njɨ buud bwə́ cɛ́ɛ́l nə́mə́ bɨ́ wá, bɨ mə mpíyá nə máyɛ́ myə́na? Ŋgaá buud bwə́ dʉ ŋwa otóya wá bwə́ dʉ nə́mə́ sá ntɔ́? ");
INSERT INTO mcp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ŋkí bɨ mə́ dʉ bə́da njɨ omínyɔŋʉ̂ bʉ́n, ye gúl sâ ágúgwáan wə́ cɨ́? Ŋgaá íkûl ishús í dʉ nə́mə́ sá ntɔ́? ");
INSERT INTO mcp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bə́gá mbii í jə́la yí, nə́mə́ nda Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́, a jɨ mbii í jə́la yí.» ");
INSERT INTO mcp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ja bɨ́ mə́ dʉ sá misɔ́ɔ́lʉ́gʉ́ myâ Zɛmbî yí, sɔ̧́gá nə́ í kú dʉ bə lwóyá. Bɨ́ mə́ ká dʉ lwóya búúd dɨ́, Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́, kú ná kwo yə bɨ́ myə́na. ");
INSERT INTO mcp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Í ká bə nə́ wo yə mbúmbúwá *mwaanɛ̂, wo kú báŋgʉla nə sâ jɔɔŋgʉ̂ nda búúd ɔ́ mə́kə́ŋ bwə́ dʉ sá *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá, nə mə́zhɨɨ́ məzhɨɨ́ nə́. Bwə́ dʉ sá ntɔ́ nə́ buud bwə́ yə́g bwo gúmə́. Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, myáŋ myə́na myɛ̂sh wə́ mínɨ. ");
INSERT INTO mcp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Njɨ wɛɛ, ja wó yə́ mbúmbúwá mwaanɛ̂ yí, ság nə́ mbwə̂ məkɔ́ɔ́l wô í bə́g kú mpu sá mbwə̂ məncwûm í ŋgə́ sá yí, ");
INSERT INTO mcp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","nəcé yána dwô í jəlá nə sɨ̂y shwoód. Sɔ́ɔ́ŋgʉ́ woó mə́ dʉ dʉ́g sâ jɛ̂sh jɨ́ shwoód yɛ́, mə́ bá fáágʉlə wo.» ");
INSERT INTO mcp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ja bɨ́ mə́ sá mə́jəgʉla yí, kúgá sá nda buud ɔ́ mə́kə́ŋ. Bwə́ bul cɛɛl dʉ sá mə́jəgʉla, bwə́ tə́l ótʉ́təlí *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá nə mə́zhɨɨ́ məzhɨɨ́ shú nə́ buud bwə́ dʉ́g dʉ́g bwo. Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, myáŋ myə́na myɛ̂sh wə́ mínɨ. ");
INSERT INTO mcp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Njɨ wɛɛ, wó ká cɛɛl jəgʉla nə Zɛmbî, kag nyíi wódɨ́ kʉ́l fúm. Wó fad mbɛ̂, wo mú ka jəgʉla nə Sɔ́ɔ́ŋgʉ́ woó nəcé a jɨ na kʉ́l búúd bwə́ cúgɛ́ yí. Ntɔ́ Sɔ́ɔ́ŋgʉ́ woó mə́ dʉ dʉ́g ísâ í shwoó byɛ̂sh yɛ́, a bá fáágʉlə wo. ");
INSERT INTO mcp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Ja bɨ́ mə́ sá mə́jəgʉla yí, kúgá bul íciyá bí kú nə wúmbʉ́lé yí. Ikûl ishús wə́ í dʉ sá ntɔ́. Bwə́ dʉ tə́dʉga nə́ Zɛmbî mə́ dʉ gwágʉlə bwo nəcé zhwog iciyá. ");
INSERT INTO mcp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bɨ kú sá nda bwo, nəcé Sɔ́ɔ́ŋgʉ́ wʉ́n mə́ dʉ bwey mpu sâ bɨ́ ŋgə jɨɨ yí, bɨ njúl kú fwo gwáámb nyə gwo. ");
INSERT INTO mcp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bɨ́ ɔ́ bâŋ dʉgá jəgʉla ntʉ́ga: “Yé Sɔ́ɔ́ŋgʉ́ wúsʉ́ jɨ́ gwɔ́w yɛ́, jínə́ dwô í bə́g nə gúmə́ ntɔ̧ sâ jɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ijwûga byô í zə́g, buud bwə́ bɛ̧́g micɛ̧ɛ̧lá myô shí gaád, nə́mə́ nda í dʉ sɨ̂y gwɔ́w nə́. ");
INSERT INTO mcp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yə́g sə́ idʉ̂w í jə́lá nə sə́ múús yí. ");
INSERT INTO mcp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Juug sə́ nə məbyaagʉlə mə́sʉ́ nə́mə́ nda sə́ ŋgə́ juu buud bwə́ ŋgə́ byaagʉlə nə sə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wo kú bɨ́d nə́ məbwə́bʉ́lán mə́ ntɔ̧́g sə́ ŋkul. Sáág nə́ sə́ fáámʉg mə́bwə̂ mə́ Mbʉ́wʉ́lú múúd dɨ̂. Nəcé ijwûga nə ŋkul nə gúmə́ bísə isâ byô, kandʉgə á kandʉgə. Amɛn.” ");
INSERT INTO mcp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Mpugá nə́ bɨ́ mə́ ká dʉ juu búúd nə iwushí byáŋ, Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́ nyə bá nə́mə́ dʉ juu bɨ̂ nə iwushí bín. ");
INSERT INTO mcp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Njɨ bɨ́ mə́ ká bə kú juu búúd nə iwushí, Sɔ́ɔ́ŋgʉ́ wʉ́n nyə abʉ́lɛ nə́mə́ juu bɨ̂ nə iwushí bín.» ");
INSERT INTO mcp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ŋkí bɨ mə́ ci idʉ̂w nə́ bɨ mə yə́ Zɛmbî gúmə́, bɨ́ ajə́láyɛ́ nə ŋgə ji nə́ shúsʉ́lú-shúsʉ́lú nda buud ɔ́ mə́kə́ŋ. Buud bɔɔŋgʉ́ bwə́ dʉ nywadʉlə mə́ŋkágə́ nə́ bwə́ lwóya nə́ bwə́ ŋgə ci idʉ̂w. Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, myáŋ myə́na myɛ̂sh wə́ mínɨ. ");
INSERT INTO mcp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Njɨ wɛɛ, wó ká ci idʉ̂w nə́ wo yə́ Zɛmbî gúmə́, gusag mísh, wo kwambʉlə nyúul. ");
INSERT INTO mcp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Wó jəlá nə sá nə́ buud bwə́ kú mpu nə́ wo ŋgə ci idʉ̂w. Ntɔ́ Sɔ́ɔ́ŋgʉ́ woó mə́ dʉ dʉ́g ísâ í shwoó byɛ̂sh yɛ́, mú bá fáágʉlə wo.» ");
INSERT INTO mcp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Kúgá ŋkúnd byɔɔg shí gaád, kʉ́l óshê nə myáŋgʉlə́ í dʉ də ísâ yí, ijúwâl dʉ búgə mímpumbɛ́ dʉ júwo yí. ");
INSERT INTO mcp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yidagá ŋkúnd byɔɔg gwɔ́w, kʉ́l óshê nə myáŋgʉlə́ í ádɛ́ də ísâ yí, ijúwâl kú dʉ búgə mímpumbɛ́ dʉ júwo yí, ");
INSERT INTO mcp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","nəcé kʉ́l byɔɔg dwô mbwúg yí, cínɔŋg wə́ lâm wô í é bə nə́mə́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Jús dʉ́sə lámba á nyúul. Jús í ká bə kú nə bwas ɨɨ́, nyúúl nyɛ̂sh bə mə́ŋkɛnyad. ");
INSERT INTO mcp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Njɨ, mísh mwô mə ká bə ŋkí bɔ̂w, nyúúl nywô bə yídʉ́gʉ́d. Ntɔ́, ŋkí mísh mwô mə́ adʉ́gɛ́ tɛɛm bə sâ, á wagʉwólə jâŋ yídʉ́gʉ́!» ");
INSERT INTO mcp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Muud cúgɛ́ nə ŋkul sɛ̂y nə omása óbá ja ŋgwúd, nəcé nyə é mpii ŋgwɔ́l, a cɛɛl ŋgwɔ́l; gúl ja nyə e gwág nə ŋgwɔ́l, a mpyêny ŋgwɔ́l. Bɨ́ cúgɛ́ nə ŋkul sɛ̂y nə Zɛmbî bɨ ŋgə́ sɛ̂y nə *mwaanɛ̂ ja ŋgwúd.» ");
INSERT INTO mcp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Mə́ ka cɨ nə bɨ nə́, bɨ kú dʉ yágʉwo cʉg jɨ́n nə́ bɨ́ é də jɨ́. Bɨ kú yágʉwo mə́nyúúl mʉ́n nə́ bɨ́ é bwáád jɨ́. Ŋgaá nə́ cʉg í ntɔ̧ ídʉ̂w, nyúul ntɔ̧ míkáándə́. ");
INSERT INTO mcp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mpugá dʉ́g ínunú. Í ádɛ́ bɛ̧ mə́mpəg, kú mwáágʉlə mpúmə́, kú nə sâ bwə́ wá ówaag ɔ ídʉ̂wʉd. Njɨ Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́ ŋgə wɨ́ɨl byo. Ŋgaá, bɨ bɨ́ nə mfíí cɔ̧́ ínunú byɔɔŋgʉ̂? ");
INSERT INTO mcp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Zə́ á na bɨ́dɨ́ jɨ́ nə ŋkul bə nə́, nəcé a ŋgə́lə yágʉ́wó, a kwádʉlə jwɔ̂w ŋgwúd nyə́dɨ́ cʉg dɨ́ yɛ́? ");
INSERT INTO mcp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Nəcé jɨ́ bɨ́ mə́ dʉ sá yágʉwo mímbwéédí yí? Mpugá dʉ́g nda ofʉláwa bwə́ dʉ wɨ̂y mə́ncugú nə́. Bwə́ ádɛ́ yɨ́ɨ́ŋga nə isɛ́y, kú tiŋ míkáándə́. ");
INSERT INTO mcp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Njɨ mə mpú jaaw bɨ́ nə́ cî Sə́lʉmun nyə á tɛɛm jág bul bə nə gúmə́, nyə a shígɛ́ bwɛlɛ bwáád nda ofʉláwa. ");
INSERT INTO mcp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ŋkə́mʉ́sá Zɛmbî mə fwó bwééd zhizhe sâ nda akánda á jugʉ̂ jɨ́ nə́ bwə́ é wusə kuda dɨ́ mán yɛ́, ŋkəmʉsa nə bɨ̂. Ye bɨ wə́ nyə é bə kú bul mpu bwééd wá? Yé búúd wâ tag búgə́ óga! ");
INSERT INTO mcp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kúgá dʉ yágʉwo nə́: “Sə́ é də jɨ́, sə́ é ŋgul jɨ́, sə́ é bwáád jɨ?” ");
INSERT INTO mcp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ikûl ishús wə́ í dʉ́ ŋgə wádʉga sɔ̧́ isâ ínɨ byɛ̂sh. Bɨ báá kúgá dʉ sɔ̧́ byo, nəcé Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́ mə mpú nə́ í jɨɨ bɨ́ isâ byɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yidagá dʉ fwo tə̂l ísâ í dʉ́gyá nə Faan mə́ Zɛmbî yí shwóg, bɨ́ cʉgə tʉ́təlí mísh mɛ́d, Zɛmbî ka dʉ kwádʉlə bɨ́ ísâ ínɨ byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ntɔ́ bɨ́ kú yágʉwo sâ í bá sɨ̂y mán yí, nəcé isâ yâ mán í é bá nə́mə́ mpûy mán. Micúŋ myâ ŋkúmba jwɔ̂w mí kwaga nə dâŋ jwɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Kúgá dʉ jɛ́ɛ́g búúd minjagə́, bwə́ bâg nə́mə́ dʉ bə kú jɛ́ɛ́g bɨ́ minjagə́. ");
INSERT INTO mcp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bwə́ bá dʉ jɛ́ɛ́g bɨ́ minjagə́ mbií ŋgwúd bɨ́ é dʉ jɛ́ɛ́g bɔ́ɔ́l búúd minjagə́ yí. Nəcé yuug bɨ́ é dʉ yigʉla bɔ́ɔ́l búúd nə ndɨ́ yí, gwə́ nə́mə́ wə́ bwə́ bá dʉ yigʉla bɨ́ nə ndɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nəcé jɨ́ wó ŋgə́ mpu dʉ́g ntand shwú jɨ́ mínyɔŋʉ̂ woó jús dɨ́ yí, njɨ wo kú dʉ́g mbwûŋ wɨ́ dwó jús dɨ́ yí? ");
INSERT INTO mcp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ntʉdɛlɛ̂ wó jɨ́ nə ŋkul cɨ nə́ wo yîl mínyɔŋʉ̂ wóó ntand shwú júsʉ́d yɛ́, wɛɛ njúl nə mbwûŋ dwó júsʉ́d? ");
INSERT INTO mcp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yé múúd məkə́ŋ, fwog yîl mbwûŋ wódɨ́ júsʉ́d; ja jɔɔŋgʉ̂ wə́ wó é ka dʉ́g nda wó jɨ́ nə ŋkul yîl mínyɔŋʉ̂ wóó ntand shwú júsʉ́d nə́. ");
INSERT INTO mcp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Kúgá yə ompyə̂ isâ í Zɛmbî, nəcé bwə́ á bá yid zə kwagʉlə bɨ̂. Bɨ kú kʉl óŋkuú ijimə́ í mə́kwóógʉ́ mə́ álal-kus bwə́ dʉ jɔ̂w nə́ pɛ̂rlə yí, bwə́ á bá nyaal byo. ");
INSERT INTO mcp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Gwáámbʉ́gá Zɛmbî, nyə é yə bɨ̂; sɔ̧́gá, nyə e lwó bɨ̂; kudəgá mbɛ̂, nyə é juw. ");
INSERT INTO mcp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nəcé muud mə gwáámb yɛ́, nyə é bii. Muud mə sɔ̧́ yɛ́, nyə é kwey. Múúd mə ká kudə mpumbɛ́, bwə́ juw nyə wə. ");
INSERT INTO mcp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nda bɨ́, mwân mə́ ká gwáámb sɔ́ɔ́ŋgʉ́ bʉlɛ́d, ye sɔ́ɔ́ŋgʉ́ nyə é yə́ nyə kwóógʉ́? ");
INSERT INTO mcp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ŋkí nə́ a gwáámb shû, ye sɔ́ɔ́ŋgʉ́ nyə é yə nyə kuwó nywâ? ");
INSERT INTO mcp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ŋkə́mʉ́sá bɨ̂, tɛɛm bə nda bɨ́ bʉ́sə nə mbíya mílâm nɨ, bɨ mə́ dʉ yə bwân bʉ́n isâ í ányunywaâ. Ŋkəmʉsa nə Sɔ́ɔ́ŋgʉ́ wʉ́n a gwɔ́w, bɨ́ mə́ ká gwáámb nyə sâ ányunywaâ, a yə bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Ságá buud sâ jɛ̂sh bɨ́ mə́ cɛ́ɛ́l nə́ bwə́ sáág bɨ́ yí. Ntɔ́ wə́ *mbwoomb mə́cɛ̧ɛ̧ nə micilyá mí *búúd ɔ́ mícúndə́ mí ŋgə cɨ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Nyíígá mpumbɛ́ ámʉ́mánda dɨ̂, nəcé mpumbɛ́ í kə́ mícúŋ myâ kandʉgə dɨ́ yí wúsə ŋkí bwaag; zhɨɨ́ á wu ŋkí laasʉwo. Bulyálə búúd bwə́ ŋgə́ kə wu wá. ");
INSERT INTO mcp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Njɨ mpumbɛ́ ámʉ́mánda nə zhɨɨ́ ákukwowʉlá, í kənd búúd cʉg á kandʉgə dɨ̂. Buud bwə́ kə́ wu wá, bwə́ ábúlyáyɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Bɨ ɔ káálʉ́gə́ nə *buud ɔ mícúndə́ wâ məshɨɨgâ. Bwə́ dʉ zə nyíi gwooŋg jɨ́nʉ́d, bwə́ njúl nə́ shɛɛ nda incwəmbɛ, í njúl nə́ bʉ́sə ŋkí wagʉwo nda oŋkweny. ");
INSERT INTO mcp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bɨ mə bá dʉ mpu bwo nə kuú njɔɔnd wáŋ. Ye bwə́ dʉ mwáág mə́budə́ ŋgwúdáánzə́ dɨ̂, ŋkí nə́ ifumbí byaag dɨ̂? ");
INSERT INTO mcp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mpugá nə́ fwámɛ́ lɨ́ɨ́ í dʉ wúmə fwámɛ́ íbumə́, lɨ́ɨ́ ábʉ́bɔ̂w í wúmə njɨ ibumə́ í abʉ́bɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Fwámɛ́ lɨ́ɨ́ í cúgɛ́ nə ŋkul wúmə íbumə́ í abʉ́bɔ̂w; lɨ́ɨ́ abʉ́bɔ̂w kú nə́mə́ wúmə fwámɛ́ íbumə́. ");
INSERT INTO mcp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Muud fambə́ mə́ dʉ cal lɨ́ɨ́ jɛ̂sh í ádɛ́ wúmə fwámɛ́ mpúmə́ yí, a wusə gwo kudad. ");
INSERT INTO mcp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bɨ mə bá ka dʉ mpu bwo nə kuú njɔɔnd wáŋ. ");
INSERT INTO mcp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Buud bwə́ ŋgə́ cɨ nə mə nə́: “Yé Cwámba! Yé Cwámba!” ɔ́nɨ, bɛ̂sh dɨ́ Zɛmbî mə bá magʉlə nyə́dɨ́ Faan dɨ́ wá. Njɨ bɔɔŋg bwə́ ŋgə́ cʉgə nda Sɔ́ɔ́ŋgʉ́ wâm jɨ́ gwɔ́w yɛ́ mə́ cɛ́ɛl nə́, bwə́ wə́ á bá magʉlə wá. ");
INSERT INTO mcp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nəcé jwɔ̂w Zɛmbî mə́ bá sámb búúd milə́sʉ́ yí, zhwog buud bwə́ bá cɨ nə mə nə́: “Yé Cwámba! Yé Cwámba! Dʉgɨ́, sə́ á shí cúndə mícúndə́ mí Zɛmbî nə ŋkul nywô. Sə́ yîl mə́jamb nə ŋkul nywô, sə́ sá nə́mə́ zhwog *məshimbá.” ");
INSERT INTO mcp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Njɨ mə bá bɛ̧sa nə bwo nə́ ŋgə́ŋ nə́: “Mə a shígɛ́ bwɛlɛ mpu bɨ̂ buud wâ kú bísh mə́cɛ̧ɛ̧ ɔ́ga, wúgá mə na.”» ");
INSERT INTO mcp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Múúd mə ká gwág lə́sʉ́ mə́ mə́ lás nɨ, a sá nda mə́ ŋgə́ cɨ nə́, a jɨ nda kə́ŋ nyə á shumə njɔ́w kwóógʉ́d gwɔ́w yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ompú bwə́ á nywɔ̧̂, mpʉŋ wɔ́ɔ́s mə́ncúwód, oŋkwɔ̧̂ bwə́ á kuŋg, isâ ínɨ byɛ̂sh dʉ nyífa njɔ́w wɔɔŋgʉ́d, njɨ njɔ́w kú búg, nəcé nyə á shumə wə mə́lal dɨ́, kwóógʉ́d gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Njɨɨ́, múúd mə ká gwág lə́sʉ́ mə́ mə́ lás nɨ, a kú sá nda mə́ ŋgə́ cɨ nə́, a jɨ nda lad nyə á shumə njɔ́w shɛ̧ dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ompú bwə́ á nywɔ̧̂, mpʉŋ wɔ́ɔ́s mə́ncúwód, oŋkwɔ̧̂ bwə́ kuŋg. Isâ ínɨ byɛ̂sh dʉ nyífa njɔ́w wɔɔŋgʉ́d, njɔ́w í mú búg, shugʉla shí nə́ mpuu.» ");
INSERT INTO mcp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ja Yésus mə́ shîn lás yí, ncúlyá buud bwə́ á bə cínɔŋg wá bwə́ mú bul káam mbií nyə á ŋgə jɨ́ɨ́gʉli yí, ");
INSERT INTO mcp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nəcé nyə á ŋgə jɨ́ɨ́gʉli nə kɛ́ɛ́nd, kú bə nda *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ báŋ. ");
INSERT INTO mcp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yésus mú shulə, wú mbʉ́mbʉ́ŋʉ́d, buud bwə́ mú bɛ̧ nyə áncuncuma. ");
INSERT INTO mcp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bwə́ ŋgə́ shulə, wúl zʉ́zaamə́ mú cúwo, shísh wə́ Yésus, zə kúdɔw shí, yə nyə gúmə́. A mú cɨ nə Yésus nə́: «Cwámba, ŋkí wó magʉlə wo je lwag mə, nyúúl bə mə nə́ səndôŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yésus mú sɛ́ɛ́mb mbwə̂, kúnya nə nyə, cɨ nə nyə nə́: «Mə́ magʉlə. Nyúúl í bə́g wo nə́ səndôŋ!» Cé nə cé, zaamə́ í mú shîn wú muud ɛ́nɛ nyúúlʉ́d. Nyúúl í mú bə nyə nə́ səndôŋ. ");
INSERT INTO mcp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yésus mú cɨ nə nɛ́ nə́: «Ci wo kú jaaw múúd sâ í mə́ sɨ̂y yí. Yidagʉ́ kə lwágʉlə fada nda wó músə́ nə́, wo ka wá *mə́túnʉga Moyîz nyə á cilə má. Bwə́ mpúg nə́ wo mú mpwogɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yésus nyə á ka kə wɔ́ɔ́s Kapɛrnawûm. A ká nə́mə́ wɔ́ɔ́s ntʉ́nɨ, wúl lúlúú á izɨmbɨ təd í mú zə tɛ́ɛ́g nyə məbwə̂, ");
INSERT INTO mcp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nə́: «Yé Cwámba, sɔ́ɔl məsáal waamə́ mbwug kə́ga njɔ́w; a músə mbúmbwúgʉ́, a ŋgə bul jug.» ");
INSERT INTO mcp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yésus músə cɨ nə nɛ́ nə́: «Mə é kə lwag nyə.» ");
INSERT INTO mcp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Njɨ lúlúú á ízɨmbɨ mú bɛ̧sa nə́: «Cwámba, mə ampíyáyɛ́ nə́ wo nyííg mə́dɨ́ njɔ́w. Jeg lás lásʉ́g, sɔ́ɔl məsáal waamə́ yálʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nəcé mə jɨ nə omása bwə́ ŋgə́ jwú nə mə wá. Mə jɨ nə́mə́ nə ozɨmbɨ mə́ ŋgə́ jwú nə ndɨ́ wá. Nyɔɔŋg yɛ̂sh mə́ é cɨ nə́ a kyéyʉg yɛ́, a kə; nyɔɔŋg mə́ é cɨ nə́ a zə́g yɛ́, a zə. Mə́ ká cɨ nə lwaá dâm nə́ í sáág gúl sâ, í sá gwo.» ");
INSERT INTO mcp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja Yésus mə́ gwág ntʉ́nɨ yí, a mú bul bɨ̂. Nyə nə buud bwə́ á ŋgə bɛ̧ nyə wá nə́: «Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, mə afwóyɛ́ bwɛlɛ dʉ́g múúd nə fwámɛ́ búgə́ nda nyíga, tɛɛm bə kúl búúd *Izʉrəyɛ̂l dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mə mpú jaaw bɨ́ nə́ zhwog ikûl í búúd í bá zhu kɔ́ɔ́mb jwɔ̂w í dʉ cúwo yí, zhu kɔ́ɔ́mb í dʉ jímə yí, bwə́ zə́ sɛɛŋgya nə impáámbə́ bísʉ́ *Abʉraham nə *Izaag, nə *Yákwab Faan á gwɔ́wʉ́d, bə́nɔ́ŋ bwə́ mú də dína. ");
INSERT INTO mcp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Njɨ buud bwə́ á jəla nə bə nə ŋkɔw Faan a gwɔ́w dɨ́ wá, bwə́ bá wusɔw yídʉ́gʉ́d tɔ́ɔ́n. Bwə́ bá bə cínɔŋg, njɨ bwə́ ŋgə́ bwam nə məyə̂.» ");
INSERT INTO mcp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yésus músə cɨ nə lúlúú á ízɨmbɨ ɛ́nɛ nə́: «Wɛɛ kag njɔ́w. Í bə́g nda wó ŋgə́ *búgʉla nə́.» Nə́mə́ baan dɔɔŋgʉ̂, sɔ́ɔl məsáal mú yâl. ");
INSERT INTO mcp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yésus mú ka zə kə Pyɛ̂r dɨ́ njɔ́w. A mú kə kwey nə́ Pyɛ̂r cii yé á mudá mbwug shí, ayɔ̂ŋ nə yɔ̂ŋ mə́ bií nyə. ");
INSERT INTO mcp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yésus mú kúnya nə nyə mbwə́d. Ayɔ̂ŋ nə yɔ̂ŋ mú shîn nyə. A mú wɔɔl, a tɛ́ɛ́d ntâg sɛ́yʉ́lə nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mpwó-kugʉ́ shí, buud bwə́ mú zə nə zhwog mimbə̂l mí mə́jamb. Yésus mú ŋgə yîl bwo bɔ́w-bɔ̂w míshíshim myɔɔŋgʉ́ njɨ nə iciyá yâ mpu, a shîn nə́mə́ lwag míl mímbə̂l myɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nyə á ŋgə cʉg buud ntɔ́ shú nə́ cúndə́ mə́ Zɛmbî Izayí nyə á cúndə yí, í bwə́mag. Izayí nyə á cɨ nə́: «Nyə á cʉg buud ɔ́ íjâm, a yîl sə́ ofimâl ɔ́ mə́bwas.» ");
INSERT INTO mcp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dʉ́gʉ́lə Yésus nyə á dʉ́g buud bwə́ á lyɛ̧ nyə nə́ kɛsh yí, a mú cɨ nə *ompwíín bɛ́ nə́ bə́nɔ́ŋ bwə́ lɨ́ɨ́nág mâŋ kə́ faŋwíny. ");
INSERT INTO mcp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ŋgwɔ́l Yɨ́ɨ́gʉli məcɛ̧ɛ̧ mú ntâg shísh zə cɨ nə nɛ́ nə́: «Yé Yɨ́ɨ́gʉli, mə zə́ bá dʉ bɛ̧ wo kʉ́l jɛ̂sh wó bá dʉ kə yí.» ");
INSERT INTO mcp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yésus mú cɨ nə nyə nə́: «Ontɔ̧́ bɨ́ nə miku, inunú nə maagɛ, njɨ *Mwân mə Múúd cugɛ́ nə ŋkúmba kʉ́l á dʉ́g já yí.» ");
INSERT INTO mcp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ŋgwɔ́l *mpwíín mə́ Yésus mú cɨ nə nɛ́ nə́: «Cwámba, fwog bɨ́d mə, mə kə́g dʉl sɔ́ɔ́ŋgʉ́ waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yésus mú yidá bɛ̧sa nə nyə nə́: «Wɛɛ bɛ̧g mə. Bɨ́dʉ́g mímbimbə mí dʉ́lʉg mimbimbə myáŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yésus mú kə kəwa byɔ́ɔ́lʉ́d, ompwíín bɛ́ bwə́ mú bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nə́ ndɛɛ́ ŋkwɔ̧̂ mú zə kuŋg mâŋ nə ŋkulû, ikwɔ̧́ dʉ bád kə gwɔ̂w, dʉ shwɨy byɔ́ɔ́lʉ́d, njɨ Yésus njúl gwə́d. ");
INSERT INTO mcp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ntɔ́, ompwíín bwə́ mú kə juumʉshi nyə, bwə́ nə nɛ́ nə́: «Cʉgʉg sə̂, yé Cwámba! Sə́ wál zə yə.» ");
INSERT INTO mcp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yésus nə bwo nə́: «Wáyɛ́ mbií ífwaas nɨ? Búgə́ jɨ́n í bul ná tag ɛ́!» A músə tɔ̂w, ŋkáánd nə ŋkwɔ̧̂ nə mâŋ, byɛ̂sh í mú salʉwo nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Buud bɔɔŋgʉ́ bwə́ mú bul bɨ̂. Bwə́ nə́: «Wáyɛ́ mbií muud ga! Tɔɔ ŋkwɔ̧̂ tɔɔ mâŋ í bə́lɛ́ sá nyə məgwág ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ja Yésus mə́ shîn lɨ́ɨ́na mâŋ, jé shí á Gadarɛ̂n yí, buud obá bwə́ mú cúwo baŋ mə́shwoŋ, məjamb mə́ ŋgə́ lwáfʉlə bwo, bwə́ mú zə́ bwəma nə nyə. Buud bɔɔŋgʉ́ bwə́ á dʉ bul wagʉwo. Kú ná nə muud nyə a jísɔw nə́ a cɔ̧́ kʉ́l bwə́ á dʉ bə yí. ");
INSERT INTO mcp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bwə́ mú zə nə oŋkwiimbyê wə́ Yésus, bwə́ ŋgə́ cɨ nə́: «Shé bâŋ nə inɛ́y, yé *Mwân mə́ Zɛmbî? Wo wál lɛɛl zə tə̂l sə́ cwúnd dɨ́ fwála dɔɔŋgʉ́ kú fwo wɔ́ɔ́s ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, məma sɔɔnz óŋkuú í á bə fwámɛ́ cícé nə bwo, í ŋgə́ də. ");
INSERT INTO mcp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Məjamb mə́ mú ka tɛ́ɛ́g Yésus məbwə̂ nə́: «Ŋkí wo yîl sə̂ wa búúd ɔ́ga dɨ́, kəndʉ́g sə́ nûŋ óŋkuúd.» ");
INSERT INTO mcp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yésus músə cɨ nə mwo nə́: «Kəgâ!» Məjamb mə́ mú wú búúd ɔ́nɨ mə́nyúúlʉ́d, kə nyíi óŋkuúd. Sɔɔnz óŋkuú nɨ jɛ̂sh mú bumb nə mikʉ́lə́, wú kʉ́l í á bə mbʉ́mbʉ́ŋ dɨ́ yí, kə juwa mâŋ, bɛ̂sh bwə́ mú ŋgul məjúwó, fudə. ");
INSERT INTO mcp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nə́ ndɛɛ́, buud bwə́ á ŋgə baagʉlə oŋkuú wá, bwə́ mú wɛɛnzh kə kwáádə́, kə́ bwiiŋg búúd sá í ámə sɨ̂y nə oŋkuú yí. Bwə́ bwiiŋg nə́mə́ lâŋ búúd bwə́ á bə nə məjamb wá. ");
INSERT INTO mcp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Buud ɔ ŋgwə́la bɛ̂sh bwə́ mú tɨ̂, kə bwəma nə Yésus. Ja bwə́ mə́ dʉ́g nyə yí, bwə́ mú tɛ́ɛ́g nyə məbwə̂ nə́ a wúg bwə́dɨ́ lɔɔmʉd. ");
INSERT INTO mcp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ntɔ́ Yésus mú kə kəwa byɔ́ɔ́lʉ́d, nyiŋgə lɨ́ɨ́na mâŋ, kə nyə́dɨ́ ŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A ŋgə́ nə́mə́ jé, buud bwə́ mú zə nyə́dɨ́, bwə́ ŋgə́ ŋkɛ̂ny mbúmbwúgʉ́ táádə́d. Yésus mú dʉ́g nə́ buud bɔɔŋgʉ́ bʉ́sə nə fwámɛ́ búgə́, a mú cɨ nə mbúmbwúgʉ́ nə́: «Mwân waam! Səlʉg lâm shí! Mə mə́ juu wo nə *misə́m myô.» ");
INSERT INTO mcp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bɔ́ɔ́l *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «Muud ɛ́ga ŋgə *lás nə Zɛmbî bwaasʉ́lə mpu.» ");
INSERT INTO mcp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yésus músə mpu sâ bwə́ á ŋgə tə́dʉga yí, a mú lás nə bwo nə́: «Nəcé jɨ́ bɨ́ mə́ bɔ̂w mitə́dʉ́gá ntʉ́nɨ yí? ");
INSERT INTO mcp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Jɨ́ í búl bə kúnə́-kúnə? Ye cɨ́lə nə muud nə́: “Mə mə́ juu wo nə misə́m myô”, ye nə́: “Wɔɔlʉ́g, wo kyéyʉg?” ");
INSERT INTO mcp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mə́ ka cɛɛl nə́ bɨ mpúg nə́ *Mwân mə Múúd jɨ nə ŋkul ijwûga nə́ a juu búúd nə misə́m myáŋ.» Ntɔ́, a mú yid wə́ mbúmbwúgʉ́. Nyə nə́: «Wɔɔlʉ́g, wo ŋkɛ́nyʉ́g táádə́ gwô, wo nyíŋgəg kə njɔ́w.» ");
INSERT INTO mcp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Muud wɔɔŋgʉ̂ mú wɔɔl, kyey kə njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ja áncuncuma buud mə́ dʉ́g sɔ́ɔ́lʉ́gʉ́ nɨ yí, bwə́ mú gwág íkukwɛndɛ, bwə́ mú ságʉsə Zɛmbî, nəcé a yə́lə búúd mbií ŋkûl ijwûga nyɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yésus mú wú na, kyey. A ŋgə́ cɔ̧́ kʉ́l búúd bwə́ dʉ jə́na tóya yí, a mú dʉ́g ŋgwɔ́l múúd njúl cínɔŋg shí. Muud wɔɔŋgʉ̂ nyə á bə nə jínə́ nə́ Matiyô. Yésus mú cɨ nə nyə nə́: «Bɛ̧g mə.» A mú tɔ̂w, bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Í á ka zə bə nə́, Yésus njúl njɔ́w a ŋgə́ də, zhwog oŋwɛnyɛ ɔ tóya nə bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́bɔ̂w bwə́ mú nə́mə́ zə, bə́nɔ̂ŋ nyə nə *ompwíín bɛ́ zə də. ");
INSERT INTO mcp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ja *Ofarizyɛ̂ŋ bwə́ á ka dʉ́g ntʉ́nɨ yí, bwə́ á cɨ nə ompwíín ɔ́ Yésus nə́: «Nəcé jɨ́ Yɨ́ɨ́gʉli wʉ́n ŋgə́ bə́lɛ də nə oŋwɛnyɛ ɔ tóya nə bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́bɔ̂w yí?» ");
INSERT INTO mcp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yésus mú gwág sâ bwə́ á ŋgə́ cɨ yí, nyə nə bwo nə́: «Mikanz dɨ́ mí dʉ jɨɨ jwɔ́wʉda, í dʉ bə mímbə̂l. ");
INSERT INTO mcp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mpugá tə́dʉga sâ jɨ́ cilyá Kálaad Zɛmbî dɨ́ yí nə́: “Mə́ bul jɨɨ nə́ buud bwə́ gwágʉ́g buud cɛy lámʉ́d, ntɔ̧ nə́ bwə́ dʉ́g sâ mə *mətúnʉga.” Ntɔ́ jɨ nə́ mə a shígɛ́ zə jɔ̂w ótʉ́təlí ɔ búúd. Mə á yida zə jɔ̂w osɔ́ɔl ɔ mə́bɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","*Ompwíín ɔ́ Yuánɛs Nduu-buud bwə́ á ka zə wə́ Yésus zə jî nyə nə́: «Sə́nɔ́ŋ *Ofarizyɛ̂ŋ sə́ mə́ dʉ ci idʉ̂w yə́lə Zɛmbî gúmə́ njɨ ompwíín bwô bâŋ kú ci. Jɨ́ í sá ntɔ́?» ");
INSERT INTO mcp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yésus mú bɛ̧sa nə bwo nə́: «Ja múúd mə́ ŋwa bâ yí, a tə̂l zâŋ, a jɔ̂w óshwə́ bɛ́; ye oshwə́ bɛ́ bwə́ yidá zə nə məcɛy lámʉ́d bə́nɔ̂ŋ muud bâ bwə́ njúl kʉ́l ŋgwúd? Mbɔ̂! Njɨ mɔ́ɔ́l mwɔ̂w mə́ ŋgə zə, bwə́ bá yîl bwo muud bâ yí. Mwɔ̂w mɔɔŋgʉ́ dɨ́ wə́ óshwə́ bɛ́ bwə́ ka bá ci ídʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mpugá nə́ bwə́ ádɛ́ ŋwa kʉ́l káándə́ ágúgwáan kə wá bágá bwoodʉ́ káándə́d. Nəcé bágá dɔɔŋg í ká juli, í tʉ̂w, í yida bweeg luun lʉ káándə́. ");
INSERT INTO mcp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ntɔ́ nə́mə́, bwə́ ádɛ́ ŋwa wáan ágúgwáan kə wá bwoodʉ́ lɛnyad; lɛnya í é bá nyɛy, wáan shwɨy shí, lɛnya ntáma. Bwə́ dʉ wá wáan ágúgwáan ílɛnya í agúgwáanʉd. Nə́ ndɛɛ́, nə lɛnya nə məlwəg byɛ̂sh í mú cʉgə.» ");
INSERT INTO mcp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yésus ŋgə́ ná lás ntʉ́nɨ, ŋgwɔ́l njwû *Oyúdɛn mú jê. A mú kúdɔw shí, yə Yésus gúmə́. Nyə nə nɛ́ nə́: «Sʉ́sás jâm mə́ kúnɔw yə. Mə́ cɛɛl nə́ wo zə́g kə kɛɛl nyə mbwə̂, a cʉ́gəg.» ");
INSERT INTO mcp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yésus mú tɔ̂w shí bə́nɔ̂ŋ ompwíín bɛ́ bwə́ músə bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bwə́ ŋgə́ ná kə, ŋgwɔ́l múdá mú lɛɛl bɛ̧ nyə mpʉ́sə. Mudá məcií mə́ á dʉ wú nyə nyúúlʉ́d tɛ́ mímbú wûm nə mímbá. Mudá ɛ́nɛ mú shísh Yésus mpʉ́sə kwoŋ, kúnya nə nyə lwə́ lʉ́ káándə́, ");
INSERT INTO mcp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","a ŋgə́ tə́dʉga nə́: «Mə́ ká jísɔw kúnya nə káándə́ mə́ Yésus, mə e yâl.» ");
INSERT INTO mcp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yésus mú yid mpʉ́sə, dʉ́g mudá ɛ́nɛ, nyə nə nɛ́ nə́: «Shilə wâm, səlʉg lâm shí. Wo mə́ *dʉ́g cʉg nəcé búgə́ gwô.» Mudá mú yâl nə́mə́ cé nə cé. ");
INSERT INTO mcp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yésus mú ka kə nə́ ndɛɛ́, kə nyíi njwû dɨ́ njɔ́w. A mú kwey, buud bwə́ ŋgə́ lwɔ̧́ milaag, bwo ŋgə́ sá saagʉwo mímbií mímbií. ");
INSERT INTO mcp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yésus mú ŋkáánd nə buud nə́ bwə́ cúwóg tɔ́ɔ́n. Nyə nə bwo nə́: «Sʉ́sás ga í afwóyɛ́ yə, á yidá bə gwə́d.» Bwə́ mú yida ŋgə cágʉlə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ja bwə́ mə́ shîn wéésh buud ɔ́nɨ tɔ́ɔ́n yí, Yésus mú nyíi fúm, a mú bii sʉ́sás mbwə́d, sʉ́sás í mú wɔɔl. ");
INSERT INTO mcp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ntɔ́, lâŋ nɨ í mú zə jwɔ̧ shí nyɔɔŋg nyɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yésus mú kyey. A ŋgə́ kə ntʉ́nɨ, wəancím-ncîm óbá bwə́ mú bɛ̧ nyə nə oŋkwiimbyê. Bwə́ nə́: «Yé Mwân mə́ *Dávid, bwɨ́ɨ́gʉ́g sə́ nə́ ŋkwoŋʉ́!» ");
INSERT INTO mcp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ntɔ́, Yésus mú kə jé njɔ́w, wəancím-ncîm bwə́ mú shísh nyə́dɨ́. Yésus mú jí bwo nə́: «Ye bɨ́ ŋgə *búgʉla nə́ mə jɨ nə ŋkul sá ntɔ́?» Bwə́ nə́: «Haaw, yé Cwámba, sə́ mə́ búgʉla.» ");
INSERT INTO mcp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yésus músə ka kúnya nə bwo míshʉ́d. Nyə nə bwo nə́: «Í bə́g nda bɨ́ ŋgə́ búgʉla nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mísh mə́ músə bâŋ bwo. Yésus mú mpu báásʉlə bwo nə́: «Mpugá gwágʉlə. Bɨ kú jaaw tɔɔ muud sâ í mə́ bə ga.» ");
INSERT INTO mcp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Njɨ bwə́ bâŋ, wúlə bwə́ á wú cínɔŋg yí, bwə́ á shwal kə ŋgə báŋgʉla nə lâŋ wɔɔŋgʉ̂ kʉ́kʉ́l jɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nə́ ndɛɛ́ cúwólə bwə́ á cúwo tɔ́ɔ́n yí, bɔ́ɔ́l búúd bwə́ mú zə nə wúl fífî wə́ Yésus. Jamb í á wá nyə mə́ŋkədad nə́ a bə́g fífî. ");
INSERT INTO mcp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yésus músə yîl muud ɛ́nɛ jamb, a mú tɛ́ɛ́d lásʉ́lə. Buud bwə́ á bə cínɔŋg áncuncuma wá, bwə́ mú bul káam nə́: «Sə́ a bwɛ́lɛ́ dʉ́g mbií sâ ga shí *Izʉrəyɛ̂l.» ");
INSERT INTO mcp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","*Ofarizyɛ̂ŋ bâŋ, bwə́ mú cɨ nə́: «A ŋgə yîl məjamb nə ŋkul mə́ njwû məjamb.» ");
INSERT INTO mcp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ntɔ́ Yésus nyə á ŋgə kə míŋgwə́la miŋgwə́la, nə mə́kwáádə́ məkwáádə́. Nyə á ŋgə jɨ́ɨ́gʉli buud *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ́, á ŋgə́ cúndə Jɔ̧jɔ̧ Kɛ́ɛ́l á Faan mə́ Zɛmbî, a ŋgə́ nə́mə́ lwag buud məbwas mímbií myɛ̂sh, tɔɔ ijâm. ");
INSERT INTO mcp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yésus nyə á dʉ ŋgə dʉ́g buud bɛ̂sh nyə á dʉ bwəma nə bwo wá. A mú gwág bwo cɛy lámʉ́d nə dʉ́gʉ́lə nə́ bwə́ á ŋgə cʉgə mə́ntágʉla dɨ́, bwə́ mə́ shîn nə́mə́ tag nda sɔɔnz íncwəmbɛ í cúgɛ́ nə mbaagʉlə yí. ");
INSERT INTO mcp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ntɔ́ nyə á cɨ nə *ompwíín bɛ́ nə́: «Dʉgá, idʉ̂w í mə́ tɨ́ fambə́ məŋkund məŋkund, njɨ buud bwə́ kə́ saag wá bʉ́sə cíg-cíg. ");
INSERT INTO mcp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ntɔ́ wə́ mə́ cɨ́ náaá: jə́gʉlagá nə amə́dɨ́ fambə́ nə́ a ntɨ́ɨ́g buud, bwə́ kə́g saag.» ");
INSERT INTO mcp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ntɔ́ Yésus mú jɔ̂w *ómpwíín wûm nə óbá bɛ́. A mú yə́ bwo ŋkul á dʉ́lə yîl búúd bɔ́w-bɔ̂w míshíshim, lwag mə́bwas mímbií myɛ̂sh, tɔɔ ijâm. ");
INSERT INTO mcp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","*Buud ɔ lwámá wûm nə óbá Yésus nyə á jɔ̂w wá, mínə́ máŋ wə́ mə́ga: tɛ́ɛ́d nə Shímun bwə́ á dʉ jɔ̂w nə́ Pyɛ̂r yɛ́, kala nə mínyɔŋʉ̂ yé Andrê; zə kɛɛl Zhâk bá mínyɔŋʉ̂ yé Yuánɛs bwân ɔ́ Zhébedé. ");
INSERT INTO mcp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","A jɔ̂w nə́mə́ Fílíp bá Batəlʉmî nə Tómas bá Matiyô ŋwɛnyɛ tóya. A jɔ̂w nə́mə́ Zhâk, Mwân mə Alfê bá Tadê, ");
INSERT INTO mcp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nə Shímun kambʉlɛ lɔɔm bá Yúdas Iskariyôt, muud nyə á kusha nə Yésus yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nə́ ndɛɛ́ Yésus mú kənd búúd wûm nə óbá ɔ́nɨ lwámád, a mə́ fwo shîn cwîny bwo nə́: «Ja bɨ́ mə́ kə̂ yí, bɨ kú kə ikúl í cúgɛ́ *Oyúdɛn yííd. Bɨ kú kə míŋgwə́la mí búúd ɔ́ Samaríya. ");
INSERT INTO mcp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yidagá kə búúd ɔ́ *Izʉrəyɛ̂l dɨ́, bwə́ mə́ jág zhɨ́ɨ́ nda íncwəmbɛ bɨ́ kú nə mbaagʉlə yí. ");
INSERT INTO mcp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ja bɨ́ ŋgə́ kə yí, bɨ ɔ kə́ ŋgə cúndə nə́ Faan mə́ Zɛmbî mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lwagʉgá mimbə̂l, bɨ́ gwúmʉshi mimbimbə, bɨ́ lwag nə́mə́ mízʉ́zaamə́, bɨ́ yîl búúd məjamb. Bɨ mə́ ŋwa ŋkul ga ashwâ, kəgá nə́mə́ sɛ̂y nə ndɨ̂ ashwâ. ");
INSERT INTO mcp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Muud kú kə nə *mwaanɛ̂ bwúgʉ́d, tɔɔ or, tɔɔ wúl mbií mwaanɛ̂ wɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Muud kú ŋwa baamʉtálá, ŋkí ishimí íbá, ŋkí bɔ́ɔ́l ósílʉ́faas, ŋkí wagatîg, nəcé muud ŋgə́ sɛ̂y yɛ́ mə́ jəlá nə yéyɔw ídʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ja bɨ́ mə́ jé wúl ŋgwə́la ŋkí wúl lɔɔm dɨ́ yí, bɨ́ fwó sɔ̧́ ŋkí bɨ bɨ́ nə ŋkul kwey múúd jɨ́ nə lâm mə́ báágʉ́lə́ bɨ̂, bɨ ɔ́ ji nyə́dɨ́ kə wɔ́ɔ́s jwɔ̂w bɨ́ mə́ bá cɔ̧́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Njɔ́w wɛ̂sh bɨ́ mə́ nyíi yí, bɨ ɔ bə́dá nə́: “Zɛmbî sáág nə́ bɨ bə́g nə́ shɛɛ.” ");
INSERT INTO mcp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ŋkí buud ɔ njɔ́w wɔɔŋgʉ̂, bwə́ lə́g bɨ́, Zɛmbî bə́lɛ sá nə́ bwə́ bə́g nə́ shɛɛ. Njɨ ŋkí bwə́ bə́ kú lə́g bɨ́, Zɛmbî kú nə́mə́ sá nə́ bwə́ bə́g nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Búud ɔ́ wúl njɔ́w ŋkí wúl ŋgwə́la bwə́ ká bə kú lə́g bɨ́, kú gwágʉlə kɛ́ɛl dʉ́n, ja bɨ́ mə́ wú cínɔŋg yí, bɨ́ kudə fumbyá í ámə nada bɨ́ mə́kuú dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, jwɔ̂w Zɛmbî mə bá zə sámb búúd milə́sʉ́ yí, a bá jagʉlə búúd ɔ Sódom nə Gomor ntɔ̧ ŋgwə́la wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Owɛy, mə mə́ kənd bɨ́ nda íncwəmbɛ mpə́dʉ́gá oŋkweny. Bɨ mə́ jəlá nə kɛ̧̂ nda onywâ, bɨ́ kə nə tə́dʉ́gá ŋgwúd nda məfaf. ");
INSERT INTO mcp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dʉgá ji nə buud kuú kalə́; bwə́ bá dʉ kusha nə bɨ́ mə́bwə́ mə́ osémbye ɔ́ mílə́sʉ́d, bwə́ dʉ fyámʉsə bɨ́ milwóŋ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bɨ mə bá dʉ kaad mísh mə́ búúd ɔ́ anʉ́nɨ̂ nə ojwû ɔ́ lɔɔm dɨ́ nə́, nə́ bɨ kə́g bwaagʉlə sâ bɨ́ mə́ mpú shú jínə́ dâm yí, bɨ́ bwaagʉlə nə́mə́ ikúl í cúgɛ́ Oyúdɛn yí. ");
INSERT INTO mcp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ja bwə́ bá dʉ kusha nə bɨ́ yí, bɨ kú bá dʉ yágʉwo mbií bɨ́ mə́ bá dʉ kaad yí, kú yágʉwo íciyá í kɔɔd. Iciyá í bá nə́mə́ dʉ jé bɨ́ cé jɔɔŋgʉ́d, ");
INSERT INTO mcp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","nəcé bɨ dɨ́ mə́ bá dʉ lás, Shíshim mə́ Sɔ́ɔ́ŋgʉ́ wʉ́n Zɛmbî wə́ mə́ bá lás mímpu mínʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Mínyɔŋʉ̂ mə́ bá kusha nə mínyɔŋʉ̂ yé nə́ bwə́ kə́g gwú nyə. Sɔ́ɔ́ŋgʉ́ mə bá kusha nə mwân; bwân bwə́ lúmbʉli nə obyɔ̂l, ŋgə gwú bwo. ");
INSERT INTO mcp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Buud bɛ̂sh bwə́ bá mpii bɨ́ nəcé jínə́ dâm. Njɨ, muud mə bá jísɔw kə wɔ́ɔ́s mə́shínéd yɛ́, a bá cʉgə.» ");
INSERT INTO mcp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bwə́ ká lwágʉlə bɨ́ cúwʉ́lí wúl ŋgwə́la dɨ́, fúndə́gá, bɨ́ kə ŋgwə́la shúsʉ́d. Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, *Mwân mə Múúd mə bá nyiŋgə zə, bɨ njúl kú fwo shîn jaand míŋgwə́la myâ *Izʉrəyɛ̂l myɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«*Mpwíín nyə ádɛ́ bwɛlɛ ntɔ̧ yɨ́ɨ́gʉli, lwaá kú ntɔ̧ mása. ");
INSERT INTO mcp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Buud bwə́ dʉ dʉ́g *ompwíín nə́mə́ nda bwə́ dʉ́g yɨ́ɨ́gʉli nə́, bwə́ dʉ́g nə́mə́ lwaá nda bwə́ dʉ́g mása yé nə́. Ŋkə́mʉ́sá bwə́ lwîy sɔ́ɔ́ŋgʉ́ njɔ́w nə́ Bɛlʉzebul, ŋkəmʉsa nə bwân.» ");
INSERT INTO mcp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Bɨ kú dʉ fúndə bwo; nəcé kú nə sâ á mbúdʉ́lá í bá bwên kú bʉ́gʉli, ŋkí sâ á *ndímba í bwên kú mpûy. ");
INSERT INTO mcp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sâ mə́ jaaw bɨ́ yídʉ́gʉ́d yí, kəgá lás gwo mə́ŋkɛnyad. Sâ mə́ nyímbʉ́lá nə bɨ́ lwə́d yí, kəgá ŋgə cúndə gwo íkwalʉ́minúd. ");
INSERT INTO mcp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kúgá dʉ fúndə búúd bɨ́ nə ŋkul gwú njɨ nyúul, njɨ kú nə ŋkul gwú *jîm wá. Yidagá fúndə Zɛmbî. Nyə wə́ jɨ́ nə ŋkul gwɨ́ɨ́lya múúd ncindî, nə nyúúl nə jîm, a wusə byɛ̂sh kuda á kandʉgəd. ");
INSERT INTO mcp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ŋgaá nə́ bwə́ dʉ kusha mímbá-kwáádə́ mímbá sʉsáŋ *mwaanɛ̂ ŋgwúd. Tɛɛm bə ntɔ́ mbá-kwáádə́ ŋgwúd cúgɛ́ nə ŋkul kud shí, Sɔ́ɔ́ŋgʉ́ wʉ́n kú fwo magʉlə. ");
INSERT INTO mcp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bɨ bâŋ ntâg ɨɨ́, Zɛmbî mə mpú bímbí lʉ́ íntand í shilú bísə́ bɨ́ mílúúd yí. ");
INSERT INTO mcp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nə́ ndɛɛ́, kúgá dʉ fúndə. Mpugá nə́ bɨ́ mə́ cɛy Zɛmbî lámʉ́d cɔ̧́ mimbá-kwáádə́ ŋkí bulya. ");
INSERT INTO mcp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Muud yɛ̂sh mə mágʉ́lə́ mə mísh mə́ búúd dɨ́ yɛ́, mə é magʉlə nə́mə́ nyə mísh mə́ Dâ jɨ́ gwɔ́w yɛ́d. ");
INSERT INTO mcp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Njɨ muud mə kɨ́ɨ́lyá mə mísh mə́ búúd dɨ́ yɛ́, mə́ é kɨ́ɨ́lya nə́mə́ nyə mísh mə́ Dâ jɨ́ gwɔ́w yɛ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Bɨ kú ŋgə tə́dʉga nə́ mə mə́ zə sá nə́ buud bwə́ cʉ́gəg nə́ shɛɛ shí gaád. Mbɔ̂! Mə azə́yɛ́ sá ntɔ́. Mə mə́ yida zə nə dɔɔmb. ");
INSERT INTO mcp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mə mə́ zə wá ífʉmʉga mínjɔ́w mí búúdʉd, mwán nyə é lúmbʉli nə sɔ́ɔ́ŋgʉ́, sás lúmbʉli nə nyɔɔŋgʉ́, cɔ́ɔl lúmbʉli nə mpɔ́ɔ́mbʉ́lú. ");
INSERT INTO mcp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nə́ ndɛɛ́, buud ɔ njɔ́w mə́ múúd ɔ bwə́ bá lúmbʉli nə muud. ");
INSERT INTO mcp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Múúd mə cɛ́ɛ́l sɔ́ɔ́ŋgʉ́ ŋkí nyɔɔŋgʉ́ cɔ̧́ mə yɛ́, a cúgɛ́ nə ŋkul bə *mpwíín waamə̂. Nyɔɔŋg mə cɛ́ɛ́l ncwə́má dɛ́ ŋkí sás dɛ́ cɔ̧́ mə yɛ́, a cúgɛ́ nə ŋkul bə mpwíín waamə̂. ");
INSERT INTO mcp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Múúd mə ká bə kú ŋkɛ̂ny kwolós jé bɛ̧ mə, a cúgɛ́ nə ŋkul bə mpwíín waamə̂. ");
INSERT INTO mcp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Muud mə sɔ̧́ nə́ a kaambʉlə nə cʉg jé yɛ́, a jímbal gwo. Nyɔɔŋg mə jímbál cʉg jé nəcé mə yɛ́, a mə́ yidá kaambʉlə nə gwo.» ");
INSERT INTO mcp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Muud mə lə́g bɨ́ yɛ́ mə́ lə́g mə. Muud mə lə́g ntâg mə yɛ́ mə́ lə́g múúd nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Múúd mə ká lə́g *múúd micúndə́ mə́ Zɛmbî nəcé mpǔlə nə́ muud micúndə́, muud wɔɔŋgʉ̂ mə ŋwa myə́na mí jə́lá nə búúd ɔ mícúndə́ myá. Nyɔɔŋg mə lə́g múúd jɨ́ tʉ́təlí mísh mə́ Zɛmbî dɨ́ yɛ́ nəcé mpǔlə nə́ tʉ́təlí muud ɨɨ́, nyâŋ ŋwa myə́na mí jə́lá nə otʉ́təlí ɔ́ búúd myá. ");
INSERT INTO mcp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Muud mə bá yána tɔɔ njɨ láá mə́júwó mə́tálá ŋgwûd, ŋgulal ŋgwɔ́l zhizhe muud ɛ́ga nəcé bə́lə *mpwíín waamə́ yɛ́, bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, muud wɔɔŋgʉ̂ nyə abʉ́lɛ shúb myə́na myâ cínɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yésus mə́ shîn cwîny *ompwíín wûm nə óbá bɛ́ ntʉ́nɨ. A músə kyey, kə ŋgə yə buud minjɨ́ɨ́gʉ́lá, ŋgə cúndə bwə́dɨ́ míŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ja Yuánɛs Nduu-buud nyə á bə mímbwug dɨ́ yí, nyə a gwág misɔ́ɔ́lʉ́gʉ́ *Krîst nyə á ŋgə sá myá. A mú kənd bɔ́ɔ́l ómpwíín bɛ́ nə́ bwə́ kə́g jî Yésus nə́: ");
INSERT INTO mcp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Ye wo wə́ muud sə́ ŋgə́ bwánd nə́ a bá zə yɛ́? Ye sə́ kwóg ná bwánd íshús?» ");
INSERT INTO mcp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yésus mú bɛ̧sa nə bwo nə́: «Kəgá jaaw Yuánɛs sâ bɨ́ mə́ gwág yí nə sâ bɨ́ mə́ dʉ́g yí. ");
INSERT INTO mcp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wəancím-ncîm bwə́ ŋgə mpu dʉ́gya; mimbúmbwúgʉ́ mí ŋgə́ kyey tʉ́təlí, mizʉ́zaamə́ mí ŋgə yâl, wəakúmə́lwə̂ bwə́ ŋgə mpú gwág, mimbimbə mí ŋgə gwûm, iŋkúŋkwóŋʉ́lə í búúd í mú ŋgə gwág Jɔ̧jɔ̧ Kɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Muud nyə́ é bə kú bwəma nə bɔɔgʉ́ mə́dɨ́ yɛ́, nywáá mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ja ompwíín ɔ́ Yuánɛs bwə́ mə́ nyiŋgə yí, Yésus mú zə lésha nə buud bwə́ á bə cínɔŋg áncuncuma wá; a mú cɨ nə bwo shú mə́ Yuánɛs nə́: «Ja bɨ́ á dʉ kə shí a shwééshá dɨ́ yí, bɨ́ á dʉ kə dʉ́g jɨ́? Ye gúl ká í dʉ́gə́ ntʉ̂ŋ nə fʉfə́? ");
INSERT INTO mcp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ŋkí í á shígɛ́ bə ntɔ́, bɨ́ á dʉ kə dʉ́g jɨ? Ye ŋgwɔ́l múud dʉ́gə́ bwáád íjimə́ í mímbwéédí? Mbɔ̂, buud bwə́ dʉ́ bwáád íjimə́ í mímbwéédí wá bwə́ dʉ bə mínjɔ́w mí ójwú-buudʉd. ");
INSERT INTO mcp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ká bɨ á dʉ kə dʉ́g jɨ? Ye *muud micúndə́ mə́ Zɛmbî? Haaw, mə́ jaaw bɨ́ nə́ nyɔɔŋg bɨ́ á kə dʉ dʉ́g yɛ́ mə́ ntɔ̧ ŋkwóŋ múúd micúndə́ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nəcé nyə wə́ Zɛmbî nyə á cɨ nda jísə́ cilyá nyə́dɨ́ Kálaad dɨ́ nə́, nə́: “Dʉgɨ́! Mɛɛ mə zə́ kənd mbwiiŋgyɛ lâŋ waamə́ nə́ a kə́g wo shwóg kə kwambʉlə wo zhɨɨ́.”» ");
INSERT INTO mcp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yésus mú nyiŋgə cɨ nə́: «Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, mpə́dʉ́gá buud bɛ̂sh bwə́ mə́ byɛ̂l mímwɔ̧ mi búdád wá, kú nə nyɔɔŋg mə́ fwo bwɛlɛ ntɔ̧́ Yuánɛs. Njɨ tɛɛm bə ntɔ́, muud mə́ búl bə zhizhe Faan á gwɔ́w dɨ́ yɛ́, á ntɔ̧́ Yuánɛs. ");
INSERT INTO mcp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nə́ ndɛɛ́, wúlə fwála mə́ Yuánɛs Nduu-buud zə wɔ́ɔ́s múús ɨɨ́, Faan á gwɔ́w í mú ŋgə bə sâ ŋkûl, buud bwə́ ŋgə́ lʉl iŋkuŋkwanz wá, bwə́ wə́ bwə́ ŋgə́ ŋwa dwo. ");
INSERT INTO mcp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mbwoomb mə́cɛ̧ɛ̧ nə micilyá mí búúd ɔ mícúndə́ bɛ̂sh mí á ŋgə cúndə Faan mə́ Zɛmbî zə jé baan mə́ Yuánɛs. ");
INSERT INTO mcp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ŋkí bɨ́ bʉ́sə́ cʉ́ŋ nə mə, mpugá nə́ Yuánɛs wə́ jísə́ Eli bwə́ á bwiiŋg nə́ a bá zə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, a gwág. ");
INSERT INTO mcp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Mə kág yɨɨga kala búúd á múús nə ozə́? Jɨ́ nda ikágə́ bísə́ shishɛ̧́ ísɛɛŋgyá dɨ́ yí, bíl í ŋgə́ kámbʉla nə bílʉ́gá nə́: ");
INSERT INTO mcp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Sə́ mə́ lwɔ̧́ bɨ́ ilúlwóŋ í ábulya məkə̂l, bɨ kú sáág; sə́ mə́ nyiŋgə wá míŋgwa mí shwɨy, bɨ kú tədʉwa.” ");
INSERT INTO mcp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ntɔ́ wə́ í ŋgə́ bə ɛ́ga; Yuánɛs nyə á zə, kú də ídɨ́y-dɨ̂y, a kú ŋgul; buud nə́: “A jɨ nə jamb.” ");
INSERT INTO mcp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","*Mwân mə Múúd mə́ zə, a ŋgə́ də, a ŋgə́ ŋgul; bwə́ nə́: “Nyɨ́nɛ nyɛ jisə ndə̂l dəg, ŋgulɛ məlwəg, a jɨ nə́mə́ shwə́ oŋwɛnyɛ ɔ tóya nə osɔ́ɔl ɔ *mísə́m.” Njɨ mə́ jaaw bɨ́ nə́ fʉg í ŋgə nyîn mísɔ́ɔ́lʉ́gʉ́ myɛ́d nə́ sáŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yésus nyə a ŋkáánd nə buud ɔ́ míl míŋgwə́la nəcé, nyə á tɛɛm ŋgə sá ncúlyá *məshimbá bwə́dɨ́, bwə́ á shígɛ́ cɛ́nd mítə́dʉ́gá. Nyə a ŋkáánd nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Məntágʉla nə bɨ́ buud ɔ́ Korazín. Məntágʉla nə bɨ́ buud ɔ́ Bɛtʉsayída nə́mə́. Nəcé bímbí lʉ́ mə́shimbá mə́ mə́ sɨ̂y bɨ́dɨ́ má, mə́ á mbə̂m sɨ̂y Tir nə Sidon, buud ɔ́ nûŋ bwə́ á mbə̂m nə́mə́ bwey bwáád míŋkud, ji ífiî dɨ̂ nə́ bwə́ cɛ́nd mítə́dʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nə́ ndɛɛ́, mə́ jaaw bɨ́ nə́, jwɔ̂w lʉ́ cígʉ́lɛ́ mílə́sʉ́, intʉ́gʉ́lí i Tir nə Sodom í ábʉ́lɛ́ bul nyaan nda bɨ́ bɨ́n. ");
INSERT INTO mcp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bɨ bâŋ buud ɔ́ Kapɛrnawûm, bɨ́ ŋgə tə́dʉga nə́ bɨ mə bá kə gwɔ̂w? Mbɔ̂, bɨ mə bá yidá shulə kə baŋ mínjîm. Nəcé bímbí lʉ́ mə́shimbá mə́ mə́ sɨ̂y bɨ́dɨ́ má, mə́ á mbə̂m sɨ̂y ŋgwə́la á Sódom, ŋki ŋgwə́la wɔɔŋgʉ̂ wúsə́ ná mpwogɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gwə́ wə́ mə́ mpu jaaw bɨ́ nə́, jwɔ̂w Zɛmbî mə bá zə sámb búúd milə́sʉ́ yí, bɨ mə bá bə nə intʉ́gʉ́lí ŋkí yáág ntɔ̧ búúd ɔ́ Sódom.» ");
INSERT INTO mcp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yésus nyə á ka lás jâŋ ja nə́: «Pʉpa, Cwámba á gwɔ̂w nə shí, mə yə́ wo gúmə́ nəcé wo á shweel ompuye bə́nɔ̂ŋ buud ɔ́ fʉg isâ íga, wo yida lwágʉlə ozhizhe ɔ búúd. ");
INSERT INTO mcp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Haaw Pʉpa, ntɔ́ wə́ wó á cɛɛl nə́ í bə́g yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Dâ nyə a cwámbʉlə mə isâ byɛ̂sh. Kú nə muud mə wámbʉ́lə́ mpu Zɛmbî Mwân njɨ Sɔ́ɔ́ŋgʉ́, kú nə́mə́ nə muud mə wámbʉ́lə́ mpu Zɛmbî Sɔ́ɔ́ŋgʉ́, njɨ Mwân, nə muud yɛ̂sh Mwân mə́ cɛ́ɛ́l sá nə́ a mpúg yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Bɨ́ buud bɨ́ ŋgə́ wádʉga nə mimbag mí ájijilə̂ wá, zəgá mə́dɨ́, mə é sá nə́ bɨ́ wógag. ");
INSERT INTO mcp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magʉləgá nə́ shé sáág isɛ́y byâm fʉlá, bɨ zə́g ŋwa njɨ́ɨ́gʉ́lá wâm. Mə jɨ nə jɔ̧ lâm, mə kú nə intʉ́gʉ́lí. Bɨ́ é yidá mpu yɔwʉla, ");
INSERT INTO mcp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","nəcé isɛ́y byâm í akwówʉ́láyɛ́, mbag wâm wɨ́ ŋkí yɨ́ɨ́sa.» ");
INSERT INTO mcp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dúl fwála í á bə nə́, Yésus bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ á ŋgə lɨ́ɨ́na ifambə́ í *blé jwɔ́w lʉ́ Sábaad. Ompwíín bwə́ á ka gwág zha, bwə́ mú ka ŋgə búgə mikʉŋg mí blé, ŋgə də. ");
INSERT INTO mcp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","*Ofarizyɛ̂ŋ bwə́ mú dʉ́g sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂. Bwə́ mú cɨ nə Yésus nə́: «Dʉgɨ́, ompwíín bwô bwə́ ŋgə sá sâ mə́cɛ̧ɛ̧ mə́ amágʉ́lə́yɛ́ nə́ muud sáág jwɔ̂w lʉ́ Sábaad yí.» ");
INSERT INTO mcp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Njɨ Yésus mú bɛ̧sa nə bwo nə́: «Ye bɨ́ afwóyɛ́ bwɛlɛ lɔ̧̂ sâ *Dávid nyə á sá ja bə́nɔ̂ŋ buud bɛ́ bwə́ á gwág zha yí? ");
INSERT INTO mcp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nə́ nyə á kə nyíi banda *mə́túnʉga dɨ́, kə də íbʉlɛ́d í á dʉ bə ci shú yə́lə Zɛmbî gúmə́ yí; í njúl nə́ tɔɔ nyə tɔɔ buud bɛ́ bwə́ á shígɛ́ bə nə zhɨɨ́ nə́ bwə́ də́g byo. Ŋgaá, məcɛ̧ɛ̧ mə́ dʉ cɨ nə́ njɨ ofada wə́ bwə́ dʉ́g də byo, kú nə ŋgwɔ́l múúd shús? ");
INSERT INTO mcp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bɨ mə́ dʉ bwey lɔ̧́ məcɛ̧ɛ̧ mə́ Moyîz. Ŋgaá mə́ ŋgə cɨ nə́ jwɔ̂w lʉ́ Sábaad ofada bwə́ dʉ sɛ̂y *Mpáánzə́ Zɛmbî dɨ́? Ntɔ́ jɨ nə́ bwə́ dʉ ntɔ̧ cɛ̧ɛ̧ á jwɔ̂w lʉ́ Sábaad, njɨ Zɛmbî kú yə́ bwo məbɛ̧ɛ̧́. ");
INSERT INTO mcp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mə́ jaaw bɨ́ nə́ shé músə nə gúl sâ shé mə́ jəlá nə ságʉsə ntɔ̧ Mpáánzə́ Zɛmbî yí. ");
INSERT INTO mcp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kálaad Zɛmbî ŋgə cɨ nə́: “Mə́ bul jɨɨ nə́ buud bwə́ gwágʉ́g buud cɛy lámʉ́d, ntɔ̧ nə́ bwə́ dʉ́g sá mə mətúnʉga.” Bɨ mbə̂m ŋgə mpu gwág ciyá nɨ, ŋki bɨ shígɛ́ fánda yə́ buud ɔ́nɨ məbɛ̧ɛ̧́ ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mpugá nə́ *Mwân mə Múúd ŋgə jwú nə məcɛ̧ɛ̧ mə Sábaad.» ");
INSERT INTO mcp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yésus mú wú na jínɨ kʉ́lʉ́d, a mú kyey kə nyíi *mpáánzə́ minjɨ́ɨ́gʉ́lá dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A mú kə kwey ŋgwɔ́l múúd cínɔŋgʉ́ nə́ mbwə̂ í mə́ shîn shwáámb. Ofarizyɛ̂ŋ bwə́ á ka ŋgə sɔ̧́ zhɨɨ́ nə́ bwə́ jɛ́ɛ́g Yésus njagə́, bwə́ á ka jî nyə nə́: «Ye məcɛ̧ɛ̧ mə́shé mə́ magʉlə nə́ bwə́ lwágʉg mbə̂l jwɔ̂w lʉ́ Sábaad?» ");
INSERT INTO mcp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A mú yida cɨ nə bwo nə́: «Ŋkí ŋgwɔ́l múúd á na gwooŋg jɨ́nʉ́d jɨ nə tɔw ŋgwúd nə́ báŋ, tɔw jɔɔŋgʉ̂ ka kud bɨ́d jwɔ̂w lʉ́ Sábaad, ŋgaá nyə e kə bií gwo, a bʉ̂n, yîl gwo bɨ́d? ");
INSERT INTO mcp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ŋgaá muud jɨ nə mfíí cɔ̧́ tɔw? Ntɔ́ jɨ nə́, məcɛ̧ɛ̧ mə́shé mə́ magʉlə nə́ sə́ sáág buud mənywa jwɔ̂w lʉ́ Sábaad.» ");
INSERT INTO mcp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A mú cɨ nə muud á shwáámbʉ́lə mbwə̂ nə́: «Kwéégʉ́g mbwə̂.» A mú kwéég mbwə̂, í mú bə mpwogɛ́ nda wúlʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na, Ofarizyɛ̂ŋ bwə́ mú wɔ́ɔ́s tɔ́ɔ́n, kə sá shwushwaga, sɔ̧́lə zhɨ́ɨ́ nə́ bwə́ cɛ̧ɛ̧lə Yésus shwɨy. ");
INSERT INTO mcp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ja Yésus mə́ mpu yuug jɔɔŋg yí, a mú wú cínɔŋg. Buud bwə́ mú bɛ̧ nyə áncuncuma. Yésus mú ŋgə lwag mimbə̂l myɛ̂sh, ");
INSERT INTO mcp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","a ŋgə́ báásʉlə bwo nə́ bwə́ kú bwɛlɛ sá nə́ buud bwə́ mpúg mbii váál múúd á jísə́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ntɔ́ kɛ́ɛl mə́ Zɛmbî, Izayí nyə á cúndə yí, í mú bwəma. Zɛmbî nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sɔ́ɔl məsáal wâm wə́ ɛ́ga, nyə wə́ mə́ á fɛ́ɛ́sh yɛ́. A jɨ abábə waamə́, lâm wâm wɛ̂sh wúsə́ nyə́dɨ́. Mə bá yə́ nyə Shíshim wâm. Nyə wə́ mə́ bá zə lwágʉlə ílwoŋ í búúd tʉ́təlí mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nyə abʉ́lɛ́ dʉ shuya nə buud, a kú saagʉwo, kú nə muud mə́ bá gwádʉga kə́l dɛ́ mə́ŋkúmbə mə́ búúd dɨ̂ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nyə a bʉ́lɛ lal lâm nda muud mə́ kə́ casʉlə mbwu í mə́ bwey láŋgʉwo yí, tɔɔ nda muud mə́ jímə́ ŋgwiilɛ lámba í mə́ shîn tag yí. A bá bə nə jɔ̧ lâm ntʉ́nɨ kə jé ja búúd bɛ̂sh bwə́ bá mpu tʉ́təlí mə́ Zɛmbî yí. ");
INSERT INTO mcp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ilwoŋ í búúd byɛ̂sh í bá ŋgə bwánd sɔ́ɔ́lʉ́gʉ́ yé nə búgə́. ");
INSERT INTO mcp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mpʉ́sə na, buud bwə́ mú zə nə wúl mbə̂l wə́ Yésus. Jamb í á wá nyə mə́ŋkədad nə́ a bə́g, nyə ancím-ncîm, nyə fífî. Yésus músə yîl muud ɛ́nɛ jamb, a mú dʉ́gya, a mú nə́mə́ lás. ");
INSERT INTO mcp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Buud bwə́ á bə cínɔŋg áncuncuma wá, bwə́ mú bul káam. Bwə́ nə́: «Mwân mə *Dávid dɨ́ ɛ́ga?» ");
INSERT INTO mcp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ja *Ofarizyɛ̂ŋ bwə́ mə́ gwág ciyá jɔɔŋg yí, bwə́ mú shwána, bwə́ nə́: «Muud ɛ́nɛ ŋgə yîl məjamb nə ŋkul mə́ Bɛlʉzebul, njwû məjamb.» ");
INSERT INTO mcp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Njɨ, Yésus mú mpu mítə́dʉ́gá myáŋ, a mú ka cɨ nə bwo nə́: «Búúd ɔ dúl faan bwə́ ká bɔ́ɔ́g ŋgə lúmbʉli bwə́mɛ́ nə bwə́mɛ́, faan dɔɔŋg í é jɛ̧ɛ̧ nə́ mpaá. Buud wâ wúl ŋgwə́la bwə́ ká béégya, lúmbʉli bwə́mɛ́ nə́ bwə́mɛ́, ŋgwə́la wɔɔŋgʉ̂ í shîn bwɨ̂l. Ntɔ́ nə́mə́, búúd ɔ wúl njɔ́w bwə́ ká bɔ́ɔ́g ŋgə lúmbʉli bwə́mɛ́ nə bwə́mɛ́, njɔ́w búúd wɔɔŋg í ábʉ́lɛ́ bwey nə jímbʉ́lə. ");
INSERT INTO mcp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ŋkí *Sátan mə́ yida nyiŋgə cuwo, ŋgə yîl nyəmɛ́fwó, ntɔ́ jɨ nə a mə́ bɔɔg, faan dɛ́ í ka tɔ̂w na ntʉdɛl? ");
INSERT INTO mcp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ŋki Bɛlʉzebul wə́ ŋgə́ yə mə ŋkul nə́ mə ŋgə́g yîl buud məjamb nda bɨ́ ŋgə́ cɨ nə́, zə́ nyɛ́ ŋgə yə buud bʉ́n ŋkul nyɔɔŋgʉ̂? Ŋgaá bwə́mɛ́fwó bwə́ ŋgə mpu lwágʉlə bɨ́ nə́ sáŋ nə́ bɨ bʉ́sə nə məbɛ̧ɛ̧́? ");
INSERT INTO mcp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Njɨ, ŋkí Shíshim mə́ Zɛmbî wə́ ŋgə́ yə mə ŋkul nə́ mə yílʉ́g buud məjamb ɨɨ́, mpugá nə́ Faan mə́ Zɛmbî í mú wa. ");
INSERT INTO mcp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Muud cúgɛ́ nə ŋkul nyíi njɔ́w mə́ ŋkuŋkúl, dɛ́ɛ́g nyə isâ byé, a kú fwo figə ŋkuŋkúl wɔɔŋg shí, wɔ́ɔlə nyə məŋkəda. Njɨ, á ká shîn wɔ́ɔlə nyə məŋkəda, a mú ka tɛɛm sha nyə njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Muud mə bə́ kú kɛɛm mə yɛ́, a ŋgə lúmbʉli nə mə. Muud mə bə́ kú zə wá mə́bwə̂ nə́ sə́ná sə́ sɛ́ɛ́ŋgʉg yɛ́, a ŋgə yida caam. ");
INSERT INTO mcp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sâ jɔɔŋg wə́ mə́ jaaw bɨ́ nə́ Zɛmbî mə bá juu búúd *misə́m nə *bwaasʉ́lə mpu bwə́ ŋgə́ sá yí. Njɨ, múúd mə ká kə nə bwaasʉ́lə mpu wə́ Shíshim, muud wɔɔŋgʉ̂ nyə abʉ́lɛ bwɛlɛ bə nə ijuugá. ");
INSERT INTO mcp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Múúd mə ká jág lás nə *Mwân mə Múúd, Zɛmbî juu nyə. Njɨ múúd mə ká jág lás nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim, muud wɔɔŋgʉ̂ nyə abʉ́lɛ bwɛlɛ bə nə ijuugá tɔɔ wa cʉg ga dɨ̂, tɔɔ jɔɔŋg í ŋgə́ zə yíd. ");
INSERT INTO mcp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Bɨ́ mə́ ká cɨ nə́ lɨ́ɨ́ jɨ́ fwámɛ́ lɨ́ɨ́, bɨ mə́ cɨ nə́ ibumə́ byé bísə fwámɛ́ íbumə́; bɨ́ mə́ ká cɨ nə́ lɨ́ɨ́ jɨ́ bɔ́w-bɔ̂w lɨ́ɨ́, bɨ mə́ cɨ nə́ ibumə́ byé bísə bɔ́w-bɔ̂w íbumə́. ");
INSERT INTO mcp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yé iyəlʉkag íga, bɨ njúl ibɔ́w-bɔ̂w í búúd, bɨ bʉ́sə nə ŋkul cɨ fwámɛ́ íciyá na ntʉdɛlɛ̂? Sâ múúd ŋgə́ bul tə́dʉga lámʉ́d yí, gwə́ wə́ mpu yé í dʉ́ lás yí. ");
INSERT INTO mcp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jɔ̧jɔ̧ múúd lâm yé wúsə nə jɔ̧jɔ̧ kwɔ̧ɔ̧zʉ́, í ka dʉ wééshʉli jɔ̧jɔ̧ ísâ; bɔ́w-bɔ̂w múúd yé lâm nə bɔ́w-bɔ̂w kwɔ̧ɔ̧zʉ́, ka nə́mə́ dʉ wééshʉli bɔ́w-bɔ̂w ísâ. ");
INSERT INTO mcp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mə mpú jaaw bɨ́ nə́ jwɔ̂w Zɛmbî mə bá zə sámb buud milə́sʉ́ yí, muud yɛ̂sh mə bá tɔ̂w kɔɔdʉd nə iciyá nyə á lás ilɨ́s-lɨ́s yí. ");
INSERT INTO mcp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wo bá ŋwa ŋkaam ŋkí məbɛ̧ɛ̧́ íciyá byô dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nə́ ndɛɛ́, bɔ́ɔ́l *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ bɔ́ɔ́l *Ofarizyɛ̂ŋ bwə́ mú cɨ nə Yésus nə́: «Yé Yɨ́ɨ́gʉli sə́ mə́ cɛɛl nə́ wó lwóg sə́ dúl *shimbá sə́ dʉ́gʉ́g.» ");
INSERT INTO mcp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yésus mú bɛ̧sa nə bwo nə́: «Mbɛɛ kala búúd í njúl ŋkí bɔ̂w, nə mitə́dʉ́gá olɨ́lɨŋgɨ̂ í bə́lɛ́ jí nə́ mə lwóg bwo shimbá! Bwə́ ábʉ́lɛ dʉ́g dúl shimbá, njɨ dɔɔŋg í á bə nə Zhwónas *muud micúndə́ mə́ Zɛmbî yí. ");
INSERT INTO mcp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nda Zhwónas nyə á já ibulú ílɔ́ɔl nə mimwásə́ mílɔ́ɔl shú ánʉ́nɨ́ dɨ́ mwɔ̧̂ dɨ́ nə́, ntɔ́ nə́mə́ wə́ *Mwân mə Múúd mə bá já ibulú ílɔ́ɔl nə mimwásə́ mílɔ́ɔl mə́ndəlú dɨ́ cwú yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jwɔ̂w Zɛmbî mə bá zə sámb búúd milə́sʉ́ yí, buud ɔ́ Ninivə bwə́ bá tɔ̂w tʉ́təlí yə kala búúd ga məbɛ̧ɛ̧́. Nəcé báá, bwə́ á cɛ́nd mítə́dʉ́gá ja bwə́ á gwág cúndə́ Zhwónas nyə a cúndə yí. Dʉgá, sâ í ntɔ̧́ Zhwónas yí jísə wa. ");
INSERT INTO mcp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Cî ámudâ í á wú *mə́kɔ́ɔ́l mə́ jwɔ̂w yí í bá nə́mə́ tɔ̂w tʉ́təlí yə kala búúd ga məbɛ̧ɛ̧́. Nəcé nyə á gwaa zhu íjumə i shíd zə gwágʉlə fʉg mə́ Sə́lʉmun. Dʉgá, sâ í ntɔ̧́ Sə́lʉmun yí jísə wa. ");
INSERT INTO mcp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ja bɔ́w-bɔ̂w shíshim í dʉ wú múúd nyúúlʉ́d yí, í dʉ kə ŋgə jɛ̧́ɛ̧la mə́shí mâ mishwééshá ŋgə́lə sɔ̧́ wogá. Njɨ ŋkí í bə́ kú kwey wogá, ");
INSERT INTO mcp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","í mú tə́dʉga nə́: “Mə zə́ nyiŋgə kə mə́dɨ́ njɔ́w, kʉ́l mə́ á fwo dʉ ji yí.” Í ká zə kwey njɔ́w cwúd, njɨ ŋgwámbʉ́lá, sâ jɛ̂sh jɔ̧ kwambʉlá, ");
INSERT INTO mcp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","í é kə ŋwa mílʉ́gá míshíshim zaŋgbá mí njúl nə ŋkʉ́d ntɔ̧ wə́mɛ́fwó, bə́nɔ́ŋ bɛ̂sh bwə́ mú kə nyíi njɔ́w, kwambʉlə jiya cínɔŋg. Nə́ ndɛɛ́, cʉg mə múúd wɔɔŋgʉ̂ í mú nyiŋgə jág bɔ̂w, ntɔ̧ mbií í á fwó dʉ bə yí. Mə́ jaaw bɨ́ nə́ kala búúd ábʉ́bɔ̂w ga í bá shúgʉla mbií wɔɔŋgʉ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yésus ŋgə́ ná lésha nə ncúlyá buud ntʉ́nɨ, nyɔɔŋgʉ́ yé bə́nɔ̂ŋ omínyɔŋʉ̂ bɛ́ bwə́ mú jê. Bwə́ músə tɔ̂w tɔ́ɔ́n, bwə́ ŋgə́ sɔ̧́ nə́ bwə́ lésha nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ŋgwɔ́l múúd mú kə jaaw Yésus nə́: «Nyɔɔŋgʉ́ woó bə́nɔ̂ŋ omínyɔŋʉ̂ bwô bʉ́sə na tɔ́ɔ́n, bwə́ ŋgə cɛɛl lésha nə wo.» ");
INSERT INTO mcp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yésus mú bɛ̧sa nə nɛ́ nə́: «Nyɔɔŋgʉ́ waamə̂ wə́ zə? Omínyɔŋʉ̂ báamə́ wə́ ozə́?» ");
INSERT INTO mcp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A músə sɛ́ɛ́mb mbwə̂ ŋgɛɛ *ómpwíín bɛ́ dɨ́. Nyə nə́: «Dʉgá, nyɔɔŋgʉ́ waamə́ nə omínyɔŋʉ̂ báamə́, bwə́ wə́ ɔ́ga! ");
INSERT INTO mcp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Muud yɛ̂sh mə́ dʉ sá sâ Sɔ́ɔ́ŋgʉ́ waamə́ a gwɔ́w mə jɨ́ɨ yɛ́, nyə wə́ jɨ́ mínyɔŋʉ̂ waamə́, ŋkí kɔ́ɔ́l waamə́ ŋkí ntâg nyɔɔŋgʉ́ waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nə́mə́ jwɔ̂w nɨ dɨ, Yésus nyə a wú njɔ́w, kə ncindye mâŋ, kə ji shí. ");
INSERT INTO mcp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Buud bwə́ mú kə sɛɛŋgya nyə́dɨ́ ŋkí jág bulya nə ndɛɛ́, a mú tɔ̂w kə kəwa byɔ́ɔ́lʉ́d, kə ji shí, buud bâŋ cíndú. ");
INSERT INTO mcp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A mú ŋgə kənd bwo zhwog mikanda. Nyə nə bwo nə́: «Ŋgwɔ́l mbɔɔl məmpəg nyə á zə kə myɛɛg mpəg. ");
INSERT INTO mcp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ja á mə́ ŋgə myɛɛg yí, nyúl mpúmə́ í mə́ shugʉla zhɨ́ɨ́ nə zhɨɨ́. Inunú í mú zə, zə shîn lúú nywô. ");
INSERT INTO mcp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nyúlʉ́gá í mú shugʉla shí á məkwóógʉ́d, kú nə fwámɛ́ mə́ndəlú cínɔŋg. Í mú nə́mə́ lɛɛl wéésh míŋgwu, nəcé məndəlú mə́ á shígɛ́ fifə. ");
INSERT INTO mcp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Njɨ, ja yásə́ í mə́ faan yí, miŋgwu mi mpwásə́ mí mú jígə, shîn shwáás nəcé kú nə fwámɛ́ míkɔ̧ɔ̧lə́. ");
INSERT INTO mcp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nyúl mpúmə́ í mú shugʉla íbiin-bíinʉd. Ibiin-bíin byɔɔŋg í mú lɛɛl juwo nə́ ndɛɛ́ káda íkɔ̧́lə í mpəg. ");
INSERT INTO mcp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Njɨ, nyúl mpúmə́ í á shugʉla shí átʉtagʉ́ dɨ̂, í mú ŋgə wúmə, dʉ́ga shug wúmə íbumə́ təd, dʉ́ga ibumə́ məwûm mə́saman, dúlʉ́gá məwûm mə́lɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yésus mú cɨ nə bwo nə́: «Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, a gwág.» ");
INSERT INTO mcp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","*Ompwíín bɛ́ bwə́ mú shísh nyə́dɨ́, kə jí nyə nə́: «Nəcé jɨ́ wó ŋgə́ jɨ́ɨ́gʉli buud míkanda dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yésus mú bɛ̧sa nə bwo nə́: «Jísə nəcé Zɛmbî nyə a mə́ sá nə́ bɨ báá mpúg mindímba myâ Faan á gwɔ̂w; njɨ nyə a shígɛ́ sá bɔ́ɔ́lʉ́gá ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Muud jɨ́ nə baalɛ́ fʉg yɛ́, Zɛmbî mə bá kwádʉlə nyə nywo, a músə bul nyiŋgə bə nə ndɨ̂. Njɨ nyɔɔŋg cúgɛ́ nə ndɨ́ yɛ́, Zɛmbî mə bá mɛɛl yîl nyə bʉ́baalɛ̂ á jɨ́ nə ndɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mə ŋgə jɨ́ɨ́gʉli bwo nə mikanda nəcé bʉ́sə bwə́ tɛɛm kənd mísh, bwə́ kú dʉ́g, bwə́ tɛɛm gwágʉlə, bwə́ kú gwág kú nə́mə́ wámbʉlə. ");
INSERT INTO mcp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ntɔ́ kɛ́ɛl mə́ Zɛmbî, Izayí nyə á cúndə yí, í mú bwəma shú dáŋ. Kɛ́ɛl dɔɔŋg dɨ́ nə́: Bɨ mə bá dʉ kənd mə́lwə̂, njɨ bɨ kú bwɛlɛ wámbʉlə; bɨ́ dʉ kənd mísh, njɨ bɨ kú bwɛlɛ dʉ́g; ");
INSERT INTO mcp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","nəcé kúl búúd ga í mə́ shîn lal mílâm, bwə́ mə́ shîn juwal mə́lwə̂, wə́ búdal mísh; nə́ mísh máŋ mə́ á bá dʉ́g, məlwə̂ máŋ mə́ á bá gwág, milâm myáŋ mí á bá wámbʉlə. Ŋkwuŋgá bwə́ á bá cɛ́nd kuú njɔɔnd, nə́ ndɛɛ́ mə mú lwag bwo.» ");
INSERT INTO mcp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yésus mú cɨ nə *ompwíín nə́: «Bɨ bâŋ, mísh mʉ́n mə́ mə́ jəla nəcé mə́ ŋgə dʉ́g; məlwə̂ mʉ́n jəla nəcé mə́ ŋgə gwág. ");
INSERT INTO mcp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, zhwog *buud ɔ mícúndə́ nə otʉ́təlí ɔ́ búúd bwə́ á bə nə yéésh nə́ bwə́ dʉ́g sâ bɨ́ ŋgə́ dʉ́g yí, njɨ bwə́ áshígɛ́ dʉ́g. Bwə́ á bə nə yéésh nə́ bwə́ gwág sâ bɨ́ ŋgə́ gwág yí, njɨ bwə́ áshígɛ́ gwág.» ");
INSERT INTO mcp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Kagá gwágʉ́lə nda kanda mbɔɔl məmpəg í kə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Múúd mə ká bə nə́, a gwágʉlə Kɛ́ɛl á Faan á gwɔ́w njɨ a kú wámbʉlə, Mbʉ́wʉ́lú múúd nyə é zə, zə yîl nyə mpəg í ámə kə lámʉ́d yí: ntɔ́ jɨ nə́ nyɨ́nɨ́ jisə tâŋ mpəg í á shugʉla zhɨ́ɨ́ nə zhɨɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Muud jísə́ tâŋ nda mpəg í á shugʉla shí á məkwóógʉ́ dɨ́ yɛ́, jísə nyɔɔŋg jɨ́ nə́, a gwág Mílə́sʉ́ mí Zɛmbî, a lə́g myə nə məshusʉg; ");
INSERT INTO mcp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","njɨ a kú nə mikɔ̧ɔ̧lə́ nyə́dɨ́ cʉgʉd, a kú wá nadâ, á bɛ̧ Mílə́sʉ́ mí Zɛmbî njɨ kʉ́kʉ́l baan, á ká nə́mə́ bwəma nə məntágʉla ŋkí cúwʉ́lí nəcé Mílə́sʉ́ mí Zɛmbî, a julə nyúul. ");
INSERT INTO mcp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Muud jísə́ tâŋ nda mpəg í á shugʉla íbiin-bíin dɨ́ yɛ́, jísə nyɔɔŋg á nə́, a gwág Mílə́sʉ́ mí Zɛmbî, njɨɨ́, yágʉ́wó ísâ yâ mâŋ mwɔ̂w, nə wɨ́ɨ́mbʉ́lə mə́bii í mú zə káda Mílə́sʉ́ mí Zɛmbî, mí mú bə nda wúmə. ");
INSERT INTO mcp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Muud nywáá jísə́ tâŋ nda mpəg í á shugʉla shí átʉtagʉ́ dɨ́ yɛ́, jísə nyɔɔŋg á nə́, a gwág Mílə́sʉ́ mí Zɛmbî, a wámbʉlə myə, a mú wúmə, dúl shug wúmə íbumə́ təd, dúl məwúm mə́saman, dúlʉ́gá məwúm mə́lɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yésus nyə á nyiŋgə nə́mə́ kənd buud wúl kanda nə́: «Faan á gwɔ̂w dʉ́sə nda lâŋ ga: Ŋgwɔ́l múúd nyə á zə sá fambə́, a myɛɛg jɔ̧ mpəg ídʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Njɨ, mpwó-bulú, búúd bɛ̂sh bwə́ njúl ígwə́d ɨɨ́, wúl zhízhíŋ músə zə bɛ̧ gúl bɔ́w-bɔ̂w ká na fambə́ nɨɨ́d nə́ ndɛɛ́ a mú kyey. ");
INSERT INTO mcp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ja mpəg í á kɔ̧́, í wá mə́bəga yí, bɔ́w-bɔ̂w ká í á kɔ̧́ nə́mə́, í músə nyîn. ");
INSERT INTO mcp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nə́ ndɛɛ́, amə́dɨ́ fambə́ osɔ́ɔl ɔ́ mə́sáal bɛ́ bwə́ mú kə jî nyə nə́: “Mása, ŋgaá wo á bɛ̧ njɨ mpəg ányunywaâ wódɨ́ fambə́? Ká, bɔ́w-bɔ̂w káá jâŋ í ŋgə wú ŋgow?” ");
INSERT INTO mcp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A mú bɛ̧sa nə bwo nə́: “Wúl zhízhíŋ wâm wə́ í á jəla nə zə sá ntʉ́nɨ.” Bwə́ nə nɛ́ nə́: “Ye sə́ kə́g tɨ́ yîl íkáá byɔɔŋgʉ̂?” ");
INSERT INTO mcp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nyə nə́: “Mbɔ̂! Kúgá kə. Bɨ á bá ŋgə bə́dʉga ikáá nə fwámɛ́ ídʉ̂w, byɛ̂sh í mú ŋgə tʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bɨ́dʉ́gá idʉ̂w nə káá abʉ́bɔ̂w byɛ̂sh í wɨ́yʉ́g, kə wɔ́ɔ́s ja búúd bwə́ bá zə saag ídʉ̂w yí. Mə é bá cɨ nə buud bɔɔŋg nə́ bwə́ tɛ́ɛ́dʉ́g tɨ́ íkáá í abʉ́bɔ̂w, bwə́ wɔ́ɔlə byo mimbwoomb, kə bá jígal. Bwə́ ka tɛɛm zə kwɔ́s ídʉ̂w, kə wá ŋkundád.”» ");
INSERT INTO mcp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yésus nyə á nyiŋgə kənd bwo wúl kaanə́ nə́: «Faan á gwɔ̂w dʉ́sə nda búbumə́ *mutárʉd ŋgwɔ́l múúd nyə á myɛɛg nyə́dɨ́ fambə́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Búbumə́ jɔɔŋg wə́ í búl cwáágʉwo nə bíl íbumə́ í mə́mpəg byɛ̂sh. Njɨ ja í dʉ́ kɔ̧́ yí, í dʉ gwaa cɔ̧́ mɔ́ɔ́lʉ́gá mə́mpəg mâ fambə́; í bə fwámɛ́ lɨ́lɨ́ɨ́, inunú zə ji nyə́dɨ́ mílɔ́wʉd.» ");
INSERT INTO mcp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A mú nyiŋgə kənd wúl kaanə́ nə́: «Faan á gwɔ̂w dʉ́sə nda fuú *ləvur. Ja múdá mə́ ŋwa wə, a fugə nə məmpɨɨ́ mə́ ŋgug bʉlɛ́d mə́lɔ́ɔl yí, í é sá nə́ ŋgug wɔɔŋg wɛ̂sh í búndɔwʉg.» ");
INSERT INTO mcp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yésus nyə á ŋgə cɨ buud isâ ínɨ byɛ̂sh míkaanə́d, nyə a shígɛ́ dʉ bwɛlɛ lás nə bwo kú kənd kaanə́. ");
INSERT INTO mcp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nyə á ŋgə sá ntɔ́ nə́ iciyá í ŋgwɔ́l *múúd micúndə́ í bwə́mag mbií nyə á cilə yí, nə́: Mə bá lésha nə bwo míkaanə́d. Mə bá wéésh isâ búúd bwə́ afwóyɛ́ bwɛlɛ mpu tɛ́ Zɛmbî nyə á fwɔ̧ shí yí. ");
INSERT INTO mcp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yésus músə wú kʉ́l búúd bwə́ á bə áncuncuma yí, kyey kə njɔ́w. *Ompwíín bɛ́ bwə́ mú shísh nyə́dɨ́. Bwə́ nə nyə nə́: «Fɛ́ɛ́lʉ́g sə́ kanda á bɔ́w-bɔ̂w káá í á bə fambə́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A mú bɛ̧sa nə bwo nə́: «Muud nyə á myɛɛg jɔ̧ mpəg ídʉ̂w yɛ́, nyə wə́ *Mwân mə Múúd. ");
INSERT INTO mcp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fambə́ wə́ shí búúd bwə́ njúl ga. Jɔ̧ mpəg wə́ buud bʉ́sə́ Faan á gwɔ́wʉ́d wá. Bɔ́w-bɔ̂w íkáá wə́ buud bwə́ ŋgə bɛ̧ Mbʉ́wʉ́lú múúd wá. ");
INSERT INTO mcp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zhízhíŋ í á bɛ̧ bɔ́w-bɔ̂w íkáá wə́ Njwû məjamb. Saagʉ́lə bwə́ bá saag ídʉ̂w fambə́ yí, wə́ mə́shíné mə́ shí. Buud bwə́ bá saag wá, bwə́ wə́ *wəéŋgəles. ");
INSERT INTO mcp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nda bwə́ dʉ tɨ́ íkáá í abʉ́bɔ̂w, bwə́ jígal byo bágə́d nə́, ntɔ́ nə́mə́ wə́ í bá bə məshíné mə́ shí dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwân mə Múúd mə bá ntɨ wəéŋgəles bɛ́, bwə́ zə́ bigas Faan dɛ́, bwə́ mú yîl búúd bwə́ ŋgə́ ndêny bɔ́ɔ́l məláámb wá, nə bɔɔŋg bʉ́sə́ kú bísh mə́cɛ̧ɛ̧ wá. ");
INSERT INTO mcp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bwə́ kə́ kʉl bɛ̂sh kuda ánʉ́nɨ̂ dɨ̂. Bwə́ bá bə cínɔŋg, njɨ bwə́ ŋgə́ bwam nə məyə̂. ");
INSERT INTO mcp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ntɔ́ otʉ́təlí ɔ búúd wâ Zɛmbî bwə́ bá dʉ faan nda yásə́ Faan mə́ Sɔ́ɔ́ŋgʉ́ wáŋʉ́d. Muud jɨ́ nə mə́lwə̂ mə́ gwág yɛ́, a gwág.» ");
INSERT INTO mcp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Faan á gwɔ̂w dʉ́sə nda gúl jimə́ lʉ́ sâ jísə́ shwoó dɨ́ gúl fambə́ yí. Muud mə́ kwey gwo yɛ́ a nyiŋgə mpu shweel gwo. A músə kə nə məshusʉg, a kə kusha mə́bii mɛ́ mɛ̂sh nə́ ndɛɛ́ a mú kə kusə fambə́ jɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Faan á gwɔ̂w í nyiŋgə nə́mə́ bə nda lâŋ ga: ŋgwɔ́l múúd nyə á dʉ kusə ijimə́ í mə́kwóógʉ́ bwə́ dʉ lúlə ísâ í nyaŋgá nə ndɨ̂ yí, nə́ a kə́ dʉ kusha. ");
INSERT INTO mcp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Muud wɔɔŋgʉ̂ mú ka kwey dɔɔŋg í búl bə nə mfíí cɔ̧́ mɔ́ɔ́lʉ́gá mɛ̂sh yí, a músə kə kusha ísâ byé byɛ̂sh nyə á bə nə ndɨ̂ yí, kə kusə kwóógʉ́ dɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Faan á gwɔ̂w í nyiŋgə nə́mə́ bə nda wód bwə́ mə́ wusə mə́júwód yí. Í bii óshû mímbií mímbií. ");
INSERT INTO mcp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ja í mə́ lwánd yí, bwə́ mú julə, kə nə dwo cíndú. Bwə́ mú kə ji shí, fɛ́ɛ́sh fwámɛ́ óshû, wá mímaŋgad. Bwə́ yîl óshû ɔ́ abʉ́bɔ̂w, myaas. ");
INSERT INTO mcp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ntɔ́ nə́mə́ wə́ í bá bə məshíné mə́ shí dɨ́ yɛ́. *Wəéŋgəles bwə́ bá bɛ́ɛ́g mimbíya mi búúd bə́nɔ̂ŋ otʉ́təlí ɔ́ búúd. ");
INSERT INTO mcp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bwə́ bá kʉl ósɔ́ɔl ɔ́ mə́bɔ̂w kuda ánʉ́nɨ́ dɨ̂. Cínɔŋg mə bá bə bwo, njɨ bwə́ ŋgə́ bwam nə məyə̂.» ");
INSERT INTO mcp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yésus mú jí *ompwíín bɛ́ nə́: «Ye bɨ shí mpu gwág ísâ ínɨ byɛ̂sh?» Bwə́ nə́: «Haaw.» ");
INSERT INTO mcp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nyə nə bwo nə́: «Gwə́ wə́ mə́ jaaw bɨ́ nə́, Yɨ́ɨ́gʉli məcɛ̧ɛ̧ yɛ̂sh mə́ jɨ́ɨ́g isâ yâ Faan á gwɔ̂w yɛ́, a jɨ nda ŋgwɔ́l sɔ́ɔ́ŋgʉ́ jísə́ nə jɔ̧ kwɔ̧ɔ̧zʉ́ yɛ́. A jɨ nə ŋkul wéésh ísâ í acwúlû nə í agúgwáan cínɔŋg kwɔ̧ɔ̧zʉ́ dɔɔŋgʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja Yésus mə́ shîn jɨ́ɨ́gʉli búúd nə mikanda mínɨ yí, a mú wú na, ");
INSERT INTO mcp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kə nyə́dɨ́ kwáádə́. A mú ká dʉ yə búúd minjɨ́ɨ́gʉ́lá bwə́dɨ́ *mpáánzə́ minjɨ́ɨ́gʉ́lá, mbií í á nə́ buud bɛ̂sh bwə́ á dʉ káam, bwə́ nə́: «Dʉ́ga váál fʉ́g nə dʉ́ga váál *mə́shimbá í á wú nyə ŋgow? ");
INSERT INTO mcp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mwân mə́ kábíndá dɨ́ ɛ́ga? Nyɔɔŋgʉ́ dɨ́ Maríya? Omínyɔŋʉ̂ bɛ́ wə́ *Yákwab bə́nɔ̂ŋ Yósɛb nə Shímun nə Yûdə? ");
INSERT INTO mcp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ŋgaá, okɔ́ɔ́l bɛ́ bɛ̂sh bʉ́sə wa sə́dɨ́? Məma ísâ ínɨ byɛ̂sh í á wú nyə ŋgow?» ");
INSERT INTO mcp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A mú bə bwo kwal-bɔɔgʉ́. A mú ka zə cɨ nə bwo nə́: «*Muud micúndə́ mə́ dʉ nə́mə́ bwəma nə mpyóŋ njɨ nyə́dɨ́ kwáádə́ nə nyə́dɨ́ njɔ́w búúdʉd.» ");
INSERT INTO mcp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ntɔ́ Yésus nyə a shígɛ́ bul sá məshimbá cínɔŋg, nəcé buud kú *búgʉla nyə. ");
INSERT INTO mcp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mwɔ̂w mɔɔŋgʉ̂ dɨ, Herod á Tatarâk nyə á gwág bwiiŋgyá mə́ Yésus, a mú ka cɨ nə osɔ́ɔl ɔ́ mə́sáal bɛ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","«Yuánɛs Nduu-buud mə́ gwûm. Sâ jɔɔŋg wə́ á músə́ nə mpífə́ á ŋgə́ sá *məshimbá ntʉ́nɨ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod nyə á cɨ ntɔ́ nəcé nyə á bii Yuánɛs Nduu-buud, wɔ́ɔlə nyə məŋkəda, wá nyə mímbwug dɨ́ nəcé lə́sʉ́ mə́ Herodyâd, mudá mə́ mínyɔŋʉ̂ yé Fílíp. ");
INSERT INTO mcp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nəcé Yuánɛs Nduu-buud nyə á jum Herod nə́: «Wo ajə́láyɛ́ nə ŋwa mudá ɛ́nɛ nə́ wo bâ.» ");
INSERT INTO mcp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod nyə á ka dʉ cɛɛl gwú Yuánɛs, njɨ a ká dʉ fúndə buud nəcé nda bwə́ á dʉ gwɔ̧́ɔ̧ Yuánɛs nə́ a jisə *muud micúndə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nə́ ndɛɛ́, jwɔ̂w Herod nyə a tə̂l zaŋ byélé dɛ́ yí, shilə mə́ Herodyâd í á zə sáág cwánʉ́d, Herod músə bul gwág nyə nywa. ");
INSERT INTO mcp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A mú kaag shilə nɨ nə́: «Mə é fáágʉlə wo sá jɛ̂sh wó é gwáámb mə yí.» A kɛɛn ŋkaanə́ kaagʉ́lə nyə ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Shilə nɨ músə bɛ̧ íshwambʉlə í nyɔ́ɔ́ŋgʉ̂, nyə nə Njwú-buud nə́: «Yə́g mə lúú mə́ Yuánɛs Nduu-buud yáásə́d wa kɨ́kɨdɨ́ga.» ");
INSERT INTO mcp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Njwú-buud músə gwág ŋgwóómbʉ́lú wɔɔŋgʉ̂ cɛy lámʉ́d; njɨ nda nyə á bwey kɛɛn ŋkaanə́ mísh mə́ ójóŋ dɨ́ nə́, a mú magʉlə nə́ bwə́ yə́g nyə. ");
INSERT INTO mcp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A mú kənd múúd njɔ́w mímbwug, kə cígə Yuánɛs cʉ́ŋ. ");
INSERT INTO mcp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bwə́ músə zə nə lúú yé yáásə́d, zə yə shilə nɨ, a músə kə nə wə, kə cwámbʉlə nyɔ́ɔ́ŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ompwíín ɔ́ Yuánɛs bwə́ músə kə ŋkɛ̂ny kug nyúul, kə dʉl. Bwə́ mú kə nə lâŋ kə jaaw Yésus. ");
INSERT INTO mcp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ja Yésus nyə a gwág mbii Herod nyə á ŋgə tə́dʉga yí, nyə a wú cínɔŋg, kə kəwa byɔ́ɔ́lʉ́d kyey nə́ a kə́ ji nyə́mɛ́fwó bugád kʉ́l búúd bwə́ cúgɛ́ yí. Njɨ buud bwə́ mú mpu ntɔ́, bwə́ músə zə áncuncuma, bwə́ ŋgə́ zhu míŋgwə́la, bwə́ ŋgə́ kyey ncindye nə ncindye ŋgə́lə bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja á mə́ shulə byɔ́ɔ́l dɨ́ yí, a mú dʉ́g mə́ŋkúmbə mə búúd mə́nɨ; a mú gwág bwo cɛy lámʉ́d, a músə lwag mimbə̂l myáŋ. ");
INSERT INTO mcp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ja kugʉ́ mə́ bii shí yí, *ompwíín bwə́ mú shísh nyə kúnə́-kúnə, kə cɨ nə nyə nə́: «Sə́ bʉ́sə wa bugád, kugʉ́ nə́mə́ ɔ́ga, bɨ́dʉ́g mə́ŋkúmbə mə búúd mə́ga, bwə́ kə́g mə́kwáádə́, kə kusə sâ mə́ də̂.» ");
INSERT INTO mcp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yésus mú bɛ̧sa nə bwo nə́: «Í ajə́láyɛ́ nə́ buud ɔ́nɨ bwə́ kə́g. Bɨmɛ́fwó, yə́gá bwo sâ mə́ də̂.» ");
INSERT INTO mcp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ompwíín nə nɛ́ nə́: «Sə́ cugɛ́ nə sâ wa, njɨ ibʉlɛ́d itɔ́ɔn nə oshú óbá.» ");
INSERT INTO mcp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nyə nə bwo nə́: «Zəgá mə nə byo wa.» ");
INSERT INTO mcp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A mú cɨ nə buud bɛ̂sh nə́ bwə́ jíg shí ákándad. A mú ka ŋwa íbʉlɛ́d itɔ́ɔn nə oshú óbá ɔ́nɨ, a bʉ̂n mísh gwɔ̂w, yə Zɛmbî akíba. A músə fɛ̂y íbʉlɛ́d, yə ompwíín. Ompwíín bwə́ músə kə kaaw búúd. ");
INSERT INTO mcp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Buud bɛ̂sh bwə́ mú də, jílə, idʉ̂w lʉ́g. Byɔɔŋg í á lʉ́g yí, í músə lwánd mə́bwumú wûm nə mə́bá. ");
INSERT INTO mcp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Buud bwə́ á də wá, bwə́ á jee bə budûm otɔ́ɔ́shin ótɔ́ɔn, kú lɔ̧́ búdá nə ikágə́. ");
INSERT INTO mcp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nə́mə́ njɨ í á shîn yí, Yésus nə *ompwíín nə́ bwə́ kə́wag byɔ́ɔ́lʉ́d, bwə́ lɨ́ɨ́nág kə nyə shwóg mâŋ faŋwíny tɛ́ nyə é ŋgə fwo bɨ́d zhwog buud bwə́ á bə ɔ́nɨ yí. ");
INSERT INTO mcp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yésus mú shîn bɨ́d búúd, a músə bád mbʉ́ŋʉ́d nyə́mɛ́fwó nə́ a kə́ jəgʉla nə Zɛmbî. Bulú mú zə yínd a njúl cíndú nyəmɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Byɔ́ɔ́l dâŋ í á bə í mə́ wú bwúŋʉ́d fwámɛ́ cé. Njɨ ikwɔ̧́ í á ŋgə bul jág ntágʉlə bwo nəcé ŋkwɔ̧̂ nyə á ŋgə yida wú kɔ́ɔ́mb bwə́ á ŋgə kə yí. ");
INSERT INTO mcp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ŋgɛɛ míŋgwûm mí kúwo mí ashúshwóógʉ́ dɨ, a músə zə bɛ̧ bwo, a ŋgə́ kyey nə məkuú mə́júwó dɨ́ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ja ompwíín bwə́ mə́ dʉ́g a ŋgə́ kyey nə məkuú mə́júwó dɨ́ gwɔ̂w yí, bwə́ mú jág bul fúndə, bwə́ ŋgə́ tə́dʉga nə́ jísə *jîm. Bwə́ músə ka ŋgə bul bwú óŋkwiimbyê nə ifwaas. ");
INSERT INTO mcp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Njɨ Yésus mú lɛɛl cɨ nə bwo nə́: «Səlʉgá milâm shí. Mə wə́ ɛ́nɛ, kúgá fúndə.» ");
INSERT INTO mcp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pyɛ̂r mú cɨ nə nyə nə́: «Ŋkí jísə wo, cɨɨ́g nə́ mə kyéyʉg mə́júwó dɨ́ gwɔ̂w zə nûŋ wódɨ́.» ");
INSERT INTO mcp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yésus mú cɨ nə nyə nə́: «Zaág.» Pyɛ̂r mú wú byɔ́ɔ́lʉ́d, a músə ŋgə kyey mə́júwó dɨ́ gwɔ̂w, ŋgə kə wə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Njɨ, ja á mə́ dʉ́g nda ŋkwɔ̧̂ ŋgə́ bul kuŋg nə́, a mú nyiŋgə bə nə ifwaas, a mú tɛ́ɛ́d nyasʉlálə mə́júwód, a músə lɛɛl kɨ̂m nə́: «Yé Dâ, cʉgʉg mə.» ");
INSERT INTO mcp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yésus mú nə́mə́ lɛɛl sɛ́ɛ́mb mbwə̂, kə bií nyə. A mú cɨ nə nyə nə́: «Búgə́ gwô jɨ́ ná ŋkí tag. Nəcé jɨ́ wo ámə sá məshwán yí?» ");
INSERT INTO mcp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bwə́ músə kəwa byɔ́ɔ́lʉ́d, ŋkwɔ̧́ mú ntâg shîn. ");
INSERT INTO mcp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bɔɔŋg bwə́ á bə byɔ́ɔ́lʉ́d wá, bwə́ mú kúd Yésus məbwóŋ shí, yə nyə gúmə́, bwə́ nə́: «Wo jɨ bə́lɛ bə *Mwân mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bwə́ mə́ shîn lɨ́ɨ́na mâŋ, bwə́ mú jé lɔɔm á Genezarɛ̂t. ");
INSERT INTO mcp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Buud wâ kʉ́kʉ́l jɔɔŋg bwə́ mə́ yag Yésus, bwə́ mú kyey nə lâŋ mə́nd mâ kúnə́-kúnə mɛ̂shʉd. Buud bwə́ mú zə nyə nə mimbə̂l myɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bwə́ mú tɛ́ɛ́g nyə məbwə̂ nə́ a bɨ́dʉ́g nə́ bwə́ jísɔ́wʉ́g ŋgə kúnya njɨ nə *mbwaag káándə́ yé. Bɔɔŋg bwə́ á ŋgə kúnya nə nyə wá bwə́ mú ŋgə yâl. ");
INSERT INTO mcp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bɔ́ɔ́l *Ofarizyɛ̂ŋ nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á wú Yurʉ́səlɛm wá, bwə́ á ka shísh wə́ Yésus, kə cɨ nə nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«*Ompwíín bwô bwə́ ŋgə ntɔ̧ məcum mə́ ímpáámbə́, bwə́ ŋgə də kú gusa mə́bwə̂. Jɨ́ í sá ntɔ́?» ");
INSERT INTO mcp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yésus mú bɛ̧sa nə bwo nə́: «Nəcé jɨ́ bɨ́ bâŋ ŋgə́ ntɔ̧ mpə́ndí mə́ Zɛmbî, bɨ ŋgə́ yida baagʉlə məcum mə́ ímpáámbə́ yí? ");
INSERT INTO mcp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Zɛmbî nyə á cɨ nə́: “Gúmálʉ́g sɔ́ɔ́ŋgʉ́ woó nə nyɔɔŋgʉ́ woó.” A nyiŋgə nə́mə́ cɨ nə́: “Múúd mə ká lweem sɔ́ɔ́ŋgʉ́ yé ŋkí nyɔɔŋgʉ́ yé, bwə́ jəlá nə gwú múúd wɔɔŋgʉ̂.” ");
INSERT INTO mcp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Njɨ bɨ bâŋ bɨ́ ŋgə cɨ nə́: “Múúd mə ká jaaw sɔ́ɔ́ŋgʉ́ ŋkí nyɔɔŋgʉ́ nə́: ‘Sâ mə ámə nywá kwíínd wo nə ndɨ́ yí í músə məyə́na shú mə́ Zɛmbî,’ ");
INSERT INTO mcp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","í cúgɛ́ bwɛlɛ bə múúd wɔɔŋgʉ̂ obʉlʉga nə́ a yə́g sɔ́ɔ́ŋgʉ́ ŋkí nyɔɔŋgʉ́ gúmə́.” Ŋgaá nə́ bɨ́ ŋgə sá nə́ Milə́sʉ́ mí Zɛmbî mí bə́g ŋkʉ́ŋgʉ́g, məcum mʉ́n yidá mpu yáág? ");
INSERT INTO mcp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bɨ bʉ́sə nə məkə́ŋ! Izayí nyə á bə nə ŋkaam ja nyə á cúndə shú dʉ́nʉ́d nə́: ");
INSERT INTO mcp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kúl búúd ga í ŋgə gúmal mə njɨ mímpu dɨ́, milâm myáŋ mí njúl shwóg-shwóg nə mə. ");
INSERT INTO mcp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wáŋ ŋgə́lə ságʉsə bwə́ ŋgə́ ságʉsə mə yí wúsə ntɔ́ ŋgwas. Bwə́ ŋgə yida jɨ́ɨ́gʉli buud minjɨ́ɨ́gʉ́lá myâ məmpə́ndí mə́ búúd.» ");
INSERT INTO mcp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yésus músə ka yid, lésha nə buud bwə́ á bə cínɔŋgʉ́ áncuncuma wá, nyə nə bwo nə́: «Bɛ́nyʉ́gá məlwə̂, mpu gwágʉlə. ");
INSERT INTO mcp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sâ í dʉ nyíi múúd mpu dɨ́ yí, gwə́ dɨ́ í dʉ wá múúd məlwaagʉwo mísh mə́ Zɛmbî dɨ̂; njɨ sâ í dʉ yida wú múúd mpu dɨ́ yí, gwə́ wə́ í dʉ wá nyə məlwaagʉwo.» ");
INSERT INTO mcp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ompwíín bwə́ mú shísh nyə́dɨ́ kúnə́-kúnə, kə cɨ nə nyə nə́: «Ye wo mpú nə́ lə́sʉ́ wó ámə lás nɨ í ámə bul ntágʉlə Ofarizyɛ̂ŋ?» ");
INSERT INTO mcp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A mú bɛ̧sa nə bwo nə́: «Sâ jɛ̂sh sɔ́ɔ́ŋgʉ́ waamə́ nyə a shígɛ́ bɛ̧ yí, í bá tʉ̂w nə mikɔ̧ɔ̧lə́. ");
INSERT INTO mcp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bɨ́dʉ́gá bwo. Bʉ́sə wəancím-ncîm, bwə́ ŋgə bii bɔ́ɔ́l wə́ancím-ncîm mbwə́d nə́ bwə́ jaand nə bwo. Ŋkí ŋgwɔ́l áncím-ncîm mə́ jaand nə ŋgwɔ́l, bɛ̂sh bwə́ é bʉ́la bɨ́ɨ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pyɛ̂r músə cɨ nə nyə nə́: «Fɛ́ɛ́lʉ́g sə́ mpwokwoond nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yésus mú lás nə́: «Ye bɨ bʉ́sə nə́mə́ kú mpu gwág ísâ? ");
INSERT INTO mcp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ye bɨ agwágɛ́ nə́ sâ jɛ̂sh í nyíi múúd mpu dɨ́ yí, í dʉ kə mwɔ̧̂ dɨ́, í músə cɔ̧́ kə bɨ́ɨ́d? ");
INSERT INTO mcp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Njɨ isâ í dʉ wú múúd mpu dɨ́ yí, í dʉ zhu lámʉ́d, byó wə́ í dʉ wá múúd məlwaagʉwo mísh mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nəcé lámʉ́d wə́ bɔ́w-bɔ̂w mítə́dʉ́gá mí dʉ zhu yɛ́, nə məgwú mə búud, nə minɔɔmb, nə jaŋga, nə júwo, nə yə́lə búúd ompwɛnɛ, nə *bwaasʉ́lə mpu. ");
INSERT INTO mcp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Isâ í dʉ́ wá múúd məlwaagʉwo mísh mə́ Zɛmbî dɨ̂ wə́ ínɨ. Də́lə ídʉ̂w kú gusa mə́bwə̂ í ádɛ́ wá múúd məlwaagʉwo.» ");
INSERT INTO mcp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yésus músə wú na kʉ́l nɨɨ́d. A músə kə kɔ́ɔ́mb shí á Tir nə Sidon. ");
INSERT INTO mcp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ŋgwɔ́l múdá á nûŋ, a njúl shilə Kanaan, mú ŋgə zə nyə́dɨ́ a ŋgə́ kɨ̂m nə́: «Yé Cwámba, Mwân mə́ *Dávid, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́. Jamb í mə́ jág bul bii shilə wâm.» ");
INSERT INTO mcp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yésus mú ji nyə kʉ́l-kʉ̂l. *Ompwíín bwə́ mú shísh Yésus kúnə́-kúnə, zə cɨ nə nyə nə́: «Wɨ́ɨ́ŋgʉ́g nyə, a ŋgə sá káŋgá bɛ̧ɛ̧́lə sə́ nə ŋkwiimbyê.» ");
INSERT INTO mcp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yésus mú bɛ̧sa nə́: «Zɛmbî nyə á ntɨ mə shú íncwəmbɛ í *Izʉrəyɛ̂l, í mú ŋgə cwagʉwa yí.» ");
INSERT INTO mcp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Njɨ mudá ɛ́nɛ nyɛ músə zə kúd mpwóómbʉ́ shí wə́ Yésus, jəgʉla nə nyə nə́: «Yé Cwámba, shwɔ̧gʉ́ mə.» ");
INSERT INTO mcp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yésus mú bɛ̧sa nə nɛ́ nə́: «Ŋwálə ídʉ̂w í bwân ɔ́ njɔ́w, wusə yə ómpyə̂, í anywáyɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nyə nə Yésus nə́: «Jísə bə́lɛ bə ntɔ́. Ká, Cwámba, ompyə̂ bwə́ dʉ nə́mə́ cwála mə́mpulú mə́ dʉ́ kud tʉ́wʉli ómása dɨ́ shí má.» ");
INSERT INTO mcp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yésus músə cɨ nə nyə nə́: «Mudá ɛ́ga, wo jɨ nə fwámɛ́ búgə́. Sâ wó ŋgə́ jɨɨ yí, í bə́g nə́mə́ ntɔ́.» Nə́mə́ wəla dɔɔŋgʉ́ dɨ, mwân mə mudá ɛ́nɛ músə yâl. ");
INSERT INTO mcp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yésus músə wú kʉ́l nɨɨ́d. A mú ŋgə bɛ̧ ncindye mâŋ mə́ Galilê nə́ ndɛɛ́ a kə bád wúl mbʉ́ŋʉ́d, kə́ ji shí. ");
INSERT INTO mcp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Buud bwə́ mú zə sɛɛŋgya na nyə́dɨ́ áncuncuma; bwə́ ŋgə́ zə nə buud bwə́ á dʉ nyás wá, nə wəancím-ncîm, nə wəakúmə́lwə̂ nə buud wâ ijâm, nə míl zhwog mimbə̂l. Bwə́ mú zə ŋgə bwɨ́ɨ́g myo Yésus dɨ́ shí məkuú, a mú ŋgə lwag myo. ");
INSERT INTO mcp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Buud bwə́ á bul ŋgə káam ifífí ŋgə́lə bə́lɛ lás, buud ɔ́ íjám bwə́ ŋgə́ bə mpwogɛ́, bɔɔŋg bwə́ á dʉ nyás wá bwə́ ŋgə́ kyey kú ná kwo nyás, wəancím-ncîm bwə́ ŋgə́ mpu dʉ́g; bwə́ mú ŋgə ságʉsə Zɛmbî á Izʉrəyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yésus músə jɔ̂w *ómpwíín bɛ́, nyə nə bwo nə́: «Mə ŋgə gwág buud ɔ́ga ŋkúŋkwóŋʉ́lə nəcé sə́nɔ̂ŋ sə́ mə́ ji mwɔ̂w mə́lɔ́ɔl, bwə́ cúgɛ́ ná nə sâ mə́ də̂. Mə acɛ́ɛ́lɛ́ nyiŋg bwo ntʉ́nɨ zha, bwə́ á bá kə tag nə məntʉmbʉli zhɨ́ɨ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ompwíín bwə́ mú cɨ nə nyə nə́: «Sə́ é sá ntʉdɛlɛ́ nə́ sə́ bə́g nə bímbí lʉ́ ídʉ̂w mə yə́ zhwog buud ɔ́ga wa bugád?» ");
INSERT INTO mcp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yésus mú jî bwo nə́: «Bɨ bʉ́sə nə ibʉlɛ́d ínɛ́?» Bwə́ nə́: «Zaŋgbá, nə bʉ́baalɛ́ íshúshú.» ");
INSERT INTO mcp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yésus músə ka cɨ nə́ buud bwə́ jíg shí. ");
INSERT INTO mcp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nə́ ndɛɛ́ a músə ŋwa íbʉlɛ́d zaŋgbá byɔɔŋgʉ́ nə oshû, a yə Zɛmbî akíba, a fɛ̂y byo ikʉ́l ikʉ̂l, yə ómpwíín bɛ́, bwə́ mú kə ŋgə kaaw buud. ");
INSERT INTO mcp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Muud yɛ̂sh mú də nə́ ndɛɛ́ jílə. Zhwog ikʉ́l í mú lʉ́g tâŋ məkúdə́ zaŋgbá. ");
INSERT INTO mcp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Buud bwə́ á də wá, bwə́ á bə buud otɔ́ɔ́shin onɔ̧̂, njɨ budûm kú lɔ̧́ búdá nə ikágə́. ");
INSERT INTO mcp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A músə ka bɨ́d nə́ buud bwə́ nyíŋgəg, nyə mú kəwa byɔ́ɔ́lʉ́d, kə kɔ́ɔ́mb shí á Magadan. ");
INSERT INTO mcp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bɔ́ɔ́l *Ofarizyɛ̂ŋ nə *Osadwisyɛ̂ŋ bwə́ á zə jí Yésus njígá mə́bwə́bʉ́lán, bwə́ nə́ a lwóg bwo dúl *shimbá í ŋgə́ zhu gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yésus mú bɛ̧sa nə bwo nə́: «Bɨ mə́ dʉ bə, bɨ́ mə́ ká dʉ́g mpwó-kugʉ́ nə́ joŋ dʉ́sə tɨ́tɨɨ̂ nə́ zhwuŋ, bɨ nə́ jwɔ̂w á mán í bá bə nə́ sáŋ. ");
INSERT INTO mcp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ŋkí nə́, kúndə́ mán, bɨ́ mə́ ká dʉ́g joŋ ŋkí shila, bɨ́ mpu nə́ mpú nyə é nywɔ̧̂. Bɨ mə́ dʉ mpu yag íyuug í joŋ; njɨ bɨ kú mpu yag sâ í ŋgə́ sɨ̂y mwɔ̂w mə́ga dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mbɛɛ kala búúd í njúl ŋkí bɔ̂w, nə mitə́dʉ́gá olɨ́lɨŋgɨ̂ í bə́lɛ́ jí nə́ mə lwóg bwo shimbá! Bwə́ ábʉ́lɛ dʉ́g dúl shimbá, njɨ dɔɔŋg í á bə nə Zhwónas yí.» A músə wú na bwə́dɨ́, kyey. ");
INSERT INTO mcp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","*Ompwíín bwə́ á wusa ŋwaálə íbʉlɛ́d ja bə́nɔ́ŋ bwə́ á lɨ́ɨ́na mâŋ kə faŋwíny yí. ");
INSERT INTO mcp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yésus mú cɨ nə bwo nə́: «Jigá ncə̂ nə *Ofarizyɛ̂ŋ bə́nɔ́ŋ *Osadwisyɛ̂ŋ *ləvur wáŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bwə́ mú ka ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «A lás ntʉ́nɨ nəcé nda sə́ shígɛ́ zə nə ibʉlɛ́d nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yésus mú ka mpu sá bwə́ á ŋgə tə́dʉga yí, a mú cɨ nə bwo nə́: «Buud bâm tagʉ́lə ná búgə́ jɨ́n ɛɛ́! Jɨ́ tə́dʉ́gá wúsə́ bɨ́ njɨ nə́ bɨ shígɛ́ ŋwa íbʉlɛ́d yí? ");
INSERT INTO mcp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jɨ́ bɨ́ mə́ cá gwág ntʉ́nɨ yí? Ye bɨ anyíŋgə́yɛ́ ná tə́dʉga íbʉlɛ́d itɔ́ɔn búúd otɔ́ɔ́shin otɔ́ɔn bwə́ á də yí, nə bímbí lʉ́ mə́bwumú mə́ íkʉ́l bɨ́ á lʉ́g nə ndɨ́ má? ");
INSERT INTO mcp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ye bɨ kú tə́dʉga ibʉlɛ́d zaŋgbá búúd otɔ́ɔ́shin onɔ̧̂ bwə́ á də yí nə bímbí lʉ́ mə́kúdə́ mə́ íkʉ́l bɨ́ á lʉ́g nə ndɨ́ má? ");
INSERT INTO mcp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nəcé jɨ́ bɨ́ mə cá gwág nə́ mə aŋgɛ̂ nə lás lə́sʉ́ íbʉlɛ́d yí? Mə ŋgə cɨ nə́: “Jigá ncə̂ nə Ofarizyɛ̂ŋ bə́nɔ́ŋ Osadwisyɛ̂ŋ ləvur wáŋ.”» ");
INSERT INTO mcp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bwə́ mú ka tɛɛm mpu gwág nə́ nyə a shígɛ́ ŋgə lás nə bwo lə́sʉ́ ləvur á ibʉlɛ́d. Nyə á ŋgə yida cɨ nə́ bwə́ bɛ́yʉg minjɨ́ɨ́gʉ́lá Ofarizyɛ̂ŋ nə Osadwisyɛ̂ŋ bwə́ ŋgə jɨ́ɨ́gʉli myá. ");
INSERT INTO mcp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ja bwə́ mə́ kə jé shí á Sezarê mə Fílíp yí, Yésus mú ŋgə jí *ompwíín bɛ́ nə́: «Buud bwə́ ŋgə cɨ nə́ *Mwân mə Múúd jisə zə́?» ");
INSERT INTO mcp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bwə́ mú bɛ̧sa nə́: «Bɔ́ɔ́l búúd bwə́ ŋgə cɨ nə́ jísə Yuánɛs Nduu-buud, bɔ́ɔ́l nə́ jísə Eli, bɔ́ɔ́lʉ́gá nə́ Zheremî ŋkí ntâg ŋgwɔ́l *múúd micúndə́.» ");
INSERT INTO mcp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nyə nə bwo nə́: «Ká bɨ bâŋ, bɨ́ ŋgə cɨ nə́ mə jisə zə́?» ");
INSERT INTO mcp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Shímun Pyɛ̂r músə bɛ̧sa nə́: «Wo jisə *Krîst, *Mwân mə́ Zɛmbî á kuwô» ");
INSERT INTO mcp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yésus músə nyiŋgə lás, nyə nə Pyɛ̂r nə́: «Wɛɛ mə́ jəla, yé Shímun Mwân mə́ Zhwónas. Muud dɨ́ nyə ámə lwágʉlə wo sâ wó mə́ cɨ nɨ. Sɔ́ɔ́ŋgʉ́ wâm jísə́ gwɔ́w wə́ nyə ámə lwágʉlə wo gwo. ");
INSERT INTO mcp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mɛɛ mə́ ka jaaw wo nə́ wo wə́ Pyɛ̂r. Wo mə́ bə́lɛ bə kwóógʉ́. Nda bwə́ dʉ lwɔ̧́ njɔ́w kwóógʉ́ dɨ́ gwɔ́w nə́, mə bá sɛɛŋg *Dɔ̧ lʉ́ óbúgʉla dâm kwóógʉ́ dwô dɨ́ gwɔ̂w. Tɛɛm bə shwɨy í ábʉ́lɛ́ sá bwo sâ. ");
INSERT INTO mcp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mə bá yə wo ijuwʉga yâ Faan á gwɔ̂w. Sâ jɛ̂sh wó bá cɛ̧ɛ̧lə shí ga dɨ́ yí, í bá ntɔ́ gwɔ̂w, jɔɔŋg wó bá wiinzh shí ga dɨ́ yí, í bá bə ntɔ́ gwɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nə́ ndɛɛ́, a mú ka mpu báásʉlə ómpwíín nə́ bwə́ kú bwɛlɛ jaaw múúd nə́ a jisə Krîst. ");
INSERT INTO mcp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tɛ́ɛ́d na, a músə ka tɛ́ɛ́d jaawʉ́lə *ómpwíín bɛ́ nə́ í jɨɨ nə́ a kə́g Yurʉ́səlɛm, nə́ ocúmbá buud wâ lɔɔm nə milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ jəlá nə kə jág jugʉshi nyə, bwə́ gwú ntâg nyə. Njɨ a bá gwûm shwoŋ dɨ́ jwɔ́w lʉ́ lɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pyɛ̂r músə kə nə nyə koogʉ́, kə lás nə nyə nə́: «Mbɔ̂! Zɛmbî kyɛ́mʉg wo, Cwámba! Mbií sâ wɔɔŋgʉ̂ í abʉ́lɛ bə nə wo.» ");
INSERT INTO mcp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Njɨ Yésus mú yid, ŋkáánd nə nyə nə́: «Wúg mə na, *Sátan! Wo jɨ mə məma bɔɔgʉ́. Mitə́dʉ́gá myô mí cúgɛ́ mítə́dʉ́gá mí Zɛmbî, mísə njɨ mitə́dʉ́gá myâ buud.» ");
INSERT INTO mcp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A músə ka cɨ nə ompwíín bɛ́ nə́: «Ŋkí muud mə́ cɛɛl bɛ̧ mə, a bə́g kú jagʉlə nyə́mɛ́fwó; a ŋkɛ́nyʉ́g kwolós jé, a bɛ̧ mə. ");
INSERT INTO mcp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nəcé, múúd mə ká kaambʉlə nə cʉg jé, a yida jímbal gwo. Nyɔɔŋg mə jímbál cʉg jé nəcé mə yɛ́, a mə́ yidá kaambʉlə nə gwo. ");
INSERT INTO mcp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ŋkí muud mə́ bii mə́bii mɛ̂sh mâ shí ga nə́ ndɛɛ́ *shíshim yé jímb, wáyɛ́ mfíí nyə́ é bə nə ndɨ́ cínɔŋg yí? Muud jɨ nə ŋkul wá jɨ́ shú nə́ a nyíŋgəg bii shíshim yé? ");
INSERT INTO mcp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nəcé *Mwân mə Múúd mə bá zə a ŋgə́ ŋkənʉwa nda sɔ́ɔ́ŋgʉ́ yé, bə́nɔ̂ŋ *wəéŋgəles, a bá zə yə búúd myə́na mí mísɔ́ɔ́lʉ́gʉ́ bwə́ á sá myá. ");
INSERT INTO mcp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, bɔ́ɔ́l búúd bʉ́sə́ wa ɔ́ga, bwə́ ábʉ́lɛ bwɛlɛ yə, bwə́ kú fwo dʉ́g *Mwân mə Múúd mə́ zə ŋwa jiya icî jé.» ");
INSERT INTO mcp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mpʉ́sə mwɔ̂w mə́saman, Yésus mú ŋwa Pyɛ̂r nə Zhâk bá mínyɔŋʉ̂ Yuánɛs. A mú wú nə bwo búúd dɨ́, bwə́ kə bád wúl məma mbʉ́ŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nyúúl nyɛ́ mú shwɔ̧́ɔ̧la bwo míshʉ́d, mpwoombʉ́ í mú ŋgə ŋkənʉwa nyə nda jwɔ̂w, mikáándə́ myɛ́ mí mú ŋgə faan nda məŋkɛnya. ");
INSERT INTO mcp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Seegya nə́ Moyîz bá Eli bwə́ mə́ wɔ́ɔ́s, zə ŋgə́ lésha nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pyɛ̂r músə ka cɨ nə́: «Cwámba, nywaálə ŋgə́lə ji wa. Ŋkí wó magʉlə, mə shumə mə́banda məlɔ́ɔl, ŋgwúd shú dwô, dúl shú mə́ Moyîz, dúlʉ́gá shú mə́ Eli.» ");
INSERT INTO mcp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pyɛ̂r ŋgə́ ná lás ntʉ́nɨ, seegya njɨ gúndə́ á ŋkʉŋkənʉwá í mə́ zə búdal bɛ̂sh. Bwə́ mú gwág kə́l í ŋgə́ wú gúndə́ jɔɔŋg dɨ́ nə́: «Mwân waamə́ abábə wə́ ɛ́ga. Nyə́dɨ́ wə́ lâm wâm wɛ̂sh wúsə́ yɛ́. Ságá nyə məgwág.» ");
INSERT INTO mcp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ja *ómpwíín bwə́ mə́ gwág kə́l dɔɔŋg yí, bwə́ mú bul bə nə ifwaas, bwə́ mú wusə mə́nyúúl shí ombúmbudɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yésus músə shísh, zə kúnya nə bwo, a mú cɨ nə bwo nə́: «Bʉ́nʉ́gá! Kúgá ná kwo gwág ífwaas.» ");
INSERT INTO mcp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bwə́ mú bʉ̂n mə́mpwoombʉ́, bwə́ mú dʉ́g njɨ Yésus nyə́mɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ja bə́nɔ́ŋ bwə́ mə́ ka ŋgə shulə wú mbʉ́ŋ dɨ́ yí, a mú lás nə bwo nə́: «Ci bɨ kú jaaw múúd sâ bɨ́ ámə dʉ́g yí, kə wɔ́ɔ́s ja *Mwân mə Múúd mə bá gwûm shwoŋ dɨ̂ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nə́ ndɛɛ́ bwə́ músə jí nyə nə́: «Nəcé jɨ́ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ dʉ cɨ nə́ í jɨɨ nə́ Eli fwóg tɛ́ɛ́d zə yí?» ");
INSERT INTO mcp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A mú bɛ̧sa nə́: «Jɨ́ bə́lɛ bə ntɔ́ nə́ Eli mə́ jəlá nə fwo zə, zə tə̂l ísâ byɛ̂sh ícé byáŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sâ ŋgwúdʉ́, mɛɛ mə́ jaaw bɨ́ nə́ Eli nyə a shí zə. Buud bwə́ á shígɛ́ yag nyə, bwə́ á sá nyə mbií wɛ̂sh bwə́ á cɛɛl yí. Ntɔ́ nə́mə́ Mwân mə Múúd mə bá jug məbwə̂ máŋʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ompwíín bwə́ músə mpu nə́ Yuánɛs Nduu-buud wə́ á ŋgə cɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ja bwə́ mə́ kə wɔ́ɔ́s mə́ŋkúmbə mə búúd dɨ́ yí, ŋgwɔ́l múúd músə zə kúd Yésus məbwóŋ shí, jəgʉla nə nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Yé Cwámba, gwágʉ́g mwân waamə́ ŋkúŋkwóŋʉ́lə. A dʉ fudə ibwúg, a ŋgə bul jug. A mú dʉ kʉl nyúúl tɔɔ kuda dɨ́ tɔɔ mə́júwód. ");
INSERT INTO mcp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mə ámə zə nə nyə *ómpwíín bwô dɨ́, njɨ bwə́ shígɛ́ kwag lwagʉ́lə nyə.» ");
INSERT INTO mcp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yésus músə bɨ̂ nə́: «Wúu! yé óháádɛn ɔ́ga! A bɔ́wʉ́lə bɨ́ mitə́dʉ́gá e! Mə e bá kə nə bɨ̂ ntʉ́nɨ kə wɔ́ɔ́s ŋgow? Mə é bá jísɔw bɨ́ kə kumə jáyɛ́ ja? Zəgá mə nə mwân wɔɔŋg kâ.» ");
INSERT INTO mcp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yésus mú ŋkáánd nə jamb, í músə wû mwân nyúúlʉ́d, ncúncwə́má jɔɔŋg músə yâl nə́mə́ cé nə cé. ");
INSERT INTO mcp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nə́ ndɛɛ́ ompwíín bwə́ músə shísh wə́ Yésus, zə nyímbʉla nə nyə nə́: «Nəcé jɨ́ sə́ bâŋ shígɛ́ kwag yílʉ́lə jamb nɨ yí?» ");
INSERT INTO mcp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yésus mú bɛ̧sa nə bwo nə́: «Jísə nəcé bɨ cugɛ́ nə fwámɛ́ búgə́. Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, í mbə̂m bə nə búgə́ tɔɔ njɨ cíg-cîg bímbí búbumə́ *mutárʉd, bɨ́ je cɨ nə mbʉ́ŋ ga nə́: “Tʉ́wʉ́g na, wo kə́g tɔ̂w wáádə́”, mbʉ́ŋ bə́lɛ kə. Sâ kú ná kwo ntɔ̧ bɨ ŋkul. ");
INSERT INTO mcp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Njɨ, mbií jamb nɨ í dʉ wú njɨ wo mə́ fwo mpu jəgʉla nə Zɛmbî, wo ci ídʉ̂w.» ");
INSERT INTO mcp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ja bə́nɔ́ŋ bwə́ á ŋgə kyey shí á Galilê yí, Yésus nyə á jaaw bwo nə́: «Í jɨɨ nə́ *Mwân mə Múúd bâg kaanz məbwə̂ mə́ búúd dɨ́, ");
INSERT INTO mcp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bwə́ bág gwú nyə. Njɨ a bá gwûm jwɔ̂w álɛ́ɛl.» Ompwíín bwə́ músə ka bul gwág sâ jɔɔŋgʉ̂ cɛy lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ja bwə́ mə́ ka kə wɔ́ɔ́s Kapɛrnawûm yí, búúd bwə́ á dʉ ŋwa tóya á *Mpáánzə́ Zɛmbî wá bwə́ mú zə jí Pyɛ̂r nə́: «Yɨ́ɨ́gʉli wʉ́n mə́ dʉ nə́mə́ jə́na tóya ɛ́ga?» ");
INSERT INTO mcp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pyɛ̂r mú magʉlə nə́: «Haaw!» Ja Pyɛ̂r mə́ kə nyíi njɔ́w yí, a kú fwo lás, Yésus mú jí nyə nə́: «Shímun e, wɛɛ mə́ dʉ́g nə́ jɨ? Ozə́ bwə́ dʉ jə́na ójwû ɔ shí otóya nə oŋgasʉmâŋ? Ye mimbyágá mí mə́shí máŋ, ye ijigə-jigə?» ");
INSERT INTO mcp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pyɛ̂r mú bɛ̧sa nə nyə nə́: «Ijigə-jigə.» Yésus mú cɨ nə nyə nə́: «Ŋgaá, ntɔ́ jɨ nə́ mimbyágá mí ádɛ́ jə́na? ");
INSERT INTO mcp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Njɨ, shú nə́ sə́ kú ntágʉlə bwo, kaág mâŋ, kə wusə ŋgwéye; shú wó é tɛ́ɛ́d tɨ́ yɛ́, wo bɛ̂ny nyə mpu, wo mú kwey saŋ *mwaanɛ̂ í kwágá nə tóya á buud obá yí. Wo músə ŋwa wə, wo kə jə́na tóya waamə̂ nə wô.» ");
INSERT INTO mcp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Baan dɔɔŋgʉ́ dɨ́, *ompwíín bwə́ á shísh wə́ Yésus zə jí nyə nə́: «Zə́ mə́ búl ná bə fwámɛ́ múúd Faan á gwɔ́wʉ́d?» ");
INSERT INTO mcp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yésus mú jɔ̂w kʉ́kágə́, zə tə̂l bwo míshʉ́d, ");
INSERT INTO mcp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nyə nə bwo nə́: «Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, ŋkí bɨ mə bə́ kú cɛ́nd kuú njɔɔnd nə́ bɨ bə́g nda ikʉ́kágə́, bɨ abʉ́lɛ́ bwɛlɛ nyíi Faan á gwɔ́wʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gwə́ wə́ jɨ́ nə́, muud mə dʉ́g nyə́mɛ́fwó zhizhe nda kʉ́kágə́ ga yɛ́ nyə wə́ mə́ bá bul bə fwámɛ́ múúd Faan á gwɔ́wʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Muud mə lə́g ntâg gúl kʉ́kágə́ nda jíga jínə́ dâm dɨ́ yɛ́, a mə́ lə́g mə. ");
INSERT INTO mcp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Njɨ, ikʉ́kágə́ í ŋgə́ *búgʉla mə íga, múúd mə ká kwal gúl bɔɔgʉ́, í bul jəla nə́ bwə́ kə́lʉg muud wɔɔŋgʉ̂ məma kwóógʉ́ cʉ́ŋʉ́d, bwə́ kʉl nyə nə dwo mâŋ, a kú ná cwánʉwo. ");
INSERT INTO mcp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Ŋkúŋkwóŋʉ́lə búúd nəcé bulyálə mə́bɔɔgʉ́. Cʉg í cúgɛ́ nə ŋkul bə kú nə məbɔɔgʉ́, njɨ ŋkwɛ́ɛ muud mə kwál búúd mwo yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ntɔ́, í ká bə nə́ mbwə̂ wô ŋkí kuú wô í ŋgə kwal wo bɔɔgʉ́, sámbʉ́g wə, wo wúsəg wə shwóg-shwóg; nəcé í bul jəla nə́ wo cʉ́gəg cʉg á kandʉgə wo njúl nə kʉ́l mbwə̂ ŋkí kʉ́l kuú, ntɔ̧ nə́ wo bə́g nə məbwə̂ nə məkuú mwô mɛ̂sh wo mú kə kuda á kandʉgə dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ŋkí jús dwô í ŋgə kwal wo bɔɔgʉ́, tɨ́ɨ́g dwo, wo wusə shwóg-shwóg nə wo. Í bul jəla nə́ wo nyííg cʉg á kandʉgə dɨ́ wo njúl nə ncwaan jús, ntɔ̧ nə́ wo bə́g nə mísh mwô mɛ̂sh, bwə́ bá kə kʉl wo kuda á kandʉgəd. ");
INSERT INTO mcp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Bɨ ɔ bɛy nə́ bɨ mpyényʉ́g gúl múmwántombú ga, nəcé mə mpú cɨ nə bɨ́ nə́ *wəéŋgəles báŋ bwə́ təl ja jɛ̂sh mísh mə́ Dâ jísə́ gwɔ́w yɛ́d. ");
INSERT INTO mcp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nəcé *Mwân mə Múúd nyə á zə cʉg buud bwə́ á mə́ jímb nə zhɨɨ́ wá. ");
INSERT INTO mcp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bɨ mə tə́dʉ́gá nə́ jɨ? Ŋkí ŋgwɔ́l múúd jɨ nə íncwəmbɛ təd, ŋgwúd í mú wú sɔɔnz dɨ́ kə ŋgə jɛ̧́ɛ̧la. Ŋgaá nə́ nyə e lʉ́gə byɔɔŋg yâ məwûm ibuú nə ibuu kʉ́l í ŋgə́ də yí, a fwo kə sɔ̧́ jɔɔŋg í ámə kə ŋgə jɛ̧́ɛ̧la yí? ");
INSERT INTO mcp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A ká kwey gwo, bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, nyə é bə nə məshusʉg nə gwo ntɔ̧ yâ məwûm ibuú nə ibuu í shígɛ́ kə ŋgə jɛ̧́ɛ̧la yí. ");
INSERT INTO mcp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nə́mə́ mbií wɔɔŋgʉ̂, Sɔ́ɔ́ŋgʉ́ wʉ́n jɨ́ gwɔ́w yɛ́ nyə acɛ́ɛ́lɛ́ nə́ gúl múmwántombú ga í jímbʉ́g.» ");
INSERT INTO mcp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ŋkí ŋgwɔ́l mínyɔŋʉ̂ woó mə́ sá *sə́m, kaág lás nə nyə bɨná obá; á ká magʉlə gwág wo, wo mə́ sá nyə mpwogɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Njɨ ŋkí nyə amágʉ́lə́yɛ́ gwág wo, kaág jɔ̂w múúd ŋgwúd ŋkí óbá, bɨnɔ́ŋ bɨ kə́g lás nə nyə, í bə́g nda jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́, nə́: “Ŋkwambʉlə nyɛ̂sh í jəlá nə sɨ̂y nə owúshinɛd óbá ŋkí ólɔ́ɔl”. ");
INSERT INTO mcp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A ká ban nə́ nyə agwágɛ́ bwo, kaág jaaw *Dɔ̧ lʉ́ óbúgʉla. A ká nə́mə́ ban gwág Dɔ̧ lʉ́ óbúgʉla, dʉ́gʉ́g nyə nda muud nyə́ ampúyɛ́ fwámɛ́ Zɛmbî yɛ́, nda ŋwɛnyɛ tóya. ");
INSERT INTO mcp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, sâ jɛ̂sh bɨ́ mə́ cɛ̧ɛ̧lə shí ga dɨ́ yí, í bá bə ntɔ́ gwɔ́w. Jɔɔŋg jɛ̂sh bɨ́ mə́ bá wiinzh shí ga dɨ́ yí, í bá bwey bə ntɔ́ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bʉ́bə́lɛ́ mə́ nyiŋgə jaaw bɨ́ nə́, ŋkí buud obá wâ gwooŋg jɨ́n nɨ bwə́ mpú bwəma cʉ́ŋ ŋgwúd shí gaád nə́ bwə́ gwáámb Zɛmbî gúl sâ, tɛɛm bə jɨ́ tɛɛm bə jɨ́, Sɔ́ɔ́ŋgʉ́ waam jɨ́ gwɔ́w yɛ́ nyə é yə bwo gwo. ");
INSERT INTO mcp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nəcé kʉ́l búúd obá ŋkí olɔ́ɔl bwə́ mə́ sɛɛŋgya shú dâm dɨ́ yí, sə́nɔ́ŋ nə bwo wə́ bʉ́sə́ cínɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pyɛ̂r nyə á ka shísh wə́ Yésus, kə jí nyə nə́: «Cwámba e, ŋkí mínyɔŋʉ̂ waamə́ mə sá mə məbɔ̂w, mə́ jəlá nə juu nyə ija inɛ́? Ye ija zaŋgbá?» ");
INSERT INTO mcp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yésus mú bɛ̧sa nə́: «Mə acɨ́yɛ́ nə wo nə́ kə shúg ija zaŋgbá, mə́ cɨ nə́ kə kumə mə́wûm zaŋgbá ija zaŋgbá. ");
INSERT INTO mcp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gwə́ wə́ jɨ́ nə́, Faan á gwɔ̂w dʉ́sə nda yuug ga: wúl njwú-buud í a zə kə sá osɔ́ɔl ɔ́ mə́sáal bɛ́ shitɔ́g. ");
INSERT INTO mcp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ja á mə́ ŋgə sá shitɔ́g wɔɔŋg yí, ŋgwɔ́l sɔ́ɔl mə́sáal músə biil nə mpwə́lá ŋkí jág bulya *mwaanɛ̂, tâŋ bʉ́sə́ nə ŋkul jə́na nə ibwêy otɔ́ɔ́shin otɔ́ɔ́shin yí. ");
INSERT INTO mcp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nda sɔ́ɔl məsáal ɛ́nɛ nyə á shígɛ́ bə nə ŋkul nyiŋg mpwə́lá nə́, mása músə cɨ nə́ bwə́ bííg nyə nə mudá nə bwân bɛ́ bɛ̂sh, bwə́ kúshag bwo, tɛɛm bə ísâ byáŋ byɛ̂sh, mwaanɛ̂ wɔɔŋgʉ̂ zə́g jə́na mpwə́lá. ");
INSERT INTO mcp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sɔ́ɔl məsáal ɛ́nɛ músə zə kə́sʉwa mása yé shí məkuú, zə jəgʉla nə nyə nə́: “Dá, jísɔ́wʉ́g mə, mə é jə́na wo mpwə́lá nɨ nyɛ̂sh.” ");
INSERT INTO mcp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iŋkúŋkwoŋ í músə bii mása lâm, a músə bɨ́d nyə nə mpwə́lá nyɛ̂sh, kú ná jí tɛɛm bə sâ. ");
INSERT INTO mcp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ja sɔ́ɔl məsáal ɛ́nɛ mə́ wɔ́ɔ́s tɔ́ɔ́n yí, a mə́ bwəma nə ŋgwɔ́l shwə́ yé bá bwə́ á dʉ sɛ̂y yɛ́, nyə á bə nə nyə mwaanɛ̂ njɨ odanarî təd. A músə bii shwə́ yé ɛ́nɛ cʉ́ŋʉ́d, yɨ́ɨ́mbʉli nyə nə́: “Nyiŋgʉ́g mə mwaanɛ̂ waam yɛ̂sh.” ");
INSERT INTO mcp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Shwə́ yé músə tɛ́ɛ́g nyə məbwə̂ nə́: “Jísɔ́wʉ́g mə, mə é jə́na wo mpwə́lá nywô.” ");
INSERT INTO mcp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Njɨ sɔ́ɔl məsáal ɛ́nɛ kú magʉlə. A mú kənd shwə́ yé mímbwug dɨ́ shú nə́ a jə́nág nyə mpwə́lá nyɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ja bɔ́ɔ́l óshwə́ báŋ bə́nɔ́ŋ bwə́ á dʉ sɛ̂y wá bwə́ mə́ dʉ́g sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂ yí, bwə́ mú bul gwág cɛy lámʉ́d, bwə́ mú kə jaaw mása wáŋ sâ í mə́ sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nə́ ndɛɛ́ mása músə jɔ̂w nyə, zə cɨ nə nyə nə́: “Wo jɨ bɔ́w-bɔ̂w sɔ́ɔl məsáal. Mə ámə bɨ́d wo nə mpwə́lá nywô nyɛ̂sh, mə yîl lâm nəcé nda wo ámə tɛ́ɛ́g mə məbwə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ŋgaá, wo ámə jəlá nə gwág shwə́ woó ŋkúŋkwóŋʉ́lə nə́mə́ nda mə ámə gwág wo ŋkúŋkwóŋʉ́lə nə́.” ");
INSERT INTO mcp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mása yé músə kɛɛnzh nyə nə wəálal-məbag nə́ a fwóg nə́mə́ nyiŋg nyə nyɛ́ mpwə́lá nyɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ntɔ́ nə́mə́ wə́ Dâ á gwɔ̂w mə́ bá dʉ sá bɨ yɛ́, ŋkí bɨ mə bə́ kú dʉ juu ómínyɔŋʉ̂ bʉ́n ijuugá nə́ bɨ yîl lâm kandʉgə.» ");
INSERT INTO mcp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ja Yésus nyə á shîn lás ntʉ́nɨ yí, nyə á ka wú shí á Galilê, kə shí á Yudéa, Zhurdɛ̧̂ faŋwíny. ");
INSERT INTO mcp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Buud bwə́ á bɛ̧ nyə nûŋ ŋkí jág bulya, a mú ŋgə lwag mímbə̂l myáŋ, mí shîn ŋgə yâl. ");
INSERT INTO mcp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bɔ́ɔ́l *Ofarizyɛ̂ŋ bwə́ á zə kə nyə́dɨ́, kə bwɔ́wʉlə nyə, bwə́ nə́: «Ye məcɛ̧ɛ̧ míshé mə́ ŋgə cɨ nə́ muud jɨ nə ŋkul yîl múdá yé bâ nə mbií mə́byaagʉlə wɛ̂sh?» ");
INSERT INTO mcp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A mú bɛ̧sa nə bwo nə́: «Bɨ a fwóyɛ́ lɔ̧̂ mícilyád nə́ ja Zɛmbî nyə á tɛ́ isâ byɛ̂sh yí, nyə a sá mudúm bá mudá, ");
INSERT INTO mcp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","a músə cɨ nə́: “Nda mə mə́ sá bwo ntʉ́nɨ́ nə́, mudúm mə́ bá lʉ́gə sɔ́ɔ́ŋgʉ́ bá nyɔɔŋgʉ̂, a kə leedya nə mudá yé, bá obá bwə́ mú bə nyúul ŋgwúdʉ̂.” ");
INSERT INTO mcp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ntɔ́ jɨ nə́ bwə́ cúgɛ́ ná búúd obá, bwə́ músə muud ŋgwúd. Muud nyə ajə́láyɛ́ nə ka bɛ́ɛ́g sá Zɛmbî mə́ laad yí.» ");
INSERT INTO mcp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ofarizyɛ̂ŋ bwə́ mú nyiŋgə jí nyə nə́: «Ká nəcé jɨ́ Moyîz nyɛ nyə á cilə nə́ múúd mə ká cɛɛl yîl múdá yé bâ, a yə nyə kálaad məgwú mə́ bâ yí?» ");
INSERT INTO mcp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yésus mú bɛ̧sa nə́: «Moyîz nyə á magʉlə nə́ muud jéég yîl múdá yé bâ nəcé lal bɨ́ mílâm. Í á shígɛ́ dʉ fwo sɨ̂y ntɔ́ mə́tɛ́ɛ́dʉ́léd. ");
INSERT INTO mcp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mɛɛ mə́ ka jaaw bɨ́ nə́, ŋkí muud mə yíl múdá yé bâ, mudá kú fwo sá mínɔɔmb, a bâ múdá shús ɨɨ́, muud wɔɔŋg mə́ sá mínɔɔmb.» ");
INSERT INTO mcp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","*Ompwíín bɛ́ bwə́ mú lás nə́: «Ŋkí ntʉ́nɨ wə́ cɛ̧ɛ̧ lʉ bâ í dʉ bii múdúm yɛ́, í yidá bul jəla nə́ buud bwə́ jíg kú béya.» ");
INSERT INTO mcp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A mú bɛ̧sa nə bwo nə́: «Buud bɛ̂sh dɨ́ bɨ́ nə ŋkul gwág lə́sʉ́ ga, njɨ bɔɔŋg Zɛmbî mə́ yə ŋkûl nyɔɔŋg wá. ");
INSERT INTO mcp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nəcé bɔ́ɔ́l búúd bwə́ njul mimyáágə́ zhu byélé dáŋʉ́d; bɔ́ɔ́l bwə́ á sɨ̂y mimyáágə́ kukúg; bɔ́ɔ́lʉ́gá bâŋ bwə́ njul nda mimyáágə́ shú nə́ bwə́ mpúg wá milâm Faan á gwɔ́wʉ́d. Múúd jɨ́ nə ŋkul gwág yɛ́, a gwág.» ");
INSERT INTO mcp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bɔ́ɔ́l búúd bwə́ á ka zə nə ikʉ́kágə́ wə́ Yésus nə́ a bə́dʉg byo məbwə̂, sá məjəgʉla shú dáŋʉ́d. Njɨ *ompwíín bwə́ mú lás nə bwo. ");
INSERT INTO mcp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yésus músə cɨ nə́: «Bɨ́dʉ́gá ikʉ́kágə́ í zə́g mə́dɨ́, kúgá kaambʉlə nə bwo, nəcé Faan á gwɔ́w dʉ́sə sâ á mbií búúd wáŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A mú bəd bwo məbwə̂ nə́ ndɛɛ́ a mú cɔ̧́ cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ŋgwɔ́l múúd nyə á ka shísh wə́ Yésus zə jí nyə nə́: «Yɨ́ɨ́gʉli, jáyɛ́ jɔ̧ sâ mə́ sáág shú nə́ mə bə́g nə cʉg á kandʉgə kandʉgə yí?» ");
INSERT INTO mcp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yésus mú cɨ nə nyə nə́: «Nəcé jɨ́ wó zə́ jí mə njígá shú jɔ̧ sâ yí? Muud ŋgwúd wə́ jɨ́ jɔ̧ múúd. Ŋkí wó cɛɛl nyíi cʉg dɨ́ ság nda məcɛ̧ɛ̧ mə́ ŋgə́ cɨ nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nyə nə Yésus nə́: «Máyɛ́ mə́cɛ̧ɛ̧?» Yésus nə́: «Kú gwú múúd, kú sá mínɔɔmb, kú júwo, kú yə múúd mpwɛnɛ sá nyə́ ampúyɛ́ yí ");
INSERT INTO mcp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gúmal sɔ́ɔ́ŋgʉ́ woó nə nyɔɔŋgʉ́ woó, ka nə́mə́ cɛɛl múúd yɛ̂sh jísə́ wo kúnə́-kúnə yɛ́ nda wó cɛ́ɛ́l wómɛ́fwó nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ncwə́má nɨ nə Yésus nə́: «Mə ŋgə bwey bɛ̧ məcɛ̧ɛ̧ mə́nɨ mɛ̂sh. Gúl jɨ́ í ŋgə́ nâ fúfə mə yí?» ");
INSERT INTO mcp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yésus mú cɨ nə nyə nə́: «Ŋkí wó jɨɨ́ mpu bə nda Zɛmbî mə cɛ́ɛl nə́, kaá kusha ísâ byɛ̂sh wó jɨ́ nə ndɨ̂ yí, wo yə mímbúmbúwá *mwaanɛ̂ wɔɔŋgʉ̂, wo ka bá kə bə nə məbii gwɔ̂w; ság ntɔ́ wo ka zə bɛ̧ mə.» ");
INSERT INTO mcp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Njɨ ncwə́má dɔɔŋg mə́ gwág ntʉ́nɨ yí, a mú shúsʉla, a mú ntâg kyey, nəcé nyə á bə nə zhwog məbii. ");
INSERT INTO mcp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yésus mú cɨ nə ompwíín bɛ́ nə́: «Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, jísə kwowʉlálə nə́ buud bɨ́ nə məbii wá bwə́ nyííg Faan á gwɔ́wʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mə́ nyiŋgə jaaw bɨ nə́, í yida nywá bə kúnə́-kúnə nə́ *shamô nyííg luun lʉ́ ndundu dɨ́, ntɔ̧ nə́ muud á bulya məbii nyííg Faan á gwɔ́wʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Njɨ ómpwíín bwə́ á gwág ntʉ́nɨ yí, bwə́ á bul káam, bwə́ nə́: «Ká zə́ jɨ́ nə ŋkul *dʉ́g cʉg yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yésus mú kənd mísh bwə́dɨ́, a mú cɨ nə bwo nə́: «Muud cugɛ́ nə ŋkul sá jínɨ jâŋ, njɨ Zɛmbî nywáá jɨ nə ŋkul sá sâ jɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pyɛ̂r mú ka cɨ nə Yésus nə́: «Sə́ buud sə́ á mə́ shîn lʉ́gə ísâ byɛ̂sh, sə́ zə bɛ̧ wo wá, í bá ka bə nə sə́ bâŋ ntʉdɛlɛ?» ");
INSERT INTO mcp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yésus mú bɛ̧sa nə bwo nə́: «Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, ja ísâ byɛ̂sh í bá bə ógúgwáan yí, ja *Mwân mə Múúd mə bá ji nyə́dɨ́ *caaŋgə́ á milwanə́d yí, bɨ báá buud ŋgə́ bɛ̧ mə wá, bɨ mə bá ji bín ícaaŋgə́ wûm nə íbáád, bɨ́ ka sámb íbɛɛnd wûm nə íbá yâ *Izʉrəyɛ̂l milə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ŋkí muud mə sá nə́, tɔɔ minjɔ́w, tɔɔ məshí, tɔɔ omínyɔŋʉ̂, tɔɔ okɔ́ɔ́l, tɔɔ sɔ́ɔ́ŋgʉ́, tɔɔ nyɔɔŋgʉ́, tɔɔ bwân, a lʉ́gə́ byo shú dâm, a bá nyiŋgə bií byo, sâ ŋgwúd ija təd; muud wɔɔŋgʉ̂ ka bá kə cʉgə cʉg á kandʉgə kandʉgə dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bɔ́ɔ́l ncúlyá buud bwə́ tə́l shwóg wá, bwə́ bá tɔ̂w mpʉ́sə, bɔɔŋg bwə́ tə́l mpʉ́sə wá, bwə́ bá tɔ̂w shwóg.» ");
INSERT INTO mcp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Faan á gwɔ̂w dʉ́sə nda lâŋ ga: ŋgwɔ́lʉ́gá múúd nyə á bə nə fambə́ *vînyə. Muud wɔɔŋgʉ̂ nyə á ka jɔ́ɔ́g mpʉ́mán mpʉ́mán nə́ a kə́ sɔ̧́ búúd bwə́ kə́g sɛ̂y nyə́dɨ́ fambə́. ");
INSERT INTO mcp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bə́nɔ́ŋ bwə́ mú kwambʉlə nə́ a bá jə́na nə bwo *danarî ŋgwúd ŋkúmba jwɔ̂w nda í dʉ bwey bə nə́, a músə kənd bwo ísɛ́yʉ́d nyə́dɨ́ fambə́. ");
INSERT INTO mcp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Muud ɛ́nɛ mú nyiŋgə wɔ́ɔ́s ŋgɛɛ mə́wəla ibuú. A mú dʉ́g bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́sáal bwə́ njúl tâm də́nd kú nə sâ bwə́ sáag yí. ");
INSERT INTO mcp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A mú cɨ nə bwo nə́: “Kəgá nə́mə́ sɛ̂y mə́dɨ́ fambə́, mə é yə bɨ́ sâ í jə́la yí.” ");
INSERT INTO mcp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bʉ́nɨ bwə́ mú kə. A mú nyiŋgə wɔ́ɔ́s ŋgɛɛ tɔ́lɔ́g dɨ̂, a nyiŋgə nə́mə́ wɔ́ɔ́s ŋgɛɛ mə́wəla məlɔ́ɔl, a ŋgə́ nə́mə́ kənd buud fambə́. ");
INSERT INTO mcp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ŋgɛɛ mə́wəla mətɔ́ɔn mâ mpwó-kugʉ́, a mú nyiŋgə wɔ́ɔ́s, a mú kə kwey bɔ́ɔ́l bwə́ tə́l nə́mə́ tâm də́nd. Nyə nə bwo nə́: “Nəcé jɨ́ bɨ́ mə́ shínal jwɔ̂w ncindî na kú nə sâ bɨ́ ŋgə́ sá yí?” ");
INSERT INTO mcp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bwə́ mú bɛ̧sa nə nyə nə́: “Nəcé kú nə muud mə́ ŋwá sə́ ísɛ́yʉ́d.” Nyə nə bwo nə́: “Kəgá nə́mə́ sɛ̂y mə́dɨ́ fambə́.” ");
INSERT INTO mcp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Ja kugʉ́ í á zə bii shí yí, amə́dɨ́ fambə́ mú cɨ nə muud nyə́ á dʉ vyee nyə jús ísâ dɨ́ yɛ́ nə́: “Jɔ́wʉ́g ósɔ́ɔl ɔ mə́sáal, wo yə́g bwo myə́na myáŋ. Wo é tɛ́ɛ́d nə bɔɔŋg bwə́ ámə shúgʉla zə jé mpʉ́mpʉ́sə́ wá, wo ka kə shúgʉla nə bɔɔŋg bwə́ ámə tɛ́ɛ́d zə shúshwóógʉ́ wá.” ");
INSERT INTO mcp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bɔɔŋg bwə́ á ŋwa isɛ́y ŋgɛɛ mə́wəla mətɔ́ɔn dɨ́ wá, bwə́ mú ŋwa myə́na myáŋ, muud yɛ̂sh danarî ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bɔɔŋg bwə́ á tɛ́ɛ́d zə shúshwóógʉ́ wá bwə́ mú shísh jáŋ ja, bwə́ ŋgə́ tə́dʉga nə́ myáŋ myə́na mí é ŋwá bulya; njɨ bwə́ mú nə́mə́ ŋwa muud yɛ̂sh danarî ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ja bʉ́nɨ bwə́ mə́ lə́g bímbí dɔɔŋg yí, bwə́ mú ŋgə cwadʉga nə amə́dɨ́ fambə́. ");
INSERT INTO mcp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bwə́ nə́: “Bɔɔŋg bwə́ ámə zə mpʉ́mpʉ́sə́ wá, bwə́ mə́ sɛ̂y njɨ wəla ŋgwúd, wo mú yida yə bwo myə́na bímbí ŋgwúd nə sə́, í njúl nə́ sə́ bâŋ sə́ mə́ jísɔw mwásə́ ncindî nə lal-lal yásə́.” ");
INSERT INTO mcp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amə́dɨ́ fambə́ mú bɛ̧sa nə ŋgwɔ́l nə́: “Wɛy, kwába cúgɛ́ na. Ŋgaá shwə́ ámə bwey bə cʉ́ŋ nə́ wo é sɛ̂y mwásə́ ncindî, mə mú yə wo danarî ŋgwúd? ");
INSERT INTO mcp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ŋwagʉ́ kɔw dwô, wo kyéyʉg. Mə́ cɛɛl yə bɨ́ná muud a mpʉ́mpʉ́sə́ bímbí ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nə́ jɨ, mə ajə́láyɛ́ nə sá byɔɔg dâm nda mə́ cɛ́ɛl nə́? Ye wo gwág bɔ̂w nə mə bə́lə nə jɔ̧ lâm?” ");
INSERT INTO mcp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ntɔ́ nə́mə́ wə́ búúd wâ mpʉ́sə bwə́ bá tɔ̂w shwóg, bɔɔŋg wâ shwóg tɔ̂w mpʉ́sə yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yésus nyə á ka ŋgə bád kə Yurʉ́səlɛm; na zhɨ́ɨ́d ɨɨ́, nyə á ŋwa *ompwíín wûm nə óbá bɛ́, a wú nə bwo búúd dɨ́, bə́nɔ́ŋ kə ŋgə kyey koogʉ́, a mú ŋgə jaaw bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Dʉgá, sə́ ŋgə́lə bád kə Yurʉ́səlɛm ɔ́ga; mpugá nə́ *Mwân mə Múúd mə zə́ kə kaanz mə́bwə̂ mə́ mílúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧́d. Bwə́ é cɛ̧ɛ̧lə nyə shwɨy, ");
INSERT INTO mcp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bwə́ mú kɛɛnzh nyə mə́bwə̂ mə́ íkûl ishúsʉ́d nə́ bwə́ kə́g cágʉlə nyə, bwə́ yíd nyə nə milwóŋ, bwə́ bwambʉlə nyə kwolós dɨ̂. Nə́ ndɛɛ́, jwɔ̂w álɛ́ɛl, a bá gwûm shwóŋʉd.» ");
INSERT INTO mcp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Bwân ɔ́ Zhébedé nyɔɔŋgʉ́ wáŋ nyə á ŋwa bwo, bə́nɔ́ŋ ka shísh wə́ Yésus. Nda nyə á ŋgə kə ŋgwóómbʉ́lúd nə́, nyə a kúdɔw shí yə Yésus gúmə́. ");
INSERT INTO mcp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yésus mú jí nyə nə́: «Wó jɨɨ jɨ́?» Nyə nə́: «Yə́g bwân bâm óbá ɔ́ga wáda nə́ bwə́ bâg ji wo, nyíga mbwə̂ məncwûm, nyíga mbwə̂ məkɔ́ɔ́l, Faan dwô dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yésus mú bɛ̧sa nə́: «Bɨ́ ampúyɛ́ sâ bɨ́ ŋgə́ jɨɨ yí. Ye bɨ bɨ́ nə ŋkul ŋgul bálá mə́ wál zə ŋgul yí?» Bwə́ nə́: «Haaw. Sə́ bɨ́ nə ŋkul ŋgul.» ");
INSERT INTO mcp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yésus mú ka cɨ nə bwo nə́: «Jínɨ kɔ́ɔ́mb jɨ́ ntɔ́. Bɨ é bá ŋgul bálá jâm. Njɨ, kɔ́ɔ́mb á nə́ bɨ jíg mə nyíga mbwə̂ məncwûm nyíga mbwə̂ məkɔ́ɔ́l, mə dɨ́ jɨ́ nə ŋkul ŋwa wʉ́nɨ cígʉ́lá, ijiya byɔɔŋg bísə shú bɔɔŋg Sɔ́ɔ́ŋgʉ́ waamə̂ nyə á bwey kwəmʉsa byo wá.» ");
INSERT INTO mcp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ja bɔ́ɔ́l ómpwíín wûm bwə́ á gwág ntɔ́ yí, bwə́ a gwág omínyɔŋʉ̂ óbá bɔɔŋg bɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yésus mú jɔ̂w bwo, lás nə bwo nə́: «Ŋgaá bɨ mə mpú nə́ otɔ́we ɔ shwóg ɔ íkûl ishús bwə́ ŋgə ntɛɛŋg ijwûga byáŋ, ofwó búúd bwə́ ŋgə́ lwóya njɨ mpə̂l. ");
INSERT INTO mcp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Í nda bá dʉ bə ntɔ́ bɨ́ bâŋ dɨ́. Nyɔɔŋg yɛ̂sh mə cɛ́ɛ́l bə fwó múúd gwooŋg jɨ́n dɨ́ yɛ́, yídag sɛ̂y nə bɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nyɔɔŋg mə cɛ́ɛ́l tɔ̂w bɨ́ shwóg yɛ́, bə́g bɨ́ lwaá. ");
INSERT INTO mcp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sâ jɔɔŋgʉ̂ wə́ jísə́ nə́ *Mwân mə Múúd nyəmɛ́fwó nyə a shígɛ́ zə nə́ bwə́ sɛ́yʉ́g nə nyə. Nyə á yida zə sɛ̂y nə buud, a yána nə́mə́ cʉg jé shú nə́ ncúlyá buud bwə́ bə́g ofʉlî.» ");
INSERT INTO mcp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ja bwə́ á ŋgə wú Zheríko yí, buud bwə́ á bɛ̧ Yésus áncuncuma. ");
INSERT INTO mcp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wəancím-ncîm óbá bwə́ á bə zhɨ́ɨ́ dɨ́ koogʉ́, bwə́ mú gwádʉga nə́ Yésus ŋgə cɔ̧́. Bwə́ mú ŋgə kɨ̂m nə́: «Cwámba, Mwân mə *Dávid, bwɨ́ɨ́gʉ́g sə́ nə́ ŋkwoŋʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Buud bwə́ á bə áncuncuma wá bwə́ mú ŋgə ŋkáánd nə bwo nə́ bwə́ jíg kʉ́l-kʉ̂l, njɨ bâŋ bwə́ mú yidá mpu bʉ̂n mə́kə́l gwɔ̂w nə́: «Cwámba, Mwân mə Dávid, bwɨ́ɨ́gʉ́g sə́ nə́ ŋkwoŋʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yésus mú shigʉla, a mú jɔ̂w bwo, jí bwo nə́: «Bɨ mə́ jɨɨ nə́ mə sáág bɨ́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bwə́ nə nɛ́ nə́: «Cwámba, ság nə́ mísh mə́sʉ́ mə́ báŋʉ́g.» ");
INSERT INTO mcp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yésus mú bul gwág bwo cɛy lámʉ́d, a músə kúnya nə bwo mísh; nə́mə́ cé nə cé mísh mə́ mú nyiŋgə dʉ́gya bwo, bwə́ mú bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ja bwə́ á ŋgə shísh kúnə́-kúnə nə Yurʉ́səlɛm yí, bwə́ á kə wɔ́ɔ́s ŋgɛɛ́ Betʉfazhe, *Mbʉ́ŋ wə́olivyê dɨ̂. Yésus mú lwâm *ómpwíín óbá. ");
INSERT INTO mcp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nyə nə bwo nə́: «Kəgá na də́nd á shwóg nɨɨ́d. Í é bə, bɨ́ ká nə́mə́ jé bɨ kwey myɔɔlú jakáás cɛ̧ɛ̧lá, nə mwân yé. Bɨ ɔ́ ciny byo, zə mə nə byo. ");
INSERT INTO mcp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ŋkí muud mə jí bɨ́ sâ, bɨ́ bɛ̧sa nə nyə nə́: “Cwámba wə́ ŋgə́ jɨɨ byo.” Muud wɔɔŋgʉ̂ nyə é lɛɛl nə́mə́ bɨ́d nə́ bɨ zə́g nə byo.» ");
INSERT INTO mcp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Í á sɨ̂y ntɔ́ shú nə́ ciyá mə́ *múúd micúndə́ í bwə́mag nə́: ");
INSERT INTO mcp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cɨgá nə buud ɔ́ Siyôn nə́: «Dʉgá, njwû wʉ́n ŋgə zə bɨ́dɨ́. A jɨ nə lâm nə́ shɛɛ, a mbə́d myɔɔlú jakáásʉd, cwɔ̧ jakáás, mwân cúdú aŋkɛ̂ny mimbag dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ompwíín bwə́ mú nə́mə́ kə sá nda Yésus nyə ámə cɨ nə bwo nə́. ");
INSERT INTO mcp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bwə́ mú zə nə myɔɔlú jakáás nə mwân, bwə́ ŋgə yîl mikáándə́ myáŋ ŋgə jɛɛl bwo míkwoŋʉd. Yésus músə ji gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bɔ́ɔ́l ncúlyá buud bwə́ á bə cínɔŋg wá, bwə́ ŋgə́ taalə mikáándə́ myáŋ zhɨ́ɨ́ nə zhɨɨ́, bɔ́ɔ́l bwə́ ŋgə́ búgə məmpúnzə́ mə́ ílɨ́ɨ́ ŋgə zə taalə zhɨ́ɨ́d. ");
INSERT INTO mcp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Shwɨ́ɨ́nzhá buud bwə́ á ŋgə kə Yésus shwóg wá nə bɔɔŋg bwə́ á ŋgə bɛ̧ mpʉ́sə́ wá bwə́ á ŋgə wá ŋgwa nə́: Hosána nə Mwân mə *Dávid! Gúmə́ í bə́g nə nyɔɔŋg ŋgə́ zə jínə́ mə́ Cwámba dɨ́ yɛ́! Hosána joŋ lʉ gwɔ́w dɨ́ cwû! ");
INSERT INTO mcp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ja Yésus nyə á kumə Yurʉ́səlɛm yí, ŋgwə́la wɛ̂sh í á tɔ̂w otʉ́təlí, buud bwə́ ŋgə́ jí nə́: «Zə́ nyə ɛ́nɛ?» ");
INSERT INTO mcp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bɔ́ɔ́l zhwog buud bwə́ ŋgə́ bɛ̧sa nə́: «Jísə Yésus, *muud micúndə́, muud á Nazarɛ̂t shí á Galilê.» ");
INSERT INTO mcp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yésus mú kə nyíi *Luŋ mə́ Zɛmbî, a mú kə wɨ́ɨ́ŋg búúd bwə́ á ŋgə sá mikus cínɔŋg wá. A shîn lwág ítʉ́wʉli í búúd bwə́ á ŋgə́ sá icɛ́nd í *mwaanɛ̂ wá, nə ishíya í bɔɔŋg bwə́ á ŋgə kusha məfaf wá. ");
INSERT INTO mcp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A mú lás nə bwo nə́: «Jísə cilyá Kálaad Zɛmbî dɨ́ nə́: “Bwə́ bá dʉ jɔ̂w njɔ́w wâm nə́ njɔ́w mə́jəgʉla?” Ká bɨ́ bâŋ mə́ yida sá nə́ í bə́g daagɛ lʉ́ íjúwâl.» ");
INSERT INTO mcp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nə́ ndɛɛ́ wəancím-ncîm nə wa ijâm bwə́ mú shísh nyə́dɨ́ na Luŋ dɨ́ cwû, a músə lwag bwo. ");
INSERT INTO mcp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Njɨ milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á gwág bɔ̂w nə *məshimbá Yésus nyə á ŋgə sá má, bwə́ gwág nə́mə́ bɔ̂w nə iyáŋgá íkʉ́kágə́ í á ŋgə wá Luŋ dɨ́ cwû yí nə́: «Hosána, Mwân mə́ Dávid». ");
INSERT INTO mcp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bwə́ mú cɨ nə nyə nə́: «Ye wo ŋgə nə́mə́ gwág sâ bwə́ ŋgə́ cɨ yí?» Nyə nə bwo nə́: «Haaw. Ye bɨ bâŋ bɨ afwóyɛ́ lɔ̧̂ cilyá ga nə́: “Wo a wéésh gúmə́ mímpu mí íkʉ́kágə́ nə ikény í bə̂l dɨ̂?”» ");
INSERT INTO mcp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nə́ ndɛɛ́ a mú lʉ́gə bwo, wú ŋgwə́la dɨ̂, kə Betanî, kʉ́l nyə́ é jâ yí. ");
INSERT INTO mcp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mpʉ́mán mpʉ́mán, ja nyə á ŋgə kə ŋgwə́la yí, nyə á ka gwág zha. ");
INSERT INTO mcp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A mú dʉ́g shug lʉ *figyê njwóŋ dɨ́ koogʉ́, a mú shísh, a músə kə kwey njɨ ikáá nə ikáá. A músə cɨ nə figyê nə́: «Wo abʉ́lɛ́ ná nyiŋgə bwɛlɛ wúmə tɔɔ bumə́.» Cé nə cé, figyê músə shwáás. ");
INSERT INTO mcp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ja *ompwíín bwə́ mə́ dʉ́g ntʉ́nɨ yí, bwə́ mú bul káam, bwə́ jí Yésus nə́: «Figyê ɛ́ga mə́ ka lɛɛl shwáás cé nə cé ntʉdɛlɛ̂?» ");
INSERT INTO mcp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yésus mú ntâg cɨ nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bɨ mbə̂m bə nə búgə́ kú nə məshwán, bɨ́ sá nə́mə́ sâ mə́ mə́ sá figyê ɛ́ga yí. Kú bə njɨ gwo, bɨ́ jee nə́mə́ cɨ nə mbʉ́ŋ ga nə́: “Tʉ́wʉ́g na, wo kə́g juwa mâŋ”, í bə́lɛ nə́mə́ sɨ̂y ntɔ́.» ");
INSERT INTO mcp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sâ jɛ̂sh bɨ́ mə́ bá gwáámb mə́jəgʉla dɨ́ nə búgə́ yí, bɨ mə bá bii gwo. ");
INSERT INTO mcp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yésus nyə á ka kə nyíi *Luŋ mə́ Zɛmbî dɨ̂, á mú ŋgə yə buud minjɨ́ɨ́gʉ́lá. Nə́ ndɛɛ́, milúlúú myâ ofada nə ocúmbá buud wâ lɔɔm bwə́ mú kə nyə́dɨ́ kə jí nyə nə́: «Nyáyɛ́ ŋkul wó ŋgə́ sá ísâ ínɨ nə ndɨ́ yí? Zə́ nyə ámə yə wo ŋkul nyɔɔŋgʉ̂?» ");
INSERT INTO mcp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A músə bɛ̧sa nə bwo nə́: «Mə zə́ nə́mə́ fwo jí bɨ́ njígá. Bɨ́ mə́ ká bɛ̧sa, mə mú jaaw bɨ́ ŋkul mə́ ŋgə́ sá misɔ́ɔ́lʉ́gʉ́ míga nə ndɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nduwán Yuánɛs nyə á ŋgə duu buud yí, í á bə nə nyáyɛ́ ŋkûl? Ye ŋkul á gwɔ́w wə́ Zɛmbî, ye ŋkul á buud?» Bwə́ mú tə́dʉga nə́: «Ŋkí sə́ mə́ cɨ nə́ “gwɔ́w”, nyə e jí sə́ nə́: “Ká nəcé jɨ́ bɨ́ a shígɛ́ *búgʉla nyə yí?” ");
INSERT INTO mcp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sə́ mə́ ká mɛɛl cɨ nə́ í á bə ŋkul á buud ɨɨ́, ŋkwɛ́ɛ sə̂! Buud bɛ̂sh bwə́ ŋgə magʉlə nə́ Yuánɛs nyə á bə *muud micúndə́.» ");
INSERT INTO mcp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bwə́ mú bɛ̧sa nə Yésus nə́: «Sə́ ampúyɛ́.» A mú nə́mə́ cɨ nə bwo nə́: «Mə ajááwɛ́ nə́mə́ bɨ́ ŋkul mə́ ŋgə́ sá misɔ́ɔ́lʉ́gʉ́ míga nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yésus mú nyiŋgə cɨ nə bwo nə́: «Nda wúga lâŋ bɨ mə tə́dʉga wo nə́ jɨ? Ŋgwɔ́l múúd nyə á bə nə bwân óbá. A músə cɨ nə ashúshwóógʉ́ nə́: “Mwân waam, kaag sɛ̂y fambə́ *vînyə múús.” ");
INSERT INTO mcp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwân mú bɛ̧sa nə́: “Mə acɛ́ɛ́lɛ́.” Njɨ, mpʉ́mpʉ́sə́, a mú cɛ́nd mítə́dʉ́gá, a músə kə fambə́. ");
INSERT INTO mcp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Muud ɛ́nɛ mú lésha nə ŋgwɔ́l mwân mbií ŋgwúd. Nyâŋ mú bɛ̧sa nə́: “Dá, mə zə́ kə.” Njɨ a kú kə. ");
INSERT INTO mcp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bwân óbá ónɨɨ́d, nyáyɛ́ mə́ sá nda sɔ́ɔ́ŋgʉ́ wáŋ nyə ámə cɛɛl nə́?» Bwə́ mú bɛ̧sa nə́: «Ashúshwóógʉ́.» Yésus músə cɨ nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, Oŋwɛnyɛ ɔ́ tóya nə budá bwə́ jáŋgá fʉlî wá bwə́ bá cɔ̧́ bɨ̂, bwə́ kə́ kumə Faan mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nəcé Yuánɛs nyə á zə bɨ́dɨ́, zə lwágʉlə bɨ́ zhɨɨ́ a tʉ́təlí, njɨ bɨ a shígɛ́ *búgʉla nyə. Oŋwɛnyɛ ɔ́ tóya nə budá ɔ́ jaŋga, báá bwə́ á búgʉla nyə. Bɨ á tɛɛm dʉ́g ntɔ́, bɨ a shígɛ́ cɛ́nd mítə́dʉ́gá, búgʉla nyə.» ");
INSERT INTO mcp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Gwágʉ́lə́gá wúl kanda. Ŋgwɔ́lʉ́gá múúd nyə á bə nə shí. A mú sá fambə́ *vînyə, wá gwo luŋgʉla dɨ́. A fáág bɨ́ɨ́ dʉ́lə bá nyáam mpúmə́, a lwɔ̧́ cwámbə́ ísándə́lé, a mú yə búúd fambə́ jɔɔŋg mə́céd. A músə kə njɔɔndʉd. ");
INSERT INTO mcp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ja mə́mwáágʉlə mə́ á wɔ́ɔ́s yí, nyə á kənd ósɔ́ɔl ɔ́ mə́sáal bɛ́ nə́ bwə́ kə́g ŋwa nyə dɛ́ kɔw lʉ mpúmə́ búúd bwə́ á lʉ́g nə fambə́ wá dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Njɨ, buud bɔɔŋgʉ́ bwə́ mú yida kə bii osɔ́ɔl ɔ́ mə́sáal, bwə́ daŋgʉlə cú ŋgwɔ́l, bwə́ gwú ŋgwɔ́l, bwə́ lúmə ŋgwɔ́lʉ́gá məkwóógʉ́ nə́ ndɛɛ́ a fudə. ");
INSERT INTO mcp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Muud fambə́ mú nyiŋgə kənd bɔ́ɔ́lʉ́gá ósɔ́ɔl ɔ́ mə́sáal ŋkí bulya, cɔ̧́ wə́ ashúshwóógʉ̂. Buud bwə́ á lʉ́g nə fambə́ wá bwə́ mú nə́mə́ sá bwo njɨ mbií ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Zhúgʉ́lá zhúgʉ́lâ, a músə kənd mwân yé, a ŋgə́ tə́dʉga nə́ bwə́ é gwɔ̧́ɔ̧ nyə nə́ mwán yé. ");
INSERT INTO mcp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ká, ja búúd bwə́ á lʉ́g nə fambə́ wá bwə́ á dʉ́g mwân ɛ́nɛ yí, bwə́ á ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: “Dʉgá! Muud mə bá lʉ́g nə lʉ́gí ɔ́nɨ. Shé gwúgá nyə, shé bâg lʉ́g nə lʉ́gí jé.” ");
INSERT INTO mcp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bwə́ mú ntâg bií nyə, shɛɛnzh julə wú nə nyə fambə́, kə gwú nyə ncâ.» ");
INSERT INTO mcp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yésus mú jí bwo nə́: «Ja múúd fambə́ mə́ bá zə yí, a bá zə sá búúd bɔɔŋgʉ́ ntʉdɛl?» ");
INSERT INTO mcp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bwə́ mú bɛ̧sa nə nyə nə́: «A bá gwú búúd bɔɔŋgʉ́ kú nə iŋkúŋkwoŋ; a mú ŋwa fambə́ jé, yə búúd oshús, bɔɔŋg bwə́ bá dʉ yə nyə dɛ́ kɔw ja í jə́la wá.» ");
INSERT INTO mcp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yésus mú cɨ nə bwo nə́: «Ye bɨ abwɛ́lɛ́ lɔ̧̂ mícilyá mí Kálaad Zɛmbî dɨ́ nə́: Kwóógʉ́ ólwɔ̧́ye bwə́ á myaas yí, dwó wə́ í mə́ bə kwóógʉ́ lʉ́ lʉ́mʉga. Cwámba sɔ́ɔ́lʉ́gʉ́ yé wə́ nɨ. Jísə *sâ mímbʉ́gú sə́dɨ́ míshʉ́d ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yésus mú nyiŋgə́ cɨ nə bwo nə́: «Gwə́ wə́ mə́ jááw bɨ́ nə́, Zɛmbî mə bá yîl Faan dɛ́ bɨ́dɨ́, a kə nə dwo gúl lwoŋ búúd í é bá mpu wúmə mpúmə́ yííd. ");
INSERT INTO mcp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Muud mə bá bʉ́l kwóógʉ́ dɔɔŋg dɨ́ yɛ́ mə bá kweshʉli búg; nyɔɔŋg kwóógʉ́ dɔɔŋg í bá káda yɛ́ mə bá cugʉli.» ");
INSERT INTO mcp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ja mílúlúú myâ ofada bə́nɔ̂ŋ *Ofarizyɛ̂ŋ bwə́ á shîn gwág mikanda mínɨ yí, bwə́ á ka mpu nə́ bwə́ wə́ Yésus ŋgə́ lás nə ndɨ̂ wá. ");
INSERT INTO mcp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bwə́ mú tɛ́ɛ́d ŋgə́lə sɔ̧́ məzhɨɨ́ nə́ bwə́ bií nyə. Njɨ, bwə́ á ka ŋgə fúndə məŋkúmbə mə búúd nəcé buud bɛ̂sh bwə́ á dʉ ŋwa Yésus nə́ *muud micúndə́ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yésus nyə á nyiŋgə nə́mə́ lás nə bwo míkandad nə́ ");
INSERT INTO mcp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Faan á gwɔ̂w dʉ́sə nda wúl njwú-buud í á kwəmʉsa nə́ a sá mwân yé zaŋ bá yí. ");
INSERT INTO mcp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nyə á ka kənd osɔ́ɔl ɔ́ mə́sáal bɛ́ nə́ bwə́ kə́g jɔ̂w búúd nyə á jɔ̂w zâŋ dɨ́ wá; njɨ buud bɔɔŋgʉ́ bwə́ á shígɛ́ cɛɛl zə. ");
INSERT INTO mcp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A mú nyiŋgə kənd bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́sáal, nyə nə bwo nə́: “Kəgá cɨ nə buud mə́ ámə jɔ̂w wá nə́, mə mə́ shîn kwəmʉsa dína. Mə mə́ cígə íntɛny nə ocúdú wâ məwóŋ. Isâ byɛ̂sh í mú kwəmʉsá, zəgá dínad.” ");
INSERT INTO mcp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Njɨ buud bɔɔŋgʉ́ kú bísh njúwúlú mə cî, bwə́ mú yida ŋgə bwɨ́lya, nyâŋ kə nyə́dɨ́ fambə́, nyâŋ kə mákîd mɛ́d, ");
INSERT INTO mcp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","bɔ́ɔ́lʉ́gá bwə́ bii nə́mə́ *búúd ɔ lwámá ɔ́ cî, bwə́ cúg bwo nə́ ndɛɛ́ gwú bwo. ");
INSERT INTO mcp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Njwú-buud mú gwág mpimbə. A músə kənd ózɨmbɨ bɛ́, kə jaŋgʉlə ógwûl ɔ búúd bɔɔŋgʉ́ nə́ ndɛɛ́ jígal ŋgwə́la wáŋ. ");
INSERT INTO mcp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A músə zə cɨ nə osɔ́ɔl ɔ́ mə́sáal bɛ́ nə́: “Dína í mə́ shîn bə kwəmʉsá, njɨ buud mə́ á jɔ̂w wá bwə́ á shígɛ́ mpíya nə ndɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kəgá mə́maan məmaan, bɨ́ kə́g ŋgə jɔ̂w buud bɛ̂sh bɨ́ é ŋgə kwey wá, bwə́ zə́g zâŋʉd.” ");
INSERT INTO mcp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Osɔ́ɔl ɔ́ mə́sáal ɔ́nɨ bwə́ mú kə mə́zhɨɨ́ məzhɨɨ́, kə ŋgə ŋwa buud bɛ̂sh bwə́ á ŋgə kwey wá, tɔɔ mimbʉ́wʉ́lú tɔɔ ijɔ̧ɔ̧́ í búúd. Njɔ́w zâŋ í mú lwánd nə buud nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Njwú-buud mú zə nyíi njɔ́w zâŋ nə́ a zə́ dʉ́g búúd bwə́ ámə zə njúwúlú dɨ́ wá. A mú ŋgə dʉ́g nə́ ndɛɛ́ a músə kwey ŋgwɔ́l múúd kú nə káándə́ zâŋ. ");
INSERT INTO mcp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A mú cɨ nə muud wɔɔŋg nə́: “Wɛy e, ntʉdɛlɛ́ wo ámə mpu zə wa kú nə káándə́ zâŋ yɛ́?” Muud wɔɔŋg njɨ kʉ́l-kʉ̂l nə́ kufʉg, kú mpu nda á bɛ̧́sag nə́. ");
INSERT INTO mcp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ntɔ́, njwú-buud mú cɨ nə osɔ́ɔl ɔ mə́sáal bɛ́ nə́: “Wálʉ́lə́gá nyə məbwə̂ nə məkuú, bɨ wúsəg nyə tɔ́ɔ́n yídʉ́gʉ́d, kʉ́l á bá kə bə njɨ a ŋgə́ bwam nə məyə̂ yí.” ");
INSERT INTO mcp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ntɔ́, mpugá nə́ njúwúlú wúsə shú búúd ŋkí bulya, njɨ bɔɔŋg bɨ́ fééshá wá bʉ́sə cíg-cîg.» ");
INSERT INTO mcp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nə́ ndɛɛ́ *Ofarizyɛ̂ŋ bwə́ mú kə shwushwagád, kə́lə sɔ̧́ nda bʉ́sə nə ŋkul bwéel Yésus nə́ a bíílʉg nə iciyá byé nə́. ");
INSERT INTO mcp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bwə́ mú ŋwa bɔ́ɔ́l *ómpwíín báŋ nə bɔ́ɔ́l búúd ɔ́ gwooŋg í á dʉ ságʉsə ijwûga í Herod yí, bwə́ mú kənd bwo, bwə́ kə cɨ nə Yésus nə́: «Yɨ́ɨ́gʉli! Sə́ ŋgə mpu nə́ wo jɨ bʉ́bə́lɛ́ muud. Wo ŋgə jɨ́ɨ́gʉli sə́ cʉg á Zɛmbî bʉ́bə́lɛ́. Wo ádɛ́ nə́mə́ bɛɛmb sâ bɔ́ɔ́l búúd bwə́ é cɨ yí, wo kú nə́mə́ bə nə ifwaas nə mbií múúd wɨ́ nə ŋkul tɔ̂w wo míshʉ́d yí. ");
INSERT INTO mcp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ntɔ́, jaawʉg sə̂. Ye məcɛ̧ɛ̧ mə́shé mə́ ŋgə magʉlə nə́ sə́ jə́nag tóya mə *Káázɛl, ye mə́ aŋgɛ̂ nə magʉlə?» ");
INSERT INTO mcp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ká, Yésus nyə á bwey mpu mbíya lâm wáŋ. A mú cɨ nə bwo nə́: «Bɨ mə zə́ bwɔ́wʉlə mə nəcé jɨ, yé búúd ɔ mə́kə́ŋ ɔ́ga? ");
INSERT INTO mcp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lwógá ná mə *mwaanɛ̂ bwə́ dʉ jə́na tóya nə ndɨ̂ yɛ́.» Bwə́ mú zə nyə nə saŋ *danarî. ");
INSERT INTO mcp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A mú jí bwo nə́: «Zə́ jɨ́ nə vʉgʉli mpwoombʉ́ nə jínə́ bwə́ á lúlə wa ga?» ");
INSERT INTO mcp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bwə́ nə nɛ́ nə́: «Jísə Káázɛl». A mú ka cɨ nə bwo nə́: «Yə́gá Káázɛl isâ í Káázɛl, bɨ́ yə Zɛmbî isâ í Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ja bwə́ mə́ gwág mpɛ̧sá nɨ yí, bwə́ mú bul káam bwə́ mú kyey, béégya nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nə́mə́ jwɔ̂w ŋgwúd nɨ, *Osadwisyɛ̂ŋ, buud bwə́ dʉ cɨ nə́ mimbimbə mí ábʉ́lɛ gwûm mə́shwoŋ dɨ́ wá, bwə́ á ka zə wə́ Yésus, zə jí nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Yɨ́ɨ́gʉli, Moyîz nyə á cɨ nə́: “Ŋkí muud mə yə́ kundú, mínyɔŋʉ̂ yé mə́ jəlá nə shúgʉla nə kúsə́ yé, a byág nyɔɔŋg mə́ yə yɛ́ mpwoŋ buud.” ");
INSERT INTO mcp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ká gúl sâ í á bə sə́ wa, bɔ́ɔ́l omínyɔŋʉ̂ bwə́ á byɛ̂l zaŋgbá, budûm nə budûm. Acúmbâ mú bá múdá, a mú yə. Nda nyə á yə kú nə mwân nə́, a mú lʉ́gə mínyɔŋʉ̂ yé nə mudá. ");
INSERT INTO mcp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nyɨ́nɛ mú nə́mə́ yə kú nə mwân, a lʉ́gə ŋgwɔ́l nə mudá. Í á ŋgə kə ntʉ́nɨ nə́ ndɛɛ́, bɛ̂sh zaŋgbá mbií ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mudá mú nə́mə́ zə yə bwə́dɨ́ mpʉ́sə. ");
INSERT INTO mcp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ja búúd bwə́ bá gwûm yí, nyáyɛ́ á omínyɔŋʉ̂ zaŋgbá mə́ bá ka ŋwa mudá? Ŋgaá nə́ bɛ̂sh bwə́ á shí bə ógwúm bɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yésus mú bɛ̧sa nə bwo nə́: «Bɨ́ ŋgə kwab nəcé bɨ ampúyɛ́ sâ Kálaad Zɛmbî ŋgə́ cɨ yí, bɨ kú nə́mə́ mpu mpífə́ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ja búúd bwə́ bá gwûm mə́shwoŋ dɨ́ yí, budúm bwə́ ábʉ́lɛ́ ná bá búdá, budá nda ná kə mə́báád. Bwə́ bá ji nda *wəéŋgəles ɔ́ Zɛmbî bwə́ njúl joŋ dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kɔ́ɔ́mb á mimbimbə bálə gwûm mə́shwoŋ dɨ́, ye bɨ afwóyɛ́ lɔ̧́ sâ Zɛmbî nyə a lás nə bɨ́ yí? Ŋgaá nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Mə jɨ Zɛmbî mə́ *Abʉraham, Zɛmbî mə́ *Izaag, Zɛmbî mə́ *Yákwab.” Ntɔ́ jɨ nə́ Zɛmbî cugɛ́ Zɛmbî mimbimbə, a jɨ yidá bə Zɛmbî á buud bwə́ ŋgə́ cʉgə wá.» ");
INSERT INTO mcp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Məŋkúmbə mə́ búud mə́ á ŋgə gwág nyə má mə́ á ŋgə bul káam njɨ́ɨ́gʉ́lá yé. ");
INSERT INTO mcp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ja *Ofarizyɛ̂ŋ bwə́ mə́ gwág nə́ Yésus mə́ juwal Osadwisyɛ̂ŋ mimpu yí, bwə́ mú sɛɛŋgya nə́ ndɛɛ́ bwə́ mú kə nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ŋgwɔ́l múúd á gwooŋg jáŋ njúl Ŋkumɛ məcɛ̧ɛ̧ mú zə bwɔ́wʉlə Yésus, nyə nə nɛ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Yɨ́ɨ́gʉli, mə́cɛ̧ɛ̧ míshé mɛ̂sh dɨ́, dáyɛ́ í ntɔ̧́ mɔ́ɔ́l mɛ̂sh?» ");
INSERT INTO mcp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yésus mú bɛ̧sa nə nyə nə́: «Wó jəlá nə cɛɛl Zɛmbî woó Yawé nə lâm wô wɛ̂sh, nə *shíshim wô wɛ̂sh, nə lúú wô wɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dʉ́nɨ cɛ̧ɛ̧ wə́ í ntɔ̧́ mɔ́ɔ́l mɛ̂sh, dwó wə́ í tə́l shwóg. ");
INSERT INTO mcp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dɔɔŋg í ká nə́mə́ nyiŋgə bə nda dwo yí, dwó wə́ ga: Wo cɛɛl múúd yɛ̂sh jísə́ wo kúnə́-kúnə yɛ́ nda womɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Məcɛ̧ɛ̧ məbá mə́nɨ wə́ mə́sə́ shug á *mbwoomb mə́cɛ̧ɛ̧ wɛ̂sh nə minjɨ́ɨ́gʉ́lá mí *búúd ɔ mícúndə́ myɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nda *Ofarizyɛ̂ŋ bwə́ á bə sɛɛŋgyá nə́, Yésus mú jî bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Bɨ́ ŋgə ná cɨ *Krîst nə́ jɨ? A jɨ Mwân mə zə́?» Bwə́ nə́: «Mwân mə *Dávid.» ");
INSERT INTO mcp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yésus mú cɨ nə bwo nə́: «Ká ntʉdɛlɛ́ Dávid nə ŋkul mə Shíshim, nyə á jɔ̂w Krîst nə́ Cwámba yɛ́? Ŋgaá Dávid nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Cwámba nyə á cɨ nə Cwámba wâm nə́: “Jigʉ́ shí wa mə́dɨ́ mbwə̂ məncwûm, kə wɔ́ɔ́s ja mə é culʉshi mízhízhíŋ myô, wo nyaál myo nə məkuú yí!” ");
INSERT INTO mcp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ŋkí Dávid mə́ bwey jɔ̂w Krîst nə́ Cwámba, nyə é ka bə Dávid mwân na ntʉdɛlɛ?» ");
INSERT INTO mcp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kú nə muud nyə á bə nə ŋkul bɛ̧sa sâ yɛ́. Tɛ́ɛ́d jwɔ̂w nɨ, muud a shígɛ́ ná bwɛlɛ jí Yésus njígá. ");
INSERT INTO mcp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yésus músə ka cɨ nə məŋkúmbə mə búúd nə *ompwíín bɛ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«*Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ *Ofarizyɛ̂ŋ bwə́ njúl jiya mə́ Moyîz dɨ́ nə́ bwə́ dʉ́g jɨ́ɨ́gʉli búúd məcɛ̧ɛ̧ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ntɔ́, ságá bwo məgwág, bɨ́ bɛ̧ mínjɨ́ɨ́gʉ́lá myáŋ. Njɨ, bɨ kú ŋwa kuú njɔɔnd wáŋ; nəcé bwə́ mpú njɨ məlás, kú ka dʉ sá. ");
INSERT INTO mcp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bwə́ dʉ kɔ̧ɔ̧lə jilə-jilə mímbag, dʉ zhimb búúd záməbag; njɨ bwə́mɛ́fwó kú sʉ́sal tɔɔ nyinə́ nə́ bwə́ kwiy myo. ");
INSERT INTO mcp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Misɔ́ɔ́lʉ́gʉ́ myáŋ myɛ̂sh mísə njɨ dʉ́lə sɔ̧́ mísh. Bwə́ dʉ bweeg byáŋ *íŋgwabí í mə́cɛ̧ɛ̧ ntɔ̧ bɔ́ɔ́l búúd byáŋ. Bwə́ bul nə́mə́ dʉ gweesh myáŋ mímbwaag mi káándə́. ");
INSERT INTO mcp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bwə́ cɛɛl dʉ ji njɨ lúú tʉ́wʉli dɨ́ ja bwə́ dʉ́ kə ídína dɨ́ yí; ja bʉ́sə́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ́ yí, bwə́ cɛɛl kə dʉ ji njɨ íjiya yâ shwóg. ");
INSERT INTO mcp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bwə́ cɛɛl nə́ buud bwə́ dʉ́g bə́da bwo məbə́dá mə́ gúmə́ mə́ŋkúmbə mə búúd dɨ̂. Bwə́ cɛɛl nə́mə́ nə́ buud bwə́ dʉ́g jɔ̂w bwo nə́: *Rabi. ");
INSERT INTO mcp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Njɨ bɨ bâŋ, kúgá sɔ̧́ nə́ buud bwə́ jɔ́wʉ́g bɨ́ nə́: *Rabi nəcé Rabi wʉ́n jɨ́ njɨ ŋgwúd; bɨ bʉ́sə omínyɔŋʉ̂ mpə́dʉ́gá nyɨ́nʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kúgá jɔ̂w múúd shí ga dɨ́ nə́ sɔ́ɔ́ŋgʉ́ waamə́ nəcé sɔ́ɔ́ŋgʉ́ wʉ́n jɨ ŋgwúd, njɨ nyɔɔŋg jísə́ gwɔ́w yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kúgá sɔ̧́ nə́ buud bwə́ jɔ́wʉ́g bɨ́ nə́ omása, nəcé mása jisə ŋgwúd, njɨ *Krîst. ");
INSERT INTO mcp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nyɔɔŋg yɛ̂sh mə́ bul bə fwámɛ́ múúd mpə́dʉ́gá nyɨ́n dɨ́ yɛ́, á jəlá nə sɛ̂y nə bɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Muud mə bʉ̂n nyə́mɛ́fwó gwɔ́w yɛ́, bwə́ bá səl nyə shí; nyɔɔŋg mə sə́l nyə́mɛ́fwó shí yɛ́, bwə́ bá bʉ̂n nyə gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Məntágʉla nə bɨ́ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bɨ́ nə məkə́ŋ. Məntágʉla nəcé bɨ mə́ laa búúd zhɨɨ́ á Faan á gwɔ̂w. Í músə, bɨmɛ́fwó kú nyíi, bɨ́ kú nə́mə́ nyiŋgə bɨ́d nə́ bɔɔŋg bwə́ ŋgə́ cɛɛl nyíi wá, bwə́ nyííg. ");
INSERT INTO mcp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Məntágʉla nə bɨ́ *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bɨ́ nə məkə́ŋ. Məntágʉla nəcé bɨ́ ŋgə mánda mikúsə́ mí búdá nə minjɔ́w myáŋ, bɨ́ ka dʉ sá ígwaa-gwaa í mə́jəgʉla nə́ bwə́ dʉ́gʉ́g nə́ bɨ bɨ́ ijɔ̧ɔ̧́ i búúd. Bɨ mə bá bwəma nə intʉ́gʉ́lí í bá bul nyaan yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Məntágʉla nə bɨ́ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bɨ́ nə məkə́ŋ. Məntágʉla nəcé bɨ́ ŋgə ntɔ̧ míshwû ntɔ̧ mə́kwamb ŋgə́lə sɔ̧́ muud ŋgwúd jɨ́ nə ŋkul cɛ́nd mítə́dʉ́gá zə nyíi mísɔɔn wʉ́nʉ́d yɛ́. Ja bɨ́ mə́ ka jíga dʉ́g mbií múúd wɔɔŋg yí, bɨ mú sá nə́ a bə́g njɨ muud mə jə́lá nə kə kuda á kandʉgəd, nəcé bɨ é sá nə́ a nyíŋgəg bul sá bɔ́w-bɔ̂w ísâ ntɔ̧ bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Məntágʉla nə bɨ̂, wəancím-ncîm bɨ́ mə́ tɔ̂w shwóg nə́ bɨ mə lwágʉlə búúd zhɨɨ́ wá, məntágʉla nəcé bɨ́ ŋgə cɨ nə́ ŋkí muud mə́ kɛɛn *Mpáánzə́ Zɛmbî, sâ nyə́ ámə kɛɛn yí, í cugɛ́ nyə yɨ́ɨ́mbʉ́lí. Njɨ, múúd mə ká kɛɛn or á Mpáánzə́ Zɛmbî, sâ nyə́ ámə kɛɛn yí, jɨ́ nyə yɨ́ɨ́mbʉ́lí. ");
INSERT INTO mcp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yé ímpwúfú íga, wəancím-ncîm ɔ́ga! Jɨ́ í ntɔ̧́ gúlʉ́gá, ye or, ye Mpáánzə́ Zɛmbî í ŋgə́ sá nə́ or bə́g or mə́ Zɛmbî yí? ");
INSERT INTO mcp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bɨ́ ŋgə nə́mə́ cɨ nə́ muud mə ká kɛɛn *alatâr, sâ nyə́ ámə kɛɛn yí, í cugɛ́ nyə yɨ́ɨ́mbʉ́lí. Njɨ, múúd mə ká kɛɛn sâ mə́ Zɛmbî í mbwúg alatâr dɨ́ yí, sâ nyə́ ámə kɛɛn yí, jɨ́ nyə yɨ́ɨ́mbʉ́lí. ");
INSERT INTO mcp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yé wə́ancím-ncîm ɔ́ga! Jɨ́ í ntɔ̧́ gúlʉ́gá, ye sâ í mbwúg alatâr dɨ́ yí, ye alatâr mə sá nə́ sâ jɔɔŋg í bə́g shú mə́ Zɛmbî yí? ");
INSERT INTO mcp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ntɔ́, muud mə kɛ́ɛ́n alatâr yɛ́, á kɛɛn alatâr nə sâ jɛ̂sh í mbwúg alatâr dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Muud mə kɛ́ɛ́n Mpáánzə́ Zɛmbî yɛ́, á kɛɛn Mpáánzə́ Zɛmbî nə Zɛmbî muud njúl cínɔŋg yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Muud mə kɛ́ɛ́n joŋ lʉ gwɔ̂w yɛ́, mə́ kɛɛn jiya ícî mə́ Zɛmbî nə Zɛmbî muud njúl cínɔŋg yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Məntágʉla nə bɨ́ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bɨ́ nə məkə́ŋ. Məntágʉla nə bɨ́ nəcé bɨ́ ŋgə yə Zɛmbî *ŋkɔw wûm á isâ nda mânt nə anis nə kumîn, ikáá bɨ́ mə́ dʉ teegʉshi ídʉ̂w nə ndɨ̂ yí. Njɨ bɨ́ yida mpyêny mɔɔŋg mə́cɛ̧ɛ̧ mə́ búl ntɔ̧ má, nda cʉgə́lə nə buud tʉ́təlí, nə gwágʉ́lə búúd cɛy lámʉ́d nə búgʉ́lálə Zɛmbî. Sâ bɨ́ á jəla nə sá wə́ nɨ, kú yida mpyêny byɔɔŋg bɨ́ ŋgə́ bwey sá yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yé ólwóye ɔ zhɨ́ɨ́ wə́ancím-ncîm ɔ́ga. Bɨ mə́ dʉ sâl mə́lwəg, yîl ncincíŋ jɨ́ cínɔŋg yí, njɨ bɨ́ minə *shamô ncindî. ");
INSERT INTO mcp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Məntágʉla nə bɨ́ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bɨ́ nə məkə́ŋ. Məntágʉla nəcé bɨ́ ŋgə gusa bálá nə shúyá njɨ kwoŋʉd, cwû nyɛ njúl lwándʉ́lá nə isâ í mándá nə ibɔ́w-bɔ̂w ísâ í mə́ ŋwa bɨ́ milâm yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yé áncím-ncîm Farizyɛ̂ŋ! Fwog tɛ́ɛ́d gusa bálá cwû shú nə́ kwoŋ bə́g nə́mə́ ŋkí ŋkɛ̧̂. ");
INSERT INTO mcp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Məntágʉla nə bɨ̂ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bʉ́sə nə məkə́ŋ. Məntágʉla nəcé bɨ bʉ́sə nda məshwoŋ bwə́ mə́ wá fə́m má, ŋkí nywa dʉ́g tɔ́ɔ́n, njɨ cwû njúl lwándʉ́lá nə iyasə́ í búúd nə bíl ísâ í ádʉdanâ mimbií mímbií. ");
INSERT INTO mcp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bɨ bʉ́sə nə́mə́ ntɔ́, mísh mə́ búúd dɨ́, bɨ́ ŋgə nyîn nda buud bʉ́sə́ ótʉ́təlí wá; í njúl nə́ milâm mín mísə bɨ́ nə kwába nə fúlú a kú bísh mə́cɛ̧ɛ̧ nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Məntágʉla nə bɨ̂ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə Ofarizyɛ̂ŋ. Bɨ bʉ́sə nə məkə́ŋ. Məntágʉla nəcé bɨ́ ŋgə lwɔ̧́ məshwoŋ mə *búúd ɔ mícúndə́, bɨ ŋgə́ lugʉshi ikʉ́l otʉ́təlí ɔ́ búúd bwə́ á dɔw yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bɨ́ ŋgə cɨ nə́ bɨ a mbə̂m bə ja impáámbə́ bɨ́n í á cʉgə yí, bɨ a shígɛ́ nywá dʉ wá məbwə̂ kʉ́l bwə́ á dʉ gwú búúd ɔ mícúndə́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ciyá jɨ́n jɔɔŋg í ŋgə bwaagʉlə nə́ bɨ bʉ́sə bwân ɔ́ búúd bwə́ á dʉ gwú buud ɔ mícúndə́ wá. ");
INSERT INTO mcp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ká jɨ, mɛɛlʉgá casʉlə sâ ímpáámbə́ bɨ́n í á tɛ́ɛ́d yí. ");
INSERT INTO mcp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bɨ bʉ́sə mbɛɛ́ ónywâ, iyəlʉkag. Bɨ́ mə bá faam kú kə kuda á kandʉgə dɨ́? Í bá bə ntʉdɛlɛ? ");
INSERT INTO mcp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gwə́ wə́ í bá bə nə́, mə é dʉ ntɨ bɨ́ buud ɔ mícúndə́, mə ntɨ búúd ɔ́ fʉg, ntɨ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧; bɨ mə bá gwú bɔ́ɔ́l, bɨ́ bwambʉlə bɔ́ɔ́l ikwolós dɨ́, bɨ́ yíd bɔ́ɔ́l nə milwóŋ bɨ́dɨ́ mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lád, bɨ mə bá julya nə bɔ́ɔ́l míŋgwə́la miŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Í bá nə́mə́ dʉ sɨ̂y ntʉ́nɨ nə́ ndɛɛ́, otʉ́təlí ɔ́ búúd bɛ̂sh bwə́ á gwúyɔw wá, məcií máŋ shwɨy bɨ́ mílúúd; tɛ́ɛ́d mə́cií mə́ Abɛl, tʉ́təlí múúd, zə wɔ́ɔ́s mə́cií mə́ Zakarî mə́ Baraki bɨ́ á gwú mpə́dʉ́gá Mpáánzə́ Zɛmbî nə alatâr yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kala buud ga í é bwəma nə intʉ́gʉ́lí byɔɔŋg byɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Eéé Yurʉ́səlɛm ŋgə́ gwú *buud ɔ mícúndə́ ɛ́ga! Eéé Yurʉ́səlɛm! Wo ŋgə sá nə́, buud Zɛmbî ŋgə́ ntɨ lwámád wódɨ́ wá, wo ŋgə gwú bwo nə məkwóógʉ́! A bweyʉ́lə mə́ á tɛ́ɛ́d nə́ mə́ sɛɛŋg bwân bwô nda ábiyá kúwó mə́ dʉ sɛɛŋg bwân bɛ́ mə́faafʉgə́ dɨ́ nə́! Njɨ, bɨ kú magʉlə ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ká, dʉgá njɔ́w wʉ́n í zə́ lʉ́g wuul. ");
INSERT INTO mcp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nəcé mə mpú jaaw bɨ́ nə́ tɛ́ɛ́d nə́mə́ kɨ́kɨdɨ́ga, bɨ ákwolɛ́ ná dʉ́g mə. Mə bá nyiŋgə nyîn njɨ ja bɨ́ mə́ bá shwas mə nə́: “Gúmə́ í bə́g nə nyɔɔŋg ŋgə́ zə jínə́ mə́ Cwámba dɨ́ yɛ́”.» ");
INSERT INTO mcp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yésus nyə á ka kyey nə́ a wú *Luŋ mə́ Zɛmbî, cúwo tɔ́ɔ́n. A ŋgə́ kə ntʉ́nɨ, *ompwíín bwə́ mú shísh nyə́dɨ́, kə́lə cɛɛl sá nə́ a dʉ́gʉ́g mbií mə́lwɔ̧́ga búúd bwə́ á lwɔ̧́ cínɔŋgʉ́ Luŋ mə́ Zɛmbî má. ");
INSERT INTO mcp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A mú yida cɨ nə bwo nə́: «Bɨ mə́ dʉ́g dɨ́ isâ ínɨ byɛ̂sh ɨɨ́? Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kú nə kwóógʉ́ í bá lʉ́g í mbə́d dúlʉ́gá na gwɔ̂w. Na yɛ̂sh mə bá bə ícɨɨmí icɨɨmí.» ");
INSERT INTO mcp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","A mú ka kə *Mbʉ́ŋ wə́olivyê dɨ́, kə ji shí. Ompwíín bɛ́ bwə́ mú shísh nyə́dɨ́ kə jí nyə bə́nɔ́ŋ bwə́mɛ́ nə́: «Jaawʉg sə̂, isâ ínɨ í bá bə jáyɛ́ ja? Jɨ́ í bá ka lwágʉlə sə́ nə́ wo wál zə, nə́ cʉg á shí ga í wál zə shîn?» ");
INSERT INTO mcp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yésus mú bɛ̧sa nə bwo nə́: «Bɨ ɔ́ bɛy nə́ buud bwə́ bâg shɨɨg bɨ́, bɨ mú bɛ̧ bɔ́w-bɔ̂w zhɨ́ɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nəcé buud ŋkí bulya bwə́ bá dʉ zə nə jínə́ dâm, zə dʉ cɨ nə́: “Mə wə́ Krîst”. Məshɨɨgâ máŋ mɔɔŋg mə́ bá kənd zhwog buud jugʉ́. ");
INSERT INTO mcp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bɨ mə bá dʉ gwág míláŋ mí mɔ́ɔmb, bɨ gwádʉga ncíndə́ dɔɔmb. Bɨ kú bá dʉ kənd mílám gwɔ̂w; í bá jɨɨ nə́ isâ ínɨ í bə́g. Njɨ tɛɛm bə ntɔ́, í ábʉ́lɛ́ fwo bə mə́shíné mə́ shí. ");
INSERT INTO mcp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gúl lwoŋ í bá lúmbʉli nə gúl, dúl faan lúmbʉli nə dúl. Zha á ifií mpu í bá bə bíl íkʉ́lʉ́d, shí í bá nə́mə́ dʉ ntaŋʉsa bíl íkʉ́lʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Isâ ínɨ byɛ̂sh í bá ná bə njɨ mətɛ́ɛ́dʉ́lé mə́ mə́cɛy mə byɛ́yí. ");
INSERT INTO mcp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bwə́ bá dʉ kusha nə bɨ̂ nə́ bɨ bwə́mag nə məntágʉla, bwə́ dʉ gwú bɨ̂. Ilwoŋ byɛ̂sh í bá mpii bɨ́ nəcé jínə́ dâm. ");
INSERT INTO mcp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ntɔ́, zhwog buud bwə́ bá jímb, bwə́ cwagʉwa zhɨ́ɨ́ abʉ́bɔ̂wʉd. Buud bwə́ bá bə, bɔ́ɔ́l kusha nə bɔ́ɔ́l, mpə́dʉ́gá nyáŋʉ́d njɨ zhíŋ nə zhíŋ. ");
INSERT INTO mcp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Zhwog *buud ɔ mícúndə́ ɔ́ məshɨɨgâ bwə́ bá zə, zə sá nə́ buud ŋkí bulya bwə́ bɛ̧́g bɔ́w-bɔ̂w zhɨ́ɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nə́ ndɛɛ́, fúlú á kú bísh mə́cɛ̧ɛ̧ í bá ŋgə mpyáánz, zhwog buud cɛɛlí mú bá ŋgə shîn. ");
INSERT INTO mcp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Njɨ muud mə bá jísɔw kə wɔ́ɔ́s mə́shínéd yɛ́, a bá cʉgə. ");
INSERT INTO mcp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bwə́ bá cúndə Jɔ̧jɔ̧ Kɛ́ɛ́l nɨ kʉ́l jɛ̂sh shú nə́ ilwoŋ byɛ̂sh í gwágʉ́g; nə́ ndɛɛ́ məshíné mə́ músə bə. ");
INSERT INTO mcp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Gwə́ wə́ jɨ́ nə́, bɨ mə bá dʉ́g ájəlʉŋkúŋkwɔ̧ múúd micúndə́ Danyɛ̂l nyə á bwey jaaw yɛ́. Ja á bá kə ŋwa jiya kʉ́l í búl bə ci yí, muud ŋgə́ lɔ̧́ cilyá ga yɛ́, kə́ mpú gwág! ");
INSERT INTO mcp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ja bɨ́ mə́ bá dʉ́g ísâ byɔɔŋg yí, buud bwə́ bá bə Yudéa wá, bwə́ bâg fúndə, kə mímbʉ́mbʉ́ŋʉ́d! ");
INSERT INTO mcp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Muud mə bá bə kwáminʉ́ yɛ́ kú bá shulə nə́ a kə́ njɔ́w kə ŋwa sâ. ");
INSERT INTO mcp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nyɔɔŋg mə bá bə fambə́ yɛ́, kú ná kwo kə kwáádə́ nə́ a kə́ ŋwa kúúd. ");
INSERT INTO mcp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ŋkwɛ́ɛ budá bwə́ bá bə nə məbum, nə bɔɔŋg bwə́ bá ŋgə nyɛ́ɛ́ŋg bwân mwɔ̂w mɔɔŋg dɨ́ wá! Bwə́ bá bul ŋkúŋkwoŋ. ");
INSERT INTO mcp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jəgʉlagá nə Zɛmbî nə́ mitúbʉ́g myɔɔŋg mí kú bá bə bɨ́ ŋkwánʉ́d, ŋkí jwɔ̂w lʉ́ Sábaad. ");
INSERT INTO mcp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nəcé *incwaw í ntʉg í bá bə mwɔ̂w mɔɔŋg dɨ́ mbií í abwɛ́lɛ́ bə té shí í á tɛ́ɛ́d yí. Bíl í ábʉ́lɛ́ kwo bə mbií wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Í á mbə̂m bə Cwámba kú cunal mwɔ̂w mə́ incwaw í ntʉg mɔɔŋgʉ̂, tɔɔ muud kú faam. Njɨ a bá cunal mwɔ̂w mɔɔŋgʉ̂ nəcé buud á mə́ bwey fɛ́ɛ́sh wá. ");
INSERT INTO mcp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Ntɔ́, ŋkí ŋgwɔ́l múúd mə́ cɨ nə bɨ́ nə́: “Dʉgá! Mesî jisə wa”, ŋkí nə́: “a jisə wá”, kúgá magʉlə. ");
INSERT INTO mcp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nəcé omesî ɔ́ mə́shɨɨgâ nə buud ɔ mícúndə́ wâ məshɨɨgâ bwə́ bá dʉ wɔ́ɔ́s. Bwə́ bá dʉ sá məma *mə́shimbá, nə *isâ í mímbʉ́gú mbií wúsə́ nə́ ŋkí gúl sâ jɨ́ nə ŋkul bə ntɔ́, buud Zɛmbî mə́ bwey fɛ́ɛ́sh wá bwə́ bɛ̧ bɔ́w-bɔ̂w zhɨ́ɨ́. ");
INSERT INTO mcp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bɨ ɔ́ bɛy! Mə mə́ bwey jaaw bɨ́ wə́ nɨ. ");
INSERT INTO mcp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bwə́ ká cɨ nə bɨ́ nə́: “Dʉgá, Mesî jɨ nûŋ shí a shwééshád”, bɨ kú kə wu. Ŋkí bwə́ cɨ nə́: “A jɨ ká nyúl fúmʉ́d”, shwánágá, bɨ kú magʉlə, ");
INSERT INTO mcp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","nəcé *Mwân mə Múúd mə bá zə nda njəs í dʉ yas kɔ́ɔ́mb jwɔ̂w í dʉ cúwo yí, í nyîn kɔ́ɔ́mb jwɔ̂w í dʉ jímə yí. ");
INSERT INTO mcp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kʉ́l mbimbə wúsə́ yí, cínɔŋg wə́ ómpal ɔ́ dʉ sɛɛŋgya yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Í bá bə, mwɔ̂w mə́ incwaw í ntʉg mɔɔŋg mə́ ká nə́mə́ shîn cɔ̧̂, jwɔ́w í bá shila nə́ ŋkwed kú ná kwo faan; ŋkwoond kú ná wééshʉli mə́ŋkɛnya; wəacén-cénî bwə́ bá dʉ bí shí; isâ byɛ̂sh bísə́ nə mpífə́ joŋ dɨ́ yí í bá kúŋgʉla. ");
INSERT INTO mcp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ja jɔɔŋgʉ̂, sâ í bá lwágʉlə nə́ Mwân mə Múúd wál zə yí í mú cúwo joŋ dɨ̂; ikûl í búúd byɛ̂sh yâ shí ga í mú ŋgə tədʉwa; bwə́ músə dʉ́g Mwân mə Múúd ŋgə́ zə míŋkúdʉ́d, a zág nə mpífə́ nə milwanə́. ");
INSERT INTO mcp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A bá ntɨ *wə́éŋgəles bɛ́ nə məmá laag í dʉ lás nə ŋkulú yí, bwə́ zə sɛɛŋg búúd Zɛmbî nyə á fɛ́ɛ́sh wá, ikɔ́ɔ́mb ínɔ̧́ byɛ̂sh, tɛ́ɛ́d bíl íjumə í shíd kə wɔ́ɔ́s bílʉ́gád. ");
INSERT INTO mcp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ŋwagá fʉg nə yuug bɨ́ mə́ dʉ dʉ́g nə lɨ́ɨ́ *figyê yí. Í dʉ bə, ja mpúnzə́ nyɛ́ í mú nə́ bud-bud, məncuug mə́ agúgwáan mə́ ŋgə́ kɔ̧́ yí, bɨ́ mú mpu nə́ ompú bwə́ mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ntɔ́ nə́mə́, ja bɨ́ mə́ bá dʉ́g ísâ byɔɔŋg byɛ̂sh í ŋgə́ sɨ̂y yí, mpugá nə́ zɨ́yé mə́ Mwân mə Múúd í mú kúnə́-kúnə, í mú cé mə́yíndə mə nyâ. ");
INSERT INTO mcp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kala búúd ga í ábʉ́lɛ́ cɔ̧́, isâ ínɨ byɛ̂sh kú fwo sɨ̂y. ");
INSERT INTO mcp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gwɔ́w nə shí í bá cɔ̧́, njɨ iciyá byâm kú cɔ̧̂.» ");
INSERT INTO mcp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Shú sâ í dʉ́gyá nə jwɔ̂w nə wəla ísâ byɔɔŋg í bá sɨ̂y yí, kú nə muud mə mpû; tɛɛm bə wə́éŋgəles bʉ́sə́ wə́ Zɛmbî wá bwə́ ampúyɛ́; tɛɛm bə Mwân nyə ampúyɛ́; njɨ Sɔ́ɔ́ŋgʉ́ wə́ mə́ mpû. ");
INSERT INTO mcp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ja *Mwân mə Múúd mə bá zə yí, isâ í bá sɨ̂y nə́mə́ nda í á sɨ̂y ja mə *Nówe dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Shúshwóógʉ́ nə́ mpʉŋ í búdálʉ́g shí nyɛ̂sh, buud bwə́ á dʉ də, dʉ ŋgul, bwə́ béya, bɛ́lʉshi nə́mə́ bwân báŋ nə́ ndɛɛ́ kə wɔ́ɔ́s jwɔ̂w *Nówe nyə a nyíi məma byɔ́ɔ́l dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Buud bwə́ á shígɛ́ dʉ bɛɛmb tɔɔ sâ, kə wɔ́ɔ́s ja mpʉŋ í á zə jaŋgʉlə bwo bɛ̂sh yí. Ntɔ́ nə́mə́ wə́ í bá bə ja Mwân mə Múúd mə bá zə yí. ");
INSERT INTO mcp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Í bá bə, budûm óbá bwə́ ŋgə́ sɛ̂y fambə́, ŋgwúd ŋwiny, ŋgwɔ́l lʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Budá óbá bwə́ ŋgə́ jí isâ kwóógʉ́ ŋgwúd dɨ́, ŋgwúd ŋwiny, ŋgwɔ́l lʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Ntɔ́, jigá ŋkasə̂! Bɨ ampúyɛ́ jwɔ̂w Cwámba wʉ́n mə́ bá zə yí. ");
INSERT INTO mcp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mpugá nə́ amə́dɨ́ njɔ́w mbə̂m dʉ mpu wəla lʉ búlú júwâl í é zə yí, ŋki á dʉ ji ŋkasə̂, a kú bɨ́d nə́ júwâl í búgə́g nyə njɔ́w, júwo ísâ. ");
INSERT INTO mcp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ntɔ́, bɨ mə́ jə́lá nə dʉ ji ŋkwəmʉsá, nəcé Mwân mə Múúd mə bá zə wəla bɨ́ abʉ́lɛ́ ŋgə tə́dʉga nə́ nyə é zə yí.» ");
INSERT INTO mcp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Wáyɛ́ sɔ́ɔl məsáal wúsə́ abúgʉ́lág a njúl ŋkí kɛ̧̂ mása mə́ tə̂l nə́ a bə́g lúlúú á buud ɔ njɔ́w a dʉ yə bwo idʉ̂w wəla i jə́la yí? ");
INSERT INTO mcp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sɔ́ɔl məsáal wɔɔŋg nywá mə́ jəla nəcé mása nyə é zə kwey a ŋgə́ sá isɛ́y byé. ");
INSERT INTO mcp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, mása nyə é jil nyə nə́ a jwúg nə bíl ísâ í njɔ́w byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Njɨ ŋkí a jisə bɔ́w-bɔ̂w sɔ́ɔl məsáal, nyə é cɨ nə́: “Cwámba waamə́ nyə álɛɛlɛɛ́ nyiŋgə”. ");
INSERT INTO mcp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nə́ ndɛɛ́ a mú ka ji yídʉ́lə búúd bə́nɔ́ŋ bwə́ ŋgə́ sɛ̂y wá, nə də́lə dəg, bə́nɔ̂ŋ oshwégye ɔ́ mə́lwəg njɨ ŋgə́lə ŋgul. ");
INSERT INTO mcp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mása yé mə́ bá zə wɔ́ɔ́s nyə dúl jwɔ́wʉ́d məseegyâ, wəla á shígɛ́ ŋgə tə́dʉga yí. ");
INSERT INTO mcp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mása nyə é yə nyə intʉ́gʉ́lí í ányinyaanə̂, a kənd nyə kʉ́l búúd ɔ́ məkə́ŋ bwə́ ŋgə́ bwəma nə ŋkʉ̂d yí; nyə é bə cínɔŋgʉ́, njɨ a ŋgə́ bwam nə məyə̂.» ");
INSERT INTO mcp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ntɔ́, Faan á gwɔ́w í bá bə nda lâŋ ga: oncwíyɛ̂ ɔ́ mə́sás wûm mə́ á ŋwa məlámba, zə kə nə́ mə́ kə́ lə́g múúd nyə á bə nə́ a zə́ bwéémb shwə́ wáŋ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mə́sás wûm mə́nɨ dɨ́, mə́tɔ́ɔn mə́ á bə ilad, mə́tɔ́ɔn okə́ŋ. ");
INSERT INTO mcp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mɔɔŋg mə́ á bə ilad má mə́ á ŋwa məlámba kú bwey ŋwa mɔ́ɔ́l mə́wúdə kə nə mwo. ");
INSERT INTO mcp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Njɨ okə́ŋ bá, bwə́ á ŋwa məlámba, bwə́ kə nə́mə́ nə ifuundú í mə́wúdə nə́ bwə́ bá kə ŋgə kwádʉlə. ");
INSERT INTO mcp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Muud nyə á bə nə́ a zə́ bwéémb múdá yɛ́, nyə á shígɛ́ jɔ̧́wa zə; məsás wûm mə́nɨ mɛ̂sh mə́ mú tag nə jiya nə́ ndɛɛ́ mə́ shîn kə gwə́d. ");
INSERT INTO mcp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tâm bulú, cúndə́ í mú sɨ̂y nə́: “Muud bá wə́ zág ɛ; kəgá lə́g nyə!” ");
INSERT INTO mcp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oncwíyɛ̂ ɔ́ mə́sás wûm mə́nɨ mɛ̂sh mə́ músə juum, mə́ ka zə kwəmʉsa mə́lámba. ");
INSERT INTO mcp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mɔɔŋg mə́ á bə ilad má, mə́ mú cɨ nə okə́ŋ nə́: “Yə́gá sə́ baalɛ́ mə́wúdə, mə́sʉ́ mə́lámba mə́ wál jímə.” ");
INSERT INTO mcp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Okə́ŋ nə bwo nə́: “Mbɔ̂! Məwúdə́ mə́ ákwagayɛ́ nə shé bɛ̂sh; kagá íkʉ́l bwə́ dʉ ŋgə kusha yí, bɨ kə́g kusə mʉ́n.” ");
INSERT INTO mcp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tɛ́ ílad ínɨ í á ŋgə kə nə́ í kə́ kusə mə́wúdə yí, muud bá mú wɔ́ɔ́s. Bə́nɔ̂ŋ bɔɔŋg bwə́ á bə okə́ŋ wá, bwə́ mú nyíi njɔ́w zâŋ, bwə́ fad mbɛ̂. ");
INSERT INTO mcp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Məsás mâ ilad mə́ á ka zə wɔ́ɔ́s na mpʉ́mpʉ́sə́, ka zə ŋgə jɔ̂w nə́: “Mása, Mása, juwʉ́g sə́ mbɛ̂.” ");
INSERT INTO mcp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nyə mú yida bɛ̧sa nə bwo nə́: “Mə ŋgə cɨ nə bɨ́ fwámɛ́ cɨ nə́, mə ampúyɛ́ bɨ̂.” ");
INSERT INTO mcp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ntɔ́, jigá ŋkasə̂, nəcé bɨ ampúyɛ́ jwɔ̂w nə wəla *Mwân mə Múúd mə bá zə yí.» ");
INSERT INTO mcp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Í bá bə nda muud nyə á kə njɔɔnd dɨ́ yɛ́. Ja á mə́ bə nə́ a zə́ tɨ́ yí, a mú jɔ̂w osɔ́ɔl ɔ mə́sáal bɛ́, zə yə bwo məbii mɛ́ tâŋ nda məcé. ");
INSERT INTO mcp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A mú ŋgə yə bwo nə́mə́ nda bwə́ á ŋgə bə nə ŋkul isɛ́y nə́; a yə nyíga mimbwoomb mí mímbɛɛsh mítɔ́ɔn, a yə nyíga mimbwoomb mímbá, a yə nyíga mbwoomb ŋgwúd. Nyə a shîn yə bwo ntʉ́nɨ nə́ ndɛɛ́ a músə kyey. ");
INSERT INTO mcp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nə́mə́ njɨ bwə́ á shîn lə́g *mwaanɛ̂ yí, nyɔɔŋg nyə á bə nə mimbwoomb mitɔ́ɔn yɛ́ mú kə sɛ̂y nə yé mwaanɛ̂; a músə nyiŋgə́ bii míl mítɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nyɔɔŋg nyə á bə nə mímbá yɛ́ mú nə́mə́ nyiŋgə́ bii míl mímbá. ");
INSERT INTO mcp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nyɔɔŋg nyə á bə nə ŋgwúd yɛ́ nyɛ nyə á kə fáág bɨ́ mə́ndəlúd, a mú shweel mwaanɛ̂ mə mása yé cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ja fwámɛ́ fwála í á cɔ̧́ yí, mása nyə á ka zə nə́ a zə sá ósɔ́ɔl ɔ́ mə́sáal bɛ́ shitɔ́g. ");
INSERT INTO mcp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nyɔɔŋg nyə á lə́g mimbwoomb mí mímbɛɛsh mitɔ́ɔn yɛ́ mú shísh, a zág nə míl mímbwoomb mitɔ́ɔn, nyə nə́: “Mása, wo á yə mə mimbwoomb mí mímbɛɛsh mítɔ́ɔn; dʉgɨ́, míl mímbwoomb mitɔ́ɔn mə á bii wə́ míga.” ");
INSERT INTO mcp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mása yé mú cɨ nə nyə nə́: “Ʉhʉ́ʉŋ. Wo jɨ jɔ̧jɔ̧ sɔ́ɔl məsáal abúgʉ́lág. Wo mə́ bə mə abúgʉ́lág nə isâ cíg-cîg, mə é jil wo ísâ í ábubulyá dɨ̂. Zaá ji mə́shusʉg mə mása woó dɨ̂.” ");
INSERT INTO mcp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nyɔɔŋg nyə á lə́g mimbwoomb mímbá yɛ́ mú nə́mə́ shísh, nyə nə́: “Mása, wo á yə mə mimbwoomb mí mímbɛɛsh mímbá; dʉgɨ́, míl mimbwoomb mímbá mə á bii wə́ míga.” ");
INSERT INTO mcp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mása yé mú cɨ nə nyə nə́: “Ʉhʉ́ʉŋ. Wo jɨ jɔ̧jɔ̧ sɔ́ɔl məsáal abúgʉ́lág. Wo mə́ bə mə abúgʉ́lág nə isâ cíg-cîg, mə é jil wo ísâ í ábubulyá dɨ̂. Zaá ji mə́shusʉg mə mása woó dɨ̂.” ");
INSERT INTO mcp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nyɔɔŋg nyə á lə́g njɨ mbwoomb ŋgwúd yɛ́ músə nə́mə́ shísh, nyə nə́: “Mása, mɛɛ mə á bwey mpu nə́ wo jɨ ŋkí nyaan, wó dʉ mwáágʉlə mpúmə́ kʉ́l wó á shígɛ́ bɛ̧ yí, wó dʉ shwo ídʉ̂w kʉ́l wó á shígɛ́ myɛɛg mpəg yí; ");
INSERT INTO mcp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gwə́ wə́ mə́ á fúndə yí, mə músə kə shweel mbwoomb mímbɛɛsh wô mə́ndəlúd. Lə́gʉ́g, sâ gwô wə́ ga.” ");
INSERT INTO mcp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mása yé mú cɨ nə nyâŋ nə́: “Wo jɨ bɔ́w-bɔ̂w sɔ́ɔl məsáal. Wo jɨ mbɛɛ́ ləm. Ŋkí wo á mpu nə́ mə́ dʉ mwáágʉlə mpúmə́ kʉ́l mə́ á shígɛ́ bɛ̧ yí, mə dʉ shwo ídʉ̂w kʉ́l mə́ á shígɛ́ myɛɛg mpəg yí, ");
INSERT INTO mcp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ŋgaá, wo á jəla nə kə wá mə mwaanɛ̂ waamə́ bâŋ dɨ́, nə́ ja mə́ wɔ́ɔ́s yí, mə zə ŋwa nyə nə məbədî gwɔ̂w! ");
INSERT INTO mcp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dɛ́ɛ́gʉ́gá nyə mbwoomb mímbɛɛsh nɨ, bɨ yə́g nyɔɔŋg jɨ́ nə myo wûm yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nəcé muud jɨ́ nə məbii yɛ́, bwə́ bá nyiŋgə kwádʉlə nyə mwo, á mú bul bii, njɨ nyɔɔŋg cúgɛ́ nə ndɨ̂ yɛ́, bwə́ bá mɛɛl dɛ́ɛ́g sʉ́sʉ́sá á jɨ́ nə ndɨ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Biigá mbɛɛ́ bɔ́w-bɔ̂w sɔ́ɔl məsáal ga, bɨ wúsəg nyə tɔ́ɔ́n, kʉ́l í bá bə njɨ a ŋgə́ bwam nə məyə̂ yí.”» ");
INSERT INTO mcp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ja *Mwân mə Múúd mə bá zə nyə́dɨ́ íjwûga dɨ́, bə́nɔ̂ŋ *wəéŋgəles bɛ̂sh yí, a bá zə ji nyə́dɨ́ *caaŋgə́ á milwanə́d. ");
INSERT INTO mcp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ntɔ́ ilwoŋ byɛ̂sh yâ shí ga í bá sɛɛŋgya nyə́dɨ́ mpwóómbʉ́d. A bá bɛ́ɛ́g búúd ígwooŋg íbá nda mbaagʉlə itɔw mə́ dʉ bɛ́ɛ́g íncwəmbɛ nə ikálá nə́. ");
INSERT INTO mcp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A bá tə̂l íncwəmbɛ nyə́dɨ́ mbwə̂ məncwûm, ikálá nyə́dɨ́ mbwə̂ məkɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nə́ ndɛɛ́ Njwú-buud mə bá cɨ nə bɔɔŋg wâ mbwə̂ məncwûm nə́: “Zəgá, bɨ́ buud Sɔ́ɔ́ŋgʉ́ wâm mə́ yə́ ócúncɛ́sh wá. Zəgá ji Faan dɛ́d, zə lə́g lʉ́gí nyə á bwey bwɨ́ɨ́g bɨ́ nə́mə́ ja nyə á fwɔ̧ shí nə gwɔ́w yí. ");
INSERT INTO mcp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nəcé mə a gwág zha, bɨ á yə mə idʉ̂w; mə a gwág shwáásʉ́lə minʉ́, bɨ á ŋgulal mə; mə á bə njôŋ, bɨ á ŋwa mə bɨ́dɨ́; ");
INSERT INTO mcp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mə á bə shushwáás, bɨ a bwééd mə mikáándə́; mə á bwas, bɨ á zə dʉ́g mə; mə á bə mímbwugʉd, bɨ á kə dʉ́g mə.” ");
INSERT INTO mcp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ja jɔɔŋgʉ̂ wə́ otʉ́təlí ɔ búúd bwə́ bá bɛ̧sa nə nɛ́ nə́: “Cwámba, jáyɛ́ ja sə́ á dʉ́g wo nə zha sə́ mú yə wo idʉ̂w, sə́ dʉ́g wo nə shwáásʉ́lə minʉ́ sə́ ŋgulal wo yí? ");
INSERT INTO mcp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Jáyɛ́ ja sə́ á dʉ́g wo, wo njúl njôŋ sə́ mú ŋwa wo sə́dɨ́ yí; ŋkí nə́ wo njúl shushwáás sə́ mú bwééd wo yí? ");
INSERT INTO mcp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Jáyɛ́ ja sə́ á mpu nə́ wo ŋgə bwas ŋkí nə́ wo jɨ mímbwugʉd sə́ mú kə dʉ́g wo yí?” ");
INSERT INTO mcp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Njwú-buud mə bá bɛ̧sa nə bwo nə́: “Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ja jɛ̂sh bɨ́ á sá gúl mímínyɔŋʉ̂ jâm wúl sɔ́ɔ́lʉ́gʉ́ nɨ yí, mə wə́ bɨ́ á sá wə yɛ́.” ");
INSERT INTO mcp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«A músə bá cɨ nə bɔɔŋg wâ nyə́dɨ́ mbwə̂ məkɔ́ɔ́l nə́: “Wúgá mə míshʉ́d. Bɨ bʉ́sə nə məzhúŋgʉ́lú mə́ Zɛmbî. Kyeyʉgá kə kuda á kandʉgə kandʉgə dɨ̂, kuda Zɛmbî nyə á kwəmʉsa shú Njwû məjamb bə́nɔ̂ŋ wəéŋgəles bɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nəcé mə á gwág zha, bɨ a shígɛ́ yə mə idʉ̂w; mə á gwág shwáásʉ́lə minʉ́, bɨ a shígɛ́ ŋgulal mə məjúwó. ");
INSERT INTO mcp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mə á bə njôŋ, bɨ a shígɛ́ ŋwa mə bɨ́dɨ́; mə shushwáás bɨ kú bwééd mə mikáándə́; mə bwas, mə kə mímbwugʉd, bɨ kú kə dʉ́g mə.” ");
INSERT INTO mcp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ntɔ́, bwə́ bá nə́mə́ jí nyə nə́: “Cwámba, jáyɛ́ ja sə́ á bwɛlɛ dʉ́g wo, wo ŋgə́ yə nə zha ŋkí shwáásʉ́lə minʉ́, ŋkí ntâg nə́ sə́ á dʉ́g wo, wo njúl shushwáás ŋkí nə́ wo ŋgə́ bwas, ŋkí nə́ wo njúl mímbwugʉd sə́ kú bísh wo yí?” ");
INSERT INTO mcp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ntɔ́, a bá bɛ̧sa nə bwo nə́: “Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ja jɛ̂sh bɨ́ á bə kú sá ŋgwɔ́l mímínyɔŋʉ̂ waamə́ wúl sɔ́ɔ́lʉ́gʉ́ nɨ yí, mə wə́ bɨ́ á bə kú sá mə́nywa mɔɔŋg yɛ́”. ");
INSERT INTO mcp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nə́ ndɛɛ́, bʉ́nɨ bwə́ bá kə intʉ́gʉ́lí yâ kandʉgə kandʉgə dɨ̂; otʉ́təlí ɔ búúd bâŋ bwə́ kə cʉg á kandʉgə kandʉgə dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Í á zə bə nə́, ja Yésus nyə á shîn lás isâ ínɨ byɛ̂sh yí, nyə á ka cɨ nə *ompwíín bɛ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Bɨ mə mpú nə́ í mə́ lʉ́g mwɔ̂w mə́bá nə́ *Páska bə́g. Mpugá nə́ *Mwân mə Múúd mə bá kaanz shú nə́ bwə́ bâg bwambʉlə nyə kwolós dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Milúlúú myâ ofada nə ocúmbá buud wâ lɔɔm bwə́ á ka kə sɛɛŋgya luŋ mə́ Kayíf, Ajəlácɨ á ofada. ");
INSERT INTO mcp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bwə́ mú kə cwɔ̧́ íyuug nə́ bwə́ bii Yésus mə́kə́ŋʉ́d, gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Njɨ, bwə́ á ŋgə cɨ nə́: «Í ajə́láyɛ́ nə sɨ̂y fwála lʉ zâŋ, buud bwə́ á bá bul sá ícucu». ");
INSERT INTO mcp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yésus nyə á ka bə Betanî, Shímun á zʉ́zaamə́ dɨ́ njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ŋgwɔ́l múdá mbíd fúfuundú *alʉbátrə mú shísh wə́ Yésus. Fúfuundú jɔɔŋg í á bə nə labínda álal-kus. Nə́ ndɛɛ́, Yésus ŋgə́ də, mudá ɛ́nɛ mú shwu nyə labínda wɔɔŋg lúúd. ");
INSERT INTO mcp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ja *ómpwíín bwə́ mə́ dʉ́g ntʉ́nɨ yí, bwə́ mú gwág bɔ̂w, bwə́ mú ŋgə lás nə́: «Jɨ́ á ntámá labínda ɛ́ga ntʉ́ga yí? ");
INSERT INTO mcp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Í ámə jəla nə́ bwə́ kúshag labínda nɨ ŋkí lal kus, bwə́ mú kwíínd mímbúmbúwá nə *mwaanɛ̂ wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yésus nyə á ka mpu nə́ bwə́ ŋgə lás ntɔ́, a mú cɨ nə bwo nə́: «Nəcé jɨ́ bɨ́ mə́ ntágʉ́lə́ múdá ɛ́nɛ yí? Sâ mə́nywa wə́ á mə́ sá mə nɨ. ");
INSERT INTO mcp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nəcé bɨnɔ̂ŋ mimbúmbúwá bɨ é dʉ ji mwɔ̂w mɛ̂sh, njɨ sə́nɔ̂ŋ bɨ́ sə́ ábʉ́lɛ́ ji mwɔ̂w mɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ja nyə́ ámə shwu mə labínda nyúúlʉ́d nɨ, nyə ámə bwey kwəmʉsa mə dɔwʉ́lə mə́ bá zə dɔw yí. ");
INSERT INTO mcp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kʉ́l jɛ̂sh bwə́ bá cúndə Jɔ̧jɔ̧ Kɛ́ɛl ga shí nyɛ̂sh dɨ́ yí, bwə́ bá nə́mə́ dʉ jaaw sâ múdá ɛ́ga mə́ sá mə yí, buud dʉ tə́dʉga nyə.» ");
INSERT INTO mcp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mpʉ́sə na, ŋgwɔ́l múúd á gwooŋg ómpwíín wûm nə óbá, nyɔɔŋg bwə́ á dʉ jɔ̂w nə́ Yúdas Iskariyôt yɛ́, músə kə dʉ́gya nə milúlúú myâ ofada, ");
INSERT INTO mcp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nyə nə bwo nə́: «Mə ká sá nə́ bɨ bííg Yésus, bɨ́ yə mə jɨ́?» Bwə́ mú ntâg lɔ̧́ misaŋ mí mwaanɛ̂ məwûm mə́lɔ́ɔl, bwə́ yə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tɛ́ɛ́d baan dɔɔŋgʉ́ dɨ, Yúdas músə ŋgə sɔ̧́ fwámɛ́ fwála á jɨ́ nə ŋkul sá nə́ bwə́ bííg Yésus yí. ");
INSERT INTO mcp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jwɔ̂w mə́tɛ́ɛ́dʉ́lé mə́ zâŋ mú ka zə wɔ́ɔ́s, jwɔ̂w bwə́ á jəla nə tɛ́ɛ́d də́lə íbʉlɛ́d yâ kú nə *ləvur yí, *ompwíín bwə́ á ka jî Yésus nə́: «Wó cɛɛl nə́ sə́ kə́g kwísha dína *Páska ŋgow?» ");
INSERT INTO mcp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yésus mú bɛ̧sa nə bwo nə́: «Kagá ŋgwə́la, wə́ mbɛɛ́; bɨ kə́g cɨ nə nyə nə́: “Yɨ́ɨ́gʉli mə́ cɨ nə́ baan dɛ́ í mú kúnə́-kúnə. Bə́nɔ̂ŋ ompwíín bɛ́ bwə́ é zə sá Páska wa wódɨ́.”» ");
INSERT INTO mcp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ompwíín bwə́ á kə nə́mə́ kə sá nda Yésus nyə á cɨ nə bwo nə́, bwə́ mú kwísha dína Páska. ");
INSERT INTO mcp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ja kugʉ́ í á bii shí yí, Yésus nyə á kə ji shí, bə́nɔ̂ŋ *buud ɔ lwámá wûm nə óbá bɛ́, kə́lə də. ");
INSERT INTO mcp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bwə́ ŋgə́ də, Yésus mú cɨ nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ŋgwɔ́l múúd á na bɨ́dɨ́ nyə é kusha nə mə». ");
INSERT INTO mcp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ompwíín bwə́ mú bul gwág sâ jɔɔŋgʉ̂ cɛy lámʉ́d, bwə́ mú ŋgə jî nyə, múúd yɛ̂sh nə́: «Cwámba, ye mə?» ");
INSERT INTO mcp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yésus mú bɛ̧sa nə́: «Muud sə́ná sə́ ámə juwo məbwə̂ shúyád yɛ́, nyə wə́ nyə é kusha nə mə. ");
INSERT INTO mcp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwân mə Múúd nywáá, nyə é kə nə́mə́ nda jísə́ bwey bə cilyá shú dɛ́ dɨ́ nə́. Njɨ məntágʉla nə múúd mə kɛ́ɛ́nzh nyə yɛ́; í á yida nywá bul jəla nə́ muud wɔɔŋgʉ̂ kú byɛ̂l.» ");
INSERT INTO mcp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ntɔ́, Yúdas, muud nyə á kusha nə nyə yɛ́ mú nə́mə́ lás, a jî nyə nə́: «*Rabi e, ye mə?» Yésus mú bɛ̧sa nə nyə nə́: «Wo mə́ cɨ wə́ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bwə́ ŋgə́ də ntʉ́nɨ, Yésus mú ŋwa bʉlɛ́d, a yə Zɛmbî cúncɛ́sh nə́ ndɛɛ́, a mú fɛ̂y bʉlɛ́d, yə ómpwíín bɛ́, nyə nə bwo nə́: «Ŋwagá, bɨ də́g. Nyúul nyâm wə́ ga.» ");
INSERT INTO mcp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nə́ ndɛɛ́, a mú ŋwa bálá wáan, a yə Zɛmbî cúncɛ́sh, a yə ntâg ompwíín bɛ́, nyə nə bwo nə́: «Bɨ bɛ̂sh ŋgulʉgá. ");
INSERT INTO mcp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Məcií mâm wə́ mə́nɨ, məcií mâ sɔ̧, mə́ zə́ shwɨy shí má, zə cé búúd ŋkí bulya, nə́ bwə́ bə́g nə ijuugá í *mísə́m. ");
INSERT INTO mcp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mə́ jaaw bɨ́ nə́, mə abʉ́lɛ́ ná kwo ŋgul wáan nɨ kə wɔ́ɔ́s ja shé mə́ bá ŋgul ncuncúmbə Faan mə́ Sɔ́ɔ́ŋgʉ́ waam dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bwə́ mú ka sɛy Zɛmbî isʉsa i gúmə́ nə́ ndɛɛ́ bwə́ músə kyey kə *Mbʉ́ŋ wə́olivyê dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nə́ ndɛɛ́, Yésus mú cɨ nə *ompwíín bɛ́ nə́: «Búlú ga dɨ́, bɨ e láŋgʉwo búgə́d nəcé mə. Sâ jɔɔŋgʉ̂ wə́ jísə́ cilyá Kálaad Zɛmbî dɨ́ yí nə́: “Mə é nyífə mbaagʉlə itɔw, incwəmbɛ í sɔɔnz í mú shîn cɨɨma.” ");
INSERT INTO mcp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Njɨ, ja mə́ bá gwûm yí, mə bá tɛ́ɛ́d kə Galilê, bɨ́ kə bá kwey mə nûŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pyɛ̂r mú lás, cɨ nə́: «Tɛɛm bə nə́ bɔ́ɔ́lʉ́gá bɛ̂sh bwə́ láŋgʉwo búgə́d nəcé wo, mɛɛ mə abʉ́lɛ́ bwɛlɛ láŋgʉwo.» ");
INSERT INTO mcp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yésus mú bɛ̧sa nə nyə nə́: «Bʉ́bə́lɛ́, mə́ jaaw wo nə́, nə́mə́ búlú ga dɨ́, shúshwóógʉ́ nə́ ŋgwúm kúwo kwáágʉ́gi, wo e kɨ́ɨ́lya mə ija ilɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pyɛ̂r nə nɛ́ nə́: «Tɛɛm bə nə́ í wɔ́ɔ́s nə́ shwə́ yə́g shwɨy ŋgwúdʉ̂, mə kú bwɛlɛ kɨ́ɨ́lya wo». Bɔ́ɔ́l ómpwíín bɛ̂sh bwə́ mú nə́mə́ ŋgə cɨ ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nə́ ndɛɛ́, Yésus bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ músə kumə kʉ́l bwə́ dʉ jɔ̂w nə́ Gɛtsemane yí. A mú cɨ nə bwo nə́: «Jigá wa shí, mə́ fwo kə wá shwóg, kə sá mə́jəgʉla». ");
INSERT INTO mcp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A músə jɔ̂w Pyɛ̂r nə bwân ɔ́ Zhébedé óbá, bə́nɔ́ŋ bwə́ mú kə; a mú tɛ́ɛ́d ŋgə́lə bul gwág məcɛy mə lâm, mbɔɔm í ŋgə́ shwɨy nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A mú ka cɨ nə bwo nə́: «Lâm wúsə mə nə məcɛy ki mə é yə. Jigá ŋkasə́ wa shí, bɨ nyɛ́ɛ́lə́g mə.» ");
INSERT INTO mcp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A mú wú na bwə́dɨ́, a ŋwá shísh shwóg, a músə kə wusə nyúúl shí, a kúd mpwoombʉ́ mə́ndəlúd, jəgʉla nə Zɛmbî nə́: «Pʉpá e, ŋkí jɨ́ nə ŋkul jəla ntɔ́, magʉləg nə́ mə bə́g kú ŋgul bálá mə́cɛy ga. Njɨ, í sɨ́yʉ́g nda wó cɛ́ɛl nə́, kú bə nda mə́ cɛ́ɛl nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A músə zə kɔ́ɔ́mb ómpwíín bwə́ á bə yí, a mú zə kwey bwo ígwə́d. A músə lás nə Pyɛ̂r nə́: «Ntɔ́ nə́ bɨ́ cugɛ́ nə ŋkul ji ŋkasə́ nə mə tɔɔ njɨ wəla ŋgwúdʉ̂? ");
INSERT INTO mcp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jigá ŋkasə́, jəgʉla nə Zɛmbî, bɨ bə́g kú biil mə́bwə́bʉ́lánʉ́d. Lâm wúsə nə yéésh mə kyéy jɔ̧ kuú njɔɔnd; njɨ nyúul í cúgɛ́ nə ŋkul kwag kuú njɔɔnd wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A músə nyiŋgə shísh shwóg ja ábɛɛ̂, kə jəgʉla nə Zɛmbî nə́: «Pʉpa, ŋkí tə́dʉ́gá wô í cúgɛ́ nə́ wo yíl mə bálá ga mə kú ŋgul, í sɨ́yʉ́g nda wó cɛ́ɛl nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A músə nyiŋgə́ zə ómpwíín bɛ́ dɨ́, zə nə́mə́ nyiŋgə kwey bwo ígwə́d nəcé mísh mə́ á ŋgə ntámb bwo. ");
INSERT INTO mcp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A mú wú na bwə́dɨ́, a shísh shwóg, kə sá mə́jəgʉla ja álɛ́ɛl, məjəgʉla məmpúd á ŋgə́ bwey sá má. ");
INSERT INTO mcp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A músə nyiŋgə zə ómpwíín bɛ́ dɨ́, a mú cɨ nə bwo nə́: «Ye bɨ bâŋ bɨ é bə wa njɨ gwə́ nə gwə́ njɨ ŋgə́lə woga? Dʉgá! Wəla í mú kúnə́-kúnə, wəla *Mwân mə Múúd mə zə kaanz məbwə̂ mə́ ósɔ́ɔl ɔ́ *mísə́m dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tɔ́wʉ́gá, sə́ kyéyʉg. Muud mə́ kusha nə mə wə́ zág yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yésus ŋgə́ ná lás ntʉ́nɨ, seegya nə́, Yúdas nyə á bə nə́mə́ gwooŋg *ómpwíín wûm nə óbá dɨ́ yɛ́ mú cúwo, a ŋgə́ zə nə məma kínda búúd, bwó nə ikafwɛlɛ nə məbʉ́lə. Milúlúú myâ ofada nə ocúmbá buud wâ lɔɔm wə́ bwə́ á ntɨ bwo. ");
INSERT INTO mcp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yúdas, muud nyə á kusha nə nyə yɛ́, nyə a bwey kwambʉlə nə buud ɔ́nɨ nə́: «Muud mə́ é kə fʉ́lal, sə́ sɔ̧nya mímpu yɛ́, nyə wə́ ɛ́nɛ, bɨ ɔ́ bii nyə». ");
INSERT INTO mcp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nə́mə́ njɨ Yúdas nyə á cúwo yí, nyə a cɔ̧́ kə njɨ wə́ Yésus, nyə nə nɛ́ nə́: «Rabi, wo ɔ lás ɔ!» A mú fʉ́lal nyə. ");
INSERT INTO mcp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yésus mú cɨ nə nyə nə́: «Wɛy e, ság sâ wo ámə zə sá yí». Buud bwə́ mú cíg, zə kɔ̧ Yésus, bwə́ mú bii nyə. ");
INSERT INTO mcp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Seegya nə́ ŋgwɔ́l múúd gwooŋg mə Yésus mə́ wéem kafwɛlɛ jé, taad ŋgwɔ́l sɔ́ɔl məsáal mə Ajəlácɨ á ofada, í mú sámb nyə lwə̂. ");
INSERT INTO mcp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yésus músə cɨ nə nyə nə́: «Nyiŋgə́g fɛɛn kafwɛlɛ gwô jiya jéd; nəcé muud yɛ̂sh mə bálán nə kafwɛlɛ yɛ́, a bá nə́mə́ bwəma nə shwɨy kafwɛlɛd. ");
INSERT INTO mcp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ye wo ampúyɛ́ nə́ mə jɨ nə ŋkul gwáámb Dâ kwííndyá, a lɛɛl nə́mə́ ntɨ mə məma íkínda í *wə́éŋgəles wûm nə íbá? ");
INSERT INTO mcp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ká, ŋkí isâ í sɨ̂y ntɔ́, mícilyá myâ Kálaad Zɛmbî mí é ka bwəma ntʉdɛlɛ̂? Sâ í ŋgə sɨ̂y ga í ŋgə lwándʉlə micilyá myɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yésus músə ka cɨ nə buud bwə́ á zə bii nyə wá nə́: «Bɨ́ ŋgə zə nə ikafwɛlɛ nə məbʉ́lə zə́lə bií mə, mə jisə zhilʉŋgaanə́ ɨɨ́? Ŋgaá nə́ shé á dʉ bə jwɔ̂w dɛ̂sh kʉ́l ŋgwúd, mə ŋgə́ jɨ́ɨ́gʉli buud *Luŋ mə́ Zɛmbî dɨ̂, bɨ kú sɛ́ɛ́mb mbwə̂ nə́ bɨ mə́ bií mə. ");
INSERT INTO mcp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Isâ íga byɛ̂sh í ŋgə sɨ̂y ntʉ́ga nə́ isâ *búúd ɔ mícúndə́ bwə́ á cilə yí í bwə́mag.» Mpʉ́sə wɔɔŋgʉ̂, ompwíín bɛ́ bwə́ mú myaas nyə, bwə́ shîn fúndə. ");
INSERT INTO mcp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Buud bwə́ á zə bii Yésus wá bwə́ mú kə nə nyə wə́ Kayíf, Ajəlácɨ á ofada, kʉ́l *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə ocúmbá buud wâ lɔɔm bwə́ á kə sɛɛŋgya yí. ");
INSERT INTO mcp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pyɛ̂r nyɛ nyə á ŋgə bɛ̧ bwo shwóg-shwóg nə́ ndɛɛ́ kə wɔ́ɔ́s nûŋ luŋ. A mú nyíi nə́ á cɛɛl fwo wámbʉlə sâ í é bə yí. A mú kə ji shí, bə́nɔ̂ŋ bíl ífulísh kʉl ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tɛ́ nɨ, milúlúú myâ ofada, bə́nɔ̂ŋ *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî jɛ̂sh bwə́ á ŋgə sɔ̧́ mpwɛnɛ bwə́ yə́g nyə nə́ ndɛɛ́ bwə́ gwú nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Njɨ, zhwog buud bwə́ á tɛɛm ŋgə zə nə ijɔ̧́ɔ̧́ ŋgə zə yə nyə ompwɛnɛ, í á shigɛ́ bə nə tɔɔ sá á shwɨy. Bɔ́ɔ́l búúd ɔ ómpwɛnɛ óbá bwə́ mú zə cúwo, bwə́ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Wɛy ɛ́nɛ, nyə á cɨ nə́ a jɨ nə ŋkul búgə *Mpáánzə́ Zɛmbî nə́ ndɛɛ́ a kwo sá njɨ mwɔ́w mə́lɔ́ɔl shumə́lə nyúl.» ");
INSERT INTO mcp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ajəlácɨ á ofada mú tɔ̂w tʉ́təlí, nyə nə Yésus nə́: «Wo abɛ̧́sáyɛ́ búúd ɔ́ga sâ bwə́ ŋgə́ bwaagʉlə wo nɨ?» ");
INSERT INTO mcp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yésus njúl njɨ kʉ́l-kʉ̂l. Ajəlácɨ mú kwo cɨ nə nyə nə́: «Jaawʉg sə́ bʉ́bə́lɛ́ mə́ Zɛmbî á kuwô, ye wo jɨ *Krîst, *Mwân mə́ Zɛmbî?» ");
INSERT INTO mcp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yésus mú bɛ̧sa nə nyə nə́: «Wo mə́ cɨ ɔ́nɨ. Mə́ ka jaaw bɨ́ nə́ tɛ́ɛ́d nə́mə́ kɨ́kɨdɨ́ga, bɨ é dʉ́g *Mwân mə Múúd njúl shí mbwə̂ məncwûm mə́ Zɛmbî á ŋkul nyɛ̂sh dɨ́, bɨ mə bá nə́mə́ dʉ́g nyə, a ŋgə́ zə míŋkúdʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ajəlácɨ músə nyaa míkáándə́, nyə nə́: «A mə́ *lás nə Zɛmbî bwaasʉ́lə mpu, jɨ́ shé mə́ kwo sɔ̧́ owúshinɛd yí? Bɨmɛ́fwó bɨ mə́ gwág nda á mə́ lás nə Zɛmbî bwaasʉ́lə mpu nə́. ");
INSERT INTO mcp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bɨ mə dʉ́g nə́ jɨ?» Bwə́ nə́: «A jəlá nə yə.» ");
INSERT INTO mcp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bwə́ mú ka ŋgə sɛy nyə məntənd mpwóómbʉ́d, bwə́ ŋgə́ wá nyə ikúda; bɔ́ɔ́l bwə́ ŋgə́ tɨ́ nyə məmpɔ́ɔ́nz, ");
INSERT INTO mcp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bwə́ ŋgə́ cɨ nə nyə nə́: «Yé Krîst, lwóg nə́ wo jɨ *muud micúndə́, jaawʉg sə́ muud nyə ámə yíd wo yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pyɛ̂r njúl ná na tɔ́ɔ́n mbaadə́ dɨ, dúl sás í á dʉ sɛ̂y nə Ajəlácɨ á ofada yí, í músə shísh nyə́dɨ́ zə cɨ nə nyə nə́: «Wo á bə nə́mə́ gwooŋg mə Yésus muud á Galilê ɛ́ga dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pyɛ̂r mú kɨ́ɨ́lya nyə tâm buud, nyə nə́: «Mə ampúyɛ́ sâ wó ŋgə́ cɨ yí.» ");
INSERT INTO mcp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A mú ka tɔ̂w shí, ŋgə kə ŋgɛɛ mbɛ̂ kɔ́ɔ́gʉ́lə́d. Dúl sás í á dʉ nə́mə́ sɛ̂y cínɔŋg yí í mú yag nyə, a mú cɨ nə buud bwə́ á bə cínɔŋg wá nə́: «Muud ɛ́ga nyə á bə gwooŋg mə Yésus á Nazarɛ̂t dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pyɛ̂r mú kwo kɨ́ɨ́lya nyə, a kɛɛn nə́: «Bʉ́bə́lɛ́, mə ampúyɛ́ múúd ɛ́nɛ.» ");
INSERT INTO mcp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kú nə́mə́ bwey, buud bwə́ á bə cínɔŋg wá bwə́ mú shísh nyə́dɨ́, zə cɨ nə nyə nə́: «Wo jɨ bə́lɛ bə múúd á gwooŋg jɔɔŋgʉ̂; kə́l lʉ́ lə́sʉ́ dwô í ŋgə bwey lwágʉlə ntɔ́ nə́ sáŋ.» ");
INSERT INTO mcp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pyɛ̂r mú kɨ́ɨ́lya nyə nə məma ŋkaanə́, nyə nə́: «Ŋkí mə́ bwiiŋg ijɔ̧́ɔ̧́, ŋkwaal nə mə. Mə ampúyɛ́ múúd ɛ́nɛ.» Nə́mə́ njɨ nyə á cɨ ntʉ́nɨ yí, ŋgwúm kúwo mú kwáág. ");
INSERT INTO mcp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pyɛ̂r mú tə́dʉga ciyá Yésus nyə á cɨ nə nyə yí nə́: «Shúshwóógʉ́ nə́ ŋgwúm kúwo kwáágʉ́g, wo e kɨ́ɨ́lya mə ija ílɔ́ɔl.» A mú cúwo tɔ́ɔ́n kə dʉ sʉ́g nə yə̂. ");
INSERT INTO mcp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mán mələ̂m, ná nə́mə́ mpʉ́mán mpʉ́mán, milúlúú myâ ofada nə ocúmbá buud wâ lɔɔm bwə́ mú sá shwushwaga nə́ ndɛɛ́ bwə́ sámb nə́ Yésus mə́ jəlá nə yə. ");
INSERT INTO mcp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bwə́ mú wɔ́ɔlə nyə məŋkəda nə́ ndɛɛ́ bwə́ kə cwámbʉlə ŋgwə́mʉna Pilât. ");
INSERT INTO mcp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ja Yúdas muud nyə á kusha nə nyə yɛ́ mə́ dʉ́g nə́ bwə́ mə́ sámb nə́ Yésus mə́ jəlá nə yə yí, lâm í mú cɛy nyə cwû nə sɔ́ɔ́lʉ́gʉ́ nyə á sâ yí. A mú kə nə́ a kə́ nyiŋg mílúlúú myâ ofada nə ocúmbá buud misaŋ mí *mwaanɛ̂ məwûm mə́lɔ́ɔl myáŋ, ");
INSERT INTO mcp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nyə nə bwo nə́: «Mə mə́ sə̂m nə kushálə nə muud njúl kú nə məbyaagʉlə.» Bwə́ mú cɨ nə nyə nə́: «Sə́ abíshɛ́. Wóó lə́sʉ́ ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yúdas mú shwu mwaanɛ̂ cínɔŋg shí *Mpáánzə́ Zɛmbî dɨ̂, a mú kyey kə kəl kwoolú cʉ́ŋʉ́d nə́ ndɛɛ́ yə. ");
INSERT INTO mcp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Milúlúú myâ ofada mí mú wásʉlə mwaanɛ̂ wɔɔŋg, bwə́ nə́: «Mwaanɛ̂ ɛ́ga jɨ mwaanɛ̂ məcií. Í á jə́láyɛ́ nə́ sə́ wáág nyə maŋga á Mpáánzə́ Zɛmbî dɨ̂; məcɛ̧ɛ̧ mə́sʉ́ mə́ amágʉ́lə́yɛ́ ntɔ́.» ");
INSERT INTO mcp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bwə́ mú ka sá shwushwaga nə́ ndɛɛ́ bwə́ mú kə nə mwaanɛ̂ wɔɔŋg, kə kusə kʉ́l shí mə́ mɔɔl məmpɨɨ́, bwə́ sá kʉ́l shí jɔɔŋgʉ̂ baŋ mə́shwoŋ ójôŋ. ");
INSERT INTO mcp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sâ jɔɔŋgʉ̂ í á sá nə́ bwə́ dʉ́g jɔ̂w kʉ́l shí jɔɔŋg nə́ fambə́ mə́cií. Jínə́ dɔɔŋg dʉ́sə ná zə kumə múús. ");
INSERT INTO mcp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ntɔ́, sâ *múúd micúndə́ Zheremî nyə á cɨ yí í mú bwəma. Nəcé nyə á cɨ nə́: Bwə́ á ŋwa misaŋ mí mwaanɛ̂ məwûm mə́lɔ́ɔl; tâŋ bwân ɔ́ Izʉrəyɛ̂l bwə́ á cígə nə́ í kwaga nə muud wɔɔŋgʉ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bwə́ mú kusə kʉ́l shí mə́ mɔɔl məmpɨɨ́ nə ndɨ̂, nə́mə́ nda Dá Zɛmbî nyə á cɨ nə mə nə́. ");
INSERT INTO mcp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bwə́ á ka kə nə Yésus wə́ njwú-buud. Njwú-buud mú ŋgə jí nyə minjígá; a mú jí nyə nə́: «Ye wo jisə Njwû *Oyúdɛn?» Yésus nə nɛ́ nə́: «Wo mə́ cɨ ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Njɨ ja mílúlúú myâ ofada nə ocúmbá buud wâ lɔɔm bwə́ búgə Yésus lə́sʉ́ yí, Yésus kú bɛ̧sa. ");
INSERT INTO mcp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ntɔ́ Pilât mú jí nyə nə́: «Ye wo aŋgɛ̂ nə gwág isâ byɛ̂sh bwə́ ŋgə́ bwaagʉlə wo ínɨ?» ");
INSERT INTO mcp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Njɨ Yésus kú bɛ̧sa nə nyə tɔɔ sâ. Ŋgwə́mʉna mú bul káam. ");
INSERT INTO mcp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ŋgwə́mʉna nyə á dʉ bə nə́, ja jɛ̂sh zâŋ nyísə́ yí, a bɨ́d mbwug ŋgwûd, wɔɔŋg lɔɔm í ámə gwáámb nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bwə́ á ka bə nə wúl mbʉ́mbɛ́n mbwug nə jínə́ nə́ Barábas. ");
INSERT INTO mcp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nda búúd bwə́ á bə sɛɛŋgyá nə́, Pilât mú jí bwo nə́: «Mə bɨ́dʉ́g bɨ́ wáyɛ́ mbwug? Ye Barábas, ye Yésus jɨ́ nə jínə́ nə́ *Krîst yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilât nyə a jí ntɔ́ nəcé nyə á bwey mpu nə́ bwə́ ŋgə kusha nə Yésus zhíŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ja Pilât nyə á bə a njúl jiya mílə́sʉ́ jéd a ŋgə́ lás lə́sʉ́ mə́ Yésus nɨ, mudá yé nyə á ntɨ nyə məcwama nə́: «Wo kú tɛ́ɛ́d nyíi lə́sʉ́ nɨɨ́d. Muud ɛ́nɛ jɨ tʉ́təlí muud. Mə mə́ bul wádʉga nə ntamə́ nyɛ́ búlú gaád.» ");
INSERT INTO mcp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Milúlúú myâ ofada nə ocúmbá buud wâ lɔɔm bâŋ bwə́ mə́ shîn bwey cwîny lɔɔm nə́ bwə́ gwáámbʉ́g Barábas, Yésus yə́g. ");
INSERT INTO mcp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋgwə́mʉna mú lás, nyə nə́: «Búud obá ógad, mə bɨ́dʉ́g bɨ́ nyáyɛ́?» Bwə́ nə́: «Barábas.» ");
INSERT INTO mcp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilât mú jí nə́: «Ká Yésus jɨ́ nə jínə́ nə́ Krîst ɛ́ga nyɛ, mə sáág nyə ntʉdɛlɛ?» Bɛ̂sh bwə́ mú cɨ nə́: «Bwə́ bwámbʉləg nyə kwolós dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ŋgwə́mʉna mú jí nə́: «Dáyɛ́ bɔ̂w á mə́ sá yí?» Bwə́ mú kɨ̂m gwɔ́w gwɔ̂w nə́: «Bwə́ bwámbʉləg nyə kwolós dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilât mú dʉ́g nə́ nyə e tɛɛm wá nadâ, sâ í ábʉ́lɛ́ cɛ́nd, icucu í é ŋgə yáág yáágʉ́g. A mú ka ŋwa mə́júwó, zə gusa məbwə̂ mísh mə́ búúdʉd, nyə nə́: «Muud ɛ́ga cugɛ́ nə məbyaagʉlə, shwɨy dɛ́ í adʉ́gɛ́ mə. Í dʉ́g bɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Buud bɛ̂sh bwə́ mú magʉlə nə́: «Ŋkwaal á shwɨy dɛ́ bə́g nə sə́, kala nə bwân bʉ́sʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilât mú bɨ́d bwo Barábas. A mú sá nə́ bwə́ fyámʉ́sə́g Yésus milwóŋ nə́ ndɛɛ́ a mú yə bwo nyə nə́ bwə́ kə́g bwambʉlə nyə kwolós dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ozɨmbɨ ɔ ŋgwə́mʉna bwə́ mú ka kə nə Yésus luŋ mə ŋgwə́mʉna. Bwə́ mú jɔ̂w ózɨmbɨ bɛ̂sh bwə́ zə sɛɛŋgya cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bwə́ mú yîl nyə mikáándə́, bwə́ bwééd nyə fwámɛ́ jud átɨ́tɨɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bwə́ mú ŋwa isâ yâ məgwaagʉlə́, bwə́ lwɔ̧́ *tûm gúmə́ nə́ ndɛɛ́ jil nyə lúúd, bwə́ wá nyə kʉ́l mbwu mbwə̂ məncwúmʉ́d. Bwə́ ka zə ŋgə kúd nyə məbwóŋ, ŋgə cágʉlə nyə, ŋgə cɨ nə nyə nə́: «Yé Njwû *Oyúdɛn, sə́ ŋgə báág nə wo.» ");
INSERT INTO mcp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bwə́ mú sɛy nyə məntənd, bwə́ ŋwa kʉ́l mbwu, dʉ nyífə nyə lúúd. ");
INSERT INTO mcp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ja bwə́ á ka shîn cágʉlə nyə ntʉ́nɨ yí, bwə́ á ka yîl nyə jud átɨ́tɨɨ̂, bwə́ bwééd nyə mikáándə́ myɛ́, bwə́ mú kə nə nyə kə́lə bwambʉlə nyə kwolós dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bwə́ ŋgə́ wú nə nyə ŋgwə́la ntʉ́nɨ, bwə́ mú bwəma nə ŋgwɔ́l múúd á Sirɛ̂n nə jínə́ nə́ Shímun. Ozɨmbɨ bwə́ mú yɨ́ɨ́mbʉli nyə nə́ a ŋkɛ́nyʉ́g Yésus kwolós. ");
INSERT INTO mcp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bwə́ mú kə kumə kʉ́l bwə́ dʉ jɔ̂w nə́ Golgota yí. Jínə́ dɔɔŋg í kə́ nə́ «kʉ́l á bwundú lúu». ");
INSERT INTO mcp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bwə́ mú ŋgulal nyə wáan fʉlá nə wúl myámbə́ í njúl ŋkí gwul. Njɨ nyə á kag gwo yí, a mú ban nə́ nyə aŋgúlɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bwə́ mú bwambʉlə nyə kwolós dɨ́, bwə́ mú wusə mpaambə́ nə́ bwə́ kawʉla míkáándə́ myɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bwə́ músə ka ji shí dʉ nyɛ́ɛlə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Shú nə́ buud bwə́ mpúg cwoomb bwə́ gwú nyə nə ndɨ́ yí, bwə́ á cilə, bwə́ bwambʉlə nyə́dɨ́ lúú dɨ́ gwɔ̂w nə́: «Muud ɛ́ga wə́ Yésus, Njwû Oyúdɛn». ");
INSERT INTO mcp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bwə́ á bwambʉlə bə́nɔ̂ŋ izhilʉŋgaanə́ íbá, jíga nyə́dɨ́ mbwə̂ məncwûm, jíga mbwə̂ məkɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Buud bwə́ á ŋgə cɔ̧́ cínɔŋg wá bwə́ á ŋgə lwîy nyə bwə́ ŋgə́ sagʉsə milúu nə məzhwámá, ");
INSERT INTO mcp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bwə́ ŋgə́ lás nə nyə nə́: «Wɛɛ muud jɨ nə ŋkul búgə *Mpáánzə́ Zɛmbî nə́ ndɛɛ́ wo kwo sá njɨ mwɔ́w mə́lɔ́ɔl shumə́lə nyúl yɛ́, cʉgʉg wómɛ́fwó na. Ŋkí wo jɨ *Mwân mə́ Zɛmbî, wúg na kwolós dɨ́ shulə shí.» ");
INSERT INTO mcp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Milúlúú myâ ofada bə́nɔ̂ŋ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə ocúmbá buud bwə́ mú nə́mə́ ŋgə cágʉlə nyə, bwə́ ŋgə́ cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Nyə á dʉ cʉg buud oshús, njɨ a káád cʉgʉ́lə nyə́mɛ́fwó. Ŋkí a jɨ Njwú-buud á *Izʉrəyɛ̂l, a shúləg na kwolós dɨ́ sə́ búgʉ́lág nyə. ");
INSERT INTO mcp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nyə a shîn shwu nyúul nə́ Zɛmbî jɨ nə nyə, a dʉ nə́mə́ cɨ nə́: “Mə jɨ Mwân mə́ Zɛmbî”. Ntɔ́, ŋkí Zɛmbî mə́ cɛɛl nyə, a cʉ́gʉg nyə ja gaád.» ");
INSERT INTO mcp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tɛɛm bə ízhilʉŋgaanə́ bə́nɔ́ŋ bwə́ á bə íkwolós dɨ́ yí, í á ŋgə nə́mə́ lwîy nyə. ");
INSERT INTO mcp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yídʉ́gʉ́ í á ka shila shí nyɛ̂sh nə́ ŋkwed, tɛ́ɛ́d tɔ́lɔ́g dɨ́ kə wɔ́ɔ́s mə́wəla məlɔ́ɔl mâ mpwó-kugʉ́. ");
INSERT INTO mcp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ŋgɛɛ́ mə́wəla məlɔ́ɔl dɨ́, Yésus músə kɨ̂m nə ŋkulû nə́: «Eli, Eli, lemá sabakʉtáni?» Ntɔ́ mə́ kə́ nə́: «Zɛmbî waam, Zɛmbî waam, wó myaas mə nə́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ja bɔ́ɔ́l búúd bwə́ á bə cínɔŋg wá bwə́ á gwág ntɔ́ yí, bwə́ nə́: «A ŋgə jɔ̂w Eli.» ");
INSERT INTO mcp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋgwɔ́l múúd wáŋ mú tɨ́ kʉ́lə́ kə ŋwa eponzh juwo mə́lwəg mə́ ábibyɛnzhʉ̂ dɨ́, a fɛɛn gwo lɨ́ɨ́ mbwu dɨ́, a kə dásʉlə Yésus nə́ a ŋgúlʉg. ");
INSERT INTO mcp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bɔ́ɔ́lʉ́gá búúd bwə́ mú cɨ nə́: «Bwándʉ́g, sə́ fwóg dʉ́g ŋkí Eli nyə é zə cʉg nyə.» ");
INSERT INTO mcp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ja jɔɔŋgʉ̂, Yésus mú nyiŋgə kɨ̂m nə ŋkulû nə́ ndɛɛ́ a mú nyiŋg kənd *jîm jé wə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Seegya nə́ məmá *sanda í á dʉ kalʉwo *Mpáánzə́ Zɛmbî yí í mú sɛɛl tʉ́tám nə́ cáŋ wú gwɔ̂w wɔ́ɔ́s shí. Shí í mú ntaŋʉsa, məkwóógʉ́ mə́ ŋgə́ sɛɛl. ");
INSERT INTO mcp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Məshwoŋ mə́ mú ŋgə bâŋ; bɔ́ɔ́l zhwog buud bwə́ á yə bwə́ njúl buud ɔ́ Zɛmbî wá mimbimbə myáŋ mí mú gwûm. ");
INSERT INTO mcp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bwə́ mú wú mə́shwoŋ máŋʉ́d nə́ ndɛɛ́, ja Yésus nyə á gwûm yí, bwə́ mú kə nyíi Yurʉ́səlɛm, ŋgwə́la mə́ Zɛmbî. Ncúlyá buud bwə́ á dʉ́g bwo. ");
INSERT INTO mcp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja lúlúú ízɨmbɨ nə bɔɔŋg bə́nɔ́ŋ bwə́ á ŋgə nyɛ́ɛlə Yésus wá bwə́ mə́ dʉ́g nda shí í mə́ ntaŋʉsa nə́, nə sâ jɛ̂sh í mə́ sɨ̂y yí, bwə́ mú bə nə iŋkuŋkúúnd, bwə́ mú lás nə́: «Bʉ́bə́lɛ́, muud ɛ́ga nyə á bə Mwân mə́ Zɛmbî». ");
INSERT INTO mcp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bɔ́ɔ́lʉ́gá búdá ŋkí bulya bwə́ á bə cínɔŋg bwə́ tə́l shwóg-shwóg ka dʉ dʉ́g. Budá bɔɔŋg bwə́ á ŋgə bɛ̧ Yésus tɛ́ Galilê, bwə́ ŋgə́ sɛ̂y nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nə Maríya á Magʉdála, nə Maríya nyɔ́ɔ́ŋgʉ̂ mə Zhâk bá Yósɛb, nə nyɔɔŋgʉ́ mə bwân ɔ́ Zhébedé bwə́ á bə gwooŋg búdá bɔɔŋg dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ja kugʉ́ í á bii shí yí, ŋgwɔ́l múúd nə jínə́ nə́ Yósɛb, a njúl bíg múúd á Arimatê músə zə wɔ́ɔ́s. Nyə á bə nə́mə́ *mpwíín mə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nyə á ka kə wə́ Pilât, kə jî nyə nə́ á cɛɛl ŋwa mbimbə mə Yésus. Pilât mú lwâm búúd, bwə́ kə yə nyə wə. ");
INSERT INTO mcp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yósɛb mú ŋwa mbimbə mə Yésus, a músə fʉ́lə wə ndómbó ágúgwáan dɨ̂, ");
INSERT INTO mcp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nə́ ndɛɛ́ a mú kə dʉl shwoŋ ágúgwáan nyə á sá nə́ bwə́ bwágʉləg kwóógʉ́d shú dɛ́ nyəmɛ́fwó yí. A mú bíŋgal məma kwóógʉ́, juwal shwoŋ nə́ ndɛɛ́ a músə kyey. ");
INSERT INTO mcp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maríya á Magʉdála nə gúlʉ́gá Maríya bwə́ á bə bwə́ njúl cínɔŋg nə́ bɛɛndyá nə shwoŋ. ");
INSERT INTO mcp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mán mələ̂m á mpʉ́sə jwɔ̂w bwə́ dʉ kwəmʉsa Sábaad yí, milúlúú myâ ofada nə *Ofarizyɛ̂ŋ bwə́ á kə wə́ Pilât sámbá ");
INSERT INTO mcp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kə cɨ nə nyə nə́: «Mása e, sə́ mə́ kə tə́dʉga nə́ muud məshɨɨgâ ɛ́nɛ nyə á dʉ cɨ ja nyə á dʉ ná cʉgə yí nə́: “Mə bá gwûm mpʉ́sə mwɔ̂w mə́lɔ́ɔl”. ");
INSERT INTO mcp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cɨɨ́g nə́ buud bwə́ kə́g baagʉsə shwoŋ kə wɔ́ɔ́s jwɔ̂w álɛ́ɛl, *ompwíín bɛ́ bwə́ á bá kə júwo mbimbə nə́ ndɛɛ́ bwə́ kə jaaw búúd nə́: “A mə́ gwûm”; mâŋ mə́shɨɨgâ mə́ á bá bul ntɔ̧ mə́ ashúshwóógʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilât mú cɨ nə bwo nə́: «Ozɨmbɨ wə́ ɔ́nɨ. Ŋwagá bwo, bɨ kə́g baagʉsə shwoŋ nda bɨ́ mə́ dʉ́g nə́.» ");
INSERT INTO mcp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bwə́ mú kə kwambʉlə mbaagʉsə á shwoŋ; bwə́ wá mə́yɨɨgyé máŋ kwóógʉ́ í á bə mpu shwoŋ dɨ́ yí, bwə́ tə̂l ózɨmbɨ tâŋ nda isándə́lé nə́ bwə́ mpúg ŋgə dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ja Sábaad nyə a cɔ̧́ yí, ná nə́mə́ mpʉ́mán mpʉ́mán á jwɔ̂w shwɛ́ndɛ mə́ dʉ́ tɛ́ɛ́d yí, Maríya á Magʉdála bə́ná ŋgwɔ́l Maríya bwə́ á weelya kə nə́ bwə́ kə́ dʉ́g shwoŋ. ");
INSERT INTO mcp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Seegya nə́ shí í mú jág ntaŋʉsa nəcé *éŋgəles mə Yawé nyə á shulə wú gwɔ̂w, zə bíŋgal məma kwóógʉ́ nə́ ndɛɛ́ a ji cínɔŋg gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eŋgəles wɔɔŋgʉ̂ nyə á ŋgə ŋkənʉwa nda njəs, mikáándə́ myɛ́ mí njúl ŋkí jág fumə. ");
INSERT INTO mcp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Isándə́lé í mú jág bul fúndə, bwə́ mú ŋgə lilya nə́ ndɛɛ́ bwə́ shîn kân nda mimbimbə. ");
INSERT INTO mcp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eŋgəles mú lás, cɨ nə budá nə́: «Bɨ bâŋ, kúgá fúndə. Mə mpú nə́ bɨ́ ŋgə sɔ̧́ Yésus bwə́ á bwambʉlə kwolós dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A cugɛ́ wa. A mə́ gwûm nda nyə á cɨ nə́. Zəgá dʉ́g kʉ́l nyə́ ámə dʉ bə a mbwúg yí. ");
INSERT INTO mcp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nə́ ndɛɛ́, lɛɛlʉgá kə, kə jaaw *ómpwíín bɛ́ nə́ a mə́ gwûm, a mə́ kə shwóg kə bwánd bɨ́ Galilê. Nûŋ wə́ bɨ́nɔ́ŋ bɨ́ é dʉ́gya yɛ́. Sâ mə́ ámə bə nə́ mə jaaw bɨ́ ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Budá bwə́ mú lɛɛl wú shwoŋ dɨ́, bwə́ njúl lâm nə ifwaas lâm nə məshusʉg. Bwə́ mú kə nə́ bwə́ kə́ jaaw ómpwíín bɛ́ məkə̂l. ");
INSERT INTO mcp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Seegya nə́ Yésus mú zə bwəma nə bwo, nyə nə bwo nə́: «Bɨ ɔ lás ɔ.» Bwə́ mú shísh nyə́dɨ́ kə kúdɔw shí bií nyə məkuú, yə nyə gúmə́. ");
INSERT INTO mcp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yésus mú ka cɨ nə bwo nə́: «Kúgá fúndə. Kəgá cɨ nə bwááŋg nə́ bwə́ kə́g Galilê. Núŋ wə́ sə́nɔ́ŋ bwo sə́ é dʉ́gya yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Budá bwə́ njúl ná zhɨ́ɨ́d ɨɨ́, bíl ísándə́lé í mə́ lɛɛl kə ŋgwə́la kə jaaw mílúlúú myâ ofada sâ jɛ̂sh í á mə sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Milúlúú myâ ofada mí mú kə sɛɛŋgya nə ocúmbá buud, bwə́ mú yə ísándə́lé fwámɛ́ bímbí lʉ́ *mwaanɛ̂, ");
INSERT INTO mcp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bwə́ nə bwo nə́: «Bɨ ɔ bá ŋgə jaaw nə́: “Wɛy ɛ́nɛ ompwíín bɛ́ bwə́ á mə zə mpwó-bulú zə júwo nyə, sə́ njúl ígwə́d”. ");
INSERT INTO mcp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ŋkí lâŋ wɔɔŋg í gwɨ́ɨ́g mə́lwə̂ mə́ ŋgwə́mʉna dɨ́, sə́ wə́ mə́ bá cweel nyə lâm, bɨ bâg bə kú bwəma nə intʉ́gʉ́lí.» ");
INSERT INTO mcp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Isándə́lé í mú ŋwa mwaanɛ̂ nə́ ndɛɛ́ bwə́ mú nə́mə́ kə ŋgə jaaw nda í á cɨy nə́ bwə́ ŋgə́g nə jaaw nə́. *Oyúdɛn bwə́ á ŋgə kala lâŋ wɔɔŋgʉ́ zə wɔ́ɔ́s múús. ");
INSERT INTO mcp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","*Ompwíín wûm nə ŋgwúd bwə́ á ka kə Galilê, kə kumə mbʉ́ŋ Yésus nyə á cɨ nə́ bwə́ bâg kə yí. ");
INSERT INTO mcp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja bwə́ á dʉ́g nyə yí, bwə́ á kúd mə́mpwoombʉ́ shí, yə nyə gúmə́. Njɨ, bwə́ á ŋgə bə kú fwo mpu *búgʉla nə́ jísə nyə. ");
INSERT INTO mcp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yésus músə shísh bwə́dɨ́ kúnə́-kúnə, zə cɨ nə bwo nə́: «Dá Zɛmbî mə́ yə mə ŋkul nə́ mə jwúg nə isâ byɛ̂sh, tɔɔ ya joŋ dɨ́, tɔɔ ya shî ga. ");
INSERT INTO mcp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ntɔ́, kagá ŋgə sá nə́ mə bə́g nə ompwíín ikûl nə ilwoŋ byɛ̂sh dɨ̂, bɨ ŋgə́ duu bwo jínə́ mə́ Zɛmbî Sɔ́ɔ́ŋgʉ́, nə Mwân, nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim dɨ̂, ");
INSERT INTO mcp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","bɨ ŋgə́ jɨ́ɨ́gʉli bwo nə́ bwə́ bɛ̧́g sâ jɛ̂sh mə́ á cɨ nə bɨ́ yí. Mpugá nə́ mə jɨ nə bɨ́ jwɔ̂w dɛ̂sh kə kumə mə́shíné mə́ shí.»");
INSERT INTO mcp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mətɛ́ɛ́dʉ́lé mə́ Jɔ̧jɔ̧ Kɛ́ɛ́l mə Yésus-Krîst, *Mwân mə́ Zɛmbî wə́ mə́ga: ");
INSERT INTO mcp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nə́mə́ nda jísə́ cilyá kálaad mə́ Izayî *muud micúndə́ dɨ́ nə́, nə́: Dʉgɨ́! Mɛɛ mə zə́ kənd mbwiiŋgyɛ lâŋ waamə́ nə́ a kə́g wo shwóg kə kwambʉlə wo zhɨɨ́. ");
INSERT INTO mcp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jísə kə́l mə́ múúd ŋgə́ cúndə shí a shwééshád yɛ́, a ŋgə cɨ nə́: «Kwambʉləgá zhɨ́ɨ́ mə́ Cwámba, bɨ́ sá íkwûŋ byé nə́ səndôŋ.» ");
INSERT INTO mcp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nə́ ndɛɛ́ Yuánɛs Nduu-buud nyə á zə cúwo shí a shwééshá dɨ̂, a mú ŋgə cúndə nə́ buud bwə́ cɛ́ndʉ́g mitə́dʉ́gá, bwə́ zə duwan, Zɛmbî yílʉ́g misə́m myáŋ lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ntɔ́, buud ɔ́ shí á Yudéa nə bɔɔŋg wâ Yurʉ́səlɛm bɛ̂sh bwə́ á dʉ kə nyə́dɨ́, kə́ dʉ magʉlə mísə́m myáŋ tâm buud. Yuánɛs mú dʉ duu bwo ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Káándə́ Yuánɛs nyə á dʉ bwáád yí í á bə sɨ́yá nə mimyɔ̧ɔ̧́ mí *shamô, kandá yé á kug nə kúúdú cúdú. Nyə á dʉ də ikájalá nə kwaan. ");
INSERT INTO mcp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nyə á dʉ cúndə nə́: «Ŋgwɔ́l múúd ŋgə zə mə mpʉ́sə, a jɨ nə mpífə́ cɔ̧́ mə. Nda mɛɛ, mə ampíyáyɛ́ nə́ mə kúdɔ́wʉ́g shí, ciny nyə mikwoolú mí mə́ŋgwub. ");
INSERT INTO mcp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɛɛ ŋgə duu bɨ́ nə məjúwó, njɨ nyɛ mə bá duu bɨ́ nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim.» ");
INSERT INTO mcp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mwɔ̂w mɔɔŋgʉ̂ dɨ, Yésus mú zə wɔ́ɔ́s, a ŋgə́ wú Nazarɛ̂t, shí a Galilê; Yuánɛs mú zə duu nyə Zhurdɛ̧̂. ");
INSERT INTO mcp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Í mú zə bə nə́, Yésus mə́ shîn duwan, a ŋgə́ cúwo wú mə́júwód ɨɨ́, a mú dʉ́g joŋ mə́ bâŋ, Shíshim mə́ Zɛmbî mú ŋgə shulə nda faf, zə ji nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kə́l mú cúwo wú joŋ dɨ́ nə́: «Wo wə́ Mwân waamə́ alâm. Lâm wâm wɛ̂sh wúsə wódɨ́.» ");
INSERT INTO mcp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ntɔ́, ja Yésus nyə a shîn duwan ntʉ́nɨ yí, kú nə́mə́ bwey, Shíshim mə́ Zɛmbî mú cíndal kənd nyə shí a shwééshád. ");
INSERT INTO mcp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A mú kə já wu mwɔ̂w məwûm mə́nɔ̧̂, *Sátan ŋgə́ bwɔ́wʉlə nyə. Bə́nɔ̂ŋ ocúdú ɔ́ anyinyaanə́ wə́ bwə́ á dʉ ji, *wəéŋgəles bwə́ ŋgə́ sɛ̂y nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bwə́ á ka wá Yuánɛs mímbwug dɨ̂. Yésus mú gwág, a mú kə Galilê, kə ŋgə cúndə Jɔ̧jɔ̧ Kɛ́ɛ́l mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nyə nə́: «Fwála í mə́ wɔ́ɔ́s. Faan mə́ Zɛmbî í mú kúnə́-kúnə, cɛ́ndʉ́gá mitə́dʉ́gá! *Magʉləgá Jɔ̧jɔ̧ Kɛ́ɛl!» ");
INSERT INTO mcp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dúl jwɔ́w, Yésus ŋgə́ cɔ̧́ ncindye mâŋ mâ Galilê, nyə a dʉ́g Shímun bá mínyɔŋʉ̂ yé Andrê, bwə́ ŋgə́ wusə wód mə́júwód. Bwə́ á dʉ julə oshû nə məwód. ");
INSERT INTO mcp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yésus mú cɨ nə bwo nə́: «Bɛ̧gá mə, mə é sá nə́ bɨ́ dʉ́g julə búúd.» ");
INSERT INTO mcp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nə́mə́ cé nə cé bwə́ mú lʉ́gə mə́wód, bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ja bwə́ mə́ ŋwá shísh shwóg yí, Yésus músə nyiŋgə dʉ́g Zhâk bá mínyɔŋʉ̂ yé Yuánɛs, bwân ɔ́ Zhébedé, bwə́ njúl nə́mə́ byɔ́ɔ́lʉ́d, bwə́ ŋgə́ kwambʉlə məwód. ");
INSERT INTO mcp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cé nə cé a mú nə́mə́ jɔ̂w bwo. Bwə́ mú lʉ́gə sɔ́ɔ́ŋgʉ́ wáŋ Zhébedé bə́nɔ̂ŋ osɔ́ɔl ɔ́ mə́sáal byɔ́ɔ́lʉ́d, bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bə́nɔ́ŋ bwə́ mú kə Kapɛrnawûm. Yésus mú fwo kə nyíi *mpáánzə́ mínjɨ́ɨ́gʉ́lá jwɔ̂w lʉ́ Sábaad, kə yə búúd minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Buud bwə́ mú bul káam mbií nyə á ŋgə jɨ́ɨ́gʉli yí, nəcé nyə á ŋgə jɨ́ɨ́gʉli nə kɛ́ɛ́nd, kú bə nda *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧. ");
INSERT INTO mcp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cínɔŋg mpáánzə́ mínjɨ́ɨ́gʉ́lá dɨ́, ŋgwɔ́lʉ́gá múúd nyə á bə nə bɔ́w-bɔ̂w shíshim í dʉ lwáfʉlə nyə. Cé nə cé a mú kɨ̂m nə́: ");
INSERT INTO mcp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yésus, muud Nazarɛ̂t! Shé bâŋ nə inɛy? Ye wo ámə zə jaŋgʉlə sə̂? Mɛɛ mə mpú wo. Wo wə́ fééshá múúd mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yésus mú ŋkáánd nə jamb. Nyə nə dwo nə́: «Fadʉg mpu! Wúg múúd ɛ́nɛ nyúúlʉ́d!» ");
INSERT INTO mcp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bɔ́w-bɔ̂w shíshim wɔɔŋgʉ́ í mú juŋg múúd ɛ́nɛ nə ŋkulû, í kɨ̂m məma ŋkwiimbyê nə́ ndɛɛ́ wɔ́ɔ́s tɔ́ɔ́n. ");
INSERT INTO mcp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Buud bɛ̂sh bwə́ mú bul káam, bwə́ ŋgə́ nyímbʉla nə́: «Jáyɛ́ ga? Míga mínjɨ́ɨ́gʉ́lá mí mə́ bə gúgwáan ɛ! Nə məma kɛ́ɛ́nd! A ká nə́mə́ lás, tɔɔ ibɔ́w-bɔ̂w míshíshim mí ŋgə́ bə́lɛ sá nyə məgwág!» ");
INSERT INTO mcp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jínə́ dɛ́ í mú jwɔ̧ lɔɔm á Galilê wɛ̂sh dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yésus bə́nɔ̂ŋ Zhâk nə Yuánɛs bwə́ mú zə wú mpáánzə́ minjɨ́ɨ́gʉ́lá, kə Shímun bá Andrê dɨ́ njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Í á bə, Shímun cii yé á mudá mbwúg shí, ayɔ̂ŋ nə yɔ̂ŋ mə́ bií nyə. Bwə́ ka lɛɛl jaaw Yésus nə́mə́ njɨ bwə́ á nyíi njɔ́w yí. ");
INSERT INTO mcp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A mú shísh mudá kúnə́-kúnə, bií nyə mbwə́d, tə̂l nyə tʉ́təlî, ayɔ̂ŋ nə yɔ̂ŋ mú shwal shîn. Mudá wɔɔŋg mú zə tɛ́ɛ́d sɛ́yʉ́lə nə bwo. ");
INSERT INTO mcp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mpwó-kugʉ́ shí, buud ɔ́ ŋgwə́la bwə́ mú zə nə mimbə̂l myɛ̂sh nyə́dɨ́, tɔɔ mimbə̂l mí mə́jamb. ");
INSERT INTO mcp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ntɔ́ bwə́ mú zə ŋkúndɔw mpumbɛ́d nə́ jəd. ");
INSERT INTO mcp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Cínɔŋg Yésus mú lwag zhwog mimbə̂l mí á bə nə məbwas mímbií mímbií myá, myɛ̂sh mí yâl. A yîl nə́mə́ zhwog buud məjamb, a kú bɨ́d nə́ mə́jamb mɔɔŋgʉ̂ mə́ lásʉ́g, nəcé mə́ á ŋgə mpú nyə. ");
INSERT INTO mcp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ntɔ́, ná mpʉ́mán mpʉ́mán, jwɔ̂w kú fwo sâŋ, Yésus mú zə wɔɔl, wɔ́ɔ́s tɔ́ɔ́n, kə gúl kʉ́l í á shígɛ́ bə nə buud yí, kə jəgʉla nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nyə ŋgə́ ná jəgʉla wu, Shímun bə́nɔ̂ŋ bɔ́ɔ́l *ómpwíín bwə́ mú kə sɔ̧́ nyə. ");
INSERT INTO mcp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ja bwə́ mə́ kwey nyə yí, bwə́ mú cɨ nə nɛ́ nə́: «Buud bɛ̂sh, bwə́ ŋgə sɔ̧́ wo.» ");
INSERT INTO mcp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ntɔ́ Yésus mú cɨ nə bwo nə́: «Iŋkyenâ! Shé kə́g mɔ́ɔ́l mə́nd mə́sə́ wa mə́koogʉ́ məkoogʉ́ má! Mə́ jəlá nə cúndə nə́mə́ Jɔ̧jɔ̧ Kɛ́ɛ́l wu, nəcé sâ jɔɔŋg wə́ mə́ á zə sá yí.» ");
INSERT INTO mcp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ntɔ́ a mú kə shí á Galilê nyɛ́shʉd, kə ŋgə cúndə *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ̂, nyə ŋgə́ yîl buud məjamb. ");
INSERT INTO mcp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wúl zʉ́zaamə́ í á ka zə wə́ Yésus, zə kúd mə́bwóŋ shí, tɛ́ɛ́g nyə məbwə̂, cɨ nə nyə nə́, «Ŋkí wó magʉlə wo je lwag mə, nyúúl bə mə nə́ səndôŋ.» ");
INSERT INTO mcp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yésus mú gwág nyə ŋkúŋkwoŋ, nyə sɛ́ɛ́mb mbwə̂, kúnya nə nɛ́. Nyə nə́: «Mə́ magʉlə. Nyúúl í bə́g wo nə́ səndôŋ!» ");
INSERT INTO mcp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cé nə cé jɔɔŋgʉ̂ zaamə́ í mú shîn múúd ɛ́nɛ nyúúlʉ́d. Nyúul í mú bə nyə nə́ səndôŋ. ");
INSERT INTO mcp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yésus mú báásʉlə nyə, a ŋgə́ ŋkáánd nə́: «Ci wo kú jaaw múúd sâ í mə́ sɨ̂y yí. Yidagʉ́ kə lwágʉlə fada nda wó músə́ nə́, wo ka wá sâ Moyîz nyə á cɨ yí shú yálʉ́lə wó mə́ yâl nɨ. Bwə́ mpúg nə́ wo mú mpwogɛ́.» Cé nə cé nyə mú nyiŋg muud ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yésus nyə á tɛɛm báásʉlə muud ɛ́nɛ ntʉ́nɨ, muud ɛ́nɛ nyə á kə ŋgə jaaw lâŋ wɔɔŋgʉ̂ kʉ́l jɛ̂sh, a ŋgə́ báŋgʉla nə sâ í á sɨ̂y nə nyə yí. Sâ jɔɔŋgʉ̂ wə́ Yésus nyə a shígɛ́ ná kwo bə nə ŋkul nə́ a nyííg wúl ŋgwə́la dɨ́ buud bwə́ ŋgə́ dʉ́g nyə yí. Nyə á shwal dʉ ji njɨ íkʉ́l búúd bwə́ á shígɛ́ dʉ bə yí. Buud yidá dʉ wú íkʉl ikʉl, dʉ zə kwey nyə cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mpʉ́sə baalɛ́ mwɔ̂w, Yésus mú nyiŋgə zə Kapɛrnawûm. Buud bwə́ mú zə mpu nə́ a jɨ cínɔŋg njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bwə́ mú zə sɛɛŋgya áncuncuma, váál á nə́ kú nə tɔɔ cé kuú tɔ́ɔ́n balánda dɨ̂. Yésus mú ŋgə bwiiŋg bwo Milə́sʉ́ mí Zɛmbî cínɔŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A ŋgə́ bwiiŋg ntʉ́nɨ, bɔ́ɔ́l búúd onɔ̧̂ bwə́ mú zə nyə́dɨ́, bwə́ ŋgə́ ŋkɛ̂ny mbúmbwúgʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bwə́ á shígɛ́ dʉ́g kʉ́l bɨ́ nə ŋkul cɔ̧́ nə mbə̂l wáŋ yí nəcé buud bə́lə áncuncuma. Bwə́ mú kə cúwo luun kwáminʉ́ nə́ bɛɛndyá nə kʉ́l Yésus nyə á bə yí, bwə́ mú shul mbúmbwúgʉ́ wáŋ cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yésus mú dʉ́g nə́ buud bɔɔŋgʉ́ bʉ́sə nə fwámɛ́ búgə́, a mú cɨ nə mbúmbwúgʉ́ nə́: «Mwân waam! Mə mə́ juu wo nə *misə́m myô!» ");
INSERT INTO mcp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Í njúl nə́ bɔ́ɔ́l *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á bə cínɔŋg bwə́ njúl shí, bwə́ ŋgə lás mílâm dɨ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Nəcé jɨ́ múúd ɛ́nɛ mə mpú lás ntʉ́nɨ yí? A ŋgə *lás nə Zɛmbî bwaasʉ́lə mpu. Zə́ ŋgwɔ́l jɨ́ nə ŋkul juu búúd misə́m myɛ́d kwoŋ Zɛmbî nyəmɛ́fwó yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yésus mú lɛɛlʉ́ mpu sâ bwə́ á ŋgə lás bwə́dɨ́ mílâm dɨ́ yí. A mú cɨ nə bwo nə́: «Nəcé jɨ́ bɨ́ ŋgə́ lás ntʉ́nɨ bɨ́dɨ́ mílâm dɨ́ yí? ");
INSERT INTO mcp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Jɨ́ í búl bə kúnə́-kúnə? Ye cɨ́lə nə mbúmbwúgʉ́ nə́: “Mə mə́ juu wo nə misə́m myô”, ye cɨ́lə nə nyə nə́: “Wɔɔlʉ́g wo ŋwág taŋʉ́ gwô, wo kyéyʉg”? ");
INSERT INTO mcp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mə́ ka cɛɛl nə́ bɨ mpúg nə́ *Mwân mə Múúd jɨ nə ŋkul ijwûga nə́ a juu búúd nə misə́m myáŋ wa shí.» Nə́ ndɛɛ́ a mú cɨ nə mbúmbwúgʉ́ nə́ ");
INSERT INTO mcp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Mə́ cɨ nə wo nə́ wɔɔlʉ́g, wo báágʉ́g taŋʉ́ gwô, wo nyíŋgəg, kə njɔ́w». ");
INSERT INTO mcp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cé nə cé, muud wɔɔŋgʉ̂ mú wɔɔl, báág taŋʉ́ jé, kyey buud bɛ̂sh bwə́ ŋgə́ dʉ́g. Bɛ̂sh bwə́ mú ŋgə káam, bwə́ mú yə Zɛmbî gúmə́, bwə́ nə́: «Sə́ abwɛ́lɛ́ dʉ́g gúlʉ́gá sâ ntʉ́ga!» ");
INSERT INTO mcp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mpʉ́sə cínɔŋg, Yésus mú nyiŋgə kə ŋgɛɛ́ mâŋ, áncuncuma buud ŋgə́ bɛ̧ nyə, a ŋgə́ jɨ́ɨ́gʉli bwo Milə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nyə ŋgə́ kyey, a mú dʉ́g Lévi, mwân mə́ Alfê, ŋgə́ sɛ̂y wú bwə́ dʉ jə́na ótóya wá. Yésus mú cɨ nə nɛ́ nə́: «Bɛ̧g mə.» A mú tɔ̂w, bɛ̧ Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Í á ka zə bə nə́, Yésus njúl Lévi dɨ́ njɔ́w a ŋgə́ də, zhwog oŋwɛnyɛ ɔ tóya nə bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́bɔ̂w bwə́ mú nə́mə́ zə, bə́nɔ̂ŋ nyə nə ompwíín bɛ́ zə də, nəcé mimbií mi búúd myɔɔŋgʉ́ ŋkí bulya mí á ŋgə bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","*Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á bə *Ofarizyɛ̂ŋ wá, bwə́ á bə nə́mə́ cínɔŋg. Bwə́ mú dʉ́g nə́ Yésus ŋgə də kʉl ŋgwúd nə osɔ́ɔl ɔ́ mə́bɔ̂w nə oŋwɛnyɛ ɔ́ ótóya. Bwə́ mú jí ómpwíín bɛ́ nə́: «Nəcé jɨ́ á ŋgə́ bə́lɛ də nə oŋwɛnyɛ ɔ tóya nə bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́bɔ̂w yí?» ");
INSERT INTO mcp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yésus mú gwág sâ bwə́ á ŋgə cɨ yí. Nyə mú cɨ nə bwo nə́: «Mikanz dɨ́ mí dʉ jɨɨ jwɔ́wʉda, í dʉ bə mímbə̂l. Mə a shígɛ́ zə jɔ̂w ótʉ́təlí ɔ búúd. Mə á yida zə jɔ̂w osɔ́ɔl ɔ mə́bɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ompwíín ɔ́ Yuánɛs bə́nɔ̂ŋ Ofarizyɛ̂ŋ, bwə́ á ŋgə ci idʉ̂w yə́lə Zɛmbî gúmə́. Buud bwə́ mú ka kə jî Yésus nə́: «Nəcé jɨ́ ómpwíín ɔ́ Yuánɛs bə́nɔ̂ŋ *Ofarizyɛ̂ŋ bwə́ ŋgə́ ci idʉ̂w yə́lə Zɛmbî gúmə́, wɛɛ bwô bâŋ kú ci yí?» ");
INSERT INTO mcp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yésus mú bɛ̧sa nə bwo nə́: «Ja múúd mə́ ŋwa bâ yí, a tə̂l zâŋ, a jɔ̂w óshwə́ bɛ́; ye oshwə́ bɛ́ bwə́ yidá zə nə məcɛy lámʉ́d bə́nɔ̂ŋ muud bâ bwə́ njúl kʉ́l ŋgwúd? Mbɔ̂. Té wɛ̂sh bə́nɔ̂ŋ muud nyə́ ámə ŋwa bá yɛ́ bʉ́sə́ yí, bwə́ cúgɛ́ nə ŋkul ci də́lə. ");
INSERT INTO mcp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Njɨ mɔ́ɔ́l mwɔ̂w mə́ ŋgə zə, bwə́ bá yîl bwo muud bâ yí. Mwɔ̂w mɔɔŋgʉ́ dɨ́ ɔ́ óshwə́ bɛ́ bwə́ ka bá ci ídʉ̂w yí. ");
INSERT INTO mcp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mpugá nə́ bwə́ ádɛ́ ŋwa kʉ́l káándə́ ágúgwáan kə wá bágá bwoodʉ́ káándə́d; bágá dɔɔŋg í é bá juli, í tʉ̂w, í yida bweeg luun lʉ káándə́. ");
INSERT INTO mcp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ntɔ́ nə́mə́, muud cugɛ́ nə ŋkul ŋwa wáan ágúgwáan kə wá bwoodʉ́ lɛnyad, wáan í é bá sá nə́ lɛnya í búndʉ́g, nə wáan nə lɛnya byɛ̂sh ntáma. Í jɨɨ nə́ bwə́ dʉ́g wá wáan ágúgwáan ílɛnya í agúgwáanʉd.» ");
INSERT INTO mcp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Í á wɔ́ɔ́s dúlʉ́gá jwɔ̂w lʉ́ Sábaad dɨ́ nə́ Yésus bə́nɔ̂ŋ ompwíín bɛ́ bwə́ á ŋgə lɨ́ɨ́na ifambə́ í *blé, ompwíín bwə́ mú ka ŋgə búgə mikʉŋg mí blé. ");
INSERT INTO mcp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nə́ ndɛɛ́, bɔ́ɔ́l *Ofarizyɛ̂ŋ bwə́ mú cɨ nə Yésus nə́: «Dʉ́gʉ́g, nəcé jɨ́ ómpwíín bwô bwə́ ŋgə́ sá sâ mə́cɛ̧ɛ̧ mə́ amágʉ́lə́yɛ́ nə́ muud sáág jwɔ̂w lʉ́ Sábaad yí?» ");
INSERT INTO mcp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yésus mú cɨ nə bwo nə́: «Ye bɨ afwóyɛ́ bwɛlɛ lɔ̧́ sâ *Dávid nyə á sá ja ídʉ̂w í á fúfə nyə bə́nɔ̂ŋ buud bɛ́ bwə́ ŋgə́ gwág zha yí? ");
INSERT INTO mcp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nə́ nyə á kə nyíi banda *mə́túnʉga dɨ́ Abiyatar njúl Ajəlácɨ á ofada, kə bə́lɛ də íbʉlɛ́d í á bə ci shú yə́lə Zɛmbî gúmə́ a yə nə́mə́ búúd bɛ́ bwə́ də nə́mə́; í njúl nə́ məcɛ̧ɛ̧ mə́ dʉ cɨ nə́ njɨ ofada wə́ bwə́ dʉ́g də byo.» ");
INSERT INTO mcp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yésus mú nyiŋgə cɨ nə bwo nə́: «Zɛmbî nyə á tə̂l jwɔ̂w lʉ́ sábaad shú mə́nywa mə múúd. Nyə á shígɛ́ kwambʉlə múúd nəcé jwɔ̂w dɔɔŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ntɔ́ jɨ nə́, *Mwân mə Múúd ŋgə nə́mə́ jwú nə məcɛ̧ɛ̧ mə Sábaad.» ");
INSERT INTO mcp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yésus mú nyiŋgə kə nyíi *mpáánzə́ mínjɨ́ɨ́gʉ́lá. Ŋgwɔ́l múúd nyə á bə cínɔŋg nə mbwə̂ í mə́ shîn shwáámb. ");
INSERT INTO mcp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bɔ́ɔ́lʉ́gá búúd bwə́ á bə nə́mə́ cínɔŋg, bwə́ ŋgə́ fáf nə́ ka Yésus nyə é lwag múúd wɔɔŋgʉ̂ jwɔ̂w lʉ́ Sábaad. Nyə ká sá ntɔ́, bwə́ kə shwə́man nyə. ");
INSERT INTO mcp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ntɔ́ Yésus mú zə cɨ nə muud á mbwə̂ shwáámbʉ́lə nə́: «Tɔ́wʉ́g tʉ́təlí na tâm buud!» ");
INSERT INTO mcp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yésus mú jí búúd bwə́ á bə mpáánzə́ wá nə́: «Məcɛ̧ɛ̧ mə́shé mə́ magʉlə nə́ jɨ́ í sɨ́yʉ́g jwɔ̂w lʉ́ Sábaad? Ye nə́ sə́ sáág mənywa, ye nə́ sə́ sáág məbɔ̂w, ye nə́ sə́ cʉ́gʉg buud, ye sə́ gwúg?» Bɛ̂sh bwə́ mú ji nə́ kufʉg! ");
INSERT INTO mcp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A mú ciŋg mpwóómbʉ́ ŋgə dʉ́g bɛ̂sh nyə́dɨ́ mə́koogʉ́, nə mpimbə nəcé nyə a dʉ́g nə́ bʉ́sə ŋkí lal milúu. A mú cɨ nə muud á shwáámbʉ́lə mbwə̂ nə́: «Kwéégʉ́g mbwə̂.» A mú kwéég mbwə̂, í mú bə mpwogɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ofarizyɛ̂ŋ bə́nɔ̂ŋ buud wâ gwooŋg í á dʉ ságʉsə ijwûga í Herod yí, bwə́ mú ntâg wɔ́ɔ́s tɔ́ɔ́n, kə sá shwushwaga, sɔ̧́lə zhɨ́ɨ́ nə́ bwə́ cɛ̧ɛ̧lə Yésus shwɨy. ");
INSERT INTO mcp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yésus bə́nɔ̂ŋ *ómpwíín bɛ́ bwə́ mú wú cínɔŋg, kə mâŋ, buud bwə́ ŋgə́ bɛ̧ nyə áncuncuma. Bʉ́ga wú shí á Galilê, bɔ́ɔ́lʉ́gá wú shí á Yudéa, ");
INSERT INTO mcp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","bʉ́ga wú ŋgɛɛ́ ŋgwə́la Yurʉ́səlɛm, bɔ́ɔ́lʉ́gá wú lɔɔm Idume, bɔ́ɔ́lʉ́gá wú cíndú Zhurdɛ̧̂, bɔ́ɔ́lʉ́gá wú kúnə́-kúnə nə miŋgwə́la myâ Tir nə Sidon. Buud bɔɔŋgʉ́ bwə́ á ŋgə bɛ̧ nyə áncuncuma ntɔ́ nəcé bwə́ á ŋgə gwág isâ byɛ̂sh nyə á ŋgə sâ yí. ");
INSERT INTO mcp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nyə a ka cɨ nə ompwíín nə́ bwə́ bwɨ́ɨ́gʉ́g nyə ŋkúmba bíbyɔ́ɔ́l, nyə é dʉ ji cínɔŋg cwû ncúlyá buud ɔ́nɨ bwə́ nda shúsə nyə. ");
INSERT INTO mcp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nəcé í á dʉ bə nə́, nda nyə á dʉ lwag zhwog buud nə́, buud bɛ̂sh bwə́ á bə nə məbwas wá bwə́ á ŋgə shwɔ̧ nə bwə́ kúnyá nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bɔ́w-bɔ̂w míshíshim mí á ka dʉ́g Yésus, mí mú kə wusə mə́nyúúl nyə́dɨ́ shí mə́kuú, mí ŋgə́ kɨ̂m nə́: «Wo wə́ Mwân mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Njɨ Yésus mú mpu báásʉlə myə nə́ mí kú bwɛlɛ sá nə́ buud bwə́ mpúg mbii váál múúd á jísə́ yí. ");
INSERT INTO mcp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yésus mú wú na, kə bád mbʉ́mbʉ́ŋʉ́d. A mú jɔ̂w búúd nyə á cɛɛl wá. Bwə́ mú kə nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A mú fɛ́ɛ́sh búúd wûm nə óbá, gwiid bwo nə́ *buud ɔ lwámá bɛ́, nə́ bwə́ dʉ nə́mə́ bə nyə́dɨ́ koogʉ́, a dʉ kənd bwo kə dʉ cúndə Jɔ̧jɔ̧ Kɛ́ɛ́l. ");
INSERT INTO mcp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","A mú nə́mə́ yə bwo ŋkul nə́ bwə́ kə́g ŋgə yîl buud məjamb. ");
INSERT INTO mcp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nyə a fɛ́ɛ́sh bwo ntʉ́ga: a fɛ́ɛ́sh Shímun, a mú gwiid nyə nə́ Pyɛ̂r, ");
INSERT INTO mcp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","a fɛ́ɛ́sh Zhâk, bá mínyɔŋʉ̂ yé, Yuánɛs, bwân ɔ́ Zhébedé, a mú gwiid bwo nə́ «Bowanɛrgɛs», ntɔ́ mə́ kə́ nə́ «Bwân ɔ́ Ŋkɛ̂l Mpú», ");
INSERT INTO mcp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","a fɛ́ɛ́sh nə́mə́ Andrê bə́nɔ̂ŋ Fílíp nə Batəlʉmî, nə Matiyô bə́nɔ̂ŋ Tómas nə Zhâk, mwân mə́ Alfê, nə́ Tadê nə Shímun muud nyə á bə «Kambʉlɛ lɔɔm» yɛ́, ");
INSERT INTO mcp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ka zə kɛɛl Yúdas Iskariyôt, muud nyə á kusha nə Yésus yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mpʉ́sə na, Yésus mú nyiŋgə kə njɔ́w. Buud bwə́ á bə áncuncuma wá bwə́ mú zə sɛɛŋgya cínɔŋg mbií á nə́ bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ á shígɛ́ bə nə baan nə́ bwə́ də́g. ");
INSERT INTO mcp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Njɔ́w búúd yé í mú gwág sâ jɔɔŋgʉ̂. Bwə́ mú zə nə́ bwə́ zə́ ŋwa nyə nə ŋkul, nəcé bwə́ á ŋgə cɨ nə́: «Lúu í cugɛ́ ná nyə mpwogɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","*Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á ka shulə wú Yurʉ́səlɛm wá bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «Bɛlʉzebul mə́ tɔ̂w nyə lúúd. A ŋgə yîl buud məjamb nə ŋkul mə́ Bɛlʉzebul wɔɔŋgʉ̂, njwû məjamb.» ");
INSERT INTO mcp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yésus mú ka jɔ̂w bwo nə́ bwə́ shíshʉ́g nyə́dɨ́. Nyə mú lás nə bwo kaanə́d. Nyə nə́: «Mbií wáyɛ́ *Sátan jɨ́ nə ŋkul wɨ́ɨ́ŋg Sátan yí? ");
INSERT INTO mcp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ŋkí buud ɔ dúl faan bwə́ bɔ́ɔ́g ŋgə lúmbʉli bwə́mɛ́ nə bwə́mɛ́, faan dɔɔŋg í ámpúyɛ́ ná tɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Búúd ɔ wúl njɔ́w bwə́ ká bɔ́ɔ́g ŋgə lúmbʉli bwə́mɛ́ nə bwə́mɛ́, njɔ́w búúd wɔɔŋg í ábʉ́lɛ́ bwey nə jímbʉ́lə. ");
INSERT INTO mcp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ŋkí Sátan mə́ yida nyiŋgə cuwo, ŋgə yîl nyəmɛ́fwó, a mə́ bɔ́ɔ́g wə́ nɨ, a cugɛ́ ná nə ŋkul tɔ̂w, a jɛ̧ɛ̧. ");
INSERT INTO mcp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Muud cúgɛ́ nə ŋkul nyíi njɔ́w mə́ ŋkuŋkúl, júwo nyə isâ byé, a kú fwo figə ŋkuŋkúl wɔɔŋg shí, wɔ́ɔlə nyə məŋkəda. Njɨ, á ká shîn wɔ́ɔlə nyə məŋkəda, a mú ka tɛɛm sha nyə njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, *misə́m myɛ̂sh búúd bwə́ sá myá, nə bímbí lʉ́ *bwaasʉ́lə mpu dɛ̂sh bwə́ bá sá yí, í bá bə nə ijuugá. ");
INSERT INTO mcp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Njɨɨ, múúd yɛ̂sh mə bá kə nə bwaasʉ́lə mpu wə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim yɛ́, nyə abʉ́lɛ bwɛlɛ bə nə ijuugá. Nyɨ́nɨ múúd mə́ sá sə́m á kandʉgə kandʉgə.» ");
INSERT INTO mcp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yésus nyə á lás ntɔ́ nəcé bwə́ á ŋgə cɨ nə́: «A jɨ nə bɔ́w-bɔ̂w shíshim.» ");
INSERT INTO mcp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nyɔɔŋgʉ́ mə Yésus bə́nɔ̂ŋ omínyɔŋʉ̂ bɛ́ bwə́ á ka jê, bwə́ mú tɔ̂w tɔ́ɔ́n, ka lwâm muud nə́ a kə́g jɔ̂w bwo Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yésus nyə á ka bə mə́ŋkúmbə mə búúd dɨ́, bwə́ mú jaaw nyə nə́: «Nyɔɔŋgʉ́ woó bə́nɔ̂ŋ omínyɔŋʉ̂ bwô bɨ́ na tɔ́ɔ́n, bwə́ ŋgə sɔ̧́ wo.» ");
INSERT INTO mcp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yésus mú bɛ̧sa nə bwo, nyə nə́: «Nyɔɔŋgʉ́ waamə̂ wə́ zə? Omínyɔŋʉ̂ báamə́ wə́ ozə́?» ");
INSERT INTO mcp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A mú kənd mísh dʉ́g búúd bwə́ á ŋgə lyɛ̧ nyə wá, nyə nə́: «Dʉgá, nyɔɔŋgʉ́ waamə́ nə omínyɔŋʉ̂ báamə́, bwə́ wə́ ɔ́ga! ");
INSERT INTO mcp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Muud yɛ̂sh mə́ dʉ sá sâ Zɛmbî mə jɨ́ɨ yɛ́, nyə wə́ jɨ́ mínyɔŋʉ̂ waamə́, ŋkí kɔ́ɔ́l waamə́ ŋkí ntâg nyɔɔŋgʉ́ waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dúlʉ́gá jwɔ̂w, Yésus nyə á ŋgə nyiŋgə jɨ́ɨ́gʉli buud, bwə́ njúl ncindye mâŋ. Buud bwə́ á ka sɛɛŋgya nyə́dɨ́ ŋkí jág bulya nə ndɛɛ́, a mú tɔ̂w kə kəwa byɔ́ɔ́lʉ́d, ji shí, buud bâŋ cíndú. ");
INSERT INTO mcp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A mú ŋgə jɨ́ɨ́gʉli bwo zhwog isâ míkandad. Nyə nə bwo nyə́dɨ́ njɨ́ɨ́gʉ́lád nə́: ");
INSERT INTO mcp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Bɛ́nyʉ́gá məlwə̂, bɨ mpúg gwágʉlə! Ŋgwɔ́l mbɔɔl məmpəg nyə á kə myɛɛg mpəg. ");
INSERT INTO mcp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Í á ka bə, a ŋgə́ myɛɛg ɨɨ́, nyúl mpumə́ mú shugʉla zhɨ́ɨ́ nə zhɨɨ́. Inunú í mú zə, zə shîn lúú nywô. ");
INSERT INTO mcp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nyúl mpúmə́ í mú shugʉla shí á məkwóógʉ́d, kú nə fwámɛ́ mə́ndəlú cínɔŋg. Í mú nə́mə́ lɛɛl wéésh míŋgwu, nəcé məndəlú mə́ á shígɛ́ fifə. ");
INSERT INTO mcp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Njɨɨ́, ja yásə́ í mə́ faan yí, miŋgwu mi mpwásə́ mí mú jígə, shîn shwáás nəcé kú nə fwámɛ́ míkɔ̧ɔ̧lə́. ");
INSERT INTO mcp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nyúl mpumə́ í mú shugʉla íbiin-bíinʉd. Ibiin-bíin byɔɔŋg í mú lɛɛl juwo nə́ ndɛɛ́ káda íkɔ̧́lə í mpəg, í mú bə kú wúmə tɔɔ bumə́. ");
INSERT INTO mcp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Njɨɨ́, nyúl mpúmə́ í á shugʉla tag-tag shí dɨ̂, í mú kɔ̧́, mpu wɨ̂y. Í mú ŋgə wúmə, dúl shug ibumə́ məwûm mə́lɔ́ɔl, dúlʉ́gá məwûm mə́saman, dúlʉ́gá təd.» ");
INSERT INTO mcp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yésus mú cɨ nə bwo nə́: «Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, a gwág!» ");
INSERT INTO mcp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ja á mə́ kə bə nyə́mɛ́fwó yí, *ompwíín bɛ́ wûm nə óbá nə buud bə́nɔ́ŋ bwə́ á bə wá, bwə́ mú jí nyə nə́ a jááwʉg bwo nda míkanda mí kə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yésus mú bɛ̧sa nə́: «Zɛmbî nyə a mə́ yə bɨ́ báá *ndímba á Faan dɛ́. Njɨ buud ɔ tɔ́ɔ́n bâŋ bwə́ é dʉ gwág njɨ mikanda ");
INSERT INTO mcp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","shú nə́ bwə́ dʉ́g bə, bwə́ tɛɛm kənd mísh, bwə́ kú dʉ́g; bwə́ tɛɛm gwágʉlə, bwə́ kú wámbʉlə, ŋkwaŋgá bwə́ á bá cɛ́nd kuú njɔɔnd, Zɛmbî juu bwo.» ");
INSERT INTO mcp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A mú jí bwo nə́: «Bɨ agwágɛ́ kanda nɨ? Ká bɨ́ é bá ka gwág mílʉ́gá na ntʉdɛlɛ̂? ");
INSERT INTO mcp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbɔɔl məmpəg mə́ dʉ bɛ̧ Mílə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Buud bʉ́sə́ tâŋ nda zhɨɨ́ nə zhɨɨ́ kʉ́l mpəg Mílə́sʉ́ mí Zɛmbî í á myɛɛgya yí, jísə bɔɔŋg bwə́ á bə nə́, bwə́ ká nə́mə́ shîn gwág Mílə́sʉ́ mí Zɛmbî, *Sátan lɛɛ́l ntâg nə́mə́ zə, zə yîl bwo mpəg í ámə kə lámʉ́d yí. ");
INSERT INTO mcp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ntɔ́ nə́mə́, bɔ́ɔ́l bʉ́sə nda bwə́ dʉ lə́g mpəg shí á mə́kwóógʉ́d. Ja bwə́ gwág Milə́sʉ́ mí Zɛmbî, bwə́ tɛ́ɛ́d fwo lə́g myə nə məshusʉg; ");
INSERT INTO mcp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","njɨ bwə́ kú nə mikɔ̧ɔ̧lə́ bwə́dɨ́ cʉgʉd, bwə́ kú wá nadâ, bwə́ bɛ̧ Mílə́sʉ́ mí Zɛmbî njɨ kʉ́kʉ́l baan, bwə́ ká nə́mə́ bwəma nə məntágʉla ŋkí cúwʉ́lí nəcé Mílə́sʉ́ mí Zɛmbî, bwə́ julə mə́nyúul. ");
INSERT INTO mcp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bɔ́ɔ́l bwə́ dʉ lə́g mpəg íbiin-bíin dɨ̂. Bâŋ bʉ́sə nə́, bwə́ gwág Mílə́sʉ́ mí Zɛmbî, ");
INSERT INTO mcp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","njɨɨ́, yágʉ́wó ísâ yâ mâŋ mwɔ̂w, nə wɨ́ɨ́mbʉ́lə mə́bii, nə bíl zhwog iwɨ́ɨ́mbʉ́g yâ cʉg í mú zə káda Mílə́sʉ́ mí Zɛmbî, mí mú bə nda wúmə. ");
INSERT INTO mcp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bɔ́ɔ́l báá bʉ́sə nda bwə́ dʉ lə́g mpəg shí átʉtagʉ́ dɨ̂. Bâŋ bʉ́sə nə́, bwə́ gwág Mílə́sʉ́ mí Zɛmbî, bwə́ lə́g myə, bwə́ mú wúmə mpúmə́, dúl shug wúmə íbumə́ məwúm mə́lɔ́ɔl, dúl məwúm mə́saman, dúlʉ́gá təd.» ");
INSERT INTO mcp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yésus mú nyiŋgə cɨ nə bwo nə́: «Ye bwə́ dʉ jida lámba nə́ bwə́ kə́ kúd dwo mpɨ́ɨ́d? Yé bwə́ dʉ kə tə̂l shí gwoŋʉ́? Ŋgaá jɨ́ yida bə nə́ í tɔ́wʉ́g cé lámba dɨ̂? ");
INSERT INTO mcp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kú nə sâ á *ndímba í bá bwên kú nyîn, ŋkí sâ á shwoó í bwên kú wɔ́ɔ́s mə́ŋkɛnyad. ");
INSERT INTO mcp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, a gwág!» ");
INSERT INTO mcp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A mú nyiŋgə cɨ nə bwo nə́: «Jigá kuú nə́ kalə́ nə sâ bɨ́ mə́ dʉ gwág yí! Nəcé yuug bɨ́ é dʉ yigʉla bɔ́ɔ́l búúd nə́ ndɨ́ yí, gwə́ nə́mə́ wə́ bwə́ bá dʉ yigʉla bɨ́ nə ndɨ́ yí, bwə́ wá mə́bə́dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Muud jɨ́ nə baalɛ́ fʉg yɛ́, Zɛmbî mə bá kwádʉlə nyə nywo. Njɨ nyɔɔŋg cúgɛ́ nə ndɨ́ yɛ́, Zɛmbî mə bá mɛɛl yîl nyə bʉ́baalɛ̂ á jɨ́ nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yésus mú nyiŋgə cɨ nə́: «Faan mə́ Zɛmbî dʉ́sə nda yuug ga. Ŋgwɔ́l múúd mə́ myɛɛg mpəg nyə́dɨ́ fambə́. ");
INSERT INTO mcp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nyə e jâ ibulú, wɔɔl mímwásə́. Mpəg jáá í é kâl nə́ ndɛɛ́, í ŋgə́ wɨ̂y gwə́mɛ́fwó, muud nyə́ ámə bɛ̧ yɛ́ kú mpu nda í ŋgə́ sɨ̂y nə́. ");
INSERT INTO mcp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Shí nyə́mɛ́fwó í sá nə́ mpəg kɔ̧́g íkáá, í wá mə́bəga, mpúmə́ lwánd mə́bəga dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nə́ ndɛɛ́, ja mpúmə́ mə́ tɨ̂ yí, bwə́ mú saag fambə́, nəcé fwála bwə́ jə́lá nə saag yí í mə́ wɔ́ɔ́s». ");
INSERT INTO mcp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yésus mú nyiŋgə cɨ nə́: «Shé bɨ́ nə ŋkul cɨ nə́ Faan mə́ Zɛmbî dʉ́sə nda jɨ́? Shé bɨ́ nə ŋkul yɨɨga dwo nə wáyɛ́ kaanə́? ");
INSERT INTO mcp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dʉ́sə nda búbumə́ *mutárʉd. Búbumə́ jɔɔŋg wə́ í búl cwáágʉwo nə bíl íbumə́ í mə́mpəg byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Njɨ ja bwə́ bɛ̧́ gwo yí, í dʉ gwaa cɔ̧́ mɔ́ɔ́lʉ́gá mə́mpəg mâ fambə́; í wá mílɔ̂w nə́ ŋkudə́, mbií á nə́ inunú bí nə ŋkul zə lwɔ̧́ maagɛ cínɔŋg nyə́dɨ́ gúgʉ́wád.» ");
INSERT INTO mcp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Míl zhwog mikaanə́ mbií nɨd wə́ nyə á dʉ lás nə buud yɛ́, nə́mə́ mbií bwə́ á bə nə ŋkul dʉ gwág yí. ");
INSERT INTO mcp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nyə a shígɛ́ dʉ bwɛlɛ lás nə bwo kú kənd kaanə́. Njɨ nyə á dʉ kə fɛ́ɛl isâ byɛ̂sh, ja bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ mə́ kə bə bwə́mɛ́fwó yí. ");
INSERT INTO mcp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jwɔ̂w ŋgwúd dɔɔŋgʉ́ mpwó-kugʉ́, Yésus mú cɨ nə *ompwíín bɛ́ nə́: «Shé lɨ́ɨ́nágá mâŋ, kə faŋwíny!» ");
INSERT INTO mcp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ompwíín bwə́ mú béégya nə áncuncuma buud, kə kwey Yésus byɔ́ɔ́lʉ́d. Bə́nɔ́ŋ bwə́ mú kə nə dwo. Mɔ́ɔ́lʉ́gá mɔ́ɔ́l mə́ á bə nə́mə́ mə́koogʉ́, mə́ ŋgə́ bɛ̧ bwo. ");
INSERT INTO mcp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bwə́ ŋgə́ kə, seegya nə́ məma ŋkwɔ̧̂ mú tɛ́ɛ́d kuŋgʉ́lə, ikwɔ̧́ í mə́júwó í mú ŋgə shwɨy byɔ́ɔ́lʉ́d, byɔ́ɔ́l mú tɛ́ɛ́d lwándʉ́lə nə məjúwó. ");
INSERT INTO mcp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Í á bə, Yésus mbwúg bán byɔ́ɔ́lʉ́d, a ŋgə́ jâ, lúú mbwúg fílo dɨ̂. Ompwíín bɛ́ bwə́ mú juumʉshi nyə. Bwə́ nə nɛ́ nə́: «Yɨ́ɨ́gʉli sə́ wál zə yə! Ye sâ jɔɔŋgʉ̂ í acɨ́yɛ́ wo tɔɔ sâ?» ");
INSERT INTO mcp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yésus mú wɔɔl, nyə ŋkáánd nə ŋkwɔ̧̂. Nyə nə mâŋ nə́: «Salʉwóg, jigʉ́ nə́ shɛɛ!» Njɨ nyə á shîn lás ntʉ́nɨ yí, ŋkwɔ̧̂ mú shwal shîn, mâŋ bə nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ntɔ́ Yésus mú ka cɨ nə ompwíín bɛ́ nə́: «Wáyɛ́ mbií ífwaas nɨ? Ye bɨ cúgɛ́ nə búgə́ nə Zɛmbî?» ");
INSERT INTO mcp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iŋkuŋkúúnd í mú jág bii bwo, kə jé bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «Nyáyɛ́ múúd ɛ́ga nyɛ! Tɔɔ ŋkwɔ̧̂, tɔɔ mâŋ í bə́lɛ́ sá nyə məgwág ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ntɔ́ bwə́ mú kə wɔ́ɔ́s cíndú faŋwíny shí á Ogerazeniyɛ̧̂. ");
INSERT INTO mcp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yésus mú shulə byɔ́ɔ́lʉ́d. A ká nə́mə́ shîn tə̂l məkuú shí, ŋgwɔ́lʉ́gá múúd mú wú mə́shwoŋ dɨ́, bɔ́w-bɔ̂w *shíshim ŋgə́ lwáfʉlə nyə, zə bwəma nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Muud wɔɔŋgʉ́ nyə á dʉ ji baŋ mə́shwoŋ. Tɔɔ muud ŋgwúd nyə a shígɛ́ ná bə nə ŋkul mə wálʉ́lə nyə, tɛɛm bə nə mimbwagə́ mí íŋkwánz. ");
INSERT INTO mcp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ija ŋkí bulya bwə́ á dʉ tɛɛm wɔ́ɔlə nyə məbwə̂ nə mikwoolú mí íŋkwánz, bwə́ wá nyə mimbwagə́ məkuúd, njɨ nyə á dʉ tɨ̂ isâ ínɨ byɛ̂sh. Tɔɔ muud ŋgwúd nyə a shígɛ́ bə nə ŋkul mə káágʉ́lə́ nyə. ");
INSERT INTO mcp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bulú nə mwásə́ nyə á dʉ bul bə njɨ baŋ mə́shwoŋ nə mímbʉ́ŋʉ́d, kə́ dʉ kɨ̂m, a ŋgə́ bɛ́wʉli nyúúl nyɛ́ nə məkwóógʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ntɔ́ nda nyə á dʉ́g Yésus ná shwóg-shwóg nə́, nyə á ju kʉ́lə́, kə kúd Yésus məbwóŋ shí, jəgʉla nə nyə, ");
INSERT INTO mcp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a ŋgə́ kɨ̂m nə́: «Yésus, *Mwân mə́ Zɛmbî á gwɔ́w-gwɔ̂w, shwə̂ bâŋ nə inɛy? Mə́ jəgʉla nə wo jínə́ mə́ Zɛmbî dɨ́ nə́, wo kú tə̂l mə cwúndʉd.» ");
INSERT INTO mcp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nyə á jəgʉla nə Yésus ntʉ́nɨ nəcé Yésus nyə á ŋgə cɨ nə nyə nə́: «bɔ́w-bɔ̂w shíshim, wúg nyə nyúúlʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yésus mú jí nyə nə́: «Jínə́ dwô wə́ zə́?» Nyə nə́: «Jínə́ dâm wə́ “Kínda”, nəcé sə́ bɨ́ ŋkí bulya.» ");
INSERT INTO mcp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bwə́ mú tɛ́ɛ́g Yésus məbwə̂ nə́ a kú yîl bwo lɔɔm dɨ́ kənd kʉ̂l shús. ");
INSERT INTO mcp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, məma sɔɔnz óŋkuú, í á ŋgə də mbʉ́mbʉ́ŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Məjamb mə́ mú tɛ́ɛ́g Yésus məbwə̂ nə́ a nyíŋgálʉ́g mwo óŋkuú bɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A mú magʉlə nə́ í sɨ́yʉ́g ntɔ́. Bɔ́w-bɔ̂w míshíshim myɔɔŋgʉ́, mí mú zə wú múúd wɔɔŋgʉ̂ nyúúlʉ́d, kə nyíi óŋkuúd. Sɔɔnz óŋkuú nɨ, je bə ótɔ́ɔ́shin óbá, jɛ̂sh mú shwal bumb nə mikʉ́lə́, wú mbʉ́mbʉ́ŋʉ́d, kə juwa máŋʉ́d. Bwə́ mú ŋgul mə́júwó nə́ ndɛɛ́ fudə. ");
INSERT INTO mcp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Buud bwə́ á ŋgə baagʉlə oŋkuú wá, bwə́ mú wɛɛnzh kə ŋgə jaaw buud ŋgwə́la nə mílɔɔm milɔɔm. Buud bwə́ mú zə, zə dʉ́g sâ í ámə sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bwə́ mú zə wɔ́ɔ́s kʉ́l Yésus nyə á bə yí. Bwə́ dʉ́g múúd məjamb mə́ á dʉ lwáfʉlə yɛ́, a njúl cínɔŋg shí nə jɔ̧jɔ̧ míkáándə́, a njúl nə́mə́ nə́ shɛɛ. Bwə́ mú bul gwág ífwaas. ");
INSERT INTO mcp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Buud bwə́ á dʉ́g sɔ́ɔ́lʉ́gʉ́ í á sɨ̂y wá bwə́ mú jaaw bwo sâ í ámə bə nə muud wɔɔŋgʉ̂ nə oŋkuú yí. ");
INSERT INTO mcp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ntɔ́ bwə́ mú tɛ́ɛ́g Yésus məbwə̂ nə́ a wúg bwə́dɨ́ lɔɔmʉd. ");
INSERT INTO mcp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ja Yésus mə́ kə bád byɔ́ɔ́l dɨ́ yí, muud nyə á bə nə məjamb yɛ́, mú tɛ́ɛ́g nyə məbwə̂ nə́ a ŋwág nyə nyə́dɨ́ gwooŋgʉd. ");
INSERT INTO mcp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Njɨ Yésus nyə a shígɛ́ magʉlə. A mú yida cɨ nə nyə nə́: «Kag wódɨ́ kwáádə́ kə jaaw búúd bwô sâ jɛ̂sh Cwámba mə́ sá wo yí, nda á mə́ gwág wo ŋkúŋkwóŋʉ́lə nə́.» ");
INSERT INTO mcp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Muud ɛ́nɛ músə kyey, kə ŋgə jaaw buud wâ Dekapwôl sâ jɛ̂sh Yésus nyə á sá nyə yí. Bɔɔŋg bɛ̂sh bwə́ á gwág wá bwə́ mú bul káam. ");
INSERT INTO mcp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ja Yésus mə́ sɔw kə faŋwíny byɔ́ɔ́l dɨ́ yí, buud bwə́ mú zə lyɛ̧ nyə áncuncuma, a njúl ná bwúŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ŋgwɔ́l njwû á *mpáánzə́ minjɨ́ɨ́gʉ́lá, nə jínə́ nə́ Zharus mú wɔ́ɔ́s. Njɨ nyə á dʉ́g Yésus yí, nyə á zə kúd mə́bwóŋ shí, ");
INSERT INTO mcp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tɛ́ɛ́g nyə məbwə̂. Nyə nə́: «Sʉ́sás jâm í ŋgə júgʉla. Mə́ jəgʉla nə wo nə́ wo zə́g kə kɛɛl nyə məbwə̂, a bə́g mpwogɛ́, a cʉ́gəg.» ");
INSERT INTO mcp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bá Yésus bwə́ mú kə, buud bwə́ ŋgə́ bɛ̧ bwo áncuncuma, bwə́ ŋgə́ shúsə Yésus ikɔ́ɔ́mb byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ŋgwɔ́l múdá nyə á bə cínɔŋg, məcií mə́ á dʉ wú nyə nyúúlʉ́d tɛ́ mímbú wûm nə mímbá. ");
INSERT INTO mcp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nyə á bul dʉ́g cúŋ ncúlyá ojwɔ́wʉda dɨ́ sɔ̧́lə nə́ a yâl, a shîn kɛɛnzh *mwaanɛ̂ yé yɛ̂sh. Njɨ, a kú yâl, bwas ŋgə́ yida yáág yáágʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nda nyə á gwág lâŋ mə́ Yésus nə́, nyə á kə Yésus mpʉ́sə kwoŋ na áncuncuma buud dɨ́, kə kúnya nə nyə káándə́, ");
INSERT INTO mcp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","a ŋgə́ tə́dʉga nə́: «Ŋkí mə kúnyá nə njɨ káándə́ mə́ Yésus, mə yâl.» ");
INSERT INTO mcp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Njɨ nyə á kúnya nə nyə káándə́ yí, məcií tɔ̂w ntâg nyə cé nə cé, nyə mú gwádʉga nyúúl nyɛ́d nə́ a mə́ yâl. ");
INSERT INTO mcp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yésus mú gwádʉga nə́ nyúl mpífə́ mə́ wú nyə nyúúlʉ́d. A mú yág mpʉ́sə búúd dɨ́, jí nə́: «Zə́ mə́ kúnya mə nə káándə́ ɛ́nɛ?» ");
INSERT INTO mcp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","*Ompwíín bɛ́ bwə́ mú bɛ̧sa nə nyə nə́: «Wo ŋgə́ dʉ́g buud ɔ́ ŋgə́ shúsə wo íkɔ́ɔ́mb byɛ̂sh, wo nyiŋgə jí nə́: “Zə́ mə́ kúnya nə mə káándə́ ɛ́nɛ?”» ");
INSERT INTO mcp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Njɨ Yésus mú ŋgə kənd mísh mə́koogʉ́ məkoogʉ́ nə́ a dʉ́g múúd nyə́ ámə sá sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mudá ɛ́nɛ nyə á ŋgə lilya nə ifwaas, nəcé nyə á mpu sâ í ámə sɨ̂y nə nyə yí. A mú zə wusə nyúúl shí Yésus dɨ́ mpwóómbʉ́d, jaaw nyə bʉ́bə́lɛ́ yɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ntɔ́ Yésus mú cɨ nə nyə nə́: «Shilə wâm, wo mə́ *dʉ́g cʉg nəcé búgə́ gwô. Kaág nə́ shɛɛ. Bwas í shínʉ́g wo!» ");
INSERT INTO mcp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yésus ŋgə́ ná lás ntʉ́nɨ, buud bwə́ mú wɔ́ɔ́s wúlə wə́ njwû á mpáánzə́ minjɨ́ɨ́gʉ́lá zə cɨ nə nyə nə́: «Shilə wô mə́ yə. Wó ka kwo ŋgə ntágʉlə Yɨ́ɨ́gʉli nə jɨ?» ");
INSERT INTO mcp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Njɨ, Yésus kú bísh sâ bwə́ á ŋgə cɨ yí, a mú cɨ nə Zharus nə́: «Kú bɛɛg fúndə, bə́g njɨ nə búgə́.» ");
INSERT INTO mcp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A mú cɨ nə́ tɔɔ muud kú bɛ̧ nyə, a kə́ nə njɨ Pyɛ̂r nə Zhâk bá mínyɔŋʉ̂ yé Yuánɛs. ");
INSERT INTO mcp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ja bwə́ mə́ jé njwû á mpáánzə́ minjɨ́ɨ́gʉ́lá dɨ́ njɔ́w yí, Yésus mú dʉ́g buud bwə́ ŋgə́ sá saagʉwo mímbií mímbii, bwə́ ŋgə́ jɨɨ, bwə́ ŋgə́ kɨ̂m. ");
INSERT INTO mcp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A mú nyíi njɔ́w, nyə nə bwo nə́: «Bɨ́ ŋgə jɨɨ nə ŋgə sá bímbí lʉ́ saagʉwo nɨ nəcé jɨ? Mwân nyə afwóyɛ́ yə, a ŋgə yida jâ.» ");
INSERT INTO mcp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bwə́ mú yida ŋgə cágʉlə nyə. Nə́ ndɛɛ́ a mú wééshʉli bɛ̂sh tɔ́ɔ́n, lʉ́gə njɨ sɔ́ɔ́ŋgʉ́ nə nyɔɔŋgʉ́ mə mwân, nə buud ɔ́ gwooŋg jé. Bwə́ mú nyíi fúm, kʉ́l mwân nyə á bə yí. ");
INSERT INTO mcp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A mú bii mwân wɔɔŋgʉ̂ mbwə̂. Nyə nə nɛ́ nə́: «Talita, kûm!» Ntɔ́ mə́ kə́ nə́ «Mwámuda! Mə́ cɨ nə wo nə́: wɔɔlʉ́g!» ");
INSERT INTO mcp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cé nə cé, shilə wɔɔŋg mú wɔɔl, tɛ́ɛ́d kyeyʉ́lə, nəcé nyə á bə nə mimbû wûm nə mímbá. Ja bwə́ mə́ dʉ́g ntʉ́nɨ yí, bwə́ mú ŋgə káám mbií á nə́ fʉg jímb lúúd. ");
INSERT INTO mcp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ntɔ́ Yésus mú bul báásʉlə bwo nə́ bwə́ kú bwiiŋg múúd sâ í mə́ sɨ̂y yí. A mú cɨ nə́ bwə́ yə́g nyə sâ mə́ də̂. ");
INSERT INTO mcp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yésus mú ka wú na, bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ mú kə nyə́dɨ́ kwáádə́. ");
INSERT INTO mcp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ja jwɔ̂w lʉ́ Sábaad í á wɔ́ɔ́s yí, nyə á kə *mpáánzə́ mínjɨ́ɨ́gʉ́lá, kə ŋgə yə buud minjɨ́ɨ́gʉ́lá. Ncúlyá buud bwə́ á ŋgə gwágʉlə nyə wá bwə́ mú ŋgə bul káam, bwə́ ŋgə́ jî nə́: «Bíga ísâ í á wú nyə ŋgow? Dʉ́ga váál fʉ́g wə́ jɨ? A ŋgə mpu sá dʉ́ga váál *mə́shimbá wa ntʉdɛlɛ̂? ");
INSERT INTO mcp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kábíndá á mwân mə́ Maríya dɨ́ ɛ́ga? Mínyɔŋʉ̂ mə́ Zhâk, bə́nɔ̂ŋ Yózɛs, nə Yûdə nə Shímun dɨ́ ɛ́ga? Ŋgaá okɔ́ɔ́l bɛ́ bʉ́sə wa sə́dɨ́!» A mú bə bwo kwal-bɔɔgʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yésus mú zə cɨ nə bwo nə́: «*Muud micúndə́ mə́ dʉ nə́mə́ bwəma nə mpyóŋ njɨ nyə́dɨ́ kwáádə́, nə nyə́dɨ́ mə́wɔ́ŋgɔ́d, nə nyə́dɨ́ njɔ́w búúdʉd.» ");
INSERT INTO mcp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nyə a shígɛ́ bə nə ŋkul sá tɔɔ *shimbá cínɔŋg nyə́dɨ́ kwáádə́, njɨ baalɛ́ mímbə̂l nyə́ a kɛɛl məbwə̂, cʉg myá. ");
INSERT INTO mcp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A mú bul káam nda búúd bwə́ á bə kú *búgʉla nyə nə́. Nə́ ndɛɛ́ a mú cɔ̧́, ŋgə kə mə́kwáádə́ mɛ̂sh mâ faan dɔɔŋgʉ́d kə ŋgə yə buud minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ja ísâ ínɨ í mə́ cɔ̧́ yí, Yésus mú jɔ̂w *ómpwíín wûm nə óbá bɛ́, a mú zə ŋgə lwâm bwo óbá óbá. A shîn yə bwo ŋkul á dʉ́lə yîl búúd bɔ́w-bɔ̂w míshíshim. ");
INSERT INTO mcp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A báásʉlə bwo nə́: «Ja bɨ́ mə́ kə́ yí, bɨ kú ŋwa íbadʉga í njɔɔnd, ka njɨ wagatîg. Bɨ kú ŋwa bʉlɛ́d, tɔɔ baamʉtálá. Bɨ kú kə nə *mwaanɛ̂. ");
INSERT INTO mcp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bɨ́ bwáád osílʉ́faas! Njɨ bɨ kú bwáád íshimí íbá.» ");
INSERT INTO mcp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A mú nyiŋgə cɨ nə bwo nə́: «Ja bɨ́ mə́ jé wúl ŋgwə́la dɨ́ yí, bɨ ɔ́ ji njɔ́w bɨ́ ámə nyíi yííd, kə jé jwɔ̂w bɨ́ mə́ bá lɔ̧ yí. ");
INSERT INTO mcp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Búúd bwə́ ká bá bə kú lə́g bɨ́ gúl kʉ́lʉ́d, bwə́ kú cɛɛl gwág sâ bɨ́ mə́ jááw bwo yí, bɨ́ ɔ bá wú cínɔŋgʉ́, bɨ́ kudə fumbyá í ámə nada bɨ́ mə́kuú dɨ́ yí. Sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂ í lwágʉlə bwo nə́ bwə́ mə́ byaagʉlə.» ");
INSERT INTO mcp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nə́ ndɛɛ́ ompwíín bɛ́ bwə́ mú zə kə, kə ŋgə cúndə nə́ buud bwə́ cɛ́ndʉ́g mítə́dʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bwə́ mú nə́mə́ yîl buud zhwog mə́jamb mə́ á ŋgə ntágʉlə bwo má. Bwə́ gwáágʉlə zhwog mímbə̂l məwúdə, ŋgə lwag myo. ");
INSERT INTO mcp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Njwú-buud Herod mú gwág jínə́ mə́ Yésus ŋgə́ jag bul jwɔ̧, bɔ́ɔ́lʉ́gá búúd bwə́ á ŋgə cɨ nə́: «Yuánɛs Nduu-buud mə́ gwûm, sâ jɔɔŋg wə́ á músə́ nə mpífə́ á ŋgə́ sá *məshimbá ntʉ́nɨ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bɔ́ɔ́lʉ́gá nə́: «Jísə Eli.» Bɔ́ɔ́lʉ́gá nə́: «Jísə Zɛmbî ŋgwɔ́l *múúd micúndə́ yé, nda bɔɔŋg ɔ́ ayág.» ");
INSERT INTO mcp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ja Herod nyə á gwág ntɔ́ yí, nyə nə́: «Yuánɛs Nduu-buud mə́ á cígə cʉ́ŋ wə́ ɛ́nɛ! A mə́ gwûm shwóŋʉd!» ");
INSERT INTO mcp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nəcé Herod nyəmɛ́fwó nyə a ŋwa Herodyâd, mudá mə́ mínyɔŋʉ̂ yé Fílíp, bâ. Lə́sʉ́ wɔɔŋg wə́ í á sá nə́ Herod lwámʉ́g buud kə bii Yuánɛs, wɔ́ɔlə nyə məŋkəda, kə wá nyə mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nəcé Yuánɛs Nduu-buud nyə á jum Herod nə́: «Wo ajə́láyɛ́ nə ŋwa mudá mə́ mínyɔŋʉ̂ woó nə́ wo bâ!» ");
INSERT INTO mcp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodyâd nyə á ka dʉ fʉm Yuánɛs, a mú dʉ sɔ̧́ mə́zhɨɨ́ nə́ a gwú nyə. Njɨ, yuug jé í á shígɛ́ bánda ");
INSERT INTO mcp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nəcé Herod nyə á dʉ mpu nə́ Yuánɛs jɨ tʉ́təlí muud mísh mə́ Zɛmbî dɨ̂, a njúl muud Zɛmbî, nyə á ka dʉ gwɔ̧́ɔ̧ nyə. Sâ jɔɔŋg wə́ nyə á dʉ kɛɛm nyə yí. Nə́ ndɛɛ́, tɛɛm bə nə́ iciyá í Yuánɛs í á dʉ shul nyə lámʉ́d, nyə á yida nə́mə́ dʉ gwágʉlə nyə nə məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nə́ ndɛɛ́, Herodyâd nyə á zə dʉ́g zhɨ́ɨ́ mə́ gwú Yuánɛs jwɔ̂w Herod nyə a tə̂l zaŋ byélé dɛ́ yí. Herod nyə a jɔ̂w milúlúú myâ lɔɔm nə myâ izɨmbɨ, a jɔ̂w nə́mə́ otɔ́we ɔ́ shwóg wâ Galilê. ");
INSERT INTO mcp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Í á ka bə, Herod bə́nɔ̂ŋ buud bɔɔŋgʉ́ bwə́ njúl shí, shilə mə́ Herodyâd mú nyíi cínɔŋg, tɛ́ɛ́d sáágʉ́lə cwánʉ́d. Kuú zâŋ yé mú zə bul nywa Herod bə́nɔ̂ŋ buud ɔ́nɨ míshʉ́d. Kə jé Njwú-buud nyə á cɨ nə nyə nə́: «Jaawʉ́g mə sâ jɛ̂sh wó cɛ́ɛ́l yí, mə é fáágʉlə wo gwo.» ");
INSERT INTO mcp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A mú kaag nyə fwámɛ́ kaag nə́: «Tɛɛm bə nə wó jɨɨ məma mpál á faan dâm, mə é fáágʉlə wo gwo.» ");
INSERT INTO mcp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Shilə nɨ kú fwo bɛ̧sa, a mú wɔ́ɔ́s tɔ́ɔ́n, kə jí nyɔ́ɔ́ŋgʉ̂ nə́: «Mə gwáámbʉ́g jɨ́?» Nyɔɔŋgʉ́ mú bɛ̧sa nə nyə nə́: «Gwáámbʉ́g lúu mə́ Yuánɛs Nduu-buud!» ");
INSERT INTO mcp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A mú lɛɛl ntâg jéél nyiŋgə kə jé wə́ Herod, kə cɨ nə nyə nə́: «Mə́ jɨɨ nə́ wo yə́g mə lúú mə́ Yuánɛs Nduu-buud yáásə́d wa kɨ́kɨdɨ́ga.» ");
INSERT INTO mcp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ŋgwóómbʉ́lú nɨ mú shul Njwú-buud lámʉ́d. Njɨ nda nyə á bwey kɛɛn ŋkaanə́ mísh mə́ ójóŋ dɨ́ nə́, nyə a shígɛ́ nywá nyiŋgə ban nə́ nyə ayə́yɛ́ nyə sâ nyə́ ámə gwáámb yí. ");
INSERT INTO mcp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nə́mə́ cé nə cé, a mú kənd ŋgwɔ́lʉ́gá zɨmbɨ nə́: «Zaá mə nə lúú mə́ Yuánɛs Nduu-buud!» Muud wɔɔŋgʉ̂ mú kə cígə Yuánɛs cʉ́ŋ. ");
INSERT INTO mcp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A mú zə nə lúú yáásə́d, zə yə shilə nɨ. Shilə nɨ mú kə nə wo, kə cwámbʉlə nyɔ́ɔ́ŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nə́ ndɛɛ́ *ompwíín ɔ́ Yuánɛs bwə́ mú gwág sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂. Bwə́ mú kə ŋkɛ̂ny kug nyúul mə́ Yuánɛs kə wá shwóŋʉd. ");
INSERT INTO mcp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ja *búúd ɔ́ lwámá ɔ́ Yésus bwə́ á nyiŋgə yí, bwə́ á zə bwiiŋg Yésus sâ jɛ̂sh bwə́ á kə ŋgə sá yí, nə sâ bwə́ á ŋgə jɨ́ɨ́gʉli buud yí. ");
INSERT INTO mcp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yésus mú cɨ nə bwo nə́: «Zəgá, shé kə́g kʉ́l búúd bwə́ cúgɛ́ yí ŋwá ná kə woga.» Nyə á cɨ ntɔ́ nəcé buud bwə́ á bə cínɔŋg ŋkí bulya, bɔ́ɔ́l ɔ́ ŋgə́ kə, bɔ́ɔ́l ɔ́ ŋgə́ nyiŋgə, mbií á nə́ bə́nɔ̂ŋ ompwíín bɛ́ bwə́ á shígɛ́ bə nə fwála nə́ bwə́ də́g. ");
INSERT INTO mcp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bwə́ á ka kəwa byɔ́ɔ́lʉ́d, kyey nə́ bwə́ kə́ ji bwə́mɛ́fwó bugád kʉ́l búúd bwə́ cúgɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Njɨ buud ŋkí bulya bwə́ á dʉ́g bwə́ ŋgə́ kə byɔ́ɔ́lʉ́d, bwə́ mú yag bwo. Buud bwə́ á ka ŋgə wu míŋgwə́la myɛ̂sh dɨ́, ŋgə kə nə mikʉ́lə́, kə́ sámb Yésus bə́nɔ̂ŋ ompwíín bɛ́ shwóg kə tɛ́ɛ́d jê. ");
INSERT INTO mcp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ja bwə́ mə́ shulə byɔ́ɔ́l dɨ́ yí, a mú dʉ́g mə́ŋkúmbə mə búúd mə́nɨ, a mú gwág bwo cɛy lámʉ́d nəcé bwə́ á bə nda sɔɔnz íncwəmbɛ í cúgɛ́ nə mbaagʉlə yí. Ntɔ́ a mú ŋgə jɨ́ɨ́gʉli bwo isâ ŋkí bulya. ");
INSERT INTO mcp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nda kugʉ́ í á ka jé nə́, ompwíín bwə́ mú kə cɨ nə nyə nə́: «Sə́ bʉ́sə wa bugád, kugʉ́ nə́mə́ ɔ́ga. ");
INSERT INTO mcp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bɨ́dʉ́g búúd ɔ́ga, bwə́ kə́g íbaafə́ nə mə́kwáádə́ mə́sə́ wa kúnə́-kúnə má, kə kusə sâ mə́ də̂.» ");
INSERT INTO mcp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yésus mú cɨ nə bwo nə́: «Bɨmɛ́fwó yə́gá bwo sâ mə́ də̂.» Bwə́ mú jí nyə nə́: «Sə́ é sá ntʉdɛlɛ̂ nə́ sə́ kúsəg ibʉlɛ́d kwaga nə buud ɔ́ga? Í jɨɨ́ ódanarî mitəd mímbá!» ");
INSERT INTO mcp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A mú jí bwo nə́: «Bɨ bʉ́sə nə ibʉlɛ́d ínɛ́y? Kəgá dʉ́g!» Bwə́ mú kə lɔ̧̂. Bwə́ mú zə jaaw nyə nə́: «Sə́ bʉ́sə nə ibʉlɛ́d itɔ́ɔn, nə oshú óbá.» ");
INSERT INTO mcp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yésus mú cɨ nə bwo nə́ bwə́ jílʉg buud shí ikínda ikínda ákánda dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bwə́ mú zə ji shí ikínda ikínda, bíl íkínda nə buud təd, bíl nə buud məwûm mə́tɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ja búúd bwə́ mə́ shîn ji shí yí, Yésus mú ka ŋwa íbʉlɛ́d itɔ́ɔn nə oshú óbá ɔ́nɨ, a bʉ̂n mísh gwɔ̂w, yə Zɛmbî akíba. A mú fɛ̂y íbʉlɛ́d, yə ómpwíín bɛ́. Bwə́ mú kaaw búúd. A mú nə́mə́ kaaw oshû mbií ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Buud bɛ̂sh bwə́ mú də, jílə, idʉ̂w lʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ompwíín bwə́ mú sɛɛŋg íkʉ́l í bʉlɛ́d nə ikʉ́l í óshû í á lʉ́g yí, byɛ̂sh í á lwánd mə́bwumú wûm nə mə́bá. ");
INSERT INTO mcp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Buud bwə́ á də ibʉlɛ́d byɔɔŋg wá, bwə́ á bə budûm otɔ́ɔ́shin otɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nə́mə́ njɨ í á shîn yí, Yésus nə *ompwíín bɛ́ nə́ bwə́ kə́wag byɔ́ɔ́lʉ́d, bwə́ lɨ́ɨ́nág kə nyə shwóg Bɛtʉsayída, mâŋ faŋwíny tɛ́ nyə é ŋgə fwo bɨ́d zhwog buud bwə́ á bə ɔ́nɨ yí. ");
INSERT INTO mcp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yésus mú shîn bɨ́d búúd, a músə bád mbʉ́ŋʉ́d nə́ a kə́ jəgʉla nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bulú mú zə yínd, kwey nə́ byɔ́ɔ́l mú tâm mâŋ, nyɛ mə́ lʉ́g cíndú nyəmɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nyə á ka dʉ́g nə́ júgə í ŋgə bə ompwíín cúŋ nə cúŋ, nəcé ŋkwɔ̧́ nyə á ŋgə yida wú kɔ́ɔ́mb bwə́ á ŋgə kə yí. Ŋgɛɛ míŋgwûm mí kúwo mí ashúshwóógʉ́ dɨ, a músə zə bɛ̧ bwo, a ŋgə́ kyey nə məkuú mə́júwó dɨ́ gwɔ̂w. Nyə á ka sá nda a cɔ̧́ bwo. ");
INSERT INTO mcp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ja bâŋ bwə́ mə́ dʉ́g a ŋgə́ kyey nə məkuú mə́júwó dɨ́ gwɔ̂w yí, bwə́ mə́ tə́dʉga nə́ jísə *jîm, bwə́ mú bwú óŋkwiimbyê. ");
INSERT INTO mcp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nəcé bɛ̂sh bwə́ a dʉ́g nyə, iŋkuŋkúúnd í mú bii bɛ̂sh. Yésus mú lɛɛl cɨ nə bwo nə́: «Səlʉgá milâm shí. Mə wə́ ɛ́nɛ, kúgá fúndə!» ");
INSERT INTO mcp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A mú kə kəwa byɔ́ɔ́lʉ́d, kwey bwo, ŋkwɔ̧́ mú ntâg shîn. Bwə́ mú káam mbií á nə́ fʉg dʉ jímb lúúd. ");
INSERT INTO mcp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bwə́ á bul káam nəcé bwə́ á shígɛ́ fwo mpu gwág mbií múúd mə Yésus. Sâ jɔɔŋgʉ̂ ɔ í á sá nə́ bwə́ kú wámbʉlə sâ nyə á cɛɛl jɨ́ɨ́gʉli bwo ja nyə á sá nə́ ibʉlɛ́d í búlyag yí. Bwə́ á bə ná ŋkí jilə milúu. ");
INSERT INTO mcp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bwə́ mə́ shîn lɨ́ɨ́na mâŋ, bwə́ mú jé lɔɔm á Genezarɛ̂t, bwə́ mú səl byɔ́ɔl. ");
INSERT INTO mcp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nə́mə́ shulə́lə bwə́ á shulə byɔ́ɔ́lʉ́d yí, buud bwə́ mú yag Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bwə́ mú kə nə mikʉ́lə́ kə ŋgə báŋgʉla shí nyɔɔŋg nyɛ̂sh dɨ̂. Bwə́ mú ŋgə́ ŋkɛ̂ny mimbə̂l ítaŋʉ́d, ŋgə kə nə myo kʉ́l jɛ̂sh bwə́ á ŋgə gwág nə́ Yésus jisə yí. ");
INSERT INTO mcp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yésus mú ŋgə kyey mə́kwáádə́ nə míŋgwə́la, tɔɔ íbaafə́. Buud bwə́ mú ŋgə kə bwɨ́ɨ́g mimbə̂l myáŋ mímbaadə́d, íkʉ́l nyə é ŋgə cɔ̧́ yí. Bwə́ mú ŋgə tɛ́ɛ́g nyə məbwə̂ nə́ a bɨ́dʉ́g nə́ bwə́ jísɔ́wʉ́g ŋgə kúnya njɨ nə *mbwaag káándə́ yé. Bɔɔŋg bwə́ á ŋgə kúnya nə nyə wá bwə́ mú ŋgə yâl. ");
INSERT INTO mcp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Ofarizyɛ̂ŋ nə bɔ́ɔ́lʉ́gá *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á wú Yurʉ́səlɛm, kə wə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bwə́ mú zə dʉ́g nə́ bɔ́ɔ́lʉ́gá *ómpwíín bɛ́ bwə́ á dʉ də idʉ̂w məbwə̂ nə məbwam. Ntɔ́ jɨ nə́ bwə́ á shígɛ́ dʉ gusa mwo mbii mə́cum mə́ *Oyúdɛn mə́ ŋgə́ jɨ́ɨ́gʉ́lí yí. ");
INSERT INTO mcp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Í njúl nə́ Ofarizyɛ̂ŋ nə́mə́ nda Oyúdɛn bɛ̂sh bwə́ á shígɛ́ dʉ də, bwə́ kú fwo mpu gusa məbwə̂, nəcé bwə́ á dʉ yáág nə məcum ímpáámbə́ í á lʉ́gə má. ");
INSERT INTO mcp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ja bwə́ nyíŋgə́ míkus dɨ́ yí, bwə́ cúgɛ́ nə ŋkul də kú fwo gusa. Bwə́ á dʉ nə́mə́ baagʉlə bílʉ́gá íjâm nə ijag nda dʉ́lə gusa íbálá nə mikáágə́ nə iwɔ́ŋgɔ́. ");
INSERT INTO mcp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ja Ofarizyɛ̂ŋ nə Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á dʉ́g ntʉ́nɨ yí, bwə́ mú cɨ nə Yésus nə́: «Ompwíín bwó bâŋ bwə́ aŋgɛ̂ nə baagʉlə məcum mə́ ímpáámbə́, bwə́ ŋgə də kú gusa mə́bwə̂. Jɨ́ í sá ntɔ́?» ");
INSERT INTO mcp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yésus mú bɛ̧sa bwo nə́: «Izayí nyə á bə nə ŋkaam ja nyə á cúndə shú dʉ́n, bɨ́ buud ɔ mə́kə́ŋ mbii wúsə́ cilyá yí, nə́: Kúl búúd ga í ŋgə gúmal mə njɨ mímpu dɨ́, milâm myáŋ mí njúl shwóg-shwóg nə mə. ");
INSERT INTO mcp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wáŋ ŋgə́lə ságʉsə bwə́ ŋgə́ ságʉsə mə yí wúsə ntɔ́ ŋgwas. Bwə́ ŋgə yida jɨ́ɨ́gʉli buud minjɨ́ɨ́gʉ́lá myâ məmpə́ndí mə́ búúd.» ");
INSERT INTO mcp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yésus mú kwádʉlə nə́: «Bɨ́ mə́ myaas mə́cɛ̧ɛ̧ mə́ Zɛmbî, yida nywɨ́ɨ́lya nə mə́cum mʉ́n.» ");
INSERT INTO mcp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A kwo nə́mə́ cɨ nə́: «Bɨ mə mpú dʉ ntɔ̧ mpə́ndí mə́ Zɛmbî nə́ bɨ mə́ yida baagʉlə məcum mʉ́n. ");
INSERT INTO mcp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moyîz nyə á cɨ nə́: “Gúmálʉ́g sɔ́ɔ́ŋgʉ́ wô nə nyɔɔŋgʉ́ wô.” A nyiŋgə́ nə́mə́ cɨ nə́: “Múúd mə ká lweem sɔ́ɔ́ŋgʉ́ yé ŋkí nyɔɔŋgʉ́ yé, bwə́ jəlá nə gwú múúd wɔɔŋgʉ̂.” ");
INSERT INTO mcp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","«Njɨ bɨ bâŋ bɨ́ ŋgə cɨ nə́: “Múúd mə ká jaaw sɔ́ɔ́ŋgʉ́ ŋkí nyɔɔŋgʉ́ nə́: ‘Sâ mə ámə nywá kwíínd wo nə ndɨ́ yí í músə korban (ntɔ́ mə́ kə́ nə́ ŋkɔw nyɔɔŋg í músə məyə́na shú mə́ Zɛmbî),’” ");
INSERT INTO mcp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bɨ kú cíndal múúd wɔɔŋg nə́ a sáág sâ shú mə́ sɔ́ɔ́ŋgʉ́ ŋkí nyɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ŋgaá ntɔ́ jɨ nə́ bɨ́ ŋgə sá nə́ Milə́sʉ́ mí Zɛmbî mí bə́g ŋkʉ́ŋgʉ́g, məcum mʉ́n yidá mpu yáág? Bɨ ŋgə́ nə́mə́ nyiŋgə sá bíl zhwog isâ í abʉ́bɔ̂w!» ");
INSERT INTO mcp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yésus músə ka kwo yid, lésha nə buud bwə́ á bə cínɔŋgʉ́ áncuncuma wá, nyə nə bwo nə́: «Bɨ bɛ̂sh bɛ́nyʉ́gá məlwə̂, mpu gwágʉlə. ");
INSERT INTO mcp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sâ í dʉ́ wú tɔ́ɔ́n, nyíi múúd nyúúlʉ́d yí, gwə́ dɨ́ í dʉ́ wá múúd məlwaagʉwo mísh mə́ Zɛmbî dɨ̂; njɨ byɔɔŋg í wú nyə́dɨ́ lámʉ́d yí, byó wə́ í dʉ́ wá nyə məlwaagʉwo. ");
INSERT INTO mcp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, nyə mpu gwág.» ");
INSERT INTO mcp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yésus mú lʉ́gə áncuncuma buud. Bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ mú nyiŋgə kə njɔ́w. Cínɔŋg bwə́ mú zə jí nyə nə́ a fɛ́ɛ́lʉ́g bwo kaanə́ wɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A mú ka cɨ nə bwo nə́: «Ye bɨ bʉ́sə nə́mə́ kú mpu gwág ísâ? Ye bɨ agwágɛ́ nə́ sâ jɛ̂sh í wú tɔ́ɔ́n nyíi múúd nyúúlʉ́d yí, í cúgɛ́ nə ŋkul wá nyə məlwaagʉwo mísh mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nəcé í ányííyɛ́ nyə lámʉ́d. Í yida kə nyə mwɔ̧̂ dɨ́ nə́ ndɛɛ́ í mú wɔ́ɔ́s kə bɨ́ɨ́d.» (Ntɔ́ mə́ cɛɛl cɨ nə́ idʉ̂w í cúgɛ́ nə məlwaagʉwo mísh mə́ Zɛmbî dɨ̂.) ");
INSERT INTO mcp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nyə mú nyiŋgə cɨ nə́: «Sâ í wɔ́ɔ́s wú múúd dɨ́ yí, gwə́ wə́ í wá nyə məlwaagʉwo mísh mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nəcé lâm mə́ múúd dɨ́ wə́ bɔ́w-bɔ̂w mítə́dʉ́gá mí dʉ zhu yɛ́, nə jaŋga, nə júwo, nə məgwú mə búúd, ");
INSERT INTO mcp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nə minɔɔmb, nə yéésh mə́bii, nə mbíya lâm, nə məkə́ŋ, nə asɨ́y-sɨ̂y, nə zhíŋ, nə *bwaasʉ́lə mpu, nə dʉ́lə ŋkɛ̂ny nyúúl, nə cʉg ímpwúfú. ");
INSERT INTO mcp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Isâ ínɨ byɛ̂sh í wú lâm mə́ múúd dɨ́ cwû, byó wə́ í dʉ́ wá múúd məlwaagʉwo mísh mə́ Zɛmbî dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yésus músə wú na kʉ́l nɨɨ́d. A músə kə kɔ́ɔ́mb shí á Tir. Wu, nyə mú kə nyíi wúlʉ́gá njɔ́wʉ́d, nyə ŋgə́ sɔ̧́ nə́ muud kú mpu nə́ nyə ji cínɔŋg. Njɨ buud bwə́ mú bə́lɛ nə́mə́ mpu. ");
INSERT INTO mcp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kú nə́mə́ bwey, ŋgwɔ́lʉ́gá múdá mú gwág nə́ Yésus mə́ jé cínɔŋg. Mudá wɔɔŋgʉ́, bɔ́w-bɔ̂w shíshim í á bul bii shilə yé. Nyə á ka zə kʉl nyúul Yésus dɨ́ shí məkuú. ");
INSERT INTO mcp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mudá wɔɔŋgʉ́ nyə á bə shilə Ogʉrɛ̂k, nyə a byɛ̂l lɔɔm á Fenisî, shí á Sirî. Nyə á ka zə jəgʉla nə Yésus nə́ a yílʉ́g shilə yé jamb. ");
INSERT INTO mcp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yésus mú cɨ nə nyə nə́: «Fwog bɨ́d nə́ bwân ɔ́ njɔ́w bwə́ də́g nə́ ndɛɛ́, jílə. Nəcé ŋwálə ídʉ̂w í bwân ɔ́ njɔ́w, wusə yə ómpyə̂, í anywáyɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Njɨ mudá ɛ́nɛ mú zə bɛ̧sa nə nyə nə́: «Ká, Cwámba, ompyə̂ bwə́ dʉ nə́mə́ cwála mə́mpulú mə́ dʉ́ kud tʉ́wʉli bwán dɨ́ shí má.» ");
INSERT INTO mcp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ntɔ́ Yésus mú zə cɨ nə nɛ́ nə́: «Nda wo mə́ mpu bə nə zɛ́ny nə́, nyiŋgə́g kə wódɨ́ njɔ́w; məjamb mə́ á ŋgə lwáfʉlə shilə wô má, mə́ mə́ wú nyə nyúúlʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mudá wɔɔŋgʉ̂ mú nyiŋgə, kə nyə́dɨ́ njɔ́w, kə kwey Mwân mbwúg shí, məjamb mə́ mə́ wú nyə. ");
INSERT INTO mcp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mpʉ́sə na, Yésus mú wú ŋgwə́la á Tir, ciiŋgya Sidon. Nyə a lɨ́ɨ́na mpál shí á miŋgwə́la wûm kə ŋgɛɛ mâŋ mə́ Galilê. ");
INSERT INTO mcp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cínɔŋg bwə́ mú zə nyə nə ŋgwɔ́l akúmə́lwə̂ a njúl nə́mə́ fífî. Bwə́ mú jəgʉla nə Yésus nə́ a bə́dʉg nyə məbwə̂. ");
INSERT INTO mcp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ntɔ́ Yésus mú zə ŋwa múúd ɛ́nɛ kə nə nyə kɔ́ɔ́mb búúd bwə́ á shígɛ́ bə yí. A mú jil nyə inyinə́ mə́lwə́d, a yîl. A sɛy mə́ntənd nyə́dɨ́ ínyinə́d nə́ ndɛɛ́ a cilə múúd ɛ́nɛ júmʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nə́ ndɛɛ́ nyə mú yág gwɔ́w, nyə səl fə̂m, nyə mú cɨ nə muud ɛ́nɛ nə́: «Efata!» (Ntɔ́ mə́ kə́ nə́ «báŋʉ́g!») ");
INSERT INTO mcp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cé nə cé jɔɔŋgʉ́d, muud ɛ́nɛ məlwə̂ mə́ mú bâŋ, tɛ́ɛ́mbí í mú wú júmʉ́d. Nyə mú mpu ŋgə lás. Yésus mú nyiŋgə nə nyə, zə kwey búúd. ");
INSERT INTO mcp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ntɔ́ Yésus mú báásʉlə bwo nə́ bwə́ kú bwɛlɛ jaaw tɔ́ɔ muud. Nyə á tɛɛm báásʉlə bwo ntʉ́nɨ, í mú yida bə nda nyə á ŋgə lwâm bwo nə́ bwə́ ŋgə́g nə cúndə. ");
INSERT INTO mcp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Buud bɛ̂sh bwə́ mú bul bɨ̂, bwə́ ŋgə́ cɨ nə́: «Isâ byɛ̂sh nyə́ ŋgə́ sá yí bísə ŋkí bul nywa! Nyə́ bə́lɛ sá nə́ wəakúmə́lwə̂ bwə́ gwágʉ́g, mifífí mí lásʉ́g!» ");
INSERT INTO mcp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mwɔ̂w mɔɔŋgʉ̂ dɨ, áncuncuma buud nyə á zə sɛɛŋgya kʉ́l Yésus nyə á bə yí. Nda bwə́ á shígɛ́lɛ́ bə nə sâ mə́ də̂ nə́, Yésus mú jɔ̂w *ómpwíín bɛ́, nyə nə bwo nə́ ");
INSERT INTO mcp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mə ŋgə gwág buud ɔ́ga ŋkúŋkwóŋʉ́lə nəcé sə́nɔ̂ŋ sə́ mə́ ji mwɔ̂w mə́lɔ́ɔl, ja gaad bwə́ cúgɛ́ ná nə sâ mə́ də̂. ");
INSERT INTO mcp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ŋkí mə́ nyiŋg bwo ntʉ́nɨ zha nə́ bwə́ kə́g bwə́dɨ́, bwə́ é kə tag nə məntʉmbʉli zhɨ́ɨ́d, nəcé bɔ́ɔ́lʉ́gá ŋkí bulya bwə́ ŋgə gwaa zhu.» ");
INSERT INTO mcp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ompwíín bɛ́ bwə́ mú bɛ̧sa nə nyə nə́: «Sə́ é wɨ́ɨl bwo ntʉdɛlɛ́ nə́ bwə́ jílə wa bugád?» ");
INSERT INTO mcp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yésus mú jî bwo nə́: «Bɨ bʉ́sə nə ibʉlɛ́d ínɛ́?» Bwə́ nə́: «Zaŋgbá.» ");
INSERT INTO mcp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yésus músə ka cɨ nə́ buud bwə́ jíg shí. Nə́ ndɛɛ́ a músə ŋwa íbʉlɛ́d zaŋgbá byɔɔŋgʉ́, a yə Zɛmbî akíba, a fɛ̂y byo ikʉ́l ikʉ̂l, yə ómpwíín bɛ́ nə́ bwə́ kə́g ŋgə kaaw, bwə́ mú kə kaaw búúd. ");
INSERT INTO mcp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bwə́ á bə nə bʉ́baalɛ́ íshúshú. Nyə mú ŋwa nə́mə́, yə Zɛmbî akíba. Nyə nə ompwíín bɛ́ nə́ bwə́ kááwʉg nə́mə́ byo. ");
INSERT INTO mcp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Buud bwə́ mú də nə́ ndɛɛ́, jílə. Zhwog ikʉ́l í mú lʉ́g tâŋ məkúdə́ zaŋgbá. ");
INSERT INTO mcp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Í njúl nə́ buud bwə́ á jee bə otɔ́ɔ́shin onɔ̧̂. Yésus mú nyiŋg búúd nə́ bwə́ kág ŋgə kə. ");
INSERT INTO mcp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nyə shwal kəwa byɔ́ɔ́lʉ́d, bə́nɔ̂ŋ ompwíín bɛ́ bwə́ mú kə shí á Dalmanuta. ");
INSERT INTO mcp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ja bwə́ mə́ kə jé wu yí, *Ofarizyɛ̂ŋ bwə́ mú zə shúsə Yésus nə minjígá mí mə́bwə́bʉ́lán, bwə́ zə jí nyə nə́ a lwóg bwo dúl *shimbá í ŋgə́ zhu gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yésus mú səl fə̂m nə mətag mə́ nyúul. Nyə nə bwo nə́: «Nəcé jɨ́ bɨ́ kala buud ga bɨ́ ŋgə cɛ́ɛ́l dʉ́g shimbá yí? Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kala búúd ga í ábʉ́lɛ́ bwɛlɛ dʉ́g tɔɔ sâ!» ");
INSERT INTO mcp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A mú béégya nə bwo, kwo kə kəwa byɔ́ɔ́lʉ́d nə́ a lɨ́ɨ́na, kə cíndú faŋwíny. ");
INSERT INTO mcp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","*Ompwíín bwə́ á ka wusa ŋwaálə íbʉlɛ́d ja bə́nɔ́ŋ bwə́ á kəwa byɔ́ɔ́l dɨ́ yí, bwə́ á bə nə njɨ ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yésus mú báásʉlə bwo nə́: «Jigá ncə̂ nə *Ofarizyɛ̂ŋ *ləvur wáŋ, tɔɔ yé mə́ Herod». ");
INSERT INTO mcp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «A lás ntʉ́nɨ nəcé sə́ cugɛ́ nə ibʉlɛ́d.» ");
INSERT INTO mcp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yésus mú mpu sâ bwə́ á ŋgə́ cɨ yí. A mú jí bwo nə́: «Nəcé jɨ́ tə́dʉ́gá wúsə́ bɨ́ njɨ nə́ bɨ shígɛ́ ŋwa íbʉlɛ́d yí? Jɨ́ bɨ́ mə́ cá gwág ntʉ́nɨ yí? Kú wámbʉlə ísâ! Bɨ anyíŋgə́yɛ́ ná bə nə fʉg ɨɨ́? ");
INSERT INTO mcp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bɨ bʉ́sə nə mísh, njɨ bɨ kú dʉ́g ɨɨ́? Bɨ bʉ́sə nə məlwə̂, njɨ bɨ kú gwág ɨɨ́? ");
INSERT INTO mcp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bɨ anyíŋgə́yɛ́ ná tə́dʉga ja mə́ á fɛ̂y ibʉlɛ́d itɔ́ɔn buud otɔ́ɔ́shin ótɔ́ɔn də yí? Bɨ á lwándʉlə mə́bwumú mə́nɛ́y nə ikʉ́l bɨ́ á lʉ́g nə ndɨ́ yí?» Bwə́ nə́: «Wûm nə mə́bá.» ");
INSERT INTO mcp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nyə nə́: «Ja mə́ á fɛ̂y ibʉlɛ́d zaŋgbá buud otɔ́ɔ́shin onɔ̧̂ də yí, bɨ á lwándʉlə məkúdə́ mə́nɛ́y nə ikʉ́l bɨ́ á lʉ́g nə ndɨ́ yí?» Bwə́ nə́: «Zaŋgbá.» ");
INSERT INTO mcp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yésus mú cɨ nə bwo nə́: «Ká jɨ́ bɨ́ mə́ cá gwág yí?» ");
INSERT INTO mcp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ntɔ́ bwə́ mú kə jé Bɛtʉsayída. Buud bwə́ mú zə nyə nə ancím-ncîm, zə tɛ́ɛ́g Yésus məbwə̂ nə́ á kúnyág nə nɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yésus mú zə bii áncím-ncîm wɔɔŋgʉ̂ mbwə́d, wú nə nɛ́ kwáádə́. Kʉ́l bá bwə́ á kə yí, nyə á ŋwa məntənd, bwiid múúd ɛ́nɛ míshʉ́d, a bəd nyə məbwə̂. A mú jí nyə nə́: «Ye wo ŋgə ŋwá dʉ́g?» ");
INSERT INTO mcp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ancím-ncîm mú bɛ̂ny mísh, nyə nə́: «Mə ŋgə dʉ́g buud. Bʉ́sə nda ilɨ́ɨ́, njɨ í ŋgə jaand.» ");
INSERT INTO mcp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yésus mú nyiŋgə kwo kɛɛl múúd ɛ́nɛ məbwə̂ míshʉ́d. Nyə mú yâl. Nyə mpu dʉ́g ísâ byɛ̂sh nə́ ŋgə́ŋ. ");
INSERT INTO mcp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yésus mú cɨ nə nyə nə́: «Nyiŋgə́g, wo kə́g bɨ́dɨ́; wo kú nyiŋgə kə kwáádə́ nɨɨ́d.» ");
INSERT INTO mcp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yésus bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ músə cɔ̧́ na, kə ŋgɛɛ mə́kwáádə́ mâ Sezarê mə Fílíp. A mú ŋgə jí ómpwíín bɛ́ nûŋ zhɨ́ɨ́d nə́: «Buud bwə́ ŋgə cɨ nə́ mə jisə zə́?» ");
INSERT INTO mcp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bwə́ mú bɛ̧sa nə nyə nə́: «Bɔ́ɔ́lʉ́gá búúd bwə́ ŋgə cɨ nə́ wo jisə Yuánɛs Nduu-buud, bɔ́ɔ́l nə́ wo jisə Eli, bɔ́ɔ́lʉ́gá bwə́ ŋgə́ nə́mə́ cɨ nə́ wo jisə ŋgwɔ́l *múúd micúndə́.» ");
INSERT INTO mcp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A mú nyiŋgə jí bwo nə́: «Ká bɨ bâŋ ŋgə cɨ nə́ mə jisə zə́?» Pyɛ̂r músə bɛ̧sa nə nyə nə́: «Wo jisə *Krîst.» ");
INSERT INTO mcp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nə́ ndɛɛ́, a mú báásʉlə bwo nə́ ci bwə́ kú bwɛlɛ jaaw múúd sâ á jísə́ yí. ");
INSERT INTO mcp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A mú ka tɛ́ɛ́d jɨ́ɨ́gʉ́lílə bwo nə́: «Í jɨɨ shú mə́ *Mwân mə Múúd nə́ ocúmbá buud wâ lɔɔm nə milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ kə́g jág jugʉshi nyə, bwə́ kudʉwa nyə, bwə́ gwú ntâg nyə. Njɨ a bá gwûm shwoŋ dɨ́ mpʉ́sə mwɔ́w mə́lɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nyə á jaaw bwo gwo nə́ kpwɔɔ́. Pyɛ̂r músə kə nə nyə koogʉ́, kə lás nə nyə. ");
INSERT INTO mcp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yésus músə yid, dʉ́g *ómpwíín bɛ́, a mú ŋkáánd nə Pyɛ̂r nə́: «Wúg mə na, *Sátan! Mitə́dʉ́gá myô mí cúgɛ́ mítə́dʉ́gá mí Zɛmbî, mísə njɨ mitə́dʉ́gá myâ buud.» ");
INSERT INTO mcp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A mú ka jɔ̂w ncúlyá buud bwə́ á bə cínɔŋg wá bə́nɔ̂ŋ ompwíín bɛ́, nyə nə bwo nə́: «Ŋkí muud mə́ cɛɛl bɛ̧ mə, a bə́g kú jagʉlə nyə́mɛ́fwó; a ŋkɛ́nyʉ́g kwolós jé, a bɛ̧ mə. ");
INSERT INTO mcp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nəcé, múúd mə ká kaambʉlə nə cʉg jé, a yida jímbal gwo. Nyɔɔŋg mə jímbál cʉg jé nəcé mə nə shú Jɔ̧jɔ̧ Kɛ́ɛ́l yɛ́, a faam. ");
INSERT INTO mcp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ŋkí muud mə́ bii mə́bii mɛ̂sh mâ shí ga nə́ ndɛɛ́ *shíshim yé jímb, wáyɛ́ mfíí nyə́ é bə nə ndɨ́ cínɔŋg yí? ");
INSERT INTO mcp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Muud jɨ nə ŋkul wá jɨ́ shú nə́ a nyíŋgəg bii shíshim yé? ");
INSERT INTO mcp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mpugá nə́ muud mə bá gwág mə shwôn, gwág íciyá byâm shwôn kala búúd á mitə́dʉ́gá olɨ́lɨŋgɨ̂ í ŋgə́ sá məbɔ̂w ga dɨ́ yɛ́, Mwân mə Múúd mə bá nə́mə́ gwág nyə shwôn ja á bá zə a ŋgə́ ŋkənʉwa məŋkənʉwa mə Sɔ́ɔ́ŋgʉ́ yé, bə́nɔ̂ŋ mifééshá mí wəéŋgəles yí.» ");
INSERT INTO mcp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A mú nyiŋgə cɨ nə bwo nə́: «Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, bɔ́ɔ́l búúd bʉ́sə́ wa ɔ́ga, bwə́ abʉ́lɛ́ bwɛlɛ yə, bwə́ kú fwo dʉ́g Faan mə́ Zɛmbî mə́ wɔ́ɔ́s nə ŋkul.» ");
INSERT INTO mcp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mpʉ́sə mwɔ̂w mə́saman, Yésus mú ŋwa Pyɛ̂r nə Zhâk bá Yuánɛs. A mú wú nə bwo búúd dɨ́, bwə́ kə bád wúl məma mbʉ́ŋʉ́d, njɨ bə́nɔ́ŋ kú nə ŋgwɔ́l múud. Nyúúl nyɛ́ mú shwɔ̧́ɔ̧la bwo míshʉ́d, ");
INSERT INTO mcp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mikáándə́ myɛ́ mí mú ŋgə jág bul faan nə mbii mə́fumə mâ nə́, tɔɔ muud cúgɛ́ nə ŋkul gusa míkáándə́ nə́ ndɛɛ́ mí fumə ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cínɔŋgʉ́, Moyîz bá Eli bwə́ mú wɔ́ɔ́s, zə ŋgə́ lésha nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pyɛ̂r músə ka cɨ nə Yésus nə́: «*Rabi, nywaálə ŋgə́lə ji wa. Sə́ shúməgá məbanda məlɔ́ɔl, ŋgwúd shú dwô, dúl shú mə́ Moyîz, dúlʉ́gá shú mə́ Eli.» ");
INSERT INTO mcp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pyɛ̂r nyə a shígɛ́ mpu sâ á cɨ́g yí, nəcé bə́nɔ̂ŋ bɔ́ɔ́lʉ́gá *ómpwíín bwə́ á bul gwág ifwaas nda bwə́ nyɛ̂. ");
INSERT INTO mcp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Seegya njɨ gúndə́ í mə́ zə búdal bɛ̂sh. Bwə́ mú gwág kə́l í ŋgə́ wú gúndə́ jɔɔŋg dɨ́ nə́: «Mwân waamə́ abábə wə́ ɛ́ga. Ságá nyə məgwág.» ");
INSERT INTO mcp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ompwíín bwə́ mú ntâg ŋgə yágʉwa, bwə́ kú ná dʉ́g tɔɔ muud shús, njɨ bə́nɔ̂ŋ Yésus wə́ bwə́ á bə. ");
INSERT INTO mcp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ja bə́nɔ́ŋ bwə́ mə́ ka ŋgə shulə wú mbʉ́ŋ dɨ́ yí, a mú lás nə bwo nə́: «Ci bɨ kú jaaw múúd sâ bɨ́ ámə dʉ́g yí, kə wɔ́ɔ́s ja *Mwân mə Múúd mə bá gwûm shwoŋ dɨ̂ yí.» ");
INSERT INTO mcp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bwə́ mú baagʉlə cɨ nɨ, njɨ bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «Gwúmʉ́lə mə́shwoŋ dɨ́ á ŋgə́ cɨ ga, í kə́ nə́ jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nə́ ndɛɛ́ bwə́ músə jí nyə nə́: «Nəcé jɨ́ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ dʉ cɨ nə́ í jɨɨ nə́ Eli fwóg tɛ́ɛ́d zə yí?» ");
INSERT INTO mcp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A mú bɛ̧sa nə́: «Jɨ́ bə́lɛ bə ntɔ́ nə́ Eli mə́ jəlá nə fwo zə, zə tə̂l ísâ byɛ̂sh ícé byáŋʉ́d. Ká nəcé jɨ́ jísə́ cilyá Kálaad Zɛmbî dɨ́ nə́ bwə́ bá mpyêny Mwân mə Múud, bwə́ bul jugʉshi nyə yí? ");
INSERT INTO mcp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sâ ŋgwúdʉ́, mɛɛ mə́ jaaw bɨ́ nə́ Eli nyə a shí bwey zə. Buud bwə́ á sá nyə mbií wɛ̂sh bwə́ á cɛɛl yí, nə́mə́ nda jɨ́ cilyá shú dɛ́ dɨ́ nə́.» ");
INSERT INTO mcp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ja bwə́ mə́ kə wɔ́ɔ́s *ómpwíín dɨ́ yí, bwə́ mú kwey mə́ŋkúmbə mə búúd mə́ mə́ lyɛ̧ bwo, bə́nɔ̂ŋ Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ ŋgə́ sɛ́ŋʉsa məkə̂l. ");
INSERT INTO mcp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Njɨ mə́ŋkúmbə mə búúd mə́nɨ mə́ mə́ dʉ́g Yésus yí, bwə́ mú seegya, bwə́ mú ŋgə kə nə mikʉ́lə́, kə ŋgə bə́da nyə. ");
INSERT INTO mcp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yésus mú jí ómpwíín bɛ́ nə́: «Jáyɛ́ bɨ́nɔ́ŋ buud ɔ́ga ŋgə́ sɛ́ŋʉsa məkə̂l nə ndɨ̂ yí?» ");
INSERT INTO mcp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na zhwog buud ɛ́nɛ dɨ́, ŋgwɔ́l múúd mú bɛ̧sa nə nyə nə́: «Yɨ́ɨ́gʉli mə́ ámə zə nə mwân waamə́ wódɨ́, wúl shíshim í mə́ sá nə́ a bə́g kú ná lás. ");
INSERT INTO mcp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Í mú ntâg ka dʉ bə, kʉ́l jɛ̂sh í ámə wɔ́ɔ́s nə́ í bii nyə yí, í jumə nyə shí, ifúlug lwánd nyə mpu, a ŋgə́ fúgal məjə, a shwal nyánʉwo. Mə́ ámə jí ómpwíín bwô nə́ bwə́ yílʉ́g nyə jamb dɔɔŋgʉ̂, bwə́ shígɛ́ kwag.» ");
INSERT INTO mcp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yésus músə bɨ̂ nə́: «Wúu! Yé óháádɛn ɔ́ga! Mə e bá kə nə bɨ̂ ntʉ́nɨ kə wɔ́ɔ́s ŋgow? Mə e bá jísɔw bɨ́ kə kumə jáyɛ́ ja? Zəgá mə nə mwân wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bwə́ mú kə nə nyə. Njɨ shíshim nɨ í mə́ dʉ́g Yésus yí, í mú juŋg mwân nə ŋkulû, a mú juma shí, ŋgə bíŋgʉla, ifúlug í ŋgə́ wɔ́ɔ́s nyə mpud. ");
INSERT INTO mcp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yésus mú jí sɔ́ɔ́ŋgʉ́ mwân nə́: «Í á tɛ́ɛ́d nyə jáyɛ́ ja?» A mú bɛ̧sa nə́: «Í á tɛ́ɛ́d nyə, a njúl ná mwántombú. ");
INSERT INTO mcp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Í dʉ cɛɛl gwú nyə. Í dʉ kʉl nyə tɔɔ kuda dɨ́ tɔɔ mə́júwód ija ija. Ŋkí wo jɨ nə ŋkul sá gúl sâ shú dɛ́, gwágʉ́g sə́ ŋkúŋkwóŋʉ́lə, kwííndʉ́g sə̂.» ");
INSERT INTO mcp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yésus mú yagʉla nyə nə́: «Ŋkí wo jɨ nə ŋkul!» Ntɔ́, a mú jaaw nyə nə́: «Múúd yɛ̂sh mə *búgʉ́lá Zɛmbî yɛ́ jɨ nə ŋkul sá sâ jɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Cé nə cé sɔ́ɔ́ŋgʉ́ mwân mú lás gwɔ́w gwɔ̂w nə́: «Mə ŋgə *búgʉla! Njɨ, yə́g mə ŋkul nə́ mə mpúg bə nə búgə́!» ");
INSERT INTO mcp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Buud bwə́ mú zə sɛɛŋgya áncuncuma kʉ́l bwə́ á bə yí. Ntɔ́ Yésus mú ŋkáánd nə shíshim ábʉ́bɔ̂w wɔɔŋg nə́: «Wo shíshim ŋgə́ juwo mwân məlwə̂ nə mpu ga! Mə yɨ́ɨ́mbʉ́lí wo nə́, wúg nyə nyúúlʉ́d! Ci wo kú ná bá nyiŋgə nyíi nyə nyúúlʉ́d!» ");
INSERT INTO mcp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Í mú kɨ̂m nə ŋkulû, í juŋg mwân nə́ ndɛɛ́ wú nyə nyúúlʉ́d. Mwân mú cɔ̧́ fudʉd nə́ nyágʉ́sə́, zhwog buud bwə́ ŋgə́ cɨ nə́: «A mə́ yə.» ");
INSERT INTO mcp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Njɨ Yésus mú bií nyə mbwə̂, wɛɛl nyə. Mwân mú tɔ̂w tʉ́təlî. ");
INSERT INTO mcp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nə́ ndɛɛ́, Yésus mú kə nyíi njɔ́w. Ompwíín bɛ́ bwə́ mú kə jí nyə wu bə́nɔ́ŋ bwə́mɛ́fwó nə́: «Nəcé jɨ́ sə́ bâŋ shígɛ́ kwag yílʉ́lə shíshim nɨ yí?» ");
INSERT INTO mcp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A mú bɛ̧sa bwo nə́, bwə́ dʉ yîl mbií nɨ njɨ nə məjəgʉla. ");
INSERT INTO mcp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bwə́ mú zə lɔ̧ na. Bwə́ lɨ́ɨ́na Galilê. Yésus nyə a shígɛ́ cɛɛl nə́ buud bwə́ mpúg kʉ́l bwə́ á bə yí, ");
INSERT INTO mcp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nəcé nyə á ŋgə jɨ́ɨ́gʉli *ompwíín bɛ́. Nə́ ndɛɛ́, a mú ŋgə́ jaaw bwo nə́: «Í jɨɨ nə́ *Mwân mə Múúd bâg kaanz məbwə̂ mə́ búúd dɨ́, bwə́ bág gwú nyə. Njɨ mpʉ́sə shwɨy dɛ́, nyə bá já shwoŋ dɨ́ mwɔ̂w mə́bá, a mú gwûm jwɔ̂w álɛ́ɛl.» ");
INSERT INTO mcp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Njɨ Yésus nyə á tɛɛm ŋgə jaaw bwo ntɔ́, bwə́ á shígɛ́ mpu gwág. Bwə́ mú bul gwág ifwaas. Bwə́ ŋgə́ fúndə jílə nyə nə́ nyə fɛ́ɛ́lʉ́g bwo isâ nyə́ ŋgə́ jaaw bwo yí. ");
INSERT INTO mcp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ntɔ́ bwə́ mú kə jé Kapɛrnawûm. Cínɔŋg bwə́ mú nyíi wúl njɔ́wʉ́d. Yésus mú jí ómpwíín bɛ́ nə́: «Jɨ́ gwə́mɛ́fwó bɨ́ ámə ŋgə sɛ́ŋʉsa məkə̂l nə gwo zhɨ́ɨ́ nə zhɨɨ́ yí?» ");
INSERT INTO mcp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bwə́ mú ji nə́ kufʉg, nəcé zhɨ́ɨ́ nə zhɨɨ́, bwə́ á ŋgə shwɔ̧ nə́ bwə́ cɛɛl mpu nyɔɔŋg jɨ́ bul bə fwámɛ́ múúd bwə́dɨ́ gwooŋg dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ntɔ́ Yésus mú zə ji shí. Nyə jɔ̂w *ómpwíín wûm nə óbá bɛ́. Nyə nə bwo nə́: «Múúd mə cɛ́ɛ́l bə tɔ́we shwóg á gwooŋg jɨ́n yɛ́, nyə́ jəlá nə bə múúd a mpʉ́sə, nyə bə nə́mə́ sɔ́ɔl məsáal á gwooŋg jɨ́nʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nyə́ ká shîn lás ntɔ́, nyə mú zə ŋwa gúl kʉ́kágə́, tə́l bwo nyə míshʉ́d, a mú ŋwa nyə nyə́dɨ́ mə́bwə́d. Nyə nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Muud mə lə́g gúl kʉ́kágə́ nda jíga jínə́ dâm dɨ́ yɛ́, a mə́ lə́g mə. Muud mə lə́g ntâg mə yɛ́, nyə alə́gɛ́ mə, a lə́g múúd nyə á ntɨ mə yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na Yuánɛs mú cɨ nə Yésus nə́: «Yɨ́ɨ́gʉli, sə́ ámə dʉ́g ŋgwɔ́l múúd ŋgə́ balan nə jínə́ dwô, ŋgə yîl buud məjamb nə ndɨ̂. Sə́ ámə ka kaambʉlə nə nyə nə́ a kú ná ŋgə sá nəcé a cugɛ́ sə́dɨ́ gwooŋg dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yésus mú bɛ̧sa nə nyə nə́: «Kúgá dʉ kaambʉlə nə́ a kú ŋgə sâ. Muud cúgɛ́ nə ŋkul balan nə jínə́ dâm, sá *mə́shimbá nə ndɨ́, nə́ ndɛɛ́ nyə nyiŋgə kə ŋgə lás nə mə ŋkí bɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nəcé muud nyə́ aŋgɛ̂ nə mpii shé yɛ́, jɨ shédɨ́ kɔ́ɔ́mbʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Muud mə bá yána tɔɔ njɨ láá mə́júwó ŋgwûd, ŋgulal bɨ́ mə́dɨ́ jínə́d nəcé bɨ bə́lə búúd ɔ́ *Krîst yɛ́, bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud wɔɔŋgʉ̂ nyə abʉ́lɛ shúb myə́na myâ cínɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Njɨ, ikʉ́kágə́ í ŋgə́ *búgʉla mə íga, múúd mə ká kwal gúl bɔɔgʉ́, í bul jəla nə́ bwə́ kə́lʉg muud wɔɔŋgʉ̂ məma kwóógʉ́ cʉ́ŋʉ́d, bwə́ kʉl nyə nə dwo mâŋ. ");
INSERT INTO mcp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ntɔ́, í ká bə nə́ mbwə̂ wô ŋkí kuú wô í ŋgə kwal wo bɔɔgʉ́, sámbʉ́g wə, nəcé í bul jəla nə́ wo cʉ́gəg cʉg á kandʉgə wo njúl nə kʉ́l mbwə̂ ŋkí kʉ́l kuú, ");
INSERT INTO mcp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ntɔ̧ nə́ wo bə́g nə məbwə̂ mwô mɛ̂sh wo mú kə kuda á kandʉgə jísə́ kú jímə yíd. ");
INSERT INTO mcp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Í ká bə nə́ kuú wô í ŋgə kwal wo bɔɔgʉ́, sámbʉ́g wə, nəcé í bul jəla nə́ wo cʉ́gəg cʉg á kandʉgə wo njúl nə kʉ́l kuú, ");
INSERT INTO mcp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ntɔ̧ nə́ wo bə́g nə məkuú mwô mɛ̂sh wo mú kə kuda á kandʉgə jísə́ kú jímə yíd. ");
INSERT INTO mcp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ŋkí jús dwô í ŋgə kwal wo bɔɔgʉ́, tɨ́ɨ́g dwo. Í bul jəla nə́ wo nyííg Faan mə́ Zɛmbî dɨ́ nə ncwaan jús, ntɔ̧ nə́ wo bə́g nə mísh mwô mɛ̂sh bwə́ bá kə kʉl wo kuda á kandʉgəd. ");
INSERT INTO mcp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cínɔŋg kuda jɔɔŋgʉ́d ilúmágə́ í dʉ də nyúul yí í ádɛ́ fudə. Kuda kú nə́mə́ bwɛlɛ jímə. ");
INSERT INTO mcp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mpugá nə́ kuda í bá wá múúd yɛ̂sh məgwâm nə́mə́ nda ca í dʉ wá mə́gwâm ídʉ̂w dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ca dʉ́sə jɔ̧ sâ. Sâ ŋgwúdʉ̂, ŋkí ca í sɔ́ɔ́mb, jɨ́ í bá nyiŋgə wá dwo məgwâm? Bə́gá nə́mə́ nda jɔ̧ ca mpə́dʉ́gá búúd, bɨ́ mú ka bə nə ŋkul ji mpwogɛ́ mpə́dʉ́gá bɨmɛ́fwó nə bɨmɛ́fwó.» ");
INSERT INTO mcp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nə́ ndɛɛ́, Yésus nyə á ka wú na, kə shí á Yudéa, Zhurdɛ̧̂ faŋwíny. Buud bwə́ mú zə áncuncuma zə ŋkúndɔw cínɔŋg nyə́dɨ́. A mú ŋgə jɨ́ɨ́gʉli bwo nda nyə á dʉ sá nə́. ");
INSERT INTO mcp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɔ́ɔ́l *Ofarizyɛ̂ŋ bwə́ á zə kə nyə́dɨ́, kə bwɔ́wʉlə nyə, bwə́ nə́: «Ye məcɛ̧ɛ̧ míshé mə́ ŋgə cɨ nə́ muud jɨ nə ŋkul yîl múdá yé bâ?» ");
INSERT INTO mcp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ntɔ́ nyə mú bɛ̧sa bwo nə́: «Moyîz nyə a báásʉlə bɨ́ nə́ jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bwə́ nə nyə nə́: «Moyîz nyɛ nyə á cilə nə́ múúd mə ká cɛɛl yîl múdá yé bâ, a yə nyə kálaad məgwú mə́ bâ.» ");
INSERT INTO mcp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yésus mú cɨ nə bwo nə́: «Moyîz nyə á yə bɨ́ cɛ̧ɛ̧́ dɔɔŋgʉ́ nəcé lal bɨ́ milâm. ");
INSERT INTO mcp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sâ ŋgwúdʉ̂, ja Zɛmbî nyə á tɛ́ isâ byɛ̂sh yí, nyə a sá mudúm bá mudá. Ntɔ́ nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Nda mə mə́ sá bwo ntʉ́nɨ́ nə́, mudúm mə́ bá lʉ́gə sɔ́ɔ́ŋgʉ́ bá nyɔɔŋgʉ̂, a kə leedya nə mudá yé, ");
INSERT INTO mcp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bá obá bwə́ mú bə nyúul ŋgwúdʉ̂.” Ntɔ́ jɨ nə́ bwə́ cúgɛ́ ná búúd obá, bwə́ músə muud ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Muud nyə ajə́láyɛ́ nə ka bɛ́ɛ́g sá Zɛmbî mə́ laad yí.» ");
INSERT INTO mcp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ja bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ mə́ kə wɔ́ɔ́s njɔ́w yí, bwə́ mú kwo jí nyə nə́ a fɛ́ɛ́lʉ́g bwo lə́sʉ́ wɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ntɔ́ wə́ nyə á cɨ nə bwo nə́: «Ŋkí muud mə yíl múdá yé bâ, a bá múdá shús ɨɨ́, muud wɔɔŋg mə́ sá mínɔɔmb mísh mə́ múdá nyə ámə yîl yɛ́d. ");
INSERT INTO mcp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tɔɔ mudá, á ká wú bâ, a nyiŋgə kə dúl báád ɨɨ́, a mə́ sá nə́mə́ mínɔɔmb.» ");
INSERT INTO mcp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bɔ́ɔ́l búúd bwə́ á ka zə nə ikʉ́kágə́ wə́ Yésus nə́ a kúnyág nə byo. Njɨ *ompwíín bwə́ mú lás nə bwo. ");
INSERT INTO mcp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nda Yésus nyə a dʉ́g ntɔ́ nə́, nyə a lámʉsa nə ompwíín bɛ́, nyə nə bwo nə́: «Bɨ́dʉ́gá ikʉ́kágə́ í zə́g mə́dɨ́, kúgá kaambʉlə nə bwo, nəcé Faan mə́ Zɛmbî dʉ́sə sâ á mbií búúd wáŋ. ");
INSERT INTO mcp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud yɛ̂sh nyə amágʉ́lə́yɛ́ Faan mə́ Zɛmbî məməgʉlá mə kʉ́kágə́ yɛ́, muud wɔɔŋgʉ̂ cúgɛ́ nə ŋkul nyíi cínɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A mú ŋkɛ̂ny bwân bɔɔŋgʉ́, ŋgə bəd bwo məbwə̂, ŋgə yə bwo ocúncɛ́sh. ");
INSERT INTO mcp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yésus mú zə cɔ̧́ na. A ŋgə́ kə zhɨ́ɨ́d, ŋgwɔ́l múúd mú zə nə kʉ́lə́, zə kúdɔw nyə́dɨ́ shwóg. A mú jí Yésus nə́: «Jɔ̧jɔ̧ Yɨ́ɨ́gʉli, jáyɛ́ jɔ̧ sâ mə́ sáág nə́ mə bííg cʉg á kandʉgə kandʉgə yí?» ");
INSERT INTO mcp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yésus mú yida cɨ nə nyə nə́: «Nəcé jɨ́ wó jɔ́w mə nə́ jɔ̧jɔ̧ múúd yí? Kú nə muud jɨ́ jɔ̧ múúd, njɨ Zɛmbî nyəmɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wo mpú dɨ́ məcɛ̧ɛ̧ mə́ga? “Wo kú gwú múúd, kú sá mínɔɔmb, kú júwo, kú yə múúd mpwɛnɛ á sá nyə́ ampúyɛ́ yí, kú shɨɨg múúd, gúmal sɔ́ɔ́ŋgʉ́ woó nə nyɔɔŋgʉ́ woó.”» ");
INSERT INTO mcp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Muud ɛ́nɛ mú bɛ̧sa nə nyə nə́: «Yɨ́ɨ́gʉli! Mə ŋgə bɛ̧ məcɛ̧ɛ̧ mə́nɨ mɛ̂sh, tɛ́ɛ́d íkágə́d zə kumə múús.» ");
INSERT INTO mcp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yésus mú dʉ́g nyə nə́ figə́-figə́, a mú gwág nyə cɛy lámʉ́d. Nyə nə nɛ́ nə́: «Í ŋgə ná fúfə wo sâ ŋgwúd. Kaá kusha ísâ byɛ̂sh wó jɨ́ nə ndɨ̂ yí, wo yə mímbúmbúwá *mwaanɛ̂ wɔɔŋgʉ̂, wo ka bá kə bə nə məbii gwɔ̂w; ság ntɔ́ wo ka zə bɛ̧ mə.» ");
INSERT INTO mcp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Muud wɔɔŋg mú shúsʉla nə mpɛ̧sá mə́ Yésus, a mú ntâg kyey, nəcé nyə á bə nə zhwog məbii. ");
INSERT INTO mcp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yésus mú ciŋg mpwóómbʉ́ dʉ́g nyə́dɨ́ mə́koogʉ́ nə́ ndɛɛ́, a mú cɨ nə *ompwíín bɛ́ nə́: «A kwowʉlálə nə́ buud bɨ́ nə məbii wá bwə́ nyííg Faan mə́ Zɛmbî dɨ́ eé!» ");
INSERT INTO mcp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ompwíín bɛ́ bwə́ mú káam ciyá jɔɔŋg, Yésus mú nyiŋgə cɨ nə bwo nə́: «Yé bwân bâm! A kwowʉlálə nə́ muud nyííg Faan mə́ Zɛmbî dɨ́ eé! ");
INSERT INTO mcp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Í yida nywá bə kúnə́-kúnə nə́ *shamô nyííg luun lʉ́ ndundu dɨ́, ntɔ̧ nə́ muud á bulya məbii nyííg Faan mə́ Zɛmbî dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Njɨ bwə́ á gwág ntʉ́nɨ yí, bwə́ á bul káam, bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «Ká zə́ jɨ́ nə ŋkul *dʉ́g cʉg yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yésus mú kənd mísh bwə́dɨ́, a mú cɨ nə bwo nə́: «Muud cugɛ́ nə ŋkul sá jínɨ jâŋ, njɨ Zɛmbî; nəcé Zɛmbî nywáá jɨ nə ŋkul sá sâ jɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pyɛ̂r mú ja lə́sʉ́, nyə nə́: «Ká, dʉgɨ́! Sə́ báá sə́ á mə́ shîn lʉ́gə ísâ byɛ̂sh, sə́ zə bɛ̧ wo.» ");
INSERT INTO mcp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yésus mú bɛ̧sa nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ŋkí muud mə sá nə́, tɔɔ minjɔ́w, tɔɔ məshí, tɔɔ omínyɔŋʉ̂, tɔɔ okɔ́ɔ́l, tɔɔ nyɔɔŋgʉ́, tɔɔ sɔ́ɔ́ŋgʉ́, tɔɔ bwân, a lʉ́gə byo shú dâm, nə shú bwiiŋgʉ́lə Jɔ̧jɔ̧ Kɛ́ɛ́l, ");
INSERT INTO mcp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nyə é nyiŋgə bií ísâ byɔɔŋg byɛ̂sh ija təd tɛ́ nyə́ é ŋgə cʉgə wa shí yí: tɔɔ minjɔ́w, tɔɔ məshí, tɔɔ omínyɔŋʉ̂ nə okɔ́ɔ́l, nə nyɔɔŋgʉ̂, nə bwân, ija təd, a bwəma nə́mə́ nə cúwʉ́lí cínɔŋg, nə́ ndɛɛ́ a ka bá kə cʉgə kandʉgə kandʉgə cʉg í zág yííd. ");
INSERT INTO mcp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bɔ́ɔ́l ncúlyá buud bwə́ tə́l shwóg wá, bwə́ bá tɔ̂w mpʉ́sə, bɔɔŋg bwə́ tə́l mpʉ́sə wá, bwə́ bá tɔ̂w shwóg.» ");
INSERT INTO mcp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bwə́ á ka ŋgə bád kə Yurʉ́səlɛm, Yésus tə́l shwóg, ompwíín bɛ́ bwə́ ŋgə́ bɛ̧ nyə mpʉ́sə, mílâm mí kə́l bwo gwɔ̂w nə ifwaas. Tɔɔ buud bwə́ á ŋgə́ bɛ̧ bwo wá, bwə́ á ŋgə nə́mə́ bɛɛmb. Yésus mú ŋwa *ompwíín wûm nə óbá bɛ́, a wú nə bwo búúd dɨ́, bə́nɔ́ŋ kə ŋgə kyey koogʉ́, a mú ŋgə jaaw bwo isâ í bá zə sɨ̂y nə nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nyə nə́: «Dʉgá, sə́ ŋgə́lə bád kə Yurʉ́səlɛm ɔ́ga; mpugá nə́ *Mwân mə Múúd mə zə́ kə kaanz mə́bwə̂ mə́ mílúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧́d. Bwə́ é cɛ̧ɛ̧lə nyə shwɨy, bwə́ mú kɛɛnzh nyə mə́bwə̂ mə́ íkûl ishúsʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bwə́ wə́ bwə́ bá cágʉlə nyə, bwə́ sɛy nyə məntənd mpwóómbʉ́d, bwə́ fyámʉsə nyə milwóŋ, bwə́ mú gwú nyə. Njɨ nyə bá gwûm shwoŋ dɨ́ jwɔ̂w álɛ́ɛl.» ");
INSERT INTO mcp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nə́ ndɛɛ́, Zhâk bá Yuánɛs, bwân ɔ́ Zhébedé, bwə́ mú zə shísh wə́ Yésus, zə cɨ nə nyə nə́: «Yɨ́ɨ́gʉli, sə́ mə́ tɛ́ɛ́g wo məbwə̂, ság sə́ sâ sə́ é jí wo yí.» ");
INSERT INTO mcp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A músə jí bwo nə́: «Bɨ mə́ jɨɨ nə́ mə sáág bɨ́ jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bwə́ mú bɛ̧sa nə́: «Yə́g sə́ wáda nə́ sə́ bâg ji wo, nyíga mbwə̂ məkɔ́ɔ́l, nyíga mbwə̂ məncwûm ja wó bá kə ji wódɨ́ jiya gúmə́d yí.» ");
INSERT INTO mcp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yésus mú bɛ̧sa nə́: «Bɨ́ ampúyɛ́ sâ bɨ́ ŋgə́ jɨɨ yí. Ye bɨ bɨ́ nə ŋkul ŋgul bálá mə́ é ŋgul yí, ŋkí nə́ bɨ́ duwan nduwán mə́ é duwan yí?» ");
INSERT INTO mcp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bwə́ nə́: «Haaw. Sə́ bɨ́ nə ŋkul ŋgul.» Yésus nə bwo nə́: «Bálá mə́ zə́ ŋgul yí, bɨ́ é ŋgul gwo, tɔɔ nduwán mə́ zə́ duwan yí, bɨ é duwan nə́mə́ wo. ");
INSERT INTO mcp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Njɨ, kɔ́ɔ́mb á nə́ bɨ jíg mə nyíga mbwə̂ məncwûm nyíga mbwə̂ məkɔ́ɔ́l, mə dɨ́ jɨ́ nə ŋkul ŋwa wʉ́nɨ cígʉ́lá, ijiya byɔɔŋg bísə shú búúd í á bwey kwəmʉsɔw wá.» ");
INSERT INTO mcp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ja bɔ́ɔ́l *ómpwíín wûm bwə́ á gwág ntɔ́ yí, bwə́ a gwág Zhâk bá Yuánɛs bɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yésus mú jɔ̂w bwo, lás nə bwo nə́: «Ŋgaá bɨ mə mpú nə́ buud bwə́ ŋgə́ wúmə nə jiya tɔ́we shwóg íkûl ishús dɨ́ wá bwə́ ŋgə ntɛɛŋg ijwûga byáŋ, ofwó búúd bwə́ ŋgə́ lwóya njɨ mpə̂l. ");
INSERT INTO mcp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Í ajə́láyɛ́ nə bə ntɔ́ bɨ́ bâŋ dɨ́. Nyɔɔŋg yɛ̂sh mə cɛ́ɛ́l bə fwó múúd gwooŋg jɨ́n dɨ́ yɛ́, yídag sɛ̂y nə bɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nyɔɔŋg mə cɛ́ɛ́l tɔ̂w bɨ́ shwóg yɛ́, bə́g bɔ́ɔ́lʉ́gá lwaá. ");
INSERT INTO mcp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sâ jɔɔŋgʉ̂ wə́ jísə́ nə́ *Mwân mə Múúd nyəmɛ́fwó nyə a shígɛ́ zə nə́ bwə́ sɛ́yʉ́g nə nyə. Nyə á yida zə sɛ̂y nə buud, a yána nə́mə́ cʉg jé shú nə́ ncúlyá buud bwə́ bə́g ofʉlî.» ");
INSERT INTO mcp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ntɔ́, Yésus bə́nɔ̂ŋ ómpwíín bɛ́ bwə́ mú kə kumə Zheríko. Bwə́ mú ŋgə lɔ̧ ŋgwə́la wɔɔŋgʉ̂; buud bwə́ á ŋgə bɛ̧ bwo áncuncuma. Ŋgwɔ́l áncím-ncîm nyə á bə zhɨ́ɨ́ dɨ́ koogʉ́, a ŋgə́ gwáámb buud isâ. Muud wɔɔŋgʉ̂ nyə á bə nə jínə́ nə́ Bartimê, mwân mə́ Timê. ");
INSERT INTO mcp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nyə mú gwág nə́ Yésus á Nazarɛ̂t wə́ ŋgə́ cɔ̧́ ɛ́nɛ. Ntɔ́ nyə mú tɛ́ɛ́d ŋgə́lə kɨ̂m nə́: «Yésus, mwân mə *Dávid, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Njɨ buud bwə́ mú ŋgə ŋkáánd nə nyə. Tɔɔ ntɔ́ nyə mú mpu bʉ̂n kə́l gwɔ̂w nə́: «Yé Mwân mə Dávid, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́.» ");
INSERT INTO mcp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yésus mú shigʉla. Nyə nə́ buud nə́: «Jɔ́wʉ́gá mə nyə.» Bwə́ músə jɔ̂w áncím-ncîm. Bwə́ nə nyə nə́: «Səlʉg lâm shí! Tɔ́wʉ́g! A ŋgə jɔ̂w wo.» ");
INSERT INTO mcp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Muud ɛ́nɛ mú wusə kúúd jé koogʉ́. A mú bumb, lɛɛl kə wə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yésus mú cɨ nə nyə nə́: «Wó jɨɨ nə́ mə sáág wo jɨ?» Ancím-ncîm mú bɛ̧sa nə́: «Ye yɨ́ɨ́gʉli, ság nə́ mə kwóg dʉ́gya.» ");
INSERT INTO mcp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yésus nə nyə nə́: «Kaág mpwogɛ́, wo mə́ *dʉ́g cʉg nəcé búgə́ gwô.» Cé nə cé, mísh mə́ mú nyiŋgə dʉ́gya nyə. A músə bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ja bwə́ á ŋgə shísh kúnə́-kúnə nə Yurʉ́səlɛm yí, bwə́ á kə wɔ́ɔ́s ŋgɛɛ́ Betʉfazhe, *Mbʉ́ŋ wə́olivyê dɨ̂. Yésus mú lwâm *ómpwíín óbá. ");
INSERT INTO mcp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nyə nə bwo nə́: «Kəgá na də́nd á shwóg nɨɨ́d. Í é bə, bɨ́ ká nə́mə́ jé, bɨ kwey cwɔ̧ jakáás cɛ̧ɛ̧lá, í njúl nə́ tɔɔ muud kú fwo bwɛlɛ kəwa nyə kwoŋʉd. Bɨ́ ɔ́ ciny gwo, zə mə nə gwo. ");
INSERT INTO mcp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ŋkí muud mə jí bɨ́ nə́ nəcé jɨ́ bɨ́ ŋgə́ ciny gwo yí, bɨ́ bɛ̧sa nə nyə nə́: “Cwámba wə́ ŋgə́ jɨɨ gwo.” Muud wɔɔŋgʉ́ nyə é lɛɛl nə́mə́ bɨ́d nə́ bɨ zə́g nə gwo.» ");
INSERT INTO mcp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ompwíín bwə́ mú kə, bwə́ mú kə kwey cwɔ̧ jakáás cɛ̧ɛ̧lá kúnə́-kúnə nə wúl mpumbɛ́, njwóŋ dɨ́ koogʉ́. Bwə́ mú ciny gwo. ");
INSERT INTO mcp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bɔ́ɔ́lʉ́gá búúd bwə́ á bə cínɔŋg wá, bwə́ mú jí bwo nə́: «Jɨ́ bɨ́ ŋgə́ sá nɨ? Bɨ́ mə́ ciny cwɔ̧ jakáás nɨ nəcé jɨ?» ");
INSERT INTO mcp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bwə́ músə bɛ̧sa mbií Yésus nyə ámə jaaw bwo yí. Buud bɔɔŋg bwə́ mú bɨ́d nə́ bwə́ kə́g nə ndɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bwə́ mú zə Yésus nə cwɔ̧ jakáás, bwə́ ŋgə yîl mikáándə́ myáŋ ŋgə jɛɛl gwo kwoŋʉd. Yésus músə ji gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ncúlyá buud bwə́ mú ŋgə taalə mikáándə́ myáŋ zhɨ́ɨ́ nə zhɨɨ́, bɔ́ɔ́l bwə́ ŋgə́ búgə məmpúnzə́ mə́ ílɨ́ɨ́ mə́koogʉ́ ŋgə zə taalə zhɨ́ɨ́d. ");
INSERT INTO mcp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Shwɨ́ɨ́nzhá buud bwə́ á ŋgə kə Yésus shwóg wá nə bɔɔŋg bwə́ á ŋgə bɛ̧ mpʉ́sə́ wá bwə́ á ŋgə wá ŋgwa nə́: «Hosána! Gúmə́ í bə́g nə nyɔɔŋg ŋgə́ zə jínə́ mə́ Cwámba dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gúmə́ í bə́g nə ijwûga í ŋgə́ zə yí, ijwûga i Dâ *Dávid! Hosána joŋ lʉ gwɔ́w dɨ́ cwû!» ");
INSERT INTO mcp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ja Yésus nyə á kumə Yurʉ́səlɛm yí, nyə á kə nyíi *Luŋ mə́ Zɛmbî, a músə kənd mísh Luŋ dɛ̂shʉd. Nda í á bə mpwó-kugʉ́ shí nə́, a mú cúwo tɔ́ɔ́n, nyiŋgə kə nə ompwíín bɛ́ wûm nə óbá Betanî. ");
INSERT INTO mcp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mán mələ̂m, bwə́ mú wú Betanî. Yésus mú ka gwág zha. ");
INSERT INTO mcp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A mú dʉ́g shug lʉ́ *figyê shwóg-shwóg í njúl nə́ ŋkudə́. A mú kə dʉ́g nə́ ka nyə é kwey mpumə́ cínɔŋg. Njɨ, ja á mə́ kə wɔ́ɔ́s lɨ́ɨ́ dɨ́ shí yí, a mú kwey njɨ ikáá nə ikáá, nəcé í a shígɛ́ fwo bə baan lʉ mpúmə́. ");
INSERT INTO mcp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A músə cɨ nə figyê nə́: «Muud nyə abʉ́lɛ́ ná bá bwɛlɛ də tɔɔ bumə́ gwô.» Nyə́ á ŋgə lás ntɔ́, *ompwíín bɛ́ bwə́ ŋgə́ gwág. ");
INSERT INTO mcp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bwə́ mú nyiŋgə jé Yurʉ́səlɛm. Nə́ ndɛɛ́, Yésus mú kə nyíi *Luŋ mə́ Zɛmbî, a mú kə wɨ́ɨ́ŋg búúd bwə́ á ŋgə sá mikus cínɔŋg wá. A shîn lwág ítʉ́wʉli í búúd bwə́ á ŋgə́ sá icɛ́nd í *mwaanɛ̂ wá, nə ishíya í bɔɔŋg bwə́ á ŋgə kusha məfaf wá. ");
INSERT INTO mcp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A ban nə́ muud kú ná lɨ́ɨ́na nə mbag Luŋ mə́ Zɛmbî dɨ́ cwû. ");
INSERT INTO mcp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A mú ka zə yə bwo njɨ́ɨ́gʉ́lá, nyə nə́: Ŋgaá jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: «Bwə́ bá dʉ jɔ̂w njɔ́w wâm nə́: “njɔ́w mə́jəgʉla á ikûl nə ilwoŋ byɛ̂sh?” Ká bɨ́ bâŋ mə́ yida sá nə́ í bə́g daagɛ lʉ́ íjúwâl.» ");
INSERT INTO mcp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú gwág sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂. Bwə́ mú ŋgə sɔ̧́ məzhɨɨ́ nə́ bwə́ gwú Yésus, njɨ bwə́ á ka ŋgə fúndə nəcé njɨ́ɨ́gʉ́lá yé á ŋgə bul nyíi buud mílámʉ́d, buud ŋgə bul káam. ");
INSERT INTO mcp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mpwó-kugʉ́ shí, Yésus bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ músə wú ŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mán mələ̂m, bwə́ mú nyiŋgə kə ŋgwə́la, bwə́ mú dʉ́g lɨ́ɨ́ *figyê, í mə́ shîn shwáás kə jé míkɔ̧ɔ̧lə́d. ");
INSERT INTO mcp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pyɛ̂r mú zə tə́dʉga sâ Yésus nyə ámə sâ yí, a mú cɨ nə Yésus nə́: «*Rabi! dʉgɨ́! Figyê wó ámə shwó yɛ́ mə́ shwáás.» ");
INSERT INTO mcp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yésus mú ntâg cɨ nə bwo nə́: «Búgʉ́lágá Zɛmbî! ");
INSERT INTO mcp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ŋkí muud mə́ cɨ nə mbʉ́ŋ ga nə́: “Tʉ́wʉ́g na, wo kə́g juwa mâŋ”, a ká bə nə lâm búgə́, kú ŋgə sá mə́shwán, í bə́lɛ sɨ̂y nda nyə ámə cɨ nə́. ");
INSERT INTO mcp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gwə́ wə́ mə́ jááw bɨ́ nə́, sâ jɛ̂sh bɨ́ mə́ bá gwáámb mə́jəgʉla dɨ́ yí, bə́gá nə búgə́ nə́ bɨ mə́ bii, bɨ́ dʉ́g í bə́ nə́mə́ nda bɨ́ ámə gwáámb nə́. ");
INSERT INTO mcp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ja bɨ́ tə́l tʉ́təlí ŋgə sá məjəgʉla yí, ŋkí muud mə́ tə́dʉ́gá íwushí ŋgwɔ́l múúd nyə á wush nə nyə yí, a júúg muud wɔɔŋgʉ̂. Ságá ntɔ́, Sɔ́ɔ́ŋgʉ́ wʉ́n jísə́ gwɔ́w yɛ́ júúg nə́mə́ bɨ́ nə iwushí bín.» ");
INSERT INTO mcp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Njɨ, ŋkí bɨ mə bə́ kú dʉ juu bɔ́ɔ́l búúd ɨɨ́, Sɔ́ɔ́ŋgʉ́ wʉ́n jísə́ gwɔ́w yɛ́ kú nə́mə́ dʉ juu bɨ́ nə məbɔ̂w bɨ́ mə́ dʉ sá má. ");
INSERT INTO mcp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bwə́ mú zə jé Yurʉ́səlɛm. Yésus mú kə ŋgə kyey *Luŋ mə́ Zɛmbî dɨ́ cwû nə́ ndɛɛ́, milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə ocúmbá buud bwə́ mú kə nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bwə́ mú jí nyə nə́: «Nyáyɛ́ ŋkul wó ŋgə́ sá ísâ ínɨ nə ndɨ́ yí? Zə́ nyə ámə yə wo ŋkul nə́ wo zə́g ŋgə sá byo?» ");
INSERT INTO mcp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A músə bɛ̧sa nə bwo nə́: «Mə zə́ nə́mə́ fwo jí bɨ́ njígá. Bɨ́ mə́ ká bɛ̧sa, mə mú jaaw bɨ́ ŋkul mə́ ŋgə́ sá misɔ́ɔ́lʉ́gʉ́ míga nə ndɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nduwán Yuánɛs nyə á ŋgə duu buud yí, í á bə nə nyáyɛ́ ŋkûl? Ye ŋkul á gwɔ́w wə́ Zɛmbî, ye ŋkul á buud? Bɛ̧sagá mə.» ");
INSERT INTO mcp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bwə́ mú tə́dʉga nə́: «Ŋkí sə́ mə́ cɨ nə́ “gwɔ́w”, nyə e jí sə́ nə́: “Ká nəcé jɨ́ bɨ́ a shígɛ́ *búgʉla nyə yí?” ");
INSERT INTO mcp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sə́ mə́ ká mɛɛl cɨ nə́ í á bə ŋkul á buud ɨɨ́, ŋkwɛ́ɛ sə̂! Buud bɛ̂sh bwə́ ŋgə magʉlə nə́ Yuánɛs nyə á bə *muud micúndə́.» ");
INSERT INTO mcp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bwə́ mú bɛ̧sa nə Yésus nə́: «Sə́ ampúyɛ́.» Yésus mú cɨ nə bwo nə́: «Mə ajááwɛ́ nə́mə́ bɨ́ ŋkul mə́ ŋgə́ sá misɔ́ɔ́lʉ́gʉ́ míga nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nyə á ka zə kənd milúlúú myâ ofada nə *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ nə ocúmbá buud ɔ́nɨ kanda. Nyə nə bwo nə́: «Ŋgwɔ́l múúd nyə a sá fambə́ *vînyə, wá gwo luŋgʉla dɨ̂. A fáág bɨ́ɨ́ dʉ́lə bá nyáam mpúmə́, a lwɔ̧́ cwámbə́ ísándə́lé, a mú yə búúd fambə́ jɔɔŋg mə́céd. A músə kə njɔɔndʉd. ");
INSERT INTO mcp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Fwála lʉ́ mə́mwáágʉlə dɨ́, nyə á kənd ŋgwɔ́l sɔ́ɔl məsáal yé nə́ a kə́g ŋwa nyə dɛ́ kɔw lʉ mpúmə́ búúd bwə́ á lʉ́g nə fambə́ wá dɨ́. ");
INSERT INTO mcp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Njɨ buud bɔɔŋgʉ́, bwə́ mú yida bii sɔ́ɔl mə́sáal wɔɔŋgʉ̂, daŋgʉlə nə́ ndɛɛ́ nyiŋg nyə məbwə̂ məbwə̂. ");
INSERT INTO mcp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Muud fambə́ mú nyiŋgə kənd ŋgwɔ́l sɔ́ɔl mə́sáal yé. Bwə́ mú wá nyə fə́ŋ lúúd, sɛ́ɛ́mbʉli nə́mə́ nyə nə məlwíy. ");
INSERT INTO mcp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Muud fambə́ nyə á nyiŋgə kənd muud shús. Bwə́ mú kə gwú nyâŋ. Nyə mú nyiŋgə kənd bɔ́ɔ́l ŋkí bulya, bwə́ mú nə́mə́ sá bwo nda bɔɔŋg wə́ ashúshwóógʉ̂: bwə́ cú bʉ́ga, bwə́ gwú bʉ́ga. ");
INSERT INTO mcp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Muud fambə́ nyə á ka bə nə mwân yé nyə á dʉ bul dʉ cɛɛl yɛ́. A mú ka zə jə́na kənd mwân yé wɔɔŋg búúd bɔɔŋg dɨ́, nyə ŋgə́ tə́dʉga nə́ gúl ja, buud ɔ́nɨ bwə́ é gwɔ̧́ɔ̧ nyə nə́ mwán yé. ");
INSERT INTO mcp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ká, ja búúd bwə́ á lʉ́g nə fambə́ wá bwə́ á dʉ́g mwân ɛ́nɛ yí, bwə́ á ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: “Dʉgá! Muud mə bá lʉ́g nə lʉ́gí ɔ́nɨ. Shé gwúgá nyə, shé bâg lʉ́g nə lʉ́gí jé.” ");
INSERT INTO mcp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bwə́ mú zə bií nyə, gwú nyə nə́ ndɛɛ́ wusə ncâ fambə́.» ");
INSERT INTO mcp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yésus mú jí milúlúú myâ ofada nə Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ nə ocúmbá buud ɔ́nɨ nə́: «Nda bɨ̂, bɨ́ mə́ dʉ́g nə́ muud fambə́ mə bá zə sá jɨ́? Mɛɛ mə dʉ́g nə́ a bá zə, zə gwú búúd bwə́ á lʉ́g nə fambə́ wá, a mú yə búúd óshús fambə́ jé. ");
INSERT INTO mcp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bɨ afwóyɛ́ bwɛlɛ lɔ̧́ mícilyá mí Kálaad Zɛmbî dɨ́ nə́: Kwóógʉ́ ólwɔ̧́ye bwə́ á myaas yí, dwó wə́ í mə́ bə kwóógʉ́ lʉ́ lʉ́mʉga. ");
INSERT INTO mcp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cwámba sɔ́ɔ́lʉ́gʉ́ yé wə́ nɨ. Jísə *sâ mímbʉ́gú sə́dɨ́ míshʉ́d ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Milúlúú myâ ofada bə́nɔ̂ŋ *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ nə ocúmbá buud ɔ́nɨ bwə́ mú tɛ́ɛ́d ŋgə́lə sɔ̧́ məzhɨɨ́ nə́ bwə́ bií nyə, nəcé bwə́ á mpu nə́ lə́sʉ́ wáŋ wə́ Yésus nyə á ŋgə lás kandad nɨ. Njɨ, nda bwə́ á ŋgə fúndə məŋkúmbə mə búúd nə́, bwə́ mú béégya nə nyə, bwə́ mú kyey. ");
INSERT INTO mcp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bwə́ mú ka ŋwa bɔ́ɔ́l *Ofarizyɛ̂ŋ nə bɔ́ɔ́l búúd wâ gwooŋg í á dʉ ságʉsə ijwûga í Herod yí, bwə́ mú kənd bwo nyə́dɨ́ nə́ bwə́ kə́g bwɔ́wʉlə nyə, nə́ ka nyə́ é biil nə iciyá byé. ");
INSERT INTO mcp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ja bwə́ mə́ jé nyə́dɨ́ yí, bwə́ mə́ cɨ nə nɛ́ nə́: «Yɨ́ɨ́gʉli! Sə́ ŋgə mpu nə́ wo jɨ bʉ́bə́lɛ́ muud. Wo ádɛ́ bɛɛmb sâ bɔ́ɔ́l búúd bwə́ é cɨ yí, wo kú nə́mə́ bə nə ifwaas nə mbií múúd wɨ́ nə ŋkul tɔ̂w wo míshʉ́d yí. Wo ŋgə jɨ́ɨ́gʉli sə́ cʉg á Zɛmbî bʉ́bə́lɛ́. Ntɔ́, jaawʉg sə̂. Ye məcɛ̧ɛ̧ mə́shé mə́ ŋgə magʉlə nə́ sə́ jə́nág tóya mə *Káázɛl, ye mə́ aŋgɛ̂ nə magʉlə? Ye sə́ dʉ́g jə́na, ye sə́ nda dʉ jə́na?» ");
INSERT INTO mcp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ká, nyə á bwey mpu kwába jáŋ jɔɔŋg, a mú cɨ nə bwo nə́: «Bɨ mə zə́ bwɔ́wʉlə mə nəcé jɨ? Zəgá ná mə nə saŋ *danarî, mə dʉ́gʉ́g.» ");
INSERT INTO mcp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bwə́ mú zə nyə nə wo. A mú jí bwo nə́: «Zə́ jɨ́ nə vʉgʉli mpwoombʉ́ nə jínə́ bwə́ á lúlə wa ga?» Bwə́ nə nɛ́ nə́: «Jísə Káázɛl.» ");
INSERT INTO mcp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A mú ka cɨ nə bwo nə́: «Yə́gá Káázɛl isâ í Káázɛl, bɨ́ yə Zɛmbî isâ í Zɛmbî.» Bwə́ mú bul káam mpɛ̧sá nyɛ́ nyɔɔŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Osadwisyɛ̂ŋ, buud bwə́ dʉ cɨ nə́ mimbimbə mí ábʉ́lɛ gwûm mə́shwoŋ dɨ́ wá, bwə́ á ka zə wə́ Yésus, zə jí nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Yɨ́ɨ́gʉli! Moyîz nyə á yə sə́ cɛ̧ɛ̧ nə́: “Ŋkí muud mə yə́ kundú, mínyɔŋʉ̂ yé mə́ jəlá nə shúgʉla nə kúsə́ yé, a byág nyɔɔŋg mə́ yə yɛ́ mpwoŋ buud.” ");
INSERT INTO mcp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bɔ́ɔ́l ómínyɔŋʉ̂ bwə́ á byɛ̂l wa zaŋgbá, budûm nə budûm. Acúmbá mú bâ múdá, a mú yə kú nə mwân. ");
INSERT INTO mcp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nyɔɔŋg nyə á bɛ̧ nə nyə yɛ́, mú bâ kúsə́ acúmbá nyə á lʉ́gə yí, a mú nə́mə́ yə kú nə mwân. Mbií ŋgwúd nə álɛ́ɛl, ");
INSERT INTO mcp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","nə bɔ́ɔ́l óntombú bɛ́ bɛ̂sh, kə jé mwân á məzhúgʉ́lâ. Bɛ̂sh, bwə́ á bâ mudá ŋgwúd wɔɔŋgʉ̂, bɛ̂sh shîn yə, bwə́ kú lʉ́gə mwân. Mpʉ́sə wáŋ, mudá wɔɔŋg mú nə́mə́ zə yə. ");
INSERT INTO mcp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ja búúd bwə́ bá gwûm yí, nyáyɛ́ mə bá ŋwa mudá? Ŋgaá nə́ bɛ̂sh bwə́ á shí bə ógwúm bɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yésus mú bɛ̧sa nə bwo nə́: «Ŋgaá bɨ mə́ kwab, nəcé bɨ́ ampúyɛ́ sâ Kálaad Zɛmbî ŋgə́ cɨ yí, bɨ kú nə́mə́ mpu mpífə́ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ja búúd bwə́ bá gwûm mə́shwoŋ dɨ́ yí, budúm bwə́ ábʉ́lɛ́ ná bâ búdá, budá nda ná kə mə́báád. Bwə́ bá ji nda *wəéŋgəles ɔ́ Zɛmbî bwə́ njúl joŋ dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kɔ́ɔ́mb á mimbimbə bálə gwûm mə́shwoŋ dɨ́, ŋgaá nə́ Kálaad məcɛ̧ɛ̧ mə́ Moyîz dɨ̂, bɨ mə́ dʉ lɔ̧́ kʉ́l í ŋgə́ lwágʉlə nda nyə á kwey ŋgwiilɛ ŋkaŋ dɨ́ yí. Ŋgaá Zɛmbî nyə á cɨ nə nyə nə́: “Mə jɨ Zɛmbî mə́ *Abʉraham, Zɛmbî mə́ *Izaag, Zɛmbî mə́ *Yákwab.” ");
INSERT INTO mcp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ntɔ́ jɨ nə́ Zɛmbî cugɛ́ Zɛmbî mimbimbə, a jɨ yidá bə Zɛmbî á buud bwə́ ŋgə́ cʉgə wá. Bɨ́ ŋgə jág bul kwab.» ");
INSERT INTO mcp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋgwɔ́l Yɨ́ɨ́gʉli məcɛ̧ɛ̧ nyə á ŋgə gwág nda bwə́ á ŋgə jí nyə minjígá nə́. Nda nyə á dʉ́g nə́ Yésus ŋgə mpu bɛ̧sa nə́, a mú zə jí nyə nə́: «Mə́cɛ̧ɛ̧ míshé mɛ̂sh dɨ́, dáyɛ́ í tə́l mɔ́ɔ́l mɛ̂sh shwóg?» ");
INSERT INTO mcp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yésus mú bɛ̧sa nə nyə nə́: «Cɛ̧ɛ̧ í tə́l mɔ́ɔ́l mɛ̂sh shwóg yí, dɨ́ nə́: Gwágʉ́lə́g, Izʉrəyɛ̂l! Zɛmbî wúsʉ́, Cwámba, jísə́ Zɛmbî njɨ nyəmɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wó jəlá nə cɛɛl Zɛmbî wô Cwámba nə lâm wô wɛ̂sh, nə *shíshim wô wɛ̂sh, nə lúú wô wɛ̂sh, nə ŋkul nywô nyɛ̂sh!» ");
INSERT INTO mcp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yésus mú nyiŋgə cɨ nə́: «Cɛ̧ɛ̧ ábɛɛ̂ dʉ́sə nə́: Wo cɛɛl múúd yɛ̂sh jísə́ wo kúnə́-kúnə yɛ́ nda womɛ́fwó. Kú nə tɔɔ cɛ̧ɛ̧ í ntɔ̧́ mə́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yɨ́ɨ́gʉli məcɛ̧ɛ̧ ntâg nə nyə nə́: «Haaw! Wo mə́ mpu lás! Sâ wó ŋgə́ cɨ yí, jísə tʉ́təlî. Zɛmbî jísə njɨ ŋgwúd, kú nə ŋgwɔ́lʉ́gá shús mpʉ́sə nyə. ");
INSERT INTO mcp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Muud mə́ jəlá nə wá lâm yé wɛ̂sh wə́ Zɛmbî, a cɛɛl nyə nə fʉg nyɛ́ nyɛ̂sh, nə ŋkul nyɛ́ nyɛ̂sh. A jəlá nə cɛɛl nə́mə́ muud jɨ́ nyə kúnə́-kúnə yɛ́ nda nyəmɛ́fwó. Ntɔ́ wə́ jísə́ mpwogɛ́, cɔ̧́ jígálʉ́lə Zɛmbî ocúdú nə sálə nyə mɔ́ɔ́l *mə́túnʉga mɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nda Yésus nyə á dʉ́g nə́ nyə á mpu bɛ̧sa nə nyə nə́, a mú cɨ nə nyə nə́: «Í abʉ́lɛ́ ná gwaa nə wo nə́, wo nyííg Faan mə́ Zɛmbî dɨ̂.» Nə́ ndɛɛ́, tɔɔ muud nyə a shígɛ́ ná nyiŋgə jí Yésus njígá. ");
INSERT INTO mcp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ntɔ́, nda Yésus nyə á ŋgə jɨ́ɨ́gʉli buud *Luŋ mə́ Zɛmbî dɨ́ nə́, nyə a jí bwo nə́: «Wáyɛ́ mbií *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bɨ́ nə ŋkul cɨ nə́ *Krîst jɨ Mwân mə́ *Dávid yí? ");
INSERT INTO mcp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ŋgaá *Dávid, nyəmɛ́fwó, nə ŋkul mə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim, mə́ cɨ nə́: Cwámba nyə á cɨ nə Cwámba wâm nə́: “Jig shí wa mə́dɨ́ mbwə̂ məncwûm, kə wɔ́ɔ́s ja mə é culʉshi mízhízhíŋ myô, wo nyaál myo nə məkuú yí!” ");
INSERT INTO mcp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dávid nyəmɛ́fwó nyə á jɔ̂w *Krîst nə́ Cwámba. Ká nyə é ka bə Dávid mwân na ntʉdɛlɛ?» Buud bwə́ á bə áncuncuma wá bwə́ á bul gwág məshusʉg nə lə́sʉ́ yé. ");
INSERT INTO mcp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nə́ ndɛɛ́, a mú kə shwóg nə jɨ́ɨ́gʉ́lílə búúd. Nyə nə bwo nə́: «Bɨ ɔ káálʉ́gə́ nə Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧! Bwə́ cɛɛl dʉ́lə mɛ̧ɛ̧la nə ŋwɔ̧ɔ̧la ŋwɔ̧ɔ̧la íjud, nə dʉ́lə sɔ̧́ nə́ buud bwə́ dʉ́g bə́da bwo məbə́dá mə́ gúmə́ mə́ŋkúmbə mə búúd dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bwə́ cɛɛl nə́mə́ kə dʉ ji njɨ íjiya yâ shwóg ja bʉ́sə́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ́ yí; bwə́ cɛɛl nə́mə́ dʉ kə ji njɨ lúú tʉ́wʉli dɨ́ ja bwə́ dʉ́ kə ídína dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bwə́ dɛ́ɛ́g míkúsə́ mí búdá isâ byáŋ byɛ̂sh. Bwə́ nyiŋgə dʉ sá ígwaa-gwaa í mə́jəgʉla, lwóyálə nə́ bʉ́sə ijɔ̧ɔ̧́ í búúd. Intʉ́gʉ́lí byáŋ í bá bə ŋkí jág bul nyaan.» ");
INSERT INTO mcp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yésus nyə á ka kə ji nə́ bɛɛndyá nə jaadə́ mə́yə́na mâ *Mpáánzə́ Zɛmbî, a ka ŋgə dʉ́g nda búúd bwə́ á ŋgə wá məyə́na nə́. Ofwó búúd bwə́ á ŋgə wá ŋkí bulya. ");
INSERT INTO mcp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Njɨ wúl mbúmbúwá kúsə́ múdá, í á zə wá isʉsáŋ íbá, tâŋ á bʉ́baalɛ́ ifáda. ");
INSERT INTO mcp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yésus mú jɔ̂w *ompwíín bɛ́, nyə nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, mbúmbúwá kúsə́ múdá nɨ mə́ wá mə́yə́na cɔ̧́ buud bɛ̂sh bwə́ ámə ŋgə wá wá. ");
INSERT INTO mcp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nəcé buud bɛ̂sh bwə́ ámə ŋgə wá ɔ́nɨ, bwə́ ámə ŋgə ŋwa mə́mpugə mâ byɔɔg dáŋʉ́d. Ká nyɛ, a njúl mbúmbúwá, nyə ámə wá bímbí dɛ̂sh nyə́ ámə bə nə ndɨ́ yí, bímbí dɛ̂sh í ámə bə nə́ nyə é ŋgə cʉgə nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nda Yésus nyə á ŋgə cúwo wú *Luŋ mə́ Zɛmbî nə́, ŋgwɔ́l *mpwíín yé mú cɨ nə nɛ́ nə́: «Yɨ́ɨ́gʉli, fwog dʉ́g jɔ̧jɔ̧ mə́kwóógʉ́ mə́nɨ, nə məma lwɔ̧́yá nɨ!» ");
INSERT INTO mcp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yésus nyə á ka bɛ̧sa nə nɛ́ nə́: «Nə jɔ̧jɔ̧ mə́kwóógʉ́ nə məma lwɔ̧́yá wó dʉ́g nɨ, tɔ́ɔ kwóógʉ́ ŋgwúd í ábʉ́lɛ́ nyiŋgə lʉ́g í mbə́d na dúlʉ́gá dɨ́ gwɔ̂w, mɛ̂sh mə́ bá shugʉla shí.» ");
INSERT INTO mcp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yésus mú ka kə *Mbʉ́ŋ wə́olivyê dɨ́, kə ji shí, ŋgə́ dʉ́g kɔ́ɔ́mb Luŋ mə́ Zɛmbî. Pyɛ̂r, Zhâk, Yuánɛs nə Andrê, bə́nɔ̂ŋ bwə́ á bə bwə́mɛ́fwó wá, bwə́ mú cɨ nə nyə nə́ ");
INSERT INTO mcp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Jaawʉg sə̂, isâ ínɨ í bá bə jáyɛ́ ja? Jɨ́ í bá ka lwágʉlə sə́ nə́ isâ byɔɔŋg í wál bá ŋgə zə bwəma yí.» ");
INSERT INTO mcp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yésus mú ka cɨ nə bwo nə́: «Bɨ ɔ́ bɛy nə́ buud bwə́ bâg shɨɨg bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nəcé buud ŋkí bulya bwə́ bá dʉ zə nə jínə́ dâm; nyâŋ wɔ́ɔ́s, nyə nə́: “Mə wə́ *Krîst”. Bwə́ bá kənd zhwog buud jugʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bɨ mə bá dʉ gwág míláŋ mí mɔ́ɔmb, bɨ gwádʉga ncíndə́ dɔɔmb, bɨ́ kú bá dʉ kənd mílám gwɔ̂w; í bá jɨɨ nə́ isâ ínɨ í bə́g. Njɨ tɛɛm bə ntɔ́, í ábʉ́lɛ́ fwo bə mə́shíné mə́ shí. ");
INSERT INTO mcp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gúl lwoŋ í bá lúmbʉli nə gúl, dúl faan lúmbʉli nə dúl. Shí í bá nə́mə́ dʉ ntaŋʉsa bíl íkʉ́lʉ́d, zha á ifií mpu í bá bə. Isâ ínɨ byɛ̂sh í bá ná bə njɨ mətɛ́ɛ́dʉ́lé mə́ mə́cɛy mə byɛ́yí. ");
INSERT INTO mcp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Bɨ ɔ́ dʉ bɛy. Bwə́ bá dʉ kusha nə bɨ́ mə́bwə́ mə́ osémbye ɔ́ mílə́sʉ́d, bwə́ dʉ fyámʉsə bɨ́ milwóŋ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ̂. Bɨ mə bá dʉ kaad mísh mə́ búúd ɔ́ anʉ́nɨ̂ nə ojwû ɔ́ lɔɔm dɨ́ nə́, bɨ kə́g bwaagʉlə sâ bɨ́ mə́ mpú shú jínə́ dâm yí. ");
INSERT INTO mcp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Í fwo tɛ́ɛ́d jɨɨ nə́ bwə́ cúndə́g Jɔ̧jɔ̧ Kɛ́ɛ́l ikûl nə ilwoŋ byɛ̂sh dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ja bwə́ bá dʉ kusha nə bɨ́ yí, bɨ kú bá dʉ bwey yágʉwo íciyá í kɔɔd. Bɨ ɔ bá dʉ lás sâ í é bá dʉ jé bɨ́ cé jɔɔŋgʉ́d nə́ bɨ́ lásʉ́g yí; nəcé bɨ dɨ́ mə́ bá dʉ lás, í bá dʉ bə Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mínyɔŋʉ̂ mə́ bá kusha nə mínyɔŋʉ̂ yé nə́ bwə́ kə́g gwú nyə. Sɔ́ɔ́ŋgʉ́ mə bá kusha nə mwân; bwân bwə́ lúmbʉli nə obyɔ̂l, ŋgə gwú bwo. ");
INSERT INTO mcp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Buud bɛ̂sh bwə́ bá mpii bɨ́ nəcé jínə́ dâm. Njɨ, muud mə bá jísɔw kə wɔ́ɔ́s mə́shínéd yɛ́, a bá cʉgə.» ");
INSERT INTO mcp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ja bɨ́ mə́ bá dʉ́g ájəlʉŋkúŋkwɔ̧ mə́ kə ŋwa jiya kʉ́l í búl bə ci yí, muud ŋgə́ lɔ̧́ cilyá ga yɛ́, kə́ mpú gwág! Ja bɨ́ mə́ bá dʉ́g ísâ byɔɔŋg yí, buud bwə́ bá bə Yudéa wá, bwə́ bâg fúndə, kə mímbʉ́mbʉ́ŋʉ́d! ");
INSERT INTO mcp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Muud mə bá bə kwáminʉ́ yɛ́ kú bá shulə nə́ a kə́ njɔ́w kə ŋwa sâ. ");
INSERT INTO mcp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nyɔɔŋg mə bá bə fambə́ yɛ́, kú ná kwo kə kwáádə́ nə́ a kə́ ŋwa kúúd. ");
INSERT INTO mcp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋkwɛ́ɛ budá bwə́ bá bə nə məbum, nə bɔɔŋg bwə́ bá ŋgə nyɛ́ɛ́ŋg bwân mwɔ̂w mɔɔŋg dɨ́ wá! Bwə́ bá bul ŋkúŋkwoŋ. ");
INSERT INTO mcp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jəgʉlagá nə Zɛmbî nə́ isâ ínɨ í kú bá wɔ́ɔ́s bɨ́ ŋkwánʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nəcé *incwaw í ntʉg í bá bə mwɔ̂w mɔɔŋg dɨ́ mbií í abwɛ́lɛ́ bə té Zɛmbî nyə á tɛ́ gwɔ̂w nə shí yí. Bíl í ábʉ́lɛ́ kwo bə mbií wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Í á mbə̂m bə Cwámba kú cunal mwɔ̂w mə́ incwaw í ntʉg mɔɔŋgʉ̂, tɔɔ muud kú faam. Njɨ, a bá cunal mwɔ̂w mɔɔŋgʉ̂ shú buud nyə á fɛ́ɛ́sh nə́ bwə́ bə́g bɛ́ wá. ");
INSERT INTO mcp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ntɔ́, ŋkí ŋgwɔ́l múúd mə́ cɨ nə bɨ́ nə́: “Dʉgá! Mesî jɨ wa”, ŋkí nə́: “a jisə wá”, kúgá *magʉlə. ");
INSERT INTO mcp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Omesî ɔ́ mə́shɨɨgâ nə *buud ɔ mícúndə́ wâ məshɨɨgâ bwə́ bá dʉ wɔ́ɔ́s. Bwə́ bá dʉ sá *mə́shimbá nə *isâ í ntɔ̧́ búúd ŋkwóŋ yí mbií wúsə́ nə́ ŋkí gúl sâ jɨ́ nə ŋkul bə ntɔ́, buud Zɛmbî mə́ bwey fɛ́ɛ́sh wá bwə́ bɛ̧ bɔ́w-bɔ̂w zhɨ́ɨ́. ");
INSERT INTO mcp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bɨ ɔ́ bɛy! Mə mə́ bwey jaaw bɨ́ isâ byɛ̂sh wə́ nɨ. ");
INSERT INTO mcp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Mə́ jaaw bɨ́ nə́ mwɔ̂w mɔɔŋgʉ̂ dɨ, mwɔ̂w mə́ incwaw í ntʉg mɔɔŋg mə́ ká nə́mə́ shîn cɔ̧̂, jwɔ́w í bá shila nə́ ŋkwed kú ná kwo faan; ŋkwoond kú ná wééshʉli mə́ŋkɛnya; ");
INSERT INTO mcp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wəacén-cénî bwə́ bá dʉ bí shí; isâ byɛ̂sh bísə́ nə mpífə́ joŋ dɨ́ yí í bá kúŋgʉla. ");
INSERT INTO mcp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja jɔɔŋgʉ̂, bwə́ bá ka dʉ́g *Mwân mə Múúd ŋgə́ cúwo joŋʉd, a zág nə mpífə́ nə milwanə́. ");
INSERT INTO mcp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A bá ntɨ *wə́éŋgəles bɛ́ bwə́ zə sɛɛŋg búúd Zɛmbî nyə á fɛ́ɛ́sh wá ikɔ́ɔ́mb ínɔ̧́ byɛ̂sh, tɛ́ɛ́d bíl íjumə í shíd kə wɔ́ɔ́s bílʉ́gád.» ");
INSERT INTO mcp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ŋwagá fʉg nə yuug bɨ́ mə́ dʉ dʉ́g nə lɨ́ɨ́ *figyê yí. Í dʉ bə, ja mpúnzə́ nyɛ́ í mú nə́ bud-bud, məncuug mə́ agúgwáan mə́ ŋgə́ kɔ̧́ yí, bɨ́ mú mpu nə́ ompú bwə́ mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ntɔ́ nə́mə́, ja bɨ́ mə́ bá dʉ́g ísâ byɔɔŋg í ŋgə́ sɨ̂y yí, mpugá nə́ zɨ́yé mə́ *Mwân mə Múúd í mú kúnə́-kúnə, í mú cé mə́yíndə mə nyâ. ");
INSERT INTO mcp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kala búúd ga í ábʉ́lɛ́ cɔ̧́ isâ ínɨ byɛ̂sh kú fwo sɨ̂y. ");
INSERT INTO mcp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gwɔ́w nə shí í bá cɔ̧́, njɨ iciyá byâm kú cɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Shú sâ í dʉ́gyá nə jwɔ̂w nə wəla ísâ byɔɔŋg í bá sɨ̂y yí, kú nə muud mə mpû; tɛɛm bə *wə́éŋgəles bʉ́sə́ wə́ Zɛmbî wá bwə́ ampúyɛ́; tɛɛm bə Mwân nyə ampúyɛ́; njɨ Sɔ́ɔ́ŋgʉ́ wə́ mə́ mpû. ");
INSERT INTO mcp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bɨ́ ɔ mpú ji ŋkasə́! Nəcé bɨ ampúyɛ́ baan dɔɔŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Í bá bə nda muud mə zə́ tɨ́ nə́ a kə́ njɔɔnd dɨ́, a lʉ́gə njɔ́w búúd yé, a yə ósɔ́ɔl ɔ́ mə́sáal ŋkul ŋgə́lə sá isâ, nyə nə mbaagʉlə mbɛ̂ nə́ a jíg ŋkasə̂. ");
INSERT INTO mcp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ntɔ́, jigá ŋkasə̂! Bɨ ampúyɛ́ baan amə́dɨ́ njɔ́w mə́ bá zə yí. A jɨ nə ŋkul zə mpwó-kugʉ́, tɔɔ tâm bulú, ŋkí nə́ ŋgwúm kúwó ashúshwóógʉ́, tɔɔ mán mə́ lə̂m. ");
INSERT INTO mcp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sásʉ́lə́gá nə́ a zə́g məseegya, zə kwey bɨ́ ígwə́d. ");
INSERT INTO mcp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sâ mə́ ŋgə́ jaaw bɨ́ ga, jísə shú buud bɛ̂sh. Jigá ŋkasə́!» ");
INSERT INTO mcp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nə́ ndɛɛ́, í á lʉ́g mwɔ̂w mə́bá nə́ *Páska nə zaŋ bwə́ á dʉ də ibʉlɛ́d yâ kú nə *ləvur yí í bwə́mag. Milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á ŋgə sɔ̧́ məzhɨɨ́ nə́ bwə́ bii Yésus mə́kə́ŋʉ́d, bwə́ gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nəcé bwə́ á ŋgə nyímbʉla nə́: «Shé ajə́láyɛ́ nə bií nyə baan lʉ́ zâŋ, ŋkwaŋgá buud bwə́ á bá sá ícucu.» ");
INSERT INTO mcp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yésus nyə á ka bə Betanî Shímun á zʉ́zaamə́ dɨ́ njɔ́w. Ŋgwɔ́l múdá mbíd fúfuundú *alʉbátrə mú shísh wə́ Yésus. Fúfuundú jɔɔŋg í á bə lwándʉ́lá nə labínda álal-kus. Bwə́ dʉ sá labínda jɔɔŋgʉ̂ nə mikɔ̧ɔ̧lə́ mí nâr. Nə́ ndɛɛ́, bwə́ ŋgə́ də, mudá wɔɔŋgʉ̂ mú búgə fúfuundú lúú, shwu Yésus labínda lúúd. ");
INSERT INTO mcp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bɔ́ɔ́lʉ́gá búúd bwə́ á bə cínɔŋg wá, bwə́ mú gwág bɔ̂w, bwə́ mú ŋgə lás mpə́dʉ́gá nyáŋ nə́: «Wúga mbií yúúdʉ́gʉ́ wə́ jɨ́? ");
INSERT INTO mcp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Í mbə̂m jəla nə́ bwə́ kusha labínda nɨ odanarî mitəd milɔ́ɔl, bwə́ kwíínd mímbúmbúwá nə ndɨ̂.» Bwə́ mú bul jum múdá wɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yésus mú cɨ nə bwo nə́: «Bɨ́dʉ́gá nyə nə́ shɛɛ! Jɨ́ bɨ́ ŋgə́ lúg nyə lâm ntʉ́nɨ yí? A mə́ sá mə jɔ̧jɔ̧ sɔ́ɔ́lʉ́gʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bɨnɔ̂ŋ mímbúmbúwá bɨ́ njul jwɔ̂w dɛ̂sh, bɨ bɨ́ nə ŋkul sá bwo mənywa ja jɛ̂sh bɨ́ mə́ cɛɛl yí. Njɨ sə́nɔ̂ŋ bɨ́ sə́ ábʉ́lɛ́ ji mwɔ̂w mɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mudá ɛ́ga mə́ sá bímbí nyə ámə kwag yí. Nyə mə́ bwey gwáágʉlə mə labínda nyúúlʉ́d, shú mə́dʉlya mâm. ");
INSERT INTO mcp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kʉ́l jɛ̂sh bwə́ bá cúndə Jɔ̧jɔ̧ Kɛ́ɛl ga shí nyɛ̂sh dɨ́ yí, bwə́ bá nə́mə́ dʉ jaaw sâ múdá ɛ́ga mə́ sá mə yí, buud dʉ tə́dʉga nyə.» ");
INSERT INTO mcp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nə́ ndɛɛ́, Yúdas Iskariyôt, ŋgwɔ́l múúd á gwooŋg *ómpwíín wûm nə óbá, músə kə dʉ́gya nə milúlúú myâ ofada nə́ a kə́ kusha bwo nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nda bwə́ á gwág ntɔ́ nə́, bwə́ mú gwág nywa. Bwə́ mú kaag nə́ bwə́ é yə nyə *mwaanɛ̂. Yúdas músə zə sɔ̧́ fwámɛ́ fwála á jɨ́ nə ŋkul sá nə́ bwə́ bííg Yésus yí. ");
INSERT INTO mcp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jwɔ̂w lʉ́ *Páska *Oyúdɛn í á ka jê. Jwɔ̂w dɔɔŋgʉ́ wə́ bwə́ á dʉ cígə ncwəmbɛ Páska, í njúl nə́mə́ jwɔ̂w á shúshwóógʉ́ á zaŋ ibʉlɛ́d yâ kú nə *ləvur yí. Ntɔ́ wə́ *ompwíín ɔ́ Yésus bwə́ á zə jí nyə nə́: «Jáyɛ́ kʉ́l wó cɛ́ɛ́l nə́ sə́ kə́g kwísha wo dína Páska yí?» ");
INSERT INTO mcp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yésus mú lwâm ompwíín bɛ́ óbá, nyə nə bwo nə́: «Kəgá ŋgwə́la! Bɨ́ é bwəma nə ŋgwɔ́l múúd, a ŋgə́ ŋkɛ̂ny káágə́ məjúwó. Bɨ ɔ́ bɛ̧ nyə! ");
INSERT INTO mcp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Njɔ́w nyə́ é kə nyíi yí, bɨ́ cɨ nə amə́dɨ́ njɔ́w nə́ Yɨ́ɨ́gʉli mə́ cɨ nə́ wo lwóg sə́ kʉ́l bə́nɔ̂ŋ ompwíín bɛ́ bwə́ é də dína Páska yí. ");
INSERT INTO mcp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nyə e lwágʉlə bɨ́ fúm ánʉ́nɨ̂ njɔ́w á gwɔ́wʉ́d, í njúl kwambʉlá. Cínɔŋg wə́ bɨ́ é kwísha shé zaŋ Páska yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ompwíín bwə́ mú kə jé ŋgwə́la, kə kwey ísâ byɛ̂sh mbií nyə á jaaw bwo yí. Bwə́ mú shîn kwísha dína Páska. ");
INSERT INTO mcp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ja kugʉ́ í a bii shí yí, bə́nɔ̂ŋ *buud ɔ lwámá bɛ́ wûm nə óbá bwə́ mú jê. ");
INSERT INTO mcp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ntɔ́, bwə́ ŋgə də, Yésus mú cɨ nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ŋgwɔ́l múúd á na bɨ́dɨ́, shénɔ́ŋ ŋgə́ də wa yɛ́, nyə é kusha nə mə.» ");
INSERT INTO mcp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ompwíín bwə́ mú gwág sâ jɔɔŋgʉ̂ cɛy lámʉ́d, bwə́ mú ŋgə jí nyə ŋgwúd ŋgwúd nə́: «Ye jísə mə?» ");
INSERT INTO mcp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nyə mú bɛ̧sa nə bwo nə́: «Jísə ŋgwúd á bɨ́ buud wûm nə óbá, nyɔɔŋg sə́ná ŋgə juwo məbwə̂ shúyá ŋgwúd dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","*Mwân mə Múúd nywáá, nyə é kə nə́mə́ nda jísə́ bwey bə cilyá shú dɛ́ dɨ́ nə́. Njɨ məntágʉla nə múúd mə kɛ́ɛ́nzh nyə yɛ́; í á yida nywá bul jəla nə́ muud wɔɔŋgʉ̂ kú byɛ̂l.» ");
INSERT INTO mcp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bwə́ ŋgə́ də ntʉ́nɨ, Yésus mú ŋwa bʉlɛ́d, yə Zɛmbî cúncɛ́sh nə́ ndɛɛ́, a mú fɛ̂y bʉlɛ́d, yə ómpwíín bɛ́. Nyə nə bwo nə́: «Ŋwagá, bɨ də́g. Nyúul nyâm wə́ ga.» ");
INSERT INTO mcp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mpʉ́sə na, nyə mú ŋwa bálá wáan, yə Zɛmbî akíba, nyə mú kala bwo. Bɛ̂sh bwə́ mú ŋgul. ");
INSERT INTO mcp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nyə mú cɨ nə bwo nə́: «Məcií mâm wə́ mə́nɨ, məcií mâ sɔ̧, mə́ zə́ shwɨy shí, zə cé búúd ŋkí bulya má. ");
INSERT INTO mcp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, mə abʉ́lɛ́ ná kwo ŋgul wáan nɨ, kə wɔ́ɔ́s ja mə́ bá ŋgul ncuncúmbə Faan mə́ Zɛmbî dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bwə́ mú ka sɛy Zɛmbî isʉsa i gúmə́ nə́ ndɛɛ́ bwə́ músə kyey kə *Mbʉ́ŋ wə́olivyê dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yésus mú cɨ nə bwo nə́: «Bɨ e láŋgʉwo búgə́d nəcé mə. Sâ jɔɔŋgʉ̂ wə́ jísə́ cilyá Kálaad Zɛmbî dɨ́ yí nə́: “Mə é nyífə mbaagʉlə itɔw, incwəmbɛ í sɔɔnz í mú shîn cɨɨma.” ");
INSERT INTO mcp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Njɨ, ja mə́ bá gwûm yí, mə bá tɛ́ɛ́d kə Galilê, bɨ́ kə bá kwey mə nûŋ.» ");
INSERT INTO mcp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pyɛ̂r mú cɨ nə nɛ́ nə́: «Tɛɛm bə nə́ bɔ́ɔ́lʉ́gá bɛ̂sh bwə́ láŋgʉwo búgə́d nəcé wo, mɛɛ mə abʉ́lɛ́ bwɛlɛ láŋgʉwo.» ");
INSERT INTO mcp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ntɔ́ wə́ Yésus mú cɨ nə nɛ́ nə́: «Bʉ́bə́lɛ́, mə́ jaaw wo nə́, wo e kɨ́ɨ́lya mə ija ílɔ́ɔl búlú gaád, ŋgwúm kúwó kú fwo kwáág ja ábɛɛ̂.» ");
INSERT INTO mcp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pyɛ̂r mú nyiŋgə kə shwóg, mpu báásʉlə nə́: «Tɛɛm bə nə́ í wɔ́ɔ́s nə́ shwə́ yə́g shwɨy ŋgwúdʉ̂, mə kú bwɛlɛ kɨ́ɨ́lya wo». Bɔ́ɔ́l *ómpwíín bɛ̂sh bwə́ mú nə́mə́ ŋgə cɨ ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nə́ ndɛɛ́, Yésus bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ músə kumə kʉ́l bwə́ dʉ jɔ̂w nə́ Gɛtsemane yí. A mú cɨ nə bwo nə́: «Jigá wa shí, tɛ́ mə́ kə́ sá mə́jəgʉla yí.» ");
INSERT INTO mcp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A músə jɔ̂w Pyɛ̂r, nə Zhâk, nə Yuánɛs, bə́nɔ̂ŋ bwə́ mú kə kɔ́ɔ́mb shús. Yésus mú ŋgə bə kú ná gwádʉga lám nə́ shɛɛ, mbɔɔm í ŋgə́ shwɨy nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nyə nə bwo nə́: «Lâm wúsə mə nə məcɛy ki mə é yə. Jigá ŋkasə́ wa shí.» ");
INSERT INTO mcp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A mú ŋwá shísh shwóg, kə wusə nyúúl shí mbúmbudɨ̂. A mú jəgʉla nə Zɛmbî nə́, ŋkí jɨ́ nə ŋkul bə ntɔ́, a kə́ndʉg nyə baan lʉ́ mə́cɛy nə ifwaas nɨ shwóg-shwóg. ");
INSERT INTO mcp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nyə nə́: «Abba! Pʉpa! Sâ í ádɛ́ káád wo. Yílʉ́g mə bálá mə́cɛy ga! Tɛɛm bə ntɔ́, í kú bə nda mə́ cɛ́ɛ́l nə́, njɨ nda wó cɛ́ɛ́l nə́!» ");
INSERT INTO mcp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nyə mú wɔɔl shí, zə kwey ompwíín bɛ́ ólɔ́ɔl ígwə́d. Nyə nə Pyɛ̂r nə́: «Shímun! Wo ŋgə bə́lɛ kə gwə́d ɨɨ́? Wo cugɛ́ nə ŋkul ji ŋkasə́ tɔɔ njɨ wəla ŋgwúdʉ̂? ");
INSERT INTO mcp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jigá ŋkasə́, jəgʉla nə Zɛmbî, bɨ bə́g kú biil mə́bwə́bʉ́lánʉ́d. Lâm wúsə nə yéésh mə kyéy jɔ̧ kuú njɔɔnd; njɨ nyúul í cúgɛ́ nə ŋkul kwag kuú njɔɔnd wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A mú nyiŋgə shísh shwóg, kə nyiŋgə jəgʉla nə Zɛmbî, mbií nyə ámə fwo jəgʉla yí. ");
INSERT INTO mcp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A músə nyiŋgə́ zə ómpwíín bɛ́ dɨ́, zə nə́mə́ nyiŋgə kwey bwo ígwə́d nəcé mísh mə́ á ŋgə ntámb bwo, bwə́ kú ná mpu sâ bwə́ bɨ́ nə ŋkul jaaw nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ja álɛ́ɛl nyə á nyiŋgə zə yí, nyə á cɨ nə bwo nə́: «Ja gaád, mpugá kə gwə́d, bɨ́ woga! Í mə́ shîn. Baan í mə́ jê. Bwə́ zə́ kɛɛnzh *Mwân mə Múúd məbwə̂ mə́ ósɔ́ɔl ɔ́ mə́bɔ̂w dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tɔ́wʉ́gá, sə́ kyéyʉg. Muud mə́ kusha nə mə ɔ́ zág yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yésus ŋgə́ ná lás ntʉ́nɨ, seegya nə́, Yúdas nyə á bə nə́mə́ gwooŋg *ómpwíín wûm nə óbá dɨ́ yɛ́ mú cúwo, a ŋgə́ zə nə məma kínda búúd, bwó nə ikafwɛlɛ nə məbʉ́lə. Milúlúú myâ ofada, nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧, nə ocúmbá buud wâ lɔɔm wə́ bwə́ á ntɨ bwo. ");
INSERT INTO mcp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yúdas, muud nyə á kusha nə nyə yɛ́, nyə a bwey kwambʉlə nə buud ɔ́nɨ nə́: «Muud mə́ é kə fʉ́lal, sə́ sɔ̧nya mímpu yɛ́, nyə wə́ ɛ́nɛ, bɨ ɔ́ bií nyə, bɨ ɔ kə́ nə́ nyə kú wúya.» ");
INSERT INTO mcp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nə́mə́ njɨ Yúdas nyə á cúwo yí, nyə a cɔ̧́ kə njɨ wə́ Yésus, nyə nə nɛ́ nə́: «*Rabi!» A mú fʉ́lal nyə. ");
INSERT INTO mcp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Buud ɔ́nɨ bwə́ mú ntâg kɔ̧ Yésus, bwə́ mú bií nyə. ");
INSERT INTO mcp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Njɨ, ŋgwɔ́l múúd gwooŋg mə Yésus mə́ wéem kafwɛlɛ jé, taad ŋgwɔ́l sɔ́ɔl məsáal mə Ajəlácɨ á ofada, í mú sámb nyə lwə̂. ");
INSERT INTO mcp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nə́ ndɛɛ́, Yésus mú zə cɨ nə buud ɔ́nɨ nə́: «Bɨ́ ŋgə zə nə ikafwɛlɛ nə məbʉ́lə zə́lə bií mə, mə jisə zhilʉŋgaanə́? ");
INSERT INTO mcp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋgaá nə́ shé á dʉ bə jwɔ̂w dɛ̂sh kʉ́l ŋgwúd, mə ŋgə́ jɨ́ɨ́gʉli buud *Luŋ mə́ Zɛmbî dɨ̂, bɨ kú sɛ́ɛ́mb mbwə̂ nə́ bɨ mə́ bií mə. Njɨ bɨ mə́ bií mə ja gaád, shú nə́ sâ jɨ́ cilyá Kálaad Zɛmbî dɨ́ yí í bwə́mag.» ");
INSERT INTO mcp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ompwíín bɛ̂sh bwə́ mú myaas nyə, bwə́ shîn fúndə. ");
INSERT INTO mcp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wúl shwanzə́ í á ŋgə bɛ̧ nyə mpʉ́sə, í njúl njɨ nə *sanda nyúúlʉ́d. Nda bwə́ á ŋwá nə́mə́ bií nyə nə́, ");
INSERT INTO mcp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a mú bɨ́d sanda yé, túb shushwáás. ");
INSERT INTO mcp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bwə́ mú kə nə Yésus wə́ Ajəlácɨ á ofada. Milúlúú myâ ofada, nə ocúmbá buud nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧, bɛ̂sh bwə́ mú kə sɛɛŋgya cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pyɛ̂r nyɛ nyə á ŋgə bɛ̧ bwo shwóg-shwóg nə́ ndɛɛ́ kə wɔ́ɔ́s nûŋ luŋ. A mú kə ji shí, bə́nɔ̂ŋ bíl ífulísh, ŋgə gwáalə kuda. ");
INSERT INTO mcp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tɛ́ nɨ, milúlúú myâ ofada, bə́nɔ̂ŋ *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî jɛ̂sh bwə́ á ŋgə sɔ̧́ njagə́ bwə́ jɛ́ɛ́g nyə nə́ ndɛɛ́ bwə́ gwú nyə nə ndɨ́ yí. Njɨ, bwə́ á shígɛ́ kwey. ");
INSERT INTO mcp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ncúlyá buud bwə́ á ŋgə búgə nyə milə́sʉ́, njɨ isâ bwə́ á ŋgə cɨ yí í kú ŋgə bwəma. ");
INSERT INTO mcp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ntɔ́, bɔ́ɔ́l búúd bwə́ mú tɔ̂w otʉ́təlí, zə búgə nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Sə́ á gwág a ŋgə́ cɨ nə́, nyə e búgə *Mpáánzə́ Zɛmbî búúd bwə́ á lwɔ̧́ nə məbwə̂ ga. Nə́ ndɛɛ́, nyə é shumə Mpáánzə́ íshús njɨ mwɔ́w mə́lɔ́ɔl, nyâŋ í kú bə nə́ məbwə̂ mə́ búúd wə́ mə́ shúmə.» ");
INSERT INTO mcp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Njɨ bwə́ á tɛɛm cɨ ntɔ́, milə́sʉ́ myáŋ mí á shígɛ́ bwəma. ");
INSERT INTO mcp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ntɔ́, Ajəlácɨ á ofada mú tɔ̂w tʉ́təlí mísh mə́ buud ónɨɨ́d, a mú jí Yésus nə́: «Wo abɛ̧́sáyɛ́ búúd ɔ́ga sâ bwə́ ŋgə́ bwaagʉlə wo nɨ?» Yésus njúl njɨ kʉ́l-kʉ̂l, kú bɛ̧sa tɔɔ sâ. ");
INSERT INTO mcp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ntɔ́, Ajəlácɨ mú nyiŋgə jí nyə nə́: «Ye wo jɨ *Krîst, *Mwân mə́ Zɛmbî sə́ ŋgə́ gúmal yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yésus músə bɛ̧sa nə nyə nə́: «Mə jisə nyə. Ntɔ́, bɨ é dʉ́g *Mwân mə Múúd njúl shí mbwə̂ məncwûm mə́ Zɛmbî á ŋkul nyɛ̂sh dɨ́, bɨ mə bá nə́mə́ dʉ́g nyə, a ŋgə́ zə míŋkúdʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ajəlácɨ músə nyaa míkáándə́, nyə nə́: «Jɨ́ shé mə́ kwo sɔ̧́ owúshinɛd yí? ");
INSERT INTO mcp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bɨmɛ́fwó bɨ mə́ gwág nda á mə́ *lás nə Zɛmbî bwaasʉ́lə mpu nə́. Bɨ mə dʉ́g nə́ jɨ?» Bɛ̂sh bwə́ mú sámb nə́ á jəlá nə yə. ");
INSERT INTO mcp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nə́ ndɛɛ́, bɔ́ɔ́lʉ́gá búúd wâ cínɔŋg bwə́ mú tɛ́ɛ́d ŋgə́lə sɛy nyə məntənd mpwóómbʉ́d, bwə́ cɛ̧ɛ̧lə nyə sâ míshʉ́d, ŋgə wá nyə ikúda, bwə́ ŋgə́ cɨ nə nyə nə́: «Lwóg nə́ wo jɨ *muud micúndə́, jaawʉg sə́ muud nyə ámə yíd wo yɛ́.» Ifulísh í mú ŋgə tɨ́ nyə məmpɔ́ɔ́nz. ");
INSERT INTO mcp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pyɛ̂r njúl na shí, mbaadə́ dɨ, seegya nə́ ŋgwɔ́l múdá mə́ dʉ sɛ̂y wə́ Ajəlácɨ á ofada mú wɔ́ɔ́s. ");
INSERT INTO mcp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nyə mú yag Pyɛ̂r ŋgə́ gwáalə kuda, nyə dʉ́g nyə nə́ figə́-figə́. Nyə nə nɛ́ nə́: «Wo ɛ́ga! Wo á bə nə́mə́ gwooŋg mə́ Yésus muud á Nazarɛ̂t dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pyɛ̂r mú kɨ́ɨ́lya nyə, nyə nə́: «Mə ampúyɛ́, mə agwágɛ́ sâ gwə́mɛ́fwó wó ŋgə́ cɛɛl cɨ yí.» Ntɔ́, nyə mú wú cínɔŋg, cúwo tɔ́ɔ́n, kə fúm í á bə mbɛ̂ dɨ́ koogʉ́ yí, ŋgwúm kúwó mú kwáág. ");
INSERT INTO mcp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mudá wɔɔŋg mú nyiŋgə dʉ́g Pyɛ̂r cínɔŋgʉ́, nyə nə buud bwə́ á bə nyə́dɨ́ koogʉ́ wá nə́: «Muud ɛ́ga jisə muud á gwooŋg jáŋ.» ");
INSERT INTO mcp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pyɛ̂r mú nyiŋgə kɨ́ɨ́lya. Kú bwey nə́, buud bwə́ á bə cínɔŋg wá, bwə́ mú nyiŋgə cɨ nə Pyɛ̂r nə́: «Jísə bʉ́bə́lɛ́ nə́ wo jisə muud á gwooŋg jáŋ, nəcé wo jisə nə́mə́ múúd á Galilê.» ");
INSERT INTO mcp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pyɛ̂r mú kɨ́ɨ́lya nyə nə məma ŋkaanə́, nyə nə́: «Ŋkí mə́ bwiiŋg ijɔ̧́ɔ̧́, ŋkwaal nə mə. Mə ampúyɛ́ múúd bɨ́ ŋgə́ cɨ ɛ́nɛ.» ");
INSERT INTO mcp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cé nə cé, ŋgwúm kúwó mú kwáág ja ábɛɛ̂. Pyɛ̂r mú tə́dʉga sâ Yésus nyə á fwo cɨ nyə yí nə́: «Ŋgwûm kúwó kú fwo kwáág ja ábɛɛ̂, wo e kɨ́ɨ́lya mə ija ílɔ́ɔl.» A mú cwɨ́ɨl nə yə̂. ");
INSERT INTO mcp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mán mələ̂m, ná nə́mə́ mpʉ́mán mpʉ́mán, milúlúú myâ ofada, nə ocúmbá buud wâ lɔɔm, nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ nə *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî bwə́ mú sɛɛŋgya nə́ bwə́ zə́ sámb lə́sʉ́ mə́ Yésus. Bwə́ mú wɔ́ɔlə Yésus məŋkəda, kə cwámbʉlə Pilât. ");
INSERT INTO mcp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ntɔ́ Pilât mú jí nyə nə́: «Ye wo jisə Njwû *Oyúdɛn?» Yésus mú bɛ̧sa nə nyə nə́: «Wo mə́ cɨ ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Milúlúú myâ ofada mí mú ŋgə bul búgə Yésus lə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilât mú nyiŋgə jí nyə nə́: «Fwog dʉ́g bímbí mílə́sʉ́ bwə́ ŋgə́ búgə wo myá. Nə́ wo abɛ̧́sáyɛ́?» ");
INSERT INTO mcp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yésus kú bɛ̧sa tɔɔ ciyá. Pilât mú káam. ");
INSERT INTO mcp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilât nyə á dʉ bə nə́, ja jɛ̂sh zâŋ nyísə́ yí, a bɨ́d mbwug ŋgwûd, wɔɔŋg lɔɔm í ámə gwáámb nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Í á ka bə, ŋgwɔ́l múúd nə jínə́ nə́ Barábas bə́nɔ̂ŋ bɔ́ɔ́l búúd bwə́ á sá nə́ buud bwə́ sáág miŋgáádə́ nə ijwû, bwə́ gwú múúd cínɔŋg, bwə́ mú ka kə mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ntɔ́, áncuncuma buud mú bád mbʉ́ŋ í dʉ kə mpáánzə́ milə́sʉ́ yí, kə jí Pilât nə́ nyə sáág bwo sâ nyə́ dʉ bwey sá nə ŋkəndɨ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilât mú jí bwo nə́: «Ye bɨ mə́ jɨɨ nə́ mə bɨ́dʉ́g bɨ́ Njwû Oyúdɛn?» ");
INSERT INTO mcp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nyə á cɨ ntɔ́ nəcé nyə á bwey mpu nə́ milúlúú myâ ofada mí ŋgə kusha nə Yésus zhíŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ja Pilât mə́ jí bwo ntʉ́nɨ yí, milúlúú myâ ofada mí mə́ shwúgʉli lɔɔm nə́ Pilât bɨ́dʉ́g Barábas. ");
INSERT INTO mcp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilât mú kwo jí bwo nə́: «Ká mə sáág nyɔɔŋg bɨ́ ŋgə́ jɔ̂w nə́ Njwû Oyúdɛn yɛ́ ntʉdɛlɛ̂?» ");
INSERT INTO mcp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bwə́ mú nyiŋgə kɨ̂m gwɔ́w-gwɔ̂w nə́: «Bwambʉləg nyə kwolós dɨ̂!» ");
INSERT INTO mcp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilât mú jí nə́: «Dáyɛ́ bɔ̂w á mə́ sá yí?» Bwə́ mú kwo kɨ̂m gwɔ́w nə́: «Bwambʉlə́g nyə kwolós dɨ̂!» ");
INSERT INTO mcp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nda Pilât nyə á cɛɛl cweel lɔɔm mpimbə nə́, nyə mú bɨ́d bwo Barábas. Nyə lwâm búúd nə́ bwə́ fyámʉ́sə́g Yésus milwóŋ. Nyə mú yə bwo Yésus nə́ bwə́ kə́g bwambʉlə nyə kwolós dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ozɨmbɨ bwə́ mú kə nə Yésus luŋ mə́ Pilât dɨ́ cwû. Bwə́ mú sɛɛŋg ózɨmbɨ bɛ̂sh cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bwə́ mú bwééd nyə káándə́ ícî atɨ́tɨɨ̂. Bwə́ ŋwa kwoolú íbiin-bíin, lwɔ̧́ *tûm gúmə́, jil nyə lúúd. ");
INSERT INTO mcp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bwə́ mú ŋgə bə́da nyə məbə́dá mə cóógʉ́ nə́: «Yé Njwû Oyúdɛn, sə́ ŋgə báág nə wo.» ");
INSERT INTO mcp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bwə́ mú nyífə nyə mbwu lúúd, sɛy nyə məntənd, bwə́ ŋgə́ kúd məbwóŋ shí nyə́dɨ́ mpwóómbʉ́d nda bwə́ ŋgə yə nyə gúmə́. ");
INSERT INTO mcp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ja bwə́ mə́ shîn cágʉlə nyə ntʉ́nɨ yí, bwə́ mú yîl nyə káándə́ ícî atɨ́tɨɨ̂, bwééd nyə mikáándə́ myɛ́, bwə́ mú kə nə nyə, kə́lə bwambʉlə nyə kwolós dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bwə́ ŋgə́ kə ntʉ́nɨ, bwə́ mú bwəma nə ŋgwɔ́l múúd ŋgə́ wú ífambə́, Shímun, muud á Sirɛ̂n, sɔ́ɔ́ŋgʉ́ mə́ Aləgʉzándrə bá Rúfus. Bwə́ mú yɨ́ɨ́mbʉli nyə nə́ nyə ŋkɛ́nyʉg Yésus kwolós. ");
INSERT INTO mcp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bwə́ mú ŋgə kə nə Yésus kə jé kʉ́l bwə́ dʉ jɔ̂w nə́ Golgota yí. Jínə́ dɔɔŋg í kə́ nə́ «kʉ́l á bwundú lúu». ");
INSERT INTO mcp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bwə́ mú ŋwá yə nyə wáan fʉlá nə mîr nə́ a ŋgúlʉg, a mú ban. ");
INSERT INTO mcp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bwə́ mú bwambʉlə nyə kwolós dɨ́, bwə́ mú wusə mpaambə́ nə́ bwə́ kawʉla míkáándə́ myɛ́, muud yɛ̂sh á gwooŋg jáŋ bə nə kɔw. ");
INSERT INTO mcp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bwə́ á bwambʉlə nyə kwolós dɨ́, jwɔ̂w í mú məbaan ibuu mâ mpʉ́mán mpʉ́mán. ");
INSERT INTO mcp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bwə́ á cilə cwoomb bwə́ á gwú nyə nə ndɨ́ yí nyə́dɨ́ kwolós dɨ nə́ «Njwû *Oyúdɛn wə́ ɛ́ga». ");
INSERT INTO mcp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bwə́ á bwambʉlə nyə kwolós dɨ́, bə́nɔ̂ŋ izhilʉŋgaanə́ íbá, jíga jé kwolós dɨ́ Yésus dɨ́ mbwə̂ məncwûm, jíga jéd nyə́dɨ́ mbwə̂ məkɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Micilyá mí Kálaad Zɛmbî mí á bwəma nə́: «Bwə́ á lɔ̧́ nyə gwooŋg ízhilʉŋgaanə́d.» ");
INSERT INTO mcp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Buud bwə́ mú ŋgə lɔ̧ cínɔŋg, bwə́ ŋgə́ lwîy nyə, bwə́ ŋgə́ sagʉsə milúu nə məzhwámá. Bwə́ nə nɛ́ nə́: «Nə́ wo wə́ ɛ́ga! Wo muud jɨ nə ŋkul búgə *Mpáánzə́ Zɛmbî nə́ ndɛɛ́ wo kwo sá njɨ mwɔ́w mə́lɔ́ɔl shumə́lə nyúl yɛ́, ");
INSERT INTO mcp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","cʉgʉg womɛ́fwó, shulə́g, wú kwolós nɨɨ́d». ");
INSERT INTO mcp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú nə́mə́ ŋgə cágʉlə nyə, bwə́ ŋgə́ cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Nyə á dʉ cʉg buud oshús, njɨ a káád cʉgʉ́lə nyə́mɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yé *Krîst Njwú-buud á *Izʉrəyɛ̂l! shuləg shí kɨ́kɨdɨ́ga, sə́ dʉ́gʉ́g ná, sə́ ka *búgʉla wo». Tɛɛm bə búúd bə́nɔ́ŋ bwə́ á bə íkwolós dɨ́ wá, bwə́ á ŋgə nə́mə́ lwîy nyə. ");
INSERT INTO mcp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yídʉ́gʉ́ í á ka shila shí nyɛ̂sh nə́ ŋkwed, tɛ́ɛ́d tɔ́lɔ́g dɨ́ kə wɔ́ɔ́s mə́wəla məlɔ́ɔl mâ mpwó-kugʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mə́wəla məlɔ́ɔl dɨ́, Yésus músə kɨ̂m nə ŋkulû nə́: «Eli, Eli, lemá sabakʉtáni?» Ntɔ́ mə́ kə́ nə́: «Zɛmbî waam, Zɛmbî waam, wó myaas mə nə́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ja bɔ́ɔ́l búúd bwə́ á bə cínɔŋg wá bwə́ á gwág ntɔ́ yí, bwə́ nə́: «Gwágá, a ŋgə jɔ̂w Eli.» ");
INSERT INTO mcp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋgwɔ́l múúd mú tɨ́ kʉ́lə́, kə ŋwa eponzh, juwo mə́lwəg mə́ ábibyɛnzhʉ̂ dɨ́, a fɛɛn shwóg lʉ́ lɨ́ɨ́d. A mú kənd nə́ Yésus ŋgúlʉg. Nyə nə́: «Bwándʉ́gá! shé fwógá ná dʉ́g jínɨ, ŋkí Eli nyə é zə shul nyə shí.» ");
INSERT INTO mcp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yésus mú ntâg kɨ̂m nə ŋkulû, a mú jímal. ");
INSERT INTO mcp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Seegya nə́ məmá *sanda í á dʉ kalʉwo *Mpáánzə́ Zɛmbî yí í mú sɛɛl tʉ́tám nə́ cáŋ wú gwɔ̂w wɔ́ɔ́s shí. ");
INSERT INTO mcp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lúlúú ízɨmbɨ í á bə Yésus dɨ́ shwóg yí mú dʉ́g mbií Yésus nyə á jímal yí, nyə nə́: «Bʉ́bə́lɛ́, muud ɛ́ga nyə á bə *Mwân mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bɔ́ɔ́lʉ́gá búdá bwə́ á bə cínɔŋg bwə́ tə́l shwóg-shwóg ka dʉ dʉ́g. Maríya á Magʉdála, nə Maríya nyɔɔŋgʉ́ mə́ Yózɛs bá Zhâk á ntombú, zə kɛɛl Salúma, bwə́ á bə gwooŋg búdá jɔɔŋg dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Budá bɔɔŋgʉ́ bwə́ á dʉ sɛ̂y nə Yésus ja nyə á bə Galilê yí. Bɔ́ɔ́lʉ́gá búdá ŋkí bulya bə́nɔ́ŋ bwə́ á bád zə Yurʉ́səlɛm wá, bwə́ á bə nə́mə́ cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ŋgwɔ́l múúd nə jínə́ nə́ Yósɛb, muud á Arimatê, nyə á bə nə́mə́ gwooŋg mílúlúú myâ lɔɔm dɨ̂. Nyə á dʉ bwánd Faan mə́ Zɛmbî. Jwɔ̂w dɔɔŋgʉ́, kugʉ́ í mú ŋgə bii shí, baan bwə́ dʉ kwísha ísâ yâ Sábaad yí, Yósɛb wɔɔŋgʉ̂ mú kə nə iŋkáŋ wə́ Pilât, kə gwáámb mbimbə mə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Njɨ Pilât nyə á gwág nə́ Yésus mə́ lɛɛlʉ́ yə yí, a mú bul bɨ̂. A mú jɔ̂w lúlúú ízɨmbɨ, zə wámbʉlə ŋkí Yésus mə́ ŋwá bwey yə. ");
INSERT INTO mcp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja á mə́ shîn gwág mpɛ̧sá mə́ lúlúú ízɨmbɨ yí, a mú magʉlə nə́ Yósɛb kə́g ŋwa mbimbə. ");
INSERT INTO mcp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yósɛb mú kə kusə ndómbó áfufumə́, nyə kə shul mbimbə shí, wɔ́ɔlə wo ndómbó wɔɔŋgʉ́d, kə dʉl shwôŋ dɨ̂. Bwə́ á lúmə shwoŋ nyɔɔŋgʉ́ fifim mə́kwóógʉ́d. A mú bíŋgal məma kwóógʉ́, juwal shwoŋ. ");
INSERT INTO mcp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maríya á Magʉdála bá Maríya nyɔɔŋgʉ́ mə Zhâk, bwə́ mú ŋgə mpu dʉ́g kʉ́l bwə́ á dʉl nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ja Sábaad mə́ shîn yí, mpwó-kugʉ́ shí, Maríya á Magʉdála, nə Salúma, nə Maríya nyɔɔŋgʉ́ mə́ Zhâk, bwə́ mú kə kusə ólabínda nə́ bwə́ bá kə gwáágʉlə mbimbə mə Yésus. ");
INSERT INTO mcp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nə́ ndɛɛ́, jwɔ̂w shwɛ́ndɛ mə́ dʉ́ tɛ́ɛ́d yí, bwə́ mú kə wɔ́ɔ́s shwoŋ dɨ́ ná nə́mə́ mpʉ́mán mpʉ́mán, lúú jwɔ̂w í ŋgə́ kúnɔw cwɨ́ɨl. ");
INSERT INTO mcp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bwə́ mú ŋgə jî bwə́mɛ́ nə bwə́mɛ́ nə́: «Zə́ nyə é kə bíŋgal shé kwóógʉ́ dʉ́sə́ shwoŋ dɨ́ yí?» ");
INSERT INTO mcp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bwə́ ka bʉ̂n mísh, bwə́ mú dʉ́g məma kwóógʉ́ nɨ í mbwúg koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bwə́ mú nyíi shwoŋ dɨ́, kə kwey wúl shwanzə́ í njúl njínjilî, kɔ́ɔ́mb á mbwə̂ məncwûm, nyə nə mikáándə́ mí áfufumə́. Bwə́ mú bul gwág ifwaas. ");
INSERT INTO mcp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Shwanzə́ nɨ mú cɨ nə bwo nə́: «Kúgá fúndə! Bɨ́ ŋgə sɔ̧́ Yésus, muud á Nazarɛ̂t bwə́ á bwambʉlə kwolós dɨ́ yɛ́! A cúgɛ́ wa, a mə́ gwûm. Dʉgá kʉ́l bwə́ á bwɨ́ɨ́g nyə yí. ");
INSERT INTO mcp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nə́ ndɛɛ́, lɛɛlʉgá kə, kə jaaw *ómpwíín bɛ́ nə Pyɛ̂r nə́ a mə́ kə shwóg, kə bwánd bɨ́ Galilê. Nûŋ wə́ bɨ́nɔ́ŋ bɨ́ é dʉ́gya yɛ́, nə́mə́ nda nyə á bwiiŋg bɨ́ nə́.» ");
INSERT INTO mcp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ntɔ́, bwə́ mú wɛɛnzh wú shwoŋ dɨ́ bwə́ ŋgə́ lilya, milám kú bə nə́ shɛɛ; í mú sá nə́ bwə́ nda jaaw tɔɔ muud. ");
INSERT INTO mcp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yésus nyə á gwûm mpʉ́mán mpʉ́mán a jwɔ̂w lʉ́ shwɛ́ndɛ. Nyə á ka tɛ́ɛ́d lwóya nyúul wə́ Maríya á Magʉdála, mudá nyə á yîl məjamb zaŋgbá yɛ́. ");
INSERT INTO mcp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mudá wɔɔŋgʉ̂ mú kə jaaw buud ɔ́ gwooŋg ɔ Yésus sâ jɔɔŋgʉ̂, nəcé bwə́ á bə nə məcɛy mílámʉ́d, bwə́ ka ŋgə jɨɨ. ");
INSERT INTO mcp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A mú ka jaaw bwo nə́ Yésus mə́ gwûm, nyə shí nə́mə́ dʉ́g nyə nə mísh mɛ́. Njɨ, nyə á tɛɛm jaaw bwo ntɔ́, bwə́ á shígɛ́ magʉlə. ");
INSERT INTO mcp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mpʉ́sə na, bɔ́ɔ́l ómpwíín bɛ́ óbá, bwə́ ŋgə́ kə bwə́dɨ́ kwáádə́, nyə mú lwóya bwo nyúúl nyɛ́ wúl mbií shús. ");
INSERT INTO mcp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Buud obá bɔɔŋgʉ́ bwə́ mú nyiŋgə nə mpʉ́sə, kə jaaw bɔɔŋgʉ́ ómpwíín bwə́ á lʉ́gə Yurʉ́səlɛm wá, bâŋ nə́mə́ njɨ məshwán. ");
INSERT INTO mcp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gúl ja shús, Yésus mú nyiŋgə lwóya nyúúl nyɛ́ ómpwíín wûm nə ŋgwúd dɨ̂, bwə́ ŋgə də. Cínɔŋg a mú jum bwo nəcé bwə́ á shígɛ́ *magʉlə kɛ́ɛl búúd bwə́ á jaaw bwo nə́ a mə́ gwûm shwoŋ dɨ́ yí. Bwə́ á bə ŋkí lal mílâm. ");
INSERT INTO mcp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nə́ ndɛɛ́, a mú cɨ nə bwo nə́: «Kəgá shí ga nyɛ̂sh, bɨ kə́g cúndə Jɔ̧jɔ̧ Kɛ́ɛl, muud yɛ̂sh gwágʉ́g. ");
INSERT INTO mcp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nyɔɔŋg mə́ bá *búgʉla, bwə́ juwo nyə yɛ́, nyə wə́ mə́ bá *dʉ́g cʉg yɛ́. Nyɔɔŋg mə bá bə kú búgʉla yɛ́, nyə bá bwəma nə intʉ́gʉ́lí yâ kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ntɔ́, bɔɔŋg bwə́ bá búgʉla wá, bwə́ bá dʉ sá *mə́shimbá: bwə́ bá dʉ yîl búúd məjamb jínə́ dáámʉd, bwə́ lás mə́kə̂l məshús, ");
INSERT INTO mcp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bwə́ bii ónywâ nə məbwə̂. Ŋkí bwə́ də́ gwoog, sâ kú sá bwo. Bwə́ kɛɛl mimbə̂l mə́bwə̂, mimbə̂l myɔɔŋgʉ́ mí yâl.» ");
INSERT INTO mcp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja Yésus mə́ shîn lás nə bwo ntʉ́nɨ yí, a mú ŋkâŋ kə gwɔ̂w, kə ji mbwə̂ məncwûm mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nə́ ndɛɛ́, *ompwíín bɛ́ bwə́ mú nyiŋgə, kə ŋgə cúndə Jɔ̧jɔ̧ Kɛ́ɛl ikʉ́l byɛ̂sh. Cwámba Yésus nyə á dʉ yə bwo ŋkul ísɛ́y byáŋʉ́d. A lwágʉlə nə́ minjɨ́ɨ́gʉ́lá myáŋ mí á bə tʉ́təlí nəcé bwə́ á dʉ sá mə́shimbá.");
INSERT INTO mcp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yé Tyofîl lwám múúd, zhwog buud bwə́ á mə́ ŋgə she cilə ŋkúmba lâŋ á isâ í á sɨ̂y wa sə́dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bwə́ á ŋgə jaaw isâ nə́mə́ nda búúd bwə́ á dʉ́g byo tɛ́ɛ́d mə́tɛ́ɛ́dʉ́léd wá bwə́ á bwiiŋg sə́ nə́. Buud bɔɔŋgʉ́ wə́ bwə́ ŋgə́ sá isɛ́y í bwiiŋgʉ́lə mílə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nə́ ndɛɛ́ mə mə́ ka nə́mə́ kwey nə́ mə́ jə́lá nə cilə wo isâ byɔɔŋgʉ̂ téégyá nda í á ŋgə sɨ̂y nə́. Mə zə́ cilə na mə mə́ fwo mpu wámbʉlə sʉ́sʉ́sá jɛ̂sh tɛ́ɛ́d mə́tɛ́ɛ́dʉ́léd. ");
INSERT INTO mcp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mə́ jɨɨ nə́ wo mpúg nə́ minjɨ́ɨ́gʉ́lá wó á ŋwa myá mí bə́lɛ́ bə bʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ŋgwɔ́l fada nyə á bə nə́ Zakarî ja Herod nyə á bə njwú-buud á Yudéa yí. Fada wɔɔŋgʉ̂ bə́nɔ̂ŋ Abiya wə́ bwə́ á bə jáŋ gwooŋg. Mudá yé nyə á bə nə́ Ilísabet, a njúl shilə bag ɔ Arɔɔn. ");
INSERT INTO mcp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bɛ̂sh obá nə mudûm nə mudá bwə́ á bə otʉ́təlí ɔ búúd mísh mə́ Zɛmbî dɨ̂, bwə́ dʉ́gə́ mpu sâ Zɛmbî məgwág, dʉ bɛ̧ ísâ byɛ̂sh Cwámba ŋgə́ cɨ nə́ í bə́g yí nə məcɛ̧ɛ̧ mɛ́ mɛ̂sh mbií á kú nə sâ á jumʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Njɨ bwə́ áshígɛ́ bə nə mwân nəcé Ilísabet nyə á bə kundú, bɛ̂sh obá bwə́ á bə ntâg bwə́ mú icwúcwúúl. ");
INSERT INTO mcp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dúlʉ́gá jwɔ̂w dɨ ɨɨ́, Zakarî nyə á ŋgə sá isɛ́y í fada byé nda í á bə jwaŋga á gwooŋg jáŋ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ofada bwə́ á dʉ wusə mpaambə́ nə́ bwə́ fɛ́ɛ́sh nyɔɔŋg kə́g nyíi *Mpáánzə́ Zɛmbî yɛ́. Bwə́ á ka nə́mə́ wusə jínɨ jaá, mpaambə́ mú fɛ́ɛ́sh Zakarî nə́ nyə wə́ kə́g nyíi kə jígal *cáá. ");
INSERT INTO mcp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wəla lʉ jígálʉ́lə cáá nɨ dɨ, buud ɔ kúl búúd bɛ̂sh bwə́ á bə tɔ́ɔ́n bwə́ ŋgə́ jəgʉla nə Zɛmbî ");
INSERT INTO mcp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ŋgwɔ́l *éŋgəles mə́ Yawé mú zə lwóya nyúúl wə́ Zakarî, zə tɔ̂w nyə ŋgɛɛ mbwə̂ məncwûm, *alatâr bwə́ dʉ jígal cáá yɛ́ dɨ́ koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mitə́dʉ́gá mí á búbulə Zakarî lúúd nə dʉ́gʉ́lə nyə á dʉ́g éŋgəles yí, a mú bul bə nə ifwaas. ");
INSERT INTO mcp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Njɨ, éŋgəles mú cɨ nə nyə nə́: «Zakarî, kú bɛɛg fúndə, nəcé Zɛmbî mə́ ŋwa mə́jəgʉla mwô. Mudá woó mə bá byá wo mwámudûm, wo bá gwiid nyə nə́ Yuánɛs. ");
INSERT INTO mcp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wo bá bul kɔɔs nə məshusʉg, ncúlyá buud bwə́ bá nə́mə́ bə nə məshusʉg nə byɛ́lʉ́lə mwân wɔɔŋg mə bá byɛ̂l yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nəcé a bá bə fwámɛ́ múúd mísh mə́ Zɛmbî dɨ̂. Nyə abʉ́lɛ́ bwɛlɛ́ ŋgul mə́lwəg kú ŋgul gúl sâ ányinyaanə̂. A bá bwey bə lwándʉ́lá nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim a njúl ná mwɔ̧ mə nyɔ́ɔ́ŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A bá nə́mə́ sá nə́ bɔ́ɔ́l búúd wâ bag ɔ *Izʉrəyɛ̂l bwə́ nyíŋgəg zə wə́ Zɛmbî wáŋ Yawé. ");
INSERT INTO mcp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A bá zə nə lâŋ mə́ Zɛmbî nə *shíshim nə ŋkul Eli nyə á bə nə ndɨ̂ yí. A bá zə sá ŋkwambʉlə mpə́dʉ́gá osɔ́ɔ́ŋgʉ́ bə́nɔ̂ŋ bwân. A bá nə́mə́ sá nə́ bɔɔŋg bwə́ á dʉ bə nə məlwə̂ wá bwə́ cɛ́ndʉ́g kuú njɔɔnd, bwə́ bə nə fʉg á otʉ́təlí ɔ búúd. Ntɔ́, a bá kwəmʉsa Cwámba kúl búúd í njúl nyə fwámɛ́ kwééshá.» ");
INSERT INTO mcp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakarî mú cɨ nə éŋgəles nə́: «Mə músə cwúcwúúl, mudá waamə́ mə́ nə́mə́ jaas; mə e bá wámbʉlə sâ wó ŋgə́ cɨ nɨ ntʉdɛlɛ̂?» ");
INSERT INTO mcp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eŋgəles mú bɛ̧sa nə nyə nə́: «Mə wə́ Gabryɛ̂l, mə jɨ mísh mə́ Zɛmbî dɨ̂, mə ŋgə sɛ̂y nə nyə. Nyə ámə ntɨ́ mə nə́ mə zə́g lésha nə wo, zə jaaw wo jɔ̧jɔ̧ mə́kə́l mə́nɨ. ");
INSERT INTO mcp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Njɨ, nda wó mə́ ka bə kú *magʉlə íciyá byâm nə́, wo é bə fífî. Wo bá ji kú lás kə wɔ́ɔ́s jwɔ̂w ísâ mə́ ámə zə jaaw wo ínɨ í bá bwəma yí. Nəcé byáá í bá bwəma dáŋ wəlad.» ");
INSERT INTO mcp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Í á bə na, kúl búúd jâŋ í ŋgə́ bwánd Zakarî. Buud bwə́ mú ŋgə káam nə́ a mə́ bul bwey nûŋ Mpáánzə́ Zɛmbî dɨ́ cwû. ");
INSERT INTO mcp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ja Zakarî nyə á ka cúwo tɔ́ɔ́n yí, nyə á bə kú ná nə ŋkul mə lésha nə buud. Bwə́ mú mpu nə́ a shí dʉ́g gúl sâ nûŋ fúm á ci dɨ́. Nyə á ŋgə fufə njɨ məbwə̂. Nyə á shwal bə fífî. ");
INSERT INTO mcp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ja nyə á shínal mɛ́ mwɔ̂w mə́ ísɛ́y yâ Mpáánzə́ Zɛmbî yí, nyə á ka nyiŋgə kə bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fwála mú cɔ̧́, mudá yé Ilísabet músə bə nə bum. A mú shwaaw tâŋ oŋkwoond otɔ́ɔn kú lwóya nyúul, a ŋgə́ cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Sâ Cwámba mə́ sá mə wə́ ga. A mə́ ntɨ mísh mɛ́ mə́dɨ́ zə yîl mə shwôn mə́ á bə nə ndɨ̂ búúd bâm dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ja bum mə́ wɔ́ɔ́s Ilísabet ŋkwoond saman dɨ́ yí, Zɛmbî mú kənd *éŋgəles Gabryɛ̂l ŋgwə́la á Galilê bwə́ dʉ jɔ̂w nə́ Nazarɛ̂t yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nyə á kənd nyə nə́ a kə́g lésha nə ncwíyɛ̂ sás lʉ́ múdá í á bə wu nə́ Maríya yí. Sás dɔɔŋg í á bə nə cɛ̧ɛ̧lá bá nə Yósɛb, muud á bag ɔ *Dávid. ");
INSERT INTO mcp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eŋgəles mú nyíi Maríya njɔ́w cɨ nə nyə nə́: «Mə báág nə wo, Yawé jɨ nə wo, a mə́ sá mpaam nə jɔ̧ lâm.» ");
INSERT INTO mcp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iciyá ínɨ í mú sá Maríya mitə́dʉ́gá búbulə lúúd. A mú ŋgə jî lámʉ́d nə́ wâŋ mbií mə́bə́dá í kə́ nə́ jɨ. ");
INSERT INTO mcp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eŋgəles mú cɨ nə nyə nə́: «Maríya, kú bɛɛg fúndə. Nəcé wo mə́ bwəma nə ocúncɛ́sh ɔ́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dʉgɨ́, wo zə́ bə nə bum, wo bá byá mwámudûm, wo gwiid nyə nə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A bá bə fwámɛ́ múúd. Bwə́ bá dʉ jɔ̂w nyə nə́ *Mwân mə́ Zɛmbî a gwɔ́w-gwɔ̂w. Zɛmbî wúsʉ́ Yawé mə bá yə nyə ijwûga í mpáámbə́ jé Dávid. ");
INSERT INTO mcp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A bá jwú nə bag ɔ *Yákwab kandʉgə á kandʉgə, ijwûga byé í ábʉ́lɛ́ bə nə məshíné.» ");
INSERT INTO mcp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríya mú cɨ nə éŋgəles nə́: «Jâŋ í bá bə ntʉdɛlɛ́, mɛɛ kú fwo mpu múdûm?» ");
INSERT INTO mcp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eŋgəles mú bɛ̧sa nə nyə nə «Ŋkɛ̧́ŋkɛ̧̂ Shíshim mə bá zə wódɨ́, ŋkul mə́ Zɛmbî a gwɔ́w-gwɔ̂w í mú búdal wo nda gúgʉ́wá í dʉ búdal múúd nə́. Gwə́ wə́ í bá sá nə́ mwân wó bá byá yɛ́ mə́ bá bə fééshá, bwə́ dʉ jɔ̂w nyə nə́ Mwân mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dʉgɨ́, mbyɛ̂l wô Ilísabet mə́ zə bə nə bum ícwúúlʉ́d. A bá nə́mə́ byá mwámudûm. Nyə muud bwə́ á dʉ cɨ nə́ a jɨ kundú yɛ́, bum mú nyə ŋkwoond saman dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mpug nə́ sâ cúgɛ́ nə ŋkul bwɛlɛ́ ntɔ̧ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maríya mú cɨ nə́: «Mə jɨ sɔ́ɔl məsáal mə Yawé. A sáág mə nda wó mə́ cɨ nə́.» Eŋgəles mú kyey. ");
INSERT INTO mcp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nə́mə́ fwála dɔɔŋgʉ́ dɨ, Maríya mú ŋwa zhɨ́ɨ́ lɛɛlʉ́lə kə ŋgwə́la á kɔ́ɔ́mb Yudéa jísə́ mímbʉ́ŋ mimbʉ́ŋ yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A mú kə nyíi Zakarî dɨ́ njɔ́w, bə́da Ilísabet. ");
INSERT INTO mcp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja Ilísabet nyə á gwág məbə́dá mə́ Maríya yí, mwân nyə á lugʉsa nyə mwɔ̧̂ dɨ̂, Ilísabet músə lwánd nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A mú kɨ̂m məma ŋkwiimbyê, nyə nə́: «Wo jɨ nə ibwádán ntɔ̧ bɔ́ɔ́lʉ́gá búdá bɛ̂sh, mwân jɨ́ wo mwô dɨ́ yɛ́ jɨ nə́mə́ nə ibwádán. ");
INSERT INTO mcp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jɨ́ í mpú sâ nə́ nyɔɔŋgʉ́ mə Cwámba waamə́ zə́g mə́dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nəcé dʉgɨ́, njɨ mə́lwə̂ mâm mə́ ámə gwág mə́bə́dá mwɔ̧̂ yí, mwân nyə ámə lugʉsa mə nə məshusʉg mwô dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wɛɛ mə́ jəla, wɛɛ muud mə́ *búgʉla nə́ sâ jɛ̂sh Cwámba mə́ sá nə́ bwə́ jááwʉg wo yí í é bwəma yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maríya mú cɨ nə́: Zɛmbî waam, wo jɨ məma Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Shíshim wâm í ŋgə kɔɔs nə məshusʉg nəcé cʉgye waamə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nəcé a mə́ bə́lɛ ntɨ mísh dʉ́g zhizhe lwaá dɛ́ ámudâ. Haaw! Tɛ́ɛ́d fwála gaád buud wâ ikala byɛ̂sh bwə́ bá dʉ cɨ nə́: «mɛɛ mə́ jəla». ");
INSERT INTO mcp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nəcé Zɛmbî á ŋkul nyɛ̂sh mə́ sá mə məma ísâ. Jínə́ dɛ́ dʉ́sə nə gúmə́ ntɔ̧ sâ jɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lâm mə́cɛy yé wúsə nə́ bagə́ shú búúd bwə́ ŋwá nyə nə fúndʉ́gʉ́ wá kə wɔ́ɔ́s íkala ikala. ");
INSERT INTO mcp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A mə́ lwóya ŋkûl nyɛ́. A mə́ sá nə́ buud bwə́ dʉ ŋkɛ̂ny mə́nyúúl wá bwə́ cɨ́ɨ́magʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A mə́ yîl íŋkácid i búúd íjiya í ící byáŋʉ́d wusə shí, a bʉ̂n ózhizhe ɔ búúd gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Buud bwə́ á bə nə məfúfə wá, a mə́ yə bwo zhwog tɔɔm a nyiŋg búúd ɔ́ tɔɔm məbwə̂ ocwûd. ");
INSERT INTO mcp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A mə́ zə kwiid bag ɔ sɔ́ɔl məsáal yé *Izʉrəyɛ̂l, a mə́ tə́dʉga lâm mə́cɛy yé, ");
INSERT INTO mcp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nda nyə á kaag impáámbə́ bísʉ́ shú mə́ *Abʉraham bə́nɔ̂ŋ mpwoŋ buud nyɛ́ kandʉgə á kandʉgə nə́. ");
INSERT INTO mcp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maríya bá Ilísabet bwə́ á já je bə óŋkwoond olɔ́ɔl nə́ ndɛɛ́ Maríya músə nyiŋgə kə bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wəla lʉ byɛyí í á ka wɔ́ɔ́s Ilísabet. A mú byá mwámudûm. ");
INSERT INTO mcp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nə buud bə́nɔ́ŋ bwə́ á bə jáŋ baŋ wá, nə mimbyɛ̂l myɛ́ bwə́ mú gwág nə́ Yawé mə́ bul gwág nyə cɛy lámʉ́d. Bə́nɔ́ŋ bwə́ mú ka zə taag. ");
INSERT INTO mcp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jwɔ̂w mwân nyə a wɔ́ɔ́s mwɔ̂w mwɔɔmb yí, bwə́ mú zə nə́ bwə́ zə́ sá nyə ábɨwáág. Bwə́ mú cɛɛl gwiid nyə nə́ Zakarî nda sɔ́ɔ́ŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Njɨ nyɔɔŋgʉ́ mú cɨ nə́: «Mbɔ̂! Jínə́ dɛ́ wə́ Yuánɛs.» ");
INSERT INTO mcp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bwə́ mú cɨ nə nyə nə́: «Muud ŋgwúd nə ŋgwúd cugɛ́ nə jínə́ lʉ́ Yuánɛs njɔ́w búúd wʉ́n wɛ̂sh dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bwə́ mú dʉ lésha nə sɔ́ɔ́ŋgʉ́ mwân dʉ fufə njɨ məbwə̂ jílə nyə jínə́ á cɛ́ɛ́l gwiid mwân yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sɔ́ɔ́ŋgʉ́ mwân mú gwáámb nə́ bwə́ yə́g nyə kwóógʉ́ nə́ a zə́g cilə cínɔŋg. A mú cilə nə́: «Jínə́ dɛ́ wə́ Yuánɛs.» Buud bɛ̂sh bwə́ mú bul káam. ");
INSERT INTO mcp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Seegya ntâg nə́ Zakarî mpu mə́ bâŋ, jûm mú nyə fʉlî nə́ a je lás. A mú shwal bʉ̂n kə́l ŋgə yə Zɛmbî məshwúmb. ");
INSERT INTO mcp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Buud ɔ́ baŋ bɛ́ bwə́ mú bə nə fúndʉ́gʉ́. Nə́ ndɛɛ́ buud bwə́ mú ŋgə bwiiŋg lâŋ á isâ í á sɨ̂y ínɨ shí Yudéa á mimbʉ́ŋ nyɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Buud bɛ̂sh bwə́ á gwág lâŋ wɔɔŋg wá bwə́ á bə kú bwɛlɛ yîl lâm cínɔŋg. Bwə́ mú dʉ jî nə́: «Múmwán jɔɔŋg í bá bə jɨ́ e? Bʉ́bə́lɛ́, ŋkul mə́ Yawé í á ŋgə nyîn cʉg mə mwân wɔɔŋgʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mwân sɔ́ɔ́ŋgʉ́ yé Zakarî mú lwánd nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́, a mú cúndə cúndə́ mə́ Zɛmbî, nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Gúmə́ nə Yawé, Zɛmbî á *Izʉrəyɛ̂l nəcé a mə́ kwiid kúl búúd jé, yîl bwo mənyámád. ");
INSERT INTO mcp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A mə́ wééshʉli sə́ ŋkácid cʉgye mpwoŋ buud mə́ sɔ́ɔl məsáal yé *Dávid dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nyə a shí bwey dʉ jaaw kɛ́ɛl dɔɔŋgʉ́, *buud ɔ mícúndə́ bɛ́ nyə á fɛ́ɛ́sh yág wá dʉ jaaw. ");
INSERT INTO mcp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nyə á kaag nə́ a bá zə yîl sə́ mə́nyámá mə́ mízhízhíŋ mísʉ́d, a yîl sə́ məbwə̂ mə́ bɔɔŋg bwə́ ŋgə́ mpii sə́ wád. ");
INSERT INTO mcp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A mə́ lwágʉlə nə́ a jɨ nə lâm mə́cɛy nə odâ; a mə́ tə́dʉga sɔ̧ nyə á sá nə bwo yí. ");
INSERT INTO mcp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nəcé nyə á kɛɛn bʉ́bə́lɛ́ nə Dâ *Abʉraham nə́ í bá bə nə́ ");
INSERT INTO mcp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","á ká shîn yîl sə́ mə́bwə̂ mə́ búúd bwə́ ŋgə́ lúmbʉli nə sə́ wá dɨ, sə́ mə́ bá dʉ yə nyə gúmə́ kú nə ifwaas, ");
INSERT INTO mcp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","sə́ ŋgə́ lwóya nə́ sə́ bʉ́sə buud bɛ́, sə́ ŋgə́ cʉgə tʉ́təlí nyə́dɨ́ míshʉ́d, ŋgə cʉgə nda búúd ɔ kúl jé bwə́ jə́lá nə cʉgə nə́, sə́ bə ntɔ́ mwɔ̂w mə́ cʉg mə́sʉ́ mɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Múmwán, bwə́ bá dʉ jɔ̂w wo nə́ *muud micúndə́ mə́ Zɛmbî á gwɔ́w-gwɔ̂w. Nəcé wo bá kə́ Cwámba shwóg, kə kwambʉlə nyə zhɨɨ́ ");
INSERT INTO mcp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kúl búúd jé í mpúg nə́ a ŋgə zə nə́ a zə́ cʉg bwo, juu bwo nə *misə́m myáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Zɛmbî wúsʉ́ jɨ bul bə nə lâm mə́cɛy. A mə́ ntɨ sə́ məŋkɛnya mə́ ŋgə́ zhu gwɔ̂w nda mɔɔŋg mə jwɔ̂w ja í dʉ cúwo yí, ");
INSERT INTO mcp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mə́ zə́g kwan bɔɔŋg bwə́ ŋgə́ cʉgə yídʉ́gʉ́ shwɨy dɨ́ wá, mə́ zə́g sá nə́ sə́ cʉ́gəgí nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwân nyə á ka nə́mə́ ŋgə wɨ̂y, *shíshim yé ŋgə́ ŋwa ŋkul. Nyə á dʉ ji mə́shí mâ shwééshá nə́ ndɛɛ́ kə wɔ́ɔ́s jwɔ̂w nyə á kə lwóya nyúúl kúl búúd jé dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Í á zə bə mə́nɨ mwɔ̂w dɨ, *Káázɛl Ogust nyə á cilə nə́ buud ɔ shí mishwun bɛ̂sh bwə́ kə́g cilya ílâŋ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ilâŋ bwɛlɛ́lə sɨ̂y wə́ cɨ́. Í á bə Kirínus njúl ŋgwə́mʉna á faan lʉ́ Sirî. ");
INSERT INTO mcp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ntɔ́ buud bɛ̂sh bwə́ á ka kə ŋgə cilya, muud kə ŋgwə́la í dʉ́gyá nə bɛɛnd jé yííd. ");
INSERT INTO mcp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yósɛb mú nə́mə́ tɨ́ Nazarɛ̂t faan lʉ́ Galilê, bád kə Betʉlehɛm, ŋgwə́la mə *Dávid faan lʉ́ Yudéa, nəcé nyə á bə mwân á njɔ́w búúd mə Dávid. ");
INSERT INTO mcp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nyə á ŋgə kə ílâŋ dɨ́, bá Maríya, mudá í á bə nə́ bá bwə́ zə́ béya yɛ́, Maríya wɔɔŋg njúl nə bum. ");
INSERT INTO mcp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Í á ka bə, bwə́ njúl nûŋ, fwála lʉ byɛyí mú wɔ́ɔ́s Maríya. ");
INSERT INTO mcp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A mú byá mwân yé acúmbâ, mwámudûm. A mú wá nyə bwə́mád a bwɨ́ɨ́g nyə kʉ́l bwə́ á dʉ wá itɔw idʉ̂w nə́ í dʉ́g də yí, nəcé bwə́ áshígɛ́ bə nə bwágə́ njɔ́w ójôŋ. ");
INSERT INTO mcp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Obaagʉlə ɔ́ itɔw bwə́ á bə shí nyɔɔŋgʉ́d bwə́ ŋgə́ ji mifum tɔ́ɔ́n íbugád ŋgə́ baagʉlə itɔw byáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ŋgwɔ́l *éŋgəles mə Yawé mú zə wɔ́ɔ́s bwo na, məŋkənʉwa mə Cwámba mə́ mú lyɛ̧ bwo nə məŋkɛnya nə́ kɛsh. Ifwaas í músə jág bií bwo. ");
INSERT INTO mcp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Njɨ, éŋgəles mú cɨ nə bwo nə́: «Kúgá fúndə, nəcé mə ŋgə zə bɨ́ nə jɔ̧jɔ̧ kɛ́ɛl í é sá kúl búúd jɛ̂sh məma mə́shusʉg yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cʉgye mə́ byɛ̂l bɨ́ múús ŋgwə́la mə *Dávid. Nyə wə́ *Krîst Cwámba. ");
INSERT INTO mcp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bɨ é yag nyə nə məyɨɨgyé mə́ga: bɨ é kwey kʉ́kény í mbwúg bwə́mád kʉ́l bwə́ dʉ wá itɔw idʉ̂w nə́ í dʉ́g də yí.» ");
INSERT INTO mcp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Seegya nə́ kúdə zhwog wəéŋgəles wâ gwɔ̂w bwə́ mú zə kwey nyɨ́nɨ bwə́ ŋgə́ yə Zɛmbî gúmə́ sʉsad nə́: ");
INSERT INTO mcp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Zɛmbî bə́g nə gúmə́ joŋ á gwɔ́w-gwɔ́wʉ́d; wa shí, buud Zɛmbî mə́ gwág nywa wá bwə́ cʉ́gəg nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Í mú zə bə nə́, ja wəéŋgəles bwə́ mə́ béégya nə bwo kə joŋ dɨ́ yí, obaagʉlə ɔ́ itɔw bwə́ mú cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Sə́ kə́gá Betʉlehɛm kə dʉ́g sâ í mə́ sɨ̂y Zɛmbî mə́ sá nə́ sə́ mpúg ga.» ");
INSERT INTO mcp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bwə́ mú ŋgə kə nə́ cá-câ, bwə́ mú kə kwey Maríya nə Yósɛb nə kʉ́kény í mbwúg kʉ́l bwə́ dʉ wá itɔw idʉ̂w nə́ í dʉ́g də yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ja bwə́ mə́ dʉ́g nyə yí, bwə́ mú bwiiŋg sâ éŋgəles nyə́ ámə jaaw bwo shú mə́ múmwán jɔɔŋg yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Buud bɛ̂sh bwə́ á ŋgə gwág bwo wá bwə́ á ŋgə bul káam sâ bwə́ á ŋgə bwiiŋg yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríya nyɛ nyə á baagʉlə isâ byɔɔŋg lámʉ́d, a ŋgə́ bigas byo. ");
INSERT INTO mcp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nə́ ndɛɛ́ obaagʉlə ɔ́ itɔw bwə́ mú nyiŋgə bwə́ ŋgə́ yə Zɛmbî gúmə́, ŋgə yə nyə məshwúmb nə isâ byɛ̂sh bwə́ ámə gwág nə dʉ́g yí, nəcé í á bə nə́mə́ njɨ nda éŋgəles nyə á jaaw bwo nə́. ");
INSERT INTO mcp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ja jwɔ̂w lʉ́ mwɔɔmb í á wɔ́ɔ́s yí, í mú bə fwála nə́ bwə́ sáág mwân ábɨwáág. Bwə́ mú gwiid nyə nə́ Yésus, jínə́ éŋgəles nyə á jaaw Maríya a kú fwo ŋwa bum yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nə́ ndɛɛ́ í mú zə bə fwála nə́ bwə́ sáág ŋgusa íci Moyîz nyə a cɨ yí. Bwə́ mú bád kə nə mwân Yurʉ́səlɛm kə́lə lwóya nyə wə́ Yawé, ");
INSERT INTO mcp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","nə́mə́ nda jɨ́ cilyá *mbwoomb mə́cɛ̧ɛ̧ dɨ́ nə́, nə́: «Mwámudûm yɛ̂sh mə tɛ́ɛ́d byɛ̂l yɛ́, bwə́ kənd nyə koogʉ́ nə́ a bə́g shú mə́ Yawé.» ");
INSERT INTO mcp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Í á jɨɨ nə́ bwə́ kə́g yána ílɨ́ɨ́m í *mə́túnʉga nə́mə́ nda jɨ́ cilyá nda mbwoomb mə́cɛ̧ɛ̧ dɨ́ nə́, bwə́ kə nə məwúwo məbá ŋkí icwɔ̧ í mə́faf íbá. ");
INSERT INTO mcp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ŋgwɔ́l múúd nyə á dʉ bə Yurʉ́səlɛm nə́ Símʉyon. Nyə á bə tʉ́təlí muud, nyə a wá lâm wə́ Zɛmbî. Nyə á bə nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim. Nyə á dʉ bwánd muud nyə á bə nə́ a bá zə səl *Izʉrəyɛ̂l milâm shí yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ŋkɛ̧́ŋkɛ̧̂ Shíshim í á lwágʉlə nyə ntámə́d nə́ nyə abʉ́lɛ yə a kú fwo dʉ́g *Krîst Yawé mə bá ntɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Muud wɔɔŋgʉ̂ Ŋkɛ̧́ŋkɛ̧̂ Shíshim í á sá nə́ a kə́g *Luŋ mə́ Zɛmbî. Ja óbyɔ̂l ɔ Yésus bwə́ á zə nə mwân Luŋ nə́ bwə́ zə́ sá nyə nda mbwoomb mə́cɛ̧ɛ̧ í ŋgə́ cɨ nə́, ");
INSERT INTO mcp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","nyə á ŋwa mwân nyə́dɨ́ mə́bwə́d a mú yə Zɛmbî cúncɛ́sh, nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Mása, jaá ga í músə wo je bɨ́d nə́ lwaá dwô í yə́g nə́ shɛɛ nda wó á cɨ nə́, ");
INSERT INTO mcp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","nəcé mísh mâm mə́ mə́ dʉ́g nda wó zə́ cʉg sə́ nə́, ");
INSERT INTO mcp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","cʉgʉ́lə wó á kwəmʉsa ikûl í búúd byɛ̂sh í ŋgə́ dʉ́g yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jísə məŋkɛnya mə́ bá sá nə́ ikúl íshús í mpúg wo yí, kûl gwô Izʉrəyɛ̂l í bə́g nə gúmə́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yésus sɔ́ɔ́ŋgʉ́ nə nyɔɔŋgʉ́ bwə́ á ŋgə káam sâ jɛ̂sh Símʉyon nyə á ŋgə cɨ shú dɛ́ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Símʉyon mú bwádan nə bwo, nyə nə Maríya nyɔɔŋgʉ́ mə Yésus nə́: «Mwân ɛ́ga Zɛmbî mə́ ntɨ́ nyə nə́ a zə́g sá nə́ zhwog buud ɔ Izʉrəyɛ̂l bwə́ bʉ́lág, zhwog buud wɔɔl. A bá bə gúl sâ mə́ Zɛmbî í bá ntɔ̧ búúd ŋkul yí, sâ búúd bwə́ ábʉ́lɛ magʉlə yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A bá zə sá nə́ zhwog buud mitə́dʉ́gá myáŋ mí mpúyʉ́g. Wɛɛ ntâg ɨɨ́, məcɛy mə́ bá nyisʉli wo lámʉ́d nda kafwɛlɛ.» ");
INSERT INTO mcp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ŋgwɔ́l *múúd micúndə́ ámudâ nyə á bə nə́mə́ cínɔŋg nə́ Ana, a njúl shilə mə Fanuɛ̂l bɛɛnd mə́ Azɛr dɨ̂. Mudá wɔɔŋgʉ̂ nyə á bə a mə́ bul jaas. Nyə a béya a mú cʉgə nə ŋgwûm mimbû zaŋgbá. ");
INSERT INTO mcp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nyə á ji kúsə kə wɔ́ɔ́s mimbû məwûm mwɔɔmb nə mínɔ̧̂. Nyə a shígɛ́ dʉ bwɛlɛ́ kə shwóg-shwóg nə Luŋ mə́ Zɛmbî. Nyə á dʉ sá Zɛmbî isɛ́y byé nə mwásə́ nə bulú a dʉ́gə́ ci ídʉ̂w, dʉ yə Zɛmbî gúmə́. ");
INSERT INTO mcp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nyə á bə nə́mə́ cínɔŋgʉ́ ja bwə́ á bə nə Yésus Luŋ yí, a mú yə Zɛmbî akíba; buud bɛ̂sh bwə́ á ŋgə bwánd nə́ Zɛmbî mə bá zə yîl Yurʉ́səlɛm mə́nyámád wá, Ana nyə á ŋgə jaaw lâŋ mə́ mwân. ");
INSERT INTO mcp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja óbyɔ̂l ɔ Yésus bwə́ á shîn sá isâ byɛ̂sh Mə́cɛ̧ɛ̧ mə́ Yawé mə́ ŋgə́ cɨ yí, bwə́ á ka nyiŋgə kə bwə́dɨ́ ŋgwə́la Nazarɛ̂t, faan lʉ Galilê. ");
INSERT INTO mcp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwân nyə á ka nə́mə́ ŋgə wɨ̂y, *shíshim yé ŋgə́ ŋwa ŋkul, a njúl mpaam mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Obyɔ̂l ɔ Yésus bwə́ á dʉ kə zâŋ páska dɨ́ Yurʉ́səlɛm mbû wɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bwə́ á ka nə́mə́ kwo bád kə nda fúlú í á bə nə́, Yésus njúl mimbû wûm nə mímbá, bwə́ mú kə nə nyə. ");
INSERT INTO mcp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ja zâŋ í á shîn yí, obyɔ̂l bɛ́ bwə́ mú nyiŋgə. Yésus mú lʉ́g Yurʉ́səlɛm bwə́ kú mpu. ");
INSERT INTO mcp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bwə́ á ŋgə tə́dʉga nə́ Yésus bə́nɔ̂ŋ buud ɔ́ gwooŋg bʉ́sə zhɨ́ɨ́d. Bwə́ músə kyey mwásə́ ncindî. Nə́ ndɛɛ́ bwə́ mú ka zə ŋgə sɔ̧́ nyə mímbyɛ̂l nə mímbií myáŋ dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nda bwə́ áshígɛ́ kwey nyə nə́, bwə́ mú nyiŋgə nə məsɔ̧́ɔ̧́gʉ́ kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Í á ka zə bə, bwə́ mə́ sɔ̧́ nyə nə́ sɔ̧̂ sɔ̧̂ tâŋ mwɔ̂w mə́lɔ́ɔl, bwə́ mú kə kwey nyə a njúl tâm oyɨ́ɨ́gʉli ɔ mə́cɛ̧ɛ̧ *Luŋ mə́ Zɛmbî, a ŋgə́ gwágʉlə bwo, a ŋgə́ jí bwo minjígá. ");
INSERT INTO mcp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Buud bɛ̂sh bwə́ á ŋgə gwág nyə wá bwə́ á ŋgə káam fʉ́g nyɛ́ nə məmpɛ̧sá mɛ́. Bwə́ á ŋgə káam mbií á nə́ fʉg dʉ jímb lúúd. ");
INSERT INTO mcp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ja óbyɔ̂l bɛ́ bwə́ á dʉ́g nyə yí, bwə́ á jág bul káam. Nyɔɔŋgʉ́ mú cɨ nə nyə nə́: «Mwân waam, jɨ́ wó mə́ sá sə́ ntʉ́nɨ nɨ? Wo mpú nə́ sá shwóóŋgʉ̂ sə́ mə́ ŋgə sɔ̧́ wo nə milâm gwɔ̂w?» ");
INSERT INTO mcp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nyɛ mú cɨ nə bwo nə́: «Bɨ́ ámə ŋgə sɔ̧́ mə nə jɨ́? Bɨ ampúyɛ́ nə́ mə́ jəlá nə dʉ bə ísâ í Dâ dɨ?» ");
INSERT INTO mcp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Njɨ bâŋ bwə́ áshígɛ́ mpu gwág sá nyə á cɨ nə bwo yí. ");
INSERT INTO mcp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yésus bə́nɔ̂ŋ bwo bwə́ mú shulə kə Nazarɛ̂t, a ŋgə́ magʉlə ijwûga byáŋ. Nyɔɔŋgʉ́ mú baagʉlə ísâ ínɨ byɛ̂sh lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yésus nyə á ka ŋgə wɔɔf, fʉg ŋgə kwɨ́dʉli, mpaam mə́ Zɛmbî ŋgə́ kwɨ́dʉli, a ŋgə́ bə jɔ̧ kágə́ mísh mə́ Zɛmbî nə mísh mə́ búúdʉd. ");
INSERT INTO mcp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Í á ka zə bə, ijwûga í *Káázɛl Tibɛr í mə́ wɔ́ɔ́s mbû wûm nə tɔ́ɔ́n dɨ̂, Pons Pilât mú bə ŋgwə́mʉna á faan lʉ́ Yudéa, Herod nyə Tatarâk á Galilê, mínyɔŋʉ̂ yé Fílíp nə faan lʉ́ Ityurê nə Trakonitídí, Lisanʉyas nə faan lʉ́ Abilɛn. ");
INSERT INTO mcp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Í á bə Hána njúl Ajəlácɨ á ofada, bá Kayíf. Ja jɔɔŋgʉ̂, kɛ́ɛl mə́ Zɛmbî í á wɔ́ɔ́s wə́ Yuánɛs mwân mə́ Zakarî a njúl shí a shwééshád. ");
INSERT INTO mcp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nyə á ka zə ŋgə kyey shí nyɛ̂sh á fundú ŋgwɔ̧ɔ̧́ Zhurdɛ̧̂, ŋgə cúndə nə́: «Cɛ́ndʉ́gá mitə́dʉ́gá, bɨ́ duwan, Zɛmbî nyə é juu bɨ́ nə *misə́m mín.» ");
INSERT INTO mcp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Í á bə ntɔ́ nda jísə́ cilyá kálaad mə *múúd micúndə́ Izayí dɨ́ nə́. Nəcé jísə nə́: Muud ŋgə cúndə shí a shwééshád, a ŋgə cɨ nə́: «Kwambʉləgá zhɨ́ɨ́ mə́ Cwámba, bɨ́ sʉ́g kwûŋ jé. ");
INSERT INTO mcp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bʉlalʉgá ibɨ́ɨ́ byɛ̂sh, bɨ́ bwú mímbʉ́ŋ mí anʉ́nɨ̂ nə mi acíg-cíg myɛ̂sh səl shí, bɨ́ sʉ́g mə́búgə. Sandʉləgá ikʉ́l í ákukwowʉlâ, sá byo nə́ səndôŋ ");
INSERT INTO mcp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","muud yɛ̂sh ka bá dʉ́g cʉgʉ́lə Zɛmbî mə bá cʉg búúd yí.» ");
INSERT INTO mcp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Buud bwə́ á dʉ zə wə́ Yuánɛs áncuncuma zə́lə dʉ duwan wá, nyə á ka dʉ cɨ nə bwo nə́: «Yé iyəlʉkag íga! Bɨ mə́ bə́lɛ fúndə mpimbə Zɛmbî mə́ bá lwóya yí? Zə́ ámə kɛ́wʉli bɨ́ ɛ́nɛ? ");
INSERT INTO mcp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kágá wúmə fwámɛ́ mpúmə́ í lwágʉ́lə́ nə́ bɨ mə́ cɛ́nd mítə́dʉ́gá yí. Kúgá bɛ̧ njɨ dʉ́lə tə́dʉga nə́: “Sə́ bâŋ sə́ bɨ́ mpwoŋ buud mə́ *Abʉraham” nəcé mə mpú jaaw bɨ́ nə́ Zɛmbî jɨ nə ŋkul shwɔ̧́ɔ̧la mə́kwóógʉ́ mə́ga, sá mwo bwân ɔ́ Abʉraham. ");
INSERT INTO mcp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mpugá nə́ zʉ̂ŋ í wál zə sámb míkɔ̧ɔ̧lə́ mí ílɨ́ɨ́ mə́shugʉd. Bwə́ é cal lɨ́ɨ́ jɛ̂sh í ádɛ́ wúmə fwámɛ́ mpúmə́ yí, bwə́ kʉl gwo kudad.» ");
INSERT INTO mcp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Buud bwə́ mú zə jî nyə nə́: «Sə́ mə́ jəlá nə sá jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A mú bɛ̧sa nə bwo nə́: «Muud jɨ́ nə ishimí íbá yɛ́ kɛ́ɛ́nzhʉg ŋgwûd yə nyɔɔŋg cúgɛ́ nə ndɨ̂ yɛ́. Muud jɨ́ nə idʉ̂w yɛ́ sáág nə́mə́ ntɔ́.» ");
INSERT INTO mcp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Oŋwɛnyɛ ɔ tóya bwə́ mú nə́mə́ zə nə́ bwə́ zə́ duwan. Bwə́ mú jî nyə nə́: «Yɨ́ɨ́gʉli e, sə́ mə́ jəlá nə sá jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nyə nə bwo nə́: «Dʉgá jî búúd njɨ sâ mə́cɛ̧ɛ̧ mə́ yə́ bɨ́ ŋkul nə́ bɨ dʉ́g jî yí, bɨ kú ntɛɛŋg.» ");
INSERT INTO mcp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ozɨmbɨ bwə́ mú nə́mə́ jî nyə nə́: «Sə́ bâŋ sə́ mə́ jəlá nə sá jɨ́?» Nyə nə bwo nə́: «Kúgá mánda múúd nə sâ jé ŋkí ntâg nə́ bɨ mə lwó múúd mpə̂l. Magʉləgá nə́ myə́na bwə́ ŋgə́ jə́na nə bɨ́ má mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nda búúd bwə́ á ŋgə bwánd bwə́ ŋgə́ tə́dʉga nə́ Yuánɛs ɔ mə́ jéé bə Mesî nə́, ");
INSERT INTO mcp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yuánɛs nyə á cɨ nə bwo nə́: «Mɛɛ mə ŋgə duu bɨ́ nə məjúwó. Njɨ ŋgwɔ́l múúd ŋgə zə, a jɨ nə mpífə́ cɔ̧́ mə. Mə ampíyáyɛ́ nə́ mə cínyʉg nyə mikwoolú mí mə́ŋgwub. Nywáá mə́ bá duu bɨ́ nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə kuda. ");
INSERT INTO mcp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A mbid fwafʉga mbwə́d. A bá zə bɛ́ɛ́g búúd nda bwə́ dʉ fyaf ŋkwáándə́ nə́; a ŋwa fwámɛ́ mpúmə́ wá ŋkundá dɛ́d, a yîl ílwáásə́ shwu kuda jɨ́ kú bwɛlɛ jímə yííd.» ");
INSERT INTO mcp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yuánɛs nyə á kwo nə́mə́ ŋgə jaaw bwo Jɔ̧jɔ̧ Kɛ́ɛl, a ŋgə́ yáág nə bwo nə́ bwə́ mágʉləg. ");
INSERT INTO mcp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Í á ka zə wɔ́ɔ́s nə́, nyə á jum Herod á Tatarâk nəcé lə́sʉ́ mə́ Herodyâd, mudá mə́ mínyɔŋʉ̂ nə mɔ́ɔ́l mə́bɔ̂w mɛ̂sh nyə á dʉ sá má. ");
INSERT INTO mcp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod mú kwádʉlə dúl bɔ̂w cínɔŋg gwɔ̂w, wá Yuánɛs mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Í á ka bə gúl ja nə́, nda búúd bɛ̂sh bwə́ á ŋgə duwan nə́, Yésus mú nə́mə́ kə duwan. Nə́ ndɛɛ́, ja nyə á ŋgə jəgʉla yí, joŋ í mú bâŋ, ");
INSERT INTO mcp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ŋkɛ̧́ŋkɛ̧̂ Shíshim mú nyîn nə nyúul nda faf í mú shulə nyə nyúúlʉ́d. Kə́l í mú zhu joŋ dɨ́ nə́: «Wo wə́ Mwân waamə̂ alâm. Lâm wâm wɛ̂sh wúsə wódɨ́.» ");
INSERT INTO mcp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ja Yésus nyə a tɛ́ɛ́d sáal dɛ́ yí, nyə á bə kala múúd á je bə mímbû məwûm mə́lɔ́ɔl. Buud bwə́ á ŋgə tə́dʉga nə́ a jɨ mwân mə Yósɛb, Yósɛb mwân mə Heli, ");
INSERT INTO mcp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mwân mə Matat, Matat mwân mə Lévi, Lévi mwân mə́ Mɛlʉkî, Mɛlʉkî mwân mə Yanay, Yanay mwân mə Yósɛb. ");
INSERT INTO mcp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yósɛb mwân mə́ Matatíyas, Matatíyas mwân mə Amos, Amos mwân mə Nahum, Nahum mwân mə Hɛsʉli, Hɛsʉli mwân mə Nagay, ");
INSERT INTO mcp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay mwân mə Maad, Maad mwân mə Matatíyas, Matatíyas mwân mə Símʉyon, Símʉyon mwân mə Yósɛk, Yósɛk mwân mə Yoda. ");
INSERT INTO mcp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mwân mə Yoanan, Yoanan mwân mə Résa, Résa mwân mə Zorobábɛl, Zorobábɛl mwân mə́ Salátiyɛl, Salátiyɛl mwân mə Neri; ");
INSERT INTO mcp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mwân mə Mɛlʉkî, Mɛlʉkî mwân mə Adi, Adi mwân mə Kosam, Kosam mwân mə Ɛlʉmadam, Ɛlʉmadam mwân mə Ɛr. ");
INSERT INTO mcp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛr mwân mə Yésus, Yésus mwân mə Elyazar, Elyazar mwân mə Yorîm, Yorîm mwân mə Matat, Matat mwân mə Lévi. ");
INSERT INTO mcp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lévi mwân mə Símʉyon, Símʉyon mwân mə Yúda, Yúda mwân mə Yósɛb, Yósɛb mwân mə Yonam, Yonam mwân mə Eliyakim. ");
INSERT INTO mcp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim mwân mə Məleya, Məleya mwân mə Mɛna, Mɛna mwân mə Matata, Matata mwân mə Natan, Natan mwân mə *Dávid. ");
INSERT INTO mcp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dávid mwân mə Yése, Yése mwân mə Yobɛd, Yobɛd mwân mə Bowaz, Bowaz mwân mə Sala, Sala mwân mə Naáson. ");
INSERT INTO mcp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naáson mwân mə Aminadab, Aminadab mwân mə Adʉmin, Adʉmin mwân mə Arni, Arni mwân mə Hesʉron, Hesʉron mwân mə Farɛs, Farɛs mwân mə Yúda; ");
INSERT INTO mcp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yúda mwân mə *Yákwab, Yákwab mwân mə *Izaag, Izaag mwân mə *Abʉraham, Abʉraham mwân mə Tara, Tara mwân mə Nakor; ");
INSERT INTO mcp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor mwân mə Seruk, Seruk mwân mə Ragɔw, Ragɔw mwân mə Falɛk, Falɛk mwân mə Ebɛr, Ebɛr mwân mə Sala; ");
INSERT INTO mcp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mwân mə Kaynam, Kaynam mwân mə Arfagʉsaad, Arfagʉsaad mwân mə Sem, Sem mwân mə *Nówe, Nówe mwân mə Lamɛk; ");
INSERT INTO mcp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛk mwân mə Matusalɛm, Matusalɛm mwân mə Inɔɔg, Inɔɔg mwân mə Yarɛd, Yarɛd mwân mə Malʉlɛɛl, Malʉlɛɛl mwân mə Kaynam. ");
INSERT INTO mcp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam mwân mə Inos, Inos mwân mə Set, Set mwân mə Adam, Adam mwân mə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yésus nyə a wú Zhurdɛ̧̂ a mə́ shîn lwánd nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́. Ŋkɛ̧́ŋkɛ̧̂ Shíshim mú kə nə nyə shí a shwééshád. ");
INSERT INTO mcp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Njwû məjamb mú kə bwɔ́wʉlə nyə wu tâŋ mwɔ̂w məwûm mə́nɔ̧̂. Yésus nyə a shígɛ́ də tɔ́ɔ sâ mwɔ̂w mɔɔŋgʉ́d nə́ ndɛɛ́ ja mwɔ̂w mɔɔŋg mə́ á shîn yí a mú gwág zha. ");
INSERT INTO mcp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Njwû məjamb mú cɨ nə nyə nə́: «Ŋkí wo jɨ *Mwân mə́ Zɛmbî, cɨɨ́g nə kwóógʉ́ ga nə́ í nyɛ́ɛ́g idʉ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yésus mú yidá bɛ̧sa nə nyə nə́: «Jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: “Muud cugɛ́ nə ŋkul cʉgə njɨ nə idʉ̂w”.» ");
INSERT INTO mcp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Njwû məjamb mú kə nə nyə gwɔ́w-gwɔ̂w. A mú lwágʉlə nyə məfaan mâ shí mishwun mɛ̂sh njɨ ja ŋgwúd nə́ cág. ");
INSERT INTO mcp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A mú cɨ nə nyə nə́: «Mə é yə wo ijwûga nə́ wo jwúg nə məfaan mə́nɨ mɛ̂sh wo ŋwa gúmə́ jáŋ, nəcé mə wə́ jɨ́ nə byo. Mə jɨ nə ŋkul yána byo yə múúd yɛ̂sh mə́ cɛ́ɛ́l yə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ntɔ́, ŋkí wo kúd mpwoombʉ́ wa shí yə mə gúmə́, byɛ̂sh í é bə ísâ byô.» ");
INSERT INTO mcp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yésus mú bɛ̧sa nə nyə nə́: «Jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: “Dʉgʉ́ kúd mpwoombʉ́ shí njɨ wə́ Zɛmbî woó Yawé. Njɨ nyə wə́ wó dʉ́g yə gúmə́ yɛ́.”» ");
INSERT INTO mcp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","*Sátan mú kə nə nyə Yurʉ́səlɛm, kə tə̂l nyə zhwááŋgɛ̂ *Mpáánzə́ Zɛmbî dɨ́ gwɔ̂w. A mú cɨ nə nyə nə́: «Ŋkí wo jɨ Mwân mə́ Zɛmbî, bɨ́dʉ́g nyúul wú wa kə kud shí, ");
INSERT INTO mcp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","nəcé jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: “Zɛmbî mə bá lésha nə *wəéŋgəles bɛ́ nə́ bwə́ báágʉləg wo. ");
INSERT INTO mcp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bwə́ é ŋkɛ̂ny wo mə́bwə́d, kuú wô í nda bwɨɨm bɔɔgʉ́.”» ");
INSERT INTO mcp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yésus mú bɛ̧sa nə nɛ́ nə́: «Ciyá jísə nə́: “Wo ajə́láyɛ́ nə bwɔ́wʉlə Zɛmbî woó Yawé”.» ");
INSERT INTO mcp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ja Njwû məjamb mə́ shîn bwɔ́wʉlə Yésus mimbii myɛ̂sh ntʉ́nɨ yí, a mú kyey béégya nə Yésus, kə bwánd ja fwámɛ́ fwála í bá bə yí. ");
INSERT INTO mcp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yésus mú nyiŋgə kə Galilê a njúl nə ŋkul á Ŋkɛ̧́ŋkɛ̧̂ Shíshim. Jínə́ dɛ́ í mú ŋgə jwɔ̧ cínɔŋg yɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nyə á ŋgə yə buud minjɨ́ɨ́gʉ́lá *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ̂, buud bɛ̂sh bwə́ ŋgə́ yə nyə gúmə́. ");
INSERT INTO mcp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nə́ ndɛɛ́ nyə á ka kə Nazarɛ̂t wú nyə á wɔɔf wá. A mú kə nyíi *mpáánzə́ minjɨ́ɨ́gʉ́lá jwɔ̂w lʉ́ Sábaad nda nyə á dʉ bwey sá nə́. Nyə á ka tɔ̂w tʉ́təlí nə́ a lɔ̧́ Kálaad Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bwə́ mú yə nyə ŋgwɔ́l kálaad Izayí *muud micúndə́ nyə á cilə yɛ́. A mú wɛɛf kálaad nə́ ndɛɛ́ a mú kwey kʉ́kʉ́l jísə cilyá nə́: ");
INSERT INTO mcp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Shíshim mə Yawé wúsə mə́dɨ́ nəcé nyə a gwáágʉlə mə məwúdə nə́ mə zə́g bwiiŋg mímbúmbúwá Jɔ̧jɔ̧ Kɛ́ɛl. Nyə á ntɨ mə nə́ mə zə́g jaaw mímbwug nə́: «Bɨ mə́ wú mímbwug dɨ̂», mə jaaw wə́ancím-ncîm nə́: «Mísh mə́ mə́ bâŋ bɨ̂». Nyə á ntɨ mə nə́ mə zə́g fɛɛmʉshi búúd bwə́ cúgɛ́ nə ŋkul shwɔ̧ mə́nyúúl wá, ");
INSERT INTO mcp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mə zə cúndə mbû Yawé mə bá lwóyá mpáam yí. ");
INSERT INTO mcp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nyə á ka fʉ́lə kálaad nə́ ndɛɛ́ a mú yə fulísh á *Mpáánzə́ Zɛmbî, a mú ji shí. Buud bɛ̂sh bwə́ á bə mpáánzə́ minjɨ́ɨ́gʉ́lá wá bwə́ mú mpu kənd mísh nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A mú tɛ́ɛ́d lásʉ́lə nə bwo, nyə nə́: «Kʉ́kʉ́l mícilyá mí Kálaad Zɛmbî bɨ́ ámə gwág mə́ ámə lɔ̧́ nɨ í mə́ bwəma múús.» ");
INSERT INTO mcp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Buud bɛ̂sh bwə́ á ŋgə ságʉsə nyə. Bɛ̂sh bwə́ á ŋgə káam jɔ̧jɔ̧ íciyá í á ŋgə wú nyə́dɨ́ mpu dɨ́ yí, bwə́ ŋgə́ cɨ nə́: «Mwân mə Yósɛb dɨ́ ɛ́ga?» ");
INSERT INTO mcp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A mú cɨ nə bwo nə́: «Mə mpú nə́ bɨ é kənd mə kaanə́ í dʉ cɨ nə́: “Yé jwɔ́wʉda, lwagʉg wómɛ́fwó” yí. Sə́ á shí gwág ísâ wó á sá Kapɛrnawûm yí. Sáág nə́mə́ byo wa wódɨ́ kwáádə́.» ");
INSERT INTO mcp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A mú nyiŋgə cɨ nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bwə́ abwɛ́lɛ́ mpu lə́g múúd micúndə́ nyə́dɨ́ kwáádə́. ");
INSERT INTO mcp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mə́ jaaw bɨ́ bʉ́bə́lɛ́ nə́, ja Eli nyə á bə yí, ja joŋ í á feed tâŋ mimbû mílɔ́ɔl nə oŋkwoond ósaman yáág-yáág zha mú bə shí nyɛ̂sh yí, zhwog mikúsə́ mí búdá mí á bə *Izʉrəyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Njɨ Zɛmbî nyə a shígɛ́ kənd Eli míkúsə́ myɔɔŋg dɨ́! Cwûd! kú bə tɔ́ɔ ŋgwúd dɨ́. Nyə á yida kənd nyə Sarɛ́pʉta, shí í gwág nə Sidon yí, wə́ wúl kúsə́ múdá á nûŋ. ");
INSERT INTO mcp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mizʉ́zaamə́ mí á bə nə́mə́ Izʉrəyɛ̂l ŋkí bulya ja mə́ múúd micúndə́ Elizê nyə á bə yí. Njɨ, ŋgwúd nə ŋgwúd í áshígɛ́ lwəgʉwa; í á bə njɨ Naaman muud á Sirî.» ");
INSERT INTO mcp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Buud bɛ̂sh bwə́ á bə mpáánzə́ minjɨ́ɨ́gʉ́lá wá bwə́ mú nyada nə a lásʉ́lə ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bwə́ mú tɔ̂w shí, wáámb kə nə nyə ŋgwə́la dɨ́ tɔ́ɔ́n, kə bád nə nyə mbʉ́ŋ dɨ́ gwɔ̂w. Ŋgwə́la wɔɔŋg í á bə lwɔ̧́yá mbʉ́ŋʉ́d. Bwə́ mú kə nə nyə wu gwɔ̂w nə́ bwə́ kə́ ságʉwo nyə wusə mbʉ́ŋ dɨ́ shí. ");
INSERT INTO mcp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Njɨ, nywáá mú cɔ̧́ bwo mpə́dʉ́gá nə́ ndɛɛ́ a mú kyey. ");
INSERT INTO mcp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A mú shulə kə Kapɛrnawûm, wúl ŋgwə́la á faan lʉ́ Galilê. A mú dʉ yə búúd minjɨ́ɨ́gʉ́lá mwɔ̂w mə́ ósábaad dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Buud bwə́ mú bul káam mbií nyə á ŋgə jɨ́ɨ́gʉli yí, nəcé ciyá jé í á dʉ bə nə kɛ́ɛ́nd. ");
INSERT INTO mcp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ŋgwɔ́l múúd nyə á ka bə *mpáánzə́ minjɨ́ɨ́gʉ́lá a njúl nə bɔ́w-bɔ̂w shíshim jamb, a mú kɨ̂m nə ŋkulû nə́: ");
INSERT INTO mcp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Eéékyé! Yé Yésus muud á Nazarɛ̂t! Shé bâŋ nə inɛy? Ye wo ámə zə jaŋgʉlə sə̂? Mɛɛ mə mpú wo. Wo wə́ fééshá múúd mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yésus mú ŋkáánd nə jamb nə́: «Fadʉg mpu! Wúg múúd ɛ́nɛ nyúúlʉ́d!» Jamb í mú wusə múúd wɔɔŋg shí na tâm buud. Í mú wú nyə nyúúlʉ́d kú sá nyə məbɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Buud bɛ̂sh bwə́ mú bul káam, bwə́ ŋgə́ cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Wáyɛ́ mbií lə́sʉ́ wɨ́ nə kɛ́ɛ́nd nə ŋkul ijwûga ntʉ́ga ga? Muud ɛ́ga mə ŋkáánd nə bɔ́w-bɔ̂w míshíshim, mí wú?» ");
INSERT INTO mcp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jínə́ dɛ́ í mú jwɔ̧ kʉ́kʉ́l jɛ̂sh faan dɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yésus nyə á ka wú *mpáánzə́ minjɨ́ɨ́gʉ́lá, a mú kə Shímun dɨ́ njɔ́w. Shímun wɔɔŋgʉ̂ ayɔ̂ŋ nə yɔ̂ŋ nyə á bií cii yé á mudá nə́ táás. Bwə́ mú cɨ nə́ Yésus nə́ a sáág sâ shú dɛ́d. ");
INSERT INTO mcp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yésus mú shísh kə jwaagʉwo nyə́dɨ́, ŋkáánd nə ayɔ̂ŋ nə yɔ̂ŋ. Ayɔ̂ŋ nə yɔ̂ŋ mú bɨ́d nyə. Mudá wɔɔŋg mú wɔɔl cé nə cé tɛ́ɛ́d ntâg ŋgə́lə ŋwa njugú wáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ja jwɔ̂w í á ŋgə jímə yí, buud bɛ̂sh bwə́ á bə nə mimbə̂l mimbií mimbií wá bwə́ á zə nə myo wə́ Yésus. A mú ŋgə bəd myo məbwə̂ nə́ ndɛɛ́ mí ŋgə́ yâl. ");
INSERT INTO mcp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Zhwog buud məjamb mə́ á ŋgə wú mə́ ŋgə́ kɨ̂m nə́: «Wo jɨ *Mwân mə́ Zɛmbî.» A mú ŋgə ŋkáánd nə mwo, a kú magʉlə nə́ mə́ ŋgə́g nə lás ntɔ́, nəcé mə́ á ŋgə mpu nə́ a jisə *Krîst. ");
INSERT INTO mcp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ja mán í á lə̂m yí, Yésus nyə a cúwo tɔ́ɔ́n kə kʉ́l búúd bwə́ áshígɛ́ bə yí. Buud bwə́ mú ka kə sɔ̧́ nyə áncuncuma nə́ ndɛɛ́ bwə́ mú kə kwey nyə. Bwə́ mú cɛɛl bií nyə nə́ a kú ná kwo béégya nə bwo. ");
INSERT INTO mcp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A mú cɨ nə bwo nə́: «Í jɨɨ nə́ mə kə́g nə́mə́ bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛl á Faan mə́ Zɛmbî míl míŋgwə́lad. Gwə́ wə́ nyə á ntɨ mə nə́ mə zə́g sá yí.» ");
INSERT INTO mcp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nyə á ka kə ŋgə cúndə *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn mâ Yudéa dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dúl jwɔ̂w, Yésus nyə á bə a tə́l bwûŋ lʉ́ cwoogʉ́ cíndú á Genezarɛ̂t; buud bwə́ á ka zə bul shúsə nyə ŋgə́lə gwágʉlə Milə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A mú dʉ́g mɔ́ɔ́l mə́bá na ncindye cwoogʉ́d. Buud ɔ́ shwey bwə́ á shulə mɔ́ɔ́l mɔɔŋgʉ́d, bwə́ ka ŋgə gusa məwód máŋ. ");
INSERT INTO mcp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yésus mú kəwa dúl byɔ́ɔl dɔɔŋgʉ́d. Dâŋ í á bə dɛ́ mə Shímun. A mú cɨ nə Shímun nə́ a wúg nə byɔ́ɔ́l bwúŋʉ́d shísh ŋgɛɛ́ bwag. A mú ji shí na byɔ́ɔ́lʉ́d ka ŋgə yə buud minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ja nyə á yɔw lásʉ́lə yí, nyə á cɨ nə Shímun nə́: «Sʉ́sálʉ́g byɔ́ɔ́l dwô kʉ́l jɨ́ ŋkí jímə yí bɨ wúsəg məwód mə́júwód nə́ bwə́ julə óshû.» ");
INSERT INTO mcp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Shímun mú bɛ̧sa nə nyə nə́: «Mása, sə́ mə́ ntʉ̂ŋ búlú ncindî kú bií tɔɔ sâ. Mə zə́ wusə mə́wód njɨ nəcé wo mə́ cɨ.» ");
INSERT INTO mcp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bwə́ mú wusə mə́wód nə́ ndɛɛ́ bwə́ mú bii ncúlyá oshû, məwód mə́ ŋgə́ nyɛy. ");
INSERT INTO mcp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bwə́ mú dʉ mas búúd ɔ́ gwooŋg báŋ bwə́ á bə dúl byɔ́ɔ́lʉ́d wá məbwə̂ nə́ bwə́ zə́g kwíínd bwo. Bwə́ mú zə, bə́nɔ́ŋ bwə́ mú wá óshû mə́bá mɛ̂sh dɨ́ nə́ ndɛɛ́ mə́ mú tɛ́ɛ́d nə́ mə́ nyasʉla mə́júwód. ");
INSERT INTO mcp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nda Shímun Pyɛ̂r nyə á dʉ́g ntɔ́ nə́, nyə á zə kúd Yésus məbwóŋ shí, nyə nə́: «Cwámba, wúg mə kúnə́-kúnə nəcé mə jɨ sɔ́ɔl *misə́m.» ");
INSERT INTO mcp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wɔɔŋg mbií bwə́ á bii oshû yí í á sá bə́nɔ̂ŋ buud bɛ́ bɛ̂sh iŋkuŋkúúnd. ");
INSERT INTO mcp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tɛɛm bə Zhâk bá Yuánɛs bwân ɔ́ Zhébedé bwə́ á bə buud ɔ́ gwooŋg ɔ Shímun wá bwə́ á bə nə́mə́ nə iŋkuŋkúúnd. Nə́ ndɛɛ́ Yésus mú cɨ nə Shímun nə́: «Kú bɛɛg fúndə, tɛ́ɛ́d fwála gaád wo zə́ bá dʉ julə búúd.» ");
INSERT INTO mcp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bwə́ mú zə nə mɔ́ɔ́l cíndú nə́ ndɛɛ́ bwə́ lʉ́gə ntâg isâ byɛ̂sh, bɛ̧ Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na gúl ja, Yésus nyə á bə wúl ŋgwə́la dɨ̂. Ŋgwɔ́l múúd nyə á bə cínɔŋgʉ́ nə zaamə́ nyúúlʉ́d nə́ jəəd. Ja múúd wɔɔŋg nyə á dʉ́g Yésus yí, nyə á lɛɛl zə jwaagʉwo kúd mpwóómbʉ́ mə́ndəlúd, jəgʉla nə nyə nə́: «Cwámba, ŋkí wó magʉlə wo je lwag mə, nyúúl bə mə nə́ səndôŋ.» ");
INSERT INTO mcp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yésus mú sɛ́ɛ́mb mbwə̂, kúnya nə nyə, cɨ nə nyə nə́: «Mə́ magʉlə. Nyúúl í bə́g wo nə́ səndôŋ!» Cé nə cé, zaamə́ í mú shîn wú muud ɛ́nɛ nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Njɨ Yésus mú tə̂l nyə mpə́ndí nə́ ci a kú jaaw tɔɔ muud sâ í mə́ sɨ̂y yí. Nyə nə nɛ́ nə́: «Yidag kə lwágʉlə fada nda wó músə́ nə́, wo ka wá sâ Moyîz nyə á cɨ yí shú yálʉ́lə wó mə́ yâl nɨ. Bwə́ mpúg nə́ wo mú mpwogɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lâŋ mə́ Yésus í mú ŋgə bul kyey, buud bwə́ mú bul ŋgə sɛɛŋgya áncuncuma, ŋgə zə gwágʉlə nyə, ŋgə nə́mə́ zə lwəgʉwa məbwas máŋ. ");
INSERT INTO mcp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Njɨ, nyɛ mú kə, nyə́mɛ́fwó íkʉ́l í áshígɛ́ bə nə buud yí, kə jəgʉla nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yésus nyə á ŋgə yə buud minjɨ́ɨ́gʉ́lá dúl jwɔ́wʉ́d. Bɔ́ɔ́l *Ofarizyɛ̂ŋ nə *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ bwə́ á zhu mílɔɔm myɛ̂sh myâ Galilê nə Yudéa, bɔ́ɔ́l zhu nə́mə́ Yurʉ́səlɛm. Yésus nyə á bə nə ŋkul mə Cwámba shú nə́ buud məbwas mə́ ŋgə́g nə yâl. ");
INSERT INTO mcp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ká dʉ́g nə́, bɔ́ɔ́l búúd bwə́ mú wɔ́ɔ́s bwə́ ŋgə́ ŋkɛ̂ny mbúmbwúgʉ́ táádə́d. Bwə́ mú ŋgə sɔ̧́ nə́ bwə́ nyíŋgál nyə njɔ́w kənd nyə kʉ́l Yésus nyə á bə yí. ");
INSERT INTO mcp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bwə́ áshígɛ́ ka bə nə wú bwə́ nyíŋgálʉ́g nyə, nəcé buud bə́lə áncuncuma. Bwə́ mú ntâg bád nə nyə kwáminʉ́ kə cúwo luun nə́ ndɛɛ́ bwə́ shul nyə nə táádə́ jé wə́ Yésus na tâm buud. ");
INSERT INTO mcp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yésus mú dʉ́g nə́ buud bɔɔŋgʉ́ bʉ́sə nə fwámɛ́ búgə́, a mú cɨ nə́: «Amudûm, mə mə́ juu wo nə *misə́m myô.» ");
INSERT INTO mcp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","*Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ Ofarizyɛ̂ŋ bwə́ mú tɛ́ɛ́d ŋgə́lə lás bwə́mɛ́ nə bwə́mɛ́ nə́: «Wáyɛ́ múúd ŋgə́ *lás nə Zɛmbî bwaasʉ́lə mpu ɛ́ga? Ŋgwɔ́l zə́ jɨ́ nə ŋkul juu búúd nə misə́m myɛ́d kwoŋ Zɛmbî nyəmɛ́fwó?» ");
INSERT INTO mcp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yésus músə mpu sâ bwə́ á ŋgə tə́dʉga yí, a mú lás nə bwo nə́: «Jɨ bɨ́ ŋgə́ cɨ bɨ́dɨ́ mílámʉ́d yí? ");
INSERT INTO mcp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Jɨ́ í búl bə kúnə́-kúnə? Ye cɨ́lə nə muud nə́: “Mə mə́ juu wo nə misə́m myô”, ye nə́: “Wɔɔlʉ́g, wo kyéyʉg?” ");
INSERT INTO mcp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mə́ ka cɛɛl nə́ bɨ mpúg nə́ *Mwân mə Múúd jɨ nə ŋkul ijwûga nə́ a juu búúd nə misə́m myáŋ wa shí.» Ntɔ́, Yésus mú yid wə́ mbúmbwúgʉ́, nyə nə nyə nə́: «Mə́ cɨ nə wo nə́, wɔɔlʉ́g, wo ŋkɛ́nyʉ́g táádə́ gwô, wo nyíŋgəg kə njɔ́w.» ");
INSERT INTO mcp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nə́mə́ cé nə cé, mbúmbwúgʉ́ mú wɔɔl bwə́ ŋgə́ dʉ́g, a mú ŋkɛ̂ny táádə́ jé, kyey kə njɔ́w a ŋgə́ yə Zɛmbî gúmə́. ");
INSERT INTO mcp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Buud bɛ̂sh bwə́ mú káam mbií á nə́ fʉg dʉ jímb lúúd. Bwə́ mú yə Zɛmbî gúmə́ bwə́ mú bul bə nə ifwaas, bwə́ mú ŋgə lás nə́: «Sə́ mə́ dʉ́g *ísâ í mímbʉ́gú múús.» ");
INSERT INTO mcp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ja ísâ ínɨ í mə́ shîn yí, Yésus mú cúwo tɔ́ɔ́n, a mú dʉ́g ŋwɛnyɛ tóya bwə́ á dʉ jɔ̂w nə́ Lévi yɛ́ njúl kʉ́l bwə́ á dʉ jə́na tóya yí. Yésus mú cɨ nə nyə nə́: «Bɛ̧g mə.» ");
INSERT INTO mcp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lévi mú lʉ́gə ísâ byɛ̂sh, tɔ̂w bɛ̧ Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A mú kə sá məma dína nyə́dɨ́ njɔ́w. Oŋwɛnyɛ ɔ́ tóya nə bɔ́ɔ́l búúd bwə́ á kə cínɔŋg áncuncuma, bə́nɔ̂ŋ bwə́ mú kə də. ");
INSERT INTO mcp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Ofarizyɛ̂ŋ bə́nɔ̂ŋ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú kə ŋgə nyímbʉla nə *ompwíín ɔ́ Yésus nə́: «Nəcé jɨ́ bɨ́nɔ̂ŋ oŋwɛnyɛ ɔ tóya nə bɔ́ɔ́l osɔ́ɔl ɔ mə́bɔ̂w bɨ́ ŋgə́ bə́lɛ də nə ŋgul yí?» ");
INSERT INTO mcp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yésus mú bɛ̧sa nə bwo nə́: «Mikanz dɨ́ mí dʉ jɨɨ jwɔ́wʉda, í dʉ bə mímbə̂l. ");
INSERT INTO mcp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mə a shígɛ́ zə jɔ̂w ótʉ́təlí ɔ búúd nə́ bwə́ cɛ́ndʉ́g mítə́dʉ́gá, mə á yida zə jɔ̂w osɔ́ɔl ɔ mə́bɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bwə́ mú cɨ nə nyə nə́: «Ompwíín ɔ́ Yuánɛs báá bwə́ dʉ ci idʉ̂w yə́lə Zɛmbî gúmə́, ompwíín ɔ́ Ofarizyɛ̂ŋ bwə́ dʉ nə́mə́ sá ntɔ́; wɛɛ bwô bâŋ ku ci.» ");
INSERT INTO mcp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yésus mú bɛ̧sa nə bwo nə́: «Ja múúd mə́ ŋwa bâ yí, a tə̂l zâŋ, a jɔ̂w óshwə́ bɛ́; ye bɨ bʉ́sə nə ŋkul sá nə́ oshwə́ bɛ́ bwə́ yídag zə nə məcɛy lámʉ́d bə́nɔ̂ŋ muud bâ bwə́ njúl kʉ́l ŋgwúd? ");
INSERT INTO mcp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mbɔ̂! Njɨ mɔ́ɔ́l mwɔ̂w mə́ ŋgə zə, bwə́ bá yîl bwo muud bâ yí. Mwɔ̂w mɔɔŋgʉ́ dɨ́ ɔ́ óshwə́ bɛ́ bwə́ ka bá ci ídʉ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A mú nə́mə́ kənd bwo kaanə́ nə́: «Bwə́ ádɛ́ nyaa káándə́ ágúgwáan ŋwa kʉ́l cínɔŋgʉ́, kə wá bágá bwoodʉ́ káándə́d. Múúd mə ká sá ntɔ́, í é bə, a mə́ nyaa káándə́ ágúgwáan, kʉ́l jé kú nyiŋgə mpíya nə káándə́ á bwoodʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ntɔ́ nə́mə́, bwə́ ádɛ́ ŋwa wáan ágúgwáan kə wá bwoodʉ́ lɛnyad; ŋkwaŋgá wáan í é sá nə́ lɛnya búndʉ́g, wáan shwiy shí. ");
INSERT INTO mcp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ntɔ́, í jɨɨ nə́ bwə́ dʉ́g wá wáan ágúgwáan ílɛnya í agúgwáanʉd. ");
INSERT INTO mcp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Muud cugɛ́ nə ŋkul bə nə́ a shîn ŋgul mə́lwəg mə́ mə́ lyʉŋ má a nyiŋgə gwág yéésh íkwan. Mbɔ̂! Bwə́ dʉ cɨ nə́ məlwəg mə́ mə́ lyʉŋ má wə́ mə́sə́ fwámɛ́ mə́lwəg.» ");
INSERT INTO mcp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Í á wɔ́ɔ́s dúlʉ́gá jwɔ̂w lʉ́ Sábaad dɨ́ nə́, Yésus nyə á ŋgə lɨ́ɨ́na ifambə́ í *blé. *Ompwíín bɛ́ bwə́ mú ka ŋgə búgə mikʉŋg mí blé, ŋgə nyamʉsə nə́ ndɛɛ́ ŋgə də. ");
INSERT INTO mcp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bɔ́ɔ́lʉ́gá búúd wâ gwooŋg *Ofarizyɛ̂ŋ bwə́ mú lás nə bwo nə́: «Nəcé jɨ́ bɨ́ ŋgə́ sá sâ mə́cɛ̧ɛ̧ mə́ amágʉ́lə́yɛ́ nə́ muud sáág jwɔ̂w lʉ́ Sábaad yí?» ");
INSERT INTO mcp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yésus mú bɛ̧sa nə bwo nə́: «Ye bɨ afwóyɛ́ bwɛlɛ lɔ̧́ sâ *Dávid nyə á sá ja bə́nɔ̂ŋ buud bɛ́ bwə́ á gwág zha yí? ");
INSERT INTO mcp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nə́ nyə á kə nyíi banda *mə́túnʉga dɨ́, ŋwa ibʉlɛ́d í á dʉ bə ci shú yə́lə Zɛmbî gúmə́ yí də, a yə nə́mə́ búúd bɛ́ bwə́ də. Í njúl nə́ məcɛ̧ɛ̧ mə́ ŋgə cɨ nə́ njɨ ofada wə́ bwə́ á jəla nə dʉ də byo, kú nə ŋgwɔ́l múúd shús.» ");
INSERT INTO mcp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A mú cɨ nə bwo nə́: «Mwân mə Múúd ŋgə jwú nə məcɛ̧ɛ̧ mə Sábaad.» ");
INSERT INTO mcp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Í á nyiŋgə bə dúlʉ́gá jwɔ̂w lʉ́ Sábaad dɨ̂ nə́, Yésus nyə a nyíi *mpáánzə́ minjɨ́ɨ́gʉ́lá, a mú dʉ yə búúd minjɨ́ɨ́gʉ́lá. Ŋgwɔ́l múúd nyə á bə cínɔŋgʉ́ nə mbwə̂ məncwûm shwáámbʉ́lə. ");
INSERT INTO mcp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","*Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ Ofarizyɛ̂ŋ bwə́ mú ŋgə fáf Yésus nə́ bwə́ dʉ́g ŋkí nyə é lwag múúd jwɔ̂w lʉ́ Sábaad, bwə́ shwə́man nyə. ");
INSERT INTO mcp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yésus mú bwey mpu mítə́dʉ́gá bwə́ á ŋgə tə́dʉga bwə́dɨ́ mílámʉ́d myá. A mú cɨ nə muud á mbwə̂ shwáámbʉ́lə nə́: «Tɔ́wʉ́g tʉ́təlí, wo kə́g tɔ̂w na tâm buud.» Muud wɔɔŋg mú kə, kə tɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yésus mú cɨ nə buud nə́: «Mə shílə́ ná bɨ́ nə́ ye məcɛ̧ɛ̧ mə́ magʉlə nə́ sə́ sáág mənywa jwɔ̂w lʉ́ Sábaad, ye nə́ sə́ sáág məbɔ̂w, ye nə́ sə́ cʉ́gʉg buud, ye nə́ sə́ gwúg?» ");
INSERT INTO mcp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A mú ciŋg mpwóómbʉ́ ŋgə dʉ́g bɛ̂sh nyə́dɨ́ mə́koogʉ́ nə́ ndɛɛ́ nyə nə muud á shwáámbʉ́lə mbwə̂ nə́: «Kwéégʉ́g mbwə̂.» A mú kwéég mbwə̂, í mú bə mpwogɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","*Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ Ofarizyɛ̂ŋ bwə́ mú bə nə impimbə nda bwə́ é cwɨ́ɨl. Bwə́ mú ŋgə sɛ́ŋʉsa məkə̂l bwə́mɛ́ nə bwə́mɛ́ ŋgə́lə sɔ̧́ sâ bɨ́ nə ŋkul sá Yésus yí. ");
INSERT INTO mcp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Í á zə bə na dúl fwála dɨ́ nə́, Yésus nyə a bád mbʉ́mbʉ́ŋʉ́d kə jəgʉla nə Zɛmbî. Nyə a shínal bulú ncindî a ŋgə́ jəgʉla. ");
INSERT INTO mcp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ja mán í á lə̂m yí, nyə a jɔ̂w ompwíín bɛ́ a mú fɛ́ɛ́sh wûm nə óbá cínɔŋgʉ́, a mú gwiid bwo nə́ *buud ɔ lwámá. ");
INSERT INTO mcp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Í á bə, nə Shímun nyə á gwiid nə́ Pyɛ̂r yɛ́, nə Andrê mínyɔŋʉ̂ mə Pyɛ̂r wɔɔŋgʉ̂, nə Zhâk nə Yuánɛs, nə Fílíp, nə Batəlʉmî, ");
INSERT INTO mcp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nə Matiyô, nə Tómas, nə Zhâk mwân mə́ Alfê, nə Shímun nyə á bə kaambʉlə lɔɔm yɛ́, ");
INSERT INTO mcp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nə Yúdas mwân mə Zhâk, zə kɛɛl Yúdas Iskariyôt muud nyə á zə kusha nə Yésus yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yésus nyə á ka shulə wú nə bwo mbʉ́ŋʉ́d zə tɔ̂w kʉ́l í á bə mbwaanzʉlə yí. Ncúlyá *ompwíín bɛ́ nə kúdə zhwog buud bwə́ á bə cínɔŋg áncuncuma bwə́ ŋgə́ zhu Yudéa yɛ̂sh nə Yurʉ́səlɛm, bɔ́ɔ́l zhu fundú mâŋ á kɔ́ɔ́mb míŋgwə́la myâ Tir nə Sidon. ");
INSERT INTO mcp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Buud bɔɔŋgʉ́ bwə́ á zə nə́ bwə́ zə́ gwágʉlə Yésus zə ŋgə lwəgʉwa məbwas máŋ. Bɔɔŋg bɔ́w-bɔ̂w míshíshim mí á dʉ tə̂l cwúnd dɨ́ wá bwə́ ŋgə́ yâl. ");
INSERT INTO mcp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Buud bɛ̂sh bwə́ á ŋgə sɔ̧́ nə́ bwə́ kúnyá nə Yésus nəcé nyúl ŋkûl í á ŋgə wú nyə́dɨ́ ŋgə lwag bwo bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yésus mú bʉ̂n mísh dʉ́g *ómpwíín bɛ́, a mú cɨ nə bwo nə́: Bɨ́ buud ɔ mə́búwa bɨ mə́ jəla, nəcé Faan mə́ Zɛmbî dɨ́ shú dʉ́n. ");
INSERT INTO mcp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bɨ́ buud bɨ́ ŋgə́ gwág zha kɨdɨ́ga wá, bɨ mə́ jəla, nəcé bɨ mə bá bə nə jílə́. Bɨ́ bɔɔŋg bɨ́ ŋgə́ jɨɨ məyə̂ kɨdɨ́ga wá, bɨ mə́ jəla, nəcé bɨ mə bá bə nə məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Buud bwə́ bá mpii bɨ̂, bwə́ ban nə́ bɨ kú ná dʉ sɛɛŋgya nə bwo, bwə́ lwîy bɨ̂, bwə́ ŋwa mínə́ mʉ́n nda sâ nyɛɛ́ nəcé bɨ ŋgə́lə bɛ̧ *Mwân mə Múúd. Ja í bə́ nə bɨ́ ntɔ́ yí, bɨ mə́ jəla. ");
INSERT INTO mcp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jwɔ̂w í bə́ nə bɨ́ ntɔ́ yí, gwágʉ́gá nywa, bɨ́ kɔ̂w nə məshusʉg, nəcé bɨ mə bá kə bə nə məma myə́na gwɔ̂w. Mpugá nə́ nda bwə́ ŋgə́ sá bɨ́ nɨ, ntɔ́ nə́mə́ wə́ ímpáámbə́ byáŋ í á dʉ sá *buud ɔ mícúndə́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ká məntágʉla nə bɨ́ buud ɔ kúm, nəcé wʉ́n tɔɔm wɛ̂sh ɔ bɨ́ bɨ́ nə ndɨ̂ nɨ. ");
INSERT INTO mcp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Məntágʉla nə bɨ́ buud bɨ́ nə jílə́ wá, nəcé bɨ mə bá bə nə zha. Məntágʉla nə bɨ́ buud bɨ́ ŋgə́ gwo kɨdɨ́ga wá, nəcé bɨ mə bá tədʉwa, bɨ́ jɨɨ mə́yə̂. ");
INSERT INTO mcp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Məntágʉla nə bɨ́ ja búúd bɛ̂sh bwə́ fáág bɨ́, cɨ nə bɨ́ njɨ mənywa yí. Mbií ŋgwúd wɔɔŋg nə́mə́ wə́ ímpáámbə́ byáŋ í á dʉ sá buud ɔ mícúndə́ wâ məshɨɨgâ yí. ");
INSERT INTO mcp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Njɨ, mɛɛ mə́ cɨ nə bɨ́ buud bɨ́ ŋgə́ gwágʉlə mə wá nə́, cɛɛlʉgá mizhízhíŋ mín, bɨ́ sá bɔɔŋg bwə́ ŋgə́ mpii bɨ́ wá mənywa. ");
INSERT INTO mcp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bwádánʉ́gá nə buud bwə́ shwó bɨ́ wá, bɨ́ jəgʉla nə Zɛmbî shú bɔɔŋg bwə́ ŋgə́ cúg bɨ́ wá. ");
INSERT INTO mcp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ŋkí muud mə nyífə́ wo bɔ́ɔ́nz mbáŋʉ́d, yə́g nə́mə́ nyə wúl mbáŋ. Ŋkí muud mə mándá wo nə kúúd gwô, wo kú kaambʉlə nyə nə wáma gwô á cwû. ");
INSERT INTO mcp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ŋkí muud mə gwáámb wo sâ, yə́g nyə; nyɔɔŋg mə mándá wo nə sâ gwô yɛ́, bɨ́dʉ́g a kə́g nə gwo. ");
INSERT INTO mcp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ságá buud sâ bɨ́ mə́ cɛ́ɛ́l nə́ bwə́ sáág bɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Ŋkí bɨ mə́ dʉ cɛɛl njɨ buud bwə́ cɛ́ɛ́l nə́mə́ bɨ́ wá, buud bɨ́ nə ŋkul ka lɔ̧́ bɨ́ ntʉdɛlɛ̂? Ŋgaá nə́ osɔ́ɔl ɔ *mísə́m bwə́ dʉ nə́mə́ cɛɛl njɨ buud bwə́ cɛ́ɛ́l bwo wá? ");
INSERT INTO mcp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ŋkí bɨ mə́ sá búúd mənywa njɨ bɔɔŋg bwə́ sá nə́mə́ bɨ́ mənywa wá, buud bɨ́ nə ŋkul ka lɔ̧̂ bɨ́ ntʉdɛlɛ̂? Ŋgaá nə́ osɔ́ɔl ɔ mísə́m bwə́ dʉ nə́mə́ sá ntɔ́? ");
INSERT INTO mcp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ŋkí bɨ mə́ dʉ kənd íkwalá njɨ wú bɨ́ mə́ bwánd nə búgə́ nə́ bwə́ é nyiŋg bɨ́ wá, buud bɨ́ nə ŋkul ka lɔ̧́ bɨ́ ntʉdɛlɛ̂? Ŋgaá nə́ osɔ́ɔl ɔ mísə́m bwə́ dʉ nə́mə́ kənd íkwalá njɨ wú bwə́ dʉ nyiŋg bwo tâŋ ŋgwúd wá? ");
INSERT INTO mcp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Bɨ bâŋ, cɛɛlʉgá mizhízhíŋ mín, dʉgá sá búúd mənywa, bɨ́ dʉ yə búúd ikwalá kú bwánd nə́ bwə́ nyíŋgʉg bɨ̂. Ntɔ́, Zɛmbî mə bá yə bɨ́ məma myə́na; í é mpûy nə́ bɨ bʉ́sə bwân ɔ́ Zɛmbî a gwɔ́w-gwɔ̂w. Nəcé nywáá jɨ nə jɔ̧ lâm tɛɛm bə shú búúd bwə́ aŋgɛ̂ nə yə nyə akíba wá, tɛɛm bə shú bɔɔŋg wâ mbíya milâm. ");
INSERT INTO mcp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dʉgá lwóya lâm íŋkúŋkwoŋ nda Sɔ́ɔ́ŋgʉ́ wʉ́n mə́ dʉ lwóya lâm íŋkúŋkwoŋ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Kúgá dʉ jɛ́ɛ́g búúd minjagə́, bwə́ ka nə́mə́ bá dʉ bə kú jɛ́ɛ́g bɨ́ minjagə́. Kúgá dʉ yə búúd intʉ́gʉ́lí í mə́bɛ̧ɛ̧́ máŋ, bwə́ ka nə́mə́ bá dʉ bə kú yə bɨ́ intʉ́gʉ́lí í mə́bɛ̧ɛ̧́ mʉ́n. Dʉgá juu búúd nə məbɛ̧ɛ̧́ máŋ, bwə́ ka nə́mə́ bá dʉ juu bɨ́ nə mʉ́n mə́bɛ̧ɛ̧́. ");
INSERT INTO mcp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dʉgá sá yána, bwə́ bâg nə́mə́ dʉ sá bɨ́ yána. Bwə́ bá dʉ shwu bɨ́ isâ məma kwáám káándə́d, í njúl njinyá, bwə́ san í ŋgə́ sɔw. Nəcé yuug bɨ́ é dʉ yigʉla bɔ́ɔ́l búúd nə́ ndɨ́ yí, gwə́ nə́mə́ ɔ́ bwə́ bá dʉ yigʉla bɨ́ nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yésus mú nə́mə́ kənd bwo kaanə́ nə́: «Ŋgwɔ́l áncím-ncîm jɨ nə ŋkul jaand nə ŋgwɔ́l? Ŋgaá nə́ bɛ̂sh bwə́ é bʉ́la bɨ́ɨ́d?» ");
INSERT INTO mcp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mpwíín nyə ádɛ́ bwɛlɛ ntɔ̧ yɨ́ɨ́gʉli; njɨ, *mpwíín mə́ mpú ŋwa njɨ́ɨ́gʉ́lá yɛ́ mə́ dʉ nə́mə́ bə nda yɨ́ɨ́gʉli. ");
INSERT INTO mcp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Nəcé jɨ́ wó ŋgə́ mpu dʉ́g ntand shwú jɨ́ mínyɔŋʉ̂ woó jús dɨ́, njɨ wo kú dʉ́g mbwûŋ wɨ́ dwó jús dɨ́ yí? ");
INSERT INTO mcp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ntʉdɛlɛ́ wó jɨ́ nə ŋkul cɨ nə́ wo yîl mínyɔŋʉ̂ woó ntand shwú júsʉ́d wɛɛ kú dʉ́g mbwûŋ wúsə́ wo dwó júsʉ́d yí? Yé múúd məkə́ŋ, fwog yîl mbwûŋ wódɨ́ júsʉ́d; ja jɔɔŋgʉ̂ wə́ wó é ka dʉ́g nda wó jɨ́ nə ŋkul yîl mínyɔŋʉ̂ woó ntand shwú júsʉ́d nə́. ");
INSERT INTO mcp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Fwámɛ́ lɨ́ɨ́ dɨ́ í dʉ́ wúmə íbumə́ í abʉ́bɔ̂w; lɨ́ɨ́ abʉ́bɔ̂w kú nə́mə́ wúmə fwámɛ́ íbumə́. ");
INSERT INTO mcp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lɨ́ɨ́ jɛ̂sh í dʉ mpûy íbumə́d. Bwə́ ádɛ́ mwáág ífumbí ŋgwúdáánzə́ dɨ̂, kú saag mə́budə́ ŋgwuŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jɔ̧jɔ̧ múúd lâm yé wúsə nə jɔ̧jɔ̧ kwɔ̧ɔ̧zʉ́, í ka dʉ wééshʉli jɔ̧jɔ̧ ísâ; bɔ́w-bɔ̂w múúd yé lâm nə bɔ́w-bɔ̂w kwɔ̧ɔ̧zʉ́, ka nə́mə́ dʉ wééshʉli bɔ́w-bɔ̂w ísâ. Sâ múúd ŋgə́ bul tə́dʉga lámʉ́d yí, gwə́ wə́ mpu yé í dʉ́ lás yí. ");
INSERT INTO mcp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Bɨ́ ŋgə jɔ̂w mə nə́ Cwámba! Cwámba! Ká nəcé jɨ́ bɨ́ bʉ́sə́ kú sá sâ mə́ ŋgə́ cɨ yí? ");
INSERT INTO mcp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Muud yɛ̂sh mə zə́ mə́dɨ́ zə gwágʉlə lə́sʉ́ mə́ ŋgə́ lás ga, a sá nda mə́ ŋgə́ cɨ nə́, muud wɔɔŋgʉ̂ jisə mbií múúd mə́ zə́ lwágʉlə bɨ́ ga. ");
INSERT INTO mcp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A jɨ nda muud mə sá nə́, ja á zə́ shumə njɔ́w yí, a tɛ́ɛ́d fáág shí nə́ fáág fáág fáág, a mú kə tə̂l mífim kwóógʉ́d. Ja mpʉŋ i wɔ́ɔ́s yí, kwuŋgú tɛɛm dʉ nyífa njɔ́w wɔɔŋgʉ́d, í kú bwɛlɛ shwágʉsa, nəcé í bə́lə fwámɛ́ shumyá. ");
INSERT INTO mcp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Njɨ, ŋkí muud mə gwágʉ́lə́ lə́sʉ́ mə́ ŋgə́ lás yí, a kú sá nda mə́ ŋgə́ cɨ nə́, a jisə nda muud mə shúmə́ njɔ́w mə́tag dɨ́ kú fáág nə́ ndɛɛ́ kə tə̂l mífim kwóógʉ́d yɛ́. Kwuŋgú mə ká nyífa njɔ́w wɔɔŋgʉ́d, í búg shugʉla shí nə́ mpuu.» ");
INSERT INTO mcp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ja Yésus nyə a shîn lás lə́sʉ́ yé nə wɛ̂sh kúl búúd í ŋgə́ gwág yí, nyə á kyey kə Kapɛrnawûm. ");
INSERT INTO mcp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wúl lúlúú múúd í á dʉ jwú nə ozɨmbɨ təd yí í á bə nûŋ, lwaá dɛ́ á lâm í á ŋgə bwas ŋkí yáág nə́ í zə́ yə. ");
INSERT INTO mcp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lúlúú ózɨmbɨ nɨ í á ka gwádʉga Yésus. A mú kənd bʉ́baalɛ́ ocúmbá buud wâ *Oyúdɛn nə́ bwə́ kə́g jəgʉla nə nyə nə́ a zə́g lwag nyə lwaá dɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ocúmbá buud bɔɔŋg bwə́ mú kə wɔ́ɔ́s wə́ Yésus, kə bul bul tɛ́ɛ́g nyə məbwə̂ nə́: «Muud ɛ́nɛ mə́ jəla nə́ wo kwííndʉ́g nyə, ");
INSERT INTO mcp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nəcé á cɛɛl lwoŋ búúd jísʉ́, nyə wə́ nyə a lwɔ̧́ sə́ *mpáánzə́ minjɨ́ɨ́gʉ́lá nyísʉ́.» ");
INSERT INTO mcp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yésus mú ŋwa zhɨ́ɨ́, bə́nɔ́ŋ bwə́ mú kə. Nə́ bwə́ wál bá kə kumə njɔ́w, lúlúú ózɨmbɨ mú kənd óshwə́ bɛ́ nə́ bwə́ kə́g cɨ nə Yésus nə́: «Cwámba, kú bul ntágʉlə nyúúl, nəcé mə ampíyáyɛ́ nə́ wo nyííg mə́dɨ́ njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gwə́ wə́ mə́ shígɛ́ kwey tʉ́təlí nə́ mə zə́g məmɛ́fwó zə bwəma nə wo yí. Jeg lás lásʉ́g, sɔ́ɔl məsáal waamə́ yálʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nəcé mə jɨ nə omása bwə́ ŋgə́ jwú nə mə wá. Mə jɨ nə́mə́ nə ozɨmbɨ mə́ ŋgə́ jwú nə ndɨ́ wá. Nyɔɔŋg yɛ̂sh mə́ é cɨ nə́ a kyéyʉg yɛ́, a kə; nyɔɔŋg mə́ é cɨ nə́ a zə́g yɛ́, a zə. Mə́ ká cɨ nə lwaá dâm nə́ í sáág gúl sâ, í sá gwo.» ");
INSERT INTO mcp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yésus nyə á faag njwû ozɨmbɨ ɛ́nɛ ja nyə á gwág á mə́ lás ntʉ́nɨ yí. A mú yid dʉ́g búúd bwə́ á ŋgə bɛ̧ nyə áncuncuma wá, nyə nə bwo nə́: «Mə́ jaaw bɨ́ nə́ mə afwóyɛ́ bwɛlɛ dʉ́g múúd nə fwámɛ́ búgə́ nda nyíga, tɛɛm bə kúl búúd *Izʉrəyɛ̂l dɨ̂» ");
INSERT INTO mcp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Buud bwə́ á zə lwámád wá bwə́ mú nyiŋgə, kə njɔ́w mə́ lúlúú ózɨmbɨ, bwə́ mú kə kwey sɔ́ɔl məsáal mú mpwogɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yésus nyə á ka kə ŋgwə́la á Nayîn, bə́nɔ̂ŋ *ompwíín bɛ́ nə bɔ́ɔ́l zhwog buud ɔ bwə́ á ŋgə kə. ");
INSERT INTO mcp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bwə́ ŋgə́lə shísh ŋgɛɛ́ mpumbɛ́ ŋgwə́la, dʉ́g nə́, buud bwə́ ŋgə́ kə nə mbimbə nə́ bwə́ kə́ dʉl. Í á bə cʉ́gə́ lʉ́ mwân, nyɔɔŋgʉ́ njúl kúsə. Zhwog buud ɔ ŋgwə́la bwə́ á ŋgə lʉ́gal nyə. ");
INSERT INTO mcp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cwámba nyə á bul gwág cɛy lâm mwo dɨ́ ja nyə á dʉ́g kúsə́ múdá wɔɔŋg yí. A mú cɨ nə nyə nə́: «Kú ná ŋgə jɨɨ.» ");
INSERT INTO mcp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A mú shísh kə kúnya nə taŋʉ́. Buud bwə́ á ŋgə ŋkɛ̂ny wá bwə́ mú shigʉla. Yésus mú lás nə́: «Mwâ ncwə́má, juumʉ́g! Mə́ cɨ nə wo ntɔ́.» ");
INSERT INTO mcp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mbimbə mú wɔɔl ji njínjilî, tɛ́ɛ́d ntâg ŋgə́lə lás. Yésus mú ŋwa nyə nyiŋg yə nyɔ́ɔ́ŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Buud bɛ̂sh bwə́ mú bə nə iŋkuŋkúúnd. Bwə́ mú ŋgə yə Zɛmbî məshwúmb bwə́ ŋgə́ cɨ nə́: «Məma *múúd micúndə́ mə́ wɔ́ɔ́s sə́dɨ́. Zɛmbî mə́ zə kwiid kúl búúd jé.» ");
INSERT INTO mcp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lâŋ mə́ Yésus í mú ŋgə kala nə́ ndɛɛ́ í mú kyey Yudéa yɛ̂sh nə cínɔŋg mə́koogʉ́ məkoogʉ́ yɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yuánɛs Nduu-buud nyə á ka gwág misɔ́ɔ́lʉ́gʉ́ mínɨ myɛ̂sh nə *ompwíín bɛ́. Nyə á ka jɔ̂w óbá cínɔŋgʉ́, ");
INSERT INTO mcp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a mú kənd bwo wə́ Yésus nə́ bwə́ kə́g jî nyə nə́: «Ye wo wə́ muud sə́ ŋgə́ bwánd nə́ a bá zə yɛ́? Ye sə́ kwóg ná bwánd íshús?» ");
INSERT INTO mcp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ompwíín ɔ́ Yuánɛs bwə́ mú kə wɔ́ɔ́s wə́ Yésus, bwə́ mú cɨ nə nyə nə́: «Yuánɛs Nduu-buud ŋgə ntɨ sə́ nə́ sə́ zə́g jî wo nə́: “Ye wo wə́ muud sə́ á ŋgə bwánd nə́ a bá zə yɛ́, ye sə́ kwóg ná bwánd íshús?”» ");
INSERT INTO mcp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nə́mə́ fwála dɔɔŋgʉ́ dɨ, Yésus mú lwag zhwog buud məbwas, shínal íjâm, yîl mə́jamb, bɛ̂ny zhwog wəancím-ncîm mísh. ");
INSERT INTO mcp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A mú bɛ̧sa nə buud Yuánɛs nyə á ntɨ wá nə́: «Kəgá jaaw Yuánɛs sâ bɨ́ mə́ dʉ́g yí nə sâ bɨ́ mə́ gwág yí. Wəancím-ncîm bwə́ ŋgə mpu dʉ́gya; mimbúmbwúgʉ́ mí ŋgə́ kyey tʉ́təlí, mizʉ́zaamə́ mí ŋgə yâl, wəakúmə́lwə̂ bwə́ ŋgə mpú gwág, mimbimbə mí ŋgə gwûm, iŋkúŋkwóŋʉ́lə í búúd í mú ŋgə gwág Jɔ̧jɔ̧ Kɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Muud nyə́ é bə kú bwəma nə bɔɔgʉ́ mə́dɨ́ yɛ́, nywáá mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ja búúd Yuánɛs nyə á ntɨ wá bwə́ mə́ nyiŋgə yí, Yésus mú zə lésha nə buud bwə́ á bə cínɔŋg áncuncuma wá; a mú cɨ nə bwo shú mə́ Yuánɛs nə́: «Ja bɨ́ á dʉ kə shí a shwééshá dɨ́ yí, bɨ́ á dʉ kə dʉ́g jɨ́? Ye gúl ká í dʉ́gə́ ntʉ̂ŋ nə fʉfə́? ");
INSERT INTO mcp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ŋkí í á shígɛ́ bə ntɔ́, bɨ́ á dʉ kə dʉ́g jɨ? Ye ŋgwɔ́l múud dʉ́gə́ bwáád íjimə́ í mímbwéédí? Mbɔ̂, buud bwə́ dʉ́ bwáád íjimə́ í mímbwéédí dʉ cʉgə cʉg álal-ŋkul wá bwə́ dʉ bə mínjɔ́w mí ójwú-buudʉd. ");
INSERT INTO mcp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ká bɨ á dʉ kə dʉ́g jɨ? Ye *muud micúndə́ mə́ Zɛmbî? Haaw, mə́ jaaw bɨ́ nə́ nyɔɔŋg bɨ́ á kə dʉ dʉ́g yɛ́ mə́ ntɔ̧ ŋkwóŋ múúd micúndə́ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nəcé nyə wə́ Zɛmbî nyə á cɨ nda jísə́ cilyá nyə́dɨ́ Kálaad dɨ́ nə́, nə́: “Dʉgɨ́! Mə zə́ kənd mbwiiŋgyɛ lâŋ waamə́ nə́ a kə́g wo shwóg kə kwambʉlə wo zhɨɨ́.” ");
INSERT INTO mcp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mə́ ka jaaw bɨ́ nə́, mpə́dʉ́gá buud bɛ̂sh bwə́ mə́ byɛ̂l mímwɔ̧ mi búdád wá, kú nə muud mə ntɔ̧́ Yuánɛs. Njɨ tɛɛm bə ntɔ́, muud mə bul bə zhizhe Faan mə́ Zɛmbî dɨ́ yɛ́, á ntɔ̧́ Yuánɛs. ");
INSERT INTO mcp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Buud bɛ̂sh tɛɛm bə óŋwɛnyɛ ɔ tóya bwə́ á ŋgə duwan wə́ Yuánɛs wá, báá bwə́ á ŋgə magʉlə nə́ Zɛmbî jɨ tʉ́təlî. ");
INSERT INTO mcp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Njɨ, *Ofarizyɛ̂ŋ bə́nɔ̂ŋ *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ bâŋ buud bwə́ á ban nə́ bwə́ adúwánɛ́ wə́ Yuánɛs wá, bwə́ á ban sâ Zɛmbî nyə á yagʉ́lə shú dáŋ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Mə kág ná yɨɨga kala búúd á múús nə ozə́? Mə kág cɨ nə́ bʉ́sə ntʉdɛlɛ? ");
INSERT INTO mcp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bʉ́sə nda ikágə́ bísə́ shishɛ̧́ ísɛɛŋgyá dɨ́ yí, bíl í ŋgə́ kámbʉla nə bílʉ́gá nə́: “Sə́ mə́ lwɔ̧́ bɨ́ ilúlwóŋ í ábulya məkə̂l, bɨ kú sáág; sə́ mə́ nyiŋgə wá míŋgwa mí shwɨy, bɨ kú jɨɨ”. ");
INSERT INTO mcp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ntɔ́ wə́ í ŋgə́ bə ɛ́ga; Yuánɛs Nduu-buud nyə á zə, kú də ídɨ́y-dɨ̂y, kú ŋgul mə́lwəg; bɨ nə́: “A jɨ nə jamb.” ");
INSERT INTO mcp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwân mə Múúd mə́ zə, a ŋgə́ də a ŋgə́ ŋgul, bɨ nə́: “Nyɨ́nɨ jisə ndə̂l dəg, ŋgulɛ məlwəg. A jɨ nə́mə́ shwə́ oŋwɛnyɛ ɔ tóya nə osɔ́ɔl ɔ *mísə́m.” ");
INSERT INTO mcp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Njɨ buud bɛ̂sh bwə́ ŋgə́ bɛ̧ fʉg mə́ Zɛmbî wá bwə́ ŋgə lwó nə́ jísə jɔ̧jɔ̧ sâ.» ");
INSERT INTO mcp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ŋgwɔ́l *Farizyɛ̂ŋ nyə a jɔ̂w Yésus nə́ a kə́g nyə́dɨ́ njɔ́w bá bwə́ kə́ də. Yésus mú kə nyíi njɔ́w mə́ Farizyɛ̂ŋ wɔɔŋgʉ̂ kə ŋwa jiya shú də́lə. ");
INSERT INTO mcp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ŋgwɔ́l múdá nyə á dʉ bə sɔ́ɔl *misə́m cínɔŋg ŋgwə́la, nyə á ka mpu nə́ Yésus jɨ wə́ Farizyɛ̂ŋ ɛ́nɛ, a ŋgə də. Ká dʉ́g ɨɨ́, mudá wɔɔŋgʉ̂ mə́ wɔ́ɔ́s, a zág nə labínda fúfuundú *alʉbátrə dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A mú zə tɔ̂w Yésus mpʉ́sə, ŋgɛɛ kɔ́ɔ́mb mə́kuú. A mú dʉ jɨɨ, dʉ bweesh Yésus məkuú nə məzhwíílɛ nə́ ndɛɛ́ a fîm nyə mwo nə shilú jé, a músə ŋgə ywó nyə mwo nə mpu, a nywɔ̧ mwo labínda. ");
INSERT INTO mcp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja Farizyɛ̂ŋ nyə a jɔ̂w Yésus yɛ́ nyə á dʉ́g sɔ́ɔ́lʉ́gʉ́ wɔɔŋg yí, nyə á ŋgə lás nyə́dɨ́ lámʉ́d nə́: «Muud ɛ́ga mbə̂m bə *múúd micúndə́ mə́ Zɛmbî, ŋki a mə́ mpu múdá ŋgə́ kúnya nə nyə ɛ́ga mbií múdá á jísə́ yí, a mpu nə́ a jisə sɔ́ɔl misə́m.» ");
INSERT INTO mcp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yésus mú lás cɨ nə nyə nə́: «Shímun e, mə́ cɛɛl jaaw wo gúl sâ.» Shímun nə́: «Yɨ́ɨ́gʉli, jaawʉ́g.» ");
INSERT INTO mcp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","«Ŋgwɔ́l múúd nyə á bə nə buud obá bwə́ mbíd nyə mpwə́lá; ŋgwɔ́l nə mpwə́lá odanarî mitəd mitɔ́ɔn, ŋgwɔ́lʉ́gá nə odanarî məwûm mə́tɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nda bwə́ áshígɛ́ bə nə *mwaanɛ̂ bwə́ nyíŋg nyə yɛ́ nə́, nyə á shwal bɨ́d bwo nə mpwə́lá nyɔɔŋg. Búud obá ónɨɨ́d, nyáyɛ́ nyə é bul cɛɛl múúd mpwə́lá wáŋ yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Shímun mú bɛ̧sa nə́: «Mə tə́dʉ́gá nə́ í é bə nyɔɔŋg á mə́ bɨ́d nə məma mpwə́lá yɛ́.» Yésus nə nyə nə́: «Wo mə́ sámb mbií í jə́la yí.» ");
INSERT INTO mcp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yésus mú yid wə́ mudá, nyə nə Shímun nə́: «Wo mə́ dʉ́g múdá ɛ́ga? Mə ámə nyíi wa wódɨ́ njɔ́w, wo shígɛ́ shwú mə məjúwó məkuúd; njɨ nywáá, a mə́ gusa mə məkuú nə məzhwíílɛ mɛ́, a fîm mə mwo nə shilú jé. ");
INSERT INTO mcp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wo shígɛ́ nə́mə́ ywó mə mpu; njɨ nywáá, tɛ́ nyə́ ámə nyíi wa yí, a jɨ njɨ a ŋgə́ ywó mə məkuú. ");
INSERT INTO mcp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wo shígɛ́ nywɔ̧ mə məwúdə́ lúúd; njɨ nywáá mə́ nywɔ̧ mə labínda məkuúd. ");
INSERT INTO mcp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gwə́ wə́ mə́ ká jaaw wo nə́, misə́m myɛ́ mí á tɛɛm bulya nda jɨ́, a mə́ bii íjuugá yâ misə́m myɔɔŋg myɛ̂sh; gwə́ wə́ á búl bə nə cɛɛlí nə mə yí. Nəcé, muud bwə́ dʉ juu nə isâ cíg-cîg yɛ́ a dʉ nə́mə́ bə nə cɛɛlí cíg-cîg.» ");
INSERT INTO mcp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A músə cɨ nə mudá nə́: «Wo mə́ bə nə ijuugá nə misə́m myô.» ");
INSERT INTO mcp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Buud bwə́ á bə dína dɨ́ wá bwə́ mú ŋgə lás bwə́dɨ́ mílámʉ́d nə́: «Nyáyɛ́ múúd ɛ́ga nyɛ? A bə́lɛ́ juu múúd nə misə́m?» ");
INSERT INTO mcp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yésus mú cɨ nə mudá nə́: «Wo mə́ *dʉ́g cʉg nəcé búgə́ gwô. Wɛɛ kaág nə́ shɛɛ.» ");
INSERT INTO mcp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mpʉ́sə isâ ínɨ, í á zə bə nə́, Yésus nyə á ŋgə kyey míŋgwə́la nə mə́ndʉ́d ŋgə jɨ́ɨ́gʉli buud, a ŋgə́ cúndə Jɔ̧jɔ̧ Kɛ́ɛl á Faan mə́ Zɛmbî. *Buud ɔ lwámá bɛ́ wûm nə óbá bwə́ á ŋgə lʉ́gal nyə, ");
INSERT INTO mcp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nə bɔ́ɔ́l búdá nyə á yîl məjamb wá, nə bɔ́ɔ́l nyə á lwag wá. Í á bə, nə Maríya bwə́ á dʉ jɔ̂w nə́ Mədalína mə́jamb zaŋgbá mə́ á wú yɛ́, ");
INSERT INTO mcp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nə Yuána mudá mə Kúsa nyə́ á dʉ vyee jús ísâ í Herod dɨ́ yɛ́, nə Sʉsána, nə bɔ́ɔ́l búdá. Budá bɔɔŋg bwə́ á dʉ ŋgə kwíínd Yésus bə́nɔ̂ŋ buud ɔ lwámá bɛ́ nə məbii máŋ. ");
INSERT INTO mcp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Buud bwə́ á ka zə sɛɛŋgya ŋkí jág bulya, bwə́ ŋgə́ wú míŋgwə́la myɛ̂sh, ŋgə zə nyə́dɨ́. A mú zə lás nə bwo kandad nə́: ");
INSERT INTO mcp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ŋgwɔ́l mbɔɔl məmpəg nyə á zə kə myɛɛg mpəg. Ja á mə́ ŋgə myɛɛg yí, nyúl mpúmə́ í mə́ shugʉla zhɨ́ɨ́ nə zhɨɨ́. Buud bwə́ mú nyaal nywo nə məkuú, inunú í zə ntâg shîn lúu. ");
INSERT INTO mcp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nyúl kə shugʉla kwóógʉ́d, í mú kɔ̧́ nə́ ndɛɛ́ í mú shwáás nəcé kú nə məbwaas. ");
INSERT INTO mcp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nyúl mú shugʉla íbiin-bíinʉd. Bə́nɔ̂ŋ ibiin-bíin bwə́ mú kɔ̧́ nə́ ndɛɛ́ ibiin-bíin í mú káda nywo. ");
INSERT INTO mcp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Njɨɨ́, nyúlʉ́gá mú kə shugʉla jɔ̧jɔ̧ shíd, í mú kɔ̧́, í wúmə, bumə́ ŋgwúd wúmə íbumə́ təd.» A mú cɨ nə bwo nə́: «Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, a gwág.» ");
INSERT INTO mcp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","*Ompwíín bɛ́ bwə́ mú jí nyə nda kanda wɔɔŋg í kə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A mú bɛ̧sa nə bwo nə́: «Zɛmbî nyə a mə́ sá nə́ bɨ báá mpúg mindímba myâ Faan dɛ́; njɨ a sá nə́ bɔ́ɔ́l bâŋ bwə́ ŋgə́g gwág njɨ mikaanə́; bwə́ bə́g, bwə́ tɛɛm kənd mísh, bwə́ kú dʉ́g; bwə́ tɛɛm gwágʉlə, bwə́ kú wámbʉlə. ");
INSERT INTO mcp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Kanda nɨ í kə́ ntʉ́ga: Mpəg wə́ Milə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Buud bʉ́sə́ ka bə tâŋ nda zhɨɨ́ nə zhɨɨ́ wá, jísə bɔɔŋg bwə́ dʉ́ gwág, njɨ Njwû məjamb mú zə, zə yîl bwo Milə́sʉ́ mí Zɛmbî lámʉ́d, nə́ bwə́ á bá *búgʉla nə́ ndɛɛ́ bwə́ *bə nə cʉg. ");
INSERT INTO mcp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bɔɔŋg bʉ́sə́ tâŋ nda kwóógʉ́d gwɔ́w wá, nyísə bɔɔŋg bʉ́sə́ nə́, ja bwə́ gwág Milə́sʉ́ mí Zɛmbî, bwə́ lə́g myə nə məshusʉg; njɨ bwə́ kú nə mikɔ̧ɔ̧lə́ bwə́dɨ́ cʉgʉd, bwə́ dʉ búgʉla njɨ kʉ́kʉ́l baan. Bwə́ ká bwəma nə məkʉgʉlʉ, bwə́ julə mə́nyúul. ");
INSERT INTO mcp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mpəg í á shugʉla ibiin-bíin dɨ́ yí, jísə buud bʉ́sə́ nə́, bwə́ ká shîn gwág Mílə́sʉ́ mí Zɛmbî, bwə́ kə, yágʉ́wó nə tɔɔm nə məlugə mə́ cʉg i mú káda bwo, bwə́ nda wúmə mpúmə́ nə́ ndɛɛ́ í tɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mpəg í á shugʉla shí átʉtagʉ́ dɨ́ yí, nyísə buud báá bʉ́sə́ nə́, bwə́ gwág Mílə́sʉ́ mí Zɛmbî nə jɔ̧ mílâm myâ tʉ́təlî, bwə́ bii myə, bwə́ mú wúmə mpúmə́ nəcé bə́lə nə zɛ́ny. ");
INSERT INTO mcp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Muud cugɛ́ nə ŋkul sá nə́, a jida lámba kə kúd mpwo dɨ̂, ŋkí nə́ a kə tə̂l dwo shí gwoŋʉ́. Bwə́ dʉ yida tə̂l lámba cé lámba dɨ́ nə́ buud bwə́ nyíi njɔ́w wá bwə́ dʉ́gʉ́g məŋkɛnya. ");
INSERT INTO mcp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kú nə sâ á *ndímba í bá bwên kú bʉ́gʉli, ŋkí sâ á shwoó í bwên kú mpûy, kú wɔ́ɔ́s mə́ŋkɛnyad. ");
INSERT INTO mcp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bɨ ɔ́ ka dʉ bɛy nə mbií bɨ́ mə́ dʉ gwágʉlə isâ yí. Mpugá nə́ muud jɨ́ nə baalɛ́ fʉg yɛ́, Zɛmbî mə bá kwádʉlə nyə nywo. Njɨ nyɔɔŋg cúgɛ́ nə́mə́ fwo bə nə ndɨ́ yɛ́, Zɛmbî mə bá mɛɛl yîl nyə bʉ́baalɛ̂ á ŋgə́ *búgʉla nə́ a jɨ nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nyɔɔŋgʉ́ mə Yésus bə́nɔ̂ŋ omínyɔŋʉ̂ bɛ́ bwə́ músə jê nə́ bwə́ zə́ nyə́dɨ́. Njɨ, bwə́ a shígɛ́ bə nə ŋkul mə shísh nyə kúnə́-kúnə nəcé buud bulʉ́lə bulya. ");
INSERT INTO mcp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bwə́ mú ka jaaw Yésus nə́: «Nyɔɔŋgʉ́ woó bə́nɔ̂ŋ omínyɔŋʉ̂ bwô bʉ́sə na tɔ́ɔ́n, bwə́ ŋgə jɨɨ dʉ́g wo.» ");
INSERT INTO mcp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A mú bɛ̧sa nə bwo nə́: «Nyɔɔŋgʉ́ waamə́ nə omínyɔŋʉ̂ báamə́ wə́ buud bwə́ ŋgə́ gwág Milə́sʉ́ mí Zɛmbî bwə́ ŋgə́ sá nda mí ŋgə́ cɨ nə́.» ");
INSERT INTO mcp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Í á bə dúlʉ́gá jwɔ́wʉ́d nə́, Yésus mə́ kəwa byɔ́ɔ́lʉ́d bə́nɔ̂ŋ ompwíín bɛ́, a mú cɨ nə bwo nə́: «Sə́ lɨ́ɨ́nágá mâŋ mə́ga kə faŋwíny.» Bwə́ músə wú bwúŋʉ́d kə bwag. ");
INSERT INTO mcp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yésus mú kə gwə́d ompwíín bɛ́ bwə́ ŋgə́ júgə. Məma ŋkwɔ̧̂ músə zə kuŋg mâŋ, məjúwó mə́ mú lwándʉla byɔ́ɔ́lʉ́d, í mú bə bwo ŋkí wagʉwo. ");
INSERT INTO mcp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ompwíín bwə́ mú kə juumʉshi nyə nə́: «Mása, Mása, sə́ wál zə yə.» A músə juum, a ŋkáánd nə ŋkwɔ̧̂, ŋkáánd nə ikwɔ̧́ í mə́júwó, byɛ̂sh í mú cwaalʉwo, mâŋ mə́ mú bə nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A mú cɨ nə bwo nə́: «Búgə́ jɨ́n jɨ́ ŋgow?» Iŋkuŋkúúnd í mú bii bwo, bwə́ ŋgə́ bul bɨ̂. Bwə́ mú ŋgə nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: «Nyáyɛ́ múúd ɛ́ga nyɛ! A ká nə́mə́ lás, tɔɔ ŋkwɔ̧̂, tɔɔ məjúwó í bə́lɛ́ sá nyə məgwág ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bwə́ mú kə səl byɔ́ɔ́l shí á Ogerazeniyɛ̧̂, nə́ bɛɛndyá nə Galilê. ");
INSERT INTO mcp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yésus ŋgə́ nə́mə́ wú byɔ́ɔ́lʉ́d tɔ̂w shí, ŋgwɔ́l múúd a ŋgwə́la mú zə bwəma nə nyə. Muud wɔɔŋgʉ̂ nyə á bə nə məjamb. Bweyʉ́lə nyə á bwey dʉ ji shushwáás, kú ji mínjɔ́w, dʉ ji njɨ mə́shwoŋ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dʉ́gʉ́lə múúd ɛ́nɛ nyə á dʉ́g Yésus yí, nyə a bwú ŋkwiimbyê a mú zə bʉ́la nyə shí məkuú. A músə kɨ̂m nə́: «Yé Yésus *Mwân mə́ Zɛmbî á gwɔ́w-gwɔ̂w, shwə̂ bâŋ nə inɛy? Mə́ jəgʉla nə wo, kú bɛɛg tə̂l mə cwúndʉd.» ");
INSERT INTO mcp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nəcé Yésus nyə a lás nə bɔ́w-bɔ̂w shíshim mpə̂l dɨ́ nə́ í wúg muud wɔɔŋg nyúúlʉ́d. Í á dʉ bád nyə ija ija, bwə́ dʉ́gə́ wɔ́ɔlə nyə nə mikwoolú mí íŋkwánz, dʉ wá nyə mimbwagə́ məkuúd shú nə́ bwə́ baagʉlə nyə. Njɨ nyə á dʉ tɨ́ isâ ínɨ byɛ̂sh, jamb í mú dʉ kə nə nyə íkʉ́l í á dʉ bə kú nə buud yí. ");
INSERT INTO mcp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yésus mú jí nyə nə́: «Jínə́ dwô wə́ zə́?» Nyə nə́: «Jínə́ dâm wə́ Kínda,» nəcé ncúlyá məjamb mə́ á bə nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Məjamb mə́ mú tɛ́ɛ́g Yésus məbwə̂ nə́ a kú cɨ nə bwo mpə̂l dɨ́ nə́ bwə́ kə́g bɨ́ ncíməd. ");
INSERT INTO mcp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na, məma sɔɔnz óŋkuú í á bə í ŋgə́ də cínɔŋg mbʉ́ŋʉ́d. Məjamb mə́ mú tɛ́ɛ́g Yésus məbwə̂ nə́ a mágʉləg nə́ mə́ kə́g nyíi óŋkuúd. A mú magʉlə. ");
INSERT INTO mcp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Məjamb mə́ músə wú múúd ɛ́nɛ dɨ́, kə nyíi óŋkuúd. Dɔ̧ lʉ́ óŋkuú dɔɔŋg dɛ̂sh mú dad wú mbʉ́ŋʉ́d kə juwa mâŋ nə́ ndɛɛ́ fudə. ");
INSERT INTO mcp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Buud bwə́ á ŋgə baagʉlə oŋkuú wá, dʉ́gʉ́lə bwə́ mə́ dʉ́g sâ í ámə cɔ̧́ yí, bwə́ mú wɛɛnzh kə ŋgə jaaw buud ŋgwə́la nə mílɔɔm milɔɔm. ");
INSERT INTO mcp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Buud bwə́ mú wú kwáádə́ zə, zə́lə dʉ́g sâ í ámə cɔ̧́ yí. Bwə́ mú zə kwey múúd mə́jamb mə́ á wú ɛ́nɛ a njúl nə mikáándə́ nə fwámɛ́ fʉ́g, a njúl Yésus shí məkuú. Bwə́ mú gwág íŋkuŋkúúnd. ");
INSERT INTO mcp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Buud bwə́ á dʉ́g sɔ́ɔ́lʉ́gʉ́ í á sɨ̂y wá bwə́ mú jaaw bwo nda njumbʉ́lu wɔɔŋg í á *dʉ́g cʉg nə́. ");
INSERT INTO mcp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nə́ ndɛɛ́, zhwog buud bɛ̂sh wâ shí Ogerazeniyɛ̧̂ bwə́ mú zə, zə cɨ nə Yésus nə́ a kyéyʉg wú bwə́dɨ́ shíd, nəcé í á bə fwámɛ́ íŋkuŋkúúnd í mə́ bií bwo. Yésus mú nyiŋgə kəwa byɔ́ɔ́lʉ́d, nyiŋgə nə mpʉ́sə. ");
INSERT INTO mcp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Muud nyə á bə nə məjamb yɛ́, mú tɛ́ɛ́g nyə məbwə̂ nə́ a ŋwág nyə nyə́dɨ́ gwooŋgʉd. Yésus mú yidá nyiŋg nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Nyíŋgə́g kə wódɨ́ njɔ́w kə jaaw sâ jɛ̂sh Zɛmbî mə́ sá wo yí.» A músə kyey, lɨ́ɨ́na ŋgwə́la wɛ̂sh a ŋgə́ jaaw sâ jɛ̂sh Yésus mə́ sá nyə yí. ");
INSERT INTO mcp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nyiŋgə́lə Yésus nyə á nyiŋgə yí, buud bwə́ á shwas nyə áncuncuma, nəcé í á bə bwə́ ŋgə́ bwánd nyə. ");
INSERT INTO mcp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ká dʉ́g nə́, ŋgwɔ́l múúd nə jínə́ nə́ Zharus, a njúl njwû á *mpáánzə́ minjɨ́ɨ́gʉ́lá, mə́ zə nə́ ndɛɛ́ zə kúd mə́bwóŋ shí, tɛ́ɛ́g Yésus məbwə̂ nə́ a kə́g nyíi nyə́dɨ́ njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Muud wɔɔŋgʉ́ nyə á bə nə sʉ́sásʉ́ ŋgwúd nə ŋgwûd í njúl nə mimbû wûm nə mímbá. Sʉ́sásʉ́ jɔɔŋgʉ̂ í á ŋgə júgʉla. Ja Yésus mə́ tɨ́ njɔɔnd kə́lə wu yí, buud bwə́ mú zə ŋgə shúsə nyə ikɔ́ɔ́mb byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋgwɔ́l múdá nyə á bə cínɔŋg məcií mə́ á dʉ wú nyə nyúúlʉ́d tɛ́ mímbú wûm nə mímbá. Mudá wɔɔŋgʉ̂ nyə á kɛɛnzh məbii mɛ́ mɛ̂sh mínjɔ́w mí mə́byaŋ dɨ́ njɨ a kú yâl. ");
INSERT INTO mcp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nyə á ka shísh wə́ Yésus ŋgɛɛ mpʉ́sə kwoŋ, a mú kúnya nə nyə lwə́ lʉ́ káándə́, məcií tɔ̂w ntâg nyə. ");
INSERT INTO mcp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nə́ ndɛɛ́ Yésus mú cɨ nə́: «Zə́ mə́ kúnya nə mə ɛ́nɛ?» Buud bɛ̂sh bwə́ mú ŋgə kɨ́ɨ́lya nə́ ndɛɛ́ Pyɛ̂r mú cɨ nə́: «Mása, buud bwə́ ŋgə bɛ̧ wo áncuncuma bwə́ ŋgə́ shúsə wo.» ");
INSERT INTO mcp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yésus mú cɨ nə́: «Ŋgwɔ́l múúd mə́ kúnya nə mə. Mə mə́ gwádʉga nyúl mpífə́ mə́ wú mə nyúúlʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mudá ɛ́nɛ mú mpu nə́ a cugɛ́ ná shwoód. A mú zə a ŋgə́ lilya, zə wusə nyúúl shí Yésus dɨ́ mpwóómbʉ́d, zə jaaw búúd bɛ̂sh sâ í ámə sá nə́ a kúnyág nə Yésus yí, a jaaw nə́mə́ nda nyə ámə yâl cé nə cé nə́. ");
INSERT INTO mcp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yésus mú cɨ nə nyə nə́: «Shilə wâm, wo mə́ *dʉ́g cʉg nəcé búgə́ gwô. Kaág nə́ shɛɛ.» ");
INSERT INTO mcp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A ŋgə́ ná lás ntʉ́nɨ, muud mú wɔ́ɔ́s wúlə wə́ njwû á mpáánzə́ minjɨ́ɨ́gʉ́lá, zə jaaw nyə nə́: «Sʉ́sás gwô mə́ yə, kú ná bɛɛg ntágʉlə Yɨ́ɨ́gʉli.» ");
INSERT INTO mcp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yésus mú gwág, a mú cɨ nə Zharus nə́: «Kú bɛɛg fúndə, bə́g njɨ nə búgə́, nyə é cʉgə.» ");
INSERT INTO mcp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ja Yésus mə́ kə wɔ́ɔ́s njɔ́w yí, a mú ban nə́ ŋgwɔ́l múúd shús kú nyíi, njɨ Pyɛ̂r nə Yuánɛs nə Zhâk nə sɔ́ɔ́ŋgʉ́ mwân nə nyɔɔŋgʉ́ mwân. ");
INSERT INTO mcp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bɛ̂sh bwə́ á ŋgə jɨɨ sʉ́sásʉ́ jɔɔŋgʉ́, ŋgə tədʉwa. Yésus mú cɨ nə́: «Kúgá ŋgə jɨɨ, nyə afwóyɛ́ yə, a ŋgə yida jâ.» ");
INSERT INTO mcp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nda bâŋ bwə́ á mpu nə́ sʉ́sásʉ́ mə́ yə nə́, bwə́ á yida ŋgə cágʉlə Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yésus nywáá mú bii sʉ́sásʉ́ mbwə́d, a mú cɨ gwɔ́w-gwɔ̂w nə́: «Mwân, wɔɔlʉ́g!» ");
INSERT INTO mcp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","*Jîm mə mwân mú nyiŋgə zə nyə nyúúlʉ́d, a mú wɔɔl cé nə cé. Yésus mú cɨ nə́ bwə́ yə́g nyə sâ mə́ də̂. ");
INSERT INTO mcp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Obyɔ̂l ɔ mwân bwə́ mú bul káam. Yésus mú báásʉlə bwo nə́ ci bwə́ kú jaaw múúd sâ í ámə cɔ̧́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yésus nyə á ka jɔ̂w *buud ɔ lwámá wûm nə óbá, a mú yə bwo ŋkul nə kɛ́ɛ́nd á dʉ́lə yîl búúd məjamb, nə ŋkul á dʉ́lə lwag bwo məbwas. ");
INSERT INTO mcp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A mú kənd bwo nə́ bwə́ kə́g ŋgə cúndə Faan mə́ Zɛmbî, kə ŋgə lwag mimbə̂l. ");
INSERT INTO mcp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A mú cɨ nə bwo nə́: «Bɨ kú ŋwa íbadʉga í njɔɔnd, tɔɔ wagatîg, tɔɔ baamʉtálá, kú kə nə bʉlɛ́d, kú kə nə mwaanɛ̂; muud kú bwáád íshimí íbá. ");
INSERT INTO mcp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bɨ ɔ́ ji njɔ́w bɨ́ ámə nyíi yííd, bɨ́ ka bá tɨ́ cínɔŋgʉ́ kə shwóg. ");
INSERT INTO mcp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Búúd bwə́ ká bá bə kú lə́g bɨ́ wúl ŋgwə́la dɨ́, bɨ́ wú cínɔŋgʉ́, bɨ́ kudə fumbyá í ámə nada bɨ́ mə́kuú dɨ́ yí. Sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂ í lwágʉlə bwo nə́ bwə́ mə́ byaagʉlə.» ");
INSERT INTO mcp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Buud ɔ lwámá bɔɔŋg bwə́ mú kyey, ŋgə kə mílɔɔm milɔɔm, ŋgə kə bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛl, bwə́ ŋgə́ lwag buud kʉ́l jɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod á tatarâk mú gwág ísâ byɛ̂sh í á ŋgə sɨ̂y yí. A mú bə kú ná mpu sâ á tə́dʉ́gág yí, nəcé bɔ́ɔ́l búúd bwə́ á ŋgə cɨ nə́ Yuánɛs mə́ gwûm; ");
INSERT INTO mcp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bɔ́ɔ́l nə́ Eli wə́ mə́ nyiŋgə lwóya nyúúl ɛ́nɛ; bɔ́ɔ́l nə́ ŋgwɔ́l *múúd micúndə́ ayág wə́ mə́ gwûm ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod mú cɨ nə́: «Mə wə́ mə a cígə Yuánɛs cʉ́ŋ. Nyáyɛ́ múúd nyɛ mə búl gwádʉga ntʉ́ga ɛ́ga?» A mú ka ŋgə sɔ̧́ nə́ a dʉ́g Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","*Buud ɔ́ lwámá bwə́ á ka nyiŋgə. Bwə́ mú zə jaaw Yésus sâ jɛ̂sh bwə́ á sá yí. Yésus mú ŋwa bwo, bə́nɔ́ŋ bwə́ wú búúd dɨ́, kə bwə́mɛ́fwó ŋgɛɛ́ ŋgwə́la bwə́ dʉ́ jɔ̂w nə́ Bɛtʉsayída yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ncúlyá buud bwə́ mú mpu nə́ bwə́ ŋgə kə nûŋ, bwə́ mú bɛ̧ nyə áncuncuma. Yésus mú lə́g bwo, a mú ŋgə bwiiŋg bwo isâ í dʉ́gyá nə Faan mə́ Zɛmbî yí, a ŋgə́ lwag bɔɔŋg bwə́ á ŋgə jɨɨ luug wá. ");
INSERT INTO mcp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ja kugʉ́ mə́ bii shí yí, buud ɔ lwámá wûm nə óbá bwə́ mú shísh wə́ Yésus zə cɨ nə nyə nə́: «Cɨɨ́g nə bwo nə́ bwə́ nyíŋgəg, bwə́ kə́g ŋgə já mə́kwáádə́ nə ibaafə́ yâ wa kúnə́-kúnə, bwə́ kə sɔ̧́ sâ mə́ də̂ nəcé sə́ bɨ́ wa bugád.» ");
INSERT INTO mcp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A mú cɨ nə bwo nə́: «Bɨmɛ́fwó yə́gá bwo sâ mə́ də̂.» Bwə́ nə nɛ́ nə́: «Sə́ cugɛ́ nə sâ, njɨ ibʉlɛ́d itɔ́ɔn nə oshú óbá. Ka njɨ nə́ sə́mɛ́fwó sə́ mə́ kə́ kusə búúd ɔ́ga bɛ̂sh idʉ̂w, í ka tɛɛm kwaga nə bwo.» ");
INSERT INTO mcp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Buud bwə́ á bə cínɔŋgʉ́ je bə budûm otɔ́ɔ́shin otɔ́ɔn. Yésus mú cɨ nə *ompwíín nə́ bwə́ jílʉg bwo shí ikínda ikínda, kínda jɛ̂sh nə buud je bə mə́wûm mə́tɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bwə́ mú nə́mə́ sá ntɔ́, shîn jil búúd bɛ̂sh shí. ");
INSERT INTO mcp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A mú ka ŋwa íbʉlɛ́d itɔ́ɔn nə oshú óbá ɔ́nɨ, a bʉ̂n mísh gwɔ̂w, yə Zɛmbî akíba. A mú fɛ̂y byo yə ómpwíín bɛ́ bwə́ kə ŋgə yə buud. ");
INSERT INTO mcp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Buud bɛ̂sh bwə́ mú də, jílə, idʉ̂w lʉ́g. Bwə́ mú sɛɛŋg íkʉ́l í á lʉ́g yí, wá mə́bwumúd tâŋ mə́bwumú wûm nə mə́bá. ");
INSERT INTO mcp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Í á ka zə bə, a mə́ kə koogʉ́ kə jəgʉla nə Zɛmbî, ompwíín bɛ́ bwə́ mú kə sɛɛŋgya nə nyə. A mú jí bwo nə́: «Buud bwə́ ŋgə cɨ nə́ mə jisə zə́?» ");
INSERT INTO mcp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bwə́ mú bɛ̧sa nə́: «Bɔ́ɔ́l búúd bwə́ ŋgə cɨ nə́ wo jisə Yuánɛs Nduu-buud, bɔ́ɔ́lʉ́gá nə́ wo jisə Eli, bɔ́ɔ́lʉ́gá nə́ wo jisə ŋgwɔ́l *múúd micúndə́ ayág mə́ gwûm yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A mú cɨ nə bwo nə́: «Ká bɨ bâŋ bɨ́ ŋgə cɨ nə́ mə jisə zə́?» Pyɛ̂r mú bɛ̧sa nə́: «Wo jisə *Krîst Zɛmbî nyə á ntɨ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yésus mú mpu báásʉlə bwo nə́ ci bwə́ kú bwɛlɛ jaaw múúd ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A mú ka jaaw bwo nə́: «Í jɨɨ shú mə́ *Mwân mə Múúd nə́ ocúmbá buud wâ lɔɔm nə milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ kə́g jág jugʉshi nyə, bwə́ kudʉwa nyə, bwə́ gwú ntâg nyə. Njɨ a bá gwûm shwoŋ dɨ́ jwɔ́w lʉ́ lɛ́ɛl.» ");
INSERT INTO mcp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A mú cɨ nə bɛ̂sh nə́: «Ŋkí muud mə́ cɛɛl bɛ̧ mə, a bə́g kú jagʉlə nyə́mɛ́fwó; a ŋkɛ́nyʉ́g kwolós jé jwɔ́w dɛ̂sh, bɛ̧ mə. ");
INSERT INTO mcp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nəcé, múúd mə ká kaambʉlə nə cʉg jé, a yida jímbal gwo. Nyɔɔŋg mə jímbál cʉg jé nəcé mə yɛ́, a faam. ");
INSERT INTO mcp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ŋkí muud mə́ bii mə́bii mɛ̂sh mâ shí ga, njɨ a yə, ŋkí ntâg nə́ a ntámá cʉg jé, wáyɛ́ mfíí nyə́ é bə nə ndɨ́ cínɔŋg yí? ");
INSERT INTO mcp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mpugá nə́ muud mə gwág mə shwôn, gwág íciyá byâm shwôn yɛ́, Mwân mə Múúd mə bá nə́mə́ gwág nyə shwôn ja á bá zə a ŋgə́ ŋkənʉwa məŋkənʉwa mɛ́ nə məŋkənʉwa mə Sɔ́ɔ́ŋgʉ́, bə́nɔ̂ŋ mifééshá mí *wəéŋgəles myɛ́ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, bɔ́ɔ́l búúd bʉ́sə́ wa ɔ́ga, bwə́ abʉ́lɛ́ bwɛlɛ yə, bwə́ kú fwo dʉ́g Faan mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Í á ka zə bə, Yésus mə́ shîn lás lə́sʉ́ nɨ, mwɔ̂w mə́ mú cɔ̧́ je bə mwɔɔmb, nyə á ŋwa Pyɛ̂r nə Yuánɛs nə Zhâk. Bə́nɔ́ŋ bwə́ mú bád mbʉ́ŋʉ́d gwɔ̂w kə jəgʉla nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ja nyə á ŋgə jəgʉla yí, mpwoombʉ́ nyɛ́ í á shwɔ̧́ɔ̧la, mikáándə́ myɛ́ mí mú bə ŋkí fumə, mí ŋgə́ faan nda njəs. ");
INSERT INTO mcp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Seegya nə́ buud obá, Moyîz bá Eli bwə́ mú bwə́ ŋgə́ lésha nə nyə. ");
INSERT INTO mcp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Moyîz bá Eli bwə́ á lwóya mənyúúl mílwanə́d. Bwə́ mú ŋgə lésha nə Yésus shú shwɨy á bá kə yə Yurʉ́səlɛm yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na nyə á bə, Pyɛ̂r bə́nɔ̂ŋ buud ɔ́ gwooŋg bɛ́ bwə́ mú ígwə́d nə́ cúg. Bwə́ á ka juum, bwə́ mú dʉ́g Yésus ŋgə́ jág ŋkənʉwa, buud obá bwə́ ŋgə́ lésha nə nyə. ");
INSERT INTO mcp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja Moyîz bá Eli bwə́ á ŋgə béégya nə Yésus yí, Pyɛ̂r nyə á cɨ nə Yésus nə́: «Mása, nywaálə ŋgə́lə ji wa. Sə́ shúməgá məbanda məlɔ́ɔl, ŋgwúd shú dwô, dúl shú mə́ Moyîz, dúlʉ́gá shú mə́ Eli.» Nyə a shígɛ́ mpu sâ nyə á ŋgə cɨ yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A ŋgə́ ná lás ntʉ́nɨ, seegya nə́ gúndə́ í mə́ zə búdal bɛ̂sh. Iŋkuŋkúúnd í mú bií bwo ja bwə́ mə́ dʉ́g gúndə́ mə́ búdal bwo yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kə́l í mú wú gúndə́ jɔɔŋg dɨ́ nə́: «Mwân waam mə́ á fɛ́ɛ́sh wə́ ɛ́ga. Ságá nyə məgwág.» ");
INSERT INTO mcp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ja kə́l í mə́ shîn lás ntʉ́nɨ yí, bwə́ mú dʉ́g Yésus njɨ nyəmɛ́fwó. Bwə́ mú ji ókʉ́l-ókʉ̂l. Bwə́ á ji mwɔ̂w mɔɔŋgʉ́d kú jaaw tɔɔ muud sâ bwə́ á dʉ́g yí. ");
INSERT INTO mcp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jwɔ̂w í á bɛ̧ cínɔŋg yí, bwə́ mə́ shulə wú mbʉ́ŋ dɨ, buud bwə́ mú zə bwəma nə nyə áncuncuma. ");
INSERT INTO mcp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ká gwág ɨɨ́, ŋgwɔ́l múúd mə́ kɨ̂m na mə́ŋkúmbə mə búúd dɨ́ nə́: «Yɨ́ɨ́gʉli, mə́ jəgʉla nə wo, kəndʉg mísh dʉ́g mwân waamə̂ dɨ́. Mə jɨ nə nyə njɨ ŋgwúd ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jamb í dʉ bii nyə, a mú dʉ kɨ̂m, ifúlug í dʉ́gə́ wɔ́ɔ́s nyə mpud. Jamb í dʉ jugʉshi nyə nə́ ndɛɛ́ í ka tɛɛm zə ŋgə bɨ́d nyə í mə́ fwo lídʉga. ");
INSERT INTO mcp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mə ámə jəgʉla nə *ompwíín bwô nə́ bwə́ yílʉ́g nyə jamb dɔɔŋgʉ́, bwə́ shígɛ́ kwag.» ");
INSERT INTO mcp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yésus músə káam nə́: «Wúu! yé óháádɛn ɔ́ga! A bɔ́wʉ́lə bɨ́ mitə́dʉ́gá e! Mə e bá kə nə bɨ̂ ntʉ́nɨ kə wɔ́ɔ́s ŋgow? Mə é bá jísɔw bɨ́ kə kumə jáyɛ́ ja? Zaá mə nə mwân woó wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mwân ŋgə́ shísh wə́ Yésus ɨɨ́, jamb mú kadʉwo nyə shí, ŋgə jág sagʉsə nyə. Yésus mú ŋkáánd nə jamb, a lwag mwân nə́ ndɛɛ́ a nyiŋg kənd nyə wə́ sɔ́ɔ́ŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dʉ́gʉ́lə búúd bɛ̂sh bwə́ á dʉ́g misɔ́ɔ́lʉ́gʉ́ mí Zɛmbî yí, bwə́ á káam ntɔ̧ ŋkûl. Buud bɛ̂sh bwə́ ŋgə́ ná káam isâ byɛ̂sh Yésus nyə á ŋgə sá yí, nyɛ mú cɨ nə ompwíín bɛ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Mpugá gwágʉlə lə́sʉ́ mə́ zə́ lás ga: *Mwân mə Múúd wál bá zə kaanz mə́bwə̂ mə́ búúdʉd.» ");
INSERT INTO mcp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Njɨ bâŋ bwə́ á shígɛ́ mpu gwág lə́sʉ́ wɔɔŋgʉ̂, í á bə bwo shwɨɨlyá nə́ bwə́ kú gwág nda í kə́ nə́. Bwə́ á ka ŋgə fúndə jílə nyə lə́sʉ́ wɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bwə́ mú zə tɛ́ɛ́d sɛ́ŋʉ́sálə mə́kə̂l nə́ bwə́ cɛɛl mpu nyɔɔŋg jɨ́ bul bə fwámɛ́ múúd bwə́dɨ́ gwooŋg dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Njɨ Yésus nyə á bwey mpu sâ bwə́ á ŋgə tə́dʉga bwə́dɨ́ mílámʉ́d yí. A mú ŋwa gúl kʉ́kágə́, tə́l nyə́dɨ́ kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A mú cɨ nə bwo nə́: «Muud mə lə́g kʉ́kágə́ ga jínə́ dâm dɨ́ yɛ́, a mə́ lə́g mə. Muud mə lə́g ntâg mə yɛ́, nyə alə́gɛ́ mə, a lə́g múúd nyə á ntɨ mə yɛ́. Mpugá nə́ muud mə ŋwá nyə́mɛ́fwó zhizhe mpə́dʉ́gá nyɨ́n yɛ́, nyə wə́ jɨ́ fwámɛ́ múúd ntɔ̧ bɔ́ɔ́l.» ");
INSERT INTO mcp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuánɛs mú ka zə lás cɨ nə́: «Mása, sə́ ámə dʉ́g ŋgwɔ́l múúd ŋgə́ balan nə jínə́ dwô, ŋgə yîl buud məjamb nə ndɨ̂. Sə́ ámə ka kaambʉlə nə nyə nə́ a kú ná ŋgə sá nəcé a cugɛ́ sə́dɨ́ gwooŋg dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yésus mú yidá bɛ̧sa nə nyə nə́: «Kúgá dʉ kaambʉlə nə́ a kú ŋgə sâ, nəcé muud nyə́ aŋgɛ̂ nə mpii bɨ́ yɛ́, jɨ bɨ́dɨ́ kɔ́ɔ́mbʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Fwála í á bə nə́ Yésus mə́ zə́ bá ŋkâŋ wú shí ga dɨ́ yí í á ŋgə shísh. Ntɔ́ Yésus nyə á ŋwa cígʉ́lá nə́ tɔɔ jɨ́ tɔɔ jɨ́ a kə́ Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nyə á ka lwâm bɔ́ɔ́l búúd nə́ bwə́ kə́g nyə shwóg. Bwə́ mú ŋwa zhɨ́ɨ́, kə nyíi dúl də́nd á Samaríya dɨ́ nə́ bwə́ kə́ kwəmʉsa, Yésus bâg kə shigʉla cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Njɨ, buud ɔ də́nd dɔɔŋgʉ́ bwə́ mú ban nə́ bwə́ alə́gɛ́ nyə nəcé nyə á ŋgə kə ŋgɛɛ́ Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nda *ómpwíín bɛ́ Zhâk bá Yuánɛs bwə́ á dʉ́g ntɔ́ nə́, bwə́ á cɨ nə nyə nə́: «Cwámba, ye wó jɨɨ nə́ sə́ jɔ́wʉ́g kuda í shúləg wú gwɔ̂w zə cumbal jígal bwo?» ");
INSERT INTO mcp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yésus mú yid, ŋkáánd nə bwo, nyə nə́: «Bɨ ampúyɛ́ wɔɔŋg shíshim í ŋgə́ shwambʉlə bɨ́ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bwə́ mú ŋwa zhɨ́ɨ́ kə dúl də́ndʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bwə́ ŋgə́ kyey zhɨ́ɨ́ nə zhɨɨ́, ŋgwɔ́l múúd mú cɨ nə Yésus nə́: «Mə zə́ bá dʉ bɛ̧ wo kʉ́l jɛ̂sh wó bá dʉ kə yí.» ");
INSERT INTO mcp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yésus mú cɨ nə nyə nə́: «Ontɔ̧́ bɨ́ nə miku, inunú nə maagɛ, njɨ *Mwân mə Múúd cugɛ́ nə ŋkúmba kʉ́l á dʉ́g já yí.» ");
INSERT INTO mcp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A mú cɨ nə ŋgwɔ́l múúd nə́: «Bɛ̧g mə.» Nyɨ́nɨ nə nɛ́ nə́: «Cwámba, fwog bɨ́d mə, mə kə́g dʉl sɔ́ɔ́ŋgʉ́ waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yésus mú cɨ nə nyə nə́: «Bɨ́dʉ́g mímbimbə mí dʉ́lʉg mimbimbə myáŋ. Wɛɛ, kaág ŋgə bwiiŋg buud Faan mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ŋgwɔ́l múúd mú nə́mə́ cɨ nə nyə nə́: «Cwámba, mə zə́ bɛ̧ wo. Njɨ bwándʉ́g nə́ mə fwóg kə jə́na nə njɔ́w búúd wâm.» ");
INSERT INTO mcp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yésus mú cɨ nə nyə nə́: «Múúd mə ká ŋkɛ̂ny bɔɔg nə́ á waad fambə́, a nyiŋgə yág dʉ́g mpʉ́sə, muud wɔɔŋgʉ̂ cugɛ́ nə mfíí Faan mə́ Zɛmbî dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ja Cwámba nyə a shîn lás isâ ínɨ yí, nyə a cwééd *ompwíín məwûm zaŋgbá nə óbá a mú kənd bwo nə́ bwə́ ŋgə́g nə kə óbá óbá íkʉ́l byɛ̂sh nyə́mɛ́fwó nyə á jəla nə kə yí. ");
INSERT INTO mcp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nyə a lás nə bwo nə́: «Dʉgá, idʉ̂w í mə́ tɨ́ fambə́ məŋkund məŋkund, njɨ buud bwə́ kə́ saag wá bʉ́sə cíg-cíg. Ntɔ́ wə́ mə́ cɨ́ nə́əə́: jə́gʉlagá nə amə́dɨ́ fambə́ nə́ a kə́ndʉg buud, bwə́ zə́g saag. ");
INSERT INTO mcp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kəgá, mə mə́ kənd bɨ́ nda bwán ɔ́ íncwəmbɛ mpə́dʉ́gá oŋkweny. ");
INSERT INTO mcp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muud kú kə nə *mwaanɛ̂ ŋkí kwáám. Muud kú ŋwa bɔ́ɔ́l osílʉ́faas; muud kú kə́ ji mə́bə́dád zhɨ́ɨ́ nə zhɨɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Njɔ́w wɛ̂sh bɨ́ mə́ nyíi yí, fwogá cɨ nə́: “Zɛmbî sáág nə́ bɨ bə́g nə́ shɛɛ.” ");
INSERT INTO mcp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ŋkí ŋgwɔ́l muud á nə́ shɛɛ jɨ cínɔŋgʉ́, məbə́dá mʉ́n mə́ kə nyə́dɨ́; ŋkí ntɔ́ dɨ́, mə́ nyiŋgə zə bɨ́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bɨ ɔ́ ji njɔ́w wɔɔŋgʉ́d, bɨ́ dʉ də nə ŋgul ísâ bwə́ é dʉ yə bɨ́ yí, nəcé sɔ́ɔl məsáal mə́ jəlá nə bə nə myə́na. Bɨ́ kú bá dʉ kyey mínjɔ́w minjɔ́w. ");
INSERT INTO mcp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ŋgwə́la wɛ̂sh bɨ́ é nyíi buud lə́g bɨ́ yí, bɨ ɔ́ də́ ísâ bwə́ yə́ bɨ́ cínɔŋg yí, ");
INSERT INTO mcp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","bɨ ɔ́ lwag mímbə̂l myâ cínɔŋg, bɨ́ jaaw bwo nə́ Faan mə́ Zɛmbî í mú bɨ́ kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wɔɔŋg ŋgwə́la bɨ́ mə́ nyíi buud kú lə́g bɨ́ yí, bɨ́ kə tâm də́nd kə lás nə́: ");
INSERT INTO mcp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Sə́ mə́ kudə yə bɨ́ fumbyá a ŋgwə́la wʉ́n í ámə nada sə́ mə́kuú dɨ́ yí. Njɨ mpugá nə́ Faan mə́ Zɛmbî í mə́ shísh kúnə́-kúnə.” ");
INSERT INTO mcp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mə mpú jaaw bɨ́ nə́ jwɔ̂w Zɛmbî mə bá zə sámb búúd milə́sʉ́ yí, a bá jagʉlə búúd ɔ Sódom ntɔ̧ ŋgwə́la wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Məntágʉla nə bɨ́ buud ɔ́ Korazín. Məntágʉla nə bɨ́ buud ɔ́ Bɛtʉsayída nə́mə́. Nəcé bímbí lʉ́ *mə́shimbá mə́ mə́ wɔ́ɔ́s bɨ́dɨ́ má, mə́ á mbə̂m wɔ́ɔ́s Tir nə Sidon, buud ɔ́ nûŋ bwə́ á mbə̂m nə́mə́ bwey bwáád míŋkud ji ífiî dɨ̂ nə́ bwə́ cɛ́nd mítə́dʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nə́ ndɛɛ́, cígʉ́lɛ́ mílə́sʉ́ dɨ, intʉ́gʉ́lí i Tir nə Sodom í ábʉ́lɛ́ bul nyaan nda bɨ́ bɨ́n. ");
INSERT INTO mcp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bɨ bâŋ buud ɔ́ Kapɛrnawûm, bɨ́ ŋgə tə́dʉga nə́ bɨ mə bá kə gwɔ̂w? Mbɔ̂, bɨ mə bá yidá shulə kə baŋ mínjîm. ");
INSERT INTO mcp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Muud mə gwágʉ́lə́ bɨ́ yɛ́, mə́ gwágʉlə mə. Muud mə bə́ kú gwágʉlə bɨ́ yɛ́, mə́ bə kú gwágʉlə mə. Muud mə bə́ ntâg kú gwágʉlə mə yɛ́, a mə́ bə kú gwágʉlə múúd nyə á ntɨ mə yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","*Ompwíín məwûm zaŋgbá nə óbá bwə́ mú kə nyiŋgə nə məshusʉg bwə́ ŋgə́ cɨ nə́: «Cwámba, tɛɛm bə mə́jamb mə́ ámə ŋgə bə nə məgwág nə sə́ ja sə́ ámə ŋgə lás nə mwo jínə́ dwô dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A mú cɨ nə bwo nə́: «Mə á ŋgə dʉ́g *Sátan ŋgə́ kud wú gwɔ̂w nda njəs. ");
INSERT INTO mcp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mə mə́ yə bɨ́ ŋkul ijwûga nə́ bɨ nyáálʉg onywâ nə wəacə́laafə̂ nə məkuú, bɨ́ nyaal nə́mə́ mpífə́ mə́ múúd ŋgə́ lúmbʉli nə bɨ́ yɛ́ nyɛ̂sh, sâ kú sá bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Njɨ bɨ kú bul gwág mə́shusʉg nə məjamb ŋgə́lə magʉlə ijwûga bín, yidagá gwág mə́shusʉg nə mínə́ mʉ́n bə́lə cilyá gwɔ̂w joŋ dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nə́mə́ wəla dɔɔŋgʉ́ dɨ, Yésus mú kɔɔs nə məshusʉg mə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim, a mú cɨ nə́: «Pʉpa, Cwámba á gwɔ̂w nə shí, mə yə́ wo gúmə́ nəcé wo á shweel ompuye bə́nɔ̂ŋ buud ɔ́ fʉg isâ íga, wo yida lwágʉlə ozhizhe ɔ búúd. Haaw Pʉpa, ntɔ́ wə́ wó á cɛɛl nə́ í bə́g yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dâ nyə a cwámbʉlə mə isâ byɛ̂sh. Kú nə muud mə mpú Zɛmbî Mwân, njɨ Sɔ́ɔ́ŋgʉ́; kú nə́mə́ nə muud mə mpú Zɛmbî Sɔ́ɔ́ŋgʉ́, njɨ mwân nə muud yɛ̂sh mwân mə́ cɛ́ɛ́l sá nə́ a mpúg yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A mú yág dʉ́g ómpwíín bɛ́, cɨ nə njɨ bwo nə́: «Bɨ bâŋ mísh mʉ́n mə́ mə́ jəla nəcé mə́ ŋgə dʉ́g isâ bɨ́ ŋgə́ dʉ́g ínɨ. ");
INSERT INTO mcp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bʉ́bə́lɛ́ mə́ jaaw bɨ́ nə́, zhwog *buud ɔ mícúndə́ nə minjwú-buud mí á cɛɛl dʉ́g sâ bɨ́ ŋgə́ dʉ́g yí, njɨ mí áshígɛ́ dʉ́g. Bwə́ á cɛɛl gwág sâ bɨ́ ŋgə́ gwág yí, njɨ bwə́ áshígɛ́ gwág.» ");
INSERT INTO mcp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ka dʉ́g nə́, ŋgwɔ́l *Ŋkumɛ məcɛ̧ɛ̧ mə́ zə bwɔ́wʉlə nyə jî nyə nə́: «Yɨ́ɨ́gʉli, mə sáág jɨ́ nə́ mə lə́gʉ́g cʉg á kandʉgə kandʉgə?» ");
INSERT INTO mcp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nyə ntâg nə nɛ́ nə́: «Jɨ́ jɨ́ cilyá *mbwoomb mə́cɛ̧ɛ̧ dɨ́ yí? Wó dʉ lɔ̧́ cínɔŋg nə́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A mú bɛ̧sa nə́: «Wó jəlá nə cɛɛl Zɛmbî woó Yawé nə lâm wô wɛ̂sh, nə *shíshim wô wɛ̂sh, nə ŋkul nywô nyɛ̂sh, nə lúú wô wɛ̂sh. Wo cɛɛl nə́mə́ múúd yɛ̂sh jísə́ wo kúnə́-kúnə yɛ́ nda womɛ́fwó.» ");
INSERT INTO mcp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yésus nə nɛ́ nə́: «Wo mə́ bɛ̧sa mbií í jə́la yí. Sáág ntɔ́ wo bâg dʉ cʉg.» ");
INSERT INTO mcp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nyɛ, cɛɛlʉ́lə lwágʉlə nə́ a jɨ tʉ́təlí, a mú jî Yésus nə́: «Muud jɨ́ mə kúnə́-kúnə wə́ zə́?» ");
INSERT INTO mcp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yésus mú nyiŋgə lás, a mú cɨ nə́: «Ŋgwɔ́l múúd nyə á ŋgə wú Yurʉ́səlɛm ŋgə shulə kə Zheríko. Izhilʉŋgaanə́ í mú bií nyə zhɨ́ɨ́d, dɛ́ɛ́g nyə isâ byé byɛ̂sh, yíd nyə nə́ ndɛɛ́ lʉ́gə nyə cíg-cîg nə́ á fudə. ");
INSERT INTO mcp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Í mú jé nə́ ŋgwɔ́l fada kyéyʉg zhɨ́ɨ́ nyɔɔŋgʉ́d. A mú dʉ́g múúd wɔɔŋgʉ̂, a mú cɔ̧́ lúú tə́l gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ŋgwɔ́l *Levît mú nə́mə́ zə wɔ́ɔ́s kʉ́l jɔɔŋgʉ́d, a dʉ́g múúd ɛ́nɛ, a cɔ̧́ lúú tə́l gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Njɨ ŋgwɔ́l múúd á Samaríya ŋgə́ nə́mə́ kyey yé njɔɔnd ɨɨ́, a mú wɔ́ɔ́s kʉ́l múúd ɛ́nɛ nyə á bə a mbwúg yí. Ja á mə́ dʉ́g nyə yí, lâm mú bul cɛy nyə cwû. ");
INSERT INTO mcp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A mú shísh kúnə́-kúnə, a lwag nyə məfə́ŋ nə məwúdə nə wáan nə́ ndɛɛ́ a shîn wɔ́ɔlə. A mú ŋkɛ̂ny nyə bəd nyə́dɨ́ jakáás dɨ́, kə nə nyə njɔ́w ójôŋ kə kweemb nyə. ");
INSERT INTO mcp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mán mələ̂m, muud á Samaríya mú ŋwa ódanarî obá, yə múúd njɔ́w ójôŋ. Nyə nə nɛ́ nə́: “Kweembʉgʉ́ mə muud ɛ́ga. Bímbí dɛ̂sh wo é kwo kɛɛnzh shú dɛ́ yí, mə é zə nyiŋg wo ja mə é nyiŋgə yí”». ");
INSERT INTO mcp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yésus mú jî nə́: «Búúd olɔ́ɔl ɔ́nɨ bɛ̂sh dɨ́, nyáyɛ́ nyə á bə muud ízhilʉŋgaanə́ í á yíd yɛ́ kúnə́-kúnə yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yɨ́ɨ́gʉli məcɛ̧ɛ̧ nə́: «Jísə nyɔɔŋg nyə á gwág nyə cɛy lámʉ́d yɛ́.» Yésus mú cɨ nə nyə nə́: «Kaág, wo kə́g sá ntɔ́.» ");
INSERT INTO mcp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ja Yésus bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ á ŋgə kyey yí, bwə́ á kə nyíi dúl də́ndʉ́d. Ŋgwɔ́l múdá nyə á bə də́nd dɔɔŋg dɨ́ nə́ Mááta, a mú lə́g bwo nyə́dɨ́ njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mudá wɔɔŋg nyə á bə nə mínyɔŋʉ̂ nə́ Maríya. Nyə á zə ji Cwámba shí məkuú, dʉ gwágʉlə lə́sʉ́ yé. ");
INSERT INTO mcp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mááta nyɛ nyə á ŋgə yɨ́ɨ́ŋga nə zhwog iság-ság shú ójôŋ. A mú ka zə, zə cɨ nə Cwámba nə́: «Ja Maríya mə́ yida bɨ́d nə́ mə ŋgə́g nə sɛ̂y məmɛ́fwó ga, sâ jɔɔŋg í acɨ́yɛ́ wo sâ? Cɨɨ́g nə nyə nə́ a zə́g kwiid mə.» ");
INSERT INTO mcp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Cwámba mú bɛ̧sa nə nyə nə́: «Mááta, Mááta, wo ŋgə kənd lâm gwɔ̂w ŋgə ntágʉlə nyúúl nə zhwog isâ. ");
INSERT INTO mcp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sâ jɨ́ nə mfíí yí jɨ́ njɨ ŋgwúd. Maríya mə́ fɛ́ɛ́sh sâ í búl nywa yí, muud nyə abʉ́lɛ kwo ŋwa nyə gwo.» ");
INSERT INTO mcp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dúl jwɔ̂w dɨ, Yésus nyə á bə gúl kʉ́kʉ́lʉ́d a ŋgə́ jəgʉla. Ja nyə á yɔw jəgʉlálə yí, ŋgwɔ́l *mpwíín yé mú cɨ nə nyə nə́: «Cwámba, jɨ́ɨ́gʉ́líg sə́ jəgʉlálə nda Yuánɛs nyə a jɨ́ɨ́gʉli bɛ́ ómpwíín nə́.» ");
INSERT INTO mcp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yésus mú cɨ nə bwo nə́: «Ja bɨ́ mə́ bá dʉ jəgʉla yí, bɨ ɔ bá dʉ cɨ nə́: Pʉpa, Jínə́ dwô í bə́g nə gúmə́ ntɔ̧ sâ jɛ̂sh. Ijwûga byô í zə́g. ");
INSERT INTO mcp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yə́g sə́ idʉ̂w í jə́lá nə sə́ yí jwɔ́w dɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Juug sə́ *misə́m mísʉ́ nəcé sə́ ŋgə nə́mə́ juu buud bwə́ ŋgə́ byaagʉlə nə sə́ wá. Wo kú bɨ́d nə́ mə́bwə́bʉ́lán mə́ ntɔ̧́ sə́ ŋkul.» ");
INSERT INTO mcp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A mú nyiŋgə cɨ nə bwo nə́: «Shé fwógá ná cɨ nə́ ŋgwɔ́l múúd na bɨ́dɨ́ jɨ nə yé shwə́. Muud wɔɔŋgʉ̂ ka kə wə́ shwə́ yé mpwó-bulú kə cɨ nə nyə nə́: “Wɛy e, kwalʉg ná mə ibʉlɛ́d ilɔ́ɔl ");
INSERT INTO mcp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nəcé ŋgwɔ́l shwə́ waamə́ ŋgə zhu njɔɔnd dɨ́, a mə́ wɔ́ɔ́s mə kâ njɔ́w mə kú nə sâ mə́ yə́ nyə.” ");
INSERT INTO mcp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Shé fwógá ná cɨ nə́ shwə́ yé mə́ bɛ̧sa nə nyə nûŋ njɔ́w dɨ́ cwû nə́: “Kú zə ntágʉlə mə, sə́nɔ̂ŋ bwân bâm sə́ mə́ bwey já shí, mə cugɛ́ nə ŋkul wɔɔl zə yə wo ibʉlɛ́d.” ");
INSERT INTO mcp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mə́ jaaw bɨ́ nə́, tɛɛm bə nə́ a cugɛ́ nə ŋkul wɔɔl zə yə nyə ibʉlɛ́d nə́ a jɨ shwə́ yé, nyə é wɔɔl nəcé ŋgwɔ́l sálə káŋgá ŋgwóómbʉ́lú, nyə é zə yə nyə sâ jɛ̂sh á ŋgə́ gwáámb yí. ");
INSERT INTO mcp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Mɛɛ mə́ ka cɨ nə bɨ́ nə́: Gwáámbʉ́gá Zɛmbî, nyə é yə bɨ̂; sɔ̧́gá, nyə e lwó bɨ̂; kudəgá mbɛ̂, nyə é juw. ");
INSERT INTO mcp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nəcé muud mə gwáámb yɛ́ nyə é bii, muud mə sɔ̧́ yɛ́ nyə é kwey, múúd mə ká kudə mpumbɛ́, bwə́ juw nyə wə. ");
INSERT INTO mcp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nyáyɛ́ sɔ́ɔ́ŋgʉ́ mwân na bɨ́dɨ́ gwooŋg dɨ́ jɨ́ nə ŋkul sá nə́ mwân yé gwáámb nyə shû, a yidá yə nyə kuwó nywâ yɛ́? ");
INSERT INTO mcp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ŋkí ntâg nə́ Mwân yé gwáámb nyə́ kɨ́ɨ́, a yidá yə nyə acə́laafə̂? ");
INSERT INTO mcp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ŋkə́mʉ́sá bɨ̂, tɛɛm bə nda bɨ́ bʉ́sə nə mbíya mílâm nɨ, bɨ mə́ dʉ yə bwân bʉ́n isâ í ányunywaâ. Ŋkəmʉsa nə Dâ á gwɔ̂w; ŋkí bɨ mə gwáámb nyə Ŋkɛ̧́ŋkɛ̧̂ Shíshim, a yə bɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yésus nyə á ŋgə yîl muud jamb í á wá nyə mə́ŋkədad nə́ a bə́g fífî yí. Í á ka bə nə́, ja jamb í á wú yí, muud wɔɔŋgʉ̂ nyə a tɛ́ɛ́d lásʉ́lə, buud bɛ̂sh bwə́ mú ŋgə káam. ");
INSERT INTO mcp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bɔ́ɔ́l búúd wâ cínɔŋgʉ́ bâŋ bwə́ mú yidá cɨ nə́ Bɛlʉzebul wə́ ŋgə́ yə Yésus ŋkul nə́ a ŋgə́g nə yîl buud məjamb. ");
INSERT INTO mcp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bɔ́ɔ́lʉ́gá bwə́ mú zə nə njígá mə́bwə́bʉ́lán wə́ Yésus, zə cɨ nə́ a wééshʉ́g bwo gúl *sâ í ntɔ̧́ búúd ŋkwóŋ yí, í ŋgə́ zhu gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nyɛ mú mpu mítə́dʉ́gá myáŋ, a mú ka cɨ nə bwo nə́: «Búúd ɔ dúl faan bwə́ ká bɔ́ɔ́g ŋgə lúmbʉli bwə́mɛ́ nə bwə́mɛ́, faan dɔɔŋg í é jɛ̧ɛ̧ nə́ mpaá. Búúd ɔ wúl njɔ́w bwə́ ká bɔ́ɔ́g ŋgə lúmbʉli bwə́mɛ́ nə bwə́mɛ́, njɔ́w búúd wɔɔŋg jímb. ");
INSERT INTO mcp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bɨ́ ŋgə cɨ nə́ Bɛlʉzebul wə́ ŋgə́ yə mə ŋkul nə́ mə ŋgə́g nə yîl buud məjamb. Ntɔ́ jɨ nə́ *Sátan mə́ yida nyiŋgə cuwo, ŋgə yîl nyəmɛ́fwó. Ká dɛ́ faan í é ka tɔ̂w na ntʉdɛl? ");
INSERT INTO mcp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ŋkí Bɛlʉzebul wə́ ŋgə́ yə mə ŋkul nə́ mə ŋgə́g yîl buud məjamb nda bɨ́ ŋgə́ cɨ nə́, zə́ nyɛ ŋgə́ yə buud bʉ́n ŋkul nyɔɔŋgʉ̂? Ŋgaá bwə́mɛ́fwó bwə́ ŋgə mpu lwágʉlə bɨ́ nə́ sáŋ nə́ bɨ bʉ́sə nə məbɛ̧ɛ̧́? ");
INSERT INTO mcp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Njɨ, ŋkí nyinə́ mbwə̂ mə́ Zɛmbî wə́ í ŋgə́ yə mə ŋkul nə́ mə yílʉ́g buud məjamb ɨɨ́, mpugá nə́ Faan mə́ Zɛmbî í mú wa. ");
INSERT INTO mcp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ja ŋkuŋkúl múúd wɨ́ nə fwámɛ́ ísâ í dɔ́ɔ́mb í ŋgə́ baagʉlə njɔ́w yé yí, muud cugɛ́ nə ŋkul kúnya nə məbii mɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Njɨ múúd mə ntɔ̧́ nyə ŋkul yɛ́ mə́ ká nə́mə́ zə, zə figə nyə shí dɛ́ɛ́g nyə məkwɔ̧ɔ̧ mə dɔ́ɔ́mb á dʉ *búgʉla má, muud wɔɔŋg mú ka tɛɛm ŋwa mə́bii mɛ́ ŋgə kaaw buud. ");
INSERT INTO mcp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Muud mə bə́ kú kɛɛm mə yɛ́ ŋgə lúmbʉli nə mə. Muud mə bə́ kú zə wá mə́bwə̂ nə́ sə́ná sə́ sɛ́ɛ́ŋgʉg yɛ́, a ŋgə yida caam.» ");
INSERT INTO mcp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Ja bɔ́w-bɔ̂w shíshim í dʉ wú múúd nyúúlʉ́d yí, í dʉ kə ŋgə jɛ̧́ɛ̧la mə́shí mâ mishwééshá ŋgə́lə sɔ̧́ wogá. Njɨ ŋkí í bə́ kú kwey wogá, í mú tə́dʉga nə́: “Mə zə́ nyiŋgə kə mə́dɨ́ njɔ́w kʉ́l mə́ á fwo dʉ ji yí.” ");
INSERT INTO mcp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Í ká zə kwey njɔ́w ŋgwámbʉ́lá, sâ jɛ̂sh jɔ̧ kwambʉlá, ");
INSERT INTO mcp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","í é kə ŋwa mílʉ́gá míshíshim zaŋgbá mí njúl nə ŋkʉ́d ntɔ̧ wə́mɛ́fwó, bə́nɔ́ŋ bɛ̂sh bwə́ mú kə nyíi njɔ́w, kwambʉlə jiya cínɔŋg. Nə́ ndɛɛ́, cʉg mə múúd wɔɔŋgʉ̂ í mú nyiŋgə jág bɔ̂w, ntɔ̧ mbií í á fwó dʉ bə yí.» ");
INSERT INTO mcp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Í á ka zə bə, Yésus ŋgə́ lás ntʉ́nɨ, ŋgwɔ́l múdá mú wééshʉli kə́l mə́ŋkúmbə mə búúd dɨ́ cɨ nə nyə nə́: «Mudá nyə á byá wo nyɛ́ɛ́ŋg wo yɛ́ nywáá mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yésus nyɛ mú cɨ nə́: «Buud bwə́ ŋgə́ gwág Milə́sʉ́ mí Zɛmbî wá, bwə́ ŋgə́ sá nda mí ŋgə́ cɨ nə́, bwó wə́ bwə́ mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Buud bwə́ á ka ŋgə sɛɛŋgya ŋkí bulya. Yésus mú cɨ nə bwo nə́: «Mbɛɛ kala búúd í njúl ŋkí bɔ̂w, í bə́lɛ́ jí nə́ mə wééshʉ́g bwo gúl *sâ í ntɔ̧́ búúd ŋkwóŋ yí! Bwə́ abʉ́lɛ́ dʉ́g gúl sâ í ntɔ̧́ búúd ŋkwóŋ yí, njɨ jɔɔŋg í á bə nə Zhwónas yí. ");
INSERT INTO mcp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nda Zhwónas nyə á bə sâ í á ntɔ̧ buud ɔ Ninivə ŋkul nə́, ntɔ́ nə́mə́ wə́ *Mwân mə́ Múúd nyə́ é bə sâ í ntɔ̧́ búúd ɔ kala ga ŋkul yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jwɔ̂w Zɛmbî mə bá zə sámb búúd milə́sʉ́ yí, Cî ámudâ í á wú *mə́kɔ́ɔ́l mə́ jwɔ̂w yí í bá tɔ̂w tʉ́təlí yə kala búúd ga məbɛ̧ɛ̧́. Nəcé nyə á gwaa zhu íjumə i shíd zə gwágʉlə fʉg mə́ Sə́lʉmun. Dʉgá, sâ í ntɔ̧́ Sə́lʉmun yí jísə wa. ");
INSERT INTO mcp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Buud ɔ́ Ninivə bwə́ bá nə́mə́ tɔ̂w tʉ́təlí, yə kala búúd ga məbɛ̧ɛ̧́. Nəcé báá bwə́ á cɛ́nd mítə́dʉ́gá ja bwə́ á gwág cúndə́ Zhwónas nyə a cúndə yí. Dʉgá, sâ í ntɔ̧́ Zhwónas yí jísə wa. ");
INSERT INTO mcp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Muud cugɛ́ nə ŋkul sá nə́, a jida lámba nə́ ndɛɛ́ a kə shweel dwo shí tʉ́wʉli. Í dʉ bə a yida tə̂l dwo cé lámba dɨ́ nə́ buud bwə́ nyíi njɔ́w wá bwə́ dʉ́gʉ́g məŋkɛnya. ");
INSERT INTO mcp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jús dwô dʉ́sə lámba á nyúúl nywô. Jús dwô í ká bə kú nə bwas ɨɨ́, nyúúl nywô nyɛ̂sh bə mə́ŋkɛnyad. Njɨ, jús dwô í ká bə ŋkí bɔ̂w, nyúúl nywô bə yídʉ́gʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ntɔ́, wo ɔ́ bɛy nə́ məŋkɛnya mə́sə́ wódɨ́ má mə́ bə́g yídʉ́gʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ŋkí nyúúl nywô nyɛ̂sh í bə́ mə́ŋkɛnya dɨ́ kú nə kʉ́kʉ́l jísə́ yídʉ́gʉ́d yí, nyúúl nywô nyɛ̂sh í faan nda ja lámba í kwan wo nə məŋkɛnya mɛ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ja Yésus nyə a shîn lás yí ŋgwɔ́l *Farizyɛ̂ŋ nyə a jɔ̂w nyə nə́ a kə́g də nyə́dɨ́ njɔ́w. Yésus nyə á ka nə́mə́ kə, kə ji shí kə́lə də. ");
INSERT INTO mcp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farizyɛ̂ŋ ɛ́nɛ mú káam nə́ Yésus nyə a shígɛ́ sá ŋgusa bwə́ dʉ sá shúshwóógʉ́ nə́ bwə́ zə́g də yí. ");
INSERT INTO mcp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Cwámba mú cɨ nə nyə nə́: «Bɨ bâŋ Ofarizyɛ̂ŋ bɨ mə́ dʉ sá nə́ bɨ́ gusa kwoŋ bálá nə kwoŋ shúyá, cwû nyɛ njúl bɨ́ lwándʉ́lá nə isâ í mándá, nə bɔ́w-bɔ̂w ísâ. ");
INSERT INTO mcp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yé ílad íga! Ŋgaá nə́ muud nyə á sá tɔ́ɔ́n yɛ́, nyə nə́mə́ wə́ nyə a sá cwû? ");
INSERT INTO mcp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yidagá kɛɛnzh ísâ bísə́ cwû yí, yə mímbúmbúwá, isâ byɛ̂sh í mú bə bɨ́ ŋkí ŋkɛ̧̂. ");
INSERT INTO mcp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Məntágʉla nə bɨ́ Ofarizyɛ̂ŋ nəcé isâ nda mânt nə ru nə bíl íkáá í də̂ byɛ̂sh, bɨ́ ŋgə yə Zɛmbî *ŋkɔw wûm á isâ byɔɔŋgʉ̂, bɨ́ yida mpyêny cʉgə́lə nə buud tʉ́təlí nə cɛɛlʉ́lə Zɛmbî. Í njúl nə́ sâ bɨ́ mə́ jə́lá nə sá wə́ nɨ, kú yida mpyêny byɔɔŋg bɨ́ ŋgə́ bwey sá yí. ");
INSERT INTO mcp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Məntágʉla nə bɨ́ Ofarizyɛ̂ŋ nəcé bɨ mə́ cɛɛl kə dʉ ji njɨ íjiya yâ shwóg ja bɨ́ bʉ́sə́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ́ yí; bɨ mə́ cɛɛl nə́mə́ nə́ buud bwə́ dʉ́g bə́da bɨ́ məbə́dá mə́ gúmə́ mə́ŋkúmbə mə búúd dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Məntágʉla nə bɨ́ nəcé bɨ bʉ́sə nda məshwoŋ mə́sə́ kú nə məyɨɨgyé; buud bwə́ dʉ kyey mwo gwɔ̂w kú mpu.» ");
INSERT INTO mcp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ŋgwɔ́l *Ŋkumɛ məcɛ̧ɛ̧ mú bɛ̧sa nə Yésus nə́: «Yɨ́ɨ́gʉli, ja wó ŋgə́ lás ntʉ́nɨ nɨ, wo ŋgə́lə nə́mə́ lwîy sə́ ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yésus mú cɨ nə́: «Məntágʉla nə bɨ́ *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ nə́mə́, nəcé bɨ mə́ dʉ zhimb búúd jilə-jilə mímbag záməbag, í njúl nə́ bɨmɛ́fwó bɨ ádɛ́ bwɛlɛ sʉ́sal nyinə́ nə́ bɨ mə́ kwiid bwo nə ŋkɛ́nyʉ́lə myo. ");
INSERT INTO mcp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Məntágʉla nə bɨ́ nəcé bɨ́ ŋgə lwɔ̧́ məshwoŋ mə *búúd ɔ mícúndə́ ímpáámbə́ bɨ́n í á dʉ gwú yí. ");
INSERT INTO mcp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ntɔ́ jɨ nə́ bɨ́ ŋgə bwaagʉlə misɔ́ɔ́lʉ́gʉ́ mí ímpáámbə́ bín, bɨ́ ŋgə gwág myo nywa. Bâŋ bwə́ á gwú, bɨ mú zə lwɔ̧́ mə́shwoŋ. ");
INSERT INTO mcp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gwə́ wə́ jɨ́ nə́, Zɛmbî nyə á cɨ fʉ́g nyɛ́ dɨ́ nə́: “Mə bá dʉ kənd bwo buud ɔ mícúndə́ nə *buud ɔ lwámá. Bwə́ bá dʉ gwú bɔ́ɔ́l wâ cínɔŋgʉ́, bwə́ lwágʉlə bɔ́ɔ́lʉ́gá cúwʉ́lí. ");
INSERT INTO mcp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bwə́ bá dʉ sá ntɔ́ shú nə́ kala búúd ga í bâg tɔ̂w kɔɔd dɨ́ nəcé məcií mə búúd ɔ mícúndə́ bɛ̂sh bwə́ á gwúyɔw tɛ́ɛ́d mə́tɛ́ɛ́dʉ́lé mə́ shí wá. ");
INSERT INTO mcp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Í bá bə, tɛ́ɛ́d mə́cií mə́ Abɛl zə wɔ́ɔ́s mɨ́ mə́ Zakarî nyə á gwúyɔw mpə́dʉ́gá *alatâr nə Njɔ́w Zɛmbî yɛ́.” Haaw. Mə mpú jaaw bɨ́ nə́ kala búúd ga í bá tɔ̂w kɔɔd dɨ́ nəcé məcií mɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Məntágʉla nə bɨ́ Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ nəcé bɨ a mə́ mánda juwʉga jɨ́ nə ŋkul juw búúd mbɛ̂ nə́ bwə́ bə́g nə mpúyá yí. Bɨmɛ́fwó bɨ anyííyɛ́ mpúyá wɔɔŋgʉ́d, bɨ́ kú nə́mə́ nyiŋgə bɨ́d nə́ bɔɔŋg bwə́ ŋgə́ cɛɛl nyíi wá, bwə́ nyííg.» ");
INSERT INTO mcp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ja Yésus nyə a wú njɔ́w wɔɔŋg dɨ́ cúwo tɔ́ɔ́n yí, *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ Ofarizyɛ̂ŋ bwə́ á ŋgə nándʉlə nyə nə zhwog mishílí ŋgə jî nyə isâ mimbií mimbií, ");
INSERT INTO mcp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bwə́ ŋgə́ bwéél nə́ a lásʉ́g gúl sâ abʉ́bɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ja jɔɔŋgʉ̂, buud bwə́ á sɛɛŋgya ŋkí jág bulya mbií bwə́ cúgɛ́ nə ŋkul lɔ̧́ yí, bɔ́ɔ́l bwə́ ŋgə́ nyaal bɔ́ɔ́l. Yésus mú ka zə fwo tɛ́ɛ́d lás nə *ompwíín bɛ́ nə́: «Jigá ncə̂ nə *Ofarizyɛ̂ŋ *ləvur wáŋ, ntɔ́ jɨ nə́ kwába bʉ́sə́ nə ndɨ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kú nə sâ á mbúdʉ́lá í bá bwên kú bʉ́gʉli, ŋkí sâ á shwoó í bwên kú mpûy. ");
INSERT INTO mcp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gwə́ wə́ jɨ́ nə́, sâ jɛ̂sh bɨ́ mə́ lás yídʉ́gʉ́d yí, í bá gwɨ́ɨ́g mə́ŋkɛnyad; jɔɔŋg bɨ́ mə́ nyímbʉ́lá nə muud lwə́d kʉ́l fúm yí, bwə́ bá ŋgə cúndə gwo íkwalʉ́minúd. ");
INSERT INTO mcp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mə́ cɨ nə bɨ́ oshwə́ bâm nə́, kúgá dʉ fúndə búúd bɨ́ nə ŋkul gwú njɨ nyúul kú ná kwo sá gúl sâ mpʉ́sə wɔɔŋg wá. ");
INSERT INTO mcp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mə zə́ lwágʉlə bɨ́ muud bɨ́ mə́ jə́lá nə fúndə yɛ́. Fúndə́gá muud jɨ́ nə ŋkul ijwûga nə́ a gwú múúd, a kənd nə́mə́ nyə kuda á kandʉgə dɨ́ yɛ́. Haaw, mə ŋgə cɨ nə́ nyə wə́ bɨ́ mə́ jə́lá nə fúndə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ŋgaá nə́ bwə́ dʉ kusha mímbá-kwáádə́ mitɔ́ɔn ifáda íbá? Tɛɛm bə ntɔ́, Zɛmbî nyə awúsáyɛ́ tɔɔ mbá-kwáádə́ ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bɨ bâŋ ntâg ɨɨ́, Zɛmbî mə mpú bímbí lʉ́ íntand í shilú bísə́ bɨ́ mílúúd yí. Nə́ ndɛɛ́, kúgá dʉ fúndə. Mpugá nə́ bɨ́ mə́ cɛy Zɛmbî lámʉ́d cɔ̧́ mimbá-kwáádə́ ŋkí bulya. ");
INSERT INTO mcp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mə́ jaaw bɨ́ nə́ muud yɛ̂sh mə mágʉ́lə́ mə mísh mə́ búúd dɨ́ yɛ́, *Mwân mə Múúd mə bá nə́mə́ magʉlə nyə mísh mə́ *wə́éŋgəles ɔ́ Zɛmbî dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Njɨ, nyɔɔŋg mə kɨ́ɨ́lyá mə mísh mə́ búúd dɨ́ yɛ́, Mwán mə Múúd nyə é kɨ́ɨ́lya nə́mə́ nyə mísh mə́ wə́éŋgəles ɔ́ Zɛmbî dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Muud yɛ̂sh mə bá jág lás nə Mwân mə Múúd yɛ́ mə́ bá bə nə ijuugá. Njɨ nyɔɔŋg mə bá kə nə *bwaasʉ́lə mpu wə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim yɛ́ nyə abʉ́lɛ bə nə ijuugá. ");
INSERT INTO mcp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ja bwə́ bá dʉ kə nə bɨ́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ̂, nə ósémbye ɔ mílə́sʉ́ dɨ́, ŋkí ójwú ɔ́ lɔɔm dɨ́ yí, bɨ kú bá dʉ yágʉwo mbií bɨ́ mə́ bá shwɔ̧ mə́nyúúl yí, kú yágʉwo íciyá í kɔɔd. ");
INSERT INTO mcp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nəcé Ŋkɛ̧́ŋkɛ̧̂ Shíshim mə bá dʉ jɨ́ɨ́gʉli bɨ́ lə́sʉ́ bɨ́ mə́ bá dʉ lás yí cé jɔɔŋgʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋgwɔ́l múúd nyə á ka lás mə́ŋkúmbə mə búúd dɨ́ nə́: «Yɨ́ɨ́gʉli, cɨɨ́g nə mínyɔŋʉ̂ waamə́ nə́ a kááwʉg sá məbii sɔ́ɔ́ŋgʉ́ wúsʉ́ nyə a lʉ́gə sə́ nə ndɨ̂ má.» ");
INSERT INTO mcp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yésus mú cɨ nə nyə nə́: «Muud ɛ́ga, zə́ nyə a tə̂l mə nə́ mə dʉ́g sámb bɨ́ milə́sʉ́ dʉ kaaw bɨ́ məŋkɔw?» ");
INSERT INTO mcp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A mú cɨ nə bɛ̂sh nə́: «Bɨ ɔ́ bɛy, bɨ ɔ káálʉ́gə́ nə ŋkɔ́ɔ́g. Nəcé, muud tɛɛm bə nə məbii məŋkund məŋkund ɨɨ́, cʉg jé í cúgɛ́ mə́bii dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A mú zə kənd bwo kanda, nyə nə́: «Wúl kúkúm í á bə nə məshí; məshí mɔɔŋg mə́ á ka zə wééshʉli nyə zhwog məbii. ");
INSERT INTO mcp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A mú ka zə ŋgə jî lámʉ́d nə́: “Mə cugɛ́ nə kʉ́l mə́ é ŋkúnd mə́bii mâm yí. Mə é ka sá ntʉdɛl?” ");
INSERT INTO mcp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A mú cɨ nə́: “Mə zə́ sá ntʉ́ga: mə zə́ cɛ́ɛ́g ífwɔ̧ɔ̧́ byâm, mə lwɔ̧́ byɔɔŋg í búl bwaag yí, mə mú ŋkúnd *blé waamə́ nə məbii mâm cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mə músə cɨ nə lâm wâm nə́: Yé lâm, wo mú nə zhwog məbii mə́ ŋkúndú nə́ wo é dʉ balan nə mwo mimbû mimbû. Wogagʉ́ ja gaád, wo də́g wo ŋgul wo zhwiimbya.” ");
INSERT INTO mcp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Zɛmbî mú cɨ nə muud wɔɔŋgʉ̂ nə́: “Yé lad, ŋkí mə yîl wo cʉg gwô búlú gaád isâ wó mə́ shîn ŋkúnd ínɨ í bə ísâ í zə́?”» ");
INSERT INTO mcp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yésus mú cɨ nə́: «Muud mə́ dʉ ŋkúnd mə́bii shú nyə́mɛ́fwó, kú nə məbii mə jə́lá mísh mə́ Zɛmbî dɨ́ yɛ́, nda í dʉ bə nə nyə wə́ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yésus mú cɨ nə *ompwíín bɛ́ nə́: «Mə́ ka cɨ nə bɨ nə́, bɨ kú dʉ yágʉwo cʉg jɨ́n nə́ bɨ́ é də jɨ́. Bɨ kú yágʉwo mə́nyúúl mʉ́n nə́ bɨ́ é bwáád jɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cʉg í ntɔ̧ ídʉ̂w, nyúul ntɔ̧ míkáándə́? ");
INSERT INTO mcp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mpugá dʉ́g íŋkwɔlɔ́ŋkwɔ. Í ádɛ́ bɛ̧ mə́mpəg, kú mwáágʉlə mpúmə́, í cúgɛ́ nə ifwɔ̧ɔ̧́, kú nə owaag ɔ ídʉ̂w. Njɨ, Zɛmbî ŋgə wɨ́ɨ́l byo. Ŋkəmʉsa nə bɨ̂, bɨ bʉ́sə nə mfíí cɔ̧́ íŋkwɔlɔ́ŋkwɔ. ");
INSERT INTO mcp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Zə́ á na bɨ́dɨ́ jɨ́ nə ŋkul bə nə́, nəcé a ŋgə́lə yágʉ́wó, a kwádʉlə jwɔ̂w ŋgwúd nyə́dɨ́ cʉg dɨ́ yɛ́? ");
INSERT INTO mcp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ŋkí bɨ́ cugɛ́ nə ŋkul sá sʉ́sʉ́sá acíg-cíg, bɨ mə́ ka dʉ yágʉwo bíl nəcé jɨ́? ");
INSERT INTO mcp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Mpugá dʉ́g nda ófʉláwa bwə́ dʉ wɨ̂y nə́. Bwə́ ádɛ́ yɨ́ɨ́ŋga nə isɛ́y, kú tiŋ míkáándə́. Njɨ mə mpú jaaw bɨ́ nə́ cî Sə́lʉmun nyə á tɛɛm jág bul bə nə gúmə́, nyə a shígɛ́ bwɛlɛ bwáád nda ofʉláwa. ");
INSERT INTO mcp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ŋkə́mʉ́sá Zɛmbî mə fwó bwééd zhizhe sâ nda akánda jɨ́ nə́ bwə́ é wusə kuda dɨ́ mán yɛ́, ŋkəmʉsa nə bɨ̂; bɨ wə́ nyə é bul mpu bwééd wá. Yé búúd wâ tag búgə́ óga! ");
INSERT INTO mcp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Njɨ bɨ báá, kúgá dʉ sɔ̧́ sâ bɨ́ é də yí nə sâ bɨ́ é ŋgul yí; kúgá dʉ yágʉwo. ");
INSERT INTO mcp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ikûl ishús yâ shí mishwun wə́ í dʉ́ ŋgə wádʉga sɔ̧́ isâ ínɨ byɛ̂sh. Bɨ báá kúgá dʉ sɔ̧́ byo, nəcé Sɔ́ɔ́ŋgʉ́ wʉ́n mə mpú nə́ í jɨɨ bɨ́ isâ byɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yidagá dʉ tə̂l ísâ í dʉ́gyá nə́ Faan mə́ Zɛmbî yí shwóg, Zɛmbî ka dʉ kwádʉlə bɨ́ ísâ ínɨ. ");
INSERT INTO mcp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Yé sʉsɔ̧́ɔ̧́zʉ́ íncwəmbɛ, kúgá fúndə tɔɔ sâ nəcé Sɔ́ɔ́ŋgʉ́ wʉ́n nyə á gwág nywa nə́ a yə́ bɨ́ Faan dɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kushagá məbii mʉ́n bɨ kááwʉg mimbúmbúwá *mwaanɛ̂ wɔɔŋg. Kwəmʉsagá mimaŋga mí ábʉ́lɛ bwɛlɛ cɔ́ɔ́g myá, ŋkúndʉ́gá məkwɔ̧ɔ̧zʉ́ mə bá bə kú bɔ́ɔ́g má gwɔ̂w kʉ́l íjúwâl í cúgɛ́ nə ŋkul kumə, oshê kú nə́mə́ də yí. ");
INSERT INTO mcp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nəcé kʉ́l byɔɔg dʉ́n mbwúg yí, cínɔŋg wə́ lâm wʉ́n í é bə nə́mə́ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Yáásʉ́lə́gá wəáfigʉsa, bɨ́ ji ŋkasə̂. ");
INSERT INTO mcp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bə́gá nda buud bwə́ ŋgə́ bwánd mása wáŋ nə́ a ŋgə wú zaŋ bá dɨ́ wá. Bwə́ ŋgə́ bwánd nə́ ja nyə é wɔ́ɔ́s yí, á ká nə́mə́ kudə mbɛ̂, bwə́ ɔ́ juw. ");
INSERT INTO mcp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Məlwaá mə́ bá bə nə́, mása wáŋ ká wɔ́ɔ́s, a zə kwey bwo bwə́ njúl oŋkasə́ má, məlwaá mɔɔŋg má mə́ mə́ jəla. Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ja mása mə kwéy bwo ntɔ́ yí, nyə é yáásʉlə yé áfigʉsa a jilʉ́ bwo shí nə́ bwə́ də́g, nyɛ mú ka sɛ̂y nə bwo. ");
INSERT INTO mcp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ŋkí mása mə wɔ́ɔ́s tâm bulú ŋkí ŋgwúm kúwó ashúshwóógʉ́ dɨ́, a kwey mə́lwaá mə́ ŋgə́ bwánd ntɔ́, məlwaá mɔɔŋg mə́ mə́ jəla. ");
INSERT INTO mcp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mpugá nə́ amə́dɨ́ njɔ́w mbə̂m dʉ mpu wəla júwâl í é zə yí, a kú bɨ́d nə́ júwâl búgə́g nyə njɔ́w júwo ísâ. ");
INSERT INTO mcp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ntɔ́, bɨ mə́ jə́lá nə dʉ ji ŋkwəmʉsá, nəcé *Mwân mə Múúd mə bá zə wəla bɨ́ ábʉ́lɛ́ ŋgə tə́dʉga nə́ nyə é zə yí.» ");
INSERT INTO mcp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pyɛ̂r músə ka cɨ nə́: «Lə́sʉ́ wó ŋgə́ lás nɨ, ye í ŋgə dʉ́gya njɨ nə sə̂, ye í dʉ́gyá nə buud bɛ̂sh?» ");
INSERT INTO mcp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Cwámba mú bɛ̧sa nə́: «Dáyɛ́ kʉlág dʉ́sə́ abúgʉ́lág í njúl ŋkí kɛ̧̂ mása mə́ tə̂l nə́ í bə́g lúlúú á osɔ́ɔl ɔ mə́sáal í dʉ yə bwo idʉ̂w wəla i jə́la yí? ");
INSERT INTO mcp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sɔ́ɔl məsáal wɔɔŋg nywáá mə́ jəla nəcé mása nyə é zə kwey í ŋgə́ sá isɛ́y byé. ");
INSERT INTO mcp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, mása nyə é jil nyə nə́ a jwúg nə bíl ísâ í njɔ́w byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Njɨ ŋkí sɔ́ɔl məsáal mə́ yida nə́: “Cwámba waamə́ nyə álɛɛlɛɛ́ nyiŋgə”, a mú ka ji yídʉ́lə ósɔ́ɔl ɔ mə́sáal wâ budâ nə wa budûm, nə də́lə dəg, nə ŋgulʉ́lə nə́ ndɛɛ́ shwág ɨɨ, ");
INSERT INTO mcp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mása yé mə́ bá zə wɔ́ɔ́s nyə dúl jwɔ́wʉ́d məseegyâ, wəla á shígɛ́ ŋgə tə́dʉga yí. Mása nyə é yə nyə intʉ́gʉ́lí í ányinyaanə̂, a kənd nyə kʉ́l búúd ɔ́ məkə́ŋ bwə́ ŋgə́ bwəma nə ŋkʉ̂d yí. ");
INSERT INTO mcp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Lwaá dɨ́ nə́, í ŋgə́ mpu sá mása yé ŋgə́ jɨɨ yí njɨ í kú kwəmʉsa, í kú sâ nda mása mə jɨ́ nə́, lwaá dɔɔŋg í dʉ bwəma nə bígə́ áyíyáág. ");
INSERT INTO mcp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dɔɔŋg dɨ́ nə́, í kú mpu sâ mása ŋgə́ jɨɨ yí, í mú ŋgə sá isâ í jə́lá nə bígə́ yí nyə é bwəma nə bígə́ kú bul yáág. Muud yɛ̂sh bwə́ dʉ yə ísâ ŋkí bulya yɛ́, nyə nə́mə́ wə́ bwə́ dʉ gwáámb ŋkí bulya yɛ́. Nyɔɔŋg bwə́ dʉ yə isâ kú nə ŋkágʉ́lə́ yɛ́ nyə nə́mə́ wə́ bwə́ dʉ jî ŋkí bulya yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Mə á zə nə́ mə zə́ jida kuda shí gaád. Mə mú nə́mə́ ka jɨɨ nə́ kuda jɔɔŋg í jídʉg. ");
INSERT INTO mcp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mə́ jəlá nə duwan wúl nduwán, lâm í cúgɛ́ mə nə́ shɛɛ té nduwán wɔɔŋg í afwóyɛ́ bə yí. ");
INSERT INTO mcp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bɨ́ ŋgə tə́dʉga nə́ mə á zə sá nə́ buud bwə́ cʉ́gəg nə́ shɛɛ shí ga dɨ́? Mbɔ̂! Mə́ jaaw bɨ́ nə́ mə mə́ yidá zə nə mbɛ́ɛ́gí dɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nəcé í zə́ bá dʉ bə nə́ buud otɔ́ɔn bwə́ ŋgə́ cʉgə njɔ́w ŋgwúdʉ̂, bwə́ béégya; olɔ́ɔl lúmbʉli nə óbá, óbá lúmbʉli nə ólɔ́ɔl. ");
INSERT INTO mcp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mbɛ́ɛ́gí mə́ŋkɔɔmʉ́ í bá bə; sɔ́ɔ́ŋgʉ́ lúmbʉli nə mwân, mwân lúmbʉli nə sɔ́ɔ́ŋgʉ́; nyɔɔŋgʉ́ lúmbʉli nə sás dɛ́, sás lúmbʉli nə nyɔɔŋgʉ́ yé; mpɔ́ɔ́mbʉ́lú ámudâ lúmbʉli nə cɔ́ɔl, cɔ́ɔl lúmbʉli nə mpɔ́ɔ́mbʉ́lú ámudâ.» ");
INSERT INTO mcp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yésus nyə á cɨ nə́mə́ nə buud bwə́ á bə áncuncuma wá nə́: «Bɨ mə́ dʉ bə ja bɨ́ mə́ dʉ́g ŋkúdú í mə́ bád kɔ́ɔ́mb jwɔ̂w í dʉ jímə yí, ŋgaá bɨ́ cɨ nə́ mpú mə́ zə́ nywɔ̧̂; mpú nywɔ̧̂ nə́mə́? ");
INSERT INTO mcp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ja ŋkwɔ̧̂ mə dʉ́ kuŋg wúlə ŋgɛɛ *mə́kɔ́ɔ́l mə́ jwɔ̂w yí, ŋgaá bɨ mə́ dʉ cɨ nə́ yásə́ í é yáág, yásə́ yáág nə́mə́? ");
INSERT INTO mcp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bɨ bɨ́ nə məkə́ŋ. Bɨ mə́ dʉ mpu yag íyuug i shí nə ya gwɔ̂w; ká nəcé jɨ́ bɨ́ ampúyɛ́ yag sâ í ŋgə́ sɨ̂y mwɔ̂w mə́ga dɨ́ yí? ");
INSERT INTO mcp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Bɨmɛ́fwó bɨ́ cugɛ́ nə ŋkul mpu sámb nə́: “Tʉ́təlí wə́ ɛ́ga.” Nəcé jɨ? ");
INSERT INTO mcp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ŋkí wo mə́ byaagʉlə nə ŋgwɔ́l múúd nə́ ndɛɛ́ a ŋgə kə nə wo wə́ sémbye milə́sʉ́, sɔ̧́ɔ̧́g nə́ wo kwámbʉləgɨ̂ nə nyə zhɨ́ɨ́d. Nəcé nyə a bá kə nə wo wə́ sémbye milə́sʉ́ nə́ ndɛɛ́ sémbye milə́sʉ́ mú kənd wo wə́ fulísh, fulísh kə wá wo mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mə mpú jaaw wo nə́ wo cugɛ́ nə ŋkul wú mímbwug myɔɔŋgʉ́d wo kú fwo tɔ̧́ wôŋ jɔɔŋgʉ̂ kə wɔ́ɔ́s fáda á məshínéd.» ");
INSERT INTO mcp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bɔ́ɔ́l búúd bwə́ mú zə wɔ́ɔ́s ja jɔɔŋgʉ́d zə jaaw nyə sâ Pilât nyə a sá bɔ́ɔ́l búúd ɔ́ Galilê yí. Nə́ nyə a gwú bwo, a fʉla mə́cií máŋ nə məcií mə́ ílə́m í *mə́túnʉga byáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yésus mú bɛ̧sa nə bwo nə́: «Ye bɨ mə tə́dʉ́gá nə́ buud ɔ́ Galilê bɔɔŋg bwə́ á jɛ̧ɛ̧ ntɔ́ nəcé bwə́ bulʉ́lə bul sá *mísə́m ntɔ̧ bɔ́ɔ́lʉ́gá búúd ɔ́ Galilê bɛ̂sh ɨɨ́? ");
INSERT INTO mcp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mbɔ̂! Mə́ yida cɨ nə bɨ́ nə́ ŋkí bɨ mə bə́ kú cɛ́nd mítə́dʉ́gá, bɨ bɛ̂sh mə bá nə́mə́ jɛ̧ɛ̧́ mbií ŋgwúdʉ́ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ŋkí ntâg nə́ ye buud wûm nə mwɔɔmb cwámbə́ á Siloy í á káda í shîn gwú wá, bâŋ ɔ bwə́ á bul bə nə məbyaagʉlə ntɔ̧ bɔ́ɔ́l búúd ɔ́ Yurʉ́səlɛm bɛ̂sh? ");
INSERT INTO mcp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mbɔ̂! Mə́ yidá cɨ nə bɨ́ nə́ ŋkí bɨ mə bə́ kú cɛ́nd mítə́dʉ́gá, bɨ bɛ̂sh mə bá nə́mə́ jɛ̧ɛ̧́ mbií ŋgwúdʉ́ wɔɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A mú nə́mə́ kənd bwo kanda ga nə́: «Ŋgwɔ́l múúd nyə á bə nə *figyê tə́l nyə́dɨ́ fambə́ *vînyə. Nyə á ka kə sɔ̧́ mpumə́ lɨ́ɨ́ jɔɔŋgʉ́d a kú kwey. ");
INSERT INTO mcp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A mú cɨ nə muud nyə á dʉ baagʉlə nyə fambə́ yɛ́ nə́: wo mə́ dʉ́g ɨɨ́? Mimbû mílɔ́ɔl ɔ míga, mə ŋgə sɔ̧́ mpumə́ wa figyê ɛ́gaád mə kú kwey. Cígálʉ́g gwo. Í é ŋgə fánda laa shí na ntɔ́ ŋgwas nə́ jɨ́? ");
INSERT INTO mcp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mbaagʉlə fambə́ mú bɛ̧sa nə nyə nə́: “Mása, fwog ná kwo bɨ́d gwo mbû gaád. Mə e fáág na mə́koogʉ́ məkoogʉ́, mə shwu mə́ndəlú mə́ kund, ");
INSERT INTO mcp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ja jɔɔŋgʉ̂ wə́ í bá jee wúmə yí. Ŋkí í ka nə́mə́ bá nyiŋgə bə kú wúmə, wo ka bá cal.”» ");
INSERT INTO mcp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dúl jwɔ̂w lʉ́ Sábaad ɨɨ́, Yésus nyə á bə nyúl *mpáánzə́ minjɨ́ɨ́gʉ́lá dɨ́. Nyə á ŋgə yə buud minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋgwɔ́l múdá nyə á ka bə cínɔŋgʉ́ nə wúl shíshim í á sá nə́ a jámʉ́g mbʉ́mbɛɛlí té mímbû wûm nə mwɔɔmb, kú bwɛlɛ sʉ́g bə tʉ́təlî. ");
INSERT INTO mcp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ja Yésus nyə á dʉ́g mudá wɔɔŋg yí, nyə a jɔ̂w nyə cɨ nə nyə nə́: «Muda, wo mə́ wú mə́nyámá mə jám gwô dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A mú bəd nyə məbwə̂, mudá mú sʉ́g nə́mə́ cé nə cé, a mú yə Zɛmbî gúmə́. ");
INSERT INTO mcp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Njwû á mpáánzə́ minjɨ́ɨ́gʉ́lá mú gwág bɔ̂w nə́ Yésus mə́ jág sá nə lwagʉ́lə múúd jwɔ̂w lʉ́ sábaad. A mú lámʉsa nə buud nə́: «Mwɔ̂w búúd bʉ́sə́ nə ŋkul sɛ̂y má mə́sə mwɔ̂w mə́saman. Zəgá dʉ lwəgʉwa mwɔ̂w mɔɔŋgʉ́d; kú bə jwɔ̂w lʉ Sábaad.» ");
INSERT INTO mcp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Cwámba mú bɛ̧sa nə nyə nə́: «Bɨ bɨ́ buud ɔ mə́kə́ŋ. Ŋgaá bɨ mə́ dʉ bə jwɔ̂w lʉ́ Sábaad muud yɛ̂sh ciny ntɛny jé ŋkí kabʉlí jé kʉ́l í dʉ də yí kə nə gwo kə ŋgulal gwo məjúwó? ");
INSERT INTO mcp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ká, ŋkəmʉsa nə shilə bag ɔ *Abʉraham *Sátan nyə a mə́ wɔ́ɔlə té mímbû wûm nə mwɔɔmb ɛ́ga. Ye í shígɛ́ jəla nə́ nyɛ́ ŋkáda nyɔɔŋg í wíínzhʉg jwɔ̂w lʉ́ Sábaad?» ");
INSERT INTO mcp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ja Yésus nyə á cɨ ntɔ́ yí, buud bɛ̂sh bwə́ á dʉ lúmbʉli nə nyə wá bwə́ á bə nə shwôn nə́ ŋkwed. Bɔ́ɔ́lʉ́gá zhwog buud bɛ̂sh bwə́ á bə nə məshusʉg nə *isâ í mímbʉ́gú Yésus nyə á ŋgə sá yí. ");
INSERT INTO mcp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A mú ka cɨ nə́: «Faan mə́ Zɛmbî dʉ́sə nda jɨ́ e, mə kág ná yɨɨga dwo nə jɨ́? ");
INSERT INTO mcp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dʉ́sə nda búbumə́ *mutárʉd múúd mə ŋwá kə myɛɛg nyə́dɨ́ fambə́ yí. Ja í dʉ́ kɔ̧́ yí, í dʉ gwaa, bə fwámɛ́ lɨ́lɨ́ɨ́, inunú zə lwɔ̧́ maagɛ nyə́dɨ́ mílɔ́wʉd.» ");
INSERT INTO mcp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A mú nyiŋgə cɨ nə́: «Mə yɨ́ɨ́gag ná Faan mə́ Zɛmbî nə jɨ́? ");
INSERT INTO mcp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dʉ́sə nda fuú *ləvur. Ja múdá mə́ ŋwa wə, a fugə nə məmpɨɨ́ mə́ ŋgug bʉlɛ́d mə́lɔ́ɔl yí, í é sá nə ŋgug wɔɔŋg wɛ̂sh í búndɔwʉg.» ");
INSERT INTO mcp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yésus nyə á ka ŋgə lɨ́ɨ́na miŋgwə́la nə mə́nd a ŋgə́ yə buud minjɨ́ɨ́gʉ́lá, a ŋgə́ kə ŋgɛɛ́ Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ŋgwɔ́l múúd mú ka cɨ nə nyə nə́: «Cwámba, ye njɨ bʉ́baalɛ́ buud wə́ bwə́ bá *dʉ́g cʉg?» Cwámba mú cɨ nə́ ");
INSERT INTO mcp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Yáágʉ́gá nə́ bɨ nyííg mpumbɛ́ ámʉ́mánda dɨ̂. Nəcé mə́ jaaw bɨ́ nə́ zhwog buud bwə́ bá sɔ̧́ nə́ bwə́ nyííg, njɨ bwə́ ábʉ́lɛ nyíi. ");
INSERT INTO mcp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ja ámə́dɨ́ njɔ́w mə bá wɔɔl zə fad mbɛ̂ bɨ́ lʉ́g tɔ́ɔ́n yí, bɨ mə bá tɛ́ɛ́d kudə́lə mbɛ̂ bɨ ŋgə́ cɨ nə́: “Mása, juwʉ́g sə́ mbɛ̂”. A bá cɨ nə bɨ́ nə́: “Mə ampúyɛ́ bɨ́ dʉ́n shug.” ");
INSERT INTO mcp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bɨ mú bá cɨ nə nyə nə́: “Ŋgaá nə́ shé á dʉ də dʉ ŋgul kʉl ŋgwúd? Wo á dʉ nə́mə́ yə buud minjɨ́ɨ́gʉ́lá sə́dɨ́ íkʉ́lʉ́d.” ");
INSERT INTO mcp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nyɛ nə bɨ́ nə́: “Mə ŋgə cɨ nə bɨ́ fwámɛ́ cɨ nə́, mɛɛ mə ampúyɛ́ bɨ́ dʉ́n shug. Wúgá mə na, bɨ á ŋgə bɛ̧ məzhɨɨ́ mâ olɨ́lɨŋgɨ̂.”» ");
INSERT INTO mcp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Ja jɔɔŋgʉ̂, bɨ mə bá dʉ́g *Abʉraham nə *Izaag nə *Yákwab bə́nɔ̂ŋ *buud ɔ mícúndə́ bɛ̂sh bwə́ njúl Faan mə́ Zɛmbî dɨ̂, bɨ bâŋ bɨ njúl tɔ́ɔ́n. Bɨ mə bá ka bə cínɔŋgʉ́ njɨ bɨ́ ŋgə́ bwam nə məyə̂. ");
INSERT INTO mcp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Buud bwə́ bá zhu kɔ́ɔ́mb jwɔ̂w í dʉ cúwo yí, zhu kɔ́ɔ́mb í dʉ jímə yí, zhu *mə́ncwúm mə́ jwɔ̂w nə *mə́kɔ́ɔ́l mə́ jwɔ̂w, bwə́ zə ji shí zə də dína Faan mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ntɔ́, bɔ́ɔ́l ncúlyá buud bwə́ tə́l shwóg wá, bwə́ bá tɔ̂w mpʉ́sə, bɔɔŋg bwə́ tə́l mpʉ́sə wá, bwə́ bá tɔ̂w shwóg.» ");
INSERT INTO mcp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nə́mə́ wəla dɔɔŋgʉ́, bɔ́ɔ́lʉ́gá *Ofarizyɛ̂ŋ bwə́ mú shísh zə cɨ nə Yésus nə́: «Kyeyʉ́g, wúg wa nəcé Herod ŋgə cɛɛl gwú wo.» ");
INSERT INTO mcp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A mú cɨ nə bwo nə́: «Kəgá cɨ nə muud kwába wɔɔŋg nə́: “Dʉgɨ́ mə ŋgə yîl buud məjamb mə ŋgə́ lwag mimbə̂l múús nə mán. Mə bá casʉlə ísɛ́y byâm wâŋ mánʉ́d”. ");
INSERT INTO mcp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Njɨ í jɨɨ nə́ mə kə́g shwóg múús nə mán nə wâŋ mán. Nəcé í cúgɛ́ nə ŋkul bə nə́ *muud micúndə́ bwə́magí nə shwɨy kʉ̂l shúsʉ́d, njɨ Yurʉ́səlɛm.» ");
INSERT INTO mcp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Eéé Yurʉ́səlɛm ŋgə́ gwú buud ɔ mícúndə́ ɛ́ga! Eéé Yurʉ́səlɛm! Wo ŋgə sá nə́, buud Zɛmbî ŋgə ntɨ lwámád wódɨ́ wá, wo ŋgə gwú bwo nə məkwóógʉ́! A bweyʉ́lə mə́ á tɛ́ɛ́d nə́ mə́ sɛɛŋg bwân bwô nda ábiyá kúwó mə́ dʉ sɛɛŋg bwân bɛ́ mə́faafʉgə́ dɨ́ nə́! Njɨ, bɨ kú magʉlə ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ká, dʉgá njɔ́w wʉ́n í zə́ lʉ́g cwúdʉgʉ̂. Nəcé mə mpú jaaw bɨ́ nə́ tɛ́ɛ́d nə́mə́ kɨ́kɨdɨ́ga, bɨ ákwolɛ́ ná dʉ́g mə. Mə bá nyiŋgə nyîn njɨ ja bɨ́ mə́ bá shwas mə nə́: “Gúmə́ í bə́g nə nyɔɔŋg ŋgə́ zə jínə́ mə́ Cwámba dɨ́ yɛ́”.» ");
INSERT INTO mcp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Í á ka zə bə dúl jwɔ̂w lʉ́ Sábaad nə́, Yésus nyə á kə wúl lúlúú *Ofarizyɛ̂ŋ dɨ́ njɔ́w kə́lə də. Ja nyə á kə nɨ, Ofarizyɛ̂ŋ bwə́ á ŋgə fáf nyə. ");
INSERT INTO mcp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ka dʉ́g nə́, ŋgwɔ́l múúd nyə á bə a njúl Yésus dɨ́ shwóg, muud wɔɔŋgʉ̂ ŋgə́ bwas sə́g mə́júwó. ");
INSERT INTO mcp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yésus mú lás cɨ nə *Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ Ofarizyɛ̂ŋ nə́: «Ye məcɛ̧ɛ̧ míshé mə́ ŋgə magʉlə nə́ sə́ lwágʉg buud jwɔ̂w lʉ́ Sábaad, ye mə́ aŋgɛ̂ nə magʉlə ntɔ́?» ");
INSERT INTO mcp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bwə́ mú ji ókʉ́l-ókʉ̂l nda bɛ̧sa. Yésus mú ŋwa mbə̂l, lwag nyə nə́ ndɛɛ́ a mú bɨ́d nyə nə́ a kə́g. ");
INSERT INTO mcp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A mú cɨ nə Oŋkumɛ ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ Ofarizyɛ̂ŋ nə́: «Zə́ jɨ́ nə ŋkul bə na bɨ́dɨ́ nə́, mwân yé, ŋkí ntâg ntɛny jé í kud taamb dɨ́, a kú lɛɛl cáás kə yîl gwo nəcé í bə́lə jwɔ̂w lʉ́ Sábaad yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bwə́ mú bə kú nə ŋkul nə́ bwə́ bɛ̧sa nə nyə. ");
INSERT INTO mcp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yésus nyə a dʉ́g nə́ buud bwə́ á bə fééshá nə́ bwə́ zə́g də wá, bwə́ á ŋgə fɛ́ɛ́sh jílə njɨ íjiya i gúmə́d; a mú kənd bwo kaanə́ nə́: ");
INSERT INTO mcp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ja múúd mə jɔ́w wo zâŋ báád yí, kú kə ŋwa jiya gúmə́. Wo ampúyɛ́ ŋkí nyə́ ámə jɔ̂w nə́mə́ ŋgwɔ́l múúd mə jə́lá nə gúmə́ ntɔ̧ wo yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ja múúd wɔɔŋgʉ̂ nyə e wɔ́ɔ́s yí, bwə́ é cɨ nə wo nə́: “Yə́g nyə jiya”, í njúl nə́ bwə́ ámə jɔ̂w bɨ́ná bɛ̂sh. Wo é ka ŋgə kə nə shwôn kə ŋwa jiya wəámpyal-kogû. ");
INSERT INTO mcp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yidagʉ́ sá nə́, ja bwə́ jɔ́w wo yí, kaág ŋwa jiya wəámpyal-kogû shú nə́ ja múúd nyə́ ámə jɔ̂w wo yɛ́ mə́ wɔ́ɔ́s yí, a cɨ́g nə wo nə́: “Wɛy e, shíshíg zə ŋwa fwámɛ́ jiya”. Ja jɔɔŋgʉ̂, wo é bul ŋwa gúmə́ mísh mə́ búúd bɨ́nɔ́ŋ bɨ́ ámə bə fééshá wád. ");
INSERT INTO mcp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nəcé, muud mə bʉ̂n nyə́mɛ́fwó gwɔ́w yɛ́, bwə́ bá səl nyə shí; nyɔɔŋg mə sə́l nyə́mɛ́fwó shí yɛ́, bwə́ bá bʉ̂n nyə gwɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yésus mú nə́mə́ cɨ nə *Farizyɛ̂ŋ nyə a jɔ̂w nyə yɛ́ nə́: «Ja wó cɛ́ɛ́l yə búúd idʉ̂w ŋkí dína yí, kú ŋgə jɔ̂w oshwə́ bwô ŋkí omínyɔŋʉ̂ bwô nə mimbyɛ̂l myô. Nda ŋgə jɔ̂w buud ɔ kúm bɨ́nɔ́ŋ bʉ́sə́ mə́bwugʉ́lu wá. Nda ŋgə jɔ̂w mbií búúd wɔɔŋgʉ̂, nəcé bwə́ á bá nə́mə́ jɔ̂w wo jáŋ ja, í mú bə nə́ bwə́ mə́ nyiŋg wo sâ wó á sá bwo yí. ");
INSERT INTO mcp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Njɨ, ja wó sá dína yí, jɔ́wʉ́g mímbúmbúwá nə ɔ á ijâm, nə buud bwə́ dʉ nyɛ̂sh wá nə wəancím-ncîm. ");
INSERT INTO mcp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wó ká sá ntɔ́, wɛɛ mə́ jəla, nəcé bwə́ cúgɛ́ nə sâ bwə́ nyíŋg wo mənywa mwô nə ndɨ̂ yí. Zɛmbî nyə é bá nyiŋg wo mwo jwɔ̂w á bá gwûmʉshi ótʉ́təlí ɔ búúd yí.» ");
INSERT INTO mcp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ŋgwɔ́l múúd á buud bwə́ á ŋgə də wá, ja á mə́ gwág ntʉ́nɨ yí, a mú cɨ nə Yésus nə́: «Muud mə bá də idʉ̂w Faan mə́ Zɛmbî dɨ́ yɛ́ nywáá mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yésus mú cɨ nə nyə nə́: «Ŋgwɔ́l múúd nyə á kwəmʉsa nə́ a sá məma dína; a mú jɔ̂w búúd ŋkí bulya. ");
INSERT INTO mcp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nyə á ka kənd sɔ́ɔ́l məsáal yé ja wəla lʉ dína í á wɔ́ɔ́s yí, nə́ a kə́g cɨ nə buud nyə́ á jɔ̂w wá nə́: “Zəgá, isâ byɛ̂sh í mú mitéégyá”. ");
INSERT INTO mcp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Njɨ, bɛ̂sh bwə́ mú ŋgə yida lwágʉlə nə́ bwə́ cúgɛ́ nə fwála nə́ bwə́ kə́g dínad. Ashúshwóógʉ́ nə́: “Mə mə́ kúnɔw kusə fambə́, í jɨɨ nə́ mə kə́g dʉ́g gwo, mə́ jəgʉla nə wo, bɨ́dʉ́g nə́ mə bə́g kú zə.” ");
INSERT INTO mcp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ŋgwɔ́l nə́: “Mə mə́ kúnɔw kusə mímbáág mí íntɛny íbá íbá tâŋ mimbáág mitɔ́ɔn; mə kə́ sheé myo, mə́ jəgʉla nə wo, bɨ́dʉ́g nə́ mə bə́g kú zə.” ");
INSERT INTO mcp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ŋgwɔ́lʉ́gá nə́: “Mə mə́ kúnɔw bá múdá, gwə́ wə́ mə́ cúgɛ́ nə ŋkul zə nə ndɨ̂ yí.” ");
INSERT INTO mcp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Sɔ́ɔ́l məsáal mú nyiŋgə zə wə́ mása yé zə jaaw nyə nda búúd ɔ́nɨ bwə́ ámə ŋgə bɛ̧sa nə́. Mása mú gwág mpimbə. A mú cɨ nə sɔ́ɔ́l məsáal yé nə́: “Nə́ câ. Kaág wa ŋgwə́la íkʉ́l búúd bwə́ dʉ sɛɛŋgya yí, nə mínjwóŋ minjwóŋ kə ŋgə ŋwa mimbúmbúwá nə ɔ á ijâm, nə wəancím-ncîm nə bɔɔŋg bwə́ ŋgə́ nyɛ̂sh wá wo zə́g nə bwo wa.” ");
INSERT INTO mcp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nə́ ndɛɛ́ sɔ́ɔ́l məsáal mú zə jaaw nyə nə́: “Mása, í mə́ bə nda wó ámə jɨɨ nə́. Njɨ fwála dʉ́sə ná njɔ́w.” ");
INSERT INTO mcp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mása músə cɨ nə nyə nə́: “Kaág mə́zhɨɨ́ məzhɨɨ́ nə ífambə́ kə ŋgə yɨ́ɨ́mbʉli buud nə́ bwə́ zə́g nyíi, njɔ́w í lwándʉ́g mə. ");
INSERT INTO mcp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mə́ jaaw bɨ́ nə́ buud mə́ ámə jɔ̂w wá, ŋgwúd nə ŋgwúd nyə ákagɛɛ́ tɔɔ sâ mə́dɨ́ dínad.”» ");
INSERT INTO mcp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zhwog məŋkúmbə mə búúd mə́ á ŋgə kə sámbá nə Yésus. A mú yid cɨ nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ŋkí muud mə zə́ mə́dɨ́ a nda cɛɛl mə ntɔ̧ sɔ́ɔ́ŋgʉ́ bá nyɔɔŋgʉ́, ntɔ̧ múdá yé, ntɔ̧ bwân bɛ́, ntɔ̧ ómínyɔŋʉ̂ bɛ́ nə okɔ́ɔ́l bɛ́, a kú cɛɛl mə ntɔ̧ nə́mə́ cʉg jé gwə́mɛ́fwó, muud wɔɔŋgʉ̂ cugɛ́ nə ŋkul bə *mpwíín waamə̂. ");
INSERT INTO mcp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Muud mə bə́ kú ŋkɛ̂ny kwolós jé nyəmɛ́fwó ŋgə bɛ̧ mə yɛ́, a cugɛ́ nə ŋkul bə mpwíín waamə̂. ");
INSERT INTO mcp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Zə́ jɨ́ nə ŋkul sá na bɨ́dɨ́ nə́ ja á cɛ́ɛ́l lwɔ̧́ cwámbə́ yí, a tɛ́ɛ́d njɨ lwɔ̧́lə kú fwo ji shí fwo bála tâŋ á jə́lá nə kɛɛnzh yɛ́? A jəlá nə fwo bála, a dʉ́g ŋkí a jɨ nə bímbí lʉ mə́bii á jɨ́ nə ŋkul lwɔ̧́ njɔ́w nə ndɨ̂ shínal má. ");
INSERT INTO mcp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nəcé í á bá bə nə́ a shîn lîm njɔ́w nə́ ndɛɛ́ a kú nyiŋgə bə nə ŋkul mə shínál mə́lwɔ̧́ga. Buud bwə́ bá dʉ dʉ́g wá bwə́ ka bá dʉ cágʉlə, ");
INSERT INTO mcp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","dʉ cɨ nə́: “Muud ɛ́ga nyə a tɛ́ɛ́d nə́ a lwɔ̧́ njɔ́w a kú nə ŋkul mə shínál ísɛ́y.” ");
INSERT INTO mcp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Í kwo nə́mə́ bə nə́, wáyɛ́ njwú-buud wúsə́ nə ŋkul tɨ́ kə lúmbʉli dɔ́ɔ́mb nə wúl cî, a kú fwo ji shí faas yɛ́? Kí á jəlá nə fwo faas ŋkí nyə nə buud otɔ́ɔ́shin wûm a jɨ nə ŋkul lúmbʉli nə nyɔɔŋg zág dɔ́ɔ́mb dɨ́ nyə́dɨ́ nə buud otɔ́ɔ́shin məwûm mə́bá yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ŋkí a dʉ́g nə́ a cugɛ́ nə ŋkul lúmbʉli dɔ́ɔ́mb dɔɔŋgʉ́, nyə é bwey fwo kənd búúd, muud nyaand yé njúl ná shwóg-shwóg. Bwə́ kə jî nyə nə́ í jɨɨ nə́ bə́nɔ́ŋ bwə́ bə́g nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ntɔ́ jɨ nə́, muud yɛ̂sh jɨ́ na bɨ́dɨ́ nə́ nyə ayílɛ́ lâm mə́bii mɛ́d yɛ́, muud wɔɔŋgʉ̂ cugɛ́ nə ŋkul bə mpwíín waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ca dʉ́sə jɔ̧ sâ. Njɨ ŋkí ca í cwâl, jɨ́ bwə́ é nyiŋgə wá dwo məgwâm nə ndɨ̂ yí? ");
INSERT INTO mcp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kú nə sâ. Í mú bə kú nə mfíí tɔɔ shú mə́ndəlú, tɔɔ shú kund; bwə́ shwu dwo tɔ́ɔ́n. Muud jɨ́ nə məlwə̂ mə́ gwág yɛ́, a gwág.» ");
INSERT INTO mcp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zhwog zhwog oŋwɛnyɛ ɔ tóya nə bɔ́ɔ́l búúd ɔ *mísə́m bɛ̂sh bwə́ á ŋgə zə wə́ Yésus nə́ bwə́ zə́ gwágʉlə nyə. ");
INSERT INTO mcp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Ofarizyɛ̂ŋ bə́nɔ̂ŋ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú ŋgə nyímbʉla nə nyə ŋgə cɨ nə́: «Muud ɛ́ga ŋgə mpu lə́g buud ɔ mísə́m bə́nɔ́ŋ ŋgə də kʉl ŋgwúdʉ́!» ");
INSERT INTO mcp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yésus mú ka zə ŋwa bwo mpwokwoond nə́: ");
INSERT INTO mcp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Nyáyɛ́ múúd na bɨ́dɨ́ jɨ́ nə ŋkul sá nə́, nyə nə íncwəmbɛ təd, ŋgwûd á cínɔŋg jímb, a kú sɔ̧́ gwo yɛ́? Ŋgaá nə́ nyə e lʉ́gə byɔɔŋg yâ məwûm ibuú nə ibuu bugád, a fwo kə sɔ̧́ jɔɔŋg í ámə jímb yí nə́ ndɛɛ́ kə wɔ́ɔ́s ja nyə́ é kwey gwo yí? ");
INSERT INTO mcp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A ká kwey gwo, ŋgaá nə́ nyə é bə nə məshusʉg, a bəd gwo záməbag ");
INSERT INTO mcp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a mú nyiŋgə kə njɔ́w, kə sɛɛŋg óshwə́ bɛ́ nə buud bə́nɔ́ŋ bʉ́sə́ mə́bwugʉ́lu wá, nyə nə bwo nə́: “Shé sáágá məshusʉg nəcé mə mə́ kwey ncwəmbɛ jâm í ámə jímb yí?” ");
INSERT INTO mcp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mə́ jaaw bɨ́ nə́ məshusʉg mə́ bá nə́mə́ bə ntɔ́ joŋ dɨ́ nə muud *misə́m ŋgwúd mə cɛ́nd tə́dʉ́gá yɛ́, ntɔ̧ mbií mə́sə́ nə ŋkul bə nə otʉ́təlí ɔ búúd məwûm ibuú nə ibuu bwə́ aŋgɛ̂ nə jɨɨ cɛ́ndʉ́lə tə́dʉ́gá wá. ");
INSERT INTO mcp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Shé fwógá ná nyiŋgə cɨ nə́ ŋgwɔ́l múdá ŋgə bə nə misaŋ mí *mwaanɛ̂ wûm, ŋgwúd mú jímb. Ŋgaá nə́ nyə é jida lámba, a wáámbʉlə njɔ́w ŋgə mpu sɔ̧́ saŋ nə́ ndɛɛ́ kə wɔ́ɔ́s ja nyə́ é kwey wə yí? ");
INSERT INTO mcp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja á kwéy yí, ŋgaá nə́ nyə é sɛɛŋg bɛ́ óshwə́ nə budá bə́nɔ́ŋ bʉ́sə́ mə́bwugʉ́lu wá, nyə nə bwo nə́: “Shé sáágá məshusʉg nəcé mə mə́ kwey saŋ mwaanɛ̂ wâm í ámə jímb yí?” ");
INSERT INTO mcp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gwə́ wə́ mə́ jááw bɨ́ nə́ məshusʉg mə́ dʉ bə *wəéŋgəles ɔ́ Zɛmbî dɨ́ ja múúd *misə́m ŋgwúd mə cɛ́nd mítə́dʉ́gá yí.» ");
INSERT INTO mcp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yésus mú nyiŋgə cɨ nə́: «Ŋgwɔ́l múúd nyə á bə nə bwán óbá budûm nə budûm. ");
INSERT INTO mcp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Á ntombú mú cɨ nə sɔ́ɔ́ŋgʉ́ nə́: “Pʉpa, yə́g mə nyâm ŋkɔw lʉ́ mə́bii mə́ jə́lá nə bə nə ndɨ́ yí”. Sɔ́ɔ́ŋgʉ́ wáŋ mú kaaw bwo məbii mɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Baalɛ́ mwɔ̂w mə́ mú cɔ̧́, mwân á ntombú mú kusha nyɛ́ ŋkɔw lʉ́ mə́bii nə́ ndɛɛ́ a mú kyey kə wúl lɔɔm á shwóg-shwógʉ́d. A mú kə gwiímb cʉg nûŋ nə́ ndɛɛ́ shîn caam byɔɔg dɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ja nyə á shîn kɛɛnzh kúm dɛ́ yí, məma zha mú zə wɔ́ɔ́s lɔɔm wɔɔŋgʉ́d. Mwân ɛ́nɛ mú zə bə mə́fúfəd. ");
INSERT INTO mcp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A mú zə kə nyíi ísɛ́yʉ́d wə́ wúl mbyágá á shí nyɔɔŋg. Muud wɔɔŋgʉ̂ mú kənd nyə nyə́dɨ́ mə́shíd kə dʉ wɨ́ɨ́l nyə oŋkuú. ");
INSERT INTO mcp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ja nyə á ŋgə wɨ́ɨl oŋkuú bɔɔŋg yí, nyə á dʉ bə nə yéésh nə́ a də́ mímwag mi mpúmə́ óŋkuú bɔɔŋg bwə́ á dʉ də myá, njɨ kú nə muud mə yə́ nyə. ");
INSERT INTO mcp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«A mú zə nyiŋg lâm, zə tə́dʉga nə́: “A zhwog idʉ̂w ósɔ́ɔl ɔ mə́sáal ɔ sɔ́ɔ́ŋgʉ́ waam bɛ̂sh bʉ́sə́ nə ndɨ̂ yí e! Mɛɛ mə ŋgə́ fudə nə zha wa? ");
INSERT INTO mcp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mə zə́ nyiŋgə kə wə́ sɔ́ɔ́ŋgʉ́ waamə̂. Mə é kə cɨ nə nyə nə́: Pʉpa, mə á mə́ sə̂m nə Zɛmbî, mə sə̂m nə wo. ");
INSERT INTO mcp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mə ampíyáyɛ́ ná nə́ wo ŋwág mə nə́ mwân woó. Ŋwag mə nda ŋgwɔ́l sɔ́ɔl məsáal woó.” ");
INSERT INTO mcp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mwân ɛ́nɛ mú zə tɨ́ kə wə́ sɔ́ɔ́ŋgʉ́. «A mú ŋgə kə nə́ ndɛɛ́ sɔ́ɔ́ŋgʉ́ mú dʉ́g nyə a ŋgə́ ná gwaa zə. A mú bul gwág nyə cɛy lámʉ́d. A mú kə nə kʉ́lə́ kə shwɨy nyə nyúúlʉ́d kúlal nyə. ");
INSERT INTO mcp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwân mú cɨ nə sɔ́ɔ́ŋgʉ́ nə́: “Pʉpa, mə á mə́ sə̂m nə Zɛmbî, mə sə̂m nə wo. Mə ampíyáyɛ́ ná nə́ wo ŋwág mə nə́ mwân woó”. ");
INSERT INTO mcp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sɔ́ɔ́ŋgʉ́ mú cɨ nə osɔ́ɔl ɔ mə́sáal bɛ́ nə́: “Nə́ câ! Zəgá nə káándə́ í búl bə káándə́ gúmə́ yí, zə bwééd nyə. Wágá nyə lwondó mbwə́d, bɨ́ wá nyə osílʉ́faas məkuúd. ");
INSERT INTO mcp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bɨ́ ka nə́mə́ zə nə mwâ ntɛny a wóŋʉ̂ zə cígə tâŋ lʉ́m, sə́ də́g, sə́ zhwiimbya. ");
INSERT INTO mcp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nəcé mwân waam ɛ́ga nyə á yə, a mə́ gwûm; nyə á jímb, a mə́ nyîn.” Bwə́ mú tɛ́ɛ́d zâŋ. ");
INSERT INTO mcp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Í á bə na mwân a cúmbá njúl ífambə́. Ja nyə á ka ŋgə nyiŋgə yí, a mú ŋgə zə, zə wɔ́ɔ́s kúnə́-kúnə nə njɔ́w, a mú gwág íbwamʉgə́-bwámʉg nə isʉsa. ");
INSERT INTO mcp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A mú jɔ̂w ŋgwɔ́l mwâ mpáánzə́ zə jî nyə sâ í ŋgə́ cɔ̧́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mwâ mpáánzə́ mú jaaw nyə nə́: “Mínyɔŋʉ̂ woó mə́ wɔ́ɔ́s. Shwóóŋgʉ̂ nyə ámə cígə mwâ ntɛny á wóŋʉ̂ nəcé mínyɔŋʉ̂ woó mə́ nyiŋgə zə mpwogɛ́.” ");
INSERT INTO mcp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwân a cúmbá mú gwág bɔ̂w, a ban nə́ nyə anyííyɛ́ njɔ́w. Sɔ́ɔ́ŋgʉ́ mú cúwo tɔ́ɔ́n kə tɛ́ɛ́g nyə məbwə̂. ");
INSERT INTO mcp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A mú cɨ nə sɔ́ɔ́ŋgʉ́ nə́: “Mə mə́ sɛ̂y nə wo mimbû mimbû kú bwɛlɛ mpyêny ciyá gwô tɔɔ ŋgwúd. Njɨ, wo abwɛ́lɛ́ yə mə tɔɔ njɨ mwâ tɔw nə́ sə́nɔ́ŋ oshwə́ bâm sə́ zhwíímbyag. ");
INSERT INTO mcp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Njɨ, mwân woó nyə á shîn kə kɛɛnzh wo byɔɔg dwô kə́lə ŋgə cʉgə nə budá ɔ́ jaŋga ɛ́ga, ja á mə́ wɔ́ɔ́s yí, wo mə́ cígə nyə mwâ ntɛny a wóŋʉ̂.” ");
INSERT INTO mcp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sɔ́ɔ́ŋgʉ́ mú cɨ nə nyə nə́: “Mwân waam wo njul nə mə wa mwɔ̂w mɛ̂sh isâ byâm bísə isâ byô. ");
INSERT INTO mcp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Njɨ í ámə jɨɨ nə́ sə́ zhwíímbyag nəcé mínyɔŋʉ̂ woó ɛ́nɛ, mə ŋgə dʉ́g nyə na nda nyə á yə nə́ ndɛɛ́ a mə́ gwûm; nyə a jímb, a mə́ nyîn.”» ");
INSERT INTO mcp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yésus nyə á nyiŋgə cɨ nə *ompwíín bɛ́ nə́: «Ŋgwɔ́l múúd byɔɔg nyə á bə nə kʉlág. Í mú zə bʉ́gʉli wə́ muud ɛ́nɛ nə́ kʉlág dɔɔŋgʉ́ í ŋgə caam nyə məbii. ");
INSERT INTO mcp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Muud byɔɔg mú jɔ̂w kʉlág zə cɨ nə nyə nə́: “Wɔɔŋg lâŋ mə́ ŋgə́ gwág ga wɨ́ nə́ jɨ? Zaá shitɔ́gʉd, mə wámbʉ́lə́g nda wó ŋgə́ kyey nə isɛ́y byô nə́.” ");
INSERT INTO mcp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kʉlág mú zə lás lámʉ́d nə́: “Ja Mása mə zə́ yîl mə íkʉlág dɨ́ ga, mə e sá ntʉdɛl? Mə cugɛ́ nə ŋkul nə́ mə kə́g fʉlə mə́ndəlú, bɛ̧ mə́mpəg. Sálə nə́mə́ shwôn nə́ mə bə́g muud miŋgwóómbʉ́lú. ");
INSERT INTO mcp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mə mə́ mpu sâ mə́ zə́ sá yí. Í jɨɨ nə́ ja bwə́ é yîl mə íkʉlág dɨ́ yí, mə bə́g nə buud bwə́ é dʉ ŋwa mə bwə́dɨ́ wá.” ");
INSERT INTO mcp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Buud bwə́ á ŋgə bə nə Mása yé məmpwə́lá wá, a mú ŋgə jɔ̂w bwo ŋgwúd ŋgwúd. Nyə nə ashúshwóógʉ́ nə́: “Wo mbid Mása waamə́ mpwə́lá taŋ nɛ?” ");
INSERT INTO mcp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Muud mpwə́lá nə́: “Mə mbid nyə məwúdə məfwánda wûm.” Kʉlág mú cɨ nə nyə nə́: “Lə́gʉ́g, fə́b lʉ́ mpwə́lá dwó wə́ ga; jigʉ́ shí wo lɛ́ɛ́lʉg cilə nə́ məfwánda məwûm mə́tɔ́ɔn.” ");
INSERT INTO mcp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nyɛ nə ŋgwɔ́l nə́: “Wɛɛ jɨ nə mpwə́lá taŋ nɛ?” Nyɨ́nɨ nə́: “Iyuug í *blé təd.” Nyə nə nɛ́ nə́: “Lə́gʉ́g, fə́b lʉ́ mpwə́lá dwó wə́ ga. Ciləg nə́ məwûm mwɔɔmb.” ");
INSERT INTO mcp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mása músə yə kʉlág á iŋkwííl nə məshwúmb nəcé a sálə sɔ́ɔ́lʉ́gʉ́ mə́kyɛ̧̂. Nəcé í ŋgə nyîn nə́ buud bwə́ ŋgə́ bɛ̧ cʉg á shí ga wá bwə́ ŋgə bul kyɛ̧́ mpə́dʉ́gá nyáŋ ntɔ̧ bɔɔŋg bʉ́sə́ búúd ɔ mə́ŋkɛnya wá.» ");
INSERT INTO mcp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yésus mú nyiŋgə cɨ nə́: «Mɛɛ mə́ cɨ nə bɨ́ nə́, balanʉgá nə *mwaanɛ̂ iŋkwííl ŋgə cɛ̧ɛ̧ məshwə́ nə ndɨ̂: ja bɨ́ mə́ bá bə mə́fúfə dɨ́ yí, oshwə́ bʉ́n bɔɔŋg bwə́ bâg ŋwa bɨ́ mə́banda mâ kandʉgə kandʉgə dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muud mə báágʉ́lə́ ísʉ́sʉ́sá í acíg-cíg kú teeg búúd məbwóŋ yɛ́, nyə é baagʉlə nə́mə́ ísâ í anʉ́nɨ̂ kú teeg búúd məbwóŋ. Muud mə tə́g búúd məbwóŋ ísʉ́sʉ́sá í acíg-cíg dɨ́ yɛ́, nyə é teeg nə́mə́ búúd məbwóŋ ísâ í anʉ́nɨ̂ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ŋkí bɨ mə tɛ́ɛ́d teeg búúd məbwóŋ ja bɨ́ mə́ bálán nə mwaanɛ̂ iŋkwííl yí, zə́ nyə é yə bɨ́ mwaanɛ̂ á fwámɛ́ a kú bə nə məsʉs lámʉ́d yɛ́? ");
INSERT INTO mcp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bɨ́ mə́ ká tɛ́ɛ́d teeg búúd məbwóŋ nə sá ŋkán, zə́ nyə é yə bɨ́ jɔɔŋg í jə́lá nə bə sâ jɨ́n yɛ́? ");
INSERT INTO mcp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Lwaábʉlə cúgɛ́ nə ŋkul sɛ̂y nə omása obá ja ŋgwúd, nəcé nyə é mpii ŋgwɔ́l, a cɛɛl ŋgwɔ́l; gúl ja nyə e gwág nə ŋgwɔ́l, a mpyêny ŋgwɔ́l. Bɨ́ cúgɛ́ nə ŋkul sɛ̂y nə Zɛmbî bɨ ŋgə́ sɛ̂y nə mwaanɛ̂ ja ŋgwúd» ");
INSERT INTO mcp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Ofarizyɛ̂ŋ, nda bwə́ á dʉ bul cɛɛl mwaanɛ̂ nə́, bwə́ á ŋgə gwágʉlə lə́sʉ́ nɨ wɛ̂sh bwə́ ŋgə́ cágʉlə Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A mú cɨ nə bwo nə́: «Bɨ́ ŋgə cɛɛl lwóya mísh mə́ búúd dɨ́ nə́ bɨ bʉ́sə otʉ́təlí ɔ búúd, njɨ Zɛmbî mə mpú mílâm mín; nəcé sâ búúd bwə́ dʉ́g nə́ fwámɛ́ sâ yí, Zɛmbî nyɛ mə dʉ́g gwo sâ nyɛɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","*Mbwoomb mə́cɛ̧ɛ̧ nə micilyá mí *búúd ɔ mícúndə́ mí á ŋgə cwîny buud zə shúg wəla mə Yuánɛs. Kǎlə wú fwála mə́ Yuánɛs ɨɨ́, Jɔ̧jɔ̧ Kɛ́ɛl á Faan mə́ Zɛmbî wə́ í ŋgə́ bwiiŋgya, muud yɛ̂sh ka ŋgə nádʉwo nə ŋkul nyɛ́ nyɛ̂sh nə́ á ŋwa kɔw cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jisə ŋkí fwanʉwo nə́ gwɔ̂w nə shí í cɔ̧́g, ntɔ̧ nə́ gúl lʉ́lándə́ kaŋgá á mbwoomb mə́cɛ̧ɛ̧ í jímbʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Muud yɛ̂sh mə yíl múdá yé bá a nyiŋgə bâ múdá shús yɛ́, mə́ sá mínɔɔmb. Muud mə bâ múdá bwə́ ámə yîl bá yɛ́, mə́ sá mínɔɔmb.» ");
INSERT INTO mcp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Ŋgwɔ́l múúd nyə bə nə byɔɔg, a dʉ́gə́ bwáád míkáándə́ mí álal-kus ófwó búúd bwə́ dʉ bwáád myá. Nyə á dʉ cʉgə cʉg áyíyáág, dʉ sá ídína jwɔ̂w dɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gúl ntágʉ́lá-ntágʉla múúd nə́ Lazâr, nə nyúúl məfə́ŋ məfə́ŋ, í á dʉ já múúd byɔɔg wɔɔŋg dɨ́ mpumbɛ́d. ");
INSERT INTO mcp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazâr nyə á dʉ bə nə yéésh nə́ a də́ məmpulú mə́ á dʉ kud wú múúd byɔɔg dɨ́ tʉ́wʉli dɨ́ yí. Njɨ, ompyə̂ bwə́ á dʉ zə jáal nyə məfə́ŋ. ");
INSERT INTO mcp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ntágʉ́lá-ntágʉla í á ka yə; *wəéŋgəles bwə́ mú kə nə nyə kə jɛ́ɛ́g *Abʉraham dɨ́ bʉdʉd. Muud byɔɔg mú nə́mə́ yə, a mú dɔw. ");
INSERT INTO mcp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kə wɔ́ɔ́s nûŋ baŋ mínjîm, muud byɔɔg mú kə bwəma nə cwúnd. A njúl ŋkááŋgɛ́ dɨ́ ntʉ́nɨ, a mú bʉ̂n mísh, a mú dʉ́g Lazâr njóóg Abʉraham bʉdʉd. ");
INSERT INTO mcp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A mú kámb Abʉraham, nyə nə́: “Eéé Pʉpá Abʉraham, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́. Kəndʉ́g Lazâr kə́g juwo nyinə́ mbwə̂ mə́júwód zə cweel mə jûm; miŋgwiilɛ míga mí ŋgə sá mə ŋkááŋgɛ́ mbíya.” ");
INSERT INTO mcp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abʉraham mú cɨ nə nyə nə́: “Mwân waam, wo á shí bə nə tɔɔm ja wó á ŋgə cʉgə yí, Lazâr nyɛ ŋgə́ bwəma nə micúŋ. Ja ga dɨ, Lazâr micúŋ myɛ́ mí mə́ cwaalʉwo, wɛɛ mú cwa bwəma nə ŋkááŋgɛ̂. ");
INSERT INTO mcp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sá í búl bə yí jɨ́ ntâg nə́ məma bɨ́ ncímə jísə shé wa tʉ́tám nə́ buud bwə́ cɛ́ɛ́l wú wa zə nûŋ wá bwə́ cúgɛ́ nə ŋkul lɨ́ɨ́na; bɔɔŋg bwə́ cɛ́ɛ́l wú nûŋ zə kə́ga wá bwə́ kú lɨ́ɨ́na.” ");
INSERT INTO mcp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Muud byɔɔg mú cɨ nə́: “Pʉpa, nda jɨ́ ntɔ́ nə́, mə́ jəgʉla nə wo: kəndʉ́g Lazâr njɔ́w mə́ sɔ́ɔ́ŋgʉ́ waamə̂. ");
INSERT INTO mcp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Omínyɔŋʉ̂ bâm bʉ́sə nûŋ ótɔ́ɔn. A kə́g lás nə bwo nə́ bwə́ ɔ́ bɛy, bwə́ kú bá zə wa kʉ́l mə́ jɨ́ cwúnd dɨ́ ga.” ");
INSERT INTO mcp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abʉraham mú cɨ nə nyə nə́: “Omínyɔŋʉ̂ bwô bʉ́sə nə Məcɛ̧ɛ̧ mə́ Moyîz nə micilyá mí *búúd ɔ mícúndə́, bwə́ bɛ̧́g myo.” ");
INSERT INTO mcp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Muud byɔɔg nə́: “Nda bə ntɔ́, Pʉpá Abʉraham. Njɨ, ŋkí muud mə wú mínjîm kə lésha nə bwo, bwə́ é cɛ́nd mítə́dʉ́gá.” ");
INSERT INTO mcp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abʉraham mú cɨ nə nyə nə́: “Ŋkí bwə́ bə́ kú bɛ̧ mícilyá mí Moyîz bə́nɔ̂ŋ buud ɔ mícúndə́, mpug nə́ muud tɛɛm gwûm mínjîm kə lésha nə bwo, bwə́ ábʉ́lɛ́ magʉlə lâŋ yé.”» ");
INSERT INTO mcp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yésus mú kwo cɨ nə *ompwíín bɛ́ nə́: «Cʉg í cúgɛ́ nə ŋkul bə kú nə kwal-bɔɔgʉ́. Njɨ, ŋkwɛ́ɛ muud mə bə́ bɔ́ɔ́l kwal-bɔɔgʉ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Í yidá nywa nyə nə́ bwə́ kə́lʉg nyə məma kwóógʉ́ cʉ́ŋʉ́d kʉl nyə nə dwo mâŋ, ntɔ̧ nə́ a kwálʉg ŋgwúd á ikʉ́kágə́ íga bɔɔgʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bɨ ɔ́ bɛy. Ŋkí mínyɔŋʉ̂ woó mə́ sə̂m nə wo, jumʉ́g nyə. A ká cɛ́nd mítə́dʉ́gá, wo juu nyə. ");
INSERT INTO mcp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ŋkí ŋkúmba jwɔ̂w a sə̂m nə wo ija zaŋgbá, a dʉ nə́mə́ zə wódɨ́ ija zaŋgbá zə dʉ cɨ nə́: “Mə mə́ cɛ́nd tə́dʉga,” juugʉ́ nyə.» ");
INSERT INTO mcp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","*Buud ɔ lwámá bwə́ mú cɨ nə Cwámba nə́: «Kwádʉ́lə́g sə́ búgə́.» ");
INSERT INTO mcp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Cwámba mú cɨ nə́: «Bɨ mbə̂m bə nə búgə́ tɔɔ njɨ cíg-cîg bímbí búbumə́ *mutárʉd, bɨ́ je cɨ nə lɨ́ɨ́ sikomɔ̂r ga nə́: “Munʉ́g kə tɔ̂w mâŋ”, lɨ́ɨ́ sá bɨ́ məgwág. ");
INSERT INTO mcp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zə́ á na bɨ́dɨ́ jɨ́ nə ŋkul sá nə́ ŋkí a mbid lwaá dɛ́ í dʉ waad nyə ifambə́ ŋkí ntâg nə́ í dʉ wɨ́ɨl nyə iwoó, lwaá dɔɔŋg ŋgə́ wɔ́ɔ́s wúlə ísɛ́yʉ́d, nyə nə lwaá nə́: “Lɛɛlʉgʉ́ zə ji shí zə də”? ");
INSERT INTO mcp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ye nyə áyidayɛ́ cɨ nə nyə nə́: “Kwəmʉsag mə idʉ̂w, wo yáásʉlə áfigʉsa zə sɛ̂y nə mə. Mə́ ká shîn də mə ŋgul, wo ka tɛɛm də nə ŋgul gwô ja?” ");
INSERT INTO mcp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ye nyə e lɔ̧́ lwaá dɛ́ nə nyə nə sá ísâ byɛ̂sh nyə ámə lwám nyə nə́ a sáág yí? ");
INSERT INTO mcp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ntɔ́ nə́mə́ wə́ jísə́ shú dʉ́nʉ́d yɛ́. Ja bɨ́ mə́ shîn sá sâ jɛ̂sh bwə́ ámə lwám bɨ́ nə́ bɨ sáág yí, ŋwagá bɨmɛ́fwó nə́: “Sə́ bʉ́sə ozhizhe osɔ́ɔl ɔ mə́sáal wâ kú nə mfíí, sə́ mə́ sá njɨ sâ í ámə bə nə́ sə́ sáág yí.”» ");
INSERT INTO mcp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yésus nyə á ŋgə kyey Samaríya nə Galilê, ŋgə kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ja nyə á ŋgə nyíi dúl də́nd dɨ́ yí, mizʉ́zaamə́ wûm mí á zə nə́ mí zə́ bwəma nə nyə, njɨ mí mú tɔ̂w shwóg-shwóg kú fwo kumə nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mí mú bʉ̂n mə́kə́l gwɔ̂w cɨ nə nyə nə́: «Yé Yésus, éé yé mása, bwɨ́ɨ́gʉ́g sə́ nə́ ŋkwoŋʉ́.» ");
INSERT INTO mcp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yésus mú dʉ́g bwo, a mú cɨ nə́: «Kəgá lwóya mə́nyúúl ófada dɨ́.» Bwə́ mə́ ka nə́mə́ ŋgə kə nə́ bwə́ kə́ ófada dɨ́, bwə́ mú yâl zhɨ́ɨ́d, mənyúúl bə bwo nə́ səndôŋ. ");
INSERT INTO mcp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ŋgwɔ́lʉ́gá nywáá, ja á mə́ dʉ́g nə́ a mə́ yâl yí, a mú cuwʉli nyiŋgə, a mú ŋgə zə a ŋgə́ lás gwɔ́w-gwɔ̂w ŋgə yə Zɛmbî gúmə́. ");
INSERT INTO mcp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A mú zə kʉl nyúúl Yésus dɨ́ shí məkuú, kúd mpwoombʉ́ shí yə Yésus akíba. Nyâŋ nyə á bə muud á Samaríya. ");
INSERT INTO mcp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yésus mú cɨ nə́: «Ŋgaá nə́ bɛ̂sh wûm bwə́ ámə yâl? Ká bɔ́ɔ́l ibuu bʉ́sə ŋgow? ");
INSERT INTO mcp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ntɔ́ nə́ bwə́ bɛ̂sh dɨ́, kú nə muud mə zə́ yə Zɛmbî gúmə́ njɨ njôŋ muud ɛ́ga á?» ");
INSERT INTO mcp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A mú cɨ nə nyə nə́: «Tɔ́wʉ́g wo kyéyʉg wo mə́ *dʉ́g cʉg nəcé búgə́ gwô.» ");
INSERT INTO mcp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","*Ofarizyɛ̂ŋ bwə́ á jî Yésus nə́: «Faan mə́ Zɛmbî í bá ka zə jáyɛ́ ja?» A mú bɛ̧sa nə bwo nə́: «Faan mə́ Zɛmbî í abʉ́lɛ́ zə nda gúl yaŋgá-yáŋga sâ búúd bwə́ bá beny yí. ");
INSERT INTO mcp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Í abʉ́lɛ́ bə sâ nə́ bwə́ cɨ nə́: “Gwə́ wə́ jɨ́ wa ga”, ŋkí nə́: “Gwə́ wə́ jɨ́ wáádə́ mí!” Nəcé Faan mə́ Zɛmbî dʉ́sə na bɨ́dɨ́.» ");
INSERT INTO mcp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A mú cɨ nə *ompwíín nə́: «Mɔ́ɔ́l mwɔ̂w mə́ bá bə, bɨ mə bá gwág yéésh nə́ bɨ mə dʉ́g *Mwân mə Múúd nə ijwûga byé tɔɔ njɨ jwɔ̂w ŋgwúd, njɨ bɨ kú dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bwə́ bá dʉ cɨ nə bɨ́ nə́: “Dʉgá nyə wáádə́,” gúl ja nə́: “Dʉgá nyə wa.” Bɨ́ kú bá dʉ kə, bɨ kú bɛ̧, ");
INSERT INTO mcp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","nəcé, jwɔ́w Mwân mə Múúd mə bá zə yí, a bá zə nə́mə́ nda njəs í dʉ yas wú bíga íjumə kə wɔ́ɔ́s bíga dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Njɨ í bá fwo jɨ nə́ a bâg bul jug, kala búúd ga í ban nyə. ");
INSERT INTO mcp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Mwɔ̂w Mwân mə Múúd mə bá zə má, isâ í bá sɨ̂y nə́mə́ nda í á sɨ̂y ja mə *Nówe dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Buud bwə́ á dʉ də, dʉ ŋgul, bwə́ béya, bɛ́lʉshi nə́mə́ bwân báŋ nə́ ndɛɛ́ kə wɔ́ɔ́s jwɔ̂w Nówe nyə a nyíi məma byɔ́ɔ́l dɨ́ yí. Mpʉŋ í mú zə byalʉga nə buud nə́ ndɛɛ́ jaŋgʉlə ísâ byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ntɔ́ nə́mə́ wə́ í á bə mwɔ̂w mə́ Lót dɨ́ yɛ́. Buud bwə́ á dʉ də, dʉ ŋgul, bwə́ dʉ sá míkus, dʉ bɛ̧ mə́mpəg, shumə mínjɔ́w. ");
INSERT INTO mcp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Njɨ jwɔ̂w Lót nyə a wú Sódom yí, Zɛmbî nyə a sá nə́ kuda nə fumbyá ágúgwɔ̧̂ í nywɔ̧́g nda mpú, zə jaŋgʉlə búúd bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mbií ŋgwúd wɔɔŋg nə́mə́ wə́ í bá bə ja Mwân mə Múúd mə bá lwóya nyúúl yí. ");
INSERT INTO mcp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Jwɔ̂w dɔɔŋg í bá bə nə́, muud mə bá bə kwáminʉ́, kú bá shulə nə́ a kə́ ŋwa sâ. Nyɔɔŋg mə bá bə fambə́ yɛ́, kú ná nə́mə́ kwo kə kwáádə́. ");
INSERT INTO mcp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bɨ ɔ tə́dʉ́gá sâ í á bə nə mudá mə Lót yí. ");
INSERT INTO mcp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Muud mə bá sɔ̧́ nə́ á kaambʉlə nə cʉg jé yɛ́, a bá jímbal gwo. Nyɔɔŋg mə jímbál cʉg jé nəcé mə yɛ́, a mə́ yidá kaambʉlə nə gwo. ");
INSERT INTO mcp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Mə́ jaaw bɨ́ nə́, í bá bə búlú jɔɔŋg dɨ́ nə́ buud óbá bwə́ mbwúg gwoŋʉ́ ŋgwûd, ŋgwúd mə bá ŋwiny, ŋgwɔ́l lʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Budá óbá bwə́ ŋgə́ jí isâ kʉ́l ŋgwúd dɨ́, ŋgwúd mə bá ŋwiny, ŋgwɔ́l lʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Budûm óbá bwə́ bá bə fambə́, ŋgwúd mə bá ŋwiny, ŋgwɔ́l lʉ́g.» ");
INSERT INTO mcp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ompwíín bwə́ mú jî nyə nə́: «Cwámba, sâ jɔɔŋg í bá sɨ̂y ŋgow?» A mú bɛ̧sa nə bwo nə́: «Kʉ́l mbimbə í bá bə yí, cínɔŋg wə́ ómpal ɔ́ bá sɛɛŋgya yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yésus nyə á jɨ zə lwágʉlə bwo nə́ bwə́ dʉ́g jəgʉla ja jɛ̂sh kú teeg mə́nyúul. Gwə́ wə́ nyə á kənd bwo kanda ga yí. ");
INSERT INTO mcp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nyə á cɨ nə́: «Ŋgwɔ́l sémbye milə́sʉ́ nyə á bə wúl ŋgwə́la dɨ́ kú fúndə Zɛmbî, kú bísh tɔɔ muud. ");
INSERT INTO mcp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wúl kúsə́ múdá í á bə nə́mə́ ŋgwə́la wɔɔŋg dɨ̂, í mú dʉ zə cɨ nə sémbye milə́sʉ́ ɛ́nɛ nə́: “Ŋgwɔ́l múúd ŋgə lúmbʉli nə mə, kyɛmʉg mə.” ");
INSERT INTO mcp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sémbye milə́sʉ́ nyə á ka dʉ ban məlú məlú nə́ nyə alásɛ́ lə́sʉ́ yé wɔɔŋg. «Njɨ a mú zə cɨ nə́: “Tɛɛm bə nə́ mə afúndə́yɛ́ Zɛmbî mə kú nə́mə́ bísh tɔɔ muud ɨɨ́, ");
INSERT INTO mcp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mə zə́ kyɛm kúsə́ múdá ga nəcé mə mə́ gwág nyə káŋgá. Nyə a bá bul zə ntágʉlə mə lúu.”» ");
INSERT INTO mcp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Cwámba mú cɨ nə *ompwíín nə́: «Bɨ mə́ gwág sâ sémbye milə́sʉ́ á olɨ́lɨŋgɨ̂ ɛ́nɛ mə́ cɨ yí? ");
INSERT INTO mcp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ŋkəmʉsa nə Zɛmbî, ŋkí buud bɛ́ nyə á mə́ fɛ́ɛ́sh wá bwə́ jɨɨlya nyə́dɨ́ nə mwásə́ nə bulú, yé nyə é sá nə́ bwə́ cáág bwánd? ");
INSERT INTO mcp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mə́ jaaw bɨ́ nə́ nyə é lɛɛl kyɛm bwo nə́ máás. Njɨ, ja *Mwân mə Múúd mə bá zə yí, ye a bá ná zə kwey búgə́ shí ga dɨ́ e?» ");
INSERT INTO mcp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bɔ́ɔ́l búúd bwə́ dʉ tə́dʉga nə́ bʉ́sə otʉ́təlí, bwə́ ŋwa bɔ́ɔ́lʉ́gá mpyóŋ nə mpyóŋ. Yésus nyə á ka kənd kanda shú dáŋʉ́d, nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Buud obá bwə́ á zə kə *Luŋ mə́ Zɛmbî nə́ bwə́ kə́ jəgʉla nə Zɛmbî. Ŋgwɔ́l nyə á bə *Farizyɛ̂ŋ, ŋgwɔ́lʉ́gá nyɛ ŋwɛnyɛ tóya. ");
INSERT INTO mcp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizyɛ̂ŋ nyə a tɔ̂w tʉ́təlí a mú dʉ jəgʉla nyə́mɛ́fwó dɨ́ nə́: “Yé Zɛmbî, mə yə́ wo cúncɛ́sh nəcé mə cugɛ́ nda bɔ́ɔ́lʉ́gá búúd. Bɨ́ ijúwâl, bwə́ cɛɛl ólɨ́lɨŋgɨ̂, nə minɔɔmb, tɛɛm bə nda ŋwɛnyɛ tóya ɛ́ga, mə cugɛ́ nda nyə. ");
INSERT INTO mcp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mə́ dʉ ci ídʉ̂w ija íbá ŋkúmba shwɛ́ndɛ; mə́ dʉ jə́na *ŋkɔw wûm á sâ jɛ̂sh mə́ bíí yí.” ");
INSERT INTO mcp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ŋwɛnyɛ tóya nywáá nyə a tɔ̂w shwóg-shwóg. A kú nə́mə́ she bʉ̂n tɔɔ mpwoombʉ́ nə́ a yág ŋgɛɛ joŋ dɨ̂; nyə á yida dʉ *bí mbwə̂ bʉd dɨ́ a ŋgə́ cɨ nə́: “Yé Zɛmbî, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́, mə jɨ sɔ́ɔl *misə́m.” ");
INSERT INTO mcp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mə́ jaaw bɨ́ nə́ á məzhúgʉ́lâ ɛ́ga nyə á kə nyə́dɨ́ njɔ́w Zɛmbî mə́ sá nə́ a bə́g tʉ́təlí nyə́dɨ́ míshʉ́d, kú bə ashúshwóógʉ́ nyɛ. Nəcé, muud mə bʉ̂n nyə́mɛ́fwó gwɔ́w yɛ́, bwə́ bá səl nyə shí; nyɔɔŋg mə sə́l nyə́mɛ́fwó shí yɛ́, bwə́ bá bʉ̂n nyə gwɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bɔ́ɔ́l búúd bwə́ á zə nə́mə́ nə ikʉ́kény wə́ Yésus nə́ a kúnyág nə byo. *Ompwíín, nda bwə́ á dʉ́g ntɔ́ nə́, bwə́ mú lás nə bwo. ");
INSERT INTO mcp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yésus nywáá mú jɔ̂w bwo, nyə nə́: «Bɨ́dʉ́gá ikʉ́kágə́ í zə́g mə́dɨ́, kúgá kaambʉlə nə bwo, nəcé Faan mə́ Zɛmbî dʉ́sə sâ á mbií búúd wáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud yɛ̂sh nyə amágʉ́lə́yɛ́ Faan mə́ Zɛmbî məməgʉlá mə kʉ́kágə́ yɛ́, muud wɔɔŋgʉ̂ cúgɛ́ nə ŋkul nyíi cínɔŋg.» ");
INSERT INTO mcp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wúl cî *Oyúdɛn í á jí Yésus nə́: «Jɔ̧jɔ̧ Yɨ́ɨ́gʉli, jáyɛ́ jɔ̧ sâ mə́ sáág nə́ mə bííg cʉg á kandʉgə kandʉgə yí?» ");
INSERT INTO mcp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yésus mú yida cɨ nə nyə nə́: «Nəcé jɨ́ wó jɔ́w mə nə́ jɔ̧jɔ̧ múúd yí? Kú nə muud jɨ́ jɔ̧ múúd, njɨ Zɛmbî nyəmɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wo mpú dɨ́ məcɛ̧ɛ̧ mə́ga? “Wo kú sá mínɔɔmb, kú gwú múúd, kú júwo, wo kú yə múúd mpwɛnɛ á sá nyə́ ampúyɛ́ yí, wo gúmal sɔ́ɔ́ŋgʉ́ woó nə nyɔɔŋgʉ́ woó.”» ");
INSERT INTO mcp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Cî nə Yésus nə́: «Mə ŋgə bɛ̧ məcɛ̧ɛ̧ mə́nɨ mɛ̂sh, tɛ́ɛ́d wú íkágə́d zə kumə múús.» ");
INSERT INTO mcp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ja Yésus mə́ gwág ntʉ́nɨ yí a mú cɨ nə nyə nə́: «Sâ ŋgwúd í ŋgə ná fúfə wo: kaá kusha ísâ byɛ̂sh wó jɨ́ nə ndɨ̂ yí, wo kaaw mímbúmbúwá *mwaanɛ̂ wɔɔŋgʉ̂, wo ka bá kə bə nə məbii gwɔ̂w; ság ntɔ́ wo ka zə bɛ̧ mə.» ");
INSERT INTO mcp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cî wɔɔŋg mú shúsʉla nə mpɛ̧sá mə́ Yésus, nəcé nyə á bə nə zhwog məbii. ");
INSERT INTO mcp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yésus mú dʉ́g nə́ a mə́ shúsʉla, a mú cɨ nə́: «A kwowʉlálə nə́ buud bɨ́ nə məbii wá bwə́ nyííg Faan mə́ Zɛmbî dɨ́ eé. ");
INSERT INTO mcp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Í yida nywá bə kúnə́-kúnə nə́ *shamô nyííg luun lʉ́ ndundu dɨ́, ntɔ̧ nə́ muud á bulya məbii nyííg Faan mə́ Zɛmbî dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Buud bwə́ á ŋgə gwágʉlə Yésus wá bwə́ á ŋgə cɨ nə́: «Ká zə́ jɨ́ nə ŋkul *dʉ́g cʉg yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A mú bɛ̧sa nə bwo nə́: «Isâ í ntɔ̧́ múúd ŋkul yí, Zɛmbî nywáá jɨ nə ŋkul sá byo.» ");
INSERT INTO mcp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pyɛ̂r mú cɨ nə́: «Sə́ báá sə́ á mə́ lʉ́gə ísâ byɛ̂sh, sə́ zə bɛ̧ wo.» ");
INSERT INTO mcp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A mú cɨ nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ŋkí muud mə lʉ́gə́ tɔɔ njɔ́w, tɔɔ mudá, tɔɔ omínyɔŋʉ̂, tɔɔ obyɔ̂l, tɔɔ bwân shú Faan mə́ Zɛmbî, ");
INSERT INTO mcp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nyə é nyiŋgə bii ísâ byɔɔŋg byɛ̂sh ŋkí bulya tɛ́ nyə́ é ŋgə cʉgə wa shí yí, a bá nə́mə́ cʉgə kandʉgə kandʉgə cʉg í zág yííd.» ");
INSERT INTO mcp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yésus nyə á ka ŋwa *ompwíín wûm nə óbá bɛ́, a mú cɨ nə bwo nə́: «Dʉgá, sə́ ŋgə́lə bád kə Yurʉ́səlɛm ɔ́ga. Isâ byɛ̂sh *búúd ɔ mícúndə́ bwə́ á cilə shú mə́ *Mwân mə Múúd yí í zə́ kə bwəma. ");
INSERT INTO mcp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A zə́ kə kaanz mə́bwə̂ mə́ íkûl ishúsʉ́d, a bwəma nə cóógʉ́, buud cúg nyə, bwo sɛy nyə məntənd nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bwə́ é fyámʉsə nyə milwóŋ, bwə́ gwú nyə. Njɨ, a bá gwûm jwɔ̂w álɛ́ɛl.» ");
INSERT INTO mcp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bâŋ bwə́ áshígɛ́ ŋgə mpu gwág nda lə́sʉ́ wɔɔŋg í á ŋgə kə nə́. Í á bə bwo sâ shwoó, bwə́ kú wámbʉlə sâ Yésus nyə á ŋgə cɨ yí. ");
INSERT INTO mcp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Í á ka zə bə nə́, ja Yésus nyə á ŋgə shísh Zheríko yí, ŋgwɔ́l áncím-ncîm nyə á bə zhɨ́ɨ́ dɨ́ koogʉ́, a ŋgə́ gwáámb buud *mwaanɛ̂. ");
INSERT INTO mcp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nyə á ka gwág buud bwə́ ŋgə́ cɔ̧́ áncuncuma, a mú jî nə́: «Jɨ́ í ŋgə́ cɔ̧́ yí?» ");
INSERT INTO mcp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bwə́ mú jaaw nyə nə́ Yésus á Nazarɛ̂t wə́ ŋgə́ cɔ̧́ ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A mú kɨ̂m nə́: «Yésus Mwân mə *Dávid, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́!» ");
INSERT INTO mcp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Buud bwə́ á ŋgə kyey mpwoombʉ́ gwooŋg dɨ́ wá bwə́ mú ŋkáánd nə nyə nə́ a jíg kʉ́l-kʉ̂l. Nyɛ mú yidá mpu bʉ̂n kə́l gwɔ́w nə́: «Mwân mə Dávid, bwɨ́ɨ́gʉ́g mə nə́ ŋkwoŋʉ́.» ");
INSERT INTO mcp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yésus mú tɔ̂w, a mú cɨ nə́ bwə́ zə́g nə nyə. Ja áncím-ncîm mə́ zə wɔ́ɔ́s nyə kúnə́-kúnə yí, Yésus mú jî nyə nə́ ");
INSERT INTO mcp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wó jɨɨ nə́ mə sáág wo jɨ́?» Nyə nə Yésus nə́: «Cwámba, mísh mâm mə́ kwóg dʉ́gya.» ");
INSERT INTO mcp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yésus mú cɨ nə nyə nə́: «Mísh mwô mə́ kwóg dʉ́gya. Wo mə́ *dʉ́g cʉg nəcé búgə́ gwô.» ");
INSERT INTO mcp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nə́mə́ cé nə cé, mísh mə́ mú kwo dʉ́gya nyə. A mú ŋgə bɛ̧ Yésus a ŋgə́ yə Zɛmbî gúmə́. Buud bɛ̂sh bwə́ á dʉ́g sɔ́ɔ́lʉ́gʉ́ wɔɔŋg wá bwə́ mú ŋgə yə Zɛmbî məshwúmb. ");
INSERT INTO mcp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nə́ ndɛɛ́ Yésus mú nyíi Zheríko, a mú ŋgə lɨ́ɨ́na ŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ŋgwɔ́l múúd nyə á bə cínɔŋg nə́ Zashé, a njúl ŋwɛnyɛ tóya, a mbíd zhwog məbii. ");
INSERT INTO mcp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nyə á ŋgə sɔ̧́ nə́ a dʉ́g Yésus; njɨ nyə a shígɛ́ bə nə ŋkul mə dʉ́g nyə nəcé buud bwə́ á bə áncuncuma, Zashé nyɛ njúl ntâg wúlə-wúlə. ");
INSERT INTO mcp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A mú ju nə kʉ́lə́ kə shwóg kə bád sikomɔ̂r dɨ̂ shú nə́ a bâg dʉ́g Yésus ja á bá cɔ̧́ cínɔŋg shí yí. ");
INSERT INTO mcp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ja Yésus nyə á zə wɔ́ɔ́s kʉ́kʉ́l jɔɔŋg dɨ́ yí, nyə a bʉ̂n mísh a mú cɨ nə Zashé nə́: «Zashé, lɛɛlʉg shulə nəcé í jɨɨ nə́ mə jíg wódɨ́ njɔ́w múús.» ");
INSERT INTO mcp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zashé mú lɛɛl shulə, a mú kə lə́g Yésus nə məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nda búúd bwə́ á dʉ́g ntɔ́ nə́, bɛ̂sh bwə́ á ŋgə nyímbʉla nə́: «A mə́ kə nyíi kə ji múúd misə́m dɨ́ njɔ́w!» ");
INSERT INTO mcp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zashé nywáá mú tɔ̂w tʉ́təlí cɨ nə Yésus nə́: «Cwámba e, mə zə́ kaaw mə́bii mâm tʉ́tám nə́ cáŋ, mə yə mimbúmbúwá dúl kɔw. Ŋkí mə a shí ntâg mánda múúd nə sá jé mə nyiŋg nyə gwo ija inɔ̧̂.» ");
INSERT INTO mcp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yésus músə cɨ nə́: «Zɛmbî mə́ cʉg búúd ɔ́ njɔ́w ga múús, nəcé a jɨ nə́mə́ múúd á bag mə *Abʉraham. ");
INSERT INTO mcp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nəcé *Mwân mə Múúd nyə á zə sɔ̧́ bɔɔŋg bwə́ á jímb wá, zə cʉgʉshi bwo.» ");
INSERT INTO mcp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Buud bwə́ mú gwág lə́sʉ́ Yésus nyə á lás yí. Yésus mú kə nə lə́sʉ́ shwóg kənd bwo kanda nəcé bwə́ á ŋgə tə́dʉga nə́, nda a mú kúnə́-kúnə nə Yurʉ́səlɛm nə́ Faan mə́ Zɛmbî í zə nyîn. ");
INSERT INTO mcp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ntɔ́ Yésus mú cɨ nə́: «Ŋgwɔ́l múúd nyə a byɛ̂l njɔ́w mícî dɨ̂. Nyə á ka zə bə nə́ a kə́ nyúl shí a shwóg-shwógʉ́d bwə́ kə́ tə́l nyə Njwú-buud nə́ ndɛɛ́ a mú nyiŋgə. ");
INSERT INTO mcp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ja á mə́ bə nə́ a zə́ tɨ́ yí, a mú jɔ̂w osɔ́ɔl ɔ mə́sáal bɛ́ wûm, zə yə bwo *mwaanɛ̂, muud yɛ̂sh sáŋ mína ŋgwúd; nyə nə bwo nə́: “Ŋgəgá nə sá omákíd nə mwaanɛ̂ ɛ́nɛ té mə é bə njɔɔnd dɨ́ yí.” ");
INSERT INTO mcp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Njɨ, nda búúd ɔ́ lɔɔm yé bwə́ á dʉ mpii nyə nə́, bwə́ á kənd buud nyə́dɨ́ mpʉ́sə kə jaaw nə́: “Sə́ acɛ́ɛ́lɛ́ nə muud ɛ́nɛ jwúg nə sə́.” ");
INSERT INTO mcp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ja bwə́ á shîn tə́l nyə njwú-buud yí, nyə á ka nyiŋgə. A mú zə wɔ́ɔ́s, a mú jɔ̂w ósɔ́ɔl ɔ́ mə́sáal bɛ́ nyə á kaaw mwaanɛ̂ wá nə́ bwə́ zə́g lwágʉlə nyə nda mákîd máŋ mə́ á kyey nə́. ");
INSERT INTO mcp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ashúshwóógʉ́ mú zə wɔ́ɔ́s, nyə nə́: “Mása, saŋ wô í á mə́ sá nə́ mə bííg misaŋ wûm.” ");
INSERT INTO mcp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Njwú-buud mú cɨ nə nyə nə́: “Ʉhʉ́ʉŋ, wo jɨ jɔ̧jɔ̧ sɔ́ɔl məsáal. Wo mə́ bə mə abúgʉ́lág nə sʉ́sʉ́sá ácíg-cíg. Mə mə́ yə wo ijwûga nə́ wo jwúg nə miŋgwə́la wûm.” ");
INSERT INTO mcp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sɔ́ɔl məsáal ábɛɛ̂ mú nə́mə́ zə, nyə nə́: “Mása, saŋ wô í á mə́ sá nə́ mə bííg misaŋ mitɔ́ɔn.” ");
INSERT INTO mcp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Njwú-buud mú nə́mə́ cɨ nə nyə nə́: “Mə mə́ yə nə́mə́ wo ijwûga nə́ wo jwúg nə miŋgwə́la mitɔ́ɔn.” ");
INSERT INTO mcp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Ŋgwɔ́l mú nə́mə́ zə, nyə nə́: “Mása, saŋ wô wə́ ga. Mə a fʉ́lə wo nábʉ́kən dɨ́ nə́ ndɛɛ́ mə baagʉlə. ");
INSERT INTO mcp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mə á ŋgə fúndə wo nəcé wo jɨ muud ŋkʉ́d; wó dʉ ŋwa sâ jɨ́ nə́ wo dɨ́ wo á bwɨ́ɨ́g yí, wo dʉ saag isâ bísə́ nə́ wo dɨ́ wo á bɛ̧ yí.” ");
INSERT INTO mcp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Njwú-buud mú cɨ nə nyâŋ nə́: “Mə zə́ sámb wo lə́sʉ́ wô na wódɨ́ íciyád. Wo jɨ bɔ́w-bɔ̂w sɔ́ɔl məsáal. Wo á ŋgə mpu nə́ mə jɨ muud ŋkʉ́d, mə́ dʉ ŋwa ísâ bísə́ nə́ mə dɨ́ mə a bwɨ́ɨ́g yí, mə dʉ saag ísâ bí nə́ mə dɨ́ mə á bɛ̧ yí. ");
INSERT INTO mcp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ká nəcé jɨ wó áshígɛ́ kə wá mə mwaanɛ̂ waamə́ bâŋ dɨ́, nə́ ja mə́ wɔ́ɔ́s yí, mə zə ŋwa nyə nə məbədî gwɔ̂w yí?” ");
INSERT INTO mcp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","A mú cɨ nə buud bwə́ á bə cínɔŋg wá nə́: “Dɛ́ɛ́gʉ́gá nyə saŋ nɨ bɨ yə́g nyɔɔŋg jɨ́ nə misaŋ wûm yɛ́.” ");
INSERT INTO mcp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bwə́ mú cɨ nə nyə nə́: “Cwámba, á bwey fwo bə nə misaŋ wûm.” ");
INSERT INTO mcp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mə mpú jaaw bɨ́ nə́ muud jɨ́ nə baalɛ́ yɛ́, Zɛmbî mə bá kwádʉlə nyə. Njɨ nyɔɔŋg cúgɛ́ nə ndɨ́ yɛ́, Zɛmbî mə bá mɛɛl yîl nyə bʉ́baalɛ̂ á jɨ́ nə ndɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Nə́ ndɛɛ́ mizhízhíŋ myâm mí á ban nə́ mə kú jwú nə bwo wá, zəgá nə bwo wa, zə cígə bwo məcʉ́ŋ mə ŋgə́ dʉ́g.”» ");
INSERT INTO mcp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja Yésus nyə á shîn lás ntʉ́nɨ yí nyə a tɔ̂w shwóg ŋwa zhɨ́ɨ́ kə́lə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Í á ka zə bə, Yésus nyə á ŋgə shísh kúnə́-kúnə nə Betʉfazhe nə Betanî, a mú kə wɔ́ɔ́s ŋgɛɛ́ mbʉ́ŋ bwə́ dʉ́ jɔ̂w nə́ *Mbʉ́ŋ wə́olivyê yí. A mú lwâm *ómpwíín óbá. ");
INSERT INTO mcp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nyə nə bwo nə́: «Kəgá na də́nd á shwóg nɨɨ́d. Í é bə, bɨ́ ká nə́mə́ jé bɨ kwey cwɔ̧ jakáás cɛ̧ɛ̧lá, í njúl nə́ tɔɔ muud nyə a bwɛ́lɛ́ kəwa gwod. Bɨ́ ɔ́ ciny gwo, zə mə nə ndɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ŋkí muud mə jí bɨ́ nə́ nəcé jɨ́ bɨ́ ŋgə́ ciny gwo yí, bɨ́ bɛ̧sa nə nyə nə́: “Cwámba wə́ ŋgə́ jɨɨ gwo.”» ");
INSERT INTO mcp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Buud nyə á lwâm wá bwə́ mú kə, kə nə́mə́ kwey ísâ nda nyə á cɨ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja bwə́ mə́ ciny cwɔ̧ jakáás yí, wəamə́dɨ́ bɛ́ bwə́ mú cɨ nə bwo nə́: «Bɨ mə́ ciny gwo nəcé jɨ?» ");
INSERT INTO mcp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bwə́ nə́: «Cwámba wə́ ŋgə́ jɨɨ gwo». ");
INSERT INTO mcp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bwə́ mú zə Yésus nə cwɔ̧ jakáás jɔɔŋg, bwə́ ŋgə yîl mikáándə́ myáŋ ŋgə jɛɛl gwo kwoŋʉd, bwə́ mú jil Yésus gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yésus mú ŋgə kə jakáás dɨ́, buud bwə́ ŋgə́ taalə mikáándə́ myáŋ zhɨ́ɨ́d. ");
INSERT INTO mcp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ja nyə á ŋgə shísh kúnə́-kúnə nə Mbʉ́ŋ wə́olivyê yí, ompwíín bɛ̂sh bwə́ á bə áncuncuma wá bwə́ mú bə nə məshusʉg, bwə́ mú ŋgə yə Zɛmbî məshwúmb gwɔ́w-gwɔ̂w nəcé məma misɔ́ɔ́lʉ́gʉ́ mí ŋkûl bwə́ á dʉ́g myá. ");
INSERT INTO mcp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bwə́ mú ŋgə cɨ nə́: Gúmə́ í bə́g nə Njwú-buud ŋgə́ zə jínə́ mə́ Cwámba dɨ́ yɛ́. Joŋ í bə́g nə́ shɛɛ, gúmə́ joŋ lʉ gwɔ́w dɨ́ cwû. ");
INSERT INTO mcp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bɔ́ɔ́lʉ́gá *Ofarizyɛ̂ŋ bwə́ á bə na mə́ŋkúmbə mə búúd dɨ́ wá bwə́ mú cɨ nə Yésus nə́: «Yɨ́ɨ́gʉli, wo alásɛ́ nə ompwíín bwô nə́ bwə́ yɔ́wʉg kɨ́mʉ́lə?» ");
INSERT INTO mcp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A mú bɛ̧sa nə bwo nə́: «Mə́ jaaw bɨ́ nə́ ŋkí bwə́ ji kʉ́l-kʉ̂l, məkwóógʉ́ kɨ̂m.» ");
INSERT INTO mcp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yésus nyə á ŋgə shísh ŋgwə́la nə́ ndɛɛ́ ja nyə á dʉ́g wə yí, nyə á jɨɨ yə́ nə gwágʉ́lə wə cɛy lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A mú cɨ nə́: «Eéé! Jwɔ̂w gaád wo mbə̂m mpu nda wó jə́lá nə sɔ̧́ nə́ wo jííg nə́ shɛɛ nə́! Ká jísə wo shwɨɨlyá, mísh mwô kú dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nəcé mɔ́ɔ́l mwɔ̂w mə́ bá bə wo nə́ mizhízhíŋ myô mí bá laá wo nə mimyə́gə́, mí lyɛ̧ wo nə dɔɔmb, shúsə wo ikɔ́ɔ́mb byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bwə́ bá caam wo nə bwân bwô, lʉ́gə wo shí nə shí kú nə tɔɔ kwóógʉ́ í mbə́d dúlʉ́gáád. Í bá bə wo ntɔ́ nəcé wo a shígɛ́ mpu fwála Zɛmbî nyə á zə nə́ a zə́ cʉgʉshi wo yí.» ");
INSERT INTO mcp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nə́ ndɛɛ́, Yésus mú kə nyíi *Luŋ mə́ Zɛmbî, a mú kə wɨ́ɨ́ŋg búúd bwə́ á ŋgə sá mikus cínɔŋg wá, ");
INSERT INTO mcp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nyə nə bwo nə́: «Jísə cilyá Kálaad Zɛmbî dɨ́ nə́: “Njɔ́w wâm í bá bə njɔ́w mə́jəgʉla.” Bɨ bâŋ mə́ yida sá nə́ í bə́g daagɛ lʉ́ íjúwâl!» ");
INSERT INTO mcp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nyə á ka dʉ yə buud minjɨ́ɨ́gʉ́lá Luŋ mə́ Zɛmbî jwɔ̂w dɛ̂sh. Nə́ ndɛɛ́, nə Milúlúú myâ ofada, nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧, nə mícî mí kúl búúd mí mú ŋgə sɔ̧́ nə́ mí gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Njɨ bwə́ áshígɛ́ mpu nda bwə́ sáág nə́, nəcé məŋkúmbə mə búúd mɛ̂sh mə́ á dʉ gwágʉlə nyə nə lâm wɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Í á bə dúl jwɔ́wʉ́d nə́, Yésus ŋgə́ yə buud minjɨ́ɨ́gʉ́lá *Luŋ mə́ Zɛmbî, a ŋgə́ jaaw Jɔ̧jɔ̧ Kɛ́ɛl, seegya nə́ milúlúú myâ ofada, nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧, nə ocúmbá buud bwə́ mə́ wɔ́ɔ́s. ");
INSERT INTO mcp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bwə́ mú jí nyə nə́: «Jaawʉg sə̂. Nyáyɛ́ ŋkul wó ŋgə́ sá ísâ ínɨ nə ndɨ́ yí? Zə́ nyə ámə yə wo ŋkul nyɔɔŋgʉ̂?» ");
INSERT INTO mcp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A mú bɛ̧sa nə bwo nə́: «Mə zə́ nə́mə́ fwo jí bɨ́ njígá. ");
INSERT INTO mcp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nduwán Yuánɛs nyə á ŋgə duu buud yí, í á bə nə nyáyɛ́ ŋkûl? Ye ŋkul á gwɔ́w wə́ Zɛmbî, ye ŋkul á buud?» ");
INSERT INTO mcp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bwə́ mú tə́dʉga nə́: «Ŋkí sə́ mə́ cɨ nə́: “gwɔ́w”, nyə e jí sə́ nə́: “Ká nəcé jɨ́ bɨ́ a shígɛ́ *búgʉla nyə yí?” ");
INSERT INTO mcp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sə́ mə́ ká mɛɛl cɨ nə́ í á bə ŋkul á buud ɨɨ́, kúl búúd jɛ̂sh gwú sə́ nə məkwóógʉ́, nəcé bɛ̂sh bwə́ ŋgə magʉlə nə́ Yuánɛs nyə á bə *muud micúndə́.» ");
INSERT INTO mcp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bwə́ mú bɛ̧sa nə́ bwə́ ampúyɛ́ kʉ́l í á ŋgə wú yí. ");
INSERT INTO mcp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yésus mú cɨ nə bwo nə́: «Mə ajááwɛ́ nə́mə́ bɨ́ ŋkul mə́ ŋgə́ sá misɔ́ɔ́lʉ́gʉ́ míga nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yésus nyə á ka kənd buud kanda ga nə́, «Ŋgwɔ́l múúd nyə a sá fambə́ *vînyə a mú yə búúd fambə́ jɔɔŋg mə́céd. A músə kə njɔɔnd dɨ́ nə́ nyə é já fwámɛ́ fwála. ");
INSERT INTO mcp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Fwála lʉ́ mə́mwáágʉlə dɨ́, nyə á kənd ŋgwɔ́l sɔ́ɔl məsáal yé nə́ a kə́g ŋwa nyə dɛ́ kɔw lʉ mpúmə́ búúd bwə́ á lʉ́g nə fambə́ wá dɨ́. Njɨ buud bɔɔŋgʉ́ bwə́ mú kə daŋgʉlə cú sɔ́ɔl məsáal nə́ ndɛɛ́ nyiŋg nyə məbwə̂ məbwə̂. ");
INSERT INTO mcp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Muud fambə́ mú ŋwa cígʉ́lá nə́ á nyiŋgə nə́mə́ kənd ŋgwɔ́l sɔ́ɔl məsáal yé. Bwə́ mú nə́mə́ kə daŋgʉlə cú nyâŋ, sɛ́ɛ́mbʉli nyə nə məlwíy nə́ ndɛɛ́ nyiŋg nyə məbwə̂ məbwə̂. ");
INSERT INTO mcp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Muud fambə́ nə́ á nyiŋgə nə́mə́ kənd sɔ́ɔl məsáal álɛ́ɛl. Bwə́ mú kə wá nyâŋ məfə́ŋ nə́ ndɛɛ́ bwə́ wɨ́ɨ́ŋg nyə. ");
INSERT INTO mcp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Muud fambə́ mú ka zə cɨ nə́: “Mə sáág nə́ e? Mə zə́ kənd mwân waam mə́ búl cɛɛl yɛ́, ka bwə́ é gwɔ̧́ɔ̧ nyə.” ");
INSERT INTO mcp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ká, buud bwə́ á lʉ́g nə fambə́ wá, dʉ́gʉ́lə bwə́ á dʉ́g *Mwân mə Múúd fambə́ mə́ wɔ́ɔ́s yí, bwə́ á nyímbʉla bwə́mɛ́ nə bwə́mɛ́ nə́: “Muud mə bá lʉ́g nə lʉ́gí wə́ ɛ́nɛ. Shé gwúgá nyə shé bâg lʉ́g nə lʉ́gí.” ");
INSERT INTO mcp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bwə́ mú julə wú nə nyə fambə́, kə gwú nyə ncâ.» Yésus mú jí bwo nə́: «Muud fambə́ mə́ bá sá búúd ɔ́nɨ ntʉdɛl? ");
INSERT INTO mcp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ŋgaá nə́ a bá zə gwú bwo nə́ ndɛɛ́ a ŋwa fambə́ yə búúd oshús?» Ja búúd bwə́ á gwág á mə́ cɨ ntɔ́ yí, bwə́ á lás nə́: «Mbɔ̂! Í cúgɛ́ nə ŋkul bə ntɔ́!» ");
INSERT INTO mcp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yésus mú dʉ́g bwo nə́ figə́-figə́, a mú jí bwo nə́: «Micilyá míga mí kə́ nə́ jɨ? Kwóógʉ́ ólwɔ̧́ye bwə́ á myaas yí, dwó wə́ í mə́ bə kwóógʉ́ lʉ́ lʉ́mʉga. ");
INSERT INTO mcp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Muud mə bá bʉ́l kwóógʉ́ dɔɔŋg dɨ́ yɛ́ mə bá kweshʉli búg; nyɔɔŋg kwóógʉ́ dɔɔŋg í bá káda yɛ́ mə bá cugʉli.» ");
INSERT INTO mcp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ milúlúú myâ ofada bwə́ á mpu nə́ lə́sʉ́ wáŋ wə́ Yésus nyə á ŋgə lás kaanə́d nɨ. Bwə́ mú tɛ́ɛ́d ŋgə́lə sɔ̧́ məzhɨɨ́ nə́ bwə́ bii nyə nə́mə́ wəla dɔɔŋgʉ́d. Njɨ bwə́ á ka ŋgə fúndə məŋkúmbə mə búúd. ");
INSERT INTO mcp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nə́ ndɛɛ́ bwə́ mú ŋgə baagʉsə Yésus. Bwə́ kə kənd búúd nə́ bwə́ kə́g nda buud wâ tʉ́təlî. Bwə́ ká dʉ bwéél nə́ ka bwə́ é gwág gúl ciyá í ajə́láyɛ́ yí, bwə́ kusha nə nyə, a bə mə́nyámá mə́ ŋgwə́mʉna dɨ́, nyə́dɨ́ mpə̂l dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Buud bwə́ mú zə jí Yésus nə́: «Yɨ́ɨ́gʉli! Sə́ ŋgə mpu nə́ lə́sʉ́ wô nə njɨ́ɨ́gʉ́lá wô bísə tʉ́təlî. Wó dʉ nə́mə́ dʉ́g búúd njɨ nda njɨ́ɨ́gʉ́lá wô wɨ́ nə́. Wo ŋgə jɨ́ɨ́gʉli sə́ cʉg á Zɛmbî bʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ntɔ́, jaawʉg sə̂. Ye məcɛ̧ɛ̧ mə́shé mə́ ŋgə magʉlə nə́ sə́ jə́nág tóya mə *Káázɛl, ye mə́ aŋgɛ̂ nə magʉlə?» ");
INSERT INTO mcp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ká, Yésus nyə á bwey mpu məkə́ŋ máŋ, a mú cɨ nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Lwógá ná mə saŋ *danarî. Zə́ jɨ́ nə vʉgʉli mpwoombʉ́ nə jínə́ bwə́ á lúlə wa ga?» Bwə́ nə́: «Jísə Káázɛl.» ");
INSERT INTO mcp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nyə ntâg nə bwo nə́: «Ntɔ́, yə́gá Káázɛl isâ í Káázɛl, bɨ́ yə Zɛmbî isâ í Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bwə́ mú kú nə sá bwə́ júmʉg Yésus mísh mə́ búúd dɨ́ yí; bwə́ mú bul káam mpɛ̧sá nɨ, bwə́ shwal fad mímpu. ");
INSERT INTO mcp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gúl bʉ́baalɛ̂ *Osadwisyɛ̂ŋ, buud bwə́ dʉ cɨ nə́ mimbimbə mí ábʉ́lɛ gwûm mə́shwoŋ dɨ́ wá, í á ka zə wə́ Yésus, zə jí nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Yɨ́ɨ́gʉli, Moyîz nyə á yə sə́ cɛ̧ɛ̧ nə́: “Ŋkí muud mə yə́ kundú, mínyɔŋʉ̂ yé mə́ jəlá nə shúgʉla nə kúsə́ yé, a byág nyɔɔŋg mə́ yə yɛ́ mpwoŋ buud.” ");
INSERT INTO mcp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bɔ́ɔ́l ómínyɔŋʉ̂ bwə́ á byɛ̂l wa zaŋgbá budûm nə budûm. Acúmbá mú bâ múdá, a mú yə kú nə mwân. ");
INSERT INTO mcp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nyɔɔŋg nyə á bɛ̧ nə nyə yɛ́ mú ŋwa múdá, ");
INSERT INTO mcp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","álɛ́ɛl ŋwa nə́mə́ nyə, nə́ ndɛɛ́ bɛ̂sh zaŋgbá bwə́ á ŋwa mudá wɔɔŋgʉ̂, bwə́ ŋgə́ yə kú byá mwân. ");
INSERT INTO mcp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Zhúgʉ́lá zhúgʉ́lâ, mudá mú nə́mə́ yə. ");
INSERT INTO mcp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ja búúd bwə́ bá gwûm yí, nyáyɛ́ mə bá ka ŋwa mudá? Ŋgaá nə́ bɛ̂sh bwə́ á shí bə ógwúm bɛ́?» ");
INSERT INTO mcp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yésus mú bɛ̧sa nə bwo nə́: «Buud wâ cʉg ga bwə́ ŋgə bə, budûm bâ búdá, budá kə məbáád. ");
INSERT INTO mcp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Njɨ, bɔɔŋg bwə́ bá nyîn nə́ bwə́ jəlá nə gwûm bwə́ cʉgə cʉg í zág wá, bwə́ ábʉ́lɛ dʉ sá mə́bâ: budúm nda ná bâ búdá, budá nda ná kə mə́báád. ");
INSERT INTO mcp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bwə́ ábʉ́lɛ ná nə́mə́ bə nə ŋkul yə, nəcé bwə́ bá bə nda *wəéŋgəles. Bwə́ bá bə bwân ɔ́ Zɛmbî nəcé í bá bə bwə́ mə́ wú shwɨy dɨ́ kə cʉgʉd. ");
INSERT INTO mcp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kɔ́ɔ́mb á mimbimbə bálə gwûm mə́shwoŋ dɨ́, Moyîz nyə a lwágʉlə ntɔ́ ja nyə á kwey ŋgwiilɛ ŋkaŋ dɨ́ yí; nyə á jɔ̂w Cwámba nə́ Zɛmbî mə́ *Abʉraham, Zɛmbî mə́ *Izaag, Zɛmbî mə́ *Yákwab. ");
INSERT INTO mcp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ntɔ́ jɨ nə́ Zɛmbî cugɛ́ Zɛmbî mimbimbə, a jɨ yidá bə Zɛmbî á buud bwə́ ŋgə́ cʉgə wá. Ntɔ́ jɨ shú dɛ́d nə́ bɛ̂sh bwə́ ŋgə cʉgə.» ");
INSERT INTO mcp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bɔ́ɔ́lʉ́gá *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú lás cɨ nə́: «Yɨ́ɨ́gʉli, wo mə́ mpu lás.» ");
INSERT INTO mcp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bwə́ áshígɛ́ ná nyiŋgə bwɛlɛ jí Yésus tɔɔ njígá ŋgwúd nə ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A mú cɨ nə bwo nə́: «Ntʉdɛlɛ́ búúd bwə́ mpú dʉ cɨ nə́ *Krîst jɨ mwân mə Dávid yɛ́? ");
INSERT INTO mcp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ŋgaá Dávid nyə á cɨ nyə́dɨ́ kálaad Osôm dɨ́ nə́: Cwámba nyə á cɨ nə Cwámba wâm nə́: “Jig shí wa mə́dɨ́ mbwə̂ məncwûm, ");
INSERT INTO mcp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kə wɔ́ɔ́s ja mə é culʉshi mízhízhíŋ myô, wo nyaál myo nə məkuú yí!” ");
INSERT INTO mcp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ŋkí Dávid mə́ bwey jɔ̂w *Krîst nə́ Cwámba, nyə é ka bə Dávid mwân na ntʉdɛlɛ?» ");
INSERT INTO mcp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yésus mú cɨ nə *ompwíín bɛ́ buud bɛ̂sh bwə́ ŋgə́ gwág nə́: ");
INSERT INTO mcp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Bɨ ɔ káálʉ́gə́ nə Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ cɛ́ɛ́l dʉ mɛ̧ɛ̧la nə ŋwɔ̧ɔ̧la ŋwɔ̧ɔ̧la íjud wá, bwə́ cɛ́ɛ́l nə́mə́ nə́ buud bwə́ dʉ́g bə́da bwo məbə́dá mə́ gúmə́ mə́ŋkúmbə mə búúd dɨ̂ wá, bwə́ nə́mə́ wə́ bwə́ cɛ́ɛ́l dʉ́lə kə ji njɨ íjiya yâ shwóg ja bʉ́sə́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ́ yí, nə dʉ́lə dʉ ji njɨ lúú tʉ́wʉli dɨ́ ja bwə́ dʉ́ kə ídína dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bwə́ dʉ dɛ́ɛ́g míkúsə́ mí búdá isâ byáŋ byɛ̂sh ka dʉ sá igwaa-gwaa í mə́jəgʉla nə́ bwə́ dʉ́gʉ́g nə́ bʉ́sə ijɔ̧ɔ̧́ i búúd. Intʉ́gʉ́lí byáŋ í bá bə ŋkí jág bul nyaan.» ");
INSERT INTO mcp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yésus nyə a bʉ̂n mísh a mú dʉ́g ofwó búúd bwə́ ŋgə́ wá məyə́na máŋ jaadə́ mə́yə́na mâ *Mpáánzə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A mú nə́mə́ dʉ́g wúl mbúmbúwá kúsə́ múdá ŋgə́ wá isʉsáŋ íbá. ");
INSERT INTO mcp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yésus mú cɨ nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, mbúmbúwá kúsə́ múdá nɨ mə́ wá mə́yə́na cɔ̧́ búúd bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nəcé buud ɔ́nɨ bwə́ ámə ŋgə wá ɔ́nɨ, bwə́ ámə ŋgə ŋwa mə́mpugə mâ byɔɔg dáŋʉ́d. Ká nyɛ, a njúl mbúmbúwá, nyə ámə wá bímbí dɛ̂sh í ámə bə nə́ nyə é ŋgə cʉgə nə ndɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bɔ́ɔ́l búúd bwə́ á ŋgə faag *Luŋ mə́ Zɛmbî bwə́ ŋgə́ cɨ nə́ məlwɔ̧́ga mâ cínɔŋg mə́sə nə jɔ̧jɔ̧ mə́kwóógʉ́, jɔ̧jɔ̧ ísâ búúd bwə́ á ŋgə yə Zɛmbî yí í ŋgə́ kwádʉlə ijɔ̧ɔ̧. Nda bwə́ á ŋgə faag ntɔ́ nə́, Yésus mú cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Sâ bɨ́ ŋgə́ dʉ́g ŋkí nywa nɨ í bá cɨɨm jɛ̂sh, dúl kwóógʉ́ í ábʉ́lɛ́ lʉ́g na í mbə́d dúl gwɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bwə́ mú ka jí nyə nə́: «Yɨ́ɨ́gʉli, jâŋ sâ í bá bə jáyɛ́ ja? Jɨ́ í bá ka lwágʉlə sə́ nə́ í wál zə sɨ̂y?» ");
INSERT INTO mcp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yésus mú cɨ nə bwo nə́: «Bɨ ɔ́ bɛy nə́ buud bwə́ bâg zə kənd bɨ́ jugʉ́. Nəcé buud ŋkí bulya bwə́ bá dʉ zə nə jínə́ dâm zə cɨ nə́: “Mə wə́ *Krîst,” bwə́ nə́: “Wəla í mə́ wɔ́ɔ́s.” Bɨ́ kú bá dʉ bɛ̧ bwo. ");
INSERT INTO mcp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ja bɨ́ mə́ bá dʉ gwág miláŋ mí mɔ́ɔmb yí, bɨ kú bá dʉ gwág wagʉwo. Bɨ́ tɛɛm gwág nə́ buud bwə́ mú ŋgə sá miŋgáádə́ nə ijwû, bɨ́ kú bá gwág wagʉwo. Nəcé í bá jɨɨ nə́ isâ byɔɔŋg í ŋgə́g nə tɛ́ɛ́d fwo sɨ̂y; njɨ, í ábʉ́lɛ́ lɛɛl bə mə́shíné mə́ shí.» ");
INSERT INTO mcp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A mú nyiŋgə cɨ nə bwo nə́: «Gúl lwoŋ í bá lúmbʉli nə gúl, dúl faan lúmbʉli nə dúl, ");
INSERT INTO mcp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","shí í bá dʉ jág ntaŋʉsa, zha á ifií mpu nə okwaag-jumə ɔ́ mə́bwas í bá dʉ bə íkʉ́l ikʉ̂l, isâ í áwuwagʉwə̂ nə məma ísâ í ntɔ̧́ búúd fʉg yí í bá dʉ zhu gwɔ̂w joŋ dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Njɨ, shúshwóógʉ́ nə́ isâ ínɨ byɛ̂sh í bə́g, bwə́ bá dʉ bii bɨ̂, dʉ lwágʉlə bɨ̂ cúwʉ́lí, bwə́ bá dʉ kusha nə bɨ̂ mə́bwə́ mə́ wə́amə́dɨ́ wâ *məmpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn, bwə́ wá bɨ́ mímbwugʉd. Bɨ mə bá dʉ kaad mísh mə́ ójwû ɔ́ lɔɔm nə buud ɔ́ anʉ́nɨ̂ dɨ́ nəcé jínə́ dâm. ");
INSERT INTO mcp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Njɨ sɔ́ɔ́lʉ́gʉ́ wɔɔŋg wɛ̂sh í bá bə shú nə́ bɨ kə́g bwaagʉlə sâ bɨ́ mə́ mpú shú dâm yí. ");
INSERT INTO mcp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bweyʉgá wá mílúúd nə́ bɨ ajə́láyɛ́ nə bá dʉ kwəmʉsa mbii bɨ́ mə́ bá dʉ shwɔ̧ mə́nyúúl yí. ");
INSERT INTO mcp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Məmɛ́fwó mə bá dʉ yə bɨ́ iciyá í lə́sʉ́ nə fʉg mbií í bá dʉ bə nə́, buud bɛ̂sh bwə́ bá dʉ lúmbʉli nə bɨ́ wá, ŋgwúd nə ŋgwúd kú tɨ́ sâ bɨ́ mə́ cɨ́ yí, ŋgwúd nə ŋgwúd kú wá íciyá í oŋkwafad. ");
INSERT INTO mcp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Obyɔ̂l bʉ́n bwə́mɛ́fwó, tɔɔ omínyɔŋʉ̂ bʉ́n, tɔɔ mimbyɛ̂l mín nə oshwə́ bʉ́n bwə́ bá dʉ kusha nə bɨ̂, bwə́ sá nə́ bɨ́ bɔ́ɔ́l ŋkí bulya bɨ bwə́mag nə shwɨy. ");
INSERT INTO mcp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Buud bɛ̂sh bwə́ bá mpii bɨ́ nəcé jínə́ dâm. ");
INSERT INTO mcp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Njɨ, sâ í ábʉ́lɛ́ sá bɨ́ tɔɔ bíbíyá. ");
INSERT INTO mcp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bɨ ɔ́ bá jísɔw kə wɔ́ɔ́s mə́shínéd, bɨ mú bá cʉgə. ");
INSERT INTO mcp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Njɨ, ja bɨ́ mə́ bá dʉ́g ígwooŋg i dɔ́ɔ́mb í mə́ lyɛ̧ Yurʉ́səlɛm nə́ kɛsh yí, bɨ ɔ bá mpu nə́ Yurʉ́səlɛm wál zə cɨɨm. ");
INSERT INTO mcp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nə́ ndɛɛ́, buud bwə́ bá bə Yudéa wá bwə́ bâg fúndə kə mímbʉ́mbʉ́ŋʉ́d! Bɔɔŋg bwə́ bá bə tâm ŋgwə́la wá, bwə́ bâg wû; bɔɔŋg bwə́ bá bə mpʉ́sə milɔɔm wá, bwə́ kú bá zə ŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nəcé mwɔ̂w mɔɔŋg mə́ bá bə mwɔ̂w Zɛmbî mə bá zə yə búúd intʉ́gʉ́lí má, sâ jɛ̂sh Mícilyá mí ŋgə́ cɨ yí í bá bwəma. ");
INSERT INTO mcp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋkwɛ́ɛ budá bwə́ bá bə nə məbum, nə bɔɔŋg bwə́ bá ŋgə nyɛ́ɛ́ŋg bwân mwɔ̂w mɔɔŋg dɨ́ wá! Bwə́ bá bul ŋkúŋkwoŋ. Nəcé məntágʉla mə́ bá bul bə lɔɔm dɨ́, mpimbə mə́ Zɛmbî í bá bii kúl búúd ga. ");
INSERT INTO mcp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɔ́ɔ́l bwə́ bá gwúyɔw nə ikafwɛlɛ, bɔ́ɔ́l kə míkwámʉ́d ikúl byɛ̂sh í cúgɛ́ Oyúdɛn dɨ̂; ikúl í cúgɛ́ Oyúdɛn í bá yád Yurʉ́səlɛm, tagʉlə nyaal nyə nə́ ndɛɛ́ kə kumə mə́shíné mə́ jwaŋga dáŋ.» ");
INSERT INTO mcp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«*Məshimbá mə́ bá wɔ́ɔ́s jwɔ̂w nə ŋkwoond nə wə́acén-céníd. Shí í bá bə nə́, ilwoŋ í bá bə ífwaasʉd, muud kú wɔɔf nəcé mâŋ mə́ bá sá məma ncíndə́, ikwɔ̧́ bul juŋgya. ");
INSERT INTO mcp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Buud bwə́ bá ŋgə kân nə fúndʉ́gʉ́ ŋgə́lə bwánd cúgə́ í bá wɔ́ɔ́s shí mishwun yí, nəcé isâ byɛ̂sh bísə́ nə mpífə́ joŋ dɨ́ yí í bá kúŋgʉla. ");
INSERT INTO mcp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja jɔɔŋgʉ̂, bwə́ bá ka dʉ́g *Mwân mə Múúd ŋgə́ zə míŋkúdʉ́d, a zág nə mpífə́ nə milwanə́. ");
INSERT INTO mcp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ja ísâ byɔɔŋg í bá tɛ́ɛ́d ŋgə́lə sɨ̂y yí, bɨ ɔ bá sʉ́g mə́nyúúl íjiyad, bɨ́ bʉ̂n milúu nəcé í bá bə wəla bɨ́ mə́ bá zə wú mə́nyámád yí í mú kúnə́-kúnə.» ");
INSERT INTO mcp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A mú kənd bwo kaanə́ nə́: «Ŋwagá yuug nə *figyê nə bíl ílɨ́ɨ́ byɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ja məncuug mə́ agúgwáan mə́ ŋgə́ kɔ̧́ yí, ŋgaá bɨ mə́ dʉ mpu cínɔŋg nə́ ompú bwə́ mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ntɔ́ nə́mə́, ja bɨ́ mə́ bá dʉ́g ísâ byɔɔŋg í ŋgə́ sɨ̂y yí, mpugá nə́ Faan mə́ Zɛmbî í mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, kala búúd ga í ábʉ́lɛ́ cɔ̧́, isâ ínɨ byɛ̂sh kú fwo sɨ̂y. ");
INSERT INTO mcp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Gwɔ́w nə shí í bá cɔ̧́, njɨ iciyá byâm kú cɔ̧̂.» ");
INSERT INTO mcp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Bɨ ɔ́ bɛy nə́ milâm mí kə́g bá wamba bɨ́ mə́zaŋ nə iŋgulʉga nə zhwiimbyálə nə cʉg dɨ́ nə́ ndɛɛ́, jwɔ̂w dɔɔŋgʉ́ zə bá byalʉga nə bɨ́ ");
INSERT INTO mcp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","nda wód í dʉ byalʉga nə cúdú nə́. Nəcé jwɔ̂w dɔɔŋg í bá bii búúd ɔ shí mishwun ɔ́ga bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jigá ŋkasə́, bɨ́ dʉ jəgʉla nə Zɛmbî ja jɛ̂sh shú nə́ bɨ bâg faam ísâ byɔɔŋg byɛ̂sh dɨ́, bɨ mú bá kə wɔ́ɔ́s ótʉ́təlí mísh mə́ *Mwân mə Múúd dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yésus nyə á dʉ sá nə́, mwásə́ wɛ̂sh a ji *Luŋ mə́ Zɛmbî a ŋgə́ yə buud minjɨ́ɨ́gʉ́lá; mpwó-bulú, a kə mbʉ́mbʉ́ŋ á wəolivyê kə cɨ́ŋgʉli búlú wu. ");
INSERT INTO mcp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Buud bwə́ á ka dʉ zə nyə́dɨ́ cínɔŋg Luŋ ná kúndə́ mán zə dʉ gwágʉlə nyə. ");
INSERT INTO mcp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wəla lʉ *Páska í á ŋgə shísh. Páska nyə á bə zaŋ bwə́ á dʉ də ibʉlɛ́d yâ kú nə *ləvur yí. ");
INSERT INTO mcp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Milúlúú myâ ofada bə́nɔ̂ŋ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á ŋgə sɔ̧́ məzhɨɨ́ nə́ bwə́ gwú Yésus, bwə́ á ka ŋgə fúndə məŋkúmbə mə búúd. ");
INSERT INTO mcp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yúdas bwə́ á dʉ jɔ̂w nə dúl jínə́ nə́ Iskariyôt yɛ́, a njúl ŋgwɔ́l múúd á gwooŋg *ómpwíín wûm nə óbá, *Sátan mú nyíi nyə lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yúdas músə zə kə, kə lésha nə milúlúú myâ ofada bə́nɔ̂ŋ ojwû wâ buud bwə́ á dʉ baagʉlə *Luŋ mə́ Zɛmbî wá. A mú kə lwágʉlə bwo nda nyə é sá nə́ bwə́ bííg Yésus nə́. ");
INSERT INTO mcp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bwə́ mú gwág nywa, bə́nɔ́ŋ bwə́ mú bə cʉ́ŋ nə́ bwə́ é yə nyə *mwaanɛ̂. ");
INSERT INTO mcp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yúdas mú ka ŋgə sɔ̧́ fwámɛ́ fwála á jɨ́ nə ŋkul sá nə́ bwə́ bííg Yésus məŋkúmbə mə búúd kú mpu yí. ");
INSERT INTO mcp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jwɔ̂w lʉ́ zâŋ bwə́ dʉ tɛ́ɛ́d də́lə íbʉlɛ́d yâ kú nə *ləvur yí í mú ka wɔ́ɔ́s. Jwɔ̂w dɔɔŋgʉ́ wə́ bwə́ dʉ cígə ncwəmbɛ *Páska yí. ");
INSERT INTO mcp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yésus mú lwâm Pyɛ̂r bá Yuánɛs nə́: «Kagá kwísha sə́ dína Páska, sə́ bâg kə də.» ");
INSERT INTO mcp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bwə́ mú jí nyə nə́: «Wo ŋgə cɛɛl nə́ sə́ kə́g kwísha gwo ŋgow?» ");
INSERT INTO mcp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nyə nə bwo nə́: «Kagá, ja bɨ́ é nyíi ŋgwə́la yí, bɨ é bwəma nə ŋgwɔ́l múúd ŋgə́ ŋkɛ̂ny káágə́ mə́júwó; bɨ ɔ́ bɛ̧ múúd wɔɔŋgʉ̂ kə wɔ́ɔ́s njɔ́w nyə é nyíi yí. ");
INSERT INTO mcp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bɨ mú cɨ nə muud njɔ́w nə́: “Yɨ́ɨ́gʉli mə́ cɨ nə́ wo lwóg sə́ kʉ́l bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ é də dína Páska yí.” ");
INSERT INTO mcp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nyə e lwágʉlə bɨ́ fúm ánʉ́nɨ̂ njɔ́w á gwɔ́wʉ́d, í njúl kwambʉlá. Cínɔŋg wə́ bɨ́ é kwísha shé zaŋ Páska yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ompwíín bwə́ mú kə ŋgwə́la, bwə́ mú kə kwey ísâ nə́mə́ nda nyə á jaaw bwo nə́. Bwə́ mú kwísha dína Páska. ");
INSERT INTO mcp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ja wəla lʉ dína í á wɔ́ɔ́s yí, Yésus nyə á kə ji shí, bə́nɔ̂ŋ *buud ɔ lwámá bɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A mú cɨ nə bwo nə́: «Mə́ ámə bul jɨɨ nə́ sə́nɔ̂ŋ bɨ́ sə́ də́g *Páska ɛ́ga té mə́ afwóyɛ́ bwəma nə cúŋ yí. ");
INSERT INTO mcp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mə́ jaaw bɨ́ nə́ mə abʉ́lɛ́ ná kwo də ídʉ̂w i Páska kə wɔ́ɔ́s ja Zɛmbî mə bá fɛ́ɛ́g sɔ́ɔ́lʉ́gʉ́ á cínɔŋg nyə́dɨ́ Faan dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nə́ ndɛɛ́, a mú ŋwa bálá, a yə Zɛmbî akíba, a mú cɨ nə́: «Ŋwagá bálá mə́lwəg ga bɨ kááwʉlag mpə́dʉ́gá nyɨ́n. ");
INSERT INTO mcp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mə́ jaaw bɨ́ nə́, tɛ́ɛ́d kɨ́kɨdɨ́ga mə áŋgulɛɛ́ ná wáan nɨ; mə bá kwo ŋgul gwo njɨ ja Faan mə́ Zɛmbî í bá zə tɔ̂w yí.» ");
INSERT INTO mcp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nə́ ndɛɛ́ a mú ŋwa bʉlɛ́d, a yə Zɛmbî akíba nə́ ndɛɛ́, a mú fɛ̂y bʉlɛ́d, a yə ómpwíín, nyə nə bwo nə́: «Nyúúl nyâm í mə́ kaanz shú dʉ́n dɨ́ wə́ ga. Dʉgá sá sɔ́ɔ́lʉ́gʉ́ ga, dʉ tə́dʉgá mə.» ");
INSERT INTO mcp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nə́mə́ mbií ŋgwúdʉ́, ja bwə́ mə́ shîn də yí, a mú nə́mə́ ŋwa bálá wáan, yə bwo, nyə nə bwo nə́: «Bálá ga jísə sɔ̧ á gúgwáan í zə́ sɨ̂y mə́cií mâm dɨ́ yí. Nəcé məcií mâm mə́ zə́ shwɨy shí, zə cé bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Njɨ, dʉgá, muud nyə é kusha nə mə yɛ́ jɨ wa, sə́nɔ́ŋ ŋgə də. ");
INSERT INTO mcp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nəcé *Mwân mə Múúd mə zə́ kə nda cɛ̧ɛ̧lá mə́ Zɛmbî wɨ́ nə́. Njɨ məntágʉla nə múúd mə kɛ́ɛ́nzh nyə yɛ́!» ");
INSERT INTO mcp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bwə́ mú ŋgə sɛ́ŋʉsa məkə̂l bwə́mɛ́ nə bwə́mɛ́, ŋgə́ jí nə́ zə́ nyə e sá sɔ́ɔ́lʉ́gʉ́ wɔɔŋgʉ̂ na mpə́dʉ́gá nyáŋʉ́d? ");
INSERT INTO mcp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","*Buud ɔ lwámá bwə́ á sɛ́ŋʉsa məkə̂l nə́ bwə́ cɛɛl mpu nyɔɔŋg jɨ́ bul bə fwámɛ́ múúd bwə́dɨ́ gwooŋg dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yésus mú cɨ nə bwo nə́: «Micî myâ ikûl ishús mí ŋgə ntɛɛŋg ijwûga byáŋ; buud ɔ mpə̂l bwə́ ŋgə yida jɨɨ nə́ buud bwə́ ŋwág bwo nə́ ijɔ̧ɔ̧́ i búud. ");
INSERT INTO mcp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Í ajə́láyɛ́ nə bə ntɔ́ bɨ́ bâŋ dɨ́. Nyɔɔŋg yɛ̂sh mə cɛ́ɛ́l bul bə fwó múúd gwooŋg jɨ́n dɨ́ yɛ́, yídag bə nda nyə wə́ mə́ búl bə mwántombú; nyɔɔŋg mə tɔ́w bɨ́ shwóg yɛ́ sɛ́yʉ́g nə bɔ́ɔ́lʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mpə́dʉ́gá muud njúl shí ŋgə́ də yɛ́ nə nyɔɔŋg ŋgə́ sɛ̂y nə nyə yɛ́, zə́ jɨ́ fwámɛ́ múúd? Ŋgaá nə́ nyɔɔŋg njúl shí ŋgə́ də yɛ́? Njɨ, mɛɛ mə́ yidá ŋwa jiya sɔ́ɔl məsáal mpə́dʉ́gá nyɨ́nʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Bɨ báá, bɨ́ mə́ kyey nə mə zə wɔ́ɔ́s wəla lʉ́ mə́kʉgʉlʉ dâm dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nə́ ndɛɛ́ mə jɨ nə ŋkul yə bɨ́ Faan mə́ Zɛmbî nda Dâ nyə á yə mə dwo nə́. ");
INSERT INTO mcp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mə jɨ nə ŋkul sá ntɔ́ shú nə́ bɨ bâg də nə ŋgul mə́dɨ́ tʉ́wʉli dɨ́ ja mə́ bá bə mə́dɨ́ Faan dɨ́ yí, bɨ́ ji nə́mə́ ícaaŋgə́d sámb íbɛɛnd wûm nə íbá yâ *Izʉrəyɛ̂l milə́sʉ́.» ");
INSERT INTO mcp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yésus mú cɨ nə Pyɛ̂r nə́: «Shímun, Shímun, *Sátan mə́ gwáámb ŋkûl nə́ a zə́ fyá bɨ́ nə məbwə́bʉ́lán nda múdá mə́ dʉ fyá mə́wúdə nə́. ");
INSERT INTO mcp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Njɨ mɛɛ mə ámə jəgʉla shú dwô dɨ́ nə́ búgə́ gwô í bə́g kú tag. Nə́ ndɛɛ́, wo ɔ bá ka lʉlʉshi ómínyɔŋʉ̂ bwô ja wó é bá cɛ́nd kuú njɔɔnd yí.» ");
INSERT INTO mcp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pyɛ̂r mú cɨ nə nyə nə́: «Cwámba, mə jɨ kwééshá nə́ tɔɔ mímbwug shwə́ kə, tɔɔ shwɨy shwə́ bɛ̂sh yə.» ");
INSERT INTO mcp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yésus mú cɨ nə nyə nə́: «Pyɛ̂r, mə́ jaaw wo nə́ shúshwóógʉ́ nə́ ŋgwúm kúwó kwáágʉ́g wo e kɨ́ɨ́lya ija ilɔ́ɔl nə́ wo ampúyɛ́ mə.» ");
INSERT INTO mcp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","A mú cɨ nə bwo nə́: «Ja mə́ á lwâm bɨ́ kú nə *mwaanɛ̂, kú nə məkwáám, kú nə osílʉ́faas yí, jɨ́ í á fúfə bɨ̂?» Bwə́ nə́: «Kú nə sâ.» ");
INSERT INTO mcp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A mú cɨ nə bwo nə́: «Í zə́ yidá bə ja ga dɨ́ nə́, ŋkí muud jɨ nə mwaanɛ̂, a ŋwa; ŋkí muud jɨ nə kwáám, a ŋwa; muud cúgɛ́ nə kafwɛlɛ yɛ́ kusha kúúd jé, kusə kafwɛlɛ. ");
INSERT INTO mcp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nəcé mə́ jaaw bɨ́ nə́ micilyá míga mí jəlá nə bwəma cʉg jâm dɨ̂. Micilyá mí nə́: “Bwə́ á sɛɛŋg bə́nɔ̂ŋ izhilʉŋgaanə́.” Ntɔ́ jɨ nə́, sâ í dʉ́gyá nə mə yí í jəlá nə sɨ̂y nda í jɨ́ nə́.» ");
INSERT INTO mcp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bwə́ mú cɨ nə nyə nə́: «Cwámba, dʉgɨ́ ikafwɛlɛ íbá wa.» Nyə nə bwo nə́: «Bímbí nɨ í jəla.» ");
INSERT INTO mcp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A mú cúwo tɔ́ɔ́n, kə *Mbʉ́ŋ wə́olivyê nda nyə á dʉ bwey sá nə́. *Ompwíín bɛ́ bwə́ mú bɛ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ja bwə́ mə́ kə wɔ́ɔ́s kʉ́kʉ́l jɔɔŋg dɨ́ yí, Yésus mú cɨ nə *ompwíín nə́: «Jəgʉlagá nə Zɛmbî, bɨ bə́g kú biil mə́bwə́bʉ́lánʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nyɛ, a músə nywá shísh shwóg-shwóg nə bwo, cé bɔ̧ɔ̧lə́ dɨ́ nə ŋkul shúg yí. A mú kúd mə́bwóŋ shí, tɛ́ɛ́d ŋgə́lə jəgʉla nə Zɛmbî, ");
INSERT INTO mcp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","nyə nə́: «Pʉpa, ŋkí wó cɛɛl, yílʉ́g mə bálá mə́cɛy ga! Njɨ, kú bə nda mə́ jɨ́ nə́, í sɨ́yʉ́g nda wó cɛ́ɛl nə́.» ");
INSERT INTO mcp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nə́ ndɛɛ́, ŋgwɔ́l *éŋgəles mú wɔ́ɔ́s zhúlə gwɔ̂w, zə ŋgə lʉlʉshi nyə. ");
INSERT INTO mcp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ifwaas í shwɨy í mú bul bií nyə, a mú bul nyiŋgə jəgʉla nə Zɛmbî, gúŋ í mú dʉ wú nyə nyúúlʉ́d nda ibʉbɔl í mə́cií dʉ kud shí. ");
INSERT INTO mcp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A músə yɔw jəgʉlálə, a bʉ̂n zə kɔ́ɔ́mb ómpwíín bwə́ á bə yí. A mú zə kwey nə́ məcɛy mə lâm mə́ mə́ kənd bwo ígwə́d. ");
INSERT INTO mcp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A mú cɨ nə bwo nə́: «Nə́ jɨ! Bɨ́ ŋgə já? Wɔɔlʉgá, bɨ jə́gʉlag, bɨ bə́g kú biil mə́bwə́bʉ́lánʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yésus ŋgə́ ná lás ntʉ́nɨ, seegya nə́ məma kínda búúd mə́ cúwo, Yúdas tə́l bwo shwóg. Yúdas nyə á bə nə́mə́ muud á gwooŋg *búúd ɔ lwámá wûm nə óbá yɛ́ mú shísh wə́ Yésus, zə fʉ́lalʉ́ nyə. ");
INSERT INTO mcp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yésus mú cɨ nə nyə nə́: «Yúdas, ntɔ́ nə́ wo zə́ kusha nə *Mwân mə Múúd mə́fʉ́lʉla dɨ́?» ");
INSERT INTO mcp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ja búúd bə́nɔ̂ŋ Yésus bwə́ á bə gwooŋg wá bwə́ á dʉ́g sá í á ŋgə sɨ̂y jɔɔŋg yí, bwə́ á jí nyə nə́: «Cwámba, ye sə́ gwánág nə ikafwɛlɛ?» ");
INSERT INTO mcp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ŋgwɔ́l mú wéem kafwɛlɛ jé, taad ŋgwɔ́l sɔ́ɔl məsáal mə Ajəlácɨ á ofada, í mú sámb nyə lwə́ á mbwə́ məncwûm. ");
INSERT INTO mcp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yésus mú cɨ nə́: «Yɔwʉgá ntʉ́nɨ». A mú kúnya nə muud ɛ́nɛ lwə̂, í mú yâl. ");
INSERT INTO mcp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yésus mú lás nə milúlúú myâ ofada bə́nɔ̂ŋ ojwû wâ buud bwə́ á dʉ baagʉlə *Luŋ mə́ Zɛmbî wá nə ocúmbá buud, nyə nə́: «Bɨ́ ŋgə zə nə ikafwɛlɛ nə məbʉ́lə zə́lə bií mə, mə jisə zhilʉŋgaanə́? ");
INSERT INTO mcp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ŋgaá nə́ shé á dʉ bə jwɔ̂w dɛ̂sh kʉ́l ŋgwúd Luŋ mə́ Zɛmbî dɨ̂, bɨ kú sɛ́ɛ́mb mbwə̂ nə́ bɨ mə́ bií mə. Njɨ, wəla dʉ́n wə́ mə́ wɔ́ɔ́s ga, wəla mə *Sátan muud mə́ dʉ kuŋg mə́yídʉ́gʉ́d yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bwə́ mú bií nyə, kə nə nyə nə́ ndɛɛ́ kə nyíi njɔ́w mə́ Ajəlácɨ á ofada. Í á bə, Pyɛ̂r ŋgə́ bɛ̧ bwo nə fwámɛ́ cé. ");
INSERT INTO mcp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bwə́ á ka jida kuda tâm mbaadə́ bwə́ mú sɛɛŋgya zə ji shí; Pyɛ̂r mú nə́mə́ zə ji cínɔŋg bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dúl sás í á dʉ sɛ̂y nə Ajəlácɨ á ofada yí í mú dʉ́g nyə na mə́ŋkɛnya mə́ kudad. Sás dɔɔŋg mú mpu shimal dʉ́g nə́ ndɛɛ́ a mú cɨ nə́: «Muud ɛ́ga nyə á bə nə́mə́ gwooŋg mə Yésus dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pyɛ̂r mú kɨ́ɨ́lya nyə, nyə nə́: «Amuda, mə ampúyɛ́ múúd ɛ́nɛ.» ");
INSERT INTO mcp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Fúfwálá mú cɔ̧́, ŋgwɔ́l múúd mú nyiŋgə cɨ nə Pyɛ̂r nə́: «Wo jɨ nə́mə́ ŋgwɔ́l múúd wáŋ.» Pyɛ̂r nə nɛ́ nə́: «Muud ɛ́ga, kú bə mə.» ");
INSERT INTO mcp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fwála mə́ cɔ̧́ je bə wəla ŋgwúd ntʉ́nɨ, ŋgwɔ́l múúd mú nyiŋgə zə báásʉlə nə́: «Jɨ́ ntɔ́, muud ɛ́ga bə́nɔ̂ŋ Yésus wə́ bwə́ á bə. Ŋgaá a jɨ nə́mə́ muud á Galilê?» ");
INSERT INTO mcp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pyɛ̂r mú cɨ nə́: «Mə ampúyɛ́ sâ wó ŋgə́ cɨ yí.» Pyɛ̂r ŋgə́ ná lás ntʉ́nɨ, ŋgwúm kúwó mú kwáág. ");
INSERT INTO mcp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Cwámba mú yid dʉ́g Pyɛ̂r nə́ shi shi shi. Pyɛ̂r mú tə́dʉga ciyá Yésus nyə ámə cɨ nə nyə yí nə́: «Shúshwóógʉ́ nə́ ŋgwúm kúwó kwáágʉ́g múús ɨɨ́, wo e kɨ́ɨ́lya mə ija ilɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pyɛ̂r mú cúwo tɔ́ɔ́n kə dʉ nyɛ̂sh nə yə̂. ");
INSERT INTO mcp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Buud bwə́ á bə bwə́ mbíd Yésus wá bwə́ á ŋgə cágʉlə Yésus, bwə́ ŋgə́ yíd nyə. ");
INSERT INTO mcp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bwə́ á cɛ̧ɛ̧lə nyə sâ míshʉ́d ka ŋgə cɨ nə nyə nə́: «Lwóg nə́ wo jɨ *muud micúndə́, jaawʉg sə́ muud nyə ámə yíd wo yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bwə́ mú ŋgə jág lás nə nyə bíl íciyá í mə́lwíy. ");
INSERT INTO mcp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mán mələ̂m, gúfʉ́gá ócúmbá wâ kúl búúd, nə milúlúú myâ ofada nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á sɛɛŋgya. Bwə́ mú zə nə Yésus bwə́dɨ́ *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bwə́ mú cɨ nə nyə nə́: «Ŋkí wo jisə *Krîst, jaawʉgʉ́ sə̂». Nyə nə bwo nə́: «Mə tɛɛm jaaw bɨ́, bɨ ámagʉləyɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mə jí nə́mə́ bɨ́ njígá na, bɨ ábɛ̧sayɛ́ mə. ");
INSERT INTO mcp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Njɨ, tɛ́ɛ́d kɨ́kɨdɨ́ga, *Mwân mə Múúd nyə é kə ji shí mbwə̂ məncwûm mə́ Zɛmbî á ŋkul nyɛ̂sh dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bɛ̂sh ntâg nə́: «Ntɔ́ jɨ nə́ wo jɨ *Mwân mə́ Zɛmbî?» Nyə nə bwo nə́: «Bɨmɛ́fwó bɨ́ ŋgə cɨ ntɔ́, mə jisə nyə.» ");
INSERT INTO mcp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bwə́ mú ntâg cɨ nə́: «Jɨ́ shé mə́ kwo sɔ̧́ owúshinɛd yí? Sə́mɛ́fwó mə́ gwág á mə́ lás.» ");
INSERT INTO mcp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Gúfʉ́gá búúd jɛ̂sh mú tɔ̂w kyey kə nə Yésus wə́ Pilât. ");
INSERT INTO mcp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kə wɔ́ɔ́s nûŋ, bwə́ mú ŋgə búgə nyə lə́sʉ́ nə́: «Sə́ ámə kwey múúd ɛ́ga ŋgə́ sá nə lwoŋ búúd jísʉ́ mitə́dʉ́gá mí ŋgə́g nə búbulə mílúúd, a ŋgə́ cɨ nə́ nyə wə́ jísə́ Mesî, Njwú-buud; a ŋgə́ sá nə́ bwə́ kú jə́na *Káázɛl tóya.» ");
INSERT INTO mcp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilât mú jí nyə nə́: «Ye wo jisə Njwû *Oyúdɛn?» Yésus mú bɛ̧sa nə́: «Wo mə́ cɨ ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilât mú cɨ nə milúlúú myâ ofada nə məŋkúmbə mə búúd nə́: «Mə akwéyɛ́ nə́ muud ɛ́ga mə́ shwey wôŋ.» ");
INSERT INTO mcp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bwə́ mú cɨ nə nyə nə́: «A ŋgə shwambʉlə kúl búúd jísʉ́. A mə́ ŋgə yə bwo minjɨ́ɨ́gʉ́lá wú Galilê, wɔ́ɔ́s Yudéa zə kumə wa.» ");
INSERT INTO mcp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ja Pilât mə́ gwág ntʉ́nɨ yí, a mú jí ŋkí Yésus jɨ muud á Galilê. ");
INSERT INTO mcp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nda nyə á mpu nə́ Yésus jɨ muud á faan lʉ́ íjwûga mə́ Herod nə́, nyə á cɨ nə bwo nə́ bwə́ kə́g nə nyə wə́ Herod. Í á bə Herod njúl Yurʉ́səlɛm mwɔ̂w mɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod nyə á bul bə nə məshusʉg ja nyə á dʉ́g Yésus yí. Nəcé bwey nyə á dʉ bwey sɔ̧́ nə́ a dʉ́g nyə nə isâ nyə á dʉ gwág shú dɛ́ dɨ́ yí. Nyə á ŋgə bwánd nə búgə́ nə́ Yésus nyə e sá dúl *shimbá a mú dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A mú jí Yésus zhwog minjígá, njɨ Yésus kú bɛ̧sa. ");
INSERT INTO mcp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Milúlúú myâ ofada bə́nɔ̂ŋ *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á bə cínɔŋgʉ́ bwə́ ŋgə́ búgə Yésus milə́sʉ́ nə ŋkʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod bə́nɔ̂ŋ ifulísh byé bwə́ ŋgə́ ŋwa nyə mpyóŋ nə mpyóŋ, ŋgə cágʉlə nyə. Bwə́ mú bwééd nyə jɔ̧jɔ̧ jud nə́ ndɛɛ́ nyiŋg nyə nə́ bwə́ kə́g nə nyə wə́ Pilât. ");
INSERT INTO mcp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod bá Pilât buud bwə́ á dʉ bə nə ifʉmʉga wá, bwə́ mú cɛ̧ɛ̧ shwə́ jwɔ̂w dɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilât mú sɛɛŋg mílúlúú myâ ofada, nə micî nə buud bɛ̂sh, ");
INSERT INTO mcp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a mú cɨ nə bwo nə́: «Bɨ́ ámə zə nə muud ɛ́ga mə́dɨ́ nə́ a ŋgə shwúgʉli kúl búúd jɨ́n. Ká dʉgá, mə mə́ jí nyə minjígá bɨ ŋgə́ gwág. Mɛɛ mə́ kwey nə́ a cugɛ́ nə tɔɔ wôŋ ísâ byɛ̂sh bɨ́ ŋgə́ cɛɛl bwaagʉlə nyə yííd. ");
INSERT INTO mcp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod mə́ kwey nə́mə́ nə́ a cugɛ́ nə məbyaagʉlə, gwə́ wə́ á mə́ nyiŋgə ntɨ sə́ nyə yí. Ntɔ́ jɨ nə́ muud ɛ́ga nyə asáyɛ́ gúl sâ shwɨy. ");
INSERT INTO mcp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mə zə́ yə nyə intʉ́gʉ́lí nə́ ndɛɛ́ mə bɨ́d nyə.» ");
INSERT INTO mcp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilât nyə á dʉ bə nə fúlú nə́ zaŋ *Páska í ká bə, a bɨ́d búúd wúl mbwug. ");
INSERT INTO mcp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bɛ̂sh bwə́ mú kɨ̂m ja ŋgwúd nə́: «Gwúg nyə. Yidag bɨ́d sə́ Barábas.» ");
INSERT INTO mcp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barábas wɔɔŋgʉ̂ nyə á kə mímbwug dɨ́ nəcé bwə́ á sá nə́ buud bwə́ sáág miŋgáádə́ nə ijwû, bwə́ gwú nə́mə́ múúd. ");
INSERT INTO mcp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilât mú kwo lésha nə buud bwə́ á ŋgə shwə́man Yésus wá gúl ja nə́, nywáá mə́ cɛɛl bɨ́d nyə. ");
INSERT INTO mcp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bwə́ mú kɨ̂m nə́: «Bwambʉləg nyə kwolós dɨ̂, bwambʉləg nyə kwolós dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilât mú nyiŋgə cɨ nə bwo ja álɛ́ɛl nə́: «Dáyɛ́ bɔ̂w á mə́ sá yí? Mə akwéyɛ́ nə́ a mə́ shwey wôŋ í jə́lá nə shwɨy yí. Mə zə́ sá nə bwə́ fyámʉ́sə́g nyə milwóŋ nə́ ndɛɛ́ mə bɨ́d nyə.» ");
INSERT INTO mcp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bwə́ mú nyiŋgə kɨ̂m nə́ a bwámbʉləg Yésus kwolós dɨ̂, oŋkwiimbyê ŋgə yáág yáágʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilât mú ŋwa cígʉ́lá nə́ a zə́ sá sâ bwə́ ŋgə́ jɨɨ yí. ");
INSERT INTO mcp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A mú bɨ́d múúd bwə́ á ŋgə gwáámb yɛ́, muud nyə á kə mímbwug dɨ́ nəcé ciŋʉ́-cində̂ nə məgwú mə múúd yɛ́; a mú yə bwo Yésus nə́ bwə́ kə́g sá nyə nda bwə́ dʉ́g nə́. ");
INSERT INTO mcp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ja bwə́ á ka ŋgə kə nə Yésus yí, bwə́ á bii Shímun á Sirɛ̂n ŋgə́ wú ífambə́, bwə́ mú zhimb nyə kwolós nə́ a ŋkɛ́nyʉ́g, ŋgə bɛ̧ Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zhwog buud wâ kúl búúd, nə budá bwə́ á ŋgə bɛ̧, bwə́ ŋgə́ *bí məbwə̂ íbʉd dɨ́, bwə́ ŋgə́ tədʉwa. ");
INSERT INTO mcp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yésus mú yid dʉ́g búdá bɔɔŋgʉ́, a mú cɨ nə bwo nə́: «Kúgá jɨɨ́ mə, jɨɨgá bɨmɛ́fwó nə bwân bʉ́n, ");
INSERT INTO mcp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","nəcé í bá wɔ́ɔ́s nə́ buud bwə́ bá cɨ nə́: “Mikundú mí búdá myá mí mə́ jəla, bá buud bwə́ abwɛ́lɛ́ ŋwa mə́bum, kú bwɛlɛ nyɛ́ɛ́ŋg bwân wá.” Mwɔ̂w búúd bwə́ bá lás ntɔ́ má mə́ ŋgə zə. ");
INSERT INTO mcp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nə́ ndɛɛ́ bwə́ bá cɨ nə mimbʉ́ŋ nə́: “Kádágá sə̂,” bwə́ nə iŋkwúndʉ́gʉ́ nə́: “Shweelʉgá sə̂.” ");
INSERT INTO mcp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ŋkə́mʉ́sá ná bwə́ fwó sá lɨ́ɨ́ á bʉ́s nda bwə́ ŋgə́ sá ga, jâŋ í bá bə nə fumbə ntʉdɛlɛ̂?» ");
INSERT INTO mcp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ja bwə́ á ŋgə kə nə Yésus yí, bwə́ á ŋgə nə́mə́ kə nə míl mímbʉ́wʉ́lú mí búúd mímbá nə́ bwə́ kə́ gwú bə́nɔ́ŋ. ");
INSERT INTO mcp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ja bwə́ mə́ kə wɔ́ɔ́s kʉ́l bwə́ dʉ jɔ̂w nə́ «Bwundú lúú» yí, bwə́ mú bwambʉlə Yésus kwolós dɨ̂, bə́nɔ̂ŋ mimbʉ́wʉ́lú mí búúd mímbá myɔɔŋg, nyíga jé kwolós dɨ́ Yésus mbwə̂ məncwûm, nyíga jéd nyə́dɨ́ mbwə̂ məkɔ́ɔ́l. ");
INSERT INTO mcp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nə́ ndɛɛ́ Yésus mú lás nə́: «Pʉpa, juug bwo, nəcé bwə́ ampúyɛ́ sâ bwə́ ŋgə́ sá yí.» Bwə́ mú wusə mpaambə́ shú kaawʉ́lə míkáándə́ mí Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zhwog buud bwə́ á bə bwə́ tə́l dʉ dʉ́g. Micî mí mú ŋgə cágʉlə Yésus, ŋgə́ cɨ nə́: «Nyə á dʉ dɨ́ cʉgʉshi buud ɨɨ́, a cʉ́gʉg nyəmɛ́fwó, ŋkí a jɨ *Krîst, muud Zɛmbî nyə a fɛ́ɛ́sh yɛ́». ");
INSERT INTO mcp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ozɨmbɨ bwə́ á ŋgə nə́mə́ cágʉlə nyə; bwə́ mú shísh nyə́dɨ́ kə yə nyə məlwəg mə́ ábibyɛnzhʉ̂. ");
INSERT INTO mcp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bwə́ nə́: «Ŋkí wo jɨ Njwû *Oyúdɛn, cʉgʉg wómɛ́fwó.» ");
INSERT INTO mcp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bwə́ á cilə cilyá, bwambʉlə nyə wə ŋgɛɛ lúúd gwɔ́w nə́ «Njwû Oyúdɛn wə́ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wúl mbʉ́wʉ́lú í á bə nə́mə́ jé kwolós dɨ́ yí mú jág lás nə nyə nə́: «Ŋgaá wo wə́ jɨ́ Krîst? Cʉgʉgʉ́ wómɛ́fwó wo ka nə́mə́ cʉg sə̂.» ");
INSERT INTO mcp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wúl mbʉ́wʉ́lú mú fɛɛl, jum nyə nə́: «O! Wo jɨ nə́mə́ íntʉ́gʉ́líd nda nyə, wo ka bə kú fúndə Zɛmbî? ");
INSERT INTO mcp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Shwə́ bâŋ mə jəla nə intʉ́gʉ́lí íga, nəcé shwə́ a sá nə́mə́ ísâ í jə́lá nə́ shwə́ bə́g nə intʉ́gʉ́lí yí. Ká nyɛ, nyə abwɛ́lɛ́ sá sâ abʉ́bɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A mú cɨ nə Yésus nə́: «Yésus, wo ɔ bá tə́dʉgá mə ja wó bá zə nə ijwûga byô yí.» ");
INSERT INTO mcp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yésus mú cɨ nə nyə nə́: «Bʉ́bə́lɛ́, mə́ jaaw wo nə́, shwə́ é bə múús *Paradis.» ");
INSERT INTO mcp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jwɔ̂w í á bə í mú ŋgɛɛ tɔ́lɔ́g dɨ́, yídʉ́gʉ́ í á shila shí nyɛ̂sh nə́ ŋkwed kə wɔ́ɔ́s mə́wəla məlɔ́ɔl mâ mpwó-kugʉ́, ");
INSERT INTO mcp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","jwɔ̂w í mə́ shwaaw, *sanda í á dʉ kalʉwo *Mpáánzə́ Zɛmbî yí í mú sɛɛl tʉ́tám nə́ cáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yésus mú kɨ̂m gwɔ́w-gwɔ̂w nə́: «Pʉpa, mə mə́ kɛɛl *jîm jâm wódɨ́ mə́bwə́d.» Nə́ ndɛɛ́ a mú jímal. ");
INSERT INTO mcp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ja lúlúú ízɨmbɨ mə́ dʉ́g ísâ í á ŋgə sɨ̂y yí, a mú yə Zɛmbî gúmə́, nyə nə́: «Bʉ́bə́lɛ́, muud ɛ́ga nyə á bə tʉ́təlí muud.» ");
INSERT INTO mcp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Buud bɛ̂sh bwə́ á ŋgə zə nə mikʉ́lə́ áncuncuma nə́ bwə́ zə́ dʉ́g lugə-lugə sâ wá, ja bwə́ mə́ dʉ́g ísâ í á ŋgə sɨ̂y yí, bwə́ mú ŋgə nyiŋgə bwə́ ŋgə́ *bí məbwə̂ íbʉd dɨ́ nə məcɛy mə lâm. ");
INSERT INTO mcp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Buud bɛ̂sh bə́nɔ̂ŋ Yésus bwə́ á bə nə wɔ́ŋgɔ́ wá nə budá bə́nɔ́ŋ bwə́ á ŋgə kyey té wúlə Galilê wá bwə́ á bə bwə́ tə́l shwóg-shwóg ka dʉ dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nə́ ndɛɛ́, ŋgwɔ́l múúd nə jínə́ nə́ Yósɛb mú zə wɔ́ɔ́s, a njúl tʉ́təlí muud nə jɔ̧jɔ̧ lâm, a njúl nə́mə́ muud á gwooŋg mílúlúú myâ lɔɔm. ");
INSERT INTO mcp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nyə á bə muud Arimatê, nyə a shígɛ́ bə cʉ́ŋ nə cígʉ́lá bwə́ á ŋwa yí nə sâ jɛ̂sh bwə́ á ŋgə sá yí. Nywáá nyə á ŋgə ji a ŋgə́ bwánd Faan mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nyə á ka kə wə́ Pilât, kə gwáámb nyə mbimbə mə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A mú shul yîl mbimbə kwolós dɨ́, a fʉ́lə wə ndómbó dɨ́ nə́ ndɛɛ́ kə wá nyúl shwoŋ bwə́ á bwagʉlə kwóógʉ́d yí, í njúl bwə́ nda fwo bwɛlɛ bwɨ́ɨ́g wúl mbimbə cínɔŋg cwû. ");
INSERT INTO mcp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jwɔ̂w dɔɔŋg í á bə ntâg jwɔ́w bwə́ dʉ́ kwəmʉsa Sábaad yí, kwəmʉsálə wɔɔŋg í á shí nə́mə́ tɛ́ɛ́d. ");
INSERT INTO mcp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Budá bə́nɔ̂ŋ Yésus bwə́ á dʉ ŋgə kyey té wúlə Galilê wá bwə́ á ŋgə bɛ̧ Yósɛb kə wɔ́ɔ́s shwoŋ dɨ̂, kə dʉ́g nda nyə á wá mbimbə mə́ Yésus cínɔŋg nə́. ");
INSERT INTO mcp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bwə́ mú nyiŋgə, bwə́ kə kwəmʉsa ísâ í ámpə-məcud nə olabínda. Bwə́ mú woga jwɔ̂w lʉ́ Sábaad nda cɛ̧ɛ̧ í á ŋgə cɨ nə́. ");
INSERT INTO mcp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jwɔ̂w shwɛ́ndɛ mə́ dʉ́ tɛ́ɛ́d yí, ná nə́mə́ mpʉ́mán mpʉ́mán, bwə́ á ká zə kə nə olabínda bwə́ á kwəmʉsa wá shwoŋ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bwə́ mú kə kwey nə́ məma kwóógʉ́ í ámə dʉ juwal shwoŋ yí í músə í mbwúg koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bwə́ mú nyíi shwoŋ dɨ́, njɨ, bwə́ kú kwey mbimbə mə Cwámba Yésus. ");
INSERT INTO mcp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Í mú zə bə, bwə́ ŋgə́ nâ ntɨ́ya, seegya njɨ buud obá bwə́ mú bwə́ tə́l bwo na kúnə́-kúnə, bwə́ njúl nə mikáándə́ mí ŋgə́ ŋkənʉwa. ");
INSERT INTO mcp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Iŋkuŋkúúnd í mú shwɨy búdá nyúúlʉ́d, bwə́ mú kúd mə́mpwoombʉ́ shí. Buud obá bɔɔŋg bwə́ mú cɨ nə bwo nə́: «Nəcé jɨ́ bɨ́ mə́ zə́ sɔ̧́ múúd ŋgə́ cʉgə yɛ́ mímbimbə dɨ́ yí? ");
INSERT INTO mcp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A cugɛ́ wa, a mə́ gwûm. Tə́dʉ́gágá nda nyə á lás nə bɨ́ bɨnɔ́ŋ njúl Galilê nə́. ");
INSERT INTO mcp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ŋgaá nyə á cɨ nə́ í jɨɨ nə́ *Mwân mə Múúd káánzʉg məbwə̂ mə́ búúd ɔ *mísə́mʉ́d, bwə́ bwambʉlə nyə kwolós dɨ́ nə́ ndɛɛ́ a mú gwûm jwɔ̂w álɛ́ɛl.» ");
INSERT INTO mcp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Budá bwə́ mú nyiŋgə tə́dʉga lə́sʉ́ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nə́ ndɛɛ́ bwə́ mú wú shwoŋ dɨ́ kə bwiiŋg *búúd ɔ lwámá wûm nə ŋgwúd isâ ínɨ byɛ̂sh, bwə́ bwiiŋg nə́mə́ bɔ́ɔ́l *ómpwíín bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Í á bə, nə Maríya á Magʉdála, nə Yuána, nə Maríya nyɔɔŋgʉ́ mə Zhâk, nə bɔ́ɔ́lʉ́gá bə́nɔ̂ŋ bwə́ á bə wá. Bwə́ á ŋgə bwiiŋg buud ɔ lwámá isâ byɔɔŋg, ");
INSERT INTO mcp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","njɨ buud ɔ lwámá bwə́ á ŋgə ŋwa bwo nda buud bwə́ ŋgə́ cɨ isâ bísə́ kú nə wúmbʉ́lé yí, bwə́ áshígɛ́ magʉlə lâŋ wáŋ. ");
INSERT INTO mcp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Njɨ, Pyɛ̂r mú tɔ̂w, a mú kə nə kʉ́lə́ shwoŋ dɨ̂. A mú bɔ̧ɔ̧lə, a mú dʉ́g njɨ obándáshi bwə́ á dʉl Yésus nə ndɨ́ wá. A mú nyiŋgə kə njɔ́w a ŋgə́ káam sâ í ámə sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Í á bə nə́, jwɔ̂w ŋgwúd dɔɔŋgʉ́, *ompwíín ɔ́ Yésus obá bwə́ á ŋgə kə də́nd bwə́ á dʉ jɔ̂w nə́ Imawus yí. Wúlə Yurʉ́səlɛm kə wu í á jee bə okílomáda wûm nə óbá. ");
INSERT INTO mcp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bwə́ á ŋgə kə bwə́ ŋgə́ lésha mpə́dʉ́gá nyáŋ, ŋgə bwiiŋg isâ byɛ̂sh í á sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Í mú kə wɔ́ɔ́s nə́, bwə́ ŋgə́ kə ntʉ́nɨ bwə́ ŋgə́ lésha ŋgə faas ɨɨ́, Yésus nyəmɛ́fwó mú zə kwey bwo, bə́nɔ́ŋ bwə́ mú ŋgə kə. ");
INSERT INTO mcp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Njɨ mísh máŋ mə́ á bə nda gúl sâ í á ŋgə ntágʉlə, bwə́ áshígɛ́ yag nyə. ");
INSERT INTO mcp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A mú cɨ nə bwo nə́: «Myáyɛ́ míláŋ bɨ́ ŋgə́ zə bwiiŋgya zhɨ́ɨ́ nə zhɨɨ́ míga?» Bwə́ mú shigʉla, bwə́ ŋgə́ nyîn nda bwə́ mə́ shúsʉla nə zhwuŋʉ́. ");
INSERT INTO mcp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nyɔɔŋg nyə á bə nə jínə́ nə́ Kleyopas yɛ́ mú bɛ̧sa nə́: «Njɨ wo wə́ jɨ́ nə́ wo njúl Yurʉ́səlɛm wo kú mpu ísâ í mə́ sɨ̂y mwɔ̂w mə́ga dɨ́ yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A mú jí bwo nə́: «Byáyɛ́ ísâ?» Bwə́ nə́ nyə nə́: «Isâ í dʉ́gyá nə Yésus á Nazarɛ̂t yí! Muud nyə á bə *muud micúndə́ yɛ́, misɔ́ɔ́lʉ́gʉ́ myɛ́ nə iciyá byé í dʉ́gə́ bə ŋkí lal ŋkûl mísh mə́ Zɛmbî nə mísh mə́ búúd bɛ̂sh dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wo afwóyɛ́ gwág nda milúlúú myâ ofada nə otɔ́we ɔ shwóg bʉ́sʉ́ bwə́ á kusha nə nyə nə́ a yə́g, bwə́ bwambʉlə nyə kwolós dɨ́ nə́? ");
INSERT INTO mcp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sə́ á ŋgə bwánd nə búgə́ nə́ nyə wə́ nyə é zə yîl *Izʉrəyɛ̂l mə́nyámád. Njɨ í áshígɛ́ ná bə ntɔ́. Múús jɨ jwɔ̂w álɛ́ɛl bwə́ shínʉ́lə sá isâ byɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Í mə́ mɛɛl nyiŋgə bə, bɔ́ɔ́l búdá wâ sə́dɨ́ gwooŋg bwə́ mə́ zə ntágʉlə sə́ milúu, nə́ bwə́ ámə kə shwoŋ dɨ́ mpʉ́mán mpʉ́mán, ");
INSERT INTO mcp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bwə́ shígɛ́ kwey mbimbə yé cínɔŋg; bwə́ mú zə jaaw nə́ bwə́ ámə dʉ́g *wəéŋgəles, wəéŋgəles bɔɔŋg bwə́ mú jaaw bwo nə́ Yésus ŋgə cʉgə. ");
INSERT INTO mcp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bɔ́ɔ́l búúd ɔ́ gwooŋg jísʉ́ bwə́ shí nə́mə́ kə shwoŋ dɨ́, bwə́ kə kwey ísâ nda búdá bwə́ ámə jaaw nə́; njɨ nyɛ, bwə́ shígɛ́ dʉ́g nyə.» ");
INSERT INTO mcp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nyɛ mú ka zə lás nə bwo nə́: «A bɨ mə́ bə nə shúg e! A bɨ́ caálə *magʉlə nə́ isâ búúd ɔ mícúndə́ bwə́ á cɨ yí bísə́ bʉ́bə́lɛ́ e! ");
INSERT INTO mcp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ŋgaá nə́ í á jɨɨ nə́ *Krîst júgʉg ntʉ́nɨ nə́ ndɛɛ́ a mú nyiŋgə ŋwa gúmə́ jé?» ");
INSERT INTO mcp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A mú ka zə sá nə́ bwə́ mpúg isâ í dʉ́gyá nə nyə yí, nda Kálaad Zɛmbî ŋgə́ cɨ nə́, tɛ́ɛ́d nə Micilyá mí Moyîz kala nə mí mí búúd ɔ mícúndə́. ");
INSERT INTO mcp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bwə́ mú ŋgə shísh kúnə́-kúnə nə də́nd bwə́ á ŋgə kə yí. Yésus nyɛ mú sá nda a cɔ̧́ kə nə njɔɔnd shwóg. ");
INSERT INTO mcp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bwə́ mú yáág nə nyə nə́ a kú cɔ̧́, bwə́ nə nyə nə́: «Jig wa sə́dɨ́, kugʉ́ mə́ bii shí, jwɔ̂w í mú bul kə.» A mú nyíi njɔ́w nə́ a ji cínɔŋg bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Í mú zə bə nə́, ja bə́nɔ́ŋ bwə́ mə́ zə ji shí nə́ bwə́ də yí, Yésus mú ŋwa bʉlɛ́d, a mú bwádan nə gwo, a mú fɛ̂y gwo a yə bwo. ");
INSERT INTO mcp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mísh mə́ mú ka tɛɛm bâŋ bwo nə́ ndɛɛ́ bwə́ mú yag nyə. Njɨ, a mú jímb bwo míshʉ́d. ");
INSERT INTO mcp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bwə́ mú ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Ja nyə ámə ŋgə lésha nə sə́ zhɨ́ɨ́ nə zhɨɨ́ ŋgə fɛ́ɛ́g sə́ mícilyá mí Kálaad Zɛmbî yí, ŋgaá nə́ milâm mí ámə ŋgə bə sə́ nə́ gwɔ̧́ɔ̧́-gwɔ̧́ɔ̧́ nə fwámɛ́ yéésh ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bwə́ mú tɨ́ njɔɔnd nə́mə́ wəla dɔɔŋgʉ́d nyiŋgə kə Yurʉ́səlɛm. Bwə́ mú kə kwey *búúd ɔ lwámá wûm nə ŋgwúd bə́nɔ̂ŋ buud bwə́ á zə sɛɛŋgya nə bwo wá. ");
INSERT INTO mcp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bwə́ mú kə jaaw bwo nə́ jísə bʉ́bə́lɛ́ nə́ Cwámba mə́ gwûm, Shímun shí dʉ́g nyə. ");
INSERT INTO mcp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bwə́ mú bwiiŋg bwo sâ í ámə bə nə bwo zhɨ́ɨ́ nə zhɨɨ́ yí nə nda bwə́ ámə kə yag Yésus ja nyə́ ámə fɛ̂y bʉlɛ́d nə́. ");
INSERT INTO mcp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bwə́ ŋgə́ bwiiŋg bwo gwo ntʉ́nɨ, Yésus mə́ cúwo, zə tɔ̂w bwo tʉ́tám, a mú cɨ nə bwo nə́: «Səlʉgá milâm shí.» ");
INSERT INTO mcp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Məma yáág-yáág íŋkuŋkúúnd í mú shwɨy bwo nyúúlʉ́d, bwə́ ŋgə́ dʉ́g nə́ *jîm wə́ bwə́ mə́ dʉ́g nɨ. ");
INSERT INTO mcp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A mú cɨ nə bwo nə́: «Jɨ́ bɨ́ ŋgə́ búbulə yí? Jɨ́ bɨ́ ŋgə́ bə nə məshwán mílámʉ́d yí? ");
INSERT INTO mcp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dʉ́gʉ́gá məbwə̂ nə məkuú mâm. Jísə mpú bə mə wə́ ɛ́ga. Kúnyágá nə mə, dʉ́gʉ́gá. Jîm í ádɛ́ bə nə ifúndə́ nə iyasə́ nda bɨ́ ŋgə́ dʉ́g mə nə ndɨ̂ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nyə á ŋgə cɨ ntʉ́nɨ a ŋgə́ lwágʉlə bwo məbwə́ nə məkuú mɛ́. ");
INSERT INTO mcp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bwə́ á bə bwə́ mú nə məshusʉg, bwə́ ŋgə́ káam, njɨ bwə́ kú fwo mpu *búgʉla. A mú cɨ nə bwo nə́: «Bɨ́ cugɛ́ nə sâ mə́ də́ wa?» ");
INSERT INTO mcp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bwə́ mú yə nyə kʉ́l shú mbufá. ");
INSERT INTO mcp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A mú ŋwa gwo, a mú də bwə́ ŋgə́ dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A mú cɨ nə bwo nə́: «Sâ mə́ á bwey dʉ jaaw bɨ́ ja shé á dʉ bə yí ɔ́nɨ; mə á dʉ jaaw bɨ́ nə́ isâ bísə́ cilyá shú dâm Cɛ̧ɛ̧ mə́ Moyîz dɨ́ nə micilyá mí *búúd ɔ mícúndə́ nə osôm dɨ́ yí byɛ̂sh í jəlá nə bá sɨ̂y.» ");
INSERT INTO mcp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A mú bɛ̂ny bwo fʉg nə́ bwə́ gwágʉ́g mícilyá mí Kálaad Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A mú cɨ nə bwo nə́: «Jísə cilyá Kálaad Zɛmbî dɨ́ ntʉ́ga “Krîst mə bá jug nə́ ndɛɛ́ a gwûm jwɔ̂w álɛ́ɛlʉd, ");
INSERT INTO mcp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","bwə́ ka bá dʉ cúndə jínə́ dɛ́d nə́ buud bwə́ cɛ́ndʉ́g mitə́dʉ́gá, Zɛmbî mú juu bwo. Cúndə́ wɔɔŋg í bá tɛ́ɛ́d Yurʉ́səlɛm í mú kala ílwoŋ byɛ̂sh.” ");
INSERT INTO mcp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bɨ wə́ bʉ́sə́ ówúshinɛd wâ isâ byɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nə́ ndɛɛ́, mə bá ntɨ́ bɨ́ sâ Dâ nyə á kaag bɨ́ yí. Bɨ bâŋ jigá wa ŋgwə́la kə kumə ja mpífə́ í bá zhu gwɔ̂w, bɨ́ zə lwánd nə ndɨ̂ yí.» ");
INSERT INTO mcp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A mú wú nə bwo ŋgwə́la kə nə bwo kúnə́-kúnə nə Betanî. Kə wɔ́ɔ́s nûŋ, a mú bʉ̂n məbwə̂ bwádan nə bwo. ");
INSERT INTO mcp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A ŋgə́ bwádan nə bwo ntʉ́nɨ, a mú ŋgə béégya nə bwo, ŋgə ŋkâŋ kə gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bâŋ bwə́ mú kúdɔw shí yə nyə gúmə́ nə́ ndɛɛ́ bwə́ mú nyiŋgə kə Yurʉ́səlɛm nə məshusʉg milâm nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bwə́ mú kə ji *Luŋ mə́ Zɛmbî kú ná kwo wú, dʉ ságʉsə Zɛmbî.");
INSERT INTO mcp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mə́tɛ́ɛ́dʉ́lé mə́ ísâ byɛ̂sh dɨ́, Ciyá í á bwey bə, Ciyá bá Zɛmbî wə́ bwə́ á bə. Ciyá jɔɔŋg í á bə ntâg Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bá Zɛmbî wə́ bwə́ á bə mə́tɛ́ɛ́dʉ́lé mə́ ísâ byɛ̂sh dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gwə́ wə́ í á tɛ́ isâ byɛ̂sh; kú nə tɔɔ sâ wo é kwey nə́ Ciyá dɨ́ í á tɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cʉg í á bə Ciyá jɔɔŋg dɨ̂, cʉg jɔɔŋg í njúl məŋkɛnya ŋgə̌lə kwan buud. ");
INSERT INTO mcp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Məŋkɛnya mə́ á ŋgə faan yídʉ́gʉ́d; njɨ, yídʉ́gʉ́ í áshígɛ́ magʉlə lə́g mə́ŋkɛnya. ");
INSERT INTO mcp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ŋgwɔ́l múúd nyə á bə nə́ Yuánɛs, Zɛmbî wə́ nyə á ntɨ nyə. ");
INSERT INTO mcp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yuánɛs nyə á zə nə́ a zə́g bwiiŋg sâ í dʉ́gyá nə məŋkɛnya mɔɔŋg yí, shú nə buud bɛ̂sh bwə́ búgʉ́lág nəcé bwiiŋgyá jɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nyə dɨ́ nyə á bə məŋkɛnya; nyə á yida zə bwiiŋg sâ í dʉ́gyá nə məŋkɛnya yí. ");
INSERT INTO mcp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Məŋkɛnya mɔɔŋg mə́ á bə fwámɛ́ mə́ŋkɛnya, mâ nə́, ja mə́ zə́ shí ga dɨ́ yí, mə́ zə́ kwan búúd bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ciyá í á bə shí gaád, gwə́ nə́mə́ wə́ í á tɛ́ shí ga; njɨ, buud ɔ shí ga bwə́ á shígɛ́ yag gwo. ");
INSERT INTO mcp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Í á zə búúd bɛ́ dɨ́, njɨ buud bɛ́ nda magʉlə lə́g gwo. ");
INSERT INTO mcp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Njɨ, búúd báá bwə́ á lə́g gwo, bwə́ *búgʉla jínə́ dɛ́ wá, nyə á yə bwo ŋkul nə́ bwə́ bə́g bwán ɔ́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bâŋ bwə́ mə́ byɛ̂l, kú bə byélé í ŋgə́ wú mə́cií dɨ́ yí, kú nə́mə́ bə váál búúd bwə́ dʉ́ ŋgə byá nə yéésh jáŋ yí, nda nyiŋgə bə nə́ muud nyə ámə jɨɨ nə́ a byá mwân; bwə́ mə́ byɛ̂l byélé á nə́ Zɛmbî wə́ mə́ byá bwo. ");
INSERT INTO mcp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ciyá í á ka nyɛɛ muud, í á cʉgə wa sə́dɨ́. Cʉg jé í á bə cʉg mílwanə́, mpaam nə mpaam, obʉ́bə́lɛ́ nə obʉ́bə́lɛ́. Sə́ á beny milwanə́ myɛ́, mí njúl milwanə́ mí Mwán mə́ byɛ̂l cʉ́gə́ mwɔ̧ mə Sɔ́ɔ́ŋgʉ́ dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuánɛs nyə á bwiiŋg láŋ yé, a lás gwɔ́w-gwɔ̂w nə́: «Muud mə á jaaw bɨ́ wə́ ɛ́nɛ. Nyə wə́ mə á cɨ yɛ́, nə́: muud ŋgə zə mə́dɨ́ mpʉ́sə; njɨ, a mə́ tɔ̂w mə shwóg, nəcé nyə wə́ nyə a tɛ́ɛ́d fwo bə nə mə. Muud wɔɔŋg wə́ ɛ́nɛ» ");
INSERT INTO mcp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sə́ bɛ̂sh sə́ á mə́ bə nə kɔw nyə́dɨ́ zhwog tɔɔm dɨ̂, a ŋgə cʉgə nə sə́ njɨ mpaam nə mpaam. ");
INSERT INTO mcp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nəcé Moyîz nyə á zə nə *mbwoomb mə́cɛ̧ɛ̧, Yésus-Krîst zə nə mpaam nə obʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Muud nyə abwɛ́lɛ́ dʉ́g Zɛmbî. Njɨ, Cʉ́gə́ lʉ́ Mwán dɛ́ nyə́mɛ́fwó mə́ jɛ́ɛ́g bʉd dɨ́, dʉ́sə́ nə́mə́ Zɛmbî yí, dwə́ wə́ í á sá nə́ Zɛmbî mpúyʉ́g. ");
INSERT INTO mcp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Oyúdɛn bwə́ á kənd ofada nə *Olevît kə shilə Yuánɛs nə́: «Wo wə́ zə́?» A mú ka bwiiŋg bwo sâ Yésus jísə́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nyə á mpu məm nə́: «Mɛɛ dɨ́ jísə́ *Krîst.» Nyə á mpu məm ntɔ́ kú shwána. ");
INSERT INTO mcp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bwə́ á ka nə́mə́ jî nyə nə́: «Ká wo wə́ zə́? Ye Eli?» Nyə nə́: «Mbɔ̂, mə dɨ́ Eli.» «Ye wo wə́ *Muud micúndə́?» Nyə nə́: «Mbɔ̂». ");
INSERT INTO mcp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bwə́ mú ka cɨ nə nyə nə́: «Ká wo wə́ zə́? Sə́ kə́g bɛ̧sa nə buud bwə́ ámə ntɨ sə́ wá nə́ jɨ? Womɛ́fwó ŋgə cɨ nə́ wo wə́ zə́?» ");
INSERT INTO mcp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A mú bɛ̧sa nə bwo nə́: «Mə wə́ kə́l í ŋgə́ cúndə shí a shwééshád yí, ŋgə cɨ nə́: “Sʉ́gʉ́gá zhɨɨ́ mə Cwámba í bə́g tʉ́təlî” nə́mə́ nda múúd micúndə́ Izayí nyə á cɨ nə́.» ");
INSERT INTO mcp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ofada nə Olevît bwə́ á kəndɔw wá bwə́ á bə *Ofarizyɛ̂ŋ. ");
INSERT INTO mcp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bwə́ mú ka jî nyə nə́: «Ŋkí wo dɨ́ Krîst, wo kú bə Eli, wo kú nyiŋgə bə múúd micúndə́, nəcé jɨ́ wó ŋgə́ duu buud yí?» Yuánɛs mú bɛ̧sa nə bwo nə́ ");
INSERT INTO mcp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","«Mɛɛ mə ŋgə duu buud mə́júwód. Njɨ ŋgwɔ́l múúd jɨ na mpə́dʉ́gá nyɨ́nʉ́d, bɨ ampúyɛ́ nyə. ");
INSERT INTO mcp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A ŋgə zə mə́dɨ́ mpʉ́sə, mə ampíyáyɛ́ nə́ mə cínyʉg nyə mikwoolú mí mə́ŋgwub məkuúd.» ");
INSERT INTO mcp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sá nɨ í á ŋgə sɨ̂y Betanî, Zhurdɛ̧̂ faŋwíny, kʉ́l Yuánɛs nyə á ŋgə duu buud yí. ");
INSERT INTO mcp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nə́ ndɛɛ́, mán mələ̂m, Yuánɛs nyə a dʉ́g Yésus ŋgə́ zə nyə́dɨ́, a mú cɨ nə́: «Dʉgá, *Mwân Ncwəmbɛ mə́ Zɛmbî wə́ ɛ́ga, nyə wə́ mə́ zə́ yîl búúd ɔ shí ga *sə́m wáŋ. ");
INSERT INTO mcp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ŋgaá mə a cɨ nə́: “Muud ŋgə zə mə́dɨ́ mpʉ́sə; njɨ, nyə wə́ nyə a tɛ́ɛ́d zə nə mə, nəcé nyə wə́ nyə a tɛ́ɛ́d fwo bə nə mə.” Nyə wə́ mə́ á ŋgə cɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mə a shígɛ́ fwo dʉ mpu nyə. Njɨ, nda í á jɨɨ nə́ bag ɔ́ *Izʉrəyɛ̂l bwə́ mpúg nyə nə́, gwə́ wə́ mə́ á zə ŋgə duu buud mə́júwód yí.» ");
INSERT INTO mcp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuánɛs nyə á bwaagʉlə nə́: «Mə a dʉ́g Shíshim ŋgə́ shulə wú gwɔ̂w nda faf nə́ ndɛɛ́ zə ji nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɛɛ mə a shígɛ́ fwo dʉ mpu nyə ɔ; njɨ muud nyə á ntɨ mə nə́ mə zə́g ŋgə duu buud mə́júwód yɛ́ nyə á bwey jaaw mə nə́: “Muud wó bá dʉ́g Shíshim mə́ shulə zə ji nyúúlʉ́d yɛ́, nyə wə́ mə́ bá dʉ duu búúd Ŋkɛ̧́ŋkɛ̧̂ Shíshimʉd.” ");
INSERT INTO mcp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mɛɛ mə a shí ntâg dʉ́g, mə ŋgə bwaagʉlə nə́ nyə wə́ jɨ́ Mwân mə Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Í á ka zə bə mán mələ̂m, Yuánɛs bə́nɔ̂ŋ bɔ́ɔ́l *ómpwíín bɛ́ óbá bwə́ njúl nə́mə́ na, ");
INSERT INTO mcp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","a mú dʉ́g Yésus ŋgə́ cɔ̧́, a mú cɨ nə́: «Dʉgá, *Mwân Ncwəmbɛ mə́ Zɛmbî wə́ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ompwíín óbá bɔɔŋg bwə́ mú gwág sâ Yuánɛs nyə á ŋgə cɨ yí nə́ ndɛɛ́ bwə́ mú kə ŋgə bɛ̧ Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yésus mú yid, a mú dʉ́g bwə́ ŋgə́ bɛ̧ nyə, a mú jî bwo nə́: «Bɨ́ ŋgə sɔ̧́ jɨ?» Bwə́ nə nɛ́ nə́: «*Rabi, wó dʉ ji ŋgow?» (Rabi mə kə́ nə́ «Yɨ́ɨ́gʉli».) ");
INSERT INTO mcp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nyə ntâg nə bwo nə́: «Zəgá kə dʉ́g». Bwə́ mú ka kə dʉ́g kʉ́l á dʉ jɨ yí, nə́ ndɛɛ́, bwə́ mú ji cínɔŋg nyə́dɨ́ jwɔ̂w dɔɔŋgʉ́d. Í á bə jwɔ́w í mú ŋgɛɛ mə́wəla mənɔ̧̂ mâ mpwó-kugʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ompwíín óbá bwə́ á gwág sâ Yuánɛs nyə á ŋgə cɨ yí nə́ ndɛɛ́ bwə́ mú bɛ̧ Yésus wá, ŋgwɔ́lʉ́gá nyə á bə Andrê mínyɔŋʉ̂ mə́ Shímun Pyɛ̂r. ");
INSERT INTO mcp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nyə á ka tɛ́ɛ́d kə wə́ mínyɔŋʉ̂ yé Shímun, kə cɨ nə nyə nə́: «Sə́ mə́ bwəma nə Mesî (jínə́ dɔɔŋg í kə́ nə́ Krîst).» ");
INSERT INTO mcp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A mú kə nə nyə wə́ Yésus. Yésus mú dʉ dʉ́g Shímun nə́ ndɛɛ́ a mú cɨ nə nyə nə́: «Ŋgaá nə́ wo wə́ Shímun, shwóóŋgʉ̂ nə́ Yuánɛs; wo bá zə dʉ jɔ́wɔw nə́ Séfas» (jínə́ dɔɔŋg í kə́ nə́ Pyɛ̂r). ");
INSERT INTO mcp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mán mələ̂m, Yésus nyə a ŋwa cígʉ́lá nə́ a kə́ Galilê. A mú bwəma nə Fílíp, a mú cɨ nə Fílíp nə́: «Bɛ̧g mə.» ");
INSERT INTO mcp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fílíp nyə á bə muud á Bɛtʉsayída, də́nd mə́ Andrê bá Pyɛ̂r. ");
INSERT INTO mcp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fílíp mú ka kə wə́ Natanaɛ̂l kə cɨ nə nyə nə́: «Sə́ mə́ bwəma nə Yésus á Nazarɛ̂t, mwân mə Yósɛb bwə́ ŋgə́ cɨ ókálaad ɔ mə́cɛ̧ɛ̧ mə́ Moyîz nə bɔɔŋg ɔ *búúd ɔ mícúndə́d yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaɛ̂l mú cɨ nə Fílíp nə́: «Ye sâ ányunywaâ jɨ́ nə ŋkul zhu Nazarɛ̂t?» ");
INSERT INTO mcp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Fílíp mú ka cɨ nə nyə nə́: «Zaá kə dʉ́g». Yésus mú dʉ́g Natanaɛ̂l ŋgə zə, a mú cɨ nə́: «Dʉgá, muud ɛ́ga jɨ fwámɛ́ mwâ *Izʉrəyɛ̂l, kú yîl, kú bəd.» ");
INSERT INTO mcp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaɛ̂l mú jî nyə nə́: «Wɛɛ mə mpú mə na ntʉdɛl?» Yésus mú bɛ̧sa nə́: «Mə ámə ŋgə bwey dʉ́g wo, wo njúl ná shug lʉ́ *figyê dɨ, bɨná Fílíp kú fwo lésha.» ");
INSERT INTO mcp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaɛ̂l mú cɨ nə́: «Rabi, wɛɛ jɨ Mwân mə́ Zɛmbî, wɛɛ jɨ Cí á Izʉrəyɛ̂l.» ");
INSERT INTO mcp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yésus mú bɛ̧sa nə nyə nə́: «Wo mə́ *búgʉla nəcé mə jaawʉ́lə wo nə́ mə á ŋgə bwey dʉ́g wo, wo njúl ná shug lʉ́ figyê dɨ; mpug nə́ wo bá dʉ́g ísâ í bá nyiŋgə bul bə í anʉ́nɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A mú nyiŋgə cɨ nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bɨ mə bá dʉ́g joŋ nə́ bagə́, *wəéŋgəles ɔ́ Zɛmbî bwə́ dʉ́gə́ bád dʉ shulə *Mwân mə Múúd nyúúlʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mpʉ́sə mwɔ̂w mə́bá, ŋgwɔ́l múúd nyə á ŋwa bá ŋgwə́la á Galilê bwə́ jɔ́w nə́ Kana yí, bwə́ á ka sá zaŋ. Maríya á nyɔɔŋgʉ́ mə Yésus nyə á bə cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bwə́ á jɔ̂w nə́mə́ Yésus nə́ a kə́g zâŋ nyɔɔŋgʉ́d, tɔɔ *ompwíín bɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Í á ka zə bə, məlwəg ka zə fúfə, Yésus nyɔɔŋgʉ́ mú ka zə cɨ nə nyə nə́: «Dʉgɨ́, bwə́ cúgɛ́ ná nə məlwəg». ");
INSERT INTO mcp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yésus mú cɨ nə nyə nə́: «Amuda, shwə̂ bâŋ nə inɛ́y? Wəla dâm í afwóyɛ́ wɔ́ɔ́s.» ");
INSERT INTO mcp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nyɔɔŋgʉ́ mú cɨ nə osɔ́ɔl ɔ mə́sáal nə́: «Bɨ ɔ sá sâ jɛ̂sh nyə é cɨ nə́ bɨ sáág yí.» ");
INSERT INTO mcp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na jɨ nə́, idɔ̧ɔ̧la ísaman í á bə í tə́l na, *Oyúdɛn bwə́ á dʉ balan nə byo dʉ́lə gusa míŋgusa mí íci. Idɔ̧ɔ̧la byɔɔŋg í á bə cɨɨgá nə məkwóógʉ́, í njúl nə́ dɔ̧ɔ̧la ŋgwúd je kə ílwuŋgá í mə́júwó ŋkí mwɔɔmb ŋkí wûm nə íbá. ");
INSERT INTO mcp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yésus mú cɨ nə osɔ́ɔl ɔ mə́sáal nə́: «Lwándʉ́lə́gá məjúwó na ídɔ̧ɔ̧la ínɨɨ́d.» Bwə́ mú lwándʉlə byo nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A mú nyiŋgə cɨ nə bwo nə́: «Kagá dɔ̧ɔ̧lə ja nɨɨ́d bɨ kə́g yə múúd ŋgə́ sá dína yɛ́.» Bwə́ mú dɔ̧ɔ̧lə, kə yə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Muud nyə á ŋgə sá dína yɛ́ mú kagʉlə mə́júwó mə́ mə́ shîn nyɛɛ mə́lwəg mə́nɨ; nyə a shígɛ́ mpu kʉ́l mə́lwəg mɔɔŋg mə́ á ŋgə wú yí, osɔ́ɔl ɔ mə́sáal báá, buud bwə́ á dɔ̧ɔ̧lə məjúwó wá, bwə́ ŋgə́ mpu. ");
INSERT INTO mcp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","A mú jɔ̂w múúd nyə á ŋwa bá yɛ́ zə cɨ nə nyə nə́: «Ja bwə́ dʉ sá ídína yí, bwə́ dʉ tɛ́ɛ́d fwo yə búúd məlwəg mə́ búl nywa má, ka zə shúgʉla nə mɔɔŋg mə́ abʉ́lɛ́ nywa má ja búúd bwə́ mú ŋgə shwág yí. Ká wɛɛ wo ámə nyiŋgə baagʉlə mə́lwəg mə anyunywaâ zə wɔ́ɔ́s wəla ga dɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","*Shimbá Yésus nyə a tɛ́ɛ́d sá wə́nɨ, nyə a sá dwo ŋgwə́la á Galilê bwə́ jɔ́w nə́ Kana yí lwóya milwanə́ myɛ́, ompwíín bɛ́ bwə́ mú *búgʉla nyə. ");
INSERT INTO mcp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ja ísâ ínɨ í mə́ shîn yí, a mú shulə kə Kapɛrnawûm, bə́nɔ̂ŋ nyɔɔŋgʉ́ yé nə omínyɔŋʉ̂ bɛ́ nə ompwíín bɛ́. Njɨ, bwə́ á jǐ wu njɨ bʉ́baalɛ́ mwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nda zâŋ Páska í á bə í mú kúnə́-kúnə nə́, Yésus nyə á ka bád kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A mú kə kwey nə́, nə buud bwə́ á ŋgə kusha intɛny wá, nə bɔɔŋg bwə́ á ŋgə kusha itɔw nə məfaf wá, nə bɔɔŋg bwə́ á ŋgə sá icɛ́nd í *mwaanɛ̂ wá bwə́ mə́ kə ji nə mikus *Luŋ mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","A mú ŋwa míkwoolú sá lwóŋ nə́ ndɛɛ́ wɨ́ɨ́ŋg yîl bɛ̂sh Luŋ mə́ Zɛmbî, wɨ́ɨ́ŋg nə́mə́ ítɔw nə intɛny. A mú ŋgə lwágʉsə omwaanɛ̂ búúd bwə́ á ŋgə sá icɛ́nd wá, shîn lwág itʉ́wʉlɨ byáŋ. ");
INSERT INTO mcp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nyə nə buud bwə́ á ŋgə kusha məfaf wá nə́: «Yílʉ́gá isâ íga wa. Kúgá ŋwa njɔ́w mə́ pʉpa nda watála.» ");
INSERT INTO mcp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","*Ompwíín bɛ́ bwə́ mú tə́dʉga nda jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́, nə́: «Cɛɛlí mə́ ŋgə́ cɛɛl njɔ́w wô yí, í ŋgə gwɔ̧́ mə lámʉ́d nda kuda». ");
INSERT INTO mcp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oyúdɛn bwə́ mú zə lás nə nyə nə́: «Wo ŋgə zə sá isâ ínɨ nə́ wo mə́ fwo ka lwágʉlə sə́ dáyɛ́ *shimbá?» ");
INSERT INTO mcp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yésus nə bwo nə́: «Caamʉgá *Mpáánzə́ Zɛmbî ga, mə nyiŋgəg lwɔ̧́ bɨ nywo njɨ mwɔ̂w mə́lɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","*Oyúdɛn nə́: «Jɨ́! Mpáánzə́ nɨ, məlwɔ̧́ga mɛ́ mə́ á ŋwa buud mimbú məwûm mə́nɔ̧̂ nə mísaman, wɛɛ mə́ cɨ nə́ wo é lwɔ̧́ nywo njɨ mwɔ̂w mə́lɔ́ɔl?» ");
INSERT INTO mcp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ndug nyúúl nyɛ́ wə́ nywáá nyə á ŋgə jɔ̂w nə́ Mpáánzə́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ompwíín bɛ́ bwə́ á kə nyiŋgə tə́dʉga lə́sʉ́ Yésus nyə a lás wɔɔŋgʉ́ ja nyə gwûm yí, bwə́ mú *magʉlə Mícilyá myâ Kálaad Zɛmbî, *magʉlə nə́mə́ lə́sʉ́ yé. ");
INSERT INTO mcp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Í á ka ŋgə bə na nə́, ja Yésus nyə á bə zâŋ Páska dɨ́ Yurʉ́səlɛm yí, zhwog buud bwə́ á *búgʉla jínə́ dɛ́ nə dʉ́gʉ́lə mə́shimbá nyə á ŋgə sá má. ");
INSERT INTO mcp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Njɨ Yésus nyə a shígɛ́ ŋgə shwu nyúul nə bwo, nəcé nyə á ŋgə mpu bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Í áshígɛ́ nyiŋgə jɨɨ nə́ muud zə́g jaaw nyə nə́ mbɛɛ́ jɨ ntʉ́ga, kɛɛl jɨ ntʉ́ga. Nyəmɛ́fwó nyə á ŋgə mpu sâ jɨ́ múúd lámʉ́d yí. ");
INSERT INTO mcp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ŋgwɔ́l múúd nyə á ka bə gwooŋg *Ofarizyɛ̂ŋ dɨ́ nə jínə́ nə́ Nikodɛ̂m; nyə á bə nə́mə́ tɔ́we shwóg *Oyúdɛn. ");
INSERT INTO mcp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Muud ɛ́nɛ nyə á ka kə dʉ́g Yésus mpwó-bulú kə cɨ nə nyə nə́: «*Rabi sə́ ŋgə mpu nə́ wo jɨ yɨ́ɨ́gʉli ŋgə́ zhu wə́ Zɛmbî yɛ́. Nəcé, muud cugɛ́ nə ŋkul sá *mə́shimbá wó ŋgə́ sá mə́ga ŋkí Zɛmbî nyə ayə́yɛ́ nyə ŋkul.» ");
INSERT INTO mcp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yésus mú bɛ̧sa nə nyə nə́: «Bʉ́bə́lɛ́, mə́ jaaw wo nə́, ŋkí muud mə bə́ kú byɛ̂l byélé ágúgwáan, a cugɛ́ nə ŋkul dʉ́g Faan mə́ Zɛmbî». ");
INSERT INTO mcp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛ̂m mú jî nyə nə́: «Ntʉdɛlɛ́ cwúcwúúl múúd jɨ́ nə ŋkul nyiŋgə byɛ̂l yɛ́? Ye a jɨ nə ŋkul nyiŋgə nyíi nyɔ́ɔ́ŋgʉ́ mwô dɨ́ ja ábɛɛ̂ nə́ ndɛɛ́ a mú nyiŋgə byɛ̂l?» ");
INSERT INTO mcp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yésus mú bɛ̧sa nə́: «Bʉ́bə́lɛ́, mə́ jaaw wo nə́, ŋkí muud mə bə́ kú byɛ̂l zhɨɨ́ á məjúwó nə Shíshim dɨ́, a cugɛ́ nə ŋkul nyíi Faan mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Byɛyí á shí ga í dʉ byá míshwun, byɛyí á Shíshim byá *shíshim. ");
INSERT INTO mcp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kú káam nə́ mə́ cɨ nə wo nə́ bɨ mə́ jəlá nə byɛ̂l byélé ágúgwáan. ");
INSERT INTO mcp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ŋkwɔ̧̂ mə́ dʉ kuŋg kʉ́l á kûŋg yí, wo ŋgə́ gwág ncíndə́ nyɛ́, njɨ wo nda mpu kɔ́ɔ́mb á ŋgə́ zhu yí nə kɔ́ɔ́mb á ŋgə kə yí. Ntɔ́ nə́mə́ wə́ jɨ́ nə muud mə́ byɛ̂l byélé Shíshim yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛ̂m mú cɨ nə nyə nə́: «Jâŋ jɨ́ nə ŋkul bə na ntʉdɛl?» ");
INSERT INTO mcp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yésus mú bɛ̧sa nə nyə nə́: «Wɛɛ muud ŋgə́ jɨ́ɨ́gʉli bwán ɔ́ *Izʉrəyɛ̂l yɛ́ wo ampúyɛ́ ísâ ínɨ? ");
INSERT INTO mcp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bʉ́bə́lɛ́, mə́ jaaw wo nə́, sə́ ŋgə lás sâ sə́ mə́ mpú yí, sə́ ŋgə bwiiŋg sâ sə́ á dʉ́g yí, njɨ bɨ́ nda magʉlə sâ sə́ ŋgə́ bwiiŋg yí. ");
INSERT INTO mcp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ja mə́ lás nə bɨ́ isâ yâ shí ga, bɨ́ nda *magʉlə yí, bɨ bʉ́sə nə ŋkul magʉlə yâ gwɔ̂w na ntʉdɛl? ");
INSERT INTO mcp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mpugá nə́ muud nyə afwóyɛ́ bád kə joŋ dɨ́ gwɔ̂w, nə́mə́ njɨ *Mwân mə Múúd, nyə muud nyə á zhu gwɔ́w yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nə́ ndɛɛ́, nə́mə́ nda Moyîz nyə a bʉ̂n vʉgʉli nywâ gwɔ́w shí a shwééshád nə́, í jɨɨ nə́ bwə́ bág nə́mə́ bʉ̂n Mwân mə Múúd gwɔ̂w, ");
INSERT INTO mcp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","shú nə́ muud yɛ̂sh mə bá *búgʉla nyə yɛ́ bág *bə nə cʉg á kandʉgə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nəcé, Zɛmbî nyə á cɛɛl buud ɔ shí ga nə mbíya yáág-yáág cɛɛlí, váál á nə́, nyə a yána Cʉ́gə́ lʉ́ Mwán dɛ́ nə́ muud yɛ̂sh mə búgʉla nyə yɛ́ bág bə kú yə, a yidag bə nə cʉg á kandʉgə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mpugá nə́ Zɛmbî nyə a shígɛ́ ntɨ Mwán yé shí ga dɨ́ nə́ a zə́g yə búúd intʉ́gʉ́lí, i á yida bə nə́ a zə́g sá nə́ buud bwə́ fáámʉg. ");
INSERT INTO mcp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Muud mə búgʉ́lá nyə yɛ́ nyə ányiŋgəyɛ́ ná bwəma nə intʉ́gʉ́lí; muud mə yídá bə kú búgʉla yɛ́, intʉ́gʉ́lí byé í mə́ bwey bə; í mə́ bwey bə nəcé a mə́ bə kú búgʉla Cʉ́gə́ lʉ́ Mwán mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Dʉgá, Zɛmbî nyə a sá nə́ sémbyé mílə́sʉ́ í mpúyʉ́g, nyə a sá ntʉ́ga: nyə á ntɨ məŋkɛnya shí ga dɨ̂, buud bwə́ mú yida cɛɛl mə́yídʉ́gʉ́ cɔ̧́ mə́ŋkɛnya. Bwə́ á sá ntɔ́ nəcé bɔ̂w bwo misɔ́ɔ́lʉ́gʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jɨ́ nə́ muud yɛ̂sh mə dʉ sá mə́bɔ̂w yɛ́ mə́ dʉ mpii mə́ŋkɛnya, nyə ádɛ́ kə kʉ́l mə́sʉ́ yí, a fúndə́ nə́ misɔ́ɔ́lʉ́gʉ́ myɛ́ mí á bá bʉ́gʉli. ");
INSERT INTO mcp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Muud nywáá ŋgə́ bɛ̧ obʉ́bə́lɛ́ yɛ́ mə́ dʉ kə kʉ́l mə́ŋkɛnya mə́sʉ́ yí, í nyínʉ́g nə́ a ŋgə sá misɔ́ɔ́lʉ́gʉ́ myɛ́ váál Zɛmbî ŋgə́ jɨɨ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ja ísâ ínɨ í mə́ shîn yí, Yésus mə́ zə kə shí á Yudéa, bə́nɔ̂ŋ *ompwíín bɛ́. A mú kə ji nə bwo wu, a ŋgə́ duu buud. ");
INSERT INTO mcp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Í á bə, Yuánɛs ŋgə́ nə́mə́ duu buud Inɔn, kúnə́-kúnə nə Salîm, nəcé məjúwó mə́ á bə wu ŋkí bulya. Buud bwə́ á ka dʉ kə, dʉ kə duwan. ");
INSERT INTO mcp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na nyə á bə bwə́ kú fwo wá Yuánɛs mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ompwíín ɔ́ Yuánɛs bə́nɔ̂ŋ ŋgwɔ́l *Yúdɛn bwə́ á ka zə sɛ́ŋʉsa məkə̂l shú sâ í dʉ́gyá nə ŋgusa yə́bə́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bwə́ mú kə wə́ Yuánɛs kə cɨ nə nyə nə́: «*Rabi, dʉgɨ́, muud bɨ́ná bɨ á bə Zhurdɛ̧̂ faŋwíny wó á ŋgə bwaagʉlə láŋ yé yɛ́, a ŋgə duu buud, buud bɛ̂sh bwə́ mú ŋgə kə nyə́dɨ́.» ");
INSERT INTO mcp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuánɛs mú bɛ̧sa nə́: «Muud cugɛ́ nə ŋkul bə nə sâ, Zɛmbî kú fwo yə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bɨmɛ́fwó bɨ́ bʉ́sə mə owúshinɛd nə́ mə á cɨ nə́: “Mɛɛ dɨ́ jísə́ *Krîst, mɛɛ jɨ njɨ muud Zɛmbî nyə á ntɨ Krîst dɨ́ shwóg yɛ́.” ");
INSERT INTO mcp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Muud mə ŋwá bá yɛ́, nyə wə́ jɨ́ nə mudá; shwə́ yé tə́l cínɔŋgʉ́ ŋgə́ gwágʉlə nyə yɛ́, nyə é bul bə nə məshusʉg ja á gwág kə́l mə́ múúd bá yí. Váál mə́shusʉg dɔɔŋg wə́ mə́ jɨ́ nə ndɨ́ yí, məshusʉg ntɔ̧ njɨ. ");
INSERT INTO mcp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Í jɨɨ nə́ jínə́ mə́ Yésus ŋgə́g nə jwɔ̧, mɛɛ dâm ŋgə́ jímb jímbʉ́g. ");
INSERT INTO mcp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Muud ŋgə́ zhu gwɔ́w yɛ́ ŋgə cɔ̧́ buud bɛ̂sh; nyɔɔŋg ŋgə́ zhu shí yɛ́ jɨ nə́mə́ njɨ muud a shí, a lás nə́mə́ njɨ sâ í dʉ́gyá nə shí yí. Muud ŋgə́ zhu gwɔ́w joŋ dɨ́ yɛ́ ŋgə cɔ̧́ buud bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A ŋgə bwaagʉlə sâ nyə á dʉ́g yí nə sâ nyə á gwág yí, njɨ, buud bwə́ áŋgɛ̂ nə magʉlə sâ á ŋgə́ bwaagʉlə yí. ");
INSERT INTO mcp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Muud mə mágʉ́lə́ bwaagʉlə́lə wɔɔŋg yɛ́ mə́ lwágʉlə nə́ Zɛmbî jɨ bʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nəcé muud Zɛmbî nyə á ntɨ yɛ́ mə́ dʉ lás íciyá í Zɛmbî; nəcé, Zɛmbî mə yə́ nyə Shíshim kú nə minjɨ. ");
INSERT INTO mcp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dâ mə́ cɛɛl Mwán, nyə a mə́ bəd nyə isâ byɛ̂sh mə́bwə́d. ");
INSERT INTO mcp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Muud mə *búgʉ́lá Mwân mə Zɛmbî yɛ́ jɨ nə cʉg á kandʉgə kandʉgə; muud mə bán nə́ nyə abúgʉ́láyɛ́ *Mwân mə́ Zɛmbî yɛ́ nyə abʉ́lɛ *dʉ́g cʉg, mpimbə mə́ Zɛmbî yida nada nyə cʉgʉd.» ");
INSERT INTO mcp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yésus nyə á ka zə mpu nə́ *Ofarizyɛ̂ŋ bwə́ mə́ gwádʉga nə́ a mú ŋgə bul bə nə *ompwíín ntɔ̧ Yuánɛs, a ŋgə duu buud ntɔ̧ nyə. ");
INSERT INTO mcp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Njɨ, Yésus nyəmɛ́fwó nyə a shígɛ́ ŋgə duu buud, ompwíín wə́ bwə́ á ŋgə duu. ");
INSERT INTO mcp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nə́ ndɛɛ́, Yésus nyə á ka zə wú Yudéa nə́ a kə́ Galilê. ");
INSERT INTO mcp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nə́ ndɛɛ́, í á jɨɨ nə́ a lɨ́ɨ́nág Samaríya. ");
INSERT INTO mcp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A mú kə wɔ́ɔ́s ŋgwə́la á Samaríya bwə́ dʉ jɔ̂w nə́ Sikâr yí, ŋgwə́la wɔɔŋg í njúl kúnə́-kúnə nə fambə́ *Yákwab nyə á yə mwán yé Yósɛb yí. ");
INSERT INTO mcp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Bwûŋ mə Yákwab í njúl cínɔŋg. Yésus nyə á ka bə a mə́ tag nə njɔɔnd, a mú kə ji shí bwííndɛ lʉ́ taambʉd. Í á bə na, jwɔ́w í mú ŋgɛɛ tɔ́lɔ́g dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A njúl na ntʉ́nɨ, ŋgwɔ́l mudá á Samaríya mú wɔ́ɔ́s nə́ a zə́ dɔ̧ mə́júwó. Yésus mú cɨ nə nyə nə́: «Yə́g mə məjúwó mə́ ŋgul.» ");
INSERT INTO mcp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Í á bə ompwíín bwə́ mə́ kə ŋgwə́la nə́ bwə́ kə́ kusə ídʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mudá á Samaríya mú cɨ nə Yésus nə́: «Nə́ jɨ? Wo mwâ *Yúdɛn, wo bə́lɛ́ gwáámb mə shilə Samaríya məjúwó? Jâŋ í ámə tɛ́ na ntʉdɛl?» Mpugá nə́ *Oyúdɛn bə́nɔ̂ŋ nə buud ɔ Samaríya bwə́ ádɛ́ bə nə wɔ́ŋgɔ́. ");
INSERT INTO mcp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yésus mú bɛ̧sa nə nyə nə́: «Wo ampúyɛ́ sâ Zɛmbî mə́ yána yí, wo kú mpu múúd ŋgə́ gwáámb wo məjúwó yɛ́. Wo mbə̂m mpu, ŋki wo wə́ mə́ yida gwáámb nyə məjúwó, a mú yə wo məjúwó mâ cʉg.» ");
INSERT INTO mcp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mudá mú cɨ nə nyə nə́: «Cwámba, taamb jɨ́ nə gwaálə shí, wo ntâg kú nə dɔ̧ɔ̧la; wo é ka ŋwa məjúwó mâ cʉg ŋgow? ");
INSERT INTO mcp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ye wó bul bə fwámɛ́ múúd ntɔ̧ mpáámbə́ jísʉ́ Yákwab muud nyə á yə sə́ taamb ga yɛ́? Nyəmɛ́fwó nyə á ŋgul məjúwó mâ wa, bwán bɛ́ ŋgul nə́mə́, tɔɔ iwoo byé.» ");
INSERT INTO mcp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yésus mú bɛ̧sa nə nyə nə́: «Muud yɛ̂sh mə ŋgúl mə́júwó mə́ga yɛ́, nyə é nyiŋgə gwág shwáásʉ́lə minʉ́; ");
INSERT INTO mcp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","njɨ, muud mə bá ŋgul mə́júwó mə́ bá yə nyə yɛ́, nyə abʉ́lɛ nyiŋgə bwɛlɛ gwág shwáásʉ́lə minʉ́, məjúwó mɔɔŋg mə́ bá bə nyə bwûŋ í bá dʉ wééshʉli məjúwó cé cʉg.» ");
INSERT INTO mcp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mudá nə́: «Cwámba, yə́g mə məjúwó mɔɔŋgʉ̂ mə bág bə kú ná nyiŋgə gwág shwáásʉ́lə minʉ́, mə nda ná bá nyiŋgə jɨɨ nə́ mə zə́ dɔ̧ mə́júwó wa.» ");
INSERT INTO mcp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yésus nə nyə nə́: «Kaá jɔ̂w ŋgwûm woó, bɨná zə́g.» ");
INSERT INTO mcp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mudá nə́: «Mə cugɛ́ nə ŋgwûm.» Yésus nə nɛ́ nə́: «Wo mə́ mpu cɨ nə́ wo cugɛ́ nə ŋgwûm. ");
INSERT INTO mcp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nəcé wo a mə́ bə nə ogwûm ótɔ́ɔn, nyɔɔŋg wó jɨ́ nə ndɨ́ ja gaád yɛ́ cugɛ́ ŋgwûm woô. Wo mə́ bwiiŋg bʉ́bə́lɛ́ na.» ");
INSERT INTO mcp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mudá mú cɨ nə nyə nə́: «Cwámba, mə dʉ́g nə́ wo jɨ *muud micúndə́. ");
INSERT INTO mcp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Odâ bwə́ á dʉ yə Zɛmbî gúmə́ wa mbʉ́ŋ gaád; bɨ bâŋ mə́ cɨ nə́ Yurʉ́səlɛm wə́ búúd bwə́ kə́g dʉ nyə gúmə́ yɛ́». ");
INSERT INTO mcp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yésus mú cɨ nə nyə nə́: «Amuda, *magʉləg sâ mə́ cɨ́ yí. Dúl wəla í bá zə bə, í bá bə, bɨ kú ná dʉ yə Dâ gúmə́ wa mbʉ́ŋ gaád, kú nə́mə́ nyiŋgə bə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bɨ́ ŋgə kənd gúmə́ kʉ́l bɨ́ ampúyɛ́ yí; sə́ bâŋ sə́ ŋgə kənd kʉ́l sə́ mə́ mpú yí, nəcé cʉgʉshílə Zɛmbî ŋgə́ cʉgʉshi buud yí í ŋgə ciŋgya Oyúdɛn dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Njɨ, dúl wəla í bá zə bə, wəla dɔɔŋg ntâg nə́mə́ wə́ga, wəla á nə́ fwámɛ́ búúd bwə́ yə Dâ gúmə́ wá bwə́ é yə nyə gúmə́ nə *shíshim nə obʉ́bə́lɛ́. Váál búúd i yə nyə gúmə́ ntɔ́ wə́ Dâ ŋgə́ sɔ̧́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Zɛmbî jɨ shíshim, buud bwə́ yə nyə gúmə́ wá bwə́ jəlá nə yə nyə gúmə́ nə shíshim, nə obʉ́bə́lɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mudá mú cɨ nə nyə nə́: «Mə mpú nə́ Mesî zag, nyə wə́ bwə́ ŋgə́ jɔ̂w nə́ *Krîst yɛ́. Ja á bá ntâg zə yí, a bá zə jaaw sə́ isâ byɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yésus ntâg nə nɛ́ nə́: «Mə wɔɔŋg wə́ ŋgə́ lésha nə wo ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ompwíín bɛ́ bwə́ mú ntâg wɔ́ɔ́s, bwə́ mú ŋgə káam nə́ Yésus ŋgə lésha nə mudá; njɨ, tɔɔ muud nyə a shígɛ́ jî nyə nə́: «Wo ŋgə jɨɨ jɨ́?» Ŋkí ntâg nə́: «Nəcé jɨ́ wó ŋgə́ lésha nə nyə yí?» ");
INSERT INTO mcp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mudá mú lʉ́gə dɔ̧ɔ̧la jé na, kyey kə kwáádə́ kə jɔ̂w búúd nə́: ");
INSERT INTO mcp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Zəgá kə dʉ́g ŋgwɔ́l múúd mə́ jaaw mə sâ jɛ̂sh mə́ á sá yí, ye í cúgɛ́ je bə Krîst ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Buud bwə́ mú tɨ́ kwáádə́, kə kɔ́ɔ́mb Yésus nyə á bə yí. ");
INSERT INTO mcp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Té nɨ, ompwíín bwə́ mú ŋgə jəgʉla nə Yésus nə́: «*Rabi, daág.» ");
INSERT INTO mcp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nyə ntâg nə bwo nə́: «Mɛɛ jɨ nə́ mə də́g idʉ̂w bɨ́ ampúyɛ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ompwíín bwə́ mú ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Ŋgwɔ́l múúd nyə ámə zə yə nyə bíl ídʉ̂w?» ");
INSERT INTO mcp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yésus nə bwo nə́: «Idʉ̂w byâm wə́ mə sáág sâ múúd nyə á ntɨ mə yɛ́ mə jɨ́ɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ŋgaá bɨ́ ŋgə cɨ nə́ í mə́ lʉ́g óŋkwoond onɔ̧̂ nə́ fwála bwə́ jə́lá nə saag ífambə́ yí í wɔ́ɔ́sʉ́g ɨɨ́? Ʉhʉ́ʉ. Mɛɛ mə́ ka cɨ nə́: Kəndʉgá mísh bɨ dʉ́gʉ́g, idʉ̂w í mə́ shîn wɨ̂y ífambə́, í mú fwála lʉ́ mə́saag. ");
INSERT INTO mcp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muud məsaag mú ŋgə bwey ŋwa myə́na, a ŋgə sɛɛŋg mpumə́ shú cʉg á kandʉgə kandʉgə; nə́ ndɛɛ́, mbɔɔl məmpəg bá bɛ̂sh muud məsaag bwə́ gwág məshusʉg mbií ŋgwûd. ");
INSERT INTO mcp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wúl kaanə́ í dʉ cɨ nə́: muud mə bɛ̧́ mpəg yɛ́, nə yé; nyɔɔŋg mə sáag yɛ́, nə yé. Sâ kaanə́ wɔɔŋg ŋgə́ cɨ yí jɨ́ bʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mə á kənd bɨ́ nə bɨ kə́g saag ídʉ̂w kʉ́l bɨ́ áshígɛ́ wéénd gúŋ yí. Bɔ́ɔ́l bwə́ á sɛ̂y, bwə́ wéénd gúŋ; bɨ bâŋ mú kə saag ígúŋ byáŋʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Zhwog buud wâ ŋgwə́la Samaríya wɔɔŋg bwə́ á *búgʉla Yésus nəcé bwaagʉlə́lə múdá nyə́ á bwaagʉlə nə́: «A mə́ jaaw mə sâ jɛ̂sh mə́ á sá yí». ");
INSERT INTO mcp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nə́ ndɛɛ́, ja búúd ɔ Samaríya bwə́ á zə wɔ́ɔ́s wə́ Yésus yí, bwə́ á jəgʉla nə nyə nə́ a jíg na bwə́dɨ́; a mú ja cínɔŋgʉ́ mwɔ̂w mə́bá. ");
INSERT INTO mcp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Buud bwə́ mú nyiŋgə jág bul zə búgʉla nəcé ŋgə̌lə gwág ciyá jé. ");
INSERT INTO mcp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bwə́ mú ŋgə cɨ nə mudá nə́: «Sə́ ŋgə búgʉla ja gaád nəcé sə́mɛ́fwó sə́ mə́ gwág nyə nə məlwə̂ mə́sʉ́, kú ná nyiŋgə bə nəcé bwiiŋgʉ́lə wô, sə́ mə́ ka mpu nə́ nyə wə́ jɨ́ bə́lɛ bə Cʉgye á shí ga.» ");
INSERT INTO mcp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mpʉ́sə mwɔ̂w mə́bá mə́nɨ, Yésus nyə á zə tɨ́ na, kə Galilê, ");
INSERT INTO mcp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","í njúl nə́ nyəmɛ́fwó nyə á bwey bwaagʉlə nə́: «Bwə́ ádɛ́ gúmal *múúd micúndə́ mə́ Zɛmbî nyə́dɨ́ kwáádə́». ");
INSERT INTO mcp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Njɨ, ja nyə́ á wɔ́ɔ́s Galilê yí, buud ɔ Galilê bwə́ á jɛɛnd nyə nəcé bwə́ á shí dʉ́g sâ jɛ̂sh nyə́ á sá Yurʉ́səlɛm fwála lʉ zâŋ yí. ");
INSERT INTO mcp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nyə á ka nyiŋgə kə Kana á Galilê, wú nyə́ á sá nə́ məjúwó mə́ nyɛ́ɛ́g məlwəg wá. Wúl lúlúú ósɔ́ɔl ɔ mə́sáal ɔ Njwú-buud í a bə Kapɛrnawûm, nyə á ka bə nə mwán ŋgə́ bwas. ");
INSERT INTO mcp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Muud ɛ́nɛ nyə á ka gwág nə́ Yésus mə́ wú Yudéa, a mə́ wɔ́ɔ́s Galilê. A mú kə nyə́dɨ́, kə jəgʉla nə nyə nə́ a shúləg kə, kə lwag nyə mwán, nəcé, nyə á ŋgə bə nə́ a zə yə. ");
INSERT INTO mcp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yésus mú cɨ nə nyə nə́: «Bɨ́ mə́ ká bə kú dʉ́g *mə́shimbá nə *isâ í mímbʉ́gú, bɨ́ kú *búgʉla?» ");
INSERT INTO mcp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Lúlúú ósɔ́ɔl ɔ mə́sáal mú cɨ nə nyə nə́: «Lɛɛlʉg kə té mwán nyə afwóyɛ́ yə mə yí». ");
INSERT INTO mcp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yésus mú cɨ nə nyə nə́: «Jeg kə, mwân woó ŋgə cʉgə.» Muud ɛ́nɛ mú *magʉlə ciyá Yésus nyə á cɨ nyə yí, a mú kyey. ");
INSERT INTO mcp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A ŋgə́ ná ka shulə kə, osɔ́ɔl ɔ mə́sáal bɛ́ bwə́ mú zə bwəma nə nyə, zə jaaw nyə nə́ mwán yé ŋgə cʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A mú jî bwo wəla bwas í ámə shîn mwán yí, bwə́ mú jaaw nyə nə́: «Nyúúl í ámə mpwambʉwo nyə nəkugʉ́ wəla ŋgwûd á tâm mwásə́.» ");
INSERT INTO mcp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sɔ́ɔ́ŋgʉ́ mwán mú yag nə́ wəla dɔɔŋg dɨ́ wə́ Yésus nyə ámə cɨ nə nyə nə́: «Mwân woó ŋgə cʉgə» yí; nə nyə, nə njɔ́w yé wɛ̂sh bwə́ mú búgʉla. ");
INSERT INTO mcp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Shimbá ábɛɛ̂ Yésus nyə a sá ja nyə á wú Yudéa nyiŋgə zə Galilê ɔ́nɨ. ");
INSERT INTO mcp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ja ísâ ínɨ í mə́ shîn yí, *Oyúdɛn bwə́ mú zə bə nə zaŋ. Yésus nyə á ka nə́mə́ kə Yurʉ́səlɛm zâŋ nyɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Gúl cwoogʉ́ í á ka dʉ bə nûŋ Yurʉ́səlɛm, bwə́ dʉ́gə́ jɔ̂w gwo hebʉrə̂ dɨ́ nə́ Bétɛ́sda. Cwoogʉ́ jɔɔŋg í á dʉ bə nə mənyíŋgʉ́lé mə́tɔ́ɔn, í njúl kúnə́-kúnə nə mpumbɛ́ bwə́ á gwiid nə́ Mpumbɛ́ Itɔw yí. ");
INSERT INTO mcp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ncúlyá mimbə̂l mí a ka dʉ já na mə́nyíŋgʉ́lé mə́nɨɨ́d, nə wəancím-ncîm, nə wə á ibúgʉ́lə í mə́kuú, nə bɔɔŋg bwə́ á bə nə bíl íkʉ́l í nyúúl í mə́ shwáámb wá. Bwə́ á dʉ já cínɔŋgʉ́ dʉ bwánd nə́ məjúwó mə́ búsʉlag. ");
INSERT INTO mcp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nəcé, ŋgwɔ́l *éŋgəles nyə á dʉ shulə cwoogʉ́d bíl íja, dʉ zə busal mə́júwó. Nə́ ndɛɛ́, mbə̂l í bwɛ́lɛ́ kʉl nyúúl cwoogʉ́d ja á mə́ busal yí, í yâl, tɔɔ nə́ dɛ́ bwas í á bə dáyɛ́ váál. ");
INSERT INTO mcp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŋgwɔ́l múúd nyə á ka bə cínɔŋgʉ́, bwas mə́ ji nyə nyúúlʉ́d mimbú məwûm mə́lɔ́ɔl nə mwɔɔmb. ");
INSERT INTO mcp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yésus mú dʉ́g muud ɛ́nɛ mbwúg; nda Yésus nyə á mpu nə́ a mə́ bwey nə bwas nə́, a mú jî nə́: «Ye wó cɛɛl yâl?» ");
INSERT INTO mcp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mbə̂l wɔɔŋg mú bɛ̧sa nə nyə nə́: «É yé Cwámba, mə cugɛ́ nə muud mə kʉ́l mə cwoogʉ́d ja mə́júwó mə́ ŋgə́ busʉla yí. Í dʉ bə, mə ŋgə́ ná nywá kə, ŋgwɔ́l múúd nywáá mə́ lɛɛl kə.» ");
INSERT INTO mcp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yésus mú cɨ nə nyə nə́: «Wɔɔlʉ́g, wo báágʉ́g taŋʉ́ gwô, wo kyéyʉg.» ");
INSERT INTO mcp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Muud wɔɔŋgʉ̂ mú yâl nə́mə́ cé nə cé, a mú báág taŋʉ́ jé nə́ ndɛɛ́ tɛ́ɛ́d njɔɔnd. Isâ ínɨ í á ŋgə sɨ̂y jwɔ́w lʉ́ Sábaad. ");
INSERT INTO mcp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oyúdɛn bwə́ mú ka cɨ nə muud nyə á yâl ɛ́nɛ nə́: «Sábaad wə́ ɛ́ga, jísə wo ci nə́ wo kú ŋkɛ̂ny taŋʉ́ gwô.» ");
INSERT INTO mcp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A mú bɛ̧sa nə bwo nə́: «Muud nyə ámə lwag mə yɛ́ nyə ámə cɨ nə mə nə́: “Ŋwag taŋʉ́ gwô wo kyéyʉg”». ");
INSERT INTO mcp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bwə́ nə nɛ́ nə́: «Nyáyɛ́ múúd nyɛ nyə ámə cɨ nə wo nə́: “Ŋwagʉ́ taŋʉ́ gwô wo kyéyʉg” ɛ́nɛ?» ");
INSERT INTO mcp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Njɨ, muud nyə á yâl yɛ́ nyə a shígɛ́ ná mpu múúd wɔɔŋgʉ̂; í á bə Yésus mə́ nyɔɔs cínɔŋg búúd bwə́ á bə áncuncuma wá. ");
INSERT INTO mcp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ja fwála í á cɔ̧́ yí, Yésus mú kə kwey múúd ɛ́nɛ *Luŋ mə́ Zɛmbî, a mú cɨ nə nyə nə́: «Wɛy, wo mə́ yâl dɨ́? Wo kú ná nyiŋgə sá *sə́m, wo a bá bwəma nə sâ í búl yáág yí.» ");
INSERT INTO mcp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Muud ɛ́nɛ mú kə jaaw Oyúdɛn nə́ Yésus wə́ nyə ámə lwag nyə. ");
INSERT INTO mcp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oyúdɛn bwə́ mú tɛ́ɛ́d nə́ bwə́ lwágʉlə Yésus cúwʉ́lí, nəcé a sálə sɔ́ɔ́lʉ́gʉ́ nɨ jwɔ́w lʉ́ Sábaad. ");
INSERT INTO mcp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Njɨ Yésus nyə á bɛ̧sa nə Oyúdɛn bɔɔŋg nə́: «Dâ ŋgə ná sɛ̂y zə wɔ́ɔ́s fwála gaád; mɛɛ mə sɛ́y nə́mə́.» ");
INSERT INTO mcp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ja nyə á mɛɛl cɨ ntʉ́nɨ yí, Oyúdɛn bwə́ mú nyiŋgə bul sɔ̧́ nə́ bwə́ gwú nyə; kú bə njɨ nəcé á dʉ yád Sábaad ɨɨ́, nyə á nyiŋgə nə́mə́ cɨ nə Zɛmbî jɨ Sɔ́ɔ́ŋgʉ́ yé, ntɔ́ jɨ nə́ a ŋgə tə̂l nyəmɛ́fwó cé ŋgwûd nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yésus nyə á ka bɛ̧sa nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, Mwân cugɛ́ nə ŋkul sá sâ nə lúú yé, a sá nə́mə́ njɨ sâ á dʉ́g Dâ mə́ sá yí. Sâ jɛ̂sh Dâ mə́ sá ntâg yí, Mwân mə́ sá nə́mə́ gwo. ");
INSERT INTO mcp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nəcé Dâ ŋgə cɛɛl Mwân, a ka ŋgə lwágʉlə nyə sâ jɛ̂sh á ŋgə́ sá yí; a bá nə́mə́ lwágʉlə nyə misɔ́ɔ́lʉ́gʉ́ mí nyiŋgə́ ntɔ̧ míga myá, bɨ́ ka bá káam. ");
INSERT INTO mcp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mpugá nə́, Dâ mə́ dʉ gwúmʉshi búúd, dʉ nyiŋgə yə bwo cʉg; mbií ŋgwûd wɔɔŋgʉ́, Mwân mə́ dʉ nə́mə́ sá nə́, muud á cɛɛl yə cʉg yɛ́, a yə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dâ nyə asámbɛ́ tɔɔ muud lə́sʉ́, nyə a mə́ yida yə Mwân ŋkul nə́ a dʉ́g cígal mílə́sʉ́ myɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","A sá ntɔ́ nə́ buud bɛ̂sh bwə́ gúmálʉ́g Mwân nda bwə́ gúmál Dâ nə́. Muud mə bə́ kú gúmal Mwân yɛ́, nyə agúmálɛ́ nə́mə́ Dâ muud nyə á ntɨ Mwân yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud mə gwágʉ́lə́ ciyá jâm a *búgʉla múúd nyə á ntɨ mə yɛ́, a mú nə cʉg á kandʉgə kandʉgə; nyə abʉ́lɛ nyiŋgə bwəma nə intʉ́gʉ́lí, a mə́ yida wú shwɨy dɨ́ kə cʉgʉd. ");
INSERT INTO mcp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, dúl wəla í bá zə bə, wəla dɔɔŋg ntâg nə́mə́ wə́ga, wəla mímbimbə mí bá gwág kə̂l mə́ *Mwân mə́ Zɛmbî yí. Bɔɔŋg bwə́ bá ntâg gwág dwo wá, bwə́ bá *bə nə cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mpugá nə́, Dâ jɨ amə́dɨ́ á cʉg, a mə́ ka nə́mə́ sá nə́ Mwân bə́g amə́dɨ́ á cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nda Mwân jɨ́ Mwân mə Múúd nə́, Dâ mə́ yə nyə ŋkul nə́ a dʉ́g sámb milə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kúgá káam sâ jɔɔŋg; nəcé dúl wəla í bá zə bə, wəla búúd bʉ́sə́ mə́shwoŋ dɨ́ wá bwə́ bá gwág kə̂l mə́ *Mwân mə Múúd yí. ");
INSERT INTO mcp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bɔɔŋg bwə́ bá bə nə́ bwə́ á sá mə́nywa wá, bwə́ bá gwûm mə́shwoŋ dɨ́, zə lə́g cʉg; bɔɔŋg bwə́ bá bə nə́ bwə́ á sá mə́bɔ̂w wá, bwə́ bá gwûm mə́shwoŋ dɨ́, zə bwəma nə intʉ́gʉ́lí. ");
INSERT INTO mcp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɛɛ, mə cugɛ́ nə ŋkul sá sâ nə lúú wâm, mə́ dʉ sámb mílə́sʉ́ nda mə́ dʉ gwág nə Pʉpá nə́; mə dʉ cígal mílə́sʉ́ tʉ́təlî, nəcé mə ádɛ́ sɔ̧́ nə́ mə sá sâ mə́ jɨ́ɨ́ yí, njɨ nə́ mə sá sâ múúd nyə á ntɨ mə yɛ́ ŋgə́ jɨɨ yí. ");
INSERT INTO mcp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Í mbə̂m bə nə́ məmɛ́fwó wə́ ŋgə́ bwiiŋg láŋ wâm, bwiiŋgʉ́lə wɔɔŋg í nda bə sá búúd bwə́ mágʉləg yí. ");
INSERT INTO mcp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ká, muud shús wə́ ŋgə́ bwiiŋg láŋ wâm, mə mpú ntâg nə́ bwiiŋgʉ́lə wɔɔŋg wúsə bʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bɨ á kənd buud wə́ Yuánɛs, nyə á shí ntâg bwiiŋg bɨ́ bʉ́bə́lɛ́ waamə̂. ");
INSERT INTO mcp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mɛɛ mə aŋgɛ̂ ntâg bwánd nə́ muud bwííŋgʉg láŋ wâm; mə ŋgə yida lás ntʉ́nɨ shú nə́ bɨ dʉ́gʉ́g cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuánɛs nyə á bə njidá lámba í á ŋgə kwan yí, bɨ á shí ntâg jɨɨ nə́ bɨ mə́ kɔɔs nə mə́ŋkɛnya mɛ́, njɨ í a bə njɨ bʉ́baalɛ́ fwála. ");
INSERT INTO mcp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mɛɛ jɨ nə wúl bwiiŋgʉ́lə í ŋgə́ bwiiŋg láŋ wâm, wâŋ í ntɔ̧ wɔɔŋg Yuánɛs nyə á bwiiŋg yí. Misɔ́ɔ́lʉ́gʉ́ Dâ nyə á yə mə ŋkul nə́ mə sáág myá, mə ŋgə sá myo, mí ŋgə́ bwiiŋg láŋ wâm nə́ Dâ wə́ nyə á ntɨ mə. ");
INSERT INTO mcp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dâ muud nyə á ntɨ mə yɛ́ nyəmɛ́fwó ŋgə bwiiŋg láŋ wâm. Bɨ abwɛ́lɛ́ gwág kə̂l dɛ́, kú bwɛlɛ dʉ́g mpwóómbʉ́ nyɛ́, ");
INSERT INTO mcp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ciyá jé í afwóyɛ́ ŋwa jiya bɨ́dɨ́ mílámʉ́d, nəcé bɨ aŋgɛ̂ nə búgʉla muud nyə á ntɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bɨ́ ŋgə sɔ̧́ nə́ bɨ mpúg micilyá myâ Kálaad Zɛmbî, bɨ ŋgə́ tə́dʉga nə́ bɨ é kwey cʉg á kandʉgə kandʉgə cínɔŋg; í njúl nə́ micilyá myɔɔŋg mí ŋgə bwiiŋg láŋ wâm. ");
INSERT INTO mcp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Njɨ bɨ acɛ́ɛ́lɛ́ zə mə́dɨ́ nə́ bɨ bə́g nə cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Mə aŋgɛ̂ nə jɨɨ nə́ buud bwə́ gúmálʉ́g mə. ");
INSERT INTO mcp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Njɨ, mə mpú bɨ̂, mə mpú nə́ milâm mín mí acɛ́ɛ́lɛ́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dâ wə́ nyə á ntɨ mə nyə́dɨ́ jínə́d, njɨ bɨ alə́gɛ́ mə; ŋkí ŋgwɔ́l múúd mə zə́ dɛ́ jínə́d ɨɨ́, bɨ́ yida lə́g nyɛ̂. ");
INSERT INTO mcp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bɨ bɨ́ nə ŋkul búgʉla na ntʉdɛlɛ́ bɨ ŋgə́ sɔ̧́ gúmə́ mənyúúl mə́ búúd dɨ̂? Bɨ cugɛ́ nə ŋkul búgʉla, nəcé bɨ aŋgɛ̂ nə sɔ̧́ gúmə́ í ŋgə́ zhu wə́ Zɛmbî á ŋgwûd nə ŋgwûd yí. ");
INSERT INTO mcp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kúgá ŋgə tə́dʉga nə́ mə bá shwə́man bɨ́ wə́ Dâ. Moyîz muud bɨ́ á mə́ kə kəl mílâm nyə́dɨ́ yɛ́, nyə wə́ mə́ bá shwə́man bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nəcé, bɨ mbə̂m ŋgə búgʉla Moyîz ɨɨ́, ŋki bɨ mə́ búgʉla nə́mə́ mə, nəcé láŋ wâm wə́ Moyîz nyə á cilə yí. ");
INSERT INTO mcp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ká, nda bɨ́ aŋgɛ̂ nə *magʉlə micilyá myɛ́ nɨ, bɨ é ka *magʉlə íciyá byâm na ntʉdɛl?» ");
INSERT INTO mcp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ja ísâ ínɨ í mə́ shîn yí, Yésus mú lɨ́ɨ́na máŋ mə́ Galilê bwə́ dʉ nə́mə́ jɔ̂w nə́ Tiberyad yí, kə faŋwíny. ");
INSERT INTO mcp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Buud bwə́ mú ŋgə bɛ̧ nyə áncuncuma, nəcé bwə́ á ŋgə dʉ́g a ŋgə́ lwag mimbə̂l mə́shimbád. ");
INSERT INTO mcp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A mú ka bád mbʉ́mbʉ́ŋʉ́d, kə ji shí wu gwɔ̂w, bə́nɔ̂ŋ *ompwíín bɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na jɨ ntâg nə́, *Oyúdɛn zaŋ *Páska nyáŋ í mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yésus nyə á ka kənd mísh, a mú dʉ́g nə́ ncúlyá buud bwə́ ŋgə zə nyə́dɨ́, a mú ka jî Fílíp nə́: «Sə́ é ka kusə íbʉlɛ́d ŋgow nə́ buud ɔ́ga bwə́ də́g?» ");
INSERT INTO mcp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nyə á jî ntɔ́ nə́ a gwágʉ́lə ná nda Fílíp nyə é cɨ nə́, nyə á ŋgə bwey mpu sâ á zə́ sá yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fílíp mú bɛ̧sa nə nyə nə́: «Sə́ tɛɛm kusə íbʉlɛ́d tâŋ odanarî mitəd mimbá, í nda kwaga nə bwo mbii á nə́ muud yɛ̂sh bə nə jé kʉ́kʉ́l.» ");
INSERT INTO mcp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nyɔɔŋg *mpwíín mə Yésus bwə́ á dʉ jɔ̂w nə́ Andrê yɛ́, mínyɔŋʉ̂ mə́ Shímun Pyɛ̂r mú cɨ nə nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Gúl ncúncwə́má jɨ́ nə ibʉlɛ́d itɔ́ɔn wa, ibʉlɛ́d i *orzhə, nə oshú óbá; ká bímbí dɔɔŋg dɨ́ nə ŋkul ka sá zhwog buud ɔ́ga jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yésus mú cɨ nə́: «Jilʉgá buud shí.» Zhwog ákánda nyə á bə kʉ́kʉ́l jɔɔŋgʉ́d, buud bwə́ mú shîn ji shí, je bə búúd otɔ́ɔ́shin otɔ́ɔn lɔ̧́lə njɨ budûm. ");
INSERT INTO mcp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yésus mú ŋwa íbʉlɛ́d, a mú yə Zɛmbî akíba nə́ ndɛɛ́ a mú kaaw búud bwə́ á bə cínɔŋg wá. A mú nə́mə́ sá nə oshû ntɔ́, a yə bwo bímbí bwə́ á jɨɨ yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ja búúd bwə́ mə də nə́ ndɛɛ́ jílə yí, a mú cɨ nə ompwíín bɛ́ nə́: «Kwɔ́sʉ́gá ikʉ́l í mə́ lʉ́g yí, í kú bə sâ yúúdʉ́gʉ́.» ");
INSERT INTO mcp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bwə́ mú kwɔ́s íkʉ́l í íbʉlɛ́d í á lʉ́g ja búúd bwə́ á shîn də yí, í mú lwánd mə́bwumú wûm nə mə́bá. ");
INSERT INTO mcp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ja búúd ɔ́nɨ bwə́ mə́ dʉ́g Yésus mə́ sá *shimbá yí, bwə́ mú ŋgə cɨ nə́: «Bʉ́bə́lɛ́, *muud micúndə́ nyə á bə nə́ a bá zə shí ga dɨ́ ɔ́nɨ». ");
INSERT INTO mcp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nda Yésus nyə á ka mpu nə́ bwə́ é zə ŋwa nyə nə́ bwə́ kə́ tə̂l nyə njwú-buud nə́, nyə á kyey, kə nyiŋgə bád mbʉ́mbʉ́ŋʉ́d nyəmɛ́fwó kú nə muud. ");
INSERT INTO mcp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mpwó-kugʉ́, *ompwíín bɛ́ bwə́ mú shulə kə mâŋ. ");
INSERT INTO mcp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bwə́ mú kəwa byɔ́ɔ́lʉ́d, tɨ́ kə faŋwíny, Kapɛrnawûm. Í á bə yídʉ́gʉ́ í mə́ bii shí, Yésus kú fwo nyiŋgə sɛɛŋgya nə bwo sámbá. ");
INSERT INTO mcp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yáág-yáág ŋkwɔ̧̂ nyə á ka zə kuŋg, ikwɔ̧́ tɔ̂w máŋ nə́ shwuu. ");
INSERT INTO mcp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bwə́ mú ka ŋgə júgə nə́ ndɛɛ́, ja bwə́ mə́ kə shwóg je bə ókílomáda otɔ́ɔn ŋkí ósaman yí, bwə́ mú dʉ́g Yésus ŋgə́ kyey mə́júwó dɨ́ gwɔ̂w, a ŋgə́ shísh kúnə́-kúnə nə byɔ́ɔl dáŋ; bwə́ mú gwág íkukwɛndɛ. ");
INSERT INTO mcp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yésus mú cɨ nə bwo nə́: «Mə wə́ ɛ́nɛ, kúgá fúndə.» ");
INSERT INTO mcp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bwə́ mú cɛɛl ŋwa nyə byɔ́ɔ́lʉ́d, njɨ byɔ́ɔ́l mú lɛɛl kumə́ bwûŋ, kʉ́l bwə́ á ŋgə kə yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mán mələ̂m, ncúlyá buud bwə́ á lʉ́g gúl kɔ́ɔ́mb mâŋ wá, bwə́ mú dʉ́g nə́ byɔ́ɔ́l í á bə cínɔŋgʉ́ njɨ ŋgwúdʉgʉ̂, dwó ntâg wə́ í á kə nə *ompwíín yí, Yésus nyə a shígɛ́ bád byɔ́ɔ́l dɔɔŋgʉ́d; ompwíín bwə́ á kə bwə́mɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Njɨ, mɔ́ɔ́lʉ́gá mɔ́ɔ́l mə́ á shí wú Tiberyad, nyiŋgə zə kúnə́-kúnə nə kʉ́l Cwámba nyə á yə Zɛmbî akíba nə́ ndɛɛ́ bwə́ mú də yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ncúlyá buud ɔ́nɨ bwə́ mú dʉ́g nə tɔɔ Yésus, tɔɔ ompwíín bɛ́ bwə́ cúgɛ́ cínɔŋg. Bwə́ mú ntâg bád mɔ́ɔ́l mɔɔŋgʉ́d kə Kapɛrnawûm, kə sɔ̧́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bwə́ mú kə kwey nyə nûŋ mâŋ faŋwíny, bwə́ mú shilə nyə nə́: «*Rabi, wo ámə ka zə kʉ́ga jáyɛ́ ja?» ");
INSERT INTO mcp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yésus mú bɛ̧sa nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bɨ aŋgɛ̂ nə sɔ̧́ mə nəcé *məshimbá bɨ́ ámə dʉ́g má, bɨ́ ŋgə sɔ̧́ mə nəcé bɨ́ ámə də íbʉlɛ́d nə́ ndɛɛ́ jílə. ");
INSERT INTO mcp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kúgá ŋgə yáág nə́ bɨ bə́g nə idʉ̂w í dʉ kaag yí, yidagá yáág shú byɔɔŋg í kwíínd nə́ muud cʉ́gəg cʉg á kandʉgə kandʉgə yí; byó wə́ *Mwân mə Múúd mə bá yə bɨ́ yí. A bá yə bɨ́ byo nəcé a jɨ nyɔɔŋg Dâ nyə a wá məyɨɨgyé mə́ íjwûga yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bwə́ mú ka cɨ nə nyə nə́: «Yáág nə misɔ́ɔ́lʉ́gʉ́ mí Zɛmbî wə́ ntʉdɛl, sə́ sáág jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yésus nə bwo nə́: «Yáág nə sɔ́ɔ́lʉ́gʉ́ mə́ Zɛmbî wúsə nə́ bɨ búgʉ́lág muud Zɛmbî nyə á ntɨ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bwə́ nə nɛ́ nə́: «Wo mə́ fwo sá jáyɛ́ sâ í ntɔ̧́ buud fʉg nə́ sə́ dʉ́gʉ́g nə́ ndɛɛ́ sə́ mú *búgʉla wo? Wáyɛ́ sɔ́ɔ́lʉ́gʉ́ wo mə́ fwo sá yí? ");
INSERT INTO mcp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Osɔ́ɔ́ŋgʉ́ bʉ́sʉ́ bwə́ á dʉ də *mána ja bwə́ á bə shí a shwééshá dɨ́ yí, nə́mə́ nda jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́, nə́: “Nyə á yə bwo idʉ̂w í á ŋgə zhu joŋ dɨ́ yí”.» ");
INSERT INTO mcp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yésus mú cɨ nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, Moyîz nə́mə́ dɨ́ nyə á yə bɨ́ idʉ̂w í á dʉ zhu joŋ dɨ́ yí, Sɔ́ɔ́ŋgʉ́ waam wə́ mə́ yə́ bɨ́ fwámɛ́ ídʉ̂w í ŋgə́ zhu joŋ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Fwámɛ́ ídʉ̂w í Zɛmbî bísə byɔɔŋg í wú joŋ dɨ́, zə yə búúd ɔ shí cʉg yí.» ");
INSERT INTO mcp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bwə́ nə nɛ́ nə́: «Cwámba, dʉg yə sə́ idʉ̂w byɔɔŋgʉ́ ja jɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yésus mú cɨ nə bwo nə́: «Mɛɛ jisə idʉ̂w yâ cʉg. Muud mə zə́ mə́dɨ́ yɛ́, nyə abʉ́lɛ nyiŋgə bwɛlɛ gwág zha, muud mə búgʉ́lá mə yɛ́, nda nyiŋgə bwɛlɛ gwág shwáásʉ́lə minʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mə shí jaaw bɨ́ nə́, bɨ mə́ dʉ́g mə, njɨ bɨ aŋgɛ̂ nə *magʉlə. ");
INSERT INTO mcp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Búúd bɛ̂sh Dâ mə yə́ mə wá bwə́ é zə mə́dɨ́; mə abʉ́lɛ́ ntâg wɨ́ɨ́ŋg múúd mə zə́ mə́dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nəcé, mɛɛ mə á shulə wú gwɔ̂w nə́ mə zə́ sá sâ múúd nyə á ntɨ mə yɛ́ ŋgə́ jɨɨ yí, kú bə sâ mə́ ŋgə́ jɨɨ yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Muud nyə á ntɨ mə yɛ́, sâ á ŋgə́ jɨɨ yí jísə nə́, mə kú jímbal tɔɔ muud ŋgwûd á sámbá búúd nyə á yə mə yí, mə bág yida gwûmʉshi bwo jwɔ́w á məzhúgʉ́lâ. ");
INSERT INTO mcp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mə ŋgə cɨ nə́ sâ Dâ ŋgə jɨɨ yí jísə nə́, muud yɛ̂sh mə dʉ́g Mwân, a búgʉla nyə yɛ́, a bə́g nə cʉg á kandʉgə kandʉgə; mə ka bá gwûmʉshi nyə jwɔ́w á məzhúgʉ́lâ.» ");
INSERT INTO mcp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","*Oyúdɛn bwə́ á ka ŋgə cwadʉga nə Yésus, nə a cɨ́lə nə́: «Mə wə́ jísə́ ídʉ̂w í á wú joŋ dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bwə́ á ŋgə cwadʉga nə́: «Ŋgaá nyə wə́ Yésus mwân mə Yósɛb? Sə́ mə́ mpú dɨ́ sɔ́ɔ́ŋgʉ́ bá nyɔɔŋgʉ́? Ká, a zə ŋgə cɨ nə́: “Mɛɛ jisə idʉ̂w í á wú joŋ dɨ́ yí.”» ");
INSERT INTO mcp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yésus mú cɨ nə bwo nə́: «Kúgá ŋgə cwadʉga bɨmɛ́fwó nə bɨmɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Muud cugɛ́ nə ŋkul zə mə́dɨ́ té Dâ, muud nyə á ntɨ mə yɛ́, nyə afwóyɛ́ julə nyə yí. Dâ ká nə́mə́ ka julə múúd ɨɨ́, muud mú zə mə́dɨ́, mə ka bá gwûmʉshi nyə jwɔ́w á məzhúgʉ́lâ. ");
INSERT INTO mcp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ŋgaá jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: “Bɛ̂sh bwə́ bá ŋwa mínjɨ́ɨ́gʉ́lá wə́ Zɛmbî”. Kagá mpu nə́ muud yɛ̂sh mə́ gwág Dâ, a ŋwa njɨ́ɨ́gʉ́lá yé yɛ́, nyə é zə mə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ntɔ́ jɨ nə́ muud nyə abwɛ́lɛ́ dʉ́g Dâ; nə́mə́ njɨ muud nyə á zhu wə́ Zɛmbî yɛ́, nywáá wə́ nyə a dʉ́g Dâ. ");
INSERT INTO mcp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud mə búgʉla yɛ́ jisə nə cʉg á kandʉgə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mə wə́ jísə́ ídʉ̂w yâ cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Osɔ́ɔ́ŋgʉ́ bín bwə́ á dʉ də mána ja bwə́ á bə shí a shwééshá dɨ́ yí, njɨ bwə́ á shí yə. ");
INSERT INTO mcp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Idʉ̂w í ŋgə́ wú joŋ dɨ́ yí byáá, í ŋgə zə nə́, muud mə də́ byo yɛ́ kú bá yə. ");
INSERT INTO mcp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mə wə́ jísə́ ídʉ̂w yâ cʉg í ŋgə́ wú joŋ dɨ́ yí. Múúd mə ká də ídʉ̂w byɔɔŋgʉ́, a bá cʉgə kandʉgə kandʉgə. Idʉ̂w mə é yána yí bísə mishwun myâm, mə é yána myo shú nə́ buud ɔ shí ga bwə́ bə́g nə cʉg.» ");
INSERT INTO mcp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Oyúdɛn bwə́ mú ka bə nə zhuyâ bwə́mɛ́ nə bwə́mɛ́ bwə́ ŋgə́ shilə nə́: «Nyíga nyɛ jɨ nə ŋkul yə sə́ mishwun myɛ́ na ntʉdɛlɛ́ nə́ sə́ də́g?» ");
INSERT INTO mcp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yésus mú cɨ nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bɨ́ mə ká bə kú də míshwun mi Mwân mə Múúd, bɨ́ mə́ ká bə kú ŋgul mə́cií mɛ́, bɨ kú *bə nə cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Muud mə də́ míshwun myâm ŋgul mə́cií mâm yɛ́ músə nə cʉg á kandʉgə kandʉgə; mə bá gwûmʉshi nyə jwɔ́w á məzhúgʉ́lâ. ");
INSERT INTO mcp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nəcé, mishwun myâm mísə mpu bə ídʉ̂w, məcií mâm məŋgul. ");
INSERT INTO mcp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Muud mə də́ míshwun myâm, ŋgul mə́cií mâm yɛ́ mə́ nada nə mə, mə mə́ ŋwa jiya nyə́dɨ́ lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nda Dâ á cʉg nyə á ntɨ mə nə́, á ŋgə́ ntâg sá nə́ mə cʉ́gəg nə́, muud mə də́ mə yɛ́, mə wə́ mə é ŋgə sá nə́ a ŋgə́g nə cʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Idʉ̂w í á wú joŋ dɨ́ yí byáá í cúgɛ́ nda idʉ̂w ímpáámbə́ bín í á də yí. Bâŋ bwə́ á də, njɨ bwə́ á shí yə. Muud mə də bíga yɛ́, nywáá mə́ bá cʉgə kandʉgə kandʉgə.» ");
INSERT INTO mcp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Lə́sʉ́ Yésus nyə lás ja nyə á ŋgə yə buud minjɨ́ɨ́gʉ́lá wə́nɨ, nyə á ŋgə yə buud minjɨ́ɨ́gʉ́lá myɔɔŋg *mpáánzə́ minjɨ́ɨ́gʉ́lá á Kapɛrnawûm. ");
INSERT INTO mcp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ja ompwíín bɛ́ bwə́ á gwág lə́sʉ́ yé wɔɔŋg yí, bɔ́ɔ́l ŋkí bulya bwə́ á cɨ nə́: «Wʉ́nɨ lə́sʉ́ í bul nyaan, muud cugɛ́ ná nə ŋkul ŋgə nyiŋgə gwágʉlə wə.» ");
INSERT INTO mcp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yésus mú mpu nə́ ompwíín bɛ́ bwə́ ŋgə cwadʉga, a mú jî bwo nə́: «Lə́sʉ́ wâm í mə́ kwal bɨ́ bɔɔgʉ́? ");
INSERT INTO mcp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bɨ mbə̂m ka mɛɛl dʉ́g Mwân mə Múúd ŋgə́ bád kə kʉ́l nyə á fwo dʉ bwey bə yí, í ka bə nə? ");
INSERT INTO mcp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Shíshim mə́ Zɛmbî wə́ í dʉ sá nə́ muud cʉ́gəg, ŋkul mə múúd í ádɛ́ kwíínd tɔɔ sâ. Lə́sʉ́ mə́ ŋgə́ lás nə bɨ́ nɨ wúsə shú nə́ Shíshim mə́ Zɛmbî í zə́g bɨ́dɨ́ zə yə bɨ́ cʉg. ");
INSERT INTO mcp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Njɨ, bɔ́ɔ́l búúd wâ na bɨ́dɨ́ bwə́ aŋgɛ̂ nə magʉlə mə.» Yésus nyə á cɨ ntʉ́nɨ nəcé, tɛ́ɛ́d jwɔ́w nyə á tɛ́ɛ́d yə́lə búúd minjɨ́ɨ́gʉ́lá yí, nyə á bwey ŋgə mpu buud bwə́ áshígɛ́ ŋgə magʉlə nyə wá, a bwey nə́mə́ mpu múúd mə bá kusha nə nyə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nyə á nyiŋgə nə́mə́ cɨ nə bwo nə́: «Muud cugɛ́ nə ŋkul zə mə́dɨ́, Dâ kú fwo sá nə́ nyâŋ zə́g.» ");
INSERT INTO mcp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tɛ́ɛ́d na fwála nɨɨ́d wə́ zhwog ompwíín bɛ́ bwə́ á wú nyə́dɨ́ gwooŋg dɨ́ kú ná nyiŋgə ŋgə kyey nə nyə yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yésus nyə á ka cɨ nə wa wûm nə óbá nə́: «Bɨ báá bɨ akyéyɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Shímun Pyɛ̂r mú bɛ̧sa nə nyə nə́: «Cwámba, sə́ é ká nyiŋgə kə wə́ zə́? Wɛɛ jɨ nə iciyá í dʉ yə búúd cʉg yí. ");
INSERT INTO mcp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sə́ mə́ magʉlə, sə́ mə́ mpu ntâg nə́ wo jisə Ŋkɛ̧́ŋkɛ̧̂ múúd mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yésus mú bɛ̧sa bwo nə́: «Ŋgaá mə wə́ mə a fɛ́ɛ́sh bɨ́ buud wûm nə óbá? Ká dʉgá, ŋgwɔ́l á na bɨ́dɨ́ jisə nə jamb.» ");
INSERT INTO mcp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nyə á ŋgə cɨ Yúdas, mwân mə Shímun Iskariyôt; nəcé, Yúdas nyə á tɛɛm bə muud á sámbá ómpwíín wûm nə óbá, nyə á bə nə́ nyə wə́ mə́ bá kusha nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ja ísâ ínɨ í mə́ shîn yí, Yésus mú kə ŋgə kyey Galilê. Nyə a shígɛ́ cɛɛl kə Yudéa, *Oyúdɛn bwə́ á ŋgə sɔ̧́ nə́ bwə́ gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Í á bə ntâg ɨɨ́, Oyúdɛn zaŋ nyáŋ bwə́ á dʉ jɔ̂w nə́ Zaŋ məbanda yí í mú kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yésus omínyɔŋʉ̂ bɛ́ bwə́ mú cɨ nə nyə nə́: «Wúg wa wo kə́g Yudéa, *ompwíín bwô bwə́ kə́g nə́mə́ dʉ́g mísɔ́ɔ́lʉ́gʉ́ wó ŋgə́ sá myá. ");
INSERT INTO mcp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ja múúd mə cɛ́ɛ́l nə́ bwə́ mpúg nyə yí, nyə ádɛ́ nyiŋgə ŋgə sá isâ ishwoó ishwoo. Məma mísɔ́ɔ́lʉ́gʉ́ wó ŋgə́ sá mínɨ, í jɨɨ nə́ wo lwóyág myo bəl-bə̂l dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Í á bə na, omínyɔŋʉ̂ bɛ́ bwə́mɛ́fwó nda *búgʉla nyə. ");
INSERT INTO mcp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yésus mú bɛ̧sa nə bwo nə́: «Fwála dâm í afwóyɛ́ bə; bɨ bâŋ bɨ bʉ́sə nə fwála ija byɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Buud ɔ shí ga bwə́ cúgɛ́ nə ŋkul mpii bɨ̂; bwə́ ŋgə mpii mɛ̂, nəcé mə ŋgə bwaagʉlə bwo nə́ bɔ̂w bwo misɔ́ɔ́lʉ́gʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bɨ báá kagá, mɛɛ mə akɛ́ɛ́ zâŋ nɨɨ́d, nəcé fwála dâm í afwóyɛ́ bwəma. ");
INSERT INTO mcp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ja nyə á shîn cɨ nə bwo ntʉ́nɨ yí, nyə á lʉ́g Galilê. ");
INSERT INTO mcp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yésus nyə á ka nə́mə́ zə bád kə zâŋ dɨ́ omínyɔŋʉ̂ bɛ́ bwə́ mə́ bwey kə. Nyə á kə nda muud ŋgə́ shwaaw yɛ́, kú bə bəl-bə̂l dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Oyúdɛn bwə́ á ŋgə sɔ̧́ nyə zâŋ dɨ́, bwə́ ŋgə́ jî nə́: «A jɨ ŋgow?» ");
INSERT INTO mcp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Buud bwə́ á ŋgə bul lás lə́sʉ́ yé íkínda dɨ̂; bɔ́ɔ́l bwə́ ŋgə́ cɨ nə́: «A jɨ jɔ̧ múúd», bɔ́ɔ́lʉ́gá nə́: «Mbɔ̂. A ŋgə yida kʉl buud jugʉ́». ");
INSERT INTO mcp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Njɨ, isâ ínɨ byɛ̂sh í á ŋgə bə, muud kú cwééd nyə nə́ kpwɔɔ́, bwə́ ŋgə́ fúndə *Oyúdɛn. ");
INSERT INTO mcp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Zaŋ í á ka zə wɔ́ɔ́s tʉ́tám. Yésus mú bád kə Luŋ mə́ Zɛmbî kə ŋgə yə buud minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Oyúdɛn bwə́ mú ŋgə káam nyə nə́: «Muud ɛ́ga nyə á mpu dʉ́ga bímbí lʉ́ kwas ntʉdɛlɛ́ nyɛ nda sá shikûl?» ");
INSERT INTO mcp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yésus mú bɛ̧sa bwo nə́: «Njɨ́ɨ́gʉ́lá mə́ ŋgə́ jɨ́ɨ́gʉli yí í áŋgɛ̂ nə zhu mə́mɛ́fwó dɨ́; í ŋgə zhu wə́ muud nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Múúd mə ká cɛɛl sá sâ Zɛmbî mə jɨ́ɨ́ yí, a ka mpu ŋkí njɨ́ɨ́gʉ́lá wâm í ŋgə zhu wə́ Zɛmbî, ŋkí mə ŋgə tɛ́ wo nə lúu. ");
INSERT INTO mcp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Muud mə́ dʉ tɛ́ íbwiiŋgyá nə lúu yɛ́, a dʉ sɔ̧́ nə́ gúmə́ í kə́g nyə́dɨ́; njɨ, muud mə sɔ̧́ nə́ gúmə́ í kə́g wə́ muud nyə á ntɨ nyə yɛ́, nywáá jisə tʉ́təlí, a cugɛ́ nə məshɨɨgâ. ");
INSERT INTO mcp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ŋgaá Moyîz nyə a shí yə bɨ́ *mbwoomb mə́cɛ̧ɛ̧? Njɨ, kú nə tɔɔ muud ŋgə́ baagʉlə mwo. Nəcé jɨ́ bɨ́ ŋgə́ sɔ̧́ nə́ bɨ mə gwú mə yí?» ");
INSERT INTO mcp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Buud bwə́ mú bɛ̧sa nə nyə nə́: «Jamb í ŋgə ntágʉlə wo. Zə́ ŋgə́ sɔ̧́ nə́ a gwú wo?» ");
INSERT INTO mcp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yésus mú bɛ̧sa nə bwo nə́: «Mɛɛ mə a sá njɨ sɔ́ɔ́lʉ́gʉ́ ŋgwûd, í mə́ tɨ́ bɨ́ məkuú shí. ");
INSERT INTO mcp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ŋgaá Moyîz nyə á cɨ nə́ bɨ dʉ́g sá ábɨwáág, í njúl nə́ nyə dɨ́ nyə a tɛ́ɛ́d dʉ́lə sá ábɨwáág, odâ wə́ bwə́ á tɛ́ɛ́d. Njɨ, nda Moyîz nyə á cɨ nə́ bɨ dʉ́g sá nə́, bɨ mú dʉ sá ábɨwáág wɔɔŋgʉ́ tɔɔ jwɔ́w lʉ́ Sábaad. ");
INSERT INTO mcp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bɨ mə́ magʉlə nə́ bɨ é dʉ sá ábɨwáág jwɔ̂w lʉ́ Sábaad, nəcé bɨ acɛ́ɛ́lɛ́ caam cɛ̧ɛ̧ mə́ Moyîz; ká nəcé jɨ́ bɨ́ mə́ gwág bɔ̂w ja mə́ lwág múúd ncindî jwɔ̂w lʉ́ Sábaad yí? ");
INSERT INTO mcp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kúgá ná dʉ ŋwa ísâ njɨ váál bɨ́ ŋgə́ dʉ́g yí, dʉgá ŋwa ísâ váál í jə́la yí.» ");
INSERT INTO mcp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bɔ́ɔ́l búúd ɔ́ Yurʉ́səlɛm bwə́ á ka ŋgə cɨ nə́: «Ŋgaá muud bwə́ ŋgə́ sɔ̧́ nə́ bwə́ gwú wə́ ɛ́ga? ");
INSERT INTO mcp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ká dʉgá, nywáá ŋgə lás bəl-bə̂l dɨ̂, bwə́ nda cɨ nyə tɔɔ sâ. Ye micî mísʉ́ mí mə́ mpu fwámɛ́ mpu nə́ nyə wə́ jísə́ *Krîst e? ");
INSERT INTO mcp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sə́ bâŋ sə́ mə́ mpú kʉ́l múúd ɛ́ga ŋgə́ zhu yí, í njúl nə́, ja Krîst mə bá zə yí, muud nyə abʉ́lɛ mpu kʉ́l á bá zhu yí.» ");
INSERT INTO mcp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nə́ ndɛɛ́, Yésus ŋgə́ yə buud minjɨ́ɨ́gʉ́lá *Luŋ mə́ Zɛmbî, a mə́ shwal cɨ gwɔ́w-gwɔ̂w nə́: «Bɨ mə mpú mə ɛ̧ɛ̧́? Bɨ́ mpu nə́mə́ kʉ́l mə́ ŋgə́ zhu yí! Ká mə a shígɛ́ zə nə lúu wâm, muud nyə á ntɨ mə yɛ́ jisə abúgʉ́lág; njɨ bɨ ampúyɛ́ nyə. ");
INSERT INTO mcp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mɛɛ mə mpú nyə, mə ŋgə zhu nyə́dɨ́, nyə wə́ nyə a ntɨ mə.» ");
INSERT INTO mcp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Njɨ nyə á lás ntʉ́nɨ yí, bwə́ mú ŋgə sɔ̧́ məzhɨɨ́ nə́ bwə́ bii nyə; njɨ, muud nyə a shígɛ́ kúnya nə nyə, í á bə wəla dɛ́ kú fwo wɔ́ɔ́s. ");
INSERT INTO mcp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Í á ka bə na mə́ŋkúmbə mə búúd mə́nɨ dɨ nə́, bɔ́ɔ́l ŋkí bulya bwə́ á *búgʉla nyə; bwə́ mú ŋgə cɨ nə́: «Ja Krîst mə bá zə yí, ye a bá nyiŋgə bul sá *mə́shimbá cɔ̧́ múúd ɛ́ga?» ");
INSERT INTO mcp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","*Ofarizyɛ̂ŋ bwə́ á ka gwág buud bwə́ ŋgə́ nyímbʉla ntɔ́ lúu mə́ Yésus dɨ̂. Bə́nɔ̂ŋ mílúlúú myâ ofada bwə́ mú kənd ífulísh nə́ bwə́ kə́g bii nyə. ");
INSERT INTO mcp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yésus mú cɨ nə́: «Sə́nɔ̂ŋ bɨ́ é ŋgə na bə fúfwálá nə́ ndɛɛ́, mə mú kə wə́ muud nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bɨ mə bá sɔ̧́ mə, kú kwey, nəcé bɨ́ cugɛ́ nə ŋkul bá kə kʉ́l mə́ bá bə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","*Oyúdɛn bwə́ mú ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Ŋgow á bá ka kə nə́ sə́ nda bá kwey nyə ɛ́nɛ? Ye a bá kə búúd bʉ́sʉ́ bwə́ á mə́ kə ŋgə ji mílɔɔm mí Ogʉrɛ̂k dɨ́ wá, kə ŋgə yə Ogʉrɛ̂k minjɨ́ɨ́gʉ́lá? ");
INSERT INTO mcp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A cɨ́ nə “Bɨ mə bá sɔ̧́ mə, kú kwey, nəcé bɨ́ cugɛ́ nə ŋkul bá kə kʉ́l mə́ bá bə yí.” Ntɔ́ mə́ kə́ nə́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jwɔ́w á məshíné, jwɔ́w zâŋ í ká dʉ busʉla yí, Yésus nyə a tɔ̂w tʉ́təlí a mú cɨ gwɔ́w gwɔ̂w nə́: «Ŋkí muud ŋgə gwág shwáásʉ́lə minʉ́, a zə́g mə́dɨ́ zə ŋgul. ");
INSERT INTO mcp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Muud mə búgʉ́lá mə yɛ́, məjúwó mâ cʉg mə́ é dʉ júg wú nyə lámʉ́d nda miŋgwɔ̧ɔ̧́, nə́mə́ nda Kálaad Zɛmbî ŋgə́ cɨ nə́.» ");
INSERT INTO mcp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ja nyə́ a ŋgə lás ntɔ́ yí, nyə á ŋgə cɨ Ŋkɛ̧́ŋkɛ̧̂ Shíshim í á bə nə́, buud bɛ̂sh bwə́ bá *búgʉla nyə wá bwə́ bá lə́g yí; í á bə, Ŋkɛ̧́ŋkɛ̧̂ Shíshim kú fwo zə nəcé Yésus nyə a shígɛ́ fwo ŋwa gúmə́. ");
INSERT INTO mcp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Í á ka bə, ja búúd bwə́ á gwág lə́sʉ́ yé nɨ yí, bɔ́ɔ́l bwə́ á ŋgə cɨ nə́: «Bʉ́bə́lɛ́, muud ɛ́ga wə́ jísə́ *Múúd micúndə́»; ");
INSERT INTO mcp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","bɔ́ɔ́l bâŋ nə́: «Krîst wə́ ɛ́nɛ», bɔ́ɔ́lʉ́gá ka ŋgə cɨ nə́: «Krîst cugɛ́ nə ŋkul zhu Galilê. ");
INSERT INTO mcp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ŋgaá Kálaad Zɛmbî ŋgə cɨ gúl kʉ́kʉ́lʉ́d nə́ *Krîst mə bá zhu mpwoŋ buud mə *Dávid dɨ̂? Ntɔ́ jɨ nə́ a bá zhu Dávid dɨ́ də́nd, Betʉlehɛm.» ");
INSERT INTO mcp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Buud bwə́ mú bə ícé íbá lúu mə́ Yésus dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bɔ́ɔ́lʉ́gá bwə́ mú ŋgə jɨɨ nə́ bwə́ bii nyə; njɨ, muud nyə a shígɛ́ kúnya nə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ifulísh í mə́ ka kə nyiŋgə. Mílúlúú myâ ofada bə́nɔ̂ŋ *Ofarizyɛ̂ŋ bwə́ mú jî bwo nə́: «Bɨ mə́ bə kú zə nə nyə? Nəcé jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ifulísh nə́: «Muud nyə afwóyɛ́ bwɛlɛ lás nda muud ɛ́nɛ.» ");
INSERT INTO mcp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ofarizyɛ̂ŋ ntâg nə́: «Bɨ mə́ nə́mə́ bɨ́d nə́ a kʉ́lʉg bɨ́ jugʉ́ ɛ̧ɛ̧́? ");
INSERT INTO mcp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ye bɨ mə́ fwo bwɛlɛ dʉ́g wúl cî ŋkí ŋgwɔ́l Farizyɛ̂ŋ mə *búgʉ́lá nyə? ");
INSERT INTO mcp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Zhwog buud bɨ́ ŋgə́ dʉ́g bwə́ ŋgə́ *búgʉla nyə ɔ́nɨ bwə́ ámpúyɛ́ mə́cɛ̧ɛ̧, bʉ́sə nə məlweemyâ.» ");
INSERT INTO mcp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛ̂m muud nyə á fwo kə wə́ Yésus yɛ́ nyə á bə sámbá mícî mínɨɨ́d; a mú ka cɨ nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ye məcɛ̧ɛ̧ mə́sʉ́ mə́ magʉlə nə́ shé yə́g muud məbɛ̧ɛ̧́ a kú fwo kaad, sə́ mpu sâ nyə ámə sá yí?» ");
INSERT INTO mcp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bwə́ nə nɛ́ nə́: «Wo á zhu nə́mə́ Galilê? Fwog ná mpu faas, wo ákweyɛ nə́ ŋgwɔ́l múúd micúndə́ nyə a mə́ bwɛlɛ zhu Galilê.» ");
INSERT INTO mcp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bwə́ mú bwɨ́lya, ŋgə kə bwə́dɨ́ mínjɔ́w. ");
INSERT INTO mcp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yésus nyɛ mú kə mbʉ́mbʉ́ŋ á wəolivyê. ");
INSERT INTO mcp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ná nə́mə́ mpʉ́mán mpʉ́mán, a mú nyiŋgə kə *Luŋ mə́ Zɛmbî, buud bɛ̂sh bwə́ mú kə nyə́dɨ́. A mú ji shí, tɛ́ɛ́d ŋgə́lə yə bwo minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nə́ ndɛɛ́, *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bə́nɔ̂ŋ *Ofarizyɛ̂ŋ bwə́ mú ŋgə zə nə ŋgwɔ́l múdá nə́ a mə́ biil mínɔɔmbʉd. Bwə́ mú zə nə nyə zə tə́l cwánʉ́d, ");
INSERT INTO mcp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","bwə́ nə Yésus nə́: «Yɨ́ɨ́gʉli, mudá ɛ́ga nyə ámə biil a ŋgə́ sá minɔɔmb. ");
INSERT INTO mcp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moyîz nyə á yə sə́ ŋkul *mbwoomb mə́cɛ̧ɛ̧́d nə́ sə́ dʉ́g lúmə váál búdá ɔ́ga məkwóógʉ́ nə́ ndɛɛ́ bwə́ fudə. Ká wɛɛ mə́ cɨ nə́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bwə́ á jî nyə ntʉ́nɨ bwə́ ŋgə́ bwéél nə́, ka nyə é cɨ gúl ciyá á lɨ́lɨŋgɨ̂ nə́ ndɛɛ́ bwə́ ɔ́ kə́ shwə́man nyə. Njɨ, Yésus mú nyɔ̂w shí, a mú ŋgə cilə nə nyinə́ jé mə́ndəlúd. ");
INSERT INTO mcp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bâŋ bwə́ mú ŋgə yáág ŋgə jî nyə. Nə́ ndɛɛ́, a mú bʉ̂n, a mú cɨ nə bwo nə́: «Muud nyə abwɛ́lɛ́ sá *sə́m na bɨ́dɨ́ sámbád yɛ́ tɛ́ɛ́dʉ́g ŋkɛ̂ny kwóógʉ́ lúmə nyə.» ");
INSERT INTO mcp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A mú nyiŋgə nyɔ̂w shí, ŋgə cilə mə́ndəlúd. ");
INSERT INTO mcp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ja búúd ɔ́nɨ bwə́ mə́ gwág nda Yésus mə́ cɨ nə bwo nə́, bwə́ mú ŋgə nyɔɔs ŋgwúd ŋgwúd nə́ ndɛɛ́ bɛ̂sh, tɛ́ɛ́d ócúmbá wɔ́ɔ́s óntombú. Yésus mú lʉ́g na nyəmɛ́fwó nə mudá tə́l cwánʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nə́ ndɛɛ́, Yésus mú nyiŋgə bʉ̂n, a mú cɨ nə mudá nə́: «Amuda, bwə́ mú ŋgow? Kú nə muud mə sámb nə́ wó jəlá nə yə?» ");
INSERT INTO mcp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mudá nə́: «Cwámba, kú nə muud.» Yésus ntâg nə nyə nə́: «Mə asámbɛ́ nə́mə́. Kyeyʉ́g, njɨ, wo kú ná nyiŋgə sá sə́m.» ");
INSERT INTO mcp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yésus mú nyiŋgə lás nə buud nə́: «Mə wə́ jísə́ mə́ŋkɛnya mə́ ŋgə́ kwan buud wâ shí ga má. Muud mə bɛ̧́ mə yɛ́ nyə abʉ́lɛ bwɛlɛ kyey yídʉ́gʉ́d, a bá yida bə nə məŋkɛnya mâ cʉg.» ");
INSERT INTO mcp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ja *Ofarizyɛ̂ŋ bwə́ mə́ gwág ntɔ́ yí, bwə́ mú cɨ nə nyə nə́: «Womɛ́fwó ŋgə bwiiŋg láŋ wô ntʉ́nɨ kú nə muud mə bwáágʉlə? Jínɨ bwiiŋgyá cúgɛ́ sâ búúd bwə́ mágʉləg yí.» ");
INSERT INTO mcp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A mú bɛ̧sa bwo nə́: «Tɛɛm bə nə́ məmɛ́fwó mə́ bwiiŋg láŋ wâm, bwiiŋgyá jâm jísə sá búúd bwə́ mágʉləg yí; mə mpú kʉ́l mə́ ŋgə́ wú yí, nə kʉ́l mə́ ŋgə́ kə yí. Bɨ bâŋ bɨ ampúyɛ́ kʉ́l mə́ ŋgə́ wú yí, nə kʉ́l mə́ ŋgə́ kə yí. ");
INSERT INTO mcp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bɨ́ ŋgə sámb milə́sʉ́ njɨ váál dʉ́n á buud; mɛɛ mə asámbɛ́ tɔɔ muud lə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Í ká ntâg bə nə́ mə sámb lə́sʉ́, sémbyé wâm bə tʉ́təlí, nəcé mə cugɛ́ mə́mɛ́fwó, sá Dâ muud nyə á ntɨ mə wə́ bʉ́sə́. ");
INSERT INTO mcp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ŋgaá jísə cilyá mə́cɛ̧ɛ̧ mʉ́nʉ́d nə́ buud bwə́ jəlá nə magʉlə bwiiŋgyá á buud obá? ");
INSERT INTO mcp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mə ŋgə bwiiŋg lâŋ wâm, Dâ muud nyə á ntɨ mə yɛ́ ŋgə́ nə́mə́ bwiiŋg.» ");
INSERT INTO mcp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bwə́ mú ka cɨ nə nyə nə́: «Shwóóŋgʉ̂ ji ŋgow?» Yésus nə bwo nə́: «Bɨ ampúyɛ́ tɔɔ mə, tɔɔ Sɔ́ɔ́ŋgʉ́ waamə̂. Bɨ mbə̂m mpu mə, ŋki bɨ mə́ mpu nə́mə́ Sɔ́ɔ́ŋgʉ́ waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yésus nyə á ŋgə lás ntʉ́nɨ a ŋgə́ yə buud minjɨ́ɨ́gʉ́lá *Luŋ mə́ Zɛmbî, a njúl kʉ́l kúm í á bə yí, muud kú sɛ́ɛ́mb mbwə́ nə́ á bii nyə. Bwə́ á shígɛ́ bii nyə nəcé í á bə wəla dɛ́ kú fwo wɔ́ɔ́s. ");
INSERT INTO mcp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yésus mú nyiŋgə cɨ nə bwo nə́: «Mə zə́ kyey, bɨ mə bá sɔ̧́ mə, njɨ bɨ mə bá yə bɨ njúl nə *sə́m wʉ́n. Bɨ cugɛ́ nə ŋkul kə kʉ́l mə́ zə́ kə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","*Oyúdɛn bwə́ mú ŋgə cɨ nə́: «Ja á ŋgə́ cɨ nə́: “bɨ́ cugɛ́ nə ŋkul kə kʉ́l mə́ zə́ kə yí” nɨ, ye a zə́ gwɨ́ɨ́lya nyúúl?» ");
INSERT INTO mcp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A mú cɨ nə bwo nə́: «Bɨ bâŋ bɨ bʉ́sə buud ɔ shí ga, mɛɛ jisə muud a gwɔ̂w. Bɨ bâŋ shug dʉ́n dʉ́sə wa shí gaád, mɛɛ shug dâm cúgɛ́ wa shí gaád. ");
INSERT INTO mcp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gwə́ wə́ mə ámə cɨ́ nə bɨ́ nə́ bɨ mə bá yə nə misə́m mín yí. Nəcé, bɨ́ mə́ ká bə kú *magʉlə nə́ mə jisə, bɨ mə bá yə nə misə́m mín.» ");
INSERT INTO mcp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bwə́ mú jî nyə nə́: «Wo wə́ zə́?» Yésus mú bɛ̧sa bwo nə́: «Mə jisə nda mə́ ŋgə́ bwey jaaw bɨ́ té sə́ ámə tɛ́ɛ́d yí nə́. ");
INSERT INTO mcp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mə jɨ nə zhwog isâ mə́ lás nə bɨ̂, nə byɔɔŋg bísə́ nə́ mə sámbʉ́g yí. Njɨ, muud nyə á ntɨ mə yɛ́ jisə bʉ́bə́lɛ́, mə ŋgə ntâg jaaw buud sâ mə á gwág nə nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bwə́ á shígɛ́ gwág na nə́ nyə á ŋgə cɨ Zɛmbî Sɔ́ɔ́ŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yésus mú ka cɨ nə bwo nə́: «Ja bɨ́ mə́ bá bʉ̂n *Mwân mə Múúd yí, bɨ mə́ bá ka mpu nə́ mə jisə, mə aŋgɛ̂ nə sá tɔɔ sâ nə lúu wâm, mə ŋgə lás nə́mə́ nda Dâ nyə a jɨ́ɨ́gʉli mə nə́. ");
INSERT INTO mcp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sá muud nyə á ntɨ mə wə́ bʉ́sə́. Nyə a shígɛ́ lʉ́gə mə məmɛ́, nəcé mɛɛ mə́ dʉ sá njɨ sâ á jɨ́ nə ŋkul magʉlə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja Yésus nyə á ŋgə lás ntʉ́nɨ yí, zhwog buud bwə́ á *búgʉla nyə. ");
INSERT INTO mcp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yésus nyə á ka cɨ nə *Oyúdɛn bwə́ á *búgʉla nyə wá nə́: «Bɨ́ mə́ ká nada mə́dɨ́ íciyá dɨ, mpu nə́ bɨ bʉ́sə wámbʉlə bə *ómpwíín bâm, ");
INSERT INTO mcp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","bɨ́ ka mpu óbʉ́bə́lɛ́, obʉ́bə́lɛ́ bɔɔŋgʉ́ ka bá sá nə́ bɨ bə́g ofʉlî.» ");
INSERT INTO mcp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bwə́ mú bɛ̧sa nə nyə nə́: «Sə́ bʉ́sə mpwoŋ mə *Abʉraham, sə́ abwɛ́lɛ́ bə mə́lwaa mə múúd. Nəcé jɨ́ wó mpú cɨ nə sə́ nə́: “Bɨ́ ka bá bə ófʉlí” yí?» ");
INSERT INTO mcp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yésus mú bɛ̧sa bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud yɛ̂sh mə sá *sə́m yɛ́, jisə lwaá lʉ́ mísə́m. ");
INSERT INTO mcp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lwaá í ádɛ́ ntâg ji njɔ́w kandʉgə, mwân a njɔ́w nywáá mə́ dʉ ji kandʉgə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nə́ ndɛɛ́, Mwân mə Zɛmbî mə ká yîl bɨ́ mə́nyámád ɨɨ́, bɨ́ bə fwámɛ́ ófʉlî. ");
INSERT INTO mcp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mə mpú nə́ bɨ bʉ́sə mpwoŋ mə Abʉraham; ká bɨ́ ŋgə sɔ̧́ nə́ bɨ mə gwú mə, nəcé kɛ́ɛl dâm í áŋgɛ̂ nə jəla nə bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mɛɛ ŋgə jaaw sâ mə́ á dʉ́g wə́ Dâ yí; bɨ bâŋ ŋgə ntâg sá isâ bɨ́ á gwág nə sɔ́ɔ́ŋgʉ́ wʉ́n yí.» ");
INSERT INTO mcp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bwə́ mú bɛ̧sa nə nyə nə́: «Sɔ́ɔ́ŋgʉ́ wúsʉ́ wə́ Abʉraham.» Yésus ntâg nə bwo nə́: «Í mbə́m bə nə́ sɔ́ɔ́ŋgʉ́ wʉ́n wə́ Abʉraham ɨɨ́, ki bɨ́ ŋgə sá misɔ́ɔ́lʉ́gʉ́ Abʉraham nyə a sá myá. ");
INSERT INTO mcp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ká dʉgá, bɨ mú ŋgə cɛɛl gwú mə, í njúl nə́ mɛɛ mə́ jaaw bɨ́ bʉ́bə́lɛ́ mə́ á gwág nə Zɛmbî yɛ́. Abʉraham nyə a shígɛ́ sá ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bɨ́ ŋgə sá misɔ́ɔ́lʉ́gʉ́ mí sɔ́ɔ́ŋgʉ́ wʉ́n.» Bwə́ mú cɨ nə nyə nə́: «Sə́ cugɛ́ bwân wâ tɔ́ɔ́n, sə́ bʉ́sə nə sɔ́ɔ́ŋgʉ́ ŋgwûd jɨ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yésus nə bwo nə́: «Í mbə̂m bə nə sɔ́ɔ́ŋgʉ́ wʉ́n wə́ Zɛmbî, ki bɨ́ ŋgə cɛɛl mə, nəcé ja mə́ jɨ́ wa ga, mə á zhu nyə́dɨ́. Mə a shígɛ́ ntâg zə nə lúu wâm, nyə wə́ nyə á ntɨ mə. ");
INSERT INTO mcp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ká nəcé jɨ́ bɨ́ aŋgɛ̂ nə gwág lə́sʉ́ wâm yí? Jísə nəcé bɨ́ cugɛ́ nə ŋkul gwágʉlə kɛ́ɛl dâm. ");
INSERT INTO mcp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sɔ́ɔ́ŋgʉ́ wʉ́n wə́ Njwû məjamb, bɨ́ ka nə́mə́ ŋgə cɛɛl sá isâ sɔ́ɔ́ŋgʉ́ wʉ́n mə́ dʉ́ gwág yéésh yí. A jɨ ŋgwûl buud tɛ́ɛ́d mə́tɛ́ɛ́dʉ́léd; a cugɛ́ nə ŋkul bwɛlɛ bwiiŋg óbʉ́bə́lɛ́, nəcé obʉ́bə́lɛ́ bwə́ cugɛ́ nyə́dɨ́ cʉgʉd. Yé bwiiŋgʉ́lə íjɔ̧́ɔ̧́ í bwey nə́mə́ dʉ nyîn nə́ a jɨ amə́dɨ́ ijɔ̧́ɔ̧́, nəcé a jɨ mbíya njínjɔ̧́ɔ̧́, nyə wə́ ijɔ̧́ɔ̧́ sɔ́ɔ́ŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ká bɨ aŋgɛ̂ nə búgʉla mə nəcé mɛɛ ŋgə jaaw bɨ́ obʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Zə́ á na bɨ́dɨ́ jɨ́ nə ŋkul máalə mə nə́ mə mə́ sə̂m yɛ́? Ká, mɛɛ ŋgə́ jaaw bɨ́ obʉ́bə́lɛ́, bɨ mə́ ban ka *magʉlə mə nə jɨ́? ");
INSERT INTO mcp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Múúd mə ká bə yé mə́ Zɛmbî, a gwágʉlə mə́kɛ́ɛl mə́ Zɛmbî. Ká bɨ bâŋ bɨ agwágʉ́lə́yɛ́, nəcé bɨ́ cugɛ́ bɔɔŋg wə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Oyúdɛn bwə́ mú bɛ̧sa nə nyə nə́: «Sə́ shí mpu cɨ nə́ wo jɨ mwâ Samaríya, nə́ wo jɨ nə jamb.» ");
INSERT INTO mcp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yésus mú bɛ̧sa nə bwo nə́: «Mɛɛ cugɛ́ nə jamb, mɛɛ ŋgə gúmal Sɔ́ɔ́ŋgʉ́ waamə̂, bɨ bâŋ kú gúmal mə. ");
INSERT INTO mcp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɛɛ mə aŋgɛ̂ nə sɔ̧́ nə́ mə́ ŋwa gúmə́. Muud ŋgə́ sɔ̧́ nə́ mə bə́g nə gúmə́ yɛ́ jisə, nyə wə́ mə́ dʉ cígal mílə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, múúd mə ká bɛ̧ íciyá byâm, a kú bá bwɛlɛ yə.» ");
INSERT INTO mcp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bwə́ nə nɛ́ nə́: «Sə́ mə́ ka mpu ja gaád nə́ wo jɨ nə jamb. Abʉraham nyə á yə, *buud ɔ mícúndə́ yə; wɛɛ mə́ cɨ nə́: múúd mə ká bɛ̧ íciyá byâm, a kú bá bwɛlɛ yə. ");
INSERT INTO mcp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wɛɛ mə́ bul bə fwámɛ́ múúd ntɔ̧ sɔ́ɔ́ŋgʉ́ wúsʉ́ Abʉraham muud nyə á yə yɛ́? Wó ntɔ̧ nə́mə́ búúd ɔ mícúndə́ buud bwə́ á ŋgə yə wá? Wo ŋgə cɛɛl cɨ nə́ wo jɨ jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yésus mú bɛ̧sa nə́: «Mə́ ká ŋgə ŋwa gúmə́ məmɛ́fwó, í bə ntɔ́ cwag. Dâ wə́ ŋgə́ sá nə́ mə ŋwág gúmə́, nyə muud bɨ́ ŋgə́ kudə ibʉd nə́: “A jisə Zɛmbî wúsʉ́” yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bɨ ampúyɛ́ ntâg nə́mə́ nyə. Mɛɛ mə mpú nyə. Mə́ ká cɨ nə́ mə ampúyɛ́ nyə, mə bə njínjɔ̧́ɔ̧́ nda bɨ̂. Ká mɛɛ mə mpú nyə, mə ŋgə ntâg nə́mə́ bɛ̧ iciyá byé. ");
INSERT INTO mcp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sɔ́ɔ́ŋgʉ́ wʉ́n Abʉraham nyə á bwey kɔɔs nə məshusʉg nə tə́dʉ́gálə nə́ a bá dʉ́g jwɔ́w mə bá wɔ́ɔ́s yí; nyə a shí nə́mə́ dʉ́g jwɔ̂w dɔɔŋgʉ́, a kɔɔs ntâg nə mə́shusʉg». ");
INSERT INTO mcp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ja Oyúdɛn bwə́ mə́ gwág ntʉ́nɨ yí, bwə́ mú cɨ nə nyə nə́: «Wo afwóyɛ́ kumə mímbú məwúm mə́tɔ́ɔn, wó cɨ nə́ wo a dʉ́g Abʉraham ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yésus mú bɛ̧sa nə bwo nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, Abʉraham nda nə́mə́ fwo bə, mə jisə.» ");
INSERT INTO mcp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oyúdɛn bwə́ mú ntâg ŋkɛ̂ny mə́kwóógʉ́ nə́ bwə́ lúmə́ nyə; Yésus mú shwaaw nə́ ndɛɛ́, nyɔɔs cúwo tɔ́ɔ́n. ");
INSERT INTO mcp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yésus ŋgə́ cɔ̧́ ntʉ́nɨ, a mú dʉ́g ŋgwɔ́l múúd nə́ nyɛ nyə a byɛ̂l a njúl ancím-ncîm. ");
INSERT INTO mcp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","*Ompwíín bwə́ mú jî Yésus nə́: «*Rabi, ja múúd ɛ́nɛ nyə́ á byɛ̂l ancím-ncîm nɨ, í á bə nəcé *sə́m mə́ zə́, ye nyəmɛ́fwó sə́m yé, ye obyɔ̂l bɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yésus mú bɛ̧sa nə́: «Í á shígɛ́ bə nəcé sə́m, mbɔ̂; kú bə tɔɔ sə́m yé, kú nə́mə́ nyiŋgə bə sə́m obyɔ̂l bɛ́. Í á yida bə nə́ buud bwə́ dʉ́gʉ́g sâ Zɛmbî jɨ́ nə ŋkul sá yí na nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Í jɨɨ nə́ shé sáág isɛ́y í múúd nyə á ntɨ mə yɛ́, té mwásə́ wúsə́ ná yí. Bulú í zag, muud cugɛ́ ntâg nə ŋkul sɛ̂y mpwó-bulú. ");
INSERT INTO mcp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Té mə́ jɨ́ ná wa shí ga dɨ́ yí, mə wə́ jɨ́ mə́ŋkɛnya mə́ ŋgə́ kwan buud wâ shí ga má.» ");
INSERT INTO mcp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ja nyə á shîn cɨ ntʉ́nɨ yí, a mú sɛy mə́ntənd shí, a fugə mwo nə məndəlú nə́ ndɛɛ́, a bwiid áncím-ncîm ishwáfá byɔɔŋg míshʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A mú cɨ nə nyə nə́: «Kyeyʉ́g kə gusa cwoogʉ́ bwə́ jɔ̂w nə́ Siloy yí» (Siloy mə kə́ nə́: «muud lwámá»). Ancím-ncîm mú kə, kə gusa nə́ ndɛɛ́ a mú nyiŋgə a ŋgə́ dʉ́gya. ");
INSERT INTO mcp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nə́ ndɛɛ́, nə buud bə́nɔ́ŋ bwə́ á dʉ bə məbwugʉ́lu wá, nə bɔɔŋg bwə́ á dʉ dʉ́g a dʉ́gə́ gwáámb buud isâ wá, bwə́ mú ŋgə kə məshwán nə́: «Muud ɛ́ga dɨ́ nyə á dʉ ji wá a dʉ́gə́ gwáámb búúd isâ yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Í á ka bə, bɔ́ɔ́l bwə́ ŋgə́ cɨ nə́: «Jísə nyə», bɔ́ɔ́lʉ́gá nə́: «Mbɔ̂! A yida bɛ̧ɛ̧la nyə.» Nyəmɛ́fwó mú ŋgə cɨ nə́: «Jísə mə.» ");
INSERT INTO mcp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bwə́ mú jî nyə nə́: «Ntʉdɛlɛ́ mísh mə ámə bâŋ wo yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nyə nə bwo nə́: «Muud bwə́ ŋgə́ jɔ̂w nə́ Yésus yɛ́ nyə ámə fugə íshwáfá bwiid mə míshʉ́d, a mú cɨ nə mə nə́ mə kə́g gusa Siloy. Mə ámə ka nə́mə́ kə, kə gusa nə́ ndɛɛ́, mísh mə́ mú dʉ́gya mə.» ");
INSERT INTO mcp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bwə́ mú shilə nyə nə́: «Muud wɔɔŋgʉ́ jɨ ŋgow?» Nyə nə́: «Mə ampúyɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bwə́ mú kə nə muud nyə á dʉ bə ancím-ncîm ɛ́nɛ *Ofarizyɛ̂ŋ dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jwɔ̂w Yésus nyə á fugə ishwáfá bwiid múúd ɛ́nɛ míshʉ́d nɨ í á bə ntâg jwɔ̂w lʉ́ Sábaad. ");
INSERT INTO mcp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ofarizyɛ̂ŋ bwə́ mú nə́mə́ jî múúd ɛ́nɛ váál mísh mə́ ámə dʉ́gya nyə yí. A mú bɛ̧sa nə bwo nə́: «Nyə ámə bwiid mə ishwáfá míshʉ́d nə́ ndɛɛ́, mə mú kə gusa, mə músə ntâg dʉ́gya.» ");
INSERT INTO mcp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ja bwə́ mə́ gwág ntɔ́ yí, bɔ́ɔ́l Ofarizyɛ̂ŋ bwə́ mú cɨ nə́: «Muud nyə ámə sá sâ nɨ yɛ́ nyə aŋgɛ̂ nə wú wə́ Zɛmbî. Dʉgá, nyə agúmálɛ́ jwɔ̂w lʉ́ Sábaad.» Bɔ́ɔ́lʉ́gá nə́: «Ye sɔ́ɔl misə́m jɨ nə ŋkul sá mbií *shimbá nɨ?» Bwə́ mú bə nə mbɛ́ɛ́gí mpə́dʉ́gá nyáŋ. ");
INSERT INTO mcp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bwə́ mú nyiŋgə jî áncím-ncîm nə́: «Wɛɛ ŋgə dʉ́g nə́ muud nyə ámə bɛ̂ny wo mísh ɛ́nɛ jɨ ntʉdɛl?» Nyə nə́: «A jɨ *muud micúndə́ mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Njɨ, *Oyúdɛn bwə́ mú sá məshwán nə́ muud ɛ́nɛ nyə a shígɛ́ bə áncím-ncîm nə́ ndɛɛ́ mísh mə́ mú dʉ́gya nyə. Bwə́ mú ntâg kənd búúd kə jɔ̂w obyɔ̂l bɛ́, ");
INSERT INTO mcp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","zə jî bwo nə́: «Ye mwân wʉ́n bɨ́ mə́ dʉ cɨ nə́ nyə a byɛ̂l ancím-ncîm wə́ ɛ́ga? Ka ntʉdɛlɛ́ a mú ŋgə dʉ́gya yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Obyɔ̂l bwə́ mú bɛ̧sa nə́: «Sə́ mə́ mpú nə́ mwân wúsʉ́ wə́ ɛ́nɛ, nə́ nyə a byɛ̂l ancím-ncîm. ");
INSERT INTO mcp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Njɨ, váál í mə́ zə wɔ́ɔ́s ja gaád nə́ a ŋgə́g nə dʉ́gya yí, sə́ bâŋ sə́ ámpúyɛ́; sə́ kú nə́mə́ mpu múúd nyə ámə bɛ̂ny nyə mísh yɛ́. Shílə́gá nyəmɛ́fwó, a bɛ̧́sag, a cugɛ́ ná mwántombú.» ");
INSERT INTO mcp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Obyɔ̂l bwə́ á bɛ̧sa ntʉ́nɨ nəcé bwə́ á fúndə́ Oyúdɛn. Oyúdɛn bwə́ á bwey tɔ̂w cʉ́ŋ nə́ ŋkí muud mə́ məm nə́ Yésus jɨ *Krîst ɨɨ́, bwə́ yîl múúd wɔɔŋg *mpáánzə́ minjɨ́ɨ́gʉ́lád. ");
INSERT INTO mcp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gwə́ wə́ bwə́ á shwal cɨ nə́: «Shílə́gá nyəmɛ́fwó, a cugɛ́ ná mwántombú, nyəmɛ́fwó bɛ̧́sag sâ í dʉ́gyá nə nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ofarizyɛ̂ŋ bwə́ mú nyiŋgə jɔ̂w múúd nyə á dʉ bə ancím-ncîm ɛ́nɛ ja ábɛɛ̂ zə cɨ nə nyə nə́: «Yə́g Zɛmbî gúmə́. Sə́ mə́ mpú nə́ muud nyə ámə lwag wo ɛ́nɛ jɨ sɔ́ɔl misə́m.» ");
INSERT INTO mcp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nyə nə bwo nə́: «Ŋkí a jɨ sɔ́ɔl misə́m óo, mɛɛ mə ampúyɛ́. Mɛɛ mə mpú njɨ sâ ŋgwûd nə́: mə á dʉ bə ancím-ncîm, mə mú ŋgə dʉ́gya ja gaád.» ");
INSERT INTO mcp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bwə́ mú nyiŋgə jî nyə nə́: «Nyə ámə sá wo jɨ? Ntʉdɛlɛ́ nyə ámə bɛ̂ny wo mísh yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nyə nə bwo nə́: «Ŋgaá mə shí bwey jaaw bɨ́, bɨ́ nda gwág. Bɨ mə́ cɛɛl nə́ mə nyiŋgəg jaaw bɨ́ ja ábɛɛ̂? Bɨ wál nə́mə́ cɛɛl zə bə ómpwíín bɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bwə́ mú lwîy nyə nə́ ndɛɛ́ bwə́ nə́: «Wo wə́ jɨ *mpwíín yé. Sə́ báá, sə́ bʉ́sə ompwíín ɔ́ Moyîz. ");
INSERT INTO mcp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sə́ mə́ mpú nə́ Zɛmbî nyə a lésha nə Moyîz, sə́ ámpúyɛ́ nyɨ́nɨ nyɛɛ ŋgə́ zhu wá.» ");
INSERT INTO mcp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Muud nyə á dʉ bə ancím-ncîm yɛ́ mú cɨ nə́: «Mə káám nə́ bɨ ampúyɛ́ á ŋgə́ zhu wá; ká nywáá mə́ bɛ̂ny dɨ́ mə mísh ɨɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sə́ mə́ mpú nə́ Zɛmbî nyə ádɛ́ magʉlə mə́jəgʉla mə́ ósɔ́ɔl ɔ mísə́m. Njɨ, muud ŋgə́ yə Zɛmbî gúmə́ yɛ́, á ŋgə́ sá sâ Zɛmbî mə jɨ́ɨ́ yɛ́, Zɛmbî magʉlə mə́jəgʉla mɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sə́ abwɛ́lɛ́ nə́mə́ fwo gwág nə́ muud mə́ bɛ̂ny áncím-ncîm a byélé mísh. ");
INSERT INTO mcp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Í mbə̂m bə nə́ muud ɛ́nɛ nyə aŋgɛ̂ nə wú wə́ Zɛmbî, a kú bə nə ŋkul mə sá tɔɔ sâ.» ");
INSERT INTO mcp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bwə́ mú bɛ̧sa nə nyə nə́: «Wɛɛ mbɛɛ́ sâ í á byɛ̂l mísə́mʉ́d ncindî nə ncindî yí, wó cɛɛl zə yə sə́ minjɨ́ɨ́gʉ́lá?» Bwə́ mú ntâg wɨ́ɨ́ŋg nyə. ");
INSERT INTO mcp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yésus mú gwág nə́ bwə́ ámə wɨ́ɨ́ŋg múúd ɛ́nɛ. A mú kə bwəma nə nyə, a mú jî nyə nə́: «Ye wo búgʉ́lá *Mwân mə Múúd?» ");
INSERT INTO mcp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nyə nə Yésus nə́: «Cwámba, Mwân mə Múúd wə́ zə́ nə́ mə búgʉ́lág nyə?» ");
INSERT INTO mcp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yésus nə nɛ́ nə́: «Nyə wə́ wó ŋgə́ dʉ́g á ŋgə́ lésha nə wo ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Muud ɛ́nɛ mú cɨ nə́: «Cwámba, mə mə́ *búgʉla.» A mú kúd mpwóómbʉ́ shí na wə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nə́ ndɛɛ́, Yésus mú cɨ nə́: «Mə á zə shí ga dɨ́ nə́ mə zə́ sámb ŋkúmba lə́sʉ́. Sémbyé lə́sʉ́ wɔɔŋg wúsə nə́ mə zə sá nə wəancím-ncîm bwə́ dʉ́gyág, buud bwə́ ŋgə́ dʉ́gya wá bə wə́ancím-ncîm.» ");
INSERT INTO mcp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bʉ́baalɛ́ Ofarizyɛ̂ŋ bwə́ á bə cínɔŋg wá bwə́ mú gwág á mə́ cɨ ntɔ́, bwə́ mú shilə nyə nə́: «Ntɔ́ jɨ nə́ sə́ bɨ́ nə́mə́ wə́ancím-ncîm?» ");
INSERT INTO mcp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yésus nə bwo nə́: «Bɨ mbə̂m bə wə́ancím-ncîm, bɨ kú bə nə misə́m. Ká bɨ́ ŋgə cɨ nə́: “Sə́ ŋgə dʉ́gya”, sə́m wʉ́n í mə́ nada.» ");
INSERT INTO mcp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, múúd mə kə́ ŋkáál itɔw dɨ́ yɛ́ mə́ ká bə kú nyíi mpumbɛ́d, a yida kə kyey zhɨ́ɨ́ shúsʉ́d, kə ntɔ̧ kɔ́ɔ́gʉ́lə́d gwɔ̂w, nyɨ́nɨ múúd jisə juwâl, a jisə zhilʉŋgaanə́. ");
INSERT INTO mcp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Muud nywáá mə́ nyíi mpumbɛ́ dɨ́ yɛ́, mbaagʉlə itɔw wə́ ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Í dʉ bə, muud mə́ dʉ baagʉsə mpumbɛ́ yɛ́ juw nyə mpumbɛ́, itɔw í mú gwág mbaagʉlə wáŋ kə̂l. A mú ŋgə jɔ̂w itɔw byé, jɔ̂w tɔw jɛ̂sh nə jínə́ dɛ́, a mú kə nə byo tɔ́ɔ́n. ");
INSERT INTO mcp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ja á mə́ shîn cúwâl byɛ̂sh tɔ́ɔ́n yí, a kə tɔ̂w byo shwóg, í ka ŋgə bɛ̧ nyə nəcé í ŋgə yag kə́l dɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Itɔw í cúgɛ́ nə ŋkul bwɛlɛ bɛ̧ njínə muud, í yida ŋgə túb nyə, nəcé í ádɛ́ yag mə́kə̂l mə́ ójínə ɔ búúd.» ");
INSERT INTO mcp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yésus nyə á ŋwa bwo mpwokwoond nɨ, njɨ bwə́ á shígɛ́ wámbʉlə sâ nyə á ŋgə cɛɛl cɨ yí. ");
INSERT INTO mcp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nə́ ndɛɛ́, a mú ka nyiŋgə cɨ nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, mɛɛ wə́ jísə́ mpumbɛ́ ŋkáál itɔw. ");
INSERT INTO mcp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Buud bɛ̂sh bwə́ á tɛ́ɛ́d zə nə mə wá bʉ́sə ijúwâl, izhilʉŋgaanə́, itɔw í áshígɛ́ gwágʉlə bwo. ");
INSERT INTO mcp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mə wə́ jísə́ mpumbɛ́. Muud mə kyéy mə́dɨ́ yɛ́ nyə e dʉ́g cʉg; nyə é dʉ nyíi, dʉ cúwo, a kwey ídʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Juwâl í dʉ zə njɨ nə́ í zə́ júwo, zə gwú, zə caam. Mɛɛ mə á zə shú nə́ buud bwə́ bə́g nə cʉg, bwə́ bə́g nə gwo kú nə minjɨ. ");
INSERT INTO mcp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Mə wə́ jísə́ jɔ̧jɔ̧ mbaagʉlə itɔw. Jɔ̧jɔ̧ mbaagʉlə mə́ dʉ kɛɛnzh cʉg jé shú ítɔw byé. ");
INSERT INTO mcp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nyɔɔŋg mbaagʉlə mə sɛ́y njɨ shú *mwaanɛ̂ yɛ́, a cugɛ́ fwámɛ́ mbaagʉlə itɔw, a mpú nə́ itɔw í cúgɛ́ nyə byé yí; á dʉ bə, á ká dʉ́g ŋkweny ŋgə́ zə, a myaas ítɔw, a túb; ŋkweny mú zə ŋgə bii itɔw, itɔw í ŋgə́ cɨɨma. ");
INSERT INTO mcp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A sá ntɔ́ nəcé a ŋgə sɛ̂y ibamba, itɔw í acɛ́yɛ́ nyə lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Mɛɛ wə́ jísə́ jɔ̧jɔ̧ mbaagʉlə itɔw, mə mpú ítɔw byâm, itɔw byâm mpu mə, ");
INSERT INTO mcp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nə́mə́ nda Dâ mə mpú mə, mə mpu nə́mə́ nyə nə́. Mə́ kɛɛnzh cʉg jâm shú ítɔw. ");
INSERT INTO mcp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mə jɨ nə́mə́ nə bíl ítɔw, byâŋ í cúgɛ́ wa ŋkáál gaád. Í jɨɨ nə́ mə kyéyʉg nə́mə́ nə byo, í é gwágʉlə kə́l dâm nə́ ndɛɛ́ sɔɔnz mú bə ŋgwúdʉ̂, mbaagʉlə nə́mə́ ŋgwúdʉ̂. ");
INSERT INTO mcp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Dâ mə́ cɛɛl mə nəcé mə kɛɛnzh cʉg jâm nə́ mə bá nyiŋgə ŋwa gwo. ");
INSERT INTO mcp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Muud nyə adɛ́ɛ́gɛ́ mə cʉg jâm; məmɛ́fwó wə́ mə́ kɛɛnzh gwo. Mə jɨ nə ŋkul mə kɛɛnzh cʉg jâm, mə nə ŋkul mə nyíŋgə́ ŋwa gwo: wáda Dâ nyə á yə mə wə́ cɨ́.» ");
INSERT INTO mcp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lə́sʉ́ Yésus nyə á ŋgə lás nɨ í á sá mbɛ́ɛ́gí mpə́dʉ́gá *Oyúdɛn. ");
INSERT INTO mcp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bɔ́ɔ́lʉ́gá ŋkí bulya bwə́ á ŋgə cɨ nə́: «Jamb í mə́ bii nyə, í mú ŋgə sá nə́ a lásʉ́g ilɨ́s-lɨ́s; kúgá ná ŋgə gwágʉlə nyə.» ");
INSERT INTO mcp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bɔ́ɔ́lʉ́gá nə́: «Ilɨ́s-lɨ́s í jamb dɨ́ ínɨ; jamb í cúgɛ́ nə ŋkul bwɛlɛ bɛ̂ny áncím-ncîm mísh.» ");
INSERT INTO mcp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Zaŋ ifúb mpáánzə́ í á ŋgə sɨ̂y Yurʉ́səlɛm, í á bə fwála lʉ ŋkwân. ");
INSERT INTO mcp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yésus nyə á ka bə *Luŋ mə́ Zɛmbî, a ŋgə́ kyey kʉ́l bwə́ á gwiid nə́ Nyíŋgʉ́lé mə́ Sə́lʉmun dɨ́, a kə, a zə, a kə, a zə. ");
INSERT INTO mcp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Oyúdɛn bwə́ á ka kə lyɛ̧ nyə, kə jî nyə nə́: «Wo é ka bá səl sə́ milâm shí jáyɛ́ ja? Ŋkí wo wə́ jísə́ *Krîst, jaawʉg sə́ nə́ kpwɔɔ́.» ");
INSERT INTO mcp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yésus mú bɛ̧sa bwo nə́: «Mə a shí bwey jaaw bɨ́ njɨ bɨ ŋgə́ shwána. Misɔ́ɔ́lʉ́gʉ́ mə́ ŋgə́ sá jínə́ mə́ Dâ dɨ̂ myá mí ŋgə nə́mə́ lwágʉlə ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mí ŋgə tɛɛm lwágʉlə ntɔ́, bɨ́ ŋgə shwána shwánág, nəcé bɨ́ cugɛ́ mə́dɨ́ sɔɔnz ítɔw dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Itɔw byâm í dʉ gwágʉlə kə́l dâm; mə mpú byo, í dʉ bɛ̧ mə. ");
INSERT INTO mcp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɛɛ ŋgə ntâg yə byo cʉg á kandʉgə kandʉgə, í ábʉ́lɛ́ bwɛlɛ yə, muud nyə abʉ́lɛ nə́mə́ bwɛlɛ dɛ́ɛ́g mə byo mbwə́d. ");
INSERT INTO mcp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dâ muud nyə á yə mə byo yɛ́ mə́ ntɔ̧ múúd yɛ̂sh ŋkúlʉd; muud cugɛ́ nə ŋkul dɛ́ɛ́g nyə sâ mbwə́d. ");
INSERT INTO mcp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sá Dâ sə́ bʉ́sə nda muud ŋgwûd.» ");
INSERT INTO mcp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oyúdɛn bwə́ mú nyiŋgə ŋkɛ̂ny mə́kwóógʉ́ nə́ bwə́ gwú nyə nə ndɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Njɨ, Yésus mú jî bwo nə́: «Mə mə́ lwágʉlə bɨ́ jɔ̧jɔ̧ mísɔ́ɔ́lʉ́gʉ́ mí ŋgə́ zhu wə́ Dâ myá, bɨ mə́ cɛɛl gwú mə nə wáyɛ́?» ");
INSERT INTO mcp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Oyúdɛn bwə́ mú bɛ̧sa nə nyə nə́: «Sə́ acɛ́ɛ́lɛ́ gwú wo nə jɔ̧jɔ̧ sɔ́ɔ́lʉ́gʉ́; sə́ mə́ yida cɛɛl gwú wo nəcé wo ŋgə lás nə Zɛmbî *bwaasʉ́lə mpu; wɛɛ njúl muud, wo ŋgə bə́lɛ cɨ nə́ wo jɨ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yésus mú fɛɛl nə́: «Ŋgaá cilyá wúsə bɨ́dɨ́ kálaad məcɛ̧ɛ̧́d nə́: “Bɨ bʉ́sə ozɛmbî” ");
INSERT INTO mcp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na mə lwágʉlə nə́ buud Zɛmbî nyə á ŋgə lás nə ndɨ́ wá, Kálaad Zɛmbî mə jɔ̂w bwo nə́ ozɛmbî. Ká jɨ? Muud nyə ajə́láyɛ́ nə yîl sâ Kálaad Zɛmbî ŋgə́ cɨ yí. ");
INSERT INTO mcp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Bɨ bâŋ bɨ mə sá nə́, mə muud Zɛmbî nyə a fɛ́ɛ́sh, a mú ntɨ shí ga dɨ́ yɛ́, bɨ mə́ cɨ nə́ mə ŋgə *lás nə Zɛmbî bwaasʉ́lə mpu nəcé mə ŋgə́lə bwaagʉlə nə́ mə jɨ Mwân mə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ŋkí mə aŋgɛ̂ nə sá misɔ́ɔ́lʉ́gʉ́ mí Dâ, shwánágá mə. ");
INSERT INTO mcp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Njɨ, ŋkí mə ŋgə sá myo, bɨ́ tɛɛm ŋgə shwána mə, *magʉləgá misɔ́ɔ́lʉ́gʉ́; bɨ́ mə́ ká magʉlə myo, bɨ́ yag, bɨ́ mpu nə́mə́ nə́ Dâ njul mə́dɨ́, mə njúl wə́ Dâ.» ");
INSERT INTO mcp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Njɨ bwə́ á gwág ntʉ́nɨ yí, bwə́ mú nyiŋgə sɔ̧ nə́ bwə́ bii nyə, a mú faam. ");
INSERT INTO mcp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","A mú nyiŋgə lɨ́ɨ́na kə Zhurdɛ̧̂ faŋwíny, kʉ́l Yuánɛs nyə á fwo ŋgə duu buud yí, a mú kə ji wu. ");
INSERT INTO mcp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Zhwog buud bwə́ mú dʉ zə nyə́dɨ́. Bwə́ mú dʉ cɨ nə́: «Yuánɛs nyə a shígɛ́ bwɛlɛ sá tɔɔ *shimbá; njɨ, sâ jɛ̂sh nyə á cɨ shú mə́ múúd ɛ́ga yí jísə bʉ́bə́lɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Zhwog buud bwə́ mú *búgʉla Yésus kʉ́kʉ́l jɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ŋgwɔ́l múúd nyə á bə nə́ Lazâr, muud á Betanî, lɔɔm mə́ Maríya bá mínyɔŋʉ̂ shilə Mááta. Lazâr ɛ́nɛ nyə á ka bwas. ");
INSERT INTO mcp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lazâr nyə á bwas ɛ́nɛ nyə á bə ncwûm mə́ Maríya, Maríya nyə á gwáágʉlə Yésus labínda məkuúd, a fîm mwo nə shilú yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Maríya bá Mááta bwə́ á ka kənd Yésus məkə́l nə́: «Cwámba, muud woó ŋgə bwas.» ");
INSERT INTO mcp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ja Yésus nyə á gwág məkə́l mə́nɨ yí, nyə á cɨ nə́: «Bwas nɨ í cúgɛ́ bwas shwɨy, í yida bə bwas i é sá nə́ Zɛmbî ŋwág gúmə́ yí, í ka nə́mə́ sá nə́ *Mwân mə́ Zɛmbî ŋwág gúmə́.» ");
INSERT INTO mcp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yésus nyə á dʉ bul cɛɛl Mááta bá mínyɔŋʉ̂ shilə Maríya, nə Lazâr. ");
INSERT INTO mcp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nə́ ndɛɛ́, nyə á tɛɛm gwág nə́ Lazâr ŋgə bwas ɨɨ́, nyə á fwo nyiŋgə cɨ́ŋgʉli mwɔ̂w mə́bá kʉ́l nyə á bə yí. ");
INSERT INTO mcp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mpʉ́sə mwɔ̂w mə́bá mɔɔŋgʉ̂, a mú ka cɨ nə *ompwíín bɛ́ nə́: «Shé nyiŋgəgá kə Yudéa.» ");
INSERT INTO mcp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ompwíín nə nyə nə́: «*Rabi, Oyúdɛn bwə́ mə́ nywá fwo kúnɔw gwú wo nə məkwóógʉ́ nûŋ Yudéa, wó cɛɛl nə́mə́ nyiŋgə kə wu?» ");
INSERT INTO mcp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yésus mú bɛ̧sa nə bwo nə́: «Ŋgaá mwásə́ wɨ́ nə məwəla wûm nə mə́bá? Múúd mə ká ŋgə kyey mə́wəla mɔɔŋg dɨ, nyə abʉ́lɛ ŋgə mága, nəcé nyə é ŋgə dʉ́g iŋgʉ́ŋgə́ŋ yâ shí ga. ");
INSERT INTO mcp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Njɨ, múúd mə ká kyey mpwó-bulú, nyə é ŋgə mága, nəcé kú nə iŋgʉ́ŋgə́ŋ lámʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ja nyə á shîn cɨ ntʉ́nɨ yí, nyə nə́: «Shwə́ wúsʉ́ Lazâr mə́ kə gwə́d, njɨ, mə é kə juumʉshi nyə.» ");
INSERT INTO mcp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ompwíín ntâg nə́: «Cwámba, ŋkí Lazâr mə́ kə gwə̂ dɨ, nyə é yâl.» ");
INSERT INTO mcp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Í á bə, Yésus ŋgə́ cɛɛl cɨ nə́ Lazâr mə́ yə, bâŋ bwə́ ŋgə́ dʉ́g nə́ a ŋgə cɨ gwó múúd mə́ dʉ ja nə́ á woga nyúúl yí. ");
INSERT INTO mcp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yésus mú ka jaaw bwo nə́ kpwɔɔ́ nə́: «Lazâr mə́ yə. ");
INSERT INTO mcp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mə gwág nywa nəcé mə shígɛ́ bə ja nyə ámə yə yí, sá jɔɔŋg í é sá nə́ bɨ búgʉ́lág. Nə́ ndɛɛ́, íŋkyená kʉ́l á jɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tómas bwə́ á dʉ nə́mə́ nyiŋgə jɔ̂w nə́ Wáás yɛ́ mú ka cɨ nə bɔ́ɔ́l ómpwíín nə́: «Íŋkyená, shénɔ̂ŋ Cwámba bɛ̂sh kə́g nə́mə́ yə.» ");
INSERT INTO mcp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ja Yésus mə́ kə wɔ́ɔ́s yí, a mə́ kə kwey nə́ Lazâr mə́ bwey dɔw mwɔ̂w mə́nɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nda wúlə Betanî kə Yurʉ́səlɛm wúsə́ jee bə ókílomáda ólɔ́ɔl nə́, ");
INSERT INTO mcp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","zhwog *Oyúdɛn bwə́ á kə dʉ́g Mááta bá Maríya, kə cweel bwo milâm nə shwɨy mə ncwûm wáŋ. ");
INSERT INTO mcp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ja Mááta nyə á gwág nə́ Yésus mə zə́ wɔ́ɔ́s yí, nyə á lɛɛl kə, kə bwəma nə nyə, Maríya nyɛ njúl ná shí, njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mááta mú ka cɨ nə Yésus nə́: «Yé Cwámba, wo mbə̂m bə wa, ŋki ncwûm waamə́ shígɛ́ yə. ");
INSERT INTO mcp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Njɨ, tɔɔ kɨ́kɨdɨ́ga, mə mpú nə́ Zɛmbî nyə é yə wo sâ jɛ̂sh wó é gwáámb nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yésus mú cɨ nə nyə nə́: «Ncwûm woó mə bá gwûm.» ");
INSERT INTO mcp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nyə nə Yésus nə́: «Mə mpú nə́ a bá gwûm ja búúd bwə́ bá gwûm jwɔ́w á məzhúgʉ́lâ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yésus mú cɨ nə nyə nə́: «Mə wə́ mə́ dʉ gwûmʉshi búúd, dʉ nyiŋgə yə bwo cʉg. Muud mə *búgʉ́lá mə yɛ́, a tɛɛm yə, a bá nyiŋgə cʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Muud ŋgə́ ntâg cʉgə yɛ́ ká *búgʉla mə, a kú bá bwɛlɛ yə. Ye wo *magʉlə ntɔ́?» ");
INSERT INTO mcp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mááta nə́: «Haaw Cwámba. Mə mə́ magʉlə nə́ wo jisə *Krîst, *Mwân mə́ Zɛmbî nyə á zə shí ga dɨ́ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ja Mááta mə́ shîn cɨ ntʉ́nɨ yí, a mə́ kyey kə jɔ̂w mínyɔŋʉ̂ shilə Maríya, kə nyímbʉla nə nyə nə́: «Cwámba mə́ wɔ́ɔ́s, a ŋgə jɔ̂w wo.» ");
INSERT INTO mcp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Njɨ Maríya nyə á gwág ntʉ́nɨ yí, nyə a tɔ̂w nə́ máás kə wə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Í á bə, Yésus kú fwo nyíi baŋ lɔɔmʉd, a njúl ná kʉ́l Mááta nyə á kə bwəma nə nyə yí. ");
INSERT INTO mcp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Oyúdɛn bə́nɔ̂ŋ Maríya bwə́ á bə njɔ́w bwə́ ŋgə́ cɛɛl cweel nyə lâm wá bwə́ mú dʉ́g á tɔ́w nə́ máás cúwo tɔ́ɔ́n. Bwə́ mú bɛ̧ nyə, bwə́ ŋgə́ dʉ́g nə́ a kə́ jɨɨ shwóŋʉd. ");
INSERT INTO mcp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maríya mə́ kə kumə kʉ́l Yésus nyə á bə yí; njɨ nyə á dʉ́g Yésus yí, nyə á wusə nyúúl shí Yésus dɨ́ shí məkuú, nyə nə́: «Yé Cwámba, wo mbə̂m bə wa, ŋki ncwûm waamə́ shígɛ́ yə.» ");
INSERT INTO mcp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yésus mú dʉ́g Maríya bə́nɔ̂ŋ Oyúdɛn bwə́ á ŋgə lʉ́gal nyə wá bwə́ ŋgə́ jɨɨ, mbɔɔm mú shwɨy nyə nyúúlʉ́d, mitə́dʉ́gá búbulə nyə lámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A mú jî nə́: «Bɨ á dʉl nyə ŋgow?» Bwə́ nə nɛ́ nə́: «Zaá kə dʉ́g, yé Cwámba.» ");
INSERT INTO mcp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yésus mú ntâg jɨɨ. ");
INSERT INTO mcp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oyúdɛn bwə́ mú ŋgə cɨ nə́: «Bɨ mə́ dʉ́g ɨɨ́, nyə á bul cɛɛl nyə ɛ̧ɛ̧́.» ");
INSERT INTO mcp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bɔ́ɔ́lʉ́gá wâ bwə́dɨ́ sámbád bâŋ bwə́ mú ŋgə cɨ nə́: «Ŋgaá muud ɛ́ga wə́ nyə a bɛ̂ny ancím-ncîm mísh? Ká a shígɛ́ dɨ́ bə nə ŋkul sá nə́ Lazâr kú yə.» ");
INSERT INTO mcp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yésus mbɔɔm mú nyiŋgə shwɨy nyúúlʉ́d, a mú kə kʉ́l bwə́ á dʉl Lazâr yí. Shwoŋ í á bə ku, mbwagʉlá kwóógʉ́d, bwə́ ka fad nə dúl kwóógʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yésus mú cɨ nə́: «Yílʉ́gá kwóógʉ́.» Mááta á kɔ́ɔ́l mə múúd nyə á yə yɛ́ mú cɨ nə́: «Ey Cwámba, a mə́ dɔw mwɔ̂w mə́nɔ̧̂ múús, a mú ŋgə mpə.» ");
INSERT INTO mcp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yésus mú ka cɨ nə nyə nə́: «Ŋgaá mə shí cɨ nə wo nə́ wó ká *búgʉla, wo e dʉ́g nda Zɛmbî nyə é ŋwa gúmə́ nə́.» ");
INSERT INTO mcp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bwə́ mú ka yîl kwóógʉ́. Yésus mú bʉ̂n mpwóómbʉ́, a mú lás nə́: «Ye Dâ, mə yə́ wo akíba nəcé wo ámə magʉlə mə́jəgʉla mâm. ");
INSERT INTO mcp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Haaw. Mə ámə bwey ŋgə mpu nə́ wó dʉ magʉlə mə́jəgʉla mâm ja jɛ̂sh. Mə ámə yida lás shú nə́ zhwog buud bwə́ mə́ lyɛ̧ mə ɔ́ga bwə́ mpúg nə́ wo wə́ wo ámə ntɨ mə.» ");
INSERT INTO mcp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ja á mə́ shîn lás ntʉ́nɨ yí, a mú kɨ̂m nə ŋkulú nə́: «Lazâr, cúwóg tɔ́ɔ́n.» ");
INSERT INTO mcp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Muud nyə á bə mbimbə yɛ́ mú cúwo tɔ́ɔ́n, a njúl nə obándáshi ŋgwɔ́ɔ́lá mə́kuú nə məbwə́d, mpwóómbʉ́ ŋgwɔ́ɔ́lá nə kʉ́l káándə́. Yésus mú cɨ nə buud nə́: «Wiinzhʉgá nyə isâ ínɨ bɨ bɨ́dʉ́g nyə, a kə́g.» ");
INSERT INTO mcp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zhwog *Oyúdɛn bwə́ á zə wə́ Maríya wá, bwə́ á dʉ́g sâ Yésus nyə a sá yí, bwə́ mú *búgʉla nyə. ");
INSERT INTO mcp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Njɨ, bɔ́ɔ́lʉ́gá bwə́ á kə *Ofarizyɛ̂ŋ dɨ́, kə jaaw bwo sâ Yésus nyə a sá yí. ");
INSERT INTO mcp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Milúlúú myâ ofada bə́nɔ̂ŋ Ofarizyɛ̂ŋ bwə́ mú sɛɛŋg *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî, kə cɨ nə́: «Muud ɛ́ga ŋgə bul sá *məshimbá. Shé mə́ sá ntʉdɛl? ");
INSERT INTO mcp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Shé mə́ ká bɨ́d nə́ a ŋgə́g nə kə shwóg ɨɨ́, buud bɛ̂sh bwə́ é búgʉla nyə nə́ ndɛɛ́, buud ɔ Róma bwə́ zə ntâg ɨɨ́, zə búgə Mpáánzə́ íshé, bwú nə́mə́ lɔɔm íshé.» ");
INSERT INTO mcp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ŋgwɔ́l múúd wáŋ nə jínə́ nə́ Kayíf ɨɨ́, nyə muud nyə á bə Ajəlácɨ á ofada mbû wɔɔŋg dɨ́ yɛ́ mú cɨ nə́: «Bɨ agwágɛ́ tɔɔ sâ na lə́sʉ́ nɨɨ́d. ");
INSERT INTO mcp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bɨ adʉ́gɛ́ nə́ í yida bə bɨ́ nə mfíí nə́ muud ŋgwûd yə́g shú kúl búúd jɛ̂sh ncindî, lɔɔm í nda jɛ̧ wɛ̂sh ɨɨ́?» ");
INSERT INTO mcp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Lə́sʉ́ nyə á lás wɔɔŋgʉ́, nyə a shígɛ́ lás nə lúu yé. Í á yida bə nə́, nda nyə á bə Ajəlácɨ á ofada mbû wɔɔŋg dɨ́ nə́, nyə a lás tâŋ *muud micúndə́ nə́ í á jɨɨ nə́ Yésus yə́g shú lɔɔm wɛ̂sh; ");
INSERT INTO mcp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kú nə́mə́ bə njɨ shú lɔɔm wə́mɛ́fwó, a yə́ shú nə́ bwân ɔ́ Zɛmbî bʉ́sə́ ícɨɨmí icɨɨmí wá bwə́ sɛ́ɛ́ŋgyag bə sâ ŋgwûd. ");
INSERT INTO mcp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jwɔ̂w nɨ wə́ bwə́ á ŋwa cigʉlá nə́ bwə́ gwú Yésus yí. ");
INSERT INTO mcp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yésus nyɛ mú yɔw ŋgə́lə kyey bəl-bə̂l dɨ̂ kʉ́l Oyúdɛn bʉ́sə́ yí; a mú kə kɔ́ɔ́mb lɔɔm jísə ŋgɛɛ shí a shwééshá dɨ́ yí, bə́nɔ̂ŋ *ompwíín bɛ́ kə ji də́nd bwə́ á dʉ jɔ̂w nə́ Ifrɛ̂m yí. ");
INSERT INTO mcp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Í á ka zə bə, nda *Páska Oyúdɛn nyə á bə kúnə́-kúnə nə́, zhwog buud bwə́ á ŋgə wú mə́kwáádə́ máŋʉ́d ŋgə bád kə Yurʉ́səlɛm nə́ bwə́ kə́ ŋgə gusa miŋgusa mi yə́bə́. ");
INSERT INTO mcp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bwə́ á ka ŋgə sɔ̧́ Yésus nə́ ndɛɛ́, kʉ́l bwə́ á bə *Luŋ mə́ Zɛmbî yí, bwə́ á ŋgə shilə bwə́mɛ́ nə bwə́mɛ́ nə́: «Bɨ mə dʉ́g nə́ jɨ? Nyə ajeyɛ́ zə zâŋ dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Í á bə, milúlúú myâ ofada bə́nɔ̂ŋ Ofarizyɛ̂ŋ bwə́ mə́ cɨ nə́ í bə́g nə́: «Muud nyə é mpu kʉ́l Yésus nyə é bə yí, bágʉ́lə́g, bwə́ kə́g bii nyə.» ");
INSERT INTO mcp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Í á ka zə bə, í mə́ lʉ́g mwɔ̂w mə́saman nə́ *Páska *Oyúdɛn zə́g bə, Yésus mə́ kə Betanî, də́nd mə́ Lazâr Yésus nyə a gwûmʉshi yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bɔ́ɔ́l búúd ɔ də́nd dɔɔŋgʉ́ bwə́ á ka sá dína lúu mə́ Yésus dɨ̂. Mááta nyə á bə a ŋgə́ sá milwámá dína jɔɔŋgʉ́d, Lazâr njúl sámbá búúd bə́nɔ̂ŋ Yésus bwə́ á ŋgə də wád. ");
INSERT INTO mcp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maríya mú ka ŋwa labínda álal-kus bwə́ á sá nə fwámɛ́ nâr yɛ́. Nyə á ŋwa labínda nɨ kʉ́l njwɔmbɔ, zə gwáágʉlə Yésus məkuúd nə́ ndɛɛ́ a mú fîm nyə mwo nə shilú jé; məcud mə́ labínda mə́ mú lwánd njɔ́w wɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ŋgwɔ́l *mpwíín mə Yésus nyə á bə cínɔŋg nə́ Yúdas Iskariyôt, mpwíín nyə́ á bə nə́ nyə wə́ mə́ bá kusha nə Yésus yɛ́. Ja Yúdas ɛ́nɛ mə́ dʉ́g nda Maríya nyə á gwáágʉlə Yésus labínda nâr nə́, a mə́ cɨ nə́ ");
INSERT INTO mcp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Jɨ́ bwə́ ámə bə kú kusha labínda ɛ́ga odanarî mitəd milɔ́ɔl nə́ ndɛɛ́ bwə́ kwíínd mímbúmbúwá nə ndɨ́ yí?» ");
INSERT INTO mcp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nyə a shígɛ́ cɨ ntʉ́nɨ nə́ a baam nə mimbúmbúwá. Nyə á cɨ ntɔ́ nəcé nyə á bə juwâl; nda nyə á dʉ bii maŋga *mwaanɛ̂ nə́, nyə á dʉ júwo mwaanɛ̂ cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yésus mú cɨ nə́: «Bɨ́dʉ́g múdá ɛ́nɛ nə́ shɛɛ. A mə́ sá sɔ́ɔ́lʉ́gʉ́ nɨ, ŋgə́lə bwey tə́dʉga nda bwə́ bá dʉl mə nɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nəcé bɨ é dʉ ji nə mimbúmbúwá mwɔ̂w mɛ̂sh, njɨ sə́nɔ̂ŋ bɨ́ sə́ ábʉ́lɛ́ ji mwɔ̂w mɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na nyə á bə, kúdə zhwog Oyúdɛn bwə́ mə́ gwág nə́ Yésus jɨ Bétanî; bwə́ á ka ŋgə kə wu, kú bul bə njɨ shú dɛ́, bwə́ á ŋgə nə́mə́ kə nə́ bwə́ kə́ dʉ́g Lazâr nyə á gwûmʉshi yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nə́ ndɛɛ́, milúlúú myâ ofada mí mú ŋwa cígʉ́lá nə́ bwə́ jəlá nə gwú nə́mə́ Lazâr, ");
INSERT INTO mcp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nəcé sâ í á bə nə nyə yí í á sá nə́ kúdə zhwog Oyúdɛn bwə́ béégyág nə bwo, yidá kə, kə *búgʉla Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mán mələ̂m, ncúlyá buud bwə́ á zə zâŋ dɨ́ wá bwə́ mú gwág nə́ Yésus ŋgə zə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bwə́ mú ŋgə ŋwa máŋ mə́ lə́ndú nə́ ndɛɛ́, kə lə́g nyə bwə́ ŋgə́ kɨ̂m nə́: Hosána! Gúmə́ í bə́g nə nyɔɔŋg ŋgə́ zə jínə́ mə́ Cwámba dɨ́ yɛ́, Njwú-buud á Izʉrəyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yésus mú kwey mwâ jakáás, a mú kəwa gwo gwɔ̂w nda Kálaad Zɛmbî ŋgə́ cɨ nə́, nə́: ");
INSERT INTO mcp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yé shilə Siyôn, kú fúndə. Dʉgɨ́ njwû woó ŋgə́ zə. A mbə́d cwɔ̧ jakáás dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","*Ompwíín ɔ́ Yésus bwə́ áshígɛ́ fwo wámbʉlə sâ í á ŋgə sɨ̂y yí fwála dɔɔŋgʉ́d. Bwə́ á ka kə tə́dʉga gwo ja Yésus nyə á ŋwa gúmə́ yí; bwə́ mú mpu nə́ í á bə cilyá shú mə́ Yésus, sɔ́ɔ́lʉ́gʉ́ wɔɔŋg nə́mə́ wə́ bwə́ á sá nyə yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Í á bə na, ncúlyá buud bwə́ á bə ja nyə́ á jɔ̂w Lazâr gwûmʉshi nyə yí, bwə́ ŋgə́ bwiiŋg láŋ yé. ");
INSERT INTO mcp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Haaw. Bwə́ á ŋgə zə bwəma nə nyə nəcé bwə́ á gwág nə́ nyə a sá *shimbá dɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ntɔ́, *Ofarizyɛ̂ŋ bwə́ mú ka ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Bɨ mə́ dʉ́g ɨɨ́? Bɨ cugɛ́ nə ŋkul sá sâ. Dʉgá lɔɔm wɛ̂sh ŋgə́ kə nyə́dɨ́!» ");
INSERT INTO mcp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bʉ́baalɛ́ Ogʉrɛ̂k bwə́ á bád nə́mə́ zə Yurʉ́səlɛm nə́ bwə́ zə́ yə Zɛmbî gúmə́ zâŋ nɨɨ́d. ");
INSERT INTO mcp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bwə́ á ka kə dʉ́gya nə Fílíp á mwâ Bɛtʉsayída, kə jî nyə nə́: «Mása, sə́ ŋgə cɛɛl dʉ́g Yésus.» ");
INSERT INTO mcp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fílíp mú kə jaaw Andrê, bá bɛ̂sh bwə́ mú kə jaaw Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yésus mú bɛ̧sa nə bwo nə́: «Wəla mə́ wɔ́ɔ́s, wəla *Mwân mə Múúd mə jəlá nə ŋwa gúmə́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bumə́ mpəg í ámə kə mə́ndəlúd yí, í ká kə ji kú yə, í bwên gwə́mɛ́fwó. Í ká yə, í wúmə íbumə́ məŋkund məŋkund. ");
INSERT INTO mcp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Muud mə nywɨ́ɨ́lyá nə cʉg jé yɛ́ nyə e jímbal gwo; muud mə yídá bə kú nywɨ́ɨ́lya nə cʉg jé wa shí ga dɨ́ yɛ́, nyə é baagʉlə gwo kandʉgə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ŋkí muud mə́ cɛɛl sɨ́ya nə mə, a bɛ̧ mə, í mú bə nə́, kʉ́l mə́ jísə́ yí, muud ŋgə́ sɨ́ya nə mə yɛ́ bə nə́mə́ cínɔŋg. Múúd mə ká sɨ́ya nə mə, Dâ yə nyə gúmə́. ");
INSERT INTO mcp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Nda bɨ́ mə́ dʉ́g ɛ́ga, mitə́dʉ́gá mí mə́ búbulə mə lámʉ́d. Ká mə cɨ́g nə́ jɨ? Nə́ Dâ, ság nə́ mə fáámʉg nə cúŋ ŋgə́ zə ga? Mbɔ̂. Mə á yida zə nə́ mə zə́g bwəma nə cúŋ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dâ, ság nə́ jínə́ dwô í ŋwág gúmə́.» A ká nə́mə́ shîn lás ntʉ́nɨ, kə́l mú wú joŋ dɨ́ nə́: «Mə mə́ sá, mə é nyiŋgə nə́mə́ sâ.» ");
INSERT INTO mcp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Buud bwə́ á bə cínɔŋgʉ́ áncuncuma wá bwə́ á gwág kə́l dɔɔŋgʉ́, bwə́ mú cɨ nə́ jísə njum-mpú; bɔ́ɔ́lʉ́gá nə́ ŋgwɔ́l *éŋgəles mə́ lésha nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yésus mú ka cɨ nə́: «Kə́l nɨ́ shígɛ́ lás na shú dâm, í ámə yida bə shú dʉ́n. ");
INSERT INTO mcp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nəcé shí ga í zə bwəma nə sémbyé mílə́sʉ́ kɨ́kɨdɨ́ga, cî á shí ga wusɔw tɔ́ɔ́n. ");
INSERT INTO mcp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mɛɛ, ja mə́ bá wú shí gaád bʉ̂nɔw gwɔ́w yí, mə bá julə búúd bɛ̂sh mə́dɨ́.» ");
INSERT INTO mcp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ja Yésus nyə á ŋgə cɨ ntʉ́nɨ yí, nyə á ŋgə lwágʉlə váál shwɨy á bá yə yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zhwog buud ɔ́nɨ bwə́ mú bɛ̧sa nə́: «Sə́ á jɨ́ɨ́g *mbwoomb mə́cɛ̧ɛ̧ dɨ́ nə́ *Krîst mə bá cʉgə kandʉgə kandʉgə. Wó nyiŋgə́ zə jaaw sə́ nə́ í bá jɨɨ nə́ Mwân mə Múúd bʉ́nɔ́wʉ́g gwɔ́w, ntɔ́ nyɛ wə́ jɨ? Mwân mə Múúd wɔɔŋg wə́ zə?» ");
INSERT INTO mcp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yésus mú bɛ̧sa bwo nə́: «Məŋkɛnya mə́sə ná wa bɨ́dɨ́ nə fúfwálá. Ŋgəgá nə kyey té bɨ́ bʉ́sə́ ná nə məŋkɛnya yí, yídʉ́gʉ́ í kú bá zə byalʉga nə bɨ̂; nəcé, muud mə kyéy yídʉ́gʉ́d yɛ́ nyə ádɛ́ mpu kʉ́l á ŋgə́ kə yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ŋgəgá nə *búgʉla məŋkɛnya té mə́ŋkɛnya mə́sə́ ná bɨ́dɨ́ yí, bɨ ŋgə́g nə bə bwân ɔ́ mə́ŋkɛnya.» Ja Yésus nyə a shîn lás nə bwo ntʉ́nɨ yí, nyə a béégya nə bwo, a mú kə shwaaw. ");
INSERT INTO mcp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yésus nyə á tɛɛm sá bímbí lʉ́ *mə́shimbá mə́nɨ buud bwə́ ŋgə́ dʉ́g ɨɨ́, buud bwə́ áshígɛ́ *búgʉla nyə. ");
INSERT INTO mcp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sâ jɔɔŋg í á sá nə́ ciyá mə́ Izayí *muud micúndə́ í bwə́mag. Nyə á cɨ nə́: Cwámba, zə́ nyə a búgʉla kɛ́ɛl sə́ á ŋgə bwiiŋg yí? Zə́ Cwámba nyə a lwágʉlə mpífə́ nyɛ́ yɛ́? ");
INSERT INTO mcp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gwə́ wə́ í sá nə́ buud ɔ́nɨ bwə́ bə́g kú búgʉla sâ Izayî nyə á cɨ yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Zɛmbî nyə a shwu bwo ncím míshʉ́d, a lʉlʉshi bwo milâm, nəcé mísh máŋ mə́ á bá dʉ́g, milâm myáŋ mí á bá wámbʉlə, bwə́ á bá cɛ́nd kuú njɔɔnd, nə́ ndɛɛ́ mə mú lwag bwo. ");
INSERT INTO mcp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Izayí nyə á lás ntɔ́ nəcé nyə á bwey dʉ́g milwanə́ mí Yésus, a mú lás sâ í dʉ́gyá nə Yésus yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Í á tɛɛm bə ntɔ́, bɔ́ɔ́l zhwog buud wâ sámbá ótɔ́we ɔ shwóg bwə́ á shí búgʉla Yésus. Njɨ, bwə́ áshígɛ́ bə nə ŋkul məm nyə mísh mə́ búúd dɨ́, bwə́ á ŋgə fúndə nə́ *Ofarizyɛ̂ŋ bwə́ á bá yîl bwo *mpáánzə́ minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nəcé bwə́ á cɛɛl ŋwa gúmə́ mísh mə́ búúd dɨ́, kú bə mísh mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Njɨ, tɛɛm bə ntɔ́, Yésus nyə á cúndə gwɔ́w-gwɔ̂w nə́: «Muud mə búgʉ́lá mə yɛ́ nyə abúgʉ́láyɛ́ njɨ mə, a búgʉ́lá nə́mə́ múúd nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Muud mə́ dʉ́g mə yɛ́, a mə́ dʉ́g nə́mə́ múúd nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mɛɛ muud jísə́ mə́ŋkɛnya yɛ́, mə á zə shí ga dɨ́ nə́, muud yɛ̂sh mə búgʉ́lá mə yɛ́ bə́g kú nyiŋgə ŋgə cʉgə yídʉ́gʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Muud mə gwágʉlə lə́sʉ́ mə́ ŋgə́ lás yɛ́, njɨ a kú sá nda mə́ ŋgə́ cɨ nə́, mə dɨ́ mə́ yə́ nyə intʉ́gʉ́lí; mə áyəyɛ́ nyə intʉ́gʉ́lí nəcé mə a shígɛ́ zə nə́ mə zə́ yə búúd ɔ shí ga intʉ́gʉ́lí, mə á yida zə sá nə́ buud ɔ shí bwə́ fáámʉg. ");
INSERT INTO mcp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Muud mə ká ban mə, ban lə́sʉ́ mə́ ŋgə́ lás yí, muud wɔɔŋg mə́ bwey bə nə sâ í bá yə nyə intʉ́gʉ́lí yí; lə́sʉ́ mə́ ŋgə́ lás ga wə́ í bá yə nyə intʉ́gʉ́lí jwɔ́w á məzhúgʉ́lâ. ");
INSERT INTO mcp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mə aŋgɛ̂ nə lás nə lúu wâm; Dâ muud nyə á ntɨ mə yɛ́ nyə a bwey lwágʉlə mə sâ mə́ bág dʉ cɨ yí nə sâ mə́ bág dʉ bwiiŋg yí. ");
INSERT INTO mcp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mə mpú ntâg nə́ sâ Dâ mə cɨ́ nə́ í bə́g yí, gwə́ wə́ í dʉ yə búúd cʉg á kandʉgə kandʉgə. Nə́ ndɛɛ́, sâ jɛ̂sh mə́ ŋgə́ lás yí, mə ŋgə lás nda Dâ nyə á cɨ nə́ mə dʉ́g lás nə́.» ");
INSERT INTO mcp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Í á ka zə bə, zaŋ *Páska í ŋgə́ bə nə́ í zə́ tɛ́ɛ́d ɨɨ́, Yésus nyə á ŋgə bwey mpu nə́ wəla í mə́ wɔ́ɔ́s nə́ a wúg shí gaád kə wə́ Dâ. Nda nyə á bul cɛɛl buud bɛ́ nə́, nyə á ka nə́mə́ cɛɛl bwo kə wɔ́ɔ́s mə́shíné mə́ cʉg jé. ");
INSERT INTO mcp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nə́ ndɛɛ́, bə́nɔ̂ŋ buud bɛ́ bwə́ á ka ŋgə də; bwə́ ŋgə́ də ntʉ́nɨ, ndug Njwû məjamb mə́ bwey wá Yúdas mwân mə Shímun Iskariyôt tə́dʉ́gá lámʉ́d nə́ a kúshag nə Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nə́ ndɛɛ́, Yésus nywáá nyə á ŋgə bwey mpu nə́ Dâ nyə a mə́ sá nə́ a jwúg nə isâ byɛ̂sh, a ŋgə́ mpu nə́ nyə á zhu wə́ Dâ, a zə́ nə́mə́ nyiŋgə kə wə́ Dâ. ");
INSERT INTO mcp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yésus ŋgə́ bwey mpu ntɔ́, a mú tɔ̂w shí, yîl káándə́ nyə́ á bə nə ndɨ́ gwɔ́w yí, a mú ŋwa táwʉla cɛ̧ɛ̧lə kugʉd. ");
INSERT INTO mcp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A mú shwu mə́júwó bíshim dɨ̂, tɛ́ɛ́d ŋgə́lə gusa *ompwíín bɛ́ məkuú, ŋgə fîm nə táwʉla nyə á cɛ̧ɛ̧lə kug dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Í mú zə wɔ́ɔ́s nə́ a gúsag Shímun Pyɛ̂r mɛ́ mə́kuú. Shímun Pyɛ̂r mú cɨ nə nɛ́ nə́: «Wo, Cwámba? Wó gusa mə məkuú?» ");
INSERT INTO mcp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yésus nə nɛ́ nə́: «Sâ mə́ ŋgə́ sá ga, wo cugɛ́ nə ŋkul fwo mpu gwo kɨ́kɨdɨ́ga, wo bá yida shúgʉla wámbʉlə gwo.» ");
INSERT INTO mcp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pyɛ̂r mú cɨ nə nyə nə́: «Mbɔ̂! Wo abʉ́lɛ́ bwɛlɛ gusa mə məkuú.» Yésus mú bɛ̧sa nə nyə nə́: «Mə́ ka bə kú gusa wo məkuú, wo nda ná nyiŋgə bə múúd waamə̂.» ");
INSERT INTO mcp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Shímun Pyɛ̂r mú ka cɨ nə nyə nə́: «Ŋkí ntɔ́ Cwámba, kú gusa mə njɨ məkuú; gusag nə́mə́ mə məbwə̂, nə lúu!» ");
INSERT INTO mcp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yésus mú cɨ nə nyə nə́: «Muud nyə ámə bwey gusa yɛ́ mə́ dʉ jɨɨ nə́ bwə́ gúsag nyə njɨ məkuú, kú ná nyiŋgə bə nyúúl nyɛ̂sh, nəcé á bwey bə fúbán. Bɨ báá bɨ bʉ́sə ntâg mífúbán, njɨ kú bə bɨ́ bɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yésus nyə á ŋgə bwey mpu muud mə bá kusha nə nyə yɛ́; gwə́ wə́ nyə á cɨ nə bwo nə́: «Bɨ bɛ̂sh dɨ́ bʉ́sə́ mífúbán» yí. ");
INSERT INTO mcp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ja Yésus nyə a shîn gusa ompwíín bɛ́ məkuú ntʉ́nɨ yí, nyə á nyiŋgə bwáád káándə́ yé nə́ ndɛɛ́ a mú nyiŋgə kə ji shí, də. A mú jî bwo nə́: «Sâ mə ámə sá bɨ́ nɨ, ye bɨ mə mpú nda í kə́ nə́? ");
INSERT INTO mcp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bɨ mə́ dʉ dɨ́ jɔ̂w mə nə́: “Yɨ́ɨ́gʉli”, gúl ja nə́: “Cwámba.” Bɨ mə́ dʉ mpu sâ, nəcé mə jisə Yɨ́ɨ́gʉli, mə Cwámba. ");
INSERT INTO mcp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ŋkí mə Yɨ́ɨ́gʉli, mə Cwámba, mə mə́ gusa bɨ́ məkuú, bɨ mə́ jəla nə́mə́ nə dʉ sá ntɔ́ mpə́dʉ́gá nyɨ́n. ");
INSERT INTO mcp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nəcé yuug wə́ mə mə́ yə bɨ́ nɨ. Nda mə ámə sá bɨ́ nɨ, dʉgá sɨ́ya ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, lwaá í ádɛ́ bwɛlɛ ntɔ̧ mása, *muud lwámá nda bwɛlɛ ntɔ̧ múúd nyə ámə kənd nyə lwámád yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bɨ mə́ mpu ntɔ́ wə́ nɨ; bɨ́ mə́ ká dʉ sá ntɔ́, bɨ mə́ jəla. ");
INSERT INTO mcp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mə aŋgɛ̂ nə cɨ bɨ bɛ̂sh. Mə mpú búúd mə́ á fɛ́ɛ́sh wá. Njɨ, í jɨɨ nə́ sâ jɨ́ cilyá Kálaad Zɛmbî dɨ́ yí í bwə́mag. Jɨ́ cilyá nə́: “Muud sá ŋgə́ də səŋ ŋgwûd yɛ́ mə́ tɛ́ɛ́d nə́ a lúmbʉ́lí nə mə”. ");
INSERT INTO mcp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mə mə́ fwo bwey jaaw bɨ́ gwo kɨdɨ́ga, í kú fwo sɨ̂y, shú nə́ ja í bá sɨ̂y yí, bɨ bág *magʉlə nə́ mə jisə. ");
INSERT INTO mcp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud mə lə́g múúd lwámá wâm yɛ́, a mə́ lə́g mə; muud mə lə́g ntâg mə yɛ́ mə́ lə́g múúd nyə á ntɨ mə yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ja Yésus nyə a shîn cɨ ntʉ́nɨ yí, mitə́dʉ́gá mí á búbulə nyə lámʉ́d; a mú lás nə́: «Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, ŋgwɔ́l múúd á na bɨ́dɨ́ nyə é kusha nə mə.» ");
INSERT INTO mcp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","*Ompwíín bwə́ mú ŋgə dʉ́gya mpə́dʉ́gá nyáŋ ŋgə sɔ̧́ nə́ bwə́ mpúg muud Yésus ŋgə́ cɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mpwíín Yésus nyə á dʉ bul cɛɛl yɛ́ nyə á bə a njúl Yésus dɨ́ koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Shímun Pyɛ̂r mú ŋgə nyúg nyə mpu nə́: «Shílə́g nyə muud á ŋgə́ cɨ yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mpwíín wɔɔŋg mú yid, jɛ́ɛ́g Yésus lúu bʉd dɨ́ jî nyə nə́: «Cwámba, jísə zə́ eé?» ");
INSERT INTO mcp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yésus mú bɛ̧sa nə́: «Mə zə́ juwo kʉ́l bʉlɛ́d ídʉ̂wʉd, muud mə́ é yə yɛ́, muud wɔɔŋg wə́ ɛ́cɨ́.» Yésus mú ŋwa kʉ́l bʉlɛ́d juwo ídʉ̂w dɨ́, yə Yúdas Iskariyôt, mwân mə Shímun. ");
INSERT INTO mcp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Njɨ Yésus mə́ yə nyə kʉ́l bʉlɛ́d nɨ yí, *Sátan mə́ nyíi wə́ Yúdas. Yésus mú cɨ nə nyə nə́: «Lɛɛlʉg sá sâ wó ŋgə́ jɨɨ nə́ wo sá yí.» ");
INSERT INTO mcp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Buud bwə́ á bə cínɔŋg wá, kú nə tɔɔ ŋgwúd nyə á mpu sâ Yésus nyə á cɨ nə nyə ntɔ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nda í á bə nə́ Yúdas nyə á dʉ bii maŋga *mwaanɛ̂ nə́, bɔ́ɔ́l bwə́ á ŋgə tə́dʉga nə́ Yésus nyə á ŋgə cɨ nə nyə nə́ a kə́g kusə ísâ í zâŋ, ŋkí ntâg nə́ a kə́g yə mímbúmbúwá gúl sâ. ");
INSERT INTO mcp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yúdas nyɛ nyə á shwal cúwo tɔ́ɔ́n ja nyə́ á ŋwa kʉ́l bʉlɛ́d yí, í njúl mpwó-bulú. ");
INSERT INTO mcp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Njɨ Yúdas nyə a cúwo tɔ́ɔ́n yí, Yésus mú cɨ nə́: «Mwân mə Múúd mə́ ŋwa gúmə́ ja gaád, a mə́ sá nə́mə́ nə́ Zɛmbî ŋwág gúmə́. ");
INSERT INTO mcp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Zɛmbî nyəmɛ́fwó nyə e lwóya gúmə́ mə́ *Mwân mə Múúd, a wál nə́mə́ zə lwóya gwo. ");
INSERT INTO mcp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yé bwán bâm, sə́nɔ̂ŋ bɨ́ sə́ é ji njɨ fúfwálá. Bɨ mə bá sɔ̧́ mə; nə́ ndɛɛ́, nə́mə́ nda mə á cɨ nə *Oyúdɛn nə́, mə́ cɨ nə́mə́ nə bɨ́ ja gaád nə́: “Bɨ́ cugɛ́ nə ŋkul kə kʉ́l mə́ zə́ kə yí.” ");
INSERT INTO mcp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mə yə́ bɨ́ cɛ̧ɛ̧ agúgwáan, dʉ́sə nə́: “Cɨɨlagá bɨmɛ́fwó nə bɨmɛ́fwó. Nə́mə́ nda mə á cɛɛl bɨ́ nə́, cɨɨlagá bɨmɛ́fwó nə bɨmɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sâ í é sá nə́ buud bwə́ dʉ́g mpu nə́ bɨ bʉ́sə ompwíín bâm yí jísə cɛɛlí bɨ́ é ŋgə cɨɨla bɨmɛ́fwó nə bɨmɛ́fwó yí.”» ");
INSERT INTO mcp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Shímun Pyɛ̂r mú cɨ nə nyə nə́: «Cwámba e, wo kə́ ŋgow ée?» Yésus nə nyə nə́: «Kɨ́kɨdɨ́ga, wo cugɛ́ nə ŋkul bɛ̧ mə kʉ́l mə́ é kə yí, wo e bá shúgʉla bɛ̧ mə.» ");
INSERT INTO mcp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pyɛ̂r mú bɛ̧sa nə́: «Cwámba, mə cugɛ́ nə ŋkul ka bɛ̧ wo kɨ́kɨdɨ́ga nəcé jɨ? Mə jɨ nə ŋkul kɛɛnzh cʉg jâm shú dwô.» ");
INSERT INTO mcp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yésus mú bɛ̧sa nə́: «Wo jɨ nə ŋkul bə́lɛ kɛɛnzh cʉg gwô shú dâm? Bʉ́bə́lɛ́, mə́ jaaw wo nə́, shúshwóógʉ́ nə́ ŋgwúm kúwó kwáágʉ́gi, wo e kɨ́ɨ́lya mə ija ilɔ́ɔl.» ");
INSERT INTO mcp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Mitə́dʉ́gá mí nda bɛɛg búbulə bɨ́ mílúúd. Búgʉ́lágá Zɛmbî, bɨ́ *búgʉla mə. ");
INSERT INTO mcp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Njɔ́w mə́ Dâ wúsə nə zhwog ikʉ́l búúd bɨ́ nə ŋkul ji yí. Í mbə̂m bə kú bə ntɔ́, ŋki mə mə́ nə́mə́ jaaw bɨ̂. Mə zə́ kə kwambʉlə bɨ́ jiya. ");
INSERT INTO mcp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ja mə́ bá shîn kwambʉlə bɨ́ jiya yí, mə bá nyiŋgə zə ŋwa bɨ́, kə nə bɨ̂. Mə bá kə nə bɨ́ nə́ bɨ bág nə́mə́ bə kʉ́l mə́ jísə́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bɨ mə mpú ntâg zhɨɨ́ í kə́ kʉ́l mə́ zə́ kə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tómas mú cɨ nə nyə nə́: «Cwámba, sə́ bâŋ nda mpu kʉ́l wó zə́ kə yí, sə́ é ka mpu zhɨ́ɨ́ á wu ntʉdɛlɛ?» ");
INSERT INTO mcp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yésus mú cɨ nə́: «Mə wə́ jísə́ zhɨ́ɨ́, mə obʉ́bə́lɛ́, mə cʉg. Muud cugɛ́ nə ŋkul kə wə́ Dâ kú ciŋgya mə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Í ká bə nə́ bɨ mə mpú mə, bɨ é mpu nə́mə́ Sɔ́ɔ́ŋgʉ́ waamə̂. Nə́ ndɛɛ́, tɛ́ɛ́d kɨ́kɨdɨ́ga, bɨ mə́ mpu nyə, bɨ mə́ nə́mə́ dʉ́g nyə.» ");
INSERT INTO mcp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fílíp mú cɨ nə́: «Cwámba, lwóg sə́ Dâ, bímbí dɔɔŋg í é jəla nə sə̂.» ");
INSERT INTO mcp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yésus nə́: «Ɔ Fílíp! Wo afwóyɛ́ mpu mə? Bímbí shwə́ mə́ ji ga? Muud mə́ dʉ́g mə yɛ́, mə́ dʉ́g Dâ. Nəcé jɨ́ wó nyíŋgə́ cɨ nə́ mə lwóg bɨ́ Dâ yí? ");
INSERT INTO mcp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ye wo aŋgɛ̂ nə *magʉlə nə́ mə jɨ Dâ dɨ́ cwû, Dâ njúl mə́dɨ́ cwû? Lə́sʉ́ wɛ̂sh mə́ ŋgə́ lás nə bɨ́ yí, mə aŋgɛ̂ nə cɨ tɔɔ ciyá nə lúu wâm. Dâ muud njúl mə́dɨ́ cwû wə́ ŋgə́ sá misɔ́ɔ́lʉ́gʉ́ myɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Magʉləgá nə́ mə jisə Dâ dɨ́ cwû, Dâ njúl mə́dɨ́ cwû. Nywágá nə́mə́ ka magʉlə nə dʉ́gʉ́lə mísɔ́ɔ́lʉ́gʉ́ mə́ ŋgə́ sá myá. ");
INSERT INTO mcp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, muud mə búgʉ́lá mə yɛ́, a bá nə́mə́ sá mísɔ́ɔ́lʉ́gʉ́ mə́ ŋgə́ sá myá; a bá nə́mə́ sá myɔɔŋg mí búl nyiŋgə ntɔ̧ myá. A bá sá myo nəcé mə zə́ kə wə́ Dâ. ");
INSERT INTO mcp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sâ jɛ̂sh bɨ́ mə́ bá gwáámb nə jínə́ dâm yí, mə bá sá gwo; ntɔ́, Mwân mú bá sá nə́ Sɔ́ɔ́ŋgʉ́ ŋwág gúmə́. ");
INSERT INTO mcp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bɨ́ mə́ ká gwáámb mə gúl sâ nə jínə́ dâm, mə sá gwo. ");
INSERT INTO mcp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Bɨ́ mə́ ká cɛɛl mə, bɨ e wá mílúú mə́cɛ̧ɛ̧ mâm dɨ́, ");
INSERT INTO mcp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","mɛɛ ka bá jəgʉla nə Dâ. A bá ntɨ bɨ́ ŋgwɔ́l múúd mə bá zə dʉ bándʉlə bɨ́ yɛ́, bɨnɔ́ŋ nyâŋ zə bá jɨ kandʉgə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nyâŋ wə́ Shíshim óbʉ́bə́lɛ́; Shíshim búúd ɔ shí ga bwə́ cúgɛ́ nə ŋkul lə́g yí. Bwə́ cúgɛ́ nə ŋkul lə́g nyə nəcé bwə́ áŋgɛ̂ nə dʉ́g nyə, bwə́ ámpúyɛ́ nə́mə́ nyə. Bɨ bâŋ bɨ mə mpú nyə, nəcé bɨnɔ́ŋ wə́ bʉ́sə́, a bá nə́mə́ ŋwa jiya bɨ́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mə abʉ́lɛ́ lʉ́gə bɨ́ bwân ónyulú, mə bá nyiŋgə zə bɨ́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Í mə́ lʉ́g bʉ́baalɛ́ fwála, buud bwə́ á nyiŋgəyɛ́ ná dʉ́g mə. Bɨ bâŋ bɨ mə bá dʉ́g mə mə ŋgə́ cʉgə, bɨ ka ntâg bá cʉgə. ");
INSERT INTO mcp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jwɔ̂w dɔɔŋgʉ́, bɨ mə́ bá mpu nə́ mə jɨ Sɔ́ɔ́ŋgʉ́ waam dɨ́ cwû, bɨ njúl mə́dɨ́ cwû, mə nə́mə́ bɨ́dɨ́ cwû. ");
INSERT INTO mcp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ŋkí muud mə gwág ísâ byɛ̂sh mə́ ŋgə́ cɨ nə́ í bə́g yí, a bɛ̧ byo, muud wɔɔŋg mə́ cɛɛl mə. Í njúl ntâg nə́, muud mə cɛ́ɛ́l mə yɛ́, Dâ nyə é cɛɛl nyə, mə mú nə́mə́ cɛɛl nyə, mə sá nə́ a mpúg mə.» ");
INSERT INTO mcp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yûdə, kú bə Yúdas Iskariyôt, mú cɨ nə nyə nə́: «Cwámba, wo sá nə́ sə́ mpúg wo, kú sá nə́ buud ɔ shí ga bwə́ mpúg wo, ntɔ́ nyɛ wə́ ntʉdɛl?» ");
INSERT INTO mcp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yésus mú bɛ̧sa nə́: «Múúd mə ká cɛɛl mə, nyə e sá sâ mə́ ŋgə́ cɨ yí, Dâ mú bá cɛɛl nyə; nə́ ndɛɛ́, sə́ bá zə nyə́dɨ́ zə ji jiya. ");
INSERT INTO mcp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muud nyə́ acɛ́ɛ́lɛ́ mə yɛ́, nyə á bəyɛ́ nə məgwág nə lə́sʉ́ wâm. Í njúl nə́ lə́sʉ́ bɨ́ ŋgə́ gwág mə ŋgə́ lás nɨ í áŋgɛ̂ nə zhu mə́dɨ́, í ŋgə zhu wə́ Dâ muud nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mə á dʉ jaaw bɨ́ isâ ínɨ sə́nɔ̂ŋ bɨ́ sə́ njúl ná. ");
INSERT INTO mcp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Njɨ, muud mə bá dʉ zə bándʉlə bɨ́ yɛ́, Ŋkɛ̧́ŋkɛ̧̂ Shíshim Dâ mə bá ntɨ bɨ́ jínə́ dáámʉd yɛ́, a bá jɨ́ɨ́gʉli bɨ́ isâ byɛ̂sh, a dʉ sá nə́ bɨ dʉ́g tə́dʉga ísâ byɛ̂sh mə́ á jaaw bɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mə lʉ́gə́ bɨ́ nə mətəla, mə yə́ bɨ́ mətəla mâm. Mə ayə́yɛ́ bɨ́ mwo nda búúd ɔ shí ga bwə́ dʉ yə bɨ́ nə́. Mitə́dʉ́gá mí nda bɛɛg búbulə bɨ́ mílúúd, kúgá bə nə ifwaas. ");
INSERT INTO mcp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bɨ a shí gwág mə́ á cɨ nə bɨ́ nə́: “Mə é kyey, njɨ mə bá nyiŋgə zə.” Í mbə̂m bə nə́ bɨ mə́ cɛɛl mə, ki bɨ mə́ gwág mə́shusʉg nə́ mə zə́ kə wə́ Dâ, nəcé Dâ mə cɔ̧́ mə. ");
INSERT INTO mcp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mə́ bwey ná jaaw bɨ́ gwo kɨdɨ́ga, í kú fwo sɨ̂y, shú nə́ bɨ bág *búgʉla ja í bá sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tɛ́ɛ́d kɨ́kɨdɨ́ga, mə á nyiŋgəyɛ́ ná ŋgə bul lésha nə bɨ̂, nəcé cî á shí ga ŋgə zə. A cúgɛ́ yida bə nə tɔɔ zhɨ́zhɨɨ́ nə́ a sá mə sâ; ");
INSERT INTO mcp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","í yida jɨɨ nə́ buud bwə́ mpúg nə́ mə́ cɛɛl Dâ, mə́ dʉ sá ísâ njɨ váál Dâ nyə á cɛ̧ɛ̧lə nə́ mə bág dʉ sá yí. Tɔ́wʉ́gâ shé wúgá wa!» ");
INSERT INTO mcp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Mə wə́ jísə́ fwámɛ́ shug lʉ́ kwoolú *vînyə, Dâ jisə mbɔɔl. ");
INSERT INTO mcp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lɔ̂w wɛ̂sh í nɔ́ɔ́d mə́dɨ́ í kú nə ibumə́ yí, a yîl wo. Wɔɔŋg wɛ̂sh í ŋgə́ wúmə yí, a kwambʉlə wo shú nə́ í nyíŋgəg mpu wúmə. ");
INSERT INTO mcp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bɨ mə́ bwey ntâg bə mífúbán, minjɨ́ɨ́gʉ́lá mə́ mə́ jɨ́ɨ́gʉli bɨ́ myá mí mə́ bwey fúb bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nadagá nə mə, nə́mə́ nda mə́ mə́ nada nə bɨ́ nə́. Lɔ̂w lɨ́ɨ́ í cúgɛ́ nə ŋkul wúmə ntʉ́nɨ, í kú bə í nɔ́ɔ́d kug lɨ́ɨ́d. Nə́mə́ váál ŋgwúd, bɨ́ cugɛ́ nə ŋkul bə nə mpumə́ ŋkí bɨ anádáyɛ́ nə mə yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mə wə́ jísə́ shug lʉ́ kwoolú vînyə, bɨ bâŋ milɔ̂w. Nyɔɔŋg mə nádá nə mə, mə ŋwa jiya nyə́dɨ́ lámʉ́d yɛ́, a bá bə nə ibumə́ məŋkund məŋkund; bɨ mə mpú nə́ bɨ́ cugɛ́ nə ŋkul sá sâ mə kú bə. ");
INSERT INTO mcp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Múúd mə ká bə kú nada nə mə, bwə́ bá wusə nyə tɔ́ɔ́n, a mú bə nda lɔ̂w kwoolú vînyə í áshígɛ́ wúmə yí. Milɔ̂w myɔɔŋg mí dʉ shwáás nə́ ndɛɛ́, bwə́ cwéég myo kʉl kuda dɨ́, mí kə jígə. ");
INSERT INTO mcp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bɨ́ mə́ ká nada nə mə, iciyá byâm ŋwa jiya bɨ́dɨ́ mílámʉ́d ɨɨ́, bɨ́ je gwáámb sâ jɛ̂sh bɨ́ mə́ jɨ́ɨ́ yí, í bə. ");
INSERT INTO mcp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Zhɨɨ́ bɨ́ bɨ́ nə ŋkul sá nə́ Dâ ŋwág gúmə́ yí nyísə nə́, bɨ bə́g nə ibumə́ məŋkund məŋkund ɨɨ́, lwágʉlə nə́ bɨ bʉ́sə *ompwíín báamə́. ");
INSERT INTO mcp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mə mə́ cɛɛl bɨ́ nə́mə́ nda Dâ mə cɛ́ɛ́l mə nə́; nadagá mə́dɨ́ cɛɛlíd. ");
INSERT INTO mcp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bɨ́ mə́ ká wá mílúu mə́cɛ̧ɛ̧ mâm dɨ́, bɨ́ nada mə́dɨ́ cɛɛlíd, nə́mə́ nda mə́ mə́ wá lúu mə́cɛ̧ɛ̧ mə́ Dâ dɨ́, mə nada nyə́dɨ́ cɛɛlíd nə́. ");
INSERT INTO mcp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Mə mə́ lás nə bɨ́ ntʉ́nɨ nəcé mə́ jɨɨ nə́ məshusʉg mâm mə́ kálag bɨ́dɨ́, bɨ bə́g nə məshusʉg kú nə njɨ. ");
INSERT INTO mcp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cɛ̧ɛ̧ dâm wə́: Cɨɨlagá bɨmɛ́fwó nə bɨmɛ́fwó nə́mə́ nda mə́ cɛ́ɛ́l bɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gúl cɛɛlí í ányíŋgɛ́ ntɔ̧ jɔɔŋg jɨ nə́ muud mə́ kɛɛnzh cʉg jé shú óshwə́ bɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bɨ́ mə́ ká wá mílúu mə́cɛ̧ɛ̧ mâm dɨ́, bɨ bʉ́sə oshwə́ bâm. ");
INSERT INTO mcp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mə aŋgɛ̂ ná ŋwa bɨ́ nə́ osɔ́ɔl ɔ mə́sáal, sɔ́ɔl məsáal nyə ádɛ́ mpu sâ mása yé ŋgə́ sá yí. Mə ŋgə ŋwa bɨ́ nə́ oshwə́ bâm, mə a mə́ sá nə́ bɨ mpúg sâ jɛ̂sh mə á gwág nə Sɔ́ɔ́ŋgʉ́ waam yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bɨ dɨ́ bɨ a fɛ́ɛ́sh mə; mə wə́ mə a fɛ́ɛ́sh bɨ́, mə yə bɨ́ sɛ́y nə́ bɨ kə́g, kə ŋgə bə nə ibumə́, ibumə́ byɔɔŋg í ji kandʉgə. Í ká bə ntɔ́, Dâ dʉ bá yə bɨ́ sâ jɛ̂sh bɨ́ mə́ bá dʉ gwáámb nə jínə́ dâm yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sâ mə́ ŋgə́ cɨ nə́ bɨ sáág yí jɨ́ nə́ bɨ cɨ́ɨ́lag bɨmɛ́fwó nə bɨmɛ́fwó.» ");
INSERT INTO mcp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Búúd ɔ shí ga bwə́ ká mpii bɨ̂, mpugá nə́ bwə́ á fwo nə́mə́ tɛ́ɛ́d mpii mə. ");
INSERT INTO mcp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bɨ mbə̂m bə búúd ɔ shí ga, ki buud ɔ shí ga bwə́ mə́ cɛɛl bɨ̂ nə́ bɨ bʉ́sə buud báŋ. Ká, bɨ́ cugɛ́ búúd ɔ shí ga, mə a fɛ́ɛ́sh bɨ́, mə wá mbɛ́ɛ́gí mpə́dʉ́gá bɨnɔ́ŋ bwo, gwə́ wə́ búúd ɔ shí ga bwə́ ŋgə́ mpii bɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bɨ ɔ tə́dʉ́gá lə́sʉ́ mə́ á lás nə bɨ́ yí, nə́: “Lwaá í ádɛ́ bwɛlɛ ntɔ̧ mása”. Kagá mpu nə́ ŋkí bwə́ á lwágʉlə mə cúwʉ́lí, bwə́ bá nə́mə́ lwágʉlə bɨ́ cúwʉ́lí; ŋkí bwə́ á bə nə məgwág nə lə́sʉ́ wâm, bwə́ bá nə́mə́ bə nə məgwág nə lə́sʉ́ wʉ́n. ");
INSERT INTO mcp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bwə́ bá dʉ sá bɨ́ isâ ínɨ byɛ̂sh nəcé bɨ́ bə́lə búúd bâm, bâŋ bwə́ ámpúyɛ́ ntâg muud nyə á ntɨ mə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mə a mbə̂m bə kú zə, zə lésha nə bwo, bwə́ nda bə nə *sə́m; ká, bwə́ cúgɛ́ nə kɔɔd bwə́ káádʉg shú sə́m wáŋ ja gaád yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Muud ŋgə́ mpii mə yɛ́ ŋgə mpii Sɔ́ɔ́ŋgʉ́ waamə̂. ");
INSERT INTO mcp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mə a mbə̂m bə kú sá mísɔ́ɔ́lʉ́gʉ́ mə́ á sá bwə́dɨ́ myá, misɔ́ɔ́lʉ́gʉ́ múúd nyə abwɛ́lɛ́ sá myá, bwə́ nda bə nə sə́m; ká, bwə́ á mə́ dʉ́g mísɔ́ɔ́lʉ́gʉ́ myɔɔŋgʉ́, njɨ bwə́ ŋgə mpii sə́, nə mə nə Sɔ́ɔ́ŋgʉ́ waamə̂. ");
INSERT INTO mcp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Njɨ, í ŋgə bə ntɔ́ shú nə́ sâ jísə́ cilyá bwə́dɨ́ mə́cɛ̧ɛ̧ dɨ́ yí í bwə́mag; jísə cilyá nə́: “Bwə́ á mpii mə kú nə sâ mə́ á sá bwo yí.” ");
INSERT INTO mcp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Muud mə bá dʉ zə bándʉlə bɨ́ yɛ́ mə bá zə, nyə wə́ Shíshim óbʉ́bə́lɛ́ mə́ Dâ. Mə bá ŋwa nyə wə́ Dâ, mə ntɨ bɨ̂. Ja á bá zə yí, a bá zə dʉ bwiiŋg sâ í dʉ́gyá nə mə yí. ");
INSERT INTO mcp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bɨ́, bɨ mə bá nə́mə́ dʉ bwiiŋg sâ í dʉ́gyá nə mə yí, nəcé shé á mə́ bə sámbá té mə́tɛ́ɛ́dʉ́lé.» ");
INSERT INTO mcp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mə ŋgə bwey jaaw bɨ́ isâ ínɨ shú nə́ bɨ́ nda bá biil mə́bwə́bʉ́lánʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mpugá nə́ bwə́ bá dʉ yîl bɨ́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lád. Dúl wəla í bá ntâg zə bə nə́, buud bwə́ bá dʉ tə́dʉga nə́ ja nyâŋ mə gwú ŋgwɔ́l a bɨ́dɨ́ yí, a mə́ yə Zɛmbî gúmə́ fwámɛ́ yə. ");
INSERT INTO mcp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bwə́ bá dʉ sá ntɔ́ nəcé bwə́ áshígɛ́ mpu Dâ, kú nə́mə́ mpu mə. ");
INSERT INTO mcp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Njɨ, mə ŋgə bwey jaaw bɨ́ isâ ínɨ shú nə́ ja wəla dɔɔŋg í bá wɔ́ɔ́s yí, bɨ ɔ bá tə́dʉga nə́ mə á shí jaaw bɨ̂.» «Mə a shígɛ́ fwo bwey jaaw bɨ́ isâ ínɨ mə́tɛ́ɛ́dʉ́léd nəcé sə́nɔ̂ŋ bɨ́ sə́ á bə ná sámbá. ");
INSERT INTO mcp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ká ja gaád ɨɨ́, mə zə́ kə wə́ muud nyə á ntɨ mə yɛ́, tɔɔ muud a bɨ́dɨ́ sámbá nyə ashílɛ́ ntâg mə nə́: “Wo kə́ ŋgow?” ");
INSERT INTO mcp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Njɨ, nda mə́ ŋgə́ jaaw bɨ́ isâ ínɨ nə́, bɨ mə́ shîn bul bə nə məcɛy mílámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Njɨ, tɛɛm bə ntɔ́, mə mə́ jaaw bɨ́ bʉ́bə́lɛ́. Í yida bə bɨ́ nə mfíí nə́ mə kyéyʉg; mə́ ká bə kú kə, muud mə bá zə dʉ bándʉlə bɨ́ yɛ́ kú zə bɨ́dɨ́. Mə́ ká yida kə, mə mú bá ntɨ bɨ́ nyə. ");
INSERT INTO mcp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ja á bá ntâg zə yí, a bá zə sá nə́ buud ɔ shí ga bwə́ mpúg iwushí bʉ́sə́ nə ndɨ́ kɔ́ɔ́mb á *sə́m, nə otʉ́təlí, nə sémbyé mílə́sʉ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iwushí bʉ́sə́ nə ndɨ́ kɔ́ɔ́mb á sə́m yí bísə nə́ bwə́ abúgʉ́láyɛ́ mə. ");
INSERT INTO mcp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bwə́ nyiŋgə bə nə iwushí kɔ́ɔ́mb á otʉ́təlí dɨ̂; byáŋ bísə nəcé mə zə kə wə́ Dâ, bɨ ányiŋgəyɛ́ ná dʉ́g mə. ");
INSERT INTO mcp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bwə́ ka nə́mə́ nyiŋgə bə nə iwushí kɔ́ɔ́mb á sémbyé mílə́sʉ́d; bísə nəcé Zɛmbî mə́ bwey sámb Cî á shí ga lə́sʉ́ yé. ");
INSERT INTO mcp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mə jɨ ná nə zhwog isâ nə́ mə ŋgə́g nə jaaw bɨ̂; njɨ, bɨ́ cugɛ́ nə ŋkul jísɔw byo kɨ́kɨdɨ́ga. ");
INSERT INTO mcp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ja Shíshim á obʉ́bə́lɛ́ mə bá zə yí, a bá jaand nə bɨ́ nə́ ndɛɛ́ bɨ́ wámbʉlə óbʉ́bə́lɛ́ bɛ̂sh. Nyə abʉ́lɛ́ dʉ lás ísâ nə lúú yé, a bá dʉ kala bɨ́ isâ bwə́ bá dʉ jaaw nyə yí, a dʉ jaaw bɨ́ isâ í bá sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A bá sá nə́ mə ŋwág gúmə́, nəcé a bá dʉ lə́g ísâ byâm a dʉ jaaw bɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sâ jɛ̂sh Sɔ́ɔ́ŋgʉ́ waam jɨ́ nə ndɨ́ yí jísə sâ jâm, gwə́ wə́ mə́ cɨ́ nə́ a bá jaaw bɨ́ isâ á bá lə́g mə́dɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Í mə́ lʉ́g bʉ́baalɛ́ fwála, bɨ á nyiŋgəyɛ́ ná dʉ́g mə; bʉ́baalɛ́ fwála ká nyiŋgə cɔ̧̂, bɨ mú nyiŋgə dʉ́g mə.» ");
INSERT INTO mcp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bɔ́ɔ́l *ómpwíín bwə́ mú ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Jɨ́ gwə́mɛ́fwó á ŋgə́ cɛɛl cɨ yí? A cɨ nə́: “Í mə́ lʉ́g bʉ́baalɛ́ fwála, bɨ á nyiŋgəyɛ́ ná dʉ́g mə; gúl bʉ́baalɛ́ fwála kú nyiŋgə cɔ̧̂, bɨ mú nyiŋgə dʉ́g mə.” Nyə ámə fwo nə́mə́ cɨ nə́: “Mə zə́ kə wə́ Dâ.” Ntɔ́ mə́ kə́ nə́ jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bwə́ nə́: «“Bʉ́baalɛ́ fwála” ntɔ́ nyɛ mə kə́ nə́ jɨ́? Sə́ ampúyɛ́ sâ á ŋgə́ cɛɛl cɨ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yésus músə mpu nə́ bwə́ wál cɛɛl zə jî nyə mishílí, a mú ka cɨ nə bwo nə́: «Mə ámə cɨ nə bɨ́ nə́: “Í mə́ lʉ́g bʉ́baalɛ́ fwála, bɨ á nyiŋgəyɛ́ ná dʉ́g mə; bʉ́baalɛ́ fwála ká nyiŋgə cɔ̧̂, bɨ mú nyiŋgə dʉ́g mə.” Gwə́ wə́ bɨ́ ŋgə́ sɔ̧́ bɨmɛ́fwó nə bɨmɛ́fwó nə́ bɨ mə wámbʉlə yí? ");
INSERT INTO mcp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bɨ mə bá jɨɨ mə́yə̂, bɨ́ tədʉwa, buud ɔ shí ga bâŋ bwə́ ŋgə́ zhwiimbya. Bɨ mə bá bə nə məcɛy mə lâm, njɨ məcɛy mɔɔŋg mə́ bá nyɛɛ bɨ́ məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ja múdá wəla lʉ byɛ́yí í dʉ wɔ́ɔ́s yí, ŋgaá á dʉ bə nə məcɛy. Ŋgaá ja á mə́ byâ yí nyə ádɛ́ ná tə́dʉga mə́cɛy, a yida gwág mə́shusʉg nə́ a mə́ byá? ");
INSERT INTO mcp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nə́mə́ mbií ŋgwúd wɔɔŋgʉ́, bɨ́ bʉ́sə nə məcɛy ja gaád; njɨ, mə bá nyiŋgə dʉ́g bɨ́, bɨ́ ka bá bə nə məshusʉg; muud nyə abʉ́lɛ bwɛlɛ dɛ́ɛ́g bɨ́ mâŋ mə́shusʉg. ");
INSERT INTO mcp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja jwɔ̂w dɔɔŋg í bá bə yí, bɨ abʉ́lɛ ná nyiŋgə jî mə shílí tɔɔ gúl sâ nə gúl. Bʉ́bə́lɛ́, mə́ jaaw bɨ́ nə́, bɨ́ mə́ ká gwáámb Dâ sâ nə jínə́ dâm, a yə bɨ́ gwo. ");
INSERT INTO mcp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wɔ́ɔ́s nə kɨ́kɨdɨ́ga, bɨ afwóyɛ́ ná gwáámb sâ nə jínə́ dâm. Gwáámbʉ́gá, bɨ é bii, məshusʉg ka bə bɨ́ kú nə njɨ.» ");
INSERT INTO mcp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mə mə́ ŋgə lás nə bɨ́ lə́sʉ́ nɨ wɛ̂sh ómpwokwoond dɨ̂. Njɨ, dúl wəla í bá zə bə, wəla dɔɔŋgʉ́, mə abʉ́lɛ ná dʉ lás nə bɨ́ ntɔ́, mə bá dʉ jaaw bɨ́ isâ í dʉ́gyá nə Dâ yí nə́ kpwɔɔ́ kpwɔɔ́. ");
INSERT INTO mcp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jwɔ̂w dɔɔŋgʉ́, bɨ mə bá gwáámb Dâ isâ nə jínə́ dâm, mə acɨ́yɛ́ nə́ mə bá jəgʉla nə nyə shú dʉ́n, mbɔ̂; ");
INSERT INTO mcp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nyəmɛ́fwó mə́ cɛɛl bɨ́. A cɛɛl bɨ́ nəcé bɨ á cɛɛl mə, bɨ́ magʉlə nə́ mə á wú wə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mə á wú wə́ Dâ, mə zə wa shí mishwun; ja gaád ɨɨ́, mə zə́ wú wa shí mishwun kə wə́ Dâ.» ");
INSERT INTO mcp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","*Ompwíín bɛ́ bwə́ mú cɨ nə nyə nə́: «Wo mə́ dʉ́g ɨɨ́, wo mú ŋgə lás ja gaád nə́ kpwɔɔ́ kpwɔɔ́, kú ná nyiŋgə bə ómpwokwoond dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sə́ mə́ mpu ja gaád nə́ wɛɛ mə mpú sâ jɛ̂sh, nə́ í ajɨ́ɨ́yɛ́ nə́ muud shílə́g wo shílí. Gwə́ wə́ sə́ mə́ ka magʉlə nə́ wo a wú wə́ Zɛmbî yí.» ");
INSERT INTO mcp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yésus mú bɛ̧sa nə bwo nə́: «Bɨ mə́ ka tɛɛm magʉlə ja gaád ɛ̧ɛ̧́? ");
INSERT INTO mcp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dʉgá, dúl wəla í bá zə bə, í mə́ bwey nə́mə́ bə, wəla á nə́ bɨ é cɨɨma, muud yɛ̂sh kə jé kɔ́ɔ́mb, bɨ́ lʉ́gə mə məmɛ́fwó. Njɨ, mə cugɛ́ mə́mɛ́fwó, sá Dâ wə́ bʉ́sə́. ");
INSERT INTO mcp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mə ŋgə bwey jaaw bɨ́ isâ ínɨ shú nə́ bɨ bə́g nə mətəla mə́dɨ́ kwoŋʉd. Shí ga í bá lwágʉlə bɨ́ *incwaw í ntʉg; njɨ bɨ ɔ́ lwóyá íŋkáŋ, mɛɛ mə́ ntɔ̧ *mə́ŋkul mâ shí ga.» ");
INSERT INTO mcp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ja Yésus nyə á shîn lás ntʉ́nɨ yí, nyə bʉ̂n mpwoombʉ́ dʉ́g gwɔ́w a mú cɨ nə́: «Ye Dâ, wəla mə wɔ́ɔ́s. Ság nə́ Mwân woó ŋwág gúmə́ shú nə́ Mwân woó kág nə́mə́ yə wo gúmə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A ŋwág gúmə́ shú nə́ a yə́g buud bɛ̂sh wo á yə nyə wá cʉg á kandʉgə kandʉgə, nda wo á yə nyə ŋkul nə́ a jwúg nə buud bɛ̂sh nə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Cʉg á kandʉgə kandʉgə jɔɔŋg jísə nə́ muud mpúg wo, fwámɛ́ Zɛmbî ŋgwûd nə ŋgwûd jísə́ yɛ́, ka nə́mə́ mpu Yésus-Krîst muud wo á ntɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mə mə́ sá nə́ wo ŋwág gúmə́ shí gaád, mə mə́ casʉlə ísɛ́y wo á cɨ nə́ mə sáág yí. ");
INSERT INTO mcp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dâ, mə á bwey dʉ bə nə gúmə́ wódɨ́ koogʉ́, shí nə gwɔ̂w nda fwo bə; ság ja gaád nə́ mə nyíŋgəg bə nə gúmə́ jɔɔŋg wódɨ́ koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Buud wo á fɛ́ɛ́sh yə mə mpə́dʉ́gá buud ɔ shí ga wá, mə á mə́ sá nə́ bwə́ mpúg sâ wó jísə́ yí. Bwə́ á bə buud bwô, wo á ka yə mə bwo, bwə́ mú gúmal lə́sʉ́ wô. ");
INSERT INTO mcp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bwə́ mə́ mpu ja gaád nə́ sâ jɛ̂sh wo á yə mə yí í á wú wódɨ́, ");
INSERT INTO mcp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","nəcé iciyá wo á yə mə yí, mə á yə bwo byo. Bwə́ á mə́ bii byo, bwə́ á mə́ mpu fwámɛ́ mpu nə́ mə á wú wódɨ́, bwə́ á mə́ ntâg magʉlə nə́ wo á ntɨ mə. ");
INSERT INTO mcp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mə ŋgə jəgʉla shú dáŋ, kú bə shú búúd ɔ shí ga; mə ŋgə jəgʉla shú búúd wo á yə mə wá, nəcé bʉ́sə buud bwô. ");
INSERT INTO mcp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sâ jɛ̂sh mə́ jɨ́ nə ndɨ́ yí jísə sâ gwô, jɔɔŋg jɛ̂sh wó jɨ́ nə ndɨ́ yí jísə sâ jâm. Buud wo á yə mə wá bwə́ á mə́ sá nə́ mə ŋwág gúmə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mə ányiŋgəyɛ́ ná bə wa shí, mə ŋgə zə nûŋ wódɨ́, njɨ bâŋ bʉ́sə ná wa shí. Dâ, wo muud wó ádɛ́ sɛɛŋgya nə məbɔ̂w yɛ́, baagʉləg bwo nə ŋkul nyísə́ wódɨ́ jínə́ dɨ́ yí, ŋkul wo á yə mə yí. Baagʉləg bwo ntɔ́, bwə́ bə́g sâ ŋgwûd nə́mə́ nda mə nə wo, shwə́ bʉ́sə́ sâ ŋgwûd nə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ja sə́nɔ́ŋ sə́ á bə yí, mə á ŋgə baagʉlə bwo nə ŋkul nyísə́ wódɨ́ jínə́ dɨ́ yí; mə á dʉ baagʉsə bwo nə́ ndɛɛ́, tɔɔ ŋgwûd nyə a shígɛ́ jímb, sʉsaalɛ̂ nə́mə́ njɨ nyɔɔŋg nyə á bə nə́ a bá jímb yɛ́. Ntɔ́, sâ jɨ́ mícilyád yí í á mə́ bwəma. ");
INSERT INTO mcp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mə ŋgə zə wódɨ́ ja gaád; mə ŋgə ná lás lə́sʉ́ ga mə njúl wa shí shú nə́ məshusʉg mâm mə́ kálag bwə́dɨ́ kú nə njɨ. ");
INSERT INTO mcp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mə á yə bwo iciyá byô, buud ɔ shí ga bwə́ mú ntâg mpii bwo; bwə́ mpii bwo nəcé báá bwə́ cúgɛ́ búúd ɔ shí ga, nə́mə́ nda mə́ cúgɛ́ múúd a shí ga nə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mə acɨ́yɛ́ nə́ wo yílʉ́g bwo shí gaád, mbɔ̂. Mə́ yida cɨ nə́ wo báágʉləg bwo, Mbʉ́wʉ́lú múúd nda sá bwo sâ. ");
INSERT INTO mcp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bwə́ cúgɛ́ búúd ɔ shí ga, nə́mə́ nda mə́ cúgɛ́ muud a shí ga nə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ság nə́ bwə́ ŋgə́g nə bɛ̧ obʉ́bə́lɛ́ bwô, bwə́ ka ŋgə béégya nə məbɔ̂w; kɛ́ɛl dwô dʉ́sə obʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wo á ntɨ mə shí gaád, mə zə́ nə́mə́ kənd bwo shí gaád. ");
INSERT INTO mcp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mə tə́l mə́mɛ́fwó jâm cé shú nə́ obʉ́bə́lɛ́ bwə́ sáág nə́ bwə́ béégyág nə məbɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Mə aŋgɛ̂ nə bul jəgʉla njɨ shú dáŋ. Mə́ jəgʉla nə́mə́ shú búúd bɛ̂sh bwə́ bá *búgʉla mə nəcé láŋ wáŋ wá. ");
INSERT INTO mcp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mə́ jəgʉla nə wo nə́ bɛ̂sh bwə́ bə́g sâ ŋgwúd. Dâ, wo jɨ mə́dɨ́ cwû, mə njúl wódɨ́ cwû. Nə́mə́ nda shwə́ bʉ́sə́ ntɔ́ nə́, mə́ jəgʉla nə wo nə́ bwə́ bə́g nə́mə́ shwə́ dɨ́ cwû, buud ɔ shí ga bwə́ mágʉləg nə́ wo á ntɨ mə. ");
INSERT INTO mcp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mə a mə́ yə bwo milwanə́ wo á yə mə myá, nə́ bwə́ bə́g sâ ŋgwúd nə́mə́ nda shwə́ bʉ́sə́ sâ ŋgwúd nə́, ");
INSERT INTO mcp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","í bə́g nə́, mə njúl bwə́dɨ́ cwû, wo njúl mə́dɨ́ cwû, bwə́ mú bə sâ ŋgwúdʉ́ váál í jə́la yí, buud bwə́ mú mpu nə́ wo á ntɨ mə, wó cɛɛl ntâg nə́mə́ bwo nda wó cɛ́ɛ́l mə nə́. ");
INSERT INTO mcp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dâ, mə́ jɨɨ nə́ kʉ́l mə́ jísə́ yí, sə́nɔ̂ŋ buud wo á yə mə wá sə́ bə́g, bwə́ bényʉg milwanə́ wo á yə mə myá. Wo á yə mə myo nəcé wo á bwey cɛɛl mə wo nda fwo fwɔ̧ shí nə gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dâ, wo muud jɨ́ tʉ́təlí yɛ́, buud ɔ shí ga bwə́ ámpúyɛ́ wo, mɛɛ mə mpú wo, buud wo á yə mə ɔ́ga bwə́ á mə́ mpu nə́ wo á ntɨ mə. ");
INSERT INTO mcp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mə a mə́ sá nə́ bwə́ mpúg sâ wó jísə́ yí, mə é nyiŋgə nə́mə́ ŋgə sá, shú nə́ váál cɛɛlí wó cɛ́ɛ́l mə yí í bə́g bwə́dɨ́ ícʉg dɨ́, mə njúl bwə́dɨ́ ícʉgʉd.» ");
INSERT INTO mcp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ja Yésus nyə a shîn cɨ ntʉ́nɨ yí, nyə á kyey, bə́nɔ̂ŋ *ompwíín bɛ́ bwə́ mú ntɔ̧ Kédron, kə faŋwíny; gúl fambə́ í á dʉ bə nûŋ, bə́nɔ̂ŋ ompwíín bɛ́ bwə́ á dʉ bwey kə cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na jɨ nə́, Yúdas, muud nyə á kusha nə nyə yɛ́, nyə á bwey dʉ mpu kʉ́kʉ́l jɔɔŋgʉ́, nəcé Yésus nyə á kə dʉ sɛɛŋgya nə ompwíín bɛ́ wu ija ija. ");
INSERT INTO mcp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Milúlúú myâ ofada bə́nɔ̂ŋ *Ofarizyɛ̂ŋ bwə́ á ka kənd kínda ózɨmbɨ nə ifulísh nə́ bwə́ kə́g bii Yésus. Bwə́ á ka ŋwa imɔɔs nə məlámba nə məkwɔ̧ɔ̧ mə dɔ́ɔ́mb. Yúdas mú ŋwa bwo, bə́nɔ́ŋ bwə́ mú kə fambə́ jɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yésus nyə á ŋgə bwey mpu sâ í zə́ bə nə nyə yí; a mú ka shísh bwə́dɨ́, kə jî bwo nə́: «Bɨ́ ŋgə sɔ̧́ zə?» ");
INSERT INTO mcp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bwə́ nə́: «Sə́ ŋgə sɔ̧́ Yésus á Nazarɛ̂t.» Nyə nə bwo nə́: «Mə wə́ ɛ́ga». Yúdas, muud nyə á kusha nə nyə yɛ́, bə́nɔ̂ŋ buud ɔ́nɨ bwə́ njúl sámbá. ");
INSERT INTO mcp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Í á ka bə, Yésus ká nə́mə́ cɨ nə bwo nə́: «Mə wə́ ɛ́ga», seegya njɨ bwə́ mú ŋgə cúculə nə mikwoŋ nə́ ndɛɛ́ kə ŋgə bʉ́la shí. ");
INSERT INTO mcp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yésus mú nyiŋgə jî bwo nə́: «Bɨ́ ŋgə sɔ̧́ zə?» Bwə́ nə́: «Sə́ ŋgə sɔ̧́ Yésus á Nazarɛ̂t.» ");
INSERT INTO mcp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yésus mú cɨ nə bwo nə́: «Mə shí cɨ nə́: “Mə wə́ ɛ́ga”. Ŋkí mə wə́ bɨ́ ŋgə́ sɔ̧́ yɛ́, bɨ́dʉ́gá bʉ́ga, báá bwə́ kə́g.» ");
INSERT INTO mcp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yésus nyə á cɨ ntɔ́ shú nə́ ciyá nyə́ á fwo bwey cɨ yí í bwə́mag; nyə á fwo bwey cɨ nə́: «Buud wo á yə mə wá, mə a shígɛ́ jímbal tɔɔ ŋgwûd.» ");
INSERT INTO mcp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nə́ ndɛɛ́, Shímun Pyɛ̂r nyə á bə nə kafwɛlɛ. A mú wéém gwo, taad ŋgwɔ́l sɔ́ɔl məsáal mə Ajəlácɨ á ofada, í mú sámb nyə lwə́ á mbwə́ məncwûm. Sɔ́ɔl məsáal wɔɔŋg nyə á bə nə jínə́ nə́ Málkus. ");
INSERT INTO mcp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Njɨ, Yésus mú cɨ nə Pyɛ̂r nə́: «Fɛɛnʉ́g kafwɛlɛ gwô kʉ́l í dʉ ji yí. Ye mə bə́g kú ŋgul bálá Dâ mə́ yə mə yí?» ");
INSERT INTO mcp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nə́ ndɛɛ́, nə kínda ózɨmbɨ, nə tɔ́we shwóg wáŋ, nə ifulísh í *Oyúdɛn bwə́ mú bii Yésus, wɔ́ɔlə nyə məŋkəda. ");
INSERT INTO mcp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bwə́ mú tɛ́ɛ́d fwo kə nə nyə wə́ Hána, cií mə Kayíf muud nyə á bə Ajəlácɨ á ofada mbú wɔɔŋg dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayíf wɔɔŋg wə́ nyə á cɨ nə *Oyúdɛn nə́ í yida bə nə mfíí nə́ muud ŋgwûd yə́g shú kúl búúd jɛ̂sh ncindî yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Shímun Pyɛ̂r bá ŋgwɔ́l *mpwíín bwə́ á ŋgə bɛ̧ Yésus kʉ́l bwə́ á ŋgə kə nə nyə yí. Kə́lə wɔ́ɔ́s Ajəlácɨ á ofada dɨ́ njɔ́w, mpwíín ɛ́nɛ nywáá bə́nɔ̂ŋ Yésus bwə́ mú nyíi, nəcé Ajəlácɨ á ofada nyə á dʉ mpu mpwíín wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pyɛ̂r nyɛ nyə a lʉ́g tɔ́ɔ́n, kúnə́-kúnə nə́ mpumbɛ́. Mpwíín Ajəlácɨ á ofada nyə á dʉ mpu ɛ́nɛ mú zə tɔ́ɔ́n, zə lésha nə mudá nyə á dʉ baagʉlə mpumbɛ́ yɛ́ nə́ ndɛɛ́ nyíŋgal Pyɛ̂r cwû. ");
INSERT INTO mcp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mudá nyə á dʉ baagʉlə mpumbɛ́ yɛ́ mú cɨ nə Pyɛ̂r nə́: «Ŋgaá wo jɨ nə́mə́ mpwíín mə múúd ɛ́nɛ.» Pyɛ̂r nə́: «Kú bə mɛ̂! Mə cugɛ́ mpwíín yé.» ");
INSERT INTO mcp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Osɔ́ɔl ɔ mə́sáal bə́nɔ̂ŋ ifulísh bwə́ á bə bwə́ mə́ jida kuda máág, ka ŋgə gwáalə, nəcé yɔ̂ŋ. Pyɛ̂r nyə á ka nə́mə́ ŋgə gwáalə kuda cínɔŋg bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ajəlácɨ á ofada mú ŋgə shílə Yésus mishílí mí dʉ́gyá nə *ompwíín bɛ́ nə minjɨ́ɨ́gʉ́lá nyə á dʉ jɨ́ɨ́gʉli myá. ");
INSERT INTO mcp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yésus mú bɛ̧sa nə nyə nə́: «Mə á dʉ lás nə buud bɛ̂sh nə́ kpwɔɔ́-kpwɔɔ́, mə á dʉ yə buud minjɨ́ɨ́gʉ́lá ja jɛ̂sh *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lád nə *Luŋ mə́ Zɛmbî dɨ́, kʉ́l *Oyúdɛn bɛ̂sh bwə́ á dʉ sɛɛŋgya yí, mə a shígɛ́ dʉ lás mə́shwoó məshwoó. ");
INSERT INTO mcp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nəcé jɨ́ wó zə́ ŋgə jî mə mishílí yí? Shílə́g búúd bwə́ á dʉ gwág mə wá sâ mə á dʉ lás yí, bwə́ mpû sâ mə́ á dʉ cɨ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ja gúl fulísh mə́ gwág Yésus mə́ bɛ̧sa ntʉ́nɨ yí, a mə́ tɨ́ Yésus bɔ́ɔ́nz, a bâm nə nyə nə́: «Wo bɛ̧sa nə Ajəlácɨ á ofada ntʉ́nɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yésus mú bɛ̧sa nə́: «Ŋkí mə ámə jag lás ɨɨ́, lwóg sâ mə ámə jág cɨ yí. Ká, ŋkí mə ámə mpu lás ɨɨ́, nəcé jɨ́ wó yíd mə yí?» ");
INSERT INTO mcp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hána mú cɨ nə́ bwə́ kə́g nə Yésus wə́ Kayíf, bwə́ mú kə nə nyə, a njúl mə́ŋkədad. ");
INSERT INTO mcp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na nyə á bə, Shímun Pyɛ̂r ŋgə́ gwáalə kuda. Bwə́ mú cɨ nə nyə nə́: «Ŋgaá wo jɨ nə́mə́ *mpwíín yé?» Pyɛ̂r mú kɨ́ɨ́lya nyə, nyə nə́: «Kú bə mɛ̂! Mə cugɛ́ mpwíín yé.» ");
INSERT INTO mcp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ŋgwɔ́l sɔ́ɔl məsáal mə́ Ajəlácɨ á ofada, a njúl nə byɛ̂l nə muud Pyɛ̂r nyə ámə sámb lwə́ yɛ́, mú máalə nyə nə́: «Ŋgaá mə shí dʉ́g bɨ́ná nûŋ fambə́?» ");
INSERT INTO mcp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pyɛ̂r mú nə́mə́ nyiŋgə kɨ́ɨ́lya nyə, ŋgwúm kúwó í wə́ kwáág ntâg. ");
INSERT INTO mcp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nə́ ndɛɛ́, bwə́ mú wú nə Yésus wə́ Kayíf, kə nə nyə luŋ mə ŋgwə́mʉna. Í á bə mán í mə́ ŋgə lə̂m. Njɨ, bwə́ áshígɛ́ nyíi luŋ, nə́ bwə́ á bá lweegʉshi ícʉg nə́ ndɛɛ́ bwə́ kú ná nə zhɨɨ́ bwə́ də́ *Páska. ");
INSERT INTO mcp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilât mú wú luŋ kə kwey bwo tɔ́ɔ́n, nyə nə bwo nə́: «Bɨ́ ŋgə cɨ nə́ muud ɛ́ga nyə ámə sá jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bwə́ mú bɛ̧sa nə nyə nə́: «Sə́ ámə zə yə wo nyə ntʉ́nɨ ntɔ́ a kú sá sâ?» ");
INSERT INTO mcp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilât mú cɨ nə bwo nə́: «Ŋwagá nyə, bɨmɛ́fwó bɨ kə́g sámb nyə lə́sʉ́ váál mə́cɛ̧ɛ̧ mʉ́n mə́ ŋgə́ cɨ yí.» *Oyúdɛn nə́: «Məcɛ̧ɛ̧ mə́sʉ́ mə́ áŋgɛ̂ nə yə sə́ ŋkul nə́ sə́ gwúg muud.» ");
INSERT INTO mcp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ciyá nɨ í mú bwəma nə lwólə Yésus nyə á bwey lwágʉlə váál shwɨy á jə́lá nə bá yə yí. ");
INSERT INTO mcp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilât mú nyiŋgə nyíi luŋ. A mú jɔ̂w Yésus, jí nyə nə́: «Ye wo jisə Njwû Oyúdɛn?» ");
INSERT INTO mcp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yésus mú bɛ̧sa nə́: «Ye wo ŋgə cɨ ntʉ́nɨ nə lúú wô, ye bɔ́ɔ́l búúd bwə́ ámə jaaw wo ntɔ́ shú dâm?» ");
INSERT INTO mcp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilât mú bɛ̧sa nə nyə nə́: «Ye mə jɨ mwâ Yúdɛn? Lɔɔm wô nə milúlúú myâ ofada mí ámə zə nə wo zə yə mə; wo ámə sá ná bwo jɨ?» ");
INSERT INTO mcp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yésus mú bɛ̧sa nə́: «Ijwûga byâm í cúgɛ́ yâ shí ga; í mbə̂m bə ntɔ́, ki buud bâm bwə́ mə́ zə lúmbʉ́líd, zə kaambʉlə nə Oyúdɛn nə́ bwə́ nda bii mə. Ká, ijwûga byâm í cúgɛ́ yâ wa.» ");
INSERT INTO mcp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilât mú cɨ nə nyə nə́: «Ntɔ́ jɨ nə́ wo jɨ Njwú-buud ɨɨ́?» Yésus nə́: «Wo mə́ cɨ, mə jɨ Njwú-buud. Ŋkí mə á zə byɛ̂l shí gaád ɨɨ́, í á bə shú ŋkúmba sâ: nə́ mə zə́g lwágʉlə búúd sâ bwə́ jɔ́w nə́ obʉ́bə́lɛ́ yí. Buud bɛ̂sh bʉ́sə́ búúd wâ obʉ́bə́lɛ́ wá bwə́ dʉ gwágʉlə sâ mə́ cɨ́ yí.» ");
INSERT INTO mcp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilât mú jî nə́: «Jɨ́ jɨ́ nə́ obʉ́bə́lɛ́ yí?» Njɨ nyə á cɨ ntʉ́nɨ yí, a mú nyiŋgə wú luŋ cúwo tɔ́ɔ́n, kə cɨ nə Oyúdɛn nə́: «Mɛɛ mə adʉ́gɛ́ nə́ múúd ɛ́ga mə́ sá gúl sâ mə́bɛ̧ɛ̧́ bɨ́ mə́ jɨ́ɨ́ nyə shwɨy nə ndɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Njɨ, í dʉ bwey bə nə́ mə dʉ́g bɨ́d bɨ́ mbwug ŋgwûd fwála lʉ Páska; nə́ ndɛɛ́, ye bɨ mə́ jɨɨ nə́ mə bɨ́dʉ́g bɨ́ Njwû *Oyúdɛn?» ");
INSERT INTO mcp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bɛ̂sh bwə́ mú nyiŋgə kɨ̂m nə́: «Mbɔ̂! Kú bə nyə! Yidagʉ́ bɨ́d sə́ Barábas!» Barábas ɛ́nɛ nyɛ njúl zhilʉŋgaanə́. ");
INSERT INTO mcp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nə́ ndɛɛ́, Pilât mú kə, kə sá nə́ bwə́ fyámʉ́sə́g Yésus milwóŋ. ");
INSERT INTO mcp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ozɨmbɨ bwə́ mú ŋwa ísâ yâ məgwaagʉlə́, bwə́ lwɔ̧́ *tûm gúmə́ nə́ ndɛɛ́ jil Yésus lúúd; bwə́ mú nə́mə́ bwééd nyə káándə́ ícî atɨ́tɨɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bwə́ mú dʉ shísh nyə́dɨ́ dʉ zə cɨ nə́: «Yé Njwû Oyúdɛn, sə́ ŋgə báág nə wo»; bwə́ mú ŋgə nyífə nyə məmpɔ́ɔ́nz. ");
INSERT INTO mcp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilât mú nyiŋgə wú luŋ, cúwo tɔ́ɔ́n kə cɨ nə Oyúdɛn nə́: «Mə zə́ sá nə́ bwə́ zə́g yə bɨ́ nyə; njɨ mpugá nə́ mə adʉ́gɛ́ ŋkúmba sâ á mə́ sá yí.» ");
INSERT INTO mcp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bwə́ mú zə nə Yésus tɔ́ɔ́n a njúl nə tûm gúmə́ á məgwaagʉlə́ nə káándə́ ícî atɨ́tɨɨ̂. Pilât nə bwo nə́: «Dʉgá, muud wə́ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dʉ́gʉ́lə mílúlúú myâ ofada bə́nɔ̂ŋ ifulísh bwə́ á dʉ́g Yésus yí, bwə́ á zə ji kɨ́mʉ́lə nə́: «Bwambʉləg nyə kwolós dɨ̂, bwambʉləg nyə kwolós dɨ̂.» Pilât mú cɨ nə bwo nə́: «Ŋwagá nyə, bɨmɛ́fwó bɨ bwámbʉləg nyə kwolós dɨ̂, mɛɛ mə adʉ́gɛ́ ŋkúmba sâ á mə́ sá yí.» ");
INSERT INTO mcp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Oyúdɛn bwə́ mú fɛɛl nə́: «Sə́ bʉ́sə nə dúl cɛ̧ɛ̧, dwó wə́ í ŋgə́ cɨ nə́ á jəlá nə yə, nəcé a ŋgə jaaw nyúúl nə́ a jɨ Mwân mə Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja Pilât nyə a gwág ntɔ́ yí, nyə á bul nyiŋgə gwág íkukwɛndɛ. ");
INSERT INTO mcp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A mú nyiŋgə kə luŋ kə cɨ nə Yésus nə́: «Wo á zhu ŋgow?» Yésus kú bɛ̧sa. ");
INSERT INTO mcp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilât ntâg nə nyə nə́: «Wó yida ban nə́ wo ayálánɛ́ mə? Wo ampúyɛ́ nə́ mə jɨ nə ŋkul mə bɨ́d wo, mə jɨ nə́mə́ nə ŋkul mə sá nə́ bwə́ bwámbʉləg wo kwolós dɨ̂?» ");
INSERT INTO mcp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yésus mú bɛ̧sa nə nyə nə́: «Í mbə̂m bə Zɛmbî kú yə wo ŋkul nyɔɔŋgʉ́, wo kú sá mə sâ. Gwə́ wə́ jɨ́ nə́, muud nyə ámə zə nə mə wódɨ́ yɛ́ mə́ jág bul byaagʉlə.» ");
INSERT INTO mcp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tɛ́ɛ́d fwála nɨ dɨ́, Pilât nyə á ŋgə sɔ̧́ zhɨɨ́ nə́ a bɨ́d Yésus, Oyúdɛn bwə́ mú ŋgə kɨ̂m nə́: «Wó ká bɨ́d nyə, sə́ mpu nə́ wo cugɛ́ shwə́ mə *Káázɛl. Nəcé muud yɛ̂sh mə ŋwá ící nə bʉd yɛ́ mə́ lwágʉlə nə́ a jɨ zhízhíŋ mə́ Káázɛl.» ");
INSERT INTO mcp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Njɨ Pilât nyə gwág ntʉ́nɨ yí, nyə a cúwo nə Yésus tɔ́ɔ́n, a mú kə ji jiya nyə á dʉ cígal mílə́sʉ́ yí, kʉ́l bwə́ á dʉ jɔ̂w nə́ Mbaadə́ á məkwóógʉ́ məkwóógʉ̂ yí, hebʉrə̂ dɨ́ nə́ Gabáta. ");
INSERT INTO mcp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na í á bə í njúl jwɔ́w bwə́ dʉ́ kwəmʉsa *Páska yí, jwɔ́w í mú ŋgɛɛ tɔ́lɔ́g dɨ̂. Pilât mú cɨ nə Oyúdɛn nə́: «Dʉgá Njwú-buud wʉ́n.» ");
INSERT INTO mcp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bwə́ mú ŋgə kɨ̂m nə́: «Njɨ shwɨy, njɨ shwɨy. Bwambʉləg nyə kwolósʉd.» Pilât nə́: «Mə bwámbʉləg Njwú-buud wʉ́n kwolós dɨ̂?» Milúlúú myâ ofada mí mú bɛ̧sa nə́: «Sə́ bʉ́sə nə Njwú-buud njɨ Káázɛl.» ");
INSERT INTO mcp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","A mú ka yə bwo Yésus nə́ bwə́ kə́g bwambʉlə nyə kwolós dɨ̂. Bwə́ mú ka bii Yésus, kyey nə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nyəmɛ́fwó mú ŋgə ŋkɛ̂ny kwolós jé, ŋgə wú ŋgwə́la, ŋgə kə kʉ́l bwə́ jɔ́w nə́ «Kʉ́l á bwundú lúu» yí, hebʉrə̂ dɨ́ nə́ «Golgota.» ");
INSERT INTO mcp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bwə́ mú kə bwambʉlə nyə kwolós dɨ́ wu, bə́nɔ̂ŋ bɔ́ɔ́l búúd obá, nyíga jé kwolós dɨ́ ká, nyíga jé dɨ́ kâ, Yésus jéd tʉ́tám. ");
INSERT INTO mcp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilât nyə á ka cilə bʉ́bɔ́ɔ́mbúd bwə́ kə bwambʉlə Yésus dɨ́ lúú kwolós dɨ̂ nə́: «Yésus á Nazarɛ̂t, Njwû *Oyúdɛn.» ");
INSERT INTO mcp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ncúlyá Oyúdɛn bwə́ á lɔ̧́ bʉ́bɔ́ɔ́mbú jɔɔŋg, nəcé kʉ́l bwə́ á bwambʉlə Yésus kwolós dɨ́ yí í á bə kúnə́-kúnə nə ŋgwə́la, cilyá í á bə ntâg hebʉrə̂ dɨ́, nə latɛ̧́ dɨ́, nə gʉrɛ̂k dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Milúlúú myâ ofada ɔ́ Oyúdɛn mí mú cɨ nə Pilât nə́: «Kú bɛɛg cilə nə́: “Njwû Oyúdɛn”. Yidagʉ́ cilə nə́: “Muud ɛ́ga nyə á cɨ nə́ a jɨ Njwû Oyúdɛn”.» ");
INSERT INTO mcp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilât mú cɨ nə bwo nə́: «Sâ mə́ mə́ cilə yí, gwə́ wə́ mə́ mə́ cilə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ja ózɨmbɨ bwə́ á shîn bwambʉlə Yésus kwolós dɨ́ yí, bwə́ á ka ŋwa mikáándə́ myɛ́ bwə́ kaaw mə́ŋkɔw mənɔ̧̂, muud nyɛ́ ŋkɔw, muud nyɛ́. Í mú ka lʉ́g wáma jé á cwû. Jâŋ í á bə sɨ́yá ncindî, wú gwɔ̂w wɔ́ɔ́s shí kú nə leedyá. ");
INSERT INTO mcp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ozɨmbɨ bwə́ mú ka cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Shé kúgá nyaa, shé yídágá jwɔ̧ bya, dʉ́g múúd nyə é ŋwa yɛ́». Í mú sɨ̂y nda gúl kʉ́kʉ́l mícilyá mí Kálaad Zɛmbî í ŋgə́ cɨ nə́, nə́: «Bwə́ á kawʉla mikáándə́ myâm njɨ, bwə́ á jwɔ̧ bya shú mbwéédí wâm». Ntʉ́nɨ wə́ ózɨmbɨ bwə́ á sá yɛ́. ");
INSERT INTO mcp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Í á bə, nyɔɔŋgʉ́ yé bá mínyɔŋʉ̂ bwə́ tə́l nyə kúnə́-kúnə nə kwolós, nə Maríya mudá mə́ Klópas, nə Maríya á Magʉdála. ");
INSERT INTO mcp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yésus mú dʉ́g nyɔ́ɔ́ŋgʉ́, *mpwíín Yésus nyə á dʉ cɛɛl yɛ́ tə́l nyə kúnə́-kúnə. A mú cɨ nə nyɔɔŋgʉ́ nə́: «Dʉgɨ́ Muda, mwân woó wə́ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A mú nə́mə́ cɨ nə mpwíín nə́: «Dʉgɨ́ nyɔɔŋgʉ́ woó.» Tɛ́ɛ́d wəla nɨɨ́ dɨ, mpwíín wɔɔŋg mú ŋwa nyɔ́ɔ́ŋgʉ́ mə Yésus, kə jil nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ja í mə́ shîn bə ntʉ́nɨ yí, Yésus ŋgə́ mpu nə́ isâ byɛ̂sh í mə́ shîn cɨshʉlɨ, nyə á ka cɨ nə́: «Mə ŋgə gwág shwáásʉ́lə minʉ́»; ciyá jɔɔŋg í mú sá nə́ sâ í á bə cilyá Kálaad Zɛmbî dɨ́ yí í bwə́mag váál í jə́la yí. ");
INSERT INTO mcp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nyúl mpɨ́ɨ́ í á bə í tə́l nə məlwəg mə́ ábibyɛnzhʉ̂; bwə́ mú ŋwa eponzh, juwo cínɔŋg mə́lwəg mə́ ábibyɛnzhʉ̂ dɨ́, ka fɛɛn mbúmbwə́ *ízop dɨ̂. Bwə́ mú ka kənd gwo kə dásʉlə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Njɨ Yésus nyə á ywó məlwəg mə́ ábibyɛnzhʉ̂ mə́nɨ yí, nyə nə́: «Sʉ́sʉ́sá jɛ̂sh í mə́ bə.» A mú jweeg lúu, a mú nyiŋg kənd *jîm jé wə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na nyə á bə, í njúl jwɔ́w bwə́ dʉ́ kwəmʉsa Sábaad yí. *Oyúdɛn bwə́ áshígɛ́ ka cɛɛl nə́ mimbimbə mí jíg íkwolós dɨ́ kə wɔ́ɔ́s jwɔ́w lʉ́ Sábaad. Í á ŋgə ntâg bə nə́ nyâŋ Sábaad nyə é cɔ̧́ bɔ́ɔ́lʉ́gá bɛ̂sh. Nə́ ndɛɛ́, bwə́ á ka kə jî Pilât nə́ a yə́g bwo ŋkul nə́ bwə́ búgə́g buud ɔ́nɨ məkuú, ka yîl bwo íkwolós dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ozɨmbɨ bwə́ mú kə, kə búgə áshúshwóógʉ́ məkuú, búgə nə́mə́ ábɛɛ̂. ");
INSERT INTO mcp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ja bwə́ á kə wɔ́ɔ́s wə́ Yésus yí, bwə́ mú kwey nə́ a mə́ bwey yə, bwə́ nda ntâg búgə nyə məkuú. ");
INSERT INTO mcp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ŋgwɔ́l zɨmbɨ mú yida ŋwa kwɔ̧ɔ̧́, juwo nyə ntʉ́g lʉ́ mwɔ̧́ dɨ̂, məjúwó nə məcií mə́ ɔ́ júg ntâg. ");
INSERT INTO mcp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Muud ŋgə́ bwiiŋg isâ ínɨ yɛ́ nyə a dʉ́g byo nə mísh mɛ́. Bwiiŋgʉ́lə á ŋgə́ bwiiŋg yí wúsə nda óbʉ́bə́lɛ́ bwə́ ŋgə́ magʉlə nə́; a mpú nə́ a ŋgə bwiiŋg sâ jísə́ bʉ́bə́lɛ́ yí. A ŋgə bwiiŋg gwo shú nə́ bɨ búgʉ́lág nə́mə́. ");
INSERT INTO mcp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Í á sɨ̂y ntʉ́nɨ nə́ sâ jɨ́ cilyá Kálaad Zɛmbî dɨ́ yí í bwə́mag, nə́: «Tɔɔ yasə́ jé ŋgwúd nə ŋgwúd í áshígɛ́ bwɛlɛ búg.» ");
INSERT INTO mcp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Í nyiŋgə nə́mə́ bə cilyá Kálaad Zɛmbî dɨ́ nə́: «Bwə́ bá dʉ́g múúd bwə́ á cúwal nyúúl yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ŋgwɔ́l múúd nyə á dʉ bə Arimatê nə́ Yósɛb, nyə á dʉ bə *mpwíín mə Yésus shwoód a dʉ́gə́ fúndə *Oyúdɛn. Ja ózɨmbɨ bwə́ á shîn kə búgə buud ɔ íkwolós məkuú bwə́ juwo Yésus kwɔ̧ɔ̧́ ntʉ́g lʉ́ mwɔ̧́ dɨ́ yí, Yósɛb nyə á ka wə́ Pilât nə́ Pilât yə́g nyə wáda nə́ a kə́g yîl mbimbə mə Yésus kwolós dɨ̂. Pilât mú magʉlə. Yósɛb mú kə ŋwa mbimbə mə Yésus. ");
INSERT INTO mcp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛ̂m muud nyə á fwo kə wə́ Yésus gúl búlú dɨ́ yɛ́ mú nə́mə́ zə, a mbíd bíl íkáá í labínda bwə́ á dʉ jɔ̂w nə́ aloɛ̂s yí fʉlá nə mîr. Fʉlá wɔɔŋg wɛ̂sh í á jee bə okílo məwûm mə́lɔ́ɔl. ");
INSERT INTO mcp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yósɛb bá Nikodɛ̂m bwə́ á ka ŋwa mbimbə mə Yésus, bwə́ fʉ́lə wo nə obándáshi, wá ólabínda, váál Oyúdɛn bwə́ dʉ́ sá ja bwə́ dúl mbimbə yí. ");
INSERT INTO mcp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gúl fambə́ í á dʉ bə nûŋ kʉ́l Yésus nyə á bə kwolós dɨ́ yí, nyúl shwôŋ njúl cínɔŋgʉ́ gúgwáan, bwə́ kú fwo bwɛlɛ dʉl múúd cwû. ");
INSERT INTO mcp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nda jwɔ́w dɔɔŋg í á bə jwɔ́w bwə́ dʉ́ kwəmʉsa Sábaad yí nə́, bwə́ á shwal wá mbimbə mə Yésus shwoŋ nyɔɔŋgʉ́d nəcé í á bə kúnə́-kúnə. ");
INSERT INTO mcp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jwɔ̂w shwɛ́ndɛ mə́ dʉ́ tɛ́ɛ́d yí, ná nə́mə́ yídʉ́gʉ́ yídʉ́gʉ́, Maríya á Magʉdála nyə á kə shwoŋ dɨ̂. A mú kə kwey kwóógʉ́ kú ná nyiŋgə bə kʉ́l í á ŋgə juwal shwoŋ yí. ");
INSERT INTO mcp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A mú kə nə kʉ́lə́ wə́ Shímun Pyɛ̂r bá nyɔɔŋg *mpwíín Yésus nyə á dʉ cɛɛl yɛ́. A mú kə jaaw nə́: «Bwə́ mə́ yîl Cwámba shwóŋʉd, sə́ ámpúyɛ́ kʉ́l bwə́ mə́ kənd nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pyɛ̂r mú cúwo tɔ́ɔ́n, ŋgwɔ́l mpwíín cúwo nə́mə́, bwə́ mú kə kʉ́l bwə́ á dʉl Yésus yí. ");
INSERT INTO mcp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bɛ̂sh obá bwə́ á ŋgə kə nə mikʉ́lə́, njɨ, ŋgwɔ́l nyə á ŋgə bul ju cɔ̧́ Pyɛ̂r, a mú kə tɛ́ɛ́d kumə shwoŋ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A mú bɔ̧ɔ̧lə, a mú dʉ́g njɨ obándáshi bwə́ á dʉl Yésus nə ndɨ́ wá bwə́ mbwúgʉ́. Njɨ nyə a shígɛ́ nyíi shwoŋ dɨ́ cwû. ");
INSERT INTO mcp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Shímun Pyɛ̂r nyə á ŋgə bɛ̧ nyə, a mú zə wɔ́ɔ́s jé ja, a nyíi shwóŋʉd. A mú dʉ dʉ́g óbándáshi bwə́ á bə bwə́ mbwúg cínɔŋg wá. ");
INSERT INTO mcp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","A mú nə́mə́ dʉ dʉ́g kʉ́l káándə́ bwə́ á wɔ́ɔlə mbimbə lúu nə ndɨ́ yí, jâŋ í á shígɛ́ bə kʉ́l óbándáshi bwə́ á bə yí, í á bə yé fʉ́lá, í mbwúg jé kɔ́ɔ́mb. ");
INSERT INTO mcp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na, ŋgwɔ́l mpwíín, nyɔɔŋg nyə́ á tɛ́ɛ́d wɔ́ɔ́s yɛ́, mú ka zə nyíi shwóŋʉd, a mú dʉ́g, a mú *magʉlə. ");
INSERT INTO mcp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Í á bə nəcé bwə́ áshígɛ́ fwo mpu wámbʉlə sâ í á bə mícilyád yí, nə́ Yésus mə́ jəlá nə bá gwûm. ");
INSERT INTO mcp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ja ómpwíín bwə́ á shîn dʉ́g ntʉ́nɨ yí, bwə́ á ka nyiŋgə kə bwə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maríya nyə a lʉ́g tɔ́ɔ́n, shwoŋ dɨ́ kúnə́-kúnə a ŋgə́ jɨɨ. Nyə á ka nə́mə́ kə bɔ̧ɔ̧lə shwoŋ a ŋgə́ jɨɨ. ");
INSERT INTO mcp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","A mú dʉ́g wə́éŋgəles obá nə mikáándə́ mí áfufumə̂ bwə́ njúl kʉ́l mbimbə mə́ Yésus í á bə í mbwúg yí, nyíga ŋgɛɛ kɔ́ɔ́mb lúú, nyíga ŋgɛɛ kɔ́ɔ́mb məkuú. ");
INSERT INTO mcp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wəéŋgəles bwə́ mú jî nyə nə́: «Amuda, jɨ́ wó ŋgə́ jɨɨ yí?» Nyə nə bwo nə́: «Bwə́ mə́ yîl Cwámba waamə́ wa, mə ampúyɛ́ kʉ́l bwə́ mə́ kənd nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A ŋgə́ ná lás ntʉ́nɨ, a mú yid, a dʉ́g ntâg Yésus tə́l, njɨ a kú mpu nə́ jísə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yésus mú cɨ nə nyə nə́: «Amuda, jɨ́ wó ŋgə́ jɨɨ yí? Wo ŋgə sɔ̧́ zə?» Maríya mú tə́dʉga nə́ muud mə́ dʉ sɛ̂y cínɔŋgʉ́ fambə́ wə́ ŋgə́ jî nyə ntʉ́nɨ ɛ́nɛ. A mú cɨ nə nyə nə́: «Cwámba, ŋkí wo wə́ wo ámə yîl nyə, jaawʉg mə kʉ́l wo ámə kə kənd nyə yí, mə kə́ ŋwa nyə.» ");
INSERT INTO mcp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yésus mú jɔ̂w nyə nə jínə́ dɛ́ nə́: «Maríya.» A mú yid wə́ Yésus cɨ nə nyə hebʉrə̂ dɨ́ nə́: «Rabúni», ntɔ́ mə́ kə́ nə́ «Yɨ́ɨ́gʉli.» ");
INSERT INTO mcp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yésus mú cɨ nə nyə nə́: «Kú kúnya nə mə, nəcé mə afwóyɛ́ bád kə wə́ Sɔ́ɔ́ŋgʉ́ waamə̂. Yidagʉ́ kə jaaw ómínyɔŋʉ̂ bâm nə́ mə zə́ bád kə wə́ Sɔ́ɔ́ŋgʉ́ waamə̂ jísə́ nə́mə́ Sɔ́ɔ́ŋgʉ́ wʉ́n yɛ́, wə́ Zɛmbî waamə̂ jísə́ nə́mə́ Zɛmbî wʉ́n yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maríya á Magʉdála músə kə jaaw *ómpwíín nə́: «Mə ámə dʉ́g Cwámba», a mú ntâg jaaw bwo nda Cwámba nyə ámə cɨ nə́. ");
INSERT INTO mcp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nə́mə́ mpwó-kugʉ́ á jwɔ̂w ŋgwúd nə ŋgwúd nɨ, jwɔ́w shwɛ́ndɛ mə́ dʉ tɛ́ɛ́d yí, *ompwíín bwə́ á bə njɔ́w. Bwə́ á ŋgə ji nə mimpumbɛ́ minjuwʉlá, ŋgə́lə fúndə *Oyúdɛn. Seegya nə́, Yésus mə́ cúwo, zə tɔ̂w bwo tʉ́tám, a mú cɨ nə bwo nə́: «Səlʉgá milâm shí.» ");
INSERT INTO mcp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ja á mə́ cɨ ntʉ́nɨ yí, a mú lwágʉlə bwo məbwə́ nə ntʉ́g lʉ́ mwɔ̧́. Ompwíín bwə́ mú bul gwág mə́shusʉg nə dʉ́gʉ́lə Cwámba. ");
INSERT INTO mcp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yésus mú nyiŋgə cɨ nə bwo nə́: «Səlʉgá milâm shí. Nə́mə́ nda Dâ nyə á ntɨ mə nə́, mə́ ka nə́mə́ kənd bɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ja á mə́ shîn cɨ ntʉ́nɨ yí, a mú yámb bwo ŋgúl, nyə nə́: «Lə́gʉ́gá Ŋkɛ̧́ŋkɛ̧̂ Shíshim; ");
INSERT INTO mcp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","buud bɨ́ mə́ bá dʉ juu nə *misə́m wá, bwə́ bá dʉ lə́g íjuugá; bɔɔŋg bɨ́ ábʉ́lɛ dʉ juu wá, bwə́ ábʉ́lɛ dʉ lə́g íjuugá.» ");
INSERT INTO mcp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, Tómas, ŋgwɔ́l múúd á buud wûm nə óbá, nyɔɔŋg bwə́ á dʉ nə́mə́ nyiŋgə jɔ̂w nə́ Wáás yɛ́, nyə a shígɛ́ bə ja Yésus nyə á zə wɔ́ɔ́s *ómpwíín bɛ́ dɨ́ nɨ. ");
INSERT INTO mcp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bɔ́ɔ́l ómpwíín bwə́ á ka jaaw nyə nə́: «Sə́ báá sə́ ámə dʉ́g Cwámba». Nyɛ mú cɨ nə bwo nə́: «Mə́ jɨɨ nə́ mə dʉ́gʉ́g məluun mə́ mə́sʉ́n nyə́dɨ́ mə́bwə́d, mə wá nyinə́ cínɔŋgʉ́, mə juwo mbwə́ kʉ́l bwə́ á juwo nyə kwɔ̧ɔ̧́ ntʉ́g lʉ́ mwɔ̧́ dɨ́ yí. Té mə́ afwóyɛ́ dʉ́g íyuug byɔɔŋg yí, mə cugɛ́ nə ŋkul *magʉlə.» ");
INSERT INTO mcp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Í á ka bə, ja shwɛ́ndɛ ncindí nyə a bwəma yí, ompwíín ɔ́ Yésus bwə́ á nyiŋgə bə sɛɛŋgyá njɔ́w, bə́nɔ̂ŋ Tómas jâŋ ja. Seegya nə́, Yésus mə́ zə, zə tɔ̂w bwo na tʉ́tám, mimpumbɛ́ mí njúl minjuwʉlá, a mú cɨ nə bwo nə́: «Səlʉgá milâm shí.» ");
INSERT INTO mcp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nyə ntâg nə Tómas nə́: «Ntɨɨ́g nyinə́ mbwə́ gwô wa, dʉgɨ́ məbwə́ mâm; ntɨɨ́g mbwə́ zə wá wa mə́dɨ́ ntʉ́g lʉ́ mwɔ̧́ dɨ̂, yɔwʉg ŋgə́lə sá məshwán, magʉlə́g.» ");
INSERT INTO mcp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tómas mú bɛ̧sa nə nyə nə́: «Cwámba waamə́ nə Zɛmbî waam.» ");
INSERT INTO mcp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yésus mú cɨ nə nyə nə́: «Wo mə́ ka magʉlə nəcé wo dʉ́gʉ́lə mə! Buud bwə́ ŋgə́ magʉlə bwə́ kú fwo dʉ́g mə wá, báá bwə́ mə́ jəla.» ");
INSERT INTO mcp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yésus nyə a sá nə́mə́ mɔ́ɔ́l zhwog məshimbá ompwíín bɛ́ bwə́ ŋgə́ dʉ́g; mâŋ mə́ cúgɛ́ cilyá wa kálaad ɛ́gaád. ");
INSERT INTO mcp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mɔɔŋg mə́sə́ cilyá wa má mə́sə shú nə́ bɨ mágʉləg nə́ Yésus jisə *Krîst, *Mwân mə́ Zɛmbî, bɨ́ mə́ ká magʉlə ntɔ́ bɨ́ *bə nə cʉg jínə́ dɛ́d. ");
INSERT INTO mcp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nə́ ndɛɛ́, fwála í á zə cɔ̧̂; Yésus mú nə́mə́ nyiŋgə zə lwóya *ompwíín bɛ́ nyúul ncindye máŋ Tiberyad. Í á bə ntʉ́ga: ");
INSERT INTO mcp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","nə Shímun Pyɛ̂r, nə Tómas bwə́ á dʉ nə́mə́ nyiŋgə jɔ̂w nə́ Wáás yɛ́, nə Natanaɛ̂l muud á Kana faan lʉ́ Galilê, nə bwân ɔ́ Zhébedé, nə bɔ́ɔ́l ómpwíín bɛ́ óbá bwə́ á bə bwə́ njúl. ");
INSERT INTO mcp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Shímun Pyɛ̂r mú zə cɨ nə bɔ́ɔ́l nə́: «Mə zə́ kə shwey óshû». Bwə́ ntâg nə́ nɛ́ nə́: «Shé mə́ zə́ kə.» Bwə́ mú kə, kə kəwa byɔ́ɔ́lʉ́d. Njɨ, bwə́ áshígɛ́ bii tɔɔ shú búlú nɨɨ́d. ");
INSERT INTO mcp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nə́ ndɛɛ́, ja mán í mə́ zə ŋgə lə̂m yí, Yésus mú zə, zə tɔ̂w cíndú, ompwíín nda mpu nə́ jísə nyə. ");
INSERT INTO mcp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A mú cɨ nə bwo nə́: «Náaá, bwân e, bɨ á bəyɛ́ nə bʉ́baalɛ́ óshû na?» Bwə́ nə́: «Mbɔ̂.» ");
INSERT INTO mcp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nyə nə bwo nə́: «Wusəgá wód dʉ́n kɔ́ɔ́mb byɔ́ɔ́l á mbwə́ məncwûm, bɨ é bii óshû.» Bwə́ mú wusə, wód í mú bii óshû bímbí á nə́ bwə́ kú ná nə ŋkul júgə. ");
INSERT INTO mcp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mpwíín Yésus nyə á dʉ cɛɛl yɛ́ mú cɨ nə Pyɛ̂r nə́: «Cwámba wə́ ɛ́nɛ!» Njɨ Shímun Pyɛ̂r nyə a gwág nə́ jísə Cwámba yí, nda nyə á bə shushwáás nə́, a mə́ bwáád míkáándə́, mə́ kʉl nyúúl mə́júwó. ");
INSERT INTO mcp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bɔ́ɔ́l bwə́ mú ŋgə zə nə byɔ́ɔ́l bwə́ ŋgə́ julə oshû lwándʉ́la wódʉ́d nə́ cwɔ́ɔ́. Bwə́ áshígɛ́ bul bə shwóg-shwóg nə bwûŋ, í á jee bə njɨ omáda təd. ");
INSERT INTO mcp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ja bwə́ mə́ wɔ́ɔ́s cíndú yí, bwə́ mú kwey kuda máág, oshú bwə́ mbə́d cínɔŋg, nə ibʉlɛ́d. ");
INSERT INTO mcp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yésus mú cɨ nə bwo nə́: «Zəgá nə bɔ́ɔ́l óshû bɨ́ mə́ bii ɔ́nɨ.» ");
INSERT INTO mcp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Shímun Pyɛ̂r mú nyiŋgə kəwa byɔ́ɔ́lʉ́d, a mú kə julə wód lwándʉ́lá nə məma óshû təd nə məwûm mə́tɔ́ɔn nə ólɔ́ɔl. Oshû bwə́ á tɛɛm bə ntʉ́nɨ, wód í áshígɛ́ nyɛy. ");
INSERT INTO mcp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yésus mú cɨ nə bwo nə́: «Zəgá də.» Tɔɔ muud nyə áshígɛ́ jî nyə nə́: «Wo wə́ zə?» Bɛ̂sh bwə́ á ŋgə bwey mpu nə́ jísə Cwámba. ");
INSERT INTO mcp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nə́ ndɛɛ́, Yésus mú shísh, a ŋwa íbʉlɛ́d yə bwo, a ŋwa nə́mə́ óshû yə bwo. ");
INSERT INTO mcp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na nyə á bə ja alɛ́ɛl Yésus lwóyálə nyúúl ómpwíín bɛ́ dɨ́ ja nyə́ á shîn gwûm yí. ");
INSERT INTO mcp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ja bwə́ mə́ shîn də yí, Yésus mú jî Shímun Pyɛ̂r nə́: «Shímun mwâ mə Yuánɛs, ye wó cɛɛl mə cɔ̧́ bímbí bʉ́ga bwə́ cɛ́ɛ́l mə yí?» Shímun nə́: «Haaw, Cwámba. Wo mpú nə́ mə́ cɛɛl wo.» Yésus ntâg nə nyə nə́: «Wɨ́ɨ́lʉ́g mə bwán ɔ́ ncwəmbɛ bâm.» ");
INSERT INTO mcp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yésus mú nyiŋgə jî nyə ja ábɛɛ́ nə́: «Shímun mwâ mə Yuánɛs, ye wó cɛɛl mə?» Nyə nə́: «Haaw, Cwámba. Wo mpú nə́ mə́ cɛɛl wo.» Yésus nə nɛ́ nə́: «Bə́g mə mbaagʉlə incwəmbɛ.» ");
INSERT INTO mcp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yésus mú nyiŋgə jî nyə ja alɛ́ɛl nə́: «Shímun mwâ mə Yuánɛs, ye wó cɛɛl mə?» Pyɛ̂r mú bə nə məcɛy mə lâm nə Yésus jílə nyə ja alɛ́ɛl nə́: «Ye wó cɛɛl mə?» A mú ntâg bɛ̧sa nə́: «Cwámba, wo mpú ísâ byɛ̂sh, wo mpú ntâg nə́ mə́ cɛɛl wo.» Yésus mú cɨ nə nyə nə́: «Wɨ́ɨ́lʉ́g mə incwəmbɛ byâm. ");
INSERT INTO mcp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Bʉ́bə́lɛ́, mə́ jaaw wo nə́, ja wó á dʉ bə ncwə́má yí, womɛ́fwó wo á dʉ cɛ̧ɛ̧lə kandá, wo kə kʉ́l wó cɛ́ɛl kə yí. Ja wó bá bə cwúcwúúl yí, wo bá dʉ tɛ́ɛ́g mə́bwə́, buud oshús dʉ cɛ̧ɛ̧lə wo kandá, kə nə wo kʉ́l wó shígɛ́ cɛɛl kə yí.» ");
INSERT INTO mcp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na nyə á bə nə́, Yésus nyə á ŋgə lwágʉlə mbií shwɨy Pyɛ̂r mə bá yə yí, shwɨy í bá yə Zɛmbî gúmə́ yí. Ja nyə á shîn ka jaaw nyə ntɔ́ yí, nyə á ka cɨ nə nyə nə́: «Bɛ̧g mə.» ");
INSERT INTO mcp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pyɛ̂r nyə á ka yid, a mú dʉ́g *mpwíín Yésus nyə á dʉ cɛɛl yɛ́ ŋgə́ zə nyə́dɨ́ mpʉ́s, mpwíín nyə á jágʉwo Yésus bʉd dɨ́ ja bwə́ á ŋgə də yí, jî nyə nə́: «Cwámba, zə́ nyə é kusha nə wo?» ");
INSERT INTO mcp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ja Pyɛ̂r mə́ dʉ́g mpwíín ɛ́nɛ yí, a mə́ jî Yésus nə́: «Nyíga nyɛ mə bá shúgʉla ntʉdɛl?» ");
INSERT INTO mcp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yésus mú bɛ̧sa nə nyə nə́: «Mə ká cɨ nə́ a bág cʉgə kə wɔ́ɔ́s ja mə bá nyiŋgə zə yí, jɨ́ í dʉ́g wo cínɔŋg yí? Wɛɛ bɛ̧g mə.» ");
INSERT INTO mcp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tɛ́ɛ́d fwála nɨ dɨ́, lâŋ mú kyey óbúgʉla bɛ̂sh dɨ́ nə́ mpwíín wɔɔŋgʉ́ nyə abʉ́lɛ yə. Í njúl nə́ Yésus nyə a shígɛ́ cɨ nə Pyɛ̂r nə́ mpwíín wɔɔŋgʉ́ nyə abʉ́lɛ yə, nyə yida cɨ nə́: «Mə ká cɨ nə́ a bág cʉgə kə wɔ́ɔ́s ja mə bá nyiŋgə zə yí, jɨ́ í dʉ́g wo cínɔŋg yí?» ");
INSERT INTO mcp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mpwíín wɔɔŋg wə́ ŋgə́ bwiiŋg isâ íga, nyə wə́ nyə á cilə byo; sə́ mə́ mpú ntâg nə́ bwiiŋgʉ́lə yé wúsə nda óbʉ́bə́lɛ́ bwə́ ŋgə́ magʉlə nə́. ");
INSERT INTO mcp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bíl ncúlyá isâ Yésus nyə a sá yí bísə. Byɛ̂sh í á mbə̂m ŋgə kə mícilyá dɨ, shí ga bə bíbíyá shú ókálaad ɔ mícilyá myɔɔŋg.");
INSERT INTO mcp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tyofîl, mə a tɛ́ɛ́d cilə kálaad ashúshwóógʉ́ nə́ mə bwiiŋg sâ jɛ̂sh Yésus nyə a sá yí, nə jɔɔŋg jɛ̂sh nyə á jɨ́ɨ́gʉli yí tɛ́ɛ́d mə́tɛ́ɛ́dʉ́lé ");
INSERT INTO mcp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kə wɔ́ɔ́s jwɔ̂w nyə á bʉ̂n kə gwɔ́w yí. Jwɔ̂w dɔɔŋgʉ́, nə ŋkul á Ŋkɛ̧́ŋkɛ̧̂ Shíshim, nyə á fwo shîn lwágʉlə *buud ɔ lwámá bɛ́ nyə á fɛ́ɛ́sh wá sá bwə́ jə́lá nə bá sá yí. ");
INSERT INTO mcp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Búúd ɔ lwámá bɛ́ bɔɔŋg dɨ́ wə́ nyə á lwóya nyúul mpʉ́sə micúŋ nə shwɨy dɛ́ yí. Nyə a lwágʉlə bwo iyuug mimbií mimbií nə́ a jisə kuwó, bwə́ ŋgə́ dʉ́g nyə tâŋ mwɔ̂w məwûm mə́nɔ̧̂, a ŋgə́ bwiiŋg bwo isâ í dʉ́gyá nə Faan mə́ Zɛmbî yí. ");
INSERT INTO mcp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Í á ka zə bə, dʉ́nɨ jwɔ́wʉ́d ɨɨ́, bə́nɔ́ŋ bwə́ ŋgə́ də, a mú báásʉlə bwo nə́: «Bɨ́ kú bá tɨ́ mə́kuú Yurʉ́səlɛm, bɨ́ ɔ bá fwo bwánd sâ Dâ nyə á kaag yí, sâ bɨ́ á gwág nə mə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nyə nə bwo nə́: «Yuánɛs nyɛ nyə á duu buud nə məjúwó, bɨ́ bâŋ bɨ mə zə́ bá duwan nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́mə́ mwɔ̂w mə́gaád.» ");
INSERT INTO mcp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bɛ̂sh bwə́ mú ka jî nyə cʉ́ŋ ŋgwúd nə́: «Cwámba e, ye ja gaád wə́ wó zə́ kwo tə́l íjwûga yâ *Izʉrəyɛ̂l yí?» ");
INSERT INTO mcp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A mú cɨ nə bwo nə́: «Bɨ dɨ́ bɨ́ nə́ bɨ mpúg mə́fwála nə ija Dâ nyəmɛ́fwó nyə á tə̂l yí. ");
INSERT INTO mcp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Njɨ, bɨ mə bá lə́g ŋkûl í bá zhu wə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim, zə bɨ́dɨ́, bɨ músə bá bwiiŋg láŋ wâm, tɛ́ɛ́d Yurʉ́səlɛm, kala Yudéa, kə kumə Samaríya, kə wɔ́ɔ́s íjumə í shí byɛ̂sh dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ja nyə á shîn lás nə bwo ntʉ́nɨ yí, bwə́ ŋgə́ dʉ́g nyə, a mú ŋkâŋ kə gwɔ̂w, ŋkúdú mú shweel nyə, mísh máŋ mə́ kú ná dʉ́g nyə. ");
INSERT INTO mcp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bwə́ ŋgə́ ná dʉ́g ŋgɛɛ joŋ dɨ́ wú nyə á kə wá, seegya nə́ buud obá bwə́ mə́ wɔ́ɔ́s bwo na koogʉ́, bwə́ njúl nə mimbwéédí mí áfufumə́. ");
INSERT INTO mcp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Buud ɔ́nɨ bwə́ mú cɨ nə bwo nə́: «Yé búúd ɔ́ Galilê, jɨ́ bɨ́ mə́ ká bwên na dʉ dʉ́g joŋ dɨ́ yí? Yésus mə́ bʉ́n kə joŋ dɨ́ béégya nə bɨ ɛ́nɛ, nyə é bá nə́mə́ kwo zə mbií ŋgwúd bɨ ámə dʉ́g a ŋgə kə joŋ dɨ́ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ntɔ́, bwə́ mú tɨ́ njɔɔnd wúlə mbʉ́mbʉ́ŋ á wəolivyê, kə́lə Yurʉ́səlɛm, cínɔŋgʉ́ jisə cé zhɨ́ɨ́ múúd mə kyéy jwɔ̂w lʉ́ sábaad yí. ");
INSERT INTO mcp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ja bwə́ mə́ wɔ́ɔ́s Yurʉ́səlɛm yí, bwə́ mú bád fúm á njɔ́w dɨ́ gwɔ̂w, kʉ́l bwə́ á dʉ sɛɛŋgya yí, nə Pyɛ̂r, nə Yuánɛs, nə Zhâk bá Andrê, nə Fílíp bá Tómas, nə Batəlʉmî bá Matiyô, nə Zhâk á mwân mə Alfê, nə Shímun nyə á bə gwooŋg á məcɛy mə́ lɔɔm dɨ́ yɛ́, nə Yúda mwân mə Zhâk. ");
INSERT INTO mcp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɛ̂sh bwə́ á dʉ sá zɛ́ny mə́jəgʉla lâm ŋgwúd, bə́nɔ̂ŋ bɔ́ɔ́l búdá, nə Maríya nyɔɔŋgʉ́ mə Yésus, nə omínyɔŋʉ̂ ɔ́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dúl jwɔ́wʉ́d ntʉ́nɨ, obúgʉla bwə́ mə́ sɛɛŋgya je bə tâŋ buud təd nə məwûm mə́bá, Pyɛ̂r nyə á tɔ̂w shí, a mú cɨ nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Bwááŋg ɔ́, Ŋkɛ̧́ŋkɛ̧̂ Shíshim nyə a lás mpu mə́ *Dávid dɨ́, sâ jɔɔŋg jísə cilyá shú mə́ Yúdas. Nyə wə́ nyə á ŋgə kə nə buud bwə́ á kə bii Yésus wá. Í á jɨɨ nə́ sâ jísə́ mícilyá mí Kálaad Zɛmbî dɨ̂ yí í bwə́mag. ");
INSERT INTO mcp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yúdas nyə á bə nə́mə́ gwooŋg jísʉ́d, Zɛmbî nyə a yə nə́mə́ nyə ŋkɔw sáal gaád. ");
INSERT INTO mcp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Njɨ, *mwaanɛ̂ bwə́ á jə́na nə nyə nə́ a sáág olɨ́lɨŋgɨ̂ nyə á sâ wá, nyə á kusə shí nə mwaanɛ̂ wɔɔŋg. Nyə á ka kə kadʉwa shí cínɔŋg mbúmbudɨ̂, a mú kɔɔd tâm kug, isə́g nə incuwa cɨɨm shí nə shí. ");
INSERT INTO mcp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Buud ɔ Yurʉ́səlɛm bɛ̂sh bwə́ á shí mpu sâ jɔɔŋg, nə́ ndɛɛ́ bwə́ á gwiid shí nyɔɔŋg nə́ Akɛ́lʉdama, ntɔ́ mə́ kə́ nə́ “Shí məcií”. ");
INSERT INTO mcp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mpugá nə́ jísə cilyá kálaad osôm dɨ̂ nə́: “Də́nd dɛ́ í lʉ́gʉ́g wuul, muud kú ná bá ji cínɔŋg”. Í njúl nə́mə́ kwo bə cilyá nə́: “Ŋgwɔ́l múúd ŋwág jiya jé”. ");
INSERT INTO mcp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Ntɔ́, sə́ bʉ́sə nə bɔ́ɔ́l búúd wa, buud sə́nɔ̂ŋ bwo sə́ á dʉ ŋgə jaand ja sə́nɔ̂ŋ Cwámba Yésus sə́ á bə gwooŋg yí, ");
INSERT INTO mcp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tɛ́ɛ́d nduwán mə́ Yuánɛs Nduu-buud kə kumə ja nyə á bʉ̂n kə joŋ dɨ́ yí. Í jɨɨ nə́ ŋgwɔ́l múúd á cínɔŋg zə́g sɛɛŋgya nə sə́, sə́nɔ́ŋ zə ŋgə bwiiŋg gwûmʉ́lə Cwámba nyə a gwûm yí.» ");
INSERT INTO mcp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bwə́ mú lwágʉlə búúd obá, nə Yósɛb nyə á bə nə dúl jínə́ nə́ Barsábas, bwə́ dʉ́gə́ nə́mə́ nyiŋgə jɔ̂w nə́ Yustos yɛ́, nə Matíyas. ");
INSERT INTO mcp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nə ndɛɛ́, buud bwə́ mú jəgʉla nə Zɛmbî nə́: «Cwámba e, wo muud mə mpú mílâm mí búúd bɛ̂sh yɛ́, lwóg sə́ nyɔɔŋg wó mə́ fɛ́ɛ́sh wa búúd obá ɔ́ga dɨ́ yɛ́, ");
INSERT INTO mcp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a zə́g ŋwa jiya wa sáal *búúd ɔ lwámád, nəcé Yúdas nywáá nyə á myaas jiya jɔɔŋgʉ̂, a kə ŋwa jɔɔŋg í á jəla nə nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bwə́ mú jwɔ̧ bya shú búúd obá bɔɔŋg, mpaambə́ í mú fɛ́ɛ́sh Matíyas, bwə́ músə sɛɛŋg nyə nə buud ɔ lwámá wûm nə ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ja jwɔ̂w lʉ́ Pantekôt í á wɔ́ɔ́s yí, bɛ̂sh bwə́ á bə bwə́ njúl kʉkʉ̂l ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Seegya nə́ nyúl ncíndə́ mú zhu gwɔ̂w nə́mə́ nda ja məma ŋkwɔ̧̂ mə dʉ kuŋg yí. Ncíndə́ nyɔɔŋg í mú lwánd njɔ́w bwə́ á bə yí wɛ̂sh nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nə ndɛɛ́ bwə́ mú dʉ́g bíl ísâ í ŋgə́ wɔ́ɔ́s nda məjûm mə́ kuda. Isâ byɔɔŋg í mú ŋgə bɔ́ɔ́g ŋgə kə badʉwo muud yɛ̂sh nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bɛ̂sh bwə́ mú lwánd nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́, bwə́ mú tɛ́ɛ́d ŋgə́lə lás mɔ́ɔ́l mə́kə̂l nda Shíshim í á ŋgə sá nə́ bwə́ lásʉ́g nə́. ");
INSERT INTO mcp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Í á bə *Oyúdɛn bwə́ njúl Yurʉ́səlɛm, Oyúdɛn bwə́ mə́ wá lâm wə́ Zɛmbî wá, bwə́ á zhu ílwoŋ i búúd byɛ̂sh bísə́ joŋ dɨ́ shí yí. ");
INSERT INTO mcp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ja sâ nɨ mə́ gwɨ́ɨ́g lɔɔm nə lɔɔm yí, búúd bwə́ mú zə sɛɛŋgya bwə́ kú mpu sâ bwə́ cɨ́g yí nəcé muud yɛ̂sh ŋgə́lə gwág obúgʉla bwə́ ŋgə́ lás kə́l lʉ́ byélé dɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Fʉg í á jímb bwo mílúúd, bwə́ ŋgə́ jág bul káam, bwə́ mú ŋgə cɨ nə́: «Ŋgaá nə́ búúd bwə́ ŋgə́ lás ɔ́ga bɛ̂sh bʉ́sə buud wâ Galilê? ");
INSERT INTO mcp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ká ntʉdɛlɛ́ í mpú zə bə nə́ sə́ ŋgə́g nə gwág bwə́ ŋgə́ lás məkə́l mə́sʉ́, muud yɛ̂sh yag kə́l lʉ́ byélé dɛ́ yɛ́? ");
INSERT INTO mcp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nə Oparʉt, nə buud ɔ́ Mɛdî nə bɔɔŋg wâ Elam, nə bɔɔŋg bwə́ dʉ ji Məzhuputamî nə Yudéa, nə bɔɔŋg wâ Kapados nə́mə́, nə Pɔ̂ŋ nə Azî, ");
INSERT INTO mcp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nə Frizhî, nə Pamʉfilî nə́mə́, nə Igîpten, nə məfaan mə́ Libî mâ ŋgɛɛ́ ŋgwə́la Sirɛ̂n, nə buud bwə́ ámə zhu Róma wá, ");
INSERT INTO mcp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","fwámɛ́ Oyúdɛn, nə ojóŋ bwə́ á zə nyíi mísɔɔn Oyúdɛn dɨ́ wá, nə buud ɔ́ Kʉrɛ̂t nə Arabî. Ntʉdɛlɛ́ sə́ ŋgə́ gwág buud ɔ́ga bwə́ ŋgə́ bwiiŋg məma mísɔ́ɔ́lʉ́gʉ́ mí Zɛmbî sə́dɨ́ mə́kə́l mə́ byélé dɨ́ yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bɛ̂sh fʉg í á jímb mílúúd, bwə́ kú ná mpu sâ bwə́ cɨ́g yí. Bwə́ mú ka ŋgə cɨ bwə́mɛ́ nə bwə́mɛ́ nə́: «Jáyɛ́ í mə́ bə ga?» ");
INSERT INTO mcp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bɔ́ɔ́lʉ́gá bâŋ bwə́ mú ŋgə cágʉlə obúgʉla, bwə́ nə́: «Bwə́ mə́ lwánd nə məlwəg.» ");
INSERT INTO mcp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pyɛ̂r bə́nɔ̂ŋ *buud ɔ lwámá wûm nə ŋgwúd bwə́ mú ka zə tɔ̂w tâm buud. Pyɛ̂r mú bʉ̂n kə́l gwɔ́w-gwɔ̂w, lás nə bwo nə́: «Yé *Oyúdɛn nə bɨ bɛ̂sh buud bɨ́ ŋgə́ ji Yurʉ́səlɛm wá, bɨ ɔ mpú ntɨ mə́lwə̂ kə́ga mə́dɨ́, bɨ mə́ jəlá nə mpu sâ ga. ");
INSERT INTO mcp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Buud ɔ́ga bwə́ aŋgɛ̂ nə fudə nə məlwəg nda bɨ́ ŋgə́ cɨ nə́. Ŋgaá nə́ jwɔ̂w dʉ́sə ná njɨ məwəla ibuu mâ mpʉ́mán mpʉ́mán. ");
INSERT INTO mcp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Í yidá bə nə́ sâ Zhuwɛ̂l *muud micúndə́ nyə á jaaw yí, gwə́ wə́ í mə́ bwəmá ga, nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Í bá bə nə́, mwɔ̂w mâ məzhúgʉ́lâ, mə bá shwu múúd yɛ̂sh Shíshim wâm. Zɛmbî mə́ cɨ ntɔ́. Bwân bʉ́n wâ budûm nə wâ budá bwə́ bá cúndə mícúndə́ myâm, məncwə́má mʉ́n mə́ dʉ́g *məntamə́ mə́ á mísh nə́ bagə́, icwúcwúúl bín dʉ́g mə́ntamə́. ");
INSERT INTO mcp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jɨ́ ntɔ́. Mə bá shwu ósɔ́ɔl ɔ mə́sáal bâm Shíshim wâm mwɔ̂w mɔɔŋgʉ́d, tɔɔ osɔ́ɔl ɔ mə́sáal wá budûm, tɔɔ wâ budá, bɛ̂sh bwə́ mú bə búúd ɔ mícúndə́. ");
INSERT INTO mcp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mə bá wééshʉli *ísâ í mímbʉ́gú gwɔ́w joŋʉd, mə sá *ísâ í ntɔ̧́ búúd ŋkwóŋ yí shí mishwun. Í bá bə, nə məcií nə kuda, nə ŋgúdə́ yílɛ, ");
INSERT INTO mcp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","shúshwóógʉ́ nə mwásə́ mə́ Cwámba í zə́g wɔ́ɔ́s, məma mwásə́ áŋkʉŋkənʉwâ wɔɔŋg, jwɔ̂w í bá shwɔ̧́ɔ̧la bə yídʉ́gʉ́, mbyôl bə məcií. ");
INSERT INTO mcp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nə́ ndɛɛ́, múúd yɛ̂sh mə bá kɨ̂m jɔ̂w jínə́ mə́ Cwámba yɛ́, a bá cʉgə. ");
INSERT INTO mcp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Bag ɔ́ *Izʉrəyɛ̂l, gwágʉ́lə́gá sâ mə́ ŋgə́ cɨ yí. Zɛmbî nyə a wééshʉli bɨ́ *məshimbá nə isâ í mímbʉ́gú nə isâ í ntɔ̧́ búud ŋkwóŋ yí. Nyə a wééshʉli byo məbwə̂ mə́ Yésus á Nazarɛ̂t dɨ́ nda bɨ́ mə́ bwéy mpu nə́. Ntɔ́ jɨ nə́ Zɛmbî nyə á mpu lwóya nə́ nyə wə́ nyə á ntɨ bɨ́ Yésus á Nazarɛ̂t wɔɔŋgʉ̂, ");
INSERT INTO mcp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Zɛmbî mú sá nə́ bɨ bííg muud wɔɔŋgʉ̂ nə́mə́ nda nyə́mɛ́fwó Zɛmbî nyə á ŋwa cígʉ́lá nə́, nda nyə á bwey mpu nə́. Bɨ á kusha nyə nə buud bʉ́sə́ kú bísh mə́cɛ̧ɛ̧ wá, bɨ́ sá nə́ bwə́ gwúg nyə, bwə́ músə bwambʉlə nyə kwolós dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Njɨ, Zɛmbî nyə a gwûmʉshi nyə, a fɛɛmʉshi nyə nə shwɨy nəcé shwɨy í á shígɛ́ nywá bə nə ŋkul máánd nyə kandʉgə. ");
INSERT INTO mcp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dávid nyə á wámbʉlə cɨ shú dɛ́d nə́: Mə á dʉ dʉ́g Cwámba mə́dɨ́ shwóg ja jɛ̂sh, nəcé a jisə mə́dɨ́ mbwə̂ məncwûm shú nə́ sâ kú bwɛlɛ fwágʉsə mə. ");
INSERT INTO mcp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ntɔ́, lâm wâm wúsə nə məshusʉg, jûm dâm í ŋgə kɔɔs nə jámbə́. Ka nyiŋgə bul bə nə́ ifúndə́ byâm í bá ŋgə woga nə búgə́, ");
INSERT INTO mcp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nəcé wo abʉ́lɛ́ sá nə́ mə kə́g myeesh baŋ mínjîm, wo abʉ́lɛ́ bɨ́d nə́ jɔ̧jɔ̧ sɔ́ɔl məsáal wô kə́g bwo shwóŋʉd. ");
INSERT INTO mcp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wo a sá nə́ mə mpúg məzhɨɨ́ mə́ cʉg, wo bá lwándʉlə mə nə məshusʉg ja mə́ bá dʉ́g wó yí. ");
INSERT INTO mcp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Bwááŋg, magʉləgá nə́ mə jááwʉg bɨ́ nə́ kpwɔɔ́ nə́, mpáámbə́ íshé *Dávid nyə a shí yə, nyə á dɔw, shwoŋ nyɛ́ nyísə ná wa sə́dɨ́ zə wɔ́ɔ́s múús. ");
INSERT INTO mcp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Njɨ, nda nyə á bə muud micúndə́ nə́, nyə á bwey mpu nə́ Zɛmbî nyə á kaag nyə, a kɛɛn bʉ́bə́lɛ́ nə́ a bá jil ŋgwɔ́l mwân yé, məbyá mɛ́ mâ nyəmɛ́fwó, a bá jil nyə nyə́dɨ́ jiya ící dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nyə á bwey dʉ́g nə́ Yésus mə bá gwûm, gwûmʉ́lə wɔɔŋg wə́ nyə á ŋgə cɨ ja nyə á lás nə́: “Bwə́ á shígɛ́ myaas nyə baŋ mínjîm, nyúúl nyɛ́ í á shígɛ́ bwo shwóŋʉd”. ");
INSERT INTO mcp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Yésus wɔɔŋgʉ̂, Zɛmbî nyə á gwûmʉshi nyə, sə́ bɛ̂sh sə́ bʉ́sə owúshinɛd wâ lâŋ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mbwə̂ məncwûm mə́ Zɛmbî í á bʉ̂n nyə gwɔ̂w. Ŋkɛ̧́ŋkɛ̧̂ Shíshim Zɛmbî nyə á kaag yɛ́, a mə́ lə́g nyə wə́ Dâ, a mə́ shwu sə́ nyə, gwə́ wə́ bɨ́ ŋgə́ gwág bɨ́ ŋgə́ dʉ́g nə sə́ ga. ");
INSERT INTO mcp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Dávid nyəmɛ́fwó nyə a shígɛ́ kə gwɔ̂w, njɨ nyə á cɨ nə́: Yawé nyə á cɨ nə Cwámba wâm nə́: “Jig shí wa mə́dɨ́ mbwə̂ məncwûm kə wɔ́ɔ́s ja mə é culʉshi mízhízhíŋ myô, wo nyaál myo nə məkuú yí!” ");
INSERT INTO mcp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yé bag ɔ Izʉrəyɛ̂l bɛ̂sh, bɨ́ mə́ jəlá nə ka mpu kú nə məshwán nə́ Yésus bɨ́ á bwambʉlə kwolós dɨ́ yɛ́, Zɛmbî mə́ sá nə́ a bə́g Cwámba, a bə *Krîst.» ");
INSERT INTO mcp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kaand nɨ nyə á kwiy buud milâm, bwə́ mú jî Pyɛ̂r bə́nɔ̂ŋ *buud ɔ lwámá nə́: «Bwááŋg e, sə́ sáág ntʉdɛlɛ̂?» ");
INSERT INTO mcp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pyɛ̂r mú bɛ̧sa nə bwo nə́: «Cɛ́ndʉ́gá mitə́dʉ́gá, muud yɛ̂sh dúwanʉgɨ́ jínə́ mə́ Yésus-Krîst dɨ́, Zɛmbî jwúg bɨ́ nə *misə́m mín. Ntɔ́, bɨ mú lə́g yána mə́ Zɛmbî, yána dɔɔŋg wə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nəcé ŋkaagə́ mə́ Zɛmbî í dʉ́gyá nə bɨ̂, nə bwân bʉ́n, nə bɔ́ɔ́l búúd bɛ̂sh bʉ́sə́ óshwóg-óshwóg wá, bímbí dɛ̂sh Zɛmbî mə bá jɔ̂w yí.» ");
INSERT INTO mcp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pyɛ̂r mú nə́mə́ kwo ŋgə lás nə bwo bíl zhwog iciyá na, ŋgə cwîny bwo, nyə nə bwo nə́: «Túbʉ́gá wú na kala búúd á lɨ́lɨŋgɨ̂ nɨɨ́d.» ");
INSERT INTO mcp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Buud bwə́ á magʉlə kaand yé wá, bwə́ á duwan. Jwɔ̂w dɔɔŋgʉ́, buud bwə́ á kwɨ́dʉli *Dɔ̧ lʉ́ óbúgʉla dɨ́ kúnə́-kúnə buud otɔ́ɔ́shin olɔ́ɔl. ");
INSERT INTO mcp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Obúgʉla bɛ̂sh bwə́ á dʉ sá zɛ́ny bɛ̧ɛ̧́lə mínjɨ́ɨ́gʉ́lá mí búúd ɔ lwámá, zɛ́ny cʉg sɛɛŋgí á omínyɔŋʉ̂, zɛ́ny dʉ́lə féya bʉlɛ́d, nə zɛ́ny dʉ́lə ji ísɛɛŋgyá í mə́jəgʉlad. ");
INSERT INTO mcp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Buud bɛ̂sh bwə́ á bə nə gwɔ̧́ɔ̧́gə́, buud ɔ lwámá bwə́ ŋgə́ bul sá *ísâ í mímbʉ́gú nə *isâ í ntɔ̧́ búúd ŋkwóŋ yí. ");
INSERT INTO mcp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Buud bɛ̂sh bwə́ á *búgʉla wá bwə́ á dʉ bə kʉ́l ŋgwúd, bwə́ sɛɛŋg isâ byáŋ dʉ bií byo sɛɛŋgí. ");
INSERT INTO mcp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bwə́ á ŋgə kusha məbii máŋ nə isâ byáŋ, bwə́ ka dʉ kawʉla *mwaanɛ̂ wɔɔŋgʉ̂ nə́mə́ nda múúd yɛ̂sh nyə á bə nə məyáŋgan nə́. ");
INSERT INTO mcp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bɛ̂sh bwə́ á dʉ sá zɛ́ny kə̌lə *Luŋ mə́ Zɛmbî jwɔ̂w dɛ̂sh mbií ŋgwúd; bwə́ dʉ féya bʉlɛ́d mínjɔ́w minjɔ́w, bwə́ dʉ də ídʉ̂w byáŋ nə məshusʉg, kú nə muud mə ŋkɛ̂ny nyúul. ");
INSERT INTO mcp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bwə́ dʉ ságʉsə Zɛmbî, bɔ́ɔ́l búúd bɛ̂sh dʉ ŋwa bwo nə məjilə. Cwámba nyə á dʉ cʉg buud jwɔ̂w dɛ̂sh, a dʉ kwádʉlə bwo *Dɔ̧ dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pyɛ̂r bá Yuánɛs bwə́ á ka zə kə *Luŋ mə́ Zɛmbî wəla lʉ́ mə́jəgʉla dɨ̂, mə́wəla məlɔ́ɔl mâ mpwó-kugʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ŋgwɔ́l múúd nyə á byɛ̂l mbúmbwúgʉ́. Buud bwə́ á ka dʉ ŋkɛ̂ny nyə jwɔ̂w dɛ̂sh dʉ kə jil nyə mpumbɛ́ Luŋ bwə́ dʉ jɔ̂w nə́: «Jɔ̧ Mbɛ̂» yí, a ka dʉ gwáámb búúd bwə́ kə́ Luŋ wá kwííndyá. ");
INSERT INTO mcp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Múúd ɛ́nɛ nyə á ka dʉ́g Pyɛ̂r bá Yuánɛs bwə́ ŋgə́ bə nə́ bwə́ zə́ nyíi Luŋ, a mú gwáámb bwo kwííndyá. ");
INSERT INTO mcp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pyɛ̂r bá Yuánɛs bwə́ mú dʉ́g nyə nə́ figə́-figə́, bwə́ nə nɛ́ nə́: «Ntɨɨg mísh kə́ga.» ");
INSERT INTO mcp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Muud ɛ́nɛ mú kənd mísh bwə́dɨ́ a ŋgə́ tə́dʉga nə́ a zə́ lə́g gúl sâ. ");
INSERT INTO mcp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pyɛ̂r músə cɨ nə nyə nə́: «Mə cugɛ́ nə *mwaanɛ̂, mə kú nə or. Sá mə́ jɨ́ nə ndɨ̂ yí, gwə́ wə́ mə́ yə́ wo yí. Jínə́ mə́ Yésus-Krîst á Nazarɛ̂t dɨ́, tɔ́wʉ́g tʉ́təlí wo kyéyʉg!» ");
INSERT INTO mcp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nə́ ndɛɛ́ a mú bií nyə mbwə̂ məncwúmʉ́d, bʉ̂n. Nə́mə́ cé nə cé, məkuú nə məcʉgʉlu mə́ músə lal múúd ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A mú sáánz tɔ̂w tʉ́təlí nə́ cɛdɛk. A mú tɛ́ɛ́d ŋgə́lə kyey. A mú kə, bə́nɔ̂ŋ bwo bwə́ mú kə nyíi Luŋ mə́ Zɛmbî, a ŋgə́ kyey, a ŋgə́ kɔ̂w, a ŋgə́ ságʉsə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Buud bɛ̂sh bwə́ mú dʉ́g nyə a ŋgə́ kyey, a ŋgə́ kɔ̂w, a ŋgə́ ságʉsə Zɛmbî, ");
INSERT INTO mcp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bwə́ ŋgə́ mpu yag nyə nə́ muud nyə á dʉ jɨ mpumbɛ́ Luŋ bwə́ dʉ jɔ̂w nə́ Jɔ̧ Mbɛ̂, a dʉ́gə́ gwáámb búúd mikwííndyá yɛ́, nyə wə́ ɛ́nɛ. Bwə́ mú ŋgə jág bul káam sâ í mə́ sɨ̂y yí, ikukwɛndɛ bií bwo. ");
INSERT INTO mcp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Muud ɛ́nɛ nyə á shígɛ́ ná kwo béégya nə Pyɛ̂r bá Yuánɛs. Buud bɛ̂sh bwo mú zə nə mikʉ́lə́ kú ná mpu sâ bwə́ cɨ́g yí, zə lyɛ̧ bwo na wú bwə́ á bə kʉ́l bwə́ á gwiid nə́ Nyíŋgʉ́lé mə́ Sə́lʉmun yí. ");
INSERT INTO mcp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nda Pyɛ̂r nyə á dʉ́g ntʉ́nɨ nə́, nyə á ka lás nə buud, nyə nə́: «Yé bag ɔ *Izʉrəyɛ̂l, nəcé jɨ́ bɨ́ ŋgə́ bul káam sâ í mə́ sɨ̂y nɨ yí? Jɨ́ bɨ́ ŋgə́ dʉ́g sə́ nə́ ŋkaamə́ nə́mə́ nda ŋkul nyísʉ́ wə́ í mə́ sá nə́ muud ɛ́ga kyéyʉg tʉ́təlí yí, ŋkí ntâg nə́ sə́ bulʉ́lə wá milâm wə́ Zɛmbî wə́ í mə́ sá yí? ");
INSERT INTO mcp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Zɛmbî mə́ *Abʉraham, Zɛmbî mə́ *Izaag, Zɛmbî mə́ *Yákwab, Zɛmbî odâ mə́ sá nə́ sɔ́ɔl məsáal yé Yésus bə́g nə gúmə́. Yésus bɨ́ bâŋ bɨ́ á kɛɛnzh yɛ́, bɨ́ á ban mísh mə́ Pilât dɨ́ yɛ́, í njúl nə́ Pilât nywáá nyə á ŋgə cɛɛl bɨ́d nyə. ");
INSERT INTO mcp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bɨ á ban muud Zɛmbî nyə a fɛ́ɛ́sh yɛ́, tʉ́təlí muud, bɨ́ yidá jî nə́ Pilât gwágʉ́g ŋgwûl buud ŋkúŋkwóŋʉ́lə, a bɨ́d nyə. ");
INSERT INTO mcp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Muud nyə a tɛ́ cʉg yɛ́, bɨ bâŋ bɨ a gwú nyə, Zɛmbî nywáá mú gwûmʉshi nyə. Sə́ bʉ́sə owúshinɛd wâ lâŋ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nəcé búgʉ́lálə Jínə́ mə́ Yésus í, Jínə́ dɔɔŋg í mə́ lʉlʉshi múúd bɨ́ mə́ dʉ́g, bɨ́ mə́ bwey mpu ɛ́ga. Búgʉ́lálə Yésus wə́ í mə́ sá nə́ a yálʉ́g fwámɛ́ yâl nda bɨ́ bɛ̂sh mə́ dʉ́g ɛ́ga. ");
INSERT INTO mcp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nə́ ndɛɛ́, bwaaŋg, mə mpú nə́ sɔ́ɔ́lʉ́gʉ́ wɛ̂sh bɨ́nɔ̂ŋ otɔ́we ɔ shwóg bʉ́n bɨ́ á sá yí, í á bə nəcé ijág. ");
INSERT INTO mcp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Njɨ, Zɛmbî nyə á bwey jaaw mímpu mi *búúd ɔ mícúndə́ bɛ́ bɛ̂sh dɨ́ nə́ *Krîst yé mə́ bá bwəma nə micúŋ nə́ ndɛɛ́ a yə, sâ jɔɔŋg wə́ í mə́ bwəma ntʉ́nɨ nɨ. ");
INSERT INTO mcp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kagá cɛ́nd mítə́dʉ́gá, bɨ́ cɛ́nd kuú njɔɔnd, ja jɔɔŋgʉ̂ Zɛmbî mú jímbal *misə́m mín; ");
INSERT INTO mcp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","bɨ́ mə́ ká sá ntɔ́ Cwámba mə bá sá nə́ bɨ bə́g nə́ bud-bud, a ntɨ bɨ́ Yésus nyə á fɛ́ɛ́sh nə́ a bə́g Krîst wʉ́n yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Í jɨɨ nə́ Yésus wɔɔŋgʉ̂ fwóg ji joŋ dɨ́ kə wɔ́ɔ́s ja ísâ byɛ̂sh í bá kwo sɨ̂y ógúgwáán yí. Zɛmbî nyə á ŋgə jaaw ntɔ́ mímpu mí búúd ɔ mícúndə́ bɛ́ nyə á fɛ́ɛ́sh yág wá. ");
INSERT INTO mcp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nəcé Moyîz nyə a shí cɨ nə́: “Cwámba Zɛmbî mə bá ntɨ bɨ́ ŋgwɔ́l múúd micúndə́ nda mə, a njúl mbyágá á kúl búúd jɨ́n. Bɨ ɔ bá gwágʉlə nyə sâ jɛ̂sh nyə́ é bá cɨ bɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Muud yɛ̂sh mə bá bə kú gwágʉlə múúd micúndə́ wɔɔŋg yɛ́, nyə abʉ́lɛ ná bə mə́láŋ mâ kúl búúd jíshéd, a bá gwúyɔw.” ");
INSERT INTO mcp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Buud ɔ mícúndə́ bɛ̂sh, tɛ́ɛ́d wə́ Samyɛ̂l kala nə bɔɔŋg bɛ̂sh bwə́ á zə nyə́dɨ́ mpʉ́sə wá bwə́ á shí bwey dʉ bwiiŋg lâŋ á mwɔ̂w mə́ga. ");
INSERT INTO mcp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bɨ bʉ́sə bwân ɔ́ búúd ɔ mícúndə́, bɨ́ á ŋgə nə́mə́ byɛ̂l Zɛmbî njúl nə sɔ̧ nə impáámbə́ bín. Nyə a sá sɔ̧ jɔɔŋgʉ̂ ja nyə á cɨ nə Abʉraham nə́: “Minjɔ́w mí búúd myâ shí ga myɛ̂sh mí bá dʉ lə́g ibwádán mpwoŋ buud nywô dɨ̂.” ");
INSERT INTO mcp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Shú dʉ́n wə́ Zɛmbî nyə á tɛ́ɛ́d wééshʉli sɔ́ɔl məsáal yé yɛ́, a ntɨ́ nyə nə́ a zə́g bwádan nə bɨ́, a sá nə́ muud yɛ̂sh yɔ́wʉg bɔ́w-bɔ̂w fúlú.» ");
INSERT INTO mcp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pyɛ̂r bá Yuánɛs bwə́ ŋgə́ ná lésha nə buud ntʉ́nɨ, nə ofada, nə njwû á buud bwə́ á dʉ baagʉlə *Luŋ mə́ Zɛmbî wá, nə *Osadwisyɛ̂ŋ bwə́ mú zə wɔ́ɔ́s, ");
INSERT INTO mcp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","bwə́ ŋgə́ bul gwág bɔ̂w nə Pyɛ̂r bá Yuánɛs ŋgə́lə yə buud minjɨ́ɨ́gʉ́lá ŋgə jaaw nə́ buud bwə́ bá gwûm nda Yésus nyə a gwûm nə́. ");
INSERT INTO mcp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Buud ɔ́nɨ bwə́ mú bii Pyɛ̂r bá Yuánɛs kə fad bwo mímbwug dɨ́ nə́ bwə́ bá lás lə́sʉ́ wáŋ mpwó-mwásə́. Nəcé í á bə kugʉ́ mə́ bii shí. ");
INSERT INTO mcp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Njɨ, bɔ́ɔ́lʉ́gá ncúlyá buud bwə́ á gwág kɛ́ɛl wá, bwə́ á *búgʉla. Tâŋ obúgʉla í mú bád kə kumə kúnə́-kúnə ótɔ́ɔ́shin otɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mán mələ̂m, otɔ́we ɔ shwóg, nə ocúmbá buud, nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á bə Yurʉ́səlɛm wá bwə́ mú zə sɛɛŋgya. ");
INSERT INTO mcp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ajəlácɨ á ofada bwə́ á dʉ jɔ̂w nə́ Hána yɛ́ nyə á bə cínɔŋg, nə Kayíf, nə Yuánɛs, nə Aləgʉzándrə, nə mimbyɛ̂l myɛ̂sh myâ wə́ájəlácɨ wâ ofada. ");
INSERT INTO mcp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bwə́ mú zə nə Pyɛ̂r bá Yuánɛs zə tə́l bwo cwánʉ́d na búúd ɔ́nɨ dɨ́. Bwə́ mú ŋgə jî bwo mishílí. Bwə́ nə bwo nə́: «Bɨ ámə sá sɔ́ɔ́lʉ́gʉ́ wʉ́n nɨ nə nyáyɛ́ ŋkul? Bɨ ámə cwééd jínə́ mə́ zə́?» ");
INSERT INTO mcp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ntɔ́, Pyɛ̂r njúl lwándʉ́lá nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim mú ka zə bɛ̧sa nə bwo nə́: «Yé ótɔ́we ɔ shwóg wâ kúl búúd, yé ócúmbá buud, ");
INSERT INTO mcp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","sə́ təl kɔɔd dɨ́ múús nəcé sə́ sálə mbə̂l múúd mənywa. Bɨ́ ŋgə jî sə́ sâ sə́ ámə sá shú nə́ a bə́g mpwogɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Bɨ bɛ̂sh nə bag ɔ *Izʉrəyɛ̂l bɛ̂sh, mpugá nə́ muud bɨ́ ŋgə́ dʉ́g ɛ́ga mə́ bə mpwogɛ́ jínə́ mə́ Yésus-Krîst á Nazarɛ̂t dɨ̂, Yésus bɨ́ á bwambʉlə kwolós dɨ́ yɛ́. Nyə wə́ Zɛmbî nyə a gwûmʉshi yɛ́, nyə wə́ mə́ sá nə́ muud ɛ́ga bə́g mpwogɛ́ nda a tə́l ɛ́ga. ");
INSERT INTO mcp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nəcé Yésus jisə “kwóógʉ́ bɨ́ olwɔ̧́ye bɨ́ á myaas yí, dwó wə́ í mə́ shúgʉla kwóógʉ́ lʉ́ lʉ́mʉga yí”. ");
INSERT INTO mcp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kú nə ŋgwɔ́l múúd jɨ́ nə ŋkul yîl búúd mə́bɔ̂w dɨ́ yə bwo cʉg yɛ́, njɨ nyə. Nəcé kú nə dúl jínə́ lʉ́ múúd sə́ mə́ jə́lá nə *dʉ́g cʉg nə ndɨ̂ wa shí mishwun yí.» ");
INSERT INTO mcp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Buud ɔ́nɨ bwə́ mú bul káám dʉ́gʉ́lə nə́ Pyɛ̂r bá Yuánɛs bwə́ ŋgə lás nə́ kpwɔɔ́-kpwɔɔ́. Bwə́ á bul káam nəcé mpǔlə nə́ Pyɛ̂r bá Yuánɛs bʉ́sə ozhizhe ɔ búúd kú mpu kwas, njɨ í ŋgə́ yida mpûy nə́ bʉ́sə buud ɔ́ gwooŋg mə Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nda bwə́ á ŋgə nə́mə́ dʉ́g muud nyə á yâl ɛ́nɛ tə́l na bwə́dɨ́ koogʉ́ nə́, bwə́ á shígɛ́ ná kwo bə nə sâ bwə́ cɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bwə́ mú cɨ nə Pyɛ̂r bá Yuánɛs nə́ bwə́ wúg na *mpáánzə́ milə́sʉ́ á Zɛmbî dɨ́, bwə́ cúwóg tɔ́ɔ́n. Osémbye ɔ́ mílə́sʉ́ bwə́ mú ka ŋgə sɔ̧́ sâ bwə́ cɨ́g nə bwo yí. ");
INSERT INTO mcp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bwə́ nə́: «Sə́ sáág buud ɔ́ga ntʉdɛl? Jísə mpu bə nə́ bwə́ mə́ sá *shimbá. Í cugɛ́ ná kwo bə shwoó, buud ɔ́ Yurʉ́səlɛm bɛ̂sh bwə́ mə́ mpu ntɔ́, sə́ cugɛ́ nə ŋkul sá mə́shwán. ");
INSERT INTO mcp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Njɨ, í á jə́láyɛ́ nə́ lâŋ nɨ í kwágagí nə muud yɛ̂sh. Ntɔ́, sə́ mpúg yáásʉlə bwo məlwə̂ nə́ ci bwə́ kú ná kwo lésha nə muud nə jínə́ mə́ Yésus.» ");
INSERT INTO mcp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bwə́ mú jɔ̂w bwo, zə mpu yáásʉlə bwo məlwə̂ nə́ ci bwə́ kú ná kwo lésha nə muud nə jínə́ mə́ Yésus, ŋkí nə́ bwə́ kwo jɨ́ɨ́gʉli búúd gúl sâ jínə dɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pyɛ̂r bá Yuánɛs bwə́ mú bɛ̧sa nə bwo nə́: «Bɨmɛ́fwó faasʉgâ. Ye í jəla mísh mə́ Zɛmbî dɨ́ nə́ sə́ yídag gwág nə bɨ́, kú gwág nə Zɛmbî? ");
INSERT INTO mcp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sə́ bâŋ sə́ cugɛ́ nə ŋkul yɔw bwiiŋgʉ́lə sâ sə́ á dʉ́g nə gwág yí.» ");
INSERT INTO mcp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Buud ɔ gúfʉ́gá ósémbye ɔ mílə́sʉ́ bwə́ mú kwo mpu báásʉlə bwo ci nə́ ndɛɛ́, bwə́ músə bɨ́d bwo kú sá bwo sâ. Bwə́ dʉ́g nə́ ŋkí bwə́ yə́ bwo intʉ́gʉ́lí, í bɔ̂w, nəcé buud bɛ̂sh bwə́ á ŋgə bul ságʉsə Zɛmbî nə sâ í á sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Muud nyə á yâl shimbád yɛ́ wɔɔŋg nyə á bə kala múúd í mə́ cɔ̧́ mimbû məwûm mə́nɔ̧̂ yí. ");
INSERT INTO mcp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pyɛ̂r bá Yuánɛs, ja buud ɔ́nɨ bwə́ á bɨ́d bwo yí, bwə́ á kə búúd báŋ dɨ́, kə jaaw bwo lə́sʉ́ wɛ̂sh milúlúú myâ ofada nə ocúmbá buud bwə́ á lás nə bwo yí. ");
INSERT INTO mcp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nda bwə́ á gwág lə́sʉ́ wɔɔŋg nə́, bɛ̂sh bwə́ á bʉ̂n mə́kə̂l jəgʉla nə Zɛmbî lâm ŋgwúd bwə́ nə́: «Mása, wo wə́ wo a sá gwɔ̂w nə shí nə mâŋ nə isâ byɛ̂sh bí cínɔŋg yí. ");
INSERT INTO mcp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wo wə́ wo á balan nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim lás mpu mə́ sɔ́ɔl məsáal woó mpáámbə́ jísʉ́ *Dávid dɨ́, cɨ nə́: Nəcé jɨ́ ilwoŋ í búl cugʉla ntʉ́ga yí? Nəcé jɨ́ ikûl í búl wá mílúú mítə́dʉ́gá mí kú nə wúmbʉ́lé dɨ́ yí? ");
INSERT INTO mcp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ojwû ɔ shí bwə́ mə́ sɛɛŋgya, otɔ́we ɔ shwóg bwə́ bə́dʉga nə́ bɛ̂sh bwə́ zə lúmbʉli nə Cwámba á shí nyɛ̂sh bá Krîst yé. ");
INSERT INTO mcp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nəcé Herod bá Pons Pilât bwə́ mə́ bə́lɛ zə sɛɛŋgya nə ikúl í cúgɛ́ *Oyúdɛn yí nə Dɔ̧ mə́ *Izʉrəyɛ̂l. Bwə́ mə́ zə sɛɛŋgya wa ŋgwə́la gaád nə́ bwə́ zə́ lúmbʉli nə Yésus, jɔ̧jɔ̧ sɔ́ɔl məsáal wô wó á gwágʉlə məwúdə́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bwə́ sá nə́ isâ byɛ̂sh í bwə́mag nda wó á bwey ŋwa cígʉ́lá nə ŋkul nywô nə tə́dʉ́gá woó nə́ í bâg bə nə́. ");
INSERT INTO mcp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cwámba e, ntɨɨg mísh ja gaád wo dʉ́gʉ́g nda bwə́ ŋgə́ cɛɛl juwal sə́ nə́. Ság nə́ osɔ́ɔl ɔ mə́sáal bwô bwə́ bwííŋgʉg kɛ́ɛl dwô nə́ kpwɔɔ́-kpwɔɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Shɛ́ɛ́mbʉ́g mbwə̂ wô, mimbə̂l mí ŋgə́g nə yâl, *isâ í ntɔ̧́ búúd ŋkwóŋ yí nə *isâ í mímbʉ́gú í ŋgə́g nə sɨ̂y Jínə́ mə́ Jɔ̧jɔ̧ Sɔ́ɔl məsáal woó Yésus dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ja bwə́ á shîn jəgʉla yí, kʉ́kʉ́l bwə́ á bə yí í mú ntaŋʉsa, bɛ̂sh bwə́ mú lwánd nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́, bwə́ mú ŋgə bwiiŋg Milə́sʉ́ mí Zɛmbî nə́ kpwɔɔ́-kpwɔɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ncúlyá buud bwə́ á *búgʉla wá bwə́ á ŋgə cʉgə lâm ŋgwúd, nə tə́dʉ́gá ŋgwúd. Kú nə muud nyə á ŋkwandʉwa nə mɛ́ məbii yɛ́. Bɛ̂sh bwə́ á dʉ balan nə məbii máŋ sɛɛŋgí. ");
INSERT INTO mcp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","*Buud ɔ lwámá bwə́ á ŋgə bwiiŋg lâŋ gwúmʉ́lə Cwámba Yésus nyə a gwûm nə məma ŋkûl yí, Zɛmbî ŋgə́ bul lwágʉlə bɛ̂sh məma mpáam nyɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kú ná nə muud á *Dɔ̧ lʉ́ óbúgʉla nyə á kwo bə nə məyáŋgan. Bɔɔŋg bɛ̂sh bwə́ á bə nə məshí ŋkí minjɔ́w wá, bwə́ á ŋgə kusha myo, dʉ zə nə *mwaanɛ̂ wɔɔŋg ");
INSERT INTO mcp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","dʉ zə bwɨ́ɨ́g búúd ɔ́ lwámá shí məkuú. Bwə́ ka dʉ kaaw búúd nda mə́yáŋgan mə́ á dʉ bə nə́. ");
INSERT INTO mcp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ntɔ́, ŋgwɔ́l múúd á Shíprə nə́ jínə́ nə́ Yósɛb, nyə á bə mwâ *Levît, búúd ɔ lwámá bwə́ á kwo gwiid nə́ Barnábas. Jínə dɔɔŋg í kə́ nə́ «Muud mə dʉ́ bándʉlə búúd yɛ́». ");
INSERT INTO mcp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nyə á bə nə fambə́. Nyə á ka kusha gwo. A mú zə nə mwaanɛ̂ wɔɔŋg zə bwɨ́ɨ́g búúd ɔ́ lwámá shí məkuú. ");
INSERT INTO mcp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Njɨ, ŋgwɔ́l múúd nə jínə́ nə́ Ananíyas bá mudá yé Safira bwə́ á zə tɔ̂w cʉ́ŋ. Muud ɛ́nɛ mú nə́mə́ zə kusha dúl bii dɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nə́ ndɛɛ́ bá mudá yé bwə́ mú tɔ̂w cʉ́ŋ, a mú bɛ́ɛ́g ŋgwɔ́l *mwaanɛ̂, a bwɨ́ɨ́g shú dɛ́. A músə kə nə ŋgwɔ́l kə bwɨ́ɨ́g *búúd ɔ lwámá shí məkuú. ");
INSERT INTO mcp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pyɛ̂r mú ka jî nyə nə́: «Ananíyas, jɨ́ í sá nə́ *Sátan jwúg nə lâm wô wɛ̂sh wó mú shweel ŋgwɔ́l mwaanɛ̂ wo ámə kusha shí yɛ́, wo zə́ shɨɨg Ŋkɛ̧́ŋkɛ̧̂ Shíshim? ");
INSERT INTO mcp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ŋgaá nə́ shí í ámə bə shí nywô? Ja wó ámə ka ntâg kusha nywo yí, ŋgaá nə́ mwaanɛ̂ wɔɔŋg nyə ámə bə mwaanɛ̂ woó? Ntʉdɛlɛ́ wó ámə mpu wá wʉ́nɨ tə́dʉga lámʉ́d yɛ́? Ká, buud dɨ́ wó ámə shɨɨg wá, Zɛmbî wə́ wó ámə shɨɨg yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Njɨ Ananíyas nyə a gwág iciyá ínɨ yí, nyə á shwal kadʉwa shí a mú fudə. Ifwaas í mú bul bii búúd bɛ̂sh bwə́ á ŋgə gwág lâŋ nɨ wá. ");
INSERT INTO mcp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Məncwə́má mə́ á tɔ̂w shí, fʉ́lə nyə nə́ ndɛɛ́ bwə́ mú kə dʉl. ");
INSERT INTO mcp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Fwámɛ́ fwála í mú cɔ̧́, je bə mə́wəla məlɔ́ɔl ntʉ́nɨ. Mudá mə́ Ananíyas mú nyíi njɔ́w, a kú mpu sâ í ámə sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pyɛ̂r mú jî nyə nə́: «Jaawʉ́g sə̂. Ye bímbí ga wə́ bɨ́ ámə kusha shí nyɨ́n yí?» Nyə nə́: «Haaw. Bímbí dɔɔŋg wə́ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pyɛ̂r mú ka cɨ nə nyə nə́: «Nəcé jɨ́ bɨ́ ámə mpu tɔ̂w cʉ́ŋ nə́ bɨ mə zə́ shweenzh Shíshim mə Cwámba yí? Dʉgɨ́, búúd bwə́ ámə kə dʉl ŋgwúm woó wá, bwə́ mú na mpumbɛ́d mə́nɨ. Bwə́ é kə nə́mə́ nə wo.» ");
INSERT INTO mcp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nə́mə́ cé jɔɔŋgʉ̂, a mú kadʉwa na Pyɛ̂r dɨ́ shí məkuú, a mú fudə. Məncwə́má mə́ ŋgə́ nə́mə́ nyíi njɔ́w, mə́ mú kwey nyə mbimbə. Bwə́ mú kə nə nyə kə dʉl ŋgwúm dɨ́ koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ifwaas í mú bul bii búúd bɛ̂sh, tɔɔ bɔɔŋg wâ *Dɔ̧ lʉ́ óbúgʉla, tɔɔ bɔɔŋg bwə́ á ŋgə gwág njɨ lâŋ wá. ");
INSERT INTO mcp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","*Buud ɔ lwámá bwə́ á ŋgə sá zhwog *isâ í ntɔ̧́ búúd ŋkwóŋ yí, nə *isâ í mímbʉ́gú mə́ŋkúmbə mə́ búúd dɨ̂. Bɛ̂sh bwə́ á bə cʉ́ŋ ŋgwúd, bwə́ njúl kʉ́l bwə́ á gwiid nə́ Nyíŋgʉ́lé mə́ Sə́lʉmun yí. ");
INSERT INTO mcp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Muud nyə a shígɛ́ ná kwo kə sɛɛŋgya nə bwo. Njɨ, zhwog buud bwə́ á ŋgə bul ságʉsə bwo. ");
INSERT INTO mcp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Buud ŋkí bul bulya bwə́ á ŋgə *búgʉla Cwámba, nə budûm nə budá, bwə́ mú zə ŋgə kwɨ́dʉli gwooŋg dɨ̂, ");
INSERT INTO mcp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","mbií í á wɔ́ɔ́s nə́ buud bwə́ á ŋgə zə nə mimbə̂l ítáádə́ nə ítaŋʉ́d, ŋgə zə bwɨ́ɨ́g koogʉ́ lʉ njwóŋ. Bwə́ á ŋgə sá nə́ ja Pyɛ̂r nyə e cɔ̧́ yí, ka shishîm jé í é kúnya nə wúl mbə̂l cínɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Buud bwə́ á kə cíg wú mílɔɔm myâ kúnə́-kúnə nə Yurʉ́səlɛm, bwə́ ŋgə́ zə nə mimbə̂l nə bɔɔŋg buud mə́jamb mə́ á tə̂l cwúnd dɨ́ wá, bɛ̂sh bwə́ mú ŋgə zə yâl. ");
INSERT INTO mcp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ajəlácɨ á ofada, nə bɔ́ɔ́l búúd wâ ŋkɔɔmʉ́ *Osadwisyɛ̂ŋ bə́nɔ́ŋ bwə́ á bə cʉ́ŋ wá bwə́ á ka zə mpii *buud ɔ lwámá váál áwuwagʉwə̂. ");
INSERT INTO mcp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bwə́ mú bií bwo, kə wá bwo njɔ́w mímbwug íjwû dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ŋgwɔ́l *éŋgəles mə Yawé músə zə mpwó-bulú, zə juw mímpumbɛ́ myâ njɔ́w mímbwug, wééshʉli búúd ɔ lwámá tɔ́ɔ́n, nyə nə bwo nə́: ");
INSERT INTO mcp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Kəgá nyíi *Luŋ mə́ Zɛmbî, bɨ kə́g bwiiŋg búúd sâ jɛ̂sh í dʉ́gyá nə cʉg ágúgwáan ga yí.» ");
INSERT INTO mcp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Njɨ bwə́ á gwág ntʉ́nɨ yí, bwə́ á kə nyíi Luŋ mə́ Zɛmbî ná nə́mə́ mpʉ́mán mpʉ́mán, bwə́ mú ŋgə yə buud minjɨ́ɨ́gʉ́lá. Ajəlácɨ á ofada nə buud bə́nɔ́ŋ bwə́ á bə cʉ́ŋ wá bwə́ mú sɛɛŋg *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî nə sɛɛŋgyá milúlúú mí bag ɔ́ Izʉrəyɛ̂l. Bwə́ mú kənd búúd njɔ́w mímbwug nə́ bwə́ kə́g ŋwa búúd ɔ lwámá. ");
INSERT INTO mcp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ifulísh í mə́ kə wɔ́ɔ́s wu, bwə́ kú kwey búúd ɔ lwámá njɔ́w mímbwug. Bwə́ músə nyiŋgə, zə jaaw bwo nə́ ");
INSERT INTO mcp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Sə́ ámə kə kwey njɔ́w mímbwug í njúl fwámɛ́ feedyá, isándə́lé í tə́l ŋgə́ baagʉlə. Njɨ ja sə́ ámə juw yí sə́ shígɛ́ kwey múúd cwû.» ");
INSERT INTO mcp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ja njwû á buud bwə́ á dʉ baagʉlə Luŋ mə́ Zɛmbî wá bə́nɔ̂ŋ milúlúú myâ ofada bwə́ mə́ gwág ntʉ́nɨ yí, fʉg í mú jímb bwo mílúúd. Bwə́ mú ŋgə jî nə́ ntɔ́ nyə wə́ ntʉdɛl? ");
INSERT INTO mcp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ŋgwɔ́l múúd mú zə jaaw bwo nə́: «Náaá, buud bɨ́ ámə wá mímbwug dɨ́ wá bwə́ təl kʉ́ga Luŋ mə́ Zɛmbî, bwə́ ŋgə yə buud minjɨ́ɨ́gʉ́lá». ");
INSERT INTO mcp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nə́ ndɛɛ́, njwû á Luŋ mə́ Zɛmbî bə́nɔ̂ŋ ifulísh bwə́ mú kə ŋwa bwo. Njɨ, bwə́ á ŋgə zə nə bwo nə́ shɛɛ kú cúg bwo, bwə́ ŋgə́ fúndə nə́ buud bwə́ á bá gwú bwo nə məkwóógʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bwə́ mú zə nə bwo zə tə̂l mpwoombʉ́ gúfʉ́gá ósémbye ɔ́ mílə́sʉ́d. Ajəlácɨ á ofada mú tɛ́ɛ́d jílə bwo mishílí. ");
INSERT INTO mcp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nyə nə́: «Ŋgaá sə́ á shí bwey tə̂l bɨ́ ci nə́ bɨ kú ná ŋgə jɨ́ɨ́gʉli buud jínə́ nɨɨ́d. Njɨ, ja ga, bɨ mə́ lwándʉlə njɨ́ɨ́gʉ́lá wʉ́n Yurʉ́səlɛm yɛ̂sh. Bɨ ŋgə nə́mə́ cɛɛl yə sə́ mpwɛnɛ shwɨy mə múúd ɛ́nɛ.» ");
INSERT INTO mcp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pyɛ̂r bə́nɔ̂ŋ buud ɔ lwámá bwə́ mú bɛ̧sa nə́: «Sə́ mə́ jəlá nə sá mə́gwág nə Zɛmbî, kú bə búúd. ");
INSERT INTO mcp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zɛmbî odâ nyə a gwûmʉshi Yésus bɨ́ á gwú nə məbwə̂ mʉ́n bwambʉlə́lə nyə kwolós dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Njɨ, Zɛmbî nywáá nyə a mə́ bʉ̂n nyə nə mbwə̂ məncwûm yé, a tə̂l nyə amə́dɨ́ á sâ jɛ̂sh, tə̂l nə́mə́ nyə Cʉgye buud shú nə́ buud ɔ *Izʉrəyɛ̂l bwə́ cɛ́ndʉ́g mítə́dʉ́gá, Zɛmbî mú juu bwo nə *misə́m myáŋ. ");
INSERT INTO mcp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sə́ bʉ́sə owúshinɛd wâ isâ byɔɔŋgʉ̂, nə sə́, nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim Zɛmbî nyə á yə buud bwə́ ŋgə́ sá nyə məgwág wá.» ");
INSERT INTO mcp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Buud ɔ gúfʉ́gá ósémbye ɔ mílə́sʉ́ bwə́ mú jág nyada nə mbií lə́sʉ́ nɨ. Bwə́ nə́ bwə́ zə́ gwú búúd ɔ lwámá. ");
INSERT INTO mcp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Njɨ, ŋgwɔ́l *Farizyɛ̂ŋ á *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî, nyɔɔŋg bwə́ á dʉ jɔ̂w nə́ Gamalyɛl yɛ́, nyə á bə yɨ́ɨ́gʉli məcɛ̧ɛ̧, buud bɛ̂sh bwə́ dʉ́gə́ bul gwɔ̧́ɔ̧ nyə. A mú zə tɔ̂w, nyə nə́ bwə́ fwóg wééshʉli búúd ɔ́nɨ tɔ́ɔ́n fúfwálá. ");
INSERT INTO mcp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","A mú ka zə cɨ nə buud bɛ́ nə́: «Bag ɔ́ Izʉrəyɛ̂l, bɨ ɔ́ káálʉ́gə́ nə sâ bɨ́ mə́ cɛ́ɛ́l sá búúd ɔ́ga nɨ. ");
INSERT INTO mcp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nəcé, í afwóyɛ́ nə́mə́ bwey, Tə́das nyə á wɔ́ɔ́s wa, zə jaaw nyúúl nə́ ndɛɛ́ buud je bə mitəd minɔ̧̂ zə bɛ̧ nyə. Njɨ, a mú gwúyɔw, buud bwə́ á bɛ̧ nyə wá bɛ̂sh bwə́ mú cɨɨma, jâŋ í mú shîn. ");
INSERT INTO mcp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mpʉ́sə wɔɔŋgʉ̂, Yúdas á Galilê mú nə́mə́ zə wɔ́ɔ́s mwɔ̂w ílâŋ í á ŋgə sɨ̂y yí. A mú nə́mə́ zə julə ncúlyá buud. Njɨ, ja nyə á yə yí, buud bɛ̂sh bwə́ á bɛ̧ nyə wá bwə́ mú nə́mə́ shîn cɨɨma. ");
INSERT INTO mcp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gwə́ wə́ mə́ cɨ́ nə bɨ́ nə́, fwogá yîl mílâm búúd ɔ́ga dɨ́, bɨ́ bɨ́d bwo nə́ shɛɛ. Nəcé, ŋkí mitə́dʉ́gá myáŋ nə sɔ́ɔ́lʉ́gʉ́ wáŋ í ŋgə zhu búúd dɨ́, mí é shîn jímb mímɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Í ká yida bə nə́ í ŋgə zhu wə́ Zɛmbî, bɨ́ cugɛ́ nə ŋkul caam bwo. Bɨ ɔ́ bɛy nə́ bɨ bâg lúmbʉli nə Zɛmbî.» Bwə́ mú gwág nyə, ");
INSERT INTO mcp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","bwə́ mú jɔ̂w búúd ɔ lwámá, zə fyámʉsə bwo milwóŋ nə́ ndɛɛ́ bwə́ mú tə́l bwo ci nə́ bwə́ kú ná lésha nə buud jínə́ mə́ Yésus dɨ́. Bwə́ mú ntâg bɨ́d bwo. ");
INSERT INTO mcp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Buud ɔ lwámá bwə́ mú wú mpwóómbʉ́ Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî dɨ̂. Bwə́ mú ŋgə kə bwə́ ŋgə́ bul gwág nywa nə́ bwə́ mə́ mpíya nə cúgə́ jínə́ mə́ Yésus dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bwə́ á shígɛ́ yɔw bwiiŋgʉ́lə Jɔ̧jɔ̧ Kɛ́ɛ́l mə́ Krîst Yésus. Bwə́ á dʉ bwiiŋg dwo jwɔ̂w dɛ̂sh, tɔɔ Luŋ mə́ Zɛmbî, tɔɔ mínjɔ́w minjɔ́w. ");
INSERT INTO mcp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ja *ómpwíín bwə́ á zə ŋgə bul bulya yí, milɨ́ɨ́gya mí á zə bə. *Oyúdɛn bwə́ á janʉwo nə cʉg Ogʉrɛ̂k wá bwə́ á ŋgə tədʉwa nə Wəhebʉrə̂. Nəcé mikúsə́ myáŋ mí á ŋgə bwəma nə mpyóŋ mə́ŋkɔw mə́ ídʉ̂w mâ jwɔ̂w dɛ̂sh dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","*Buud ɔ lwámá wûm nə óbá bwə́ mú sɛɛŋg ómpwíín bɛ̂sh, zə cɨ nə bwo nə́: «Í ajə́láyɛ́ nə́ sə́ dʉ́g tə̂l bwiiŋgʉ́lə Milə́sʉ́ mí Zɛmbî, fwo dʉ zə kaaw ídʉ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gwə́ wə́ jɨ́ nə́, bwaaŋg, sɔ̧́gá buud zaŋgbá na mpə́dʉ́gá nyɨ́nʉ́d, bɔɔŋg búúd bwə́ ŋgə́ bwiiŋg lâŋ wáŋ nə́ bʉ́sə ijɔ̧ɔ̧́ i búúd wá, bwə́ njúl lwándʉ́lá nə Shíshim nə fʉg wá, sə́ tə́lʉ́g bwo ísɛ́y í kaawʉ́lə mə́biid. ");
INSERT INTO mcp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sə́ bâŋ sə́ é ka wá mílúú njɨ mə́jəgʉla dɨ́ nə bwiiŋgʉ́lə kɛ́ɛl dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Buud bɛ̂sh bwə́ mú magʉlə tə́dʉ́gá wɔɔŋg. Bwə́ mú fɛ́ɛ́sh Itiyɛn a njúl lwándʉ́lá nə búgə́ nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́. Bwə́ fɛ́ɛ́sh nə́mə́ Fílíp, nə Prokor, nə Nikanor, nə Timoŋ nə Parʉmenas, zə bəd Níkwalâ muud Antyósh nyə á nyíi mísɔɔn Oyúdɛn dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bwə́ mú kə nə bwo búúd ɔ lwámá dɨ́, buud ɔ lwámá bwə́ mú jəgʉla nə Zɛmbî, bwə́ mú bəd bwo məbwə̂. ");
INSERT INTO mcp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Milə́sʉ́ mí Zɛmbî mí mú ŋgə kə shwóg nə shwóg, tâŋ ompwíín í ŋgə kwɨ́dʉli Yurʉ́səlɛm, ncúlyá ofada bwə́ mú magʉlə búgʉ́lálə Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Itiyɛn nyə a bə lwándʉ́lá nə mpaam mə́ Zɛmbî nə ŋkul nə́ cwɔ́ɔ́. A mú ŋgə sá *isâ í mímbʉ́gú nə məma *isâ í ntɔ̧́ búúd ŋkwóŋ yí, buud bɛ̂sh bwə́ ŋgə́ dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bɔ́ɔ́l búúd bə́nɔ̂ŋ Itiyɛn bwə́ mú zə sɛ́ŋʉsa məkə̂l. Í á bə bɔ́ɔ́l búúd wâ *mpáánzə́ mínjɨ́ɨ́gʉ́lá á buud bwə́ á wú mə́lwaá dɨ́ wá, bwə́ njúl buud ɔ́ Sirɛ̂n nə Aləgʉzandrî, zə kɛɛl *Oyúdɛn bwə́ á zhu Silisî nə Azî wá. ");
INSERT INTO mcp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Njɨ, bwə́ á shígɛ́ bə nə ŋkul mə kwag Itiyɛn nəcé nyə á ŋgə lás nə fʉg Ŋkɛ̧́ŋkɛ̧̂ Shíshim á ŋgə yə nyə yí. ");
INSERT INTO mcp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bwə́ mú kusə búúd nə́ bwə́ zə́g máalə Itiyɛn nə́: «Sə́ ámə gwág múúd ɛ́ga ŋgə́ *lás nə Moyîz bá Zɛmbî bwaasʉ́lə mpu.» ");
INSERT INTO mcp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bwə́ mú shwambʉlə búúd bɛ̂sh, nə ocúmbá buud, nə *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ mú zə bii Itiyɛn, kə nə nyə mpáánzə́ milə́sʉ́ á Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bwə́ mú kwəmʉsa bɔ́ɔ́l ówúshinɛd wâ məshɨɨgâ nə́ bwə́ kə́g máalə nə́: «Muud ɛ́ga mə́ dʉ jág lás nə kʉ́l í búl bə ci yí, nə Məcɛ̧ɛ̧ mə́ Moyîz ja jɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sə́mɛ́fwó sə́ ámə gwág a ŋgə́ cɨ nə́ Yésus á Nazarɛ̂t mə bá caam *Mpáánzə́ Zɛmbî, a cɛ́nd íjâm nə ijag yâ odá Moyîz nyə a lʉ́gə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Buud bɛ̂sh bwə́ á bə *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî dɨ́ wá bwə́ mú ŋgə dʉ́g Itiyɛn nə́ figə́-figə́, bwə́ mú dʉ́g nə́ mpwoombʉ́ nyɛ́ nyísə nda mpwoombʉ́ *éŋgəles. ");
INSERT INTO mcp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ajəlácɨ á ofada mú jí nyə nə́: «Ye sâ bwə́ ŋgə́ cɨ wǒ nɨ jísə bánda bə ntɔ́?» ");
INSERT INTO mcp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Itiyɛn mú bɛ̧sa nə́: «Yé bwááŋg, yé ódâ, gwágʉ́lə́gá. Mpáámbə́ íshé *Abʉraham njúl ná shí á Məzhuputamî, a kú fwó kə ji Sharaŋ, Zɛmbî á milwanə́ nyə a lwóya nyúúl nyə́dɨ́, ");
INSERT INTO mcp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","zə cɨ nə nyə nə́: “Wúg wódɨ́ shíd, wo béégya nə njɔ́w búúd wô, wo kə́g shí mə́ bá lwágʉlə wo yííd.” ");
INSERT INTO mcp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ntɔ́, Abʉraham mú wú shí Okalʉdyɛ̧̂ dɨ̂, a mú kə ji Karaŋ. Mpʉ́sə shwɨy mə sɔ́ɔ́ŋgʉ́, Zɛmbî mú yîl nyə wu, ntɨ́ nyə wa shí bɨ́ njúl múús ga. ");
INSERT INTO mcp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Njɨ nyə a shígɛ́ yə nyə ŋkɔw wa shí gaád, kú nə́mə́ bə tɔ́ɔ bímbí múúd jɨ nə ŋkul tə̂l kuú yí. Nyə á yida kaag nə́ í é bá bə shí nyɛ́, mpwoŋ buud nyɛ́ ka bá shúgʉla nə nywo. Í á bə cínɔŋgʉ́ Abʉraham njúl kú fwo bə nə mwân. ");
INSERT INTO mcp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Zɛmbî mú cɨ nə nyə nə́: “Mpwoŋ buud nywô í bá kə ji ízhaá shíd. Buud ɔ́ wu bwə́ bá sá bwo məlwaá bwə́ cúg bwo tâŋ mimbû mitəd minɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Njɨ, lwoŋ búúd í bá wá bwo mə́lwaa dɨ́ nɨ, mə bá yə gwo intʉ́gʉ́lí, bag dwô í mú bá shwub, í mú zə wa shí gaád, zə dʉ yə mə gúmə́.” ");
INSERT INTO mcp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Zɛmbî músə sá bá sɔ̧. Sɔ̧ jɔɔŋgʉ́ mɛ́ məyɨɨgyé wə́ ábɨwáág. Ntɔ́ Abʉraham mú byá *Izaag a sá nyə ábɨwáág jwɔ̂w lʉ́ mwɔɔmb mpʉ́sə byélé. Izaag byá *Yákwab, sá nə́mə́ nyə ntɔ́. Yákwab byá nə́mə́ ímpáámbə́ í á fwɔ̧ ibɛɛnd wûm nə íbá íshé yí, a sá nə́mə́ byo ábɨwáág. ");
INSERT INTO mcp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Impáámbə́ bíshé ínɨ í á ka zə shîŋ Yósɛb. Bwə́ mú kusha nə nyə nə́ a kə́g Igîpten. Njɨ, Zɛmbî nyə á bə nə nyə. ");
INSERT INTO mcp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","A mú ŋgə sɛy yîl nyə *íncwaw í ntʉg byɔɔŋg byɛ̂sh dɨ́ nə́ ndɛɛ́ a kə yə nyə fʉg mísh mə́ Farawôŋ njwú-buud á Igîpten dɨ̂, a sá nə́ Farawôŋ gwágʉ́g nyə nywa lámʉ́d. Farawôŋ mú tə́l nyə ŋgwə́mʉna á Igîpten yɛ̂sh, tɛɛm bə nyə́mɛ́fwó Farawôŋ dɨ́ njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Məma zha músə zə bə Igîpten yɛ̂sh dɨ̂, kumə Kanaan, incwaw í ntʉg bul yáág, impáámbə́ í íshé kú ná nə sâ bwə́ də́g. ");
INSERT INTO mcp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nda Yákwab nyə a gwádʉga nə́ idʉ̂w bísə Igîpten nə́ nyə á ka kənd impáámbə́ í íshé wu ja ashúshwóógʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ja bwə́ á kwo kə ja ábɛɛ̂ yí, Yósɛb músə kə bágʉlə bwo nyúul, Farawôŋ músə zə mpu mpwoŋ buud nyə á zhu yí. ");
INSERT INTO mcp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yósɛb músə ka zə sá nə́ bwə́ kə́g ŋwa sɔ́ɔ́ŋgʉ́ Yákwab nə njɔ́w buud yé wɛ̂sh tâŋ buud məwûm zaŋgbá nə ótɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yákwab músə zə shulə kə Igîpten, nyə á kə yə wu, bə́nɔ̂ŋ impáámbə́ bíshé. ");
INSERT INTO mcp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bwə́ á nyiŋgə nə bwo, kə dʉl Síkɛm, shwoŋ Abʉraham nyə á kusə bwân ɔ́ Imor dɨ́ nə *mwaanɛ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Ŋkaagə́ Zɛmbî nyə á kaag Abʉraham yí í á ŋgə bə nə́ í zə bwəma. Nda wəla dɔɔŋg í á ŋgə shísh nə́, kúl búúd jé í á ŋgə zə bulya, í ŋgə́ bul mpyáánz nûŋ Igîpten. ");
INSERT INTO mcp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kúl mə Abʉraham í á ŋgə mpyáánz ntɔ́ nə ndɛɛ́ kə wɔ́ɔ́s ja wúl njwú-buud í á ŋwa ijwûga yí, wɔɔŋg njwú-buud í á shígɛ́ mpu Yósɛb yí. ");
INSERT INTO mcp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Njwú-buud wɔɔŋg í á ka zə cʉgə nə mpwoŋ buud íshé mə́shɨɨgâ dɨ̂. A mú cúg ódá nə bɔ́w-bɔ̂w lâm nyə á bə nə ndɨ̂ yí nə ndɛɛ́ a sá nə́ bwə́ ŋgə́g nə myaas ikʉ́kény byáŋ í ŋgə́g nə fudə. ");
INSERT INTO mcp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Fwálá dɔɔŋg wə́ Moyîz nyə a byɛ̂l yí. Zɛmbî nyə á ka gwág nyə nywa lámʉ́d, obyɔ̂l bɛ́ bwə́ mú wɨ́ɨ́l nyə bwə́dɨ́ njɔ́w tâŋ oŋkwoond olɔ́ɔl, ");
INSERT INTO mcp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","nə ndɛɛ́, ja bwə́ á ka nə́mə́ kə myaas nyə yí, sás mə́ Farawôŋ mú cwéég nyə, zə baagʉlə nyə tâŋ nda yé mwân. ");
INSERT INTO mcp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moyîz mú nyíŋgʉla mpúyá á Igîpten wɛ̂sh dɨ́ nə́ ndɛɛ́ á mú zə bə ŋkácid íciyá nə mísɔ́ɔ́lʉ́gʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Ja nyə á zə bə nə mimbû məwûm mə́nɔ̧̂ yí, tə́dʉ́gá í mú wɔ́ɔ́s nyə lámʉ́d nə́ a kə́g dʉ́g ómínyɔŋʉ̂ bɛ́ Bag ɔ́ *Izʉrəyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A mú dʉ́g ŋgwɔ́l mwân Igîpten ŋgə́ sá ŋgwɔ́l mwân Izʉrəyɛ̂l. Moyîz mú kɛɛm mwân Izʉrəyɛ̂l, a cú mwân Igîpten. ");
INSERT INTO mcp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nyə á ŋgə tə́dʉga nə́ kúl jé Izʉrəyɛ̂l bwə́ é mpu nə́ Zɛmbî mə zə́ balan nə nyə, zə cʉg bwo. Njɨ, bwə́ á shígɛ́ mpu ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jwɔ̂w í á bɛ̧ yí, a mú kə kwey bwân ɔ́ Izʉrəyɛ̂l óbá bwə́ ŋgə́ shuya. A mú ka cɛɛl bɛ́ɛ́g bwo nə́ bwə́ jíg nə́ shɛɛ, nyə nə bwo nə́: “Bɨ bʉ́sə omínyɔŋʉ̂, nəcé jɨ́ bɨ́ ŋgə́ sɨ́ya yí?” ");
INSERT INTO mcp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Njɨ, nyɔɔŋg nyə á ŋgə sá ŋgwɔ́l yɛ́ mú lámʉsa nə nyə, nyə nə́: “Zə́ nyə á tə́l wo cî nə́ wo dʉ́g sámb sə́ milə́sʉ́? ");
INSERT INTO mcp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wó cɛɛl zə gwú mə nda wó ámə gwú mwân Igîpten nə kugʉ́ nə́?” ");
INSERT INTO mcp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Njɨ Moyîz nyə a gwág ntʉ́nɨ yí, nyə a túb, a mú kə ji shí á Madyan. Wu wə́ nyə á byá bwábudûm óbá yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Nyə á ji wu mimbû məwûm mə́nɔ̧̂, ŋgwɔ́l *éŋgəles mə Cwámba mú zə lwóya nyə nyúúl míŋgwiilɛd, miŋgwiilɛ mí ŋgə́ maŋ kwasa dɨ́ nûŋ shí a shwééshá á mbʉ́mbʉ́ŋ Sinayî. ");
INSERT INTO mcp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyîz mú káam sâ nyə á ŋgə dʉ́g jɔɔŋgʉ̂. A mú ka shísh nə́ a kə́ mpu dʉ́g. Kə́l mə́ Cwámba í mú gwɨ́ɨ́g í ŋgə́ cɨ nə́ ");
INSERT INTO mcp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Mə ɔ́nɨ, mə Zɛmbî impáámbə́ byô, Zɛmbî mə́ Abʉraham, Zɛmbî mə Izaag, Zɛmbî mə Yákwab.” Moyîz mú tɛ́ɛ́d lilyálə, a kú ná kwo sɔ̧́ nə́ a mpúg dʉ́g. ");
INSERT INTO mcp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nə ndɛɛ́, Cwámba mú cɨ nə nyə nə́: “Yílʉ́g mə́ŋgwub məkuúd nəcé kʉ́l shí wó tə́l nɨ í músə nda mə. ");
INSERT INTO mcp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mə mə́ ntɨ mísh, mə mə́ dʉ́g bɔ̂w dɛ̂sh bwə́ ŋgə́ sá kúl jâm Igîpten yí. Mə mə́ gwág nda bwə́ ŋgə́ leegya nə́. Mə mə́ shulə nə́ mə zə́ cʉg bwo. Kagʉ́ kə ja gaád, mə mə́ kənd wo Igîpten.” ");
INSERT INTO mcp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Eŋgəles nyə á lwóya nyúúl kwasa dɨ́ yɛ́, Zɛmbî nyə á kənd nyə, a kə tə́l Moyîz cî, tə̂l nyə cʉgye. Í njúl nə́ bwə́ á ban Moyîz wɔɔŋg, bwə́ jî nyə nə́: “Zə́ nyə á tə́l wo cî nə́ wo zə́g dʉ sámb sə́ milə́sʉ́?” ");
INSERT INTO mcp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moyîz wɔɔŋg wə́ nyə á kə yîl bwo mə́lwaá dɨ̂ Igîpten yɛ́, a ŋgə́ sá *isâ í mímbʉ́gú nə *isâ í ntɔ̧́ búúd ŋkwóŋ yí wu, tɛɛm bə ja bwə́ á lɨ́ɨ́na mâŋ mə́ atɨ́tɨɨ̂ yí, tɛɛm bə ja bwə́ á ŋgə kyey shí a shwééshá dɨ́ tâŋ mimbû məwûm mə́nɔ̧̂ yí. ");
INSERT INTO mcp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nyə wə́ nyə á cɨ nə Bag ɔ́ Izʉrəyɛ̂l nə́: “Zɛmbî mə bá ntɨ bɨ́ ŋgwɔ́l *múúd micúndə́ nda mə, a njúl mbyágá á kúl búúd jɨ́n.” ");
INSERT INTO mcp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moyîz wɔɔŋg wə́ nyə á bə mpə́dʉ́gá éŋgəles nyə á ŋgə lésha nə nyə yɛ́ bə́nɔ̂ŋ odâ, ja kúl búúd jíshé í á sá gúfʉ́gá mbʉ́ŋ Sinayî shí a shwééshád yí. Nyə wə́ a lə́g milə́sʉ́ myâ cʉg wə́ éŋgəles, a kalá yə shé. ");
INSERT INTO mcp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Njɨ, odá bwə́ á shígɛ́ cɛɛl sá nyə məgwág. Bwə́ lámʉsa nə nyə, milâm dʉ nyiŋgə kə njɨ Igîpten. ");
INSERT INTO mcp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bwə́ mú cɨ nə Arɔɔn nə́: “Ság ozɛmbî bwə́ é dʉ tɔ̂w sə́ shwóg wá. Sə́ bâŋ sə́ ampúyɛ́ ná sá í mə́ bə nə Moyîz muud á kə yîl sə́ Igîpten yɛ́.” ");
INSERT INTO mcp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bwə́ mú lúlə mwâ ntɛny tâŋ zɛmbî áyadʉ́g, bwə́ sá nyə *mətúnʉga nda Zɛmbî, bwə́ sá mə́shusʉg gúmálə́lə sâ bwə́ ámə sá nə məbwə̂ máŋ yí. ");
INSERT INTO mcp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Zɛmbî nyə á ka ntâg yid bwo kwoŋ, a mú sá nə́ bwə́ nyíŋgʉ́lág ŋgə́lə yə wəacén-cénî wâ joŋ gúmə́. Sá jɔɔŋg wə́ jísə́ cilyá kálaad búúd ɔ mícúndə́d nə́: Bag ɔ́ Izʉrəyɛ̂l, ye bɨ á cígə mə ocúdú ŋkí nə́ bɨ á sá mə *mətúnʉga mímbû məwûm mə́nɔ̧̂ bɨ́ á bə shí a shwééshá dɨ́ myá? ");
INSERT INTO mcp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ŋgaá nə́ bɨ á yida dʉ ŋkɛ̂ny banda mə́ Molok, nə yuug ácén-céní bɨ́ á sá shú mə́ Zɛmbî wʉ́n Refan yí? Ŋgaá nə́ bɨ á yida dʉ kúd məmpwoombʉ́ mə́ndəlúd dʉ yə mbɛɛ́ íyuug í zɛmbî bɨ́ á sá yí gúmə́? Sâ jɔɔŋg wə́ í sá nə́ mə bâg kənd bɨ́ míkwám dɨ́ shwóg-shwóg cɔ̧́ *Babilɔn. ");
INSERT INTO mcp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Njɨ, ja ódá bwə́ á bə shí a shwééshá dɨ́ yí, bwə́ á shí bə nə banda í á dʉ lwágʉlə nə́ Zɛmbî jisə bwə́dɨ́ yí. Muud nyə á dʉ lésha nə Moyîz yɛ́ nyə á cɨ nə nɛ́ nə́ a kə́g sá banda dɔɔŋgʉ́, a bɛ̧ yuug nyə á dʉ́g yí. ");
INSERT INTO mcp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Odá bwə́ á shí ŋgə kala banda dɔɔŋgʉ́ íkala i búúd byɛ̂sh í á ŋgə byɛ̂l yííd. Bɔɔŋg bə́nɔ̂ŋ Yeshuwa bwə́ á ntɔ̧ shí Zɛmbî nyə a wɨ́ɨ́ŋg wəamə́dɨ́ yí, bwə́ á kə nə́mə́ nə dwo wu, í mú jɨ wu kə wɔ́ɔ́s fwála mə́ *Dávid. ");
INSERT INTO mcp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","«Zɛmbî nyə á bul cɛɛl Dávid wɔɔŋgʉ̂. Ntɔ́ Dávid mú jî Zɛmbî nə́ a sáág nyə mpaam nə́ a lwɔ̧́g bag ɔ Yákwab njɔ́w Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sə́lʉmun wə́ nyə á yida lwɔ̧́ nyə njɔ́w. ");
INSERT INTO mcp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Njɨ, Zɛmbî a gwɔ́w-gwɔ̂w nyə ádɛ́ ji mínjɔ́w məbwə̂ mə́ búúd mə́ ámə lwɔ̧́ myá, nə́mə́ nda múúd micúndə́ nyə á cɨ nə́. ");
INSERT INTO mcp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nyə á cɨ nə́: Joŋ dʉ́sə jiya ícî jâm. Shí nyísə kʉ́l mə́ dʉ tə̂l mə́kuú yí. Wáyɛ́ njɔ́w bɨ́ bɨ́ nə ŋkul lwɔ̧̂ mə yí? Cwámba mə shílə́ ntɔ́. Ŋgow mə́ jɨ nə ŋkul kə woga yɛ́? ");
INSERT INTO mcp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ŋgaá nə́ mə wə́ mə a sá isâ ínɨ byɛ̂sh? ");
INSERT INTO mcp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Bɨ bʉ́sə nə nʉ́ŋ. Bɨ́ ŋgə sá Zɛmbî məlwə̂. Bɨ bʉ́sə njɨ bɨ ɔ́ dʉ sá ŋgáádə́ nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim, nə́mə́ nda impáámbə́ bín í a dʉ sá nə́. ");
INSERT INTO mcp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyáyɛ́ múúd micúndə́ ímpáámbə́ bín í á shígɛ́ lwágʉlə cúwʉ́lí yɛ́? Bwə́ á dʉ gwú bɔɔŋg bwə́ á dʉ bwey zə jaaw nə Tʉ́təlí Muud mə bá zə wá. Tʉ́təlí muud wɔɔŋgʉ̂ wə́ bɨ́ á kɛɛnzh, bɨ́ mú gwú yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bɨ buud bɨ́ á lə́g *mbwoomb mə́cɛ̧ɛ̧ wə́éŋgəles bwə́ á yə bɨ́ má, nə məmpə́ndí mɛ̂sh mâ cínɔŋg wá, bɨ abɛ̧́ɛ̧́yɛ́ mwo.» ");
INSERT INTO mcp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Njɨ búúd ɔ gúfʉ́gá ósémbye ɔ mílə́sʉ́ bwə́ á gwág iciyá ínɨ yí, bwə́ á shwal gwág Itiyɛn yáág-yáág mpimbə, bwə́ ŋgə́ fúgal məjə. ");
INSERT INTO mcp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Itiyɛn nyɛ, lwándʉ́lá nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́, mú kənd mísh joŋ dɨ́, a mú dʉ́g mə́ŋkənʉwa mə́ Zɛmbî, Yésus tə̂l Zɛmbî mbwə̂ məncwûm. ");
INSERT INTO mcp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A mú cɨ nə́: «Dʉgá, mə ŋgə dʉ́g joŋ í mə́ bâŋ. *Mwân mə Múúd təl Zɛmbî mbwə̂ məncwûm.» ");
INSERT INTO mcp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bwə́ mú bwú məma óŋkwiimbyê, bwə́ ŋgə́ fad məlwə̂ máŋ; bɛ̂sh nə lâm ŋgwúdʉ̂, bwə́ shwal kə shwɨy nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bwə́ julə wú nə nyə ŋgwə́la, kə lúmə nyə məkwóógʉ́. Buud bwə́ á ŋgə sá sɔ́ɔ́lʉ́gʉ́ wɔɔŋg wá bwə́ á yîl iwáma byáŋ kə bwɨ́ɨ́g gúl ncúncwə́má shí məkuú. Ncúncwə́má jɔɔŋg wə́ Sôl. ");
INSERT INTO mcp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bwə́ ŋgə́ lúmə Itiyɛn məkwóógʉ́ ntʉ́nɨ́, Itiyɛn mú jɔ̂w Zɛmbî, nyə nə́: «Cwámba Yésus, lə́gʉ́g *jîm jâm.» ");
INSERT INTO mcp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nə́ ndɛɛ́, a mú kúd mə́bwóŋ shí, a kɨ̂m nə ŋkulû nə́: «Cwámba, wo kú lɔ̧́ bwo *sə́m bwə́ ŋgə́ sá ga.» Njɨ nyə á shîn cɨ ntʉ́nɨ yí, a mú yə. ");
INSERT INTO mcp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sôl nyə á bə cʉ́ŋ nə buud bwə́ á gwú Itiyɛn wá. *Dɔ̧ lʉ́ óbúgʉla í á bə Yurʉ́səlɛm yí í á zə bul bwəma nə cúwʉ́lí mwɔ̂w mɔɔŋgʉ́d. Obúgʉla bɛ̂sh bwə́ mú shîn nyuŋgʉla wú Yurʉ́səlɛm, kə mə́shí mâ Yudéa nə Samaríya; í lʉ́g cínɔŋgʉ́ njɨ *buud ɔ lwámá. ");
INSERT INTO mcp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bɔ́ɔ́l búúd bwə́ á wá milâm wə́ Zɛmbî wá bwə́ á kə dʉl Itiyɛn, bwə́ sá nə́mə́ nyə shwɨy mbií áyíyáág. ");
INSERT INTO mcp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sôl nyɛ nyə á ŋgə yáág nə́ á jaŋgʉlə Dɔ̧ lʉ́ óbúgʉla. Nyə á dʉ ŋgə nyíi mínjɔ́w minjɔ́w, dʉ ŋgə bii óbúgʉla, budá nə budûm, dʉ kə wá bwo mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Buud bwə́ á cɨɨma Yurʉ́səlɛm wá bɛ̂sh bwə́ á ŋgə kə mə́zhɨɨ́ məzhɨɨ́, bwə́ ŋgə́ bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛ́l á lâŋ mə́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ntɔ́, Fílíp nyə á shulə kə wúl ŋgwə́la á Samaríya, a mú kə bwiiŋg buud ɔ́ wu lâŋ mə́ *Krîst. ");
INSERT INTO mcp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Buud ɔ́ wu bɛ̂sh bwə́ mú kənd mílâm ísâ Fílíp nyə á ŋgə cɨ yííd, muud ŋgwúd nə ŋgwúd kú sá nʉ́ŋ nəcé bwə́ á ŋgə gwádʉga *məshimbá nyə á ŋgə sâ má, bwə́ ŋgə́ nə́mə́ dʉ́g mwo. ");
INSERT INTO mcp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nəcé zhwog buud bwə́ á bə nə məjamb wá, məjamb mə́ á dʉ wû mə́ ŋgə́ kɨ̂m məma óŋkwiimbyê, mimbúmbwúgʉ́ nə bɔɔŋg bwə́ á dʉ nyɛ̂sh wá bwə́ ŋgə́ yâl. ");
INSERT INTO mcp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ŋgwə́la wɔɔŋg wɛ̂sh í mú bə nə məma mə́shusʉg. ");
INSERT INTO mcp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Í njúl nə́ ŋgwɔ́l múúd nyə á dʉ bə ŋgwə́la wɔɔŋgʉ́d nə jínə́ nə́ Shímun. Muud wɔɔŋgʉ̂ nyə á dʉ sá májig, buud bɛ̂sh wâ Samaríya bwə́ mú dʉ bul káám nyə, nyɛ mú nə́mə́ dʉ jaaw nyúul nə́ á bul bə. ");
INSERT INTO mcp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Buud bɛ̂sh, tɛ́ɛ́d ozhizhe kə kumə məma fwámɛ́ búúd, bɛ̂sh bwə́ á dʉ ŋwa Shímun nə gwɔ̧́ɔ̧́gə́, bwə́ nə́: «Muud ɛ́nɛ jisə ŋkul mə́ Zɛmbî, nyɔɔŋg bwə́ dʉ cɨ nə́ í búl ntɔ̧ yí.» ");
INSERT INTO mcp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bwə́ á kənd milâm nyə́dɨ́ nəcé nyə á bwey bul sá nə́ bwə́ káámʉ́g nyə nə misɔ́ɔ́lʉ́gʉ́ mí jamb myɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Njɨ, ja bwə́ á *magʉlə Jɔ̧jɔ̧ Kɛ́ɛ́l Fílíp nyə á ŋgə bwiiŋg bwo shú Faan mə́ Zɛmbî nə shú jínə́ mə́ Yésus-Krîst yí, bwə́ á ŋgə duwan, nə budûm nə budá nə́mə́. ");
INSERT INTO mcp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Shímun wɔɔŋgʉ̂ nyəmɛ́fwó nyə a *búgʉla nə́mə́, a mú duwan. A mú zə nada nə Fílíp kú ná béégya nə nyə, a ŋgə́ dʉ́g məma ísâ í ntɔ̧́ búúd ŋkul yí nə məshimbá mə́ á ŋgə sɨ̂y má, a ŋgə́ bul káam. ");
INSERT INTO mcp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","*Buud ɔ lwámá bwə́ á bə Yurʉ́səlɛm wá bwə́ á ka gwág nə́ buud ɔ́ Samaríya bwə́ mə́ lə́g Milə́sʉ́ mí Zɛmbî. Bwə́ mú kənd Pyɛ̂r bá Yuánɛs wu. ");
INSERT INTO mcp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bâŋ, ja bwə́ á shulə kə Samaríya yí, bwə́ á jəgʉla nə Zɛmbî shú nə́ obúgʉla wâ wu bwə́ lə́gʉ́g Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nəcé, í á bə cínɔŋgʉ́, Ŋkɛ̧́ŋkɛ̧̂ Shíshim kú fwo shulə tɔɔ múúd ŋgwúd dɨ̂. Bwə́ á yida shîn ŋgə duwan jínə́ mə́ Cwámba Yésus dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nə́ ndɛɛ́, Pyɛ̂r bá Yuánɛs bwə́ mú ŋgə bəd bwo məbwə̂, bwə́ mú ŋgə lə́g Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Shímun nyə á ka dʉ́g nə́ buud bwə́ ŋgə lə́g Ŋkɛ̧́ŋkɛ̧̂ Shíshim ja buud ɔ lwámá bwə́ bə́d bwo məbwə̂ yí, a mú ka zə nə *mwaanɛ̂ nə́ a zə́ yə Pyɛ̂r bá Yuánɛs, ");
INSERT INTO mcp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nyə nə bwo nə́: «Yə́gá nə́mə́ mə ŋkul nɨ, muud yɛ̂sh mə́ é bəd məbwə̂ yɛ́ lə́gʉ́g Ŋkɛ̧́ŋkɛ̧̂ Shíshim.» ");
INSERT INTO mcp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Njɨ, Pyɛ̂r mú yidá cɨ nə nyə nə́: «Bɨná mwaanɛ̂ woó bɛ̂sh nə́ mpaá, nəcé wó ámə tə́dʉga nə́ bwə́ dʉ kusə yána mə́ Zɛmbî nə mwaanɛ̂. ");
INSERT INTO mcp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wo cugɛ́ nə ŋkɔw wa sâ gaád, kú nə tɔɔ sâ, nəcé lâm wô í cugɛ́ tʉ́təlí nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cɛ́ndʉ́g bɔ́w-bɔ̂w tə́dʉ́gá wô nɨ, wo jə́gʉlag nə Zɛmbî, ka nyə é juu wo nə yuug í ámə wɔ́ɔ́s wo lámʉ́d nɨ. ");
INSERT INTO mcp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mə dʉ́g nə́ byó íwɨ́ɨ́mbʉ́g í mə́ bul yáág. Olɨ́lɨŋgɨ̂ bwə́ mə́ bií wo kwám.» ");
INSERT INTO mcp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Shímun mú bɛ̧sa nə́: «Bɨmɛ́fwó jəgʉlagá nə Zɛmbî shú dâm nə́ tɔɔ sâ ŋgwúd bɨ́ mə́ cɨ na nɨ í kú bə nə mə.» ");
INSERT INTO mcp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pyɛ̂r bá Yuánɛs bwə́ mú shîn lwóya búgə́ jáŋ, bwiiŋg kɛ́ɛl mə Cwámba nə́ ndɛɛ́ bwə́ mú nyiŋgə́ kə Yurʉ́səlɛm. Bwə́ mú ŋgə bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛ́l zhɨ́ɨ́ nə zhɨɨ́ zhwog milɔɔm myâ Samaríya dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ŋgwɔ́l *éŋgəles mə Yawé mú zə lás cɨ nə Fílíp nə́: «Kyeyʉ́g kə ŋgɛɛ *məkɔ́ɔ́l mə́ jwɔ̂w, zhɨ́ɨ́ í dʉ shulə wú Yurʉ́səlɛm kə Gaza, zhɨ́ɨ́ nyísə́ kú jwɔ̧́ɔ̧la búúd yí.» ");
INSERT INTO mcp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Fílíp mú nə́mə́ tɨ́ njɔɔnd kú fadʉlə. Ndug nə́ ŋgwɔ́l múúd Ityopí, a njúl myáágə́, a njúl lúlúú ósɔ́ɔl ɔ mə́sáal ɔ cî mudá á Ityopí bwə́ á dʉ jɔ̂w nə́ Kandás yɛ́, muud wɔɔŋgʉ̂ njúl kʉlág mə́bii mə cî mɛ̂sh dɨ̂, nyə á kə Yurʉ́səlɛm kə́lə yə Zɛmbî gúmə́; ");
INSERT INTO mcp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","nyə á ŋgə nyiŋgə a njúl nyə́dɨ́ mə́túwa dɨ́, a ŋgə́ lɔ̧́ kálaad mə́ *múúd micúndə́ Izayí. ");
INSERT INTO mcp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Shíshim mú cɨ nə Fílíp nə́: «Shíshʉ́g kə kumə mə́túwa ɛ́nɛ̌d.» ");
INSERT INTO mcp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fílíp mú lɛɛl kə, a mú gwág múúd ɛ́nɛ ŋgə́ lɔ̧́ kálaad mə́ múúd micúndə́ Izayí. Fílíp mú jî nyə nə́: «Ye wo ŋgə mpu gwág sâ wó ŋgə́ lɔ̧́ nɨ?» ");
INSERT INTO mcp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Muud ɛ́nɛ mú bɛ̧sa nə́: «Mə é ka mpu gwág na ntʉdɛlɛ́ muud nda fwo lwágʉlə mə?» A mú jɔ̂w Fílíp nə́ a kə́wag mə́túwa dɨ́ kə jɨ nyə́dɨ́ koogʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kʉ́kʉ́l mícilyá mí Kálaad Zɛmbî nyə á ŋgə lɔ̧́ wə́ ga: Nyə á bə nda tɔw bwə́ ŋgə́ kə nə ndɨ̂ nə́ bwə́ kə́ cígə yí, nə́mə́ nda mwâ ncwəmbɛ bwə́ ŋgə́ sámb mimyɔ̧ɔ̧́ yí. Nyə a shígɛ́ bɛ̂ny mpu nə́ a lás. ");
INSERT INTO mcp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bwə́ á sɛ́ɛ́mbʉli nyə, bwə́ nyaal nyə ŋkaam nyɛ́ nə məkuú. Zə́ jɨ́ nə ŋkul bá bwiiŋg lâŋ á mpwoŋ buud nyɛ́ yɛ́? Kú nə muud! Bwə́ á sámb nyə jé cʉg shí gaád. ");
INSERT INTO mcp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Myáágə́ mú jî Fílíp nə́: «Mə́ jəgʉla nə wo, fɛ́ɛ́lʉ́g mə, zə́ múúd micúndə́ ŋgə cɨ yɛ́? Ye nyəmɛ́fwó, yə muud shús?» ");
INSERT INTO mcp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fílíp mú ka zə tɛ́ɛ́d lásʉ́lə. A mú zə bwiiŋg nyə Jɔ̧jɔ̧ Kɛ́ɛ́l mə Yésus tɛ́ɛ́dʉ́lə na kʉ́kʉ́l mícilyá nɨɨ́d. ");
INSERT INTO mcp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bá bwə́ mú ŋgə kə nə́ ndɛɛ́ bwə́ mú kə wɔ́ɔ́s júwó. Myáágə́ mú cɨ nə Fílíp nə́: «Dʉgɨ́, məjúwó wə́ mə́ga. Jɨ́ í ntágʉ́lə́ nə́ mə kú duwan yí?» ");
INSERT INTO mcp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fílíp mú cɨ nə nyə nə́: «Ŋkí wo *búgʉla nə lâm wô wɛ̂sh, wo je duwan.» Nyə nə́: «Mə mə́ *magʉlə nə́ Yésus-Krîst jisə *Mwân mə́ Zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A mú cɨ nə́ bwə́ tə́lʉ́g mətúwa. Bɛ̂sh obá bwə́ mú shulə mə́júwód, nə Fílíp, nə myáágə́. Fílíp mú duu nyə. ");
INSERT INTO mcp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ja bwə́ á ŋgə sɔw wú mə́júwód yí, Shíshim mə Yawé í a ŋkɛ̂ny Fílíp kyey nə nyə, myáágə́ kú ná nyiŋgə dʉ́g nyə. Njɨ, a mú kə nə njɔɔnd yé shwóg nə məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fílíp mú kə bə njɨ Azot. A mú ŋgə bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛ́l mə́nd nə mə́nd nə́ ndɛɛ́ kə wɔ́ɔ́s Sezarê. ");
INSERT INTO mcp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na í á bə Sôl, nyɛ ŋgə́ ná cwambʉlə *ompwíín ɔ́ Cwámba, a ŋgə gwú bwo. Nyə á ka kə wə́ Ajəlácɨ á ofada, ");
INSERT INTO mcp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nə́ Ajəlácɨ yə́g nyə kálaad mə yə́ nyə ŋkul nə́ a kə́g Damás, a kə́g ŋgə dʉ́g *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn mâ nûŋ. A ká kwey búúd bwə́ ŋgə́ bɛ̧ zhɨɨ́ mə Cwámba, a bii bɛ̂sh tɔɔ budûm tɔɔ budá, a wɔ́ɔlə bwo məŋkəda, a kə nə bwo Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nyə á ka kə nə́ ndɛɛ́ ŋgə́lə shísh kúnə́-kúnə nə Damás, a mú seegya njɨ məŋkɛnya mə́ mə́ zhu joŋ dɨ́ zə kwan kʉ́l nyə á bə yí. ");
INSERT INTO mcp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A mú kadʉwa shí, a mú gwág kə̂l í ŋgə́ cɨ nə nyə nə́: «Sôl, Sôl, nəcé jɨ́ wó búl lwágʉlə mə cúwʉ́lí ntʉ́nɨ yí?» ");
INSERT INTO mcp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nyə ntâg nə́: «Wo zə́ e, Cwámba?» Cwámba nə nɛ́ nə́: «Mə Yésus, mə wə́ wó ŋgə́ lwágʉlə cúwʉ́lí yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sâ ŋgwúd, wɔɔlʉ́g, wo kúməg ŋgwə́la, bwə́ é jaaw wo sâ wó jə́lá nə sá yí.» ");
INSERT INTO mcp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Buud ɔ́ gwooŋg bɛ́ bwə́ á shigʉla, bwə́ shwal ji ókʉ́l-ókʉ̂l, fʉg jímb bwo mílúúd. Bwə́ á ŋgə gwág njɨ kə́l í ŋgə́ lás, bwə́ kú dʉ́g múúd nyə á ŋgə lás yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sôl músə wɔɔl shí, mísh mə́ njúl nyə nə́ bagə́ njɨ a kú ŋgə dʉ́g. Bwə́ mú bií nyə mbwə́d kə nə nyə kə kumə Damás. ");
INSERT INTO mcp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nyə a já mwɔ̂w mə́lɔ́ɔl, mísh kú dʉ́gya nyə, a kú də, a kú ŋgul. ");
INSERT INTO mcp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ŋgwɔ́l múúd nyə á bə Damás nə jínə́ nə́ Ananíyas, a njúl *mpwíín mə Yésus. Muud wɔɔŋg mú dʉ́g *ntamə́ á mísh nə́ bagə́, Cwámba ŋgə́ jɔ̂w nyə nə́: «Ananíyas!» Nyə nə́: «Cwámba, mə wə́ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Cwámba mú cɨ nə nyə nə́: «Tɔ́wʉ́g, wo kə́g njwóŋ bwə́ dʉ jɔ̂w nə́ “njwóŋ á tʉ́təlí” yí, kə sɔ̧́ Sôl muud á Tárʉs nûŋ njɔ́w mə́ Yúdas. A ŋgə jəgʉla nə́mə́ nda mə́ ŋgə́ lás ɛ́ga. ");
INSERT INTO mcp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nyə ámə dʉ́g ntamə́ á mísh nə́ bagə́, muud bwə́ jɔ́w nə́ Ananíyas yɛ́ mə́ nyíi njɔ́w zə bəd nyə məbwə̂ nə́ mísh mə́ dʉ́gyág nyə.» ");
INSERT INTO mcp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananíyas mú bɛ̧sa nə́: «Cwámba, mə mə́ bul gwádʉga múúd ɛ́nɛ, bímbí lʉ́ mə́bɔ̂w á mə́ sá buud bwô Yurʉ́səlɛm yí. ");
INSERT INTO mcp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tɛɛm bə wa nyəmɛ́fwó, milúlúú myâ ofada mí á yə nyə ŋkul nə́ a zə́g bií búúd bɛ̂sh bwə́ ŋgə́ kɨ̂m jɔ̂w jínə́ dwô wá.» ");
INSERT INTO mcp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Cwámba mú cɨ nə nyə nə́: «Kaág, nəcé mə mə́ fɛ́ɛ́sh múúd ɛ́nɛ nə́ a bə́g mə sâ ísɛ́y shú nə́ ikúl í cúgɛ́ Oyúdɛn yí nə ojwú-buud báŋ nə Bag ɔ́ *Izʉrəyɛ̂l bwə́ mpúg jínə́ dâm. ");
INSERT INTO mcp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Məmɛ́fwó mə é lwágʉlə nyə bímbí lʉ́ minjugú á bá jug shú dâm myá.» ");
INSERT INTO mcp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananíyas mú kə, kə nyíi njɔ́w, bəd nyə məbwə̂, cɨ nə nyə nə́: «Sôl mwaaŋg, Cwámba Yésus wo á bwəma nə nyə zhɨ́ɨ́d ŋgə́lə zə wa yɛ́, nyə ámə ntɨ́ mə shú nə́ mísh mwô mə́ nyíŋgəg dʉ́gya, wo lwándʉ́g nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim.» ");
INSERT INTO mcp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bíl ísâ í mú shugʉla wú nyə míshʉ́d í njúl nda ifʉfâ. Mísh mə́ mú nyiŋgə dʉ́gya nyə nə ndɛɛ́ a mú shwal duwan. ");
INSERT INTO mcp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nə́ ndɛɛ́, a mú də ídʉ̂w, ŋkul í mú kwo wɔ́ɔ́s nyə nyúúlʉd. Bə́nɔ̂ŋ ompwíín wâ Damás bwə́ á ji baalɛ́ mwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kú nə́mə́ kwo lɛŋg fwála, Sôl mú shwal ŋgə kə mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ Oyúdɛn dɨ̂, kə ŋgə cúndə nə́ Yésus jisə *Mwân mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Buud bɛ̂sh bwə́ á ŋgə gwág nyə wá bwə́ á ŋgə káam mbií á nə́ fʉg dʉ jímb lúúd, bwə́ ŋgə́ cɨ nə́: «Ŋgaá nə́ buud bɛ̂sh bwə́ á dʉ kɨ̂m jɔ̂w jínə́ ga Yurʉ́səlɛm wá muud ɛ́ga wə́ nyə á lwágʉlə bwo njugú yɛ́? Ŋgaá nə́ nyə á zə wa nə́ a zə bií bɔɔŋg wâ wa, a wɔ́ɔlə bwo məŋkəda kə nə bwo milúlúú myâ ofada dɨ̂?» ");
INSERT INTO mcp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Njɨ Sôl nywáá nyə á ŋgə yáág nə jaawʉ́lə Jɔ̧jɔ̧ Kɛ́ɛl yáág yáágʉ́g, a dʉ fad Oyúdɛn wâ Damás mimpu nə dʉ́lə mpu lwágʉlə bwo nə́ Yésus wə́ jísə́ *Krîst. ");
INSERT INTO mcp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ja fwámɛ́ baalɛ́ mwɔ̂w mə́ á cɔ̧́ yí, Oyúdɛn bwə́ á cwɔ̧́ yuug nə́ bwə́ gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sôl mú mpu shwushwaga jɔɔŋg. Bwə́ á bə bwə́ mú ŋgə baagʉsə mimpumbɛ́ mí ŋgwə́la mwásə́ nə bulú nə́ bwə́ gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nda ómpwíín bɛ́ bwə́ a mpu ntɔ́ nə́, bwə́ á ŋwa nyə gúl búlúd, wá kúdə́d, bwə́ mú ntɛɛŋgʉli nyə nyuŋg dɨ́ gwɔ̂w kə shul tɔ́ɔ́n. ");
INSERT INTO mcp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kə wɔ́ɔ́s Yurʉ́səlɛm, Sôl nyə á cɛɛl kə sɛɛŋgya nə bɔ́ɔ́l ómpwíín. Njɨ, bɛ̂sh bwə́ á ŋgə fúndə nyə, bwə́ kú fwo *magʉlə nə́ a músə mpwíín. ");
INSERT INTO mcp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnábas músə ŋwa nyə, kə nə nyə *búúd ɔ lwámá dɨ́. A kə bwiiŋg bwo nda Sôl nyə á dʉ́g Cwámba zhɨ́ɨ́d nə́, nə nda Cwámba nyə á lás nə nyə nə́, nə nda nyə á bwiiŋg kɛ́ɛl Damás jínə́ mə́ Yésus dɨ́ kú fúndə muud nə́. ");
INSERT INTO mcp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tɛ́ɛ́d ja jɔɔŋgʉ̂, Sôl bə́nɔ̂ŋ buud ɔ lwámá bwə́ mú bə́dʉga gwooŋg, bə́nɔ̂ŋ bwə́ mú ŋgə́ kyey ŋgwə́la nə ŋgwə́la, a ŋgə́ bwiiŋg kɛ́ɛl á jínə́ mə́ Cwámba, kú fúndə mísh mə́ búúd. ");
INSERT INTO mcp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nyə á dʉ nə́mə́ lésha nə Oyúdɛn bwə́ á janʉwo nə cʉg Ogʉrɛ̂k wá, bə́nɔ́ŋ dʉ nə́mə́ sɛ́ŋʉsa məkə̂l. Njɨ, bâŋ bwə́ mú sɔ̧́ nə́ bwə́ gwú nyə. ");
INSERT INTO mcp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nda ómínyɔŋʉ̂ wâ búgə́ bwə́ á mpu ntɔ́ nə́, bwə́ á kə nə nyə Sezarê, bwə́ mú kənd nyə Tárʉs. ");
INSERT INTO mcp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","*Dɔ̧ lʉ́ óbúgʉla í á ka ŋgə cʉgə nə́ shɛɛ Yudéa yɛ̂sh, nə Galilê, nə Samaríya, gwooŋg í ŋgə́ lal búgə́d, obúgʉla bwə́ ŋgə́ gwɔ̧́ɔ̧ Cwámba. Ŋkɛ̧́ŋkɛ̧̂ Shíshim ŋgə́ sá nə́ buud ŋkí bul bulya bwə́ zə́g ŋgə nyíi gwooŋgʉd. ");
INSERT INTO mcp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Í á ka zə bə, Pyɛ̂r ŋgə́ kyey kə́lə ŋgə dʉ́g obúgʉla, nyə á ka nə́mə́ shulə kə dʉ́g bɔɔŋg wâ Lida. ");
INSERT INTO mcp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A mú kə kwey ŋgwɔ́l múúd nûŋ nə́ Ene. Muud wɔɔŋg nyə á bə mbúmbwúgʉ́, a mə́ já shí tâŋ mimbû mwɔɔmb. ");
INSERT INTO mcp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pyɛ̂r mú cɨ nə nyə nə́: «Ene, Yésus-Krîst mə́ lwag wo. Wɔɔlʉ́g wo báágʉ́g taŋʉ́ gwô.» Nə́mə́ cé nə cé, Ene mú wɔɔl. ");
INSERT INTO mcp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Buud bɛ̂sh bwə́ á bə Lida nə mbwaanzʉlə shí á Sarona wá bwə́ mú dʉ́g nyə, bwə́ mú cɛ́nd kuú njɔɔnd, yid wə́ Cwámba. ");
INSERT INTO mcp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ŋgwɔ́l *mpwíín á mudá nyə á bə Zhwópe nə jínə́ nə́ Tabita. Jínə́ dɔɔŋg í kə́ nə́ Dórʉ́kas. Mudá wɔɔŋgʉ̂ nyə á bul dʉ sá jɔ̧jɔ̧ mísɔ́ɔ́lʉ́gʉ́, a dʉ bul yə mímbúmbúwá isâ. ");
INSERT INTO mcp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Í á ka zə bə mə́nɨ mwɔ̂w dɨ́ nə́ Tabita nyə á bwas nə́ ndɛɛ́ a mú yə. Bwə́ mú gusa nyə nə́ ndɛɛ́ kə bwɨ́ɨ́g fúm á njɔ́w dɨ́ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ompwíín bwə́ á ka gwág nə́ Pyɛ̂r jɨ Lida, Lida njúl kúnə́-kúnə nə Zhwópe. Bwə́ mú kənd búúd obá kə tɛ́ɛ́g nyə məbwə̂ nə́: «Oshwoŋ! Lɛɛlʉgʉ́ zə kʉ́ga, kú neela.» ");
INSERT INTO mcp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pyɛ̂r mú nə́mə́ tɔ̂w shí, bə́nɔ̂ŋ buud ɔ́nɨ bwə́ mú kə. Ja nyə á kə wɔ́ɔ́s yí, bwə́ á kə nə nyə fúm á gwɔ́wʉ́d. Mikúsə́ myɛ̂sh mí mú zə nə məyə̂ nyə́dɨ́, zə ŋgə lwágʉlə nyə ijud nə ikúúd Dórʉ́kas nyə á dʉ laad bwo ja bə́nɔ́ŋ bwə́ á bə yí. ");
INSERT INTO mcp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pyɛ̂r mú wééshʉli búúd bɛ̂sh tɔ́ɔ́n, a mú kúd məbwóŋ shí, a jəgʉla nə Zɛmbî nə́ ndɛɛ́ a mú yid kɔ́ɔ́mb gwoŋʉ́ mbimbəd, a cɨ nə́: «Tabita, wɔɔlʉ́g.» Tabita mú bɛ̂ny mísh, a mú dʉ́g Pyɛ̂r, a músə wɔɔl ji njínjilî. ");
INSERT INTO mcp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pyɛ̂r músə bií nyə mbwə́d, tə́l nyə tʉ́təlî. A músə jɔ̂w óbúgʉla nə mikúsə, a yə bwo nyə kuwó. ");
INSERT INTO mcp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sâ jɔɔŋg í mú mpûy Zhwópe yɛ̂sh, zhwog buud bwə́ mú *búgʉla Cwámba. ");
INSERT INTO mcp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pyɛ̂r nyə á ji cínɔŋg Zhwópe fwámɛ́ zhwog mwɔ̂w, a njul njɔ́w mə́ Shímun nyə á dʉ sá ísɛ́y í íkúúdú í cúdú yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ŋgwɔ́l múúd nyə á bə Sezarê nə jínə́ nə́ Kɔrʉnɛ̂y. Nyə á bə lúlúú ózɨmbɨ təd, kínda ózɨmbɨ ánʉ́nɨ́ dɨ́, kínda bwə́ á dʉ jɔ̂w nə́ «kínda Italî» yí. ");
INSERT INTO mcp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Muud wɔɔŋgʉ̂ nyə á kənd lâm wə́ Zɛmbî, bə́nɔ́ŋ njɔ́w yé wɛ̂sh dʉ bul gwɔ̧́ɔ̧ Zɛmbî. Ntɔ́, nyə á dʉ bul sá buud wâ kúl *Oyúdɛn mikwííndyá, a dʉ jəgʉla nə Zɛmbî ja jɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dúl jwɔ̂w, ŋgɛɛ mə́wəla məlɔ́ɔl mâ mpwó-kugʉ́, nyə a dʉ́g *ntamə́ á mísh nə́ bagə́, a dʉ́g *éŋgəles mə́ Zɛmbî mə́ zə nyíi nyə njɔ́w, zə jɔ̂w nyə nə́: «Kɔrʉnɛ̂y». ");
INSERT INTO mcp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrʉnɛ̂y mú dʉ́g nyə nə́ figə́-figə́ nə́ ndɛɛ́ nda ífwaas í á bii nyə nə́, a mú cɨ nə́: «Nə́ jɨ́ e, Cwámba?» Eŋgəles nə nɛ́ nə́: «Məjəgʉla mwô nə mikwííndyá wó ŋgə́ kwíínd buud myá mí mə́ wɔ́ɔ́s wə́ Zɛmbî, Zɛmbî nyə awúsáyɛ́ myo. ");
INSERT INTO mcp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ntɔ́, kəndʉ́g búúd Zhwópe ja gaád, bwə́ kə́g jɔ̂w ŋgwɔ́l múúd jɨ́ nûŋ nə́ Shímun bwə́ dʉ jɔ̂w nə dúl jínə́ nə́ Pyɛ̂r yɛ́, ");
INSERT INTO mcp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","a njul wə́ ŋgwɔ́l múúd mə́ dʉ sá ísɛ́y í íkúúdú í cúdú yɛ́, bwə́ dʉ nə́mə́ jɔ̂w muud wɔɔŋg nə́ Shímun. Njɔ́w yé wúsə ncindye mâŋ.» ");
INSERT INTO mcp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ja éŋgəles nyə á zə lésha nə nyə nɨ nyə á kyey yí, Kɔrʉnɛ̂y nyə á jɔ̂w olwaábʉlə óbá, nə ŋgwɔ́l zɨmbɨ á bɔɔŋg bwə́ á bul sɛ̂y nə nyə wá, a njúl nə́ nyə a mə́ wá lâm wə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","A mú shîn bwiiŋg bwo sâ jɛ̂sh nə ndɛɛ́ a mú kənd bwo Zhwópe. ");
INSERT INTO mcp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mán mələ̂m, buud ɔ́nɨ bwə́ ŋkág bwə́ mú kúnə́-kúnə nə Zhwópe, Pyɛ̂r mú bád kwáminʉ́ nə́ a kə́ sá mə́jəgʉla. Í á bə ŋgɛɛ tɔ́lɔ́g dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A mú gwág zha nə yéésh nə́ á də. Í á bə bwə́ ŋgə́ ná jáámb idʉ̂w, seegya a músə nda *shíshim yé mə́ wú nyə́dɨ́ nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A mú dʉ́g joŋ í mə́ bâŋ, gúl sâ nda *sanda í kə́l mə́lwə̂ mə́nɔ̧̂ dɨ̂, í ŋgə́ shulə wú joŋ dɨ̂ ŋgə zə shí. ");
INSERT INTO mcp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sá jɔɔŋg í á bə nə mímbií mí ócúdú myɛ̂sh: nə bɔɔŋg wâ məkuú mə́nɔ̧̂, nə bɔɔŋg bwə́ dʉ julə mímwɔ̧ shí wá, nə inunú yâ gwɔ̂w cínɔŋg cwû. ");
INSERT INTO mcp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A mú gwág kə́l í ŋgə́ cɨ nə nyə nə́: «Pyɛ̂r, tɔ́wʉ́g wo gwúg isâ ínɨ́ wo də́g!» ");
INSERT INTO mcp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pyɛ̂r mú bɛ̧sa nə́: «Mbɔ̂, Cwámba. Nəcé mə abwɛ́lɛ́ də sâ jɨ́ nə nyɛɛ́ mísh mə́ Zɛmbî dɨ́ yí, ŋkí sâ íci.» ");
INSERT INTO mcp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kə́l í mú nyiŋgə́ kwo lás cɨ nə nyə nə́: «Sâ Zɛmbî mə́ fúb yí, wɛɛ kú bɛɛg nyiŋgə́ cɨ nə́ jísə sâ abʉ́bɔ̂w.» ");
INSERT INTO mcp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Í á sá ntʉ́nɨ ija ilɔ́ɔl, sâ jɔɔŋg í mú ŋkâŋ kə gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pyɛ̂r fʉg mə́ jímb lúúd nə sâ nyə ámə dʉ́g nɨ nda í kə́ nə́, ndug buud Kɔrʉnɛ̂y nyə ámə lwâm wá, bwə́ mə́ sɔ̧́ njɔ́w mə́ Shímun nə́ sɔ̧̂ sɔ̧̂, bwo mə́ kwey, bwə́ təl mpumbɛ́d. ");
INSERT INTO mcp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bwə́ mú jɔ̂w búúd ɔ njɔ́w, jî bwo Shímun bwə́ dʉ jɔ̂w nə́ dúl jínə́ nə́ Pyɛ̂r yɛ́ ŋkí cínɔŋg wə́ á dʉ ji yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pyɛ̂r ŋgə́ ná ca tə́dʉga nda sâ nyə ámə dʉ́g yí í kə́ nə́, Ŋkɛ̧́ŋkɛ̧̂ Shíshim mú cɨ nə nyə nə́: «Dʉgɨ́, buud olɔ́ɔl bwə́ ŋgə sɔ̧́ wo. ");
INSERT INTO mcp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tɔ́wʉ́g wo shúləg, bɨnɔ́ŋ bɨ kə́g. Wo kú zhízhigə nəcé mə wə́ mə ámə ntɨ́ bwo.» ");
INSERT INTO mcp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pyɛ̂r músə shulə kə bwəma nə buud bɔɔŋg, nyə nə bwo nə́: «Mə wə́ ɛ́ga, mə muud bɨ́ ŋgə́ sɔ̧́ yɛ́. Jɨ́ bɨ́ ámə zə sá yí?» ");
INSERT INTO mcp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bwə́ nə nɛ́ nə́: «Kɔrʉnɛ̂y wə́ nyə ámə ntɨ sə́, Kɔrʉnɛ̂y á lúlúú ózɨmbɨ təd, a jɨ tʉ́təlí muud, a gwɔ̧́ɔ̧́ Zɛmbî, lwoŋ buud *Oyúdɛn jɛ̂sh í ŋgə jaaw lâŋ yé ŋkí nywa. Ŋgwɔ́l Eŋgəles mə́ Zɛmbî nyə á zə cɨ nə nyə nə́ a jɔ́wʉ́g wo, wo kə́g nyə́dɨ́ njɔ́w, a kə́g gwágʉlə sâ wó é bwiiŋg nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pyɛ̂r mú nyíŋgal bwo njɔ́w, bə́nɔ́ŋ bwə́ mú jâ. Mán mələ̂m, a mú wɔɔl, bə́nɔ́ŋ bwə́ mú kə. Bɔ́ɔ́l ómínyɔŋʉ̂ wâ Zhwópe bwə́ mú kə lʉ́gal nyə. ");
INSERT INTO mcp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jwɔ̂w í á kwo bɛ̧ yí, bwə́ mú kumə Sezarê. Kɔrʉnɛ̂y nyə á ŋgə bwánd bwo, a mə́ shîn sɛɛŋg mímbyɛ̂l myɛ́ nə bɛ́ óshwə́ ɔ́ abúgʉ́lág. ");
INSERT INTO mcp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ja Pyɛ̂r nyə á bə nə a zə́ nyíi njɔ́w yí, Kɔrʉnɛ̂y nyə á lɛɛlʉ́ kə səl nyə́mɛ́fwó shí, kúdɔw Pyɛ̂r shí məkuú nyə yə gúmə́. ");
INSERT INTO mcp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pyɛ̂r mú bʉ̂n nyə, nyə nə nɛ́ nə́: «Bʉ́nʉ́g, mə jɨ nə́mə́ múúd nda wo.» ");
INSERT INTO mcp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bá bwə́ mú ŋgə lésha nə́ ndɛɛ́ kə nyíi njɔ́w. A mú kə kwey nə́ zhwog buud bwə́ ámə sɛɛŋgya. ");
INSERT INTO mcp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pyɛ̂r mú cɨ nə bwo nə́: «Bɨ mə mpú nə́ mwâ Yúdɛn jɨ ci kú sɛɛŋgya nə mwân ilwoŋ, kú nə́mə́ shísh nyə kúnə́-kúnə. Njɨ, Zɛmbî mə́ lwágʉlə mə nə́ mə ajə́láyɛ́ nə dʉ́g ŋgwɔ́l múúd nda sâ jɨ́ nə nyɛɛ́ mísh mə́ Zɛmbî dɨ́ yí, ŋkí sâ íci. ");
INSERT INTO mcp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gwə́ wə́ í ámə sá nə́, njɨ mə́ ámə gwág njúwúlú yí, mə ámə zə kú nə oŋkwafad. Nə́ ndɛɛ́, mə ŋgə ka cɛɛl mpu sâ bɨ́ ámə jɔ̂w mə nə ndɨ̂ yí.» ");
INSERT INTO mcp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrʉnɛ̂y mú bɛ̧sa nə́: «Í mə́ sá mwɔ̂w mə́nɔ̧̂ múús, mə á ŋgə sá məjəgʉla ŋgɛɛ mə́wəla məlɔ́ɔl mâ mpwó-kugʉ́ mə́dɨ́ njɔ́w, mə mú dʉ́g njɨ ŋgwɔ́l muud tə́l mə mpwóómbʉ́d nə mikáándə́ mí áŋkʉŋkənʉwâ, ");
INSERT INTO mcp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a ŋgə́ cɨ nə mə nə́: “Kɔrʉnɛ̂y, Zɛmbî mə́ magʉlə mə́jəgʉla mwô, nyə awúsáyɛ́ míkwííndyá wó ŋgə́ kwíínd buud nə ndɨ̂ myá. ");
INSERT INTO mcp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kəndʉ́g búúd Zhwópe bwə́ kə́g jɔ̂w wo Shímun jɨ́ nə dúl jínə́ nə́ Pyɛ̂r yɛ́. A njul njɔ́w mə́ Shímun mə dʉ sá ísɛ́y í íkúúdú í cúdú yɛ́, ncindye mâŋ.” ");
INSERT INTO mcp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ntɔ́ nə́mə́ mə́ á ka lɛɛlʉ́ kənd buud kə jɔ̂w wo yɛ́. Wo mə́ mpu sá nə zə́lə. Nə́ ndɛɛ́, sə́ bɛ̂sh sə́ təl mísh mə́ Zɛmbî dɨ́ ja gaád nə́ sə́ mə́ gwágʉ́lə́ sâ jɛ̂sh Zɛmbî nyə ámə lwâm wo nə́ wo jááwʉg sə́ yí.» ");
INSERT INTO mcp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pyɛ̂r mú ka zə lás, nyə nə́: «Bʉ́bə́lɛ́, mə mə́ mpu nə́ Zɛmbî nyə a dɛ́ dʉ́g búúd məmpwoombʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Jísə njɨ nə́ muud yɛ̂sh mə gwɔ̧́ɔ̧́ Zɛmbî a sá tʉ́təlí yɛ́, tɔɔ a jɨ jáyɛ́ lwoŋ búúd dɨ́, Zɛmbî mə gwág nyə nywa tɛɛm bə nə a jɨ jáyɛ́ kúl búúd dɨ́, tɔɔ jáyɛ́ dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nyə á kənd bag ɔ *Izʉrəyɛ̂l məkə́l. A bwiiŋg bwo Jɔ̧jɔ̧ Kɛ́ɛ́l nə́ buud bwə́ mú nə ŋkul jee cʉgə nə Zɛmbî nə́ shɛɛ nəcé Yésus-Krîst, nyə wə́ jɨ́ Cwámba á buud bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bɨ mə mpú məma sâ í á ŋgə sɨ̂y tɛ́ɛ́d Galilê kə wɔ́ɔ́s Yudéa mpʉ́sə nduwán Yuánɛs nyə á ŋgə cúndə yí. ");
INSERT INTO mcp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bɨ mə mpú nə́ Zɛmbî nyə a gwáágʉlə Yésus á Nazarɛ̂t Shíshim, yə́ nyə məma ŋkûl. Yésus wɔɔŋgʉ̂ nyə á ka ŋgə kə íkʉl ikʉl, ŋgə sâ buud mənywa, ŋgə lwag bɔɔŋg bɛ̂sh Njwû məjamb nyə á ŋgə lwágʉlə cúŋ wá, nəcé Zɛmbî nyə á bə nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sə́ bâŋ sə́ á shí dʉ́g sâ jɛ̂sh nyə á sá shí *Oyúdɛn nə Yurʉ́səlɛm yí, nyə muud bwə́ á bwambʉlə kwolós dɨ́ bwə́ gwú yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Zɛmbî nyə a gwûmʉshi nyə jwɔ̂w álɛ́ɛl, a sá nə́ a lwóyág nyúul. ");
INSERT INTO mcp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Njɨ, nyə a shígɛ́ lwóya nyúúl kúl búúd jɛ̂sh dɨ̂, í á bə njɨ sə́ owúshinɛd Zɛmbî nyə á bwey fɛ́ɛ́sh wá. Mpʉ́sə gwûmʉ́lə nyə á gwûm yí, sə́nɔ́ŋ sə́ á də, sə́ ŋgul. ");
INSERT INTO mcp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nyə a lwâm sə́ nə́ sə́ cúndə́g kɛ́ɛl, sə́ bwaagʉlə nə́ nyə wə́ Zɛmbî nyə a tə̂l nə́ a bâg sámb míkuwó nə mimbimbə milə́sʉ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","*Buud ɔ mícúndə́ bɛ̂sh bwə́ ŋgə bwiiŋg lâŋ yé nə́ muud yɛ̂sh mə *búgʉ́lá nyə yɛ́ a bə nə ijuugá í *mísə́m nəcé jínə́ dɛ́.» ");
INSERT INTO mcp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pyɛ̂r ŋgə́ ná lás ntʉ́nɨ, Ŋkɛ̧́ŋkɛ̧̂ Shíshim mú shulə wə́ buud bɛ̂sh bwə́ á ŋgə gwágʉlə lə́sʉ́ yé wá. ");
INSERT INTO mcp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Obúgʉla bwə́ á bə misɨ́yá mí ábɨwáág wá, bɔɔŋg bɛ̂sh bə́nɔ̂ŋ Pyɛ̂r bwə́ á bə gwooŋg wá, bwə́ mú káam mbií á nə́ fʉg dʉ jímb lúúd. Bwə́ á jág bul káam nə́ Zɛmbî mə́ bə́lɛ yə búúd bwə́ cúgɛ́ Oyúdɛn wá Ŋkɛ̧́ŋkɛ̧̂ Shíshim. ");
INSERT INTO mcp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nəcé bwə́ á gwág buud bɔɔŋg bwə́ ŋgə́ lás mə́kə́lʉ́d, bwə́ ŋgə́ ságʉsə Zɛmbî. Ntɔ́ wə́ Pyɛ̂r nyə á ka cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ye sə́ nyíŋgəg ban nə buud ɔ́ga nə́ bwə́ kú duwan, í njúl nə́ bwə́ mə́ lə́g nə́mə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim nda sə́?» ");
INSERT INTO mcp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A mú lwâm nə́ bwə́ dúwanʉgɨ́ jínə́ mə́ Yésus-Krîst dɨ̂. Bwə́ mú cɨ nə nyə nə́ bə́nɔ́ŋ bwə́ kwóg ná já baalɛ́ mwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nə *buud ɔ lwámá nə obúgʉla wâ Yudéa bwə́ á ka gwág nə́ ikúl í cúgɛ́ *Oyúdɛn yí bwə́ mə́ nə́mə́ lə́g Milə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ja Pyɛ̂r nyə á ka bád kə Yurʉ́səlɛm yí, buud ɔ́ ábɨwáág bwə́ á ka kə lámʉsa nə nyə. ");
INSERT INTO mcp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bwə́ nə nɛ́ nə́: «Wo mə́ kə nyíi búúd wá kú ábɨwáág dɨ́, bɨnɔ́ŋ də ídʉ̂w səŋ ŋgwúd». ");
INSERT INTO mcp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pyɛ̂r mú ka zə tɛ́ɛ́d jaawʉ́lə bwo sâ í á cɔ̧́ yí nə ofɛ́ɛ́l-fɛ́ɛ́lí bɛ̂sh, nyə nə́ ");
INSERT INTO mcp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Mɛɛ mə á bə Zhwópe. Mə ŋgə́ jəgʉla nə Zɛmbî, mə mú seegya njɨ mə músə nda *shíshim wâm mə́ wú mə́dɨ́ nyúúlʉ́d. Mə mú dʉ́g *ntamə́ á mísh nə́ bagə́, gúl sâ nda *sanda í njúl ŋgwɔ́ɔ́lʉ́lá məlwə̂ mə́nɔ̧̂ í ŋgə́ shulə wú gwɔ̂w ŋgə zə mə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mə́ á ka kənd mísh, mə mpu dʉ́g sâ jɔɔŋg, mə mú dʉ́g nə́ cínɔŋg cwû í á bə, nə ocúdú wâ məkuú mə́nɔ̧̂ nə bɔɔŋg wâ jugʉ́, nə bɔɔŋg bwə́ dʉ julə mímwɔ̧ shí wá, nə inunú yâ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mə mú nə́mə́ gwág kə́l í ŋgə́ cɨ nə mə nə́: “Pyɛ̂r, tɔ́wʉ́g, wo gwúg isâ ínɨ wo də́g!” ");
INSERT INTO mcp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mə nə́: “Mbɔ̂, Cwámba. Nəcé sâ jɨ́ nə nyɛɛ́ mísh mə́ Zɛmbî dɨ́ yí, nə sâ íci í abwɛ́lɛ́ kə mə́dɨ́ mpud.” ");
INSERT INTO mcp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kə́l í mú nyiŋgə lás nə mə ja ábɛɛ̂ í ŋgə́ wú gwɔ̂w nə́: “Sâ Zɛmbî mə́ fúb yí, kú bɛɛg nyiŋgə́ cɨ nə́ jísə sâ abʉ́bɔ̂w.” ");
INSERT INTO mcp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Í á sá ntɔ́ ija ilɔ́ɔl, sâ jɔɔŋg jɛ̂sh mú ŋkâŋ kə gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ka seegya nə́, nə́mə́ wəla dɔɔŋgʉ́ dɨ, buud olɔ́ɔl bwə́ mú wɔ́ɔ́s njɔ́w sə́ á bə yí, bwə́ ŋgə́ zhu Sezarê, nə́ bwə́ ámə ntɨ́ bwo mə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Shíshim mú cɨ nə mə nə́ sə́nɔ̂ŋ kə́g, mə nda zhízhigə. Bɔ́ɔ́l obúgʉla ósaman bwə́ mú zə, sə́nɔ̂ŋ mú bɛ̧ búúd bɔɔŋg nə́ ndɛɛ́ bwə́ mú kə nə sə́ njɔ́w mə́ múúd bɨ́ ŋgə́ cɨ ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A mú jaaw sə́ nda nyə á dʉ́g *éŋgəles tə́l nyə njɔ́w ŋgə́ cɨ nə nyə nə́: “Kəndʉg búúd Zhwópe bwə́ kə́g jɔ̂w Shímun bwə́ dʉ jɔ̂w nə dúl jínə́ nə́ Pyɛ̂r yɛ́, ");
INSERT INTO mcp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","nyə é zə bwiiŋg wo kɛ́ɛl í é yə wo cʉg nə njɔ́w wô wɛ̂sh yí”. ");
INSERT INTO mcp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mə á ka nə́mə́ tɛ́ɛ́d nə́ mə́ bwiiŋg bwo kɛ́ɛl, seegya njɨ Ŋkɛ̧́ŋkɛ̧̂ Shíshim mə́ shwɨy bwo nyúúlʉ́d nə́mə́ nda í á bə nə sə́ mə́tɛ́ɛ́dʉ́lé dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mə mú tə́dʉga ciyá Cwámba nyə á cɨ yí nə́: “Yuánɛs nyə á ŋgə duu buud nə məjúwó, bɨ bâŋ bɨ é duwan nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim”. ");
INSERT INTO mcp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ntɔ́, ŋkí Zɛmbî mə́ yə búúd yána dɛ́ nda nyə a yə nə́mə́ sə́ ja sə́ á *búgʉla Yésus yí, mə wə́ zə́ nə́ mə sáág ŋgáádə́ nə Zɛmbî?» ");
INSERT INTO mcp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ja bwə́ á gwág ntʉ́nɨ́ yí, bwə́ á salʉwo, bwə́ mú ságʉsə Zɛmbî, bwə́ nə́: «Ntɔ́ jɨ nə́ Zɛmbî mə́ yə ikúl í cúgɛ́ Oyúdɛn yí zhɨɨ́ nə́ bwə́ cɛ́ndʉ́g mítə́dʉ́gá bwə́ ŋwa cʉg.» ");
INSERT INTO mcp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ja bwə́ á gwú Itiyɛn yí, məma lúmbʉ́lí í á zə bɛ̧ obúgʉla, bwə́ mú shîn cɨɨma, ŋgə kə íkʉl ikʉl kə kumə Fenisî, nə Shíprə nə Antyósh. Bwə́ á ŋgə bwiiŋg njɨ *Oyúdɛn kɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Njɨ, bɔ́ɔ́l búúd bwə́ á bə cínɔŋg bwə́ njúl buud ɔ́ Shíprə nə buud ɔ́ Sirɛ̂n. Bâŋ bwə́ á kə kumə Antyósh, bwə́ mú bwiiŋg Ogʉrɛ̂k Jɔ̧jɔ̧ Kɛ́ɛ́l mə Cwámba Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Cwámba nyə á ŋgə kwíínd bwo nə ŋkul nyɛ́, zhwog buud bwə́ mú *búgʉla, bwə́ cɛ́nd kuú njɔɔnd, yid wə́ Cwámba. ");
INSERT INTO mcp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","*Dɔ̧ lʉ́ óbúgʉla á Yurʉ́səlɛm í á ka gwádʉga lâŋ wɔɔŋg. Bwə́ mú kənd Barnábas wu Antyósh. ");
INSERT INTO mcp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnábas wɔɔŋg, ja nyə á jé Antyósh a dʉ́g nda Zɛmbî nyə a lwóya mpaam nyɛ́ nə́, nyə á bul bə nə məshusʉg, a mú cwîny óbúgʉla bɛ̂sh nə́ bwə́ jííg gwooŋg mə Cwámba dɨ́ nə milâm myáŋ myɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nyə á bə jɔ̧ múúd, a njúl lwándʉ́lá nə jɔ̧jɔ̧ Shíshim nə búgə́ nə́ cwɔ́ɔ́. Bɔ́ɔ́lʉ́gá ncúlyá buud bwə́ mú kwɨ́dʉli Dɔ̧ lʉ́ óbúgʉla dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnábas nyə á ka kə Tárʉs nə́ a kə́ ŋwa Sôl. ");
INSERT INTO mcp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nda nyə á kwey nyə nə́, nyə á zə nə nyə Antyósh. Bá bwə́ mú jâ cínɔŋgʉ́ mbû ncindî, bwə́ ŋgə́ sɛɛŋgya nə Dɔ̧ lʉ́ óbúgʉla, bwə́ ŋgə́ yə ncúlyá buud minjɨ́ɨ́gʉ́lá. Nûŋ Antyósh wə́ *ompwíín bwə́ á tɛ́ɛ́d gwiidɔw nə́ okrîstɛn yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Í á ka zə bə na dúl baan dɨ́ nə́, bɔ́ɔ́l *búúd ɔ mícúndə́ bwə́ á shulə wú Yurʉ́səlɛm kə Antyósh. ");
INSERT INTO mcp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ŋgwɔ́l á bwo, nə jínə́ nə́ Agabus, músə zə lás nda Shíshim nyə a lwágʉlə nyə nə́. A mú jaaw nə́ məma yáág-yáág zha í bá bə shí nyɛ̂sh dɨ̂. Zha nyɔɔŋg í á shí nə́mə́ bə fwála Klóod nyə á bə Káázɛl yí. ");
INSERT INTO mcp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ntɔ́, ompwíín bwə́ mú ŋwa cígʉ́lá nə́ bwə́ zə́ sɛɛŋg míkwííndyá, muud yɛ̂sh wá bímbí á jɨ́ nə ŋkul wá yí, bwə́ kənd bɔɔŋg óbúgʉla wâ Yudéa. ");
INSERT INTO mcp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bwə́ á sá nə́mə́ ntɔ́, bwə́ mú kənd Barnábas bá Sôl nə mikwííndyá, bwə́ kə yə ócúmbá buud wâ Yudéa. ");
INSERT INTO mcp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Baan dɔɔŋgʉ́ Njwú-buud Herod nyə a tɛ́ɛ́d nə́ a zə́ ŋgə jugʉshi bɔ́ɔ́l búúd ɔ́ *Dɔ̧ lʉ́ óbúgʉla. ");
INSERT INTO mcp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A mú gwú Zhâk mínyɔŋʉ̂ mə Yuánɛs nə kafwɛlɛ. ");
INSERT INTO mcp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nda nyə á dʉ́g nə́ *Oyúdɛn bwə́ á ŋgə gwág nywa sâ jɔɔŋg nə́, nyə á ka nə́mə́ bii Pyɛ̂r, í njúl fwála lʉ́ zaŋ bwə́ dʉ də ibʉlɛ́d yâ kú nə *ləvur yí. ");
INSERT INTO mcp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nyə á bii nyə ntʉ́nɨ, a mú kə wá nyə mímbwug dɨ́, a tə̂l íkínda í ízɨmbɨ inɔ̧̂ nə́ í báágʉləg nyə, kínda ízɨmbɨ jɛ̂sh nə ozɨmbɨ onɔ̧̂. Nyə a ŋgə tə́dʉga nə́ a bá ka zə tə̂l nyə kɔɔd dɨ́ tâm buud ja zâŋ *Páska í bá cɔ̧́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pyɛ̂r nyə á ka bə mímbwugʉd. Dɔ̧ lʉ́ óbúgʉla dâŋ, ŋgə́ báásʉlə məjəgʉla ŋgə́lə jəgʉla nə Zɛmbî shú dɛ́d kú yɔw. ");
INSERT INTO mcp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Búlú í á bə nə́ Herod mə bá tə̂l Pyɛ̂r kɔɔd dɨ́ nda mán yí, Pyɛ̂r nyə á bə a mbwúg gwə́d ŋgwɔ́ɔ́lʉ́lá mə́ŋkəda nə mikwoolú mí íŋkwánz mímbá. Nyə a bə a mbwúg mpə́dʉ́gá ózɨmbɨ obá, isándə́lé í tə́l mpumbɛ́d. ");
INSERT INTO mcp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ka seegya nə́ ŋgwɔ́l *éŋgəles mə Yawé mə́ jé, kʉ́l fúm jɔɔŋg mə́ shwal bə nə məŋkɛnya nə́ ŋgə́ŋ. Eŋgəles mú yíd Pyɛ̂r bugʉ́lu dɨ́, juumʉshi nyə, nyə nə nɛ́ nə́: «Nə́ câ! Wɔɔlʉ́g!» Mikwoolú mí íŋkwánz mí mú shugʉla wú Pyɛ̂r mə́bwə́d. ");
INSERT INTO mcp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Eŋgəles mú kwo cɨ nə nyə nə́: «Cɛ̧ɛ̧ləgʉ́ kanda wo bwáád mə́ŋgwub.» A mú nə́mə́ sá ntɔ́. Eŋgəles nə́: «Bwáádʉ́g kúúd gwô, wo bɛ̧́g mə.» ");
INSERT INTO mcp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pyɛ̂r mú cúwo tɔ́ɔ́n ŋgə bɛ̧ éŋgəles, a kú fwo mpu magʉlə nə́ sâ éŋgəles ŋgə́ sá yí jísə bʉ́bə́lɛ́. Nyə á ŋgə ŋwa nda *ntamə́ á mísh nə́ bagə́. ");
INSERT INTO mcp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ja bwə́ mə́ cɔ̧́ cé ísándə́lé ashúshwóógʉ́, bwə́ cɔ̧́ ábɛɛ̂ yí, bwə́ mú jé njuwʉg íŋkwánz á ŋgɛɛ ŋgwə́la. Njuwʉg wɔɔŋg mú juw bwo wə́mɛ́fwó. Njɨ bwə́ á wɔ́ɔ́s tɔ́ɔ́n kə njwóŋ dɨ́ yí, éŋgəles mú kyey, béégya nə Pyɛ̂r. ");
INSERT INTO mcp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Fʉg mú zə Pyɛ̂r lúúd, a mú cɨ nə́: «Mə mə́ ka mpu já gaád bʉ́bə́lɛ́ nə́ Cwámba nyə ámə ntɨ éŋgəles yé, zə tɨ́ yîl mə məbwə̂ mə́ Herod dɨ́ nə́ mə fáámʉg nə sâ Oyúdɛn bwə́ ŋgə́ jɨɨ sá mə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nda nyə á shîn mpu ntɔ́ nə́, nyə á ka kə njɔ́w mə́ Maríya nyɔɔŋgʉ́ mə Yuánɛs bwə́ á kwo dʉ jɔ̂w nə́ Márkus yɛ́. Cínɔŋg wə́ zhwog buud bwə́ á bə bwə́ mə sɛɛŋgya, bwə́ ŋgə́ jəgʉla nə Zɛmbî yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nyə á ka kudə mbɛ̂. Ŋgwɔ́l sɔ́ɔl məsáal mudá nə jínə́ nə́ Rôd mú shísh mbɛ́d kə gwágʉlə. ");
INSERT INTO mcp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","A mú yag Pyɛ̂r kə̂l nə́ ndɛɛ́, a kú fwo juw mbɛ̂, a mú yida nyiŋgə nə kʉ́lə́ nə məshusʉg kə jaaw búúd nə́ Pyɛ̂r təl na mbɛ́d tɔ́ɔ́n. ");
INSERT INTO mcp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bwə́ mú cɨ nə nɛ́ nə́: «Wo jɨ lad». Nyɛɛ mú nə́mə́ bwaagʉlə nə́ a ŋgə jaaw bʉ́bə́lɛ́. Bwə́ nə́: «Eŋgəles yé wə́ ɛ́nɛ.» ");
INSERT INTO mcp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pyɛ̂r mú nyiŋgə bul kudə mbɛ̂. Bwə́ mú juw, bwə́ mú dʉ́g nyə, fʉg mú jímb bwo mílúúd. ");
INSERT INTO mcp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nyɛɛ mú fʉfə bwo mbwə̂ nə bwə́ jíg kʉ́l-kʉ̂l. A mú bwiiŋg bwo nda Cwámba nyə ámə yîl nyə njɔ́w mímbwug wééshʉli nyə tɔ́ɔ́n nə́. A mú cɨ nə bwo nə́: «Kəgá jaaw Zhâk bə́nɔ̂ŋ bɔ́ɔ́l bwááŋg bɛ̂sh». A músə kyey kə kʉ̂l shúsʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ja mán í á lə̂m yí, ózɨmbɨ məkuú mə́ á tə̂w shí nə á Pyɛ̂r, bwə́ kú mpu sâ í ámə sɨ̂y yí. ");
INSERT INTO mcp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod mú kənd búúd mə́sɔ̧́ɔ̧́gʉ́d, njɨ bwə́ kú kwey Pyɛ̂r. A mú tə̂l ísándə́lé kɔɔdʉd nə́ ndɛɛ́ a mú lwám buud nə bwə́ gwúg byo. Herod músə shulə wú Yudéa kə Sezarê, kə ji wu. ");
INSERT INTO mcp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod nyə á ka zə bə nə mbíya zhwuŋʉ́ nə buud ɔ Tir nə bɔɔŋg wâ Sidon. Nda búúd bɔɔŋg bwə́ á mpu nə́ məbii máŋ mə́ á dʉ bul zhu lɔɔm mə́ Herod nə́, bwə́ á ka tɔ̂w cʉ́ŋ nə́ bwə́ jəlá nə kə dʉ́g nyə, a sáág nə́ bə́nɔ́ŋ bwə́ jííg nə́ shɛɛ. Bwə́ mú kə kwambʉlə nə mwâ mpáánzə́ yé Blastos nə́ a sáág nə́ bə́nɔ̂ŋ Herod bwə́ bwə́mag. ");
INSERT INTO mcp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jwɔ̂w lʉ́ mpwəmá dɔɔŋgʉ́, Herod mú bwáád míkáándə́ mí ícî myɛ́ nə́ ndɛɛ́ a mú kə ji jiya ící dɨ̂. A mú ka zə lás nə buud ɔ́nɨ kaand. ");
INSERT INTO mcp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Buud ɔ́nɨ bwə́ mú shwal wá yáŋgá nə́: «Dʉ́nɨ kə́l dʉ́sə njɨ kə́l lʉ́ Zɛmbî, kú bə kə́l lʉ́ múúd.» ");
INSERT INTO mcp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ka seegya nə́ ŋgwɔ́l *éŋgəles mə Yawé mə́ yíd nyə nəcé a bə́lə kú yə Zɛmbî gúmə́ jé. A mú yə, mishwóómbú də́lə nyə. ");
INSERT INTO mcp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Milə́sʉ́ mí Zɛmbî myáá mí mú nə́mə́ ŋgə kə njɨ shwóg nə shwóg. ");
INSERT INTO mcp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnábas bá bâŋ Sôl bwə́ mú shîn sá lwámá bwə́ á kə Yurʉ́səlɛm yí nə́ ndɛɛ́ bwə́ mú nyiŋgə. Ja bwə́ nyíŋgə́ nɨ, bwə́ mú kə nə Yuánɛs bwə́ á kwo dʉ jɔ̂w nə́ Márkus yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Dɔ̧ lʉ́ óbúgʉla í á bə Antyósh yí í á bə nə *buud ɔ mícúndə́ nə oyɨ́ɨ́gʉli. Barnábas nyə á bə cínɔŋg, nə Símʉyon bwə́ á kwo dʉ jɔ̂w nə́ Nizhɛr yɛ́, nə Lusyus múúd á Sirɛ̂n, nə Manaɛn bá cî Herod á tatarâk bá wɔɔf kʉ́l ŋgwúd yɛ́, nə Sôl. ");
INSERT INTO mcp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dúl jwɔ̂w bwə́ á ŋgə sá mísɔɔn bwə́ ŋgə́ ci idʉ̂w yí, Ŋkɛ̧́ŋkɛ̧̂ Shíshim nyə á cɨ nə bwo nə́: «Tə́lʉ́gá mə Barnábas bá Sôl koogʉ́, bwə́ zə́ kə sá sáal mə́ mə́ fɛ́ɛ́sh bwo nə́ bwə́ sáág yí.» ");
INSERT INTO mcp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nə́ ndɛɛ́, bwə́ mú jəgʉla nə Zɛmbî bwə́ ŋgə́ cɨ idʉ̂w, bwə́ mú bəd Barnábas bá Sôl məbwə̂, bwə́ mú bɨ́d bwo nə́ bwə́ kyéyʉg. ");
INSERT INTO mcp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ja Ŋkɛ̧́ŋkɛ̧̂ Shíshim mə́ kənd Barnábas bá Sôl lwámád ntʉ́nɨ yí, báá bwə́ mú shulə kə Seləsi, bwə́ mú ŋwa byɔ́ɔl cɔ̧́ kə kɔ́ɔ́mb ŋkwamə́ á Shíprə. ");
INSERT INTO mcp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bwə́ á kə wɔ́ɔ́s Salaminə, ŋgə bwiiŋg Milə́sʉ́ mí Zɛmbî *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ *Oyúdɛn dɨ̂, bwə́ ŋgə́ kə nə Yuánɛs tâŋ kágə́ mílwámá. ");
INSERT INTO mcp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bwə́ mú lɨ́ɨ́na ŋkwamə́ nyɔɔŋg nyɛ̂sh nə́ ndɛɛ́ kə wɔ́ɔ́s ŋgwə́la á Pafos. Bwə́ á kə kwey ŋgwɔ́l mwâ Yúdɛn nûŋ Pafos nə jínə́ nə́ Bar-Yésus, a njúl muud ncidə, *muud micúndə́ á məshɨɨgâ. ");
INSERT INTO mcp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bar-Yésus ɛ́nɛ bá ŋgwə́mʉna Serzhus Polus wə́ bwə́ á ŋgə cʉgə. Ŋgwə́mʉna nywáá njúl nə fʉg, nyə á ka jɔ̂w Barnábas bá Sôl nəcé nyə á bə nə məma yéésh nə́ á gwág kɛ́ɛl mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Njɨ, Elimas mú ŋgə laa bwo, a ŋgə́ yida cɛɛl shwúgʉli ŋgwə́mʉna nə́ a kú *búgʉla. Jínə́ lʉ́ Elimas í kə́ nə́ muud ncidə. ");
INSERT INTO mcp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sôl, bwə́ jɔ́w nə́ Pwôl yɛ́, mə́ lwánd nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́ músə ka dʉ́g Elimas nə́ figə́-figə́, ");
INSERT INTO mcp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a mú lás nə nyə nə́: «Yîf! yé mása məkə́ŋ nə məshɨɨgâ ɛ́ga, yé mwân mə Njwû məjamb, yé múúd jɨ́ kú cɛɛl ótʉ́təlí ɛ́ga! Wo ayɔ́wɛ́ ŋgə́lə cɛɛl ntáma jɔ̧jɔ̧ íyuug i Cwámba? ");
INSERT INTO mcp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wo zə́ dʉ́g ja gaád. Mbwə̂ mə́ Zɛmbî í mə́ bii wo. Wo zə́ fwo bə áncím-ncîm, kú ná dʉ́g mə́ŋkɛnya mə́ jwɔ̂w. Wo é ji ntɔ́ fwámɛ́ fwála.» Pwôl ká nə́mə́ shîn lás ntʉ́nɨ, gúndə́ nə yídʉ́gʉ́ í mú shulə Elimas míshʉ́d, a mú ŋgə lyɛ̧da kʉkʉ̂l ŋgwúd ŋgə sɔ̧́ muud bííg nyə mbwə́d yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Njɨ ŋgwə́mʉna nyə á dʉ́g sâ í á sɨ̂y nɨ yí, nyə shwal bə mbúgʉla, njɨ́ɨ́gʉ́lá nyə á gwág shú mə́ Cwámba yí í mə́ bií nyə. ");
INSERT INTO mcp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pwôl bə́nɔ̂ŋ buud ɔ́ gwooŋg bɛ́ bwə́ mú kəwa byɔ́ɔ́lʉ́d Pafos, kə Pɛrzhe kɔ́ɔ́mb shí á Pamʉfilî. Yuánɛs mú kə béégya nə bwo nûŋ, nyɛ mú nyiŋgə kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bâŋ bwə́ mú tɨ́ Pɛrzhe, ŋgə kə nə́ ndɛɛ́ kə wɔ́ɔ́s Antyósh á Pisidî. Bwə́ mú kə nyíi *mpáánzə́ minjɨ́ɨ́gʉ́lá dɨ́ jwɔ̂w lʉ́ Sábaad, kə ji shí. ");
INSERT INTO mcp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ja lɔ̧́lə *mbwoomb mə́cɛ̧ɛ̧ nə micilyá mí búúd ɔ mícúndə́ í á shîn yí, otɔ́we ɔ shwóg wâ mpáánzə́ minjɨ́ɨ́gʉ́lá bwə́ mú cɨ nə bwo nə́: «Bwaaŋg, ŋkí bɨ bʉ́sə nə gúl sâ bɨ́ bɨ́ nə ŋkul bándʉlə búúd nə ndɨ́ yí, lásʉ́gá ja gaád.» ");
INSERT INTO mcp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pwôl mú tɔ̂w tʉ́təlí, a fʉfə bwo mbwə̂, a músə lás nə́: «Nə bag ɔ́ *Izʉrəyɛ̂l nə bɔɔŋg bwə́ ŋgə́ gwɔ̧́ɔ̧ Zɛmbî wá, bɨ ɔ gwágʉ́lə́ mə. ");
INSERT INTO mcp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Zɛmbî á kúl búúd Izʉrəyɛ̂l jísʉ́ ga nyə a fɛ́ɛ́sh osɔ́ɔ́ŋgʉ́ bʉ́sʉ́. Nyə a sá nə́ kúl búúd jísʉ́ í kə́g bul mpyáánz nûŋ jiya á Igîpten dɨ̂. Nə́ ndɛɛ́ nyə a yîl bwo nûŋ nə mbwə̂ ŋkûl yé. ");
INSERT INTO mcp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A mú ŋgə jísɔw bwo shí a shwééshá dɨ́ kə wɔ́ɔ́s je kumə mimbû məwûm mə́nɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","A mú jaŋgʉlə ílwoŋ í búúd zaŋgbá shí á Kanaan nə́ ndɛɛ́ a yə ódâ shí nyáŋ tâŋ lʉ́gí ");
INSERT INTO mcp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","shú mímbû kúnə́-kúnə mitəd minɔ̧̂ nə məwûm mə́tɔ́ɔn. «Mpʉ́sə wɔɔŋgʉ̂ a mú dʉ wééshʉli bwo osémbye ɔ mílə́sʉ́ nə́ ndɛɛ́ zə wɔ́ɔ́s fwála mə́ *múúd micúndə́ Samyɛ̂l. ");
INSERT INTO mcp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ja jɔɔŋgʉ̂ bwo mú jɨɨ nə́ bwə́ bə́g nə wáŋ njwú-buud. Zɛmbî mú yə bwo Sawul mwân mə Kís a njúl mbyágá á bɛɛnd mə́ Bəŋzhamɛ̧̂. Sawul mú jwú nə bwo tâŋ mimbû məwûm mə́nɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Zɛmbî mú yîl nyə, a mú tə̂l bwo *Dávid njwú-buud. Dávid wɔɔŋg wə́ Zɛmbî nyə á bwiiŋg lâŋ yé nə́: “Mə mə́ dʉ́g nə́ Dávid mwân mə Yése jisə muud mə́ kwaga nə tə́dʉ́gá wâm yɛ́, nyə wə́ mə bá dʉ sá sâ jɛ̂sh mə́ bá dʉ jɨɨ nə́ a sáág yí.” ");
INSERT INTO mcp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nyə́dɨ́ mpwoŋ buud dɨ́ wə́ Zɛmbî nyə a lwándʉ́lə́ mpu yé, a wééshʉli Yésus cʉgye buud á Izʉrəyɛ̂l yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Shúshwóógʉ́ nə́ cʉgye wɔɔŋg zə́g, Yuánɛs nyə a zə jɨ́ɨ́gʉli kúl búúd Izʉrəyɛ̂l jɛ̂sh nduwán tâŋ yuug nə́ bwə́ mə́ cɛ́nd mítə́dʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ja Yuánɛs wɔɔŋgʉ̂ nyə á ŋgə shínal sáal dɛ́ yí, nyə á ŋgə cɨ nə buud nə́: “Bɨ́ ŋgə ná tə́dʉga nə mə wə́ zə? Mə cugɛ́ múúd bɨ́ ŋgə́ tə́dʉga nə́ mə́ jísə́ yɛ́. Njɨ, ŋgwɔ́l múúd zag mə́dɨ́ mpʉ́sə. Mə ampíyáyɛ́ nə́ mə cínyʉg nyə mikwoolú mí mə́ŋgwub məkuúd.” ");
INSERT INTO mcp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bwááŋg bɛ̂sh, tɔɔ mpwoŋ buud mə́ *Abʉraham tɔɔ bɨ́ bɔɔŋg bɨ́ ŋgə́ gwɔ̧́ɔ̧ Zɛmbî wá, shé wə́ Zɛmbî nyə á ntɨ kɛ́ɛl á cʉg dɔɔŋg wá. ");
INSERT INTO mcp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Buud ɔ́ Yurʉ́səlɛm bɛ̂sh nə otɔ́we ɔ shwóg báŋ bwə́ á shígɛ́ mpu Yésus. Bwə́ á yida cɛ̧ɛ̧lə nyə shwɨy. Ntɔ́, bwə́ á sá nə́ iciyá í búúd ɔ mícúndə́ shé mə́ dʉ lɔ̧́ ósábaad bɛ̂sh dɨ́ yí í bwə́mag. ");
INSERT INTO mcp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tɛɛm bə nda bwə́ á shígɛ́ kwey nyə nə məbɛ̧ɛ̧́ nə́ a yə́g nə́, bâŋ bwə́ á cɨ nə Pilât nə́ a gwúg nyə. ");
INSERT INTO mcp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nə́mə́ njɨ bwə́ á shîn sá isâ byɛ̂sh í á bə cilyá Kálaad Zɛmbî dɨ́ shú dɛ́ dɨ́ yí, bwə́ á shul yîl nyə lɨ́ɨ́d bwə́ kə wá nyə shwóŋʉd. ");
INSERT INTO mcp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Njɨ, Zɛmbî nyə a gwûmʉshi nyə. ");
INSERT INTO mcp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nyə a lwóya nyúúl məlú məlú, buud bə́nɔ́ŋ bwə́ á zhu Galilê bád kə Yurʉ́səlɛm wá bwə́ á ŋgə dʉ́g nyə. Buud bɔɔŋg wə́ bwə́ músə́ owúshinɛd bɛ́ kúl búúd jɛ̂sh dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Jɔ̧jɔ̧ kɛ́ɛl dɔɔŋg nə́mə́ wə́ sə́ ŋgə́ bwiiŋg bɨ́ yí, ŋkaagə́ Zɛmbî nyə a kaag odâ yí. ");
INSERT INTO mcp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Zɛmbî nyə a sá nə́ ŋkaagə́ nyɔɔŋg í zə́g bwəma nə sə́ bwân gwúmʉ́shílə nyə á gwûmʉshi Yésus yí. Sâ jɔɔŋg wə́ jísə́ cilyá Sôm ábɛɛ̂ dɨ́ yí, nə́: “Wo jɨ mwân waamə́, mə mə́ byâ wo múús”. ");
INSERT INTO mcp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jɨ́ ntɔ́. Zɛmbî nyə a gwûmʉshi nyə ákandʉg, a kú ná bá kwo bwo. Ntɔ́ wə́ nyə á cɨ yɛ́, nə́: “Mə bá yə bɨ́ jɔ̧jɔ̧ ísâ mə á kaag Dávid yí, məŋkaagə́ mə́ cúgɛ́ nə ŋkul salan má”. ");
INSERT INTO mcp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gwə́ nə́mə́ wə́ á ŋgə́ báásʉlə gúl kʉ́kʉ́l cilyá dɨ́ nə́: “Wo abʉ́lɛ́ bɨ́d nə́ jɔ̧jɔ̧ sɔ́ɔl məsáal wô kə́g bwo shwóŋʉd”. ");
INSERT INTO mcp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dávid nywáá nyə a shí sá mítə́dʉ́gá mí Zɛmbî fwála dɛ́d. A mú yə, a dɔw nə osɔ́ɔ́ŋgʉ́ bɛ́, a bwo. ");
INSERT INTO mcp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Njɨ, nyɔɔŋg Zɛmbî nyə a gwûmʉshi yɛ́ nywáá nyə a shígɛ́ bwo. ");
INSERT INTO mcp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bwaaŋg bɨ mə́ jəlá nə mpu ntɔ́ nə́ nyə wə́ mə́ sá nə́ bɨ gwágʉ́g kɛ́ɛl ijuugá í *mísə́m mín. Məcɛ̧ɛ̧ mə́ Moyîz bɨ́ á dʉ bɛ̧ má mə́ á shígɛ́ sá nə́ bɨ ŋgə́g nə bə otʉ́təlî. ");
INSERT INTO mcp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Njɨ Yésus wə́ jísə́ nə́ muud yɛ̂sh mə́ búgʉ́lá nyə yɛ́, a bə tʉ́təlí ncindî nə ncindî. ");
INSERT INTO mcp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bɨ ɔ́ bɛy nə́ sâ búúd ɔ mícúndə́ bwə́ á cɨ yí, í bwə́mag nə bɨ̂. Bwə́ á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Bɨ́ buud ɔ mpyóŋ, dʉgá, káámʉ́gâ, bɨ jímbʉ́g! Nəcé, té bɨ́ ŋgə́ ná dʉ́gya yí, mə zə́ bá sá gúl sâ bɨ ŋgə́ dʉ́g, sâ jɨ́ nə́ ŋkí bɨ mə gwág njɨ lâŋ bɨ́ kú *magʉlə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ja Pwôl bá Barnábas bwə́ á cúwo tɔ́ɔ́n yí, búúd bwə́ á jəgʉla nə bwo nə́ bwə́ bâg kwo zə bwiiŋg bwo lâŋ ŋgwúd nɨ Sábaad mə bá bɛ̧ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ja buud bwə́ á bwɨ́lya yí, fwámɛ́ bímbí lʉ́ *Oyúdɛn nə bɔ́ɔ́l búúd bwə́ á wá milâm mísɔɔn wáŋ dɨ́ wá bwə́ á bɛ̧ Pwôl bá Barnábas bə́nɔ̂ŋ kə ŋgə lésha. Pwôl bá Barnábas bwə́ mú ŋgə wá bwo ŋkul mílámʉ́d nə́ bwə́ wág icʉg byáŋ mpaam mə́ Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sábaad nyə á bɛ̧ yɛ́, buud bwə́ á zə sɛɛŋgya je bə buud ɔ ŋgwə́la bɛ̂sh nə́ bwə́ zə́ gwágʉlə kɛ́ɛl mə Cwámba. ");
INSERT INTO mcp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nda bɔ́ɔ́l Oyúdɛn bwə́ á dʉ́g bímbí lʉ́ ncúlyá buud bɔɔŋg nə́, bwə́ á ka zə mpii Pwôl bá Barnábas váál áwuwagʉwə̂, bwə́ mú ŋgə shwána bwo, ŋgə lwîy bwo. ");
INSERT INTO mcp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pwôl bá Barnábas bwə́ mú mpu jaaw bwo kú nə ifwaas nə́: «Í á jəla nə́ bɨ wə́ tɛ́ɛ́dʉ́g gwág Milə́sʉ́ mí Zɛmbî. Nda bɨ́ bâŋ mə́ ka ban myo nə́, bɨ mə́ lwágʉlə nə́ bɨ ampíyáyɛ́ nə cʉg á kandʉgə kandʉgə. Ntɔ́, sə́ bâŋ mə zə́ lésha nə ikúl í cúgɛ́ Oyúdɛn yí. ");
INSERT INTO mcp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nəcé Cwámba nyə á cɨ nə sə́ nə́: “Mə mə́ tə́l wo nə́ wo bə́g məŋkɛnya mâ ilwoŋ, nə́ wo kə́g nə cʉg kə wɔ́ɔ́s íjumə í shíd”.» ");
INSERT INTO mcp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Njɨ ikûl ishús í á gwág ntʉ́nɨ yí, bwə́ á bul bə nə məshusʉg bwə́ ŋgə́ ságʉsə kɛ́ɛl mə Cwámba. Bɔɔŋg bwə́ á bə fééshá nə́ bwə́ dʉ́gʉ́g cʉg á kandʉgə kandʉgə wá bwə́ mú bə óbúgʉla. ");
INSERT INTO mcp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kɛ́ɛl mə Cwámba í á kyey lɔɔm wɔɔŋg wɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Oyúdɛn bwə́ á ka shwambʉlə fwámɛ́ búdá ɔ́ lɔɔm bwə́ á dʉ gwɔ̧́ɔ̧ Zɛmbî wá. Bwə́ mú zə lwágʉlə Pwôl bá Barnábas cúwʉ́lí nə́ ndɛɛ́ bwə́ wáámb bwo kə ntɔ̧ mínjɨ mí shí nyáŋ. ");
INSERT INTO mcp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pwôl bá Barnábas bwə́ mú kudə fumbyá mə́kuú máŋʉ́d shú dáŋ, báá bwə́ mú kə Ikóniyum. ");
INSERT INTO mcp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","*Ompwíín bwə́ mú lʉ́g lwándʉ́lá nə məshusʉg nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́ cwɔ́ɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Í á ka bə, ja bwə́ á wɔ́ɔ́s Ikóniyum yí, Pwôl bá Barnábas bwə́ á kə mpáánzə́ minjɨ́ɨ́gʉ́lá. Bwə́ á kə lésha nə buud mbií á nə́ *Oyúdɛn nə Ogʉrɛ̂k ŋkí bul bulya bwə́ *magʉlə búgə́. ");
INSERT INTO mcp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bɔɔŋg Oyúdɛn bwə́ á shígɛ́ magʉlə búgə́ wá, bwə́ mú zə sá nə́ ikúl í cúgɛ́ Oyúdɛn yí bwə́ shíŋʉ́g obúgʉla. ");
INSERT INTO mcp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Njɨ, Pwôl bá Barnábas bâŋ bwə́ á ji cínɔŋgʉ́ fwámɛ́ mwɔ̂w, bwə́ ŋgə lás kú nə ifwaas. Bwə́ á ŋgə bul ŋwa ŋkul wə́ Cwámba. Cwámba ŋgə́ nə́mə́ magʉlə kɛ́ɛl bwə́ á ŋgə bwiiŋg yí, a ŋgə yə bwo ŋkul, bwə́ ŋgə sá *isâ í ntɔ̧́ búúd ŋkwóŋ yí, nə *ísâ í mímbʉ́gú. ");
INSERT INTO mcp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Buud ɔ ŋgwə́la bwə́ mú béégya ígwooŋg íbá, gúl í ŋgə́ bɛ̧ ishwambʉlə í Oyúdɛn, gúl í ŋgə magʉlə *buud ɔ lwámá. ");
INSERT INTO mcp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nə Oyúdɛn, nə bɔ́ɔ́l búúd bwə́ cúgɛ́ Oyúdɛn wá, nə otɔ́we ɔ shwóg báŋ bwə́ mú zə sá yuug nə́ bwə́ jugʉshi búúd ɔ lwámá, bwə́ lúmə bwo məkwóógʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nda búúd ɔ lwámá bwə́ á mpu yuug jɔɔŋg nə́, bwə́ mú túb kə Lístrə nə Dɛ́rbə, miŋgwə́la myâ Likawʉní, nə cínɔŋg mə́koogʉ́ məkoogʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bwə́ mú kə ŋgə bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛ́l wu. ");
INSERT INTO mcp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ŋgwɔ́l múúd nyə á bə nûŋ Lístrə kú bwɛlɛ tɔ̂w tʉ́təlí nə məkuú mɛ́. Nyə a byɛ̂l mbúmbwúgʉ́, nyə a shígɛ́ bwɛlɛ kyey. ");
INSERT INTO mcp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Dúl jwɔ̂w, muud wɔɔŋg nyə á ka ŋgə gwágʉlə nda Pwôl nyə á ŋgə lás nə́. Pwôl mú dʉ́g nyə nə́ figə́-figə́, a mú dʉ́g nə́ muud ɛ́nɛ jɨ nə búgə́ nə a jɨ nə ŋkul yâl. ");
INSERT INTO mcp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pwôl mú cɨ nə nɛ́ gwɔ́w-gwɔ̂w nə́: «Tɔ́wʉ́g tʉ́təlí nə məkuú mwô». Muud ɛ́nɛ mú sáánz, a mú tɛ́ɛ́d ŋgə́lə kyey. ");
INSERT INTO mcp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Buud bwə́ á bə cínɔŋg wá bwə́ mú dʉ́g sâ Pwôl mə́ sá yí. Bwə́ mú ŋgə lás gwɔ́w-gwɔ̂w kə́l lʉ́ Likawʉní dáŋʉ́d nə́: «Ozɛmbî bwə́ mə́ bə nda buud nə́ ndɛɛ́ bwə́ mə́ shulə zə sə́dɨ́». ");
INSERT INTO mcp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bwə́ mú ŋgə jɔ̂w Barnábas nə́ Zə́s, Pwôl nyɛ nə́ Hɛrmɛs nəcé nyə wə́ nyə á dʉ bə nə ciyá lə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Buud bwə́ á dʉ *búgʉla Zə́s wá bwə́ á dʉ bə nə mpáánzə́ ŋgɛɛ́ nyíŋgʉ́lé ŋgwə́la dɨ̂. Fada á yə́bə́ wɔɔŋgʉ́ músə ŋwa míŋgwûm mí ntɛny nə ikəlʉgʉ́-kə́lʉg í dʉ lugʉshi də́nd lʉ́ zâŋ yí, bə́nɔ̂ŋ buud bwə́ mú zə kə ŋgɛɛ nyíŋgʉ́lé ŋgwə́la. Bwə́ á cɛɛl kə cígə intɛny nə́ bwə́ sâ Pwôl bá Barnábas *mətúnʉga nda ozɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ja *búúd ɔ lwámá, Barnábas bá Pwôl bwə́ mə́ gwág ntɔ́ yí, bwə́ mú nyaa míkáándə́, bwə́ mú sáánz kə nə oŋkwiimbyê tâm buud, ");
INSERT INTO mcp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","bwə́ nə́: «Buud ɔ́ga, jáyɛ́ nɨ? Sə́ bʉ́sə nə́mə́ búúd nda bɨ̂. Sə́ ŋgə yida bwiiŋg bɨ́ Jɔ̧jɔ̧ Kɛ́ɛ́l nə́ bɨ bɨ́dʉ́g isâ í íkás ínɨ, bɨ cɛ́ndʉ́g kuú njɔɔnd yid wə́ Zɛmbî á kuwô. Nyə wə́ nyə a tɛ́ gwɔ̂w nə shí, nə mâŋ nə isâ byɛ̂sh bísə́ cínɔŋg yí. ");
INSERT INTO mcp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nyə á ka yida bɨ́d tɛ́ zhúlə yág nə́ ilwoŋ i búúd byɛ̂sh í ŋgə́g nə bɛ̧ byáŋ ijâm nə ijag, ");
INSERT INTO mcp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","njɨ nyɛ kú bɨ́d ŋgə́lə lwágʉlə nə́ a jisə, a ŋgə́ nə́mə́ sá bwo mpaam. Ntɔ́ nə́mə́ wə́ á ŋgə́ ntɨ bɨ́ ompú bwə́ ŋgə́ zhu gwɔ́w yɛ́, a ŋgə́ yə bɨ̂ məfwála mə́mpəg mə́ jə́la nə bugʉban yí, a yə bɨ́ zhwog idʉ̂w, a lwándʉlə bɨ́ məshusʉg mílámʉ́d». ");
INSERT INTO mcp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Njɨ, bwə́ á tɛɛm lás nə buud ɔ́nɨ ntʉ́nɨ, buud ɔ́nɨ bwə́ á shígɛ́ lɛɛl magʉlə nə́ bwə́ bɨ́d sálə bwo *mətúnʉga. ");
INSERT INTO mcp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bɔ́ɔ́l *Oyúdɛn bwə́ mú zə wɔ́ɔ́s bwə́ ŋgə́ zhu Antyósh nə Ikóniyum. Bwə́ mú zə kwambʉlə nə buud nə́ ndɛɛ́ bwə́ mú lúmə Pwôl məkwóógʉ́ nə́ lúmə lúmə, bwə́ julə nyə shí nə shí nə́ ndɛɛ́ kə wusə bugád. Bwə́ á tə́dʉga nə́ a mə́ yə. ");
INSERT INTO mcp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Njɨ, *ompwíín bwə́ mú kə lyɛ̧ nyə. Pwôl mú wɔɔl, a mú nyiŋgə kə ŋgwə́la. Mán mələ̂m, a músə kyey kə Dɛ́rbə, bá Barnábas. ");
INSERT INTO mcp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bwə́ mú kə bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛ́l nûŋ Dɛ́rbə nə́ ndɛɛ́ bwə́ mú bə nə ompwíín fwámɛ́ bímbí. Bwə́ músə nyiŋgə kə Lístrə, cɔ̧́ kə Ikóniyum kə wɔ́ɔ́s Antyósh. ");
INSERT INTO mcp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bwə́ á ŋgə wá ompwíín ŋkul mílámʉ́d, bwə́ ŋgə́ cwîny bwo nə́ bwə́ sáág zɛ́ny búgə́. Bwə́ á ŋgə lwágʉlə bwo nə́ bwə́ mpúg nə́: «Sə́ mə́ jəlá nə ŋgə bwəma nə *incwaw í ntʉg, sə́ ŋgə́ ntɔ̧ ŋgə ntɔ̧ ŋgə ntɔ̧ nə́ ndɛɛ́ sə́ mú ka nyíi Faan mə́ Zɛmbî dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bwə́ á ŋgə sá nə́, *Dɔ̧ lʉ́ óbúgʉla dɛ̂sh dɨ́, bwə́ fɛ́ɛ́sh bwo ocúmbá buud, bwə́ ci idʉ̂w jəgʉla nə Zɛmbî, bwə́ mú ŋwa bwo cwámbʉlə Cwámba wáŋ bwə́ á *búgʉla yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bwə́ mú lɨ́ɨ́na Pisidî, kə kumə Pamʉfilî, ");
INSERT INTO mcp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","bwə́ bwiiŋg kɛ́ɛl mə́ Zɛmbî Pɛrzhe nə́ ndɛɛ́ bwə́ mú shulə kə Antalya. ");
INSERT INTO mcp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kǎlə wú Antalya, bwə́ mú ŋwa byɔ́ɔ́l kə Antyósh wú bwə́ á zhu ja mpaam mə́ Zɛmbî í á fɛ́ɛ́sh bwo nə́ bwə́ sáág sáal bwə́ mə́ sá yí. ");
INSERT INTO mcp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ja bwə́ á kə jé yí, bwə́ á sɛɛŋg *Dɔ̧ lʉ́ óbúgʉla, jaaw bwo sâ jɛ̂sh Zɛmbî nyə á yə bwo ŋkul nə́ bwə́ sáág yí, bul bə nə́ ndɛɛ́ nda Zɛmbî nyə a mə́ juw zhɨ́ɨ́ nə́ ikúl í cúgɛ́ *Oyúdɛn yí í mágʉləg búgə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bə́nɔ̂ŋ *ompwíín bwə́ mú ji na fwámɛ́ məma fwála. ");
INSERT INTO mcp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bɔ́ɔ́l búúd bwə́ á shulə wú Yudéa zə ŋgə jɨ́ɨ́gʉli obúgʉla nə́: «Ŋkí bɨ mə bə́ kú sɨ́ya ábɨwáág nda Cɛ̧ɛ̧ mə́ Moyîz í ŋgə́ cɨ nə́, bɨ́ cugɛ́ nə ŋkul *dʉ́g cʉg.» ");
INSERT INTO mcp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Buud bɔɔŋgʉ́ bə́nɔ̂ŋ Pwôl bá Barnábas bwə́ mú zə sɛ́ŋʉsa mə́kə̂l, í mú sá fwámɛ́ zhuyâ. Cígʉ́lá í mú zə bə nə́ Pwôl nə Barnábas, nə bɔ́ɔ́l óbúgʉla bwə́ kə́g nə lə́sʉ́ wɔɔŋg Yurʉ́səlɛm kə lwágʉlə *buud ɔ lwámá bə́nɔ̂ŋ ocúmbá buud. ");
INSERT INTO mcp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","*Dɔ̧ lʉ́ óbúgʉla í músə kənd bwo. Bwə́ mú lɨ́ɨ́na Fenisî nə Samaríya, bwə́ ŋgə́ bwiiŋg buud nda ikûl ishús í mə́ cɛ́nd mítə́dʉ́gá nə́. Sâ jɔɔŋg í mú ŋgə bul sá bɔ́ɔ́l óbúgʉla məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ja bwə́ mə́ kə jé Yurʉ́səlɛm yí, nə Dɔ̧ lʉ́ óbúgʉla, nə buud ɔ lwámá, nə ocúmbá buud, bɛ̂sh bwə́ mú lə́g bwo. Bâŋ bwə́ músə jaaw bwo bímbí dɛ̂sh Zɛmbî mə́ balan nə bwo sáal dɛ́ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bɔ́ɔ́l óbúgʉla bwə́ á bə ŋkɔɔmʉ́ *Ofarizyɛ̂ŋ dɨ́ wá bwə́ mú báásʉlə nə́ í jɨ nə́ ikûl í ŋgə́ cɛ́nd mítə́dʉ́gá yí í ŋgə́g nə sɨ́ya ábɨwáág, bwə́ bɛ̧ nə́mə́ Məcɛ̧ɛ̧ mə́ Moyîz. ");
INSERT INTO mcp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Buud ɔ lwámá nə ocúmbá buud bwə́ mú ka zə sɛɛŋgya, zə́lə faas lə́sʉ́ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Buud bwə́ mú nə́mə́ bul sɛ́ŋʉsa mə́kə̂l. Ntɔ́, Pyɛ̂r mú ka zə lás. Nyə nə́: «Bwaaŋg, bɨ mə́ bwey mpu nə́ Zɛmbî nyə a fɛ́ɛ́sh mə wa bɨ́dɨ́ mwɔ̂w mə́ ashúshwóógʉ́ dɨ́, a kənd mə nə́ mə kə́g bwiiŋg ikûl ishús Jɔ̧jɔ̧ Kɛ́ɛ́l, bwə́ búgʉ́lág. ");
INSERT INTO mcp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nyɛɛ muud mə mpú mílâm mí búúd yɛ́, nyə a lwágʉlə nə́ a mə́ magʉlə ikûl, a yə bwo Ŋkɛ̧́ŋkɛ̧̂ Shíshim nə́mə́ nda nyə á yə sə́ nə́. ");
INSERT INTO mcp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nyə a shígɛ́ wá mbɛ́ɛ́gí mpə́dʉ́gá sə́nɔ̂ŋ ikûl. Nyə a fúb nə́mə́ bwo milâm nəcé bwə́ bə́lə nə búgə́. ");
INSERT INTO mcp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nəcé jɨ́ bɨ́ é ka zə shweenzh Zɛmbî, zə zhimb *ómpwíín məma mbag wúsə́ nə́ tɔɔ impáámbə́ bísʉ́, tɔɔ sə́mɛ́fwó sə́ á shígɛ́ bə nə ŋkul mə jísɔw yí? ");
INSERT INTO mcp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Njɨ sə́ ŋgə *magʉlə nə́ sə́ mə́ dʉ́g cʉg mpáam mə Cwámba Yésus dɨ́, ntɔ́ nə́mə́ wə́ jɨ́ nə ikûl yɛ́.» ");
INSERT INTO mcp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Buud bɛ̂sh bwə́ mú ji ókʉ́l-ókʉ̂l, ka gwágʉlə Barnábas bá Pwôl, gwágʉlə nda Zɛmbî nyə á balan nə bwo, *isâ í ntɔ̧́ búúd ŋkwóŋ yí nə *isâ í mímbʉ́gú í ŋgə́ sɨ̂y ikûl ishús dɨ́ nə́. ");
INSERT INTO mcp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ja bwə́ mə́ shîn bwiiŋg yí, Zhâk mú ka zə lás, nyə nə́: «Bwaaŋg, bɨ ɔ gwágʉ́lə́ mə. ");
INSERT INTO mcp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Shímun mə́ kúnɔw shîn jaaw sə́ nda Zɛmbî nyə a sá nə́: nə́ nyə á kənd mísh íkûl ishúsʉ́d kə fɛ́ɛ́sh búúd bwə́ ŋgə́ bɛ̧ jínə́ dɛ́ cínɔŋg wá. ");
INSERT INTO mcp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Sɔ́ɔ́lʉ́gʉ́ wɔɔŋg í bwəma nə sâ *búúd ɔ mícúndə́ bwə́ á cɨ yí. Nəcé jísə cilyá Kálaad Zɛmbî dɨ́ nə́: ");
INSERT INTO mcp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mpʉ́sə isâ ínɨ, mə bá kwo zə lwɔ̧́ banda mə *Dávid. Mə bá sɛɛŋg íbúgʉ́lə yâ cínɔŋg nə́ ndɛɛ́ mə kwo tə̂l banda dɔɔŋg tʉ́təlî. ");
INSERT INTO mcp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ja jɔɔŋgʉ̂, buud bɛ̂sh bwə́ bá sɔ̧́ Cwámba. Haaw, buud ɔ ílwoŋ byɛ̂sh mə á jɔ̂w nə́ í bɛ̧́g jínə́ dâm yí. Ntɔ́ wə́ Cwámba nyə á cɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A mə́ sá íyuug byé sə́ mə́ bwey mpu wúlə yág yí. ");
INSERT INTO mcp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Sâ jɔɔŋg wə́ mɛ́ mə dʉ́g nə́, ilwoŋ í búúd í ŋgə́ cɛ́nd kuú njɔɔnd ŋgə yid wə́ Zɛmbî yí, sə́ ajə́láyɛ́ nə wá bwo məkwowʉla cʉgʉd. ");
INSERT INTO mcp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Njɨ, sə́ cíləg bwo nə́ bwə́ sásʉ́lə́g məlwaagʉwo mə́ ózɛmbî ɔ́ áyadʉ́g, nə məlwaagʉwo mâ jaŋgálə múúd bɨná kú nə bâ, nə məlwaagʉwo mâ də́lə cúdú nyə ámə yə məcií kú shwɨy yɛ́, nə də́lə mə́cií. ");
INSERT INTO mcp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sə́ mə́ mpú nə́ tɛ́ɛ́d íkala i búúd í ayág óbwiiŋgyɛ ɔ lâŋ ɔ́ Moyîz bʉ́sə míŋgwə́la myɛ́shʉd. Mwɔ̂w mə Sábaad mɛ̂sh dɨ́, bwə́ lɔ̧́ mícilyá myɛ́ *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mɛ̂shʉd.» ");
INSERT INTO mcp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ntɔ́, nə buud ɔ lwámá, nə ocúmbá buud, nə Dɔ̧ lʉ́ óbúgʉla dɛ̂sh bwə́ mú dʉ́g nə́ bwə́ jəlá nə fɛ́ɛ́sh bɔ́ɔ́l búúd bə́nɔ̂ŋ Pwôl nə Barnábas bwə́ kə́g Antyósh. Bwə́ músə kənd bɔ́ɔ́l fwámɛ́ búúd wâ Dɔ̧: nə Yûdə bwə́ á dʉ nə́mə́ jɔ̂w nə Barnábas yɛ́, nə Sílas. ");
INSERT INTO mcp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bwə́ mú kənd bwo nə kálaad ɛ́ga nə́: Sə́, buud ɔ lwámá nə ocúmbá buud nə bɔ́ɔ́l óbúgʉla bɛ̂sh, sə́ mə́ bə́da bɨ́ obúgʉla bɨ́ cúgɛ́ Oyúdɛn wá, bɨ́ bɔɔŋg bʉ́sə́ Antyósh nə Sirî nə Silisî wá. ");
INSERT INTO mcp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sə́ mə́ gwág kʉ́ga nə́ bɔ́ɔ́l búúd bʉ́sʉ́ bwə́ á zə nə minjɨ́ɨ́gʉ́lá myáŋ nûŋ bɨ́dɨ́ zə sá nə́ mitə́dʉ́gá mí búbúlə́g bɨ́ mílámʉ́d. Sə́ dɨ́ sə́ á ntɨ bwo. ");
INSERT INTO mcp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gwə́ wə́ sə́ bɛ̂sh sə́ ámə bə cʉ́ŋ nə́ sə́ mə́ fɛ́ɛ́sh búúd bwə́ zə́g nûŋ bɨ́dɨ́, bə́nɔ̂ŋ Barnábas bá Pwôl omínyɔŋʉ̂ bʉ́sʉ́ wâ cɛɛlí, ");
INSERT INTO mcp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","buud bwə́ á mə́ kɛɛnzh ícʉg byáŋ shú jínə́ mə́ Cwámba wúsʉ́ Yésus-Krîst wá. ");
INSERT INTO mcp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Sə́ mə́ ka ntɨ bɨ́ Yûdə bá Sílas nə́ bwə́ zə́g báásʉlə jaaw bɨ́ sâ sə́ ŋgə cilə ga. ");
INSERT INTO mcp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nə Ŋkɛ̧́ŋkɛ̧̂ Shíshim, nə sə́, sə́ mə́ dʉ́g nə́ sə́ ajə́láyɛ́ nə zhimb bɨ́ wúl mbag, sə́ mə́ cilə bɨ́ njɨ isâ bɨ́ cúgɛ́ nə ŋkul kwanz yí: ");
INSERT INTO mcp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","bɨ mə́ jəlá nə sásʉlə ocúdú buud bwə́ ámə cígə shú ózɛmbî ɔ́ áyadʉ́g wá, bɨ kú dʉ də mə́cií, kú də cúdú nyə ámə yə məcií kú shwɨy yɛ́, bɨ́ kú dʉ sá jaŋga. Bɨ mə́ ká dʉ sásʉlə ísâ ínɨ́, í bə bɨ́ mpwogɛ́. Bɨ ɔ́ ji nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yûdə bá Sílas bə́nɔ̂ŋ Pwôl nə Barnábas bwə́ mú béégya nə obúgʉla, bwə́ mú shulə kə Antyósh. Bwə́ mú kə sɛɛŋg óbúgʉla, yə bwo kálaad. ");
INSERT INTO mcp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bwə́ mú lɔ̧́ kálaad nə́ ndɛɛ́ a mú wá bwo ŋkul mílámʉ́d, bɛ̂sh bwə́ mú bul bə nə məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nda Yûdə bá Sílas bwə́ á bə *buud ɔ mícúndə́ nə́, bwə́ á ka nə́mə́ kwo dʉ lésha nə obúgʉla, dʉ cwîny bwo, dʉ wá bwo ŋkul mílámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bwə́ á ji cínɔŋgʉ́ fwámɛ́ fwála nə́ ndɛɛ́ obúgʉla bwə́ mú jə́na nə bwo nə́ bwə́ nyíŋgəg nə́ shɛɛ kə kwey búúd bwə́ á ntɨ bwo wá. ");
INSERT INTO mcp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Njɨ Sílas mú kwey nə́ nyə anyíŋgə́yɛ́, nyɛ mə́ ji wu. ");
INSERT INTO mcp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pwôl bá bâŋ Barnábas bwə́ á jɨ nə́mə́ cínɔŋg Antyósh. Bə́nɔ̂ŋ bɔ́ɔ́l óbúgʉla bwə́ ŋgə́ yə buud minjɨ́ɨ́gʉ́lá, bwə́ ŋgə́ bwiiŋg jɔ̧jɔ̧ lâŋ á kɛ́ɛl mə Cwámba. ");
INSERT INTO mcp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mpʉ́sə baalɛ́ mwɔ̂w, Pwôl mú cɨ nə Barnábas nə́: «Shwə́ nyíŋgəg ná kə ŋgə dʉ́g omínyɔŋʉ̂ bʉ́sʉ́ míŋgwə́la myɛ̂sh shwə́ á bwiiŋg kɛ́ɛl mə Cwámba myá. Í jɨɨ nə́ shwə́ mpúg nda bwə́ mú ŋgə bə nə́.» ");
INSERT INTO mcp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnábas nyə á ka nə́mə́ jɨɨ nə́ bwə́ kə́g nə Yuánɛs nyə á bə nə dúl jínə́ nə́ Márkus yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pwôl nyɛ mú dʉ́g nə́ bwə́ ajə́láyɛ́ nə kwo kə nə muud nyə á fwo kə mpáŋgʉlə bwo nə isɛ́y, kə béégya nə bwo Pamʉfilî yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bwə́ mú sɛ́ŋʉsa mə́kə̂l nə́ ndɛɛ́ bwə́ mú béégya. Barnábas mú ŋwa Márkus, báá bwə́ mú ŋwa byɔ́ɔ́l kə Shíprə. ");
INSERT INTO mcp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pwôl nyɛ mú fɛ́ɛ́sh Sílas nə́ bá bwə́ kə. Obúgʉla bwə́ mú jɔ̂w Cwámba nə́ a jáándʉg nə bwo mpáam nyɛ́d. ");
INSERT INTO mcp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pwôl mú jaand Sirî nə Silisî, a ŋgə́ wá mədɔ̧ mə́ óbúgʉla ŋkul mílámʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A mú kə wɔ́ɔ́s Dɛ́rbə, kumə Lístrə. A mú kə kwey ŋgwɔ́l *mpwíín nûŋ nə jínə́ nə́ Timotê. Timotê wɔɔŋgʉ̂ nyɔɔŋgʉ́ njúl shilə *Yúdɛn mbúgʉla Yésus, sɔ́ɔ́ŋgʉ́ nyɛ njúl mwâ Gʉrɛ̂k. ");
INSERT INTO mcp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Obúgʉla wâ Lístrə nə Ikóniyum bwə́ á ŋgə bwiiŋg lâŋ mə́ Timotê nə a jɨ jɔ̧ múúd. ");
INSERT INTO mcp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pwôl nyə á ka cɛɛl nə́ bá bwə́ kə̂. A mú ŋwa nyə, a sá nyə ábɨwáág nəcé ŋgə́lə bɛɛmb *Oyúdɛn wâ shí nyɔɔŋg nəcé nda bwə́ á bwey mpu nə́ sɔ́ɔ́ŋgʉ́ jisə mwâ Gʉrɛ̂k nə́. ");
INSERT INTO mcp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Míŋgwə́la myɛ̂sh bwə́ á ŋgə kə myá, bwə́ á ŋgə kala obúgʉla micígʉ́lá *búúd ɔ lwámá nə ocúmbá buud wâ Yurʉ́səlɛm bwə́ á ŋwa myá, bwə́ ŋgə́ tə̂l obúgʉla məkuú shí nə́ bwə́ bɛ̧́g micígʉ́lá myɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mədɔ̧ mə́ óbúgʉla mə́ mú ŋgə lal, buud bwə́ ŋgə́ kwɨ́dʉli jwɔ̂w dɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pwôl nə gwooŋg jé bwə́ mú lɨ́ɨ́na Frizhî nə shí á Galátia lɨ́ɨ́na lɨ́ɨ́nág nəcé Ŋkɛ̧́ŋkɛ̧̂ Shíshim nyə a shígɛ́ magʉlə nə́ bwə́ bwííŋgʉg kɛ́ɛl Azî. ");
INSERT INTO mcp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ja bwə́ mə́ kə wɔ́ɔ́s íjumə í Mishî yí, bwə́ mú ŋwá kə Bitinî, njɨ Shíshim mə́ Yésus kú magʉlə. ");
INSERT INTO mcp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bwə́ mú ka lɨ́ɨ́na Mishî nə́ ndɛɛ́ kə wɔ́ɔ́s Truwás. ");
INSERT INTO mcp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Gúl búlú dɨ́, Pwôl mú dʉ́g *ntamə́ á mísh nə́ bagə́, ŋgwɔ́l múúd Masedwân tə́l ŋgə́ tɛ́ɛ́g nyə məbwə̂ nə́: «Zaá Masedwân, zə kwíínd sə̂.» ");
INSERT INTO mcp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nda nyə á dʉ́g ntɔ́ nə́, sə́ á shwal zə sɔ̧́ nə́ sə́ mə́ kə́ Masedwân, sə́ ŋgə́ mpu bʉ́bə́lɛ́ nə́ Zɛmbî ŋgə jɔ̂w sə́ wu nə́ sə́ kə́g bwiiŋg kɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Sə́ mú ŋwa byɔ́ɔ́l Truwás, sə́ kə nə́ tɨ́ɨ́ŋ kə wɔ́ɔ́s Samotʉras. Mán mələ̂m sə́ ɔ́ kumə Neyapolis. ");
INSERT INTO mcp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tɨ́lə cínɔŋgʉ́ sə́ mú kə Filipî, ŋgwə́la ashúshwóógʉ́ á mpál shí Masedwân. Filipî wɔɔŋgʉ̂ njúl ŋgwə́la ózhul ɔ Róma, sə́ mú ji cínɔŋgʉ́ baalɛ́ mwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jwɔ̂w lʉ́ Sábaad sə́ mú cúwo wú ŋgwə́la, kə bwûŋ lʉ́ ŋgwɔ̧ɔ̧́, wú sə́ á tə́dʉga nə́ bwə́ á kwambʉlə ŋkúmba kʉ̂l shú mə́jəgʉla wá. Sə́ á ka bə sə́ njúl nûŋ, sə́ ŋgə́ lésha nə budá bwə́ á sɛɛŋgya cínɔŋg wá. ");
INSERT INTO mcp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ŋgwɔ́l múdá nə jínə́ nə́ Lidiya nyə á zhu ŋgwə́la á Tiyatîr, nyə á dʉ kusha ijimə́ í míkáándə́ mí atɨ́tɨɨ̂; mudá wɔɔŋgʉ́ nyə á dʉ gwɔ̧́ɔ̧ Zɛmbî. A mú dʉ gwágʉlə Pwôl nə́ ndɛɛ́ Cwámba mú bɛ̂ny nyə lâm nə́ a mágʉləg lə́sʉ́ mə́ Pwôl. ");
INSERT INTO mcp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ja múdá ɛ́nɛ nyə á ka duwan nə buud ɔ njɔ́w bɛ́ bɛ̂sh yí, nyə a tɛ́ɛ́g sə̂ məbwə̂ nə́: «Ŋkí bɨ mə́ kwey nə́ mə jɨ mbúgʉla mə Cwámba, zəgá ji mə́dɨ́ njɔ́w.» A mú yɨ́ɨ́mbʉli sə́ nə́ sə́ mágʉləg. ");
INSERT INTO mcp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Í á ka zə bə, dúl jwɔ̂w sə́ ŋgə́ kə kʉ́l sə́ á dʉ jəgʉla yí, dúl sás mú zə bwəma nə sə̂. Sás dɔɔŋg í á dʉ sá ísɛ́y í mə́lwaá. Nyə á bə nə jamb lʉ́ lweendí, lweendí jɔɔŋg dʉ́gə́ yə buud bwə́ á bə nə nyə wá zhwog məbii. ");
INSERT INTO mcp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Sás dɔɔŋg mú zə ŋgə bɛ̧ Pwôl, a ŋgə́ kɨ̂m gwɔ́w-gwɔ̂w nə́: «Buud ɔ́ga bʉ́sə osɔ́ɔl ɔ mə́sáal ɔ́ Zɛmbî á gwɔ́w-gwɔ̂w. Bwə́ ŋgə jaaw bɨ́ zhɨɨ́ á cʉg.» ");
INSERT INTO mcp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nyə á ka nə́mə́ dʉ sá ntʉ́nɨ mwɔ̂w ŋkí bulya nə́ ndɛɛ́ Pwôl mú lwádʉga nyə, a mú yid dʉ́g nyə mpʉ́sə, a mú lás nə jamb nə́: «Jínə́ mə́ Yésus-Krîst dɨ̂, mə yɨ́ɨ́mbʉli wo nə́ wo wúg múdá ɛ́nɛ dɨ́!» Shíshim músə nə́mə́ cúwo cé nə cé. ");
INSERT INTO mcp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nda búúd bwə́ á bə nə nyə wá bwə́ á dʉ́g nə́ búgə́ jáŋ bwə́ dʉ bə nə məbii yí í mə jímb nə́, bwə́ mú bii Pwôl bá Sílas, wádʉgə kə nə bwo ósémbye ɔ́ mílə́sʉ́ dɨ́ wú buud bwə́ á dʉ sɛɛŋgya tâm də́nd wá. ");
INSERT INTO mcp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bwə́ mú kə lwóya bwo ótɔ́we ɔ shwóg dɨ́, kə shwə́man bwo nə́: «Buud ɔ́ga bwə́ mə́ tə̂l sə́ ŋgwə́la nə́ shwuu. Bâŋ bwə́ njúl *Oyúdɛn, ");
INSERT INTO mcp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","bwə́ ŋgə zə jɨ́ɨ́gʉli buud məfúlú mə́ ajə́láyɛ́ nə́ sə́ buud ɔ Róma sə́ bwɛ́lɛ́g magʉlə má.» ");
INSERT INTO mcp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Buud bwə́ á bə cínɔŋg áncuncuma wá bɛ̂sh bwə́ mú shwal mpii bwo. Otɔ́we ɔ shwóg bwə́ mú tɨ́ bwo mikáándə́, bwə́ lwâm buud nə́ bwə́ yídʉ́g bwo nə milwóŋ. ");
INSERT INTO mcp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bwə́ mú daŋgʉlə cú bwo na nə́ ndɛɛ́ bwə́ kə wusə bwo njɔ́w mímbwug, bwə́ nə mása á njɔ́w mímbwug nə́: «Wo ɔ mpú ŋgə baagʉsə sə́ buud ɔ́ga». ");
INSERT INTO mcp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Njɨ mása á njɔ́w mímbwug nyə á gwág ntʉ́nɨ yí, a kə ntâg fad bwo kʉ́l fúm dɨ́ cwû, a wá bwo mimbwagə́ mə́kuúd. ");
INSERT INTO mcp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ŋgɛɛ́ tâm bulú, Pwôl bá Sílas bwə́ mú ŋgə jəgʉla nə Zɛmbî bwə́ ŋgə́ sɛy isʉsa gúmálə́lə Zɛmbî. Bwə́ á ŋgə sá ntɔ́ míl mímbwug myɛ̂sh mí ŋgə́ gwágʉlə bwo. ");
INSERT INTO mcp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Seegya nə́ shí í mú jág ntaŋʉsa mbií á nə́ mənyuŋg mə njɔ́w mímbwug mə́ ŋgə shwágʉsa mə́shugʉd. Mimpumbɛ́ myɛ̂sh mí mú nə́mə́ lɛɛl shîn juw, mimbwug myɛ̂sh məŋkəda shîn sémb. ");
INSERT INTO mcp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mása á njɔ́w mímbwug músə juum. A mú dʉ́g mímpumbɛ́ nə́ bagə́, a mú ntâg wéem kafwɛlɛ nə́ a gwɨ́ɨ́lyá nyúul, a ŋgə́ tə́dʉga nə́ mimbwug mí mə́ shîn túb. ");
INSERT INTO mcp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pwôl músə ka kɨ̂m nə ŋkulû nə́: «Kú sá wómɛ́fwó məbɔ̂w. Sə́ bɛ̂sh sə́ bʉ́sə wa.» ");
INSERT INTO mcp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mása á njɔ́w mímbwug mú jɔ̂w buud nə́ bwə́ zə́g nyə nə məlámba. A mú ŋgə lilya, a mú fwágʉwa kə, kə bʉ́la Pwôl bá Sílas shí məkuú, ");
INSERT INTO mcp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","a mú ŋwa bwo kə nə bwo tɔ́ɔ́n kə jî bwo nə́: «Omása e, mə sáág jɨ́ shú nə́ mə dʉ́gʉ́g cʉg?» ");
INSERT INTO mcp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bwə́ mú bɛ̧sa nə nyə nə́: «Búgʉ́lág Cwámba Yésus, wo bâg *dʉ́g cʉg, nə womɛ́fwó nə njɔ́w wô wɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bwə́ mú bwiiŋg bwo kɛ́ɛl mə Cwámba, nə nyə nə buud ɔ njɔ́w bɛ́ bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nə́mə́ wəla dɔɔŋgʉ́, tâm bulú, mása á njɔ́w mímbwug mú kə nə bwo kə gusa bwo məfə́ŋ nə́ ndɛɛ́, nə nyə nə buud ɔ njɔ́w bɛ́ bɛ̂sh bwə́ mú duwan. ");
INSERT INTO mcp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A mú kə nə bwo nyə́dɨ́ njɔ́w kə yə bwo idʉ̂w. Nə nyə nə njɔ́w yé wɛ̂sh bwə́ mú kɔɔs nə məshusʉg nəcé bwə́ búgʉ́lálə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ja mán í á lə̂m yí, otɔ́we ɔ shwóg bwə́ á ka kənd ifulísh kə cɨ nə mása á njɔ́w mímbwug nə́: «bɨ́dʉ́g búúd ɔ́nɨ bwə́ kə́g.» ");
INSERT INTO mcp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A mú kə jaaw Pwôl nə́: «Otɔ́we ɔ shwóg bwə́ mə́ ntɨ búúd zə cɨ nə mə nə́ mə bɨ́dʉ́g bɨ́, bɨ kyéyʉg. Ntɔ́, bɨ báá, cúwógá tɔ́ɔ́n bɨ kə́g nə́ shɛɛ.» ");
INSERT INTO mcp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Na wə́ Pwôl mə cɨ́ nə bwo nə́: «Bwə́ ámə yíd sə́ tâm buud kú nə́mə́ jî sə́ kɔɔd, í njúl nə́ sə́ bʉ́sə buud ɔ Róma. Bwə́ mú wusə sə́ mímbwugʉd. Ja gaád bwə́ cɛɛl zə bɨ́d sə́ nyima buud kú mpu. Mbɔ̂! Í ábəyɛ́ ntɔ́! Bwə́mɛ́fwó bwə́ zə́g bɨ́d sə̂!» ");
INSERT INTO mcp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ifulísh í mú kə jaaw ótɔ́we ɔ shwóg iciyá ínɨ byɛ̂sh. Bwə́ mú bul bə nə ifwaas nə gwágʉlə nə́ buud bɔɔŋg bʉ́sə buud ɔ Róma. ");
INSERT INTO mcp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bwə́mɛ́fwó bwə́ mú kə cweel bwo milâm, wééshʉli bwo tɔ́ɔ́n, bwə́ mú jəgʉla nə bwo nə́ bwə́ kyéyʉg wú ŋgwə́la wɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pwôl bá Sílas bwə́ mú wú njɔ́w mímbwug bwə́ mú kə Lidiya dɨ́ njɔ́w. Bwə́ mú dʉ cwîny óbúgʉla nə́ ndɛɛ́ bwə́ músə kyey. ");
INSERT INTO mcp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bwə́ mú lɨ́ɨ́na Amfípolis nə Apoloniya, bwə́ kə wɔ́ɔ́s Tesaloníka wú *Oyúdɛn bwə́ á bə nə *mpáánzə́ minjɨ́ɨ́gʉ́lá wá. ");
INSERT INTO mcp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pwôl mú kə bwəma nə Oyúdɛn bɔɔŋgʉ́ nə́mə́ nda nyə á dʉ bwey sá nə́. Bə́nɔ́ŋ bwə́ mú ji mwɔ̂w mə́ Sábaad məlɔ́ɔl, a ŋgə́ lésha nə bwo, ");
INSERT INTO mcp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ŋgə jɨ́ɨ́gʉli bwo nda mícilyá mí Kálaad Zɛmbî mí ŋgə́ cɨ nə́. Nə́: «Í á jəla nə́ *Krîst júgʉg nə́ ndɛɛ́ a yə, a mú gwûm.» Nyə nə bwo nə́: «Krîst wɔɔŋg wə́ Yésus mə́ ŋgə́ bwiiŋg bɨ́ ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bɔ́ɔ́lʉ́gá Oyúdɛn bwə́ mú magʉlə njɨ́ɨ́gʉ́lá wɔɔŋg. Bwə́ mú sɛɛŋgya gwooŋg nə Pwôl bá Sílas. Bɔ́ɔ́l zhwog Ogʉrɛ̂k bwə́ á dʉ gwɔ̧́ɔ̧ Zɛmbî wá bwə́ mú nə́mə́ sá ntɔ́, tɛɛm bə nə́mə́ bɔ́ɔ́l ncúlyá fwámɛ́ búdá wâ cínɔŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Njɨ, Oyúdɛn bwə́ mú zə jág shîŋ bwo. Bwə́ mú kusə wəámbeshé-mbéshe wâ nyaan milâm bwə́ á dʉ ji ntɔ́ kú nə isɛ́y wá, bwə́ zə shwambʉlə búúd nə́ ndɛɛ́ tə̂l ŋgwə́la nə́ shwuu. Bwə́ músə kə Yason dɨ́ njɔ́w nə́ bwə́ kə bii Pwôl bá Sílas, zə nə bwo tâm buud. ");
INSERT INTO mcp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nda bwə́ á shígɛ́ kwey bwo nə́, bwə́ mú bii Yason bə́nɔ̂ŋ bɔ́ɔ́l óbúgʉla, kə nə bwo ójwú ɔ́ lɔɔm dɨ́ bwə́ ŋgə́ kɨ̂m nə́: «Məŋkúmbə mə búúd mə́ ŋgə́ wá zhizhɔɔm shí nyɛ̂sh myá mí mə́ wɔ́ɔ́s wa. ");
INSERT INTO mcp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason nyə a bə́lɛ lə́g bwo nyə́dɨ́ njɔ́w, í njúl nə́ bwə́ aŋgɛ̂ nə bísh məcɛ̧ɛ̧ mə Káázɛl, bwə́ ŋgə yida cɨ nə́ wúl Njwú-buud íshús wúsə, nə́ wə́ wə́ Yésus.» ");
INSERT INTO mcp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Oŋkwiimbyê báŋ ɔ́nɨ bwə́ mú kənd buud milâm gwɔ̂w tɔɔ ojwû ɔ́ lɔɔm bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ojwû bwə́ á zə bɨ́d Yason bə́nɔ̂ŋ bɔ́ɔ́l óbúgʉla ɔ́nɨ njɨ bwə́ mə́ fwo wá myə́na kwiidʉ́lə mə́nyúul. ");
INSERT INTO mcp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Obúgʉla bwə́ mú lɛɛlʉ́ kənd Pwôl bá Sílas Berê bulú nə bulû. Ja bâŋ bwə́ á kə wɔ́ɔ́s Berê yí, bwə́ á kə mpáánzə́ minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Oyúdɛn wâ Berê bwə́ á bə nə jɔ̧ mílâm ntɔ̧ bɔɔŋg wâ Tesaloníka. Báá, bwə́ á lə́g kɛ́ɛl nə məjigʉwa, bwə́ mú dʉ bigas mícilyá mí Kálaad Zɛmbî jwɔ̂w dɛ̂sh shú nə́ bwə́ dʉ́g mpu ŋkí minjɨ́ɨ́gʉ́lá mí Pwôl mísə tʉ́təlî. ");
INSERT INTO mcp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Zhwog buud báŋ bwə́ á *búgʉla, nə bɔ́ɔ́l zhwog budá Ogʉrɛ̂k, fwámɛ́ búdá, nə zhwog budûm nə́mə́. ");
INSERT INTO mcp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ja Oyúdɛn wâ Tesaloníka bwə́ á gwág nə́ Pwôl mə́ kə nə́mə́ bwiiŋg Milə́sʉ́ mí Zɛmbî Berê yí, bwə́ á tɨ́ nə́mə́ kə wu, kə wá zhizhɔɔm, kə sá nə́ buud mitə́dʉ́gá mí búbúlə́g mílúúd. ");
INSERT INTO mcp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Obúgʉla bwə́ mú ntâg lɛɛl ŋwa Pwôl kənd nyə kɔ́ɔ́mb á mâŋ. Sílas bá bâŋ Timotê bwə́ mú lʉ́g Berê. ");
INSERT INTO mcp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Buud bwə́ á kə lʉ́gal Pwôl wá bwə́ á kə nə nyə kə kumə Atɛ̂n, bâŋ bwə́ mú nyiŋgə. Pwôl mú ntɨ bwo nə məkə́l shú mə́ Sílas bá Timotê nə́ bwə́ lɛ́ɛ́lʉg kə kwey nyə. ");
INSERT INTO mcp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ja Pwôl nyə á ŋgə bwánd Sílas bá Timotê Atɛ̂n yí, lâm í á bul cɛy nyə cwû nə dʉ́gʉ́lə nə́ buud ɔ ŋgwə́la wɔɔŋgʉ̂ bwə́ á ŋgə gwɔ̧́ɔ̧ zhwog ivʉgʉli í ózɛmbî ɔ́ áyadʉ́g. ");
INSERT INTO mcp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nyə á ka dʉ kə *mpáánzə́ minjɨ́ɨ́gʉ́lá kə dʉ lésha nə bwo nə bɔ́ɔ́l búúd bwə́ á dʉ gúmal Zɛmbî wá, a dʉ nə́mə́ kə jwɔ̂w dɛ̂sh tâm də́nd kə́ dʉ lésha nə buud á kwéy wú wá. ");
INSERT INTO mcp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bɔ́ɔ́l məma wəáfaas mitə́dʉ́gá bwə́ á dʉ nə́mə́ lésha nə nyə, bwə́ njúl buud ɔ Epikyur nə bɔɔŋg ɔ Stoyik. Bɔ́ɔ́l bwə́ mú ka dʉ jî nə́: «Jɨ́ gwə́mɛ́fwó lás-lás múúd ga ŋgə́ cɨ yí?» Bɔ́ɔ́lʉ́gá nə́: «Jísə nda a ŋgə bwiiŋg lâŋ ózɛmbî sə́ abwɛ́lɛ́ gwág wá.» Nəcé Pwôl nyə á ŋgə bwiiŋg lâŋ mə́ Yésus nə gwûmʉ́lə nyə á gwûm yí. ");
INSERT INTO mcp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bwə́ á ka ntâg ŋwa Pwôl, kə nə nyə buud onʉ́nɨ́ bwə́ á dʉ sɛɛŋgya Areyopagos dɨ́ wá. Bwə́ nə nɛ́ nə́: «Fwog ná mpu jaaw sə́ wó njɨ́ɨ́gʉ́lá ágúgwáan wó ŋgə́ kyey nə ndɨ̂ nɨ. ");
INSERT INTO mcp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wo mə́ sá nə́ məlwə̂ mə́sʉ́ mə́ gwágʉ́g isâ í agúgwáan. Sə́ mə́ cɛɛl wámbʉlə ísâ byɔɔŋgʉ̂.» ");
INSERT INTO mcp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Buud ɔ Atɛ̂n bɛ̂sh nə ojóŋ bwə́ á dʉ ji wu wá bwə́ á dʉ cɨ́ŋgʉli fwála dáŋ njɨ dʉ́lə ŋgə bwiiŋg nə ŋgə gwágʉlə miláŋ mí agúgwáan mí ŋgə́ kúnɔw wɔ́ɔ́s myá. ");
INSERT INTO mcp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nə́ ndɛɛ́, Pwôl tə́l na tʉ́tám Areyopagos a mú ka zə lás nə buud nə́: «Yé búúd ɔ Atɛ̂n, mə mə́ dʉ́g nə́ íkɔ́ɔ́mb byɛ̂sh dɨ́ bɨ mə jág bul cɛɛl yə́bə́. ");
INSERT INTO mcp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nəcé ja mə mə́ ŋgə kyey bɨ́dɨ́ ŋgwə́la ŋgə dʉ́g bín ísâ bɨ́ ŋgə́ yə gúmə́ yí, mə ámə kwey ŋgwɔ́l *alatâr nə cilyá nə́: “Nyíga jɨ shú mə́ Zɛmbî sə́ ampúyɛ́ é”. Sâ bɨ́ bâŋ ŋgə́ yə gúmə́ kú mpu nɨ, gwə́ wə́ mɛ́ mə́ ŋgə́ zə bwiiŋg bɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Zɛmbî nyə á tɛ́ shí nyɛ̂sh nə isâ bísə́ cínɔŋg yɛ́, á jɨ Cwámba á gwɔ̂w nə shí yɛ́, nyə ádɛ́ ji mə́mpáánzə́ búúd bwə́ shúmə́ nə məbwə̂ má. ");
INSERT INTO mcp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sáal dɛ́ í ádɛ́ sɨ̂y məbwə̂ mə búúd dɨ́ nə́mə́ nda á jɨɨ nə́ buud bwə́ sáág nyə gúl sâ. Nyɛɛ muud ŋgə́ yə sə́ bɛ̂sh cʉg nə məyɔwʉda nə bíl ísâ byɛ̂sh yɛ́, sâ í cúgɛ́ nə ŋkul fúfə nyə. ");
INSERT INTO mcp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","«Nyə a tɛ́ ilwoŋ í búúd byɛ̂sh í ŋgə́ zhu wə́ muud ŋgwúd, nə́ ilwoŋ byɔɔŋg í jígʉ shí nyɛ̂sh dɨ̂. Nyə á cɛ̧ɛ̧lə buud məfwála mə́ cʉg, a tə́l nə́mə́ bwo minjɨ mí mə́shí bwə́ ŋgə́ ji má. ");
INSERT INTO mcp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nyə a sá ntɔ́ nə́ buud bwə́ sɔ̧́ɔ̧́g nyə, bwə́ ŋgə́g bwɔ́wʉlə ka bwə́ é kwey nyə, í njúl nə́ a cugɛ́ shwóg-shwóg nə sə̂. ");
INSERT INTO mcp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nəcé, cʉg sə́ ŋgə́ cʉgə yí, í ŋgə zhu nyə́dɨ́, nyə wə́ ŋgə́ sá nə́ sə́ ŋgə́g nə kuwo, nyə wə́ ŋgə́ sá nə́ sə́ bə́g sâ sə́ bʉ́sə́ yí. Sâ jɔɔŋg wə́ bɔ́ɔ́l ócilɛ ɔ́ ókálaad bʉ́n bwə́ á cɨ yí, nə́: “Nəcé sə́ bʉ́sə mpəg jé”. ");
INSERT INTO mcp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nda sə́ bʉ́sə́ ka bə mpwoŋ buud nyɛ́ nə́, sə́ ajə́láyɛ́ nə tə́dʉga nə Zɛmbî jisə nda or ŋkí nda kwóógʉ́ bwə́ dʉ lúlə *mwaanɛ̂ nə ndɨ̂ yí ŋkí gúl jimə́ kwóógʉ́ sâ búúd ɔ ikə́ŋ bwə́ yágʉ́lə́ nə milúu nə́ ndɛɛ́ bwə́ mú caag yí. ");
INSERT INTO mcp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Zɛmbî nyə aŋgɛ̂ ná nə kənd mísh mə́fwála búúd bwə́ á dʉ bə jág dɨ́ má. Njɨ, a ŋgə jɔ̂w buud bɛ̂sh íkʉ́l byɛ̂sh bwo njúl yí nə́ bwə́ cɛ́ndʉ́g mítə́dʉ́gá. ");
INSERT INTO mcp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nyə á mə́ tə̂l ŋkúmba jwɔ̂w á bá cígal mílə́sʉ́ myâ shí nyɛ̂sh sémbyé á tʉ́təlí yí nda múúd nyə á fɛ́ɛ́sh yɛ́ mə́ bá zə sámb nə́. Nyə a lwágʉlə buud bɛ̂sh yuug nə́ nyə á fɛ́ɛ́sh muud wɔɔŋgʉ̂ gwúmʉ́shílə nyə́ á gwûmʉshi nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Njɨ bwə́ á gwág Pwôl mə́ cɨ nə́ muud nyə a gwûm yí, bɔ́ɔ́l bwə́ mú tɛ́ɛ́d ŋgə́lə cágʉlə nyə, bɔ́ɔ́lʉ́gá bâŋ nə́ nɛ́ nə́: «Sə́ é bá kwo gwágʉlə wo nə lâŋ wô nɨ gúl ja.» ");
INSERT INTO mcp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na wə́ Pwôl nyə á zə béégya nə bwo yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Njɨ, bɔ́ɔ́lʉ́gá báá bwə́ á shí leedya nə nyə, bwə́ *búgʉla. Í á bə buud nda Denis muud Areyopagos, nə mudá bwə́ á dʉ jɔ̂w nə́ Damaris yɛ́, nə bɔ́ɔ́lʉ́gá nə́mə́ na. ");
INSERT INTO mcp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ja ísâ ínɨ í mə́ shîn bə ntʉ́nɨ yí, Pwôl músə wú Atɛ̂n kə Kɔrɛ̂nt. ");
INSERT INTO mcp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A mú kə kwey ŋgwɔ́l *Yúdɛn nûŋ nə jínə́ nə́ Akilas, a njúl muud á Pɔ̂ŋ. Akilas ɛ́nɛ bá mudá yé Priska bwə́ á ŋgə kúnɔw wɔ́ɔ́s, bwə́ ŋgə́ zhu Italî nəcé Klóod nyə a wɨ́ɨ́ŋg Oyúdɛn bɛ̂sh nə́ bwə́ wúg Róma. Pwôl mú sɛɛŋgya nə bwo. ");
INSERT INTO mcp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nda í á nyîn nə́ bə́nɔ́ŋ bwə́ á jɨ́ɨ́g váál ísɛ́y ŋgwúd nə́, bə́nɔ́ŋ bwə́ mú ji kʉl ŋgwúd dʉ sɛ̂y. Bwə́ á dʉ laad məbanda nə míkáándə́. ");
INSERT INTO mcp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pwôl nyə á ka dʉ kə lésha nə buud *mpáánzə́ minjɨ́ɨ́gʉ́lá dɨ̂ mwɔ̂w mə́ Sábaad mɛ̂sh, a dʉ́gə́ mpu sá nə́ Oyúdɛn nə Ogʉrɛ̂k bwə́ mágʉləg kɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ja Sílas bá Timotê bwə́ á wɔ́ɔ́s wúlə Masedwân yí, Pwôl nyə á ka zə wá nyúul nyɛ́ nyɛ̂sh bwiiŋgʉ́lə kɛ́ɛl dɨ̂, a ŋgə́ mpu bwaagʉlə Oyúdɛn nə́ Yésus wə́ jísə *Krîst. ");
INSERT INTO mcp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Njɨ, Oyúdɛn bwə́ mú zə bul fʉm nyə, bwə́ dʉ jág lwîy nyə. Pwôl mú ka samʉsə míkáándə́ nyə nə bwo nə́: «Mpwɛnɛ wʉ́n mə jágʉwə nə bɨmɛ́fwó, kú bə mə. Mɛɛ mə zə́ ka yág kɔ́ɔ́mb búúd bwə́ cúgɛ́ Oyúdɛn wá jaá gaád.» ");
INSERT INTO mcp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A mú wú na kə nyíi njɔ́w mə́ ŋgwɔ́l múúd bwə́ á dʉ jɔ̂w nə́ Titiyos Yustos yɛ́. Muud wɔɔŋgʉ̂ nyə á dʉ gúmal Zɛmbî, njɔ́w yé nɨ i njúl koogʉ́ lʉ mpáánzə́ minjɨ́ɨ́gʉ́lá. ");
INSERT INTO mcp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kríspus múúd nyə á bə njwû á mpáánzə́ minjɨ́ɨ́gʉ́lá yɛ́ nyə a *búgʉla Cwámba nə njɔ́w yé wɛ̂sh. Zhwog buud ɔ́ Kɔrɛ̂nt bwə́ á dʉ gwág Pwôl wá bwə́ á búgʉla nə́mə́, bwə́ mú ŋgə duwan. ");
INSERT INTO mcp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pwôl mú dʉ́g *ntamə́ á mísh nə́ bagə́ gúl búlúd Cwámba ŋgə́ cɨ nə nyə nə́: «Wo kú fúndə. Wɛɛ ŋgag nə lás, wo kú ji kʉ́l-kʉ̂l, ");
INSERT INTO mcp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nəcé mə jɨ nə wo, múúd cugɛ́ nə ŋkul kúnya nə wo nə́ a sá wo bɔ̂w. Mə jɨ nə búúd ŋkí bulya wa ŋgwə́la gaád.» ");
INSERT INTO mcp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pwôl nyə á ji na mbû ncindî nə oŋkwoond ósaman, a ŋgə́ bwiiŋg bwo Milə́sʉ́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Njɨ, ja Galiyôŋ nyə á bə ŋgwə́mʉna íjwûga yâ Róma í á tə̂l Akayî yí, Oyúdɛn bɛ̂sh bwə́ á tɔ́w ciŋʉ́-cində̂ nə Pwôl, bwə́ mú bií nyə kə nə nyə ósémbye ɔ mílə́sʉ́ dɨ́ ");
INSERT INTO mcp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","kə shwə́man nyə nə́: «Muud ɛ́ga ŋgə shwúgʉli buud nə́ bwə́ yə́g Zɛmbî gúmə́ mbií í yídá lúmbʉli nə Məcɛ̧ɛ̧ yí.» ");
INSERT INTO mcp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pwôl mú nywá cɛɛl lás, njɨ Galiyôŋ mú cɨ nə Oyúdɛn nə́: «Í mbə̂m bə nə́ muud ɛ́nɛ mə́ shwey gúl wôŋ ŋkí nə́ a mə́ sá gúl sâ áyíyáág, mə lə́g shwə́man jɨ́n nda í jə́la nə́, yé Oyúdɛn. ");
INSERT INTO mcp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Njɨ, nda jísə́ nə́ bɨ́ ŋgə shuya shú sâ í dʉ́gyá nə minjɨ́ɨ́gʉ́lá mín, nə mínə́ mʉ́n, nə məcɛ̧ɛ̧ mʉ́n nə́, bɨmɛ́fwó lásʉ́gá isâ bín. Mə acɛ́ɛ́lɛ́ lás mbií lə́sʉ́ nɨ.» ");
INSERT INTO mcp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","A músə nyiŋg bwo nə́ bwo wúg njɔ́w mílə́sʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bɛ̂sh bwə́ mú bií Sostɛ̂n njwû á mpáánzə́ minjɨ́ɨ́gʉ́lá, dʉ daŋgʉlə cú nyə nə́mə́ na mpumbɛ́ njɔ́w mílə́sʉ́d Galiyôŋ kú bísh. ");
INSERT INTO mcp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pwôl nyə á nyiŋgə kwo ji Kɔrɛ̂nt fwámɛ́ zhwog mwɔ̂w nə́ ndɛɛ́ a mú jə́na nə obúgʉla, a mú kəwa byɔ́ɔ́lʉ́d kyey kə Sirî, bə́nɔ̂ŋ Akilas bá Priska. Nyə á ka kə kɛ̧nya lúú Saŋkrê nə ŋkaagə́ nyə á sá yí. ");
INSERT INTO mcp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bwə́ mú kə kumə Ifɛ̂z, Pwôl mú béégya nə Akilas bá mudá. Nyɛɛ mú kə mpáánzə́ minjɨ́ɨ́gʉ́lá kə lésha nə Oyúdɛn. ");
INSERT INTO mcp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bwə́ mú bií nyə nə́ bə́nɔ́ŋ bwə́ nyág ná já fwámɛ́ mwɔ̂w. A mú ban. ");
INSERT INTO mcp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A mú jə́na nə bwo, nyə nə́: «Ŋkí Zɛmbî mə́ magʉlə, mə é bá nyiŋgə zə wa bɨ́dɨ́.» A mú kəwa byɔ́ɔ́lʉ́d kyey wú Ifɛ̂z. ");
INSERT INTO mcp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bwə́ mú kə səl byɔ́ɔ́l Sezarê. Pwôl mú bád kə, kə bə́da *Dɔ̧ lʉ́ óbúgʉla, a músə ka shulə kə Antyósh. ");
INSERT INTO mcp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A mú ji wu baalɛ́ fwála nə́ ndɛɛ́ a mú kyey. A lɨ́ɨ́na shí Galátia a cɔ̧́ Frizhî, a ŋgə́ yə *ompwíín məcwûŋ ŋgə́lə wa bwo ŋkul búgə́d. ");
INSERT INTO mcp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ŋgwɔ́l *Yúdɛn nə jínə́ nə́ Apolos nyə á bə muud á Aləgʉzandrî, nyə á ka zə wɔ́ɔ́s Ifɛ̂z. Nyə á bə nə cóŋ lə́sʉ́, a njúl nə́mə́ nə fwámɛ́ mpúyá kɛ́ɛl mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nyə a shí jɨ́ɨ́g ísâ í dʉ́gyá nə zhɨɨ́ mə Cwámba yí. Nyə á bə nə məma yéésh ísɛ́y a mú dʉ bwiiŋg ísâ í Yésus, a dʉ jɨ́ɨ́gʉli byo njɨ́ɨ́gʉ́lá á tʉ́təlí í njúl nə́ nyə á mpu njɨ nduwán mə́ Yuánɛs. ");
INSERT INTO mcp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nyə á ka dʉ bwiiŋg kɛ́ɛl *mpáánzə́ minjɨ́ɨ́gʉ́lá dɨ́, kú fúndə múúd. Priska bá Akilas bwə́ mú dʉ gwágʉlə nyə nə ndɛɛ́ bwə́ mú ŋwa nyə bwə́dɨ́ njɔ́w zə nyiŋgə mpu lwágʉlə nyə zhɨɨ́ mə́ Zɛmbî nə́ sáŋ sáŋ. ");
INSERT INTO mcp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nda nyə á ka ŋgə cɛɛl kə Akayî nə́, obúgʉla bɛ̂sh bwə́ mú wá nyə ŋkul lámʉ́d, bwə́ cilə bɔɔŋg wâ wu nə́ bwə́ bâg ŋwa nyə nə məshusʉg. Ja nyə á ka kə jé wu yí, mpaam mə́ Zɛmbî í mú sá nə́ a bə́g nə məma mfíí shú obúgʉla. ");
INSERT INTO mcp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Iciyá í lə́sʉ́ byé í á dʉ sá nə́ məshwán *Oyúdɛn bwə́ á dʉ cɛɛl sá má mə́ bə́g zhizhe. Nyə á dʉ mpu lwágʉlə bwo mícilyá myâ Kálaad Zɛmbî dɨ́ nə́ Yésus wə́ jísə́ *Krîst. ");
INSERT INTO mcp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Í á ka zə bə, ja Apolos nyə á bə Kɔrɛ̂nt nɨ, Pwôl nyə a shîn lɨ́ɨ́na shí á mimbʉ́ŋ nə́ ndɛɛ́ a mú shulə kə Ifɛ̂z. Nyə á ka kə kwey bɔ́ɔ́l *ómpwíín nûŋ, ");
INSERT INTO mcp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","a mú jî bwo nə́: «Ye bɨ a shí lə́g Ŋkɛ̧́ŋkɛ̧̂ Shíshim ja bɨ́ á *búgʉla yí?» Bwə́ nə nɛ́ nə́: «Sə́ afwóyɛ́ nə́mə́ bwɛlɛ gwág nə́ Ŋkɛ̧́ŋkɛ̧̂ Shíshim jisə.» ");
INSERT INTO mcp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A mú kwo jî nə́: «Wáyɛ́ nduwán bɨ́ á ka duwan yí?» Bwə́ nə́: «Nduwán mə́ Yuánɛs.» ");
INSERT INTO mcp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pwôl mú ka cɨ nə́: «Nduwán mə́ Yuánɛs í á bə shú búúd bwə́ á magʉlə nə́ bwə́ cɛ́nd mítə́dʉ́gá wá. Yuánɛs nyə á ŋgə lwágʉlə kúl búúd nə́ bwə́ búgʉ́lág múúd ŋgə́ zə nyə́dɨ́ mpʉ́sə yɛ́. Muud wɔɔŋg wə́ Yésus.» ");
INSERT INTO mcp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nda bwə́ á gwág ntɔ́ nə́, bwə́ á duwan jínə́ mə́ Cwámba Yésus dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ja Pwôl nyə á bəd bwo məbwə̂ yí, Ŋkɛ̧́ŋkɛ̧̂ Shíshim mú zə bwə́dɨ́, bwə́ mú ŋgə lás mə́kə́lʉ́d bwə́ ŋgə́ cúndə micúndə́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bwə́ á je bə buud wûm nə óbá. ");
INSERT INTO mcp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pwôl nyə á kə nyíi *mpáánzə́ minjɨ́ɨ́gʉ́lá, nyə a dʉ bwiiŋg kɛ́ɛl cínɔŋg tâŋ oŋkwoond olɔ́ɔl kú fúndə mísh mə buud, a ŋgə́ lésha nə buud, a ŋgə́ sá nə́ bwə́ mágʉləg sâ í dʉ́gya nə Faan mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nda bɔ́ɔ́l bwə́ á ŋgə sá lal lúú bwə́ kú magʉlə sá nyə á ŋgə cɨ yí bwə́ ŋgə́ yida *lás nə zhɨɨ́ mə Cwámba bwaasʉ́lə mpu tâm buud nə́, Pwôl nyə á ka ntâg béégya nə bwo, a ŋwa ómpwíín, a kə dʉ lésha nə bwo jwɔ̂w dɛ̂sh shikûl mə́ Tirános dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nyə a sá ntɔ́ tâŋ mimbû mímbá, í mú sá nə́ buud ɔ Azî bɛ̂sh bwə́ gwágʉ́g kɛ́ɛl mə Cwámba, tɔɔ *Oyúdɛn tɔɔ Ogʉrɛ̂k. ");
INSERT INTO mcp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Zɛmbî nyə a wééshʉli *məshimbá mə́ álal-ŋkul mə́bwə̂ mə́ Pwôl dɨ̂, ");
INSERT INTO mcp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","mbií í á bə nə́ bwə́ á dʉ ŋwa onábʉkən nə mikáándə́ mí á dʉ kúnya nə Pwôl myá, bwə́ dʉ báaw mímbə̂l nə myo, məbwas bɨ́d mímbə̂l myɔɔŋgʉ́, məjamb wû. ");
INSERT INTO mcp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bɔ́ɔ́l óŋkɔ̧ɔ̧ ɔ́ Oyúdɛn bwə́ á dʉ kyey mílɔɔm milɔɔm dʉ yîl búúd məjamb wá, bwə́ mú zə tɛ́ɛ́d nə́ bwə́ dʉ jɔ̂w jínə́ mə́ Cwámba Yésus nə́ í lwágʉg minjumbʉ́lu. Bwə́ á dʉ cɨ nə́: «Mə yɨ́ɨ́mbʉ́lí bɨ́ jínə́ mə́ Yésus Pwôl ŋgə́ cúndə yɛ́d.» ");
INSERT INTO mcp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ntɔ́, bɔ́ɔ́l búúd zaŋgbá bwə́ njúl bwân ɔ́ wúl lúlúú ófada Oyúdɛn bwə́ dʉ jɔ̂w nə́ Skéva yɛ́, bwə́ á ka nə́mə́ zə sá sɔ́ɔ́lʉ́gʉ́ wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ntɔ́ jamb í á zə fɛɛl bwo nə́: «Mə mpú Yésus, mə mpú nə́mə́ Pwôl, bɨ́ bâŋ wə́ ozə́?» ");
INSERT INTO mcp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Muud nyə á bə nə jamb nɨ yɛ́ mú ncoŋ bwo nyúúlʉd, figə bɛ̂sh shí ntɔ̧ bwo ŋkul. Nyə a sá bwo nə́ ndɛɛ́ bwə́ mú wɛɛnzh na njɔ́w nɨ dɨ́ oshushwáás nə məfə́ŋ nyúúlʉ́d nə́ jəəd. ");
INSERT INTO mcp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Buud ɔ Ifɛ̂z bɛ̂sh, tɔɔ Oyúdɛn tɔɔ Ogʉrɛ̂k bwə́ mú gwág lâŋ wɔɔŋg, í mú sá bwo ifwaas nə́ ndɛɛ́ jínə́ mə́ Cwámba Yésus í mú jwɔ̧. ");
INSERT INTO mcp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ncúlyá buud wâ bɔɔŋg bwə́ á búgʉla wá bwə́ mú zə ŋgə magʉlə məbɔ̂w máŋ, bwə́ ŋgə́ bágʉlə isâ bwə́ á dʉ sá yí tâm buud. ");
INSERT INTO mcp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bɔ́ɔ́l zhwog buud bwə́ á dʉ sá májig wá bwə́ mú dʉ zə nə okálaad bɔɔŋg dʉ zə ŋkúnd tâm buud nə́ ndɛɛ́ jígal. Bwə́ á bála bímbí lʉ́ ókálaad dɔɔŋg nə́ í á kumə́ misaŋ mí *mwaanɛ̂ otɔ́ɔ́shin məwûm mə́tɔ́ɔn. ");
INSERT INTO mcp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nə́ ndɛɛ́, kɛ́ɛl í á ŋgə mpyáánz nə ŋkul mə Cwámba, misɔ́ɔ́lʉ́gʉ́ mí ŋgə́ sɨ̂y. ");
INSERT INTO mcp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ja ísâ ínɨ í á shîn sɨ̂y yí, Pwôl mú zə bii tə́dʉ́gá nə́ á kyey Masedwân nə Akayî kə Yurʉ́səlɛm. Nyə nə́: «Ja mə́ bá kumə Yurʉ́səlɛm yí, í bá nə́mə́ jɨ nə́ mə kə́g Róma.» ");
INSERT INTO mcp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","A mú kənd bɔ́ɔ́l ósɔ́ɔl ɔ́ mə́sáal bɛ́ óbá Masedwân, nə Timotê nə Erâst. Nyɛɛ mú lɛŋgʉli fwámɛ́ fwála Azî. ");
INSERT INTO mcp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Fwála dɔɔŋg wə́ ícucu í á zə bə shú zhɨ́ɨ́ mə Cwámba yí. ");
INSERT INTO mcp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ŋgwɔ́l álúlə igwámʉ́gə̂ nə jínə́ nə́ Dəmitrî nyə á dʉ lúlə kwóógʉ́ bwə́ dʉ lúlə *mwaanɛ̂ nə ndɨ̂ yí, dʉ sá ímpʉ́mpáánzə́ í zɛmbî ámudâ bwə́ á dʉ jɔ̂w nə́ Artemís yɛ́. Sâ jɔɔŋg í á dʉ sá nə́ buud bwə́ á dʉ sá íság-ság í məbwə̂ wá bwo bííg fwámɛ́ mə́bii. ");
INSERT INTO mcp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nyə á ka sɛɛŋg buud ɔ íság-ság bɔɔŋgʉ́ nə bɔ́ɔ́l búúd bɛ̂sh bwə́ dʉ sá mbií mə́sáal mɔɔŋg wá, a mú cɨ nə bwo nə́: «Owɛy, bɨ mə mpú nə́ isɛ́y íga wə́ í ŋgə́ yə shé məbugʉbaan. ");
INSERT INTO mcp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Bɨ́ ŋgə dɨ́ gwág nda í mú ŋgə lɨ́s nə́! Nə́, tɔɔ wa Ifɛ̂z tɔɔ Azî yɛ̂sh, Pwôl ɛ́nɛ mə́ shîn sá nə́ zhwog buud bwə́ mágʉləg lâŋ yé nə́ ozɛmbî buud bwə́ lúlə nə məbwə̂ wá bwə́ cúgɛ́ ózɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Sâ jɔɔŋg í é sá nə́ isɛ́y bísʉ́ í bə́g zhizhe. Kú nə́mə́ bul bə njɨ ntɔ́, í é sá nə́mə́ nə́ mpáánzə́ mə́ Artemís məma zɛmbî ámudâ í nyínʉ́g zhizhe, buud bwə́ mú dʉ́g nywo nda sâ cwag, í kú ná nyiŋgə bə nə gúmə́ Azî nə shí nyɛ̂sh bwə́ ŋgə́ gúmal Artemís yí.» ");
INSERT INTO mcp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Njɨ bwə́ á gwág ntʉ́nɨ yí, bwə́ mú nyada, bwə́ mú tɛ́ɛ́d ŋgə́lə kɨ̂m nə́: «Artemís á buud ɔ Ifɛ̂z jisə sâ anʉ́nɨ́.» ");
INSERT INTO mcp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ŋgwə́la wɛ̂sh mú shwal tɔ̂w nə́ shwuu. Buud bwə́ mú cíg kə mpáánzə́ isɛɛŋgyá. Bwə́ bii búúd ɔ́ gwooŋg ɔ Pwôl, Gáyus bá Aristárʉg, buud wâ Masedwân, julə kə nə bwo wu mpáánzə́ isɛɛŋgyá. ");
INSERT INTO mcp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pwôl mú cɨ nə́ a kə́ lwóya nyúul wu tâm buud. Njɨ, *ompwíín bwə́ mú ban nə́ a kú kə. ");
INSERT INTO mcp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bɔ́ɔ́l búúd ɔ Azî bwə́ á bə oshwə́ bɛ́ wá bwə́ mú nə́mə́ kənd búúd kə tɛ́ɛ́g nyə məbwə̂ nə́ a kú tə̂l mə́kuú mpáánzə́ isɛɛŋgyá. ");
INSERT INTO mcp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Í á shwal zə bə buud ŋgə kɨ̂m ntʉ́nɨ, nyâŋ kɨ̂m yé ŋkwiimbyê, nyâŋ kɨ̂m yé. Í mú bə áfúlʉkumbɛ̂, bɔ́ɔ́l ncúlyá buud kú nə́mə́ mpu sâ gwə́mɛ́fwó í ámə sɛɛŋg búúd yí. ");
INSERT INTO mcp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bɔ́ɔ́l búúd bwə́ mú mpu jaaw Aləgʉzándrə sâ í ŋgə́ cɔ̧́ yí, nyɛ muud *Oyúdɛn bwə́ á tə́l shwóg yɛ́. A mú ŋgə fʉfə buud mbwə̂ nə́ bwə́ gwágʉ́lə́g, á cɛɛl lwágʉlə búúd sâ jísə́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Njɨ bwə́ á yag nə́ a jɨ Yúdɛn yí, buud bɛ̂sh bwə́ á shwal ŋgə kɨ̂m nda ŋgwa nə́: «Artemís á buud ɔ Ifɛ̂z jisə sâ anʉ́nɨ́.» Bwə́ á kɨ̂m ntɔ́ nə ndɛɛ́ je bə tâŋ məwəla məbá. ");
INSERT INTO mcp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Muud nyə á dʉ cilə isâ í ŋgwə́la yɛ́ mú ka zə mpu jil búúd nə́ shɛɛ. A mú lás nə bwo nə́: «Ye búúd ɔ Ifɛ̂z, nyáyɛ́ múúd á shí ga mə jág nə́ njɨ wa Ifɛ̂z wə́ mpáánzə́ mə́ Artemís məma zɛmbî ámudâ nyísə́ yɛ́, njɨ wa nə́mə́ wə́ vʉgʉli jé í á kud wú gwɔ́w yí jísə́ yɛ́? ");
INSERT INTO mcp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Muud cugɛ́ nə ŋkul shwána sâ jɔɔŋg. Ntɔ́, bɨ mə jəlá nə ji nə́ shɛɛ bɨ kú jigʉwa nə́ bɨ mə sá wúl sɔ́ɔ́lʉ́gʉ́ kú fwo tə́dʉga. ");
INSERT INTO mcp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bɨ́ ámə zə nə buud ɔ́ga wa í njúl nə́ bwə́ asáyɛ́ zɛmbî ámudâ wúsʉ́ bɔ̂w, kú nə́mə́ *lás nə nɛ́ bwaasʉ́lə mpu. ");
INSERT INTO mcp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ŋkí Dəmitrî bə́nɔ̂ŋ buud ɔ íság-ság bɛ́ bʉ́sə nə lə́sʉ́ nə muud, ŋgaá nə́ mílə́sʉ́ mí dʉ lɨ́s njɔ́w mílə́sʉ́, ogwə́mʉna bʉ́sə nə́mə́! Bwə́ kə́g nə lə́sʉ́ wáŋ íshwə́man dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ŋkí bɨ mə́ ka bə nə gúl sâ bɨ́ ŋgə́ shwaag yí, í jəlá nə lɨ́s fwámɛ́ sɛɛŋgyád. ");
INSERT INTO mcp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Jɔɔŋg sə́ ŋgə́ sá múús ga jísə ojwû jee wáámb sə́ nə́ sə́ ŋgə wá zhizhɔɔm lɔɔmʉd. Sə́ bʉ́sə ná nə ŋkul ka jaaw búúd nə́ sɛɛŋgya ga jísə shú jɨ́?» ");
INSERT INTO mcp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Njɨ nyə á shîn lás ntʉ́nɨ́ yí, a mú cɨ nə buud nə́ bwə́ bwɨ́lyág. ");
INSERT INTO mcp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ja zhizhɔɔm nɨ nyə a shîn yí, Pwôl nyə a jɔ̂w *ompwíín, a zə cwíny bwo. A mú jə́na nə bwo nə́ ndɛɛ́ a músə tɨ́ kə Masedwân. ");
INSERT INTO mcp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A mú kyey mə́shí mɔɔŋg dɨ́ a ŋgə́ cwîny obúgʉla ŋkí bulya nə́ ndɛɛ́ a mú kə kumə shí Ogʉrɛ̂k. ");
INSERT INTO mcp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","A mú já cínɔŋgʉ́ oŋkwoond olɔ́ɔl. Nyə á ka bə nə́ a ŋwa byɔ́ɔ́l kə Sirî. Njɨ nda nyə á gwádʉga nə́ *Oyúdɛn bwə́ ŋgə bwéél nyə nə́, a mú nyiŋgə kə Masedwân. ");
INSERT INTO mcp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Buud ɔ́ gwooŋg bɛ́ bwə́ á bə, nə Sopatɛr mə Pírus muud á Berê, nə Aristárʉg bá Səgundo búúd ɔ́ Tesaloníka, nə Gáyus á Dɛ́rbə bá Timotê, nə Tishik bá Trofîm buud ɔ́ Azî. ");
INSERT INTO mcp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bâŋ bwə́ á kə shwóg kə bwánd sə́ Truwás. ");
INSERT INTO mcp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sə́ bâŋ sə́ á ka zə tɨ̂ njɔɔnd Filipî ja mwɔ̂w bwə́ á dʉ də ibʉlɛ́d yâ kú nə *ləvur mə́ á shîn yí. Sə́ mú ŋwa byɔ́ɔ́l, sə́ já zhɨ́ɨ́d mwɔ̂w mə́tɔ́ɔn nə́ ndɛɛ́ sə́ mú kə kwey bwo Truwás. Sə́ á ji cínɔŋgʉ́ mwɔ̂w zaŋgbá. ");
INSERT INTO mcp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sə́ á ka sɛɛŋgya jwɔ̂w shwɛ́ndɛ mə́ dʉ tɛ́ɛ́d yí nə́ sə́ mə́ zə́ féya bʉlɛ́d. Nda Pwôl nyə á bə nə́ nyə é kyey mán mələ̂m nə́, nyə á ka ŋgə lésha nə buud, a ka julə kaand nə́ ndɛɛ́ kə wɔ́ɔ́s tâm bulû. ");
INSERT INTO mcp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kʉ́l sə́ á bə fúm á njɔ́w dɨ́ gwɔ́w wá, məlámba mə́ á bə minjidyá fwámɛ́ bímbí. ");
INSERT INTO mcp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Dúl ncwə́má í á bə a njúl vúndɛd, ncwə́má dɔɔŋgʉ́ nə jínə́ nə́ Etíkus. Nyə á ka zə cɔ̧́ gwə́d nə́ cúg, Pwôl nyɛ ŋgə́ kə nə kaand shwóg. Nda gwə̂ í á bul bií Etíkus nə́, nyə á yʉŋ wú nûŋ bə́dyé álɛ́ɛl á njɔ́wʉ́d zə kadʉwa shí. Bwə́ zə wɛɛl nyə, a mə́ yə. ");
INSERT INTO mcp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pwôl mú shulə. A mú lɛɛlʉ́ kə, kə ŋkɛ̂ny ncwə́má nɨ mə́bwə́d. A mú cɨ nə buud nə́: «Kúgá kənd mílâm gwɔ̂w. Jîm jé jísə ná nyə nyúúlʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pwôl mú nyiŋgə bád, a mú fɛ̂y bʉlɛ́d a də. A mú kə nə kaand shwóg nə́ ndɛɛ́ mán mú lə̂m. A músə kyey. ");
INSERT INTO mcp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bwə́ mú kyey nə ncwə́má nɨ kuwó. Sâ jɔɔŋg í á bə məma sâ í á mpu yə buud ŋkul yí. ");
INSERT INTO mcp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sə́ mú kə shwóg, sə́ ŋwa byɔ́ɔ́l kə Asos wú í á bə nə́ sə́nɔ́ŋ Pwôl sə́ é kə nyiŋgə lad gwooŋg wá. Nyɛɛ, nyə á kyey njwóŋ nə njwóŋ nda nyə́ á cɛɛl nə́. ");
INSERT INTO mcp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pwôl mú kə kwey sə́ Asos. Sə́ mú ŋwa nyə byɔ́ɔ́lʉ́d sə́ músə kə Mitilɛ̂n. ");
INSERT INTO mcp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wúlə cínɔŋgʉ́, sə́ mú kə nə byɔ́ɔ́l mâŋ nə́ ndɛɛ́ mán mələ̂m sə́ mú kumə nə́ bɛɛndyá nə Kyos. Jwɔ̂w í á bɛ̧ yí sə́ kumə ŋgɛɛ́ Sámos, jwɔ̂w í á kwo bɛ̧ yí sə́ mú kumə Milɛ̂t. ");
INSERT INTO mcp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pwôl nyə á ŋgə bul jɨɨ nə́ a kyey mâŋ nə mâŋ, cɔ̧́ Ifɛ̂z kú shigʉla shú nə́ a kú ná kwo bwey Azî. Nyə á ŋgə cáás nə́ ŋkí fwála dɨ́ nə ŋkul bə, a bə Yurʉ́səlɛm jwɔ̂w lʉ́ Pantekôt. ");
INSERT INTO mcp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sə́ njúl na Milɛ̂t ɨɨ́, Pwôl nyə á kənd muud Ifɛ̂z kə jɔ̂w ocúmbá buud wâ *Dɔ̧ lʉ́ óbúgʉla ɔ́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ja ocúmbá buud bwə́ á zə wɔ́ɔ́s nyə́dɨ́ yí, nyə a lás nə bwo nə́: «Bɨ mə mpú nda mə́ á cʉgə nə bɨ́ mwɔ̂w mɛ̂sh tɛ́ɛ́d jwɔ̂w mə́ á wɔ́ɔ́s Azî yí. ");
INSERT INTO mcp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nə́ mə a sɛ̂y nə Cwámba mə kú bwɛlɛ ŋkɛ̂ny nyúul, mə ŋgə sɛ̂y nə micúŋ nə mindɔɔlú mə á ŋgə bwəma nə ndɨ́ nə məláámb *Oyúdɛn bwə́ á ŋgə ndêny mə má. ");
INSERT INTO mcp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bɨ mə mpú nə́ mə a shígɛ́ shweel gúl fwámɛ́ sâ í á jəla nə kwíínd bɨ́ yí, njɨ mə á bwiiŋg bɨ́ kɛ́ɛl, mə dʉ yə bɨ́ minjɨ́ɨ́gʉ́lá tâm buud nə bɨ́dɨ́ mínjɔ́w, ");
INSERT INTO mcp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","mə ŋgə́ báásʉlə Oyúdɛn nə Ogʉrɛ̂k bɛ̂sh nə́ bwə́ cɛ́ndʉ́g mítə́dʉ́gá zə wə́ Zɛmbî, bwə́ búgʉ́lág Cwámba wúsʉ́ Yésus. ");
INSERT INTO mcp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ja ga, Ŋkɛ̧́ŋkɛ̧̂ Shíshim mə́ bií mə mbwug, mə wə́ ŋkág Yurʉ́səlɛm kú mpu sâ í ŋgə́ bwánd mə shwóg ɛ́ga. ");
INSERT INTO mcp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sâ jísə́ yí jɨ́ njɨ nə́ míŋgwə́la miŋgwə́la, Ŋkɛ̧́ŋkɛ̧̂ Shíshim ŋgə jaaw mə nə́ məŋkəda nə *incwaw í ntʉg wə́ mə́ é kə bwəma nə ndɨ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Njɨ, mə adʉ́gɛ́ cʉg jâm nda gúl məma sâ. Mə́ jɨɨ njɨ nə́ mə mpúg ju kʉ́lə́ mə́ ŋgə́ ju yí, mə mpu sâ ísɛ́y Cwámba Yésus nyə á yə mə yí, isɛ́y í bwiiŋgʉ́lə Jɔ̧jɔ̧ Kɛ́ɛ́l á mpaam mə́ Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Jaá ga, mə mpú nə́ bɨ abʉ́lɛ́ ná kwo dʉ́g mpwóómbʉ́ nyâm, bɨ́ buud mə á ji bɨ́dɨ́ ŋgə́lə cúndə Faan mə́ Zɛmbî wá. ");
INSERT INTO mcp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mə ka ŋgə jaaw bɨ́ fwámɛ́ jaaw múús nə́ mə cugɛ́ nə məbɛ̧ɛ̧́ mə́ ŋkúmba muud na bɨ́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mə a bwiiŋg bɨ́ tə́dʉ́gá mə́ Zɛmbî wɛ̂sh kú shweel tɔɔ sâ. ");
INSERT INTO mcp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bɨ ɔ mpú baagʉlə bɨ́mɛ́fwó, bɨ́ mpu nə́mə́ baagʉlə sɔɔnz jɛ̂sh Ŋkɛ̧́ŋkɛ̧̂ Shíshim nyə á tə̂l bɨ́ nə́ bɨ bə́g obaagʉlə yí. Bɨ ɔ mpú wɨ́ɨl Dɔ̧ lʉ́ óbúgʉla Zɛmbî nyə á kusə nə məcií mɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mə mpú nə́ ja mə é cɔ̧́ yí, oŋkweny ɔ́ ányinyaanə̂ bwə́ é zə nyíi na bɨ́dɨ́. Bwə́ ábʉ́lɛ jagʉlə sɔɔnz jɨ́n. ");
INSERT INTO mcp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bɔ́ɔ́l búúd bwə́ bá dʉ wɔɔf na bɨ́dɨ́ gwooŋg dɨ́ bwə́ dʉ jɨ́ɨ́gʉli bɔ́w-bɔ̂w mínjɨ́ɨ́gʉ́lá dʉ julə *ompwíín nə́ bwə́ bɛ̧́g bwo. ");
INSERT INTO mcp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Gwə́ wə́ mə́ cɨ́ nə bɨ́ nə́: “Jigá ŋkasə̂. Bɨ ɔ́ dʉ tə́dʉga nə́, tâŋ mimbû mílɔ́ɔl, mə á dʉ kɛ́wʉli muud yɛ̂sh nə bulú nə mwásə́, mə nə məzhwíílɛ míshʉ́d.” ");
INSERT INTO mcp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nə́ ndɛɛ́, mə mə́ bəd bɨ́ mə́bwə́ mə́ Zɛmbî dɨ́, nə kɛ́ɛl á mpaam nyɛ́d. Nyə wə́ jɨ́ nə ŋkul sá nə́ bɨ́ ŋgə́g nə lal búgə́d, nyə nə́mə́ wə́ jɨ́ nə ŋkul yə bɨ́ mənywa nyə á bwey kwəmʉsa shú búúd nyə á mə́ sá nə́ bwə́ bə́g miŋkɛ̧́ŋkɛ̧̂ wá. ");
INSERT INTO mcp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mə a shígɛ́ wɨ́ɨ́mb *mwaanɛ̂ ŋkí or ŋkí káándə́ mə́ múud. ");
INSERT INTO mcp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bɨmɛ́fwó bɨ mə mpú nə́ ísâ mə́ á dʉ jɨɨ yí nə byɔɔŋg búúd ɔ́ gwooŋg jâm bwə́ á dʉ jɨ́ɨ́ yí, məbwə̂ mâm mə́ga mə́ á dʉ sɛ̂y, mə́ dʉ bii. ");
INSERT INTO mcp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mə a lwágʉlə bɨ́ fwámɛ́ lwágʉlə nə́ ntʉ́ga wə́ múúd mə jə́lá nə wádʉga yɛ́ shú nə́ a kwííndʉ́g bɔɔŋg bʉ́sə́ kú nə məŋkul wá. Muud tə́dʉga nə́mə́ íciyá Cwámba Yésus nyə a cwééd yí nə́: “Nə muud mə yána yɛ́, nə nyɔɔŋg mə lə́g yɛ́, nyɔɔŋg mə yána ɔ jísə́ nə ocúncɛ́sh.”» ");
INSERT INTO mcp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ja nyə á shîn lás ntʉ́nɨ yí, bə́nɔ́ŋ bɛ̂sh bwə́ á kúd məbwóŋ shí, a músə jəgʉla. ");
INSERT INTO mcp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Buud bɛ̂sh bwə́ músə ŋgə bwawʉda, bwə́ ŋgə kúlal nyə, bwə́ ŋgə kalʉwo nyə cʉ́ŋʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bwə́ á bul gwág cɛy lámʉ́d nəcé nda nyə á cɨ nə bwo nə́ bwə́ ábʉ́lɛ kwo dʉ́g mpwóómbʉ́ nyɛ́ nə́. Bwə́ á ka kə lʉ́gal nyə kə wɔ́ɔ́s byɔ́ɔ́lʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ja sə́ á ka tɨ́ mənyúúl na béégya nə bwo yí, sə́ á ka wú nə byɔ́ɔ́l dʉ́sʉ́ bwúŋʉ́d, sə́ mú bɛ̧ zhɨ́ɨ́ tʉ́təlí kə Kos. Mán mələ̂m sə́ mú kə Rodɛs, sə́ wú Rodɛs kə Patara. ");
INSERT INTO mcp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Sə́ mú kə kwey dúl byɔ́ɔl ŋgə́ cɛɛl kə Fenisî, sə́ mú bád cínɔŋgʉ́ kyey. ");
INSERT INTO mcp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sə́ mú ŋgə kə nə́ ndɛɛ́ sə́ mú dʉ́g Shíprə ŋgə́ nyîn sə́ shwóg. Sə́ mú sásʉlə Shíprə, sə́ kə kɔ́ɔ́mb Sirî nə́ ndɛɛ́ sə́ kə səl byɔ́ɔ́l Tir wú í á bə nə́ í kə́ shul ísâ wá. ");
INSERT INTO mcp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Sə́ á ji cínɔŋgʉ́ mwɔ̂w zaŋgbá nəcé sə́ á kwey bɔ́ɔ́l óbúgʉla cínɔŋg. *Ompwíín bɔɔŋgʉ́, Ŋkɛ̧́ŋkɛ̧̂ Shíshim í á tɔ̂w bwo lúúd bwə́ mú cɨ nə Pwôl nə́ á kú bád kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nda mwɔ̂w sə́ á jəla nə ji cínɔŋgʉ́ mə́ á shîn nə́, sə́ á tɨ́ njɔɔnd. Obúgʉla bɛ̂sh nə budá nə ikágə́ bwə́ mú kə ŋgə lʉ́gal sə́ kə cúwo ŋgwə́la dɨ́ tɔ́ɔ́n. Ja sə́nɔ́ŋ mə́ kə wɔ́ɔ́s ncindye mâŋ yí, sə́ bɛ̂sh sə́ mú kúd mə́bwóŋ shí jəgʉla nə Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sə́nɔ́ŋ sə́ mú shîn jə́na. Sə́ mú kə byɔ́ɔ́lʉ́d, bâŋ bwə́ mú nyiŋgə kə kwáádə́. ");
INSERT INTO mcp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sə́ bâŋ, tɨ́lə sə́ á tɨ́ Tir yí, sə́ á kə səl byɔ́ɔ́l Tolemayis, sə́ bə́da óbúgʉla sə́ á kwey wú sə́nɔ́ŋ sə́ mú já jwɔ̂w ŋgwúd. ");
INSERT INTO mcp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mán mələ̂m, sə́ mú kyey. Sə́ kə nə́ ndɛɛ́ kə wɔ́ɔ́s Sezarê, sə́ mú kə nyíi wə́ Fílíp mbwiiŋgyɛ lâŋ mə Yésus nyə á bə ŋgwɔ́l múúd á buud zaŋgbá bwə́ á fééshɔw Yurʉ́səlɛm wá. Sə́ mú ji cínɔŋg nyə́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nyə á bə nə məsás mə́nɔ̧̂ mə́ njúl oncwíyɛ̂, məsás mɔɔŋg mə́ á dʉ cúndə micúndə́ mí Zɛmbî. ");
INSERT INTO mcp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nda sə́ á ji cínɔŋgʉ́ ŋkí bwey jiya nə́, ŋgwɔ́l *múúd micúndə́ mú wɔ́ɔ́s wúlə Yudéa, nyə nə jínə́ nə́ Agabus. ");
INSERT INTO mcp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A mú zə sə́dɨ́, a ŋwa kandá mə Pwôl, a wɔ́ɔlə nyə́mɛ́fwó məkuú nə məbwə̂ nə ndɛɛ́ a mú cɨ nə́: «Ŋkɛ̧́ŋkɛ̧̂ Shíshim ŋgə cɨ nə́ muud jɨ́ nə kandá ɛ́ga yɛ́, ntʉ́ga wə́ *Oyúdɛn bwə́ é kə wɔ́ɔlə nyə Yurʉ́səlɛm yɛ́, bwə́ kɛɛnzh nyə məbwə̂ mə́ íkûl ishúsʉ́d.» ");
INSERT INTO mcp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nda sə́ á gwág ntɔ́ nə́, nə sə̂, nə obúgʉla wâ Sezarê sə́ bɛ̂sh sə́ á tɛ́ɛ́g Pwôl məbwə̂ nə́ a kú bád kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nə́ ndɛɛ́ Pwôl mú bɛ̧sa nə sə́ nə́: «Nəcé jɨ́ bɨ́ é zə bɛ́wʉli mə lâm nə yə́ bɨ́ ŋgə́ jɨɨ nə yí? Mɛɛ mə jɨ ŋkwəmʉsá nə́ bwə́ wálʉ́lə́g mə məŋkəda nûŋ Yurʉ́səlɛm, tɔɔ bwə́ gwú ntâg mə jínə́ mə́ Yésus dɨ́, bwə́ gwúg.» ");
INSERT INTO mcp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nda nyə á shígɛ́ magʉlə sâ sə́ á ŋgə cɨ yí nə́, sə́ á shígɛ́ nə́mə́ kwo nándʉlə nyə, sə́ mú shwal cɨ nə́: «Í sɨ́yʉ́g nda Cwámba mə cɛ́ɛl nə́.» ");
INSERT INTO mcp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mpʉ́sə baalɛ́ mwɔ̂w, sə́ á ka kwəmʉsa nə́ ndɛɛ́ sə́ mú kyey bádʉ́lə kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bɔ́ɔ́l ómpwíín wâ Sezarê bwə́ mú nyíi sə́dɨ́ gwooŋgʉd. Bwə́ mú kə nə sə́ wə́ ŋgwɔ́l muud Shíprə nyə á bwey bə *mpwíín yɛ́ nə́ sə́ jígʉ nyə́dɨ́ njɔ́w. Muud wɔɔŋgʉ̂ nyə á bə nə jínə́ nə́ Mʉnason. ");
INSERT INTO mcp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ja sə́ á kə wɔ́ɔ́s Yurʉ́səlɛm yí, omínyɔŋʉ̂ bʉ́sʉ́ wâ búgə́ bwə́ á lə́g sə́ nə məshusʉg. ");
INSERT INTO mcp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mán mələ̂m, Pwôl mú kə nə sə́ wə́ Zhâk, ocúmbá buud bwə́ mú nə́mə́ wɔ́ɔ́s. ");
INSERT INTO mcp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pwôl mú bə́da bwo nə́ ndɛɛ́ a mú ká zə jaaw bwo bímbí Zɛmbî nyə á balan nə nyə ikûl ishúsʉ́d yí. Nyə á ŋgə bwiiŋg sâ jɛ̂sh a ŋgə́ fɛ́ɛl. ");
INSERT INTO mcp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bwə́ mú dʉ gwágʉlə nyə nə́ ndɛɛ́ bwə́ mú ságʉsə Zɛmbî, bwə́ mú cɨ nə nyə nə́: «Mwaaŋg, wo mə́ dɨ́ dʉ́g bímbí lʉ́ ncúlyá Oyúdɛn bwə́ mú obúgʉla yí, bɛ̂sh milúu myáŋ mísə ná Mə́cɛ̧ɛ̧ mə́ Moyîz dɨ́ nə́ tɨ́ny. ");
INSERT INTO mcp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bwə́ mə́ shîn gwádʉga lâŋ í ŋgə́ kyey yí nə́ wo ŋgə jɨ́ɨ́gʉli Oyúdɛn bʉ́sə ikûl íkûl dɨ́ wá nə́ bwə́ bɨ́dʉ́g məcɛ̧ɛ̧ mə́ Moyîz kú ná kwo bɛ̧ mwo. Wo ŋgə nə́mə́ cɨ nə bwo nə́ bwə́ kú ná ŋgə sá bwân báŋ ábɨwáág, bwə́ kú ná ŋgə bɛ̧ ijâm nə ijag bísʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Jâŋ wə́ jɨ́? Bwə́ é gwádʉga nə́ wo mə́ zə. ");
INSERT INTO mcp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Gwə́ wə́ jɨ́ nə́, ság sâ sə́ mə́ zə́ jaaw wo ga. Bɔ́ɔ́l búúd bʉ́sə wa ónɔ̧̂ bwə́ ámə də ómbyûl. ");
INSERT INTO mcp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ŋwag bwo bɨnɔ́ŋ kə́g gusa ŋgusa íci, wo ka jə́na mətâŋ mʉ́n mɛ̂sh shú nə́ bwə́ kɛ̧́nyag milúu. Ja jɔɔŋg, buud bɛ̂sh bwə́ é mpu nə́ lâŋ í ŋgə́ kyey shú dwô dɨ́ yí wúsə ijɔ̧́ɔ̧́, wo ŋgə ná bɛ̧ Məcɛ̧ɛ̧ mə́ Moyîz. ");
INSERT INTO mcp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Shú bɔɔŋg búúd bwə́ cúgɛ́ Oyúdɛn njɨ bwə́ á mə́ *búgʉla Yésus wá, sə́ á shí bwey ŋwa mícígʉ́lá, sə́ mú cilə bwo nə́ bwə́ cíg ocúdú ɔ́ *mə́túnʉga mə́ ívʉgʉli í ózɛmbî ɔ́ áyadʉ́g, bwə́ yɔw dʉ́lə də mə́cií, nə dʉ́lə də míshwun mí shígɛ́ shwɨy mə́cií myá, bwə́ yɔw jaŋga.» ");
INSERT INTO mcp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ntɔ́, jwɔ̂w í á bɛ̧ yí, Pwôl nyə á ŋwa buud bɔɔŋg, bə́nɔ́ŋ bwə́ kə gusa ŋgusa íci nə́ ndɛɛ́ a mú ka zə nyíi *Luŋ mə́ Zɛmbî zə́lə jaaw jwɔ̂w ŋgusa íci wɔɔŋg í bá shîn yí, jwɔ̂w múúd yɛ̂sh mə bá lwágʉlə sâ á kɛ́ɛ́nzh yí. ");
INSERT INTO mcp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ja í á ka ŋgə bə nə́ mwɔ̂w zaŋgbá mə́nɨ mə́ zə́ shîn yí, *Oyúdɛn wâ Azî bwə́ mú dʉ́g Pwôl *Luŋ mə́ Zɛmbî dɨ́ cwû. Bwə́ mú shwambʉlə búúd bɛ̂sh nə́ ndɛɛ́ bwə́ mú bií nyə. ");
INSERT INTO mcp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bwə́ mú ŋgə kɨ̂m nə́: «Bag ɔ́ *Izʉrəyɛ̂l, oshwoŋ, zəgá, muud ɛ́ga wə́ ŋgə́ lúmbʉli nə kúl buud jísʉ́ nə məcɛ̧ɛ̧ mə́sʉ́ nə Luŋ ga. A ŋgə lúmbʉli nə sə́ mínjɨ́ɨ́gʉ́lá myɛ́ á ŋgə́ jɨ́ɨ́gʉli buud bɛ̂sh kʉ́l jɛ̂sh yííd. Nyə a bə́lɛ nə́mə́ zə nyíŋgal Ogʉrɛ̂k wâ Luŋ, a mə́ wá mə́lwaagʉwo wa fééshá kʉ́l gaád.» ");
INSERT INTO mcp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Nda bwə́ á ŋgə dʉ́g Pwôl bá Trofîm muud Ifɛ̂z ŋgwə́la nə́, bwə́ á tə́dʉga nə nyə a nyíŋgal nyə Luŋ. ");
INSERT INTO mcp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ŋgwə́la wɛ̂sh í mú tɔ̂w nə́ shwuu, buud bwə́ mú zə wɔ́ɔ́s áncuncuma. Bwə́ mú bii Pwôl, bwə́ julə wú nə nyə Luŋ mə́ Zɛmbî, bwə́ lɛɛl ntâg fad mímpumbɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nda bwə́ á ŋgə sɔ̧́ nə́ bwə́ gwú nyə nə́, lâŋ í mú kə wɔ́ɔ́s wə́ lúlúú á ózɨmbɨ tɔ́ɔ́shin í á ŋgə jwú cínɔŋg yí nə́: «Yurʉ́səlɛm yɛ̂sh músə nə́ shwuu.» ");
INSERT INTO mcp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nə́mə́ cé nə cé, a mú ŋwa ózɨmbɨ nə milúlúú mí ózɨmbɨ təd, bə́nɔ́ŋ bwə́ mú kə nə mikʉ́lə́ wú búúd bwə́ á bii Pwôl wá. Njɨ búúd bɔɔŋg bwə́ á dʉ́g lúlúú ózɨmbɨ tɔ́ɔ́shin nə bɔ́ɔ́l ózɨmbɨ yí, bwə́ á yɔw yídʉ́lə Pwôl. ");
INSERT INTO mcp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lúlúú á ózɨmbɨ tɔ́ɔ́shin músə shísh nyə́dɨ́, mamʉsə bií nyə, cɨ nə́ bwə́ wálʉ́lə́g nyə nə mikwoolú mí íŋkwánz mímbá. A mú ka ŋgə jî nə́ a mpúg nə́ muud wɔɔŋg wə́ zə́? Jɨ́ nyə́ ámə sá yí? ");
INSERT INTO mcp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Njɨ, na mə́ŋkúmbə mə búud dɨ́, í á bə nyâŋ ŋgə́ kɨ̂m jé, nyâŋ ŋgə́ kɨ̂m jé. Kakʉ́lə jɔɔŋg mú sá nə́ lúlúú ózɨmbɨ kú wámbʉlə sâ í ámə sɨ̂y yí. A mú ntâg cɨ nə́ bwə́ kə́g nə Pwôl luŋgʉla ízʉmbid. ");
INSERT INTO mcp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ja Pwôl nyə á kə kumə ícé í mə́kuú yâ bádʉ́lə njɔ́w yí, ózɨmbɨ bwə́ á ŋkɛ̂ny nyə gwɔ̂w nəcé buud bwə́ á bə njɨ nə́ bwə́ sá nyə bɔ̂w, ");
INSERT INTO mcp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","nəcé, bɛ̂sh bwə́ á ŋgə bɛ̧ nyə bwə́ ŋgə́ kɨ̂m nə́: «A jəlá nə yə!» ");
INSERT INTO mcp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ja í á ka bə nə́ bwə́ wál zə nyíi nə Pwôl luŋgʉla ízɨmbɨ dɨ́ yí, Pwôl mú cɨ nə lúlúú á ózɨmbɨ tɔ́ɔ́shin nə́: «Ye mə jɨ nə ŋkul cɨ wo ciyá?» Lúlúú ózɨmbɨ nə́: «O! wo mpú dʉ lás Gʉrɛ̂k ɨɨ́? ");
INSERT INTO mcp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ntɔ́ jɨ nə́ wo dɨ́ mwân Igîpten nyə á ndəm zə wá zhizhɔɔm wa nə́ ndɛɛ́ a mú kə nə izhilʉŋgaanə́ otɔ́ɔ́shin onɔ̧̂ shí a shwééshá dɨ́ yɛ́?» ");
INSERT INTO mcp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pwôl mú bɛ̧sa nə nyə nə́: «Mɛɛ mə jɨ mwâ *Yúdɛn á Tárʉs, shí á Silisî. Mə jɨ muud á ŋgwə́la wúsə́ kú bə zhizhe ŋgʉ́ŋgwə́lá yí. Mə́ jəgʉla nə wo nə́ wo yə́g mə́ fwála, mə fwóg lésha nə buud ɔ́ga.» ");
INSERT INTO mcp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nda bwə́ á magʉlə nə́ a lásʉ́g nə́, Pwôl nyə á ka tɔ̂w na ícé í mə́kuú yâ bádʉ́lə njɔ́wʉ́d, a mú fʉfə búud mbwə̂. Buud bɛ̂sh bwə́ mú ji kʉ́l-kʉ̂l nə́ kufʉg. Pwôl mú tɛ́ɛ́d lásʉ́lə nə bwo kə́l lʉ́ hebʉrə̂ dɨ́, nyə nə́: ");
INSERT INTO mcp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Yé bwááŋg nə odâ, gwágʉ́lə́gá kɔɔd mə́ zə kaad bɨ́dɨ́ míshʉ́d yí.» ");
INSERT INTO mcp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ja buud bwə́ á gwág nə́ Pwôl ŋgə lésha nə bwo kə́l lʉ́ hebʉrə̂ dɨ́ yí, bwə́ á nyíŋgə mpu ji okʉ́l-ókʉ̂l nə́ kufʉg. ");
INSERT INTO mcp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Mə jɨ mwân *Yúdɛn. Mə a byɛ̂l Tárʉs á Silisî, njɨ mə á wɔɔf wa ŋgwə́la gaád, mə ŋwa nə́mə́ njɨ́ɨ́gʉ́lá wa wə́ Gamalyɛl. Njɨ́ɨ́gʉ́lá wɔɔŋg í á bə njɨ́ɨ́gʉ́lá á nə́ mə á bɛ̧ məcɛ̧ɛ̧ mə́ impáámbə́ bíshé mbií í á jəla yí. Mə a wá nə́mə́ lúú ázɛmbî dɨ́ nda mə dʉ́g bɨ́ ŋgə́ sá múús ɛ́ga. ");
INSERT INTO mcp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Buud bɛ̂sh bwə́ á bɛ̧ zhɨɨ́ ga wá, mə a lwágʉlə bwo cúwʉ́lí á shwɨy. Mə á dʉ bií bwo, dʉ wɔ́ɔlə bwo, dʉ wusə bwo mímbwugʉd, tɔɔ budûm tɔɔ budá. ");
INSERT INTO mcp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ajəlácɨ á ofada nə ocúmbá buud ɔ́ ázɛmbî bɨ́ nə ŋkul mpu bwiiŋg lâŋ wâm. Bwə́ wə́ bwə́ á yə mə okálaad shú bwááŋg wâ Damás. Mə mú ká zə kə wu nə́ mə kə́ bií bɔɔŋg wâ nûŋ mə zə nə bwo wa Yurʉ́səlɛm nə́ bwə́ zə́g bwəma nə intʉ́gʉ́lí. ");
INSERT INTO mcp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Í á ka bə nə mə, mə ŋgə́ shísh Damás, ŋgɛɛ tâm mwásə́, yáág-yáág mə́ŋkɛnya mú zhu joŋ dɨ́, zə lyɛ̧ mə. ");
INSERT INTO mcp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mə mú kadʉwa shí, mə mú gwág kə́l í ŋgə́ cɨ nə mə nə́: “Sôl, Sôl, nəcé jɨ́ wó búl lwágʉlə mə cúwʉ́lí ntʉ́nɨ yí?” ");
INSERT INTO mcp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mə mú jî nə́: “Cwámba, wo zə e?” Nyə nə mə nə́: “Mə Yésus á Nazarɛ̂t, mə wə́ wó ŋgə́ lwágʉlə cúwʉ́lí yɛ́.” ");
INSERT INTO mcp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Buud ɔ́ gwooŋg bâm bwə́ á dʉ́g məŋkɛnya njɨ bwə́ kú gwág kə́l í á ŋgə lás nə mə yí. ");
INSERT INTO mcp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mə mú cɨ nə́: “Cwámba e, mə sáág jɨ́?” Cwámba nə mə nə́: “Wɔɔlʉ́g wo kə́g Damás. Nûŋ wə́ bwə́ é kə jaaw wo sâ jɛ̂sh Zɛmbî mə́ cɨ nə́ wo sáág yí é.” ");
INSERT INTO mcp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nda mísh mə́ á ntáma mə nə məŋkənʉwa mɔɔŋg nə́ mə á ka wú na, kumə Damás buud ɔ́ gwooŋg bâm bwə́ ŋgə́ bii mə mbwə́d. ");
INSERT INTO mcp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Ŋgwɔ́l múúd nyə á bə nûŋ nə́ Ananíyas, nyə á dʉ gwɔ̧́ɔ̧ Zɛmbî nda məcɛ̧ɛ̧ mə cɨ̂ nə́. Oyúdɛn bɛ̂sh bwə́ á bə nûŋ wá bwə́ á dʉ ságʉsə nyə. ");
INSERT INTO mcp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Muud wɔɔŋgʉ̂ nyə á ka zə kwey mə kʉ́l mə á bə yí, nyə nə mə nə́: “Mwááŋg Sôl e, mísh mə́ báŋʉ́g wo.” Nə́mə́ cé jɔɔŋgʉ̂ dɨ, mísh mə́ mú dʉ́gya mə, mə mú dʉ́g nyə. ");
INSERT INTO mcp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","A mú cɨ nə mə nə́: “Zɛmbî odâ nyə a fɛ́ɛ́sh wo nə́ wo mpúg tə́dʉ́gá yé, wo dʉ́g tʉ́təlí múúd, wo gwág lə́sʉ́ á mpu yé. ");
INSERT INTO mcp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nəcé wo bá bə wúshinɛd yé, bwiiŋg búud bɛ̂sh isâ wó mə́ dʉ́g nə byɔɔŋg wo mə́ gwág shú dɛ́ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nə́ ndɛɛ́, kú ná kwo bwánd. Tɔ́wʉ́g, wo kámbʉ́g jínə́ dɛ́, wo duwan, wo mú bii íjuugá í *mísə́m myô.” ");
INSERT INTO mcp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Mə á ka nyiŋgə kə Yurʉ́səlɛm. Í á ka kə bə nûŋ dúl jwɔ̂w dɨ, mə ŋgə́ jəgʉla *Luŋ mə́ Zɛmbî dɨ́ cwû, mə seegya mə músə nda *shíshim wâm mə́ wú mə́dɨ́ nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mə mú dʉ́g Cwámba ŋgə́ cɨ nə mə nə́: “Nə́ câ! Lɛɛlʉgʉ́ cúwo wú wa Yurʉ́səlɛm. Nəcé buud ɔ́ wa bwə́ ámagʉləyɛ́ lâŋ wó é bwiiŋg shú dâm yí.” ");
INSERT INTO mcp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mə mú cɨ nə nɛ́ nə́: “Cwámba, bwə́ bwey mpu nə́ mə á dʉ kə *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ Oyúdɛn dɨ̂ kə dʉ bii búud bwə́ á dʉ *búgʉla wo wá dʉ wá bwo mímbwug dɨ́, dʉ yíd bwo nə milwóŋ. ");
INSERT INTO mcp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ja gwə́mɛ́fwó bwə́ á gwú wúshinɛd woó Itiyɛn yí, mə á bə cínɔŋg mə ŋgə́ magʉlə buud bwə́ á ŋgə gwú nyə wá, mə wə́ mə á ŋgə baagʉlə bwo mikáándə́.” ");
INSERT INTO mcp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Cwámba mú cɨ nə mə nə́: “Kaág, mɛɛ mə zə́ kənd wo shwóg-shwóg, ílwoŋ í cúgɛ́ Oyúdɛn yííd.”» ");
INSERT INTO mcp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Buud bwə́ á ŋgə gwágʉlə nyə nə́ ndɛɛ́ zə wɔ́ɔ́s ja nyə á cwééd iciyá ínɨ yí, bwə́ mú kɨ̂m gwɔ́w-gwɔ̂w nə́: «Jímbálʉ́gá mbií múúd nɨ! A yə́g! Nyə ajə́láyɛ́ nə ji shí gaád!» ");
INSERT INTO mcp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bwə́ mú ŋgə kɨ̂m, bwə́ ŋgə́ tɨ́ mikáándə́, bwə́ dʉ myɛɛg mífumbyâ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Lúlúú á ózɨmbɨ tɔ́ɔ́shin mú cɨ nə́ bwə́ nyíŋgálʉ́g nyə luŋgʉla ízɨmbɨ dɨ́, bwə́ kə́g yíd nyə nə milwóŋ, a jááwʉg sâ bwə́ ŋgə́ shwaag nə nyə ntɔ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nda bwə́ á wɔ́ɔlə nyə nə mikwoolú mí kúúdú nə́ bwə́ zə́ fyámʉsə nyə milwóŋ nə́, a mú jî lúlúú ózɨmbɨ təd í á bə cínɔŋg yí nə́: «Ye bɨ bʉ́sə nə zhɨɨ́ nə́ bɨ yídʉ́g muud a njúl muud á Róma a kú nə́mə́ fwo kaad lə́sʉ́?» ");
INSERT INTO mcp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lúlúú á ózɨmbɨ təd mú gwág ntʉ́nɨ, a mú kə jaaw lúlúú ózɨmbɨ tɔ́ɔ́shin, nyə nə nɛ́ nə́: «Wo e sá ntʉdɛl! Muud ɛ́nɛ jɨ bə́lɛ bə múúd lɔɔm á Róma!» ");
INSERT INTO mcp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lúlúú á ózɨmbɨ tɔ́ɔ́shin mú kə jî Pwôl nə́: «Jaawʉ́g mə. Wo jɨ bə́lɛ bə múúd lɔɔm á Rómǎ?» Pwôl nə: «Haaw». ");
INSERT INTO mcp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Lúlúú á ózɨmbɨ tɔ́ɔ́shin mú cɨ nə nɛ́ nə́: «Mɛɛ mə a wá zhwog *mwaanɛ̂ shú nə́ bwə́ mágʉləg nə́ mə bə́g muud á Róma.» Pwôl nə́: «Mɛɛ mə jɨ mbyágá.» ");
INSERT INTO mcp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Buud bwə́ á bə nə́ bwə́ zə yíd Pwôl a lásʉ́g wá bwə́ mú shîn kyey. Ifwaas í mú bii lúlúú á ózɨmbɨ tɔ́ɔ́shin nə a zə́lə mpu nə́ muud lɔɔm á Róma wə́ á mə́ sá nə́ bwə́ wálʉ́lə́g ŋkəda ɛ́nɛ. ");
INSERT INTO mcp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lúlúú á ózɨmbɨ tɔ́ɔ́shin nyə á bul yáág nə́ a mpúg sâ *Oyúdɛn bwə́ á ŋgə bwaagʉlə Pwôl nə́ nyə ámə sá yí. Ntɔ́, mán mələ̂m nyə á wiinzh Pwôl məŋkəda, a jɔ̂w milúlúú myâ ofada nə *Gwooŋg ósémbye ɔ mílə́sʉ́ wâ Zɛmbî bɛ̂sh bwə́ zə sɛɛŋgya. A músə ka zə nə Pwôl zə tə́l bwo míshʉ́d nə́ a káádʉg. ");
INSERT INTO mcp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pwôl mú bʉ̂n mísh dʉ́g *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî, a mú cɨ nə́: «Bwaaŋg, mə ŋgə sɛ̂y nə Zɛmbî lâm nə́ sáŋ zə wɔ́ɔ́s múús.» ");
INSERT INTO mcp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananíyas, Ajəlácɨ á ofada, mú cɨ nə buud bwə́ á bə nyə kúnə́-kúnə wá nə́ bwə́ nyífə́g nyə bɔ́ɔ́nz mpud. ");
INSERT INTO mcp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pwôl mú cɨ nə nyə nə́: «Wo jɨ nda mbɛɛ́ fifim bwə́ mə́ shîn wá fə́m yí. Zɛmbî nyə é yíd wo. Wo mə́ zə ji na shí nə́ wo zə́ sámb mə lə́sʉ́ nda mə́cɛ̧ɛ̧ mə́ jɨ́ nə́, njɨ wo abɛ̧́ɛ̧́yɛ́ sâ mə́cɛ̧ɛ̧ mə ŋgə́ cɨ yí, wo yida lwâm nə́ bwə́ yídʉ́g mə.» ");
INSERT INTO mcp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Buud bwə́ á bə cínɔŋg wá bwə́ mú cɨ nə nyə nə́: «Wo lwîy Ajəlácɨ á ofada ɔ Zɛmbî?» ");
INSERT INTO mcp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pwôl nə́: «Bwaaŋg, mə shígɛ́ mpú nə́ jísə Ajəlácɨ á ofada. Mə mpú nə́ jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́: “Wo ajə́láyɛ́ nə lwîy tɔ́we shwóg á kúl búúd gwô.”» ");
INSERT INTO mcp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nda Pwôl nyə á mpu nə́ buud bʉ́sə́ na Gwooŋg ósémbye ɔ mílə́sʉ́ dɨ wá bʉ́sə bɔ́ɔ́l *Osadwisyɛ̂ŋ bɔ́ɔ́l *Ofarizyɛ̂ŋ nə́, nyə á kɨ̂m cínɔŋg cwû nə́: «Bwaaŋg, mə jɨ Farizyɛ̂ŋ, mwân Ofarizyɛ̂ŋ. Mə təl kɔɔdʉd nəcé mə ŋgə́lə bwánd nə búgə́ nə́ mimbimbə mí bá gwûm.» ");
INSERT INTO mcp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nə́mə́ njɨ nyə á cɨ ntʉ́nɨ yí, Ofarizyɛ̂ŋ bə́nɔ̂ŋ Osadwisyɛ̂ŋ bwə́ mú sɛ́ŋʉsa mə́kə̂l, gúfʉ́gá ósémbye ɔ mílə́sʉ́ í mú bɔ́ɔ́g mə́ŋkɔw məbá. ");
INSERT INTO mcp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nəcé Osadwisyɛ̂ŋ bâŋ bwə́ dʉ cɨ nə́ muud mə́ yə yɛ́ cugɛ́ nə ŋkul kwo gwûm, sâ bwə́ jɔ́w nə́ *éŋgəles yí í cúgɛ́, gúl sâ cúgɛ́ nə́mə́ nə́ *jîm. Ofarizyɛ̂ŋ bâŋ bwə́ dʉ magʉlə ísâ byɔɔŋg byɛ̂sh nə́ bísə. ");
INSERT INTO mcp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Í músə zə bə bwo nda zhuyâ. Bɔ́ɔ́l *Oyɨ́ɨ́gʉli ɔ́ mə́cɛ̧ɛ̧ bwə́ á bə Ofarizyɛ̂ŋ wá bwə́ mú tɔ̂w ótʉ́təlí ŋgə lás nda bwə́ tɨ́ mə́nyúul, bwə́ nə́: «Sə́ bâŋ sə́ adʉ́gɛ́ nə́ muud ɛ́ga jɨ nə gúl sâ mə́bɛ̧ɛ̧́. Jɨ́ nə ŋkul bə nə́ wúl shíshim í ámə lésha nə nyə, ŋkí ntâg ŋgwɔ́l éŋgəles.» ");
INSERT INTO mcp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Zhuyâ músə bul yáág. Nə ndɛɛ́ lúlúú á ózɨmbɨ tɔ́ɔ́shin mú fúndə nə́ bwə́ á bá nyaa Pwôl nə məbwə̂. A mú cɨ nə ozɨmbɨ nə́ bwə́ shúləg kə nûŋ kə yîl Pwôl kə nə nyə bwə́dɨ́ kɔ́ɔ́gʉ́lə́d. ");
INSERT INTO mcp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Búlú í á bɛ̧ cínɔŋg yí, Cwámba mú zə wɔ́ɔ́s wə́ Pwôl, zə cɨ nə nyə nə́: «Wo ɔ wá ŋkûl. Wo mə́ bwaagʉlə lâŋ wâm wa Yurʉ́səlɛm, í jɨɨ nə́ wo kə́g nə́mə́ bwaagʉlə wə Róma.» ");
INSERT INTO mcp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mán mələ̂m, bɔ́ɔ́l *Oyúdɛn bwə́ á sá shwushwaga. Bwə́ ci ídʉ̂w nə məŋgul, bwə́ nə́, ŋkí bwə́ agwúyɛ́ Pwôl bwə́ bə nə məzhúŋgʉ́lú. ");
INSERT INTO mcp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Buud bwə́ á sá kúdúgú jɔɔŋg wá bwə́ á bə buud cɔ̧́ məwûm mə́nɔ̧̂. ");
INSERT INTO mcp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bwə́ á ka kə dʉ́gya nə milúlúú myâ ofada nə ocúmbá buud, kə cɨ nə bwo nə́: «Sə́ mə́ jɔ̂w mə́zhúŋgʉ́lú sə́dɨ́ ícʉg dɨ́, sə́ mə́ ci idʉ̂w nə məŋgul kə wɔ́ɔ́s ja sə́ é gwú Pwôl yí. ");
INSERT INTO mcp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Í jɨɨ já gaád nə́ bɨnɔ́ŋ *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî bɨ dʉ́gyág nə lúlúú á ózɨmbɨ, a zə́g nə Pwôl bɨ́dɨ́ nə́ bɨ mə zə́ faas lə́sʉ́ yé. Sə́ mə́ shîn kwəmʉsa nə́ sə́ é gwú nyə a nda fwo kumə́ bɨ́dɨ́.» ");
INSERT INTO mcp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pwôl táá yé í á ka gwág kúdúgú jɔɔŋg. A músə kə nyíi luŋgʉla ízɨmbɨ dɨ́ kə jaaw Pwôl. ");
INSERT INTO mcp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pwôl mú jɔ̂w ŋgwɔ́l tɔ́we shwóg á izɨmbɨ, zə cɨ nə nyə nə́: «Kaág nə ncwə́má ga wə́ lúlúú á ózɨmbɨ tɔ́ɔ́shin, a jɨ nə sâ á kə́ jaaw nyə yí.» ");
INSERT INTO mcp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tɔ́we shwóg ɛ́nɛ mú kə nə ncwə́má nɨ wə́ lúlúú á ózɨmbɨ kə lwóya nyə nə́: «Pwôl jɨ́ mímbwug dɨ́ yɛ́ nyə́ ámə jɔ̂w mə, a mú ntɨ́ mə nə ncwə́má ga nə́ a zə́g jaaw wo gúl sâ.» ");
INSERT INTO mcp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lúlúú á ózɨmbɨ mú bii ncwə́má nɨ mbwə́d kə nə nyə koogʉ́ kə jî nyə nə: «Jɨ́ wó cɛ́ɛ́l jaaw mə yí?» ");
INSERT INTO mcp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A mú bɛ̧sa nə nɛ́ nə́: «Oyúdɛn bwə́ mə́ shîn kwambʉlə nə́ bwə́ zə́ cɨ nə wo nə́ wo kə́g nə Pwôl mán Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî dɨ́ nda bwə́ cɛɛl kə faas lə́sʉ́ yé. ");
INSERT INTO mcp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wɛɛ kú bá magʉlə. Bʉ́sə buud cɔ̧́ məwûm mə́nɔ̧̂ bwə́ ŋgə́ bwéél nə́ bwə́ gwú nyə wá. Bwə́ mə́ ci ídʉ̂w, ci mə́lwəg, jɔ̂w nə́ bwə́ bə́g nə mə́zhúŋgʉ́lú icʉg byáŋʉ́d ŋkí bwə́ bə́ kú gwú nyə. Bwə́ ŋgə bwánd njɨ nə́ wo mágʉləg sâ bwə́ cɨ́ yí, bwə́ mə́ bwey kwəmʉsa.» ");
INSERT INTO mcp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Lúlúú á ózɨmbɨ tɔ́ɔ́shin músə bɨ́d mwân ncwə́má, nyə nə nɛ́ nə́: «Ci wo kú jaaw múúd nə́ wo mə́ shîn zə lwágʉlə mə kúdúgú ga.» ");
INSERT INTO mcp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","A mú jɔ̂w milúlúú mímbá myâ ozɨmbɨ təd, nyə nə bwo nə́: «Kwəmʉsagá ozɨmbɨ mitəd mímbá, nə bɔɔŋg bwə́ dʉ ju nə ikabʉlí wá məwûm zaŋgbá nə ifulísh mitəd mímbá bwə́ bâg zə kə Sezarê mə́wəla ibuú mâ mpwó-bulú dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bwə́ kwə́mʉsag nə́mə́ íkabʉlí shú nə́ bwə́ kə́g nə Pwôl a kú shwúg jús kú bwɨɨm bɔɔgʉ́ kə wɔ́ɔ́s nə nyə wə́ ŋgwə́mʉna Felígʉ́s.» ");
INSERT INTO mcp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","A mú cilə kálaad ntʉ́ga: ");
INSERT INTO mcp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Mə Klódyus Lísyas, mə́ cilə lwám ŋgwə́mʉna Felígʉ́s. Wo ɔ lás ɔ! ");
INSERT INTO mcp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Muud mə́ ŋgə́ ntɨ wo ɛ́ga, Oyúdɛn bwə́ ámə bií nyə, bwə́ mú shîn bə nə́ bwə́ gwú nyə. Sə́nɔ̂ŋ ozɨmbɨ sə́ mú fɛɛmʉshi nyə nəcé sə́ ámə gwág nə́ a jɨ muud á Róma. ");
INSERT INTO mcp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mə ŋgə́ ka sɔ̧́ nə́ mə wámbʉ́lə́ cwoomb bə́nɔ́ŋ bwə́ yə́ nə ndɨ̂ yí, mə́ ámə kə nə nyə bwə́dɨ́ Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî dɨ́, ");
INSERT INTO mcp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","mə mú kwey nə́ bə́nɔ́ŋ bwə́ ŋgə sɛ́ŋʉsa mə́kə̂l ísâ í dʉ́gyá nə məcɛ̧ɛ̧ máŋ yí. A cugɛ́ nə məbɛ̧ɛ̧́ mɨ́ nə ŋkul sá nə́ bwə́ gwúg nyə ŋkí nə́ bwə́ wáág nyə mímbwug dɨ́ má. ");
INSERT INTO mcp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nda mə́ ámə ka gwádʉga nə́ bwə́ ŋgə bwéél nə́ bwə́ gwú nyə nə́, mə mə́ ka ntɨ́ wo nyə. Mə mə́ nə́mə́ jaaw búúd bwə́ ŋgə́ wáámb nyə wá nə́ bwə́ zə́g bwaagʉlə nyə məbɛ̧ɛ̧́ mɛ́ nûŋ wódɨ́. ");
INSERT INTO mcp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ozɨmbɨ bwə́ á ka sá nda ijwûga í á bə nə́, bwə́ mú ŋwa Pwôl kyey nə nyə bulú nə bulú kə́lə nə nyə Antipátris. ");
INSERT INTO mcp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mán mələ̂m, bwə́ mú bɨ́d nə́ bɔɔŋg bwə́ á ŋgə ju nə ikabʉlí wá bwə́ kə́g nə nyə shwóg, bâŋ bwə́ mú nyiŋgə nə mpʉ́sə kə luŋgʉla ízʉmbid. ");
INSERT INTO mcp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bɔɔŋg bwə́ á kə nə Pwôl wá bwə́ mú kə kumə Sezarê, bwə́ músə yə ŋgwə́mʉna kálaad, bwə́ lwágʉlə nə́mə́ nyə Pwôl. ");
INSERT INTO mcp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ŋgwə́mʉna mú lɔ̧́ kálaad nə́ ndɛɛ́ a mú jî Pwôl kɔ́ɔ́mb mpál shí kwáádə́ nyɛ́ nyísə́ yí. A mú gwág nə́ mpál shí á Silisî. ");
INSERT INTO mcp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","A mú cɨ nə Pwôl nə́: «Mə é bá gwágʉlə wo ja buud bɨ́nɔ́ŋ bʉ́sə́ nə lə́sʉ́ wá bwə́ bá zə yí.» A mú lwâm nə́ bwə́ kə́g jil nyə luŋ mə́ Herod dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mpʉ́sə mwɔ̂w mə́tɔ́ɔn ntʉ́nɨ, Ananíyas, Ajəlácɨ á ofada, bə́nɔ̂ŋ bɔ́ɔ́l ócúmbá buud nə ŋgwɔ́l lwóya bwə́ á dʉ jɔ̂w nə Tɛrtúlos yɛ́ bwə́ á wɔ́ɔ́s Sezarê. Bwə́ mú zə shwə́man Pwôl wə́ ŋgwə́mʉna. ");
INSERT INTO mcp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bwə́ mú jɔ̂w Pwôl. Tɛrtúlos mú tɛ́ɛ́d ŋgə́lə búgə nyə lə́sʉ́, nyə nə́: «Yé lwám múúd Felígʉ́s, wo wə́ mə́ sá nə́ sə́ búlʉg mpu cʉgə nə́ shɛɛ nəcé wóó mbií wó ŋgə́ kyey nə ijwûga yí, í mə́ mpu kwambʉlə lwoŋ buud jísʉ́. ");
INSERT INTO mcp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sə́ ŋgə lɔ̧́ wo kʉ́kʉ́l jɛ̂sh nə wəla dɛ̂sh shú jɔ̧jɔ̧ sɔ́ɔ́lʉ́gʉ́ wô wɔɔŋg. ");
INSERT INTO mcp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mə abʉ́lɛ́ ŋgə julə lwóŋ julə kwasa, mə́ tɛ́ɛ́g wo məbwə̂ nə́ wo gwágʉ́lə́g mə cíg-cîg nə́mə́ nda wo bwéy bə nə jɔ̧ fúlú nə́. ");
INSERT INTO mcp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Sə́ mə́ kwey nə́ muud ɛ́ga jisə ŋkí jág wagʉwo. Nyə wə́ jísə́ lúlúú á ŋkɔɔmʉ́ buud bwə́ jɔ́w nə́ buud ɔ́ Nazarɛ̂t wá, nyə wə́ ŋgə́ tə̂l *Oyúdɛn bɛ̂sh wâ shí mishwun nə́ shwuu. ");
INSERT INTO mcp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nyə a sɔ̧́ nə́mə́ nə́ a sɛ́ɛ́mbʉli *Luŋ mə́ Zɛmbî, sə́ mú ka bií nyə. Sə́ á jɨɨ nə́ sə́ mə lás lə́sʉ́ yé nda mə́cɛ̧ɛ̧ mə́sʉ́ mə́ ŋgə́ cɨ nə́. ");
INSERT INTO mcp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Njɨ Lísyas, lúlúú ózɨmbɨ tɔ́ɔ́shin nyə á lɛɛlʉ́ zə nə júdə́ zə dɛ́ɛ́g sə́ nyə, ");
INSERT INTO mcp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","a mú cɨ nə́ buud bə́nɔ́ŋ bʉ́sə́ nə lə́sʉ́ wá bwə́ zə́g bɛ̧ nyə wa wódɨ́. Ja wómɛ́fwó wó é ŋgə jî nyə mishílí mí kɔɔd yí wo é je magʉlə mə́bɛ̧ɛ̧́ mɛ̂sh sə́ ŋgə́ bwaagʉlə nyə má.» ");
INSERT INTO mcp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Oyúdɛn bwə́ mú mpu bwaagʉlə lə́sʉ́ nɨ wɛ̂sh nə́ ntɔ́ wə́ jísə́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ŋgwə́mʉna mú yə Pwôl lə́sʉ́, Pwôl mú cɨ nə́: «Mə mpú nə́ wo mə́ kyey nə lwoŋ jísʉ́ ga tʉ́təlí mimbú mimbû. Mə zə kaad kɔɔd wâm nə búgə́. ");
INSERT INTO mcp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mə ŋgə kúnɔw bád kə Yurʉ́səlɛm nə́ mə kə́ yə Zɛmbî gúmə́, í afwóyɛ́ sá mwɔ̂w wûm nə mə́bá. Wo jɨ nə ŋkul je fyal sə́ mə́ ŋgə cɨ ga. ");
INSERT INTO mcp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bwə́ abwɛ́lɛ́ kwey mə Luŋ mə́ Zɛmbî, ŋkí *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ Oyúdɛn dɨ̂, sá muud sə́ ŋgə́ sɛ́ŋʉsa məkə̂l ŋkí ntâg nə́ mə ŋgə́ wá zhizhɔɔm ŋgwə́la. ");
INSERT INTO mcp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Sâ jɛ̂sh bwə́ ŋgə́ cɨ mə nɨ, bwə́ cúgɛ́ nə ŋkul lwágʉlə nə́ jísə bʉ́bə́lɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Njɨ, mə mpú magʉlə wódɨ́ míshʉ́d nə́, na zhɨ́ɨ́ bwə́ mə́ jɔ̂w nə́ ŋkɔɔmʉ́ nɨ dɨ́ wə́ mə́ ŋgə́ yə Zɛmbî á impáámbə́ bísʉ́ gúmə́ yɛ́, mə ŋgə́ *magʉlə sâ jɛ̂sh jísə́ cilyá kálaad məcɛ̧ɛ̧ nə ókálaad ɔ *búúd ɔ mícúndə́ dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Sâ bwə́ ŋgə́ bwánd nə búgə́ nə́ Zɛmbî mə bá sá yí, gwə́ nə́mə́ wə́ mə́ ŋgə́ bwánd nə búgə́ yí. Jísə nə́ buud bwə́ bá gwûm, tɔɔ bɔɔŋg ɔ́ ányunywaâ, tɔɔ bɔɔŋg ɔ́ abʉ́bɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Gwə́ wə́ jɨ́ nə́, mɛɛ ŋgə wá ŋkul nə́ mitə́dʉ́gá myâ lâm mí bə́g mə tʉ́təlí ja jɛ̂sh mísh mə́ Zɛmbî nə mísh mə́ búúd dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mə a cɨ́ŋgʉli mimbû ŋkí bulya nə́ ndɛɛ́ mə á ka zə nə́ mə zə́ yə mímbúmbúwá myâ lwoŋ buud jâm mikwííndyá, mə kɛɛnzh nə́mə́ ílɨ́ɨ́m, ");
INSERT INTO mcp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ja jɔɔŋg wə́ bwə́ á kə kwey mə Luŋ mə mə́ shîn fyá nyúul. Í á bə ntâg kú nə gúfʉ́gá búud, kú nə icucu. ");
INSERT INTO mcp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Njɨ gúl bʉ́baalɛ́ Oyúdɛn wâ Azî wə́ bwə́ á bə, bwə́ wə́ bʉ́sə́ nə́ bwə́ zə́g tɔ̂w wo míshʉ́d shwə́man mə, ŋkí bʉ́sə nə sâ bwə́ lámʉsa nə mə yí. ");
INSERT INTO mcp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ŋkí ntɔ́ dɨ́, buud ɔ́ga, bɔɔŋg bwə́ tə́l ɔ́ga bwə́ jááwʉg ŋkí mə a shí biil nə wôŋ ja mə́ á kaad *Gwooŋg ósémbye ɔ́ mílə́sʉ́ wâ Zɛmbî dɨ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ye njɨ ciyá mə́ á cɨ mə tə́l tâm kɔɔd nə́: “Mə təl múús kɔɔdʉd nəcé mə ŋgə́lə magʉlə nə́ mimbimbə mí bá gwûm” yí?» ");
INSERT INTO mcp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felígʉ́s nywáá nyə á bwey bul mpu isâ í dʉ́gyá nə zhɨɨ́ Pwôl nyə á ŋgə bɛ̧ yí. Nyə á ka bɨ́d bwo nə́ bwə́ bâg shúgʉla zə, nyə nə bwo nə́: «Ja Lísyas lúlúú á ózɨmbɨ tɔ́ɔ́shin mə bá wɔ́ɔ́s yí, ja jɔɔŋg wə́ mə́ bá zə faas lə́sʉ́ wʉ́n yí.» ");
INSERT INTO mcp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","A mú cɨ nə lúlúú ózɨmbɨ təd nə́ a báágʉləg Pwôl, njɨ a bɨ́d nə́ a jéég ŋgə wiinzh nyúul, a kú kaambʉlə nə buud bɛ́ nə bwə́ kú zə dʉ́g nyə. ");
INSERT INTO mcp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Baalɛ́ mwɔ̂w mə́ mú cɔ̧́. Felígʉ́s bá mudá yé Drusîl shilə Oyúdɛn bwə́ njúl ntʉ́nɨ, a mú jɔ̂w Pwôl nə́ a zə́g jaaw bwo sâ í dʉ́gyá nə búgə́ búgʉ́lálə Yésus-Krîst yí. ");
INSERT INTO mcp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Njɨ, Pwôl mú ka ŋgə bul lás lə́sʉ́ cʉgə́lə cʉg á tʉ́təlí, dʉ́lə mpu bii lâm, nə lə́sʉ́ sémbyé mílə́sʉ́ í bá zə sɨ̂y yí. Felígʉ́s mú gwág íkukwɛndɛ, a mú cɨ nə Pwôl nə́: «Fwog je nyiŋgə jíga ja. Mə é bá kwo jɔ̂w wo ja shús.» ");
INSERT INTO mcp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nyə á ŋgə bwánd nə búgə́ nə́ Pwôl nyə é je yə nyə *mwaanɛ̂. Gwə́ wə́ í á sá nə́ a dʉ́g bul jɔ̂w nyə ija ija zə dʉ lésha nə nyə. ");
INSERT INTO mcp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Mimbû mí á cɔ̧́ mímbá. Porsyus Festos mú zə cɛ́nd Felígʉ́s. Nda Felígʉ́s nyə á ŋgə jɨ́ nə́ Oyúdɛn bwə́ gwágʉ́g nyə nywa nə́, nyə á kyey a lʉ́gə Pwôl mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festos nyə á ka wɔ́ɔ́s mpál shí jɔɔŋgʉ́d. A mú já Sezarê mwɔ̂w mə́lɔ́ɔl, a mú bád kə Yurʉ́səlɛm. ");
INSERT INTO mcp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nə milúlúú myâ ofada, nə otɔ́we ɔ shwóg wâ *Oyúdɛn bwə́ mú zə shwə́man Pwôl nyə́dɨ́, bwə́ tɛ́ɛ́g nyə məbwə̂, ");
INSERT INTO mcp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","nə́ a bwɨ́ɨ́gʉ́g bwo nə́ ŋkwoŋʉ́, a ntɨ́ɨ́g Pwôl Yurʉ́səlɛm. Í á bə bwə́ mə́ shîn cwɔ̧́ yuug nə́ bwə́ zə gwú nyə zhɨ́ɨ́d. ");
INSERT INTO mcp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festos mú bɛ̧sa nə bwo nə́ Sezarê wə́ Pwôl jɨ́ mímbwug dɨ́ yɛ́, nyəmɛ́fwó Festos mə zə́ nə́mə́ kə wu. ");
INSERT INTO mcp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nyə nə bwo nə́: «Otɔ́we ɔ shwóg bʉ́n bwə́ zə́g sə́nɔ́ŋ kə́g. Ŋkí gúl sâ abʉ́bɔ̂w í ŋgə dʉ́gya nə muud wɔɔŋgʉ̂, bwə́ ka kə shwə́man nyə nûŋ.» ");
INSERT INTO mcp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festos nyə a já cínɔŋg bwə́dɨ́ mwɔ̂w mwɔɔmb ŋkí wûm. A músə shulə kə Sezarê. Mán mələ̂m nyə á kə ji jiya sémbyé mílə́sʉ́d, a mú cɨ nə́ bwə́ zə́g nə Pwôl. ");
INSERT INTO mcp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pwôl mú zə. Oyúdɛn bwə́ á zhu Yurʉ́səlɛm wá bwə́ mú lyɛ̧ nyə, bwə́ mú ŋgə jɛ́ɛ́g nyə məma minjagə́ bwə́mɛ́fwó bwə́ cúgɛ́ nə ŋkul mpu bwaagʉlə myá. ");
INSERT INTO mcp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pwôl mú shwɔ̧ nyúul, nyə nə́: «Mə afwóyɛ́ shwey wôŋ nə məcɛ̧ɛ̧ mə́ Oyúdɛn, kú shwey wôŋ nə *Luŋ mə́ Zɛmbî, kú shwey wôŋ nə *Káázɛl.» ");
INSERT INTO mcp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Njɨ, Festos mú cɛɛl sá Oyúdɛn mənywa. A mú cɨ nə Pwôl nə́: «Ye wó magʉlə nə́ mə kə́ndʉg wo Yurʉ́səlɛm, lə́sʉ́ wô í kə́g lɨ́s wu mə njúl?» ");
INSERT INTO mcp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pwôl nə́: «Mə tə́l *mpáánzə́ milə́sʉ́ mə Káázɛl dɨ̂. Í jɨɨ nə́ lə́sʉ́ wâm í lɨ́sʉ́g cínɔŋg. Mə afwóyɛ́ sá Oyúdɛn gúl sâ abʉ́bɔ̂w, womɛ́fwó mə́ bwey mpu ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ŋkí jísə mpu bə nə́ mə jɨ nə məbɛ̧ɛ̧́, nə́ mə mə́ sá gúl sâ á shwɨy, mə kú ban shwɨy. Í ká yidá bə nə́ mə cugɛ́ nə məbɛ̧ɛ̧́ ísâ byɛ̂sh bʉ́ga bwə́ ŋgə́ jɛ́ɛ́g mə íga dɨ́, muud nyə ajə́láyɛ́ nə kɛɛnzh mə nə́ bwə́ kə́g gwú mə. Mə́ jɨɨ nə́ lə́sʉ́ wâm í kə́g wə́ Káázɛl.» ");
INSERT INTO mcp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festos bə́nɔ̂ŋ osémbye ɔ́ mílə́sʉ́ bɛ́ bwə́ mú dʉ lésha na nə́ ndɛɛ́ a mú cɨ nə Pwôl nə: «Wo mə́ jɨɨ nə́ lə́sʉ́ wô í kə́g wə́ Káázɛl, wo é ka nə́mə́ kə wu.» ");
INSERT INTO mcp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Baalɛ́ mwɔ̂w mə́ mú cɔ̧́. Njwú-buud Agʉrípa mú zə wɔ́ɔ́s Sezarê, bá mudá yé Berenís nə́ bwə́ zə́ bə́da Festos. ");
INSERT INTO mcp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nda bwə́ á já cínɔŋgʉ́ fwámɛ́ zhwog mwɔ̂w nə́, Festos nyə á ka jaaw njwú-buud lə́sʉ́ mə́ Pwôl. Nyə nə́: «Felígʉ́s nyə a lʉ́gə ŋgwɔ́l múúd wa mímbwugʉd. ");
INSERT INTO mcp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ja mə́ á kə Yurʉ́səlɛm yí, milúlúú myâ ofada, nə ocúmbá buud wâ Oyúdɛn bwə́ á shwə́man muud wɔɔŋgʉ̂, bwə́ nə́ mə mágʉləg nə́ a jɨ nə məbɛ̧ɛ̧́. ");
INSERT INTO mcp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mə á ka cɨ nə bwo nə́ buud ɔ Róma bwə́ cúgɛ́ nə ŋkul kɛɛnzh múúd nə́ a yə́g, muud wɔɔŋgʉ̂ bə́nɔ̂ŋ buud ɔ lə́sʉ́ bɛ́ bwə́ kú fwo kaad ɨɨ́, muud wɔɔŋgʉ̂ kú fwo bə nə fwála nə́ á shwɔ̧ nyɛ́ nyúul. Bwə́ ádɛ́ sá ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Sə́nɔ́ŋ bɛ̂sh sə́ á ka zə wa. Mə kú nə́mə́ nyiŋgə neela, mə mú ji jiya sémbyé mílə́sʉ́d, mán mələ̂m, mə mú jɔ̂w nə́ bwə́ zə́g nə muud wɔɔŋgʉ̂. ");
INSERT INTO mcp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Buud ɔ lə́sʉ́ bɛ́ bwə́ mú nə́mə́ zə, njɨ ísâ bwə́ á ŋgə cɨ nyə yí í kú bə nə isâ í abʉ́bɔ̂w mɛ́ mə á ŋgə tə́dʉga yí. ");
INSERT INTO mcp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bə́nɔ́ŋ bwə́ á ŋgə sɛ́ŋʉsa məkə́l ísâ í yə́bə́ wáŋʉ́d. Bwə́ á ŋgə wáámb nyə nə lə́sʉ́ mə́ ŋgwɔ́l múúd nə jínə́ nə́ Yésus. Muud wɔɔŋgʉ̂ nyə á yə, Pwôl ka ŋgə cɨ nə́ a jɨ kuwó. ");
INSERT INTO mcp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mɛɛ mə a shígɛ́ ka mpu sâ mə́ sáág yí. Mə á ka jî nyə ŋkí a jɨ nə ŋkul magʉlə nə́ a kə́ Yurʉ́səlɛm, lə́sʉ́ yé kə́g lɨ́s wu. ");
INSERT INTO mcp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Njɨ, Pwôl mú cɨ nə́ á jɨɨ nə́ lə́sʉ́ yé í kə́g wə́ Káázɛl, nyə wə́ kə́g sámb wə. Mə á ka nə́mə́ cɨ nə́ bwə́ báágʉləg nyə njɔ́w mímbwug kə wɔ́ɔ́s ja mə́ é bá kənd nyə wə́ Káázɛl yí.» ");
INSERT INTO mcp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agʉrípa mú cɨ nə Festos nə́: «Məmɛ́fwó mə́ cɛɛl nə́mə́ fwo gwágʉlə múúd ɛ́nɛ.» Festos nə́: «Wo e gwágʉlə nyə mán.» ");
INSERT INTO mcp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ja mán í á lə̂m yí, Agʉrípa bá Berenís bwə́ á zə nə isâ í gúmə́ byɛ̂sh í dʉ bə ja njwú-buud í ŋgə kyey yí, bwə́ mú zə nyíi *mpáánzə́ milə́sʉ́, bə́nɔ̂ŋ milúlúú mí ózɨmbɨ nə otɔ́we ɔ shwóg wâ ŋgwə́la. Festos mú sá nə́ bwə́ zə́g nə Pwôl. ");
INSERT INTO mcp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festos mú lás nə́: «Njwú-buud Agʉrípa nə buud bɛ̂sh bʉ́sə wa wá, bɨ mə́ dʉ́g múúd ɛ́ga? *Oyúdɛn bɛ̂sh wâ Yurʉ́səlɛm nə bɔɔŋg wâ wa, bwə́ á shwə́man nyə mə́dɨ́ bwə́ ŋgə yáág nə́ nyə ajə́láyɛ́ nə kwo cʉgə. ");
INSERT INTO mcp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Jâm kɔ́ɔ́mb dɨ, mɛɛ mə a shígɛ́ dʉ́g nə́ a mə́ sá gúl sâ abʉ́bɔ̂w á jə́lá nə yə nə ndɨ̂ yí. Njɨ, nda nyə á jî nə́ lə́sʉ́ yé í kə́g wə́ *Káázɛl nə́, mə á ka nə́mə́ magʉlə nə́ mə é kənd nyə wu. ");
INSERT INTO mcp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Njɨ mə cugɛ́ nə fwámɛ́ sâ mə́ cíləg Káázɛl shú lə́sʉ́ wɔɔŋg dɨ́ yí. Gwə́ wə́ mə́ ámə zə nə nyə wódɨ́ nə́ ŋkí wo e sá nə́ a lásʉ́g ɨɨ́, mə je bii sâ mə́ cíləg yí. ");
INSERT INTO mcp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nəcé í é bə kú nə wúmbʉ́lé nə́ mə bííg muud, mə kənd nyə, mə kú mpu lwágʉlə fwámɛ́ sâ nyə́ ámə sá yí.» ");
INSERT INTO mcp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agʉrípa mú cɨ nə Pwôl nə́: «Wo músə je kaad já nɨɨ́d.» Pwôl mú sɛ́ɛ́mb mbwə̂, a mú tɛ́ɛ́d kɔɔd. ");
INSERT INTO mcp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Njwú-buud Agʉrípa, mə dʉ́g nə́ í mə́ bul jəla mə nda mə́ tə́l wódɨ́ mpwóómbʉ́d múús nə́ mə zə kaad shú ísâ byɛ̂sh Oyúdɛn bwə́ ŋgə́ máág mə ínɨ. ");
INSERT INTO mcp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Í bul jəla nəcé wo mpú íjâm nə ijag í Oyúdɛn byɛ̂sh, wo mpú nə́mə́ ísâ bwə́ dʉ sɛ́ŋʉsa məkə̂l nə ndɨ̂ yí. Mə́ ka jəgʉla nə wo nə́ wo gwágʉ́lə́g mə nə lâm jísɔ́w. ");
INSERT INTO mcp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Oyúdɛn bɛ̂sh bwə́ mpú cʉg jâm tɛ́ wúlə shí. Bwə́ mpú nda mə́ á ŋgə cʉgə wa mə́dɨ́ lwoŋ buud dɨ́ nə wa Yurʉ́səlɛm nə́. ");
INSERT INTO mcp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bwə́ bwey mpu nə́ kɔ́ɔ́mb yə́bə́ wúsʉ́ dɨ́ mə á bə ŋkɔɔmʉ́ í búl bə nə ŋkʉ́d yííd, mə á bə *Farizyɛ̂ŋ. Ŋkí bwə́ cɛɛl, bwə́mɛ́fwó bʉ́sə nə ŋkul je bwiiŋg lâŋ wâm. ");
INSERT INTO mcp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mə mə́ zə tɔ̂w kɔɔdʉd ja ga dɨ́ nəcé ŋkaagə́ Zɛmbî nyə á kaag odá yí, mɛɛ ŋgə bwánd nywo nə búgə́. ");
INSERT INTO mcp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ibɛɛnd wûm nə íbá byɛ̂sh sə́ bʉ́sə́ nə ndɨ̂ yí í ŋgə yə Zɛmbî gúmə́ bulú nə mwásə́ kú yɔw. Ibɛɛnd byɔɔŋg í ŋgə bwánd ŋkaagə́ nyɔɔŋgʉ́ nə búgə́. Yé Njwú-buud, wâm bwándʉ́lə wɔɔŋg wə́ Oyúdɛn bwə́ ŋgə́ wáámb mə nə ndɨ̂ ga. ");
INSERT INTO mcp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nəcé jɨ́ bɨ́ bâŋ bɨ́ cúgɛ́ nə ŋkul magʉlə nə́ Zɛmbî ŋgə gwûmʉshi mimbimbə yí? ");
INSERT INTO mcp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mɛɛ mə á fwo nə́mə́ dʉ tə́dʉga nə́ mə́ jəlá nə bul lúmbʉli nə jínə́ mə́ Yésus á Nazarɛ̂t. ");
INSERT INTO mcp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ntɔ́ nə́mə́ wə́ mə́ á dʉ sá Yurʉ́səlɛm yɛ́. Məmɛ́fwó mə á dʉ bií zhwog obúgʉla nə ŋkul milúlúú myâ ofada mí á yə mə yí, mə dʉ wá bwo mímbwugʉd. Mə á dʉ nə́mə́ bə cʉ́ŋ nə buud bwə́ á dʉ gwú bwo wá. ");
INSERT INTO mcp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mə á dʉ kyey *mə́mpáánzə́ mə́ mínjɨ́ɨ́gʉ́lá mə́ Oyúdɛn dɨ̂, mə dʉ ŋgə lwágʉlə obúgʉla cúwʉ́lí, dʉ yɨ́ɨ́mbʉli bwo nə́ bwə́ kɨ́ɨ́lyág búgə́ jáŋ. Mə á ntɛɛŋg nə́mə́ sɔ́ɔ́lʉ́gʉ́ wâm, mə kə dʉ bɛ̧ óbúgʉla míŋgwə́la mishúsʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Gwə́ wə́ í á sá nə́ mə kə́g Damás, milúlúú myâ ofada mí mə́ yə mə ŋkul nə lwámá mə́ kə́g sá yí. ");
INSERT INTO mcp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mə ŋgə́ kə ntʉ́nɨ tâm mwásə́, yé Njwú-buud, mə mú dʉ́g njɨ məma mə́ŋkɛnya mə́ mə́ faan cɔ̧́ yásə́. Məŋkɛnya mə́nɨ mə́ mú lyɛ̧ sə́nɔ́ŋ buud ɔ́ gwooŋg bâm. ");
INSERT INTO mcp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Sə́ bɛ̂sh sə́ mú kadʉwa shí. Mə mú gwág kə́l í ŋgə́ lás nə mə kə́l lʉ́ aramyɛ̧̂ dɨ́ nə́: “Sôl, Sôl, nəcé jɨ́ wó búl lwágʉlə mə cúwʉ́lí ntʉ́nɨ yí? Mpug nə́ wo cugɛ́ nə ŋkul sá míŋgáádə́ nə shushwom.” ");
INSERT INTO mcp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mə mú jî nə́: “Wo zə́ e, Cwámba?” Cwámba nə́: “Mə Yésus, mə wə́ wó ŋgə́ lwágʉlə cúwʉ́lí yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Njɨ, wɔɔlʉ́g, wo tɔ́wʉ́g tʉ́təlí nə məkuú mwô. Mə ámə zə lwóya nyúul wódɨ́ nə́ mə zə sá nə́ wo bə́g mə kágə́ mílwámá, wo bwiiŋg sâ wó mə́ dʉ́g yí nə byɔɔŋg byɛ̂sh mə́ bá nyiŋgə zə dʉ lwágʉlə wo yí. ");
INSERT INTO mcp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mə é cʉg wo nə kúl gwô nə ikûl ishús, kʉ́l jɛ̂sh mə́ é lwâm wo yí. ");
INSERT INTO mcp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mə lwám wo nə́ wo kə́g bɛ̂ny bwo mísh, bwə́ wúg yídʉ́gʉ́d zə mə́ŋkɛnyad, wú mpə̂l mə *Sátan dɨ́ zə wə́ Zɛmbî. Búgə́ bwə́ é *búgʉla mə yí í é sá nə́ bwə́ lə́gʉ́g ijuugá í *mísə́m myáŋ bwə́ mú ŋwa jiya, bə́nɔ̂ŋ bɔɔŋg búúd bwə́ mú miŋkɛ̧́ŋkɛ̧̂ nəcé ŋgə̌lə búgʉla mə wá.” ");
INSERT INTO mcp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Ntɔ́, yé Njwú-buud Agʉrípa, sâ mə́ á dʉ́g í á zhu mə gwɔ́w yí, mə a shígɛ́ mpyêny gwo. ");
INSERT INTO mcp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mə á yida tɛ́ɛ́d njɔɔnd, mə tɛ́ɛ́d kə búúd ɔ Damás dɨ́, mə mú nyiŋgə́ kə bɔɔŋg wâ Yurʉ́səlɛm nə bɔɔŋg wâ Yudéa yɛ̂sh dɨ́, kə nə́mə́ íkûl ishúsʉ́d, mə kə bwiiŋg bɛ̂sh nə́ bwə́ cɛ́ndʉ́g mítə́dʉ́gá bwə́ cɛ́nd kuú njɔɔnd yid wə́ Zɛmbî, bwə́ mú cʉgə cʉg í lwágʉlə nə́ bwə́ mə́ cɛ́nd mítə́dʉ́gá yí. ");
INSERT INTO mcp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sâ jɔɔŋg wə́ Oyúdɛn bwə́ á kə bií mə *Luŋ mə́ Zɛmbî dɨ́, bwə́ ŋgə́ sɔ̧́ nə́ bwo gwú mə nə ndɨ̂ yí. ");
INSERT INTO mcp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mə ŋgə cʉgə zə wɔ́ɔ́s múús njɨ nəcé Zɛmbî, shú nə́ mɛ́ɛ́ ŋgə́g nə bwiiŋg kɛ́ɛl, bwiiŋg íkʉ́kágə́, bwiiŋg ócúmbá buud. Mə ŋgə bwiiŋg njɨ sâ *búúd ɔ mícúndə́ nə Moyîz bwə́ á bwey jaaw nə́ í bá bə yí, kú bəd sâ gwɔ̂w. ");
INSERT INTO mcp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Í á bə nə́ *Krîst mə́ jəlá nə bá jug, á jəlá nə bá bə múúd ashúshwóógʉ́ gwûmʉ́lə, á jəlá nə bá bwiiŋg kúl jísʉ́ nə byɔɔŋg í cúgə́ Oyúdɛn yí məŋkɛnya.» ");
INSERT INTO mcp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pwôl ŋgə́ kə shwóg nə kɔɔd yé ntʉ́nɨ, Festos mú ŋkáánd nə́: «Pwôl wo jɨ lad. Bulʉ́lə mpu wô nɨ í mə́ kənd wo ímpwúfúd.» ");
INSERT INTO mcp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pwôl nyɛ mú cɨ nə́: «Mə cugɛ́ lad ye Festos lwám múúd. Lə́sʉ́ mə́ ŋgə́ lás yí wúsə fwámɛ́ lə́sʉ́, í njúl lə́sʉ́ fʉg. ");
INSERT INTO mcp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Njwú-buud mə́ ŋgə́ lésha nə ndɨ̂ kú fúndə yɛ́, a mpú ísâ ínɨ. Mə tə́dʉ́gá nə́ mə aŋgɛ̂ nə kwab ja mə́ cɨ́ ntɔ́ yí, nyə ajágɛ́ tɔɔ sâ na. Nəcé isâ byɔɔŋg í á shígɛ́ dʉ sɨ̂y íshwoo mə́fəfʉd. ");
INSERT INTO mcp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Njwú-buud Agʉrípa, ye wo ŋgə *magʉlə isâ *búúd ɔ mícúndə́ bwə́ á cɨ yí? Haaw. Mə mpú nə́ wo ŋgə magʉlə byo.» ");
INSERT INTO mcp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agʉrípa mú cɨ nə Pwôl nə́: «Í mú wo kúnə́-kúnə nə́ wo sáág mə nə́ mə bə́g krîstɛn ɛ̧ɛ̧́!» ");
INSERT INTO mcp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pwôl nə́: «Í bə́g ntɔ́ tɔɔ kɨ́kɨdɨ́ga tɔɔ jáyɛ́ ja. Mə́ jəgʉla nə Zɛmbî nə́ tɔɔ wo, tɔɔ buud bɛ̂sh bwə́ ŋgə́ gwágʉlə mə múús wá bɨ bə́g nda mə, njɨ bɨ kú yidá bə nə məŋkəda nda mə́ jɨ́ nə mwo ɛ́ga.» ");
INSERT INTO mcp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Njwú-buud mú tɔ̂w, nə ŋgwə́mʉna, nə Berenís nə buud bɛ̂sh bə́nɔ́ŋ bwə́ á bə bwə́ njúl wá. ");
INSERT INTO mcp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bwə́ músə kə shwushwagád, kə lésha nə́: «Muud ɛ́nɛ nyə asáyɛ́ tɔɔ sâ bʉ́sə nə ŋkul gwú nyə nə ndɨ̂ yí, kú nə́mə́ bə tɔɔ sâ bwə́ wálʉ́lə́g nyə məŋkəda yí.» ");
INSERT INTO mcp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agʉrípa mú cɨ nə Festos nə́: «Í mbə̂m bə muud ɛ́nɛ kú jî nə́ lə́sʉ́ yé í kə́g wə́ *Káázɛl, wo mbə̂m je bɨ́d nyə.» ");
INSERT INTO mcp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ja í á zə wɔ́ɔ́s nə́ bwə́ kənd sə́ Italî yí, bwə́ á ŋwa Pwôl nə míl mímbwug, bwə́ yə wúl lúlúú ózɨmbɨ təd. Lúlúú ózɨmbɨ wɔɔŋg í á bə nə jínə́ nə́ Zhuliyus, nyə á dʉ sɛ̂y kínda ózɨmbɨ ánʉ́nɨ̂ bwə́ á dʉ jɔ̂w nə́ Kínda mə *Káázɛl yí. ");
INSERT INTO mcp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Sə́ á bád titíma á Adramît í á ŋgə kə mə́bwûŋ mə́ Azî yí. Sə́ á bád cínɔŋgʉ́, mú kyey sə́nɔ̂ŋ Aristárʉg muud Masedwân nyə á zhu Tesaloníka yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Sə́ mú kə shulə Sidon mán mələ̂m. Zhuliyus nyə á bə nə jɔ̧ lâm nə Pwôl, a mú bɨ́d nyə nə́ a kə́g óshwə́ bɛ́ dɨ́, ka bwə́ é ŋgə yə nyə isâ. ");
INSERT INTO mcp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sə́ mú tɨ́ na. Nda oŋkwɔ̧̂ bwə́ á ŋgə ntágʉlə sə́ nə́, sə́ á ŋgə baag kɔ́ɔ́mb fuundú mâŋ á Shíprə oŋkwɔ̧̂ bwə́ á dʉ bə bwə́ mú ŋgə cwaalʉwo yí. ");
INSERT INTO mcp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sə́ mú ka lɨ́ɨ́na mâŋ mâ Silisî nə Pamʉfilî, sə́ mú kə səl titíma Mira, mpál shí á Lisî. ");
INSERT INTO mcp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Cínɔŋg wə́ lúlúú ózɨmbɨ wúsʉ́ nyə a dʉ́g ŋgwɔ́l titíma á Aləgʉzandrî tə̂l nə́ a kə Italî yɛ́. A mú ntɛɛŋg sə́ titíma wɔɔŋgʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Sə́ á ŋgə kə ntʉ́nɨ, júgə cúŋ nə cúŋ, sə́ ŋgə́ kə togʉ́toogʉ́, já zhɨ́ɨ́d zhwog mwɔ̂w nə́ ndɛɛ́ sə́ mú kə wɔ́ɔ́s ŋgɛɛ́ Kanídus. Ŋkwɔ̧̂ kú bɨ́d sə́ fwála nə́ sə́ shíshʉ́g kúnə́-kúnə. Sə́ á shwal baag kɔ́ɔ́mb fuundú mâŋ á Kʉrɛ̂t óŋkwɔ̧̂ bwə́ á dʉ bə bwə́ mú ŋgə cwaalʉwo yí. Sə́ á ŋgə kə ŋgɛɛ́ Salmóne. ");
INSERT INTO mcp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Sə́ mú ŋgə lídʉga nə ŋgə́lə baag na fuundú mâŋ nə́ ndɛɛ́ sə́ mú kə wɔ́ɔ́s kʉ́kʉ́l bwə́ dʉ́ jɔ̂w nə́: «Jɔ̧jɔ̧ mə́bwûŋ» yí, ŋgwə́la í njúl kúnə́-kúnə nə cínɔŋgʉ́ njɨ Lasaya. ");
INSERT INTO mcp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Fwála í á bwey bul cɔ̧́ sə́. Ka nə́mə́ nyiŋgə bə nə́ nda wəla lʉ́ íci í ídʉ̂w í á cɔ̧́ nə́ júgə í á zə bə ŋkí wagʉwo. Gwə́ wə́ Pwôl nyə á ka zə kɛ́wʉli búud, ");
INSERT INTO mcp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","nyə nə́: «Owɛy, njɔɔnd ga í é bə sə́ ŋkí jág ŋkáŋgʉla. Mə dʉ́g nə́ sə́ é jímbal mímbag mísʉ́, tɔɔ titíma, sə́ je nə́mə́ gwɨ́ɨ́l míkug mi búúd.» ");
INSERT INTO mcp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lúlúú ózɨmbɨ nyɛ mú yida bul bə nə búgə́ nə njulye titíma bá amə́dɨ́, a kú gwág sâ Pwôl nyə á cɨ yí. ");
INSERT INTO mcp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nda bwûŋ dɔɔŋg í á shígɛ́ bə jɔ̧ bwûŋ búud bɨ́ nə ŋkul cɨ́ŋgʉli ŋkwân yí nə́, zhwog buud bwə́ mú ŋgə cɨ nə́ sə́ cɔ̧́g cínɔŋg, sə́ sɔ̧́ɔ̧́g nə́ sə́ kúməg Fenígʉ́s, bwûŋ á Kʉrɛ̂t, sə́ kə́g cɨ́ŋgʉli ŋkwân wu. Bwûŋ dɔɔŋg dáá dʉ́sə mbəg ŋgɛɛ mpə́dʉ́gá *məkɔ́ɔ́l mə́ jwɔ̂w nə kɔ́ɔ́mb jwɔ̂w í dʉ jímə yí, í njúl nə́mə́ mbəg ŋgɛɛ mpə́dʉ́gá *məncwûm mə jwɔ̂w nə kɔ́ɔ́mb jwɔ̂w í dʉ jímə yí. ");
INSERT INTO mcp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Gúl ŋgúŋgúl í dʉ zhu mə́kɔ́ɔ́l mə́ jwɔ̂w yí í mú ŋgə wɔ̧́ɔ̧lə. Bwə́ mú tə́dʉga nə́ bʉ́sə nə ŋkul kə, kə wɔ́ɔ́s Fenígʉ́s. Bwə́ mú yîl shwamá í dʉ sá nə́ titíma kú kyey yí, bwo mú ŋgə bɛ̧ fuundú mâŋ á Kʉrɛ̂t. ");
INSERT INTO mcp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kú nə́mə́ bwey, məma ŋkwɔ̧̂ bwə́ dʉ jɔ̂w nə́ Erakilɔ̂ŋ yɛ́ mú zhu nûŋ ŋkwamə́d zə byalʉga nə bwo. ");
INSERT INTO mcp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nda titíma í á shwal tʉ̂w nə́, fwála mə kwo tə́l nyə yí í a shígɛ́ ná bə. Sə́ mú bɨ́d, ŋkwɔ̧̂ mú ŋgə kə nə sə́ kɔ́ɔ́mb í ajə́láyɛ́ yí. ");
INSERT INTO mcp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Sə́ á ka kə cɔ̧́ mpʉ́sə ŋkwamə́ bwə́ jɔ̂w nə́ Koda yí, í mú nywá laa sə́ ŋkwɔ̧̂, sə́ músə ka tɛɛm balan nə bíbyɔ́ɔ́l acíg-cíg sə́ mə́ fwo bul lídʉga. ");
INSERT INTO mcp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ofʉ́la bwə́ mú kəl bíbyɔ́ɔ́l jɔɔŋg titíma dɨ́ gwɔ̂w nə́ ndɛɛ́ bwə́ mú ŋgə cɛ̧ɛ̧lə mikwoolú lyɛ̧ titíma nəcé bwə́ á ŋgə fúndə nə́ ŋkwɔ̧̂ nyə a bá kə nə sə́ nə́ ndɛɛ́ sə́ kə mága bwûŋ á Sírʉt. Bwə́ mú shul shwamá í dɨ́ cwánʉwo yí mə́júwód, sə́ mú shwal ŋgə kə, kú ná bə kɔ́ɔ́mb sə́ mə́ cɛ́ɛl yí. ");
INSERT INTO mcp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Jwɔ̂w í á bɛ̧ yí í á bə ŋkwɔ̧̂ ŋgə́ ná nə́mə́ zhɨ́ɨ́ŋg sə̂. Sə́ mú ka tɛ́ɛ́d wusə́lə mímbag mə́júwód. ");
INSERT INTO mcp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Jwɔ̂w álɛ́ɛl, ofʉ́la bwə́mɛ́fwó bwə́ mú ŋgə wusə isâ í titíma mə́júwód nə məbwə̂ máŋ. ");
INSERT INTO mcp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sə́ á cʉgə mwɔ̂w ŋkí bulya kú ná dʉ́g jwɔ̂w joŋ dɨ́, kú nə tɔɔ acén-céní, njɨ wúl mbií yáág-yáág ŋkwɔ̧̂ ŋgə kuŋg. Sə́ mú shîn dʉ́g nə́ sə́ bâŋ sə́ ácʉgəyɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Í á bə nə́mə́ buud bwə́ mə́ bul já kú də. Pwôl mú ka zə tɔ̂w bwo tʉ́tám, a mú cɨ nə bwo nə́: «Owɛy, bɨ́ a mbə̂m gwág sâ mə́ a ŋgə cɨ yí, ŋki sə́ á shígɛ́ tɨ́ mə́kuú Kʉrɛ̂t, sə́ á mbə̂m sásʉlə míga mícúŋ nə intáma. ");
INSERT INTO mcp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mə́ ka cɨ nə bɨ́ ja gaád nə́ bɨ lwóyág iŋkáŋ. Cʉg múúd í ájímbɛɛ́ wa tɔɔ ŋgwúd. Sá jɨ́ nə ŋkul ntáma, njɨ titíma. ");
INSERT INTO mcp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Zɛmbî mə́ gwág nə ndɨ̂ yɛ́, mə́ ŋgə́ yə gúmə́ yɛ́, ŋgwɔ́l *éŋgəles yé nyə ámə wɔ́ɔ́s mə́dɨ́ búlú gaád. ");
INSERT INTO mcp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Nyə ámə lás nə mə nə́: “Pwôl, wo kú bə nə ifwaas. Í jɨɨ nə́ wo kúməg wə́ *Káázɛl. Zɛmbî nyə e cʉg nə́mə́ búúd ɔ titíma gwô nəcé wo.” ");
INSERT INTO mcp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Gwə́ wə́ mə́ cɨ́ nə bɨ́ nə́, oshwə́ bâm, lwóyágá iŋkáŋ. Mə jɨ nə búgə́ nə Zɛmbî nə́ ísâ í é bə nda nyə ámə jaaw mə nə́. ");
INSERT INTO mcp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Sə́ é kə mága nyúl ŋkwamə́ dɨ̂.» ");
INSERT INTO mcp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Í á ka zə bə, ŋkwɔ̧̂ mə́ jɛ̧́ɛ̧la nə sə́ ntʉ́nɨ ibulú wûm nə ílɔ́ɔl. Búlú wûm nə nɔ̧̂ dɨ́, sə́ ŋgə́ ná nə́mə́ ntʉ̂ŋ mâŋ bwə́ jɔ́w nə Adriyatîk má dɨ, ísâ í tâm bulú, ofʉ́la bwə́ mú gwádʉga nə́ sə́ mú kúnə́-kúnə nə nyúl shí. ");
INSERT INTO mcp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bwə́ mú wusə zhwaŋgʉla mə́júwód, bwə́ kwey nə́ í gwaa shí kə wɔ́ɔ́s ómáda məwûm mə́lɔ́ɔl nə zaŋgbá. Sə́ mú shísh shwóg, bwə́ mú kwo wusə zhwaŋgʉla, bwə́ kwey ómáda məwûm mə́bá nə mwɔɔmb. ");
INSERT INTO mcp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bwə́ mú bɛɛmb nə́ sə́ á bá kə mága gúl kʉ́kʉ́l á məkwóógʉ́d. Bwə́ mú wá mə́shwamá mə́nɔ̧̂ bán titíma dɨ́, bwə́ ŋgə́ wɨ́ɨ́mb nə́ mán í lɛ́ɛ́lʉg lə̂m. ");
INSERT INTO mcp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ofʉ́la bwə́ mú ka zə bii tə́dʉ́gá nə́ bwə́ túb. Bwə́ mú shul bíbyɔ́ɔ́l ácíg-cíg mə́júwód nda sâ mə́ cɨ́ nə́ bwə́ kə́ wá mə́shwamá mâ lúú titíma. ");
INSERT INTO mcp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pwôl mú cɨ nə lúlúú ózɨmbɨ nə́: «Ŋkí buud ɔ́nɨ bwə́ bə́ kú ji titíma dɨ́, bɨ́ kú faam nə shwɨy.» ");
INSERT INTO mcp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ozɨmbɨ bwə́ mú sámb míkwoolú mí bíbyɔ́ɔ́l nə ndɛɛ́ í mú wô. ");
INSERT INTO mcp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Té bwə́ á ŋgə bwánd nə́ mán í lə́mʉ́g yí, Pwôl nyə á ŋgə cwîny buud nə́ bwə́ də́g ídʉ̂w. Nyə á cɨ nə bwo nə́: «Í mə́ bə mwɔ̂w wûm nə mə́nɔ̧̂ múús bɨ njul bɨ ŋgə bwánd, muud kú də. ");
INSERT INTO mcp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mə́ ŋgə jɨɨ nə́ bɨ nyíŋgəg tɛ́ɛ́d ŋgə̌lə də́, sâ jɔɔŋg í é sá bɨ́ mpwogɛ́. Mpugá nə́ muud nyə ajímbálɛ́ tɔɔ ntand shilú ŋgwúd wa.» ");
INSERT INTO mcp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Njɨ nyə á shîn cɨ ntʉ́nɨ yí, nyə á ŋwa bʉlɛ́d, a jəgʉla nə Zɛmbî nə́ ndɛɛ́ a fɛ̂y, a mú tɛ́ɛ́d də́lə. ");
INSERT INTO mcp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bɛ̂sh mənyúúl mə́ mú lal, bwə́ mú ŋwa ídʉ̂w ŋgə də. ");
INSERT INTO mcp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Sə́ bɛ̂sh sə́ á bə titíma dɨ́ buud mitəd mímbá nə məwûm zaŋgbá nə ósaman. ");
INSERT INTO mcp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ja bwə́ á shîn də jílə yí, bwə́ á ka zə sɔ̧́ məzhɨɨ́ mə sá nə́ titíma ŋwág yɨ́ɨ́sa. Bwə́ mú wusə ídʉ̂w mə́júwód. ");
INSERT INTO mcp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ja mán í á ka lə̂m yí, bwə́ a shígɛ́ yag shí bwə́ á kə wɔ́ɔ́s nɨ. Í á yida bə nda wúl mbwə̂ mâŋ í á zə shúsə cíndú. Mbwaanzʉlə shɛ̧́ í á ŋgə nyîn cínɔŋg. Wu mbwaanzʉlə wɔɔŋg dɨ́ wə́ bwə́ á dʉ́g nə́ bwə́ cɛɛl kə tə̂l titíma yɛ́ ŋkí í á bə nə ŋkul sɨ̂y ntɔ́. ");
INSERT INTO mcp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bwə́ á ka wiinzh məshwamá mɛ̂sh bwo mpáŋgʉlə mwo mə́júwód, bwə́ wiinzh nə́mə́ míkwoolú mí sá í dʉ fiinzh titíma yí, bwə́ mú wɛɛf *sanda ŋgúl, ŋgúl mú ŋgə kə nə titíma kɔ́ɔ́mb mbwaanzʉlə shɛ̧. ");
INSERT INTO mcp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Njɨ bwə́ nda fwo kumə bwûŋ, titíma mú kə mága dúl kú lʉ́ shɛ̧ í á bə mə́júwó dɨ́ shí kú ŋgə nyîn yí. Lúú titíma í mú nyíi shɛ̧ dɨ̂ í kə yɨ́ɨm. Ikwɔ̧́ í mə́júwó í mú dʉ zə jiwa bán titíma dɨ́ nə́ ndɛɛ́ bán titíma í mú shîn wôŋ. ");
INSERT INTO mcp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ozɨmbɨ bwə́ mú dʉ́g nə́ bwə́ shîn gwú mimbwug shú nə muud kú gwáág nə́ ndɛɛ́ túb. ");
INSERT INTO mcp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Njɨ nda lúlúú ózɨmbɨ nyə á cɛɛl cʉg Pwôl nə́, nyə á cɨ nə ozɨmbɨ nə́ bwə́ kú gwú mímbwug. A mú yida lwâm nə́ bɔɔŋg bɨ́ nə ŋkul gwáág wá bwə́ gwáágʉ́g kə cíndú, ");
INSERT INTO mcp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","bɔɔŋg bwə́ lʉ́g wá bwə́ ŋgə́g nə badʉwo mə́bɔ́ɔ́mbúd, bɔ́ɔ́l íbwɨ́l í titíma dɨ́ bwə́ ka ŋgə kə cíndú. Ntɔ́ wə́ bɛ̂sh bwə́ á faam nə shwɨy yɛ́, bwə́ mú kumə cíndú mpwogɛ́ nə mpwogɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ja sə́ mə́ shîn faam nə shwɨy ntʉ́nɨ yí, sə́ mú gwág nə́ bwə́ dʉ jɔ̂w nyâŋ ŋkwamə́ nə́ Malta. ");
INSERT INTO mcp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mimbyágá mí shí nyɔɔŋg mí á ŋwa sə́ nə dúl váál ósʉsa í cúgɛ́ kʉ́l jɛ̂sh yí. Nda mpú nyə á ŋgə nywɔ̧̂ yɔ̂ŋ í ŋgə́ fafʉlə nə́, bwə́ á sɔ̧ məma kuda, bwə́ mú ŋwa sə́ bɛ̂sh nə́ sə́ kə́g gwáalə. ");
INSERT INTO mcp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pwôl nyə á ka ŋkɛ̂ny dúl bímbí lʉ́ ncaga wusə kudad. Yúul mú kə wú cínɔŋgʉ́ nə gúŋ kuda, zə bwamʉsə nyə mbwə́d nada. ");
INSERT INTO mcp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ja mímbyágá mí shí mí á dʉ́g yúul kə́l Pwôl mbwə́d yí, bwə́ á ŋgə lésha bwə́mɛ́ nə bwə́mɛ́ nə́: «Muud ɛ́ga jɨ wámbʉlə bə ŋgwûl buud. A mə́ tɛɛm faam nə shwɨy mə́júwó dɨ, myɛ́ndí í á mágʉ́lə́yɛ́ nə́ a cʉ́gəg.» ");
INSERT INTO mcp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Njɨ Pwôl nywáá mú samʉsə yúul kuda dɨ́, a kú nə́mə́ gwádʉga tɔɔ məcɛy. ");
INSERT INTO mcp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bâŋ bwə́ á ŋgə tə́dʉga nə́ bwə́ é je dʉ́g Pwôl ŋgə́ gúsə, gúl ja nə́ bwə́ é seegya njɨ a mə́ yʉŋ kadʉwa shí mbimbə. Bwə́ á bwánd nə́ kə́kə́kə́, bwə́ kú dʉ́g tɔɔ sâ ábʉ́bɔ̂w í bə́ nə nyə. Bwə́ mú cɛ́nd mítə́dʉ́gá, bwə́ nə́: «A cugɛ́ zhizhe muud, a jɨ zɛmbî.» ");
INSERT INTO mcp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ŋgwɔ́l kâŋ nyə á bə kúnə́-kúnə nə kʉ́kʉ́l bwə́ á bə nɨ. Kâŋ wɔɔŋg njúl kâŋ mə́ Publíyus, lúlúú múúd á ŋkwamə́ nyɔɔŋg. Publíyus ɛ́nɛ mú ŋwa sə́ nə cɛɛlí, a mú jil sə́ nyə́dɨ́ kâŋ mwɔ̂w mə́lɔ́ɔl. ");
INSERT INTO mcp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Sɔ́ɔ́ŋgʉ́ yé nyə á bə a mbwúg shí nə bwas. Nyúúl í á ŋgə gwɔ̧̂ nyə, a ŋgə́ nə́mə́ bwas ncwú-məcií. Pwôl mú kə nyə́dɨ́, kə jəgʉla nə Zɛmbî, bəd nyə məbwə̂, a mú yâl. ");
INSERT INTO mcp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Í mú ka zə bə nə́, míl mímbə̂l myâ ŋkwamə́ nyɔɔŋgʉ́ mí mú ŋgə zə nyə́dɨ́, mí ŋgə́ zə yâl. ");
INSERT INTO mcp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Buud bɔɔŋg bwə́ mú bul ŋwa sə́ nə gúmə́, gúmə́ í ŋgə́ nyîn mimbií mimbií. Bwə́ á yə nə́mə́ sə́ isâ í njɔɔnd ja sə́ á kyey yí. ");
INSERT INTO mcp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sə́ á ji cínɔŋg oŋkwoond olɔ́ɔl. Gúl titíma á Aləgʉzandrî í á cɨ́ŋgʉli ŋkwân cínɔŋg ŋkwamə́ nyɔɔŋgʉ́d. Titíma jɔɔŋg mɛ́ mə́yɨɨgyé mə́ á bə yuug «Məwáás». Gwə́ wə́ sə́ á ŋwa kə́lə nə njɔɔnd shwóg yí. ");
INSERT INTO mcp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sə́ á kə nə́ ndɛɛ́ kə shulə Sirakûs, sə́ mú já cínɔŋgʉ́ mwɔ̂w mə́lɔ́ɔl. ");
INSERT INTO mcp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tɨ́lə sə́ á tɨ́ na yí, sə́ á ŋgə baag nciindye nə nciindye nə́ ndɛɛ́ kə wɔ́ɔ́s Regyo. Mán mələ̂m, ŋkwɔ̧̂ á məkɔ́ɔ́l mə́ jwɔ̂w mú kuŋg. Mpʉ́sə mwɔ̂w mə́bá sə́ mú kumə Puzhwoləs. ");
INSERT INTO mcp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Sə́ mú kwey bɔ́ɔ́l ómínyɔŋʉ̂ bʉ́sʉ́ óbúgʉla na. Bwə́ mú jəgʉla nə sə̂ nə́ sə́nɔ́ŋ sə́ jág mwɔ̂w zaŋgbá. Mpʉ́sə wɔɔŋg wə́ sə́ á kə kumə Róma yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Na, bɔ́ɔ́l ómínyɔŋʉ̂ bʉ́sʉ́ wâ Róma bwə́ á gwádʉga nə́ sə́ ŋgə zə. Bwə́ á zə, zə bwəma nə sə́ Ifacilá í Apyus, bɔ́ɔ́lʉ́gá kʉ́l bwə́ dʉ jɔ̂w nə Minjɔ́w mí ójóŋ mílɔ́ɔl yí. Ja Pwôl nyə a dʉ́g bwə́ yí, nyə á yə Zɛmbî cúncɛ́sh, ŋkul bul wɔ́ɔ́s nyə nyúúlʉ́d. ");
INSERT INTO mcp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ja sə́ á kumə Róma yí, bwə́ á bɨ́d Pwôl nə́ a jeg kə ji kʉ́l á cɛ́ɛl yí, bá ŋgwɔ́l zɨmbɨ nyə́ é dʉ baagʉsə nyə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Mpʉ́sə mwɔ̂w mə́lɔ́ɔl ntʉ́nɨ, Pwôl nyə á jɔ̂w otɔ́we ɔ shwóg wâ *Oyúdɛn, bwə́ zə bwəma nə nyə kʉ́l nyə á dʉ ji yí. Ja bwə́ á zə sɛɛŋgya yí, nyə á ka cɨ nə bwo nə́: «Bwaaŋg mə a shígɛ́ shwey wôŋ nə kúl búud jíshé, kú shwey wôŋ nə ijâm nə ijag ódá bwə́ á lʉ́gə yí. Njɨ tɛɛm bə ntɔ́, bwə́ á bii mə Yurʉ́səlɛm, kɛɛnzh mə məbwə̂ mə́ búud ɔ Róma dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Buud bɔɔŋg bwə́ á shí jî mə kɔɔd, bwə́ mú kwey nə́ bwə́ bɨ́d mə nəcé bâŋ bwə́ á shígɛ́ kwey mə nə məbɛ̧ɛ̧́ mə mpíyá nə shwɨy má. ");
INSERT INTO mcp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Njɨ, nda Oyúdɛn bwə́ á ŋgə ŋgaan nə́, gwə́ wə́ mə́ á jî nə́ lə́sʉ́ wâm í zə́g wə́ *Káázɛl nə ndɨ̂ yí. Njɨ ntɔ́ cugɛ́ nə́ mə jɨ nə məshwán nə lwoŋ búúd jâm. ");
INSERT INTO mcp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Sâ jɔɔŋg wə́ mə́ ámə sɔ̧́ nə́ shé dʉ́gyág nə ndɨ́ yí, shé lésha yí. Bʉ́bə́lɛ́ mə jɨ mə́ŋkəda dɨ̂ nəcé sâ *Izʉrəyɛ̂l ŋgə́ bwánd nə búgə́ yí.» ");
INSERT INTO mcp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bwə́ mú bɛ̧sa nə nɛ́ nə́: «Sə́ afwóyɛ́ bii ŋgwɔ́l kálaad ŋgə́ wú sə́ Yudéa shú dwô dɨ́, ŋki ntâg nə́ ŋgwɔ́l *mínyɔŋʉ̂ wúsʉ́ mə́ zə́ jaaw sə́ wúl bɔ́w-bɔ̂w lâŋ shú dwô dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Njɨ, sə́ mə́ jɨɨ nə́ womɛ́fwó jááwʉg ná sə́ tə́dʉ́gá wô shú nyɔɔŋg ŋkɔɔmʉ́ a búgə́ wó mə́ kə nyíi nɨ. Sə́ ŋgə gwág nə́ buud bwə́ ŋgə ban nywo kʉ́l jɛ̂sh.» ");
INSERT INTO mcp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bə́nɔ́ŋ bwə́ á cɛ̧ɛ̧lə ŋkúmba jwɔ̂w bwə́ bá zə cínɔŋg nyə́dɨ́ njɔ́w yí. Ja jwɔ̂w dɔɔŋg í á jé yí, bwə́ á zə bwə́ njúl buud ŋkí bul bulya. Pwôl mú zə lwóya búgə́ jé wú mpʉ́mán wɔ́ɔ́s mpwó-kugʉ́, a ŋgə́ bwiiŋg bwo Faan mə́ Zɛmbî, a ŋgə́ sɔ̧́ nə́ bwə́ mágʉləg Yésus, a ŋgə́ bwiiŋg bwo nə́ nyə wə́ Məcɛ̧ɛ̧ mə́ Moyîz nə micilyá mí *búúd ɔ mícúndə́ mí á ŋgə cɨ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bɔ́ɔ́l bwə́ mú ŋgə *magʉlə isâ nyə á ŋgə cɨ yí, bɔ́ɔ́lʉ́gá kú magʉlə. ");
INSERT INTO mcp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bwə́ á ka ŋgə bwɨ́lya bwə́ njúl məcʉ́ŋ məcʉ́ŋ. Pwôl mú kwo cɨ bwo njɨ sâ ŋgwúd nə́: «Sâ Ŋkɛ̧́ŋkɛ̧̂ Shíshim nyə á lás nə impáámbə́ bín mpú mə múúd micúndə́ Izayí dɨ́ yí í mə́ mpu nyîn. Nyə á cɨ nə́: ");
INSERT INTO mcp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kaág kúl búud nɨ dɨ́ kə cɨ nə bwo nə́: “Bɨ mə bá dʉ kənd mə́lwə̂, njɨ bɨ kú bwɛlɛ wámbʉlə; bɨ́ dʉ kənd mísh, njɨ bɨ kú bwɛlɛ dʉ́g, ");
INSERT INTO mcp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","nəcé kúl búúd ga í mə́ shîn lal mílâm. Bwə́ mə́ shîn juwal mə́lwə̂, bwə́ búdal mísh; nə́ mísh máŋ mə́ á bá dʉ́g, məlwə̂ máŋ mə́ á bá gwág, milâm myáŋ mí á bá wámbʉlə, ŋkwuŋgá bwə́ á bá cɛ́nd kuú njɔɔnd, nə́ ndɛɛ́ mə mú lwag bwo.” ");
INSERT INTO mcp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Kagá mpu nə́ Zɛmbî mə́ kənd búúd bwə́ cúgɛ́ Oyúdɛn wá cʉg jé jɔɔŋg. Báá, bwə́ é gwágʉlə nyə.» ");
INSERT INTO mcp_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ja Pwôl nyə a shîn cɨ ntʉ́nɨ yí, Oyúdɛn bwə́ á shwal bwɨ́lya, bwə́ ŋgə́ jág sɛ́ŋʉsa məkə̂l. ");
INSERT INTO mcp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pwôl nyə á já mimbû mímbá oncindî, a ŋgə ji njɔ́w nyə́mɛ́fwó nyə á ŋgə jə́na nə *mwaanɛ̂ yé yí, a dʉ́gə́ lə́g búúd bwə́ á dʉ zə nyə́dɨ́ wá, ");
INSERT INTO mcp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","a ŋgə́ cúndə kɛ́ɛl á Faan mə́ Zɛmbî, a ŋgə́ jɨ́ɨ́gʉli buud minjɨ́ɨ́gʉ́lá mí dʉ́gyá nə Cwámba Yésus-Krîst myá nə́ kpwɔɔ́ kpwɔɔ́, kú nə gúl sâ í ntágʉ́lə́ nyə.");
INSERT INTO mcp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mə Pwôl, lwaá mə́ *Krîst Yésus, mə wə́ mə́ cílə́ kálaad ɛ́ga. Mə á zə bə *muud lwámá mə Yésus nəcé Zɛmbî nyə a jɔ̂w mə nə́ mə bə́g ntɔ́, Zɛmbî nyə a fɛ́ɛ́sh mə nə́ mə bwííŋgʉg Jɔ̧jɔ̧ Kɛ́ɛl dɛ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Bweyʉ́lə Zɛmbî nyə á bwey kaag buud Jɔ̧jɔ̧ Kɛ́ɛl dɔɔŋg, a sá nə́ *buud ɔ mícúndə́ bɛ́ bwə́ cíləg ŋkaagə́ nyɔɔŋgʉ́ Kálaad Zɛmbî dɨ̂. ");
INSERT INTO mcp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Jɔ̧jɔ̧ Kɛ́ɛl dɔɔŋgʉ̂ dʉ́sə lâŋ mə́ mwân yé nyə á zə byɛ̂l mpwoŋ buud mə *Dávid dɨ́ yɛ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Njɨ, Zɛmbî nyə á yə nyə ŋkul á Shíshim mə́ Zɛmbî ja nyə á gwúmʉshi nyə yí; cínɔŋg wə́ nyə á mpu lwágʉlə nə́ Cʉgye wúsʉ́ Yésus-Krîst wɔɔŋgʉ́ jɨ *Mwân mə́ Zɛmbî yɛ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Zɛmbî nyə a fɛ́ɛ́sh mə fééshá á mpaam kwoŋ mə Yésus dɨ́ nə́ mə bə́g *muud lwámá yé. Lwámá wɔɔŋg wɨ́ nə́ mə sáág nə́ ikûl byɛ̂sh í bə́g nə məgwág mə búgə́, jínə́ dɛ́ í mú ŋwa gúmə́. ");
INSERT INTO mcp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Bɨ bʉ́sə nə́mə́ búúd ɔ ikûl nə ilwoŋ byɔɔŋgʉ́, bɨ́ buud Zɛmbî mə́ jɔ̂w nə́ bɨ bə́g buud ɔ Yésus wá. ");
INSERT INTO mcp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mə Pwôl, mə́ cilə bɨ́ buud bɛ̂sh Zɛmbî mə búl cɛɛl nûŋ Róma wá. Nyə a jɔ̂w bɨ́ nə́ bɨ bə́g buud bɛ́. Sɔ́ɔ́ŋgʉ́ wúsʉ́ Zɛmbî bâ Cwámba Yésus-Krîst bwə́ ɔ́ sá bɨ́ mpaam, bwə́ ɔ́ sá nə́mə́ nə́ bɨ ŋgə́g nə cʉgə nə́ shɛɛ. ");
INSERT INTO mcp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mə tɛ́ɛ́d fwo yə Zɛmbî waamə́ akíba kwoŋ mə Yésus-Krîst dɨ́ shú dʉ́n bɨ bɛ̂sh nəcé shí mishwun nyɛ̂sh í ŋgə gwádʉga búgə́ jɨ́n. ");
INSERT INTO mcp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mə ŋgə yə Zɛmbî gúmə́ nə lâm wâm wɛ̂sh nəcé mə ŋgə̌lə bwiiŋg Jɔ̧jɔ̧ Kɛ́ɛl mə mwân yé. Zɛmbî wɔɔŋgʉ́ jɨ wúshinɛd waamə̂ nə́ mə aŋgɛ̂ nə bwɛlɛ yɔw tə́dʉ́gálə bɨ́ bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mə ŋgə wá bɨ́ ja jɛ̂sh mə́jəgʉla mâm dɨ́; mə ŋgə jî Zɛmbî nə́ ŋkí á magʉlə, mə bə́g nə fwámɛ́ fwála mə zə́ nûŋ bɨ́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mə jɨ bul bə nə yéésh nə́ mə dʉ́g bɨ̂. Mə́ cɛɛl kwíínd bɨ́ nə ísâ Zɛmbî mə dʉ yə bwán bɛ́ zhɨ́ɨ́ a *shíshim dɨ́ yí, bɨ mpúg lal búgə́d. ");
INSERT INTO mcp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ntɔ́ jɨ nə́ mə ŋgə jɨɨ nə́ shé bə́g kʉl ŋgwúd shú nə́, búgə́ bɨ́ bɨ́ nə ndɨ̂ mə́ jɨ́ nə́mə́ nə ndɨ̂ yí, í sáág nə́ shé bɛ̂sh bə́g nə məgwɔ̧̂, bɨ́ ŋwa mwo mə́dɨ́, mə ŋwa nə́mə́ bɨ́dɨ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bwaaŋg, mə acɛ́ɛ́lɛ́ nə́ bɨ bə́g kú mpu nə́ mə́ dʉ́ yigʉla nə́ mə zə́ nûŋ bɨ́dɨ́. Mə ŋgə jɨɨ nə́ sɛ́y jâm í bə́g nə́mə́ nə mpumə́ bɨ́dɨ́ nda bíl ílwoŋ dɨ̂. Njɨ, zə wɔ́ɔ́s múús ɨɨ́, məkwowʉla mə́ abɨ́dɛ́ mə nə́ mə zə́g. ");
INSERT INTO mcp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mə jisə nə́ mə bwííŋgʉg buud bɛ̂sh Jɔ̧jɔ̧ Kɛ́ɛl, tɔɔ buud bwə́ mpu cʉg wá, tɔɔ buud bɨ́ kú mpu wá; tɔɔ ompuye ɔ́ ísâ tɔɔ buud bwə́ cúgɛ́ ómpuye wá. ");
INSERT INTO mcp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Gwə́ wə́ mə́ ŋgə́ bul jɨɨ nə́ mə zə́g nə́mə́ bwiiŋg bɨ́ buud ɔ Róma Jɔ̧jɔ̧ Kɛ́ɛl yí. ");
INSERT INTO mcp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mɛɛ mə aŋgɛ̂ nə gwág shwôn nə bwiiŋgʉ́lə Jɔ̧jɔ̧ Kɛ́ɛl dɔɔŋgʉ̂. Nəcé a dʉ́sə nə nyúl ŋkûl mə́ Zɛmbî shú cʉgʉ́lə múúd yɛ̂sh mə *búgʉla yɛ́, tɛ́ɛ́d nə *Oyúdɛn kala nə Ogʉrɛ̂k bɛ̂sh. ");
INSERT INTO mcp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Nəcé otʉ́təlí ɔ́ Zɛmbî bwə́ mə́ nyín Jɔ̧jɔ̧ Kɛ́ɛl dɨ̂. Muud nyə é kumə ótʉ́təlí ɔ́ Zɛmbî bɔɔŋg dɨ́ nə búgə́ nda jɨ́ cilyá Kálaad Zɛmbî dɨ́ nə́. Jɨ́ cilyá nə́: «Tʉ́təlí muud mə dʉ́g cʉg nəcé bə́lə nə búgə́». ");
INSERT INTO mcp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mpugá nə́ Zɛmbî ŋgə lwóya mpimbə jé í ŋgə́ zhu gwɔ̂w, a ŋgə nyada nə buud bwə́ ŋgə́ cʉgə cʉg á kú bísh Zɛmbî ŋgə sá olɨ́lɨŋgɨ̂ wá, nəcé bwə́ ŋgə́ sá nə́ obʉ́bə́lɛ́ bwə́ kú sɛ̂y. ");
INSERT INTO mcp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nəcé, isâ byɛ̂sh búúd bwə́ jə́lá nə mpu shú mə́ Zɛmbî dɨ́ yí, í á mə́ nyîn nə́ ŋgə́ŋ, Zɛmbî nyəmɛ́fwó nyə a mə́ lwó búúd byo nə́ ŋgə́ŋ. ");
INSERT INTO mcp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Jɨ́ ntɔ́. Zɛmbî ŋkul nyɛ́ á kú nə njɨ í aŋgɛ̂ nə nyîn; sâ gwə́mɛ́fwó á jísə́ yí kú nə́mə́ nyîn. Njɨ, tɛ́ɛ́d ja nyə á tɛ́ shí nə gwɔ́w yí, misɔ́ɔ́lʉ́gʉ́ myɛ́ mí ŋgə lwágʉlə ŋkul nyɛ́ nə sâ gwə́mɛ́fwó Zɛmbî jísə́ yí. Múúd mə ká tə́dʉga tə́dʉ́gá á fʉg, a dʉ́g. Buud bwə́ cúgɛ́ ná nə kɔɔd bɨ́ nə ŋkul kaad yí. ");
INSERT INTO mcp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Nəcé bwə́ á mə́ sá nə́, bwə́ mə́ tɛɛm mpu ísâ í dʉ́gyá nə Zɛmbî yí, bwə́ ayə́yɛ́ nyə gúmə́ nə akíba mə jə́lá nə nyə Zɛmbî yɛ́. Wáŋ faasʉ́lə ísâ í mú kú nə mfíí, lâm ímpwúfú wáŋ í mú yídʉ́gʉ́d nə́ ŋkwed. ");
INSERT INTO mcp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Sâ jɔɔŋg í mə́ sá nə́ bwə́ bə́g ilad, njɨ bwə́ ŋgə́ tə́dʉga nə́ bɨ́ nə fʉg. ");
INSERT INTO mcp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bwə́ á mə́ sá nə́, gúmə́ bwə́ jə́lá nə yə Zɛmbî jɨ́ kú bá bwɛlɛ fudə yɛ́, bwə́ ŋgə yida yə ivʉgʉli í ísâ í dʉ bwoo yí, ivʉgʉli í búúd, nə ivʉgʉli í ínunú nə ivʉgʉli í ócúdú nə onywâ. ");
INSERT INTO mcp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Gwə́ wə́ jɨ́ nə́, Zɛmbî nyə a mə́ bɨ́d bwo daŋg-dáŋg nə́ bwə́ ŋgə́g nə bɛ̧ íwɨ́ɨ́mbʉ́g yâ milâm myáŋ, ŋgə sá misɔ́ɔ́lʉ́gʉ́ mí ádʉdanâ, ŋgə sɛ́ɛ́mbʉli mənyúúl máŋ bwə́mɛ́fwó. ");
INSERT INTO mcp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bwə́ á mə́ shwɔ̧́ɔ̧la óbʉ́bə́lɛ́ ɔ́ Zɛmbî, yidá ŋwa bwo nda ijɔ̧́ɔ̧́; bwə́ ŋgə yida kənd gúmə́ ísâ Zɛmbî nyə á tɛ́ yííd, í njúl nə́ Zɛmbî muud nyə a tɛ́ isâ byɛ̂sh yɛ́, nyə wə́ mə́ jə́lá nə gúmə́ kandʉgə á kandʉgə! Amɛn. ");
INSERT INTO mcp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Gwə́ wə́ jɨ́ nə́, Zɛmbî nyə a mə́ bɨ́d bwo daŋg-dáŋg nə́ bwə́ bɛ̧́g iyéésh í ísâ í shwôn. Budá báŋ bwə́ mə́ bɨ́d sálə sɔ́ɔ́lʉ́gʉ́ nə budûm, bwə́ mú yida ŋgə sá bwə́ budá nə budá, í njúl nə́ ntɔ́ dɨ́ Zɛmbî nyə á kwambʉlə bwo nə́ í bág dʉ bə yɛ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nə́mə́ mbií ŋgwûd wɔɔŋgʉ̂, budûm, bwə́ mə́ lʉ́gə nə́ bwə́ bálanʉgɨ́ nə budá, bwə́ mú yida dʉ bə nə́, ŋgwɔ́l múdûm yə nə yéésh shú ŋgwɔ́l. Bwə́ ŋgə sá isâ í shwôn, ŋgwɔ́l múdûm balan nə ŋgwɔ́l nda mudá. Cwagʉwálə bwə́ ŋgə́ cwagʉwa wɔɔŋgʉ̂, bwə́mɛ́fwó bwə́ ŋgə nə́mə́ ŋwa myə́na myâ cínɔŋgʉ́. ");
INSERT INTO mcp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nə́ ndɛɛ́, nda bâŋ bwə́ abíshɛ́ nə́ bwə́ mpúg Zɛmbî nə́, Zɛmbî nyə a mə́ ka bɨ́d bwo daŋg-dáŋg nə́ bwə́ bə́g milúu kú dʉ mpu faas ísâ, ka ŋgə sá isâ bí kú jəla yí. ");
INSERT INTO mcp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bwə́ mú lwándʉ́lá nə olɨ́lɨŋgɨ̂, nə mbíya lâm, nə yéésh mə́bii, nə gwɔ̧́lə lâm, nə zhíŋ, nə məgwú mə búud, nə ozhuyâ, nə məkə́ŋ, nə məfúlú kú nə wúmbʉ́lé; bwə́ kyey nə ontaandɛ̂, ");
INSERT INTO mcp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","sá íkúdʉ́gú, bwə́ mpii Zɛmbî, sá mpyóŋ, ŋkɛ̂ny mə́nyúul, sá bəgʉwa, bul bə nə fʉg sálə mə́bɔ̂w dɨ̂, sá míŋgáádə́ nə obyɔ̂l báŋ. ");
INSERT INTO mcp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bwə́ mú kú ná bɛ̧ mə́cɛ̧ɛ̧, kú gwág múud cɛy lámʉ́d, kú nə lâm íŋkúŋkwoŋ. ");
INSERT INTO mcp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Í njúl nə́ bwə́ ŋgə mpu cígʉ́lá mə́ Zɛmbî nə́ buud bwə́ sá mbií mísɔ́ɔ́lʉ́gʉ́ mínɨ wá bwə́ mpíyá nə shwɨy ɨɨ́, bâŋ bwə́ sá myo, bwə́ gwág nə́mə́ búúd bwə́ sá myo wá nywa. ");