﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcoNT_vpl;
CREATE TABLE mcoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcoNT_vpl WRITE;
INSERT INTO mcoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Cham ngapxa'ñ nmɨydäga'ñɨch pɨn Jesucristo y'ap'ajt yteedy'ajt jadu'n nej yhuɨ'my jaybety. Jesucristo je' oy ap'adyii teedy'adyii David etz Abraham. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham oy ung'adyii Isaac. Isaac oy ung'adyii Jacob. Jacob oy ung'adyii Judá etz y'ajchytɨjc y'uchytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá etz Tamar oy ung'adyii Fares etz Zara. Fares oy ung'adyii Esrom. Esrom oy ung'adyii Aram. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram oy ung'adyii Aminadab. Aminadab oy ung'adyii Naasón. Naasón oy ung'adyii Salmón. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón etz Rahab oy ung'adyii Booz. Booz etz Rut oy ung'adyii Obed. Obed oy ung'adyii Isaí. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí oy ung'adyii rey David. Je rey David je' oy ytöxyɨjc'adyii huɨdɨ anajty Urías ytöxyɨjc'ajtpy. E je' ajcxy y'ung'ajtɨ Salomón. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón oy ung'adyii Roboam. Roboam oy ung'adyii Abías. Abías oy ung'adyii Asa. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa oy ung'adyii Josafat. Josafat oy ung'adyii Joram. Joram oy ung'adyii Uzías. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías oy ung'adyii Jotam. Jotam oy ung'adyii Acaz. Acaz oy ung'adyii Ezequías. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías oy ung'adyii Manasés. Manasés oy ung'adyii Amón. Amón oy ung'adyii Josías. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías oy ung'adyii Jeconías mɨɨd y'ajchytɨjc y'uchytɨjc. Huin'it Babilonia jäy oy mach je israelitas jäy. Chi mɨnɨcxy jɨm Babilonia y'it. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jɨm ma je Babilonia y'it, jɨm Jeconías oy ung'adyii Salatiel. Salatiel oy ung'adyii Zorobabel. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel oy ung'adyii Abiud. Abiud oy ung'adyii Eliaquim. Eliaquim oy ung'adyii Azor. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor oy ung'adyii Sadoc. Sadoc oy ung'adyii Aquim. Aquim oy ung'adyii Eliud. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud oy ung'adyii Eleazar. Eleazar oy ung'adyii Matán. Matán oy ung'adyii Jacob. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob oy ung'adyii José huɨdi oy ñäy'adyii María. E je María oy ung'adyii Jesús huɨdi yxɨɨ Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jadu'n oy ñɨcxy majmactz najtzquëxɨ' Abraham ixtɨ David. Ma je David jamajmactz najtzquëxɨ' chi je israelitas jäy yajtzɨmy yajmajch ma Babilonia y'it, e nañ jamajmactz najtzquëxɨ' chiinɨ oy ymiñ yja'ty je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jadayab capxy ayuc jadu'n nej ymiñ yja'ty je Jesucristo. Jesús ytaj, huɨdi anajty yxɨɨ María, yɨ' tɨ anajty ycapxytungɨxy co ypɨgaangɨxy mɨɨd José; e ma anajty ca'nɨ ñaybudɨgɨ́ɨyɨgɨxy, chi María oy y'ungdzɨmɨ̈gy mɨɨd yɨ Dios yjɨhuɨ'ñ ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, yɨ' ñäy, hue' anajty yɨ' yajpaty janch tudägy. Ca' anajty xɨ̈hua'ñ María mayjäyjoty. Hue' janchtɨy yhuinma'ñybaty co ixmadza'ñ ayüch ameech ca' pɨn yajnejhuɨ̈hua'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huin'it ma jadu'n anajty nihuinmayɨ̈y, chi Huindzɨn Dios tüg y'ángel ñayquëxɨ̈cɨ cumäyjoty ma José, chi ñɨmaayɨ: ―José, David y'ap y'oc, ca' mɨjcajee mdzachhuinmay nej m'octöxyɨjc'adɨɨyb María, com yɨ' y'ung huɨdibɨ yajma'xung'adamy hue' mɨɨd Dios yjɨhuɨ'ñ ymɨc'ajt ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yɨ' ypadamy tüg y'ung e mxɨɨmöhuɨpy Jesús. Jadu'n yɨ' xɨɨ'adɨɨyb com jëgɨ́x co yɨ' yajpocyñïhuädzam ñaax ycajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tüg'ócɨy jada ytundaayɨ yjajtaayɨ ycɨjxy yca'pxy jadu'n nej je Dios anajty tɨ nɨmäy je profeta, je jäy huɨdi Dios y'ayuc najtzcapxɨɨyɨp ma anajty jadu'n yjaybetyɨty: ");
INSERT INTO mcoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Je töxyjäy huɨdibɨ ca' yëydɨjc mɨɨddzɨnäy hue' je' ung tzɨmɨ̈cɨp. Chi ypadamyb tüg je y'ung hue' je' yxɨɨ'adaanɨp Emanuel. Emanuel hue' yhuimbɨdzɨmy Dios mɨɨd ɨɨch ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Co José ymäyhuijy, chi cuyduñ jadu'n nej anajty Dios y'ángel tɨ nɨmäyii, chi huoy María jadu'n nej jɨhuɨɨy töxyɨjc'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per ni ca' ajcxy jadu'n chɨnaay jadu'n nej jäy ypɨcy chɨnäy ixtɨ coonɨ oy María y'ung yajma'xung'aty. Chi yxɨɨmoy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús yma'xung'ajty ma tüg cajp huɨdi yxɨɨ Belén, jɨm ma Judea ñaaxjot, huin'it co anajty Herodes yrey'aty ma yɨ jɨmbɨ naaxjot. Chi huin'it yja'ty ma Jerusalén cajp nijëjɨty yëydɨjctɨjc huidibɨ anajty tɨ choñ ma xɨɨ ypɨdzɨmy, yɨ huɨdibɨ anajty ajcxy xɨɨ madza' tɨ ni'ixpɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Chi ajcxy yajtɨy: ―¿Ma je judíojäy yrey tɨɨbɨ yma'xung'aty? Tɨ ɨɨch ajcxy n'ijxɨ yɨ' ymadza' jɨm ma xɨɨ ypɨdzɨmy, e yɨ' ɨɨch ajcxy ya miñ nhuindzɨgɨ̈huaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Co je rey Herodes jadu'n mɨdooy, chi ooy ytɨgɨɨy tajpɨ maybɨ mɨɨd tüg'ócɨy cajpjäy jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Huin'it je rey huomujctay tüg'ócɨy teedytɨjc huindzɨndɨjc huɨdibɨ anajty yaj'ixpɨjcp yɨ Dios yley, chi yajtɨy ma anajty yma'xung'ada'ñ yɨ Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chi ajcxy y'adzooy: ―Jɨm Belén ma Judea ñaaxjot, com Dios y'ayucnajtzcapxɨɨybɨ jadu'n je' cojaay: ");
INSERT INTO mcoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","E miich Belén, mabɨ Judea ñaaxjot, mɨj'ajtp mgɨx'ajtp ca'ydɨ jac huɨdi naax jac huɨdi cajp, com ma miich chona'ñ tüg Huindzɨn huɨdi ane' mam yɨ israeljäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Huin'it Herodes oy yajhuoyii ameech huɨdibɨ anajty tɨ íjxcɨxy yɨ madza'. Chi tɨybɨjcy yajxon mɨna anajty oga'n tɨ ijxcɨxy je madza'. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","E huin'it ajcxy quejxy jɨm Belén. Chi jadu'n nɨmay: ―Nɨ́cxcɨx jɨm e ocnidɨu ocyajtɨugɨxy je pi'c'anäg; e co anajty tɨ mbatcɨxy, miñ miich ajcxy xyajnɨmáaygɨxyɨch jaydëbɨ ɨɨch nɨcxy nañ jadu'n nhuindzɨgɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Co jadu'n rey najtzcapxɨyday, chi ajcxy choñ. E je madza' tɨɨbɨ anajty íjxcɨxy ma xɨɨ ypɨdzɨmy, chi ajcxy ijxy jayɨjp je' anajty ñɨcxy ma je' ajcxy, ixtɨ conɨ oy je madza' yhuäcxɨpy ma anajty je pi'c'anäg yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Co je rey ixpɨcytɨjc jadu'n ijxy yɨ madza', chi ajcxy oy janch jotcujc ñayjɨhuɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Co ajcxy ytɨjctɨgɨɨy, chi ajcxy ijxy je pi'c'anäg mɨɨd ytaj je María. Chi jada' ajcxy ñaygojxtɨnaydaacɨ huindzɨgɨɨy ojadajty ajcxy je pi'c'anäg. Chi ajcxy yaj'ahuach yxuumy aguejtucy abɨjctucy, chi ajcxy yajpɨdzɨmy oorɨ, poom, etz tüg tzoy huɨdi yxɨɨ mirra. Chi ajcxy moy je pi'c'anäg. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chi cumäyjoty ajcxy nɨmaayɨ co ca' huaad yhuimbijtcɨxy ma Herodes, chi ajcxy ñɨcxnɨ ma ycajp, jüyöyñaxy ajcxy je Herodes, huingbɨ tü'aa ajcxy ycuyñɨcx. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Co je rey ixpɨcytɨjc ajcxy yhuimbijttaayñɨ, chi cumäjoty José ijxy tüg Dios y'ángel, chi ñɨmaayɨ: ―Pɨdɨ̈g, nɨcx jɨm Egipto ñaaxjot mɨɨd yɨ pi'c'anäg etz mɨɨd yɨ' ytaj, e jɨm mhuɨ'mɨpy ixtɨ coonɨ ɨɨch miich nɨmähuɨpy. Com yɨ Herodes y'ixtähuamy yɨ' yɨ pi'c'anäg e yaj'öga'ñ yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chi huin'it José ypɨdɨ̈gy mɨɨd tzooñ coodz je pi'c'anäg mɨɨd ytaj, chi ajcxy ñɨcxy jɨm Egipto. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jɨm ajcxy y'ijty ixtɨ coonɨ oy y'ögy je Herodes. Jada je' jadu'n yajcuydun jadu'n nej Dios anajty tɨ ymɨnañ ma yɨ' y'ayucnajtzcapxɨɨybɨ: “Jɨm Egipto ɨɨch n'ung tɨ nhuoy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Co Herodes oy huinma'ñ yajyöy co tɨ anajty ooy yhuin'ɨɨñyii je rey ixpɨcytɨjc ajcxy co ca' anajty tɨ ñihuimbidyii, chi ooy yjot'ambɨjcy, chi ni'ane'mdɨɨy co huen nɨcxy jɨm Belén etz majaty cajp mɨhuingon Belén, yaj'öctaaygɨxy tüg'ócɨy yɨ pi'c'anäg huɨdibɨ mejtz jɨmɨjt etz huɨdibɨ ca'nɨ nigooty mejtz jɨmɨjt. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","E jadu'n jada yajcuyduñ jadu'n nej anajty Dios y'ayucnajtzcapxɨɨybɨ, je Jeremías, anajty tɨ cojaay: ");
INSERT INTO mcoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Jɨm Ramá yajmɨdoy co anajty chachjɨɨy chachyäxy jäy ajcxy; yɨ Raquel tzachjɨɨyb tzachyaaxp mɨɨd y'ung ajcxy ycɨxpɨ, ca' ajcxy anajty yjotcujc'aty mɨɨd co anajty y'ung tɨ y'öctäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Co oy y'öcnɨ Herodes huin'it jɨm Egipto, Dios tüg y'ángel ñayguëxɨ̈cɨ cumäyjoty ma José. Chi ñɨmayɨ: ");
INSERT INTO mcoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Pɨdɨ̈g, mɨɨdnɨcx yɨ pi'c'anäg etz yɨ' ytaj jɨm ma yɨ Israel ñaaxjot jadügtecy com tɨ y'öctaayñɨ yɨ huɨdibɨ anajty yaj'ögam yɨ pi'c'anäg. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Huin'it José ypɨdɨ̈gy, mɨɨd nɨcxy yɨ pi'c'anäg etz yɨ' ytaj jɨm ma Israel ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per co José nejhuɨɨy co je Arquelao yɨ' anajty jɨm ane'mb jadu'n nej anajty je yteedy Herodes, ooy chɨgɨɨy nej ñɨcxɨp jɨm. E co jadu'n anajty tɨ ycumäy co ca' jɨm ñɨcxɨp, chi ajcxy ñɨcxy jɨm Galilea ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Co jɨm yjäty, chi jɨm chɨnaydacpɨjcy ma je cajp huɨdi yxɨɨ Nazaret. Jadayaabɨ je' jadu'n tun jajtɨ jadu'n nej anajty ycojaayɨty ma Dios y'ayucnajtzcapxɨɨybɨ ñecy co Jesús xɨɨ'adɨɨyb Nazareno. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Huin'it tiempo nañ jadu'n Juan je Bautista (huɨdibɨ jäy yajnɨɨbejtpɨ) ymiñ tüg tɨgɨ̈dum ma Judea ñaaxjot capxhuäcx Dios y'ayuc, ");
INSERT INTO mcoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ymɨnañ: ―Jothuimbíjtcɨx ma Dios com yɨ Dios y'ane'mɨn huingonɨñ yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jada Juan yɨ' je' huɨdibɨ je profeta Isaías nigapxy ymɨnañ: Jɨm mɨjtɨgɨ̈dum yajmɨdoy tüg ayuc mɨna'ñ: “Ni'ixɨɨygɨxy yɨ mHuindzɨn ytü'aa, ni'ixɨɨygɨxy tüg tü'aa tɨɨybɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Je Juan hue' anajty yhuit'ajtpy ɨyujc nïbɨjc (huɨdibɨ jäy ytijpy camello) e hue' anajty yhuɨɨnɨp ɨyujc ac, e yɨ' anajty yjɨcxy'ajtpy mu' etz tijaty ɨyujc päg jɨm tüg tɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Chi chooñ jɨm Jerusalén jäy etz tüg'ócɨy huɨdijaty tzɨnaayb ma Judea ñaaxjot, nañ jadu'n huɨdijaty tzɨnaayb ma Jordán mɨjnɨɨba', ñɨcx ajcxy ma Juan amɨdo'íjtɨy yɨ' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Co anajty ajcxy nigapxtaaygɨxy yɨ ypocy huɨdi anajty tɨ tundɨgooygɨxy, huin'it anajty ajcxy Juan yajnɨɨbedyii ma Jordán mɨj nɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Per yɨ Juan y'ix co may fariseo jäy etz saduceo jäy miñ anajty ajcxy nɨɨbejtcɨxy, chi ajcxy nɨmay: ―¡Miich ajcxy, m'ajuugy m'amɨgüg ahua'n ɨyujc! ¿Pɨn tɨ xyajni'ixɨɨygɨxy nej jëbɨ huaad mgögueeccɨxy yɨ ayo'n huɨdibɨ huingomb? ");
INSERT INTO mcoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yajxon jäy'ajtcɨx tɨydudägy huen niguëxɨ̈gy co tɨ mjothuimbijtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ca' jadu'n mdzachmɨnaangɨxy co Abraham xy'ap'adyii xy'oc'adyii. Ɨɨch miich ajcxy yam ndɨmnɨmaayb co Dios ixtɨ jëbɨ yɨ' yaj'ap'adyii yaj'oc'adyii Abraham jada tzaajot ca'ydɨ miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yɨ jach ni'ixɨ̈ yɨ' y'ijtnɨ ma quipy y'ɨjx, tüg'ócɨy quipy huɨdi ca' oy ytɨm'aty yajpujxp yɨ', e chi jada' yajnögy jɨɨnjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨɨch, janch yajnɨɨbejtpɨch mɨɨd nɨɨ, yɨ' yɨ' jadu'n nej tüg ixpejt co tɨ mjothuimbijtcɨxy; per jacminamb tzojc huɨdi ajcxy xyajnɨɨbedɨpy mɨɨd Dios yjɨhuɨ'ñ etz mɨɨd jɨɨn. Je' ymɨɨd mɨc'ajtɨn etz cötujcɨn, nïgɨ ca'ydɨ ɨɨch, ni xycapaadyɨch nɨcxy ycɨ̈g nyajtecyjendügyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ymɨɨd mɨc'ajtɨn pɨjc-huäcxamy yɨ jäy jadu'n nej jäy huimbojy moc, abɨcy pɨdäga'ñ actz, abɨcy moc pajc. Yujcpɨga'ñ moc pajc ma tze'x ninögɨ̈hua'ñ yɨ moc actz moc jaam jɨɨnjoty ma je jɨɨn huɨdibɨ nicamɨnaaxɨɨ ycapïch. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Huin'it Jesús chooñ ma Galilea ñaaxjot, chi ñɨcxy ma Jordán mɨj nɨɨ ma anajty Juan yjäyyajnɨɨbety, nɨɨbedam anajty yɨ' nañ jadu'n. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan ca'jadɨm'a'ɨxɨ̈y, chi nɨmay Jesús: ―Ɨɨch miich ixyipy xyajnɨɨbejtpɨch, ¿e miich mimb ma ɨɨchɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chi Jesús y'adzooy: ―Jadachambɨ oc'a'ɨxɨ̈ jadu'n, com ooy yɨ' ycopɨtyɨty co nguydundayɨm tüg'ócɨy tɨɨbɨ Dios xyaj'ane'mɨm. Huin'it Juan a'ɨxɨɨy chi yajnɨɨbejty Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Co Jesús ñɨɨbejttay, chi Jesús ijxy Dios yjɨhuɨ'ñ ñigɨdägyii jadu'n nej tüg pi'cmuuxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","E huin'it yajmɨdoy tzajpcɨ́xy tüg ayuc ymɨna'ñ: ―Jada je' ɨɨch n'ung'ajtypɨch huɨdibɨ ooy ndzocyɨch huɨdibɨ ooy mɨɨd jotcujc nayjɨhuɨ̈yiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chi Dios yjɨhuɨ'ñ yajnɨcxy Jesús mɨjtɨgɨ̈duum jaydëbɨ je ca'oybɨ yjot'ixɨɨyb yhuinma'ñ'ixɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jɨm y'ijty jaygay huixchɨgui'px xɨɨ huixchɨgui'px tzuum, e huin'itnɨ ooy yɨböccodyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chi je ca'oybɨ nimɨjhuägy Jesús ocjot'ixa'ñ oc-huinma'ñ'ixa'ñ, chi nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","―Pen Dios miich xy'ung'ajtp, nɨma' jada tzaa huen naygojyii tzajcaagy. Chi Jesús y'adzooy: ―Jaybety jadu'n ymiñ ma Dios ñecy: “Ca'p jäy tzajcaagytɨ'ajty nitzɨnähuɨpy, nañ jadu'n nitzɨnähuɨpy tüg'ócɨy yɨ ayuc huɨdibɨ Dios ycapxp.” ");
INSERT INTO mcoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chi je ca'oybɨ mɨɨdnɨcxy Jesús jɨm Jerusalén, chi ymɨɨdpejty tzajptɨjc cöduum. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chi nɨmay: ―Pen janch co miich Dios xy'ung'adyii, cödɨjpnax jiiby naaxcɨ́xy, ca' yɨ' nej mjadɨpy com jaybety jadu'n ymiñ co jadu'n ymɨna'ñ: Dios yquexyp yɨ' y'ángeles jɨgɨx xycuend'adɨpy xyhuidzɨpy mɨɨd ycɨ', ca'ydɨ ninej mgönepy ma tzaagop. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chi Jesús y'adzooy: ―Nañ jadu'n ymiñ jaybety: “Ca' mjot'ixɨpy mhuinma'ñ'ixɨpy yɨ mhuindzɨn Dios.” ");
INSERT INTO mcoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jadüg'oc je ca'oybɨ ymɨɨd'ajty Jesús ma tüg copnïcx janch cɨjxpɨ, e jɨm yajni'ixɨɨyday tüg'ócɨy naax cajp co ooy mɨɨdɨty oy'ajtɨn etz mɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","E chi nɨmay: ―Ɨɨch jada miich nmoydähuɨpy tüg'ócɨy, pen miich cojxtɨna' xyhuindzɨgɨ̈yɨch xy'ojadatyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Huin'it Jesús y'adzooy: ―Huinhuäctutcɨch miich mujcu', com jadu'n yjaybetyɨty: “Tügpajc yɨ mHuindzɨn Dios yɨ' mhuindzɨgɨ̈huɨpy m'ojadadɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Huin'it je ca'oybɨ huinhuäctucy Jesús, chi Jesús ñimiinɨ ángeles ycuend'ajtɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Co Jesús nejhuɨɨy co Juan tɨ anajty yajpɨdägy pujxtɨgoty, chi yhuimbijtnɨ jadüg'oc jɨm Galilea. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","E ni ca' yhuɨ'mɨɨy jɨm Nazaret, chi ñɨcxy jɨm Capernaum, jɨm ma Zabulón etz Neftalí y'it. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jada je' jadu'n tunɨ jajtɨ jadu'n nej Dios y'ayucnajtzcapxɨɨybɨ Isaías anajty tɨ cojaay: ");
INSERT INTO mcoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón etz Neftalí ñaaxjot. Je tü'aa huɨdibɨ mejypa' huɨdibɨ a'oy'amy ma Jordán mɨj nɨɨ. Jɨm Galileajäy chɨnäy huɨdibɨ ca' yjudiojäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yɨ jäy ajcxy huɨdibɨ jɨm tzɨnaayb agootztuuby ijxpaty ajcxy tüg tɨɨcxɨn jajɨn. Je huɨdijaty anajty ajcxy tzɨnaayb ma je jɨbɨcpɨ y'anicɨ̈y, chi ajcxy ycodɨcxɨɨy tügɨ tɨɨcxɨn jajɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ixtɨ huin'it Jesús ytɨgɨɨy ayuccapxhuäcxp ymɨnañ: ―Jothuimbijtcɨx, yajmingɨx yajmejtzcɨx mjot mhuinma'ñ ma Dios, com yɨ Dios y'ane'mɨn huingonɨp yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús tüyöyb anajty ma Galilea mejypa', co ijxpaty metz yëydɨjc ac tüg quëxpɨ, hue' anajty yɨ' je' je Simón, huɨdibɨ nañ jadu'n yxɨɨ Pedro, e je jadügpɨ hue' je' anajty Andrés. Acxmadzɨɨ anajty ajcxy yɨ' ytung'ajty e jɨm anajty ajcxy yɨ' tzachnɨɨgöhuich y'acxmadzɨ'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chi Jesús nɨmay ajcxy: ―Pajamgɨch, ɨɨch miich ajcxy nyajni'ixɨ̈huɨpy nej jäy myaj'ixpɨgɨpy je Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Huin'it je' ajcxy ixmajtztay tüg'ócɨy yɨ y'acxtzaay, chi ajcxy panɨcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hueenɨ jac'amɨjcɨ'm Jesús ijxy janimetz Zebedeo ajcxy ymang, je Jacobo etz Juan. Jɨm anajty yɨ' ajcxy ma tüg barco mɨɨd yteedy, yɨ' anajty ajcxy yɨ' jɨm chach'adagɨɨyb yɨ huɨdibɨ mɨ'acxmajtzcɨxy. Chi ajcxy Jesús yhuoohuɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","E huin'it ajcxy ixmajtztay je barco etz yɨ' yteedy, chi ajcxy panɨcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Huɨdijttay Jesús ma tüg'ócɨy Galilea ñaaxjot, yaj'ixpɨcy jäy majaty je naymujctac cajp cajp. Capxhuäcxy yɨ Dios ytɨy'ajt etz nañ jadu'n pa'mjäy yajtzocy huen ytɨmyhuɨdipá'mɨty anajty ajcxy ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chi Jesús oy yajnejhuɨɨyñɨ ma tüg'ócɨy yɨ Siria ñaaxjot, e chi ajcxy mɨɨdmiñ ma Jesús tüg'ócɨy huɨdijaty anajty ajcxy ca'oybɨ mɨɨd, etz huɨdijaty anajty ajcxy cɨ̈xuxy tecyxuxy, chi Jesús yajtzoocy. ");
INSERT INTO mcoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huin'it Jesús ypanɨcxɨ mayjäy huɨdijaty anajty ajcxy tzɨnaayb ma Galilea ñaaxjot etz yɨ Decapolis jäy, nañ jadu'n Jerusalén jäy etz huɨdijaty tzɨnaayb ma Judea ñaaxjot, nañ jadu'n huɨdijaty anajty ajcxy tzɨnaayb a'oy'amy ma Jordán mɨj nɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Co Jesús ijxy tüg'ócɨy je mayjäy, chi nɨcxy ma tüg copnïcx, e chi jɨm y'ixtacy. E huin'it je' y'ixpɨjcpɨdɨjc ajcxy yjübigɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chi Jesús ytɨgɨɨy yaj'ixpɨjcp ymɨnañ jadu'n: ");
INSERT INTO mcoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Janch jotcujc je jäy ajcxy huɨdibɨ nejhuɨɨyb co yajmayjajtpy Dios y'oy'ajt, yɨ' ajcxy paatɨp Dios y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Janch jotcujc je jäy ajcxy huɨdi yajpatp taj may, yɨ' ajcxy yajmöhuam jotcujc'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Janch jotcujc je jäy ajcxy huɨdibɨ yung naxpy jäy'ajtp, yɨ' ajcxy padaamb tüg'ócɨy je huɨdi Dios tɨ yaj'ahuanɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Janch jotcujc je jäy ajcxy huɨdibɨ cuydunamb huɨdibɨ Dios chojcpy, Dios yɨ' ajcxy pubedɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Janch jotcujc je jäy ajcxy huɨdibɨ pa'ayoob huenytimpɨnjäyɨty, Dios nañ jadu'n ajcxy pa'ayohuɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Janch jotcujc je jäy ajcxy huɨdibɨ huädz yjot yhuinma'ñ, yɨ' ajcxy y'ixɨpy yɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Janch jotcujc je jäy ajcxy huɨdibɨ ca' ti tzip tzojccɨxy, com yɨ' ajcxy Dios ung'adɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Janch jotcujc je jäy ajcxy huɨdibɨ yajnixiicp yajnigapxp mɨɨd je Dios ytɨy'ajt ycɨxpɨ. Yɨ' ajcxy idamb ma Dios y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Janch jotcujc miich ajcxy co jäy jɨbɨc xytungɨxy co nɨgoob xyñïhuambejtcɨxy etz capxcɨxy huɨdijaty ca' ytɨy'ajtɨty mɨɨd ɨɨch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xondaaccɨx jotcuj'ajtcɨx co mbadaangɨxy tüg oy'ajtɨn jiiby tzajpjoty. Nañ jadu'n ajcxy ixhuɨdijty pahuɨdijty je Dios y'ayucnajtzcapxɨɨybɨ jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jadu'n nej caan ca' yajpüch je tzüch jɨɨcxy tɨm jadu'n miich ajcxy myajpaady ya naaxhuiñ. Pen je caan ca' mɨɨd ti xücx'ajtɨn, ¿nej jëbɨ nyajtuunɨm? Ca' y'oc'oyyajtunɨty, chi yajnajtzxɨdɨɨyñɨ, chi yhuaanɨ tembejt hua'cpejt. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Oc'ix tüg je cajp jɨm copcɨx, ca' jëbɨ mhuijtzyüdzɨm mgoyüdzɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Co tüg jɨɨn nyajtoyɨ̈cɨm, ca' huaad tu'tz ngöjujpɨm. Hue janchtɨy co nyajtɨɨcxɨm cɨx, huin'it jëbɨ xycodɨcxtaayɨm jadu'n nej ajt nyajpaatɨm ma tɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nañ jadu'n miich ajcxy mdzɨnaaygɨxy tudägy ma ajcxy je mayjäy jaydëbɨ ajcxy ixipy je oybɨ huidi miich ajcxy mdumyb. Huin'it ajcxy ojadadɨpy je mDios teedy huɨdibɨ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ca' mhuinmay co ɨɨch tɨ nmiñɨch ya co nbɨgaanɨch je Dios y'ayuc je' huɨdibɨ anajty tɨ jaay Moisés etz je profetɨtɨjc. Ca' ɨɨch nyajmɨjaagɨxa'ñ je cötujcɨn, ɨɨch tɨ nmiñɨch co nguyduna'ñɨch jadu'n nej ymiñ jaaybety. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy, je huɨdibɨ mimb jaaybety jadu'n tundähuam jajtähuam. Ni tüg letra oy mabaad ymúdzɨty nɨcxy ycayajcuyduñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Je jäy huɨdibɨ ca' nimɨdooy je Dios ytɨy'ajt oy yjadɨm mutzjaty etz yaj'ixpɨcy jäy jadu'n, je' ajcxy padamb je mutzpɨ tɨgɨydac ma Dios y'ane'mɨn. Paady je jäy huɨdibɨ yaj'ixpɨjcp jadu'n nej tɨy'ajt ymɨna'ñ, e paduñ jadu'n nej yaj'ixpɨcy, je' ajcxy padamb tüg je mɨjpɨ tɨgɨydac ma Dios y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ɨɨch miich ajcxy nɨmaayb, pen ca' miich ajcxy jac'oy mdúngɨxy ca'ydɨ fariseos etz escribas ajcxy, ca' nimɨna mdɨgɨ̈huɨpy ma Dios y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Miich ajcxy mnejhuɨɨygɨxy jadu'n nej yɨ m'ap mdeedy ajcxy ayuc yajhuɨ'my: “Ca' jäy myaj'ögɨp; e pɨn anajty jäy yaj'öcp ypaadɨp je tzaachypɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ɨɨch miich ajcxy jadu'n nɨmaayb pɨnjaty ymɨgügtɨjc mɨjotma'tp, je' Dios tɨydunaanɨpy; e pɨn ymɨgüg xɨɨdijp tzuudijp, yajtɨydunɨpy je' ma Dios tɨydundac; e pɨn ymɨgüg tzuudijp locɨdijp ayo'ndumb, je' y'ity co ñɨcxɨp ayoodactuuby. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pen myajnɨcxpy miich mhuindzɨgɨ'ñ ma Dios ytɨjc, e pen jɨm jäymetzgodyii co mmɨgüg tɨ xyhuin'ɨɨnnaxy tɨ xyhuincapxynaxy yinjaty hueenjaty, ");
INSERT INTO mcoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jɨm myajhuɨ'm je huindzɨgɨ'ñ ma je altar yhuinduu, e nɨcx jayɨjp nayyaj'oyɨ̈huɨɨ mɨɨd je mɨgüg, huin'it mhuimbedɨp e chɨmgɨ̈yecy je mhuindzɨgɨ'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tzojc naygapxjotcɨdägɨɨ mɨɨd je mɨdzip, pen yam mɨɨd tüyöy nɨɨ'am tü'am, ca' jecyɨty co je mɨdzip xycɨ̈yegɨp ma juez, e je juez xycɨ̈yegɨp ma je policia, e je' nɨcxy xypɨdägy pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Janch tɨy'ajt ɨɨch miich nɨmäy co ca' jiiby mbɨdzɨmɨpy ixtɨ coonɨ mgüejtähuɨpy je meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Miich ajcxy mnejhuɨɨyb co jecyɨp tɨy'ajt ymɨna'ñ: “Ca' mmɨdundɨgoyɨpy huingbɨ töxyjäy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ɨɨch miich ajcxy nɨmaayb, pen ji pɨn huindɨcxy tüg töxyjäy, e jot'adɨɨyb nejjaty, tɨ je' anajty ñitundɨgooyñɨ ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pen yɨ mhuin a'oy'amybɨ xyajtundɨgoyamb tɨm yajpɨdzɨmb; jac'oy co tüg'ɨdu'mbɨ mhuin ytɨgoyɨpy ca'ydɨ co cɨxyca'px mnɨcxɨpy jɨɨnjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","E pen yɨ mgɨ' a'oy'amybɨ xyajtundɨgoyamb tɨm ixpux etz najtzjibibɨ' jɨguem; jac'oy co tüg mgɨ' ytɨgoyɨpy ca'ydɨ co mmɨnɨcxɨpy metz mgɨ' jɨɨnjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nañ jadu'n ymiñ jaaybety: “Pɨn ixmajtzp ytöxyɨjc, huen möhuɨpy tüg necy ti ycɨxpɨ co ñay'ixmájtzɨgɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ɨɨch miich ajcxy nɨmaayb, pen ji pɨn ixmach ytöxyɨjc, e ca' anajty tɨ ytundɨgooy mɨɨd huingbɨ yëydɨjc, je yëydɨjc anajty nigɨydeyɨɨyb ytöxyɨjc co anajty ytundɨgooy mɨɨd huingbɨ yëydɨjc; pɨn yëydɨjc pɨjcp mɨɨd je töxyjäy huɨdibɨ anajty tɨ yaj'ixmach, pocytumyb je' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Miich ajcxy mnejhuɨɨyb nej jecy'ajty m'aptɨjc mdeedytɨjc ajcxy yajnɨmay: “Ca' nɨgo ti m'ahuanɨ̈huɨpy, mguydunɨpy jadu'n nej anajty tɨ mmɨna'ñ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Per ɨɨch miich ajcxy nɨmaayb: ni mga'ɨɨbaadɨp ni mgacapxpaadɨp; ni mgamɨna'nɨp; “y'ijxpy tzajpjotypɨ,” com yɨ' Dios chɨnaydac. E ni mgamɨna'nɨp, “y'ijxpy naaxhuiñybɨ,” com Dios yajpatp oy ytɨmymaajɨty. E ni mgamɨna'nɨp; “y'ijxpy Jerusalén,” com jɨm je' Dios chajptɨjc; ni mga'ɨɨbaadɨp ni mgacapxpaadɨp mgohuajc, com ca' mjaty myaj'ahuimbity poob o tzixy tüg cöhuay. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hue' janchtɨy, tɨydudägy mɨnaangɨxy: “oy” o “ca'.” E pen miich ajcxy anaxy jaccapxp jadu'n mujcu' y'ayuc je' anajty ajcxy mgapxpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Miich ajcxy mnejhuɨɨyb co jecy'ajty yajmɨnañ: “Pen ji jäy mhuiin xyajpɨdzɨmɨ, nañ tɨm jadu'n yhuiin myajpɨdzɨmɨpy; pen ji mɨgüg mdɨɨtz xyajpɨdzɨmɨ, nañ jadu'n myaj'ahuimbidɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per ɨɨch miich ajcxy nɨmaayb: Ca' myaj'ahuimbidɨpy jɨbɨcpɨ ma mɨgügtɨjc; pen ji pɨn xycoxy ma mhuiñyjɨjp tüg adu'mbɨ, jac tɨm mo' jadüg adu'm'amybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pen ji pɨn xyxɨ̈y e xypɨgaanɨ yɨ mnïjen, najtz'ixɨ', huen xyajnɨcxɨ nañ jadu'n mjocx huit. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pen ji pɨn adzip tzɨmy xyajmɨnɨcxa'ñ tüg kilómetro jɨguemɨty, yajnɨcx jac tɨm jadüg kilómetro. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pen tijaty xypɨjctzoohuɨ, mo'. E pen ji pɨn xymɨnuucxa'ñ, yajnuucx. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jadu'n ymiñ jaaybety nej jecyɨp Moisés yjay: “Mɨgüg'adɨɨ yɨ' huɨdibɨ xymɨgüg'ajtp, e mɨdzip'adɨɨ yɨ' huɨdibɨ xymɨdzip'ajtp.” ");
INSERT INTO mcoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ɨɨch miich ajcxy nɨmaayb: Tzoc yɨ' huɨdibɨ ajcxy xymɨdzip'ajtp, etz mɨbɨjctzoohuɨ ma Dios huen y'oy'ajtɨn paady yɨ huɨdibɨ xyñigapx xyni'ojɨɨyb, e nañ mɨ'oyjäy'at yɨ huɨdibɨ xyca'ixamb. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Huin'it miich ajcxy xy'ung'adɨɨby yɨ Dios tzajpjotypɨ huɨdibɨ yxɨɨ yajtɨɨcxp yajjajp ma oyjäydɨjc etz ma jɨbɨcjäydɨjc, nañ jadu'n yajtüy ma jɨbɨcjäydɨjc etz ma oyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pen miich ajcxy mdzojcpy je huɨdibɨ xychojcp, ¿ti jäygɨdaacɨn yɨ' m'ocpadamyb? Nañ jadu'n yɨ' ajcxy yja'ɨdɨɨtzp yɨ pocyjäydɨjc etz yɨ yajcogüejtpɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pen miich ajcxy mgapxpocxyp yɨ mjugymɨgüg, ¿ti oybɨ yɨ'? Nañ jadu'n ajcxy yɨ' yja'ɨdɨɨtzp yɨ huɨdibɨ ajcxy ca' Dios nejhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jäy'ajtcɨx tudägy jadu'n nej ajcxy yɨ mdeedy tzajpjotypɨ ytudägy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ca' mdungɨxy je oybɨ ma jäy y'ixy yhuindɨcxy mɨɨd co mdzachyajhuindɨcxaangɨxy co mdungɨxy oybɨ. Pen jadu'n m'ɨdɨɨtzcɨxy mDios Teedy huɨdi jiiby tzajpjoty tzɨnaayb, ca' ajcxy xymöhua'ñ je oy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Paady co mbubedɨpy mmɨgüg, je ayoobɨ jäy huɨdi yajmayjajtpy tijaty, ca' huaad mnigapxy mnimɨydägy o mnaygömayii co anajty tɨ mmöy tijaty. Yɨ' jadu'n ɨdɨɨtzp je jäy huɨdi mɨj cɨx nayjɨhuɨɨyɨp huɨdi anɨdaacp co huen jäy y'ixyii mɨjpɨdägyii co anajty jadu'n y'ɨdɨ̈ch. Janch ɨɨch miich ajcxy jadu'n nɨmaaygɨx co yɨ' tɨ patcɨxy je oy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Co miich mmöhuɨpy mmɨgüg tijaty yajmayjajtpy, hue' janchtɨy mdunɨpy ca' myajnejhuɨ̈huɨpy huɨdi mɨɨd mnaymɨgüg'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E co miich amoñ m'idɨpy, mDios Teedy huɨdi ijxp co amoñ tijaty mduñ, je' xymöhuamb tüg oy'ajtɨn mayjäyduum. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Co miich ajcxy Dios mmɨbɨjctzoy, ca' jadu'n m'ɨdɨɨtzcɨxy jadu'n nej je jäy huɨdibɨ capxtacp ma Dios huin aguy ahuac aguy. Yɨ' ajcxy capxtacp ma Dios huäctɨna' jiiby tzajptɨgoty jaydëbɨ jäy y'ixɨɨyb etz ymɨjpɨdägɨɨyb. Ɨɨch jëyɨ jadu'n nɨmaayb, co jadu'n oy'ajtɨn'adɨɨby. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","E co miich Dios mmɨbɨjtzoy, nɨcx tɨgoty etz m'agɨ̈huɨpy je mdɨjc aguu. Huin'it Dios mɨbɨjctzou. E je Dios y'ijxpy ymɨdooyb co jadu'n mmɨbɨjctzoy, e je' je m'oy'ajtɨn xymöhuɨipy mayjäyduum. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Com Dios mmɨbɨjctzoy, ca' m'agapxɨyo'cɨp je huɨdi anajty tɨ m'occapxpɨ, jadu'n nej ajcxy y'ɨdɨɨtzcɨxy huɨdi ca' nejhuɨɨygɨxy Dios ytɨy'ajt. Yɨ' ajcxy huinma'ñypɨdägy co mɨɨd ajcxy ymay'ayuc huin'it ajcxy ymɨdoohuɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ca' jadu'n m'ɨdɨɨtzcɨxy jadu'n nej je' ajcxy; mDios ñejhuɨɨyb ti miich ajcxy myajmayjajtpy ma anajty ca'nɨ mbɨjctzooyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","E jadu'n miich ajcxy Dios mɨbɨjctzohuɨpy, jadu'n mɨna'nɨp: Dios Teedy, miich huɨdibɨ tzajpjoty tzɨnaayb; huindzɨgɨ̈y miich mxɨɨ y'ity. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Huen miñ ya miich yɨ m'ane'mɨn. Huen mdzojcɨn yajcuyduñ ma je jäy yjot yhuinma'ñ jadu'n nej yajcuyduñ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mooygɨch ajcxy ngaayɨn n'uucɨn jabom jabom. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Méecxɨbɨch ajcxy nbocy ngaydey huɨdibɨ ɨɨch ajcxy ndundɨgooyb, jadu'n nej ɨɨch ajcxy meecxyɨch huɨdibɨ ajcxy xymɨdundɨgooybɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ca' m'a'ɨxɨ̈y co ɨɨch ajcxy nhuinma'ñ tɨgoyɨpɨch. Yajnïhuaatzcɨch ajcxy ma yɨ jɨbɨcpɨ. Co miich yɨ' mje' je cötujcɨn, je mɨc'ajtɨn etz je oy'ajtɨn huinɨxɨɨ huinɨtiempo. Amén. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pen miich ajcxy mhuinmeecxyp je huɨdibɨ xymɨdundɨgooygɨxp, je mDios Teedy huɨdibɨ tzajpjoty je' nañ jadu'n xyhuinmeecxɨp miich ajcxy mbocy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","E pen miich ajcxy ca' pɨn jäy mhuinmeecxy nej xymɨdundɨgooygɨxy, nañ jadu'n mDios ca' xyhuinmeecxɨp ajcxy ma tɨ mdundɨgooygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Com ajcxy m'ida'nɨp jaygaay jay'ügy (mɨna Dios mmɨbɨjctzoogɨxy), ca' mnaybɨdáaccɨgɨxy tajy may, jadu'n nej ajcxy ɨdɨɨtzcɨxy yɨ' huɨdibɨ ajcxy mɨnamb co Dios mɨbɨjccɨxy e ca' yjanchɨty. Yɨ' ajcxy yajtɨgajchpy yhuiñyjɨjp jɨgɨx jäy ajcxy oc'ixɨɨyb co jaygaay jay'ügy y'ijtcɨxy; jëyɨ jadu'n oy'ajt'adɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Miich ajcxy co m'idɨpy jaygaay jay'ügy jotcujc naybɨdägɨɨ, caax mgohuajc etz puj mhuin mjɨjp, ");
INSERT INTO mcoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ca'ydɨ myajniguëxɨ̈gy mayjäyjoty co m'ity jaygaay jay'ügy, hue' janchtɨy myajniguëxɨ̈g ma je mDeedy huɨdibɨ ca' yaj'ijxy; e je mDeedy huɨdibɨ ijxp huɨdibɨ miich ajcxy ca' mduñ ijxna' quëxna' yɨ' xymöhuɨpy oy'ajtɨn mayjäyduum. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ca' nïgɨ m'adzocy huɨdibɨ ya naaxhuiñ, je' co ya huindɨgooyb oy ytimtijɨty huɨdibɨ yɨ huech yajhuindɨgooyb, huɨdibɨ tougaayɨp etz ma je meetzpɨ ajcxy meetzcɨxy pɨgɨ̈ccɨxy tijaty. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Je' miich nijot'ajtcɨxy je' oy'ajt huɨdibɨ miich ajcxy Dios xymöhuamb jiiby tzajpjoty ma ca' huech yajhuindɨgooy ni ti, e nañ ni ycatougaayii ni ti, etz ma je meetzpɨ ca' ajcxy meetzcɨxy pɨgɨ̈ccɨxy tijaty. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma miich ajcxy mɨɨdɨty je oy'ajt nañ jiiby ajcxy mjot mhuinma'ñ pɨdäg. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yɨ mhuiɨn yɨ' yɨ' jadu'nɨp nej tüg tɨɨcxɨn jajɨn ma mnïnïcx, e paady pen ca' miich yɨ mhuiin xyajtundɨgoy, tüg'ócɨy mjot mhuinma'ñ huädz yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pen miich mhuiin xyajtundɨgoyb nañ jadu'n mjot mhuinma'ñ huɨdi miich mɨɨd ca' y'oyɨty, jadu'n yɨ' nej coodzpɨ ¡jac tɨm nïgɨ ca' y'oyɨty ca'ydɨ je coodzpɨ! ");
INSERT INTO mcoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ni tüg pɨn ca' huaad mɨɨd tuñ metz huindzɨn com mɨjotma'tɨ tüg je', e jadügpɨ chogɨpy; o ixtijɨpy tüg e jadüg ymɨgüg'adɨɨyb. Nañ jadu'n ca' huaad miich ajcxy metz m'ojadajtcɨxy, Dios etz je meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Paady ɨɨch miich ajcxy nɨmaaygɨxy: Ca' mdzachhuinmaaygɨxy ti ajcxy mnitzɨnähuɨpy, ti ajcxy mgayɨpy m'ügɨpy o ti ajcxy mhuit'adɨɨyb mducxy'adɨɨyb. MDios yɨ' tɨ xymooygɨxy je mjugy'ajtɨn, e paady ycɨxpɨ yɨ' nejhuɨɨyb ti ajcxy myajmayjajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oc'ix miich ajcxy yɨ joon huɨdi queec-huɨdijtp. Yɨ' ajcxy ycaniipcɨxy ycatungɨxy, nañ ni ca' yɨ' ajcxy yujcpɨjccɨxy ma tze'x. Miich ajcxy mDios Teedy huɨdi tzajpjoty tzɨnaayb, je' moydaayb huɨdi ajcxy yɨ' yjɨɨcxyp. E miich ajcxy mjactzoobatp ca'ydɨ yɨ joon. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Pɨn ji ma miich ajcxy, ooy mɨj jahuinmay, jëbɨ tüg nuux yjacyeegyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿E na'amy co miich ajcxy mdzachnidajy mdzachnimay mɨɨd je mhuit mducxy ycɨxpɨ? Oc'ix miich ajcxy nej yoñ tüg je pɨjy huɨdi yajpatp tun nïgap. Ni yɨ' ycatuñ ni piidy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per janch tɨy'ajt jadu'n nej nɨmaaygɨxy, ni je comeeñyjäy huɨdi yxɨɨ rey Solomón, ni ycaquipxɨ̈y je' yxojxɨn mɨɨd je pɨjy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E pen mDios xojxpy jadu'n je aay ujtz cham etz tzojcy ytɨɨtztäy ñicxtäy, jac nïgɨ miich ajcxy Dios xymöhua'ñ huɨdibɨ myajmayjajtpy, miich ajcxy huɨdibɨ hueenɨ mmɨbɨjcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Paady ca' nɨgoobɨ mdzachhuinmaaygɨxy ma ajcxy mbaadɨp ti mgayɨpy m'ügɨpy o ti mhuit'adɨɨyb mducxy'adɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yɨ jäy ajcxy huɨdibɨ ca' mɨbɨcy yɨ Dios oy tzach nijot'ajtcɨxy jadayaabɨ, per miich mDeedy huɨdibɨ tzajpjoty je' ñejhuɨɨyb ti miich ajcxy myajmayjajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E pen miich ajcxy mbɨdacpy Dios jayɨjp ma mjot mhuinma'ñ etz mguydun ajcxy yɨ' y'ane'mɨn, huin'it miich ajcxy Dios xymöhuɨpy tijaty myajmayjajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Paady ca' mhuinmaaygɨxy cham mɨɨd je jabom cɨxpɨ, je' co je jabombɨ ymɨmiñ je tajɨn mayɨn. Tzoc mɨjotcujc'ajtɨm je tajɨn mayɨn huɨdi cham nmɨnajx nyajnajxɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ca' m'ix'ijxpy mba'ijxpy ti mmɨgügtɨjc ytundɨgooyb, jɨgɨx ca' Dios xytɨydunɨpy chaachytunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pen miich m'ix'ijxpy mba'ijxpy mmɨgügtɨjc ti ytundɨgooyb, nañ jadu'n miich Dios xytɨydunɨpy xychaachytunɨpy, e yɨ quipxɨ'ñ huɨdibɨ miich mhuamyb quipxɨ'ñ, nañ yɨ' Dios yajtunamyb ma miich. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nej co miich m'ixy huɨdibɨ mmɨgüg ytumyb e hueenɨ ytundɨgooyb, e ca' mnay'ixyii huɨdibɨ miich jac mɨj mdundɨgooybɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Nej jëbɨ mmɨgüg m'ocnɨmäy: “Nbubedamybɨch miich ca'ydɨ mjacpocytuñ”, e miich yam m'ocmɨɨdpɨ jac mɨj pocy? ");
INSERT INTO mcoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Miich cɨ'm mnayhuin'ɨɨñyii. Nɨcx jayɨjp mbocy mgaydey ocyajhuädz, huin'it jëbɨ mbubety je mmɨgüg. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ca' mmöy yɨ jɨbɨcjäydɨjc huɨdibɨ Dios yjë'ajty co nɨcx camɨj'ijx camɨjpɨdaaccɨxy; ni mgayegɨpy Dios y'ayuc ytɨy'ajt ma yɨ jäy ajcxy huɨdibɨ ca' tzojccɨxy Dios y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mɨbɨjctzougɨx yɨ Dios e yɨ' xymöhuɨpy ajcxy; ixtaaygɨx, huin'it mbáatcɨxɨpy; cogapxɨɨygɨx e ahuädzɨp ajcxy mdɨjc aguu. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Com pɨn tijaty pɨjctzoob ypaatyp yɨ'; e pɨn tijaty ixtaayb ypaatyp yɨ'; e pɨn cogapxɨɨyb ma tɨjc aguu, yaj'ahuaatzɨp ytɨjc aguu. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Nej ji jada' miich ajcxy nidügtɨ co m'ung pɨjtzoohuɨpy tzajcaagy nej mmöhuɨpy tüg tzaajɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O pen ypɨjctzooby tüg acx nej mmöhuɨpy tüg tza'ñɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Miich ajcxy oy mjɨbɨcjäyɨty e mjajtpy ajcxy nej m'ung m'anäg mmöhuɨpy je oybɨ. ¡Nïgɨ Dios Teedy tzajpjotypɨ möhua'ñ je oybɨ pɨnjaty pɨjctzoob! ");
INSERT INTO mcoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tzɨnaaygɨx tɨydudägy mɨɨd je mmɨgügtɨjc, pen miich ajcxy mdzojcpy co je mmɨgügtɨjc chɨnähuɨpy tudägy mɨɨd miich ajcxy; com jadu'n y'ane'my Moisés yley etz yɨ Dios y'ayuc najtzcapxɨɨyb ajcxy ñecy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tɨgɨɨygɨx ma yɨ tɨgɨyɨɨydac xützpɨ: yɨ tɨgɨyɨɨydac etz yɨ tü'aa huɨdibɨ ja'tp ca'oydactuuby mɨj huin yɨ', e may jäy ajcxy oy ji ytɨgɨyɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","E janch je tɨgɨyɨydac etz yɨ tü'aa huɨdibɨ ja'tp ma je jugy'ajtɨn huinɨxɨɨbɨ, xüdz je' etz tzip naxɨɨyñɨ; janch tɨm hueenɨ jäy huɨdibɨ ji nɨcxɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nayguend'ájtɨgɨx mɨɨd yɨ jäy anɨɨjatypɨ huɨdibɨ ajcxy mɨnamb co Dios ytɨy'ajt yaj'ixpɨjcp, huɨdibɨ ajcxy huɨdijtp janch yung janch naxy ñaybɨdaaccɨxy nejɨhuɨ̈y ooy oy huinma'ñ mɨɨdɨty; nɨgoobɨ ajcxy jadu'n ñaybɨdägyii, ymɨɨd ajcxy jɨbɨc-huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Miich ajcxy jëbɨ m'ijxcapy nejjaty ajcxy mɨɨdɨty chɨnaayɨn yjugy'ajtɨn; ca' pɨn caamuxy cha'm tucy ma apy quipy, e nañ jadu'n ca' pɨn higo tɨɨm tucy ma jaam'apy quipy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Je quipy huɨdibɨ ooy y'oyɨty, oy yɨ' ytɨɨm'aty. Je quipy huɨdibɨ ca' y'oyɨty, ca' yɨ' oy ytɨɨm'aty. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","E je oybɨ quipy ca' huaad ytɨɨm'aty jɨbɨc. E je quipy huɨdibɨ ca' y'oyɨty ca' ytɨɨm'aty oy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tüg'ócɨy je quipy huɨdi ca' oy ytɨɨm'aty, cɨxy yajpujxp je'. Chi jada' yajnögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nañ jadu'n miich ajcxy jëbɨ mnejhuɨ̈y jadu'n nej jäy yjäy'aty co m'ixɨpy nej chɨnäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ca' nmɨnaanɨm nidüg'ócɨy jäy ajcxy ytɨgɨ̈huɨpy jiiby tzajpjoty huɨdibɨ xyñɨmaaybɨch: “Huindzɨn, Huindzɨn”, jëda'ajty ajcxy tɨgɨ̈huamb huɨdibɨ ycapxymɨdooyb je Dios chojcɨn y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mayjäy oy mɨna'na'ñ huin'it xɨɨ huin'it tiempo: “Huindzɨn, Huindzɨn”, tɨ ɨɨch ajcxy ngapxhuäcxy miich m'ayuc, e mɨɨd miich mxɨɨ tɨ ɨɨch ajcxy nyajpɨdzɨmy je ca'oybɨ; etz mɨɨd miich mxɨɨ tɨ nduñ ɨɨch ajcxy mɨj huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Huin'it nɨmähuɨpy: “Camɨnaabɨ miich ajcxy tɨ nga'ixy'adyii; huinhuäctutcɨch miich jɨbɨc tumbɨdɨjc ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nidüg'ócɨy pɨnjäy huɨdibɨ xymɨbɨjcpɨch etz mɨdooyb jadu'n nej ɨɨch n'ane'myɨch yɨ' ajcxy quipxyjaty mɨɨd je jäy huɨdibɨ cohuinma'ñ huɨdibɨ ytɨjc ycojp ma yhuingɨ́xɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Co ymɨcpojtüy etz ycomy je mɨj nɨɨ, ca' ypadyii nɨɨgom je tɨjc, je' co anajty cɨxy je' ycojyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per yɨ' ajcxy huɨdibɨ mɨdoob e ca' cuyduñ huɨdibɨ ngapxpɨch, je' jadu'nɨp nej tüg jäy huɨdi janch locɨ huɨdi ytɨjccoj ma pu' jot. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Co ymiñ je mɨc poj tuu, chi ycomy je mɨj nɨɨ. Chi ycɨday je ytɨjc; mɨj ayo'n oy yjajtɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Co Jesús ycapxtay ymɨydactay, chi je jäy ooy huinmay jadu'n nej anajty tɨ yaj'ixpɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Com je' co Jesús anajty yaj'ixpɨcy nej tüg huɨdibɨ cötujcɨn mɨɨd, ca' yjadu'nɨty nej je escribas ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Co Jesús oy choonɨ ma je cögop, chi ypagɨdacɨ mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huin'it ñimiinɨ tüg jäy jɨbɨc pützpa'mmɨɨdpɨ. Chi ycojxtɨnay'ahuɨɨy ma Jesús yhuinduu. Chi minañ: ―Huindzɨn, pen m'a'ixɨɨyb jëbɨ xyajtzögyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Huin'it Jesús nïdooñ je jäy. Chi nɨmay: ―Ndzojcpyɨch, jëbɨ mdzögy. Co Jesús jadu'n nɨmay je pa'mjäy huin'ítɨy je ypützpa'm oy ytɨgooy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chi Jesús nɨmay: ―Ca' pɨn myajnɨmäy; nɨcx janchtɨy ma je teedy. Mɨnɨcx tüg huindzɨgɨ'ñ huɨdi Moisés y'ane'my. Huin'it jëbɨ yɨ jäy ajcxy ixɨpy co tɨ m'agɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Co Jesús yja'ty jɨm Capernaum huin'it tüg capitán ñimiinɨ e ycohuanɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Chi ñɨmaayɨ: ―Huindzɨn, jɨm ɨɨch tüg ndumbɨ ma ɨɨch ndɨjc huɨdi tɨm cöcnaayñɨp, ca' y'ocyücxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chi Jesús mɨnañ: ―Ɨɨch nɨcxy nyajtzögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chi je capitán y'adzooy: ―Huindzɨn, ca'p ɨɨch n'oyjäyɨty, ca' yhuaadɨty mdɨgɨ̈huɨpy ma ɨɨch ndɨjc, jëyɨ miich nɨgoo capxy e tɨ anajty ɨɨch ndumbɨ chögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ɨɨch nañ jadu'n ane'my n'ityɨch, e nañ nmɨɨdɨch soldadtɨjc cɨ̈'am. Co ɨɨch nɨmäy: “Nɨcx”, nɨcxp; e co ɨɨch nɨmäy: “Min”, mimb; e co n'ane'myɨch je nbödumbɨch huen tijaty tun, ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Co Jesús jadu'n mɨdooy, chi nɨgoobɨ ycɨjxy ycuejty. Chi ajcxy nɨmay huɨdi pahuidijtɨp: ―Janch tɨy'ajt jadu'n nej nɨmaaygɨxy, ma Israeljäy ymiñ, ca' jadu'n tɨ nbaadyɨch huɨdi oy mɨbɨcy jadu'n nej jadayaabɨ yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ɨɨch jadu'n nɨmaayb co mayjäy oy miinaangɨxy xɨɨpɨdzɨmy'amy xɨɨcɨdägy'amy, chi ixtäga'ñ quipxyɨ mɨɨd Abraham, Isaac etz Jacob jiiby ma Dios y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Je judíojäy huɨdibɨ ixyipy ajcxy jëbɨ yjatzɨnäy jiiby tzajpjoty, je' ajcxy nɨcxamb agootztuuby, jiiby ajcxy yjɨ̈huɨpy yäxɨpy etz y tɨɨtzmúcxɨpy ytɨɨtzqueedɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Huin'it Jesús nɨmay je capitán: ―Nɨcx ma mdɨjc. Jadu'n nej miich xymɨbɨcyɨch, tɨ ɨɨch yam nguyduñ. Chi je tumbɨ oy chögy tɨm huin'it hora. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chi Jesús ñɨcxy ma Pedro ytɨjc. Chi ijxy je Pedro ymɨ̈d co jɨm cɨjx'am ycöcnäy mɨɨd je toyba'm. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Co Jesús cɨ̈nïxajy huin'it je toyba'm ñajxy. Chi pɨdɨ̈gy. Chi mɨc'amy ni'ixɨɨy je caayɨn uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Co oy chu'ɨɨyñɨ ycoodzɨɨyñɨ huin'it yajmɨmiñ ma Jesús may je huɨdi ca'oybɨ mɨɨd. E mɨɨd yɨ' y'ayuc yjëda'ajty ypɨdzɨmday je ca'oybɨ, e huin'it tüg'ócɨy je pa'mjäy chooctay. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jadayaabɨ je' ytunɨ yjajtɨ jɨgɨx yajcuyduñ jadu'n nej je profeta Isaías mɨnañ: “Yɨ' cɨ'm ajt nyuu nba'm tɨ xyajtzoctaayɨm etz yɨ pɨjcɨn ixɨn tɨ yajnɨcxtäy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Co Jesús ijxy janch mayjäy anajty tɨ yjübigɨ̈yii, chi nɨmay co huen nájxcɨxy jɨm'amy mejy nïnaxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Huin'it ñimiinɨ tüg escriba. Chi nɨmay: ―Huindzɨn, nbanɨcxamybɨch miich oy janch tɨm ma'amy ma anajty mnɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Chi Jesús y'adzooy: ―Je huaax ymɨɨd je' ajcxy yjut, e je joon ymɨɨd je' ajcxy ype'ñ. Per ɨɨch, je jäy huɨdibɨ tzoon jiiby tzajpjoty, ca' nmɨ́ɨdɨdyɨch ma nmähuɨbɨch ma nbócxɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E jadügpɨ ydiscípulo ymɨnañ: ―Huindzɨn, nɨcx jayɨjp ndeedyɨch n'ocyajnaaxtɨgɨ̈yɨch huin'it nbanɨcxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Huin'it Jesús y'adzooy: ―Pamiingɨch, ixmajtzcɨx yɨ öcpɨ huen ymɨɨ'öcpɨ yajnaaxtɨgɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Huin'it Jesús oy ybarcotɨgɨɨyñɨ. Chi ypadzoonɨ je ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","E jɨm anajty ytüyöy mejyhuingɨ́xy, huin'it mɨc poj ñaymɨbɨdzɨmɨ. Janch mɨc y'ocpɨdɨ̈cnɨ je mejy jɨgo jɨgo je barco cayajnïdɨgoy, pero Jesús anajty chachmaab. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Huin'it oy ymɨgapxyii yajmäybɨdɨ̈gyii je' ydiscípulos ajcxy. Chi ñɨmaayɨ: ―¡Huindzɨn, ocyajtzoogɨch ajcxy! ¡Cheeby ɨɨch ajt n'ocquiinɨm! ");
INSERT INTO mcoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Huin'it Jesús y'adzooy: ―¿Na'amy co mdzachtzɨgɨ́ɨygɨxnɨ? ¡Miich ajcxy hueenɨ mɨɨdɨty mɨbɨjcɨn! Huin'it Jesús ypɨdɨ̈gy. Chi mɨgapxy je poj etz je mejy. Huin'it je mejy etz je poj yhua'cxɨjptay. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","E je' ydiscípulos ajcxy nɨgoobɨ y'occɨ́x y'occuejtnɨ chachmɨnaangɨxy: ―¿Pɨn yëydɨjc jada jada', co je mejy je poj tɨ ycapxymɨdoyii? ");
INSERT INTO mcoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Co Jesús yja'ty ma yɨ nɨɨba' ma yɨ Gadara ñaax ycajp, chi metz yëydɨjc, huɨdi anajty ca'oybɨ mɨɨd oy yjɨjpcoyöyɨ̈yii anajty ajcxy, tɨ chooñ ma je öcpɨ jut. Yɨ jäy ajcxy ooy janch ahua'n, e ca' anajty huaad jɨm ni pɨn ñaxy ma je tü'aa. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","E co anajty Jesús jɨm ñaxy huin'it janch ahua'n ymɨgapxqueecɨ: ―¿Ti miich mdunamyb mɨɨd ɨɨch ajcxy, Jesús, miich Dios y'ung? ¿Nej tɨ mmiñ jayɨjp co xychaachytúngɨxɨch ma ca'nɨ xɨɨ tiempo paady? ");
INSERT INTO mcoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jɨguem ma anajty ajcxy je' yajpaady jɨm anajty may'ɨdzɨm y'ojccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chi je ca'oybɨ ymɨnañ: ―Pen miich xyajpɨdzɨm ɨɨch ajcxy, xyaj'adɨgɨɨygɨxy xyajjottɨgɨɨygɨxy yɨ may'ɨdzɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chi Jesús ñɨmay yɨ' ajcxy: ―Nɨcxcɨx. Huin'it ñïhuaatzɨ je yëydɨjc je ca'oybɨ. Chi oy ytɨgɨɨygɨxy je ca'oybɨ ma je ɨdzɨm. Huin'it je ɨdzɨm oy ñɨɨgöboyɨ̈ctäy. Jiiby ajcxy yjïcxtäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","E je jäy ajcxy huɨdibɨ anajty ɨdzɨm ycuend'ajtp, huin'it ajcxy yqueegy mɨɨd je tzɨgɨ'ñ. Chi co ajcxy yja'ty cajpjoty, huin'it ajcxy ytɨgɨɨy mɨydaacpɨ jadu'n nej anajty tɨ ytuñyii tɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","E huin'it chonday je mayjäy ma je cajp. Chi ajcxy ninɨcxy je Jesús. E co ajcxy ijxpaty, huin'it ajcxy cohuanɨɨy co huen pɨdzɨmnɨ ma je naax je cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chi Jesús ybarcɨtɨgɨɨy. Chi ñɨcxy jɨm'amy mejyñaxy. Chi oyjäty ma ycɨ'mgajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E jɨm yajmɨmiñ tüg yëydɨjc huɨdibɨ anajty cɨ̈mät tecymät. Yajcɨɨy ymiñ ma'ndzaayjoty. E co Jesús ijxy co ymɨɨd je mɨbɨjcɨn, chi nɨmay je pa'mjäy: ―Jotcugɨ' miich, tɨ je mbocy nhuinmeecxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Huin'it nijëjɨty je escribas ajcxy, je ley yhuindzɨn, jot'ajtɨ: “Jadayaabɨ yëydɨjc capxtɨgooyb yɨ' ma Dios co jadu'n ymɨna'ñ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Com Jesús ñejhuɨɨy jadu'n nej anajty ajcxy je jäy tzachjot'ájtɨgɨxy, chi ajcxy nɨmay: ―¿Nej co ajcxy jɨbɨc mdzachjot'ájtɨgɨxy jotjoty huinma'ñyjoty? ");
INSERT INTO mcoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Huɨdibɨ ca' chipɨty, co nmɨná'ñɨbɨch: “Tɨ yɨ mbocy nhuinmeecxɨch”, o co nmɨná'nɨbɨch: “Pɨdɨ̈g etz tüyöy”? ");
INSERT INTO mcoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ɨɨch ndzojcpyɨch co miich ajcxy mhuinjɨhuɨ̈huɨp co ɨɨch tɨ ndzooñɨch tzajpjoty e paady nmɨɨdɨch je cötujcɨn ya naaxhuiñ e jëbɨ nhuinméecxɨbɨch pocyjäy ajcxy. Huin'it Jesús nɨmay je cɨ̈mätpɨ tecymätpɨ: ―Pɨdɨ̈g, huijtzɨ̈g yɨ mdögy etz nɨcxnɨ ma mdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chi je cɨ̈mätpɨ tecymätpɨ ypɨdɨ̈gy. Chi ñɨcxy ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","E co je mayjäy jadu'n ijxy, huin'it ajcxy ooy jɨhuɨɨy huinmay. Chi ajcxy ooy ojadaty yɨ Dios co anajty tɨ yecy je mɨc'ajtɨn ma mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Co Jesús oy choonɨ jɨm, huin'it ijxy tüg yëydɨjc, yxɨɨ Mateo, huɨdibɨ anajty ɨñaayb ma yajcogüejttac. Chi nɨmay: ―Pajamgɨch. Huin'it Mateo ytɨnayɨ̈gy. Chi panɨcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jadu'n ytunɨ yjajtɨ co Jesús jɨm ycay ma Mateo ytɨjc, e may nañ jadu'n ymiñ yajcogüejtpɨdɨjc etz pocyjäydɨjc. Chi ajcxy jɨm tú'cɨy y'ixtactay mɨɨd Jesús etz mɨɨd yɨ' ydiscípulos. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Co je fariseos jadu'n ijxy ajcxy, chi nɨmay ajcxy je' ydiscípulos: ―¿Na'amy co yɨ mHuindzɨn ycaymucy mɨɨd je yajcogüejtpɨdɨjc je pocyjäydɨjc? ");
INSERT INTO mcoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Co Jesús jadu'n mɨdooy huin'it nɨmay ajcxy: ―Ca' yajmayjaty tzoydumbɨ huɨdi ca' ajcxy ypɨgyii, jëyɨ huɨdi ajcxy pɨjcɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nɨcx ixpɨjccɨxy nej ymiñ jaaybety ma Dios ñecy: “Ɨɨch ndzojcpyɨch co miich ajcxy mɨɨd'adɨpy je pa'ayo'n, ca'ydɨ co myajhuindzɨgɨ̈y tijaty ɨyujc.” Ca' ɨɨch tɨ nmiiñɨch ma je jäy ajcxy huɨdibɨ ca' pocy mɨɨdɨty. Ɨɨch tɨ nmiiñɨch mɨɨd yɨ pocyjäy ycɨxpɨ co huen jothuimbijttaaygɨxy ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Huin'it ajcxy ymiñ Juan ydiscípulos ma Jesús. Chi je ajcxy nɨmay Jesús: ―¿Na'amy co ɨɨch ajcxy etz fariseo ajcxy ayuu'ijtcɨxy, e yɨ' ajcxy huɨdibɨ xymɨɨdhuɨdijtp ca' ajcxy ayuu'íjtcɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Huin'it Jesús y'adzooy: ―¿Nej jëbɨ yaj'ayuu'aty jäy ajcxy huɨdi yajpaatpɨ ma je pɨjcpɨ yajnixɨɨduñyɨ, pen quipxyɨ yam yajpaady mɨɨd je huɨdibɨ pɨjcp? Minamb je xɨɨ je tiempo mɨna je pɨjcpɨ yajtzonɨɨyb, huin'it janchtɨy ajcxy jëbɨ y'ayuu'ajtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ni pɨn tuc huit ca' agɨyɨɨy mɨɨd tüg pedas jemyhuit, com nïgɨ je tuc huit ñajtzcɨɨdzɨ̈y, chi nïgɨ o'ctɨy yjajtnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ca' pɨn pɨdägy vino nɨɨ ma tucpɨ cochac, ycɨɨdzɨp je', e tüg'ócɨy anajty tɨ y'ayoodäy je vino nɨɨ mɨɨd ñigochac. Pɨdägɨpy ajcxy jemy vino ma jemy cochac, chi jadu'n ca' ayoohuɨpy je vino, ni huindɨgoyɨpy je cochac. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ma anajty Jesús jɨm ycapxy ymɨydägy huin'it ymiñ tüg mɨjjäy. Chi ñaygojxtɨnay'ahuɨy ma Jesús yhuinduu. Chi ymɨnañ: ―Nnɨɨxɨch tɨ y'ögy. Nɨcx ma ɨɨch ndɨjc etz mgɨ̈nïxajɨpy, jugypɨgɨpy ya. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Huin'it Jesús ypɨdɨ̈gy. Chi ñɨcxy mɨɨd je ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma anajty ajcxy jɨm ytüyöy huin'it ymiñ jɨxcɨ'py'amy tüg töxyjäy huɨdi yxɨɨ ybo' tɨ mɨ'ijtɨɨyñɨ majmetz jɨmɨjt. Chi nïdonɨ Jesús yhuitpa'. Huin'it ñajxy je' ypa'm. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","22","Jadu'n anajty tɨ yjot'adyii: “Oy Jesús jëda'ajty yhuitpa' nnïdónɨbɨch, tɨ ɨɨch anajty n'agɨdäygɨch.” Huin'it Jesús yhuäc-huimbijty. Chi huindɨcxpejty je töxyjäy. Chi nɨmay: ―Jotcujc'at miich, tɨ m'agɨdägy jɨgɨx co xymɨbɨcyɨch. E tɨm huin'it hora oychögy je pa'mjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chi Jesús oy yjäty ma je mɨjjäy ytɨjc. Chi ijxy je xuuxpɨdɨjc mɨɨd je ymɨgügtɨjc ajcxy huɨdi chachyaaxcɨxy co anajty tɨ y'ögy je töxy'anäg. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Huin'it Jesús nɨmay ajcxy: ―Queccɨx ya, yɨ pi'ctöxy'anäg ca' yɨ' tɨ y'ögy. Hue' yɨ' maab. Huin'it ajcxy nɨgo nɨxiicy yajxiicy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Co anajty je jäy tɨ ixquejxtäy, chi Jesús ytɨjctɨgɨɨy ma anajty je töxy'anäg huijtznäy. Chi majch ma ycɨ'. Chi ypɨdɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chi je jäy oy yajnejhuɨɨydaayñɨ ma je jɨmbɨ naax cajp nej anajty tɨ ytuñyii tɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ma anajty jɨm tɨ choñ huin'it metz jäy huintzpɨ ypamiinɨ. Chachñɨmäyii jadu'n: ―¡Pa'ayoogɨch ajcxy, miich David y'ap y'oc! ");
INSERT INTO mcoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chi Jesús yajpajäty ma anajty tɨ yjättägy. Co ytɨgɨɨy tɨgoty, chi Jesús yajtɨɨy: ―¿Nej mmɨbɨjcpy miich ajcxy co jëbɨ nyajhuindɨcxɨ̈ccɨxy? Huin'it je' ajcxy y'adzooy: ―Mɨbɨjcy ɨɨch ajcxy, Huindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Huin'it Jesús nïdoñ je jäy ajcxy huintzpɨ ma yhuiin. Chi nɨmay ajcxy: ―Jadu'n nej miich ajcxy mmɨbɨcy, jadu'n ytunɨɨb yjadɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chi je' ajcxy y'ijxɨ̈gy. Huin'it Jesús y'ane'mɨn pɨdacy: ―Ca' huaad pɨn myajnejhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Co je' ajcxy ñɨcxnɨ, chi ajcxy ooy nigapxy nimɨydacy co Jesús anajty tɨ yaj'ijxɨ̈cɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Co anajty je' jɨm tɨ chongɨxy, huin'it ajcxy mɨmiñ ma Jesús tüg yëydɨjc huɨdibɨ uum huɨdibɨ anajty ca'oybɨ mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E co Jesús yajpɨdzɨmy je ca'oybɨ, chi je mayjäy ooy ycɨjxy ycuejty ajcxy. Chi ajcxy mɨnaangɨxy: ―Ni camɨna jadu'n ycayaj'ixy ya ma jada Israel naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per je fariseos jadu'n ymɨnaangɨxy co Jesús je' mɨɨd je ca'oybɨ ymɨc'ajt yajpɨdzɨmy ca'oybɨ ma jäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús jadu'n yhuɨdijty cajp cajp yaj'ixpɨjcy majaty tzajptɨjc. Yajhuingapxɨ̈y je jäy Dios y'ayuc. Etz nañ jadu'n yaj'agɨdacy huen ytɨm huɨdi yuu huen ytɨm huɨdi pa'mɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Co Jesús jadu'n ijxy je mayjäy, chi oy pa'ayoonɨ co yɨ' ajcxy ca' mɨɨdɨty ni pɨn huɨdibɨ jëbɨ ñajtzcapxɨ̈y Dios y'ane'mɨn. Yɨ' ajcxy jadu'n yajpatp nej cöbixy huɨdi ca mɨɨdɨty cuend'ajtpɨ. Ca' nejhuɨɨygɨxy pɨn y'ane'mɨp e pɨn ypanɨcxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Huin'it Jesús nɨmay yɨ' ydiscípulos ajcxy: ―Tɨy'ajt yɨ', janch mɨj je tung e hueenɨ je tumbɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Paady pɨjctzou miich ajcxy ma Dios co huen quexy tumbɨdɨjc ma yɨ' ytung. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Huin'it Jesús huoy je nimajmetz discípulos. Chi moy ajcxy cötujcɨn jëbɨ huaad yajnïhuäch je huɨdi ca'oybɨ mɨɨd. Etz nañ jadu'n yaj'agɨdägɨp huen ytɨm huɨdi yuu huen ytɨm huɨdi pa'mɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jada je' je nimajmetzp yxɨɨ: Simón, huɨdi nañ jadu'n yajtijp Pedro, etz ymɨguëx Andrés; Jacobo etz y'uch Juan, Zebedeo ymang; ");
INSERT INTO mcoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo, je yajcogüejtpɨ; Jacobo, Alfeo ymang; Lebeo, huɨdi nañ jadu'n yajtijp Tadeo; ");
INSERT INTO mcoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, je cananista; e Judas Iscariote, je huɨdi ycɨ̈yejc Jesús agojɨx. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Chi Jesús quejxy yɨ nimajmetzpɨ, e jadu'n najtzcapxɨɨy ajcxy: ―Ca' ajcxy mnɨcxɨpy ma je naax cajp ma ajcxy je jäy chɨnäy huɨdibɨ ca' ajcxy Israeljäyɨty. Ni mgatɨgɨ̈huɨpy ajcxy ma Samaria naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nïgɨ jac'oy co ajcxy mnɨcxɨpy ma je Israeljäy huɨdibɨ ca' nejhuɨ̈y huɨdibɨ ca' paduñ Dios ytɨy'ájtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nɨcx miich ajcxy capxhuäcx Dios y'ayuc co tɨ yhuingonɨ Dios y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yaj'agɨdaaccɨxy yuujäy pa'mjäy huɨdijaty pützpa'm ymɨɨd. Myajjugypɨjccɨxy tɨɨbɨ ögy. Myajnïhuädzɨp huɨdi ca'oybɨ ymɨɨd. Ninɨgoobɨ miich jada cötujcɨn tɨ myajmooygɨxy, nañ ninɨgoobɨ yejccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ca' ni ti meeñ mmɨnɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ca' mbijty mmɨnɨcxcɨxy tü'amgɨxpɨ. Mmɨnɨcxcɨxy jëda'ajty yɨ mhuit huɨdi mɨɨd ma mnïnïcx. Ni mgamɨnɨcxɨp huingbɨ mgɨ̈g etz mdajc; com ycopɨcɨty co je cajpjäy xyajcáaygɨxɨpy xyaj'úuccɨxɨpy miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Co anajty mjäty miich ajcxy ma tüg cajp nidɨu yajtɨu pɨnjäy jɨm tudäcyɨp. Jɨm ajcxy mhuɨ'mɨpy ma je' ytɨjc ixtɨ coonɨ ajcxy mdzoonɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Co anajty miich ajcxy mdɨgɨ̈y tɨgoty huin'it mgapxpócxcɨxɨpy je codɨjc jadu'n nej tzocy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","E pen je codɨjc ymɨhuaad'ajtpy, yejccɨxy jɨm ɨɨbocxɨn capxpoocxɨn. E pen je jäy ca' ytudägyɨty, ñaadɨgɨ̈'adɨp huɨdi anajty tɨ mgapxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","E pen ca' pɨn xycöbɨgaangɨxy, e ni pɨn xycamɨdohuaanɨ ajcxy m'ayuc, pɨdzɨmgɨx jɨm ma je tɨjc o ma je cajp. Chi ajcxy mdecy huinnebɨpy, je' je' je tɨy'ajt co ca' miich ajcxy ti pocy mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co anajty je xɨɨ tiempo paady ma anajty yajtɨyduna'ñ je naaxhuiñyjäy, jac nïgɨ yajtzaachytuna'ñ yɨ' ajcxy ca'ydɨ yɨ jäy ajcxy huɨdibɨ tzɨnaayb ma Sodoma cajp etz ma Gomorra cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","¡Ocmɨdoogɨx! Ɨɨch yam miich ajcxy nguejxyp majaty yɨ jäy huɨdi jɨbɨc-huinma'ñ mɨɨd. Jadu'n nipaady nej ɨɨch nguexyɨch cöbixy ma je lobɨ. Huijy cujc ajcxy mnaypɨdägɨɨb jadu'n nej tza'ñ, per yung naxy jadu'n nej muuxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mnayguend'adɨɨb ajcxy je' co yɨ jäy ajcxy xycɨ̈yegaangɨxy ma ajcxy mɨjtungmɨɨdpɨ etz myajhuobaangɨxy ma je judíojäy ajcxy ñaymujctac, ");
INSERT INTO mcoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ixtɨ xyajnɨcxaangɨxy ajcxy ma je gobernador etz je reydɨjc ajcxy mɨɨd ɨɨch ycɨxpɨ; e jɨm ɨɨch miich ajcxy xyñigapxɨpy ma je jäy ajcxy yhuinduu, e nañ jadu'n majaty anajty je jäy ajcxy huɨdibɨ ca' yjudiojäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Co anajty ajcxy xyajcɨ̈dɨgɨ̈y je mɨjtungmɨɨdpɨ, ca' ajcxy oy mhuinmaayɨpy nej m'ocnɨmähuɨpy. Co anajty paady je tiempo, huin'it ɨɨch miich ajcxy myajnɨmähuɨpy nej ajcxy mgapxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","E je ayuc huɨdibɨ miich anajty ajcxy mgapxpy, ca' miich anajty je' ajcxy m'ayuc'ájtɨgɨxy, je Dios Teedy anajty yjɨhuɨ'ñ, je Espíritu Santo, xyajcapxp miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Huin'it yɨ jäy ajcxy ñaygɨ̈yegáanɨgɨxy miñ xyipy tüg quëxtɨjc co huen yaj'ögyii. E je ungdeedy cɨ̈yega'ñ y'ung; je ung'anäg mɨbɨdɨ̈ga'ñ je ytaj yteedy etz yaj'öcɨp ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tüg'ócɨy je jäy ajcxy ca' ajcxy xy'ix'anɨpy xychoga' nɨpy mɨɨd ɨɨch nxɨɨ ycɨxpɨ. E pɨn xymɨbɨjcpɨch amumdügjot ixtɨ mabaad y'ögy, yɨ' ajcxy y'alma tzögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","E co anajty miich ajcxy jäy xy'ixhuɨdity xypahuɨdity ma tüg cajp, nɨcxcɨx ma huingbɨ cajp. Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co ca'nɨ anajty mgapxhuäcxtäy ayuc tɨy'ajt ma tüg'ócɨy je Israelcajp co nhuimbidɨpyɨch, ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tüg yaj'ixpɨjcpɨ jac nïgɨ mɨj'ajtɨn mɨɨdɨty ca'ydɨ je huɨdi ixpɨjcp, e tüg huindzɨn jac nïgɨ mɨj'ajtɨn mɨɨdɨty ca'ydɨ je' ytumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jëb jotcujc idɨpy je discípulo co jadu'n yajpaadɨpy jadu'n nej yhuindzɨn, e je tumbɨ jotcujc idɨpy nej yhuindzɨn. Pen jäy mɨnamb co ɨɨch nmɨɨdɨch ca'oybɨ, jac nïgɨ ymɨna'na'ñ co miich ajcxy mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ca' ajcxy mdzɨgɨ̈y yɨ jäy ajcxy. Ca' ji ni ti yüch ity nɨcx ycaniguëxɨ̈gy; nañ ni ti ji ycayajtuñ ayüch ameech nɨcx ycayajnejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Huɨdi ɨɨch miich ajcxy ayüch nyajnɨmaayb, capxpɨdzɨmgɨx miich yɨ' mayjäyjoty, e huɨdi ajcxy mɨdooyb ameech, capxpɨdzɨmgɨx miich yɨ' mɨc ma tüg cögop. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ca' ajcxy mdzɨgɨ̈huɨp je jäy huɨdib ninïcx yaj'öcp etz ca' huaad yɨ' ajcxy yaj'ögy je alma. Yɨ' miich ajcxy mdzɨgɨɨygɨxy je Dios huɨdib pɨdacp je alma etz je ninïcx mɨjjɨɨnjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Nej ca' jäy ajcxy toogy metz pi'cjoon mɨɨd tügpɨ pi'cmeeñɨ? Per ca' ni tüg huaad ycäy naaxhuiñ, pen ca' tzocy je mDios Teedy huɨdi jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Miich ajcxy mgöhuay ac mɨchoy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Paady miich ajcxy ca' mdzɨgɨ̈huɨpy, jac nïgɨ miich ajcxy mdzoubaady ca'ydɨ je joon. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yɨ jäy ajcxy huɨdi xymɨbɨjcpɨch etz xyñidɨy'ajtyɨch ma jäy yhuinduu, nañ jadu'n ɨɨch yɨ' nidɨy'ajtyɨch ma ɨɨch nDeedy huɨdibɨ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per je jäy ajcxy huɨdi ɨɨch xycoyützpɨch ma mayjäy ajcxy yhuinduu, nañ jadu'n yɨ' ngoyützɨp ma ɨɨch nDeedy yhuinduu huɨdibɨ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ca' miich ajcxy mhuinmay co ɨɨch ya tɨ nmiñɨch mɨɨd co nmöhuaangɨxy jotcujc'ajtɨn ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ɨɨch tɨ nmiiñɨch co nyajtziptunɨpyɨch jäy mɨɨd yteedy; töxyjäy mɨɨd ytaj etz xecy mɨɨd yxecy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","E jadu'n miich ajcxy mdzip'adɨɨyb mgɨ'mjuugy mgɨ'mmɨgüg. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yɨ jäy ajcxy huɨdibɨ tzojcp ytaj yteedy jac nïgɨ ca'ydɨ ɨɨch, ca' yɨ' ypaadyii co njäy'adɨɨybɨch; e pɨn ymang o ñɨɨx tzojcp nïgɨ ca'ydɨ ɨɨch, ca' ypadyii co njäy'adɨɨybɨch; ");
INSERT INTO mcoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","e pɨn ca' ycɨ'mdzojcɨn y'ijxmajtztäy etz ca' ñaybɨdägyii ycɨxjot huinɨjot ma ɨɨch, ca' mɨhuaadɨty nɨcx njäy'adɨɨybɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pɨn yjugy'ajtɨn najtztzogɨɨyb, yajtɨgoyɨpy yɨ'; e pɨn yjugy'ajtɨn tɨgooyb mɨɨd ɨɨch ycɨxpɨ, ypaadɨpy jugy'ajtɨn huinɨxɨɨ tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pɨn miich ajcxy xycöbɨjcp, ɨɨch yɨ' anajty xycöbɨjcp; e pɨn ɨɨch anajty xycöbɨjcp, nañ ycöbɨjcpy anajty je huɨdibɨ ɨɨch tɨ xyquejxyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Je huɨdibɨ cöbɨjcp je jäy huɨdibɨ Dios y'ayuc capxhuacxɨp, je' co yɨ' ymiñ mɨɨd Dios ycɨxpɨ, yɨ' jadu'mbɨ je oy'ajtɨn ypaadɨpy. Nañ jadu'n je huɨdi cöbɨjcp je oybɨ jäy mɨɨd co oy yjäyɨty, yɨ' jadu'mbɨ oy'ajtɨn ypaadɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Je huɨdi yaj'ucp tüg vaso nɨɨ ma huenytɨmpɨnjäy mɨɨd co xymɨbɨcyɨch, janch ɨɨch miich nɨmaaygɨxy, ypaadɨpy oy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","E co Jesús anajty tɨ najtzcapxɨydäy je tɨyy'ajt ma je nimajmetzpɨ ydiscípulos ajcxy, chi Jesús ñɨcxy yaj'ixpɨjcp etz ayuccapxhuäcxp majaty cajp huinduy agonbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E Juan je Bautista hue' je' anajty yajpaady pujxtɨgoty. E co nejhuɨy tijaty mɨjhuinma'ñ anajty Jesús ytumyb, chi quejxy metz je' ydiscípulos ajcxy ma Jesús yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Chi Juan ydiscípulos ajcxy y'amɨdooy Jesús: ―¿Nej miich je' je Cristo huɨdibɨ anajty minamb o jëbɨ ɨɨch ajcxy huingbɨ n'ahuijxcɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chi Jesús y'adzooy: ―Nɨcxcɨx miich ajcxy nɨmaaygɨx yɨ Juan, je Bautista, tijaty miich ajcxy m'ijxpy mmɨdooyb co ndumybɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Miich ajcxy yajmɨɨdmɨydäg je Juan, jadu'n nej je huintzpɨ nyajhuindɨcxɨ̈gyɨch; je cɨ̈mät tecymät nyajtzoocypɨch; je huɨdibɨ jɨbɨc nïbützpa'm ymɨɨd nyajtzoocpyɨch; je' ajcxy huɨdibɨ cönat nyajmɨdohuɨ̈cpyɨch; je öcpɨ ajcxy nyajjugypɨjcpyɨch; etz je ayoobtɨjc, je huɨdibɨ yung naxy yjothuinma'ñ nyajmɨɨdmɨydacypɨch Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jotcujc yɨ' ajcxy pɨnjaty xymɨbɨjcpɨch amumdügjot etz ca' ni nej yjotmetzcɨ' mɨɨd ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Co Juan je Bautista ydiscípulos ajcxy ñɨcxnɨ, chi Jesús ytɨgɨɨy nimɨydaccoty Juan je Bautista ytung ma je mayjäy, chi ymɨnañ: ―¿Ti miich ajcxy oy m'ixy jɨm mɨjtɨgɨ̈duum? ¿Tüg nähuaax huɨdibɨ poj xɨjpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ti ajcxy oy m'ixy? ¿Ti oy m'ixy, tüg jäy huɨdibɨ ooy y'oyxöxyɨty? ");
INSERT INTO mcoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ti miich ajcxy oy m'ixy? ¿Nej tɨ m'ixy tüg Dios y'ayucnajtzcapxɨɨybɨ? Janch co tɨ m'íjxcɨxy tüg jäy jac mɨj ca'ydɨ tüg Dios y'ayucnajtzcapxɨɨybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Je' jada je jäy huɨdibɨ Dios nigapxy ma ñecy co Dios jadu'n ymɨnañ: Cham nguexyɨch ɨɨch nguexyöyp jayɨjp ma miich. Je' yaj'oyɨ̈huɨp je jäy yjot yhuinma'ñ mɨɨd ɨɨch ycɨxpɨ, tɨm jadu'n nipaady nej jɨhuɨ̈y jäy tü'aa yaj'oyɨ̈y co rey ymiina'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Co yɨ jäy ajcxy huɨdibɨ tɨ chɨnaaygɨxy ixtɨ chambaad ni pɨn tɨ ca' yajpaady mɨj jadu'n nej Juan je Bautista; per pɨnjaty ɨɨch xymɨbɨjcp, yɨ' jac mɨj naxam ma Dios y'ane'my ca'ydɨ Juan. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Maabɨ Juan je Bautista ytundɨgɨ̈y, ixtɨ chamnɨ janch mayjäy amumdügjot ñejhuɨ̈hua'ñ Dios y'ayuc, je' co ajcxy ytɨgɨ̈hua'ñ ma Dios y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tüg'ócɨy ajcxy je Dios y'ayucnajtzcapxɨɨybɨ etz Moisés ycötujcɨn ñigapxy ajcxy je ané'mɨn ixtɨ coonɨ Juan oy ymiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pen miich ajcxy mɨbɨjcpy Moisés ycötujcɨn etz Dios y'ayucnajtzcapxɨɨybɨ ajcxy, Juan je Bautista je' je' je Elías huɨdibɨ anajty miinamb. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pɨnjaty mɨdo'n mɨɨd huen mɨdo'mbɨgɨpy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesús yjacmɨnañ: ―¿Pɨn mɨɨd n'ocyajtügɨ̈huɨbyɨch yɨ jäy huɨdi ajcxy cham tzɨnaayb? Tɨm jadu'n yɨ' ajcxy nej pi'ctɨjc huɨdibɨ ajcxy ɨyɨɨyb ma mayjäy yjuygɨxy ytooccɨxy, mɨyaaxcɨxy mɨdɨnaaygɨxy ymɨgügtɨjc: ");
INSERT INTO mcoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tɨ njayajxüxyɨch flauta e ni ca' tɨ m'ejtzcɨxy; tɨ ɨɨch ajcxy öcpɨ njahuinyäxɨch, e miich ajcxy ca' tɨ myäxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chi Juan, je Bautista, anajty miiñ, e je' ca' ycay y'ügy. E miich ajcxy mɨnaangɨxy co Juan ca'oybɨ ymɨɨdɨty. Jada pi'c'anäctɨjc nipaady nej miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chi ɨɨch je' je jäy huɨdibɨ tzoon tzajpjoty nmiiñɨch, e caaybɨch uucpɨch, e miich ajcxy mɨnaangɨxy: “Ijxcɨx, cha tüg yëydɨjc, janch cax janch vino'ucp huɨdibɨ mɨgüg'ajtpy yajcuejtpɨdɨjc etz pocyjäydɨjc.” Je Dios tɨy'ajt ji je' ñiguëxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chi Jesús ojcoty je maygajpjäy ma anajty may mɨjhuinma'ñ tɨ tuñ, com je mayjäy ca' anajty yjothuimbidaangɨxy ma Dios. Chi Jesús ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ay miich ayoob ajcxy huɨdibɨ tzɨnaayb jɨm Corazín! ¡Ay miich ayoob ajcxy huɨdibɨ tzɨnaayb jɨm Betsaida! Co ixyipy ɨɨch tɨ nduñɨch jecy'ajty je mɨjhuinma'ñ mɨjtzög'ajtɨn ma je Tiro etz Sidón cajp, jadu'n nej ɨɨch tɨ nduñɨch ma miich ajcxy, tɨ ixyipy je Tiro jäy etz Sidón jäy nijothuimbijtcɨxy etz ɨñaaygɨxy saco nïjen nïcuyjam ixcuyjam, je' je tɨy'ajt co ooy ytajcɨxy ymaygɨxy mɨɨd ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Paady miich ajcxy yam nɨmaaygɨxy. Co anajty Dios tɨyduna'ñ je naaxhuiñybɨ jäy, huin'it miich ajcxy Dios xychaachytuna'ñ jac nïgɨ, ca'ydɨ je jäy ajcxy huɨdibɨ jecy'ajty tzɨnay jɨm Tiro etz Sidón. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Miich ajcxy, Capernaum jäy, mnaybɨdáacɨgɨxy jadu'n nej jɨhuɨ̈y mdɨgɨ̈huaangɨxy jiiby tzajpjoty. Per ca' yjadu'nɨty. Mdɨgɨ̈huam miich ajcxy ayoodactuuby. Ayo'n tzaachypɨ mbadaangɨxy. Co ixyipy ɨɨch tɨ nduñɨch jecy'ajty je mɨjhuinma'ñ mɨj tzög'ajtɨn ma Sodoma cajp, jadu'n nej tɨ nduñɨch ma miich ajcxy mgajp, chambaad ixyipy ity yɨ jadu'mbɨ cajp, ca' ixyipy Dios cayajtɨgooy. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Paady ɨɨch miich yam nɨmaaygɨxy. Co anajty Dios tɨyduna'ñ je naaxhuiñyjäy, huin'it miich ajcxy myajtzaachytuna'ñ jac nïgɨ, ca'ydɨ je jäy huɨdibɨ jecy'ajty tzɨnay ma Sodoma ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chi Jesús ytɨgɨɨy Dios mɨbɨjctzooyb, ymɨnañ: ―Dios Teedy, ɨɨch miich n'ɨɨbaatpɨch ngapxpaatpɨch. Miich mɨɨd je mɨj cötujcɨn jiiby tzajpjoty etz ya naaxhuiñ. Com miich tɨ mnajtzcapxɨy yɨ m'ixpɨjcɨn ma je ayoobtɨjc huɨdibɨ tzɨnaayb jotxeemy, e tɨ myüch yɨ m'ixpɨjcɨn ma yɨ ixpɨcytɨjc cohuinma'ñydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jadu'n, Tat, tɨ mduñ, com jadu'n miich tɨ mdzocy tɨ mjäygɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús yjacmɨnañ: ―Ɨɨch nDeedy tɨ xyajcɨ̈dɨgɨydäyɨch tüg'ócɨy mɨc'ajt oy'ajt. Ni pɨn ca' ijxcapy pɨn je' y'ung, jëyɨ nDeedyɨch tügpajc. Ni pɨn ca' ijxcapy pɨn je' nDeedy'ájtpyɨch, jëyɨ ɨɨch, je Dios y'ung tügpajc, etz jacjadyii huɨdibɨ ɨɨch, je Dios y'ung, nyajniguëxɨ̈gamyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Min ma ɨɨch nidüg'ócɨy miich ajcxy huɨdijaty taj mayb myajpatp ma mjot mhuinma'ñ, ɨɨch miich ajcxy nmöhuamyb jotcujc'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cöbɨc miich ajcxy ɨɨch n'ane'mɨn ɨɨch ngötujcɨn, jadu'n nej huaj yuub ajcxy cöbɨcy ycögɨ'. Ijxpɨc ajcxy ɨɨch ndɨy'ajt etz cuydun ɨɨch n'ayuc, com ɨɨch nmɨɨdɨch mecxtujcɨn etz ca' ɨɨch amɨj agɨx nayjɨhuɨ̈yiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ca' ɨɨch n'ane'mɨn ymɨcɨty, e ɨɨch ndung ca' nimɨjaajɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chi tüg xɨɨ Jesús yhuɨdity mɨɨd ymɨgügtɨjc ma tüg camjot. E hue' anajty sábado xɨɨ, je poocxɨn xɨɨ. Chi Jesús ydiscípulos ajcxy oy anajty yubögyii. Chi ajcxy ytɨgɨɨy trigo tɨɨm nïxajtztutp etz yjɨɨcxy ajcxy je ypajc. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","E co je fariseos ajcxy ijxy nej Jesús ydiscípulos ajcxy y'ɨdɨɨtzcɨxy, chi ajcxy nɨmay Jesús: ―Oc'ix nej miich mdiscípulos ajcxy y'ɨdɨ̈ch. Hue' ajcxy tumyb huɨdibɨ ca' huaad ma sábado xɨɨ yajtuñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Per Jesús mɨnañ: ―¿Nej ca' miich ajcxy mgapxyñɨ ma Dios ñecy, jadu'n nej David etz ymɨgügtɨjc ajcxy ɨdɨ̈ch jecy'ajty co yuböccotɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pues yɨ' ajcxy tɨgɨɨy ma Dios ytɨjc. Chi cay ajcxy je tzajcaagy huɨdibɨ anajty jäy ajcxy tɨ yajhuindzɨgɨ̈y Dios. Je' je tzajcaagy huɨdibɨ teedy ajcxy anajty paatɨp cayɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Nej ca' miich ajcxy tɨ mgapxyñɨ Moisés ycötujcɨn necy co je teedy ajcxy jëbɨ ytuñ ma Dios ytɨjc sábado xɨɨ, e ca' nan tundɨgooyb je' ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ɨɨch miich ajcxy nɨmaaygɨxyp, jac nïgɨ mɨj cötújcɨn nmɨ́ɨdɨdyɨch, ca'ydɨ je cötujcɨn huɨdibɨ je teedy ajcxy yajtuñ ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pen miich ajcxy tɨ mhuinjɨhuɨ̈y nej yhuimbɨdzɨmy jada Dios y'ayuc, co Dios jadu'n ymɨnañ: “Ɨɨch ndzojcpy co miich ajcxy mɨɨd'idɨpy pa'ayo'n ca'ydɨ co ajcxy myegɨpy huindzɨgɨ'ñ.” Pen miich ajcxy tɨ mhuinjɨhuɨ̈y jada ayuc, ca' ixyipy mbocy'ixy ma ɨɨch nmɨgügtɨjc huɨdibɨ ca' ma tɨ ytundɨgooy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nmɨɨdɨch ane'mɨn, jaydëbɨ nɨmäyɨch je jäy ajcxy ti jëbɨ tungɨxy sábado xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chi Jesús choñ jɨm, ñɨcxy ma je judíojäy ñaymujctac. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","E jiiby ma je naymujctac anajty tüg yëydɨjc huɨdibɨ ycɨ̈tɨ̈tz. Je fariseo ajcxy xɨ̈huamyb Jesús, paady ajcxy y'amɨdooy, ymɨnañ: ―¿Nej jëbɨ tüg pa'mjäy chögy sábado xɨɨjɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chi Jesús y'adzooy: ―Pen ya ma miich ajcxy ji tüg jäy huɨdibɨ cöbixy yjutcögäy sábado xɨɨ, ¿nej ca' je' nɨcxy yajpɨdzɨmy mɨc'amy? ");
INSERT INTO mcoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nïgɨ tzobaatp tüg yëydɨjc ca'ydɨ tüg cöbixy, paady Moisés ycötujcɨn ca' capx'aducy co tüg oy'ajtɨn nduunɨm sábado xɨɨ, je poocxɨn xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chi Jesús nɨmay je yëydɨjc: ―Xajtɨu yɨ mgɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Co xajtɨɨy ycɨ', chi choocy, e huɨ'my quipxyjaty mɨɨd je ycɨ' oybɨ. Chi je fariseos ajcxy yjotmätcoty, yhuinma'ñ ixtaaygɨxy ajcxy nej huaad Jesús ocyaj'o'ccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E co Jesús nejhuɨɨy nej yɨ' ajcxy yhuinma'ñ mɨɨdɨty, chi jɨm choñ. E ooy mayjäy ypanɨcxɨ Jesús, Jesús yajtzoocpy anajty tüg'ócɨy pɨnjaty pa'm mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesús ane'my je pa'mjäy ajcxy co ca' huaad nigapxy nimɨydägy co yɨ' je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jadu'n Jesús ane'my je pa'mjäy jɨgɨx ycɨxɨpy ycá'pxɨpy je ayuc huɨdibɨ je profeta Isaías yjaay jecy'ajty, co Dios jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jada je' ɨɨch ndumbɨ huɨdɨ tɨ nhuin'ixyɨch. Yɨ' ɨɨch ooy ndzocyɨch njɨhuɨ̈yɨch etz ooy njotcujcɨch mɨɨd yɨ'. Ɨɨch yɨ' nmöhuamybɨch ɨɨch njɨhuɨ'ñ mɨc'ajt. Yɨ' capxhuäcxɨp ɨɨch n'ayuc jadu'n nej ndzaachytuna'ñɨch naaxhuiñyjäy ajcxy mɨɨd ajcxy ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yɨ' ni ymɨgügtɨjc ca' oja'ñ, ni ycayäxa'ñ, ni ycatɨnähua'ñ, ni pɨn ca' mɨdoohuɨpy ma cajp cujc. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ca' yɨ' tzaachytuna'ñ ayoobɨtɨjc etz huɨdibɨ ayo'ndumb ijtp. Etz nañ ni ca' yajtɨgoya'ñ huɨdibɨ ayoobɨtɨjc yco'ögy'ungdɨjc yjɨjp'ijxpy. Jadu'n nej jäy cayajhuindɨgoy tzajcapy huɨdi huiidyɨp etz ni cayajpïch je mecha huɨdibɨ uuxy uuxy tɨɨcxp. Ixtɨ mabaad anajty yajcopɨcy y'ane'mɨn tudägypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E yɨ' mayjäy ooy yjɨjp'ixa'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chi mɨɨd miiñ ajcxy ma Jesús tüg jäy huɨdibɨ huintzɨp etz uum. Je' anajty mɨɨd ca'oybɨ. Chi Jesús yajtzoogy, e chi y'ijxɨ̈gy etz ycapxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Co Jesús jadu'n tuñ, chi je mayjäy ytɨgɨɨy huinmay'ahuɨdijt, chi ajcxy ymɨnañ: ―¿Nej jada je', je David y'ap y'oc huɨdibɨ rey'adam? ");
INSERT INTO mcoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Per co je fariseos ajcxy nejhuɨy nej je jäy huinmay, chi ajcxy ymɨnañ: ―Jadaabɨ yëydɨjc yajpɨdzɨmy ca'oybɨ mɨɨd je mujcu' huindzɨn ymɨc'ajt (ca' yɨ' yjëjɨty je Cristo). ");
INSERT INTO mcoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per Jesús ñejhuɨɨyb anajty ti je fariseos ajcxy yhuinmaayb, chi ymɨnañ: ―Pen tügpɨcy tungmɨɨdpɨ ixyipy ñaybɨjc-huäcxɨgɨxy, etz ñaymɨdziptzóonɨgɨxy ixyipy ac jëyɨ, pues cɨxɨpy yɨ' ajcxy y'ane'mɨn. Pen tüg cajp o tügpɨcy jugymɨgüg ixyipy ñaybɨjc-huäcxɨgɨxy, pues ca' ajcxy y'idaangɨxy tügmucy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pen Satanás, je ca'oybɨ huindzɨn, yajpɨdzɨmy ixyipy ca'oybɨ ma je jäy ajcxy, chi cɨ'm ixyipy je ca'oybɨ tɨ ñaybɨjc-huäcxɨgɨxy, e je Satanás ymɨc'ajt ca' y'ida'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Miich ajcxy mɨnamb co ɨɨch nyajpɨdzɨmyɨch ca'oybɨ mɨɨd je ca'oybɨ huindzɨn, je Beelzebú ymɨc'ajt. Pen tɨy'ajt jadu'n nej miich ajcxy mɨna'ñ, je jäy ajcxy huɨdibɨ xymɨjnɨcxpejt miich ajcxy, ¿nej yɨ' ajcxy paady mɨc'ajt ma je mujcu' co ajcxy yajpɨdzɨmy ca'oybɨ ma je pa'm jäy? Pues ca', paady yɨ' ajcxy tɨy'ajt yejcp co miich ajcxy tɨ mgapxtɨgoy co ymɨnaangɨxy co ɨɨch nyajpɨdzɨmyɨch ca'oybɨ mɨɨd Satanás ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per ɨɨch nyajpɨdzɨmyɨch ca'oybɨ ma pa'mjäy mɨɨd Dios yjɨhuɨ'ñ ymɨc'ajt. Paady miich ajcxy nejhuɨɨyb co tɨ ymiiñ yjäty je Dios y'ane'mɨn ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","(Dios ycötujcɨn jac mɨc ca'ydɨ je ca'oybɨ ycötujcɨn, paady jëbɨ nyajpɨdzɨmyɨch ca'oybɨ.) ¿Nej jëbɨ tüg jäy ytɨgɨɨy ma tüg mɨcpɨ jäy ytɨjc etz pɨgaanɨ tijaty yɨ' ymɨɨd, pen ca' jayɨjp ycɨ' ytecy xojtzɨty? Pues ca'. Coonɨ jayɨjp ycɨ' ytecy xojtzɨty, huin'it jëb pɨjcɨp tɨjaty ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pɨnjaty ca' xymɨjnɨcxpetyɨch, xymɨdzipɨch yɨ'. Pɨnjaty ca' tuñ mɨɨd ɨɨch co jäy nyaj'ixpɨcyɨch, hue' je' ajcxy jäy yajhuinma'ñydɨgooyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Janch ɨɨch miich ajcxy nɨmäy co Dios jëbɨ huinmecxɨp tüg'ócɨy pocy huɨdibɨ jäy ytungɨxp etz tüg'ócɨy jɨbɨcpɨ huɨdibɨ jäy ycapxcɨxp. Jëyɨ janchtɨy co pɨnjaty capxtɨgooyb mɨɨd je Espíritu Santo, je Dios yjɨhuɨ'ñ ymɨc'ajt, ca' Dios huinmecxɨp nimɨna. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pɨnjaty jɨbɨc xyñigapxpɨch xyñimɨydacpɨch, je' huinmecxam. Per je huɨdibɨ jɨbɨc ñigapxpy je Espíritu Santo, je' ca' huinmecxa'ñ ni jadachambɨ tiempo, etz ni camɨna xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Pen miich ajcxy mnejhuɨ̈huamy je quipy pen oy quipy, o pen ca', jëbɨ mnejhuɨ̈huɨpy co je quipy nɨcxy ytɨɨm'aty. Pen oy je ytɨɨm, miich mɨna'nɨp co oy je quipy. E pen ca' oy ytɨɨm'aty, huin'it miich ajcxy mɨna'nɨp co ca' y'oyɨty je quipy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jɨbɨc jäy miich ajcxy, jadu'n nipaady nej jɨhuɨ̈y ahua'n ɨyujc xy'ung'ajtp. Pen miich ajcxy jɨbɨc jäy'ajtp, ¿nej jëbɨ miich ajcxy oybɨ ayuc mgapxɨpy? Jadu'n nej jäy ajcxy yjot yhuinma'ñ mɨɨdɨty, ac tɨm jadu'n ajcxy ycapxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Je jäy huɨdibɨ oy ayuc ycapxpy, ymɨɨd oyjot oyhuinma'ñ paady oy ayuc capxy. Je jäy huɨdibɨ jɨbɨc ayuc capxp, ymɨɨd jɨbɨc jot jɨbɨc huinma'ñ, paady jɨbɨc ayuc capxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ɨɨch miich ajcxy nɨmay co anajty paady je xɨɨ je tiempo mɨna Dios tɨyduna'ñ je naaxhuiñyjäy, huin'it ajcxy y'adzohuɨpy mɨɨd huen tɨm huɨdibɨ ayuc huɨdibɨ anajty ajcxy tɨ mgapxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Com nejjaty miich anajty ajcxy tɨ mgapxy je m'ayuc jadu'n miich ajcxy Dios xytɨydunɨp. Com mɨɨd yɨ mgɨ'm ayuc yɨ' mɨɨd m'oybɨdzɨmɨpy mhuätzpɨdzɨmɨpy. E nañ jadu'n mɨɨd yɨ mgɨ'm ayuc yɨ' mɨɨd mbocycähuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chi nijëjɨty fariseos ajcxy etz escribas ajcxy Jesús nɨmayɨ: ―Huindzɨn, n'ixamy ɨɨch ajcxy miich tüg m'ijxpejt. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chi Jesús y'adzooy: ―Yɨ jɨbɨc jäydɨjc ajcxy etz ajcxy huɨdibɨ ca' mɨbɨga'ñ Dios ypɨjctzooyb tüg ijxpejt huɨdibɨ tzomb tzajpjoty. Per Dios ca' yega'ñ jadüg ijxpejt. Tɨ Dios yecy tüg ijxpejt ma Jonás. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Com jadu'n nej Jonás jecy'ajty ijxpejt yejcy co y'ijty tugɨɨg xɨɨ tugɨɨg tzuum mejyjoty ma acx ymoxac, nañ tɨm jadu'n ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nyegamy ijxpejt jadachambɨ tiempo co n'idɨpyɨch tugɨɨg xɨɨm etz tugɨɨg tzuum naaxjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Je mayjäy huɨdibɨ anajty tzɨnaayb ma Nínive cajp, tɨ jothuimbijtcɨxy etz tɨ ixmach ajcxy huɨdijaty jɨbɨcpɨ ajcxy ytumyb co Jonás capxhuäcxy Dios y'ayuc ma yɨ' ajcxy. Cha ɨɨch ngapxhuäcxyɨch Dios y'ayuc ma miich ajcxy, etz jac nïgɨ cötujcɨn nmɨɨdɨdyɨch, ca'ydɨ Jonás; e ca' miich ajcxy mjothuimbity. Paady co anajty Dios tɨyduna'ñ je naaxhuiñyjäy, je Nínive jäy miich ajcxy xyajpocycähuam. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nañ jadu'n je töxyjäy reina huɨdibɨ tzɨnay jecy'ajty ma madza'cruudz ypɨdzɨmy, yɨ' je' xɨ̈dähuam je jäy ajcxy huɨdibɨ tzɨnaayb jadachambɨ tiempo, etz yajpocycähuɨɨb ajcxy. Je reina tzoon jɨguëgy nɨcxy co amɨdo'ida'ñ je rey Salomón ma capxhuäcxɨ Dios y'ayuc. Ji naaxhuiñ jadachambɨ tüg Dios ytɨy'ajtmɨɨdpɨ jac nïgɨ ymɨjɨty, ca'ydɨ Salomón anajty, e ca' je jäy ajcxy mɨjpɨdäga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Yɨ jäy ajcxy huɨdibɨ cham tzɨnaayb, quipxyjaty ajcxy mɨɨd je ca'oybɨ. Co je ca'oybɨ ypɨdzɨmy ma je jäy, chi je' ñɨcxy jɨm mɨjtɨgɨ̈duum y'ijxtacy. Co ca' paty ypocxtac, huin'it ymɨna'ñ: “Huimbidaambɨch ma je jäy yjot yhuinma'ñ ma ɨɨch tɨ n'octzombɨ.” Co je ca'oybɨ yjäty ma anajty tɨ chɨnäy, chi paty je jäy yjot yhuinma'ñ ooy yhuätzɨty etz yajxon ypedɨ̈gɨty oy oyduñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chi je ca'oybɨ ñɨcxy oy yajtzooñ jahuɨxtujc ca'oybɨ jac jɨbɨcpɨ ca'ydɨ je'. Chi ajcxy ytɨgɨɨy ma je jäy yjot yhuinma'ñ, e chɨnay ajcxy jiiby. Huin'it je jäy jac'öctɨy oy yjajtnɨ, ca'ydɨ jadu'n nej anajty jayɨjp'aty. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús yaj'ixpɨjcpy anajty je mayjäy, co oy yja'ty je' ytaj etz y'uch mɨguëx ajcxy. Hue' ajcxy yhuɨ'my tɨba'y. Je' ajcxy anajty ymɨgapxamy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chi jäy yajnɨmay Jesús: ―Yɨ mdaj etz m'uch mɨguëx ajcxy, chiiby ajcxy tɨba'y, miich xyjamɨgapxamb. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús y'adzooy, nɨmay je jäy huɨdibɨ ytaj y'ayuc yajnajxɨ ma yɨ': ―¿Pɨn jäy miich ajcxy mdijy co ɨɨch ndaj'adyii etz ɨɨch n'uch'adyii nmɨgüg'adyii? ");
INSERT INTO mcoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huin'it Jesús nitziihuɨɨy je' ydiscípulos ajcxy e ymɨnañ: ―Jada ɨɨch ndiscípulos ajcxy jadu'n nipaady nej ɨɨch ndaj etz ɨɨch n'uch nmɨguëx. ");
INSERT INTO mcoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Huen ytɨmpɨnɨty huɨdibɨ ytumyb ɨɨch nDeedy chojcɨn, huɨdibɨ jiiby tzajpjoty, pues jadu'n yɨ' ajcxy nipaady nej ɨɨch ndaj etz ɨɨch n'uch mɨguëx. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Je huin'it xɨɨ Jesús choñ ma je tɨjc. Chi ñɨcxy ma je mejypa' jɨm oy y'ɨñay'ɨhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","E co mayjäy ooy ñaymujcɨ jɨm ma anajty Jesús ɨñay, chi Jesús ytɨgɨy barcojoty. Per tüg'ócɨy je mayjäy yhuɨ'mday ma mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús ytɨgɨɨy jäy yaj'ixpɨjcp mɨɨd jɨhuimbit ayuc, ymɨnañ: ―Tüg jäy chooñ trigotɨɨm huɨjp. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E ma anajty jɨm ytɨɨmhuɨjy, huin'it je ytɨɨm oy naagɨty ycäy ma tü'aa. Chi jada' je joon ajcxy oy ymiiñ etz ypiihuɨ̈gy je tɨɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nijëjɨty ytɨɨm ycäy ma tzaanïcx ma anajty hueenɨ naax. Jada tɨɨm tzojc ymujxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Com hueenɨ anajty je naax ma je tzaanïcx, chi co oy xɨɨ'an ypadyii, chi ytɨɨtztay, com ca' anajty je ytictz yeegɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nijëjɨty tɨɨm oy ycäy ma ujtz'aayjot ma apyjot, e ujtz'öctay je trigo mang. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per je tɨɨm huɨdibɨ ca'u ma oy ñaax, je' yon yajxon e tɨɨm'ajt may'amy; tüg ypi'cpajc iipxmajc oy yco'ity, jadüg pi'cpajc tugɨ'px oy yco'ity, jadüg pi'cpajc mɨgo'px oy yco'ity. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pinjaty mɨdo'n mɨɨd huen mɨdo'mbɨcy jada ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chi je' ydiscípulos ajcxy nimɨjhua'cy Jesús, chi ajcxy yajtɨɨy: ―¿Na'amy co myajtuñ jɨhuimbit ayuc co myaj'ixpɨcy je mayjäy? ");
INSERT INTO mcoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chi Jesús y'adzooy, ymɨnañ: ―Miich ajcxy jaydëb mnejhuɨ̈huɨpy huɨdibɨ Dios ñigapxyp ñimɨydacpy coyüch'amy ma y'ane'mɨn. Jacjadyii jäy ca' ajcxy huinjɨhuɨ̈huɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pɨnjaty ymɨɨd yajmöhuɨp nïgɨ, pɨnjaty hueen mɨɨd yajpɨgɨpy nïgɨ, oy ixyipy hueen jadɨm mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Paady jɨhuimbit'amy nyajnɨmaayɨch; jaydëbɨ pɨnjaty ijxcɨxy, ñipatpy nejɨhuɨ̈y ca' tɨ ijxcɨxy; etz co ajcxy mɨdoogɨxy, ca' ajcxy huinjɨhuɨ̈y, ñipatpy nejɨhuɨ̈y ca' tɨ mɨdoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jadayaabɨ ytunyii yjadyii jadu'n nej je profeta Isaías jaaybejty yajhuɨ'my ma jadu'n ymɨnañ: Miich ajcxy mɨdohuamy, per ca' mhuinjɨhuɨ̈huangɨxy. Miich ajcxy m'ixamy, nañ ca' mhuinjɨhuɨ̈huaangɨxy huɨdibɨ tɨ m'ijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Com jadayaabɨ jäy ooy ajcxy yjot yhuinma'ñ tɨ y'ahuimbity juuñ. Nej ajcxy yjamɨdoy, ca' ajcxy ymɨdohuɨ'mgɨxy. Nej ajcxy ja'ixy, ca' y'ijxhuɨ'mgɨxy. Nej ajcxy yjahuinjɨhuɨɨygɨxy, per ca' yhuinjɨhuɨ̈y ma yjot yhuinma'ñ. Yɨ' ajcxy ca' yjothuimbidaangɨxy ma ɨɨch, jaydëb nyajnïdzögɨbɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Per jotcujc miich ajcxy, co miich ajcxy ijxhuɨ'my mɨɨd mhuiin huɨdibɨ ndumybɨch, e mmɨdo'mbɨcy ajcxy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Janch tɨy'ajt jadu'n nej ɨɨch miich nɨmaaygɨxy. Janch tɨy'ajt co may profetas ajcxy etz tudägy jäy ajcxy huɨdibɨ tzɨnaayb jecy'ajty, ooy ajcxy ja'ixañ huɨdibɨ miich ajcxy m'ijxyp cham, per ca' ajcxy ixy. E ooy ajcxy jamɨdohuañ je ayuc huɨdibɨ miich ajcxy mɨdooyb cham, per ca' ajcxy mɨdoy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Amɨdo'it miich ajcxy, jadu'n nej yhuimbɨdzɨmy jada jɨhuimbit ayuc maabɨ je tɨɨm huɨjpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Je jäy ajcxy huɨdibɨ amɨdo'ijtp Dios y'ayuc, e mɨc'amy je ca'oybɨ yajpɨdzɨmy Dios y'ayuc ma ajcxy yjot yhuinma'ñ, jadu'n ajcxy nipaady nej trigo tɨɨm huɨdibɨ cäb tügujc, e je joon ajcxy mɨc'amy ypiimujctay. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Je jäy ajcxy huɨdibɨ amɨdo'ijtp Dios y'ayuc janch jotcujc, per co agapxɨɨyb paady, co tzaachypɨ mɨnaxy yajnaxy mɨɨd Dios y'ayuc ycɨxpɨ, chi mɨc'amy ajcxy ixmajtznɨ Dios y'ayuc, jadu'n ajcxy nej je trigotɨɨm huɨdibɨ tɨ ycäy ma tzaanïcx, huɨdibɨ ca' oy ytictz mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Je jäy ajcxy huɨdibɨ amɨdo'ijtp Dios y'ayuc, e co ñɨcxnɨ, chi jäydɨgooyñɨ Dios y'ayuc mɨɨd jotcujc'ajtɨn tzɨnaayɨn, comeeñ'ajtɨn etz adzojcɨn. Jadu'n ajcxy nipaady nej trigotɨɨm huɨdibɨ tɨ ycäy ujtzjoty, e ca' ytɨɨm'aty mɨɨd co oy y'ujtz'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Je jäy ajcxy huɨdibɨ amɨdo'ijtp etz cöbɨjcp yajxon Dios y'ayuc amumdügjot etz Dios y'ayuc ytumyb ma ajcxy yjot yhuinma'ñ, jadu'n ajcxy nipaady nej je tɨɨm huɨdibɨ tɨ ycäy ma oy ñaax etz tɨ ytɨɨm'aty may'amy. Tüg pi'cpajc iipx majc oy yco'ity, etz jadüg pi'cpajc tugɨ'px oy yco'ity, etz jadüg pi'cpajc mɨgo'px oy yco'ity. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chi Jesús yaj'ixpɨjcy jadüg jɨhuimbit ayuc, ymɨnañ: ―Je Dios y'ane'mɨn jadu'n nipaady nej tüg yëydɨjc huɨdibɨ trigo tɨɨm huɨjp ma je' ycam. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per co ajcxy yma'öctay nidüg'ócɨy je cogam, chi ytɨgɨɨy tüg ymɨdzip ma je ycamjot. Chi je mɨdzip jɨbɨc ujtz tɨɨm oy huɨjy ma je trigo cam. Chi ñɨcxñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","E co je trigo oy yooñ, chi ypɨjy. Nañ jadu'n je jɨbɨc ujtz oy yooñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chi je ytumbɨdɨjc oy yhuindzɨn yajnɨmay: “Huindzɨn, ¿nej ca' tɨ mnïpy ac trigotɨɨm? ¿Nej co jɨm nañ jadu'n jɨbɨc ujtz yajpaady?” ");
INSERT INTO mcoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chi je cogam ymɨnañ: “Huen jada' nmɨdzipɨch jadu'n tɨ y'ɨdɨ̈ch.” Chi je tumbɨdɨjc y'amɨdoohuɨ: “¿Nej mdzojcpy co ɨɨch ajcxy nhuijxɨ̈gɨbɨch je jɨbɨc ujtzɨ?” ");
INSERT INTO mcoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chi je cogam ymɨnañ: “Ca'. Pen miich ajcxy mhuijxɨ̈cpy je jɨbɨc ujtz, ca' jecyɨty co m'ahuijxmugɨpy nañ jadu'n je trigo. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ixmatz, huen je jɨbɨc ujtz yeegy tügmucy mɨɨd je trigo, ixtɨ coonɨ anajty ypɨdɨ̈gy je cosecha. Co cosecha paty, huin'it nguexa'ñɨch je ndumbɨdɨjc co huen jayɨjp pujxɨ̈gy je jɨbɨc ujtz etz axotzɨpy etz nögɨpy. E co yajpɨdɨ̈ctay je jɨbɨc ujtz, chi yajpɨdɨ̈gɨpy je trigo e pɨdägɨpy ma je tze'x.” ");
INSERT INTO mcoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Nañ jadu'n Jesús yaj'ixpɨjcy jadüg jɨhuimbit ayuc, ymɨnañ: ―Je Dios y'ane'mɨn jadu'n nipaady nej tüg mostazapajc huɨdibɨ tüg jäy ñiip ma je' ycam. E je mostaza ytɨɨm je' jac tɨm mutz ca'ydɨ ni huɨdibɨ ujtz tɨɨm. Per co je mostaza ytɨɨm ymujx etz yoñ, chi y'ahuimbijty jac mɨj ca'ydɨ jacjadyii ujtz. E hue' nɨcxy yjaty janch mɨj, ixtɨ joon ajcxy oy yqueec miiñ yqueec xɨjpy jɨm, pɨdägy je ype'ñ ma je mostaza y'aacx. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nañ jadu'n Jesús yaj'ixpɨjc jadüg jɨhuimbit ayuc, ymɨnañ: ―Je Dios y'ane'mɨn jadu'n nipaady nej levadura huɨdibɨ tüg töxyjäy ypɨdacpy mɨɨd je harina, jɨgɨx je harina oy ypɨdɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tüg'ócɨy Jesús yaj'ixpɨjc je mayjäy, jɨhuimbit'amy yaj'ixpɨjc, e ni ti ca' jäy yaj'ixpɨjcy cayajnɨmäy jɨhuimbit ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jadu'n Jesús ytuuñ, jɨgɨx yajcuyduñ je ayuc huɨdibɨ je profeta Isaías yjaayhuɨ'm jecy'ajty, co jadu'n ymɨnañ: Ɨɨch ngapxamyɨch ac tɨm jɨhuimbit ayuc. Ɨɨch nigapxamybɨch tijaty huɨdibɨ ca' pɨn nejhuɨ̈y, mabaad Dios oga'n yajcojy je naaxhuiñybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chi Jesús capxycɨjxy mɨɨd je mayjäy, chi ñɨcxy ma tüg tɨjc. Chi ytɨgɨy tɨgoty mɨɨd je' ydiscípulos ajcxy. Chi Jesús ydiscípulos ajcxy nimɨjhua'cy Jesús, ymɨnañ ajcxy: ―Tun may'ajt ɨɨch ajcxy xyajhuinjɨhuɨɨyg je jɨhuimbit ayuc co tɨ mnigapxy je jɨbɨc ujtz ma je trigo cam. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chi Jesús yajnɨmay: ―Ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, jadu'n ɨɨch nipaady nej je jäy huɨdibɨ niip je oybɨ tɨɨm ma je ycam. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Je cam jadu'n nipaady nej tüg'ócɨy naaxhuiñyjäy. Je oybɨ tɨɨm jadu'n nipaady nej je jäy ajcxy huɨdibɨ cöbɨjcp Dios y'ane'mɨn. Je jɨbɨc ujtz jadu'n nipaady nej je jäy ajcxy huɨdibɨ cöbɨjcy ajcxy je mujcu' y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Je jäy huɨdibɨ niipy je jɨbɨc ujtz, jadu'n yɨ' nipaady nej je ca'oybɨ. Je jɨbɨc ujtz cosecha, jadu'n nipaady nej je tiempo co anajty je naaxhuiñ ycɨxy ytɨgoy. Je ajcxy huɨdibɨ yajpɨdɨ̈c je cosecha, nipaady nej je ángeles ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jadu'n nej je jɨbɨc ujtz oy yajpujxɨ̈gy etz yajpɨdacy jɨɨnjoty, nañ tɨm jadu'n nɨcxy yjaty mɨɨd je jäy ajcxy huɨdibɨ cöbɨjcp je mujcu' y'ane'mɨn co anajty je naaxhuiñ cɨxy ytɨgoy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Co anajty je naaxhuiñ ycɨxy ytɨgoy, chi ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nguexamyɨch n'ángeles huen yajmujctäy je jäy huɨdibɨ je ymɨgüg yajtundɨgooyb, etz yɨ huɨdibɨ ajcxy jɨbɨc-huinma'ñ tumb. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Co yajmujctähuɨpy je jɨbɨcjäydɨjc, chi ajcxy yajpɨdägɨpy mɨjjɨɨnjoty, jiiby ajcxy yäxa'ñ etz ytɨɨtzmucxy ytɨɨtzqueecy mɨɨd je ayo'n ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Per je jäy ajcxy huɨdibɨ cuydumb Dios chojcɨn, idam ajcxy mɨɨd Dios Teedy jiiby tzajpjoty. Ymɨɨ'idamy ajcxy tüg oy'ajtɨ, jadu'n nipaadɨp nej je xɨɨ ytɨɨcxɨn yjajɨn. Pen miich ajcxy mɨdo'n mɨɨd, mɨdo'mbɨjc ajcxy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Je Dios y'ane'mɨn jadu'n nipaady nej meeñ huɨdibɨ yüch ijtp ma tüg cam. Per co tüg jäy paady je meeñ, chi mɨc'amy jadüg'oc yüdz tɨgach. Chi ooy yxondägy. Chi ñɨcxy etz tooctäy tüg'ócɨy huɨdibɨ ymɨɨd etz juy je naax. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nañ jadu'n Dios y'ane'mɨn jadu'n nipaady nej tüg ajuuyb adoocpɨ huɨdibɨ ijxtaayb tüg oybɨ perla huɨdibɨ tzoobatp. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E co anajty paady tüg perla huɨdibɨ janch tzou, chi ñɨcxy tooctɨgoydäy tüg'ócɨy huɨdibɨ ymɨɨd etz juy je perla. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","E nañ jadu'n Dios y'ané'mɨn jadu'n nipaady nej tüg acxmadzɨ'ñ huɨdibɨ jäy mɨɨd ycojɨbɨɨby mejyjoty. Chi jiiby ytɨgɨy huen ytɨm huɨdibɨ acxɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","E co anajty je acxmadzɨ'ñ y'uch mɨɨd je acx, chi je jäy ajcxy yajpɨdzɨmy ma mejypa'áy. Chi ɨñay ajcxy jɨm mejypa'áy etz huin'ijxy ajcxy je oyjatypɨ acx etz pɨdaaccɨxy ma ycach. Je acx huɨdijaty ca' y'oyɨty, je' ajcxy y'ixjɨbijp. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tɨm jadu'n nej tɨ yjaty mɨɨd je acx, nañ jadu'n jada'ñ, co anajty ycɨxy ytɨgoy je naaxhuiñ. Huin'it je ángeles ajcxy ñɨcxa'ñ huindu'my naaxhuiñ huin'ixa'ñ je jɨbɨc jäydɨjc e pɨdäga'ñ ajcxy abɨcy, nañ jadu'n huin'ixa'ñ je oy jäydɨjc, e pɨdäga'ñ ajcxy nañ jadu'n abɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chi je ángeles ajcxy pɨdäga'ñ je jɨbɨcjäydɨjc mɨj jɨɨnjoty. Jiiby jɨɨnjoty ajcxy yäxa'ñ ytɨnähua'ñ etz ytɨɨtzmucxaangɨxy ytɨɨtzqueedaangɨxy mɨɨd je ayo'n mɨɨd je tzaachypɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chi Jesús y'amɨdooy ajcxy: ―¿Nej mhuinjɨhuɨɨyb miich ajcxy tüg'ócɨy huɨdibɨ ɨɨch tɨ ngapxɨch? Chi ajcxy y'adzooy: ―Huindzɨn, tɨ nhuinjɨhuɨ̈y ɨɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chi Jesús ajcxy nɨmay: ―Nidüg nidüg escriba co tɨ ixpɨcytäy tüg'ócɨy Dios ytɨy'ajt y'ane'mɨn huɨdibɨ tzajpjoty tzoon, hue' jadu'n nipaady nej tüg codɨjc comeeñybɨ huɨdijaty ymɨɨd yjajty nej yajpɨdzɨmɨpy jemybɨ etz tucpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Co Jesús yaj'ixpɨjctay jada jɨhuimbit ayuc, chi chooñ jɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Co Jesús chooñ jɨm, chi ñɨcxy ma ycɨ'mnaax ycɨ'mgajp. Chi Jesús ytɨgɨɨy ma je judio ñaymujctac, e ytɨgɨɨy yaj'ixpɨjcp. Chi je mayjäy jiiby ooy jɨhuɨy huinmay nej yɨ' yaj'ixpɨcy, ymɨnañ ajcxy: ―¿Ma jada' jada yëydɨjc tɨ paady jada ixpɨjcɨn? ¿Ma mɨc'ajt paady co ooy mɨjhuinma'ñ tzachtuñ? ");
INSERT INTO mcoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jadayaabɨ yëydɨjc hue' yteedy'ajtpy je tzejtzpɨ, etz ytaj'ajtpy María. E ɨɨch ajcxy n'ix'ajtpyɨch je y'uch ajcxy; Jacobo, José, Simón, etz Judas. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nañ jadu'n ya chɨnay ma ɨɨch ajt je' y'uch ajcxy töxyjäy. ¿Ma oy tɨ paady jada ixpɨjcɨn jada mɨc'ajtɨn? ");
INSERT INTO mcoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Paady je maycogajpɨ ajcxy ca' ytunɨcuend. Paady Jesús ajcxy nɨmay: ―Huen ma'amyɨty tüg'ócɨy je mayjäy ajcxy ooy yajmɨj'aty yɨ jäy ajcxy huɨdibɨ najtzcapxɨɨyb Dios y'ayuc, ca'ydɨ huɨdibɨ y'ayucnajtzcapxɨɨyb ma ycɨ'mnaax ycɨ'mgajp ycɨ'mjɨɨn ycɨ'mdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma ycɨ'mnaax ycɨ'mgajp Jesús ca' jaty nej mɨjhuinma'ñ tunɨp anajty, mɨɨd co je jäy ajcxy ca' mɨjpɨdägyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Je huin'it tiempo Herodes huɨdibɨ anajty ane'mb jɨm Galilea tɨy'ajt paty nej Jesús ytuñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","E yɨ' nɨmay je ymɨdungmɨɨdpɨdɨjc: ―Yɨjiibɨ jäy huɨdibɨ tzachtumb mɨjhuinma'ñ, yɨ' je' je Juan, je Bautista. Juan tɨ jugypɨcy jadüg'oc ma anajty tɨ y'ögy, paady mɨc'ajt mɨɨd jaydëb mɨjhuinma'ñ tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes tɨ anajty ni'ane'mdɨ̈y co Juan huen yajmach, e yajpɨdägɨpy pujxtɨgoty. Jadu'n Herodes tuñ mɨɨd Herodías ycɨxpɨ. Je Herodías je' anajty mɨɨd jayɨjp'aty tɨ ypɨcy Felipe, je Herodes y'ajch, chi tɨ ixmajch Felipe, chi ypɨjcy mɨɨd Herodes. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan tɨ anajty nɨmäy Herodes co tɨ ytundɨgooy co tɨ pɨcy mɨɨd Herodías. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Je rey Herodes ooy anajty jayaj'öga'ñ yɨ Juan, per tzɨgɨɨyb anajty mɨɨd je mayjäy. Com je mayjäy tɨ anajty mɨbɨcy ajcxy co Juan hue' anajty tügɨ Dios tɨy'ajt mɨɨdpɨ, tüg profeta. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Co Herodes yjɨmɨjtpejty, chi anajty ñayñixɨɨduñyii, e chi Herodías ñɨɨx ñɨcxy ejtzp ma Herodes yhuinduu. Je rey ooy jäygɨdacy nej anajty Herodías ñɨɨx y'ejch. Paady Herodes Herodías ñɨɨx nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","―Dios ɨɨch yam ngapxpatpy co nmöhuamyb ti mdɨmypɨjctzooyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chi Herodías nɨmay je' ñɨɨx co huen pɨjctzoohuɨ je Juan, je Bautista, ycohuajc ma tüg texy. Chi Herodías ñɨɨx je rey nɨmay: ―Ndzojcypɨch co miich xymöhuɨp Juan, je Bautista, ycohuajc ma tüg texy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Co jadu'n mɨdooy je rey, chi ytɨgɨɨy tajp maybɨ mɨj cajee. Per co tɨ anajty Dios capxpaatnɨ, ymɨnaanɨ mayjäy yhuinduu co ymöhuamyb tijaty ypɨjctzooyb. Paady ane'my tüg soldado co huen nɨcxy yajtzoñyii Juan ycohuajc, e möhuɨpy Herodías ñɨɨx. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huin'it je soldado oy je Juan ycohuajc yajmɨnajcɨ jiiby pujxtɨgoty. Chi moy je töxy'anäg, e je töxy'anäg yejcnajxnɨ ma ytaj. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Huin'it xɨɨ je Juan ydiscípulos ajcxy yja'ty. Chi ajcxy oy yajnaaxtɨgɨ̈y je Juan ñinïcx. Chi ajcxy oy Jesús yajnɨmäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Co Jesús nejhuɨɨy ti anajty tɨ ytuñyii tɨ yjadyii mɨɨd Juan, chi ytɨgɨɨy ma tüg barco naydüg, e nɨcxnɨ ma tüg it ma ca' pɨn chɨnäy. Co je mayjäy nejhuɨy co Jesús tɨ ñɨcxy, chi ajcxy chonday canaag agajp, nɨcxy ajcxy ma Jesús yajpaady, hue' tecygɨ'm ajcxy nɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Co Jesús ypɨdzɨmy barcojoty, chi ijxy mayjäy. Jesús ooy pa'ayoy je mayjäy, e yajtzoocy je pa'mjäy huɨdibɨ anajty ajcxy jɨm ymɨɨd miiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Com tɨ anajty chuu'ɨɨñɨ, paady je' ydiscípulos ajcxy nimɨjhua'cy Jesús, e nɨmay ajcxy: ―Tɨ chuu'ɨɨñ, e ca' ya pɨn chɨna'y, paady capxcɨ́xy mɨɨd jada mayjäy ajcxy, jaydëb ajcxy nɨcxy ixtäy ycaayɨn y'uucɨn ma yɨ mutz cajp ajcxy huingonbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chi Jesús ymɨnañ: ―Ca' ycopɨcyɨty co ajcxy nɨcxy jɨcxy ixtäy. Miich ajcxy möhuɨp caayɨn uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chi je' ajcxy ymɨnañ: ―Per ɨɨch ajcxy jëyɨ yeeby nmɨɨdɨty mɨgoox tzajcaagy etz metz acx. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chi Jesús ymɨnañ: ―Mɨmiingɨx yam'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chi Jesús nɨmay je mayjäy co huen ɨñay'ɨhuɨydaaygɨxy ma pi'cmɨɨy'ung nïcx. Huin'it Jesús je mɨgooxpɨ tzajcaagy conɨ̈gy etz je metzpɨ acx. Chi ypa't'ijxy jiiby tzajpcɨ́xy, e yajnajxy Dioscojuyipy. Chi tujc-huäcxy je tzajcaagy etz moy je' ydiscípulos ajcxy, co huen yajhuäcxycɨxy ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nidüg'ócɨy je mayjäy ajcxy ycay cüxyɨ. Co je mayjäy ycayday, chi je discípulos ajcxy yajmujcy je cayduc jɨcxtuc, e yaj'ujch ajcxy majmetz cach. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mɨgoox mil anajty ajcxy je yëydɨjctɨjc huɨdibɨ cay uuc. E ca' ajcxy mɨchoy je töxyjäydɨjc ajcxy etz je y'ung y'anäg ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chi Jesús ane'my yɨ' ydiscípulos ajcxy co huen barco tɨgɨɨygɨxy mɨc'amy, jɨgɨx ñɨcxɨpy ajcxy jɨm mejy nïnaxy. Namɨ yɨ' ydiscípulos ajcxy choñ barcojoty, Jesús ycapxycɨ́jxy mɨɨd je mayjäy huen nɨ́cxcɨxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Co anajty Jesús tɨ ycapxycɨ́xy mɨɨd je mayjäy, chi ñɨcxy naydüg ma tüg cögop Dios mɨbɨjctzoobɨ. Co ycoodzɨɨñ Jesús naydüg anajty yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Co ycoodzɨɨñ, mejy cujc anajty je barco cujc nɨcxy. E je nɨɨ ooy anajty ymɨjjëtzpety ma je barco, je' co ooy anajty mɨc yjanchpojy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","E co oy ymoñɨ̈y, huin'it Jesús ymɨjhua'cy ma je' ydiscípulos ajcxy, ñɨcxy adüyöyb mejyhuingɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E co je discípulos ajcxy ijxy co Jesús anajty ymiiñ mejyhuingɨ́xy, chi ajcxy ooy ñay'adzɨgɨɨyɨ. Ooy ajcxy yaaxqueecy ymɨnañ ajcxy: ―Hue' ɨɨch ajt ijxmanɨɨyɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chi Jesús mɨc'amy ymɨgapxy ajcxy etz nɨmay: ―Huinmɨc jotmɨc naybɨdáacɨgɨxy, ɨɨch yɨ'. Ca' mdzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chi oy Pedro Jesús ymɨgapxyii, nɨmaayɨ: ―Huindzɨn, pen janch miichɨty, ane'mgɨch co huen ɨɨch miich ninɨcxɨp adüyöyɨp mejyhuingɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chi Jesús Pedro nɨmay: ―Min. Huin'it Pedro ymɨnajcy ma je barco etz ñɨcx ma Jesús adüyöyɨp mejyhuingɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per co Pedro jɨhuɨ'ñybɨjcy jadu'n nej anajty ooy mɨc yjanchpojy, chi ooy chɨgɨy, chi oy oga'n ytɨgɨɨyñɨ quimbɨ, chi yaaxqueecy, ymɨnañ: ―¡Huindzɨn, ɨɨch yajtzóocɨgɨch! ");
INSERT INTO mcoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Huin'it Jesús oy ycɨ' mɨmajtzɨ, chi nɨmay: ―Miich, janch hueenɨ mmɨbɨjcɨn. ¿Nej co ca' yajxon xymɨbɨcyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Co Pedro etz Jesús ytɨgɨɨy barcojoty, huin'it je mɨc poj ñajxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Huin'it je' ajcxy jiiby barcojoty ycojxtɨnay'ɨhuɨydaay ma Jesús yhuinduu. Chi ymɨnañ ajcxy: ―Janch tɨy'ajt co miich Dios xy'ung'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Co ajcxy ymejyñajxtay, chi ajcxy oy ja'ty ma je Genesaret naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","E co je jäy ajcxy nejhuɨɨy co Jesús tɨ yjäty ma yɨ' ajcxy naaxjot, chi ajcxy tɨy'ajt quejxy ma tüg'ócɨy cajp etz rancho huinduy agonbɨ co Jesús yjɨmɨty. Chi je mayjäy mɨɨd miiñ tüg'ócɨy je pa'mjäy ma Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chi ajcxy cohuanɨɨy Jesús, pen jëb je pa'mjäy ñïdoñyii je yhuit. E tüg'ócɨy je huɨdijaty ñïdonɨp je' yhuit, je' ajcxy chooctay y'agɨdactay. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chi ymiiñ ma Jesús nijëjɨty fariseo jäy ajcxy, je huindzɨndɨjc huɨdibɨ tzachpadumb judío ycostumbre. Nañ jadu'n miiñ nijëjɨty escribas, je huindzɨndɨjc huɨdibɨ ajcxy nïjaydutp anajty Dios ñecy. Je fariseos etz escribas ajcxy tɨ choongɨxy anajty jɨm Jerusalén, chi ajcxy y'amɨdooy Jesús: ");
INSERT INTO mcoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Na'amy co miich mdiscípulos ajcxy ca' cuydungɨxy judío ñi'ap costumbre? Yɨ' ajcxy ycaaygɨxy y'uuccɨxy, e ca' jayɨjp ycɨ̈bujcɨxy, ca' ixpujcɨxy ixjëtzcɨxy ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chi Jesús y'adzooy, yajtɨɨy: ―¿Na'amy co miich ajcxy mgapxycömɨdodägy Dios? Mdzachcuydungɨxy mgɨ'mgostumbre ma yjapadyii mguydungɨxy ixyipy Dios ycötújcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Com Dios tɨ y'ane'my ma ycötujcɨn: “Yajmɨj'at mdaj mdeedy, e pɨnjaty jɨbɨc nigapxy ni'ojɨɨyb ytaj yteedy, ögɨpy yɨ'.” ");
INSERT INTO mcoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per miich ajcxy mɨnamb co tüg je yëydɨjc jëbɨ nɨmäy ytaj yteedy: “Ca' ɨɨch miich ajcxy nbubeda'ñ, com tɨ n'ahuanɨ̈yɨch ma Dios tüg'ócɨy tijaty nmɨɨdɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chi huen ytɨmpɨnɨty jadu'n mɨnamb, ca' ocpubedaanɨp ytaj yteedy, e jadu'n miich ajcxy myajtɨgoy Dios y'ane'mɨn com tzachtunaangɨxy mgɨ'mgostumbre. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Miich ajcxy naybɨdaacɨp jadu'n nej jɨhuɨ̈y tudägy jäy, e ca' yjanchɨty. Janch tɨy'ajt jadu'n nej jecyɨp Isaías jaaybejty yajhuɨ'my co Dios jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jadayaabɨ jäy xyajmɨj'ajtpɨch ahuac aguy, per ca' ajcxy xyajmɨj'atyɨch cɨxyjot huinɨjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Naadɨgɨ' co ajcxy xyhuin'ɨ́ɨygɨxyɨch xyhuinyáaxcɨxyɨch. Mnayyaj'ixpɨ́jcɨgɨxy ayuc tɨy'ajt huɨdibɨ jäy ajcxy tɨ cojy tɨ maacxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Huin'it Jesús huomujctay je mayjäy, ymɨnañ: ―Amɨdoo'ijtcɨxy ɨɨch n'ayuc etz mhuinjɨhuɨ́ɨygɨxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ca' ji ni ti jɨɨcxy huɨdi jäy ypɨdacpy ma y'ahuac nɨcxy yajpocycäyii. Yɨ' janchtɨy je jɨbɨc ayuc huɨdibɨ pɨdzɨm ma jäy ajcxy y'ahuac, yɨ' ajcxy yajpocycähuɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chi ymiiñ ma Jesús je' ydiscípulos ajcxy, chi ajcxy ñɨmaayɨ: ―¿Nej miich mnejhuɨɨyb co je fariseos ajcxy ñijotma'tpy co ajcxy mɨdoy je ayuc jadu'n nej miich mɨnañ? ");
INSERT INTO mcoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Chi Jesús y'adzooy, ymɨnañ: ―Huen tɨm huɨdibɨ ane'mɨn huɨdibɨ ca' Dios tɨ pɨdägy, Dios yajtɨgoyam, tɨm jadu'n nej jäy ajcxy huijxɨ̈gy ujtz huɨdibɨ ca' y'oy'ujtzɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ixmajtzcɨx yɨ fariseos etz escribas ajcxy. Ca' ajcxy huinjɨhuɨ̈y Dios ytɨy'ajt. Jadu'n ajcxy nipaady nej jäy huintzpɨ, e co tüg huintzpɨ huijtzhuɨdity jadüg huintzpɨ, chi nimetz nɨcxy yjutcögägɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Huin'it Pedro nɨmay Jesús: ―Yajhuinjɨhuɨɨyg ɨɨch ajcxy jada jɨhuimbit ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chi Jesús ymɨnañ: ―¿Nej miich ajcxy nañ jadu'n ca' mhuinjihuɨ̈y jada jɨhuimbit ayuc? ");
INSERT INTO mcoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Nej ca' miich ajcxy mnejhuɨ̈y co tüg'ócɨy huɨdibɨ tɨgɨɨyb ma miich ajcxy m'ahuac, je' nɨcxp ma miich ajcxy mjot etz ypɨdzɨmy ma ajcxy mninïcx? ");
INSERT INTO mcoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per je jäy huɨdibɨ jɨbɨc capxp, capxp je' je jɨbɨc ayuc huɨdibɨ ymɨɨd ma yjot yhuinma'ñ. Jada jɨbɨc ayuc yajpocychɨmɨ̈cp je jäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yɨ jɨbɨcpɨ huɨdibɨ tzomb ma jäy ajcxy yjot yhuinma'ñ, yɨ' je' jäyyaj'ögɨɨ huinma'ñ, je töxyjäy mɨgapxtɨgoyɨɨ huinma'ñ, meedzɨɨ huinma'ñ, je ɨndägɨɨ huinma'ñ, je piitz capx huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yɨjadu'mbɨ jɨbɨc-huinma'ñ yajpocycäb jäy ajcxy ma Dios. Per co jäy ajcxy ycaay y'ügy, ma ca'nɨ ajcxy pocy ixpujcɨxy jayɨjp, ca' je' ypocycäy ajcxy ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chi Jesús jɨm chooñ, nɨcxy ma je Tiro etz Sidón naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jɨm anajty tüg töxyjäy chɨnäy. Jada töxyjäy hue' anajty cananeajäy, canan judíojäy. Chi yɨ' nimiiñ Jesús, chi nɨmay: ―Huindzɨn, David y'ap y'oc, pa'ayoogɨch. Ɨɨch nmɨɨdɨch tüg nɨɨx huɨdibɨ ymɨɨd ca'oybɨ etz oy tzaachypɨ paady. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per ca' ni nej Jesús y'adzoohuɨ. Huin'it je' ydiscípulos ajcxy miiñ ma Jesús, e ycohuanɨɨy, mɨnañ ajcxy: ―Capxycɨ́x mɨɨd jada töxyjäy, com nɨgo xypayaax xypadɨnaayɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chi Jesús ymɨnañ: ―Dios ɨɨch tɨ xyquexyɨch jëda'ajty ma je israelitasjäy huɨdibɨ y'alma tɨgoyam. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chi je töxyjäy ymɨjhua'cɨ ma Jesús, e ycojxtɨnay'ɨhuɨy ma je yhuinduu, chi ymɨnañ: ―Huindzɨn, tun may'ajt pubejtcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chi Jesús ymɨnañ: ―Ca' jadu'n y'oyɨty co n'ixmadzipɨch je israelitasjäy (Dios yjäy), e nbubedɨpɨch miich ajcxy. Co jadu'n ndunɨpɨch, jadu'n nipaadɨp nej jäy ajcxy y'ɨdɨ̈ch co ajcxy pɨjcɨ je ajcxy y'ung ycaagy, e möy je uc. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Huin'it je töxyjäy y'adzooy: ―Janch tɨy'ajt jadu'n nej miich mɨna'ñ, per ixtɨ ycaayb je uc je tzajcaagy y'abu'x huɨdibɨ cäb ma yhuindzɨn mesa. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chi Jesús je töxyjäy nɨmay: ―Janch mɨj mmɨbɨjcɨn. Ɨɨch ndunaamybɨch jadu'n nej miich mdzocy. Huin'it horɨ je töxyjäy ñɨɨx choocy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chi Jesús jɨm chooñ. Chi ñajxy ma Galilea mejypa'. Chi ypejty ma tüg cögop, jɨm ɨñay'ɨhuɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","E huin'it oy mayjäy mɨɨdmiiñ pa'mjäy huɨdibɨ huintz, uum, cɨ̈mucy tecymucy, etz huen tɨm huɨdibɨ pa'mjäy. Pɨdacy ajcxy je pa'mjäy ma Jesús yhuinduu, e yɨ' yajtzooctay. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","E je mayjäy ooy tzachjɨhuɨɨy tzachhuinmaay ajcxy co anajty je uumbɨ tɨ capxɨ̈gy, je huintzpɨ tɨ y'ijxɨ̈gy, je cɨ̈mucpy tecymucpyɨ tɨ yöyɨ̈gy. Chi je mayjäy ytɨgɨɨy ɨɨbaady capxpaady Dios, je Dios huɨdibɨ je Israel jäy ymɨjpɨdacpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chi Jesús mɨjhuoy je' ydiscípulos ajcxy, nɨmay: ―Ooy nba'ayooyɨch jadayaab jäy ajcxy. Com cujc mɨdugɨɨg xɨɨ ijtcɨxy ya mɨɨd ɨɨch etz ca' ajcxy mɨɨdɨty ti ycaayɨpy. Ca' nguexhuimbida'ñɨch ajcxy ayuu ma ytɨjc, ca' yjetyɨty yajpa'mgojɨp ajcxy tü'am. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chi je' ydiscípulos ajcxy mɨnañ: ―¿Per ma n'ocpatɨm ti jada jäy ajcxy ycaayɨpy yjɨɨcxɨpy ya ma jada abac it ma ca' pɨn chɨnäy? Co ooy mayjäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chi Jesús yajtɨɨy: ―¿Naag jiiby tzajcaagy miich ajcxy mjacmɨɨdɨty? Chi ajcxy y'adzooy: ―Jëyɨ huɨxtujc tzajcaagy etz hueen acx. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chi Jesús nɨmay je mayjäy co huen ɨñay'ɨhuɨydaaygɨxy naaxcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chi Jesús conɨ̈gy je huɨxtujcpɨ tzajcaagy etz je hueenɨp acx, e yajnajx Dioscojuyɨp ma Dios. Chi tujc-hua'cx etz moy je' ydiscípulos ajcxy. E yɨ' ajcxy yajhua'cx je jɨcxy pɨcy ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chi je mayjäy nidüg'ócɨy ycay cüxɨ. Jesús ydiscípulos ajcxy yajpɨdɨ̈gy huɨxtujc cach cayduc uuctuc tɨɨbɨ anajty yconaxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E je huɨdibɨ ajcxy cay hue' anajty naybáatɨgɨxy nimɨdaax mil, abɨcy je töxyjäydɨjc etz pi'ctɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chi Jesús ycapxycɨ́xy mɨɨd je mayjäy huen ajcxy nɨ́cxcɨxyñɨ ma ytɨjc. Chi Jesús ytɨgɨɨy barcojoty etz ñɨcxnɨ ma Magdala naax jot. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chi je fariseos etz saduceos y'oy ajcxy ixy Jesús. Yɨ' ajcxy ijxta'n octunaangɨxy mɨɨd Jesús, paady ajcxy pɨjctzoy co Jesús huen yaj'ixyii ajcxy tüg ijxpejt huɨdibɨ tzomb tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Chi Jesús y'adzooy je' ajcxy: ―Co miich ajcxy m'ixy tzuu yɨ tzajp tzaptz, chi miich ajcxy mɨna'ñ com jabom oy tiempo yajpada'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Per co miich ajcxy m'ixy jopy je tzajp tzaptz etz huimbɨcy, chi ajcxy mɨna'ñ co ca' y'oyɨty yɨ tiempo. Miich ajcxy ooy mnaybɨdägyii nejɨhuɨ̈y ooy m'ixpɨcyɨty ma Dios ytɨy'ajt, e ca' yjanchɨty. Miich ajcxy jëbɨ yɨ tzajp myajcapxy, per ca' mnejhuɨɨygɨxy nej yhuimbɨdzɨmy yɨ mɨjhuinma'ñ ijxpejt huɨdibɨ Dios ytumyb ma jadachambɨ xɨɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yɨ jäy ajcxy huɨdibɨ cham tzɨnaayb, ooy yjɨbɨcjäyɨty ajcxy, ca' ajcxy capxymɨdoy Dios. Yɨ' ajcxy chojcpy co nyaj'ixɨpyɨch tüg ijxpejt mɨjhuinma'ñ huɨdibɨ tzomb tzajpjoty. Ca' Dios yaj'ixa'ñ ajcxy jadüg mɨjhuinma'ñ, com mɨɨd miich ajcxy jaybetyɨty je mɨjhuinma'ñ ijxpejt huɨdibɨ Dios ytuun mɨɨd Jonás jecy'ajty. Chi Jesús ixmajch je fariseos etz saduceos ajcxy, chi ñɨcxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Co Jesús etz ydiscípulos ajcxy yja'ty ma jadüg nɨɨba', chi je' ajcxy yjäydɨgoy je tzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chi Jesús ymɨnañ: ―Naygüend'ájtɨgɨx mɨɨd yɨ fariseos etz saduceos ajcxy, ca' mɨjpɨdaacɨ yɨ' ajcxy y'ayuc ytɨy'ajt, com jadu'n yɨ' nipaady nej levadura. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chi Jesús ydiscípulos ñayñɨmáayɨgɨxy miñ xyɨpy: ―Paady jadu'n ymɨnañ, je' co tɨ ɨɨch ajt je tzajcaagy njäydɨgooyɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús nejhuɨy nej ajcxy nayñɨmáayɨgɨxy miñ xyɨpy, chi nɨmay ajcxy: ―¿Na'amy co miich ajcxy mɨnaangɨxy co ca' ajcxy tzajcaagy mɨɨdɨty? Janch hueenɨ miich ajcxy mmɨbɨjcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nej ca'nɨ miich ajcxy mhuinjɨhuɨ̈yɨ? ¿Nej ca' mjäymechyii co ɨɨch mɨgoox tzajcaayg nyajhuäcxy etz ni mɨgoox mil je yëydɨjctɨjc anajty huɨdibɨ ajcxy cay? ¿E ni mga'ajɨhuɨ̈yii ajcxy naag cach cayduc uuctuc tɨ myajpɨdɨ̈gy? ");
INSERT INTO mcoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿E ni mga'ajɨhuɨ̈yii ajcxy co huɨxtujc tzajcaagy nyajhuäcxyɨch ma nimɨdaax mil yëydɨjc ajcxy huɨdibɨ caay etz naag cach cayduc uuctuc myajpɨdɨ̈gy ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nej co ca' miich ajcxy mhuinjɨhuɨ̈y, co ca' ɨɨch yam nigapxy yɨ tzajcaagy huɨdibɨ miich ajcxy tɨ mjäydɨgoy, co tɨ nyajnɨmaaygɨxy je levadura huɨdibɨ je fariseos etz saduceos ajcxy ymɨɨd? ");
INSERT INTO mcoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Huin'it Jesús ydiscípulos ajcxy huinjɨhuɨy co Jesús ca' anajty je' tɨ yajnɨmäyii ajcxy co huen naygüend'ájtɨgɨxy mɨɨd tzajcaagy levadura. Hue' janchtɨy Jesús yajnɨmay ajcxy co huen naygüend'ájtɨgɨxy mɨɨd je fariseos etz saduceos ajcxy y'ixpɨjcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Co Jesús yja'ty ma Cesarea Filipo naaxjot, chi Jesús y'amɨdooy je' ydiscípulos ajcxy: ―¿Nej jäy ajcxy ymɨna'ñ, pɨ́nɨc ɨɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chi ajcxy ymɨna'ñ: ―Nijëjɨty jäy ymɨna'ñ co miich je' Juan je Bautista. Nijëjɨty jäy ymɨna'ñ co miich je' Elías, e nijëjɨty ymɨna'ñ co miich je' Jeremías o jadüg profeta (huɨdibɨ tzɨnay jecy'ajty). ");
INSERT INTO mcoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chi Jesús ymɨnañ: ―¿E miich ajcxy nej mɨnaangɨxy, pɨn ɨɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Huin'it Simón Pedro y'adzooy: ―Miich je' je Cristo, je Dios y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chi Jesús y'adzooy: ―Jotcujc miich Simón, Jonás y'ung, je' co ni pɨn xycayajnɨmäy jada tɨy'ajt, tügpajc je Dios Teedy nDeedyɨch huɨdibɨ jiiby tzajpjoty, yɨ' tɨ xyajnejhuɨ̈y jada tɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɨɨch miich nɨmaayb co miich mxɨɨ'adɨɨyb Pedro, e hue' yhuimbɨdzɨmy tzaa (hue' je', je tzaa tija'ñ je ayuc huɨdibɨ Simón ycapxy co je Cristo hue' je' anajty Dios), e ma jada tzaa ji ngoja'ñɨch ɨɨch ndzajptɨjc (hue' yhuimbidzɨmy, ma ɨɨch n'ane'mɨn chondäga'ñ), e ni ca' oybɨ ymɨc'ajt ycamɨmadägɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ɨɨch miich nmöhuamyb je cötujcɨn jadu'n nipaady nej tüg ahuaast huɨdibɨ mɨɨd myaj'ahuädzɨpy Dios y'ayuc ytɨy'ajt. Tüg'ócɨy huɨdibɨ miich mgapx'adujcpy ya naaxhuiñ, Dios nañ jadu'n capx'adugɨpy jiiby tzajpjoty, e huɨdibɨ miich ya naaxhuiñ ca' capx'aducy, Dios nañ ca' capx'adugɨpy jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Huin'it Jesús nɨmay je' ydiscípulos ajcxy, co ca' huaad ni pɨn nɨmäy co yɨ' je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ixtɨ huin'itnɨ Jesús ytɨgɨɨy yajnɨmay je' ydiscípulos ajcxy co nɨcxamb jɨm Jerusalén etz co jɨm ooy y'ayoohua'ñ. Jɨm Jerusalén je judío mɨjjäydɨjc, je teedytɨjc huɨdibɨ tungmɨɨdpɨ, etz yɨ escribas ajcxy ooy chaachytuna'ñyii etz yaj'öga'ñyii. Per codugɨɨg xɨɨ huin'it yjugypɨga'ñ jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Huin'it Pedro mɨɨdnɨcxy Jesús ahuingujc, e oy ojy, ymɨnañ: ―Huindzɨn, ca' Dios tzocy nɨcx jadu'n mjaty. Mɨɨd miich ca' jëbɨ jadu'n mjadɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per Jesús yhuäc-huimbijty, chi nɨmay Pedro: ―Huinhuäctuutcɨch Pedro, je mujcu' miich jadu'n xyajcapxp. Ca' nɨgoo xy'adzipyɨch. Ca' miich mhuinma'ñybɨdägy nej Dios tzocy. Yɨ' janchtɨy miich mhuinma'ñ'ajtpy nej jäy ajcxy tzocy. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Huin'it Jesús je' ydiscípulos ajcxy nɨmay: ―Pen je pɨnjaty xypamina'ñɨch, huen ycɨ'mdzojcɨn ixmajtztäy etz huen yhuinma'ñypɨdägy co ayoohuɨpy mɨɨd ɨɨch ycɨxpɨ, ixtɨ mabaad y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Huen pɨnjäy huɨdibɨ ca' ayoohua'ñ mɨɨd ɨɨch ycɨxpɨ, hue' je' yajtɨgoyamy yɨ' yjugy'ajtɨn. Per pɨnjaty xypanɨcxpɨch oy nej ytɨmyjadɨpy, hue' je' ypadamyb yjugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy nimɨna. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ti jäygɨdaacɨn yɨ' co tüg jäy y'ocnayyajpadɨɨyb yɨ meeñ etz mɨc'ajtɨn huindu'my ñaaxhuiñybɨ, e yjugy'ajtɨn cɨxɨpy tɨgoyɨpy tüccɨ'y? ¿Jadu'ñyɨ jëbɨ jäy y'alma yjugy'ajtɨn occojuyɨ? Nïgɨ choohuɨty jäy ajcxy y'alma yjugy'ajtɨn, ca'ydɨ jac ni ti. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, miinaambɨch jadüg'oc ya naaxhuiñ mɨɨd je ángeles ajcxy etz mɨɨd nDeedyɨch y'oy'ajtɨn. Huin'it mɨcuejtähua'ñ tüg'ócɨy je jäy nej anajty tɨ ytuungɨxy, pen oy, o ca' y'oyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co ji ya naagɨty huɨdibɨ ca' y'öga'ñ ixtɨ coonɨ xy'ixɨpyɨch jadüg'oc co ɨɨch anajty nmiiñ ane'mbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Codudujc xɨɨ huin'it Jesús mɨɨdnɨcxy Pedro, Jacobo, etz y'uch Juan ma tüg mɨjcop, ma tüg cop huɨdibɨ ooy ycɨxɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","E jɨm copcɨ́xy Jesús ñinïcx ñaygojtɨgajtzɨ ma Pedro, Jacobo etz Juan ajcxy yhuinduu. Jesús yhuiñyjɨjp ytɨgɨɨy adɨɨcxp nej je xɨɨ ytɨɨcxɨn. E Jesús yhuit y'ahuimbijty janch poob jadu'n nej tüg tɨɨcxɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","E tɨmetiinɨ oy ijxcɨxy Moisés etz Elías ycapxy mɨydägy anajty mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chi Pedro nɨmay Jesús: ―Huindzɨn, oy y'oyɨty co ɨɨch ajt ya. Pen miich mdzojcpy jëbɨ ɨɨch ajcxy nyaj'oyɨ̈y tugɨɨg tɨjcquemy. Tüg miich mje', tüg Moisés yje', etz tüg Elías yje'. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro capxp anajty, tɨm huin'ítɨy tüg joc yajnïdɨgoyday je' ajcxy huɨdibɨ ooy adɨɨcxp anajty. E ma je joc yajmɨdoy tüg ayuc huɨdibɨ ymɨnañ: ―Jadayaabɨ yëydɨjc ɨɨch je' n'ung'ajtpy huɨdibɨ ooy ndzocy njɨhuɨ̈yɨch etz yɨ' ɨɨch mɨɨd njotcujcɨty. Amɨdoo'it miich ajcxy yɨ' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Co Pedro, Jacobo, etz Juan jadu'n mɨdooy je ayuc chooñ jocjoty, chi ajcxy ooy chɨgɨɨy etz ñayñitziitzcɨdaacɨ ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Huin'it ajcxy Jesús ñimiinɨ etz nïdoñ ajcxy, e ymɨnañ: ―Pɨdɨ̈ccɨx, ca' mdzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E co ajcxy y'ijxɨ̈gy, ca' anajty jɨm Elías etz Moisés. Naydügpajc Jesús yjac-huɨ'my mɨɨd je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","E co ajcxy ymɨnajcy ma je cop, chi ajcxy Jesús nɨmay: ―Ca' ni pɨn miich ajcxy nyajnɨmähuɨpy jadu'n nej tɨ m'ijxcɨxy cham, ixtɨ coonɨ ɨɨch anajty tɨ njugypɨcyɨch jadüg'oc ma anajty tɨ n'ögɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Huin'it je' ydiscípulos ajcxy yajtɨɨy Jesús: ―¿Nej co yɨ escribas, yɨ' ajcxy huɨdibɨ nïjaydutp etz yajnïguejp Dios y'ayuc, ymɨnaangɨxy co Elías yɨ' miinaam jayɨjp etz axam je Cristo? ");
INSERT INTO mcoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chi Jesús y'adzooy: ―Janch tɨy'ajt co Elías ymiina'ñ etz yaj'oyɨydähuamy tüg'ócɨy mɨɨd Dios ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per ɨɨch miich ajcxy nɨmaayb co Elías tɨ y'oy. E je jäy ajcxy ca' nejhuɨ̈y pɨn yɨ', e ooy jɨbɨc tuuñ ajcxy, nej tɨm tzojccɨxy. E nañ jadu'n ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty ayoohuaambɨch ma yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Huin'it je' ydiscípulos ajcxy huinjɨhuɨɨy co Jesús hue' anajty ñigapxyp je Juan, el Bautista. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Co Jesús, Pedro, Jacobo etz Juan yjäty jɨm ma je mayjäy ajcxy, chi ñimiinɨ tüg jäy. Chi je jäy ycoxtɨnay'ɨhuɨy ma Jesús yhuinduu, chi ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Huindzɨn, ɨɨch nmang pa'ayoohuɨc. Je' co ymɨɨd mo'tpa'm etz oy yaj'ɨyooyii. Canaag'oc tɨ ycäy jɨɨnjoty nɨɨjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Paady ɨɨch tɨ nmɨɨdmiiñɨch ma miich mdiscípulos ajcxy, per ca' ajcxy ymadacy yajtzögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chi Jesús y'adzooy: ―Miich ajcxy huɨdibɨ jugy'ajtp jadachambɨ xɨɨ tiempo, ca' miich ajcxy mmɨbɨga'ñ Dios, ca' miich ajcxy mgapxymɨdoohua'ñ Dios. ¿Naag xɨɨ naag tiempo ɨɨch miich ajcxy njacmɨmecxtugɨpy? Yajmiingɨx yɨ yeeg'anäg. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Co je yeeg'anäg yajmɨɨdja'ty ma Jesús, huin'it Jesús ane'my je ca'oybɨ co huen pɨdzɨm ma je yeeg'anäg. E mɨc'amy je' chögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jac co hueeñɨ, je' ydiscípulos ajcxy mɨɨdmɨydac Jesús ahuingujc, chi ajcxy yajtɨɨy ma Jesús: ―¿Nej co ɨɨch ajcxy ca' tɨ nmadägy nɨcx nyajpɨdzɨ́ɨmgɨxyɨch je ca'oybɨ ma je yeeg'anäg? ");
INSERT INTO mcoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chi Jesús ymɨnañ: ―Je' co miich ajcxy hueenɨ mmɨbɨjcɨn. Janch tɨy'ajt jadu'n nej nnɨmaaygɨxy, co ixyipy miich ajcxy xy'ocmɨbɨcyɨch, ooy ixyipy jëda'ajty jadu'n nej je jac mutzpɨ ujtz tɨɨm, huin'it jëbɨ ixyipy mnɨmäy jadayaabɨ cop co huen jɨɨhuäcy ya etz huen nɨcxy huingduum, chi ñɨcxɨp je cop. Ni ti ji ycatzipɨty pen janch miich ajcxy mɨɨdɨty mɨbɨjcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jadayaabɨ pɨcy ca'oybɨ pɨdzɨmɨpy co Dios nmɨbɨjctzoohuɨm mɨctägy etz ayuu'ijt, ca' jac ti huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Co anajty ajcxy yhuɨdity tügmucy jɨm ma Galilea y'it, chi Jesús nɨmay je' ydiscípulos ajcxy: ―Ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, yajcɨ̈yegɨpyɨch ma jäy. E yɨ' ajcxy xyaj'ögɨbɨch etz codugɨɨg xɨɨ njugypɨgɨpyɨch jadüg'oc. Co je' ydiscípulos ajcxy jadu'n mɨdooy, chi ajcxy ooy yjotmaybaty. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Co Jesús yja'ty mɨɨd je' ydiscípulos ajcxy jɨm ma je Capernaum cajp, chi huɨdi anajty ajcxy meeñ yajmujcp mɨɨd tzajptɨjc ycɨxpɨ, oy ajcxy ijxcɨxy je Pedro, chi ajcxy y'amɨdooy: ―¿Nej miich mhuindzɨn ycuejcpy meeñ mɨɨd tzajptɨjc ycɨxpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chi Pedro y'adzooy: ―Cuejtpy. E huin'it hora co anajty Pedro ytɨgɨ̈y tɨgoty, chi Jesús jayɨjp ymɨgapxy, ñɨmay: ―Simón, ¿nej mmɨna'ñ? ¿Pɨn je rey ajcxy yajcuejcpy? ¿Yɨ' yjäy o huingjäyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chi Pedro y'adzooy: ―Ma huingjäy huɨdibɨ ane'my ijtp. Chi Jesús y'adzooy: ―Ah, ca'tz yɨ' yjäy huaad ti cuejtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per ca' ndzocyɨch co je cogüejtpɨ nyajcapxmayɨɨyɨm, nɨcx miich ma yɨ mɨj laguun e cohuidzɨ' jiiby mxu'ñ, e je acx huɨdibɨ anajty jayɨjp huoomb, je' myajpɨdzɨmɨpy, e ma y'ahuac jiiby mbaadɨpy tüg meeñ, yajpɨdzɨm je meeñ e nɨcx cuet mɨɨd ɨɨch ycɨxpɨ etz mɨɨd miich ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Je huin'it hora je' ydiscípulos ajcxy ymɨjhuäctay Jesús etz yajtɨy: ―¿Pɨnjäy je'jac nïg ymɨɨd je mɨj'ajtɨn ma Dios y'ane'my jiiby tzajpjoty? ");
INSERT INTO mcoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chi Jesús mɨjhuoy tüg je pi'c'anäg. Chi pɨdacy je pi'c'anäg cujc'amy ma yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Chi Jesús ymɨnañ: ―Janch tɨy'ajt ɨɨch miich ajcxy nɨmäy, pen ca' miich ajcxy jothuimbijtcɨxy etz naybɨdaaccɨxy mhuinma'ñ jadu'n nej jada pi'c'anäg huinma'ñ mɨɨd, pues ca' mdɨgɨ̈huɨpy ma Dios Teedy y'ane'my jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Paady, pɨnjaty mɨɨd yhuinma'ñ yung nax jadu'n nej jadayaabɨ pi'c'anäg mɨɨd yhuinma'ñ yung nax, je' je' je huɨdiib jac nïgɨ mɨj'ajtɨn ymɨɨd jiiby ma Dios y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hueñypɨnɨty huɨdibɨ mɨɨd ɨɨch ycɨxpɨ cöbɨgɨpy etz tzogɨpy tüg pi'c'anäg, jadu'n nej jada pi'c'anäg tɨ ndzocyɨch tɨ ngöbɨcyɨch, hue' jadu'n nipaady nej jɨhuɨ̈y tɨ xycöbɨcyɨch tɨ xychocyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hueñypɨnɨty huɨdibɨ jɨbɨc-huinma'ñ ymɨbɨdzɨmy, e yajpocycäy yɨ jadu'mbɨ pi'ctɨjc huɨdibɨ ajcxy xymɨjnɨcxpejtpɨch, jac'oy ixyipy co yɨ jadu'mbɨ jäy ytimyñayyöcxodzɨ̈yii tüg paandzaa etz ñayñajtzjɨbibɨ̈huɨpy mejyjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ooy ayo'ñɨty ooy jɨbɨcɨty co ji naaxhuiñybɨ yajpaady tijaty huɨdibɨ yajtundɨgooby jäy ajcxy. Ni mɨna xɨɨ ca' tɨgoy y'idɨpy tijaty huɨdi yajtundɨgoy je jäy ajcxy. Per mɨj ayo'n pada'ñ mɨɨd yɨ Dios pɨnjaty cojp tundɨgooyɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pen miich mgɨ' o miich mdecy xyajtundɨgooyb, jac'oy ixyipy co mdɨm'ixpuxy etz ixjɨbɨpy jɨguem. Nïgɨ oy co mdɨgɨ̈huɨpy cɨ̈duc tecytuc jiiby tzajpjoty etz ca'ydɨ co mdɨgɨ̈huɨpy mɨɨd metz mgɨ' etz metz mdecy mɨjjɨɨnjoty huɨdibɨ nimɨna ycapïch. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","E pen yɨ mhuiin tug xyajpocycähuamb, tɨm yajpɨdzɨm etz ixcätz jɨguem. Com jac'oy mdɨgɨ̈huɨpy mɨɨd tüg mhuiin ma jugy'ájtɨn huinɨxɨɨbɨ, ca'ydɨ co mdɨgɨ̈huɨpy mɨɨd metz mhuiin ma yɨ jɨɨn huɨdibɨ camɨna xɨɨ ycapïch. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ca' m'ixtijcɨxy ni tüg pi'c'anäg huɨdibɨ xymɨbɨjcpɨch. Yɨ' ajcxy je' y'ángeles tɨm ijtɨɨb jiiby tzajpjoty ma Dios Teedy, ɨɨch nDeedy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ɨɨch je jäy huɨdibɨ tzoon tzajpjoty, tɨ nmiiñɨch ya naaxhuiñ, je' co nyajnitzöga'ñɨch je jäy ajcxy y'alma huɨdibɨ tɨgoyam. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Nej miich ajcxy mɨna'ñ? Pen tüg jäy ymɨɨd mɨgo'px cöbixy, etz pen yöydɨgooyb nidügtɨ cöbixy, ¿nej ca' jëbɨ ixmach je nimɨda'px majmocx mɨdaax cöbixy etz nɨcxy ixtäy je jadügpɨ huɨdibɨ yöydɨgooy? ");
INSERT INTO mcoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E pen ypatpy je tügpɨ huɨdibɨ yöydɨgooyb, chi ooy xondägy mɨɨd co anajty tɨ paady huɨdibɨ anajty tɨ ytɨgooy, ca' jadu'n yxondägy mɨɨd je nimɨda'px majmocx mɨdaax huɨdibɨ ca' anajty tɨ yöytɨgooygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tɨm jadu'n nipaady mɨɨd Dios Teedy jiiby tzajpjoty, ca' tzocy co ni tüg jäy y'alma tɨgoyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Pen miich mmɨgüg xytuñ jɨbɨc, mɨɨdmɨydac ahuingujc e yajhuinjɨhuɨ' ma tɨ ytundɨgooy, pen xy'ayuchuinjɨhuɨɨyb tɨ anajty mmɨnaymɨgügpɨgyii je mmɨgüg. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pen ca' xy'ayuc-huinjɨhuɨ̈y, chi huoominɨpy tüg o metz mmɨgüg huɨdibɨ jëbɨ nidɨy'ajt'adɨpy miich m'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","E pen nañ ca' je' ajcxy ayuc-huinjɨhuɨ̈hua'ñ, mɨɨdnɨcxɨp ma mɨbɨjcpɨdɨjc yöymujctac e jɨm ajcxy myajnaxɨpy jadu'n nej tüg huɨdibɨ ca' Dios mɨbɨcy etz jadu'n nej tüg yajcogüejtpɨ huɨdibɨ ooy pocymɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Janch tɨy'ajt ɨɨch miich ajcxy nɨmäy, tüg'ócɨy huɨdibɨ miich ajcxy mgapx'adujcpy ya naaxhuiñ, Dios nañ jadu'n capx'adugɨpy jiiby tzajpjoty, e huɨdibɨ miich ajcxy ya naaxhuiñ ca' capx'aducy, Dios nañ ca' capx'adugɨpy jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","E nañ jadu'n ɨɨch miich ajcxy nɨmäy, pen ya naaxhuiñ miich ajcxy nimetz mnaygápxɨgɨxy co tijaty mmɨbɨjctzohuaangɨxy ma Dios, Dios, ɨɨch nDeedy huɨdibɨ jiiby tzajpjoty, xymöhuɨpy huɨdibɨ ajcxy mbɨjctzooyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Com ma miich ajcxy nimetz o nidugɨɨg naymújcɨgɨxy, jɨm ɨɨch n'ity cujc'amy ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chi Pedro y'amɨdooy Jesús ymɨnañ: ―Huindzɨn, ¿naag'oc huaad nhuinmeecxyɨch yɨ' ajcxy huɨdibɨ xymɨdundɨgooybɨch? ¿Nej nméecxɨbɨch ixtɨ coonɨ huɨxtujc'ocɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chi Jesús y'adzooy: ―Ca' yhuɨxtujc'ócɨty, hue' meecxɨpy mɨdaax mɨgo'px jamɨda'px majmocx mɨdaax'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dios y'ane'mɨn jiiby tzajpjoty jadu'n nipaady nej tüg rey huɨdibɨ huijtz'oyɨɨyb mɨɨd je ytumbɨdɨjc jajadu'ñɨ ajcxy yjacmɨnucxy'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Je rey ytɨmyhuijtz'oyɨɨychondacyñɨ anajty cuentas, co oy yjädy tüg ytumbɨ huɨdibɨ anajty mɨnuucxy'ajtɨp canaag millón. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Com je' ytumbɨ ca' anajty mɨɨdɨty ti mɨɨd mɨgüedɨɨb je' yhuindzɨn. Huin'it je huindzɨn ane'my co huen je' ytumbɨ yajtoocnax quipxyɨ mɨɨd y'ungdöxyɨjc etz tüg'ócɨy tijaty ymɨɨd, jaydëb ñuucxy y'adujctähuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Huin'it ytumbɨ ycoxtɨnay'ɨhuɨɨy ma yhuindzɨn yhuinduu etz nɨmay: “Huindzɨn, pa'ayoogɨch, etz ɨɨch miich nmɨgüejtähuɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chi je tumbɨ yhuindzɨn yajtuñ pa'ayo'n, chi huinmeecxɨp je nuucxy, e yajpɨdzɨmy pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","E mɨc'amy co je' ypɨdzɨmy pujxtɨgoty, chi ymɨnaybatɨ tüg ymɨgüg huɨdibɨ anajty mɨɨd quipxyɨ tɨ ytuñ. Je' anajty mɨnuucx'ajtɨp tɨm hueenɨ, chi je' yöcmɨmadzɨy je' ymɨgüg huɨdibɨ mɨɨd ytuuñ, chi nɨmay: “Cuet huɨdibɨ mnuucx'ajtpy ma ɨɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Huin'it ymɨgüg ycojxtɨnay'ɨhuɨɨy ma je' yhuinduu. Chi mɨnuucxtaacy nɨmay: “Pa'ayoogɨch. Ɨɨch miich nmɨgüejtähuɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Chi je jadügpɨ ca' mecxtujcɨn yajtuuñ. Chi oy ymɨgüg pɨdägy pujxtɨgoty, ixtɨ coonɨ anajty mɨcuedyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Co je jacjadyii ymɨdumbɨdɨjc oy ixy jadu'n nej tɨ yajtuñ je' ymɨgüg, chi ooy ajcxy jɨhuɨɨy. Chi ajcxy nɨcx ma je yhuindzɨn etz yajnɨmayday tüg'ócɨy nejjaty anajty tɨ ijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Huin'it je' ajcxy yhuindzɨn oy yajhuoyii je huɨdibɨ mɨnuucx'ajtɨp canaag millón. Chi nɨmay: “Miich ooy mdzachjɨbɨcjäyɨty. Tɨ ɨɨch miich nhuinmeecxɨ tüg'ócɨy je mnuucxy, mɨɨd co miich pa'ayoohuɨn mbɨjctzooy ma ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","E miich nañ jadu'n ixyipy tɨ mba'ayoy je mɨgüg huɨdibɨ mɨɨd mmɨduñ, huɨdibɨ xymɨnuucxy'ajtp, jadu'n nej ɨɨch miich tɨ nba'ayooy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chi je huindzɨn ooy chachjotma'ty, chi pɨdacy ane'mɨn co huen yajtzaachytuñ je' ytumbɨ mabaad cuejttäy tüg'ócɨy huɨdibɨ ñuucxy'ajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chi Jesús ycapxycɨ́jxnɨ, mɨnañ: ―Tɨm jadu'n nej jada rey tɨ tuñ mɨɨd je ytumbɨ, nañ tɨm jadu'n Dios tunɨpy mɨɨd miich ajcxy, pen ca' nidüg nidügtɨ miich ajcxy ca' mhuinmeecxy je mmɨgügtɨjc amumdügjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","E co Jesús capxtay jada ayuc, chi choñ Galilea, chi oy yjädy ma Judea it jɨm Jordán mɨj nɨɨ nïnaxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chi ooy mayjäy ypanɨcxɨ, e jɨm yajtzoocy huɨdijaty anajty yuu mɨɨd pa'm mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Huin'it nijëjɨty je fariseos ajcxy nimiiñ Jesús co yajmachcähuaangɨxy anajty. Chi ajcxy y'amɨdooy: ―¿Nej janch co Dios tɨ xymooyɨm cötujcɨn co jëbɨ tüg yëydɨjc ixmadzip ytöxyɨjc mɨɨd tɨm hueenɨ ti capxy ti ayuc? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chi Jesús y'adzooy: ―¿Nej ca'nɨ miich ajcxy m'ixy mgapxy ma ymiiñ jaybety ma Dios ñecy co je naaxhuiñybɨ chondacy, co Dios oga'ñ yajcojy tüg'ócɨy tijaty huɨdibɨ ji'ajtp co “Dios yajcojy tüg yëydɨjc etz tüg töxyjäy”? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nañ jadu'n Dios ymɨnañ: “Je yëydɨjc y'ixmadzip ytaj yteedy etz pudɨgɨ̈huɨpy je' ytöxyɨjc. E je yëydɨjc etz ytöxyɨjc tú'cɨy idaangɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Paady ca' ñimetzɨty ajcxy, com je yëydɨjc etz ytöxyɨjc tügmucy y'idaangɨxy. Com Dios tɨ huijtzmucy je yëydɨjc mɨɨd je töxyjäy, paady ca' huaadɨty co jäy ajcxy huijtzhuäcxyp tɨɨbɨ Dios huijtzmucy. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Huin'it je fariseos ajcxy y'amɨdooy Jesús: ―¿Na'amy co Moisés cötujcɨn tɨ yejcy jecy'ajty co tüg yëydɨjc jëbɨ huaad ixmach ytöxyɨjc, e möhuɨpy ñinecy ñidɨy'ajt e jadu'n jëbɨ ixmach? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chi Jesús ymɨnañ: ―Moisés jada cötujcɨn tɨ xymooygɨxy co jëbɨ m'ixmajtzcɨxy mdöxyɨjc mɨɨd co miich ajcxy mdzachcöjuuñɨty, ca' mgapxymɨdohuaangɨxy Dios. Per co je naaxhuiñybɨ chondacy ca' anajty jadu'nɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Janch tɨy'ajt jadu'n nej ɨɨch miich ajcxy nɨmaaygɨxy co je yëydɨjc huɨdibɨ yajjayhuäcxp mɨɨd je ytöxyjäy, e je ytöxyjäy ca' anajty tɨ ytundɨgooyb mɨɨd huingbɨ yëydɨjc, hue' je' yëydɨjc ytundɨgooy co ixmach ytöxyɨjc etz ypɨjctɨgach mɨɨd huingbɨ. Nañ tɨm jadu'n pen tüg yëydɨjc ypɨcy mɨɨd tüg töxyjäy huɨdibɨ ñäy tɨ y'ixmachyii, hue' tundɨgooyb anajty je yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Co Jesús ydiscípulos ajcxy mɨdooy jada ayuc, chi ajcxy ymɨnañ: ―Pen jadu'n jëdu'n je tɨy'ajt co je yëydɨjc ca' huaad ixmadzip ytoxyjäy, jac'oy co ca' nbɨjcɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chi Jesús ymɨnañ: ―Ca' tüg'ócɨy je jäy huinjɨhuɨ̈y jadayaabɨ tɨy'ajt. Jëyɨ ajcxy huinjɨhuɨ̈huɨp pɨn ajcxy Dios pɨdaacɨ co huinjɨhuɨ̈huɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ji canaagnax je ayuc je huinma'ñ nej ca' yjëbɨty ypɨgɨpy je yëydɨjc. Naagɨty pi'ctɨjc yma'xung'aty e ca' yca'pxɨty ñinïcxy, paady ca' pɨcy ajcxy. E nijëjɨty je yëydɨjc ca' huaad ypɨcy, mɨɨd jëgɨxpɨ co anajty je' tɨ ymɨjaapɨgyii. E nijëjɨty yëydɨjc huɨ'my jaybɨcy mɨɨd jëgɨxp co ajcxy ytuñ ma Dios ytung, je Dios huɨdibɨ ane'myb tzajpjoty. Pɨnjaty cöbɨgamy ɨɨch n'ayuc huen cöbɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chi naagɨty je jäy mɨɨdnɨcxy y'ung y'anäg ma Jesús jaydëb yajcɨ̈nïxajɨpy etz Dios mɨbɨjctzoy mɨɨd yɨ' ajcxy ycɨxpɨ. Chi Jesús ydiscípulos ajcxy ojy je jäy ajcxy huɨdibɨ anajty mɨɨd miimb je y'ung y'anäg, nɨmaaygɨxy co ca' jadu'n y'oyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Per Jesús ymɨnañ: ―Huen mɨɨd miiñ ajcxy pi'c'anäg ma ɨɨch, ca' mjɨjpcogapxɨɨygɨxy. Com pɨnjaty ymɨbɨjcp ɨɨch ngapxy n'ayuc, jadu'n nej jadayaabɨ pi'c'anäg ajcxy ymɨbɨcy, je' ajcxy tɨgɨ̈huam ma Dios y'ane'my jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chi Jesús cɨ̈nïxajy je pi'c'anäg ajcxy. Chi ñɨcxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chi tüg yëydɨjc oy ixy Jesús. Chi y'amɨdooy: ―Huindzɨn, ¿ti jada' co oy ɨɨch ndunɨpyɨch jaydëb nbaadɨbɨch jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chi Jesús y'adzooy: ―¿Na'amy co xyñɨmäyɨch co oy huindzɨn ɨɨch? Dios tügpajc oyɨp, ca' jac pɨn. Pen miich mdzojcpy co mbada'ñ jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy nimɨna mguydunɨpy je Dios ycötujcɨn huɨdibɨ Moisés ycojaay jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chi je yeeg'anäg yajtɨɨhuimbijty: ―¿Huɨdibɨ cötujcɨn miich mdijp? Chi Jesús ymɨnañ: ―Ca' mɨgüg myaj'ögɨpy. Ca' mɨgüg ytöxyɨjc mɨgapxtɨgooyɨpy. Ca' mmeedzɨp. Ca' mmɨgüg mhuin'ɨɨnɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yajmɨj'at mdaj mdeedy. Mdzogɨpy mjɨhuɨ̈huɨp miich mmɨgügtɨjc, tɨm jadu'n nej miich cɨ'm mnaychogyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chi je yeeg'anäg Jesús nɨmaayɨ: ―Tɨ nguydundäyɨch jadayaabɨ cötujcɨn ajcxy maabɨ ɨɨch nbi'c'atyɨch. ¿Ti jada njacyajtɨgoy'ijtpyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chi Jesús jadüg'oc y'adzooy: ―Pen miich m'idam tudägy, nɨcx tooctɨgoyda' huɨdijaty miich mɨɨd, etz mo' je meeñ je jäy ajcxy huɨdijaty ayoob. Co jadu'n mdunɨpy, chi mbaadɨpy oy'ajtɨn jiiby tzajpjoty. Co jadu'n mdooctähuɨpy tijaty miich mɨɨd, chi miinɨp jadüg'oc ma ɨɨch nyajpaadyɨch, e pajamgɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Co je yeeg'anäg jadu'n mɨdooy, chi ñɨcxnɨ taj may com ooy anajty chachcomeeñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Huin'it Jesús nɨmay je' ydiscípulos ajcxy: ―Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co ooy ymɨjhuinma'ñɨty co tüg comeeñyjäy ytɨgɨ̈huɨpy ma Dios y'ane'my jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jadüg'oc nmɨna'ñɨch co ooy chipɨty co tüg comeeñyjäy tɨgɨ̈huɨpy ma Dios y'ane'my, nïgɨ ca' chipɨty co tüg camello ñaxɨpy ma tüg xu'ñ'ɨjx yxutɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Co Jesús ydiscípulos ajcxy jadu'n mɨdoy, chi ajcxy ooy jɨhuɨy huinmay. Chi ajcxy ñay'amɨdoohuɨ miñ xyɨpy: ―¿Pɨn jëbɨ paady je' y'alma nïdzoocɨn? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chi Jesús ajcxy huindɨcxpejty etz nɨmay: ―Je huɨdibɨ jäy ajcxy chipjɨhuɨɨyb, mɨɨd Dios ca' ni ti chipɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Huin'it Pedro ymɨna'ñ: ―Huindzɨn, ɨɨch ajcxy tɨ n'ixmajtztäyɨch tüg'ócɨy huɨdijaty anajty ɨɨch ajcxy nmɨɨd etz nbanɨcx ɨɨch ajcxy miich. ¿E ti jada' ɨɨch ajcxy nbaadaamybɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Chi Jesús y'adzooy: ―Janch tɨy'ajt nmɨna'ñɨch co anajty je xɨɨ je tiempo paady mɨna Dios yajtɨgajtztähuɨpy je tzajp etz naaxhuiñybɨ, co anajty ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, n'ityɨch ma ngötujctacɨch oybɨ jiiby tzajpjoty, chi miich ajcxy huɨdi tɨ xypahuɨdityɨch, miich ajcxy mbadamy majmetz cötujctac, e miich ajcxy mdɨydunɨpy je majmetz pɨcypɨ Israeljäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","E tüg'ócɨy jäy ajcxy huɨdibɨ tɨ ixmajtztäy yjɨɨn ytɨjc, y'uch ymɨgüg, y'ung ytöxyɨjc, y'ung y'anäg, ytaj yteedy, o ycam ytu' mɨɨd ɨɨch ycɨxpɨ, yɨ' ajcxy ypadamyb mɨgo'px'oc, ca'ydɨ huɨdibɨ tɨ ixmach. E ypadamy je jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy ni mɨna. ");
INSERT INTO mcoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mayjäy ajcxy huɨdibɨ cham ymɨɨd mɨj'ajtɨn cötujcɨn, tzajpjoty ca' ajcxy mɨɨd'ada'ñ mɨj'ajtɨn cötujcɨn. E mayjäy huɨdibɨ cham ca' mɨɨdɨty ajcxy mɨj'ajtɨn cötujcɨn, tzajpjoty ymɨɨd'adamy ajcxy mɨj'ajtɨn cötujcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jadu'n Jesús ymɨnañ: ―Je Dios y'ane'mɨn jiiby tzajpjoty jadu'n nipaady nej tüg cogambɨ huɨdibɨ ooy mɨj cam mɨɨdɨty. Chi je cogam jopyñɨ choñ ma oy nɨcxy ixtäy tumbɨdɨjc ajcxy huɨdibɨ yajpɨdɨ̈gɨpy yɨ uva cosecha. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chi ycapxytuñ mɨɨd nidüg nidüg ytumbɨ co mujuya'ñ tüg denario meeñ tüg xɨɨbɨ. Chi quejxy nidüg nidüg ytumbɨ ma je uva cam. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chi petyxɨɨ je cogam ñɨcxy jadüg'oc tumbɨ ixtaayb. Chi paty cajp cujc nijëjɨty tumbɨ huɨdibɨ ca' ti tung mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Chi je cogam je tumbɨ ajcxy nɨmay: “Nɨcx miich ajcxy tuñ ma ɨɨch ngosecha. Cham nmujuyɨpy jadu'n nej ytɨy'ajtɨty.” Chi ñɨcxy ajcxy mɨdumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chi je cogam ñɨcxy jadüg'oc cujcxɨɨ tumbɨ ijxtaayb. Nañ jadu'n nɨcxy jadüg'oc mɨnacyxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nañ tɨm jadu'n tzuu jadüg'oc je cogam ñɨcxy tumbɨ ijxtaayb, chi paty nijëjɨty cajpcujc huɨdibɨ ca' ti tung mɨɨdɨty ajcxy, chi ajcxy nɨmay: “¿Na'amy co miich ajcxy myaajɨty? ¿Nej co ca' mnɨcxy mdungɨxy?” ");
INSERT INTO mcoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chi je' ajcxy y'adzooy: “Je' co ca' ɨɨch ajcxy pɨn tɨ xycapxytuñ.” Chi je cogam ajcxy nɨmay: “Nɨcx miich ajcxy tun ma ɨɨch nnaaxjot. Cham ɨya nmujuyɨpy jadu'n nej ypaadyii.” ");
INSERT INTO mcoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Co oy ycodzɨɨyñɨ, chi je huindzɨn nɨmay je huɨdibɨ nigop'ajtp je tung: “Nɨcx mɨjhuoodäy je tumbɨdɨjc etz mujuyɨpy. Mujuy jayɨjp huɨdibɨ tɨ ymiiñ axam tumbɨ etz jɨm nɨcxy myajcogɨxɨ̈y ma huɨdibɨ anajty tɨ miiñ jayɨjp tumbɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chi ajcxy jayɨjp yajmujuy je tumbɨ ajcxy huɨdibɨ anajty tɨ ytɨgɨɨy tumbɨ axam. Chi yajmujuy ajcxy jadu'n nej anajty jäy ñaymujuyii je tüg xɨɨbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Co miiñ je tumbɨ ajcxy je huɨdibɨ ajcxy jayɨjp tɨgɨɨy tumb. Chi ajcxy jot'ajtɨ co jac'anaxy yajmujuya'ñ. Per quipxyjaty ajcxy paty tüg meeñ nidüg'ócɨy je tumbɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","E co ajcxy quipxyjaty yajmujuy, chi ajcxy ytɨgɨɨy jotma'tpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chi ajcxy nɨmay je cam huindzɨn: “¿Na'amy co quipxyjaty ɨɨch ajcxy tɨ xymujuyɨch mɨɨd je huɨdibɨ tɨ miiñ axam tumbɨ? Yɨ' ajcxy tüg jaxɨ̈gy tɨ ytuñ, e ɨɨch ajcxy tüg xɨɨ je anbɨ tɨ ngöbɨcyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chi je cam huindzɨn y'adzooy, nɨmay nidügtɨ je' ajcxy: “Miich, ɨɨch nmɨgüg, ca' ɨɨch jɨbɨc tɨ nduñɨch mɨɨd miich. ¿Nej ca' ɨɨch ajt ngapxytuunɨm co jadu'n nmujuya'ñ tüg denario meeñɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Con yɨ mmeeñ, e nɨcxnɨ. Jadu'n ndzocyɨch co quipxyjaty nmujuya'ñɨch miich mɨɨd huɨdibɨ tɨ ymiñ axam ma je tung. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Nej ca' huaad ɨɨch nduñɨch mɨɨd ɨɨch nmeeñ nej ndzócyɨchɨ? ¿O co xyajca'oy'ixyɨch, co ɨɨch ooy n'oyjäyɨty?” ");
INSERT INTO mcoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","E huɨdibɨ ajcxy jaccogɨxɨɨyb, yɨ' ajcxy jayɨjp'adam. E huɨdibɨ ajcxy jayɨjp'ajtp cham, yɨ' ajcxy yjaccogɨxɨ̈huamb. May ooy yjayajhuoomiñ e hueenɨ huidɨ huin'íjxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","E co Jesús anajty ñɨcxy ma Jerusalén tü'aa, chi mɨɨd nɨcxy ahuingujc je nimajmetzpɨ ydiscípulos. Chi ajcxy nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jadu'n nej miich ajcxy m'ijxy mnejhuɨ̈y cham ɨɨch ajt nba'ttɨgɨɨyɨm jɨm Jerusalén. Jɨm Jerusalén ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, xyajcɨ̈yegaamɨch je teedy mɨjtungmɨɨdpɨ etz escribas ajcxy. Nyajtɨyduna'ñɨch etz pɨdäga'ñ ajcxy ané'mɨn co n'ögɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","E yɨ' ajcxy xycɨ̈yega'ñɨch ma je huɨdibɨ ca' yjudiojäyɨty, jɨgɨx xyñixïgɨbɨch xyajxïgɨbɨch, xycoxɨpɨch, etz xyajcruutzpedɨpɨch ajcxy. E co n'ögɨbɨch, chi njugypɨgɨpyɨch codugɨɨg xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chi je Zebedeo ytöxyɨjc nimiiñ Jesús mɨɨd metz je ymang; Jacobo etz Juan. Huin'it je ungdaj huingojxtɨnay'ɨhuɨɨy Jesús, pɨjctzoy may'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chi yajtɨɨy Jesús: ―¿Ti mdzojcpy? Chi je ungdaj y'adzooy: ―Tun may'ajt möhuɨpy ɨɨch metzpɨ yɨ nmang yɨ jacmɨjtung ma miich m'ane'mɨn, jaydëb ɨñähuɨpy ma miich mmɨjc, tüg a'oy'amy etz jadüg anajty'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chi Jesús y'adzooy: ―Miich ajcxy ca' mhuinjɨhuɨ̈y ti ajcxy mbɨjctzooyb. ¿Nej mmɨnaxa'ñ myajnaxa'ñ miich ajcxy je tzaachypɨ huɨdibɨ ɨɨch nmɨnaxamy nyajnaxamyɨch? Jadu'n nej jɨhuɨ̈y m'üga'ñ ajcxy je ta'm nɨɨ huɨdibɨ ɨɨch n'ügamy e mbaada'ñ je nɨɨbejtɨn huɨdibɨ ɨɨch nbadamyb. Chi je' ajcxy y'adzooy: ―Jëbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chi Jesús ymɨna'ñ: ―Janch tɨy'ajt nej miich ajcxy mɨna'ñ co mmɨnájxcɨxɨpy myajnájxcɨxɨpy je tzaachypɨ huɨdibɨ nnaxa'ñɨch. Per ca' ɨɨch cötujcɨn nmɨɨdɨdyɨch co ɨɨch miich ajcxy nbɨdägɨpy mɨjtungmɨɨd, co myajpaadɨp tüg ma ɨɨch nmɨjc a'oy'amy e jadüg anajty'amy. Hue' janchtɨy Dios Teedy ymɨɨd ni'ixɨ' pɨnjaty tɨ huin'ixy jaydëb yajnɨcxɨp je mɨjtung ma ɨɨch n'ane'mdac. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Co je nimajcpɨ ydiscípulos ajcxy nejhuɨɨy jadu'n nej Jacobo etz Juan pɨjctzooy may'ajt ma Jesús, chi ajcxy ooy mɨjotma'ty Jacobo etz Juan. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Huin'it Jesús mɨjcapxy je' ydiscípulos ajcxy, chi nɨmay jadu'n: ―Miich ajcxy mnejhuɨy co yɨ jäy ajcxy huɨdibɨ mɨjtungmɨɨdpɨ ma je maybɨ naax cajp, mɨc ajcxy ane'my je naax cajp. Nañ jadu'n yɨ' ajcxy huɨdibɨ mɨc'ajt mɨɨd ma je maybɨ naax cajp, mɨc ajcxy ane'my je jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per miich ajcxy ca' mjadu'nɨty nej je mɨjtungmɨɨdpɨ ma je maybɨ naax cajp. Pɨnjaty miich ajcxy je mɨj tung yajnɨcxɨp, copɨcy ñaybɨdägɨɨyb nej tüg tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pen ji miich ajcxy nidüg nigohuajc'ada'ñ, copɨcy ñaybɨdägɨɨyb nej tüg tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Com ɨɨch nañ jadu'n, je jäy huɨdibɨ tzoon tzajpjoty, tɨ nmiiñɨch ya naaxhuiñ jaydëbɨ nbubedɨpyɨch yɨ mayjäy ajcxy. E canan yɨ' ajcxy xypubedɨpɨch. Ngɨ̈yegaamyɨch njugy'ajtɨn ma yɨ o'cɨn mɨɨd je mayjäy ycɨxpɨ, jaydëbɨ ngohua'nɨch jäy ajcxy y'alma huɨdibɨ tɨgoyam. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","E co Jesús etz ydiscípulos ajcxy ycajppɨdzɨmy jɨm Jericó, chi ypanɨcxɨ ajcxy mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E jɨm anajty ɨñaay nimetz huintzpɨ tüba'áy. E co ajcxy nejhuɨɨy co jɨm anajty ñaxy Jesús, chi ajcxy yaaxpɨ jojcpɨ: ―Huindzɨn, David y'ap y'oc, tun may'ajt ɨɨch pa'ayoog. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chi je mayjäy ajcxy ojcooty je metzpɨ jäy huintzpɨ, nɨmay ajcxy co huen amoñ. Per je huintzpɨ nïgɨ mɨnan'ɨdɨ̈ch: ―Huindzɨn, David y'ap y'oc, tun may'ajt ɨɨch pa'ayoog. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Huin'it Jesús ytɨnayxɨjp, e ymɨnañ: ―Ocmin miich ajcxy ya. Huin'it yajtɨɨy: ―¿Ti mdzojcpy ndunɨpyɨch mɨɨd miich? ");
INSERT INTO mcoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chi ajcxy ñɨmaayɨ: ―Huindzɨn, ndzojcpyɨch co xyajhuindɨcxɨ̈gɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Huin'it Jesús pa'ayoogoty ajcxy. Chi ajcxy nïdonɨ ma je' yhuiin, e mɨc'amy je huintzpɨ ajcxy y'ijxɨ̈gy. Chi Jesús ajcxy panɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","E co anajty Jesús etz je mayjäy ajcxy tɨ mɨhuingonɨ Jerusalén, chi yja'ty ma Betfagé cajp mɨhuingon je Olivos cögop. E jɨm Jesús quejxy nimetz ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Chi ajcxy nɨmay: ―Nɨcxcɨx ma je cajp huɨdibɨ jɨm'amy. E jɨm tüg burro ycoxochɨty mɨɨd y'ung. Coguejttüdɨp ajcxy je burro e yajmiingɨx ya ma ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","E pen jɨm pɨn nej xyñɨmäy, nɨma' co je Huindzɨn yajtunam, e yajhuimbida'ñ mɨc'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jadayaabɨ oy jadu'n ytuñyii yjadyii ycɨxy yca'pxy jadu'n nej je profeta jecyɨp jaay, co jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Yajnɨma' je jäy ajcxy huɨdibɨ tzɨnaayb jɨm Sión (Jerusalén), oc'ijxcɨx, chi miiñ ajcxy je mrey, yung nax yjot yhuinma'ñ mɨɨdɨty je mrey, etz burrocɨ́xy miiñ. Ma tüg burro mang huɨdibɨ ytaj tzɨmy yajyöyp. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chi je metz ydiscípulos ajcxy cuyduñ nej anajty Jesús tɨ y'ane'myii. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yajja'ty ajcxy je burro mɨɨd ymang. Chi Jesús ydiscípulos ajcxy jɨɨbe'ñ je metzpɨ burro mɨɨd ajcxy yjocxhuit, chi Jesús yaj'ɨñay je burro mang. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","E je mayjäy ooy yajhuinyëbɨy ajcxy je tü'aa mɨɨd yhuit, chi ajcxy oy ypuxy quipy y'aacx. Chi ajcxy pɨdacy ma je tü'aa. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","E jɨm ñajxy je burro, e je mayjäy huɨdibɨ nɨcxp jayɨjp, e nañ jadu'n huɨdibɨ anajty mimb axam, ooy ajcxy ytɨgɨɨy huambɨ jɨhuɨɨyb, chach mɨnaangɨxy: ―¡Hosana! ¡Gloria a Dios! ¡Ooy ycömayɨty Dios! Huen capxpaady idɨpy jada yëydɨjc huɨdibɨ mimb ma yɨ nHuindzɨn Dios yxɨɨ etz mɨɨd ymɨc'ajt. ¡Gloria a Dios! ");
INSERT INTO mcoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Co Jesús ytɨgɨɨy jɨm Jerusalén, chi tüg'ócɨy je mayjäy huinmay'ahuɨdijty, chi ñay'amɨdóohuɨgɨxy miñ xyɨpy: ―¿Pɨn yɨ' yɨjiibɨ jäy? ");
INSERT INTO mcoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chi mayjäy y'adzooy: ―Yɨ' je' je profeta Jesús huɨdibɨ tzoon ma Nazaret cajp ma Galilea it. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Huin'it Jesús ytɨgɨɨy ma Dios ytɨjc. Chi ixquejxtay tüg'ócɨy je ajuybɨ adoocpɨ huɨdibɨ anajty yajpatp jiiby. Chi tijhuimbijttay tüg'ócɨy je mesa ma anajty jäy jɨm ymeeñyhuingogongɨxy, etz nañ jadu'n tijhuimbijttay je muuxytoocpɨ ɨñaybejt. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chi jadu'n nɨmay ajcxy: ―Jaaybety jadu'n ymiiñ ma Dios ñecy: “Ɨɨch ndɨjc je' yɨ' ma jäy ajcxy Dios mɨbɨjctzoy”, per miich ajcxy hue' yɨ' mhua'ñ meetzpɨ tɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","E co anajty jiiby tzajptɨgoty Jesús, chi jiiby ñimiinɨ huɨdijaty anajty huintz, huɨdijaty anajty cɨ̈ma'ty tecyma'ty, chi Jesús yajtzooctay. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Per je teedy ajcxy huɨdibɨ mɨjtungmɨɨd etz je escribas ajcxy ooy mɨjotma'ty Jesús co ajcxy ijxy nejhuɨɨy jadu'n nej Jesús anajty tuñ mɨjhuinma'ñ. Etz nañ jadu'n ajcxy ijxy co je pi'c'anäg anajty ajcxy yhuaangɨxy yjɨhuɨɨygɨxy jiiby tzajptɨgoty, ymɨnaangɨxy: “¡Huen cömay'idɨpy je rey David y'ap y'oc!” ");
INSERT INTO mcoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Chi je teedy etz escribas ajcxy Jesús nɨmay: ―¿Nej ca' miich mmɨdooy nej je pi'c'anäg chach mɨnaangɨxy? Chi Jesús y'adzooy: ―Nmɨdooybɨch. ¿Nej ca' miich ajcxy mgapxyñɨ Dios ñecy ma ymiiñ jaaybety co jadu'n ymɨna'ñyɨ?: Tɨ myaj'ixpɨcy ɨɨy ma je pi'ctɨjc ma'xungdɨjc jaydëbɨ ajcxy ɨɨbaadɨp capxpaadɨp Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chi Jesús ycapxycɨ́jxy mɨɨd je teedy etz escribas ajcxy etz chooñ jiiby tzajtɨgoty. Chi ñɨcxy ma Betania cajp, e jɨm yajnajxy je tzumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","E co yxɨɨmɨy ytɨɨcxɨ̈gy, chi Jesús yhuimbijty Jerusalén. E ma anajty tɨm ytüyöy, jɨm yuuböccootɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","E jɨm ijxy ma tüba' tüg cop je higuerɨ quipy. Chi ninɨcxy. Chi pät'ijxy, per ca' anajty ni tüg ytɨɨm, jëda'ajty je' y'aay. Chi Jesús nɨmay je higuerɨ quipy: ―¡Ni ca mɨnaa xɨɨ mdɨɨm'adɨpy! E mɨc mɨ́cɨyɨ je higuerɨ quipy ytɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","E co je' ydiscípulos ajcxy jadu'n ijxy, chi ajcxy ooy huinmay. Chi ajcxy y'amɨdooy Jesús: ―¿Na'amy co yɨ higuerɨ quipy mɨc'amy tɨ ytɨ̈ch? ");
INSERT INTO mcoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chi Jesús y'adzooy: ―Janch tɨy'ajt jadu'n nej nnɨmaaygɨxy. Pen miich ajcxy mɨɨd je mɨbɨjcɨn, etz ca' ajcxy mmɨbɨcy aametz jotmetz, jëbɨ mɨjhuinma'n mdungɨxy nej ɨɨch tɨ nduñɨch. E nañ jadu'n jëbɨ jac mɨjpɨ mɨjhuinma'ñ mdunɨpy ajcxy. Jëbɨ ajcxy tun cop mnɨmäy: “Quëg ya, tɨgɨ' mejyjoty” e xycapxymɨdohuɨpy ajcxy je tun je cop. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","E tüg'ócɨy tijaty miich ajcxy mbɨjctzooyb huen ytɨmytijyɨty, pen mmɨbɨjcp ajcxy, mbaadɨp ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Co Jesús yja'ty Jerusalén, chi ytɨgɨɨy jadüg'oc ma Dios ytɨjc. E jiiby anajty yaj'ixpɨcy je mayjäy, chi ñimiinɨ je teedy mɨjtungmɨɨdpɨ etz judío mɨjjäydɨjc ajcxy. Chi ajcxy y'amɨdoohuɨ: ―¿Ma cötujcɨn tɨ mbaady co jadu'n mduñ tzajtɨgoty? ¿Pɨn jada cötujcɨn tɨ xymöy? ");
INSERT INTO mcoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Chi Jesús y'adzooy: ―Nañ jadu'n ɨɨch miich ajcxy nyaj'amɨdoohuamy tüg ayuc. Pen m'adzooyb ajcxy jada ayuc, huin'it ɨɨch miich ajcxy nyajnɨmähuɨpy ti cötujcɨn ɨɨch mɨɨd nduñ huɨdijaty. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pɨn quejxy je Juan, je Bautista, yajnɨɨbejtpɨ, Dios o jäy ajcxy? Chi ajcxy ñayñɨmáayɨgɨxy miñ xyipy: ―Co ixyipy ajt n'adzoohuɨm co Dios Juan quejx, huin'it xy'adzoohuɨm: “¿Na'amy co miich ajcxy ca' mmɨbɨjcy Juan?” ");
INSERT INTO mcoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Per nañ jadu'n ca' huaad nmɨnaanɨm co jäy ajcxy yajnïbɨjcy Juan, com nejhuɨɨyɨm co yɨ mayjäy mɨbɨjccɨxy co je' anajty Dios tüg y'ayucnajtzcapxɨɨybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","E paady ajcxy jadu'n adzooy Jesús: ―Ca' ɨɨch ajcxy nejhuɨɨygɨxy. Huin'it Jesús ymɨnañ: ―Nañ jadu'n ɨɨch ca' nigapxa'ñɨch pɨn je' ycötujcɨn mɨɨd nduñɨch huɨdijaty. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chi Jesús ymɨnañ: ―¿Nej m'oc'ixy m'ocjaygugɨ' jadayaabɨ ixpejt? Tüg je yëydɨjc ymɨɨd anajty metz je' ymang. Chi nɨmay je mɨjpɨ: “Nɨcx cham m'octuñ ma ɨɨch n'uva cam.” ");
INSERT INTO mcoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Huin'it je' ymang y'adzoohuɨ: “¡Ca' nnɨcxa'ñɨch!” Chi jaccohueeñyɨ je' ymang yhuinmaydɨgajch, chi ñɨcxy tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chi je ungdeedy oy ixy je ymang mutzpɨ. Chi nañ jadu'n nɨmaay co huen nɨcxy tuñ. Chi je' ymang mutzpɨ y'adzooy: “Oy, cham nɨ́cxɨbɨch.” Per ca' ñɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Huɨdi je' nidügtɨ ycuyduuñ nej anajty yteedy tzocy? Chi ajcxy ymɨnañ: ―Je' ymang mɨjpɨ huɨdibɨ jayɨjp nɨmay. Huin'it Jesús nɨmay ajcxy: ―Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co je huɨdibɨ ajcxy yajcogüejtpɨ etz je töxyjäy ajcxy huɨdibɨ tundɨgooyb mɨɨd yëydɨjc, je' ajcxy tɨgɨ̈huamb jayɨjp ma Dios y'ane'my jiiby tzajpjoty, ca'ydɨ miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Paady ycɨxpɨ oy ymiiñ je Juan huɨdibɨ jäy ajcxy yajnɨɨbejt, Juan yajni'ixɨɨygɨxy je mayjäy nej ajcxy jëbɨ yjothuimbidɨpy ma Dios. E miich ajcxy ca' mɨbɨjcy jadu'n nej Juan ymɨnañ. Per je' ajcxy huɨdibɨ yajcogüejtp etz je töxyjäydɨjc huɨdibɨ tundɨgooyb mɨɨd yëydɨjctɨjc, ymɨbɨjc je' ajcxy Juan. Oy miich ajcxy mja'ijxy, per ca' mjothuimbidaangɨxy etz ca' mɨbɨgaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Chi Jesús ymɨnañ: ―Oc'amɨdoo'ijtcɨx jadayaabɨ ijxpejt. Ji anajty tüg je huɨdibɨ nihuindzɨn'ajtp mɨjpɨ je tundac. Chi je cogam uvas cojy ma je ytundac etz jügajy. Chi yaj'oyɨɨy ma anajty jëbɨ je uvas ñɨɨ yajnïgɨdägaanɨ. Nañ jadu'n cojy tüg tzaaboch cɨxpɨ, jɨgɨx jëbɨ cuend'aty ycam. Co yaj'oyɨyday, chi je cogam yejcy pɨjctzoy je ycam ma je jäy ajcxy huɨdibɨ naymɨdunaanɨp. Chi oy choonɨ je cogam nɨcxy viaje tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Je huin'it tiempo co yhuaad'ajtnɨ je cosecha, chi je cogam quejxy nijëjɨty ytumbɨ jɨm ma huɨdibɨ anajty tɨ yajpɨjctzoy je ñaax co huen möyii je huɨdibɨ yɨ' paadaanɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per je jäy huɨdibɨ anajty tɨ naax pɨjctzoy, chi ajcxy majch je tumbɨ. Chi ajcxy ooy huinhuojpy jɨjphuojpy tüg. Chi ajcxy huingäch jɨjpcäch jadüg. Chi ajcxy je mɨdugɨɨgpɨ yaj'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chi je conaax cogam huingbɨ ytumbɨdɨjc quejxy. E nañ jadu'n ajcxy oy tungɨxy jadu'n nej anajty tɨ tungɨxy je jayɨjp'atypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chi ycɨ'm'ung oy quejx cogɨxɨɨyñɨ. Hue' jot'ajtɨ co yajmɨj'adɨɨyb je' y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per co ajcxy je tumbɨdɨjc ijxpaty je cogam je' y'ung, chi ajcxy ñaygapxɨ: “Tzoc ajt yaj'o'cɨm je cogam ymang, com yɨ' je' mɨhuɨ'mamb je' yteedy je yjugy'ajtɨn je ypɨdägy. E co ajt nyaj'o'cɨm, chi ɨɨch ajt nmɨhuɨ'mɨm je cam.” ");
INSERT INTO mcoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chi ajcxy majch je cogam ymang. Chi ajcxy huijtzpɨdzɨmy ma je tundac. Chi oy yaj'öccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Huin'it Jesús ymɨnañ: ―Co anajty tɨ miiñ je conaax je cogam, ¿ti jada' y'octunɨpy mɨɨd je tumbɨdɨjc ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chi je teedytɨjc etz mɨjjäydɨjc y'adzooy: ―Je cogam yaj'ögɨpy yɨjiibɨ jɨbɨcjäydɨjc, ca' ajcxy pa'ayoohuɨpy, etz yegɨpy je uvas cam pɨjctzoy ma je huingbɨ jäy huɨdibɨ yegɨpy je pɨdägy huɨdibɨ cogam paatɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chi Jesús ymɨnañ: ―¿Nej ca'nɨ miich ajcxy mgapxy ma miiñ jaaybety ma Dios ñecyɨ? Jadu'n ymɨnañ: Je yëydɨjc huɨdibɨ je jäy ajcxy ca' anajty tzocy, Dios tɨ pɨdägy mɨj'ane'mbɨ. Tɨm jadu'n nipaady nej tüg tzaa oybɨ huɨdibɨ je pojtzpɨdɨjc ca' ajcxy yajtuna'ñ, e je' je' oy tɨ yhuɨ'mnɨ ma anajty yjaccopɨcyɨty. Je Huindzɨn Dios jada tung tɨ tuñ, e ooy oy n'ijxɨm yɨ' ytung. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","E paady jadu'n ɨɨch miich ajcxy nɨmäy co miich ajcxy myajpɨga'ñ yɨ m'it mlugar jiiby tzajpjoty ma Dios y'ane'my etz yajmöhua'ñ je huingbɨ jäy je huɨdibɨ amuumdügjot naygɨ̈yejcɨp ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pɨnjaty ca' cöbɨga'ñ jada mɨj'ane'mbɨ, ayo'n ypadaamb, ytɨmnipatp nej jɨhuɨ̈y jɨm ycɨjxcɨday ma je tzaa nïcx, tɨjhuïdz yjajtähuɨpy. O pen je mɨj'ane'mbɨ mɨdziptzoñ je jäy, chi ytɨgoydähuɨpy ajcxy, tɨm jadu'n nej jɨhuɨ̈y je tzaa ñigɨdaagoodyii ajcxy, e janch jaam püx nɨcxy yjaty. ");
INSERT INTO mcoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Co ajcxy mɨdooy, chi je teedytɨjc etz je fariseostɨjc huinjɨhuɨɨy co yɨ' ajcxy yajnigapxyp, ");
INSERT INTO mcoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","chi Jesús ajcxy jamadzaañ. Per tzɨgɨɨyb anajty ajcxy mɨɨd je mayjäy, je' co je mayjäy anajty mɨbɨjccɨxy co Jesús najtzcapxɨɨyb Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chi Jesús jadüg'oc ytɨgɨɨy capxp mɨɨd ijxpejt, ymɨnañ jadu'n: ");
INSERT INTO mcoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Je Dios y'ane'mɨn jadu'n nipaady nej je rey ymang ocnixɨɨduñ co tɨ ypɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chi je rey quejxhuäcxtay je ytumbɨ co huen nɨcxy huoomujctaaygɨxy je huɨdijaty anajty tɨ yaj'nɨmaaygɨxy co míingɨxɨpy ma ytuna'ñyii yjada'ñyii je pɨjcɨn. Per ca' je' ajcxy ymiina'ñ ma je pɨjcɨn nixɨɨduñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chi quejxnɨp huingbɨ ytumbɨ, nɨmay ajcxy: “Nɨmaaygɨx je tɨɨbɨ oy jayɨjp'aty mnɨmaaygɨx jadu'n co huen mmiingɨxy ma yam je caayɨn uucɨn ni'ixɨ' y'ity. Tɨ je huaj nïcxpɨ nyaj'ögyɨch. E ni'ixɨ' ijttaayñɨ, huen miiñ ajcxy ma je pɨjcɨn ytuna'ñyii yjada'ñyii.” ");
INSERT INTO mcoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","E je' ajcxy tɨɨbɨ anajty yaj'nɨmaaygɨxy, ca' ajcxy je' ytɨmy tuñ cuendɨ. Nijëjɨty ajcxy ñɨcxy ma ytundac. Nijëjɨty ajcxy ñɨcxy toocp yejcp; ");
INSERT INTO mcoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","e nijëjɨty ajcxy majch je rey yquejxyöybɨ ajcxy, chi ajcxy oy chaachytuñ, chi yaj'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chi je rey ooy chachjotma'ty. Chi je soldados ajcxy quejxy co huen nɨcxy yaj'öctäyii je jäyyaj'öcp ajcxy etz ytoydähuɨp je ycajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chi je rey nɨmay je ytumbɨ ajcxy: “Ni'ixɨ' ijttäy ma jadayaabɨ je pɨjcɨn yajnixɨɨduna'ñ. Per je huɨdibɨ ajcxy tɨ yajnɨmäy ca' ajcxy mɨhuaadɨty co ymíingɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nɨcx miich ajcxy majaty jäy yjɨɨn ytɨjc. Nɨmaaygɨxy tüg'ócɨy pɨnjaty ajcxy mbaty, co huen miingɨxy ma je pɨjcpɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chi ñɨcxy je rey ytumbɨ ajcxy. Chi ajcxy mɨɨdmiinday je mayjäy, je oyjäybɨ etz je jɨbɨcjäybɨ. Chi y'ujtztay je rey ytɨjc mɨɨd je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Huin'it je rey ytɨgɨɨy mayjäyjoty, ixa'ñ anajty huɨdijaty tɨ yajhuomiñ. E jiiby tüg yëydɨjc tɨ ijxpaty huɨdibɨ ca' anajty tɨ ñayxoxyii, jadu'n nej jäy nayxójxɨgɨxy co ajcxy nɨcxy ma tüg pɨjcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Huin'it je rey mɨnañ: “Mɨgüg, ¿nej ya tɨ mdɨgɨ̈y tɨgoty, e ca' mxojx mɨɨdɨty nej ypaadyii?” E je yëydɨjc amoñyɨ je' yhuɨ'my. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chi je rey nɨmay huɨdibɨ anajty jɨm pubejtp: “Cɨ̈xotz tecyxotz jada yëydɨjc etz pɨdäg agootztuuby. E jiiby yjɨ̈huɨpy yäxɨpy, jiiby ytɨɨtz huinqueedɨp mɨɨd jotmay.” ");
INSERT INTO mcoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Com may je jäy ajcxy huɨdibɨ tɨ yajhuooy, e hueenɨ ajcxy huɨdibɨ tɨ yajhuin'ixy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Je huin'it tiempo je fariseos ajcxy tuuñ quipxycapxy co anajty xɨ̈huaangɨxy nïhuambedaangɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","E jadu'n ajcxy quejxy ma Jesús yajpaady naagɨty huɨdibɨ mɨnɨcxpejt je fariseos ajcxy ytɨy'ajt etz naagɨty huɨdibɨ mɨjnɨcxpejt je Herodes ytɨy'ajt. Chi ajcxy Jesús nɨmay: ―Huindzɨn, nejhuɨɨybɨch ɨɨch ajcxy co miich mgapxy je tɨy'ajt. Tudägy myaj'ixpɨcy jäy ajcxy jadu'n nej huaad ajcxy cuychɨnaaygɨxy Dios ytɨy'ajt. E ca' mgüendɨtuñ nej jäy ajcxy ymɨnaangɨxy. Tú'cɨy miich mduñ mɨɨd comeeñyjäy etz mɨɨd ayoobtɨjc, ca' huin'ixpety myaj'ixpɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nejhuɨ̈huamy ɨɨch ajcxy nej miich mɨna'ñ pen tɨy'ajt jadu'n: ¿Nej ndundɨgooyɨm ma Dios ycötujcɨn, co ngüejtɨm ma César, je romano mɨj'ane'mbɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per Jesús ñejhuɨɨyb anajty ajcxy yjɨbɨc-huinma'ñ, e chi ajcxy nɨmay: ―Ooy miich ajcxy naybɨdáacɨgɨxy nej jɨhuɨ̈y ooy mdudägyɨty, e ca' yjanchɨty. ¿Na'amy co ajcxy xychachjot'ixy xychachhuinma'ñ'ixyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yaj'ijxcɨch tüg meeñ huɨdi mɨɨd mɨgüéjtɨgɨxy César. Chi ajcxy mɨmiiñ tüg meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chi co Jesús y'ijxy je meeñ, chi yajtɨɨy: ―¿Pɨn y'ahuɨnax e pɨn yxɨɨ cɨxjaay ma jada meeñ? ");
INSERT INTO mcoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Chi ajcxy y'adzooy: ―Je romano mɨj'ane'mbɨ y'ahuɨnax etz yɨ' yxɨɨ. Huin'it Jesús je' ajcxy nɨmay: ―Mo' je César huɨdibɨ yɨ' yjë'ajtpy, etz mo' Dios huɨdibɨ Dios yjë'ajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","E co ajcxy jadu'n mɨdooy, chi ajcxy ooy jɨhuɨɨy huinmay. Chi ajcxy ixmajch Jesús, e ñɨcxnɨ ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Je huin'it xɨɨ je saduceos ajcxy oy ixy Jesús. Yɨ' ajcxy ymɨna'ñ co ca' yjugypɨga'ñ je öcpɨ ajcxy. E jadu'n ajcxy huinma'ñ pɨdägy, e ymɨnaangɨxy: ");
INSERT INTO mcoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Huindzɨn, jadu'n miiñ ma Moisés ycötújcɨn co je yëydɨjc huɨdibɨ ypɨjcychɨnaayb mɨɨd ytöxyɨjc, e pen öcp je yëydɨjc, e ca' ni tüg y'ung yajhuɨ'my, copɨcy co co'öcytöxyjäy ypɨjctɨgadzɨpy mɨɨd je yëydɨjc ymɨguëx. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pues jii ma ɨɨch ajcxy anajty tüg quëx je yëydɨjc nihuɨxtujc. Je unggoob ypɨjcy, e chi ix'ögy ytöxyɨjc, e ca' ni tüg y'ung yajhuɨ'my. Chi je mɨguëx ypɨjctɨgajch mɨɨd je töxyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nañ jadu'n je mɨmetzpɨ yëydɨjc ix'o'cy ytöxyɨjc. Nañ jadu'n je mɨdugɨɨgpɨ yëydɨjc ix'o'cy ytöxyɨjc. E jadu'n oytuñyii yjadyii mɨɨd je töxyjäy co tɨ anajty mɨɨddzɨnay'abɨdzɨmdäy je nihuɨxtujcpɨ yëydɨjc tüg quëxpɨ. E je nihuɨxtujcpɨ ajcxy ix'o'cy je töxyjäy, e ca' ni tüg y'ung ajcxy yajhuɨ'my. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chi nañ jadu'n oy y'öcnɨ je töxyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","E co anajty xɨɨ tiempo paty, co anajty Dios yajjugypɨcy yɨ tɨɨbɨ ajcxy y'ögy, ¿huɨdibɨ jada' ajcxy nidügtɨ je yëydɨjc töxyɨjc'adaanɨp je töxyjäy? Com tɨ ajcxy jadu'n nihuɨxtujcpɨ mɨɨddzɨnay'abɨdzɨmgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chi Jesús je' ajcxy y'adzooy: ―Miich ajcxy ca' mhuinjɨhuɨ̈y je tɨy'ajt, com ca' mnejhuɨɨygɨxy Dios y'ayuc ytɨy'ajt, e com ni ca' mnejhuɨɨygɨxy je mɨc'ajt huɨdibɨ Dios ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pues co anajty yjugypɨjccɨxy je jäy tɨɨbɨ y'öccɨxy, chi ca' ajcxy ypɨga'ñ, e nañ jadu'n ni ca' ajcxy ñaymöhuɨɨyb y'ung huen pɨjccɨxy. Hue' ajcxy yjugy'adaangɨxy chɨnähuaangɨxy jiiby tzajpjoty, tɨm jadu'n nej je ángeles ajcxy chɨnaaygɨxy jugy'ajtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Per je tɨy'ajt co jäy ajcxy tɨɨbɨ y'öccɨxy yjucypɨgaangɨxy jadüg'oc, jëbɨ mbaatcɨxy jada tɨy'ajt ma Dios ñecy. Dios cɨ'm jadu'n mɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ɨɨch je' je Dios huɨdibɨ Abraham, Isaac etz Jacob yDios'ajtpy.” Com yɨ Dios ca' yɨ' yDios'aty ma yɨ öcpɨ ajcxy. Yɨ Dios Dios'ajtp yɨ' ma yɨ juugypɨ ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","E co je mayjäy jadu'n mɨdooy, chi ajcxy ooy tzachjɨhuɨɨy tzachhuinmaay je Jesús y'ixpɨjcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","E co je fariseos ajcxy nejhuɨɨy co Jesús anajty tɨ yaj'amoñyii je saduceos ajcxy, chi ajcxy ñayyöymujctaayɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","E jɨm anajty tüg leyhuindzɨn huɨdibɨ Jesús anajty jot'ijxyp huinma'ñ'ijxyp, chi y'amɨdooy: ");
INSERT INTO mcoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Huindzɨn, ¿ma yɨ maybɨ Dios ycötujcɨn, huɨdibɨ yɨ' jaccopɨcyɨp? ");
INSERT INTO mcoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chi Jesús y'adzooy: ―Tzoc jɨhuɨ' etz yajmɨj'at nHuindzɨn'ajtɨm Dios mɨɨd tüg'ócɨy m'aa mjot, etz mɨɨd tüg'ócɨy m'alma, etz mɨɨd tüg'ócɨy mhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jada je' jadu'n je Dios ycötujcɨn huɨdibɨ jaccopɨcyɨp, etz huɨdibɨ tɨm jayɨjpɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Je mɨmetzpɨ Dios ycötujcɨn jahueengɨ tú'cɨy ñaybadyii mɨɨd je jayɨjpɨ, yɨ' huɨdibɨ jadu'n mɨnamb: “Tzojccɨx jɨhuɨɨygɨx yɨ mmɨgügtɨjc, tɨm jadu'n nej mnaychogyii nayjɨhuɨ̈yii cɨ'm.” ");
INSERT INTO mcoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jada Dios metzpɨ ycötujcɨn jaccopɨcy jacmɨc'ajt mɨɨd ca' jac huɨdibɨ cötujcɨn huɨdibɨ Moisés etz je profetas ajcxy yejc. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","E ma anajty jɨm tügmucy yjac'ijtcɨxy je fariseos, huin'it Jesús yajtɨɨy: ");
INSERT INTO mcoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Nej miich ajcxy huinmay mɨɨd Cristo? ¿Pɨn je' y'apmang? Chi ajcxy y'adzooy: ―Je David je' y'apmang. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chi Jesús ajcxy nɨmay: ―¿Na'amy co David anajty tɨ ymɨna'ñ co Cristo hue' je' yɨ' yhuindzɨn? Jadu'n tɨ capxy David anajty mɨɨd je Dios yjɨhuɨ'ñ ymɨc'ajt, ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Je Huindzɨn Dios nɨmay ɨɨch nHuindzɨn: “Ɨña' ma ɨɨch n'a'oy'amy, ixtɨ coonɨ ɨɨch miich nyajmɨmadägɨp ma je mmɨdzip ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Nej jëbɨ David ymɨj'ap'adyii je Cristo? Com David cɨ'm ymɨnañ co Cristo yɨ' je' yhuindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","E nitüg'aa ajcxy yca'adzohuimbijty. E jadu'n nej je xɨɨ tiempo yjacnɨcx anajty ca' ni pɨn ocjacyajtɨɨyñɨ huɨdijaty ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chi Jesús nɨmay je mayjäy etz yɨ' ydiscípulos ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Je escribas etz je fariseos ajcxy chachnaygömáayɨgɨxy co yɨ' ajcxy jajtp nej capxtɨ'cxɨpy je cötujcɨn huɨdibɨ Moisés yjaay jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Oy co ajcxy mguydunɨpy jadu'n nej yɨ' ajcxy xyaj'ixpɨjccɨxy Dios y'ayuc, capxymɨdoogɨx nej xyñɨmaaygɨxy per ca' mdungɨxy huɨdibɨ yɨ' ajcxy ytumb, com yɨ' ajcxy oy ycapxcɨxy e ca' ajcxy cuydungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yɨ' ajcxy nɨgo yajcojcɨxy canaag costumbre huɨdi je jäy ajcxy ca' mɨmadäga'ñ, e ca' ajcxy pa'ayoy je jäy, tɨm jadu'n nipaady nej jɨhuɨ̈y tüg tzɨmy tɨ mooygɨxy jemxypɨ huɨdibɨ ca' je jäy ajcxy mɨmadäga'ñ, e yɨ escribas etz fariseos ajcxy ni ca' ycɨ̈huäx yajpaadaangɨxy je tzɨmy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tüg'ócɨy huɨdi yɨ' ajcxy ytumyb, je' ajcxy ytumyb co huen jäy ajcxy ixyii, jaydëbɨ yajcömay ajcxy. Yɨ' ajcxy yajhuimboc-huɨɨnɨ́ɨyɨgɨxy etz ñayyajcɨ̈huɨɨnɨ́ɨyɨgɨxy Dios y'ayuc. Nayxojxcɨxy mɨɨd huit yooñjatypɨ co chachcömayaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ooy ajcxy tzocy ɨñaybejt ma je' ɨñäy je ane'mbɨ ma jäy ajcxy yxɨɨduñ. Ooy ajcxy tzocy yɨ cödumbɨ ɨñaybejt ma je naymujctac. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yɨ escribas etz fariseos ajcxy oy tzojccɨxy co ajcxy yajcapxpoocxɨp huindzɨgɨ'ñ'amy mayjäyduum. Etz nañ jadu'n ajcxy tzocy co jäy ajcxy yajmɨj'adɨɨyb nej huindzɨndɨjc ixpɨcytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Miich ajcxy ca' jadu'n m'a'ɨxɨ̈huɨpy co ajcxy xytijɨpy huindzɨn com nidüg'ócɨy miich ajcxy mnaymɨgüg'ájtɨgɨxy, etz tügpajc je' huɨdibɨ miich ajcxy mhuindzɨn'ajtpy yɨ' je' Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","E nañ jadu'n miich ajcxy ya naaxhuiñ, ca' oy ni pɨn mdeedy'adɨɨyb co mɨɨd miich ajcxy tügpajc je mDeedy, huɨdibɨ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","E nañ ni mganaydijɨɨyb ajcxy mɨj ane'mbɨ, com yɨ Cristo je' tügpajc miich ajcxy mmɨj'ane'mbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Je pɨn jaccapxymɨdoob ymɨgügtɨjc, je' je' mɨj'ajtɨn mɨɨd ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pɨnjaty huɨdibɨ cɨ'm naygömayɨp, tzöydu'nbaadɨp je', e pɨnjaty naybɨdaacɨp nicy xeemy, je' je' capxpaady y'idɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Ay miich ayoob ajcxy fariseos etz escribas ajcxy! Miich ajcxy mnaybɨdáacɨgɨxy nej jɨhuɨ̈y ooy mdudägyjäy, e ca' yjanchɨty. Miich ajcxy mgoyüchpy je Dios ytɨy'ajtɨn nej huaad jäy ajcxy ytɨgɨ̈y jiiby tzajpjoty ma Dios y'ane'my. Ni miich ajcxy mgatɨgɨɨygɨxy, e nañ ni mga'a'ɨxɨɨygɨxy co huingbɨ ytɨgɨ̈huɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ay miich ayoob ajcxy fariseos etz escribas ajcxy! ¡Miich ajcxy m'aanɨɨdacp! Miich ajcxy myajcɨjxtaayɨ yɨ co'ögy ytöxyjäy ypɨdägy mɨɨd ajcxy m'adzojcɨn, e mdungɨxy ooy jecy tzajpcapxycapxɨɨ, jɨgɨx capxpaady mbɨdzɨmɨpy. Dios nïgɨ chaachytunɨp miich ajcxy mɨɨd mbocy ycɨxpɨ, ca'ydɨ jac pɨn jäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ay miich ayoob ajcxy fariseos etz escribas, miich ajcxy naybɨdaacɨgɨxy tudägy, e ca' yjanchɨty! Mhuinyöy'abɨdzɨmyb miich ajcxy je naaxhuiñybɨ, co mgapxhuäcxa'ñ je m'ixpɨjcɨn ma je tügpɨ jäy. E co ajcxy je' myajmɨbɨcy, huin'it mejtz jadu'ñyɨ je pocy anajty mɨɨdɨty je jäy, ca'ydɨ miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ay miich ayoob ajcxy huɨdibɨ jadu'n ɨdɨɨtzp nej tügɨ huintzpɨ huinhuoy! Miich ajcxy mɨnamb co pen tüg jäy tuñ yhuandaacɨn, e ɨɨbaatɨ capxpaatɨ Dios ytɨjc, chi ca' cuyduñ je huandaacɨn. Per pen ɨɨbatpy capxpatpy je oorɨ huɨdibɨ jiiby ma Dios ytɨjc, huin'it janchtɨy cuyduñ je huandaacɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tzuudɨjc locɨdɨjc huɨdibɨ ca' huinjɨhuɨ̈y je tɨy'ajt. ¿Huɨdibɨ jaccopɨcyɨp: je oorɨ o je Dios ytɨjc ma je oorɨ yoxy ity? ");
INSERT INTO mcoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nañ jadu'n miich ajcxy mɨna'ñ: “Pen tüg jäy huandaacɨn tuñ, e capxpaady je altar ma Dios yajhuindzɨgɨ̈y, chi ca' cuyduñ je huandaacɨn. Per pen capxpaady je huindzɨgɨ'ñ tzüch ma je altar ma Dios yajhuindzɨgɨ̈y, chi cuyduñ yhuandaacɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tzuudɨjc locɨdɨjc huɨdibɨ ca' huinjɨhuɨ̈y je tɨy'ajt! ¿Huɨdibɨ jacmɨj'ajtɨn ymɨɨd je huɨdibɨ tɨ yajyoxy o je altar? ");
INSERT INTO mcoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pɨnjaty capxpatp je Dios ytɨjc ma Dios yajhuindzɨgɨ̈y y'agapxmuctaayb anajty huɨdijaty jiiby yajpaatp ma Dios yajhuindzɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pɨnjaty capxpatp je Dios ytɨjc, ca' anajty jëyɨ capxpaady Dios ytɨjc, nañ ycapxpatp anajty Dios huɨdibɨ jiiby tzɨnaayb. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pɨnjaty capxpatp je tzajp, nañ capxpatp anajty Dios y'ane'mdac quipxyɨ mɨɨd Dios huɨdi tzɨnaayb jiiby. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ay miich ayoob ajcxy fariseos etz escribas ajcxy, huɨdi naybɨdaacɨp tudägy, e ca' yjanchɨty! Miich ajcxy mooyb Dios je tügpɨcy je majcpɨ huɨdibɨ je' paatɨp, ixtɨ yɨ tzajnɨmang, yɨ ruda etz je pi'c'ujtz'ay ung. Per ca' ajcxy mduñcuentɨ je cötujcɨn huɨdibɨ jaccopɨcyɨty. Miich ajcxy ca' mdzɨnäy tɨydudägy mɨɨd je mɨgügtɨjc. Miich ajcxy ca' mmɨɨdɨty pa'ayo'n mɨɨd je' ajcxy huɨdibɨ ayoob jottɨgooyb, etz ca' mmɨbɨjccɨxy Dios. Jada ixyipy ajcxy mbaadumyb, e mooygɨxy Dios je tügpɨcy je majcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Tzuudɨjc locɨtɨjc! Miich ajcxy tɨ m'anajxyp je uux, e mgojɨɨnnaaxcɨxy je camello, je mɨjpɨ ɨyujc. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ay miich ayoob ajcxy fariseos etz escribas ajcxy, miich ajcxy naybɨdaacɨp nej tudägy jäy, e ca' yjanchɨty! Jiiby jotjoty huinma'ñyjoty miich ajcxy mɨɨdɨty jɨbɨcpɨ. Miich ajcxy mɨɨd je ca'oy'ixɨɨ etz je adzojcɨn. Tɨm jadu'n nipaady nej jɨhuɨ̈y myajhuächpy ajcxy yɨ tasɨ ninïcx yɨ texy ninïcx, e chi myajhuɨ'my jɨbɨcpɨ ma tasɨjot ma texyjot. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Tzuudɨjc miich ajcxy! Jayɨjp yajhuädz jiiby jotjoty texy tasɨ, huin'it huɨ'm nañ jadu'n huädz nïgɨx'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ay miich ayoob ajcxy fariseos etz escribas ajcxy, miich ajcxy naybɨdaacɨp nej tudägy jäy, e ca' yjanchɨty! Jadu'n miich ajcxy nipaady nej öcpɨ jut. Je öcpɨ jut nïgɨx janch oy yquëxɨ̈gy, per jiiby jutjoty ujtz jiiby mɨɨd je öcpɨ pajc etz mɨɨd jɨbɨcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jadu'n ajcxy mguëxɨ̈gy mayjäyduum nej jɨhuɨ̈y ooy m'oyjäyɨty, per jiiby jotjoty mɨɨd jɨbɨc-huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ay miich ayoob ajcxy fariseos etz escribas ajcxy, miich ajcxy naybɨdaacɨp nej tudägy jäy, e ca' yjanchɨty! Miich ajcxy mgo'abojtzcɨxy yajxon je öcpɨ jut ma profeta ajcxy ñaaxtɨgɨɨy, etz mxoxy ajcxy mɨɨd je pɨjy ma ñaaxtɨgɨɨy je tudägy jäy ajcxy, ");
INSERT INTO mcoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","e miich ajcxy nayñɨmaayɨgɨxy miñ xyipy: “Co ixyipy anajty n'octzɨnaayɨm jecy'ajty ca' ngapubejtɨm co ajt nmɨj'ap nmɨjteedy yaj'ögy je profetas ajcxy etz je tudägy jäy ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mɨɨd jada ycɨxpɨ miich ajcxy nejhuɨɨyb co miich ajcxy m'ap'adyii mdeedy'adyii je jɨbɨcjäydɨjc ajcxy huɨdibɨ yaj'öc je profetas. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Miich ajcxy yajcɨ́jxcɨxy je jɨbɨcpɨ huɨdibɨ ajcxy mmɨj'ap mmɨjteedy yajtzondac! ");
INSERT INTO mcoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Jadu'n miich ajcxy nipaady nej mayxoox! Ca' miich ajcxy madägɨpy cöguëgɨpy je tzaachypɨ jiiby ayoodactuuby. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","E paady nguexaamybɨch ma miich ajcxy profetas etz huɨdibɨ ixpɨcyɨp ma Dios y'ayuc, etz huɨdibɨ xyaj'ixpɨgamb ajcxy yɨ Dios ñecy. Per miich ajcxy myaj'ögamyb myajcruutzpedamyb nijëjɨty, etz nijëjɨty mgoxamyb mhuobamyb ajcxy jiiby tzajtɨgoty etz m'ixhuɨdida'ñ mbahuɨdida'ñ ajcxy cajp cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Je mɨjpocy xyñigɨdaccoda'ñ miich ajcxy, jadu'n nej je oyjäy ñɨ'py temy yojcy jecy'ajty, oga'ñ chondacy mɨɨd je oyjäy Abel etz ycogɨxɨ̈y mɨɨd Zacarías, je Berequías y'ung huɨdibɨ miich ajcxy mmɨj'ap mmɨjteedy myaj'o'c jiiby tzajtɨgoty ma altar. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co je mɨjpocy ñigɨdaccoda'ñ je jäy ajcxy huɨdibɨ tzɨnaayb jadachambɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Miich ajcxy Jerusalén jäy! ¡Miich ajcxy Jerusalén jäy! Jerusalén jäy huɨdibɨ jecy'ajty yaj'ögy je profetɨtɨjc etz ycögächpy ajcxy je Dios ycogapxy. Canaag'oc tɨ njayajtügmujctähua'ñɨch miich ajcxy, jadu'n nej tzeydaj yajtügmujctäy je' y'ung ma yqueec pät, per miich ca' m'a'ɨxɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Oc'ix miich ajcxy nej mdɨjc abac yhuɨ'maangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co camɨna miich ajcxy xy'ixɨpyɨch jadüg'oc, ixtɨ coonɨ paadɨpy je xɨɨ je tiempo co jäy ajcxy ymɨna'nɨpy: “Cömay yɨ huɨdibɨ miimb mɨɨd nhuindzɨn Dios yxɨɨ etz ymɨc'ajt.” ");
INSERT INTO mcoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma anajty Jesús tɨ ypɨdzɨmnɨ ma Dios ytɨjc, nɨcxp anajty, huin'it Jesús ydiscípulos ajcxy ñimɨjhuäcɨ. Yɨ' ajcxy anajty yaj'ixɨydähuamyb je Dios ytɨjc, com ooy anajty chachmɨjtɨjcɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chi Jesús ymɨnañ: ―Huindɨcx miich ajcxy jada maybɨ mɨjjaty ytɨjc. Miinɨpy xɨɨ tiempo mɨna tüg'ócɨy jada tɨjc nɨcxy yhuɨ'my taj xit, ca' ma tzaamacxy. Huindɨgoydähuɨpy tüg'ócɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chi oy ñɨcxnɨ ajcxy ma Olivos cögop. E co anajty jɨm, Jesús y'ɨñäy, chi ñɨmaayɨ ameech je' ydiscípulos ajcxy: ―Ɨɨch ajcxy nejhuɨ̈huamyb mɨna jëdu'n ytuna'ñyii yjada'ñyii. ¿Ti je' quëxɨ̈gamb co anajty miich mhuimbida'ñ ya naaxhuiñ, e co anajty je naaxhuiñybɨ ytɨgoya'ñ? ");
INSERT INTO mcoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chi Jesús nɨmay ajcxy: ―Mnaygüend'adɨɨb ajcxy, ca'ydɨ pɨn xyhuin'ɨɨngɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ooy mayjäy ñaybɨdägáanɨgɨxy mɨɨd ɨɨch nxɨɨ, naybɨdägáanɨgɨxy co je' ajcxy je Cristo, ymɨna'na'ñ ajcxy: “Ɨɨch je' je Cristo.” ");
INSERT INTO mcoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Co miich ajcxy ayuc mɨdohuɨpy co jäy ajcxy chachtziptungɨxy ñayñibɨdɨ̈gɨgɨxy xɨ ya, chi ca' ajcxy mdzɨgɨ́ɨygɨxɨp, com ooy ycopɨcyɨty co jadu'n jayɨjp ytunɨɨyb yjadɨɨyb. Ca' nan hue' je' anajty tɨm cɨjxp tɨm tɨgooyb je xɨɨ je tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nayñibɨdɨ̈gɨɨb naax cajp mɨɨd huɨngbɨ naax huingbɨ cajp, e gobierno mɨɨd huingbɨ gobierno. E miinɨp mɨc'ujx canaag'it etz mɨj yuu etz mɨj pa'm xɨ ya. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jada tzaachypɨ ayo'n oga'nɨ anajty chondägy huɨdibɨ nmɨnaxaanɨm nyajnaxaanɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Huin'it xɨɨ huin'it tiempo miich ajcxy myajcɨ̈yegɨpy, jɨgɨx xychaachytúngɨxɨpy e xyaj'ögɨxɨpy. E tüg'ócɨy je maynaaxhuiñyjäy xyca'ixáangɨxɨpy, mɨɨd ɨɨch nxɨɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Je huin'it tiempo may je jäy ajcxy yajtɨgoya'ñ ymɨbɨjcɨn. E nañ jadu'n ñayca'oy'ixáanɨgɨxy etz ñayñigapxáanɨgɨxy ñi'ojɨ̈huáanɨgɨxy miñ xyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ooy may quëxɨ̈gaangɨxy aanɨɨdaacpɨdɨjc mɨna'naangɨxy co Dios y'ayuc ytɨy' ajt nimɨydacɨ, e mayjäy oy huin'ɨɨnaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","E je' co ajcxy xɨɨ jɨmɨjt ñajtznïnɨcxɨɨyñɨ jac tɨm nïgɨ jɨbɨcpɨ tunaangɨxy, ca' ajcxy y'ocnaychójcɨnɨpy miñ xyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per pɨnjaty tɨydudägy panɨcxp je mɨbɨjcɨn, je' ajcxy ypaadɨp y'alma nïdzoocɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Copɨcy co jayɨjp yajcapxhuäcxa'ñ huindu'ñybɨ naaxhuiñybɨ Dios y'ayuc ytɨy'ajt jemybɨ, jaydëbɨ jäy ajcxy nidüg'ocɨy nejhuɨ̈y Dios ytɨy'ajt. Huin'it je naaxhuiñybɨ ycɨjxnɨ ytɨgooyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Je profeta Daniel jaay jecy'ajty jada ayuc (miich ajcxy pɨnjaty capx jada necy huinjɨhuɨɨygɨxy) ma mɨnañ: Miich ajcxy co m'ixy pɨnjaty jɨbɨc-huinma'ñ tumb nej ca' ypadyii ma Dios ytɨjc, huɨdibɨ ooy ycodzɨgɨ̈jɨty, chi miich ajcxy huɨdibɨ tzɨnaayb jɨm Judea, co jadu'n m'ijxcɨxy, chi nɨcx mgueectzóocɨxɨpy mɨc'amy ma tungop. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pɨnjaty huɨdibɨ yajpatp ma ytɨjcnïcx ca' nɨcxy tijaty yajpɨdzɨmy ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yɨ jäy ajcxy huɨdibɨ yajpatp camjoty, ca' ajcxy huimbidɨpy co yajpɨdzɨmɨpy tijaty ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Huin'it tiempo ayo'n ypadamy je töxyjäy ajcxy huɨdibɨ anajty y'ungdzɨm'ijt, e nañ jadu'n je' ajcxy huɨdibɨ mɨɨd y'ungma'xung. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","May'ajt ajcxy mbɨjctzoohuɨpy yɨ Dios co jada jadu'mbɨ ayo'n ca' ytunɨɨyb yjadɨɨyb ma anajty ytɨɨchtiempojɨty, etz ma anajty pocxɨnxɨɨjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Huin'it oy ayo'n jotmay ytuna'ñyii yjada'ñyii huɨdibɨ nicamɨna ycatuñyii ycajadyiinɨ mabɨ naaxhuiñybɨ chondägy e nicamɨna jadu'n ycajactunɨɨyb ycajacjadɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pen ca' Dios capx'aduga'ñ yɨjiibɨ ayo'n xɨɨ ayo'n tiempo, ni pɨn ca' chögɨpy. Per Dios ycapx'adugamy yɨjiibɨ ayo'n tiempo mɨɨd je mɨbɨjcpɨdɨjc ycɨxpɨ huɨdibɨ Dios tɨ huin'ixy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Co yɨ jadu'mbɨ xɨɨ tiempo anajty ymiiñ, ca' mmɨbɨ́jccɨxɨpy, pen ji pɨnjaty xyñɨmaaygɨxy: “Ijxcɨx, cha yajpaady je Cristo”, o “Jɨm'amy yajpaady je Cristo.” Ca' mmɨbɨ́jccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pues miinɨp jäy ajcxy huɨdibɨ huin'ɨɨnaangɨxy ymɨgügtɨjc. Cɨ'm ñayyajnaxáanɨgɨxy jadu'n nej jɨhuɨ̈y je' yCrístɨty, e ymɨnáangɨxɨpy co capxhuäcxy ajcxy Dios y'ayuc, e ca' yjánchɨty. Ytunɨp ajcxy mɨjhuinma'ñ etz mɨjpɨ ijxpejt, ixtɨ jëbɨ jahuin'ɨ́ɨngɨxɨp je mayjäy huɨdibɨ Dios tɨ yhuin'ixyii. Per ca' Dios a'ɨxɨ̈huɨpy co yhuin'ɨɨnɨɨyb yɨ' yjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tɨ ɨɨch yɨ' jayɨjpnɨ nigapxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","E co pɨnjaty ajcxy xyñɨmähuɨpy: “Chɨm je' je Cristo mɨjtɨgɨ̈dumb”, ca' ajcxy mninɨcxɨp. O co pɨnjaty ajcxy xyñɨmähuɨpy: “Chiiby je' tɨgoty yhuingoyüch”, ca' ajcxy mmɨbɨgɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ɨɨch je' je jäy huɨdibɨ tzoon tzajpjoty, nhuimbidaambɨch ya naaxhuiñ mɨɨd je tɨɨcxɨn je jájɨn, jadu'n nej je huɨdzuc huɨdi tɨɨcxp xɨɨbɨdzɨmyb ixtɨ xɨɨgɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma je öcp ninïcx yajpaady jɨm ñïmujctähua'ñ je luud ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Co anajty tɨ ñaxy je ayo'n xɨɨ ayo'n tiempo, huin'it je xɨɨ ycoodzɨygɨdäga'ñ, je po' ca' ytɨɨcxa'ñ, je madza' ycädähua'ñ etz janch mɨc je tzajp yücxa'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Co yɨ jadu'mbɨ ytunɨɨyb yjadɨɨyb, chi quëxɨ̈ga'ñ tzajpjoty je ijxpejt co ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nhuimbida'ñɨch ya naaxhuiñ. E chi tüg'ócɨy je mayjäy tájɨp máyɨp yjɨhuɨ̈huɨpy yäxɨpy, chi ajcxy ixɨpy je jäy huɨdi tzoon tzajpjoty miñ anajty jocjoty mɨɨd ymɨc'ajt y'oy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chi nguexɨpyɨch ángeles ajcxy co huen mɨc yajxüxy ajcxy ytrompeta, jɨgɨx yöymujctähuɨpy tüg'ócɨy pɨnjaty huin'ijxyp xɨ ya ma ajcxy yajpaady ya naaxhuiñ; ma xɨɨ pɨdzɨmyb, ma xɨɨ cɨdägy, ma jɨɨnboj pɨdzɨmyb, ma tɨchpoj pɨdzɨmyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jɨm miich ajcxy ijxpejt mbɨgɨpy ma je higuerɨ quipy jadu'n nej je xɨɨ tiempo ymiiñ cɨdägy. Co je higuerɨ quipy jadüg'oc pɨdägɨpy je' y'aay'ung, huin'it miich ajcxy nejhuɨ̈huɨpy co yhuingonɨ mɨna ypottɨgɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tɨm jadu'n nej tɨy'ajt mbɨjccɨxy ma je higuerɨ quipy co jada ajcxy jadu'n ixɨpy nejhuɨ̈huɨy co yhuingonɨ anajty je xɨɨ je tiempo jɨɨn'aguy tɨjc'aguy. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co tüg'ócɨy ytuna'ñyii yjada'ñyii ma ca'nɨ anajty je jäy y'öctäy huɨdibɨ anajty jactzɨnaayb huin'it tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Je tzajp etz je naaxhuiñybɨ cɨxam tɨgoyam yɨ', per ɨɨch n'ayuc ca' ycɨxa'ñ ytɨgoya'ñ nimɨna. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ca' ni pɨn nejhuɨ̈y je xɨɨ je hora mɨna nhuimbida'ñɨch ya naaxhuiñybɨ. Ni je ángeles ajcxy canejhuɨ̈y, ni je Dios y'ung canejhuɨ̈y. Tügpajc je Dios Teedy nejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Com jadu'n nej yjajtɨ ya naaxhuiñ jecy'ajty, co je Noé chɨnay, nañ tɨm jadu'n yjadɨpy co anajty nhuimbityɨch, yɨ jäy huɨdibɨ tzoon tzajpjoty, ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jecy'ajty co anajty ca'nɨ je ayo'nduu ymiiñ ya naaxhuiñybɨ, hue' je' mayjäy ajcxy chɨnay agujc jotcujc, ycaaygɨxy y'uuccɨxy etz yajpɨjccɨxy je y'ung y'anäg, ixtɨ coonɨ paty je xɨɨ tzuu co ytɨgɨɨy Noé barcojoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Je mayjäy ajcxy ca' ajcxy cuenttuñ co ayo'n miina'ñ anajty, ixtɨ coonɨ je ayo'nduu miin e öctay ajcxy je jäy nɨɨjoty. Jadu'n nej yjajty jecy'ajty mɨɨd je mayjäy huɨdibɨ tzɨnaayb anajty quipxy mɨɨd Noé, nañ tɨm jadu'n yjada'ñ mɨɨd je jäy ajcxy huɨdibɨ tzɨnähuɨp jac jiinɨ co ɨɨch anajty nhuimbityɨch ya naaxhuiñ jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Je huin'it tiempo co nhuimbidɨpyɨch jadüg'oc ya naaxhuiñ, chi metz yëydɨjc yajpaadɨpy ma ytundac, tüg je' yajmɨnɨcxa'ñ, e tüg je' yhuɨ'ma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","E mejtz töxyjäy yajpaadɨp anajty yjɨch, tüg je' yajmɨnɨcxa'ñ, e tüg je' yhuɨ'ma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","E paady miich ajcxy ni'ixɨ̈ íjtcɨx, xyjɨjp'ixɨpyɨch com ca' mnejhuɨɨygɨxy mɨna miich ajcxy je mHuindzɨn ymiina'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mnejhuɨɨygɨxy miich jada co ixyipy je ungdeedy nejhuɨ̈y ti hora je meetzpɨ miina'ñ, ca'p je' ymähuɨpy, e ca'p a'ɨ'xɨ̈huɨpy co je meetzpɨ ytɨgɨ̈huɨpy tɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nañ tɨm jadu'n miich ajcxy ni'ixɨ̈ ijtcɨx, je' co ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nhuimbida'ñɨch ma ca' ni pɨn anajty nejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Huɨdibɨ tumbɨ je' ya huɨdibɨ tumb mɨɨd yhuindzɨn janch cɨxyjot huinɨjot huɨdibɨ mɨɨd ixpɨjcɨn, huɨdibɨ je' yhuindzɨn mooyɨpy ane'mɨn ma ytɨjc, huɨdibɨ yajnigɨdagɨ̈huɨpy ma ymɨgügtɨjc caayɨn uucɨn mɨna ypadyii? ");
INSERT INTO mcoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Janch jotcujc je tumbɨ co yhuimbidɨpy je' yhuindzɨn, e je' cuyduñ jadu'n nej je' yhuindzɨn tɨ ñɨmäyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Janch tɨy'ajt jadu'n nej nɨmaaygɨxy co je huindzɨn ytumbɨ yajnigohuajc'adyii tüg'ócɨy huɨdibɨ ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pen je tumbɨ jɨbɨcjäybɨ mɨna'ñ jotjoty huinma'ñyjoty: “Huäcxɨjpnɨ ɨɨch je nhuindzɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E chi nïmajtztägɨp ymɨgügtɨjc, e ytɨgɨ̈huɨp caaybɨ uucpɨ mɨɨd amügyjäydɨjc; ");
INSERT INTO mcoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","chi je tumbɨ yhuindzɨn minɨpy ma ytɨjc huɨdi xɨɨ mɨna je tumbɨ ca' anajty aa'ixy jɨjp'ixy e ni je hora anajty canejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chi huindzɨn tzaachytunɨp je' ytumbɨ, etz ypɨdägɨpy mɨɨd je jacjadyii jäy ajcxy yajpaady huɨdibɨ naybɨdáacɨgɨxp nej tudägyjäyɨty e ca' yjanchɨty. Jiiby ayoodactuuby yjɨ̈hua'ñ yäxa'ñ etz huinmucxa'ñ huingueeda'ñ ytɨɨtz mɨɨd jotmay. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Co anajty nhuimbityɨch jadüg'oc ya naaxhuiñybɨ jadu'n nipaadɨp nej je nimajcpɨ töxy'anäg co ñɨcxy ajcxy ñayjɨjpcobadɨ̈huáanɨgɨxy mɨɨd je yëydɨjc huɨdi pɨgamb. Chi mɨnɨcxy ajcxy aceite lámpara co yajtɨcxaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Nimɨgoox je töxy'anäg huɨdi cohuinma'ñɨty etz ahuing mɨnɨcxy jadüg quiig ujtz mɨɨd aceite. E nimɨgoox je töxy'anäg ca'pɨ ajcxy cohuinma'ñɨty, e ca' ajcxy ahuing mɨnɨcxy jadüg quiig aceite. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","E je yëydɨjc huɨdibɨ anajty pɨgamb huäcxɨjpnɨ ooy, chi je töxy'anäg ajcxy ooy ytɨgɨɨyñɨ mä'uuybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","E mɨjcuctz ajcxy mɨdoy co tüg jäy mɨc mɨna'ñ: “Chi miiñ je yëydɨjc huɨdibɨ pɨgamb, nɨcx jɨjpcobadɨɨygɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","E huin'it je nimajcpɨ töxy'anäg ajcxy ypɨdɨ̈ctay. Chi ajcxy yjɨɨn ni'ixɨɨy nidüg nidüg. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chi je nimɨgooxpɨ huɨdibɨ ca' ycohuinma'ñɨty nɨmay je nimɨgooxpɨ huɨdibɨ cohuinma'ñɨp: “Ɨɨch ajcxy hueenɨ mooygɨch yɨ m'aceite, co pïdzaanɨp ɨɨch ajcxy njɨɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chi y'adzooy je cohuinma'ñybɨ ajcxy: “Ca' nyega'ñɨch, je' co ca' ɨɨch ajcxy nje' yhuaadɨ̈hua'ñ. Nɨcx miich ajcxy juy jɨm ma ytoogyii.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","E tɨ anajty ajcxy ñɨcxy aceite juuyb je huɨdibɨ ajcxy ca' ycohuinma'ñɨty, co oy yjäty je yëydɨjc huɨdibɨ pɨgaanɨp. Chi je cohuinma'ñybɨ ajcxy mɨɨd tɨgɨy tɨgoty je yëydɨjc huɨdibɨ pɨgaanɨp. Chi tɨjc yaj'agɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","E com jecyñɨ oy yhuimbity ajcxy je huɨdibɨ ca' ycohuinma'ñɨty. Chi ajcxy ymɨnañ: “¡Huindzɨn, Huindzɨn, ocyaj'ahuädz mdɨjc!” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Chi je' y'adzooy: “Ca' ɨɨch miich ajcxy n'ixy'adyii.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chi Jesús ymɨnañ: ―Nayñi'ixɨ́ɨyɨgɨx, je' co ca' mnejhuɨɨygɨxy mɨna ɨɨch nhuimbida'ñɨch jadüg'oc ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Co ɨɨch anajty nhuimbida'ñɨch jadüg'oc ya naaxhuiñybɨ, jadu'n nipaadɨp nej jadayaabɨ ijxpejt, co anajty tüg comeeñyjäy chona'ñ viajetumbɨ, chi je' ytumbɨ ajcxy mooy je meeñ co huen cuend'ajtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Je ymɨdügpɨ tumbɨ moy mɨgoox mil meeñ. Je mɨmetzpɨ moy mejtz mil. E je ymɨdugɨɨgpɨ moy tüg mil. E jadu'n ajcxy moy nije' nije' nej huaad cuend'ajtcɨxy. Chi choñ je huindzɨn viajetumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Je tumbɨ huɨdibɨ cɨ̈dɨgɨɨyɨ mɨgoox mil meeñ, ytɨgɨy ajuybɨ adoocpɨ. Chi je' ymeeñ y'ung'ajty jamɨgoox mil. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nañ jadu'n huɨdibɨ cɨ̈dɨgɨɨy mejtz mil, ytɨgɨɨy tumbɨ mɨɨd je meeñ. Chi je' ymeeñ y'ung'ajty ja mejtz mil. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Je huɨdibɨ cɨ̈dɨgɨɨy tüg mil hue' oy pɨdägy je meeñ tützjoty. Chi tajɨy, e yützɨ je yhuindzɨn ymeeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","E com jecyñɨ oy yhuimbity je huindzɨn. Chi ytɨgɨɨy cuenta yaj'oyɨɨyb mɨɨd je ytumbɨ ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chi miiñ jayɨjp je huɨdibɨ anajty tɨ cɨ̈dɨgɨ̈yii mɨgoox mil meeñ. Chi je tumbɨ yajcɨ̈dɨgɨɨy je' yhuindzɨn majc mil meeñ. Chi ymɨnañ: “Miich tɨ xymooyɨch mɨgoox mil meeñ, e ɨɨch tɨ nyaj'ung'atyɨch jamɨgoox mil.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chi je' yhuindzɨn mɨnaañ: “Janch jotcujc ɨɨch cham co jadu'n tɨ mduñ mɨɨd je hueenbɨ meeñ. Miich ooy mdudägy etz oy tɨ mduñ, e paady njacmöhuamyb jacmay. Tɨgɨ' ma ɨɨch, e xondäg mɨɨd ɨɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chi ymiñ je huɨdibɨ anajty tɨ cɨ̈dɨgɨ̈yii mejtz mil meeñ. Chi nɨmay je yhuindzɨn: “Miich xymooyɨch mejtz mil meeñ, e tɨ nyaj'ung'atyɨch jamejtz mil.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Huin'it je' yhuindzɨn ñɨmaayɨ: “Janch jotcujc ɨɨch cham, co jadu'n oy tɨ mduñ mɨɨd ɨɨch nmeeñ, e paady njacmöhuamy jacmay. Tɨgɨ' xondäg mɨɨd ɨɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","E co oy yja'ty je huɨdibɨ cɨ̈dɨgɨɨyb tüg mil meeñ, chi nɨmay je' yhuindzɨn: “Huindzɨn, hue' ndijyɨch miich myëydɨjc'aty janch jɨbɨc jäy. Miich cosecha myajpɨdɨ̈cpy ma ca' tɨ mnïpy etz miich mgosecha myajpɨdɨ̈cpy ma ca' ti tɨ mhuɨjy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Paady ooy ndzɨgɨ̈yɨch co je meeñ ngayaj'ung'adɨpyɨch. E co miich mhuimbida'ñ, mdzogamy je mmeeñ, e paady je mgɨ'mmeeñ tɨ nyüchɨch, je' co ndzɨgɨ̈yɨch co nɨcxy nyajtɨgooyɨch miich mmeeñ. Cha je meeñ huɨdibɨ tɨ xymooyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Chi je' yhuindzɨn ñɨmaayɨ: “Jɨbɨc tumbɨ miich, ooy mnuuxɨty. ¿Nej tɨ mnejhuɨ̈y miich co ɨɨch cosecha nyajpɨdɨ̈gyɨch ma ca' ti tɨ nnïbyɨch, etz cosecha nyajpɨdɨ̈gyɨch ma ca' ti tɨ nhuɨjyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Oy co ixyipy miich je ɨɨch nmeeñ tɨ myejc'anuucxy, e jɨm ixɨpy y'ung'at. E cham co tɨ nhuimbityɨch cham ixyipy je nmeeñɨch xycɨ̈dɨgɨ̈yɨch mɨɨd nimeeñ'ung.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chi je huindzɨn nɨmay je jacjadyii tumbɨdɨjc: “Pɨjcɨ ajcxy yɨ meeñ huɨdi ymɨɨd, e mooygɨx yɨ huɨdibɨ majc mil ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Je huɨdibɨ oy tumb jacyajmöhuamb je' anaxy, e ymɨɨd'adamy je' conaxpɨ. Je' huɨdibɨ hueen mɨɨd yajpɨgamb je' huɨdi ymɨɨd, je' co ca' oy tɨ ytuñ mɨɨd je hueenbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yɨ jiibɨ tumbɨ huɨdibɨ ca' oy ytuñ, pɨdäg ajcxy agootztuuby ma yjɨ̈huɨpy yäxɨpy, ma ytɨɨtz huinmuucx huingueedɨp mɨɨd jotmay.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Co ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nhuimbity ɨɨch anajty jadüg'oc ya naaxhuiñybɨ, huin'it n'ixtäga'ñɨch ma ɨɨch n'ane'mdac etz ane'ma'ñɨch mɨɨd ɨɨch nmɨj'ájtɨn etz n'oy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chi tüg'ócɨy je naaxhuiñyjäy yajtügmujctähua'ñ ma ɨɨch. Nhuäcxamybɨch jadüg jadüg jadu'n nej jäy ajcxy huäcxy je cöbixy etz je chiibo ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nbɨdägaamybɨch a'oy'amy je jäy ajcxy huɨdibɨ oy tɨ ytungɨxy mɨɨd ɨɨch. E yɨ' ajcxy jadu'n nipaadɨp nej cöbɨxy. Nbɨdägaamybɨch anajty'amy yɨ jäy ajcxy huɨdibɨ jɨbɨc tɨ ytungɨxy mɨɨd ɨɨch. E yɨ' ajcxy jadu'n nipaadɨp nej chiibɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chi nnɨmähuɨbɨch yɨ jäy ajcxy huɨdibɨ a'oy'amy: “Miingɨx miich ajcxy huɨdibɨ Dios Teedy tɨ xyconuucxy ajcxy. Je'ájtɨgɨx ane'mdac huɨdibɨ ijtp ni'ixɨ̈ mɨɨd miich ajcxy ycɨxpɨ maabɨ naaxhuiñybɨ chondägy. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ma anajty ɨɨch nyuubögyii miich ajcxy tɨ xyajcaayɨch; ma anajty ɨɨch ndɨdzɨ̈yii, miich ajcxy tɨ xyajnɨɨ'ügyɨch; ma anajty ɨɨch nihuɨdɨtyɨch, miich ajcxy jättac tɨ xymöyɨch; ");
INSERT INTO mcoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ma anajty ɨɨch je nhuit tɨ nyajmayjatyɨch, miich ajcxy tɨ xymöyɨch je huit; ma anajty ɨɨch nbɨgyiijɨch, miich ajcxy tɨ xycuend'átyɨch; etz co anajty ɨɨch pujxtɨgoty nyajpaady, miich ajcxy tɨ xycogapxɨ̈yɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Huin'it ymɨna'na'ñ je jäy ajcxy huɨdibɨ oy tɨ ytungɨxy mɨɨd ɨɨch: “Huindzɨn, ¿mɨna ɨɨch miich ajcxy tɨ n'ixy ayuu, e tɨ nyajcay? O ¿mɨna ɨɨch miich ajcxy tɨ n'ixy co mdɨdzɨ̈yii, e tɨ nyajnɨɨ'ügy? ");
INSERT INTO mcoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mɨna ɨɨch miich ajcxy tɨ n'ixy co miich mnihuɨdity, e tɨ nmöy jättac? O ¿mɨna mhuit tɨ myajmayjaty, e tɨ nmöy je mhuit? ");
INSERT INTO mcoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Mɨna ɨɨch miich ajcxy tɨ n'ixy, co miich mbɨgyii, e oy tɨ ngüend'aty? etz ¿mɨna ɨɨch miich ajcxy tɨ n'ixy co pujxtɨgoty myajpaady, e oy tɨ ngogapxɨ̈y?” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ɨɨch, je mɨj'ane'mbɨ, n'adzohuimbɨdɨpyɨch: “Janch tɨy'ajt jadu'n nej nnɨmaaygɨxy co yɨ jäy ajcxy huɨdibɨ oy tɨ ytungɨxy mɨɨd pɨnjaty huɨdibɨ xymɨjnɨcxpejtpɨch, nañ jadu'n oy tɨ ytungɨxy mɨɨd ɨɨch. Ca' ñéjɨty co jäy ajcxy ymɨnañ co ca' ypɨnɨty je jäy huɨdibɨ xymɨjnɨcxpejtpɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chi ɨɨch, je mɨj'ane'mbɨ, nɨmähuɨbɨch je jäy ajcxy huɨdibɨ yajpatp: “Huinhuäctuutcɨch miich ajcxy jɨbɨcjäydɨjc. Nɨcxy miich ajcxy mɨjjɨɨnjoty, huɨdibɨ ijtp ni'ixɨ̈ mɨɨd je mujcu' ycɨxpɨ etz mɨɨd je' y'ángeles ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ma anajty ɨɨch nyuubögyii, ca' miich ajcxy xyajcaayɨch; ma anajty ɨɨch ndɨdzɨ̈yii, ca' miich ajcxy xyajnɨɨ'ucyɨch; ");
INSERT INTO mcoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ma anajty nnihuɨdityɨch, ca' miich ajcxy xyajjättägyɨch; ma anajty ɨɨch nhuit xytɨgoy'íjtɨgɨch, ca' miich ajcxy huit xymooyɨch; etz ma anajty ɨɨch nbɨgyii e nyajpaadyɨch pujxtɨgoty, ca' miich ajcxy xycogapxɨɨyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","E chi je' ajcxy ymɨna'na'ñ: “Huindzɨn, ¿mɨna ɨɨch ajcxy miich tɨ n'ijxcɨxy co anajty miich yubögyii tɨdzɨ̈yii, o co anajty mnihuɨdity? ¿Mɨna tɨ n'ijxcɨxy co ca' mhuit mɨɨdɨty, o co mbɨgyii, o co anajty pujxtɨgoty myajpaady, e ca' ɨɨch ajcxy miich nbubejty?” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chi ɨɨch, je mɨj'ane'mbɨ, n'adzohua'ñɨch: “Janch tɨy'ajt jadu'n nej nnɨmaaygɨxy. Huen tɨm pɨnɨty huɨdibɨ ca' mɨɨdɨty pa'ayo'n mɨɨd je' ajcxy huɨdibɨ xymɨjnɨcxypejtpɨch, oy jäy yjamɨna'ñ co ca' ypɨnɨty, ɨɨch miich ajcxy anajty jadu'n tɨ xytuñɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","E jada ajcxy nɨcxɨp huinɨxɨɨ ayoodactuuby, e yɨ tudägypɨ ajcxy nɨcxɨp ma yɨ jugy'ajtɨn huinɨxɨɨbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Co Jesús nigapxtay tüg'ócɨy jadayaabɨ ayuc, chi nɨmay yɨ' ydiscípulos ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Miich ajcxy mnejhuɨɨyb co huɨxtɨc je amayxɨɨ, je pascua xɨɨ. Pascua xɨɨjoty ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nyajcɨ̈yega'ñɨch ma nmɨdzipɨch etz xyajcruutzpeda'ñɨch, xyaj'öga'ñɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Je huin'it xɨɨ je teedy huɨdibɨ tungmɨɨd ajcxy, je escribas, etz je mɨjjäydɨjc ajcxy ñayyöymujctayɨ ma je' ytɨba' je teedy huɨdi jacmɨjtungmɨɨd huɨdi anajty yxɨɨ Caifás. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","E jɨm ma Caifás ytɨba' jɨm ajcxy huinma'ñy'ixtay nej jëbɨ yajmachycägɨxy Jesús mɨɨd anɨɨ etz yaj'ögaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Chi ajcxy ñayñɨmaayɨ miñ xyɨpy: ―Ca' y'oyɨty co xɨɨjoty nmajtzɨm Jesús. Ca' jecyɨty co je mayjäy xymɨjotma'ttayɨm etz ytɨgɨ̈huɨp ajcxy huambɨ jɨhuɨɨybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús anajty yajpaady Betania ma Simón ytɨjc, je Simón huɨdibɨ anajty ymɨɨd je jɨbɨc nïbüdz pa'm. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","E ma anajty Jesús ycay, huin'it ymiiñ tüg töxyjäy mɨɨd tüg quiig ujtz mɨɨd perfume huɨdibɨ ooy oy yxuugy, jada perfume ooy anajty choohuɨty. Chi je töxyjäy yaj'ahuäch je quiig, e yajcöyogɨy Jesús je perfume huɨdibɨ ooy oy yxuugy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Co Jesús ydiscípulos ajcxy jadu'n ijxy, chi ajcxy mɨjotma'ty je töxyjäy. Chi ajcxy ñayñɨmaayɨ miñ xyɨpy: ―¿Ti co jada perfume huɨdibɨ ooy oy xuugy ayoy? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tzou ixyipy ooy jada yajtoocy, jaydëbɨ ixyipy mɨɨd yajpubet je ayoobɨtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E co Jesús nejhuɨɨy nej ajcxy ymɨnañ, chi nɨmay: ―¿Na'amy co m'amayɨ̈y jadayaabɨ töxyjäy? Yɨ' huɨdibɨ tɨ tuñ, je' yɨ' tüg oybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Je ayoobtɨjc ca' ytɨgoy'ida'ñ ma miich ajcxy nimɨna. Huen huɨdibɨ xɨɨ huen huɨdibɨ tiempo jëbɨ miich ajcxy mbubedɨpy ayoobtɨjc. Ɨɨch ca' n'ida'ñɨch jecy ya mɨɨd miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jada töxyjäy tɨ pɨdägy ma ɨɨch nninïcx perfume huɨdibɨ ooy oy xuugy, jayɨjp ca'nɨ nnaaxtɨgɨ̈yɨch. Jadu'n je' jɨjp'ijxpy mɨna nnaaxtɨgɨ̈hua'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","E huentɨmma'amyɨty je Dios y'ayuc anajty yajcapxhuäcxy huindu'my naaxhuiñ jɨm yajnigapxa'ñ jadu'n nej je töxyjäy tɨ tuñ cham mɨɨd ɨɨch, e jadu'n je mayjäy jäymedzɨpy jada töxyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chi nidüg je' ydiscípulos huɨdibɨ yxɨɨ Judas Iscariote oy nɨmäy je teedy mɨjtungmɨɨdpɨ, ");
INSERT INTO mcoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nɨmay ajcxy: ―¿Ti ajcxy xymöhuɨbɨch co ngɨ̈yegɨpyɨch Jesús? Chi ajcxy moy iipxmajc plata meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Co ajcxy meeñ ymooy, chi mɨc'amy Judas yhuinma'ñ'ixtay nej jëbɨ cɨ̈yecy Jesús ma ymɨdzip. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Je ymɨdügpɨ xɨɨ, je amayxɨɨ, je pascua xɨɨ ma anajty yajcay je tzajcaagy huɨdi ca' levadura mɨɨdɨty, huin'it je' ydiscípulos ajcxy nimiiñ Jesús. Chi ajcxy yajtɨɨy: ―¿Ma mdzocy co ɨɨch ajcxy ni'ixɨ̈huɨp huidi mgayamy je pascua xɨɨ cɨxpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chi Jesús y'adzooy: ―Nɨcx miich ajcxy jɨm Jerusalén ma tüg jäy ytɨjc, e mnɨmähuɨp: “Ɨɨch nHuindzɨn jadu'n mɨnamb co yhuingoñ je' yxɨɨ yhora, e paady ma miich mdɨjc yɨ' tuna'ñ je pascua xɨɨ adzu'ajtɨn mɨɨd ydiscípulos ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Huin'it Jesús ydiscípulos ajcxy cuyduñ jadu'n nej Jesús anajty tɨ ñɨmäyii. Chi ni'ixɨɨy ajcxy je pascua adzuu'ɨ̈bɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","E co chu'ɨɨy, chi Jesús y'ixtacy ma je mesa mɨɨd je nimajmetzpɨ ydiscípulos. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","E ma anajty ycaaygɨxy, huin'it nɨmay je nimajmetzpɨ: ―Nidügtɨ miich ajcxy huɨdibɨ xycɨ̈yegaambɨch ma nmɨdzipɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Huin'it ajcxy yjajtay taj may. Chi ajcxy yajtɨɨy: ―Huindzɨn, ¿nej ɨɨch jada'jɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chi Jesús y'adzooy: ―Yɨ huɨdi mɨɨd ndocxmucyɨch, yɨ' je' jadu'n xycɨ̈yegaambɨch ma nmɨdzipɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Janch tɨy'ajt co ɨɨch n'öga'ñɨch, jadu'n nej je profeta jaay jecy'ajty. ¡Ay ayoob je yëydɨjc huɨdi xycɨ̈yegaambɨch! Jac'oy co ca' ycama'xung'aty je huɨdibɨ xycɨ̈yegaambɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chi Judas ymɨnañ: ―Huindzɨn, ¿nej ɨɨch jada'jɨ? Chi Jesús y'adzooy: ―Miich jadu'n mɨnamb. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","E ma anajty ajcxy ycay, huin'it Jesús tzajcaagy conɨ̈gy. Chi yajnajxy Dioscojuyip. E chi jada' tujchuäcxy je tzajcaagy. Chi moy je nimajmetzpɨ ajcxy je tzajcaagy, e ymɨnañ: ―Cay miich ajcxy jadayaabɨ tzajcaagy, yɨ' je' ɨɨch je nninïcxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Huin'it Jesús cɨyɨ̈gy je y'ügy. Chi yajnajxy Dioscojuyip. E huin'it moy je ügy je nimajmetzpɨ ajcxy, e ymɨnañ: ―Üc miich ajcxy jadayaabɨ ügy, ");
INSERT INTO mcoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yɨ' je' ɨɨch je nnɨ'pyɨch. Yɨ' ñigapxy co Dios tɨ yaj'aducy je jemybɨ ayuc. E ɨɨch nnɨ'py ytema'ñ yoga'ñ mɨɨd je mayjäy ycɨxpɨ, jaydëbɨ ajcxy paadɨp je huinmeecxɨn mɨɨd je ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Janch tɨy'ajt jadu'n nej nnɨmaaygɨxy, co ca' n'oc'ügaanɨch jadüg'oc je pascua xɨɨ ügy, ixtɨ coonɨ je xɨɨ tiempo paadɨp co ɨɨch ajt n'uucɨm huinjemybɨ je pascua xɨɨ ügy ma ɨɨch nDeedy y'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","E co tɨ y'ɨɨdäy, chi ajcxy chooñ ñɨcxy ma Olivos cögop. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chi Jesús je' ydiscípulos ajcxy nɨmay: ―Nidüg'ócɨy miich ajcxy xy'ixmajtztähua'ñɨch cham coodz. Je' co jaaybejty jadu'n miiñ ma je Dios ñecy: “Ögɨp je cuend'ajtpɨ, huin'it je cöbixy yöyhuäcxtähua'ñ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","E co anajty ɨɨch njugypɨcyɨch jadüg'oc ma anajty tɨ n'ögyɨch, chi jayɨjpnɨ nnɨcxa'ñɨch ma Galilea, e jɨm naybaatɨm nidüg'ócɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chi Pedro ymɨnañ: ―Oy yɨ jacjadyiibɨ mɨgügtɨjcɨch xyjadɨm'ixmajtztäy, per ni camɨna xɨɨ ɨɨch miich n'ixmadzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chi Jesús Pedro nɨmay: ―Janch tɨy'ajt jadu'n nɨmäyɨch, cham coodz ca'nɨ anajty je tzey yaxɨ̈gy, miich tugɨɨg'oc mɨna'nɨp co ca' xy'ixy'adyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chi Pedro ymɨnañ: ―Oy ɨɨch ndɨm'ögɨp mɨɨd miich, ni camɨna ngamɨná'nɨbɨch co ca' miich n'ix'adyii. E nidüg'ócɨy je' ydiscípulos ac tɨm jadu'n ymɨnañ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chi Jesús ñɨcxy mɨɨd je' ydiscípulos ajcxy, oy yja'tcɨxy jɨm Getsemaní. Chi jɨm Jesús nɨmay je ydiscípulos ajcxy: ―Ya miich ajcxy oc'ɨña', miin ɨɨch n'ocnɨcxyɨch jɨm'amy Dios mɨbɨjctzoobɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","E chi Jesús ñɨcxy mɨɨd Pedro etz nañ jadu'n mɨɨd je Zebedeo ymang nimetzpɨ. E jɨm Jesús ñayjɨhuɨɨyɨ janch tajy may mɨj cajee. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","E chi jɨm yajnɨmay je nidugɨɨgpɨ discípulos: ―Nayjɨhuɨɨybɨch taj may ma njot nhuinma'ñ, ixtɨ mabaad anajty n'ögɨch mɨɨd tájɨn máyɨn. Huɨ'm miich ajcxy ya mɨɨd ɨɨch etz ca' mmaagɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Huin'it Jesús ñajtzyöyɨɨy mɨjcɨ'm jahuɨ'. Chi jɨm ñaygojxtɨnaydacɨ naaxcɨ́xy, e ytɨgɨɨy Dios mɨbɨjctzoobɨ, ymɨnañ: ―Dios Teedy, ɨɨch nDios, pen jëbɨ jadu'n, mduñ may'ajt pɨ́jcɨgɨch jadayaabɨ tzaachypɨ ayo'n, per ca' yjadu'nɨty nej ɨɨch ndzojcɨn mdunɨpy, jadu'n mdunɨpy janchtɨy nej miich mdzojcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Huin'it Jesús yhuimbijty jɨm ma anajty tɨ yajhuɨ'my je nidugɨɨgpɨ. E oy paady ac tɨm maab anajty ajcxy. Chi nɨmay je Pedro: ―¿Nej ca' madäga'ñ miich ajcxy co m'idɨpy juugy tüg hora mɨɨd ɨɨch ycɨxpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Huɨ'mɨ' ya, juugy m'idɨpy etz mɨbɨjctzoo Dios, jaydëb ca' je ca'oybɨ xymɨmadägɨp. Janch tɨy'ajt co jotjoty ooy mnijot'ajtcɨxy com tunaangɨxy yɨ oybɨ. Per yɨ mninïcx ca' ymadäga'ñ nɨcxy tuñ oybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chi mɨmetz'oc Jesús ñɨcxy oy Dios mɨbɨjctzoy, ymɨnañ: ―Dios Teedy, pen copɨcy co ɨɨch nbaadɨbɨch je ayo'n, huen jadu'n yjadɨɨyb mɨɨd ɨɨch nej miich mdzojcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chi jadüg'oc Jesús huimbijty ma je nidugɨɨgpɨ discípulos, e oy pátnɨbɨ maab ajcxy, je' co ca' anajty ajcxy mɨmadägy mähuɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chi yajhuɨ'my ajcxy, e mɨdugɨɨg'oc ñɨcxy Dios mɨbɨjctzoobɨ. E nañ tɨm jadu'n oy mɨnaanɨp jadu'n nej anajty tɨ y'ocmɨnamb. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chi jadüg'oc huimbijtnɨ jɨm ma je nidugɨɨgpɨ, chi nɨmay ajcxy: ―¿Máagɨxnɨ? Pócxcɨx jadachambɨ. Tɨ je tiempo yhuaad'ajtnɨ mɨna ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nyajcɨ̈yega'ñɨch ma yɨ jɨbɨcjäydɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pɨdɨ̈ccɨx, tzoc jámɨm, chi ymiiñ je huɨdibɨ xycɨ̈yegaambɨch ma nmɨdzipɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús capxnɨ anajty jɨm co yjäty je Judas. Judas hue' je' nidügtɨ je majmetzpɨ discípulos huɨdibɨ Jesús yhuin'ijx. E je Judas mɨɨd ja'ty mayjäy, je huɨdibɨ anajty tɨ quexy je judío teedy mɨjtungmɨɨdpɨ etz je mɨjjäydɨjc. E je mayjäy hue' anajty ajcxy mɨɨd ypujx etz quipy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, je huɨdibɨ anajty cɨ̈yejcp Jesús, tɨ anajty jayɨjp yecy tüg ijxpejt huɨdibɨ mɨɨd jëbɨ ajcxy ijxcapy Jesús. Jadu'n jayɨjp Judas ycapxtuñ mɨɨd je' ajcxy, e ymɨnañ: ―Je jäy huɨdibɨ anajty ndzücxypɨch, yɨ' je' Jesús. Májtzcɨx. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Huin'it Judas nimɨjhuägy Jesús co capxpocxa'ñ, chi ymɨnañ: ―¡Huindzɨn! Chi tzücxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Chi Jesús ñɨmayɨ: ―Mɨgüg, ¿na'amy co xyñimɨjhuägyɨch? E co jadu'n nɨmay, chi mɨc'amy yɨ' ajcxy majch Jesús. Chi ajcxy yajnɨcxy tzumy mach. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","E huin'it nidüg je Jesús ymɨgüg, juudy je ypujx. Chi tatzpujxtucy je teedy mɨjtungmɨɨdpɨ ytumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chi Jesús nɨmay je' ydiscípulo: ―Pɨdäg yɨ mbujx ma ytɨjc. Com pɨnjaty tziptumb mɨɨd pujx, nañ jadu'n y'ögɨpy mɨɨd pujx. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Nej ca' mnejhuɨ̈y co ɨɨch jëbɨ nbɨjctzooyɨch cham adzu'x may ángeles, je huɨdibɨ xyñihuá'nɨbɨch ma nmɨdzipɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Per nej ycɨxɨpy yca'pxɨpy nej miiñ jaaybety, jadu'n nej cham ytuñyii yjadyii mɨɨd ɨɨch ycɨxpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chi Jesús nɨmay je mayjäy: ―Miich ajcxy tɨ xyñidzonɨ̈yɨch mɨɨd je pujx mɨɨd je quiipy. ¿Nej mdijy ɨɨch meetzpɨ o jäy yaj'öcpɨch? Ɨɨch jabom jabom anajty ɨñäyɨch nyaj'ixpɨcyɨch miich ajcxy jiiby ma Dios ytɨjc. E ca' miich ajcxy xymajchɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Huinjɨhuɨ' miich ajcxy co tüg'ócɨy yam ytuñyii yjadyii ca'px tɨm jadu'n nej je profeta ajcxy cojaay jecy'ajty. Huin'it nidüg'ócɨy je' ydiscípulos ajcxy yqueectay. Chi Jesús yhuɨ'my naydügpajc. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Je' ajcxy huɨdibɨ anajty tɨ mach Jesús, yajnɨcx ajcxy jɨm ma Caifás ytɨjc. E jɨm ma Caifás ytɨjc ma anajty tɨ ñayyöymujctáayɨgɨxy je escribas etz je mɨjjäydɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","E je Pedro anajty axam nɨcxy jɨguëgy jɨhuɨ̈y, ixtɨ coonɨ yajja'ty ma Caifás ytɨba'. Chi jɨm ytɨgɨy. Chi ixtacy mɨɨd je cuend'ajtpɨ ajcxy, je' co oc'ixa'ñ ocnejhuɨ̈hua'ñ nej Jesús yjada'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Je teedy ajcxy mɨjtungmɨɨdpɨ etz tüg'ócɨy je judíojäy mɨjtungmɨɨdpɨ ajcxy huinma'ñ ixtaaygɨxy nej jëbɨ Jesús yajpocycägɨxy mɨɨd ajcxy xɨ̈huɨn, e jadu'n jëbɨ mooygɨxy yɨ o'cɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mayjäy nïhuambejty Jesús mɨɨd anɨɨ, per ni pɨn anajty ca' mɨɨdɨty tɨy'ajt co Jesús anajty tɨ ytundɨgooy mɨɨd judíojäy ajcxy ycötujcɨn. Jac com jecy miin metz testigos mɨɨd aanɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Je' ajcxy ymɨnañ: ―Jadayaabɨ yëydɨjc mɨnañ co jëbɨ nyajhuindɨgooyɨch Dios ymɨjtzajptɨjc, e codugɨɨg xɨɨ tɨ anajty nyaj'oyɨ̈yɨch jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Huin'it je teedy mɨjtungmɨɨdpɨ ytɨnayɨ̈gy, e nɨmay Jesús: ―¿Nej co ca' m'adzooy? ¿Nej janch tɨy'ajt nej jadayaabɨ metzpɨ testigo ymɨna'ñ? ");
INSERT INTO mcoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per Jesús ca' y'adzooy. E huin'it je teedy mɨjtungmɨɨdpɨ ñɨmaayɨ: ―Nɨmaayg ɨɨch ajcxy Dios ycɨxpɨ, pen janch miich je' je Cristo je Dios y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chi Jesús ymɨnañ: ―Miich jadu'n mɨnamb. Nañ jadu'n ɨɨch miich ajcxy nɨmäy, co ɨɨch je jäy huɨdibɨ tzoon tzajpjoty, miich ajcxy xy'ixɨpyɨch tzajpjoty ma Dios ymɨjc a'oy'amy. Nañ jadu'n miich ajcxy xy'ixɨpyɨch jocjoty co anajty nhuimbityɨch jadüg'oc ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chi je teedy jacmɨjtungmɨɨdpɨ oy yhuit huindzecxy huinma'ch, chi ymɨnañ: ―Jadayaabɨ yëydɨjc tɨ capxtɨgooy Dios. ¿Ti testigo njac-huaanɨm? Miich ajcxy cɨ'm tɨ mmɨdoogɨxy co yɨ' tɨ ycapxytɨgooy ma Dios, e minañ: ");
INSERT INTO mcoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nej miich ajcxy mɨnaangɨxy? Chi ajcxy ymɨnañ: ―Tɨ ycapxytigooy, copɨcy co y'ögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chi ajcxy huindzujy jɨjptzujy etz cojxy ajcxy. Chi jacjadyii huingojxy jɨjpcojxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","E chi ajcxy nɨmay: ―Pen janch co miich je' je Cristo octɨygapx pɨn tɨ xycoxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Je huin'it moñɨ Pedro anajty ɨñay tɨbägujc. Chi ñimiinɨ tüg töxy'anäg tumbɨ, chi ñɨmaayɨ: ―Miich nañ jadu'n tɨ mhuɨdity mɨɨd Jesús je Galilea jäy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Chi Pedro ymɨnañ mayjäyjoty: ―Ca' nhuinjɨhuɨ̈yɨch ti mgapxpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro hue' anajty pɨdzɨmnɨp co ñimiinɨ huingbɨ töxy'anäg. Chi je töxy'anäg nɨmay je' ymɨgügtɨjc: ―Jadayaabɨ yëydɨjc tɨ yhuɨdity nañ jadu'n mɨɨd Jesús je Nazaretpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chi Pedro jadüg'oc coyüch je Jesús cɨxyjot huinɨjot ymɨnañ: ―Ca' n'ixy'adyiijɨch yɨjiibɨ yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jac co hueenɨ, je jäy huɨdibɨ anajty ajcxy jɨmɨp ñɨmay ajcxy je Pedro: ―Janch co miich nañ jadu'n anajty mɨɨd mhuɨdity yɨ Jesús, com yɨ m'ayuc yɨ' xyajniquëxɨ̈cp. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chi Pedro tɨgɨɨy capxpɨ janch oy ñinej mɨnañ huinɨjot: ―Ca' n'ix'adyiijɨch yɨ yëydɨjc. E tɨm huin'ítɨy je tzey yaxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chi Pedro jäymejtzcoody jadu'n nej anajty Jesús tɨ ñimäyii: “Ma ca'nɨ anajty tzey yaxɨ̈gy cham coodz, miich tugɨɨg'oc xycoyützɨbɨch.” Chi Pedro pɨdzɨmy tɨba', e jiiby oy yäxy mɨbaad yjotcɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","E co oy yxɨɨmɨ̈y ytɨcxɨ̈y, chi je teedy mɨjtungmɨɨdpɨ etz je mɨjjäydɨjc ajcxy quipxycapxy co yaj'ögaangɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chi ajcxy yajnɨcxy cɨ̈xoch oy ajcxy cɨ̈yecy ma Poncio Pilato je gobernador. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Co je Judas je huɨdibɨ anajty tɨ cɨ̈yecy Jesús, co ijxy co yaj'ögaanɨp Jesús, chi oy yjotmaybaatnɨ. Chi conhuimbijty je iipxmajcpɨ plata meeñ ma je teedy mɨjtungmɨɨdpɨ etz mɨjjäydɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Chi Judas nɨmay je teedy mɨjtungmɨɨdpɨ etz je mɨjjäydɨjc ajcxy: ―Ɨɨch tɨ ndundɨgooyɨch co tɨ ngɨ̈yecyɨch yɨ tudägyjäy ma miich ajcxy. Chi je' ajcxy y'adzooy: ―Ti ɨɨch ajcxy n'occuent. Miich yɨ' mnïgɨxp tɨɨbɨ mduñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Huin'it Judas cohuɨjɨy je meeñ jiiby tzajtɨgoty. Chi ñɨcxy. Chi ñayyöctɨɨyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Huin'it je teedy mɨjtungmɨɨdpɨ yajpɨdɨ̈gy je meeñ. Chi ajcxy ñayñɨmaayɨ miñ xyɨpy: ―Jadayaabɨ meeñ ca' yjëbɨty co nbɨdaacɨm ma ofrenda ñigɨdägy. Je' co yɨ' yjëjɨty je huɨdi nɨ'py tɨ tzoo'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Huin'it je teedy ajcxy tuñ je quipxycapxy co juyaangɨxy mɨɨd je meeñ tüg naax huɨdibɨ jäy ytijp, tütznaax it, ma ajcxy yajnaxtɨgɨ̈huɨpy pɨnjaty ca' ycogajpɨty jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ixtɨ chambaad jadu'n xɨɨ'adyii jejɨmbɨ it: Nɨ'py naax. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","E jadu'n ycɨjx yca'px nej je profeta Jeremías ymɨnañ: “E jadu'n ajcxy je' yajpɨdɨ̈gy meeñ iipx majcpɨ plata meeñ (je' choou nej anajty ajcxy Israeljäy tɨ yajnigödugɨ̈y), ");
INSERT INTO mcoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","e mɨɨd je meeñ ajcxy juy je tütznaax it, jadu'n nej anajty tɨ xy'ane'myɨch Dios.” ");
INSERT INTO mcoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús yajpaady jɨm anajty ytɨnäy ma je gobernador Poncio Pilato yhuinduu, chi y'amɨdoohuɨ: ―¿Nej miich je' judíos jäy xyrey'ajtp? Chi Jesús y'adzooy: ―Miich jadu'n mɨnamb. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Je judío teedy ajcxy huɨdibɨ mɨjtungmɨɨdpɨ etz je mɨjjäydɨjc tzachxɨ̈gɨxy Jesús ma je gobernador. Ni jadu'ñyɨ Jesús ca' y'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chi je Pilato ñɨmay Jesús: ―¿Nej ca' mmɨdooy nej yɨ' ajcxy yxɨ̈yɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesús ni jadu'ñyɨ ca' y'adzooy. E paady je gobernador oy mɨj huinmay, ni ca' ocnejhuɨɨyñɨ ti ycapxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Je gobernador jadu'n anajty ycostumbre mɨɨdɨty co jɨmɨjt jɨmɨjt najtzmadzɨ̈y tüg machyjäy pascua xɨɨjoty, je huɨdibɨ je mayjäy tɨ ytɨmychojcpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E jɨm anajty tüg je machjäy huɨdibɨ anajty ajcxy ixy'ajttaayb, e yxɨɨjɨty Barrabás. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","E co anajty jɨm tɨ ytügmujctaaygɨxy, chi Pilato ajcxy y'amɨdooy: ―¿Pɨn miich ajcxy mdzojcpy co ɨɨch nnajtzmadzɨ̈huɨbɨchɨ? ¿Najtzmadzɨ̈yɨch Barrabás o Jesús huɨdibɨ jäy ajcxy ytijpy je Cristo? ");
INSERT INTO mcoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato ñejhuɨɨyb anajty co mañ'ájtɨngɨ́x anajty tɨ cɨ̈yejccɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jɨmnɨ anajty ɨñäy Pilato me je ycötujctac co je ytöxyɨjc tɨy'ajt quejxy ma yɨ', ymɨnañ: “Ca' huaad myajtzaachytuñ yɨ tudägyjäy. Je' co ɨɨch amygoodz tɨ ngumäyɨch janch jɨbɨc mɨɨd yɨ' ycɨxpɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per je teedy ajcxy etz je mɨjjäydɨjc tɨ anajty capxyjotcɨdaaccɨxy je mayjäy co huen yajnajtzmadzɨɨy Barrabás etz huen yaj'öccɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paady co jadüg'oc je gobernador y'amɨdooy je mayjäy: ―¿Huɨdibɨ machyjäy mdzojcpy co nnajtzmadzɨ̈huɨbɨch? Chi je mayjäy y'adzooy: ―Najtzmadzɨ' Barrabás. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chi Pilato y'amɨdooy je mayjäy: ―¿E nej ndunɨpyɨch yɨ Jesús, huɨdibɨ jäy ytijpy Cristo? Huin'it ajcxy nidüg'ócɨy y'adzoday: ―¡Yajcruutzpet yɨ Jesús! ");
INSERT INTO mcoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Chi Pilato ymɨnañ: ―Pues, ¿nej tɨ ytundɨgooy? Per je mayjäy nɨgoob y'adzoday: ―¡Yajcruutzpet! ¡Yajcruutzpet! ");
INSERT INTO mcoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato yjapubedaan Jesús, per co ijxy nejhuɨɨy co je mayjäy ca' ni nej niducy. Hue' ajcxy oy ytɨgɨɨy huambɨ jɨhuɨɨybɨ, chach ñayñajtztijɨɨygɨxy mɨɨd jot'an. Huin'it Pilato capxyñiguejxy je huädz nɨɨ. Chi ytɨgɨɨy cɨ̈bujp ma je mayjäy yhuinduu, e ymɨnañ: ―Ca' ɨɨch ngo'adzohuɨpyɨch jadayaabɨ tudägyyëydɨjc y'o'cɨn. Miich ajcxy yɨ' mgo'adzoohuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chi je mayjäy y'adzoday: ―Ɨɨch ajcxy ngo'adzohuɨpyɨch yɨ' y'o'cɨn mɨɨd n'ung anäg etz n'ap n'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chi Pilato najtzmadzɨy je Barrabás. Per Pilato ane'my co huen Jesús yajhuojp. E co yajhuojptay, chi cɨ̈yejcy, co huen yajcruutzpedyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chi Pilato ysoldados ajcxy yajnɨcxy Jesús ma agujctɨjc. E jiiby tüg'ócɨy soldadtɨjc ñayyöymujcɨ ma Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chi je soldado ajcxy je' yhuit yajnïjenducy. Chi ajcxy yajnïjenɨy je tzapx huit huɨdibɨ je rey ajcxy yajtuumyb. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chi ajcxy tacy tüg corona mɨɨd apy. Chi ajcxy yajcöjenɨy ma Jesús. E huin'it ajcxy a'oy'amy yajcɨ̈gabɨɨy tüg je paxy. Chi ajcxy huingojxtɨnay'ahuɨɨy. Chi ajcxy nɨxiicy yajxiicy, e ymɨnaangɨxy: ―¡Ooy ymɨjɨty yjanchɨty, je judíos ajcxy yrey! ");
INSERT INTO mcoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chi ajcxy huindzujy jɨjptzujy. Chi ajcxy yajcɨ̈gajptucy je paxy, e yajcöhuojpɨ̈gy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","E co ajcxy nɨxiictay yajxiictay, chi yajnïjenducy je rey yhuit etz yajnïjenɨy je ycɨ'm huit. Chi ajcxy yajnɨcxy ma yajcruutzpedaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","E jɨm ma anajty hueenɨ tɨ ytüyöy, jɨm tɨ paty tüg Cirene yëydɨjc anajty yxɨɨjɨty Simón. Chi ajcxy adzɨp nɨmay Simón co huen jaccapɨ Jesús ycruudz. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E co ajcxy yja'ty ma tüg je it yxɨɨjɨp Gólgota, jadu'n yhuimbɨdzɨm Öcpɨ Cohuajc Cögop. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","E jɨm ajcxy Jesús jayaj'üga'ñ vino temhuɨdity mɨɨd tzooy, jɨgɨx ca' jɨhuɨ̈huɨp je tzaachypɨ. Per co uucmajch, chi jɨhuɨ'ñybɨjc co ca' y'oy'uucnɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","E co anajty ajcxy yajcruutzpety Jesús, chi je soldadtɨjc suerte ijxy, pɨn jëbɨ ocjë'adyii Jesús yhuit, chi ycɨjxy yca'pxy jadu'n nej je profeta cojaay jecy'ajty: “Yajhuäcxɨpy ajcxy ɨɨch nhuit e mɨɨd ɨɨch nhuit ycɨxpɨ ixɨpy ajcxy suerte.” ");
INSERT INTO mcoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E jɨm anajty ajcxy ɨñaaygɨxy cuend'ajtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Je xɨ̈huɨn ayuc huɨdibɨ ajcxy yjaay ma Jesús ycöduu jadu'n ymɨnañ: “Jadayaabɨ je' Jesús, je judíos ajcxy je yrey.” ");
INSERT INTO mcoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Quipxy mɨɨd Jesús ajcxy yajcruutzpejty metz meetzpɨ. Tüg a'oy'amy, e jadüg anajty'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Je mayjäy huɨdibɨ ajcxy naxɨɨyb anajty ma Jesús, ooy anajty oy ycöjɨgɨñ, nɨxïgy yajxïgy ajcxy Jesús, ");
INSERT INTO mcoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ymɨna'ñ ajcxy: ―Bah, miich huɨdibɨ Dios ytɨjc jidaanɨp, e codugɨɨg xɨɨ huingbɨ myajpɨdɨ̈ga'ñ. Miich cɨ'm cham naygohuänɨɨ, e mɨnac cruudzcɨ́xy, pen janch miich Dios xy'ung'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nañ jadu'n je teedy ajcxy huɨdibɨ mɨjtungmɨɨdpɨ, etz je escribas, etz je fariseos ajcxy etz je mɨjjäydɨjc nɨxiicy yajxiicy ajcxy Jesús, ñayñɨmáayɨgɨxy miñ xyɨpy: ");
INSERT INTO mcoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Huingbɨ tɨ cohua'ñ, e ca' jaty nej cɨ'm ñaygohua'nɨɨyb. Pen janch co yɨ' jëjɨty je Cristo je Israel jäy rey, huen mɨnacy jadachambɨ ma cruudz, huin'it nmɨbɨjcɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yɨ' tɨ pɨdägy ymɨbɨjcɨn ma Dios; huen jadachambɨ je Dios yajnïdzögyii, pen janch Dios chogyii; yɨ' tɨ ymɨna'ñ co Dios y'ung'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nañ jadu'n je metzpɨ meetzpɨ ajcxy huɨdibɨ cruudzpejt quipxy mɨɨd Jesús nɨxiicy yajxiicy ajcxy ooy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Co ycujcxɨɨjɨɨy, chi ycoodzɨyday tüg'ócɨy naaxhuiñybɨ. E jadu'n je naaxhuiñybɨ y'ijty coodz, ixtɨ mɨnacy yxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huin'ítɨy Jesús ycapxyqueecy janch mɨc ymɨnañ: ―Elí, Elí, ¿lama sabactani? ―yɨ jadu'mbɨ ayuc hue' yhuimbɨdzɨmy: Dios Teedy, Dios Teedy, ¿ti co tɨ xy'ixmachɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nijëjɨty jäy huɨdibɨ anajty jɨm yajpatp huingon ma Jesús co jadu'n mɨdoogɨxy Jesús y'ayuc, chi ajcxy ymɨnañ: ―Jadayaabɨ yëydɨjc cham yaaxtaayb je profeta Elías. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Huin'it nidüg jäy ñɨcxy janch poyɨ̈gy etz oy yajtzooñ je pixy. Chi je pixy yajxoogy mɨɨd je xun vino. Chi pɨdacy je pixy ma je paxyjɨjp. Chi yujctijy ma Jesús y'ahuac co huen ügy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Huin'it nijëjɨty ajcxy ymɨnañ: ―Ixmatz, tzoc ajt oc'ijxɨm, pen nimiinɨp Elías, pen janch yajnïdzögyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jadüg'oc Jesús yaaxqueegy janch mɨc. Chi oy y'o'cnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Co Jesús y'o'cy, tɨm huin'ítɨy jɨm ma Dios ytɨjc je mapxy yhuit ycɨɨtzhua'cxy tɨnä'amy. E nañ jadu'n je naaxhuiñybɨ ooy chuyuy mɨɨd ujx mɨcpɨ etz je mɨjjatychaa oy jiitzhua'cxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","May öcpɨ jut y'ahuach etz yjugypɨjcy mayjäy tɨɨbɨ anajty y'o'ccɨxy tɨɨbɨ anajty mɨbɨjccɨxy Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Co Jesús yjugypɨjcy, chi je may'öcpɨ tɨɨbɨ anajty jugypɨjccɨxy etz tɨɨbɨ anajty pɨdzɨmgɨxy ma öcpɨ jut, chi ajcxy ytɨgɨɨy ma je Dios ycajp, je Jerusalén. E mayjäy ajcxy ijxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Co je mɨc ujx oy ñaxy etz jac tijaty anajty tɨ ytuñyii tɨ yjadyii, chi je capitán etz mɨɨd jadyii ymɨgügtɨjc huɨdibɨ anajty cuend'ajtp Jesús ooy ajcxy chɨgɨy yjɨhuɨy, e mɨnaangɨxy: ―Janch tɨy'ajt co yɨjiibɨ yëydɨjc Dios yɨ' anajty y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","May anajty nañ jadu'n töxyjäydɨjc ymɨj'ijxcɨxy jɨguem huɨdibɨ anajty ajcxy Jesús tɨ mɨɨddzoon jɨm Galilea. Yɨ' anajty ajcxy Jesús ypubejtp. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E ma je' ajcxy jɨm anajty chooñɨty, María Magdalena, María huɨdibɨ Jacobo etz José ytaj'ajtpy, etz je huɨdibɨ Zebedeo y'ung ytaj'ajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Co oy chuu'ɨɨyñɨ ycoodzɨɨyñɨ, huin'it chooñ ma Arimatea tüg comeeñyjäy huɨdibɨ yxɨɨ José. E je' ymɨjnɨcxpejty anajty Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Chi José ninɨcxy Pilato oy pɨjctzou Jesús ñinïcx. Huin'it Pilato pɨdacy y'ane'mɨn co huen möyii. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chi José ycɨ̈dɨgɨɨyɨ Jesús ñinïcx. Chi huinmojch mɨɨd tüg poob sábana. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Chi yajnaaxtɨgɨy ma je ycɨ'm jut jemybɨ huɨdibɨ anajty tɨ yajtzejtztüty tɨ yajpädüty ma tüg tzahuingueetz. Chi adɨguejctujcy je öcpɨ jut mɨɨd tüg tzaa. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chi José ñɨcxnɨ. E jɨm yhuɨ'my María Magdalena etz je jadügpɨ María, y'ɨñäy ajcxy ymɨhuingon öcpɨ jut. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","E com jabom ma anajty Jesús ɨxɨɨybɨ tɨ y'ögy, ma anajty tɨ ni'ixɨydäy mɨɨd je sábado xɨɨ ycɨxpɨ, chi je teedy ajcxy huɨdibɨ tungmɨɨd etz je fariseos ajcxy ñayyöymujcɨ ma je Pilato. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chi ajcxy ymɨnañ: ―Huindzɨn, yɨ' ɨɨch ajcxy njäymejchpyɨch co je anɨɨdacpɨ ymɨnañ ma anajty yjuugyɨty co codugɨɨg xɨɨ jugypɨga'ñ jadüg'oc co anajty tɨ y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E paady tunmay'ajt quexɨpy soldados ajcxy ma Jesús tɨ ñaaxtɨgɨ̈y huen cuend'ajtcɨxy ixtɨ coonɨ tugɨɨg xɨɨbɨ paadɨpy. Ca' yjecyɨty co ñiminɨɨb adzuum agoodz je' ajcxy huɨdibɨ mɨjnɨcxpejtɨp etz tzɨmguëgɨpy ajcxy Jesús ñinïcx. E chi nɨcxy jäy ymɨna'ñ: “Tɨ yjugypɨcy je öcpɨ.” Chi anajty jac'anaxy je anɨɨ tɨ yjajtnɨ ca'ydɨ je jayɨjpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chi Pilato ajcxy nɨmay: ―Miich ajcxy mɨɨd tüg pɨcy soldados huɨdib cuend'ajtp ma miich ajcxy. Nɨ́cxcɨx miich ajcxy yaj'adujccɨxy je öcpɨ jut, jadu'n nej m'a'ɨxɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chi ajcxy chonɨ ma je Pilato. Chi ajcxy quejxy je tüg pɨcypɨ soldados ma je öcpɨ jut. Chi ajcxy pɨdacy ijxhuɨ'mɨn ma je tzaa huɨdibɨ ajcxy je jut yaj'adɨguejctujcy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","E com jabom co yxɨmɨ̈y ytɨcxɨ̈gy je domingo xɨɨ, huin'it ñɨcxy María Magdalena etz je jadügpɨ María ma Jesús ñaaxtɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chi tüg mɨj ujx ñajxy. Huin'it ycɨdacy Dios tüg y'ángel huɨdibɨ tzomb tzajpjoty. Chi jɨdɨgejcy je tzaa ma je öcpɨ jut aguu. Chi y'ixtacy ma tzaa nïcx. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Janch adɨɨcxp je ángel anajty yhuinjɨjp jadu'n nej huɨdzuc, e je yhuit janch poob'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","E co je soldados ajcxy ijxpaty je ángel, chi ajcxy ooy chuyuygooty. Chi ajcxy yhuɨ'my jahuengɨ ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Huin'it je ángel y'adzooy je metz töxyjäy: ―Ca' miich ajcxy mdzɨgɨ̈y. Ɨɨch nejhuɨɨybɨch co miich ajcxy m'ixtäy Jesús je huɨdibɨ ajcxy yajcruudzpejty. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Per ca' je' cham ya. Tɨ je' yjugypɨcy, jadu'n nej ymɨnañ. Min miich ajcxy oc'ix ma ñaaxtɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɨcx miich ajcxy jottɨgooyb ma je' ydiscípulos ajcxy e nima': “Tɨ Jesús yjugypɨcy jadüg'oc, e yɨ' ñɨcxɨp jɨm Galilea e jɨm ajcxy mmɨɨdnaybadɨɨyb.” Ɨɨch miich ajcxy yam nnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Huin'it je töxyjäy ajcxy chooñ janch poyɨ̈gy ma anajty tɨ ñaaxtɨgɨ̈y Jesús. Chi ajcxy ñɨcxy mɨɨd tzɨgɨ'ñ, per agujc jotcujc. Poyɨ̈gy ajcxy oy tɨy'ajt yecy ma je discípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","E jɨm anajty je metzpɨ töxyjäy ytüyöy, tɨmetinɨ Jesús ñayguëxɨ̈cɨ ma je' ajcxy yhuinduu. Chi Jesús ajcxy capxpocxy. Chi je' ajcxy mɨhuingoñ Jesús etz mɨneenɨ je' ytecy. Chi ajcxy huindzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús mɨnañ: ―Ca' mdzɨgɨɨygɨxy. Nɨcx miich ajcxy nɨma' je nmɨgügtɨjcɨch co huen ajcxy nɨcxy jɨm Galilea, e jɨm naybadɨɨybɨch mɨɨd yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","E tüyöybñɨ anajty je töxyjäy nimetzpɨ co nijëjɨty je soldados ajcxy chooñ ma Jesús ñaaxtɨgɨɨy ñɨcxy jɨm Jerusalén, mɨɨdmɨydäga'ñ je teedy huɨdibɨ tungmɨɨdpɨ nej anajty tɨ ytuñyii tɨ yjadyii ma Jesús ñaaxtɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","E huin'it je teedy ajcxy ñayyöymujctayɨ mɨɨd je mɨjjäydɨjc, tunaangɨxy quipxy capxy. Huin'it je teedy ajcxy etz je mɨjjäydɨjc moy ajcxy je soldados may meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Chi ajcxy nɨmay: ―Miich ajcxy mɨna'nɨp co maab anajty miich ajcxy mɨjcoodz co ymiiñ Jesús ydiscípulos ajcxy etz tzɨmgueecɨ Jesús ñinïcx. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Etz pen ymɨdooyb anajty yɨ gobernador, ɨɨch ajcxy ngapxjotcɨdägɨch, jɨgɨx ca' nej xytúngɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","E huin'it ajcxy je soldados ycɨ̈dɨgɨɨyɨ je meeñ. Chi ajcxy ñɨcxy cuyduñ jadu'n nej anajty ajcxy tɨ ñɨmäyii. E ixtɨ chambaad jadu'n judíojäy capx je ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","E jadu'n ajcxy ñɨcxy je nimajctügpɨ Jesús ydiscípulos ajcxy jɨm Galilea. Chi ajcxy ñɨcxy ma je cögop jadu'n nej anajty Jesús tɨ ñɨmáayɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","E co ajcxy ijxpaty Jesús, chi ajcxy oy huindzɨgɨɨy. Per jɨm nijëjɨty huɨdibɨ ca' mɨbɨjcy co anajty yjëjɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Huin'it Jesús ymɨjhua'cy ma yɨ' ajcxy, e nɨmay: ―Ɨɨch tɨ nyajmöyɨch je cötujcɨn jiiby tzajpjoty etz ya naaxhuiñ. Ɨɨch tɨ nyajmöyɨch je mɨj cötujcɨn, jaydëbɨ n'ane'myɨch jiiby tzajpjoty etz ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","E paady nɨcx miich ajcxy huindu'my naaxhuiñ capxhuäcxcɨx je ayuc, jaydëbɨ jäy ajcxy xymɨbɨgɨpyɨch. Tüg'ócɨy jäy ajcxy huɨdibɨ xymɨbɨjcpɨch myajnɨɨbedɨpy ajcxy mɨɨd Dios yxɨɨ, Dios y'ung yxɨɨ, etz mɨɨd je Espíritu Santo yxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Miich ajcxy myaj'ixpɨgɨpy je mayjäy co copɨcy cuydunɨpy ajcxy ɨɨch ngötujcɨn tüg'ócɨy jadu'n nej tɨ n'ane'myɨch miich ajcxy. E miich ajcxy mnejhuɨɨyb co nmɨɨd'ityɨch miich ajcxy huinɨxɨɨ huinɨtiempo, ixtɨ mabaad naaxhuiñybɨ anajty ycɨxpɨ ytɨgooy. Jibaad ycɨxy. Amén.");
INSERT INTO mcoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jadu'n oga'ñ chondacy je oybɨ ayuc tɨy'ajt jadu'n nej Jesucristo, je Dios y'ung ytun etz yjajtɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Je Dios y'ayucnajtzcapxɨɨybɨ je Isaías jecy'ajty jayhuɨ'my jadu'n nej Dios nɨmay je Cristo: Nguexaamyɨch ɨɨch ngogapxy jayɨjp ma nidüg nidüg cajp ma miich mnɨcxa'ñ jac'axam, jɨgɨx jëb je cogapxy nɨmähuɨpy je jäy ajcxy co huen nayñi'ixɨ́ɨyɨgɨxy ma yjot yhuinma'ñ mɨɨd miich ycɨxpɨ, jadu'n nipaady nej jɨhuɨ̈y jäy ajcxy ni'ixɨ̈y tü'aa co tüg rey yjäda'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nañ jadu'n jadüg it Isaías jayhuɨ'my jada ayuc ma jadu'n ymɨnañ: Jɨm mɨjtɨgɨ̈duum jäy ajcxy mɨdoy co tüg jäy y'ayuccapxhuäcxy, jadu'n ymɨnañ: “Nayñi'ixɨɨyɨgɨx ma mjot mhuinma'ñ ajcxy jaydëb naybaatɨm mɨɨd ajt nHuindzɨn Dios. Ixmájtzcɨxy yɨ mjɨbɨcjot mjɨbic-huinma'ñ. Jadu'n nipaady nej jäy ajcxy yajtɨy tü'aa huɨdibɨ ooy y'adɨjy y'a'och.” ");
INSERT INTO mcoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jɨm mɨjtɨgɨ̈duum anajty Juan je Bautista miñ e ytɨgɨɨy mayjäy yajnɨɨbejtpɨ. Chi Juan capxhuäcxy Dios y'ayuc ma je mayjäy ajcxy huɨdibɨ anajty mimb nɨɨbejtp. Juan ayuc capxhuäcx co copɨcy co jäy ajcxy huen jothuimbíjtcɨxy etz ixmájtzcɨxy ajcxy je yjɨbɨchuinma'ñ, etz nɨɨbéjtcɨxy, jɨgɨx jëbɨ Dios yhuinmecxɨɨb ajcxy ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tüg'ócɨy je mayjäy ajcxy huɨdibɨ anajty tzɨnaayb jɨm Judea ñaaxjot etz jɨm Jerusalén mimb anajty ajcxy ma Juan, e y'amɨdoo'ijty anajty ajcxy je'y'ayuc. Co je jäy ajcxy capxpɨdzɨɨmy nej anajty ypocytúngɨxy, chi Juan yajnɨɨbejty ajcxy ma je Jordán mɨjnɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan hue' anajty yhuit'ajtpy camello nïbɨjc, e nañ jëyɨm anajty mɨɨd ñayhuɨɨñyii, e hue' anajty yjɨcx'ajtpy mu' etz uxpäg. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan ycapxhuäcxyp anajty Dios y'ayuc ma je mayjäy, e ymɨnañ: ―Ɨɨch jayɨjp tɨ nmiñɨch ngapxhuäcxy Dios y'ayuc. Jac'axam minɨpy tüg jäy huɨdibɨ jacnïgɨ mɨc'ajt mɨɨdɨty ca'ydɨ ɨɨch, ca' xypaadyɨch nɨcxy nguejyɨch yɨ' ycɨ̈ghuin. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɨɨch tɨ nyajnɨɨbetyɨch miich ajcxy mɨɨd nɨɨ. Per je jäy huɨdibɨ yjacmɨɨd Dios ymɨc'ajt, ca'ydɨ ɨɨch. Yɨ' xyaj'adɨgɨ̈huɨp xyajjotɨgɨ̈huɨp Dios yjɨhuɨ'ñ ymɨc'ajt, jadu'n nipaadɨp nej jɨhuɨ̈y xyajnɨɨbedɨp mɨɨd Dios yjɨhuɨ'ñ ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Je huin'it xɨɨ huin'it tiempo Jesús chooñ ma je cajp huɨdibɨ yxɨɨ Nazaret, jɨm Galilea ñaaxjot, e ymiñ ma Juan el Bautista anajty yajpaady. Huin'it xɨɨ Juan yajnɨɨbejty Jesús ma je Jordán mɨjnɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pɨdzɨmb anajty Jesús ma je mɨjnɨɨ, e tɨm huin'ítyɨ Jesús ijx co je tzajp anajty y'ahuäch, e ijx je Espíritu Santo chooñ tzajpjoty, e ycɨdägy ma yɨ'. Jadu'n je Espíritu Santo yquëxɨ̈gy anajty nej tüg muuxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chi Jesús mɨdooy capxy ayuc choñ tzajpjoty, nɨmäyii: ―Ɨɨch miich n'ung'ajtpy. Ooy ɨɨch miich ndzocy njɨhuɨ̈y. Ooy jotcujc nayjɨhuɨ̈yiijɨch mɨɨd miich. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Huin'it mɨc'amy je Espíritu Santo yajnɨcxy Jesús mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E hue' Jesús yhuɨ'mɨy jɨm mɨjtɨgɨ̈duum huixchɨguïpx xɨɨ ahua'n ɨyujc agujc. Huin'it je mujcu' jot'ijxy yhuinma'ñ'ijxy je Jesús. Chi je ángeles ajcxy miñ ypubejty ypudɨgɨɨy je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tɨ anajty Juan yajpɨdägy pujxtɨgoty, jac'axam Jesús ñɨcxy jɨm Galilea. Jɨm Galilea Jesús capxhuäcxy Dios y'ayuc etz yɨ Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús ymɨnañ: ―Tɨ je xɨɨ je tiempo yhuaad'ajtnɨ. Tɨ nigoody je xɨɨ je tiempo mɨna Dios pɨdäga'ñ yɨ' y'ané'mɨn ya naaxhuiñ. Jothuimbijtcɨx ajcxy, etz ixmajtzcɨx ajcxy mjɨbɨcjot mjɨbɨc-huinma'ñ. Mɨbɨjccɨx Dios y'ayuc jadu'n nej jëb ajcxy m'alma ñïdzögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús huɨdijtp anajty ma je mejypa' huɨdib yxɨɨ Galilea mejy, co oy'ijxpaady Simón etz y'uch Andrés. Simón etz Andrés acxmadzɨɨ anajty ytung'ajtpy, ytɨmpɨdacpy anajty y'acxmadzɨ'ñ mejyjoty co ajcxy Jesús ijxpaty. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chi Jesús nɨmay Simón etz Andrés: ―Min mɨɨd ɨɨch. Ɨɨch miich ajcxy huingbɨ tung nmöhuɨpy. Jadu'n mdung nipaadɨp nej jɨhuɨ̈y mjäymájtzcɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mɨc'amy Simón etz Andrés ajcxy ixmajch y'acxmadzɨ'ñ, e ñɨcxy ajcxy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chi Jesús yjacyöy anajty hueen, e ijxpaty Jacobo etz y'uch Juan, je Zebedeo ajcxy ymang. Je Jacobo etz Juan tumb anajty barcojoty. Hue' anajty ajcxy yaj'oyɨɨyb je' y'acxmadzɨ'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Chi Jesús mɨjhuooy ajcxy Jacobo etz Juan, e nɨmay co huen nɨcxy mɨɨd yɨ'. Mɨc'amy je' ajcxy ixmajch yteedy, je Zebedeo, barcojoty mɨɨd ytumbɨ, chi ajcxy ñɨcxy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Huin'it Jesús mɨɨd ymɨgügtɨjc yja'ty jɨm Capernaum. Je huin'it sábado, je poocxɨn xɨɨ, Jesús ytɨgɨɨy ma je judíojäy ajcxy ñaymujctac jɨm Capernaum, chi yjäyyaj'ixpɨjctzondacy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Je mayjäy ooy ajcxy jɨhuɨy huinmay je ayuc huɨdibɨ Jesús anajty ajcxy yaj'ixpɨ́jcɨp. Com Jesús hue' anajty yaj'ixpɨcy jadu'n nej jɨhuɨ̈y ycɨ'm'ané'mɨn mɨɨdɨty. Ca' Jesús anajty yaj'ixpɨcy jadu'n nej je jäy ajcxy huɨdibɨ yaj'ixpɨjcp anajty Moisés ycötújcɨn je jécyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","E ma je naymujctac tüg yëydɨjc huɨdibɨ mɨɨd anajty ca'oybɨ. Chi je ca'oybɨ ooy mɨc ycapxcoody, e ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Ti co xy'amayɨ̈y ɨɨch ajcxy, Jesús huɨdibɨ tzomb jɨm Nazaret? ¿Nej tɨ mmiñ co xyajhuindɨgoyáangɨxyɨchɨ? Ɨɨch n'ijxcajpy miich, e nejhuɨɨybɨch co miich je' je Huätzpɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chi Jesús ix'ojy je ca'oybɨ, e nɨmay: ―Amon miich, e pɨdzɨmb ma jada yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Huin'it je ca'oybɨ yajyajch yajquïdy je yëydɨjc, e mɨc yaaxqueegy, e ypɨdzɨmy ma je yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tüg'ócɨy je mayjäy jiiby ma je naymujctac ooy ajcxy ñay'adzɨgɨɨyɨ, e ñayñɨmaayɨ ajcxy miñ xyɨpy: ―¿Ti jada' yɨ'? Jada yëydɨjc ymɨɨd jemybɨ ixpɨ́jcɨn. Yɨ' mɨɨd mɨc'ajt etz ane'm'ajt, paady ycɨxpɨ yɨ' ane'my yɨ ca'oybɨ, e ycapxmɨdoohuɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mɨc'amy je mayjäy ajcxy huɨdijaty tzɨnaayb ma tüg tüg cajp jɨm Galilea nejhuɨy ajcxy nej Jesús ytuñ, e cömaaygɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tɨm huin'ítɨy Jesús ypɨdzɨmy ma je naymujctac, chi ñɨcxy mɨɨd Jacobo etz Juan jɨm ma Simón etz Andrés ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón ymɨ̈d töxyjäybɨ pɨ́jcɨp anajty. Cɨjx'am anajty y'ity, e mɨc anajty ooy ytoyii. Tɨm huin'ítɨyɨ Jesús ñɨmaayɨ co Simón ymɨ̈d ooy mɨc ypɨgyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chi Jesús nimɨjhuägy je pa'mjäy. Chi majtzɨ ycɨ', e huijtzɨ̈gy. Tɨm huin'ítɨy yɨ toyɨɨ y'ixmajtzɨ, e chi yajcay yaj'uucy Jesús etz ymɨgügtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Co xɨɨ oy ycɨdacnɨ, e chuu'ɨɨyñɨ, chi je mayjäy mɨɨd miñ ajcxy ma Jesús tüg'ócɨy pa'mjäydɨjc, etz huɨdijaty ajcxy ca'oybɨ ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tüg'ócɨy je mayjäy ajcxy ma je jɨmbɨ mɨj cajp nimujcy je tɨjc ma Jesús anajty tɨ yjättägy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús yajtzooctay tüg'ócɨy je may pa'mjäy huenytɨmytiibá'mɨty, etz yajpɨdzɨmy may ca'oybɨ majaty jäy ajcxy. Per Jesús ca' anajty a'ɨxɨ̈y nɨcxy je ca'oybɨ ñigapxyii, com y'ixy'ajttaayb anajty ajcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tɨm mooñɨ Jesús ymaybɨdɨ̈gy, ca' anajty yxɨɨmɨɨyñɨ, e ypɨdzɨmy ma je cajp. Chi ñɨcxy ma tüg mɨjtɨgɨ̈duum Dios mɨbɨjctzoobɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Huin'it je Simón etz je ymɨgügtɨjc ooy ajcxy ja'ijxtäy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Co ajcxy paty je Jesús, chi ajcxy nɨmay: ―Tüg'ócɨy je mayjäy xyjadɨm'ixtäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chi Jesús nɨmay Simón etz je ymɨgügtɨjc ajcxy: ―Tzoc ajt jámɨm ma yɨ jacjadyii cajp huinduy agonbɨ, jaydëb ngapxhuäcxɨbɨch Dios y'ayuc nañ jadu'n ma yɨ jäy ajcxy jɨm. Paady ycɨxpɨ ndzooñɨch tzajpjoty, jɨgɨx jëbɨ ngapxhuäcxɨbɨch Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús nɨcxp anajty ma nidüg nidüg cajp jɨm Galilea ycapxhuäcx anajty Dios y'ayuc ma nidüg nidüg judíojäy ñaymujctac, e yajpɨdzɨmy anajty ca'oybɨ majaty jäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tüg jäy huɨdibɨ ymɨɨd anajty jɨbɨc pützpa'm, je mɨcpɨ, chi nimɨjhuägy Jesús, e ycojxtɨnay'ahuɨɨy ma Jesús yhuinduu, ymɨnañ: ―Pen miich jadu'n tzojcpy, jëb xyajtzögɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chi Jesús pa'ayoy je pa'mjäy, e pɨdacy ycɨ' ma je pa'mjäy ñinïcx, e ymɨnañ: ―Ndzojcpyɨch, cham nyajtzögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Co Jesús jadu'n ymɨnañ, chi mɨc'amy je jäy huɨdibɨ anajty mɨɨd je jɨbɨc püdz chögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Mɨc'amy Jesús ycapxcɨ́jxy mɨɨd je jäy huɨdibɨ anajty tɨ chögy, e nɨmay: ―Ix pɨn myajnɨmäy co tɨ mdzögy. Nɨcx jayɨjp jiiby ma Dios ytɨjc ma je judío teedy ajcxy, e mo' Dios yhuindzɨgɨ'ñ jadu'n nej Moisés ycötújcɨn ane'my, jɨgɨx jëbɨ huädz mbɨdzɨmɨpy ma Dios ycötújcɨn. Cuydun miich huɨdibɨ Moisés ñajtz'ane'mɨɨy jecy'ajty, jɨgɨx jëbɨ je mayjäy ajcxy nejhuɨ̈huɨp co tɨ mdzögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per je yëydɨjc ca' capxymɨdoy Jesús. Co ñɨcxy, chi ytɨgɨɨy capxy yajyöybɨ jadu'n nej anajty tɨ yajtzögyii. Com je mayjäy nejhuɨɨyb huɨdibɨ anajty Jesús tɨ tuñ, paady ycɨxpɨ Jesús ca' anajty ocjajtnɨ nej ytɨgɨ̈huɨpy ijxna' jɨgue'xna' majaty cajp. Hue' anajty huɨdity ma ca' pɨn chɨnäy. Per miñ anajty y'oy'ixyii huenytɨmypɨnjäyɨty, chooñ ma nidüg'ócɨy cajp huinduy agonbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tɨ anajty xɨɨ tiempo ñajtznïnɨcxɨɨyñɨ co Jesús yhuimbijty jadüg'oc jɨm Capernaum. Je mayjäy ñejhuɨɨyb anajty co Jesús yajpaady ma tüg tɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chi mɨc'amy mayjäy ñayyöymujcɨ ma anajty Jesús yajpaady, e ca' anajty tɨgɨydac ma je tɨjc, mɨɨd co tzach mayjäy anajty tɨ miingɨxy. Y'adujctaayb anajty ajcxy je tɨjc'aguu. E Jesús ycapxhua'xyp anajty Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Huin'it xɨɨ, mɨdaax yëydɨjc cɨymiñ cɨjx'am ma Jesús yajpaady tüg pa'mjäy huɨdibɨ ycɨ' ytecy tɨ yxujxtäy anajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","E com ca' anajty ni nej y'oyɨ̈y nej yajjädɨp ajcxy ma Jesús je pa'mjäy, je' co anajty chach újtzɨty je tɨjc mɨɨd je mayjäy, chi ajcxy yajcöhuaach hueenɨ je tɨjcnïcx ma anajty Jesús yajpaady. Chi ajcxy cödɨyñajxy je pa'mjäy cɨjx'am. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Co Jesús ijxy je jäy ajcxy ymɨbɨ́jcɨn, chi nɨmay je pa'mjäy: ―Mɨgügɨch, yɨ mbocy tɨ yajhuinmecxtäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per nijëjɨty huindzɨndɨjc huɨdibɨ ajcxy nïjaydutp anajty Dios ñecy co ajcxy mɨdoy nej Jesús ymɨna'ñ, chi ajcxy ymɨna'ñ jotjoty huinma'ñyjoty: ");
INSERT INTO mcoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nej co jada jäy jadu'n ymɨna'ñ co tɨ yajhuinmecxy jada pa'mjäy ypocy? Capxtɨgooyb yɨ' mɨɨd Dios. Com ca' nipɨnjäy jëb ypocyhuinmecxy. Tügpajc Dios yɨ' huɨdibɨ jëb ypocyhuinmecxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per Jesús ñejhuɨɨyb anajty nej je' ajcxy chachmɨna'ñ jotjoty huinma'ñyjoty, paady mɨc'amy ymɨnañ: ―¿Na'amy co mdzachhuinmaaygɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Huɨdibɨ jada jac'ooy co nnɨmäyɨch yɨ pa'mjäy: “Tɨ mbocy yajhuinmecxytäyɨ.” O jac'ooy co nnɨmähuɨbɨch: “Pɨdɨ̈g, e yajpɨdɨ̈g yɨ mdögy, e tüyöy?” Tú'cɨy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Chi Jesús yjacmɨnañ: ―Jadachambɨ janchtɨy nyajquëxɨ̈ga'ñɨch co ɨɨch, je jäy huɨdib tzoon tzajpjoty, e huɨdibɨ cham yajpaady ya naaxhuiñ, nmɨɨdɨch mɨc'ajt jaydëb nhuinmecxyɨch jäy ypocy. Co Jesús jadu'n ymɨnañ, chi nɨmay je pa'mjäy huɨdibɨ ycɨ' ytecy anajty xuxy: ");
INSERT INTO mcoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ɨɨch miich yam jadu'n nɨmäy: “Tɨnayɨ̈g, yajpɨdɨ̈g yɨ mmabejt e nɨcx ma mdɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","E mɨc'amy je pa'mjäy ypɨdɨ̈gy, e yajpɨdɨ̈gy ymabejt, chi ytüyöychoñ jiiby ma je mayjäy ajcxy anajty y'ixy yhuindɨcxy. Paady ycɨxpɨ tüg'ócɨy je mayjäy ooy jɨhuɨy huinmay etz jäymejch ojadajty ajcxy Dios, ymɨnaangɨxy: ―Nimɨnaabɨ ajt jadu'n nga'íjxɨm mɨjhuinma'ñ jadu'n nej cham tɨ n'íjxɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chi jadüg'oc Jesús ycajppɨdzɨmy, ñɨcxy jɨm ma mejypa'. E co mayjäy ñayöymujcy jɨm ma Jesús anajty yajpaady, chi Jesús yaj'ixpɨjc je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Co Jesús yjactüyöy anajty, chi ijxpaady Leví je Alfeo ymang. E Leví ɨñaayb anajty ma je yajcogüejttac jäy yajcogüejtp anajty. Chi Jesús nɨmay Leví: ―Pajamgɨch. Tɨm huin'ítɨy Leví ytɨnayɨ̈gy, ixmajch ytung, e panɨcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jadu'n yjajtɨ co tüg xɨɨ Jesús caayb anajty me Leví ytɨjc. Mayjäy huɨdibɨ ytung'ajtpy anajty yajcogüedɨɨ, etz jacjadyii jäy huɨdibɨ anajty tundɨgooyb mɨɨd judío jäy ycostumbre y'ɨñaaygɨxy ma je caydac quipxy mɨɨd Jesús etz je' ydiscípulos ajcxy. Com may jäy anajty ooy Jesús tzach mɨɨd huɨdíjtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jɨm anajty ma Leví ytɨjc nijëjɨty fariseojäy, je huindzɨndɨjc huɨdibɨ tzach padumb judíojäy ycostumbre. E co je' ajcxy ijxy co Jesús caayb uucp anajty tügmucy mɨɨd tüg'ócɨy je mayjäy ajcxy huɨdibɨ tundɨgooyb mɨɨd judíojäy ytɨy'ajt ycötújcɨn, etz yajcogüejtpɨdɨjc, chi ajcxy mɨgapxy Jesús ydiscípulos, je' ajcxy huɨdibɨ mɨjnɨcxpejtp anajty Jesús, nɨmay ajcxy: ―¿Nej co Jesús miich ajcxy mHuindzɨn ycaymucy y'ucmucy mɨɨd yɨ yajcogüejtpɨdɨjc ajcxy, etz jacjadyii jäy ajcxy huɨdibɨ tundɨgooyb mɨɨd judíojäy ycötújcɨn? ");
INSERT INTO mcoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Co Jesús jadu'n mɨdoy nej je fariseo jäy nigapxyii, chi ajcxy nɨmay: ―Ca' tzocy tzoydumbɨ yɨ jäy ajcxy huɨdibɨ mɨc'ajtp oy'ajtp. Yɨ' janchtɨy yɨ huɨdibɨ ajcxy yuuba'm ymɨɨd chojcpy ajcxy tzoydumbɨ. Nañ tɨm jadu'n yɨ jäy ajcxy huɨdibɨ ca' ypocymɨɨdɨty, ca' ajcxy tzocy pocyhuinmeecxɨn. Ɨɨch tɨ nmiñɨch co nyajjothuimbidɨpyɨch pocyjäydɨjc. Ɨɨch ca' tɨ nmiñɨch co nyajjothuimbidɨpyɨch oyjäydɨjc tudägyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jadu'n yjajtɨ tüg tiempo ayuu'ijtp anajty je jäy ajcxy huɨdibɨ mɨjnɨcxpejtp anajty Juan je Bautista. Nañ jadu'n ayuu'ajtp anajty je fariseojäy ajcxy. Chi nijëjɨty ajcxy ymiñ ma Jesús e amɨdoy: ―¿Nej co yɨ jäy ajcxy huɨdibɨ mɨjnɨcxpejtp ajcxy Juan etz nañ jadu'n yɨ fariseojäy ajcxy ayuu'ajtp ajcxy, e je jäy ajcxy huɨdib miich xymɨjnɨcxpejtp, ca' y'ayuu'ájtcɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chi Jesús y'adzooy: ―Co ya nyajpaadyɨch ya naaxhuiñ, ca' ycopɨ́cɨty co ɨɨch ndiscípulos ajcxy y'ayuu'adɨp. Jadu'n nipaady nej jäy ajcxy huɨdibɨ pɨ́jcɨn nixɨɨdumy ca' ajcxy y'ayuu'aty ma yam yɨ pɨ́jcɨn nixɨɨduñ, e penɨ ca'nɨ je pɨjcpɨ ymɨgügtɨjc y'ixmajtztäyii. Namɨ je pɨjcpɨ ca'nɨ choñ, chi ca' pɨn y'ayuu'ada'ñ huɨdibɨ nixɨɨdum je pɨ́jcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","E paadɨp je xɨɨ je tiempo mɨna ca' nmɨɨd'ida'ñɨch ya naaxhuiñ yɨ' huɨdibɨ ajcxy xymɨjnɨcxpejtpɨch, e huin'it ajcxy y'ayuu'adaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Com jemybɨ Dios y'ayuc nyaj'ixpɨcpyɨch, paady ca' ytügɨ̈y mɨɨd je jécyɨp ayuc huɨdibɨ je fariseo jäy ajcxy yaj'ixpɨjcpy. Jadu'n nej miich ajcxy mnejhuɨ̈y co ni pɨn ca' agɨyɨ̈y tuc huit mɨɨd tüg pedaas jemy huit, con je' co je jemy huit nɨɨmujcp je', e chi nïgɨ najtzcɨɨdzɨ̈huɨp je tuc huit. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","E nañ ni pɨn ca' jëb huaad pɨdägy jemy vino ma tuc cochac. Je' co je vino jemybɨ ycɨɨdzamy je tuc cochac, e chi y'ixyojctähuɨp je vino etz je cochac ñitɨgoydähuɨp. Hue' janchtɨy jëb ajcxy pɨdacy jemy vino ma jemy cochac. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tüg sábado xɨɨ Jesús mɨɨd ydiscípulos ajcxy ñaxɨɨy ma tüg trigo cam. E huin'ítɨyɨ je ydiscípulos ajcxy ytɨgɨɨy je trigo tujcp. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Co je fariseo jäy ajcxy ijxy jadu'n nej Jesús ydiscípulos ajcxy anajty tujcmujc trigo tɨɨm, chi ajcxy nɨmay Jesús: ―Ix miich. ¿Na'amy co miich mdiscípulos túngɨxy huɨdibɨ judío ycötújcɨn capx'adujcpy sábado xɨɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Per Jesús ymɨnañ: ―¿Nej ca'miich ajcxy mguendtuñ Dios y'ayuc co mnecycapxy, jadu'n nej David ytuñ tügtecy jecy'ajty, co David etz ymɨgügtɨjc yuu'ögaangɨxy anajty? ");
INSERT INTO mcoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Je huin'it tiempo jecy'ajty co je judío teedy Abiatar mɨjtungmɨɨdpɨ anajty ma Dios ytɨjc, chi David ytɨgɨy ma Dios ytɨjc, e caay je tzajcaagy huɨdibɨ tɨ anajty yoxy ma Dios yhuinduu. Dios ycötújcɨn ymɨnañ co je teedy ajcxy ycaagy'ajtpy jada tzajcaagy, ca' jac'ooyñipɨn. Nañ jadu'n David moy je tzajcaagy je jäy huɨdib anajty ajcxy ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nañ jadu'n Jesús yjacmɨnañ: ―Ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nmɨɨdɨch ané'mɨn, jaydëb nɨmäyɨch je jäy ajcxy ti jëb túngɨxy sábado xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Com Dios tɨ ixmach je sábado xɨɨ, paady ycɨxpɨ, ɨɨch je jäy huɨdibɨ tzoon tzajpjoty, nmɨɨdɨch ané'mɨn jaydëb nɨmayɨch jäy ajcxy co jëb tijaty tuñ sábado xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús ytɨgɨy jadüg'oc ma je judío naymujctac. Jiiby anajty tüg yëydɨjc huɨdibɨ anajty ymɨɨd tüg ycɨ' tɨ̈tz. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Je fariseojäy jiiby ma je naymujctac y'ijx'ijtpy anajty Jesús, co anajty nejhuɨ̈hua'ñ pen Jesús yajtzögamy je pa'mjäy sábado xɨɨ, jɨgɨx jëbɨ ajcxy xɨ̈huɨp Jesús co tɨ ytundɨgoy mɨɨd judíojäy ycötújcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús nɨmay je jäy huɨdibɨ mɨɨd tüg ycɨ' tɨ̈tz: ―Pɨdɨ̈g, min ya ma ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Huin'it Jesús y'amɨdoy je jäy ajcxy e nɨmay: ―¿Nej miich ajcxy mɨnaangɨxy: Nej jëbɨ jada nduñɨch je oybɨ o je jɨbɨcpɨ sábado xɨɨjoty? ¿Jëbɨ nyajtzögɨch jäy o jëbɨ nyajtɨgoyɨch jugy'ájtɨn? Per je jäy amoñ ajcxy ijty, ca' ajcxy je' y'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Huin'it Jesús huindɨcxpejty je jäy ajcxy mɨɨd chip y'ahua'n, e mɨɨd jotmay, je' co ooy ajcxy jotjuuñɨty, e chi nɨmay je yëydɨjc: ―Xajtɨu yɨ mgɨ'. Chi je yëydɨjc xajtɨy ycɨ', e chi ycɨ' oy chögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chi je fariseojäy ypɨdzɨmday ma je naymujctac, ooy yjotmädy ajcxy, e ñɨcxy ajcxy ñaymújcɨp mɨɨd je jadügpɨcy judío huindzɨndɨjc huɨdibɨ ymɨjnɨcxpejt je rey Herodes. Huinma'ñ ixtaayb anajty ajcxy nej jëb ocyaj'ögɨp Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Per Jesús chooñ mɨɨd yɨ' ydiscípulos ajcxy, ñɨcxy ma mejypa'. E ooy mayjäy huɨdibɨ ajcxy tzomb Galilea ñaaxjot etz Judea ñaaxjot panɨcxy ajcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nañ jadu'n mayjäy panɨcx ajcxy Jesús huɨdibɨ ajcxy tzomb jɨm Jerusalén, huɨdibɨ ajcxy tzomb jɨm Idumea ñaaxjot, huɨdibɨ ajcxy tzomb jɨm Jordán mɨjnɨɨ nïnaxy ma xɨɨ ypɨdzɨmyb, huɨdibɨ ajcxy tzomb jɨm Tiro etz Sidón ñaaxjot. Ñɨcxtäy je mayjäy ma Jesús yajpaady, com ñejhuɨɨyb anajty ajcxy je mɨjhuinma'ñ huɨdibɨ Jesús anajty ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Com tzach mayjäy anajty ymiingɨxy, paady Jesús ni'ane'mdɨy ma yɨ ydiscípulos ajcxy tüg barco ma jëb ɨñäy, ca'ty je mayjäy ooy y'adijɨ̈yii y'agodɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Com Jesús tɨ anajty yajtzögy may jäy, paady ycɨxpɨ tüg'ócɨy je pa'mjäy nimujcy Jesús, adzip tzachnïdonaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Co je jäy ajcxy huɨdibɨ ca'oybɨ ymɨɨd ijxpaty Jesús, chi ajcxy ñayhuɨjojtacɨ ma Jesús yhuinduu, e mɨc ycapxcooty, ymɨnaangɨxy: ―Miich je' Dios y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per Jesús nɨmay mɨctägy je ca'oybɨ ajcxy co ca' huaad nigapxcɨxy nimɨydaaccɨxy pɨn je' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Huin'it Jesús ypejty ma tüg cögop, e capxyñiguexy co huen miñ ma yɨ' je ymɨgügtɨjc huɨdibɨ yhuin'ixamy co ytunam mɨɨd yɨ'. Chi ajcxy ymiñ ma Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chi Jesús yhuin'ijx majmetz ajcxy huɨdibɨ ymɨɨd'idamy, e huɨdibɨ yquexamy y'ayuccapxhuäcxp. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesús moy je majmetzpɨ discípulos ajcxy huɨdibɨ anajty tɨ yhuin'ixy mɨc'ajt jaydëb yajtzögɨp pa'mjäy ajcxy, e ymoy ajcxy ymɨc'ajt jaydëb ca'oybɨ yajpɨdzɨmy ma jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Jada je nimajmetzpɨ discípulos ajcxy yxɨɨ nidüg nidüg: Simón, je huɨdibɨ Jesús yxɨɨmoy Pedro; Jacobo mɨɨd y'uch Juan, yɨ Zebedeo y'ung y'anäg, je huɨdibɨ ajcxy Jesús yxɨɨmoy Boanerges (je ayuc Boanerges jadu'n yhuimbɨdzɨmy: “Enee ymang”). ");
INSERT INTO mcoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","E jacjadyii huɨdib Jesús tɨ anajty huin'ixy: Andrés; Felipe; Bartolomé; Mateo; Tomás; Jacobo je huɨdibɨ Alfeo ymang'ajtpy; Tadeo; e je jadügpɨ Simón, je cananista. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nañ jadu'n Jesús huin'ijxy Judas Iscariote, je huɨdibɨ agojɨɨx cɨ̈yejc Jesús ma ymɨdzip. (Co jadu'n huin'ijxtaay je majcmetzpɨ discípulos ajcxy), Jesús ytɨgɨɨy ma tügtɨjc mɨɨd yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Huin'ítɨy tzach mayjäy ñayyöymújcɨgɨxy ma je tɨjc ma Jesús y'ity, ixtɨ Jesús etz ymɨgügtɨjc ca' y'oyɨ̈y nej jëb ycaaygɨxy y'uuccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Co Jesús y'amɨgügtɨjc jadu'n nejhuɨɨy, chi ajcxy nimiiñ Jesús yajnɨcxaangɨxy anajty mach, com hue' anajty tíjcɨxy co Jesús ylocɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nijëjɨty escribas ajcxy, je huindzɨndɨjc huɨdibɨ nïjaydutp anajty Dios ñecy, miin ma Jesús co choñ ajcxy Jesusalén, ymɨnaangɨxy: ―Jada Jesús ymɨɨd Beelzebú, je ca'oybɨ yhuindzɨn, ma y'aa yjot. E yɨ' yajpɨdzɨmy je ca'oybɨ ajcxy ma jäy ajcxy yjothuinma'ñ mɨɨd Beelzebú ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chi Jesús huoomiñ ma yɨ' je escribas ajcxy, e yajmɨɨdmɨydacy ajcxy tüg jɨhuimbit ayuc. Chi Jesús ymɨnañ: ―¿Nej tɨy'ajt jada nej miich ajcxy mɨna'ñ co Satanás jëb cɨ'm ñayyajpɨdzɨmyii ma jäy ajcxy y'aa yjot? Ca' tɨy'ajt nej miich ajcxy mɨna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pen tügpɨcy tungmɨɨdpɨ ixyipy ñaybɨjc-huá'cxɨgɨxy, etz ñaymɨdziptzóonɨgɨxy ixyipy ac jëyɨ. Pues cɨxɨp yɨ' ajcxy y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nañ jadu'n pen tügpɨcy tüg juugy tüg mɨgüg ixyipy ñaybɨjc-huá'cxɨgɨxy, ca' ajcxy y'idaangɨxy tügmucy. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nañ jadu'n pen Satanás ixyipy tɨ ñaybɨjc-huäcxyii, e cɨ'm ixyipy tɨ nayñibɨdɨ̈gyii, ca' ixyipy yɨ' ymɨc'ajt ida'ñ. Hue' janchtɨy Satanás cɨxɨpy tɨgoyɨpy. (Paady ca'tɨy'ájtɨty nej miich ajcxy ymɨnañ.) ");
INSERT INTO mcoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ca' ni pɨn jëb huaad ytɨgɨ̈huɨ̈p ma tüg mɨcpɨ jäy ytɨjc etz meedzɨpy tijaty ymɨɨd, pen ca' jayɨjp cɨ̈xoch tecyxoch je jäy mɨcpɨ. Pen tɨ cɨ̈xoch tecyxoch ixyipy je mɨcjäy, huin'it janchtɨy mɨmadägɨpy, e pɨ́jcɨp tijaty ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Janch ɨɨch miich ajcxy nɨmäy co Dios jëb huinmeecxɨp tüg'ócɨy pocy huɨdibɨ jäy ytúngɨxp etz tüg'ócɨy jɨbɨcpɨ huɨdibɨ jäy ycapxp. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jëyɨ janchtɨy co pɨnjaty capxtɨgooyb mɨɨd je Espíritu Santo, je Dios yjɨhuɨ'ñ ymɨc'ajt, ca' Dios huinmecxɨ nimɨna. Huinɨxɨɨ y'ida'ñ pocymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mɨɨd co jäy ajcxy chach ymɨnaangɨxy co Jesús anajty mɨɨdɨty ca'oybɨ, paady Jesús jadu'n ymɨnañ. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús ytaj etz y'uch ajcxy oy yja'ty ma anajty Jesús yajpaady. Chi Jesús ytaj etz y'uch ajcxy anajty ytɨnaaygɨxy tɨba'y, e chi ajcxy capxñiguejxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Je mayjäy huɨdibɨ anajty ajcxy ɨñaayb jühuɨditɨ ma Jesús, ymɨnañ ajcxy: ―Miich mdaj etz m'uch cheeby ajcxy tɨba'y miich ixtaayb. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chi Jesús ymɨnañ: ―¿Pɨnjäy miich ajcxy mdijy co ɨɨch ndaj'adyii etz ɨɨch n'uch'adyii? ");
INSERT INTO mcoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Huin'it Jesús huindɨcxpejty je jäy ajcxy huɨdibɨ anajty ɨñaayb ajcxy jühuɨdity ma je', e ymɨnañ: ―Tüg'ócɨy jada jäy ya jadu'n ajcxy nipaady nej ɨɨch ndaj etz ɨɨch n'uch. ");
INSERT INTO mcoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Huenytimypɨ́nɨty huɨdibɨ ajcxy cuydumb yɨ Dios chójcɨn, yɨ' je' jadu'n nipaady nej ɨɨch n'uch, ɨɨch n'ajch, ɨɨch ndzɨ' etz ɨɨch ndaj. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jadüg'oc Jesús ytɨgɨɨy yaj'ixpɨjcpɨ ma mejypa'. E ooy mayjäy ymujcpejty ma anajty Jesús yajpaady. Mɨɨd co ooy anajty chachmayjäyɨty, paady Jesús ytɨgɨy ma tüg barco jahuengɨ mejyjoty. Jesús ɨñaayb anajty barcojoty, e je mayjäy ɨñaayb anajty ajcxy ma mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Huin'it Jesús yaj'ixpɨjcy je mayjäy mɨɨd canaag jɨhuimbit ayuc. Co yaj'ixpɨcy, chi ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Amɨdoo'ijtcɨx miich ajcxy ɨɨch jada n'ayuc. Tüg jäy chooñ niipɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Co je niipɨ yhuɨjpy anajty trigo tɨɨm, chi je trigo tɨɨm nijëjɨty oy ycäy tɨm tügujc. Chi je joon ajcxy ymiiñ jɨcxy je trigo tɨɨm huɨdibɨ tügujc tɨ ycäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","E nijëjɨty trigo tɨɨm oycäy ma tzaanïcx, ma nihueeñ oyñaax yajpaady. E je trigo tɨɨm ca' tzip mujx je', je'co ca'anajty ooy naax mápxɨty. E co je xɨɨ ypɨdzɨmy, chi no'cy je trigo mang, com ca' anajty ytictz mɨɨdɨty naaxjoty, chi ytɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","E nijëjɨty trigo tɨɨm oycäy ma apyjot. Co jada trigo tɨɨm ymujxy, chi y'ujtz'ögtäy je trigo mang, e ca' ytɨɨm'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per jacjadyii trigo tɨɨm oycäy ma oyñaax, chi ymujxy, e ytɨɨm'ajt may'amy: tüg pi'c pajc iipxmajc oyco'ity, jadüg pi'c pajc tugɨ'px oyco'ity, jadüg pi'c pajc mɨgo'px oyco'ity. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Co Jesús je mɨydägɨɨ yajmay, chi ymɨnañ: ―Pɨnjaty mɨɨd ytätzac, pɨn mɨdohuamy, huen mɨdo'mbɨcy jada ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Co je mayjäy ñɨcxnɨ, e Jesús yhuɨ'my naydüg, chi je nimajmetzpɨ ydiscípulos ajcxy etz jacjadyii huɨdib mɨjnɨcxpejt Jesús ñimɨjhua'cy, e amɨdoy nej yhuimbɨdzɨmy je jɨhuimbit ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","E Jesús ymɨnañ: ―Miich ajcxy jaydëb mnejhuɨ̈huɨpy huɨdibɨ Dios ñigapxpy ñimɨydacpy coyüch'amy ma y'ané'mɨn ycötújcɨn. Jacjadyii jäy ajcxy jɨhuimbit'amy nyajmɨɨdmɨydaacyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jadu'n jɨhuimbit'amy nyaj'ixpɨjcpyɨch je mayjäy, jaydëb co pɨnjaty ijxp, ca' ajcxy ixɨpy; etz pɨnjaty mɨdoob, ca' ajcxy mɨdo'mbɨgɨpy. E jadu'n ca' ajcxy yjothuimbidip, e nañ ni ycayajmeecxɨpy ajcxy ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chi Jesús yjacmɨnañ: ―¿Nej ca' miich ajcxy mhuinjɨhuɨ̈y jada jɨhuimbit ayuc? Pen ca' miich ajcxy mhuinjɨhuɨ̈y jada jɨhuimbit ayuc, ca' miich ajcxy mhuinjɨhuɨ̈huɨp yɨ jacjadyii jɨhuimbit ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Je huɨdibɨ capxhuäcxp Dios y'ayuc, jadu'n yɨ' nipaady nej je huɨdibɨ niip trigo tɨɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Je jäy ajcxy huɨdibɨ amɨdoo'ijtp Dios y'ayuc, e mɨc'amy je ca'oybɨ yajpɨdzɨmy Dios y'ayuc ma ajcxy yjot yhuinma'ñ, jadu'n ajcxy nipaady nej trigo tɨɨm huɨdibɨ cäb tügujc, e je joon ajcxy mɨc'amy piimujctay. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Je jäy ajcxy huɨdibɨ amɨdoo'ijtp Dios y'ayuc janch jotcujc, e mɨbɨ́jccɨxy tzojccɨ́x, chi ajcxy ixmajtzɨ Dios y'ayuc co agapxɨɨyb paady, e co tzaachypɨ mɨnaxy yajnaxy mɨɨd Dios y'ayuc ycɨxpɨ. Jadu'n ajcxy nipaady nej je trigo tɨɨm huɨdibɨ tɨ ycäy ma tzaanïcx. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Je jäy ajcxy huɨdibɨ amɨdoo'ijtp Dios y'ayuc, e co ñɨcxnɨ, chi jäydɨgooyñɨ Dios y'ayuc mɨɨd jotcujc'ájtɨn tzɨnaayɨn, etz comeeñ'ájtɨn etz adzójcɨn. Jadu'n ajcxy nipaady nej trigo tɨɨm huɨdibɨ tɨ ycäy ujtzjoty, e ca' ytɨɨm'aty mɨɨd co oy y'ujtz'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Je jäy ajcxy huɨdibɨ amɨdoo'ijtp etz cöbɨjcp Dios y'ayuc amumdügjot etz Dios y'ayuc tumb ma ajcxy yjot yhuinma'ñ, jadu'n ajcxy nipaady nej je trigo tɨɨm huɨdibɨ tɨ cäb ma oyñaax etz ytɨɨm'aty may'amy: tüg pi'cpajc iipxmajc, etz jadüg pi'cpajc tugɨ'px, etz jadüg pi'cpajc mɨgo'px. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Chi Jesús yjacmɨnañ: ―Co jäy ajcxy jɨndɨcxɨ'ñ nöctzoy, chi canan ajcxy cöjujpy mɨɨd tu'tz, ni ca' ajcxy pɨdacy cɨjxpa'tcɨ'py, hue' janchtɨy pɨdaaccɨxy ma jɨndɨcxpejt jaydëb mɨj ytɨɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","E nañ ni ca' ni pɨn ni ti jëb ameech tunɨpy, e nɨcxy ycayajnejhuɨ̈y. E ca' ni pɨn ni ti ayüch tunɨpy, e nɨcxy ycayajnejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pɨnjaty ytätzac ymɨɨd, pɨn mɨdoohuamb, huen mɨdo'mbɨ́jccɨxy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nañ jadu'n Jesús ymɨnañ: ―Cuendtúngɨx jada ayuc huɨdibɨ miich ajcxy yam mmɨdooyb. Yɨ quipxɨ'ñ huɨdibɨ ajcxy myajquipxɨɨyb, nañ jadu'n yɨ' mɨɨd Dios ajcxy xyquipxyhuimbidɨpy, e ixtɨ jacyajmöhuɨp ajcxy huɨdijaty mɨdoob ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pɨnjaty ymɨɨd, yajmöhuɨp nïgɨ, pɨnjaty hueen mɨɨd, yajpɨgɨpy nïgɨ (oy ixyipy hueen jadɨm mɨɨdɨty). ");
INSERT INTO mcoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nañ jadu'n Jesús ymɨnañ: ―Yɨ Dios y'ané'mɨn jadu'n yɨ' nej co tüg jäy nɨcxy ñïpy ma ycamjot. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chi jada' co ñiiptay ñɨcxnɨ ma ytɨjc e ymɨ'o'cnɨ ymäybɨdɨ̈gnɨ com jabom, e jadu'n yajnaxy canaag xɨɨ tzuu. E je moc pajc mujxp je' etz yomb. Per je cogam ni ca' nejhuɨ̈y nej je moc yoñ, ma mɨc'ajt paady. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Je' co yɨ naax cɨ'm mɨc'ajt mɨɨdɨty jaydëb yajyoñ je moc. Jayɨjp ypɨdzɨmy je moc ung, jac'axam ypɨdzɨmy yɨ moc pɨjy, e chi jada' ytɨɨm'ajtnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Co je moc ymajaanɨ, chi je jäy ajcxy nɨcxy moc tzijcp, com tɨ yhuindɨy je moc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nañ jadu'n Jesús ymɨnañ: ―¿Nej m'oc'a'ɨxɨ́ɨygɨxy yɨ Dios y'ané'mɨn? ¿Ti mɨɨd n'ocyajquipyxɨ̈huɨbɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jadu'n Dios y'ané'mɨn nipaady nej mostaza pajc huɨdibɨ tüg jäy nɨcxy niipy ma ycam. Yɨ mostaza pajc jacnïgɨ ymútzɨty ca'ydɨ jacjadyii ujtzpajc huɨdibɨ yajpatp ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","E co yajnïpy je mostaza pajc, chi yoñ, e chi yeegy ooy janch mɨj, ca'ydɨ jacjadyii ujtz. E janch mɨj yeegy tüg'ócɨy ycɨ' y'aacx, ixtɨ joon ajcxy pe'mb ma je ycɨ'y'aacx y'anicɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jadu'n anajty Jesús yaj'ixpɨcy je mayjäy ajcxy Dios ytɨy'ajt mɨɨd canaag jɨhuimbit ayuc, ixtɨ mɨbaad ajcxy jëb huinjɨhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ac jɨhuimbit ayuc Jesús yajnɨmay je mayjäy. Per mɨɨd yɨ'ydiscípulos Jesús ycapxtɨ̈cxtaayb anajty je jɨhuimbit ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Je huin'it xɨɨ co ycoodzɨɨy, chi Jesús nɨmay yɨ ydiscípulos ajcxy: ―Tzoc ajt jámɨm jɨm'amy ahuin ma yɨ jadügpɨ mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Huin'it Jesús ydiscípulos ajcxy ixmajtztay je mayjäy, e mɨɨd tzooñ Jesús barcojoty. Nañ jadu'n jacjadyii barco ajcxy choñ quipxy mɨɨd Jesús ydiscípulos ajcxy ybarco. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Je huin'it coodz tüg poj miiñ janch mɨc. E je mejy nɨgoo anajty y'ocpɨdɨ̈gnɨ. Janch tɨgɨɨyb anajty nɨɨ barcojoty, jagoo jagoo yca'ujtztay je barco mɨɨd nɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús maab anajty ma je barco ɨjx ma tüg mabejt. Chi yajmäybɨdɨ̈gɨ, e nɨmay ajcxy: ―Huindzɨn, ¿nej ca'mduñcuend co ɨɨch ajt yam nguinaanɨm? ");
INSERT INTO mcoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Huin'it Jesús ymäybɨdɨ̈gy, e jɨjpcogapxɨy je poj. Etz nɨmay je mejy: ―¡Amon! ¡Huäcxɨp! Chi mɨc'amy je poj ymongɨdactay yhuäcxɨjptay jadu'ñyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Huin'it Jesús ymɨnañ: ―¿Na'amy co mdzachtzɨgɨɨygɨxy ajcxy? ¿Nej ca' mmɨbɨ́jccɨxy co nmɨɨdɨch Dios ymɨc'ajt? ");
INSERT INTO mcoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesús ydiscípulos ajcxy ooy chɨgɨɨy, e ñayñɨmaayɨ ajcxy miñ xyɨpy: ―¿Pɨn jäy jada' jada Jesús? Ooy chachmɨjhuinma'ñ co yɨ poj etz je mejy ycapxymɨdoyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chi Jesús mɨɨd ydiscípulos ajcxy oyja'tcɨxy ma je mejypa' ma je Gadara jäy ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tɨm mɨc'amy co Jesús ybarcobɨdzɨmy, chi nimiiñ tüg jäy huɨdibɨ ca'oybɨ mɨɨd anajty. Hue' anajty chooñ ma öcpɨ jut. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Je yëydɨjc, ca'oybɨmɨɨdpɨ, tzɨnaayb anajty ma öcpɨ jut. E ni pɨn anajty ycamɨmadägyii. Ni pɨn camɨmadacy nɨcx cɨ̈xoch tecyxoch jada je ca'oybɨmɨɨdpɨ, e ni ca' ajcxy mɨmadacy mɨɨd cadena. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Canaag'oc ajcxy jacɨ̈xojch jatecyxojch mɨɨd cadena, e ypojtaayb anajty je cadena. Ni pɨn camɨhuinma'ñybaady nej jëb ocmɨmadaaccɨxy je ca'oybɨmɨɨdpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Je ca'oybɨmɨɨdpɨ xɨɨm tzuum anajty yhuɨdity tüg yuugjot etz ma öcpɨ it, janch mɨc anajty yäxytɨnäy. E chachnayyajtzaachɨ̈yii anajty mɨɨd tzaa. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jɨguëgy anajty je ca'oybɨmɨɨdpɨ ymiiñ, co ijxpaty Jesús, chi poyɨ̈gy ninɨcxy Jesús, e ycojxtɨnay'ahuɨy ma Jesús yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Je ca'oybɨmɨɨdpɨ mɨc mɨgapxcooty Jesús, e nɨmay: ―Jesús, je mɨjpɨ Dios y'ung, ¿na'amy co xymɨdziptzooñɨch? May'ajt nbɨjctzooybɨch ma Dios co ca' ɨɨch jëb huaad xychaachytuñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Je ca'oybɨ jadu'n ymɨnañ, com Jesús tɨ anajty nɨmäy: ―Ca'oybɨ, pɨdzɨmb ma jada yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús y'amɨdooy je ca'oybɨ: ―¿Ti mxɨɨ? Chi je ca'oybɨ y'adzooy: ―Ɨɨch nxɨɨ hue' je' “ni may”, com ni may ɨɨch ajcxy huɨdibɨ yajpatp ma jada yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huin'it je may ca'oybɨ may'ajt pɨjctzoy ma Jesús co ca' ajcxy jëb huaad ixquexyii ma huingbɨ it lugar. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Huingon anajty je cop ma anajty may ɨdzɨm yjɨɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chi je ca'oybɨ ajcxy may'ajt pɨjctzoy, e nɨmay ajcxy: ―Najtzquexɨɨyg ma yɨ may ɨdzɨm, jɨgɨx jëbɨ n'adɨgɨ̈yɨch njottɨgɨ̈yɨch yɨ may ɨdzɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chi Jesús jadu'n a'ɨxɨy co jëbɨ adɨgɨɨygɨxy jotɨgɨɨygɨxy je may ɨdzɨm. Chi je ca'oybɨ ypɨdzɨmday ma je yëydɨjc, e yajtɨgɨyday je may ɨdzɨm ajcxy. Jɨm anajty yajpaady jahuengɨ mejtz mil ɨdzɨm. Chi je ɨdzɨm ylocjɨydaay, e ycögänaxtaay ajcxy ma tüg tzajɨjp, e oy ycädaaygɨxy nɨɨjoty, e chi ajcxy ñɨɨ'ögtay. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Je ɨdzɨm cuend'ajtp ajcxy ooy ajcxy ñay'adzɨgɨɨyɨ, e nɨcxtay ajcxy poyɨ̈gy ma ytɨjc. E oy nimɨydaaccɨxy cajpjoty etz majaty tundac nej anajty ajcxy y'ɨdzɨm y'öctaaygɨxy. Mayjäy ajcxy choñ mɨc'amy oy íjxcɨxy nej anajty tɨ ytunyii tɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Co je mayjäy ajcxy yja'ty ma Jesús yajpaady, chi ajcxy ijxy je yëydɨjc huɨdibɨ anajty mayca'oybɨ ymɨɨd. Ijxy ajcxy co ɨñäy huit mɨɨd etz huijycujc, tɨ anajty y'oyɨ̈y. E huin'it ooy ajcxy je mayjäy ñay'adzɨgɨɨyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Je jäy ajcxy huɨdibɨ anajty huindɨcxp co anajty je ca'oybɨmɨɨdpɨ tɨ y'oyɨ̈y, etz íjxcɨxy nej tɨ ytunyii tɨ yjadyii mɨɨd je may ɨdzɨm, chi yajmɨydactay je maycajpjäy jadu'n nej anajty tɨ ijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Huin'it ajcxy pɨjctzoy may'ajt ma je Jesús, co huen tzooñ ma ajcxy je ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Co Jesús ytɨgɨɨy jadüg'oc ma je barco, chi je yëydɨjc huɨdibɨ anajty ca'oybɨ tɨ ñibɨdzɨmyii tɨ ycöbɨdzɨmyii, pɨjctzoy may'ajt ma Jesús co huen a'ɨxɨ̈y möhuɨp co huen mɨɨd'idyii Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per Jesús ca' a'ɨxɨ̈y co ymɨɨd'idyii, chi nɨmay: ―Huimbit ma mdɨjc etz mjugymɨgüg, e yajmɨɨdmɨydäg jada mɨjpɨ tung mɨjpɨ huinma'ñ huɨdibɨ je Huindzɨn Dios tɨ tuñ mɨɨd miich. Mɨɨdmɨydägɨpy jadu'n nej je Huindzɨn Dios tɨ xypa'ayoy. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chi je yëydɨjc yhuimbijtnɨ, e huɨdijtp anajty cajp cajp jɨm Decápolis ñaaxjot, e nimɨydactay tüg'ócɨy jadu'n nej Jesús tɨ yajtzögyii, e tüg'ócɨy je mayjäy ooy jɨhuɨy huinmay. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Co Jesús huimbijty barcojoty ma je mejypa' ma anajty tɨ chooñ, chi mayjäy ymiiñ ma Jesús yajpaady, chi Jesús yhuäcxɨjpy ma je mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Huin'it Jesús ñija'tɨ tüg mɨjtungmɨɨdpɨ ma yɨ judíojäy ajcxy ñaymujctac. Je yëydɨjc hue' anajty xɨɨjɨty Jairo. Co Jairo ijxpaty Jesús, chi ñayhuɨjojtac ma Jesús yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jairo may'ajt pɨjctzoy, ymɨnañ: ―Huindzɨn, ögaanɨp ɨɨch nnɨɨx. Tun may'ajt nɨcxy ma ɨɨch ndɨjc, e mgɨ̈nïxájɨp ma ɨɨch nnɨɨx, jɨgɨx jëbɨ myajtzögɨp, e yjactzɨnähuɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","E Jesús nɨcxp anajty mɨɨd Jairo, e mayjäy panɨcxy anajty Jesús. E je mayjäy ooy anajty tzach'adijɨ'y tzach'agodɨ'y Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","E ma je mayjäy ymiiñ anajty tüg töxyjäy pa'm mɨɨd, jécyɨñ anajty ymɨjtacnɨ. Majmetz jɨmɨjt yxɨɨ ybo' anajty cujc payöy, ca' anajty y'oc-huäcxɨjpnɨ je nɨ'py. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jada töxyjäy tɨ anajty yajtzoyduñ mɨɨd may tzoydumbɨ, tɨ anajty ymeeñ yajtundäy ma je tzoydumbɨ ajcxy. E je'nɨ anajty ypa'm'ity. Ni ti pubéjtɨn tɨ capaady, ixtɨ nïgɨ anajty ypa'm mɨjhua'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jada töxyjäy tɨ anajty ayuc mɨdoy nej Jesús anajty pa'mjäy yajtzögy, paady nimiiñ etz nimɨjhuägy jɨɨxcɨ'py'amy, chi nïdoonɨ Jesús yhuitpa'. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jada töxyjäy nayñɨmaayɨ jotjoty huinma'ñyjoty: “Co nnïdónɨbɨch Jesús yhuitpa', mɨɨd tɨm yɨ'yɨ ndzögɨbɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Co je töxyjäy nïdoñ Jesús yhuitpa', tɨm huin'ítɨy mɨc'amy yhuäcxɨjp je nɨ'py. Huin'it je töxyjäy jɨhuɨy co anajty tɨ chögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","E Jesús jɨhuɨɨy co anajty tɨ yajtzögy tüg jäy mɨɨd ymɨc'ajt, paady ni'ijxhuimbijty je mayjäy huɨdibɨ anajty pamíinɨp, y'amɨdooy ajcxy: ―¿Pɨn ɨɨch nhuit tɨ xyñïdonɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Huin'it Jesús ñɨmaayɨ ajcxy ydiscípulos: ―Miich m'ijxpy co yɨ mayjäy xychach'adijɨ̈y xychach'agodɨ̈y, e miich mɨna'ñ: “¿Pɨn tɨ xyñïdóñɨch?” ");
INSERT INTO mcoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per Jesús huindɨcxypejty je mayjäy jühuɨdity ma yɨ', oc'ixa'ñ ocnejhuɨ̈hua'ñ pɨn anajty tɨ ñïdonyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Huin'it je töxyjäy, com ñejhuɨɨyb anajty jadu'n nej Jesús tɨ yajtzögyii, paady nimɨjhua'cy Jesús janch tzɨyuuyb mɨɨd tzɨgɨ'ñ ñayhuɨjojtacɨ ma yɨ' yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús ymɨnañ: ―Töxyjäy huɨdibɨ ooy ndzócyɨch, tɨ mdzögy mɨɨd co tɨ xymɨbɨ́cyɨch. Nɨcx agujc jotcujc, tɨ mba'm ñaxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Capxp mɨydacp anajty Jesús mɨɨd je töxyjäy co nijëjɨty jäy ñimiinɨ, choñ ma je judío jäy ñaymujctac mɨjtungmɨɨdpɨ ytɨjc, e nɨmay je töxy'anäg yteedy: ―Yɨ mnɨɨx tɨ je y'ögy. Ca' huaad mjac'amayɨ̈y nïg yɨ Huindzɨn Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per Jesús ca' tuñcuend jadu'n nej ajcxy yjamɨna'ñ, chi nɨmay je naymujctac huindzɨn: ―Ca' mdzɨgɨ̈y, mɨbɨc nɨgoda'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E ni ca' jac'a'ɨxɨy nɨcxy yjacmɨɨdnɨcxyii jacpɨnjaty. Jëda'ajty mɨɨdnɨcxy je Pedro, Jacobo etz Juan, je Jacobo y'uch. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","E co Jesús ytɨjctɨgɨɨy ma yɨ naymujctac huindzɨn ytɨjc, chi ijxy jadu'n nej jäy jiiby chachne'mgɨxy chachjɨɨygɨxy chachyaaxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Co Jesús tɨjctɨgɨɨy, chi nɨmay je jäy ajcxy: ―¿Nej co nɨgoo ajcxy mdzachne'mnɨ, e mdzachyáaxcɨxnɨ? Yɨ pi'c töxy'anäg ca' yɨ' tɨ y'ögy, maab yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Per nɨgoob ajcxy Jesús nɨxiicy co jadu'n ymɨna'ñ. Huin'it Jesús yajpɨdzɨmday tüg'ócɨy pɨnjaty anajty jiiby tɨgoty, e mɨɨd tɨjc tɨgɨy jëda'ajty je ungdeedy etz ungdaj, e nañ je tugɨɨgpɨ ydiscípulos huɨdibɨ anajty tɨ mɨɨd miiñ. Chi ajcxy ytɨgɨy jiiby ma anajty je töxy'anäg yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chi Jesús májtzɨy yɨ töxy'anäg ycɨ', e chi nɨmay: ―Talita, cumni ―jadayaab ayuc hue' yɨ' yhuimbɨdzɨmy: Töxy'anäg, ɨɨch miich yam nɨmaayb, pɨdɨ̈g. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Huin'ítɨy je töxy'anäg, je huɨdibɨ anajty majmetz yjɨmijt, ypɨdɨ̈gy e ytüyöychoñ. E tüg'ócɨy yɨ mayjäy ooy ajcxy jɨhuɨy huinmay. ");
INSERT INTO mcoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Huin'it Jesús najtzcapxɨɨy co ca' huaad pɨn yajnɨmay jadu'n nej je töxy'anäg tɨ chögy, nañ jadu'n ni'ane'mdɨy co huen ajcxy yajcay je pi'c töxy'anäg. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Huin'it Jesús chooñ ma je jɨmbɨ it lugar, e yhuimbijty ma ycɨ'mgajp. E mɨɨd ñɨcxy yɨ' ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado xɨɨjoty Jesús ytɨgɨy yaj'ixpɨjcp ma je mayjäy huɨdibɨ yöymújccɨxp ma je judío jäy ñaymujctac. E je mayjäy huɨdibɨ amɨdoo'ijtp anajty ooy jɨhuɨy huinmay ajcxy, e ñayñɨmaayɨ ajcxy miñ xyɨpy: ―¿Ma jada' jadayaab jäy tɨ ni'ixpɨgɨ̈y jadayaab ixpɨ́jcɨn? ¿Ma tɨ paady jada huijy'ajt cujc'ajt huɨdibɨ ymɨɨd? ¿Ma jada' tɨ paady yɨ mɨc'ajt huɨdibɨ mɨɨd mɨjhuima'ñ tumyb? ");
INSERT INTO mcoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Je' jada je tzejtzpɨ, yɨ María y'ung. Yɨ' y'uch ymɨgüg, yɨ Jacobo, yɨ José, yɨ Judas, etz yɨ Simón. Nañ jadu'n yɨ' y'uch töxyjäybɨ cha ajcxy chɨnäy quipxy mɨɨd ɨɨch ajt. E je mayjäy ca'ajcxy anajty ixa'ñ cöbɨga'ñ Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Huin'it Jesús nɨmay je mayjäy ajcxy: ―Huenma'ámyɨty tüg'ócɨy je mayjäy ooy yajmɨj'aty je jäy ajcxy huɨdibɨ najtzcapxɨɨyb Dios y'ayuc. Jëyɨ janchtɨy, ma ycɨ'm naax ma ycɨ'mgajp ca' je jäy ajcxy yajmɨj'adyii, etz nañ ytɨm jadu'n yɨ' y'amɨgügtɨjc etz ymɨjɨɨn ymɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma ycɨ'm naax ycɨ'm gajp Jesús ca' jaty nej mɨjhuinma'ñ tunɨpy mɨɨd co ca' ajcxy mɨjpɨdägyii. Jëyɨ ycɨ̈pɨdacy ma nijëjɨty pa'mjäy etz yajtzoocy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús ooy jɨhuɨy huinmay nej je jäy ajcxy ca' ymɨjpɨdägyii ma ycɨ'm naax ycɨ'm gajp. Chi Jesús chooñ jɨm ñɨcxy ma jacjadyii cajp huinduy agonbɨ, e yaj'ixpɨjcy anajty je mayjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Huin'it Jesús mɨjhuoy je majmetz ydiscípulos ajcxy, e chi quejxhuäcxy nimetz nimetz ma canaag cajp. E chi mooy mɨc'ajt, jɨgɨx jëb yajpɨdzɨmy ajcxy ca'oybɨ ma jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nañ jadu'n y'ane'my Jesús je' ydiscípulos ajcxy co ca' huaad ti mɨnɨ́cxcɨxy tü'amgɨxpɨ, jëyɨ jëb mɨnɨ́cxcɨxy tüg tajc nidüg nidügtɨ. Ca' huaad mɨnɨ́cxcɨxy ymorral, e ca' huaad mɨnɨ́cxcɨxy ycaagy, e ca' huaad mɨnɨcxcɨxy ymeeñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jëyɨ je ycɨ̈g etz je yhuit huɨdibɨ anajty ajcxy ymɨɨd huen mɨnɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chi Jesús ymɨnañ: ―Co anajty ajcxy mjättaccɨxy ma tüg tɨjc, jɨm ajcxy mhuɨ́'mɨpy ixtɨ coon mdzóonɨp ma yɨjɨmbɨ cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pen mdɨgɨɨygɨxp ma tüg cajp, e je jäy ajcxy ca' ajcxy xycöbɨga'ñ, ca' ajcxy amɨdo'ida'ñ miich m'ayuc, mbɨdzɨmgɨx ma je cajp, chi mhuinhuójpcɨxɨpy mgïg. Jada je' je tɨy'ajt co ca' ajcxy mjotcújcɨty. Janch ɨɨch miich ajcxy nɨmäy co Dios anajty ytɨyduñ jada naaxhuiñ jäy, jacnïgɨ tzaachypɨ paada'ñ yɨ jäy ajcxy huɨdibɨ ajcxy anajty ca' xycöbɨ́jccɨxy, ca'ydɨ je' ajcxy huɨdibɨ tzɨnaay jecy'aty ma Sodoma etz Gomorra cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chi je nimajmetzpɨ ajcxy chon Dios y'ayuccapxhuäcxy co huen jäy ajcxy jothuimbíjtcɨxy, huen ixmajtztaaygɨxy yɨ pocytunɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nañ jadu'n ajcxy yajpɨdzɨmy ca'oybɨ majaty jäy, e pɨdaaccɨxy aceite majaty pa'mjäy, e yajtzóoccɨxy anajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Huin'it je rey Herodes nejhuɨɨy co Jesús canaag mɨjhuinma'ñ tzachytuñ anajty, com tüg'ócɨy je mayjäy anajty nimɨydaaccɨxy Jesús. Herodes ymɨnañ co Juan je Bautista tɨ yjugypɨcy jadüg'oc ma anajty tɨ y'ögy, paady mɨc'ajt mɨɨdɨty jaydëb mɨjhuinma'ñ tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nijëjɨty jäy ymɨnaangɨxy: ―Jesús yɨ' je' Elías. E naagɨty jäy ymɨnángɨxy: ―Yɨ' je' tüg Dios tɨy'ajtmɨɨdpɨ huɨdibɨ quipxyɨɨby mɨɨd je Dios ytɨy'ajtmɨɨdpɨ huɨdibɨ tzɨnay jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Co Herodes nejhuɨɨy nej je mayjäy nimɨydaaccɨxy Jesús, chi ymɨnañ: ―Janch jada co Juan tɨ yjugypɨcy, je huɨdibɨ nni'ane'mdɨɨyɨch co huen yajmɨnagyii ycohuajc. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mɨɨd Herodías, Herodes ytöxytɨjc ycɨxpɨ, Herodes n'ane'mdɨɨy co Juan yajmach, e pɨdägyii pujxtɨgoty. Jada Herodías jayɨjp ypɨjcy mɨɨd je rey Herodes y'ajch Felipe, per tɨ anajty ixmach Felipe, e ypɨjctɨgajch mɨɨd je ycapy Herodes. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hue' anajty Juan tɨ nɨmay Herodes: ―Ca' jadu'n paadyii co yɨ m'ajch Felipe ytöxytɨjc miich mɨɨddzɨnaayɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Paady ycɨxpɨ Herodías mɨjotma'ty Juan, e ytɨmy yaj'ögamy anajty. Per ca' mɨc'amy yhuinma'ñybaty nej ocyaj'ögɨp; ");
INSERT INTO mcoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","com je rey Herodes ñejhuɨɨyb co tudägy jäy huädz jäy anajty je Juan, e tzɨgɨɨyb anajty mɨɨd Juan. Paady ycɨxpɨ anajty je rey Herodes Juan mɨɨdɨty cuend'aty pujxtɨgoty. Naag'oc naag'oc anajty Herodes nɨcxy amɨdo'ity Juan y'ayuc, ooy anajty huinmay nej yhuimbɨdzɨmy, per jotcujc anajty amɨdo'ijty. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Huin'it Herodías ypat huinma'ñ nej jëb yaj'ögy Juan je huin'it xɨɨ co je rey Herodes anajty ñayñixɨɨduñyii. Hue' yajcay yaj'uucy je gobierno ytumbɨ ajcxy, je soldado huindzɨn ajcxy, etz tüg'ócɨy yɨ mɨc jäydɨjc huɨdibɨ ajcxy tzɨnaayb naag naag cajp jɨm Galilea. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Xɨɨduñyjoty anajty co Herodías ñɨɨx oy y'ech ma je rey anajty yajpaady mɨɨd je may jäy huɨdibɨ anajty yajcaayb yaj'uucpy. E jadu'n nej je Herodías ñɨɨx y'ejch, ooy je rey jadu'n jäygɨdacy, etz tüg'ócɨy je jäy je huɨdijaty anajty mɨɨd ajcxy ycaaygɨxy y'uuccɨxy. Chi je rey nɨmay je töxy'anäg: ―Pɨjctzóohuɨgɨch ti mdɨmdzojcpy, ɨɨch miich nmöhuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Je rey nïgɨ capxcödujcy janch cɨxyjot huinɨjot co möhua'ñ ti ytimy ypɨjctzooyb, ixtɨ jëb jamöy cujhuäcxy yɨ' y'ané'mɨn, mɨbaad anajty ane'my je naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chi je töxy'anäg ñɨcxy ma ytaj oy amɨdoy, nɨmay: ―¿Ti nbɨjctzohuɨ́pɨch? Chi je' ytaj y'adzooy: ―Pɨjctzoohuɨ yɨ Juan je Bautista ycohuajc. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mɨc'amy je Herodías ñɨɨx nihuimbity je rey e ymɨnañ: ―Ndzojcypɨch co xymöhuɨbɨch mɨc'amy je Juan je Bautista ycohuajc ma tüg texy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Co jadu'n mɨdoy je rey, chi ytɨgɨɨy tajp mayb janch mɨjcajee. Per ti y'octunɨpy. Com tɨ anajty jadu'n capxcöducy, tɨ anajty mayjäy mɨdoy ti anajty tɨ yaj'ahuanɨ̈y je töxy'anäg, ca' y'ayuc yajxiicy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Paady ycɨxpɨ je rey mɨc'amy ane'my tüg soldado, co huen nɨcxy yajtzonɨ Juan ycohuajc. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chi je soldado ñɨcxy ma pujxtɨjc, e yöcpujxtuuty Juan. Chi je soldado mɨmiiñ Juan ycohuajc ma tüg texy, e yajcɨ̈dɨgɨy je töxy'anäg, e je töxy'anäg yajcɨ̈dɨgɨy ytaj. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Co je jäy ajcxy huɨdibɨ anajty mɨjnɨcxpejtp Juan ñejhuɨɨy ajcxy co je rey tɨ yaj'ögy Juan, chi ajcxy y'oy e yajpɨdɨ̈cɨ Juan ñinïcx, e yajnaaxtɨgɨɨy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Co je majmetzpɨ apóstoles ajcxy yhuimbijty huɨdibɨ anajty Jesús tɨ quexy y'ayuccapxhuäcxpɨ ma canaag cajp, chi ajcxy yajmɨɨdmɨydacy Jesús tüg'ócɨy tijaty anajty tɨ túngɨxy, etz tüg'ócɨy ayuc huɨdijaty tɨ yaj'ixpɨ́jccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Huin'it Jesús nɨmay je nimajmetzpɨ huɨdibɨ anajty tɨ quexy y'ayuccapxhuäcxpɨ: ―Tzoc jámɨm ma tüg it ma ca' pɨn, jaydëb nbócxɨm tüg xɨɨ metz xɨɨ. Paady ycɨxpɨ Jesús jadu'n ymɨnañ, com tzach mayjäy ja'ttɨɨb tzondɨɨb ma Jesús yajpaady, e ca' ajcxy tiempo anajty mɨ́ɨdɨty mɨna ycáaygɨxɨpy y'úuccɨxɨpy mɨɨd je mayjäy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","E Jesús mɨɨd ydiscípulos ajcxy ñɨcxy barcojoty ma ca' pɨn. Ac jëyɨ ajcxy nɨcxy ca' jac pɨn jäy mɨɨd nɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","E mayjäy ijxy co Jesús ajcxy choñ, e nañ ijxcajpy pɨn anajty tzoñ barcojoty. Paady mayjäy chooñ ma canaag cajp tegyɨ'm, ñɨ́cxcɨxy poyɨ̈gy anajty ma Jesús ñɨcxa'ñ. Mayjäy oy yja'ty jayɨjp ca'ydɨ Jesús ajcxy, e jɨm ajcxy yöymujctay. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Co Jesús ybarcopɨdzɨmy, chi ixy janch mayjäy, e Jesús ooy pa'ayoy je mayjäy, com jadu'n anajty ajcxy nej maycöbixy huɨdibɨ ca' mɨɨdɨty ycuend'ajtpɨ. Chi Jesús ytɨgɨy yaj'ixpɨjcp, canaag nax ixpɨ́jcɨn anajty yecy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Co anajty tɨ chu'ɨɨyñɨ, chi Jesús ydiscípulos ajcxy ñɨmaayɨ: ―Ca' ni pɨn chɨnäy ma jadayaabɨ it lugar, e tɨ chu'ɨɨyñɨ. Capxycɨ́x mɨɨd jada mayjäy ajcxy, jaydëb ñɨ́cxcɨxyñɨ ma yɨ cajp huinduy agonbɨ, huen nɨcxy júygɨxɨpy ycaayɨn y'uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Huin'it Jesús y'adzooy yɨ' ydiscipulos ajcxy: ―Miich ajcxy móoygɨx jada mayjäy caayɨn úucɨn. Chi ajcxy Jesús y'adzooy: ―¿Huaad ɨɨch ajcxy nɨcxy njuy mejtz mɨgo'px denario tzajcaagy, jɨgɨx ycayɨpy y'ügɨpy jada mayjäy? ");
INSERT INTO mcoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chi Jesús y'amɨdooy ydiscípulos ajcxy: ―¿Naag tzajcaagy miich ajcxy mɨɨdɨty ya? Nɨcx íjxcɨx. Co ajcxy tɨy'ajt paty, chi ajcxy Jesús nɨmay: ―Ɨɨch ajcxy nmɨɨd mɨgoox tzajcaagy etz metz acx. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chi Jesús ni'ane'mdɨɨy co je mayjäy huen ixtaaccɨxy naaxcɨ́xy tügpɨcyjaty. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chi je mayjäy y'ixtactay canaagpɨcy. Canaagpɨcy mɨgo'px jatypɨ, e canaagpɨcy huixchiguïpxmajcjatypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chi Jesús conɨ̈gy je mɨgooxpɨ tzajcaagy etz je metzpɨ acx, e ypa't'ijxy tzajpcɨ́xy, e yajnajxy Dios cojuyɨp ma Dios mɨɨd je tzajcaagy etz je acx ycɨxpɨ. Huin'it Jesús tujc-huäcxy je mɨgooxpɨ tzajcaagy, e yajcɨ̈dɨgɨy je' ydiscípulos ajcxy, jaydëb ajcxy yajhuäcxɨp ma je mayjäy. Nañ jadu'n Jesús yajcɨ̈dɨgɨɨy je metzpɨ acx je' ydiscípulos ajcxy, jaydëb yajhuäcxɨp ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nidüg'ócɨy je mayjäy ajcxy ycay y'uucy cüxyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Co je mayjäy ycayday, chi je discípulos ajcxy yajmujcy je cayduc tzütztuc, e yaj'ujch ajcxy majmetz cach. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mɨgoox mil anajty ajcxy je yëydɨjctɨjc huɨdibɨ cay uuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Huin'it Jesús ane'my je' ydiscípulos ajcxy co huen barcotɨgɨɨygɨxy mɨc'amy. Huen nɨcxɨ̈ccɨxy jayɨjp jɨm Betsaida jɨm mejy ñïnajxy. Co yɨ discípulos ajcxy ybarcotɨgɨyday, chi Jesús ycapxycɨ́jxy mɨɨd je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Co anajty Jesús tɨ ycapxycɨ́xy mɨɨd je mayjäy, chi ñɨcxy ma tüg cögop Dios mɨbɨjctzoob. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Co ycoodzɨɨyñɨ je discípulos ajcxy anajty yajpaady mejyjoty ma je barco. Jesús naydüg anajty yajpaady mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús y'ijx co je'ydiscípulos ajcxy anajty tɨ y'anucxɨɨygɨxy mɨɨd mejycabɨɨ, je' co je barco anajty chachjɨjpcobojɨ̈y. E co oy moñɨ̈y, chi Jesús ymɨjhuägy ma je barco. Jesús yöyp anajty mejyhuingɨ́xy, e hue' anajty jüyöyñaxamy je discípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Co ajcxy ijxpaty Jesús yöyp anajty mejyhuingɨ́xy, chi ajcxy ooy yaxqueegy, com hue' anajty ajcxy tijy co nɨgo y'ijxmañɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Com tüg'ócɨy yɨ discípulos ajcxy anajty tɨ íjxcɨxy Jesús, e ooy ajcxy chɨgɨɨy, paady mɨc'amy Jesús mɨgapxy je' ydiscípulos ajcxy, e nɨmay: ―Jotmɨc naybɨdáacɨgɨxy, ca' mdzɨgɨɨygɨxy. Ɨɨch yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huin'it Jesús ybarcotɨgɨɨy, e mɨc'amy je poj yxeemy, e je discípulos ajcxy ooy jɨhuɨy huinmay. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ooy ajcxy jɨhuɨɨygɨxy huinmaaygɨxy, com ca' ajcxy huinjɨhuɨɨygɨxy anajty nej Jesús je mayjäy yajcay mɨɨd je mɨgooxpɨ tzajcaagy. Com je'nɨ anajty ajcxy ooy yjotjuuñɨty ycöjuuñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chi ajcxy ymejch ma je mejypa' ma je Genesaret ñaaxjot. E coxojch ajcxy je barco ma mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Co ajcxy ybarcopɨdzɨmy, chi mɨc'amy je mayjäy ajcxy jɨm ijxcajpy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Poyɨ̈gy je jäy ajcxy chooñ, e yajyöyñajxtay je cajp ajcxy huinduy agonbɨ, capxhuäcxcɨxy co Jesús anajty tɨ yjädy jɨm. E jäy ajcxy yajmiindzondacy may pa'mjäy cɨjx'am jɨm ma anajty Jesús yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E hueñytɨm ma'amyɨty anajty Jesús ñɨcxy majaty mɨj cajp, mutz cajp, o majaty jäy y'ujtztzɨnäy, ooy anajty ajcxy pɨdáccɨxy pa'mjäy majaty majaty yɨ mɨj tüba', e cohuanɨɨygɨxy Jesús co huen nïdoñyii yɨ yhuitpa', e tüg'ócɨy huɨdijaty anajty ajcxy nïdomb, najxp ajcxy anajty je' ypa'm. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Huin'it ymiiñ ma Jesús nijëjɨty fariseojäy ajcxy, je huindzɨndɨjc huɨdibɨ tzachpadumb judío ycostumbre. Nañ jadu'n mɨɨd miiñ nijëjɨty escribas, je huindzɨndɨjc huɨdibɨ ajcxy nïjaydutp anajty Dios ñecy. Hue' je fariseos etz escribas ajcxy anajty tɨ choongɨxy Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Je fariseos etz escribas ajcxy ijxy co Jesús ydiscípulos ajcxy ytɨgɨɨy caaybɨ uucpɨ jaygɨ̈bujy, ca' anajty cuydúngɨxy judíojäy ycostumbre. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Com yɨ fariseojäy etz jacjadyii judíojäy ajcxy cuydumby anajty ajcxy ñi'ap costumbre, e ixpocypújcɨxy jayɨjp ma ca'nɨ ytɨgɨɨygɨxy caaybɨ uucpɨ. Com yɨ judíojäy ajcxy co ajcxy ñɨcxy mayjäyjoty etz yhuimbíjtcɨxy jadüg'oc ma ytɨjc, ca' ajcxy ycay ixtɨ coonɨ jayɨjp ajcxy ycɨ̈bújcɨxy canaag'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yɨ judíojäy ymɨɨd canaagnax costumbre huɨdibɨ cuydúngɨxyp jadu'n nej ajcxy yajhuaatzcɨxy ajcxy ytaasɨ ytexy ytütz etz ypujxtexy.) ");
INSERT INTO mcoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chi je fariseos etz escribas ajcxy y'amɨdooy Jesús, nɨmaayɨ: ―¿Na'amy co miich mdiscípulos ajcxy ca' cuydúngɨxy judíojäy ñi'ap costumbre? ¿Na'amy co ajcxy ycaaygɨxy y'úccɨxy, e ca' jayɨjp ixpújcɨxy yɨ' ypocyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chi Jesús y'adzooy: ―Janch tɨy'ajt jadu'n nej je Dios ytɨy'ajtmɨɨdpɨ Isaías jayhuɨ'my jecy'ajty mɨɨd miich ajcxy ycɨxpɨ. Miich ajcxy huɨdibɨ naybɨdaacɨp jadu'n nej jɨhuɨ̈y ajcxy tudägyjäy, e ca' yjánchɨ́ty. Com jadu'n Isaías jaybejty co Dios jadu'n ymɨnañ: Jada jäy jadu'n ajcxy ycapxcɨxy ymɨydaaccɨxy jadu'n nej jɨhuɨ̈y xyajmɨj'atyɨch. Per ca' ajcxy xyajmɨj'atyɨch cɨxyjot huinɨjot. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naadɨgɨ̈ co ajcxy xyhuin'ɨ́ɨgɨxɨch xyhuinyáaxcɨxɨch. Ñayyaj'ixpɨ́jcɨgɨxy ayuc tɨy'ajt huɨdibɨ jäy ajcxy tɨ cojy tɨ macxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chi Jesús ymɨnañ: ―Miich ajcxy tɨ m'ixmájtzcɨxy Dios ycötújcɨn, e myajmɨj'ájtcɨxy ayuc huinma'ñ huɨdibɨ jäy cɨ'm tɨ cojy tɨ macxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Miich ajcxy ca' mgüendtúngɨxy Dios ycötújcɨn Dios ytɨy'ajt jɨgɨx jëbɨ cuydúngɨxy mgɨ'm costumbre. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Com Moisés je cötújcɨn ypɨdac jecy'ajty: “Yajmɨj'at mdaj mdeedy”, e “Pɨnjaty jɨbɨc nigapx ni'ojɨɨyb ytaj yteedy, copɨcy y'ögɨp.” ");
INSERT INTO mcoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","E miich ajcxy mɨnañ co tüg jäy nɨmähuɨp ytaj yteedy co ca' pubeda'ñ ajcxy jadu'n nej padyii, mɨɨd co tüg'ócɨy tijaty yɨ' ymɨɨd huɨdibɨ ytaj yteedy jë'adánɨp, hue' tɨ ahuanɨ̈y nɨgoo ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E pen jadu'n mɨnañ, chi miich ajcxy mɨnaangɨxy co ca' copɨ́cyɨty mbubéjtcɨxɨpy mdaj mdeedy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Miich ajcxy mɨdundɨgooyb Dios ycötújcɨn mɨɨd mgostumbre huɨdibɨ myajnajxyp myajtɨgɨɨyb, etz jacjadyii jɨbɨc-huinma'ñ myaj'ixpɨ́jccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jadüg'oc Jesús mɨjhuoy yɨ mayjäy ajcxy, e chi nɨmay: ―Mɨdo'mbɨ́jccɨx miich ajcxy ɨɨch n'ayuc, e mhuinjɨhuɨ̈huɨp ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ca' yɨ' yajpocycähuɨɨyb huɨdibɨ jäy ajcxy ypɨdacy ma yhuin y'ahuac. Yɨ' janchtɨy huɨdibɨ pɨdzɨm ma jäy ajcxy yjot yhuinma'ñ, yɨ' yɨ' yajpocycähuɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Miich ajcxy mmɨɨd mdätzac, mɨdo'mbɨ́jccɨx ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Co Jesús ixmajch je mayjäy, e ytɨjctɨgɨɨy, chi je discípulos ajcxy yaj'amɨdoohuɨ nej yhuimbɨdzɨmy jada ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chi Jesús ydiscípulos ajcxy nɨmay: ―¿Nej nañ jadu'n miich ajcxy ca' mhuinjɨhuɨ̈y jada ayuc? ¿Nej ca' mhuinjɨhuɨɨygɨxy co huɨdibɨ tɨgɨɨy ma yɨ jäy y'ahuac (yɨ caayɨn uucɨn), ca' yɨ' yajpocycäy yɨ jäy? ");
INSERT INTO mcoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yɨ caayɨn uucɨn hue' yɨ jäy ypɨdägy ma y'aa ymoox ca' nan ma yjot yhuinma'ñ, e co ñax ma y'aa ymox, chi ypɨdzɨmnɨ. Co Jesús jadu'n ymɨna'ñ, chi nejhuɨɨyɨm co Dios ca' capx'aducy ni ti caayɨn ni ti uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","E Jesús yjacmɨnañ: ―Dios yajpocycähuɨp jäy ajcxy mɨɨd huɨdibɨ pɨdzɨmb ma ajcxy yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ma yɨ jäy ajcxy yhuinma'ñ jiiby chooñ jɨbɨc-huinma'ñ; jiiby chooñ mɨgapxtɨgoyɨɨ töxyjäy yhuinma'ñ; jiiby chooñ je tundɨgooyɨɨ yëydɨjc mɨɨd töxyjäy etz töxyjäy mɨɨd yëydɨjc huinma'ñ; jiiby chooñ jäyyaj'ögɨɨ huinma'ñ; jiiby chooñ meedzɨɨ huinma'ñ; jiiby chooñ mügɨɨ huɨdidɨɨ huinma'ñ; jiiby chooñ jɨbɨc-huinma'ñ; jiiby chooñ je huin'ɨɨnɨɨ huinma'ñ; jiiby choñ nayca'oy'ixɨɨ huinma'ñ; jiiby chooñ je piitzcapxɨɨ huinma'ñ; jiiby chooñ je amɨj agɨx huinma'ñ; jiiby chooñ je tzuu huinma'ñ je locɨ huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yɨ jadu'mbɨ jɨbɨcpɨ jiiby chooñ ma jäy ajcxy yjot yhuinma'ñ, paady jɨbɨcpɨ jäy ajcxy túngɨxy, e ypocycäy ajcxy ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chooñ Jesús ma yɨjɨmbɨ it, e ñɨcxy jɨm ma Tiro etz Sidón ñaaxjot. Jesús ytɨgɨy ma tüg jäy ytɨjc, e ca' anajty tzocy co je mayjäy ñejhuɨ̈huɨɨyb ma y'ity. Per ca' jajty nɨcx yhuingoyüch. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mɨc'amy tüg töxyjäy nejhuɨɨy ma Jesús anajty yajpaady. Hue' je töxyjäy ypi'cnɨɨx ymɨɨd anajty ca'oybɨ. Je töxyjäy ymiiñ ma Jesús, e ycojxtɨnay'ahuɨy ma yɨ' yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Je töxyjäy hue' anajty ycogájpɨty Sirofenicia (e hue' anajty griegojäy). Yɨ töxyjäy may'ajt pɨjctzoy ma Jesús co huen yajpɨdzɨmy je ca'oybɨ ma ypi'cnɨɨx yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chi Jesús je töxyjäy nɨmay: ―Ooy ycopɨ́cyɨty co nbubedɨpyɨch jayɨjp Dios yjäy (yɨ judíojäy). Jadu'n nipaady nej tüg ungdeedy. Tɨm copɨcy co je ungdeedy yajcayɨpy jayɨjp ycɨ'm ung, e ca' möhuɨp uc je huɨdibɨ y'ung yajjɨcxaamy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chi je töxyjäy y'adzooy: ―Huindzɨn, tɨy'ajt nej miich mmɨna'ñ, per nañ jadu'n yɨ uc ajcxy yjɨɨcxyp je caagy abu'x huɨdi cäb naaxcɨ́xy ma mesɨpa't ma je jäy y'ung ajcxy ycaay. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chi Jesús je töxyjäy nɨmay: ―Tɨy'ajt jadu'n nej ɨɨch miich tɨ xy'adzooy, paady ycɨxpɨ jëb mhuimbidɨpy ma mdɨjc jotcujc, je ca'oybɨ tɨ ypɨdzɨmy ma mnɨɨx yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Co je töxyjäy huimbijty ma ytɨjc, chi paty ypi'cnɨɨx cɨjx'am, tɨ anajty je ca'oybɨ ñïbɨdzɨmyii ycöbɨdzɨmyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chi Jesús jɨm tzojcɨ choonɨ Tiro ñaaxjot. Chi chooñ jɨm ñɨcxy anajty Galilea, e nɨcxy ma je tü'aa huɨdibɨ najxp Sidón etz je cajp huɨdibɨ yajpatp jɨm Decápolis ñaaxjot, chi yja'ty ma Galilea mɨj laguunba'. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jɨm ajcxy mɨɨd miiñ tüg jäy huɨdibɨ cönátɨp etz aahuɨ'mb. Chi ajcxy may'ajt pɨjctzooy ma Jesús huen cɨ̈nïxajy je pa'mjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chi Jesús mɨɨdnɨcxy je pa'mjäy ahuingujc ma ca' mayjäy, e pɨdacy ycɨ̈hua'x ma je pa'mjäy ytätzac. Chi chujy, e huin'it nïdonɨ je ytoodz. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chi Jesús ypa't'ijxy tzajpcɨ́x, e ymɨcxejy, e chi ymɨnañ Aramaico'amy: ―Efata ―jada ayuc hue' yhuimbɨdzɨmy: Ahuädz. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E mɨc'amy je jäy cönatpɨ ytätzac y'ahuaach etz ytoodz yungɨɨy etz ycapxnɨ yajxon. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chi Jesús ane'my je pa'mjäy etz ymɨgügtɨjc co ca' huaad ni pɨn yajmɨɨdmɨydägɨpy jadu'n nej anajty tɨ chögy. Co Jesús jadu'n mɨctägy ane'my co ca' huaad ni pɨn yajmɨɨdmɨydägɨpy je mɨjhuinma'ñ huɨdibɨ ytumyb, chi nïgɨ je pa'mjäy etz ymɨgügtɨjc mɨɨdmɨydaaccɨxy hueñypɨ́nɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Je mayjäy ooy tzachjɨhuɨy huinmay ajcxy, ñayñɨmaayɨ ajcxy miñ xyɨpy: ―Jada Jesús ooy oy chachtuñ. Ymɨmadactaayb yɨ'huenytɨmytíijɨty, ixtɨ yajmɨdohuɨ̈cpy yɨ' yɨ cönatpɨ etz yajcapxɨ̈gy yɨ uumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Je huin'it xɨɨ je huin'it tiempo mayjäy anajty tɨ ñaymújcɨgɨxy ma Jesús yajpaady, e ca' anajty je mayjäy ajcxy mɨɨdɨty ti ycáaygɨxɨpy y'úuccɨxɨpy. Jesús capxyñiguejxy je' ydiscípulos ajcxy, co huen miingɨxy ma yɨ' yajpaady. Co ajcxy ymiiñ, chi nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ooy nba'ayooyɨch yɨ mayjäy. Yɨ' co cham mɨdugɨɨg xɨɨ maabɨ ya mɨɨd y'ityɨch je mayjäy, e ni ca' ajcxy mɨ́ɨdɨty ti ycayɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Co ixyipy nguexhuimbityɨch ajcxy ma ytɨjc ayuu, ca' yjécyɨty yajpa'mgójɨpy ajcxy tü'am, com nijëjɨty ajcxy jɨguëgy tɨ choongɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chi je discípulos ajcxy Jesús adzooy: ―¿Ma ɨɨch ajt nbaatɨm je caayɨn uucɨn huɨdibɨ jëb mɨɨd nyajcaayɨm nyaj'úucɨm jada mayjäy? Com mɨjtɨgɨ̈duum ya nyajpaatɨm ma ca' pɨn chɨnäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chi Jesús y'amɨdooy je' ydiscípulos ajcxy: ―¿Naag tzajcaagy miich ajcxy mɨɨdɨty? Chi je' ajcxy y'adzooy: ―Huɨxtujc tzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chi Jesús ane'my je mayjäy, co huen ɨñay'ahuɨɨygɨxy naaxcɨ́xy. Huin'it Jesús conɨ̈gy je huɨxtujcp tzajcaagy, e yajnajxy Dioscojuyɨp ma Dios mɨɨd tzajcaagy ycɨxpɨ. Chi tujc-huäcxy je tzajcaagy, e moy je' ydiscípulos ajcxy, e je' ydiscípulos ajcxy yajhuäcxy je tzajcaagy ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Je Jesús ydiscípulos ajcxy ymɨɨd anajty nijëjɨty pi'c acx. Chi Jesús yajnajxy Dioscojuyip ma Dios mɨɨd je pi'c acx ycɨxpɨ, e moy je' ydiscípulos ajcxy huen yajhuäcxtaygɨxy ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chi je mayjäy nidüg'ócɨy ycay cüxyɨ, e co ajcxy ycayday, chi je Jesús ydiscípulos ajcxy yajpɨdɨ̈gy huɨxtujc cach cayduc jɨɨcxtuc tɨɨbɨ anajty yconaxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jahueenɨ anajty ycamɨdaaxmilɨty je jäy huɨdibɨ ajcxy cay uuc cüxyɨ. Chi Jesús ycapxy ycɨjxy mɨɨd je mayjäy, e nɨmay ajcxy co huen nɨcxcɨxy ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E mɨc'amy Jesús ybarcotɨgɨy mɨɨd ydiscípulos ajcxy, e chi ñɨcxy ajcxy jɨm Dalmanuta ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nijëjɨty fariseos ajcxy, je huindzɨndɨjc huɨdibɨ padumb judío ycostumbre, ymiiñ ajcxy ma Jesús yajpaady, e ytɨgɨy ajcxy ijxquípxcɨxy y'ixpɨjcɨn mɨɨd Jesús. Pɨjctzoogɨxy co Jesús huen yaj'ixyii ajcxy tüg ijxpejt huɨdibɨ tzomb tzajpjoty. Ijxta'n octunaangɨxy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chi Jesús tajy may ñayjɨhuɨɨyɨ jotjoty huinma'ñyjoty, chi ymɨcxejy, e ymɨnañ: ―¿Na'amy co jada jäy ajcxy huɨdibɨ jugy'ajtp cham, pɨjctzoogɨxy ijxpejt huɨdibɨ tzomb tzajpjoty? Janch ɨɨch miich nɨmaaygɨxy co ca' nyaj'ixaangɨxy ijxpejt huɨdibɨ tzomb tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E Jesús ytɨmycapxycɨ́xy mɨɨd je fariseos ajcxy, e chi puyöyduuty ajcxy. Chi Jesús ybarcotɨgɨɨy, e ñɨcxy mɨɨd ydiscípulos ajcxy ma mɨj laguun ñïnaxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Je' ydiscípulos ajcxy tɨ anajty jaydɨgoygɨxy je jɨɨcxy pɨcy co ajcxy ybarcotɨgɨy. Jëyɨ ajcxy mɨmiiñ tüg pi'c tzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chi Jesús ane'myb je' ydiscípulos ajcxy, e ymɨnañ: ―Ca' mmɨjpɨdaaccɨxy yɨ fariseojäy ajcxy y'ayuc ytɨy'ajt etz ni rey Herodes y'ayuc ytɨy'ajt, com jadu'n ajcxy y'ayuc nipaady nej levadura huɨdibɨ ca' y'óyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","E je Jesús ydiscípulos ajcxy nimɨydaaccɨxy Jesús y'ayuc ñayñɨmáayɨgɨxy ajcxy miñ xyɨpy: ―Je' co ca' ɨɨch ajt nmɨmiinɨm caayɨn uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E Jesús ñejhuɨɨyb anajty nej je' ydiscípulos ajcxy ñayñɨmaayɨ miñ xyɨpy, paady ymɨnañ: ―¿Na'amy co mdzachnimɨydaaccɨxy je caayɨn uucɨn huɨdibɨ tɨ mjäydɨgooygɨxy? ¿Nej ca' mhuinjɨhuɨɨygɨxy e ca' mguendɨtungɨxy ɨɨch n'ayuc? ¿Nej co ajcxy mdzachcöjuuñɨty? ");
INSERT INTO mcoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miich ajcxy mɨɨd mhuiin: ¿Nej co ca' m'ijxcɨxy huɨdibɨ ndumybɨch? Miich ajcxy mɨɨd mdädzac: ¿Nej co ca' mmɨdo'mbɨ́jccɨxy ɨɨch n'ayuc? ¿Nej co ca' mjäyméjtzcɨxy ti tɨ nduñɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jayhuin co ndujc-huäcxyɨch je mɨgooxpɨ tzajcaagy e nyajcaayɨch mɨgoox mil jäy: ¿Naag cach cayduc jɨcxtuc tɨ ajcxy myajpɨdɨ̈gy? Chi ajcxy y'adzooy: ―Hue' ɨɨch ajcxy nyajpɨdɨ̈gyɨch majmetz cach cayduc jɨcxtuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chi Jesús ymɨnañ: ―E jayhuin co ndujc-huäcxyɨch je huixtujcpɨ tzajcaagy, e nyajcaayɨch mɨdaax mil jäy: ¿Naag cach cayduc tɨ ajcxy myajpɨdɨ̈gy? Chi ajcxy y'adzooy: ―Hue' ɨɨch ajcxy nyajpɨdɨ̈gyɨch huixtujc cach cayduc jɨcxtuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chi Jesús ymɨnañ: ―¿Nej chambaad miich ajcxy ca' mhuinjɨhuɨɨy? ");
INSERT INTO mcoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús etz ydiscípulos ajcxy oy yjá'tcɨxy jɨm Betsaida. Jɨm Betsaida nijëjɨty jäy mɨɨd miiñ ma Jesús tüg huintzpɨ, e pɨjctzoy ajcxy may'ajt co huen nïdoñ jɨgɨx je huintzpɨ y'ijxɨ̈gɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Huin'it Jesús huijtztzooñ je huintzpɨ ma ycɨ', chi mɨɨd cajppɨdzɨmy. E chi Jesús yajjaaxy yɨ chujyñɨɨ je huintzpɨ yhuiin, etz cɨ̈nïxajy, e chi amɨdoy pen y'ijxpy anajty tigati yinjaty huenjaty. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chi je huintzpɨ huindɨcxpejty Jesús, e nɨmay: ―N'ijxypɨch yëydɨjctɨjc, e jadu'n ajcxy yquëxɨ̈gy nej quipy, per yöyp ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","E jadüg'oc Jesús ycɨ' pɨdacy ma je huintzpɨ yhuiin, e chi je huintzpɨ yhuindɨcxpejtpy anajty, e chi yhuiin y'oyɨɨy yajxon, huin'it oy huädz y'ijxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E Jesús ycapxycɨ́jxy mɨɨd je', e quejxhuimbijty ma ytɨjc. Chi ymɨnañ: ―Ca' mdɨgɨ̈huɨp cajpjoty, e ni pɨn jada mgayajmɨɨdmɨydägɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chi Jesús ñɨcxy mɨɨd ydiscípulos ajcxy jɨm ma nijëjɨty mutz cajp mɨhuingon je mɨj cajp Cesarea Filipo. E tü'am Jesús amɨdoy ajcxy ydiscípulos, nɨmay: ―¿Nej jäy ymɨnaangɨxy pɨn ɨɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chi ajcxy je' ydiscípulos y'adzooy: ―Nijëjɨty jäy ymɨnaangɨxy co miich je' je Juan, je Bautista. E nijëjɨty ymɨnaangɨxy co miich je' je Elías. E jacjadyii ymɨnaangɨxy co miich je' tüg Dios y'ayucnajtzcapxɨɨybɨ huɨdibɨ tügɨɨyb mɨɨd nijëjɨty Dios ytɨy'ajtmɨɨdpɨ huɨdibɨ tzɨnaay jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús y'amɨdooy je' ydiscípulos ajcxy: ―Miich ajcxy, ¿nej miich mmɨnaangɨxy pɨn ɨɨch? Chi Pedro y'adzooy: ―Miich je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chi Jesús nɨmay je' ydiscípulos ajcxy co ca' huaad ni pɨn nɨmaaygɨxy, co yɨ' je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chi Jesús jacyaj'ixpɨjcy je' ydiscípulos ajcxy, e ymɨnañ: ―Copɨcy co ɨɨch, je jäy huɨdi tzoon tzajpjoty, nyajnaxɨpyɨch mɨj tzaachpyɨ etz mɨj ayo'n. Yɨ mɨjjäydɨjc ajcxy, yɨ judío teedy mɨjtungmɨɨdpɨ, etz yɨ escribas, je huindzɨndɨjc huɨdibɨ nïjayduutcɨxyp Dios necy, ca' ajcxy xy'ixa'ñɨch, e xyaj'öga'ñ ajcxy, e codugɨɨg xɨɨ njugypɨgɨpyɨch jadüg'oc co ɨɨch anajty tɨ n'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Co Jesús jadu'n nigapxy nimɨydacy huädz huädz nej yjada'ñyii anajty, chi Pedro huobɨbzɨmy Jesús ahuingujc, chi ooy ojy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Chi Jesús ni'ijxhuimbijty ydiscípulos ajcxy, e ojy je Pedro, ñɨmay: ―Huinhuäctuutcɨch, miich Satanás. Com miich ca' mhuinma'ñ mbɨdägy nej Dios tzocy. Yɨ' janchtɨy miich mhuinma'ñ'ajtpy nej jäy ajcxy tzocy. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Huin'it Jesús huoomiñ yɨ' ydiscípulos ajcxy etz yɨ mayjäy, e chi nɨmay: ―Pen ji pɨnjaty xypanɨcxa'ñɨch, huen jäydɨgoydäy ycɨ'mdzójcɨn etz huen xypanɨcxɨch jabom jabom. Oy nej ytɨmyjadɨpy ytɨmy'ayoohuɨpy. Jadu'n nipaady nej jɨhuɨ̈y ajcxy anajty mgruudz mgabɨ̈ccɨxy, etz naygɨ̈yéjcɨgɨxy ma yɨ ó'cɨn huen ytɨmyñéjɨty mɨɨd ɨɨch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Huenpɨnjäy huɨdibɨ ca' yega'ñ yɨ yjugy'ájtɨn ma yɨ ó'cɨn mɨɨd ɨɨch ycɨxpɨ, hue' je' yajtɨgoyamy yɨ'yjugy'ájtɨn. E huenpɨnjäy huɨdibɨ yegamy yjugy'ájtɨn ma yɨ ó'cɨn mɨɨd ɨɨch ycɨxpɨ etz ɨɨch y'ayuc oybɨ ycɨxpɨ, hue' je' ypadamyb yɨ jugy'ájtɨn huɨdibɨ ca' cɨxɨpy tɨgoyɨpy ni mɨnaa. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ti oy'ájtɨn yɨ' co tüg jäy y'ocnayyajpadɨɨyb yɨ meeñ etz mɨc'ájtɨn (huɨdi yajpaatp ya ñaaxhuiñybɨ) e y'alma yjugy'ájtɨn cɨxɨpy tɨgoyɨpy tügcɨ̈y? ");
INSERT INTO mcoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Jadu'ñyɨ jëb jäy y'alma yjugy'ájtɨn occojuyɨ? Nïgɨ tzoohuɨn mɨɨdɨty jäy ajcxy y'alma yjugy'ájtɨn, ca' jac ti. ");
INSERT INTO mcoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Huentɨmpɨ́nɨty yɨ huɨdibɨ xymɨdzo'ydúnɨbɨch yɨ n'ayucɨch ndɨy'ájtɨch ma yɨ pocyjäydɨjc yhuinduu huɨdibɨ tzɨnaayb cham ma jada naaxhuiñybɨ. Pues nañ jadu'n ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, nmɨdzo'ydúnɨbɨch yɨ jadu'mbɨ jäy co ɨɨch anajty nhuimbity ya naaxhuiñybɨ mɨɨd ɨɨch nDeedy, je Dios Teedy, ymɨc'ajt y'oy'ajt etz mɨɨd tüg'ócɨy yɨ may'ángeles ajcxy tudägypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jadu'n Jesús yjacmɨnañ: ―Janch tɨy'ajt jadu'n nej ɨɨch miich ajcxy cham nɨmäy, co nijëjɨty miich ajcxy huɨdibɨ cham ma ɨɨch nhuinduu, ca' m'ögaangɨxy, ixtɨ coonɨ ajcxy jayɨjp m'ixɨpy je Dios y'ané'mɨn etz ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Co tuctujc xɨɨ naxy, chi Jesús mɨɨd tzooñ Pedro, Santiago etz Juan, e mɨɨdpa'ttɨgɨɨy ma tüg mɨjcop ma tüg it ooy ycɨ́xɨty. E jɨm copcɨ́xy Jesús ñinïcx naygojtɨgajtznɨ ma Pedro ajcxy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Chi Jesús yhuit oy y'ahuimbity janch poob, e janch adɨɨcxp. E ni pɨn jadu'n yhuit cayajhuäch janch poob jadu'n nej je' anajty yhuit mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","E chi oy nayguëxɨ̈gyii ma ajcxy yhuindu Elías etz Moisés. Elías etz Moisés mɨydacp anajty ajcxy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Huin'it Pedro nɨmay Jesús: ―Huindzɨn, janch oy jadu'n co ɨɨch nyáajɨty. N'occojyɨch ajcxy tugɨɨg tɨjcquemy: tüg miich mje'; tüg Moisés yje'; etz tüg Elías yje'. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Com Pedro, Jacobo etz Juan ooy anajty chɨgɨɨygɨxy, paady Pedro ca' anajty nejhuɨ̈y ti ycapxyp. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tɨm huin'ítɨy tüg joc yajnïdɨgoy je' ajcxy, e mɨdooy ajcxy ayuc jocjoty, e je ayuc ymɨnañ: ―Jada je' ɨɨch n'ung, huɨdibɨ ooy ndzocyɨch. Mɨdo'mbɨc miich ajcxy Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","E tɨm huin'ítɨy Pedro, Jacobo etz Juan ajcxy yujc'ijxy, e yja'ijxhuɨdijty ajcxy, e ca' ni pɨn ma ocjac'ijxnɨ, jëda'ajty Jesús naydügpajc. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","10","Tɨ anajty choongɨxy copcɨ́xy, e cɨdacp anajty ajcxy, co Jesús nɨmay Pedro, Jacobo etz Juan, co ca' huaad yajmɨɨdmɨydaaccɨxy pɨnjaty huɨdibɨ ajcxy anajty tɨ íjxcɨxy, ixtɨ coonɨ ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, n'ögɨbɨch etz njugypɨgɨpyɨch jadüg'oc. Pedro, Jacobo, etz Juan ca' yjacmɨydägy mɨɨd jacpɨnjaty huɨdibɨ anajty tɨ íjxcɨxy. Per ooy ajcxy huinmay etz naymɨɨdmɨydáacɨgɨxy miñ xyɨpy ti Jesús ytijamy co ymɨnañ: “N'ögɨbɨch etz njugypɨgɨpyɨch jadüg'oc.” ");
INSERT INTO mcoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Huin'it ajcxy Jesús y'amɨdooy: ―¿Na'amy co yɨ escribas ymɨna'ñ co yɨ Elías huɨdibɨ chɨnay jecy'ajty jayɨjp miina'ñ ca'ydɨ je Cristo? ");
INSERT INTO mcoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chi Jesús y'adzooy: ―Tɨy'ajt jadu'n co miñ jaybety ma Dios ñecy jecy'ajty co Elías yhuimbidɨpy jacjayɨjp ca'ydɨ je Cristo, e yaj'oyɨydähuɨpy huinjemybɨ tüg'ócɨy mɨɨd Dios ycɨxpɨ. E nañ tɨy'ajt jadu'n co jaybety ymiiñ ma Dios ñecy co je Cristo, je jäy huɨdib tzoon tzajpjoty, yajnaxa'ñ ayo'n etz tzaachypɨ etz mayjäy ca' y'ixa'nɨɨby. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ɨɨch miich ajcxy nɨmaayb co je Elías tɨ je' yhuimbity ya naaxhuiñ, e je mayjäy tɨ túngɨxy mɨɨd Elías nej anajty tɨm tzójcɨxy. E cuyduñ ajcxy nej jaybety miiñ ma Dios ñecy mɨɨd Elías ycɨ́xpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Co Jesús, Pedro, Jacobo etz Juan yhuimbity ma je jacjadyii Jesús ydiscípulos ajcxy anajty tɨ yhuɨ'mɨ̈y, chi ajcxy ijxy mayjäy jühuɨdity ma Jesús ydiscípulos ajcxy. Etz ijxy ajcxy nijëjɨty escribas huɨdibɨ ayuc tzachyajtzibɨɨyb mɨɨd Jesús ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","E co je mayjäy íjxcɨxy nejhuɨɨygɨxy co Jesús tɨ yhuimbity anajty, chi mɨc'amy ajcxy ninɨcxy Jesús poyɨ̈gy, e capxpoocxcɨxy, e may je' ajcxy ooy jɨhuɨy huinmay. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chi Jesús y'amɨdooy je mayjäy, nɨmay: ―¿Ti ayuc miich ajcxy mdzachyajyomyb mɨɨd ɨɨch ndiscípulos ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chi nidüg je jäy ajcxy y'adzooy: ―Huindzɨn, tɨ nmɨɨdmiiñ ɨɨch nmang huɨdibɨ ymɨɨd ca'oybɨ, e je ca'oybɨ tɨ yaj'umɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","E janam jadzojc je ca'oybɨ yajyachyii yajquïdyii ɨɨch nmang, e oy cäy naaxcɨ́xy, e ooy y'aa'opy ypɨdzɨmy, e nañ jadu'n oy ytɨɨtz queety etz ñinïcx janch ögy yhuɨ'my. Tɨ nbɨjctzoyɨch may'ajt mɨɨd miich mdiscípulos ajcxy co huen yajpɨdzɨmgɨxy je ca'oybɨ ma ɨɨch nmang, e ca' ajcxy ymadacy nɨcxy yajpɨdzɨmgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús nɨmay je mayjäy: ―Miich ajcxy huɨdibɨ jugy'ajtp jadachambɨ xɨɨ tiempo huɨdibɨ ca' mɨjpɨdägy Dios y'ayuc, ¿naag xɨɨ naag po' ɨɨch njac-huɨ'mmɨ̈huɨbɨch mɨɨd miich ajcxy? ¿Naag xɨɨ naag po' n'ocmɨmecxtuguipɨch miich ajcxy? Mɨɨdmiin yɨ mmang ya ma ɨɨch nhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chi ajcxy mɨɨdmiñ je pa'mjäy ma Jesús yhuinduu. E co je ca'oybɨ ijxpaady Jesús, chi mɨc'amy yajyajch yajquïdy je pa'mjäy, e chi oy cɨday naaxcɨ́xy, e ooy yajch yquïdy, yajpɨdzɨmy ooy y'aa'opy ma y'ahuac. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","Jesús y'amɨdooy je pa'mjäy yteedy: ―¿Mɨnaag jɨmɨjt cujc yöy maabɨ mmang ypa'mbety? Chi je ungdeedy y'adzooy: ―Ma'xung anajty co pa'mbedyii. Canaag'oc je ca'oybɨ yajyachyii yajquïdyii ɨɨch nmang, ixtɨ tɨ oy ycogɨdahuɨ̈y jɨɨnjoty etz nɨɨjoty. Je ca'oybɨ canaag'oc jayaj'ögy ɨɨch nmang. Pen miich mɨɨd tzöc'ajt mɨc'ajt jaydëb xypubedɨpyɨch, tun may'ajt pa'ayoogɨch etz pubejtcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chi Jesús y'adzooy nɨmay je pa'mjäy yteedy: ―Pen miich mɨbɨjcpɨ, ca' ti chípɨty ma pɨn mɨbɨjcp. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mɨc'amy je pa'mjäy yteedy mɨc ycapxy ymɨnañ: ―Nmɨbɨjcyɨch, pubéjtcɨch nej huaad jacmɨj nmɨbɨcyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","E co Jesús ijxy co nïgɨ mayjäy chach ymiiñ poyɨ̈gy ma yɨ', chi ix'ojy je ca'oybɨ, e ymɨnañ: ―Miich ca'oybɨ huɨdib tɨ yajhuɨ'my jada pi'c'anäg uum etz nat, ɨɨch miich yam n'ane'myb: “Pɨdzɨm ma yɨ pa'mjäy, e ca' mjactɨgɨ̈huɨpy ma yɨ' yjot yhuinma'ñ jadüg'oc.” ");
INSERT INTO mcoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jayɨjp je ca'oybɨ yaaxqueecy janch mɨc, yajyajch yajquïdy je pa'mjäy. Co jadu'n tuñ, chi ypɨdzɨmy. Je pa'mjäy oy ñinïcx yhuɨ'my nej jɨhuɨ̈y tɨ y'o'cnɨ. Je mayjäy huɨdibɨ anajty ajcxy jɨm huindɨcxp ymɨnaangɨxy: ―Tɨ ayoob y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Chi Jesús majtz je pa'mjäy ycɨ', e yajpɨdɨ̈gy e huin'it je pa'mjäy ytɨnayɨ̈gy mɨc oy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Co Jesús ytɨgɨɨy ma tüg tɨjc, chi je' ydiscípulos ajcxy y'amɨdou ameech, minañ ajcxy: ―¿Na'amy co ɨɨch ajcxy ca' tɨ nmadägyɨch nej nyajpɨdzɨmɨp ɨɨch ajcxy yɨ ca'oybɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chi Jesús y'adzooy: ―Yɨjiibɨ ca'oybɨ ca' yɨ' huaad ypɨdzɨmy jadu'ñyɨ. Hue' janchtɨy copɨcy mɨbɨjctzou Dios mɨctägy, e huin'it ypɨdzɨmɨpy je ca'oybɨ ma je pa'mjäy. Ca' jac ni nej huaad ypɨdzɨmy yɨ jadu'mbɨ ca'oybɨ, jëyɨ co Dios nmɨbɨjctzoohuɨm n'íjtɨm ayuu. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chi Jesús mɨɨd yɨ' ydiscípulos ajcxy choñ ma je jɨmbɨ it, e yajyöyñajxtay ajcxy Galilea naaxjot. Jesús ca' anajty tzocy co je mayjäy ñejhuɨ̈huɨɨyb ma yɨ' ñɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Com Jesús hue' anajty yaj'ixpɨcy yɨ' ydiscípulos ajcxy, co ooy ycopɨ́cyɨty co yɨ jäy huɨdibɨ tzoon tzajpjoty, yajcɨ̈yegɨpy ma yɨ ymɨdzip, etz yaj'ögɨɨyb, e co anajty tɨ y'ögy codugɨɨg xɨɨ jadüg'oc yjugypɨgɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jesús ydiscípulos ajcxy ca' huinjɨhuɨ̈y anajty Jesús y'ayuc, e nañ jadu'n tzɨgɨɨyb anajty ajcxy co Jesús yaj'ójɨp, paady ca' ajcxy amɨdoy nej huimbɨdzɨmy yɨjiibɨ ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","E Jesús mɨɨd ydiscípulos ajcxy oyjäty jɨm Capernaum. Co ajcxy ytɨjctɨgɨɨy, chi Jesús yaj'amɨdoy ydiscípulos ajcxy, nɨmay: ―¿Ti ayuc miich ajcxy naymɨɨdmɨydáacɨgɨxy jɨm ma anajty mdüyöygɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per amonday ajcxy, com jëgɨxpɨ co anajty ajcxy ooy tɨ ñaymɨɨdmɨydáacɨgɨxy tüyöyjoty co pɨn jada' ajcxy nidügtɨ ocjaccopɨ́cyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Huin'it Jesús y'ixtacy, e chi mɨjhuoy je nimajmetzpɨ ydiscípulos ajcxy, chi ajcxy nɨmay: ―Pɨn nayyajnaxaanɨp mɨj, huen ity nej jɨhuɨ̈y ca' ytiijɨty e huen capxmɨdoy ymɨgügtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chi Jesús tzenɨ̈gy tüg pi'c'anäg, e chi pɨdacy cujc'amy ma yɨ' ydiscípulos ajcxy. Chi tzenɨ̈gy jadüg'oc, e nɨmay ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Pɨn cöbɨjc tügpajc pi'c'anäg jadu'n nej jada pi'c'anäg mɨɨd ɨɨch nxɨɨ ycɨxpɨ, ɨɨch yɨ' anajty tɨ xycöbɨcyɨch, e pɨn ɨɨch xycöbɨjcpɨch, ca nan ɨɨch anajty naydügpajc tɨ xycöbɨjcyɨch, nañ jadu'n anajty tɨ cöbɨcy huɨdi tɨ xyquejxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan Jesús nɨmay: ―Huindzɨn, tɨ ɨɨch ajcxy n'ijxpaady tüg jäy co ca'oybɨ yajpɨdzɨmy mɨɨd miich mxɨɨ, e tɨ ngapx'aducyɨch mɨɨd co ca' yɨ' ɨɨch ajt xypahuɨdíjtɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Per Jesús ymɨnañ: ―Ca' mgapx'adugɨpy yɨ jadu'mbɨ jäy, com huenpɨ́nɨty huɨdibɨ mɨjhuinma'ñ tumb mɨɨd ɨɨch nxɨɨ, ca' yɨ' jɨbɨc xyñigapxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Com yɨ huɨdibɨ ajt ca' xymɨdzip'ájtɨm, yɨ' yɨ' mɨɨd ɨɨch ajt nbɨdzɨ́mɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Janch janch ɨɨch miich ajcxy jadu'n nɨmäy co huenpɨnjäy huɨdibɨ ixyipy miich ajcxy xyajnɨɨ'uucp tüg vaso nɨɨ mɨɨd co miich ajcxy tɨ mmɨjnɨcxpety je Cristo, yɨ jadu'mbɨ jäy ypadamy yɨ' y'oy'ájtɨn ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Huenpɨ́nɨty huɨdibɨ jɨbɨc-huinma'ñ mɨbɨdzɨmb, e yajpocycäy yɨ jadu'mbɨ pi'ctɨjc huɨdibɨ ajcxy xymɨjnɨcxpejtpɨch, jac'oy ixyipy co yɨ jadu'mbɨ jäy ytɨmyñayyajyöcxodzɨ̈yii tüg paandzaa etz ñayñajtzjɨbibɨ̈huɨɨyb mejyjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pen miich mgɨ' xyajtundɨgoyamb jac'oy co mdɨm'ixpuxɨpy, com jac'oy co mdɨgɨ̈huɨpy ma yɨ jugy'ájtɨn huinɨxɨɨbɨ cɨ̈duc, ca'ydɨ co Dios xypɨdägɨp mɨɨd metz mgɨ' jiiby jɨɨnjoty ca'oydactuuby, ma yɨ jɨɨn ni camɨna ycapïch. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jiiby ca'oydactuuby yɨ ucxytɨng ca' y'ögy etz ni jɨɨn ycapïch nicamɨnaaxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","E pen miich yɨ mdecy xyajpocycähuamb, ixpux, com jac'oy co mdɨgɨ̈huɨp ma yɨ jugy'ájtɨn huinɨxɨɨbɨ tecytuc ca'ydɨ co mdɨgɨ̈huɨp mɨɨd metz mdecy jiiby ca'oydactuuyb, ma yɨ jɨɨn ni camɨna ycapïch. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jiiby ca'oydactuuby yɨ ucxytɨng ca' y'ögy etz ni jɨɨn ycapïch ni camɨnaxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","E pen yɨ mhuiin tüg xyajpocycähuamb, tɨm yajpɨdzɨm, jac'oy yɨ' co mdɨgɨ̈huɨp ma yɨ Dios y'ane'mdac mɨɨd tügpajc mhuiin, ca'ydɨ co mdɨgɨ̈huɨp ca'oydactuuby mɨɨd metz mhuiin. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ma yɨ ucxytɨng ni camɨnaxɨɨ yca'ögy etz yɨ jɨɨn ni camɨnaxɨɨ ycapïch, ");
INSERT INTO mcoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","e ma nidüg'ócɨy ñi'cägooda'ñ jɨɨn xut jɨɨn ye'n tɨm jadu'n nej jäy tzüch caan xɨducy. ");
INSERT INTO mcoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yɨ caan ooy yɨ' y'óyɨty, pen ymɨɨd xücx'ájtɨn. Co je caan ytɨgoy yxücx'ájtɨn, ca' ji ni ti huɨdibɨ jëb mɨɨd nyajxücxɨɨyɨm. Mɨɨd'ájtcɨx ɨɨch n'ayuc ma mjot mhuinma'ñ, jadu'n ɨɨch n'ayuc nipaady nej caan, e tzɨna' miich ajcxy jotcujc mɨɨd mmɨgügtɨjc nidüg nidüg. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chi Jesús chooñ jɨm Capernaum, nɨcxy jɨm Judea ñaaxjot ma je it lugar Jordán mɨjnɨɨ nïnaxy xɨɨ ypɨdzɨmy'amy. E mayjäy ooy ñayyöymujcɨ ma Jesús anajty yajpaady. E Jesús yaj'ixpɨjcy je mayjäy jadu'n nej anajty yaj'ixpɨcy'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chi nijëjɨty fariseos ajcxy ñɨcxy ma Jesús anajty yajpaady. Hue' ajcxy yhuinma'ñ pɨdaaccɨxy co anajty Jesús tzu'ixaangɨxy. Chi ajcxy y'amɨdooy, pen huaad tüg yëydɨjc ixmach ytöxyɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chi Jesús y'adzooy, ymɨnañ: ―¿Nej Moisés ymɨna'ñ ma yɨ' ycötújcɨn ñecy? ");
INSERT INTO mcoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chi je fariseos ajcxy Jesús y'adzooy: ―Moisés cötújcɨn yecy co tüg yëydɨjc jëb huaad ixmach ytöxyɨjc, e möhuɨpy ñinecy ñidɨy'ajt co nej ñay'ixmájtzɨgɨxy, e jadu'n anajty tɨ y'oyɨ̈y nej jëb yɨ' ytöxyɨjc ixmach. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chi Jesús ymɨnañ: ―Moisés cojaay jada ycötújcɨn mɨɨd miich ajcxy ycɨxpɨ, co ooy miich ajcxy mdzachcapxycömɨdodaaccɨxy ca' mgapxymɨdohuaangɨxy Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per co je naaxhuiñybɨ chondacy, co Dios oga'n yajcojy tüg'ócɨy tijaty huɨdi ji'ajtp, chi Dios yajcojy yëydɨjc etz töxyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E je yëydɨjc ixmadzɨpy ytaj yteedy etz pudɨgɨ̈huɨpy yɨ ytöxyɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","E je yëydɨjc etz ytöxyɨjc tú'cɨy idaangɨxy. Paady je yëydɨjc tügmucy yajpaady mɨɨd ytöxyɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Com yɨ huɨdibɨ Dios tɨ huijtzmucy, ca' ni pɨn huaad huijtzhuägy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Co Jesús mɨɨd ydiscípulos ajcxy yhuimbijt ma anajty tɨ yjättáccɨxy, chi Jesús ydiscípulos ajcxy yajtɨhuimbijtcɨxy je ayuc huɨdibɨ anajty tɨ yaj'ixpɨcy ma je pɨ́jcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Chi Jesús ymɨnañ: ―Je yëydɨjc huɨdibɨ tɨ ixmach yɨ ytöxyɨjc, e pɨcy mɨɨd huingbɨ, hue' yɨ' anajty ymɨdundɨgooyb yɨ ytöxyɨjc huɨdibɨ mɨɨd jayɨjp ypɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nañ tɨm jadu'n co tüg töxyjäy ixmach je yëydɨjc huɨdibɨ mɨɨd tɨ ypɨcy jayɨjp, e ypɨjctɨgach mɨɨd huingbɨ yëydɨjc, hue' ymɨdundɨgooyb je yëydɨjc huɨdibɨ mɨɨd tɨ ypɨcy jayɨjp. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Je huin'it tiempo jäy ajcxy mɨɨd miñ pi'ctɨjc ma Jesús, jaydëb cɨ̈nïxajy etz conuucxɨp. Co Jesús ydiscípulos ajcxy jadu'n ijxy co jäy ajcxy nimɨjhuägy Jesús mɨɨd ajcxy ypi'c'ung, chi je' ydiscípulos ajcxy ix'ojy je jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Co Jesús jadu'n ijxy nejhuɨɨy nej yɨ' ydiscípulos ajcxy y'ɨdɨ̈ch, chi ojy ajcxy, ymɨnañ: ―Ooy y'óyɨty co je pi'ctɨjc ajcxy xyñimɨjhuägyɨch, ca' miich ajcxy mgapx'aducy. Com yɨ jäy ajcxy huɨdibɨ yajpatp ma Dios y'ané'mɨn, jadu'n ajcxy nipaady nej pi'ctɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Janch ɨɨch miich ajcxy nɨmäy co pɨnjaty huɨdibɨ ca' cöbɨga'ñ Dios y'ané'mɨn, jadu'n nej pi'ctɨjc cöbɨ́jccɨxy Dios y'ané'mɨn, hue' yɨ jadu'mbɨ jäy ajcxy ca' ytɨgɨ̈hua'ñ ma yɨ Dios y'it lugar. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chi Jesús amɨnenmujctay je pi'ctɨjc ajcxy, e chi cɨ̈nïxajɨy etz conuucxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Co Jesús chooñ jadüg'oc, chi ñimiinɨ poyɨ̈gy tüg yëydɨjc, ycojxtɨnay'ahuɨy ma Jesús yhuinduu, e ymɨnañ: ―Miich, oybɨ Huindzɨn, ¿ti huaad ndunɨpyɨch jɨgɨx jëbɨ nbadɨpyɨch jugy'ájtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chi Jesús ymɨnañ: ―¿Na'amy co xyñɨmäyɨch co oy huindzɨn ɨɨch? Dios tügpajc óyɨp, ca' jac ni pɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Miich mnejhuɨɨyb Dios ycötújcɨn huɨdibɨ jadu'n mɨnaam: “Ca' mmɨgapxtɨgoyɨp töxyjäydɨjc; ca' mjäyyaj'ögɨpy; ca' mmeedzɨp; ca' m'ɨɨndaacɨp; ca' pɨn mhuin'ɨɨnɨp; etz myajmɨj'adɨp mdaj mdeedy.” ");
INSERT INTO mcoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chi je jäy Jesús nɨmay: ―Huindzɨn, tɨ nguydundäyɨch jadayaab cötújcɨn ajcxy maabɨ ɨɨch nbi'c'atyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chi Jesús huindɨcxpejty je yëydɨjc mɨɨd tzójcɨn jɨhuɨɨyɨn, e chi nɨmay: ―Per jactɨgoy'ijtnɨ jadügnax. Nɨcx toog tüg'ócɨy huɨdijaty miich mmɨɨd, etz mo' yɨ ayoobtɨjc. Co jadu'n mdunɨpy, chi mbaadɨpy oy'ájtɨn jiiby tzajpjoty. Co jadu'n mdooctähuɨpy tijaty miich mɨɨd, chi minɨp jadüg'oc ma nyajpaadyɨch, e xypanɨ́cxɨbɨch, e mnaybɨdägɨɨb cɨxyjot huinjot oy nej mdɨmyjadɨpy mɨɨd ɨɨch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Co jadu'n je yëydɨjc mɨdoy nej anajty Jesús tɨ ñɨmäyii, chi yhuɨ'my taj may e co ñɨcxnɨ, chi ooy ytajy ymay, com hue' je' anajty ooy ycomeeñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Co Jesús jadu'n ixy co je comeeñybɨ taj may yhuimbijtnɨ, chi huindɨcxpejty je' ydiscípulos ajcxy huɨdibɨ tɨnaayb jühuɨdity ma yɨ', e ymɨnañ: ―Ooy chachtzípɨty co tüg comeeñybɨ ytɨgɨ̈huɨpy ma Dios y'it lugar. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesús ydiscípulos ajcxy ooy tzachhuinmay'ahuɨdity mɨɨd jada ayuc nej Jesús anajty tɨ ymɨna'ñ. Paady Jesús yjacmɨnañ jadüg'oc: ―Miich ajcxy mɨgügtɨjc huɨdibɨ ooy ndzocyɨch, ooy chachtzípɨty co ytɨgɨ̈huɨp ma Dios y'ane'mdac tüg comeeñyjäy huɨdibɨ tzachnijot'ajt ycomeeñ'adɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nïgɨ chípɨty co tüg comeeñ jäy ytɨgɨ̈huɨp ma Dios y'ane'my, ca'ydɨ co tüg camello ñaxɨpy ma tüg xu'ñ'ɨjx yxútɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Co jadu'n ajcxy mɨdoy nej Jesús ymɨnañ, chi ooy ajcxy yhuinmay'ahuɨdijty, e nayñɨmáayɨgɨxy miñ xyɨpy: ―Pen janch tɨy'ajt jadu'n, ¿pɨnjäy jada' huaad jëb y'alma ñïdzögɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Je huɨdibɨ jäy ajcxy ca' ni mɨnaxɨɨ huaad ca' yaj'oyɨ̈y, Dios yɨ' yaj'oyɨ̈huɨp, com mɨɨd Dios ca' yɨ' ni ti chípɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chi Pedro ymɨnañ: ―Huindzɨn, occuendtun, ɨɨch ajcxy tɨ n'ixmajtztäyɨch tüg'ócɨy tijaty anajty nmɨɨdɨch, e ɨɨch ajcxy nbanɨcxpɨch miich. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Chi Jesús y'adzooy, minañ: ―Janch tɨy'ajt nej ɨɨch miich ajcxy nɨmäy co huenpɨ́nɨty huɨdibɨ mɨɨd ɨɨch ycɨxpɨ tɨ ixmach ytɨjc, tɨ ixmach y'uch ymɨgüg ajcxy etz ytaj yteedy, etz ytöxyɨjc, etz y'ung ajcxy, etz nañ jadu'n tɨ ixmach ycam ɨɨch ycɨxpɨ, etz ɨɨch n'ayucɨch etz mɨɨd Dios ytɨy'ajt ycɨxpɨ, yɨ' ypadamy nïgɨ oy'ájtɨn ya naaxhuiñ, ixtɨ ypadamy mɨgo'px jadu'ñyɨ ytɨjc ajcxy, y'uch ajcxy, ytaj ajcxy, y'ung ajcxy, etz ypadamy nïgɨ ymɨj cam, mɨɨd tzaachypɨ mɨɨd ayo'n mɨɨd ɨɨch n'ayuc ycɨxpɨ. Etz nañ jadu'n ma je xɨɨ tiempo huɨdibɨ mimb cɨdacpɨ ypadamy jugy'ájtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ji yajpaady ya naaxhuiñ nijëjɨty jäy huɨdibɨ cömay ijtp, e co yjäty ajcxy tzajpjoty, chi ca' ajcxy cömay ida'ñ. Nañ jadu'n ji yajpaady ya naaxhuiñ nijëjɨty huɨdibɨ ca' cömay y'ity, e co ajcxy yjädɨpy tzajpjoty, chi jiiby ajcxy cömay y'idɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús mɨɨd ydiscípulos tüyöyp anajty ajcxy, hue' anajty ypättɨgɨɨygɨxy jɨm Jerusalén. Jesús jayɨjp anajty ñɨcxy, e je' ydiscípulos ajcxy etz nañ jadu'n mayjäy panɨcxy anajty ajcxy Jesús. Je Jesús ydiscípulos ajcxy ooy chachhuinmay'ahuɨdíjtcɨxy, e jacjadyii jäy huɨdibɨ anajty ypanɨcxy Jesús ooy ajcxy chɨgɨɨygɨxy. Chi Jesús huodzooñ abɨcy je majmetzpɨ ajcxy, e yajmɨɨdmɨydactay je' ajcxy jadu'n nej ytuna'ñyii yjada'ñyii jɨm Jerusalén co anajty ajcxy jɨm yja'tcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús je nimajmetzpɨ nɨmay: ―Miich ajcxy m'ijxpy mnejhuɨɨyb co nnɨ́cxɨm cham jɨm Jerusalén. E jɨm Jerusalén, ɨɨch je jäy huɨdibɨ tzoon tzajpjoty, nyajcɨ̈yega'ñɨch mach ma yɨ Teedy mɨjtungmɨɨdpɨ, etz ma yɨ escribas ajcxy. E chi ajcxy ane'mɨn pɨdäga'ñ co huen xyaj'öcɨxɨch. Nañ jadu'n xycɨ̈yegaangɨxɨch mach ma yɨ' ajcxy huɨdibɨ ca' yjudiojäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yɨ' ajcxy xyñixïgɨpy xyajxïgɨbyɨch, xyhuobɨpyɨch ajcxy mɨɨd coochac, xyhuindzuj xyjɨjptzújɨbɨch ajcxy, e xyaj'ögɨbɨch ajcxy. Codugɨɨg xɨɨ maabɨ anajty xyaj'öccɨxyɨch, chi njugypɨgɨpyɨch jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Huin'it Jacobo etz Juan, yɨ Zebedeo ajcxy ymang, nimɨjhuägy Jesús, nɨmay: ―Huindzɨn, ndzojcpyɨch ajcxy co mdunɨpy may'ajt jadu'n nej yam nɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","E Jesús ymɨnañ: ―¿Ti mdzojcpy co ndunipɨch mɨɨd miich ajcxy ycɨxpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chi ajcxy ymɨnañ: ―Tun may'ajt co anajty mbaady yɨ m'ané'mɨn etz m'oy'ájtɨn, xymöhuɨbɨch yɨ mɨj tung ma m'ané'mɨn jaydëb n'ɨñähuɨbɨch ma miich mmɨjc. Nidügtɨ ɨɨch ajcxy n'ɨñähuɨpy a'oy'amy ma miich etz jadüg anajty'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chi Jesús nɨmay Jacobo etz Juan: ―Ca' miich ajcxy mnejhuɨ̈y ti tɨ mbɨjctzoogɨxy. ¿Nej myajnaxamyb miich ajcxy je tzaachypɨ ayo'n huɨdibɨ nyajnaxaamybɨch, jadu'n nej jɨhuɨ̈y m'üga'ñ ajcxy ɨɨch n'ügy e mbaada'ñ ajcxy ɨɨch nnɨɨbéjtɨn? ");
INSERT INTO mcoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jacobo etz Juan y'adzooy: ―Ɨɨch ajcxy nmɨmadägɨbɨch mɨnaxɨpyɨch nyajnaxɨpyɨch ajcxy yɨ tzaachypɨ huɨdibɨ mmɨnaxamyb myajnaxamyb. Chi Jesús ymɨnañ: ―Janch tɨy'ajt jadu'n nej miich ajcxy mɨna'ñ co mmɨnaxaangɨxy myajnaxaangɨxy yɨ tzaachypɨ jadu'n nej ɨɨch nmɨnaxaamyɨch nyajnaxaamyɨch yɨ tzaachypɨ, tɨm jadu'n nej jɨhuɨ̈y m'ügaangɨxy ɨɨch n'ügy, e mbadaangɨxy ɨɨch nnɨɨbéjtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Per ca' ɨɨch cötújcɨn nmɨ́ɨdɨdyɨch co ɨɨch miich ajcxy nbɨdägɨpy tungmɨɨd, co myajpaadɨp tüg ma ɨɨch nmɨjc a'oy'amy, e jadüg anajty'amy. Hue' janchtɨy Dios Teedy ymɨɨd ni'ixɨ' pɨnjaty tɨ huin'ixy jaydëb yajnɨ́cxɨp je mɨjtung ma ɨɨch n'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Co je jacjadyii Jesús ydiscípulos ajcxy nejhuɨɨy jadu'n nej Jacobo etz Juan may'ajt pɨjctzoy ma Jesús, chi ajcxy ooy mɨjotmäty Jacobo etz Juan. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Per Jesús huomiñ yɨ jacjadyii ydiscípulos ajcxy, e ymɨnañ: ―Jadu'n nej miich ajcxy mnejhuɨɨygɨxy, yɨ jäy ajcxy huɨdibɨ mɨjtungmɨɨd ma je maybɨ naax cajp, mɨc ajcxy ane'my je naax cajp. Nañ jadu'n yɨ' ajcxy huɨdibɨ mɨc'ajt mɨɨd ma je maybɨ naax cajp, mɨc ajcxy ane'my je jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per miich ajcxy ca' mjadú'nɨty nej mɨjtungmɨɨdpɨ ma je maybɨ naax cajp. Pɨnjaty ma miich ajcxy mɨjtung yajnɨcxaamb, copɨcy ñaybɨdägɨɨyb nej tüg tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pɨnjaty miich ajcxy huɨdibɨ nigohuajc'ajtp, copɨcy ñaybɨdägɨɨyb nej tüg tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Com ɨɨch nañ jadu'n, je jäy huɨdibɨ tzoon tzajpjoty, tɨ nmiiñɨch ya naaxhuiñ jaydëb nbubedɨpyɨch yɨ mayjäy ajcxy, e ca' nan yɨ mayjäy ɨɨch xypubedɨpy. Tɨ nmiiñɨch jaydëb nyegɨpyɨch njugy'ájtɨn ma yɨ o'cɨn. E co jadu'n nyegɨpyɨch njugy'ájtɨn ma yɨ o'cɨn, chi ngohua'na'ñɨch yɨ jäy ajcxy y'alma. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chi oy jäty Jesús mɨɨd ydiscípulos ajcxy jɨm Jericó. E co Jesús tzooñ Jericó ytübɨjcy jadüg'oc, chi yɨ' ydiscípulos ajcxy etz janch mayjäy ñɨ́cxcɨxy anajty mɨɨd Jesús. Co ajcxy ycajp pɨdzɨmy, chi tüba'ay anajty yajpaady tüg huintzpɨ huɨdibɨ limosna anajty ypɨjctzooyb jabom jabom. Hue' anajty yxɨɨ Bartimeo, e Timeo anajty xɨɨjɨty yɨ' yteedy. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Co Bartimeo nejhuɨɨy co Jesús je Nazaretpɨ najxp anajty ma je tü'aa, chi mɨc yaaxqueegy ymɨnañ: ―Jesús, David y'ap y'oc, tun may'ajt ɨɨch pa'ayoog. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chi je mayjäy ajcxy ojy je huintzpɨ, nɨmay ajcxy co huen amoñ. Per je huintzpɨ nïgɨ ymɨnan'ɨdɨ̈ch: ―Miich, David y'ap y'oc, tun may'ajt ɨɨch pa'ayoog. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chi Jesús ytɨnayxɨjpy, e ymɨnañ: ―Huomiingɨx yɨ huintzpɨ. Chi je jäy ajcxy oy yajtzoongɨxy je huintzpɨ, nɨmaaygɨxy: ―Jotcugɨ', e pɨdɨ̈g, com Jesús xyaaxtzoob. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chi mɨc'amy je huintzpɨ, najtz'oxɨɨy je ñïbe'ñ, chi ypɨdɨ̈gy, e ninɨcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chi Jesús je huintzpɨ y'amɨdooy: ―¿Ti mdzojcpy ndunɨpyɨch mɨɨd miich ycɨxpɨ? Chi je huintzpɨ ymɨnañ: ―Huindzɨn, ndzójcpyɨch co xyajhuindɨcxɨ̈gɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chi Jesús je huintzpɨ nɨmay: ―Jëb mnɨcxy ma mdɨjc. Com tɨ xymɨbɨcyɨch, paady tɨ mhuindɨcxɨ̈gy. Tɨm huin'ít je huintzpɨ yhuin'oyɨɨy, e yhuindɨcxɨ̈gy, e panɨcxy Jesús co ytübɨjcy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Co Jesús etz je mayjäy oyjá'tcɨxy huingon ma je Jerusalén cajp ma yajpaady mejtz mutz cajp huɨdi xɨɨjɨpy Betfagé etz Betania, huingon ma je cop huɨdibɨ xɨɨjɨp Olivos, chi Jesús quejxy metz ydiscípulos huen nɨcxy jayɨjp. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesús nɨmay je metzpɨ ydiscípulos: ―Nɨcx miich ajcxy ma yɨjɨmbɨ cajp huingonbɨ. Co jɨm mjädɨpy, chi mɨc'amy mbaadɨp tüg burro ycoxóchɨty huɨdibɨ ca' pɨn yaj'ɨñayñɨ chambaad. Coguejtuutcɨx je burro e yajmiingɨx ya ma ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pen jɨm pɨnjaty xy'amɨdoogɨxy: “¿Na'amy co mmɨdzonaangɨxy yɨ burro?” Chi miich ajcxy mnɨmähuɨpy: “Je Huindzɨn (Jesús) yajtunamyb tzojc, e yajhuimbidamy mɨc'amy.” ");
INSERT INTO mcoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chi je metzpɨ ydiscípulos ñɨcxy ma je cajp huingonbɨ, e oypaatcɨxy tüg burro ycoxóchɨty huingon ma tüg tɨjc'aguu. Chi ajcxy coguejtuuty je burro. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ycoguejtuutyp anajty ajcxy je burro co nijëjɨty jäy jɨm huingon ymɨnañ: ―¿Ti mdungɨxyp? ¿Na'amy co mgoguejtuutcɨxy yɨ burro? ");
INSERT INTO mcoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chi je metzpɨ Jesús ydiscípulos je jäy ajcxy yajmɨɨdmɨydacy Jesús y'ayuc nej anajty tɨ ñɨmäyii. Je jäy ajcxy ymɨnaangɨxy co jëb yajnɨ́cxcɨxy je burro. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mɨc'amy ajcxy mɨja'ty je burro ma Jesús yajpaady. Je Jesús ydiscípulos ajcxy jɨɨbe'ñ je burro ajcxy mɨɨd yjocxhuit, chi Jesús yaj'ɨñay je burro. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mayjäy ajcxy ooy yëby yhuit tügujc ma Jesús anajty ñaxa'ñ, e jacjadyii jäy pujxy ajcxy quipy'aacx, e pɨdaaccɨxy tügujc. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Je mayjäy huɨdibɨ anajty ajcxy nɨcxp jayɨjp etz axam ma Jesús, chi ajcxy ytɨgɨɨy capxp mɨc, ymɨnaangɨxy: ―¡Hosana! ¡Gloria a Dios, ooy ycömáyɨty Dios! Huen capxpaady y'idɨpy jada yëydɨjc huɨdibɨ mimb mɨɨd yɨ nHuindzɨn Dios yxɨɨ etz ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Huen capxpaady y'idɨpy je ané'mɨn huɨdibɨ jada Jesús yajtzondacp cham. Jada je' je ané'mɨn huɨdibɨ nmɨj'ap nmɨjteedy David anajty ymɨɨd. Hosana, huen je tzajpjoty tzɨnaayb ajcxy ɨɨbaatcɨxy capxpaatcɨxy jada mɨj'ane'mbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","E jadu'ñyɨ Jesús ycajptɨgɨɨy jɨm Jerusalén, e ytɨgɨɨy tɨgoty ma Dios ytɨjc. Co huindɨcxtay tüg'ócɨy tijaty jiiby tzajtɨgoty, chi chooñ jiiby, e ñɨcxy jɨm ma je cajp huɨdibɨ yxɨɨ Betania. Chi Jesús je majmetz ydiscípulos ajcxy mɨɨdnɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Je com jabom co ajcxy chooñ jɨm Betania, chi Jesús yuböccootɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chi Jesús ijxpaty jɨguëgy tüg higuerɨ ooy anajty yco'aayɨty. Chi Jesús ñɨcxy ma je higuerɨ yajpaady, ixa'ñ pen ymɨɨd ytɨɨm. Co Jesús ymech ma je higuerɨ, chi ijxy co je higuerɨ ca' anajty ytɨɨm mɨɨdɨty, jëyɨ mɨɨdɨty anajty y'aay, com ca' anajty ni tiempɨty mɨna higo ytɨɨm'aty. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chi Jesús mɨgapxy je higuerɨ nɨmay: ―Jadu'n nej tiempo yjacnɨcxnɨ, ni pɨn cajacpaadɨpy higo tɨɨm ma miich. Chi Jesús ydiscípulos ajcxy mɨdoy nej Jesús nɨmay je higuerɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Co ajcxy oy yjädy jɨm Jerusalén, co Jesús ytɨgɨy jadüg'oc jiiby ma Dios ytɨjc, chi Jesús yajpɨdzɨmday je ajuuybɨ adoocpɨ ajcxy jiiby tzajptɨgoty. Chi Jesús tijhuimbijtay je mesa ajcxy me je meeñ yajhuäcxpɨ ytuñ ajcxy. Nañ jadu'n tijhuimbijty je jäy ajcxy ɨñaybejt huɨdibɨ muuxy toocp. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús ca' anajty tzocy co pɨnjaty mɨdɨgɨ̈huɨpy juydoogy ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesús yaj'ixpɨjcpy anajty je mayjäy, e ymɨnañ: ―Ma Dios y'ayuc necy Dios jadu'n ymɨnañ: “Ɨɨch ndɨjc hue' je' tzajpcapxcapxtac ma tüg'ócɨy jäy ajcxy chooñ ma nidüg'ócɨy naax cajp ymiingɨxy Dios ojadajtp”, per miich ajcxy hue' yɨ' mhua'ñ meetzpɨtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Co ajcxy je teedy mɨjtungmɨɨdpɨ etz je escribas nejhuɨɨy nej anajty Jesús tɨ y'ɨdɨ̈ch jiiby ma Dios ytɨjc, chi ajcxy ooy ijxtaaygɨxy nej ajcxy jëb yaj'ögɨpy Jesús. Per ca' ajcxy yhuinma'ñybaady mɨc'amy nej yaj'ögɨpy, tzɨgɨɨyb ajcxy mɨɨd je mayjäy com je mayjäy ooy tzachjɨhuɨy huinmay jadu'n nej Jesús yaj'ixpɨ́jcɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Co oycoodzɨɨyñɨ, chi Jesús ycajppɨdzɨmy. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Je com jabom Jesús mɨɨd ydiscípulos ajcxy najxp anajty tɨm jopyñɨ ma je higuerɨ anajty ytɨnäy. E je higuerɨ tɨ anajty ytɨɨtztay mabaad ytictz. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Huin'it Pedro jäymejtzcooty nej Jesús nɨmay je higuerɨ, chi Pedro Jesús nɨmay: ―Huindzɨn, ix jada higuerɨ huɨdibɨ ɨxɨy mgapxpojc, tɨ yɨ' ytɨ̈ch. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chi Jesús Pedro nɨmay: ―Mɨbɨc yɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Janch ɨɨch miich ajcxy nɨmäy, co ixyipy pɨn mɨgapxy jada huingonbɨ cop, e nɨmäy ixyipy: “Miich cop pɨdɨ̈g, e nɨcx cɨdäg mejyjoty”, pen ca' ti mɨjotmetzcɨɨy, e mɨbɨcy co jadaanɨp nej yɨ' tɨ ane'my je cop, chi jadu'n ytunɨɨyb yjadɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Paady ɨɨch miich ajcxy nɨmäy co tüg'ócɨy tijaty miich ajcxy mbɨjctzooyb ma Dios, chi Dios xymöhuɨpy ajcxy huɨdibɨ tɨ mbɨjctzoogɨxy. Pen janch miich ajcxy mɨbɨcy co Dios tɨ xymooygɨxy ajcxy je huɨdibɨ tɨ mbɨjctzooyb. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Co miich ajcxy mgapxtaaccɨxy, pen ca' oy m'ity ajcxy mɨɨd tüg jäy, huinmécxcɨx yɨ mmɨdzip tɨm jayɨjp, jɨgɨx jëbɨ Dios Teedy huɨdib jiiby tzajpjoty xyhuinmeecxɨp miich ajcxy ma tɨ mdundɨgooygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pen ca' miich ajcxy mhuinmecxy yɨ mmɨdzip huɨdibɨ tɨ xymɨdundɨgooygɨxy, ca' miich ajcxy xyhuinmecxa'ñ Dios Teedy huɨdibɨ yajpatp tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Je huin'it tiempo Jesús mɨɨd je' ydiscípulos ajcxy yhuimbijty jɨm Jerusalén. E co Jesús anajty yhuɨdity tzajtɨgoty, chi nijëjɨty huindzɨndɨjc huɨdibɨ nigohuajc'ajtp anajty je teedytɨjc etz escribas ajcxy huɨdibɨ nïjayduutpɨ Dios ñecy, nimiiñ ajcxy Jesús, e ymɨnañ ajcxy: ―¿Pɨn cötújcɨn tɨ xymöy huɨdibɨ tɨ mduñ ya tzajtɨgoty? ¿Ma cötújcɨn tɨ mbaady co jëb m'ane'my ya tzajtɨgoty? ");
INSERT INTO mcoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Chi Jesús ymɨnañ: ―Ɨɨch miich ajcxy nañ jadu'n nyaj'amɨdohuamyb tüg ayuc. E pen mni'adzooyb ajcxy, huin'it ajcxy nyajnɨmähuɨpy ma ɨɨch tɨ nbaady yɨ mɨc'ajt etz yɨ cötújcɨn, co jadu'n nduñɨch jiiby tɨgoty ma Dios ytɨjc. ¿Pɨn yajnïbɨjc Juan, je Bautista, co huen jäy yajnɨɨbety? ¿Dios, o naaxhuiñyjäy? Adzoogɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chi ajcxy ytɨgɨɨy huinmay'ahuɨdijtpɨ, ñayñɨmáayɨgɨxy miñ xyɨpy: ―Pen mɨnaanɨm co Dios tzajpjotypɨ tɨ yajnïbɨcy Juan, chi Jesús xyñɨmáayɨmɨpy: “¿Nej co ca' miich ajcxy mɨbɨjcy Juan y'ayuc?” ");
INSERT INTO mcoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nañ ni ca' jëbɨ ɨɨch ajt nmɨnaanɨm co jäy ajcxy tɨ quejxy Juan. Com chɨgɨɨyb anajty jäy com ñejhuɨɨyb anajty ajcxy co Juan je Bautista Dios anajty ytɨy'ajt ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chi ajcxy Jesús nɨmay: ―Ca' ɨɨch ajcxy nejhuɨy pɨn tɨ yajnïbɨcy Juan. Chi Jesús ymɨnañ: ―Ɨɨch nañ jadu'n ca' nnigapxa'ñɨch pɨn tɨ xycötujcmöyɨch co jëb nduñɨch huɨdibɨ ndumybɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Je huin'it xɨɨ Jesús jacmɨgapxy je mayjäy mɨɨd jɨhuimbit ayuc, ymɨnañ: ―Ji yajpaady tüg yëydɨjc huɨdibɨ camuuxy tɨ cojy ma ycam, e tɨ co'aguemy je camuuxy cam, e yaj'oyɨɨy tügɨ tang ma huinmɨcxa'ñ je camuuxy. Nañ jadu'n je yëydɨjc tüg poch yajpɨdɨ̈gy ma ycamuuxy yaj'ixɨ̈hua'ñ co cuent'aty. Co anajty tɨ ni'ixɨ̈däy tɨ a'ɨxɨ̈däy, chi ycamuuxy cam yejcy ajuyducy ma nijëjɨty tumbɨdɨjc. Chi chooñ viaje tumbɨ jɨguëgy it. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Je huin'it tiempo co yhuaad'ajtnɨ je cosechɨ, chi je cogam quejxy tüg ytumbɨ jɨm ma je' ycam yajpaady, co hueen je tumbɨdɨjc yéjccɨxy je cosechɨ, jadu'n nej anajty tɨ ycapxytuñ mɨɨd je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chi je cam tumbɨdɨjc ajcxy majch je cogam yquexyöyp, chi huinhuojpy jɨjphuojpy ajcxy. Chi ajcxy quejxhuimbijty jadu'ñyɨ, ni ti ajcxy camoy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chi je cogam quejxy jadüg ytumbɨ ma je ycam yajpaady. Chi tumbɨdɨjc ajcxy tzaagäch je mɨmetzpɨ quexyöyp etz yajtzachɨy ajcxy ma ycohuajc, chi ajcxy ooy ojy oyñinej. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chi je cogam jacquejxy jadüg ytumbɨ e ajcxy tumbɨdɨjc yaj'o'cy je mɨdugɨɨgpɨ quexyöpy. Chi je cogam jac tɨm quejxy jadyii ytumbɨ. Chi je tumbɨdɨjc ajcxy je cogam ytumbɨ huinhuojpɨ jɨjphuojpɨ nijëjɨty, e nijëjɨty ajcxy yaj'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Je cogam ymɨɨd anajty tügpajc ymang huɨdibɨ anajty ooy tzocy jɨhuɨy. Je' oy quejxcogɨxɨ̈y ma je ycam yajpaady. Je cogam huinmay jadu'n co je tumbɨdɨjc ajcxy yajmɨj'adɨɨyb je' ymang. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chi je tumbɨdɨjc ajcxy ñayñɨmaayɨ miñ xyɨpy: “Jada yëydɨjc je cogam jada ymang huɨdibɨ jë'adaanɨp je yteedy ypɨdägy. Tzoc yaj'ó'cɨm, e jadu'n je cam një'ájtɨm.” ");
INSERT INTO mcoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","E jadu'n ajcxy majch je cogam ymang yaj'ögy ajcxy. Chi ajcxy yajpɨdzɨmy camjoty, e jɨbijptacy agajjɨxcɨ'py. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Co Jesús jadu'n mɨydactay je jɨhuimbit ayuc, chi ymɨnañ: ―¿Ti ytunamyb je cogam mɨɨd je tumbɨdɨjc ajcxy? Hue' min cɨ'm ma je' ycam, e yaj'öctähuɨpy je tumbɨdɨjc ajcxy huɨdibɨ tundɨgoy. E yegɨpy pɨjctzoy je' ycam mɨɨd huingbɨ jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Nej ca'nɨ miich ajcxy mgapxy yɨ Dios ñecy ma jadu'n ymɨnañ? Je yëydɨjc huɨdibɨ je jäy ajcxy ca' anajty tzocy, Dios tɨ pɨdägy mɨj'ane'mbɨ. Tɨm jadu'n nipaady nej tzaa oyjatypɨ huɨdibɨ je pojtzpɨdɨjc ca' ajcxy yajtuna'ñ, e je' oy tɨ yhuɨ'mnɨ ma anajty yjaccopɨ́cyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jada tung je Huindzɨn Dios tɨ tuñ, e ooy oy n'íjxɨm njäygɨdaacɨm. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","E huin'it je judíojäy ajcxy ytungmɨɨdpɨ ooy jamadzaañ anajty Jesús, com ñejhuɨɨyb anajty ajcxy co Jesús ñigapxyii yɨ' ajcxy. Com tzɨgɨɨyb anajty ajcxy mɨɨd je mayjäy, chi ajcxy tɨm huinyöyducy, chi ñɨ́cxcɨxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jac'axam je judíojäy ajcxy ytungmɨɨdpɨ quejxy ajcxy ma Jesús yajpaady mejtzpɨcy ixpɨcytɨjc. Tügpɨcy anajty ñaygomájtzɨgɨxy mɨɨd yɨ fariseos ajcxy, etz jadügpɨcy ma je rey Herodes. Hue' anajty ajcxy huinma'ñ ixtaayb nej ajcxy ocxɨ̈huɨpy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jada mejtzpɨcypɨ ixpɨcytɨjc ñɨcxy ajcxy ma Jesús, e ymɨnañ ajcxy: ―Huindzɨn, ɨɨch ajcxy nejhuɨɨyb co myaj'ixpɨjcy je tɨy'ajt, ca' jäy mdzɨgɨ̈y, com ca' huin'ijxpety myaj'ixpɨcy. Tú'cɨy miich mduñ mɨɨd mɨc jäy, mɨɨd comeeñyjäy, etz mɨɨd ayoob jäy. Tudägy jäy ajcxy myaj'ixpɨcy jadu'n nej huaad ajcxy cuychɨnaaygɨxy Dios ytɨy'ajt. Nejhuɨ̈huaamybɨch ajcxy nej miich yaj'ixpɨjcpy je mayjäy. ¿Nej tundɨgooyɨm mɨɨd yɨ Dios ycötújcɨn co nmɨgüéjtɨm César, je romano jäy mɨj'ane'mbɨ, o ca'jɨ? ¿Nej jëb nmɨgüéjtɨm, o ca'jɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per Jesús ñejhuɨɨyb anajty ajcxy yjɨbɨc-huinma'ñ, e chi ajcxy nɨmay: ―¿Na'amy co miich ajcxy xyjot'ixy xyhuinma'ñ'íxyɨch? Yajmiingɨx tüg meeñ jɨgɨx n'oc'ixɨpyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chi ajcxy mɨmiiñ tüg meeñ e co Jesús ijxy je meeñ, chi ymɨnañ: ―¿Pɨn y'ahuanax etz pɨn yxɨɨ ijtp ma jada meeñ? Chi ajcxy y'adzooy: ―Hue' yɨ' César. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chi Jesús ymɨnañ: ―Mo' je César huɨdibɨ yɨ' yjë'ajtpy, e mo' Dios huɨdibɨ Dios yjë'ajtpy. Chi ajcxy ooy jɨhuɨy huinmay jadu'n nej anajty Jesús tɨ y'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Je huin'it tiempo nijëjɨty saduceos ajcxy ymiiñ ma Jesús. Yɨ saduceos ajcxy ymɨnaangɨxy co ca' pɨn yjugypɨga'ñ tɨɨbɨ y'o'ccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Chi je saduceos ajcxy Jesús nɨmay: ―Huindzɨn, Moisés jayhuɨ'my je cötújcɨn co tüg yëydɨjc y'ögy, e co'ögy yhuɨ'my je ytöxyɨjc e ca'nɨ ytöxyɨjc ung'ixy. Pues copɨcy je co'ögy ytöxyjäy ypɨgɨpy mɨɨd ña'y y'uch yëydɨjcpɨ jɨgɨx jëbɨ je töxyjäy y'ung'ixɨpy huɨdibɨ huɨ'mɨ̈huɨp jadu'n nej codɨjc cobɨdägy ma je yteedy y'ajch ypɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pues jɨm ma tüg cajp anajty chɨnäy huɨxtujc yëydɨjc tüg que'x. Je ungoob ypɨjcy, e chi ix'o'cy ytöxyɨjc, e ca' ni tüg y'ung yajhuɨ'my. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Je mɨmetzpɨ yëydɨjc ypɨjcy mɨɨd je co'ögytöxyjäy, e nañ jadu'n ix'o'cy ytöxyɨjc e ca' ni tüg ung yajhuɨ'my. E nañ jadu'n je mɨdugɨɨgpɨ mɨɨd ypɨjcy je töxyjäy, e nañ jadu'n ix'o'cy je ytöxyɨjc, e ca' ni tüg y'ung yajhuɨ'my. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","E jadu'n oytuñyii yjadyii mɨɨd je töxyjäy co tɨ anajty mɨɨddzɨnay'abɨdzɨmdäy je nihuɨxtujcpɨ yëydɨjc tüg que'xpɨ. E je nihuɨxtujcpɨ ix'o'cy ajcxy je töxyjäy, e ca' ni tüg y'ung ajcxy yajhuɨ'my. E chi je töxyjäy oy y'öcnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","E co anajty xɨɨ tiempo paaty, co anajty Dios yajjugypɨcy yɨ tɨɨbɨ ajcxy y'ögy, ¿huɨdibɨ jada' ajcxy nidüctɨ je yëydɨjc töxyɨjc'adaanɨp je töxyjäy? Com tɨ ajcxy jadu'n nihuɨxtujcpɨ mɨɨd tzɨnay'abɨdzɨmgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chi Jesús je saduceos ajcxy nɨmay: ―Miich ajcxy ca' mhuinjɨhuɨ̈y je tɨy'ajt, com ca' mhuinjɨhuɨɨygɨxy Dios y'ayuc ytɨy'ajt, e com ni ca' mnejhuɨɨygɨxy je mɨc'ajt huɨdibɨ Dios ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pues co anajty yjugypɨ́jccɨxy je jäy tɨɨbɨ y'ó'ccɨxy, chi ca' ajcxy ypɨga'ñ, e nañ jadu'n ni ca' ajcxy ñaymöhuɨɨyb y'ung huen pɨ́jccɨxy. Hue' ajcxy yjugy'adaangɨxy chɨnähuaangɨxy jiiby tzajpjoty, tɨm jadu'n nej je ángel ajcxy chɨnaaygɨxy yjugy'ájtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Per je tɨy'ajt co jäy ajcxy tɨɨbɨ y'o'ccɨxy yjugypɨgaangɨxy, ¿nej ca'nɨ mgapxynɨ Moisés ytɨy'ajt ma anajty Dios ymɨgapxyii co je aay ujtz anajty chachtoy? Chi ymɨnañ: “Ɨɨch je' je Dios huɨdib Abraham, Isaac etz Jacob yDios'ajtpy.” ");
INSERT INTO mcoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Com yɨ Dios ca' yɨ' yDios'aty ma yɨ öcpɨ ajcxy huɨdibɨ y'alma tɨ ycɨxy tɨ ytɨgoy. Yɨ Dios Dios'ajtp yɨ' ma yɨ juugypɨ ajcxy. Paady miich ajcxy ooy mɨj mdundɨgooygɨxy co ca' mhuinjɨhuɨɨygɨxy Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nañ jadu'n je huin'it tiempo nimiiñ Jesús tüg escriba. E yɨ' anajty y'amɨdo'ijtpy co Jesús adzooy je jäy huɨdibɨ ca' mɨbɨcy co yɨ öcpɨ yjugypɨgɨpy ajcxy jadüg'oc. Jada escriba ñejhuɨɨyb co Jesús ooy oy tɨ y'adzooy je saduceos ajcxy, paady yɨ' Jesús amɨdooyɨ: ―¿Huɨdibɨ je' Dios y'ané'mɨn jacmɨjpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chi Jesús y'adzooy: ―Yɨ Dios ycötújcɨn huɨdibɨ jaccopɨcyɨp, yɨ' je' huɨdibɨ mɨnamb: “Mɨdoogɨx Israel jäy, je Huindzɨn Dios huɨdibɨ nDios'ájtɨm, yɨ' je' ajt nHuindzɨn Dios tügpajcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tzoc jɨhuɨ' etz yajmɨj'at mHuindzɨn Dios mɨɨd tüg'ócɨy m'aa mjot etz mɨɨd tüg'ócɨy m'alma, etz mɨɨd tüg'ócɨy mhuinma'ñ, etz mɨɨd tüg'ócɨy mmɨc'ajt.” Jada je' je jaccopɨ́cyɨp ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Je mɨmetzpɨ Dios ycötújcɨn jahueengɨ tú'cɨy ñaybadyii mɨɨd je jayɨjpɨ, yɨ' huɨdibɨ jadu'n mɨnamb: “Tzojccɨx jɨhuɨɨygɨx yɨ mmɨgügtɨjc tɨm jadu'n nej mnaychogyii mnayjɨhuɨ̈yii cɨ'm.” Jada metz Dios ycötújcɨn jaccopɨcy jacmɨc'ajt mɨɨd ca'ydɨ jac huɨdibɨ cötújcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chi je escriba ymɨnañ: ―Ooy oy tɨ m'adzooy. Janch tɨy'ajt jadu'n nej miich mɨna'ñ, co ji yajpaady tügpajcpɨ Dios, e ca' ji jadüg Dios mɨc'ajt mɨɨdpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E janch tɨy'ajt co copɨcy nmɨjpɨdaacɨm nyajmɨj'ájtɨm Dios cɨxyjot huinɨjot mɨɨd tüg'ócɨy ajt nhuinma'ñ, mɨɨd tüg'ócɨy ajt n'alma, etz mɨɨd tüg'ócɨy ajt nmɨc'ajt. E copɨcy ndzójcɨm njɨhuɨɨyɨm nmɨgügtɨjc tɨm jadu'n nej naychójcɨm nayjɨhuɨɨyɨm cɨ'm. Jactzoobatp jada ca'ydɨ co tüg'ócɨy yɨ huindzɨgɨ'ñ huɨdibɨ anajty yajno'cpɨ mɨɨd Dios ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Co Jesús ijxy jadu'n nej je escriba tɨydudägy anajty tɨ y'adzoyii, chi ymɨnañ: ―Jahuenjaty miich mmɨbɨ́jcɨn ytɨgoy'ityñɨ jaydëb mdɨgɨ̈huɨpy ma Dios y'ane'my. Co Jesús anajty jadu'n tɨ y'adzooy je escriba, chi ca' jac pɨn ti ayuc yjacyaj'amɨdoohuɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús yaj'ixpɨjcpy anajty je mayjäy jiiby ma Dios ytɨjc, e ymɨnañ: ―¿Na'amy co yɨ escribas ajcxy ymɨnaangɨxy co Cristo hue' je' David y'ap y'oc? ");
INSERT INTO mcoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Com je Espíritu Santo ymoy David jada ayuc huɨdibɨ jaybety ma je Salmo necy ma jadu'n ymɨnañ: Yɨ Huindzɨn Dios nɨmay ɨɨch nHuindzɨn: “Ɨña' ya a'oy'amy ma ɨɨch nmɨjc, ixtɨ coonɨ anajty miich mmɨdzip tɨ nmɨmadactäyɨch, jadu'n nipaadɨpy nej jɨhuɨ̈y tɨ nbɨdägyɨch miich mmɨdzip jadu'n nej tüg tɨnaybejt.” ");
INSERT INTO mcoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Per nej co yjadu'nɨty co jäy ajcxy ymɨnaangɨxy co je Cristo David je' y'ap y'oc? ¿E David cɨ'm ymɨnañ co je Cristo yɨ' yHuindzɨn'ajtpy? Jotcujc anajty je mayjäy amɨdoo'ijtɨ Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús yaj'ixpɨjcpy anajty je mayjäy, e ymɨnañ: ―Naycuend'ájtɨgɨx mɨɨd yɨ escribas ajcxy. Com yɨ escribas ajcxy ooy jotcujc co nayxójxɨgɨxy mɨɨd yhuit oyjatypɨ yoñjatypɨ. Ooy ajcxy tzocy co yajcapxpócxcɨxɨpy huindzɨgɨ'ñ'amy mayjäyduum. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yɨ escribas ooy ajcxy tzójccɨxy yɨ cödumbɨ ɨñaybejt ma je naymujctac, etz ooy ajcxy tzójccɨxy ɨñaybejt ma yɨ cömaybɨ jäy ɨñay ma jäy ajcxy yxɨɨduñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yɨ escribas ajcxy yajcɨjxtaayɨpy yɨ co'ögy ytöxyjäy ypɨdägy mɨɨd ajcxy y'adzójcɨn. Yɨ' ajcxy ooy túngɨxy jecy tzajpcapxycapxɨɨ jɨgɨx ajcxy capxpaady idɨpy. Dios nïgɨ tzaachytunɨpy yɨ escribas ajcxy mɨɨd ypocy ycɨxpɨ, ca'ydɨ jac ni pɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tüg xɨɨ anajty Jesús ɨñay jiiby tɨgoty ma Dios ytɨjc. Ɨñaayb anajty ma je limosna caja huinduu. Jesús yhuindɨɨcxyp anajty je jäy ajcxy huɨdibɨ meeñ pɨdaaccɨxp ma je ofrenda caja. E maycomeeñyjäy ooy ymeeñ pɨdaaccɨxy janch may. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tɨm huin'ítɨy yja'ty tüg co'ögy töxyjäy janch ayoob pɨdacy metz pi'c meeñyhuäcxy, huɨdibɨ ca' ooy choobaady. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chi Jesús huoomujcy je' ydiscípulos, e nɨmay ajcxy: ―Janch tɨy'ajt jadu'n nɨmaaygɨxy co jada co'ögy ytöxyjäy ayoob jac'anaxy jada tɨ pɨdägy ofrenda, ca'ydɨ jac ni pɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tüg'ócɨy comeeñydɨjc ajcxy ypɨdacpy ma y'ofrenda yɨ meeñ huɨdibɨ yajconajxyp. Jadayaabɨ co'ögytöxyjäy tɨ pɨdacy tüg'ócɨy huɨdibɨ anajty ymɨɨd, je meeñ tüg'ócɨy huɨdibɨ anajty ñigayamy yɨ' ymooyb Dios. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Co Jesús ypɨdzɨmy ma Dios ytɨjc, chi nidügtɨ ydiscípulos ñɨmayɨ: ―Huindzɨn, ix jada maychaa mɨjjatypɨ etz jada maybɨ tɨjc ooy y'oy'oydúñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Per Jesús y'adzooy, ymɨnañ: ―Huindɨcx miich ajcxy jada maybɨ mɨjjaty ytɨjc. Minɨp tiempo mɨna tüg'ócɨy jada tɨjc nɨcxy yhuɨ'my taj xit, ca' ma tzaa macxy. Huindɨgoydähuɨp tüg'ócɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús mɨɨd ydiscípulos ajcxy ñɨcxy ma je cop huɨdibɨ xɨɨjɨp Olivos. Jɨm ajcxy co'ijxnaxy je Dios ytɨjc. Ɨñaayb anajty Jesús jɨm copcɨ́xy co Pedro, Jacob, Juan etz Andrés ameech mɨgapxy Jesús, ymɨnaangɨxy: ");
INSERT INTO mcoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tun may'ajt ɨɨch ajcxy yajnɨmaayg mɨna jada ytuna'ñyii yjada'ñyii co huindɨgoydähuɨp Jerusalén cajp. ¿Ti ijxpejt'adam co anajty jadayaabɨ jadu'n ytuna'ñyii yjada'ñyii? ");
INSERT INTO mcoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chi Jesús y'adzooy ajcxy je' ydiscípulos ymɨnañ: ―Ix pɨnjaty xyhuin'ɨɨngɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ooy jäy may ymiinañ mɨɨd ɨɨch nxɨɨ. Ñaydijáanɨgɨxy co je' ajcxy je' je Cristo, ymɨna'na'ñ ajcxy: “Ɨɨch je' je Cristo.” E ooy jäy may huin'ɨɨnaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Co miich ajcxy ayuc mmɨdohuɨpy co jäy chachchiptúngɨxy xɨɨ ya, ca' mdzɨgɨ́ɨygɨxɨp, com ooy ycopɨ́cyɨty co jada jadu'n jayɨjp ytunɨɨyb yjadɨɨyb. Ca' nan hue' je' anajty tɨm cɨjxp tɨm tɨgooyb je xɨɨ je tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nayñibɨdɨ̈gɨɨb tüg naax cajp mɨɨd huingbɨ naax cajp, e gobierno mɨɨd huingbɨ gobierno. E minɨpy mɨc ujx canaag'it etz mɨj yuu mɨjpa'm xɨɨ ya. E jäy ajcxy ooy yhuänɨpy yjɨhuɨ̈huɨpy ycanaymɨjotcujc'ájtɨgɨxɨpy. Jada tzaachypɨ ayo'n tzondacnɨ yɨ' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Chi Jesús yjacmɨnañ: ―Nayguend'ájtɨgɨx miich ajcxy, com yɨ mmɨdzip ajcxy xymájtzcɨxɨp, e xycɨ̈yéjccɨxɨp ma tungmɨɨdpɨdɨjc, e xychachytúngɨxɨp xyhuójpcɨxɨp ma yɨ judíojäy ñaymujctac ajcxy. Xyajnɨ́cxcɨxɨp mach ma rey etz ma gobernador ajcxy yhuinduu mɨɨd ɨɨch ycɨxpɨ com miich ajcxy xymɨbɨcyɨch. E miich ajcxy tɨy'ajt myegɨpy mɨɨd ɨɨch ycɨxpɨ, ixtɨ ma rey ajcxy etz ma gobernador ajcxy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ca' anajty xɨɨ tiempo paady mɨna ycɨxa'ñ naaxhuiñybɨ, chi ajcxy capxhuäcxtähuɨpy ɨɨch n'ayuc huindu'myb ñaaxhuiñ ma tüg'ócɨy naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Co jäy ajcxy xyajnɨ́cxɨp mach ma codungdɨjc co xytɨydúngɨxɨpy, chi ca' ni nej mjot'adɨɨyb, ni ca' mhuinmayɨpy nej m'adzóogɨxɨpy. Mgápxcɨxɨpy je ayuc huɨdibɨ Dios xymóoygɨxɨpy, com je ayuc huɨdibɨ mgápxcɨxɨp, ca' nan miich je' anajty ajcxy m'ayuc. Hue' je' je Espíritu Santo xymóoygɨxɨpy capxy ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yëydɨjc ajcxy ycɨ̈yegamyb ma tungmɨɨdpɨ ycɨ'm y'uch ajcxy co huen yaj'ögyii. E nañ jadu'n je ungdeedy ycɨ̈yegamy ycɨ'm y'ung ajcxy ma tungmɨɨdpɨ. Nañ jadu'n yɨ' y'ung ajcxy cɨ̈yegɨpy ycɨ'mdeedy co huen yaj'ögyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","May naaxhuiñjäy ca' xychogɨpy xyjɨhuɨ̈huɨpy miich ajcxy mɨɨd ɨɨch ycɨxpɨ. Pen miich ajcxy mmɨctɨnaayb ma mmɨbɨ́jcɨn, ypaadɨp miich ajcxy m'alma nïdzoocɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Chi Jesús yjacmɨnañ: ―Co anajty m'íjxcɨxy je huɨdibɨ Daniel ñimɨydac jecy'ajty, co pɨnjaty jɨbɨc-huinma'ñ tumb ma ca' ypadyii ma Dios ytɨjc, huɨdibɨ ooy ycodzɨgɨ̈jɨty. Miich ajcxy huɨdibɨ tzɨnaayb jɨm Judea, co jadu'n m'íjxcɨxɨpy, chi nɨcx mgueectzooccɨx ma tungop. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yɨ jäy ajcxy huɨdibɨ yajpatp ma ytɨjcnïcxy ca' ñɨ́cxɨty tɨgoty ma ytɨjc. E ni ti jiiby cayajpɨdzɨmɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yɨ jäy ajcxy huɨdibɨ yajpatp camjoty, ca' ajcxy nihuimbidɨpy je' yjocxy huit huɨdibɨ ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Huin'it xɨɨ huin'it tiempo ayo'n pada'ñ je töxyjäy huɨdibɨ anajty tɨ y'ungtzɨmɨ̈gy, e nañ jadu'n yɨ' ajcxy huɨdib mɨɨd y'ung ma'xung yajtzïtzp. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","May'ajt ajcxy mbɨjctzoohuɨpy ma Dios, co jada jadu'mbɨ ayo'n ca' ytunɨɨyb yjadɨɨyb ma anajty ytɨɨch tiémpɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yɨ jadu'mbɨ xɨɨ tiempo jäy ajcxy ayo'n tzaachypɨ mɨnaxɨpy yajnaxɨpy. Ni camɨnaaxɨɨ jäy jadu'n tzaachypɨ mɨjcajee tɨ mɨnaxy tɨ yajnaxy maabɨ Dios cojy naaxhuiñybɨ oga'n, ixtɨ chambaad. E camɨnaxɨɨ jadüg'oc ycajadɨɨyb jadu'n. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pen ca' Dios capx'aduga'ñ yɨjiibɨ ayo'n xɨɨ ayo'n tiempo, ca' ni pɨn chögɨpy. Per Dios ycapx'adugamyb yɨjiibɨ ayo'n tiempo mɨɨd je mɨbɨjcpɨdɨjc ycɨxpɨ huɨdibɨ Dios tɨ huin'ixy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Co yɨ jadu'mbɨ xɨɨ tiempo anajty ymiiñ, ca' mmɨbɨgɨpy, pen ji pɨnjaty xyñɨmaaygɨxy: “Ijxcɨx, cha yajpaady je Cristo”, o “jɨm'amy yajpaady je Cristo.” Ca' mmɨbɨ́jccɨxɨpy jäy y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Minɨp jäy ajcxy huɨdibɨ ñayyajnaxáanɨgɨxy nej Cristo, e ymɨnáangɨxɨpy co capxhuäcxy ajcxy Dios y'ayuc, e ca' yjánchɨty. Ytunɨpy ajcxy mɨj huinma'ñ etz mɨjpɨ ijxpejt, ixtɨ jahuin'ɨɨna'ñ je mayjäy ajcxy huɨdibɨ Dios tɨ yhuin'ixyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nayquend'ájtɨgɨx mɨɨd yɨ jadu'mbɨ jäy ajcxy, com jayɨjp ɨɨch miich ajcxy yɨ' tɨ nyajmɨɨdmɨydägy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chi Jesús yjacmɨnañ: ―Co anajty yɨ jadu'mbɨ ayo'n tiempo tɨ ñaxy, ycoodzɨ̈hua'ñ etz je po' ca' y'ana'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Maymadza' ycähuɨp, e nañ yücxɨp huɨdijaty mɨc'ajt mɨɨd tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Je huin'it xɨɨ je huin'it tiempo co jadu'n anajty ytunyii yjadyii, huin'it ajcxy m'ixɨpy, ɨɨch je jäy huɨdibɨ tzoon tzajpjoty, co ɨɨch anajty nmiiñɨch jocjoty mɨɨd tüg'ócɨy nmɨc'ajt n'oy'ajtɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Co jadu'n anajty nmiiñɨch, chi mɨc'amy nguexɨpyɨch ɨɨch n'ángeles ajcxy ma xɨɨ ypɨdzɨmy, ma xɨɨ ycɨdägy, ma jɨɨmboj ypɨdzɨmy etz ma tɨchpoj ypɨdzɨmy. N'ángeles ajcxy yajmuga'ñ tüg'ócɨy ɨɨch njäy, huɨdibɨ tɨ nhuin'ixyɨch, xɨm yam ma ajcxy yajpaady ya naaxhuiñ, etz jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Chi Jesús yjacmɨnañ: ―Jëb miich ajcxy tɨy'ajt mbɨgɨpy ma yɨ higuerɨ jadu'n nej je xɨɨ je tiempo mimb cɨdaacnɨ. Co je hɨguerɨ jadüg'oc ñïhuamɨ̈y, chi miich ajcxy mnejhuɨ̈y co tɨ yhuingonɨ mɨna ypottɨgɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nañ tɨm jadu'n co m'ixɨpy tunɨɨyb yjadɨɨyb tüg'ócɨy ijxpejt nej tɨ nnɨmaaygɨxy, chi mnejhuɨ̈huɨp co tɨ yhuingonɨ je tiempo mɨna nhuimbidɨpyɨch jadüg'oc ya naaxhuiñybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Janch ɨɨch miich ajcxy nɨmäy co jada huɨdibɨ tɨ nnimɨydacyɨch tunɨɨb jadɨɨb ca'nɨ anajty y'öctay je jäy ajcxy huɨdibɨ jacjugy'ajtp jadachambɨ xɨɨ jadachambɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Je tzajp etz je naaxhuiñybɨ cɨxɨpy tɨgoyɨpy. Ɨɨch n'ayuc huɨdibɨ ngapxyɨch, ca' ycɨxɨpy ytɨgoyɨpy ni camɨnaxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ca' ni pɨn nejhuɨ̈y je xɨɨ je tiempo mɨna ytuna'ñyii yjada'ñyii jadu'n nej tɨ ɨɨch miich ajcxy nnɨmaaygɨxy. Ni je ángeles ajcxy jiiby tzajpjoty ca' nejhuɨɨygɨxy, nañ ni ɨɨch, Dios y'ung', ca' nejhuɨ̈yɨch. Jëyɨ Dios Teedy tügpajc nejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ni'ixɨ' ahuíjxcɨx. Mɨbɨjctzoogɨx Dios jabom jabom, com ca' mnejhuɨɨygɨxy mɨna anajty ytuna'ñyii yjada'ñyii yɨ­ huɨdibɨ tɨ nyajnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yɨ xɨɨ yɨ tiempo huɨdibɨ minɨp jadu'n nipaady nej tüg comeeñyjäy huɨdibɨ ñɨcxa'ñ ma tüg it lugar huɨdibɨ jɨgüegy yajpatp. Jayɨjp ca'nɨ anajty chooñ, chi yajnïbɨjcy je ytumbɨ ajcxy nidüg nidüg je' ytung. E nɨmay je' ytumbɨ huɨdibɨ cuend'ajtp je tɨjc'aguu co huen ni'ixɨ' y'idɨpy ma tɨjc aguu. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ni'ixɨ' m'idɨpy miich ajcxy. Com ca' mnejhuɨɨygɨxy mɨna je codɨjc yhuimbida'ñ ma ytɨjc, pen namgodzɨ̈y, o mɨj coodz, o moñɨ, o ma anajty tɨ yxɨɨmɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ca' jécyɨty co yjädɨpy tɨmetiinɨ, e xyajyöybéjtcɨxɨpy anajty mdzachmaagɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yɨ huɨdibɨ ɨɨch miich ajcxy tɨ nyajnɨmaaygɨxy, nañ jadu'n nɨmäyɨch tüg'ócɨy jäy co huen ajcxy nidüg'ócɨy ahuíjxcɨxɨp ni'ixɨ' je xɨɨ je tiempo mɨna nhuimbidɨpɨch jadüg'oc ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tɨgoy'ijtnɨ anajty mejtz xɨɨ co judíojäy ajcxy nixɨɨduna'ñ je pascua xɨɨ, mɨna ajcxy tzajcaagy cay huɨdibɨ ca' levadura mɨɨdɨty. Je judío teedy ajcxy huɨdibɨ jacmɨjtungmɨɨd etz je escribas ajcxy huinma'ñ'ixtaaygɨxy nej jëb ameech májtzcɨxɨpy Jesús, e yaj'ögaangɨxy, ca'ydɨ je mayjäy nejhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Chi ajcxy ñayñɨmayɨ miñ xyɨpy: ―Ca' y'óyɨty co nmájtzɨm Jesús xɨɨjoty. Com ca' yjécyɨty co je mayjäy yjotmätcottähuɨpy, e ytɨgɨ̈huɨp huambɨ jɨhuɨɨyb ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","E Jesús jɨm anajty yajpaady jɨm Betania. Hue' Jesús anajty yajpaady ma Simón ytɨjc, je Simón huɨdibɨ anajty ymɨɨd nïbüdz pa'm. Jesús ɨñaayb anajty ma caydac co ymiiñ tüg töxyjäy mɨɨd tüg tzaadüdz quiig ujtz mɨɨd perfume huɨdibɨ ooy oy yxuugy. Jada perfume ooy anajty chóohuɨty. Chi je töxyjäy yaj'ahuäch je quiig, e yajcöyogɨy Jesús je perfume huɨdibɨ ooy oy yxuugy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E nijëjɨty jäy ajcxy huɨdibɨ anajty jɨm, ca' anajty ajcxy yjotcújcɨty mɨɨd huɨdibɨ je töxyjäy tɨ tuñ, e ñayñɨmayɨ ajcxy miñ xyɨpy: ―¿Nej jada co ocyaj'ayoonɨ yɨ perfume huɨdibɨ ooy oy yxuugy? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jac'oy co ixyipy yajtoogy yɨ perfume tugɨɨg mɨgo'px peexy, jɨgɨx yajpubedɨpy ayoobtɨjc. E ca' jadu'n ajcxy tɨm jäygɨdacy nej je töxyjäy ytuuñ mɨɨd Jesús, chi ix'ojy ajcxy je töxyjäy ayoob. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chi Jesús ymɨnañ: ―Ixmajtzcɨx jada töxyjäy. ¿Nej co m'amayɨɨygɨxy? Yɨ huɨdibɨ tɨ tuñ mɨɨd ɨɨch, ooy yɨ' y'óyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Je ayoobtɨjc ca' ytɨgoy'idɨpy ma miich ajcxy nimɨna. Huen huɨdibɨ xɨɨ huen huɨdibɨ tiempo jëb mbubedɨp ajcxy ayoobtɨjc. Per ɨɨch ca' n'ida'ñɨch ya jecy mɨɨd miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jada töxyjäy tɨ tuñ mɨɨd ɨɨch jadu'n nej tɨ ymadägy. Yɨ' tɨ pɨdägy ma ɨɨch nninïcx perfume huɨdibɨ ooy oy yxuugy. Yɨ' jɨjp'ijxpy mɨna naaxtɨgɨ̈hua'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Janch ɨɨch miich ajcxy nɨmaaygɨxy co huen yma'ámyɨty ya naaxhuiñ ma anajty yaj'ɨɨhuäcxy yajcapxhuäcxy jada ayuc jada tɨy'ajt huɨdibɨ nïdzoocɨn mɨɨd, yajnimɨydägɨpy huɨdi jada töxyjäy tɨ tuñ, jɨgɨx capxpaady y'idɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Huin'it tiempo je Judas Iscariote, nidüg je nimajmetzpɨ huɨdibɨ Jesús anajty tɨ huin'ixy, oy mɨɨd ñaygapxyii je teedy mɨjtungmɨɨdpɨ nej jëb cɨ̈yejcy Jesús ma yɨ teedy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Co je teedy mɨjtungmɨɨdpɨ ajcxy jadu'n mɨdoy, co je Judas cɨ̈yega'ñ Jesús ma yɨ' ajcxy, chi ajcxy ooy yjotcugɨɨy. Chi ajcxy Judas meeñ yajhuinhuanɨɨy. Chi Judas yhuinma'ñ'ixtay nej jëb occɨ̈yecy Jesús ma yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chi paty je mɨj xɨɨ mɨna je xɨɨ'ajtpɨdɨjc tzajcaagy cay huɨdibɨ ca'p levadura mɨɨdɨty, e yaj'öccɨxy je cöbixy huɨdibɨ ajcxy yajhuindzɨgɨɨyb anajty Dios. Chi ydiscípulos ajcxy y'amɨdooy Jesús: ―¿Ma'amy mdzocy co ni'ixɨɨyɨm je pascua xɨɨ adzu'ájtɨn? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chi Jesús quejxy metz ydiscípulos ajcxy cajpjoty, chi nɨmay: ―Jɨm mɨɨd mnaybadɨɨyb tüg yëydɨjc huɨdibɨ nɨɨ tzɨmnɨcxp ma tüg majt. Miich ajcxy mbanɨcxɨɨyb je yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mbanɨ́cxɨpy ajcxy je yëydɨjc, ixtɨ coon mbajädɨpy ma ytɨjc. E miich ajcxy mnɨmähuɨpy je codɨjc: “Je Huindzɨn Jesús ñejhuɨ̈huam ma miich mɨɨdɨty tüg cuarto ma je Huindzɨn Jesús mɨɨd ydiscípulos ajcxy jëb caaygɨxy yɨ pascua xɨɨ adzu'ájtɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Je codɨjc cɨ'm xyajni'ixɨ́ɨygɨxyɨp tüg cuarto mɨjpɨ ma je mɨmetz piso huɨdibɨ tɨ yajni'ixɨ̈y. Ma yɨjɨmbɨ cuarto miich ajcxy mni'ixɨ̈huɨpy yɨ pascua xɨɨ adzu'ájtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chi je metz Jesús ydiscípulos ajcxy tüyöychooñ. Co ajcxy yja'ty cajpjoty, chi ajcxy paty je cuarto, tɨm jadu'n nej Jesús jayɨjp ymɨnañ. E jɨm ajcxy ni'ixɨ̈y je pascua xɨɨ adzu'ɨ̈bɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nam coodzɨɨyñɨ anajty co Jesús yja'ty ma je cuarto mɨɨd jacjadyii ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Co anajty jɨm ycaaygɨxy ma je caydac, chi Jesús ymɨnañ: ―Janch ɨɨch miich ajcxy nɨmay co nidüg miich ajcxy huɨdibɨ cham caayb mɨɨd ɨɨch, xycɨ̈yegaambɨch ma nmɨdzípɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Co je Jesús ydiscípulos jadu'n mɨdooy, chi ooy ytɨgɨɨy tajpɨ maybɨ ajcxy, e ñay'amɨdóohuɨgɨxy miñ xyɨpy, e tüg ymɨnañ: ―¿Nej ɨɨch jada'jɨ? E jadüg ymɨnañ: ―¿Nej ɨɨch jada'jɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chi Jesús ymɨnañ: ―Yɨ' yɨ' nidügtɨ yɨ nimajmetzp huɨdibɨ tocxmujcp mɨɨd ɨɨch ma tügpɨ texy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pues janch ɨɨch je', je jäy huɨdibɨ tzoon tzajpjoty, nbadaamybɨch tzaachypɨ ayo'n jadu'n nej yjaybétyɨty ma yɨ Dios ñecy. Per mɨj ayo'n pada'ñ je jäy huɨdibɨ xycɨ̈yegaamɨch ma ɨɨch nmɨdzip. Jac'oy co ca' ycadɨmma'xung'ajty jada yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Caayb ajcxy anajty, co Jesús conɨ̈gy tüg tzajcaagy, e jayɨjp yajnajx Dioscojuyip ma Dios, e chi tujc-huäcxy je tzajcaagy, moy je' ydiscípulos ajcxy. E co Jesús jadu'n tuñ, chi ymɨnañ: ―Caaygɨx jada tzajcaagy. Jada tzajcaagy ɨɨch jada nninïcx. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chi Jesús conɨ̈gy je ügy vaso, e co Dioscojuyip yajnajxy, chi moyday ajcxy je ügy, e nidüg'ócɨy ajcxy uucy je ügy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chi Jesús ymɨnañ: ―Jada ügy ɨɨch nnɨ'py'ajtpy huɨdibɨ temamb yogamb. Je' jada jemybɨ Dios ycötújcɨn huɨdibɨ Dios yejc mɨɨd jäy ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Janch tɨy'ajt jadu'n nej ɨɨch miich ajcxy nimaaygɨxy, co ca' jadüg'oc n'üga'ñɨch vino nɨɨ, ixtɨ coonɨ anajty njädyɨch tzajpjoty ma yɨ Dios y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","E co Jesús etz ydiscípulos ajcxy ɨɨy tüg himno, chi ñɨcxy ajcxy ma je cop huɨdibɨ xɨɨjɨp Olivos. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chi Jesús ymɨnañ: ―Cham coodz xycöguëgaambɨch miich ajcxy, com jaybety jadu'n ma Dios ñecy ma jadu'n ymɨnañ: “Nyaj'ögaamybɨch je cöbixy cuend'ajtpɨ, e huin'it je cöbixy queeg-huäcxtähuɨp.” ");
INSERT INTO mcoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per co ɨɨch anajty njugypɨ́cyɨch jadüg'oc, co ɨɨch anajty tɨ n'ögyɨch, nɨ́cxɨbɨch jɨm Galilea jacjayɨjp, ca'ydɨ miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chi Pedro Jesús nɨmaayɨ: ―Oy ixyipy yɨ jacjadyii miich mdiscípulos ajcxy xycöguectäy, per ɨɨch ca' miich ngöguëga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Per Jesús nɨmay Pedro: ―Janch tɨy'ajt jadu'n nej yam nɨmäy, jadachambɨ coodz ma ca'nɨ anajty tzeyyaxɨ̈gy mejtz'oc miich xycoyüdza'ñɨch tugɨɨg'oc, mɨna'na'ñ co miich ca' xy'ixy'adyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","E Pedro ca' anajty cöbɨga'ñ nej Jesús ym­ɨnañ, chi mɨctägy mɨnañ: ―Ca' ɨɨch miich ngoyüdza'ñ, oy ixyipy ndɨm'o'cɨch quipxy mɨɨd miich. E nañ actɨm jadu'n jacjadyii Jesús ydiscípulos ajcxy ymɨnañ nej Pedro tɨ ymɨnañ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús mɨɨd ydiscípulos ajcxy oyja'ty ma tüg it huɨdibɨ xɨ́ɨjɨp Getsemaní, chi Jesús je ydiscípulos ajcxy nɨmay: ―Ɨña' miich ajcxy ya, namɨ n'ocnɨcxyɨch jɨm'amy Dios mɨbɨjctzoob. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chi Jesús mɨɨd nɨcxy jëda'ajty Pedro, Jacobo etz Juan ma tüg it ahuingujc. Chi Jesús ytɨgɨɨy tajpɨ maybɨ jɨhuɨɨy jotmay. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chi Jesús ymɨnañ: ―Njɨhuɨɨybɨch tüg jotmay nej n'öga'ñɨch. Huɨ́'mgɨx miich ajcxy ya etz juugy m'íjtcɨxɨpy, ca' mmáagɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chi Jesús ñɨcxy jac'amɨjcɨ'm, Dios mɨbɨjctzoy, e may'ajt pɨjctzoy co ixyipy ca' mɨnaxy yajnaxy je tzaachypɨ huɨdi anajty ypadamy je huin'it hora. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","E Jesús anajty Dios mɨbɨjctzoy ymɨna'ñ: ―Dios, mɨɨd miich ca' ni ti chípɨty. Pɨ́jcɨgɨch jadayaabɨ tzaachypɨ ayo'n, per ca' yjadú'nɨty nej ɨɨch ndzójcɨn, huen tuñyii jadu'n nej miich mdzójcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Co Jesús nihuimbijty Pedro, Juan, etz Jacobo, chi oy ajcxy paady tɨ anajty ymɨ'ó'ccɨxy. Chi Jesús Pedro nɨmay: ―Simón, ¿nej tɨ mmɨ'ögy? ¿Nej ca' mmadäga'ñ m'idɨpy juugy tüg hora? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jugy'íjtcɨx, e mɨbɨjctzoogɨx Dios ca'ydɨ jɨbɨctuuyb mdɨgɨɨygɨxy. Janch tɨy'ajt co jotjoty ooy mnijot'ájtcɨxy mdunaangɨxy yɨ oybɨ. Per yɨ mninïcx oy amaayɨty. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chi Jesús jadüg'oc huinhuäctuuty je' ydiscípulos ajcxy, e jadüg'oc ñɨcxy Dios mɨbɨjctzoob. May'ajt pɨjctzoy tɨm jadu'n nej je jayɨjp'atypɨ anajty tɨ ymɨna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chi Jesús yhuimbijty ma anajty ajcxy ydiscípulos yajpaady, e jadüg'oc oy pátcɨxy tɨ anajty ymɨ'öccɨxy, com ca' ajcxy mɨmadägy mähuɨɨ, e ni ca' ajcxy jajty nej adzohuɨpy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mɨdugɨɨg'oc Jesús ñɨcxy ma je' ydiscípulos ajcxy, e ymɨnañ: ―¿Nej ya mjacmáagɨxp mjacpoocxcɨxp? Maagɨx poocxcɨx jadachambɨ. Tɨ mɨɨd jadu'ñyɨ. Tɨ je tiempo huaad'ájtnɨ mɨna ɨɨch, je jäy huɨdibɨ tzoon tzajpjoty, xycɨ̈yegɨpy ajcxy ma yɨ jɨbɨc jäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maybɨdɨ̈gcɨx, tzoc jámɨm. Chi ymiiñ je jäy huɨdibɨ xycɨ̈yegaambɨch ma nmɨdzípɨch. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Capxp anajty Jesús, co Judas oyjäty ma Jesús yajpaady. Judas hue' je' nidügtɨ je majmetzpɨ huɨdibɨ Jesús yhuin'ijx. Judas mɨɨd miiñ mayjäy huɨdibɨ ajcxy mɨɨd pujx etz quipy. Je teedy mɨjtungmɨɨdpɨ, je escribas ajcxy, etz je mɨjjäydɨjc ajcxy tɨ anajty quexy je mayjäy huɨdibɨ anajty madzamb Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, je huɨdibɨ anajty cɨ̈yegamb Jesús, hue' anajty jayɨjp tɨ moy je mayjäy tüg ijxpejt huɨdibɨ mɨɨd jëb ajcxy ijxcabip Jesús. Jadu'n jayɨjp Judas ycapxytuñ mɨɨd yɨ' ajcxy, e ymɨnañ: ―Je jäy huɨdibɨ anajty ndzücxypɨch, yɨ' je' anajty Jesús. Madzɨpy ajcxy, e myajnɨ́cxɨp miich ajcxy yajxon cuend'aty. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mɨc'amy co Judas oyjädy ma Jesús yajpaady, chi nimɨjhua'cy, e nɨmay: ―Huindzɨn, Huindzɨn. E co jadu'n ymɨnañ, chi Judas Jesús tzücxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chi mɨc'amy je mayjäy Jesús mach, e yajnɨcxy ajcxy mach. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per nidügtɨ Jesús ydiscípulos juudy ypujxy ma ytɨjc, chi je teedy mɨjtungmɨɨdpɨ tüg ytumbɨ yajtzaachɨɨyɨ, quejtzpujxɨ tüg ytätzac. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chi Jesús je mayjäy nɨmay: ―¿Ti co miich ajcxy xyñimiiñɨch mɨɨd pujx etz quipy, jadu'n nej jɨhuɨ̈y ɨɨch tüg meetzpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jabom jabom nyaj'ixpɨjcyɨch jäy jiiby ma Dios ytɨjc ma miich ajcxy myajpaady, e ni ca' miich ajcxy xymajchɨch. Paady jadu'n ytunyii yjadyii jɨgɨx yɨ' yajcuydumb nej ity jaybety ma Dios ñecy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chi je' ydiscípulos ajcxy yajhuɨ'my Jesús naydügpajc. Chi je' ajcxy yqueegy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per tüg yujcyeeg anäg huɨdibɨ anajty payöy Jesús nïmóchɨty anajty mɨɨd tüg sábana. Chi Jesús ymɨdzip ajcxy majch je yujcyeegpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chi je yujcyeegpɨ cɨ̈queegtuty je mayjäy, yajhuɨ'my ysábana, e yquecytzögy nïhuädz ixhuädz. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chi ajcxy yajnɨcxy Jesús mach ma je teedy mɨjtungmɨɨdpɨ yajpaady. Chi mɨc'amy ñaymujcɨ tüg'ócɨy teedy ajcxy huɨdibɨ mɨjtungmɨɨdɨp, e tüg'ócɨy mɨjjäydɨjc, etz tüg'ócɨy escribas ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Chi Pedro jɨguëgy anajty panɨcxy je mayjäy ajcxy ixtɨ oy yja'ty ma je teedy mɨjtungmɨɨdpɨ ytɨba'. E jɨm ixtacy quipxy mɨɨd policía ajcxy agujc, yxaamgɨxy anajty ma jɨɨnba'. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Je teedy ajcxy mɨjtungmɨɨdpɨ etz tüg'ócɨy je judíojäy ytungmɨɨdpɨ ajcxy yhuinma'ñ'ixtaaygɨxy nej ajcxy jëb Jesús yajpocyca' mɨɨd ajcxy yxɨ̈huɨn, e jadu'n jëb mooygɨxy yɨ öcɨn. Per ca' ajcxy paady huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mayjäy nïhuambejty Jesús mɨɨd anɨɨ, e ca' ajcxy y'ayuc ytügɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nijëjɨty jäy ytɨnayɨ̈gy juntajoty, e nïhuambety ajcxy Jesús, ymɨnaangɨxy: ");
INSERT INTO mcoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ɨɨch ajcxy amɨdo'ijt Jesús y'ayuc tüg tecy, co jadu'n ymɨnañ: “Njidaamybɨch jada Dios ytɨjc huɨdibɨ jäy tɨ cójcɨxy, e codugɨɨg xɨɨ gojtɨgadzipɨch huingbɨ huɨdibɨ ca' jäy cojy.” ");
INSERT INTO mcoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per ni ca' ytügɨɨy ajcxy y'ayuc nej ajcxy Jesús nïhuambejty, ac tɨgachjaty nidüg nidüg ymɨnañ ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chi je teedy huɨdibɨ je jacmɨjtungmɨɨd ytɨnayɨ̈gy juntajoty, chi y'amɨdooy Jesús e nɨmay: ―Jesús, ¿ca' nej m'adzohua'ñyɨ? ¿Ca' mmɨdoy nej xychachxɨ̈gɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per Jesús amoñ y'ijty. Ca' ti ayuc adzohuimbijty. Chi je teedy jadüg'oc mɨgapxy Jesús nɨmay: ―¿Nej miich je' je Cristo, je Dios y'ung? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chi Jesús ymɨnañ: ―Janch jadu'n, ɨɨch je' je Cristo, je jäy huɨdibɨ tzoon tzajpjoty, e miich ajcxy xy'ixɨpɨch ɨñäyɨch ma je mɨjpɨ Dios ymɨjc a'oy'amy. Nañ jadu'n xy'ixɨpyɨch miich ajcxy jocjoty co anajty nhuimbityɨch jadüg'oc ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chi je teedy huindzech huinhuocy ycɨ'm yhuit, je' je' tɨy'ájtɨp co ca' anajty yjotcújcɨty mɨɨd Jesús y'ayuc, chi ymɨnañ: ―¿Ti testigo njac-huaanɨm? ");
INSERT INTO mcoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Miich ajcxy cɨ'm tɨ mmɨdoogɨxy yɨ' y'ayuc, jadu'n nej ycapxtɨgoy mɨɨd Dios. ¿Nej miich ajcxy mɨnaangɨxy? Chi nidüg'ócɨy ajcxy ymɨnañ co janch jadu'n Jesús mɨj oy tɨ ycapxtɨgoy mɨɨd Dios ytɨy'ajt, paady huaad mooygɨxy yɨ o'cɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chi nijëjɨty jäy yhuindzujɨ̈gy Jesús. Chi ajcxy huingoxodzɨy, cójxcɨxy, e chi ajcxy nɨmay: ―Octɨygapx. ¿Pɨn tɨ xycojxy? E je policiatɨjc ajcxy cojxy Jesús ma yhuiñyjɨjp. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro tɨbäy anajty y'ahuixy. Chi ñimɨjhuäcɨ tüg tumbɨ töxyjäybɨ huɨdibɨ anajty tumb ma je teedy ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Co je töxyjäy ijxpaty Pedro ɨñäy anajty jɨɨnba'áy, yxaamb anajty. Chi huindɨcxpejty Pedro, e nɨmay: ―Miich nañ mɨɨdhuɨdijtpy anajty je Jesús yɨ Nazaretpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per Pedro ca' cöbɨjcy je töxyjäy y'ayuc, e ymɨnañ: ―Ca' n'ixy'adyiijɨch jada Jesús. Ni ca' nhuinjɨhuɨ̈yɨch ti miich nimɨydacpy. E mɨc'amy Pedro ypɨdzɨmy jiiby, e tɨm huin'ítɨy tüg tzeyñɨ'aa oy yaaxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chi jadüg'oc je tumbɨ töxyjäybɨ huindɨcxpejty Pedro, e nɨmay je jäy ajcxy huɨdibɨ jɨm yajpatp huingon, e ymɨnañ: ―Jada je' nidügtɨ huɨdi anajty mɨɨd huɨdity Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Chi Pedro jadüg'oc ymɨnañ co ca' ix'adyii. Co hueeñɨ, je jäy ajcxy jadüg'oc Pedro nɨmay: ―Janch co miich je' nidügtɨ ma Jesús yjäy miñ, Galileo jäy miich, com nmɨdooybɨch miich m'ayuc nej Galileo jäy ycápxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Co ajcxy jadu'n ymɨnañ, chi Pedro mɨctägy ñaygogapxɨ co ca' yɨ' mɨɨdhuɨdity Jesús, ymɨnañ: ―Dios y'ijxpy ñejhuɨɨyb co tɨy'ajt ngapxyɨch, co ca' n'ixy'adyiijɨch yɨ Jesús huɨdibɨ miich ajcxy mnigapxyp. ");
INSERT INTO mcoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Co Pedro ycapxymaayɨ tɨm huin'itɨy tüg tzeyñɨ'aa yaaxɨ̈gy mɨmejtz'ocpɨ. Huin'it Pedro jäymetzcoody nej Jesús ñɨmäyii: “Cham coodz jayɨjp ca'nɨ anajty tzeyñɨ'aa yaaxɨ̈gy metz'oc, tɨ anajty miich mɨna'ñ tugɨɨg'oc co ca' xy'ix'adyiijɨch.” Co Pedro jadu'n jäymejtzcoody Jesús y'ayuc, chi tajy may ñayjɨhuɨɨyɨ, e ytɨgɨɨy yaaxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Co yxɨmɨɨy, chi je teedy ajcxy huɨdibɨ mɨj tung mɨɨd, je mɨjjäydɨjc, je escribas ajcxy, etz tüg'ócɨy judíojäy huɨdibɨ mɨj tung mɨɨd yöymujctay ajcxy. Chi nidüg'ócɨy ajcxy yajnɨ́cxcɨxy Jesús cɨ̈xoch ma Pilato, je gobernador. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesús y'amɨdooy, nɨmay: ―¿Nej miich rey'ajtp ma yɨ judíojäy ajcxyɨ? Chi Jesús ymɨnañ: ―Miich jadu'n mɨnamb. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Je judío teedy ajcxy huɨdibɨ mɨjtungmɨɨdpɨ mɨctägy tzachxɨ̈gɨxy Jesús mɨɨd canaagnax xɨ̈huɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chi Pilato jadüg'oc Jesús y'amɨdooy, nɨmay: ―¿Ca' nej m'adzohua'ñɨ? Ix nej yɨ mmɨdzip ajcxy xychachxɨ̈gɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Chi Jesús ca' ni nej y'adzooy. E Pilato ooy chachhuinmay'ahuɨdijty. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Com xɨɨjoty anajty, je gobernador Pilato najtzmadzɨɨy tüg machyjäy, je huɨdibɨ je mayjäy anajty ypɨjctzoogɨxyp. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pujxtɨjc ɨñaayb anajty jɨm Jerusalén tüg machyjäy huɨdibɨ anajty yxɨɨ Barrabás. Barrabás pujxtɨjc ɨñaayb anajty quipxy mɨɨd jacjadyii jäy huɨdibɨ anajty tɨ mɨdziptzoon je gobierno romano, e tɨ anajty yjäyyaj'ó'ccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","9","Co anajty je may yxɨɨ'ajtpɨdɨjc may'ajt pɨjctzoogɨxy ma Pilato co najtzmadzɨ̈huɨp tüg machyjäy, chi Pilato ymɨnañ: ―¿Nej mdzojccɨxyp co nnajtzmadzɨ̈huɨbɨch je judíojäy ajcxy yrey? ");
INSERT INTO mcoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato ñejhuɨɨyb anajty co mañ'ajtɨngɨ́xy anajty ajcxy je teedy mɨjtungmɨɨdpɨ tɨ cɨ̈yejccɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per co Pilato jadu'n ymɨnañ, chi je teedy ajcxy mɨjtungmɨɨdpɨ ooy ajcxy yajhuamgoty yajjɨhuɨygoty je mayjäy co huen je Pilato najtzmadzɨ̈y je Barrabás. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chi Pilato y'amɨdooy je mayjäy jadüg'oc: ―¿Nej miich ajcxy mdzocy ndunɨpyɨch mɨɨd jada yëydɨjc huɨdibɨ jäy ajcxy ytijpy co yrey'aty ma yɨ judíojäy ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chi je mayjäy mɨc ymɨnangottay: ―Yajcruutzpet. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chi Pilato ymɨnañ: ―Per ¿ti yɨ' tɨ tundɨgoy? Huin'it je mayjäy nïgɨ mɨc ymɨnañ: ―¡Yajcruutzpet! ");
INSERT INTO mcoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Co jadu'n je mayjäy ajcxy mɨctägy ymɨnanday, chi Pilato anajty yajjotcujc'adaangɨxy je mayjäy, chi najtzmadzɨɨy je Barrabás. E co yajcɨ̈'ajttay yɨ Jesús, chi cɨ̈yejcnɨ co huen yajcruutzpedyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chi je soldados ajcxy yajnɨcxy Jesús ma je agujctɨjc tɨba', e jɨm ñaymujcɨ tüg'ócɨy soldados ajcxy huɨdibɨ yajpatp anajty jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chi ajcxy yajnïjenɨɨy je Jesús tüg rey yhuit, color ucypɨ e yajcojenɨɨy ajcxy apy corona. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chi je soldados ajcxy ymɨnañ: ―¡Viva jada judío rey! ");
INSERT INTO mcoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chi je soldados ajcxy huojpy Jesús ma ycohuajc mɨɨd paxy, e huindzuj jɨjptzujcɨxy ooy, e huingojxtɨnay'ahuɨɨygɨxy janch ypaad nej jɨhuɨ̈y ooy huindzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Co je soldados ajcxy nɨxiictay yajxiictay Jesús, chi ajcxy jeenɨ je yreyhuit color ucypɨ, e yajnïjenɨɨy ajcxy ycɨ'm yhuit jadüg'oc. Chi ajcxy Jesús mɨɨdcajppɨdzɨmy co anajty yajcruutzpedaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tü'am ajcxy tüg jäy mɨɨdnaybatɨ, hue' anajty yxɨɨ, Simón, ycogájpɨty jɨm Cirene, Alejandro etz Rufo je' anajty yteedy. Hue' anajty choñ camjoty. Chi ajcxy adzip nɨmay Simón co huen jaccajpɨ Jesús ycruudz. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Chi ajcxy yajnɨcxy Jesús ma tüg it lugar huɨdibɨ yxɨɨ Gólgota, je ayuc Gólgota jadu'n yhuimbɨdzɨmy o'cpɨ cohuajc. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chi ajcxy moy Jesús vino huen ügy tem huɨdity mɨɨd mirra tzoy. Per ca' Jesús cöbɨjcy je vino nɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chi ajcxy yajcruutzpejty Jesús. E huin'it je soldados ajcxy suerte ijxy, co anajty ajcxy Jesús yhuit yajhuäcxaanɨ, oc'ixaangɨxy pɨn anajty ocjë'ájtɨp. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Petyxɨɨ anajty co ajcxy yajcruutzpejty Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Je ayuc huɨdibɨ ajcxy yjaay ma Jesús cruudz, jadu'n ymɨnañ: ―Je judíojäy ajcxy yRey. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Quipxy mɨɨd Jesús ajcxy yajcruutzpejty metz meetzpɨ. Tüg meetzpɨ ajcxy yajcruutzpejty a'oy'amy ma Jesús ymɨjc, e jadüg anajty'amy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yajcuyduñ nej anajty jaybety miñ ma Dios ñecy, ma jadu'n ymɨnañ: “Yaj'amɨchoomujc je Cristo mɨɨd je pocyjäy ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Je mayjäy huɨdibɨ ajcxy naxɨɨyb anajty ma Jesús yajpaady cruutzcɨ́xy, ooy anajty ajcxy ycöjɨgɨɨyñ, nɨxiicy yajxiicy ajcxy Jesús, ymɨnañ ajcxy: ―Bah, miich huɨdibɨ Dios ytɨjc mjidaanɨp, e codugɨɨg xɨɨ huingbɨ myajpɨdɨ̈ga'ñ, miich cɨ'm cham naygohuaanɨ, e mɨnac cruutzcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Nañ jadu'n je teedy ajcxy mɨjtungmɨɨdpɨ etz je escribas ajcxy nɨxiicy yajxiicy ajcxy Jesús ñayñɨmayɨ miñ xyɨpy: ―Jada Jesús tɨ cohua'ñ jacjadyii jäy, e ca' jaty nej cɨ'm ñaygohua'nɨɨyb. Pen janch, co jada Jesús yjëjɨty je Cristo huɨdibɨ rey'adamb ma yɨ judíojäy ajcxy, ymɨɨd ixyipy mɨc'ajt jaydëb cɨ'm ymɨnagɨpy cruutzcɨ́xy. Co jadu'n ixyipy n'íjxɨm co cɨ'm tɨ ymɨnacy cruutzcɨ́xy, huin'it mɨbɨ́jcɨm co janch jada jëjɨty je Cristo huɨdibɨ rey'ajtp ma yɨ Israel jäy. Nañ jadu'n je metz meetzpɨ ajcxy huɨdibɨ cruutzpejt quipxy mɨɨd Jesús nɨxiicy yajxiicy ajcxy je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Co ycujcxɨɨjɨɨy, chi ycoodzɨygɨday tüg'ócɨy naaxhuiñ. E jadu'n je naaxhuiñ y'ijty coodz ixtɨ mɨnacyxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mɨnacyxɨɨ Jesús mɨc ymɨnañ mɨɨd aramaico ayuc: ―Eloi, Eloi, ¿lama sabactani? ―yɨ jadu'mbɨ ayuc hue' yhuimbɨdzɨmy: Tat Dios. Tat Dios. ¿Na'amy co tɨ xy'ix'ixyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nijëjɨty jäy huɨdibɨ anajty jɨm yajpatp huingon ma Jesús, co mɨdoo jadu'n ajcxy Jesús y'ayuc, chi ajcxy ymɨnañ: ―Mɨdoogɨx, Elías yɨ' yaaxtaayb. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chi nidügtɨ ajcxy ninɨcxy Jesús poyɨ̈gy, tɨ anajty yajxoogy pixy mɨɨd vinonɨɨ ta'mbɨ, e yajjɨjpxodzɨɨy je pixy ma tüg paxy, e jadu'n yajja'ty je vino nɨɨ ta'mbɨ ma Jesús y'ahuac, huen muucɨp je vino nɨɨ ta'mbɨ. Co jadu'n tuñ, chi ymɨnañ: ―Tzoc oc'ahuíjxɨm pen mimb Elías, e miñ yajmɨnagyii ma yɨ cruudz. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chi Jesús mɨc ycapxqueegy, chi y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Co Jesús y'o'cy, chi je mapxhuit ycɨɨtzhua'cxy tɨnä'amy huɨdibɨ anajty mɨɨd y'adɨydútyɨty je Dios ycuarto ma je teedy mɨjtungmɨɨdpɨ ytɨgɨ̈y tüg tecypajc jɨmɨjt jɨmɨjt. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Je soldado huindzɨn huɨdibɨ anajty tɨnaayb ma Jesús yhuinduu, co jadu'n mɨdoy nej Jesús mɨc yaaxqueegy, e ijxy nej y'ögy, chi ymɨnañ: ―Janch co jadayaabɨ yëydɨjc anajty Dios ung'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nañ jɨm anajty nijëjɨty töxyjäydɨjc ymɨj'íjxcɨxy jɨguëgy. Jɨm anajty yajpaady María Magdalena, etz je jadügpɨ María, Jacobo je mutz'anägnɨp ytaj, etz José ytaj. Nañ jɨm anajty yajpaady Salomé. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jadayaabɨ töxyjäy ajcxy mɨɨdhuɨdijt Jesús, e tɨ anajty pubéjtcɨxy taabɨ anajty Jesús yajpaady jɨm Galilea ñaaxjot. Nañ jadu'n anajty jɨm yajpaady jacnaagɨty töxyjäydɨjc ajcxy huɨdibɨ anajty tɨ ycoody jɨm Jerusalén quipxy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Paady co chu'ɨɨyñɨ hue' anajty viernes mɨna judíojäy ñayyajpocyñïhuáatzɨgɨxy, jaydëb anajty amay'adaangɨxy je sábado xɨɨ je com jabom. Chi José huɨdibɨ anajty cogajp Arimatea yjotmɨctuñ, chi ytɨgɨɨy ma je gobernador Pilato, pɨjctzooy may'ajt co yajnaaxtɨgɨ̈huaanɨ Jesús ñinïcx. E hue' je' José anajty tungmɨɨd ma yɨ judíojäy ajcxy. José yjɨjp'ijxpy anajty mɨna Dios pɨdäga'ñ yɨ' y'ané'mɨn ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ooy tzachhuinmay co Jesús tɨm mɨc'amy tɨ y'ögy anajty, paady huoodzoy je soldado huindzɨn, e tɨy'ajt pɨjctzoy pen janch co Jesús tɨ anajty y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Co je soldado huindzɨn tɨy'ajt yejcy co Jesús tɨ anajty y'ögy, chi nɨmay José co huen yajnaxtɨgɨ̈huɨpy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chi José juy poob huit, e co yajmɨnajcy Jesús ñinïcx, chi mo'ñ mɨɨd je poob huit, e chi pɨdacy ma tüg tzaajut huɨdibɨ anajty tɨ yajtzejtztüdy tɨ yajpadüdy ma tüg tzaahuingueetz. E chi yaj'adujcy je öcpɨ jut mɨɨd tüg mɨj tzaa. ");
INSERT INTO mcoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E je metzpɨ töxyjäy María Magdalena etz je jadügpɨ María huɨdibɨ José ytaj'ajtpy huindɨɨcxp anajty ajcxy co Jesús ñaaxtɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Com jabom jopy, domingo, chi je tugɨɨg töxyjäy ajcxy María Magdalena, María Jacobo ytaj etz Salomé juy ajcxy tzoy huɨdibɨ ooy oy xuugy, pɨdägaangɨxy anajty ma Jesús ñinïcx. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Je tugɨɨgpɨ töxyjäy chooñ domingo, semaan ixtɨgɨ', tɨm jopyñɨ. Tɨ anajty ypɨdzɨmnɨ je xɨɨ co ajcxy oyjädy ma je öcpɨ jut. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Chi je tugɨɨgpɨ töxyjäy ajcxy nayñɨmaayɨ miñ xyɨpy: ―¿Pɨn xy'ocpubéjtɨm jɨgɨ̈huɨpy je mɨj tzaa huɨdibɨ mɨɨd agɨɨyɨty je öcpɨ jut? ");
INSERT INTO mcoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per co ajcxy ijxy je öcpɨ jut, chi ajcxy ijxy ahuingujc je mɨj tzaa anajty ytɨguejcnäy huɨdibɨ je öcpɨ jut anajty agɨɨydujcp. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chi ajcxy ytɨgɨɨy jutjoty. E chi ajcxy ijxy tüg yeeg'anäg ɨñäy anajty a'oy'amy ma je' ajcxy. E je yeeg'anäg poob huit anajty ymɨɨd. Co ajcxy jadu'n ijxy je yeeg'anäg jiiby jutjoty, chi je töxyjäy ajcxy ooy chɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chi je yeeg'anäg nɨmay je töxyjäy ajcxy: ―Ca' ooy mdzɨgɨɨygɨxy. Miich ajcxy je' m'ijxtaaygɨxp je Jesús huɨdibɨ cogajp Nazaret, je huɨdibɨ jäy ajcxy yajcruutzpejt. Tɨ je' yjugypɨcy. Ca' je' ya. Oc'íjxcɨx ya ma ajcxy pɨdaaccɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nɨ́cxcɨx, nɨmaaygɨx Pedro etz yɨ jacjadyii Jesús ydiscípulos ajcxy co Jesús nɨ́cxɨp jayɨjp jɨm Galilea, e jɨm Galilea ñaybadɨɨyb ajcxy mɨɨd Jesús, jadu'n nej ajcxy ñɨmaayɨ jayɨjp'aty. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chi je töxyjäy ajcxy jɨm yqueegy ma je öcpɨ jut, com tɨ anajty ooy chɨgɨɨygɨxy. Ooy anajty ajcxy chɨyuy mɨɨd tzɨgɨ'ñ. E ni ca' ajcxy nɨmay ni pɨn nej anajty tɨ íjxcɨxy, com ooy anajty chɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Je domingo, semana ixtɨgɨ', co Jesús yjugypɨcy, chi ñayguëxɨ̈cɨ jayɨjp ma María Magdalena, je' je' je töxyjäy huɨdibɨ anajty Jesús tɨ yajpɨdzɨmɨ huɨxtujc ca'oybɨ ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chi María Magdalena ñɨcxy ma Jesús ydiscípulos ajcxy huɨdibɨ mɨɨd yhuɨdijty, e nɨmaaygɨxy nej anajty yɨ' tɨ ixy Jesús co tɨ yjugypɨcy jadüg'oc. E Jesús ydiscípulos ajcxy ooy anajty ytájycɨxy ymáygɨxy etz yaaxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","E co ajcxy mɨdoohuɨ je María y'ayuc, co anajty tɨ ixy Jesús juugy, chi ca' ajcxy mɨjpɨdaacɨ y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Co hueeñɨ, Jesús ñayguëxɨ̈cɨ nañ jadu'n ma metz je' ydiscípulos huɨdibɨ ñɨcxp anajty ajcxy camjoty. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chi je metzpɨ discípulos ñɨcxy ajcxy mɨc'amy oy nɨmaaygɨxy je jacjadyii discípulos ajcxy co tɨ íjxcɨxy Jesús. E je jacjadyii discípulos ca' ajcxy mɨjpɨdaacɨ je metzpɨ discípulos y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jac com jecy, Jesús ñayguëxɨ̈cɨ ma je majctügpɨ discípulos ajcxy ma anajty y'ɨñaaygɨxy ma caydac. Chi Jesús ojy ajcxy co ca' ajcxy mɨbɨ́jccɨxy co ooy ajcxy yjot yjuuñɨty, ca' ajcxy mɨjpɨdägy jacjadyii pɨn anajty tɨ y'íjxcɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús je' ydiscípulos ajcxy nɨmay: ―Nɨ́cxcɨx miich ajcxy ma tüg'ócɨy naaxhuiñyjäy, ma tüg'ócɨy naax cajp, e capxhuäcxcɨx ajcxy je oybɨ ayuc nej jäy ajcxy jëb y'almanïdzögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pɨnjaty mɨbɨjc etz ñɨɨbejtcɨxy, ypaadɨp ajcxy y'almanïdzoocɨn. Per, pɨnjaty ca' mɨjpɨdägy tɨy'ajt hue' ajcxy y'alma tɨgoyɨp mɨɨd ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yɨ jäy ajcxy huɨdibɨ mɨbɨjcp, ooy ajcxy ijxpejt túngɨxɨpy. Mɨɨd ɨɨch nxɨɨ ɨɨch nmɨc'ajt yajpɨdzɨmɨpy ajcxy ca'oybɨ ma jäy ajcxy yjot yhuinma'ñ. Nañ jadu'n ycápxgɨxɨpy huingbɨ ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ymadzɨpy ajcxy tza'ñ, e ca' nej yjájtcɨxɨpy. E co ajcxy veneno ügɨp, ca' ajcxy ypa'mdunɨɨb. E co ajcxy cɨ̈nïxájɨpy pa'mjäy, tzögɨp je pa'mjäy. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","E co je Huindzɨn Jesús ycapxy ycɨjxy mɨɨd je' ydiscípulos ajcxy, chi ypätɨgɨɨyñɨ tzajpjoty. Jiiby tzajpjoty Jesús yajpaady ma Dios ymɨjc a'oy'amy, mɨɨd mɨj'ane'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chi Jesús ydiscípulos ajcxy chooñ ñɨ́cxcɨxy cajp cajp capxhuäcxy ajcxy Jesús y'ayuc ma nidüg'ócɨy naax cajp. E je Huindzɨn Jesús ooy ajcxy ypubejtɨ ypudɨgɨɨyɨ, mɨc'ajt moy je' ajcxy mɨɨd je ijxpejt je mɨjhuinma'ñ huɨdibɨ ajcxy tumyb. Jadu'ñyɨ jadu'n. Amén.");
INSERT INTO mcoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mayjäy tɨ cojaay je ayuc je tɨy'ajt huɨdi ɨɨch ajt nejhuɨɨyɨm co janch ytɨy'ájtɨty, tüg'ócɨy jadu'n nej Jesús chondacy yjugy'ájtɨn ya naaxhuiñ ixtɨ mabaad ycogɨxɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tüg'ócɨy je tɨy'ajt jadu'n nej ajt xyñɨmaayɨm huɨdi cɨ'm ijx mɨdou nej chondacy ixtɨ mabaad ycogɨxɨɨy, je' ajcxy huɨdibɨ capxhuäcxy Jesús y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ɨɨch nañ jadu'n tɨ nyajcɨ̈yöyɨch tɨ nyajtecyyöyɨch yajxon je tɨy'ajt nej Jesús chondacy je' chɨnaayɨn ya naaxhuiñ ixtɨ mabaad ycogɨxɨɨy. Paady ycɨxpɨ ɨɨch nhuinma'ñ pɨdägy co ɨɨch miich nyajnijayɨ̈hua'ñ tüg'ócɨy je tɨy'ajt, miich oyjäybɨ, Teófilo. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jɨgɨx miich nañ jadu'n mnejhuɨ̈huɨpy yajxon je tɨy'ajt, jadu'n nej miich tɨ m'ixpɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jadu'n ytunɨ yjajtɨ co anajty Herodes yrey'aty ma Judea naax cajp, jɨm anajty tüg judío teedy hue' anajty yxɨɨ Zacarías. Je' anajty semandumb mɨɨd Abías y'ajugytɨjc y'amɨgügtɨjc. Je Zacarías ypɨjcy mɨɨd Aarón y'ocnɨɨx, hue' je' anajty yxɨɨ Elisabet. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dios y'ijxyp ñejhuɨɨyb co je' anajty ajcxy ytudägyjäyɨty nimetz. Je' ajcxy ycuydumyb tüg'ócɨy yɨ Huindzɨn Dios ycapxy y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Je' ca'p anajty ajcxy y'ung ni tüg, e jadu'n ajcxy ymɨjäyɨɨñ nimetz. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Chi tügtecy Zacarías mɨɨd y'ajugy y'amɨgüg yteedy'ájtcɨxy anajty ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jadu'n nej teedy ajcxy ycostumbre mɨɨdɨty, chi ñigootɨ tung je Zacarías mɨna ypoomjogɨpy jiiby ma yɨ Huindzɨn Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tüg'ócɨy je mayjäy ooy anajty Dios mɨbɨjctzoogɨxy tɨba'y. Yam Zacarías tzajtɨgoty ypoomjocy, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","co ñayquëxɨ̈cɨ Huindzɨn Dios y'ángel tüg ytɨnäy a'oy'amy ma je poomjoctac. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Co Zacarías ijxy je ángel, chi ooy chɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chi je ángel nɨmaay Zacarías: ―Ca' mdzɨgɨ̈y, tɨ Dios mɨdooy yɨ mjuydácɨn mnucxtácɨn. Yɨ mdöxyɨjc Elisabet ypaadɨpy tüg ung yëydɨjcpɨ, e mxɨɨmöhuɨpy Juan. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mjotcujc'adɨp mxondägɨp miich etz mdöxyɨjc, nañ may yɨ jäy yjotcugɨ̈huɨpy co anajty m'ung tɨ ypi'c'aty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chi yɨ m'ung ycömay'ida'ñ ma Dios. Ni ca' ügɨpy vino ni jocnɨɨ. Ma ca'nɨ anajty yma'xung'aty ymɨɨd'adɨpy yɨ Dios yjɨhuɨ'ñ ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yɨ' yajjothuimbidɨp may Israel jäy ma yɨ' ajcxy yHuindzɨn Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Je' nɨcxy ycogapxy'aty ma yɨ jäy ajcxy huinmɨc jotmɨc mɨɨd Dios yjɨhuɨ'ñ ymɨc'ajt, tɨm jadu'n nej Elías jecy'ajty ycogapxy'ajty huinmɨc jotmɨc mɨɨd Dios yjɨhuɨ'ñ ymɨc'ajt. Je' m'ung yajjothuimbidɨpy je ungdeedy ajcxy huɨdibɨ ca' y'ung ixaangɨxy, nañ yajjothuimbidɨpy je jäy ajcxy huɨdibɨ ca' capxycöbɨcy yɨ Dios, jɨgɨx ajcxy paadɨpy oyjot oyhuinma'ñ. Nañ m'ung ñɨmähuɨpy je jäy ajcxy huen nayñi'ixɨ́ɨyɨgɨxy mɨɨd yHuindzɨn Dios ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chi Zacarías nɨmay je ángel: ―¿Nej jada ɨɨch nejhuɨ̈huɨpy penɨ janch huɨdibɨ xyajnɨmaaybɨch? Tɨ nmɨjjäyɨɨyñɨch, cham ndöxyɨjcɨch nañ tɨ ymɨjjäyɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chi je ángel y'adzooy: ―Ɨɨch Gabriel, ma Dios yhuinduu ni'ixɨ' n'ítyɨch. Dios tɨ xyquexyɨch cogapxy'ajtpɨ ma miich co nyajnɨmähuɨpy jada oybɨ ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jadachambɨ miich mhuɨ́'mɨpy uum, ni ca' m'ocjájtnɨp nej mgápxɨpy, mɨɨd co ca' mmɨbɨcy jada ɨɨch n'ayuc huɨdibɨ yajcuydunɨp co anajty tiempo patnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yam je mayjäy ooy ja'ahuíjxcɨxy Zacarías, ooy anajty ajcxy tzachhuinmaaygɨxy ti co chachhuäcxɨpy jiiby ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Co Zacarías ypɨdzɨmy, chi ca' anajty y'occapxnɨ. Chi je jäy ajcxy huinjɨhuɨɨy co tɨ anajty ixy tijaty jiiby ma Dios ytɨjc. Hue' je' yjacmɨydacy a'ɨxɨ̈y'amy, e oyhuɨ'mɨ̈y uum. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Co je semandung yajmay, chi Zacarías ñɨcxnɨ ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Co jadu'n yjajty, chi Elisabet jɨhuɨɨy co tɨ anajty y'ung tzɨmɨ̈gy cɨyɨ̈ gy. Chi yüch'ijty mɨgoox po', e ymɨnañ: “Jadu'n yɨ Huindzɨn Dios tɨ ytuñ mɨɨd ɨɨch jadachambɨ tiempo, tɨ xyjäymechɨch tɨ yajquëgy ɨɨch ndzöydu'n ma yɨ mayjäy ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Co tudujc po' maabɨ Elisabet anajty y'ungtzɨmɨ̈gy, chi Dios quejxy je' y'ángel Gabriel jɨm Galilea naaxjot ma je cajp huɨdi anajty yxɨɨ Nazaret. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chi Dios quejxy Gabriel ma anajty tüg töxy'anäg y'ity huɨdibɨ anajty ca'nɨ mɨdzɨnäy yëydɨjc. Je töxy'anäg tɨ anajty co'adzoy co pɨga'ñ mɨɨd tüg yëydɨjc huɨdi yxɨɨ José. José hue' anajty David y'ap y'oc. Je töxy'anäg hue' anajty yxɨɨjɨty María. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Co je ángel ytɨgɨɨy ma anajty María, chi nɨmay: ―María, Dios tɨ xy'ijxtɨy, je Huindzɨn Dios y'oy'ajt mɨɨd miich. Miich je' cömay y'idɨp ma tüg'ócɨy töxyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chi María co y'ijxy je ángel, chi chɨgɨɨy mɨɨd je' y'ayuc, chi huinmay ooy mɨɨd jada copxpócxɨn nej co yjadú'ñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chi je ángel ymɨnañ: ―María, ca' mdzɨgɨ̈y, miich Dios tɨ xy'ijxtɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jadachambɨ, m'ungdzɨmɨ̈gɨp, myajpi'c'adɨpy tüg mang, huɨdibɨ mxɨɨmöhuɨpy JESUS. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Je Jesús mɨj y'idɨpy, hue' je' yajtíjɨpy Dios tzajpjotypɨ y'ung. Chi je Huindzɨn Dios möhuɨɨyb je ané'mɨn huɨdi yɨ' ymɨj'ap ymɨjteedy David ymɨɨd anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Je Jesús ané'mɨp huinɨxɨɨ ma yɨ Jacob y'ap y'oc. Je' y'ané'mɨn camɨna ycɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chi María je ángel nɨmaay: ―¿Nej jada co yjadú'nɨty? Ɨɨch ca'nɨ nyëydɨjc mɨɨd tzɨnäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chi je ángel y'adzooy: ―Je Dios yjɨhuɨ'ñ ymɨc'ajt minɨp ma miich, je Dios tzajpjotypɨ ymɨc'ájtɨn xyajnïdujttähuɨp, je oyjäybɨ jäy huɨdi pi'c'adam, hue' yajtíjɨpy Dios y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","E cham Elisabet miich m'amɨgüg nañ jadu'n yajpi'c'adamy tüg mang ma tɨ ymɨjjäyɨɨyñɨ. Cham mɨdudujc po'bɨ maabɨ y'ung tzɨmɨ̈gy je huɨdibɨ jäy ytijpy ca' y'ung'ixaanɨ, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","com mɨɨdɨ Dios ca'ni ti chípɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chi María ymɨnañ: ―Jotcujc nguydunɨpyɨch yɨ Huindzɨn Dios chójcɨn, huen jadu'n tuñyii jadyii ma ɨɨch jadu'n nej miich m'ayuc xymöyɨch. Chi je ángel ñɨcxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Huin'it xɨɨ María choñ, ñɨcxy jottɨgoy ma yugjot, ma tüg cajp jɨm Judea naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chi ytɨgɨɨy ma Zacarías ytɨjc, e capxpocxy Elisabet. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chi jadu'n yjajty co Elisabet mɨdoohuɨ María ycapxpócxɨn, chi jɨhuɨɨy co y'ung yücxy ma yjot. E chi je Elisabet ooy yjotcugɨy mɨɨd je Dios yjɨhuɨ'ñ ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chi ymɨnañ janch mɨc: ―Cömay miich ma tüg'ócɨy töxyjäydɨjc, e cömay y'ida'ñ m'ung huɨdibɨ pi'c'adamb. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nej ɨɨch jada co jadu'n tɨ n'ahuägɨ̈y co nHuindzɨnɨch ytaj miñ xyco'ixɨ̈yɨch? ");
INSERT INTO mcoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Co tɨ nmɨdooyɨch yɨ mgapxpócxɨn, tɨ ɨɨch n'ung yücxy ma ɨɨch njot co chachjotcújcɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jotcujc'adɨp pɨnjaty tɨ ymɨbɨcy, co cuyduñ y'ida'ñ je ayuc mɨɨd je Huindzɨn Dios ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chi María ymɨnañ: Ooy mɨj n'ojadatyɨch yɨ Huindzɨn Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ooy nxondägyɨch mɨɨd Dios ycɨxpɨ, ɨɨch nnihuambɨ nyajtzoocpɨ, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","co yɨ' tɨ xyñi'ijxcɨdägyɨch, co ɨɨch ayoobɨ xytumbɨ'adyíijɨch. Jadachambɨ etz jacnɨcxp xɨɨ tiempo, tüg'ócɨy jäy ajcxy oy mɨna'nɨp co jotcujc'ájtpɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yɨ Dios tügpajc mɨ́jɨp, tɨɨbɨ tun mɨɨd ɨɨch, ooy yɨ' yxɨɨ ymɨ́jɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios ypa'ayooyb hueñypɨ́nɨty huɨdibɨ huindzɨgɨɨyɨp jadachambɨ etz jacnɨcxnɨ xɨɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios tɨ ooy tuñ mɨjpɨ huinma'ñ, tɨ jɨɨbɨcy pɨnjaty amɨj agɨx nayjɨhuɨɨyɨp ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dios tɨ yajpɨdzɨmy yɨ mɨjpɨ rey ma y'ane'my, tɨ mɨj'ajt möy ayoobɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pɨnjaty ayuu'ijtp anajty ymooy ti mɨɨd yjotcujc'adɨp, etz yɨ comeeñyjäydɨjc ajcxy tɨ ixmach ca' ni ti. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios tɨ pubety yɨ Israel jäy, yɨ' ajcxy ytumbɨ, mɨɨd co anajty tɨ pa'ayogoty je' ajcxy, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","jadu'n nej jecy'ajty Dios yajnɨmay je' n'ap ndeedy, je Abraham etz je'y'ap y'oc, co tunamb mɨɨd je' ajcxy huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Chi María tugɨɨg po' jɨm y'ijty mɨɨd Elisabet, chi yhuimbijtnɨ ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Co je Elisabet oy yajhuaad'ajtnɨ xɨɨ tiempo, chi yajpi'c'ajty tüg ymang. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chi ayuc mɨdooy ajcxy je ymɨjɨɨn ymɨdɨjc etz y'ajugy y'amɨgüg jadu'n nej Dios may'ajt tɨ tuñ mɨɨd Elisabet. Chi ajcxy ooy yjotcugɨy mɨɨd je' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chi jadu'n yjajty coductujc xɨɨ je ymɨjɨɨn ymɨdɨjc etz y'ajugy y'amɨgüg miñ ma Zacarías ytɨjc co anajty tɨy'ajttɨ̈huaangɨxy je pi'c'anäg. Chi ajcxy yajxɨɨ'ada'ñyii anajty jadu'n nej yteedy yxɨɨ Zacarías. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Chi ytaj ymɨnañ: ―Ca' xɨɨ'adɨɨyb Zacarías, hue' yɨ' huen xɨɨ'adyii Juan. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chi je' ymɨgügtɨjc ajcxy ymɨnañ: ―¿Na'amy? Ni tüg miich m'amɨgüg jadu'n ca' xɨ́ɨjɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chi ajcxy y'amɨdoohuɨ je' yteedy jadu'n a'ɨxɨ̈y'amy, nej yɨ' yajxɨɨ'ada'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chi Zacarías pɨjctzoy tüg necy, e jaay jadu'n: “Juan huen xɨɨ'adyii.” Chi je ymɨgügtɨjc ajcxy nidüg'ócɨy ooy jɨhuɨɨy huinmaay. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chi mɨc'amy Zacarías y'ahuac ahua'cxy e ytoodz yungɨɨy, chi oy ycapxɨ̈gy e jäymejch cömay yɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chi tüg'ócɨy ymɨjɨɨn ymɨdɨjc ooy chɨgɨɨy. Chi ajcxy nimɨydactay nej Zacarías tɨ yjaty ma tüg'ócɨy jäy huɨdibɨ tzɨnaayb Judea yuugjotypɨ tzɨnaaydac. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tüg'ócɨy pɨnjaty anajty mɨdoob je ayuc, chi jäymejtzhuɨ'm ajcxy ma yjot yhuinma'ñ, chi ñayñɨmáayɨgɨxy: ―¿Ti jada' ytunamyb jada pi'c'anäg? Com je Huindzɨn Dios je' mɨɨd y'ity. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chi je ungdeedy Zacarías mɨɨd je Dios yjɨhuɨ'ñ ymɨc'ajt Dios y'ayuc najtzcapxɨɨyɨ ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cömay yɨ Israel jäy yHuindzɨn Dios, co tɨ ni'ijxcɨdägy, tɨ cohua'ñ yɨ' ñaax ycajp, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dios tɨ quexy tüg mɨj nihuaambɨ yajtzoocpɨ, ma yɨ' ytumbɨ, David y'ap y'oc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Com Dios jadu'n ymɨnañ jecy'ajty mɨɨd yɨ' y'ayuc najtzcapxɨɨyb huɨdibɨ huätzjäyɨp; ");
INSERT INTO mcoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","je' xyñihuänaanɨm ma ɨɨch ajt nmɨdzip, nañ xypubedaanɨm xypudɨgɨ́huaanɨm ca'ydɨ xycɨ̈gähuɨɨyɨm huɨdibɨ ca' xy'ixaanɨm xychogaanɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Jaydëbɨ pa'ayoohuɨpy ɨɨch ajt nmɨj'ap nmɨjteedy, etz jäymedzɨɨyb jadu'n nej ayuc ahuanɨɨy mɨɨd je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jadu'n nej Dios janch huinɨjot y'ayuc ahuanɨɨy mɨɨd ɨɨch ajt nmɨj'ap nmɨjteedy Abraham jecy'ajty huɨdi anajty xymöhuaanɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Co nihuätzɨ̈ctuutɨm ma nmɨdzip, huin'it jaydëbɨ mɨyaaxɨm n'ojadájtɨm ca' ma tzɨgɨ'ñ jɨhuɨ'ñ, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mɨɨd huätzhuinma'ñ etz tudägy huinma'ñ ma yɨ' yhuinduu jabom jabom ixtɨ mɨbaad ndzɨnaayɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Miich ma'xung, jäy hue' myajtijɨp mɨjpɨ Dios y'ayucnajtzcapxɨɨybɨ. Miich nɨ́cxɨp cogapxy, nɨcx yajni'ixɨ̈ jäy mɨɨd Huindzɨn Dios ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yajni'ixɨ' yɨ cajpjäy jadu'n nej huaad ajcxy y'alma paadɨpy nihuáanɨn yajnïdzoocɨn, etz jadu'n nej huaad ajcxy ypocy huinmecxɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jadu'n nej Dios ɨɨch ajt tɨ xypa'ayoohuɨm co tɨ xyñi'ijxcɨdaacɨm etz xymooyɨm tɨɨcxɨn jájɨn huɨdibɨ tzomb tzajpjoty, ");
INSERT INTO mcoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","jaydëbɨ yajmöhuɨpy jäy ajcxy Dios ytɨy'ajt huɨdibɨ ajcxy tzɨnaayb agootztuum etz o'c jɨjp'am, jɨgɨx ajcxy xytümooyɨm ma je tudägypɨ tü'aa. ");
INSERT INTO mcoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Je pi'c'anäg yeeg yjodijy huinmɨc jotmɨc mɨɨd yɨ Dios yjɨhuɨ'ñ ymɨc'ajt. Chi chɨnaay adügtuum ma ca' pɨn, ixtɨ coonɨ xɨɨ tiempo paty mɨna ñɨ́cxɨpy cogapxy ma Israeljäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Huin'it xɨɨ Augusto César pɨdacy y'ané'mɨn huen tüg'ócɨy jäy nɨcxy necypejttaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Je jayɨjp'atypɨ padrón hue' je'yaj'oyɨɨy Cirenio huɨdibɨ anajty gobernador'ajtp jɨm Siria ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chi jäy ajcxy nidüg'ócɨy ñɨcxtay yajcojayɨɨybɨ nidüg nidüg ma ycɨ'mgajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chi José chooñ jɨm Galilea naaxjot ma je cajp huɨdi yxɨɨ Nazaret, ñɨcxy ajcxy jɨm Judea naaxjot ma je David ycajp, huɨdi yxɨɨ Belén. Yɨ José ñɨcxy jɨm Belén com ymɨj'ap'ajtpy ymɨjteedy'ajtpy je David. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Chi José yajcojayɨɨy padrónjoty mɨɨd María, je töxyjäy huɨdibɨ anajty ymɨɨd capxytuñ, huɨdi anajty ung tzɨm'ijtp. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chi jadu'n yjajty co ajcxy anajty yjɨ́mɨty Belén, chi oyhuaad'aty co María paadɨpy y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chi yma'xung'ajty je unggoob, e chi nïbe'ñ nïmüxy mɨɨd ymotz, e chi agögɨɨy ma ɨyujc pëcxɨ'ñ, co ca' anajty tɨ paady jättac. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chi mɨhuingon je cajp anajty jäy ycöbixycuend'aty. Hue' anajty ajcxy yhuin'ɨñaayb huintzuumnajxyp je' ycöbixy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chi Huindzɨn Dios tüg y'ángel ñigɨdaacɨ je' ajcxy, e yɨ Huindzɨn Dios y'oy'ájtɨn y'adɨcxcoody jühuɨdity ma je' anajty ajcxy ymɨjc, chi ajcxy ooy chɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Huin'it je ángel ymɨnañ: ―Ca' mdzɨgɨɨygɨxy, cham ɨɨch miich nyajnɨmaaygɨxy oybɨ ayuc huɨdibɨ yajjotcugɨ̈huɨpy tüg'ócɨy naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɨɨd miich ajcxy ycɨxpɨ tɨ ypi'c'aty cham ma je David ycajp tüg jäy huɨdibɨ miich ajcxy xyñihuänaam xycohuänaam ma ajcxy mmɨdzip. Hue' je' je CRISTO, je Huindzɨn Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yɨ' je' ijxpéjtɨp huɨdi mɨɨd m'ijxcabɨpy. Mbáadɨpy ajcxy je ung ma'xung ñïmóchɨty mɨɨd ymotz, ycöcnäy ma ɨyujc pëcxɨ'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chi janch mɨc'amy ñayguëxɨ̈cɨ mɨɨd je ángel may yɨ tzajpjotychɨnaaybɨ, chach Dios ojadájtcɨxy ymɨnáangɨxy: ");
INSERT INTO mcoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Ooy ycömáyɨty ooy ymɨ́jɨty yɨ Dios tzajpjotypɨ, ji naaxhuiñ jotcujc'ajt mɨɨd jäy ajcxy ycɨxpɨ huɨdibɨ Dios yjäygɨdacpy! ");
INSERT INTO mcoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jadu'n yjajty co je ángel ajcxy ñɨcxtay tzajpjoty, chi je cöbixy cuend'ajtpɨ ajcxy ñayñɨmayɨ: ―Tzoc jámɨm jɨm Belén, jaydëbɨ n'íjxɨm ti tɨ ytunyii tɨ yjadyii huɨdibɨ nHuindzɨn'ájtɨm Dios tɨ xyajnɨmáayɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chi ajcxy ñɨcxy jottɨgoy, chi oy pátcɨxy María, José etz je ung ma'xung y'agögɨ̈yɨty ma je ɨyujc pëcxɨ'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Co ajcxy ijxy je María etz je ung ma'xung, huin'it ajcxy nigapxtay nimɨydactay jadu'n nej je ángel ajcxy ñɨmayɨ mɨɨd je pi'c'anäg ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tüg'ócɨy jäy huɨdi mɨdou ooy jɨhuɨy huinmay jadu'n nej je cöbixycuend'ajtpɨ ajcxy ymɨnañ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Chi María mɨdo'mbɨjctay, e yajhuɨ'my ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chi yhuimbijty je cöbixycuend'ajtpɨ ajcxy cömay jäymech ajcxy yɨ Dios, etz ooy alabanza ajcxy ɨɨy mɨɨd Dios ycɨxpɨ mɨɨd tüg'ócɨy jadu'n nej anajty tɨ íjxcɨxy tɨ mɨdóogɨxy, etz jadu'n nej anajty tɨ ñɨmáayɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Coductujc xɨɨ maabɨ anajty yma'xung'aty, huin'it je' ajcxy tɨy'ajttɨy je ung ma'xung. Chi ajcxy yxɨɨmoy JESUS, jadu'n nej je ángel anajty jayɨjp tɨ ymɨna'ñ ca'nɨ anajty chɨmɨ̈gyii ycɨyɨ̈gyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Co je xɨɨ oypaatnɨ mɨna je María anajty yhuätzpɨdzɨmaamnɨ, jadu'n nej Moisés ycötújcɨn je jécyɨp ymɨnañ. Chi ajcxy mɨɨdnɨcxy je ung ma'xung jɨm Jerusalén capxquëxɨ̈gaangɨxy ma yɨ Huindzɨn Dios yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Com jadu'n anajty yjaybétyɨty ma Huindzɨn Dios ñecy: Tüg'ócɨy unggoob yëydɨjcpɨ huɨdi ma'xung'ajtp, abɨcy yhuɨ́'mɨpy mɨɨd je Huindzɨn Dios ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","José etz María oy yéjccɨxy huindzɨgɨ'ñ jadu'n nej Huindzɨn Dios ñecy ymɨna'ñ co jëbɨ yecy metzc jam muuxy o pajctza'm muuxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jɨm Jerusalén anajty chɨnäy tüg jäy huɨdi anajty yxɨɨ Simeón, tudägyjäy je', etz ooy Dios jäymech. Simeón y'ahuijxyp anajty mɨna Dios miñ yajjotcujc'ada'ñ Israeljäy ajcxy, e mɨɨd je' anajty Dios yjɨhuɨ'ñ ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Dios yjɨhuɨ'ñ ymɨc'ajt tɨ anajty yajnejhuɨ̈yii co ca' chojc öga'ñ, jayɨjpnɨ oc'ixɨpy je Huindzɨn Dios yCristo. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Je Dios yjɨhuɨ'ñ ymɨc'ajt yajmin yajmejtzɨ Simeón yhuinma'ñ huen nɨcxy ma Dios ytɨjc; huin'it Jesús ytaj yteedy ymɨɨdnɨcxɨ ma Dios ytɨjc, cuyduñ ajcxy jadu'n nej Dios ñecy y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Chi Simeón tzendzoy etz capxpaady je ung ma'xung, e chi Dios mɨbɨjctzoy mɨɨd je' ycɨxpɨ, chi ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Jadachambɨ capxcɨ́x jotcujc, Huindzɨn Dios, mɨɨd ɨɨch miich mdumbɨ, com tɨ mguyduñ jadu'n nej tɨ xyñɨmäyɨch co n'ixɨpyɨch je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Cham tɨ n'ixyɨch je nihuambɨ cohuambɨ, ");
INSERT INTO mcoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","huɨdibɨ tɨ mni'ixɨ̈y ma tüg'ócɨy jäy ajcxy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jada ung ma'xung ytɨy'ajt yegɨp ma yɨ jäy ajcxy huɨdi ca' yjudiojäyɨty. Jadu'n yɨ' nipaady nej tüg jɨɨn huɨdi codɨɨcxp je jäy. Cömay y'idɨpy yɨ Israel jäy mɨɨd yɨ' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José etz Jesús ytaj ooy jɨhuɨɨy huinmaay jadu'n nej Simeón ñigapxy je pi'c ma'xung. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Chi Simeón conuucx yɨ' ajxcy, e nɨmay María, Jesús ytaj: ―Jadayaabɨ pi'c'anäg hue' jada aminɨ̈y co may Israel jäy yjothuinma'ñ yaj'oyɨ̈huɨpy mɨɨd yɨ Dios etz nañ jadu'n may Israel jäy yjothuinma'ñ ca' yaj'oyɨ̈huɨpy mɨɨd yɨ Dios. Yɨ' je' tüg ijxpejt co ca' jäy y'ixa'nɨɨyb choga'nɨɨyb, e jadu'n tüg'ócɨy yajnejhuɨ̈huɨpy nej ajcxy nidüg nidüg yjothuinma'ñ mɨɨdɨty. E miich m'idɨpy jotmaymɨɨd jadu'n nejɨhuɨ̈y tüg espada tɨ xyajtzaachɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nañ jɨm Jerusalén anajty tüg töxyjäy huɨdibɨ anajty yxɨɨ Ana, Dios je' anajty y'ayucnajtzcapxɨɨybɨ. Fanuel anajty yteedy'ajtpy, hue' je' Aser y'ap y'oc, mɨj jäy anajty ooy. Janch mutz'anägnɨ ypɨjcy e jëyɨ huixtujc jɨmɨjt chɨnay mɨɨd yña'y, mada'px mɨdaax jɨmɨjt anajty cujc co'ögy chɨnäy, e ca' anajty ytɨgoy'ity ma Dios ytɨjc. Ana ytumb anajty tzajtɨgoty xɨɨm tzuum jopy ayuu anajty ycapxtägy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chi Ana nimiñ José etz María jiiby ma Dios ytɨjc, e quipxy mɨɨd ajcxy huingapxtacy je Huindzɨn Dios. Chi je Ana nimɨydacy je pi'c Jesús mɨɨd tüg'ócɨy jäy jɨm Jerusalén huɨdi anajty ajcxy jɨjp'ijxp mɨna Dios cohua'na'ñ Jerusalén ma ymɨdzip. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Co oy yajcuydundäy tüg'ócɨy jadu'n nej je Huindzɨn Dios ñecy ymɨna'ñ, chi José etz María ñɨ́cxcɨxnɨ jɨm Galilea ma ajcxy ycɨ'mgajp Nazaret. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Je pi'c Jesús anajty yeegy mɨc ooy mɨɨd huijy'ajt cujc'ajt, etz ymɨɨd je' Dios ymay'ájtɨn y'oy'ájtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jɨmɨjt jɨmɨjt yɨ ungdaj ungdeedy ñɨcxy anajty ajcxy jɨm Jerusalén co anajty je Pascua xɨɨ paady. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Co Jesús anajty ymajmetzjɨmɨjt'ajty, chi ajcxy ypättɨgɨɨy jɨm Jerusalén jadu'n anajty ajcxy costumbre mɨɨdɨty co xɨɨ paady. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Co je xɨɨ ñaxtäy, chi ajcxy huimbíjtcɨxnɨ, e Jesús yhuɨ'mɨɨy je' jɨm Jerusalén. Ca' José etz ytaj nejhuɨɨy ajcxy co tɨ anajty yhuɨ'mɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hue' ajcxy anajty tijy je' ymiñ axaam mɨɨd ymɨgügtɨjc. Co tüg xɨɨ yöygɨxnɨ, chi ajcxy ixtay je' y'ung ma y'amɨgügtɨjc ajcxy, etz huɨdi mɨɨd ñay'ixy'adyii ñaymɨgüg'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Co ca' ajcxy y'ung paady, chi yhuimbíjtcɨxnɨ jɨm Jerusalén ung ixtaaybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chi jadu'n yjajty codugɨɨg xɨɨ oypaatcɨxy jɨm ma Dios ytɨjc, Jesús y'ɨñäy anajty agujc'amy ma je huindzɨndɨjc. Yɨ' anajty y'amɨdo'ijtyp yɨ huindzɨndɨjc y'ayuc, e nañ yaj'amɨdooy anajty tijaty. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tüg'ócɨy je huindzɨndɨjc huɨdibɨ mɨdou Jesús y'ayuc, chi ooy ajcxy huinmay etz jɨhuɨy jadu'n nej je Jesús huinjɨhuɨydäy etz jadu'n nej anajty tɨydudägy y'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Co Jesús ytaj yteedy y'ijxpatɨ, chi ooy ajcxy tzachjɨhuɨɨy. Chi ungdaj ymɨnañ: ―Aay ung, ¿nej co miich jadu'n xytúngɨxyɨch? Yɨ mdeedy etz ɨɨch yam tzachjottɨgooyb nay'adzɨgɨ̈yiijɨch n'ixtáaygɨxɨch miich. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chi Jesús y'adzooy: ―¿Na'amy co miich xy'ixtáaygɨxyɨch? ¿Ca' mnejhuɨɨygɨxy co copɨty n'ida'ñɨch ma nDéedyɨch ytung? ");
INSERT INTO mcoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Chi ajcxy ca' huinjɨhuɨɨyɨ Jesús y'ayuc huɨdibɨ ycapxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chi Jesús mɨɨd nɨcxy je' ajcxy jɨm Nazaret. Chi Jesús capxymɨdoy ytaj yteedy. Chi yɨ' ytaj yajhuɨ'mday ma yjot yhuinma'ñ tüg'ócɨy nej ytunyii yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Chi Jesús ixpɨjc'adɨɨtzp anajty ooy, etz yeegy yjäygojy huijycujc. E yɨ Dios etz jäy ajcxy ooy anajty jäygɨdaaccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ma anajty je Tiberio César yjɨmɨjtjoty, mɨmajmocx jɨmɨjt anajty maabɨ y'ane'mtɨgɨ̈y, chi je Poncio Pilato anajty gobernador'ajtp jɨm Judea, je Herodes anajty rey'ajtp jɨm Galilea, je' y'uch Felipe anajty rey'ajtp jɨm Iturea etz jɨm Traconite ñaaxjot. Chi Lisanias anajty rey'ajtp jɨm Abilina. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chi je Anás etz Caifás je' ajcxy anajty teedy mɨjtungmɨɨd ma Dios ytɨjc. Je huin'it tiempo Dios y'ayuc yja'ty ma je Juan, Zacarías ymang, huɨdibɨ anajty tzɨnaayb mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chi Juan choñ ñɨcxy ma tüg'ócɨy cajp mɨhuingon je Jordán mɨjnɨɨ, capxhuijy je jäy ajcxy, co huen jothuimbijttaaygɨxy etz huen nɨɨbejtcɨxy jɨgɨx ajcxy ypocy yajhuinmeecxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jada jadu'n tunɨ jajtɨ nej je ayucnajtzcapxɨɨybɨ Isaías anajty tɨ cojaay: Jɨm mɨjtɨgɨ̈duum yajmɨdooy tüg jäy mɨna'ñ: “Yaj'oyɨɨygɨx yɨ Dios ytü'aa, tɨm jadu'n nej jäy ajcxy yaj'oyɨɨygɨxy yɨ jɨbɨc tü'aa co tüg rey mina'ñ.” Yajtɨ́ɨyɨgɨxy yɨ tü'aa huidɨbɨ ooy y'adɨjy y'a'och. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tüg'ócɨy anɨɨ ahuoc huen joyɨɨydäy, tüg'ócɨy tungop huen nañ jadu'n joyɨɨydäy. Tüg'ócɨy nɨɨ'aa tü'aa huɨdibɨ tɨjmin tɨjxɨjp huen tɨɨydäy. Yɨ tü'aa huɨdibɨ ca' quipxyjátyɨty huen quipxyjaty tɨɨydäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tüg'ócɨy yɨ jäy ajcxy ixɨpy ñejhuɨ̈hɨpy nej Dios yega'ñ je nihuambɨ cohuambɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chi Juan ojy ajcxy je jäy pɨnjaty anajty miimb nɨɨbejtpɨ, ymɨnañ: ―¡Miich ajcxy tza'ñ ajcxy y'ajugy y'amɨgüg! ¿Pɨn miich ajcxy tɨ xynɨmäy quëg ma yɨ ayo'n huɨdibɨ Dios yquexaamy? ");
INSERT INTO mcoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Túngɨx oybɨ, jothuimbíjtcɨx, ca' ajcxy mɨnaangɨxy miñ xyipy: “Abraham ɨɨch ajcxy n'ap'ajtpy ndeedy'ajtpy”. Ɨɨch miich ajcxy nɨmaayb co Dios ixtɨ jëbɨ yɨ' yaj'ung'adyii yaj'anäg'adyii Abraham jada tzaa ca'ydɨ miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios ni'ixɨ̈ y'ity jaydëbɨ yajcödɨgoyɨpy jäy ajcxy y'alma huɨdibɨ jɨbɨc-huinma'ñ mɨɨd. Tɨm jadu'n nipaady nej jäy ni'ixɨ̈ y'ity mɨɨd jacha co pujxɨ̈ga'ñ tüg quipy huɨdi ca' oy ytɨɨm'aty, etz yajnögtähua'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chi je mayjäy ajcxy y'amɨdooy je Juan: ―¿Ti ɨɨch ajcxy jëbɨ nduñ? ");
INSERT INTO mcoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chi je Juan y'adzooy, ymɨnañ: ―Pɨnjaty yhuit mɨɨd metz, jaydëbɨ möy pɨn ca' mɨɨdɨty ni tüg. Etz pɨnjaty caagy mɨɨd nañ jadu'n möhuɨpy pɨnjaty ca' mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chi miiñ jadyii yajcogüejtpɨ co anajty ñɨɨbedaangɨxy, ymɨnañ ajcxy: ―¿Ti huaad ɨɨch ajcxy nduñ (jɨgɨx Dios xymɨjotcujc'adɨpyɨch)? ");
INSERT INTO mcoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chi Juan y'adzooy: ―Ca' nɨ̈gɨ anaxy myajcogüety jadu'n nej je cötújcɨn y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chi soldado ajcxy ymɨnañ: ―¿Ti ɨɨch ajcxy ndunɨpy (jɨgɨx Dios xymɨjotcujc'adɨpyɨch)? Chi Juan y'adzooy: ―Ni pɨn ajcxy ti mgapɨ́jcɨpy, ni mganïhuambedɨpy ajcxy. Nañ jadu'n mɨjotcujc'ájtcɨxy nej myajmujuuygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Je mayjäy yjɨjp'ijxyp anajty ajcxy ooy, etz ooy jɨhuɨɨy huinmaay nejhuɨ̈huaangɨxy pen yɨ Juan je' anajty Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chi Juan nɨmay ajcxy nidüg'ócɨy: ―Ɨɨch janch nyajnɨɨbéjtypɨch jäy mɨɨd nɨɨ. Miimb je' axaam huɨdibɨ jacmɨj ca'ydɨ ɨɨch, ca' huaad yɨ' ycɨ̈ghuin ngejɨch. Je' miich ajcxy xyajnɨɨbedɨpy mɨɨdɨ Dios yjɨhuɨ'ñ ymɨc'ajt etz mɨɨdɨ jɨɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Je Cristo ni'ixɨ' y'ity co oybɨ möhua'ñ je jäy huɨdibɨ ajcxy oyhuinma'ñ mɨɨd, etz ymöhuaamy tzaachypɨ je jäy ajcxy huɨdibɨ jɨbɨc-huinma'ñ mɨɨd, tzaachypɨ huɨdibɨ nicamɨna ycɨxɨpy. Tɨm jadu'n nipaady nej tüg jäy ni'ixɨ' y'ity co ymoc-huimboja'n, e chi je oybɨ mocpajc pɨdäga'ñ ma che'x, etz je mocjaam ninögɨ̈hua'ñ, e camɨnaxɨɨ ycapïdza'ñ je jɨɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Je Juan ooy jäy capxhuijy, etz canaagnax oybɨ ayuc capxhuäcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chi yɨ' ojy je rey Herodes, co y'uch Felipe ytöxyɨjc Herodías mɨɨd tzɨnaayɨ, etz jacjaydiiybɨ jɨbɨc-huinma'ñ tɨɨbɨ Herodes anajty tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chi je rey Herodes nïgɨ pocytuñ co Juan pɨdacy pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Chi jadu'n yjajty co jadu'n tüg'ócɨy jäy ñɨɨbejttay nañ jadu'n Jesús ñɨɨbejty. Yam anajty Jesús ycapxtägy co je tzajp y'ahuaach, etz je Dios yjɨhuɨ'ñ ymɨc'ajt ymɨnajcy ma Jesús ycöduu mɨɨd ñinïcx jadu'n nej muuxy ñinïcx. Nañ jadu'n yajmɨdoy tüg ayuc choñ tzajpjoty ymɨnañ: ―Miich n'ung'ajtpy, ooy ɨɨch miich ndzocy ooy njɨhuɨ̈y, ooy njotcújcɨdyɨch mɨɨd miich. ");
INSERT INTO mcoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús hue' anajty yjɨmɨjt oy ni iipxmajc co ytungtɨgɨɨy. Hue' je' anajty jadu'n jäy tijy José ymang, José yteedy hue' je' Elí, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí yteedy hue' je' Matat, Matat yteedy hue' je' Leví, je Leví yteedy hue' je' Melqui, je Melqui yteedy hue' je' Jana, je Jana yteedy hue' je' José, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Je José yteedy hue' je' Matatías, je Matatías yteedy hue' je' Amós, je Amós yteedy hue' je' Nahum, je Nahum yteedy hue' je' Esli, je Esli yteedy hue' je' Nagai, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","je Nagai yteedy hue' je' Maat, je Maat yteedy hue' je' Matatías, je Matatías yteedy hue' je' Semei, je Semei yteedy hue' je' José, je José yteedy hue' je' Judá, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","je Judá yteedy hue' je' Joana, je Joana yteedy hue' je' Resa, je Resa yteedy hue' je' Zorobabel, je Zorobabel yteedy hue' je' Salatiel, je Salatiel yteedy hue' je' Neri, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","je Neri yteedy hue' je' Melqui, je Melqui yteedy hue' je'Adi, je Adi yteedy hue' je' Cosam, je Cosam yteedy hue' je' Elmodam, je Elmodam yteedy hue' je' Er, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","je Er yteedy hue' je' Josué, je Josué yteedy hue' je'Eliezer, je Eliezer yteedy hue' je' Jorim, je Jorim yteedy hue' je' Matat, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","je Matat yteedy hue' je' Leví, je Leví yteedy hue' je' Simeón, je Simeón yteedy hue' je' Judá, je Judá yteedy hue' je' José, je José yteedy hue' je' Jonán, je Jonán yteedy hue' je' Eliaquim, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","je Eliaquim yteedy hue' je' Melea, je Melea yteedy hue' je' Mainán, je Mainán yteedy hue' je' Matata, je Matata yteedy hue' je' Natán, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","je Natán yteedy hue' je' David, je David yteedy hue' je' Isaí, je Isaí yteedy hue' je' Obed, je Obed yteedy hue' je' Booz, je Booz yteedy hue' je' Salmón, je Salmón yteedy hue' je' Naasón, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","je Naasón yteedy hue' je' Aminadab, je Aminadab yteedy hue' je' Aram, je Aram yteedy hue' je' Esrom, je Esrom yteedy hue' je' Fares, je Fares yteedy hue' je' Judá, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","je Judá yteedy hue' je' Jacob, je Jacob yteedy hue' je' Isaac, je Isaac yteedy hue' je' Abraham, je Abraham yteedy hue' je' Taré, je Taré yteedy hue' je' Nacor, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","je Nacor yteedy hue' je' Serug, je Serug yteedy hue' je' Ragau, je Ragau yteedy hue' je' Peleg, je Peleg yteedy hue' je' Heber, je Heber yteedy hue' je' Sala, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","je Sala yteedy hue' je' Cainán, je Cainán yteedy hue' je' Arfaxad, je Arfaxad yteedy hue' je' Sem, je Sem yteedy hue' je' Noé, je Noé yteedy hue' je' Lamec, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","je Lamec yteedy hue' je' Matusalén, je Matusalén yteedy hue' je' Enoc, je Enoc yteedy hue' je' Jared, je Jared yteedy hue' je' Mahalaleel, je Mahalaleel yteedy hue' je' Cainán, ");
INSERT INTO mcoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","je Cainán yteedy hue' je' Enós, je Enós yteedy hue' je' Set, je Set yteedy hue' je' Adán, je Adán yteedy hue' je' Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ymɨɨd'ajtpy anajty je Dios yjɨhuɨ'ñ ymɨc'ajt. Co Jesús jɨm choñ ma Jordán mɨj nɨɨ, chi je Dios yjɨhuɨ'ñ ymɨc'ajt yajnɨcxɨ mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jesús y'ijty huixchɨgui'px xɨɨ jɨm mɨjtɨgɨ̈duum. Chi je mujcu' yjot'ijxɨ huinma'ñ'ijxɨ. Jaygay jɨm y'ijty, e co huixchɨgui'px xɨɨ ñajxnɨ, chi oy yuuböccodyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chi je mujcu' nɨmay: ―Penɨ janch miich Dios xy'ung'adyii, nɨmay jada tzaa huen ahuimbity tzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chi Jesús y'adzooy: ―Jaybety ity ma Dios ñecy co ca'nan mɨɨd tzajcaagy tɨ'ajty jäy ajcxy yjugy'aty, nañ jadu'n tzocy tüg'ócɨy Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chi je mujcu' mɨɨdpejty Jesús ma tüg cop janch cɨxpɨ, chi tüg jaxɨ̈gy yajni'ixɨɨy tüg'ócɨy je naax cajp huɨdi jii naaxhuiñbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Chi je mujcu' ymɨnañ: ―Ɨɨch miich möhuɨpy tüg'ócɨy mɨc'ájtɨn ané'mɨn etz oy'ájtɨn, com ɨɨch ngɨ̈'am y'ity tüg'ócɨy, e nmöhuɨbɨch hueñytɨmpɨ̈nɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pen xyhuingoxtɨnaaybɨch xy'ojadajtpɨch miich, ac miich jada mje' tüg'ócɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chi Jesús y'adzooy, ymɨnañ: ―Huinhuägtuutcɨch miich mujcu', com jadu'n jaybéty y'ity: “Co yɨ Huindzɨn miich mDios mhuingoxtɨnähuɨpy m'ojadadɨpy, etz yɨ' je' tüg pajc myajmɨj'adɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chi je mujcu' mɨɨdnɨcxy Jesús jɨm Jerusalén, chi mɨɨd pejty ma Dios ytɨjc coduu, e nɨmay: ―Pen Dios miich xy'ung'ajtp cödɨjpnax naaxcɨ́xy, ");
INSERT INTO mcoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","com jaybety jadu'n y'ity ma Dios ñecy co quexɨpy Dios yɨ' y'ángeles ajcxy e xycuend'adɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cɨ̈gɨ́xy ajcxy xyhuidzɨpy, ca'ydɨ mdzaachɨ̈y ma tzaajot. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chi Jesús ymɨnañ: ―Ji Dios y'ayuc huɨdi jadu'n mɨnam co ca' mjot'ixɨpy mhuinma'ñ'ixɨpy yɨ mHuindzɨn Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Co je mujcu' yajcɨjxy jadu'n nej anajty jot'ixa'ñ huinma'ñ'ixa'ñ Jesús, chi huinhuägtuuty tüg tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chi Jesús nɨcxy jɨm Galilea, e Jesús mɨɨd'ajtpy je Dios yjɨhuɨ'ñ ymɨc'ajt. Chi Jesús ooy cömay y'ijty ma tüg'ócɨy cajp huinduy agonbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hue' Jesús anajty yaj'ixpɨcy majaty je' ajcxy naymujctac. Chi je jäy ajcxy tüg'ócɨy ooy cömay Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chi Jesús ymiiñ Nazaret ma anajty tɨ yeegy. Chi Jesús ytɨgɨy ma naymujctac, jadu'n nej costumbre anajty mɨɨdɨty pocxxɨɨduum. Chi ytɨnaay'ahuɨy, chi ytɨgɨɨy necycapxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chi ajcxy mooy je necy huɨdibɨ je Dios y'ayucnajtzcapxɨɨybɨ Isaías yjaay. Chi cɨyhuäcxy je necy, paty jiiby tüg it ma anajty yjaybétyɨty jadu'n: ");
INSERT INTO mcoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Je Huindzɨn Dios yjɨhuɨ'ñ ymɨc'ajt xymɨɨd'ajtpɨch, co xyajnïbɨcyɨch co nyajnɨmähuɨbɨch ayoobɨtɨjc je oybɨ ayuc. Tɨ xyquexyɨch co nyajjotcugɨ̈huɨbɨch je jäy ajcxy huɨdi jotmay ymɨɨd, etz nhuinméecxɨbɨch huɨdibɨ ajcxy pujxtɨgótyɨp, nañ jadu'n ajcxy je huɨdibɨ huiintzɨp nyajhuindɨɨcxɨ̈gɨbɨch, e nbɨdägɨbɨch ahuätztuum huɨdibɨ yajtzaachytumb. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tɨ xyquexyɨch co ngapxhuäcxɨbɨch je tiempo mɨna Huindzɨn Dios may'ajt oy'ajt tuna'ñ mɨɨd je jäy ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chi jada' Jesús abɨdijty je ñecy, yajcɨ̈dɨgɨɨy je tungmɨɨdpɨ, huin'it y'ixtacy. Chi tüg'ócɨy mayjäy jiiby ma naymujctac ooy ajcxy huindɨcxy je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chi Jesús ymɨnandacy: ―Cham yajcuydun je' huɨdi jaybety ma Dios ñecy jadu'n nej miich ajcxy cham tɨ mmɨdooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chi nidüg'ócɨy ajcxy ooy jäygɨdacy nej Jesús mɨna'ñ, etz huinmay ajcxy ooy je ayuc huɨdibɨ Jesús ycapxy, chi ñayñɨmáayɨgɨxy: ―¿Nej ca'y José jada jada' y'ung? ");
INSERT INTO mcoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chi Jesús ymɨnaañ: ―Ca' yjécyɨty miich ajcxy xyajnɨmähuɨbɨch jada ayuc: “Tzoydumbɨ naychoyɨ̈huɨɨ cɨ'm. Tüg'ócɨy jadu'n nej ɨɨch ajcxy nmɨdooyɨch tɨ mduñ jɨm Capernaum, nañ jadu'n miich octun ma mgɨ'mgajp.” ");
INSERT INTO mcoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chi Jesús yjacmɨnañ: ―Janch ɨɨch miich ajcxy nnɨmäy co ni tüg jäy huɨdibɨ Dios y'ayucnajtzcapxɨɨyb ca' jäy ajcxy cöbɨcy ma ycɨ'mgajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Janch ɨɨch miich ajcxy nɨmäy co ooy anajty may co'ögy ytöxyjäy ya Israel jecy'ajty co Elías chɨnaay, co je tzajp adujcy tugɨɨg jɨmɨjt jatudujc po', co oy yuu miiñ ma tüg'ócɨy naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","E Dios ca' quejxy je Elías ma yɨ Israeljäy co'ögy töxyjäy ajcxy. Hue' janch quejxy huinduum jɨm Sarepta ma Sidón naaxjot ma tüg co'ögy töxyjäy huɨdi jɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nañ jadu'n anajty ooy mayjäy püdz pa'm mɨɨdɨty ya Israel jecy'ajty co je Dios y'ayucnajtzcapxɨɨybɨ Eliseo chɨnay. Chi ni tüg jäy huin'it catzoocy, jëyɨ tügpajc choocy pa'mjäy huɨdibɨ anajty yxɨɨ Naamán huɨdi tzoon Siria naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Huin'it tüg'ócɨy jäy huɨdi anajty jiiby ma naymujctac ooy yjotma'tcoty co jadayaab ayuc ajcxy mɨdooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chi je mayjäy ajcxy nibɨdɨ̈gy Jesús etz yajpɨdzɨmy ma je cajp. Chi ajcxy yajnɨcxy jɨm ma je tzaahuingueetz, co je cajp copcɨ́xy anajty yajpaady, e jɨm anajty cödɨjpnaxaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Chi Jesús ñajxy cujc'amy ma je' ajcxy, chi ñɨcxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chi Jesús y'idacy jɨm Capernaum, tüg cajp jɨm Galilea naaxjot, chi Jesús jäy ajcxy yaj'ixpɨjcy pocxxɨɨduum. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Huinmay ooy ajcxy jadu'n nej je' yaj'ixpɨcy. Ñayñɨmáayɨgɨxy co je Jesús yaj'ixpɨcy nejɨhuɨ̈y mɨjtung mɨj'ané'mɨn mɨ́ɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jiiby ma je naymujctac jiiby anajty tüg yëydɨjc huɨdibɨ mɨɨd tüg ca'oybɨ, chi je ca'oybɨ mɨc yaaxqueecy ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ixmajtzcɨch ajcxy, ¿ti mdunamy mɨɨd ɨɨch ajcxy Jesús je nazaretpɨ? ¿Nej tɨ mmiñ co xyajhuindɨgoyáanɨgɨxyɨch? Ɨɨch miich n'ijxcapy co miich je' je Huätzpɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chi Jesús je ca'oybɨ ojy, nɨmay: ―Amon, pɨdzɨm ma yɨ jäy. Chi je ca'oybɨ najtztijɨɨy je yëydɨjc agujc'amy ma je jäy ajcxy, huin'it ypɨdzɨmy, e ca' ni nej jactuuñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tüg'ócɨy jäy jɨm ooy ajcxy ñay'adzɨgɨɨyɨ miñ xyɨpy yjanayñɨmáayɨgɨxy: ―¿Ti ayuc jada' yɨ'? Co mɨɨd y'ané'mɨn etz mɨc'ajt ane'my ca'oybɨ etz yajpɨdzɨmy ma jäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chi Jesús capxpaady y'ijty ma tüg'ócɨy cajp huɨdi huinduy agónɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chi Jesús ypɨdɨ̈gy choñ ma naymujctac, ytɨgɨɨy ma Simón ytɨjc. Jadu'n anajty Simón ymɨ̈d töxyjäybɨ mɨc ytoyii. Chi ajcxy cohuanɨɨy Jesús mɨɨd je' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chi Jesús yhuindacy ma je' yhuinduu, ix'ojy je toyɨɨ, e jadu'ñɨ ñajxy. Chi je' mɨc'amy ypɨdɨ̈gy, yajcay yaj'uucy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tzuu tzuu anajty jäy ajcxy yajnɨcxy tüg'ócɨy jäy ajcxy pa'mmɨɨdpɨ ma Jesús. Chi Jesús cɨ̈nɨ̈xajy nidüg nidüg, e jadu'n anajty ajcxy chögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chi nañ jadu'n je' ca'oybɨ yajpɨdzɨmy ma mayjäy, mɨc je ca'oybɨ anajty yhua'ñ yjɨhuɨ̈y, ymɨna'ñ: ―Miich je' Dios xy'ung'ajtp. Chi Jesús nïgɨ ix'ojy, ca' anajty yajhuäcxɨpy nɨcxy yjaccapxy, com tɨ anajty nejhuɨɨygɨxy co yɨ' je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Co yxɨɨmɨɨy, chi chooñ Jesús, ñɨcxy mɨjtɨgɨ̈duum. Ooy jäy yja'ixtäyii, chi ajcxy oy paatcɨxy, yajhuäcxɨjpy ajcxy ooy, ca' anajty oc'ixmadzáangɨxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chi Jesús ymɨnañ: ―Ooy jada chachcopɨ́cyɨty co canaag agajp ɨɨch jada ngapxhuäcxɨbɨch je oybɨ ayuc jadu'n nej Dios y'ane'my. Paady Dios tɨ xyquexyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jadu'n anajty je' capxhuäcxy majaty jäy ñaymujctac jɨm Galilea. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tügtecy jadu'n yjajtɨ, jɨm anajty Jesús ma je Genesaret mejypa', co jäy ñimiinɨ janch ñay'adijɨɨy ñay'agodɨ́ɨyɨgɨxy, tzach'amɨdohuaangɨxy Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chi yɨ' ijxpaty mejtz barco jahueengɨ mejypa'áy. Je acxmajtzpɨdɨjc tɨ anajty ypɨdzɨ́mgɨxy ma je barco, jɨm anajty y'acxxuumy pújccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chi Jesús yajtɨgɨyɨɨy tüg barco huɨdi Simón anajty je'ajtpy. Chi may'ajt pɨjctzoy co huen yajjɨhuägy hueenɨ yɨ barco mejypa'áy. Chi Jesús y'ixtacy barcojoty, e jadu'n yaj'ixpɨjcy je mayjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Co ycapxymaayɨ, chi Jesús Simón nɨmay: ―Nɨcx pɨdäg m'acxmadzɨ'ñ mejyjoty, jaydëbɨ májtzcɨxɨpy acx. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chi Simón y'adzooy: ―Huindzɨn, tɨ ɨɨch ajcxy ooy njatuñ tüg tzuum, ni ti tɨ ngapáatcɨxyɨch. Per mɨɨd miich m'ayuc ycɨxpɨ yɨ acxmadzɨ'ñ nbɨdägɨbɨch mejyjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Co ajcxy pɨdacy je acxmadzɨ'ñ mejyjoty, chi yajco'adujcy ooy may acx, jahueenɨ acxmadzɨ'ñ ycacɨɨch mɨɨd je may acx ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chi Pedro yemɨ ymɨgügtɨjc huɨdi anajty jɨm ma je jadügpɨ barco, huen miñ ajcxy pubedyii. Chi ajcxy ymiñ pubejtp, yaj'ujch ajcxy metzpɨ barco mɨɨd may acx, jagoo jagoo ycaquiiñ je barco mɨɨd may acx ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Co Simón Pedro ijxy jadu'n, chi ycojxtɨnaay'ahuɨɨy ma Jesús yhuinduu, nɨmay: ―Huinhuäctúutcɨch, Huindzɨn, com ɨɨch pocyjäy ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Com Pedro janch tzɨgɨɨyb anajty, etz nañ tzɨgɨɨyb tüg'ócɨy huɨdi anajty mɨɨd tɨ ytuñ, co anajty ooy may acx tzachyajnïbéjtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nañ jadu'n tzɨgɨɨyb anajty je Jacobo etz Juan je Zebedeo ymang ajcxy huɨdibɨ Simón anajty tɨ pubety. Chi Jesús ñɨmay Simón: ―Ca' mdzɨgɨ̈y, jadachambɨ etz jacnɨcxnɨ xɨɨ tiempo mdunɨpy jäymadzɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Co je barco yajmejypɨdzɨmy, chi ajcxy y'ixmajch tüg'ócɨy, chi ajcxy panɨcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Chi jadu'n yjajtɨ co anajty Jesús yjɨ́mɨty ma tüg cajp, co ñimiinɨ tüg yëydɨjc ymɨɨd anajty pützpa'm. Co je pa'mjäy ijxy Jesús, chi nihuindacy ma yhuinduu, mɨnucxtacy, nɨmay: ―Huindzɨn, pen mdzojcpy jëbɨ xyajtzögɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chi Jesús ycɨ' najtzxajɨɨy nïdooñ, nɨmay: ―Ndzojcpyɨch, huɨ'm huädz. Chi mɨc'amy je jäy choocy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chi Jesús ane'my, nɨmay: ―Ca' ni pɨn myajnɨmähuɨpy, nɨcx janchtɨy nayguëxɨ̈gɨɨb ma teedy, jaydëbɨ möhuɨpy Dios huindzɨgɨ'ñ, jadu'n nej Moisés ycötújcɨn je jécyɨp y'ane'my, mɨɨd yɨ' ycɨxpɨ co tɨ mhuätzpɨdzɨmy, jaydëbɨ jäy ajcxy nejhuɨ̈huɨpy co tɨ mdzögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Je capxy'ayuc nïgɨ y'oc-huäcx'adɨɨtznɨ, e janch mayjäy y'ocnimújcɨn, jɨm pɨn ayuc mɨdohuaam, e jɨm huɨdi tzögaam. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús ycögueecpy anajty je mayjäy, ñɨcxy anajty mɨjtɨgɨ̈duum Dios ojadajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tüg tecy yjájtɨ, Jesús anajty yaj'ixpɨjcp, e jɨm anajty ajcxy ɨñäy ma Jesús yhuinduu fariseojäy ajcxy, etz huɨdi jäy yaj'ixpɨjcp Dios ñecy huɨdijaty anajty tɨ choongɨxy canaag agajp ma Galilea naaxjot Judea naaxjot, etz cham huɨdijaty anajty tɨ chooñ Jerusalén. E Jesús ymɨɨd anajty Huindzɨn Dios ymɨc'ajt co jäy yajtzögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chi nijëjɨty jäy yajja'ty cɨjx'am tüg pa'mjäy yëydɨjcpɨ huɨdi ca' anajty ycɨ' ytecy yücxy. Chi ajcxy ixtaay ma yajtɨjctɨgɨ̈huɨpy pɨdäga'ñ anajty ajcxy je pa'mjäy ma Jesús yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Com ca' anajty ni ma tɨgɨyɨydac mɨɨd co je tɨjc anajty ooy y'újtzɨty mɨɨd mayjäy. Chi ajcxy mɨɨdpejty tɨjc nïgɨ́xy, chi ajcxy tɨjc yajcöhuach, e chi ajcxy cödɨyñajxy cɨjx'am je pa'mjäy ma Jesús yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Co Jesús ijxy jadu'n nej je' ajcxy ymɨbɨcy, chi nɨmay: ―Yëydɨjc, yajmeecxp mbocy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chi je' ajcxy huɨdi yaj'ixpɨjcpy Dios ñecy etz je judío ixpɨcytɨjc huɨdi naydíjɨgɨxp fariseojäy huinmaygoty, ñayñɨmáayɨgɨxy: “Jada Jesús ooy ycapxtɨgoy mɨɨd Dios. Ni pɨn yëydɨjc huaad ca' ti pocymeecxy. Tügpajc nHuindzɨn'ájtɨm Dios huɨdi pocyhuinmecxp.” ");
INSERT INTO mcoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús ñejhuɨɨy je' ajcxy yjot yhuinma'ñ, paady ajcxy nɨmay: ―¿Ti mdzachhuinmaayb ajcxy ma mjot mhuinma'ñ? ");
INSERT INTO mcoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ti jactzip co mɨnaanɨm co tɨ mbocy yajmeecxy o mɨnaanɨm: “Pɨdɨ̈g etz nɨcxnɨ”? ");
INSERT INTO mcoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jaydëbɨ miich ajcxy mnejhuɨ̈huɨpy co ɨɨch je' je jäy huɨdi tzoon tzajpjoty, nmɨ́ɨdɨch ané'mɨn etz mɨc'ajt ya naaxhuiñ jëbɨ jäy nbocyhuinmeecxyɨch, paady cham nnɨmäyɨch yɨ pa'mjäy: “Pɨdɨ̈g etz yajpɨdɨ̈g mmaabejt, nɨcx ma mdɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chi mɨc'amy je pa'mjäy ytɨnayɨ̈gy ma je jäy ajcxy yhuinduu, etz yajpɨdɨ̈gy je' ymaabejt ma anajty ycögnäy. Chi ñɨcxnɨ ma ytɨjc, chi ooy cömay jäymejch Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Huin'it nidüg'ócɨy je mayjäy ooy ajcxy jɨhuɨɨy, e chi ajcxy ooy cömay etz jäymejch Dios. Chi ajcxy ooy chɨgɨɨygɨxy, ymɨnaangɨxy: ―Cham janchtɨy n'íjxɨm mɨjhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Co jadu'n ytunɨ yjajtɨ, chi Jesús jɨm choñ, chi ijxy tüg yajcogüejtpɨ huɨdi anajty yxɨɨ Leví. Leví jɨm anajty ɨñäy ma yajgogüejttac. Chi Jesús nɨmay je Leví: ―Pajaamgɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chi je Leví ixmajtztay huɨdi anajty ytuumyb etz padzooñ je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chi Leví mayjäy yajcay yaj'uucy ma ytɨjc, cham may yajcogüejtpɨ ajcxy etz jacjadyii jäy huɨdi ɨñaayb ma yɨ mesa mɨɨd Jesús etz yɨ' ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chi je' ajcxy huɨdibɨ yaj'ixpɨjcp Dios ñecy etz je ixpɨcytɨjc huɨdi naydíjɨgɨxp fariseojäy tzachni'ameechycápxcɨxy ni'ojɨɨygɨxy je Jesús ydiscípulos ajcxy, ymɨnaangɨxy: ―¿Na'amy co mgaaygɨxy m'uuccɨxy mɨɨd yajcogüejtpɨ etz mɨɨd pocyjäy ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chi Jesús ymɨnañ: ―Ca' yajmayjaty tzoydumbɨ huɨdibɨ ca' ajcxy ypɨgyii, jëyɨ huɨdi ajcxy pɨ́jcɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ca' ɨɨch tɨ nmiñɨch ma je jäy ajcxy huɨdibɨ ca' pocy mɨɨdɨty. Ɨɨch tɨ nmiñɨch mɨɨd yɨ pocyjäy ycɨxpɨ co huen jothuimbijttaaygɨxy ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chi je mayjäy ajcxy Jesús nɨmay: ―Nej co yɨ' (Juan) ydiscípulos ajcxy janam jadzojc jaygay y'íjtcɨxy etz ycapxtáccɨxy, nañ jadu'n je fariseojäy ydiscípulos ajcxy janam jadzojc jaygay y'íjtcɨxy. Chi miich mdiscípulos ajcxy ca' ajcxy jaygay y'ijtcɨxy, caaby uucp ajcxy jabom jabom. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chi Jesús ymɨnañ: ―¿Nej jëbɨ yaj'ayuu'aty jäy ajcxy huɨdi yajpatpɨ ma je pɨjcpɨ yajnixɨɨduñ, pen quipxyɨ yam yajpaady mɨɨd je huɨdibɨ pɨjcp? ");
INSERT INTO mcoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Minamb je xɨɨ je tiempo mɨna je pɨjcpɨ yajtzonɨɨyb, huin'it janchtɨy ajcxy jëbɨ y'ayuu'ájtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nañ jadu'n ajcxy yajnɨmay tüg jɨhuimbit ayuc: ―Ni pɨn ca' huaad agɨyɨ̈y tuc-huit mɨɨd jemyhuit, canaan jëyɨ ycɨ́ɨdzɨp yɨ jemybɨ, nañ jadu'n je tucpɨ ca' oy yhuɨ'ma'ñ mɨɨd je jemyhuit agɨyɨ'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni pɨn ca' pɨdägy jemy vino ma je tucpɨ cochac, pen janch jadu'n octuñ, je vino jemybɨ ycɨ́ɨdzɨp je tucpɨ cochac, chi y'ixyojctähuɨpy je vino etz je cochac ñitɨgoydähuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pɨdägɨpy ajcxy jemy vino ma tüg jemybɨ cochac, chi jadu'n ca' ytɨgoyɨpy je vino ni je cochac. ");
INSERT INTO mcoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ca' ni pɨn tzocy vino jemybɨ, pen tɨ anajty ügy vino tɨɨbɨ yjejcnɨ, co jadu'n ymɨna'ñ co jac oy je tɨɨbɨ yjejcnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Chi jadu'n yjajtɨ tüg pocxxɨɨduum co Jesús oy ñaxy ma tüg trigo cam, e yɨ' ydiscípulos ajcxy oy anajty yajmɨnájccɨxy trigo tɨɨm, chi ajcxy nïxajtztüdy, e chi ajcxy jɨɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chi nidügtɨ fariseojäy ymɨnañ: ―¿Ti co ajcxy jadu'n mdundɨgooy co mdúngɨxy huɨdi ca' ñigodúcyɨty ajcxy mdunɨpy pocxɨn xɨɨduum? ");
INSERT INTO mcoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chi Jesús ymɨnañ: ―¿Nej ca'nɨ miich ajcxy mgapxy Dios ñecy nijadu'ñyɨ? ¿Nej ca' mnejhuɨɨygɨxy ti David ytuun co anajty yuubögyii etz nañ co ymɨgügtɨjc anajty yuubögyii? ");
INSERT INTO mcoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David ytɨgɨɨy ma Dios ytɨjc, chi conɨ̈gy je tzajcaagy huɨdibɨ anajty jiiby ma Dios yhuinduu, chi caay, nañ jadu'n moy je ymɨgügtɨjc ajcxy. Je' tzajcaagy ca' anajty ypadyii nɨcxy je' ajcxy cay. Teedy je' anajty ajcxy paatɨp cáaygɨxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chi Jesús yjacmɨnañ: ―Ɨɨch je' je jäy huɨdibɨ tzoon tzajpjoty, jëbɨ nnɨmäyɨch je jäy ajcxy ti jëbɨ huaad ytúngɨxy sábado xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chi jadügtecy yjajtɨ tüg pocxxɨɨduum, co Jesús ytɨgɨɨy ma tüg naymujctac, chi jäy yaj'ixpɨjcy. Jiiby anajty tüg yëydɨjc huɨdi y'a'oygɨ' anajty tɨ̈dzɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chi huɨdi ajcxy yaj'ixpɨjcp Dios ñecy etz fariseojäy ajcxy ix'ijxy pa'íjxcɨxy Jesús nej pen jäy yajtzögam pocxxɨɨduum, e je' ajcxy anajty mɨɨd ycɨxpɨ xɨ̈hua'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús ñejhuɨɨyb je' anajty ajcxy yjot yhuinma'ñ. Chi Jesús nɨmay je yëydɨjc huɨdibɨ anajty ycɨ' tɨ̈dzɨp: ―Pɨdɨ̈g, tɨnayɨ̈g mayjäy'agujc. Chi je' ytɨnaayɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chi Jesús ymɨnañ: ―Nyaj'amɨdohuaamybɨch miich ajcxy tüg ayuc. ¿Nej Dios ñecy ymɨna'ñ, jëbɨ oybɨ nduunɨm pocxxɨɨduum o jëbɨ jɨbɨcpɨ nduunɨm, nyajtzoocɨm jäy o nyajtɨgooyɨm jäy yjugy'ajt? ");
INSERT INTO mcoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chi Jesús ajcxy huindɨcxpejttay nidüg'ócɨy, chi nɨmay je pa'mjäy: ―Xajtɨu mgɨ'. Chi je' ycɨ' xajtɨɨy, huin'it je' ycɨ' choocy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chi je' ajcxy huɨdi yaj'ixpɨjcp Dios ñecy etz je ixpɨcytɨjc huɨdi ajcxy mɨjpɨdacp judío ycostumbre ooy ajcxy yjot'ambɨjcy, ñayñɨmáayɨgɨxy miñ xyɨpy: ―¿Nej ajt n'octuunɨm jada Jesús? ");
INSERT INTO mcoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jadu'n yjajtɨ huin'it xɨɨ Jesús ñɨcxy mɨjtɨgɨ̈duum Dios ojadajtpɨ. Tüg tzuum ooy Dios mɨbɨjctzooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Co yxɨɨmɨɨy, chi Jesús huoomiñ yɨ' ydiscípulos ajcxy. Chi huin'ijxy je majmetzpɨ, etz yxɨɨmoy ajcxy, apóstoles. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Chi Jesús yhuin'ijxy je Simón huɨdi yxɨɨmoy Pedro; je Andrés, Pedro y'uch; Jacobo etz Juan; Felipe etz Bartolomé; Mateo etz Tomás, Jacobo hue' je' Alfeo ymang; etz Simón huɨdi jäy ytijpy Zelote; Judas, Jacobo y'uch; etz Judas Iscariote huɨdibɨ nañ jadu'n Jesús cɨ̈yejc ma ymɨdzip. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chi Jesús mɨɨd'ɨdacy je discípulos ajcxy, chi oy yhuäcxɨpy ma tüg ajoy mɨɨd ydiscípulos ajcxy etz mayjäy huɨdi anajty tɨ choongɨxy Judea naaxjot, etz Jerusalén, etz ma mejypa' jɨm Tiro etz Sidón. Ymiñ ajcxy je mayjäy co amɨdoo'idáanɨ Jesús y'ayuc etz nañ chögaangɨxy je pa'm huɨdi ajcxy ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Cham je huɨdi anajty ayo'n tzachpaatp mɨɨd ca'oybɨ, nañ tzoocp je' anajty ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chi tüg'ócɨy je jäy ajcxy janch ñïdonamy anajty ajcxy je Jesús, co ymɨɨd mɨc'ajt co jäy tüg'ócɨy yajtzög. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chi Jesús huindɨcxpejttay je mayjäy huɨdi ajcxy ixpɨgaam yɨ' y'ayuc, e ymɨnañ: ―Jotcujc miich ajcxy ayoobtɨjc, com miich ajcxy cham xypaat Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jotcujc miich ajcxy huɨdi cham yuubó'cɨp, co mgüxɨɨb miich ajcxy. Jotcujc miich ajcxy huɨdi cham jotmay mɨɨd, co ypáadɨp xɨɨ tiempo mɨna mxondáaccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jotcujc miich ajcxy mɨna anajty jäy ca' xy'ixáangɨxy, co pɨn xy'ixtíjcɨxɨpy, e co jäy ajcxy jɨbɨc xyñigapxa'ñ xyñixïga'ñ mɨɨd ɨɨch ycɨxpɨ, je jäy huɨdi tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mxondäg miich ajcxy huin'it xɨɨ, etz mjotcugɨ́ɨygɨxɨp, com ooy chachmɨ́jjɨty huɨdi ajcxy mbadaamy tzajpjoty. Com jadu'n anajty jecy'ajty miich mmɨj'ap mmɨjteedy ca' ixaangɨxy je huɨdi anajty Dios y'ayucnajtzcapxɨɨyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Miich ayoob ajcxy comeeñyjäy, com ca' ti jotcujc'ájtɨn mjacpadaangɨxy huin'it xɨɨ (co Dios tɨydunɨp je naaxhuiñyjäy). ");
INSERT INTO mcoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Miich ayoob ajcxy huɨdi cham oc'agujc'ajtp ocjotcujc'ajtp, ayo'n jotmay ajcxy mbaadɨp, e myajmayjadɨpy miich ajcxy tijaty. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Miich ayoob ajcxy co ajcxy myajnigapxɨpy myajnimɨydägɨpy, com jadu'n jecy'ajty miich ajcxy mmɨj'ap mmɨjteedy nɨmay je jäy ajcxy co ooy y'oyjäy huɨdi ajcxy anajty najtzcapxɨɨyb ayuc huɨdibɨ ca' ytɨy yjánchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Chi Jesús yjacmɨnañ: ―Miich ajcxy huɨdi cham amɨdo'ijtp ɨɨch n'ayuc, ɨɨch miich ajcxy nɨmaayb: Tzójccɨx mmɨdzip, mɨ'oyjäy'ájtcɨx huɨdijaty ca' xy'ixaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mɨgapx je jäy ajcxy mɨɨd oyjot oyhuinma'ñ huɨdi ajcxy jɨbɨc xyñigapxp xyñi'ojɨɨyb. Mɨbɨjctzoogɨxy yɨ Dios mɨɨd je' ajcxy ycɨxpɨ huɨdibɨ xyñigapxp xyñi'ojɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pen ji pɨn xycojxy ma yɨ mhuinjɨjp, mo' jadüg adu'm'amy ahuin hueñ coxy. Pen ji pɨn xypɨgaanɨ yɨ mjocxhuit, jactɨmmo' mnïjen huen yajnɨcx. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pɨn xypɨjctzohuɨp tijaty, mo'. Pɨn xypɨ́jcɨp huɨdi miich mjë'ajtpy, ca' mbɨjctzohuɨpy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nej mdzocy tunɨpy jäy mɨɨd miich ajcxy, nañ jadu'n miich ajcxy mdunɨpy mɨɨd yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pen miich ajcxy jëyɨ mdzojccɨxpy pɨnjaty xychojccɨxp, ¿ti oyjäy'ájtɨn jada' miich ajcxy m'ocpaadɨpy? Nañ jadu'n je pocyjäy ajcxy chojcpy pɨnjaty yɨ' ajcxy tzójcɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pen mdumyb oybɨ huɨdijaty mmɨɨd ooy mnaymɨgüg'adyii. ¿Ti oyjäy'ajtɨn jada' miich ajcxy m'ocpáadɨp? Nañ jadu'n je pocyjäy ajcxy tuñ oybɨ mɨɨd ymɨgügtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pen myejcpɨjctzou mɨɨd je jäy huɨdibɨ miich ajcxy mjɨjp'ijxpy co nañ jadu'n xymöhuɨpy tigatii, ¿ti oyjäy'ájtɨn miich ajcxy mdumyb? Nañ jadu'n yɨ jɨbɨc jäydɨjc jayejcpɨ tijaty pɨjctzoy co nañ jadu'n jɨjp'íjxcɨxy co ymöhuɨpy tigatii. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Miich ajcxy, tzójccɨx mmɨdzip, mɨ'oyjäy'ájtcɨx mmɨdzip, yajpɨjctzoogɨx tijaty, e ca' ni ti mjɨjp'íjxcɨxɨpy co ajcxy jac mɨj mbaadɨp. Jadu'n miich ajcxy mɨj mbaadɨp oy'ájtɨn e mnaydijɨɨyb ajcxy je mɨjpɨ Dios y'ung. Com Dios pa'ayoodaayb tüg'ócɨy yɨ jäy ajcxy huɨdibɨ ca' ti jäygɨdägy, etz huɨdi jɨbɨcjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Miich ajcxy pa'ayoo mɨgügtɨjc ajcxy, jadu'n nej mDios Teedy tzajpjotypɨ ypa'ayooy huenytɨmpɨ́nɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ca' mmɨgüg ni ti myaj'ix'ixɨpy myajpa'ixɨpy, huin 'it ca' pɨn xy'ix'ixɨpy xypa'ixɨpy. Ca' mmɨgüg mbocy'ixɨpy, e huin'it ca' pɨn xypocy'ixɨpy. Huinmecx mmɨgüg, e huin'it nañ jadu'n Dios myajhuinmeecxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mo' mmɨgüg etz huin'it miich ajcxy Dios xymöhuɨpy quipxy ooy tijtäch etz janch yajxon y'újtzɨty cödɨnaayb. Com yɨ quipxɨ'ñ tɨɨbɨ myajquipxɨ̈y, nañ yɨ' mɨɨd xyquipxhuimbidɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chi Jesús yajnɨmay je mayjäy tüg jɨhuimbit ayuc: ―¿Nej jëbɨ tüg jäy huintzpɨ ymɨgüg huintzpɨ huijtzyöyñɨ? ¿Nej ca' mdijy nimetz yjutcögägɨxɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ca' ji ni tüg ixpɨjcpɨ huɨdi nïgɨ ixpɨ́cyɨp ca'ydɨ yhuindzɨn, pen ji pɨn huädz yjadɨm'ixpɨcy najtzpadɨ̈huɨpy yhuindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Na'amy co mɨc'amy mbocy'ixy mmɨgüg co hueenɨ ytundɨgoy, e miich jac mɨj ooy mdundɨgoy, e ca' mjɨhuɨ'ñybɨcy? Tɨm jadu'n nipaady nej jɨhuɨ̈y tɨ m'ixy pi'cpüx ma mmɨgüg yhuiin, e ma miich mgɨ'mhuiin jac jiiby mɨj quipy, e ca' m'ixy je quipy ma mgɨ'mhuiin. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ca' huaad mnɨmähuɨpy mmɨgüg: “Nayyegɨɨ miñɨch püx n'ocyajpɨdzɨm maabɨ mhuiin”, e miich ca' m'ijxy mɨj quipy ma mgɨ'mhuiin. Jɨbɨcjäy miich. Jayɨjp miich myajhuädzɨp mjot mhuinma'ñ, huin'it jëbɨ mmɨgüg m'ɨɨhuíjɨp mgapxhuíjɨp, jadu'n nipaady nej jɨhuɨ̈y tɨ myajpɨdzɨmy je quipy maabɨ mhuiin, jachuädz m'íjxɨ̈gɨpy e chi jëbɨ yɨ pi'cpüx myajpɨdzɨmɨpy maabɨ mmɨgüg yhuiin. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ca' yɨ' y'oyjäyɨty huɨdi jɨbɨc tuumb, nañ jadu'n ca' jɨbɨcjäy huɨdi oy tuum, tɨm jadu'n nipaady nej tüg quipy. Ca' ji yɨ' oyguípy huɨdi jɨbɨc tɨɨm'ajt, nañ jadu'n ni ca' yjɨbɨcquípyɨty huɨdi oy tɨɨm'ajtp. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Com ni je' quipy yaj'ijxcajp mɨɨd ytɨɨm ycɨxpɨ. Ca' pɨn higuerɨ tɨɨm tucy ma quipy apymɨɨdpɨ. Nañ ni pɨn ca' uvas cha'm piiy ma aadz apymɨɨdpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Je jäy oyjäybɨ ma yjot yhuinma'ñ yajpɨdzɨmy oybɨ. Je jɨbɨcjäybɨ ma yjot yhuinma'ñ yajpɨdzɨmy jɨbɨcpɨ. Huɨdibɨ yhuinmaayb jotjoty huinma'ñyjoty yɨ' ycapxyp. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Chi Jesús yjacmɨnañ: ―¿Nej co nɨgo mɨnaangɨxy: “Huindzɨn, Huindzɨn”, ni ca' ajcxy mdúngɨxy huɨdi nyajnɨmaaygɨxpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tüg'ócɨy jäy huɨdi xyñimimbɨch etz xymɨdoohuɨ ɨɨch n'ayuc etz cuyduñ, ɨɨch nyajni'ixɨ̈huɨpy pɨn je' ymɨdügnax. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Quipxyɨɨyb tüg yëydɨjc huɨdibɨ ytɨjccojp ma tzaa nïcxy, chi nidajɨ̈y ooy cɨɨcy, chi pɨdägy poch'ɨjx tzaa nïgɨ́xy, co mɨjnɨɨ ycomy nimiñ je tɨjc, mɨɨd tüg'ócɨy ymɨjaa jayajpɨdɨ̈ga'ñ je tɨjc, e ni ca' jadu'ñyɨ yajyücxy, com tzaagɨ́xy anajty ypojtztzooñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yɨ jäy huɨdi mɨdoob ɨɨch n'ayuc e ca' cuyduñ, mɨɨdquipxɨɨy jadu'n yɨ' nej tüg yëydɨjc co tɨ ytɨjccojy. Ni ca' poch cɨɨcy ypojtztzooñɨty, jëyɨ naaxhuingɨ́xy nidajɨ̈y hueenɨ. Co je mɨjnɨɨ ymiñ mɨɨd ymɨjaa, chi yajpɨdɨ̈gy je tɨjc, chi oy yhuindɨgoydäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Co Jesús ycapxtaay ymɨydactaay mɨɨd je mayjäy huɨdi anajty jɨm amɨdo'ijtp, chi ytɨgɨɨy jɨm Capernaum. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jɨm anajty tüg Capɨtán tüg ytumbɨ hue' anajty pɨ́jcɨp, janch tɨm ögaanɨp anajty, e je soldado huindzɨn ooy anajty tzocy je ytumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Co je capitán ayuc mɨdooy jadu'n nej Jesús ytuñ, chi quejxy judío mɨjjäydɨjc, huen nɨcxy mɨnuucxtaaccɨxy Jesús co je' yminɨpy ma ytɨjc yajtzögɨɨyb je' ytumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Chi je mɨjjäydɨjc ajcxy ymiiñ ma Jesús, chi ajcxy cohuanɨɨy ooy, pɨjctzou may'ajt, nɨmay: ―Jadayaabɨ capitán ymɨhuaad co mbubedɨpy, com yajmɨj'ajtpy ɨɨch ajcxy ngajp, tɨ cojy ɨɨch ajt naymujctac. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chi Jesús ñɨcxy mɨɨd je' ajcxy. Co ajcxy mɨhuingooñ je tɨjc, chi je capitán quejxy ymɨgüg huen nɨcxy jɨjpcobadɨ̈y Jesús, nɨmähuɨpy: ―Huindzɨn, ca' nej mnayjɨhuɨ̈yii, ca' ɨɨch mɨhuaadɨty co mdɨgɨ̈huɨpy ma ɨɨch ndɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","E paady ca' ɨɨch njot tɨ mɨctuñ co ɨɨch miich cɨ'm nɨ́cx n'ixtäy. Jëda'ajty miich nɨgoo capx, e tɨ anajty ndumbɨch chögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nañ jadu'n ɨɨch nmɨɨdɨch soldados ajcxy huɨdi ajcxy xycapxcöbɨjcpɨch. Nɨmäyɨch tüg: “Nɨcx”, e nɨcxp; nɨmäyɨch jadüg: “Min”, e mimb; nɨmäyɨch ndumbɨ: “Tun jada”, e ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Co Jesús mɨdoy nej je capitán ymɨnañ, chi jɨhuɨɨy ooy, chi ni'ijxhuimbijty nɨmay ajcxy huɨdi pamiinɨp: ―Ɨɨch miich yɨm nɨmaaygɨxyp co ca' nbaadyɨch Israel jäy huɨdibɨ xymɨbɨ́jcpɨch jadu'n nej jadayaab agatz jäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Co ajcxy je quexyöybɨ yhuimbíjtcɨxnɨ ma je tɨjc, chi oy páatcɨxnɨ je tumbɨ tɨ anajty y'agɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chi jadu'n yjajty huin'it xɨɨ co Jesús anajty ñɨcxy ma tüg cajp huɨdi anajty yxɨɨ Naín. Mɨɨd anajty ñɨcxy jadyii ydiscípulos ajcxy etz mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Co yhuingooñ ma anajty ycajp tɨgɨ̈huaanɨ, chi mɨnaybaatɨ jäy ajcxy, ñɨcxy anajty ajcxy tüg öcpɨ yajnaaxtɨgɨɨygɨxy, huɨdi anajty ungdaj tügpajc y'ung'ajtpy. Hue' je' anajty co'ögy je töxyjäy, e mɨɨd anajty ñɨcxy maycajpjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Co je Huindzɨn Jesús ijxy, chi pa'ayogoty je töxyjäy, chi nɨmay: ―Ca' myäxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chi Jesús ymɨjhua'cy, nïdoñ je öcpɨ cajón. Chi ajcxy ytɨnayxɨjpy je huɨdi anajty ajcxy öcpɨ cɨyñɨcxp. Chi Jesús ymɨnañ: ―Yëydɨjc, ɨɨch miich yam nɨmaayb, pɨdɨ̈g. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chi je yëydɨjc ɨñayɨ̈gy huɨdi anajty tɨ y'ögy, e ytɨgɨɨy mɨydaacp. Chi Jesús yajcɨ̈dɨgɨɨyñɨ je' ytaj. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chi ajcxy nidüg'ócɨy ooy ñay'adzɨgɨygotɨ, e Dios jäymejch cömay, ymɨnaangɨxy: ―Tüg mɨjpɨ Dios tɨy'ajtmɨɨtpɨ cham yajpatp ma ɨɨch ajt. Nañ jadu'n ajcxy ymɨnaangɨxy: ―Tɨ Dios ni'ijxcɨdägy yɨ yñaax ycajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ooy Jesús yajcömay ma tüg'ócɨy Judea naaxjot, etz ma tüg'ócɨy jac huinduy agonbɨ naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Chi je jäy ajcxy huɨdi anajty Juan je Bautista yaj'ixpɨjcpy nimɨydactay jadu'n nej mɨɨd ytunɨ yjajtɨ Jesús. Chi Juan huooy metz yɨ' ydiscípulos ajcxy, e quejxy ma Jesús yajpaady. Chi Juan nɨmay co huen nɨcxy amɨdoogɨxy Jesús, pen yɨ' je' je Cristo huɨdi anajty miinaam, o pen n'ahuíjxpy ajcxy huingbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chi je Juan yquejxyöybɨ miiñ ma Jesús nɨmay: ―Yɨ Juan je Bautista ɨɨch ajcxy tɨ xyquéxyɨch ma miich amɨdohua'ñ pen miich je' je Cristo huɨdi minaamb, o ¿n'ahuíjxypɨch ajcxy huingbɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tɨm huin'ítɨy Jesús ooy mayba'mjäy yajtzoocy. Yajtzoocy nañ jadu'n huɨdi anajty ajcxy ooy mɨj yuu mɨj pa'm yaj'ayoyii, etz nañ yajtzoocy pɨnjaty anajty ca'oybɨ mɨɨd ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chi Jesús je Juan yquejxyöybɨ nɨmaayɨ: ―Nɨcx nɨmaaygɨx je Juan jadu'n nej tɨ m'íjxcɨxy tɨ mmɨdoogɨxy, co yɨ huintzpɨ tɨ yhuindɨcxɨ̈gy, yɨ tecyma'tpɨ tɨ yöyɨ̈gy, yɨ nïbützpa'mmɨɨdpɨ tɨ chögy, je cönatpɨ tɨ ymɨdohuɨ̈ccɨxy, je öcpɨ ajcxy tɨ yjugypɨjcy, e ngapxhuäcxyɨch oybɨ ayuc ma ayoobtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jotcujc yɨ' ajcxy huɨdi ca' huinma'ñytɨgooygɨxy mɨɨd ɨɨch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Co je Juan yquexyyöybɨ yhuimbijttay, chi Jesús nimɨydaccoty je Juan ma je mayjäy ajcxy, ymɨnañ: ―Co ajcxy tɨ m'oy mɨjtɨgɨ̈duum, ¿ti tɨ m'íjxcɨxy? ¿Nej tɨ m'íjxcɨxy tüg jäy ametz jotmetz, jadu'n nejhuɨ̈y tüg nähuaax huɨdi pojmiimb pojxɨjp? ");
INSERT INTO mcoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chi jada', ¿ti oy tɨ m'íjxcɨxy? ¿Tüg yëydɨjc huɨdi mɨɨd oy yhuit yxöxyɨty? Yɨ jäy ajcxy oy yxojxypɨ huɨdi agujc jotcujc tzɨnaaygɨxp hue' ajcxy yajpaady ma yɨ rey ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ti ajcxy tɨ m'ixy jɨm mɨjtɨgɨ̈duum? ¿Tüg jäy huɨdi Dios ytɨy'ajt mɨɨd? Janch tɨ m'íjxcɨxy tüg Dios ytɨy'ajtmɨɨdpɨ, etz jacnïgɨ ymɨ́jɨty je' ca'ydɨ Dios y'ayucnajtzcapxɨɨybɨ huɨdi jecy'ajty tzɨnay. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Je' jada je jäy huɨdi Dios ñigapxyp ma ñecy ma Dios jadu'n ymɨnañ: Cham nguejxyɨch ɨɨch nguexyöybɨ jayɨjp ma miich, je' yaj'oyɨ̈huɨp je jäy ajcxy yjot yhuinma'ñ mɨɨd ɨɨch ycɨxp, tɨm jadu'n nipaady nej jɨhuɨ̈y jäy tü'aa yaj'oyɨ̈y co rey ymina'ñ yjäda'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ɨɨch miich ajcxy yam nɨmaayb co huɨdijaty ajcxy töxyjäydɨjc yajpi'c'ajtpy, ca' ji ni tüg Dios y'ayucnajtzcapxɨɨybɨ huɨdibɨ jacnïgɨ ymɨ́ jɨty ca'ydɨ Juan, je Bautista. Chi jada' je jac mutzpɨ huɨdi jiiby tzajpjoty yajpaatp ma Dios y'ane'my, jacmɨj je' ca'ydɨ Juan. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Co ajcxy je mayjäy jadu'n mɨdoy nañ jadu'n je yajcogüejtpɨdɨjc ajcxy huɨdi anajty nɨɨbéjtcɨxy ma Juan, chi ajcxy mɨnañ co Dios ytudägyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","E je fariseos ajcxy etz je escribas ajcxy huɨdi anajty ca' nɨɨbéjtcɨxy ma Juan, ca' ajcxy mɨjpɨdacy huɨdi anajty Dios ytunamy mɨɨd je' ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chi je Huindzɨn Jesús ymɨnañ: ―¿Ti mɨɨd nyajquipxɨ̈huɨbɨch jadayaabɨ jäy huɨdi tzɨnayb ma jadachambɨ tiempo? ¿Huɨdi mɨɨd nyajtügɨ̈huɨbɨch? ");
INSERT INTO mcoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jadu'n nej pi'ctɨjc huɨdi ajcxy ɨyɨɨyb ma jäy yjuygɨxy ytooccɨxy. Mɨjhuan mɨjjɨhuɨɨygɨxy ymɨgügtɨjc: “Tɨ njayajxüxɨch flauta e ni ca' tɨ m'éjtzcɨxy; tɨ nja'ɨɨhuɨ ajcxy ɨɨy jotmaymɨɨdpɨ, e ca' tɨ myaaxcɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chi Juan je Bautista ymiiñ, e je' ca' anajty cay, ni ca' vino ügy, chi miich ajcxy mɨnaangɨxy co Juan ymɨɨd ca'oybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chi ɨɨch, je jäy huɨdi tzoon tzajpjoty, nmiñɨch, chi caaybɨch uucpɨch, e miich ajcxy mɨnaangɨxy: “Ijxcɨx, cha tüg yëydɨjc janch cax janch vino uucp, huɨdi mɨgüg'ajtpy yajcuëjtpɨdɨjc etz pocyjäydɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Je tɨy'ajt ji je' ñiguëxɨ̈gy ma je pɨnjaty nigapxp nimɨydaacp tɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chi tüg fariseojäy may'ajt pɨjctzoy, co Jesús anajty mɨɨd ycaya'ñ. Chi Jesús ytɨgɨɨy ma je fariseojäy ytɨjc, chi ɨñay'ahuɨɨy ma mesa. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chi jɨm anajty tüg töxyjäy huɨdibɨ anajty jɨbɨc tzɨnaayb jɨbɨc jugy'ajtp ma je jɨmbɨ cajp. Co je' nejhuɨɨy jiiby Jesús ma fariseojäy ytɨjc ɨñäy ma mesa, chi mɨmiiñ tüg quiig aceite huɨdibɨ ooy oy xuugy, chi mɨdɨgɨɨy tɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chi ypɨguetz'ahuɨy ma Jesús ytecy ymɨjc, e chi yajxoocɨ Jesús ytecy mɨɨd huinnɨɨ e yajpöt mɨɨd ycöhuay, chi yajjaaxy je aceite huɨdi ooy oy xuugy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Co jadu'n ijxy je fariseojäy, je' huɨdibɨ anajty tɨ huoy Jesús, chi jot'ajtɨ ymɨnañ: ―Co ixyipy jada Jesús y'ocjëjɨty Dios ytɨy'ajtmɨɨdpɨ, y'ijxcajpy ixyipy pɨn jäy nejpy jäy yɨ töxyjäy huɨdibɨ nïdoonɨp co yɨ' yjɨbɨctzɨnäy yjɨbɨcjugy'aty. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chi Jesús ymɨnañ: ―Simón, cham ɨɨch tüg ayuc nmɨ́ɨdɨdyɨch huɨdi nyajnɨmähuamy. Chi je' y'adzooy: ―Yajnɨmaaygɨch, Huindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chi Jesús ymɨnañ: ―Tüg comeeñyjäy ymɨɨd anajty metz jäy huɨdi tɨ ñuucxy. Tüg jäy anuucxy mɨgoox mɨgo'px denario meeñ, e je jadügpɨ anuucxy huixchɨgui'px majc. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Com je' ajcxy ca' anajty mɨɨdɨty ti mɨɨd cuedɨp, chi je comeeñyjäy huinmecxy nimetz. Miich ocnɨmaaygɨch, ¿je metzpɨ jäy huɨdi nuucxy, huɨdibɨ je' nïgɨ chojpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chi Simón y'adzooy: ―Hue' n'a'ɨxɨɨyɨch je tɨɨbɨ huinmecxy jac'anaxy. Chi Jesús ymɨnañ: ―Tɨ mdɨygapxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chi Jesús ni'ijxhuimbijty je töxyjäy, e nɨmay Simón: ―¿Nej m'ijxyp jadayaabɨ töxyjäyɨ? Co ndɨgɨɨyɨch ma mdɨjc, ca' miich nɨɨ xymooyɨch co ndecy nbújɨbɨch. Jadayaabɨ töxyjäy ɨɨch ndecy tɨ xypújɨp mɨɨd yhuinnɨɨ, e tɨ xyméexyɨch ndecy mɨɨd ycöhuay. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ca' ɨɨch miich tɨ xychücxy. Jada töxyjäy jadu'n nej tɨ ytɨjc tɨgɨ̈y, xychücxtɨɨyb ɨɨch ndecy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɨɨch miich ca' aceite mbɨdägy ma ɨɨch ngohuajc. Jada töxyjäy tɨ xyajjaaxɨ ndecyɨch aceite huɨdi ooy oy xuugy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Paady ɨɨch miich nyajnɨmäy co jada töxyjäy huinmeecxɨ yɨ' ymaybocy, co tɨɨbɨ oyhuinma'ñ yajtuñ cɨxyjot huinɨjot. Pɨnjaty hueenɨ ypocy yajhuinmecxɨ, hueenɨ yɨ' chójcɨn yajniquëxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chi Jesús je töxyjäy nɨmay: ―Tɨ miich mbocy yajhuinmecxtäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pɨnjaty anajty ɨñaayb ma je mesa ñayñɨmáayɨgɨxy miñ xyɨpy: ―¿Pɨn jäy jada jada' co nañ yhuinmeecxɨpy jäy ypocy? ");
INSERT INTO mcoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Chi Jesús nɨmay je töxyjäy: ―Tɨ m'alma ñïdzögy co tɨ xymɨbɨcyɨch. Nɨcx jotcujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Co jadu'n yjajtɨ, chi Jesús ñɨcxy ma tüg'ócɨy je mɨj cajp etz mutz cajp, capxhuäcxy je oybɨ ayuc maabɨ Dios y'ané'mɨn. Je nimajmetzpɨ ydiscípulos ajcxy mɨɨd ñɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Etz nañ ymɨɨdnɨcx nijëjɨty töxyjäydɨjc huɨdi anajty Jesús tɨ yajtzögy huɨdi ca'oybɨ anajty ymɨɨd etz jac tijaty pa'm. Hue' je' ajcxy anajty je María je töxyjäy huɨdi anajty xɨ́ɨjɨp Magdalena, je huɨdibɨ Jesús yajpɨdzɨmɨ huɨxtujc ca'oybɨ ma je'; etz Juana, je huɨdibɨ ñäy anajty xɨɨjɨp Chuza, e je Chuza hue' je' je rey Herodes ytungmɨɨdpɨ; etz Susana, etz jacjadyii ajcxy huɨdi anajty ajcxy pubejt Jesús mɨɨd tijaty anajty ajcxy ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Co mayjäy ooy ñayyöymujc ma Jesús yhuinduu huɨdi tzoon ma tüg tüg cajp, chi Jesús nɨmay je mayjäy ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Cha tüg ayuc nyajnɨmähuaangɨxy. Jadu'n jäy tüg choñ niipɨ, ñɨcxy trigo tɨɨm huɨjpɨ. Co je trigo tɨɨm huɨjy, chi nijëjɨty ypajc oy ycäy mɨjtügujc, chi je jäy ajcxy yajhuägpejty, e huɨdi ca' yajhuägpejty, chi joon piihuɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chi nijëjɨty trigo pajc oycäy ma tzaa nïcx. Co ymujxy chi je' ytɨɨch, je' co anajty naax ca' yxoogɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Chi nijëjɨty trigo pajc oycäy ma apyjot, chi ymujxy quipxy mɨɨd apy'ung, chi y'ujtz'o'ctay. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Chi nijëjɨty trigo pajc oycäy ma je naax oybɨ huinnätzcujc, chi ymujxy, chi yeectzooñ, ytɨɨm'ajty oyjaty, tüg trigo pajc mɨgo'px oyco'ity. Co Jesús je mɨydägɨɨ yajmay chi yjactɨmcapxcoty, ymɨnañ: ―Pɨn mɨdohuamb jada ayuc, huen mɨdooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chi je discípulos ajcxy y'amɨdooy: ―¿Nej jada jadu'mbɨ jɨhuimbit ayuc yhuimbɨdzɨmy? ");
INSERT INTO mcoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chi Jesús ymɨnañ: ―Miich ajcxy jaydëbɨ mnejhuɨ̈huɨpy huɨdi Dios ñigapxpy ñimɨydacpy coyüch'amy ma y'ané'mɨn ycötújcɨn. Jacjadyiibɨ jäy jɨhuimbit'amy nyajnɨmayɨch, jaydëbɨ pɨnjaty huɨdi ijxp ca' ajcxy y'ixɨpy, etz pɨnjaty mɨdoob, ca' ajcxy mɨdo'mbɨgɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jadu'n je jɨhuimbit ayuc yhuimbɨdzɨmy: Je trigo pajc Dios je' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Je trigo pajc tɨɨbɨ tügujc ycäy, je' je' jadu'n nej jäy huɨdi mɨdoob Dios y'ayuc, chi mɨc'amy ñiminyii je ca'oybɨ, e piibɨdzɨmdäy je Dios y'ayuc ma yjot yhuinma'ñ, ca'ydɨ mɨbɨc etz ca'ydɨ y'alma yajnïdzögyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Je trigopajc huɨdi cähuɨ ma tzaajot, je' yɨ' ajcxy huɨdi je ayuc mɨdoob, chi cöbɨcy jotcujc, chi je' ca' ytictztɨgɨ̈y, tzojccɨ́xy y'ocmɨbɨcy, co agapxɨɨyb paaty chi ixmajtznɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Je trigo pajc huɨdi tɨ cähuɨ apy'agujc, je' je' ajcxy huɨdibɨ mɨdoob, chi co ñɨcxnɨ jäydɨgooyñɨ Dios y'ayuc mɨɨd jotcujc'ájtɨn tzɨnaayɨn etz jugy'ájtɨn etz comeeñ'ájtɨn, e chi ca' Dios y'ayuc yhuɨ'my ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Je trigo pajc huɨdi cähuɨ ma oyñaax huinnätzcujc, je' ajcxy huɨdi oy etz tudägy yjot yhuinma'ñ mɨɨdɨty. Chi je Dios y'ayuc mɨdohuɨ'my, e oñdägy'amy Dios y'ayuc ymayɨ̈y ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Co jäy ajcxy jɨɨndɨcxɨ'ñ nöctzoy, chi ca' ajcxy cöjupy mɨɨd tu'tz, nañ ca' huaad pɨdägy cɨjx pätcɨ'py, hue' janchtɨy pɨdaaccɨxy ma jɨɨndɨcxpejt, co pɨn ytɨgɨ̈y jëbɨ ixy je jɨɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ca' ni pɨn ayüch tunɨpy e nɨcxy ycayajnejhuɨ̈y, ca' ni pɨn ti tunɨpy ameech e nɨcxy ycaniquëxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Paady miich ajcxy mɨdoogɨx yajxon co pɨn tijaty mɨɨd, jacyajmöhuɨp yɨ'. Pɨn ti camɨɨd, yajpɨgɨpy je' huɨdi anajty yjamɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chi Jesús ytaj etz y'uch ajcxy ñimiinɨ, ca' ajcxy nimejch Jesús yajxon mɨɨd mayjäy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chi Jesús yñɨmaayɨ: ―Cheeby mdaj etz m'uch ajcxy tɨba'y, miich ajcxy xyjamɨgapxam. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chi Jesús ymɨnañ: ―Yɨ jäy ajcxy huɨdibɨ Dios ayuc mɨdoohuɨpy etz cuyduunɨp, yɨ' ɨɨch ndaj'ájtypɨch etz n'uch'ájtypɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chi tüg tecy yjajtɨ Jesús ytɨgɨɨy ma tüg barco mɨɨd ydiscípulos ajcxy, chi Jesús ymɨnañ: ―Tzoc jɨm'amy ñɨɨnaxy nájxɨm. Chi ajcxy chooñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chi nɨɨgujc anajty nɨ́cxcɨxy co Jesús ymɨ'ögy. Chi tüg mɨc poj miñ ma je mejy. Chi je barco ñɨɨ yajtɨgɨyɨɨyɨ, janch yinjaty jahueenjaty ycaquiiñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chi ajcxy Jesús nimɨjhuägy, tijyücxy ajcxy nɨmaaygɨxy: ―¡Huindzɨn! ¡Huindzɨn! Cham ajt n'ocquiinɨm. Co Jesús oy ymäyhuijy, chi jɨjpcogapxɨɨy je poj etz je mejy co anajty chachmɨjjëtzpety ma barco. Chi je poj yhuäcxɨjptay, y'amoonday. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chi Jesús ymɨnañ: ―¿Ma miich ajcxy je mmɨbɨ́jcɨn? Chi ajcxy yjanchchɨgɨygoty janch yhuinmay ajcxy ñayñɨmáayɨgɨxy miñ xyɨpy: ―Pɨn yëydɨjc jada jada' co je poj etz nɨɨ jɨɨguexy, etz yajhuäcxɨpy, etz ycapxycöbɨgyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chi ajcxy ymejch ma je gadarenos naaxjot, huɨdi huɨ'm jɨm'amy ñɨɨnaxy ma je Galilea mɨjlaguunba'. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Co Jesús ñɨɨbɨdzɨmy, chi jɨjpcobadɨy tüg yëydɨjc huɨdi anajty tɨ choñ ma je Gadara cajp. Je' anajty ymɨɨd ca'oybɨ, tɨ anajty yjejcnɨ maabɨ ypadyii. Ca' je' anajty huit yajtuñ, nañ ni ca' anajty chɨnäy ma ytɨjc, öcpɨjut anajty yajtzɨnähuɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Co je' ixpaty Jesús, chi yaaxqueecy, e ycoxtɨnay'ahuɨɨy ma Jesús yhuinduu, ymɨnañ janch mɨc: ―¿Ti ɨɨch miich co xyñimiiñɨch, Jesús, tügpajc mɨjpɨ Dios y'ung? Tun may'ajt ca' nijot xychachchaachytúñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jadu'n mɨnañ com co anajty Jesús ixquexy je ca'oybɨ ma je jäy, tɨ anajty yjejcnɨ ma je ca'oybɨ anajty tzach'ane'my je jäy. Coxoch anajty ymɨgügtɨjc ymɨɨd'adyii mɨɨd cadena. Janch ypojtpy cadena, chi ca'oybɨ anajty yajnɨcxyii mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chi Jesús y'amɨdooy je locɨjäy: ―¿Ti miich mxɨɨ? Chi je ca'oybɨ ymɨnañ: ―Ɨɨch nxɨɨ Legión (hue' yhuimbɨdzɨmy nimay). Jadu'n mɨnañ com nimay anajty ca'oybɨ tɨ ytɨgɨɨygɨxy ma je jäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chi je ca'oybɨ may'ajt pɨjctzoy ma Jesús co ca'ydɨ yquexyii ma ayoodactuuby. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jɨm anajty tüg quepy ɨdzɨm chachjɨɨcxcɨxy ma je ujtzjot. Chi je ca'oybɨ may'ajt pɨjctzoy co huen yajtɨgɨyɨ̈huɨpy je' ɨdzɨm. Chi Jesús ni'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Co je ca'oybɨ ypɨdzɨmy ma je jäy, chi ytɨgɨɨy ma je may'ɨdzɨm. Huin'it je may'ɨdzɨm ñayñajtzjɨbibɨydaayɨ ajcxy ma tüg ahuoc, chi oy ajcxy ycädäy nɨɨjoty, chi y'ögtay. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chi je ɨdzɨm cuend'ajtpɨ ajcxy co ixy jadu'n nej tɨ yjadyii mɨɨd ajcxy y'ɨdzɨm, chi ajcxy yqueecy, oy nimɨydaaccɨxy cajpjoty etz majaty tundac. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chi mayjäy ajcxy chooñ oy íjxcɨxy jadu'n nej anajty tɨ ytunyii tɨ jadyii, oyja'tcɨxy ma Jesús. Chi je mayjäy ajcxy paty je yëydɨjc, tɨɨbɨ anajty ca'oybɨ ñïbɨdzɨmyii ycöbɨdzɨmyii, ɨñäy ma Jesús yhuinduu, huit mɨɨd etz huijy quejy, chi ooy je jäy ajcxy chɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chi pɨnjaty ajcxy ijx mɨɨd mɨydacy jadu'n nej yɨ' choocy, je jäy huɨdi anajty ca'oybɨ mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Huin'it tüg'ócɨy je mayjäy ma gadarenos naaxjot etz jadyii cajp huinduy agonbɨ, chi ajcxy may'ajt pɨjctzoy ma Jesús co huen jɨhuägy ma je' ajcxy, co anajty ooy chɨgɨɨygɨxy. Chi Jesús ytɨgɨɨyñɨ barcojoty yhuimbijtnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Chi je jäy tɨɨbɨ anajty ca'oybɨ ñïbɨdzɨmyii ycöbɨdzɨmyii pɨjctzoy may'ajt co mɨɨd'idan Jesús. Chi Jesús mɨɨd capxycɨ́jxy, nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Nihuimbit mdɨjc, etz nimɨydäg jada mɨjpɨ tung huɨdibɨ Dios tɨ tuñ mɨɨd miich ycɨxpɨ. Chi je' ñɨcxy capxhuäcxy je tɨy'ajt cajp cajp jadu'n nej anajty mɨjhuinma'ñ Jesús tɨ tuñ mɨɨd je' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jadu'n yjajtɨ co Jesús yhuimbijty co chooñ Galilea, chi je jäy ajcxy cöbɨjcy Jesús janch agujc jotcujc, com nidüg'ócɨy anajty ooy jɨjp'íjxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chi tüg yëydɨjc huɨdi anajty yxɨɨ Jairo huɨdibɨ anajty mɨjtungmɨɨd ma judíojäy ñaymujctac ymiiñ ma Jesús, chi mɨnucxtacy Jesús pɨjctzoy may'ajt co huen nɨcxy ma je' ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairo ymɨɨd anajty tügpajc ñɨɨx, hue' anajty yjɨmɨjt majmetz, janch tɨm ögaanɨp anajty. Co Jesús ñɨcxy mɨɨd je', chi janch mayjäy anajty chach'adijɨ̈yii chach'agodɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chi tüg töxyjäy huɨdi anajty yxɨɨ ybo', ca' anajty y'oc-huäcxɨjpnɨ, mɨmajmetz jɨmɨjt anajty cujc jadu'n mɨ'ijtnɨ. Tɨ anajty ymeeñ yajtundäy ma je tzoydumbɨ ajcxy, etz ni pɨn anajty ycayajtzögyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chi je töxyjäy nimɨjhuägy je Jesús, chi nïdonɨ yhuitpä. Janch mɨc mɨc je yxɨɨ ybo' oy yhuäcxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chi Jesús ymɨnañ: ―¿Pɨn xyñïdoñ ɨɨch nhuit? Chi ajcxy y'adzooy co ca' pɨn. Chi Pedro etz tüg'ócɨy mɨɨd je' ymɨnañ: ―Huindzɨn, jäy tɨ xy'adijɨ̈y tɨ xy'abodɨ̈y etz miich mɨna'ñ: “¿Pɨn tɨ xyñïdoñɨch?” ");
INSERT INTO mcoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Chi Jesús ymɨnañ: ―Nidügtɨ tɨ xyñïdoñɨch. Nnejhuɨ́ɨybɨch co mɨɨd nmɨc'ájtɨch tɨ nyajtzögyɨch pɨnjaty. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Co je töxyjäy jɨhuɨɨy co ca' coyüch yhuɨ'ma'ñ, chi nimiiñ janch tzɨyuuyb. Chi yhuindacy ma Jesús yhuinduu, chi capxpɨdzɨmy mayjäy'agujc ti ycɨxpɨ anajty co tɨ nïdoonɨ Jesús yhuitpa', e co anajty mɨc'amy tɨ chögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chi Jesús nɨmay je töxyjäy: ―Töxyjäy, tɨ mdzögy co tɨ xymɨbɨcyɨch, nɨcx jotcujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yam Jesús anajty ycapxpy, co ymiiñ tüg jäy huɨdi anajty tɨ chooñ ma Jairo ytɨjc; je Jairo nihuindzɨn'ajtp anajty je judiojäy naymujctac, chi nɨmaayɨ: ―Tɨ y'ögy miich mnɨɨx, ca' mjac'amayɨ̈y nïgɨ yɨ Huindzɨn Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Co Jesús jadu'n mɨdooy, chi ymɨnañ: ―Ca' mdzɨgɨ̈y, mɨbɨjcɨch janchtɨy, etz tzögɨp yɨ mnɨɨx. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Co Jesús ytɨgɨɨy ma je tɨjc, chi ca' a'ɨxɨɨy nɨcxy ytɨgɨ̈y hueñypɨ́nɨty mɨɨd je'. Jëyɨ Pedro, Jacobo, Juan etz je töxy'anäg ytaj yteedy ytɨgɨɨy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Chi tüg'ócɨy je mayjäy ajcxy janch yaaxp, janch ñé'mgɨxy mɨɨd je töxy'anäg ycɨxpɨ. Chi Jesús ymɨnañ: ―Ca' myaaxcɨxy, ca' yɨ' ögɨty, maab yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chi nɨgoob ajcxy nɨxiicy com tɨ anajty nejhuɨɨygɨxy co tɨ y'ögnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chi Jesús majch je töxy'anäg ma ycɨ', chi mɨgapxy mɨc, ymɨnañ: ―Töxy'anäg pɨdɨ̈g. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chi je' yjugypɨjcy, e mɨc'amy ypɨdɨ̈gy. Chi Jesús ymɨnañ co huen yajcaaygɨxy yaj'uuccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chi ytaj yteedy ajcxy ooy chɨgɨɨy yjɨhuɨɨy. Chi Jesús nɨmay co ca' huaad pɨnjaty mɨɨdmɨydägɨpy jadu'n nej tɨ ytuñyii yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Co Jesús yajyöymujctay je ni majmetzpɨ ydiscípulos ajcxy, chi moy je mɨc'ajt jaydëbɨ yajtzögɨpy pa'mjäy, etz moy ajcxy nañ jadu'n cötújcɨn co ajcxy ixquexɨpy je ca'oybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Chi quejxy je' ajcxy ñɨcxy capxhuäcxcɨxy jadu'n nej Dios y'ane'my, etz yajtzooccɨxy pa'mjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chi Jesús ymɨnañ: ―Ca' ni ti tü'amgɨxpɨ mmɨnɨ́cxcɨxy; ni mgamɨnɨ́cxɨp mdajc, ni mmorral, ni mgaagy, ni meeñ, e ni mgamɨnɨ́cxcɨxɨpy ajcxy metz mhuit. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Huen tɨm huɨdi tɨjc ma anajty mdɨgɨɨygɨxy, jɨm ajcxy huɨ́'mgɨxɨpy, e jɨm ajcxy nayyöyhuäcxɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hueñyma'amyɨty ma ca' jäy xycöbɨ́jccɨxy, co ajcxy mbɨdzɨ́mgɨxɨpy ma je' cajp mhuinnéjpcɨxɨpy mhuinjáaxcɨxɨpy je naaxjoc ma mdecy. Jada je' tɨy'ájtɨp co Dios tzaachytunɨpy yɨ jadu'mbɨ jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chi ajcxy ñayyöyhuäcxtaayɨ, ñɨcxy ajcxy cajp cajp capxhuäcxcɨxy je oybɨ ayuc, etz yajtzooccɨxy pa'mjäy hueñytɨmma'ámyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Je rey Herodes co nejhuɨɨy jadu'n nej Jesús anajty mɨjhuinma'ñ tuñ, chi ooy anajty tzachnejhuɨ̈hua'ñ pɨn je' anajty. Com nijëjɨty jäy anajty ymɨnaangɨxy co tɨ Juan jugypɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Chi jacnaagɨty ymɨnaangɨxy co Elías tɨ ñayguëxɨ̈gyii, e jacnaagɨty ymɨnaangɨxy co tüg Dios y'ayucnajtzcapxɨɨybɨ je' tɨ yjugypɨcy huɨdi jecy'ajty octzɨnaybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Chi Herodes ymɨnañ: ―Ɨɨch yɨ' ni'ane'mdɨy co huen ajcxy Juan ycohuajc yajmɨnajcɨ. ¿Pɨn jada jada' huɨdi ɨɨch nmɨdooybɨch co tzachnimɨydaaccɨxy? Herodes ooy anajty ja'ixa'ñ Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Co je apóstoles ajcxy yhuimbijty, chi yajmɨɨdmɨydactay ajcxy Jesús tüg'ócɨy tɨɨbɨ anajty túngɨxy. Chi ac jëyɨ ydiscípulos mɨɨd'ajty Jesús mɨjtɨgɨ̈duum huingon ma tüg cajp huɨdi yxɨɨ Betsaida. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Co je mayjäy ajcxy nejhuɨɨy, chi ajcxy panɨcxy Jesús. Chi Jesús je mayjäy cöbɨjctay etz yajmɨɨdmɨydacy ajcxy Dios y'ayuc ytɨy'ajt nej ané'mɨn cötújcɨn mɨɨdɨty. Jesús nañ yajtzöcpy anajty huɨdijaty yajtzoyɨ̈huaam. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Co oy chu'ɨɨyñɨ, chi ymɨjhuägy je nimajmetzpɨ ydiscípulos ajcxy ma Jesús, chi ajcxy nɨmay: ―Capxycɨjxnɨ mɨɨd jadayaabɨ mayjäy ajcxy, jaydëbɨ ajcxy ñɨcxɨpy ma yɨ cajp huɨdi huinduy agon yajpaatpɨ, huen nɨcxy ixtaaygɨxy jättac etz jɨm ajcxy paadɨpy caayɨn uucɨn. Com hue' jada it ma ɨɨch ajt yam nyajpaatɨm mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chi Jesús ymɨnañ: ―Mooygɨx miich yɨ' ajcxy ycaayɨn y'uucɨn. Chi je' ajcxy y'adzooy: ―Jëyɨ ɨɨch ajcxy nmɨɨdɨdyɨch mɨgoox tzajcaagy e mejtz acx, nɨgo co ca' ɨɨch ajcxy njuy caayɨn uucɨn mɨɨd jadayaab mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hue' anajty oy nimɨgoox mil je jäy. Chi Jesús nɨmay je discípulos: ―Yaj'ixtaaccɨx ajcxy yɨ mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chi ajcxy jadu'n cuyduuñ, yaj'ixtactay ajcxy je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chi Jesús conɨ̈gy je mɨgooxpɨ tzajcaagy, etz je metzpɨ acx, chi ypa't'ijxy tzajpcɨ́xy conuucxy je tzajcaagy etz acx, huin'it tujc-huäcxy moy je' ydiscípulos ajcxy, huen yajhuäcxcɨxy ma tüg'ócɨy mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chi ajcxy ycay cüxyɨ, huin'it ajcxy yajmujcy je tzajcaagy yconaxy etz je acx yconaxy majmetz cach. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Chi jadu'n yjajtɨ co Jesús anajty ycapxtägy ahuingujc mɨɨd je' ydiscípulos ajcxy, chi Jesús je' ajcxy y'amɨdoy: ―¿Pɨn ɨɨch jäy xytijy? ");
INSERT INTO mcoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chi ajcxy y'adzooy: ―Nijëjɨty jäy xytijy co miich je Juan je Bautista; nijëjɨty ymɨnaangɨxy co miich je' Dios y'ayucnajtzcapxɨɨybɨ huɨdi jecy'ajty tzɨnay e tɨ yjugypɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chi Jesús ymɨnañ: ―¿Miich ajcxy, pɨn ɨɨch miich ajcxy xytíjcɨxy? Chi Pedro y'adzooy: ―Dios yCristo. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chi Jesús pɨdacy ané'mɨn etz cötújcɨn co ca' ajcxy ni pɨn yajnɨmähuɨp co yɨ' je' Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chi Jesús ymɨnañ: ―Ooy ycopɨ́cyɨty co ɨɨch, je jäy huɨdi tzoon tzajpjoty, canaag nax ayo'n nbáadɨbɨch, ca' xymɨjpɨdägɨbɨch je mɨjjäydɨjc, je teedy tungmɨɨdpɨ, etz je' ajcxy huɨdi yaj'ixpɨcy Dios ñecy, e co n'ögɨp njugypɨgɨ́pyɨch codugɨɨg xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chi Jesús nɨmay ajcxy nidüg'ócɨy: ―Pen ji pɨn xypanɨcxa'ñɨch, huen jäydɨgoydäy ycɨ'm tzójcɨn etz huen xypanɨcxyɨch jabom jabom, oy nej ytɨmyjadɨpy ytɨmy'ayoohuɨpy, tɨm nipaady nej jɨhuɨ̈y tɨ cabɨ̈gy mgruudz jabom jabom etz pajamgɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Huen pɨnjäy huɨdibɨ ca' yega'ñ yɨ yjugy'ájtɨn ma yɨ o'cɨn mɨɨd ɨɨch ycɨxpɨ, hue' je' yajtɨgoyamy yɨ' yjugy'ájtɨn. E huen pɨnjäy huɨdibɨ yegamy yjugy'ájtɨn ma yɨ o'cɨn mɨɨd ɨɨch ycɨxpɨ hue' je' ypadamy yɨ jugy'ájtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ti tüg jäy ypatpy, pen tɨ paady tüg'ócɨy cohuit'ájtɨn comeeñ'ájtɨn ya naaxhuiñ e nayyajtɨgoyii, etz ca' y'alma yajnïdzögy? ");
INSERT INTO mcoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yɨ jäy ajcxy pɨnjaty xymɨdzöydúnɨbɨch n'ayuc, ɨɨch je' je jäy huɨdi tzoon tzajpjoty, nañ nmɨdzöydunɨɨybɨch je' ajcxy co anajty nhuimbityɨch ya naaxhuiñ, mɨɨd ɨɨch n'ané'mɨn etz nmɨc'ajtɨch etz nDéedyɨch y'ane'm'ajt, etz ymɨc'ajt, etz mɨɨd je ángeles ajcxy ymɨc'ajt huɨdibɨ huädz yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Janch ɨɨch miich ajcxy nɨmäy co ji jäy ma miich ajcxy huɨdibɨ ixɨpy Dios y'ané'mɨn jayɨjp ca'nɨ anajty y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chi mɨductujc xɨɨbɨ maabɨ anajty jada ayuc jadu'n capxy, Jesús huodzooñ Pedro, Juan etz Jacobo, chi mɨɨd'ajtpy jɨm ma tüg copjɨjp Dios mɨbɨjctzoob. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yam anajty Dios ooy mɨbɨjctzoy, co Jesús yhuiñyjɨjp oytɨgach, e je yhuit yjajty janch poob janch adɨɨcxp. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chi metz jäy ñayguëxɨ̈cɨ, mɨɨdgapxy mɨɨdmɨydägy Jesús, Moisés je' anajty etz Elías. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Huɨdi ajcxy naygëxɨ̈cɨ janch jühuɨdityɨ anajty ajcxy je tɨɨcxɨn jájɨn mɨɨdɨty, nigapxcɨxy nimɨydaaccɨxy je o'cɨn huɨdi Jesús ypadamy jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, Jacobo etz Juan ooy anajty ajcxy chachmähuanɨ, chi ajcxy mɨ'ögtɨgooy. Co oy ymäyhuijcɨxy, ijxy ajcxy Jesús y'adɨɨcxɨn y'ajajɨn, etz nañ jadu'n ijxy ajcxy je nimetzpɨ jäy ajcxy huɨdi anajty Jesús mɨɨdmɨydäcpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jadu'n yjajty co yɨ jäy ajcxy puyöyduutnɨ Jesús. Chi Pedro Jesús nɨmay: ―Huindzɨn, jotcujc ɨɨch ajt ya. Tzoc tugɨɨg tɨjc yaj'oyɨ́ɨyɨm, tüg miich mjëdɨɨby, jadüg Moisés jëdɨɨby, etz jadüg yɨ Elías jëdɨɨby. Pedro ca' anajty nejhuɨɨy ti ycapxpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yam nïgɨ anajty ycapxy co joc ñaaxcɨdacy huɨdi yajnïdɨgoy je' ajcxy. Chi ajcxy ooy chɨgɨɨy co oy joc yajnïdɨgoydáayɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chi tüg ayuc yajmɨdooy ma je joc ymɨnañ: ―Ɨɨch jada n'ung'ajtpy, ooy ndzocyɨch njɨhuɨ̈yɨch. Amɨdo'ijtɨ miich ajcxy yɨ' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Co je ayuc y'amoñ, chi ajcxy ijxy Jesús naydüg yhuɨ'my, chi ajcxy nañ jadu'n amoñ. Huin'it xɨɨ ni ca' ajcxy mɨydacy mɨɨd ni pɨn jadu'n nej anajty tɨ y'ijxcɨxy tɨ ymɨdoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Com jabom co Jesús, Pedro, Jacobo etz Juan ajcxy ymɨnajcy ma je copjɨjp, chi ooy mayjäy chooñ oyjɨjpcobadɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chi nidügtɨ jäy ycapxy janch mɨc, ymɨnañ: ―Huindzɨn tun may'ajt ix ɨɨch n'ung, yɨ' ɨɨch tügpajc n'ung'ajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huen mɨnáajɨty ca'oybɨ ymachyii, chi tɨmetiinɨ yaaxquëgy yajyachyii yajquïdyii, etz yajpɨdzɨmy oy yhuin'opy y'aa'opy e adzaach y'ixmachyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tɨ ɨɨch may'ajt nbɨjctzooyɨch ma yɨ mdiscípulos ajcxy, co huen yajpɨdzɨmy je ca'oybɨ, per ca' yɨ' ajcxy tɨ mɨmadägy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chi Jesús ymɨnañ: ―¡Miich jäy ajcxy huɨdibɨ ca' mɨbɨjcp ca' ajcxy mmɨjpɨdäga'ñ yɨ tɨy'ajt! ¿Naag xɨɨ ɨɨch njac'idɨpy ma miich ajcxy nmɨmecxtújccɨxɨpy? Mɨmin m'ung ya. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Co anajty yhuingoñ, chi je ca'oybɨ yajcɨdaay je yeeg'anäg, chi ooy yajyatzcootɨ. Chi Jesús ix'ojy je ca'oybɨ, e yajtzoocy je yeeg'anäg, chi yteedy yajcɨ̈dɨgɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chi tüg'ócɨy je mayjäy ajcxy ooy chɨgɨɨy mɨɨd je mɨjhuinma'ñ huɨdi Dios ytuun. Jesús ydiscípulos ajcxy ooy jɨhuɨɨygɨxy huinmaaygɨxy co Jesús jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Miich ajcxy yajxon mɨdo'mbɨ́jccɨx jada ayuc. Ɨɨch je' je jäy huɨdi tzoon tzajpjoty, hue' nyajcɨ̈yega'ñɨch ma pocyjäydɨjc ajcxy ycɨ̈'am. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Je' ydiscípulos ajcxy ni ca' anajty huinjɨhuɨɨygɨxy, tzɨgɨɨyb anajty ajcxy, paady ca' ajcxy jaty nej yaj'amɨdóogɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chi Jesús ydiscípulos ajcxy ytɨgɨɨy huinmay'ahuɨdijtp, nejhuɨ̈huaangɨxy pɨn je' jacmɨj'idam. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús nejhuɨɨy je' ajcxy yjot yhuinma'ñ huɨdi nayyajmɨɨdmɨydáacɨp ajcxy, chi tüg pi'c'anäg huijtzɨ̈gy, ypɨdacy ma ymɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chi Jesús ymɨnañ: ―Pɨnjaty xycöbɨjcpɨch jadu'n nej jada pi'c'anäg xycöbɨcyɨch mɨɨd ɨɨch nxɨɨ ycɨxpɨ, ɨɨch yɨ' anajty tɨ xycöbɨcyɨch; je huɨdibɨ ɨɨch xycöbɨ́jcpɨch, cöbɨgɨɨb je huɨdi tɨ xyquexyɨch ya naaxhuiñ. Yɨ' huɨdibɨ jacmútzɨp ma miich ajcxy, yɨ' je' jacmɨjpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chi Juan ymɨnañ: ―Huindzɨn, tɨ ɨɨch ajcxy n'íjxcɨxy co tüg jäy tɨ yajpɨdzɨmy ca'oybɨ mɨɨd miich mxɨɨ miich mmɨc'ajt. Tɨ ɨɨch ajcxy yɨ' nyaj'ojyɨch com ca' yɨ' ɨɨch ajt xypahuɨdijtɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chi Jesús ymɨnañ: ―Ca' myaj'ójcɨxy yɨ'; pɨnjaty ca' xymɨdzip'ajtɨm, ɨɨch ajt yɨ' nmɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jadu'n yjajtɨ co tiempo yhuingonɨ mɨna Jesús ñɨ́cxɨp tzajpjoty, chi yhuinma'ñ pɨdacy co nɨcxa'ñ jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Chi Jesús quejxy cogapxy jayɨjp jättac pɨjctzoobɨ. Chi je cogapxy'ajtpɨ ñɨcxy ytɨgɨy ma je samaritano jäy ajcxy ycajp, jättac pɨjctzoobɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chi je' samaritano jäy ajcxy ca' yega'ñ jättac, com ñejhuɨɨygɨxyp co Jesús etz ymɨgügtɨjc ñɨcxy anajty ajcxy jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Co jadu'n Jesús ymɨgüg ajcxy nejhuɨɨy co je samaritano jäy ca' jättac yega'ñ, chi Jacobo etz Juan nɨmay Jesús: ―Huindzɨn, ¿nej m'a'ɨxɨɨyb ɨɨch ajcxy n'ocni'ane'mdɨ̈yɨch huen jɨɨn cäy huɨdibɨ tzomb tzajpjoty, jɨgɨx yɨ samaritano jäy ajcxy ycɨjxtähuɨpy jadu'n nej je profeta Elías ytuuñ jecy'ajty? ");
INSERT INTO mcoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chi Jesús y'ijxhuimbijty, ojy Jacobo etz Juan, nɨmay: ―Miich ajcxy ca' mnejhuɨɨygɨxy tɨ jot tɨ huinma'ñ miich ajcxy mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɨɨch, je jäy huɨdi tzoon tzajpjoty, ca' tɨ nmíñɨch ya naaxhuiñ co jäy yjugy'ajt miñ nyajtɨgooyɨch, hue' jánchtɨy tɨ nmiñɨch co jäy yjugy'ajt nyajtzóogɨbɨch. Chi ajcxy ñɨcxnɨ huingbɨ cajp jättacp. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jadu'n yjajtɨ co anajty ñɨ́cxcɨxy ma tüg tü'aa, chi tüg jäy Jesús nɨmay: ―Huindzɨn, ɨɨch miich nbanɨcxaamy oy tɨm ma'amy miich mnɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chi Jesús y'adzooy: ―Yɨ huaax ymɨɨd yɨ' ajcxy yjut, etz yɨ joon ajcxy ymɨɨd ajcxy ype'ñ, ɨɨch je jäy huɨdi tzoon tzajpjoty ca' nmɨ́ɨdɨdyɨch ma nmähuɨbɨch ma nbócxɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chi Jesús nɨmay jadüg jäy: ―Pajamgɨch. Chi je jäy y'adzooy: ―Huindzɨn, jayɨjp ɨɨch ndeedy n'ocyajnaaxtɨgɨ̈huɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chi Jesús ymɨnañ: ―Jëbɨ yajnaaxtɨgɨ̈huɨpy huɨdibɨ ca' xypanɨcxa'ñɨch. Nɨcx miich capxhuäcxɨ Dios y'ayuc y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chi jadüg jäy ymɨnañ: ―Huindzɨn, nbanɨcxamy yam. Tun may'ajt ocnajtzmadzɨɨygɨch nɨcxy n'ocmɨɨdcapxycɨ́xyɨch njuugy nmɨgügɨch huɨdi jɨm ma ɨɨch ndɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chi Jesús ymɨnañ: ―Pɨnjaty yhuinma'ñ tɨ pɨdägy co Dios ytung tunaanɨ, ca' huaad ixmach je tung, tɨm jadu'n nipaady nejɨhuɨɨy tüg jäy tɨ ytɨgɨ̈y naaxjɨdzijtzpɨ mɨɨd arado, e ca' huaad y'ijxhuimbity com co huinduum arado nɨcxɨ̈huɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Huin'it co jada jadu'n tɨ ñaxy, chi je Huindzɨn Jesús huin'ijxy jatugɨ'pxmajc y'ixpɨjcpɨdɨjc, chi quejxɨ̈gy cogapxy metz metz ma tüg tüg cajp majaty ñɨcxa'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chi Jesús nɨmay yɨ' ajcxy: ―Janch je cosecha ooy tɨ yhuindɨɨy, yɨ mɨdumbɨ janchtɨɨy hueenɨ. Chojcpy co nbɨjctzóohuɨm ma nHuindzɨn Dios co huen quexy ytumbɨdɨjc ma yɨ cosecha. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɨ́cxcɨx, ɨɨch miich ajcxy nguejxpy jadu'n nej cöbixy y'ung yhuɨdity pa'uc agujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ca' mmɨnɨcxcɨxy mbijty, ni mxäcxuumy, ni mgɨ̈g, e ni pɨn ca' mgapxpócxcɨxɨpy tü'am. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Co ajcxy mdɨgɨ̈huɨpy huenytɨmtitɨ́jcɨty, jayɨjp ajcxy mɨnáangɨxɨpy: “Ji jotcujc'ájtɨn ma jada tɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pen yung naxy je' ajcxy yajpaady, miich ajcxy je mgapxpoocxɨn jotcujc'ajt myegɨpy ma je' ajcxy; pen ca' ajcxy yjadú'nɨty, naadɨgɨ̈'adɨp huɨdi anajty tɨ mgápxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nañ huɨ'mgɨx ma je tɨjc, chi ajcxy mgayɨpy m'ügɨpy huɨdi je jäy anajty ajcxy xymooyb, com je tumbɨ paatɨp je' je ymuju'ñ. Ca' ajcxy mhuɨdidɨpy jayjɨɨn jaydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Huenytɨmyhuɨdi cájpɨty ma anajty mdɨgɨɨygɨxy, pen je jäy ajcxy xycöbɨjcp, caaygɨx uuccɨx huɨdi anajty jäy ajcxy xymooyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yajtzóoccɨx yuujäy pa'mjäy huɨdijaty jɨm ma je' ajcxy yajpaady, etz yajnɨmaaygɨx: “Je Dios y'ané'mɨn huingónɨñ yɨ' ma miich ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Huenytɨmyhuɨdicájpɨty ma anajty mdɨgɨɨygɨxy, e ca' anajty jäy xycöbɨgaangɨxy, co ajcxy mdzonaanɨp, nɨmaaygɨx: “Yɨ mgajp naaxjoc huɨdi tɨ ypety ma ɨɨch ndecy nhuinnebáamyɨch, yɨ' je' ijxpejt co Dios ajcxy xychaachytunɨpy. Chi nejhuɨɨygɨx miich ajcxy jada co je Dios y'ané'mɨn tɨ ymɨhuingonɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ɨɨch miich ajcxy nɨmayb co huin'it xɨɨ co anajty yajhuaad'aty, Dios nïgɨ tzaachytunaangɨxy je jäy huɨdi ajcxy ca' miich ajcxy xycöbɨga'ñ, ca'ydɨ Sodoma cajpjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Chi Jesús yjacmɨnañ: ―¡Miich ayoob ajcxy Corozín jäy! ¡Miich ayoob ajcxy Betsaida jäy! Co jɨm ma je Tiro cajp etz Sidón cajp caytunɨ cayjajtɨ je Dios ymɨjhuinma'ñ huɨdi tɨ ytunyii tɨ yjadyii ma miich ajcxy, jécyɨp ixyipy ajcxy yjothuimbijtnɨ, etz tɨ yajniquëxɨ̈ccɨxy ixyipy mɨɨd je yhuit ɨñaaygɨxy sacɨ nïjen nïcuyjam ixcuyjam (je' je tɨy'ajt co ooy ytajcɨxy ymaygɨxy mɨɨd ypocy ycɨxpɨ). ");
INSERT INTO mcoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Janch jadu'n yjadɨpy co anajty Dios yajnigödugɨ̈y, nïgɨ o'ctɨy miich ajcxy ayo'n mbaadɨɨyb ca'ydɨ jadu'n nej Tiro jäy etz Sidón jäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","E miich ajcxy Capernaum jäy ajcxy, ¿nej mmɨnaangɨxy mjätcɨxɨpy tzajpjotyɨ? Hue' m'ɨdaaccɨxyp miich ajcxy ma yɨ ayoodactuuby. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Je jäy ajcxy huɨdi miich ajcxy m'ayuc xymɨdoohuɨp, nañ xymɨdoohuɨɨb yɨ' ajcxy ɨɨch n'ayuc. Je jäy ajcxy huɨdibɨ miich ajcxy ca' xy'ixa'ñ, nañ ca' je' ajcxy xy'ixa'ñɨch; e pɨnjaty ca' xy'ixa'ñɨch, nañ ni ca' yɨ' ixaangɨxy je Dios je huɨdi tɨ xyquexyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chi je nidugɨ'pxmajcpɨ huɨdi Jesús yquejx ayuccapxhuäcxpɨ yhuimbijttay ajcxy janch jotcujc, ymɨnaangɨxy: ―Ixtɨ je ca'oybɨ tɨ ɨɨch ajcxy xycapxycöbɨ́jccɨxy mɨɨd miich mxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chi Jesús ymɨnañ: ―Tɨ n'ixyɨch nej je ca'oybɨ yhuindzɨn tɨ ycäy, jadu'n nej jɨhuɨ̈y tɨ ycäy tɨ ycödɨgɨɨy tzajpcɨ́xy, jadu'n nej tüg huɨdzuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ɨɨch miich ajcxy mɨc'ájtɨn tɨ nmooygɨxy, jaydëbɨ ca'oybɨ ca' xymɨmadáaccɨxɨpy, tɨm jadu'n nipaady nej jɨhuɨ̈y tza'ñ etz ca'ty myajhuäcpéjtcɨxy e ca' nej mjájtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nïgɨ miich ajcxy jotcujc'ájtcɨx co ajcxy mxɨɨ y'íjtcɨxy cojay jiiby tzajpjoty, ca'ydɨ co ajcxy ca'oybɨ xycapxymɨdoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Huin'it Jesús yjotcugɨɨy mɨɨd je Dios yjɨhuɨ'ñ ymɨc'ajt, ymɨnañ: ―Nyajnajxypɨch Dioscojuyip ma miich, Dios Teedy, tzajpjotypɨ Huindzɨn etz je naaxhuiñybɨ Huindzɨn, co tɨ myüch jada mɨjhuinma'ñ ma yɨ cohuinma'ñ jäydɨjc, etz tɨ myajnejhuɨ̈y je jäy huɨdi ca' y'ixpɨ́cyɨty. Dios Teedy, jadu'n miich tɨ mduñ com jadu'n miich tɨ mjäygɨdacy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ndéedyɨch tɨ xyajcɨ̈dɨgɨydäyɨch tüg'ócɨy tijaty mɨc'ajt oy'ajt. Ni pɨn ca' ijxcajp pɨn je' Dios y'ung'ajtpy, jëyɨ nDéedyɨch tügpajcɨ pɨn xy'ijxcajpɨch. Ni pɨn ca' ijxcapy pɨn je' nDéedy'ájtypɨch, jëyɨ je Dios ung tügpajcɨ huɨdi ijxcajp, etz jacjadyii ma je ung yajniguëxɨ̈ga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chi Jesús ni'ijxhuimbijty yɨ' ydiscípulos ajcxy, ahuingujc ajcxy nɨmay: ―Jotcujc ajcxy je jäy ajcxy huɨdi ijxcɨxp jadu'n nej miich ajcxy tɨ m'íjxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ɨɨch miich ajcxy nɨmayb co ooy may Dios y'ayucnajtzcapxɨɨyb etz rey ajcxy ja'ixa'ñ huɨdibɨ miich ajcxy m'ijxpy, e ni ca' ajcxy ixy; etz jamɨdoo'ida'ñ huɨdi miich ajcxy mɨdooyb, e ni ca' ajcxy mɨdooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chi tüg jäy huɨdi yaj'ixpɨjcp Dios ñecy ytɨnaay'ahuɨɨy jot'ixy huinma'ñ'ixy Jesús, chi y'amɨdooy: ―Huindzɨn, ¿ti huaad ndunɨpɨch co ɨɨch jugy'ajtɨn huinɨxɨɨbɨ nbáadɨbɨch? ");
INSERT INTO mcoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chi Jesús y'adzooy: ―¿Ti jaybétyɨp ma yɨ Dios ñecy? ¿Nej mhuinjɨhuɨ̈y co mnecycapxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chi je ley huindzɨn y'adzooy: ―Mdzogɨpy mjɨhuɨ̈huɨpy mHuindzɨn Dios mɨɨd tüg'ócɨy m'aa mjot, mɨɨd tüg'ócɨy m'alma, mɨɨd tüg'ócɨy mmɨjaa, etz mɨɨd tüg'ócɨy mjot mhuinma'ñ, e mdzogɨpy yɨ mɨjɨɨn mɨdɨjc jadu'n nej miich cɨ'm naychogyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chi Jesús y'adzooy: ―Tɨ ooy yajxon m'adzooy. Tun yɨ', e mdzɨnähuɨp huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","E je' nañ jadu'n tɨm tɨy ñejhuɨ̈hua'ñ, nɨmay Jesús: ―¿Pɨn ɨɨch nmɨdɨjc'ajtpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chi Jesús y'adzooy: ―Tüg jäy choñ jɨm Jerusalén ycɨdägy anajty jɨm Jericó, chi oy meetzpɨ mɨnaybadyii. Chi ajcxy tüg'ócɨy yhuit e tijaty yɨ' anajty ymɨɨd pɨjctaayɨ. Chi ajcxy ooy huinhuojpy jɨjphuojpy huingojxy jɨjpcojxy, chi ajcxy ixmach jahueengɨ ögy, chi ajcxy ñɨcxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tüg judío teedy ymɨnagɨɨy ma je jɨmbɨ tü'aa. Co y'ijxy je tzaachɨ̈jäy, chi jüyöyñajxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nañ jadu'n ymɨnagɨɨy ma je jɨmbɨ tü'aa tüg levita jäy huɨdi tuumb ma Dios ytɨjc, co jɨm yjäty mɨhuingon je tzaachɨ̈jäy, co oy ixy, nañ chi jüyöyñajxy (ca' pa'ayooy). ");
INSERT INTO mcoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chi tüg samaritano jäy anajty jɨm naxɨ̈y, co mɨhuingoñ je tzaachɨ̈jäy, co oy ixy, huin'it ooy pa'ayogooty je tzaachɨ̈jäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chi je' nimɨjhuägy, chi pujɨ e xojtzɨ je chaachɨ̈'au, nañ tzoyɨɨyɨ chaachɨ̈'au mɨɨd aceite etz vino. Chi yaj'ɨyujcpety, e yajnɨcxy jɨm ma yjättac, e jɨm cuend'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Com jabom co anajty ñɨcxaanɨ, chi yajpɨdzɨmy mejtz denario meeñ, moy je codɨjc nɨmay: “Cuend'at jadayaabɨ tzaachɨ̈jäy, jadu'n nej anajty mjacmeeñyajtuñ, co ɨɨch anajty nhuimbityɨch huin'it nmɨgüedɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Ma je nidugɨɨgpɨ jäy pɨn je oybɨ tɨ tuñ mɨɨd je jäy huɨdi anajty je meetzpɨ tɨ ymeechyii tɨ yajtzaachɨ̈yii? ");
INSERT INTO mcoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chi je jäy huɨdi Dios ñecy yaj'ijxpɨjcp Jesús y'adzooy: ―Je huɨdi tɨ yajtuñ je pa'ayo'ñ. Chi Jesús ymɨnañ: ―Nɨcx miich, e tun nañ jadu'n pa'ayo'n. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chi jadu'n yjajty co Jesús anajty ytüyöy, chi ytɨgɨɨy ma tüg mutz cajp. Jɨm anajty tüg töxyjäy huɨdi anajty yxɨɨ Marta, yɨ' yajjättacɨ ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Je Marta ymɨɨd anajty tüg y'uch töxyjäybɨ huɨdi anajty yxɨɨ María, chi je' y'ixtacy ma Jesús ymɨjc, amɨdoo'ijtɨ je' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Chi je Marta ooy anajty jɨm chachjottɨgoy tuñ anajty tigatii ma ytɨjc, chi nimɨjhua'cy je Jesús nɨmay: ―Huindzɨn, ¿ca' nej mnayjɨhuɨ̈yiijɨ co ɨɨch naydüg yam tzach nayyajtuñyiijɨchɨ? Nɨma' yɨ María co huen xypubétyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chi Jesús ymɨnañ: ―Marta, Marta, yɨ maytung miich mdzachmɨjottɨgooyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tügpajc ji, huɨdibɨ ooy ycopɨ́cyɨp. Yɨ María tɨ yɨ' huin'ixy je oybɨ huɨdi ni pɨn ca' ypɨgɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jadu'n yjajtɨ co Jesús anajty Dios mɨbɨjctzoy ma tüg it lugar, co yajmay, chi tüg discípulo ñɨmaayɨ: ―Huindzɨn, yajni'ixɨɨygɨch ajcxy tzajcapxycapxɨɨ, jadu'n nej Juan yajni'ixɨɨy yɨ' ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chi Jesús ymɨnañ: ―Co ajcxy Dios mmɨbɨjctzohuɨpy, jadu'n mɨnáangɨxɨpy: Dios Teedy, miich huɨdi tzajpjoty tzɨnaayb, huindzɨgɨ̈y miich mxɨɨ y'ity. Huen miñ ya miich yɨ m'ané'mɨn. Huen mdzójcɨn yajcuyduñ ma je jäy yjot yhuinma'ñ jadu'n nej yajcuyduñ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mooygɨch ajcxy ngaayɨn n'uucɨn jabom jabom. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Méecxɨbɨch ajcxy nbocy ngaydey huɨdibɨ ɨɨch ajcxy ndundɨgooyb, jadu'n nej ɨɨch ajcxy nmeecxyɨch huɨdibɨ ajcxy xymɨdundɨgooybɨch. Ca' m'a'ɨxɨ̈y co ɨɨch ajcxy huinma'ñ tɨgoyɨpɨch. Yajnïhuaatzcɨch ajcxy ma yɨ jɨbɨcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Chi Jesús yjacmɨnañ: ―Pɨnjaty ji ma miich ajcxy huɨdi tüg ymɨgüg mɨɨd, co ninɨ́cxɨpy mɨjcoodz e mnɨmähuɨpy: “Mɨgüg, tun may'ajt yajpɨjctzoogɨch tugɨɨg mdzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tüg ɨɨch nmɨgüg tɨ xyñimiñɨch huɨdi tüyöyp, etz ca' nmɨ́ɨdɨdyɨch ti nmöhuɨbɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chi je jäy y'adzooy jiiby tɨgoty, ymɨnañ: “Ca' xy'amayɨ̈yɨch. Tɨ ɨɨch ndɨjc n'agɨɨyñɨ, etz n'ungɨch yam nmɨɨdɨch cɨjx'am; ca' njatyɨch nej nbɨdɨ̈gɨbɨch etz nmöhuɨpy huɨdi mbɨjctzooyb.” ");
INSERT INTO mcoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ɨɨch miich nɨmaayb, oy ca' tzojc nipɨdɨ̈ga'ñ ymöhuamy huɨdi pɨjctzou co mɨgüg'adyii, hue' ymöhuamy jaydëbɨ ca'ydɨ yjac'amayɨ̈yii, chi yegɨpy tüg'ócɨy huɨdi yajmayjajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ɨɨch miich ajcxy nɨmaayb: Pɨjctzóogɨx, e myajmöhuɨpy ajcxy. Ixtaaygɨx, e mbaadɨpy ajcxy; cogapxɨɨygɨx, ahuädzɨp ajcxy mdɨjc'aguu. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tüg'ócɨy je' pɨn pɨjctzoob tijaty ma Dios, cɨ̈dɨgɨ̈huɨɨb; pɨn y'ixtaayb, ypaadɨpy; pɨn cogapxɨɨyb, yaj'ahuatzɨɨb ytɨjc'aguu. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Pɨn ungdeedy ji ma miich ajcxy pen y'ung ypɨjctzoob tzajcaagy, nej mmöhuɨpy tüg tzaajɨ? ¿E pɨn ypɨjctzooyb acx, nej jëbɨ mmöhuɨpy tüg tza'ñɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Pen ypɨjctzoyb tzeydüty, nej jëbɨ mmöhuɨpy ca'ty? ");
INSERT INTO mcoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pen miich jɨbɨcjäy ajcxy mnejhuɨɨyb nej oybɨ m'ung móoygɨxɨpy, ¿nej ca' mdijy yjánchɨty co mDios Teedy tzajpjotypɨ xymóoygɨxɨpy je Espíritu Santo, pen miich ajcxy mmɨbɨjctzohuɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Chi Jesús anajty yajpɨdzɨmy tüg ca'oybɨ ma tüg jäy huɨdi anajty uumɨp. Jadu'n yjajty co je ca'oybɨ ypɨdzɨmy, chi je uum ycapxɨ̈gy. Chi je mayjäy ooy jɨhuɨy huinmay. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nijëjɨty jäy ymɨnaangɨxy: ―Jesús mɨjhuinma'ñ ytumyb mɨɨd je Beelzebú ymɨc'ajt, je ca'oybɨ yhuindzɨn, paady ca'oybɨ yajpɨdzɨmdäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jacjaydiibɨ jäy ajcxy co jot'ixaangɨxy huinma'ñ'ixaangɨxy Jesús, pɨjctzooy ajcxy Dios tüg ymɨjhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Co Jesús nejhuɨɨy nej je' ajcxy jot'adyii huinma'ñ'adyii, chi nɨmay: ―Co tüg gobierno ñaybɨjc-huäcxyii, chi ñaychiptúnɨgɨxy miñ xyɨpy; ñayyajcɨ́jxɨgɨxy ñayyajtɨgóoyɨgɨxy; co tüg quëx jäy ñaybɨjc-huäcxyii, nañ jadu'n je' ñayyajcɨ́jxɨgɨxy ñayyajtɨgóoyɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pen je mujcu' ajcxy ñaybɨjc-huäcxɨp, ¿nej jada je mujcu' y'ané'mɨn yjac'idɨpy? Miich ajcxy mɨnamb co ɨɨch mɨɨd ndúñɨch je Beelzebú ymɨc'ajt co ɨɨch ca'oybɨ nyajpɨdzɨmy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pen jadu'n yɨ', ¿pɨn je mɨc'ajt mooyb huɨdi miich ajcxy xypahuɨdijtp co yajpɨdzɨmy je ca'oybɨ? Paady yɨ' ajcxy cɨ'm yajniquëxɨ̈cp co miich ajcxy mdundɨgooygɨxy mgapxtɨgooygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pen ɨɨch mɨɨd Dios y'ané'mɨn nyajpɨdzɨmyɨch ca'oybɨ, janch jada co Dios y'ané'mɨn tɨ yjäty ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Co tüg mɨcjäybɨ mɨɨdɨty maydujt, e ñaycuend'adyii yajxon, ca' je' ytɨgoyɨpy tijaty ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Co yjäty jadüg jäy jacmɨcpɨ ca'ydɨ je', chi ymɨmadägyii, e ypɨjctäyii tüg'ócɨy ytujt huɨdi anajty ooy jot'amɨj'adyii, e yajhuäcxɨpy tijaty anajty ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pɨnjaty ca' xymɨjnɨcxpétyɨch, nmɨdzipɨch yɨ'. Pɨnjaty ca' ytuñ mɨɨd ɨɨch co jäy nyaj'ixpɨcyɨch Dios ytɨy'ajt, hue' je' ajcxy jäy yajhuinma'ñydɨgooyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Co je ca'oybɨ ypɨdzɨmy ma je jäy, chi je' ñɨcxy jɨm tɨ̈tznaax ijxtägy co ypocxa'ñ. Co ca' paty ypocxtac, huin'it ymɨna'ñ: “Huimbidaambɨch ma je jäy yjot yhuinma'ñ ma ɨɨch tɨ n'octzombɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Co je ca'oybɨ yja'ty ma anajty tɨ chɨnäy, chi paady je jäy yhuinma'ñ janch yhuädzɨty janch ooy jadu'n nej tüg tɨjc huɨdi janch huädz pedɨ̈gɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chi je ca'oybɨ ñɨcxy, e mɨɨd miñ jahuixtujc ca'oybɨ jacjɨbɨcpɨ ca'ydɨ je'; chi ajcxy ytɨgɨɨy ma je jäy yjot yhuinma'ñ, e chɨnay ajcxy jiiby; huin'it je jäy jac'o'ctɨy oy yjajtnɨ ca'ydɨ jadu'n nej anajty jayɨjp'aty. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Co Jesús jadu'n anajty ymɨna'ñ, chi tüg töxyjäy mayjäy agujc mɨc ymɨnañ: ―Jotcujc je töxyjäy huɨdi tɨ xyajpi'c'aty etz huɨdi xyajyeegy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chi Jesús ymɨnañ: ―Je' jacjotcujc pɨnjaty Dios y'ayuc mɨdoohuɨp etz cuyduunɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Co je mayjäy ajcxy jübigɨɨy, chi Jesús ymɨnandacy: ―Jadachambɨ jäy ooy ajcxy yjɨbɨcjäyɨty, ypɨjctzooyb ajcxy mɨjhuinma'ñ ijxpejt. Ni camɨna Dios ajcxy ycamöhuɨɨyb ijxpejt, jëyɨ tügpajc Jonás y'ijxpejt yajmöhuɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Com jadu'n nej je Jonás jecy'ajty ijxpejt yejcy ma je Nínive jäy, nañ jadu'n ɨɨch, je jäy huɨdi tzoon tzajpjoty, nyegaamyɨch ijxpejt jadachambɨ tiempo mɨɨd jäy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Je töxyjäy reina huɨdi tzɨnay jecy'ajty ma madzäcruudz ypɨdzɨmy, yɨ' je' xɨ̈dähuam jadachambɨ tiempo jäy co anajty Dios tɨyduna'ñ mayjäy, etz yajpocycähuɨpy ajcxy. Ixtɨ ma naaxhuiñybɨ ycogɨxɨ̈y jɨm je reina chooñ co anajty amɨdo'idanɨ je rey Salomón ycapxy y'ayuc. Ji naaxhuiñ jadachambɨ tüg Dios ytɨy'ajtmɨɨdpɨ jacnïgɨ ymɨ́jɨty ca'ydɨ Salomón anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Co anajty Dios tɨyduna'ñ yɨ may naaxhuiñyjäy, chi je jäy ajcxy huɨdibɨ anajty cogajpɨp jɨm Nínive pɨdɨ̈gaangɨxy etz yajpocycähuaangɨxy jadachambɨ naaxhuiñyjäy. Com je Nínive jäy jothuimbijt je' ajcxy co Jonás Dios y'ayucnajtzcapxɨɨyɨ. Ji jadachambɨ tüg Dios y'ayucnajtzcapxɨɨybɨ jacnïgɨ ymɨ́jɨty ca'ydɨ jadu'n nej anajty je Jonás. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ni pɨn ca' yüch je jɨɨn huɨdi tɨ nögpɨty, ni ca' pɨdägy jiiby cajón pa'tcɨ'py, jëyɨ janchtɨy pɨdägy je jɨɨn ma jɨɨndɨcxpejt, jaydëbɨ co pɨnjaty ytɨgɨ̈huɨpy tɨgoty, codɨcxɨɨb je jɨɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Je jɨɨn ma miich ajcxy mninïcx je' yɨ' miich ajcxy mhuiin. Pen oy miich ajcxy mhuiin, nañ jadu'n tüg'ócɨy miich ajcxy mninïcx ymɨɨd yɨ' tɨɨcxɨn. Pen ca' y'óyɨty mhuiin, nañ jadu'n ajcxy yɨ mninïcx yajpaty agootztuum. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cuend'ájtcɨx yɨ tɨy'ajt huɨdi miich ajcxy mɨɨd, ca' mgoyützcɨxy, com co jadu'n nɨcxy y'ahuimbity nej cootzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pen miich mdɨy'ajt codɨɨcxy y'ity mɨɨd Dios ytɨy'ajt, tüg'ócɨy quëxɨ̈gtähua'ñ janch huädz. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Co Jesús ycapxtay, chi tüg fariseojäy may'ajt pɨjctzoy huen nɨcxy mɨɨd cayii. Co Jesús ytɨjctɨgɨɨy, chi y'ixtacy ma je caybejt. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Co je fariseojäy ijxy jadu'n nej Jesús ytuñ, chi ooy huinmay nej co Jesús ca' ñayyajpocyhuächyii mɨɨd nɨɨ jayɨjpnɨ ma anajty ca'nɨ ycaayñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chi je Huindzɨn Jesús ymɨnañ: ―Miich ajcxy fariseojäy, ooy mnaybɨdaaccɨxy tudägyjäy ma jäy ajcxy yhuinduu e ca' yjánchɨty; chi jada' ma mjot mhuinma'ñ miich ajcxy ooy m'adzocy, etz mɨɨd ajcxy jɨbɨc-huinma'ñ; tɨm jadu'n nipaady nej myajhuäch ajcxy yɨ tasɨ ninïcx, yɨ texyñinïcx e chi ajcxy yajhuɨ́'mgɨxy jɨbɨcpɨ je tasɨjoty je texyjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Miich ajcxy ca' Dios y'ayuc huinjɨhuɨɨybɨ! ¿Ca' mnejhuɨɨygɨxy co yɨ pɨn tɨ texyñinïcx yajcojy nañ tɨ yajcojy texyjot? ");
INSERT INTO mcoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tun miich ajcxy oyjäy'ájtɨn, huin'it janchtɨy anajty ajcxy mhuädzɨty ma mjot mhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ay miich ayoobɨ ajcxy fariseojäy! Com mbɨdaaccɨxy abɨcy tüg pɨcy je majcpɨ mɨɨd yɨ Dios ycɨxpɨ ixtɨ yɨ tzajnɨmang, yɨ ruda, etz tüg'ócɨy aay ujtz. Chi jada' ca' mduñ je oyjäy'ájtɨn etz tɨy'ájtɨn jadu'n nej Dios tzocy. Hue' je' oy mduñ co tijaty abɨcy mbɨdägy mɨɨd Dios ycɨxpɨ, nañ jadu'n copɨcy oyjäy'ájtɨn mdunɨpy etz Dios ytɨy'ajt mguydunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ay miich ayoobɨ fariseojäy ajcxy! Co ooy m'adzójccɨxy je ɨñaybejt huɨdi cöduum ma naymujctac, etz ooy m'adzójccɨxy co huen jäy ajcxy xycapxpoocxcɨxy oy huindzɨgɨ̈y mayjäy agujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ay miich ayoobɨ ajcxy huɨdi yaj'ijxpɨjcp Dios yley etz miich fariseojäy ajcxy! Oy mjanaybɨdáacɨgɨxy oyjäy e ca' yjánchɨty, ca' mguydungɨxy Dios ytɨy'ajt, jadu'n nipaady miich ajcxy nej öcpɨ jut huɨdi ca' yquëxɨ̈gy, chi jäy yöy nïgɨx, com co ca' ñiguëxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chi tüg jäy huɨdibɨ yaj'ixpɨjcp Dios y'ayuc ymɨnañ: ―Huindzɨn, co jadu'n miich mɨna'ñ, nañ jadu'n ɨɨch ajcxy ooy jɨbɨc nayjɨhuɨ́ɨyɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chi Jesús ymɨnañ: ―¡Ay ayoob miich ajcxy Dios y'ayuc huindzɨn! Miich ajcxy mgójcɨxyp canaag costumbre huɨdi je jäy ajcxy ca' mɨmadäga'ñ, e ca' ajcxy mba'ayoogɨxy, tɨm jadu'n nipaady nej jɨhuɨ̈y tüg tzɨmy tɨ mmooygɨxy jemxypɨ huɨdi ca' je jäy ajcxy mɨmadäga'ñ, e miich ajcxy ni ca' mgɨ̈huäx jëda'ajty mgayajpadaangɨxy je tzɨmy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ay miich ayoob ajcxy! com myajcojcɨxy je ögpɨ jut ma je Dios ayucnajtzcapxɨɨybɨ naaxtɨgɨy, je huɨdi m'ap mdeedy ajcxy yaj'o'c. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jadu'n yajhuinjɨhuɨ̈y nej jɨhuɨ̈y miich ajcxy ooy mjäygɨdägy jadu'n nej ajcxy m'ap mdeedy ytundɨgoy. Janch yɨ' ajcxy yaj'ögy Dios y'ayucnajtzcapxɨɨybɨ, e miich ajcxy myajcoj je öcpɨ jut ma ajcxy je' ñaaxtɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Paady yɨ Dios jadu'n huinmay, e mɨnañ: Nyajniguexɨpyɨch miich ajcxy profetas etz y'ayuccapxhuäcxpɨ, e miich ajcxy myaj'ögɨp nijëjɨty, etz jacnaagɨty mbahuɨdijttáccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dios yajcomɨdohuɨpy jadachambɨ tiempo jäy ajcxy je ypocy huɨdi y'ap yteedy ajcxy ytuñ, com maabɨ naaxhuiñ chondägy, yɨ' ajcxy yaj'ögy Dios ytɨy'ajtmɨɨdpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Janch nɨmaaybɨch miich ajcxy co Dios yajcomɨdohuɨpy jadachambɨ tiempo jäy ajcxy je y'ap yteedy ypocy co ajcxy yaj'o'cy Dios ytɨy'ajtmɨɨdpɨ chondägy ma Abel, ixtɨ Zacarías huɨdi jäy yaj'o'c ma Dios ytɨjc tɨba'gujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ay miich ayoob ajcxy Dios y'ayuc huindzɨn! Ca' miich ajcxy m'ixpɨga'ñ Dios ytɨy'ajt, nañ ca' mdzocy co yɨ jäy ajcxy ixpɨgɨpy; tɨm jadu'n nipaady nejjɨhuɨ̈y tɨ mbɨcy je tɨjc ahuaast e ca' miich ajcxy mdɨgɨ̈hua'ñ, e ni mgatzojccɨxy co huingbɨ nɨcxy ytɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Co Jesús anajty jadayaab ayuc yajnɨmaaygɨxy, chi je Dios y'ayuc huindzɨn etz yɨ fariseojäy ajcxy jotmätcooty chi yaj'amɨdogoty ajcxy may ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ñayñɨmáayɨgɨxy miñ xyɨpy co huen amɨdo'ijt Jesús y'ayuc, jɨgɨx jëb páatcɨxɨpy huɨdi jëb mɨɨd xɨ̈gɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chi je mayjäy ooy nimujcy Jesús, janch jadu'n ñay'adijɨy ñay'agodɨ́ɨyɨgɨxy, chi Jesús nɨmaydacy je' ydiscípulos jayɨjp: ―Nigüendɨ mɨɨd yɨ fariseojäy ajcxy nej ajcxy yjäyyaj'ixpɨ́jccɨxy. Yajxon yɨ' ajcxy ycapxy ymɨydägy, chi ca' cuydungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ca' ji ti huɨdi ijtp ayüch nɨcxy ycayajnejhuɨ̈y, nañ ni ca' ji ti huɨdi ijtp ameech nɨcxy ycaniguëxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Huen huɨdi ayuc miich ajcxy ameech mgapxy, yajnejhuɨ̈huɨp yɨ'. Huen huɨdibɨ ayuc huɨdi tɨ mnayyajnɨmáayɨgɨxy ameech jiiby tɨgoty, mɨc yajcapxhuäcxɨp tɨjc nïgɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Chi Jesús yjacmɨnañ: ―Miich ajcxy nmɨgügtɨjc, ɨɨch miich ajcxy nɨmaayb co ca' mdzɨgɨɨygɨxy yɨ jäy ajcxy huɨdibɨ ninïcx yaj'o'cp, com ca' jac ni ti ajcxy tunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ɨɨch miich ajcxy nyajni'ixɨ̈huɨpy pɨn huaad jëbɨ mdzɨgɨɨygɨxy. Yɨ' janch mdzɨgɨɨygɨxy yɨ Dios huɨdibɨ jugy'ajt pɨjcp, e huin'it mɨɨd je' ymɨc'ajt jëbɨ quexɨpy m'alma ma je mɨj jɨɨn. Yɨ' janch mdzɨgɨɨygɨxy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Nej ca' jäy ajcxy ytoogyii mɨgoox joon mɨɨd metz pi'cmeeñ? Dios ni tüg yɨ' ajcxy ca' jäydɨgooyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ixtɨ mgöhuay ajcxy ac mɨchoy Dios mɨɨdɨty. Ca' mdzɨgɨɨygɨxy, jactzou nïgɨ miich ajcxy ma Dios ca'ydɨ pi'cjoon ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ɨɨch miich ajcxy nɨmaayb co pɨnjaty ma miich ajcxy huɨdi capxpɨdzɨmp mayjäyjoty co xymɨbɨ́cyɨch xymɨjpɨdägyɨch, ɨɨch, je jäy huɨdi tzoon tzajpjoty, ngapxpɨdzɨmɨpyɨch co tɨ ngöbɨcyɨch jadu'mbɨ jäy ma Dios y'ángeles ajcxy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pɨnjaty ca' xycöbɨcyɨch mayjäy'agujc, nañ jadu'n ɨɨch yɨ' ca' ngöbɨgɨpyɨch jiiby ma Dios y'ángeles ajcxy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tüg'ócɨy jäy huɨdi jadu'n ɨɨch, je jäy huɨdi tzoon tzajpjoty, xyñigapxp xyñi'ojɨɨybɨch Dios huinmecxɨɨb. Chi jada' pɨnjaty nigapxp ni'ojɨɨyb je' Dios yjɨhuɨ'ñ (je Espíritu Santo), yɨ' janchtɨy Dios ca' yhuinmecxɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Co mmɨdzip ajcxy xyajnɨ́cxɨp ma naymujctac, ma codungdɨjc, etz tungmɨɨdpɨ yhuinduu, ca' mdájɨp mmáyɨp nej m'adzóogɨxɨpy, e ca' mhuinmayɨpy nej ajcxy m'adzohuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Com je Dios yjɨhuɨ'ñ huin'ítɨy ajcxy xyajni'ixɨ̈huɨp nej huaad m'adzoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chi nidügtɨ je mayjäy ymɨnañ: ―Huindzɨn, nɨma' n'ajchɨch co huen yajhuäcxy mɨɨd ɨɨch huɨdi ndaj ndeedyɨch ñidungɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chi Jesús ymɨnañ: ―Yëydɨjc, ca' ɨɨch ni pɨn tɨ xypɨdägyɨch ane'mbɨ ma miich ajcxy etz yajhuäcxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chi Jesús nɨmay je jäy ajcxy: ―Ijxcɨx naygüend'ájtɨgɨx, ca' m'adzojccɨxy comeeñ'adɨɨ, com je m'alma yjugy'ájtɨn ca' je' nïdzoocɨn'adyii huɨdijaty miich ajcxy mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chi ajcxy yajnɨmay tüg ayuc, ymɨnañ: ―Jɨm anajty tüg comeeñyjäy huɨdibɨ anajty ooy mɨj ypɨdägy yajpɨdɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Je comeeñyjäy anajty ooy cɨ'm huinmay ma yjot yhuinma'ñ, ymɨnañ: “¿Ti n'octunɨpɨch com ca' nmɨ́ɨdɨdyɨch ma nyajnïgɨdägɨbɨch yɨ tɨɨbɨ y'ity?” ");
INSERT INTO mcoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chi ymɨnañ jotjoty huinma'ñyjoty: “Nyajpɨdɨ̈cnɨbɨch ndzëx, e ngójɨbɨch jacmɨjpɨ, chi tüg'ócɨy jiiby nbɨdactähuɨbɨch tɨɨbɨ y'ity.” ");
INSERT INTO mcoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Co jadu'n ndunɨpyɨch, chi jëbɨ jotcujc ndzɨnähuɨbɨch, com ooy anajty nmɨ́ɨdɨdyɨch pɨdägy yujcpɨcy, jëbɨ canaag jɨmɨjt niboocxyɨch etz jëbɨ ngay n'ügyɨch jotcujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chi Dios nɨmay je comeeñyjäy: “Ooy jɨbɨc-huinma'ñ miich mɨɨdɨty. Cham coodz ɨɨch miich nibɨjctzohuɨ̈huaanɨy yɨ m'alma (m'ögɨp), e co anajty tɨ m'ögy yɨ huɨdibɨ tɨ myujcpɨcy, ¿pɨn yɨ' je'adɨɨb?” ");
INSERT INTO mcoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jadu'n yjajty yɨ' ajcxy huɨdibɨ ymeeñ'idɨ'ñ cɨ'm yujcpɨjcp, ca' yɨ' ajcxy jiiby ycomeeñyɨty ma Dios yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chi Jesús nɨmay je y'ixpɨjcpɨdɨjc: ―Paady ajcxy nɨmaaygɨxy co ca' huaad mjottɨgooygɨxy ma yɨ mdzɨnáayɨn yɨ mjugy'ájtɨn, huɨdi mjɨ́ɨcxcɨxɨpy mgáaygɨxɨpy, huɨdi mɨɨd mninïcx mxójxcɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yɨ jugy'ajt jacnïgɨ tzou yɨ', ca'ydɨ yɨ caayɨn uucɨn, etz je mninïcx jacnïgɨ choohuɨty ca'ydɨ huit. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ijxcɨx yɨ joogy ni ca' ñïpy, ni ca' chijccɨxy, ni ca mɨɨdɨty ytɨjc ni chëx, e Dios yɨ' ajcxy mooyɨpy huɨdi yjɨɨcxcɨxyp, ¿nej cayjacnïgɨ miich ajcxy mdzoohuɨty ca'ydɨ joon ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ca' ji ni pɨn ma miich ajcxy pɨn jadɨpy nej ñayjɨjptzomɨ̈huɨɨb jadüg cɨ̈nuux. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pen ca' mjajtcɨxy nej mdúngɨxɨpy huɨdi hueen huinma'ñ, ¿nej co mdzachmɨjottɨgooygɨxy yɨ tzɨnaayɨn yɨ comeeñ'ájtɨn? ");
INSERT INTO mcoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ijxcɨx yɨ aaybɨjy nej xóxyɨty, ca' ytaaccɨxy ni ca' yxuuygɨxy. Ɨɨch miich ajcxy nɨmaayb, co ni je rey Salomón mɨɨd tüg'ócɨy ymeeñ ca' ñayxojxɨ jadu'n nej jada aaybɨjy ujtzpɨjy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pen jadu'n Dios xoxy yɨ aay yɨ ujtz huɨdibɨ cham jajtɨp ma yɨ tungop, e com jabom tɨ anajty ñiicxnɨ, Dios xypubedɨpy xypudɨgɨ̈huɨpy nïgɨ miich ajcxy huɨdi hueen mɨbɨjcp. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ca' miich ajcxy mhuinmay'ahuɨdíjtcɨxɨpy ajcxy ti mgáaygɨxɨpy m'úuccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yɨ naaxhuiñyjäy ajcxy ymɨjottɨgoyb anaxy tüg'ócɨy caayɨn uucɨn, huit etz tijaty. Miich ajcxy huɨdi mɨjpɨdacp Dios, Dios Teedy ñejhuɨɨyb co copɨcy ajcxy mɨɨd'adɨpy caayɨn uucɨn etz huit tucxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jayɨjp mɨjottɨgooygɨx Dios y'ayuc ytɨy'ajt, chi jada' tüg'ócɨy huɨdi ajcxy myajmayjajty mbáatcɨxɨpy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Chi Jesús yjacmɨnaañ: ―Ca' miich ajcxy mdzɨgɨɨygɨxy, miich ajcxy mnihueeñɨty, per mDios Teedy yega'ñ ane'mdac tzajpjoty mɨɨd miich ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tooccɨx tijaty miich ajcxy mɨɨd, nimooygɨx ayoobɨtɨjc. Yaj'oyɨɨygɨx meeñ'idɨ'ñ huɨdi ca' y'amɨjɨ̈huɨpy ni camɨna. Yaj'oyɨɨygɨx tüg pɨdägy, janch mɨj e janch oy, jiiby tzajpjoty huɨdi ca' ycɨxɨpy ytɨgoyɨpy, ma ca' meetzpɨ huaad ytɨgɨ̈y, ni ucxytɨng ca' yajhuindɨgoyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pen miich ajcxy mɨɨd mgomeeñ'ájtɨn ya naaxhuiñ, yaayɨ je mjot mhuinma'ñ ajcxy. Pen mdzojcpy ajcxy je oybɨ huɨdibɨ Dios yegamy, nañ mɨɨd'ájtcɨxy jɨm jabom jabom mjot mhuinma'ñ ajcxy ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Chi Jesús yjacmɨnañ: ―Ni'ixɨɨygɨx mjot mhuinma'ñ jadu'n nej jɨhuɨ̈y mhuit myujc'ameetcɨxy co mdunaangɨxy, etz jadu'n nej jɨhuɨ̈y lámpara mnögpɨjccɨxy co mdzumnaxaangɨxy m'ahuixaangɨxy je huindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ni'ixɨ̈'ijtcɨx jadu'n nej jäy huɨdi yhuindzɨn ahuijxp, co anajty yhuimbity co anajty tɨ y'oy ma jäy tɨ ypɨcy, chi co anajty minɨpy ycogapxɨ̈y, mɨc'amy myaj'ahuädzɨty ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jotcujc ajcxy je tumbɨ co je yhuindzɨn anajty yjädy, e paady chumnajx juugy. Janch nɨmaaybɨch miich ajcxy co je tumbɨ ajcxy yhuindzɨn anajty yjädy, chi yhuit yujc'ameedɨpy, chi ajcxy yaj'ixtägɨpy ma caybejt, yajcayɨpy yaj'ügɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Oy miinɨpy je huindzɨn mɨjcoodz o moñyɨ, e páadɨp je tumbɨdɨjc ajcxy jɨm chumnájxcɨxy juugy, jotcujc je' ajcxy je jadu'mbɨ tumbɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nejhuɨɨygɨx jada co je codɨjc ixyipy nejhuɨ̈huɨpy ti hora ymina'ñ je meetzpɨ, chi juugy ixyipy chuumnaxa'ñ, e ca' cɨ̈yegɨpy ytɨjc nɨcxy jäy tɨgoty ymeech. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Miich ajcxy nañ jadu'n íjtcɨxy ni'ixɨ', mɨna anajty ca' ti mhuinmaaygɨxy, huin'it miina'ñɨch ɨɨch, je jäy huɨdi tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chi Pedro Jesús nɨmay: ―¿Pɨn jada tɨ myajnɨmaayb jada ayuc huɨdi tɨ mgapxy, ɨɨch ajcxy, o nidüg'ócɨy jäy? ");
INSERT INTO mcoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chi je Huindzɨn Jesús ymɨnañ: ―Huɨdibɨ tumbɨ je' ya huɨdi tumb mɨɨd yhuindzɨn janch cɨxyjot huinɨjot huɨdi mɨɨd yhuijy'ajt ycujc'ajt huɨdi je yhuindzɨn mooyɨp ané'mɨn ma ytɨjc, huɨdi yajnigɨdägɨɨyb tumbɨdɨjc nej ypaadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jotcujc je tumbɨ co anajty je' yhuindzɨn yhuimbity e padɨɨyb tɨ cuyduñ jadu'n nej anajty tɨ ñɨmäyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Janch ɨɨch miich ajcxy nɨmäy co je tumbɨ huindzɨn yajmɨhuɨ'mdähuɨpy jada ytumbɨ tüg'ócɨy pɨdägy huɨdi ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pen je tumbɨ yhuinmaayb jotjoty huinma'ñyjoty co je yhuindzɨn yhuäcxɨjpnɨ mɨna ymiina'ñ, chi mɨdziptzoonɨ jacjadyii tumbɨdɨjc ajcxy, huojpnɨ, cojxnɨ, nañ ytɨgɨɨyñɨ caayb uucp anaxy etz ymügyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chi je tumbɨ yhuindzɨn miinɨpy ma je xɨɨ hora anajty ca' jɨjp'ixy e ni canejhuɨy anajty, e huin'it ooy tzaachytunɨpy yɨ tumbɨ e chi pɨdägɨpy ma je huɨdi ajcxy ca' ytudägyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Je tumbɨ huɨdi nejhuɨɨyb nej yhuindzɨn chójcɨn, e ca' cuyduñ, ni ca' ycapxymɨdoy, ni ca' ni'ixɨ' ity co yhuindzɨn anajty yhuimbity, je' je' nïgɨ yajtzaachytunɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Je tumbɨ huɨdi ca' yajxon huinjɨhuɨ̈y nejjɨhuɨ̈y yhuindzɨn chójcɨn, hueenɨ je' yajtzaachytunɨpy. Huenpɨ́nɨty huɨdi may yajmooyb, may yɨ' yajmɨbɨjctzohuɨɨyb; etz huenpɨ́nɨty huɨdi tɨ mɨhuɨ'my ooy, yajmɨbɨjctzohuɨɨb nïgɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Chi Jesús yjacmɨnañ: ―Ɨɨch tɨ nmiiñɨch ya naaxhuiñ co jɨɨn nbɨdägɨbɨch. ¡Ooy njadzocyɨch ji ixyipy ñitooyñɨ! ");
INSERT INTO mcoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nyajnaxɨpyɨch tüg tzaachypɨ, e ¡ooy ndajy nmayɨch ixtɨ mabaad yajcuydundäy! ");
INSERT INTO mcoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Nej miich ajcxy mdijy co tɨ nmiiñɨch ya naaxhuiñ co nyajcɨxɨpyɨch je tzipɨ? Ɨɨch miich ajcxy nɨmaayb co ca'. Hue' janchtɨy nyajnaybɨjc-huäcxáanɨbɨch jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jadachambɨ etz yjacnɨcxnɨ xɨɨ tiempo ji mɨgoox tüg quëxjäydɨjc huɨdibɨ ajcxy ñaybɨjc-huäcxɨɨb, tugɨɨg mɨɨd je metzpɨ, e metzpɨ mɨɨd je tugɨɨgpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Je ungdeedy tziptunɨp mɨɨd ymang etz je mang mɨɨd yteedy. Nañ je ungdaj tziptunɨp mɨɨd yñɨɨx etz je nɨɨx mɨɨd ytaj. Nañ jadu'n je xecy tziptunɨp mɨɨd yxecy. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chi Jesús nɨmay je mayjäy ajcxy: ―Co ajcxy m'ixy je joc ypɨdɨ̈gy ma xɨɨ ycɨdägy, chi mɨnaangɨxy co tühuaam, e janch jadu'n yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Co ymiiñ je jɨɨnboj, chi miich ajcxy mɨnaangɨxy co ambɨgaamb, chi janch jadu'n yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Miich jɨbɨc jäy ajcxy! Ooy mjajtcɨxy nej myajcapxcɨxy yɨ xɨɨ tiempo huɨdi ajcxy m'ijxpy tzajpcɨ́xy etz ya naaxhuiñ: ¿Nej co ca' mjajtcɨxy nej myajcápxcɨxɨpy xɨɨ tiempo ymiñ ycɨdägy? ");
INSERT INTO mcoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Nej co miich ajcxy ca' cɨ'm mnaydɨydúunɨgɨxy nej ytudägyɨty je tɨy'ajt? ");
INSERT INTO mcoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Co mnɨ́cxɨpy ma yɨ codung mɨɨd yɨ mmɨdzip jac'oy co mnayyaj'oyɨ̈huɨpy mɨɨd yɨ mmɨdzip tü'am, ca'ydɨ mɨɨd mjädɨp ma yɨ codung, e chi je codung xycɨ̈yegɨpy ma je xueetz, e je xueetz xypɨdägɨp pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ɨɨch miich nɨmaayb co ca' jiiby mbɨdzɨmɨpy, ixtɨ coonɨ mgüejttähuɨpy tüg'ócɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Huin'it jäy mɨɨdmɨydacy Jesús jadu'n nej je gobernador Pilato yaj'ögy nijëjɨty jäy jɨm Galilea, chi tem huɨdijtɨ ajcxy ñɨ'py mɨɨd ɨyujc ñɨ'py huɨdi je' ajcxy mɨɨd huindzɨgɨ'ñ tuuñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chi Jesús y'adzooy nɨmay ajcxy: ―¿Nej mdijy, nïgɨ anajty ypocymɨɨdɨty je galileojäy ajcxy huɨdi jadu'n ayo'n patp, ca'ydɨ nidüg'ócɨy galileojäy? ");
INSERT INTO mcoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ɨɨch miich ajcxy nɨmaayb co ca'. Pen miich ajcxy ca' mjothuimbíjtcɨxy ma Dios etz nay'adzɨgɨ́ɨyɨgɨxy ma Dios, nidüg'ocɨy miich ajcxy mgɨjxtähuɨp mdɨgoydähuɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","E je' ajcxy je majmocxtugɨɨgpɨ huɨdi je mɨjtɨjc jɨm Siloé nïgɨdaagoottɨ, yaj'öcɨ ajcxy. ¿Nej mdijy nïgɨ ajcxy ypocymɨɨdɨty, ca'ydɨ nidüg'ócɨy je jäy huɨdi tzɨnayb jɨm Jerusalén? ");
INSERT INTO mcoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ɨɨch miich ajcxy nɨmaayb co ca'. Pen miich ajcxy ca' mjothuimbijtcɨxy, nañ mgɨjxtähuɨp mdɨgoydähuɨp miich ajcxy nidüg'ócɨy, jadu'n nej je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chi Jesús yajnɨmay ajcxy jada ayuc: ―Tüg jäy anajty mɨɨdɨty higuerɨ cojy ma y'aguemy, chi ñɨcxy jiiby ma y'aguemy higuerɨ tɨɨm ijxtaaybɨ, ni ca' paty. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chi nɨmay je' ytumbɨ: “Cham mɨdugɨɨg jɨmɨjt miiñɨch ya higuerɨ tɨɨm ijxtayb ma jada higuerɨ cop, ni tüg ngapaadyɨch. Huen yajpujxcɨday jada higuerɨ cop, nej co nɨgoobɨ ñaaxnihua'ñ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chi je' ytumbɨ y'adzooy: “Huindzɨn, oc'ixmatz. Huen jadüg jɨmɨjt jëyɨ ocjactɨnäy, octajyɨch jayɨjp yɨ naax jühuɨdityɨ, etz oc'abonɨjɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pen tɨɨm'ajt ca' nyajpuxɨpy, pen ca' ytɨɨm'aty jëbɨ nbújxɨgɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Chi Jesús anajty yaj'ixpɨcy ma tüg naymujctac pocxxɨɨduum. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jɨm anajty tüg töxyjäy huɨdi anajty mɨmajmocxtugɨɨg jɨmɨjt cujc mɨ'ijtnɨ yjɨɨbojpa'm, agojojy anajty yöy, ni nej anajty yca'oyɨ̈y nej ytɨnaaygugɨ̈huɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Co Jesús ijxy, chi yaaxɨ, e nɨmay: ―Töxyjäy, tɨ mdzögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chi ycɨ' cɨjxxajy ma je töxyjäy yjɨɨx, e chi je' yjɨɨx ytɨɨy, huin'it ytɨgɨɨy Dios ojadajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Huin'it je naymujctac huindzɨn ooy yjotmäty mɨɨd co anajty Jesús jäy tɨ tzoyɨ̈y pocxxɨɨduum. Chi je naymujctac huindzɨn nɨmay ajcxy je mayjäy: ―Jëyɨ tudujc xɨɨ jäy huaad ytuñ, huen miñ semaanjoty pɨn yajtzoyɨ̈huam, ca' ypocxxɨɨduumɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chi je huindzɨn Jesús ymɨnañ: ―¡Miich ajcxy naybɨdaacɨp nej tudägyjäy, e ca' yjanchɨty! ¿Nej ca'miich ajcxy mmɨguejɨ̈y mhuajyuubɨ, etz mburro ma ypëcxtac pocxxɨɨduum, e myajnɨcxy ajcxy nɨɨ'ucpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","E jada Abraham y'ap y'oc huɨdi Satanás ca' y'ixmachii majmocxtugɨɨg jɨmɨjt, ¿nej ca' ypadyii nyajtzögɨbɨch pocxxɨɨduum? ");
INSERT INTO mcoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Co Jesús jadu'n y'adzoy, chi yajtzöyduuñ ymɨdzip. Chi tüg'ócɨy cajpjäy oy ajcxy yjotcugɨɨygɨxy mɨɨd je oybɨ huɨdi Jesús ytuun. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chi Jesús ymɨnañ: ―¿Nej m'oc'a'ɨxɨɨygɨxy yɨ Dios y'ané'mɨn? ¿Huɨdi mɨɨd n'ocyajquipxɨ̈huɨbɨch? ");
INSERT INTO mcoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jadu'n Dios y'ané'mɨn nipaady nej mostaza pajc huɨdibɨ tüg jäy ñiip ma y'aguemy, chi ymujxy etz yeegy ooy janch mɨj, chi je joon ajcxy oy ype'ñ pɨdaaccɨxy ma je mostaza quipy aacxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Chi Jesús jadüg'oc ymɨnañ: ―¿Huɨdibɨ mɨɨd n'ocyajquipxɨ̈huɨbɨch yɨ Dios y'ané'mɨn? ");
INSERT INTO mcoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jadu'n Dios y'ané'mɨn ni paady nej levadura huɨdi tüg töxyjäy ytijhuɨdijt mɨɨd tugɨɨg quipxɨ'ñ harina ixtɨ coonɨ yajxunday je harina. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Co Jesús anajty ñɨcxy jɨm Jerusalén, chi yaj'ixpɨcy anajty Dios y'ayuc ytɨy'ajt cajp cajp majaty ñaxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chi tüg jäy Jesús amɨdoy: ―Huindzɨn, ¿nej hueenɨ yɨ jäy ajcxy huɨdi y'alma nïdzögɨp? Chi Jesús y'adzooy: ");
INSERT INTO mcoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Mɨjpɨdaaccɨx Dios ytɨy'ajt amuumdügjot, jëbɨ ajcxy m'alma ñïdzögɨpy, jadu'n nipaady nej jäy ajcxy ñaymɨc'íjxɨgɨxy co ytɨgɨ̈huaangɨxy ma je tɨjc aguu xützpɨ. Jadu'n ɨɨch miich nɨmaayb co mayjäy ooy ja'a'ɨxɨ̈y ytɨgɨ̈huaangɨxy ma Dios y'ane'my e ca' ajcxy jadɨpy nej ytɨgɨ́ɨygɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Co je codɨjc ypɨdɨ̈gɨpy etz agɨɨyñɨp ytɨjc, huin'it miich ajcxy pɨnjaty tɨbäy huɨ'm, chi jiiby tɨbäy miich ajcxy mmɨnandägɨpy: “Huindzɨn, yaj'ahuädz”, e chi je tɨjc huindzɨn miich ajcxy xy'adzohuɨpy: “Ca' ɨɨch miich ajcxy nejhuɨ̈yɨch ma miich ajcxy mdzoongɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chi huin'it miich ajcxy mɨnandägɨpy: “Mɨɨd ɨɨch ajcxy miich tɨ nmɨɨdgaaygɨxy tɨ nmɨɨd'uuccɨxy, e miich tɨ myaj'ixpɨcy ma ɨɨch ajcxy ngajp.” ");
INSERT INTO mcoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chi je Huindzɨn y'adzohuɨpy ajcxy: “Ɨɨch miich ajcxy nɨmayb co ca' nnejhuɨ̈yɨch ma miich ajcxy mdzoongɨxy. Jɨhuäccɨx ma ɨɨch nhuinduu, miich ajcxy pocy ytumbɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chi miich ajcxy jɨm ooy mdájcɨxɨpy mmáygɨxɨpy, myáaxcɨxɨpy mdɨɨtzquéetcɨxɨpy, co miich ajcxy m'ixɨpy Abraham, Isaac, Jacob etz tüg'ócɨy yɨ Dios y'ayucnajtzcapxɨɨybɨ jiiby ma Dios y'ane'my, e miich ajcxy tɨbäy anajty tɨ mhuɨ'mgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Minɨp yɨ jäy ajcxy huɨdibɨ tzoomb ma xɨɨ ypɨdzɨmy, ma xɨɨ ycɨdägy, ma jayhuixtujc ypɨdzɨmy, etz cham ma madzäcruudz ytɨnaay'ahuɨ̈y, chi y'ixtáaccɨxɨpy ma je caydac jiiby ma Dios y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Paady ji jäy ajcxy huɨdi cham axam'ajtp, je' ajcxy jayɨjp'adɨp, etz ji jäy ajcxy huɨdibɨ cham jayɨjp'ajtp, etz je' ajcxy axam'adɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chi nijëjɨty fariseojäy nɨmay Jesús: ―Quëg ya com yɨ rey Herodes xyaj'ögaam. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chi Jesús y'adzooy: ―Nɨcx nɨmaaygɨx yɨjiibɨ huaax co nyajpɨdzɨmybɨch ca'oybɨ etz nyajtzoocypɨch jäy cham etz jabom, codugɨɨg xɨɨ tɨ ndung mayíijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ooy ycopɨcyɨty co ɨɨch njactüyöyɨbɨch cham, jabom etz huixtɨc. Com ypaadyii co Dios y'ayuccapxhuäcxpɨ y'ögɨp ajcxy jɨm Jerusalén. Chi Jesús yjacmɨnaañ: ");
INSERT INTO mcoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","―¡Jerusalén jáy! ¡Jerusalén jäy! huɨdibɨ yaj'o'cp Dios y'ayucnajtzcapxɨɨyb ajcxy, etz ycögädz ajcxy je jäy huɨdibɨ Dios tɨ xyajniguéjx ajcxy. Janch canaag'oc ɨɨch miich ajcxy njahuijtzmuga'ñ jadu'n nej tzeydaj y'ung yajmucy queecpätcɨ̈py, chi ni ca' jadu'n tɨ m'a'ɨxɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chi jada' ijxcɨx cuendɨtungɨx, com jadachambɨ mgajp yhuɨ'my najtz'ixɨ'. Ɨɨch miich ajcxy nɨmayb co ca' xy'ixɨpyɨch jadügtecy, ixtɨ coonɨ anajty tiempo paaty mɨna mmɨnáangɨxɨpy: “Capxpaaty je' huɨdi miimb mɨɨd Huindzɨn'ájtɨn Dios ycɨxpɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Chi jadu'n yjajtɨ co tüg pocxxɨɨduum Jesús ytɨgɨy ycaya'ñ anajty ma tüg fariseojäy ytɨjc, hue' anajty judío tungmɨɨdpɨ. Chi yɨ judío ixpɨcytɨjc ajcxy tzach'ix'ijtcɨxy Jesús, amɨdoo'ijtcɨxy Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Huin'it tüg jäy huɨdibɨ ymɨɨd anajty quïxypa'm miiñ ma Jesús yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chi Jesús ymɨgapxɨ je' ajcxy huɨdibɨ yaj'ixpɨjc Dios ñecy etz yɨ fariseojäy ajcxy, nɨmay: ―¿Nej je Dios ytɨy'ajt ymɨnañ? ¿Huaad o ca' huaad chögy jäy pocxxɨɨduum? ");
INSERT INTO mcoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chi ajcxy y'amonday. Huin'it Jesús cɨ̈nïxajɨɨy je pa'm jäy, chi yajtzoocy. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chi Jesús nɨmay je fariseos ajcxy: ―¿Nej miich ajcxy pen nɨɨjutcögäp ajcxy mhuajyuubɨ o mburro pocxxɨɨduum, nej ca' mɨc'amy nɨcxy yajpɨdzɨmgɨxy oy ypocxxɨɨduumɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chi ca' ajcxy jajty nej y'adzohuimbíjtcɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Co Jesús ijxy jadu'n nej yɨ' ajcxy jac'oybɨ ɨñaybejt huin'ijxcɨxy jɨm ma je caybejt, chi ajcxy tüg ayuc yajnɨmaayɨ, je tɨɨbɨ anajty yajhuomiingɨxy: ");
INSERT INTO mcoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Co miich myajhuoohuɨpy ma pɨjcpɨ yajnixɨɨduñ, ca' m'ixtägɨpy ma je ɨñaybejt cödumbɨ, ca' jécyɨty co yajhuoomiñ huɨdi je' ɨñaaybejt ymɨhuaad. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chi jada' xyñɨmähuɨpy je huɨdibɨ anajty tɨ xyhuoomiñ: “Mo' jada mɨgüg jada ɨñaaybejt cödumbɨ.” Chi miich tzöydu'n mɨɨd mnɨcxpy ma je' ɨñaybejt axambɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Co jäy xyhuohuɨpy ma je pɨ́jcɨn yajnixɨɨduñ, jɨm m'ixtägɨp ma je axambɨ ɨñaybejt, e co yminɨpy je huɨdibɨ anajty tɨ xyhuomiñ, chi xyñɨmähuɨpy: “Mɨgüg, nax ma yɨ ɨñaybejt cödumbɨ.” Huin'it capxpaady m'idɨpy ma je' ajcxy huɨdibɨ anajty ɨñayb ma caybejthuinduu mɨɨd miich. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pɨnjaty cɨ'm naygömáyɨp, tzöydu'nbaadɨp je'. Pɨnjaty naybɨdaacɨp nicy xeemy je' je' capxpaady y'idɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chi Jesús nɨmay pɨnjaty huɨdi anajty tɨ yhuoomiñyii: ―Co miich mxɨɨduunɨpy ca' mhuoohuɨpy je jäy ajcxy huɨdibɨ ooy mɨɨd mnaymɨgüg'ájtɨgɨxy, ni mmɨdügquëx, ni m'ajuugy m'amɨgüg, ni mmɨdɨjc comeeñybɨ, ca' jécyɨty co nañ jadu'n xyhuohuɨpy, e chi anajty jac mɨj yejc-huimbijty. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Co mxɨɨdunɨpy, chi huoohuɨpy ayoobɨtɨjc, tzaachɨ̈jäy ajcxy, tecymätpɨ ajcxy, etz jäy huiintzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huin'it miich mjotcujc'adɨpy co yɨ' ajcxy ca' jadɨpy nej yejc-huimbidɨpy. Jiinɨ Dios xymɨgüedɨpy co anajty yajjugypɨcy je tudägypɨ jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tüg jäy huɨdi anajty ɨñaayb mɨɨd Jesús ma caybejt huinduu co mɨdooy nej Jesús ymɨnañ, chi nɨmay Jesús: ―Jotcujc je jäy ajcxy huɨdi cayɨp jiiby ma Dios y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chi Jesús y'adzooy: ―Tüg jäy may anajty jäy yaj'adzu'ada'ñ, chi jayɨjpnɨ oy mayjäy nɨmay co anajty yaj'adzuu'ada'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Co je adzuu'ɨ̈bɨ paty, chi quejxy tüg cogapxy huen nɨcxy huoogɨxy je tɨɨbɨ anajty ajcxy yajnɨmäy, nɨmay ajcxy: “Jámgɨx, tɨ jɨm yajni'ixɨ̈y je caayɨn uucɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chi ajcxy nidüg'ócɨy ymɨnandacy: “Tun may'ajt meecxcɨch, ca' y'oyɨ̈y nej nyajnɨ́cxɨbɨch.” Chi je' jayɨjp jäy y'adzoy: “Tɨ njuyɨch tüg rancho je' copɨcy jayɨjp nɨcxy n'ixyɨch, paady ca' nɨcxa'ñɨch; tun may'ajt meecxcɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Chi jadüg jäy ymɨnañ: “Tɨ njuyɨch mɨgoox par huaj yuubɨ, nɨcxy n'oc'ijxmadza'ñɨch jayɨjp, paady ca' y'oyɨ̈y nej nɨ́cxɨbyɨch, tun may'ajt meecxcɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chi jadüg jäy ymɨnañ: “Tɨm chamnɨ nbɨcyɨch, paady ca' oyɨ̈y nej nɨ́cxɨbyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Co je cogapxy yhuimbijty, chi yajnɨmay je' yhuindzɨn jadu'n nej je jäy ajcxy y'adzooy huɨdi anajty oy tɨ huoy. Huin'it je huindzɨn ooy yjotmätcoty, chi nɨmay je ytumbɨ: “Nɨcx tzojcyɨ cajpjoty ma yɨ jäy ajcxy yöygɨxy ñajxcɨxy etz ma yɨ mɨj tü, e chi huomiinɨpy pɨn mdɨmypaatyp ayoobɨtɨjc, yɨ tzaachɨ̈jäy etz huiintzpɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chi je' ytumbɨ ymɨnañ: “Huindzɨn, tɨ nduñɨch jadu'n nej tɨ xyñɨmäyɨch, etz jac chiinɨ ɨñaybejt.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chi je huindzɨn nɨmay je' ytumbɨ: “Nɨcx ma yɨ mɨj nɨɨ mɨj tü yajmin je jäy ajcxy adzip, huen ɨɨch ndɨjc uch. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi ɨɨch miich nɨmäy co ni tüg yɨ jäy ajcxy huɨdi jayɨjp yajnɨmay, ca' ajcxy y'adzuu'adɨpy mɨɨd ɨɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chi may anajty jäy ñɨcxy mɨɨd Jesús, chi Jesús yhuäc-huimbijty, nɨmay ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Pen ji pɨn xypamiiñɨch, e ooy nïgɨ tzocy yɨ' ytaj yteedy, yɨ' ytöxyɨjc, yɨ' y'ung, y'ajch o chɨ', etz nañ ooy nïgɨ tzocy yɨ' yjugy'ájtɨn, ca' ɨɨch yɨ' huaad ndiscípulo'adyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yɨ jäy ajcxy huɨdi xypamiimbɨch huɨdi ɨɨch ndiscípulo'adaanɨp, copɨcy yajnaxɨpy ajcxy ayo'n, jadu'n nipaady nejjɨhuɨ̈y ycruudz tɨ cabɨ̈ccɨxy e nɨcxy yajcruudzpeda'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Co miich ajcxy mmɨjtɨjc mgoja'ñ, chi miich ajcxy jayɨjp m'ixtaaccɨxy e m'a'ɨxɨɨygɨxy jadu'ñyɨ meeñydunaangɨxy, nej pen mɨɨd ajcxy huɨdi jëbɨ mɨɨd myajmaaygɨxy je mmɨjtɨjc, o penɨ ca'. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ca' yjécyɨty co anajty je tɨjc tɨ yajpojtzɨ̈gy, chi anajty ca' m'ocjajtnɨ nej myajmayɨpy, e pɨnjaty anajty tɨ xy'ixy, chi ooy xyñɨxïgɨpy xyajxïgɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Chi jäy ajcxy ymɨna'nɨp: “Jadayaabɨ yëydɨjc nɨgoo tɨ yajtzondägy tɨjc poch, e ca' tɨ ocyajmaayñɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O huɨdi rey ji co chona'ñ tziptumbɨ mɨɨd huingbɨ rey, ¿ca' jayɨjp huinmayɨpy pen jëbɨ chiptuñ mɨɨd majc mil jäy, pen je ymɨdzip miimb mɨɨd iipx mil jäy? ");
INSERT INTO mcoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ca' yjécyɨty co je tügpɨ rey jɨguemnɨ anajty miiñ, chi quexɨpy tüg huingapxpɨ pɨjctzohuɨpy may'ajt ca'ydɨ yɨ tzip yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hueñypɨ́nɨty ma miich ajcxy pen ca' m'ixmájtzcɨxy tüg'ócɨy tijaty miich ajcxy mmɨɨd, ca' ɨɨch yɨ' huaad ndiscípulo'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yɨ caan ooy yɨ' y'óyɨty pen ymɨɨd ytamtz'ájtɨn. Co je caan ytɨgoy ytamtz'ájtɨn ca' ji ni ti xücx'ájtɨn yegɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yɨ caan huɨdi tɨ ytɨgoy ytamtz'ájtɨn ni ca' y'oybɨdägnɨty ma je naax, ni ma je püx huɨdi aboon'ajtp. Hue' janchtɨy yaj'ixjɨdejtp tɨbäy. Pɨnjaty ɨɨch n'ayuc xymɨdohuaanɨp huen mɨdo'mbɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Chi ajcxy je yajcuejtpɨdɨjc etz pocyjäydɨjc nimɨjhuägtay ajcxy Jesús tzach'amɨdoo'idaanɨ ajcxy je' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chi ajcxy huɨdi ooy tzachmɨjpɨdägy judíojäy ytɨy'ajt etz huɨdi ajcxy yaj'ixpɨjc Dios ñecy ameech nigapxcɨxy ni'ojɨɨygɨxy je Jesús, chi ajcxy ymɨnañ: ―Yɨ Jesús pocyjäydɨjc ajcxy ymɨgüg'ajtpy, e yɨ' mɨɨd ycaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Chi Jesús jadayaabɨ ayuc ajcxy yajnɨmay: ―Huɨdi jäy ji ma miich ajcxy pen ymɨɨd mɨgo'px cöbixy co ytɨgoy nidügtɨ, ¿nej ca' yajhuɨ'mɨpy je mada'px majmocx mɨdaaxpɨ jɨm ma chɨnaaydac, chi nɨcxy ixtäy huɨdi anajty tɨ ytɨgoy ixtɨ coonɨ paadɨp? ");
INSERT INTO mcoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Co paadɨp, chi mɨc'amy pɨdägɨp ma quejycop janch jotcujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Co yajjädɨp ma ytɨjc, chi huomucy ymɨgügtɨjc etz ymɨjɨɨn ymɨdɨjc, nɨmähuɨpy ajcxy: “Jotcugɨɨygɨx mɨɨd ɨɨch, tɨ ɨɨch ngöbixy nbaady huɨdi anajty tɨ ytɨgooy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ɨɨch miich ajcxy nɨmaayb co nañ jadu'n tzajpjoty ooy jotcujc'ájtɨn nïgɨ mɨɨd co tüg pocyjäy yjothuimbity, ca'ydɨ mɨɨd mada'px majmocx madaax tudägypɨ jäy huɨdi ca' ytundɨgoy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Chi Jesús yjacmɨnañ: ―¿Huɨdi töxyjäy ji pen ymɨɨd majc ymeeñ, co ytɨgooy tüg meeñ, nej ca' jɨɨn nöctzohuɨpy, e ytɨgɨ̈huɨpy pedɨ̈gpɨ ixtähuɨpy ymeeñ oñydägy ixtɨ coonɨ paadɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Co paady, chi huomucy ymɨgügtɨjc etz ymɨjɨɨn ymɨdɨjc, e chi nɨmähuɨpy: “Xondaaccɨx mɨɨd ɨɨch, tɨ ɨɨch nmeeñ nbaty huɨdibɨ ɨɨch anajty tɨ nyajtɨgoy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jadu'n ɨɨch miich ajcxy nɨmäy co nañ jadu'n Dios y'ángeles ajcxy ooy yjotcújcɨty co yjothuimbity tüg pocyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nañ jadu'n Jesús yjacmɨnañ: ―Tüg yëydɨjc ymɨɨd anajty metz ymang. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chi je jacmutzpɨ nɨmay yteedy: “Tat, mooygɨch yɨ pɨdägy huɨdi xypaatpɨch.” Chi je' yteedy je pɨdägy yajhuäcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hueenɨ anajty xɨɨ tzuu cujc ñɨcxy, co je' ymang mutzpɨ yajmujctay tüg'ócɨy huɨdi yɨ yjë'ajtpy, chi chooñ ñɨcxy huingnaax huinggajp. Chi jɨm mɨc'amy yajtunday yajtɨgoyday tüg'ócɨy huɨdi anajty ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Co anajty ymeeñ tüg'ócɨy yajtundäy, chi miiñ tüg mɨj yuu ma je cajp. Chi ooy je mang mutzpɨ caayɨn uucɨn huit meeñ jayajmayjajtnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chi je' ninɨcxy tüg jäy ma je jɨmbɨ naaxjot ymɨduna'ñ anajty. Chi yquejxɨ ma yrancho ɨdzɨm cuend'ajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ooy anajty janijot'aty ycüxa'ñyii mɨɨd je pëtztɨɨm huɨdi anajty ɨdzɨm y'ojcpy. Chi ni pɨn anajty ni ti ycamöyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Co yhuinma'ñ yajmejch, chi ymɨnañ ma yjot yhuinma'ñ: “Jɨm janch maytumbɨ ma ɨɨch ndeedy ytɨjc, ymɨɨd ajcxy jɨɨcxy pɨcy janch may'amy. Ɨɨch ya tzach'ayoob mɨɨd yuu xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tzonaambɨch ya, nɨcxa'ñɨch ma ɨɨch ndeedy, nɨmähuɨbɨch: Tat, tɨ ndundɨgóyɨch mɨɨd Dios tzajpjotypɨ etz mɨɨd miich. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cham ca' ypadyii miich mɨna'nɨp co miich xy'ung'adyíijɨch. Yajtungɨch jadu'n nej mdumbɨdɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chi je' choñ, ñɨcxy ma yteedy. Jeguëgyñɨ anajty ymiñ co yteedy y'ijxpaatɨ. Chi yteedy ypa'ayogotɨ, e ñɨcxy poyɨ̈gy oy jɨjpcobadɨ̈y. Chi yögmɨnennajxy etz tzücxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chi je ung ymɨnañ: “Tat, tɨ ndundɨgooyɨch mɨɨd Dios tzajpjotypɨ etz mɨɨd miich. Cham ca' ypadyii nɨcxy miich mɨna'ñ co ɨɨch miich xy'ung'adyii.” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Chi je ungdeedy nɨmay je' ytumbɨ: “Yajpɨdzɨm je huit oybɨ, mɨc'amy yajnïjenɨɨygɨx jada n'ungɨch, chi mooygɨx yɨ cɨ̈jiitz etz ycɨ̈g. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nɨcx yajtzoongɨx yɨ huaj mang nïcxpɨ, yaj'öccɨx, chi ngaayɨm n'uucɨm e nxɨɨduunɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Jada n'ungɨch jadu'n nipaady nejjɨhuɨ̈y anajty tɨ y'ögy, e chi tɨ yjugypɨcy. Tɨgooy yɨ' anajty e tɨ yjädy.” Chi ajcxy ooy yjotcugɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Chi je ymang mɨjpɨ camjoty je' anajty. Co yja'ty mɨhuingon je ytɨjc, chi mɨdoy co jäy ooy yxüxy etz y'ech. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chi yaaxɨ tüg ytumbɨ y'amɨdooy: “¿Ti yɨ' túnɨp jájtɨp?” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chi je tumbɨ y'adzooy: “Tɨ yjädy m'uch, tɨ mdeedy yaj'ögy tüg huaj nïcxpɨ, co ymang tɨ huimbity juugy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chi je unggoob ooy yjotmäty, ca' anajty ytɨgɨ̈hua'ñ tɨgoty. Huin'it je yteedy ñibɨdzɨmɨ, ycohuanɨɨyɨ co huen tɨgɨ̈y tɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chi je' y'adzooy, nɨmay yteedy: “Janch mɨcanaag jɨmɨjt ɨɨch miich mɨɨd nduñ, ni ca' ngapxhuimbityɨch. Ca' chambaad miich ni xycamooyɨch tüg pi'ccöbixy jaydëb njotcujc'adɨpyɨch nxɨɨdunɨpyɨch mɨɨd nmɨgügtɨjcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Per co yɨ mmang tɨ yjädy huɨdi oy tɨ yajtundäy yɨ ymeeñ mɨɨd jɨbɨc-huinma'ñ mɨɨd jɨbɨc töxyjäydɨjc ajcxy, chi tɨ myaj'ögy huaj mang nïcxpɨ mɨɨd yɨ' ycɨxpɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chi je ungdeedy nɨmay je' ymang: “Miich ung huinɨxɨɨ ya mɨɨd n'ity. Tüg'ócɨy huɨdi nmɨɨdɨch miich yɨ' mje'. ");
INSERT INTO mcoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ooy ycopɨ́cyɨty co nxɨɨduunɨm etz njotcugɨɨyɨm, co yɨ m'uch jadu'n anajty nej tɨ y'ögnɨ, e jadachambɨ tɨ yjugypɨcy, tɨ anajty ytɨgoy, e cham tɨ yajpaady.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nañ jadu'n Jesús nɨmay yɨ' ydiscípulos: ―Jɨm anajty tügjäy comeeñybɨ, ymɨɨd tüg ytumbɨ huɨdi yɨ' ypɨdägy cuend'ájtɨp. Chi oy nɨmäyii co tüg je ytumbɨ nɨgoo anajty tzachyajtuñ je meeñ ma ycapaadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chi je huindzɨn oy yajhuoyii je' ytumbɨ, chi nɨmay: “¿Nej jada co ɨɨch jadu'n nɨmäyiijɨch mɨɨd miich ycɨxpɨ? Ya yɨ cuentɨ cɨ̈moydaaygɨch nej tɨ mduñ, etz ca' ɨɨch miich n'ocjactumbɨ'adaanɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chi je pɨdägy cuend'ajtpɨ jot'ajtɨ: “¿Ti ndunɨpɨch? co yɨ' nhuindzɨn xyajpɨdzɨma'ñɨch ma yɨ ytung. Juttajɨɨ ca' njatyɨch, co limosna nbɨjctzohuɨpyɨch tzöydúmbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nejhuɨɨybɨch ti ndunɨpɨch jaydëb jäy ajcxy xycöbɨgɨpyɨch ma ajcxy ytɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chi tüg tüg huoy pɨn anajty mɨnuucx'ajtp je' yhuindzɨn; chi y'amɨdooy je jayɨjpɨ: “¿Jadu'ñyɨ miich mɨnuucxy'adyii ɨɨch nhuindzɨn?” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chi je' y'adzooy: “Mɨgo'px garafón aceite.” Chi nɨmay: “Matz mnecy, ɨña' mɨc'amy, e cojayɨ' huixchiguïpxmajc.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chi jadüg nɨmay: “¿Miich jadu'ñɨ mmɨnuucxy'adyii?” Chi je' y'adzooy: “Mɨgo'px quipxɨ'ñ trigo.” Chi nɨmay: “Matz mnecy, cojayɨ' mɨda'px.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chi je pɨdägy huindzɨn capxpaaty je jɨbɨcjäybɨ huɨdi cuend'ajtp yɨ' ypɨdägy co oy yhuinma'ñybaady mɨj; co jadachambɨ naaxhuiñyjäy huɨdi ca' mɨbɨcy Dios, nïgɨ ajcxy ypëgyɨty mɨɨd yhuinma'ñ, ca'ydɨ yɨ jäy ajcxy huɨdi huinjɨhuɨɨyb Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ɨɨch miich ajcxy yam nɨmaayb mɨgüg'ájtɨgɨxy yɨ jäy ajcxy mɨɨd yɨ meeñ huɨdibɨ ca' ytɨmytiijyɨty, jɨgɨx co je meeñ anajty myajmayjajtcɨxy ji pɨn miich ajcxy xycöbɨgɨp ma jugy'ajttac huinɨxɨɨbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Je' jäy ajcxy huɨdibɨ yajxon cuydunam je ané'mɨn huɨdi hueenɨ, nañ ycuydunamy je ané'mɨn huɨdibɨ mɨjɨp. Je jäy ajcxy huɨdibɨ ca' cuydunaangɨxy je ané'mɨn huɨdi hueenɨ, nañ ca' cuydunaangɨxy je mɨjpɨ ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pen ca' mjajtcɨxy nej mgüend'ájtcɨxɨpy yɨ jugy'ájtɨn huɨdibɨ ya naaxhuiñ yajpatp, ¿pɨn miich ajcxy m'ocyajmɨhuɨ'mamy je jugy'ájtɨn je riqueza oybɨ janchypɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pen ca' mjájtcɨxy nej mgüend'ájtcɨxɨpy tɨɨbɨ mɨhuɨ́'mgɨxy huɨdi huingjäy yje'ajtpy, ¿pɨn miich ajcxy xymöhuɨp huɨdibɨ ajcxy yjë'ajtpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni tüg tumbɨ ca' jëbɨ ytuñ mɨɨd metz yhuindzɨn; com tüg je' ixtijɨpy etz jadüg mɨjnɨcxpedɨpy; o tüg huɨdi ycapxycöbɨgɨpy, etz jadüg ca'. Miich ajcxy ca' huaad mɨjpɨdägɨpy Dios etz nañ jadu'n mɨjpɨdägɨpy yɨ comeeñ'ájtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nañ jadu'n mɨdooy jada ayuc yɨ fariseojäy ajcxy, com ooy anajty ajcxy meeñ adzójccɨxy. Chi ajcxy ooy nɨxiicɨ yajxiicɨ Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chi Jesús ymɨnañ: ―Miich ajcxy fariseojäy jadu'n mnaybɨdáacɨgɨxy ma jäy ajcxy yhuinduu nejjɨhuɨ̈y ajcxy ooy m'oyjäyɨty. Dios ñejhuɨɨydaayb co miich ajcxy mɨɨd jɨbɨcpɨ ma mjot mhuinma'ñ. Tijaty huinma'ñ huɨdi jäy ya naaxhuiñ y'oy'ijxyp, Dios ca' yɨ' oy'ixy. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Chi Jesús yjacmɨnañ: ―Je taabɨ je Juan anajty yjiijɨty, jii'ajtp anajty Moisés ycötújcɨn etz je y'ayucnajtzcapxɨɨybɨ ajcxy y'ixpɨ́jcɨn. Huin'it tiempo etz ixtɨ jadachambɨ jadu'n yajnajtzcapxɨ̈y je Dios y'ané'mɨn, e mayjäy ooy ñaybɨdáacɨgɨxy co ytɨgɨ̈huaangɨxy ma Dios y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ca'chípɨty co je tzajp etz naaxhuiñybɨ ñajxtähuɨpy, pero je Dios ycuydundähuamy tüg'ócɨy jadu'n nej ñecy ymɨna'ñ. Ni tügɨ letra oy mabaad ymúdzɨty nɨcxy ycayajcuyduñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Chi Jesús yjacmɨnañ: ―Huenpɨnjäyɨty co ytöxyɨjc ixmach etz ypɨcy mɨɨd huingbɨ töxyjäy, ooy anajty mɨj pocy tuñ. Nañ huenpɨnjäyɨty huɨdibɨ pɨjcp mɨɨd je töxyjäy huɨdi ñäy tɨ y'ixmachyii, nañ mɨj anajty ypocytuñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Chi Jesús yjacmɨnañ: ―Ji anajty tüg jäy comeeñybɨ ñayxoxyii anajty janch ooy mɨɨd oyjatypɨ huit, etz janch oy ycay y'ügy jabom jabom. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nañ ji anajty tüg ayoobɨ jäy huɨdi limosna pɨjctzoob, hue' anajty yxɨɨ Lázaro. Lázaro jabom jabom anajty ycögnäy ma je comeeñyjäy ytɨjc'aguu, janch nïbuutzp anajty ooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro ooy anajty jani'ixy caya'ñ je cayduc tzütztuc huɨdibɨ cäb ma je comeeñyjäy ycaybejt. Oy uc anajty ymiiñ yhueyii je ñïbüdz. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chi jadu'n yjajtɨ co oy y'o'cnɨ je jäy huɨdi limosna pɨjctzoob, chi je ángeles ajcxy yajnɨcxy Lázaro ma je Abraham yajpaady. Chi je comeeñybɨ nañ jadu'n y'o'cnɨ, e oy yajnaaxtɨgɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chi je comeeñybɨ jiiby ca'oydactuuby tzaachypɨ anajty jɨhuɨ̈y, chi mɨj'ijxy jɨguëgy je Abraham etz je Lázaro. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chi je comeeñybɨ ycapxy janch mɨc, ymɨnañ: “Apteedy Abraham, ɨɨch pa'ayoog. Tun may'ajt quex Lázaro, huen yɨ' ycɨ̈huäx yajxoogy mɨɨd nɨɨ etz xyajtɨ́jtzɨbɨch ndootz, co ɨɨch ooy ayo'n nbaadyɨch ma jada mɨj jɨɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Chi Abraham y'adzooy: “Oc'ungɨch, ajɨhuɨ̈huɨɨ co tɨ mdzɨnäy tɨ mjugy'aty mɨɨd mhuit mmeeñ agujc jotcujc, e yɨ Lázaro ooy ayo'n paty. Jadachambɨ Lázaro yjotcujc'aty, etz miich jiiby mbatpy tzaachypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E jadügnax, ji tüg mɨj huoc ma ɨɨch ajcxy etz miich ajcxy. Pen ɨɨch jɨm'amy janaxam ma miich, ca' njadɨpyɨch, nañ jadu'n miich ajcxy ni pɨn ca' jadɨpy nej ñaxɨpy ma ɨɨch nyajpaadyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chi je comeeñybɨ jacnɨmay Abraham: “Apteedy Abraham, tun may'ajt quex yɨ Lázaro ma ɨɨch ndeedy ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Jɨm ma ɨɨch ndeedy ytɨjc jɨm mɨgoox mɨguëx nmɨ́ɨdɨdyɨch, huen nɨcxy yajmɨɨdmɨydaaccɨxy, ca'ydɨ je' ajcxy nañ jadu'n ya minɨpy ma jada ayoodac.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chi Abraham y'adzooy: “Yɨ' ajcxy ymɨɨd necy huɨdibɨ Moisés etz Dios y'ayucnajtzcapxɨɨybɨ ycojaay, huen cuydungɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chi je comeeñybɨ ymɨnañ: “Janch jadu'n apteedy Abraham. Pen nidüg yɨ ögpɨ ñɨcxy ma je' ajcxy, jothuimbidɨp yɨ ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chi Abraham ymɨnañ: “Pen ca' je' ajcxy mɨjpɨdägy Moisés y'ayuc je jécyɨp etz huɨdi ajcxy jecy'ajt Dios y'ayucnajtzcapxɨɨy, nañ ni ca' mɨbɨ́jccɨxɨpy pen nidüg ögpɨ yjugypɨcy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Chi Jesús nɨmay yɨ' ydiscípulos: ―Janch tɨy'ajt jadu'n co yminɨp jäy ajcxy huɨdi yajhuinma'ñydɨgoyɨp yɨ mayjäy ajcxy mɨɨd aanɨɨ. ¡Ay yɨ' ayoob ajcxy! pɨnjaty jäy ajcxy yajhuinma'ñydɨgoyaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nïgɨ y'óyɨty co ixyipy yajyo'cxodzɨ̈yii tüg tzaa janch mɨjpɨ, e chi yajcöjɨbijpnaxɨpy mejyjoty, ca'ydɨ co yajhuinma'ñydɨgoyɨpy jada jäy ajcxy huɨdibɨ ixpɨ́jcɨn hueenɨ mɨɨd ma Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Naygüend'ájtɨgɨx miich ajcxy co ca' mgapxtɨgóoygɨxɨpy. Co m'uch xymɨdundɨgooyɨpy, e chi mgapxhuíjɨp, e pen jothuimbijt, chi mbocymeecxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pen m'uch huixtujc'oc xymɨdundɨgooy tüg xɨɨbɨ, nañ huixtujc oc xyñimiiñ tüg xɨɨbɨ, e ymɨna'nɨpy: “Tɨ njothuimbityɨch”, huinmeecxɨpy miich yɨ', chi jada' miich huixtujc'oc mbocymeecxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chi je apóstoles ajcxy nɨmay je Huindzɨn Jesús: ―Yajyeeg ɨɨch ajcxy nmɨbɨ́jcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chi je Huindzɨn Jesús y'adzooy: ―Co ixyipy miich ajcxy mmɨbɨcy Dios jadu'n nej tüg pi'c mostaza pajc, e mnɨma' ixyipy jada paadzɨm quipy: “Nayyajpɨdɨ̈gɨɨ, nɨcx tɨna' mejyjoty, e xycapxymɨdohuɨp yɨ'.” ");
INSERT INTO mcoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pen ji miich ajcxy nidüg pɨn ymɨɨd tüg ytumbɨ huɨdi tumb ñaaxjɨdzitzɨɨ o yhuaj cuend'aty, co yja'ty ma mdɨjc, ¿nej jëbɨ nɨmay: “Tɨgɨ', ixtäg ma mesa etz adzu'at?” ");
INSERT INTO mcoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hue' janchtɨy mnɨmähuɨpy: “Yaj'oyɨ́ɨyɨgɨch n'adzuu'ɨ̈bɨ, co'amedɨ' mhuit, e xymooygɨch ngaayɨn n'uucɨn. E huin'it miich mgayɨpy m'ügɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Nej yajnaxɨpy je' Dioscojuyip mɨɨd co je' anajty tɨ tuñ huɨdibɨ yaj'ane'my? Ɨɨch mɨnamb co ca'. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nañ jadu'n miich ajcxy co tɨ mguydungɨxy tüg'ócɨy tɨɨbɨ Dios xyaj'ane'mgɨxy, chi mmɨnáangɨxɨpy: “Je' ɨɨch ajcxy je tumbɨ huɨdibɨ ca'p ycapxpaadyɨty, jëyɨ tɨ ndúngɨxɨch huɨdibɨ ɨɨch ajcxy huaad ndungɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nɨcxp jɨm Jerusalén anajty Jesús, chi ñaxɨy ma Samaria etz Galilea ñaymɨdzɨba'n'ájtɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Co anajty mɨhuingoñ tüg cajp, chi jɨjpcoyöyɨɨy majc jäy pützpa'mmɨɨdpɨ. Chi ajcxy yhuäcxɨjpy jɨguëgyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chi ajcxy mɨc ycapxcoody ymɨnaangɨxy: ―Huindzɨn Jesús, pa'ayoog ɨɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Co Jesús je' ajcxy ijxy, chi nɨmay ajcxy: ―Nɨcx nayguëxɨ̈cɨgɨx ma yɨ teedy ajcxy. Chi jadu'n yjajtɨ, co ajcxy ñɨcxy, chi tüyöyjoty oy chooccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nidügtɨ je' ajcxy co ñay'ijxɨ co tɨ anajty chögy, chi nihuimbijty Jesús, ooy Dios jäymech cömay janch cɨxyjot huinɨjot. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chi je' ycojxtɨnay'ahuɨɨy ma Jesús ytecymɨjc, chi pɨdacpy yhuiñyjɨjp naaxcɨ́xy yajnaxy Dioscojuyipy. Samaritanojäy je' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chi Jesús ymɨnañ: ―¿Nej ca' nimajc miich ajcxy huɨdi tɨ mdzooccɨxy? ¿Ma ajcxy je' janidaxtujcpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Nej ca' pɨn jac yhuimbijty miiñ jäymedza'ñ cömaya'ñ Dios, jëyɨ tügpajc tɨ yhuimbity jada samaritanojäy? ");
INSERT INTO mcoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chi Jesús nɨmay je jäy: ―Pɨdɨ̈g, nɨcxnɨ. Yɨ mmɨbɨ́jcɨn tɨ xyajtzögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chi je fariseojäy ajcxy y'amɨdooy Jesús mɨna anajty yɨ Dios ya miñ ya naaxhuiñ y'ane'ma'ñ. Chi Jesús y'adzooy: ―Je Dios y'ané'mɨn ca' je' yminɨpy jadu'n nej ti yaj'ixy o yajmɨdoy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni mgamɨnáangɨxɨpy co cha je' o jɨm'amy je'. Dios y'ané'mɨn ya je' cham ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chi Jesús nɨmay yɨ' ydiscípulos ajcxy: ―Miim je xɨɨ je tiempo ma miich ajcxy anajty ooy xyjamɨɨd'idáangɨxɨch tüg xɨɨ, e ca' ɨɨch miich ajcxy xy'ixɨpy, ɨɨch je jäy huɨdi tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chi jäy ajcxy ymɨná'nɨp: “Chaa'amy je', je Cristo”, o “Chɨm'amy je'.” Ca' miich ajcxy yɨ' mninɨ́cxcɨxɨpy, e ni mgabanɨ́cxcɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Co anajty nmiñɨch jadügtecy ya naaxhuiñ, ɨɨch, je jäy huɨdi tzoon tzajpjoty, co ɨɨch anajty nmɨmiñ n'ané'mɨn, jadu'n je' yjadɨpy nej huɨdzuc co y'aa'an ma tüg tzajp'ɨjx e nañ jadu'n y'aa'an jadüg tzajp'ɨjx. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nañ ooy ycopɨ́cyɨty co jayɨjp ocpáadɨbɨch ayo'n, e chi jada xyca'ixa'nɨbɨch xycatzoga'nɨbɨch yɨ jäy ajcxy huɨdi tzɨnaayb jugy'ajtp jadachambɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Com jadu'n nej yjajtɨ jecy'ajty, co je Noé chɨnaay, nañ jadu'n yjadɨpy co anajty ɨɨch, je jäy huɨdi tzoon tzajpjoty, co anajty nxɨɨ ndiempo paty mɨna anajty nmiñɨch ane'mbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Janch caayb janch uucp anajty je jäy ajcxy agujc jotcujc co je Noé ytɨgɨɨy ma ymɨjcajoon. Chi je ayo'nduu ymiñ huɨdi cɨjx yaj'ögtɨgoydäy je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nañ jadu'n yjajtɨ jecy'ajty co Lot chɨnaay. Je jäy ajcxy jɨm Sodoma etz Gomorra ycaaygɨxy y'uuccɨxy yjuuygɨxy ytooccɨxy, etz ytɨjccojcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Huin'it xɨɨ co Lot choonɨ jɨm Sodoma, chi ycäy tzajpjoty jɨɨn etz huɨdi jɨndzaa mɨɨd conhuɨdity ytoy, chi cajp ytɨgoyday. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jadu'n nej ayo'n yjajtɨ taabɨ chɨnaay Noé etz Lot ya naaxhuiñ, nañ jadu'n yjadɨɨyb ayo'n co anajty nmiiñɨch jadüg'oc ya naaxhuiñ, ɨɨch je jäy huɨdi tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Je huin'it xɨɨ huin'it tiempo pɨn anajty ɨñaayb ma ytɨjccop, e ymɨɨd anajty ypɨdägy jiiby tɨgoty, ca' nimɨnagɨpy nɨcxy ti yajpɨdzɨmy, e huɨdi jäy anajty jɨm camjoty nañ ni ca' yhuimbidɨpy ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ajɨhuɨɨygɨx jadu'n nej Lot ytöxyɨjc ayo'n paty. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tüg'ócɨy jäy ajcxy pɨnjaty yjugy'ajt tzögam, tɨgoyɨpy yjugy'ajt. Tüg'ócɨy jäy ajcxy pɨnjaty yjugy'ajt tɨgooyb (mɨɨd ɨɨch ycɨxpɨ), hue' je' yjugy'ajt ypaadɨpy chögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ɨɨch miich ajcxy nɨmaayb co je huin'it coodz nimetz jäy anajty ajcxy ma cɨjx, tüg yajnɨcxɨɨyb etz jadüg yajhuɨ'mɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nimetz töxyjäy anajty yjɨjtzcɨxy, tüg yajnɨcxɨɨyb, etz jadüg yajhuɨ'mɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nimetz yëydɨjc anajty ytungɨxy camjoty, tüg yajnɨcxɨɨyb etz jadüg yajhuɨ'mɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chi je jäy ajcxy huɨdi ixpɨjcp Jesús y'ayuc ymɨnañ ajcxy: ―¿Ma jadu'n yjadɨɨyb nej miich tɨ mɨna'ñ, Huindzɨn? Chi Jesús ymɨnañ: ―Ma anajty je ögpɨ yajpaady, jɨm yɨ luud ajcxy ñïmuga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chi Jesús yajnɨmay ajcxy tüg ayuc huɨdijaty ixpɨjcp ma yɨ' co ooy ycopɨ́cyɨty Dios nmɨbɨjctzoohuɨm jabom jabom, ni ca' nmɨdzijpɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Chi Jesús ymɨnañ: ―Ji anajty tüg juez ma tüg cajp, ni Dios anajty ca' tzɨgɨ̈y, etz ni jäy ajcxy anajty ca' huindzɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nañ ma je cajp jɨm anajty tüg co'ögy ytöxyjäy. Je' anajty yminög janam jadzojc ma je juez, nɨmäy anajty: “Nihuaangɨch ma je nmɨdzipɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Chi je codung ca' co'adzoy ca' a'ɨxɨy tzojc. Chi je juez jot'ajtɨ, ymɨnañ jotjoty huinma'ñyjoty: “Oy Dios ca' ndzɨgɨ̈yɨch, ni jäy ca' nhuindzɨgɨ̈yɨch, per com jada co'ögytöxyjäy nïgɨ xychach'amayɨ̈yɨch, miñ n'ocnihua'ñɨch, ca'ydɨ jadüg'oc ymiñ e xyajcɨjxɨch anajty nmecxtújcɨn.” ");
INSERT INTO mcoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chi je Huindzɨn Jesús ymɨnañ: ―Mɨdo'mbɨc miich ajcxy nej je juez jɨbɨcjäybɨ tɨ nihuañ je töxyjäy co anajty tɨ yajtzibyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nej ca' Dios ñihuaanɨp yɨ huɨdibɨ tɨ huin'ixy, huɨdibɨ mɨbɨjctzoob xɨɨm tzuum? ¿Huäcxɨbɨp, nɨcx ca' tzojc adzooyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ɨɨch miich ajcxy nɨmaayb co Dios ñihuänamy mɨc'amy yɨ' yjäy. Co anajty nhuimbity ya naaxhuiñ, ɨɨch, je jäy huɨdi tzoon tzajpjoty, ¿nej nbáadɨbɨch mɨbɨ́jcɨn ya naaxhuiñ? ");
INSERT INTO mcoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús ñimɨydac je jäy ajcxy huɨdi cɨ'm ooy ñaygömayyii co ooy y'oyjäyɨty, etz pejxy yɨ jacjadyiibɨ jäy ajcxy, chi yajnɨmay ajcxy tüg jɨhuimbit ayuc: ");
INSERT INTO mcoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Mejtz jäy ajcxy ytɨgɨɨy ma Dios ytɨjc capxtacpɨ. Tüg hue' je' fariseojäy, e jadüg yajcogüejtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chi je fariseojäy ytɨnay'ahuɨɨy ycapxtägy, chachmɨna'ñ jadu'n: “Dios Teedy, Dioscojuyip yajnajxpɨch com co ca' ɨɨch nbocytuñɨch jadu'n nej jacjadyii jäy ypocytúnngɨxy, ca' nmeechɨch, ca' njɨbɨcjäyɨdyɨch, ca' nmɨgapxɨch huingjäy ytöxyɨjc, ca' nbocytuñɨch jadu'n nej jada yajcogüejtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mejtz xɨɨ n'ityɨch jaygay tügpɨ semaan. Chi huen ytɨm ti nmɨɨdɨch ngüejtpyɨch ma Dios majcjaty.” ");
INSERT INTO mcoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per je yajcogüejtpɨ jɨguem ytɨnay'ahuɨɨy, ni ycapät'ixy tzajpcɨjx, jëyɨ ycaachtzachcoxy ymɨna'ñ: “Dios Teedy, pa'ayoogɨch, ɨɨch pocyjäyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ɨɨch miich ajcxy nɨmaayb co jada yajcogüejtpɨ y'idacy ma ytɨjc tɨ anajty yajhuinmecxy ypocy, e je fariseojäy ca' yajpocyhuinmecxy. Huenpɨ́nɨty huɨdi cɨ'm naygömayɨpy, Dios yajtzöydunɨɨb; e pɨnjaty ca' ñaygömayyii cɨ'm, Dios ycömayɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chi jäy ajcxy mɨɨdmiñ pi'c'anäg ma Jesús huen nïdoñyii. Co je' ydiscípulos ajcxy ijxy, chi ajcxy ojy ungdaj. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chi Jesús yaaxɨ ymɨgügtɨjc nɨmay ajcxy: ―Ixmatz, huen yɨ pi'ctɨjc xyñimiñɨch, ca' ajcxy mjɨjpcogapxɨɨygɨxy, com yɨ jäy ajcxy huɨdibɨ yajpatp ma Dios y'ané'mɨn, jadu'n ajcxy nipaady nej pi'ctɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Janch ɨɨch miich ajcxy nɨmäy co hueñypɨ́nɨty huɨdi ca' cöbɨjcɨ yɨ Dios y'ayuc ytɨy'ajt jadu'n nej yɨ pi'ctɨjc ajcxy cöbɨjcy Dios y'ayuc ytɨy'ajt, ca' yɨ' ajcxy ytɨgɨ̈huɨpy ma Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chi tüg mɨcjäy y'amɨdooy Jesús, nɨmay: ―Miich oyjäybɨ Huindzɨn, ¿ti huaad nduñɨch co ɨɨch n'alma nïdzoocɨn paadɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chi Jesús y'adzooy: ―¿Nej co xytíjɨch oyjäy? Ni pɨn ya yca'oyjäyɨty, je'yɨ Dios tügpajc y'oyjäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Miich mnejhuɨɨyb yɨ Dios ycötújcɨn. Ca' mmɨgapxtɨgoyɨpy huingbɨ töxyjäy, ca' jäyyaj'ögɨpy, ca' mmeedzɨp, ca' mmɨgüg nïhuambedɨpy, yajmɨj'at mdaj mdeedy. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chi je' y'adzooy: ―Tɨ tüg'öcɨy nguydundäyɨch jada cötújcɨn maabɨ nyeecpɨdzɨmyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Co Jesús jadu'n mɨdooy, chi nɨmay: ―Tɨgoy'ijtnɨ ja tüg huɨdi ca' mduñɨ. Toocta' tüg'ócɨy tijaty miich mɨɨd, e mo' je meeñ ayoobtɨjc, huin'it mgomeeñ'adɨpy jiiby tzajpjoty; miin, e pajamgɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Co je comeeñybɨ jadu'n ayuc mɨdoy, chi ooy yjottɨgoygoty com ooy anajty ycomeeñɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Co Jesús ijxy co je comeeñybɨ anajty tɨ yjotmaybɨcy, chi mɨnañ: ―Ooy chachchípɨty ytɨgɨ̈huɨpy tüg comeeñyjäy ma Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jac ca' chípɨty co ñaxɨpy tüg camello ma yɨ xu'ñ yxútɨty, ca'ydɨ co tüg comeeñyjäy ytɨgɨ̈huɨpy ma Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chi je jäy ajcxy anajty tɨɨbɨ ajcxy mɨdoogɨxy Jesús y'ayuc, ymɨnaangɨxy: ―¿Pɨn jada' jëbɨ y'alma paadɨpy nïdzoocɨn? ");
INSERT INTO mcoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chi Jesús y'adzooy: ―Huɨdibɨ naaxhuiñyjäy ajcxy ca' jaty nej yaj'oyɨ̈huɨpy, Dios jëbɨ yaj'oyɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chi Pedro ymɨnañ: ―Ɨɨch ajcxy tɨ nbɨdägy n'ixmajtztaaygɨxy, co nbanɨcxaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Chi Jesús y'adzooy: ―Janch ɨɨch miich ajcxy nnɨmaaygɨxy co yɨ jäy ajcxy huɨdi ytɨjc ixmajtz etz ytaj yteedy, ymɨguëx, etz y'ung y'anäg mɨɨd Dios y'ané'mɨn ycɨxpɨ, ypáadɨpy ajcxy ya naaxhuiñ nïgɨ oy'ájtɨn, etz ypaadɨpy ajcxy tzajpjoty tzɨnaayɨn huɨdi ca' ycɨxɨpy ytɨgoyɨpy nimɨna. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chi Jesús huodzon je nimajmetzpɨ, nɨmay ajcxy: ―Jadachambɨ tzoc jámɨm jɨm Jerusalén. Nguydunaamyɨch tüg'ócɨy jadu'n nej yɨ Dios y'ayucnajtzcapxɨɨybɨ ajcxy jaybejty jecy'ajty mɨɨd ɨɨch ycɨxpɨ, ɨɨch, je jäy huɨdi tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi nyajcɨ̈yega'ñɨch ma je romano gobernador, xycamɨj'ixɨpy xycamɨjpɨdägɨbɨch ajcxy. Xy'ójɨbɨch xyhuindzújɨbɨch xyjɨjptzújɨbɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xychaachytunɨpyɨch ajcxy, xyaj'ögɨbɨch ajcxy, e codugɨɨg xɨɨ njugypɨgɨpyɨch jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chi yɨ majmetzpɨ ajcxy ni jadu'ñyɨ ca' huinjɨhuɨɨy ajcxy nej yhuimbɨdzɨmy Jesús y'ayuc. Yüch anajty jada ayuc mɨɨd yɨ' ajcxy ycɨxpɨ, paady ca' huinjɨhuɨɨy nej anajty yajnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chi jadu'n yjajtɨ co Jesús mɨhuingoñ je cajp huɨdi yxɨɨ Jericó, chi tüg huintzpɨ anajty ɨñäy tüba'áy pɨjctzoy anajty limosna. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Co mɨdooy mayjäy ñaxy, chi je' yajtɨy: ―¿Pɨn yɨ' ñajxp? ");
INSERT INTO mcoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chi ajcxy nɨmay co Jesús nazareno najxp. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Huin'it je huintzpɨ mɨc ymɨnañ: ―Jesús, David y'ap y'oc, ɨɨch pa'ayoog. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Je jäy ajcxy huɨdi anajty jayɨjp nɨcxp ooy ojy je huintzpɨ, nɨmay co huen amoñ. E je' nïgɨ mɨc ymɨnan'ɨdɨ̈ch: ―David y'ap y'oc, ɨɨch pa'ayoog. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chi Jesús ytɨnayxɨjpy oy yajhuoyii. Co je' jɨm ymejch, chi amɨdoy, nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ti mdzojcpy ndunɨpyɨch mɨɨd miich? Chi je' y'adzooy: ―Huindzɨn, yajhuindɨcxɨ̈ccɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chi Jesús mɨnañ: ―Huindɨcxɨ̈g, yɨ mmɨbɨ́jcɨn tɨ xyajtzögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chi je huintzpɨ mɨc'amy yhuin y'ijxɨ̈gy, chi panɨcxy Jesús, chi ooy jäymejch cömay yɨ Dios. Cham tüg'ócɨy je cajp jäy co ajcxy jadu'n ijxy, nañ ycömay yjäymejtz yɨ ajcxy Dios. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Co Jesús ytɨgɨɨy jɨm Jericó, ñajxy cajpcujc anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chi jadu'n yjajty jɨm anajty tüg jäy hue' anajty yxɨɨ Zaqueo. Hue' je' anajty yajcogüejtpɨ huindzɨn, e comeeñ anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ooy yɨ' anajty tzach'ixa'ñ Jesús, nejhuɨ̈hua'ñ pɨn jäy je', chi ca' jajty nej ixɨpy, je' co anajty ñaxɨty, etz co anajty ooy mayjäy jɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chi je' ñɨcxy poyɨ̈gy jayɨjp, chi ypejty ma tüg sicómoro quipy, yco'ijxnaxa'ñ co anajty Jesús jɨm ñaxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Co Jesús jɨm ymejch, chi pät'ijxy je Zaqueo, e nɨmay: ―Zaqueo, tzojc mɨnac, com copɨcy co nɨcxy njättäga'ñɨch ma mdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chi je' ymɨnajty janch jottɨgoy, e jotcujc cöbɨjcy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Co jadu'n ijxy, chi je mayjäy ajcxy nigapxy ni'ojɨɨygɨxy Jesús, ymɨnaangɨxy: ―Tɨ ñɨcxy jättacpɨ ma tüg pocyjäy ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chi Zaqueo ytɨnayɨ̈gy, nɨmay Jesús: ―Huindzɨn Jesús, cha je' je njugy'ajtɨch huɨdi cup nbɨjc-huäcxaamyɨch nmöhua'ñɨch ayoobɨtɨjc. Pen tɨ ɨɨch nyajcuejtnaxy, nyajhuimbidɨpyɨch mɨdaax jadu'ñyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chi Jesús ymɨnañ: ―Jadachambɨ jada jäy ma jadayaabɨ tɨjc tɨ y'alma ñïdzögy, com co yɨ' nañ jadu'n Abraham y'ap'adyii y'oc'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ɨɨch, je jäy huɨdi tzoon tzajpjoty, tɨ nmiiñɨch ya naaxhuiñ co n'ixtähuɨbɨch etz nyajnïdzögɨbɨch tɨɨbɨ anajty ytɨgooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Co je jäy ajcxy mɨdooy jadu'n, chi Jesús jacyajnɨmay ajcxy tüg ayuc, com ytɨmymɨhuingónɨp anajty Jerusalén, etz je jäy ajcxy tzachhuinmaaygɨxy co Jesús mɨc'amy anajty pɨdäga'ñ y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Chi Jesús ymɨnañ: ―Tüg mɨcjäy, comeeñyjäy anajty, ñɨcxy ma tüg naaxjot jɨguembɨ, nɨcxy anajty ytungbɨcy co yrey'ada'ñ, e chi anajty yhuimbidaanɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chi je mɨcjäy mɨjhuooy nimajc ytumbɨ, chi moy ajcxy majc meeñ nidüg nidüg, chi ajcxy nɨmay: “Meeñ yaj'ung'ájtcɨx ji ixtɨ coonɨ ɨɨch anajty nhuimbityɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Chi je ymɨgogajp ajcxy ca' anajty ixa'ñyii ajcxy je comeeñybɨ, chi ajcxy yajpaguejxy huingapxpɨ ma anajty je comeeñybɨ ñɨcxy, chi je huingapxpɨ ymɨnañ: “Ca' ɨɨch ajcxy ndzocy co jada comeeñyjäy rey'adɨpy ma ɨɨch ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Chi jadu'n yjajty co je comeeñyjäy yhuimbijty tɨ anajty yreytɨgɨ̈y. Chi oy yajhuoyii je ytumbɨ ajcxy, je huɨdi anajty je meeñ tɨ yajmɨhuɨ'mgɨxy, nejhuɨ̈hua'ñ anajty jadu'ñɨ tɨ yaj'ung'ajtcɨxy je meeñ nidüg nidüg. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chi tüg jayɨjp ymiñ ymɨnañ: “Huindzɨn, yɨ meeñ majcjadu'ñɨ tɨ nyaj'ung'atyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chi je rey y'adzooy: “Ooy miich oy mduñ. Jadu'n nej tɨ mgapxycöbɨcy mɨɨd huɨdi hueenɨ, cham m'ané'mɨpy majc ciudad.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chi je mɨmetzpɨ ymiiñ, ymɨnañ: “Huindzɨn, yɨ mmeeñ mɨgoox jadu'ñyɨ tɨ nyaj'ung'atyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chi je rey nɨmay je mɨmetzpɨ: “Cham m'ane'mɨpy mɨgoox ciudad.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Chi je mɨdugɨɨgpɨ ymiñ, ymɨnañ: “Huindzɨn, cha je mmeeñ huɨdi tɨ nmɨ'ityɨch, tɨ nyujcpɨcyɨch ma tüg paayɨ. Ndzɨgɨɨybɨch miich co miich mjäy'aty ahua'ñ, myajpɨdɨ̈gtäy huɨdi ca' mjë'adyii, nañ mdzijcpy huɨdi ca' tɨ mnïpy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chi je rey ymɨnañ: “Miich jɨbɨc tɨ mduñ, cham ndɨyduna'ñ mɨɨd mgɨ'm'ayuc ycɨxpɨ. Miich mnejhuɨyb co nyajpɨdɨ̈gyɨch huɨdi ca' një'adyiijɨch, e ndzicyɨch huɨdi ca' tɨ nnïbyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Nej co ca' tɨ mbɨdägy ɨɨch nmeeñ ma je banco, jɨgɨx co ixyipy nhuimbityɨch, may meeñ ixyipy xycɨ̈dɨgɨ̈yɨch mɨɨd meeñ'ung?” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chi je rey nɨmay huɨdi anajty ajcxy jɨ́mɨp: “Pɨjcɨ ajcxy yɨ' ymeeñ, etz mooygɨxy yɨ' tɨɨbɨ meeñ yaj'ung'aty majc jadu'ñyɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chi je jäy ajcxy y'adzooy: “Huindzɨn, ymɨɨd yɨ' cham majc jadu'ñyɨ meeñ.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chi je rey y'adzooy: “Ɨɨch mɨnaam co tüg'ócɨy pɨnjaty mɨɨd, jacyajmöhuɨp; e huɨdi ca' ti mɨɨdɨty, oy jamɨɨdɨty yajpɨjctähuɨp huɨdi ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nañ jadu'n ajcxy je nmɨdzipɨch huɨdi ca' anajty tzojccɨxy co ɨɨch nrey'adɨpyɨch ma yɨ' ajcxy, yajmiingɨx ya, yo'cpujxtutaaygɨx ma ɨɨch nhuinduu.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Co Jesús jadu'n ymɨnanday, chi choñ jɨm, ñɨcxy Jerusalén. Jesús jayɨjp anajty ytüyöy ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Jadu'n yjajty co jɨm yja'ty mɨhuingon Betfagé etz Betania ma je cop huɨdi yxɨɨ Olivos, chi Jesús quejxy metz ydiscípulos, nɨmay ajcxy: ―Nɨ́cxcɨx ma yɨjiibɨ cajp huɨdi ji huingon. Co ajcxy mgajptugɨ̈huɨp mbáatcɨxɨpy tüg burro mang ycoxochɨty, huɨdi ca' ni pɨn yaj'ɨñaayñɨ. Mgoguejtúutcɨxɨpy, etz mmɨmíingɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pen jɨm pɨn xy'amɨdoogɨxy, ¿nej co yɨ burro mgoguejtüdy? Chi ajcxy jadu'n m'adzohuɨpy: “Je nhuindzɨnɨch jɨm tzojcp.” ");
INSERT INTO mcoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chi je' ajcxy ñɨcxy huɨdi Jesús yquejx. Chi ajcxy paty je burro jadu'n nej Jesús anajty ajcxy tɨ ñɨmäyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jɨm anajty ajcxy je burro mang coguejtuutcɨxy, co ñihuindzɨn ñɨmaayɨ ajcxy: ―¿Nej co yɨ burro mang mgoguejtuutcɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chi je' ajcxy y'adzooy: ―Je nhuindzɨnɨch jɨm tzojcp. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chi ajcxy huijtz miñ je burro ma Jesús. Chi ajcxy jɨbe'ñ mɨɨd yhuit, chi ajcxy Jesús yajburrɨpejty. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Co Jesús anajty ytüyöy, chi je mayjäy ajcxy yhuit yé'pcɨxy tügujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Co ajcxy mɨhuingoñ je mɨnac ma je cop huɨdi yxɨɨ Olivos, chi tüg'ócɨy je mayjäy yjotcugɨyday, e ytɨgɨɨy ajcxy ooy alabanza ɨɨbɨ Dios ojadajtpɨ mɨɨd je mɨj huinma'ñ ycɨxpɨ co anajty tɨ íjxcɨxy huɨdi anajty Jesús tɨ tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Chachmɨnaangɨxy: ―¡Capxpaady je rey huɨdi miimb mɨɨd Huindzɨn Dios yxɨɨ ycɨxpɨ! ¡Jotcujc'ajt jiiby tzajpjoty etz cömáyɨn ma Dios! ");
INSERT INTO mcoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Huin'it nijëjɨty fariseojäy huɨdi anajty ajcxy jiiby jäy agujc nɨmay ajcxy je Jesús: ―Oj yɨ mjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chi Jesús y'adzooy: ―Ɨɨch miich ajcxy nɨmaayb pen yɨ' ajcxy amomb, yɨ tzaa tɨgɨ̈huɨp mɨc capxp. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Co Jesús yja'ty jɨm mɨhuingon Jerusalén cajp, e co ijxy, chi yaaxy mɨɨd je cajpjäy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Chi Jesús ymɨnañ: ―¡Pen mhuinjɨhuɨɨyb ixyipy miich ajcxy nej mbáatcɨxɨpy mjotcujc'ájtɨn jadachambɨ xɨɨ tiempo! Yüch jada tɨy'ajt cham ity ma miich ajcxy, ca' huaad m'íjxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Minɨp je xɨɨ je tiempo ma miich ajcxy je mmɨdzip ajcxy xyajjüdugɨpy mgajp mɨɨd tzaamacxy, e tziptunɨpy ajcxy mɨɨd miich, yajxon xyajco'adugɨpy ajcxy jühuɨdity ma je mgajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Xyñigɨdaagoodɨp mdzaaboch ni'ung ni'anäg, ni ca' yhuɨ́'mɨp tzaagop tzaamacxy, jadu'n yjadɨpy com miich ajcxy ca' mnejhuɨ̈y je tiempo mɨna je Dios xyñigɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chi Jesús ytɨgɨɨy ma Dios ytɨjc yajpɨdzɨmday tüg'ócɨy jäy huɨdi anajty jiiby ajuuyb adoocp. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Chi Jesús nɨmay je jäy ajcxy: ―Jadu'n mɨna'ñ ma jaybétyɨty: “Ɨɨch ndɨjcɨ tzajpcapxycapxtägɨ'ñ yɨ'.” E miich ajcxy hue' mhuaangɨxy jadu'n nej meetzpɨ y'ang. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús anajty yaj'ixpɨjc jabom jabom ma Dios ytɨjc, chi je teedy tungmɨɨdpɨ, etz huɨdi ajcxy yaj'ixpɨjcp anajty Dios ñecy, etz mɨjjäydɨjc ajcxy nihuinmayɨɨygɨxy co yaj'ögaangɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Chi ajcxy ca' ni nej mɨhuinma'ñybaty nej yaj'öccɨxy, com tüg'ócɨy jäy anajty ooy tzach'amɨdoo'ijt Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Chi jadu'n yjajty tüg xɨɨ anajty Jesús yaj'ixpɨcy je cajpjäy ma Dios ytɨjc, capxhuäcxy anajty oybɨ ayuc. Chi ñimiinɨ je teedy tungmɨɨdpɨ ajcxy etz huɨdi ajcxy yaj'ixpɨjc Dios ñecy etz mɨjjäydɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Chi ajcxy mɨgapxy Jesús nɨmay: ―Yajnɨmaaygɨch, ¿ma cötújcɨn tɨ mbaady co jäy myaj'ixpɨcy ya ma Dios ytɨjc? ¿Pɨn je' tɨɨbɨ xycötujc möy? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chi Jesús y'adzooy: ―Ɨɨch nañ jadu'n nyaj'amɨdohuamy ɨɨch miich ajcxy tüg ayuc, e m'adzóogɨxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Co Juan (je Bautista) jäy yajnɨɨbejty, ¿pɨn je' cötújcɨn moy, je Dios tzajpjotypɨ o jäy ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chi ajcxy ytɨgɨɨy huinmay'ahuɨdijtpɨ ñayñɨmáayɨgɨxy miñ xyɨpy: ―Pen mɨnaanɨm co tzajpjoty choñ je Juan ycötújcɨn, Jesús xyñɨmaayɨmɨp ya: “¿Nej co ca' miich ajcxy mɨjpɨdacy yɨ' y'ayuc?” ");
INSERT INTO mcoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pen mɨnaanɨm ajt co jäy cötújcɨn moy je Juan, chi tüg'ócɨy cajpjäy tzojc xycögädzɨm, com ymɨbɨjcpy ajcxy co yɨ Juan, Dios yɨ' y'ayucnajtzcapxɨɨybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chi ajcxy y'adzooy co ca' ajcxy nejhuɨɨygɨxy pɨn Juan tɨ quexyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chi Jesús nɨmay je' ajcxy: ―Ɨɨch nañ jadu'n ca' nigapxa'ñɨch pɨn tɨ xycötujcmöyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chi Jesús ymɨnandacy yajnɨmay tüg'ócɨy je jäy ajcxy tüg ayuc, ymɨnañ: ―Tüg jäy pɨdacy tüg camuuxy ycam, chi yajpɨjctzoy ytumbɨdɨjc, co anajty chona'ñ ñɨcxa'ñ jɨguem jecy jecy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Co cosecha paty, chi quejxy tüg ytumbɨ ma je ytumbɨdɨjc, huen cɨ̈möyii huɨdibɨ je' anajty paatɨp. Chi je ytumbɨdɨjc huinhuojpy jɨjphuojpy je quejxyöybɨ yajhuimbijty ca' ni ti mooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chi huingbɨ ytumbɨ quejxy, nañ jadu'n ajcxy je' tuñ, huin'ojy jɨjp'ojy ajcxy, yajhuimbijty ajcxy, ca' ajcxy ni ti mooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chi mɨdugɨɨgpɨ ytumbɨ quejxy, nañ jadu'n ajcxy je' yajtzaachɨɨy etz yajhuimbijty ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Huin'it je camuuxycam huindzɨn ymɨnañ: “¿Ti ndunɨpyɨch? Ocquejxyɨch nmang huɨdibɨ ooy ndzocyɨch. Ca' jécyɨty co ajcxy ixɨpy nmangɨch, yajmɨj'adɨpy ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chi je ytumbɨdɨjc co ajcxy ijxy je' yhuindzɨn ymang, chi ajcxy huinmaygoty nayñɨmáayɨgɨxy miñ xyɨpy: “Tɨ ymiñ je cogam ymang, yɨ' je' jada cam jëdaanɨp. Tzoc yaj'o'cɨm jɨgɨx ɨɨch ajt jada cam një'ajtɨm.” ");
INSERT INTO mcoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chi ajcxy je cogam ymang yajpɨdzɨmɨ camjoty, chi ajcxy yaj'o'cy. Chi Jesús y'amɨdooy: ―¿Ti jada' ytunɨpy je cam huindzɨn? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Minɨp je', miñ yajtɨgoydäy je ytumbɨdɨjc ajcxy, e chi je' je ycam yegɨpy mɨɨd huingbɨ tumbɨ. Co je jäy ajcxy jadu'n mɨdoy, chi ajcxy ymɨnañ: ―Ni catzogɨpy Dios, nɨcxy jadu'n njajtɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chi Jesús huindɨcxpejty je mayjäy nɨmay ajcxy: ―¿Ti tijamy huɨdi yjaybétyɨp ma Dios ñecy? Jadu'n: Je yëydɨjc huɨdi je jäy ajcxy ca' anajty tzocy, tɨ Dios pɨdacy mɨj'ane'mbɨ. Tɨm jadu'n nipaady nejɨhuɨ̈y je tzaa oyjatypɨ huɨdibɨ je pojtzpɨdɨjc ajcxy ca' yajtuna'ñ, je' oy tɨ yhuɨ'mnɨ ma anajty yjaccopɨ́cyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pɨnjaty ca' cöbɨga'ñ jada mɨj'ane'mbɨ, ayo'n ypadamy, tɨm jadu'n nipaady nej jɨhuɨ̈y jɨm ycɨjxcɨday ma je tzaa nïcx e tɨjhuïtz yjajtähuɨpy; e pen je tzaa nïgɨdagoty, je' ajcxy janch jaam püx nɨcxy yjajtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Je teedy tungmɨɨdpɨ etz huɨdi ajcxy yaj'ixpɨjc Dios ñecy ooy anajty nihuinmayɨɨygɨxy madzaangɨxy je Jesús mɨc'amy, co ajcxy huinjɨhuɨy co Jesús nimɨydáacɨgɨxy mɨɨd je jɨhuimbit ayuc, e chɨgɨɨyb anajty ajcxy je cajp jäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chi ajcxy chachhuinma'ñ'ixtaaygɨxy nej huaad xɨ̈gɨxy Jesús, chi quejxy ajcxy ijx'ijtpɨ ma Jesús yajpaady huɨdi naybɨdaacɨp janch ypaat tudägyjäy; chi amɨdoo'íjtcɨxy Jesús y'ayuc huɨdi mɨɨd xɨ̈huaangɨxy, chi cɨ̈yegaangɨxy ma je gobernador. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chi je ijx'ijtpɨ ajcxy y'amɨdooy Jesús nɨmay ajcxy: ―Huindzɨn, nejhuɨɨyb ɨɨch ajcxy co miich m'ayuc ooy y'óyɨty, etz myaj'ixpɨcy yajxon, ca' huin'ixpety jäy myaj'ixpɨcy, etz myaj'ixpɨcy Dios ytɨy'ajt nej jäy jëbɨ huaad chɨnaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Nej copɨcy ɨɨch ajcxy mɨgüedɨpy je César je romanojäy mɨj'ane'mbɨ, o ca'ɨjɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Chi Jesús huinjɨhuɨɨy yɨ' ajcxy yjɨbɨc-huinma'ñ, paady ajcxy nɨmay: ―¿Ti co miich ajcxy xyjot'ixy xyhuinma'ñ'íxyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Yaj'ijxcɨch tüg meeñ. ¿Pɨn y'ahuɨnax etz pɨn yxɨɨ mimb ma jada meeñ? Chi ajcxy y'adzooy: ―Yɨ César. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chi Jesús nɨmay ajcxy: ―Cuet ma César huɨdi César paatɨp, e ma Dios huɨdi Dios paatɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ca' mɨmadacy ajcxy nej tzu'íjxcɨxy ma mayjäy yhuinduu. Chi ajcxy ooy huinmaay jadu'n nej anajty Jesús tɨ y'adzóohuɨgɨxy, chi ajcxy amoñyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chi ñija'ttɨ Jesús tüg saduceojäy, e yɨ saduceojäy ajcxy ymɨnañ co jäy ögy ca' y'ocjuyujcnɨ. Chi je' yajtɨy: ");
INSERT INTO mcoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Huindzɨn, Moisés jaybety ma yɨ' ñecy, je jécyɨp, co tüg yëydɨjc ytöxyɨjc yajhuɨ'my ix'ögp, e ca' ymang tɨ paatcɨxy. Jëbɨ je yëydɨjc y'uch mɨɨdtzɨnäy je töxyjäy jaydëbɨ yaj'ung'ixɨp mɨɨd y'ajch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jadu'n anajty tügpɨcy jäy, nihuixtujc ajcxy ytügquëx'ájtcɨxy, ac yëydɨjc ajcxy. Je mɨjpɨ mɨɨdtzɨnay töxyjäy, chi ix'o'cy, e ca' ymang paty. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chi je mɨmetzpɨ ypɨjcy mɨɨd je töxyjäy, e ni ca' ajcxy ung paty. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chi je mɨdugɨɨgpɨ ypɨjcy mɨɨd je töxyjäy, e jadu'n je nihuixtujcpɨ mɨɨdtzɨnay ajcxy je töxyjäy, ix'o'cy ajcxy, ni ca' ajcxy ung paty. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chi nañ jadu'n je töxyjäy y'ögnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Co anajty je nihuixtujcpɨ jugypɨjccɨxy, ¿huɨdi jada' octöxɨjc'adɨɨyb je töxyjäy? Com nihuixtujc ajcxy tɨ töxyɨjc'ájtɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chi Jesús y'adzooy: ―Jadachambɨ jäy pɨ́jccɨxp, ñaymooyɨgɨxy y'ung huen pɨ́jccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Je jäy ajcxy huɨdibɨ paatɨp anajty chɨnähuɨp ma je tiempo huɨdi mimb co ögpɨ yjugypɨ́jccɨxɨpy, ni ca' ajcxy ypɨgɨpy, ni ca' ajcxy ñaymóoyɨgɨxɨpy y'ung huen pɨ́jccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Co jäy ajcxy yjugypɨcy, chi ca' huaad y'ögcɨxy jadüg'oc, quipxyjaty ajcxy mɨɨd je ángeles ajcxy, e Dios yɨ' ajcxy ung'adɨɨb co yjugypɨgɨpy mɨɨd jemybɨ jugy'ájtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Janch co yɨ ögpɨ yjugypɨgɨpy, jëbɨ mbaadɨp je tɨy'ajt ma Moisés ñecy ma jadu'n yjaybétyɨty, je taab anajty aay'ujtz ytoy, co je Huindzɨn Dios mɨgapxy Moisés, nɨmay: “Ɨɨch Abraham yDios, Isaac yDios, Jacob yDios.” ");
INSERT INTO mcoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Je ögpɨ ca' mɨɨdɨty Dios. Je jäy ajcxy huɨdi juugyɨp janchtɨy ajcxy ymɨɨd Dios, com co mɨɨd Dios ycɨxpɨ tüg'ócɨy jäy ajcxy ymɨɨd yjugy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chi jäy ajcxy huɨdi yaj'ixpɨjcp Dios ñecy nɨmay Jesús: ―Oy tɨ m'adzoy, Huindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ca' ajcxy ocjajtnɨ nej jac nɨmáaygɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chi Jesús je' ajcxy nɨmay: ―¿Nej co miich ajcxy mɨna'ñ co Cristo David y'ap y'oc? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David cɨ'm mɨna'ñ ma je Salmo necy: Yɨ Huindzɨn Dios nɨmay ɨɨch nHuindzɨn: “Iña' ya a'oy'amy ma ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ixtɨ coonɨ anajty miich mmɨdzip tɨ nmɨmadactäyɨch, jadu'n nej jɨhuɨ̈y tɨ nbɨdägyɨch yɨ mmɨdzip ma miich mdecypocxpejt.” ");
INSERT INTO mcoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Co David yxɨɨmoy Cristo ɨɨch nHuindzɨn, ¿nejtz yɨ' co y'ap'adyii y'oc'adyii? ");
INSERT INTO mcoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chi tüg'ócɨy cajpjäy jɨm anajty y'amɨdo'ijtcɨxy co Jesús nɨmay je' ydiscípulos ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Naygüend'ájtɨgɨx mɨɨd yɨ' escribas ajcxy ydiscípulos, co ajcxy ooy tzojccɨxy yhuɨdidaangɨxy mɨɨd yhuit oyjatypɨ, ooy ajcxy tzojccɨxy co huen capxpocxyii ma jäy y'amugɨ̈y, e ooy ajcxy tzojccɨxy yɨ cödumbɨ ɨñaybejt ma naymujctac, etz ooy ajcxy tzojccɨxy cödumbɨ ɨñaybejt ma jäy ajcxy yxɨɨdungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chi ajcxy yajcɨjxtayɨ yɨ co'ögytöxyjäy ypɨdägy, e tungɨxy ooy jecy tzajpcapxycapxɨɨ ma jäy yhuinduu. Yɨ jadu'mbɨ jäy ajcxy nïgɨ ajcxy Dios chaachytunɨɨyb mɨɨd ypocy ycɨxpɨ ca'ydɨ jacnipɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jiiby anajty Jesús ma Dios ytɨjc co ijxy comeeñyjäy may'amy ofrenda pɨdaaccɨxy ma meeñygaax. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","E nañ ijxy co tüg co'ögytöxyjäy pɨdägy anajty metz pi'cmeeñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chi Jesús ymɨnañ: ―Janch ɨɨch miich ajcxy nɨmäy co jadayaabɨ co'ögytöxyjäy ayoob jac anaxy jada, tɨ pɨdägy ofrenda ca'ydɨ jacnipɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tüg'ócɨy comeeñydɨjc ajcxy ypɨdacyp ma ofrenda je meeñ huɨdi conajxp. Jadayaabɨ co'ögytöxyjäy tɨ pɨdägy huɨdi anajty ñigayamy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nijëjɨty jäy co ytɨgɨɨy ma Dios ytɨjc nimɨydacy ajcxy co Dios ytɨjc ooy chach'oy'oydúñɨty mɨɨd tzaa oyjatpyɨ, e mɨɨd tɨɨbɨ jiiby yojxcɨxy. Chi Jesús ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Tüg'ócɨy jada huɨdi ajcxy m'ijxpy ma Dios ytɨjc, minɨp xɨɨ tiempo mɨna jada nɨcxy yhuɨ'my taj xit jada tzaa, ca' ma pochycop. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chi ajcxy y'amɨdooy Jesús: ―Huindzɨn, ¿mɨna jada jadu'n ytunɨɨyb yjadɨɨyb nej miich tɨ mmɨnañ? ¿Ti tɨy'ajt ji yaj'ixɨp co jada anajty jadu'n ytuna'ñyii yjada'ñyii? ");
INSERT INTO mcoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chi Jesús y'adzooy: ―Ix mgayajhuin'ɨɨngɨx. Ooy mayjäy ymina'ñ ñaybɨdägáanɨgɨxy co je' ajcxy je Cristo, ymɨna'ñ ajcxy: “Ɨɨch je' je Cristo; huingóniñ anajty je xɨɨ je tiempo mɨna je naaxhuiñybɨ ycɨxa'ñ ytɨgoya'ñ.” Ca' ajcxy axam mbanɨcxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Co miich ajcxy ayuc mɨdohuɨpy co jäy chachchiptungɨxy, e ñayñibɨdɨ̈cɨgɨxy, ca' mdzɨgɨ́ɨygɨxɨpy, com ooy ycopɨ́cyɨty co jada jadu'n jayɨjp ytunɨɨyb yjadɨɨyb, ca'nan hue' je' anajty tɨm cɨjxp tɨm tɨgooyb (je naaxhuiñybɨ). ");
INSERT INTO mcoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chi Jesús yjacmɨnañ: ―Nayñibɨdägɨɨb naax cajp mɨɨd huingbɨ naax huingbɨ cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","E minɨp mɨc'ujx, etz mɨj yuu mɨj pa'm xɨɨ yaa. E jadɨɨb mɨj'adzɨgɨ'ñ, etz ooy ijxpejt huɨdi qüexɨ̈gɨp tzajpcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma ca'nɨ anajty jadu'n jadyii, xypahuɨdijtcóotcɨxɨpy jäy, xymájtzcɨxɨpy, xycɨ̈yéjcɨxɨpy ma judíojäy ñaymujctac. Chi jäy ajcxy xypɨdägɨpy pujxtɨgoty, xyajnɨ́cxcɨxɨpy mach ma rey etz ma gobernador ajcxy yhuinduu. Jadu'n jäy ajcxy jɨbɨc xytunɨpy mɨɨd miich ajcxy com co anajty tɨ xymɨjpɨdáaccɨxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Miich ajcxy tɨy'ajt myegɨpy mɨɨd ɨɨch nxɨɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Co jäy ajcxy yxɨ̈huɨpy ma codungdɨjc, ca' ni nej ajcxy mjot'adɨɨyb, ni ca' ajcxy mhuinmayɨpy nej m'adzóogɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nyegɨpyɨch ayuc etz tɨy'ajt nej huaad mmɨdzip m'adzoogɨxy. Ca' mmɨdzip ajcxy jadɨpy nej xy'adzóogɨxɨpy, e nej xyjacxɨ̈gɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Miich ajcxy mgɨ'mdeedy, mgɨ'm'uch, mgɨ'm'ajch, etz mgɨ'm ajuugy amɨgüg xycɨ̈yéjcɨxɨpy ma cötujctac. Nijëjɨty miich ajcxy m'ögɨpy mɨɨd co anajty tɨ mmɨjpɨdaaccɨxy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mayjäy ajcxy ca' xy'ixaanɨpy xychogaanɨpy mɨɨd co anajty tɨ mmɨjpɨdaaccɨxy ɨɨch nxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ni tüg miich ajcxy mgöhuay ca' ytɨgoyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pen ooy ajcxy mmecxtucy, chi m'alma ñïdzögɨpy huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Co ajcxy m'ixɨpy Jerusalén anajty tɨ ñaducy mɨɨd ymɨdzip, huin'it ajcxy mnejhuɨ̈huɨpy co huingon je'anajty ma yhuindɨgoyaanɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Huin'it tiempo je jäy ajcxy huɨdi jɨm Judea naaxjot yquéeccɨxɨpy ñɨ́cxcɨxɨpy ajcxy yuugjoty, etz je jäy ajcxy huɨdi jɨm Jerusalén queegɨpy ajcxy, etz je jäy ajcxy huɨdi camjoty ca' huaad y'occajptɨgɨɨyñɨ ma je Jerusalén cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Je tiempo mɨna yjadɨɨyb ayo'n mɨɨd co anajty judío jäy tɨ ytundɨgooygɨxy, je' jada yajcuydundaayb jadu'n nej yjaaybétyɨty ma Dios ñecy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ayoob yɨ töxyjäy ajcxy huɨdi anajty ung tzɨm'ijtp huin'it xɨɨ, etz huɨdi anajty mɨɨd y'ungma'xung! Ooy jadɨɨb mɨj ayo'n ya naaxhuin etz tzip éjcɨn ma jada cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nijëjɨty ajcxy y'ögɨpy tzipjoty, e nijëjɨty yajnɨcxɨp tzumy mach ma huingbɨ cajp huingbɨ naax. E Jerusalén naxmɨhuägɨydähuɨɨb yɨ jäy huɨdi ca' yjudiojäyɨty, minɨpy je tiempo mɨna anajty Dios yajcɨxaanɨ yajtɨgoyaanɨ yɨ' ajcxy y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Huin'it xɨɨ huin'it tiempo quëxɨ̈gɨp ijxpejt ma xɨɨ po' etz ma yɨ madza', ya naaxhuiñ ooy jäy ajcxy jotmay mɨɨ'idɨpy. Je jäy ajcxy ooy chɨgɨ̈huɨpy yjɨhuɨ̈huɨpy yhuinmay'ahuɨdidɨpy ajcxy ooy, mɨɨd je mejy ycɨxpɨ co anajty chachpɨdɨ̈gy chachnögy chachmɨna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yɨ jäy ajcxy anucxɨ'ñ yajcɨdahuɨɨb co anajty ajcxy ixy nej yjadyii huindu'mybɨ naaxhuiñ; e huɨdijaty mɨc'ajt yajpatp jiiby tzajpjoty yücxtähuɨpy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Huin'it miich ajcxy xy'ixɨpyɨch, ɨɨch je jäy huɨdi tzoon tzajpjoty, nmiiñɨch jocjoty mɨɨd je nmɨc'ajtɨch, nmiiñɨch mɨɨd ɨɨch ngötújcɨn etz ɨɨch n'oy'ájtɨn mɨjpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Co je ayo'n tiempo jadu'n yjatzondägɨpy, chi mba't'íjxcɨxɨpy com huingoniñ anajty mɨna Dios xyñihuáangɨxɨpy xycohuáangɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chi Jesús yajnɨmay ajcxy tüg ayuc, ymɨnañ: ―Ijxcɨx yɨ higuerɨ etz tüg'ócɨy quipy, ");
INSERT INTO mcoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","co yhuamɨ̈gy huin'it miich ajcxy nejhuɨ̈y co tɨ yhuingonɨ mɨna ypottɨgɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tɨm jadu'n nej miich ajcxy ijxpejt mbɨcy ma higuerɨ quipy co pottiempo ytɨgɨɨyñɨ, nañ jadu'n co miich ajcxy m'ixɨpy je ijxpejt tzajpcɨ́xy jadu'n nej yam nyajnɨmaaygɨxy, mnejhuɨ̈huɨpy ajcxy co huingónɨp je tiempo mɨna Dios y'ane'ma'ñ ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Janch nɨmaaybɨch miich ajcxy co jadu'n yjadɨɨyb ytunɨɨyb jayɨjp, ca' anajty o'ctäy je jäy ajcxy huɨdibɨ tzɨnaayb jugy'ájtcɨxyp jadachambɨ xɨɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yɨ tzajp etz naaxhuiñybɨ naxɨp tɨgoyɨp yɨ'. Ɨɨch n'ayuc ca' ñaxɨpy ytɨgoyɨpy ni camɨna. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Naygüend'ájtɨgɨx miich ajcxy ca' mnijot'ájtcɨxy yɨ jocnɨɨ yɨ mügɨɨ, etz yɨ tzɨnaayɨn jugy'ájtɨn, jɨgɨx ca' ajcxy xyniminɨpy jotcömoñyɨ je ayo'n xɨɨ je ayo'n tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tɨmetiinɨ minɨpy je ayo'n tiempo mɨɨd jäy ajcxy ycɨxpɨ huɨdi ya tzɨnaayb ma tüg'ócɨy naaxhuiñybɨ. Tɨm jadu'n nej tüg ɨyujc ayo'nbaady co tɨmetiinɨ yajtüxuuch. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ni'ixɨ' ijtcɨx, mɨbɨjctzoogɨx Dios, ca'ydɨ ayo'n ajcxy mbaatcɨxy huɨdi jadaanɨp, jɨgɨx jiiby myajpáatcɨxɨpy tzajpjoty ma ɨɨch nhuinduu, ɨɨch, je jäy huɨdi tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Xɨɨm anajty Jesús yaj'ixpɨcy ma Dios ytɨjc, e coodz anajty chooñ ñɨcxy jɨm ma cögop huɨdi yxɨɨ Olivos. ");
INSERT INTO mcoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jabom jabom jopy jopy ñiminyii tüg'ócɨy cajpjäy jiiby ma Dios ytɨjc tɨbäy co y'amɨdoo'idaanɨ ajcxy Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Huingon anajty je xɨɨ mɨna jäy tzajcaagy caaygɨxy huɨdi ca' ylevadura mɨɨdɨty, huɨdi jäy ytijpy pascua xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chi je teedy mɨjtungmɨɨdpɨ etz je escribas yhuinma'ñ'ixtaaygɨxy nej ajcxy ocyaj'ögɨpy Jesús. Chɨgɨɨyb anajty ajcxy je cajpjäy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chi je mujcu' ytɨgɨɨy ma Judas yjot yhuinma'ñ. Je Judas hue' anajty ymɨmetz xɨɨ Iscariote, je' nidügtɨ je majmetzpɨ discípulos. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Chi Judas ñɨcxy oy mɨgapxy je teedy mɨjtungmɨɨdpɨ etz tzajptɨjc soldado huindzɨn, e ycapxytuñ mɨɨd je' ajcxy nej jëbɨ cɨ̈yecy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Huin'it je Jesús ymɨdzip ooy ajcxy yxoondaccottay. Chi ajcxy ñaygapxɨ co meeñ möhuangɨxy je Judas. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chi Judas cöbɨjcy je meeñ, chi yhuinma'ñ'ixtay nej jëbɨ cɨ̈yegɨpy Jesús ma ca'p mayjäy y'ixyii yhuindɨɨcxyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chi paty je xɨɨ mɨna jäy cay je tzajcaagy huɨdi ca' ylevadura mɨɨdɨty com huin'it anajty ajcxy yaj'ögy cöbixy ymang pascua xɨɨgɨxp. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chi Jesús quejxy Pedro etz Juan, nɨmay: ―Nɨcx miich ajcxy yaj'oyɨ' je pascua adzu'ɨ̈bɨ, jaydëbɨ ajt ngaayɨm. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chi ajcxy y'amɨdooy: ―¿Ma mdzocy co nyaj'oyɨ̈huɨbɨch ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chi Jesús ymɨnañ: ―Co mdɨgɨ̈huɨpy ajcxy cajpjoty, mbaadɨpy tüg yëydɨjc huɨdi yajnɨcxp tüg majt nɨɨ. Mbanɨcxyp ajcxy je yëydɨjc coonɨ yjädɨpy ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Co miich ajcxy mjädɨpy ma je jäy ytɨjc, chi ajcxy mnɨmähuɨpy je codɨjc: “Nhuindzɨnɨch jadu'n mɨnaam: ¿Ma yaj'ahuädz yajpaady ma ngayɨpyɨch je pascua adzu'ɨ̈bɨ mɨɨd ɨɨch ndiscípulotɨjcɨ?” ");
INSERT INTO mcoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Je codɨjc miich ajcxy xyajni'ixɨ̈huɨp tüg cuarto ma mɨmejtzpɨ piso. Ni'ixɨ' jɨm je adzu'ɨ̈bɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chi Pedro etz Juan ñɨcxy, chi paty jadu'n nej anajty tɨ ñɨmäyii, e jɨm ajcxy ni'ixɨɨy je pascua caayɨn uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Co je hora paty, chi Jesús y'ixtacy ma je mesa mɨɨd je' ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chi Jesús ymɨnañ: ―Tɨ ooy nijot'atyɨch co nmɨɨdgayaangɨxy jada pascua adzu'ɨ̈bɨ ma ca'nɨ n'ögyñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ɨɨch miich ajcxy jadu'n nɨmaayb co ɨɨch ni mɨna ca' njaccayɨpyɨch jadüg'oc je pascua adzu'ɨ̈bɨ, ixtɨ coonɨ yajcuydundähuɨpy je pascua xɨɨ ytɨy'ajt ma Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chi Jesús conɨ̈gy je ügy co Dioscojúyip yajnaxy, huin'it ymɨnañ: ―Uccɨx jada ügy, naymóoyɨgɨxy miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cham ɨɨch miich ajcxy nɨmäy co jadu'n nej yjacnɨcxa'ñ xɨɨ tiempo ca' vino nɨɨ üga'ñɨch ixtɨ coonɨ Dios y'ané'mɨn yminɨpy ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nañ yconɨ̈gy Jesús tüg tzajcaagy co mɨbɨjctzooy Dios, huin'it tujc-huäcxy moy discípulos ajcxy, e chi ajcxy nɨmay: ―Jada tzajcaagy ɨɨch nninïcx'ajtpyɨch huɨdi ngɨ̈yejcpyɨch ma yɨ o'cɨn mɨɨd miich ajcxy mbocy ycɨxpɨ. Jada ijxpejt miich ajcxy mɨɨ'idɨpy oy jäymech mɨɨd ɨɨch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Co anajty tɨ ycaydaaygɨxy, chi Jesús conɨ̈gy je ügy jadüg'oc, chi ymɨnañ: ―Jada vino je' jada Dios y'ayuc ytɨy'ajt jemybɨ jadu'n yɨ' nej ɨɨch nnɨ'py huɨdi temam yogam mɨɨd miich ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jadachambɨ yɨ jäy huɨdi xycɨ̈yegaambɨch ma nmɨdzipɨch, ya je' cham mɨɨd'ɨñäyɨch ma jada mesa. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Janch jadu'n njada'ñ n'ayoohua'ñɨch jadu'n nej tɨ nyajnigodugɨ̈yiijɨch. ¡Ayo'n padamy je jäy ayoob huɨdi xycɨ̈yegaamyɨch ma nmɨdzipɨch! ");
INSERT INTO mcoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chi je nimajmetzpɨ ajcxy ñayñɨmaayɨ miñ xyɨpy: ―¿Pɨn jada' yɨ' ma ɨɨch ajt huɨdi jadu'n tundɨgoyam? ");
INSERT INTO mcoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chi je nimajmetzpɨ huɨdi Jesús anajty tɨ huin'ixy ca' ajcxy ñay'ayuc-huinjɨhuɨɨyɨ pɨn jada' jac mɨjpɨ oc'idɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chi Jesús nɨmay ajcxy: ―Yɨ reyes ajcxy y'ane'myb ajcxy naax cajp jadu'n nej tüg huindzɨn, yɨ' ajcxy huɨdibɨ ane'mb yajtíjycɨxy co ooy oytuungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mɨɨd miich ajcxy ca'ydɨ yjadú'nɨty. Hue' janchtɨy je mɨjpɨ ma miich ajcxy huen ñaybɨdägyii nej jɨhuɨ̈y ymútzɨty. E je huɨdi nigohuajc'ajtp huen ñaybɨdägyii nej jɨhuɨy je' je' je tumbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Pɨn je' jacmɨ́jɨp? ¿Huɨdi ɨñaybɨ ma mesa, o huɨdi ni'ixɨɨyb a'ɨxɨɨyb caayɨn uucɨn? Yɨ' je' jacmɨ́jɨp huɨdi ɨñaayb ma mesa. Per ɨɨch ijtpɨch mɨɨd miich ajcxy jadu'n nej huɨdi ni'ixɨɨyb aa'ɨxɨɨyb caayɨn uucɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mɨɨch ajcxy tɨ m'íjtcɨxy mɨɨd ɨɨch ma anajty ayo'n tɨ nyajnaxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Paady ɨɨch miich ajcxy tüg ané'mɨn nmooyb, jadu'n nej ɨɨch ndeedy tɨ xymöyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jaydëbɨ miich ajcxy mgáaygɨxɨpy m'uuccɨxɨpy ma ɨɨch nmesa jiiby ma ɨɨch n'ané'mɨn e m'ɨñähuɨpy ajcxy ma je ane'mdac, e mdɨydúngɨxɨpy m'ané'mgɨxɨpy je nimajmetz pɨcy Israel ñaax ycajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nañ jadu'n je huindzɨn Jesús ymɨnañ: ―Simón, Simón, jadachambɨ je mujcu' xyjot'ixaangɨxy xyhuinma'ñ'ixaangɨxy jadu'n nej jäy trigo huimbojy co yajhuätzaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per ɨɨch Dios nmɨbɨjctzooyɨch mɨɨd miich ycɨxpɨ, jɨgɨx miich ca'ydɨ mmɨbɨ́jcɨn ytɨgoy'ity. Mɨna anajty miich tɨ mjothuimbity, jotmɨc mɨgápxɨpy yɨ mmɨgügtɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chi Pedro ymɨnañ: ―Huindzɨn, jotcujc ɨɨch nnɨcxa'ñɨch mɨɨd miich oy pujxtɨgótyɨty, etz oy ndɨmy'ögɨbɨch mɨɨd miich. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Huin'it Jesús nɨmay Pedro: ―Ɨɨch miich nɨmaayb co ca'nɨ anajty tzey yaxɨ̈gy jabom jopy co miich mɨná'nɨp tugɨɨg'oc co miich ca' xy'ix'adyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chi Jesús nɨmay ydiscípulos ajcxy: ―Co ɨɨch miich ajcxy jayhuin nguejxy, ni mmoral, ni ca' mmeeñydɨjc, ni mgɨ̈g tɨ mmɨ'oygɨxy, ¿nej myajtɨgoy'ijt ajcxy ti jatyɨ? Chi ajcxy y'adzooy: ―Ni ti. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chi Jesús ymɨnañ: ―Jadachambɨ pɨn ymeeñydɨjc etz ymorral mɨɨd, huen mɨnɨcx; nañ pɨn ca' mɨɨdɨty y'espada, huen toogy yjocx huit, chi juyɨpy y'espada. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ɨɨch miich ajcxy nɨmaayb co copɨcy jada yajcuydunɨpy huɨdibɨ mimb jaybety mɨɨd ɨɨch ycɨxpɨ ma Dios ñecy ma jadu'n ymɨnañ: “Yaj'amɨchomujc (je Cristo) mɨɨd yɨ' ajcxy huɨdi jɨbɨcjäyɨp.” Tüg'ócɨy mimb jaybéty ma Dios ñecy mɨɨd ɨɨch ycɨxpɨ, yajcuydunɨpy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chi Jesús ydiscípulos ajcxy ymɨnañ: ―Huindzɨn, cha metz espada. Chi Jesús y'adzooy: ―Huen mɨɨd yɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chi Jesús jɨm choñ ñɨcxy ma je cop huɨdi yxɨɨ Olivos, com jɨm anajty nɨcxy coodz coodz, chi je' ydiscípulos ajcxy ypanɨcxɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Co ajcxy yja'ty ma je cop, chi Jesús ymɨnañ: ―Mɨbɨjctzoogɨx Dios huen xypubedɨpy xypudɨgɨ̈huɨpy ajcxy ca'ydɨ mdɨgɨɨygɨxy jɨbɨc tuum. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chi Jesús huinhuäctuty je discípulos ajcxy tüg tzaagäch yjɨguëgyɨty, chi ycoxtɨnay'ahuɨɨy ytɨgɨɨy Dios mɨbɨjctzoob. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Chi Jesús ymɨnañ: ―Dios Teedy, pen miich m'a'ɨxɨɨyb pɨ́jcɨgɨch jada tzaachypɨ, ca' ɨɨch huaad nyajnaxyɨch, per ca' ɨɨch huaad ngɨ'mdzójcɨn nguyduñɨch, miich mdzójcɨn huen myajcuyduñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chi ñayguëxɨ̈cɨ tüg ángel tzajpjoty chooñ, jotmɨc mɨgapxy je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yam anajty Jesús ooy ytaj ymay, chi Dios mɨbɨjctzooyb jacmɨctägy. E je yxɨbitnɨɨ ypɨdzɨmy janch jadu'n yɨ' anajty nej nɨ'py janch mɨjjaty y'ocnajtzta'cxɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Co ypɨdɨ̈gy ma anajty Dios mɨbɨjctzoy, chi nihuimbijty je' ydiscípulos ajcxy, chi oy paatcɨxy maab anajty ajcxy mɨɨd jotmay. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chi Jesús nɨmay ymɨgügtɨjc ajcxy: ―¿Ti co mdzachmaagɨxy? Pɨdɨ̈ccɨx mɨbɨjctzoogɨx Dios, ca'ydɨ jɨbɨc tuum mdɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jɨm Jesús anajty ymɨgügtɨjc ajcxy mɨɨdcapxy mɨɨdmɨydägy, co je mayjäy oy yjäty. Jayɨjp anajty ymiñ je huɨdi anajty xɨɨjɨp Judas, yɨ' je'anajty nidügtɨ ma je nimajmetzpɨ Jesús ydiscípulos ajcxy. Chi Judas mɨhuingoñ Jesús co anajty tzücxa'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chi Jesús ymɨnañ: ―Judas, ¿nej mɨɨd tüg tzücxɨn mgɨ̈yecy ma ymɨdzip, je jäy huɨdi tzoon tzajpjotyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","E je' ajcxy huɨdi anajty Jesús ymɨɨd, co ajcxy ijxy jadu'n nej ytuñyii yjadyii, chi ajcxy ymɨnañ: ―Huindzɨn, ¿tzoc ajt mɨhuimbijtɨm? ");
INSERT INTO mcoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chi nidüg je' ajcxy yajtzaachɨɨyɨ je teedy mɨjtungmɨɨdpɨ tüg ytumbɨ, quejtzpujxɨ tüg ytätz'ac a'oy'amybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Huin'it Jesús ymɨnañ: ―Ixmajtzcɨx, huen jadu'ñyɨ. Chi nïdonɨ je jäy ytätz'ac, e jadu'n yajtzoocy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chi Jesús nɨmay ajcxy huɨdi nimiinɨ, yɨ teedy tungmɨɨdpɨ ajcxy, yɨ Dios ytɨjc policía huindzɨn etz mɨjjäydɨjc: ―¿Nej co xyñimíingɨxyɨch mɨɨd pujx etz mguipyjɨjpxu'ñ jadu'n nej jɨhuɨ̈y ɨɨch tüg meetzpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jiiby ɨɨch anajty jabom jabom ma Dios ytɨjc, e ca' miich ajcxy ti tɨ mduñ mɨɨd ɨɨch. Per cham jëdu'n je tiempo mɨna miich ajcxy xy'ane'myɨch etz je jɨbɨcpɨ xymɨmadägyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chi ajcxy majch je Jesús, yajnɨcxy ajcxy, e pɨdacy ma teedy mɨjtungmɨɨdpɨ ytɨjc. Je Pedro jɨguëgyjɨhuɨ' anajty ypanɨcxyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jɨm ajcxy jɨɨn yajmɨjɨy tɨbägujc chi ajcxy y'ixtactay nidüg'ócɨy. Pedro y'ixtacy nañ jadu'n ma je jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Huin'it tüg pödumbɨ ijxy Pedro ɨñäy ma jɨɨmba', chi huindɨcxpejty nɨmay: ―Jada yëydɨjc nañ ymɨɨd anajty Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chi Pedro ca' cöbɨjcy, ymɨnañ: ―Töxyjäy, ca' ɨɨch yɨ' n'ixy'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nañ jahueengɨ huin'it jadüg jäy Pedro yhuindɨcxpejtɨ, ñɨmaayɨ: ―Miich, yɨ Jesús ajcxy anajty mɨɨd m'ity. Chi Pedro ymɨnañ: ―Ca' n'ɨɨchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tɨ anajty tüg horɨ nïnaxnɨ co oy huingbɨ ymɨnandägy: ―Janch co jada yëydɨjc yɨ' anajty mɨɨd y'ity Jesús. Com nañ galileojäy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chi Pedro ymɨnañ: ―Ca' ɨɨch nhuinjɨhuɨ̈y nej miich mmɨna'ñ. Capxnɨ anajty je Pedro co tzey oy yaaxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chi je Huindzɨn Jesús ni'ijxhuimbijty je Pedro. Huin'it Pedro jäymetzcoottɨ je' ayuc nej anajty yHuindzɨn Jesús tɨ ñɨmäyii: “Ni ca'nɨ anajty tzey yaaxɨ̈gy cham coodz co miich tugɨɨg'oc xycoyüdzɨbyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chi Pedro ypɨdzɨmy tɨbäy, oy jiiby yäxy mɨɨd tájɨn máyɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Je jäy ajcxy huɨdi anajty Jesús cuend'ajtp, ooy ajcxy nɨxiicy nɨyaaxy, etz nañ ooy ajcxy huingojxy jɨjpcojxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Chi ajcxy huiingoxodzɨy, e cojxy ajcxy ma yhuiñyjɨjp, nɨmaaygɨxy: ―Octɨygapx, ¿pɨn tɨ xycoxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E ooy anajty mɨɨd yjɨbɨc ayuc cɨxy cuety nɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Co yxɨɨmɨɨy, chi yöymujcy yɨ teedy mɨjtungmɨɨdpɨ ajcxy, yɨ mɨjjäydɨjc ajcxy, etz yɨ escribas ajcxy, chi ajcxy y'amɨdooy: ");
INSERT INTO mcoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Nɨmaaygɨch ajcxy ¿nej miich je' je Cristo? Chi Jesús y'adzooy: ―Co ixyipy nnigapxɨch, ca' miich ajcxy mɨbɨgɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","E pen ɨɨch miich ajcxy n'amɨdooyb, ca' miich ajcxy xy'adzohuɨpyɨch, etz canan huin'it xyñajtzmadzɨ̈huɨbɨch miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jadachambɨ e ñɨcxa'ñɨ ɨɨch, je jäy huɨdi tzoon tzajpjoty, n'ixtäga'ñɨch a'oy'amy ma Dios mɨc'ajtmɨɨdpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chi nidüg'ócɨy je' ajcxy y'amɨdooy: ―¿Nej janch co miich Dios xy'ung'adyii? Chi Jesús y'adzooy: ―Miich ajcxy jadu'n mɨnamb co ɨɨch njëjɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chi ajcxy ymɨnañ: ―¿Ti ajt njac-huáanɨm testigo? Tɨ ajt yam cɨ'm nmɨdoohuɨm nej mɨna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chi tüg'ócɨy je mayjäy ajcxy ypɨdɨ̈gy, chi yajnɨcxy ajcxy Jesús ma je gobernador Pilato. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chi ajcxy ytɨgɨɨy xɨ̈bɨ ymɨnaangɨxy: ―Jada jäy naax cajp yaj'ixpɨjcp huɨdi ca' ytɨy'ájtɨty. Yɨ' adujctähuam co ca' huaad nmɨgüéjtɨm César, e ymɨna'ñ cɨ'm co yɨ' je' je Cristo huɨdi rey'ajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chi Pilato y'amɨdooy Jesús: ―¿Nej miich je' judío jäy xyrey'ajtp? Chi Jesús y'adzooy: ―Miich jadu'n mɨnamb. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chi Pilato nɨmay je teedy tungmɨɨdpɨ ajcxy etz je mayjäy: ―Ca' ɨɨch ti pocy nbaadyɨch ma jadayaabɨ yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chi Jesús ymɨdzip nïgɨ anajty ajcxy ymɨnan'adɨɨtzcɨxy: ―Jada Jesús naax cajp tzachyajqueec-huäcxtaayb je judíojäy mɨɨd yɨ' y'ayuc. Yajtzondacy Galilea, e jadachambɨ ya Judea jadu'n ɨdɨ̈ch. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Co Pilato mɨdoy Jesús ymɨdzip ajcxy nigapxy Galilea, chi y'amɨdooy pen galileojäy je Jesús anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chi mɨc'amy huinjɨhuɨy co yɨ' jɨm anajty yajpaady ma Herodes y'ane'my, chi jɨm quejxy ma Herodes huɨdi nañ jadu'n anajty yajpatp jɨm Jerusalén huin'it xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Co Herodes ijxy Jesús, chi oy jotcugɨɨy com tɨɨyɨp anajty ooy ja'ixa'ñ, tɨ anajty may ayuc mɨdoohuɨ, e ahuixy anajty co mɨjhuinma'ñ tunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Janch may ayuc ooy jayaj'amɨdoy, e Jesús ni tüg'aa ca' y'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jɨm anajty teedy mɨjtungmɨɨdpɨ etz je escribas ajcxy, tzachnïgɨ̈béjtcɨxy mɨctägy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chi Herodes mɨɨd yjäy ooy nɨxiicy yajxiicy Jesús, ca' mɨj'ijxy mɨjpɨdacy. Chi xojxy mɨɨd oyhuit etz quejxhuimbijty jɨm ma Pilato. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Huin'it xɨɨ Herodes etz Pilato ajcxy ñaymɨgügpɨjcɨ, com naymɨjotma'tɨp anajty ajcxy huin'it tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chi Pilato huomujcy yɨ teedy mɨjtungmɨɨdpɨ, yɨ cajptungmɨɨdpɨ, etz yɨ naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chi ajcxy nɨmay: ―Tɨ miich ajcxy xyajnimíngɨxyɨch jadayaabɨ yëydɨjc, jadu'n miich ajcxy mɨnamb co ooy jäy yajqueec-huäcxtay. Tɨ ɨɨch yɨ' jatɨyduñɨch ma miich ajcxy mhuindu, ca' ɨɨch yɨ' ni ma ypocy tɨ nbaatɨ, jadu'n nej miich ajcxy mxɨ̈gɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nañ ni ca' Herodes ti pocy tɨ paady ma jada jäy, com tɨ njayajniquexyɨch, ni ti pocy jada Jesús ca' tɨ tuñ huɨdi huaad nyajco'ögɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Miñ n'octzaachytuñɨch, jaydëbɨ nnajtzmadzɨ̈huɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jadu'n je gobernador anajty costumbre mɨɨdɨty co najtzmadzɨ̈y tüg machyjäy mɨjxɨɨjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chi je mayjäy tügmucy ajcxy ymɨnaandacy: ―¡Yaj'ög jadayaab Jesús! ¡Najtzmadzɨ' yɨ Barrabás! ");
INSERT INTO mcoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Je Barrabás anajty pujxtɨgoty tɨ ypɨdägyii co anajty tɨ nibɨdɨ̈gy je gobierno, nañ tɨ anajty yjäyyaj'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Chi Pilato nɨmay ajcxy jadüg'oc co najtzmadzɨ̈hua'ñ Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Chi je mayjäy janch mɨc ymɨnañ: ―¡Yajcruudzpet miich yɨ'! ¡Yajcruudzpet miich yɨ'! ");
INSERT INTO mcoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chi Pilato ymɨnañ je mɨdugɨɨg'ocpɨ: ―¿Ti Jesús tɨ tundɨgoy? Ca' yɨ' ma ypocy nbaatɨch. Miñ n'octzaachytuñɨch, e najtzmadzɨ̈huɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Je jäy ajcxy nïgɨ anajty ymɨnaan'adɨɨtzcɨxy janch mɨc, co huen yajcruudzpejty. Chi ajcxy jadu'n mɨmadacy Jesús co chachne'mgɨxy je teedy tungmɨɨdpɨ, etz je cajpjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chi jada' Pilato cuyduñ jadu'n nej je jäy ajcxy anajty pɨjctzoy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chi Pilato najtzmadzɨɨy je Barrabás huɨdi anajty pujxtɨgótyɨp, co anajty chach jäy yajqueec-huäcxy, etz yjäyyaj'ögy, je' huɨdi yɨ jäy ajcxy ypɨjctzou. Chi Pilato cɨ̈yejcy Jesús ma yɨ' ajcxy huen tungɨxy nej tzojccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chi je judíojäy ajcxy yajnɨcxy Jesús. Jɨm tü'am ajcxy mɨnaybaatɨ tüg jäy huɨdi anajty tɨ chooñ camjoty, huɨdi anajty yxɨɨ Simón, e ycogájpɨty anajty Cirene. Chi adzip ajcxy Simón yajquejcycabɨy Jesús ycruudz, e yajpanɨcxy ajcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jac'axam anajty naax cajp panɨcxcɨxy, etz nañ may töxyjäydɨjc ajcxy chachyaaxcɨxy mɨɨd jotmay mɨɨd yɨ' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Chi Jesús ni'ijxhuimbijty je töxyjäydɨjc ajcxy, chi nɨmay ajcxy: ―Miich Jerusalén töxyjäydɨjc ajcxy, ca' xyñiyáaxcɨxɨch. Nayñiyaaxɨgɨx miich ajcxy cɨ'm etz m'ung ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chi ypaadɨpy tiempo co jäy ajcxy ymɨna'nɨpy: “Jotcujc je töxyjäy ajcxy huɨdi ca' y'ung ixy, huɨdi ca' tɨ y'ungtzɨmɨ̈gy, etz huɨdi ca' tɨ y'ung yajtzïtzcɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chi je jäy ajcxy nɨmaydägɨpy mɨjtun mɨjcop: “Nïgɨdagótcɨch ajcxy”; etz je mutztun mutzcop: “Yajtɨgooygɨch ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pen jäy ajcxy tzaachypɨ ayo'n mooyb Dios y'ung, nïgɨ ajcxy jacjiinɨ ytundɨgoya'ñ mɨɨd Dios yjäy, tɨm jadu'n nipaady nej pɨn puxam tzuxy quipy nañ puxamy quipy tɨ̈tzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nañ jɨm anajty yajnɨcxcɨxy mɨɨd Jesús jametz pocyjäy. Tú'cɨy mɨɨd Jesús anajty yaj'ögaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Co ajcxy oyjäty jɨm ma tüg it huɨdi jäy ytijpy ögpɨ cohuajc, chi ajcxy jɨm Jesús yajcruudzpejty mɨɨd metz pocyjäy: tüg pocyjäy a'oy'amy, jadüg anajty'amy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chi Jesús ymɨnañ: ―Dios Teedy, mecxɨ ajcxy ypocy, com ca' nejhuɨɨygɨxy ti ytungɨxyp. Co je soldados anajty ajcxy yajhuäcxaanɨ ac je'y Jesús yhuit, chi ajcxy ijxy suerte pɨn ocjëdɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jɨm je cajpjäy anajty yhuindɨɨcxcɨxy, yam je tungmɨɨdpɨ nɨxïgy yajxïgy Jesús, ymɨnañ ajcxy: ―Jada Jesús huingjäy tɨ yajtzögy, huen cham cɨ'm nayyajtzögyii, pen yɨ' je' je Cristo, je huɨdi Dios tɨ huin'ixyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nañ jadu'n je soldados ajcxy nɨxiiccɨxy yajxiiccɨxy Jesús, nimɨjhuägy ajcxy möhuaangɨxy anajty vino ta'mbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chi je soldados ajcxy ymɨnañ: ―Pen miich Rey'ajt ma yɨ judíojäy ajcxy, nayñihuänɨɨ cɨ'm. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma Jesús ycödu jɨm anajty yjaayɨty griego'amy, latin'amy, etz hebreo'amy: JADA JE' YƗ JUDIOJÄY AJCXY YREY. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chi tüg pocyjäy huɨdi anajty cruudzcɨ́xy ooy nɨxiicy yajxiicy Jesús ymɨnañ: ―Pen miich je' je Cristo, naygohuänɨɨ cɨ'm, e cohuaangɨch ɨɨch ajcxy nañ jadu'n. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chi je jadügpɨ pocyjäy oy y'adzooy, ojy ymɨgüg, nɨmay: ―¿Nej ca' miich Dios mdzɨgɨ̈y. Ca' m'ixy co tú'cɨy tɨ nbócycähuɨm? ");
INSERT INTO mcoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ɨɨch ajt janch paatɨp jadu'n, co jadu'n jada ngöbɨ́jcɨm tzaachypɨ je tɨɨbɨ ndundɨgooyɨm. Jadayaabɨ Jesús janch ni ti jɨbɨcpɨ jada tɨ catuñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chi je pocyjäy nɨmay Jesús: ―Tun may'ajt xyjäymedzɨpɨch co anajty mjäty jiiby ma m'ane'mdac. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chi Jesús oy y'adzooy: ―Janch ɨɨch miich yam nɨmäy co cham ɨɨch miich mɨɨd'íjtnɨpy ma je oybɨ it. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Co cujcxɨɨbɨ paty, chi oy ycoodzɨ̈y tüg'ócɨy naaxhuiñ ixtɨ mɨnacyxɨɨnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chi xɨɨ ca' y'oc'anɨ. Chi je huit oy ycɨɨtzhuäcxy huɨdi anajty adɨɨydujcp je Dios y'it jiiby ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Huin'it Jesús mɨc ypätcapxy ymɨnañ: ―Dios Teedy, cham nyajcɨ̈dɨgɨ̈y ɨɨch n'alma. Co Jesús jadu'n ymɨnañ chi y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Co je soldado huindzɨn ijxy jadu'n nej anajty tɨ ytunyii tɨ yjadyii, chi ooy jäymejch yɨ Dios ymɨnañ: ―Janch co jadayaabɨ yëydɨjc anajty tudägy yjäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chi je mayjäy tɨɨbɨ anajty jɨm yöymújccɨxy yhuindɨɨcxcɨxy, co ajcxy ijxy jadu'n nej ytuunɨ yjajtɨ, chi ajcxy huimbijttaayñɨ cajpjoty yam ycaach tzachcójxcɨxy mɨɨd jotmay ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Cham tüg'ócɨy Jesús ymɨgügtɨjc ajcxy huɨdi anajty mɨɨd ñay'ixy'adyii, etz töxyjäydɨjc ajcxy huɨdi anajty Jesús tɨ ypadzonyii jɨm Galilea, jɨguëgy je' anajty ajcxy yhuindɨɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jɨm anajty tüg yëydɨjc huɨdi anajty yxɨɨ José, hue' anajty ycogájpɨty Arimatea ma Judea naaxjot. Je' anajty judío mɨjtungmɨɨdpɨ, e je' ooy anajty chach'oyjäyɨty etz ytudägyjäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Je' nañ yjɨjp'ijxy anajty co yminɨpy je Dios y'ané'mɨn, e ca' je' anajty jɨjptɨgɨyɨ̈y mɨɨd jacnaagɨty mɨjtungmɨɨdpɨ co ajcxy yaj'ögy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chi José ñɨcxy ma Pilato oy pɨjctzoohuɨ Jesús ñinïcx. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chi yajmɨnajcy ma cruudz, e mo'ñ mɨɨd tüg sábana, chi pɨdacy ma ögpɨ jut, ma tüg tzaahuinguetzmɨjc ma ca'nɨ anajty ni tüg ögpɨ jiiby yajpɨdägyp. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Je' anajty ajcxy ni'ɨxɨɨyb a'ɨxɨɨyb je pascua xɨɨ e je' anajty tɨm tzondägan je pócxɨn xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chi je töxyjäydɨjc huɨdi anajty tɨ ypadzoñyii Jesús jɨm Galilea, panɨcxy ajcxy je José axam. Chi ajcxy nañ jadu'n ijxy je ögpɨ jut, etz je ninïcx jadu'n nej jiiby yajpɨdacy. ");
INSERT INTO mcoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chi ajcxy yhuimbijttay cajpjoty. Chi ajcxy yaj'oyɨɨy ujtz xuucpɨ, tzoy, etz ungüento, chi amay'ajty je pocxɨnxɨɨ, jadu'n nej anajty cötújcɨn y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Co je semaan y'ixtɨgɨɨy janch tɨm tɨcxɨ̈cp je töxyjäydɨjc ajcxy ymiiñ ma je o'cpɨ jut, chi mɨmiiñ ajcxy ujtz xuucpɨ, etz tzoy huɨdibɨ anajty tɨ yaj'oyɨɨygɨxy. Nañ jadu'n mɨɨdjadyii töxyjäydɨjc miiñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chi ajcxy paty je tzaa tɨ anajty yjɨdɨguegyii ma je o'cpɨ jut'aguu. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Co ajcxy ytɨgɨɨy jutjoty, chi ca' ajcxy paty je Huindzɨn Jesús ñinïcx. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chi jadu'n yjajty, jiiby anajty ajcxy jutjoty huinmaaygɨxy, co ñayguëxɨ̈gɨ ma ajcxy ymɨjc metz yëydɨjc janch adɨcxp anajty yhuit. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chi ajcxy ooy chɨgɨy, chi ajcxy yhuindactay, chi je metzpɨ yëydɨjc ymɨnañ: ―¿Na'amy co m'ixtaaygɨxy yɨ jugypɨ ma yɨ tɨɨbɨ y'ögy? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ca' je' ya, tɨ je' yjugypɨcy. Jäyméjtzcɨx jadu'n nej mɨna'ñ jɨm Galilea, co ymɨnañ: ―Ooy ycopɨ́cyɨty co ɨɨch, je jäy huɨdi tzoon tzajpjoty, nyajcɨ̈yegɨpy pocyjäy cɨ̈'am. Yɨ' ajcxy xyajcruudzpedɨpyɨch, chi njugypɨgɨpyɨch codugɨɨg xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chi ajcxy oy jäymejtzcooty nej anajty Jesús tɨ ymɨna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chi je töxyjäydɨjc ajcxy yhuimbijttay ma o'cpɨ jut. Chi ajcxy yajmɨɨdmɨydactay jadu'n nej anajty tɨ íjxcɨxy tɨ mɨdoogɨxy mɨɨd Jesús ydiscípulos ajcxy je nimajmetzpɨ etz jacjadyii jäy huɨdi yajpaatp ma je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Je töxyjäy ajcxy huɨdi ooy ma Jesús ñaaxtɨgɨɨy, je' je' anajty ajcxy: María Magdalena, Juana, etz María Jacobo ytaj, e cham jacnaagɨty ymɨdöxyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chi Jesús ydiscípulos ca' ajcxy tɨm mɨjpɨdacy je töxyjäydɨjc ajcxy ayuc, hue' ajcxy tijy nɨgo y'occapxcɨxy y'ocmɨydaaccɨx, paady ca' ajcxy mɨbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Chi Pedro ypɨdɨ̈gy ñɨcxy poyɨ̈gyɨ ma anajty Jesús tɨ ñaaxtɨgɨ̈y. Chi Pedro yco'ixɨɨy ma je o'cpɨ jut, chi ijxy co ca' jiiby ni ti, jëyɨ Jesús yhuit abɨcy y'ooxnäy. Chi Pedro yhuimbijty ma ytɨjc jɨhuɨɨy ooy jadu'n nej tɨ ytuñyii yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Huin'it xɨɨ metz Jesús ydiscípulos ajcxy ñɨcxy ma tüg cajp mutzpɨ hue' anajty yxɨɨ je cajp Emaús, hue' yjɨguemyɨty mɨɨd Jerusalén tugɨ'px estadios (majmetz kilómetro). ");
INSERT INTO mcoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chi amɨydaacɨp anajty ajcxy ñɨcxy. Nigapxcɨxy nimɨydaaccɨxy nej Jesús tɨ yjaty tɨ y'ayoy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","E jadu'n yjaty ma anajty ycapxcɨxy ymɨydaaccɨxy je nimetzpɨ, chi Jesús cɨ'm nimɨjhua'cy je metzpɨ, chi mɨɨd ñɨcxy ajcxy yquipxyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oy anajty ja'ijxcɨxy, ca' ajcxy tuñcuend pɨn je' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chi Jesús y'amɨdooy je' ajcxy: ―¿Ti miich ajcxy mɨydacpy ma yam mdüyöygɨxy? ¿Nej co mdájcɨxy mmáygɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chi tüg huɨdi anajty yxɨɨ Cleofas y'adzooy: ―Janch tüg'ócɨy mayjäy nejhuɨydäy je ayo'n tɨ ytunyii tɨ yjadyii. ¿E miich naydüg jɨm jättac Jerusalén, e jadu'n tijy ca' mnejhuɨ̈y? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chi Jesús je' ajcxy nɨmay: ―¿Ti tɨ ytuñyii tɨ yjadyii? Chi je' ajcxy ymɨnañ: ―Jesús Nazaretpɨ, huɨdi Dios y'ayucnajtzcapxɨɨyɨp, yɨ' anajty mɨj jánchɨp ma yɨ ayuc etz huinma'ñ ma Dios yhuinduu, etz cham ma tüg'ócɨy naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Chi yɨ' ajcxy je teedy mɨjtungmɨɨdpɨ etz ɨɨch ajt ndungmɨɨdpɨ Jesús yajcɨ̈dɨgɨɨy je gobernador co huen yaj'ögyii. Chi ajcxy yajcruudzpejty. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hue' ɨɨch ajcxy anajty ndzach'ahuijxyp co yɨ' je' huɨdi Israeljäy ajcxy cohuänaam ma ymɨdzip. Jadachambɨ jada' ymɨdugɨɨgxɨɨ ma jadu'n tɨ ytunyii tɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Cham ɨɨch ajcxy ndöxyjäydɨjc ajcxy ooy xy'adzɨgɨ́ɨygɨxyɨch. Tɨ y'oygɨxy janch tɨcxɨ̈cp ma o'cpɨ jut. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","E com ca' ajcxy paaty je ñaaxnïcx, chi ajcxy yhuimbijtnɨ ymɨnaangɨxy co tɨ íjxcɨxy yɨ ángeles ajcxy, hue' je ángeles ajcxy ymɨnañ co Jesús yjuugyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Huin'it nijëjɨty nmɨgügtɨjcɨch ooy ma o'cpɨ jut, paty ajcxy janch jadu'n nej töxyjäydɨjc anajty ymɨnaangɨxy. Ca' je' ajcxy ijxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chi Jesús ymɨnañ: ―¡Miich jäy ajcxy ooy ajcxy m'aajuuñɨty mjotjuuñɨty, ca' ajcxy tɨ mdzojcmɨbɨjccɨxy co ajcxy mjamɨbɨgá'nɨp huɨdibɨ y'ayuc najtzcapxɨɨybɨ ajcxy ycapxy! ");
INSERT INTO mcoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Nej ca' anajty ycopɨ́cyɨty co je Cristo ayo'n paadɨp, e huin'it ytɨgɨ̈huɨp tzajpjoty ma yɨ' y'it oybɨ? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chi Jesús yajnɨmaay ajcxy Dios ytɨy'ajt, chondägy ma Moisés ñecy, etz tüg'ócɨy jacjadyii necy huɨdi Dios y'ayucnajtzcapxɨɨybɨ yjaay, yajxon ajcxy yajni'ixɨyday jadu'n nej yjaybétyɨty mɨɨd je Cristo ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chi ajcxy mɨhuingoñ je mutz cajp ma anajty ñɨ́cxcɨxy, je Jesús jadu'n ñaybɨdaacɨ jadu'n nej jɨhuɨ̈y jacjɨguem ñɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Huin'it ajcxy nɨmay adzip: ―Huɨ'm miich mɨɨd ɨɨch ajcxy, nïgɨ jada chuu'ɨɨy'adɨ̈ch. Chi Jesús ytɨgɨɨy cajpjoty yhuɨ'my mɨɨd je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chi jadu'n yjajty co anajty tɨ y'ixtaaccɨxy caaybɨ, chi Jesús tüg tzajcaagy conɨ̈gy, e yajnajxy Dios cojuyip, huin'it tujc-huäcxy moy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Huin'it ajcxy ijxcajpy Jesús. Chi Jesús mɨc mɨ́cɨy yaj'ijxtɨgoy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chi ajcxy ñayñɨmaayɨ: ―¿Nej ca' yjánchɨty co ɨɨch ajt ooy njɨhuɨɨyɨm jotjoty huinma'ñjoty co anajty ajt jɨm xymɨɨdmɨydacɨm tü'am, etz co ajt xyñajtzcapxɨɨyɨm je huidi jaybety ma Dios ñecy? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","E tɨm huin'ítɨy ajcxy tübɨ́jccɨxy, chi ajcxy nɨ́cxcɨxnɨ jɨm Jerusalén. Ni'amugɨ' ajcxy paty je majctügpɨ Jesús ydiscípulos ajcxy e jacjadyii jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chi ajcxy mɨnaangɨxy: ―Janch yɨ' co tɨ yjugypɨcy je Huindzɨn Jesús, com tɨ oy ñayguëxɨ̈gyii ma Simón. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chi Cleofas nimɨydacy jadu'n nej tü'ay anajty ajcxy tɨ ñaybáatɨgɨxy mɨɨd Jesús, etz jadu'n nej ajcxy Jesús ijxcajpy co tzajcaagy tɨ tujc-huäcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jiiby anajty ajcxy tzachnimɨydaaccɨxy co Jesús oy ñayguëxɨ̈gyii ma je' ajcxy. Chi ytɨnay'ahuɨɨy cujc'amy ma je' ajcxy, chi ymɨnañ: ―Jotcugɨ' miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chi je' ajcxy ooy ñay'adzɨgɨyɨ ooy huinmaaygɨxy, hue' ajcxy tijy ijxmañɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chi Jesús nɨmay je' ajcxy: ―¿Na'amy co mjot mhuinma'ñ tɨ ytɨgoydaaygɨxy? ¿Nej co m'aa'ájtɨgɨxy mjot'ájtɨgɨxy pɨn ɨɨch? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ijxcɨx miich ajcxy ɨɨch ngɨ' ɨɨch ndecy, ɨɨch jënɨ ɨɨch. Nïdongɨch etz íjxcɨch ajcxy. Tüg espíritu ca' mɨɨdɨty chüch ni ypajc, jadu'n nej m'ijxcɨxy ɨɨch nmɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Co Jesús jadu'n ymɨnañ, chi ajcxy yaj'ijxy ycɨ' ytecy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per ca'nɨ ajcxy mɨbɨjcy mɨɨd co anajty ajcxy chachjotcújcɨty, chi Jesús ajcxy nɨmaayɨ: ―¿Mɨɨd ajcxy ti ii mgayɨpy? ");
INSERT INTO mcoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chi ajcxy moy Jesús acxtzäy, etz tüg jɨɨdy serpäg. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chi cöbɨjcy, chi ycaay y'uucy jɨm ma je' ajcxy yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Huin'it Jesús ymɨnañ: ―Huɨdi m'ijxyp cham je' je' huɨdi nyajnɨmay jayhuin, co ɨɨch miich ajcxy anajty mɨɨd'ijtcɨxy, co copɨcy nguydundähuɨbɨch jadu'n nej yjaybétyɨty ma je Moisés ñecy je jëcyɨp, etz jacjadyii Dios y'ayucnajtzcapxɨɨybɨ ñecy, etz yɨ salmo necy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Huin'it je' ajcxy yjot yhuinma'ñ ymiiñ ymejch, jaydëbɨ huinjɨhuɨ́ɨygɨxɨpy huɨdi jaybétyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Chi Jesús yjacmɨnañ: ―Jadu'n jaybety y'ity ma Dios ñecy co copɨcy co je Cristo paadɨp ayo'n e yjugypɨgɨpy codugɨɨg xɨɨ, maabɨ anajty y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Huen ajcxy yajcapxhuäcxy Dios ytɨy'ajt huindu'my naaxhuiñ, chondägɨp Jerusalén, co ooy ycopɨ́cyɨty huen jäy ajcxy jothuimbijtcɨx jaydëbɨ ajcxy paadɨp pocyhuinmeecxɨn. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Miich ajcxy nidɨy'ajt'adɨpy tüg'ócɨy jadu'n nej cham tɨ m'ijxcɨxy tɨ mnejhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jadachambɨ nguexɨpyɨch ma miich ajcxy je huɨdi nDeedyɨch tɨ xyaj'ahuanɨɨygɨxy. Huɨ'mgɨx ya Jerusalén ixtɨ coonɨ ajcxy xyñïdɨgɨ̈huɨp xycödɨgɨ̈huɨp je Dios yjɨhuɨ'ñ ymɨc'ajt huɨdi tzonam tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Huin'it xɨɨ Jesús mɨɨd tzoñ je' ydiscípulos ajcxy, chi ajcxy ycajppɨdzɨmy, ñɨcxy ajcxy mɨhuingon je Betania. Chi Jesús xajhuäcxy ycɨ' mɨbɨjctzoy Dios mɨɨd je ymɨgügtɨjc ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chi jadu'n yjajty ma anajty Dios mɨbɨjctzoy mɨɨd yɨ' ajcxy ycɨxpɨ, chi abɨcy yajhuɨ'mnɨ je' ajcxy e je' ypättɨgɨɨyñɨ jiiby tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chi yɨ' ajcxy jɨm yjac-huäcxɨjpy Dios ojadajtcɨxy. Chi ajcxy yhuimbijttaayñɨ jɨm Jerusalén janch jotcujc. ");
INSERT INTO mcoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chi ajcxy jabom jabom anajty ñɨcxcɨxy ma Dios ytɨjc chajpcapxycapxcɨxy, ojadajtcɨxy jäymejtzcɨxy yɨ Dios, Janch jadu'n jada. Amén.");
INSERT INTO mcoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Co naaxhuiñybɨ oga'n chondacy jiiyɨm anajty Dios y'ung, e yɨ' yajnejhuɨɨy jäy ajcxy Dios y'ayuc ytɨy'ajt. Dios y'ung tú'cɨy anajty yajpaady ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Je' tɨm oga'n'aty anajty yajpatp ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tüg'ócɨy huɨdijaty yaj'ijxp yajpatp ya naaxhuiñ, yɨ' yaj'oyɨyday yajcojtay. Tüg'ócɨy huɨdijaty Dios yajcojy, tú'cɨy ytuñ mɨɨd y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dios y'ung yɨ' jugy'ajtyejctaayb ma tüg'ócɨy naaxhuiñyjäy. Mɨɨd co jugy'ajtyejctäy ma tüg'ócɨy naaxhuiñyjäy, je' je' tɨy'ajt co Dios y'ung ymɨɨd Dios ymɨc'ajt. Jadu'n nipaady nej tüg jɨɨn huɨdibɨ jäy codɨɨcxp. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ya naaxhuiñ yajpaady anɨɨ. Yɨ anɨɨ jadu'n yɨ' nej coodzpɨ. Yɨ Dios y'ung tɨ mɨmiñ ya naaxhuiñ Dios y'ayuc ytɨy'ajt. Jadu'n Dios y'ayuc ytɨy'ajt ma jäy yjot yhuinma'ñ nej tüg jɨɨn ytɨɨcxy agoodztuuyb. Yɨ anɨɨ ca' ñaygodɨgɨ̈yii mɨɨd Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma'xung'ajt tüg yëydɨjc huɨdibɨ Dios anajty tɨ yajnïbɨcy. Hue' anajty yxɨɨ Juan. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yɨ' oga'n tɨy'ajt yejc co Dios ymɨc'ajt etz ytɨy'ajt yajpaady ma Dios y'ung, jɨgɨx tüg'ócɨy je jäy ajcxy camɨbɨjctähuɨpy je Dios y'ung. Dios y'ung jadu'n nipaady nej tüg jɨɨn huɨdibɨ codɨɨcxp ma jäy ytüyöy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Je Juan ca' je' anajty yjëjɨty je Cristo, je huɨdibɨ capxhuäcxp Dios y'ayuc ytɨy'ajt. Hue' janchtɨy je Juan ñidɨy'ajt'ajt je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Je Dios y'ung hue' je' ma'xung'ajty ya naaxhuiñ. Je' je' anajty je Dios ymɨc'ajt etz ytɨy'ajt ymɨɨd, je janchypɨ, ma jëb tüg'ócɨy jäy ya naaxhuiñ patcɨxy Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Je Dios y'ung ya anajty yhuɨdity naaxhuiñygɨ́xy. E jada naaxhuiñ yɨ' yaj'oyɨyday. E may je naaxhuiñyjäy ca' ajcxy ijxcajpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Je ymɨgügtɨjc, je judiojäy, je' ajcxy nimiinɨ, e may ajcxy je ymɨgügtɨjc ca' ajcxy ycöbɨjcɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tüg'ócɨy je jäy ajcxy pɨnjaty mɨjpɨdac yɨ' yxɨɨ yɨ' ymɨc'ajt, yɨ' ajcxy yajmoy Dios ymɨc'ajt, e jadu'n nipaty nejjɨhuɨ̈y ajcxy Dios y'ung'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Canan hue' je' co naydijɨɨyb Dios y'ung co tɨ yma'xung'aty jadu'n nej jäy ajcxy y'ocma'xung'aty. Nañ ni ca' yjadu'nɨty nej jäy tijy, nej jäy jɨjp'ixy, ni canan jäy jadu'n tɨ huinmay. Hue' janchtɨy Dios jadu'n tɨ huinmay. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Je Dios y'ung ya naaxhuiñ je' yma'xung'ajty mɨɨd ñinïcx etz chɨnay mɨɨd naaxhuiñyjäy. E ɨɨch ajcxy n'ijxɨch yɨ' y'oy'ajt etz ymɨc'ajt, jadu'n nej Dios Teedy y'ung tügpajc oy'ajt etz mɨc'ajt mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan ñidɨy'ajt'ajt je Dios y'ung, e chi capxypɨdzɨmy, e jadu'n ymɨnañ: ―Jada je' je jäy huɨdibɨ ɨɨch jadu'n nimɨydaacɨch ma miich ajcxy. Je huɨdibɨ miimb jac'axam ma ɨɨch, jac mɨc'ajt mɨɨd yɨ' ca'ydɨ ɨɨch, com jacjayɨjp yɨ' jugy'ajt paty ca'ydɨ ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Je Dios y'ung oy xychojcɨm xyjɨhuɨɨyɨm mɨjcajee, paady je' tuuñ may'ajt oy'ajt mɨjcajee mɨɨd ɨɨch ajt ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Com Dios y'ané'mɨn ycötujcɨn mɨcpɨ hue' Dios yajniguejx je Moisés. Co Dios quejxy Jesucristo ya naaxhuiñ, chi may'ajt oy'ajt tuñ mɨɨd je jäy ajcxy ycɨxpɨ, e nañ je' ytɨy'ajt yajniguejx je Jesucristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Je Dios ni camɨnaabɨ pɨn ca'ixyñɨ, je y'ung tügpajcɨ yajpatp ma Dios Teedy ity. Je Dios y'ung tɨ xyajnejhuɨɨyɨm nej Dios yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jadaabɨ je' je tɨy'ajt huɨdibɨ Juan yejc, co judío jäy ajcxy quejxy nijëjɨty teedytɨjc etz tzajptɨjc tungmɨɨdpɨ. Jɨm ajcxy chooñ Jerusalén nɨcxy ma anajty Juan yajpaady, chi ajcxy y'amɨdooy: ―¿Mbɨn miich? ¿Nej miich je' je Cristo huɨdibɨ Dios yquexamy? ");
INSERT INTO mcoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Je' ñigapx je tɨy'ajt, ca' ñaygoyützɨ, chi ymɨnañ: ―Ca' ɨɨch njëjɨty je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Chi ajcxy jac'amɨdoy: ―¿E pɨn miich mnaydijyii? Pen ca' mjëjɨty je Cristo. ¿Nej miich je' je Elías? Chi Juan y'adzooy: ―Ca' je' n'ɨɨchɨty. Chi ajcxy jac'amɨdooy: ―¿Nej miich je' je Dios y'ayuccapxhuäcxpɨ, je huɨdibɨ ñigapxy ma Dios ñecy co ymiinañ ya naaxhuiñ? Chi Juan y'adzooy: ―Ca'. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chi y'amɨdooy ajcxy jadüg'oc: ―¿Mbɨn miich? Jɨgɨx ɨɨch ajcxy tɨy'ajt nyajnɨ́cxɨbɨch ma yɨ tɨɨbɨ ɨɨch ajcxy xyquexyɨch. ¿Ti miich nayxɨɨgoyäxyii? ");
INSERT INTO mcoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chi Juan ymɨnañ: ―Ɨɨch je' je jäy huɨdibɨ Dios y'ayuccapxhuäcxɨp ma tüg mɨjtɨgɨ̈duum, tɨm jadu'n nej jiiby jaybety ymiiñ ma Isaías ñecy, nañ tɨm jadu'n ɨɨch nmɨna'ñɨch co copɨcy nayñi'ixɨ́ɨyɨgɨx ma yɨ mjot yɨ mhuinma'ñ, jëbɨ naybáatɨgɨxy mɨɨd mHuindzɨn Dios. Jadu'n nej jäy ixyipy tü'aa yaj'oyɨ̈y co tüg huindzɨn ymiina'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Je teedytɨjc etz tzajptɨjc tungmɨɨdpɨ huɨdibɨ oy mɨgapxy Juan, hue' anajty ajcxy fariseojäy tɨ yquexyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Chi ajcxy jactɨm'amɨdoy Juan: ―¿Ti miich co mjäyyajnɨɨbety? Penɨ ca' miich mjëjɨty je Cristo, ni mgajëjɨty je Elías, ni mgajëjɨty huɨdibɨ Dios y'ayuc najtzcapxɨɨyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Chi Juan y'adzooy: ―Ɨɨch hue' jäy nyajnɨɨbetyɨch mɨɨd nɨɨ. Ya naaxhuiñ ji tüg jäy huɨdibɨ miich ajcxy ca' m'ixy'adyii. Je' huɨdibɨ jac'axam mimb ma ɨɨch, je huɨdibɨ ca' mɨhuaadɨty nɨcxy yɨ' xytumbɨ'adyiijɨch, nɨcxyɨch ycɨ̈ghuin nguejɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jadu'n ytunɨ yjajtɨ jɨm Betábara, jɨm'amy ahuin ma Jordán mɨj nɨɨ, jɨm anajty Juan jäy yajnɨɨbety. Juan tɨy'ajt yejc co Jesús je' anajty yjugy'ajt yegam mɨɨd ɨɨch ajt nbocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chi je com jabom co ijxy Jesús anajty ñimiñyii, chi Juan nɨmay je jäy ajcxy: ―Cha je' ymiñ je Dios yjäy huɨdibɨ Dios nayyajhuindzɨgɨ̈huaanɨp mɨɨd naaxhuiñyjäy ajcxy ypocy ycɨxpɨ. Tɨm jadu'n nej judíojäy ajcxy Dios huindzɨgɨ̈y mɨɨd ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jada je' huɨdibɨ ɨɨch nnigapxypɨch co jac'axam ymiina'ñ ma ɨɨch tüg yëydɨjc huɨdibɨ nïgɨ Dios ymɨc'ajt y'oy'ajt mɨɨdɨty ca'ydɨ ɨɨch. Com jiiyɨm anajty yɨ' yjugy'aty co oga'n naaxhuiñybɨ chondacy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Oy ɨɨch anajty ca' yɨ' n'ixy'adyiijɨch huingɨ́xy jɨjpcɨ́xy, nyajnɨɨbejtɨch jäy, jɨgɨx yɨ judíojäy nejhuɨ̈huɨp ajcxy co ji yajpaady je Cristo je huɨdibɨ Dios ymɨc'ajt mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Chi Juan nigodɨy'ajt'ajty je Cristo co ymɨna'ñ: ―Ɨɨch tɨ n'ixyɨch yɨ Espíritu Santo jiiby choñ tzajpjoty, jadu'n yquëxɨ̈gy nej tüg muuxy, e chi y'ixtacy ma Jesucristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tɨydudägy ca' ɨɨch anajty n'ixy'adyiijɨch. Je Dios huɨdibɨ xyquejxɨch jäy yajnɨɨbejtpɨ, je' ɨɨch anajty jadu'n tɨ xyñɨmäyɨch co je jäy ma anajty n'ixyɨch je Espíritu Santo ñigɨdägyii anajty etz yhuɨ'my ma je'. Je' je' jadu'n anajty huɨdibɨ y'adɨgɨ̈huɨpy yjottɨgɨ̈huɨpy Dios yjɨhuɨ'ñ ymɨc'ajt ma je jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cham nnïgapxpetyɨch co ɨɨch tɨ n'ixyɨch je jäy, e nyejcpyɨch tɨy'ajt co je' je' je Dios y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chi je com jabom jopy jɨm anajty Juan yajpaady mɨɨd metz jäy huɨdibɨ ixpɨjcp ma yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chi anajty ajcxy tzachhuindɨcxy Jesús co anajty jɨm ñaxy, chi Juan nɨmay je metzpɨ jäy: ―Oc'ijxcɨx ocnejhuɨɨygɨx, cha je jäy huɨdibɨ Dios nayyajhuindzɨgɨ̈huaanɨp mɨɨd naaxhuiñyjäy ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","E je metzpɨ jäy huɨdibɨ anajty ajcxy ixpɨjcp ma Juan, co jadu'n ajcxy mɨdoy nej Juan ymɨnañ, chi ajcxy Jesús padzooñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chi Jesús y'ijxhuimbijty, chi ijxy co anajty ajcxy ypanɨcxyii, chi jada' nɨmay ajcxy: ―¿Ti ajcxy m'ixtaayb? Chi ajcxy y'adzooy: ―Huindzɨn, ¿ma tɨɨyɨ tɨ mja'ttägy? ");
INSERT INTO mcoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chi Jesús y'adzooy: ―Miingɨx, jɨgɨx ajcxy m'ixɨpy ma tɨ nja'ttägyɨch. Chi jada' ajcxy panɨcxy, e chi ajcxy ijxy ma anajty tɨ yja'ttägy. Je huin'it xɨɨmbɨ chi jɨm je' mɨɨd yhuɨ'mɨy, com mɨjmɨnacyxɨɨ anajty co ajcxy jɨm ymejch. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés, je Simón Pedro ymɨguëx, je' anajty tüg tzoonɨp huɨdibɨ nimetz ajcxy mɨdou jadu'n nej Juan ymɨnañ, etz je' anajty ajcxy tɨ padzooñ Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chi jada' Andrés oy ixtäy y'uch Simón tɨm jayɨjp, chi nɨmay: ―Tɨ ɨɨch ajcxy nbaady je Mesías ―jadu'n je ayuc Mesías yhuimbɨdzɨma'ñ Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chi Andrés mɨɨdnɨcxy Simón ma Jesús, e chi Jesús huindɨcxpejty, nɨmay: ―Miich je' Simón, Jonás miich xy'ung'ajtp. Miich je' mxɨɨ'adɨɨyb Cefas ―huɨdibɨ ayuc'amy huimbɨdzɨmb tzaa. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chi com jabom Jesús chooñ ñɨcxy jɨm Galilea, chi mɨnaybaatɨ Felipe, chi jadu'n nɨmay: ―Pajamgɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe jɨm anajty ycogajpɨty Betsaida, nañ je' je' je cajp ma anajty ajcxy ycogajpɨty Andrés etz Pedro. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chi Felipe mɨnaybaatɨ je jäy huɨdibɨyxɨɨ Natanael, chi jadu'n nɨmay: ―Tɨ ɨɨch ajcxy je' nbaadyɨch je jäy huɨdibɨ yajnigapxp yajnimɨydacp ma Moisés ñecy, etz yɨ Dios y'ayucnajtzcapxɨɨybɨ ñecy. Yɨ' je' je Jesús, José y'ung huɨdibɨ cogajpɨp jɨm Nazaret. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chi Natanael y'adzohuimbijty: ―¿Nej jɨm Nazaret tɨ choñ tüg oyjäyɨ? Com ac jadu'n jäy ymɨna'ñ co ac jɨbɨcjäydɨjc jɨm tzɨnaayb. Chi Felipe ymɨnañ: ―Jam cɨ'm octɨm'ix. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Co Jesús ijxy co Natanael ñimiñyii, chi jadu'n ymɨnañ: ―Cha tüg judíojäy huɨdibɨ ca' pɨn huin'ɨɨnɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chi Natanael ymɨnañ: ―¿Nej miich tɨ xy'ijxcapyɨch pɨn jäy ɨɨch? Chi Jesús nɨmay Natanael: ―Ca'nɨ anajty Felipe xyñɨmaayñɨ: “Jam íjxɨm je Jesús” co anajty miich jiiby'emy ma je higuerɨ quipypa't, huin'it ɨɨch miich tɨ n'ijxcapy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chi Natanael y'adzooy: ―Huindzɨn, miich je' Dios y'ung. Miich je' Rey'adam ma je judíojäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chi Jesús y'adzooy: ―Mɨɨd co tɨ nnɨmäy co jiiby'emy anajty miich ma je higuerɨ quipypa't co ɨɨch miich tɨ n'ijxcapy. ¿E tɨ mdɨmjanimɨbɨcy? Jactɨmmɨjhuinma'ñ etz jactɨmmɨj'oy'ajt m'ixamyb mbadamyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chi Jesús jadu'n ymɨnañ: ―Janch tɨm tɨy ɨɨch miich ajcxy yam jadu'n nɨmäy co m'ixɨpy ajcxy yɨ tzajp y'ahuäch etz Dios y'ángeles ajcxy chooñ tzajpjoty xyñigɨdägyɨch, e ypa'ttɨgɨɨygɨxy jadüg'oc tzajpjoty. Choongɨxy yja'tcɨxy ma ɨɨch je jäy huɨdibɨ tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mɨdugɨɨgxɨɨbɨ anajty maabɨ ajcxy Jesús mɨnaymɨgápxɨgɨxy, ma je cajp huɨdibɨ yxɨɨ Caná ma je Galilea naaxjot jɨm anajty huinxɨɨdungɨxy tüg jäy huɨdibɨ anajty tɨ ypɨcy. E jɨm anajty nañ jadu'n Jesús ytaj. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chi Jesús mɨɨd je' ydiscípulos ajcxy yajhuooy jɨm ma je xɨɨ anajty ytuñyii yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tɨ anajty vino ycɨjxtaayñɨ̃, huin'it Jesús ytaj ñɨmayñɨ: ―Ca'p ajcxy mɨɨdɨñ vino. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chi Jesús y'adzooy ytaj nɨmay: ―Ca' ti jotmay nmɨɨdɨdyɨch mɨɨd miich töxyäy. Ɨɨch nhorɨ ca'nɨ paady mɨna jäy ajcxy nyajnejhuɨ̈huɨbɨch pɨn ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chi je ytaj nɨmay je tumbɨdɨjc ajcxy: ―Mdúngɨxɨpy nej anajty ajcxy Jesús xyñɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jɨm anajty tudujc tzaadu'tz ma anajty nɨɨ y'ity. Je nɨɨ anajty ajcxy yajtumyb co anajty ajcxy ycɨ̈bujcɨxy jadu'n nej ypocy ixpujcɨxy, jadu'n anajty ajcxy judíojäy costumbre mɨɨdɨty. Tügpɨ tzaadu'tz ymɨɨd anajty yjot metz majt tugɨɨg majt nɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chi Jesús nɨmay je tumbɨdɨjc ajcxy: ―Yaj'ujtzcɨx yɨ tzaadu'tz mɨɨd nɨɨ. E chi ajcxy yaj'ujtztay mabaat y'a'ujtznaxy je tzaadu'tz. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chi Jesús ymɨnañ: ―Yajpɨdzɨmgɨx cham yɨ nɨɨ, e yajnɨcxcɨx jiiby ma huɨdibɨ ane'mb ma yɨ caydac uuctac. Chi ajcxy yajnɨcxy je nɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Co jada' je ane'mbɨ jɨhuɨymajch je nɨɨ tɨ anajty yvinocojy, chi mɨjhuoy je yëydɨjc huɨdibɨ anajty tɨ ypɨcy. Je ane'mbɨ ca' anajty nejhuɨ̈y ma anajty je vino tɨ choñ. Jëyɨ anajty je ytumbɨdɨjc ñejhuɨɨyb co nɨɨ anajty ajcxy yajpɨdzɨmgɨxy ma je tzaadu'tz. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Chi je ane'mbɨ nɨmay je huɨdibɨ anajty tɨ ypɨcy: ―Tüg'ócɨy jäy ajcxy huɨdibɨ xɨɨdumb, hue' ajcxy yajtumyb jayɨjp je vino oybɨ. E co jäy ajcxy ooy yxondaacnɨ, chi oyñihuɨdibɨ vino nɨɨ jacyajtungɨxy. Miich janchtɨy, tɨ m'amay'aty yɨ vinonɨɨ oybɨ ixtɨ chamnɨ myajtuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Je' je' je oga'nɨbɨ mɨjhuinma'ñ huɨdibɨ Jesús ytuun jɨm Caná ma Galilea ñaaxjot. Chi yajniguëxɨ̈gy je ymɨc'ajt etz y'oyjäy'ajt. E je huɨdibɨ anajty ajcxy yaj'ixpɨjcpy, chi ajcxy ooy mɨbɨjcy mɨjpɨdacy je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Co jadu'n tüg'ócɨy ytunɨ yjajtɨ, chi Jesús y'ɨdacy jɨm ma je cajp huɨdi yxɨɨ Capernaum mɨɨd ytaj etz y'uch ajcxy, etz huɨdibɨ anajty yaj'ixpɨjcpy. Jɨm ajcxy yhuäcxɨjpy tüg xɨɨ mejtz xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tɨm huingon anajty je pascua xɨɨ huɨdibɨ judío ajcxy ytumy jɨm Jerusalén, paady Jesús ñɨcxy jɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jɨm ma Dios ytɨjc Jesús paty je' huɨdibɨ anajty ajcxy ajuuybɨ adoocpɨ, jadu'n nej ma ymiiñ huaj, borregɨ, etz muuxy (huɨdibɨ jäy ajcxy Dios yajhuindzɨgɨɨyb). Nañ jɨm meeñyhuingogombɨdɨjc anajty ajcxy y'ɨñaaygɨxy ma ymesa. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chi Jesús yaj'oyɨɨy tüg cochac huojp. E chi ixhuojppɨdzɨmday je ajuuybɨ adoocpɨ ajcxy ma Dios ytɨjc ñihuaj etz ñiborrego. Chi yɨ meeñyhuingogombɨdɨjc ymeeñ cöxijtnajxtayɨ, e chi ymesa tijhuimbijttaayɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Chi nɨmay je muuxytoocpɨdɨjc ajcxy: ―Yajpɨdzɨmgɨx jada muuxy ya. Ca' ɨɨch nDeedy ytɨjc yhuaanɨ ajcxy ajuydac adooctac. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Je' ajcxy huɨdibɨ anajty Jesús yaj'ixpɨjcpy chi ajɨhuɨygootɨ ajcxy je ayuc, jadu'n nej jaybety ymiñ ma Dios ñecy: “Ooy ndzocy njɨhuɨ̈yɨch Dios ytɨjc, paady ooy nnijottɨgoyɨch Dios ytɨjc.” ");
INSERT INTO mcoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chi je judío ixpɨcytɨjc ajcxy y'amɨdooy Jesús: ―¿Ti mɨjhuinma'ñ miich xy'ocyaj'ixambɨch ajcxy nej tüg ijxpejt, pen janch mɨɨdɨty cötujcɨn co m'ixhuojppɨdzɨmdäy yɨ ajuuybɨ adoocpɨ ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chi Jesús y'adzooy: ―Yajhuindɨgooygɨx jada Dios ytɨjc, e codugɨɨg xɨɨ ɨɨch yɨ' jadüg'oc nyajpɨdɨ̈gɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chi jada' je judío ixpɨcytɨjc ajcxy y'adzooy: ―Huixchɨguïpx tudujc jɨmɨjt yhuäcxɨjpy co jäy cojy jada Dios ytɨjc. ¿E miich tijy myajpɨdɨ̈gamy codugɨɨgxɨɨjɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per ca' je' anajty nigapxy je Dios ytɨjc. Hue' je' anajty cɨ'm ñayñigapxyii co anajty y'öga'ñ, etz co yjugypɨgɨpy jadüg'oc codugɨɨg xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chi jada' co Jesús yjugypɨjcy codugɨɨg xɨɨ maabɨ anajty y'ögy, je huɨdibɨ anajty ajcxy tɨ yaj'ixpɨcy, ajɨhuɨygootɨ ajcxy huɨdibɨ Jesús anajty tɨ yajnɨmäyiigɨxy. Chi jada' ajcxy mɨbɨjcy ooy jadu'n nej anajty ycojaayɨty ma Dios ylibro, etz com nañ jadu'n anajty Jesús tɨ ymɨna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Co anajty Jesús yjɨmɨty Jerusalén pascua xɨɨjoty, mayjäy ooy ymɨbɨjcɨ co ajcxy ijxy je mɨjhuinma'ñ huɨdibɨ anajty ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús ca' anajty yjaty ñaygɨ̈yegyii ma je mayjäy ajcxy (hue' anajty ajcxy chachyajrey'adamy). ");
INSERT INTO mcoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Com Jesús ñejhuɨydaayb anajty nej jäy ajcxy nidüg nidüg yjot yhuinma'ñ mɨɨdɨty ca' tzocy pɨn yajnɨmähuɨɨyb ti anajty ajcxy ytunamy, com ñejhuɨydaayb nej jäy ajcxy yjot yhuinma'ñ mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jɨm anajty tüg yëydɨjc, fariseojäy y'ixpɨjcɨn anajty yajtuunɨpy. Hue' anajty yxɨɨ Nicodemo. Je' anajty ñigohuajc'ajtyp ma je judíojäy ajcxy ymiiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chi jada' Nicodemo ymiñ coodz ma Jesús anajty y'ity, chi nɨmay: ―Huindzɨn, nejhuɨɨyb ɨɨch ajcxy co miich tüg huindzɨn huɨdibɨ tzomb ma Dios. Com ca' ni pɨn jaty nej tunɨpy je mɨjhuinma'ñ huɨdibɨ miich mdumyb, pen ca' Dios ymɨc'ajt mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chi Jesús y'adzooy: ―Janch janch ɨɨch miich yam jadu'n nɨmäy, co ca' ni pɨn ixɨpy Dios y'it, pen ca' jadüg'oc yma'xung'ajttɨgach. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chi Nicodemo yajtɨy: ―Per, ¿nej tüg jäy tɨɨbɨ ymɨj'anäccɨɨyñɨ y'ocnima'xung'ajttɨgájtzpɨty jadüg'oc? ¿Nej jëbɨ jadüg'oc ytɨgɨ̈y ma ytaj y'aa yjot, e chi yma'xung'adɨty jadüg'oc? ");
INSERT INTO mcoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chi Jesús y'adzooy: ―Janch janch ɨɨch miich yam jadu'n nɨmäy pen ca' jäy yjothuimbity etz ñɨɨbety, pen ca' Dios yjɨhuɨ'ñ ymɨc'ajt y'adɨgɨ̈yii yjottɨgɨ̈yii, ca' jëbɨ ytɨgɨ̈y ma Dios chɨnäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Je jäy huɨdibɨ ajcxy ma'xung'ajtp ma töxyjäy, ymɨɨd ajcxy ñinïcx yjugy'ajtɨn. Je jäy ajcxy huɨdibɨ Dios yjɨhuɨ'ñ ymɨc'ajt adɨgɨɨyɨpy jottɨgɨɨyɨpy ymɨɨd ajcxy Dios yjugy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ca' nej mnayjɨhuɨ̈huɨɨyb co tɨ nnɨmäy co copɨcy mma'xung'adɨpy huinjemy, co Dios yjɨhuɨ'ñ ymɨc'ajt xy'adɨgɨ̈huɨpy xyjottɨgɨ̈huɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Com je poj miinɨɨyb hueñytɨmyma'amyɨty, e nmɨdoohuɨm co y'a'ɨɨch, e ca' nnejhuɨɨyɨm ma choñ e ma ñɨcxy. Jadu'n nej je poj ypojy e nganejhuɨɨyɨm ma choñ, nañ tɨm jadu'n yjaty mɨɨd je Espíritu Santo, ca' nejhuɨɨyɨm nej yjaty co adɨgɨ̈y jottɨgɨ̈y jäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chi Nicodemo yajtɨhuimbijty: ―¿Nej tijy co yjadu'nɨty? Ca' nhuinjɨhuɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chi Jesús y'adzooy: ―Miich huindzɨn'ajtp ma yɨ judíojäy, ¿ti co ca' mhuinjɨhuɨ̈y jadayaabɨ tɨy'ajt? ");
INSERT INTO mcoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Janch janch ɨɨch miich yam jadu'n nnɨmäy co ɨɨch etz nDeedɨch ngapxyp yɨ huɨdibɨ nejhuɨ́ɨygɨxypɨch, e nyejcpyɨch ajcxy tɨy'ajt yɨ huɨdijaty ɨɨch tɨ n'íjxcɨxyɨch. Miich ajcxy judío ixpɨcytɨjc ca' ajcxy mgöbɨjccɨxy ɨɨch ajcxy ndɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Pen ca' miich ajcxy mɨbɨjccɨxy jada tɨy'ajt huɨdibɨ njanimɨydacypɨch huɨdibɨ yajpatp ya naaxhuiñ, ca' ajcxy mmɨbɨgɨpy co njanimɨydägɨbɨch yɨ tɨy'ajt huɨdibɨ tzajpjoty yajpatp. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ca' ni pɨn tɨ y'oy tzajpjoty, ɨɨch je jäy tügpajc huɨdibɨ tɨ ndzoñɨch tzajpjoty, tɨ ngɨdägyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jadu'n nej Moisés yaj'oyɨy je pujx tza'ñ, e chi yajcruudzpety jɨm mɨjtɨgɨ̈duum jɨgɨx chögɨpy je jäy ajcxy ma je ahua'n ɨyujc chüchyii. Nañ tɨm jadu'n jäy ajcxy xyajcruudzpeda'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","E tüg'ócɨy jäy ajcxy pɨnjaty xymɨjpɨdaacpɨch, ca' yɨ' jugy'ajtɨn ycɨxy ytɨgooy ni mɨna. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ooy mɨjcajee Dios tzocy jɨhuɨ̈y yɨ naaxhuiñyjäy co yecy y'ung tügpajcpɨ mɨɨd jäy ajcxy ypocy ycɨxpɨ. Paady pɨnjaty mɨbɨjcp mɨjpɨdacp yɨ' y'ung, ca' yjugy'ajtɨn ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. Hue' janchtɨy y'alma ypaadɨpy tüg jugy'ajtɨn huɨdibɨ ca' ni mɨna ycɨxɨpy ytɨgoyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios ca' quejxy y'ung ya naaxhuiñ co tzaachytunɨpy yɨ naaxhuiñyjäy ajcxy mɨɨd ypocy ycɨxpɨ. Paady y'ung quejxy co yajpocyñïhuáatzcɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Je jäy ajcxy pɨnjaty mɨbɨjcp mɨjpɨdacp Dios y'ung, ca' ajcxy Dios chaachytunɨpy mɨɨd ypocy ycɨxpɨ. Je jäy ajcxy pɨnjaty ca' mɨbɨcy ca' mɨjpɨdägy Dios y'ung, pocycähuɨpy ajcxy ma Dios, co ca' mɨjpɨdacɨ ajcxy Dios y'ung tügpajcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Paady ycɨxpɨ Dios tzaachytuna'ñ mayjäy mɨɨd ypocy ycɨxpɨ, com co Dios quejxy y'ung mɨɨd ytɨy'ajt ya naaxhuiñ, e ca' ajcxy mɨbɨjcy Dios y'ung, jadu'n je' anajty nej tüg jɨɨn huɨdi codɨɨcxɨp jäy ajcxy ma chɨnaayɨn yjugy'ajtɨn. Per ca'p ajcxy je naaxhuiñyjäy mɨjpɨdacy je jɨɨn, jadu'n nej jɨhuɨ̈y ajcxy anajty yjacjotcujcɨty co chɨnaaygɨxy agoodztuuyb, com je' co nïgɨ tzachnijot'ajtcɨxy jɨbɨc-huinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Com je jäy ajcxy huɨdibɨ jɨbɨc-huinma'ñ tzach nijot'ajtcɨxp, ca' ajcxy tzojcɨ Dios ytɨy'ajt, jadu'n nej jɨhuɨ̈y ca' chɨnähuaangɨxy ma jɨɨn ytɨɨcxɨn. Ca' ajcxy y'amɨdoo'idanɨ Dios y'ayuc, ca'ydɨ ñiguëxɨ̈gy je jɨbɨcpɨ huɨdibɨ ajcxy ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Je jäy ajcxy huɨdibɨ cuydumb Dios ytɨy'ajt, je' ajcxy ñiminɨpy Dios y'ung ytɨy'ajt, jadu'n nej jɨhuɨ̈y jɨɨn nimiingɨxy ma ytɨɨcxy, huen jatyɨmy niguëxɨ̈gy co oy ytungɨxy etz co Dios ytɨy'ajt ajcxy mɨɨdɨty ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Co jadu'n ytunɨ yjajtɨ, chi Jesús ñɨcxy jɨm Judea naaxjot mɨɨd ydiscípulos ajcxy. Chi ajcxy jɨm yhuäcxɨjpy. Jɨm ajcxy jäy yajnɨɨbejty. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nañ jadu'n Juan anajty yjäyyajnɨɨbety jɨm Enón, com jɨm anajty ooy comnɨɨ, e jɨm anajty jäy ymingɨxy etz ñɨɨbejtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hue' jada jadu'n ytunɨ yjajtɨ ca'nɨ anajty je Juan pɨdaaccɨxy pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ca' ajcxy ñay'ayuc-huinjɨhuɨɨyɨ nijëjɨty huɨdibɨ anajty Juan yaj'ixpɨjcyp etz tüg jäy nej jëbɨ huaad ypocy ñayyajnïhuädzɨɨyb ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chi jada' ajcxy Juan nidzooñ, oy ajcxy paty, e chi ajcxy nɨmay: ―Huindzɨn, je jäy huɨdibɨ anajty miich jɨm mɨɨd jɨm'amy Jordán mɨjnɨɨnaxy, je huɨdibɨ miich anajty mnidɨy'ajt'ajtpy co je' je' je Cristo, nañ ooy chachjäyyajnɨɨbety. E janch mayjäy y'ocnimujcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chi Juan y'adzooy: ―Ca' ni pɨn ni ti mɨc'ajt mɨɨdɨty, pen ca' Dios ni ti mɨc'ajt ymöyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Miich ajcxy mnejhuɨɨyb co nmɨnaañɨch co ɨɨch ca' njëjɨty je Cristo. Hue' janchtɨy Dios xyquejxɨch jayɨjp co nnidɨy'ajt'adɨpyɨch je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Co jäy ypɨcy je yëydɨjc je' je' mɨɨd'idam je ytöxyɨjc. E je töxycapxpɨ huɨdibɨ tɨ yaj'oyɨ̈y je pɨjcɨn, ca' je' mɨɨd'ida'ñ je töxyjäy, jëyɨ co yjotcugɨ̈y co yöcmɨdoohuɨ je töxyjäy ñäy co yjädy ma je' ytɨjc co ypɨgaanɨ. Cristo jadu'n je' nipaady nej tüg töxyjäy ñäy, e je töxyjäy jadu'n je' nipaady nej Dios yjäy. Je Cristo ymɨɨd'idaanɨpy Dios yjäy. Jadu'n ɨɨch nipaady nej tüg töxycapxpɨ, tɨ Dios yjäy nyajni'ixɨɨyɨch jɨgɨx mɨjpɨdáaccɨxɨpy je Cristo. Jotcujcɨch cham co je Cristo tɨ ymiñ, e ñɨcxy yɨ jäy ajcxy ma yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ooy ytɨmycopɨcyɨty co Jesús ymɨj'ajt paatnɨpy, e ɨɨch ndung ycɨjxnɨpy ymayñɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Chi Juan yjacmɨnañ: ―Je Cristo huɨdibɨ jiiby tzoon ma Dios jacmɨj ixpɨjcɨn mɨɨdɨty ca'ydɨ naaxhuiñyjäy ajcxy. Je jäy ajcxy huɨdibɨ ya naaxhuiñ ijtp, ymɨnaaxhuiñyjäy tɨ yaj'ixpɨ́jcɨgɨxy, e je' ajcxy ñidɨy'ajt'ajtpy je naaxhuiñyjäy y'ixpɨjcɨn. Je Cristo tzoon jiiby tzajpjoty, jacmɨjcajee yɨ' ma y'ayuc ytɨy'ajt ca'dyɨ pɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Je Cristo ñigapxyp huɨdibɨ tɨ ixy e tɨ mɨdooy, e yɨ'y'ayuc ytɨy'ajt ca' jäy ajcxy cöbɨgaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Je jäy ajcxy huɨdibɨ cöbɨjcp Dios y'ung y'ayuc ytɨy'ajt, je' ajcxy nïgapxpejtyp co Dios ytɨy'ajt janch yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Je Jesús huɨdibɨ Dios yquejx, ca'pxy Dios ytɨy'ajt nïgapxpejtɨ, com Dios tɨ möy yɨ' y'ung yɨ' yjɨhuɨ'ñ ymɨcc'ajt mɨjcajee. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Teedy chojcyp yjɨhuɨɨyb y'ung, e tüg'ócɨy ymɨc'ajt ytɨy'ajt yɨ'tɨ yajmɨgo'ixɨɨydäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Je jäy ajcxy pɨnjaty mɨbɨjcp Dios y'ung, ymɨɨd'ajtpy ajcxy y'alma je jugy'ajtɨn huɨdibɨ ca' ycɨxy ytɨgooy. Je jäy ajcxy pɨnjaty ca' capxymɨdooy Dios y'ung, ca' ajcxy y'alma mɨɨd'adɨpy je jugy'ajtɨn huɨdibɨ ca' ycɨxy ytɨgooy. Je'yɨ ypaadɨpy ajcxy Dios chip y'ejcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chi je Huindzɨn Jesús ayuc mɨdoy jadu'n nej anajty je fariseojäy ajcxy ycapxcɨxy ymɨydaaccɨxy co je Jesús jacmayjäy anajty yaj'ixpɨcy etz yajnɨɨbety ca'ydɨ Juan. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Oy Jesús ca' anajty jäy yajnɨɨbety cɨ'm. Hue' janchtɨy je' ydiscípulos anajty ajcxy jäy yajnɨɨbejtp. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","E co Jesús jada nejhuɨɨy, chi jɨm Judea chonɨ, yhuimbijtnɨ jɨm Galilea. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Co yhuimbijty, hue' anajty yjatytɨmyñaxɨ̈hua'ñ jɨm Samaria. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chi jada' yja'ty huingon ma je mɨj cajp huɨdi xɨɨjɨp Samaria, jɨm ma anajty tüg pi'ccajp huɨdi xɨɨjɨp Sicar, mɨhuingon je naax huɨdibɨ Jacob anajty tɨ möy y'ung José. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jɨm anajty Jesús yajpaady ma je Jacob ñɨɨgondac. Com tɨ anajty Jesús y'anucxɨɨyñɨ mɨɨd je tüyöyɨɨ, chi y'ijxtacy jɨm ma je nɨɨgondac anajty. Hue' anajty xɨɨ jɨm cugɨ̈huaanɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chi jɨm yja'ty nɨɨgombɨ tüg töxyjäy. Chi Jesús ymɨnañ: ―Ɨɨch yajnɨɨ'uucc. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Com je' ydiscípulos ajcxy huɨdibɨ anajty Jesús yjaymɨɨd'ajtɨp, tɨ anajty ñɨcxcɨxy cajpjoty juuyb pɨjcp. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chi je töxyjäy y'adzooy huɨdibɨ anajty cogajpɨp Samaria: ―¿Na'amy co ɨɨch nɨɨ xypɨjctzoohuɨch? com miich hue' miich judíojäy, e samariajäy ɨɨch. (Co yɨ judíojäy etz samariajäy ca' ajcxy ñaygodɨgɨ̈yiigɨxy.) ");
INSERT INTO mcoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Huin'it Jesús y'adzooy: ―Co ixyipy m'ocnejhuɨ̈y je oybɨ huɨdibɨ Dios yejcyp mɨɨd miich ycɨxpɨ, e m'ocnejhuɨ̈y ixyipy nañ jadu'n pɨn xypɨjctzoohuɨpy yɨ nɨɨ, janch co miich ixyipy xyñɨmäyɨch: “Ɨɨch yajnɨɨ'uucc”. E ɨɨch miich ixyipy nmooyb nɨɨ huɨdibɨ jugy'ajt yegɨpy huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chi je töxyjäy y'adzooy nɨmay Jesús: ―Huindzɨn, miich ca' mmɨɨdɨty ti mɨɨd myajpɨdzɨmɨpy yɨ nɨɨ, e yɨ nɨɨjut cɨɨcy yɨ' ooy. ¿Ma tijy m'ocpada'ñ yɨ nɨɨ huɨdibɨ yajjugy'ajtp? ");
INSERT INTO mcoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Nej jacnïgɨ tijy miich mɨj mnayyajnaxyii, ca'ydɨ ɨɨch ajt n'ap ndeedy Jacob? Je'je' huɨdibɨ jada nɨɨgop yaj'oyɨɨy. Jacob etz y'ung y'anäg nɨɨ'uuc ma jada nɨɨgop, e nañ jadu'n yajnɨɨ'uucy yhuaj y'ɨyujc ajcxy ya. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chi Jesús y'adzooy nɨmay je töxyjäy: ―Tüg'ócɨy pɨnjaty nɨɨ'uucp ma jada nɨɨgop tɨdzɨ̈ huɨɨb ajcxy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yɨ jäy ajcxy pɨnjaty nɨɨ'uucp huɨdibɨ nmooybɨch, ca' ni mɨna ytɨdzɨ̈huɨɨyb, com hue' yɨ nɨɨ huɨdibɨ nyejcypɨch, ahuimbidɨpy ma je jäy jadu'n nej tüg nɨɨgop huɨdibɨ yegam jugy'ajtɨn huɨdibɨ ni ca' ycɨxy ytɨgoy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chi je töxyjäy y'adzooy: ―Huindzɨn, ɨɨch mooyg yɨ nɨɨ, ca'ydɨ jabom jabom ndɨdzɨ̈yiijɨch, e ca'ydɨ n'ocjacmíinɨbɨch ma jada nɨɨgop nɨɨ yajpɨdzɨmbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chi Jesús y'adzooy: ―Nɨcx yajtzon mñäy, e mɨɨd miin. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chi je töxyjäy y'adzooy: ―Ca' nmɨɨdɨdyɨch nñäyɨch. Chi Jesús y'adzooy: ―Janch tɨy'ajt jadu'n nej miich mɨna'ñ, co ca' mmɨɨdɨty mñäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Com tɨ mɨɨddzɨnäy mɨgoox yëydɨjc, e huɨdibɨ cham mmɨɨd, ca' mñäy'adyii. Janch tɨy'ajt jadu'n nej tɨ m'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chi je töxyjäy ymɨnañ: ―Huindzɨn, cham nhuinjɨhuɨ̈yɨch co miich je' tüg huɨdibɨ Dios yhuij'ajt ycujc'ajt mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɨɨch ajcxy n'ap ndeedyɨch hue' je' ymɨnañ co jëbɨ ya huaad ɨɨch ajcxy nDios'ojadájtcɨxyɨch ma jadayaabɨ huingombɨ copjɨjp. E miich ajcxy judíojäy ymɨnaangɨxy co jɨm Jerusalén je' ma huaad jëbɨ nDios'ojadajtɨm, ca' jac ma. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chi Jesús y'adzooy nɨmay je töxyjäy: ―Töxyjäy mɨjpɨdäg ɨɨch n'ayuc. Co ypadamy je xɨɨ je tiempo co ni ya ma miich ajcxy mDios'ojadajttac, e ni jɨm Jerusalén jäy ca' ojadadɨpy ajcxy yɨ Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Miich ajcxy ca' tɨy'ajt mnejhuɨɨygɨxy nej jëbɨ huaad mDios'ojadájtcɨxɨpy. Ɨɨch ajcxy judíojäy nejhuɨɨybɨch ajcxy je tɨy'ajt nej jëbɨ huaad nDios'ojadajtɨm. Com tüg judíojäy je huɨdibɨ yajnïdzooctähuam je jäy ajcxy y'alma ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ypadamy je xɨɨ je tiempo, e jada jëdu'n je tiempo co je huɨdibɨ ajcxy tɨydudägy Dios ojadajtp, y'ojadadɨpy ajcxy Dios mɨɨd oyjot oyhuinma'ñ etz mɨɨd Dios ytɨy'ajt. Com yɨ Dios Teedy y'ixtaayb yɨ jadu'mbɨ jäy huɨdibɨ ojadadɨɨb mɨɨd oyjot oyhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios ca' ñinïcx mɨɨdɨty, jadu'n je' nej poj ca' yaj'ixy. Je jäy ajcxy pɨnjaty ojadajtp Dios, copɨcy co huen ojadajtcɨxy mɨɨd tudägyjot tudägyhuinma'ñ, etz mɨɨd Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chi je töxyjäy ymɨnañ: ―Ɨɨch nejhuɨɨyb co je Mesías ymina'ñ huɨdibɨ naydijaanɨp Cristo, co je' yminɨpy, huin'it xyajni'ixɨ̈huaanɨm tüg'ócɨy tɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chi Jesús y'adzooy: ―Ɨɨch jëdu'n je Cristo huɨdibɨ miich mɨɨdmɨydacyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chi jada' yja'ty ajcxy Jesús ydiscípulos ajcxy. Chi ajcxy ooy jɨhuɨy ti anajty co Jesús je töxyjäy mɨɨdmɨydägy, e ni pɨn ca' yaj'amɨdooy ti anajty chojcyp ti anajty yñimɨydacyp mɨɨd yɨ töxyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chi je töxyjäy jɨm ymajt ixmajch, chi ñɨcxy cajpjoty oy mayjäy nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Mingɨx, jam tüg yëydɨjc ijxɨm. Tɨ ɨɨch yɨ' xyajnɨmaydäyɨch tüg'ócɨy tijaty tɨ nduñɨch. ¿Nej ca' jada' yɨ' jëjɨty je Cristo? ");
INSERT INTO mcoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chi choñ ooy mayjäy cajpjoty, ninɨcxy ajcxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yam anajty ajcxy Jesús ydiscípulos chachnɨmäyii adzip: ―Huindzɨn, occaay. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Chi Jesús y'adzooy: ―Ɨɨch nmɨɨdɨch tüg caayɨn uucɨn huɨdibɨ miich ajcxy ca' mnejhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Paady je' ydiscípulos ajcxy tzachhuinmay, ac jëyɨ ajcxy, nayñɨmayɨgɨxy miñ xɨpy: ―¿Nej tɨ pɨnjaty yajcayyii yaj'ügyii? ");
INSERT INTO mcoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chi Jesús ymɨnañ: ―Jotcujc nayjɨhuɨ̈yiijɨch co tɨ nguydunɨch Dios chojcɨn. Com yɨ' tɨ xyquexyɨch ya naaxhuiñ, e nguydúunɨbɨch yɨ' y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Miich ajcxy mɨnaangɨxp co jactɨgoy'ijtnɨ jamɨdaax po' mɨna cosecha nyajpɨdɨ̈cɨm. Oc-huinmay miich ajcxy, ɨɨch nmɨna'ñɨch, jëbɨ nyajpɨdɨ̈cɨm yɨ cosecha cham cham. Huindɨɨcxcɨx yɨ mayjäy huɨdibɨ xyñigɨdaacɨm chooñ cajpjoty. Ni'ixɨ̈ yɨ' ajcxy y'ity co amɨdo'idaangɨxy Dios y'ayuc. Jadu'n ajcxy nipaty nej tügɨ cosecha huɨdibɨ tɨ ymɨjaanɨ, jëbɨ nyajpɨdɨ̈cɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","E pɨnjaty cosecha yajpɨdɨ̈cp ypaatyp ajcxy ymuju'ñ. Nañ tɨm jadu'n miich ajcxy huɨdibɨ myajmɨbɨjcy yɨ jäy ajcxy co ɨɨch je' je Cristo, mbaadɨpy ajcxy jotcujc'ajtɨn, etz huɨdibɨ ajcxy xymɨbɨjcpɨch xymɨjpɨdaacpɨch ypadamy ajcxy y'alma jugy'ajtɨn huɨdibɨ ca' ycɨxy ytɨgooy. Tɨm jadu'n nej je jäy ajcxy huɨdibɨ niip etz huɨdibɨ cosecha yajpɨdɨ̈cp yjotcugɨɨygɨxy mɨɨd co je cosecha tɨ y'ity, nañ tɨm jadu'n je jäy ajcxy huɨdi cojaay jecy'ajty jada Dios y'ayuc etz miich ajcxy jotcugɨɨygɨxy aguipxy co yɨ jäy ajcxy xymɨjpɨdägyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Paady tɨy'ajt je ayuc huɨdibɨ mɨnam: “Tüg jäy niip etz jadüg jäy cosecha yajpɨdɨ̈cp.” ");
INSERT INTO mcoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ɨɨch tɨ nguexyɨch miich ajcxy myajmɨbɨgɨpy jäy huɨdibɨ tɨ paady Cristo ytɨy'ajt ma Dios ñecy. Yɨ Dios y'ayuc ycojaaybɨ tɨ möy je jäy Dios ytɨy'ajt, e miich ajcxy je' mbubedɨpy co myajmɨbɨgɨpy co ɨɨch je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mayjäy huɨdibɨ cogajpɨp jɨm Samaria ymɨjpɨdac ajcxy je Jesús co je' je' je Cristo, mɨɨd co je töxyjäy anajty tɨ ymɨna'ñ: “Tɨ yɨ' xyajnɨmaydäyɨch tijaty ɨɨch tɨ nduñɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Co je samariajäy ajcxy yjädy ma Jesús yhuinduu, chi ajcxy cohuanɨɨy huen huɨ'my. Chi Jesús jɨm yhuɨ'mɨɨy mejtz xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Janch mayjäy ooy nïgɨ mɨbɨjcy mɨjpɨdacy Jesús, co je' je' je Cristo co ajcxy cɨ'm mɨdomɨydacy je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chi ajcxy nɨmay je töxyjäy: ―Canan jëyɨ co miich tɨ xyajnɨmäy ɨɨch ajcxy, paady ycɨxpɨ ɨɨch ajcxy yam nmɨbɨcyɨch. Nañ tɨ ɨɨch ajcxy yam cɨ'm n'amɨdo'ityɨch, paady ɨɨch ajcxy nejhuɨ̈y co janch jada yjëjɨty je Cristo huɨdibɨ yajnïdzögam yɨ naaxhuiñyjäy ajcxy y'alma ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mɨmejtz xɨɨbɨ anajty co Jesús chooñ jɨm, nɨcxy jɨm Galilea. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús cɨ'm anajty tɨ ymɨna'ñ: ―Co jäy ajcxy huɨdibɨ mɨɨd Dios yhuij'ajt ycujc'ajt yajpaady ma ycɨ'mgajp, ca' pɨn yajmɨj'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Co Jesús yja'ty jɨm Galilea naaxjot, huɨdi anajty ajcxy jɨmɨp agujc jotcujc ajcxy cöbɨjcy Jesús, com tɨ anajty ajcxy ijxcɨxy tijaty mɨjhuinma'ñ anajty tɨ tuñ jɨm Jerusalén xɨɨjoty, com nañ tɨ je' anajty ajcxy jɨm y'oygɨxy xɨɨ'ajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chi yhuimbijty Jesús jadüg'oc jɨm Caná ma Galilea ñaaxjot, ma je nɨɨ yajvinocojy. Jɨm Capernaum anajty tüg rey mɨjtungmɨɨdpɨ huɨdibɨ anajty y'ung pɨ́jcɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Co je' nejhuɨy co Jesús anajty tɨ yhuimbity Galilea co anajty tɨ y 'oy Judea, chi ninɨcxy, e chi cohuanɨɨy co Jesús huen nɨcxy y'ung tzoyɨ̈yii huɨdibɨ anajty ögaanɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Huin'it Jesús ymɨnañ: ―Pen ca' ixyipy tɨ m'ixy mɨjhuinma'ñ etz tijaty ijxpejt, ca' ixyipy mmɨbɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chi y'adzoy je rey ymɨjtungmɨɨdpɨ: ―Huindzɨn, tun may'ajt ninɨcx ɨɨch n'ung ma ca'nɨ y'o'cyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chi Jesús ymɨnañ: ―Huimbit ma mdɨjc, je m'ung jugy'ajtnɨ je'. Chi je yëydɨjc mɨbɨjcy Jesús nej anajty tɨ ñɨmäyii, chi ñɨcxy jadüg'oc ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nɨcxnɨp anajty co ytumbɨ ajcxy oy yjɨjpcobadɨ̈yii, e chi ñɨmaayɨ co je' y'ung tɨ anajty y'agɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chi yaj'amɨdooy ajcxy ti hora anajty tɨ yhuaadjɨhuɨ̈y, chi ajcxy y'adzooy: ―Ɨxɨɨy cujc yxɨɨ naxy je toyɨɨ y'ixmajtznɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Paady je ungdeedy jɨhuɨ'ñybɨjcy co huin'it je' jada' je tiempo co anajty Jesús tɨ ñɨmäyii: “Je m'ung jugy'ajtnɨ je'.” Chi jada' mɨbɨjcy mɨjpɨdacy Jesús mɨɨd tüg'ócɨy jäy huɨdijaty anajty yajpat ma yjɨɨn ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Je' je' je mɨmetzpɨ mɨjhuinma'ñ mɨj'oy'ajt huɨdibɨ Jesús ytun co chooñ jɨm Judea ñɨcxy jɨm Galilea ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Co jadu'n ytunɨ yjajtɨ jɨm Jerusalén anajty ajcxy judíojäy tungɨxy tüg mɨjxɨɨ. Huin'it Jesús jɨm ñɨcxy jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","E jɨm Jerusalén jɨm anajty nɨɨ abojtzɨ̈g y'ity, mɨhuingon je poch aguu huɨdi xɨɨjɨp puerta de las ovejas. Je it hue' anajty yajtijy hebreo'amy Betesda, e ymɨɨd anajty mɨgoox it yhuinguembetpa't. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma je huinguembetpa't mayba'mjäy anajty jɨm chachcögnaaygɨxy; je huintzpɨ, cɨ̈ducp tecytucpɨ, cɨ̈xuxy tecyxuxypɨ, huɨdibɨ anajty ajcxy jɨm tzach'ahuijxp mɨna je nɨɨ y'ocpu'xhuimbity. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Com tüg ángel anajty yhuimbety y'adɨjy ma je nɨɨ abojtzɨ̈g y'ity, chi je nɨɨ yajyücxy. E je jäy pɨnjaty anajty jayɨjp jiiby nɨɨjoty tɨgɨɨyb co je nɨɨ yücxy, huin'it anajty ajcxy chooccɨxy, oy ixyipy ti pa'm ajcxy tɨm mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jɨm anajty tüg yëydɨjc hue' anajty tɨ ypa'mgögnäy iipx majmocx tugɨɨg jɨmɨjt. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Co Jesús ijxy jɨm ycögnäy, ijxcajpy co anajty je' jecyɨp chachmɨjtacnɨ, chi nɨmay: ―¿Nej mdzögambɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chi je pa'mjäy y'adzooy: ―Huindzɨn, ca' nmɨɨdɨdyɨch tüg yëydɨjc pɨn ɨɨch xypɨdägɨpy jiiby nɨɨjoty co anajty nɨɨ y'ahuɨdijtcoty. E paady ycɨxpɨ co oy ɨɨch jɨm njamechɨch ma yɨ nɨɨ, tɨ huingbɨ ñitɨgɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chi Jesús ymɨnañ: ―Pɨdɨ̈g, yajpɨdɨ̈g yɨ mmaabejt, etz tüyöychon. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chi mɨc'amy choocy, chi je' ymaabejt yajpɨdɨ̈gy ytɨgɨɨy yöybɨ najxpɨ janch mɨc oy. Hue' anajty tüg sábado xɨɨ co choocy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Paady je judíojäy ixpɨcytɨjc ajcxy nɨmay je huɨdibɨ anajty tɨ chögy: ―Hue' yam sábado xɨɨ, paady ca' jadu'n ñigo'aducyɨty jadu'n nej m'ɨdɨ̈ch co mmaabejt mdzɨmhuɨdity. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chi y'adzooy je': ―Je jäy tɨɨbɨ ɨɨch xyajtzögy, yɨ' ɨɨch jadu'n tɨ xyñɨmäy: “Yajpɨdɨ̈g yɨ mmaabejt etz tüyöychoon.” ");
INSERT INTO mcoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chi ajcxy y'amɨdooy: ―¿Pɨn miich jadu'n tɨ xyñɨmäy: “Yajpɨdɨ̈ yɨ mmaabejt etz tüyöychoon”? ");
INSERT INTO mcoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per je tɨɨbɨ anajty chögy, ca' anajty je' nejhuɨ̈y pɨn je' anajty. Com tɨ anajty Jesús niyöydɨgooyñɨ ma je mayjäy huɨdibɨ anajty ajcxy jɨm tzachjajtɨp ma je it. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chi jada' jaccomjecy mɨnaybaattɨ Jesús jɨm ma Dios ytɨjc, e chi Jesús ymɨnañ: ―Cuentɨpɨc nej tɨ mdzögy, ca' ni ti bocy mjactunɨpy. Co pocy mjactunɨpy ca' yjecyɨty co tɨm nïgɨ jɨbɨc nɨcxy mjaty. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chi je yëydɨjc ñɨcxy oy je' yajnɨmäy je judío ixpɨcytɨjc co hue' je' anajty Jesús, je huɨdibɨ anajty tɨ yajtzögyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Paady ycɨxpɨ je judío ixpɨcytɨjc anajty tzach'ixhuɨdijtcɨxy tzachpahuɨdijtcɨxy je Jesús, e yaj'ögaangɨxy mɨɨd co anajty jäy tɨ yajtzögy sábado xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Chi Jesús ymɨnañ: ―Ɨɨch nDeedy tumb je' cham, ca' ypoocxy, paady ycɨxp ɨɨch nañ jadu'n nduñɨch cham ma miich ajcxy sábado xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Co Jesús jadu'n ymɨnañ, paady ycɨxpɨ je judío y'ixpɨcytɨjc ajcxy nïgɨ yjacjtotma'tcoty, ytɨmy yaj'ögamy anajty aj y Jesús. Ca' ajcxy jadu'n yjotcujcɨty co anajty Jesús ca' cuyduñ judíojäy ajcxy ytɨy'ajt nej ajcxy sábado xɨɨ yajmɨj'ajtcɨxy, etz co jadu'n ymɨnañ: “Dios yɨ' nDeedy'ajtypɨch.” Paady ycɨxpɨ ajcxy judío y'ixpɨcytɨjc ymɨnañ co Jesús cɨ'm anajty ytügɨ̈hua'ñ mɨɨd Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chi Jesús ymɨnañ: ―Janch janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy co ɨɨch Dios nDeedy'ajtypɨch. Ca' huaad ti nduñɨch mɨɨd ngɨ'mjot ngɨ'mhuinma'ñɨch. Jëbɨ janchtɨy nduñɨch huɨdibɨ n'ijxpyɨch Dios Teedy ytumy. Huɨdibɨ Dios Teedy ytumyb, ndumybɨch com Dios yɨ' nDeedy'ajtypɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Com yɨ Dios Teedy ooy yɨ tzocy jɨhuɨ̈ ycɨ'm'ung, paady xyajni'ixɨydaaybɨch tüg'ócɨy yɨ huɨdibɨ ytumyb. E nañ xyajni'ixɨ̈huaambɨch jacmɨjjatypɨ mɨjhuinma'ñ, ca'ydɨ jadayaabɨ mɨjhuinma'ñ nej ajcxy tɨ m'ijxycɨxy nej jada pa'mjäy tɨ chögy, paady ycɨxpɨ nïgɨ mhuinmayɨpy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jadu'n nej Dios Teedy yajjugypɨcy yɨ o'cpɨ, e chi yajtzɨnäy jadüg'oc. Nañ jadu'n ɨɨch anajty ndɨmymöhuamyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Com je Dios Teedy ca' je' cɨ'm ocyajcɨ̈yöyaanɨ ocyajtecyyöyaanɨ jäy ajcxy ypocy. Hue' tüg'ócɨy je ymɨc'ajt xyajcɨ̈dɨgɨydaayɨch co ɨɨch ndɨydunɨpyɨch tüg'ócɨy naaxhuiñyjäy, com Dios nDeedy'ajtypɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Hue' tüg'ócɨy je ymɨc'ajt xyajcɨ̈dɨgɨydaayɨch, jɨgɨx tüg'ócɨy jäy xyajmɨj'adɨpyɨch. Je jäy ajcxy huɨdibɨ ca' xyajmɨj'ada'ñɨch, nañ ca' ajcxy yajmɨj'ada'ñ Dios Teedy huɨdibɨ xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Janch janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy: Co hueñypɨnjäyɨty, pɨnjaty xy'amɨdo'íjtɨbɨch n'ayuc, e ymɨbɨjcyp ymɨjpɨdacyp je tɨɨbɨ xyquejxyɨch ya naaxhuiñ, ymɨɨd je'je y'alma jugy'ajtɨn huɨdibɨ ca'ycɨxɨpy ytɨgoyɨpy, e ca' Dios Teedy chaachytuna'ñyii mɨɨd ypocy ycɨxpɨ. Hue' janchtɨy co y'ögɨpy, chi janchtɨy jadügtecy yjugypɨgɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Janch janch ɨɨch miich ajcxy jadu'n nɨmaaygɨxy co yɨ xɨɨ tiempo paatnɨpy, e cham jëdu'n tɨ paady, co yɨ jäy ajcxy tɨɨbɨ y'o'ccɨxy ymɨdohuɨpy yɨ n'ayucɨch, co anajty ngapxyɨch, com Dios yɨ nDeedy'ajtpyɨch. Pɨn jäy anajty mɨdoob n'ayucɨch jugypɨgɨp jadüg'oc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Com yɨ Dios Teedy mɨc'ajt mɨɨd jëbɨ yajjugypɨcy jäy tɨɨbɨ y'o'ccɨxy. Nañ Dios tɨ xymöyɨch ymɨc'ajt jëbɨ huaad nyajjugypɨcyɨch jäy tɨɨbɨ y'o'ccɨxy, com Dios ɨɨch nDeedy'ajtypɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tɨ Dios xymöyɨch ymɨc'ajt jëbɨ ndɨyduñɨch je jäy ajcxy mɨɨd ypocy ycɨxpɨ, com ɨɨch je' je jäy huɨdibɨ tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ca' ooy jada ayuc tɨy'ajt mhuinmaaygɨxy. Com ypaadɨpy je xɨɨ je tiempo co je huɨdijaty ajcxy yajpatp ma naaxtɨgɨydac, ymɨdohuɨpy ajcxy n'ayucɨch co ɨɨch anajty nmɨgapxyɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chi ypɨdzɨmɨpy ajcxy ma ñaaxtɨgɨy. Je' ajcxy huɨdibɨ anajty oybɨ tɨ tungɨxy, jugy'adɨp ajcxy y'alma jadüg'oc. Je' ajcxy huɨdibɨ anajty jɨbɨcpɨ tɨ tungɨxy ypaadɨpy ajcxy tzaachypɨ mɨɨd ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ca' ni ti huaad nduñɨch mɨɨd ngɨ'mmɨc'ajtɨch ngɨ'm'ayucɨch. Je ayuc tɨy'ajt huɨdibɨ nmɨdooybɨch ma Dios Teedy, jada ayuc tɨy'ajt mɨɨd nyajcɨ̈yöya'ñɨch nyajtecyyöya'ñɨch jäy ajcxy ypocy. Jadu'n tɨydudägy nduna'ñɨch, com ca' ɨɨch nduñɨch ngɨ'mdzójcɨnɨch. Yɨ' ɨɨch ndumyb nej Dios Teedy tzocy, yɨ huɨdibɨ xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Co ixyipy ɨɨch cɨ'm nayñigodɨy'ajt'adyiijɨch, ca' ixyipy miich ajcxy mmɨjpɨdägy n'ayuc ndɨy'ajtɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Com huingbɨ yɨ' huɨdi xyñigodɨy'ajt'ajtpɨch co ɨɨch Dios ymɨc'ajt nmɨɨdɨdyɨch, e nejhuɨɨybɨch co janch yɨ' huɨdibɨ xyñigodɨy'ajt'ajtpɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Miich ajcxy tɨ mguexy je mɨgügtɨjc ajcxy tɨy'ajtpɨjcpɨ ma Juan. E je' yejc tɨydudägy ayuc tɨy'ajt janchypɨ pɨn ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Co jadu'n nmɨna'ñɨch co Juan xyajnidɨy'ajt'atyɨch co ɨɨch je' je Cristo, ca' jadu'n nmɨna'ñɨch co ooy ycopɨcyɨty co tüg jäy xyñidɨy'ajt'adɨpyɨch. Com Dios cɨ'm xyñidɨy'ajt'ajtpɨch. Jadu'n ajcxy nyajnɨmäy jada tɨy'ajt, jɨgɨx ajcxy m'alma nïdzoocɨn paadɨpy ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Je Juan mɨctägy ooy Dios y'ayuc najtzcapxiɨyɨ, jadu'n je' anajty nej tüg jɨɨn huɨdibɨ tɨɨcxp jajp, e miich ajcxy tüg jaxɨ̈gyɨ tɨ mxondaaccɨxy mɨɨd yɨ' y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nïgɨ ɨɨch Dios y'ayuc ytɨy'ajt nmɨɨdɨdyɨch ca'ydɨ Juan. Yɨ mɨjhuinma'ñ huɨdibɨ ndumybɨch mɨɨd Dios Teedy ymɨc'ajt. yɨ' xyajniguëxɨ̈gɨbɨch co ɨɨch ya naaxhuiñ Dios Teedy xyquejxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yɨ Dios Teedy tɨɨbɨ xyquexyɨch, yɨ' cɨ'm yejc tɨy'ajt co ɨɨch je' je Cristo. E ni camɨnaabi miich ajcxy yɨ' mgamɨdoohuɨ ycapxɨn, nañ ni camɨnaabɨ miich ajcxy Dios Teedy yhuiñyjɨjp maga'ijxɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ni ca' miich ajcxy mmɨɨdɨty yɨ' y'ayuc ma mjot mhuinma'ñ, mɨɨd co miich ajcxy ca' xymɨjpɨdägyɨch co ɨɨch je' je jäy huɨdibɨ Dios tɨ quexy ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ijxtaaygɨxy jada tɨy'ajt ma Dios ylibro, com jiiby mdijy miich ajcxy mbaadɨpy tɨy'ajt nej jëbɨ ajcxy mjugy'adɨpy co anajty tɨ m'o'ccɨxy, e yɨ Dios ylibro nañ ɨɨch yɨ' xyñigapxp. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","E ca' miich ajcxy mgöbɨgaangɨxy ɨɨch n'ayuc ɨɨch ndɨy'ajt, jɨgɨx ajcxy jugy'ajtɨ mbaadɨpy huɨdibɨ ca' ycɨxy ytɨgooy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Dios xycömayɨpyɨch, ca' ngöbɨgɨpyɨch co naaxhuiñyjäy ajcxy xycömayɨpyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nnejhuɨɨybɨch, nej miich ajcxy mjot mhuinma'ñ mmɨɨdɨty, co ca' ajcxy Dios ytɨy'ajt mguyduunɨ. Ca' ajcxy mɨgüg mdzojccɨxy mjɨhuɨɨygɨxy jadu'n nej Dios tzocy jɨhuɨ̈y jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɨɨch tɨ nmiiñɨch mɨɨd nDeedyɨch ymɨc'ajt. Miich ajcxy ni ca' xycöbɨcyɨch. Pen ji huingbɨ jäy ymiiñ mɨɨd ycɨ'mmɨc'ajt, ca' mɨɨdɨty Dios ymɨc'ajt, je' janchtɨy miich ajcxy ooy mɨjpɨdägaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ca' mjájtcɨxɨpy nej ɨɨch miich ajcxy xymɨjpɨdägɨbɨch, mɨɨd co ajcxy cɨ'm mdzachnaygömayáanɨgɨxy ac miich ajcxy jëyɨ. E co ixyipy miich ajcxy xycöbɨga'ñɨch, huin'it ajcxy Dios xycömayɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ca ajcxy mmɨna'nɨpy co ɨɨch miich ajcxy nxɨ̈huaamy ma Dios Teedy yhuinduu. Je Moisés miich ajcxy yxɨ̈huam ma Dios, je huɨdibɨ miich ajcxy mdzachmɨjpɨdaacɨp ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pen mmɨjpɨdaacyp ixyipy ajcxy je Moisés y'ayuc ytɨy'ajt, nañ jadu'n ixyipy ɨɨch miich ajcxy xymɨjpɨdägyɨch. Com Moiseś ɨɨch yɨ' xychachñimɨydaacɨch ma yɨ' ñecy. ");
INSERT INTO mcoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pen ca' mmɨjpɨdaaccɨxy Moiseś ñecy, ca' mjájtcɨxɨpy nej ajcxy mɨjpɨdáaccɨxɨpy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Co jadu'n ytunɨ yjajtɨ, chi Jesús ñɨcxy jɨm Galilea mejy nïnaxy, huɨdibɨ nañ jadu'n xɨɨjɨp Tiberias mejy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Janch mayjäy anajty Jesús ypanɨcxyii axam co anajty ajcxy ixy je mɨjhuinma'ñ tijaty anajty Jesús ytumyb ma mayba'mjäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chi Jesús ypejty ma tüg cögop, chi jɨm y'ixtacy mɨɨd je' ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tɨm huingonɨp anajty je pascuaxɨɨ huɨdibɨ anajty judíojäy ajcxy ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chi Jesús ijxy co janch mayjäy tɨ ypamiinyii, chi nɨmay Felipe: ―¿Ma jada' caayɨn uucɨn n'ocjuyɨm, ti nyajcaayɨm jada mayjäy huɨdibɨ tɨ xypamiinɨm? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hue' anajty y'oc'ijxmadzamy nej Felipe y'oc'adzooy. Jesús anajty ñejhuɨɨyb yajxon ti anajty ytunamy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chi Felipe y'adzooy: ―Ni ycahuaadɨ̈huɨp mejtz mil peso meeñ, co ixyipy ajt n'ocjuyaanɨm caayɨn uucɨn, e nmöhuaanɨm cɨjp tüg'aa cɨjp mejtz'aa jëyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tüg Jesús ydiscípulo, hue' anajty yxɨɨ Andrés, Simón Pedro y'uch, je' jadu'n nɨmay Jesús: ");
INSERT INTO mcoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Cha tüg pi'c'anäg huɨdibɨ mɨɨd mɨgoox cebada tzajcaagy, e mejtz acx ung. E ni ycatiijɨty yɨ' yɨ mɨgooxpɨ tzajcaagy, etz mejtz acx ung mɨɨd jada mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chi Jesús nɨmay je' ydiscípulos ajcxy: ―Yaj'ixtacta' yɨ mayjäy. Mɨɨyjot anajty ooy ma je it. Chi ajcxy y'ixtactay. Hue' jada' anajty ajcxy ñaybadyii mɨgoox mil ac yëydɨjctɨjc, abɨcy yɨ töxyjäydɨjc etz y'ung y'anäg ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chi Jesús je tzajcaagy conɨ̈gy, chi yajnajxy Dioscojuyip, chi yajnigɨdagɨɨyday je jäy ajcxy huɨdijaty anajty jɨm ɨñaayb, mooy jadu'n nej pɨn tɨm tzocy je tzajcaagy etz je acx. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Co je mayjäy cayday, chi Jesús nɨmay je' ydiscípulos ajcxy: ―Yajmujcta' ajcxy yɨ cayduc, ca'ydɨ huaad ni ti y'ɨyoy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chi ajcxy yajmujctay je cayduc, e yaj'ujch ajcxy majmetz mɨjjaty cach mɨɨd je tɨɨbɨ anajty yconaxy je mɨgooxpɨ tzajcaagy. Je' anajty jadu'n tɨ yjacconaxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Co ajcxy y'ijxy je mɨjhuinma'ñ huɨdibɨ anajty Jesús tɨ tuñ, chi je jäy ajcxy ymɨnañ: ―Janch jëdɨm jada je yëydɨjc huɨdibɨ Dios y'oy'ajt ymɨc'ajt mɨɨd, je huɨdibɨ anajty miinam ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Co Jesús nejhuɨy co ajcxy anajty yajrey'ada'ñyii, chi jada' jadüg'oc huinhuäctuttay je mayjäy. Chi ñɨcxy naydüg ma tüg yuugjot. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Co oy chu'ɨɨyñɨ, chi Jesús ydiscípulos ajcxy y'ɨdaacnɨ ma mejypa'. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chi ajcxy ybarcotɨgɨɨy, ñɨcxy ajcxy jɨm Capernaum jadügpɨ mejypa'. E tɨ anajty ycoodzɨɨyñɨ, e ca'nɨ anajty Jesús ajcxy ñihuimbidyiinɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chi tüg mɨjpoj ymiñ, chi je mejy ytɨgɨɨy oy yücxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tɨ anajty ajcxy ytüyöy oy mɨgoox tudujc kilómetro co ajcxy ijxy Jesús yhuingoñ ma je barco, hue' anajty ytüyöy mejyhuingɨ́xy. Chi ajcxy ooy ñay'adzɨgɨɨyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chi Jesús ymɨnañ: ―Ɨɨch yɨ', ca' mdzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chi ajcxy jotcujc Jesús yajbarcotɨgɨɨy. Chi tɨm mɨc'amy ajcxy ymejch jɨm ma mejypa' ma anajty ajcxy ñɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Je mayjäy huɨdibɨ anajty ajcxy tɨ yhuɨ'mɨ̈y jɨm'amy y'ahuin, y'ijx ajcxy co ac jëyɨ Jesús ydiscípulos ajcxy ytɨgɨɨy ma tüg barco, e Jesús ca' anajty tɨ ytɨgɨ̈y barcojoty mɨɨd je' ajcxy. Ac jëyɨ anajty ajcxy tɨ choongɨxy barcojoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Je com jabom nijejɨty barco huɨdibɨ anajty jɨm tzomb Tiberias, tɨ anajty yjädy mɨhuingon ma je it, ma anajty Jesús tɨ yajcaaygɨxy je mayjäy mɨɨd je Huindzɨn Dios ymɨc'ajt, huin'it co Dios mɨbɨjctzoy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chi je mayjäy ajcxy ijxy co ca' anajty jɨm Jesús, ni ca' anajty jɨm je' ydiscípulos ajcxy. Chi ajcxy ybarcotɨgɨyday, chi ajcxy oy ixtaaygɨxy Jesús jɨm Capernaum. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Co ajcxy mɨnaybaatɨ Jesús mejy ñïnaxy, chi ajcxy nɨmay: ―Huindzɨn, ¿mɨna miich ya tɨ mmiñ? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chi Jesús y'adzooy nɨmay je mayjäy ajcxy: ―Janch janch co ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy co miich ajcxy xy'ixtaaybɨch, canan yɨ' ycɨxpɨ co ajcxy tɨ m'oc'ixy yɨ mɨjhuinma'ñ huɨdibɨ tɨ nduñɨch, paady ycɨxpɨ miich ajcxy xy'ixtäyɨch co ajcxy nyajcay cüxyɨ mɨɨd tzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Chi Jesús yjacmɨnañ: ―Ca' myajjotmaygojcɨxy yɨ jɨɨcxy pɨcy huɨdibɨ cɨjxp tɨgooyb. Yɨ' janchtɨy mɨjottɨgooygɨxy yɨ jɨɨcxy pɨcy huɨdibɨ xymöhuɨpy yɨ jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. Ɨɨch miich ajcxy je jugy'ajtɨn nmöhuɨbɨch huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ, com ɨɨch je' je jäy huɨdibɨ tzoon tzajpjoty, e Dios Teedy xymɨc'ajtmooyɨch, jëbɨ ɨɨch miich ajcxy nmöy jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chi ajcxy nɨmay Jesús: ―¿Ti ɨɨch ajcxy jëbɨ huaad nduñ, nej jëbɨ ɨɨch ajcxy Dios xymɨjotcujc'aty? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chi Jesús y'adzooy: ―Dios chojcpy co miich ajcxy xymɨbɨcyɨch, com Dios xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chi ajcxy nɨmay Jesús: ―¿Ti ijxpejt mdunamy mɨɨd ɨɨch ajcxy, jëbɨ ɨɨch ajcxy n'ixɨpy Dios ymɨc'ajt etz ɨɨch ajcxy nmɨbɨgɨpy co miich je' je Cristo? ¿Ti mɨjhuinma'ñ mdunamy? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ɨɨch ajt nmɨj'ap nmɨjteedy ajcxy jecy'ajty yjɨɨcxy pɨjc ajcxy je maná jɨm ma tɨ̈tznaax'it. Jadu'n ymiñ jaybety ma jadu'n ymɨna'ñ: “Dios yejcpy jɨɨcxy pɨcy huɨdibɨ tzoon tzajpjoty.” ");
INSERT INTO mcoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chi Jesús y'adzooy: ―Janch janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy co canan je' je' je Moisés huɨdibɨ miich ajcxy xymooyb je jɨɨcxy pɨcy janchypɨ huɨdibɨ tzomb tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Je jɨɨcxy pɨcy huɨdibɨ Dios yejcyp huɨdibɨ tzomb tzajpjoty, je' je' huɨdibɨ jugy'ajtɨn moy je naaxhuiñy-jäy huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chi ajcxy nɨmay Jesús: ―Huindzɨn, ɨɨch ajcxy mooyg je jɨɨcxy pɨcy janchypɨ jabom jabom huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chi Jesús ymɨnañ: ―Ɨɨch jëdu'n je jɨɨcxy pɨcy huɨdibɨ miich ajcxy xymöhuɨp jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. Co jäy ajcxy xyñimiinɨch, e xymɨjpɨdägyɨch, huin'it ca' yɨ' ajcxy yuböccoda'ñyii nimɨnaxɨɨ, e co jäy ajcxy xymɨbɨcyɨch, ca' yɨ' ajcxy ytɨdzɨ̈hua'ñyii nimɨnaxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Com tɨ ɨɨch miich ajcxy nɨmäy, oy ɨɨch miich ajcxy tɨ xyja'ijxycɨxy, per ca' mɨbɨjccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tüg'ócɨy pɨnjaty ɨɨch nDeedy yquexyp ma ɨɨch, xyñimimbɨch yɨ' ajcxy. E pɨnjaty xyñimimbɨch etz xymɨjpɨdaacpɨch, ca' ɨɨch yɨ' ajcxy n'ixtijy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Canan paady ycɨxpɨ ɨɨch tɨ ndzooñ tzajpjoty ngɨdägɨch ya naaxhuiñ co nduna'ñɨch ngɨ'mhuinma'ñ. Hue' janchtɨy yɨ' ndunaamyɨch nDeedyɨch y'ayuc ytɨy'ajt, com yɨ' xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yɨ' jadu'n tzojcp ɨɨch nDeedy huɨdibɨ xyquejxɨch ya, co ɨɨch ca' ni pɨn nyajtɨgoyɨpyɨch, yɨ huɨdijaty xymooybɨch. Hue' janchtɨy yɨ' ajcxy nyajjugypɨgɨpyɨch jadüg'oc co anajty naaxhuiñybɨ tɨ yhuaad'ajtnɨ mɨna ytɨgadzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dios Teedy tɨ xyquexyɨch ya naaxhuiñ e yɨ' jadu'n tzojcp co pɨn jäy ɨɨch anajty xy'ijxpɨch, e xymɨjpɨdaacpɨch, ymɨɨd'adɨpy je' ajcxy jugy'ajtɨn huɨdibɨ ca' tüccɨ'y ycɨxɨpy ytɨgoyɨpy. Hue' janchtɨy nyajjugypɨgɨpyɨch ajcxy jadüg'oc co anajty je naaxhuiñybɨ tɨ yhuaad'ajtnɨ mɨna anajty ytɨgadza'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chi je judíojäy ajcxy ooy yajtzibɨɨy yajcapxɨɨy co anajty Jesús jadu'n tɨ ymɨna'ñ: “Ɨɨch je' je jɨɨcxy pɨcy huɨdibɨ tzoon tzajpjoty.” ");
INSERT INTO mcoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jadu'n anajty ajcxy chachmɨna'ñ: ―¿Nej ca' je' yjadaajɨty je Jesús, je José y'ung, je huɨdibɨ ajt ytaj yteedy n'ixy'ajtɨm? ¿Nej co jadu'n ymɨna'ñ: “Ɨɨch tɨ ndzooñɨch tzajpjoty”? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chi Jesús y'adzooy: ―Ca' myajtzibɨɨygɨxy myajcapxɨɨygɨxy ac miichɨy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni pɨn jäy xycaniminɨpyɨch, pen ca' jayɨjp Dios Teedy huinma'ñ ymöyii co xymɨjpɨdägɨbɨch. E co xymɨjpɨdägɨbɨch, chi nyajjugypɨgɨpyɨch jadüg'oc co anajty naaxhuiñybɨ tɨ yhuaad'ajtnɨ mɨna ytɨgadzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Com jadu'n ymiiñ jaybety ma Dios ñecy huɨdibɨ je jäy ajcxy anajty Dios ytɨy'ajt mɨɨd huɨdibɨ jecy'ajty yjaay co Dios yaj'ixpɨgamy je jäy ajcxy tüg'ócɨy. Paady ycɨxpɨ tüg'ócɨy jäy huɨdibɨ mɨdoob Dios y'ayuc etz y'ixpɨjcyp Dios ytɨy'ajt xymɨjpɨdägɨbɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ca' ni tüg jäy tɨ ixy yɨ Dios Teedy. Jëyɨ je jäy tügpajc huɨdibɨ tɨ choñ ma Dios, yɨ' je' tɨ ixy yɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Janch janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy co pɨnjaty xymɨbɨjcpɨch xymɨjpɨdaacpɨch, ymɨɨd yɨ' ajcxy yjugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɨɨch jëdu'n je jɨɨcxy pɨcy huɨdibɨ jugy'ajt mooyb je jäy huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Miich ajcxy mmɨj'ap mmɨjteedy yjɨɨcxy'ajtɨ ycaagy'ajtɨ ajcxy je maná jɨm tɨ̈tznaaxtuum'it jecy'ajty. E chi ajcxy y'o'ctay. E ni ca' ajcxy jugy'ajtɨn paty huinɨxɨɨbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Je jɨɨcxy pɨcy huɨdibɨ nnigapxypɨch huɨdibɨ tzoon tzajpjoty, co jäy ajcxy jɨɨcxɨpy, ymɨɨd'adɨpy ajcxy je jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɨɨch jëdu'n je jɨɨcxy pɨcy huɨdibɨ tɨ chooñ tzajpjoty, etz tɨ ycɨdägy ya naaxhuiñ huɨdibɨ jugy'ajtɨn yejcp. Co jäy ajcxy jɨɨcxyp je jɨɨcxy pɨcy, ymɨɨd'adɨpy ajcxy je jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. Je jɨɨcxy pɨcy huɨdibɨ nyegaamyɨch mɨɨd naaxhuiñyjäy ajcxy ycɨxpɨ, je' je' je nninïcxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chi je judío y'ixpɨcytɨjc ajcxy ooy yaj'ayucyooñ yajcapxyooñ, ac je'yɨ ajcxy ñayñɨmáayɨgɨxy: ―¿Nej jada yëydɨjc tijy yɨ' ñinïcx njɨɨcxy'ajtɨm? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chi Jesús ymɨnañ: ―Janch janch co ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy, pen ca' miich ajcxy mdzüdzcɨxy ɨɨch nninïcx, e pen ca' m'uuccɨxy ɨɨch nnɨ'py, ɨɨch je jäy tügpajc huɨdibɨ tzoon tzajpjoty, ca' miich ajcxy mɨɨd'adɨpy yɨ Dios yjugy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Com pɨnjaty ɨɨch nninïcx xychu'tzɨp etz ɨɨch nnɨ'py xy'uucɨbɨch, ca' je ajcxy yjugy'ajtɨn ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ, oy ajcxy yja'o'ccɨxy. Nyajjugypɨgɨpyɨch je' ajcxy jadüg'oc co anajty naaxhuiñbyɨ tɨ yhuaad'ajtnɨ mɨna ytɨgadzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ɨɨch nninïcx janchypɨ jɨɨcxy pɨcy yɨ', etz ɨɨch nnɨ'py janchypɨ ügy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Co yɨ jäy ajcxy xymɨbɨcyɨch xymɨjpɨdägyɨch jadu'n ni paady nej jɨhuɨ̈y ɨɨch nninïcx xychüdzɨ, etz ɨɨch nnɨ'py xy'uucɨ. Chi y'idɨpy ajcxy huinɨxɨɨ ma ɨɨch, etz ɨɨch n'idɨpyɨch huinɨxɨɨ ma je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Dios Teedy huɨdibɨ xyquejxɨch ya naaxhuiñ ymɨɨd jugy'ajtɨn huɨdibɨ ca' ycɨxy ytɨgooy. Ɨɨch tɨ nbaadyɨch ma Dios Teedy je jugy'ajt huɨdibɨ ca' ycɨxy ytɨgooy. Nañ mbadamy miich ajcxy jugy'ajtɨn huɨdibɨ ca' ycɨxy ytɨgooy ma ɨɨch. Co miich ajcxy xymɨjpɨdägɨbyɨch, jadu'n anajty nipaady nej jɨhuɨ̈y mjɨɨcxy'ajtɨgɨxy ɨɨch nninïcx. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Je jɨɨcxy huɨdibɨ tzoon tzajpjoty, e ycɨdacy ya naaxhuiñ co jäy ajcxy jɨɨcxy'adyii, yajtzɨnähuɨɨb je ajcxy, ca' ajcxy yjugy'ajtɨn ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. Yɨ mmɨj'ap mmɨjteedy huɨdibɨ jɨɨcx'ájtɨgɨxy je maná jecy'ajty, o'ctay ajcxy, ca' ajcxy paty je jugy'ajtɨn huinɨxɨɨbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jadu'n Jesús ymɨydacy jɨm ma je judíojäy ajcxy ñaymujctac jɨm Capernaum co anajty jɨm yaj'ixpɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Co ajcxy Jesús y'ayuc mɨdodaayɨ, nigujc-huäcxy je huɨdibɨ anajty ixpɨjcp ma Jesús. Chi ajcxy capxpɨdzɨmy, e jadu'n ajcxy ymɨnañ: ―Ooy chachchipɨty je Jesús y'ayuc. Ca' huaad ji pɨn huinjɨhuɨyday. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Com Jesús ñejhuɨɨyb nej ajcxy anajty yajtzibɨ̈y yajcapxɨ̈y, chi ymɨnañ: ―¿Nej ca' miich ajcxy mɨjotcujc'aty je tzip ayuc jadu'n nej cham ajcxy tɨ nyajnɨmäy? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nej xymɨjpɨdägɨbɨch ajcxy, pen m'ijxpy ixyipy ajcxy co anajty nba'ttɨgɨ̈yɨch jadüg'oc jiiby tzajpjoty ma ndzooñɨch? Com ɨɨch je' je jäy huɨdibɨ tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Je jäy ajcxy yjɨhuɨ'ñ, yɨ' je' ñinïcx yajjugy'ajtɨp, e je jäy ajcxy ninïcx ca' yɨ' ni ma chobaady, pen ca' mɨɨdɨty yjɨhuɨ'ñ. Co miich ajcxy mgöbɨgɨpy yɨ ayuc tɨɨbɨ ngapxyɨch, huin'it ajcxy mbaadɨpy Dios yjɨhuɨ'ñ (je Espíritu Santo), etz mbaadɨpy ajcxy jugy'ajtɨn huɨdibɨ ca' tüccɨ'yɨ ycɨxy ytɨgooy, oy mja'o'ccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per nigujc-huäcxy ma miich ajcxy pɨnjaty ca' mɨbɨcy ɨɨch n'ayuc. Com Jesús ñejhuɨɨyb anajty jayɨjpnɨ pɨnjaty ca' ymɨbɨgyii y'ayuc, etz pɨnjaty anajty cɨ̈yegaanɨp ma ymɨdzip. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chi Jesús yjacmɨnañ: ―Paady ycɨxpɨ jayɨjp tɨ nmɨna'ñɨch, co ca' ni pɨn jëbɨ ɨɨch xymɨjpɨdägy, pen ca' Dios Teedy jayɨjp yhuinma'ñ ymöyii co cöbɨga'ñ ymöyii co cöbɨga'ñ ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Huin'it mayjäy ajcxy, je huɨdibɨ anajty ixpɨjcp ma Jesús, chi ajcxy huinhuäctut ixmajtznɨ ajcxy Jesús. Ca' ajcxy y'ocjacpanɨcxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chi jada' Jesús nɨmay je nimajmetz discípulos ajcxy: ―¿Nej nañ xy'ixmadzaambɨch miich ajcxyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chi y'adzooy Simón Pedro: ―Huindzɨn, ca' jac ni pɨn ɨɨch ajcxy jëbɨ huaad nmɨjpɨdägyɨch, com miich tügpajc mɨɨd je ayuc huɨdibɨ xyajni'ixɨɨyɨch ajcxy nej jëbɨ huaad ɨɨch ajcxy nbaadɨpy jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ɨɨch ajcxy nmɨbɨjcypɨch e nnejhuɨɨybɨch co miich je' je jäy huɨdibɨ tzoon ma Dios huɨdibɨ huädz yhuinma'ñ ymɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chi Jesús ymɨnañ: ―Miich ajcxy je' tɨ nhuin'ixyɨch nimajmetzpɨ, e nidügtɨ miich ajcxy mujcu' huinma'ñ mmɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Je Judas Iscariote, Simón ymang, anajty ytijpy. Com je' je' anajty cɨ̈yegam Jesús ma ymɨdzip, oy je' anajty yjajëjɨty nidüg ma je nimajmetzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Co jadu'n ytundaayɨ yjajtaayɨ, jɨm anajty Jesús yhuɨdity Galilea naaxjot, ca' anajty ñɨcxa'ñ jɨm Judea naaxjot, co anajty yɨ judíojäy ajcxy huɨdibɨ mɨdzip'ajtɨp yaj'öga'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tɨm huingon anajty je judíojäy yxɨɨ, hue' anajty ajcxy yxɨɨgoyäxy Tabernáculo xɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chi Jesús ñɨmaayɨ y'amɨgüg y'uch yëydɨjcpɨ: ―Tzon miich ya, nɨcx jɨm Judea naaxjot nayguëxɨ̈gɨɨ mayjäyjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Com huenpɨnɨty huɨdibɨ nayguëxɨ̈gaanɨp mayjäyjoty, ca' ajcxy naygoyüchyii. Mdunɨpy miich mɨjhuinma'ñ xɨɨjoty, jɨgɨx je mayjäy xycömayɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ni Jesús y'amɨgüg ajcxy ca' anajty yjaty ymɨjpɨdägyii y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Paady Jesús y'adzooy: ―Ɨɨch nxɨɨ ndiempo ca'nɨ paty mɨna ndɨgɨ̈hua'ñɨch jɨm Jerusalén jadu'n nej je Mesías. Janch miich ajcxy oytɨmymɨnaajɨty jëbɨ mnayguëxɨ̈cɨgɨxy ma je mayjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ca' huaad jëbɨ miich ajcxy, naaxhuiñyjäy ajcxy, xymɨdziptzoñ. Janch ɨɨch xymɨdzip'ajtpɨch ajcxy yɨ', je' co ngapxpɨdzɨmyɨch yɨ yjɨbɨc-huinma'ñ huɨdibɨ ajcxy ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɨcx miich ajcxy jɨm ma xɨɨ yjadyii. Ɨɨch ca' nnɨcxa'ñɨch cham, com ca'nɨ ɨɨch ndiempo yhuaad'aty mɨna ndɨgɨ̈huɨbyɨch jɨm Jerusalén jadu'n nej je Mesías. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jadu'ñydɨ jëda'ajty ymɨnañ, chi yhuɨ'mɨɨy jɨm Galilea. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Co Jesús y'amɨgügtɨjc ajcxy jayɨjp ñɨcxtay xɨɨ'ajtpɨ jɨm Jerusalén, chi Jesús nɨcxy nañ jadu'n ayüch ameech ma anajty xɨɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Xɨɨjoty je judíojäy ooy ajcxy ja'ixtay Jesús, e chi ajcxy ymɨnañ: ―¿Ma jada' je Jesús? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma je mayjäy ajcxy may anajty ajcxy tzachnigapxcɨxy tzachnimɨydaaccɨxy Jesús. Nijëjɨty anajty ymɨnaangɨxy: “Tüg yëydɨjc oyjäybɨ yɨ'”; e nañ nijëjɨty ymɨnaangɨxy: “Ca'p yɨ' y'oyjäyɨty, nɨgo jäy tzachhuin'ɨɨñ.” ");
INSERT INTO mcoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","E ni pɨn anajty ca' capxpɨdzɨmy mayjäyjoty co y'oyjäyɨty anajty Jesús, mɨɨd co anajty ajcxy je judío ixpɨcytɨjc ajcxy tzachtzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","E mɨjxɨɨjoty Jesús ñɨcxy jɨm ma Dios ytɨjc, chi jɨm ytɨgɨɨy yaj'ixpɨjcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Je judío y'ixpɨcytɨjc tzachmaañyhuindɨɨcxcɨxy anajty je Jesús, chachmɨnaangɨxy anajty: ―¿Nej jada' tijy jada chach'ixpɨcyɨty? e ca' ni ma tɨ y'escuel'aty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chi Jesús y'adzooy: ―Jada ixpɨjcɨn ca' ɨɨch jada një'adyii. Yɨ' jada yje' je huɨdibɨ xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","E pen ji pɨnjaty cuydunaanɨ yɨ' ytɨy'ajt je huɨdibɨ xyquejxɨch, huinjɨhuɨ̈huɨpy yɨ' jada ixpɨjcɨn, pen janch Dios yɨ' ytɨy'ajt, o pen ɨɨch yɨ' ngɨ'm ayuc huɨdibɨ ngapxypɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Je jäy huɨdibɨ ycɨ'm'ayuc ycɨ'mdɨy'ajt mɨɨd yaj'ixpɨcy, cɨ'm je' ñaygömaya'ñyii. Janch pɨnjaty tzojcp co ycömayɨɨyb je' yhuindzɨn huɨdibɨ tɨ yquexyii, tɨydudägy je', ca' je' y'anɨɨjɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Janch co Moisés miich ajcxy xymoy Dios ytɨy'ajt. E ni tüg miich ajcxy mgacuydungɨxy je tɨy'ajt. ¿Ti ycɨxpɨ co miich ajcxy xyaj'öga'nɨch? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chi je jäy ajcxy y'adzooy: ―Mujcu' miich mɨɨd ma mjot mhuinma'ñ. ¿Pɨn miich yam xyaj'ögam? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chi je' ajcxy nɨmay: ―Mɨɨd tügpajc mɨjhuinma'ñ tɨɨbɨ nduñɨch sábado xɨɨ, yɨ' miich ajcxy mɨj mdzachjɨhuɨɨyb mdzachhuinmaayb. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés miich ajcxy xyajnajtz'ane'mɨɨy je cötujcɨn co ajcxy m'ung mdɨy'ajttɨ́ɨyɨgɨxy (oy je' ca' yajtzondac, miich janchtɨy ajcxy mmɨj'ap mmɨjteedy Abraham yajtzondac), e paady ycɨxpɨ miich ajcxy m'ung mdɨy'ajttɨɨygɨxy oy yjapocxxɨɨdumɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","E chi jada' ca'ydɨ miich ajcxy Moisés ytɨy'ajt mnɨxiicɨ myajxiicɨ, paady ajcxy m'ung mdɨy'ajttɨɨygɨxy oy sábado xɨɨjoty. ¿Ti miich ajcxy co xymɨjotma'tcɨxɨch co tüg jäy tɨ nyajtzögyɨch sábado xɨɨjoty? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ca' m'ix'ijxcɨxy mba'ijxcɨxy mmɨgüg mɨɨd anɨɨ. Yajcɨ̈yöyɨ yajtecyyöyɨ miich ajcxy jäy ypocy mɨɨd tɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chi ajcxy nijëjɨty Jerusalénjäy ymɨnañ: ―¿Nej ca' jada jada' yjëjɨty je huɨdibɨ ajcxy yjayaj'ögamyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Oc'ix ajcxy, ta ycapxy ymɨydägy ijxna' que'xna', e ca' ajcxy huam nɨmäy. ¿Nej tɨ jada ajcxy ijxcajpcɨxy yajxon tungmɨɨdpɨ ajcxy co jada yjëjɨty je Mesías? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ɨɨch ajt nnejhuɨɨyɨm ma jada yëydɨjc chooñ. Per je Cristo co anajty je' ymiñ, ni pɨn je' canejhuɨ̈huɨpy ma je' anajty choñ ma ycogajpɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Co Jesús jadu'n mɨdooy, co anajty yaj'ixpɨcy ma Dios ytɨjc, huin'it Jesús mɨc ymɨnañ: ―Mnejhuɨɨyb miich ajcxy pɨn ɨɨch, e ma ndzooñɨch. Per ca'p ɨɨch tɨ nmiñɨch ya naaxhuiñ mɨɨd ɨɨch ngɨ'mdzojcɨn. Yɨ huɨdibɨ ɨɨch tɨ xyquexyɨch, tɨydudägy yɨ' ytuñ, e ca' miich ajcxy yɨ' m'ixy'ájtɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ɨɨch janchtɨy n'ixy'ajtypɨch je'. Je' co jɨm ndzooñɨch ma je', e je' ɨɨch xyquejxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Huin'it ajcxy jamadzaañ, per ca' ni pɨn cɨ̈nïxajɨy, com ca'nɨ anajty paady je xɨɨ je tiempo mɨna ñaygɨ̈yegɨɨyb ma ymɨdzip ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Per mayjäy ooy mɨbɨjcy je Jesús y'ayuc, e ymɨnañ ajcxy: ―Co anajty je Cristo ymiñ, ca' jada' nïgɨ mɨjhuinma'ñ tuna'ñ ca'ydɨ jadayaabɨ yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Co je fariseojäy ajcxy ayuc mɨdooy co jäy chachmɨnaangɨxy jadu'n co je Jesús je' je' je Cristo, chi ajcxy quejxy tungmɨɨdpɨ huen Jesús yajmach. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Paady Jesús ymɨnañ: ―Ɨɨch jac-huäcxɨjpɨch hueenɨ ma miich ajcxy, chi nnɨcxa'ñɨch jadüg'oc jiiby tzajpjoty ma huɨdibɨ xyquejxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Xy'ixtähuɨbɨch miich ajcxy, e ca' ɨɨch miich ajcxy xypaadɨpy. Ma anajty ɨɨch nnɨcxyɨch, miich ajcxy ca' jaydëbɨ jiiby mnɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Huin'it je judíojäy ixpɨcytɨjc acjëyɨ ajcxy ñay'amɨdoohuɨ: ―¿Ma jada jada' y'ocnɨcxa'ñ, e nɨcxy ɨɨch ajt ngapaatɨm? ¿Nej nɨcxɨɨb jada' ma je judíojäy ajcxy huɨdibɨ yajpaatcɨxy yxɨɨ yaa ma yɨ griegojäy ajcxy, e yaj'ixpɨgaangɨxy yɨ griegos ajcxyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nej jada' yajhuimbɨdzɨmy? co ymɨna'ñ: “Xy'ixtähuɨbɨch miich ajcxy, e ca' xypáadɨbɨch, e ma anajty ɨɨch nyajpaady, ca' miich ajcxy jaydëbɨ jiiby mnɨcxcɨxy.” ");
INSERT INTO mcoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Co je mɨjxɨɨ ycodɨɨcxnɨ, chi Jesús ytɨnay'ahuɨy, chi mɨc ymɨnañ: ―Pen ji pɨnjaty tɨy'ajt nejhuɨ̈hua'ñ jadu'n nej ixyipy jäy ytɨdzɨ̈yii tzocy yɨ nɨɨ, huen xyñimiiñɨch, etz nmöhuɨbɨch tɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Je jäy ajcxy pɨnjaty xymɨbɨjcpɨch xymɨjpɨdaacpɨch, ytunɨpy ajcxy jadu'n nej Dios ñecy ymɨna'ñ ma jadu'n yjaybetyɨty: “Ycapxypɨdzɨmɨpy je' ajcxy Dios ytɨy'ajt, etz mayjäy jotcujc'ajtɨn etz jugy'ajtɨn pada'ñ huinɨxɨɨ, ytimyñipaatyp jadu'n nej nɨɨ ypɨdzɨmy janch com ma tüg nɨɨgop.” ");
INSERT INTO mcoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Je' anajty jadu'n Jesús ytijyp pɨnjaty je' anajty mɨbɨjcɨp, je' anajty ajcxy adɨgɨ̈huaanɨp jottɨgɨ̈huaanɨp je Espíritu Santo. Ca' nɨ anajty je Espíritu yminɨ ma je discípulos ajcxy com ca'nɨ anajty Jesús yhuimbityñɨ tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Je mayjäy ajcxy huɨdibɨ anajty tɨ mɨdooy nej Jesús anajty tɨ ymɨna'ñ, nidüg nimetz ymɨnañ: ―Jadaabɨ je' je tɨydudägypɨ jäy huɨdibɨ Dios y'ayuc najtzcapxɨɨyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jacjadyii ymɨnañ ajcxy: ―Je' yɨ' je Mesías. Per nijëjɨty ajcxy huɨdibɨ ca' ymɨbɨjccɨxy chachmɨnaangɨxy: ―Ca' jɨm Galilea naaxjot chona'ñ je Mesías. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Com jadu'n yjaybetyɨty ma Dios ñecy co je Mesías jɨm chona'ñ ma David y'ap y'oc, jɨm ma je cajp huɨdi xɨɨjɨp Belén ma David ycogajpɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Je mayjäy ca' anajty ajcxy ñay'ayuc-huinjɨhuɨɨygɨxy mɨɨd Jesús ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nijëjɨty anajty ajcxy ytɨmymadzamy Jesús, per ca' ni pɨn ymajtzɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chi ajcxy policías huɨdibɨ tumb ma tzajptɨjc nihuimbijty ajcxy je teedy mɨjtungmɨɨdpɨ etz je fariseojäy ajcxy, chi ajcxy ñɨmaayɨ: ―¿Nej ajcxy co ca' tɨ mmajtzcɨxy je Jesús? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chi ajcxy je' y'adzooy: ―Nicamɨnaaxɨɨ tüg yëydɨjc jadu'n tɨ ymɨydägy jadu'n nej yɨjiibɨ yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chi je fariseojäy ajcxy ymɨnañ: ―¿Nej nañ tɨ miich ajcxy myajhuin'ɨ́ɨnɨgɨxyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ca' nmɨnaanɨm tɨ ajcxy teedy mɨjtungmɨɨdpɨ o fariseojäy ajcxy mɨbɨjccɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Je mayjäy huɨdibɨ mɨjpɨdaacɨ Jesús y'ayuc, ca' ajcxy y'ixpɨcyɨty ma Dios ycötujcɨn. Dios yɨ' ajcxy tzaachytunɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nidügtɨ ajcxy je' anajty je Nicodemo huɨdibɨ oga'n'aty ni'oy Jesús coodz, je' ymɨgügtɨjc jadu'n nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Jadu'n ɨɨch ajt ngötujcɨn xy'ane'mɨm co ca' huaad ndzaachytuunɨm pɨnjäy, pen ca'p jayɨjp n'ixyöyɨm nbayöyɨm ti anajty tɨ tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chi ajcxy ymɨgügtɨjc y'adzohuimbijty oyñinej: ―¿Nej miich nañ jadu'n galileojäyɨ? Ixta' yajxon ma Dios ñecy, com jiiby mnejhuɨ̈huɨpy co jɨm Galilea ca' jɨm chona'ñ pɨnjäy huɨdibɨ Dios y'ayucnajtzcapxɨɨyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chi ajcxy ñɨcxtay nidüg nidüg ma yjɨɨn ydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Chi Jesús ypa'ttɨgɨɨy ma je cögop huɨdibɨ xɨɨjɨp Olivos. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Com jabom jopyñɨ Jesús yquidacy jadüg'oc ma Dios ytɨjc. Chi mayjäy ñimiinɨ. Chi y'ixtacy, e chi ytɨgɨɨy yaj'ixpɨjcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Je jäy ajcxy huɨdibɨ Dios ycötujcɨn yaj'ixpɨjcp etz je fariseojäy ajcxy mɨɨdmiiñ tüg töxyjäy ma Jesús huɨdibɨ anajty tɨ ytundɨgooy mɨɨd huingbɨ yëydɨjc. Chi ajcxy pɨdacy cujc'amy ma je mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Chi ajcxy nɨmay Jesús: ―Huindzɨn, jadayaabɨ töxyjäy huingbɨ yëydɨjc mɨɨd tɨ ytundɨgoy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés ytɨy'ajt ɨɨch ajcxy xyñajtz'ane'mɨy jecy'ajty co yajtzaagögädzɨpy jada jadu'mbɨ töxyjäy. ¿Nej miich m'ocmɨnambɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jadu'n ajcxy nɨmay co anajty ajcxy oc-huinma'ñ'ixa'ñ. Hue' anajty ajcxy ixtaayb nej jëbɨ huaad yajpocycäy Jesús. Chi Jesús yhuindacy, chi jada' ytɨgɨɨy jaaybɨ mɨɨd ycɨ̈huäx naaxcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Com je' anajty ajcxy chachyaj'amɨdooyb, chi Jesús ytɨnayɨ̈gy. Chi ajcxy nɨmay: ―Pɨn jäy ji ma miich ajcxy ca' ti pocy mɨɨdɨty, huen yɨ' jayɨjp tzaagäch jada töxyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chi Jesús yhuindacy jadüg'oc. Chi ytɨgɨɨy jaaybɨ jadüg'oc naaxcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Co ajcxy jadu'n ayuc yajhuinjɨhuɨydaayɨ, chi ajcxy ooy chöyduñ, com yjɨhuɨy ajcxy ypocy. Chi ajcxy yjɨhuäctay. Chi je mɨjjäydɨjc ajcxy ñaybattzondayɨ. Jesús yhuɨ'mɨɨy nimetz mɨɨd je töxyjäy huɨdibɨ jɨm anajty tɨnaayb huingon. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chi Jesús yhuäccugɨy jadüg'oc nɨmay je töxyjäy jada': ―¿Ma ajcxy je jäy? ¿Ca' ni pɨn tɨ xychaachytuñ mɨɨd mbocy ycɨxpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chi je töxyjäy y'adzooy: ―Huindzɨn, ca' ni pɨn. Chi Jesús ymɨnañ: ―Ni ɨɨch miich ngatzaachytunɨpy mɨɨd mbocy ycɨxpɨ. Nɨcx, e ca' m'ocjacpocytuunɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chi jadüg'oc Jesús yjactɨgɨy mɨydacp ymɨnañ: ―Ɨɨch je tɨy'ajt nmɨɨd ya ma naaxhuiñyjäy, jadu'n ɨɨch nipaady nej tüg jɨɨn huɨdibɨ tɨɨcxp ma jäy ajcxy. Pɨnjäy xymɨjpɨdaacpɨch ymɨɨd tɨy'ajt nej jëbɨ huaad tudägy chɨnähuɨpy, jadu'n nipaady nej jɨhuɨ̈y ytüyöy ma jɨɨn ytɨɨcxɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chi je fariseojäy ajcxy nɨmay Jesús: ―Miich cɨ'm nayñidɨy'ajtɨp co miich je' je Cristo, e ca' mdɨy'ajt chobaady. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chi Jesús y'adzooy: ―Janch co ɨɨch cɨ'm nayñidɨy'ajt'adyiijɨch co ɨɨch je' je Cristo. E ɨɨch ndɨy'ajt janch yɨ'. Com nnejhuɨɨybɨch ma tɨ ndzooñɨch, e ma nnɨcxa'ñɨch. E miich ajcxy ca' mnejhuɨɨygɨxy ma ndzooñɨch, e ma nnɨcxa'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Miich ajcxy mmɨgüg mbocy'ijxyp mɨɨd mgɨ'mhuinma'ñ. Ca' ni pɨn nbocy'ixyɨch mɨɨd ngɨ'mhuinma'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pen ɨɨch anajty nyajcɨ̈yöybɨch nyajtecyyöybɨch jäy ypocy, tɨydudägy anajty jadu'n nduñɨch. Com ɨɨch ca' nyajpaadyɨch naydüg. Je' xymɨɨd'ijtpɨch je Dios Teedy huɨdibɨ tɨ xyquexyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Com cojaay jadu'n y'ity ma miich ajcxy mgötujcɨn ñecy: “Pen nimetz jäy nigodɨy'ajt'aty huentiijɨty, tzoobatp ajcxy y'ayuc.” ");
INSERT INTO mcoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ɨɨch cɨ'm ñayñidɨy'ajt'adyiijɨch co ndzooñɨch tzajpjoty, etz nDeedyɨch nañ jadu'n xyñidɨy'ajt'ajtpɨch, co je' ya tɨ xyquexyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chi ajcxy y'amɨdooy: ―¿Ma miich mdeedy yajpaady? Chi Jesús y'adzooy: ―Com co ca' ɨɨch miich ajcxy xy'ijxcapy co ɨɨch je' je Cristo, nañ ca' ajcxy m'ixy'adyii ɨɨch nDeedy. Co ixyipy ajcxy xy'ijxcapyɨch, nañ jaydëbɨ ixyipy ajcxy nejhuɨ̈y pɨn ɨɨch nDeedy'ajtyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jɨm jadu'n Jesús ycapxy ymɨydacy ma je meeñ'ijttac, co anajty yjäy yaj'ixpɨcy ma Dios ytɨjc. E ca' ni pɨn ymajtzɨ. Com ca'nɨ anajty yxɨɨ yhora anajty paadyñɨ mɨna ñaygɨ̈yegɨɨyb ma ymɨdzip. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chi Jesús yjacnɨmaayɨ ajcxy: ―Ɨɨch nnɨcxaanɨp ɨɨch, miich ajcxy xy'ixtähuɨbɨch. Mɨɨd ajcxy mbocy ycɨxpɨ m'ögaangɨxy, com ma nnɨcxa'ñɨch ca' huaad miich ajcxy jëbɨ mnɨcxcɨxy mɨɨd mbocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Huin'it je judíojäy ajcxy ac jëyɨ ñayñɨmaayɨ: ―¿Nej nɨcxy jada' cɨ'm ñayyaj'öga'ñyiijɨ? Com jadu'n ymɨna'ñ co ma yɨ' ñɨcxy, ca' huaad ɨɨch ajt jëbɨ nnɨcxɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","E Jesús nïgɨ nɨmay'ɨdɨ̈ch anajty: ―Miich ajcxy ya naaxhuiñ mmɨɨdɨty mdɨy'ajtcop. Ɨɨch tzajpjoty nmɨɨdɨdyɨch ndɨy'ajtcopɨch. Miich ajcxy naaxhuiñyjäy ajcxy ytɨy'ajt mmɨjpɨdaacɨpy. Ɨɨch ca' nmɨjpɨdägyɨch naaxhuiñyjäy ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɨɨch miich ajcxy jadu'n nnɨmaayb co m'ögam miich ajcxy, e ca' ajcxy Dios mbocy xyhuinmeecxɨp. Copɨcy ajcxy m'ögɨpy, e ca' Dios mbocy ajcxy xyhuinmeecxɨp, pen ca' xymɨbɨgáangɨxyɨch co ɨɨch je' je huɨdibɨ jëbɨ mbocy ajcxy xyhuinmeecxɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chi ajcxy nɨmay Jesús: ―¿E miich, pɨn miich? Chi Jesús y'adzooy: ―Tɨ ajcxy nyajnɨmaaygɨxy pɨn ɨɨch, co oga'n ndɨgɨɨyɨch jäy yaj'ixpɨjcpɨ. Cham jadüg'oc nyajnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","May ooy tijaty ayuc nyajnɨmähuaangɨxy nej tɨ mdundɨgooygɨxy ma Dios ytɨy'ajt. Cham ca' ajcxy nyajnɨmaydähuɨpy. Je huɨdibɨ tɨ xyquexyɨch ya naaxhuiñ je' tüg'ócɨy tɨy'ajt mɨɨd. E ngapxpɨdzɨmyɨch je ayuc je tɨy'ajt jëyɨ huɨdibɨ tɨ nmɨdooyɨch ma je'. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Je jäy ca' ajcxy huinjɨhuɨy co Dios Teedy anajty Jesús ñigapxyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Paady Jesús nɨmay ajcxy: ―Co anajty miich ajcxy tɨ xyajcruudzpetyɨch, ɨɨch je jäy huɨdibɨ tzoon tzajpjoty, huin'it miich ajcxy mnejhuɨ̈huɨp co ɨɨch je' je Cristo. E co ɨɨch ca' ngɨ'mhuinma'ñ nduñɨch. Yɨ' ɨɨch ya nmɨydacypɨch huɨdibɨ Dios Teedy tɨ xyaj'ane'myɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Je Dios Teedy huɨdibɨ tɨ xyquexyɨch, yɨ' ɨɨch mɨɨd n'ityɨch. Ca' ɨɨch yɨ' xy'ixmachɨch. Com co ɨɨch njatytɨmytumybɨch jabom jabom huɨdibɨ yɨ' chojcyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Co Jesús jadu'n ymɨnañ, chi mayjäy ooy ymɨbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chi Jesús nɨmay je judíojäy ajcxy huɨdijaty anajty tɨ ymɨbɨcy: ―Pen mmɨbɨjc ajcxy cɨxyjot huinɨjot tüg'ócɨy ɨɨch n'ayuc, e ca' m'ijxmadzipy ajcxy ɨɨch n'ayuc, huin'it ɨɨch miich ajcxy jëbɨ njäy'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Huin'it jëbɨ ajcxy mnejhuɨ̈huɨpy Dios ytɨy'ajt. E. Dios ytɨy'ajt xyñihuáangɨxɨp ma je mjɨbɨc-huinma'ñ ooy xy'ané'mgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chi ajcxy y'adzooy: ―Abraham ɨɨch ajcxy nmɨj'ap nmɨjteedy'ajtpy. Ca' ɨɨch ajcxy huaad ni pɨnjäy xyjac'ane'my. ¿Nej co miich jadu'n mɨna'ñ: “Dios ajcxy xyñihua'nɨp ma yɨ mjɨbɨc-huinma'ñ xy'ane'mgɨxy”? ");
INSERT INTO mcoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chi Jesús y'adzooy: ―Janch janch ɨɨch miich ajcxy jadu'n nɨmaaygɨxy co tüg'ócɨy pɨnjaty pocy ytundɨɨb, jɨbɨcp yɨ' ane'mɨp. Tɨm jadu'n nipaady nej tüg tumbɨ huɨdi codoogɨ̈ y ijtp, yɨ' yhuindzɨn jatytɨmy'ane'mɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yɨ tumbɨ huɨdibɨ codoogɨ̈y ijtp, ca' yhuɨ'ma'ñ ma je jäy ytɨjc huinɨxɨɨ. Yɨ jäy y'ung janchtɨy huɨ'mam huinɨxɨɨ ma yteedy ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pen Dios y'ung miich ajcxy xyajpɨdzɨmgɨxp ma je jɨbɨcpɨ xy'ane'mgɨxy, janch huinɨxɨɨ m'idaangɨxy, ca' ma ti jɨbɨcpɨ xy'oc'ané'mgɨxnɨpy. Tɨm jadu'n nej Dios y'ung y'ity, ca' ti jɨbɨcpɨ y'ane'myii. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nejhuɨɨybɨch co miich ajcxy Abraham mmɨj'ap'adyii mmɨjteedy'adyii. Per miich ajcxy chachyaj'ögaambɨch. Je' co ca' mɨjpɨdaaccɨxy ɨɨch n'ayuc huɨdibɨ njayajnɨmaaygɨxyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ɨɨch miich ajcxy nyajmɨɨdmɨydaacyp tɨɨbɨ n'ixyɨch huɨdibɨ ndeedyɨch ytumyb. E miich ajcxy yɨ' mdumyb nej m'ap mdeedy tɨ xyajnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chi ajcxy y'adzooy: ―Hue' ɨɨch ajcxy nmɨj'ap'ajtyp nmɨjteedy'ajtyp je Abraham. Chi Jesús y'adzooy: ―Pen janch ajcxy Abraham mmɨj'ap'adyii mmɨjteedy'adyii, yɨ' ixyipy ajcxy mdungɨxyp jadu'n nej Abraham tuuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Janch ɨɨch miich ajcxy xychachyaj'ögáangɨxyɨch, e tɨ ajcxy njayajnɨmäy je huɨdibɨ ɨɨch tɨ nmɨdooyɨch ma Dios. Ca' Abraham yaj'ögy je jäy ajcxy huɨdijaty anajty Dios ytɨy'ajt mɨɨd, jadu'n nej miich ajcxy m'ɨdɨ̈tzaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Miich ajcxy jɨbɨc-huinma'ñ mdungɨxyp, tɨm jadu'n nej m'ap mdeedy jɨbɨc huinma'ñ ajcxy tuñ jecy'ajty. Chi ajcxy Jesús adzooy: ―Ca'ɨɨch ajcxy ndɨgoy'ungɨty. Je' tügpajc ɨɨch ajcxy ndeedy'ajtyp Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chi Jesús ymɨnañ: ―Penɨ Dios ixyipy ajcxy mdeedy'ajtyp, xychojcpɨch xymɨjpɨdaacpɨch ixyipy ajcxy. Com Dios tɨ xyquexyɨch ya naaxhuiñ, e jiiby ndzooñɨch ma Dios. Ca'ɨɨch ngɨ'mdzojcɨn ycɨxpɨ nmiiñɨch ya naaxhuiñ. Yɨ' je' jadu'n tzojcp pɨn tɨ xyquexyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ti co ca' miich ajcxy mhuinjɨhuɨ̈y ɨɨch n'ayuc? Je' co ca' ajcxy mɨdohuaangɨxy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Je' miich ajcxy mdeedy'ajtyp je mujcu'. Mɨɨd mgɨ'mdzojcɨn mguydungɨxy je mujcu' chójcɨn. Je mujcu'yaj'öctɨɨyb yɨ' jäy maabɨ naaxhuiñybɨ chondägy. Je mujcu' ca' je' ixaanɨ Dios ytɨy'ajt. Ca' ni ti tɨy'ajt yajpaady ma je', com je mujcu' ɨndaacp je', chi cɨ'm ooy nijot y'ɨdɨ̈ch. Je' ooy ɨndacy, e je' oga'n anɨɨ yajtzondac. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Com miich ajcxy mujcu' yhuinma'ñ mɨɨd, paady miich ajcxy ca' xymɨbɨjcɨ xymɨjpɨdaacɨ n'ayucɨch co ɨɨch tɨy'ajt njamɨydägy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni pɨn miich ajcxy xycayajpocycähuɨpy. Penɨ tɨy'ajt ɨɨch miich ajcxy nyajnɨmaayb, ¿ti co ca' mmɨjpɨdaaccɨxy ɨɨch n'ayuc? ");
INSERT INTO mcoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Je jäy ajcxy huɨdibɨ yajpatp ma Dios, y'amɨdo'ijtyp ajcxy Dios y'ayuc. Paady miich ajcxy ca' m'amɨdo'ijtcɨxy Dios y'ayuc, com ca' ajcxy Dios mDeedy'ájtɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chi je judío ixpɨcytɨjc ajcxy y'adzooy: ―Tɨ ɨɨch ajcxy yajxon nmɨna'ñ co miich mgogajpɨty jɨm Samaria, e mujcu' miich mɨɨd ma mjot mhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chi Jesús y'adzooy: ―Ca' ɨɨch mujcu' nmɨɨdɨty ma njot nhuinma'ñ, com nyajmɨj'ajtypɨch nDeedy, e miich ajcxy xy'ixtijpɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɨɨch ca' cɨ'm naygömayiijɨch. Dios Teedy ɨɨch xycömaayb, com yɨ' je' huɨdibɨ ixyöyp payöyp jäy ajcxy ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Janch janch ɨɨch miich ajcxy nɨmaaygɨxy co ji nijëjɨty jäy huɨdibɨ ɨɨch n'ayuc cuydumb, e ca' yɨ' ajcxy yjugy'ajtɨn ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ co y'ó'ccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chi je judío ixpɨcytɨjc ajcxy y'adzooy: ―Cham ɨɨch ajcxy janchtɨy tɨ nnejhuɨ̈yɨch tɨydudägy co miich mujcu' mɨɨdɨty ma mjot mhuinma'ñ. Abraham o'c je', nañ jadu'n o'c ajcxy je huɨdibɨ anajty Dios ytɨy'ajt capxhuäcxɨp, e miich mmɨna'ñ co pen ji pɨnjaty miich m'ayuc xymɨbɨjcɨp xymɨjpɨdaacɨp, ca' je' y'ögɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nej mjacmɨɨd miich mɨc'ajt, ca'ydɨ Abraham, ɨɨch ajt nmɨj'ap nmɨjteedy huɨdibɨ o'cɨ? ¿Nej mjacmɨɨd miich mɨc'ajt, ca'ydɨ ajcxy huɨdibɨ Dios y'ayucnajtzcapxɨɨy, huɨdibɨ ajcxy o'cɨ? ¿Pɨn miich mdɨmnaydijyii? ");
INSERT INTO mcoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chi Jesús y'adzooy: ―Pen ɨɨch nnaygömayɨbɨch cɨ'm, ca' n'ayucɨch chobaadɨpy. Ɨɨch nDeedy yɨ' xycömayɨpɨch, je huɨdibɨ miich ajcxy mdijpy co ajcxy mDios'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Per miich ajcxy ca' Dios m'ixy'adyii. Ɨɨch janchtɨy n'ixy'ajtypɨch Dios. E co ixyipy nmɨna'ñɨch co ca' ɨɨch Dios n'ixy'adyii, ɨndaacpɨch ixyipy, jadu'n nej miich ajcxy m'ɨndaaccɨxy. Janch ɨɨch n'ixyɨch Dios, e nguydumybɨch yɨ' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Je Abraham, miich ajcxy mmɨj'ap mmɨjteedy, jotcujc ooy ñayjɨhuɨɨyɨ co anajty ixa'ñ ɨɨch nxɨɨ ndiempo ya naaxhuiñ. E co ijxy co ɨɨch nmiiñɨch, chi ooy yjotcugɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chi je judío ixpɨcytɨjc ajcxy nɨmay Jesús: ―Ni mgamɨɨdɨty huixchigui'px majc jɨmɨjt, e ¿mmɨna'ñ co m'ijxy Abraham? (Ca' m'ixy'ajtɨ je Abraham, naxy tüg mil jɨmɨjt maabɨ je' y'o'cnɨ.) ");
INSERT INTO mcoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chi Jesús y'adzooy: ―Janch janch ɨɨch miich ajcxy jadu'n nɨmäy co ji anajty ɨɨch co ca'nɨ anajty Abraham yma'xung'aty. ");
INSERT INTO mcoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chi ajcxy tzaa conɨ̈gy tzaagädza'ñ anajty ajcxy. Chi Jesús yhuingoyüch, e ypɨdzɨmy ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hue' anajty Jesús huɨdijtp co ijxy tüg huintz, jadu'n anajty huiintz tɨ yma'xung'aty. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chi ydiscípulos ajcxy y'amɨdoohuɨ: ―Huindzɨn, ¿pɨn pocy ytuun, jada huintzpɨ o ytaj yteedy, co huintz yma'xung'atyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chi Jesús y'adzooy: ―Ca' yɨ' ypocytuuñ, ni ytaj yteedy, hue' janchtɨy paady ycɨxp jadu'n yjajty, jɨgɨx Dios ymɨc'ajt ñiguëxɨ̈gɨty ma yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Copɨcy njactúunɨbɨch yɨ' ytung huɨdibɨ tɨ xyquexyɨch ya naaxhuiñ. Miinɨp je xɨɨ tiempo ma ca' pɨn Dios y'ayuc tunaanɨ. Jadu'n nej jɨhuɨ̈y ixyipy je xɨɨmbɨ tɨ ñaxy etz je coodzpɨ tɨ ymiiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jadu'n nej n'ityɨch ya naaxhuiñ nmɨɨdɨch Dios ytɨy'ajt, jadu'n ɨɨch nipaady nej tüg jɨɨn huɨdibɨ codɨɨcxp yɨ naaxhuiñyjäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Co Jesús jadu'n ymɨnanday, chi nidzujɨɨy naax, chi mo'ntz yaj'oyɨɨy mɨɨd chujnɨɨ, chi jada' yajjaaxɨ je jäy yhuiin mɨɨd je mo'ntz. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chi nɨmay jada': ―Nɨcx quejtzpuj yɨ mo'ntz jɨm ma yɨ Siloé nɨɨ y'abojtzɨ̈gɨty ―je ayuc Siloé jadu'n yhuimbɨdzɨmy: quexyöybɨ. Chi je jäy huintzpɨ ñɨcxy jɨm, chi oy quejtz pujy je mo'ntz, chi oy huimbity tɨ anajty yhuindɨcxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Je ymɨjɨɨn ymɨdɨjc ajcxy etz tüg'ócɨy huɨdijaty anajty ajcxy tɨ ixy je huintzpɨ co jabom jabom ɨñäy limosna yajmucy, chi ajcxy ñay'amɨdoohuɨ miñ xyɨpy: ―¿Nej ca' jada yjëjɨty je huintzpɨ huɨdibɨ anajty jabom jabom limosna yajmujcpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nijëjɨty ajcxy ymɨnañ: ―Je' yɨ'. E jacjadyii ajcxy ymɨnañ: ―Huingbɨ yɨ', nɨgoob jadu'n yquëxɨ̈gy nej je'. E je' ymɨnañ cɨ'm: ―Ɨɨch jëdu'n huɨdibɨ anajty huintz. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jadu'n anajty ajcxy tzach'amɨdoy: ―¿Nej yɨ mhuiin tɨ ñay'ahuäcxyii? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","E je' anajty y'adzooy: ―Yɨ yëydɨjc huɨdibɨ ajcxy ytijyp Jesús, yɨ' mo'ntz yaj'oyɨɨy xyajjaaxɨch nhuiin, e chi xyñɨmaayɨch: “Nɨcx quejtzpuj ma yɨ Siloé nɨɨ.” Chi nnɨcxyɨch, e oy nguejtzpujyɨch, e chi nhuindɨcxɨ'cyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chi ajcxy je' nɨmay: ―¿Ma je' je yëydɨjc? Chi je huintzpɨ y'adzooy: ―Ca' nnejhuɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chi ajcxy yajnɨcxy ma fariseojäy ajcxy yhuinduu, je huɨdibɨ anajty huintz yajpatp. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hue' anajty tüg sábado xɨɨ (judíojäy ajcxy amayxɨɨ) co Jesús mo'ntz yaj'oyɨɨy, e yajhuindɨcxɨ̈gy je huintzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chi je fariseojäy ajcxy jadüg'oc yajtɨy nej anajty je jäy tɨ yhuindɨcxɨ̈gy. Chi je jäy y'adzooy: ―Mo'ntz tɨ pɨdägy ma ɨɨch nhuiin, chi ɨɨch tɨ nguejtzpujy, e cham n'ijxnɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nijëjɨty fariseojäy ajcxy ymɨnañ: ―Yɨ yëydɨjc huɨdibɨ jada jadu'n tɨ tuñ, ca' yɨ' Dios ytɨy'ajt mɨɨdɨty, com ca' yɨ' amay'aty sábado xɨɨ. Chi ajcxy jacjadyii y'adzooy: ―¿Nej tijy jada mɨjhuinma'ñ octuñ, pen hue' yɨ' pocyjäy? Ca' ajcxy nay'ayuc-huinjɨhuɨ́ɨyɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chi ajcxy jadüg'oc nɨmay je jäy huɨdibɨ anajty tɨ y'ijxɨ̈gy: ―E miich, ¿nej m'ocmɨnambɨ? ¿Pɨn jäy yɨ tɨɨbɨ xyajhuindɨcxɨ̈gy? Chi je jäy y'adzooy: ―Tüg jäy huɨdibɨ Dios y'ayuc etz ymɨc'ajt mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Chi je judío ixpɨcytɨjc ajcxy ca' anajty tɨm mɨbɨgaangɨxy co je yëydɨjc anajty huintz yajpaady, e co anajty tɨ yhuindɨcxɨ̈gy, ixtɨ coonɨ ajcxy ytaj yteedy mɨjhuoohuɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chi ajcxy amɨdoohuɨ ytaj yteedy: ―¿Nej je' jada miich ajcxy m'ung huɨdibɨ huintz ma'xung'ajtɨ? ¿Nej jada tɨ yhuindɨcxɨ̈gy? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chi je' ytaj yteedy ajcxy y'adzooy: ―Ɨɨch ajcxy nnejhuɨɨyb co ɨɨch ajcxy yɨ' n'ung, e co yma'xung'ajty huiintz. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per jadu'n nej cham tɨ yhuindɨcxɨ̈gy, e pɨn yɨ' yhuiin tɨ yajhuäcxyii, ca' ɨɨch ajcxy yɨ' nnejhuɨɨygɨxy. Amɨdoo miich ajcxy yɨ' cɨ'm. Mɨj'anäcɨñ yɨ', ñigapxɨpy yɨ' cɨ'm. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jadu'n ajcxy ytaj yteedy y'adzooy, mɨɨd co ajcxy tzachtzɨgɨɨygɨxy je judío ixpɨcytɨjc ajcxy. Com je judío ixpɨcytɨjc ajcxy tɨ anajty ñaygápxɨgɨxy co anajty yajpɨdzɨmaangɨxy ma ajcxy ñaymujctac je jäy ajcxy pɨnjaty anajty mɨbɨjcp co Jesús anajty yjëjɨty je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Paady ajcxy ytaj yteedy ymɨnañ: ―Mɨj'anäcɨñ yɨ', amɨdoogɨx miich ajcxy yɨ' cɨ'm. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chi ajcxy y'amɨdooy mɨmejtz'oc je yëydɨjc huɨdibɨ anajty tɨ y'ijxɨ̈gy, e chi ajcxy nɨmay: ―Cömay capxpat yɨ Dios co tɨ mdzögy. Ca' mgömay mgapxpaady je Jesús. Com ɨɨch ajcxy nejhuɨɨyb co yɨ Jesús, tüg yɨ' pocytumbɨ. Ca' yɨ' Dios y'ayuc ytɨy'ajt mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chi je jäy y'adzooy: ―Pen tüg pocytumbɨ yɨ Jesús, ca' nejhuɨ̈yɨch. Huɨdibɨ janchtɨy nnejhuɨɨybɨch, co anajty ɨɨch nhuintzɨty etz co cham huindɨ́cxnɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chi ajcxy y'amɨdooy jadüg'oc: ―¿Nej tɨ xytuñ? ¿Ti tɨ tuñ co tɨ xyaj'ijxɨ̈cɨ yɨ mhuiin? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chi je' y'adzooy: ―Tɨ ajcxy nyajnɨmaaygɨxy, e ca' ajcxy tɨ m'amɨdo'idaangɨxy. ¿Nej nañ ixpɨgaangɨxy miich ajcxy ma yɨ'jɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chi ajcxy je' ojy, nɨmay ajcxy jadu'n: ―Miich ixpɨjc ma yɨ', ɨɨch ajcxy n'ixpɨjcpɨch ma Moisés ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɨɨch ajcxy nejhuɨɨyb co Dios Moisés mɨgapxy. Janch yɨ Jesús ca' ɨɨch ajcxy nnejhuɨɨygɨxy ma yɨ' chooñ (ma mɨc'ajt tɨ paady). ");
INSERT INTO mcoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chi je jäy y'adzooy: ―Ooy yɨ' y'oychɨgɨɨyñɨty y'oyhuinma'ñɨty co miich ajcxy ca' mnejhuɨɨygɨxy ma yɨ' chooñ (ma mɨc'ajt tɨ paady), e tɨ ɨɨch yɨ' xyajhuindɨcxɨ̈gyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yajxon yajnejhuɨ̈y co Dios ca' yɨ' mɨdoohuɨ pocyjäydɨjc y'ayuc. Pen oy jäy ɨɨch ajt, e nguyduunɨm Dios ytɨy'ajt, huin'it ajt Dios n'ayuc xymɨdoohuɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni camɨnaaxɨɨ ycayajmɨdoy, co pɨnjäy tüg huintzpɨ tɨ yaj'ijxɨ̈gy huɨdibɨ jadu'n tɨ yma'xung'aty huintz. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Co ixyipy je Jesús ca' jiiby chooñ ma Dios, ca' ixyipy jaty nej ti tunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Huin'it ajcxy y'adzooy: ―Miich jadu'n tɨ mma'xung'aty pocymɨɨd. Ca' miich huaad ti xyaj'ixpɨ́jccɨxyɨch. E chi ajcxy yajpɨdzɨmy tɨbäy'tüccɨ'yɨ (ma ajcxy ñaymujctac etz ma Dios ytɨjc). ");
INSERT INTO mcoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chi Jesús nejhuɨy jadu'n co anajty tɨ yajpɨdzɨmy tɨba'y tüccɨ'yɨ ma Dios ytɨjc. Co mɨnaaybaatɨ chi nɨmay: ―¿Nej mmɨbɨjcyp mɨjpɨdaacyp miich je jäy huɨdibɨ tzoon tzajpjoty? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chi je' y'adzooy: ―Huindzɨn, nɨmaaygɨch pɨn je', jɨgɨx nmɨbɨcyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chi Jesús je' y'adzooy: ―M'ijxyp yɨ'du'n yam. Yɨ je' je huɨdibɨ xymɨɨdmɨydacp. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chi jada' huingoxtɨnay'ahuɨy ma Jesús yhuinduu, je huintzpɨ huɨdibɨ Jesús tɨ yajtzögy nɨmay: ―Nmɨbɨjcypɨch, huindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chi jada' Jesús ymɨnañ: ―Ɨɨch tɨ nmiñ ya naaxhuiñ co n'ixyöyaanɨch nbayöyaanɨch jäy ypocy, jɨgɨx nyajpocycähuɨbɨch pɨn ca' ypocymɨɨdɨty, etz nyajpocyñïhuädzɨbɨch pɨn ypocy mɨɨd. Jadu'n nej jɨhuɨ̈y nyajhuindzɨ̈yɨch je jäy huɨdibɨ ijxp, etz jadu'n nej jɨhuɨ̈y nyajhuindɨcxɨ̈gyɨch yɨ huintzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chi nijëjɨty fariseojäy huɨdibɨ anajty jɨm ma Jesús ymɨjc jadu'n mɨdoy nej Jesús ymɨnañ, chi ajcxy nɨmay Jesús: ―¿Nej nañ jadu'n miich mdijy ɨɨch ajcxy ca' Dios ytɨy'ajt nejhuɨɨyɨch, jadu'n nej jɨhuɨ̈y ɨɨch ajcxy nhuintzɨty? ");
INSERT INTO mcoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chi Jesús y'adzooy: ―Co ixyipy miich ajcxy janch janch ca' mnejhuɨɨygɨxy Dios ytɨy'ajt, ca' ixyipy ti pocy ajcxy mmɨɨdɨty. Per miich ajcxy mɨnam co Dios ytɨy'ajt mguyduunɨy, e ca' yjanchɨty. Paady ajcxy mbocymɨɨdɨty. Nipaatyp jadu'n nej jɨhuɨ̈y miich ajcxy mhuintzɨty, e mmɨnaangɨxy co m'ijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Chi Jesús jacnɨmay je judío y'ixpɨcytɨjc, je fariseojäy ajcxy: ―Janch janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy co je jäy ajcxy huɨdibɨ ca' ytɨgɨ̈huaangɨxy ma borregɨ agaj aguu (ma je cuend'ajtpɨ ycuend'aty), huɨdibɨ huingduum ameech tzach tɨgɨ̈huaam ma yborregɨ agaj, je' je' je meetzpɨ huɨdibɨ meedzam je borregɨ ajcxy ameech. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Je jäy huɨdibɨ tɨgɨ̈huam ma yborregɨ agaj aguu, je' je' je borregɨ cuend'ajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Co je borregɨ cuend'ajtpɨ ymiñ ma agaj aguu, chi je agaj aguu cuend'ajtpɨ yaj'ahuäch je agaj aguu. Chi yborregɨ ajcxy yöcmɨdoyii, chi je' mɨgapxy xɨɨbety xɨɨbety, chi yajpɨdzɨmy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Co ajcxy yajpɨdzɨmdäy, ac je' yje', chi jayɨjp ñɨcxy, e axam ajcxy ypanɨcxyii, com je' co yöcmɨdoyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ca' je borregɨ ajcxy jëbɨ panɨcxy tüg huingjäy. Nïgɨ ajcxy cöguëgy, com yöcmɨdooyb ajcxy co yhuingjäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jadu'n Jesús mayjäy yaj'ixpɨjcy jɨhuimbit'amy, jaygue' ajcxy ca' huaad huinjɨhuɨ̈y nej anajty Jesús yjamɨnäna'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chi ajcxy Jesús jadüg'oc ñɨmaayɨ: ―Janch janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy, co je Dios nDeedy'ajtypɨch. Jëbɨ jäy ajcxy paady Dios ytɨy'ajt ma ɨɨch, e huin'it ytɨgɨ́ɨygɨxɨpy ma Dios y'it. Jadu'n nipaady nej jɨhuɨ̈y ɨɨch je agaj aguu ma borregɨ ajcxy ytɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tüg'ócɨy je huindzɨndɨjc huɨdibɨ ajcxy miin jayɨjp ca'nɨ ɨɨch anajty nmiñɨch, e ymɨnaangɨxy anajty co ajcxy mɨɨd'ajtɨ Dios ytɨy'ajt, jadu'n je' anajty ajcxy nej meetzpɨ huɨdibɨ meedzaanɨp Dios yjäy. Per je Dios yjäy ca'p je' ajcxy tuuñ cuendɨ, jadu'n nej je borregɨ ca' yöcmɨdoogɨxy je meetzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jadu'n nej je borregɨ ajcxy ytɨgɨɨygɨxy ma agaj aguu, nañ tɨm jadu'n jäy ajcxy paady Dios ytɨy'ajt ma ɨɨch. Je jäy ajcxy huɨdibɨ ypaatyp Dios ytɨy'ajt ma ɨɨch, nañ ypadaamy jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. E huɨdibɨ je' ajcxy yajmayjajtyp ma yɨ chɨnaayɨn, nmöhuɨbyɨch. Tɨm jadu'n nej borregɨ ajcxy jabom jabom ypɨdzɨmgɨxy ma agaj aguu nɨcxcɨxy mɨɨy'ojcpɨ, etz yhuimbijtcɨxy tzuu tzuu. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yɨ meetzpɨ ajcxy mimb co ymeedzaangɨxy yaj'ögaangɨxy yajhuindɨgoyaangɨxy. Ɨɨch tɨ nmiiñɨch, jɨgɨx miich ajcxy mbáatcɨxɨpy jugy'ajtɨn mɨjcajee huɨdibɨ ca' tüccɨ'yɨ ycɨxɨpy ytɨgoyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Chi Jesús yjacmɨnañ: ―Ɨɨch jadu'n nipaady nej tüg borregɨ cuend'ajtpɨ oybɨ. Je oybɨ borregɨ cuend'ajtpɨ ycɨ̈yejcyp yɨ' yjugy'ajt ma yɨ o'cɨn mɨɨd yborregɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Je borregɨ cuend'ajtpɨ huɨdibɨ mujuy tumb, huɨdibɨ ca' ycɨ'mborregɨ cuend'aty, ni ycajëjɨty je borregɨ yhuindzɨn, co ixy caa ymiñ, chi cöguëgy je borregɨ, e yajqueec-huäcxtäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Com je' co mujuy ytuñ, paady cöguëgy je borregɨ ajcxy, ca' tzocy jɨhuɨ̈y borregɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Tɨm jadu'n nej je oybɨ borregɨ cuend'ajtpɨ ijxcajptäy je' yborregɨ, nañ tɨm jadu'n ɨɨch n'ijxcajptäy je njäyɨch (huɨdibɨ xymɨjpɨdaacpɨch), etz je' ajcxy xy'ixy'ajtpɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tɨm jadu'n nej Dios Teedy xy'ixy'adyiijɨch, nañ tɨm jadu'n n'ixy'adyiijɨch Dios Teedy. Tɨm jadu'n je' nej je oybɨ borregɨ cuend'ajtpɨ ycɨ̈yegamy yjugy'ajtɨn mɨɨd yborregɨ ycɨxpɨ. Nañ tɨm jadu'n ɨɨch ngɨ̈yegamyɨch njugy'ajtɨn mɨɨd ɨɨch njäy ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nmɨɨdɨch jadügpɨcy jäy, ca' ajcxy yjudiojäyɨty, je' ajcxy nañ jadu'n nmɨɨd'idaamyɨch tügmucy (mɨɨd je judío jäy ajcxy huɨdibɨ xymɨjpɨdaacpɨch). Tɨm jadu'n nej je cuend'ajtpɨ ymɨɨd'ajtyp je' yborregɨ ajcxy tügmucy. E je' ajcxy y'amɨdoo'idaamy ɨɨch n'ayuc, tɨm jadu'n nej borregɨ ajcxy yöcmɨdoogɨxy yhuindzɨn. Ji y'idɨpy tügmucy jäy (huɨdibɨ xymɨjpɨdägɨbɨch), etz tüg cuend'ajtpɨ (ɨɨch jëdu'n). ");
INSERT INTO mcoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Chi Jesús yjacmɨnañ: ―Paady ycɨxp Dios Teedy ooy xychocyɨch xyjɨhuɨ̈yɨch, co ngɨ̈yegaamyɨch njugy'ajtɨn ma yɨ ó'cɨn (mɨɨd jäy ajcxy ypocy ycɨxpɨ), etz njugypɨgɨpyɨch jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ca' ni pɨn xypɨjcɨbɨch yɨ njugy'ajtɨn, ɨɨch yɨ' cɨ'm ngɨ̈yegamy. Nmɨɨdɨch mɨc'ajt nej ngɨ̈yegɨpyɨch njugy'ajtɨn, etz nañ nmɨɨdɨch mɨc'ajt nej njugypɨgɨpyɨch jadüg'oc. Jadu'n nDeedyɨch tɨ xy'ane'myɨch co jadu'n ndunɨpyɨch, n'ögɨbɨch, njugypɨgɨpyɨch jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chi jadüg'oc ajcxy ca' nay'ayuc-huinjɨhuɨɨyɨ je judíojäy ajcxy mɨɨd Jesús y'ayuc ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mayjäy ymɨnañ: ―Ca'oybɨ yɨ' ymɨɨd, locjɨɨyb yɨ', ¿nej co ajt n'amɨdo'ijtɨm y'ayuc? ");
INSERT INTO mcoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","E jacjadyii ajcxy ymɨnaangɨxy: ―Jadayaabɨ tɨy'ajt etz mɨc'ajt ca' yajpaady ma tüg jäy huɨdibɨ mujcu' ymɨɨd. Ca' jëbɨ tüg mujcu' jäy huintzpɨ yaj'ixɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jɨm Jerusalén anajty xɨɨ yjadyii, je' anajty ajcxy ñixɨɨdumyb jɨmɨjt Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","E hue' anajty tɨɨch tiempo. Chi jɨm anajty Jesús yhuɨdity ma Dios ytɨjc, ma je Salomón ytɨjc-huinduu. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chi ajcxy je judío y'ixpɨcytɨjc nimujcy ooy Jesús, nɨmay ajcxy: ―¿Ixtɨ mɨnaanɨ miich ɨɨch ajcxy tɨydudägy xyajhuinjɨhuɨ̈huáangɨxyɨch pen miich je' je Cristo? Yajhuinjɨhuɨɨygɨch ajcxy tɨydudägy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chi Jesús y'adzooy: ―Tɨ ajcxy nyajnɨmaaygɨxy, e ca' miich ajcxy tɨ nmɨbɨjccɨxy. Je mɨjhuinma'ñ huɨdibɨ ndumybɨch nmɨɨdɨch nDeedy ymɨc'ajt, yɨ' je' nidɨy'ajt'ajtp co ɨɨch je' je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Paady ycɨxp miich ajcxy ca' mmɨbɨjccɨxy, com ca' miich ajcxy njäy'adyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɨɨch njäy ajcxy ymɨjpɨdaacyp ɨɨch n'ayuc, e n'ijxcajpɨch ajcxy je', e je' ajcxy xypanɨcxpɨch. Tɨm jadu'n nej je borregɨ ajcxy yöcmɨdoy je yhuindzɨn, jadu'n nej je huindzɨn ijxcapy je' yborregɨ, e jadu'n nej yɨ yborregɨ ypanɨcxyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ɨɨch njäy ajcxy nmooybɨch yɨ jugy'ajtɨn huɨdibɨ ca' tüccɨ'yɨ ycɨxa'ñ ytɨgoya'ñ. Ca' je' ajcxy yjugy'ajtɨn ytɨgoyɨpy ni camɨna, e ni pɨn ca' huaad je' ajcxy xypɨjcɨch. Je' ajcxy cɨ'am nmɨɨdɨdyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yɨ Dios Teedy huɨdibɨ ɨɨch njäy tɨ xymöy, tügpajc yɨ' ymɨjɨty, e ni pɨn huaad ni ti capɨ́jcɨy huɨdibɨ Dios Teedy ymɨɨd cɨ'am. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Dios Teedy etz ɨɨch tú'cɨy ɨɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chi je judíojäy ajcxy jadüg'oc tzaa conɨ̈g cädzaangɨxy anajty ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chi Jesús je' ajcxy nɨmay: ―Tɨ ɨɨch ooy mɨj oybɨ nduñɨch ma miich mhuinduu mɨɨd je nDeedyɨch ymɨc'ajt ycɨxpɨ. ¿Huɨdi ycɨxpɨ miich ajcxy xychaagädzáangɨxyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chi je judío ixpɨcytɨjc ajcxy y'adzooy: ―Ca' nmɨnaanɨm paady ɨɨch ajcxy miich ndzaagädzaangɨxy mɨɨd je oybɨ tɨɨbɨ mduñ, hue' janchtɨy ycɨxpɨ ndzaagädzaangɨxy mɨɨd co ooy Dios myajjotmädy. Com miich nañ jäy, e mnayyajnaxyii Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Huin'it Jesús je' ajcxy nɨmay: ―Jadu'n ycojaayɨty ma yɨ judíojäy ajcxy ytɨy'ajtnecy, ma Dios jadu'n ymɨna'ñ: “Jadu'n nej dios miich ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Paady ca' ngapxtɨgooyɨch, com Dios cɨ'm jadu'n mɨnamb ma ñecy, co jadu'n nej Dios je' ajcxy huɨdibɨ Dios y'ayuc cöbɨjcɨp (e ca' huaad pɨnjäy ymɨna'ñ co Dios ñecy ca' yjanchɨty). ");
INSERT INTO mcoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios tɨ xyajnïbɨcyɨch jada tung, e xyquejxyɨch ya naaxhuiñ. ¿Nej co mmɨnaangɨxy co ɨɨch ngapxtɨgooyɨch co nmɨna'ñɨch co Dios xy'ung'adyiijɨch? ");
INSERT INTO mcoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pen ca' nduñɨch nDeedyɨch ytung, ca' ɨɨch ajcxy huaad n'ayuc xymɨbɨjcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","E pen ndumybɨch nDeedyɨch ytung, oy ixyipy miich ajcxy ca' xymɨjpɨdaacɨch n'ayuc, jëbɨ ixyipy mɨjpɨdägy ajcxy je mɨjhuinma'ñ huɨdibɨ ndumybɨch. E chi mnejhuɨ̈huɨpy miich ajcxy, etz mmɨjpɨdägɨpy miich ajcxy co je Dios Teedy yajpaady ma ɨɨch, e ɨɨch nyajpaadyɨch ma Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ooy ajcxy jamadzaañ Jesús, e chi Jesús oy chonɨ, ca' ajcxy majch. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chi Jesús ñɨcxy jadüg'oc jɨm Jordán mɨj nɨɨ nïnaxy ma Juan yjäy yajnɨɨbejty oga'n'aty, chi jɨm yhuɨ'mɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mayjäy Jesús ooy ñimujcɨ, e ymɨnañ ajcxy: ―Je Juan el Bautista ca' jadu'n ooy mɨjhuinma'ñ tuuñ, per tüg'ócɨy yɨ tɨy'ajt jadu'n nej nimɨydactay jada Jesús, janch tɨy'ajt je'. ");
INSERT INTO mcoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E janch mayjäy ooy mɨbɨjcy Jesús jɨm ma je jɨmbɨ it. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jɨm Betania anajty tüg pa'mjäy, hue' anajty yxɨɨ Lázaro. Hue' je' anajty chɨnäy ma María etz Marta ycogajpɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María je' anajty huɨdibɨ je Huindzɨn Jesús anajty tɨ yajjaxy je ujtzpɨjyñɨɨ huɨdibɨ ooy oy yxuugy, etz po'tɨ Jesús ytecy mɨɨd ycöhuay. Hue' je' anajty María etz Marta ymɨdügquëx Lázaro huɨdibɨ anajty pɨjcɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chi Lázaro ymɨdügquëx ajcxy ycapxyquejxy ma je Huindzɨn Jesús anajty yajpaady, e chi oy yajnɨmäyii: ―Je mmɨgüg huɨdibɨ ooy mdzocy, pɨjcɨp je'. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Co Jesús jadu'n mɨdooy, chi ymɨnañ: ―Je' ypa'm ca' yaj'öga'ñyii tüccɨ'yɨ. Je' ypa'm hue' yajniguëxɨ̈gamy Dios ymɨc'ajt, jaydëb Dios ycömaybɨdzɨmɨpy, e nañ ɨɨch nyajcömayɨpyɨch, ɨɨch je jäy huɨdibɨ tzoon tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús ooy anajty tzocy jɨhuɨ̈y je Marta, María etz je Lázaro. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Oy jadu'n Jesús nejhuɨɨy co anajty Lázaro ypɨgyii, jamejtz xɨɨ jɨm yjacxɨɨnajxy ma anajty yajpaady. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Huin'it Jesús nɨmay ydiscípulos ajcxy: ―Tzoc jamɨm jɨm Judea naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chi je' ydiscípulos ajcxy y'adzooy: ―Huindzɨn, namnɨ jäy ajcxy jɨm Judea tɨ xy'ocjaccögädzambɨ, e ¿mnɨcxaanɨp jɨm jadüg'ocɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Chi Jesús y'adzooy: ―Majmetz hora tüg xɨɨmbɨ mɨɨdɨty. Pɨnjäy mɨɨd Dios ytɨy'ajt, ca' ayo'n pada'ñ, tɨm jadu'n nej jɨhuɨ̈y yhuɨdity xɨɨm, e ca' ycönepy, com co xɨɨ codɨɨcxy jada naaxhuiñybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pɨnjäy ca' mɨɨdɨty Dios ytɨy'ajt, ca' je' nejhuɨ̈y ti anajty jadaanɨp, chi ayo'n pada'ñ, tɨm jadu'n nej jäy ycoodzhuɨdity, e chi ycönepy mɨɨd co ca' anajty ixy ma ñɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Huin'it Jesús je' ajcxy nɨmay: ―Ɨɨch ajt nmɨgüg Lázaro maab je', nɨcxy nyajpɨdɨ̈ga'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chi je' ydiscípulos ajcxy y'adzooy: ―Huindzɨn, pen maab, huaadjɨhuɨ̈jɨ̈huɨp yɨ', cɨ'm yɨ' ymäyhuijɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Je' Jesús anajty ñimɨydaacyp je o'cɨn, e je' ajcxy tijy Jesús ñimɨydaacyp je mähuɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chi Jesús yajmɨɨdmɨydacy ajcxy tɨydudägy, ymɨnañ: ―Lázaro tɨ je' y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E ooy njotcújcɨdyɨch mɨɨd miich ajcxy ycɨxpɨ co anajty ɨɨch ca' njɨmɨty, jɨgɨx ajcxy mmɨbɨgɨpy co Dios ymɨc'ajt nmɨɨdɨdyɨch. Tzoc ajt jamɨm jɨm Betania. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás huɨdibɨ anajty ajcxy yxɨɨgoyaaxyp Dídimo, huɨdi ayuc-huimbɨdzɨm: cuate, nɨmay jacjadyii Jesús ydiscípulos ajcxy: ―Tzoc ajt nañ jadu'n jamɨm, huen jäy jɨm xyaj'o'cɨm quipxy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Co ajcxy jɨm yja'ty, chi ajcxy paty tɨy'ajt co mɨmɨdaaxxɨɨbɨ anajty maabɨ Lázaro ñaaxtɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ca' anajty ooy yjɨguëgyɨty mɨɨd Jerusalén, jëyɨ jada' anajty mɨɨdɨty tugɨɨg kilómetro. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","May judíojäy ajcxy anajty tɨ ymiiñgɨxy ma Marta etz María, yajjotcugɨ̈hua'ñ ajcxy mɨɨd je' ymɨguëx ycɨxpɨ co anajty tɨ y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Co nejhuɨ̈y Marta co Jesús anajty jɨm ymiñ, chi nidzooñ oy jɨjpcobadɨ̈y. E María jɨm yhuɨ'mɨɨy ma ytɨjc, tɨgoty anajty ɨñäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chi Marta Jesús nɨmay: ―Huindzɨn, co ixyipy miich ya anajty myajpaady, ca' ixyipy tɨ y'ögy nmɨguëxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per nnejhuɨɨybɨch co miich cham jëbɨ Dios mmɨbɨjctzoy, e xymöhuɨp ti mdɨmdzojcyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chi Jesús y'adzooy: ―Je mmɨguëx jugypɨgɨp jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chi Marta y'adzooy: ―Nnejhuɨɨybɨch co yjugypɨgɨpy jadüg'oc co anajty naaxhuiñybɨ tɨ yhuaad'ajtnɨ co Dios anajty yajtɨgadza'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Per huin'it Jesús y'adzooy: ―Ɨɨch je' nyajjugypɨgɨpyɨch je jäy ajcxy, e nmöhuɨbyɨch ajcxy jugy'ajtɨn. Pɨnjäy ajcxy xymɨbɨjcpɨch xymɨjpɨdaacpɨch, oy anajty yja'ögy ajcxy, jugy'ájtcɨxɨp ajcxy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E tüg'ócɨy pɨnjaty ajcxy xymɨbɨjcp xymɨjpɨdaacpɨch juugyñɨ, ca' y'ögɨpy ajcxy tüccɨ'yɨ. ¿Nej mɨbɨjcyp miich jadaajɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chi Marta y'adzooy: ―Nmɨbɨjcypɨch, Huindzɨn. Nmɨbɨjcypɨch co miich je' je Cristo, Dios y'ung, huɨdibɨ anajty miinam ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Co Marta jadu'n ymɨnañ, chi jada' oy huoy y'uch María, e yajnɨmay ameech: ―Je Huindzɨn chiiby je', e miich jiiby xymɨɨdmɨydägamb. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Co María jadu'n mɨdooy, chi ypɨdɨ̈gy mɨc'amy, e chi ñɨcxy ma Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ca'nɨ anajty Jesús yja'ty cajpjoty. Jɨmnɨ anajty yhuäcxɨjp ma anajty Marta tɨ yjɨjpcobaadɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Co ajcxy ijxy co María ypɨdɨ̈gy, e ypɨdzɨɨmy janch mɨc'amy, je judíojäy huɨdibɨ anajty ajcxy jɨm ma je tɨjc mɨɨd je', hue' ajcxy tijy María ñɨcxy yaaxpɨ ma anajty tɨ ñaaxtɨgɨ̈y je Lázaro. Chi ajcxy panɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Co yjädy María ma je it ma anajty Jesús, co ijxpaty, chi ycojxtɨnaay'ahuɨɨy ma Jesús yhuinduu, chi nɨmay: ―Huindzɨn, co ixyipy miich anajty m'ocyaajɨty, ɨɨch n'ay ca' je' ixyipy y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Co Jesús ijxy yäxy je María etz je judíojäy ajcxy huɨdibɨ anajty yjaymɨɨd'ajtɨp, chi ooy jɨhuɨɨy etz ytaj ymaay. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chi jada' Jesús yajtɨy: ―¿Ma ajcxy Lázaro tɨ myajnaaxtɨgɨ̈? Chi ajcxy nɨmay: ―Huindzɨn, jam ijxɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chi Jesús yaaxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chi judíojäy ajcxy ñayñɨmaayɨ miñ xyɨpy: ―Ooydɨm anajty tzocy je Lázaro. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per nijëjɨty ajcxy ymɨnañ: ―Jadayaabɨ jäy huɨdibɨ huintzjäy yajhuindɨcxɨ̈gy, ¿nej ca' jada' ixyipy mɨc'ajt mɨɨdɨty jëbɨ ixyipy tɨ yajtzögy je Lázaro, e ca'ydɨ ixyipy tɨ y'ögy? ");
INSERT INTO mcoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chi Jesús jadüg'oc yjotmaybaty, chi ymɨjhuägy ma je o'cpɨ jut. Hue' je' anajty tüg ang mɨɨd tüg mɨj tzaa y'agɨyducyɨty je jut aguu. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chi Jesús ymɨnañ: ―Jɨɨgɨ' ajcxy jada tzaa. E chi Marta je o'cpɨ y'uch y'adzooy: ―Huindzɨn, xuucnɨp yɨ', com cham yɨ' mɨmɨdaaxxɨɨbiñ maabɨ ñaaxtɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chi Jesús ymɨnañ: ―¿Nej cay tɨ jadu'n nnɨmäyɨ? Pen xymɨbɨ́jcɨbɨch yɨ' n'ayuc, m'ixɨpy Dios ymɨc'ajt y'oy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chi ajcxy je tzaa jɨɨgɨɨy, chi Jesús cɨx ypa't'ijxy, ymɨnañ: ―Dios Teedy, jäygɨdaacɨn nyajnajxypɨch ma miich, co miich xymɨdoohuɨ n'ayucɨch ");
INSERT INTO mcoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yajxon nnejhuɨ̈yɨch co miich xy'amɨdo'ijtpɨch jabom jabom, paady ycɨxp miich jadu'n tɨ nnɨmäy mɨɨd jadayaabɨ jäy ajcxy ycɨxpɨ ma ɨɨch nhuinduu, huen ajcxy mɨbɨcy co miich xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Co Jesús jadu'n ymɨnañ, chi jada' mɨc ycapxy: ―Lázaro, pɨdzɨm tɨbäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hue' je o'cpɨ mɨc'amy ypɨdzɨmy ymo'nɨty yajxon tüg'ócɨy ñinïcx etz huingoyebɨ̈yɨty mɨɨd huit, chi Jesús ymɨnañ: ―Huimbɨdijttuutcɨxy, e najtzmadzɨɨygɨx, huen yöychooñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","May je judíojäy ajcxy ymɨbɨjcy huɨdibɨ anajty María yjaymɨɨd'ajtyp, co ajcxy ijxy je huɨdibɨ anajty Jesús tɨ tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per jadyii judíojäy ajcxy oy ixtäy je fariseojäy ajcxy, chi ajcxy yajmɨɨdmɨydacy huɨdibɨ anajty Jesús tɨ tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Je teedy tungmɨɨdpɨ ajcxy, etz je fariseojäy ajcxy, chi ajcxy ñayhuoomujctayɨ je tungmɨɨdpɨ ajcxy nidüg'ócɨy, chi ajcxy ymɨnañ: ―¿Nej ajt Jesús n'octuunɨm? Yɨjiibɨ yëydɨjc ooy yɨ' mɨjhuinma'ñ tzachtuunɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Pen nnajtz'ɨxɨɨyɨm jadu'ñyɨ, tüg'ócɨy jäy mɨbɨjctähua'ñ yɨ'. Chi ajcxy ymiinɨpy je Romano tungmɨɨdpɨ huɨdibɨ ajt xy'ané'mɨm, e chi yajhuindɨgoyɨpy ɨɨch ajt nDios y'it, e nañ yajhuindɨgoyɨpy ɨɨch ajt ndzɨnaayɨn njugy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nidügtɨ ajcxy je jäy, hue' anajty yxɨɨ Caifás, hue' anajty mɨjtungmɨɨd, je' anajty teedy huindzɨn, je' jadu'n jäy nɨmayday: ―Miich ajcxy ca' ti mhuinjɨhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ca' ajcxy mnejhuɨ̈y co jac'oy nyaj'o'cɨm je Jesús tügpajc, huen yɨ' codɨnaydähuɨp naax cajp, jɨgɨx ca'ydɨ ɨɨch ajt nnaax ngajp yhuindɨooyɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Canan ycɨ'mhuinma'ñ jadu'n ycɨxpɨ ymɨnañ je'. Hue' janchtɨy com je' anajty ymɨjtungmɨɨdɨty je huin'it jɨmɨjt ma teedy ajcxy ymiñ, paady Dios huinma'ñ jadu'n yejcy, co jadu'n najtzcapxɨy co Jesús anajty y'öga'ñ mɨɨd tüg'ócɨy ajcxy naax cajp ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E ca' nmɨnaanɨm mɨɨd jëda'ajty mɨɨd je judío ajcxy ñaax ycajp ycɨxpɨ, nañ jëgɨ́x co huoomujctähua'ñ tüg'ócɨy Dios y'ung huɨdijaty anajty ajcxy yajpatp xɨɨ ya. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Huin'it oga'n ajcxy je tungmɨɨdpɨ yajnigodugɨɨy co yaj'ögaangɨxy Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesús ca' anajty ma y'ocyaj'ijxnɨ mayjäyjoty ma je judíojäy ajcxy. Chi jada' ñɨcxy jɨguem mɨhuingon ma je tɨ̈tznaax'it, ma anajty tüg cajp xɨɨjɨty Efraín. Chi jɨm yhuɨ'mɨy mɨɨd ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Huingoonɨp anajty je pascua xɨɨ huɨdibɨ anajty judíojäy ytumyb. Tɨ anajty may judíojäy ajcxy ñinɨcxnɨ jɨm Jerusalén xɨɨ'ajtp huɨdibɨ anajty jɨguëgyjaty tzomb. Jayɨjpnɨ ajcxy ñɨcxy ca' anajty xɨɨ paady, co anajty ajcxy ñayyajpocyñïhuädza'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ooy anajty jäy ajcxy ijxtäy Jesús huin'it. Paady anajty chachnayñɨmáayɨgɨxy nidüg nidüg miñ xyɨpy, co ajcxy ytɨnay'ahuɨɨy ma Dios ytɨjc, jadu'n ajcxy ymɨnañ: ―¿Nej m'ocmɨnaangɨxy? ¿Minɨpy jada' Jesús xɨɨ'ijxpɨ, o ca'jɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Je teedy ajcxy je' yhuindzɨn etz fariseojäy ajcxy tɨ anajty yejccɨxy cötujcɨn co huentɨmpɨnɨty huɨdibɨ anajty nejhuɨɨyb ma je Jesús, huen nigapxy jɨgɨx ajcxy madzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jatudujcxɨɨnɨ anajty pascuaxɨɨ ca' paady, co Jesús ñɨcxy jɨm Betania, jɨm ma anajty Lázaro yajpaady, je huɨdi anajty tɨ yajjugypɨcy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chi ajcxy jɨm yaj'oyɨɨy tüg adzu'ɨ̈bɨ. Marta anajty jɨm yajcaayb yaj'uucp je jäy ajcxy. Lázaro anajty mɨɨd Jesús ɨñäy ma je mesɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chi María conɨ̈gy tüg libra ujtzpɨjyñɨɨ huɨdibɨ anajty ooy oy yxuugy. Tzou je' anajty ooy, je' mɨɨd Jesús ytecy yajjaaxtaayɨ. Chi jada' mɨɨd ycöhuay po'ttɨɨch. Chi ac ujtzpɨjyñɨɨ yxuugɨ̈tay tɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Huin'it je Judas Iscariote je Simón ymang huɨdibɨ anajty yhuindzɨn cɨ̈yegam ma ymɨdzip, je' jadu'n ymɨna'ñ: ");
INSERT INTO mcoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Jac'oy co ixyipy tɨ ndoocɨm jada ujtzpɨjyñɨɨ oy mɨgo'pxpeexytɨ jadɨɨb ixyipy ajt ayoobtɨjc nbubejtɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Canan paady Judas jadu'n ymɨnañ co ayoobɨtɨjc tzachpa'ayoy. Paady jadu'n ymɨnañ co ajcxy chachmeedza'ñ. Com je' anajty meeñybijty cuend'ajtp, e chachpuugomyb huɨdijaty anajty jiiby ajcxy yjapɨdaacyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chi Jesús nɨmay je Judas: ―Ixmatz miich yɨ', hue' yɨ' yɨ María tɨ yujcpɨcy jada ujtzpɨjyñɨɨ co yajtuna'ñ co anajty naaxtɨgɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Com yɨ ayoobɨtɨjc ajcxy huinɨxɨɨ yɨ' miich ajcxy mɨɨd'idɨpy. Janch ɨɨch ca' ɨɨch miich ajcxy mɨɨd n'idɨpy huinɨxɨɨ (ya naaxhuiñ). ");
INSERT INTO mcoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Co ajcxy nejhuɨɨy may judíojäy ajcxy co anajty Jesús yjɨmɨty Betania, chi ajcxy nimiiñ. E canan mɨɨd Jesús ycɨxpɨ jëda'ajty, je' anajty ajcxy nañ jadu'n chach'ixaamy je Lázaro huɨdibɨ anajty tɨ jugypɨcy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Chi je teedy ajcxy yhuindzɨndɨjc ñaygapxɨ, co yaj'ögaangɨxy Jesús etz nañ jadu'n je Lázaro, ");
INSERT INTO mcoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","com may judíojäy ajcxy anajty ñayjɨɨbɨjcɨn, etz tzachmɨbɨjccɨxnɨ Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Je com jabom je mayjäy huɨdibɨ anajty ajcxy tɨ ymiingɨxy xɨɨ'ajtpɨ ñejhuɨɨy ajcxy co Jesús anajty ymina'ñ jɨm Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chi ajcxy cabɨ̈gy may ytɨɨxy y'aacx, chi ajcxy nidzooñ Jesús, chachmɨnaangɨxy: ―¡Dios ajt xyñihuaanɨm xyajtzoocɨm! Mimb tüg jäy huɨdibɨ Dios tɨ yconucxyii. Ymɨɨd yɨ' Dios ymɨc'ajt, je' je' je judíojäy yrey. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Co Jesús paty tüg burro mang huɨdibɨ ca' ni pɨn yaj'ɨñaayñɨ, chi yajpejty, chi cuyduuñ jadu'n nej anajty jaybety y'ity ma Dios ñecy co jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","―Ca' mdzɨgɨ̈y miich ajcxy huɨdibɨ tzɨnaayb ma Sión cajp (Jerusalén). Cha je mrey ymiñ y'ɨñäy ma tüg burro mang. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Je huɨdibɨ anajty ajcxy Jesús discípulo'ajtyp, ca' anajty ajcxy huinjɨhuɨɨygɨxy ixtɨ coonɨ Jesús paty jadüg'oc yɨ' y'oy'ajtɨn ymɨj'ajtɨn jiiby tzajpjoty. Huin'it ajcxy ajɨhuɨygootɨ co jadu'n anajty ycojaayɨty mɨɨd Jesús ycɨxpɨ, e nañ co je' anajty Jesús tɨ yajtunyii tɨ yajjadyii jadu'n nej jaybety ymiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Je jäy ajcxy huɨdibɨ anajty ajcxy ymɨɨd Jesús, huin'it co Lázaro ypɨdzɨmy ma yajnaaxtɨgɨɨyɨ, e yajjugypɨjcɨ jadüg'oc, chachyejcyp anajty ajcxy tɨy'ajt nañ jadu'n huɨdibɨ anajty ajcxy tɨ ijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nañ paady ycɨxpɨ je mayjäy oy nañ jadu'n yjɨjpcobadɨ̈yii, co ajcxy nejhuɨy je mɨjhuinma'ñ huɨdibɨ anajty Jesús ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Paady je fariseojäy ajcxy ñayñɨmaayɨ miñ xyɨpy: ―Ix ajcxy, ca' jada' ninej nmɨmadaacɨm Jesús, com tüg'ócɨy yɨ mayjäy axam ajcxy je' panɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nijëjɨty griegojäy nañ tɨ anajty ñɨcxcɨxy jɨm Jerusalén Dios ojadajtpɨ xɨɨjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chi jada' je griegojäy ajcxy nimɨjhuägy Felipe, huɨdibɨ anajty Betsaida cogajp jɨm Galilea naaxjot, e chi ajcxy mɨnucxtaacy nɨmay: ―Mɨgüg, tun may'ajt pubejtcɨch, Jesús ɨɨch ajcxy nja'ixamy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chi Felipe oy yajnɨmay Andrés, chi ajcxy Felipe etz Andrés oy Jesús yajnɨmay. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chi Jesús ymɨnañ: ―Tɨ je tiempo paady co ɨɨch je jäy huɨdibɨ tzoon tzajpjoty nyajcömayɨpyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Janch janch ɨɨch miich ajcxy jadu'n nɨmaaygɨxy co jäy nïby tüg mocpajc, e co je mocpajc ymuxy, huin'it yhuindɨgoy, e chi ytɨɨm'ajtnɨ may'amy. Pen ca' ni pɨn nïby jada mocpajc, ca' ytɨɨm'ada'ñ. Jadu'n ɨɨch nipaady nej je mocpajc. Copɨcy n'ögɨbyɨch, huin'it mayjäy jugy'ajtɨn paadaangɨxy huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy ni mɨna. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Je jäy huɨdibɨ ooy nïgɨ nixondägy yɨ chɨnaayɨn ya naaxhuiñ, yajtɨgoyamy je' yjugy'ajtɨn tüccɨ'yɨ. Per je pɨn ca'p ooy nijot'aty je chɨnaayɨn ya naaxhuiñ, e nixondaacɨ ooy nïgɨ Dios y'ayuc, je' y'alma nïdzoocɨn paadɨp ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pen ji jäy huɨdibɨ naybɨdaacɨp ma ɨɨch, copɨcy ajcxy xypanɨ́cxɨbɨch. Ma ɨɨch nyajpaady, nañ jɨm yɨ' yajpaadɨpy nañ jadu'n. Yɨ jäy pɨnjaty naybɨdaacɨp ma ɨɨch, Dios Teedy yɨ' cömayɨɨb. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chi Jesús yjacmɨnañ: ―Tájnɨbɨch mayñɨbɨch cham jotjoty huinma'ñyjoty. ¿Nej nnɨmähuɨbɨch nDeedyɨch? ¿Nïhuaangɨch ma jada ayo'n tzaachypɨ huɨdibɨ tɨ yhuaad'ajtnɨ? Ca' yjadu'nɨty. Com paady ycɨxp tɨ nmiiñɨch ma jada xɨɨ tiempo, jëbɨ ayo'n nyajnajxɨch mɨɨd jäy ajcxy ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dios Teedy tun huɨdibɨ copɨcy, jëbɨ jäy ajcxy ijxcɨxy miich mmɨc'ajt etz miich m'oy'ajt. Huin'it je jäy ajcxy huɨdi anajty jɨm ma Jesús yajpaady mɨdooy tüg ayuc choñ tzajpjoty ymɨnañ: ―Tɨ nduñɨch mɨjhuinma'ñ, e tɨ jäy ixy ɨɨch nmɨc'ajt n'oy'ajt. E nañ jadüg'oc ndunɨpyɨch mɨjhuinma'ñ, jɨgɨx jäy ajcxy íjxcɨxɨpy jadüg'oc ɨɨch nmɨc'ajt ɨɨch n'oy'ajt (jadu'n Dios y'adzooy y'ung Jesús). ");
INSERT INTO mcoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Je mayjäy huɨdibɨ anajty ajcxy jɨm, je tɨɨbɨ anajty ajcxy mɨdoogɨxy je ayuc huɨdibɨ tzoon tzajpjoty, ymɨnañ ajcxy: ―Enee yɨ' tɨ yjidity. Jacjadyii ajcxy ymɨnaañ: ―Tüg ángel tɨ ymɨgapxyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chi Jesús nɨmay je mayjäy ajcxy: ―Ca' nmɨnaanɨm mɨɨd ɨɨch ycɨxpɨ jadu'n tɨ yajmɨdoy jadayaabɨ ayuc huɨdibɨ tɨ chooñ tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jadachambɨ jada' Dios yajpocycähua'ñ naaxhuiñyjäy, e nañ ypɨgaanɨpy je mujcu' ymɨc'ajt huɨdibɨ ane'mb naaxhuiñyjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Co ɨɨch anajty jäy tɨ xyajcruudzpetyɨch, e co ɨɨch anajty tɨ njugypɨcyɨch jadügtecy, e co ɨɨch anajty tɨ nhuimbityɨch tzajpjoty, huin'it tüg'ócɨy jäy ajcxy huɨdibɨ xymɨbɨjcpɨch, nyajpa'ttɨgɨ̈huɨbɨch jiiby tzajpjoty ma nyajpaadyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Paady jadu'n Jesús ymɨnañ, jëbɨ huaad tüg'ócɨy jäy ajcxy huinjɨhuɨ̈huɨp ti o'cɨn anajty ypadamy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chi je mayjäy ajcxy ymɨnañ: ―Ma Dios ñecy jiiby jadu'n ymiñ jaybety co je Cristo huinɨxɨɨ je' y'ida'ñ. E ¿nej miich co cham jadu'n mɨna'ñ co copɨcy co yɨ jäy huɨdibɨ tzoon tzajpjoty, huimbidam jadügtecy tzajpjoty? ¿Pɨn jëdu'n mdijyp huɨdibɨ tzomb tzajpjoty? ");
INSERT INTO mcoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chi Jesús nɨmay je jäy ajcxy: ―Jahueenɨ xɨɨ tiempo njac'ida'ñɨch mɨɨd miich ajcxy. Jadu'n ɨɨch ndɨy'ajt nej tüg jɨɨn huɨdibɨ codɨɨcxp jäy co ytüyöy. Cuychɨnäy ɨɨch ndɨy'ajt, co tzojc nhuimbida'ñɨch tzajpjoty, e miich ajcxy mhuɨ'ma'ñ jadu'n nej jäy huɨdibɨ ca' jɨɨn mɨɨdɨty. Je jäy ajcxy huɨdibɨ ca' cuychɨnaaygɨxy ɨɨch ndɨy'ajt, ca' ajcxy nejhuɨɨygɨxy ma ñɨcxcɨxy. Jadu'n ajcxy nej jɨhuɨ̈y yöygɨxy coodz, e ca' ijxcɨxy ma ñɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Com occhaani ɨɨch ma miich ajcxy, nyaj'ixpɨjcyp ɨɨch miich ajcxy Dios ytɨy'ajt. Pen xymɨbɨ́jccɨxpɨch, m'íjtcɨxɨp ixpɨcy ma Dios ytɨy'ajtɨn. Co Jesús jadu'n je jäy ajcxy nɨmayday, huin'it Jesús je' ajcxy puhua'ctuutnɨ, chi ñɨcxnɨ, e ca' ma y'ocjac'ijxɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ooy anajty canaag mɨjhuinma'ñ Jesús tɨ jatuuñ ma jäy ajcxy yhuinduu, e ca' anajty ajcxy ni ti tɨm mɨbɨjccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Huɨdibɨ Jesús ytun ycapx, jiiby anajty jadu'n ycojayɨty ma je Dios y'ayuc necy, je Isaías ñecy, co Isaías jadu'n ymɨnañ: Huindzɨn, ca' ni pɨn ajt n'ayuc ndɨy'ajt tɨ xymɨbɨjcɨm. Ca' ni pɨn huɨdibɨ huinjɨhuɨɨyb je Huindzɨn Dios ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ca' anajty ajcxy huaad ymɨbɨjccɨxy, com nañ tɨ anajty jadu'n Isaías jay ma jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jadu'n yɨ' ajcxy nej jɨhuɨ̈y Dios tɨ yajhuindzɨɨygɨxy, e tɨ yajjotjunɨɨygɨxy, jɨgɨx ca' y'íjxcɨxɨpy mɨɨd yhuiin, e mɨɨd yjot yhuinma'ñ ca' huinjɨhuɨ́ɨyɨgɨxyɨpy, ni ycajothuimbíjtcɨxɨpy nej jëbɨ Cristo yajtzóocɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Paady jadu'n Isaías ymɨnañ je' co anajty tɨ ijxɨ Cristo y'oy'ajt, e chi cojay nej anajty tɨ ixy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ca' nidüg'ócɨy judío ixpɨcytɨjc mɨjotmädy anajty Jesús. Jɨm anajty nijëjɨty huindzɨndɨjc huɨdibɨ mɨbɨjcp Jesús. Per mɨɨd je fariseojäy ycɨxpɨ co chachjotma'tcɨxy, paady anajty ajcxy ca' capxpɨdzɨmgɨxy co mɨjpɨdaaccɨxy Jesús. Je' co chɨgɨɨygɨxy co jɨm yajpɨdzɨmɨɨyb ajcxy tüccɨ'yɨ ma Dios ytɨjc, etz ma yɨ judío ñaymujctac. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jacnïgɨ anajty tzojccɨxy co huen jäy cömáayɨgɨxy, ca'ydɨ co ajcxy Dios ycömayɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chi jada' Jesús ymɨnañ mɨc: ―Je jäy ajcxy huɨdibɨ xymɨbɨjcpɨch xymɨjpɨdaacpɨch, camɨnaanɨm ɨɨch naydüg xymɨbɨjcpɨch xymɨjpɨdaacpɨch, nañ ymɨbɨjcyp ymɨjpɨdacyp ajcxy je tɨɨbɨ ɨɨch ya naaxhuiñ xyquexyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","E je jäy huɨdibɨ xy'ijxpɨch, tɨm jadu'n nipaady nej jɨhuɨ̈y tɨ ixy je huɨdibɨ tɨ xyquexyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɨɨch tɨ nmɨmiiñɨch ya naaxhuiñ Dios ytɨy'ajt, jadu'n ɨɨch nipaady nej jɨhuɨ̈y tüg jɨɨn huɨdibɨ codɨɨcx je jäy ajcxy. Je jäy ajcxy huɨdibɨ xymɨbɨjcpɨch ca' ajcxy yhuɨ'mɨpy jɨbɨctuuby, jadu'n nej jɨhuɨ̈y ca' ajcxy chɨnaaygɨxy agootztuuby. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Je jäy ajcxy huɨdibɨ mɨdoob ɨɨch n'ayuc, e ca' cuydungɨxy, ca'p je' ɨɨch je' ypocy ajcxy n'ixyöyaanɨ nbayöyaanɨ cham. Ca'p ɨɨch tɨ nmiiñɨch ya naaxhuiñ mɨɨd co jäy ajcxy ndzaachytunɨpyɨch mɨɨd ypocy ycɨxpɨ. Paady ɨɨch tɨ nmiiñɨch ya naaxhuiñ co nyajpocyñïhuädza'ñɨch yɨ jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Je jäy ajcxy huɨdibɨ xycapxhuimbíjtɨbɨch n'ayuc, e ca' xycöbɨga'ñɨch, ymɨɨd ajcxy huɨdibɨ yajpocycähuɨɨb. Yɨ ayuc huɨdibɨ tɨ ngapxyɨch, yɨ' yajpocycähuɨɨb ajcxy co anajty naaxhuiñybɨ tɨ yhuaad'ajtnɨ co Dios anajty yajtɨgatzaanɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Com ɨɨch ca' ngɨ'm'ayuc ngapxhuäcxyɨch. Je' je' Dios Teedy y'ayuc, je huɨdibɨ tɨ xyquexyɨch, yɨ' ngapxhuäcxɨbɨch y'ayuc. Je huɨdibɨ tɨ xyquexyɨch ya naaxhuiñ tɨ xyñajtzcapxɨɨyɨch yɨ' y'ayuc, jada ayuc ngapxhuäcxypɨch nyajnɨmaaygɨxyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","E nejhuɨɨybɨch co Dios y'ayuc ytɨy'ajt ymɨmimyb yɨ' tzɨnaayɨn jugy'ajtɨn huɨdibɨ ca' tüccɨ'yɨ ycɨxy ytɨgoy. Paady ycɨx je ayuc huɨdibɨ ajcxy nyajmɨɨdmɨydacyp, jadu'n nyajmɨɨdmɨydaaccɨxy nej Dios Teedy tɨ xyajnajtz'ane'mɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ca'nɨ anajty xɨɨ paady, pascuaxɨɨ anajty ajcxy tijy. Chi Jesús ñejhuɨɨyb co anajty yxɨɨ ytiempo yhuaad'ajtnɨ mɨna chonaanɨ ya naaxhuiñ yhuimbidaanɨ ma Dios Teedy. E Jesús ooy anajty tzocy jɨhuɨ̈y ymɨgügtɨjc ajcxy huɨdibɨ ya naaxhuiñ anajty ajcxy huɨ'ma'ñ. Jadu'n tzocy jɨhuɨ̈y huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chi jada' Jesús etz ymɨgügtɨjc ytɨgɨɨy ajcxy adzuu'ajtp (je pascuaxɨɨ adzu'ajtɨn). Tɨ anajty je mujcu' huinma'ñymöy Judas Iscariote, Simón ymang, co anajty Jesús cɨ̈yega'ñ ma ymɨdzip ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ñejhuɨɨyb anajty Jesús co je Dios Teedy tɨ yajcɨ̈dɨgɨ̈yii tüg'ócɨy ymɨc'ajt, e Jesús nañ ñejhuɨɨyb anajty co je' tɨ chooñ ma Dios y'it, e nañ jiiby anajty jadüg'oc yhuimbida'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chi ypɨdɨ̈gy ma mesɨ, chi je yoñybɨ yhuit ñayyajnïjenduuttɨ. Chi huijtzɨ̈gy tüg huit huɨdibɨ mɨɨd ñaymextɨɨtzɨ nayböttɨɨtzɨ, ñayyajmɨjxojtzpejtɨ yhuindɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Co jadu'n ñayñi'ixɨɨyɨ, chi pɨdacy nɨɨ ma tüg cɨ̈bujɨ'ñyboc. Chi nihuägɨɨyɨ ydiscípulos ajcxy ytecy. Chi yajtzondacy tecypujɨɨ tüg tüg, e mextɨɨch pöttɨɨch mɨɨd je huit huɨdibɨ anajty tɨ ñayyajhuindɨyɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Co nihuägɨɨyɨ Simón Pedro ytecy, chi Pedro ymɨnañ: ―Huindzɨn, ca' huaad miich ndecy xypujɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chi Jesús y'adzooy: ―Huɨdibɨ ɨɨch ndumyb ca' yɨ' miich ajcxy mhuinjɨhuɨɨygɨxy jadachambɨ, jaccomjecy miich ajcxy mhuinjɨhuɨ̈huɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chi Pedro y'adzooy: ―Miich ca' huaad ɨɨch ndecy xypujɨch ni camɨnaabɨ. Chi Jesús y'adzohuimbijty: ―Pen ca' mdecy nbujɨ, ca' ɨɨch miich jëbɨ njäy'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","E huin'it Pedro nɨmay Jesús: ―Huindzɨn, ca' ɨɨch jëda'ajty ndecy xypújɨbɨch, hue' janchtɨy tüg'ócɨy ngɨ̈jɨch etz ngohuajcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chi Jesús nɨmay Pedro: ―Com tɨɨbɨ mjot mhuinma'ñ yajhuäch, ca' yɨ' ocjactzojcnɨ yajhuädzɨpy mjot mhuinma'ñ jadügtecy. Tɨm jadu'n nej jɨhuɨ̈y naamnɨ chïy, e cham ca' tzojcnɨ yajtzïhuɨbyɨch jadügtecy. Jëda'ajty mdecy nbujɨch cham. Miich ajcxy huädz mjot mhuinma'ñ ajcxy mmɨɨdɨñ, oy ca' miich ajcxy nidüg'ócɨy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Com Jesús ñejhuɨɨyb anajty pɨnjäy cɨ̈yegaanɨp ma ymɨdzip, e paady jadu'n ymɨnañ: ―Ca' ni tüg'ócɨy miich ajcxy mjot mhuinma'ñ yhuädzɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chi jada' co yajtecypujtay, chi jada' yoñyhuit yajtɨgɨɨy jadüg'oc. Y'ixtacy ma mesɨ, e chi jada' nɨmay ajcxy: ―¿Nej mhuinjɨhuɨɨyb ajcxy ti ɨɨch tɨ nduñɨch mɨɨd miich ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Miich ajcxy jadu'n mɨnamb co ɨɨch miich ajcxy myaj'ixpɨjcy, etz ɨɨch miich xyhuindzɨn'ajtpɨch. E tɨydudägy miich ajcxy mɨna'ñ com ɨɨch jëdu'n miich ajcxy mHuindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pen ɨɨch miich ajcxy nyaj'ixpɨjcyp etz xyhuindzɨn'ajtpɨch, e tɨ ɨɨch miich ajcxy nyajtecypujy, nañ jadu'n miich ajcxy myajtecypujɨɨyb miñ xyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ɨɨch miich ajcxy tɨ nmöy tüg ijxpejt, jɨgɨx ajcxy jadu'n mdunɨpy jadu'n nej tɨ nduñɨch, e huin'it ca' amɨj agɨx nayjɨhuɨ̈huɨɨyb ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Janch janch ɨɨch miich ajcxy yam jadu'n nnɨmäy co je huindzɨn jac mɨj je' ca'ydɨ yɨ' ytumbɨ. E nañ je' huɨdibɨ yajquejxyöyb jac mɨj je' ca'ydɨ huɨdibɨ quejxyöyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Co ajcxy tɨy'ajt mnejhuɨ̈huɨpy, chi jotcujc ajcxy m'idɨpy, pen mbadumyb ajcxy jadu'n nej nduñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ca' nmɨna'ñɨch co nidüg'ócɨy miich ajcxy mbocymɨɨdɨty. Tɨ ɨɨch yɨ' nnejhuɨ̈y pɨn tɨ nhuin'ixyɨch. Tɨ nhuin'ixyɨch tüg huɨdibɨ pocymɨɨd, jɨgɨx cuyduunɨp nej anajty yjaybetyɨty ma Dios ñecy ma je Cristo jadu'n ymɨna'ñ: “Yɨ' huɨdibɨ caymujcp mɨɨd ɨɨch, tɨ ɨɨch yɨ' xymɨbɨdɨ̈gy.” ");
INSERT INTO mcoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tɨ ɨɨch yam miich ajcxy jayɨjp nyajnɨmaaygɨxy, jɨgɨx co anajty jadu'n ytunyii yjadyii, mmɨbɨgɨpy ajcxy co ɨɨch jëdu'n je Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Janch janch yam ajcxy jadu'n nnɨmaaygɨxy co je jäy ajcxy huɨdibɨ cöbɨjcp je huɨdibɨ anajty nguejxypɨch, tɨm jadu'n nipaady jadu'n nej ɨɨch anajty xycöbɨjcyɨch. E je jäy ajcxy huɨdibɨ xycöbɨjcpɨch, je' ajcxy anajty ycöbɨjcyp je' huɨdibɨ xyquejxɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Co jadu'n Jesús ymɨnañ, chi tajnɨp mayñɨp anajty ooy jotjoty huinma'ñyjoty, chi capxypɨdzɨmy: ―Janch janch ɨɨch miich ajcxy yam jadu'n nɨmäy co nidügtɨ miich ajcxy xycɨ̈yega'ñɨch ma nmɨdzipɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chi Jesús ydiscípulos ajcxy ñayhuindɨcxpejttaayɨ nidüg nidüg. Ca' anajty ajcxy nejhuɨ̈y pɨn anajty jëdu'n Jesús ytijyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nidügtɨ je' ajcxy huɨdibɨ anajty Jesús ooy mɨɨd ñaychogyii ɨñäy anajty ma mesɨ tɨm huingon ma Jesús yhuinduu. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chi Simón Pedro ycɨ' yaj'ijxy yajhuinjɨhuɨy co huen yaj'amɨdooy Jesús pɨn anajty jadu'n ytijyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chi je discípulos ajcxy huɨdibɨ anajty ɨñaayb ma Jesús yhuinduu nɨmay yhuindzɨn: ―¿Pɨn jadu'n mdijyp? ");
INSERT INTO mcoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chi Jesús y'adzooy: ―Yɨ' je' pɨn anajty ɨɨch nmooybɨch yɨ tzajcaagy huɨdibɨ anajty nyajxoocpyɨch ma je ügy. Chi yajxoogy tüg pedasɨ tzajcaagy, chi moy je Judas, je Simón Iscariote ymang. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tɨm huin'ítɨy co Judas je tzajcaagy cöbɨjcy, chi je mujcu' ytɨgɨɨy ma je' y'ay yjot. Chi Jesús nɨmay Judas: ―Yɨ huɨdibɨ mdunamyb, tungo jadu'n mɨc'amy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Huɨdijaty anajty ajcxy jɨm caayb, ni pɨn cahuinjɨhuɨy je ayuc huɨdibɨ Jesús yajnɨmay Judas, nej je ayuc yhuimbɨdzɨmy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Com je Judas anajty mɨɨd je meeñybijty, paady ajcxy nijëjɨty huinjɨhuɨy co anajty tijy ñɨmäyii: ―Nɨcx juy yɨ huɨdibɨ ajt nyajmayjajtɨm yɨ xɨɨgɨxpɨ. Jacjadyii ajcxy anajty tijy ñɨmäyii: ―Mo' tigatii ayoobɨtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tɨm huin'ítɨy co je tzajcaagy cayday, chi ypɨdzɨmy Judas tɨba'y, e tɨ anajty ycoodzɨɨyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Co Judas ypɨdzɨmy, chi Jesús ymɨnañ: ―Cham je jäy ajcxy ixa'ñ ɨɨch nmɨc'ajt ɨɨch n'oy'ajt, ɨɨch je jäy huɨdibɨ tzoon tzajpjoty. Etz nañ ma ɨɨch je jäy ajcxy ixa'ñ Dios ymɨc'ajt Dios y'oy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jadu'n nej je jäy ajcxy tɨ ijxcɨxy Dios ymɨc'ajt ma ɨɨch, nañ tɨm jadu'n Dios yajniguëxɨ̈gɨpy yɨ nmɨc'ajtɨch n'oy'ajtɨch tɨm mɨc'amy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mɨgügtɨjc huɨdibɨ ooy ndzocy njɨhuɨ̈yɨch, ca' n'ochuäcxɨbaanɨch jecy mɨɨd miich ajcxy. Xy'ixtähuɨbɨch miich ajcxy. Jadu'n nej tɨ nnɨmáaygɨxyɨch yɨ jacjadyii judíojäy ajcxy, nañ jadu'n ɨɨch miich ajcxy yam njacnɨmaaygɨxy co ma nnɨcxa'ñɨch, ca' huaad miich ajcxy jiiby mnɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cham ajcxy nmöhua'ñ tüg ané'mɨn huinjemybɨ. Cham miich ajcxy nyajnajtz'ane'mɨ̈huaangɨxy jadüg'oc jadayaabɨ tɨy'ajt: Naychójcɨgɨx nayjɨhuɨ́ɨyɨgɨx ajcxy nidüg nidüg, tɨm jadu'n nej ɨɨch miich ajcxy tɨ ndzocy tɨ njɨhuɨ̈y. Naychójcɨgɨx nayjɨhuɨ́ɨyɨgɨx aguipxyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mɨɨd jada ycɨxpɨ ñejhuɨ̈huɨpy tüg'ócɨy jäy co ɨɨch miich ajcxy tɨ nyaj'ixpɨjccɨxy co ajcxy nidüg nidüg mnaychogɨɨyb mnayjɨhuɨ̈huɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chi Pedro nɨmay: ―Huindzɨn, ¿ma miich mnɨcxa'ñ? Huin'it Jesús y'adzooy: ―Ma ɨɨch nnɨcxa'ñɨch miich ca' huaad xypanɨcxyɨch. Jac'axam xypanɨ́cxɨbyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chi Pedro ymɨnañ: ―E ¿nej co ca' huaad jëbɨ ɨɨch miich nbanɨcxy? com ɨɨch ngɨ̈yegamyɨch njugy'ajtɨn ma yɨ o'cɨn mɨɨd miich ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chi jada' Jesús y'adzooy: ―¿Nej janch co mgɨ̈yega'ñ yɨ mjugy'ajtɨn ma yɨ o'cɨn mɨɨd ɨɨch ycɨxpɨ? Janch janch ɨɨch miich ajcxy yam jadu'n nɨmäy, co ni ca'nɨ anajty jabom tugɨɨg'oc tzey yaaxɨ̈gy, co ɨɨch miich anajty tugɨɨg'oc tɨ xycoyüchɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Chi Jesús yjacmɨnañ: ―Ca' ajcxy jotmay mjɨhuɨ̈y ma m'aa mjot mɨɨd jada ayuc. Mɨbɨc ajcxy Dios etz ɨɨch nañ jadu'n mɨbɨjccɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jiiby ma ɨɨch nDeedy chɨnäy, jiiby mɨjtɨgɨydac. Co ixyipy ca' yjadu'nɨty, ca' ixyipy tɨ nnɨmaaygɨxy co nnɨcxyɨch ma nDeedyɨch n'ocni'ixɨy tzɨnaaydac mɨɨd miich ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","E co ɨɨch anajty tɨ nba'ttɨgɨ̈yɨch, e tɨ ni'ixɨɨyɨch tzɨnaaydac jayɨjp mɨɨd miich ajcxy ycɨxpɨ, huin'it ajcxy nihuimbidɨpy, jëbɨ ɨɨch ajt naydügmujcɨm, jɨgɨx ma anajty n'ityɨch, nañ jiiby miich ajcxy m'idɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Miich ajcxy mnejhuɨɨyb nej jëbɨ ajcxy mjädɨp ma nnɨcxyɨch oyduuby. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chi Tomás ymɨnañ: ―Huindzɨn, ca' ɨɨch ajcxy nejhuɨɨygɨxy ma miich mnɨcxa'ñ, e ca' ɨɨch ajcxy nnejhuɨɨygɨxy nej jëbɨ njá'tcɨxɨbyɨch jiiby. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chi Jesús y'adzooy: ―Jadu'n nej tɨ ndzɨnäyɨch jada je' je ijxpejt nej Dios tzocy co miich ajcxy mdzɨnähuɨpy. Nyejcpyɨch je tɨy'ajt huɨdibɨ jëbɨ huaad mguychɨnaaygɨxy. Co jadu'n mguydundáygɨxɨpy ɨɨch ndɨy'ajt, chi mjá'tcɨxɨpy ma Dios. Nyejcpyɨch je jugy'ajtɨn huɨdibɨ ca' tüccɨ'yɨ ycɨxy ytɨgoy. Ca' ni pɨnjäy yjädɨpy ma Dios Teedy, penɨ ca' cuydundäy ɨɨch ndɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jadachambɨ etz nej xɨɨ tiempo yjacnɨcxa'ñ miich ajcxy m'ixy'ajty Dios Teedy. Pen xy'ixy'ajtpɨch miich ajcxy, nañ m'ixy'ajtyp miich ajcxy Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chi Felipe y'adzoy: ―Huindzɨn, ɨɨch ajcxy yɨ Dios Teedy yaj'ijxcɨch cham cham, e mɨɨd tɨm yɨ'yɨ jotcujc'adɨpyɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Paady Jesús nɨmay je Felipe: ―Cham xɨɨ jɨmɨjt ñɨcxnɨ maabɨ ɨɨch nja'ityɨch mɨɨd miich ajcxy, e ¿ca'nɨ miich xytɨmy'ijxhuɨ'myɨch Felipe? Yɨ jäy ajcxy tɨɨbɨ xy'íjxcɨxyɨch, nañ y'ijxyp ajcxy yɨ' Dios Teedy. E chi jada', ¿nej miich co jadu'n xyñɨmäyɨch: “Yaj'ijxcɨch je Dios Teedy?” ");
INSERT INTO mcoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Nej ca' mmɨbɨcy co ɨɨch n'ity ma Dios Teedy, e Dios Teedy ijtp ma ɨɨch? Yɨ ayuc huɨdibɨ ngapxhuäcxypɨch, ca' yɨ' ngɨ'm'ayuc'adyiijɨch ngɨ'mdɨy'ajt'adyiijɨch. Yɨ mɨjhuinma'ñ huɨdibɨ ajcxy m'ijxyp ndumybɨch, yɨ Dios Teedy huɨdibɨ ijt ma ɨɨch, yɨ' jadu'n tumb. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mɨbɨjccɨch ajcxy co ɨɨch n'ityɨch ma Dios Teedy, e Dios Teedy ijtp ma ɨɨch. Penɨ ca' mdɨmmɨbɨgaangɨxy, mɨbɨc ajcxy mɨɨd je mɨjhuinma'ñ ycɨxpɨ huɨdibɨ tɨ nduñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Janch janch ɨɨch miich ajcxy jadu'n nɨmaaygɨxy co je jäy ajcxy huɨdibɨ xymɨbɨjcpɨch, nañ ytunɨpy ajcxy nañ jadu'n yɨ mɨjhuinma'ñ huɨdibɨ tɨ nduñɨch. Jac tɨm nïgɨ tunɨpy mɨjhuinma'ñ, com ɨɨch nnɨcxaambɨch ma Dios Teedy y'ity. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E tüg'ócɨy ti miich ajcxy mɨbɨjctzooyb ma Dios Teedy mɨɨd ɨɨch nxɨɨ, ndunɨpyɨch yɨ'. Dios Teedy huɨdibɨ nDeedy'ajtypɨch, je' cömay y'idɨp mɨɨd huɨdibɨ miich anajty ajcxy mdumyb mɨɨd ɨɨch nmɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Co myajmɨbɨjctzohuɨpy tijaty, xycapxpáatɨbɨch nxɨɨ, huin'it nguydunɨpyɨch huɨdibɨ anajty tɨ mbɨjctzoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Penɨ xychojcpɨch miich ajcxy, cuydúnɨgɨch ajcxy tüg'ócɨy n'ayuc ndɨy'ajt, jadu'n nej anajty tɨ nnajtz'ane'mɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","E co ndzóonɨbyɨch, chi nbɨjctzóohuɨbyɨch yɨ Dios Teedy jadüg yjaymɨɨd huɨdibɨ ajcxy xyjaymɨɨd'adɨɨb. Dios ajcxy xymöhuɨpy jadüg jaymɨɨd huɨdibɨ ajcxy xycapxhuijɨp, je huɨdibɨ ajcxy mjot'amɨj'adɨɨyb, e je' xymɨɨd'idɨpy ajcxy huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Je huɨdibɨ xycapxhuɨjɨp, je' jada'ajty Dios yjɨhuɨ'ñ ymɨc'ajt, je Espíritu Santo. Je' Dios ytɨy'ajt ymɨɨd. Dios yjɨhuɨ'ñ ymɨc'ajt ca' adɨgɨ̈hua'ñ yɨ naaxhuiñyjäy huɨdibɨ ca' xymɨbɨcyɨch. Com ca' ajcxy ixy, e nañ ca' ajcxy ixy'adyii je Espíritu Santo. Miich ajcxy m'ixy'ajtyp je Espíritu Santo, com je' tzɨnaayb ma miich ajcxy, e nañ xy'adɨgɨ̈huɨpy xyjottɨgɨ̈huɨpy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ca' miich ajcxy nyajhuɨ'maangɨxy naydüg jadu'n nej co'ögy'ung. Nnihuimbidɨpyɨch miich ajcxy jadügtecy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tɨm huingónɨp yɨ xɨɨ tiempo mɨna yɨ jacjadyii naaxhuiñyjäy ajcxy ca' xy'ocjac'íjxnɨbɨch. Com jadu'n nej ɨɨch njactzɨnähua'ñ, ca' ɨɨch njugy'ajtɨn ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. Nañ jadu'n miich ajcxy mjactzɨnähua'ñ, ca' mjugy'ajtɨn ajcxy ycɨxɨpy ytɨgoyɨpy tüccɨ'yɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Co anajty Dios yjɨhuɨ'ñ ymɨc'ajt ajcxy xy'adɨgɨ̈y xyjottɨgɨ̈y, huin'it ajcxy mnejhuɨ̈huɨpy co nyajpaadyɨch ma nDeedyɨch, yɨ Dios Teedy, e miich ajcxy myajpaady ma ɨɨch, e ɨɨch nañ jadu'n yajpatpɨch ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Je jäy ajcxy huɨdibɨ ɨɨch n'ayuc ndɨy'ajtɨch xycöbɨjcɨp, e cuydungɨxy, je' je' jadu'n xychojcpɨch, e tzogɨɨb je' ɨɨch nDeedy. E ɨɨch nañ jadu'n ndzogɨpy njɨhuɨ̈huɨbyɨch je' ajcxy, e nnayyajniguëxɨ̈gɨɨybɨch ma je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Je jadügpɨ Judas, ca' nmɨnaanɨm Judas Iscariote, nɨmay Jesús: ―Huindzɨn, ¿nej co mnayyajniguëxɨ̈ga'ñyii ma ɨɨch ajcxy, e ca' mnayyajniguëxɨ̈ga'ñyii ma je jäy ajcxy huɨdibɨ ca' xymɨjpɨdägy? ");
INSERT INTO mcoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chi Jesús je' y'adzooy: ―Yɨ jäy ajcxy huɨdibɨ xychojcpɨch xyajmɨj'ajtpɨch, xycuydúunɨbɨch yɨ' ajcxy ɨɨch n'ayuc ndɨy'ajt. E huin'it yɨ' ajcxy chogɨɨyb ɨɨch nDeedy. Je nDeedyɨch etz ɨɨch miinɨp ɨɨch ajcxy ma je jäy ajcxy huɨdibɨ xycuyduunɨp ɨɨch ndɨy'ajt, e tzɨnaydacpɨgɨpyɨch ma yɨ' ajcxy yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Je jäy ajcxy pɨnjaty ca' xychocyɨch, nañ ca' ajcxy ɨɨch n'ayuc xycuyduunɨch. Paady ca' nnayyajniguëxɨ̈ga'ñyiijɨch ma je' ajcxy. Com yɨ ayuc huɨdibɨch miich ajcxy nyaj'amɨdo'ijtyp, ca' yɨ' ɨɨch ngɨ'm'ayuc'adyii. Yɨ' je' Dios Teedy y'ayuc ytɨy'ajt, com yɨ' ɨɨch ya naaxhuiñ xyquejxɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Jadayaabɨ ayuc ajcxy cham jadu'n njacyajnɨmaayb, jadu'n nej njacyáanɨgyɨch ya naaxhuiñ mɨɨd miich ajcxy, ma ca'nɨ ndzooñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Per je Espíritu Santo huɨdi miinam, je' ajcxy xycapxhuijɨp. Dios Teedy yquexamy je Espíritu Santo mɨɨd ɨɨch nxɨɨ. Je Espíritu Santo xyajnejhuɨydähuɨpy miich ajcxy tüg'ócɨy tɨy'ajt, e nañ xyaj'ajɨhuɨ̈huɨɨb tüg'ócɨy jadu'n nej ɨɨch miich ajcxy nnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ɨɨch miich ajcxy nyajmɨhuɨ'my jotcujc'ajtɨn. Jadu'n nej ɨɨch njotcujc'atyɨch, nañ nyajjotcujc'adɨpyɨch miich ajcxy. Yɨ jotcujc'ajtɨn huɨdibɨ nyajmɨhuɨ̈maamyɨch miich ajcxy, ca' yɨ' yjadu'nɨty nej je jotcujc'ajtɨn huɨdibɨ yajpaatp ya naaxhuiñ. Ca' mdajcɨxy maygɨxy, nañ ca' mdzɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tɨ ɨɨch miich ajcxy nnɨmaaygɨxy jayɨjp'aty co ndzona'ñɨch ma miich ajcxy, e nhuimbida'ñɨch jadüg'oc ma miich ajcxy. Penɨ xychojcpɨch miich ajcxy, mxondägɨpy ajcxy co nnɨcxa'ñɨch ma Dios Teedy, com yɨ Dios Teedy jac mɨj yɨ' ca'ydɨ ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tɨ ɨɨch jada tɨy'ajt jayɨjp nimɨydägyɨch ma ca'nɨ ndzooñɨch, jɨgɨx co anajty je tiempo paady mɨna jadayaabɨ ytunɨɨyb yjadɨɨyb, huin'it ajcxy mmɨbɨgɨpy ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","E ca' ɨɨch miich ajcxy mɨjcajee ooy njacmɨɨdmɨydägaangɨxy yam. Com tɨm huingónɨp mɨna je mujcu' huɨdibɨ ane'mb ya naaxhuiñ xyñimina'ñɨch. Ca' ɨɨch yɨ' huaad jëbɨ xymɨmadägyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Per copɨcy yɨ' nguydunɨpyɨch Dios Teedy y'ayuc nej xyajnajtz'ane'mɨɨyɨch, jɨgɨx je naaxhuiñyjäy nejhuɨ̈huɨpy co nyajmɨj'atyɨch yɨ Dios Teedy. Pɨdɨ̈ccɨx, tzoc'ajt huingduum jamɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Chi Jesús jacnɨmay ydiscípulos ajcxy: ―Jadu'n ɨɨch nipaady nej camuux'aadz ma tüg muuxy'aadz cam. Ɨɨch nDeedy, yɨ Dios Teedy, jadu'n yɨ' nipaady nej je muuxy'aadz cam cuend'ajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tüg'ócɨy jäy jadu'n ajcxy nipaady nej muuxy'aadz y'aacx. Je jäy ajcxy huɨdibɨ ca' cuychɨnäy ɨɨch ndɨy'ajt, yɨ Dios Teedy yajcödɨgoyɨɨb, jadu'n nej je muuxy'aadz cam cuend'ajtpɨ quejtzpuxy je muuxy'aadz y'aacx huɨdibɨ ca' ytɨɨm'aty. Je jäy ajcxy huɨdibɨ cuydundaayb ɨɨch ndɨy'ajt, Dios yaj'oyɨɨb je' ajcxy yjot yhuinma'ñ, jëbɨ oybɨ tuñ, jadu'n nej je muuxy'aadz cam cuend'ajtpɨ huijtz'oyɨ̈y je muuxy'aadz y'aacx, jɨgɨx jëbɨ nïgɨ ytɨɨm'aty. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yɨ ayuc huɨdibɨ tɨ nyajnɨmaaygɨxy, yɨ' tɨ yajhuäch yɨ jɨbɨcpɨ ma miich ajcxy mjot mhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mɨbɨjccɨch ajcxy, panɨ́cxɨgɨch ajcxy ndɨy'ajt huinɨxɨɨ. Co ajcxy jadu'n mdunɨpy, ɨɨch miich ajcxy mɨɨd'idɨpy huinɨxɨɨ. Jadu'n nej ixyipy camuuxy'aadz y'aacx co ca' ytɨɨm'aty co ahuinggujc y'ity, e ca' mɨc'ajt paady ma ycop. Nañ tɨm jadu'n miich ajcxy pen ca' mmɨc'ajt mbaadɨpy ma ɨɨch, ca' mmɨmadáaccɨxɨpy mguychɨnáaygɨxɨpy ɨɨch ndɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Jadu'n ɨɨch nipaady nej camuuxy'aadz cop, e miich ajcxy jadu'n nipaady nej camuuxy'aadz y'aacx. Je jäy ajcxy huɨdibɨ yajpatp ma ɨɨch, e ɨɨch nyajpaady ma je' ajcxy, je' ajcxy oyhuinma'ñ tunam mɨj cajee, tɨm jadu'n nej camuuxy'aadz huɨdibɨ tɨɨm'ajtp may'amy. Co ixyipy ɨɨch ca' nyajpaady ma miich ajcxy, ca' miich ajcxy huaad ti mdungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Co jäy ajcxy ndɨy'ajt xy'ixmájtzɨbɨch, Dios ajcxy yajcödɨgoyɨɨb, tɨm jadu'n nej jäy yajcödɨgoy mɨɨd jɨɨn yɨ muuxy'aadz y'aacx huɨdibɨ ymɨbuxɨɨyb co ca' ytɨɨm'ajtnɨ. Co je y'aacx ytɨ̈dzɨty, chi ajcxy yajmucy, e pɨdaaccɨxy jɨɨnjoty, e jadu'n jiiby ñïdoyɨ̈y jɨɨnjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Co miich ajcxy m'ijtcɨxy ma ɨɨch, e co ɨɨch n'ayuc nañ jadu'n ijtp ma miich ajcxy mjot mhuinma'ñ, jëbɨ mbɨjctzoogɨxy ti ajcxy mdzojcyp ma Dios, e nguydunɨpyɨch mɨɨd miich ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chi je jäy ajcxy cömayɨpy Dios co miich ajcxy mguydunɨpy ɨɨch ndɨy'ajt tɨydudägy, tɨm jadu'n nej camuuxy'aadz y'aacx ytɨɨm'aty may'amy. Co je jäy ajcxy ixɨpy nej tudägy mguydungɨxy ɨɨch ndɨy'ajt, chi je jäy ajcxy tɨydudägy nejhuɨ̈huɨpy co tɨ nyaj'ixpɨcyɨch miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jadu'n nej Dios Teedy xychocyɨch xyjɨhuɨ̈yɨch, nañ tɨm jadu'n ɨɨch miich ajcxy tɨ ndzocy tɨ njɨhuɨ̈yɨch. Ndzogɨpy njɨhuɨ̈huɨbyɨch miich ajcxy huinɨxɨɨ co ca' ajcxy xy'ixmájtzɨbyɨch ndɨy'ajtɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Co mguydundähuɨpy ajcxy jadu'n nej nyajnajtz'ane'mɨɨygɨxy, ndzogɨpyɨch njɨhuɨ̈huɨbyɨch miich ajcxy huinɨxɨɨ. Tɨm jadu'n nej nguyduñɨch yɨ huɨdibɨ Dios Teedy xyajnajtz'ane'mɨɨybɨch, e yɨ' xychojcpɨch xyjɨhuɨɨybɨch huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Cham jadayaabɨ ayuc nyajnajtz'ane'mɨɨygɨxy, jɨgɨx jotcujc m'ijtcɨxɨpy. Jadu'n nej jotcujc tɨ n'ityɨch, e nañ jadu'n miich ajcxy mjotcujc'adɨpy anaxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jadaabɨ ayuc ɨɨch miich ajcxy nyajnajtz'ane'mɨɨybɨch co naychójcɨgɨx nayjɨhuɨ́ɨyɨgɨx nidüg nidüg, tɨm jadu'n nej ɨɨch miich ajcxy ndzocy njɨhuɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Je tɨy'ajt jac'oybɨ co mɨgügtɨjc ajcxy naychogɨɨyb nayjɨhuɨ̈huɨɨyb, co tüg jäy cɨ̈yegɨpy yjugy'ajtɨn mɨɨd ymɨgügtɨjc ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɨɨch miich ajcxy mɨgüg'ajtyp, pen mguydumyb nej ajcxy nyajnajtz'ane'mɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jadu'n nej xɨɨ tiempo yjacnɨcxa'ñ, ca' miich ajcxy n'ocnaydijnɨp ɨɨch ndumbɨ. Com je tumbɨ ca' huinjɨhuɨ̈y huɨdibɨ yhuindzɨn ytumyb. Hue' miich ajcxy nyajnaxyɨch nmɨgügtɨjcɨch, com tüg'ócɨy tɨy'ajt tɨɨbɨ nmɨdooyɨch ma ɨɨch nDeedy, yɨ Dios Teedy, tɨ ɨɨch miich ajcxy nnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ca' nmɨnaanɨm ɨɨch miich ajcxy tɨ xyhuin'ixy. Ɨɨch miich janchtɨy ajcxy tɨ nhuin'ixy. E tɨ ɨɨch miich ajcxy nyajnïbɨcy co nɨcxy mgapxhuäcxcɨxy ɨɨch n'ayuc. E nañ mayjäy mɨjpɨdägɨpy je ayuc huɨdibɨ miich ajcxy mgapxhuäcxɨpy. E nañ ɨɨch n'ayuc, huɨdibɨ miich ajcxy mgapxhuäcxɨpy, y'idɨpy ma je jäy ajcxy yjot yhuinma'ñ huinɨxɨɨ. Paady ycɨx tüg'ócɨy tijaty miich ajcxy mbɨjctzooyb ma Dios Teedy mɨɨd ɨɨch nxɨɨ, yɨ' ajcxy xymöhuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jada ayuc ajcxy yam nyajnajtz'ane'mɨɨyb co ajcxy mnaychogɨɨyb mnayjɨhuɨ̈huɨɨyb miñ xyɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Co je may naaxhuiñyjäy ca' xy'ixaangɨxy miich ajcxy, ca' ajcxy ooy mhuinmayɨpy, com mnejhuɨɨyb ajcxy co ɨɨch nañ jadu'n jac jayɨjp ca' yɨ' ajcxy tɨ xy'ixáangɨxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Co ixyipy ytügɨ̈y miich ajcxy m'ayuc mdɨy'ajt mɨɨd je jacjadyii naaxhuiñyjäy y'ayuc ytɨy'ajt, huin'it ixyipy ajcxy xychojccɨxy xyjɨhuɨɨygɨxy, com tú'cɨy miich ajcxy mhuinma'ñ ixyipy mɨɨd yɨ' ajcxy yhuinma'ñ. Janch com co ca' ytügɨ̈y miich ajcxy m'ayuc mdɨy'ajt mɨɨd je jacjadyii naaxhuiñyjäy y'ayuc ytɨy'ajt, paady je jacjadyii naaxhuiñyjäy ca' ajcxy xy'ixa'nɨp. Com ɨɨch miich ajcxy tɨ nyajjɨjphuijtztüdy, jadu'n nej yɨ jacjadyii naaxhuiñyjäy ajcxy chɨnaaygɨxy yjugy'ajtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","M'ajɨhuɨ̈huɨɨb ajcxy jadu'n nej tɨ nnɨmaaygɨxy co ɨɨch miich ajcxy xyhuindzɨn'ajtpɨch, paady jac mɨj ɨɨch ca'ydɨ miich ajcxy. Jadu'n nej naaxhuiñyjäy ajcxy tɨ xy'ixhuɨdityɨch tɨ xypahuɨdityɨch, nañ jadu'n miich ajcxy yɨ' xy'ixhuɨdida'ñ xypahuɨdida'ñ. Nañ may je jäy huɨdibɨ ca' tɨ xycapxymɨdooyɨch, nañ jadu'n may je jäy huɨdibɨ miich ajcxy ca' xycapxymɨdohuaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nijot ajcxy y'idɨ̈tzaangɨxy mɨɨd miich ajcxy ycɨxpɨ, com ca' ajcxy ixy'adyii Dios Teedy huɨdibɨ xyquejxyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Co ixyipy ca' tɨ nmiiñɨch ya naaxhuiñ nyajnɨmäyɨch je jäy ajcxy Dios ytɨy'ajt, ca' ixyipy ajcxy pocy mɨɨdɨty. Per com tɨ nmiiñɨch ya naaxhuiñ, paady cham ypocy ajcxy mɨɨdɨty co ca' ajcxy xy'ixa'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Je jäy ajcxy huɨdibɨ ca' xy'ixa'ñɨch, jadu'n nipaady nej ɨɨch nDeedy ca' ajcxy ixaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Co ixyipy ɨɨch ca' tɨ nduñɨch ma yɨ ajcxy yhuinduu mɨjhuinma'ñ, huɨdibɨ ca' ni pɨn jäy tuñɨ, ca' ixyipy ajcxy pocy mɨɨdɨty. E janch tɨ ajcxy ooy ja'ijxcɨxy je mɨjhuinma'ñ, e ca' ɨɨch yɨ' ajcxy xy'ixa'ñ, e nañ ca' ixaangɨxy ɨɨch nDeedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Paady jada jadu'n ytuñyii yjadyii, jɨgɨx yajcuydunɨpy jadu'n nej ycojaayɨty ma yɨ judíojäy ajcxy ley ñecy, ma jadu'n ymɨna'ñ: “Ni ti tɨy'ajt ycaca'ty, co ɨɨch yɨ ajcxy ca' xy'ixa'ñɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","E co anajty xyñigɨdaaccɨxy yɨ Espíritu Santo, yɨ huɨdibɨ xycapxhuijɨp ajcxy, je huɨdibɨ miich ajcxy nyajniguexam, chon ma Dios Teedy, je huɨdibɨ Dios ytɨy'ajt mɨɨd. Yɨ' xyñidɨy'ajt'adaambɨch co Dios ytɨy'ajt nmɨɨdɨdyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","E miich ajcxy nañ jadu'n xyñidɨy'ajt'adɨpɨch co Dios ytɨy'ajt nmɨɨdɨdyɨch. Com ɨɨch miich ajcxy jayɨjp nyaj'ixpɨjctzondac Dios y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tɨ ajcxy yam tɨy'ajt njacyajnɨmaaygɨxy, jɨgɨx ca' ajcxy m'ixtɨgɨ̈huägɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Com judíojäy ajcxy xy'ixhuidzɨpy ajcxy ma ajcxy yɨ' ñaymujctac. Ypadaamy yɨ xɨɨ tiempo co miich ajcxy jäy xyaj'ögɨpy, hue' ajcxy tijɨpy co Dios anajty ooy jadu'n jäygɨdägy tɨɨbɨ anajty ajcxy tuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Paady ajcxy jadu'n xytunɨpy jɨbɨc, je' co ajcxy ca' ixy'adyii yɨ Dios Teedy, etz nañ jadu'n ca' xy'ixy'adyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Paady ɨɨch miich ajcxy jadachambɨ jadu'n nnɨmaaygɨxy, jɨgɨx co anajty je xɨɨ tiempo paady, chi m'ajɨhuɨ̈huɨɨyb ajcxy co tɨ anajty jayɨjp nnɨmaaygɨxy co ayo'n tzaachypɨ mmɨnaxa'ñ myajnaxa'ñ ajcxy. Ca' anajty ajcxy jada tɨ nyajnɨmäy mɨɨd jëgɨx nmɨɨd'ity ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","E cham janchtɨy nnɨcxáanɨbɨch ma yɨ huɨdibɨ tɨ xyquexyɨch ya naaxhuiñ. E ni tüg miich ajcxy xyca'amɨdooyɨch: “¿Ma mnɨcxa'ñ?” ");
INSERT INTO mcoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Paady miich ajcxy mdajy mmay ma m'aa mjot, co ajcxy cham jadu'n jada ayuc tɨ nyajhuinjɨhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Oy ixyipy miich ajcxy cham mjatajy mjamay, tɨy'ajt nej nmɨna'ñɨch co jac'oy mɨɨd miich ajcxy ycɨxpɨ co nhuimbidɨpyɨch ma Dios Teedy. Co ixyipy ca' jiiby nnɨcxa'ñɨch tzajpjoty, ca' ixyipy xyñiminaangɨxy Dios yjɨhuɨ'ñ ymɨc'ajt, je Espíritu Santo, je huɨdibɨ ajcxy xycapxhuijɨp. Per co ɨɨch anajty tzajpjoty tɨ nhuimbity, huin'it ɨɨch yɨ' miich ajcxy nyajniguexɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E co anajty je Espíritu Santo miiñ ya naaxhuiñ, huin'it yɨ' yajjɨhuɨ'ñybɨgɨpy jäy ajcxy ypocy. E nañ yajni'ixɨ̈huɨpy je jäy ajcxy co Dios tɨydunɨɨb mɨɨd ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yɨ Espíritu Santo yajjɨhuɨ'ñybɨgɨpy jäy ajcxy ypocy, co ɨɨch ca' ajcxy tɨ xymɨbɨcy ca' ajcxy tɨ xymɨjpɨdägyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Je Espíritu Santo yajnejhuɨ̈huɨpy jäy ajcxy nej huaad cuychɨnaaygɨxy Dios y'ayuc ytɨy'ajt. Com co ɨɨch nba'ttɨgɨ̈hua'ñɨch ma Dios Teedy, e miich ajcxy ca' xy'ocjac'íjxnɨbɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Je Espíritu Santo yajhuinjɨhuɨ̈huɨp je jäy ajcxy co Dios tɨydunɨɨb ajcxy mɨɨd ypocy ycɨxpɨ huɨdibɨ ajcxy ca' tɨydudägy chɨnaaygɨxy. Com yɨ Dios tɨ yɨ' mujcu' tɨyduñ mɨɨd ypocy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ooy may ayuc ɨɨch nmɨɨdɨty huɨdibɨ njayajnɨmähuaamyɨch ajcxy per ca' miich ajcxy mhuinjɨhuɨ̈huɨpy cham. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jacjiinɨ mhuinjɨhuɨ̈huɨpy ajcxy je ayuc huɨdibɨ njayajnɨmähuamy ajcxy, co Dios quexɨpy je Espíritu Santo ya naaxhuiñ huɨdibɨ tɨy'ajt mɨɨd. Yɨ' je' miich ajcxy xyajhuinjɨhuɨydähuɨpy tüg'ócɨy Dios ytɨy'ajt. Com yɨ' ca' ycɨ'mhuinma'ñ tunɨpy. Yɨ' janchtɨy ñigapxtähuɨpy tüg'ócɨy ayuc tɨy'ajt huɨdijaty anajty ymɨdooyb ma Dios Teedy, e nañ yajniguëxɨ̈ctähuɨpy tüg'ócɨy tɨy'ajt huɨdibɨ mimb cɨdaacp. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Je Espíritu Santo ɨɨch yɨ' capxpaady xyaj'idɨpyɨch, com yɨ' ɨɨch ndɨy'ajt miich ajcxy xyajhuinjɨhuɨ̈huaam. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tüg'ócɨy huɨdibɨ Dios Teedy ymɨɨd, nañ një'ajtypɨch yɨ', paady jadu'n tɨ nmɨna'ñɨch co je Espíritu Santo xyajhuinjɨhuɨydáaygɨxɨpy ajcxy ɨɨch yɨ n'ayuc yɨ ndɨy'ajtɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tɨm huaad'ajtp xɨɨ tiempo, co ɨɨch miich ajcxy ca' xy'ocjac'ijxɨp. Chi co xɨɨ tiempo yjacnajtznïnɨcxɨ̈huɨp, huin'it ɨɨch miich ajcxy xyjac'ixɨpy jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","E huin'it ajcxy nijëjɨty Jesús ydiscípulos ajcxy ñayñɨmaayɨ miñ xyɨpy ac jëyɨ: ―¿Ti jadu'n ytijyp? Co jadu'n ymɨna'ñ, co tɨm huaad'ajtnɨp xɨɨ tiempo mɨna ɨɨch miich ajcxy ca' xy'ocjac'íjxnɨbyɨch, e co yjacnajtznïnɨcxɨ̈huɨp xɨɨ tiempo, huin'it miich ajcxy xyjac'ixɨpyɨch jadüg'oc, com nnɨcxaamɨch ma Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Chi ajcxy jadu'n ñayñɨmaayɨ miñ xyɨpy: ―¿Ti jadu'n ytijamy? Co jadu'n ymɨna'ñ co tɨm huaad'ajtnɨp xɨɨ tiempo. Ca' ɨɨch ajt nhuinjɨhuɨɨyɨm ti jadu'n ytijamy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Com Jesús ñejhuɨɨyb anajty nej ajcxy yja'amɨdoohua'ñyii, chi nɨmay ajcxy: ―Yɨ' miich ajcxy ooy mjayajtɨɨhua'ñ. ¿Nej co jadu'n tɨ nmɨna'ñɨch? Tɨm huaad'ajtnɨp xɨɨ tiempo co ɨɨch miich ajcxy ca' xy'ocjac'ijxnɨpy. E chi yjacnajtznïnɨcxɨ̈huɨp xɨɨ tiempo, e chi miich ajcxy xyjac'ixɨpyɨch jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Janch janch ɨɨch miich yam nnɨmaaygɨxy co mjotmaybaadɨp ajcxy, e nañ myäxɨp ajcxy mɨɨd jotmay. Chi je naaxhuiñyjäy ajcxy huɨdibɨ ca' xymɨjpɨdägyɨch, xondägam ajcxy, e miich ajcxy nañ mjotmaybaadɨp. Per yɨ mjotmay ajcxy ahuimbidɨpy tüg xondaacɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jadu'n ajcxy mjada'ñ jadu'n nej tüg töxyjäy tzaachypɨ jɨhuɨ̈y co y'ung yma'xung'ada'ñ. E co tɨ yma'xung'aty ypi'c'ung, chi jäydɨgoy yɨ tzaachypɨ mɨɨd xondaacɨn co tüg jäy tɨ ymiiñ ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tɨm jadu'n nej yjaty mɨɨd je töxyjäy, nañ jadu'n yjada'ñ mɨɨd miich ajcxy. Cham ajcxy jotmay mjɨhuɨ̈y ma m'aa mjot, e chi co xy'ixɨpyɨch jadüg'oc miich ajcxy, huin'it ajcxy m'aa mjot yxondäga'ñ. E ni pɨn huaad mxondaacɨn ajcxy xycapɨjcɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Je huin'it xɨɨmbɨ (co anajty je Espíritu Santo tɨ ymiiñ ya naaxhuiñ) ca' ɨɨch miich ajcxy ni ti xyjacyajmɨbɨjctzohuɨpyɨch, com janch ɨɨch miich ajcxy yam jadu'n nɨmaaygɨxy co tüg'ócɨy huɨdijaty myajmayjajtcɨxyp, chi ajcxy mbɨjctzohuɨpy ma Dios Teedy mɨɨd ɨɨch nxɨɨ, e xymöhuɨpy ajcxy yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Chambaadnɨ ca'nɨ ni ti ajcxy mbɨjctzoy ma Dios mɨɨd ɨɨch nxɨɨ. Pɨjctzoogɨx, e xymöhuɨpy ajcxy yɨ', jɨgɨx mjotcugɨ̈huɨp ajcxy anaxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tüg'ócɨy jada ayuc tɨy'ajt ac jɨɨhuimbit miich ajcxy tɨ nyajnɨmäy. Huingomb xɨɨ tiempo mɨna tɨydudägy ajcxy nyajmɨɨdmɨydactähuɨpy yɨ Dios Teedy y'ayuc ytɨy'ajt yajxon, e ca' y'ocjɨɨhuimbitiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Je huin'it xɨɨ co anajty ɨɨch tɨ nhuimbityɨch ma Dios Teedy, jëbɨ miich ajcxy mbɨjctzoogɨxy ma Dios Teedy tijaty ajcxy myajmayjajtyp. Co tɨ mbɨjctzóogɨxɨpy mɨɨd ɨɨch nxɨɨ, xymóoygɨxɨpy yɨ' Dios Teedy. Ca' ycopɨcyɨty co ɨɨch yɨ' nmɨbɨjctzohuɨpy mɨɨd miich ajcxy ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Com yɨ Dios Teedy nañ xychojcp xyjɨhuɨɨyb yɨ' miich ajcxy. Com miich ajcxy jayɨjp tɨ xychocyɨch tɨ xyjɨhuɨ̈yɨch, e tɨ mmɨbɨcy ajcxy co tɨ ndzooñɨch ma Dios Teedy, paady Dios miich ajcxy xymöhuɨpy tijaty anajty myajmɨbɨjctzooyb. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jiiby ɨɨch ndzooñ ma Dios Teedy yajpaady, co nmiiñɨch ya naaxhuiñ, per jadachambɨ n'ixmájtznɨbyɨch jada naaxhuiñybɨ, e nhuimbijtnɨch ma Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Huin'it je' ydiscípulos ajcxy ymɨnañ: ―Cham janchtɨy tudägy mɨydägy, ca' m'ocyajtuunɨ jɨɨhuimbit ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cham ɨɨch ajcxy nnejhuɨ̈y co miich mnejhuɨyday tüg'ócɨy tɨy'ajt. E tɨ xyajnɨmaydäyɨch co anajty ca' ti tɨy'ajt ɨɨch ajcxy nmɨbɨcy co miich mdzooñ ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chi Jesús y'adzooy: ―¿Nej mmɨbɨjcyp cham jada ayuc jadu'n nej tɨ nnɨmáaygɨxyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jɨhuɨ'ñybɨjccɨx co huingonɨp je xɨɨ tiempo, e tɨ tɨm paady mɨna miich ajcxy mgueec-huäcxtáaygɨxɨpy nidüg nidüg ma pɨn tɨmdzocy, e xyajhuɨ́'mgɨxɨch naydüg. Per ca'p ɨɨch nnaydügɨty, com yɨ Dios Teedy yɨ' ijtp mɨɨd ɨɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Miich ajcxy yam jada ayuc nyajnɨmaayb, jɨgɨx ajcxy jotcujc'ajtɨn mbaadɨp ma ɨɨch. Ya naaxhuiñ mbadamy ajcxy ayo'n etz tzaachypɨ. Jotcugɨɨygɨx, ca' mdajcɨxy maygɨxy, com tɨ nmɨmadägyɨch yɨ jɨbɨcpɨ ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Co Jesús jadu'n ymɨnañ jayɨjp, chi ypa't'ijxy tzajpcɨ́xy, chi Dios Teedy pa'tcapxy nɨmay: ―Dios Teedy, tɨ hora paady mɨna ayo'n nyajnaxa'ñɨch jadu'n nej miich jayɨjp'aty myajnihuinmayɨɨy. Yajniguëxɨ̈g ɨɨch nmɨc'ajt ɨɨch n'oy'ajt, com ɨɨch miich nDeedy'ajtypɨch, jɨgɨx ɨɨch nañ jadu'n nyajniguëxɨ̈gɨbyɨch miich mmɨc'ajt miich m'oy'ajt ma yɨ jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Com miich tɨ xymöyɨch mɨc'ajt ma tüg'ócɨy jäy, jëbɨ nmöyɨch ajcxy jugy'ajtɨn huɨdibɨ ca' ycɨxɨpy ytɨgoyɨpy. Nmöhuɨbyɨch jada jugy'ajtɨn tüg'ócɨy jäy ajcxy huɨdibɨ miich tɨ xymöyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Je jäy ajcxy huɨdibɨ ixy'ajtp je Dios janchypɨ, je Dios tügpajcpɨ etz y'ixy'ajtyp nañ jadu'n Jesucristo huɨdibɨ tɨ mguexy ya naaxhuiñ, ymɨɨd ajcxy jugy'ajtɨn huɨdibɨ ca'ycɨxɨpy ytɨgoyɨpy nimɨnaa. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tɨ ɨɨch nyajniguëxɨ̈gyɨch miich ajcxy yɨ nmɨc'ajt ya naaxhuiñ, co ɨɨch tɨ nduñ yɨ mdung huɨdibɨ miich xyajnïbɨjcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jadachambɨ Dios Teedy yajmɨjtɨgɨɨygɨch miich, mɨɨd je mɨc'ajtɨn huɨdibɨ anajty nmɨɨdɨch ma miich mhuinduu co anajty ca'nɨ naaxhuiñybɨ chondacyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Tɨ ɨɨch miich ya naaxhuiñ nyajniguëxɨ̈cɨ yɨ nmɨc'ajt ma yɨ jäy ajcxy huɨdibɨ miich xymooyɨch, huɨdibɨ miich mhuin'ijx ma naaxhuiñyjäy ajcxy. Miich yɨ' ajcxy mjäy, e miich tɨ xymöyɨch, e tɨ ajcxy miich m'ayuc cuydungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jadachambɨ ñejhuɨɨyñɨp yɨ' ajcxy, co tüg'ócɨy tijaty tɨy'ajt ɨɨch miich yɨ' xymooyb, jiiby yɨ' chooñ tzajpjoty ma miich. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Com yɨ ayuc huɨdibɨ miich tɨ xymöyɨch, tɨ ɨɨch yɨ' ajcxy nyajnɨmaydäy, e tɨ yɨ' ajcxy cöbɨjccɨxy. E nañ tɨ ajcxy huinjɨhuɨɨygɨxy tɨydudägy co ɨɨch jiiby ndzooñɨch ma miich, e nañ tɨ ajcxy mɨbɨjccɨxy co miich ya naaxhuiñ xyquejxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mɨɨd yɨ' ycɨxpɨ ajcxy miich Dios Teedy nmɨbɨjctzooy, ca' nmɨnaanɨm mɨɨd jacjadyii naaxhuiñyjäy ajcxy ycɨxpɨ nmɨbɨjctzoy. Mɨɨd yɨ̈da'ajty ycɨxpɨ ajcxy huɨdibɨ miich tɨ xymöyɨch, com nañ mjë'ajtyp miich yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tüg'ócɨy tijaty ɨɨch një'ajtyp, nañ mjë'ajtyp miich yɨ', e tijaty miich mjë'ajtyp nañ një'ajtyp ɨɨch yɨ'; e ɨɨch nmɨc'ajt niguëxɨ'cp yɨ' ma yɨ' ajcxy chɨnaayɨn yjugy'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","E ca' n'ocjacyajpadaanɨch ya naaxhuiñ. Ɨɨch njäy ajcxy jacyajpadam ya naaxhuiñ. Nnɨ́cxnɨbɨch jiiby tzajpjoty ma miich. Dios Teedy, cuend'at ɨɨch ndiscípulos ajcxy mɨɨd miich mmɨc'ajt huɨdibɨ miich tɨ xymöyɨch, jɨgɨx yɨ' ajcxy tú'cɨy yjot yhuinma'ñ yajpaadɨpy ma miich, tɨm jadu'n nej ɨɨch ajt tú'cɨy njot nhuinma'ñ nyajpaatɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Co anajty ɨɨch njac'yaajɨty naaxhuiñ mɨɨd ɨɨch njäy ajcxy, tɨ ngüend'atyɨch anajty ajcxy mɨɨd je mɨc'ajt huɨdibɨ miich xymooyɨch. E ni tüg ajcxy ca' yhuinma'ñydɨgooy. Abɨcy ɨɨch n'octɨmpɨdägy je huɨdibɨ nayyajhuinma'ñydɨgooyɨ (je Judas Iscariote), co yɨ' anajty jadu'n yajcuydunam jadu'n nej jaybety ymiiñ mɨɨd yɨ' ycɨxpɨ etz mɨɨd ɨɨch ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Cham ɨɨch miich niba'ttɨgɨ̈huaanɨ jada'. Miich m'ayuc mdɨy'ajt nyajnɨmaaybɨch jada naaxhuiñyjäy ajcxy huɨdibɨ nyaj'ixpɨjcypɨch, jɨgɨx agujc jotcujc yhuɨ'mɨp ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tɨ ɨɨch ajcxy yɨ' nyajnɨmaydäyɨch miich m'ayuc mdɨy'ajt. E ca' ajcxy y'ixa'ñyii yɨ naaxhuiñyjäy ajcxy huɨdibɨ ca' xymɨjpɨdägyɨch. Com je' co ajcxy yjot yhuinma'ñ tɨ yajtɨgach, ca' ytügɨ̈y mɨɨd yɨ jacjadyii naaxhuiñyjäy yjot yhuinma'ñ. Jadu'n nej ɨɨch ca' ytügɨ̈y njot nhuinma'ñ mɨɨd naaxhuiñyjäy ajcxy yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ca' ɨɨch cham miich nmɨbɨjctzoy co myajpɨdzɨmɨpy ɨɨch ndiscípulos ajcxy ma jada naaxhuiñybɨ. Hue' janchtɨy tun may'ajt cuend'at ajcxy ma yɨ ca'oybɨ ymiiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yɨ' ajcxy yjot yhuinma'ñ ca' ytügɨ̈y mɨɨd yɨ jacjadyii naaxhuiñyjäy ajcxy yjot yhuinma'ñ. Tɨm jadu'n nej ɨɨch ca' ytügɨ̈y njot nhuinma'ñ mɨɨd yɨ jacjadyii naaxhuiñyjäy ajcxy yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yajhuaatzɨ ajcxy yjot yhuinma'ñ mɨɨd miich m'ayuc, com yɨ m'ayuc yɨ' je' tɨy'ajt mɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jadu'n nej miich xyquejxyɨch ya naaxhuiñ, nañ jadu'n ɨɨch yɨ' ajcxy nguejxhuäcxyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mɨɨd yɨ' ajcxy ycɨxpɨ tɨ nnaygɨ̈yegyiijɨch amuumdügjot ma miich, jɨgɨx yɨ' ajcxy nañ jadu'n ñaygɨ̈yegɨɨyb amuumdügjot ma miich, co ajcxy cuydunɨpy miich m'ayuc mdɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","E ca' ɨɨch jada'ajty ajcxy nibɨjctzohuɨ̈yɨch. Hue' ɨɨch janchtɨy nibɨjctzohuɨydaaybɨch tüg'ócɨy jäy ajcxy huɨdibɨ xymɨbɨ́jcɨbɨch xymɨjpɨdägɨbɨch mɨɨd yɨ ayuc huɨdibɨ ɨɨch ndiscípulos ajcxy ycapxhuäcxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Huen ajcxy nidüg'ócɨy yjot yhuinma'ñ yajtügɨ̈y, jadu'n nej miich Dios Teedy mjot mhuinma'ñ yajpaady ma ɨɨch, e ɨɨch njot nhuinma'ñ yajpaady ma miich. Co yɨ' ajcxy yjot yhuinma'ñ yajtügɨ̈huɨpy mɨɨd ɨɨch ajt njot nhuinma'ñ, huin'it jacjadyii naaxhuiñyjäy ajcxy mɨbɨgɨpy co miich xyquejxyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tɨ ɨɨch ajcxy nmöyɨch je tɨy'ajt etz je oy'ajt huɨdibɨ ɨɨch miich tɨ xymöy, jɨgɨx ajcxy yjot yhuinma'ñ jatyɨmy yajtügɨ̈huɨpy ajcxy, jadu'n nej ɨɨch ajt njot nhuinma'ñ yajpaatɨm tú'cɨy. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɨɨch yajpatpɨch ma ɨɨch njäy, e miich nañ myajpatp ma ɨɨch, jɨgɨx tɨydudägy ajcxy tügmucy y'idɨpy, e nañ jɨgɨx naaxhuiñyjäy ajcxy jatyɨmy nejhuɨ̈huɨpy co miich xyquejxyɨch ya naaxhuiñ, e nañ co yɨ' ajcxy tɨ mdzocy tɨ mjɨhuɨ̈y jadu'n nej ɨɨch miich xychocy xyjɨhuɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dios Teedy ndzojcpyɨch co yɨ jäy ajcxy huɨdibɨ miich tɨ xymöyɨch y'idɨpy ajcxy nañ jadu'n ma anajty n'ityɨch jiiby tzajpjoty, jaydëbɨ ajcxy ixɨpy ɨɨch nmɨc'ajt ɨɨch n'oy'ajt huɨdibɨ miich tɨ xymöyɨch. Com miich tɨ xychocy tɨ xyjɨhuɨ̈yɨch jacjayɨjp ca'nɨ anajty naaxhuiñybɨ myajcojyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dios Teedy, miich ooy mmɨjɨty mjanchɨty, e yɨ jacjadyii naaxhuiñyjäy ca' ajcxy yɨ' xy'ixy'ajtyp. Ɨɨch miich n'ixy'ajtyp. Ɨɨch njäy ajcxy tɨ mɨbɨcy tɨ mɨjpɨdägy co miich xyquejxyɨch ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tɨ nyajnɨmaayɨch yɨ' ajcxy pɨn miich, co miich je' Diosɨp. E njacyajnɨmähuaamyɨch yɨ' ajcxy tɨydudägy, jɨgɨx yɨ' ajcxy nañ jadu'n ñaychogɨɨyb ñayjɨhuɨ̈huɨɨyb nidüg nidüg, jadu'n nej miich xychocyɨch xyjɨhuɨ̈yɨch, e nañ jadu'n jɨgɨx ɨɨch ndɨy'ajt yajpaadɨpy ma yɨ' ajcxy yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Co jadu'n Jesús ycapxymɨydacy jayɨjp, chi jada' ñɨcxy mɨɨd je jäy ajcxy huɨdibɨ anajty ajcxy yaj'ixpɨjcyp. Ñɨcxy ajcxy jɨm'amy huoc nïnaxy, je huoc hue' anajty xɨɨjɨty Cedrón. Ñɨcxy ajcxy jɨm ma anajty tüg aguemy. Chi Jesús ytɨgɨɨy ma je aguemy mɨɨd ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas huɨdibɨ anajty cɨ̈yegam Jesús, ñejhuɨɨyb anajty ma je it ma anajty mɨɨd'oy canaag'oc je' ydiscípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chi jada' Judas mɨɨddzooñ soldados ajcxy etz jacjadyii tungmɨɨdpɨ huɨdibɨ je teedy yhuindzɨn ajcxy etz fariseojäy ajcxy yquejx. Chi ajcxy yja'ty ma je it ma anajty Jesús yajpaady, ymɨɨd ajcxy linterna, ymɨɨd ajcxy chinjɨɨn etz canaagnax tijaty huɨdibɨ anajty ajcxy mɨɨd chiptuñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","E Jesús com ñejhuɨydaayb anajty tüg'ócɨy nej anajty yjada'ñ y'ayohua'ñ, chi jɨjpcohuägɨy je ymaymɨdzip ajcxy, e nɨmay: ―¿Pɨn ajcxy m'ijxtaayb? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chi je' ymɨdzip ajcxy y'adzooy: ―Yɨ' ɨɨch ajcxy n'ixtaayb je Jesús, je Nazaret jäy. Chi Jesús ymɨnañ: ―Ɨɨch jëdu'n. Je Judas huɨdibɨ anajty cɨ̈yejcp Jesús, jɨm anajty ytɨnäy mɨɨd Jesús ymɨdzip. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Co Jesús jadu'n ymɨnañ: “Ɨɨch jëdu'n.” Chi ajcxy yëphuimbijtay jadu'ñyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chi Jesús jadüg'oc y'amɨdooy ajcxy: ―¿Pɨn ajcxy m'ijxtaayb? Chi ajcxy jadüg'oc y'adzooy: ―Yɨ Jesús, je Nazaret jäy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chi Jesús ymɨnañ: ―Tɨ ajcxy njanɨmäy co ɨɨch jëdu'n. Pen janch ɨɨch miich ajcxy xy'ijxtaayb, najtzmadzɨydäy jadayaab ɨɨch nmɨgügtɨjc ajcxy, huen nɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E jadu'n yajcuyduñ je ayuc co anajty Jesús cɨ'm tɨ ymɨna'ñ: “Tüg'ócɨy jäy huɨdibɨ nDeedy tɨ xymöyɨch, ca' ni tüg jëbɨ huaad ytɨgooy.” ");
INSERT INTO mcoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chi jada' je Simón Pedro huɨdibɨ anajty mɨɨd tüg espada, juudy je y'espada ma ñidɨjc, e chi yajtzaachɨɨyɨ je Teedy mɨjtungmɨɨdpɨ ytumbɨ, tüg yta'tz'ac aa'oy'amybɨ yajmɨnájcɨy. Je tumbɨ hue' anajty xɨɨjɨty Malco. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chi Jesús nɨmay Pedro: ―Pɨdäg m'espada ma ñidɨjc. Ca' mnejhuɨ̈y co copɨcy nyajnaxɨpyɨch je tzaachypɨ je ayo'n huɨdibɨ Dios Teedy tɨ xyajnigo'adugɨ̈yɨch. Min n'ocmɨnaxy n'ocyajnaxyɨch jada tzaachypɨ jadu'n nej ixyipy tüg tasɨ ta'm'ujtznɨɨ ngo'uucnaxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chi je soldados ajcxy, je soldado yhuindzɨn etz judíojäy ajcxy ytungmɨɨdpɨ huingohuägɨɨy ajcxy Jesús. Chi ajcxy majch, e chi ajcxy cɨ̈xojch. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chi ajcxy jayɨjp yajnɨcxy Jesús ma Anás yajpaady, je' anajty Caifás ymɨ̈d'ajtyp, je huɨdibɨ anajty mɨjtungmɨɨd ma teedytɨjc ajcxy ymiñ je huin'it jɨmɨjt. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Je Caifás je' anajty tɨ yecy je capxhuijɨn ma yɨ judíojäy ajcxy co tügtecy ymɨnañ: jac'oy co tüg jäy y'ögɨpy mɨɨd tüg'ócɨy naax cajp ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro mɨɨd jadügpɨ ydiscípulo ypanɨcx ajcxy Jesús (co je ymɨdzip yajnɨcxɨ mach). E je jadügpɨ ydiscípulo ixy'ajtɨp anajty yajxon je teedy mɨjtungmɨɨdpɨ, paady ytɨgɨɨy axam huin'it co Jesús ymɨdzip yajtɨgɨɨyɨ ma je teedy mɨjtungmɨɨdpɨ ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","E je Pedro jiiby je' yhuɨ'mɨy ma tɨjc aguu. E je jadügpɨ ydiscípulo co anajty ajcxy ñay'ixy'adyii mɨɨd je teedy mɨjtungmɨɨdpɨ, chi ypɨdzɨmy mɨgapxy je tɨjc aguu adɨnaayb, chi Pedro ajcxy yajtɨgɨ̈y jiiby tɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chi jada' je töxy'anäg huɨdibɨ anajty tɨjc'aguu adɨnaayb, nɨmay je Pedro: ―¿Nej ca' miich nañ jadu'n Jesús xydiscípulo'adyii? Chi Pedro y'adzooy: ―Ca'. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Je tumbɨdɨjc ajcxy etz je soldadtɨjc ajcxy tɨ anajty ajcxy oy jɨɨn yajmɨjɨɨygɨxy co anajty chachtɨɨchɨty, e Pedro nañ jɨm anajty nañ jadu'n mɨɨd xamy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chi je teedy mɨjtungmɨɨdpɨ y'amɨdooy Jesús pɨnjaty anajty tɨ yaj'ixpɨcy etz tijaty anajty tɨ yaj'ixpɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chi Jesús y'adzooy: ―Tɨ ɨɨch oy njacapxy njamɨydägy mayjäyjoty. E tɨ ɨɨch njatyɨmy nyaj'ixpɨcyɨch ma miich ajcxy mnaymujctacɨn etz ma Dios ytɨjc, ma yɨ judiojäy ajcxy nidüg'ócɨy ñaymugyii. Ca' ni ti ameech tɨ nnigapxyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Na'amy co xyjactɨm'amɨdooyɨch ti anajty tɨ nyaj'ixpɨcyɨch? Yɨ' ajcxy amɨdou pɨnjaty tɨ xy'amɨdo'ijtɨch n'ayucɨch, yɨ' ajcxy nejhuɨɨyb ti ɨɨch jadu'n tɨ nyaj'ixpɨcyɨch. Yɨ' ajcxy tüg'ócɨy ñejhuɨydaayb nejjaty ɨɨch tɨ nmɨna'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Co jadu'n y'adzooy Jesús, huin'it tüg judío tungmɨɨdpɨ huɨdibɨ anajty jɨm huingon tɨnaayb ma Jesús, chi tüg cɨ' acojxɨ̈gy Jesús, chi mɨnañ: ―¿Nej co jadu'n jɨbɨc m'adzooy yɨ teedy mɨjtungmɨɨdpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chi Jesús y'adzooy: ―Pen jɨbɨc ɨɨch tɨ n'adzooy yec tɨy'ajt nej co yjɨbɨcɨty. Pen oy ɨɨch tɨ n'adzooy, ¿nej co xycoxyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chi Anás nɨmay soldadtɨjc co huen Jesús yajnɨcxy cɨ̈xoch jɨm ma yɨ Caifás ytɨjc, je teedy mɨjtungmɨɨdpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedro jɨmnɨ anajty ytɨnäy ma jɨɨmba' yxamy anajty, chi ajcxy amɨdoy jadüg'oc: ―¿Nej cay yɨ' miich xyaj'ixpɨjcp nañ jadu'n? Chi Pedro jadüg'oc coyüch Jesús ymɨnañ: ―Ca' je' n'ɨɨchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nidügtɨ ajcxy je teedy mɨjtungmɨɨdpɨ ytumbɨ, je' anajty y'amɨgüg yɨ Malco, huɨdibɨ Pedro yta'tz'ac quejtzpujxɨ, chi jadu'n ymɨnañ: ―¿Nej ca' mdijy n'ijxyɨ jɨm ma je aguemy mɨɨd Jesús? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chi Pedro mɨdugɨɨg'oc oy coyüch yhuindzɨn, e tɨm huin'itɨy tzey oy yaaxɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chi ajcxy jɨm yajtzooñ Jesús ma Caifás ytɨjc yajnɨcxy ajcxy ma agujctɨjc, tɨm jopyñɨ anajty. Chi je judiojäy ca' ajcxy ytɨgɨɨy ma agujctɨjc, com ca' anajty ytundɨgoyaangɨxy mɨɨd judiojäy ycostumbre. Ca' ajcxy ytɨgɨ̈hua'ñ anajty ma je romanojäy gobernador ytɨjc amayxɨɨjoty, e ca' anajty ajcxy ñayyajjɨbɨccɨ̈hua'ñyii. Com co jadu'n ycanayyajjɨbɨccɨyɨ ajcxy, e huin'it ca' ajcxy ycacaay ma je pascua xɨɨ adzuu'ajtɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Co ca' ajcxy ytɨgɨ̈hua'ñ anajty ma je agujctɨjc, chi je gobernador Pilato nibɨdzɨmy ajcxy tɨba'y ma anajty ajcxy mɨɨdɨty Jesús cuend'aty. Chi Pilato ymɨnañ: ―¿Ti xɨ̈huɨn ajcxy mmɨɨd, mɨɨd jadayaabɨ yëydɨjc? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chi ajcxy y'adzooy: ―Co ixyipy ca' ti jɨbɨcpɨ tuñ, ca' ixyipy ɨɨch ajcxy ya yɨ' nyajmiñ ma miich. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Chi Pilato ymɨnañ: ―Yajnɨcxcɨx miich ajcxy. Nɨcx tɨydungɨx jadu'n nej miich ajcxy mley y'ané'my. Chi je judíojäy ajcxy y'adzooy: ―Ɨɨch ajcxy ca' ni ti mɨc'ajt nmɨɨdɨty nɨcxy ɨɨch ajcxy njäyyaj'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Co jadu'n ajcxy ymɨnañ, chi jadu'n ajcxy cuyduñ je Jesús ycɨ'm'ayuc jadu'n nej anajty tɨ ymɨna'ñ ti o'cɨn anajty ypadamy. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chi Pilato jadüg'oc ytɨgɨɨy jiiby agujctɨgoty, chi coyaaxɨɨy Jesús, chi nɨmay: ―¿Nej miich je' rey'ajtp ma yɨ judíojäy ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chi Jesús y'adzooy: ―¿Nej mgɨ'mhuinma'ñ mɨɨd xy'amɨdooyɨch pen ɨɨch nrey'ajtpɨch, o huingjäy tɨ xyajnɨmäy co nrey'atyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chi jada' Pilato y'adzooy: ―¿Nej nañ judiojäy jada' ɨɨchɨ? Mgɨ'mnaax mgɨ'mgajp etz je teedy mɨjtungmɨɨdpɨ tɨ xycɨ̈yecy ma ɨɨch. ¿Ti tɨ mdundɨgooy? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chi Jesús y'adzooy: ―Ɨɨch ca' n'ane'myɨch ya naaxhuiñ. Huingduum ɨɨch n'ané'mɨn nmɨɨdɨdyɨch. Co ixyipy ya naaxhuiñ n'oc'ane'myɨch, tüg'ócɨy ɨɨch nmɨgügtɨjc ajcxy tɨ ixyipy ajcxy tziptungɨxy, tɨ ixyipy ajcxy xyñihua'ñɨch. E ca' ixyipy tɨ naygɨ̈yegyiijɨch ma yɨ judíojäy tungmɨɨdpɨ ajcxy. Per janch ɨɨch ca' ɨɨch ya naaxhuiñ n'ane'myɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chi Pilato y'adzooy: ―¿Nej mrey miichɨ? Chi Jesús ymɨnañ: ―Miich jadu'n xytijypɨch co nrey'atyɨch. Paady tɨ nmiñɨch ya naaxhuiñ, e tɨ nma'xung'atyɨch, jɨgɨx nyecyɨch tɨy'ajt tɨydudägy. Tüg'ócɨy yɨ jäy pɨnjaty tɨy'ajt cuydumb xy'amɨdo'íjtɨbɨch yɨ' n'ayucɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chi Pilato y'adzooy: ―¿Ti jadu'n mdijy tɨy'ajt tɨydudägypɨ? Jadu'ñyɨ je' jada'ajty yjacmɨnañ, chi pɨdzɨmy jadüg'oc tɨba'y ma anajty je judíojäy ajcxy. Chi ajcxy nɨmay: ―Ca' ɨɨch ni ti bocy nbaadyɨch ma jada jäy ma yɨ romanojäy yley. ");
INSERT INTO mcoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","E com miich ajcxy mɨɨd tüg costumbre co tüg nnajtzmadzɨɨyɨm machyjäy mɨɨd jada pascua xɨɨ ycɨxpɨ, ¿nej mdzojcyp ajcxy co nnajtzmadzɨ̈huɨbyɨch jada judíojäy reyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chi ajcxy nidüg'ócɨy mɨnanday: ―Jadayaabɨ jäy ca' mnajtzmadzɨ̈huɨpy, yɨ' janchtɨy mnajtzmadzɨ' yɨ Barrabás. Barrabás hue' je' anajty tüg meetzpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chi jada' Pilato ané'mɨn pɨdacy co huen ajcxy Jesús huinhuopy jɨjphuopy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Chi jada' je soldados ajcxy yaj'oyɨɨy tüg corona mɨj'apy pa'apy, chi ajcxy yajcojenɨy Jesús. Chi ajcxy yajnïjenɨɨy tüg rey yhuit ucypɨ ycolor. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chi soldados ajcxy huingohuägɨɨy jadüg'oc capxpoocxcɨxy yajxïgy'amy, nɨmaaygɨxy: ―¡Viva miich judíojäy rey! Chi ajcxy ooy huingojxy jɨjpcojxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chi Pilato jadüg'oc ypɨdzɨmy tɨba'y. Chi nɨmay je mayjäy: ―Cham ajcxy nyajpɨdzɨmy tɨba'y jada Jesús, jɨgɨx ajcxy mnejhuɨ̈huɨp co ca' ni ti pocy tɨ nbaadyɨch ma yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Co Jesús ypɨdzɨmy tɨba'y mɨɨd je apy corona ma ycohuajc etz je rey yhuit ucypɨ ycolor. Huin'it Pilato ymɨnañ: ―Ijxcɨx, cha je yëydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Co je teedy tungmɨɨdpɨ etz je judiojäy ajcxy ijxy, chi ajcxy ymɨnanday nidüg'ócɨy aguipxyjatyɨ: ―Yajcruudzpet, yajcruudzpet. Chi Pilato ymɨnañ: ―Yajcruudzpejtcɨx miich ajcxy, janch ɨɨch ca' ni ti tɨy'ajt nbaadyɨch nej ɨɨch yɨ' nyajcruudzpedɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chi je judiojäy ajcxy y'adzooy: ―Ɨɨch ajcxy mɨɨd tüg cötujcɨn, jëbɨ y'ögy mɨɨd ɨɨch ajcxy ngötujcɨn ycɨxpɨ, com tɨ ycapxtɨgooy co ymɨna'ñ co yɨ Dios yteedy'ajtyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Co jada ayuc mɨdooy Pilato, chi nïgɨ chɨgɨygoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chi ytɨgɨɨy jadüg'oc ma je cötujctac mɨɨd Jesús, chi nɨmay: ―¿Ma miich tɨɨyɨ mgogajpɨty? E Jesús ca' y'adzooy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paady Pilato ymɨnañ: ―¿Ɨɨch miich ca' xy'adzohua'ñ? ¿Ca' mnejhuɨ̈y co nmɨɨdɨdyɨch mɨc'ajt jëbɨ nnajtzmadzɨ̈y etz nañ jëbɨ nyajcruudzpety? ");
INSERT INTO mcoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chi Jesús y'adzooy: ―Ni ti mɨc'ajt ixyipy mgamɨɨdɨty ma ɨɨch, pen ca' ixyipy mɨc'ajt tɨ xymöyɨch yɨ huɨdibɨ ane'mb jiiby tzajpjoty. E paady ycɨxpɨ yɨ tɨɨbɨ ɨɨch xycɨ̈yecyɨch nïgɨ yɨ' pocy mɨɨdɨty ca'ydɨ miich. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","E huin'it Pilato ooy yjahuinma'ñ ixtay nej huaad ca' jëbɨ ocnajtzmadzɨɨy Jesús. E je judíojäy, je Jesús ymɨdzip, nïgɨ anajty ajcxy chachxɨ̈'ɨdɨ̈ch: ―Pen miich mnajtzmadzɨɨyb jada Jesús, huin'it ca' m'ocjacnaymɨgüg'ájtɨnɨpy mɨɨd yɨ mhuindzɨn je César huɨdibɨ ané'mɨn tɨ xymöy. Com tüg'ócɨy pɨnjaty naydijɨp rey, ca' yɨ' mɨɨd nay'ixa'ñyii je César. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Co Pilato jadu'n ayuc mɨdooy, chi yajpɨdzɨmy Jesús tɨba'y. Chi Pilato y'ixtacy jɨm ma je' y'ane'mdac ycötujctac, jɨm ma je it huɨdibɨ anajty xɨɨjɨp Empedrado, hebreo'amy xɨɨjɨty Gabata. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hue' tɨm cujcxɨɨ anajty, e chi com jabom anajty je pascuaxɨɨ ycodɨɨcxnɨ, co Pilato jadu'n nɨmay judíojäy ajcxy: ―Cha ajcxy jada mrey. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","E je' ajcxy y'adzooy: ―Huen ögy, huen ögy. Yajcruudzpet. Chi Pilato ymɨnañ: ―Miich ajcxy mrey, ¿miñ n'ocyajcruudzpétyɨchɨ? Chi je teedy tungmɨɨdpɨ ajcxy y'adzooy: ―Ɨɨch ajcxy ca' ɨɨch ajcxy huingbɨ rey nmɨɨdɨty, jëyɨ César ɨɨch ajt nrey'ajtɨm. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chi Pilato cɨ̈yejcy Jesús ma je judíojäy ajcxy, huen ajcxy cɨ'm yajcruudzpety. Huin'it ajcxy Jesús nihuägɨɨy. Chi ajcxy yajtzooñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Chi ajcxy je cruudz Jesús cɨ'm yajquejcycabɨɨy. Mɨɨd nɨcx ajcxy ma je it xɨɨjɨty o'cpɨ cohuajc, hebreo'amy xɨɨjɨty Gólgota. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jɨm ajcxy yajcruudzpejty quipxyɨ mɨɨd jametz jäy, tüg anajty'amy, jadüg a'oy'amy etz Jesús cujc'amy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Chi Pilato ane'my huen cɨjxjay ayuc ma je cruudz, e jadu'n je ayuc ajcxy jay: “Jesús, Nazaret jäy, je judíojäy ajcxy yrey.” ");
INSERT INTO mcoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","May ajcxy ooy je judíojäy capxy je ayuc huɨdibɨ anajty cɨjxjay ma je cruudz. Com je it ma anajty ajcxy Jesús tɨ yajcruudzpejtcɨxy mɨhuingon anajty Jerusalén. Hue' anajty yjayɨty: hebreo'amy, latin'amy etz griego'amy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chi je teedy mɨjtungmɨɨdpɨ ajcxy nɨmay je Pilato: ―Ca' ixyipy jadu'n tɨ mjay: “Judíojäy yrey”. Hue' ixyipy tɨ mjay: “Yɨ' jadu'n naydijɨp ɨɨch judíojäy xyrey'ajtpɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chi Pilato y'adzooy: ―Yɨ tɨɨbɨ njaayɨch, tɨ ɨɨch yɨ' njaay, ca' nyajtɨgadza'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Co soldados ajcxy yajcruudzpejttay je Jesús, huin'it je' yhuit ajcxy huijtzɨ'cɨ. Chi ajcxy je huit yajhuäcxy mɨdaaxpɨcy. Chi soldados ajcxy cɨjptüg cɨɨchypɨjcy. Yɨ' yjocxhuit jadu'n nej anajty ytügjɨjpxuyɨ̈yɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chi ajcxy ñayñɨmayɨ ac jëyɨ soldadtɨjc: ―Ca' huaad ajt n'agɨɨdzɨɨyɨm jada jocxhuit. Tzoc ajt suerte n'oc'ijxɨm, jɨgɨx ajt nnejhuɨɨyɨm pɨn anajty suerte'ajtɨp. E jadu'n ajcxy cuyduñ nej anajty ycojaayɨty ma Dios ñecy, ma Cristo jadu'n ymɨnañ: “Yajhuäcx ajcxy ɨɨch nhuit, e ma ɨɨch njocxnïjen jɨm ajcxy suerte ijxy.” Je' je' huɨdibɨ soldadtɨjc ajcxy ycuyduun. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jɨm ma Jesús ycruudzmɨjc, jɨm anajty ajcxy ytɨnäy: Jesús ytaj, je ytaj chɨ', je María (Cleofas ytöxyɨjc), etz María Magdalena. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Co Jesús ijxpaty ytaj etz je ydiscípulo huɨdibɨ́ anajty ooy nïgɨ tzocy ma ytaj ymɨjc, chi nɨmay ytaj: ―Nan, ɨɨch nmɨgüg huɨdibɨ tɨnaayb ma miich mmɨjc, yɨ' xycuend'adɨp jadu'n nej jɨhuɨ̈y miich yɨ' xytaj'adyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chi Jesús nɨmay je' ydiscípulo: ―Ɨɨch ndaj miich mgüend'adɨpy, jadu'n nej ixyipy mgɨ'mdaj'adyii. Jadu'n nej xɨɨ tiempo jac nɨcxnɨ Jesús ytaj tzɨnaydacpɨcy ma jada discípulo ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Co jadu'n ytundaayɨ yjajtaayɨ, chi Jesús nejhuɨɨy co tɨ anajty tüg'ócɨy ytundäyii yjajtäyii jadu'n nej Dios tzocy. Huin'it jadu'n ymɨnañ: ―Tɨdzɨ́ɨyɨnɨbɨch. Co jadu'n ymɨnañ, je' anajty ycuydundaayb nej anajty ycojayɨty ma Dios ñecy mɨɨd yɨ' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jɨm anajty tüg pi'c uugɨ'ñ ymɨɨd anajty vinoxunnɨɨ. Chi ajcxy je' yajxoogy tüg esponja (jadu'n yɨ' nej po't) mɨɨd vinoxunnɨɨ, e chi yajjɨjp'eedzɨɨy tüg paxyjɨjp, je' mɨɨd yajjädy je vinoxunnɨɨ ma Jesús y'ahuac. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Co jada' Jesús co'uucnajxy je vinoxunnɨɨ, huin'it jadu'n ymɨnañ: ―Tɨ tüg'ócɨy nguydundäyɨch. Chi ñaax'ijxy, e chi y'o'cnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Com jabom anajty je pascua mɨjxɨɨ (amayxɨɨ ooy), e nañ sábado xɨɨ anajty. Paady copɨcy anajty co ajcxy yajmɨnájcɨpy ajcxy je jäy ninïcx je tɨɨbɨ anajty yajcruudzpejtcɨxy. Mɨɨd je' ycɨxpɨ je judíojäy ajcxy ñɨcxy ma Pilato pɨjctzoy may'ajt co huen ane'my yɨ soldados ajcxy, co huen nɨcxy yajtɨjy je jäy ytecy ajcxy huɨdibɨ tɨ yajcruudzpety. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","E chi ajcxy je soldados yja'ty ma je it ma ajcxy yajcruudzpejty Jesús. E je metzpɨ jäy ajcxy ytecy tɨjɨ huɨdibɨ ajcxy yajcruudzpejt tú'cɨy mɨɨd Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Co je soldados ajcxy ymɨjhuägy ma Jesús, huin'it ajcxy ijxy co tɨ anajty y'o'cnɨ, paady ca' ajcxy tɨjɨ ytecy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Chi tüg soldado cumy Jesús ma ycaachyjɨjp mɨɨd quipy jɨjpxu'ñybɨ. E huin'it tɨm mɨc'amy nɨ'py etz nɨɨ ypɨdzɨmy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tüg jäy jɨm anajty ixy nej ytunɨ yjajtɨ, e nañ yejc tɨy'ajt. E je' ytɨy'ajt janch je', e je' nejhuɨɨyb co yjanchɨty. Mɨɨd je tɨy'ajt ycɨxpɨ jëbɨ miich ajcxy nañ jadu'n mmɨbɨjctähuɨp. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Paady je' jadu'n ytunɨ yjajtɨ, co jadu'n anajty yajcuyduna'ñ jadu'n nej yjaybetyɨty ma Dios ñecy, co jadu'n ymɨnañ: “Ca' huaad ni tüg ypajc yajtɨjy.” ");
INSERT INTO mcoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E jadüg'it anajty ycojaayɨty ma Dios ñecy, ma jadu'n ymɨnañ: “Y'ixɨpy ajcxy je jäy huɨdibɨ ajcxy ycuum.” ");
INSERT INTO mcoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jɨm anajty José huɨdibɨ anajty cogájpɨp Arimatea. Yɨ' je' huɨdibɨ anajty mɨjpɨdacp Jesús, oy anajty ca' capxpɨdzɨmy, mɨɨd co anajty chɨgɨ̈y mɨɨd je judiojäy ajcxy huɨdibɨ anajty mɨdzip'ajtp Jesús. Co Jesús y'o'cy huin'it José oy pɨjctzoy may'ajt ma Pilato, co jëbɨ nɨcxy yajtzoonɨ Jesús ñaaxnïcx ma anajty tɨ yajcruudzpedyii. Co Pilato a'ɨxɨy, chi José ñɨcxy jɨm oy yajmɨnajcɨ je Jesús ñaaxnïcx, e chi yajnɨcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nañ mɨɨd ñɨcxy José je Nicodemo, je huɨdibɨ anajty jayɨjp tɨ ni'oy Jesús coodz. Nicodemo ymɨnɨcx oy nimɨgo'px libra mirra etz áloes tzooy huɨdibɨ ooy oy yxuugy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chi ajcxy yajpɨdɨ̈cɨ Jesús ñaaxnïcx, chi ajcxy mo'ñ mɨɨd poob huit, chi tzoyɨy ajcxy mɨɨd mirra etz áloes tzooy, jadu'n nej je judíojäy ajcxy ycostumbre mɨɨdɨty co o'cpɨ yajnaaxtɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Huingon ma je it ma ajcxy yajcruudzpejty Jesús, jɨm anajty tüg aguemy, e jɨm ma je aguemy jɨm anajty tüg o'cpɨ jut jemybɨ ma anajty ca'nɨ pɨn ñaaxtɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jɨm ajcxy Jesús ñaaxnïcx yajnaaxtɨgɨɨyɨ, co anajty jɨm yjac-huingonɨty, e janch jottɨgooy ajcxy yajnaaxtɨgɨɨy, mɨɨd co anajty tɨ chu'ɨɨyñɨ, e je judíojäy ajcxy tzachni'ixɨɨyñɨ tzach'a'ɨxɨɨyñɨ co je amayxɨɨ anajty chondägaanɨ com jabom. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tɨm seman ixtɨgɨ', moñyɨ anajty, ca' anajty oy xɨɨmɨɨyñɨ. Huin'it María Magdalena ñɨcxy ma Jesús anajty tɨ ñaaxtɨgɨ̈y. E chi jɨm ijxy co je tzaa tɨ anajty jɨm yajjɨɨdɨguecy ma je jut aguu. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Co ajcxy ijxy je jut ahuädz, chi jada' mɨc'amy poyɨ̈gyɨ ninɨcxy Simón Pedro, etz je jadügpɨ ydiscípulo huɨdibɨ anajty Jesús mɨɨd ooy naychogyii, chi nɨmay: ―Tɨ yajtzoongɨxy ɨɨch ajt nHuindzɨn ñaaxnïcx ma ajcxy yajnaaxtɨgɨy, e ca' nejhuɨɨyɨm ma ajcxy tɨ pɨdaaccɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Huin'it ajcxy nimetz chooñ poyɨ̈gyɨ Pedro etz je jadügpɨ discípulo, ñɨcxy ajcxy ma je o'cpɨ anajty ñaaxtɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Poyɨ̈gyɨ ajcxy ñɨcxy nimetz, per je jadügpɨ discípulo jayɨjp ñajxy, e jayɨjp jɨm oyja'ty ma je naaxtɨgɨydac. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chi yco'ixɨɨy jutjoty, huin'it jɨm oy ixy je mo'nhuit jiiby jutjoty y'ooxnäy, per ca' yɨ' jiiby ytɨgɨ̈y jutjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón Pedro co ymiñ jac'axam, tɨm janitɨgɨɨy jutjoty, chi ijxy je mo'nhuit y'ooxnäy jiiby jutjoty. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","E chi ijxy je cöxotz, je huɨdibɨ anajty mɨɨd ycohuajc yxochɨty, abɨcy je' anajty, ca' anajty tú'cɨy y'ooxnäy mɨɨd ymo'nhuit. Y'ijx ajcxy je cöxotz yajxon y'anëgyɨty abɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Huin'it ytɨgɨɨy jutjoty je jadügpɨ discípulo huɨdibɨ jacjayɨjp ja't. Chi ijxy, e huin'it mɨbɨjcy co Jesús ñaaxnïcx ca' anajty jiiby. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ca'nɨ anajty ajcxy yajxon huinjɨhuɨ̈y co anajty jadu'n ycojaayɨty ma Dios ñecy, co anajty je Cristo yjugypɨga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chi je metzpɨ ajcxy ydiscípulos yhuimbijty ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","E je María jɨm yhuɨ'mɨy ma je o'cpɨ jut ayaaxɨp. Chi ayaaxɨp yco'ixɨy ma je jut. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","E chi ijxy metz ángel, poob huit ajcxy ymɨɨd, y'ɨñaaygɨxy jiiby ma je Jesús ñaaxnïcx anajty yhuijtznäy, y'ɨñaaygɨxy tüg cöduy, jadüg tecy ɨxaay. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chi je ángel ajcxy nɨmay je María: ―¿Miich töxyjäy na'amy co myäxy? Chi je María y'adzooy: ―Tɨ ajcxy nHuindzɨn ñaaxnïcx yajnɨcxɨ, e ca' nnejhuɨ̈yɨch ma ajcxy tɨ pɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jadu'n anajty ymɨna'ñ, co ñayjɨɨ'ijxɨ, chi ijxy Jesús ytɨnäy ma yjɨɨx, e ca' ijxcajpy pen Jesús je' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chi Jesús ymɨnañ: ―Töxyjäy, ¿ti co myäxy? ¿Pɨn m'ixtaayb? María hue' anajty tijy je aguemy cuend'ajtpɨ mɨgapxɨp, paady jadu'n ymɨnañ: ―Huindzɨn, pen tɨ myajnɨcxy Jesús ñaaxnïcx, nigapx ma tɨ mbɨdägy, e ɨɨch nɨcxy nyajtzooñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chi Jesús ymɨnañ: ―María. Chi jada' María yhuäg-huimbijty, chi yajxon huindɨcxpejty, chi nɨmay: ―¡Raboni! ―jada hebreo ayuc yhuimbɨdzɨmy Huindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chi Jesús nɨmay María Magdalena: ―Ca' xyñïdooñɨch, com ca'nɨ ɨɨch nba'ttɨgɨ̈y ma Dios Teedy yajpaady. Nɨcx miich ixta' nmɨgügtɨjcɨch, e nɨma' co nnɨcxaamɨch ma Dios Teedy, ɨɨch nDeedy etz miich ajcxy mDeedy, ɨɨch nDios, etz miich ajcxy mDios nañ jadu'n. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chi María Magdalena oy yajnɨmäy je discípulos ajcxy, chi jadu'n nɨmay: ―Tɨ n'ixyɨch je Huindzɨn Jesús, e jadu'n yɨ' tɨ xycapxymöyɨch co nyajnɨmähuɨbyɨch miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Co je huin'it xɨɨmbɨ chuu'ɨɨy seman ixtɨgɨ', aducy anajty tɨjc'aguu y'ity ma anajty je discípulos ajcxy yajpatcɨxy, mɨɨd co anajty ajcxy tzɨgɨ̈y je judíojäy ajcxy huɨdibɨ anajty mɨdzip'ajtp Jesús. Chi Jesús ytɨgɨɨy cujc'amy ma je' ajcxy, e chi jada' capxpocxy ajcxy, nɨmay: ―Jotcugɨ' miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yam jadu'n anajty ymɨna'ñ, chi ajcxy yaj'ijxy je' ycɨ' ma je clavo ytɨgɨɨy, etz ycaachyjɨjp ma anajty jäy tɨ ycumyii. Chi yjotcugɨɨy ajcxy co ajcxy ijxy je yHuindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chi jada' Jesús jadüg'oc capxpoocx, nɨmay ajcxy: ―Jotcugɨ' miich ajcxy. Jadu'n nej ɨɨch nDeedy xyquejxyɨch ya naaxhuiñ, nañ jadu'n ɨɨch miich ajcxy yam nguejxhuäcxy mɨɨd ɨɨch n'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Co Jesús jadu'n ymɨnañ, chi jada' ajcxy nïbuxujy cöbuxujy nɨmay: ―Huen Dios yjɨhuɨ'ñ ymɨc'ajt xy'adɨgɨ̈y xyjottɨgɨ̈y ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Huenpɨnjäyɨty huɨdibɨ miich ajcxy mbocyhuinmeecxyp, nañ ypocyhuinmeecxɨpy Dios Teedy. Huenpɨnjäyɨty huɨdibɨ miich ajcxy ca' ypocy mhuinmeecxaanɨ, nañ jadu'n Dios Teedy ca' yɨ' ypocyhuinmeecxa'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás je' huɨdibɨ anajty mɨɨd majmetz yca'pxy Jesús ydiscípulos ajcxy, je huɨdibɨ anajty yajtijp Dídimo, ca' je' anajty jɨm choonɨty co Jesús ymiñ oga'n. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chi je jacjadyii ajcxy ymɨgüg ñɨmaayɨ: ―Tɨ ɨɨch ajcxy n'ixy je Huindzɨn Jesús. E chi je' y'adzooy: ―Pen ca' n'ixyɨch ma yɨ' ycɨ' je clavo'au, e pen ca' ngɨ̈huäxɨch ngodijɨ̈yɨch ma clavo'au, e ngɨ' nbɨdägyɨch ma ycaachyjɨjp ma anajty ycumyɨty, ca' nmɨbɨgɨpyɨch co yjanchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chi jacoductujc xɨɨ ajcxy jadüg'oc anajty yajpaady tɨgoty nidüg'ócɨy je discípulos ajcxy. Tzooñ anajty Tomás nañ jadu'n. Chi Jesús ymiñ. Agɨ̈y anajty tɨjc co Jesús ytɨnay'ahuɨɨy cujc'amy ma je' ajcxy. Huin'it ycapxpocxy, chi nɨmay: ―Jotcugɨ' miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chi jada' nɨmay je Tomás: ―Pɨdäg ya mgɨ̈huäx ma clavo'au ma ngɨ̈jɨch. Najtzxajɨ' mgɨ' etz pɨdäg ma ɨɨch ngaach ma jäy xycumyɨch, e mɨbɨc yajxon tɨydudägy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chi Tomás y'adzooy: ―Ɨɨch miich nHuindzɨn'ajtyp etz ɨɨch miich nDios'ajtyp. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chi Jesús Tomás nɨmay: ―Mɨɨd co miich tɨ xy'ixyɨch, paady miich tɨ mmɨbɨcy. Jotcujc yɨ' ajcxy huɨdibɨ ca' xy'ixyɨch, e tɨ ymɨbɨcy co tɨ njugypɨcyɨch co n'o'gyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tɨ anajty Jesús ooy tuñ mɨjhuinma'ñ ma ydiscípulos ajcxy yhuinduu huɨdibɨ ca' ycojaayɨty ma jadayaabɨ necy. ");
INSERT INTO mcoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Paady ycɨx jada ngojaayɨch jɨgɨx ajcxy mmɨbɨgɨpy co Jesús je' yɨ' je Cristo je Dios y'ung. E co miich ajcxy mmɨbɨgɨpy, huin'it mbaadɨp jugy'ajtɨn huɨdibɨ ca' tüccɨ'yɨ ycɨxɨpy ytɨgoyɨpy mɨɨd Jesucristo yxɨɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Co jadu'n jayɨjp ytunɨ yjajtɨ, huin'it jadüg'oc Jesús ñayguëxɨ̈cɨ ma je' ydiscípulos ajcxy jɨm ma mejypa', je huɨdibɨ anajty xɨɨjɨp Tiberias mejy. E jadu'n ñayguëxɨ̈cɨ: ");
INSERT INTO mcoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jɨm anajty ajcxy Simón Pedro mɨɨd Tomás huɨdibɨ jäy ytijyp Dídimo. Nañ jɨm Natanael huɨdibɨ anajty cogajp jɨm Caná Galilea naaxjot. E nañ jɨm anajty je Zebedeo ymang ajcxy etz jametz discípulos ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Chi Simón Pedro ymɨnañ: ―Nɨcxy n'oc'acxmachɨch. Chi ymɨgügtɨjc ajcxy ymɨnañ: ―Tzoc ajt jámɨm. Chi ajcxy ytɨgɨɨy ma tüg barco. E je huin'it tzuu ca' ni ti ajcxy majch. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Co yjobɨɨy jɨm Jesús anajty ytɨnäy ma mejypa'. Je' ydiscípulos ajcxy ca' anajty ajcxy nejhuɨ̈y co Jesús je' anajty. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chi Jesús ymɨnañ: ―Mɨgügtɨjc, ¿nej ca' ajcxy mbaadyñɨ acxɨ? Chi ajcxy y'adzooy: ―Ca' ni ti. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chi Jesús ymɨnañ: ―Pɨdaaccɨx ajcxy je huɨdibɨ mɨɨd m'acxmajtzcɨxy aa'oy'amy ma yɨ barco, e huin'it ajcxy mbaadɨpy acx. Chi ajcxy pɨdacy je acxmadzɨ'ñ aa'oy'amy, e huin'it janch adzaach ajcxy yajpɨdzɨmy, co janch may acx anajty tɨ ytɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Je ymɨgüg huɨdibɨ mɨɨd Jesús ooy anajty ñaychogyii, chi nɨmay Pedro: ―Je' yɨ', ɨɨch ajt nHuindzɨn. Co jadu'n mɨdooy Simón Pedro co anajty yjëjɨty je Huindzɨn Jesús, huin'it yhuit yajtɨgɨɨy. Com tɨ anajty yhuit jeñ, com jadu'n anajty jac'oy ytuñ. Chi ytɨgɨɨy mejyjoty huitmɨɨd. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jacjadyii ajcxy ymɨgügtɨjc yjädy ma mejypa' mɨɨd je barco, pahuich pajugucy ajcxy je y'acxmadzɨ'ñ janch ujtz mɨɨd acx. Hue' anajty ca' ooy yjɨguémyɨty ma mejypa', jëyɨ anajty mɨgo'px metro yjɨguemyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","E co ajcxy ymejch ma mejypa', chi ajcxy ijxy co jɨm anajty jɨɨmbajc y'ity ni'ixɨ', e jɨm anajty acx jɨɨmbajc nïgɨx huɨdibɨ yajtzaayb, e nañ jɨm anajty tzajcaagy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chi Jesús nɨmay je' ydiscípulos ajcxy: ―Yajmiingɨx yɨ acx tɨɨbɨ ajcxy mmajtzcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chi Simón Pedro ypejty barcojoty, chi yajpɨdzɨmy huindɨɨtztuum y'acxmadzɨ'ñ ujtz mɨɨd may'acx. Chi ajcxy mɨchoy mɨgo'px jahuixchɨgi'px majctugɨɨg acx mɨjatypɨ, e jadu'n ca' je acxmadzɨ'ñ ycɨɨch mɨɨd tzachmay'acx. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chi Jesús nɨmay ajcxy: ―Min ajop'ajtcɨx. E ni tüg ydiscípulos ajcxy ca' y'amɨdoohuɨ: ―¿Pɨn miich? Com ñejhuɨɨyb anajty ajcxy co je' anajty Huindzɨn Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chi Jesús ymɨjhuägy ma je acx cɨ' etz tzajcaagy anajty y'ity, e chi yajhuäcxy, chi moyday ymɨgügtɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","E je' je' anajty je mɨdugɨɨg'ocpɨ co Jesús ñayguëxɨ̈cɨ ma je' ydiscípulos ajcxy, huin'it co yjugypɨjcy co y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Co ajcxy y'ajop'ajttay, chi Jesús nɨmay je Simón Pedro: ―Simón, Jonás y'ung, ¿nej xyjactzojcpɨch miich, ca'ydɨ jada jacjadyii ndiscípulo'ɨchɨ? Chi y'adzooy Pedro: ―Huindzɨn mnejhuɨɨyb miich co ndzojcypɨch njɨhuɨɨybɨch miich. Chi Jesús nɨmay: ―Cuend'at ɨɨch njäy, jadu'n nej jɨhuɨ̈y borregɨ cuend'ajtpɨ yaj'ocy yɨ' yborregɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chi Jesús mɨmejtz'oc ymɨnañ: ―Simón, Jonás y'ung, ¿nej xychojcpɨch xyjɨhuɨɨybɨch miich? Chi Simón y'adzooy: ―Huindzɨn, mnejhuɨɨyb miich co ndzojcypɨch njɨhuɨɨybɨch miich. Chi Jesús nɨmay: ―Cuend'ajtɨgɨch njäy, jadu'n nej yɨ borregɨ cuend'ajtpɨ cuend'aty yborregɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Co mɨdugɨɨg'ocpɨ oy y'amɨdooy: ―Simón, Jonás y'ung, ¿nej xychojcpɨch xyjɨhuɨɨybɨch? Chi Pedro yjotmaybɨjcnɨ co mɨdugɨɨg'ocpɨ y'amɨdoohuɨ: “¿Nej xychojcpɨch xyjɨhuɨɨybɨch?” Chi Simón yjac'adzooy: ―Huindzɨn, miich mnejhuɨydaayb tüg'ócɨy, e nañ mnejhuɨɨyb co ɨɨch ndzojcyp njɨhuɨɨybɨch miich. Chi Jesús jacnɨmay: ―Cuend'ájtɨgɨch njäy, jadu'n nej borregɨ cuend'ajtpɨ cuend'aty yborregɨ. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Janch janch ɨɨch miich yam jadu'n nɨmäy: “Co anajty miich mjac'anägnɨty, cɨ'm anajty mhuit nayyajnïjenɨ̈yii, e mnɨcxp anajty ma mdɨmdzocy. E co mjacmɨjjäyɨ̈huɨpy, huin'it mgɨ' mnajtzxajɨ̈huɨpy, e huingbɨ mhuit xyajnïjenɨ̈huɨpy, e xyajnɨcxyɨpy ma anajty ca' mdzocy.” ");
INSERT INTO mcoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Co Jesús jadu'n ymɨnañ, chi Pedro yajhuinjɨhuɨɨy jadu'n nej anajty jäy ajcxy yaj'öga'ñyii mɨɨd Jesús y'ayuc ytɨy'ajt ycɨxpɨ, e nañ ma yɨ y'o'cɨn tɨy'ajt yegɨpy co ymɨɨd Dios ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chi Pedro ñayjɨɨ'ijxɨ, chi ijxy co anajty tú'cɨy anajty ymiingɨxy je' ydiscípulo huɨdibɨ anajty Jesús ooy tzocy jɨhuɨ̈y je huɨdibɨ anajty ɨñaayb huingon ma Jesús ma je mesa co anajty y'adzuu'ajtcɨxy. Je huɨdibɨ nɨmay je' yHuindzɨn: ―Huindzɨn, ¿pɨn miich yɨ' xycɨ̈yegam ma yɨ mmɨdzip? ");
INSERT INTO mcoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Co Pedro ijxy je jadügpɨ discípulo axam Jesús ypanɨcxyii, chi ymɨnañ: ―Huindzɨn, e jadayaabɨ mɨgüg, ¿ti yɨ' jadaanɨp? ");
INSERT INTO mcoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chi Jesús y'adzooy: ―Co ixyipy ndzocyɨch co yɨ' huen jugy'aty ixtɨ mabaad nhuimbityɨch, ca' miich xypaady mnejhuɨ̈huɨpy ti yɨ' jadam. Panɨcxcɨch miich. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Paady ycɨxp huinjɨhuɨy je ymɨgügtɨjc ajcxy co je ymɨgüg huɨdibɨ Jesús ooy tzocy jɨhuɨ̈y ca' anajty y'öga'ñ. Per Jesús canan je' anajty jadu'n ytijyp co ca' y'öga'ñ. Hue' anajty tɨ ymɨna'ñ janchtɨy: ―Pen ndzojcypɨch ixyipy co jada mɨgüg yhuɨ'mɨpy ixtɨ mabaad nhuimbityɨch, ca' miich xypaady mnejhuɨ̈huɨpy ti yɨ' ytunamy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Je' je' je Jesús ydiscípulo huɨdibɨ tɨy'ajt yejcp jadu'n nej Jesús ytuñ y'ayoy etz yjajty y'ayoy, e nañ yɨ' je' huɨdibɨ cojay nej Jesús ytuñ y'ayoy, yjajty y'ayoy. E ɨɨch ajt nejhuɨɨyɨm co janch yɨ' je tɨy'ajt huɨdibɨ tɨ yecy. ");
INSERT INTO mcoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","May ooy tijaty mɨj huinma'ñ Jesús jactuñ. Co ixyipy yajcojaydäy tüg'ócɨy, ca' yɨ naaxhuiñybɨ ixyipy yhuaadɨ̈y mɨɨd maylibro tzachpɨdägɨpy. Jadu'n n'aa'ɨxɨ̈yɨch.");
INSERT INTO mcoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Ma je jayɨjp'atypɨ necy, mɨgüg Teófilo, tɨ nyajnijayɨ̈y tüg'ócɨy jadu'n nej Jesús ytuuñ etz jadu'n nej yaj'ixpɨjctzondacy oga'n'aty, ixtɨ coonɨ ypättɨgɨɨy tzajpjoty. Ca'nɨ Jesús anajty ypättɨgɨ̈y tzajpjoty co huin'ijxy je' yjäy huɨdibɨ yɨ' y'ayuc ytɨy'ajt capxhuäcxɨɨb, e chi mɨɨd je Espíritu Santo najtztunɨɨy najtz'ane'mɨɨy nej huaad ajcxy ytunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Co anajty Jesús y'ögy, chi ñayguëxɨ̈cɨ canaag'oc ma je' ydiscípulos ajcxy, e huixchiguïpx xɨɨ ñayquëxɨ̈go'cɨ ma je' ajcxy, yajniquëxɨ̈gy huädz co anajty yjuugyɨty, etz nañ yajmɨɨdmɨydacy je' yjäy je Dios y'ayuc etz Dios y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Co anajty jɨm ijtcɨxy tügmucy mɨɨd Jesús, chi Jesús je' ydiscípulos ajcxy ane'my co ca' huaad jɨm choongɨxy jɨm Jerusalén. Chi ajcxy nɨmay: ―Ahuijxcɨx tɨɨbɨ Dios nDeedy ahuanɨ̈y ma miich ajcxy, je huɨdibɨ miich ajcxy nyajmɨɨdmɨydägy. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Janch Juan je Bautista jäy yajnɨɨbejt mɨɨd nɨɨ, tzojc miich ajcxy xy'adɨgɨ̈huɨpy xyjottɨgɨ̈huɨpy yɨ Espíritu Santo. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ni'amugɨ̈ anajty ajcxy jɨm mɨɨd Jesús, chi ajcxy yajtɨɨy: ―¿Huindzɨn, nej myajcödɨgoyamy je Israeljäy ymɨdzip jadachambɨ? ");
INSERT INTO mcoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chi Jesús y'adzooy: ―Ca' xypaatcɨxy mnejhuɨɨygɨxy je xɨɨ je tiempo mɨna anajty tɨ yhuaad'ajtnɨ, mɨna Dios Teedy tuna'ñ tijaty, je' tügpajc mɨɨd cötújcɨn tijaty ytunamy. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Co anajty je Espírito Santo chɨnaydacpɨcy ma ajcxy mjot mhuinma'ñ mbaatcɨxp mɨc'ajt. E chi mdzoongɨxp ayuc capxhuäcxpɨ mɨɨd ɨɨch ycɨxpɨ ya Jerusalén, etz tüg'ócɨy Judea ñaaxjot, etz jɨm Samaria, etz huindu'my ñaaxhuiñybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tɨ jada ajcxy jadu'n yajnɨmäy, jɨm anajty ajcxy yhuindɨɨcxcɨxy, chi Jesús chajppejtnɨ. Chi miñ joc yeeg huɨdi Jesús yajnïdɨgoyday, chi ajcxy ca' ocjac'ijxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jadu'n anajty ajcxy chachpät'íjxcɨxy tzajpcɨ́xy, co Jesús ypättɨgɨɨy. Huin'it mejtz yëydɨjc ñayguëxɨ̈cɨ ma je' ajcxy ymɨjc, poob huit mɨɨd, ");
INSERT INTO mcoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","chi ajcxy ñɨmaayɨ: ―Galilea jäy ajcxy, ¿nej co mdzachpät'ijxcɨxy tzajpcɨ́xy? Yɨ Jesús huɨdibɨ tɨ chajppety, tɨ chooñ ma miich ajcxy, minaamb jadüg'oc jadu'n nej tɨ m'ijxcɨxy co tɨ ypättɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Huin'it Jesús ydiscípulos ajcxy choonɨ ma je cögop huɨdi xɨɨjɨp Olivos, yhuimbíjtcɨxnɨ jɨm Jerusalén, ca' ooy yjɨguëgyɨty, jëbɨ yajyöy sábado xɨɨ, jadu'n nej Moisés ycötújcɨn y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Co ajcxy yja'ty ma je cajp, chi ajcxy ypejty ma je cuarto mɨmetz nïhuijtzpetypɨ ma ajcxy anajty mɨɨdɨty yjättac. Jɨm yɨ' anajty ajcxy: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo ymang Jacobo, Simón je Zelote etz Judas Jacobo ymɨguëx. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tüg'ócɨy anajty ajcxy y'ijtcɨxy tügmucy Dios mɨbɨjctzoogɨxy chajpcapxycapxcɨxy. Ymɨɨd ajcxy anajty Jesús y'uch etz María Jesús ytaj, etz jacjadyii töxyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Huin'it xɨɨ Pedro ytɨnayɨ̈gy agujc'amy ma je ymɨgügtɨjc ajcxy huɨdibɨ yajmɨj'ajtp Jesús, huɨdi anajty ajcxy naybaatɨp mɨgo'px ja'iipxtɨ jäy, chi nɨmay ajcxy: ");
INSERT INTO mcoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Mɨgügtɨjc, copɨcy co jada yajcuydúnɨpy nej Dios ymɨnañ ma ñecy huɨdi jaybety ijtp, ma David jaay Dios y'ayuc, ma Dios nigapxy Judas. Je'huɨdi coduu'ajt taabɨ je judíojäy ajcxy majch Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Je Judas yaj'amɨchomujcp je' anajty mɨɨd ɨɨch ajt, paatɨp anajty Dios ytung tú'cɨy mɨɨd ɨɨch ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chi Judas ñɨcxy juy tüg naax mɨɨd je muju'ñ huɨdibɨ anajty tɨ paady mɨɨd yjɨbɨc-huinma'ñ. Chi jɨm mɨc'amy ycäy tzuxcödeeñ, chi ytopxy ymooxac, e chi ytiinch ypɨdzɨmday. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Je jäy ajcxy huɨdibɨ anajty tzɨnaayb jɨm Jerusalén, co nejhuɨɨy, chi ajcxy yxɨɨmoy je naax Acéldama, hue' je' yhuimbɨdzɨmy ma je' ajcxy ayuc, nɨ'py ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jada je' je ayuc huɨdibɨ David yjaay ma je Salmo necy: Huɨ'mɨp najtz'ixɨ̈y yɨ' chɨnaaydac. E ca' pɨn yajtunɨpy. Nañ jadu'n ymɨna'ñ: Huingbɨ huen yajnɨcxyii je' ytung. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Copɨcy co tüg yëydɨjc huɨdibɨ mɨɨd tɨ yhuɨdity nHuindzɨn Jesús quipxyɨ mɨɨd ɨɨch ajt, huen tunɨpy je tung huɨdibɨ Judas anajty ytumyb, maab Juan yajnɨɨbety ixtɨ taabɨ xypuyöyduutɨm co pättɨgɨy tzajpjot, tüg jëbɨ testig'aty mɨɨd ɨɨch ajt co Jesús yjugypɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chi Jesús ydiscípulos ajcxy huin'ijxy mejtz jäy: tüg jäy huɨdi anajty yxɨɨ José, huɨdi yxɨɨ anajty yajtijy Barsabás etz nañ jadu'n anajty yajtijy Justo. E huin'ijxy ajcxy nañ jadu'n Matías. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Chi Jesús ydiscípulos ajcxy Dios mɨbɨjctzoy, ymɨnañ ajcxy: ―Huindzɨn Dios, m'ijxyp mnejhuɨɨyb tüg'ócɨy jäy yjot yhuinma'ñ, yajni'ixɨɨygɨch jada metzpɨ jäy huɨdibɨ miich nidügtɨ tɨ nhuin'ixy, je huɨdibɨ jëbɨ jɨjptɨgɨyɨ̈y miich mdung tú'cɨy mɨɨd ɨɨch ajcxy, etz huɨdibɨ apóstol'adɨp. Huen jada jäy jɨjptɨgɨyɨ̈y je tung huɨdibɨ Judas tɨ yajtɨgooy, co ytundɨgooy e ñɨcxy ma ypaadyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Chi ajcxy suerte ijxy, e je suerte ñibɨdzɨmnɨ je Matías. E huin'ítɨy je Matías oy ymɨcho'ndɨgɨ̈y ma je nimajtügpɨ ajcxy huɨdi ycapxhuäcxy Jesús y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Co oy je Pentecostés xɨɨ paady, jɨm anajty Jesús ydiscípulos ajcxy ni'amugɨ' tú'cɨy ijtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Huin'it janch tɨmɨtiinɨ yajmɨdoy tüg ne'mɨn, choñ tzajpjoty, jadu'n nej poj mɨcpɨ. Chi yaj'ujtztaay je tɨgot ma anajty ɨñaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chi nigɨdaacɨ nidüg nidügtɨ toodz jadu'n nej jɨɨnye'n. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chi je Espíritu Santo nidüg nidügtɨ ajcxy y'adɨgɨɨyɨ yjottɨgɨɨyɨ. Chi ytɨgɨ́ɨygɨxnɨ capxy mɨydaacp nije' nije' ayuc jadu'n nej je Espíritu ajcxy yajcapxyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jɨm Jerusalén anajty je huin'it xɨɨ may judíojäy ajcxy huɨdibɨ tzoomb canaag agajp. Hue' ajcxy chachcuydumb judíojäy ycostumbre. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Co je cajpjäy ajcxy mɨdooy je ne'mɨn, chi ajcxy ooy yöymujcy. Chi je mayjäy ooy yhuinmay'ahuɨdijty, co ajcxy mɨdooy chachcapxcɨxy chachmɨydaaccɨxy ma ycɨ'm'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Je mayjäy ajcxy ooy chɨgɨɨy jɨhuɨɨy, chi ajcxy ñayñɨmaayɨ miñ xyɨpy: ―Ix ¿nej cay Galilea jäy jada ajcxy nidüg'ócɨy huɨdibɨ jadu'n tzachcapxcɨxy tzachmɨydaaccɨxy ɨɨch ajt ngɨ'm'ayuc? ");
INSERT INTO mcoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nej ɨɨch ajt co nmɨdo'mbɨ́jcɨm co tzachmɨydaaccɨxy ɨɨch ajt n'ayuc huɨdibɨ tɨ nmɨbi'c'ájtɨm? ");
INSERT INTO mcoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ya anajty ajcxy Partia jäy, Media jäy, Elam jäy, Mesopotamia jäy, Judea jäy, Capadocia jäy, Ponto jäy, etz cham huɨdi tzɨnaayb ajcxy jɨm Asia ñaaxjot, ");
INSERT INTO mcoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","etz huɨdibɨ ajcxy tzomb jɨm Frigia, etz Panfilia, huɨdibɨ tzomb jɨm Egipto, etz huɨdibɨ tzomb jɨm ma yɨ Africa ñaaxjot Cirene nïnaxy. Nañ jadu'n jɨm romanojäy huɨdibɨ ya adzɨnaayb. May ajcxy jɨm huɨdibɨ judíojäy etz nijëjɨty huɨdibɨ ca' yjudíojäyɨty huɨdibɨ judíojäy ycostumbre ajcxy tɨ yjɨjptɨgɨyɨɨyɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ya nañ jadu'n Creta jäy etz Arabia jäy; e ɨɨch ajt tüg'ócɨy nmɨdoohuɨm jada jäy ajcxy nigapxcɨxy nimɨydaaccɨxy huɨdi Dios tɨ tuñ mɨjcajee ma ɨɨch ajt ngɨ'm'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nidüg'ócɨy ajcxy ooy jɨhuɨ̈y, e chi ajcxy ooy yhuinmay'ahuɨdijty, miñ xyɨpy ñay'amɨdóohuɨgɨxy: ―¿Nej jada yhuimbɨdzɨma'ñ? ");
INSERT INTO mcoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E nijëjɨty jäy jëyɨ nɨxïgy yajxïgy, ymɨnaangɨxy: ―Muucɨp jada yɨ' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Huin'it Pedro ytɨnayɨ̈gy mɨɨd je nimajctügpɨ apóstoles, e ytɨgɨɨy capxpɨ mɨc ymɨnañ: ―Yëydɨjctɨjc ajcxy huɨdibɨ tzɨnaayb Judea etz tüg'ócɨy huɨdibɨ tzɨnaayb ya Jerusalén, nejhuɨ̈huɨpy miich ajcxy jada e mɨdou ajcxy yajxon huɨdibɨ ajcxy nyajnɨmähuamyb. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jada jäy ajcxy ca' ajcxy ymügyii jadu'n nej miich ajcxy mɨnaangɨxy. Tɨm petyxɨɨnɨ jada cham. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jada je' huɨdibɨ ñigapxy je Joel, Dios y'ayuc najtzcapxɨɨybɨ, co jadu'n mɨna'ñ: ");
INSERT INTO mcoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Je huin'it xɨɨ mɨna anajty je naaxhuiñybɨ cɨxa'ñ, jadu'n Dios mɨnañ, nyajhuäcxtähuɨbɨch je nEspíritu ma tüg'ócɨy naaxhuiñyjäy. Miich mnɨɨx etz mmang ajcxy capxhuäcxɨp ɨɨch n'ayuc ndɨy'ajt, e je yujcyeecpɨdɨjc ajcxy yhuin'ixɨpy ooy mɨjhuinma'ñ, e je mɨjjäydɨjc cumähuɨpy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nyajhuäcxtähuɨp ɨɨch je nEspíritu huin'it xɨɨ ma ɨɨch ndumbɨ yëydɨjcpɨ töxyjäybɨ, e yɨ' ajcxy capxhuäcxɨp ɨɨch n'ayuc ndɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nyajquëxɨ̈gɨbɨch tzajpcɨ́xy huɨdijaty oy chɨgɨɨyñɨ, e ya naaxhuiñ nyegɨpyɨch tɨy'ajt: nɨ'py, jɨɨn etz jɨɨnjoc. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yɨ xɨɨ ahuimbidɨpy coodz, etz je po' ahuimbidɨpy nej nɨ'py, ma anajty ca' miñ je xɨɨ je tiempo mɨna anajty mina'ñ je Huindzɨn Dios. Mɨj ayo'n ji tunaanɨp jadaanɨp ijxna' quëxna'. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","E tüg'ócɨy jäy huɨdi mɨyaaxp ojadajtp je Huindzɨn Dios, Dios ajcxy yajnïdzögɨɨb y'alma. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Chi Pedro yjacmɨnañ: ―Amɨdo'ijtcɨx, miich judíojäy ajcxy, jadu'n nej cham nmɨna'na'ñɨch. Je Jesús huɨdibɨ tzoon jɨm Nazaret tɨ xyaj'ijxcɨxy Dios ymɨc'ajt, mɨjhuinma'ñ, etz ijxpejt, jadu'n nej miich ajcxy tɨ m'ijxcɨxy tɨ mnejhuɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jada yajcɨ̈yejc ma miich ajcxy, jadu'n nej anajty Dios tɨ yajnigödugɨ̈y, e tɨ huinmay. Ajcxy mmajch je Jesús e myaj'ögy ajcxy, chi ajcxy myajcruudzpejty mɨɨd jɨbɨc jäydɨjc y'ané'mɨn. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Chi Dios yajjugypɨjcy yajnïhuädzɨ̈ctuty ma yɨ ó'cɨn, ca' huaad yhuɨ'my ögy huinɨxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Je David ñimɨydac Jesús chi ymɨnañ: Nejhuɨɨybɨch co je nHuindzɨn Dios y'ity ma ɨɨch nhuinduu. Yɨ' ijt ma ɨɨch n'a'oy, jɨgɨx ca'ydɨ pɨn xy'adzɨgɨ̈yɨch xyajhuinma'ñydɨgooyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Paady tɨ njotcugɨ̈yɨch, e tɨ ngapxypɨdzɨmyɨch co ooy njotcujcɨch. Paady co oy n'ögɨbɨch etz ninïcx ñaaxtɨgɨ̈huɨpy, ca' ndajy mayɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Co miich Dios ca' myajhuɨ'ma'ñ ɨɨch n'alma ma ñaaxtɨgɨydac. Ni mga'aa'ɨxɨ̈huipy, co miich mdumbɨ huɨdibɨ ooy mdzocy, co nɨcxy ñinïcx ñaaxhuindɨgoydäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Miich Dios, tɨ xyajni'ixɨ̈yɨch yɨ tzɨnaayɨn huɨdibɨ ymɨɨd jugy'ájtɨn huinɨxɨɨbɨ. Xyajjotcugɨ̈huɨbɨch mɨɨd co xymɨɨd'idɨpyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Chi Pedro yjacmɨnañ: ―Mɨgügtɨjc ajcxy, huädz miich mnejhuɨɨygɨxy co ɨɨch ajt nmɨj'ap David y'o'cy etz yajnaaxtɨgɨɨyɨ. E ma ñaaxtɨgɨɨy nmɨɨdnɨ jë'ajt chambaad. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Je David hue' je' anajty Dios y'ayuc ñajtzcapxɨɨybɨ, e ñejhuɨɨyb anajty co tɨ Dios yajnɨmäyii huɨdibɨ ca' y'anɨɨjɨty. David ñejhuɨɨyb anajty co ma y'ap y'oc ma'xung'adɨpy Cristo, jaydëbɨ ané'mɨpy ma David y'ane'mdac. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jadu'n co David jecy'ajty huinjɨhuɨɨy e nejhuɨɨy etz nigapxy jadu'n nej yjugypɨga'ñ je Cristo co anajty tɨ y'ögy. E ymɨnañ co ca' yɨ' y'alma yhuɨ́'mɨpy jutjoty etz ñinïcx ca' ypüdzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios yajjugypɨjcy je Jesús co y'o'cy. Jada tɨy'ajt ɨɨch ajcxy nidüg'ócɨy nidɨy'ajt'ajtpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jadu'n Dios Jesús mooy mɨj'ajt jiiby tzajpjoty, chi yajcɨ̈dɨgɨɨyɨ je Espíritu Santo huɨdibɨ Dios Teedy y'ahuanɨɨy e tüg'ócɨy huɨdibɨ miich ajcxy tɨ m'ijxcɨxy tɨ mmɨdoogɨxy jiiby yɨ' chooñ ma yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Com David ca' je' chajppejty, je David cɨ'm ymɨnañ: Je Huindzɨn Dios nɨmay ɨɨch nHuindzɨn: “Ɨña' ma ɨɨch a'oy'amy, ");
INSERT INTO mcoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ixtɨ coonɨ nmɨmadactähuɨbɨch yɨ mmɨdzip, jadu'n anajty nipaady nej jɨhuɨ̈y mdecypocxpejt'adyii.” ");
INSERT INTO mcoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Chi Pedro yjacmɨnañ: ―Ñejhuɨ̈huɨpy nidüg'ócɨy yɨ Israel jäy ajcxy co janch janch co je Jesús huɨdibɨ miich ajcxy myajcruudzpejt, Dios yajnïbɨjc co yhuindzɨn'adɨpy ma miich ajcxy, etz Cristo huɨdibɨ xyñihua'nɨpy xyajtzögɨpy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Co je mayjäy ajcxy jadu'n mɨdoy, chi ajcxy yjotyungɨɨy, e amɨdoy ajcxy je Pedro etz jacjadyii jäy huɨdi Jesús y'ayuc capxhuäcxɨ anajty, chi ajcxy ymɨnañ: ―Mɨgügtɨjc, ¿ti ɨɨch ajcxy jëbɨ huaad nduñ? ");
INSERT INTO mcoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Huin'it Pedro y'adzooy: ―Jothuimbijtcɨx e nɨɨbejtcɨx nidüg nidüg mɨɨd Jesucristo yxɨɨ, jɨgɨx Dios miich ajcxy mbocy xyhuinmeecxɨpy. E jadu'n Dios xymöhuɨpy je Espíritu Santo. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Huɨdibɨ Dios y'ahuanɨɨy miich yɨ' ajcxy mje' etz m'ung ajcxy, etz m'ap m'oc ajcxy, etz nañ jadu'n je jäy ajcxy huɨdi jɨguémɨp, etz jacjadyii jäy ajcxy huɨdi Dios huin'ixamy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mɨɨd jadayaab ayuc etz jacjadyii ayuc Pedro yajnɨmay capxhuijy je mayjäy ymɨnañ: ―Ca' mmɨjpɨdaaccɨx je jäy ajcxy y'ayuc huɨdibɨ ca' capxymɨdoy Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jadu'n yjajtɨ, je jäy ajcxy huɨdijaty mɨbɨjc Pedro y'ayuc, chi ajcxy ñɨɨbejttay huin'it xɨɨ. Ñimayɨɨy ajcxy huɨdibɨ mɨjpɨdac Jesús y'ayuc oy nidugɨɨg mildɨ jäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tüg'ócɨy ajcxy anajty panɨcxcɨxy yɨ ixpɨ́jcɨn jadu'n nej yɨ Jesús y'apóstoles ajcxy yaj'ixpɨjcy. Chɨnaaygɨxy yquipxyjot yquipxyhuinma'ñ. Etz Dios mɨbɨjctzoogɨxy e ñayyöymújcɨgɨxy co anajty ajcxy chajcaagy tujc-huäcxaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nidüg'ócɨy ajcxy anajty ooy mɨjcajee jɨhuɨɨy. E Jesús y'apóstoles ajcxy ijxpejt etz mɨjhuinma'ñ ooy anajty tungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nidüg'ócɨy je jäy ajcxy huɨdibɨ anajty tɨ ymɨbɨjccɨxy ijtp anajty ajcxy tüg mucy, e yajhuäcxcɨxy tijaty ajcxy anajty ymɨɨd, mooygɨxy ymɨgügtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ytoocpy anajty ajcxy yɨ' ypɨdägy huɨdibɨ anajty ymɨɨd, e chi anajty yajhuäcxcɨxy yɨ meeñ nije' nije' nej pɨn ti yajmayjaty. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jabom jabom anajty ajcxy ñayyöymugyii ma Dios ytɨjc, etz nañ ñayyöymugyii ajcxy ma ytɨjc tzajcaagy tujc-huäcxcɨxy etz ycaaygɨxy y'uuccɨxy ni'amugɨ' jotcujc mɨɨd ajcxy y'oyjot y'oyhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ñi'ɨɨgɨxy niyaaxcɨxy yɨ Dios, e tüg'ócɨy jäy nayyajmɨj'ájtɨp anajty ajcxy. Chi je Huindzɨn Dios yajmayɨ̈y jabom jabom yɨ mɨbɨjcpɨdɨjc, yɨ' huɨdibɨ anajty patp nïdzoocɨn. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tüg xɨɨ Pedro etz Juan ypättɨgɨ̈y ajcxy tú'cɨy ma Dios ytɨjc, mɨjmɨnacy xɨɨ anajty, je' je' anajty je horɨ mɨna ajcxy Dios mɨbɨjctzoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jabom jabom anajty jäy yajnɨcxcɨxy ma je Dios ytɨjc'aguu tüg tecyma'tpɨ, jadu'n je' anajty tɨ yma'xung'aty. Chi ajcxy pɨdägy je tecyma'tpɨ ma je Dios ytɨjc'aguu huɨdi anajty yxɨɨ la Hermosa, jɨgɨx jɨm pɨjctzohuɨpy meeñ ma je jäy ajcxy huɨdibɨ tɨgɨɨyb ma Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Co je jäy tecyma'tpɨ ijxy Pedro etz Juan ytɨgɨ̈huaangɨxy anajty ma Dios ytɨjc, chi pɨjctzoy meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Co Pedro etz Juan ijxy je tecyma'tpɨ, chi Pedro ymɨnañ: ―Huindɨcxpejtcɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chi je jäy huindɨcxpejty, yjɨjp'ijxpy anajty ti möhuaanɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Chi Pedro je tecyma'tpɨ nɨmay: ―Ca' nmɨ́ɨdɨdyɨch plata, oorɨ, huɨdibɨ janchtɨy nmɨɨdɨch je' nmöhuɨp. Mɨɨd Jesucristo je Nazaretpɨ ymɨc'ajt ɨɨch miich nɨmaayb: Tɨnaayɨ̈g etz yöy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Huin'it Pedro majch je tecyma'tpɨ ma a'oygɨ', e yajtɨnaygugɨɨy. Huin'ítɨy y'oyɨɨy ymɨcpɨjcy je ytecy etz ytecyyög. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chi je tecyma'tpɨ ytɨnaygugɨɨy etz chi ñajtztɨbɨɨy. Chi jada' yöychoñ e ytɨgɨɨy ma Dios ytɨjc mɨɨd Pedro etz Juan yöyñɨp ñɨdɨjcnɨ yujctɨjcnɨ, yam Dios ooy jäymech. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tüg'ócɨy je mayjäy ijxy co anajty yöyñɨp etz jäymech yɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Je jäy ajcxy y'ijxy'ajtpy anajty ajcxy je tecyma'tpɨ e ñejhuɨɨygɨxyp co je' anajty je' huɨdibɨ pɨjtzohuo'cp pi'c meeñ ma Dios ytɨjc'aguu huɨdi anajty yxɨɨ la Hermosa. Paady je jäy ajcxy ooy chɨgɨɨy jɨhuɨɨy, co ajcxy ijxy nej anajty yam tɨ ytunyii tɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Je tecyma'tpɨ huɨdibɨ anajty tɨ chögy ca' anajty ixmach Pedro etz Juan, e tüg'ócɨy yɨ jäy anajty ooy jɨhuɨɨygɨxy huinmaaygɨxy. Chi mɨc'amy mayjäy nimujcy Pedro etz Juan jɨm ma yɨ Dios ytɨjc huinduu huɨdibɨ jäy ytijpy Salomón. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro co jadu'n ijxy je mayjay, chi ymɨnañ: ―Judío yëydɨjctɨjc, ¿nej co mdzachhuinmaaygɨxy mɨjcajee? ¿Nej co ɨɨch miich ajcxy xychachhuindɨɨcxcɨxy jadu'n nej jɨhuɨ̈y ɨɨch ajcxy jada jäy tɨ nyajtzögyɨch tɨ nyajyöychooñɨch mɨɨd ngɨ̈mmɨc'ajtɨch, o mɨɨd co ɨɨch ajcxy ooy nDios'ojadaty? ");
INSERT INTO mcoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ɨɨch'ajt nDios, je Dios huɨdi nmɨj'ap nmɨjteedy, je Abraham, je Isaac, etz je Jacob y'ojadajt, yɨ' tɨ yajtzögy jada tecyma'tpɨ, jɨgɨx yajcömayɨpy yɨ' y'ung Jesús huɨdibɨ miich ajcxy mgɨ̈yejc ma je tungmɨɨdpɨ. E co je gobernador Pilato je' najtzmadzɨ̈hua'ñ, miich ajcxy ca' m'aa'axɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ma yjapadyii ajcxy mgapɨjctzoy co huen yajnajtzmadzɨ̈y, je huɨdi anajty yajpaatp huädz etz tudägy, chi miich ajcxy mbɨjctzoy co huen yajnajtzmadzɨ̈y tüg jäy huɨdibɨ anajty tɨ yjäyyaj'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jadu'n je jäy ajcxy yaj'o'cy je' huɨdibɨ anajty jugy'ajt yejcp. Je huɨdibɨ Dios yajjugypɨjcy ma anajty tɨ y'ögy e jada tɨy'ajt ɨɨch ajcxy nidɨy'ajt'ajtpyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mɨɨd co tɨ mɨbɨcy Jesús yxɨɨ, je mɨjhuinma'ñ huɨdibɨ Jesús ymɨc'ajt tɨ tuñ mɨɨd jada pa'mjäy huɨdibɨ miich ajcxy m'ijxyp mnejhuɨɨyb. Com tɨ mɨbɨcy Jesús paady tɨ chögy janch yajxondïcnɨ, jadu'n nej miich ajcxy nidüg'ócɨy tɨ m'ijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Chi Pedro yjacmɨnañ: ―Nmɨgügtɨjcɨch, nejhuɨɨybɨch co miich ajcxy etz mhuindzɨndɨjc yaj'o'cy Jesús, mɨɨd co anajty mganejhuɨɨygɨxy ti anajty ajcxy mduungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jadu'n cham Dios tɨ cuyduñ jadu'n nej Dios y'ayucnajtzcapxɨɨybɨ ymɨna'ñ co copɨcy co yɨ Cristo yajnaxɨpy ayo'n. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Paady játyɨm jothuimbijtcɨx miich ajcxy ma Dios, jɨgɨx ajcxy mbocy yajjötztähuɨpy. Huin'it je Huindzɨn Dios xyajniguexɨpy ajcxy jotcujc'ájtɨn huinɨxɨɨ, ");
INSERT INTO mcoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","e yɨ' quexamb je Jesús, je Cristo, je huɨdibɨ Dios jayɨjp'aty yhuin'ijx co quexa'ñ ma miich ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Oy jadachambɨ Jesucristo y'oc-huɨ́'mɨpy jiiby tzajpjoty ixtɨ coonɨ Dios anajty yaj'oyɨydäy tijaty, co jadu'n yjaay yɨ' y'ayucnajtzcapxɨɨybɨ huɨdibɨ mɨɨd huädz yjot yhuinma'ñ huɨdibɨ ajcxy jecy'ajty tzɨnay. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Jadu'n Moisés nɨmay ɨɨch ajt nmɨj'ap nmɨjteedy jecy'ajty: “Je Huindzɨn Dios xyajniguexaan miich ajcxy tüg yɨ' y'ayucnajtzcapxɨɨybɨ, huɨdibɨ pɨdzɨmamyb ma miich ajcxy mjuugy mmɨgüg jadu'n nej ɨɨch yɨ' xyguejxy. M'amɨdo'idɨpy miich ajcxy yɨ' y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jadu'n yjadɨpy co tüg'ócɨy jäy huɨdibɨ anajty ca' capxymɨdooy je Dios y'ayucnajtzcapxɨɨybɨ, huädz ajcxy ytɨgoydähuɨpy, e tüg jɨɨbɨcy ajcxy idɨpy ma judíojäy ajcxy yajpaady.” ");
INSERT INTO mcoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Chi Pedro yjacmɨnañ: ―Jadu'n jada tüg'ócɨy Dios y'ayucnajtzcapxɨɨybɨ, chondacy ma Samuel ixtɨ ma jacjadyiinɨ ajcxy, ñigapxtay ajcxy jadu'n nej cham ytuñyii yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yɨ Dios y'ayucnajtzcapxɨɨybɨ ajcxy, miich je' anajty ajcxy mmɨj'ap mmɨjteedy. E je ayuc huɨdibɨ Dios yajnɨmay Abraham ycuydunaamyb mɨɨd miich ajcxy co jadu'n ymɨnañ: “Ngonúucxɨbɨch tüg'ócɨy naaxhuiñyjäy mɨɨd tüg miich m'ap m'oc.” ");
INSERT INTO mcoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Co Dios y'ung y'o'cy, chi Dios yajjugypɨjcy jadüg'oc, e quejxy jayɨjp ma miich ajcxy, jɨgɨx xyconúucxcɨxɨpy, etz jɨgɨx nidüg'ócɨy miich ajcxy m'ixmadzɨpy yɨ mjɨbɨchuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro etz Juan jɨmnɨ anajty tzachmɨɨdmɨydaaccɨxy je mayjäy ajcxy, co oy miingɨxy je judío teedy ajcxy, mɨɨd je soldado huindzɨn, je tzajptɨjc cuend'ajtpɨ etz mɨɨd saduceojäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ooy ajcxy anajty yjotmätcɨxy co Pedro etz Juan yaj'ixpɨjccɨxy anajty je mayjäy etz nɨmaaygɨxy co yɨ öcpɨ jugypɨgɨpy yɨ' ajcxy, com co Jesús yjugypɨcy co y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chi je tungmɨɨdpɨ ajcxy majch Pedro etz Juan, e chi ajcxy pɨdacy pujxtɨgoty ixtɨ com jabomnɨ, com tɨ anajty chu'ɨɨñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mayjäy ajcxy huɨdibɨ anajty tɨ amɨdo'ijtcɨxy je Pedro y'ayuc ymɨbɨjc ajcxy. E hue' je mɨbɨjcpɨdɨjc, ac yëydɨjctɨjcpɨ, yajmɨchomujcy jahueen ycamɨgoox mílɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Je com jabom ajcxy ñaymújccɨ jɨm Jerusalén judíojäy tungmɨɨdpɨ, je mɨjjäydɨjc etz yɨ escribas. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nañ jadu'n jɨm anajty Anás huɨdibɨ anajty ane'mb je teedy ajcxy, etz je Caifás, je Juan, je Alejandro, etz tüg'ócɨy teedy mɨjtungmɨɨdpɨ yjugymɨgüg. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chi ajcxy pɨdacy Pedro etz Juan cujc'amy ma anajty ajcxy ñaymugyii, chi ajcxy y'amɨdooy: ―¿Pɨn miich ajcxy tɨ xymöy cötujcɨn co jada jadu'n tɨ mdungɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Huin'it Pedro ymɨɨd anajty Espíritu Santo ma yjot yhuinma'ñ, chi ymɨnañ: ―Miich ajcxy tungmɨɨdpɨ etz judíojäy mɨjjäydɨjc, ");
INSERT INTO mcoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yɨ' ɨɨch miich ajcxy cham xyaj'amɨdoob yɨ oybɨ tɨɨbɨ yajtuñ ma tüg pa'mjäy e nejhuɨ̈huaangɨxy nej tɨ chögy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Cham nimɨydactäyɨch ma miich ajcxy mhuinduu, jaydëbɨ ajcxy nejhuɨydähuɨpy tüg'ócɨy judíojäy, co jadayaabɨ jäy huɨdibɨ anajty tecyma'tpɨ, cham yajpaady ya ma miich ajcxy mhuinduu mɨc oy, mɨɨd je mɨc'ajt huɨdibɨ Jesucristo je Nazaretpɨ yejcpy, je jäy huɨdibɨ miich ajcxy myajcruudzpejt, huɨdibɨ Dios yajjugypɨjc co y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yɨ Jesús jadu'n nipaady nej tüg tzaa oybɨ, huɨdibɨ ajcxy potzpɨdɨjc, ca' yajtúngɨxy co ytɨjccojcɨxy. Jesús cham tɨ paady mɨjtung ma Dios, jadu'n yɨ' ni paady nej tüg mɨj tzaa huɨdibɨ ytungbaatp ma poch ytaatz. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ca' jac ni pɨn huɨdibɨ jëbɨ xyajnïdzoocɨm ajt n'alma. Jesucristo yɨ' je' tügpajc huɨdibɨ Dios yejc ma jäy ya naaxhuiñ huɨdibɨ jëbɨ xyajnïdzoocɨm ajt n'alma. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Co je mɨjtungmɨɨdpɨ ajcxy ijxy mɨdoy jadu'n nej Pedro etz Juan ajcxy huinmɨc jotmɨc ycapxcɨxy, etz nejhuɨɨy co ca' ajcxy y'ixpɨcyjäyɨty, chi ajcxy ooy jɨhuɨy huinmay. Nañ yɨ' ijxcajp ajcxy co je' anajty huɨdibɨ ajcxy tɨ mɨɨd huɨdity Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Cha co yjactɨmjɨ́mɨty anajty je jäy huɨdibɨ anajty tɨ chögy ytɨnäy mɨɨd Pedro etz Juan, paady ajcxy ca'jajty nej mɨdziptzoonɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chi je tungmɨɨdpɨ ni'ane'mdɨy huen yajpɨdzɨmyii Pedro etz Juan ma je mayjäy anajty ñaymugyii, jɨgɨx ac jëyɨ tungmɨɨdpɨdɨjc ɨɨyöyaangɨxy capxyöyaangɨxy Pedro etz Juan ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chi ajcxy ymɨnañ: ―¿Ti cham nduunɨm mɨɨd yɨjiibɨ jäy ajcxy? Com tüg'ócɨy jäy huɨdibɨ tzɨnaayb ya Jerusalén ñejhuɨɨyb ajcxy co tɨ túngɨxy mɨjhuinma'ñ, e ca' huaad ɨɨch ajt nmɨnaanɨm co ca' yjanchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tzoc capx'adujcɨm co ca' huaad ajcxy jacnimɨydägɨpy Jesús jadachambɨ etz jacnɨcxpɨ xɨɨ tiempo. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chi ajcxy mɨjhuoy Pedro etz Juan, chi ajcxy nɨmay co ca' huaad ajcxy ni nej ocnimɨydaacnɨp, ni ca' jacyaj'ixpɨgɨpy mɨɨd Jesús yxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Huin'it Pedro etz Juan y'adzooy: ―Huinmaaygɨx miich ajcxy cɨ'm pen tɨy'ajt jada ma Dios co ɨɨch miich ajcxy ngapxycöbɨgɨpy jayɨjp, ca'ydɨ yɨ Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Com ɨɨch ajcxy ca' nni'amonaangɨxy jadu'n nej ɨɨch ajcxy tɨ n'ixy tɨ nmɨdoy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Huin'it je tungmɨɨdpɨ ajcxy adzɨgɨ'ñ mɨgapxy Pedro etz Juan, e najtzmadzɨɨy ajcxy. Ca' ajcxy mɨhuinma'ñybaty nej tzaachytunɨpy Pedro etz Juan. Com tüg'ócɨy jäy yjäymejchpy ycömaayb anajty yɨ Dios jadu'n nej anajty tɨ ytuñyii tɨ yjadyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Je jäy tecyma'tpɨ huɨdibɨ tzooc co Dios mɨjhuinma'ñ ytuñ, ymɨɨd anajty yjɨmɨjt huixchɨguïpx naxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chi Pedro etz Juan co yajnajtzmadzɨɨy, chi ajcxy ñɨcxy ma ymɨgügtɨjc anajty, yajmɨɨdmɨydactay tüg'ócɨy jadu'n nej teedy huindzɨn etz mɨjjäydɨjc anajty tɨ ñɨmáayɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Co jada ayuc ajcxy mɨdoy nidüg'ócɨy ajcxy tú'cɨy yjot yhuinma'ñ pɨdacy, chi ajcxy Dios mɨbɨjctzoy ymɨnañ ajcxy: ―Huindzɨn Dios, miich je' tɨ m'oyduñ je tzajp, je naaxhuiñybɨ, je mejy etz tüg'ócɨy tijaty. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Miich mɨɨd mEspíritu je David myajcapxy, e yɨ' jadu'n ymɨnañ: ¿Nej co jada naaxhuiñybɨ jäy chachhuaangɨxy chachjɨhuɨɨygɨxy, e yɨ jäy ajcxy huinmaaygɨxy huɨdibɨ ca' ytimytiijɨty? ");
INSERT INTO mcoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yɨ reydɨjc ya naaxhuiñybɨ mɨdziptzooñ ajcxy yɨ Dios. Etz je tungmɨɨdpɨ cajp cajp ñaymujcɨ ajcxy, mɨdziptzoñ ajcxy Huindzɨn Dios, etz mɨdziptzoñ ajcxy Cristo. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Com janch co je rey Herodes etz yɨ gobernador Poncio Pilato ñaymujcɨ ya ma jada cajp mɨɨd huɨdibɨ ca' yjudíojäyɨty ajcxy etz mɨɨd judíojäy ajcxy, mɨdziptzoñ ajcxy yɨ m'ung Jesús huɨdi anajty tɨ mhuin'ixy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yɨ' ajcxy tɨ cuydungɨxy tüg'ócɨy jadu'n nej miich, Huindzɨn Dios, tɨ myajnigödugɨ̈y jadu'n nej ytunɨɨyb yjadɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jadachambɨ Huindzɨn Dios, ix jadu'n nej yɨ tungmɨɨtpɨ xychachmɨjotmá'tcɨxyɨch. Mo' yɨ mdumbɨ ajcxy jotmɨc'ájtɨn, jɨgɨx m'ayuc ajcxy capxhuäcxɨpy amɨc jotmɨc, ");
INSERT INTO mcoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","e mɨɨd miich mmɨc'ájtɨn chögɨpy pa'mjäydɨjc, tunɨpy ajcxy tijaty ijxpejt etz mɨjhuinma'ñ mɨɨd yɨ m'ung Jesús yxɨɨ, huɨdibɨ mɨɨd huädz yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Co ajcxy mɨbɨjctzoday, chi je naax chuyuuy ma anajty ajcxy tügmucy yajpaatcɨxy, etz nidüg'ócɨy yɨ' ajcxy ymɨc'ajt mooyɨ je Espíritu Santo, e yɨ Dios y'ayuc capxhuäcxcɨxy anajty amɨc jotmɨc. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Je mayjäy huɨdibɨ anajty tɨ mɨbɨcy, tú'cɨy ajcxy yjot yhuinma'ñ. Ni pɨn anajty ycamɨna'ñ co naydüg jë'adyii. Hue' anajty ymɨnaangɨxy co tú'cɨy jë'ájtɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Je majmetzpɨ Jesús y'ayuccapxhuäcxpɨ amɨc jotmɨc capxhuäcxy je tɨy'ajt jadu'n nej je Huindzɨn Jesús yjugypɨjcy co y'o'cy. E mɨj ajcxy Dios ypubejtɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma je' ajcxy ca' ni ti yajmayjajtcɨxy, com tüg'ócɨy tijaty anajty ajcxy ymɨɨd ñaax o ytɨjc ytoocpy anajty ajcxy, e yejccɨxy anajty meeñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Chi je meeñ yajcɨ̈dɨgɨɨygɨxy je apóstoles ajcxy e yɨ' ajcxy moy nidüg nidüg pɨnjaty yajmayjajtp. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jɨm anajty mɨɨd je' ajcxy tüg levita jäy huɨdi anajty yxɨɨ José, huɨdibɨ ma'xung'ajt ma yɨ ñaaxjot mejy agujc huɨdibɨ yxɨɨ Chipre, je huɨdibɨ je majmetzpɨ Jesús y'ayuccapxhuäcxpɨ, yxɨɨ moy Bernabé, huɨdibɨ huimbɨdzɨm je yajjotcujc'ajtpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Je Bernabé tocy ytundac huɨdibɨ anajty ymɨɨd, e chi mɨmiiñ je meeñ, e yajcɨ̈dɨgɨy je apóstoles ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chi jadüg yëydɨjc, huɨdi anajty yxɨɨ Ananías, mɨɨd ytöxyɨjc, Safira, toogy ajcxy tüg it ytundac. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías ñayyajnihuɨ'mɨ jac'anaxy je meeñ, e yajninɨcxy Jesús y'apóstoles ajcxy je jac-hueenɨp, jadu'n nej jɨhuɨ̈y yejctay tüg'ócɨy, etz yɨ' ytöxyɨjc ñejhuɨɨyb anajty. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chi Pedro nɨmay Ananías: ―Ananías, ¿nej co myajtuñ je mujcu' yhuinma'ñ, e mhuin'ɨɨna'ñ je Espíritu Santo, e tɨ mbugoñ jac'anaxypɨ meeñ nej tɨ tzoo'adyii yɨ pɨdägy tɨɨbɨ mdoogy? ");
INSERT INTO mcoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Nej ca' anajty yɨ' miich mdundac'adyii? E co tɨ mdoogy, ¿nej ca' anajty je' miich mmeeñ'adyii? ¿Nej co jadu'n tɨ mdundɨgooy? Dios tɨ mhuin'ɨɨñ, canan jäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Co jadu'n mɨdoy, jɨ́mɨyɨ Ananías ycɨday, e chi y'o'cy. E tüg'ócɨy jäy ajcxy huɨdijaty nejhuɨɨy, ooy ajcxy chɨgɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Huin'it ymiiñ jadyii yujcyeecpɨdɨjc, chi ajcxy mo'ñ Ananías ñinïcx, e oy ajcxy yajnaaxtɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Codugɨɨg horɨ naxy, oy ytɨgɨ̈y je Ananías ytöxyɨjc, e ni ca' nejhuɨ̈y anajty ti tɨ ytuñyii tɨ yjadyii je ñäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro y'amɨdoohuɨ: ―Yajnɨmaaygɨch, ¿nej janch jadu'n tɨ mdooccɨxy yɨ mdundac jadu'n nej tɨ mgapxcɨxy? Chi je töxyjäy y'adzooy: ―Janch jadu'n tɨ ndoogyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chi Pedro ymɨnañ: ―¿Nej co tɨ mnaygápxɨgɨxy mhuin'ɨɨna'ñ yɨ Espíritu Santo? Cha ma tɨjc'aguu je jäy ajcxy ytɨnäy huɨdi oy tɨ yajnaaxtɨgɨ̈y mñäy, e jadachambɨ miich ajcxy xyajnɨcxaam nañ jadu'n. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tɨm huin'itɨy Ananías ytöxɨjc ycɨday, e chi y'o'cy. E chi oy ycɨdägy ma Pedro ytecymɨjc. Co je yujcyeecpɨdɨjc ytɨgɨɨy, chi ajcxy je' paaty ögy. Chi ajcxy yajpɨdzɨmy etz oy yajnaaxtɨgɨ̈y ma ñäy ymɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chi tüg'ócɨy je jäy ajcxy huɨdibɨ Jesús mɨbɨjcp etz tüg'ócɨy huɨdibɨ mɨdou jada nej tɨ yjadyii tɨ ytunyii, chi ajcxy ooy chɨgɨ̈y. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Je majmetzpɨ Jesús y'ayuccapxhuäcxpɨ ooy anajty ajcxy Dios ymɨc'ajt yajniguëxɨ̈cɨ etz ijxpejt yejccɨxy ma yɨ jäy ajcxy. E tüg'ócɨy jäy ajcxy huɨdibɨ Jesús mɨbɨjc jabom jabom anajty ñayyöymújcɨgɨxy ma Dios ytɨjc huinduu huɨdibɨ yxɨɨ Salomón. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ca' jac ni pɨn anajty mɨjnɨcxpeda'ñ mɨjyöypeda'ñ je' ajcxy. E je jäy ajcxy yjacyajmɨj'ajtpy huɨdi Jesús anajty ooy mɨbɨjccɨxyp. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mayjäy oy mɨbɨjcnɨ Jesús y'ayuc, yëydɨjctɨjc etz töxyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Etz ixtɨ pa'mjäydɨjc anajty ajcxy yajnɨcxy mɨjtügujc cɨjx'aam pɨdaaccɨxy, jɨgɨx co Pedro ñaxɨpy jɨm ycadɨmjecyɨty co nɨcxy y'aa'ap yjäty ma je pa'mjäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nañ jadu'n mayjäy chooñ anajty huɨdijaty huingon ycajp, ymiingɨxy Jerusalén, mɨɨdmiingɨxy pa'mjäy, etz huɨdibɨ ca'oybɨ mɨɨd ma yjot yhuinma'ñ, e tüg'ócɨy yajtzooctaayb anajty ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Huin'it je teedy mɨjtungmɨɨdpɨ etz huɨdibɨ saduceo ijxpɨ́jcɨn ymɨjpɨdacp ooy ajcxy yajca'oy'ijxy, ");
INSERT INTO mcoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","e co ajcxy majch je apóstoles ajcxy, chi ajcxy pɨdacy ma je mɨjpujxtɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Chi Huindzɨn Dios tüg y'ángel je huin'it coodz yaj'ahuaach je pujxtɨjc aguu, yajpɨdzɨmy ajcxy, chi ajcxy nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Nɨ́cxcɨx, tɨnay'ahuɨɨygɨx tzajtɨgoty, yajmɨɨdmɨydaaccɨx yɨ mayjäy ajcxy Jesucristo ytɨy'ajt nej jëbɨ jäy ajcxy paadɨpy jugy'ájtɨn jemybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Co jadu'n mɨdoy, chi com jabom ytɨgɨɨy ajcxy jopyñɨ tzajtɨgoty. Jiiby je' ajcxy anajty ñiyaj'ixpɨjcco'nɨ. Chi je teedy mɨjtungmɨɨdpɨ etz jacpɨnjaty mɨɨd, chi ajcxy capxyñiguejxy yɨ judíojäy ymɨjjäydɨjc etz ixpɨcytɨjc co huen junta jadyii. Chi ajcxy capxyñiguejxy huen nɨcxy yajpɨdzɨmyii jiiby pujxtɨgoty yɨ apóstoles ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Co je policías ajcxy ymejch ma je pujxtɨjc, ca' ajcxy paady je apóstoles ajcxy. Chi ajcxy huimbijtnɨ mɨɨd tɨy'ajt, ");
INSERT INTO mcoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","chi ajcxy nɨmay: ―Hue' ɨɨch ajcxy tɨ nbaadcɨxy yɨ pujxtɨjc aducy, etz je soldadtɨjc jɨm tɨjc aguuy yjaccuend'ajtcɨxy. Chi co ɨɨch ajcxy nyaj'ahuäch je pujxtɨjc, ca' ɨɨch ajcxy ni pɨn tɨ nbaatyɨch jiiby pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Co jadu'n ajcxy mɨdoy, je teedy mɨjtungmɨɨdpɨ etz je soldado huindzɨn, etz jacjadyii teedy huindzɨn ajcxy, chi ajcxy ooy huinmay nej jada y'occogɨxɨ̈huɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Huin'it tüg jäy miiñ huɨdibɨ nɨmaayɨ ajcxy: ―Je jäy huɨdibɨ miich ajcxy mbɨdac pujxtɨgoty, chɨm je' ajcxy tzajtɨgoty yaj'ixpɨjccɨxy yɨ mayjäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chi je soldado huindzɨn mɨɨd soldadtɨjc ñɨcxy ma yɨ apóstoles ajcxy jäy yaj'ixpɨjccɨxy, chi ajcxy yajnɨcxy oy'amy, com tzɨgɨɨyb anajty ajcxy co je mayjäy chaagädzɨɨyb. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Co ajcxy yajmiiñ, chi ajcxy pɨdacy ma je maytungmɨɨdpɨ yhuinduu. Chi je teedy mɨjtungmɨɨdpɨ je apóstoles ajcxy nɨmay: ");
INSERT INTO mcoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ɨɨch ajcxy tɨ ngapx'aducy co ca' huaad m'ocjacyaj'ixpɨ́jccɨxnɨ ma Jesús yxɨɨ. E ¿ti tɨ mdungɨxy? Tɨ myajhuäcxtaaygɨxy yɨ m'ixpɨ́jcɨn ma Jerusaléngajp, e ɨɨch ajcxy miich pocy xyjátyɨm yajmɨhuɨ'mam co Jesús y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chi Pedro etz jacjadyii apóstoles ajcxy y'adzooy: ―Copɨcy ɨɨch ajcxy ngapxycöbɨgɨpyɨch yɨ Dios jayɨjp ca'ydɨ jäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Je Dios huɨdibɨ ɨɨch ajt nmɨj'ap nmɨjteedy y'ojadajt, yɨ' yajjugypɨjc je Jesús huɨdibɨ miich ajcxy myaj'öc cruudzcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Je Dios Teedy jadachambɨ hue' Jesús mɨɨdɨty aa'oy'amy jiiby tzajpjoty, e tɨ pɨdägy ane'mbɨ etz yajnïdzoocpɨ jɨgɨx yɨ judío jäy ajcxy yjothuimbidɨpy e yajhuinmeecxɨpy ajcxy ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɨɨch ajcxy tɨy'ajt nyejcpy mɨɨd jada ycɨxpɨ, etz nañ jadu'n je Espíritu Santo huɨdibɨ Dios ymooyb pɨnjaty capxymɨdoohuɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Co je jäy ajcxy jadu'n mɨdoy, chi ajcxy ooy yjotmätcoty, chi ajcxy jayaj'öga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Huin'it ytɨnayɨ̈gy ma je naymujctac tüg fariseojäy, hue' anajty yxɨɨ Gamaliel, hue' je' anajty Moisés yley ñihuindzɨn'ájtɨp. E jäy ajcxy ooy anajty yajmɨj'ajtcɨxy je Gamaliel. Chi je' ni'ane'mdɨɨy co huen yajpɨdzɨmyii tzojcyɨ jiiby tɨba'y je apóstoles ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chi Gamaliel nɨmay yɨ tungmɨɨdpɨ ajcxy: ―Judío yëydɨjctɨjc ajcxy, íxcɨm ti mdungɨxy mɨɨd jada jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jäymetz miich ajcxy co jecy'ajty je Teudas ypɨdɨ̈gy ymɨnañ co je' ymɨjɨty yjanchɨty, e chi ypanɨcxɨ oy nimɨdaax mɨgo'pxtɨ yëydɨjc. Chi ajcxy yaj'o'cɨ, chi tüg'ócɨy huɨdibɨ anajty tɨ ypanɨcxyii yöyhuäcxtay, e jadu'ñyɨ je' ajcxy ñitɨgoyday. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jacnamnɨ je huin'it xɨɨ mɨna cajpjäy anajty ñecypejtcɨxy, ypɨdɨ̈gy Judas huɨdibɨ tzon Galilea. Mayjäy ypanɨcxɨ; nañ jadu'n ajcxy yaj'o'cy, e tüg'ócɨy jäy huɨdibɨ panɨcxy jadu'ñyɨ ajcxy yöyhuäcxtay. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Paady ɨɨch miich ajcxy jadu'n nɨmaaygɨxy, ixmajtzcɨx yɨ apóstoles ajcxy, e ca' mmɨjyöybejtcɨxy. Penɨ jäy yɨ y'ayuc ytɨy'ajt huɨdibɨ ajcxy ymɨɨd, cɨxɨp tɨgoyɨp yɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pen Dios y'ayuc ytɨy'ajt yɨ' ajcxy ymɨɨd, ca' ajcxy mjadɨpy nej myajcödɨgóoygɨxyɨpy. Jaty nayguend'ájtɨgɨxy, ca' jecyɨty co Dios anajty mɨɨd mdziptungɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nidüg'ócɨy ajcxy jäygɨdacy Gamaliel ycapxhuíjɨn. Huin'it ajcxy mɨjhuoy yɨ apóstoles ajcxy. Chi ajcxy tzaachytuñ, chi ajcxy cɨ̈'ajty, etz capx'adujcy co ca' huaad Jesús y'ayuc jaccapxhuäcxɨp. Huin'it ajcxy najtzmadzɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Je apóstoles ajcxy ypɨdzɨmy ajcxy ma tungmɨɨdpɨ ajcxy yhuinduu ooy yjotcujcɨty co Dios jadu'n tɨ aa'ɨxɨ̈y co huen tzaachytuñyii mɨɨd Jesús yxɨɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","E ooy ajcxy yaj'íxpɨjccɨxy etz nimɨydaaccɨxy Jesucristo jabom jabom jadu'n tzajtɨgoty nañ jadu'n majaty tɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Je huin'it xɨɨ ajcxy huɨdibɨ ixpɨjcp Jesús y'ayuc nïgɨ anajty ñimayɨy'adɨɨtzcɨxy. E huɨdibɨ anajty capxp griego ayuc ytɨgɨɨy nayñigápxɨp mɨɨd huɨdibɨ judío y'ayuc capxp. Ymɨnaangɨxy co yɨ griegojäy co'ögy töxyjädɨjc, ca' anajty ajcxy paady quipxyjaty mɨɨd je judíojäy co'ögy töxyjäydɨjc caayɨn uucɨn jabom jabom. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Huin'it yɨ majmetzpɨ apóstoles ajcxy yajnaymujctaayɨ je jäy huɨdibɨ Jesús mɨbɨjcp, chi ajcxy ymɨnañ: ―Ca' huaad ɨɨch ajcxy Dios y'ayuccapxhuäcxɨn n'ijxmajch, e nɨcxyɨch caayɨn uucɨn yajhuäcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Paady miich ajcxy mɨgügtɨjc nayhuin'íjxɨgɨx huɨxtujc yëydɨjctɨjc huɨdibɨ oy yajmɨj'ajtnɨ Dios, huɨdibɨ huädz oy yhuinma'ñ ymɨɨd, huɨdibɨ je Dios yjɨhuɨ'ñ ymɨc'ajt mɨɨd, e huen ajcxy tung'adɨɨb jada tung. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ɨɨch ajcxy njacmɨbɨjctzohuamy Dios, etz ɨɨch ajcxy njacyaj'ixpɨgamy Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tüg'ócɨy ajcxy jäygɨdacy je' ayuc. Chi je mayjäy huin'ijxy Esteban huɨdibɨ ymɨɨd ooy ymɨbɨ́jcɨn, etz ymɨɨd Espírito Santo. Nañ huin'ijxy ajcxy Felipe, Prócoro, Nicanor, Timón, Parmenas, etz Nicolás. Nicolás ca' je' anajty yjudíojäyɨty. Hue' je' anajty chooñ jɨm Antioquía, jécyɨp anajty jɨjptɨgɨyɨɨyñɨ judíojäy ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chi ajcxy yajnɨcxy je jäy ma je apóstoles ajcxy. Chi ajcxy je apóstoles Dios mɨbɨjctzoy e cɨ̈nïxajy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Je Huindzɨn Jesús y'ayuc nïgɨ anajty jäy tzachnejhuɨɨyñɨ. E je mɨbɨjcpɨdɨjc nïgɨ anajty ajcxy chachnimayɨɨyñɨ jɨm Jerusalén, ixtɨ may judío teedy ajcxy ymɨbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Je Esteban ymɨɨd anajty Dios ymɨc'ajt etz y'oy'ajt e oy mɨjhuinma'ñ tuuñ, etz yejcy ijxpejt ma jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Huin'it xɨɨ nijëjɨty ixpɨcytɨjc ooy ñay'ijxquípxɨgɨxy y'ixpɨjcɨn mɨɨd Esteban jɨm ma judíojäy ajcxy ñaymujctac huɨdi anajty yxɨɨ Libertados. E jɨm anajty Cirene jäy, Alejandría jäy, Cilicia jäy, etz huɨdibɨ tzomb jɨm Asia ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ca' ajcxy mɨmadacy Esteban com hue' je' anajty ycapxy mɨɨd yhuijy'ajt ycujc'ajt huɨdibɨ je Espíritu Santo anajty mooyɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chi Esteban ymɨdzip ajcxy mujuy jäy huɨdibɨ jëbɨ nïhuambety Esteban, co tɨ anajty ooy ycapxtɨgooy etz ni'ojɨ̈y Moisés etz Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jadu'n ajcxy yajyuumɨ̈gy yaj'oxɨ̈gy yɨ jäy mɨjjäydɨjc, etz huɨdibɨ ajcxy yaj'ixpɨjcp Moisés yley. Chi ajcxy mɨmadacy majch ajcxy Esteban, yajnɨcxy ajcxy ma je judíojäy ymɨjtungmɨɨdpɨ etz ixpɨcytɨjc ñaymújcɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chi ajcxy ixtaayɨ jäy huɨdibɨ nïhuambedɨɨb, chi ajcxy ymɨnañ: ―Jada Esteban jɨbɨc nigapxy yɨ Dios ytɨjc etz Moisés ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tɨ ɨɨch ajcxy mɨdoy co ymɨna'ñ co Jesús je Nazaretpɨ yjidamy je Dios ytɨjc, e yajtɨgadza'ñ Dios ytɨy'ajt jadu'n nej Moisés ajt xymooyɨm. ");
INSERT INTO mcoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Huin'it je judíojäy tungmɨɨdpɨ e tüg'ócɨy jäy nej anajty ajcxy jɨm ɨñaaygɨxy huindɨcxpejty ajcxy Esteban. E chi ajcxy ijxɨ yhuiñyjɨjp jadu'n anajty quëxɨ̈gy nej y'ángel yhuiñyjɨjp. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Huin'it je teedy mɨjtungmɨɨdpɨ yaj'amɨdooy Esteban: ―¿Nej janch jadajɨ? ");
INSERT INTO mcoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Chi Esteban y'adzooy: ―Mɨgügtɨjc ajcxy etz mɨjjäydɨjc ocmɨdoogɨx. Ɨɨch ajt nDios mɨjpɨ janchypɨ nayquëxɨ̈cɨ ma ɨɨch ajt nmɨj'ap nmɨjteedy Abraham jecy'ajty co anajty jɨm ity Mesopotamia ñaaxjot, ca'nɨ anajty chɨnaydacpɨcy jɨm Harán. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chi Abraham Dios ñɨmaayɨ: “Ixmatz mnaax mgajp etz tüg'ócɨy m'amɨgügtɨjc, e nɨcx ma yɨ naaxjot huɨdibɨ myajnïxɨ̈huamyb.” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chi Abraham chooñ ma yɨ Caldea ñaaxjot, e nɨcxy tzɨnaydacpɨjcpɨ jɨm Harán. Co yteedy oy y'o'cnɨ, chi Dios Abraham yajmiiñ ma jada naaxjot ma miich ajcxy cham mdzɨnäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E ca' Dios moy Abraham jada naaxjot ya, ni ca' ma yhuäcxtägɨpy. Hue' je' janchtɨy yaj'ahuanɨɨy co möhuaanɨɨy y'ap y'oc, e co anajty je' ajcxy jëdɨɨb. Oyñɨ anajty Abraham ca' y'ung mɨɨdɨty co Dios ymɨgapxɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nɨmaayɨ Dios co y'ap y'oc y'adzɨnähuɨpy ajcxy ma huingjäy ñaaxjot, etz chi ajcxy ytumbɨ'adɨɨyb etz chaachytunɨɨyb mɨdaax mɨgo'px jɨmɨjt. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nañ jadu'n Dios nɨmay Abraham: “Ndzaachytunɨpyɨch je naax cajp ma yɨ m'ap m'oc anajty ytumbɨ'adyii. Chi choonɨp ajcxy jɨm, e chi xymɨdunɨpyɨch ma jadayaabɨ it.” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios ytuun tüg capxytuunɨn mɨɨd Abraham, co huen ajcxy yajtɨy'ajttɨ̈huɨp. Paady co Abraham y'ung Isaac yma'xung'ajty coductujc xɨɨ ajcxy oy tɨy'ajttɨ̈y. Nañ jadu'n Isaac ymang Jacob, e Jacob yɨ ymang nimajmetzpɨ ajcxy, huɨdibɨ ajcxy ñi'ap'ajty yɨ nimajmetzpɨcypɨ Israel ycajp. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Chi Esteban yjacmɨnañ: ―Je' ajcxy Jacob ymang, ɨɨch ajt nmɨj'ap nmɨjteedy, ymɨ'ijxtɨnaayb anajty ajcxy y'uch José. Chi ajcxy José toocy, chi je' yajnɨcxɨ jɨm Egipto, per Dios mɨɨd anajty y'ity José, ");
INSERT INTO mcoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","etz nihuaañ yajtzoocy ma ayo'n jotmay. Chi Dios moy ixpɨ́jcɨn jɨgɨx cömay ypɨdzɨmɨpy ma Faraón, je Egipto jäy yrey. Chi je rey José tung moy huen ane'my je Egipto naaxjot etz ane'mɨpy je rey ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Huin'it xɨɨ ymiiñ mɨjyuu mɨj'ayo'n jɨm Egipto etz jɨm Canaán ñaaxjot. Je huin'it xɨɨ ɨɨch ajt nmɨj'ap nmɨjteedy ca' anajty ajcxy paady ti ycayɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Co Jacob oy nejhuɨ̈y co jɨm Egipto yajpaady jɨm trigo, chi jɨm quejxy ymang ajcxy trigo juuybɨ. Je' ajcxy huɨdibɨ ɨɨch ajt nmɨj'ap'ajtɨm nmɨjteedy'ajtɨm. Chi ajcxy y'oy tügtecy trigo juuyb. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Je mɨmejtz'ocpɨ co ajcxy oy trigo juy, huin'it José ñayñigapxɨ ma y'ajch ajcxy. E chi je rey nejhuɨy pɨnjäy je' anajty je José. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chi José capxyñiguejxy huen cɨdaaccɨxy jɨm Egipto yɨ' yteedy Jacob mɨɨd tüg'ócɨy yjuugy ymɨgüg. Hue' anajty ajcxy ñaybaattáayɨgɨxy nidugɨ'px majmocx jäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","E jadu'n yjajty co Jacobo oy chɨnaydacpɨcy jɨm Egipto. Jɨm oy comjecy y'o'cnɨ. Nañ jadu'n jɨm ajcxy y'o'cy may ɨɨch ajt nmɨj'ap nmɨjteedy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","E chi Jacob yjuugy ymɨgüg com jecy yajpɨdzɨmy Jacob ypajc ma ñaaxtɨgɨ̈y, e chi ajcxy yajnɨcxy jɨm Siquem, oy pɨdaaccɨxy ma je o'cpɨ jut huɨdibɨ Abraham anajty tɨ juy meeñygɨ́xy ma Hamor ymang jɨm Siquem. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Chi Esteban yjacmɨnañ: ―Ytɨmypadaanɨpy anajty tiempo nej anajty Dios tɨ yaj'ahuanɨ̈y Abraham. Tɨ anajty yɨ judíojäy ooy ymayɨɨyñɨ jɨm Egipto. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chi oy jadüg rey ytɨgɨɨy ane'mbɨ huɨdibɨ ca' ixy'adyii José. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Je rey yhuin'ɨɨñ ɨɨch ajt nmɨj'ap nmɨjteedy, e oy ajcxy chaachytuun. E chi ane'my co huen y'ung ajcxy nïguecytaaygɨxy huɨdibɨ anajty ajcxy ma'xung'ajtp, jɨgɨx y'ó'ccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Huin'it tiempo oy yma'xung'ajty Moisés, je huɨdibɨ ooy Dios jäygɨdacy. Chi Moisés ytaj yteedy tugɨɨg po' yajyeecɨ ma ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Co ajcxy yajnïgueecɨ, chi je rey ñɨɨx je' agondɨgɨɨy, e yajyeegy jadu'n nej ycɨ'm'ung. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Paady Moisés ixpɨjcy tüg'ócɨy jadu'n nej Egipto jäy anajty ajcxy y'ixpɨcyɨty, e ooy ymadacy mɨɨd y'ayuc etz mɨɨd ytung. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Co Moisés anajty mɨɨdɨty huixchɨguïpx jɨmɨjt, chi pɨdacy yhuinma'ñ co nɨcxy ixa'ñ je' y'amɨgügtɨjc je Israel y'ap y'oc. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chi Moisés ijxy co tüg egipciojäy chaachytuñyii tüg je' y'amɨgüg. Chi Moisés yaj'o'cy je egipciojäy, yaj'ahuimbijty nej anajty y'amɨgüg yajtzaachytuñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hue' Moisés tijy co je' y'amɨgügtɨjc ajcxy huen nejhuɨ̈y huinjɨhuɨ̈y co Dios nihua'naanɨp ma ymɨdzip mɨɨd Moisés ycɨxpɨ. Chi ajcxy ca' huinjɨhuɨɨy co Moisés nihua'naanɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Com jabom Moisés paty mejtz Israel jäy chachtziptungɨxy. Chi Moisés jayajxemaañ je tzip, chi nɨmay: “Miich ajcxy nay'amɨgüg'ajtɨp, ¿nej co mdziptungɨxy miich ajcxy miñ xyɨpy?” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Je huɨdibɨ anajty ymɨgüg tzaachytuumb huin'it najtztijɨɨy Moisés, nɨmay: “¿Pɨn tɨ xypɨdägy huindzɨn etz tɨydumbɨ ma ɨɨch ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Nej xyaj'ögaamɨch jadu'n nej axɨy myaj'o'cy yɨ egipciojäy?” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Co Moisés jadu'n mɨdoy, chi yqueegy, ñɨcxy jɨm ma Madián naaxjot. Moisés jecy y'adzɨnaay jɨm Madián naaxjot, e jɨm oy ypɨcy. Chi ytöxyɨjc paty metz ymang. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Huixchɨguïpx jɨmɨjt naxy, huin'it jɨm adügtuum ma je cop huɨdibɨ yxɨɨ Sinaí, ñayguëxɨ̈cɨ tüg ángel jɨnjoty ma tüg quipymang huɨdibɨ anajty tzachtooyb. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chi Moisés ooy jɨhuɨɨy huinmaay mɨɨd je' ycɨxpɨ huɨdibɨ anajty y'ijxyp. Co oy mɨhuingoñ, chi mɨdoy co je Huindzɨn Dios ñɨmäyii: ");
INSERT INTO mcoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ɨɨch Dios huɨdibɨ mmɨj'ap mmɨjteedy ajcxy Abraham, Isaac etz Jacobo Dios'ajtpy.” Chi Moisés chɨyuygoty, ca' anajty ocjac-huindɨcxpedaanɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","E je Huindzɨn Dios nɨmaayɨ: “Jen mgɨ̈g, com je it ma miich mdɨnäy, Dios yɨ' y'it. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɨɨch tɨ n'ixyɨch njäyɨch nej tzaachypɨ paatcɨxy jɨm Egipto. Tɨ nmɨdooyɨch co yɨ'ajcxy yäxy ytɨnäy mɨɨd je tzaachypɨ ycɨxpɨ. Tɨ ngɨdägyɨch co ajcxy ngohuaanɨp. Ɨɨch miich nguexamyb jɨm Egipto ma yɨ Israel jäy ajcxy.” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Chi Esteban yjacmɨnañ: ―Co Moisés oga'n ñɨcxy ma ɨɨch ajt nmɨj'ap nmɨjteedy ca' ajcxy cöbɨjcy huen y'ane'mɨɨyb, chi ajcxy ymɨnañ: “¿Pɨn tɨ xyñɨmäy co ɨɨch miich ajcxy nhuindzɨn'adɨɨyb?” Co mɨmetz'ocpɨ Moisés ñɨcxy ma yɨ Israel jäy, je taabɨ anajty je ángel tɨ ymɨgapxyii jɨnye'ñ agujc, chi ajcxy cöbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Je Moisés je' yajpɨdzɨm ɨɨch ajt nmɨj'ap nmɨjteedy jecy'ajty jɨm Egipto. Moisés ytuun oy mɨjhuinma'ñ etz ijxpejt huixchɨguïpx jɨmɨjt jɨm Egipto, jɨm ma tzaptz mejy, etz jɨm ma mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Je Moisés huɨdibɨ jecy'ajty nɨmay je Israel jäy: “Dios y'ijxtɨhuɨpy tüg jäy ma miich ajcxy m'ap m'oc huɨdibɨ najtzcapxɨ̈huɨpy yɨ' y'ayuc, jadu'n nej tɨ xy'ijxtɨɨyɨch ma miich ajcxy. M'amɨdo'ijtɨp ajcxy yɨ' y'ayuc.” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Je Moisés jɨm je' anajty mɨjtɨgɨ̈duum mɨɨd je mayjäy. Chi jɨm je Dios y'ángel mɨɨd mɨydacy ma je cop huɨdi yxɨɨ Sinaí, etz Moisés yajnajx Dios y'ayuc ma ɨɨch ajt nmɨj'ap nmɨjteedy. Moisés ycöbɨjc Dios y'ayuc huɨdibɨ jugy'ájtɨn huinɨxɨɨbɨ mɨɨd, etz jayhuɨ'my mɨɨd ɨɨch ajt ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Chi ɨɨch ajt nmɨj'ap nmɨjteedy ajcxy jecy'ajtpy ca' anajty ajcxy capxcöbɨgaangɨxy Moisés, ca' anajty cöbɨjccɨxy je' y'ané'mɨn, chachhuimbidaangɨxy jɨm Egipto. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chi ajcxy Aarón nɨmay: “Ndzojcypɨch ajcxy co miich oydun tüg Dios huɨdibɨ ɨɨch ajcxy xyhuinhuoohuɨp, com ca' nnejhuɨɨyɨm ti jada' tɨ yjadyii je Moisés huɨdibɨ ajt xyajtzoonɨm Egipto ñaaxjot.” ");
INSERT INTO mcoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chi oyduñ ajcxy tüg huajmang. Chi huindzɨgɨɨy ajcxy je huajmang huɨdibɨ anajty tɨ yajcojcɨxy, e ooy ajcxy mɨjotcujc'ajty huɨdibɨ cɨ'm anajty tɨ yajcojy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Huin'it xɨɨ ajcxy Dios y'ixmajtzɨ, huen ajcxy ojadaty yɨ xɨɨ, yɨ po' etz madza'. Com jadu'n Dios y'ayuc cojaaybɨ cojaay co Dios jadu'n ymɨnañ: Israel jäy ajcxy canan ɨɨch je' huɨdibɨ tɨ mhuindzɨgɨɨygɨxy jɨm mɨjtɨgɨ̈duum huixchɨguïpx jɨmɨjt. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tɨ mgɨynɨ́cxcɨxy Moloc ytɨjc etz yɨ Renfán ymadza', tzadzech, quipychech etz oorɨ oyduñ huɨdibɨ miich ajcxy cɨ'm myajcoj huɨdibɨ anajty ajcxy m'ojadadamy. Paady ɨɨch miich ajcxy nyajpɨdzɨmaangɨxy ma yɨ mnaaxjot, e nguexaangɨxy jɨguem jɨm Babilonia nïnaxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Chi Esteban yjacmɨnañ: ―Jɨm mɨjtɨgɨ̈duum ɨɨch ajt nmɨj'ap nmɨjteedy ymɨɨd anajty cochactɨjc ma anajty ajcxy Dios huindzɨgɨ̈y. Jiiby anajty ajcxy yujccɨ̈y je tzaa ma Dios ytɨy'ajt ycojaayɨty. Je cochactɨjc ajcxy ycoj jadu'n nej anajty tɨ yaj'ane'myii Moisés, e nej anajty yajni'ixɨ̈yii nej tunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɨɨch ajt nmɨj'ap nmɨjteedy mɨhuɨ'm je cochactɨjc, e ɨɨch ajt nmɨj'ap nmɨjteedy huɨdibɨ miiñ ma jada naaxjot mɨɨd Josué, chi mɨmiiñ ajcxy je cochactɨjc je taab ajcxy mɨmadacy je ymɨdzip canaag'agajp. Dios yajpɨdzɨm je' ajcxy ymɨdzip ma je naaxjot, jɨgɨx yajcɨ̈dɨgɨ̈huɨp ɨɨch ajt nmɨj'ap nmɨjteedy. Yajtuuñ ajcxy je cochactɨjc, ixtɨ coonɨ David ytɨgɨɨy ane'mbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios yjäygɨdaac je rey David, e David yjacoja'ñ anajty tüg tɨjc oyduñ ma jëbɨ yaj'ojadaty yajhuindzɨgɨɨy Dios, je Dios huɨdi Jacob mɨjpɨdac jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per Salomón je' oy cojy Dios ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Oy yɨ Dios tzajpjotypɨ ca' chɨnäy ma yɨ tɨjc tɨɨbɨ jäy cojy. Jadu'n nej je Dios y'ayucnajtzcapxɨɨybɨ jecy'ajty jaybety co Dios jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Je tzajp hue' je' ɨɨch n'ane'mdac, jada naaxhuiñybɨ ɨɨch ndecypocxtac. ¿Ti tɨjc ɨɨch miich ajcxy xycojaanɨp? ¿Ma je it huɨdibɨ it ma ɨɨch jëbɨ nbocxy? ");
INSERT INTO mcoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Nej cay ɨɨch tɨ n'oydundäy tüg'ócɨy? ");
INSERT INTO mcoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Miich ajcxy ooy mjotjuuñɨty, ca' mgapxymɨdoy Dios. Jadu'n Esteban yjacmɨnaañ: ―Jadu'n miich ajcxy mjot mhuinma'ñ mɨɨdɨty jadu'n nej jäy ajcxy huɨdibɨ ca' Dios ytɨy'ajt nejhuɨɨyɨ. Miich ajcxy játyɨm mɨdzip'ajtpy je Espíritu Santo. Mdügɨɨyb ajcxy mɨɨd mmɨj'ap mmɨjteedy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Miich ajcxy mmɨj'ap mmɨjteedy chaachytuun tüg'ócɨy Dios y'ayucnajtzcapxɨɨybɨ. Yɨ' ajcxy yaj'o'c Dios y'ayucnajtzcapxɨɨybɨ huɨdibɨ jayɨjp'aty najtzcapxɨɨy co ymina'ñ tüg jäy huɨdibɨ tudägyɨp. E co je tudägy jäy ymiiñ, chi miich ajcxy agojɨɨx myaj'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Je Dios y'ángel miich ajcxy xymooy je Dios ytɨy'ajt, e ca' ajcxy mgöbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Co je mayjäy mɨdoy jadu'n nej Esteban ymɨnañ, chi ajcxy mɨjotmätcoty Esteban, chi ytɨgɨɨy ajcxy tɨɨtzmucxpɨ tɨɨtzqueetpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","E chi je Esteban jɨhuɨy je Espíritu Santo ma yjot yhuinma'ñ, chi chajp'ijxy, e ijxy yɨ Dios y'oy'ájtɨn etz ijxy Jesús ytɨnäy a'oy'amy ma Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chi Esteban nɨmay je mayjäy: ―¡Ijxcɨx! N'ijxypɨch yɨ tzajp ahuädz, e n'ijxypɨch je jäy huɨdibɨ tzoon tzajpjoty ytɨnäy a'oy'amy ma Dios Teedy. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","E chi je mayjäy ajcxy ytätz'ac amo'cxy, chi ajcxy ytɨgɨɨy huambɨ jɨhuɨɨybɨ, e chi ajcxy nimujcy yajmujcy Esteban. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Chi ajcxy yajpɨdzɨmy Esteban cajppa', je' oy cögätzcɨxy. Je tɨy'ajt yejcpɨ huɨdibɨ jadu'n ɨdɨɨtz, chi yjocxhuit ajcxy yajmɨhuɨ'my tüg yeeg'anäg huɨdibɨ anajty yxɨɨ Saulo. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jɨm anajty ajcxy Esteban tzachcätzcɨxy. Chi Esteban Dios mɨbɨjctzoy, ymɨnañ: ―Huindzɨn Jesús, cöbɨ́jcɨgɨch n'alma. ");
INSERT INTO mcoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Huin'it ycoxtɨnay'ahuɨɨy, e chi yaaxqueegy mɨc ymɨnañ: ―Huindzɨn, ca' mbocy ixɨpy nej ajcxy xytuñɨch. Co jadu'n Esteban ymɨnanday, chi oy y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo ytuun quipxycapxy mɨɨd huɨdibɨ ajcxy yaj'o'c Esteban. Huin'it xɨɨ yaj'ixhuɨdijt yajpahuɨdijt pɨnjaty anajty Jesús mɨbɨjcp jɨm Jerusalén. Tüg'ócɨy je jäy ajcxy huɨdibɨ Jesús mɨbɨjcp anajty yqueec-huäcxtay, ñɨcxy ajcxy jɨm Judea ñaaxjot etz Samaria ñaaxjot. Jëyɨ je majmetzpɨ apóstoles ajcxy jac-huɨ'mɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nijëjɨty yëydɨjc huɨdibɨ Dios huindzɨgɨɨyb oy yajnaxtɨgɨ̈y Esteban. E ooy ajcxy jotmay jɨhuɨɨy, yaaxy ajcxy mɨɨd je' ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Chi Saulo ooy ixhuɨdijtcoty pahuɨdijtcoty huɨdijaty Jesús mɨbɨ́jcɨp etz tɨjc tɨjc anajty yajpɨdzɨmy pahuich pajuguty yëydɨjctɨjc etz töxyjäydɨjc, e pɨdaaccɨxy anajty pujxtɨgoty. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Je huidɨ ajcxy queec-huäcxtay ycapxhuäcxyp anajty ajcxy Jesús y'ayuc huen tɨm ma'amy huɨdijtcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nidügtɨ huɨdibɨ anajty yxɨɨ Felipe ñɨcxy jɨm Samaria, ytɨgɨɨy y'ayuccapxhuäcxpɨ, yajnɨmay ajcxy Cristo ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","E je jäy ajcxy ñayyöymujcɨ nidüg'ócɨy ajcxy y'amɨdo'ijtcɨxy janch amoñyɨ jadu'n nej Felipe anajty ymɨydägy e ijxyp anajty ajcxy je mɨjhuinma'ñ huɨdibɨ Felipe anajty ytumyb. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Com may anajty jäy jɨm huɨdibɨ mɨɨd ca'oybɨ ma yjot yhuinma'ñ, e tzoocp anajty ajcxy. E co je ca'oybɨ anajty ypɨdzɨmy ma je jäy, chi je jäy ooy yjacyaaxqueecy. Etz nañ mayjäy anajty chögy huɨdibɨ ca' ycɨ' ytecy yücxy etz tecyma'tpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","E jadu'n je mayjäy ajcxy anajty jɨm ooy yjotcujcɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jɨm anajty tüg yëydɨjc huɨdibɨ anajty yxɨɨ Simón huɨdibɨ anajty tɨ ni'ixpɨgɨ̈y huijyjäy huinma'ñ, e ooy anajty may Samaria jäy huin'ɨɨñ, ymɨna'ñ co je' anajty ymɨjɨty yjanchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tüg'ócɨy jäy anajty oy amɨdo'ijtcɨxy Simón y'ayuc, pi'ctɨjc etz mɨj'anäctɨjc, e ymɨnaangɨxy: ―Jadayaabɨ yëydɨjc ymɨɨd jada Dios ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ooy anajty je jäy ajcxy Simón mɨjnɨcxpejtcɨxy, com mɨɨd je mañ'ajt anajty jecy tɨ chachhuin'ɨ́ɨnɨgɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Co je Samaria jäy mɨbɨjcy je ayuc jadu'n nej Felipe ñimɨydacy Dios y'ané'mɨn etz Jesucristo, chi ajcxy ñɨɨbejty yëydɨjctɨjc etz töxyjäydɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Etz je Simón, je huijyjäy, nañ jadu'n mɨbɨjcy e ñɨɨbejty. Chi Simón puyöyɨɨy Felipe, ooy jɨhuɨɨy huinmaay jadu'n nej je mɨjhuinma'ñ huɨdibɨ anajty Felipe ytumyb etz jadu'n nej anajty Dios ymɨc'ajt ijxɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Co ajcxy je majmetzpɨ apóstoles ajcxy, huɨdi anajty jɨm Jerusalén, nejhuɨɨy co je Samaria jäy anajty tɨ cöbɨjccɨxy Dios y'ayuc, chi ajcxy quejxy jɨm je Pedro etz Juan. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Co Pedro etz Juan yja'ty jɨm Samaria, chi ajcxy Dios mɨbɨjctzoy mɨɨd je mɨbɨjcpɨdɨjc ycɨxpɨ, jɨgɨx ajcxy ymöhuɨɨyb je Espíritu Santo. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Com ca'nɨ anajty je' ajcxy ñicɨdägyii, jëyɨ anajty tɨ ñɨɨbejtcɨxy ma Huindzɨn Jesús yxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Huin'it Pedro etz Juan cɨ̈nïxajy ajcxy, e chi je Espíritu Santo y'adɨgɨɨy yjottɨgɨɨy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Co Simón ijxy co je Espíritu Santo y'adɨgɨ̈yii yjottɨgɨ̈yii co yɨ apóstoles ajcxy ycɨ̈nïxajy, chi Simón yaj'ahuanɨɨy je' ajcxy meeñ, ymɨnañ: ―Mooygɨch nañ jadu'n yɨ mɨc'ajt jɨgɨx co ngɨ̈nïxájɨbɨch hueñypɨnɨty nañ jadu'n jëbɨ ajcxy je Espíritu Santo y'adɨgɨ̈yii yjottɨgɨ̈yii. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Chi Pedro nɨmay Simón: ―Mɨ'ögɨ̈huɨpy miich mmeeñ, mɨɨd co mhuinma'ñ tɨ mbɨdägy co meeñygɨ́x mbada'ñ je huɨdibɨ Dios ñiyejcp. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Com miich ca' xypaady jadayaabɨ tung, com miich mjot mhuinma'ñ ca' ytudägɨty ma Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jothuimbit e ixmatz yɨ mjɨbɨc-huinma'ñ, e mɨbɨjctzou Dios, ca' jécyɨty xyhuinmeecxɨpy jadu'n nej jɨbɨc mjot mhuinma'ñ mmɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Com janch ta'm miich mjot mhuinma'ñ, e yɨ jɨbɨcpɨ hue' xymɨɨdɨty mach. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Chi Simón y'adzooy: ―Mɨbɨjctzou je Huindzɨn Dios mɨɨd ɨɨch ycɨxpɨ, jɨgɨx ca' ti xyjadɨpyɨch jadu'n nej miich tɨ xyñɨmäyɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Co Pedro etz Juan tɨy'ajt yejcy etz capxhuäcxy Dios y'ayuc jɨm Samaria, chi ajcxy yhuimbijty jɨm Jerusalén. Chi ajcxy canaag agajp ñaxɨɨy jɨm Samaria ñaaxjot, e capxhuäcxy Dios y'ayuc nej ajcxy y'alma nïdzoocɨn paadɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Huin'it xɨɨ Huindzɨn Dios y'ángel mɨgapxy je Felipe, nɨmay: ―Tzoon ya, nɨcx ma madzäcruudz ypɨdzɨmy, ma je tü'aa huɨdi tzomb jɨm Jerusalén huɨdibɨ nɨcxp jɨm Gaza. Je' je' je tü'aa huɨdibɨ adügtuum najxp. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe tɨm janitzon e ñɨcxy, e tü'am naybaattɨ mɨɨd tüg Etiopía jäy. Hue' je' anajty eunuco, mɨjtungmɨɨd jɨm Etiopía. Yɨ' je' tesorero'ajt anajty ma je töxyjäy huɨdibɨ anajty yxɨɨ Candace huɨdibɨ anajty ane'mb jɨm. Je eunuco jɨm anajty tɨ y'oy Jerusalén Dios ojadajtp. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","E chi yhuimbijtnɨ anajty ma ycajp, ɨñaayb anajty carretɨjoty yam chachnecycapxy. Hue' anajty chachcapxyp je Dios y'ayuc huɨdibɨ Isaías ycojaay. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chi je Espíritu ñɨmay Felipe co huen nɨcxy najtzpadɨ̈y je carretɨ ma je eunuco anajty y'ɨñäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Co Felipe mɨhuingoñ je carretɨ, chi mɨdoy co je jäy anajty capxy je necy huɨdi Isaías yjaay, chi y'amɨdooy: ―¿Nej mhuinjɨhuɨɨyb huɨdibɨ mgapxyp? ");
INSERT INTO mcoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Chi je jäy y'adzooy: ―¿Nej ɨɨch nhuinjɨhuɨ̈huɨpy pen ca' pɨn xyajnɨmäyɨch? Chi je eunuco nɨmay je Felipe co huen mɨɨd ɨñäyii carretɨjoty. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Je huɨdibɨ anajty je eunuco chachcapxyp jadu'n je' anajty ymɨna'ñ: Jadu'n ajcxy nɨcxy yaj'ögy nej jäy borregɨ nɨcxy yaj'ögy. Je' amoñ'ijty jadu'n nej borregɨ amoñ'ity co jäy nïme'pxy. Ni tüg'aa huam ycamɨnañ. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tɨ jäy yajtzöyduñyii, ca' ajcxy a'ɨxɨɨy co yjanayñïgapxtüdaanɨ. Ni y'ap y'oc ycaca'ty pɨn ocnigapxtüdɨɨb. Co yaj'öcɨ, chi choonɨ ya naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chi je eunuco y'amɨdooy Felipe: ―Tunmay'ajt yajnɨmaaygɨch pɨn jada ayucnajtzcapxɨɨybɨ ñimɨydacpy, ¿cɨ'm ñayñimɨdyägyii o ji jada huingbɨ pɨn nimɨydacpy? ");
INSERT INTO mcoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chi Felipe yajtzondacy je ayuc capxtɨɨcxɨn ma jadayaabɨ Dios y'ayuccojaaybɨ ñecy. Chi yajmɨɨdmɨydaacɨ nej Jesús yjajty y'ayoy. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Co ajcxy ñajx ma tüg nɨɨ, chi je eunuco ymɨnañ: ―Cha nɨɨ, ¿nej ca' ɨɨch jëbɨ huaad nnɨɨbetyɨ? ");
INSERT INTO mcoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Chi Felipe y'adzooy: ―Pen mmɨbɨjcpy Jesús mɨɨd tüg'ócɨy yɨ mjot mhuinma'ñ jëbɨ mnɨɨbety. Chi je jäy y'adzooy: ―Nmɨbɨjcpyɨch co Jesucristo Dios yɨ' y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chi je eunuco nɨmay je carretɨ huindzɨn co huen yajtɨnayxɨpy je' carretɨ. Chi nimetz ajcxy ñɨcxy ma nɨɨ, e chi Felipe yajnɨɨbejty je eunuco. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Co ajcxy ñɨɨbɨdzɨmy, chi je eunuco ijxtɨgoy je Felipe. Jadu'ñyɨ je Huindzɨn Dios y'Espíritu yajnɨcxɨ. E chi je eunuco ytü yajyöyñɨ jotcujc. ");
INSERT INTO mcoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe yajpaty jɨm Azoto, chi ñajxy cajp cajp capxhuäcxɨ Jesucristo y'ayuc ixtɨ yja'ty jɨm Cesarea. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ooy Saulo tzach'ixhuɨdijty pahuɨdijty Jesús yjäy, y'ahuändacy ooy, e yaj'öga'ñ anajty ajcxy. Paady oy ixy je teedy mɨjtungmɨɨdpɨ, ");
INSERT INTO mcoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","pɨjctzoy cötújcɨn, co anajty ñɨcxa'ñ jɨm Damasco ma yɨ judíojäy ajcxy ñaymujctac, madza'ñ pɨnjaty Jesús y'ayuc mɨbɨ́jcɨp. Saulo yajmiina'ñ anajty ajcxy mach jɨm Jerusalén huen yëydɨjctɨ́jcɨty huen töxyjäydɨ́jcɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jɨm anajty Saulo ñɨcxy mɨhuingoñ je Damasco cajp. Huin'it jotcömoñyɨ je tɨɨcxɨn huɨdi tzomb tzajpjoty, ñigɨdaacɨ jühuɨdity je Saulo. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Huin'it Saulo ycɨday, e mɨdoy co ñɨmäyii: ―Saulo, Saulo, ¿na'amy co xychachpahuɨdijttägyɨch? ");
INSERT INTO mcoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Chi Saulo yajtɨy: ―¿Mbɨn miich, Huindzɨn? Chi mɨdoy co y'adzoyii: ―Ɨɨch je' Jesús, je huɨdibɨ miich mdzachpahuɨdijttacpy, cɨ'm nayyajtzaachytunyii jadu'n nej huajyuub co jɨjpconebɨ'y huɨdi mɨɨd ñuumygumyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chi Saulo chɨyuygoty chachchɨgɨɨy, e ymɨnañ: ―Huindzɨn, ¿ti mdzojcpy ndunɨpyɨch? Chi je Huindzɨn Jesús ñɨmaayɨ: ―Pɨdɨ̈g etz nɨcx cajpjoty, e jɨm nyajnɨmähuɨpy ti jëbɨ mduñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Je yëydɨjctɨjc huɨdibɨ anajty Saulo ymɨɨd ooy ajcxy ñay'adzɨgɨɨyɨ, co mɨdoy je' ajcxy ayuc e ca' ajcxy ni pɨn ma y'ijxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chi Saulo ypɨdɨ̈gy, e co huindɨcxɨ̈cnɨ ca' pɨn ma oc'ijxnɨ. Chi ajcxy majch Saulo ma ycɨ', e chi ajcxy huijtznɨcxy jɨm Damasco. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tugɨɨg xɨɨ Pablo jɨm y'ijty huiintz, ca' ycaay y'uucy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jɨm Damasco anajty tüg yëydɨjc chɨnäy huɨdibɨ Jesús y'ayuc mɨbɨ́jcɨp, huɨdi anajty yxɨɨ Ananías, cumäyjoty Dios ñɨmaayɨ: ―¡Ananías! E chi je' y'adzooy: ―Cha ɨɨch, Huindzɨn Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Chi je Huindzɨn Dios ñɨmaayɨ: ―Pɨdɨ̈g, nɨcx ma je tü huɨdibɨ yxɨɨ Derecha, e jɨm ma Judas ytɨjc yajtɨɨu tüg Tarso jäy, huɨdi yxɨɨ Saulo. Dios mɨbɨjctzoob je' jɨm cham, cumäyjoty tɨ huin'ijxy tüg yëydɨjc huɨdi yxɨɨ Ananías, co oy ñimiñyii, e ycɨ̈nïxajɨɨy jɨgɨx y'ijxɨ̈gɨp jadüg'oc. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chi Ananías y'adzooy: ―Huindzɨn Jesús, mayjäy tɨ xyajmɨɨdmɨydägyɨch ajcxy jadu'n nej yɨ Saulo jɨbɨc y'ɨdɨ̈ch jɨm Jerusalén mɨɨd miich mjäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jadachambɨ tɨ mɨmiiñ ya je necy, ma teedy mɨjtungmɨɨdpɨ tɨ ycötujcmöyii, co huen majtztäy je jäy, e yajnɨcxtähuɨpy jɨm Jerusalén, tüg'ócɨy pɨnjaty ojadajtp miich mxɨɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Chi je Huindzɨn Jesús nɨmay Ananías: ―Nɨcx, com tɨ ɨɨch nhuin'ixy yɨjiibɨ yëydɨjc, jɨgɨx ɨɨch nxɨɨ etz n'ayucɨch capxhuäcxɨpy ma tüg'ócɨy naax cajp huɨdi ca' yjudíojäyɨty, etz ma yɨ reydɨjc, etz nañ jadu'n ma yɨ judíojäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ɨɨch yɨ' nyajnɨmähuɨpy tüg'ócɨy, nej ayo'n yajnaxɨpy mɨɨd ɨɨch nxɨɨ ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Chi Ananías ñɨcxy ma Saulo anajty tɨ yjättägy, co ytɨgɨɨy tɨgoty, chi cɨ̈nïxajy Saulo, e chi nɨmay: ―Mɨgüg Saulo, je Huindzɨn Jesús huɨdibɨ nayguëxɨ̈cɨ jɨm tü'am ma miich anajty miiñ, yɨ' tɨ xyquexyɨch jɨgɨx m'ijxɨ̈gɨpy jadüg'oc, etz je Espíritu Santo xyñïdɨgɨ̈huɨp xycödɨgɨ̈huɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mɨc'amy ycäy ma Saulo yhuiin jadu'n nej acx ñïmeeñ, chi y'ijxɨ̈gy. Huin'it Saulo ypɨdɨ̈gy e chi yajnɨɨbejtɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chi Saulo ycaay y'uucy, e chi ymɨc'pɨjcy jadüg'oc. Chi jɨm mɨɨd'ijty jecy huɨdibɨ ajcxy ixpɨjcɨp Jesús y'ayuc jɨm Damasco. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chi janch mɨc'amy Saulo ytɨgɨɨy Dios y'ayuccapxhuäcxp ma je judíojäy ajcxy ñaymujctac jɨm Damasco, ymɨnañ co je Jesús hue' je' Dios y'ung. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tüg'ócɨy pɨnjaty anajty mɨdoohuɨp Saulo y'ayuc, ooy ajcxy jɨhuɨɨy huinmaay, etz ñayñɨmáayɨgɨxy: ―¿Nej ca' jada' yjëjɨty je huɨdibɨ tzachyajcödɨgoyam yɨ jäy ajcxy huɨdibɨ Jesús yxɨɨ mɨyaax ojadájtɨp jɨm Jerusalén? ¿Nej ca' jada yjëjɨty huɨdi anajty tɨ ymiiñ ya jäy ymajtzpɨ, e nɨcxy cɨ̈yega'ñ ma teedy mɨjtungmɨɨdpɨ? ");
INSERT INTO mcoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Je Saulo capxhuacxɨp anajty Jesús y'ayuc huinmɨc jotmɨc, e nigapxtäy co Jesús hue' je' je Cristo, chi yɨ judíojäy ajcxy huɨdi anajty jɨm tzɨnaayb Damasco cɨjx ajcxy yhuinma'ñ tɨgoydäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tɨ anajty hueenɨ xɨɨ tiempo ñajtznïnɨcxɨɨyñɨ, chi je judíojäy ajcxy ñaygapxɨ co yaj'ögaangɨxy je Saulo. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulo ñejhuɨɨy co anajty yaj'öga'ñyii. Chi jɨm anajty ajcxy y'ahuixyii xɨɨm tzuum ma je poch aguu cajppäbɨ, jɨm anajty yaj'öga'ñyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","E je jäy ajcxy huɨdibɨ anajty ymɨjpɨdacpy Jesús, chi je' ajcxy codɨɨyñajxy je Saulo mɨjcachjoty ma je pochycop huɨdi je cajp mɨɨd jübojtz'ahuɨdítyɨty, e jadu'n je' choocy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Co Saulo yja'ty jɨm Jerusalén, oy japuyöyɨ̈huaañ je mɨbɨjcpɨdɨjc ajcxy. Nidüg'ócɨy anajty ajcxy ooy tzɨgɨɨygɨxy anajty com ca' anajty mɨbɨjccɨxy co je Saulo tɨ anajty yjothuimbity. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Chi Bernabé yajnɨcxy Saulo ma je nimajmetzp apóstoles ajcxy yajpaady, e chi yajmɨɨdmɨydactay nej Saulo anajty tɨ ixy je Huindzɨn Jesús tü'am, e nej anajty Saulo Jesús y'ayuc tɨ capxhuäcxɨ huinmɨc jotmɨc jɨm Damasco. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Huin'it Saulo yhuɨ'my jɨm Jerusalén, e mɨɨd huɨdity anajty ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aamɨc jotmɨc capxhuäcxy je Huindzɨn Jesús y'ayuc, etz mɨɨd mɨydaaccɨxy e ñaymɨcmɨgápxɨgɨxy mɨɨd je judíojäy huɨdibɨ griego ayuc caxp. E je' ajcxy nihuinmayɨɨyb co yaj'ögaangɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Co je mɨbɨjcpɨdɨjc nejhuɨɨy, chi ajcxy yajnɨcxy je Saulo jɨm Cesarea, e chi ajcxy quejxnajxy huen nɨcxy jɨm Tarso. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Huin'it tiempo je' ajcxy huɨdijaty mɨjpɨdacp Jesús, jotcujc anajty chɨnaaygɨxy, e nïgɨ anajty ixpɨjc'ɨdɨ̈ch Dios y'ayuc ytɨy'ajt, jadu'n nej yɨ huɨdibɨ ajcxy tzɨnaayb ma yɨ Judea ñaaxjot, Galilea ñaaxjot, etz Samaria ñaaxjot. Chi ajcxy ooy yajmɨj'ajtcɨxy je Huindzɨn Jesús, e mɨɨd je Espíritu Santo ypubéjtɨn, nïgɨ anajty yjacmayɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Co anajty Pedro yhuɨdijty cogapxɨ̈y cajp cajp je mɨbɨjcpɨdɨjc ajcxy, y'oy nañ jadu'n ma je mɨbɨjcpɨdɨjc ajcxy huɨdibɨ tzɨnaayb jɨm Lida. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jɨm mɨnaybaattɨ tüg yëydɨjc huɨdibɨ anajty yxɨɨ Eneas, huɨdibɨ anajty tɨ ypa'm'ijtnɨ tuctujc jɨmɨjt, hue' je' anajty ycɨ̈xuxy ytecyxuxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Chi Pedro nɨmay: ―Eneas, Jesucristo xyajtzoocp, pɨdɨ̈g, etz yajpɨdɨ̈g yɨ mmaabejt. Chi Eneas mɨc'amy ypɨdɨ̈gy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chi ijxy tüg'ócɨy jäy huɨdibɨ tzɨnaayb jɨm Lida etz Sarón. Chi ajcxy yjothuimbijttay nidüg'ócɨy, ixmajtztay tüg'ócɨy yɨ ñi'ap huinma'ñ e jɨjptɨgɨyɨɨy yɨ Huindzɨn Jesús y'ixpɨ́jcɨn. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Je huin'it tiempo jɨm Jope, jɨm anajty tüg töxyjäy chɨnäy huɨdibɨ mɨbɨjcp Jesús, hue' anajty yxɨɨ Tabita, je' huɨdi griegojäy ytijyp Dorcas. E je Dorcas oy xɨɨ tiempo anajty yajnaxy mɨ'oyjäy'aty yɨ jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jadu'n yjajtɨ huin'it tiempo Dorcas ypa'mbejty, e chi ytɨmy'o'cy. Co ajcxy yajtziiday, chi ajcxy je öcpɨ yajnɨcxy ma je tɨjc mɨmejtznïhuijtzpetypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Je Jope cajp naymɨhuingon'ájtɨp anajty mɨɨd Lida cajp ma anajty Pedro yajpaady, co mɨbɨjcpɨdɨjc ajcxy anajty nejhuɨy co je' anajty yjɨ́mɨty, chi ajcxy mejtz yëydɨjc quejxy co huen nɨmäyii: ―Min tzojc ya Jope. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Huin'it Pedro ñɨcxy mɨɨd je' ajcxy. Co jɨm yja'ty, chi ajcxy yajnɨcxy ma je tɨjc mɨmejtznïhuijtzpetypɨ, e jɨm anajty ajcxy je co'ögy töxyjäydɨjc ajcxy ytɨnayjühuɨdityɨ ma je öcpɨ, chachyaaxcɨxy. Chi ajcxy Pedro yaj'ijxy je huit nïjen huɨdibɨ Dorcas anajty tɨ yaj'oyɨ̈y co anajty yjugy'atyñɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mɨc'amy je Pedro quejxpɨdzɨmday je jäy ajcxy. Chi ycoxtɨnay'ahuɨɨy, e Dios mɨbɨjctzoy. Chi huindɨcxpejty je öcpɨ, nɨmay: ―Tabita, pɨdɨ̈g. Huin'it Tabita yhuindɨcxɨ̈gy, e ijxy je Pedro, chi ɨñaygugɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Chi Pedro majtzɨ ycɨ', e chi huijtzɨ̈gy. Chi yaaxɨ ymɨgügtɨjc etz co'ögytöxyjäydɨjc ajcxy, chi ajcxy yajcɨ̈dɨgɨɨy juugy. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tüg'ócɨy jäy ajcxy jɨm Jope nejhuɨyday co Pedro yajjugypɨjcy je Dorcas. E mayjäy mɨbɨjcy je Huindzɨn Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jadu'n yjajty co Pedro y'ijty jɨm Jope canaag xɨɨ ma je coodzpɨ ytɨjc huɨdi anajty yxɨɨ Simón. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jɨm Cesarea anajty tüg tungmɨɨdpɨ huɨdi anajty yxɨɨ Cornelio, hue' je' anajty capitán'ajtp ma tüg batallón soldado ajcxy yxɨɨjɨp, la Italiana. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Je Cornelio ooy anajty ytudägyɨty, etz je' mɨɨd tüg'ócɨy y'ung ytöxyɨjc ooy anajty yajmɨj'ajtcɨxy Dios. Je Cornelio nañ jadu'n ypubety mɨɨd meeñ je judíojäy ayoobtɨjc, e je' Dios ojadajt anajty jabom jabom. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tüg xɨɨ, mɨnacyxɨɨ anajty, Cornelio huin'ijxy janch huädz Dios tüg y'ángel ñigɨdaacɨ, e ñɨmaayɨ: ―¡Cornelio! ");
INSERT INTO mcoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Chi Cornelio huindɨcxpejty je ángel janch tzɨgɨɨyb anajty, e chi yajtɨɨy: ―¿Ti Huindzɨn? Huin'it je ángel y'adzooy: ―Jadu'n nej mDios'ojadaty etz jadu'n nej mbubety ayoobtɨjc tɨ Dios jäygɨdägy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Quex mjäy jɨm Jope, huen nɨcxy yajtzoñ Simón, huɨdibɨ nañ jadu'n yajtijp Pedro. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jɨm je' yja'ttacy ma jadügpɨ Simón, je cootzpɨ huɨdi ytɨjc mɨhuingon mejypa'. Je Pedro xyajnɨmähuɨpy ti mdunɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Co je ángel ñɨcxnɨ huɨdi anajty tɨ ymɨgapxyii, chi Cornelio yaaxɨ mejtz ytumbɨ, etz tüg soldado huɨdi Dios capxymɨdoob, etz huɨdibɨ je Cornelio ooy ymɨjnɨcxpedyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Chi yajmɨɨdmɨydactay nej je ángel ñɨmaayɨ, chi ajcxy quejxy jɨm Jope. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Com jabom jɨm anajty je quejxyöybɨ ajcxy ñɨcxy mɨhuingon Jope, cujc yxɨɨ anajty, e chi Pedro ypejty ma tɨjcnïcx Dios ojadajtp. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Ooy Pedro anajty yuubögyii, e ooy jacaya'ñ, jɨmnɨ anajty yjɨɨcxy yaj'oyɨ̈yii. Chi Pedro huin'ixy je tzajp ahuädz, e huin'it ijxy quidägy jadu'n nej poob huit mɨjpɨ yxóchɨty majaty ytaatz. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jiiby ma je poob huit, jiiby anajty canaagnax ɨyujc huɨdijaty mɨdaax ycɨ' ytecy etz tza'ñ etz joon. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Huin'it Pedro mɨdoy co anajty ñɨmäyii: ―Pedro, pɨdɨ̈g nɨcxy yaj'ög yɨ ɨyujc etz tzüdz. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Chi Pedro y'adzooy: ―Ca', Huindzɨn, camɨnaabɨ ɨɨch tɨ njɨcxy huɨdibɨ jɨbɨ́cɨp etz huɨdibɨ ca' ñigödúcyɨty nɨcxy judíojäy jɨɨcxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Huin'it jadüg'oc ayuc mɨdoy ñɨmäyii: ―Huɨdibɨ Dios yajhuäch ca' huaad mdijy co yɨ' yjɨbɨcɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tugɨɨg'oc jadu'n yjajtɨ, chi je poob huit ypättɨgɨɨyñɨ tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jɨm anajty Pedro tzachhuinmay nej anajty yhuimbɨdzɨmy je tɨɨbɨ ixy co yja'ty ma tɨjc aguu je Cornelio yquexyöybɨ huɨdi ajcxy anajty nidɨɨhuɨp yajtɨɨhuɨp je Simón ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chi ajcxy mɨc ycogapxɨɨy yajtɨɨy pen jɨm anajty yjättägy Simón huɨdibɨ anajty nañ jadu'n yajtijp Pedro. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","E je Pedro je' anajty chachhuinmaayb tɨɨbɨ ixy, chi je Espíritu Santo Pedro ñɨmaayɨ: ―Tugɨɨg yëydɨjc ji xy'ixtäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pɨdɨ̈g e mɨnac, nɨcx mɨɨd je' ajcxy, e ca' ti mhuinmay, com ɨɨch jadu'n tɨ nnɨmäy co huen xy'ixtäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Huin'it Pedro ymɨnajcy ma je' ajcxy, je Cornelio quexyöybɨ, nɨmay ajcxy: ―Ɨɨch je' huɨdibɨ miich ajcxy m'ixtaayb, ¿ti ycɨxpɨ co tɨ mmiingɨxy? ");
INSERT INTO mcoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Chi ajcxy y'adzooy: ―Yɨ' ɨɨch ajcxy tɨ xyquexyɨch yɨ Cornelio huɨdibɨ capitán'ajtpɨ, je' tudägy jäy huɨdibɨ Dios yajmɨj'ajtp, je huɨdibɨ tüg'ócɨy judíojäy ooy tzójccɨxy, etz cömaaygɨxy. Huindzɨn Dios tüg y'ángel ñɨmay Cornelio co miich miiñ nyajhuoy, jɨgɨx mnɨ́cxɨp ma yɨ' ytɨjc, e y'amɨdo'ida'ñ ajcxy nej miich myaj'ixpɨga'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chi Pedro yajtɨjctɨgɨɨy je' ajcxy. Chi ajcxy jɨm ymaahuɨ'my. Com jabom Pedro ñɨcxy mɨɨd je' ajcxy, e chi nijëjɨty ypanɨcxɨ huɨdibɨ mɨjpɨdacp Jesús huɨdi anajty ajcxy tzɨnaayb jɨm Jope. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Com jabom ajcxy yja'ty jɨm Cesarea ma Cornelio anajty y'ahuixy tügmucy mɨɨd yjugymɨgüg, etz nijëjɨty pɨn ooy mɨɨd ñaymɨgüg'adyii, huɨdijaty anajty ajcxy jayɨjp tɨ nɨmäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Co Pedro oyjäty ma je tɨjc, chi Cornelio ytɨjcpɨdzɨmy oy yjɨjpcobadɨ̈y je Pedro, e chi ycoxtɨnay'ahuɨɨy yajmɨj'ada'ñ anajty je Pedro. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Chi Pedro huijtztɨnayɨ̈gy je Cornelio, e nɨmay: ―Tɨnayɨ̈g, ca' xyajmɨj'ida'ñɨch, nañ jadu'n ɨɨch njäyɨty nej miich. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mɨɨd anajty ycapxy ymɨydägy co ytɨjctɨgɨy, jiiby anajty mayjäy ni'amugɨ̈'ahuijxcɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Chi Pedro nɨmay ajcxy: ―Miich ajcxy mnejhuɨɨyb co yɨ judíojäy ycostumbre capx'aducy ca' huaad judíojäy yöymucy mɨɨd huɨdibɨ ca' yjudíojäyɨty, ca' huaad ytɨgɨɨygɨxy ma ajcxy ytɨjc. Per Dios tɨ xyajni'ixɨ̈yɨch co ca' huaad nmɨna'ñɨch ca' oyjäyɨty huädzjäyɨty pɨnjaty. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Paady co oy tɨ xyajhuoyiijɨch tɨ nmiiñɨch, ni ca' huam tɨ nmɨna'ñɨch. Nnejhuɨ̈huaamyɨch na'amy co oy tɨ xyajhuoyiijɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Chi Cornelio y'adzooy: ―Cham ymɨmɨdaaxxɨɨjɨ̈y, jadu'n nej jadachambɨ hora, ya ɨɨch anajty ma ndɨjcɨch, jaygay jay'ügy nDios'ojadatyɨch. Com hue' anajty mɨjmɨnacy xɨɨ mɨna judíojäy ajcxy ycapxtaaccɨxy, co tüg ñayguëxɨ̈cɨ jadu'n nej jäy mɨɨd ypoob huit janch adɨɨcxp. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","E je ángel xyñɨmaayɨch: “Cornelio, Dios tɨ xymɨdoohuɨ m'oración e tɨ jadu'n jäygɨdägy jadu'n nej mbubety yɨ ayoobtɨjc ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Quex mdumbɨ jɨm Jope, huen nɨcxy yajtzoñ Simón huɨdi nañ jadu'n yajtijp Pedro. Jɨm Pedro yja'ttägy ma je cotzpɨ ytɨjc huɨdibɨ yxɨɨ Simón, huɨdibɨ tzɨnaayb mɨhuingon mejypa'. Co je' ymiinɨpy, chi xymɨɨdmɨydägɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Paady nguejxyɨch janch mɨc'amy huen nɨcxy xy'ijxtäy. E tɨ may'ajt mduñ co tɨ mmiiñ. Jadachambɨ cha ɨɨch ajcxy nidüg'ócɨy ma Dios yhuinduu. E n'amɨdo'idáangɨxyɨch tüg'ócɨy je y'ayuc huɨdibɨ je Huindzɨn Dios tɨ xyaj'ane'my jëbɨ xyajnɨmaaygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Huin'it Pedro ytɨgɨɨy y'ayuccapxhuäcxpɨ, nɨmay ajcxy: ―Jadachambɨ huinjɨhuɨɨybɨch, co yɨ Dios ca' ni tüg ixy'ixy jäy, y'actzojctaayb hueñypɨ́nɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dios ycöbɨjcpy hueñypɨnjäyɨty huɨdibɨ tzɨnaayb huen huɨdibɨ naax huen huɨdibɨ cajpɨty, pen chɨgɨɨyb ajcxy Dios, pen tumyb oybɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios tɨ quexy yɨ' ytɨy'ajt ma yɨ Israel jäy ajcxy, yajnɨmay co ji cham jotcujc'ájtɨn mɨɨd Jesucristo ɨɨch ajt nHuindzɨn. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Miich ajcxy mnejhuɨɨyb yajxon nej tɨ ytunyii tɨ yjadyii ma judíojäy ajcxy ñaax ycajp chondacy jɨm Galilea, Juan el Bautista tɨ anajty capxhuäcxɨ Dios y'ayuc ytɨy'ajt etz yjäyyajnɨɨbety. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","E mnejhuɨɨyb miich ajcxy co Dios yejc je Jesús je Nazaretpɨ je Espíritu Santo, e nej Jesús yhuɨdijty e tuuñ oy'ájtɨn, etz mɨjhuinma'ñ, jadu'n nej yajtzocy je jäy ajcxy huɨdi anajty ane'm'ijtp ma yɨ mujcu'. Com Dios anajty mɨɨd y'ity je Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɨɨch ajcxy je tɨy'ajt nmɨɨdɨch tüg'ócɨy jadu'n nej Jesús yjajty y'ayoy jɨm Judea naaxjot etz jɨm Jerusalén. Huin'it ajcxy Jesús yaj'o'cy cruudzcɨ́xy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","E Dios yajjugypɨjcy codugɨɨg xɨɨ, e chi yajnayguëxɨ̈cɨ ma ɨɨch ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ca' tɨ yajnayguëxɨ̈gyii ma tüg'ócɨy jäy, jëyɨ ma ɨɨch ajcxy huɨdi jayɨjp Dios yhuin'ijx jɨgɨx tɨy'ajt nyegɨpyɨch. Ɨɨch ajcxy caaymujc uucmujc huin'it co yjugypɨjcy ma y'o'cy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tɨ xyquexy ɨɨch ajcxy ayuc ngapxhuäcxpɨ ma mayjäy ajcxy etz nidɨy'ajt'adɨpyɨch ajcxy co Dios Jesús tɨ pɨdägy mɨj'ane'mbɨ ma yɨ juugypɨ etz ma yɨ ögypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nañ jadu'n jecy'ajty tüg'ócɨy Dios y'ayucnajtzcapxɨɨybɨ ñimɨydac ajcxy Jesús, e ymɨnañ ajcxy co tüg'ócɨy je jäy ajcxy pɨnjaty mɨbɨjc je Cristo, Dios huinmecxɨɨb ajcxy ypocy. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Yam anajty Pedro ycapxyñɨ co je Espíritu Santo ñïdɨgɨɨyɨ ycödɨgɨɨyɨ ajcxy nidüg'ócɨy huɨdijaty y'amɨdo'ijt Pedro y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","E je judío mɨbɨjcpɨdɨjc ajcxy tɨɨbɨ anajty miiñ mɨɨd Pedro, ooy ajcxy jɨhuɨy huinmay co Dios quejx Espíritu Santo ma je jäy ajcxy huɨdibɨ ca' yjudíojäyɨty, ");
INSERT INTO mcoNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","co mɨdoy ycapxcɨxy mɨɨd huingbɨ ayuc, etz cömaygɨxy jäymejtzcɨxy Dios. ");
INSERT INTO mcoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chi Pedro ymɨnañ: ―¿Nej ca' jada' y'óyɨty co ñɨɨbedɨpy ajcxy huɨdibɨ Dios tɨ ymóoyɨgɨxy je yEspíritu Santo jadu'n nej ɨɨch ajt xymooyɨm? ");
INSERT INTO mcoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Chi Pedro ni'ane'mdɨɨy huen nɨɨbejtcɨxy ma Huindzɨn Jesucristo yxɨɨ. Huin'it ajcxy Pedro cohuanɨɨy huen huɨ'my tüg xɨɨ mejtz xɨɨ mɨɨd je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Je apóstoles ajcxy etz je mɨbɨjcpɨdɨjc ajcxy huɨdi anajty ajcxy jɨm Judea, mɨdoy ajcxy ayuc co nijëjɨty jäy huɨdi ca' yjudíojäyɨty tɨ anajty ajcxy cöbɨ́jcɨy Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","E co Pedro yhuimbijty Jerusalén, chi nijëjɨty judíojäy ajcxy ojy Pedro, je' ajcxy huɨdibɨ tzachmɨjpɨdaaccɨxp judíojäy ycostumbre jadu'n nej ajcxy tɨy'ajttɨɨygɨxy ymang. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Je' ajcxy nɨmay Pedro: ―¿Na'amy co oy tɨ mgo'ixɨɨy jäy ajcxy huɨdi ca' yjudíojäyɨty, etz tɨ mgay m'ügy mɨɨd je' ajcxy? ");
INSERT INTO mcoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Chi Pedro nimɨydactay tüg'ócɨy jadu'n nej anajty tɨ yjaty, chi ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Jɨm ɨɨch anajty Jope nDios'ojadatyɨch. Chi nhuin'ijxyɨch jadu'n nej tüg mɨj poob huit chooñ tzajpjoty, cɨdägy ma ɨɨch nhuinduu, xóchɨty anajty ma mɨdaax ytaatz. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Co nnimɨjhuägyɨch n'ixa'ñɨch ti jiiby, chi n'ijxyɨch may ɨyujc, jiiby ɨyujc mɨdaaxpɨ ycɨ' ytecy, jiiby ahua'nbɨ ɨyujc, jiiby tza'ñ, etz joon. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Chi nmɨdooyɨch tüg ayuc huɨdibɨ xyñɨmaaybɨch: “Pedro, pɨdɨ̈g, yaj'ög yɨ ɨyujc etz tzüdz.” ");
INSERT INTO mcoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Chi n'adzooyɨch: “Ca' Huindzɨn, com camɨnaabɨ ndzüchɨch ɨyujc huɨdibɨ ca' ñigo'adúcyɨty judíojäy ajcxy tzüdzɨpy.” ");
INSERT INTO mcoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Chi mɨmetz'ocpɨ tüg ayuc tzajpcɨ́xy xyñɨmäyɨch: “Huɨdi Dios tɨ yajhuäch, ca' huaad mdijy co ca' y'oychú'tznɨty.” ");
INSERT INTO mcoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tugɨɨg'oc jadu'n yjajtɨ, chi je poob huit ypättɨgɨɨyñɨ tzajpjoty. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Huin'it xyñimiiñɨch je quexyöybɨ nidugɨɨg, chooñ ajcxy jɨm Cesarea. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chi je Espíritu xyñɨmaayɨch, co min n'ocnɨcxɨch mɨɨd je' ajcxy, ca' ma ni ti nhuinmayɨpyɨch. Mɨɨd nɨcxyɨch nidugɨɨg nmɨgügtɨjcɨch. Chi ɨɨch ajcxy ndɨgɨɨy ma je jäy ytɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Je codɨjc xyajmɨɨdmɨydaacɨch co je' anajty tɨ huin'ixy tüg ángel ma ytɨjc, ñɨmäyii: “Quex mdumbɨ ajcxy jɨm Jope huen nɨcxy yajtzoongɨxy Simón huɨdibɨ jäy ytijpy Pedro, ");
INSERT INTO mcoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","e je' xyajnɨmähuɨp nej jëbɨ Dios m'alma xyajnïdzoocɨp, miich etz tüg'ócɨy mjɨɨn mdɨjc mjuugy-mɨgüg.” ");
INSERT INTO mcoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Co Jesús y'ayuc ngapxhuäcxtzondaacɨch, chi je Espíritu Santo ñïdɨgɨɨyɨ ycödɨgɨɨyɨ je' ajcxy. Tɨm jadu'n nej xyñïdɨgɨɨyɨm xycödɨgɨɨyɨm je jayɨjp'atypɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Huin'it njäymejtzcoodyɨch nej je Huindzɨn Jesús ymɨnañ: “Janch Juan, je Bautista, jäy yajnɨɨbejt mɨɨd nɨɨ, e Dios jäy ajcxy y'adɨgɨ̈huɨɨyb yjottɨgɨ̈huɨɨyb je Espíritu Santo.” ");
INSERT INTO mcoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pen Dios tɨ ymöyii je jäy ajcxy huɨdibɨ ca' yjudíojäyɨty tú'cɨy mɨɨd huɨdibɨ ɨɨch ajt tɨ xymooyɨm co nmɨbɨ́jcɨm Jesucristo. ¿Ocjactɨm pɨn ɨɨch co Dios nmɨdzɨp'adɨɨybɨch? ");
INSERT INTO mcoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Je mɨbɨjcpɨdɨjc ajcxy jɨm Jerusalén, co ajcxy mɨdoy Pedro y'ayuc, chi ajcxy y'amonday. Chi ajcxy Dios jäymejch cömay, chi ajcxy ymɨnaangɨxy: “Dios jadu'n tɨ ymɨna'ñ co je' ajcxy huɨdibɨ ca' yjudíojäyɨty jëbɨ yjothuimbijtcɨxy, jɨgɨx Dios ymöhuɨɨyb jugy'ájtɨn huinɨxɨɨbɨ.” ");
INSERT INTO mcoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Taabɨ jäy yaj'o'cy Esteban, chi jäy ajcxy ooy ixhuɨdijtcoty pahuɨdijtcoty Jesús yjäy jɨm Jerusalén. Chi nijëjɨty ajcxy yqueecy, nɨcxy ajcxy jɨm Fenicia ñaaxjot, etz jɨm Chipre, etz jɨm Antioquía. E capxhuäcxy ajcxy je oybɨ ayuc ma jadyii judíojäy, ca' ajcxy jac ni pɨn yajnɨmay. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","E nijëjɨty mɨbɨjcpɨdɨjc huɨdibɨ jɨm anajty ajcxy yconaaxɨp ycogájpɨp Chipre etz Cirene, chi ajcxy ñɨcxy jɨm Antioquía. Chi yajmɨɨdmɨydacy ajcxy je Huindzɨn Jesús y'ayuc mɨɨd griegojäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","E je Huindzɨn Dios ooy ypubejtɨ je' ajcxy, e ooy mayjäy ixmajch je jɨbɨc-huinma'ñ etz mɨjpɨdaaccɨxy yɨ Huindzɨn Jesús ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Co je mɨbɨjcpɨdɨjc ajcxy jɨm Jerusalén mɨdoogɨxy jada ayuc, chi ajcxy quejxy Bernabé jɨm Antioquía. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Co Bernabé jɨm yja'ty, chi ijxy jadu'n nej Dios anajty oy'ájtɨn tɨ tuñ, chi oy yjotcugɨɨy je Bernabé. Chi capxhuijy tüg'ócɨy co huen ajcxy janch cɨxyjot huinɨjot cuyduunɨ yɨ Huindzɨn Jesús y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Com Bernabé oyjäy je' anajty, e ooy mɨjpɨdägy Dios y'ayuc etz ooy mɨɨdɨty je Espíritu Santo jotjoty huinma'ñyjoty. Ymɨɨd je' ycapxhuíjɨn ooy mayjäy mɨjpɨdacy Jesús y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Co jadu'n yjajtɨ, chi Bernabé oy ixtay Saulo jɨm Tarso, e co paty, chi mɨɨdmiiñ Antioquía. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jadu'n yjajty jɨm ajcxy y'ijty tüg jɨmɨjt, yaj'ixpɨjccɨxy je mayjäy huɨdibɨ ajcxy jɨjptɨgɨyɨɨy je Jesús y'ixpɨ́jcɨn. Jɨm Antioquía oga'n yxɨɨmoy cristiano, je jäy ajcxy huɨdibɨ mɨjpɨdacp Jesús. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Huin'it tiempo nijëjɨty tɨy'ajtnajtzcapxɨɨybɨ chooñ Jerusalén ñɨcxy ajcxy jɨm Antioquía. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tüg huɨdi anajty yxɨɨ Agabo ytɨnay'ahuɨɨy mayjäyjoty, e chi je Espíritu Santo yajcapxɨ, e ymɨnañ co mɨjyuu anajty ñaxcɨdäga'ñ huindu'ñybɨ naaxhuiñ. E janch jadu'n yjajtɨ taab anajty Claudio y'ane'my. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Huin'it je mɨbɨjcpɨdɨjc ajcxy jɨm Antioquía pɨdacy ajcxy yhuinma'ñ co quexaangɨxy pubéjtɨn ma ymɨgügtɨjc ajcxy huɨdi tzɨnaayb jɨm Judea, jadu'n nej pubéjtɨn pɨn tɨm yega'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","E jadu'n ajcxy tuuñ. E je meeñ tɨɨbɨ anajty ymucy yajmɨguejxy ajcxy je Bernabé etz Saulo ma je mɨbɨjcpɨdɨjc tungmɨɨdpɨ jɨm Judea. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Huin'it tiempo je rey Herodes yajmajtzɨ nijëjɨty Jesús yjäy, e chi yajtzaachytuunɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Chi ni'ane'mdɨy huen yaj'ögyii mɨɨd espada je Jacobo, je Juan y'uch. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Co je rey nejhuɨɨy co je judíojäy ajcxy jadu'n ooy jäygɨdaaccɨxy, chi ymajtzɨ Pedro nañ jadu'n. Hue' jadu'n yjajtɨ xɨɨjoty, je xɨɨ mɨna tzajcaagy caaygɨxy huɨdi ca'pɨ ylevadura mɨɨdɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Co Pedro yajmajch, chi yajpɨdacy pujxtɨgoty. E chi je rey ane'my co huen mɨdaaxpɨcy soldado ajcxy cuend'adyii, tügpɨcyjaty mɨdaax soldado ajcxy. Hue' anajty je rey tɨ huinmay xɨɨnaxy anajty tɨyduna'ñ Pedro mayjäy agujc. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedro jiiby anajty pujxtɨgoty janch oy cuend'aty. E je mɨbɨjcpɨdɨjc janch Dios mɨbɨjctzodɨɨb anajty ajcxy mɨɨd Pedro ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Huin'it coodz ma ca'nɨ anajty yxɨɨmɨ̈y, ma je Herodes anajty tɨyduna'ñ Pedro mayjäyjoty com jabom, Pedro maab anajty, e soldado agujc ajcxy cɨ̈xoch tecyxoch anajty mɨɨd cadena, e jadügpɨcy soldado ajcxy pujxtɨjc'aguy anajty ajcxy ycuend'aty. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chi janch tɨmetiinɨ yHuindzɨn Dios tüg y'ángel ñayguëxɨ̈cɨ ytɨnäy ma Pedro yhuinduu, e je pujxtɨjc yaj'anɨyday. E chi je ángel tijyücxy Pedro ma ycaach, chi yajmäyhuijy, e nɨmay: ―Pɨdɨ̈g mɨc'amy. Chi je cadena ycäday ma Pedro ycɨ'. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Chi je ángel nɨmay Pedro: ―Ñayhuɨɨnɨ, yajtɨgɨ' mgɨ̈g. Co Pedro yajtɨgɨyday ycɨ̈g, chi je ángel ñɨmaayɨ: ―Yajtɨgɨ' mjocxhuit, e pajamgɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Chi Pedro pujxtɨjc pɨdzɨmy axam ma je ángel, ni ca' nejhuɨ̈y pen janch anajty huɨdibɨ je ángel tumyb, hue' jɨhuɨy jadu'n nej ycumäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Chi ñajxy ajcxy ma tügpɨcy cuend'ajtpɨ, mɨc'amy ajcxy mɨmetzpɨ nïnajxy. Co ajcxy yjäty ma mɨjpujxtɨjc aguu, ma mɨjtüba', chi je' cɨ'm'ahuaach. Chi ajcxy ypɨdzɨmy. Tɨ anajty mɨjyöygɨxnɨ co je ángel ixmajtznɨ Pedro. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Huin'it Pedro yhuinma'ñymejch, chi ymɨnañ: ―Jadachambɨ njɨhuɨɨybɨch co janch jada' co je Huindzɨn Dios tɨ quexy y'ángel, e yɨ' tɨ xyñihua'ñɨch ma Herodes, etz jadu'n nej tüg'ócɨy judíojäy ajcxy anajty xytuna'ñɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Co Pedro yjot yhuinma'ñ ymejch, chi ñɨcxy ma María ytɨjc, je Juan ytaj, je Juan huɨdi jäy ytijpy Marcos, ma anajty ajcxy jɨm mayjäy tügmucy y'íjtcɨxy Dios mɨbɨjctzoogɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Co Pedro tɨjc'aguu cojxnojcy, je tɨba'y'amybɨ, chi tüg töxy'anäg ypɨdzɨmy huɨdi anajty yxɨɨ Rode, ixa'ñ pɨn je' tɨjc'aguu cojxnojcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Co oy yögmɨdoy co Pedro je' anajty, chi ca' ytɨjc'aguu yaj'ahuaach. Jëyɨ co poyɨ̈gy ñɨcxy tɨgoty co anajty tzachjotcújcɨty, nigapxy co Pedro je' anajty ma tɨjc'aguu. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Chi je jäy ajcxy nɨmay Roda: ―Mloocjɨɨyb jada' miich. Chi je töxy'anäg y'adzooy co janch je' anajty. E je jäy ajcxy ymɨnaangɨxy co ca' yɨ' yjëjɨty, hue' jada' Pedro y'ángel. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yam Pedro anajty tɨjc'aguu tzachcojxnocy co ajcxy yaj'ahuaach, chi ajcxy ijxy, chi ajcxy ooy chɨgɨɨy yjɨhuɨɨy. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro cɨ̈mɨɨd ytɨy'ajtyejcy co huen amoñ ajcxy. Chi yajmɨɨdmɨydacy nej je Huindzɨn Dios anajty tɨ yajpɨdzɨmyii pujxtɨgoty. E nɨmay ajcxy co huen nɨcxy yajmɨɨdmɨydägy jada je Jacobo etz jacjadyii mɨbɨjcpɨdɨjc. Chi Pedro ñɨcxy huingbɨ cajp. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Co yxɨɨmɨɨy, huin'it soldadtɨjc ajcxy ooy ytɨgɨɨy huambɨ jɨhuɨɨybɨ huinmay'ahuɨdijty, com ca' nejhuɨɨygɨxy nej je' anajty tɨ ytunyii tɨ yjadyii mɨɨd Pedro ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Chi Herodes ni'ane'mdɨɨy huen nɨcxy yaj'ixtäy Pedro. E co ca' yajpaty, chi pɨjctzoy tɨy'ajt ma soldado ajcxy huɨdi anajty Pedro tɨ ycuend'adyii. Chi ni'ane'mdɨy huen ajcxy nɨcxy yaj'ögyii. Chi Herodes chooñ jɨm Judea, chi oy chɨnaydacpɨcy jɨm Cesarea. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes janch ymɨjotmätpy anajty je jäy huɨdibɨ tzɨnaayb jɨm Tiro etz Sidón. Chi je Tiro etz Sidón jäy ajcxy ñaygapxɨ nej jëbɨ huingohuägɨ̈huaangɨxy je rey. E ymɨmadac ajcxy co mɨgapxy je Blasto je mɨjtungmɨɨdpɨ maabɨ rey Herodes ytɨjc. E chi ajcxy pɨjctzoy co huen tzip cɨxy naxy, com co ajcxy xɨjc mooc jɨm anajty yajtzoongɨxy ma rey ñaaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chi Herodes agapxtujcy tüg xɨɨ, chi je reyhuit yajtɨgɨɨy, chi ɨñaydac paty ma ycötujctac, chi mɨgapxy ajcxy je jäy. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Chi je mayjäy ajcxy ytɨgɨɨy mɨc capxp mɨydaacp, chi ajcxy ymɨnaangɨxy: ―¡Jada jäy huɨdibɨ capxp, ca' jada yjäyɨty, jadu'n yɨ' nej tüg dios! ");
INSERT INTO mcoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","E huin'ítɨy Huindzɨn Dios y'ángel yajpa'mbejty Herodes, com ca' anajty huindzɨgɨ̈y cömay je Dios. Chi y'o'cy, tɨng je' tzütztaayɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Je Huindzɨn Dios y'ayuc mɨbɨjc'ɨdɨ̈chpy anajty jäy, e yajcapxhuäcxp anajty hueñytɨmma'ámyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Co Bernabé etz Saulo ajcxy ytungmay jɨm Jerusalén, huin'it choonɨ ajcxy jɨm ymɨɨdnɨcxy huɨdibɨ anajty yxɨɨ Marcos. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ma je' ajcxy huɨdi mɨjpɨdacp Jesús jɨm Antioquía, jɨm anajty jadyii huɨdi Dios y'ayuc yaj'ixpɨjcp anajty, etz nañ huɨdibɨ tɨy'ajt najtzcapxɨɨyb. Jɨm anajty Bernabé etz Simón, huɨdi anajty ajcxy ytijpy el Negro, etz Lucio huɨdi tzoon Cirene ñaaxjot, etz Manaén huɨdi tüg yeectac mɨɨd Herodes, huɨdibɨ ane'm jɨm Galilea, etz Saulo. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tüg xɨɨ ajcxy ñayyöymújcɨgɨxy jaygay jay'ügy Dios ojadajtcɨxy. E chi je Espíritu Santo ñɨmaayɨ: ―Huen pɨdáacɨgɨch ajcxy Bernabé etz Saulo ahuing jɨgɨx ajcxy ytunɨpy ma je tung tɨɨbɨ nyajnihuohuɨ̈yɨch. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chi ajcxy yjacDios'ojadajty etz yjac'ayuu'ajty, e chi je jäy ajcxy cɨ̈nïxajy Bernabé etz Saulo, e chi ycapxycɨjxy mɨɨd je' ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Chi jada' je Espíritu Santo yquejxɨ Bernabé etz Saulo huen nɨcxy Seleucia, e jɨm ajcxy ybarcotɨgɨɨy nɨcxy ajcxy jɨm Chipre mejy agujcpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Co jɨm ajcxy yja'ty ma barco yjättac huɨdi yxɨɨ Salamina, chi ytɨgɨɨy Jesús y'ayuccapxhuäcxp ma je judíojäy ajcxy naymujctac. Tzooñ je Juan anajty nañ jadu'n je' anajty Bernabé etz Saulo pubéjtɨp. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Huɨdijttay ajcxy ma je naax mejy'agujcpɨ, e yja'ty ajcxy ma je cajp huɨdi yxɨɨ Pafos. Jɨm ajcxy paty tüg judíojäy huɨdi anajty yxɨɨ Barjesús, hue' je' anajty huijyjäy, e ñaydijyii anajty co Dios ytɨy'ajt najtzcapxɨɨyɨ, e ca' anajty yjanchɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Je huijyjäy ooy mɨɨd ñaymɨgüg'adyii anajty je huɨdibɨ ane'm jɨm, hue' anajty yxɨɨ Sergio Paulo. Je Sergio Paulo ooy anajty ycohuinma'ñɨty, ooy y'ixpɨ́cyɨty. Chi ni'ane'mdɨy co huen nɨcxy yajtzonyii Bernabé etz Saulo. Com je Sergio Paulo anajty mɨdoohuaanɨ je Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Je huijyjäy, huɨdi nañ jadu'n yajtijp Elimas, mɨdziptzoñ Pablo etz Bernabé, e tüccɨ'y capx'aduga'ñ ca'ydɨ je gobernador ymɨbɨcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Chi Saulo, huɨdibɨ nañ jadu'n yajtijpy Pablo, mɨɨd je Espíritu Santo huindɨɨcxpejty je huijy jäy, e nɨmay: ―¡Ooy mjɨbɨcjäyɨty miich, ooy m'anɨɨjɨty, mujcu' miich xy'ung'ajtp, ooy mmɨdzip'aty pɨnjaty oyjot oyhuinma'ñ mɨɨd! ¿Mɨna m'ixmadza'ñ nej mdzachyajtɨgoya'ñ je Huindzɨn Dios ytɨy'ajt? ");
INSERT INTO mcoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jadachambɨ je Huindzɨn Jesús xychachytunaamb, e mhuɨ́'mɨp huiintz, etz ni ca' je xɨɨmbɨ tzojc m'ixɨpy. Chi je huijyjäy mɨc'amy yhuɨ'my huiintz coodz, chi ixtay pɨn oc-huijtznɨcxɨɨb com ca' anajty y'oc'ijxnɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Co je gobernador jadu'n ijxy, chi mɨjpɨdacy Jesús y'ayuc, e chi ooy jɨhuɨɨy huinmaay nej Pablo nimɨydägy je Huindzɨn Jesús y'ayuc ytɨy'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chi Pablo etz ymɨgügtɨjc ajcxy mɨɨd ybarcotɨgɨɨy, chi ajcxy ñɨcxy Perge ma Panfilia ñaaxjot. Chi Juan puyöyduutnɨ Pablo etz Bernabé, e chi ñɨcxnɨ Jerusalén. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo etz Bernabé ñajxy jɨm Perge oyja'tcɨxy jɨm Antioquía ma Pisidia naaxjot. Sábado xɨɨ ajcxy ytɨgɨɨy ma je judíojäy ajcxy ñaymujctac, chi ajcxy ixtactay. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Co ñecycapxtay ma Moisés ñecy etz Dios y'ayucnajtzcapxɨɨybɨ ñecy, chi je naymujctac huindzɨn quejxy ayuc ma Pablo ajcxy, ñɨmaayɨ: ―Mɨgügtɨjc, pen mmɨɨd ayuc tɨy'ajt mɨɨd jäy ycɨxpɨ jëbɨ cham myajnɨmäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Chi Pablo ytɨnayɨ̈gy, ycɨ' mɨɨd ytɨy'ajt yecy co huen amoongɨxy, e nɨmay ajcxy: ―Mɨdoogɨx, miich Israel jäy ajcxy, etz huɨdibɨ Dios yajmɨj'ajtp. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Je Israel jäy Dios huin'ijxy ɨɨch'ajt nmɨj'ap nmɨjteedy jecy'ajty etz yajyujcpejt ajcxy mɨcho'n co anajty ajcxy jɨm yjactzɨnäy Egipto ñaaxjot. Chi ajcxy yajpɨdzɨɨmnɨ mɨɨd Dios ymɨc'ajt. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios je' ajcxy mɨhuindɨnay huixchɨguïpx jɨmɨjt jɨm mɨjtɨgɨ̈duum. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Je Dios huixtujc it naax cajp yajtɨgoy huɨdi anajty jɨm tzɨnaayb Canaán ñaaxjot, etz yajmoy je naax ɨɨch ajt nmɨj'ap nmɨjteedy jecy'ajty jɨgɨx ajcxy jɨm chɨnähuɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mɨdaax mɨgo'px jahuixchɨgïpx majc jɨmɨjt Dios mɨc'ajt mooy juez ajcxy huen ane'myii Israel jäy ixtɨ mabaad Samuel je Dios y'ayucnajtzcapxɨɨyb ytungbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Huin'it ajcxy tüg rey pɨjctzoy huɨdi ane'mɨɨb ajcxy. Chi Dios yajreytɨgɨɨy Saul huɨdi tuun huixchɨgïpx jɨmɨjt. Je Saul yteedy hue' je' anajty yxɨɨ Cis, hue' je' anajty Benjamín y'ap y'oc. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chi Dios tungbɨjcy Saul e yajreytɨgɨɨy David, chi Dios ymɨnañ: “Tɨ nbaadyɨch David, Isaí ymang, tüg yëydɨjc huɨdibɨ cuydundähuɨpy nej ndɨmdzocyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ma David y'ap y'oc Dios yajnïbɨjcy Jesús, jɨgɨx nihuänɨpy yajnïdzögɨpy je Israel jäy ajcxy, jadu'n nej anajty jécyɨp Dios yaj'ahuanɨɨy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ca'nɨ anajty Jesús miiñ co Juan, je Bautista, capxhuäcxy Dios y'ayuc ma je Israel jäy ajcxy, nɨmaaygɨxy co copɨcy huen jothuimbijtcɨxy ma Dios, e huin'it jëbɨ ñɨɨbéjtcɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Co anajty Juan y'o'cɨn huingon, chi ymɨnañ: “Ca' ɨɨch njëjɨty je Cristo, jadu'n nej mmɨnaangɨxy. Jayɨjp tɨ nmiiñɨch, jac'axam miina'ñ je Cristo; jacmɨc'ajt mɨɨd je' ca'ydɨ ɨɨch. Ca' xypaadyɨch nɨcxy yɨ' ycɨ̈ghuin nguejɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Chi Pablo yjacmɨnañ: ―Mɨgügtɨ́jc, Abraham y'ɨjx y'oc etz pɨnjaty yajmɨj'ajtp Dios, Dios tɨ xyajniguexy jada ayuc nej ajcxy jëbɨ m'alma nïdzoocɨn paady. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Je jäy ajcxy huɨdi anajty ajcxy tzɨnaayb jɨm Jerusalén etz tungmɨɨdpɨ ajcxy, ca' ajcxy nejhuɨy pɨn je' anajty je Jesús, ni ca' anajty huinjɨhuɨɨygɨxy y'ayucnajtzcapxɨɨybɨ ajcxy y'ayuc huɨdibɨ anajty yajcapxp ma ajcxy ñaymujctac huindüg sábado. E je' ajcxy cɨ'm yajpocycäy Jesús, e cuyduñ nej anajty ajcxy yjaybetyɨty ma Dios ñecy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Oy ajcxy ca' paty pocy nej yaj'öccɨxɨpy Jesús, chi ajcxy nibɨjctzohuɨɨy ma Pilato co huen nɨcxy yaj'ögyii. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Co je jäy ajcxy cuydunday jadu'n nej anajty yjaybétyɨty ma Dios y'ayuc mɨɨd je' ycɨxpɨ, chi ajcxy yajmɨnajcy cruudzcɨ́xy, etz oy yajnaaxtɨgɨɨygɨxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","E Dios je Jesús yajjugypɨjc co anajty tɨ y'ögy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Chi canaag'oc ñayguëxɨ̈go'cɨ ma ymɨgügtɨjc huɨdi anajty tɨ ymɨɨdhuɨdidyii co chooñ Galilea ñɨcxy Jerusalén. Jadachambɨ yɨ' je' ajcxy huɨdi tɨy'ajt yejcpy ma je jäy ajcxy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Je oybɨ ayuc ɨɨch miich ajcxy nyajmɨɨdmɨydacpy cham, huɨdi Dios yajnɨmay ɨɨch'ajt nmɨj'ap nmɨjteedy jecy'ajty. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Je oybɨ ayuc tɨ Dios cuyduñ cham ma ɨɨch ajt co yajjugypɨjcy Jesús co y'o'cy. Jadu'n yɨ Dios y'ayuccojaaybɨ jaay jecy'ajty ma je Salmo necy mɨmetzpɨ ma Dios jadu'n ymɨnañ: “N'ungɨch cham tɨ nyajjuugypɨcyɨch.” ");
INSERT INTO mcoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Mɨɨd jadayaabɨ ycɨxpɨ co Dios tɨ yajjugypɨcy Jesús co y'o'cy, jɨgɨx ñinïcx ca yhuindɨgooyɨpy jadu'n anajty jaybétyɨty ma Dios ñecy ma Dios jadu'n ymɨnañ: “Nmöhuaamyɨch miich ajcxy je conúcxɨn huɨdibɨ nyajnɨmaayɨch je David.” ");
INSERT INTO mcoNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Paady nañ jadu'n Dios y'ayuccojaaybɨ jaay jadüg'it, ma ymɨna'ñ: “Ca' Dios a'ɨxɨ̈y nɨcxy y'ung ñinïcx yhuindɨgooy, je y'ung huɨdibɨ mɨɨd huädz jot huinma'ñ.” ");
INSERT INTO mcoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Com janch co je David Dios huin'ijxy, jɨgɨx ane'mɨpy yɨ' yjuugy ymɨgüg ajcxy. E co ytung yajmay, chi y'o'cy, e je' y'alma ñaybaattɨ mɨɨd je y'ap yteedy y'alma, e je' ñinïcx huindɨgooy je'. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Je Jesús huɨdibɨ Dios yajjugypɨjc ca' je' ñinïcx yhuindɨgooy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mɨgügtɨjc, jëbɨ mnejhuɨɨygɨxy, co je pocyhuinmeecxɨn yaj'ɨɨhuäcxy yajcapxhuäcxy mɨɨd Jesús ycɨxpɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mɨɨd je' ycɨxpɨ pɨnjaty mɨbɨjcp tɨ ypocyyajhuinmeecxcɨxy huɨdibɨ Moisés yley anajty ca'p pocyhuinmeecxɨn yecy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nayguend'ájtɨgɨx, ix xyajcɨdacpejtcɨx je mɨj ayo'n jadu'n nej Dios y'ayuccojaaybɨ jaay jecy'ajty co Dios jadu'n ymɨnañ: ");
INSERT INTO mcoNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Mɨdoogɨx ɨɨch n'ayuc, miich ajcxy nɨxiicpɨ yajxiicpɨ, nay'adzɨgɨ́ɨyɨgɨxy, ix m'alma myajtɨgooygɨxy. Com ɨɨch Dios ndumybɨch tüg mɨjhuinma'ñ ma miich ajcxy mxɨɨ mdiempo. May miich ajcxy ca' mmɨbɨgɨpy, oy pɨn xyjayajmɨɨdmɨydáaccɨxɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Co Pablo ajcxy ypɨdzɨmy ma yɨ judíojäy ñaymujctac, chi je jäy huɨdibɨ ca' yjudíojäyɨty nɨmay je Pablo co huen nañ jadu'n yajmɨɨdmɨydägɨɨyb ma je jadügpɨ sábado. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Co ajcxy yöyhuäcxnɨ ma nayyöymujctac may judíojäy etz mayjäy huidi ca' yjudíojäyɨty huɨdibɨ jɨjptɨgɨyɨɨy je judíojäy y'ixpɨ́jcɨn, panɨcxy ajcxy je Pablo etz Bernabé. Pablo etz Bernabé capxhuijy ajcxy co huen panɨ́cxcɨxy je tɨy'ajt jadu'n nej Dios tɨɨbɨ tuñ may'ajt mɨɨd jäy ycɨxpɨ, e ca' ajcxy ixmadzɨpy. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Co sábado yxɨɨ paty, chi jäy ñayyöymujcɨ jahuenjaty cajp jäy ycanɨcxtay co anajty tzachmɨdoohuaangɨxy Dios y'ayuc. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ca' anajty ajcxy yjotcújcɨty co je judíojäy ajcxy ijxy je mayjäy. Chi ajcxy ooy yjot'ambɨjccoty ni'ojɨɨygɨxy etz nɨmaaygɨxy oy ni nej Pablo. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chi Pablo etz Bernabé ytɨgɨɨy mɨccapxpɨ ymɨnañ ajcxy: ―Copɨcy anajty co ɨɨch miich nyajnɨmähuɨpy Dios y'ayuc jayɨjp. Com ca' mgöbɨgaangɨxy Dios y'ayuc, e co ca' mnaybɨdáacɨgɨxy tudägy ma jugy'ájtɨn mɨɨd huinɨxɨɨbɨ, nɨcxyɨch n'ocyajnɨmäy ajcxy Dios y'ayuc huɨdibɨ ca' yjudíojäyɨty. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Com jadu'n xy'ane'myɨch ajcxy yɨ Huindzɨn Jesús, e xyñɨmaayɨch ajcxy: Tɨ ɨɨch miich nbɨdägy jadu'n nej tüg tɨɨcxɨn jajɨn ma tüg'ócɨy naaxhuiñybɨ jäy jɨgɨx myajnejhuɨ̈huɨpy ajcxy je nïdzoocɨn jɨguembaad huindu'my naaxhuiñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Co ajcxy jadu'n mɨdoy huɨdibɨ ca' yjudíojäyɨty, chi ajcxy ooy nïgɨ yjotcugɨɨy, e chi ajcxy ymɨnandacy co je Huindzɨn Jesús y'ayuc ooy anajty y'óyɨty. E may ajcxy mɨbɨjcy huɨdibɨ anajty Dios tɨ yajnigödungɨ̈y co paatɨp jugy'ájtɨn huinɨxɨɨbɨ. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","E jadu'n jɨm yajcapxhuäcxy Jesús y'ayuc ma je jɨmbɨ naax cajp. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","E je judíojäy ajcxy mɨnaygapxɨ nijëjɨty töxyjäydɨjc ajcxy tudägypɨ huɨdibɨ Dios yajmɨj'ajtp, etz je mɨjjäydɨjc, e je' ajcxy mɨɨd mɨbɨdɨ̈gy Pablo etz Bernabé co pahuojpquëgaangɨxy ma jejɨmbɨ naaxjot. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chi Pablo etz Bernabé ycɨ̈g huinhuojpy, je' je' tɨy'ajtɨp co ca' jäygɨdacy ajcxy nej jäy anajty ytungɨxy. Chi ajcxy ñɨcxnɨ jɨm Iconio. ");
INSERT INTO mcoNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","E je' ajcxy huɨdibɨ mɨjpɨdaacp Jesús ooy anajty ajcxy yjotcujcɨty. E ymɨɨd anajty ajcxy je Espíritu Santo ma yjot yhuinma'ñ. ");
INSERT INTO mcoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jɨm Iconio Pablo etz Bernabé ytɨgɨɨy ajcxy yquipxyɨ ma je judíojäy ñaymujctac, e oy yajxon ajcxy capxhuäcxy Jesús y'ayuc. E may judío etz griegojäy ajcxy ymɨbɨjcy. ");
INSERT INTO mcoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Je judíojäy ajcxy huɨdibɨ anajty ca' ymɨbɨjccɨxy nigapxcoty ni'ojɨygoty ajcxy huɨdibɨ ca' yjudíojäyɨty huen je cajp jäy ajcxy mɨjotmädɨpy je mɨbɨjcpɨdɨjc. ");
INSERT INTO mcoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mɨɨd jada ycɨxpɨ Pablo etz Bernabé yhuɨ'my je' ajcxy jecy etz capxhuäcxcɨxy ajcxy Dios y'ayuc huinmɨc jotmɨc etz je Huindzɨn mɨjotcujc'ajtcɨxy ooy, e mooyɨ ajcxy je mɨc'ajt jëbɨ ajcxy pa'mjäy yajtzögɨpy etz mɨjhuinma'ñ tungɨxy huɨ