﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcfNT_vpl;
CREATE TABLE mcfNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcfNT_vpl WRITE;
INSERT INTO mcfNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Esuquidistu chuiquin dada uanu. Aidën tsusedpa Abadauan nec. Aidën tsusedpabidi Abadauanën tsyuecquid Dabid nec. Abadauanën tsyuecquido chuiquinc aidën tsyuecquid Dabidën tsyuecquido chuiquinc caquin Esusën tsusedpabotedi chuinu. Tantia. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abadauanquiobi bedanquin chuinu. Abadauanën mado Isac cuëmëdpampic. Isaquën madobic Acobo cuëmëdquid. Acobon mado dadpen icpampic. Abentsëc Uda cuëmëdnuc aton buchiado utsi-utsiec cuëmëdpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Adnubien Acobon mado Uda caidën Tamad caid abentsen chudpampic. Aden chudaqui bacuë daëd usundoshon abi ushëmbi aton mado daëdpambo tishpampic. Abentsëc Pades cuëntanquin utsi Sada cuëmpampic. Padesën mado Eston cuëmëdpampic. Estonën madobic Adan cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Adanën madobic Aminidad cuëmëdquid. Aminidadën madobic Nason cuëmëdquid. Nasonën madobic Sadmon cuëmëdquid icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Adshumbic Sadmonën aton chido Daba bedshun aton mado Bos tishmepampic. Adoac canishumbi Bosën aton chido Dud bedshun aton mado Obed tishmepampic. Obedën mado Isai cuëmëdquid icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Adshumbic Isain aton mado Dabid isadaidbo chuiquid dapambo tishmepampic. Adoac canishumbic Dabidën dada utsi Udias caid cuesunetanquin aton chido bedshun aton mado Sadomon tishmepampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sadomonën mado Doboan nepampic. Doboanën madobic Abias cuëmëdquid. Abiasën madobic Asa cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asan madobic Osapad cuëmëdquid. Osapadën madobic Odan cuëmëdquid. Odanën madobic Usias cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiasën madobic Otan cuëmëdquid. Otanën madobic Acas cuëmëdquid. Acasën madobic Esequias cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esequiasën madobic Manases cuëmëdquid. Manasesën madobic Amon cuëmëdquid. Amonën madobic Osias cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Osiasën madobic Econias cuëmëdquid. Aid Econias caid aton matsesadobëdtabi yuanuen Babidonia yacnocquidon aton nidaidën buampampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Buanac shubu dadpen icquid Babidonia caid yacnoshon Econiasën aton mado Sadatied tishmepampic. Sadatiedën mado Sodobabed cuëmëdpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sodobabedën madobic Abiud cuëmëdquid. Abiudën madobic Ediaquin cuëmëdquid. Ediaquinën madobic Asod cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asodën madobic Sadoc cuëmëdquid. Sadoquën madobic Aquin cuëmëdquid. Aquinën madobic Ediud cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ediudën madobic Ediasad cuëmëdquid. Ediasadën madobic Matan cuëmëdquid. Matanën madobic Acobo cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Acobon madobic Ose cuëmëdpac caondash. Aidquio Madian bënë nepac caondash. Aidën inabi Madian Esus usundoshon tishpac caondash. Esus Nuquin Papan chomiaid yec matses bëdambo icmequidquio nec. Isadaidbon cainaidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aidtedi Esusën tsusedpabo icpampic. Abadauamba bedanquin aton matses 14tedi chuiquin Dabid ënquin chiombi. Adoshombic Dabid ënquin chuiboed chuioaquin padpiden bedanquin aidën matses 14tedbidi chuiquin Econias aton matsesbëdta buanaid ënquin chiombi. Adoshombic Econias ënquin chuiboed chuioaquin padpiden bedanquin aton matses 14tedbidi chuiquin Esusquiobi ënquin chiombi. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nëbi aid tishaidquio chuinu. Esus tishabi yec aton tita Madia icpac caondash. Abi inuequidën Osen bedabi icshobi Nuquin Papan Mayanën bacuë usundomepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Usundoacsho isun abi inuequidën Osen dada utsin chudaid danec: —“Nëbi mibi bedtiapimbo iquebi,” quequin bedenquio icnuen dada uashun Madia menenu —queuidpac caondash. Nuquin Papan chiacpadquio bëdambo icquid icquin naden chiambo icpac caondash. —Bedabi bacuë usundoaque. Cuidquimbien ictiad —quequin aton matses chienquio yequi: —Bedenquio icnuen dada uaid menenu —queuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Adnubien Nuquin Papan abi yacnoshon uaidën mayan bëdan Ose ushquin ismepac caondash. —Dabid yampidën tsyuecquid icsho mibi chuinu, Ose. Tantia. Chudenquio icquin Nuquin Papan Mayanën Madia bacuë usundomiaye. Dacuëdenda. Dacuëdenquio icquin Madia min shubuno buanta. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Adoshombic dada bacuë tishacsho Esus cuënta. “Matses icsaid bedshunquin Nuquin Papa aton matses cuidmenquio iquendac,” quequin Esus cuënta —quequin mayan bëdan Ose ushquin ismepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aden mayan bëdan Esus tishte chiacpadomboen Nuquin Papan ambi chiaid naden dada uamepampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dadan inacmaidëmbi bacuë usundoshon dada bacuë tishendac. Aidi Imanued cuënendac. ‘Nuquin Papapadquidquiobidi matsesbëd tabadnuec choash nec,’ quequin Imanued cuënendac,” quequin Esus tishte Nuquin Papan dada uamepampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aden mayan bëdan chiac isucunshumbien aidën chiacpadomboen Osen aton shubuno Madia buampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Buanshun Osen chudenquio icnubi dada bacuë tishpac caondash. Tishacsho Esus cuëmpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nidaid Udeya caid yacno tabadquin shubu daëdpactsëcquid Beden caid yacnoshon Esus tishpac caondash. Adnubien shubu dadpen icquid Edusaden caid yacno isadaidbo matses ancaquid Edodes cuëmëdquid icpac caondash. Aid icnubi matses utsibo uispa isquido Esus isnuec ushë choacmiuësh chopac caondash. Edusaden yacno choquin ");
INSERT INTO mcfNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","anocquido chuituidpac caondash. —Min matses isadaidbo chuiquid dapa ictequidquio nëbi tishtsaidëmpi ¿midambo ictseque? Isnu. Aid tishaid tantiamete uispa isombique. ¿Mitsimbo ictseque? Isnu. “Chuiquid dapa bëdamboshë ictequid nec,” quiash aid isnuec chopobi —quetuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Adsho tantiash dacuëdcuededpac caondash abitedimbo. —Padtec. ¿Midapadquid bacuë nependabac? —quecuededpac caondash Edodes isadaidbo ancaquid ambi ancaidobëdi. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Adshumbien Edodesën abi yacno tsusiobo cho-chomepac caondash. —¿Mitsicquid caique? Tantianu —queshun abi yacno Moisesën dada uampid chuibanquido abi chuiquid dapabobëdta cho-chomepac caondash. Cho-chomeshumbic: —¿Mitsishunquio Nuquin Papan chomiaid min matses chuiquid dapa ictequid tishpash? ¿Ada Nuquin Papan chiaid isbanquin tantio? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Ai, tantiembi. “Nidaid Udeya caid yacno tabadquin shubu daëdpactsëcquid Beden caid yacnoshon aid bacuë tishendac,” quiampicpadembi tantiembi. Nuquin Papan ambi chiaid nuquin tsusedpa dada uamepampic naden. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Shubu daëdpactsëcquid Beden caid yacnocquido chiec: “Beden yacno tabadec nidaid Udeya caidën tabadquido mibi nec. ‘Chuiquid dapa nibëdnuc icsambo iquendac,’ quedenedi mibi yacnoshon chuiquid dapa ictequid tishendac. Aidëmbi isadaidbo matses chuiquid dapa icquin bëdamboen tabadmendac,” —quequin Nuquin Papan Esus tishte chiaid chuipac caondash tsusiobon Edodes caid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Adoaquien Edodesën ambi ancaido isadaidbo ismenquio icquin matses utsibo uispa isquido chomeshun chuimepac caondash. —¿Nëbida tishaid tantiamete uispa isquin tauao? ¿Nëid inchëshën ushëmbida isbeno? ¿Ëndenda isbenonda? En chui. Tantianu —cac chuisho ");
INSERT INTO mcfNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","tantiashun: —Beden yacno istan. Ano nidshun mimbi chiacpadquid bacuë istan. Aid bacuë istanec cuenquin ëbi chuibenta. Ëmbitsen istanu. “Nuquin Papan chomiaid chuiquid dapa ictequid bëdambo iquec,” quequin ëmbitsen istanu —capac caondash Edodesën muaquimbi. —Cuesunenu —quequimbi adopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Adoaquien ushë choacmiuësh bed-bedquesho ambi isbëquin tsibambëboedi uispa tsibanec Beden yacno nidpac caondash. Adec nidnubien uispa shubu ismec nidtuidpac caondash: —Bacuë ictsaid shubu nëid iquec —quec. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Adsho isashien cuishonquepac caondash uispa isquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Adash shubun puduedshun isquien aton tita Madiabëd bacuë ictsec. Aid isashic: —Matses chuiquid dapa ictequid nec. Matses bëdambo icmetequid nec —quequin aton matsesën nacpadomboen ismequin danëshën sebudpac caondash. Adshumbic ambi bëboed aton na bëdambo icquid chicshun menepac caondash nëidtedi. Nëidic shocosh piu. Nëidic bëdambo nuadnuc tauitequid. Nëidic bëdambo noadec danoshquete. Aidtedi menepac caondash. Adoash ushtopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Adec ushtoacsho Nuquin Papan ushquin ismepac caondash. —Isadaidbo ancaquid Edodes chuibidanenda —quequin ushquin ismiac isucunanec abi choboedën nidenquio yec podqued utsin nidpac caondash aton shubuno nidec. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Esus isuanquido nidambien Nuquin Papan abi yacnoshon uaidën mayan bëdan Ose ushquin ismepac caondash. —Isucunanec cuenta. Bacuëmpi aton titabëdta buanec nidaid utsi Equipito caid yacno cuenta. Ëmbi chiabi choenda. Anobi tabadta. Edodesën: “Bacuëmpibo cuesun siatanta,” cac cho-choeque. Cuenta —quequin Ose ushquin ismepac caondash mayan bëdan. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aden ushquin ismiac isucuntantsequi inchëshëmbi puduanec aton bacuë anibëdta buanec nidaid utsi Equipito caid yacno Ose nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Equipito yacno nidash ambobi tabadpac caondash. Isadaidbo ancaquid Edodes unësabi icnuc Equipito yacno tabadpac caondash. Esus tishabi icnubi ëndenquimboshë Nuquin Papan tantiamiac ambi chiaid chuibanquidën Esus Equipito yacno buante chuiquin dada uapampic naden chuiquin. “Equipito yacno nidash tabadsho: ‘Auëshquio cho, Mado, caindambi,’ quiosh Nuquin Papa,” quequin Nuquin Papan chiaid dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Adnubien isadaidbo ancaquid Edodes: —Uispa isquidon cacuidposhi —quiash comapenec nëishun aton yuabo sondado chuipac caondash. —Uispa isquidon chuibocpadtsëcquid comapenec onquecuenabi ictsëcquidotedi dada bacuëmpibotedi cuesun siatan. Beden yacnocquidon bacuëbobëdtabi uano pauequidon bacuëbotsen cuesun siatan —cac cuesun siatampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aden cuesun siatanambo icnubi Nuquin Papan adote chiaid ëndenquimboshë Edemias cuëmëdquidën dada uapampic naden chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Abi yacnuësh aton bacuëbo nibëdansho isash isadaidbon chidobo sedenquecuededendac. Unësaid tantiec baded ënëdenquio yec sedenquebudnendac,” quequin chiampicpadomboen aton bacuëbo nibëdamepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yuecquio ictaniashic isadaidbo ancaquid Edodes caid unëspac caondash. Adambic nidaid utsi Equipito caid yacno tabadsho Nuquin Papan abi yacnoshon uaidën mayan bëdan Ose ushquin ismepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—“Bacuëbo cuesun siatan,” quiondaid unësaccoshe. Min chido min bacuëbëdta buanec min nidaid Isadaid caidën nidoata —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","isucunanec aidën chuibocno buanuec nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aton nidaidën nidshun aton matsesën chiaid tantiapac caondash. —¿Ada tantio? Udeya yacnocquido ancadened unësaidën mado Adquedayo caid ancanquidquiobidien nechitec —quesho tantiashien dacuëdtampac caondash Ose. Adshobien Nuquin Papan Ose ushquin ismeoapac caondash. —Cuesunenushe. Min nidaid Udeya caidën nidenda —quequin ushquin ismiac isucunanec aid nidaid Isadaid caidëmbidi nidec aid nidaid cuëshë utsi Cadidia caidën nidpac caondash. Udeya caidën nidenquio yec uquëmbo nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Uquëmbo nidec shubu dadpen icquid Nasaded caid yacno choash ambo tabadtuidpac caondash. “Nasaded yacnocquid nendac,” quequin Nuquin Papan chiaid dada uampicpadec anobi tabadpac caondash. Auëshquio canipac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Adash yuecquio ictaniashien Uan caid Nuquin Papa tantiabenquido acten mentoquid icpac caondash. Nidaid Udeya caid yacno shubu nibëdacno capucuenequin Nuquin Papan chiaid chuibenequid nepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Adquid icquin Esus chote chuibampac caondash naden. —Mibi icsaid ënash bëdamboec tabadta. Nuquin Icbombo choeque —quequin chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aden Uanën chuite chuiquin Nuquin Papan isadaidbo tsusedpa Isayas cuëmëdquid dada uamepampic naden. “Masiuidpambo yacno shubu nibëdacno capuquin ëcac matses chosho chuibenendac. ‘Chuiquid dapa choeque. Podqued andëdbanshunta,’ quiacbimboen: ‘Nuquin Icbombo choeque. Icsaid ënash bëdamboec tabadta,’ quequin chuibenendac,” quequin Isayasën Uanën chuite chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nadquid Uan icpondash. Aton dashcute nëish yua dapa cameyo caidën bu daëdcaid dasiuidpondash. Tsipantebic nidaidën capuquid yua bitsi nacnenaid tsiupondash. Aton pete bacumbëd shioshbimboecquid icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aidën Nuquin Papan chiaid chuibenesho tantianuec nëidtedi matses cho-chopac caondash. Nëidic shubu dadpen icquid Edusaden caid yacnocquido. Nëidic nidaid Udeya caid yacnocquido. Nëidic acte Odan caid cuëman tabadquido. Aidtedi cho-chopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cho-choshon Uanën chuisho tantiash: —Nuquin Papan chiaid niac-niaquec icsapobi. Icsaboedi aid tantiec bëdamboec tabadtiadquio iquebi —quesho: —“Nëid Nuquin Papa tantianu,” quequid nec —quequin acte Odan caidën mentopac caondash Uanën. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Adnubien padiseyobobëd saduseyobo Uan isec cho-chopac caondash. Padiseyobo isadaidbo tsusedpabon chiaid namequido nec. Saduseyobobic: —Matses unësaid uincuenenquio iquendac —quequido nec. Aido cho-chosho isun Uanën: —Nisibimboecquido mibi nec. Adquidën icsa uacbimboen matses icsa uaquido mibi nec. Bëdambo icquid damianquiec mibi iquec. “Nuquin Papan mibi cuidnushe. Tantiatan,” quequin ¿tsuntsin chiac cho? ");
INSERT INTO mcfNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mentomete bunec Nuquin Papan chiaid niac-niacboedi ënash bëdamboec tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Ëbipadquid Abadauanën tsyuecquidouidtsëqui Nuquin Papan bëdamboen isec,” quequin tantienda. ¿Adquidta Nuquin Papan bëdamboen ispec? Abadauampadquid abi tantiaquidien Nuquin Papan bëdamboen isec. Mimbi bëdamboen tantiatiapimbo icsho isun nëid cuënotebi matses uashun Nuquin Papan Abadauampadquid abi tantiaquidombo icmetsiash icnushe. Nuquin Papambo tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Icsambo icquid nec,” queshun ambi nitsinaid cuëte bacuëesa dëdshun nëdëncacbimboen ambi chiacpadomboen naisa Nuquin Papan cuidendac —quepac caondash Uan padiseyobo saduseyobobëdta chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Adshumbic padpiden chuiquin Esusën nate chuipac caondash. —Nuquin Papa tantianuequid acten mentobanquin chuibanquid nebi. Padnuen con tsyuecquid choshon aidëntsen chuibanendac. Ëbi bëdiactsëc tantiaquid ictsëcnuc aidquien comapenen tantiaquidquio yec bëdamboshë iquendac. “Aidquio bëdamboshë icquid icnuc ¿atotsieshun icsaquidquiobi: ‘Aid choec,’ quequin chuiquidquio Nuquin Papan ëbi icmeposh?” quec tsadebi. Ëmbi chuiboed choshon: “Ëbi tantiaquid nec,” queshun aton Mayan menequin bëdamboec tabadte mibi tantiamendac. Abi tantiesaboen cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Piacbo choeshashun putu bushcaquin secacbimboen abi tantiesabo chian anëdënquiacno nësecaindac. Adshumbic abi tantiaquido abëdi tabadmendac —quepac caondash Uan acten mentoanquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Acte Odan caidën matses mentoec adpac caondash Uan. Adnubien Uan yacno Esusquio chopac caondash. Aton nidaid Cadidia caid yacnuësh tauamboen matses ismenuec choec: —Ëbitsen mento —quetuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Adshobien Uanën: —Padenquio iquembi. Nuquin Papan chomiaid icquin mimbibi ëbi naquien bëdambo ictsiash. ¿Atotsieshun ëbi aden chie? Padi —queshobien: ");
INSERT INTO mcfNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—En na. Bëdambo iquec. Ëbi mentoquin mimbi Nuquin Papan chiacpadomboen natsiaque. Ëbi acten mento —quesho tantiashun Esus acten mentopac caondash Uanën. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Adoac Esus pudundonobien canchedacbimboec abu shëcuë yampac caondash. Adsho isaquien aid shëcuë yacnuëshquio dëbimbimboec budec Nuquin Papan Mayan Esusquio matsadtopac caondash abëd icnuec. ");
INSERT INTO mcfNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Adnubien abucuëshquio Nuquin Papa onquiampac caondash. —Nëid ëmbi tantiaidquio con Mado nec. Ëmbi chiacpadomboen nasho isash bëdambo iquebi —quepac caondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Uanën acten mentobocshobien Nuquin Papan Mayanën masiuidpambo yacno matses nibëdacno Esus nidmepac caondash. —Ma Nuquin Papa chieshënquid Satanasën Esus icsamenuequin ma tanu —quequin ambo nidmepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Adoaquien buna mëmunquin penquio yec Esus tsadpac caondash. Inchëshën ushë abentsëc nidmiash utsi tashquecuntsëcnuc 40tedec ushquin penquio yec comapenec bumpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bunec tsadshobien Satanasën istuidpac caondash. Istuidtanquimbien: —¿Nuquin Papan Madombobida mibi neque? Aidën Madombo icquin nëid cuënote cain: “Pete icta,” cata —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Esus: —Padi. Nuquin Papan chiaid dada uapampid nad iquec. “¿Peteuidi tantiecta matses bëdamboec tabadpec? Nuquin Papan chiacpadomboenuidi naiquien matses bëdamboec tabadtsiash,” quequin dada uapampid iquec —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Adsho tantiashumbien shubu dadpen icquid Edusaden caid yacno buanshun Nuquin Papa tabadte shubu uashunaid macano Satanasën Esus manidtomepac caondash abucquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Adotanquimbien padpiden chuioaquin: —¿Nuquin Papa caidën Madombobida mibi neque? Aidën Mado yec nëuëshquio pudunta. Nuquin Papan mibi paëdmenquio ictsiashe. Nadentsen Nuquin Papan chiaid dada uapampic. “ ‘Uidën uata,’ quequin ambi abi yacnoshon uaido mayan bëdabo Nuquin Papan chiac mibi uidën uaindac paëdenquio icnuc. ‘Cuënoten tadquëdnushe,’ queshun adoendac,” quequin Nuquin Papan chiaid dada uapampique. Pudunta —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Esus: —Padi. Nuquin Papan chiaid dada uapampid nad iquec. “ ‘¿Icsamboen tantiaquin ëmbembi nashodabi Nuquin Papan cuidpatsiashe? Tanu,’ quenda,” quequin dada uapampique. Padi —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Adoaquien Satanasën padpiden buanquin macuësh dapa abucquiocquid manidtomeshun nidaid abichobi Esus ismepac caondash. Chuiquid dapabotedi ismequinc aidobëd icquido ismequinc aidon dayun uaidtedi ismequinc capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Adoshombic: —Nëidtedi mibi menetsiambique. Ëbi con icbo cata. Ëbi aden chuiquin ismenuen danëshën sebudta. Adsho isun ëmbi ismiactedi mibi menembi. Aidën icbo mibi icmembi —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Esusën: —Padi. Baded cuenta. Nuquin Papan chiaidquio chuiquin naden dada uapampique. “Nuquin Papa abentsëcquiobi mimbi tantiaiduidtsëqui min Icbombo neque. Aidën namiaidquio icta,” quequin dada uapampique. Cuenta —capac caondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Adoaquien Satanas cuempac caondash. Cuenubien Nuquin Papan abi yacnoshon uaido mayan bëdabo choshon abëdi tabadquin Esus bëdambo icmepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Adashic aton nidaid Cadidia caidën Esus nidpac caondash. —Mibi acten mentondaid Uan bedshun quënën nauedac caosh —quesho tantiash nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nidashic shubu dadpen icquid Nasaded caid yacno tabadash nidec chian dapa cuëman shubu dadpen icquid Capednaun caid yacno nidash anotsen tabadoapac caondash. Aid nidaid Netadi capampic. Aid anoentsëqui icquid nidaid utsi con tsusedpabon Sabudon capampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Esus ambo tabadte chuiquin Nuquin Papan con tsusedpa Isayas cuëmëdquid dada uamiampicpadec ambo tabadpac caondash Esus. Naden dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nuquin Papa tantiamequidën chuisho nëidtedishun tantiendac. Nëidic nidaid cuëshë utsi Netadi caidën tabadquidon. Nëidic nidaid cuëshë utsi Sabudon caidën tabadquidon. Nëidic chian dapambo anoentsëqui tabadquidon. Nëidic acte dapa Odan caid cuëman tabadquidon. Nëidic isadaidpembo dadpen tabadacno Cadidia caidën tabadquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Aidtedishun Nuquin Papan chomiaid tantiendac. Pabiate cuënëdacbimboec icsamboec tabadquin Nuquin Papa tantienquio icboedombi tantiabenendac. Nuquin Papa tantiamenuen chuibansho tantiashun matsesën paposhquiacbimboen Nuquin Papa tantiabenendac. Abi tantienquio icsho Nuquin Papan cuidtsenaidombi Nuquin Papa tantiabenendac ushash isucunacbimboen,” quequin Isayas Esus choash tabadte dada uamepampic Nuquin Papan. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ashunquiobi Nuquin Papan chiaid chuiquin tauamboen Esusën matses abitedimbo chuibenepac caondash. —Icsaid ënash Nuquin Papa tantiec ambi chiacpadec bëdamboec tabadta. Nëbi Nuquin Papan abëd tabadtequido icmequin matses bëdamboen tabadmendac —quepac caondash Esus ambibi naid chiequi. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aden chuibenec chian dapa Cadidia caid cuëman nidquin isquien dadan aton utsibëdtambi nëshaid dapambo acte nënepec. Aid Simombidi Petedo capec. Aton utsi Andedes nec. Aid daëdshun nuëcquid bedquidombo icquin aton nëshaid acte nënesho istuidpac caondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Adshumbien Esusën: —Nuquibi icnu. Cho. Nuëcquid bedquid icboedi nëbi ëbi chuibanquid mibi icmenu ");
INSERT INTO mcfNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","—caquien aton nëshaid nianec nidquimbi Esus tsibanampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Udictsëc nidquin isquien dada daëd cano antabëdpec. Acobo aton utsi Uambëd icpac caondash. Aton papa Sebedeyo caidbëdi cano antabëdquin nuëcquid bednun aton nëshaid dapa nacnempac caondash. Adsho istuidshun Esusën: —Nuquibi icnu. Cho —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aton papabëdta cano nianec Esusbëd icnuec nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Adashic aton nidaid Cadidia caid yacnobi capucuenec Nuquin Papan chiaid chuibante shubun-shubunquiec puduedcuenequin Esusën Nuquin Papan chiaid chuibenepac caondash. Abi yacno tabadmenun Nuquin Papan bëdamboen iste matses chuibeniac caondash. Adshumbic daicsaidotedi bëdamebampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Adosho istanquin: —Bëdamequidquio nec —quequin isboedon Esusën naid chuibenepac caondash. Ënapen nidec nidaid utsi Sidia caidën nidshun chuibeniac caondash. Aden chiac daicsaidotedi bë-bëpac caondash. Dada paëmboshë icquido yec podobitsi icsa dapuduedaido yec unësanequido yec dada shëquëquenquio icquido yec quenuc bë-bëacsho aidtedi bëdamepac caondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aden: —Bëdamiosh —quequin chiac isec cho-choash dadpenquio tsucus-tsucustsëcquio yec tsidadash niquianquin Esus tsibanampac caondash. Nëidtedshun tsibananac caondash. Nëidic nidaid Cadidia caidën tabadquidon. Nëidic shubu dadpen icquid Decapodis caid yacno tabadquidon. Nëidic shubu dadpen icquid Edusaden caid yacnocquidon. Nëidic nidaid Udeya caidën tabadquidon. Nëidic acte Odan caid uquë cuëma utsiuc tabadquidon. Aidtedshun Esus tsibanampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Matses dadpenshun tsibananac macuësh dapa cuëte nibëdpamboecquid pudundoec poctsebi Esus tsadtuidpondash. Abi tsibananash matses dadpen abi datsidadnubien abëd icquido Esusën dayunquio tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Adshobien Nuquin Papan matses bëdamboen isquin bëdambo icmete Esusën matses abitedi chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—¿Mitsipadquid Nuquin Papan bëdambo icmepec? Nadquid caimbique. Tantia. Mibitedi chuinu. “Ëbembi bëdamboec tabadtiapimbo iquebi. Bëdapenquio iquebi. Nuquin Papan bëdamboen tabadmiaquini bëdamboec tabadtsiac,” quequid Nuquin Papan: “Ëbëd tabadtequid nec,” quequin bëdambo icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Matses abitedi icsamboec tabadnuc ëbitsen icsamboec tabadquid nebi,” quec shubiquimbi abi tantiasho Nuquin Papan bëdamboen isquin bëdambo icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aton nauidi tantienquio icquin Nuquin Papa tantiaquin utsibotsen tantiaquid Nuquin Papan bëdambo icmendac. Yuecshun ambi nidaid chuca uaidën tabadmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pete bunacbimboec ambi chiacpadec bëdamboec tabadte bunquid Nuquin Papan bëdamboen tabadmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Abi chieshënquidi chieshënenquio icquin bëdamboen isquid Nuquin Papan bëdamboen isendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ambi chiacpadomboenuidi nate bunquid Nuquin Papan bëdambo icmequin abibi bëismendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aton matses chieshënansho isash: “Padi. Chën. Bëdamboequien tabadtiad,” quequid Nuquin Papan bëdambo icmequin con mado caindac. Adquidbidi adembidi con champi caindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nuquin Papa tantiec bëdamboec tabadsho utsin chieshënaid Nuquin Papan bëdambo icmequin unësacsho abëdi tabadmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Esus tantiaquid nec,” queshun utsin mibi chieshënquin chiacsho Nuquin Papan abëd tabadmenuen mibi bëdambo icmendac. Mibi cueso adembidi mibi bëdambo icmendac. Adembidi mibi muauasho Nuquin Papan mibi bëdambo icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aden utsibon: “Esus tantiaquid nec,” queshun chieshënaqui cuishonqueta. “Ënden tsusedpabon Nuquin Papan chiaid chuisho chieshënquin cuesunepampic. Adoacsho Nuquin Papan bëdamboen isquin abëdi tabadmec. Adembidi utsibon chieshënacsho ëbi bëdamboen isquin unësacsho abëdi tabadmendac,” quiash cuishonqueta —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Abi macuësh dapa poctse tsadquin Esusën chuibampondash. —“Ma utsibontsen Nuquin Papa tantianu,” quec sa pambid casecac batambo yec petiadquio yacbimboec icta. Aden Nuquin Papan chiacpadec bëdamboec tabadquin mimbi utsibo bëdamboec tabadte bumetsiac. Sa batambo icquid bëdambo iquec. Sa batambo icboedi batapenquio yec icsasho ¿mitsipadentsi batambo icmeoapec? Adotiapimbo iquec. Sa icsambo yanacsho penquio icquin secatequid nec. Adembidi matses bëdamboec tabadenquio yec icsambo icsho Nuquin Papan chian anëdënquiacno nësecatequid nendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Adashic padpidec onquec: —Nuquin Papan chiacpadec bëdamboec tabadte utsibo tantiamequido mibi neque. Aden tantiamenuec bëdamboec tabadta. ¿Nuntanshunda ëapadic? Padenquio. Umanucshumbien ma tantianueshun ëaquid. Adembidi: “Ma Nuquin Papan chiacpadec tabadte tantianu,” quiash ënëdenquio yec bëdamboec tabadquin ismeta. Adsho isash: “Nuquin Papa tantiec bëdamboec tabadquid nec,” quetsiash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","¿Utsibo chuinuecta abentsëqui uano icpadic? Padenquio. “Ma nëidën tantianu,” quec aidbëdi bëdamboec tabadquin chuibanquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Adembidi ëbi tantiesabobëd tabadquin: “Ma Nuquin Papa tantianu,” quequin ënenquio icquin Nuquin Papan chiacpadomboen nata. “ ‘Nuquin Papa bëdambo iquec,’ ma utsibotsen quenu,” queshun adota —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nadentsen Esusën chuipondash. —Ëmbi chuibansho tantiashun: “Nuquin Papan chiaidquio chienquio iquec,” quequin tantienda. “Nuquin Papan Moises dada uamiampidbëdta con tsusedpabo utsibo dada uamiampid chienquio icquin utsi uapec,” mimbi ëbi capec. Mambi utsi uainquio yoc. Nuquin Papan chiaid utsi uainquio icquin ambi chiactedimbo namenuec nebique. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Abimbo chuinu. Tantia. Abubëdta nidaid nibëdamiabi icnuc Nuquin Papan chiaid bënudtiapimbo iquendac. Ambi chiactedimbo naquin Nuquin Papan nainendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Padnubic Nuquin Papan: “Nadomboen nata,” quequin chiaid abentsëqui niacquin aid chiaidbidi adomboembidi niacmequid Nuquin Papan: “Bëdambo icquid nec,” catiapimbo iquec. Utsibic Nuquin Papan chiacpadec tabadec: “Nuquitsen bëdamboec tabadnuna,” quequid abi yacno nidacsho Nuquin Papan: “Bëdamboshë icquid nec,” caindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moisesën dada uampid chuibanquido padiseyobobëd Nuquin Papa yacno puduedtequidoen mimbi dampec. Aido bëdambo icquid damianashi ompodash icsaic. Adashic Nuquin Papa yacno puduedtiapimbo iquendac. Adembidi Nuquin Papan chiaid niac-niaquec adecbidi Nuquin Papa yacno mibi puduedtiapimbo iquendac. Nuquin Papa tantiec bëdamboec tabadquidien puduedtsiash —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Adshumbic Esusën padpiden chuioapondash. —Nuquin Papan chiaid chuiquin isadaidbo tsusedpabon: “Cuesunenda. Cuesunianquid Nuquin Papan chiacpadomboen matses cuidte chuiquidën cuesunemequin cuidquid,” quequin chuipampid mimbi tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Nadquidotsen cuidtequido nec,” quequin chuinu. Tantia. Aton matses nëishënash aton nëish bëdanenquio icsho Nuquin Papan cuidtequido nendac. Utsibic chieshëmënec icsamboec cuëmënquido isadaidbo tsusiobon cuidacsho isun: “Bëdamboen naic,” catsiambi. Nëidic aton matses chieshënquin shëpiaquid Nuquin Papan icsano nësecaquin cuidtequido nendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Chieshëmënquid Nuquin Papan cuidtequid nendac,” quequin ëmbi chuisho tantiashun bëdamboen nata. Nuquin Papa tabadte shubu uashunaidën puduedash: “Ambi chiacpadomboen musuc menenu,” mibi quepec. Aden musuc menenumbi mimbi naid tantiata. “¿Ada ëbi chieshënquid icpec? ¿Ëmbi chieshëmeboedta icpec?” quequin tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Adshun: “Ai, ëmbi chieshëmeboed iquec,” queshun Nuquin Papa tantiaquin mimbi bëboed meniabi mibëd chieshënamboed yacno nidash aidbëd bëdamboec onqueta. Adec bëdamboec onquiash padpidec choashun Nuquin Papa tantiaquin meneta. Adec mibëd chieshënamboedbëdi bëdamboec onqueta. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mibëd chieshënamboed utsimbic: “Nëid cuidmenuen cuidte chuiquid yacno buanchitembimbi iquec,” queshun: “Baded nid,” cac podquedën nidec aidbëd bëdamboec onquenidta: “Ma nëish bëdanu,” quiash. “Matses cuidte chuiquidën cuidchitoshe,” quiash badedquio mibëd chieshënamboedbëd bëdamboec isnanta. Abi yacno buanacsho cuidte chuiquidën: “Icsambo iqueque. Quënën nauedta. Ëmbi chiacted piucquid ëmbi bedabi icnuc ma tsadpanu,” mibi catsiash. Quënën nauedshun ");
INSERT INTO mcfNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ambi chiacted piucquid nibëdnuc mibi cuemenquio ictsiashe. Mibëd chieshënamboedbëdi bëdamboec onqueta. “Nuquin Papan adembidi cuidnushe,” quiash adta —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Adshumbic naden Esusën chuipondash. —Chiaid utsitsen mimbi tantiec. “Min chidopenquio chudenda. Min bënëpenquio chudmenda. Aben uequid chudenda. Aben uequidën dada chudmenda,” quequin Nuquin Papan chiaid nuquin tsusedpan dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aden chiaid niac-niaquec icsambo icquid icnubi nadquid icsambo icoaic. Aton chidopenquio isec: “Aidquio chudtiadquio icchitebi,” quequin otacquio tantiequi matses icsapec. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ëshën isec mibi min chidopenquio bunec icsaic. Ëshë chicshuniacbimboec icsainquio yec ënëdash mibi bëdambo ictsiac. Icsaid ënenquio icquid Nuquin Papan chian anëdënquiacno nësecaquin cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Min chidopenquio chudte bunquin mëismec mibi icsaic. Mëteshuniac bedtiapimbo yacbimboen mibi icsaid ënta. Ënenquio icquid Nuquin Papan cuidendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nadentsen Esusën chuipondash. —Nuquin Papan Moises chuimiaid utsitsen mimbi tantiec. “Aton chido bunenquio icquin naden dada uashun menequid. ‘Mibi intiapimbo yanobi,’ quequin dada uashun aton chidobi menequin nidmequid,” quequin Moisesën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Utsitsen chuinu. Aton chidon bënëpenquio chudmesho istuidshun Moisesën chiacpadomboen nac bëdambo ictsiash. Aton chido dada utsi chudmesa icshobi dadan ambembi dada uaid menequin nidmiac icsambo ictsiash. Aden nidmequin chido icsametsiash. Chido nidmiacsho bedquidtsen icsatsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Adshumbic Esusën padpiden chuipondash. —Naden Nuquin Papan ambi chiaid nuquin tsusedpa Moises dada uamepampic. “ ‘Nuquin Papa utsi uatiapimbo yacbimboen abimbo caimbi,’ quequin chiaid niactemaid nec. Niacsho Nuquin Papan cuidendac,” quequin Moisesën chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Aidën chiacpadec muainquio ictiadquidi mimbi abimbo chiacbimboen utsi uain icsamboen chiec. “Abi cuëmëdquid cuënec muasho ëbi cuidtsiash. Nuquin Papa cuëmëdquid cuënenquio yec muasho Nuquin Papan ëbi cuidenquio ictsiash,” queshun mimbi utsi chiec. “Abu utsi uatiapimbo yacbimboen ëmbi chiacpadomboen naimbi. Muainquio iquebi,” mibi quepec. Adecbidi: “Nidaid utsi uatiapimbo yacbimboen ëmbi chiacpadomboen naimbi,” mibi queoapec. Adembidi chiec mibi Edusaden queoapec. Adembidi con mapi quequin mimbi chieque. Aden abimbo chiacbimboen chienda. “Nuquin Papa cuëmëdquid cuënenquio iccombi,” mibi quenubi abu abi tabadaid icnuc ashunquio Nuquin Papan abitedi namendac. Nidaidic Nuquin Papan tincate nec. Edusaden yacnoshombic Nuquin Papan chomiaidën bëdamboen namendac yuecshun. ¿Min mapin icboda mibi nedi? Padenquio. ¿Mimbida min mapi masedcamedi? Padenquio. Aton Icbombien Nuquin Papan naique. Abimbo chiacbimboen icsamboen chienda. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Adec muainquio icquin abimbo chuita. “Ai, adembi naimbi,” quequin mimbi chiacpadomboen nata muainquio icquin. Adembidi: “Padi. Natiapimbo iquebi,” queshun mimbi chiacpadomboen nainda. Utsi uaic matses icsamequidën Satanasën tantiamiacpadec mibi muapeque. Adenda —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Adashic padpidec Esus onquec: —Nuquin Papan Moises chuiquin dada uamiampid mimbi tantiaboed nad iquec. “Chieshënquin ëshë ansiac adecbidi cuidnanec ëshë ansenanquid. Chieshënquin sëcsiac adecbidi cuidnanec sëcsenanquid,” quequin chiaid icnuc ");
INSERT INTO mcfNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","utsitsen chuinu. Tantia. Mibi cuesquid cuidenda. Chieshënaqui cuidnanenquio icquin adembi bëdamboen ista. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Min matses: “Ëbi cuidquin mimbi ëbi meniambo iqueque. Min dashcute beccho,” quesho mimbi menenquio icsho isun: “Cuidte chuiquid yacno buanshun dashcute dachicmechitomane,” quesho aid dashcute meneshumbic min dashcute utsitsen chicshun meneta. Adec bëdamboec tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Utsibic: “Nëbi nidtuidquin con na buanec nid,” quequin ancabudac nëbi nidtuidenquio icquin udimbo buanshunta. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aton na nibëdquid: “Mitsana beccho,” quesho meneta. Utsibic: “Mitsana buanshun bëuaindambi,” quesho: “Padi,” cainda. Meneta. Aden bëdamboen nata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Adshumbic abi macuësh dapa poctse tsadquin bëdamboec tabadte Esusën chuipondash. Nuquin Papan Moises chuiquin dada uamiampid mimbi tantiaboed nad iquec. “Mibi tantiaquidombo tantiaquin mibi chieshënquido chieshënta,” quequin chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Utsi mibi chuinu. Tantia. Mibi chieshënquidobi bëdamboen isquin tantiata. Chieshënaqui: “Ëbi chieshënquid bëdamboen ista, Papa,” quequin Nuquin Papa chianeta. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aden chianec Nuquin Papabimboec mibi ictsiac. Mibi utsibo bëdamboen nashunquid ictsiac. ¿Bëdambo icquido yacnouidida Nuquin Papan ushë chëncamepadic? Padenquio. Icsaido yacnotsen ushë chëncamec. ¿Bëdambo icquido yacnouidida ue chomepadic? Padenquio. Icsaido yacnotsen ue chomec. Bëdambo icquidobëdtabi icsambo icquido Nuquin Papan bëdamboen nashunec. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","¿Mibëd tantiananquido min shubun icquidouidi mimbi bëdamboen nashunsho isunda Nuquin Papan mibi: “Bëdambo iquec,” capec? Padenquio. Mimbi icsambo iquec caidontsen ambi tantiaido nashuntsiash. Aidombien piucquid bedshumënquido icquimbi aton shubun icquidouidi nashuntsiashe. Aden nainda. Utsibotsen bëdamboen nashunta. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿Min shubun icquidobëduidida mibi onquec tabadpe? Nuquin Papa tantiesaboen adpec. Utsibotsen bëdamboen ista. ");
INSERT INTO mcfNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nuquin Papabimboec icta. Bëdambo icquid icta. Bëdambo icquidobëdta icsambo icquidobi Nuquin Papan bëdamboen tantiacpadomboen utsibotsen bëdamboen tantiata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Adshumbic abi macuësh dapa poctse tsadquin Esusën chuipondash. —Nadquid icsambo iquec. Nuquin Papa tantienquio icquimbi aton matses ismenuenuidi naic icsambo iquec. Adquid Nuquin Papan bëdamboen istiapimbo iqueque. “Utsibo nashunu,” quequin utsibo ismenquio icquin nata. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Aton na nibëdquido menenu,” queshun utsibo ismequin menenda. Ismenquio icquin meniac bëdambo ictsiash. “Nuquin Papa tantiaquid nebi,” quec muaquidën nacpaden nainda. Nuquin Papa tantiaquid damenuembien muaquidën matses dadpen yacnoshonuidi menedenepec. Adosho isun aton matsesënuidi bëdamboen isnubi Nuquin Papan bëdamboen istiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aton na nibëdquido menequin utsibo ismenda. Meneshun: “Menebanombi,” quequin utsibo chienda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Adsho isun mimbi utsibo ismenquio icquin naid tantiaquid icquin Nuquin Papan bëdamboen isquin abëdi mibi tabadmendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Adshumbic Nuquin Papa chianetetsen Esusën chuipondash naden. —Bëdambo icquid damianquidën nacpaden nainda. Aidon Nuquin Papan chiaid chuibante shubun puduedshun utsibo tantiamenuenuidi nidtoshon comapenec onquequin Nuquin Papa chianepec. Adash umanuc puduenshun matses dadpen ismenuenuidi padpiden adembidi chianec. Adquid aton matsesën: “Bëdambo iquec,” canubi Nuquin Papan padenquio iquec. Bëdamboen istiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mibi adenda. Utsibo ismenuenuidi nainquio icquin matsesën isacmaidquio Nuquin Papambo tantiaquioquin chianeta. Aden chianequid mibi icsho Nuquin Papan mimbi utsibo ismenquio icquin naidtedi tantiaquid icquin mibi bëdamboen isquin abëdi tabadmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nuquin Papa chuiquin bëdamboen chianeta. Nuquin Papa tantiesabon ambi tantiaid chuibudacbimboen Nuquin Papa chuibudenda. “Yuenquio chuibudac nuqui tantiaboedën nuqui nashuntsiash. Padenquio icac nuqui nashunenquio ictsiash,” queshun Nuquin Papa tantiesabon yuen chuibudacbimboen nainda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adoenquio icquin Nuquin Papa chianeta. Mimbi chiabi: “Adopashuni. Aid nibëdnuc unësebi. Utsi icnuc bëdambo ictsiabi,” quequin mimbi otacquio tantiaid Nuquin Papan tantieque. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Naden Nuquin Papa chuita. “Bëdamboshë icquid icsho matses abitedishunquio mibi tantiapashun, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Matses abitedishunquio mibi con Icbo capashun. Mibi yacnoshon mimbi uaido mayan bëdabon mimbi chiacpadomboenuidi naic. Adomboembidi mimbi chiacpadomboen matses abitedishunquio napashun. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bumianenda, Papa. Badiadquidën badiadquidënquien con pete icmeta. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utsibon chieshënaqui ëbi cuidnanenquio icsho isun ëbi icsashobi cuidenquio icquin ëbi bëdamboen ista, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mimbi chiaid ëbi niacmenda, Papa. ‘Icsamenushe,’ queshun Satanas ëbi yuamenda, Papa. Abitedishun Icbombo yec abitedimbo namequidquio mibi nec, Papa. Ëmbi mibi chuisho tantiata, Papa. Ënenquio icquin abitedishunquio: ‘Bëdambo iquec,’ mibi capashun. Padi,” quequin Nuquin Papa chianeta —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Adashic nadpondash: —Utsibo bëdamboen ista. Cuidnanec chieshënanenda. Cuidnanec chieshënanenquio icsho isun Nuquin Papan mibi cuidenquio icquin bëdamboen istsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cuidnanec chieshënansho isun Nuquin Papan mibi bëdamboen istiapimbo ictsiash —uequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Adshumbic utsibo ismenquio icte utsi Esusën naden chuipondash. —Tantia. Nuquin Papauidi tantianuequin buna mëmunquid chuinu. Muaquidën nacbimboen ismenda. Muaquido: “Buna mëmunquid nec,” aton matses camenuec abibi maniumëdash nënquidbitsëcquiec mamënenquio iquec. Adec buna mëmunquid tanec muaic. Adsho isun matsesën bëdambo icquid danubi Nuquin Papan: “Icsambo icquid nec,” queshun bëdamboen istiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Nuquin Papauidi tantiaquin nëidtedec ushquin buna mëmunu,” queshun Nuquin Papambo tantiaquin nata. “Utsibon tantianushe,” queshun bëdamboen min manëdaid shueshcata. Adash bëdamboec mamënta. Aden utsibo ismenuenuidi nainda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Aden bëdamboen manëdaid shueshcaid isun: “Buna mëmunec nec,” cainquio ictsiash utsibon mibi chuiquin. Nuquin Papambien: “Ëbiuidtsëqui tantianuen naic,” quequin tantiatsiash. Adshun mimbi utsibo ismenquio icquin naidtedi tantiaquid icquin abëdi mibi tabadmendac —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Adshumbic padpiden Esusën chuipondash. —Ëmbi chuiboedquio tantiashun mimbi dayun uatequiduidi tantienda. Dayun uatequid nadquio iquec. Chodquetequid yec shocosh chiuidtequid yec matsesën ampeshuntequid yec quec icsabudtequid nec. Adquiduidi tantienda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Icsabudesambo tantiata. Nuquin Papambo tantiec aidbëd tabadte bunquin ambi chiacpadomboen nata. Chodquetiapimbo icquid yec shënibudtiapimbo icquid yec ampeshuntiapimbo icquid yec quec Nuquin Papa yacno iqueque. Aidquio tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mibi bunaidquio ënenquio icquin tantiec mibi tabadtsiac. Nuquin Papabëd tabadte bunquin aid tantiata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Adshumbic abi macuësh dapa poctse tsadquin utsitsen Esusën chuipondash. —Pabiate shëcuë cuembo icquin Nuquin Papa tantiaquiec mitsanauidi tantienquio yec mibi bëdamboec tabadtsiac. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pabiate cuënëdacbimboec yec Nuquin Papa tantienquio yec mitsanauidi tantiec ¿bëdamboecta tabadtsia? Padenquio. Adec mibi icsamboec tabadtsiaque. Adenda —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Adshumbic naden Esusën chuipondash. —Mitsanauidi tantiec mibi icsamboec tabadtsiac. ¿“Naic cho,” quequin daëdshun chiacta aid daëdi mimbi nashumpatsia? Padenquio mimbi ictsiac. Abentsëc nashunquin utsin chiaid mimbi natiapimbo ictsiac. Aden mitsana bedtequiduidi tantiaquin aid bednuenuidi mimbi natsiac. Aden naquin Nuquin Papan chiacpadomboen mimbi natiapimbo ictsiaque. Mitsana bedteuidi tantienda. Nuquin Papauidtsëqui tantiata —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Adshumbic Esusën padpiden chuipondash. —Ëmbi aden chuisho tantiash dacuëdenda. “¿Atotsimbi pepe? ¿Atotsimbi acpe? ¿Atotsibi dasiuidpe?” quec dacuëdenda. Nuquin Papan nac unësabi mibi tabadeque. Aidëmbien petebëdta dasiuidte icmeque. “Con na nibëdtsiash,” quiash dacuëdec tabadenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","¿Uicchunënda ambibi cuëte ëshë siac bacuëacsho chepadic? Padenquio. Adecbidi ambi pete dayun uatequid shubumpi nibëdec. Adquid icsho Nuquin Papan aton pete bedmec. Uicchun abipadquidpenquio icshobi aton pete Nuquin Papan bedmec. ¿Ad icnuc ambi abipadquid uaidobi matses icsho aton pete bedmenquioda icpadic? Nuquin Papan mibi nashunquin min pete icmeque. Dacuëdenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿“Unëstiapimbo iquebi. Dacuëdebi,” quequidta unësenquio icpadic? Adequi dacuëdquid unëstsiashe. Unësteuidi dacuëdënenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Atotsibi dasiuidpeba?” ¿quecta mibi dacuëdec tabadpe? Tantia. Chuinu. “Cuëte bacuëec bëdamboshë isadtsec,” quepec nuquin matses. ¿Aton sedquidi shoyontsëcshun abi dasiuidte daëdcash dasiuidtsashta bëdamboshë isadpadic? Padenquio. Nuquin Papan uacpadquiobi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","¿Cuëte bacuëec bëdamboshë isadquidbimboecta nuquin tsusedpa chuiquid dapa Sadomon cuëmëdquidën dashcute icpampic? Padenquio. Adpenquien icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cuëte bacuëec bëdamboshë isadboed abadiadtsëcshumbi isac ënden chodquiac. Aid badedquio chodquequid nec. Ad icnuc ¿abipadquid Nuquin Papan uaido mibi icsho mibi dasiuidte bedmenquioda icpadic? Padenquio. Mibi dasiuidte icmeque. Dacuëdenda. Mitsana nibëdquio icte dacuëdënquimbi mimbi Nuquin Papa bëdiactsëc tantiatseque. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dacuëdec tabadenda. “¿Atotsimbi pepe? ¿Atotsimbi acpe? ¿Atotsibi dasiuidpe?” quec dacuëdenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nuquin Papa tantiesaboen adquid bedteuidi bunquieque. Adenda. Mitsana nibëdsho isun Nuquin Papan mitsana icmetsiashe. Abi tantiaquido yec dacuëdec tabadenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Adenquio yec: “Con Icbo mibi nec, Papa,” quequin ambi tantiacpadec bëdamboec tabadte bunta. Adec tabadec: “Aid nibëdnuc unësebi,” quequin mimbi tantiaidtedi Nuquin Papan mitsana icmetsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ëbi adsho tantiash badiad utsi caic: “Aid badiadën ¿atotsimbi nape?” quec dacuëdenda. Aid badiadën Nuquin Papan ambi tantiacpadomboen mibi nametsiashe. Nëid ushëmbi: “Naden naimbi,” quequin tantiec tabadnuna dacuëdenquio yec —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Naden Esusën Nuquin Papan chiacpadec tabadte chuipondash. —Mibi icsaid ucudambobi utsibo icsaiduidi chienda. Adembidi Nuquin Papan: “Icsambo iquec,” mibi canushe. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","“Icsambo aid iquec,” mimbi cac adembidi aidontsen mibi adoatsiashe. Adembidi Nuquin Papantsen: “Mibi icsambo iquec,” canushe. Utsibo icsaiduidi chienda. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","¿Abi bëtsiadaid bëchish nua bëuequid bëbedadabi icquidënda: “Mibi bëtsiadaque. Bëbednu,” capatsiash utsi chuiquin? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Abi bëtsiadaid abia bëbedadashien: “Mibitsen bëbednu,” quetsiash. Adembidi mimbia mibi icsaid ënshun: “Icsaid ënash bëdamboequien tabadtiad,” quequin utsibo bëdamboen chuita. Bëdambo icquid damianquidën abi icsaid ënabi: “Aid icsambo iquec,” quequin utsibo icsaid chuibanec. Adquid tanenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mimbi bëdamboen chiaqui tantienquio icsho chuidonenda. Nuquin Papan chiaid chuibudaqui tantiatiapimbo icquin niac-niacsho isun adenuidi chuidonenda. Opa icsan abi pemequid piacbimboen mibi chieshëntsiashe. Chanchon icbon dashcute nebudshun bëchish uaquin tin-tincacbimboen Nuquin Papan chiaid niac-niactsiashe. Adquid chuidonenda —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Nadembidi Esusën chuipondash. —Nuquin Papa ënenquio icquin chuidoneta. Bacuëbon: “En na,” cadoniacbimboen chuidoniac Nuquin Papan mibi tantiatsiashe. Adembidi: “Ëbi bëdamboen name, Papa,” mimbi cacpadomboen bëdamboen mibi nametsiashe. Adembidi: “Ëbi nashunquin ëbi bëdambo icmeta, Papa,” quequin chuidoniac Nuquin Papan mibi bëdambo icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Icsambo icquidta Nuquin Papa icpadic? Padenquio. Bëdambo icquidquio nec. Bacuëmpi: “Bundobique. Penu. Beccho, papa,” ¿queshoda amën cudasënquin cuënotebi menepadic? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Adembidi aton bacuën: “Nuëcquid chenu. Beccho, papa,” cacta cudasquin nisimbo menepadic? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Matses yec icsaquido icquimbi min bacuëbo abimbo mimbi menenubien Nuquin Papan ambi uaido matses: “Ëbi nashunta, Papa,” quesho tantiashun bëdamboen nashuntsiashe. Nuquin Papa chianeta. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nuquin Papan tantiaido icquin utsibo bëdamboen isquin bëdamboen nashunta. Utsibo caic: “Aidon nashumpashuni,” quequin mimbi otacquio tantiacpadomboembidi utsibotsen nashunta. Aden Nuquin Papan chiaid Moisesbëdtan nuquin tsusedpabo utsibon dada uaquin chiampicpadomboen mimbi natsiaque. Aden utsibo nashunta —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Adshumbic Esusën naden chuipondash. —Nuquin Papabëd tabadnuec aid tantiec bëdamboec tabadta. Shëcuë aniambo icquidën matses abentse-abentsec puduedacbimboec abentse-abentsec Nuquin Papa yacno puduednuec aid tantiec bëdamboec tabadec. Padnuen antied dapan abi maisi nidacbimboec matses dadpenquio abi tantiesabo yec Nuquin Papan icsaido nësecacno nidendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Abi macuësh dapa poctse tsadquin naden Esusën chuipondash. —Utsibo: “Nuquin Papan chiaidquio chuiquid nebi,” quec bëdambo icquid damianquid iquendac. Adquid choshon Nuquin Papan chiaid niac-niacmequin icsamendac. Bëdi dapa nëish yua pete bunquiacbimboec mibi icsamete bunquieque. Adquidën chuisho tantienda. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“¿Mitsipadembimbi muaquid tantiapatsia?” ¿quecta ique? Ambi naid isun mua quequin mimbi tantiatsiac. Adembidi Nuquin Papan chiaidquio chienquio icsho tantiashun: “Utsi uain chiec,” mimbi catsiac. Chetequid isun cuëte dada matsesën tantiec. Aden tantiec nisanquidën bacuë bësho isash: “Dadainën bacuë nec,” quesa matses nec. Adecbidi echo bacuë bësho isash: “Bata nec,” quesa matses neoaic. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Cuëte bëdan bacuë adquiobidi bacuëec. Cuëte icsan bacuë adquiobidi bacuëoaic. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","¿Cuëte bëdan bacuë chetemaidta nepec? Padenquio. ¿Cuëte icsan bacuë chetequidta icpec? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Chetemaidbimboec muaquid bëdambo ictiapimbo iquec. Nuquin Papan chiaid niac-niaquec icsamboec tabadsho isun: “Muaquid nec,” quequin mimbi tantiatsiac. Adembidi Nuquin Papan chiaidquio chienquio icsho: “Muaquid nec,” quequimbidi mimbi tantiatsiaque. Adquidën chuisho tantienda. Cuëte bacuëesa dëdshun nëdëncacbimboen: “Nuquin Papan chiaid chiembi,” quec muaquid Nuquin Papan icsaido cuidacno nësecaindac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Utsitsen Esusën chuipondash. —Ëbi caic: “Con Icbo mibi nec. Mibi tantiembique. Mibi yacno ëbi puduedme,” ¿quequidtedida Nuquin Papa yacno puduedpatsiash? Padenquio. Nuquin Papan chiacpadomboen naquidquien abi yacno puduedtsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nuquin Papa yacno ëmbi yuedte ushën matses dadpenshun ëbi chuiuidendac. “Con Icbo mibi nec. Mibi caic: ‘Aidën namiaidquio nebi,’ quequin dadpen naombi. Nuquin Papan chiaid chuiquinc, podobitsi icsabo matses dapuduedaido cuemequinc comapenen tantiaquin ismequinc caombique. Nuquin Papa yacno ëbi puduedme,” ");
INSERT INTO mcfNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","quesho ëbimbo tantiec Nuquin Papan chiacpadec bëdamboec tabadabi icsho: “Ëmbi tantiacmaidquio mibi neque. Baded cuenta. Icsamboec tabadquid mibi neque,” caindambi. Ëbi adsho tantiash muainquio yec bëdamboec tabadta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Adshumbic Esusën padpiden chuipondash naden chuiquin. —Ëmbi chiacpadomboen nata. Aden mimbi bëdamboen natsiaque. Shubu uaquin bëdamboen tantiaquidbimboec mibi ictsiaque. Tantia. Chuinu. Bëdamboen tantiaquidën mananënquio shubu uaquin buintad nitsinquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aden shubu uan ue dapa conquequidbëdi chonoc shubu chimeshadenquio icquid. Shubu nuntan anchiuidenquio icquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aden ëmbi chiacpadomboen naquid icnubi utsibo ëbi tantiesa iquendac. Aido shubu uaquin tantienquio icquidbimboec iquec. Tantienquio icquidën nadoquid. Acte cuidi cuëmanquiobi shubu uaquin badedi unëstsëcquidquio cueste nitsinquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Adquid nitsinaid ue dapabëd conquequid choquin shubu chimeshquid. Adecbidi acte cubudtoquidën shubu nuntan mauanquid. Aden tantesa uatsëcquidbimboec ëbi tantiesa iquec. Adquid Nuquin Papan cuidtequido neque. Ëbi tantiata —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Adsho tantiash: —Ma comapenen tantiaquidquio Esus neyoc. Nuquin matses tsusiobon Moisesën chiampid bëdiactsëc tantiatsëcquin chuitsëccosh. Padnuen Esusënquio comapenen tantiaquin chuiposh —quecuededpondash matses dadpenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ambobi macuësh poctse tsadquin ënquin chuitanequien Esus macuësh budpondash. Adec budanec nidsho isumbien matses dadpenshun tsibanampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Adnubien dada ushumbo yec daicsaidquio choshon Esus ismenuen danëshën sebudpondash. —Ëbi bëdamete bunquin mimbi ëbi bëdametsiaque. Ëbi bëdame, Icbo —caquien Esus: ");
INSERT INTO mcfNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","—Ai, mibi bëdamete bunebi. Mibi bëdanendac —quequin mishtemaidquiobi mishnubi badedquio bëdampondash daicsaid nibëdquiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Adsho Esusën: —Utsibo chienquio yec nëish yua abided unës uaquido ismenuec nidta. Mibi isash: “Bëdamiaid nec,” quequin ma aidon tantianu. Moisesën chuipampicpadomboen nanuen: “Nuquin Papan bëdamioshi,” quequin Nuquin Papa menetequid buanquin ismec nidta —quequin Esusën chuipondash. Adtanec shubu dadpen icquid Capednaun caid yacno chopondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capednaun yacno choash Esus tabadpondash. Adnubien Doma yacnoquido sondado 100ted chuiquid dapan Esus chuituidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Tantia. Chuinu, Icbo. Con shubun icquid con yua shëquëquenquio iccosh. Natiambo yec unëstiadtsëcquio iccoshe. Bëdameta ");
INSERT INTO mcfNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—quesho tantiashun: —Ai, bëdamec nidnu. Nid —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Padi. Mibi bëdamboshë icquidquio nec. Ëbibi icsactsëcquid icquin mibi con shubun puduedmetiapimbo iquebique. Nëshunquiobi bëdameta. Nidenquio icquin nëshunquiobi mimbi: “Bëdanta,” cac con yua bëdantsiashe. Mimbi tantiacpadomboen namequidquio mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ëbibic chuiquid dapan namiac sondado utsibo namequid nebi. Ëmbi: “Nid,” cac badedi nidec. Ëmbi: “Baded cho,” cac badedquio choec. Con yuan ëmbi: “Nata,” cac ëmbi chiacpadomboen naic. Mibi adquidquiobidi neque. Con yua bëdameta —quepondash sondado chuiquid dapa. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Adsho tantiashun Esusën abi tsibambëquido chuipondash. —Bëdamboen nëidën chuipec. “Comapenen tantiaquin chuiquinuidi con yua bëdametsiash,” quequin ëbi bëdamboen tantiaquid nec. Isadaidbo adquid nibëdec. Isadaidbon ëbi bëdiactsëc tantiabededtsec. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tantia. Chuinu. Matses utsi icquimbi sondado chuiquid dapan ëbi bëdamboen tantiec. Adec nidaid utsi-utsiec yacnocquido isadaidpembo ëbi tantiaquido yanash Nuquin Papa yacno puduedendac. Ambo puduedash isadaidbo tsusedpabobëd tabadendac. Abadauan caid yec Acobo caid yec Isac caid yec quequidobëd tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Padnuen Nuquin Papan con matses caido isadaidbo dadpenquio Nuquin Papa yacno puduedenquio iquendac. Abi tantiesabo icsho Nuquin Papan cacumequin icsaido nësecacno mibi nidmendac. Adoac mibi tënquebudquiendac —quequin abi tsibambëquido isadaidbo chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Adshumbic sondado chuiquid dapa chuiquin: —Nidec nid. Mimbi tantiacpadec min yua bëdaneque —cac nidshun isquien bëdanac Esusën chuibocpadequi. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Adash yuec-yuecpactsëc ictanec Esus Petedon shubun puduedpondash. Puduedshun isquien Petedon nachi chumbo yec ueten uepec. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Uesho istuidshun mëdinquin Esusën bëdamepondash. Aden bëdamiac Esus pemepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Petedon nachi bëdamiaid inchëshbudtsëqui Esus ismenuequin matses daicsaido dadpen bë-bëpondash. Bë-bëshobien podobitsi icsa dapuduedaido comapenec cuëdquin cuemeshumbic daicsaidotsen Esusën bëdamebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","“Nuqui icsaid ucquin nuqui daicsaidobi bëdamiac,” quequin ëndenquio Nuquin Papan Esusën nate Isayas dada uamepampicpadomboen nanuen adopondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Adashic abi isnuec matses dadpenquio datsidadsho isash abëd icquido chiec: —Chian potec nidnu. Nid —quianec chian yacno nidec puduampondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Puduanec nidaneshobien Moisesën dada uampid chuibanquidën Esus chinuntuidpondash. —Con Icbo mibi caindambi. Mibëd nidendabi —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—¿Ëbëdta nide? Tantia. Mibi chuinu. Bëdi chëshë shëcuën ushquid. Uicchun shubu uash abuc ushquid. Padnueni con shubu nibëdnuc Nuquin Papan matsesmiaid yec quenenenquio yec capucuenendac. ¿Ada mibi adpatsia? —capondash Esusën Moisesën chiampid chuibanquid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Adnubien abëd capucueneboed utsin: —Chiata, Icbo. Con pa unësoshe. Chococatambono —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Padi. Cho. Ma unësaidën tantienquio yacbimboen ëbi tantienquio icquidon ma papa chococanu. Ëbëdtan bëdamboen naic cho —capondash Esusën amë unësaid chuiquin. Adobidanec nidanepondash chian yacno. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chian budash Esus chedo cano antabëdtopondash. Adashic potenuec puduampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aden potenubi nënantanquio icnuc cunquetuidpondash. Adnubien acte comapenec tëccuasquiampondash. Adec acte tëccuasquenuc cano acte ancushad-ancushadquiec yampondash cano mentoadtiadtsëcquio yec. Adsho isun abëd icquidon: —Dacuëdampambo iquec —quetanquin isquien Esus ushpec. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Adshobien tinquin: —Nuqui mentoadeque. Isucun, Icbo. Baded ëbi nashun —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿Atotsi quiash dacuëde? Ëbi bëdiactsëc tantiatsec dacuëdquidquio mibi neque. Istac —quetanec nidtoshon actebëdtabi cunquequid chuipondash. —Padi. Ënëdta —caquien natiambo cunqueboedi badedquio ënëdpondash cano mentoadtsenquionobi. Actetsen tëccuasquenquio yampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Adsho isashien: —¿Mitsipadquidënquio actebëdta cunquequid ënëdmepashba? —quecuededpondash Esusbëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aden chian potiash pudundonobien Cadada yacnocquid podobitsi icsa dadpen dapuduedaid dada daëd choshon Esus chuituidpondash. Aid daëd unësaido chococaid shëcuëmbi tabadpondash. Matses cuesunete bunquiec dacuëdampambo icsho isash aid yacno matses nidenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aidon podobitsi icsabon oncamiacpadomboen comapenec cuëdquin Esus chuituidpondash. —¿Nuquin Papa caidën Madombo icquin ëbi natiamequin cuidnuecta cho? ¿Nuquin Papan cuidte ushë choabi icnubida ëbi cuide? —capondash dada daëdshun abi oncamequidën chiaid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Uano chancho dadpenshun natiacquin udquin pebededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Adnubien podobitsi icsabon aid dada daëd oncameoac: —Ëbitedi cuemiac chancho icbo-icboec dapuduedtsiabi —quecuededpondash podobitsi icsabo. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Adsho tantiashun Esusën: —Ai, mimbi tantiacpadec nid —cac nidash chancho icbo-icboec dapuduednubi chancho abitedi macuësh budec acte nësebudec mentoadbudnepondash nibëdquiec yec. Adec podobitsi icsabo dapuduenanec nidnubi dada daëd bëdambo yampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Adsho istanequien chancho pemequido aton matses chiec niquianec shubu dadpen yacno nidanepondash. Chancho mentoadbudneboedbëdta podobitsi icsabo dapuduemeboed uesquin chuituidpac caondash. —Nuqui dacuëdëmboedobi bëdambo yanosh —quequin ");
INSERT INTO mcfNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","chuituidaquien anocquido abitedi Esus isec cho-chopondash. Adec cho-choshombien: —Dacuëdampambo mibi iqueque. Ëbi yacno choenda. Nidec nid —cabededpondash. Adoac Esus nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","—Nid —cac nidanec chian budash cano antabëdtoshon chian potiash abi iccondacnobidi Esus choapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Adnubien utsibon dada shëquëquenquio icquid Esus ismenuen aton uetechobi bëpondash. Bësho isumbien Esusën: —Ëbi caic: “Aidën bëdametsiash,” queshun bëac —quequin daicsaid chuipondash naden. —Dacuëdenda, madosio. Ambi chiaid niac-niaquec icsaboedi cuidmenquio icquin Nuquin Papa mibi bëdamboen ismembique —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Adsho tantiash aid datsidadash tabadquido Moisesën dada uampid chuibanquido: —¿Adpecta matses icquid? “Nuquin Papapadquidquiobini nec,” quepequien iquec. Icsamboen chiec —quecuededpac caondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Uanuësh adsho ambembi tantiashumbien Esusën aido chuipondash. —¿Atotsi quequin mimbi ëbi chieshëmpe? ");
INSERT INTO mcfNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ambi namiaid icquin ëmbi: “Nuquin Papa cuidmenquio icquin mibi bëdamboen ismembi” cac Nuquin Papan nëid cuidenquio iquendac. Adembidi ambi namiaid icquin ëmbi: “Caputa,” cac nëid capuendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Istac. Mibi ismembique. “ ‘Nuquin Papan chomiaid nec. Icsaidobi Nuquin Papa bëdamboen ismequid nec,’ mabi canu,” queshun naimbique. Istac —quetanquin dada shëquëquenquio icquid chuiquin: —Caputa —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Adoac bëdanash aton shubuno nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Adsho isashien: —Adquidshenda nepec. Nuquin Papan namiaid icquimbien adochitec. Abi namequid Nuquin Papa bëdambo iquec —quecuededpondash isquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Adnubini con matses aton piucquid bedshunuec podqued cuëman tsadquid shubumpin tsadpondac. Con matses yuaquid ancaquid dapan: —Min matsesën na ëmbi chiactedi piucquid bedshun ëbi meneta —cac niondabi. Ambo tsadshobini Esusën istuidpondash. Istuidshumbini Esusën: —Nuquibi icnu. Cho —capondash. Adoac badedi tsibananec ");
INSERT INTO mcfNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","nidequi con shubun Esusbëd puduedpondabi. Adec puduedsho isashien matses dadpen pudued-puduedpondash. Esusbëd pec tabadnuec ëbëdtan piucquid bedshunquidobëdi con matsesën: “Icsaido nec,” caidombo pudued-puduedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Adsho isumbien Esus chieshënquido Padiseyobo caidon Esusbëd icquido chuituidpondash. —¿Atotsi quiash mibi chuiquid Esus caid icsaquidobëdi pec tabadpec? Icsambo iquec —capondash Esus chieshënquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Adsho tantiash Esus nadpondash. —¿Bëdambo icquidta dauëchoquidën dauë menepadic? Padenquio. Ma daicsaidi dauëchoquidën menepaid yoc. Adembidi icsaidobi abi icsaid ucquin bëdambo icmenuec nebi. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nuquin Papan naden dada uamiampid pausudshun bëdamboen naic nid. “Ëmbi chiacpadomboen abentse-abentsen mimbi naic. Adoquimbi ëmbi chiaid utsi niaquec mimbi icsaido caido mimbi bëdamboen istiapimbo iquec. Adsho isun: ‘Mibi bëdambo iquec,’ catiapimbo iquebi” quequin Nuquin Papan dada uamiampid pausudta. Ëbibi matses bëdamboen ismequid nebi. Muaquido: “Bëdambo icquid nebi,” quesho bëdambo icmetiapimbo iquebi. Icsaquidobi: “Nuquin Papan chiaid niac-niaquec icsapobi,” quesho: “Icsainquio yec ënëdta,” canuec nebi —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Adnubien Uan acten mentoanquidbëd icquidon choshon Esus chuituidpondash. —Nuquin tsusedpabon nacpadomboen Nuquin Papauidi tantianuen buna mëmunquidquio nebi. Padiseyobo adembidi naquidquio nec. ¿Atotsieshun mibëd icquidon aden nainquio icpec? ¿Natiapimboda iquec? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Esus nadpondash. —¿Icbon: “Pec cho,” cacta aid tantiec sedenquecuededquin buna mëmumpadic? Padenquio. Adquidbëdtan pec cuishonquec tabadquid. Icbo nibëdanan sedenquecuededquin buna mëmunquid. Ëbi nibëdanan ëbëd icquidon ëbiuidi tantianuen buna mëmunendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Adshumbic Esusën naden chuipondash. —Dashcute chuca cuëshun dashcute shëni nedesquiaidbëdta tuscaisa. Aden tuscashun panac shëni badedquio nedesquequid. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—¿“Machi sandono,” queshun tsitsan shënimbida sandopadic? Padenquio. “Machi sebudnushe,” queshun tsitsan shënin sandoenquio icquid. Tsitsan chuca daëdcashumbien machi sandoquid —quepondash Esus. —Adembidi tsusedpabon: “Naden nata,” quequin chiaid chienquio icquin ambi bëdamboen iste chuiquin Nuquin Papan chiaid utsi chiec nebi —quequin tantiec adpondash Esus Uan acten mentoanquidbëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aden chuishobien Nuquin Papan chiaid chuibante shubun tabadsho isquid dapan chuituidpondash. —Con champi unëstiadtsëcquio iccoshe. Mishec cho. Mimbi mishac bëdantsiashe —capondash. —Mibi con Icbo canu —quequin danëshën sebudquin ismepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Adoaquien Esus aidbëdi nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nidnubien chido intac budted-budtedec seta 12tedi matamec bëdanenquio yec nacchoadbudquidën Esusën cachoctsëqui choquin: —Bëdamianquidën dashcute mishec bëdampatsiash icmanendac —queshun ismenquio icquin dashcute cuëmano mishtsac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Adoaquien bidiadquin isun Esusën chuipondash. —Dacuëdenda. Mibi: “Aidën nac bëdantsiabi,” quiacpadec mibi bëdanendac —Esus quenubi bëdampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aid bëdamebidanec nidequi chuibante shubun tabadsho isquidën shubun puduedshun isquien matses dadpen tabadec. Champi unësacsho isash sedenquecuededec tabadec. Nëidic matses unësan con matsesën nacpadomboen shoncate shoncaquido. Nëidic comapenec sedenquecuededquido dadpen. Aidtedi icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Adshobien Esusën abitedi chuiquin: —Baded umanuc niecun. Champi unësabi iqueque —capondash. Adoac: —“Champi unësabi iquec,” quepequien iquec —queshun Esus mamënshumbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Niecunan Esusën champi uiacno quënën puduedtanquin mëdinac champi uincuenash bëdambo yec capupondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Adsho isun champi unësaid uincuemiaid chuibenepac caondash shubu utsin-utsinquien. Anocquido Capednaun caid yacno pauequidotedishun tantianuc chuibeniac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Auëshquio puduanec nidshobien bëshuaid daëdshun chinunshun comapenec cuëdquin Esus chuituidpondash. —Dabidën tsyuecquid Nuquin Papan chomiaid icquin bëdamboen isquin ëbi bëdame —quebud-quebudpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Shubu utsin puduedash abëdi tabadshobien Esusën: —“Ëbi bëdametsiash,” ¿caindabi ique? —caquien: —Ai, adebi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Adshobien aid daëdi bëmishquin: —Mimbi tantiacpadec bëdanta —cac ");
INSERT INTO mcfNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","bëdampondash. Adsho isun Esusën: —“Bëdamioshi,” quequin utsibo chienda —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Adoboqui anocquidotedi chuiben-chuibempac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bëshuaid bëdamiaid puduenubien podobitsi icsa dapuduedaid onquesa dada Esus ismenuen bëpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bëacsho isun Esusën podobitsi icsa dapuduemiac bëdanash onquiampondash. Aden bëdamesho isash: —Nuquin nidaid Isadaid caidënshun adoen ictenec —quecuededpondash isquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Adnubien Esus chieshënquido Padiseyobo: —Podobitsi icsan icbon namiaid icquin podobitsi icsa cuemequidien nechitec —quecuededpondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aden onquesa bëdamianec nidash capucuen-capucuenquin shubu dadpen icquid yacno Nuquin Papan chiaid chuibante shubun puduedshun Nuquin Papan matses icsaido bëdamboen iste chuipondash. Adshumbic anocquido daicsaidotedi bëdamebampondash. Adenuidi shubu dadpen yacno-yacnomboen chuibanquimbi matses bëdamebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Abi tantienquio icquido dadpen cho-chosho isash unësquio icnuc shubiantiadquio icpondash Esus. —Abi isquid nibëdnuc bacuëbo icsamboec tabadacbimboec icsambo iquec. Nuquin Papa bëdamboen ismete chiabi yac tantienquio yec natia chieshëmënec bëdamboec tabadtiapimbo iquec —quiash shubiantiadquio icpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Adshumbic abëd icquido chuipondash. —Pete dadpen nitsinaid caniacsho bedtanenquio icnuc sinash chodquebudnequid. Adecbidi Nuquin Papan chiaid chuibanquid nibëdnuc matses icsamboec tabadec. Aden chuibanquid nuquipadquid daëdpactsëcquio iqueque. ");
INSERT INTO mcfNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nuquin Papa chianeta. “Matses dadpenshunquio mimbi bëdamboen iste tantiabi iqueque. Mimbi chiaid chuibanquid dadpen icmeta, Papa,” quequin Nuquin Papa chianeta —quequin chuipondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Adshumbic Esusën abëd icquido 12tedi chuipondash. —Ëmbi naid chuibeneta. Ëmbi namiaid icquin ëmbi nabocpadomboen podobitsi icsa matses dapuduedaid mimbi cuemendac. Adembidi daicsaido abitedi mimbi bëdamendac —quequin chuipondashi nëidtedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nëidic Petedo caidbidi Simon cuëmëdquid. Nëidic abëdta tishaid Andedes cuëmëdquid. Nëidic Sebedeyon mado abi daëdi. Abentsëc Acobo icnuc utsi Uan icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nëidic Uedipe. Nëidic Badtodome cuëmëdquid. Nëidic Tomas. Nëidic ëbibi Mateyo con matses piucquid bedshundenedi. Nëidic Acobo cuëmëdquid utsi Adpeon mado. Nëidic Debeyo caidbidi Tadeyo cuëmëdquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nëidic Simon cuëmëdquid utsi con matses yuaquido cuemete bunquid. Nëidic Iscadiote caidbidi Udas cuëmëdquid abi chieshënquido Esus bedmequid. Aidtedi abëd icquido icsho chuipondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Adshumbic: —Ëmbi chiacpadomboen chuibenenuec nidshun isadaidpembo chienda. Aido yacno nidenda. Nidaid cuëshë Samadia caid yacnocquidon shubu datambidanta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nuquin matses isadaidbouidi chuibeneta. Bënudshun podqued tantienquio yacbimboen nuquin matsesën Nuquin Papambo tantienquio iqueque. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Mibi icsaid ënash bëdamboec tabadta. Nëbi abëd tabadtequido icmequin Nuquin Papan matses bëdamboen tabadmendac,” quequin chuibeneta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Adembidi daicsaido bëdamequinc unësaido uincuemequinc dada ushumbo yec daicsaido bëdamequinc podobitsi icsa dapuduedaido cuemeshunquinc cabeneta. Adoshon: “Piucquid beccho,” cainda. Ëmbi nabocpadomboembidi mibi namembique. “Piucquid beccho,” quequin nainquio iccombique. Adembidi nashumbanta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aden chuibenec nidquin min piucquid buanenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Adembidi pete sandoaid buanenda. Dashcute utsibëdta tapucudte utsi sandoshon buanenda. Mibi tidinquete cueste abentsëqui buanta. Adec mëdadauidquio chosho isun mimbi bëdamiaidon: “Mibi bëdambo iquec. Ëbi yacno ushec cho,” mibi cac bëdambo ictsiash. Adembidi: “Mitsana nibëdsho isun mibi menenu,” mibi cac bëdambo ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aden chuibenec shubu dadpen icquid yacno nidshun bëdambo icquid istuidta. Istuidshun: “Min shubu yacno ushec nidnu,” mimbi cac: “Ai,” quesho tantiash aidën shubun ushta. Auëshquio nidabi yec aidën shubunuidi ushta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aidën shubun puduedshun: “Mibi isnuec chopobi,” cata. Adoshombic: “Nëid shubun icquido Nuquin Papan bëdambo icmepashun,” quequin aido bëdamboen ista. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Adoac anocquidon mibi bëdamboen iso: “Nuquin Papan bëdambo icmepashun,” mimbi canubi Nuquin Papan aido bëdambo icmendac. Anocquidon mibi chieshënsho Nuquin Papan aido bëdamboen istiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Shubu dadpen icquid utsi yacno mibi nidacsho anocquidon cuemiac naden ismeta. Auëshquio puduanec nidnun: “Nuquin Papa tantiesabo yec Nuquin Papan cuidtequidombo mibi nec. Icsaidombo mibi nec,” quequin ismec nidaid putu tasequeta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mimbi adosho isun matses cuidte ushëmbi Nuquin Papan aido comapenen cuidendac. Ëndenquimbo shubu dadpen yacnocquidotedi cuidquin Nuquin Papan uesquin unës uapampic. Aid shubu dadpen icquid abentsëc Sodoma canubi shubu dadpen icquid utsi Comoda capampic. Aid daëd yacnocquido bëdiactsëc cuidshun mimbi chiaid tantienquio icquido comapenen cuidendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Adashic padpiden chuioaic: —Ëmbi naid chuibenequido icsho utsin-utsinquien mibi chieshënendac. Bëdi nëish yua acte bunacbimboec chieshëmënquido mibi cueste bunendac. Aidobëd chieshënanenda. “¿Mitsipadomboen chiac Nuquin Papan chiaid tantiabempatsiash?” queshun bëdamboen tantiaquin bëdamboen chuita. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mibi chieshënquin cuesunetiadquio iquendac. Mibi bedshun: “Cuesmenu,” queshun abi chuiquido mibi cuidmenuen Nuquin Papan chiaid chuibante shubuno mibi buanendac. Ashunquio mibi cueshcaten cueshcaindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Utsibombic adembidi cuesmenuen chuiquid dapa cobenadod yacno mibi buanendac. Adembidi chuiquid dapa utsi yacnotsen mibi buanendac. “Ma ëbi chuiquidon chuiquid dapabëdta isadaidpembo ëmbi naid chuibanu,” ëbi quenuc mibi aden buanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Adoac dacuëdenda. “Chuiquid dapa yacnoshon ¿atotsimbi chuipatsiaba? ¿Adambi bëdamboen chuipatsiaba?” quec dacuëdenda. Chuiquid dapa mimbi bëisnubi Nuquin Papan ambi tantiacpadomboen mibi oncamendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aden aton Mayanën ambi tantiacpadomboen mibi oncamendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Adashic padpidec onquec: —Ëbi chieshënquidon ëbi tantiaquidotsen comapenen chieshënendac. “Esus tantiaquid nec,” queshun aton buchimbi aton utsi cuesunemendac. Amëmbi ambi tishmiaid cuesunemendac. Aton bacuëbombi chieshtoshon anibëdta amë cuesunemendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“Esus tantiaquid nec,” queshun matses dadpenshun aden chieshënaqui chieshtoenquio icquin ëbi tantiasho Nuquin Papan abi yacno mibi puduedmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Shubu dadpen yacno nidacsho chieshënac shubu dadpen icquid utsi yacno cuenta. Anoshontsen ëmbi naid chuisho chieshënoac shubu dadpen icquid utsi yacnotsen cuenoata. Adecuidi cuendeneta. Nëid nidaid Isadaid caidën shubu dadpen icquid abitedi yacno nidabi icnubi choaindabi. Nuquin matses isadaidbo abitedi chiabi icnubi Nuquin Papa yacnuësh choaindabi. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mibi tantiamequid nebi. Ëmbi tantiamiaido icsho ëbi icbocpadomboembidi mibi chieshënendac. Abi chuiquid dapa chieshënacpadembidi ambi namiaidotsen chieshënquid. Icbo chieshënquimbi yuabotsen chieshënquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Adembidi ëmbi chiacpadomboen natiadquio icsho mibitsen chieshënendac. Nuquin Papa yacno puduedmianquid icsho: “Ma podobitsi icsan icbo Betsibu caid neyoc,” ¿cainquiodabi ictiosh? Adembidi mibi Nuquin Papa yacno puduedtequido icsho mibitsen chieshënendac —quequin chuipondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Adshumbic padpiden chuiquin: —Mibi chieshënquido dacuëdënenda. Aidon ompodshon icsamboen naid Nuquin Papan utsibo ismendac. Adembidi aidon shoshquetsëcquin chiaid Nuquin Papan utsibo tantiamendac. Adembidi mimbi bëdamboen naidtedi Nuquin Papan utsibo tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nëbi ëmbi mibitedictsëqui chuiboed dacuëdenquio icquin utsibo chuibeneta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chuibenesho min dadauidtsëqui cuesunetequid dacuëdënenda. Min tantiate unëstiapimbo icquid icsho nibëdametiapimbo iquec. Min dada unësan min tantiate abi icsho cuidnuequin chian anëdënquequid nësecanquid tantiata. Adquid Nuquin Papa icsho dacuëdënta. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Utsibon chieshënaqui dacuëdenda. Nuquin Papan mibi tantieque. ¿Padichucu cuesaid isashta unësquio icti? Padenquio. Padnuen ambi tantiacpadomboembi padichucu dadpen icquid abentsëc cuesac paëdsho Nuquin Papan tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Adembidi min manëdaid Nuquin Papan tambanaidquio nec. Aden min manëdaid abentsëc paëdsho aidën tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aden min manëdaid tambanquid icquin padichucu bëdiactsëc tantiatsëcquin mibien comapenen tantieque. Mibi chieshënquido dacuëdënenda —quequin chuipondashi Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Adshumbic padpiden chuiquin: —Utsibo chuiquin: “Con Icbo Esus nec. Nuquin Papa yacno ëbi puduedmequid nec,” quequin chianequid Nuquin Papa yacno chosho isun: “Nëid ëbi tantiaquid neque. Puduedmeta, Papa,” quequin Nuquin Papambo chiendambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Padnuen utsibo chieshec: “Con icbo Esus catiapimbo iquebi. Tantiatiapimbo iquebi,” quequid bëdamboen istiapimbo iquebi. “Nuquin Papa yacno puduednu,” quesho: “Padi. Ëbi tantiaquidpenquio neque. Puduedmenda,” quequin Nuquin Papa chiendambi —quequin Esusën chuipondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Adshumbic padpiden chuiquin: —Ëmbi chuiboed tantiashun: “Nuquin Papa yacnuësh choquid icquin abitedimbo bëdamboen tabadmetsiash,” ¿caquindabi ique? Padenquio ictsiambi. Ëbi tantiaquidobëd ëbi tantiesabo cuëshëdenquio icte danenda. Ëbi tantiaquidobëdi ëbi tantiesabo cuëshëdendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Amëbëd aton mado cuëshëdendac. Adecbidi anibëd aton champi cuëshëdendac. Adecbidi aton chayabëd aton babanën cuëshëdendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aden aton shubun icquidombi ëbi tantiaquid chieshënendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Padnubic aton matsesuidi tantiaquidën ëbi bëdiactsëc tantiatsëctsiash. Aton tita tantiaquinc aton papa tantiaquinc cain aidën chiacpadomboenuidtsëqui naquidën ëbi bëdiactsëc tantiatsëcquin ëmbi chiacpadomboen natiapimbo ictsiash. Adembidi aton mado tantiaquinc aton champi tantiaquinc cain aid bëdambo icmeteuidtsëqui bunquin ëbi bëdiactsëc tantiatsëcquin ëmbi chiacpadomboen natiapimbo ictsiash. Adquido bëdamboen istiapimbo iquebi. Ëbi tantiesabo nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Utsibon chieshënac ëbi tantiatsëcboedi badedi chieshtoshon ëmbi chiacpadomboen natiapimbo yantsiash. Adquidotsen ëbi tantiaquidpenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Matses ambi naiduidi naquid Nuquin Papa yacno puduedtiapimbo iquendac. Padnuen ëbi tantiaquin ëmbi chiacpadomboen naquid Nuquin Papa yacno puduedendac. Adquid chieshënaqui chieshtoenquio ictsiash —quequin Esusën chuipondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Adshumbic Esusën ëbi chedo padpiden chuipondash. —Mibi chieshënquido icnubi mibi bëdamboen isquid iquendac. Ëmbi naid mimbi chuisho tantiash: “Ai, abimbo caic,” queshun ëbi tantiabenquin ëbi chomequidtsen tantiabenendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“Naden naindambi,” quequin ambi chiaid chuibenequid Nuquin Papan bëdamboen isaido nec. Adquid shubu utsi yacno nidacsho isash: “Nuquin Papan chiaid chuibenequid choeque. Bëdamboen chuisho tantianu,” quequid icsho Nuquin Papan bëdamboen isendac. Adembidi abi tantiec ambi chiacpadec bëdamboec tabadquid Nuquin Papan bëdamboen isaidobidi nec. Adquid shubu utsi yacno nidacsho isun: “Nuquin Papan chiacpadec tabadquid nec,” queshun bëdamboen isquidotsen Nuquin Papan bëdamboen isendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Adembidi ëbi tantiaquid yec acte bundoacsho acte menequid Nuquin Papan cuidnanquin bëdambo icmendac. Adembidi utsibon Esus tantiaquido bëdamboen nashunsho Nuquin Papan bëdambo icmendac —quequin Esusën chuipondashi. Adshun: —Chuibenetan —cac nidshumbimbi chuibenepondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Esusën: —Chuibenetan —cac abëd icquido nidanenubi auëshquiobi puduanec nidquin shubu dadpen icquid shubu dadpen icquidquien Esusën Nuquin Papan chiaid chuibeniac caondash. Aid nidaid cuëshë Cadidia caidën capucuenequin adoac caondash. Adnubini yuec-yuecpambo ictanec Esusbëd icoaic cho-chopondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Adnubien Uanën Esus acten mentondaidëmbi quënën nauedaid icquin Esusën naid tantiapac caondash. Adshumbic abëd icquido chuiquin: —¿Nuquin Papan chomiaid nuqui cainaidta nepec? Esus chuitan —cac choshon Uambëd icquidon Esus chuituidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Uanën: “Chuitan,” cac chobi. ¿Ëmbi cainaid Nuquin Papan chomiaidquioda mibi nepe? Mibi adquidpenquio icnuc ¿ada utsi chopatsiash? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Esusën: —Ëmbi nadatiambo icquin nabamboedbëdta ëmbi chuiboed Uan chiec nid. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Bëshuacboedën isbenosh. Canite icsaidi capucuenosh. Daushumbo icquid nami mishadenquio icquid bëdanosh. Pashuacboedën tantiabenosh. Adoshombic unësaidi uincuemiosh. Adoshombic Nuquin Papa tantienquio icquido Nuquin Papan bëdamboen iste chuiposh,” quequin Uan chiec nid. Aden chiac Uanën: “Nuquin tsusedpan chiampicpadquid Nuquin Papan chomiaidquio nec,” quequin ëbi tantiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Adshumbic nadentsen chuita. “ ‘Muambo nec, ëbi cainquio icquin: Ambi chiacpadquid Nuquin Papan chomiaidien nec, quequin ëbi tantiaquid Nuquin Papan bëdambo icmendac,’ quiosh,” quequin chiec nid —cac nidanepondash Uambëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aido nidanebon Esusën Uan acten mentoanquid chuiquin abi datsidadquido naden chuipondash. —Matses nibëdacno ¿atotsi quenuec nidonda? ¿Cunquequidën ishcunaid isnuecta nidtionda? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Dashcute bëdaidquio dasiuidaid isnuecta nidtionda? Padenquio. Icsactsëcquid Uan dasiuidpondash. Dashcute bëdamboshë icquid dasiuidquido ancanquidën shubu dapan tabadquido nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ad icnuc ¿atotsi quenuec nidonda? “Naden naindambi,” quequin Nuquin Papan chiaid chuibenequid chuisho tantianuec ma mibi nidondac. Adec Nuquin Papan oncamiaidquio Uan nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uanën abia choshon chuite chuiquin Nuquin Papan naden dada uamepampic. “Mibi chote chuiquidba chomembi, Mado. Aid: ‘Bëdambo icquid choeque. Icsainquio yec ënëdta,’ quequin mibi chote chiendac, Mado,” quequin Nuquin Papan ambi chiaid dada uamepampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nuquin Papan chomiaidquio choec,” quequin chuiquid Uanpadquid utsi nibëdec. Adquid yequi: “Abi choec,” quequin ambi chuiboedën ëmbi nabansho isabi yequi bëdapabi Uan ictsec. Padnuen ëmbi Nuquin Papan chiacpadomboen nabansho isash ëbi tantiaquido bëdamboshë iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Uanën chuisho Nuquin Papa tantiabenacpadomboen ëmbitsen Nuquin Papan bëdamboen iste chuisho tantiashun adembidi abi icsaid ënshun icsaboedon dadpenshun Nuquin Papa tantiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nëbi Uanën: “Nuquin Papan abi yacnoshon bëdambo icquid chomendac,” quequin chuipondash. ¿Ambiada adopondash? Padenquio. Ëndenquimboshë tauamboen nuquin tsusedpa Moisesën chuibempampic. Adshumbic utsintsen. Adshumbic utsintsen. Aden Nuquin Papan ambi bëdambo icquid chomete chuiquin dada uamianepampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Adembidi Uan chote chuiquin dada uamepampic. “Nuquin Papan ambi tantiacpadomboen oncamiaidquio Edias cuëmëdquid choendac,” quequin Ediasbimboecquid Uan chote chuipampic. Bëdamboen tantiaquin: “Nuquin tsusedpa Ediasbimboecquid Uan nec,” mimbi catsiac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bëdamboen tantiaquidën adembidi tantiatsiash —quepondash Esus abi datsidadquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aden chuisho tantiash chieshtoshobien Esusën chuipondash naden. —Nuquin Papan chiaid tantienquio icquido yec nëmbo icquido ¿midapadquidoen nec? Bacuëbo nëishnanacbictsëcquiec mibi iquec. Bacuëbo: “Ëmbi chiacpadomboen nanuna,” queuidash ambi chiacpadomboen aton utsibon nainquio icsho isash nëishash chushcananquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Cuëdënuna,’ queuidbosh ëbi cuëdënubi ma mibi cuëdënenquio icboc. ‘Sedenquenuna,’ queuidbosh ëbi sedenquenubi ma mibi sedenquenquio icboc,” quetsash bacuëbo nëishnanacbictsëcquiec ma mibi iqueyoc. Adec nëishëmënquido yec icsambo ma mibi iqueyoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Uan pete utsi-utsien pesa iccosh. Adecbidi acte paëmbo icquid aquesambo niosh. Adquid icsho isash nëishash: “Ëmbi nacpadomboen naisa nec. Podobitsi icsa dapuduedashien nechitec,” mibi quepondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ëbien nuquin matsesën piacbimboen pequid nec. Adembidi actequid acquid nebi. Adsho isash nëishun ëbitsen icsamboen chuishunquin: “Peteuidi tantiaquin nua pequid nec. Tantiadenuen acte paëmbo icquid acquid nec. Adecbidi nuquin matses piucquid bedshunquidobëd onquec icsambo icquid caidobëd onquec quequid ma aidobëdi icsambo icquid nepayoc,” mimbi ëbi capec. Padnuen bëdamboen tantiaquidën Nuquin Papan chiacpadomboen nasho isun Uambëdta ëbi: “Bëdambo iquec,” caindac —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Adshumbic Esusën padpiden chuipondash. —Nëbi shubu dadpen icquid shubu dadpen icquidquien comapenen tantiaquid icquin dadpen nabanquin ismebeniombi. Aden ismiac: “Icsaboedi bëdamboec tabadtiadquio iquebi,” quetiadquidi chieshec adenquio iquec —queshun Esusën naden chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Shubu dadpen icquid Codasin caid yacnocquidobëdi shubu dadpen icquid utsi Betsaida caid yacnocquido Nuquin Papan cuidtequido nec. Ëmbi aido ismebocpadomboen ismiac isadaidpembo cuidadenquio ictsempampic. Aden ismiaqui: “Ai, icsapobi,” quiash shubibudequi icsainquio yec ënëdtsempampic. Shubu dadpen icquid Tido caid yacnocquidobëdi shubu dadpen icquid utsi Sidon caid yacnocquido adtsempampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nuquin Papan matses abitedi cuidte ushën: “Nadatiambo icquin nabanquin ismiacmaido nec,” queshun Tido caid yacnocquido Sidon caid yacnocquidobëdta bëdiactsëc cuidendac. Adoshombic: “Comapenen tantiaquin ismiaqui tantienquio icquido nec,” queshun Codasin caid yacnocquidobëdta Betsaida caid yacnocquido comapenec sidquenuc cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Adembidi nëmbo icquido Capednaun caid yacnocquido mibitsen Nuquin Papan cuidendac. “Nuquin Papa yacno tabadtequido nuquitedi nec,” ¿quecta ique? Adquidpenquio yec Nuquin Papa chieshënquido cuidacno nidmetequido ma mibi nepayoc. Ëndenquimboshë yampido shubu dadpen icquid Sodoma caid yacnocquido cuidquin Nuquin Papan nibëdamepampic. Ëmbi mibi ismebocpadomboen ismiac aidon abi icsaid ëntsempampic. Abi icsaid ënsho Nuquin Papan cuidenquio ictsempampic. Cuidenquio yac nëbi aton matses abi ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nuquin Papan matses abitedi cuidte ushën: “Comapenen tantiaquin ismiacmaido nec,” queshun Sodoma caid yacnocquido bëdiactsëc cuidendac. Nuquin Papan chomiaid icquin ëmbi ismeboedo Capednaun caid yacnocquidoen comapenec sidquenuc cuidendac —quequin abi tantiesabo Esusën chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Adshumbic Esusën Nuquin Papa chuipondash. —Mibi bëdamboshë iquec, Papa. Mibi yacnocquidotedishun Icbombo yec nidaidën tabadquidotedishun Icbobidi mibi nec. Mimbi tantiamiabi: “Dadpen tantiaquid nebi,” quequidombi ëbi tantiabi iquec. Mimbi tantiamiac nëidon ëbi tantiec. Aden mimbi bëdamboen naic. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mimbi tantiacpadomboen mimbi bëdamboen naic. Mibi bëdamboshë iquec, Papa —quequin Esusën Nuquin Papa chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Adshumbic abi datsidadquido chuipondash. —Nuquin Papan ambi tantiaidtedi ëbi chuimec. Ëmbi naboedbëdta ëmbi nate abitedi con Pan ambentsëqui tantiec utsibon tantienquio icnuc. Adembidi Nuquin Papan natebëdta ambi naboed abitedi ëmbentsëqui tantiembi. Aden Nuquin Papa tantiaquin: “Nëidtedi matses bëdamboen tantiamembi,” queshun: “Nuquin Papa nadquio iquec,” quequin tantiamembi. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ëbi tantiata. Dayacquio yacbimboecnuc mibi bëdambo icmembique. “¿Mitsipadequibi Nuquin Papa yacno puduedpe?” quec ¿uimambo yacbimboecta mibi icpe? Adquidën ëbi tantiasho Nuquin Papa yacno puduedtequid mibi icmembique. Ëbi tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Con Icbo ëbi cata. Con yuambo icquin ëmbi chiacpadomboen nasho mibi bëdamboen isquin dayacquio yacbimboecnuc mibi bëdambo icmembique. Ancanesambo yec bëdambo icquidini neque. Con Icbo ëbi cata. Adsho mibi bëdambo icmembique. ");
INSERT INTO mcfNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mibi ancainquio icquin dayacquio yacbimboecnuc bëdamboen mibi tabadmembique. Con Icbo ëbi cata —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Adshumbic chonoadtemaid ushën Esusbëd capucuenequin tied matanquin bundotsëcshun tiedën caniquid ëshchicshun petempi petsëccondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pesho istuidshumbini con tsusedpabon chiampid namequido padiseyobon: —Is. Mibëd icquido chonoadtemaid ushëmbi chonoadeque —capondash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Adoaquien Esus: —Ma icsapenquio icpayoc. ¿Nuquin tsusedpa Dabidën bundoshon ambi petemaidquio pepampid chuiquin dada uapampid isamboda ictio? ");
INSERT INTO mcfNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aidën Nuquin Papa tabadte shubu uashunaid abi puduedtemaidën puduedshun ambi petemaid pan sanaid istuidpampic. Aid panëmpi nëish yua abided unës uaquidon petequid nepampic. Aid panëmpi bedshun abëd icquidobëdtan Dabidën pepampic. Aden nuqui bëdambo icquid caidën ambi natemaidi napampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Adembidi chonoadtemaid ushën natemaid chiaid niacquimbi nëish yua abided unës uaquidon aid ushëmbi Nuquin Papa tabadte shubu uashunaidën puduedshun nacnendenepec. Nuquin Papan chiacpadomboen naiqui icsainquio icpec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nuquin Papa tabadte shubu uashunaid tantiaquin adopec. Aid shubu bëdapabi icnuc bëdamboshë icquid nebi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nuquin Papan naden chiaid mimbi bëdamboen tantienquio iquec. “Ëmbi chiacpadomboen abentse-abentsen mimbi naic. Adoquimbi ëmbi chiaid utsi niaquec mimbi icsaido caido mimbi bëdamboen istiapimbo iquec. Adsho isun: ‘Mibi bëdambo iquec,’ catiapimbo iquebi.” quequin Nuquin Papan chiaid bëdamboen tantiashun ëbëd icquidon bëdamboen nasho mimbi chushcainquio ictsenoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tantia. Nuquin Papan chomiaid icquin chonoadtemaid ushë ëmbibi chiampid icnuc ëmbi tantiacpadomboen aid ushëmbi ëbi tantiaquido namembique —quepondash Esus ëmbi petsëcsho istuidquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Adanec nidec Nuquin Papan chiaid chuibante shubun puduedshun ");
INSERT INTO mcfNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","isaquien mëicsatsaid icpondash. Adnubien padiseyobon: —Chonoadtemaid ushëmbi bëdamequid Nuquin Papan chiaid niacquidien nechitec. Nuquin Papan chiaid Esus niacmenuna. Aden niacmeshun: “Icsambo mibi iquec,” canuna —queshun Esus chuituidpondash. —¿Nadquid chonoadtemaid ushëmbi matses bëdamequinda Nuquin Papan chiaid niacpec? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Esusën: —¿Ada min nëish yua obeca caid icpec? Adquid chonoadtemaid ushën shëcuë uquëduc ampaëdacsho istuidshun ¿chiquenquioda mimbi icpatsia? Ai, mimbi chictsiac. Chonoadtemaid ushëmbi mimbi chonoadquin chicpatsiac. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aden min obeca bëdiactsëc tantiec mibi bëdapabi icnuc matses tantiaquioquin nashunquid bëdamboshë ictsiash. Nadquid chonoadtemaid ushëmbi matses aden bëdamboen nashunquidën Nuquin Papan chiaid niaquenquio ictsiash —quequin Esusën abi icsamenu caquido chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Adotanquimbien Esusën mëicsatsaid chuiquin: —Mëcueta —cac mëcuec bëdampondash aton mëdante abiuc daëdi bëdambo yec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Adsho isashien abi chieshënquido padiseyobo nëishquiopac caondash. Adec nëishanec nidash aton matses utsibobëd: —Cuesunequimbien Esus ictiad —quecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Adnubien Esus: —Ëbi cuesunetiadquio iquec —quianec auëshquiobi puduanec nidpondash. Nidsho isumbien matses dadpenshun tsibanampondash. Adshumbic aidon bëaid daicsaidotedi bëdamebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Adshumbic ambi bëdamiaido chuiquin: —“Bëdamioshi,” quenda —quequin chuipondash Esusën: —Ëbi abi chuiquid dapa icmenushe —quiash adpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aden Esusën nate chuiquin Nuquin Papan isadaidbo tsusedpa Isayas dada uamepampic naden chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ëmbi chomiaid ëmbi chiacpadomboen naquidquio nec. Aid tantiaquiec bëdambo iquebi. Con Mayan bëdambo icquid abëdi tabadmembi. Adoac ëmbi bëdamboen iste isadaidbobëdta matses utsibo abitedi bëdamboen chiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Chushcanante bunenquio yec ancanenquio iquendac. Chuiquid dapa ictiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Icsambo icquido yec shubiquido yec natiaic tabadquido yec daicsaido yec quequidon abi bëdiactsëc tantiabentsëcsho bëdamboen isquin bëdamboen tantiamendac. Nuquin Papan chiacpadec cuidte ushë choabi icnuc adoendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","‘Nuquin Papan tantiacpadomboen matses bëdamboen namendac,’ queshun nidaid utsi-utsiec yacnocquidon matses dadpenshun aidi tantiendac,” quequin Esusën bëdamboen nate chuipampic Isayasën. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Adnubien Esus ismenuen daicsaid bëpondash. Dapuduedshun podobitsi icsan bëshu uain eme uaidi onquesa nepondash. Isenquio yec onquenquio icshobien Esusën bëdamepondash. Adoac isbenequi onquiampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Adsho isashien Esus datsidadquido: —Is. Comapenen tantiaquin nabanquidquio nëid neque. ¿Nuquin tsusedpa Dabidën tsyuecquidta nepec? Adquid yec nuqui cainaidquio Nuquin Papan chomiaidien nechitec —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Adsho tantiash Esus chieshënquido padiseyobo: —¿Aidta nedic? Ma aidpenquio neyoc. Betsibu caidën podobitsi icsan icbon namiaid icquimbien Esusën podobitsi icsa cuemechitec —quequin otacquio tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Adshobien Esusën aidon otacquio tantiaid ambembi tantiashun naden chuipondash. —¿Adquidënda aton yuabi cuemepatsiash? Padenquio. Chuiquid dapan aton yuabo nëishtanquin chushcac cuësh-cuëshëdec aton yuabo uesadec nietsiash. Aido nibëdnuc chuiquid dapa ictiapimbo ictsiash. Adecbidi shubu dadpen icquidën tabadquido chushcananash cuësh-cuëshëdec niquian shubu dadpen icboedi daëdpactsëc yanec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Betsibu caidbidi Satanas caidëmbi namiaquien podobitsi icsa cuemechitec,” mimbi ëbi capoc. ¿Ambi naid nashobida Satanasën aton yuabo podobitsi icsabo cuemepatsiash? Padenquio ictsiash. Satanasën cuemiac aidbëdi aton yuabo cuësh-cuëshëdtsiash. Adnuc Satanas aton icbopenquio yantsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mibëd icquidon podobitsi icsa dapuduedaid cuemiac caosh. ¿Cuemesho isun mimbi ëbi chiacpadomboen: “Betsibu caidën namiaquien nachitec,” cainda ictio? Ma mimbi padenquio icpaboc. Mimbi adoac: “Mimbi icsamboen chiec,” quetsenosh podobitsi icsa dapuduedaid cuemequido mibëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nuquin Papan Mayanën namiaquimbi podobitsi icsa cuemioc. Ëmbi adosho isash: “Nëbi matsesbëd icquin Nuquin Papan namiaidën naosh,” quetiadquidi mibi nec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Adashic abi onquec: —Tantia. Mibi chuinu. Ampenuesho icbon istuidac ampequidën icbo uidën uabi ampeshuntiapimbo iquec. Icbo uidënquio icquid bucun cataneshun ampeshunquid. Adecbidi Satanas bëdiactsëc tantiaquid icnuc ëbien comapenen tantiaquidquio nec. Uidën uacbimboen nadatiambo icquin nabanquin aton yua cuemepombi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ëbi con icbo cainquio icquido Satanasën yuabo nec. Adquid icquin ëbi chieshënquin ëbi tantiatsëcquido cuëshëdmendac. Adquidbidi mibi nec —quequin Esusën abi chieshënquido chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Adshumbic nadentsen chuipondash. —Nuquin Papan chiaid niac-niacboedëmbi ënacsho Nuquin Papan bëdamboen isec. Nuquin Papan icsamboen chuishunquidëmbi abi icsaid ënacsho Nuquin Papan bëdamboen isec. Aton Mayanën namiacsho isash: “Icsambo iquec,” quequin bëdamboen tantienquio icsho Nuquin Papan bëdamboen istiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ëbi chieshënquin icsamboen chuishunquidëmbi ënacsho Nuquin Papan bëdamboen isec. Aton Mayanën namiacsho isash: “Icsambo iquec,” quequin icsamboen tantiasho Nuquin Papan bëdamboen istiapimbo iquec. Aden ënenquio icquin icsamboen tantiasho adembidi ënenquio icquin bëdamboen istiapimbo iquendac —quequin abi chieshënquido Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Adshumbic naden bëdamboec tabadte Esusën chuipondash. —Cuëte bëdan bacuë bëdambo iquec. Cuëte icsan bacuë icsambo iquec. Chetequid isun cuëte dada matsesën tantiec. Adembidi matses bëdambo icquid bëdamboec onquec bëdamboec tabadsho isun: “Aid bëdambo icquid nec,” quequin matsesën tantiatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma mibi adquidpenquio neyoc. Nisibimboec icsa uanquido mibi nec. ¿Icsambo icquinda mimbi bëdamboen chuidio?. Ma mimbi padenquio icboc. Mimbi icsamboen tantiaid ma mimbi utsibo icsamboen chuiboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bëdambo icquidën ambi bëdamboen tantiaid bëdamboen chuitsiash. Icsambo icquidëmbien ambi icsamboen tantiaid icsamboen chuitsiash. Aden mimbi icsamboen chuipoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ambi cuidte ushën Nuquin Papan: “¿Ada bëdamboen tantiaquin chuidenio?” quequin matses abitedi chuimendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Adoac abimbo chiec: “Ai, bëdamboen nadeniombi,” quesho icsano nidmenquio iquec. Padnuen utsi: “Padenquio. Icsamboembimbi chuidenechitoc,” quesho icsano nidmequin cuideque. Icsamboec onqueboedi ënëdta —quequin Esusën abi chieshënquido chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aden chuisho tantiashumbien abi chieshënquido utsibon Esus chuituidpondash. —“Nuquin Papan chomiaidini nec,” quequin ëbi ismequin nadatiambo icquin nabanta. Isnu —quepondash padiseyobo Moisesën dada uapampid chuibanquidobëdi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Adoaquien Esus: —Padi. Nuquin Papan chiaid niac-niaquec mibi icsamboshë iquec. Ëbi tantiate bunenquio icquimbi mimbi: “Ëbi isme,” ëbi capec. Adsho nëbi mibi ismenquio iquembi. Yuecshumbimbi mibi ismendac. ¿Ada nuquin tsusedpa Onas caidën nampid tantie? Aid yampicpaden naindambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chishcambiecquid dapan chebudac aidën pucun uec daëdec ushacsho ucbudac Onas padpidec nidpampic. Adecbidi unësacsho chococac Onas yampicpadec daëdec ushash uincuenendabi. Aden ismendambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ëbi tantienquio yec mibi icsambo iquec. Padnuen Nuquin Papan chiaid Onasën chuibanac shubu dadpenquio icquid Ninibe caid yacnocquido badedi icsainquio yec ënëdpampic. Nuquin Papan chiaid chuibanquid Onas bëdambo icpampic. Ëbien bëdamboshë icquidquio nec. Adquid icquin nadatiambo icquin dadpen ismiaqui mimbi ëbi tantienquio iquec. Aden ëbi tantienquio icquido icsho Nuquin Papan matses abitedi cuidte ushën Ninibe caid yacnocquidon: “Icsambo iquec,” mibi caindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Adquid cuidte ushëmbi matses utsi Sud yacnocquido ancaquidën nuquin tsusedpa Sadomonën chuisho tantiec chopampidëntsen: “Icsambo mibi iquec,” mibi caindac. Aid ancaquid chido nepampic. “Isadaidbo ancaquid Sadomon cuëmëdquid dadpen tantiaquid nec,” quequin chuituidac Sadomonën chuisho tantianuec nidshun aid chidon tantiatuidpampic. Adash: “Nuquin Papan tantiamiaidënquio Sadomonën bëdamboen chuipec,” quepampic. Ëmbien abitedi tantiaquid icquin nadatiambo icquin ismeuidpoc. Adoaqui mimbi tantienquio icpec —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Adshumbic naden Esusën chuipondash. —Icsaquido mibi nec. Podobitsi icsa dapuduedaidbimboecquid mibi nec. Tantia. Mibi chuinu. Abi dapuduedaid matses nianashi podobitsi icsa abi dapuduedtequid nibëdacno yuec capucuen-capucuenec. Adtanequi: “Ëbi icbocnobidi dapuduedoaic nidebi,” quianec choec. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Chonobi ambi niamboed matses: “Ëbi dapuduedaid podobitsi icsa nibëdnuc bëdambo iquebi. Adquid chomeoatiapimbo iquebi. Ëmbimbo naic bëdamboec tabadquidquio nebi,” queuidpec. Adshobien ambi niamboed podobitsi icsan istuidoapec. Istuidoashic: “Dapuduedtequidquio nëid nec,” quianec ");
INSERT INTO mcfNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","abipadquid utsi bedec nidoaic. Nidshumbic 7tedi icsamboshë icquido istuidshun bëash aidobëdi dapuduedec. Adnuc podobitsi icsa abentsëc dapuduedaid yec ënden icsambo icboedi aido dadpen dapuduedaid yec buëdanquiec aid matses icsamboshë yanec. Adquio mibi iquec. “Bëdambo iquebi,” queboedi nëbi mibi icsamboshë yanec —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Adanec shubun puduedshun Esusën abëd puduedquido dadpen chuinubi aton utsibo aton titabëdi Esus isnuec chopac caondash. Umanuc tabadnubi ");
INSERT INTO mcfNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","utsin puduedshun Esus chuituidpondash. —Mibi isec tita min utsibobëdi choaccosh. Umanuc tabadec —caquien badedi nidenquio yec ");
INSERT INTO mcfNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Esus: —Utsitsen con ta caimbi. Adembidi utsitsen con utsi caimbi —quetanquin ");
INSERT INTO mcfNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","abëd icquido mëdquin ismepondash. —Nëid ëbëd icquido con utsibo caimbi. ");
INSERT INTO mcfNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nuquin Papan chiacpadomboen naquidquio icsho con matses caimbi. Con utsi caquinc con chibi caquinc con ta caquinc caimbi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Adtanec nidec chian budash cuëmano tabadtuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tabadtuidsho isash matses dadpenquio cho-choash tsucus-tsucustsëcquio yec Esus datsidadpondash. Adsho istanec cano dapa antabëdtoash cuëma anoentsëc canon nuadquin Esusën chuipondash cuëmano tabadquidon tantianubi. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Adshumbic abi tantiate chuinuen naden ompoacbimboen chuipondash. —Piacbo ëshë siaid utsi-utsiec bëdamboec caniec. Utsi-utsiec padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Abitedi ansecanu,” caidi utsi-utsiec shëcuë nibëdacno paëdec. Paëdacsho paëdaid uicchunën chequid. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ëshë utsibic nidaid tsasimbo yacno siac badedi dëyucuidash ");
INSERT INTO mcfNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","aton tapun nidaidën puduedenquio icnuc ushë chënquequidën badedi unësquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ëshë utsibic nisanquid diadacno siaid dëyucash canidouidtsëcsho nisanquidën dayunac unësquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Padnuen ëshë utsi-utsiec nidaid bëdanquio siac dëyucash caniash dadpenquio ëshëquid. Utsi-utsiec 100ted ëshëquid icnubi utsi-utsiec 60ted ëshëquid icnuc utsi-utsiec 30ted ëshëquid —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Adashic: —¿Min pabiate shëcuë nibëdquiecta iquec? Ëmbi chuiboed bëdamboec pausudta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Adsho tantiashun abëd icquidon Esus chuipondash. —¿Atotsieshun ompoacbimboen nëid matses dadpen chie? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Esus nadpondash. —Utsibo tantiamenquio icquin Nuquin Papabëd tabadte chuiquin nëbi mibiuidtsëqui tantiamembi. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nuquin Papa tantiatiadquio icquidën ëbi tantiasho bëdamboen tantiamendambi. Nuquin Papa tantiauidtsëcquidën ëbi tantienquio icsho ëmbi ompoacbimboen chiac tantienquio ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ompoacbimboen aido dadpen chuibanembi. Ëmbi naid isun ëbi tantienquio iquec. Ëmbi chuisho pamumëdacbimboen tantienquio iquec. Adsho aidon tantiatiapimbo icnuc chiembi. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nëidon tantienquio icte chuiquin Nuquin Papan nuquin tsusedpa Isayas caid naden dada uamepampic. “Chiac tantiaboshombi tantienquio iquendac. Ismiac isquioboshombi: ‘Ai, aidi nec,’ cainquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ai, ëmbi chiaid tantiatiapimbo iquec. Ushacbimboen tantienquio yec pamumëdacbimboec chieshëmënquidombo iquec. Ëbi tantiate bunenquio iquec. Ëmbi chiaid tantiaquidombien paposhquiacbimboen bëdamboen tantiabentsiash. Pausunacbimboen tantiashun ëmbi chiacpadomboen natiadquio yansho aton chiesh bëdametsiambi. Aton chiesh bëdamete bunenquio iquec,” quequin Nuquin Papan dada uamepampic —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Adashic aidobidi chiec: —Isayasën chiacpadomboen utsibon ëbi tantienquio icnubi mimbien ëbi tantiec. Ëbi isec mibi tabadec. Ëmbi chuibansho tantiash: “Ai, abimbo caic,” quec mibi bëdambo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ëbi chote chuipampidobëdtan bëdamboec tabadquido dadpenshun mimbi ëbi isacpadomboen ëbi iste bunequi ëbi isambobi unëspampic. Mimbi ëmbi chuisho tantiacpadomboen tantiatiadquio yequi tantiambobi unëspampic —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Adashic abi onquec: —Tantia. Ëmbi piacbo ëshë siaid quequin chuiboed sebadënquio mibi chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nuquin Papabëd tabadte chiaid piacbo ëshë siaidbimboecquid nec. Nuquin Papan chiaid chiaqui tantiadenquio icsho Satanasën nac badedi bëshumpec. Uicchunën piacbo ëshë paëdaid badedi chiacbimboen adopec. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Utsibic Nuquin Papan chiaid chiaqui bëdiactsëc tantiauidtsash: “Bëdambo iquec,” quec cuishonqueuidtsec. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Adsho: “Nuquin Papan chiaid tantiaquid nec,” queshun utsibon chieshënac badedi chieshtoshon tantienquio yanendac. Piacbo ëshë tapunuidtsash unësacbimboen adoendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Utsibic Nuquin Papan chiaid tantiatsashi ambi dacuëdquin tantiaiduidi tantiequi chieshtopec. Utsibic tantiauidtsash ambi bedtequiduidi tantiequi chieshtopec. Nuquin Papan chiaid tantienquio icpec. Isitodon dayunac unësacbimboen adoendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Padnuen utsibon tantiate nidaid bëdan siaidbimboecquid nec. Nuquin Papan chiaid chuisho tantiaquioshon ambi tantiaid bënuainquio icquin tantiabudec bëdamboec tabadec. Adshun aidën chiac utsi dadpenquioshë ëbi tantiaquid yanendac. Utsin chiac dadpen adecbidi ëbi tantiaquid yanendac. Utsin chiac daëdpactsëc adquidbidi yanendac —quequin abi tantiate chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Adshumbic Esusën naden chuipondash. —Tantia. Nuquin Papan namiaid tantiamenuen utsi chiacbimboen chuinu. Tiedën caniquid pete adosbiecquid icbon siac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Adanec nidambic inchëshëmbi choshon chieshëmënquidën ëshë icsambo icquidtsen daëd uain seuanac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Adoac adosbiecquid canidotsëcnubi abëdi tancandaëdpamboec icsambo icquid canidotsac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Adsho istanquin yuabon aton icbo chuituidpac caondash. “¿Pete ëshëda sio?” cac: “Ai,” quesho tantiash: “Icsambo icquidbëd tancandaëdec canidopacboc. ¿Mitsipaden sio?” quequin yuabon icbo chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Adoaquien: “Chieshëmënquidëmbien seuanchitash,” cac: “¿Chicshunetanquindambi icpe?” yua quesho: ");
INSERT INTO mcfNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Padi. Petebëdi chiquidtsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aidbëdi ma canipanuna. Ëshëacsho tacuesquimbi teshun sianun nanuna. Adoshombic icsambo icquid tsindobanshun nëdëncanun nanuna. Icsambo icquid nëdëncatanquimbic pete bedshun sandoshon shubun dectandonon nanuna,” quepac caondash tied icbo —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Adshumbic abi tantiaquido dadpen yante tantiamenuen Esusën naden chuipondash. —Cuëte bacuë ëshëmpi ");
INSERT INTO mcfNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","pistsëcquidi nuamboshë caniec. Aid cuëte cuidin uicchun dadpen tabadtonec. Adecbidi ëbi tantiaquid abentsëcshun bëdamboec tabadquin ismiac ëbi tantiaquid dadpenquio yanendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Adshumbic Esusën abi bëdamboen tantiate chuipondash. —¿Mitsipad nami uaid icpec? Aniactsëc nami uashun utsibëdta daëd uain cabiunac abichobi batambo yanec. Adembidi ëbi bëdiactsëc tantiatsëcboedi ëmbi chiaid tantiash ëbi bëdamboen tantiaquid yanendac ");
INSERT INTO mcfNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","—quequin Esusën chuipondash. Sebadënquio chienquio icquin ompoacbimboenuidi Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aden Esusën chuite chuiquin Nuquin Papan dada uamepampicpadomboen nanuen adopondash. Nuquin Papan dada uamepampid nad iquec. “Sebadënquio chienquio icquin ompoacbimboenuidi chuibanendambi. Ëndenquimboshë matses uaboshombi Nuquin Papan ambi tantiaidi ambi uaido chiambo iquec. Adembidi aidon tsyuecquidotedi chiambobidi iquec. Nëbimbi chuibanendac,” quequin nuquin tsusedpan Esusën chuite dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Adashic matses dadpen tabadacnuësh nidec Esus shubun puduedondash. Puduedshobien abëd icquidon chuipondash. —“Chieshëmënquidën ëshë icsambo icquid siaid nec,” quequin mimbi chuiboed en sebadënquio chui, Icbo. Tantianu. ¿Atotsi chuitiadquio icquin aden chio? ");
INSERT INTO mcfNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","—caquien Esusën chuipondash naden. —Tantia. Mibi chuinu. Pete ëshë bëdambo icquid sequidbimboecquid nebi. Nuquin Papan chiaidquio tantiamequin matses bëdambo icmequid nebi. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Padnuc tied dapabimboecquid nidaidën tabadquidtedi nec. Padnuc pete ëshëbimboecquid ëbi tantiaquid nec. Nidaid utsi-utsiec yacno tabadquido utsi-utsien ëbi tantiaquid icmendambi. Padnuc ëbi chieshënquid Satanasën yuaido icsambo icquid siaidbimboecquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Padnuc ëshë icsambo icquid sequidbimboecquid Satanas nec. Aidën yuaido matses icsambo icquidon ëbi tantiaquidobëd tabadquin icsametiadquio iquec. Adsho badedi cuidenquio icquin Nuquin Papan cuidte ushë choabi icnuc matses icsambo icquidobëd bëdambo icquido tabadmendambi. Padnuen ambi chiacpadën Nuquin Papan abi yacnoshon uaido mayan bëdabon ëmbi chiacpadomboen naindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Icsambo icquid tsindoshon nëdëncacbimboen Nuquin Papan cuidte ushëmbi icsambo icquido cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ëmbimboen mayan bëdabo namendac. “Icsamianquidobëdta icsaidotedi bedshun chian anëdënquiacno nëseca,” quequin ëmbi chiac ");
INSERT INTO mcfNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bedshun chian anëdënquiacno nësecaindac. Adoac natiaic mëyadbudec sidquequiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Padnuen ëbi tantiec bëdamboec tabadquido Nuquin Papa yacno nidash icsatiapimbo icquid iquendac. Ëmbi aden chuiboed tantiashun ëmbi chiacpadomboen nata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Adshumbic padpiden Esusën chuipondash. —Tantia. Matses ambi istuidaid bedte comapenec bunquiaid mibi chuinu. Utsin tied nantan nidshun dadan ëndenquimbo ompoampid piucquid dadpenquio icquid istuidpac caondash. Istuidash aid bedte comapenec bunquiopac caondash. Adshun aton na abitedimbo menequin piucquid bedshun tied icbo aid piucquid meneshun: “Nëbi con tied nec,” queshun piucquid ompoampid bedpac caondash. Adomboen matsesën Nuquin Papabëd tabadte bunquin aton nauidi nainquio icquin Nuquin Papan chiacpadomboenuidi nac bëdambo ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tantia. Casëdu bëdaidquio bunaidtsen mibi chuinu. Dadan casëdu bëdaidquio bunquin bednuen nibënbenepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Adshun bëdaidquio istuidash: “Nadquid utsi nibëdec,” quiash comapenec bunquiac caondash. Adshun aton na abitedimbo menequin piucquid bedshun casëdu icbo menequin aid casëdu bedac caondash. Adomboen Nuquin Papabëd tabadte bunquin matsesën ëbi tantiaquiac bëdambo ictsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Adshumbic Esusën naden chuipondash. —Tantia. Mibi chuinu. Nuëcquid nibedacbimboen naindambi. Isadaidbon nuëcquid dadpenquio bedte nëshaid dapa acte nënequin ");
INSERT INTO mcfNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","nëshaid cubu-cubuctsëcquio icnuc nuëcquid bedshun acte cuëman tabadquin nuëcquid nibedquid. Nuacquid sandobanquin pistsëcquid acte nësecaquid. Aden Isadaidbon nuëcquid bedquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Adomboembidi namendambi. Nuquin Papan cuidte ushë chonoc ambi abi yacnoshon uaido mayan bëdabo namendambi. Adoac choshon nibedacbimboen matses bëdambo icquido Nuquin Papa yacno nidmequimbi ");
INSERT INTO mcfNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","icsambo icquido chian anëdënquiacno nësecaindac. Adoac natiaic shubiquiendac —quequin Esusën Nuquin Papan cuidte chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Adshumbic: —¿Ada ëmbi chuiboedtedi tantie? —caquini: —Ai, tantiembi —quepondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Adsho tantiashun Esusën chuipondashi. —Nuquin Papan chiaid chuibanquid mibi iquendac. Matsesën aton na ëndenquimbo dayun uanëdaidbëdta aton na chuca ismequin chiacbimboen mimbi naindac. Nuquin Papan chiaid ëndenquimbo dada uampidbëdtabi Nuquin Papan chiaid utsi ëmbi chuiboedquio mimbi chiendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Adanec auëshquiobi nidequi ");
INSERT INTO mcfNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","abi caninëdacno shubu dadpen icquid Nasaded caid yacno chopondash. Ambo choshombic Nuquin Papan chiaid chuibante shubun puduedshun aton matses chuipondash. Adoaquien: —¿Mitsipaden comapenen tantiabempash neba? ¿Mitsipadec comapenen tantiaquin bëdamequid yampash? ");
INSERT INTO mcfNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Nuqui isacmaidta nedic? Ma aton papa cuëte nacnenquid nepaboc. Ma aton tita Madia nepayoc. Aton utsibo nëidtedi iccosh. Nëidic Acobo. Nëidic Ose. Nëidic Simon. Nëidic Udas. Aidtedi aton utsibo iccosh. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aido nëmbo tabadosh. Aton chibichedotsen nëmbo tabadosh. ¿Comapenen tantiaquidta nedic? Ma adquidpenquio neyoc —quequin ");
INSERT INTO mcfNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Esus chieshënquin tantienquio icpondash. Adsho tantiashun Esusën nadopondash: —Nuquin Papan: “Ëmbi tantiamiacpaden chuibanta,” caidën chiac utsibon tantiaquid. Adquidën abi caniacnoshon chuibansho tantienquio icquid —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Adshun nadatiambo icquin nabanquin daëdpactsëc ismetsëccondash: —“Nuquin Papan chomiaidquio nec,” quetiapimbo iquec —queshun. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Adnubien ancaquidën Edodes caidën Esusën comapenen tantiaquin nabanaid chuisho tantiapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Adshumbic aton yuabo chuipac caondash. —Uan pado acten mentoandened nepash icnui. Ëmbi mapi butemiondaidi uincuempash icnui. Adquid icquin comapenen tantiaquin nabampash icnui —quepac caondash Edodes. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Edodesën Uan cuesuniac caondaid chuinu. Tantia. Uanën: —Mimbi bedaid Edodias caid min chidopenquio nec. Min utsi Uedipe caidën chido bedshun Nuquin Papan chiaid mimbi niaquec —cadoniaquien Edodesën chieshtoshon uidën uameshun Uan quënën nauedmepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Adshumbic Uan cuesunetiadquio icquimbi aton matses: —Nuquin Papan chiaid chuibanquidquio nec —quesho tantiashun aido dacuëdënquin Uan badedi cuesunenquio icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Adshumbic Edodesën: —Ëbi tishaid ushë nec —queshun matses dadpen aton shubun puduedmeshun pemepac caondash. Adnubien ambi inaidën champin Edodesën pemiaido baidaquin ismepac caondash. Adsho isumbic Edodesën: —Bëdamboenshë mimbi naic —queshun ");
INSERT INTO mcfNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","naden chuipac caondash. —Tantia, champi. ¿Atotsi buneque? Mibi bunaidquio mibi menenu. “Nuquin Papan cuidnushe,” quiash muatiapimbo iquebique. En ëbi chui —capac caondash Edodesën. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Adoaquien champin aton tita chuitampac caondash. Chuitanec choshon anin chiaid chuituidpac caondash. —Uan acten mentoanquidën mapi butetanquin pada-padaid dapan ananshun baded ëbi mene —capac caondash champin Edodes chuiquin. Uanën —Min bënë nianshun utsi bedmec mibi icsaic —cac champin tita Uan cuesunemete bumpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Adoaquien Edodesën: —¿Atotsi quepequini ado? ¿Adoenquio ictiadtsimbi icpoba? —quequin ambi chuiboed niactiadquio icpac caondash. —Ëbi isedquidon: “Mibi muambo nec,” canushe —quetanquin champin chiacpadomboen aton yuabo: —Uan mapi butetan —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Adoac quënën tsadacnobi Uan mapi buteshun ");
INSERT INTO mcfNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mapi pada-padaid ananshun buanshun champi menepac caondash yuabon. Adoaquien champin ani menenun buampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Adnubien Uanbëd ictenedon Uan mapi butiacsho dada bedanquin buanshun chococatampac caondash. Adotanec Esus chiec nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nidshumbic: —Mibi acten mentondaid mapi butiaccosh —catuidpondash. Adsho tantianec cano antabëdtoshon chian potiash pudundoanec matses nibëdacnombo Esus nidanepondash. Aden chian potesho isash: —Nuquitsen nidnu. Nid —quianec matses dadpen chian dëquiadec podqued nidquidën nidanepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Adnubien Esus matses nibëdacno istanec chian yacno choapondash. Choashun isquien abi cainec matses dadpen tabadec. Adsho isun aido tantiaquidquio icquin daicsaidotedi bëdamebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ushë budambi Esusbëd icquidon: —Inchësheque. Pete nibëdacno nuqui tabadeque. Nidaneme, Icbo. Shubu dadpen icquid utsi-utsiec yacno nidshun ma piucquid menequin ma pete bednu —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Esusën: —Padi. Ma tabadnu. Mimbibi peme —capondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Adoaquini: —Ma panëmpi 5tedpactsëc icpayoc. Nuëcquidëmpi daëdquiobi ictsec —quepondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Adsho: —Aidtedtsëqui beccho —cac meniondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Adoaquien Esusën abi datsidadquido chuiquin: —Uasinën tabadbud —capondash. Adoac tabadbudnubi abuc isquin Nuquin Papa chuipondash. —Mimbi uaid pete bëdambo iquec, Papa —quetanquin panëmpi cuësh-cuëshun abëd icquido menebanac aidontsen matses abitedi menebampondash. Adembidi nuëcquidëmpi bushtebantsëcshun menebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Adoaquien nua cubudcuededquin pebededpondash abitedishumbi. Piacsho isun napi uaid bedtanequin tsitsan dapan sandotanquin isquien tsitsan dapa 12tedi cubu-cubuctsëcquio iquec pete cuësh-cuëshaid napi uaid. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aden matses dadpenquio pemebampondash. Aido dadatedi tambanac 5000tedi icpondash. Aton chido aton bacuëbobëdta tambanambo iccondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Adshumbic Esusën abëd icquido chuiquin: —Chian potec nidta —capondash. Adoac cano antabëdtoanec potec nidnubi Esusën abi datsidadquidotsen: —Nidanec nid —cac nidanepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Adec nidanebon Nuquin Papa chuinuec macuësh dectatoash abentsëqui Esus inchëshpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Adnubien chian dapa potequi abëd icquidotsen inchëshpondash. Chian nënantanquio yanubi cunquetuidpondash. Adnuc acte comapenec tëccuasquiampondash uncadenquio yec. Comapenec acte ishcudnuc cano mentoadtiadpambo icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Adnubien badiadte anoentsëqui acte bëntse Esus chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Acte bëntse chosho isashini: —Podobitsi nec —quiash dacuëdtanec sidquecuededpondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Adshobini Esusën: —Ëbien neque. Dacuëdenda —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Adoaquien Petedon: —¿Con Icbombobida ne? Con Icbo icquin: “Acte bëntse cho,” ëbi ca —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Adsho tantiashun Esusën: —En cho —caquien Petedo canonoësh budanec acte bëntse Esus bëquedbanec niduidtsëccondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Esusuidi isec bëdamboec niduidtsequi acte comapenec tëccuasquesho isash dacuëdtanec acte bëntse niduidtsëcboedi mentoadtsempondash. —Ëbi bed, Icbo. Mentoadebique —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Esusën badedquio bedtanquin indopondash. Aden indoequi: —“Con icbon ëbi bëdamboen nametsiash,” queboedi ¿atotsi quiash dacuëdtano? Ëbi bëdiactsëc tantiatsëcquid mibi nec —quepondash Esus Petedo caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Adtanec Petedobëdi cano antsadtonobien cunqueboedi cunquenquio yampondash. Actetsen tëccuasquenquio yanondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Adsho isun cano antabëdquidon: —Mibi bëdamboshë iquec. Comapenen tantiaquidquio yec Nuquin Papan Madombo mibi nec —quequin Esus tantiabededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Adashic chian potiash Quenesaded yacno pudundopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pudundosho isun anocquidon: —Esus chosh —quequin uanocquido abitedi chuibeniac daicsaido abitedi bë-bëpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bë-bëshumbic: —Dashcuteuidtsëqui mishashi bëdantsiash —queshun Esus chuituidquin: —Min dashcute cuëmano daicsaido mishme —cac mishmiaqui bëdampondash abitedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Adnubien padiseyobo Moisesën dada uampid chuibanquidobëdi shubu dadpen icquid Edusaden caid yacnuësh cho-choquin Esus istuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Istuidashic: —¿Atotsieshun mibëd icquidon nuquin tsusedpabon chiaid niac-niacposh? Penush mëpamëdenquio icquin nuquin tsusedpabon chiaid ma niac-niacpaboc —quepondash Esus chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Adsho tantiashun Esusën: —Ma mimbi. ¿Atotsieshun Nuquin Papan chiaidquio niac-niaque? Nuquin tsusedpabon chiacpadomboen naquin ma mimbi Nuquin Papan chiaidquio niac-niacpayoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tantia. Mibi chuinu. “Titabëdta papa chieshënenquio icquin bëdamboen tantiata,” quequin Nuquin Papan chiampidquio ma mimbi niacpaboc. Adembidi: “ ‘Con pa unëspashun,’ quec chieshëmënquid icsho unës uaquid. Adembidi ani icsamboen chuishunsho unës uaquid,” quequin Nuquin Papan chiampid utsi mimbi niacpec. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aid niacquin nuquin tsusedpabon ambembi chiaidien mimbi chiec. “Anibëdta amë naden cudasënac bëdambo ictsiash,” mibi quepec. “ ‘Nuquin Papa menetequid nëidted con piucquid iquec. Mitsana nibëdsho menetiadquidi mibi menenquio iquembi. Nuquin Papa menetequid nec,’ quequidën ");
INSERT INTO mcfNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","cudasënac bëdambo ictsiash,” mibi quepec. Aden nuquin matsesën chiaid naquin Nuquin Papan chiaidquio ma mimbi niac-niacpayoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Nuquin Papa tantiaquidquio nebi,” quec muaquid mibi nec. Ëndenquimboshë Nuquin Papan chuimiac nuquin tsusedpa Isayas caidën mimbi icsamboen tantiate chuiquin dada uapampic naden. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Isadaidbo: ‘Nuquin Papambo tantiembi,’ quepec. Adboedëmbi ëmbi chiaid niacquin ëbi tantienquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","‘Ma Nuquin Papan ëbi bëdamboen isnu,’ queboedëmbi ëbi bëdamboen tantienquio iquec. Ëmbi chiaidquio namenquio icquin aton matsesën chiaiduidi namepec,” quequin Isayasën Nuquin Papan chiaid dada uapampic —quequin Esusën abi chieshënquido chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Adshumbic abi isec datsidadquido ompoacbimboen chuipondash. —Tantia. Mibitedi chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ana shëcuën puduedaidën matses icsaten mimbi dampec. ¿Adquidënda matses icsapec? Padenquio. Ana shëcuënuësh choaidëmbien matses icsatsiash —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Adnubien abëd icquidon: —Mimbi aden chuiboed tantiashun padiseyobon mibi chieshënosh, Icbo —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—Dacuëdenda. Icsa bescatanquin tsindoshon nëdëncacbimboen ambi tantiamiabi yaido ambembi chuiquido Nuquin Papan cuideque. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dacuëdenda. Padiseyobo bëshuaidbimboec icquido neque. Bëshuaidën aton matses bëshuaid utsi bëdamboen buantiapimbo iquec. Buanuec abi shëcuë ampaëdtsiash. Adembidi Nuquin Papan chiaidpenquio namequin aton matses bëdamboen tantiametiapimbo iquec —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Adshobien Petedon: —Mimbi ana shëcuënuësh choaid quequin chuiboed tantiambo iccombique. Aid sebadënquio chui. Tantianu, Icbo —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Tantiamboda icco? ");
INSERT INTO mcfNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Chuinu. Tantia. Ana shëcuën puduedaid mimbi peboed min pucun uedoash chimute shëcuënuësh choec. Adquidën Nuquin Papan chiaid niacmenquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Matses onquiaidimbi ana shëcuënuësh choaid caoc. Abibi uquëducuësh onquec: “Adoembi,” quequin otacquio tantiaquin naic matses icsatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Icsambo icquido yec: “Ai, adoembi,” quequin otacquio tantiashun Nuquin Papan chiaid niactsiash nadquidën. Nëidic unës uanquid. Nëidic aton chidopenquio chudquid. Nëidic aton bënëpenquio chudmequid. Nëidic aben uequid. Nëidic ampequid. Nëidic muaquid. Nëidic icsamboec chuishumënquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Adquidtedi: “Ai, adote bunebi” quequin otacquio tantiash icsaquid nec. Padnuen penush mëpamëdenquio icquin Nuquin Papan chiaid niaquenquio ictsiash —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Adanec auëshquiobi Esus nidpondash. Shubu dadpen icquid Tido caid anoentsëqui datambidanec choec shubu dadpen icquid utsi Sidon caid anoentsëqui chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Adnubien anocquid cananeyabo chidon Esus cuëntuidpondash. —Tsusedpa Dabidën tsyuecquid Nuquin Papan namiaid icquin ëbi bëdamboen ista. Con champi podobitsi icsa dapuduedaid yec natiambo iqueque. Con champi bëdameta —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Esusën ëcbedenquio icpondash. Ëcbedenquio yaqui chidon tsibanbanquin cuënbampondash. Adsho tantiashun Esusbëd icquidon: —Chieshanquiec cuëdpeque. Cuemepa —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Esusën cuemenquio icquimbi aid chuiquin: —Nuquin Papan chiacpaden Isadaidbo matsesba Nuquin Papa bëdamboen ismete tantiamenuec nebi. Bënudacbimboec icquin Nuquin Papa tantienquio icsho aidoba tantiamenuec nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Adsho tantiash nidenquio yec chido cuëdboed Esus ismequin danëshën sebudtsec: —Ëbi nashunta, Icbo. Con champi bëdameta —queshobien Esusën: ");
INSERT INTO mcfNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—¿Aton bacuëbo pemenquio icquimbi aton opa pemiacta bëdambo icpatsiash? Padenquio. Adembidi Nuquin Papan con matses caidotedi tantamiabi utsibo ëmbi nashunac icsambo ictsiash. Isadaidboba tantiamenuec nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Adsho tantiashun chidon: —Ai, abimbo mimbi caic. Padnuen bacuëbon pequin paëdmiaid opashëmpin petsëcquid. Adembidi mimbi comapenen tantiaquin nabanaqui isadaidbo dadpen bëdanubi isadaidpembo abentsëc tantiaquid icsho ëbi nashunquin con champi bëdameta ");
INSERT INTO mcfNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—caquien Esusën: —Ai. Ëbi tantiaquidquio mibi nec. Mimbi chiacpadec min champi bëdanendac —quesho tantianec aton shubuno nidshun isquien aton champi bëdanac Esusën chuinubi. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Adanec auëshquiobi nidec chian dapa Cadidia caid cuëman nidquid podquedën nidanepondash. Adashic macuësh dapa dectatoec poctsebi tabadtuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tabadtuidsho isun matses dadpenquio cho-choquin daicsaido dadpen Esus ismenuen bë-bëpondash. Tidinquequido yec bëshuaido yec shëquëquenquio icquido yec onquesabo yec daicsaido utsibotedi yec quenuc bë-bëpondash. Adsho Esusën bëdamebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bëdamiac onquenquio icboedi onquianondash. Bëshuacboedëmbi isbenondash. Capuenquio icboedi capucuenondash. Daicsaido utsibo adecbidi bëdanondash. Adsho isquido nadpondash. —¿Adquidta ictenec? Nuquin matses isadaidbon tantiaidën Nuquin Papan namiaid icquin bëdamepash icnui. Nuquin Papa bëdambo iquec —quepondash Esusën bëdamiaid tantiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Adec tabadsho isashien Esus: —Nëido tantiac unësquio iquec. Ëmbi nabansho isnuec choash 3tedec ushquin piac ambi bëboed pete naimëdaccosh. Ëmbi: “Nid,” cac nidnuequi bunambi padishtsiash. Pemiabi nidmetiapimbo iquebi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Adsho tantiashun abëd icquidon: —¿Midambo pete bedtiapimbo iquec? Pemetiapimbo matses dadpen iquec —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Adoaquien Esusën: —¿Tedtsi panëmpi iquec? —cac: —Sieteted ictsec. Nuëcquidëmpi daëdpactsëc ictsec —quesho ");
INSERT INTO mcfNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tantiashumbien abi datsidadquido chuiquin: —Nëmbo tabadbud —capondash. Adoac tabadbudpondash abitedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Adshumbic panëmpibëdta nuëcquidëmpi bedshun Nuquin Papa chuipondash. —Nëid mimbi uaid bëdambo iquec, Papa —queshun pete cuësh-cuëshbantsëcshun abëd icquido menebampondash: —Pemeban —quequin. Adoac abitedimbo pemebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aden pemiac abitedimbo nua cubudcuededpondash. Piacsho isun pequin napi uaid bedbanquin tsitsan 7ted icnuc cubu-cubuctsëcquio icnuc sandobampondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Esusën pemiaido dadpenquio icpondash. Tambanac 4000tedi dada icpondash. Chido bacuëbobëdta tambanambo iccondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Adashic: —Nidanec nid —quepondash Esus ambi pemeboedo caic. Aido nidanenubi chian budash cano antabëdtoshon Esusën chian potepondash. Chian potiash nidaid Mactada caid yacno pudundopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pudundoanec nidshobi anocquidon abi chieshënquidon Esus chuituidpondash. —“Nuquin Papan chomiaid nebi,” quequin comapenen tantiaquin nabanquin ëbi isme —cabededpondash padiseyobobëdtan saduseyobon. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Adshobien Esusën: —Nuquin matsesën chiaid mimbi tantiec. “Inchëshbudtsëqui abu piumbo icsho isash: ‘Tanunquio badiadec,’ quequid. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Badiadnubi abu inchëshpambo icsho isash: ‘Ue dapa choec,’ quequid,” quequin nuquin matsesën chiaid mimbi tantiec. Aden chiaid tantiacbimboen bëdamboen tantiatiadquidi Nuquin Papan nëbimbobi naid mimbi tantienquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Icsambo icquid icquimbi mimbi: “Ëbi isme,” cadednepec. Nëbi mibi ismenquio iquembi. Nuquin Papan nuquin tsusedpa Onas chishcambiecquid dapan chebudacsho daëdec ushun ucbudmiacbimboec unës uacsho chococac daëdec ushash uincuenendabi. Aden ëbi tantiesabo ismendambi —quianec nidpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Adanec nidec chian budash cano antabëdtoshon chian poteoapondash. Chian potequien Esusbëd icquido: —Pete nianchitombi. Bëtiadquidi nepobi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Adshobien Esusën abëd icquido chuiquin: —Padiseyobëdtan saduseyobon naid pan bidiscametebimboecquid iqueque. Ista —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tantienquio yec abëd icquido nadec onquecuededpondash. —Nuqui niamboed pete chiequi nepanui —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Adsho ambembi tantiash Esus: —Ëbi bëdiactsëc tantiatsëcquid mibi nec. ¿Mimbi pete niamboed chiectabi nedi? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Bëshunashta mibi nepe? Pete 5tedtsëcboedi ëmbi 5000tedi pemiaidën napi uaid dadpen iccondaid ¿tantienquioda yano? ");
INSERT INTO mcfNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Adembidi pete 7tedi ictsëcboedi ëmbi 4000tedi pemiaidën napi uaid dadpen tsitsanën sandoboed tantienquioda yano? ");
INSERT INTO mcfNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Aden comapenen tantiaquid icquimbidambi pete niamboed chuipadi? Padenquio. Pan bidiscamete pictsëc cabiunac pan abichobi nua bidisquiacbimboecquid padiseyobobëdtan saduseyobon chiaid iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aden chuisho tantiash abëd icquido nadpondash. —Pan chienquio icquimbi nuquin matses tsusiobon chiaidshenda capec. Aido caic: “Icsamenda,” quepecshenda niosh. “Padiseyobon chiaidbëdta saduseyobon chiaid tantienda,” quepecshenda niosh —quepondash Esusbëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Adash yuectaniash puduanec nidequien Esus nidaid utsi Sesadeya Uedipo caidën nidanepondash. Adshumbic abëd icquido chuimepondash. —Utsibon ¿tsutsi ëbi caosh? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—“Uan pado acten mentoanondaidien nec,” mibi caosh. Utsimbic: “Edias cuëmëdquid Nuquin Papan ambi tantiaid oncamiampid nepanui,” mibi caosh. Utsimbic: “Edemias cuëmëdquid Nuquin Papan oncamepampid nepanui,” mibi caosh. Utsimbic: “Nuquin Papan oncamiampid utsi nepanui,” mibi caosh —capondash abëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Adsho tantiashun Esusën: —Ma mimbibi. ¿tsutsi ëbi mimbi cao? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Petedo Simon caidën: —“Quidistu caid Nuquin Papan chomiaidquio nec,” caombi mibi. Aton Madombo mibi nec —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Adsho tantiashun Esusën: —Nuquin Papan aden tantiamiac mimbi bëdamboen chioc, Petedo. Onasën mado Simon caid yec matsesien mibi nec. Adquid icquimbi matsesën tantiaid chienquio icquin Nuquin Papan tantiamiaidquio mimbi abimbo chioc. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tantia. Ëmbitsen mibi chuinu. “Cuënotebimboecquid nec,” quequin mibi Petedo cuënondambi. “Cuënote dapa utsi ictiapimbo yacbimboec chieshtoenquio icquid iquendac,” queshun mibia ëbi tantiaquido chuiquid dapambo icmendambi. Adec mimbi namiaido ëbi tantiaquido iquendac. Satanasën aido: “Nëid yuanu. Utsibic chieshtomenu. Utsibic unës uamenu,” caqui abi ëbi tantiaquido iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Padnuc Nuquin Papan chiacpadomboen ëbi tantiaquidon nate mimbi chiendac. Adembidi ëbi tantiaquidon natemaidtsen mimbi chiendac —quepondash Esus Petedo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Adashic abëd icquido abitedi chuioaic: —“Nuquin Papan chomiaidquio nec,” quequin utsibo ëbi chienda —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Adshumbic tauaquin abi unës uate chuidondash. —Shubu dadpen icquid Edusaden caid yacno nidendabi. Anoshon nuquin matsesën ëbi chieshënquiendac nëidtedshun. Nëidic tsusiobon. Nëidic nëish yua abided unës uaquido chuiquid dapabon. Nëidic Moisesën dada uampid chuibanquidon. Aidtedishun mëyanquioquin ëbi unës uamendac. Adoacsho chococac daëdec ushash uincuenendabi —quequin chuisho ");
INSERT INTO mcfNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tantiashun Petedon uanotantsëcquin tsadumbudshun Esus chuipondash. —Unësquio icnuc mimbi chieque. Aden chienda. Ma mibi unës uatiapimbo icpayoc —capondash Petedon. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Adoaquien Esusën: —Satanasën oncamiac Petedo adec onquec —queshun Petedo isquin Satanas chushcapondash naden. —Cuen, Satanas. Nuquin Papan chiaid mimbi ëbi niacmetiadquio iqueque. Cuen —quetanec Petedobi chiec: —Matsesën tantiaid chuiquimbi Nuquin Papan tantiaidquio mimbi chienquio iccoc —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Adashic abëd icquidotedi chuioaic: —Ëbi tantiaquidon aton nauidi nainquio icquin ëmbi chiacpadomboen natsiash. Adsho chieshëmënquidon: “Unës uachitomane,” cac chieshtoenquio icquin ëbi tantiatsiash. Adquid ëbi tantiaquidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Padnuen ëbi tantiatsëcquid: “Esus tantiasho unës uachitoshe,” quiash ëbi tantienquio yanec unësash Nuquin Papan cuidaidobëd nidendac. Padnuen chieshtoenquio icquin ëbi tantiaquid Nuquin Papa yacno tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Nuquin Papa tantienquio yec tabadecta matses bëdambo icpatsiash? Abi bunaidtedi bedquin Nuquin Papa tantienquio yec unësash ¿mitsimbo tabadpatsiash? Nuquin Papabëd tabadte bunquin ¿atotsi menepatsiash? ¿Piucquid meniashta Nuquin Papa yacno tabadpatsiash? Padenquio. Adotiapimbo iquec. ¿Atoda meniantiapimbo iquec? ");
INSERT INTO mcfNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ëmbien matses cuidte chiendac. Nuquin Papa yacnuësh ambi abi yacnoshon uaido mayan bëdabobëd cho-choshon Nuquin Papan abitedishun icbo icmiaid icquin matses cuidte chiendambi. Nuquin Papa tantiec bëdamboec tabadquid Nuquin Papabëd tabadmequin Nuquin Papa tantienquio yec icsaquido icsano nidmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tantia. Chuinu. Utsi-utsiec unësabi icquin ëbi tantiaquido dadpen yansho mimbi isendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aden chiash 6tedec ushanec nidquimbi Esusën abëd icquido 3tedtsëqui buampondash. Petedo yec Acobo yec Acobon buchi Uan yec quetsëcnuc buanash macuësh dapa dectatoash mananënquio tabadtuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tabadtuidshun isquien Esus utsiacbimboec isadpec. Aton dashcutebëdi aton bëtantete ushëbimboec bëchamauanquiec yanac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Esus bëchamauanquiec icnubien dada utsi daëd isadcuenash Esusbëd onquiampac caondash. Abentsëc Moises yampid icnubi utsi Edias Nuquin Papan ambi tantiaid oncamiampid icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Adsho isashien Petedo: —Mibi adec tabadsho isash bëdambo iquebi. Mibi nëmbobi tabadmenun abentsëc chotsecnuc shubumpi uatsëcnuna, Icbo. Mitsana natsëcquinc Moisesën na natsëcquinc Ediasën na natsëcquinc canuna. ¿Ada bëda icpec? —quenubi ");
INSERT INTO mcfNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","abu ushu bëchamauanquiec icquidën isadenquio icnuc bëtimpac caondash. Adnubien abu ushu nënantanuëshquio Nuquin Papa onquiampac caondash. —Nëid con Madombo nec. Ëmbi tantiaidquio yec ëmbi bëdamboen isaidquio neque. Nëidquio tantiata —quec dacuëdampamboec onquenubien ");
INSERT INTO mcfNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","uinte paëdtampamboec dacuëdtanec uebudcuededpac caondash Petedo chedo. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Adshobien Esusën camishquin: —Dacuëdenda. Nidto —cac ");
INSERT INTO mcfNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","nidtoquin isquien Esus abentsëqui iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Adtanec macuësh budequi Esus: —Mimbi isboed nëbi utsibo chienda. Unës uac ëbi uincuenacsho isun chianta —quepac caondash abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Adsho tantiash Petedo chedo: —“Nuquin Papan chomiaidquio nec,” quequin nëbi mibi tantiembi. Mibi adquid icnuc ¿mitsipadquid nuquin matses tsusiobon chuiposh? Nuquin Papan chiaid isash: “Nuquin Papan chomiaid choabi icnuc Edias yampidba choendac,” quepequien iccosh —queshobien ");
INSERT INTO mcfNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Esusën: —Abimbo chiosh. “Edias yampid bëyuc choshon: ‘Nuquin Papan chomiac bëdambo icquid choeque. Bëdamboec tabadta,’ quequin chiendac,” quequin abimbo chiosh. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Adquid Ediasbimboecquid chondash. Choacsho tantienquio icquin matsesën abi bunacpaden unës uapac caondash. Adembidi Nuquin Papan chomiaid icsho ëbitsen chieshënquin unës uaindac —quesho tantiashien: ");
INSERT INTO mcfNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","—“Ediasbimboecquid nec,” quequinshenda chuiposh. Uan pado acten mentoandened caquinshenda Edias capec —quepac caondash Petedo chedo. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bëchamauanquiec ictanec choequi abëd icquido utsibo yacno choquin matses dadpen aido datsidadacsho Esusën istuidpondash. Adec Esus chosho isumbien unësanetsëcquidën papan Esus ismequin danëshën sebudshun chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Con mado bëdamboen isquin bëdameta, Icbo. Baded-badedquiec unësanec cuëten pichiquianec. Adecbidi unësanec acten mentoadtsenaccosh. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mibëd icquidon bëdamete danquin bëuidombi. “Në bëdame,” cac bëdamenuen tanuidosh. Bëdamenquio iccoshe. Mimbimbo bëdameta —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Esusën ambo icquidotedi chuipondash. —Ëmbi nadatiambo icquin nabanquin ismiaqui mimbi ëbi tantienquio iquec. Adsho isash chieshtoash cuentiadquio icchitebi. Adtiadquio yequi padenquio iquec nebique. Min mado beccho —cac ");
INSERT INTO mcfNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","bësho istanquin Esusën podobitsi icsa chushcapondash. —Padi. Daicsa uainda —cac podobitsi icsa cuenubi madompi bëdampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Adsho isun abëd icquidon Esus chuipondash utsibo tantiamenquio icquin. —Ëmbi: “Cuemenu,” cac ¿atotsi quiash podobitsi icsa cuenenquio icposh? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Nuquin Papa bëdamboen tantiaquin mimbi bëdamboen natsenoc. Mimbi bëdiactsëc tantiatsec. Pete ëshëmpi mostasa caid pistsëcquidi siac nua yec canitsiash. Adecbidi Nuquin Papa tantiatsëcboedi: “Ambi natiapimbo ictequid nibëdec,” quequin abimbo tantiaquidquio yanshun comapenen tantiaquidbimboec mibi ictsiac. Adquidën nëid macuëshquiobi cain: “Uquë manëd,” cac manëdtsiash. Aden mimbi: “Ëbi bëdamboen nameta, Papa,” quequin Nuquin Papa chianiac aidëmbi mimbi: “Ëmbi natiapimbo ictequid nec,” caid mibi bëdamboen nametsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nëbi ëmbi cuemeboed abembi cuentiapimbo icquid nec. Nuquin Papauidi tantianuen buna mëmunquin Nuquin Papa chianeshun adquid cuemequid —quequin Esusën chuipondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Adanec aton nidaid Cadidia yacnobi capucuenequimbi Esusën abëd icquido chuipondash. —Ëbëd icquid abentsëcshun ëbi chieshënquido ëbi bedmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bedshun ëbi unës uamendac. Aden unës uamiacsho chococaquini daëdec ushash uincuenendac —quesho tantiatanequien abëd icquido: —Unësquio icnuc chiec —quiash shubiantiadtsëcquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aden chianec nidequi shubu dadpen icquid Capednaun caid yacno Esus chopondash. Adnubien Nuquin Papa tabadte shubu uashunaid nacnemenuequin piucquid bedquidon Petedo chuituidpac caondash. —Nuquin Papa tabadte shubu uashunaid nacnemenuen ¿ada min icbon dos dada uatsaid piucquid shocoshëmpi abentsëc menepatsiash? —cac ");
INSERT INTO mcfNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petedo: —Ai, menetsiash —quepac caondash. Adanec nidec shubun puduedshobien Esusën ambia Petedo chuipondash. —¿Atotsi mimbi chie, Simon? Aton matsesën na nacnemenuen ¿tsutsi chuiquid dapabon piucquid bedshumpec? ¿Ada aton matses piucquid bedshumpec? Aido bedshunenquio icquin ¿ada ambi bedaido aton yuabo piucquid bedshumpec? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petedo: —Ma aton yuabo bedshumpaid yoc. Aton matses piucquid bedshunenquio iquec —quesho tantiashien: —Adembidi aton Mado icsho aton shubu nacnemenuen Nuquin Papan ëbi bedshuntiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aden tantiaquimbi: “Nëishnushe,” queshun menenun nanuna. Chianën ansemetan. Tauaquin ansemiaidi ancanshun anisquin 4 dada uatsaid piucquid shocoshëmpi abentsëc mimbi istuidendac. Aid bedshun piucquid bedshumënquido menetanta. “Në con icbon nabëdi con na nec,” quequin menetanta —capondash Esusën. Adoac Petedon Esusën chiacpadomboen menetampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Adshumbic abëd icquidon Esus chuipondash. —Abitedishun Icbo icquin matses mimbi namendac. Ëbi chedo caic ¿mitsicquid mibëdtan chuiquid dapa mimbi icmepatsia? —quesho ");
INSERT INTO mcfNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tantiashun abi tabadacno nënantanquio bacuë tsaduntsëcshun Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Tantia. Mibi chuinu. Mitsanauidi tantiec Nuquin Papan namiaid mibi ictiapimbo iquec. Mitsanauidi tantiaboedi nadquid bacuën amën chiacpadomboen nacbimboen ëbi tantiaquiota. Adash ambi namiaid yanash Nuquin Papa yacno mibi puduedendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aden ëmbi chiacpadomboen naquidquio icsho mibi Nuquin Papan: “Bëdamboshë iquec,” caindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nadquid bacuëbëdta ëbi tantiabentsëcquid bëdamboen tantiaquidën ëbitsen bëdamboen tantiendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Adshumbic padpiden chiec: —Ëbi tantiabentsëcquid caic: “Nuquibi Nuquin Papan chiaid niac-niacquiec icsaquionona,” quequid Nuquin Papan cuidendac. Icsamiabi yec unësacsho isun: “Bëdambo iquec,” catsiambi. “Cuënote yuëmboshë icquid tëdectanshun acte nënepatecnëdan,” caimbi icsamiante bunquidquio. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aden ëbi tantiatsëcquid utsibon icsamendac. Adec icsamianquid Nuquin Papan cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aden Nuquin Papan cuidte chuisho tantiequi icsainda. Mëdanten naic mibi icsaic. Mëteshuniac bedtiapimbo yacbimboec icsainquio yec ënëdta. Taën capuec mibi icsaic. Tateshuniac caputiapimbo yacbimboec icsainquio yec ënëdta. Ënëdenquio icsho Nuquin Papan mibi cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Adecbidi ëshën isec mibi icsate bunquiec. Ëshë chicshuniacbimboec icsainquio yec ënëdacsho: “Bëdambo iquec,” catsiambi. Ënëdenquio icsho Nuquin Papan chian anëdënquiacno nësecaindac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Adashic padpidec: —Nadquid bacuëmpin ëbi tantiatsëcsho isun: “¿Adtsëcquidëmpinquiobida bëdamboen tantiapec?” cainda. Nuquin Papan abi yacnoshon uaid mayan bëda aid bacuëbo dayun uaquid icquin Nuquin Papa yacno puduedshun mimbi mamënshumboed Nuquin Papa chuinushe. Adtsëcquidëmpi mamënshunenda. Ëbi tantiabentsëcquido con Pan tantiaquieque. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ëmbitsen aido tantiembi. “Bënudaid istuidacbimboen ëbi tantienquio icquidobi ëbi tantiaquido icmenu,” quiash matsesondabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Adashic padpidec: —¿Mitsipadquio nuquin matses icpec? Nëish yua obeca dadpen 100ted dayun uaquidën aton yua tambanac abentsëc nibëdsho istanquin utsitedi nianshun aid abentsëc nibënbenequin istuidquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aden istuidash comapenec cuishonquequid: “Con yua nibëdantsenquiac,” quiash. Aton yua utsi yacno bëash abi icboctedi icsho isash bëdambo icquid. Adecbidi matsesën ëbi tantiabensho isash Nuquin Papabëd cuishonquebi bënudaid istuidacbimboec. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Icsaido cuidacno matses nidmete Nuquin Papa bunenquio iquec. Matses bëdamboen isquin abëd tabadmete Nuquin Papa bunquiec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Adashic padpidec: —¿Ada ëbi tantiaquid utsin mibi icsa uaosh? “Ai, icsa uaoshi. Chieshëmiantiadquio icchitosh,” queshun nadoac bëdambo ictsiash. Aid abentsëqui chuiquin aidbëd bëdamboec onquequin: “Ëbi icsa uaquin Nuquin Papan chiaid mimbi niac-niaccoc. Adec icsainquio yec ënëdta,” mimbi cac: “Ai, adebi,” quiash mibëdi bëdamboec tabadtsiash Nuquin Papa tantiesabimboec icuidboedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mimbi: “Icsainquio yec ënëdta,” caqui: “Padi. Adequi icsaibi,” quesho tantiashun ëbi tantiaquid utsi beduanshun aidbëdtan chuitanta. “Nuquin Papan chiaid niac-niacsho isun daëdshun chiaid abimbo chiaid nec,” quequin chiaid tantiaquin adota. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mimbi buanaidëntsen: “Adec icsainda,” caqui: “Adequi icsaibi,” quesho tantiatanec choashun mibëdtan ëbi tantiec iccuededquido chuiquido chuituidta. “Mimbitsen chuitanta,” cac aidontsen chiaqui tantienquio icsho isun: “Nuquin Papan chiaid niac-niacquid yec Esus tantiesabimboecquid nec,” queshun ëbi tantiaquido cuëdënacno chomenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Aden mimbi: “Esus tantiesabimboecquid neque. Cuëdënacno chomenquio ictiad,” casho Nuquin Papan: “Bëdamboen naic,” mibi catsiash. Adembidi mimbi: “Adec icsaboedi icsainquio yec ënëdsho isun cuëdënacno chomeoanuna,” queshun chomeoasho Nuquin Papan: “Bëdamboen naic,” catsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Padpiden chuinu. Tantia. Mimbi: “Nuquin Papa chuinuna,” cac: “Ai, adonona,” quesho tantiashun aidbëdtan mimbi Nuquin Papa chianiac mimbi chiacpadomboen Nuquin Papan natsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ëbi tantiec daëd tabadnuc aidbëd con Mayan yec ëbëd yacbimboec tantiadendac. Adec tabadsho isun: “Con Mado tantiaquido nec,” queshun aidon chianiaid Nuquin Papan tantiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Adec: —Icsa uanec chieshtomiantiadquio iquec —Esus quesho tantiashumbien Petedon Esus chuipondash. —¿Icsa uanec chieshtomianquid tedentsimbi chieshenquio icquin bëdamboen ispe? Chieshënquin padpiden icsa uac ¿padpidendambi bëdamboen isoape? ¿Mëdante utsiuc daëd tauadoquin sietetedembi nashun padpiden bëdamboen isenquio icquin ënacta bëdambo icpatsiash? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Esusën: —“Mëdante utsiuc daëd tauadoec sietetedi” quequin daëdpactsëcquio mimbi chuipec. 70 por 7 caid ¿tedtsi icpec? Aidteden 490tedembi ënenquio icquin bëdamboen isoadoniac bëdambo ictsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Adashic abi onquec: —Nuquin Papan chiacpadomboen matses bëdamboen iste mibi chuinu. Tantia. Tsusion yuabo dadpen icpac caondash. “Ma bënu,” quequin ambi meniactedi piucquid bednuen aton yuabo aton shubuno chomepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Abia chomiaidën piucquid dadpenquioshë bedshun aton icbo meniambo icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Adsho icbon: “Mimbi bedactedi beccho,” cac: “Nibëdec,” quepac caondash yua. Adshobien icbon: “Aidtedi piucquid bednuen matses utsibo mibi yuamenu. Min chido min bacuëbobëdtabi cuësh-cuëshëdmeshun aidtedi piucquid bednu. Mibi icsambo iqueque,” cac ");
INSERT INTO mcfNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","yua abi yuaquid ismequin danëshën sebudash: “Padi. Ëbi yuamenuen cuësh-cuëshëdmenda. Chiata. Yuecshun aidtedi bedshun mibi menenun nanu,” capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Adoaquien icbon bëdamboen isquin: “Padi. Ëbi menenda. Mibi utsibo yuamenquio iquembique. Dacuëdenda. Nidec nid,” quequin icbon aton yua bëdamboen nidmepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Adoac nidquimbien aid yuan icbon bëdamboen isboedën ambi: “Ma bënu,” quequin piucquid daëdpactsëc meniaid yua utsi istuidpac caondash. Istuidshumbic bedtanquin tëtëdinquin: “Mimbi bedactedi piucquid beccho. Unës uachitomane,” caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","aidtsen ambi piucquid bedshunondaid ismenuen danëshën sebudtsec: “Chiata. Ëbi unës uainda. Yuecshun bedshun mibi menenun nanu. Chiata,” quepac caondash yua utsi. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Adsho tantiashun icbon bëdamboen isboedëmbi chieshënquin: “Padi. Mibi cuidmembi,” queshun quënën nauedmepac caondash. “Piucquid aidted abi menianenquio yacpadequi ma quënënuësh mëyadbudchitono,” queshun nauedmiac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aden chieshënquin quënën nauedmiacsho isumbien yua utsibon: “Chieshanquiec,” queshun icbo chuituidpac caondash. “Mimbi bëdamboen isboedëmbi min yua utsi quënën nauedmiac: ‘Piucquid menianenquio iquec,’ queshun,” quequin icbo chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Adsho tantiashun icbon ambi cuidenquio icquin bëdamboen isboed chomeshun chushcapac caondash. “Icsambo icquidquio mibi nec. ‘Chiata. Mibi menenun nanu,’ mibi quesho: ‘Padi. Ëbi menenda,’ quequin mibi bëdamboen isombi. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ëmbi mibi adobocpadomboen utsi bëdamboen istiapimboda icco? ‘Ma bënu,’ queshun mimbi meniactedi bëabi icsho bëdamboen isec mibitsen bëdambo ictsenac. Mibi yacpadec nëishun mibi cuidembi,” quepac caondash icbo. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Adshun quënën nauedmepac caondash. “Ambi bedactedi piucquid dadpenquio meniash ma puduempanu,” queshun quënën nauedmiac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aden matses yuan icbon nacpadomboen Nuquin Papan naindac. Utsibon chieshënaqui chieshënansho Nuquin Papan mibi bëdamboen istiapimbo iqueque. Chieshënanenda. Mibi chieshënquidobi bëdamboen ista —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Adanec nidaid cuëshë Cadidia caid yacnuësh puduanec nidec nidaid cuëshë utsi Udeya caidën nidquin acte Odan caid potebidanec Esus nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Adec nidshobien matses dadpenshun tsibanampondash. Abi tsibanansho isun nidtuidshun daicsaidtedi Esusën bëdamepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Adnubien tsusedpabon chiampid namequido padiseyobon chieshënquin: —Nuquin Papan chiaid niacmenu —quequin Esus chuituidpondash. —¿Atotsi mimbi chuipe? Dada uashun aton chidobi nidmete ¿mitsipaden mimbi chuipe? En chui. Tantianu —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Adoaquien Esus: —¿Nuquin Papan chiaid isamboda ictio? “Nuquin Papan dadaba uashun aton chido uapampic,” quequin dada uaid ma mimbi ispaboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Adembidi: “Dadan canite chido uaid icsho dadan aton chido bedquid. Amë chedobëd icboedi aton chido bedash aid nianenquio yec aidbëd tantiananquiec dada aton chidobëd abentsëc yacbimboec tabadquid,” quequin dada uaid ma mimbi ispaboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aden Nuquin Papan tantiacpadomboen aton chido nianenquio yec aidbëdi tantiananquiec abentsëc yacbimboec tabadac bëdambo ictsiash. Padnuen aton chido nianec aidbëdi cuëshëdquin Nuquin Papan chiaid niactsiash. Adecbidi chido aton bënë nianec icsaquid —Esus quesho ");
INSERT INTO mcfNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tantiashumbien abi chieshënquidon: —¿Abimboda mimbi capadi? Nuquin Papan chiaid dada uaquin ¿atotsieshun Moisesën naden chuipampic? “Aton chido bunenquio yanshun dadan naden dada uashun menequid. ‘Mibi intiapimbo yanobi,’ quequin dada uashun aton chidobi menequin nidmequid,” quequin Moisesën dada uapampid ma icpayoc —quequin chuipondash Esus chieshënquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Adsho tantiashun Esusën chuipondash. —Ai, Nuquin Papan chiacpadec aton chidobëd bëdamboec tabadtiapimbo icsho isun Nuquin Papan Moises aden dada uamepampic. Tauamboen matses uaquin Nuquin Papan aden chiambo icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tantia. Mibi chuinu. Aton chidobëd cuëshëdshun chido utsi bedquin Nuquin Papan chiaid niactsiash. Padnuen aton chidon bënëpenquio chudmesho istuidash aidbëd cuëshëdquin Nuquin Papan chiaid niaquenquio ictsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Adnubien abëd icquidon: —Adotiapimbo icte mimbi chuipec. Aton chidobëd cuëshëdenquio icte mimbi chuisho tantiashun: “Aton chido bedesambo dada bëdambo ictsiash,” caimbi —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Adsho tantiash Esus: —Ai, utsi-utsiec pabiate shëcuë nibëdacbimboen ëmbi chiaid tantiatiapimbo iquec. Utsiboen aton chido bedash Nuquin Papan chiacpadec bëdamboec tabadquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Utsibic mimbi chiacpadquid chido bedesa iquec. Nëidtedi chido bedesa iquec. Nëidic aton padibi impadishtsaid. Nëidic matsesën inicsa uaid. Nëidic: “Nuquin Papan yuambo icquin aidën chiacpadomboenuidi naquin chido bedtiapimbo iquebi,” queshun chido bedesa. Adquidtedi chido bedesa nec. Ëmbi chuiboed tantiashun ëmbi chiacpadomboen nac bëdambo ictsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Adnubien Esus ismenuen bacuëbo bë-bëpondash. —Mamishquin ma Nuquin Papa Esusën chuinu —quequin bë-bësho isumbimbi: —Padi. Bëenda —cauidpondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Adshobini Esusën: —Chën. Ma bënu. Cuemenda. Bacuëbimboecquid Nuquin Papa yacno puduedtequid nec. Amën chuisho tantiash bacuë badedi: “Abimbo caic,” quiacbimboen ëbi tantiaquid Nuquin Papa yacno puduedtequid nec. Bacuëbo bëdambo iqueque. Beccho —cac bë-bëpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Adshobien mamishbanquin Nuquin Papa chuipondash. Adobidanec nidondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Adnubien dada caniampinquio Esus chuituidpondash. —Mibi bëdambo iquec. Bëdamboen chuiquidquio mibi neque. Ëbi chui. Padpidec unëstiapimbo icquid icmenun bëdambo icquid Nuquin Papan abi yacno puduedmetsiash. ¿Atotsi nasho Nuquin Papan ëbi bëdambo capatsiash? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Esusën: —¿Mitsipadquid bëdambo icquid cai? Nuquin Papauidtsëqui bëdambo icquid nec. Aidbëd tabadnuen ambi Moises dada uamiampictedi nata —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Adoaquien cania: —Nuquin Papan chiaid ¿mitsipadquid cai? —quesho tantiashumbien: —Naden chiaid caimbi. “Cuesunenda. Min chidopenquio chudenda. Min bënëpenquio chudmenda. Ampenda. Muainda. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Titabëdta papa chieshënenquio icquin bëdamboen tantiata. Adembidi mibibi datantiadacbimboen matses utsi abitedi tantiaquiota,” quequin chiaid caimbi —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Adsho tantiash cania: —Aidtedi niaquenquio icquin nabanquidquio nebi. Bacuëctsëc icquimbi tauaondambi. “Nuquin Papabëd tabadnuen ¿atotsimbi utsi nape?” caimbi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Adsho tantiashumbien Esusën: —Nuquin Papan chiaid niaquesambo ictiadquio icquin mimbi dayun uaidtedi uesquin menequin piucquid bedta. Piucquid bedshun piucquid nibëdquido min piucquid uesquin menebanta. Adsho abëd tabadmenun Nuquin Papan mibi bëdamboen istsiashe. Adota. Adotanequic ëbëd iquec cho —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","cania: —Con na dadpenquio icsho uesquin menetiapimbo iquebi —quiash shubiantiadtsëcquio ictanec nidpondash Esusën chiacpadomboen natiapimbo yec. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Adsho isun Esusën abëd icquido chuipondash. —Chuinu. Tantia. Aton na dadpen dayun uaquid aton na tantiequi: “Nuquin Papa yacno tabadte bunebi,” queboedëmbi ëbi tantiatiapimbo iquec. Aton nauidtsëqui tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","¿Ada nëishamën pinchuc chicte ancumpadic? Padenquio. Adecbidi aton na dadpenquio dayun uaquidën aton nauidtsëqui tantiaquin ëmbi chiacpadomboen natiapimbo yec Nuquin Papa yacno tabadtiapimbo iquendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Adec: —¿Ada nëishamën pinchuc chicte ancumpadic? —quesho tantiashien abëd icquido nadpondash. —¿Tsudain Nuquin Papa yacno puduedtequid icchitotsiash? Nibëdchitequien iquec —quesho tantiashumbien ");
INSERT INTO mcfNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Esusën abëd icquido bëisquin naden chuipondash. —Matses namiantiapimbo icnuc Nuquin Papain namianquidquio nec. Ambi natiapimbo ictequid nibëdec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Adsho tantiashun Petedon: —Mimbi: “Nuquibi icnu. Cho,” cac con na abitedi nianec mibëd icnuec chopondabi. ¿Mitsimbo tabadtequidini nepe? ¿Atotsimbi nape? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Esusën: —Tantia. Mibi chuinu. Nuquin Papan ambi uaid abitedi chuca uabocnoëshquio ëbëdtan chuiquid mibitedi iquendac ëmbi abitedi namiacnuëshquio. Ëbëd icquido icsho isun Nuquin Papan mibi chuiquid icmendac. Nuquin tsusedpa Acobon mado ¿tedtsi icpampic? Aidtedi 12tedshun tsyuecquidon shubu 12tedi shubun-shubunquiec chuiquid dapabo mibitedi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Utsibontsen ëbi tantiendac. Aton shubu nianquinc abëdta tishaido nianquinc aton tita nianquinc aton papa nianquinc aton bacuëbo nianquinc aton tied nianquinc cain ëbi tantiaquin ëmbi chiacpadomboen naquid iquendac. Adsho nëbi unësabi icsho ambi nianaidobëd tabadacbimboecnuc bëdambo icmendambi. Adoshombic unësacsho Nuquin Papa yacno tabadmendambi padpidec unësenquio icnuc. ");
INSERT INTO mcfNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nidaidënuësh chuiquid dapambo icboedi Nuquin Papa yacnuësh utsi-utsiec chuiquidpenquio iquendac. Utsibic nëuëshquio chuiquidpenquio icboedi Nuquin Papa yacnoshon: “Bëdambo icquid nec,” quequin chuiquid dapa icmendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Adshumbic abëd icquido Esusën ompoacbimboen chuipondash. —Tantia. Ëbi tantiaquido Nuquin Papa yacnoshon namete mibi chuinu. Badiadnubi tied icbon piucquid menequin aton tied neshcamenuen matses istuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Istuidshumbic: “Badiadnubi tauashun ushë budtsambi mimbi ënacsho nëidtedi piucquid mibi menenu. Naic cho,” cac chonoadec cho-chopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ushë abucquio yanubi tied icbon pete meniacno nidshun utsibo nainquio yec samëdsho istuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Adoshombic aidotsen chuiquin: “Con tied neshcaic cho. Mibi bëdamboen cuidquin menenu,” cac ");
INSERT INTO mcfNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","tied neshcaic nidpac caondash. Ushë cuembo icnubi tied icbon padpidec pete meniacno nidoashun utsitsen istuidshun adembidi aton tied neshcamepac caondash. Ushë budambic padpiden utsitsen. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Inchëshbudtsëqui nidoaquin utsibo nainquio yec samëdsho istuidoashun: “¿Atotsi quiash samëduidequi ique?” cac ");
INSERT INTO mcfNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","samëdquido: “Chonoa uanquid nibëdosh,” quesho tantiashun tied icbon: “Mimbitsen con tied neshcaic cho. Mibi menenu,” cac tied neshcaic nidaneoapac caondash inchëshbudtsëqui neshcaquin tauaic. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Inchështsëcnubi tied icbon ambi chonoa uaido isquid chuipac caondash. “Chonoadquido piucquid meneban. Tsyuec choboedba menequin tauatanquin ushë budambi choboedotsen meneta. Adoshombic ushë cuembo icnuc choboedotsen. Adoshombic ushë abuctoan choboedotsen. Adoshombic badiadnubi abia choboedo ënquimbi meneta,” cac menequin tauapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Inchëshbudtsëqui chonoadec choboedoba menequin badiadnuc chonoadec taëboed tied icbon: “Menenu,” cactedquio piucquid menepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Adosho isashien badiadnubi choboedo: “Aido aden meneshun nuqui chonoadquioboed yuapambo nuqui menec,” queshobi aidtedtsëcbidi piucquid menepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aidtedtsëcbidi meniaquien tied icbo chushcapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Tsyuec chonoadboed meniactedtsëcbidi menioshi. Icsambo iquec. Inchëshbudtsëqui chotsash daëdpactsëc chonoadtsëcquid meniactedtsëc yuec chonoadquid piucquid meniac icsambo iquec. Chun mëyadec yuecquio chonoadobi. Aidtedtsëc menianec mibi chieshanquiec iquec. Ëbi dadpen meniac bëdambo ictsiash,” quequin chushcapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Adoaquien tied icbon: “¿Chieshanquiectabi ique? Ëmbi: ‘Nëidted piucquid menenu. Naic cho,’ cac ma mibi: ‘Ai,’ quepaboc. Mambi mibi aidtedquio menepaboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mimbi bedboed buanec nid. Ëbi bunacpaden tsyuec choash chonoadquid mibi meniactedquiobi meniombi. ¿Icsamboda iquec? ");
INSERT INTO mcfNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Icbon ambi tantiacpadomboen aton na dadpen meniac ada aid icsambo icpec? ¿Utsibotsen menesho isunda mimbi ëbi nëishëmpe? Aden nëishënac ¿ada bëdambo iquec?” quequin tied icbon chuipac caondash —quequin ompoacbimboen chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Adashic: —Adembidi abi yacnoshon ambi tantiacpadomboen Nuquin Papan naindac. Utsi-utsien chuiquid dapa icmequin utsi-utsien padenquio icmendac —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Adanec: —Edusaden yacno nidnu. Nid —quianec Esus nidpondash. Adec nidquimbi utsibo tantiamenquio icquin abëd icquido 12tedi icquid chuinuen uanotantsëcquin buampondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Buanshun chuipondashi naden: —Edusaden yacno nidacsho Nuquin Papan matsesmiaid icsho ëbi chieshënquido ëbi bedmendac. Nëish yua abided unës uaquido chuiquid dapabobëdtan Moisesën dada uampid chuibanquidon ëbi bedshun: “Ma unës uamenu,” queshun ");
INSERT INTO mcfNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","matses utsibo isadaidpembo ëbi bedmendac. Aden bedmiac matses utsibon mamënshunquin ëbi cueshcaten comapenen cueshcaindac. Adshumbic ëbi unës uanuen cuesten dectanendac. Aden unës uaqui daëdec ushash uincuenendabi —quequin Esusën abi unës uate padpiden chuioapondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Adnubien Sebedeyon chido Uanën titan Esus chuituidpondash. Uambëdta Acobo aton mado daëdi bëshun ismequin danëshën sebudtanquin chuipondash. —Ëmbi chiacpadomboen ëbi nashunta, Icbo —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Atotsi cai? —capondash Esusën. Adoaquien: —Nëid con mado daëdi nec. Abitedishun icbo icquin mibëdtan chuiquid dapa con mado abi daëdi icmeta. Chuiquid dapa icmequin min dayun tsadmeta. Opioc utsi tsadunquin abiuc utsi tsadunta —caquien Esusën: ");
INSERT INTO mcfNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Ëmbi naid tantienquio icquin mimbi chuipec —quequin ani chuishumbic Uanbëdta Acobo Esusën chuipondash. —¿Ada ëbi mëyadacpadquiecbidi mëyadtsia? ¿Ada chieshtoenquio icpatsia? —caquien Uan: —Ai, chieshtoenquio ictsiabi. Mibëd mëyadtsiabi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Adsho tantiashien: —Ai, ëbi tantiaquid yec mibi mëyadendac. Padnuembi ëbëdtan chuiquid dapa icmequin mibi ëbi datsadmetiapimbo iquec. Nuquin Papambien ambi tantiacpadomboen ëbëdtan chuiquid dapa icmendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Adnubimbi: —Chuiquid dapa ëbi icme —Esus casho tantiashun Uan chedo nëishëmpondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Adsho Esusën ëbitedi chuipondash. —¿Mitsipadquid matses utsibo isadaidpembo chuiquid dapa icpec? Abi chuiquid dapan baded-badedquien ancabudac dacuëdquin aton yuabon badedi naic. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ëbi tantiaquido icquin mimbi adoenquio iquendac. “Bëdambo mibi iquec,” Nuquin Papa cametiadquio icquin utsibo tantiaquin mimbi utsibo nashuntsiac. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bëdambo icquid ictiadquio icquin yuan aton icbo nashunacbimboen mimbi utsibo nashuntsiac. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Adembidi Nuquin Papan matsesmiaid icquin matses nashunquid nebi. Ancainquio icquin matses tantiaquin Nuquin Papa icsaquidobi cuidmenquio icnuec ëbided cuidadec unësendabi —quequin Esusën abëd icquido chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Adashic yuecquio ictanec shubu dadpen icquid Edico caid yacno tabadash auëshquiobi Esus nidpondash. Adsho isanec nidquin matses dadpenshun Esus tsibanampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Adnubien aid podqued cuëman bëshuaid dada daëd tsadpondash. —Esus cuenec —quesho tantiashien aid daëdi comapenec cuëdpondash. —Tsusedpa Dabidën tsyuecquid Nuquin Papan namiaidquio icquin ëbi bëdamboen ista, Icbo —quepondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Adsho tantiashun matses dadpenshun chushcapondash. —Padi. Chën. Adec cuëdec chieshanquiec mibi iqueque —caquien abi niacbidanec buëdanquiec cuëdpondash. —Tsusedpa Dabidën tsyuecquid Nuquin Papan namiaidquio icquin ëbi bëdamboen ista, Icbo —queoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Adoaquien Esusën nidtuidshun ëcbedpondash. —¿Atotsi chuinuec ne? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Isbente bunquiebi, Icbo —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Adsho tantiash: —Unësquio iquec —quetanquin Esusën bëshuaid daëdi bëmishpondash. Adoac abi daëdi bëdampondash. Bëdanshun aidëntsen Esus tsibanampondash bëshuacboedëmbi. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Adanec nidequi shubu dadpen icquid Edusaden caid anoentsëqui macuësh dapa Odibos caid poctse shubu daëdpactsëcquid Bedpaque caid yacno Esus nidpondash. Adshumbic anoentsëqui choshon abëd icquido daëd chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Nëid podquedën nidquin shubu daëdpactsëc yacno nidshun cabayobitsecquid aton bacuë caniatsëcbëdta mimbi badedquio istuidendac. Istuidshun tënëshaid tëdiadsho tëchicta. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mimbi tëchicsho isquidën: —¿Atotsi acnun nai? —cac: —Nuquin Icbo: “ ‘Bedtan,’ quiosh,” mimbi cac: “Ai, buantan,” quendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ambi Esusën nate chiaid Nuquin Papan con tsusedpa dada uamiampicpadomboen nanuen Esusën adopondash. Naden dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Shubu dadpen icquid Sion caidën tabadquido chui. Edusaden cain Sion capec. ‘Is. Mibi chuiquid dapa cabayobitsecquidën bacuë caniatsëc catsadtoash choeque. Ancanenquio yec bëdamboshë icquidquio neque. Is,’ quequin chui,” quequin dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aden dada uampicpadomboen ambi: —Bedtan —caidon bedtampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Adotanquin cabayobitsecquid anibëdta caniatsëc bëacshobimbi con dashcute bëntse dasiuidboed chictanquin casanondac. Aden ëmbi cabayobitsecquid casansho isash caniatsëquën Esus catsadtopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Adanec nidsho istanquin matses dadpenshun aton dashcute abi dasiuidaid bëntse icquid chictanquin Esus nidte podqued ansambampondash. Adnubien utsibon niste podobiecquid tetanequin podqued ansambampondash: —Chuiquid dapa Esus nec —queshun. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Matses dadpen bëyuc nidnubi aidtedbidi tsyuec nidpondash. Abitedi cuëdënidpondash. “Adeduya. Nuquin tsusedpa Dabidën tsyuecquid Nuquin Papan namiaid yec mibi bëdamboshë iquec. Nuquin Papan chomiaid yec mibi bëdamboshë iquec. Mibi chomequid Nuquin Papatsen bëdamboshë iquec. Adeduya,” quec cuëdëncuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Adec Edusaden yacno matses dadpenquio cuëdënidec nidsho isashien Edusaden yacnocquido: —¿Tsutsi tantiec cuëdëncuededpec? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Adsho tantiashun Esusbëd nidquido: —Esusquio tantiec nec. Nuquin nidaid cuëshë Cadidia caidën shubu dadpen icquid Nasaded caid yacnuësh caniondaid Nuquin Papan chiaidquio chuiquid Esus tantiec nec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Edusaden yacno choash Nuquin Papa tabadte shubu uashunaid umanuc daquënë uabenaidën Esus puduedpondash nuntanquio puduedenquio yec. Adshun isquien piucquid bednuequido dadpen tabadpec. Utsi-utsiec nidaid utsin icquido piucquid dadpen bedshunquimbi muaquin piucquid utsi daëdpactsëc menequid icnubi utsi-utsiec: —Nëid bedquidën: “Ma Nuquin Papan ëbi bëdamboen isnu,” queshun pichicametsiash —quequin aton nëish yua menequin piucquid dadpenquio bedquid nepondash. Adsho istanquin Esusën cuemepondash. Ambi tabëcaid bidiacbanquin aton yua dëbimbitsecquido cuemequin piucquid bednuequidotedi cuemepondash naden chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—¿Adenda mimbi Nuquin Papan chiaid bëdamboen nape? Naden Nuquin Papan chiaid dada uapampic. “Ëbi tabadte shubu uashunaid ëbi chianete shububidi nec,” quequin Nuquin Papan chiacpadomboen aton shubun puduedshun aid chianetiadquidi mimbi adoenquio iquec. Mitsana bedteuidi bunec ampec tabadte shubu mimbi icmiaye. Cuen —quequin cuemepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Adnubien Nuquin Papa tabadte shubu uashunaid yacno bëshuaid yec daicsaid yec quenuc bë-bëpondash. Aden bë-bëshobien Esusën bëdamepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Adsho isashien Esus chieshënquido nëishpondash. Adec nëish yua abided unës uaquido chuiquid dapabobëd Moisesën dada uampid chuibanquido nëishpondash. Adec comapenen tantiaquin Esusën nabansho isash nëishboedi bacuëbotsen: —Nuquin tsusedpa Dabidën tsyuecquid Nuquin Papan namiaid yec mibi bëdamboshë iquec —quec Esus caic cuëdëncuededsho tantiash nëishquiopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Adshumbic: —Icsambo iquec —queshun Esus chuituidec: —¿Ada bacuëbo cuëdënsho tantio? —caquien: —Ai, tantiombi. ¿Nuquin Papan chiaid isabida ictio? Naden bacuëbo cuëdënte chuipampic. “Nuquin Papan oncamiac bacuëmpin aton bacuë utsibëdtan: ‘Nuquin Papa bëdambo iquec,’ caindac.” quequin chuipampic —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Adanec nidec shubu dadpen icquid Betania yacno nidash ushtuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Badiadnubi ënden aucbidi nidoaic Edusaden yacnobidi nidoapondash. Piabi nidec bundoshon ");
INSERT INTO mcfNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","podqued cuëman nidquid cuëtempi icueda caid istuidash: —¿Ada bacuëaye? Chenun isbono —quepondash Esus. Adshun isquien bacuë nibëdec. Podouidquio icpec. Adsho isumbien Esusën: —Adequi bacuëesambo yec unësta —capondash. Adoac badedquio unëspondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Adosho isun abëd icquidon: —¿Atotsi quiash badedquio unësposh? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Esusën: —Tantia. Mibi chuinu. Adembidi mimbi natsiac. “Nuquin Papan ambi chiaid nainquien icchitec,” quenquio icquin: “Nuquin Papan ambi chiacpadomboen naquidquio nec,” queshun mimbi Nuquin Papa chianesho aidëmbi mimbi: “Natiapimbo iquec,” caidi mibi nametsiash. Aden tantiaquin mimbi nëid macuësh cain: “Mananuc tabadboedi adquiecbidi acte nantan tabadoata,” mimbi cac nëid macuësh acte nantan tabadoatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Ambi chiacpadomboen naquidquio Nuquin Papa nec,” queshun mimbi aid chianiac mimbi chiaid Nuquin Papan mibi nashuntsiash —quequin Esusën abëd icquido chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Adcuidanec Edusaden yacno padpidec nidshun Nuquin Papa tabadte shubu uashunaid daquënë uaidën puduedshun Esusën Nuquin Papan chiaid chuipondash. Adsho tantiashun con matses tsusiobon Esus chieshënquidon chuituidpondash. —¿Tsuntsin: “Naic nid,” cac nai? En chui. Tantianu —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Esusën: —En mimbia chui. Ëmbia tantianu. Mimbi chuisho tantiashun ëbi namequidtsen chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tsuntsin namiac Uan padon acten mentopadenec? ¿Ambembida napadenec? —capondash Esusën. Adoaquien badedquio chienquio yec uanotantsec tabadec onquecuededpondash Esus chieshënquido. —¿Atotsi nuqui chuipeba? “Nuquin Papan namiaidquio Uan pado nepadenec,” cac Esusën: “¿Atotsieshun aidën chiacpadomboen nainquio ique?” canushe. Aden chienquien ictiad. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nuqui: “Ambembi napondash,” quesho tantiashun nëmbo icquidon nëishënushe: “Nuquin Papan namiaid Uan pado niondash,” queshun. Aden chienquien ictiad —quepac caondash Esus chieshënquido. Isadaidbo tsusiobobëdi nëish abided unës uaquido chuiquid dapabo adpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Adashien Esus padpiden chuioaic: —Tsaudi. ¿Tsundan chiaquien nachitondash? —queshobien: —Mimbi chienquio icsho tantiashun ëmbitsen ëbi namequid chienquio iquembi —capondash Esusën abi chieshënquido cuidquin chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Adshumbic Esusën padpiden chuipondash. —Tantia. Mibi chuinu. Ëmbi chiaid tantiashun ¿mitsicquid: “Bëdambo iquec,” catsia? Dada aton mado daëdpambo icquid icpac caondash. Abentsëc chuiquin: “Neshcaic nid, mado,” cac: ");
INSERT INTO mcfNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Padi,” quec chieshuidboedi yuec-yuecpactsëctanec: “Tiedimbi neshcatanchitec,” quiash neshcaic nidac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Adshumbic amën aton mado utsi chuiquin: “Neshcaic nid, mado,” cac badedi: “Ai, adonona,” queboedi neshcaic nidenquio icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Mitsicquidën aton papan chiacpadomboen napac caondash? En chui. Tantianu —caquien Esus chieshënquido: —Abia chiac chieshuidboedën —quesho tantiashumbien Esusën: —Adquidpenquien mibi nec. Mibi tantiatiapimbo yec tabadnubi mimbi icsambo caido Nuquin Papa yacno puduedendac. Chieshuidacbimboecquid aido nec. Aton matses piucquid bedshundenedo yec aton piucquid bednuen dada chudmeboedo chido yec quequin Nuquin Papa tantiabenash abëd tabadtequido yanendac. Mibien padenquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Uan pado acten mentoandenedën Nuquin Papan chiaid chuiquin bëdamboec tabadte chuipadenec. Adsho mimbi tantienquio icnubi mimbi icsambo caidombi Nuquin Papa tantiabempondash. Adsho isun Uan padon chiacpadomboen mibi icsaid ëntiadquidi mimbi ënenquio iccondac. Aton papan chiaid niacquidbimboecquid mibi nec —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Adshumbic Esusën abi chieshënquido ompoacbimboen chuipondash naden. —Tied icbon chetequid nidtsinac caondash. Adoshombic aid tied daquënë uatanquimbic chetequid chintetsen nacnempac caondash. Adoshombic: “Ampequid chosho isnu,” queshun shubu abucquio icnuc shubu uapac caondash. Adoshombic: “Nëid tiedën caniquid chetequid iquec. Aid chequin ëbi neshcashunta,” utsibo canec ënapen nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Adash yuectaneshumbien abëd nidondaido aton yuabo chuiquin: “Nëen chetequid sinashe. Bedtan,” cac aton yuabo nidanepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Adec aton icbon tiedno nidaniacshobien neshcaquidon cudasënquin chieshëmpac caondash. Abentsëc cuesunetanquin utsi cuënoten seshunequiopac caondash. Utsibic cuesquin cuemepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aden cuemiaid choshon chuituidaquien icbon nidboedtedpenquio dadpenquio aton yua utsibo chuipac caondash. “Bedtan,” cac nidanec tiedno choacsho isun adembidi cuesun siapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Adoacsho tantiash aton madombo caic: “Bedtan,” quepac caondash. “Con mado cuesunenquio icquin ëmbi chetequid menetsiash,” queshun aton madotsen nidmepac caondash ");
INSERT INTO mcfNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Adoac nidec aton papan tiedno choacsho chetequid cudasquidon: “Tied icbo unësan aidën natedi aton madon bedtsiash. Nëbien aton mado cuesunetiad. Aid nibëdnuc icbo unësan aidën natedi nuquin nabi ictsiashe,” queshun ");
INSERT INTO mcfNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","tied tsitsuno buanshun cuesunepac caondash —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Adshumbic ambi chuiboedquio abi datsidadquido chuimenuen chuipondash. —Ëmbi chuiboed tantiash ¿atotsi mibi quepatsia? “Min mado cuesuniaccosh,” cac ¿atotsi tied icbon napatsiash? —quesho ");
INSERT INTO mcfNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tantiash datsidadquido: —Aido icsamboshë icsho comapenen cuidtsiash. Adshumbic ambi chetequid sinacsho abi cudasënesambo utsibo aton tied neshcametsiash —quecuededpondash datsidadquido. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Adsho tantiashun Esusën: —Ai, abimbo caic. Adembidi ambi chomiaid chieshënsho Nuquin Papan mibi cuidendac. ¿Nuquin Papan chiaid isabida ictio? Naden chiampid ma mimbi ispaboc. “Buintad bëdambo icquid istuidashi: ‘Nëidquio shubu uanun nitsinembi,’ quetiadquidi isuidacbimboen Nuquin Papan namiaid chieshënac. Aden buintad isuidaid utsin bedshun shubu uanun nitsinacbimboen Nuquin Papan tantiamiacpadomboen utsibon ambi namiaid tantiosh. Adsho isun: ‘Nuquin Papan namiaid bëdambo iquec,’ caimbi,” quequin dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aden ambi namiaid ëbi chieshënsho isash mibi caic Nuquin Papa nadpec. “Ëmbi con matses caid isadaidbo ëbi bëdamboen tantiametiadquidi chuiquid dapabon namenquio icsho isun utsibotsen: ‘Ëbi chuiquid icta,’ caindambi,” quepec Nuquin Papa. Aden ambi chiacpadquidën bëdamboen chuibanac abi tantiaquido dadpen yanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mibien Nuquin Papan cuidtequido nec. Cuëte uebudquin catashac canite uesadec podquëd-podquëdacbimboecnuc mibi comapenen cuidendac —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Adsho tantiashun padiseyobobëdtan nëish abided unës uaquido chuiquid dapabon: —Nuquien cachitec —quequin tantiabempanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Adshumbic Esus cuesunemenuen bedtiadquio icquimbi bedenquio icpanëdash. —Abi datsidadquidon: “Nuquin Papan chiaid chuibanquidquio Esus nec,” queshun Esus bedsho isun nuqui cuesnushe —queshun aton matses dacuëdënquin bedenquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Adshumbic Esusën padpiden ompoacbimboembidi chuipondash naden. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Tantia. Isadaidbon nacpadomboen aton mado chido bednuesho tantiashun amën matses dadpen: “Pec cho,” cauidaid mibi chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chuiquid dapan aton yuabo chuiquin: “ ‘Con icbon madon chido bedeque. Aidbëd cuishonquenuen pec cho,’ quequin ëmbi tantiaidotedi chuitan,” cac yuabon chuitanaqui choenquio icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Adsho isumbien chuiquid dapan aton yua utsibo chuiquin: “Nëish nua bëchichoquidquio dadpen codoquiaccoshe. Padpiden chuitan,” cac chuitanoaqui ");
INSERT INTO mcfNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","choenquiobidi icpac caondash. Adec cacuidanquiec abentsëc aton tied nantan nidnubi utsi piucquid bednuequin ambi aton na menebante shubuno nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Utsimbic abi: “Pec cho,” cashobi yuabo mëyanquin cuesun secapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Adoshobien chuiquid dapan nëishtanquin shëpiapac caondash. “Uesquin cuesun siatan,” cac aton sondado chedon aton yuabo cuesun siaquido uesquin cuesun secatanquin aton shubutsen uesquin nëdëncapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Adomeboshombic chuiquid dapan: “Abi pete codocaid dadpen iqueque. ‘Pec cho,’ cac cacuidanoshe. Utsibo chuitan. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ëmbi: ‘Pec cho,’ cacmaidobi chuibenetan. Podquedën nidquin mimbi istuidaidtedi: ‘Pec cho,’ cabenetan,” cac nidshun ");
INSERT INTO mcfNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ambi istuidaidtedi chuibenetanac matses dadpenquio pec cho-chopac caondash. Icsambo icquidobëdi bëdambo icquido cho-choash chuiquid dapan shubun puduedash pec tabadte quënë dapan tabadcuededpac caondash tsucus-tsucustsëcquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Adshun chuiquid dapantsen puduedshun isquien dashcute bëdaidquio dasiuidabi icquid abentsëc tsadtsec. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Adshobien chuiquid dapan: “¿Atotsi quiash dashcute bëdaidquio dasiuidambobi cho, buchi?” caqui ëcbedenquio yec tsadec. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Adshobien chuiquid dapan: “ ‘Chido bedacno isnuec dashcute bëdaidquio dasiuidquid,’ quepadenec. Mibi icsambo iqueque. Mibi cuidnu,” queshun aton yuabo chiec: “Shëbunshun buanshun icsano netan,” capac caondash. Adoac taneshun netanac mëyadquiec natiaic shubiquiopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Adembidi Nuquin Papan ambi matses bëdamboen iste dadpen tantiamiaqui utsin-utsinquien tantienquio iquendac. “Abi yacno puduednu,” queuidboedi bëdambo icte bunenquio yec abi tantiatiapimbo icsho Nuquin Papan comapenen cuidendac. Utsi daëdpactsëquien Nuquin Papan tantiacpadec abëd tabadtequid iquendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Adsho tantianec nidash abi chieshënquido padiseyobo: —Esus icsamboen chuimenuna. Icsamboen chuisho tantiashun bedshun unës uamechitono —queshun ambi chuibanquin tantiamiaido chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","—Icsamboen chuimetan —caquien chuiquid dapa Edodes caid tantiaquidobëdtan icsamboen chuimenuec cho-choshon chuituidpondash. —Bëdamboen chuiquid mibi neque. En ëbi chui. Tantianu. Muesambo icquin Nuquin Papan chiacpadec bëdamboec tabadte mimbi abimbo chuipoc. Matses dacuëdënenquio icquin Nuquin Papan chiaidquio mimbi chuipoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Adquid icquin ¿atotsi mimbi chuipe? Tantianu. Chui. Nuquin matses yuaquid chuiquid dapa Sesad caidën: “Piucquid shocoshëmpi dadpen beccho,” cac nuqui meniac ¿ada bëdambo icpatsiash? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Adoaquien Esusën ambembi tantiashun: —Bëdambo icquid damianquiec mibi muambo nec. ¿Atotsieshun ëbi icsamboen chuimetiadquio ique? —quetanquin: ");
INSERT INTO mcfNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Chuiquid dapa menetequid piucquid shocoshëmpi beccho —ambi cac ");
INSERT INTO mcfNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","bësho bedshun Esusën chuipondash. —¿Në tsutsibimboecnuc dada uaid në iquec? ¿Tsutsi cuëmëdquidbëdta dada uac? En chui. Tantianu —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Ma nuqui yuaquid chuiquid dapambo Sesad neyoc —quepondash. Adsho tantiashumbien Esusën: —Abibimboecnuc dada uaid abi cuëmëdquid dada uaid bedtequid shocosh icnuc Sesadën na neque. Icbon: “Beccho,” cac meneta. Adecbidi Nuquin Papa nuquin Icbombo neque. Aidën chiacpadomboen nabanta —quequin Esusën bëdamboen chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Adsho tantiash icsamboen chuimetiadquio icboedi: —Bëdamboen chuipec —quetanec nidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Adnubien aid ushëmbi Saduseyubo: —Matses unësaid uincuenesambo nec —quequidotsen: —Esus icsamboen chuimenu —quec cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Bëdamboen chuiquidquio mibi neque. Mimbi chuisho tantianu. ¿Mitsipaden mimbi chuipatsia? Nuquin tsusedpa Moisesën naden chuiquin dada uapampic. “Aton chido bedash bacuë tishmiabi unësacsho aton utsin aid chido bedshun: ‘Con buchin bacuëbo nibëdeque. Con buchin madobimboecnuc tishmenu,’ quequin tishmequid,” quequin Moisesën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aid tantiaquin chuinu. Dada aton utsibobëd tabadpac caondash. Aton utsibo seistedi icpac caondash. Bëyucquid aton chido bedashi bacuë tishmiabi unëspac caondash. Adsho isun abi tsibanquidën aidën chido bedash ");
INSERT INTO mcfNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","bacuë tishmiambobidi unësoapac caondash. Adsho isun aid tsibanquidën aid chidobidi bedoashic bacuë tishmiambobidi unësoapac caondash. Adenuidi abi tsibanquidën abi tsibanquidënquien aton buchi unësan-unësanquien aid chidouidi beduid-beduidpac caondash. Bacuë tishmiabi-tishmiabiec abitedi unësbudnepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Adashic bacuë tishambobi aid chidotsen unëspac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aid abitedi uincuemiac ¿mitsicquidën chido icpatsiash? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Esusën: —Nuquin Papan chiaidquio tantienquio icquin Nuquin Papan nadatiambo icquin nabanquin uincuemete mimbi tantienquio iqueque. Chuinu. Tantia. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Uincuemiac dadan aton chido bedesa. Adembidi amën aton champi menesa. Nuquin Papan abi yacnoshon uaido mayan bëdabobimboec matses uincuemiaido iquendac. Aden uincuemiaidën chido bedesa —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Adshumbic padpiden chuipondash. —Ambi unësaid uincuemete chuiquin Nuquin Papan dada uamepampid ¿isbanabida ictio? Ma mimbi aid isbampaboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Naden dada uapampic. “Abadauan caid yec Acobo caid yec Isac caid yec quequidtedishun ëbi Papa capec,” quepampic Nuquin Papa ënden unësampid chiequi. Unësun matses tantienquien mimbi danec. Unësash aton dada chodquiambic aton tantiate unësambo icnuc abi Nuquin Papa tantiatsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Adsho tantiash abi datsidadquido: —¿Mitsipadquid nepec? Bëdamboenshëen chuipec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aden unësaid uincuemete chuisho tantiashumbien Saduseyobon padpiden: —En chui —cainquio icpondash. Adsho isashien Esus chieshënquid utsibo Padiseyobo: —Nuquin Papan chiaid Esus icsamboen chuimenu. Nid —quianec Esus chuimec cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Cho-choquin abentsëcshun Nuquin Papan Moises dada uamiampid tantiaquidquio icquin chuimetuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Chuiquidquio mibi neque. En ëbi chui. Tantianu. Nuquin tsusedpa Moisesën dada uaquin dadpen chiampic. ¿Mitsicquid abentsëc ëmbi nasho Nuquin Papan: “Bëdamboshë iquec,” capatsiash? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Esus: —“Nuquin Papa tantiaquiec ambi chiacpadec tabadte bunquiota,” quequin ");
INSERT INTO mcfNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","chiampidba naic Nuquin Papan chiacpadec mibi bëdamboec tabadtsiandac. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Adembidi Moisesën chiampid utsitsen naic matses bëdamboec tabadtsiash. “Min dada mibibi datantiadacbimboen utsibotsen tantiaquiota,” quequin chiampicpadomboen nasho Nuquin Papan bëdambo catsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aden matses bëdamboen namenuen Nuquin Papan ambi chiaid utsi abitedi Moisesba chuishun nuquin tsusedpa utsibo chuiquin dada uamepampic —quequin Esusën bëdamboen chuipondash abi chieshënquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Adshumbic Esusëntsen abi icsamboen chuimete bunquido Padiseyobo chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Ëmbitsen mibi chuimenu. Tantia. Nuquin Papan chomiaid ¿mitsipadquid nec? ¿Matsesën madouidida nepec? —capondash Esusën abibi cadquimbi. Adoaquien badedi: —Nuquin tsusedpa yampid Dabidën tsyuecquid icsho Dabidën mado caimbi —quepondash Padiseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Adsho tantiashumbien Esusën: —¿Bëdamboenda chuidio? Mimbi chiacpadquid aton mado icsho ¿atotsieshun Nuquin Papan Mayanën tantiamiacpadomboen Dabidën con Icbo capampic? Naden Dabidën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Nuquin Papan con Icbo naden chiendac. ‘Con abiuc tsadash abitedishun Icbombo icnush nëmbo cho. Mibi chieshënquidobi con Icbo mibi camenu,’ quequin Nuquin Papan con Icbo chiendac,” quequin Dabidën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Con mado cainquio icquin con Icbo capampic Dabidën. ¿Atotsieshun mimbi: “Dabidën mado nec,” quequin tantiape? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ëcbedenquio yec otacquio tabadpondash. Esusën bëdamboen chuisho tantiash: —Icsamboen chienquien icchitec. Ëmbi padpiden: “Icsamboen chuimenu,” cac bëdamboembidi chuioatsiash —queshun abi chieshënquido abitedishun Esus padpiden chuimenquio icquin ënaccondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Adshumbic Esusën abëd icquidobëdta abi datsidadquido tantiamequin chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Tantia. Moisesën dada uampid chuibanquidobëdtan tsusedpabon chiampid namequido Padiseyobon naid mibi chuinu. Aidon: “Moisesën chiampicpadomboen nata,” quequin nuquin matses isadaidbo chuidenepec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aden Moisesën dada uampid abimbo chiac adenuidi mimbi nac bëdambo ictsiash. Aden naquin padiseyobon nacpadomboen nainda. Aidon Moisesën chiampid chuiquimbi ambibi aidën chiaid niac-niaquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chieshëmënquido nec. Nuquin Papan chiaid nametiadquidëmbi tsusedpabon ambembi chiaid dadpenquio namepec chushcanquin. “Matsesën aidtedi natiapimbo iquec. Padi icnuna. Nuquin matsesën chiampidtedi nainda,” catiadquidi adoenquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aden padiseyobon Nuquin Papa tantiaquidquio damequin matses ismenuenuidi naic. Nuquin Papan chiaid dada uaidëmpi sauedtsash bëdectamëdec abiuc daëdi pëdectamëdec queshun matses ismenuenuidi naic. Adembidi aton dashcute tëdiadte nacnenuequin: “ ‘Nuquin Papa chianequidquio nec,’ ma ëbi canu,” queshun sedquid shoyonaid ënapenpactsëcnuc cuididicash matses ismenuec matses tabadacno capucuenepec. Adec Nuquin Papa chianequid damianquiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Chuiquid dapa nec,” cameteuidi bunec. Isedec puduedash: “Chuiquid dapa icsho icbon abëdi tsadmequid,” quiash icbobëdi tsadte bunquiec. Nuquin Papan chiaid chuibante shubun puduedash: “Tsusio dapambo nec,” camenuec utsibobëd tabadenquio yec tsusiobobëduidi tabadquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","“Chuiquidquio yec mibi bëdambo iquec,” camete bunquiec matses dadpen tabadacno nidtenepec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mibitsen adenda. Utsibo: “Mibiuidtsëqui bëdambo iquec, Icbo,” camenuec adenda. Min Icbo abentsëcquiobi ëbi iquec. Ëbi abentsëqui con Icbo cata. Con yuabo yec con utsibo mibi neque. Bëdamboec isnanta. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Adembidi mibi chuibanquid chuiquimbi: “Mibiuidtsëqui bëdambo iquec, Papa,” cainda. Nuquin Papauidtsëqui aden chuita. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Adembidi: “Chuiquid dapa yec mibiuidtsëqui bëdambo iquec,” utsibo camenuenuidi nainda. Ëbiuidtsëqui mibi chuiquid dapa nec. Nuquin Papa yacnuëshquio choquid ëbipadquidquio utsi nibëdec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Padnuen ambi chiacpadomboen utsibo nashunquidquio utsibo dëniacte bunenquio icquid Nuquin Papan bëdamboshë catsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Utsien abibi cadequi: “Ëbiuidtsëqui bëdambo iquec,” quequin utsibo ismenuenuidi naquido Nuquin Papan icsambo catsiash. Utsibic Nuquin Papan chiacpadomboen naquin utsibo nashunquid yec utsibo ismeteuidi bunenquio icsho Nuquin Papan bëdambo caindac —quepondash Esus abi datsidadaido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Adshumbic abi chieshënquidotsen chuipondash. —Tantia. Moisesën chiampid chuibanquidobëdta Padiseyobo mibi chuinu. Nuquin Papan cuidtequidombo mibi nec. Bëdambo icquid damianquiec mibi icsambo iquec. Nuquin matses: “Nuquin Papabëd tabadte tantianu,” queshobi mimbi bëdamboen chienquio iquec. Ëmbi Nuquin Papabëd tabadte bëdamboen chuisho mimbi tantienquio iquec. Aden tantienquio icquin: “Aidën chiaid tantienda,” quequin mimbi utsibotsen Nuquin Papabëd tabadte tantiametiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nuquin Papan cuidtequido mibi nec. Muaquin unësboedën niante piucquid bedshunquido mibi nec. Nuquin Papa tantiaquidquio damenuen utsibo tantiamequinuidi buëdpambo cuëdquin Nuquin Papa chiacbimboen mimbi chianepec. Aid abimbo mimbi chienquio iquec. Adec chieshanquiecsho isun Nuquin Papan mibi comapenen cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nuquin Papan cuidtequido mibi nec. Mimbi tantiacpadomboenuidi tantiamenuen mimbi matses utsibo chuiben-chuibenec. Nidaid utsi-utsiec yacno nidshun mimbi chuibenesho tantiaquido mimbi tantiacpadquio yanash Satanasën yuambo yanec Nuquin Papan cuidtequidombo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nuquin Papan cuidtequido mibi nec. Isadaidbo chuiquid icquin bëdamboen tantiamenquien mimbi icchitec. “ ‘Nuquin Papa utsi uatiapimbo yacpaden abimbo caimbi,’ quequid muaisa nec. Muaquidën Nuquin Papan chiaid niacquid,” quetiadquidi mibi adenquio iccoc. “ ‘Nuquin Papa tabadte shubu uashunaid utsi uatiapimbo yacpaden abimbo chiombi,’ quequid muesa nec,” quetiadquidi mibi adenquio iccoc. Padenquio yec: “ ‘Nuquin Papa tabadte shubu uashunaid dapan icquid shocosh piu nacnenaidquio utsi uatiapimbo yacpaden abimbo chiombi,’ quequid muesa nec,” quechitequien mibi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aden tantienquio icquin mimbi icsamboen chiec. Nuquin Papa tabadte shubu uashunaid Nuquin Papa tabadtequid yec ¿bëdapenquioda icpec? “Aid bëdamboshë icnubi aid nuntan icquid bëdiactsëc bëdambo iquec,” caimbi. Mimbien icsamboen tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nadentsen mimbi icsamboen chiec. “ ‘Nuquin Papa tabadte shubu uashunaid dapa yacnoshon: Mabi Nuquin Papan bëdamboen isnu, quequin nëish pichicate nacnenaid dapa utsi uatiapimbo yacpaden abimbo caimbi,’ quequid muesa nec,” quetiadquidi mibi adenquio iccoc. “ ‘Nuquin Papa mabi bëdamboen isnuequin pichicatequid nëish utsi uatiapimbo yacpaden abimbo caimbi,’ quequid muesa nec,” mibi quepec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¿Adenda mimbi bëdamboen chuipe? Pashuacbimboen mimbi bëdamboen tantienquio iquec. ¿Mitsicquid bëdambo iquec? “Mabi Nuquin Papan bëdamboen isnu,” quequin nëish pichicate nacnenaid dapa bëdambo icnuc aidën pichicatequidi nëishquio bëdapabi ictsec. Nuquin Papamboen bëdamboshë iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nëish pichicate nacnenaid caic: “Aid utsi uatiapimbo yacpaden abimbo caimbi,” quequin aid nantequid nëish abitedi chiaidbidi nec. Adembidi ambi: “Mabi bëdamboen isnu,” caid Nuquin Papatsen chuipec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Adembidi Nuquin Papa tabadte shubu uashunaid caic: “Aid utsi uatiapimbo yacpaden abimbo caimbi,” quequin ambo tabadquid Nuquin Papatsen mimbi chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Adembidi abu caic: “Abu utsi uatiapimbo yacpaden abimbo caimbi,” quequin Nuquin Papa tsadaidtsen chiec. Nuquin Papa tsadaid cain Nuquin Papambo chiec. Aidën chiaidquio tantiec: “Abimbo cacbimboen chuiquid icsaquid nec,” quetiadquidi mibi adenquio iccoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Bëdambo icquid damianquid yec Nuquin Papan cuidtequido mibi nec. Nuquin Papan chiaid abentsëqui tantiatsëcquin min tiedën canitsëcquid musuquëmpi bedshun Nuquin Papa mimbi menepec. Aden menequid icquimbi mimbi Nuquin Papan chiaid utsi dadpen niac-niacpec. Chieshëmianquid icboedi: “Ëbi bëdamboen ista,” quesho bëdamboen istiapimbo mibi iquec. Adembidi bëdambo icquidi muauaquin mimbi tsusio icsamboen cuidmec. Adembidi mimbi Nuquin Papa abimbo tantienquio iquec. Aden mimbi Nuquin Papan chiaid niac-niacpec. Ambi chiacpadomboen Nuquin Papa menequid icquimbi ambi chiaid utsi abitedi natiadquidi ma mimbi nainquio icpaboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tantesa uatsëcquimbi mimbi utsibo icsamboen chiec. Manuampi nibedbantsëcquimbi utsi nuacquid nibedquiabi abi nësamëdpanumbobi acacbimboembien mimbi nachitec. “Nuquin Papa meneta,” quequin chiaiduidtsëqui natsëcshun adenuidtsëqui mimbi utsibo namepec. Adenuidtsëqui namequimbi Nuquin Papan chiaid utsien mimbi niac-niacchitec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nuquin Papan cuidtequido mibi nec. Padiseyobo yec Moisesën dada uapampid chuibanquido yec quequimbi mimbi icsamboen naic. Pada-padaidbëdta dëshote chieshquin cachocuidtsëqui dapanshun anauc ampanambo icquidi ampanaid damianacbimboec mibi bëdamboec tabadquid damianquiec. Nuquin Papan chiaid dadpen nainquio icquin mitsanauidi bednuen mibi bunaiduidi mimbi napec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pamumëdacbimboec tantiatiapimbo mibi iquec. Dëshote abichobi bëdamboen ampanacbimboec icsaid ucudash bëdambo icta. Adec icsainquio yec ënëdash Nuquin Papan chiacpadec mibi bëdamboec tabadtsiac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bëdamboec tabadquido mimbi damesho isun Nuquin Papan mibi cuidendac. Unësaid chococacno bëdamboen nacnenac bëdambo isadec ënden pisenambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Adembidi bëdamboec tabadquid mimbi damec. Matses ismec bëdamboec tabadshumbic omposhon Nuquin Papan chiaid niac-niacquin mimbi natemaidien mimbi nachitec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nuquin Papan cuidtequidombo mibi nec. Nuquin Papan oncamiaidobëdta bëdamboec tabadquido nuquin tsusedpabon unës uampido tantiaquin aido chococampicno shubu uaquin mimbi nacnempec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Adoshombic: “Nëmbo con tsusedpabon chieshënquin unës uampid chococac. Aidbëd tabadquin ëmbi unës uainquio ictsenëdac. Ëmbien bëdamboen istsenëdac,” queshun mimbi aido chococacno nacnempec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Adoboedëmbi nuquin tsusedpabon bëdambo icquid unës uampicpadomboen adoante bunquin mimbitsen chieshtoshon adoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ai, nuquin tsusedpabon Nuquin Papan oncamiampid unës uacpadombota —quepondash Esus abi unës uate chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Adashic abi padiseyobo chiec: —Nisibimboec icsa uanquido mibi nec. Adquido icsho Nuquin Papan icsano nësecaquin mibi cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Icsaido icsho isun: “Ma Nuquin Papan bëdamboen iste tantiamenu,” queshun Nuquin Papan chiaid chuibanquido utsi-utsien mibi yacno nidmendambi. Adquid mibi yacno cho-choacsho mimbi dadpen unës uaindac. Utsi-utsien cuesten dectanquin utsi-utsien Nuquin Papan chiaid chuibante shubunoshon cueshcaten mimbi cueshcaindac. Utsi-utsien cuesnuequin nadancatanequin shubu utsin shubu utsinquien mimbi cuemetanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Adosho isun Nuquin Papan mibi cuidendac. Nuquin Papan chiacpadec bëdamboec tabadsho tsusedpan chieshënquin tauamboen cuesuniampid Abed nepampic. Adoshombic adecbidi bëdamboec tabadsho tsusedpa utsibon utsi-utsien unës uapampic. Adoshombic ënquin Bedequias caidën mado Sacadias caid unës uapampic. Aidi Nuquin Papa tabadte shubu uashunaid dayunshunquio cuesunepampic. Aidtedi unës uampido tantiaquin aido unës uaquido cuidacbimboen Nuquin Papan mibitsen cuidquiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Yuecshun min tsyuecquido cuidendac,” quec nenquio iquebi. Nëbi caimbi —capondash Esusën abi chieshënquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Adshumbic Esusën chuioapondash. —Tantia, Edusaden yacnocquido. Mibitsen chuinu. Mibi tantiac unësquio iquec. Mibi yacnobidi tabadquin Nuquin Papan oncamiaidon chuisho nuquin tsusedpabon unës uapampic. Adembidi Nuquin Papan: “Isadaidbo chiec nid,” caido chosho utsi-utsien cuënoten seshunequiopampic. Adembidi mimbi nëbi naindac. Adquidombo icsho mibi tantiaquiembi. ¿Mitsipadec cachina aton bacuë cudaspec? “Penushe,” quiash aton bacuëmpi nua shoccoshon madadec cudasquid. Adecbidi: “Satanasën yuanushe,” quiash cudasquiec mibi Nuquin Papa bëdamboen ismete tantiametiadquio iccobi. “Tantiamenu,” cac tantiate bunenquio mibi icchitoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ëbi nidambic ëbi tantiatiapimbo icsho Nuquin Papan namiac min shububëdtabi mibi nibëdamendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nëbi mimbi ëbi isenquio yanendac. Padnuen min matsesën yuecash chosho ëbi isendac. Aden isash: “Nuquin Papa yacnuësh choquid bëdambo iquec,” min matses quendac —quequin Edusaden yacnocquido Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Adash Nuquin Papa tabadte shubu uashunaid daquënë uacno tabadanec nidequi Esusbëd icquido Nuquin Papa tabadte shubu uashunaid caic: —En is, Icbo. Nëid shubu bëdamboen nacnenaidquio neque —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Adsho tantiashun Esusën: —Mimbi isboedquio cuënote bëdamboen nacnenaid matses utsibon cuënote chic-chiquendac nibëdquiecnuc —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Adanec nidequi macuësh dapa Odibos caidën pudundoec poctsebi tabadtuidshun abëd icquidon utsibo tantiamenquio icquin Esus chuipondash. —En mibi chote chui. Tantianu. “Nëbi choec,” quequin mibi chote ¿mitsipadembimbi tantiape? Adecbidi ¿atotsi isashini: “Nuquin Papan cuidte nëbi nec,” quepe? —capondash abëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Adoaquien Esusën naden chuipondash: —Tantia. Mibi chuinu. Muaquidoba choendac. Aidon chuisho tantiash: “Abimboen chuichitec,” quenda. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Adquido choshon: “Nuquin Papan chomiaidquio Quidistu caid nebi,” quequin muaquin chiaqui dadpenshun: “Ai, abimboen mimbi caic,” capendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ëbi choabi icnuc: “Matses dadpenquio cuesnan-cuesnanac caosh,” quecuededendac. Adsho tantiash dacuëdenda. Nuquin Papan matses abitedi cuidte ushë choabi icnuc ambi tantiacpadec matses adonanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Adec matses utsi dadpen icquido matses utsibobëd cuesnanendac. Nidaid utsi-utsiec yacno pete nibëdquiec icted-ictedendac. Nidaid utsi-utsiec yacno nidaidquiobi comapenec uëdëquedenendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Adsho isash chido bacuë nëncuenacsho isun: “Nëbien tishchitec,” quequin tantiacbimboen tantiata. “Nuquin Papan abitedi cuidte nëbi nec,” quequin tantiata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Adashic abi onquec: —Ëmbi chiacpadquio icnuc chieshëmënquidon ëbi tantiaquido bedshun chieshënquin utsi-utsien cuesendac. Utsi-utsien unës uaindac. Aden nidaid utsi-utsiec yacno tabadquidon dadpenshun ëbi tantiaquido chieshënquiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Adoac ëbi tantiatsëcboedëmbi chieshtoshon ëbi tantienquio yanendac. Aidëmbi ëbi tantiaquid ompodacsho istuidmeshun mëyamendac. Adashic abipadquid utsibobëd chieshënanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Padnuen muaquido: “Nuquin Papan chuiboedquio chuinu. Tantia,” quependac dadpen. Adsho tantiashun dadpenshun: “Ai, abimboen mimbi chiec,” caindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Matses dadpenquio icsamboecshë tabadsho isun ëbi tantiatsëcboedëmbi ëbi tantienquio yanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Padnuembi ëbi choabi icshobi ënenquio icquin ëbi tantiaquido Nuquin Papa yacno tabadmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ëbi choabi icnuc: “Ma matses abitedishun Nuquin Papabëd tabadte tantianu,” queshun ëbi tantiaquidon nidaid utsi-utsiec yacno nidshun chuiben-chuibenendac. Matses abitedi chuibenequin nainambi choaindabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Adashic abi onquec: —Ëbi chote ushë nëbi yanuc matses icsamboshë icquid Nuquin Papa tabadte shubu uashunaid dapa icsa uanuec puduedshun: “Mimbi Nuquin Papa caid tantienda. Ëmbi chiacpadomboenuidi nata,” quequin Nuquin Papa chieshënquin chiendac. Ëndenquimbo nuquin tsusedpa Danied caidën aden icsa uate chuiquin Nuquin Papan chiaid dada uapampic. Aidën dada uampid mimbi isaidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aden: “Nuquin Papa tabadte shubu uashunaid dapa icsa uanuec puduedosh,” quesho tantiash Udeya yacnocquido macuësh dapa yacno ompodec cuenac bëdambo ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Adec cuenec shubu dayun icquido puduedenquio yec: “Con na bednu,” quenquio yec umanucuëshi cuenac bëdambo ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Adecbidi badedquio cuenuen tied nantan icquidon aton dashcute utsi aton shubuno beduanenquio yac bëdambo ictsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nidequi bacuë usunquid yec bacuë chishmequid yec quec badedquio cuentiapimbo yec mëyadquiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Adec cuente tantiec: “Ue sequenumbo cuemenquio icpashuni,” queta. “Pete bedmianenquio icnushe,” quiash “Chonoadenquio icte ushënquio cuemenquio icpashuni,” queoata. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aden Nuquin Papa tabadte shubu uashunaid dapa icsa uate bunquid icsamboshë icquid choan matses dadpenquio natiambo chieshëmënquiec tabadendac. Nuquin Papan tauamboen matses uac adec tabadenquio ictenec. Nëbi adec tabadenquio iquec. Aido icsamboecshë tabadquido nibëdanambic utsibo adquidpenquio yanoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Adec icsamboecshë tabadte tantiaquin Nuquin Papan: “Ëmbi Esus tantiaquid icmiaido uesquin cuesun sianushe. Matses abitedi nibëdanushe,” queshun yuenquio icsamboen tabadmenquio icquin ënëdmendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nuquin Papan aden ënëdmiabi yac icsamboecshë tabadec utsibo: “Is. Nëid Nuquin Papan chomiaidquio Quidistu neque,” quependac. Utsibic: “Is. Nëidquien Nuquin Papan chomiaidquio Quidistu caid neque,” quequin icsamboen chuioaindac. Adsho tantiashun: “Nuquin Icbo Esus choashien nec,” cainda. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Adec muaquidoba choendac. “Nuquin Papan chomiaidquio nebique. Is,” quequin comapenen tantiaquin nabanquin ismendac. Utsibontsen: “Nuquin Papan oncamiaid nebique. Is,” quequin nadatiambo icquin nabanquin ismendac. Adsho isun dadpenshun: “Ai, abimbo caic,” caindac. Padnuen Nuquin Papan: “Muambo nec,” quequin tantiamiabi yac ëbi tantiaquidontsen: “Ai, abimbo caic,” catsempendac. Nuquin Papan bëdamboen tantiamiaido yec adtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“ ‘Chieshëmënquido iquendac,’ quequin tantienquio icquidën ëbi tantienquio yanushe,” queshun: “Aden ëbi tantiaquido chieshënquiendac,” quequin chiombi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Adashic padpidec onquec: —Ëmbi aden chuiboed tantiashun utsibo muasho tantienda. Ëbi caic: “Utsibo ismenquio yec matses nibëdacno choac caoshe. Isnu. Nid,” cac istanenda. Adembidi: “Choash nëid shubun puduedac caoshe. Isnu. Nid,” cac adembidi istanenda. Muambo neque. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ëbimbo padpidec choquimbimbi abitedimbo ismendac. Abu ushëmbo yec bed-bedquetanesho ¿ada matsesën abitedishunquio isenquio icpadic? Ai, isec. Adembidi ëbi choasho matses abitedishunquio isendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Adec choendabi. ¿Ada edeste pisen chec budenquio icpadic? Ai, budec. Adecbidi Nuquin Papan cuidte ushë chonoc choendabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Adashic padpiden chiec: —Aden matses icsamboshë icquidon ëbi tantiaquido natiamenubi ushë chënquenquio yanendac. Inchëshën ushëtsen chënquenquio yanendac. Uispa chedo paëdbudnendac. Uispabimboecquid abitedimbo uëdëquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Adnubini abitedishun Icbo yec dacuëdampambo yec abucuësh choendac. Ëbi nadatiambo icquin nabanquidquio yec chosho isash cuidadtequido abitedimbo dacuëdec natiaic shubiquiendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Adnuc nua shoncanubimbi Nuquin Papan abi yacnoshon uaido mayan bëdabo: “Bedtan,” caindac. Adoac nidaid utsi-utsiec yacno nidshun ëbi tantiaquido abitedimbo bedtanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ëmbi chuibocpadquiec yansho isun: “Esus chote nëbi nec,” quequin tantiata. ¿Mitsipaden: “Seta taëec,” quequin tantiapec? Suc seccuduquiaid isun: “Nëbi seta taëec,” quequin tantiaquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Adembidi ëmbi chuiboed isun: “Nëbimbobi Esus choec,” quequin tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","¿Muectabi nedi? Ëmbi chuibocpadquio iquendac. Ëmbi chiacpadec yanabi matses abitedi nibëdantiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Abimbo caimbi. Abu nibëdanendac. Nidaidtsen nibëdanendac. Padnuen ëmbi chuiboedquio nibëdantiapimbo iquendac. Bënudenquio iquendac. Ucudtiapimbo iquendac. Ëmbi chuibocpadquio iquendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Adashic abi onquec Esus: —Ëbi chote tantienquio iquembi. “Aid ushënquio choendabi,” quetiapimbo iquebi. Adembidi mayan bëdabon tantienquio iquec. Ëmbibi Nuquin Papan Madonquiobi tantienquio iquembi. Nuquin Papanuidtsëquien tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Matses ëbi caic: “Nëbi choec,” quetiapimbo icnuc choendabi. Noen cano nacnenubi ¿mitsipaden aton matses icsambo icquidon tantiapampic? ");
INSERT INTO mcfNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nidaid abichobi mauanabi icnuc: “Nuquin Papan nuqui cuidendac,” quequin tantienquio icquin peshun acquinc aton chido bedquinc aton champi bedmequinc capampic. Adnubien Noe Nuquin Papan chiacpadomboen cano dapa anshubu uaquin nacnenash puduedpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aton matses: “Nëbimbobini Nuquin Papan cuidchitec,” quenquio icnubi ue dapambo choec mauanquidën matses abitedimbo unësbudnepampic Noe ambi cano anshubu uaidën nuadtonobi. Adecbidi Nuquin Papan cuidtequido ëbi caic: “Choec,” quenquio icnubini choendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Choquin Nuquin Papa yacno tabadmenuen beduamendambi. Ëmbi: “Bedtan,” cac tied nantan dada daëd icsho istuidshun ëbi tantiaquid abentsëc icsho beduanendac. Utsibic ëbi tantiesa icsho nianendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Adembidi Nuquin Papa yacno tabadmenuen chido daëdshun macueso istuidshun abentsëc ëbi tantiaquid icsho aid abentsëc beduanendac. Chido utsibic ëbi tantiesa icsho nianendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aden ëmbi chuiboed tantiashun: “¿Nëbida con Icbo chopeba?” quequin ënenquio icquin tantiata. Ëbi chote mimbi tantienquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","¿“Nëbi ampequidën ampec,” quequinda tantiapadic? Padenquio. Tantiaquidënquien aid ushënquio aton na bëdamboen isquin ampemenquio ictsiash. Aden tantienquio icquin: “Ampesho isnu,” quequin ënenquio icquin isquid. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Adembidi ëbi chote ushë mimbi tantienquio ye. ¿“Nëbida nuquin Icbo chopeba?” quec Nuquin Papabëd tabadte bunec bëdamboec tabadta. Matses dadpen: “Nëbien chochitec,” quenquio icnubini choendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Adshumbic abi bëdamboen cainte Esusën chuipondash. —Tantia. Aton icbo tantiaquin yua bëdambo icquidën naid mibi chuinu. Icbon: “Ëbi nidan mibëdta yuaido pete sandoaid musucshun ëmbi chiacpadën ëmbi chiacpadënquien menianeta,” cac yua bëdambo icquidën adotsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Adnubien icbon choshon ambi chiacpadomboen yuan nasho isun bëdamboen istsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Adshumbic aton yua chuitsiash. “Bëdamboen tantiaquid mibi neque. Con yua utsibo namequin con natedi dayun uata,” catsiash icbon yua bëdambo icquid caquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Padnuen yua icsambo icquid: “Ëndenquimbo con icbo nidondash. Choenquien icchitec. Con nauidi nanu,” ");
INSERT INTO mcfNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","quiampatsiash. Adshumbic chieshtoshon abëdta yuaido cuesanetsiash. Adashic icsambo icquidobëdi icsamboec tabadtsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Adec: “¿Nëbida con icbo chopeba?” quenquio icnubien aton icbo chotsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Choshon ambi chiacpadomboen nainquio icsho istuidshumbic: “Icsambo iquec,” queshun comapenen cuesquin cuesunetsiash. Adembidi Nuquin Papan icsambo icquido cuidendac. Bëdambo icquid damianquido cuidacno icsamboshë yacno nidmendac. Adoac natiaic shubiquiendac —quequin abi bëdamboen cainte Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Adshumbic Esusën ompoacbimboen chuiquin abi chote ushë tantienquio icte chuipondash. —Tantia. Mibi chuinu. Nuquin matses isadaidbon nacpadomboen chido bednuequid aton chido bedtanec inchëshëmbi chosho aton matsesën bëquedtanquid. Bëquedtanec choec shubun puduedash cuishonquec aidbëd pec tabadquid. Adquido icpac caondash. Chido 10tedishun: “Champi bedtanec choquid bëquedtanu,” queshun aton tabote bëchin taboadquid icbo-icboen buanuen sanambededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aid chido 5tedi tantienquio icquido icnubi 5tedbidi bëdamboen tantiaquido icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tantienquio icquidon: “Tabote bëchi naimëdsho cushtonon buanu,” quenquio icquin bëchi uesadbudtsaid taboteuidtsëqui sananquin caimpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Padnuen bëdamboen tantiaquidon naimëdsho cushtonoequin tabotebëdta sedunten cushtoaid bëchi sananquin caimpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aden cainaqui: “Chido bedtanu,” quianec nidboed choenquio icsho isash abitedi ushcastoash ushcuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Inchësh poctsemboen: “Choeque. Bëquednu. Nid,” cac ");
INSERT INTO mcfNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","isucunshun chidobon tabonoen tabote dëbedpac caondash. Adoshon bëdamboen tantiaquidon ambi bëboed bëchi cushtonobien ");
INSERT INTO mcfNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","icsamboen tantiaquidon: “Bëchi beccho. Con na naimëdeque,” caquien bëchi bëboedën ");
INSERT INTO mcfNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","bëdamboen tantiaquidon: “Padi. Mibi meniac con na uesadtsiash. Aid uesadan shubun puduedabi nuquitedi inchështsiac. Piucquid menequin bëchi cushtoquid baded cushtometan,” capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Adoac bëchi bedec nidnubien chido bedtanec dada chopac caondash. Chosho bëdamboen tantiaquidon aton tabote taboshon chido bedtanec choquid bëquedtampac caondash. Adtanec abëdi choash puduedshun bëtashte puduedtiapimbo icnuc bëdamboen bëtashpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Adnubien bëdamboen tantienquio icquido bëchi bedtanec chopac caondash. Choshon shëcuë bëtashacsho isun: “Shëcuë shëcne, buchi. Ëbitsen puduednu,” ");
INSERT INTO mcfNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","caquien chido bedquid: “Padi. Ëmbi tantiacmaido mibi nec,” quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ëmbi chuiboed tantiashun chido icsamboen tantiaquido tanenda. Bëdamboen nabi icsho: “Ëmbi tantiacmaid mibi neque. Puduedenda,” aido cacbimboen ëmbitsen Nuquin Papa yacno puduedmenquio icquin cacumechitomane. Ëbi chote ushë tantiadenquio icnuc: “¿Nëbida con Icbo chopeba?” quequin ëbi bëdamboen tantiec ëmbi chiacpadec bëdamboec tabadta —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Adshumbic abi tantiaquidon ambi chiacpadomboen nate Esusën ompoacbimboen chuioapondash. Ënapen nidnun aton piucquid dadpen dayun uaquidën aton yuabo: “Ëbi piucquid daëd uashunta,” quequin chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Nëidën bëdamboen tantiaquidquio icquin con piucquid ëbi daëd uashuntsiash,” queshun aton yua piucquid 5tedi meniac caondash. Adshumbic: “Nëidëntsen bëdamboen tantiaquin adembidi con piucquid ëbi daëd uashuntsiash,” queshun utsitsen 2tedi menepac caondash. Adshumbic: “Nëidëntsen bëdiactsëc tantiatsëcquin adembidi ëbi con piucquid daëd uashuntsëctsiash,” queshun utsitsen piucquid abentsëcquiobi menetsac caondash. Adanec nidpac caondash icbo. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Adnubien piucquid 5tedi bedboedën aton matsesën nacpadomboen piucquid daëd uanuen utsibo menequin yuecshun ambi meneboed udictsëc dëniacquin bedoapac caondash. Sincoted icboedi 5tedbidi bedoapac caondash 10ted icnuc. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Adembidi piucquid 2ted meneboedën 2bidi daëd uapac caondash 4tedi icnuc. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Padnuen abentsëc meneboedën chieshquin aid daëd uainquio icquin ambi uëdëshcaboed shëcuë anantsëcquin piucquid abentsëqui ompopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yuecquio ictaneshumbien icbon choshon ambi piucquid meniondaido chuituidpac caondash. “¿Atotsi nao?” cac ");
INSERT INTO mcfNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","sincoted meniondaidën: “Is, icbo. Mimbi ëbi meniondaidtedbidi daëd uaombi. Nëbi mitsana 10tedi iquec,” caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","icbon: “Ai, con na daëdpactsëc icboedi daëd uaquin mimbi bëdamboen nac. Nëbi ëbëdtan chuiquid dapa icta. Ëbëd cuishonquec tabadec cho,” capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Adnubien piucquid 2tedi meniondaidën: “Is, icbo. Mimbi meniondaid 2ted icboedi daëd uaondambique. Nëbi mitsana 4tedi iquec,” caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","icbon: “Ai, ëmbi chiacpadomboen mimbi con na daëd uac. Nëbi ëbëdtan chuiquid icta. Mibitsen ëbëd cuishonquec tabadec cho,” capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Adnubien piucquid abentsëcquiobi meniondaidën chieshquidëntsen: “Mimbi ancaidon nidtsinaid peteuidi bedquid mibi nec, icbo. Mimbi chiacpadomboen nainquio icsho isash chushcanquidquio mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Adec dacuëdampambo icquid icsho mibi dacuëdënquin mimbi meniondaid piucquid ompoquin chococaondambi. Në mimbi meniondaiduidtsëqui ictsec,” caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","icbon: “Chieshquiec mibi icsac. Ëmbi chiacpadomboen nambo mimbi iquec. Ëbi caic: ‘Ancanquid icquin ëbi chushcanushe,’ queshun ");
INSERT INTO mcfNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nuquin matsesën nacpadomboen utsibo meneshun piucquid daëd uaquin mimbi bedtsempac. Adoacsho aid daëd uaquin bedtsenombi. Chieshquin mimbi icsamboen nac,” ");
INSERT INTO mcfNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","quepac caondash. Adshun aton yua utsi caic: “Chieshquidën na bedshunshun piucquid 10ted dayun uatsëcboed mene,” cac meniac 10ted icboedi 11ted yanac caondash. Adshumbic chieshquid comapenen cuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Adembidi naindambi. Ëbi tantiaquin ëmbi chiacpadomboen naquid adembidi namequin bëdamboen tantiamendambi. Ëbi tantiesabo ëmbi chiaid niacquid bëdamboen tantiamenquio iquendambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aid yua icsambo icquid cuidacbimboen Nuquin Papan ëbi tantiesabo cuidquiendac. Ambi icsaido cuidquiacno nësecac natiaic shubiquiendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Adshumbic Esusën padpiden chuipondash. —Nuquin Papan abi yacnoshon uaido mayan bëdabobëd choec: “Abitedishun Icbomboeni nec,” quiash bëchamauampamboec dacuëdampamboec choequi chuiquid dapan tsadten tsadtoquin abitedi ismendambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Adshumbic matses abitedimbo cho-chomequin tsidadmendambi. Adshumbic icbon aton nauidquio tsinacacbimboen ëbi tantiaquido naden chiendambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","“Ëbëd tabadtequido mibi neque. Nëmbo con abiuc tabadec cho,” caindambi. Adshumbic ëbi tantiesabo chuiquin: “Ëbi tantiesabo cuidadtequido mibi neque. Con copioc tabadec cho,” caindambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Adshumbic ëbi tantiaquido padpiden chuioaindambi. “Ëbëdi tabadec cho. Matses uaquin tauabi ëndenquimboshë mibi caic: ‘Aido ëbi tantiaquido icmeshun ëbëdi tabadmendambi,’ quequin Nuquin Papan tantiaidombo yec ëbëdi bëdamboec tabadec cho. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mimbi ëbi nashundenec. Bundoacsho mimbi ëbi pemedenec. Acte bundoacsho adembidi mimbi ëbi acmedenec. Mimbi isacmaidquio icsho mimbi ëbi yuedtenec. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Con dashcute nibëdsho mimbi ëbi dashcute menedenec. Daicsabudtsash unëstiadtsëcquio icsho ëbi tantiec mibi datsadtenec. Quënën nauedacsho mimbi ëbi isuan-isuandenec,” caindambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Adoaquien bëdamboec tabadquido: “Tantiadenquio icnuc mimbi chuipec, icbo. ¿Bundoacshodambi mibi pemedionda? Mambi mibi pemiambo yoc. Mambi mibi acte bundoacsho acmiambo yoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ëmbi isacmaidquio icshodambi mibi yuedtionda? Mambi padambo yoc. ¿Dashcute nibëdshodambi mibi dashcute menepacti? Mambi padambo yoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mibi daicsacsho datsadambo iquebi. Quënën nauedacsho mibi istaniambo iquembi. Mimbi tantiadenquio icnuc chuipec,” ëbi caindac. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Adoac naden chiendambi. “Tantia. Mibi chuinu. Ëmbi chiacpadomboen ëbi tantiaquido utsibo bëdamboen isquin mimbi nashundenec. Aden ëbibi nashunacbimboen mimbi utsibo nashundeneque. Ëbëdi tabadec cho,” caindambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Adoshombic ëbi tantiesabotsen chiendambi. “Nuquin Papan cuidtequido mibi neque. Mibi icsaid ënte bunenquio icquid mibi neque. Nuquin Papan Satanas aton yuabo podobitsi icsabobëdta ënenquio icquin cuidacno nid. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ëmbi chiacpadomboen ëbi tantiaquido nashunesambo mibi icteneque. Bundoacsho mimbi ëbi pemenquio ictenec. Acte bundoacsho mimbi ëbi acmenquio ictenec. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mimbi isacmaid icsho mimbi ëbi cacumedenec. Dashcute nibëdsho mimbi ëbi menenquio ictenec. Daicsacsho isash mibi ëbi datsadenquio ictenec. Quënën nauedacsho mimbi ëbi istanenquio ictenec,” caindambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aden chiaquien: “Tantiadenquio icnuc mimbi chiec. ‘Pete bundopash,’ quequin tantienquio iccondambi. ‘Acte bundopash,’ quequin tantienquio iccondambi. Ëmbi isacmaid icsho mambi mibi isambo yoc. ¿Min dashcute nibëdshodambi mibi istionda? Mambi padambo yoc. Mambi mibi daicsacsho isambo yoc. Mibi quënën nauedaid tantiambo iccondambi. Tantiadenquio icnuc mimbi chuipec,” caindabi ëmbi chiacpadomboen naisabon. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Adoac naden chiendambi. “Ëbi tantiaquido nashunenquio icquin ëbibi nashunenquio yacbimboen ëmbi chiacpadomboen naisabo mibi neque. Nuquin Papan cuidacno nid,” caindambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Adoac icsamboec tabadquido ënenquio icquin cuidacnombo nidnubi bëdamboec tabadquido Nuquin Papa yacno ënëdenquio yec tabadendac —quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aden abi chote ënquin chuitanquimbic abi unës uatetsen abëd icquido Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Daëdec ushun nuquin matsesën obeca bacuë unës uaindac. Tsusedpabon: “Ma con mado unës uainquio icnu,” queshun obeca bacuë abided unës uampid tantiaquin badiadshun penun obeca bacuë unës uaindac. Aid ushëmbi ëbi bedshun cuesten dectamendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Adnubien tsusiobobëdi con matses chuiquid dapa dadpen abi chuiquid dapambo Caipas cuëmëdquidën shubun pudued-puduedpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Adashic: —Nëbien Esus unës uametiad utsibo ismenquio icquin bedshun. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nuquin matses obeca pec tabadnuc bedenquien ictiad. “Esus bëdambo icquidi cuesunec,” queshun obeca penuec cho-choquidon nuqui cuesnushe —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Adnubien Esus shubu dadpen icquid Betania caid yacno choash ambi daushumbo yec daicsaid bëdamiondaid Simon caidën shubun puduedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Puduedshun pec samëdshobien chidon puduedshun ambi piucquid dadpenquio menequin bedaid tëchumpin icquid bëdambo nuadquid Esus machiuimpondash: —Esus bëdamboshë icquid nec —queshun. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Adsho isumbien Esusbëd icquidon: —¿Adenda bëdamboen nai? Ma icsambo yoc. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Utsibo menequin dadpen piucquid bedshun piucquid nibëdquido aid piucquid menetiadquidi mibi nec —quequin chido chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Adsho tantiashumbien Esusën: —¿Atotsieshun chido chushcai? Ëbi bëdamboen tantiaquin ëbi ismequin bëdamboen nashunebique. Chushcainda. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mimbi chuiboed piucquid nibëdquido ënëdenquio yec mibëdi tabadendac. Ëbien mibëdi tabadenquio yanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ëbi unës uashun chococate tantiacbimboen machiuinoshibique. Chushcainda. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ëmbi chiaid chuibeniacnoshon nëid chidon ëbi machiuimboed chiendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Adnubien Udas Iscadiote caid Esusbëd icboedi Esus chieshënquido chuiquid dapabo chiec nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nidshumbic chuituidpac caondash. —Utsibo ismenquio icquin mibiuidtsëqui Esus bedmenu. ¿Tedtsi piucquid ëbi menetsia? —caquien badedi pudunquin piucquid shocoshëmpi 30ted icnuc tambantanquin menepac caondash: —Baded ëbi bedme —quequin. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Meniac bedanec nidec: —¿Mitsishunquiembi utsibo ismenquio icquin Esus bedmepeba? —quepanëdash Udas. Adashic Esusbëdi tabadoaic chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Adnubien Esusbëd icquidon: —Equipito yacnuësh cuenun pan bidiscamiabi yampid 7tedec ushquin tantiaquin tauaid ushë nëid nec —queshun Esus chuipondash. —Nuquin Papan nuquin tsusedpabo unës uamenquio icquin matamiampid inchësh tantiaquin obeca bacuë penuen ¿mitsishunquiembi mibi codocashumpe? —caquien Esusën: ");
INSERT INTO mcfNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Edusaden yacno nidshun ëmbi tantiaid dada chiec nid. “Nuquin Icbon: ‘Chiec nid,’ cac chobi. ‘Nëbi Nuquin Papan chiacpadomboen uesquin nabanembi,’ quiosh. Min shubumbo caic: ‘Aidën shubun puduedshun Nuquin Papan nampid tantiaquin obeca bacuë pec tabadcuedednu,’ quiosh,” quequin chiec nid ");
INSERT INTO mcfNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","—cac nidquimbi shubu icbo chuituidac caondash. Adoac: —Ai, ma chobono —quesho tantiashumbien abia nidboedon aidën shubun puduedshun penuen nëish yua obeca codocapaccondash. Adnubien Esus chedo puduedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Inchëshëmbi abëd icquido 12tedbëd samëdquin Esusën pepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pec samëdquin Esusën chuipondash. —Tantia. Mibi chuinu. Ëbi chieshënquido ëbi bedmequid abentsëc nëmbobi iquec —quesho tantiashun ");
INSERT INTO mcfNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","unësquio yanshun abentsëcshun abentsëcshunquien Esus chuipondash abëd icquidon. —¿Ëbida cai, Icbo? —quequin abi chuishobien ");
INSERT INTO mcfNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Esusën: —Ëbëdtan pete codocaid ënë punquid ëbi bedmequid nendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ëbi Nuquin Papan chiaid dada uamepampicpadquid matsesmiaid yec unësendabi. Padnuen ëbi bedmequid comapenen cuidtequidquio nec. Anin aid tishenquio icpatecnëdan. Cuidac natiaquiendac —quepondash Udas caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Adoaquien Udasën abi bedmequidënquio: —¿Ëbida cai, Icbo? —caquien: —Ai, mibibimbi caic —capondash. Adoac Udas puduenanec nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Adshumbic Esusën pete sananquin: —Mimbi pete uaid nëid nec. Mibi bëdambo iquec, Papa —quequin Nuquin Papa chuitanquin cuësh-cuëshbanshun abëd icquido menebampondash. —Nëid cuësh-cuëshquin nibëdamiacbimboen ëbi mëyanquin unës uaindac. Ëbi unës uate tantiaquin nëid peta —cac pebededtsëccondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Adshumbien Esusën dëshoten actequid cushtoshon sananquin: —Mimbi uaid nëid nec. Mibi bëdambo iquec, Papa —quequin Nuquin Papa chuishun: —Nëid abitedishun acbeded —cac dëshoten abentsen cushtoaid pictsë-pictsen acbampondambi. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aid actequid acshobien Esusën: —Nuquin Papan chiaid nuquin tsusedpan dada uapampicpadec ëbided cuidadec unësendabi. Nëid acquin: “Esusded Nuquin Papan cuidac aton intac siebudpamboec unësposh. Aton Madoded cuidshun Nuquin Papan ëbi padenquio iquec,” quequin nëid acquin tantiata —capondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Adashic: —Nadquid actequid padpiden aquec cuishonquec mibëd tabadenquio iquendabi. Nuquin Papan abitedishun Icbombo icmiac abi yacnombo mibëdi cuishonquec tabadendabi —quepondash Esus ëbi chedo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Adashic cuëdënten abentsec cuëdënash macuësh dapa Odibos caid pudundonoec nidanepondash Esus Udas Esus chieshënquido chiec nidbon. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Macuësh dapa Odibos caid yacno nidquimbi Esusën chuipondashi. —Nëid inchëshëmbi Nuquin Papan chiacpadec ëbi nianec mibitedi niquendac. Nuquin Papan naden chuipampic. “ ‘Icbo cuesnu,’ canubi aton yuabo niquendac,” quequin Nuquin Papan dada uamepampicpadec mibitedi adec niquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Padnueni unësash uincuenendac. Adanec mibi cainuec nidaid cuëshë utsi Cadidia caid yacno ëbia nidendabi —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Adoaquien Petedo: —Mibi cuesnuec cho-chosho isash utsibo dacuëdec niquenuc ëbimboen cuenenquimbo ictsiandac —queshobien ");
INSERT INTO mcfNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Esusën: —Tantia. Mibi chuinu. Nëid inchëshëmbi cachina bënë cuëdanabi icnuc: “Ëmbi isacmaidquio aidi nec,” mimbi ëbi caindac. Cachina bënë cuëdanabi icnuc 3tedec mibi adendac —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petedo: —Pada. Adtiapimboeni iquec. Chieshëmënquidon: “Esusbëd icquid mibi neque. Mibi cuesunenu,” caqui: “Ëmbi isacmaid neque. Padi,” quenquio iquendabi. Mibëdquiobi unëstsiandabi —Petedo quenubini: —Ai, ëbibic adecbidi ictsiac —quecuededpondabi Esusbëd icquidotedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Adanec nidequi cuëte dadpen nitsinacno Quetsemani yacno nidpondash. Auëshquio Esus nadpondash. —Ambobi tabadta. Udictsëc nidshun Nuquin Papa chuitanu —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Adashic Petedobëdta Sebedeyon mado daëd buanec nidpondash. Udictsëc nidequi unësquio yanec shubiantiadtsëcquio yampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Adshumbic Petedo chiec: —“Matsestedi icsaid ëmbi bedshunsho isun Nuquin Papan ëbi istiapimbo yanendac,” quiash unësquio iquebi. Ëbi yacpadec ushenquio yec nëmbobi isec tabadta —quianec ");
INSERT INTO mcfNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","udictsëc nidash nidaidën uebudshun Nuquin Papa chuipac caondash. —¿Ada mimbi ëbi unës uamenquio icpatsia, Papa? Mimbi: “Ai, mibi unës uamenquio iquembi,” cac bëdambo ictsiabi. Mimbi: “Nëbi mibi unës uamenu,” cac mimbi tantiacpadequi unësendabi —quepac caondash Esus Nuquin Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Adtanec choshon isquien Petedo chedo ushpec: —Ushenquio yec isequi tabadta —caboqui. —¿Yuec-yuecpactsec ushenquio icquin istiapimboda icco? ");
INSERT INTO mcfNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Satanasën icsamenushe,” queshun ushenquio icquin Nuquin Papa chuita. “Ushenquio iquebi,” queboedobi ushcas mëmunenquio yec mibi ushpec —capac caondash Esusën Petedo chedo chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Adtanec padpidec nidoashun Nuquin Papa chuioaic: —Ëbi unës uametiadquio icquin ëbi unës uameta, Papa. Ëbi unës uametiapimbo icquin mimbi ëbi unës uamenquio ictsiac. Mimbi tantiacpadomboen nata, Papa —quetanec ");
INSERT INTO mcfNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","choaquin isquien Petedo chedo ushoaic ushcas mëmuntiapimbo yec. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Adsho istanec nidoashun ambi chuibocpadomboembidi Esusën Nuquin Papa chuitanepac caondash tedesteden. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Adtanec choaquin ushash uesho istuidoashun: —¿Ushecta ue? Nëbimbobi ëbi unës uamenuen ëbëd icboedëmbi icsambo icquido ëbi bedmeque. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nidnu nid. Is. Ëbi bedmenuec ëbi bedmequid choeque —quepondash Esus Udas chosho isash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Adnubien Udasën Esusbëd icboedën bedtanac matses dadpen cuesantiadpambo yec chështebëdta cueste sanambededtsëcquiec cho-chopondash. Nëish yua abided unës uaquido chuiquid dapabobëdtan con matses tsusiobon: —Bedtan —cac cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ambi bedtanaidobëd cho-choquimbien Udasën: —“Nëid Esus nec,” quequin adoendambi —abi quiacpadembi ");
INSERT INTO mcfNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Esus tansudcatuidpondash: —Chobi, Icbo —quequin. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Adoaquien Esusën: —Ëmbi tantiaboedquio mibi nec. Ëmbi adoboedënquiobi mimbi tantiacpadomboen nata —queshobien cho-choquidon Esus bedtuidpondash. Aden bedshun: —Cuidmenun chuiquid dapa yacno mibi buanu —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aden Esus bedshobien abëd icquidën abi tsiusudaid chështe chictanquin chuiquid dapan yua pateshunepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Adoshobien Esusën: —Padi. Chën. Min chështe tsiusudoata. Cuesanquid icsho adembidi cuidnushe. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tantienquioda ique? Ëmbi chiac con Pan ambi abi yacnoshon uaido mayan bëdabo dadpenquioshë ëbi cudasmenuen chometsiash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nuquin Papan aden ëbi cudasmiac bedadtiapimbo icsho ¿mitsipaden Nuquin Papan chuiquin dada uamiampicpadomboen ëbi naden bedpatsiash? —capondash pateshunianquid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Adashic abi bedquido chiec: —¿Atotsi quenuec chështebëdta cueste sanambededtsëcquiec ëbi bednuec cho? ¿Nuqui chuiquid dapan chiaid niac-niacquin matses cuesanquido chuiquid dapadabi nedi? Mabi mimbi isboedquiobi neyoc. Badiadquidën badiadquidënquien Nuquin Papa tabadte shubu uashunaid daquënë uaidën puduedshun chuideneshobi ma mimbi ëbi bedenquio icboc. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Padenquio icboedombi Nuquin Papan tantiacpadënquiobi mimbi ëbi bedec. Ëbi bedte chuiquin Nuquin Papan nuquin tsusedpa dada uamiampicpadomboen mimbi ëbi bedec —quequin Esusën chuinubini niquepondac: —Cuenenquio ictsiabi —queboedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Adnubien chuiquid dapambo Caipas cuëmëdquid yacno Moisesën dada uampid chuibanquidobëdi tsusio utsibo cho-chopac caondash. Adnubien ambobi Esus bëpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Adnubien Petedo uanoshon isbëec tsyuec chopac caondash. Choash chuiquid dapabo tabadacno daquënë uaidën puduedpac caondash. Adashic Esus mëyansho isnuec puduedash chuiquid dapan namiaido sondadobëdi tsadtuidpac caondash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Adnubien cho-choboedo tsusio dapabo: —Esus unës uamenuen: “Esus icsasho isombi,” quequin muaquidon chuisho tantianuna —queshun chomiac muaquido dadpenshun: —Esusën icsamboen nasho isombi —quequin chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aden Esusën naid muaquin chuiquin Esus unës uatiadquio icquid chiambo icpac caondash. Adnubien muaquid daëdshun chuituidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Nuquin Papa tabadte shubu uashunaid caic: “Uesquin chic-chictanquin padpiden nacnenoaquin daëdec ushquin nainendambi,” ma Esus quepondac —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Adshobien chuiquid dapabo chuiquidën Esus chuiquin: —¿Atotsi quenuec ado? ¿Atotsi nëidën chiec? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Esusën ëcbedenquio icpac caondash. Adshobien chuiquid dapan: —Abimbo chuita. “Nuquin Papan cuidchitoshe,” queshun abimbo cata. ¿Nuquin Papan chomiaidquio aton Madombobida mibi nepe? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Esusën: —Ai, mimbi chiaidquio nebi. Tantia. Mibitedi chuinu. Nuquin Papan abitedishun Icbombo icmiacshobini mimbi isendac. Adecbidi Nuquin Papa yacnuësh padpidec choec abu ushu yacnuësh choshobini mimbi isendac —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Adsho tantiash chuiquid dapambo chieshtotanquin aton dashcute bëntse icquid dached-dachedquepac caondash. —¿Ada tantio? “Nuquin Papan Madombobi nebi,” quequin Nuquin Papambo icsamboen chiec muaposh. Ambi icsamboen naid utsi chuisho tantiatiapimbo iquebi. Ambibi Nuquin Papa muauasho tantiashun ");
INSERT INTO mcfNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Atotsi natiadquio ique? —caquien abëdtan chuiquid utsibo: —Adquid cuidquid quedeneque. Unës uamequimbien ictiad —quecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Adshumbien Esus chieshënquin bëcuishtuabudnetanquin mëshëbudtanquin mëdanten bëse-bësepac caondash. Bëse-bësesho istanquin utsibontsen istiapimbo icnuc Esus dashcuten bëpuctanquin mëdanten bëcues-bëcuespac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bëcuestanquin: —“Nuquin Papan madombobien nec,” canu. En chui. Tantianu. ¿Tsundan mibi naoshe? —cabededtsëcquien mamënshumpac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Adnubien Petedo tabadacno choshon chido yuan chuituidpac caondash. —Cadidia yacnocquid Esus caidbëd ma mibi icpaboc —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Tantiadenquio icnuc mimbi chiec. Ëmbi isacmaidquio mimbi chiec —quec Petedo muaic taëpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Adanec daquënë uaidën puduedte shëcuë dayun nidash nidtuidpac caondash. Adshobien chido yua utsin: —Nasaded yacnocquid Esusbëd ma nëid icpaboc —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petedo: —Ma ëmbi isacmaidquio Esus neyoc. Abimbo caimbi. Nuquin Papan cuidchitoshe muasho —queoapac caondash muequi. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Adash yuec-yuecpactsëcshumbien ambo tabadquidontsen Petedo chuipac caondash. —Aidbëd icquidien mibi nec. Cadidia yacnocquid onquiacbimboec ma mibi onquepayoc —quesho tantiash ");
INSERT INTO mcfNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petedo: —Comapenen Nuquin Papan cuidchitoshe muasho. Abimbo caimbi. Ma ëmbi isacmaidquio neyoc —queoapac caondash. Adec 3tedec Petedo muanubien cachina bënë cuëdampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Adsho tantiashun Petedon Esusën chuiboedquio tantiactampac caondash. —Cachina bënë cuëdanabi icnuc mimbi ëbi caic: “Ëmbi isacmaid nec,” capendac tedesteden —quequin Esusën chuiboedquio tantiactanec umanuc puduenanec nidec Esus muauabosh natiaic shubinidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Adnubien chuiquid dapabo aton tsusio utsibobëdi Esus isec ushenquio badiadpondash. Badiadshun Esus chieshënquin: —Nuqui yuaquid ancanquid Esus unës uamec nidnu. Nid —queshun ");
INSERT INTO mcfNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","podo cataneshun ancanquid Pidato cuëmëdquid ismenuen Esus buampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Adnubien Udas Esus bedmeboed: —Unës uamechitembien iquec. Unës uametiapimbo iquebi. Ëmbi bedboed piucquid shocoshëmpi 30ted meneoatanu —quianec abi meneboed tsusiobo menenuec nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nidshun tsusiobo chuituidpac caondash. —Icsachitobi. Unës uanuequido bëdambo icquidi bedmechitombi. Nëid mimbi meneboed mibi menenuec chobi. Në bed —caquien tsusiobo: —Padi. ¿Atotsieshun nai? Ma mimbi bedmepaboc —quepac caondash Udas caic. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Adoaquien Nuquin Papa tabadte shubu uashunaid shëcuën ambi bedboed shocoshëmpi piucquid ansecanec nidash uano cuenash tëtaniadpac caondash Udas. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aden piucquid shocoshëmpi ansecacsho bedashien tsusio dapabo: —Nuqui dayun uaid shocosh utsibëdta dayun uatiapimbo iquec. Unës uanuen meniaid shocoshëmpi dayun uatemaid quedeneque. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Matsu nacnenquidën tied bedquin nëid menenuna. Nuquin matsespenquio isedquido unësacsho ambo chococanun aid tied bednuna —queshun piucquid meniac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aidon bedacsho isun nëbi aid tied cuënquin nadopec. —Unës uamequidën bedaid tied nec —capec. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aden Udasën shocoshëmpi 30ted menete nuquin tsusedpa Edemias caidën dada uapampicpaden napac caondash. Naden dada uapampic. “ ‘Aid bednuen Isadaidbon piucquid shocoshëmpi 30ted meneuidaid bedoashun ");
INSERT INTO mcfNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","matsu nacnenquidën tied bedquin meneoapondash,’ quequin Nuquin Papan chiaid dada uaombi,” quepampic Edemias. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Adnubien isadaidbo yuaquid ancanquid Pidaton Esus bëacsho chuipac caondash. —¿Min matses isadaidbo chuiquid dapamboda mibi nepe? —caquien Esusën: —Ai, aid nebi —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Adnubien abi chieshënquidon muaquin Esusën naid Pidato chuipac caondash. Adsho tantiashun Esusën ëcbedenquio icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Adshobien Pidaton Esus padpiden chuioaquin: —Mibi icsaid dadpen chuipec. ¿Tantienquioda ique? ¿Ëcbedantiapimboda ique? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ëcbedenquio icpac caondash Esusën. —Nëidon muauac nebi —quequin chienquio icsho tantiash: —Adquid tantiambo iquembi —quepac caondash Pidato. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nuquin Papan isadaidbo unës uainquio icquin matamiampid tantiate ushëmbi seta utsin-utsinquien Pidaton quënën nauedaid isadaidbo abentsëc cuemedenec. Pidaton: —¿Tsutsi abentsëquimbi cuemepe? —cac isadaidbon chiacpadquid abentsëc cuemedenec. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Esus bëabi icnuc uimanëmënquidquio Badabas cuëmëdquid nauedpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Adnubien Esus cuidte chuisho tantianuec cho-choash dadpenquio tabadpondash. Adsho isumbien Pidaton: —¿Tsutsi abentsëquimbi cuemepe? ¿Badabastambi cuemepe? ¿Nëbi mimbi bëboed Esus Quidistu caidtambi cuemepe? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","—Esus chieshënquidon: “Nuqui padenquio yanuc nuqui dëniaquec Esus chuiquid dapa yanushe,” queshun Esus bëaccosh. Nëmbo tabadquidon: “Esusquio cueme,” capashuni —quequin tantiaquin aden chuipanëdash Pidaton. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Adashic matses icsaido cuidte chuinuec tsadte dapan abucquio tsadtopondash Pidato. Adshobien yuan chuituidpondash. —Min chidon: “Chuitan,” cac chobi. Esus caic: “ ‘Aid dada bëdambo icquid neque. Unës uamenda. Dacuëdampambo icsho ushquin isombique. Unës uamenda, quiosh’ quequin chuitan,” min chidon cac chobi mibi chiec —quequin aton yuan chuituidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Adnubien Esus chieshënquido tsusiobon ambo tabadquido chuibudpondash. —Pidaton: “¿Mitsicquidimbi cuemepe?” cac: “Badabas cuemequin Esus unës ua,” cado-cadota —cac: —Ai, adoendambi —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Adnubien Pidaton padpiden: —¿Mitsicquidimbi cuemepe? —caquien ambo tabadquidon: —Badabas cuemeta —cadonepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Adoaquien Pidaton: —Ma Esus Quidistu caid. ¿Mitsipadopembimbi aid ique? —caquien: —Unës ua. Cuesten dectanquin unës ua —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Adoaquien Pidaton: —¿Atotsieshun mimbi adope? ¿Atotsi icsa uasho mimbi adope? —caquien buëdanquiec cuëdec: —Cuesten dectanquin unës ua —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Adsho —Padi icnuna —caqui niacbidanquiec adequi unës uate bunquiec cuesantiadpambo yansho isash: —Acte beccho —quepondash Pidato. Bëacsho tasun dapan cushtotanec mëpamëdquin abitedi ismepondash. Adashic Esus caic: —Nëid unës uametiapimbo iquebi. Nëid unës uamete bunec mibien cuidadtequidombo nendac. Ëmbien adotiapimbo iquec. Mëpamëdec bëchish ucudacbimboec mimbi icsamiaid ucudebi —quiash mëpamëdquin ismepondash Pidaton. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Adsho tantiashien: —Con nabobëdtsëqui adequi cuidadtequidombo icnuna —quecuededpondash abitedimbo. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Adsho tantiashun Badabas caid cuemequin Esus cueshcaten cueshcamepac caondash. Adshumbic: —Cuesten dectanquin unës uatan —quequin sondado buamepac caondash Pidaton. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Adoaquien sondadon Pidaton shubun Esus yuedshun: —Isec cho —cac aton sondado utsibo dadpen cho-chopac caondash. Cho-choshon Esus mamënshumbededpac caondash unës uanumbi. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Abi dasiuidaid ënapen icquid chicshun: —¿Chuiquid dapada nedi? —quequin dashcute piumbo icquid dasiuintanquin ");
INSERT INTO mcfNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","mauete pinchuc-pinchucpambo icnuc nacnenaid mauemepac caondash. Adshumbic aton matses chuiquid dapan sananacbimboen sananuc abiucshun cueste sanamepac caondash. Adshumbic aton matses chuiquid dapa ismiacbimboen mamënshunquin: —Is. Isadaidbo chuiquid dapambo neque —queshun danëshën sebudquin Esus ismepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Adshumbic dacuishtucatanquin ambi cueste sanameboed bedshuntanquin aidëmbi matombudnepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aden mamënshuntanquin ambi dasiuimboed chictanquin aton dashcutebidi dasiuinoapac caondash. Adoshon: —Ma unësnuequin cuesten dectanec nidnu. Nid —quequin Esus buampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Buanquin Esus abi dectante cueste yuëmemebanquimbi dada nidaid Sidene caid yacnuësh choquid Simon cuëmëdquid Esusën yuëmiaid sondadon chiadtomebidampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Adobidanec nidec macuësh dapa yacno matses mapi canitebimboec isadquid Codocota caid yacno chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Choshombien sondadon uba chinaid actequid paëmbo dauë nëcushaid Esus meneuidpondash. —Në. Ac —cac pictsëc tantanec: —Padi —quepondash aquenquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Adshobien cueste napotiaid bëboedën dectampondash. Dectanshumbic ambi chicshumboed Esusën dashcute bednuequin sondadobon abi cuëmëdquidtedi dada uabanshun tëchun sandoshon cadotanequin dada uatempi puduemiaid isbanquin Esusën dashcute bedbampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Adash: —Esus unëso isnu —quec sondado tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Adshumbic: —“Nadquid icsho cuidquin unës uac,” quequin ma isquidon tantianu —queshun cueste cuëshën naden dada uapaccondash. —Nëidquio Esus nec. Isadaidbo chuiquid dapambo nec —quequin dada uaid Esusën mapino dectampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ampequid daëd cuesten ëquë dectambudcuenquin dectantanquin nënantanquio Esus dectampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Adshobien podqued cuëmanquio Esus diadsho isbidanequin chieshënquin chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—“Nuquin Papa tabadte shubu uashunaid chic-chictanquin daëdec ushquin nacnenquin nainendambi,” quiondaid yec bud. Nuquin Papan madombo yec unësenquio yec auëshquiobi bud —cabidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Adecbidi chuiquid dapabo yec Moisesën dada uampid chuibanquido yec tsusiobo yec quequido Esus icsamboen mamënshunec nadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Utsibo ismenuembien comapenen tantiaquin matses bëdamechitosh. Adembidi comapenen tantiaquin nacnenash budsho isnuqui. “Isadaidbo matses chuiquid dapambo nebi,” quequid neque. Ma budnu. Dectamboedi abibi budsho isash: “Nuquin Papan chomiaid yec Nuquin Papan Madombo nec,” quetsiabi. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Nuquin Papa tantiaquid yec Nuquin Papan madombo nebi,” quequid icsho: “Ai, con madombo nec,” quequin ma Nuquin Papan budmenu. Unësenquio icsho isnu —quepondash tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Adnubien abëdta cuesten dectamboedon ampequidontsen Esus mamënshumpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Adnubien ushë cuembo icnuc inchëshbocpadquiec inchëshpondash. Ushë cuembo icnuc inchështanec ushë budambi ushëmbo yanoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ushëmbo yanubien Esus comapenec cuëdec nadpondash. —Eloi, Eloi, lama sabactani —quec con onqueten cuëdpondash. —¿Atotsieshun ëbi bëdamboen isenquio yano, Papa Edoen? —quec adondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Adec cuëdsho tantiash isquido nadpondash. —Edias yampid cuënchitequien nec —quiampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Adnubien Esus isec tabadquid abentsëc titinquianec nidshun shapu-shapupactsëcquid bedtampondash. Bedtanshumbic actequid mucacquid anidtsëcquidën shapu-shapupactsëcquid punshun cueste dëdectanshun abuc sananec: —Chishmenu —queuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Adnubien abi isquido: —Padi. Nuquin tsusedpa Edias yampid choshon budmesho isnu —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Adnubien padpidec buëdanquiec cuëdtanec Esus unëspondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Esus unësnubi Nuquin Papa tabadte shubu uashunaid yacnuësh: —“Quënë uquëducquidën Nuquin Papa tabadtembo nec,” caidën utsi puduednushe —queshun dashcute ënapen icquid dectanaid abucuësh canchedbudcuenac caondash abitiombi. Nuquin Papan ambi bëdamboen iste tantiamenuen nanëdash. Adnubien nidaid uëdëquequidën cuënote dapa dadpen cuëshëdbudnepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Adec unësaid nauedaid shëcuë bëtashte cuënote dapambo cuëshëdnubien Nuquin Papa tantiaquido ënden unësaido abentse-abentsec uincuenanec chopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Esus uincuenan adec uincuenaidon shubu dadpen icquid Edusaden caid yacno nidshun matses dadpen ismepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nidaid uëdëquenuc dacuëdampambo icsho isashien: —Esus unëso isnu —quiash tabadquido sondado chedo abi chuiquidbëdi dacuëdtanec: —Ma Nuquin Papan Madombobi nepayoc —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Adnubien chidobo Cadidia yacnuësh Esusbëd choquin abi codocashumboedo Esus unëso isnuec ancuenshun isec tabadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nëidted icpac caondash. Nëidic Madia Mactada yacnuësh choquid. Nëidic Madia utsi Acobon tita. Aid Ose cuëmëdquidën titabidi niosh. Nëidic Sebedeyon chido Uanën tita. Aid Acobo cuëmëdquidën titabidi niosh. Aidtedi uanoshon isbededec tabadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Adnubien inchëshbudtsëqui aton na dadpen dayun uaquid shubu dadpen icquid Adimateya caid yacnocquid Ose caid: —Esus tantiaquid nebi —quianec Esus bedec chopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Choshombic chuiquid dapa Pidato caid chuituidpac caondash. —Esus bednuec chobi —cac aton yua chuiquin: —Ma buanu. Bedmetan —capac caondash Pidaton. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aden bedtanshun Osen Esus dashcute bëchish nibëdquidënquio nuamboshë icnuc datanedonepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Adotanquimbic nidaid cuënoteuidpambo icquid macuësh tsimpiduc shëcuë uaboed ambi: —Ëbi unësacsho nauedte nendac —caidëmbi Esus nauedpac caondash Osen. Adotanquimbic cuënote dapabidi bëtashte uaid bincumbëshun bëtimpac caondash. Adotanec nidpac caondash Ose. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Adnubien Madia utsibëd Mactada yacnuësh choquid Osen Esus nauedsho isbosh ambobi tsadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Isadaidbon obeca bacuë unës uacpadën Esus unës uamiash abentsec ushashi chonoadtemaid ushëmbi Esus chieshënquido Pidato caid chiec nidpac caondash. Padiseyobobëdi nidshun chuiquid dapabon Pidato chuituidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Esus nadpadenec. “Unësash daëdec ushash uincuenendabi,” quec muapadeneque. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Daëdec ushquin min sondado Esus nauedaid cudasmeta. Esusbëd icboedon chicshun buanushe. Aden buanash: “Uincuenaccosh,” quec muanushe. Unësabi yec abi: “Nuquin Papan madombo nebi,” quec muaic icsambo iccosh. Adembidi: “Uincuenaccosh,” quequin muauac icsamboshë ictsiashe. Min sondado: “Cudasta,” quequin chuita —capac caondash Esus chieshënquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Adoaquien Pidaton: —Ai, con sondado buantan. Aden buanshun: “Unësaid nauedaid cudasec databëdta,” cata —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Adoaquien isadaidbo tsusiobon sondado buanshun cuënote dapa bëtashaid bucun bëbitaccapac caondash. —Bëbitaccaid isash: “Chuiquid dapan bëbitaccamiaid nec. Cuidnushe. Esus chictiapimbo iquebi,” ma quenu —queshun bucun bëbitaccapac caondash. Adoshon: —Beduanushe. Isquiec tabadta —capac caondash sondado chedo chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Esus unësbon abentsec ushash abi chonoadtemaidëntsen abentsecbidi ushash dominco badiadnuc chidobo Esus nauedshun bëtimboed isec tabadnuec padpidec choapac caondash. Mactada yacnuësh choquid Madia utsibëd isec choapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Choash isec tabadnubi nidaid uëdëquiampac caondash. Adnubien Nuquin Papan abi yacnoshon uaid mayan bëda abucuësh budtanquin cuënote dapa bëtashaid shëcbempac caondash. Adtanec cuënoten tsadtopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mayan bëda yec abu bed-bedquiacbimboec ushëmboshë bëchamauanquiec icpac caondash. Aton dashcute adquiobidi bëchish nibëdquiec ushumboshë icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Adec dacuëdampambo icsho isashien unësaid cudasquido sondado dacuëdtanec uëdëquec tantiadempambo yec padishbudnepac caondash abitedi. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Adnubien mayan bëdan Madia chedo chuipac caondash. —Dacuëdenda. Cuesten dectanquin unës uaboed Esus isnuec mibi tabadec. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nibëdec. Nidosh. Ambi chuibocpadequi uincuenash nidosh. Abi uebocno en isec cho —cac chidobon anisnubien padpidec onquequin chuioapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Mimbi isboed Esusbëd icboedo chiec nid. Badedquio nidshun naden chuita. “Unësboedi uincuenash Cadidia yacno abia nidshun mibi cainendac. Anoshon mimbi Esus isendac,” quequin chiec nid —caquien ");
INSERT INTO mcfNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","auëshquiobi chidobo dacuëdboedi cuishonquec titinquianec nidanepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Titinquianec nidaneshobien Esusënquiotsen bëquedpac caondash. Adash: —Mibi isnuec nebi —quepac caondash. Adshobien chidobon: —Con Icbo nec —quequin ismenuen danëshën sebudquin taë uidën uapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Adoaquien Esusën: —Dacuëdenda. Con utsibo ëbëd icboedo chiec nid. “Cadidia yacno nidec nid. Anoshon mimbi Esus isendac,” quequin chiec nid —caquien chiec chopondash Madia. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Madia nidnubien Esus nauedaid isquido sondado abi chomeboedo isadaidbo chuiquido chiec chopac caondash. Mayan bëda chonoc Esus uincuemboed chuituidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Adoaquien isadaidbo chuiquidon aton chuiquid utsibobëd onqueshun aid sondado chedo chuipac caondash. —Mimbi chuiboed utsibo chienda. Mibi piucquid dadpen menenu —queshun piucquid dadpenquio menepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Mimbi isboedquio chienquio icquin naden chuita. “Ëbi chedo ushtoan abëd icboedon Esus ampequin beduanaccosh,” quequin utsibo chuita. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mibi caic: “Sondado ushtoac caosh,” quequin chiac mibi chuiquid dapa Pidaton chushcaquin mibi cuidnushe. Aid: “Chushcaquin cuidenda,” quequin chiendambi —queshun ");
INSERT INTO mcfNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","piucquid meniac bedanec nidec isadaidbo chuiquidon chiacpadec muapac caondash sondado. Adembidi nëbi isadaidbo dadpenshun: “Esus ampiac,” quequin chuioaic. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Adnubini Esusbëd icboedo 11tedi yec Esusën chiacnombo Cadidia yacno nidec macuësh dapa yacno nidanepondac. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Macuësh dapa yacno nidquimbi Esus istuidpondambi. Istuidshumbic: —Con Icbo neque. Ismenu —queshun danëshën sebudpondambi. Utsibombien: —¿Con Icbombobida nepeba? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Adsho isun Esusën anoentsëqui choquin chuituidpondash. —Ëbipadquid utsi nibëdec. Nuquin Papan uaido abitedi con na nec. Abitedishun Icbombo icquin abitedimbo namequidquio nebique. Mibitsen namenu. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nidaid utsi-utsiec yacno nidshun ëbi tantiaquido icmenuen matses abitedi ëmbi chiaid chuibeneta. Adoac ëbi tantiabensho utsibo ismequin acten mentobeneta. “Esus tantiabenshun Nuquin Papatsen tantiaquid nec. Nëidbëd Nuquin Papan Mayan tabadeque. Utsibo ismenu,” quetanquin aden acten mentobeneta. ");
INSERT INTO mcfNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mimbi mentoaido chuiban. “Nuquin Icbon chiacpadec bëdamboec tabadnuna,” quequin ëmbi chuiboedtedi chuiban. Mimbi adosho isash mibëd iquendabi. Nidaid abitedi nibëdanabi icnuc mibi chedo nianenquio iquendambi. Adembidi ëbi tantiaquidotedi niantiapimbo iquebi —quepondash Esus ënquimbi chiec.");
INSERT INTO mcfNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Madcos nebi. Nuquin Papan tantiampicpadquiec aton madombo Esus abi yacno matses yuedquid chote tauamboen chiaid bëda chuinu. Tantia. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Abi aton mado Esus chiec onquiaid Nuquin Papan Isayas dada uamiampid nad iquec: “Naden naimbique. Tantia, mado. Mibi chotequid chuibanquidba chomendambi. Aidën chuibanac ambi tantiaid icsa ënshun mibi cainquidombo iquendac, mado. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Shubu nibëdacnoshon comapenec onquequin mibi chotequid aidën chuibanendac naden: Nuquin Icbo choeque. Aid tantianu quequin mibi icsaid ëmbanta quequin mibi bëyuc chuiquidën mibi chotequid chuibanendac, mado,” quequin aton mado chiec onquiaid Nuquin Papan Isayas dada uamiampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aden chiampicpadquiequi Esus bëyuc chuitequid Uan chopondash. Shubu nibëdacno tabadquin comapenec onquequin chuibampondash. Mibi icsaid ënshun Nuquin Papan chiaid tantiaquin nabanta. Aden tantiaquidquio icsho mibi cuidenquio yec mibi icsaid Nuquin Papa bëpiscudendac quequin chuibampondash. Aden chuibanquimbi ambi chiacpadomboen naquid acten mentobampondash Uanën. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aden Uanën chuibanubien matses dadpen tantianu quec choded-chodedpondash. Nidaid Udeya caid yacnoësh chopondash. Edusaden caid yacnoëshbidi cho-choapondash. Cho-choash tabadquin tantiashien, Icsapobi, quec abi icsaid chiec utsi-utsiec onquecuededpondash. Aden abi icsaid chuibanquidtedictsëqui Uanën acte Odan caidën mentobampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ambo iquec Uan nidaidën capuquid cameyo bu daëdcaid dasiuidquid niondash. Nidaidën capuquid yua bitsi nacnenaid tsiuquid niondash. Shioshbimboecquid shuishun pequid niondash. Bacun chequid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aidëmbi naden chuibampondash: —Con tsyuecquid choendac. Aidi nadatiambocquin naquidquio nendac. Aidi bëdamboshëcquid icnuc ëbi icsaquid icsho ¿atotsieshun aid choec quequin chuiquidquio Nuquin Papan icmioshi? quec tsadebi. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mibi acten mentoquid nebi; aidien abipadquiocquid aton Mayan menianquidquio nendac —quepondash Uan. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Adnubien ambi chian-chianaidquio Esus chopondash. Nidaid Cadidia caid shubu dadpen icquid Nasaded caid yacnoësh chopondash. Adshobien Uanën Esus acten mentopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aden acten mentoac Esus pudundonobi abu bëcadoacnoëshquio dëbimbimboec isadquid abipadquiocquid aton Mayan bede-bedequemboec Esusbëd icnuec budpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aden budmetanec ambi bëcadoacnoëshi: —Mibentsëcquiobi icsho ëmbi tantiaidquio mibi nec, mado. Ëmbi bëdamboen isaidquio mibi nec —quepondash aton Papa Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aden chuibon budmeboed Mayanën: —Shubu nibëdacno nid —cac nidash Esus tsadpondash abentsëcquiobi. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ambo tsadquimbi ushë abentsëc nidmec utsi choaid abutometsëcquiec tabadpondash. Ambo tabadshobi Nuquin Papan chiaid niacmenuequin tanu quianec mayan icsan icbo Satanas caid chopondash. Aden tanaqui niaquesambo yec tsadpondash. Adec tsadnubi nidpondash Satanas. Ambobi bëdi nibëdquid deon caid chedo icpondash. Ambo tsadshobi ambi uaido mayan bëdabon cho-choshon nashumbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ambo yuec tabadash Esus choambien isadaidpembo ancaquidën acten mentoanquid Uan bedmeshun quënën nauedmepondash. Uan nauedmiambi nidaid Cadidia caid yacno nidshun Nuquin Papa yacno shubu abentsëquën tabadte iquec quequin Esusën chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Nuquin Papan chiampidpadquid abi yacno yuedanquid nëmbobi iqueque. Mibi icsaid ënshun ëmbi chiaid bëda tantiata —quepondash Esus comapenec onquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aden chuibanashic chian Cadidia caid cuëman capupondash. Ambo capuquin Petedo Simombëdtan aton utsin Andedesën nëshaid acte nënebansho istuidpondash. Aid daëdi nuëcquid bedquid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aden nuëcquid bednuen nëshaid nënesho isec: —Nëshaidën nuëcquid bedquid icboedi nëbi Nuquin Papa yacno yuedanquid iquec quequin chuitequid mibi icmembique. Ëbëd iquec cho —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Adsho tantiash nëshaid abëd icquid menianec abi chuiquidbëd nidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Adanec udictsëc nidanequin Sebedeyon mado daëd Acobobëdta Uan Esusën istuidpondash. Aidon aton nëshaid nacnempondash cano antabëdquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aden nacnensho isun Esusën ambi utsi chuibocpadomboen chiaquien aid daëdshuntsen aton papabëd aton yua cano antabëdsho nianec Esusbëd nidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Adashic chian Cadidia caid yacnoësh nidequi shubu dadpen icquid Capednaun caid yacno Esusbëd icquido chopondash. Choash chonoadtemaid ushë icnuc ënapen capuenquio yec Nuquin Papan chiaid chuibante shubun puduedpondash. Puduedshun iccuededquido Nuquin Papan chiaid Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aden chuisho tantiashun: —Ambia tantiaquidën chiacpadomboen Esusën chuibanec. Utsimbien adomboen chienquio iccosh —quec onquec tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aden Esusën chuisho tantianubien mayan icsa dapuduedaid tsadacnoëshquiobi comapenec onquiampondash: ");
INSERT INTO mcfNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Esus Nasaded yacnoësh choquid mibëd icquidpenquio nebique. Nidec nid. ¿Chian anëdënquiacno ëbitedi nidmenuecta cho? Nuquin Papan Madombo icsaisa nec quequin ëmbi tantiaid mibi nec —quec mayan icsa dapuduedtsaid onquepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Adoaquien: —Otacquio tabad —quetanquin: —Dapuduen —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Adoac comapenec abi dapuduedaid uëdëquenuc sidquianec dapuduempondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Adsho isash: —¿Abimbodambi ispo? ¿Mitsipadquidquio nepec? Ambi tantiamiaid utsien nechitec. Chuiquidën nacpadomboen naid nec. Dapuduen, ambi cac ambi chiacpadomboen mayan icsan naic —quec onquecuededpondash Esusën naid chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Adec onquecuededash auëshquio nidaneshun ambi isboed, Esusën naid, chuibampondash. Aden chuibansho nidaid Cadidia caid yacnocquidtedishuntsen tantiabededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ambi chuisho tantiaboedo nidanenubien Petedo Simon caidën shubu yacno Esus Acobo Uan aidtedi nidpondash. Aidën shubun icquidbidi aton utsi Andedes icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aidën shubun icquidbidi Simonën nachi icpondash. Ambo Simonën nachi chumbo yec uepondash. Ambobi Esus chosho isun utsin chuipondash chumbo iquec quequin. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aden chiaquien Simonën nachi yacnombo choshon Esusën mëdinquin uëtsëndoac abi chumbo yaid badedquio bëdampondash. Adec bëdanash nidtoshon codocashun abi choquidtedi pemebampondash Simonën nachin. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Adnubien inchëshbudtsëqui Capednaun caid yacnocquidën daicsaidtedi bë-bëpondash. Adembidi mayan icsa dapuduedaidtedi bë-bëpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bë-bëash Simonën shubu shëcuë cuëmano puduedabi tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Adsho isun daicsaidtedi Esusën bëdamebampondash. Adembidi mayan icsa dapuduedaid dapuduemebampondash oncamenquiocquin. Nuquin Papan Madombo abi yacno yuedmianquid abentsëcquiobi mibi nec quequin chuinushe queshun oncamenquiocpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Adashic badiadte anoentsëqui yanubi isucunanec puduanec shubu nibëdacno Esus nidpondash. Nidec tabadtuidshun Nuquin Papabëd onquequin chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Esus nidacshobi isucunshun Petedo Simombëd icquidën nibënampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aden nibënquin istuidashi: —Mibi isec cho-choquidtedishun mibi nibëmbededec —quepondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Adoaquien Esus: —Capucuenequin utsibotsen Nuquin Papan shubu abentsëquën yuedanquid iquec quequin chuibenec chobique. Shubu utsi-utsiec dadpen yacno nidnu. Nid —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aden chuibidanec nidaid Cadidia caid yacno capuequi shubu dadpen yacno choshon Nuquin Papan chiaid chuibante shubun puduedshun Nuquin Papa yacno shubu abentsëquën yuedanquid iquec quequin chuibampondash. Adembidi shubu dadpen icquid utsi-utsiec yacno choash puduedshun adomboembidi chuioapondash. Adembidi mayan icsa dapuduemeoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aden Esusën chuibanubien daushacbimboecquid nami mishac tantiadenquiocquid chopondash. Esus yacno choash: —Dada icsambo iquebique. Mibi adquid tantiaquid icquin ëbi bëdame —quequin Esus chiec comapenec cuëdpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Adec cuëdshobi nëid isash unësquio iquebi quequin ëquëducshun tantiaquin mishec Esus: —Mibi bëdamembique. Bëdambo icta ");
INSERT INTO mcfNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","—quenubi daicsaid nibëdquio yec bëdampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aden bëdametanquin nidmepondash: —Nidec nid. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nidquimbi, Esusën bëdamioshi quequin chuituidenda. Naden nata. Edusaden yacno nidash Nuquin Papa tabadte shubu uashunaid yacno nidec puduedta. Ambo puduedshun min dada bëdambo icquin anocquid, Nuquin Papa matses chiec onquianequid, isme. Adoshon dëbimbiecquid daëd meneta Moisesën chiacpadomboen ma anocquidën napanueshun. Aden meniac abentsëc cuesuneshun utsi cuesunenu quenquiocquin cuesuniaidën intac puntanequin intac mibi daseccashun dëbimbiecquid utsi cuemeshun naden aidën mibi chuipec. Nuquin Papan mibi bëdamboen istiapimbocboedi nëbi bëdamboen mibi isendac. Aden chuiquin mibi bëdamiaid Nuquin Papan naid nec quequin tantiatsiash —quepondash Esus ambi bëdameboed chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Adsho tantiaboshombi niacbidanquin Esusën bëdamioshi quequin chuibenepondash. Aden chuibanac Esus yacno matses dadpen cho-chopondash. Adec cho-chosho isash shubu dadpen icquid yacno Esus tabadtiapimbo yec shubu nibëdacno capupondash. Adnubien Esus nibënec nidaid utsi-utsiec yacnoësh dadpen cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Adashic Capednaun yacno nidoash shubun puduedpondash Esus. Adnubien, Esus chosh quesho tantiash padpidec dadpen cho-choapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dadpen cho-choash puduedash tsucus-tsucustsëcquio yec tabadnubi adecbidi shëcuë cuëmano tabadpondash. Adec tabadsho isun Esusën Nuquin Papa yacno shubu abentsëquën tabadte iquec quequin chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Adnubien cuembo yec uishquiaid bëec dada daëd-daëdquiec 4ted cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cho-choshon matses tsucus-tsucustsëcquio yec tabadsho isun dectatoshon macano nacnenaid chic-chictanquin Esusën dayunquio uishquiaid imbudpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aton dayunquio imbudsho isun Esusën bëdamec quequin abi imbudboedën tantiec quequin ambibi tantiapondash Esusën. Adashic: —Mado, mibi cuidenquio yec mibi icsaid bëpiscudobi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Adnubien isadaidbo tsusedpabon nadomboen nata quequin chiaid tantiamequidon ambobi tabadquin naden onquenquiocquin icsamboen tantiapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Atotsi quiash adec Esus onquepeque? Tantianu. Nuquin Papa icsamboen chuiquidien aid nechitec. Nuquin Papauidi matses cuidenquio yec abi icsaid bëpiscudquid nec, quetsëcquiec tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aidon tantiaid tantiec nadpondash Esus: —¿Atotsieshun aden mimbi icsamboen tantiape? ");
INSERT INTO mcfNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Mibi cuidenquio yec mibi icsaid bëpiscudobi quequin ëmbi chiaidquio bëdantequidpenda nedic? Adecbidi, ¿Mibi icsambocboedi mibi bëdanoque. Nidtoshon mibi imbudboed chiadtoshon buanec nid quequin ëmbi chiaid bëdantequidpembidida neoadic? ");
INSERT INTO mcfNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ai, adquidquiobidi nec. Mibi cuidenquio yec mibi icsaid bëpiscudobi queboed chidon tishac matses yanaid yequi chuiquidquio Esus nec quequin tantiesabo mibi nepec. Adquid icsho ëbi tantiamenuequin ");
INSERT INTO mcfNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","cuembo yec uishquiaid naden chiembique Tantia. Mibi icsambocboedi mibi bëdamiombique. Nidtoshon mibi imbudboed chiadtoshon buanec nid —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Adoaquien nidtoshon abi imbudboed chiadtoanquin buampondash. Aden buansho isash: —Nideque. Is. Adomboen nasho isamboccondambi —quetsëcquiec onquiash Nuquin Papan naid nec quec cuëdëncuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Adashic padpidec chian Cadidia caid cuëmano nidoapondash Esus. Ambobi tabadnubien aidën chiaid tantianuec matses dadpen cho-choapondash. Cho-choasho isun Nuquin Papan chiaid chuibanoapondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aden chuibanec nidquimbi Debi, Adpeon madombo, tsadsho istuidpondash. Aidi Mateyobidi cuënondash. Nidaid utsi yacno aton na utsibon buan-buansho isun piucquid bedshunquid Debi nepondash. Adembidi nidaid utsi yacnoshon aton na bë-bësho isun piucquid bedshunoaquid Debi nepondash. Isadaidpembo ancaquidën, Con matsespembon piucquid bedshunta, cac bedshunoaquid Debi nepondash. Adshobien: —Ëbëd iquec cho —Esusën cac: —Ai, mibëd nidnu. Nid —quianec badedi Esus tsibananec Debi nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Adshumbic Debin shubuno nidshun Esusbëd icquidon pepondash. Ashunquiobidi aton na buansho isun piucquid bedshunquid Debipadquidën utsin-utsinquien pepondash. Ashunquiobidi isadaidbo tsusedpabon nadomboen nata quequin chiaid naisan utsin-utsinquien pepondash. Debin shubuno Esus tsibanec choquid dadpen icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aden adquidbëdtan Esusën pesho isun isadaidbon nadomboen nata quequin chiaid tantiamequid padiseyobo caid: —¿Atotsieshun piucquid bedshunquidbëdtambi isadaidbon nadomboen nata quequin chiaid naisabëdtambi mibi chuiquidën pepec? Tantianu. Ëbi chui —quepondash padiseyobo Esusbëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Adsho tantiashien Esus: —¿Dada bëdambocquidta dauëchoquidën bëdametequid nedic? Padenquio. Daicsaidien dauëchoquidën bëdamec. Adquiecbidi, icsaisa nebi quequin ambibi tantiaquid icsho mibi icsaid ënta. Aden ënash ëbëd icquid mibi iquendac quequin chiesa nebi. Icsaquid nebi queshun mibi icsaid ënta. Aden ënash, ëbëd icquid mibi iquendac quequin chuiquid nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Adnubien abi chuiquid quënën nauedan aid tantiec unësquiocquin Uan acten mentoanquidbëd icquidën buna mëmunubi padiseyobobëd icquidon unësaid tantiec unësquiocquin buna mëmunoapondash. Aden buna mëmunsho isanec nidequi Esus yacno nidash Esusbëd icquidon buna mëmunenquio icsho isash utsibo: —¿Atotsieshun Uambëd icquidon adembidi padiseyobobëd icquidon buna mëmunubi mibëd icquidon buna mëmunenquio icpec? Tantianu. Chui —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Adoaquien Esus: —Aton chido bednun pambid meniac chidon codocacsho abi inquidën abëd icquido menec. Aden meniac isuidesa abëd icquido nec. Adecbidi ëbi abi chuiquid icnuc ëbëd icquidon buna mëmunenquiocquin isuidenquio iquec. Yuecash chido inquid nibëdanan abëd icboedo unësquiocquin buna mëmunquin isuidpec. Adecbidi ëbi nibëdanan ëbëd icboedo unësquio yampec. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Adembidi dashcute shënibëdta chucambocquid bëtuscaisa matses nec. Shënibëdta chucambocquid bëtuscatsaid amëec canchedoaic. Adecbidi abi icsaid ënesa tantiaid bëda pausudtiapimbo yec icsabudec. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Adembidi dadpen icquid chodo uashun sandoec. Adotanquimbic istuidshun chuca uain chodo uashun sandoaic. Chodo shënin icsa sandoshon nequid bëenquiocquin. Adecbidi Nuquin Papan tantiacpadec pausudnu queshun mibi icsaid ënacsho isun Nuquin Papan pausunendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Adnubien chonoadtemaid ushë utsi icnuc ënapen capuenquiocquin tied matanquin adosbiecquid trico caid ëshë bedshun Esusbëd icquidon pepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Adshobien: —Mibëd icquido is. Chonoadtemaid ushën chonoadeque. Abi chuiquid mibi iquec ¿atotsi quiash, Padi. Chën, quenquio ique? —quepondash padiseyobo Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Adoaquien Esus: —¿Chuiquid Dabidbëd icquidon natia bunquin ambi petemaid pepondash quequin dada uapampid tantiamboda icconda? ");
INSERT INTO mcfNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nad icpampic. Abëd icquidobëd yuec capuash Dabid comapenec bundopampic. Bundoash Nuquin Papa tabadte shubu uashunaid yacno choash puduedtemaid quënën puduedshun Nuquin Papa tantianuequin pan meniac sanaid bedshun ambi petemaid abëd icquidobëdtambi abi chuiquidën Dabidën pepampic. Puduedtemaid quënën puduedquid, Nuquin Papa matses chiec onquianequid, Abiatad abentsëqui icnubi aid quënën puduedshun bedshun Dabidën pepampic. Abiatadpadquidën peteuidtsëqui nec quenquiocquin abëd icquido tantiaquin pan bedshun aidobëdtambi pepampic chuiquid dapa Dabidën —quepondash Esus padiseyobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aden chuishumbic naden padiseyobo Esusën chuioapondash: —Nabanash tiboedte matses bumpec quequin tantiaquin abitedi uabanquin ënashini con pabëdi tiboquepampic. Adashic yuecash, Chonoadtemaid ushë nec, quepadenebi con pabëdi. Aden chiequi matses tiboedte ushë aton icbo ictiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aid ushë icbo icquin ëbëd icquidon bunquin pebededsho isash, Padi. Chonoadtemaid ushë neque. Aden penda, quenquioccobi —quepondash Esus abi chieshënquido padiseyobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Adashic padpidec Nuquin Papan chiaid chuibante shubun Esus puduedpondash. Ambo dada mëuesadaid tsadnubi ");
INSERT INTO mcfNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Esus chieshënquid padiseyobo dadpen tabadpondash. Adec tabadec, Nëbi chonoadtemaid ushë icnuda Esusën mëuesadaid bëdamepeque. Nëid badiadën bëdamesho isun bedmeshun quënën nauedmenu quetsëcquiec padiseyobo tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aden tantiec padiseyobo tabadnubien mëuesadaid chuiquin Esusën: —Nënantanquio nidto —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Adoac nënantanquio nidtoash mëuesadaid nidnubi iccuededquido chiec Esus onquepondash: —¿Chonoadtemaid ushën matses tantiaquindambi nape? ¿Adoenquiocquin matses icsa uapendambi ique? ¿Nëid ushëndambi matses bëdamepe? ¿Bëdamenquiocquindambi cuesunepe? —quepondash. Aden chiec Esus onquenubien onquenquio yec tabadpondash padiseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Adoaquien nëishtanquimbi abi chieshënquido bëisbanec Esus, Nuquin Papan chiaid tantiabanquin naisa yec pausudtiapimbo icquido nec, abibi quiashic, Unësquio iquebi, quec tsadpondash. Adec tsadquin mëuesadaid chuiquin Esusën: —Ëbi mëd —cac mëdequi bëdampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Adosho isash puduenanec nidquin edodesbo padiseyobon badedquio istuidpondash. Aido istuidash: —Esus cuesunete mibi bunacpadquiec bunebi. ¿Mitsipadentsimbi cuesunemenuen bedmepeba? —quecuededpondash padiseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Adnubien Esusbëd 12ted icquido chian Cadidia caid yacno nidoapondash. Adnubien nidaid Cadidia caid yacnoësh utsibo dadpen cho-choapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Adnubien Esusën nabansho isboedon chiac nidaid Udeya caid yacnocquido dadpen cho-chonobi adecbidi Edusaden yacnocquido cho-chonobi adecbidi Idumeya yacnocquido cho-chonobi adecbidi acte Odan caid uquë cuëma utsiucquido cho-chonobi adecbidi shubu dadpen icquid Tido caid yacnocquido cho-chonobi adecbidi shubu dadpen icquid Sidon caid yacnocquido cho-chopondash. Esus yacno ambi nabanaid utsibon chuisho tantiash cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Adec cho-choash tsucus-tsucustsëcquio yec tabadquin tsicatiac nënantanquio tsadacnoëshi catashnushe quiash Esus: —Cano bec cho —quiampondash abëd icquidquio caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Dadpen bëdamiosh cadoshe. Ëbitsen bëdanu quequin ambibi tantiaquin Esus mishbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Adembidi tantiaquin mishnuec mayan icsa dapuduedaid choquin Esus istuidequi uebudec comapenec sidquianec: —Nuquin Papan madombobi mibi nec —quec comapenec cuëdpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Adoaquien: —Padi. Aden ëbi chienda —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Adashic macuësh dapa yacno nidnushi abëd 12ted icquido chomeshun nadopondash: ");
INSERT INTO mcfNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ëmbi tantiacpadomboen mibitedi tantiamembi. Adquid icquin ëbëd tabadquin ëmbi chiacpadomboen mimbi tantiabenendac. Aden tantiabenacsho isun ëmbi chiacpadomboen chuimenuen mibitsen nidmembi. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Adembidi mayan icsa dapuduedaid dapuduemequidbidi mibi icmembi quequin abëd icquido Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ambi tantiamenu caid nëidtedi icpondash: Simon cashumbic Esusën Petedo capondash, ");
INSERT INTO mcfNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","utsibic Sebedeyon mado daëd, Acobobëd Uan. Aid daëdi, abu cuëdtequidën mado nec quequin oncain Buanedquis quequin Esusën cuëmpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Utsibic Andedes, utsibic Uedipe, utsibic Badtodome, utsibic Mateyo cuënshumbic Debi cuëmpondash. Utsibic Tomas, utsibic Acobo, aidi Adpeon mado nepondash. Utsibic Tadeyo, utsibic Simon, aidi cananistabo caidbidi nepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Utsibic Udas Iscadiote, aidi abi chieshënquido Esus bedmenush Esusbëd capuquid nepondash. Aidtedi Esusën tantiamequin chuiquin ismiaido niondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aidtedi chianec nidequi Esusbëd icquido shubun puduedpondash. Shubun puduednubien matses dadpen cho-choapondash. Adshobien Esusën Nuquin Papan chiaid chuibanubi Esusbëd icquidon penquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aden penquiocsho isanec nidshun Esus yuedquid yacno choshon chuituidpondash. Aden chuituidac anocquidtsen Esus bednuec chopondash. Icsabudashien nec quianec chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Adomboembidi Esus icsabudec quequin icsamboen chuiquid utsibo icpondash. Isadaidbo tsusedpabon nadomboen nata quequin chiaid tantiamequid chuiquid dapabo niondash. Aido Edusaden caid yacnoësh choquido niondash. Aido mayan icsa Esusën dapuduemesho isboed Esus chieshënquid yec nadpondash: —Mayan icsan icbo Satanas cashumbic Bedtsibu caidën tantiamiaid Esus nec. Adquid icquin mayan icsa matses dapuduedaid dapuduemec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Adoaquien Esus: —Mimbi icsamboen tantieque. Mibi chuibanu. Tantiec tabadta. ¿Mayan icsan icbo ambi dapuduedmiaid dapuduemequidta nepadic? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Adquiecbidi shubu icbo abëd icquido cuëshëdmesa nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Icbon abëd icquido cuëshëdmiash shubu abentsëquën tabadtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Adembidi ambi dapuduedmiaid dapuduemiash adquidën icbo ictiapimbo Satanas iquec. Icbo icnuequid abëd icquid puduemesa nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dadpenshun icbo Satanas nec. Adquid icquin ambi matses dapuduedmiaid dëniacanquidënuidquio nadatiambocquin nabanquin cuemepec. Adquid icquin ëmbi nac mayan icsa dapuduedaid Satanasën yua icboedi icbombo tantiec bëdambo yanec ëbëd iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Abimbo chiembique. Tantiata. Matses cuidenquiocquin abi icsaid bëpiscudquin paucquid Nuquin Papa nendac. Adecbidi Nuquin Papa icsamboen chuiboedi, Icsaobi, Papa, quesho tantiashun Nuquin Papan aid pauquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Utsien Nuquin Papan Mayan abipadquidën tantiamiac nasho isun Satanasën naid nec quesho pauquenquio iquendac. Adquid ënëdenquio yec icsaquid nendac —quepondash Esus ");
INSERT INTO mcfNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Satanasën tantiamiac mayan icsa dapudemequid Esus nec abi caquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Adashic Esus yacno aton utsibo anibëd chopondash. Aido choshon matses dadpen nuntan tabadsho istuidash: —Ëbi choaid con mado chuita —quepondash utsi chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Adoac puduedshun Esus nënantan tsadsho isun: —Titabëd min utsibo choshon umanucshun mibi isnuen cainec —quequin chuituidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Adoaquien Esus: —Adquid utsi chuinu. Tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Në tabadquido ëbëd icquido neque. Is —quepondash Esus abëd iccuededquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Adashic: —Nuquin Papan chiacpadomboen nabanquid ëbëd icquid nec. Adquid buchi caindambi. Adquid chido chuchu caindambi. Adquid utsi tita caindambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Adashic padpidec chian cuëmano nidshun Esusën tantiamequin chuibanoapondash. Aden chuibanuc cho-choquid dadpen icsho isash cano antabëdtopondash cho-choquid acte cuëmano tabadnubi. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Adec tabadshobi, matses nadquio iquec quequin tantiaquin tiedën caniquid ëshë Esusën tantiamequin naden chuibampondash: ");
INSERT INTO mcfNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tied icbo pete ëshë nësecanuec aton tied yacno nidquid. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Adec nësecanuec nidshun pete ëshë nësecac maisec pudun-pudunaid uicchunën chequid. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Adnubien nidaid cuënote dadpen samëdacno utsi-utsiec paëdash badedquio dëyucuidtsash ");
INSERT INTO mcfNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","tapunenquio iquec ushën shoedec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Adnubien pete ëshë utsi-utsiec nisanquid dëyucacno paëdash dëyucash canidouidtsacsho nisanquidën bëtinac podo sinash bacuëtiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Adnubien nidaid bëdambo yacno paëdaid dëyucaid caniash dadpen pete ëshë icquid. Utsi-utsiec 30ted icnuc, utsi-utsiec 60ted icnuc, utsi-utsiec 100ted iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aden chiash: —Ëmbi chuiboed tantianu quiash bëdamboen tantiec papuduedta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aden chuibanash udictsëc Esusbëdi nidshun utsibo choenquiocsho isun databëdtuidquin abëd icquidon: —Mimbi chuibamboed tantianu. Ëbi chui —capondash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Adoaquien: —Nuquin Papan shubun tabadquid tantiamendambi utsiboembi, Mibi nadquido iquec, quenquiocquin chuibanoc. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aden chiac: “Nuquin Papan nabamboed isto-istoboedi ma padenquio tabadteneyoc. Adembidi tantiado-tantiadoneboedi ma padenquio tabadteneyoc. Aidon abimbo tantiaquin abi icsaid ëntsiandac. Aden abi icsaid ënsho isun cuidenquio yec Nuquin Papa abi icsaid bëpiscudtsiandac” —quepondash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aden chiashic: —¿Mimbitsen ëmbi chuiboed tantienquioda ique? Aidi tantienquiocquin ¿mitsipadentsi adomboembidi chuibansho mimbi tantiape? Ëmbi chuiboed nad iqueque. Tantia. Chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pete ëshë sequidbimboecquid Nuquin Papan chiaid chuibanquidquio nec. Ëshë ambi siaidbimboecquid Nuquin Papan chiaid nec. Abi paëdacno nidaidbimboecquid matsesën tantiate nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nidaidën paëdash pete ëshë dëyuctiapimbocsho uicchunën chiaidbimboec matses utsi-utsiec iquec. Adquid Nuquin Papan chiaid tantiash papuduednu quesho Satanasën bëpiscudmiac tantienquio yanec Nuquin Papa yacno puduedtiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Nidaid cuënote dadpen samëdacno pete ëshë paëdash badedquio dëyucuidtsash tapunenquio yec ushën shoedaidbimboec matses utsi-utsiec iquec. Adquid Nuquin Papan chiaid tantiauidash bëdambo iquec queboedi ¿Esus tantiaquid nebi quecta icco? quequin utsibon mamënshunac badedquio tantiesa nebi quendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Nisanquid dëyucacno pete ëshë paëdash dëyucash canidouidtsacsho nisanquidën bëtinac podo sinash bacuëesabimboec matses utsi-utsiec iquec. Adquid Nuquin Papan chiaid tantiauidash abi bunaid, abi nënaid, abi icsaid aidtedi tantiaquin Nuquin Papan chiaid tantiesa yanshun bëdamboec tabadaid ismesa yanec. Adquidën Nuquin Papan chiaid tantiaquid utsi icmetiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ëshë utsibic nidaid bëdambocquidën paëdash dëyucash caniash dadpen bacuë icquidbimboec matses utsi-utsiec iquendac. Adquid Nuquin Papan chiaid tantiadonec bëdamboec tabadquin utsi ismequid nec. Aden ismiac Nuquin Papan chiaid tantiaquid daëdpactsëc yanubi utsin ismiac Nuquin Papan chiaid tantiaquid dadpen yanubi utsin ismiac Nuquin Papan chiaid tantiaquid dadpenquioshë yanendac —quepondash Esus abëd icquido tantiamenuec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aden chuishumbic abëd icquido naden Esusën chuipondash: —¿Tabote icbon ambi dayun uaboed taboshon tsadte tëdion nanshun isaidta nedic? Adembidi ¿Tabote matsun bëtashun isaidta neoadic? Padenquio. Nënantan tabote nanac chënquiacbimboec ismenu quec ictiad. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Adquiobidi abi yacno yuedanquid ambi dayun uapampidi nëbi Nuquin Papan dayun uainquiocquin ëbi chomeshun ismec. Adembidi con mado chuiban quenquiocboedëmbi nëbi ëbi ismec ma con mado chuibanu quequid con Pa nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ambi chiaid tantianu queshun tantiaquiec papuduedta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aden chiash Esus: —Chiaid bëda tantiatequidquio iquec queshun tantiaquiec papuduedquid icta. Aden chiaiduidi tantiec papuduedquid abipadquid bëdambocquid ambia tantiaquidën Nuquin Papan mibi icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Adquid ambi tantiadoniaidquio iquendac. Aden tantienquioctsëcquidën tantiaid bëda uesadendac nibëdquiec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Adec onquequin abëd icquidquio chuishumbic cho-choquidtsen naden Esusën chuipondash: —Nuquin Papan shubu abentsëquën tabadec caidaidquio chuibanu. Tantiata. Nidaid bëdan tiedën caniquid pete ëshë siash ");
INSERT INTO mcfNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","tabadquin cainquidquio icbo nec. Dadpen ushquin ambi seboed isenquio yec icbo tabadnubi ");
INSERT INTO mcfNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ambi seboed dëyucash caniec tauitanec bacuëec. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ambi siaid isenquiocnoc canitanec bacuëacsho badedquio bedquid icbo nec. Adquiecbidi Nuquin Papan chiaid chuiban-chuibanubi papudedquid utsi-utsiec yanec chuibanquidën isenquiocnobi. Papuduedquioshon tantiabenec. Adquid isash con shubun puduedquido neque. Bednu quependac Nuquin Papa —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","32","Adec onquequin chuibanashic Esus: —Nadquio Nuquin Papan shubun icquido iqueque. Chuinu. Tantia. Mostasa caid pistsëc ëshëmpi ictsëcquid nësecaid dëyucash nuamboshë caniec cuidi-cuidipambo iquec shubu-shubupambo yec podoec. Ambo uicchunën shubu uaic. Adomboembidi aton shubun abi tantiaquid dadpen dayun uaquid Nuquin Papa nec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aden chuibanshumbic adomboembidi Esusën chuibampondash. Aden chuibanash, aidtedquio tantiapec abibi queshumbic aden chiaid chuiquin ëmpondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aden abited chuibanshumbic abëd icquidouidtsëqui bëdamboen tantiamequin chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Adashic abi ushëmbi inchëshbudtsëc cano antabëdtoanec Esus: —Chian uquë cuëma utsiuc nuquiuidtsëqui nidnu. Nid —quiampondash abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aden chiac chian cuëman tabadcuededquido niananec badedquio nidquin canon Esus buampondash. Abëd icquidon potenubien cano antabëdtoanquin utsin-utsinquien potepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aden potenubien cunquequid dapan acte tëccoasquequin cano acte uemiaidën mentoadtsempondash Esus tëotadec ushnubi. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Adec uec usho: —Cunquequid dapan acte tëccoascaidën nuqui mentoeque. Isucunta, icbo —quequin Esus timpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aden tinac uëtsëdtoshon Esusën: —Mibi comapenec cunqueque. Ënëd —cac badedquio ënëdpondash. Adembidi: —Mibi comapenec tëccoasqueque. Ënëd —cac badedquio ënëdoapondash acte. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aden ënëdmetanec Esus: —¿Atotsi quiash ëbi tantienquio yec dacuëdcuedede? Ëbi tantiesa mibi nepec —quepondash abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Adec Esus cuënubi badedquio cunquequid dapa ënëdposh. Adecbidi acte tëccoasquequid ënëdoaposh. ¿Mitsipadquidën napeba? Ënëd cacpadequi ënëdposh —quec abibi onquecuededequi uëdëquianquiopondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Adshumbic acte tëccoasquec ënëdmebon nidquimbi cuëma utsiuc potiash nidaid Cadada cashumbic Quedasa caid yacno choapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ambobi choash pudundosho mayan icsa dapuduedaidën Esus bëquedpondash. Cuënote dapa macuësh dapaten icquid yacnoësh choquin bëquedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aidi unësaid chococate cuënote dapa shëcuë uaidën tabadquid icpac caondash. Aidi shocosh bucun mëdantebëdta taë taniaid icboedi nadatiambo yanshobi mëtanetiapimbo yampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Abi mëtaniaid shocosh bucu seccuduatanquin tës-tëstenepac caondash. Adosho isac abi tanebocpadquid utsi nibëdpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aidi inchëshën capucuenequi mëyanacbimboec sidquecuenepac caondash. Adec capuequi cuënoten abibi dasiadcuenepac caondash. Adec siadcuenequi dastidquebudnepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aidi abi yacno Esus canon chosho isanec titinquianec choash: —¿Tsusio, ada cho? —quiashic: ");
INSERT INTO mcfNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","—¿Mibëd icquidtabi nedi? Mimbi namiaidpenquio nebi. Abia Yampidën madombo mibi icquin naden ëbi chuita. Mibi chian anëdënquiacno nësecainquio iquembi. Abimbo chiembi quequin ëbi chuita —quepondash mayan icsa dapuduedaid Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Adec mayan icsa dapuduedaid abi onqueshobien Esusën: —Dapuduen —cashic: ");
INSERT INTO mcfNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Tsutsi cuëmëdquid mibi ne? —quepondash Esus. Adoaquien: —Dadpenquioshë. Cuëte podotedi dapuduedondaid nebi —quepondash mayan icsa dapuduedaid abentsëc yacbimboec onquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Adashic: —Mibi nadatiambocquid cadoque. Ëbitedi chian anëdënquiacno nidmenquiocnuequin ¿nëid nidaidën adabi tabadmetsia? —quepondash mayan icsatedi. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Adnubien macuësh potseshun chancho dadpenshun pec tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aden pec tabadsho isashien: —¿Ada mimbi ëbitedi chancho dapuduedmetsia? —quepondash mayan icsa Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Adoaquien: —Dada dapuduencuededash chancho dapuduedcuededta —Esusën cac dapuduencuededash acte dapa quiusudacnombo comapenec niquec pudun-pudunec mentoadbudnepondash chancho nibëdquiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Adsho isash chancho pemequin isquido chiec nidanepondash. Adec nidquimbi shubu dadpen icquid uano-uanoec tabadquido chuituidac aidotsen isec cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Esus yacno cho-choshon mayan icsa dapuduedaid bëdamiosh quequin chuituidac mayan icsa dapuduedaid icboed naden isbededpondash. Dashcute dasiuidesa icboedi dasiuidash tsadsho abimbo iquec quequin isbededpondash. Aidën tantienquiocboedi tantiec tsadsho adembidi isbededoapondash. Adec tsadsho comapenen isbededequi nadatiambocquin naid nepec quetsëcquiec tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Adec tabadsho isun mayan icsa dapuduedaid bëdamequin chancho dapuduedmesho isboedon cho-choquido tantiamenuen chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aden chuisho tantiashun cho-choboedon: —Nëmbo tabadenquio yec nidec nid. Mibëd tabadtiapimbo iquebique —capondash comapenen Esus chushcaquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Adsho tantiash cano yacno nidequi cano Esus antabëdtonobien mayan icsa dadpen dapuduemboed choash: —Mibëd icte bunebi. ¿Adabi buane? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Adoaquien: —Padi. Min shubuno nidtan. Ambo nidshun mibi bëdamequin mayan icsa dadpen dapuduemeboed Nuquin Papa tantiaquin chuiban. Nuquin Papan ëbi ad icsho unësquiocquin dapuduemiac quequin chuiban —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aden Esusën chiaquien nidpondash. Nidequi shubu dadpen icquid yacno-yacnomboec nidanec nidaid Decapodis caid yacno choshon Esusën naid chuiban-chuibampondash. Aden chuiban-chuibansho tantiaquidtedi, Adopenshenda Esusën bëdamiash, quec abibi onquec tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Adshumbic canon Esusbëd icquidon padpiden abi chobocmibidi chian poteoapondash. Adec chosho isash matses dadpen chian cuëmano padpidec cho-choashun mananuc Esus pudundotsëcshobi badedquio tsucus-tsucustsëcquio yec datsidadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Adnubien Nuquin Papan chiaid chuibante shubun tabadquido isquid, Aido cuëmëdquid, chopondash. Adec choquimbi Esus istuidash mibi bëdambocquid nec quequin ismenuec Esus tauebudshun: ");
INSERT INTO mcfNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Con champi unëseque. Aid mishquin bëdamec cho —cac ");
INSERT INTO mcfNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aidobëdi Esus nidpondash. Adec nidshobi matses dadpenshun tsibanampondash. Tsucus-tsucustsëcquio yec nidquin Esus tsibanampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Esus tsibanquidquio chido utsi icpondash. Aid chido seta 12ted matamec intac budash bëdanenquiocquid icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dauë meniaqui bëdanenquio icpac caondash. Dauëchoquid utsi-utsien piucquid menequin dauë bedshun chequi bëdanenquio yec intac nuambo yampac caondash aton piucquid naimëdnubi. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Adec intac icnubi capuquin Esusën nabanaid chuisho tantianec nidquimbi matses dadpenshun tsibananubi aidëntsen tsibanampondash. Aden matses dadpenshun tsibananubi ismenquiocquin cachoc choshon Esusën dashcute mishpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aden aton dashcuteuidtsëqui mishec bëdampatsiash icmane queshun mishtsequi bëdampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Intac bëdanenquiocquid Esus mishec bëdampac caondash. Ëmbi tantiacpadquiequi bëdanobi quequin ambibi tantiapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Adec chido bëdanubien ëmbi nadatiambocquin naoc quequin tantiec amibidi bidiadquin isec Esus: —¿Tsuntsimbini mishposh? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aden chuisho tantiashun abëd icquidënquio: —Tsucus-tsucustsëcquio matses dadpen iquec, ¿tsuntsimbini mishosh, quecta ique? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Adec abëd icquid cuëdnubi onquenquiocquin, ¿Midaquidënquio mishoshibique? Isnu, abibi quequin matses utsi-utsien bëispondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aden bëisbanubi, ëmbi mishoc quenquio yec bëdamboed uëdëquec choequi mibi nadatiambocquin naquid nec quequin tantiequi Esusën taëno uebudshun abi mishec bëdanaid chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Adoaquien Esusën: —Champi, mimbi tantiacpadquiequi mibi bëdanoc. Dada icsambo icboedi nëbi dada bëdambo mibi iqueque. Bëdambo yec nid —capondash chido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aden nidmenubien Aidon shubun icquid cho-choshon: —Min champi unësoshe. Tsusio chomenda —capondash Aido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Adnubien Aido Nuquin Papan chiaid chuibante shubun tabadquido isquid caic: —Dacuëdenquiocquin ëbi tantiata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aden Aido chuishun Esusën: —Cho-choenda —capondash abi tsibanuequido chuiquin. Aden chianec Petedobëdta Acobo Uan, Acobon utsimbo aidtedi buanec Esus nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Adec nidequi Aidon shubuno choquin comapenec shubicuededsho tantiatuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aden tantiequi puduedash Esus: —¿Atotsi quec comapenec shubicuedede? Champi unësenquio yec ushacbimboec uec nec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Adshobien tantiesa icquin mamënshumbededpondash. Adoaquien aidtedi puduemiash champin tita aton papa chedo abëd icquidbëd champi yacno Esus puduedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ambo choshon mëdante mëdintanquin Esusën: —Talita, cumi —capondash. Aton onqueten, Champi, isucunash nidto, quequin adopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Adoac badedquio isucunash nidtoash capupondash. Champi seta 12ted icquid niondash. Aidi bëdansho isun abitedishun, Adopenshenda iquec quequin isbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aden champi bëdameshun Esusën: —Ëmbi naboed utsi chienda. Abimbo caimbi. Abentsëcquiobi chienda —capondash. Aden chuitanequi: —Champi peme —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Auëshquio puduanec nidequi abi icnëdacno Nasaded caid yacno Esus choapondash. Abëdi abëd icquido chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ambo tabadashic chonoadtemaid ushën Nuquin Papan chiaid chuibante shubun puduedshun Nuquin Papan chiaid chuibanquin tauapondash Esusën. Aden chuibansho tantienquiocquid abentsëc: —¿Mitsishun chuibansho tantiashun adomboen Esusën chuibampec? —quepondash. Adnubien utsi: —¿Mitsicquidën ismiac Esusën nadatiambocquin nabampec? —queoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Adnubien utsi: —Nëmbocquid, cuëte nacnenquid, Osen mado nec —queoapondash. Adnubien utsi: —Ani Madia nec. Aton utsibo nëidtedi nëmbo tabadquid nec. Nëidic Acobo, utsibic Ose, utsibic Udas, utsibic Simon. Nëmbobidi aton chibi chedo tabadoaic —quetsëcquiec tabadec onquecuededec chieshcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aden chieshënaqui Esus nadpondash: —Utsi yacno nidshun Nuquin Papan chiaid chuibansho tantiaquid dadpen icnubi abi yacno chuibansho chieshënquid aton matses iquendac. Aton shubun icquido adecbidi iquendac —quepondash Nasaded yacnocquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aido abi chieshënquid icsho isun nadatiambocquin nabantiapimbo icpondash. Ëbi bëdamepec quequin tantiaquidquio daëdpactsëc icsho mishquin bëdamepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","¿Atotsi quiash ëmbi chiaid tantiatiapimbo icpec? Adembidi nadatiambocquin nasho istiapimbo icpec quepondash Esus abibi onquec. Adashic auëshquiobi puduanec nidaniash shubu daëdpactsëc yacno puduedcuenequin Nuquin Papan chiaid Esusën chuibenepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Adec cuenadquin chuibanequi abëd icquido caic: —Cho —quetanec tabadtuidpondash. Adec tabadtuidash Esus: —Nëbi mibi daëdshun-daëdshunquien chuibanec nid. Chuibanquimbi mayan icsa dapuduedaid dapuduemeta. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nidquin dadpen mitsana sauedshun buanenda. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tapucudte sandadia caiduidtsëqui tapucudash nidaneta. Adecbidi utsi bedenquio yec mibi dasiuidaiduidtsëqui dasiuidec nidaneta. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Shubu dadpen yacno nidash mibi yuedaid shubun puduedash ambouidi tabadquin chuibanta. Auëshquio puduanec nidequi shubu dadpen yacnobidi nidshun adquiecbidi tabadquin chuibanoata. Adenuidi naquin chuibanta. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mibi yuedquid nibëdsho isash nidaneta. Auëshquio nidash shubu ënëdacno choash, Nëmbo icquido tantiate icsachoquid yec abibi cuidadtequido nec, Papa. Adquid icsho isun abi capuaid nidaid pututedi tasequequin Nuquin Papan chiacpadomboen ismeta —capondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aden Esusën chiaquien nidanepondash. Adec nidshumbic, mibi icsaid ënshun padpiden tantianu quenquiocquin Nuquin Papan chiacpadomboen nabanta quequin chuibampondash Esusën nidmiaidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Adembidi mayan icsa dapuduedaid dadpen dapuduemepondash aidëmbidi. Adembidi nënquid dadpen daicsaid chedo cuëte bacuë bëchichoquid ënë dachinquin bëdameoapondash Esusën nidmiaidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Adnubien, Chuibanquimbi Esusën nadatiambocquin nabanosh, quequin isboedon ancanquid Edodes chuipondash. Aden chuiban-chuibanac dadpenshun Esusën nabanaid tantiapondash. Aden tantiash: —Uan acten mentoanondaid mapi butemeboed uincuempash icnui. Adec uincuenshun nadatiambocquin nabanec nepanui —quecuededpondash tantiaquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Adnubien utsibo: —Ediasien nechitec. Nuquin Papan chiampicpadquiec choashien nec —quecuededpondash. Adnubien utsibo: —Nuquin Papan chiaid chuipampidien Esus yanchitash —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Adnubien Edodes: —Ëmbi mapi butemiondaid, Uan pado, uincuempash icnui —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ënden aidëmbi Uan bedmeshun tanemeshun quënën nauedmepac caondash. Aidëmbi aton utsin chido, Edodias caid, bedacsho isash: ");
INSERT INTO mcfNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","—Min utsin chido mimbi bedaid natemaid niosh —queshun Nuquin Papan Moises dada uamepampicpaden Uanën Edodes chuipac caondash. Adoac, Uanën chuisho dadpenshun tantianushe queshun Uan bedmeshun quënën nauedmepac caondash Edodesën. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Adoaquien Uan Edodiasën chieshënquin: —Uan cuesunemetiadquidi mibi nec —quepac caondash aton bënë Edodes caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Uan bëdambocquid Nuquin Papan chomiaidbidi nec queshun Edodesën Uan cuesunemetiapimbo iquec cudaspac caondash con chidon cuesunemenushe quiash. Aden tantiaquin Edodesën abi tsadacno Uan chuibamenuen chomedenepac caondash. Uanën chuibansho tantiash: ¿Atotsimbi nëid napeba? Ambi chuibanaid bëdambo iquec. Aidën chuisho tantiash bëdambo iquebi, abibi queshumbic Edodesën chomedednepac caondash chuisho tantianuen. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Adnubien aton chido bunacpadomboen Uan cuesunemete ushë chonobi naden napac caondash: Aton bënën abi tishte ushë tantiaquin abipadquid dadpen pemenuen chomepac caondash. Adembidi sondado tsusio dadpembidi chomeoapac caondash Edodesën. Cadidia yacnocquido chuiquid dapabobidi chomeoapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aden aidtedi cho-chomiash tabadnubien aton chidon champi puduedpac caondash. Puduedacsho: —Baidata —cac baidapac caondash. Adsho isash: —Bëdamboen mimbi naoc —quecuededpac caondash Edodesën chomiaido champi caic. Adec onquesho tantiashien Edodes aton chidon champi caic: —Mibi bunaid mibi menenu. Ëbi chui. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Abimbo caimbi. Mibi bunaid ëbi chuita. Mitsanatedi bunebi ëbi casho tantiashun dadpen mibi menembi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aden Edodesën chuisho tantiash: —¿Atotsibi bumpeba? —quetanec aton tita yacno puduedshun: —“Mibi bunaid mibi menenu. Ëbi chui,” Edodesën caoshi. ¿Atotsimbi chuipe, tita? —quepac caondash ani chiec. Adsho tantiashun anin: —Uanën mapi bunebi quequin chuita —capac caondash aton champi chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aden chiaquien badedquio Edodes yacno titinquec choec puduedshun champin: —Nëbimbobi Uan acten mentoanquidën mapi maspanën nandoshon ëbi mene —capac caondash anin chuibocpadomboen chuituidquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Adsho tantiash Uan tantiec unësquio icpac caondash Edodes. Adec unësquiocquin ambi champi chiacpadomboen natiapimbo iquec ëmbi chomiaido quenushe queshun adoembi abibi queshun: ");
INSERT INTO mcfNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","—Uanën mapi bec cho —capac caondash Edodesën ambi cuesuneta caid chuiquin. Aden chiac Uan quënën nauedacno nidshun mapi butanquin ");
INSERT INTO mcfNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","maspanën nandoshon bëshun champi meniac bedshun champin aton tita menetuidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Adnubien, Uan mapi butiac, quesho tantiash Uambëd icquido nidshun Uanën dada bedshun buanshun chococapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Adambic Esusbëd icquido ambi nidmeboedo Esus yacno cho-choshon ambi nabamboedbëdtabi ambi chuibamboed chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aden chuibanash tabadnubi matses dadpen cho-chonobi utsi dadpen nidanepondash. Adec cho-chonobi penquio iccuededpondash Esusbëd icquidon. Adnubien Esus: —Matses nibëdacno tabadec nidnu. Nid —quepondash abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aden chiashic cano antabëdtoanec matses nibëdacno nidpondash aidtedtsëqui. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Adec nidsho isash matses dadpen abi nidte yacno tantiec: —U nidanec —quiash titinque choec abia cho-chopondash. Abia titinquequid cuensho isash utsi-utsiec dadpen titinquec cho-choapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Adec aidtedi abia cho-choambien Esusbëd icquido choapondash. Pudundoquimbi matses dadpenshun abi cainec tabadsho isashien Esus, Abi tantiamequin Nuquin Papan chiaid chuiquid nibëdacbimboecnuc matses cho-choec quequin tantiec unësquio iquebi queshun tauain chuibampondash Esusën. Yuen chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yuen Esusën chuibanubi ushë budpondash. Ushë budsho isun abëd icquidon: —Icbo, ushë budaque. Nëmbo tiedën caniquid nibëdec; adecbidi yuedanquid nibëdec. Matses nidme. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nidmiac shubu yacno nidshun piucquid menequin ma aton pete bedpanuna penun —capondash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Adoaquien Esusën: —Mimbibi nëidtedi pemeban —capondash. Adsho tantiashien: —¿Adambi nidshun piucquid menequin panëmpi bedpe? Ma matses dadpenquio yoc —quepondash abëd icquido Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Adoaquien: —¿Panëmpi penun bëaid iccuededquidon na tedtsi iqueque? Ista —capondash Esusën. Aden chiac ashunquiobi matsesën bëaid isbanash abëd icquido: —Panëmpi sincoted icnubi nuëcquid dosted iquec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aden bësho isun: —Uasinën tabadbud mibëd icquid 50ted icnuc, utsibëd icquid 100ted icnuc quec tabadbud —capondash Esusën iccuededquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Adoac ambi chiacted-tedquiec tabadbudpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Adec tabadbudsho isun panëmpibëdta nuëcquid bedshun sananquin abuc isec: —Mimbi meniaid nec Papa. Nëbi mimbi nadatiambocquin naid ismembi —queshun cuësh-cuëshun: —Meneban —Esusën cac abëd icquidon menebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Menebanac piash: —Padi. Piombi —quecuededpondash pequido. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aden piambien abëd icquidon napi uaid bedbampondash. Napi uaid sandobanaid tsitsan 12ted icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Peboedo dada caniaid tambanac 5000ted icpondash. Aton chidon aton bacuëbobëdtambi pepondash. Aido tambanenquiocquin dadatedictsëqui tambampondash 5000ted iquec quequin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aden iccuededquido pemiashic: —Cano antabëdtoanec mibia shubu dadpen icquid Betsaida caid yacno potec nid. Mibi nidnubi matsestedi nidmembi —quepondash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Adoac canon potenubi matsestedi nidmianec matses nibëdacno macuësh yacno Nuquin Papa chuinuec Esus nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Adnubien inchëshbudtsëqui abëd icquido acte nënantanquio canon noadpondash. Ambobi noadnubi Esus abentsëqui mananuc tsadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ashunquio Esusën isaquien abëd icquido bëdiactsëcquio nidquimbi comapenen cano uncapondash cunquequid dapan bëded-bëdednubi. Adnubien cachina cuëdanabi badiadtiapimbocnoc acte bëntse choquin abëd icquido Esusën ismetuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Datantsensho isash, Mayambien nechitec, quequin ambibi tantiec sidquecuededec ");
INSERT INTO mcfNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","dacuëdcuededpondash. Adsho isumbien: —Ëbibi nebique. Dacuëdenquio yec tabadta —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aden chuitanec cano antsadtonobi comapenec cunqueboedi ënëdpondash. Aid ënëdsho isash: —Adquidshenda nepec —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Panëmpi daëdpactsëc ictsëcquid matses dadpen menebamboedën naid nec quequin tantienquiocpondash. Adembidi Esus acte bëntse capusho isun, Nadatiambocquin naquidën naidbidi nec, quequin tantienquio icoapondash pamunacbimboecquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ashunquio chian potiashic nidaid Quenesaded caid yacno choshon cano nëshpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aden nëshash mananuc pudundosho isec anocquido, Aidi bëdamianquid nec, quequin ambibi tantiaquimbi ");
INSERT INTO mcfNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","daicsaid aton ueten nandoshon Esus yacno bë-bëpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Adecbidi shubu dadpen yacno-yacnomboec Esus puduedcuenesho isun adembidi anocquidon, Bëdamequid nec, queshun daicsaido bë-bëpondash. Adoac —Min dashcute ëbi mishme —capondash bë-bëaidon. Aden ambi tantiacpaden Esusën dashcute mishash bëdancuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Adashien Edusaden caid yacnoësh padiseyobobëdi isadaidbo tsusedpabon chiaid tantiaquin chuiquido Esus yacno choshon, ");
INSERT INTO mcfNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ëmbi mishboed mishtemaid ictsiash, quesa iquec tsusedpabon chuinëdacpadquiec mëpanudabi Esusbëd icquidon pesho ispondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Padiseyobo isadaidbobidi yec tsusedpabon chuinëdacpadquiec penush mëpanudanequid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tiedën caniquid ambi piucquid menequin bedacnoësh choec adecbidi penush tsusedpabon chuinëdacpadquiec mëpanudanequido isadaidbo nec. Isadaidbo tsusedpabon naden nata quequin ambibi chuinëdaid utsi-utsiec dadpen iquec. Ambi chuinëdacpadomboen dëshotetsen cachonouidi dapanquidquiobidi nec. Adembidi matsu nacnenaid cachonouidi dapanoaquidquiobidi nec. Shocosh matsu cachonouidi dapanoaquidquiobidi neoaic. Tsusedpabon chuinëdacpadomboen naquidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aden nabanquidquio padiseyobo nec. Adquiobidi abipadquid utsibo isadaidbo tsusedpabon naden nata quequin chuinëdaid tantiaquid neoaic. Adec tsusedpabon chuinëdacpadquiec Esusbëd icquido mëpanudenquiocsho isash padiseyobo: —Atotsieshun mibëd icquidon tsusedpabon chuinëdacpadomboen nainquiocquin mëpanudabi pepec —quepondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Adoaquien Esus: —Isayasën ëndenquio dada uaquin mibitedi bëdamboen chiampidpadquid mibi nec. Ambi dada uampid nad iqueque. Tantia: “Nuquin Papa bëdambocquid nec quequin chiacpadomboen tantiesa isadaidbo nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Abia Yampidënquio Nuquin Papan nadomboen nata quequin chiaid tantiesa icquin tsusedpabon nadomboen nata quequin chuinëdaid tantiaquidquio nec.” ");
INSERT INTO mcfNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aden tsusedpabon chuinëdacpadomboen nabanquin Abia Yampidënquio chiaid niacquid mibi nec —quepondash Esus isadaidbo tsusiobo caic Nuquin Papan Isayas dada uamepampid tantiamenuec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aden chuishumbic adomboembidi chuioaic: —Badedquio Nuquin Papan chiaid chieshënquin tsusedpabon nadomboen nata quequin chuinëdacpadomboen nabanquidquio mibi nec. ¿Aden naquinda Nuquin Papan chiacpadomboen mimbi nape? ");
INSERT INTO mcfNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nuquin Papan chiacpadomboen Moisesën dada uampid nad iquec: “Titan papabëdtan chiaid chieshenquiocquin naban.” Adquidën chiaid utsi nad iqueque. Tantia: “Aton papa icsamboen chuiquid unës ua. Adembidi aton tita icsamboen chuiquid unës uaoa,” quequin Nuquin Papan chiac Moisesën dada uampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mibien tsusedpabon chuinëdaid tantiaquin adoesa nec. Papan na naimëdacsho isun naden mimbi chiec. Mibi nashunquin menetiapimbo iquebi, papa. Mibi menenquiocquin Nuquin Papa Abia Yampid nashunquin menenun ëmbi dayun uaid nec, papa, quequin mimbi chiec. Adembidi titatsen mimbi chuioaic. Aden chuiquin papabëdta tita tantiaquin nashunenquiocquin Nuquin Papan chiaid niacquid mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aden mimbi nashunenquiocquin ismiacpadec, Papa, mibi nashunquin menetiapimbo iquebi, queoaic utsibo. Adecbidi, Tita, mibi nashunquin menetiapimbo iquebi, queoaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aden chuiquimbi titabëdta papa tantiaquin nashunta quequin Nuquin Papan chiacpadomboen nainquiocquin tsusedpabon chuinëdacpadomboenuidi nata quequin chuiquidien mibi nechitec. Adembidi Nuquin Papan chiaid utsi-utsien naisa mibipadquid utsibo icmequin tsusedpabon chuinëdaid nata quequin mimbi chiec —quepondash Esus isadaidbo tsusiobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aden Nuquin Papan chiacpadomboen niacquido chiashic: —Utsibo, tantiec cho. Mibi bëdamboen chuinu. Bëdamboec papuduedta. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tsusedpabon chuinëdacpadquiec mëpanudabi mimbi piaid min tantiate icsabudtemaid nendac. Icsamboen tantiec mibi icsaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ëmbi chiaid tantiaquin utsi chuibanta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aden chiash iccuededquido abi tabadnubi shubun puduedash tabadpondash Esus. Tabadsho isash: —Mimbi chuiboed ëbitedi tantiame —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Adoaquien: —Utsitedishun tantienquio icbocpadquido mibitedi neque. Tantia. Mimbi piaidën mimbi tantiaid icsabudtiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","¿Min tantiate yacnoda mimbi piaid nidpec? Padenquio. Mimbi piaid min pucu yacno bud-budec auëshquio chimu nëncuenash puduenec —quepondash abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aden chiec onquiashic: —Mimbi tantiacpadquiequi mibi icsabudec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chido mimbi inacmaid isash chudtiadquio iquec quequin mimbi tantiacpadomboen chido isuidtiapimbocquin mimbi chudted-chudtedec. Utsin na bedtiadquio iquebi quequin mimbi tantiacpadomboen mimbi ampec. Cuesunetiadquio iquebi quequin mimbi tantiacpadomboen mimbi cuesunepec. Utsin chido chudtiadquio iquec quequin mimbi tantiacpadomboen aidi mimbi chudpec. Dada utsin ëbi bëdaidquiocsho ispec quequin mimbi tantiacpadomboen min bënëpenquio chudmequid mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Utsin bedactedi bednu quequin mimbi tantiacpadomboen bedquid mibi nendac. Adecbidi utsin bedaid isash adomboembidi bednu queshun isuidesa iquec adomboen bedbanquidquio mibi yampec. Mibibi icsambocquid nec quiash chieshëmënquid mibi nendac. Adquid abimbo chiacbimboen chuiquid mibi nendac. Icsauidi bunquin adenuidi nabanec. Mibi icsaquin ompoenquiocquin nabanquid mibi yanec. Utsi bëdambo icsho isash chieshënquid mibi icpec. Utsi icsamboen chuiquid mibi nendac. Utsin chuisho, Ëbentsëqui tantiaquidquio nebi, quequin mamënshunquid mibi nendac. Adembidi nasho mamënshunoaquidbidi mibi nendac. Ëmbia tantiaquid nebi, quequin mimbibi nabanaid icsa isash bëdambo iquec quec mibi mamënec tsadec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ëmbi chuiboedtedi icsaquidën naid nec. Aden tantiaquid icsabudte nec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Aden chiashic isadaidbo yacnoësh puduanec nidequi isadaidpembo yacno nidpondash. Shubu dadpen icquid Tido caid anoentsëqui yacno choash shubun puduedash: —Nëmbo ëbi choaid chienda —quepondash Esus. Ambi chiacpadpenquiocnoc chuisho tantiapondash anocquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Adoac: —Esus chosh —quesho tantiashien mayan icsa dapuduedaidën tita Esus tabadacno nidpondash. Adec nidec puduedequi Esus tauebudpondash chuiquid dapa nec quequin tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Isadaidpembon chido nidaid Sidopenisia caid yacnocquid niondash. Aidi Esus tauebudash: —Con champi mayan icsa dapuduedaid dapudueme, tsusio, —quepondash comapenen chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Adoaquien Esus: —Mabi con matses isadaidboba bëdamenuec choboc. ¿Bacuëbo cubudabicnubi opashëmpida pete menequin anin bënepadic? Padenquio. Adembidi, ¿isadaidbotedi bëdamiabidambi matses utsibo, isadaidpembo, bëdamepadi? —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Adsho tantiashien chido: —Icbo, mimbi bëdamboen chiec. Padnuen anin meniac bacuëbon pete sananaid cuëshëmpi paëdtsacsho opashëmpin ambibi bedshun pec. Adembidi mimbi nadatiambocquin nabanac isadaidbo dadpen bëdanubi isadaidpembo abentsëc tantiaquid yec bëdanoapec —quepondash chido. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aden chidon chuishobien: —Bëdamboen mimbi chiec. Aden tantiaquid mibi neque. Nidec nid shubuno. Mayan icsa dapuduedaid dapuduenaque. Isec nid —capondash Esusën isadaidpembon chido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Adsho tantianec choec shubun puduedquin isaquien aton champi uebocno ënden mayan icsa niquian bëdanash abi ushaidëmbi uec. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Adashien Tido caid anoentsëcuësh nidequi Sidon caid matambidanec chian Cadidia caid yacno choapondash Esus. Nidaid Decapodis caid shubu dadpen yacno-yacnomboec capucueniash choapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ambo choash tsadnubien dada icsa, pashu buëd onquenquiocquid, Esus yacno bëash tsadquin: —Nëid mishquin bëdame —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Adsho tantiashun iccuededquido ismenquiocnuen udictsëc dada icsa buanshun aton mëdante bushbi pashun pabiate pausuntanquin chicpondash Esusën. Adshun, min anatsen mishnu quetanquin ismequin uicchun mëpidadtanquin pashun ana mishpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aden amishec abuc isec: —Epata —quepondash. Paucud, quec adpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Adec Esus cuëdnubi pashu buëd onquenquiocboedi tantiadcuenash onquiampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aden pashuaid bëdamiash: —Esusën naid nec quequin chienda —quepondash Esus. Adoboqui niacbidanquin chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aden chuisho tantiash: —Adquidshenda Esus nepec. Ambi naidtedi bëdambo iquec. Pashu paucquid nec. Adembidi ana onquesa oncamequid nec —quec onquecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Adashic Esus yacno matses dadpen padpidec cho-choash yuec tabadec bundocuededpondash. Adsho isun abëd icquido chomiash Esus nadpondash: ");
INSERT INTO mcfNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Matses bunec tabadsho isash unësquio iquebi. Daëdec ushec ëbëd tabadquin aton pete uesquin piac. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aton pete nibëdsho isash, Pec nid, quetiapimbo iquebi padishnushe quiash. Ënapenuësh dadpen cho-choash nec —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Adoaquien: —Pete nibëdacno nuqui tabadec. Pemenun ¿Mitsimbo nidshumbimbi pete bedpatsia? —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Adsho tantiashien: —¿Tedtsi panëmpi mitsana iquec? —quepondash Esus. Adoaquien: —Siete iquec —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Adnubien: —Tabadbud —quetanquin Esusën panëmpi sieteted bedshun sananquin Nuquin Papa ambi pete icmiaid chuishun panëmpi cuësh-cuëshun: —Nëid meneban —cac abëd icquidon iccuededquido menebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Adembidi nuëcquid dëmishaid daëdpactsëcbidi bedshun: —Mimbi meniaid nec quequin tantiembi, Papa —queshun: —Nëidtsen meneban —Esusën cac menebanoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aden menebanac piash: —Padi. Piombi —quecuededpondash. Aden piambien napi uaid tsitsanën sandoquin abëd icquidon bedaid tsitsan sieteted icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Peboedo dada caniaid dadpen 4000ted icpondash. Chidon aton bacuëbobëdtambi pepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aden pemeshun peboedotedi nidmiash Esus abëd icquidobëd cano antabëdtoanec nidquin Dadmanuta caid yacno potepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Aden potiash tabadnubien cho-choshon padiseyobon: —¿Nuquin Papan chomiaid nebi quepecta mibi icco? Aidën chomiaid icquin nadatiambocquin nata. Isnu —capondash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Adsho tantiash, Ëbi tantiesa nec, quec unësquio yec tsadequi —Ëmbi naid dadpen mimbi ispaboc. ¿Adosho isboshida, Ëbi isme, queoape? Nadatiambocquin nabanquin ëbi isme caqui ismenquio iquembi. Abimbo caimbi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aden chianec nidec cano antabëdtoanquin uquë cuëma utsiuc poteoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Badedquio Esus nidnuesho tantiash cano antabëdtopondash abëd icquido. Panëmpi bedabi puduampondash panëmpi abentsëqui tsitsanën anuetsëcnuc. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aden potequimbi Esusën nadopondash: —Pan uanuequidën trico caid putubëdta bidiscamete acte pistsëc cacushaqui nua yec bidisquec. Adembidi padiseyobon Nuquin Papan chiaidbëdtabi ambibi tantiaquin chiaid daëd uaquin chuibanec. Aden chuiquidbidi Edodesbëd icquido nec quequin tantiata. Aden tantiaquin padiseyobopadquid adecbidi Edodesbopadquid icmane queshun ambi tantiacpadomboen nabanenda —capondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Adsho Esusën chuiboed icsamboen tantiec abëd icquido: —¿Ëmbi panëmpi bëambo yaidta icbon chuipec? —quec onquecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aden chiec onquecuedednubien tantiaquidquio icquin Esusën nadopondash: —¿Atotsi quiash ¿ada panëmpi bëambo yaid con Icbon chuipec? quepe, mibi? ¿Ëmbi nabamboed isenquio yec bëshu tsadacbimboecta tsadpo? ");
INSERT INTO mcfNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Adecbidi ¿Ëmbi chuibanaid tantienquio yec pashuacbimboecta tsadoapo? ");
INSERT INTO mcfNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Panëmpi 5ted bedshun cuësh-cuëshun menebanaqui napi uaid tsitsanën sandoaid tedtsi iccoshe? Chui —capondash Esusën. Adoaquien: —Doseted iccosh —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Adoaquien: —Adembidi, ¿nëbi siete panëmpi bedshun matsesën piaid napi uaid tedtsi tsitsanën sandoaid icposh? Chui —caoapondash Esusën. Adoaquien: —Siete iccosh —quepondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Adoaquien Esus: —¿Nadatiambocquid Esus nec quequin ëbi tantienquioda mimbi icpe? —quepondash abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Adshumbic Betsaida caid yacno poteoapondash Esusbëdtambidi. Aden potiash chosho isun bëshuaid bëpondash anocquidon. Aden bëshun ismequin: —Nëid bëshumbo neque. Mibi bëdamianquidquio icquin mishquin bëdame —capondash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Adsho Esusën bëshu mëdinanquin Betsaida caid anoentsëqui buanshun uicchun bëcuishtuatanquin bëmishec: —¿Ada mimbi iseque? Ëbi chui —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Adsho tantiash Esus isquin: —Bëdamboen isenquiocquin cuëte podo inchëshquio yacbimboecnuc mibi isembi —capondash bëshuaidën. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aden chuishobi Esusën bëshuaid padpiden bëmishoaquien bëucudquiopondash bëdamboen isec. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aden bëdamboen iso isun: —Nëbi min shubuno nid. Shubu dadpen icquid Betsaida caid datambidanec nid —quequin Esusën nidmepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Aden nidmiashic ancanquid Uedipo caid tabadaid nidaid Sesadeya caid yacno nidequi: —¿Atotsi Matsesën ëbi capec? —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Adoaquien: —Utsi-utsiec, Acten mentoamboed, Uan Esus nec, quenubic; utsi-utsiec, Edias, Nuquin Papan chiacpadomboen chomiaidien Esus nechitec, quenubic; utsi-utsiec, Nuquin Papan chiaid ëndenquimbo chiampidpadquidien Esus nechitec, quec —quepondash abëd icquido Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Adsho tantiashun: —Ma mibitedishun ¿atotsibi cai? —capondash Esusën. Adoaquien: —Quidistu, Nuquin Papan ambi tantiampicpaden abi yacnoshon chomiaidquio mibi neyoc —quepondash Petedo abëd icquid utsibo onquiacbimboen chuioaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Adsho: —Mimbi chuiboed utsi chienda. Abentsëcquiobi chienda —capondash Esusën abëd icquido comapenen chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aden chuishun abi unës uate tantiamequin abëd icquido Esusën chuipondash. Nuquin Papan chomiaid yec matsesacsho isadaidbo tsusiobon chieshënquin ëbi mëyanendac. Aden mëyanquin unës uaqui daëdec ushash uincuenoaindabi, quequin Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Abi unës uatequid chuipecshenda niondash. Aden Esusën chiaquien aidbëdtsëqui uano nidshun Petedon: —Aden tantiaquin chienda —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aden Petedon chuisho tantiash aucbidi bidiadquin abëd icquid utsibo isec Esus nadpondash: —Nidec nid, Satanas. Nuquin Papan tantiacpadpenquiocnoc ëbi niacmenuequin icsamboen chuiquid mibi neque. Satanasën mua uac matsesën tantiacpaden mimbi tantiec —quepondash Esus Petedo comapenen chushcaic. Petedo Satanasbimboecquid nec quequin Satanas capondash Esusën Petedo chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aden Petedo chuibanashic abëd icnuec cho-choquid utsibo caic: —Cho —quepondash Esus. Chosho isash: —Esuspadquid icnu queshun mibi bunaid nainquiocquin ëmbi chiaid tantiaquin nabanta. Ëbi mëyanacpadembidi mibi mëyante icnuc niaquenda. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Esus tantiaquin ambi chiacpadomboen nanu queboedi unësmane quequin naisa Nuquin Papa yacno puduedtiapimbo iquendac. Esus tantiaquid nebi quequin tantiec mëyante icnuc unësmane quenquiocquin ëbi chuibanec tabadquid Nuquin Papa yacno tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aden aton na dadpen bedbanashic Esus tantiesa yec unësash Nuquin Papa yacno puduedtiapimbo iquendac. ¿Adquidta bëdambo icpadic? ");
INSERT INTO mcfNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Nuquin Papa mitsana menecta abi yacno puduedpatsia? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Utsi icnubi dacuëdec Esus tantiaquid nebi quesa chido aton bënë bunenquio yec dada utsibëd tabadquidbimboecquid nec. Adquid chuiquin, Con utsi nec, caisa nendabi. Adembidi ëmbi chiaid chiesa caic, Con utsi nec, quequin Nuquin Papa chienquio iquendambi. Chuiquid dapa abipadquidquio con pan ëbi icmiac ëmbi abucshun uaido mayan bëdabobëdi nidaidën choaindabi. Adec aidobëdi choashun ëbi chieshënquid isec, Con utsi nec, queoatiapimbo iquendabi —quepondash Esus cho-choquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aden chiashic Esus: —Nëbimbobi tabadquid ëbi tantiaquid utsi-utsiec unësabicquin nidaidën tabadquin Nuquin Papan nadatiambocquin nabanaqui Nuquin Papan shubun icquid abi tantiaquid utsi dadpen yansho isendac —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aden chuibanashic 5ted ushash: —Nidnu. Nid —quianec Esusbëd Petedo, Acobo, Uan, aidtedi ambi chiactedi macuësh dapa yacno nidpondash. Ambo nidash tabadquimbi abi bëdambo isadaid aidon ispac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Abi dasiuidaid dashcute icboedi nac-nacquio yampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Edias, Moises, aid daëd ënden yampidi Esusbëd onquesho ispac caondash Esusbëd choboedon. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aden isequi: —Chuiquid Dapa, nuquibi nëmbo choash tabadquin mibi isec bëdambo iquebi. Min shubumpi 3ted icnuc shubu uanuna mitsana, Moisesën na, Ediasën na, aidted icnuc —quepac caondash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","¿Atotsimbi chuipe? quetiapimbo yec dacuëdcuededquin aden chuipac caondash Petedon. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Adec tabadshobien abu ushu choquidën ambo tabadquidtedi bëtimpac caondash. Aden bëtinacnoëshquiobi Esus chiec onquiampac caondash: —Esus, con madombo con dayunquiocquid nec. Adquid icquin chuibansho bëdamboen tantiata —capac caondash Nuquin Papan. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Adsho isbanquin isaquien Esusbëd choboeduidi icoapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Adanec macuësh yacnoësh budtanequi: —Mimbi isboed nëbi chienda. Ëbi Nuquin Papan mado matsesacsho unësmiac ëbi uincuenan mimbi isboed chuita —capac caondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Adsho tantiash utsi chienquio yec abi uincuemete ¿mitsipadquio icpec? quec abibi onquecuededpac caondash Esusbëd choboedo. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Adec onquecuededash: —Nuquin Papan chomiaidquio choabicnuc Ediasba choendac quequin tsusedpabon nadomboen nata quequin chiaid tantiaquidon chuibanec. Ma Edias ëndenquimboshë chopampic —quepondash abëd icquido Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Adoaquien: —Ai, Ediasën matses bëdamboen tabadmenuen chiampidpadquidba choendac quequin Nuquin Papan chiaid nendac. Adembidi Nuquin Papan chomiaidquio yec matsesash nëbi tabadsho matsesën chieshënquin mëyanendac quequin chuipampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ediasën chiampicpadquiec Uan acten mentoanquid chopondash. Aidi choacsho abi bunacpadomboen abi chieshënquidën mëyanac. Ëndenquimboshë Edias chiec onquequin dada uampicpadomboen Ediaspadquid chomiaid Uan choshon, Mibi icsaid ënta, quequin chuisho abi chieshënquidën mëyanondash —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Adec onquetanec choquin isquien matses dadpenshun abëd icquid utsibo Esusën niamboed tsusedpabon nadomboen nata quequin chiaid tantiamequidon comapenec onquecuededquin bëtimpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Adnubien Esus chosho isash iccuededquido, Bëdamianquid choec. ¿Atotsi aidën napatsiashe? Isnu, quetanec titinque choec: —¿Ada cho? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Adoaquien: —¿Atotsi quec ëbëd icquidbëd comapenec onquecuedede? —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Adshobien: —Chuiquid Dapa, mibi ismenuen con mado bëombi. Mayan icsan buëd oncamenquio yaid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aid Mayan icsan comapenen nebudteniac ëcbacush-ëcbacushpambo yec uedeniosh. Adecbidi, uebudash unësanec shëta chëquëdëshcaic uiosh. Adquio yanesho, Bëombique. Bëdame, cauidombi mibëd icquido chuiquin. Adoaqui bëdamenquio iccosh —quepondash mayan icsan buëd onquetiapimbo icmiaidën papa. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aden chuisho tantiash abëd icquido caic: —Esus nadatiambocquid nec quequin ëbi tantiesa mibi nepec. ¿Tedectsi icshun ëmbi chiacpaden mimbi tantiabempe? Mibi tantiesa icsho ¿mitsipadembimbi tantiamepe? —queshumbic: —Madompi bec cho —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Adsho tantiashun bëpondash. Bëshobi Esus istanquin mayan icsan abi dapuduedaid comapenen cuididicamiampondash. Aden nac madompi uebudec ëcbacush-ëcbacushpambo yec cuididiquepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Adsho isash: —¿Tedtsi seta matamec ad iccondashe? Chui. Tantianu —quepondash Esus madompin papa chiec. Adoaquien: —Bacuë ictsequi ad iccondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Cuëte dëtsiadoaid nënedeniosh abi dapuduedaidën. Actetsen nënedeniosh unësmenuequin. Mibi bëdamequidquio icquin ëbëdta tantiaquin ëbi con mado bëdameshun —quepondash madompin papa Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Adoaquien: —¿Mibi bëdamequidquio icquin ëbi con mado bëdameshun quecta ique? Nuquin Papa nadatiambocquin naquid nec quequin tantiaquidën tantiacpadomboen Nuquin Papan naindac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Adsho tantiash: —Tantiembi. Ëmbi abimbo tantienquiocsho isun ëbi tantiame, Icbo —quepondash madompin papa Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Adsho tantiashun matses dadpen titinquec chosho isun mayan icsa chuiquin: —Matses buëd oncamenquiocquid mibi nec. Adembidi tantiametiapimbo icmequidbidi mibi neque. Ambo tabadenquio yec dapuduen —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aden chiaquien sidquec madompi cuididiquenubi dapuduempondash. Adnubien unësacbimboec madompi uesho isash: —Unësosh —quepondash isquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Adnubien madompi mëdintanquin Esusën uëtsëndopondash. Adoac abembi nidtopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Adnubien shubun puduedacsho: —¿Atotsieshumbimbi mayan icsa dapuduemetiapimbo icpo? —quepondash abëd icquido Esus caic utsibon tantienquiocnobi. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Adoaquien Esus: —Dapuduen quequinuidi chuibudaqui adquidquio dapuduenesa nec. Ma Nuquin Papan nadatiambocquin napanuna quequin Nuquin Papa chuideneshun mayan icsa dapuduen cac dapuduenendac —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Aden chianec nidaid Cadidia caid matanec nidpondash. Nidquimbi, Ëbëd icquid 12tedtsëqui chuibanu, quec utsibo ismenquio yec nidpondash Esus. Aden chuibanec nidequi: —Nuquin Papan Madombo matsesacsho bedendac. Aden bedshun meniac cuesuniac uincuempendac —quepondash Esus. Abi uincuentequid chiecshenda adec Esus onquepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aden chuisho bëdamboen tantienquio yequi dacuëdec ëbi bëdamboen tantiamequin chui quetiapimbo icpondash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Adanec shubu dadpen icquid Capednaun caid yacno Esus choapondash. Adec choash shubun puduedshun: —¿Podquedën choec atotsi chiec onquecuededo? —capondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Adsho tantiash cuëdenquiocpondash abëd icquido. ¿Esusbëd icquid mitsicquid chuiquid dapa icpeque? Tantianu, quec onquequin ambi chiaid chienquio yec tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Adec tabadnubi abi tsadacnoëshi: —Cho —quiampondash Esus abëd icquido caic. Aido choacsho isash: —Chuiquid dapa ëbentsëqui icnu quequid utsi nashunquidbidi ictiad —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Adec onqueshumbic bacuëmpi abentsëc mëdintanquin abëd icquid tabadacno nënantanquio tsadumbudpondash. Aden tsadumbudshun bacuë icuquequi: ");
INSERT INTO mcfNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Esus tantiaquid nebi quequin ismequin bacuë yuedquin nashunquid ëbi yuedquin nashunacbimboecquid nendac. Ëbi yuedquin nashunquid ëbi chomiondaid Nuquin Papa yacno yuedquin nashunoacbimboecquid neoaindac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Adnubien utsin naid chiec Uan onquedopondash: —Icbo, mimbi chiacpadomboen utsin chuisho tantiapombi. Aidën: “Esus nadatiambocquin naquidquio nec, quequin tantiembi. Aden tantiaquin aidën chiacpadomboen mibi chiembique. Dapuduen,” cac mayan icsa dapuduemposh. Adosho isun, Esusbëd icquidpenquio mibi neque. Adenda quequin chuipombi —quepondash Uan. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Adoaquien Esus: —Padicnuna. Nadatiambocquin naquidquio Esus nec quequin abimbo tantiaquin ëmbi nacpadomboen nabanquidën ëbi icsamboen chuitiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nuqui chieshënesa nuqui bëdamboen chuibanquid adquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Abimbo chiembique. Tantia. Esus tantiaquid nec quequin mibi nashunquid Nuquin Papan cuidnanquin bëdamboen naoaindac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Abi Esusën onquequin chuibanec: —Adembidi abi icsacpadomboen bëdamboen tantiabenabicquid ismequid Nuquin Papan comapenen cuidendac. Adquid abi icsacpadomboen ismiabicsho cuënote yuëmbocquidbëdta tëtaneshun acte dapa nënepatecnëdan. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Adembidi mimbi icsamboen tantiaquin mishaid ëntiapimbocquin ismedeniac adomboembidi utsin tantiec. Bednu quenquio yec mëtaniacbimboec tsad ënëdenquio yec chian anëdënquiacno nidmane quiash. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Adecbidi capuquin mibi icsaid mimbi ismebeneque. Capunu quequin tantienquio yec tateshuniacbimboec tsadta ënëdenquio yec chian anëdënquiacno nidmane quiash. Adec mibi tsadnuc adquiecbidi mimbi ismiaid tantiec tsadendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Adecbidi ëshën isec mibi icsaid ëntiapimbocquin mimbi ismedoniac adomboembidi utsin tantiec. Ëshë chicshuniacbimboec tsad ënëdenquio yec chian anëdënquiacno nidmane quiash ma mibi tsadacpadec mimbi ismiaid tsadoapanu. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Icsa uadenequin ënenquio yash unësash chian anëdënquiacno nidash unësenquiocshobi chodquiaid pequid macun mibi pendac. Ënëdenquio yec chian anëdënquiacno mibi tabadendac. Icsadenequin ënenquiocquid comapenen cuidtequid nendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sa casecac pambid batambo yacbimboec Esuspadquid icnu quiash mibi icsaid ënëdnuen mëmunec mibi bëdambo yampec. ");
INSERT INTO mcfNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sa batambocquid bëdambo iquec. Sa batambocboedi batapenquio yec icsasho ¿mitsipadentsi batambo icmeoapec? Sa batambocquid casecac daëdash batambo yacpadec utsibëd bëdamboec tabadta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aden abëd icquido chuiquin nainashic Esus aidobëdi nidaid Cadidia caid yacnoësh nidquin nidaid Udeya caid yacno matambidanec nidquin acte Odan caid potepondash. Ambo choash tabadsho isash padpidec matses dadpen cho-choapondash. Adec cho-chosho isun Nuquin Papan chiaid chuibanoapondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Adecbidi cho-choquid padiseyobon Esus Nuquin Papan chiaid icsamboen chuinu queshun: —Aton chido bedash bunenquio yanshun cuemec. ¿Aden naicta bëdambo iqueque? Tantianu. Chui —capondash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Adoaquien: —¿Atotsi quequin Moisesën chuipampic? —queoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Adoaquien: —Aton chido bedash bunenquio yanshun, Con chido icsambocquid nec, quequin ambi tantiacpaden aton bënën dada uashun nidmiacsho isash, Padi, quenquiocpampic Moises —quepondash padiseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Adoaquien Esus: —Nuquin Papan chiaid tantiesa tsusedpabo yansho isash, Padi. Adenda, quenquio Moises icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nadomboen Nuquin Papan tauapampic. Dada abentsëc uashumbic chido abentsëcbidi uashun dada menepampic. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adomboembidi nanuec dada aton tita aton papabëd tabadenquio yec aton chido bedash abëdi ambi quënë uaidëmbi tabadec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aden aton chido bedash tabadequi matses abentsëc icboedi daëdec. Matses daëd icboedi abentsëc yacbimboec tabadec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aden dada aton chidobëdta Nuquin Papan daëd uacsho ma cuëshëdmenquio icpanuna —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aden chiash shubun puduedacsho: —Mimbi chuiboed ëbitedi tantiame —capondash abëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Adoaquien: —Aton chido bedshun chudshun nidmeshun chido utsi bedquid Nuquin Papan menepampid niacquin tantiesa nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Adembidi chido aton bënën bedac aton bënë nianshun dada utsi bedmequid Nuquin Papan menepampid niacquin tantiesa neoaic —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Adnubien: Con bacuë mishquin Esusën bëdambo icmetsiash, quequin Esus yacno aton bacuëbo anin bë-bëpondash. Aden bë-bësho isun: —Padi. Esusën naid utsi neque. Bacuëbo buantan —capondash Esusbëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aden nidmesho isash nëishash: —Bacuëbo nidmenda. Ma cho-chono. Anin chiacpadomboen tantiaquidquio bacuëbo neque. Adomboembidi badedquio Nuquin Papan chiaid tantiendac. Nuquin Papan shubu abentsëquën tabadquid aido nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Abimbo chiembique. Tantia. Nuquin Papan chiaid bacuëbon badedquio tantiacpaden tantiesa Nuquin Papa yacno puduedtiapimbo iquendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aden chuitanquin bacuëbo dayumbanquin mamishec, Nëid bacuë bëdambo icme, Papa, quequin Nuquin Papa chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aden bacuëbo chianec auëshquio puduanec nidshobien dada abentsëc titinquec choquin bëquedtanec danëshën sebudash tsadec: —Chuibanquin tantiamianquid, bëdambocquid mibi neque. ¿Nuquin Papan shubu abentsëquën tabadnuequin atotsimbi napeba? —quepondash choboed Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Adoaquien Esus: —¿Nuquin Papabëdtabidabi mibi bëdambocquid nec, ëbi cape mimbi? Nuquin Papauidtsëqui bëdambocquidquio nec ");
INSERT INTO mcfNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","—quequin chiec abi onquec: —¿Nuquin Papan nadomboen nata quequin dada uamiampidtedi nabanquidta ne? Aidtedi mimbi tantiapec. Nad iqueque. Tantia: “cuesunianenda; adembidi min chidouidi chudquid icta; adembidi, ampenda; adecbidi, utsi chiec muainda; adecbidi, utsin na bedesabimboec muainda; adembidi papabëdtan titan chiaid chieshënenda.” ¿Aidtedi Nuquin Papan dada uamiampid nabanquidta ne? —quepondash Esus choboed caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Adoaquien: —Abimbo chiembique. Tantia, Icbo. Aidtedi nabanquidquio nebi. Bacuëctsëc icquimbi adquid nabanondambi ënenquiocquin —quepondash choboed. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Adsho tantiash, Aidbëd icte bunebi, quequin ambibi tantiec Esus nadpondash: —Nuquin Papan chuiquin dada uamiaid nabanec mibi nec. Ambi dada uacmaid iquec. Aidi mimbi nabi iquec. Nadquid iqueque. Tantia. Min shubuno nidshun mitsana mimbi tantiaidquio menebanquin piucquid bedshun aton na nibëdquid meneban. Aden menebanash Nuquin Papan chiaid tantiaquidquio mibi iquendac. Adec Nuquin Papa tantiaquidquio yec ëbëd iquec cho —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Adsho tantiash choboed mamënenquio yec unësquio yec nidpondash con na menebantiapimbo iquebi quiash. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Adec nidsho isun abitedi bëisbanec Esus: —Aton na dadpen icquidën, Con na tantiequi Nuquin Papan shubu abentsëquën tabadnu, quequin tantiauidtsec. Adquid Nuquin Papan shubun puduedesa nec —quepondash abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aden Esusën chuisho tantiash, ¿Abimboda capec? quequin ambibi tantiec abëd icquido otacquio tabadsho isec Esus: —Abuido, Nuquin Papan shubu abentsëquën matses badedquio puduedtiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Adembidi shëcuën puduedte nidaidën capuquid dapan badedquio tantiatiapimbo iquec. Puduedquin ismiac puduedec. Adembidi Nuquin Papan shubu abentsëquën puduedmianquid matsesën badedquio tantiatiapimbo iquec. Ambi tantiacpadequi puduedte bunec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Adsho tantiash abëd icquido, ¿Abimbobida capec? quetsëcquiec onquecuededpondash. Adec tabadequi: —Ambi tantiacpadequi puduedtiapimbocnoc ¿tsutsi puduedquid icpeba? —quepondash abëd icquido Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Adoaquien comapenen bëisec Esus nadpondash: —Ambibi tantiaquin naquid Nuquin Papan shubu abentsëquën puduedtiapimbo iquec. Matses abibi puduedtiapimbocnoc Nuquin Papambien abi yacno yuedanquid mibi tantiamendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aden chiaquien Petedo nadpondash: —Chuinu. Tantia, Icbo. Mibëd icnu, quequin abitedi nianondambi. Adembidi mibëd icquid utsibon abitedimbo nianondash. ¿Atotsi ëbitedi menetsia? —quepondash Petedo Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Adoaquien: —Abimbo chiembique. Tantia. Esusbëd icnu queshun Nuquin Papan shubu abentsëquën tabadte iquec quequin chuinuequidën aton shububëdta nianquin aton shubun icquid aton tied chedobëdta nianendac. Adquid ambi nianëdaidtedimbocsho ");
INSERT INTO mcfNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","daëd uaquin Nuquin Papan menendac. Nëbi shubu utsin-utsinquiec mibi puduedcuenec. Adecbidi Nuquin Papan shubu abentsëquën tabadquid abi tantiaquido mibëd icquid dadpen iquec. Adquid icnuc mibi chieshënquidbidi iquendac. Yuecash ënëdenquio yec Nuquin Papan shubun mibi tabadendac mibi chieshënquid nibëdacno. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nidaidënshun chuiquid icboedi Nuquin Papa yacno tabadquin utsi nashunquid mibi iquendac. Adecbidi nidaidën tabadquin nashunquid icboedi Nuquin Papa yacno tabadquin chuiquid iquendac. Nashunesa yec chuiquid icboedi Nuquin Papan shubun puduedash utsi nashunquid adquid iquendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aden chianec Edusaden caid yacno podquedën nidec Esus bëyucanec nidpondash. Edusaden yacno padpidec choacshobini bedshun unës uaic quequin chiashi, ¿Dacuëdenquioda ambo Esus nidoapec? quetsëcquiec abëd icquido tsyuec nidanepondash. Adnubien abi tsibanquid utsibo dacuëdecbidi nidanepondash. Adnubien: —Ëbëd icquidouidtsëqui padpiden chuioanu —quiash Esus nidtuidshun cho-chosho isquin naden abi mëyante chuiquin tauapondash: ");
INSERT INTO mcfNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Chuinu. Bëdamboen tantia. Nuquibi Edusaden yacno nidec. Ambo nidacsho ëbi bedshun ëbi matsesaid Nuquin Papan madombo isadaidbo tsusiobo menendac. Aden meniac icsaquidbimboecnuc ëbi icsamboen chuibanec onquecuededash, Icsambocquid Esus nec. Unës uamequimbien ictiad, quendac ëbi caic. Adec onqueshun ëbi buanshun isadaidpembo ancaquid ëbi meneoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aden meniac bedshun aidon ëbi oncain mamënshumbededquimbi dacuishtuashumbi cuestanquin buanshun ëbi unës uaindac. Aden unës uac daëdec ushash uincuenoaindabi —quepondash Esus abi uincuente ambibi chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aden chiaquien Acobo Uambëd Esusën dayuntsëqui choash: —Mibi chuinu. Tantia. ¿Ëbi daëdshun chiacpadomboen ëbi daëdi nashunenquioda mimbi icpe? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Adoaquien: —¿Atotsimbi mibi nashuneque? Ëbi chui. Tantianu —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Adoaquien: —Abuc nidoash chuiquid dapambo mibi icquin utsi ismequin min dayunquio ëquë tsadumbudcuenquin ëbi daëdi tsadunta —capondash Uanën Acobobëdtan Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aden aid daëdshun chiaquien: —Tantienquiocquin mimbi chioc. Icsaquid matsestedi nec, quequin Nuquin Papan aido cuidenquiocquin ëbi aton madombo bëdambocquidded cuidendac. ¿Ada ëbipadquid mibi icpatsia? —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Adoaquien: —Ai, adquid tantiembi —quepondash. Adoaquien: —Ai, adomboembidi mimbitsen tantiendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aden chiec abi onquec: —Abuc nidash chuiquidquio iquec con dayunquio ëquë tsadbudcuenec tsadec cho, quetiapimbo iquebi. Nuquin Papambien ambi tantiaidquio aden chiendac. Ëmbi padenquio iquec —quepondash Esus Uambëdta Acobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aden Esusën chiaqui abëd icquidquio utsitedi Acobobëdtan Uanën chuiboed tantiash nëishcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Adec nëishash tabadsho isash: —Cho —quepondash Esus. Aden chomiash: —Utsi namequid isadaidpembo nec quequin mimbi tantiec. Aidon matses utsi yuaquin mëyanquin namebanec. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aden namesa mibi nec. Chuiquid dapa icnu quiash utsi nashunquid icta. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Adecbidi tsusio icnu quiash yuabimboe yec utsin namiaid icta. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Adquid icnuec Nuquin Papan madombo matsesash nidaidën tabadobi. Ancanquid iquenquio yec nashumënquidquio nebi. Adquid yec matses icsaid bedshunash ëbided cuidadec unësendabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aden chiashic Edico caid yacno chonobi abi tsibanquid utsibo dadpen cho-chopondash. Ambo tabadash abitedi puduampondash. Puduanash nidquin isaquien bëshuaid, Timeyon mado, Badtimeyo cuëmëdquid podqued cuëman tsadpondash. Piucquid bednu quequin cainec podqued cuëman tsadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ambo tsadquimbi, Esus Nasaded caid yacnocquid choec, quequin utsin chiac: —Esus, Chuiquid Dapa, Dabidën madon, ëbi tantiaquin nashun —quequin chiec cuëdpondash bëshuaid. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Adec cuëdsho tantiashun: —Esus cuënenquio yec otacquio tsad —cabededpondash utsibon. Adnubien: —Chuiquid Dapa, Dabidën madon ëbi nashun —quepondash bëshuaid comapenec cuëdoaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Adoac nidtuidshun Esusën: —Cuënquid chome —capondash. Adoaquien: —“Chome,” queque. Nidtoash nid —capondash utsibon. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Adsho tantiash bëshuaid aton dashcute bëntsecquid chicanec badedquio nidtoanec Esus yacno chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Adec chosho isun: —¿Atotsimbi mibi nashumpeba? —capondash Esusën. Adoaquien: —Iste bunebi, Icbo —quepondash bëshuaid. ");
INSERT INTO mcfNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Adoaquien: —Esusën ëbi bëshuaid bëuquec quequin mimbi tantiacpadquiec mibi bëdanoque. Nidec nid —Esus quenubi isbenquiopondash bëshuaidën. Adec bëdanshun Esus nidsho isun tsibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Adec nidequi Edusaden anoentsëqui Esus chopondash. Edusaden anoentsëqui Bedpaque caid icpondash. Edusaden anoentsëcbidi Betania caid icoapondash. Aidtedi macuësh Odibos caid potsembo icpondash. Ambo choash ëbëd icquid daëd shubuno nidmenu quequin tantiec nadpondash Esus: ");
INSERT INTO mcfNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Në shubu dadpen yacno nidec nid. Ambo nidshun cabayobiecquidën bacuë caniabictsëcquid tënëshac tsadsho mimbi istuidendac. Aidi matses catsadabicquid neque. Aidi istuidshun tënëshaid tëchicshun sananquin bëta. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aden bedsho isun, ¿Atotsi canun aid bede? cac, Bëoaimbi. Nëid nuquin icbo bunaid nec, cata. Mimbi aden chiac, Buanec nid, quendac —quepondash Esus abëd icquid daëd chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aden Esusën chiaquien abi daëdi nidpondash. Adec nidanequimbi cabayobiecquid caniabictsëcquid shubu shëcuë cuëmano tënëshac tsadsho istuidshun tënëshaid tëchicpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Aden tënëshaid tëchicsho isun: —¿Mitsipaden tantiaquin ëmbi tënëshaid mimbi tëchiqueque? Tantianu. Chui —capondash anocquidën. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Adoaquien: —Tënëshaid tëchicshun bëta, con icbo quebocpaden naimbi —capondash tëchicquidën. Adoaquien: —Buanec nid —queoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Adoac Esus yacno buampondash. Aden bëshun aton dashcute bëntsecquid chicshun cabayobiecquid capucpondash ma chuiquid aidën catsadtonoeshun. Adoaidën Esus catsadtopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Adembidi chuiquid Esus nec quequin ismequin utsibontsen aton dashcute bëntsecquid chicbededshun podqued ansambampondash ma chuiquid dapa bëdambocquid capunueshun. Adembidi tantiaquin utsibon budëdbiecquid podo tebededshun podqued ansambanoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aden ansambanash matses dadpen bëyucanec nidanenubi Esus nënantanquio nidnuc aidtedbidi tsyuec choquin tsibambëpondash. Adec abitedi nidanec Esus tantiec nadec cuëdëncuededpondash: —¡Adeduya! Nuquin Papan bëdambo icmiaid ambi tantiacpadomboen chuitanta quequin chomiaid nec. Tsusedpa chuiquid dapa, Dabid cuëmëdquidën tsyuecquid, shubu abentsëqui tabadquido chuiquid dapambo choec nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ëbi chuiquid dapa Nuquin Papan abuc tabadquidën chomiaid Esus nec. Nuquin Papa bëdamboshë iquec. ¡Adeduya! —quec cuëdëncuededpondash Esusbëd nidquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Adec cuëdëncuededequi Edusaden yacno cho-chopondash. Choashic Nuquin Papa tabadte shubu uashunaid quënë dadpen yacno nidash Esus puduedpondash. Adec puduedshun abitedi isbanash ushë budtsambi Betania caid yacno nidaneoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Abadiadtsashi Betania yacnoësh nidanec Esus bundopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Adec bundoshombi cuëte icueda caid podo buntac-buntacpambo ancuenquio nidsho istuidec Esus: —Icueda podo buntac-buntacpambo podoash nideque. Isbono. ¿Bacuëashida neque? —quianec nidpondash. Adec nidquimbi icueda podouidquio icsho ispondash. Ushë utsin bacuëtiadquidi bacuëabi podopac. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ad icsho isun Esusën: —Adequi bacuëesa icsho ma matsesën chenquio icpanuna —capondash. Aden chuisho tantiapondash abëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aden cuëte chuibëtsenec choequi Edusaden yacno choapondash. Ambo choashic Nuquin Papa tabadte shubu uashunaidën puduedoapondash. Adec puduedshun piucquid bedquin piucquid sanaid cuestetedi bidiacbanquin piucquid bednun nidaidën capuquidbëdta podochoquid chedo menebanquidën tsadtetsen nebudquin icbotedi puduemebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aden puduemeshun Nuquin Papa tabadte shubu uashunaid nasiadquin aton na buansho isun: —Nuquin Papa tabadte shubu uashunaid neque. Adec nasiadec capuenda —capondash Esusën chushcaquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aden chushcashic: —¿Ëbi tabadte shubu uashunaid matsesën ëbi onquianete shubu iquendac, quenquioda Nuquin Papa icpampic? Aden Nuquin Papan chiaid tantiesabimboecquin muaquin piucquid bedte shubu mimbi icmiayoc —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aden Esusën chuisho tantiash, Icsambocquid Esus neque. Unës uatiad, quequin ambibi tantiabededec isadaidbo tsusiobo tabadcuededpondash. Utsiboen: —Chuiquid dapan chiacpadomboen Esusën chiec —quepondash. Adsho tantiash, Esus bednu, quetiapimbo yec dacuëdcuededec tabadpondash isadaidbo tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Adnubien inchëshbudtsëqui Edusaden yacnoësh nidoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Abadiadtsashi Edusaden yacno nidoaquimbi cuëte icueda caid bidiquiacsho istuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aden istuidash Esusën icueda bacuëesa chiaid tantiec Petedo: —Cuëte bacuëabicsho mimbi chuiboed bidiquiaye. Is, Icbo —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Adoaquien Esus: —Nuquin Papa nadatiambocquin nabanquid nec, quequin tantiaquiota. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Abimbo chiembique. Nuquin Papa nadatiambocquin nabanquidquio nec, quequin abimbo tantiasho isun mimbi chiacpadomboembidi naindac. Aden tantiaquin mimbi nëid macuësh cain, Mananuc tabadboedi adquiecbidi acte nantan tabadoata, mimbi cac nëid macuësh acte nantan tabadoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ëmbi chiacpadomboen Nuquin Papan naindac, quequin abimbo tantiaquin mimbi chuisho tantiashun Nuquin Papan adomboembidi naindac. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aden Nuquin Papa chuinush mibi utsin icsambocquin naid tantienquio yec bëpiscudta. Adsho abucshun isash Nuquin Papan mimbi icsa uanquin naid tantienquio yec bëpiscudendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Adenquio mibi icsho isun Nuquin Papan mibi icsa uanaid bëpiscudenquiocquin mimbi chiaid tantiatiapimbo iquendac —quepondash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Adashic padpidec Edusaden yacno choapondash Esus. Adec choash Nuquin Papa tabadte shubu uashunaidën puduedash capusho isash isadaidbo tsusiobo: ");
INSERT INTO mcfNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Mitsicquidën chuibanta cac chuiquid dapabimboecquin mimbi chieque? Tantianu. Chui —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Adoaquien: —Adembidi ¿Atotsi tantiaquin mimbi chuipe? Chui. Tantianu. ¿Matses mentondaidën, Uan padon Nuquin Papan chuimiacpadomboen nabanquinda nadiondash? Padenquio, quequin, ¿Ambibi tantiacpadomboen Uan padon naondash, quequinda mimbi tantiapeque? En chui. Tantianu. Aden mimbi chiac ëmbitsen mibi chiembi —capondash Esusën tsusiobo chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aden Esusën chuisho tantiash udictsëc nidash isadaidbo tsusiobo onquec nadcuededpondash: —Nuquin Papan tantiamiacpadomboen Uan padon naondash, nuqui quesho tantiash, ¿Atotsieshun aidën chiaid tantienquio icconda? quetsiash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naden Uan padon ambi tantiacpadomboen naondash, nuqui quesho tantiashun, ¿atotsi napatsiash Uanën chuisho tantiondaidon? Aidon, Nuquin Papan chuimiaid Uan pado niondash, quequin tantiabededquin nuqui cuënoten seshunetsiash —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aden chiec onquecuededashic —¿Tsuntsin tantiamiacpadomboen Uan padon nabampondash? quequin tantienquio iquembi —quepondash isadaidbo tsusiobo Esus chiec. Adoaquien: —¿Tsuntsin tantiamiacpadomboen Uan padon nabampondashba? quequin mimbi chienquio yacpadembi ëbi chuiquin tantiamequid mibi chienquio icoaimbi —quepondash Esus abi chieshënquido isadaidbo tsusiobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aden chiashic, isadaidbo tsusiobon nacpadomboen naid nec quequin tantiec utsi chiacbimboec Esus nadpondash: —Chuinu. Tantia. Icbon aton tiedën uba caiduidquio nitsinshun cueste bënitsinaidën otadnidec cuidian-cuidianec dadpen bacuëec. Sinash didiesho icbon bedec. Aid nitsinshun icbon daquënë uaic. Aden daquënë uashun yuecshun uba ënë chinun tsuc-tsucte nacnemposh. Aden nacnenshun uba ampenushe queshun isec tabadte shubutsen shubu uaposh. Aden aid shubu uash nidnuequin abi tied nashunquid, Ista, quequin chianec nidposh icbo. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Adec nidequi nidaid utsi yacno choash yuec tabadash, Uba sinashe. Con uba bedtan, cac, aton yua nidposh. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Adec nidboed tied yacno chosho isun tied icbo nashunquidon bedshun cuestanquin menenquiocquin aton icbo yacno nidmeoaposh. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Adoacsho isboshic, Uba bedtan, cac yua utsitsen nidoaposh. Tied yacno chosho bedshun cuestanquin aidtsen aton icbo yacno nidmeoaposh tied icbo nashunquidon. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Adosho isash, Padi, quenquiocquimbidi, Con uba bedtan, cac yua utsitsen nidoaposh. Aidi tied icbo nashunquidon cuesuneposh. Adembidi, tied icbon nidmiaid utsi-utsien abi tied nashunquidon cuesosh. Aden nabanquimbi utsi-utsien cuesuneposh. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Adsho isash tied icbo nadposh: Nëid, con madombo abentsëqui nec. Ëbi cudasaid nec. Aidi tsyuec con tied yacno nidmembi. Aidi chosho isun, Tied icbon madombo nec, queshun bëdamboen istsiash, queshun aton madombo nidmeposh. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Aden nidmiac ancuenquio chosho isash, Tied icbon madombo choeque. Is. Aton papa unësan aton papa yacpadec icbo icoanushe queshun tied icbo nuqui icnun aidi cuesunenuna, quecuededposh tied icbo nashunquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Adec onquetanquin aton icbon madombotsen bedshun cuesuneshun daquënë uaid mabudacquin nebudposh. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Adoacsho tantiashun ¿atotsi tied icbon napec? Naden naindac. Utsibëd aton tied yacno nidshun abi nashunuidboed cuesuneshun utsibo abi nashunquido icmendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aden chuishumbic Esusën: —¿Adomboembidi chuiquin Nuquin Papan dada uamiampid tantienquioda icco? Nad iqueque. Tantia. “Shubu uanuequidën buintad isuidaidi utsin abia nitsinaid icoaposh. Adquiobidi Nuquin Papan chuimiaid matsesën tantiauidaid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nuquin Papan naid bëdambo iquec. Ambi Chomiaid abi yacno yuedquid icmequin Nuquin Papan nadatiambocquin naid nec quequin abi tantiaquidënquio tantiec” —quepondash Esus Nuquin Papan chiampidquio chiec. Nuquin Papain shubu abentsëquën abi tantiaquido yuedanquid nendac, quequin utsi chiacbimboec abibi chiadquin Esusën chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Adsho tantiash, Ëbitedishun isuidaidbimboecnuc chuibanec quequin tantiec isadaidbo tsusiobo Esus bedtiadquio icpondash. Adnubien Esus onquesho dadpenshun tantiabededpondash. Dadpen icsho isash dacuëdcuededec Esus bednu quenquio yec nidanepondash chieshëmënquido isadaidbo tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Isadaidbo tsusiobo nidshun padiseyobo edodesbobëdta istuidshun: —Nëidon Esus icsamboen chuimetsiash —queshun aido Esus yacno nidmepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aden nidmiac Esus yacno choshon abentsëcshun Esus nadopondash: —Ambia tantiaquid, matsesën tantiamiacpadpenquiocquid mibi yec Nuquin Papan tantiacpadomboen chuibanquidien mibi nec. Adquid icquin ëbi chui. Tantianu. Shocosh piucquid bec cho quequin bedshunquid, isadaidpembo ancaquid, Sesad cuëmëdquid nec. ¿Aden meniaid bëdambo iquec, quequin Nuquin Papan chiaidta nepec? ");
INSERT INTO mcfNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Adambi menepeba? —quepondash padiseyobobëd edodesbo Esus caic. Adoaquien, Ëbi icsamboen chuimenuec adec onquec, quequin ambibi tantiec: —Shocosh piucquid bec cho ma isnu —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Adsho tantiashun bëpondash. Adoaquien: —Sananquin isme. ¿Tsutsibimboecnuc dada uaid iqueque? Chui. Tantianu —capondash Esusën. Adoaquien: —Isadaidpembo ancaquid, Sesadbimboecnuc dada uaid nec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Adoaquien: —Ai, aidën na nec. Aid bec cho, quesho meneta. Adembidi Nuquin Papa Nuquin Icbo icquin, Nata, cacpadomboen naban —capondash Esusën. Aden bëdamboen chuisho tantiash, Bëdamboenshenda tantiapec, quequin ambibi tantiec Esus chieshënquido tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Adnubien saduseyobotsen Esus yacno cho-chopondash. Unësaid uincuentiapimbo iquec quequin tantiaquido aido nepondash. Aido cho-choash nadpondash: ");
INSERT INTO mcfNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Moisesën dada uapampid nad iqueque. Tantia. chuinu. Chidochoquid bacuë tishmiabi yec unësan unësboedën chido aton utsin bedtequid nec. Aden bedshun ma bacuë tishmepanuna. Aden tishmiac unësaidën tishmiaidbimboec ma icpanuna, quequin chuipampid nec —quepondash saduseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aden chuishumbic: —Aden nata quequin Nuquin Papan chiaid icnuc, aton mado 7ted tishpondash. Abia tishaid canishun aton chido bedshun bacuë tishmiabi yec unëspondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Adsho isun abi tsibanquidën aid chidobidi bedshun bacuë tishmiambo yec unësoapondash. Adembidi abi tsibanquidën ");
INSERT INTO mcfNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","aton utsi unësan aid chidobidi bedshun tishmiambo yec unësoapondash bacuë nibëdquio yec. Adecbidi dadatedi unësbudnepondash. Adecbidi chidotsen unësoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Adec unësash abuc tabadequi, ¿Mitsicquidën chido aid icpatsiashe? Chui. Tantianu —capondash saduseyobon Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Adoaquien Esus: —Nuquin Papan chiaid mimbi icsamboen tantiec. Adembidi ambi nadatiambocquin naid mimbi icsamboen tantiaoaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nad iqueque. Tantia. Unësaid uincuenash abuc tabadquin chido bedesa nendac. Adecbidi aton champi bedmesa aton papa nendac. Nuquin Papan uaido mayan bëda unësesa yacpadquiec matses uincuenash unësesa iquec caidesa nendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Adembidi unësash uincuenaid tantianu queshun ¿Moisesën dada uaid isenquioda ictionda? Aidën cuëtempi abibi nëdënquesho istanec nidtuidquin nadec Nuquin Papa onquesho tantiapampic: “Min tsusedpabon Papa nebi. Abadauanën Papa nebi. Adecbidi Isaquën Papa nebi. Adecbidi Acobon Papa nebi,” quequin Nuquin Papan chuisho tantiampic Moisesën. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nuquin Papan chiacpadpenquiocquin Moisesën dada uapampid nec quequin mimbibi muaquin chienda. Chuinu. Tantia. Unësaidën Papa nebi quesa Nuquin Papa nec. Nami chodquiaid icquin Nuquin Papa tantiatiapimbo iquec. Aton nami chodquenubi aton tantiate icsho ambi uincuen uatequido Nuquin Papan tantiendac —quepondash Esus matses uincuente iquec quequin saduseyobo tantiamenuec. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Adec Esusbëd saduseyobo onquecuedednubien tsusedpabon nadomboen nata quequin chiaid tantiamequid abentsëc chopondash. Bëdamboen Esusën saduseyobo chuisho tantiash Esus icsamboen chuimenuec aidtsen: —Ëmbitsen tantianu. Chui. Nadomboen nata quequin chiaid Nuquin Papan dada uamepampid dadpen iquec. Dadpen icnuc, ¿mitsicquid aidpadquid utsi nibëdpec? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Adoaquien Esus nadpondash: —Nëid chiaidpadquid utsi nibëdeque. Chuinu. Tantia. “Nuquin Icbo Nuquin Papa nec. Nuquin Icbo Abentsëcquiobi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Adquid icsho ëbi tantiaquid isash bëdambo iquebi camequin Nuquin Papa tantiadoneta. Adecbidi ëbi yacpadecuidi icnu quenquio yec Nuquin Papa bunacpadquiec icnu quec bëdamboec tabadta. Adembidi ambi tantiacpaden tantianu quequin adombota. Adembidi aid tantiaquin bëdamboen nabanquiota. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aden nabanquin Nuquin Papa bëdambo icmequin utsibo adembidi bëdambo icmequin nabanta. Ëbi tantiaquin utsibon ëbi nashuntiadquidi nec, mimbi cacpaden utsibo tantiaquin nashunta.” Aden nata quequin Nuquin Papan dada uamepampid nec. Aidpadquid utsi nibëdec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Adoaquien Esus icsamboen chuimenuec choboed nadpondash: —Mimbi chuiboed abimbo iquec. Nuquin Papa abentsëcquiobi iquec. Aidpadquid utsi nibëdec. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Adembidi, ëbi tantiaquid isash bëdambo iquebi Nuquin Papa camequin tantiadoneta. Adecbidi mimbi tantiacpadomboen nainquio yec Nuquin Papan tantiacpadquiec icnu quec bëdamboec tabadta. Adquid icquin ambi tantiacpaden tantianu quequin adombota. Adembidi abi tantiaquin bëdamboen nabanquiota quequin chuitequidpadquid utsi nibëdec. Aden Nuquin Papa bëdambo icmequimbi utsibo adembidi bëdambo icmequin nabanta. Ëbi nashuntiadquidi nec, mimbi cacpaden utsibo tantiaquin nashunta, quequin chuitequidpadquid utsi nibëdec. Aden naquid Nuquin Papan bëdamboen isendac. Aden naisa, Con na Nuquin Papa menenu, quesho Nuquin Papan bëdamboen istiapimbo iquendac —queoapondash choboed. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aden choboedën bëdamboen chuioasho tantiash: —Nuquin Papan shubu abentsëquën tabadaid mimbi bëdamboen tantiatsempoc —quepondash Esus. Adoac Esus icsamboen chuimenu quetiapimbo icpondash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Abi icsamboen chuimenuequid utsi nibëdnuc Nuquin Papa tabadte shubu uashunaidën tabadquimbi Esusën Nuquin Papan dada uamiampid chuibanquin nadopondash: —Nuquin Papan chomiaidquio tsusedpa Dabidën mado nendac, quequin tsusedpabon chiaid tantiamequidon chiec. ¿Atotsi chuiquin naden chieque? Tantia. Chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Naden Nuquin Papan Mayanën Dabid chuimiampic: “Icbo utsi icsho mibi chiembique. Tantia, mado, quequin chiec Icbo Dapa nadpampic: Ëquë con dayun abiucquio cainec tsadec cho ma mibi chieshënquidtedi mimbi namiaid ma icpanu,” quequin chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aden Nuquin Papa icbo dapanquio aton dayunquio chomiaid chiec Dabid pado, Con icbo nec, quiashic, ¿mitsipadquiec, Con mado nec, queopampic? Nuquin Papan chometequid, aton mado, Dabidën icbo yec ¿mitsipadectsi Dabidën tsyuecquid icoapec? —quepondash Esus abibi chiadequi. Aden chiec onquesho tantiash badedquio tantiatiadquio yampondash utsibo. Bëdamboen chiec, quequin comapenen tantiapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aden tantiamequimbi Esusën nadopondash: —Tsusedpabon nadomboen nata quequin chiaid tantiamequidën chuibansho tantienda. Aido nadquid iqueque. Tantia. Tsusiobimboec isadnu quiash abi dasiuidaid ënapen icquid dasiuidtenequid aido nec. Adecbidi tantiaquidquio yec tsusiobimboec isadnu quiash aton matses dadpen yacno capuquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Adomboembidi ëbi isoanu quiash Nuquin Papan chiaid chuibante shubun puduedash tsusiobëd tsadec. Adomboembidi ismenu quiash isedquido dadpen yacno choash shubu icbon dayunquio tsadoaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aido bëdamboen nashumbimboen nianten na ampequid nec. Adembidi bëdambocquid nec camenuen yuen Nuquin Papa chiec. Adquid comapenen cuidtequid nendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Aden chiashic aton na bedtequid sandote tabëcaid tabadacno choash isec Esus uano tsadpondash. Nuquin Papa tabadte shubu uashunaid tantiaquin nashunquidën nacnentsiash quequin aton na bedtequid bë-bëquin sandobansho isec tsadpondash. Adec tsadquin isquimbi aton na dadpen icquidën aton na bedtequid sando-sandonobi ");
INSERT INTO mcfNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","aton na daëdpactsëcquidquio niante choquimbi aton shocosh piucquid daëdquiobictsëcquid sandopondash aton na utsi nibëdquiocnoc. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Adosho isun abëd icquido chomeshun Esusën nadopondash: —Abimbo chiembique. Tantia. Niante aton na bedtequid dayun uanu quenquioctsëcquin Nuquin Papa tantiaquioquin sandoquidquio nec utsibon aden sandoenquiocnobi. ");
INSERT INTO mcfNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Utsibon aton na bedtequid dadpen uesenquiocquin sandobededposh. Aido daëdpactsëc icquid sandoacbimboen sandoquido nec quequin tantiembi. Adquidpenquio niante nec. ¿Bednun tedtsimbi dayunoape? quenquiocquin aton na daëdquiobictsëcquidi nibëdquiocnoc sandoposh nianten. Dadpen icquid sandoacbimboen sandosho aid isembi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Aden chianec Nuquin Papa tabadte shubu uashunaidën puduenubien: —Nuquin Papan shubu cuënote nacnenaid bëdaidquio iqueque. Is, Icbo —quepondash abëd icquid abentsëc Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Adoaquien: —¿Nëid shubu dapa isecta ne? Shubu uaquin cuënote dapa tsindonëdaid mimbi nëbi isaid chic-chicac nibëdquiendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aden chiashic auëshquio nidanec macuësh Odibos caid yacno tabadtuidpondash Nuquin Papa tabadte shubu uashunaid uano tsadnuc. Ambo tabadec abëd icquid 4ted icpondash. Petedo, Acobo, Uan, Andedes aidted icpondash. Utsibon tantienquiocnoc aidon: ");
INSERT INTO mcfNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Cuënote nacnenaid nebudte mimbi chuiboed ¿mitsipadën nebudte icpeque? Tantianu. Ëbi chui. Adembidi aidi tauanun ismete ¿atotsi icoapeque? Tantianu. Aid chuioa —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Adoaquien Esusën nadopondash: —Muaquin chiaid tantiamane queshun Nuquin Papan chiaid isban-isbanquiota. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nuquin Papan chomiaid nebi quec muaquid cho-choendac. Aid chosh, quequin chiac utsin-utsinquien, Abimbo caic, quequin tantiabededendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Adecbidi cuesnancuededec quendac. Adembidi cuesnancuededosh, quequin chuituidsho tantiaoaindac. Aden chuituidsho tantiash dacuëdenda. Ad icnuc abitedi naimbudte ushë choabi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ai, adquio iquendac. Adashic abëd tabadquidobëdi cuesnancuededendac. Adecbidi abi ancaquid dapan, Cuestan, quequin nidmiac nidaid utsin icquidobëdi cuesnancuededoaindac. Adecbidi utsi-utsiec yacno nidaid ishcudendac canchednuec. Adecbidi bunquiote iquendac. Aidtedi icsamboshëcquid taëyendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Adquid yanubi Nuquin Papan chiacpadomboen nabanec tabadta. Mibi bedshun, Icsambocquid neque. Cuidta, quequin tsusio utsibo menenun mibi buanendac. Adembidi bedshun Nuquin Papan chiaid chuibante shubuno buanacsho nuqui tsusiobon cuesendac. Adembidi bedshun isadaidpembo ancaquid dapabo yacno buanaqui mimbi tantiaid Nuquin Papan chiaid mimbi chuibanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nuquin Papa yacno yuedanquid iquec quequin mimbi chiendac. Nidaidtedi yacnoshon aden Nuquin Papa tantiaquidën chuitiad. Aden chiabicnuc abitedi naimbudtiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Adembidi, Icsamboen naquid nec, quequin muaquin bedshun icsaquid cuidnuequid yacno mibi buanaqui ¿atotsimbi cape? quequin mimbibi tantiec tsadenda. Nuquin Papan Mayanën mibi tantiamiacpadomboen mimbi chuibanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Adembidi Nuquin Papan chiaid tantiesan aton utsimbo Nuquin Papan chiaid tantiaquid bedmec, Nëid cuesuneta, quendac. Adembidi aton papan aton bacuë cuesuneta, caindac. Adembidi aton bacuëbo tantiesa icquin aton papan chiaid niacquin adembidi aton titan chiaid niacoaquin cuesunemendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Esus tantiaquid chieshënquid dadpen iquendac. Adquidën mëyanaqui Esus tantiaquid nebi quec niaquesa icta. Aden niaquenquio yec unësash Nuquin Papa yacno nidacsho bëdambo icmiaid mibi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Adnubien Nuquin Papa chieshënte ushë choendac. Aid chonoc Edusaden yacno abi chieshënquid dapa choash, Nuquin Papa caid nebi, quiash Nuquin Papa tabadte shubu uashunaidën tsadendac. Adsho isash cuesunenushe quiash anoentsëqui icquido cuenenquiocboedi ma cuempanuna. Abimbo chiembique. Bëdamboen tantiata caimbi. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Adecbidi shubu macano pada-padapambo yacno tabadquido yec umanuc dectatote uaid dectandoaidën budanec con na bednu quenquio yec cuenta. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Adecbidi aton tied nantan tabadquid yec aton dashcute bëntsecquid chicshun dectanaid bednuec bidiadenquio yec badedquio cuenta. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bacuë usunquid adecbidi bacuë chishmequin buanquid badedquio cuentiapimbocsho mëyampec. Adquid tantiec utsibo unësquio icchitec. Nuquin Papa chieshënte ushë icsamboshë iquendac. Adnuc badedquio cuenta. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nuquin Papa chieshënte ushë icnuc ma ue dapa sequenquiocpanuna, quequin Nuquin Papa chuided-chuidedta. Adoac ma badedquio cuempanu. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Comapenen Nuquin Papa chieshënquin abi tantiaquido icsa uaquin mëyanendac. Yuen naindac. Adoaidpadquid ënden nibëdondash. Adecbidi adoaidpadquid nibëdendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nuquin Papa ëmenuen chuideneta. Nuquin Papa chuiquin, Chën, Papa, mimbi cainquiocnoc matsestedi nibëdtsiandac. Ëbi tantiaquid ambi cuënaido tantiec, Chën, quequin Nuquin Papan ëmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nuquin Papa chieshënte ushë icnuc, Nëid, Quidistu, Nuquin Papan chomiaid neque. Isec cho, quesho tantienquio icta. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aid ushë icnuc, Nuquin Papan chomiaid nebi, quec muaquid dadpen cho-choendac. Adecbidi, Nuquin Papan chuimiaid nebi, quec muaquid dadpembidi iquendac. Nuquin Papan cuënaido ëbi tantiaquid icmenu quequin abi chieshënquidombidi nadatiambocquin nabanendac. Adosho isun ëbi tantiaquidëmbi utsin-utsinquien tantiauidtsendac adquid. Nuquin Papapenquio aid nec, quequin Nuquin Papambo tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ad iquendac quequin chiombique. Ad icnuc chieshenquiocquin Nuquin Papan chiaid tantiaquiota —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aden chiash abi onquec: —Adnubien Nuquin Papa chieshënte ushë nidan inchëshquio yanendac. Badiadën ushëbëdtabi inchëshën chënquequid nibëdquiocnoc unës uaindac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Adecbidi uispa paëdted-paëdtedendac. Adecbidi abuc tabëcaid nibëdnuc ambo icquido Satanasbëd icquido ¿mitsimbo nuqui cuempeba? quendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Adnubien Nuquin Papan madombo matsesaid ëbi choasho matsesën isendac. Abu ushun nadatiambo yec ushumbo yec bëdaidquio iquequi ëbi choasho isendac matsesën. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Adnubien Nuquin Papan uaido mayan bëdabo, Ëmbi nidtan, cac nidanendac. Nuquin Papan cuënaido bednuec nidaidtedi yacno nidaneshun bedbanash ëbi tsadacno choec, Bëombi, quetuidendac bedtanec choquido —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aden chiashic: —Abi chiembique. Tantia. Suc seccuduquiac nëbi cunquecuenec, quequin matsesën tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Adomboembidi ëmbi chuibamboed tauadosho isash Nuquin Papa chieshënte ushë choeque. Ista, quec chuinanta. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Abimbo chiembique. Tantiata. Ëmbi chuibamboed naimbudabicnuc ëmbi chuibamboed tantiaquidën tsyuecquido naimëdbudenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Aden matsesën isnubien nidaidbëdi abu ënëdendac. Ëmbi chiaidtedi abimbo yec adquiouidi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Adnuc nëid ushënquio Nuquin Papa chieshënquin tauaindac quetiapimbo matses iquec. Ambi uaido mayan bëdabo adecbidi quetiapimbo icoaic. Aton madombo yec adtiapimbo iquebi. Nuquin Papa abentsëcquiobien adquid tantiaquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aid tauadote ushë choaid tantiatiapimbocquin Nuquin Papan chiaid niacmane queshun isbanquin nabanta. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nad iqueque. Tantia. Chuinu. Utsibo yacno nidnun abëd tabadquido naden chuiposh. Min utsibo chieshënenquiocquin shubu isquid icta quequin chianec nidposh. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Adec icbo nidan abi choate ushë mimbi tantienquio iqueque. Bëshunenquiocquin tantiaquiota. Inchëshbudtsëqui choapatsiash, quequin tantiata. Adembidi inchëshpotsembo chopatsiash queshun adembidi tantiaquiota. Adembidi, cachina cuëdanubi chopatsiash, queshun isucunshun tantiadenequiota ");
INSERT INTO mcfNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ëmbi tantienquiocnoc con icbo chochitondac, queshun. ");
INSERT INTO mcfNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Adquiecbidi bëdamboec tabadquin Nuquin Papan chiaid isted-istedta Nuquin Papa chieshënquidën niacmenushe queshun —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Adashic, bëyuc tishaid unësmenuequid aton shubu datamenuequin Isadaidbo tsusedpabon nidaidën capuquid yuaded cuesunepampic. Aid tantiaid ushëbëdtabi pan bidisquesa tantiaid ushë Pascuas caid daëdec ushash choendac. Aid chonoshe queshun isadaidbo tsusiobon Esus nibëmbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aden nibënec: —Pascuas ushë tantiec Edusaden yacno matses dadpen cho-choec. Matses dadpen choabicnuc ismenquiocquin Esus bedtiad. Bedsho isash, Padi. Bedenda, queuidash nëishun comapenen nuqui cuestsiashe —quepondash isadaidbo tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Adnubien Betania caid yacno tabadquin Esusën Simonën shubun puduedshun pepondash. Simon daushacbimboecquid, nami mishac tantiadenquiocquid icsho Esusën bëdamiaid nepondash. Adec puduedshun pec tabadnubi comapenec noadquid bëec chido puduedpondash. Piucquid dadpen menequin comapenec noadquid bedquid chido nec. Ambi bedaid sedunte postichoquid dëusunaid dëchictanquin Esus chidon machiuimpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aden machiuinsho isash utsibo nëishun: —¿Atotsieshun machiuino? ");
INSERT INTO mcfNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Noadte menequin piucquid dadpen bedshun aton na nibëdquid dadpen menetsiandac —quec onquecuededpanëdash Esus machiuimboed chido chushcaic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aden chushcasho tantiashien Esus onquec nadpondash: —Chushcainda. ¿Mitsanada nediosh? Ambi noadte machiuimboed bëdaidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Badiadquidën-badiadquidënquiec ënëdenquio yec aton na nibëdquid ënabi iquec. Aidi menenu queshun mimbi menepec. Ëbien nashuntiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ëbi unësabicnuc nëid chidon tantiaquin chococanuequin nacbimboen noadte machiuimpaboc. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Abimbo chiembique. Tantia. Nuquin Papan shubu abentsëquën tabadaid chuiquimbi ëbi machiuimboedën naidtsen tantiaquidon chuiben-chuibenendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Adnubien Udas Iscadiote, Esusbëd icquid abentsëc, Esus bedmenu, quianec isadaidbo tsusiobo yacno nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Adec nidequi isadaidbo tsusiobo yacno choshon Esus mibi bedmembi quequin chuituidac bëdambo icpac caondash aido. Adembidi: —Esus ëbi bedmesho isun piucquid mibi menembi —quecuededpac caondash. Adsho tantiash nidanec, ¿Mitsipadentsimbi bedmepe? quec tabadquin caimpac caondash Udasën. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Adashien penun isadaidbo utsibon nidaidën capuquid cuesunenubien: —Cuesuniaid pambid penu queshun, ¿mitsishunquiembi nacnempatsia? —quepondash Esusbëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Adsho tantiash Esus abëd icquid daëd chiec nadpondash: —Edusaden yacno nidquimbi dadan acte bësho istuidash tsibananec aidbëdi nidta. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aden aid tsibanec puduedash, ¿Ëbi tabadte quënë mitsimbo iquec? ëbëd icquidobëdtan penu, quiosh chuiquid, quequin shubu icbo chuita. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aden chiac buanshun dectatomeshun abuc quënë dapa mibi ismendac. Ambo pete sante cueste iquendac. Ashunquio penun nacnenta —quepondash Esus ambi daëd chuimiaid caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aden chiac abëd icquid daëd Edusaden yacno nidquin Esusën chiacpadomboen bëquedshun tsibananash puduedshun penun nacnempondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Adnubien inchëshbudtsëqui aid daëdtsëqui yacno Esusbëd icquid utsibo chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Adec choash pec tabadnubien: —Abimbo chiembique. Tantia. Ëbëdtan pequid abentsëcshun isadaidbo tsusiobo ëbi bedmendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Adsho tantiash, Icsambo iquec, quequin tantiec: —¿Ëbida chienquio ique? —quepondash abëd icquidtedi. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Adoaquien: —Mibëd icquid nebi, quec mibitedi. Padnuen abentsëcshun ëbëdtambi pete cuëshën ënë punshun pequidën ëbi chieshënquido bedmendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nuquin Papan chuimiacpadomboen aton madombo chidon tishac matsesaid ëbi unës uate anoentsëqui yanec. Ëbi bedmequid icsamboshë iquendac. Abi cuidte icsamboshë icnushe queshun aidi tishenquiocpatecnëdan —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Adashic pebededquin pete bedshun Nuquin Papa chiec onquetanquin pete cuësh-cuëshun abëd icquido menebanquin: —Nëid pete cuëshë ëmbi piaid con dadabëd daëdacpadquiec Esus unësash abi tantiaquid ëbi icnuc Esus ëbëdi iquec quequin tantiata —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Adembidi dëshote bedshun uba caid actequid icnuc Nuquin Papa padpiden chuishun abëd icquido menebanac acpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Nëid acquin Esusded Nuquin Papan cuidac aton intac siebudpamboec unësposh. Aton madoded cuidshun Nuquin Papan ëbi padenquio iquec quequin nëid acquin tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Uba caid ënë nidaidënshun padpiden aquenquiocquimbi Nuquin Papan shubunshun actequid chuca mibëdtambi aquendambi —quepondash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aden chiash Nuquin Papan naid chiec cuëdënanec macuësh Odibos caid yacno nidoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Adshumbic Esusën: —Esus tantiaquid nebi quesa mibitedi nendac. Nuquin Papan chiampidpadquid mibitedi nad iqueque. Chuinu. Tantia, mibi. “Abi tantiaquid bëyucanquin yuedquid unës uaimbi. Adosho isash abëd icquido cuenec cuëshëd-cuëshëdendac,” quequin Nuquin Papan chuipampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Unës uac uincuenash Cadidia yacno ëbia nidoaindabi. Mibitsen ambo nidta —capondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Adoaquien: —Esus tantiaquid nebi quenquio utsitedi icnuc ëbien padenquio iquec —quepondash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aden Petedon chuisho tantiash: —Abimbo chiembique. Tantia. Nëid inchëshëmbi cachina bënë daëdec cuëdanabicnuc Esus tantiesa nebi, quequin mimbi tedesteden chiendac —quepondash Esus Petedo caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Adsho tantiash: —Esus tantiaquid mibi icsho mibi aidbëdta unës uaimbi, cac, Esus tantiesa nebi, quenquio iquendabi —quepondash Petedo comapenec onquec. Adecbidi Esusbëd icquidtedi onquepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Adashic cuëte odibo caid dadpen icsho Quetsemani quequin cuënacno choash nidtuidash: —Nuquin Papa chuinuec udi nidebique. Nëmbobi tabad —quepac caondash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aden chianec Petedo, Acobo, Uan nëidted cho quianec bëyucanec nidec Esus, Matsestedi icsaid cuidtequid ëmbi bedshunsho isun Nuquin Papan ëbi istiapimbo iquec, quequin tantiec unësquioshë yampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Adquio iquec: —Ëbibi unësquioshë yec udictsëc nidebi. Chieshtomane queshun nëmbobi tabadquin Nuquin Papa chuiban —quepac caondash Esus ambi nëid 3ted, Cho, caboed chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aden chianec udictsëc nidash Nuquin Papa chuinuec nidaidën uebudash uec onquec: —¿Adabi adquid icmenquioctsia? Papa —quepac caondash Esus Nuquin Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aden chuishumbic: —Papa, mimbi natiapimbo ictequid nibëdec. Adquid icquin matses cuidtequid bedshunquid con mado icmenquio iquembi queshun mimbi adoenquioctsiandac, Papa. Ëbi bunacpaden nainquiocquin mibi bunacpadomboen nata, Papa —capac caondash Esusën Nuquin Papa chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aden chiash choquin abëd choboed 3ted icquid usho istuidec Petedo caic: —Simon, ¿ushecta ne? ¿Ëbibi chieshmane quiash yuecpactsëc iquec ushenquio yec tabadtiapimboda icco? ");
INSERT INTO mcfNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chieshmane queshun Nuquin Papa chuita Nuquin Papan chiaid niacmenuequidën Satanas caidën chiaid tantiamane queshun. Chieshenquio iquebi quiash dacuëdash badedquio mibi chieshendac —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aden chiash ambi Nuquin Papa chuibocno nidoashun ambi chuibocpadembi Nuquin Papa Esusën chuioapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Adtanec choashumbic abëd choboedo adecbidi ushacsho istuidoapac caondash. Ushcasquiec tabadec, Ushenquioccobi, quequin chuitiapimbo yec otacquio tabadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Adnubien padpidec nidoashun Nuquin Papa chuioatanec choec: —¿Uimabudashta tiboquec ushec ne? Padi. Ushenquio yec isucun. Nuquin Papan madombo chidon tishac matsesaid ëbi icsho nëbimbobi ëbi chieshënquidon bedmeque. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nidtoash ëbëdi nid. Ënden choaye. Is —quetuidpac caondash Esus abi bednuec choquido isec. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Aden chuinubien Esusbëd icboedquiobi Udasbëd matses dadpen cho-chopondash. Cho-choquid utsi-utsiec chështe sanampamboec chonobi utsi cueste sanampamboec chopondash. Aidted Udasën chiac isadaidbo tsusiobon chomiaido nepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Esus bednuequid tantiamenuen ambiabi Udasën: —Ëmbi tanchoccaid mimbi bedtequid nendac. Aidquiobi bedshun buanta. Cuenushe queshun bëdamboen ista —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aden chiashic aidobëdi choquimbi: —Icbo —quequin Udasën Esus tanchoccatuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aden Udasën tanchoccasho isun Esus bedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Adnubien anocquid abentsëcshun chështe sananquin isadaidbo tsusio dapan ancaidën pabiate auc abentsëc pateshunepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Adnubien: —¿Cuesanquid Esus nec, queshun utsin cueste sananubi utsibon chështe sananec ëbi bedecta cho-choec ne? ");
INSERT INTO mcfNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Badiadquidën-badiadquidënquiec Nuquin Papa tabadte shubu uashunaid umanuc daquënë uaidën tabadquin matses tantiamenuen chuibaniombi mibitedi tabadnubi. Ambo icshobi ¿atotsieshumbini mimbi bedenquiocpo? Nuquin Papan chiacpadomboen nëbi mimbi ëbi bedec, —quepondash Esus abi bedquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Adec onquesho tantiashun cuenquin abëd icquidtedishun Esus niampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Adec cuenubini nëbi caniquid yequi Esus tsibananec nidpondac. Dashcute isad-isadquid dasiuidanec nidquin Esus tsibampondambi. Aden tsibanshobi Esus chieshënquidon bedpondashi. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Aden bedac dasiuidte bëdaidquio nianec dadauidquio cuempondabi. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Adnubien, isadaidbo tsusio dapa, matses tantiec Nuquin Papa chiec onquequido yacno Esus buampondash. Aden buanec puduednu quiacnombobi isadaidbo tsusiobo utsibo iccuededec tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aden Esus buanubi tsyuec choquin Petedo cuemboedën tsibananec isadaidbo tsusio dapan shubu umanuc daquënë uaidën puduedpondash. Adec puduedash Esus cuenushe quequin isquido tabadacno ambotsen cuëte cuëec tsadpondash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Adec Petedo tsadnubien Esus unës uate bunquin Esus icsambocquid nec quequin chuiquid ¿Ada icpec? quequin nibënquin adquid tsusiobon istuidabicpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abimbo chiacbimboen dadpenshun chuibededpondash. Aden chuiquin abentsëcshun chiacpadomboen chienquiocquin utsin chuioapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Adnubien, Chuinu. Tantia, queshun Esusën chiacbimboen utsi uain chuipondash utsibon. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Aden chuinubien utsi onquec: —Naden Esusën chuisho tantiombique. Tantia. Chuinu. “Nëid, Nuquin Papa tabadte shubu uashunaid chicbanendambi. Aden chicbanshumbic daëdec ushquin matsesën naidpenquio isadnuc ëmbibi naindambi,” quequin Esusën chuipondash —quepondash utsi. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aden abentsëcshun chuinubi utsin aden chienquiocquin chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aden chuisho tantiash isadaidbo tsusio dapa nënantanquio nidtoash nidquin: —¿Mimbi chiacpadomboen chiecta nec? ¿Abimbo chuiquidta nëidtedi neque? Chui. Tantianu —capondash isadaidbo tsusio dapan Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Adsho tantiash ëcbedenquio yec otacquio nidsho isash: —¿Nuquin Papan chomiaidquio, Quidistu caid, Bëdambocquidën mado nebi, quecta mibi ique? —queoapondash isadaidbo tsusio dapa Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Adoaquien Esus: —Ai, aidi nebi. Nuquin Papan madombo matsesaid abuc nidoashic Nadatiambocquidën dayun abiucquio tsadash abu ushun ëbi chosho matsesën isendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Adsho tantiash, Icsamboen chiec, quec abi daëd dasiuidaid bëntsecquid dached-dachedquiash: —¿Atotsieshun Esusën icsamboen naosh, quequin chuimenuen utsi nibëmpe nuqui? ");
INSERT INTO mcfNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nuquin Papa icsamboen Esusën chuisho mimbi tantioc. ¿Midapaden mimbi chieque? Tantianu. Chui —capondash isadaidbo tsusio dapan tsusio utsibo chuiquin. Adoaquien: —Icsambo iqueque. Unës uametiad —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Adsho tantiashun Esus dacuishtuaquin utsibon tauapondash. Adotanquin dashcuten bëpucshun ambibi cuestanequi: —¿Tsuntsin mibi cuesposh? Comapenen tantiaquidquio mibi neque. Ëbi chui. Tantianu —capondash Esus chuiquin. Adnubien cuenushe quequin Esus bedshun sondadon comapenen cuesbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Adnubien Petedo umanuc daquënë uaidën tsadnubi isadaidbo tsusio dapan yua chido chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Choshon Petedo cuëte cuëec tsadsho isun: —Nasaded caid yacnocquid Esusbëd icquid mibi nec —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Adoaquien, Esusbëd icquid nebi, quetiapimbo yec Petedo: —¿Atotsi mibi quepe? Tantienquio yec tsadebi —quepondash. Adtanec puduedte shëcuë anoentsëqui nidtuidash tsadnuc cachina bënë cuëdpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Adec Petedo ambo tsadsho chido yuaidën istuidtanquin padpiden: —Esusbëd icquidquio nëid nec —quequin anocquido chuioapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Adoaquien: —¿Aidbëd icquidtabi nedi? —quepondash Petedo. Adnubien yuecpactsëc yash: —Aidbëdi Cadidia yacnocquid mibi nec —quepondash ambobidi tabadquido. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Adoaquien: —Ëmbi tantiacmaidquio nec quequin abimbo chiembi. Ëmbi abimbo chienquio icsho ma ëbi chian anëdënquiacno Nuquin Papan nënepanuna —quepondash Petedo comapenen chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Adnubien cachina padpidec cuëdpondash. Adsho tantiashun, “Cachina daëdec cuëdabicnuc ëmbi tantiacmaidquio Esus nec, quequin mimbi chiendac tedestedec onquequin,” quequin Esusën chioshi quequin tantiec unësquio yanec shubianquiopondash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Badiadnuc isadaidbo tsusiobo iccuededpondash. Nëidted icpondash: isadaidbo tsusio dapabo, tsusio utsibo, tsusedpabon nadomboen nata quequin chiaid tantiamequido. Adec iccuededash onqueshun Esus mëtaneshun buanshun isadaidpembo ancaquid Pidato caid menepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aden meniac Pidato: —¿Isadaidbo ancaquidta mibi neque? Ëbi chui. Tantianu —capondash Pidaton Esus chuiquin. Adoaquien: —Mimbibi aden chuipayoc —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Adnubien, Esus icsaded-icsadedosh, quequin chiec isadaidbo tsusiobo onquecuedednuc cuëdenquio yec Esus tsadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Adec tsadsho isun: —¿Ëcbedanenquio yec otacquioda tsade? Mibi icsaid dadpen nëidon chuibanec —Pidaton caqui ");
INSERT INTO mcfNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","adquiecbidi Esus tsadpondash. Adec tsadsho isash ¿Mitsipadquidquio Esus nepec? Utsimbien, Icsapenquiocquid nebi, quequin chuipec, Aden chienquio Esusën iquec, quequin ambibi tantiec Pidato tsadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Adashic, isadaidbon nidaidën capuquidded cuesunepampid tantiaid Pascuas caid ushë choaidën-choaidënquien, Quënën nauedmiaid abentsëc nidmenu. ¿Mitsiquidimbi nidmepeque? Chui. Tantianu, quequin isadaidbo Pidaton chuided-chuidedpadenec. Adoaquien ismequin, Nëid nidme, cac nidmedenepadenec. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aden chuidenequin ambi quënën nauedmiaid Badabas cuëmëdquid nepondash. Aidëmbi utsibobëdtan Domanobo bunenquiocquin cuesquin tauasho isun bedmeshun quënën nauedmepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Adnubien Pidaton seta utsin quënën nauedmiaid abentsëc ambi nidmiondacpaden nëbi adquid utsi nidmepatsiash icnui quequin tantiec Pidato yacno chopondash isadaidbo iccuededquido. Aden tantiec choash: —Quënën nauedmiaid abentsëcta mimbi nidmepatsia —quecuededpondash aido Pidato caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Adec onquesho tantiash Esus nidmetiadquiocquin Pidaton: —Mibi ancaquid caid, Esus, nidmependambi iqueque. Isadaidbon, ëbi chui. Tantianu —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Esusbidi tsusio icpec matses quenushe quiash isadaidbo tsusiobo Esus unës uate bumpec quequin tantiaquin Pidaton aden chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aden tantiec, ¿Adambi Esus nidme? quequin Pidaton chiac, Padi. Badabas nidmeta, quequin isadaidbo iccuededquin chuipondash aton tsusiobon chiacpadomboen. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aden chuibededaquien: —Badabas nidmequimbi mibi ancaquid caid Esus ¿atotsimbi napeque? Chui. Tantianu —capondash Pidaton. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Adoaquien: —Cueste nitsinshun dectan —quec comapenec cuëdcuededpondash isadaidbo. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Adoaquien: —¿Atotsi icsa uaosh? —quepondash Pidato. Adoaquien: —Cueste nitsinshun dectan —queoaic comapenec cuëdcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Adsho tantiash Esus ëmbi nidmesho isun, Pidato icsambocquid nec, quequin ëbi chuiquid dapa isadaidbo tsusiobon chuinushe queshun Badabas nidmepondash. Adshumbic: —Cueshcaten Esus comapenen cuesmebededshun cuesten dectanun buanec nid —capondash Pidaton sondado chuiquid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Adoac Esus bedshun Pidaton shubu umanuc daquënë uaid yacno sondadon buampondash. Aden buanshumbien sondado utsibo 600ted icnuc chomepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Choshon dashcute abichobicquid bëdaidquio bedshun ancanquid dasiuidacbimboecnuc dasiuinshun pinchuc-pinchucquid mauete uashun Esus matoncashun ");
INSERT INTO mcfNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ancanquid cuënacpaden cuënec: —Mibi isash bëdambo iquebi. Isadaidbo ancaquid dapa caid mibi neyoc —quequin Esus oncaic onquecuededpondash sondado. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Adoquimbi ancanquidën sanante cueste bëdaidquiobimboecnuc sananquin sondadon abentsëcshun-abentsëcshunquien Esus macuestanquin dacuishtucabudniash Esusën taëno danëshën sebudash uepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aden mamënshumbededquin mëyanshun dashcute bëdambocquid ambi dasiuimboed dachicshun aton dashcutebi dasiuinshun cuesten dectanuequin Esus buampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aden abi dectante cueste Esusën buantiapimbocnoc nidquimbi abi datanquid cueste chiadtometanquin buamepondash sondadon. Abi datanquid Sidene caid yacnocquid nëbi Edusaden caid dëuequiacnoësh choquid nepondash. Adecandedo, Dupo chedon papa Simon cuëmëdquid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aden cueste Simonën buanubi macuësh Codocota caid yacno abitedi chopondash. Macuësh mapi canitebimboecsho Codocota quequin isadaidbon aton onqueten cuëmpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ambo choshon uba sicaid paëacsho paëmbocquid dauë cacushtanquin meniac aquenquiocpondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aden isuidsho isun cuesten dectampondash. Aden dectanshun aton dashcute bednu quequin sondadon abi cuëmëdquidtedi dada uabanshun tëchun sandoshon cadotanequin dada uatsaidëmpi puduemiaid isbanquin Esusën dashcute bedbampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ushë dectatoec 9 yanuc Esus cuesten dectampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Esus dectanaid mapino dada uaid cueste podectanaid diadpondash. Isadaidbo ancaquid nec quequin dada uaid nepondash. Esusën naden chiosh quequin isadaidbo tsusiobon chiacpaden dada uaid nepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Cuesunetanquin ampequid daëd ëquë dectambudcuenshun nënantanquio Esus dectampondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","“Dectanquin icsaquidbëdta dectanendac,” quequin Nuquin Papan chuimiampicpadembi napondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aden Esus dectanaid mapino abuc: “Isadaidbo ancaquid nec” quequin dada uaid podectanaid diadsho isash, Adquidshenda diadpec, quequin tantiaquin datanquin mamënshumbededpondash. Adec cuenquin mamënshunquin: —Nuquin Papa tabadte shubu uashunaid chicbanshun daëdec ushquin chuca uaimbi, quequin chiec mibi onquiondaque. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Abimbo chuiquid yec unëstiapimbocquid nebi quianec mibibi budta —cabidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aden cuenquidën chuinubi adembidi isadaidbo tsusio dapabotedi tsusedpabon nadomboen nata quequin chiaid tantiamequid chedo onquecuededec: —Utsi-utsien bëdamequimbi utsi unësacsho uincuemeboed yec mëtoccaid abembi chiquidtiapimbocquid nec —quepondash isadaidbo tsusiobo Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—Quidistu, Nuquin Papan chomiaid, isadaidbo ancaquid nebi queboed mibibi bud. Mibi budaid isash, Quidistu nec, quequin tantiendambi —quepondash. Aden cuenquidën mamënshunubi abëdta dectanaidën adembidi chuioapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Adnubien ushë cuembocnoc 12 yanan inchëshquio icboedi ushë budec 3 yanuc uëshëmbo yanoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ushë 3 yanuc: —Eloi, Eloi, ¿lama sabactani? —quequin aton papa chiec Esus comapenec cuëdpondash. Aton onqueten: Papa Edoen, ¿atotsieshumbini bidiadquin isenquio ique? quec adpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aden Nuquin Papa Esusën chuisho tantiaquido, Nuquin Papa cuënec, quenquio yec: —Edias cuëneque. Tantia —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aden tantianubi badedi titinqueshun sicaid mucambocquid nëcushtanquin puntanquin cueste dëdectanshun acmenuequin ëccuëscadonequi: —Chiata. Edias Esus bedec chonoshe caimbono —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Adnubien comapenec cuëdec Esus unësbudpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Esus unësbudnubi abi inchëshacbimboecnubi Nuquin Papa tabadte shubu uashunaid quënë uaid nuntan dectanaid dashcute bitsipambocquid tsincabudquin dectanac diadquid canchedbudcuempac caondash tembi daëdquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Adec Esus cuëdbud-cuëdbudec unëso isash: —Abimbo chuiquid niosh. Nuquin Papan madombo nëid nec —quepondash sondado chuiquid uquë tsadbudec. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Adnubien ancuenquio isec chidobo nëidtedi tabadpondash: Madia Mactada caid yacnocquid; Madia utsi, Acobo bushcuctsëcquidën tita, aidi Osen tita nepondash. Utsibic Sadome nepondash. Aidon Esus ancuenquio diadsho isbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aidon Esus Cadidia caid yacno capusho isun abi nashumboedo nepondash. Aidobëdtan isquido chido utsibo Edusaden yacno choshon Esus buansho isun tsibanquido icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Adashic biednes ushë budtsambi: —Inchëshbudtsëqui seis icnuc chonoadtemaid ushë chonoshe Esus unësoshe chococatanu —quianec Esus tantiaquid utsi nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aidi, Ose Adimateya caid yacnoshon tishaid Pidato yacno nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Adec nidshun: —Esusën dada bedshun chococatiadquio iquebique. ¿Ada buantan mibi quepe? —caquien, ¿Ëndenda unësaccosh? quequin tantiesa icquin sondado chuiquid Pidaton chomeshun: —¿Ada Esus unësosh? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Adoac: —Ai —quesho tantiashun: —Ai, bedshun buanta —capondash Pidaton Ose chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Adoac nidshun unësaid dabidiate bedshun Esusën dada imbudshun dataneshun macuësh dapa cuënote shëcuë uaquin ambi nacnenaidën nauedshun cuënote dapan bëtashpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aden Osen Esus chococasho Madia Mactada caid yacnocquidbëdtambi Madia, Ose utsin titan ispondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Aden isashic sabado chonoadtemaid ushë inchëshbudtsëqui seis icnuc naimëdnubi Madia Mactada yacnocquid; Madia, Acobon tita; Sadome aidtedi nidshun aton na bedtequid menequin comapenec noadte dadpen bedpondash Esus danoshcanuequin. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bedtsash badiadtsëcnubi dominco ushë caidën Esus chococacno nidanequi: ");
INSERT INTO mcfNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—¿Tsuntsin cuënote shëcnepeba? —quec onquecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Adec onquequin ancuenquio isquien cuënote ënden shëcniac. Cuënote dapa yuëmbocquid nepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aden isequi nidash chococaid shëcuën puduedquin isaquien dada nëbi caniaid dashcute ushumbocquid dasiuidash abiucquio tsadpondash. Aidi isash dacuëdcuededec tabadpac caondash chidobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Adec dacuëdec tabadsho isun: —Dacuëdenquio yec tabad. Esus cuesten dectanaid mimbi nibënaid tantiembi. Uincuenash nidac. Nëmbobi nanac ueuidoshe. Is. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nadoshi: “Cadidia caid yacno ëbia nidebi. Ambo nidshun ëmbi chiacpadomboen mimbi ëbi isendac, quiosh quequin nëmbo choacsho isun chuita,” Esusën caoshi. Nëbi ëmbi chiacpaden Petedo Esusbëd icquidquio utsibobëdta chuituidec nid —quepondash nëbi caniquid chidobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aden chuisho tantiash uëdëquequi chococaid shëcuënuësh puduenanec titinquec dacuëdec onquenquio yec nidanepac caondash chidobo. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Adnubien abi nibëmboed uincuenshun Madia Matcada caid yacnocquidba Esusën ismetuidpondash. Ambi mayan icsa 7ted dapuduemiaid Madia Mactada yacnocquid nepondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aden ismiac Esusbëd icboedo yacno nidash puduedshun aido shubisho Esusën abi ismiaid Madian chuituidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Esus uincuenash capusho isombi, Madia quesho tantiash, Aidquio mimbi isambo iquec, quec tantienquio yec tabadcuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Adashic tantienquio yec tabadboed dada daëd Edusaden yacnoësh podquedën nidsho Esusën chinumpondash. Chinunanec aidobëd nidanec puduedshun ismebempac caondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aden ismiac aid daëdi aucbidi Edusaden yacno nidshun ambi isboed chuioapondash. Adembidi tantienquio icoapondash utsibon. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Adashic, abëd icquidquio 11ted pete sante cuesten tabadnubi Esus chopondash. Adec choshon: —Uincuenac quequin ëbi isquidon chiaid tantienquio mimbi icpoc. Chobique. Is —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Adashic: —Nëbi nidaidtedi yacno nidaneta. Adec nidshun Nuquin Papan shubu abentsëquën tabadtequid iquec, quequin matsestedi mimbitsen chuiban. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aden chuisho tantiaquid, Ëbi cuidenquiocquin Esusded Nuquin Papan cuidpanëdash. Adoac ëbi icsaid ënu, quequin ismenuequin acten mentomiaid abi yacno Nuquin Papan puduedmendac. Tantiesain Nuquin Papan cuidendac abi yacno puduedtiapimbocnoc. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abi tantiaquid utsi-utsien Nuquin Papan nadatiambocquin nabanquid icmendac. Adquid icmiaidën ëmbi nacpaden mayan icsa dapuduemendac. Adembidi, utsi onquiaid tantienquiocboedëmbi tantiaquin ëbi chuibanendac. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Adecbidi, nisinquio piaqui bidisquenquio iquendac. Adecbidi, unësmenuequin acmiaqui unësenquio iquendac. Adembidi, utsi unëstsensho mishac bëdanendac. Nuquin Papan nadatiambocquin namiaidënquio adobanendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aden chuiquin ënacsho Esus abuc buanaqui Nuquin Papan dayun abiucquio Esus tsadtuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ambo tsadquimbi nadatiambocquin namiac nidaidën tabadquimbi abëd icquido nidaid utsi-utsiec yacno capuquin Nuquin Papan shubu abentsëquën tabadaid chuibenepondash nadatiambocquin nabanquimbi. Ëmbi abimbo chuiboedquio mimbi isec aidquio tantianeta. Padi. Aidtedi dada uaombi.");
INSERT INTO mcfNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Utsin-utsinquien ambi naidbëdtabi Esuquidistu chuibanquin dada uaid dadpen iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aidon Esuquidistun tauain naidbëdtabi ambi naid utsitedi isted-istedquin chuibanquin chiacpaden dada uaidtedi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Esuquidistu chuibanquin dada uaid isbanquimbi Esuquidistu isnëdaidon chuibanaid tantiashun aidtedi mibi chuibanquin dada uaimbi, chuiquid dapa, Teyopido. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Abimbo iquec quequin ëmbi dada uaid ma tantiapanueshun mibi chuiquin dada uaimbique. Isec onqueta. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nidaid Udeya caid yacno Edodes cuëmëdquid ancanquid icnubien Nuquin Papan namiaidquio Sacadias cuëmëdquid icpanëdash. Aidi, Abiasën tsyuecquid Adonën tsyuecquidbidi nepanëdash. Aidi, Nuquin Papa tabadte shubu uashunaid nuntanshun nashunquid icpanëdash. Aidën chido Adonën tsyuecquidbidi icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aton bënëbëdi Nuquin Papan chiaid tantiaquin naquidquio icpanëdash. Adquid icsho Nuquin Papan bëdamboen isaidquio aid daëdi icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Edisabed bacuë tishesa icpanëdash. Adquid yequi aton bënëbëdi tsusio budpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Adashic, Nuquin Papa tabadte shubu uashunaid nuntanshun nabanuec padpidemboec Sacadias puduedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ambi noadte bëda tauite ushë chonoc Sacadias aid shubun puduedpanëdash. Ënden abipadquid utsibobëdtan abi cuëmëdquid-cuëmëdquidquien dada uashun dada uatempi tëchun sandoshon cadotaniac ambi dada uatsaidëmpi abia puduenacsho isacpadec Sacadias puduedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Noadte bëda tauinuec utsi puduedtemaid quënë yacno puduedpanëdash. Ambo Sacadias puduedash icnubi Nuquin Papa tabadte shubu uashunaid puduedte quënë yacno utsibo dadpen Nuquin Papa chiec onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Adnubien utsi puduedtemaid quënë yacno Sacadias icnubi ambobi Nuquin Icbon chomiaid, ambi uaid mayan bëda, chopanëdash. Noadte tauinun sanaid dayun abiucquio tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Adec tabadsho isash dacuëdampambo iquec, quetanec Sacadias uëdëquiampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Adsho isash Nuquin Papan uaid mayan bëda nadpanëdash: —Bacuë bunquin mimbi chian-chiamboed Nuquin Papan tantiaidquio neque. Dacuëdenda, Sacadias. Min chido Edisabedën min mado tishendac. Min mado tishacsho Uan cuënta. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Min chidon tishaid isash mibi bëdambo iquendac. Aidi mibi bëdambo icmequid iquendac. Aidën chuibanaid tantiash matses dadpen bëdambo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aidi Nuquin Papan bëdamboen isaidquio iquendac. Paëmbocquid min madon isuidendac. Abi tishaid ushën abëd icmenuequin Nuquin Papan aton Mayan meniaidquio min mado iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nuquin Papan chiaid tantiaquidquio icquin aidën chiac isadaidbo dadpen Nuquin Papan chiaid niacquid icboedi, Con Icbo Nuquin Papa nec, queoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Min mado Nuquin Icbo bëyucanec choendac. Tsusedpa Ediasën chiampicpadquiequi dacuëdenquio icquin cuembo chuibanquidquio min mado iquendac. Aden chuibanquid Nuquin Icbo bëyucanec choendac. Tsusedpabon tishmiaidën tsyuecquid dadpen tantiesabo icboedi min madon chiac tsusedpabopadquid tantiaquidquio nëbi tabadquido iquendac. Aido Nuquin Papan chiaid niacboedi min madon chiac Nuquin Papan chiaid naquidquio iquendac. Nuquin Icbon matses aido icmenuen min madon chuibanendac —quepanëdash Nuquin Papan uaid mayan bëda. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aden Nuquin Papan uaid mayan bëdan chiaquien Sacadiasën: —¿Mitsipadentsimbi mimbi chuiboed tantiape? Con chidobëdi tsusio budpobi —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Adoaquien: —Ëbibi, Cabaded nebi. Nuquin Papan abëd tabadquin namiaidquio nebi. Nuquin Papan ambi chiacpadomboen mibi chuimenuen chomiaid nebique. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tantia. Chuinu. Min chidon bacuë tishendac, quequin Nuquin Papan chiaid ëmbi chuiboed tantienquio icsho mibi eme uaindac. Min chidon bacuë tishan padpidec mibi onquianoaindac —quepanëdash Nuquin Papan uaid mayan bëda Sacadias caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Adnubien noadte bëda tauite quënënuësh Sacadias baded puduenenquiocsho isash, Baded puduenenquiocpec, quequin cainec tabadpanëdash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aden yuen caimbudnubien puduenash onquenuequi buëd cuëdenquiocpanëdash Sacadias. Adsho isun: —Ushquin isacbimboen isbenac —cabededpanëdash. Adnubien Sacadiasën iccuededquido nidmenuen mëdante uic-uiccapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Adashic, Nuquin Papa tabadte shubu uashunaid nuntanshun nashunte ushëted nainash aton shubuno Sacadias nidoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ambo choash yuec tabadnubien aton chidon bacuë usundopanëdash. Aden usundoash mëdante auc abentsëcted ushë nidmec aton shubu nuntan icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Adec tabadec Nuquin Papan naid chiec nadec Edisabed onquepanëdash: —Bacuë usundoenquiocpec, cabededboedëmbi nëbi macho budshumbi ëmbi bacuë usundoacsho utsibon ëbi isec. Ëbi tantiaquin Nuquin Papan usundomiaid nebi —quepanëdash Edisabed. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Adashic, Edisabedën bacuë usundoan ushë 6ted nidan nidaid Cadidia caid yacno shubu dadpen icquid Nasaded caid yacno Nuquin Papan Cabaded chomeoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ambo aton chido bedabicquid, tsusedpa Dabidën tsyuecquid Ose cuëmëdquid icpanëdash. Aidi ambo tabadnubien uano aton chido Madia cuëmëdquid tsadacno Cabaded chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Adec choshon: —Mibi tantiaquin Nuquin Papan bëdamboen icmiaidquio mibi nec. Nuquin Icbo mibëdi tabadendac —capanëdash Cabadedën. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Adoaquien Madia, ¿Atotsi quepeba? quequin otacquio tantiec tsadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Adec tsadsho isun Cabadedën: —Dacuëdenda. Mibi bëdamboen tantiaquin Nuquin Papan naden nanu quequin chiaid nad iqueque. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chuinu. Tantiata. Bacuë usundoshon min mado mimbi tishendac. Tishun, Ëmbi tishaid Nuquin Papa yacno yuedanquidquio nec, quequin Esus cuënta. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mimbi tishaid chuiquid dapa iquendac. Aden mimbi tishaid isec, Nadatiambocquidën madombo nec, quecuededpendac utsibo. Tsusedpa Dabid chuiquid dapa Nuquin Papan icmiacpadomboembidi chuiquid dapa min Mado Esus icmeoaindac. Adoac Chuiquid Dapa Abentsëcquiobi aid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Adec tsusedpa Acobon tsyuecquido ënenquiocquin chuiquid dapa min mado Esus iquendac —quepanëdash Cabaded Madia chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Adoaquien: —¿Mitsipadentsimbi bacuë usundoshon bacuë tishpe? Chudabicquid nebi —quepanëdash Madia. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Adoaquien: —Nuquin Papan Mayan mibëdi tabadnuc mimbi tishendac. Aden Nadatiambocquin naidënquio Madia usundomiaid, icsa nibëdquid, Nuquin Papan madombobi nec, utsibon cabededendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Min utsi Edisabed macho icquin bacuë usundoenquiocboedëmbi nëbi bacuë usundoac. Usundoenquiocquid nec, cabededboedëmbi nëbi ushë 6ted nidan usundoac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Utsin natiapimbo yaid Nuquin Papan naidquio nec —quepanëdash Cabaded. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Adoaquien Madia: —Ai, con Icbon namiaidquio nebi. Ma mimbi chiacpadquio icpanuna —quepanëdash. Aden chiaquien Cabaded nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Adashic, aton na nacnenanec Madia tsusedpa Udan tsyuecquidon nidaid macuësh yacno badedi nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Adec nidashic Sacadias oncamenquio yaidën shubu yacno choec puduedshun Sacadiasën chido, Edisabed istuidash: —Mibi isnuec chobi —Madia quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Adsho Edisabedën tantianubi aton bacuë comapenec cuididiquiampanëdash. Adec aton bacuë cuididiquenubi Nuquin Papan Mayanën tantiamiac Edisabed ");
INSERT INTO mcfNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Madia chiec nadec comapenec onquepanëdash: —Nuquin Papan bëdamboshë icmiaidquio mibi nec. Mimbi usundoaid adembidi bëdamboshë icmiaidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nuquin Icbon tita mibi yec ¿atotsi quiash ëbi isnuec cho? ");
INSERT INTO mcfNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mibi isec chobi, mibi quesho ëmbi tantianubi, Cuishon, quiacbimboec con bacuë cuididiquianosh. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nuquin Icbon tantiacpadomboen chuisho tantiaquid mibi iquec mibi bëdambo icted-ictedendac —quepanëdash Edisabed Madia chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Adnubien Madia nadec onquec cuëdëmpanëdash: “Nuquin Papan naid chuibanu. Tantia. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ëbi usundomiaid Nuquin Papa yacno Yuedanquid nec, quequin tantiec bëdambo iquebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Ëbi ambi namiaid icsho bëdamboen isquin Nuquin Papan naosh. Adoacsho, Nuquin Papan bëdamboshë icmiaid Madia nec, quequin abitedishunquio tantiabededendac. Adembidi aton tsyuecquidon tantiabededoaic. Nuquin Papa icsaisa iquec. Icsatiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ambi chiaid tantiaquin naquid icsho, Mimbi naid icsa cuidnu, quenquiocquin abëdi shubu abentsëquën tabadacbimboecnuc adquid tabadmendac. Adenuidi tantiaquin nampidquio abi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nadatiambocquin naded-nadedquidquio Nuquin Papa nec. Ëmbibi tantiacpadomboen naimbi, quequid icsho isun Nuquin Papan cacumiac uano tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ancanquid dapa icboedi utsin namiaidquio adquid iquendac. Utsin namiaid icboedi chuiquid Nuquin Papan icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ambi chiaid tantiec bëdamboec tabadte comapenec bunquiacpaden naquidquio Nuquin Papan icmendac. Con na ëmbi bedaiduidi tantiec bëdamboec tabadebi quequid unësacsho cacumiac uano tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Chuiquid Dapa Abentsëcquiobi chidon usundoendac, quequin ambi tsusedpabo chuimiampicpadomboen Nuquin Papan ëbi usundomiac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tsusedpa Abadauambëdta aton tsyuecquidtedi ambi tantiampicpadomboen Nuquin Papan ëbi usundomiac. Mimbi usundoaid ëbi yacno yuedanquid nec, quequin Nuquin Papan ambi tantiampicpadembi ëbi isec,” quec comapenec cuëdënash Madia ënëdpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Adec ënëdash Edisabedbëd ushë daëd nidmec tabadashic ushë utsi nidbudtsëcnubi aton shubuno nidoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Adnubien Edisabedën bacuë tishte ushë chonoc dada bacuë tishpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bacuë tishenquiocboedëmbi nëbi aton bacuë tishosh, quesho tantiash aton matses ado shubu utsinquidotedi Edisabedbëd bëdambo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Adashic, 8tedec ushtanquin Edisabedën madon shui dëbid dëteshunu quesho tantiash utsibo cho-chopanëdash. Choash puduedash bacuëmpi aton papa cuëmëdquid cuënu quenubi ");
INSERT INTO mcfNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Edisabed: —Padenquio. Abi cuëmëdquid Uan nec —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Adoaquien utsibo: —Min matses utsi Uan cuëmëdquid nibëdec —queshun ");
INSERT INTO mcfNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sacadias ismenuequin mëdante uic-uiccaquin: —Abi cuëmëdquid chui. Tantianu —capanëdash utsibon. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Adoaquien dada uate bedshun, Abi cuëmëdquid Uan nec, quequin dada uaquin Sacadiasën ismepanëdash. Adoaquien: —¿Abimboda mimbi cape? —quecuededpanëdash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Adnubien Nuquin Papan oncameoac Nuquin Papan naid Sacadiasën chuibampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aden chuibansho tantiash: —Dacuëdampambo iquec. ¿Atotsiepashun onquenquiocboedëmbi nëbi onquequin Nuquin Papan naid chuibampec? —quecuededpanëdash utsibo. Aden tantianec aton shubuno nidaneshun ambi isboedbëdtabi ambi tantiaboed utsibon chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Adoac: —¿Mitsipadquidquio aton mado nepec? —quecuededpanëdash Sacadiasën mado Nuquin Papan tantiamiaidquio isbededec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Adnubien Uanën papa Sacadias Nuquin Papan Mayanën oncamiac nadec Esus chiec onquepanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nuquin Papa isadaidbon Icbo nec, quequin chuibanuna. Aidën isadaidbo icsaquid icsho cuidnushe quiash abided cuidadquid chomiac mayan icsan yuaid icboedi aidën mënchictequidquio isadaidbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Abi mënchicquid nadatiamboquid nendac. Tsusedpa Dabidën tsyuecquidquio aid nendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ambi chuimiaidon chiampicpadembi Nuquin Papan adquidquio icmianac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","73","Nuquin tsusedpa Abadauan tantiaquin Nuquin Papan ambi chiampicpadembi nuquin tsusedpabo aton tsyuecquidbëdtabi abi chieshënquido nidtiapimbo yacnombo abi yacno yuedanquid Nuquin Icbo Abentsëcquiobi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Abi cudasquin mënchicaid yec dacuëdenquio yec Nuquin Papan namiaidombo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Adquid yec icsaisa abipadquio bëdamboec tabadquid icsho nuqui aidën isendac ënenquiocquin.” Adec Esus chiec onquiashic nadec aton mado chiec Sacadias onqueoapanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Adnubien nëbi Nuquin Papan chomiaid chuibanquidquio mibi nec, quequin utsibon mibi cuënendac, mado. Nuquin Icbo choec, quequin utsibon tantiabicnuc bëyuc tantiashun abi chuiquidquio mibi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Adquid icquin mibi icsaquid icsho cuidnushe quiash abided cuidadquid tantiasho isash Nuquin Papa mibi icsaid tantienquio yec bëpiscudendac, quequin chuibanquid mibi iquendac, mado. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nuquin Papan matses tantiaquin naquidquio icquin abipadquidquio icsaisa abi yacnoshon chomiaidquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aidën tantiamiac unësash abi iquendac. Adquid shubu abentsëquën tabadacpadec tabadendac, quequin mimbi chiendac, mado,” quec Uanën papa Sacadias Nuquin Papan Mayanën oncamiac onquepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Adashic, Sacadiasën bacuë Uan caniacsho Nuquin Papan tantiamiaid yequi matses nibëdacno tabadcuenepanëdash ambi Esus chuibante ushë choabicnuc. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Adnubien, Doma yacno tabadquid, isadaidbo ancaquid dapambo, empedadod caid, Aucusto cuëmëdquid icpanëdash. Aucuston, ¿Ëmbi ancaido isadaidbo aton nabëdta tedtsi iqueque? Isquin tantiata, quequin Sidenio cuëmëdquid chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sidenio nidaid Sidia caid yacnocquido chuiquid, cobednadod caid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Min tsusedpa tishampid yacnoshon mibi cuëmëdquid mitsanabëdtabi dada uanuec nidtan, cac abëd icquido buanec isadaidbo nidanepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Adec utsibo nidnubien Ose aton chido Madiabëdi nidaid Cadidia caid shubu dadpen icquid Nasaded caid yacnoësh puduanec nidequi aton tsusedpa Dabid caid tishampidnombobi nidaid Udeya caid yacno shubu dadpen icquid Beden caid yacno chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aton chido Madia bacuë nua usunquidbëdi Ose abi cuëmëdquid aton nabëdtabi dada uanuec Beden yacno chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ambo choquin aton bacuë nuambo usumpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ambo matses dadpen cho-choash shubu abitedi puduedash tsucus-tsucustsëcquio tabadnuc nidaidën capuquid tabadacno puduedshun ambi bëyuc usundoaid Madian tishpanëdash. Tishun dashcute cuësh-cuëshun dapucshun nidaidën capuquidën pete sanaid cuesten ambi bëyuc tishaid dada bacuë Madian nampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aden Beden yacnoshon Esus tishnubien shubu nibëdacno obeca dadpen pemebanquin buanquido inchëshbudtsëqui choec tabadtuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Inchëshbudtsëqui choash tabadnubien inchëshnuc Nuquin Papan chomiac ambi uaid mayan bëda abuc chopanëdash. Aid uëshëmbo chënquenuc obeca pemebanquin buanquido dacuëdcuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dacuëdsho isash: —Chiaid bëda chuinuec chobique. Dacuëdenquiocquin tantiata. Chuinu. Ëmbi chuitequid bëda mibi, Cuishon, quetequid nendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nëbimbobi tsusedpa Dabid tishampid yacnoshon Beden caid yacnoshon mibi Nuquin Papa yacno yuedquid, Quidistu, Nuquin Papan Chomiaid tishosh. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Abi tishacno nidshun naden mimbi aidi ispec. Dashcute cuësh-cuëshun dapucaid nidaidën capuquidën pete santen uesho mimbi istuidendac. Bacuëmpi adquiec uesho istuidash, Nuquin Papan chomiaid Quidistu nec, mibi quependac. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aden chiec Nuquin Papan uaid mayan bëda onquenubien abëdi abipadquid utsi dadpen choash Nuquin Papan naid chiec nadec cuëdëncuededpanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nuquin Papa abucquio tabadquid abitedi uaquidquio bëdamboshë iquec. Nuquin Papan bëdamboen isaido ma abëdi tabadpanuna,” quec cuëdëmpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Adec cuëdënash Nuquin Papan uaido mayan bëdabo abuc nidoapanëdash. Adec nidan obeca pemebanquin buanquido Nuquin Icbon chiaid nanuec: —Nuquin Papan nuqui tantiameboed bacuëmpi isnuec Beden yacno nidnu. Nid —quianec nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Adec nidshun nidaidën capuquidën pete santen bacuë nanacsho istuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Isanec nidquimbi ambi isboedbëdta ambi tantiaboed chiac ");
INSERT INTO mcfNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tantiaquidtedi: —¿Midapadquidien capec? —quecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aden obeca pemebanquin buanquidon chiaid tantiash bëpiscudenquio yec Esusën tita, Madia, ¿Mitsipadquid con bacuë nepec? quequin bëpiscudenquiocquin tantiadenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Adnubien Nuquin Papan chiaid chuibocpadquiocsho isash obeca yacno choash obeca pemebanquin buanquido: —Ëmbi isboed ëmbi tantiaboed Nuquin Papan naidquio nec —quequin chiec onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Adnubien 7tedec ushtanquin aton madon shui dëbid dëtemiacsho isun, Nuquin Papan uaid mayan bëdan chiacpadomboen cuënaid Esus nec, quequin Madian aton mado cuëmpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Adshumbic, bacuë tishun aid bacuën shui dëbid dëtemeshun ushë abentsëc nidan utsi chotsëcnuc Moises Nuquin Papan dada uamiacpaden nanuen Madiabëdtan Osen Esus Edusaden yacno buampanëdash. Edusaden yacno choash Nuquin Papa tabadte shubu uashunaid yacno choshon, Con bacuë Nuquin Papan namiaidquio nec, quequin ismepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nuquin Papan naden nata quequin chiaid nad iquec: Bëyuc tishaid dada bacuë ëmbi namiaidquio con na nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mimbi bëyuc tishaid bedte bunquin ëbi tabadte shubu uashunaid yacno mimbi buanaid min mado cuidtequidoain dëbin daëd cuesunemeta. Dëbin nibëdnuc masën bëdambocquid daëd cuesunemeta. Aden nanuec Edusaden yacno choash aton mado niantiapimbo yec Madiabëd Ose Nuquin Papan chiacpadomboen nanuec aton madobëdi puduedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Adnubien Edusaden yacnombo tabadquid Simeyon cuëmëdquid Nuquin Papan naden nata quequin chiaid tantiaquin naquidquio icpanëdash. Aidi isadaidbo chuiquid dapa abentsëcquiobi cainquidquio icpanëdash. Aidi Nuquin Papan aton Mayan meniaidquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aidi Nuquin Papan Mayanën tantiamiac, Chuiquid Dapa Abentsëcquiobi Nuquin Papan bëdamboen isaidquio choacsho unësabicquin isendambi, quequin tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Adembidi Nuquin Papan Mayanën nidmiac Nuquin Papa tabadte shubu uashunaid yacno nidequi Simeyon puduedpanëdash. Ambo puduedash capunubi Nuquin Papan naden nata quequin chiaidquio nanuen aton bënëbëdtambi Madian Esus bëpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Esus bësho isun Simeyonën Esus bedshun icucquin Nuquin Papan naid naden chuibampanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Abitedishun Icbo icquin mimbi ëndenquio chiampid nëbi nëid isembi. Nëid isash unësmane quenquio yec, Cuishon, quec unësebi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mibi yacno yuedanquid nëbi isembi. Nëid mimbi chomiaid icsho ma abitedishunquio ispanuna. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nëidëmbi mimbi tantiacpaden chuibanquin isadaidbo bëdambo icmendac,” quepanëdash Simeyon. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aden chuibanubi, ¿Midapadquidquien con mado capec? quequin Madian aton bënëbëdtambi tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Esus chuibanquin naimbudshun Osebëdta Madia chiec Simeyon: —Bëdambo icmiaid mibi daëdi nec —quepanëdash. Aden chuishumbic Madiauidtsëqui naden Simeyonën chuioapanëdash: —Chuinu. Tantiata. Nëid bacuë tantiesa isadaidbo utsi-utsiec icsho Nuquin Papan uquë nësecaindac. Min mado tantiaquid utsi-utsiec icsho Nuquin Papan abi yacno puduedmiaid iquec bëdambo iquendac. Min bacuë, Esus, Nuquin Papa yacno puduedmianquid nec, quesho tantiashun matses dadpenshun icsamboen chuided-chuidedendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Adsho ambi ompoquin naid icsabëdta ambi tantiaid icsa tantiamequid min mado iquendac. Adobanquin ismiac unës uasho isash mibibi unësquio yec, Con madon natiambo iquebi, mibi quendac —quepanëdash Simeyon Madia chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aden Simeyonën chuinubi Nuquin Papan naden nanu quequin chiaid chuiquid chido Ana cuëmëdquid icpanëdash. Aidën papa Panued icpanëdash. Aidën tsusedpa Ashed icpampic. Aid aton bënën bedac abëdi seta 7ted matamiash tabadnubi ");
INSERT INTO mcfNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","aton bënë unëspanëdash. Aton bënë unësan Nuquin Papa tabadte shubu uashunaid yacno nidshun Anan tabadec nidenquiocquin Nuquin Papauidi tantiaquin buna mëmumbudnequin Nuquin Papa chuidenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ambo icnubi Esus bësho isun Anan Nuquin Papan naden nanu quequin chiampicpaden chuipanëdash: —Isadaidbo icsaquid icsho cuidnu caid mënchictequid nëid nec —quepanëdash Ana Esus chiec utsibon tantianubi. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Adashic, Nuquin Papan naden nata quequin chiacpaden nainash Osebëd Madia nidaid Cadidia caid yacno nidoash Nasaded caid yacno abi tabadacno choapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ambo tabadnubi aton bacuë Esus dada bëdambo yec canicuempanëdash. Aidi comapenen tantiaquidquio Nuquin Papan bëdamboen isaidquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Adashic, Ëmbi bëyuc tishaid unës uamenushe queshun intaquën aton shubu shëcuë ëcnoshcacsho isun aidon bëyuc tishaid unësmenquiocquin Nuquin Papan uaid mayan bëdan matampampid tantiate ushë yanuc Madia Osebëd Edusaden yacno nidoapanëdash. Nuquin Papan chiacpadequi setan-setanquiec nidtenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Adecbidi, Esus abi tishaid seta 12ted yanash canicuenash anibëd Edusaden yacno nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Adec ambo nidashic nami uabicquid petequid tantiaid ushëtedi tantiec tabadtenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Adec ambo tabadquin nainash Esus ambobi icnubi tantienquio yec Madia Osebëd auëshquio nidoapanëdash. Adec nidash inchëshbudtsëqui abëd choboedo yacno capuquin Esus nibëmbenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aden nibënquin istuidabi yec Edusaden yacno padpidec nidoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Daëdec ushquin nibënshun Nuquin Papa tabadte shubu uashunaid yacno puduedshun Esus tsadsho istuidpanëdash. Ambo tsadec Nuquin Papan chiaid tantiamequin chuibanquidbëd onquecuededsho istuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Adec onquec tsadsho isquin, Bëdamboen tantiaquin chuibanquidquio nëid nec, quequin utsibon tantiabededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Adnubien, ¿Mitsipadquid con mado nepec? quequin otacquio Madian tantiapanëdash. Aden tantiequi: —¿Atotsi quiash ëbi daëdi tantienquio yec nëmbo choash mibi tabade, mado? Unësquiocquin papabëdtambi mibi nibëmbeniombi —capanëdash anin. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Adoaquien Esus: —¿Atotsieshun ëbi nibëno? Con Pa shubu uashunaidën tabadnuec chobosh nebi. ¿Tantienquioda mimbi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aden Esusën chuisho anibëdtan Osen tantienquiocpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Adashien: —Nidnu. Nid, mado —anin cac cacuidenquio yec Nasaded yacno anibëdi choash tabadquin Madian chiaidbëdta Osen chiaid tantiaquin Esusën nadenepanëdash. Adec tabadnubi aton titan ambi isboedbëdta ambi tantienquio yaid bëpiscudenquiocquin tantiadenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Adnubien comapenen tantiec bëdamboec canidopanëdash. Adquid icsho Esus Nuquin Papan bëdamboen isacpadomboen adomboembidi matsesën isbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Adashic, seta 15ted matamec Tibedio Sesad cuëmëdquid, Doma yacno tabadequi abitedi ancaquid dapa, empedadod caid icpanëdash. Aidi Doma yacnocquido ancaquid dapa icnubien Ponsio Pidato cuëmëdquid, nidaid Udeya caid yacnocquido ancaquid, cobednadod caid icpanëdash. Aid daëd ancanquid icnubien Edodes cuëmëdquid, nidaid Cadidia caid yacnocquido ancaquid, cobednadod caidbidi icpanëdash. Ancanquid aidtedi icnubien Edodesën utsi, Uedipe cuëmëdquid nidaid Itudeya caid yacnocquidobëdi nidaid Tëdaconite caid yacnocquido ancaquid, cobednadod caidbidi icpanëdash. Ancanquid aidtedi icnubien Disanias cuëmëdquid nidaid Abidinia caid yacnocquido ancanquid cobednadod caid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ancanquid aidtedi icnubien Anasbëdi Caipas isadaidbo tsusio dapabo icpanëdash. Aid daëdi isadaidbo tsusio icnubien Uan, Sacadiasën mado matses nibëdacnombo tabadshobi Nuquin Papan, Ëmbi chiaid chuibanta, capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Adoac acte Odan caid cuëmano capuquimbi naden chuibampanëdash. Mimbi tantiaid icsa ënta. Aden ënsho isun mimbi icsambocquin naboed tantienquio yacbimboen Nuquin Papan mibi bëdamboen isendac. Ëmbi tantiaid icsa nainquiocquin ënu, mibi quesho tantiashun mibi acten mentono, quequin cho-choquid cho-choquidquien Uanën chuidednepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ëndenquimbo Nuquin Papan tantiamiac Isayasën Uan chuiquin dada uampicpadequi Uan icpanëdash. Naden Isayasën Uan chuiquin dada uapampic: “Matses nibëdacnombo tabadquidën ëcauanshun naden chiendac: Nuquin Icbombo choeque. Aid tantianu, quequin mimbi tantiaid icsa ëmbanta. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Umbo ancuenquio chosho isnu quequin cuembocnoc andëdshun ambescabanacbimboen abimbo chuiquidënquio chiaid tantianu, quequin mimbi tantiaid icsa ëmbanta. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aden ënshun Nuquin Papa yacno puduedmianquid chuiquid dapa abentsëcquiobi cuembocnoc mimbi tantiabenendac,” quequin Isayasën Uan tishabicnuc chuiquin dada uapampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aden ënden chiampicpadequi Esus bëyucanequin acten mentomenuec cho-choquid dadpen icsho Uanën nadopanëdash: —Nisin bacuë anipadquid nec. Aidbimboecquid icsambocquid mibi neyoc. Mibi adquid icsho isun ¿tsuntsin Nuquin Papan cuidnushe queshun ambi mënchictequid icta, quequin mibi chiosh? ¿Aidën chiaid tantiashta acten mentomenuec cho? ");
INSERT INTO mcfNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mentomete bunquin mimbi tantiaid icsa ënshun bëdamboec tabadquin utsibo ismebanta. Nuquin tsusedpa Abadauan Nuquin Papan bëdamboen isaidquio icpampic. Ambi tishmiaidën tishmiaid caidaid ëbi icsho Nuquin Papan bëdamboen isaidquio nebi, quequin tantienda. Abadauampadquid ambi chiaid tantiaquid bunquin, Matses icta, Nuquin Papan cac cuënotebi matses iquendac —quepanëdash Uan. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Adequi onquebudec: —Cuëte icsatedi matenu, quequin cuëte bacuëesa dëdshun mateshun icbon nëdëncaquin tauiec. Adquiecbidi tantiaid icsambocquid cuëshëdmenu, queshun bëdamboec tabadaid ismesa cuëshëdmeshun chian anëdënquequid Nuquin Papan nënendac —quepanëdash Uan. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Adoaquien: —Chian anëdënquequid Nuquin Papan nësiate ictiapimbocquin ¿atotsimbi napeba? —quepanëdash iccuededquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Adoaquien: —Mibi dasiuidaid daëd icsho dashcute nibëdquid isun mitsana abentsëc meneta. Adembidi pete nibëdquid icsho isun meneta —capanëdash Uanën. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Adecbidi ancanquid dapan matses utsin na bedtequid nëidted bedta caidotsen acten mentomenuec cho-chopanëdash. Choshon Uanën chuibansho tantiash: —Chian anëdënquequid nësiate ictiapimbocquin ¿atotsimbi napeba? —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Adoaquien: —Ancanquid dapan chiactedtsëqui bedta. Muaquin mitsana daëd uanuequin bedenda —capanëdash Uanën aido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Adashic, adecbidi sondado cho-choash: —¿Atotsimbi napeba? —quepanëdash Uan caic. Adoaquien: —Mitsana bedtequid bunquin icsamboen bedenda. Utsin naid tantiashun mua uaquin chienda. Mibi chuiquidën, Nëidtedi menenu, cac, Utsi bec cho, quenda —capanëdash Uanën sondado chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aden Uanën chuibansho tantiash: —¿Tsutsi nepec? ¿Nuquin Papan chomiaidta nepec? —quecuededpanëdash cho-choquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Adsho tantiash: —Mibi acten mentoquidquio nebi. Padnuen ëbipadquidpenquio nadatiambocquid choendac. Aidi bëdamboshëcquid nendac. Adquid icnuc ëbi icsaquid icsho ¿atotsieshun aid choec quequin chuiquidquio Nuquin Papan icmioshi? Aid choshon aton Mayan abi tantiaquidombo aidëmbi menendac. Aden meniac Esus tantiaquidombo ambi tantiaid icsa ënte bunquidquio icmendac aton Mayanën. Adoac ënsho isun pauquendac —quepanëdash Uan. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aden chuibanec nadpanëdash: —Piacbo ëshë uashun bitsi secatanquin nëdëncashun ëshë icbon dayun uacpadomboen abi tantiesa cuëshëdmeshun chian anëdënquequid nësiashun abi tantiaquidtedi abi yacno puduedmendac aidën. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aden Nuquin Papan chiaid dadpen chuibanquin: —Adomboen tantiaquin nabanta —capanëdash Uanën. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Adshumbic, ancanquid Edodesën tantiaid icsatsen Uanën chuibampanëdash: —Min utsin chido, mimbi bedaid, mimbi tantiaid icsa neque. Mimbi tantiaid icsa ënta —capanëdash. Aden chuiboshombic adomboembidi padpiden abibidi Edodesën tantiaid utsibotsen chuioapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aden ambi tantiaid icsa chuibansho tantiashun Edodesën Uan bedmeshun quënën nauedmepanëdash abitedishun tantianushe queshun. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Quënën nauedabicquin matses dadpen acten mentobampanëdash Uanën. Utsiboba mentoshombic Esustsen mentopanëdash. Adoaquien mentoacnoëshquiobi Esus Nuquin Papa chiec onquepanëdash. Adec onquenubien abu shëcuë nibëdboedi shëcnianec ");
INSERT INTO mcfNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","dëbimbimboec cuembo budec Nuquin Papan Mayan Esusën mapino tsadtoec budpanëdash. Aid budnubien abucuësh Esus chiec nadec aton Papa onquepanëdash: —Mibentsëquiobi icsho ëmbi tantiaidquio mibi nec, mado. Adembidi ëmbi bëdamboen isaidquio mibi nec —quepanëdash aton Papa. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Adashic, abi tishaid seta 30ted icquimbi Nuquin Papan chiacpaden naquin tauapanëdash Esusën. Aden tauaquin chuibansho tantiash aton matses nadpanëdash. Osen mado nec, quiash, Nuquin Papan mado nec, quenquio yec matses onquepanëdash. Esusën papapenquio Ose icnëdash. Madia aton tita icbo icnuc Esusën tsusedpabo nëidtedi iquec: aton buchido Edi cuëmëdquid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aidën papabic Matac cuëmëdquid, aidën papabic Debi cuëmëdquid, aidën papabic Ana cuëmëdquid, aidën papabic Ose cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","aidën papabic Matatias cuëmëdquid, aidën papabic Amos cuëmëdquid, aidën papabic Naun cuëmëdquid, aidën papabic Esdi cuëmëdquid, aidën papabic Nacai cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","aidën papabic Mac cuëmëdquid, aidën papabic Matatias cuëmëdquid, aidën papabic Semei cuëmëdquid, aidën papabic Ose cuëmëdquid, aidën papabic Uda cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","aidën papabic Uana cuëmëdquid, aidën papabic Desa cuëmëdquid, aidën papabic Sodobabed cuëmëdquid, aidën papabic Sadatied cuëmëdquid, aidën papabic Nedi cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","aidën papabic Medqui cuëmëdquid, aidën papabic Adi cuëmëdquid, aidën papabic Cosan cuëmëdquid, aidën papabic Edmodan cuëmëdquid, aidën papabic Ed cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","aidën papabic Osue cuëmëdquid, aidën papabic Ediesed cuëmëdquid, aidën papabic Odin cuëmëdquid, aidën papabic Matac cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","aidën papabic Debi cuëmëdquid, aidën papabic Simeyon cuëmëdquid, aidën papabic Uda cuëmëdquid, aidën papabic Ose cuëmëdquid, aidën papabic Onan cuëmëdquid, aidën papabic Ediaquin cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","aidën papabic Medeya cuëmëdquid, aidën papabic Menan cuëmëdquid, aidën papabic Matata cuëmëdquid, aidën papabic Natan cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","aidën papabic Dabid cuëmëdquid, aidën papabic Isai cuëmëdquid, aidën papabic Obed cuëmëdquid, aidën papabic Bos cuëmëdquid, aidën papabic Sadomon cuëmëdquid, aidën papabic Nason cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","aidën papabic Aminidad cuëmëdquid, aidën papabic Adan cuëmëdquid, aidën papabic Eston cuëmëdquid, aidën papabic Pades cuëmëdquid, aidën papabic Uda cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","aidën papabic Acobo cuëmëdquid, aidën papabic Isac cuëmëdquid, aidën papabic Abadauan cuëmëdquid, aidën papabic Tade cuëmëdquid, aidën papabic Nacod cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","aidën papabic Seduc cuëmëdquid, aidën papabic Dacau cuëmëdquid, aidën papabic Pedec cuëmëdquid, aidën papabic Ebed cuëmëdquid, aidën papabic Sada cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","aidën papabic Cainan cuëmëdquid, aidën papabic Adpashad cuëmëdquid, aidën papabic Sen cuëmëdquid, aidën papabic Noe cuëmëdquid, aidën papabic Damec cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","aidën papabic Matusaden cuëmëdquid, aidën papabic Enoc cuëmëdquid, aidën papabic Aded cuëmëdquid, aidën papabic Macadaded cuëmëdquid, aidën papabic Cainan cuëmëdquid, ");
INSERT INTO mcfNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","aidën papabic Enos cuëmëdquid, aidën papabic Sed cuëmëdquid, aidën papa abia uampid Adan cuëmëdquid, aidën papambo Nuquin Papa abia yanampidquio nec. Abi tabadec. Aidtedi Esusën tsusedpabo nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Adshumbic, Matses nebi, quequin Nuquin Papan chiacpaden nanuen acten mentomepanëdash Esusën. Aden Uanën acten mentoaquien Nuquin Papan Mayanën chiacpadec acte Odan caid yacnoësh puduanec matses nibëdacnombo nidash tsadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ushë utsi nidash utsi choaid abuctotsëcquiecnuc ambobi tsadpanëdash. Aidtedi ushquin penquio yash Esus bundopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bundoacsho isash Nuquin Papa chieshënquid choash Satanas nadpanëdash: —Nuquin Papan madombo icquin penun cuënotebi pete icta cata —capanëdash Satanasën Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Adoaquien: —Padi: “Peteuidi pec bëdamboec tabadtemaid nec,” quequin dada uapampic —quepanëdash Esus Satanas caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Adoshombic, macuësh dapa abucquio yacno Esus buanshun Satanasën badedquio nidaidtedi ismebampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ismiash: —Nidaidën icquidtedishun icbo icmiaidquio nebi. Abitedi con na nec. Ëmbi menenu cac aidtedi mitsana iquendac. Nidaidën tabadquidtedi chuiquid dapa mibi icmete bunebi. Adquid mibi icnuc mibi buntequid nibëdendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nidaidën tabadquidtedi chuiquid dapa icnu quequin, Con icbo mibi nec, ëbi casho adquid mibi icmembi —quepanëdash Satanas Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Adoaquien: —Padi. Nuquin Papan chiaid dada uapampid nad iquec: “Nuquin Papa abentsëcquiobi mimbi tantiaiduidtsëqui min icbombo neque. Aidën namiaidquio icta” —quepanëdash Esus Satanas caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Adoshombic Edusaden yacno Esus buanshun Satanasën Nuquin Papa tabadte shubu uashunaid macano abucquio tsadumpanëdash. Aden tsadunshun: —Mibi Nuquin Papan madombo yec nëuëshquio dacuëdenquio yec pudunta. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Naden dada uapampid iqueque. Tantia. Chuinu. “Mibi pudunsho isun, Tsicatequin bëdamboen budmeta, quequin Nuquin Papan ambi uaido mayan bëdabo chiendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aidombi min taën tsasimbocquid tincanushe queshun uidën uaquin mibi bëdamboen budmendac.” Aden min Papan chiaid icnuc dacuëdenquio yec pudunta —capanëdash Satanasën Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Adoaquien: —Chuinu. Tantiata: “Nuquin Icbon ambi chiacpadembida natsiashe, Isnu, quequin tanenda,” quequin Nuquin Papan chiaid chiampid utsi iquec —quepanëdash Esus Satanas caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aden chiaquien Satanasën Esus icsamboen namenuen tanquin naimbudpanëdash. Aden naimbudequi, Padpidemboen ëmbi chiaid namenuequin Esus tanun nanuna, quequin ambibi tantianec Esus nianec Satanas nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Adashic, Nuquin Papan Mayanën tantiamiaidquio iquequi matses nibëdacnoësh Cadidia yacno Esus choapanëdash. Choacsho isun, Nuquin Papan Mayanën tantiamiaidquio nec, quequin abi isquidon chiac dëuequidon tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Adnubic, Nuquin Papan chiaid chuibante shubu utsin-utsinquiec puduedcuenequin Nuquin Papan chiaid Esusën chuibampanëdash. Aden chuisho tantiash, Nuquin Papan chiaid tantiaquidquio Esus nec, quec cuëdëncuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Adashic, Nasaded yacno abi caninëdacno Esus nidoapanëdash. Ambo choash chonoadtemaid ushën Nuquin Papan chiaid chuibante shubu yacno nidash abi puduedteniacpadequi puduedash Nuquin Papan chiaid isec onquenush nidtopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nidtosho isun Nuquin Papan chiaid Isayas cuëmëdquidën dada uapampid anocquidën Esus menepanëdash. Aden aid meniac sananquin seccudoabanquin isbanec nadec Esus onquepanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nuquin Icbon Mayanën namiaidquio nebi. Aidën Nuquin Papan chiaid tantiambo yaid chuibanta caid nebi. Quënën nauedaido ambi tantiaid icsa ëmenuen chuibanta caidquio nebi. Aidëmbidi Satanasën yuaid Nuquin Papan bacuë icmenuequin chuibanta caidquio nebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aidën Nuquin Icbon bëdamboen iste chuibanta caidquio nebi.” ");
INSERT INTO mcfNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Adec isec onquequin nainshun dada uaid bidicashun meniash tsadpanëdash Esus. Adec tsadsho shubu nuntan icquidtedishun bëisbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Adoac: —Nuquin Papan chiaid mimbi tantiaboed nëbimbobi tauadoec —quepanëdash Esus abibi chiadequi. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Adoaquien: —Bëdamboen chuipec. ¿Mitsipaden tantiaid ambi chiaid nepeba? —quecuededpanëdash. Adec onqueboedobi: —¿Osen mado Esus nenquioda ictic? —queoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Adoaquien: —Bëdamequid yequi abibi daicsambo yanash bëdamiadacsho isash, Bëdamequidquio nec, quequin matsesën tantiapec, quequin chuipampid nec. Ëmbi Capednaun yacnoshon nabambocpadomboen nëshuntsen nabansho isun, Nadatiambocquin nabanquid nec, quequin mibitedishun tantiapec. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Abimbo chiembique. Tantiata —quiash Esus abi onquec: —Nuquin Papan ëmbi tantiamiacpaden chuibanta caidën abi caniacnoshon chuibansho tantienquiocquid icpec. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ëndenquimboshë adomboembidi Nuquin Papan ëmbi tantiamiacpaden chuibanta caid Edias cuëmëdquidën chuibansho tantiesa icpampic. Aidi icnubien isadaidbon bënua chidobo dadpen icpampic. Aido adquid icnubien seta abentsëc chotsëcnuc matamec aton pete nibëdquiec yanubi isadaidbon bënuabo bunec tabadpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Adec bunec tabadsho isun, Isadaidbon bënua yacno nidta, quenquiocquin isadaidpembon bënua yacno pemenuec nidta cac Edias nidshun ambi chiacpadomboen isadaidpembon bënuan nanuc aton pete uesadenquiocpampic. Aid chido shubu dadpen icquid Sadecta caid yacno tabadpampic. Sadecta shubu dadpen icquid Sidon caid anoentsëqui icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Adashic, adecbidi isadaidbo abi daushumbo yacno mishac mishadenquio yacbimboecquido dadpen icpampic. Adquido icnubien Nuquin Papan namiaidquio utsi Ediseyo icpampic. Aidëmbi isadaidbo daushumbocquido bëdamenquiocquin isadaidpembo abentsëc Naman cuëmëdquid Ediseyon bëdamepampic. Ëbi bëdamepec, quequin tantiec aton nidaid Sidia caid yacnoësh choacsho Ediseyon Naman bëdamepampic —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aden Esusën isadaidpembo nashumpampid chuisho tantiash iccuededquido isadaidbo comapenec nëishpanëdash. Isadaidpembobëd isadaidbo ictiapimbo iquec, quec iccuededquido nëishpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Adec nëishash nidanec nuntanuësh puduenanec shubu ënëdacno nidshun acte dapa quiusudacnombo nebudnuequin Esus buampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aden nidmiaquien matses dadpen icquid natsusash Esus nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Adec abi caniacnoësh Nasaded caid yacno nidtanashi nidaid Cadidia yacno nidequi Capednaun caid yacno Esus choapanëdash. Ambo choash chonoadtemaid ushë icnuc Nuquin Papan chiaid chuibante shubun puduedshun Nuquin Papan chiaid chuibampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aden chuibansho tantiash: —Ambia tantiaquidën chiacpaden chuibanquidien Esus nechitec —quecuededpanëdash anocquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aden Esusën chuibanubien Nuquin Papan chiaid chuibante shubu nuntan mayan icsa dapuduedaid icpanëdash. Aidi comapenec sidquetanec onquec: ");
INSERT INTO mcfNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Nasaded yacnocquid Esus caid atotsi quec mibi cho? ¿Ëbipadquidtedi naimbudmenuecta cho? Ëmbi isaid mibi nec. Nuquin Papan bëdamboen isaidquio, icsapenquiocquidquio mibi nec —mayan icsan caquien: ");
INSERT INTO mcfNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—Otacquio tabad. Adec tabadec dapuduenta —Esusën cac mayan icsan abi dapuduedaid tacpanën nebudec icsa uainquio yec dapuduempanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Adosho isash tantiadempambo iquequi: —¿Chuiquid dapan chuitequidta neque? Tantiabono. Nadatiambocquin chuibanac mayan icsabo dapuduenchitequien nec —quepanëdash Capednaun yacnocquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aden tantiaquin Esusën mayan icsa dapuduemiosh, quequin isquidon chuiban-chuibanac Capednaun yacno dëuequidtedishuntsen tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mayan icsa dapuduemiashic Nuquin Papan chiaid chuibante shubu yacnoësh puduenanec Simonën shubu yacno Esus nidpanëdash. Ambo puduedacsho isun: —Simonën nachi chumboshë iqueque. ¿Ada aid bëdametsia? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Simonën nachi yacno choash dayunquio nidtuidec: —Chumbocquid dauebudta —Esus quenubi badedquio dauebudpanëdash. Adec dauebudash nidtoshon codocashun Esusbëd icquido pemepanëdash Simonën nachin. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Adshumbic, inchëshbudtsëqui daicsaid utsi-utsien bë-bëpanëdash. Aden bë-bësho isun damishquin Esusën bëdamepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Adembidi mayan icsa utsi-utsien dapuduemepanëdash. Adoac, Nuquin Papan madombobi mibi nec, quec sidquesho tantiashun: —Nuquin Papan chomiaid nec, quequin ëbi chiec adec onquenda —Esusën cac mayan icsa ënëdpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Adashic, badiadnuc matses nibëdacno Esus nidpanëdash. Esus nidacsho isun matses dadpenshun nibënquin istuidshun: —Nidenquio yec ëbëdi tabadta —capanëdash istuidquidon. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Adoaquien: —Shubu dadpen icquid utsi-utsiec yacno nidshun Nuquin Papa yacno tabadaid iquec, quequin anocquidotsen tantiamenuec nidendabi. Nuquin Papan chomiaid icquin chuibanun nabono —quepanëdash Esus abi nibënquin istuidquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aden chiashic Nuquin Papan chiaid chuibante shubu utsin-utsinquiec puduedcuenequin Nuquin Papa yacno tabadte iquec quequin chuibampanëdash. Nidaid Udeya caid yacno shubu dadpen icquid utsi-utsiec yacno choshon aden Esusën chuibampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Adashic chian Quenesaded caid cuëmambi tabadquin Esusën Nuquin Papan chiaid chuibansho tantiec iccuededquido dadpen tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Adnubien masi yacno aton cano daëd nëshun icbon aton nëshaidtedi pambampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Adsho isanec nidash Simonën cano antsadtoshon, Udictsëc ëbi buan, Esusën cac Simonën udictsëc buampanëdash. Aden buanac chian cuëman iccuededec tabadshobi cano antsadquin Esusën chuibampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aden chuibanquin nainshun: —Shodombo yacno nuëcquid bednuequin nëshaid nënebanta, Simon —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Adoaquien: —Icbo, inchëshëmbi nuëcquid bednuen nëshaid nënebenequin ëbitedishun bedamboccombi. Mimbi nëshaid nënetan cac nënetanembi —quepanëdash Simon. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Adash shodombo yacno nidshun nëshaid nënetanquin nuëcquid dadpenquioshë bedac nëshaid tësëdec taëpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Adsho isun abëdtan nuëcquid beduidboedo cuënquin, Cadoec cho, quequin ismiac aido cano utsin choshon cano cubu-cubutsëcquiocnoc nuëcquid sandoac cano daëd mentoadtsempanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Adoanec Esus yacno choequi danëshën sebudec shuebudash Simon Petedon: —Icbo, ëbëd iquenquio yec nidaneta. Icsambocquid nebique —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Abëd icquidobëdtan nuëcquid dadpen bedboed tantiadempambo iquec, Esus nadatiambocquid nec, quequin tantiec onquepanëdash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Acobo Uan chedo tantiadempambo yec tabadoapanëdash. Aid daëdi Sebedeyon mado icpanëdash. Adec Petedo shuebudash onquesho tantiatanec Esus nadpanëdash: —Dacuëdenda. Mimbi nuëcquid penun acten bedbocpaden nëbi tauain ëbi tantiaquid icmenuen nidaidën capucuenequin abuc tabadaid mimbi chuiban-chuibanendac —quepanëdash Esus Petedo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aden chiaquien aton cano acte cuëman nëshanec aton natedi nianec, Esusën chiacpaden tantianuna, quianec abëdtan nuëcquid bedboedobëdtan Petedon Esus nidsho tsibanampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Adashic, shubu dadpen yacno Esus icnubien daushumbocquid nami mishac paëpenquiocquid chopanëdash. Aidi choash Esusën taëno shuebudec nadpanëdash: —Ëbi bëdamete bunquin ëbi mimbi bëdamepec —quepanëdash daushumbocquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Adsho tantiashun adquid daushumbocquid mishtemaid nec, quenquiocquin damishec Esus: —Mibi bëdamete bunebique. Mibi bëdamenu —quenubi badedquio bëdampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aden bëdametanec Esus: —Ëmbi naid utsibo chienda. Adenquiocquin isadaidbo tsusiobo ismetanta ma bëdamiaid Nuquin Papan naid nec quequin ma aidon tantiapanu. Aido ismeshun Nuquin Papan ambi chiaid Moises dada uamiampicpadembi bëdambo icmiaid cuidtequidquio meneta —capanëdash Esusën ambi bëdameboed chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Adnubien Esusën bëdamesho isquidon Esusën bëdamiaid chuibanac matses dadpen Esusën chiaid tantianuec cho-chopanëdash. Adecbidi, daicsambocquido bëdanuec cho-choacsho Esusën bëdamepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Adashien matses nibëdacnombo nidash Nuquin Papa chiec onquepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Adashic, ushë utsin Esusën chuibanuc padiseyobobëdi Nuquin Papan naden nata quequin chiaid tantiamequid dadpen tabadpanëdash. Utsi-utsiec nidaid Cadidia yacnoësh cho-chonobi utsi-utsiec nidaid Udeya caid yacnoësh cho-chonobi utsi-utsiec Edusaden caid shubu dadpenquioshë yacnoësh cho-chopanëdash. Adec aido cho-choash tabadnubien Nuquin Papan nadatiambocquin naquid icmiac matses bëdamenuec Esus icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aid icnubien dada shëquëquenquiocquid aton din nandoshon aton utsibon bëpanëdash. Aden bëquin shubu nuntan nënantanquio Esus icnubi ");
INSERT INTO mcfNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","matses tsucus-tsucustsëcquiocsho isash puduedtiapimbo yec macano pada-padapambo yacno dada shëquëquenquiocquid buanec dectatoshon macano chic-chicshun dada shëquëquenquiocquid abi bëquidon imbudpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dada shëquëquenquiocquid ëmbi bëaid Esusën bëdamec, quequin tantiaquin bëquidon ambi bëaid imbudsho isash dada shëquëquenquiocquid caic: —Mimbi tantiaid icsa cuidenquio yec bëpiscudtequidquio mibi nendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aden chuisho tantiash padiseyobobëd Nuquin Papan naden nata quequin chiaid tantiamequid: —¿Nuquin Papanuidi chuitequidquioda chuibamposh? ¿Tsutsi aden chuibanquid nepec? Nuquin Papauidi tantiaid icsa cuidenquio yec bëpiscudquidquio nec —quepanëdash ambibi tantiacpadec onquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aidon tantiaid tantiec Esus: —¿Atotsi quiash mimbibi icsamboen tantiec onquepe? ");
INSERT INTO mcfNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Mimbi tantiaid icsa cuidenquio yec bëpiscudtequidquio nendac ëmbi chiaidquio bëdantequidpenda nedic? Adecbidi, ¿Mibi icsambocboedi mibi bëdanoque. Nidtoash nidta, quequin chiaid bëdantequidpenda nedic? ");
INSERT INTO mcfNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nuquin Papan chomiaid icquimbi mimbi tantiaid icsa cuidenquio yec bëpiscudtequidquio nendac ëmbi cac ad iquendac. Nuquin Papan chuimiaidquio nec mibitedi camenuen dada shëquëquenquiocquid naden chiembique Tantia. Nidtoash nidquin min di buanec nid —capanëdash Esusën dada shëquëquenquiocquid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Adoac nidtoshon aton di bedanec Nuquin Papan naboed chuibanequi aton shubuno nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Adsho isash tantiadempambo yec Nuquin Papan naid chiec onquecuededec tabadpanëdash: —Aden bëdamiaid isenquiocboedëmbi nëbimbobi aid isbempombi —quecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Adashic, capucuenequin Debi cuëmëdquid Esusën istuidpanëdash. Debi nec queshumbi Mateyo cuëmpanëdash. Ancanquid dapan utsibon na bedtequid bedshumbanta caid Debi icpanëdash. Ancanquidën chiacpaden Debin utsibon na bedtequid bedbansho isun: —Ëmbi chiaid tantianush ëbi tsibanec cho —Esusën cac ");
INSERT INTO mcfNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Debi nidtoanec aton natedi nianec Esus tsibananec nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Adshun aton shubuno Esus buanshun Debin pemepanëdash. Ancanquidën utsibon na bedtequid bedbanta caido abipadquido dadpembëdtabi Esus Debin pemepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aden adquidobëdtan Esusën pesho isash padiseyobo: —¿Atotsieshun mibi chuiquidbëdtan mibitedishun icsambocquidbëdtan pepeba? —quepanëdash Esusbëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aden chuisho tantiash Esus nadpanëdash: —Ëbi bëdamec cho, quenquio bëdambocquid iquec. Daicsambocquidien, Ëbi bëdamec cho, quendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Adecbidi, Nuquin Papan bëdamboen isaidquio icsho, Mimbi tantiaid icsa ënta, quequin chuinuec choenquio iccondabi. Nuquin Papan icsamboen isaidquio icsho, Mimbi tantiaid icsa ënta, quequin chuinuec chondabi —quepanëdash Esus padiseyobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aden Esusën chuibansho tantiashun naden padiseyobon Esus chuipanëdash: —Uambëd icquido buna mëmunec Nuquin Papa chiec onquedenec. Adquiecbidi ëbëd icquido buna mëmunec Nuquin Papa chiec onquedenec. Adenquio mibëd icquido iquec. Aidon buna mëmunenquiocquin peshun sicaid actenec —quepanëdash padiseyobo Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Adoaquien: —Aton chido bednun pambid meniac chidon codocacsho abi inquidën abëd icquido menec. Aden meniac isuidesa abëd icquido nec. Adecbidi ëbi abi chuiquid icnuc ëbëd icquidon buna mëmunenquiocquin isuidenquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yuecash chido inquid nibëdanan abëd icboedo unësquiocquin buna mëmunquin isuidpec. Adecbidi ëbi nibëdanan ëbëd icboedo unësquio yampec —quepanëdash Esus padiseyobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aden chuibanequi abi Esus onquec: —Dashcute chuca cuëshun dashcute shënibëdta nacnenquin bëtuscaisa matses nec. Cuëshquin dashcute chuca icsa uaic. Adecbidi shëni tuscaid bëtësëdec. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Adembidi dadpen icquid chodo uashun sandoec. Adotanquimbic istuidshun chuca uain chodo uashun sandoaic chodo shënin icsa sandoshon nequid bëenquiocquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Adembidi, ëmbi ënden tantiaiduidi tantianu, quequin Nuquin Papan nëbi chiaid pausudtequid bëda tantiauidquid yanec icsabudendac. Mibi adquid iquec, quequin tantiaquin utsi chiacbimboen Esusën padiseyobo chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Adashic ambi ënden chiaid tantienquiocboedi nëbi Nuquin Papan chiaid utsi chuibanac tantiaquidquio iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Adashic, chonoadtemaid ushë icnuc Esusbëdtan abëd icquidon tied matanquin tiedën caniquid ëshchicshun abëd icquidon bitsi tsucucashun pebededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aden pesho isquin padiseyobon: —¿Atotsieshun chonoadtemaid ushën chonoadpeque? Tantianu. Ëbi chui —capanëdash Esusbëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Adoaquien: —¿Tsusedpa Dabid caidbëd icquidon piasquin pepampid tantiamboda ique? ");
INSERT INTO mcfNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Naden chuipampid neque. Tantia. Abëd icquidobëd Nuquin Papa tabadte shubu uashunaid puduedtemaid quënën puduedshun Nuquin Papa tantiaquin pan meniac nanaid chuiquid dapan bedshun abëd icquido menebanshun aidobëdtambi pepampic. Aid pan Nuquin Papan namiaidënuidtsëqui petequid nepampic —quequin padiseyobo chuishun Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","—Ëbia: Tiboquenu, quiash tsadacpadec matses: Nëid chonoadtemaid ushë nec, quequin tantiec. Adnubini aid ushë icbo yec tiedën caniquid ëshchicshun bitsi tsucucasho isash: Mimbi icsamboen naic, quetiapimbo iquebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Adashic, chonoadtemaid ushë utsin Nuquin Papan chiaid chuibante shubun puduedshun Esusën chuibanubien abiucquio mëuesadaid dada icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ambobidi tabadquimbi Esus chieshënquidon, Chonoadtemaid ushën Esusën bëdamenushe. Isnu, quequin padiseyobon caimbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aden cainubien abi chieshënquidon tantiaid tantiaquin mëuesadaid isquin: —Nënantanquio nidto —Esusën cac mëuesadaid nënantanquio nidtoash nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Adsho isashien: —Tantianu. Chui. ¿Chonoadtemaid ushën matses tantiaquindambi bëdamboen nape? ¿Adoenquiocquindambi bëdametemaid ushë nëid neque? ¿Mibi nëbi bëdametiapimbo iquebi, quequindambi chuipe? ¿Adoac daicsaid utsi-utsiec unëspec? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aden chuishumbic iccuededquido isbanquin: —Ëbi mëd —cac Esus mëdequi mëuesadaid bëdampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Adec mëuesadaid bëdansho isashien comapenec nëishash: —¿Mitsipadentsimbi Esus acpe? —quec onquecuededpanëdash abi chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Adashic, ushë utsin macuësh yacno matses nibëdacno Nuquin Papa chiec onquenuec nidash inchëshën ushenquio yec Nuquin Papa chiec Esus onquepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Badiadshun abëd icquido dadpen chomeshun, Ëbi chuibeneta, quequin 12tedictsëqui chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nëidic, Simon, Esusën Petedo caid; utsibic, Andedes, Simonën utsibi; utsibic, Acobo; utsibic, Uan; utsibic, Uedipe; utsibic, Badtodome; ");
INSERT INTO mcfNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","utsibic, Debi cashumbic Mateyo caid; utsibic, Tomas; utsibic, Acobo, Adpeon mado; utsibic Simon, ancanquid isadaidpembo bunesa; ");
INSERT INTO mcfNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","utsibic, Udas, Acobon mado; utsibic, Udas Iscadiote, yuecshun Esus chieshënquido Esus bedmequid. Aidtedi, Esusën, Ëbi chuibeneta, caido icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Adashic macuësh yacnoësh abëd 12ted icquido pada-padambo yacno budash abi tsibanquido dadpen icsho isash Esus nidtuidpanëdash. Nëidted icpanëdash: Nëidic, Edusaden yacnoësh choquido; utsibic, Acte Dapa cuëman shubu dadpen icquid Tido caid yacnoësh choquido; utsibic, Sidon caid yacnoësh choquido. Aido Esusën chuibansho tantianuec cho-choash tabadnubi, Ëbi bëdamepec, quequin tantiec utsibo choash tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Adec choquido mayan icsa dapuduedaid icsho isun Esusën dapuduemepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Adsho isun nadatiambocquid Esus neque. Mishnu, queshun mishequi bëdancuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Adshumbic abëd icquidombo isbanquin naden Esusën chuibampanëdash: —Nëmbo mibi icnuc mitsana nibëdtenesho isun Nuquin Papan bëdamboen isaido iquec abuc nidan con natedi mitsana nendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nëuëshquio bundodenesho isun Nuquin Papan bëdamboen isaido yec abuc ëbëd tabadec bundoesa iquendac. “Nëuëshquio matses Nuquin Papan chiaid tantiesa icsho isash unësquio yec shubidednequid Nuquin Papan bëdamboen isaid yec abuc nidash ëbëd tabadec bëdambo iquebi quependac adquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Esus tantiaquid icsho chieshënquin pudued cainquio yaid adembidi mua uaquin chuishunaid Nuquin Papan bëdamboen isaidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Adomboembidi ëmbi ëndenquimbo chuimiaid aton matsesën icsamboen chuishundeniampic. Adomboembidi mibi min matsesën icsamboen chuishundenetsiash. Nidaidënshun adoaid iquec Nuquin Papa yacno choacsho ambi bëdambo icmiaid mibi iquendac. Adquid iquendabi quequin tantiec mibi icsamboen chuishunaqui, Cuishon, queta. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Padnuen, con na dadpen iquec, quequin tantiec bëdamboec tabadebi, quesho Nuquin Papan icsamboen isaido mibi nec. Nidaidënshun mimbi bedteniaiduidi tantiec Nuquin Papa yacno puduedtiapimbocquid mibi iquendac. Nidaidën bëdamboec tabadquin ënden bedondaidi mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nidaidënshun abi bunaidtedi bedquido Nuquin Papan icsamboen isaido nec. Abi bunaiduidi tantiaquin Nuquin Papan chiaid tantianu queshun tantiatiapimbo iquendac. “Mitsanauidi tantiec, Bëdambo iquebi, quec mamënec tabadquido icsho Nuquin Papan icsamboen isaido mibi nec. Adquido Nuquin Papa yacno puduedte bunsho, Padi, cac shubiquiendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Bëdambocquid nec, quequin mibi dadpenshun chuisho tantienda. Adomboembidi mua uain Nuquin Papan ëndenquimbo chuimiaidpembon chuipampic. Aidon chiaid tantiashun tsusedpabon Nuquin Papan chiaid tantienquio yanampic. Adquido Nuquin Papan icsamboen isaido nec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aden chiashic abi Esus onquec: —Ëmbi chiaid tantiaquidquio nad iqueque. Chuinu. Tantiata. Mibi chieshënquido bëdamboen tantiaquin nabanta. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Adembidi mibi icsamboen chuiquid bëdamboen chuita. Adembidi, ëbi icsamboen naquido bëdamboen tantiaquin cuidenda, Papa, quequin Nuquin Papa chuita. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Adembidi mibi cuesquid cuidenda. Adembidi mibi icsamboen nadenesho cuidenquiocquin adembi bëdamboen nabanta. Adembidi ampequin min dashcute bedanec nidsho isun, Chiata. Dadamicquidtsen buan, cata. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Utsibic, aton na nibëdquid, Bec cho, quesho meneta. Adembidi utsin mitsana ampesho isun cuidenquiocquin bëdamboen naoata. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Adembidi ëbi bëdamboen nashuntiadquidi nepec quequin mimbi tantiacpadomboen utsi tantiaquin nashunta. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ëbëd tantiananquiduidi tantianu, quec ¿bëdamboda mibi icpe? Padenquio. Adembidi Esus tantiesan abipadquiocquido tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Adecbidi, Ëbi bëdamboen tantiaquin nashunquiduidi tantiaquin nashunoanu quec ¿bëdamboda mibi icpe? Padenquio. Esus tantiesan adembidi nashunquidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Adecbidi, Ëbi menequiduidi menenu, quec ¿bëdamboda mibi icpe? Padenquio. Esus tantiesan adenuidi menec. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Naden nata, quequin chuinu. Tantia. Mibi chieshënquid icsho aid tantiaquin bëdamboen nabanta. Adembidi mibi meniantiapimbocquid, Bec cho, quesho, Yuecash cuidnanun nanuna, quenquiocquin meneta. Mimbi adosho isun Nuquin Papan mibi bëdamboen isendac. Adobanec bëdambo iquebi quec mibi tabadendac. Adomboen nabanquido Nuquin Papan nacpadomboen nabanquid nendac. Adquido aton mado iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nuquin Papan abi chieshënquido nashundeniacpadomboen mibi chieshënquido nashundeneta —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Aden chuibanashic Esus abi onquec: —Ëmbi tantiacpadomboen naisa icsambocquid nec, quenda. Adesa abi yacno choacsho Bëdambocquid neque. Puduedme, Nuquin Papan caindac. Adecbidi, Icsambocquid iquec. Aid cuidtiadquidi Nuquin Papa nec, quenda. Adenquio icsho Nuquin Papan cuidenquioctequid mibi iquendac. Mibi icsamboen tantiaquin utsin nasho isash cuidnanenquio yec bëpiscudta. Adquid, Cuidnu, quenquio yec mimbi icsamboen tantiaquin naid Nuquin Papa bëpiscudendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aton na nibëdquid bëdamboen tantiaquin meneta. Adembidi, mibi tantiaquin abi utsibëd bëdamboec tabadtequid Nuquin Papan mibi menendac. Utsi tantiaquin mimbi meniacpadomboen mibi tantiaquin bëdamboen tabadmetequid daëd uashun Nuquin Papan mibi meneoaindac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aden chuishumbic utsin tantienquio ictequid abëd icquido naden Esusën chuipanëdash: —¿Podquedën nidnu quec bëshuaid utsi bëyucampecta nidtic? Nidnu, quianec nidec abi daëdi nidaid shëcuë ampaëdpatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Adembidi tantianuequidën abi tantiamequid dëniactiapimbo iquec. Tantiamiac abi tantiamequidpadquid iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Adoshombic adembi tantiamequin naden Esusën chuipanëdash: —¿Atotsi quiash utsi bëtsiadaid pistsëcquid isequi mibi bëtsiadaid dapa isadtiapimbo icpec? ¿Mibibi bëtsiadaid dapa bëbedadabicquin mitsipadentsi mimbi utsi bëtsiadaid pistsëcquid bedshunuen ispe? ");
INSERT INTO mcfNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Adembidi, utsin tantiaid icsa abentsëc icnubien mimbi tantiaid icsa utsi-utsiec icnuc ¿atotsieshun, Mimbi tantiaid icsa ënta, quequin utsi chuipe? Mimbi tantiaid icsa nibëdacbimboen mimbi chuipeque. Adoenda. Mimbi tantiaid icsa ënshun utsin tantiaid icsa icsho isun ëmenuequin chui —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Adoshombic, adembidi Esusën chuipanëdash: —Cuëte bëdan bacuë adquiobidi bacuëec. Cuëte icsan bacuë adquiobidi bacuëoaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chetequid isun cuëte dada matsesën tantiec. Aden tantiec nisanquidën bacuë isash, Dadain bacuë nec, quenquio matses iquec. Adecbidi, echo bacuë isash, Bata nec, quenquio matses icoaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Adembidi bëdamboen tantiaquidën ambi tantiacpadomboen utsi bëdamboen tantiaquin nabanendac. Adecbidi ambi tantiacpadec bëdamboec onquec. Adembidi icsamboen tantiaquidën ambi tantiacpadomboen utsi icsamboen tantiaquin nabanec. Adecbidi ambi tantiacpadec icsamboec onquec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Adoshombic: —¿Atotsieshun, Con Icbo mibi nec, queshumbi ëmbi chiacpadomboen naisa mibi ne? ");
INSERT INTO mcfNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ëbi yacno choshon ëmbi chuibansho tantiaquiash nidshun nadomboen naquidquio iqueque. Chuinu. Tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cunquequid dapan chimeshnushe queshun shubu uaquidën shëcuë ëquëduc uëdëshcashun buintad nitsinquid. Adembidi, natiamianquiec cametequid yanabicnuc tantesa uainquiocnuen ëbi tantiaquidquio icquin ëmbi chiaid papuduedshun adomboembidi nabanquid nec. Adquidën tantesa uainquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Utsibic nad iqueque. Tantia. Ëquëduc uëdëshcabi nitsinaid cunquequid dapan chimeshunendac. Adecbidi, ëmbi chiaid papudueduidtsacpadomboen nabanenquio yec natiamianquid chonoc abi papudueduidtsaid bëpiscudendac. Adquid uquë nësecatequid nendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aden iccuededquido chuiquin nainash Capednaun caid yacno Esus nidoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Capednaun caid yacno choash Esus tabadnubien isadaidpembon sondado chuiquidën yua abi cudasaid unëstiadtsëcquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aton yua unëstiadtsëcquio icnubien, Nënquid bëdamequid Esus nëmbobi iquec, quequin utsibon chiac: —Aidën con yua bëdametsiash —quianec isadaidbo tsusiobo yacno nidshun istuidash: —¿Con yua chiec Esus yacno ada mibi nidpatsia? —quepanëdash sondado chuiquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Adoaquien: —Ai —quianec Esus yacno isadaidbo tsusiobo nidshun chuituidec: —Sondado chuiquidën chuitan caido nebi. Con yua unëstiadtsëcquio iqueque. Esus bëdamequid neque. Chuitan, cac mibi chiec chobi. Sondado chuiquid bëdambocquid nec. Nuquin Papan chiaid chuibante shubu uamiondaidquio nioshe. Ambi chiacpadomboen aton yua bëdametiadquidi mibi nec —quepanëdash isadaidbo tsusiobo Esus caic. Adoac aidobëdi Esus nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Adec aidobëd Esus nidshobi sondado chuiquidën chomiaid utsibo choquin bëquedtuidash nadpanëdash: —Sondado chuiquidën chomiaid nebi. Aidën chiaid chuinuec chopobi. Naden chuita, caposhi: “Padicnuna, Icbo. Icsambocquid nebique. Mibi bëdambocquid iquec con shubun puduedenquioctiadquidi mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ëbi icsambocquid iquec mibi bëquedec nidenquioccobi. Mibi bëdamequid yec con shubun puduedenquiocquin mibi yacnoshombi, Bëdanta, mimbi cac con yua bëdampec. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ëbien sondado chuiquid nec. Ëmbi nidta cacpadquiequi sondado nidec. Adecbidi, Cho, ëmbi cacpadquiecbidi choaic. Adembidi, Nadota, cacpadomboembidi con yuan nabanec,” quequin chuitan sondado chuiquidën cabocpadembi mibi chuipombi —quepanëdash sondado chuiquidën chuitan caido Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Adoaquien: —¿Abimbobida cai? —queshun ambi chiaid tantiamenuequin iccuededquido Esusën bëisbanquin nadopanëdash: —Chuinu. Tantiata. Sondado chuiquid isadaidpembo ëbi tantiaquidpadquid isadaidbo nibëdec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aden chiaquien sondado chuiquidën chuitan caido aucbidi nidoash shubun puduedshun sondado chuiquidën yua bëdamiaid istuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Adashic, ushë utsin shubu dadpen icquid Nain caid yacno Esus nidpanëdash. Aidbëdi abëd icquido nidpanëdash. Adecbidi matses utsibo dadpen nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Adec nidequi Nain tsasi uaid quënë shëcuë anoentsëqui choquimbi unësaid bëquido bëquedtuidpanëdash. Unësaid epa icnubi ani niante icpanëdash. Niantebëd Nain yacnocquido dadpen cho-chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Adec cho-choec niante shubisho isash Esus unësquio yec: —Shubienquio yec ënëd —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Adec, Ënëd, quetanec udictsëc nidshun unësaid nanaid Esusën mishnubi abi bëquido nidtuidpanëdash. Nidtuidsho isun: —Abuido, uëtsëdtota —cac ");
INSERT INTO mcfNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","uëdtsëdtoash tsadec unësboed onquepanëdash. Adsho isash ani caic: —Në, unësboedi min mado uincuenoshe. Abëdi nidec nid —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aden unësaid uincuemesho isash cho-choquido: —Adopenshenda uincuemec —queshun Nuquin Papan naid chuibampanëdash. Aden chuibanec: —Nuquin Papan matses bëdamboen isnuen ambi chomiaidquio nuquibëd icmiosh —quec isquido onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aden isash nidshun unësaid uincuemiaid isquidon chuibansho isadaidbon nidaid Udeya caid yacnocquidon tantiabempanëdash. Adembidi chiac dëuequidontsen tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Adnubien, acten mentoanondaid Uan cuëmëdquid quënën nauedaid icsho abëd icquidon Esusën nabanaid chuibampanëdash. Adoaquien abëd icquido daëd chomeshun Uanën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—Esus yacno nidshun nadota. ¿Ëbitedishun cainaid Nuquin Papan chomiaid abentsëcquiobi mibida ne? ¿Aidtabi nedi? mibi quenuc, ¿Adambi utsi caimpe? quequin chuita —Uanën cac aid daëdi Esus yacno nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Adec Esus yacno choash: —Acten mentoanondaidëmbi Uanën chomiaido nebi. Uan nadosh: “¿Ëbitedishun cainaid Nuquin Papan chomiaid abentsëcquiobi mibida ne? cac ¿Aidtabi nedi? mibi quenuc ¿Adambi utsi caimpe?” quiosh Uan —quepanëdash Uanën chomiaido Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aden chiaquien icsambocquid bëdamequinc, mayan icsa dapuduedaid dapuduemequinc, bëshuaid bëdamequinc caquin Esusën ismebampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aden nabanquin nainashic: —Mibi chuiquid Uan caid yacno nidshun ëmbi nabamboedtedi mimbi isboed naden chuitanta. Bëshun isbenosh. Adecbidi canite icsaidi capuanosh. Adecbidi daushumbocquidon nami bëdanosh. Adembidi pashun tantiabenosh. Adembidi unësaid uincuemiosh. Adembidi aton na nibëdquido tantiamenuen Nuquin Papan chiaid Esusën chuibanosh, quequin Uan chuitanta. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ëmbi aden nabansho isun tantesa uainquiocquin Nuquin Papan bëdamboen isaidquio nendac, Esus quiosh quequin Uan chuitanta —quepanëdash Esus Uanën chomiaid daëd chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Adashic, Uanën chomiaido nidambi iccuededquido tantiamebanuec Uan chiec Esus nadpanëdash: —¿Atotsi isnuec matses nibëdacno nidonda? ¿Cunquequidën ishcunaid isnuecta nidtionda? ");
INSERT INTO mcfNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Aid isnuec nidenquio yec atotsi isnuec nidonda? ¿Dashcute ushumbocquid dasiuidquid isnuecta nidtionda? Padenquio. Dashcute ushumbocquid dasiuidquido aton na dadpenquio icquido ancanquid dapan shubun tabadquido nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ad icnuc, ¿atotsi isnuec matses nibëdacno nidonda? ¿Nuquin Papan ambi chiaid chuimiaid isnuec nidenquioda ictionda? Ai, matses nibëdacno Nuquin Papan chuimiaid isnuec mibi nidondac. Uanën ëbi chuiquidëmbi ispondashi. Ëbi ëndenquimbo chuiquido ëbi isesabo icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ëbi cain naden Uan Nuquin Papan chuimiampid nec: “Mibi choec quequin chuibanquidba chomembi. Mibi choec quequin chuibanac ambi tantiaid icsa ënshun mibi cainquidombo iquendac.” Aden ëbi cain Uan chuiquin dada uapampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Adembi Uan chuibanu. Tantiata. Nuquin Papan chuimiaid Uampadquid matsesën tishaid utsi nibëdec. Aidën ëbi chotequid chuibanac choshon ëmbi nabansho isenquio icposh. Isash, Nëid Nuquin Papan chomiaid nec, quetsemposh Uan. Aidi quënën nauedac ëmbi nabanaid istiapimbo yec tsadec, Nuquin Papan chomiaid, ëbitedishun cainaid mibida ne, quepec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aden Esusën chuibansho tantiash: —Nuquin Papan naid bëdambo iquec —quepanëdash Uanën mentobanondaido. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Utsiboen ambi tantiaid icsa ënenquio icquin Uan Esusën chuisho tantiash, Nuquin Papan naid bëdambo iquec, quetiapimbo aido icpanëdash. Aido padiseyobobëd matsesën naden nata quequin chiaid tantiamequido icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aden Uan chiash Esus: —¿Nuquin Papan chiaid nëbi chuisho tantiesa mitsipadquid nepeque? ");
INSERT INTO mcfNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Adquid chuinu. Tantia. Ambi tantiacpaden naisa icsho isash bacuëbo yacbimboec nëishun mimbi icsamboen tantiec. Adembidi ambi tantiacpaden naisa icsho isun Nuquin Papan chiaid tantienquio iquec. Adquidën Nuquin Papan chuimiaidën nabansho icsamboen ispec. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nua cubudquin pesa Uan icsho isash, Mayan icsa dapuduedaid nec, queposh Uanën chuisho tantiesa. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ëmbi peshun acsho isec, Nua peshun tantienquiocquin acquid nepec. Aidbidi icsambocquidobëd icquid nec, ëbi caposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aden tantienquiocquid, Bëdamboen tantianu, queshun bëdamboen tantiaquidënquio chuibansho tantiash abi tantiamequidpadquid iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Adashic, Ëbi yacno pec cho, padiseyobo abentsëcshun cac aidbëd nidash shubun puduedash pete santen cuëshnudash Esus uepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Adec Esus puduedash uesho isquidon chiac utsin, Icsambocquid nec, caid chido choquin noadte bëda danoshquete aton shubumpichobi bëpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aden bëequi Esus yuedacno choash puduedshun abi bëdamequid Esus istuidash, Ëbi bëdamequid bëdambo iquec, quequin ambibi tantiec shubiec Esusën taëno tsadbudshun aton bëunën tapascapanëdash. Aden tapascac taë chucusho isun aton manëdaidën taucshun taë tachoccabanshun noadte bëdan chidon tanoshcapanëdash. Chidon aton na bedtequid dadpen menequin comapenec noadte bëda bedshun Esusën taë tanoshcapanëdash chidon. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chidon adosho isash Esus yuedquid, Simon caid, abibi onquec: “Ëmbi yuedaid Nuquin Papan chuimiaid iquec, Ëbi mishquid icsambocquid nec,” quequin chido mishmenquio icpec, quepanëdash Simon. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Adoaquien, tantiaquidquio icquin Esusën: —Mibi tantiamequin chuinu. Tantiata, Simon —capanëdash. Adoaquien: —Aden chuiban. Tantianu —quepanëdash Simon. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aden tantiashun Esusën Simon ambi tantiaid icsa tantiamenuen utsi chuiquin nadopanëdash: —Bec cho. Yuecshun menenun nanuna, quepondash daëd. Abentsëcshun dadpen bedshunubi utsin daëdpactsëc bedshumpondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aden bedshunshun yuecshun ambi bedshunacted abi daëdi meniantiapimbo icpondash. Adsho isun: “Padi. Mimbi bedondaid ëbi cuidenda,” quequin abi bedshunëdaidën abi daëdi chuipondash. Adoacsho, ¿Mitsiquid abi bedshunëdaid ënenquiocquin tantiec bëpiscudenquio icpec? —quepanëdash Esus Simon caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Adoaquien: —Ambi dadpen meneshun cuidenda caidien nechitec —quepanëdash Simon. Aden chiaquien: —Ai, bëdamboen tantiaquin mimbi chioc —quiash ");
INSERT INTO mcfNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Simon ismenuec Esus chido yacmi bidiadshun naden chuipanëdash: —Min shubun puduedacsho mimbi taë pante ëbi menenquioccoc. ¿Nëid chido isquindactio? Aidëmbien aton bëunën taë chucu uashun aton manëdaidën con taë bëchishaid ucposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Min shubun ëbi puduedsho isun tanchoccanesa mibi nec. Padnueni ëbi puduedacsho isun nëid chidon ëbi tantiaquioquin yuen con taë tachoccaniosh. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bëchin manoshcanesa mibi iccoc. Padnueni nëid chidombi noadte bëdan tanoshcaniosh. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Adembidi mibi chiembique. Tantiata. Mayan icsa dadpenshun tantiamiaid icsho nëid chido bëdamepombi. Aden bëdamiashic abi icsaid tantienquio yec bëpiscudpobi. Ëmbi aden nac ëbi comapenen tantiaquioquin ëbi nashunquidquio nëid chido nec. Padnuen utsi icsaid daëdpactsëc mibi icsaidtedtsëcbidi icpec. Adquid icsaid bëpiscudebi ëbi quenuc ëbi bëdiactsëc tantiatsec mibi nashumënec —quepanëdash Esus Simon caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aden Simon chiashic chido caic: —Icsaquid nec, quenquiocquin icsainquio yacbimboecquid mibi isembi —quepanëdash Esus chido chuioaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Adsho tantiash: —Icsainquio yacbimboecquid mibi isembi, quec ¿mitsipadquid Esus nepec? —quepanëdash iccuededquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aden iccuededquidon tantianubi chido caic Esus: —Ëbi tantiaquid yec Nuquin Papa yacno puduedquid mibi neyoc. Bëdamboec tabadaid tantiamiaid mibi iqueque. Dacuëdenquio yec nidta —quepanëdash chido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Adshumbic, Esusën shubu dadpen yacno-yacnomboen chuibanquin Nuquin Papa yacno shubu abentsëqui yacbimboec nidaidën tabadaid chuibenepanëdash. Abi bëdamequid tsibananec chidobo nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ambi mayan icsa dapuduemiaidobëdtan ambi bëdamiaidon Esus tsibanampanëdash. Madia, Macada yacnoshon tishaid chedon Esus tsibampanëdash. Mayan icsa 7ted dapuduemiaid Madia icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Abëd nidquid utsi Uana icpanëdash. Aidën bënë Chusa cuëmëdquid, ancanquid dapa Edodesën shubu nuntan nacnemequid icpanëdash. Abëd nidquid utsibic, Susana icpanëdash. Chido utsibo dadpen Esusbëd capucuenepanëdash. Aidon aton na dadpen icnuc Esusbëd icquidon aton na nibëdsho isun menebampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aden chuibeniash tabadtuidtsëcnubi ambi chuiquin tantiameboedo cho-choquin tsibanampanëdash. Cho-chosho isun, Mibibimboecnuc chiembi, quenquiocquin Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tiedën caniquid pete ëshë sianuec aton tied yacno nidquid icbo. Adec nidshun tiedën caniquid pete ëshë secabanac maisec utsi-utsiec podqued nantan paëdacsho matsesën manenubi utsi-utsien uicchunën chec. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Utsibic, cuënote dadpen samëdacno secac badedquio dëyucuidtsash nidaid ëquëduc tapun nidenquio iquec bidiquequid. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Utsibic, nisanquid dëyucacno secac aidbëdi dëyucash canidouidtsacsho nisanquidën bëtinac unësquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Utsibic, nidaid bëdan secac dëyucash caniash dadpen ëshëendac —quepanëdash Esus. Aden chuibanashic: —Tantiate bëdambocquidën ëmbi chuiboed tantiapec —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Adoaquien: —¿Mitsipadquid tantiaid mimbi chuiboed icpec? Ëbitedi tantiamequin chuioa —capanëdash abëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Adoaquien: —¿Mitsipadequini Nuquin Papa yacno tabadpe? queboedëmbi nëbi mimbi tantiabenec. Padnuen utsibon tantienquio yaid aid iquec. Aden chiac: “Ëshë bëdambocquid icquimbi tantiesa icquin ma Nuquin Papa yacno isenquiocpanuna. Adembidi tantiate bëdambocquid icquimbi tantiesa icquin ma abimbo chiaid tantienquiocpanuna” —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aden chiashic: —Ëmbi chuiboed nad iqueque. Tantia. Chuinu. Tiedën caniquid pete ëshë icbon siaidbimboecquid Nuquin Papan chiaid nec. Ëshë siacno nidaidbimboecquid matsesën tantiate nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Podquedën nidaid tsasimbocquidbimboecquid nad iquec. Nuquin Papan chiaid tantiash papuduedtiapimbocsho Satansën bëpiscudmiaid adquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Cuënote dadpen samëdacno nidaidbimboecquid nadquid iquendac. Nuquin Papan chiaid tantiash, Bëdambo iquebi, quiashic natiamianquiec cametequid icnuc aid tantiec Nuquin Papan chiaid papudueduidquid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nisanquid dëyucaid dadpen yacno nidaidbimboecquid nad iquec. Nuquin Papan chiaid tantiash abi bunaid, abi nënaid, ambi natequid adquid tantiaquin Nuquin Papan chiaid bëtashacbimboec icnuc bëdamboec tabadaid ismesa yampec. Aden bëdamboec tabadaid ismesa yanuc utsin Nuquin Papan chiaid tantiatiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nidaid bëdabimboecquidien nad iquec. Nuquin Papan chiaid tantiadonec bëdamboec tabadquin utsi ismequidquio nec. Adquid natiamianquid chonoc tantesa uainquiocquin ënenquiocquin ismendac. Aden ismiac Esus tantiaquid utsi dadpen yampec —quepanëdash Esus ambi chuiboed abëd icquido tantiamenuec. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aden chuishumbic naden Esusën chuioapanëdash: —Tabote taboshon matsun bëtashesa. Adembidi tsadte tëdion tabote nanesa icbo nec. Ma ëmbi yuedaidon isnueshun nënantan tabote nanquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Adomboembidi mimbi ompoquin chuibanaid Nuquin Papan ompoenquiocquin chuibanendac. Adomboembidi mimbi tantiamenquio yaid aidëmbi chuibanendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ad icnuc ëmbi chiaid bëdamboen tantiaquiota. Nuquin Papan chiaid tantianuequin ambi chiaid dadpen tantiaquid. Adquid ambi tantiacpadec tabadquid. Adec tabadquin ompoenquiocquin utsi ismequid. Nuquin Papan chiaid tantiauidboed, Bëdamboen tantiembi, queshun papuduedmenquiocquin bëdamboen ismesa nec. Aden ambi tantiauidaid uesadendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Adashic, Esus isec aton utsibobëd aton tita chopanëdash. Cho-choshon matses dadpen nuntan tabadsho isun, Ëbi choaid chuita, cac ");
INSERT INTO mcfNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","shubun puduedshun: —Titabëd min utsibo choshon umanucshun mibi cainec mibëd onquete bunquin —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Adoaquien: —Adquid chuinu. Tantia. Nuquin Papan chiaid tantiashun nabanquido ëbëd icquid nec. Adquid buchi caindambi. Adquid utsi chido chuchu caindambi. Utsibic tita caindambi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Adashic: —Chian cuëma utsiuc nidnu. Nid —quianec abëd icquidobëd cano antsadtoanec nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Adec nidec cano anuequi Esus ushtopanëdash. Adec ushnubien cunquequid dapa comapenec cunquenubi acte tëccoasquequidën acte uemiac cano mentoadtsempanëdash. Adsho isash dacuëdec ");
INSERT INTO mcfNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Esus ushacno nidshun tinec abëd icquido: —Nuqui mentoadeque. Isucun, Icbo —quec comapenec cuëdpanëdash abëd icquido. Adsho tantiash isucunash nidtoshon: —Mibi comapenec cunqueque. Ënëd —Esusën cac cunquequid badedquio ënëdpanëdash. Adembidi: —Mibi comapenec tëccoasqueque. Ënëd —Esusën cac badedquio acte tëccoasquequid ënëdoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aden ënëdmetanec: —¿Atotsi quiash ëbi tantienquio yec dacuëdcuedede? —Esusën caquien abëd icquido dacuëdcuededquiequi, ¿Mitsipadquid nepec? Cunquequidbëdtabi acte tëccoasquequid ënëd cacpadequi ënëdchitosh, quec abëd icquido abibi onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Adshumbic, acte tëccoasquec ënëdan nidaid Cadidia yacno chian cuëma utsiuc Esusbëd icquidon poteoaic nidaidëmpi Cadada caid yacno aido nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ambo nidequi canon choash dectatosho isash mayan icsa dapuduedaid dada Esus bëquedec chopanëdash. Aidi shubu dadpen yacno tabadboedi nëbi uano unësaid chococate macuësh cuënote yacno tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aidi Esus bëquedec choash sidquianec Esusën taëno uebudash: —¿Atotsienuec ëbi isec cho? Nuquin Papan madombo mibi cadoque. Ëbi mëyanenda —quec onquenubien ");
INSERT INTO mcfNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","mayan icsa chuiquin: —Dapuduenta —capanëdash Esusën. Mayan icsa dapuduedaid nad icpanëdash. Shocosh bucun abi mëtaniaidbëdtabi abi tataniaid chictenesho isun, Mëtanenu, cainquio yampanëdash. Adoac mayan icsan matses nibëdacno nidmiaid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Adquid nec, quequin tantiaquin Esusën: —¿Tsutsi cuëmëdquid mibi ne? —capanëdash. Adoaquien: —Sinco midted dapuduedondaid nebi —quepanëdash mayan icsa dapuduedaid onquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aden chiashic: —Mibi bëdambocquid cadoque. Ënenquiocquin mëyanacno cuidnuequin ëbitedi nidmenda —quiashic ");
INSERT INTO mcfNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","chancho dadpenshun pec tabadsho isash: —Ëbitedi chanchotedi dapuduedtiadquio iquebi. ¿Ada bëdambo icpec? —quepanëdash mayan icsa dapuduedaid. Adoaquien: —Aido dapuduedtan —Esusën cac ");
INSERT INTO mcfNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","dapuduenequi chancho mayan icsa dadpen dapuduedash acte quiusudacno chancho comapenec niquec chian pudun-pudunec mentoadbudnec nibëdquiec unësbunepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Adsho isash chancho pemequin isquido titinquianec shubu dadpen yacno choshon ambi isboed chuituidac ");
INSERT INTO mcfNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","anocquido istanu quianec Esus yacno cho-chopanëdash. Adec choshon mayan icsa dapuduemequin bëdamiaid dashcute dasiuidash bëdamboen tantiec Esusën taëno tsadsho istuidpanëdash. Adec aid onquesho isash anocquido, Uinsadpambo iquec, quiash dacuëdcuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dacuëdsho isun mayan icsa dapuduemequin bëdamiaid isquidon ambi isboed dacuëdquido chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aden chiac: —Nëuëshquio nidenquio icpec —quepanëdash dacuëdquido Esus chiec. Adoac Esusbëd icquido canon antabëdtopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Adsho isun: —Mibëd nidtiadquio iquebi —quepanëdash ambi mayan icsa dapuduemequin bëdamiaid Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Adoaquien: —Padi. Min shubuno nid. Ambo tabadquin Nuquin Papan naid mayan icsa mibi dapuduedaid dapuduemiaid anocquido chuibanta —quianec Esus canon nidpanëdash. Aid nidnubien mayan icsa dapuduemequin bëdamiaid nidanec aton shubu yacno choshon anocquidtedi Esusën naid abi mayan icsa dapuduemequin bëdamiaid chuibanoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Adashic chian potiash cuëma utsiuc Cadidia yacno Esus padpidec chosho isash: —Mibi isec bëdambo iquebi —quepanëdash iccuededquido abi cainquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Adnubien, Nuquin Papan chiaid chuibante shubun tabadquid isquid Aido cuëmëdquid choash Esusën taëno uebudash: ");
INSERT INTO mcfNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","—Con champi abentsëc tishaid unësanequidquio iccosh. Aton seta 12ted icquid niosh. Ëbi cudasaid nec. ¿Aidi isnuec con shubuno ada nidtsia? —quepanëdash Aido. Aden chiac Esus nidnubien cho-choquido dadpen tsucus-tsucustsëcquio yec Esus datsidadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Adnubien, chido seta 12ted matamec intac budaid chopanëdash. Aidi dauëchoquid dadpenshun bëdametiapimbo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Adoac bëdanabi yec, Bëdamequidën ëbi bëdamepec, abibi quianec Esusën cachoc choshon ismenquiocquin Esusën dashcute cuëmano mishnubi aton intac badedquio bëdampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aden mishac: —¿Tsuntsimbini mishosh? —quepanëdash Esus. Aden chuisho tantiash abi datsidash capuquido mishambo yec otacquio tabadcuededpanëdash. Adec tabadnubien: —Matses dadpenshun tsucus-tsucustsëcquiocquin mibi cuëscabededec —capanëdash Petedon. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Adoaquien: —Matses abentsëcshun ëbi mishosh. Ëmbi nadatiambocquin natequid bëuesadtsac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Adec Esus onquesho tantiash chido, Ambi tantiacpadomboen ëbi isec, quec abibi onquequi dacuëdec uëdëquequi Esusën taëno uebudtuidpanëdash. Adec uebudec datsidadquidon tantianubi: —Intac bëdanuequin min dashcute cuëscatsequi bëdanobi —quepanëdash chido Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Adoaquien: —Mimbi tantiacpadquiec mibi bëdanaye. Dacuëdenquio yec bëdamboec tabadec nid, champi —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aden Esusën chuinubien Aidon shubun icquid utsibo Esus yacno cho-chopanëdash. Choash: —Min champi unësoshe. Chuibanquin tantiamequid min shubuno nidnunda —capanëdash abi yacnoësh choquidon Aido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aden chuisho tantiash: —Dacuëdenda. Aden tantiequi nid. Mimbi tantiacpadquiec min champi bëdaneque —quepanëdash Esus Aido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aden chianec Aidon shubuno nidash cho-choquidotedi, Ëbëd puduedenda, quequin chianec Petedo, Uan, Acobo aidted buanec Aido cuëmëdquidën champi yacno Esus puduedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ambo puduedshun anocquido unësquio yec shubisho tantiashun: —Mibi shubieque. Ënëdta. Champi unësenquio yec usheque —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Adsho tantiashun, Champi unësacsho isombi, quequin Esus tantienquiocquin shubiquidon mamënshumbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mamënshumbedednubi Esusën Aido cuëmëdquidën champin mëdante mëdinquin: —Nidto, champi —comapenen cac ");
INSERT INTO mcfNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","aton tiboedte unësabi yec champi badedquio nidtopanëdash. Champi nidtosho isash: —Peme —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aton champi nidtosho isash: —Adopenshenda iquec —quepanëdash ani amëbëdi. Adoaquien: —Mimbi isboed chuibanenda —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Adashic ambi ëbi chuibeneta caido 12tedtsëqui chometanquin Esusën nadopanëdash: —Ëmbi nadatiambocquin nabanacpaden mibitedishun nabanendac. Mayan icsa dapuduemequinc daicsaido bëdamequinc cain mibi capucueniacnoshon mimbi ismebenendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nëbi mibi nideque. Adec capucuenequin chuibenequimbi bëdamebeneta. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nidquin cueste uidën nidte buanenda. Shictoadte buanenda. Petequid buanenda. Mitsana bedtequid buanenda. Dashcute utsi buanenda. Buanenquio yec dadauidquio nidtan. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Adec nidash mibi yuedquidën shubun puduedshun ëmbi chiacpadomboen nabanec anouidi tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mibi nidacno mibi yuedquid nibëdsho isun naden nata. Mimbi tantiaid icsa mibibi cuidadte nec, quequin nidaid putu tasequequin ismeta —capanëdash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aden chiac nidash abëd icquido abi yuedacno puduedash tabadquin Esusën chiacpadomboen Nuquin Papabëd tabadaid chuibanquimbi daicsaido bëdamebenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Adnubien Esusën nabansho isquidon Edodes chuibampanëdash. Edodes Cadidia yacnocquido ancaquid icpanëdash. Aden Esusën nabanaid chuisho tantiashun, ¿Tsudain nepec? Edodesën caquien, Acten mentoanondaid, Uan cuëmëdquid uincuempash icnui, quenubien; ");
INSERT INTO mcfNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Edias Nuquin Papan ambi chiaid chuimiampid padpidec choapash icnui, utsi-utsiec quenubien, Nuquin Papan chuimiampid utsi uincuenoapash icnui, utsi-utsiec quecuededpanëdash, quequin chuipanëdash Esusën nabansho isun chuiquidon Edodes tantiamequin. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Adoaquien: —Mambi uincuentiapimbocnoc Uan mapi budtemiondac. ¿Tsudain ëmbi tantiacmaidquio adobanquid icpec? —quiashic Esus iste bumpanëdash Edodes. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Adashic ambi nidmeboedo Esus yacno padpidec choapanëdash. Choashumbic ambi nabamboedtedi chuibampanëdash. Aden chuibansho tantiash Esus abëd icquido bëyucanec shubu dadpen icquid Betsaida caid anoentsëqui nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aido nidsho isun cho-choquidon tsibanampanëdash. Adsho isun Esusën Nuquin Papa yacno tabadaid chuibanquimbi daicsaido bëdamepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Adashic ushë budtsan Esusbëd icquidombo Esusën dayunquio choshon: —Nëmbo shubu nibëdeque. Shubu utsi-utsiec yacno nidshun pete bedshun pec tabadta, quequin cho-choquido chuita —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Adoaquien: —Padi. Mimbibi aido pemeban —capanëdash Esusën. Aden chiaquien: —¿Ma nëmbobi panëmpi mëdante auc abentsëcted icnubi nuëcquid daëd iquec. Aidtedtsëqui icsho isunda cho-choquidtedi pemenuequin ëbitedi bedtan, cai? —quecuededpanëdash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ambobi tabadsho chido bacuëbobëdtabi tambanenquio icquimbi dadauidquio, 5000ted icnuc tambampanëdash. Adoaquien: —Nëidtedi uano 50ted-50tedquien tabadme —Esusën cac ");
INSERT INTO mcfNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ambi chiacpadomboen tabadmepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aden tabadmesho isun panëmpi 5tedbëdta nuëcquid daëd sananquin abuc isec: —Mibi bëdambocquid icquin mimbi meniaid nëid pete nec, Papa —quec onqueshun pete cuësh-cuëshun: —Meneban —Esusën caquien abëd icquidon menebampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aden menebanac piash cubudambic napi uaid sandobanquin tsitsan 12ted icnuc Esusbëd icquidon bedbampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Adashic, matses nibëdacno abëd icquido icnubi Nuquin Papa chiec Esus onquepanëdash. Adec onqueshumbic: —¿Tsutsi ëbi tsibanquidon ëbi capec? —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Adoaquien: —Acten mentoanondaid, Uan padoen Esus nechitec, quenubien, Edias Nuquin Papan ambi chiaid chuimepampidien Esus nechitec, utsibo quenubien, Nuquin Papan chiaid chuimepampid uincuenoaidien Esus nechitec, utsibo queoaposh —quepanëdash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Adoaquien: —¿Ma, mimbi, tsutsi ëbi cape? —capanëdash Esusën. Adoaquien Petedo: —Chuiquid dapa abentsëcquiobi, Nuquin Papan chomiaidquio yec Quidistu caid ma mibi neyoc —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Adoaquien: —Mimbi ëbi tantiaid nëbi utsi chienda —quepanëdash Esus comapenen chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aden comapenen chiashic Esus: —Ëbi matsesaid icsho natiambocquin mëyantequid iquendabi. Ëbi chieshënquido dadpen iquendac. Nuquin matses tsusio dapabo yec tsusio utsibo yec Nuquin Papan naden nata quequin chiaid chuibanquin tantiamequido yec quec aidtedi ëbi chieshënquido nec. Aidon naden chiendac: ¿Esus chuiquid dapa abentsëcquiobi Nuquin Papan chomiaidta nedic? Aidpenquio nec, quequin ëbi cuesunemependac aidombi. Adoaquini daëdec ushacsho uincuen uaindac —quepanëdash Esus abi uincuen uate chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aden chiashic: —Ëbi tantiaquid icnuequin ambibi tantiacpadomboen nainquiocquin ëmbi chiacpadomboen nabantiadquidi nec. Ëbi mëyanacpaden mëyanuc unësmane quenquiocquin tantesa uainquiocquid. Ëbi tantiaquidquio iquendac adquid. Nidaidën tabadaiduidi tantiaquid iquec Nuquin Papa yacno nidenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Cuesunenu cac unësmane quiash Esus tantiaquid nebi queboedi Esus tantiesa nebi quequid unësash Nuquin Papa yacno tabadenquio iquendac. Utsibo, Esus tantiaquid nebi, quiashic abi cuesunenuequid icnuc adecbidi Esus tantiaquid nebi, queoapec. Adquid unësash Nuquin Papa yacno tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Atotsieshun Nuquin Papa yacno tabadaid tantienquio yec nidaidën bëdamboec tabadnuequin bedted-bedtede? Mimbi bedaidënquio Nuquin Papa yacno puduedtiapimbo mibi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Esusbëdtabi ambi chiaid tantiaquid nebi nidaidënuësh quetiapimbocquid icsho adquidi ëmbi tantiaid nec, queoatiapimbo iquendabi con pa yacnocquidtedishun tantianubi. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nad iquendac. Tantiaquiota. Chuinu. Ëbi tantiaquid dadpen yansho ënabicquid utsin-utsinquien isendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aden chiashic Esus mëdante utsiuc tauadoec ushash Nuquin Papa chiec onquenuec macuësh yacno nidoapanëdash. Petedo, Uan, Acobo aidted buanec macuësh yacno Esus nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Adec macuësh yacno nidash Nuquin Papa chiec Esus onquenubi aton bësbed aton dashcutebëdi nac-nacquio ushë chënquiacbimboec icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Adsho isnubien badedquio dada utsi daëd choash adquiobidi Esusbëd nidec. Nëidic, Moises, Nuquin Papan ambi naden nata quequin chiaid dada uamiampid; utsibic, Edias, Nuquin Papan ambi chiaid chuimiampid. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aid daëdi Esusbëd tabadquin Nuquin Papan tantiampicpadec Edusaden yacnoshon Esus unës uate ushë chiec onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Adnubien Esusbëd choboedo abëd icquido 3ted ushcasmash tabadtuidquin Esusbëd utsi daëd nac-nacquiocquid dasiuidacbimboec bed-bedquesho isbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Esusbëd daëd nidtuidsho isash Petedo nadpanëdash: —Nëmbobi iquec bëdambo iquebique. Nëmbobi mibi tabadmenun abentsëc chotsëcnuc shubumpi uanuna, Icbo. Abentsëc mitsana, utsibic Moisesën na, utsibic Ediasën na, quequin shubu uanuna —quepanëdash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Adec Petedo onquenubien abu ushun isadenquiocnoc abitedi bëtimpanëdash. Adsho isash Esusbëd choboedo dacuëdpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Adnubien abu ushunuësh onquec: —Nëidic ëbëd icte bunquidquio, con madombo, ëmbi bëdamboen isaidquio neque. Aidën chiaidquio tantiata —quepanëdash Nuquin Papa Esusbëd icquido tedestedshun isenquiocnobi. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Adec onquiash ënëdambi Esusuidtsëqui nidsho abëd icquidon ispanëdash. Adoshombic Esusbëd icquidon ambi isboed utsibo chienquiocpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Adashic badiadash macuësh dapa yacnoësh Esus budsho isash bëquedec matses dadpen cho-chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Cho-choash abentsëc nadpanëdash: —Con mado abentsëc icquid mayan icsa dapuduedash icsambo iccoshe. Isec chota. Aidën bedto-bedtoac badedquio sidquianesho aidëmbidi bedshun bëcunedeniac con mado ëcbacushaniosh. Dapuduenenquio icquin con mado aidën uimambo icmedeniosh. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Adsho isash choshon mibëd icquido chuiquin, Dapuduemeta, cauidombi. Adoac mayan icsa dapuduemenuequin aidon tanac dapuduenenquio iccosh —quepanëdash dada abentsëc Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Adoaquien ambi nianaido caic Esus nadpanëdash: —Nadatiambocquid Nuquin Papa nec, quequin tantiesa mibitedi neque. ¿Tedectsi icshun ëmbi chiacpaden mimbi tantiabempe? ¿Mimbi tantienquiocsho isash tedectsiashini chieshtope? —quetanquin: —Min mado bec cho —Esusën cac aton mado aton papan bëpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aden bënubi mayan icsan bëcuniac madompi uëdëquiampanëdash. Adsho isun: —Padi. Chën —capanëdash mayan icsa chuiquin. Aden madompi bëdametanquin aton papa Esusën meneoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Adsho isash: —Nuquin Papan nadatiambocquin naid uinsadpambo iquec —quecuededpanëdash isquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Adoaquien: —Chuinu. Bëpiscudenquiocquin tantiaquiota. Matsesacsho nëbi bedmendabi —quepanëdash Esus abi unës uate chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aden chuisho abëd icquidon tantienquiocpanëdash. Aden tantienquio yec, Mimbi chiaid tantienquio iquembi, quetiapimbo yec otacquio tabadcuededpanëdash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Adashic: —¿Nuquin Papa yacno nidash chuiquid dapa mitsiquid icpec? —quec Esusbëd icquido onquecuededpanëdash. ¿Ëbida chuiquid dapa icpe? quec ambibi tantiequi adpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Adoaquien Esus tantiaquidquio icquin bacuëmpi chomeshun aton dayunquio tabëcash: ");
INSERT INTO mcfNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Chuiquid dapa icnu, quesa icta. Ëbi tantiaquid icquin nëid bacuëmpi bëdamboen nashunquid iquec ëbi nashunoaquid iquendac. Nuquin Papan chiacpadomboen nabanquid Esus nec, quequin tantiaquidquio iquec ëbi chomiondaid, Nuquin Papa tantiaquidquio icoaindac. Nidaidënuësh utsi nashunquidquio icboedi aidquiobi Nuquin Papan chuiquid dapa icta caindac —quepanëdash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Adashic, Uan Esusbëd icquid abentsëc nadpanëdash: —Mayan icsa dapuduemebanquid ispombi. Aidi mayan icsa dapuduemenuec nadposh: “Esus, nadatiambocquin naquidquio mibi cadoque. Mayan icsa dapuduemeta,” cac mayan icsa dapuduemposh. Aidi ëbëd icquidpenquio icsho isun: “Padicnuna,” cauidpombi. ¿Adambi bëdamboen chuipo? —quepanëdash Uan Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Adoaquien: —Adquid, Padicnuna, cainda. Nadatiambocquin naquidquio Esus nec quequin abimbo tantiaquin ëmbi nacpadomboen nabanquid icnuc mibipadquid ëbëd icquid neque —quepanëdash Esus Uan caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Adashic Esus abi abuc indote ushë chote anoentsëqui yanan, Unësmane quenquio yec nidebi, quequin ambibi tantianec Edusaden yacmi Esus nidoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Adec nidnun ambi bëyucmiaido Esusën abia nidmiac nidaid Samadia caid yacno shubu daëdpactsëc yacno Esusbëd icquido chopanëdash. Choash: —Edusaden yacno Esus nideque. ¿Aidbëd icquido ada mimbi yuedpatsia? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Esus isadaidbo nec, quequin yuedenquiocpanëdash Samadia yacnocquidon. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Adoaquien, Acobobëd Uan nadpanëdash: —¿Ënabicquido unësmenuen mimbi nëdëncatequid chome, Papa, quequindambi Nuquin Papa chuipe, Icbo? —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Adoaquien: —Padicnuna. ¿Matses unësmenuectabi chodio? —quianec ");
INSERT INTO mcfNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","shubu daëdpactsëc yacno nidoapanëdash abëd icquidobëd. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Adec podquedën Esus nidsho abi databëdquid abentsëcshun nadopanëdash: —Mimbi chuibeniacnombobi mibi tsibananec nidendabi —quepanëdash Esus databëdquid abentsëc. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Adoaquien: —Bëdi chëshë aton shëcuën uec. Podochoquidën aton shubu uaic. Aden shubu uainquiocquin Nuquin Papa yacno tabadaid chuibenec nebi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Adoshombic: —Ëbi tsibanta —Esusën caquien utsi: —Con pa unësacsho chococashun mibi tsibanec nidendabi, Icbo —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Adoaquien: —Nuquin Papa yacno tabadnu quequin unësaid chococaquidëmbi ma chococapanuna. Mimbi Nuquin Papa yacno tabadnuequin abi yacno tabadaid tantiaquin mimbi chuibeneta —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Adashic, utsi nadpanëdash: —Mibipadquid icnuequin mibi tsibanendambi. Con matses nidnu quiacnoba ëbi nidme, Icbo —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—Mibi tsibanu queboedi utsiba tantiec ëbipadquid ictiapimbo mibi icpec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Adshumbic ambi bëyucmiaido dadpen, 72tedi, Esusën nidmepanëdash. Daëd-daëdec shubu utsi-utsiec yacno nidshun chuibeneta, quequin nidmepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nidmenun aid 72ted icquid Esusën nadopanëdash: —Mimbi ëbi chiac ëbi tantianuequid dadpen icpec. Adquido icnuc aido tantiamenuen ëbi chuibanquid daëdpactsëc iqueque. Naden Nuquin Papa chui: Icbombo, mibi cadoque. Mibi tantiamenuen chuibanquid dadpen nidmeta, Papa, quequin chui. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aden mimbi chiacpaden mibi nidmembique. Ëbi chuibenec nidanetan. Mimbi nidshun chuibenenubi mibi chieshënquido dadpen iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ëbi chuibenec nidanequin mitsana buanenda. Mitsana bedtequidbëdta shictoadte buanenda. Tapucudte tapucudenquio yec nidanetan. Adec nidanequin utsi bëquedash tabadenquiocquin datambidanec shubun puduedec nidta. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Shubun puduedshun naden shubu icbo chuita: Nuquin Papabëd abi yacnocquido bëdamboec tabadacpadquiec ma nëid shubun icquido tabadpanuna. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aden chiac shubu icbo bëdamboec tabadnuequid icsho Nuquin Papan abi bëdamboec tabadte aid shubun icquido menendac. Shubu utsi icbo ëbi chieshënquid ictsiash. Adquid yec mimbi chiaid tantianu quesa aid shubu icbo icpec. Adquid icsho Nuquin Papan abi bëdamboec tabadte aid shubun icquido menenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mibi yuedacnouidtsëqui tabadta. Adembidi, mibi yuedquidën meniaid peshun acta. Mimbi chuibanaid cuidquin aidëmbi mibi menendac. Adoac anouidi tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Shubu dadpen yacno mibi choacsho yuedshun pete meniac isuidec, Utsitsen bec cho, quenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ambobi tabadquin daicsaid bëdameshun naden chuita: Nuquin Papan Chomiaid abi yacno yuedanquid neque. Aid tantiata, quequin chuita. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Shubu dadpen yacno choshon mibi yuedquid nibëdsho isun aton podquedën nidquin naden chuita: ");
INSERT INTO mcfNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nuquin Papan chomiaid mibi chuinuec chobi. Ëbi daëdi yuedenquiocsho mibi chuitiapimbo iquebi. Adoac abi yacno ambi chomiaidën mibitedi yuedtiapimbo iquendac. Nuquin Papan chomiaid tantiate bunesa mibi icsho isash mibi yacno capuec ëbi tabitacquiaid tabesquenu. Is, quequin ismequin adota —capanëdash Esusën ambi nidmetequid 72ted icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aden chiashic aido chiec abi Esus onquec: —Naid icsabëdtabi naid bëda chuibante ushë chonoc mibi yuedesa Nuquin Papan comapenen cuidendac. Ëbi choabicnuc Sodoma yacnocquido icpampic. Ëbi choabicnuc aidon ëbi tantiatiapimbo icpampic. Adquido Nuquin Papan bëdiactsëc cuidendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aden ambi nidmetequid 72ted icquido chuibanshumbic utsibo isacbimboen Esusën nadopanëdash: —Nëbi icquido, shubu dadpen icquid tantiec unësquiocquin mibi chiembique. Tantiata. Shubu dadpen icquid Codasin caid yacnoshon ëmbi nadatiambocquin nabansho mibitedishun isted-istedshumbi Nuquin Papan chomiaid nec quequin tantienquio mimbi iccuededpec. Adembidi nadatiambocquin nabansho isted-istedboedi Betsaida yacnocquido mibi nec. Aden ëmbi nasho isash ëbi tantiesa mibi icoapec. Ënden yampido isadaidpembon ëmbi nadatiambocquin nabansho isun, Icsaquid nebi, queshun unësquiocnoc shubiquin abi icsaid ëntsempampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aden Tido yacnocquidobëdtan Sidon yacnocquidon tantiashun abi icsaid ëntsempampic. Adquido Nuquin Papan bëdiactsëc cuidendac. Isadaidbo Codasin yacnocquidobëd Betsaida yacnocquido ëbi isquido mibitedi nec. Ëbi tantiesa icsho Nuquin Papan mibi comapenen cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Adecbidi, nëbi icquido, Capednaun yacnocquido mibi unësash ¿Nuquin Papa yacnoda mibi nidpe? Padenquio. Ëmbi nadatiambocquin nabansho isun tantiesa yec chian anëdënquiacno mibi nidendac —quepanëdash Esus abi tantiesabo chiacbimboec onquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aden chiashic, ambi nidmenu caido 72ted icquido tantiamenuen chuibudec: —Mibitedishun ëbi chiac ëbi tantiaquido utsibo iquendac. Adquiobidi mimbi ëbi chiac ëbi tantiesabo icoaindac. Adomboembidi ëbi chuibansho tantienquio yash ëbi chomiondaid tantiesambo nendac —quepanëdash Esus. Aden chiac ambi nidmenu caido nidanepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Adec nidanequin Esusën chiacpaden nabeniashic, Bëdambo iquebi, quecuededec Esus yacno cho-choapanëdash. Adec cho-choash: —Mimbi chiacpaden nabanombi. Aden nabanquimbic, Esusën nadatiambocquin naidënquio dapuduenta ëmbi caidtedi mayan icsa dapuduemposh, Icbo —quecuededpanëdash ambi nidmiaido 72ted icquido ambi naboed Esus chuibanec. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Adoaquien: —Ëmbi nadatiambocquin nabanquin tantiamiac mibitedishun mayan icsa dadpen dapuduemebedednubi abi dëniacacbimboecnuc bedquetanacbimboec Satanas abucuësh badedquio paëdsho isec niobi. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ëmbi nadatiambocquin nabanacpadquid mibitedi icmebanombi. Aden mibitedi adquid icmiacsho mibi chieshënquidon mibi icsa uatiapimbo iquendac. Mibi chieshënquin icsa uanuequido nisibimboecquido nec. Aidobidi icsa uanuequid yec chichumbimboecquido neoaic. Adquid nisi icsho catashac mibi petiapimbo iquec. Adomboembidi catashac chichunën mibi setiapimbo icoaic. Adquidbimboec mibi chieshënquid icsho ëmbi chiacpadomboen nabanac mibi icsa uatiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aden nabanac mibi icsa uatiapimbo icsho isash, Bëdambo iquebi, quenda. Nuquin Papan abi yacno chomenuequin ëbi cuëmëdquid ënden dada uaid iquec abi yacno ëbi puduedte iquec, quequin tantiec, Bëdambo iquebi, quianta —capanëdash Esusën ambi nidmiaido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aden chuibanshumbic ambi nidmiaidon chiaid tantiash, Bëdambo iquebi, quequin Nuquin Papa Esusën nadopanëdash: —Abu icbo nidaid icbobidi mibi nec, Papa. Adquid icquin ëmbi nidmiaido mimbi tantiamiacpadomboen nadatiambocquin aidon nabededosh. Aden nabededshun chuisho tantiash bëdambo iquebi. Dadpen tantiaquido mimbi nadatiambocquin naid tantiamenquiocquimbi, ëmbi namiaido, daëdpactsëc tantiaquidobien mimbi tantiamioc, Papa. Mimbi tantiacpaden tantiamiac ëmbi nidmiaidon nabededosh, Papa —quepanëdash Esus Nuquin Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aden Nuquin Papa chiec onquequin nainec: —Con pa abia yampid icquin abitedi tantiaquidquio nec. Aidën abipadquid icmiaid nebi. Aid abentsëcquiobi ëbi bëdamboen tantiaquidquio con pa nec. Adecbidi abëd abia yampid icquin con pa bëdamboen tantiaquidquio nebi. Adquid icquin, Con pa nad iquec, quequin ëbi tantiaquido tantiamendambi —quepanëdash Esus abi tantiec choash iccuededquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aden iccuededquido chuibanshumbic naden ambi 72ted icquido nidmian choboedouidtsëqui Esusën chuioapanëdash: —Ëbi tantiaquido icquin ëmbi tantiamiacpaden mimbi nabansho isun Nuquin Papan bëdambo iquebi camiaido mibitedi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nuquin Papan chiaid chiampidobëd ancanquid icampido mimbi nadatiambocquin nabamboed iste bunquin aidon istiapimbo icpampic. Adembidi, ambi chiaid Nuquin Papan chomiaid abi yacno puduedmianquid chosho iste bunquin aidon ëbi istiapimbo icoapampic —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Adashic, ¿Tantiaquidquioda Esus neque? Tantiabono, abibi quequin dada utsin: —¿Nuquin Papa yacno tabadnuen atotsimbi napeba? chuibanquin tantiamequidën ëbi chui —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Adoaquien: —Ambi Nuquin Papan naden nata quequin chiaid Moises dada uamiampid ¿mitsipaden chuipec? ¿Aid isquin atotsi mimbi tantiape? —quepanëdash Esus abi chuimequid caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Adoaquien: —Nuquin Papan chiaid nad iquec: “Nuquin Papa tantiadoneta.” Ambi chiaid utsibic: “Mibi icnëdacpadpenquio yec Nuquin Papa bunacpadquiec tabadnuec adquiota.” Ambi chiaid utsibic, “Nuquin Papa tantiaquid nebi quequin bëdamboen nadeneta.” Utsibic, “Nuquin Papa tantiaquid nebi quequin ambi chiacpadomboen tantiaquiota. Aden nabanquimbi utsibo adembidi bëdambo icmequin naban. Ëbi tantiaquin nashuntiadquidi utsibo nec, mimbi cacpaden utsibo tantiaquin nashunta,” quequin Nuquin Papan chiaidquio nec —quepanëdash Esus chuimeboed Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Adoaquien: —Bëdamboen mimbi chioque. Nuquin Papan chiacpadomboen nabanec Nuquin Papa yacno mibi tabadendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aden Esusën chiac ëbi otacquio icsho isash Nuquin Papan chiacpadpenquiocquid nepec, quequin iccuededquid utsibon ëbi chuitsiash quequin tantiashun Esusën chuimeboed: —¿Mitsicquid con utsi nepec? —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Adoaquien Esus: —Utsi chuinu. Tantiata. Edusaden yacnoësh shubu dadpen icquid Edico caid yacno nidsho isun ampequidon bedshun ambi aton na bedtequid aton dashcutebëdtabi chicshun icsa uabudtsëcquien cuestanquin niamposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Adoambi, cuestanquin nianaid uiacno podquedën choquin isadaidbo tsusion, Con matses nenushe. Isnu, quenquiocquin uano datamposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Utsibic, Nuquin Papa tabadte shubu uashunaid nuntan nashunquid choquin, Con matses nenushe. Isnu, quenquiocquin adembidi uano datanoaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Utsibic, Samadia yacnoësh choquid aid podquedëmbi choquin cuestanquin nianaid istuidash unësquiocquin ");
INSERT INTO mcfNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","aton dayun tsadbudshun cuestanquin nia-naidën chiuëtedi aton dauëmbi bënoshcashun bëtaneshumposh. Aden bëtaneshunshun cuestanquin nianaid aton cabayo canandoash aton cabayobëdi nidequi capuquido puduedmete shubu yacno choash abëdi tabadquin bëdamboen isquin nashumposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Adec tabadashic badiadshun capuquido puduedmete shubu icbo cuidquin aton na bedtequid meneposh. Aden menequin nadoposh: “Nidebique. Ëmbi bëboed ampequidon cuestanquin nianaid bëdamboen isquin nashunta. Mimbi aid nashunacsho isun mimbi meneboed cuidquin mibi menendambi,” quequin chianec ampequidon cuestanquin nianaid istuidshun nashumboed nidposh —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aden chuishumbic: —Ëmbi chuiboed utsi-utsiec icposh. ¿Mitsicquid ampequidon cuestanquin nianaidën utsibimboecquid icposh? —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Adoaquien: —Ampequidon cuestanquin nianaid istuidash unësquio yanquin abi nashumboedien con utsi nec, capendac —quepanëdash Esus chuimequid. Adoaquien: —Adembidi mimbembi ëmbi chuiboedbimboecnuc utsibo tantiaquin nashunoata —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Adashic, Esusbëd nidequi abëd icquido shubu daëdpactsëc yacno chosho isun anocquid chidon Madta caidëmbi Esusbëdta abëd icquido aton shubun yuedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Adoac ambo puduedash tsadquin Esusën chuibansho Madian Madtan chibinquio datsadbudshun tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Adec tsadquin Madian tantianubi Madtan ambi natiadquio yaidtedi tantiaquin nabampanëdash. Aden nabanequi Esus yacno choshon: —¿Con chibin ëbëdtambi nainquiocsho isenquioda mimbi ique? Min utsibëdtan nabanta, cata, Icbo —capanëdash Madtan Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Adoaquien: —Mimbi natiadquio yaid dadpen tantiaquidquio mibi iqueque. ");
INSERT INTO mcfNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ëbi tantiaquidquio icta. Adquid min utsimbo Madia icsho, Padicnuna. Min utsibëdtan nabanta, catiapimbo iquebi —quepanëdash Esus Madta caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Adashic ushë utsin Nuquin Papa chiec Esus onquepanëdash. Aden Nuquin Papa chiec onquequin nainacsho isun abëd icquidon nadopanëdash: —Nuquin Papa chiec onquianeta quequin Uan padon abëd icquido tantiamepanëdash. Adembidi Nuquin Papa chiec onqueta quequin ëbitedi tantiamequin chuioa, Icbo —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Adoaquien: —Nuquin Papabëd onquequin naden chuita: “Bëdambocquidquio mibi nec, Papa. Adquid mibi icsho matsestedishun mibi con icbo capashun, Papa. Mibi yacnoshon mimbi uaido mayan bëdabon mimbi chiacpadomboenuidi naic. Adomboembidi matses abitedishunquio napashun, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tantiaquidquio, mibi cadoque. Bumianenquiocquin badiadquidën-badiadquidënquien con pete ëbi bedmedene, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Adecbidi utsin ëbi chieshënsho cuidenquio yec ëbi abi icsaid bëpiscudacpadquiequi ëbi icsasho cuidenquio yec bëpiscudoata, Papa. Adembidi, Satanasën icsa uanushe queshun ëbi cudasquin dayun uata, Papa, quequin chuita” —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Adtanequic Esus nadpanëdash: —Mibëd nashunanquid iquec. ¿Adquid icnuda inchëshpotsembo abi yacno nidshun pete mimbi bedshumpatsia? ");
INSERT INTO mcfNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Inchëshpotsembo pete bedshunuec mibëd nashunanquid yacno nidash: ‘Ëbi yacno utsi chosho pete nibëdnubi yuedombi. Con pete nibëdsho isash pemenun bedec chobi. Mimbi meniaid cuidquin adquidi mibi meneoaimbi,’ quepatsiac mibi mibëd nashunanquid caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Adoaquien, nuntanuëshi: ‘Padi. Shëcnandombi. Con bacuë ishcunec din ictoshon mibi menetiapimbo iquebi,’ quequin mibëd nashunanquidën mibi chuitsiash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Aden aidën chiaqui min pete nibëdnuc chuidonetsiac mimbi. Aden chuidoniac mibi menetsiash. ¿Abëd nashunanquid icshoda mibi menepadic? Padenquio. Mimbi nidenquiocquin chuidonesho tantiashun mimbi chuiboedtedi mibi menepatsiash —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Aden chiec abi onquec: —Adomboembidi Nuquin Papa chuidonesho mimbi bedtiadquio yaid aidëmbi mibi bedmendac. Adembidi, Nuquin Papa tantianu quequin abi chuidonesho mibi tantiamendac. Adembidi, abi chuidonesho Nuquin Papan aton Mayan mibëd tabadmiac aidën Nuquin Papa mibi tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Adembidi chuinu. Tantia. ¿Min mado, Nuëcquid bec cho, queshoda mimbi nisimbo menedi? ");
INSERT INTO mcfNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Adembidi, ¿Cachinan bacuë bec cho, queshoda mimbi chichun menedi? ");
INSERT INTO mcfNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Padenquio. ¿Aden icsaquid icquin min bacuë tantiaquin bëdamboen menequid mibi icnuc Nuquin Papa icsaisa icquin mibi, Min Mayan ëbi mene, quesho tantiashun menenquioda mibi ictic? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Adashic, mayan icsa dapuduedquin eme uaid icsho Esusën istanquin: —Dapuduen —cac mayan icsa dapuduempanëdash. Adec dapuduenan ambi eme uaid onquepanëdash. Adsho isash tantiadempambo yec iccuededquid dadpen tabadcuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Utsiboen: —Mayan icsan icbo Bedtsibu caidën tantiamiac mayan icsa Esusën dapuduemepash icnui —quepanëdash Esus chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Adnubien iccuededquid utsibo: —Nuquin Papan chomiaidquio icquin Nuquin Papa mimbi chiac aidëmbi abucshun naquin ëbi isambo yaid nadatiambocquin ismepatsiashi. Aden mimbi Nuquin Papa chiac aidën nadatiambocquin nasho isash, Nuquin Papan chomiaid nebi quequin abimbo chuiquid mibi nec, mibi catsiambi —quepanëdash iccuededquid utsibo Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aden chuisho tantiash tantiaquidquio yec abi icsamboen chuimenuequido chiec Esus nadpanëdash: —Chuiquid dapa nëishquin abëd icquido comapenen chushcac, Abëd ictiapibi, quianec cuëshëd-cuëshëdec nidanepec. Adec nidaniash chuiquid dapa ictiapimbo aid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Adembidi, Bedtsibu cashumbic Satanas caid mayan icsatedi chuiquid dapa nec. ¿Mayan icsa icquinda abëd icquido dapuduemequid ëbi icmepadic? Adembidi, ¿ambi mayan icsa dapuduemiac abëd icquido nibëdenquioda ictic? ");
INSERT INTO mcfNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bedtsibun tantiamiaid nec, mimbi ëbi capec. Adembidi mibëd icquidon mayan icsa dapuduemec. ¿Tsuntsin tantiamiac aidon mayan icsa dapuduemepash? Nuquin Papan tantiamiaido nebi, aido quesho tantiash, Abimbo caic, mibi quepec. Adomboembidi Nuquin Papan tantiamiaid nebi, quequin ëmbi chuisho ¿atotsi quiash, Abimbo chiec, quenquio mibi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","¿Nuquin Papan tantiamiac mayan icsa dapuduemequid ëbi yec ambi chomiaidquio matses chuiquid dapa mibi yacno ënden choabida ictio? —quepanëdash Esus abi chuimequido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Aden chiashic abi onquec: —Mibitedi tantiamenuen utsi chuinu. Bëdamboen tantiata. Chuiquid dapa icquin abëd icquido cuëshëdnu quenquiocquin bëdamboen chuiquin namepec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aden namiac tabadnubi chuiquid dapa icnuequid utsi chopec. Nëbi choquidën abia chuiquid dapan yuabo nameshun nua meniac aidën yuabo yanoapec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aden chiashic: —Ëbëd icquido ëbi chieshënesa nec. Matses ëbëd icquido icmenu quequid nebi. Matses Esusbëd icmenu quesa cuëshëdmianquid nec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aden chiashic abi onquec: —Abi dapuduedaid mayan icsa abibi dapuduenanec abipadquid tabadacno icsano matses nibëdacno nidash capuquin abi dapuduedbocpadquid istuidenquio icposh. Adquid istuidambo yec, Abibidi dapuduedoanu, quianec anobidi nidoaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Adec nidshun abi dapuduemboed naden istuidposh. Mayan icsa nidan, Ëbibi bëdambo iquec. Adash bëdambo tabadnu, abibi quiashic, Nuquin Papa tantianu, quenquiocposh. Aden chienquiocsho aton Mayan Nuquin Papan aid menetiapimbo icnuc abi dapuduemboed choshon aid abentsëcquio ");
INSERT INTO mcfNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","istuidashic nidoashun abipadquid chuituidac utsi 7ted abëdi choash abitedi dapuduedcuededac dada icsamboshë yamposh —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Aden Esusën chiambien iccuededquid chido: —Mibi tishacsho shuma chishmiondaid Nuquin Papan bëdamboen isaid icpec —quepanëdash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Adoaquien: —Aden nasho padenquio. Nuquin Papan chiaid tantiashun nabansho Nuquin Papan bëdamboen isaidquio nec —quepanëdash Esus chido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Adnubien abi yacno cho-choash utsi dadpen iccuededsho isun Esusën nadopanëdash: —Nëbi nidaidën tabadquido icsanuequido yec Nuquin Papan abucshun nadatiambocquin naid iste mibi bunacpaden mimbi isenquio iquendac. Nuquin Papan Onas ismiampicpaden ismiaid mimbi isendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ninibe yacno nidshun ambocquido icsaid cuidte Nuquin Papan chuimiacpaden Onasën comapenen chuisho tantiash, Abimbo chuiquid nec, queshun abi icsaid Ninibe yacnocquidon ëmbededpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Utsibic, Nuquin Papan dadpen tantiamiaid, Sadomon iquec quesho tantiash chuiquid dapa chido Sadomonën chiaid tantianuec ënapenuësh choshon tantiash, Abimbo iquec, quepampic. Nuquin Papan matsesën naid icsa ambi naid bëdabëdta chuibante ushë chonoc aid chidon tantiampicpadomboen Nuquin Papan chiaid abimbo iquec quequin mibitedishun tantienquiocsho Nuquin Papan mibi isendac. Nuquin Papan bëdamboen tantiaquin chuiquid dapa Sadomon icmepampic. Abitedi tantiampidquio nëmbobi iqueque. Ëmbi chiaid tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Adembidi, matses icsaidbëdta ambi bëdamboen naid Nuquin Papan chuibante ushë chonoc Ninibe yacnocquidon Onasën chiaid tantiacpadomboen Nuquin Papan chiaid abimbo iquec, quequin tantienquio icsho Nuquin Papan mibitedi isendac. Nuquin Papan chuimiac Onasën chuisho Ninibe yacnocquidon tantiabededpampic. Onas Nuquin Papan matses icsaid cuidte chuimiaidquio icpampic. Padnuen mibi icsaid bedshunash abided cuidadtequid nëmbobi iqueque. Ëmbi chiaid tantiata —quepanëdash Esus abibi chiadequi. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aden chuishumbic Esusën abi chuibanec: —Tabote taboshon ompoesa. Adembidi matsun bëtashesambo icbo nec. Ma ëmbi yuedaidon isnueshun tabote nënantan nanquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Adoaidbimboec min tantiate iquec. Min tantiate bëdambocquid icquin bëdamboec tabadquin ismequid mibi nendac. Bëtashacbimboec min tantiate icnuc icsamboen ismequid mibi nendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Con icbo ëbi bednuec choec queshun bëpiscudenquiocquin isted-istedta. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Min tantiate icsaisa icsho Nuquin Papan chiacpadomboen tantiaquidquio aidi nec, quequin utsibon mibi isendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aden Esusën chuibanshobien padiseyobo abentsëcshun: —¿Ada ëbi yacno pec nidtsia? —capanëdash. Adoac aidbëdi nidash pete sanaid cueste dayunquio Esus tsadbudpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Adec Esus tsadsho isash, ¿Adpecshenda iquec. Penush mëpamëdenquio Esus icpec? quec abibi onquequin padiseyobon Esus yuedquidëmbi tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Adoaquien, tantiaquidquio iquec Esus nadpanëdash: —Ëndenquimbo padiseyobon peshun acnun dëshote cachocbëdtabi pada-padaid cachoc bëdamboen dapanta quequin chuinëdacpaden mimbi naoaic. Aden dapanshun mimbi codocaidbëdtabi mimbi actequid nitsinaid anauc ampanenquio mimbi icpec. Mibitedi adquio iquec. Nesquin bëchish uquec dapanudquin mimbi tantiaid icsa ënenquio mimbi icpec. Adecbidi, mibi bunaid bednuen icsamboen naquin ampequid mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nuquin Papan chiaid tantiesabimboecquid mibitedi nec. Nuquin Papan matses uaquin dadabëdtabi tantiate uainquioda icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ai. Adquid icnuc aton na nibëdquid tantiaquin mimbi pada-padaidën nitsinaidpadquid menebanta. Aden mimbi nadenesho isun Nuquin Papan min tantiatebëdta min dada bëdamboen isendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aden chiashic padiseyobo caic Esus nadpanëdash: —Uno bedanquin dies yacno ënquin min tiedën caniquid ëshë tambanshun, Nuquin Papan chiacpaden con na 9ted icnubi abentsëc Nuquin Papan na nec, quequin aid abentsëc menenuequin mimbi dayun uaic penquiocquin. Aden nabanquin Nuquin Papan ambi matses bëdamboen tantiaquin nabanacpaden naisabo mibi nec. Min tiedën caniquid dies yacno cuëscaquin tambanshun Nuquin Papan chiacpaden abentsëc menebanshun utsibo bëdamboen tantiaquin nabantiadquidi mibi neyoc. Adesa icsho Nuquin Papan icsamboen isaidquio mibi nec, padiseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Adembidi, tsusio dapabimboecsho bëdamboen ispashuni, quequin tantiec Nuquin Papan chiaid tantiate shubun puduedash tsusiobo tsadacno mibi tsadtenec. Adomboembidi tantiec matses iccuededacno nidequi, Ëbi bëquedquidon ëbi tsusio dapabimboecsho isash onquequin chuipashuni quec mibi capuec. Aden tantiaquid Nuquin Papan icsamboen isaidquio mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Adembidi, matses unësaid chococate manenushe queshun ismequin mabiunu, quenquio yacpadomboen ëbi icsaid tantianushe quequin ompoquid mibi nec —quepanëdash Esus padiseyobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Adoaquien, Nuquin Papan naden nata quequin chiaid tantiembi, quiash utsibo tantiamequid abentsëc: —Padiseyobo chuiquin ëbipadquido mimbi chuioapec —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Adoaquien: —Nuquin Papan ëndenquimbo naden nata quequin chiaidbëdta mimbi naden nata quequin chiaid dadpen chuibanquin matses mimbi namec. Adoac aidted matsesën natiapimbo icpec. Adsho isash, Mimbi natequid dadpen iqueque. Mibi nashunu, quesa icsho Nuquin Papan icsamboen isaid mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Adembidi, Nuquin Papan chuimiaid dadpen min tsusedpabon cuesunepampic. Tsusedpabon cuesuniampido ënenquiocquin tantianu quiacbimboen mimbi shubumpi uabanec. Ëmbi shubumpi uaido isun utsibon bëdamboen ispashuni, quequin aden mimbi nabanec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aden naquin tantiec, Nuquin Papan chuimiaido cuesunequin bëdamboen tsusedpabon napampic, quiacbimboen tantiaquid mibi icnuc ambi chuimiampido cuesuniampidobimboecsho Nuquin Papan mibi isec. Nuquin Papan icsamboen isaidquio mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ëmbi chiacpaden chuibanta, cabicquin naden Nuquin Papan chuipampic. Ëmbi chuimiaid utsi-utsien aton matsesën mëyampec. Utsi-utsien mëyanshun cuesunepec, quec Nuquin Papa abitedi tantiaquidquio adpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aden min tsusedpabo Nuquin Papan chuimiaidon chuisho tantiesa icquin aido mëyampampic. Min tsusedpabopadquid nëbi icquido icquin Nuquin Papan chuimiaid tantiesambo mibi nec. Adquido iquec ënden mëyanampidpadquido mibi neoaic. Aido cuesuniampidpadquido mibi neoaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tsusedpan abia abed cuesunepampid icnubi ambi tsyuec Sacadias cuesunepampic. Aid Nuquin Papa tabadte shubu uashunaid dayunquiobi aidon cuesunepampic. Ai, Nuquin Papan chiaid tantiesatedi ambi chuimiaido cuesuniampidpadquido nëbi icquid neoaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nuquin Papan naden nata quequin chiaid tantiembi, queshun utsibo tantiamenquiocsho Nuquin Papan icsamboen isaido mibi nec. Nuquin Papan chiaid tantienquiocquin abi yacno yuedanquid tantiesa mibi nec. Adquid iquec mibi abi yacno puduedtiapimbo iquec. Adquid mibi icquin naden nata quequin chiaiduidi mimbi chiac utsibotsen abi yacno puduedmiantequid tantiesabo yec abi yacno puduedtiapimbo icoaic —quepanëdash Esus Nuquin Papan naden nata quequin chiaiduidi tantiaquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aden chiashic, Ëbëdtambi pec cho, queboedën shubunuësh puduenanec Esus nidpanëdash. Adec Esus nidambien abi comapenen chieshënquidombo padiseyobo: —Esus icsamboen chuimenu —quiampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Adquid icquin Esusën chuibanacno nidaneshun chuimeoanuequin naden padiseyobon tantiapanëdash: Ëbitedishun chuimiac Nuquin Papan chiaid icsamboen Esusën chuitsiash. Aden icsamboen chuisho tantiash, Nuquin Papan chomiaid nec, quec mibi muasho tantiashun, Unës uametiadquio iquebi, quequin Esus chiembi, quequin tantiaquin Esus chuimepanëdash padiseyobon. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aden padiseyobon: Esus icsamboen chuimeoanembi, quequin tantianubien matses dadpenquioshë Esus yacno cho-choash tsucus-tsucustsëcquio yec tabadpanëdash. Aido tsucus-tsucustsëcquio yec tabadnubien abëd icquido Esusën nadopanëdash: —Sicaid nami uaid cabiunac amëec bidisquedoec matsesën isenquiocnobi. Adembidi padiseyobon Nuquin Papan naden nata quequin chiaidbëdta ambibi tantiacpaden naden nata quequin dadpen chuioaic. Aden padiseyobon ambibi tantiacpaden naden nata quequin chuisho, Nuquin Papan naden nata quequin chiaidta nec, quequin Nuquin Papan chiaid bëdamboen ista. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Matsesën ompoquin naid Nuquin Papan abitedi ismendac. Matsesën ompoquin chienquio yaidbidi abitedi tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Inchëshën min nuntanuësh mibi icsamboec onquiaid Nuquin Papan matsestedi tantiamequin chuibanendac. Nuntanuësh shoshquequin mimbi chiaid Nuquin Papan matsestedi tantiamenuen chuioaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Adembidi chuinu. Tantiata. Mibi cuesunenuequid dacuëdënenda. Adquidën mibi cuesunequin mibi nibëdametiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nuquin Papauidtsëqui dacuëdënta. Icsadednequid icsho aidën mibi cuesunemeshun chian anëdënquequid nësecaindac. Adoanquiduidtsëqui dacuëdënta. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nuquin Papa tantiaquid yec dacuëdenda. Nuquin Papan ambi uaidtedi tantiec. Padichucu dadpen icquid abentsëc cueso isun aid Nuquin Papan tantiapec. ¿Adquid tantiaquinda Nuquin Papan mibi tantienquio ictic. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ai, mibi tantiaquiec. Min manëdaidtedi ambi tambanaid nec. Aid pistsëcquidtedi tantiaquin Nuquin Papan mibi tantienquioda ictic? Mibi comapenen tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Abi chiembique. Tantiaquiota. Utsibo icnubi Esus tantiaquid nebi, quequin abimbo chuiquid Nuquin Papa yacno chosho isun, Nëid ëbi tantiaquid neque. Puduedme, quequin chiendambi. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Adecbidi, utsibo icnubi, Esus tantiaquid nebi, quetiapimbocquid Nuquin Papa yacno chosho isun, Nëid ëbi tantiesa neque. Puduedmenda, quequin Nuquin Papan uaido mayan bëdabo chiendambi. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ëbi matsesacsho matsesën icsamboen chuipec. Aden icsamboen chuiboshombic, Icsamboen chiombique. Ëmbi mibi icsamboen chienquio yacbimboec bëpiscudta, Papa, quesho tantiash aidën icsamboen chienquio yacbimboec Nuquin Papa bëpiscudendac. Nuquin Papan Mayanën tantiamiac nasho isash, Satanasën tantiamiaid nec, quequid icpec. Aidën chiaid bëpiscudenquiocquin Nuquin Papan abi yacno adquid yuedenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Adembidi chuinu. Tantiaquiota. Mibi chieshënquido iquendac. Adquid icquin chuiquid dapa yacno Esus tantiaquido ëmbi buanacsho aidën mëyantsiash, quequin mibi bedshun aid yacno buampec. Aden nanu, quequin buanaqui ¿Atotsimbi chuiquid dapa chuipe? quequin tantienda. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nuquin Papan Mayanën mimbi chuibante mibi tantiameque —quepanëdash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Adashic, abi datsidadquid abentsëcshun: —Con pa unësan con pan na dadpen con buchin bedbanosh. Mimbi dadpen bedbamboed musuctanquin min utsi meneta, quequin con buchi chuita —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Adoaquien: —¿Buchibëdta mibi chuiquidtabi nepe? —quepanëdash Esus abi chuita caquid caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aden aid chuishumbic utsibo chuiquin nadopanëdash: —Con na dadpen bednu, quesa icta. Mimbi bedaidënquio mibi Nuquin Papa yacno puduedtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","“Aidpadquid chuinu. Bëdamboen tantiata. Aton na dadpen icnubi aton tiedën caniquid bacuëash dadpen icsho isash icbo nadposh: ");
INSERT INTO mcfNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","‘Con tiedën caniquid bacuë dadpen iqueque. ¿Atontsimbimbi aidtedi dayun uapeba? ");
INSERT INTO mcfNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naden naimbi. Tiedën caniquid ëshë dayun uate shubu shënitedi chicbanshun aidtedi nuamboshëcnuc shubu uabanuna. Aden nuamboshëcnuc shubu uashun aidënquio con tiedën caniquid bacuëtedi sandoshon dayun uanuna. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aden dayun uashumbic nadopembi: Con na dadpen iquec yuecash naimëdenquio iquec. Ad icnuc nainquio yec tabadquin peshun aquendambi. Aden naic, Bëdambo iquebi,’ quec aton na dadpen icquid abibi onqueposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Adec abibi onquesho tantiashun, ‘Mimbi icsamboen tantiec. Nëid inchëshëmbi mibi unësec. Adec mibi unësan ¿mimbi dadpen dayun uaid tsuntsin bedpatsiash?’ quequin Nuquin Papan aton na dadpen icquid chuiposh —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aden chiashic: —Aton na dadpenuidi tantiaquin Nuquin Papan chiacpaden naisa yec aton na nianec unësash Nuquin Papa yacno tabadtiapimbo iquec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aden iccuededquido chuishumbic Esusën abëd icquido nadopanëdash: —Aton na dadpen icquidën tantiacpaden tantienda. ¿Con na nibëdnuc atotsimbi pepeba? quec dacuëdenda. Adecbidi, ¿Atotsibi dasiuidpeba? quec dacuëdenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bëdamboec tabadnuequin mibi piasteuidi tantienda. Adembidi, Con dada bëdambo icmenuequin, Dashcute bedteuidi tantienda. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¿Uicchunënda ambibi cuëte ëshë siac bacuëacsho chepadic? Padenquio. Adecbidi, ambi dayun uatequid shubu nibëdnubi aton na nibëdec. Adquid icsho Nuquin Papan aton pete bedmec. Uicchun Nuquin Papapadquidpenquio icshobi aton pete Nuquin Papan bedmec. ¿Ad icnuc ambi abipadquid uaidobi matses icsho aton pete bedmenquioda icpadic Nuquin Papan? ");
INSERT INTO mcfNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Adecbidi, ¿mibi unëste ushë abimbo chonoc, Padi, quepecta mibi icti? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Adec mibi unëste chonoc, Padi, quetiapimbo mibi iquec ¿atotsi quiash ¿atotsimbi pepeba? quepe mibi? ");
INSERT INTO mcfNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Adembidi, cuëtempi chuinu. Tantia. ¿Cuëtempinda aton bacuë ictequid daëdcapec? Padenquio. Adoenquio yaid aton bacuë ictequid bëdaidquio iquec. Cuëtempi bacuë ictequid bëdaidquio yacpadquid chuiquid dapa Sadomonën dashcute adquio ictiapimbo icpampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Padnuen cuëte bacuë ictequid bëdaidquio icboedi badedquio sequiash chodquiacsho tauiquid. Ad icnuc ¿Abipadquid Nuquin Papan uaido mibi icsho mibi dasiuidte bedmenquioda icpadic? Ëbi bedmenquio ictsiash quequin Nuquin Papa bëdiactsëc tantienda. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aden tantienquio yec ¿Atotsimbi peshun aque? quec dacuëdenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nuquin Papa tantiesan abi bunaiduidi tantianubi Nuquin Papa tantiaquidquio icquin pete actequidbëdta ëbi bedmedonec, quequin tantiec tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Adembidi, Nuquin Papabëd tabadnu quequin tantiec tabadta. Aden tantiaquin mimbi bedtiadquio yaid mimbi bedendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nuquin Papan abi yacno mibi chomeque. Dacuëdenda, ëbi tantiaquido caimbi. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ambo nidabi icquin mitsana menebanquin mitsana bedtequid bedshun aton na nibëdquid menebanta. Aden utsi tantiaquin mimbi nabanuc Nuquin Papa yacnoshon menetequid mitsana chodquetemaid iquendac. Ampequidën bedtemaidquio iquendac. Capishton petemaidquio aid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mimbi tantiaidquio mimbi dayun uaid mibi cudasaid nec. Nuquin Papa yacno nidnu quequin mimbi tantiaid icnuc mibi bëdamboec tabadte cudasquin mimbi dayun uaid iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Aden chuishumbic Esusën nadopanëdash: —Aton icbo u isec nidan con icbo chonoshe quiash dasiuidacchobi ushenquiocquin tabote dëbedtonequin, Con icbo chosho puduedmeshun nashunu, quequin aton yuabon caimpec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aden abi cainquido aton icbon bëdambo icmequin nadopec: “Ëmbimbo mibi pemenu. Nëmbo tabadec cho,” queshun ambi yuaido icbonquio pemequin bëdambo icmendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Adembidi, icbo inchëshpotsembo choshon abi nashunuequin cainquido icsho icbon bëdambo icmiaido iquendac. Adembidi, cachina cuëdanabi badiadabicnuc choshon abi cainquido icbon bëdambo icmiaido iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Adquidpenquio icbo utsi chuinu. Tantia. Aidi abi cainquid nibëdnubi aton na icnuc isedtanec choshon isac ampequid ënden nidac. Adsho isash, Ampequid choec, quequin tantiaquid yec nidenquio ictsenobi, quependac icbo. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Adquiecbidi ampequid choacbimboec Nuquin Icbo choeque. Ad icnuc, Chosho ëmbibi tantienquiocchitomane queshun chieshenquiocquin ëbi cainta —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aden Esusën chuisho tantiash Petedo: —¿Utsi chuiquin mibëd icquidouidi tantiamenuenda chio? ¿Abitedi tantiamenuenda chio? Tantianu. Ëbi chui —quepanëdash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Adoaquien: —¿Icbon chiac mitsipadquiocquin ambi namiaido bëdamboen napeba? Adquid chuinu: Pete tambanshun musucshun ëmbi namiaid utsitedi bëdamboen menebanta, quequin ambi namiaid utsi abentsëc chianec icbo nidac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Adec nidashic choshon ambi chiacpaden ambi namiaidën chieshenquiocquin nabanacsho isun icbon bëdambo icmiaid nendac. Adquid naden chuipec: Ëbi nidan chieshenquiocquin mimbi nabanoque. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ëmbi namiaid utsibotedi ëbipadquiocquin chuiquid icta. Adquid icquin con natedi dayun uata, quequin chiendac icbon. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Adquid icnubi adomboen naisa icbo utsin namiaid icpec. Aton icbo yuec choenquiocsho isun aton icbon namiaid utsibo chieshënquin cuesbanshun ambentsëqui nua peshun tantienquio yanquin aquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aden nabanquin tantienquiocnoc aton icbo choshon ambi namiaidën icsamboen cuesbanaido isun icbon comapenen cuesquin abi tantiesa utsibo ambi nidmiacnombo aidi nidmeoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Adembidi, ambi chiacpaden nabanesa icsho isun, Comapenen cuesta, icbon cac cuesendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aton icbo bunaid tantiabicquidën cuesmetiadquiocquin nabansho aton icbon bëdiactsëc cuesmendac. Adembidi, Nuquin Papan dadpen tantiamiaido ambi chiacpaden nashuntiadquio iquendac. Adembidi, icbon dadpen meniaidon dadpen meneoatiadquidi nendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Aden chiashic abi onquec: —Ëbi tantiaquid icnuc ëbi tantiesa yec cuëshëdendac. Aido ënden cuëshëdondan ëbi tantiaquidombo bëdamboec tabadtsiandac, quec tsadebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Adecbidi, Yuecshun ëbi unës uanun mëyantequid iquendac, quequin tantiec, Ënden mëyanondaid iquec abuc Nuquin Papabëd tabadtsiandabi, quec tsadebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Nidaidënshun abitedi bëdamboen tabadmenu quectabi chodionda? Padenquio. Ëmbi chiaid tantiesa ëbi tantiaquidbëd icboedi cuëshëdtsiash quianec chopondabi. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nad iquendac: Min shubun icquid sincoted icboedi Esus tantiaquid utsi-utsiec yanubien utsi padenquio yec cuëshëdec adquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nadec cuëshëdtsiash: aton papa ëbi tantiaquid icnuc con papadquid icnu quesa aton mado cuëshëdendac. Shubu utsin aton mado ëbi tantiaquid icnuc aton papa adquid icnu quenquio yec cuëshëdendac. Adecbidi aton tita ëbi tantiaquid icnuc con tapadquid icnu quenquio yec aton champi cuëshëdendac. Shubu utsin, aton champi ëbi tantiaquid icnuc aton tita padenquio yec cuëshëdendac. Shubu utsin aton chaya ëbi tantiaquid icnuc aton babanën padenquio yec cuëshëdendac. Shubu utsin, aton babanën ëbi tantiaquid icnuc aton chaya padenquio yec cuëshëdendac —quepanëdash Esus. Abi tantiesa cuëshëdtequid chuibanec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aden abëd icquidombo chuishumbic Esusën naden iccuededquido chuioapanëdash: —Inchësh chosho isec, Ue choec, quiacpadec choec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Adecbidi, ushë chënquec chosho isash, Chumbo yampec quiacpadec iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aden isquin mimbi ëmbi nidaidënshun ismiaidbëdta abucshun ismiaid mimbi tantiec. Aden abucshun ismiaid isquin tantiaquidquio icquin ¿atotsieshun abucshun Nuquin Papan chomiaid isumbi tantienquiocquin mibi icsaid ënenquio ique? —quepanëdash Esus iccuededquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aden chiashic: —Utsibëd chushcananquido mibi nec. Adec tabadec ¿atotsi quiash, Naden natiadquidi nebi, quequin tantiashun mibi icsaid ënenquio ique? ");
INSERT INTO mcfNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Utsi icsambocquin mimbi nadenec. Adsho isun matses cuidte chuiquid yacno aidëmbi mibi buanshobi nëish bëdamenuen, Mimbi chiacpadomboen mibi nashunu, quequin bëdamboen chuita. Mibi adenquio icsho matses cuidte chuiquid yacno buanshun mibi icsaid chiac matses cuidte chuiquidën, Quënën nauedmenuen buanta, cac buanshun quënën nauedmequidën mibi quënën nauedmepec. ");
INSERT INTO mcfNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aden nauedaqui mimbi icsamboen naboed cuidnante meniabicnuc quënë yacnoësh mibi puduentiapimbo iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aden Esusën chuibanubien iccuededquid utsibon, Esus chuimenu, quequin caimpanëdash. Aden cainequi Esusën chuibanquin nainsho tantiashun iccuededquid utsibo: —Chuinu. Tantia. Cadidia yacnocquidon Nuquin Papan chiacpadomboen nidaidën capuquido cuesunesho Pidaton aido cuesunemiosh, quiosh. Aden cuesuniac aidon intac ambi nidaidën capuquido cuesuniaidën intacbëd daëdash chididiquiosh, quequin chuipanëdash. Aid chiaid tantiashun. ¿Atotsi icsamboen nasho aido cuesunemepashba? caimbi mibi —quecuededpanëdash Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Adoaquien: —¿Cadidia yacnocquido utsitedi icsaid daëdpactsëc icnuc cuesunemiaido icsaid dadpen icsho aido cuesunemiash, quequinda mimbi tantiape? ");
INSERT INTO mcfNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Icsamboen mimbi tantieque. Mibitedishun mibi icsaid ënta utsibo unësmiacpaden unësmenushe queshun. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chuinu. Tantiata. Shubu dadpen icquid Edusaden caid ënëdacno Sidoe yacno tabadquidon ambi abucshun nacnenaid uebudquin abëd icquido 18ted cuesac unësosh, quiosh. ¿Edusaden yacnocquid utsibo icsaid daëdpactsëc icnuc Sidoe yacnocquido icsaid dadpen icquid unësosh, quequinda mimbi tantiape? ");
INSERT INTO mcfNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mimbi icsamboen tantieque. Utsibo unësacpadec unësmane quequin mibitedishun mibi icsaid ënta —capanëdash Esusën abi chuimeboedo chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aden chuishumbic utsitsen chiec: —Icbon cuëte icnuc nadpec: ‘¿Con cuëte ada bacuëashe? Istanu,’ quianec icbo nidpec. Adec nidshun isquien bacuë nibëdec. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Adsho isun icbon abi neshcashunquid chuiquin nadopec: ‘Seta tedested matamiash cuëte bacuë cuësnuec chouidobi. Bacuëambo iqueque. ¿Bacuëenquiocquididambi dayun uape? Utsi nitsinun dëdshuneta,’ quequin abi neshcashunquid aton icbon chiosh. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Adoaquien: ‘Cuëte bacuëesa ëbi dëdshunemenda. Naden ëbi nameta, icbo. Cuëte bacuëesa tacheshcatanquin seta abentsëc matamequin nidaid chëshë chodquiaid ëbi bëdamboen tasiameta. Adoac bacuëtsiash. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aden seta abentsëc matamiash choquin bacuëacsho isash bëdambo mibi icpec. Padnuen bacuë nibëdsho isun, Dëdshuneta, ëbi caoata,’ abi neshcashunquid quiosh —quepanëdash Esus. Ëmbi tantiacpadec tabadenquiocboedi bëdamboen chiac bëdamboec tabadsho isash ëbi tantiaquid dadpen yanendac, quequin tantiec adpanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Adashic, chonoadtemaid ushën Nuquin Papan chiaid chuibante shubun puduedshun Nuquin Papan chiaid Esusën tantiamenubien ");
INSERT INTO mcfNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","seta dadpen 18tedi matamequin mayan icsan shuabudaid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Adquid icsho isun Esusën: —Shuabudaid icboedi nëbi cacueoaid mibi iquendac, chido —cashun ");
INSERT INTO mcfNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","mishac cacuiash, Nuquin Papan nadatiambocquin naid nec, quequin chiec chido onquepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aden chonoadtemaid ushën Esusën chido bëdamesho isun Nuquin Papan chiaid chuibante shubu isquidon: —Nëid ushë chonoadtemaid ushë neque. Bëdamenu quequin nëid ushënquio bëdamenda. Chonoadtequid ushënquio bëdameta —capanëdash iccuededquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Adoaquien Esus: —Mimbi chiacpaden naisa mibi neyoc. ¿Chonoadtemaid ushë icnuc, Con yua acte acmebono queshun mimbi yuaid tënëshacchobi acte yacno buanenquioda mimbi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Aden chonoadtemaid ushën mimbi min yua acmenuc nëid ushëmbidi chido, min matses Abadauanën tsyuecquid, dadpen seta matamequin Satanasën yuaid icsho mënchiquenquiodambi icpe? —quepanëdash Esus nëid ushën bëdamenda quequido tantiamequin chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aden Esusën chuisho tantiash, Adenda, quequin bëdamboen chiombi, quetiapimbo yec otacquio tabadcuedednubi utsibotedi, Esusën nadatiambocquin naidtedi bëdambo iquec, quec bëdambo yec tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Adashic: —¿Nuquin Papan shubun icquido mitsipadquidquio icpec? ");
INSERT INTO mcfNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nadquidquio iqueque. Chuinu. Tantia. Icbon cuëte ëshë pistsëcquiocquid mostasa caid nësecaid dëyucash nuamboshë caniec. Aid cuëte caniaidën cuidin podochoquidën shubu uabededec. Adquiecbidi, Nuquin Papan chiaid chuisho tantiatsëcquidën tantiabenash bëdambocquid icsho isash matses utsibo ëbi tantiaquid Nuquin Papan shubun icquido dadpen yanec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aden chuishumbic utsitsen chuioaic: —¿Nuquin Papan shubun icquido mitsipadquidquio icpec? ");
INSERT INTO mcfNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nadquid iqueque. Tantia. Sicanun nami uatepadquid nec. Sicaid chidon nami uashun cabiunac amëec bidisquedoec. Adomboembidi ëmbi chiaid ëbi tantiaquidën chuibanac ëbi tantiaquid dadpen yanec utsibon isenquiocnobi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Adashic, Edusaden yacmi nidoaquin shubu dadpen icquid utsi-utsiec yacno isbidanquin shubu daëdpactsëcquid utsi-utsiec yacnotsen isbidanoaquin anocquidotsen tantiamenuen chuibenenu, quec Esus nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Adec nidsho isun iccuededquid abentsëcshun nadopanëdash: —¿Nuquin Papa yacno matses daëdpactsëcta nidpec? Tantianu. Ëbi chui. Adoaquien Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Nuquin Papa yacno pudued-puduedtequid shëcuë pistsëcquio iquendac. Esusquio tantiec aidëmpinquio mibi puduedendac. Mimbi tantiaid utsi icnuc tsucusec puduedtiapimbo mibi iquendac. Adquid dadpen icnuc, ");
INSERT INTO mcfNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nuquin Icbon, Ëbi yacno puduedte ushë naimbudosh, caqui cho-choshon, Ëbi puduedme, quequin comapenen cuëmbededpec. “Adoaquien: ‘Ëbëd icquidpenquio mibi neque. Mibi puduedmetiapimbo iquebique. Mibëd icquido yacno nidtan,’ caindac Nuquin Icbon adquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Adoaquien: ‘Mibëdtambi peshun acbededombi. Ëbi yacnoshon mimbi tantiamequin chuibansho tantiombi,’ quequin abi tantiesan Nuquin Icbo chuipec. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Adoaquien: ‘Icsaquido mibi neque. Nëmbo puduedenda,’ quepec Icbo. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aden chiaqui Abadauan yec Isac yec Acobo yec quec Nuquin Papan chuimiaido aidtedi Nuquin Icbo yacno tabadsho isash abi tantiesa adtiapimbo yec chian anëdënquiacno tabadec shubiquiec, Nuquin Papa icsambo iquec, quec nëishpec. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nuquin Papa yacno abi tantiesa puduedtiapimbocnobien nidaidtedi yacnoësh utsibo dadpen cho-choshon Nuquin Papan abia yuedaidobëdtan tsyuec choquidon peshun aquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Abi yacno choquido utsin namiaid icboedi utsi-utsiec chuiquid iquendac. Choquid utsi chuiquid dapa icboedi utsi-utsiec utsin namiaido icoaindac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aden Esusën chuibanquin naimbudnubien padiseyobo utsi-utsiec cho-choshon: —Ancanquid Edodes mibi cuesunemete buneque. Nëuëshquio nidec nid —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Adoaquien: —Edodes cuesunemenuecbimboec onquequidquio nec. Aid yacno nidshun naden chuita. Nëbi mayan icsa dapuduemequin utsibo bëdamembi. Badiadshun adomboembidi nabanoaimbi. Abadiadshun adomboembidi nabanoaimbi. Ushë utsin-utsinquien adomboembidi nabanoaimbi. Adobanquimbi naimbudembi. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Adobanequi nëbi capuebi. Adobanequi badiadash capuoaibi. Adobanequi abadiadash capuoaibi. Adobanequi Edusaden yacno capuoaibi. Adec capuec ¿Edusaden yacno choabidabi unës uapec? quiosh, Esus quequin Edodes chuita —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Adashic choequi macuësh yacno tabadtuidash shubu dadpen icquid Edusaden caid uano icsho isec Edusaden yacnocquido chiacbimboec Esus nadpanëdash: —Nuquin Papan chuimiaido cuesunequido mibi nec. Adembidi, Nuquin Papan mibi yacno chomiaido cuënoten se-sequido mibi neoaic. Ëbi tantiaquid icmenu, quequin chuideniombi. Cachinan, Con bacuë chieshënquid choec, queshun nua shoccotsëcshun aton bacuë cudasquin mabësec aton podon. Adembidi: Mibi chieshënquid choec, queshun mibi cudasquin chuibanombi. Aden chuisho tantiatiapimbo yec mibi tabadpoc. ");
INSERT INTO mcfNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Adquido yec nëbi min shubun icquido cudasquid ëbipadquid nibëdec. Nad iqueque. Tantia. Mibi chieshënec cuesunenuequido choabicnuc ëbi nidacsho yuen ëbi isenquio mimbi iquendac. Yuecash abucuësh choasho isash, Ambi chomiaid Nuquin Papan bëdamboen isaidquio nec, quequin tantienquiocboedëmbi tantiendac —quepanëdash Esus Edusaden uano icnuc Edusaden yacnocquido tantiamequin chiacbimboec onquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Adashic, chonoadtemaid ushë utsin padiseyobo tsusio dapa isedec Esus puduedsho isun, Nëid ushën natemaid icnuc Esusën bëdamenushe queshun isnuequin padiseyobo utsibo tabadquin caimbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aden caimbedednubien podo nidte chedo bidisquiaid uano tsadsho isun Esusën: ");
INSERT INTO mcfNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","—¿Chonoadtemaid ushën daicsambocquid bëdamenquiocte ushë nec, quequinda mimbi tantiape? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","abi caimbededquido otacquio tabadcuededpanëdash. Adec aido otacquio tabadcuedednubien podo nidte chedo bidisquiaid dada Esusën bedshun bëdameshun: —Nidec nid —cac bëdambo yec nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aden aid nidmeshun abi bëdamenushe quequin caimbededquido caic: —¿Chonoadtemaid ushën nua uëdëshcaidën min baca ampaëdacsho isun badedquio bedtanquin indoenquioda mimbi ictsia? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aden chuisho tantiash adquiobidi otacquio tabadcuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Adashic, tsusiobon dayunquio tsadsho isash, Chuiquid dapa nec, utsibo quetsiash, quec padiseyobo cho-choec, quequin tantiashun Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Pec cho, cac choshon tsadte bëtinenda. Tsadte mimbi bëtinambien shubu icbon ambi pec cho caid utsi mibi chuiquid tsusio chosho ");
INSERT INTO mcfNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","isun: “Chuiquid dapa choeque. Uano tabadad,” icbon cac icsamboen naombi quiash natiaic uano tsadpec mibi. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Naden nata. Pec cho, cac choash utsiuc tsadbudta. Adsho isun: “Uano mibi tsadeque. Nëmbo, chuiquidbëd tsadec cho,” capec mibi shubu icbon. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chuiquidbimboecsho ispashuni, quequid Nuquin Papa yacno choacsho adquid ambi namiaid Nuquin Papan icmendac. Nashunquid icboedi Nuquin Papa yacno choacsho chuiquid Nuquin Papan mibi icmendac —quepanëdash Esus abëdta yuedaido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aden aido chuishumbic abi yuedquid Esus nadpanëdash: —Pemenu, quequin mibëd icquid min utsibo aton na dadpen icquidouidi pec cho cainda. Aido pemiac, mibi pec cho caoaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pemenu, quequin aton na nibëdquido, daicsaidobëdta bëshuaido pec cho cata. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Adquido mibi cuidquin pemetiapimbo iquec. Adquido pemiash, Bëdambo iquebi, mibi quepec. Nuquin Papa yacno nidash puduedsho ambi bëdambo icmiaid mibi iquendac —quepanëdash Esus abi yuedquid caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aden Esusën chuisho tantiash abëdtan pec tsadquid abentsëc: —Nuquin Papa yacno nidshun abëdtambi pec bëdambo iquebi —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Adoaquien aidi tantiamenuen utsi chiacbimboec Esus nadpanëdash: —Yuednu, quequin nadënquio pec chota, quequin ambi yuedtequid dadpen chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ambi chiacpadën ushë chonoc: ‘Ëmbi chuiboedtedi pec cho quequin chuitanta,’ cac aton yua nidposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Adec nidshun chuituidaquien: ‘Nidtiapimbo iquebi,’ queposh abitedi. Abia chuituidaid abentsëc nadposh: ‘Ëmbi sëuëmboed dëdabi nidtiapimbo iquebi,’ queposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Utsibic: ‘Baca bedshun, Bëdamboen nimbanquinda buaneque. Isnu,’ queshun isedtanenquiocquin ambi bedboed nimbameposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Utsibic: ‘Con chido bedombique. Nidenquio iquebi,’ queposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Aden chuisho tantiash nidshun aidon chiacpaden aton yuan icbo chuioaposh. Adsho tantiash nëishun icbon: ‘Ëmbi isedacmaido yacno nidshun, Pec cho, cata. Aton na nibëdquidbëdta daicsaid, bëshuaid chedo chuitan,’ cac aton yua nidposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Nidshun chuitanec aidobëdi choshon, ‘Mimbi chuiboedo bëombi. Aido icnubi abi tabadte iquec,’ queposh yua. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Adoaquien: ‘Shubu ënëdacno nidshun ëmbi chuibocpadquido isun bëoata ma con shubun tsucus-tsucustsëcquio yec ma adquido tabadpanuna. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Abia ëmbi pec cho caidon ëbëdtambi petiapimbo iquendac,’ queposh icbo —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Adashic, nidsho matses dadpenshun tsibanac abi choacmi bidiadshun isec Esus nadpanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ëbipadquio icnuequid aton papabëduidi icquid iquec ëbipadquio ictiapimbo iquec. Adecbidi, aton titabëduidi icquid iquec ëbipadquio ictiapimbo icoaic. Adecbidi, aton chidobëduidi icquid iquec ëbipadquio ictiapimbo icoaic. Adecbidi aton bacuëbobëduidi icquid iquec ëbipadquio ictiapimbo icoaic. Adecbidi, aton utsibobëduidi icquid iquec ëbipadquio ictiapimbo icoaic. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Unësmane quiash mëyanac dayactiapimbocquid ëbipadquio ictiapimbo icoaindac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aden chiec Esus abi onquec: —¿Shubu uanu, queshun abia shubu uaid isec, Nëidtenquio nanu, queshun aidtedquiobidi bëshun toccashun shubu uainquioda icpec? ");
INSERT INTO mcfNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aden tantienquiocquidën abentse-abentsen bë-bëtsëcquin baded naintiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Adsho isun utsibon mamënshumpec. Bëdamboen isun shubu uaquidpadquid, Esuspadquio icnu, queshun ëmbi chiaid bëdamboen tantiabenash adquiobidi icpec. Ëbi tantiauidtsëcquid ëbipadquio ictiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Adembi chuinu. Tantiata: ‘Mibëd icquidobëd cuesnanuec chuiquid utsi nëmbo cho-choec,’ quesho tantiashun nëmbobi icquido chuiquidën naden tantiapec: ‘Ëbëd icquido daëdpactsëc iquec. Aidtedtsëqui iquec dayacquiocquid icquin chuiquid utsi abëd icquido cuemepec, queshun ma chobono,’ quequin caimpec. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Padnuen, abëd icquido dayactiapimbo icsho isun chuiquidën: Chuiquid utsi bëquedtanta. Bëquedshun, Mibëdi ictsiabi. Ëbëd icquido chuiquid icta, ëbi chuiquid quiosh, quequin chuita, quequin chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Adembidi ëbipadquio icnuequidon bëdamboen tantiata. ¿Ëbi chuiquid Esus nec, quequin ambi chiacpadendambi nabampeba? Ai, adonona, queshun adota. Adoesa, Esuspadquiocquid nebi, quenda —quepanëdash Esus abi tsibananquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Aden chiashic Esus nadpanëdash: —Sa batambo iquec. Casecac utsibëd daëdash batambo iquec. ¿Sa batapentsëcquiocquid casecac batamboda icpadic? ");
INSERT INTO mcfNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Padenquio. Secatequid adquid nendac. Adecbidi Esuspadquio icnu quiash ëbipadquio yanesa chian anëdënquequid nësiatequid nendac. Adquid ictiapimbo iquebi, quequin, Tantianu, queshun tantiacpadomboen nabanta —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Adashic, icsaquid utsibobëd ancanquidën matsesën aton na buansho isun aton na bedtequid nëidtedi bedta caido, Tantianu, quiash Esus datsidadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Adsho isash padiseyobo Esus tantiamenquio yec chushquiacbimboec, Abi datsidadquido icsambocquid icsho cacumenquiocquin aidobëdtambi peshun Esusën aquec, quec abibi onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Adoaquien, tantiaquidquio iquec Esus: ");
INSERT INTO mcfNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Min obeca dadpen 100ted icboedi abentsëc bënudacsho isun, Nibënu, quequin min obeca utsi dadpen 99ted nianec nibënec nidenquioda mibi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aidi nibënquin istuidash, Con obeca istuidbosh bëdambo iquebi, queshun chiadquin buanec icbo nidec. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Shubuno choshon abëd icquido ambi yuedaidobëdta chomeshun: “Con obeca bënudaid istuidshun bëbosh bëdambo iquebique. Nuquibi penuna,” quequin icbon chuipec. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Adecbidi Nuquin Papa tantiaquid dadpen icnuc matses icsaquid abentsëcshun abi icsaid ënsho isash abuc Nuquin Papabëd tabadquido bëdamboshë iquebi, quecuededpendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aden icbon aton yua bënudaid chuishumbic utsi chiec Esus nadpanëdash: —¿Aton na bedtequid shocoshëmpi 10ted icboedi abentsëc nibëdsho isun tabote taboshon bescaquin chidon nibënenquioda icpec? ");
INSERT INTO mcfNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ai. Aden nibënquin istuidshun abëd icquido chomeshun: ‘Con shocoshëmpi abentsëc niadacboedi nibënquin istuidash bëdambo iquebi,’ quepec chido. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Adecbidi matses abentsëcshun abi icsaid ënsho isash abi yacnocquido ambi uaido mayan bëdabobëdi Nuquin Papa bëdambo iquebi, quecuededec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aden chido chiashic utsi chiacbimboec Esus nadpanëdash: —Aton mado daëd icnubi ");
INSERT INTO mcfNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tsyuec tishaid aton papa caic: ‘Tsusio budquin mimbi chiondacpaden nëbi ëbi aidted meneta, papa,’ quepondash. Adoac aton na musucshun aton mado abi daëdi menebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Aden meniac daëdpactsëc ushash aton mado tsyuecquid aton natedi sandoshon buanec nidaid utsi yacno nidash icsamboen nabanec tabadnuc aton natedi naimëdpondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aden aton natedi naimëdambic tiedën caniquid unësbunian abi nidacnocquidon pete naimëdan tsusion mado chedo comapenec bundocuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Adec bundoquiec abi nidacnocquid abentsëc yacno nidshun: ‘Mimbi namiaid ictiadquio iquebi,’ caquien: ‘Con chancho pemebanta,’ queshun aton chancho yacno tsusion mado nidmepondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aden nidmiac nidquin chancho pemebanequi ambi chancho pemiaid petiadquio yec tabadshobi anocquidon menenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Adec natiambo bunec tabadquin aton papa ambi nianondaidbëdta abi icsaid utsitedi tantiec abibi onquec nadpondash: ‘Con pan namiaidon pete dadpen icnubi con na nibëdnuc unëspebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nëbi con pa yacno nidshun naden con pa chiembi: Nuquin Papan chiacpaden nainquiocquin mibi tantienquio yec nidshun icsamboen nabanombique. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Adquid icsho con mado nec, ëbi cainda, papa. Nëbi min yuapadquid ëbi icme,’ quequin chiembi, ");
INSERT INTO mcfNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","abibi quianec aton papa yacno nidoapondash. Adec nidec ancuenquio yacno aton mado nidondaid casenash chosho isash unësquiocnoc aton mado bëquedquin dayumbudshun shubi uatanquin aton papan tanchoccapondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Adoac ambibi tantiabocpaden aton papa chuiquin: ‘Nuquin Papan chiacpaden nainquiocquin mibi tantienquio yec nidshun icsamboen nabanec tabadteniobi. Aden naquid con mado ëbi cainda, papa. Min yuapadquid ëbi icme,’ capondash aton madon. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Aden chiaquien bëdambo yanshun ambi namiaidombo naden aton papan chuipondash: ‘Con mado ënden nidondaid choaoshe. Dasiuidte bëdaidquio bëshun con mado dasiuinta. Adoshombic mëusudtetsen mëusunta. Adoshombic tapucudtetsen tasiuinta. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Adoshombic, bacan bacuë nuacquid dapa bedshun cuesuneta nuquitedi bëdamboec tabadquin penun. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Con mado unësacbimboecboedi nëbi ëbëdi tabadoaic. Aidi bënudacbimboecboedi nëbi istuidacbimboec choash iquec,’ cac bacan bacuë cuesuneshun codocacsho pebededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Adnubien bëyuc tishaid tied nantan icpondash. Auëshquio nidec shubu anoentsëqui choquin tentencate cuëdëmec matses cuëdënsho tantiatuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aden tantiatuidashien aton papan namiaid istuidash: ‘¿Atotsi naic nec?’ quepondash bëyuc tishaid. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Adoaquien: ‘Min utsi ënden nidondaid choaposh. Aidi chosho isash unësquiocquin nuquitedi bëdamboec tabadquin pemenuequin aton bacan bacuë nuacquid dapa papan cuesunemiosh,’ cac ");
INSERT INTO mcfNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","bëyuc tishaid nëishash shubun puduedenquio icpondash. “Adsho isash, Puduedenquio iccosh, quequin chiac bëyuc tishaid yacno nidshun: ‘Min utsibobëd bëdambo icnuec cho, mado,’ capondash aton papan. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Adoaquien: ‘Seta dadpen matamequin mimbi chiacpadomboen nabanteniombi. Adquid icsho ëbëd capuquidobëdta ëbi pemenuen yua utsin bacuë mimbi cuesunemenquiocpaboc. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nëbi mimbi meniaidtedi naimbudquinc, chido dada dadpen chudmequid chudquinc caic min mado choacsho isun bacan bacuë nuacquid mimbi cuesunemepacboc,’ quequin bëyuc tishaidën aton papa chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Adoaquien: ‘Mado, ëbëd icquid mibi nec. Adquid icnuc con natedi mitsana neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Min utsi unësacbimboecboedi nëbi choash tabadoaic. Aidi bënudacbimboecboedi nëbi istuidaid nec,’ quequin aton papan choboedën buchi chuipondash —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Adshumbic, abëd icquido Esusën naden chuipanëdash: —Icbon, Con na dadpen isquid icta, caid icnubi: Mimbi con na ista caidën mitsana uesbudec, quequin utsibon chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Adoac, ambi con na ista caid chomiash icbo nadposh: ‘Mimbi con na ista caidën mitsana uesbudec, quequin chioshi. Adoac, con na isquid mibi ictiapimbo iquec, caimbi. Nëbi ¿Ëmbi tambamboed abitedida iqueque? Con na daëd uata quequin ëmbi meniac mimbi daëd uabanquin dada uaid bec cho. Isnu,’ queposh icbo. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Aden chiac icbon na isquid otacquio onquec: ‘¿Icbon na isquid ictiapimbo yec mitsimbobi tabadpeba? Neshcashunquid ictiapimbo iquebi. Adecbidi, Con na nibëdeque. Bec cho, quetiapimbo icoaibi. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naden natsiambi. Con icbon na meniondaid abitedi cuidmenquio yac ëbi yuedtsiash,’ queposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Aden tantiashun ambi icbon na meniondaid abentse-abentsen chomiac bëyuc choquid chuiquin: ‘¿Tedtsi ëmbi con icbon na meniaqui mimbi cuidenquiocpaccoc?’ caquien: ");
INSERT INTO mcfNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“ ‘Bëchi shocosh nuacquid dapan cushtoaid 15tedi bedshun cuidamboccombi,’ queposh. “Adoaquien: ‘Mimbi 15ted bedombi, quequin dada uaid secashun dada uatempi bedshun shocosh dapa bëchi cushtoaid 7ted bedshun cuidembi, quequin dada uata.’ ");
INSERT INTO mcfNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Aden bëyuc choquid chuishumbic utsi chosho isun: ‘¿Con icbon na tedtsi bedshun cuidenquio mimbi icpo?’ caquien: “ ‘Tsitsan dapa dadpen 1000ted tiedën caniquid ëshë bedombi,’ queposh. “Adoaquien: ‘Mimbi aidted bedombi quequin dada uaid secashun dada uatempi utsin tsitsan dapa dadpen 800ted tiedën caniquid ëshë bedshun cuidembi, quequin dada uata,’ quequin icbon na isquidën chuiposh. Adoac ambi chiacpaden ambi bedaid cuidambocquidën dada uaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","9","“Aden dada uabansho isun dada uatempitedi bedshun icbo yacno nidshun meniac isbanec icbo tantiaquidquio iquec nadposh: ‘Muaquin mimbi dada uamebanquin mibi yuedmetequid con na mimbi aido menioque. Nidec nid,’ caposh icbon —quequin Esusën chuipanëdash. Aden chuishun ambi chuiboed tantiamenuen abi chuibudec: —Nuquin Papa yacno mitsana buantiapimbo icquin nidaidën tabadquin mitsana meniac mimbi meniaidotsen ëbi tantiaquid yanash unësash Nuquin Papa yacno nidshun mibi tsyuec chosho isun ëbëdtambi aidon mibi yuedendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aden chuishumbic adomboembidi chuiquin Esusën nadopanëdash: —Icbon na daëdpactsëc bëdamboen isbanquin nashunquid icquin adembidi icbon na dadpen isbanquin bëdamboen nashunendac. Padnuen, icbon na daëdpactsëc isbanquin icsamboen nashunquid iquin adomboembidi aton na dadpen icsamboen isbanoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Adembidi mimbi nidaidënshun bedquin mimbi icsamboen nabansho isun, ¿Ëbi tantiaquid bëdamboen ista, quequinda Nuquin Papan mibi chuipeba? Padenquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Adembidi, ¿utsin na isquin bëdamboen nashunenquio icsho isun abi yacno chosho isun mibi menependa ictic? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Adecbidi, chuiquid daëd icnuc aid daëdshun namiaidquio ictiapimbo mibi iquec. Abentsëcshun chiaiduidi tantiaquin utsin chiaid mimbi chieshënec. Adquiobidi Nuquin Papa mimbi tantiaidquio icquimbi mitsana bedtequid mimbi tantiaidquio ictiapimbo iquec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aden chuibanubi aton na bedtequid ambi tantiaidquio icnuc chieshec padiseyobo tabadcuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Adec tabadsho isun Esusën: —Bëdamboen nashumbimboen ismequido mibitedi icsho mimbi ompoquin naidtedi Nuquin Papan isquin tantiec. Adembidi, Bëdamboen naquidbimboecsho matsesën ispashuni, quequin tantiaquin nasho Nuquin Papan bëdamboen istiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Adembidi, acten mentoanquid Uan pado tishabicnuc Nuquin Papan naden nata quequin chiaid Moisesën dada uampidbëdta Nuquin Papan chuimiaid utsibon dada uampid mimbi ënden tantiondaid nec. Nuquin Papa yacno puduedmianquid iquec, quequin nëbi chiaid utsi nec. Ad icnuc Nuquin Papa yacno puduedmianquid tantianu, quenquio yec ambibi tantiacpadec puduedte bunec. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Abubëd nidaid ënëdtequid icnuc Nuquin Papan naden nata quequin chiaid ënëdtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ad icnuc, aton chido bunenquiocquin aid nianshun chido utsi bedquin Nuquin Papan chiaid niacquid nec. Adembidi aton bënë niamboed chido bedquid Nuquin Papan chiaid niacquid neoaic —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Adequi onquequimbi utsi chiacbimboen Esusën naden chuipanëdash: —Dada, aton na dadpen icquid bëdaidquio dasiuidquidën badiadquidën-badiadquidënquien nua peshun acposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Adnubien aton na dadpen icquidën shubu dayun bëshun tsadunac aton na nibëdquid, Dasado cuëmëdquid, chiuë dadpen icquid tsadposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bunquiec ambo tsadec aton na dadpen icquidën peshun secaid bedshun penuec tsadtsëcsho menenquiocposh. Aden menenquiocnoc tsadshobi opa choquin aton chiuë bëtashuntuidposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Adnubien, aton na nibëdquid Dasado unëso isun Nuquin Papan uaido mayan bëdabon abuc buanshun Abadauanën dayunquio tsadumposh. Adoambic, aton na dadpen icquidtsen unësashi ");
INSERT INTO mcfNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","chian anëdënquiacnoshon mëyanaid icquin abucquio isquien aton na nibëdquid unësboedi Dasado Abadauanën dayunquio tsadpec. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Adec aid daëdi tsadsho isun aton na dadpen icboedën Abadauan chuiquin: ‘Ëbi antauideque. Con ana dauebudoaquin ëbi ëcpanun Dasado acte bëme, papa,’ caposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Adoaquien: ‘Chuinu. Tantia, abuido. Ënden nidaidën tabadquin mitsana dadpen bedbanec bëdambo mibi tabadnubien Dasado comapenec bunquiec tsadposh. Nëbi aidi ënabi bëdamboec tabadnubien anchumbo yec mibi tënquebudec. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Adboedi, uquëmbo mibi iquec cuëma utsiuc potetemaid icnuc nëuëshquio nidtiapimbo iquec. Adquiobidi mibi yacnocquido nëmbo chotiapimbo icoaic,’ quequin Abadauanën aton na dadpen icboed chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Adoaquien: ‘Ëbi yacno potetemaid icnuc con pan shubu yacno Dasado nidme. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Con buchi ado mëdante auc abentsëc 5tedi unësabi yec nidaidëmbi tabadeque. Con buchi ado nëmbo mëyanacno chonoshe queshun Dasado aido chuimetanta, papa,’ queposh aton na dadpen icboed. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Adoaquien: ‘Nuquin Papan chiaid, Moisesën dada uampidbëdta dada uaid utsi isec tsusiobo onquepayoc. Aden chiaid ma min buchi adon tantiaquiopanuna,’ quequin Abadauanën chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Adoaquien: ‘Aid tantienquioctsiash, papa. Unësboed nidshun chiac aidon tantiapatsiash,’ quequin aton na dadpen icboedën chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Adoaquien: ‘Padicnuna. Nuquin Papa tantiesa icquin uincuemiaidën chiaid min utsibon tantienquio icpatsiash,’ caposh Abadauanën aton na dadpen icboed chuiquin —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aden chuishumbic abëd icquido Esusën nadopanëdash: —Icsa uanquid iquendac. Adquid Nuquin Papan comapenen cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Adquid ëbi tantiabenabicquid icsa uanabicsho cuënote yuëmbocquid tëtanetanquin acte shodomboshë yacno nënepatecnëdan. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aid tantiec aidpadquid icmane quequin bëdamboec tabadquin ismedeneta. “Utsi icsasho isun: ‘Mibi icsaique. Mibi icsaid ënta,’ mimbi cac: ‘Ai, icsaobique. Ënëdnuna,’ quesho tantiash aidi icsainquio yacbimboec bëpiscudta. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mibi icsamboen nash choec: ‘Icsaobique. Ënëdnuna,’ quenuc mibi icsamboen nacmaidbimboec yec bëpiscudta. Mibi padpiden icsamboen nash choaic: ‘Icsaobique. Ënëdnuna,’ queoanuc mibi icsamboen nacmaidbimboec yec bëpiscudoata. Mibi padpiden icsamboen nash padpidec choec: ‘Icsaobique. Ënu,’ queoanuc aidtedecbidi aidi icsambo yenquio yacbimboec bëpiscudoata —capanëdash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Adoaquien: —Nuquin Papa nadatiambocquin nabanquidquio nec, quequin tantiaquidquio ictiadquio iquebique. Adquid ëbi icme, icbo —capanëdash abëd icquidon Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Adoaquien: —Cuëtempi ëshë mostasa caid pistsëcquio iquec. Siac dëyucash nua yanec. Adecbidi Nuquin Papa nadatiambocquin nabanquid iquec quequin mimbi bëdiactsëc tantiapec. Aden bëdiactsëc tantiaquin Nuquin Papan nadatiambocquin naban-nabansho isun, Nuquin Papa nadatiambocquin nabanquidquio iquec, quequin tantiabenshun nëid cuëtempi caic, Cuëte mananuc tabadboedi adquiecbidi acte nantan tabadoata, quequin mimbi chiacpadec acte nantantsen abi tabadacpadecbidi tabadoaindac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aden chiashic Esus abi onquec: —¿Min yua mimbi neshcata cac nidshun neshcaquin nainash shubuno chosho isun: “Nëmbo tsadquin pec cho,” caquinda mimbi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Padenquio. “Con pete codocashun ëbi pemeshun acte menetanquin mimbitsen peshun acta,” mimbi caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aden mimbi chiac mimbi chuiboedtedictsëqui nabanquin mimbi yuaidën naimbudec. Aden naimbudsho isash: “¿Bëdamboen mimbi naoc,” quecta mibi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Padenquio. Ambembi nainquio iccosh. Mimbi chiacpaden min yuan nabanosh. Adembidi Nuquin Papan chuiboedtedtsëqui nabanash Nuquin Icbo caic: “Mimbi chuiboedtedi nabampombi. Mimbi namiaid icquin ëmbi naboed ëmbi natequiduidi napombi,” quequin mimbi chuite nendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Adashic, Edusaden yacno nidequi nidaid Cadidia caid ënëdacno nidaid Samadia caid yacno datambëtsenec ");
INSERT INTO mcfNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","shubu daëdpactsëc yacno Esus chopanëdash. Ambo choshobien daushumbocquidon 10tedishun Esus bëquedtuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Adquido yec uano tabadquin: —Ëbitedi bëdamboen tantiaquin nadatiambocquin naban, icbo —cabededpanëdash comapenen cuënquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Adsho tantiashun Esusën: —Isadaidbo tsusiobo yacno nidshun ismetanta —capanëdash. Adoac nidanequi abitedi bëdambudnepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Adoac bëdamboed abentsëc dëbidiadanec Nuquin Papan naid chiec onquec choaic ");
INSERT INTO mcfNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Esusën taëno tsadbudash: —Mimbi bëdameboc bëdambo iquebi —quepanëdash Esus caic. Aidi Samadia yacnocquid isadaidpembo nepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Adoaquien: —¿Diestedidambi bëdamepo? —quepanëdash Esus dëbidiadanec choboed caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aden chiashic iccuededquidtedi caic: —Nëidi isadaidpembo yequi dëbidiadanec choash Nuquin Papan naid chiec onquenubi ambi chiacpadomboen bëdameboed utsibo isadaidbo icquimbi Nuquin Papan naid chienquio icpec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aden chuishumbic: —Mimbi tantiacpadequi mibi bëdanoque. Nidtoanec nid —capanëdash Esusën daushumbo icboedi chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Adshumbic: —¿Chuiquid dapa abentsëcbëd bëdamboec tabadte ushë choaid mitsipadënquio nuqui ispeque? Tantianu. Ëbi chui —capanëdash padiseyobon Esus chuiquin. Adoaquien: —Chuiquid dapabëd bëdamboec tabadte ushë chote ismete nibëdendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Adecbidi, nëmbobi chuiquid dapa abentsëc choeque. Is, quetiapimbo matses icpec. Adecbidi, Umbo choeque. Is, quetiapimbo matses icoaic. Chuiquid dapa abentsëcbëd tabadte nëmbobi iquec caimbi —quepanëdash Esus padiseyobo abi chuimeboedo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aden padiseyobo chuishumbic abëd icquido Esusën nadopanëdash: —Yuecash natiamiantequid icnuc abuc Esusbëd tabadte ushë chopashun, quec ëbi iste mibi bunquimbi ëbi isenquio mimbi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Adec ëbi iste bunubien: “Bëdamboec tabadte chuiquid ambo choshe. Istan,” cac abëdi nidenda. Adembidi: “Nëmbobi choshe. Isnu. Cho,” cac istanenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nuquin Papa yacno bëdamboec tabadte ushë chonoc abu bedquetaniacbimboec uëshëmbo chënquec ëbi chosho abitedishun isbededendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aid ushë choabicnuc ëbi natiametequid iquendac. Adembidi, chuiquid dapa nec cainquiocquin ëbi isadaidbon chieshëmbededec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aden chiec Esus abi onquec: —Ëndenquimboshë Noe tabadnuc matsesën icsamboen tantiaded-tantiadednëdacpadomboen ëbi choate ushë icnuc adembidi matsesën tantiadenepec. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nadec tabadpampic: Nuquin Papan chiaid tantiesa cuidte ushë choec, quenquiocquin abi bunaiduidtsëqui tantiaquin nua peshun nua acbededpampic. Adembidi tantiaquin aton chido bedpampic. Adembidi tantiaquin aton champi menepampic. Aden tantiaquin nabanubien Noebëd icquido cano dapan puduedambic nua mauantequid ue dapambo sequenuc cubudquin Nuquin Papan chiaid tantiesabotedi acte mauanquin mabocac abitedi unësbunepampic —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Adec Noe tabadnuc icsamboen tantiec matses tabadaid chiashic, Esus nadpanëdash: —Adecbidi Dod caid icnuc icsamboen tantiec matses tabadpampic. Nuquin Papan chiaid tantiesa iquec abi bunaiduidtsëqui tantiaquid icoapampic. Nidaidën tabadaiduidquio tantiaquin nua peshun nua actenepampic. Adembidi tantiaquin aton na dadpen bedtenepampic. Adembidi tantiaquin aton tied nitsindenequinc, shubu uadenequinc, caquin napampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aden nabanquin Nuquin Papan chiaid tantienquio icnubi shubu dadpen icquid Sodoma caid yacnoshon Nuquin Papan abi tantiaquid Dod cuemepampic. Adnubien tabote dëpesh pasquiacbimboecquid nëdënquetequid ue sequiacbimboec sequequidën Sodoma yacnocquidtedi Nuquin Papan chiaid tantiesabo unës uabunepampic —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aden chiashic: —Ëbi choate ushë icnuc ëmbi chuibocpadquiec Nuquin Papan chiaid tantiesa yec abi bunaiduidtsëqui tantiaquid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Shubu macano yacno dectatoash mibi tsadnuc ëbi choate ushë chosho isash budanec mitsana bednu quec shubuno puduedenquio yec cuenta. Adecbidi, tied nantan mibi icnuc aid ushë chosho isash shubu yacno mitsana bednuec nidenquio yec badedquio cuenta. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mibi yacnocquidtedi unës uanushe bidiadshun isenquio yec cuenta, cac Dod cuenubien aton na tantiec aton chido aucbidi bidiadsho unës uampidpadquid iquenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Unësmane queshun ambi tantiacpadec tabadquid unësash mëyanacno tabadnubien unësmane quenquiocquin Nuquin Papa yacno tabadte tantiaquin chuiquido unësash Nuquin Papa yacnombo tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ëbi choate ushë icnuc nad iquendac: Inchëshën daëd usho Nuquin Papa yacno yuednuen abi tantiaquid bedquin abi tantiesa nianendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Adembidi, chido daëdshun macueso Nuquin Papa yacno yuednuen abi tantiaquid bedquin abi tantiesa nianoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Adembidi, dada daëd aton tied nantan icsho Nuquin Papa yacno yuednuen abi tantiaquid bedquin abi tantiesa nianoaindac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aden chuisho bëdamboen tantienquiocquin abëd icquidon: —¿Mitsimbo budpec, icbo? —capanëdash. Adoaquien: —Unësaid yacno edeste bud-budec. Adquiecbidi Nuquin Papan chiaid tantiesa abi bunaiduidtsëqui tantiaquid yacno abi cuidtequid budendac —quepanëdash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Adashic, Ëbëd icquido chieshenquio yec Nuquin Papa chiec onquian-onquianquidquio ma icpanu quec aido tantiamenu quec Esus nadpanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Shubu dadpen yacno icsambocquid cuidte chuiquid icposh. Aidi Nuquin Papan chiaidbëdta utsibo tantiesa icposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Adnubien uano tabadquid niante chido icposh. Aidi icsambocquid cuidte chuiquid yacno nidshun: ‘Ëbi icsamboen naquid ma cuidnu chuiquiota,’ quequin chuiposh. Aden chiaqui padenquiocsho isash choded-chodedquin adomboenuidi chuided-chuidedposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Aden chuidoniaqui abi icsambocquin naquid cuidte chienquiocboedëmbi chido ënëdenquio yec ");
INSERT INTO mcfNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","choded-chodedquin adomboembidi chuioasho tantiashun: ‘Nuquin Papabëdta matses tantiesa nebi, quequimbi niante ënëdenquio yec chodednesho isun uimabudmane queshun abi icsamboen naquid cuidte chuiquiono,’ queshun cuidte chuiquidën chuiquioposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aden chiashic Esus: —Choded-chodedquin chidon chuioasho tantiash: “Mibi icsamboen naquid cuidte chuinu,” queposh icsambocquid cuidte chuiquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Adomboembidi ambi cuënaidon, Ëbi chieshënquid cuidta, quequin chuidoniac, Cuidnu, quenquioda Nuquin Papa icpec? Ai, adendac. ¿Nëbimbobida cuidpeba? ");
INSERT INTO mcfNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Abitedi padenquioctsiash. Utsi nëbimbobi cuidenquiocquin choshon cuidendac. Badedquio cuidenquiocsho isash choquin ¿tedectsishumbimbi ëbi tantiaquin caimbudnequido istuidpendac? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Adashic, bëdambocquid nebi, quiash utsitedi icsambo iquec, quequido tantiamenuen adquidën tantiaid icsa chuiquin Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Nuquin Papa tabadte shubu uashunaid yacno Nuquin Papa chiec onquenuec nidnuequid daëd icposh. Abentsëc padiseyobo icnubi ancanquidën utsin na bedmianiaid utsi icposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nuquin Papa tabadte shubu uashunaid yacno abi daëdi choash puduedash uano nidtuidshun padiseyobon ambi tantiacpaden naden Nuquin Papa chuiposh: Bëdambocquid nebi, Papa. Ampequido utsibo icnubi icsamboen nabanquido utsibo icnubi aton chidopen chudquido utsibo nec. Adoesambo nebi. Adecbidi, choboed, ancanquidën utsin na bedtequid bedmianiaidpadquidpenquio nebi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Adembidi, chonoadtemaid ushë yambi chonoadtemaid ushë utsi choabicnuc daëdec ushquin mibi tantiaquin buna mëmundenembi. Adembidi, uno bedanquin dies yacno cuëscaquin con na tambanshun 9ted dayun uaquin abentsëc mibi menedenembi, Papa, quequin padiseyobon chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Aden padiseyobon uanoshon chuinubien ancanquidën utsin na bedtequid bedmianiaid puduedash nidtuidash: ‘Icsambocquid nebi, Papa.’ Adquid nebi quequin ismec shuebudacchobi abuc Nuquin Papa yacno isenquio yec abi onquec: ‘Icsambocquin nabanquid nebique. Ëbi tantiaquin pauc, Papa,’ queposh —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aden chiashic: —Chuinu. Tantia. Ancanquidën utsin na bedtequid bedmianiaid Nuquin Papan bëdamboen isaidquio icnubien padiseyobo ambi icsamboen isaidquio icposh. Icsaisa yacbimboec, Bëdambocquid nebi, quequid yuecshun Nuquin Papan aidën icsamboen tantiaid ismequin chiendac. Padnuen, icsambocquid nebi, quequin tantiaquid yuecshun ambi bëdamboen naid Nuquin Papan ismequin chuioaindac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Adshumbic, aton bacuëbo Esus mishmenuequin utsin-utsinquien bë-bësho isun: —Bacuëbo bë-bëenda. Esusën nabanaid utsi iqueque. Nidanec nid —capanëdash Esusbëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aden chuisho tantiash Esus nadpanëdash: —Bacuëbo nidmenquiocquin con dayunquio cho-chome. Chiac, Abimbo caic, quequin tantiaquidquio bacuëbo nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Adomboembidi, Nuquin Papa yacno tabadte iquec, quequin chiac bacuëbon badedquio tantiacpadomboen tantiec Nuquin Papa yacno puduedtequid iquendac. Aden tantiesa ambo puduedtemaid iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Adshumbic, nëbi chuiquid caniquidën: —Nuquin Papa yacno nidnuequin ¿atotsimbi nape? Bëdamboen tantiaquidquio icquin ëbi chui. Tantianu —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Adoaquien: —¿Mitsipaden tantiec bëdambocquid nec, quepe mibi? Nuquin Papauidtsëqui bëdambocquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Abi yacno nidnuequin ambi naden nata quequin chiaid naden mimbi tantiapec: “Mimbi inacmaid chudenda; ambi chiaid utsibic, cuesunianenda; utsibic, utsi mua uaquin chienda; utsibic, papan chiaidbëdta titan chiaid tantiaquin nabanta,” quequin chiampid mimbi tantiapec —capanëdash Esusën nëbi chuiquid caniquid chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Adoaquien: —Canidotsëcquimbi aden nadeniondambi —quepanëdash nëbi caniquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aden chuisho tantiash: —Abentsëc mimbi nabicquid iqueque. Mitsanatedi menequin bedtequid bedbanshun aton na nibëdquid menebanta. Aden mimbi menebanac ëbi tantiaquid dadpen yanash Nuquin Papa yacno nidendac. Aden meniash ëbëd iquec chota —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aden Esusën chuisho tantiash aton na dadpen tantiec unësquio yanshun Esusën chiacpaden natiapimbo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Adsho isun: —Aton na dadpen tantiaquin Nuquin Papa badedquio tantiatiapimbo adquidën iquec. Nuquin Papa tantienquio yec abi yacno puduedtiapimbocquid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adquiecbidi shëcuë pistsëcquid puduedte nidaidën capuquid dapan badedquio tantiatiapimbo iquec. Tantiamiac puduedec. Adembidi Nuquin Papan shubu abentsëquën puduedmianquid icsho aton na dadpen icquidën badedquio tantiatiapimbo icoaic. Aden aid tantiatiapimbocquid ambibi tantiacpadequi puduedte bunec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aden chuisho tantiash iccuededquido nadpanëdash: —¿Tsutsi Nuquin Papa yacno puduedquid icpec? —quepanëdash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Adoaquien: —Matses ambibi tantiacpadec puduedtiapimbocnoc Nuquin Papambien abi yacno yuedanquid matses tantiamendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Adoaquien Petedo: —Mibëd icnu, quequin ëbëd icquidbëdtan con natedi nianondambi, icbo —quepanëdash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Adoaquien: —Abimbo mimbi chioque. Tantiata. Chuinu. Nuquin Papabëd shubu abentsëquën tabadaid chuibanuequin aton shubu icnuc aton chidobëdta aton bacuëbo nianacsho ");
INSERT INTO mcfNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ambi nianaidtedimbo tambanquin daëd uabanquin Nuquin Papan nëbi bëdambo icmeshumbi abi yacno nidacsho bëdamboshë icmiaid mibi iquendac —quepanëdash Esus Petedo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Adashic, abëd icquido uano buanash: —Edusaden yacno nuquibi nidoaic. Ambo choacsho Nuquin Papan ëbi chuiquin dada uamiampicpaden icsambocquin ëbi nabanendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Anoshon bedshun buanshun isadaidbon isadaidpembo ëbi menendac. Aden meniac bedshun ëbi mamënshumbededquimbi, icsamboen chuibededquimbi, dacuishtuabededquimbi, dacuesbededtsëcquien mëyanshun ëbi cuesten dectanquin unës uaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Adoaqui daëdec ushtanec uincuenendabi —quepanëdash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aden abi unëste Esusën chuisho abëd icquidon bëdamboen tantienquio yec tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Adashic, Edusaden yacmi nidequi Edico caid shubu dadpen yacno anoentsëqui Esus chonobien podqued cuëmambi bëshuaid tsadpanëdash. Matses cuensho tantiash: “Mitsana bedtequid bec cho,” quepanëdash bëshuaid. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Adec tsadquimbi matses dadpen cuen-cuensho tantiashun: —¿Atotsi quec cuen-cuene? —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Adoaquien choquid abentsëc: —Nasaded yacnoësh choquid Esus cuenec nec —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Adsho tantiashun bëshuaidën: —Dabid, tsusedpan mado mibi icquin ëbi tantiaquin nata —capanëdash Esus cuënquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Adshobien: —Adec cuëdenquio yec tsad —capanëdash choquidon. Adoaquien bëdiactsëc cuëmboedëmbi comapenquien: —Tsusedpa Dabidën mado mibi icquin ëbi tantiaquin nashunta —caoapanëdash bëshuaidën. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Adoac nidtuidshun Esusën: —Aidi bec cho —cac abi yacno bësho isun: ");
INSERT INTO mcfNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Atotsimbi mibi nashumpeba? —capanëdash Esusën bëshuaid chuiquin. Adoaquien: —Bëshuaid nebique. Ëbi bëucshune, Icbo —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Adoaquien: —Mimbi tantiacpadomboen padpidemboen is —cac ");
INSERT INTO mcfNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","badedquio isbenshun bëshuacboedën Esus tsibanquimbi Nuquin Papan naid chuibanquin isbanec onquec nidpanëdash. Aid bëdansho isun Esusbëd nidanequidotedishuntsen Nuquin Papan naid chuibededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Adec nidequi Edico caid yacno datambidanec Esus nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Edico yacnocquid Saqueyo cuëmëdquid icpanëdash. Aidi ancanquidën utsin na bedtequid bedmianiaid dapa iquec aton na dadpen icquid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Adoaid icquimbi utsi, Esus cuenec, quesho tantiash, ¿Mitsipadquidquio Esus neque? Isnu, abibi quianec nidquimbi matses ënapen icquid dadpen Esus datsidadacsho bushcuctsëcquid icquin Esus Saqueyon isenquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Adash, Nëid podquedën Esus choec, quianec podqued cuëman nidquidën cuëte dapan dectatoash isec cuidin tsadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Adec tsadnubien aid podquedënquio choec nidtuidshun Saqueyo bushcuctsëcquid istuidshun Esusën: —Nëbi mibi yacno nuquibi tabadec nidnu. Baded bud —cac ");
INSERT INTO mcfNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Saqueyo badedi budpanëdash. Budanec nidquin Esus buanec aton shubuno choshon: —Mibi ëbëd icte bunsho isash bëdambo iquebique. Pudued —Saqueyon cac Esus puduedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Adec puduedsho isash Esus tsibananquido: —Icsaquidën shubun Esus puduedosh —quecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Adnubien, aton shubu nuntanuësh nidtoash Saqueyo: —Chuinu. Tantia, Icbo. Nëbi con na mais uaquin aton na nibëdquid menenun nabono. Adoshombic, con matses: “Con na mimbi ampioc,” quesho tantiashun ëmbi ampiaidbëdta daëd-daëdquiecnuc daëd uaquin menebanembi —quepanëdash Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Adoaquien: —Chian anëdënquequid nësiatsemboedi aton tsusedpa Abadauan yanampicpaden tantiaquid Saqueyo yanacsho nëbi mënchicaid iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Icsambocquid Saqueyo icbocpadquid nibënquin istuidshun nësecanushe queshun mënchicnuec chopobi —quepanëdash Esus Saqueyobëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aden Esusën chuisho tantiashun Edusaden yacno choash chuiquid dapa Esus yantsiash, quequin utsibon icsamboen tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aden tantianubi tantiaquidquio icquin utsi chiacbimboen aido tantiamenuen Esusën nadopanëdash: —Chuiquid dapan mado: ‘Ënden caniaid iquebique. Nëbi ëbitsen chuiquid icnuec chuiquid dapa yacno nidaid utsi yacno nidendabi. Anoshon chuiquid icmiac nëmbo choaindabi,’ ");
INSERT INTO mcfNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","queshun ambi namiaido 10ted icquido chomeshun aton na bedtequid abentse-abentsen menebamposh. Aden menebanash: ‘Ëbi nidan ëmbi meneboed bëdamboen nabanquin daëd uata ma choshon dadpen bedoapanuna,’ quianec chuiquid ictiadquiocquid abi chuiquid dapa yacno nidposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Adec aid nidambic abi yacnocquidon abi chieshënquido nadposh: ‘Aidi ëbitedi chuiquid icmenushe queshun chuiquid dapa yacno chuitanta,’ queshun abëd icquido chuimenuen chuiquid dapa yacno nidmeposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Adoaqui, Chuiquid icnu, quianec nidboed chuiquid icmeposh. Aden chuiquid icmiac aton shubuno choash, Con na bedtequid ¿tedtsi daëd uapashba? abibi queshun ambi meneboedo chomeposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Adoac bëyuc choquid: ‘Mitsana bedtequid abentsëc icboedi utsi 10ted icnuc daëd uaombi, icbo,’ queposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Adoaquien: ‘Ëmbi meneboed abentsëc bedshun bëdamboen mimbi daëd uaque. Nëbi mimbi daëd uaidtedquiobi shubu dadpen icquid 10ted uano-uanoecquido chuiquid icta,’ caposh abi chuiquidën. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Adnubien utsi: ‘Mitsana bedtequid abentsëc icboedi utsi 5ted daëd uapombi,’ queposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Adoaquien: ‘Mimbi daëd uaidtedquiobi shubu dadpen icquid 5ted uano-uanoecquido chuiquid icta,’ caposh abi chuiquidën. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Adnubien utsitsen: ‘Mimbi abentsëc menetsëcboed ëmbi dashcute cuëshaidën dayun uaboed në iquec, icbo. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mitsana bedtequid mimbi tantiactedimbo daëd uatiapimbo ictsiabi, queshun dayun uaombi. Utsin na utsin nitsinaidbidi bedbanquid mibi icsho isash chushcanushe quiash dacuëdec tsadteniobi,’ queposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Adoaquien: ‘Ëmbi chiaid niacquid mibi neyoc. Mimbi mua uaquin chiaidtedimbocsho mibi cuidtequid iquendac. ¿Utsin na utsin nitsinaidbidi bedbanquid mibi icsho isombi, ëbi chiec quecta icco? ");
INSERT INTO mcfNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Aden tantiaquin atotsieshun ëmbi chiaid nanuequin ëmbi meneboed daëd uamequin utsi menenquio icco? Aden meniac daëd uashun bedtsenombi,’ queposh abi chuiquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Aden aton na daëd uaisa chuishumbic iccuededquido chuiquin: ‘Ëbi chieshënquin con na daëd uainquiocquin ambi dayun uaboed bedshun ëmbi abentsëc meniaid 10ted icnuc daëd uaboed meneta,’ caposh abi chuiquidën. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Adoaquien: ‘Aton na dadpen iqueque. Aid menenda, chuiquid,’ queposh iccuededquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Adoaquien: ‘Chuinu. Tantia. Ëmbi chiacpaden nabanquin daëd uacsho isun ëmbi meneboed daëd uaquin menembi. Ëmbi chiacpaden chieshquin daëd uainquiocsho isun ëmbi meneboed bedshunembi. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Adembidi ëbi chieshënec abi chuiquid dapa ëbi icmete bunesabo nëmbo bec cho. Bëshun ëmbi isnubi abitedi cuesuneta,’ caposh abi chuiquidën —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aden chuibanashic Esus Edusaden yacmi nidequi anoentsëqui choash nidtuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Uano macuësh Odibos caid potsembo shubu daëdpactsëc icquid Bedpaque caid icnubi shubu daëdpactsëc icquid utsi Betania caid icpanëdash. Adec nidtuidash abëd icquid daëd caic: ");
INSERT INTO mcfNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Nëid podquedën nidquimbi shubu daëdpactsëc yacno choshon cabayobitsecquidën bacuë caniaid catsadabicquid tënëshaid mimbi istuidendac. Aid istuidshun tënëshaid tëchicshun nëmbo bëta. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aden chicsho isash: “¿Atotsi canun mimbi aid chicpe?” quepec. Adsho tantiashun: “Con Icbo bunaid nec,” quequin chuita —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Adoac nidshun istuidtanquin ");
INSERT INTO mcfNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","cabayobitsecquidëmpi tënëshaid tëchicsho isash: —¿Atotsi canuen aid tëchique? —capanëdash icbon. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Adoaquien: —Con Icbo bunaid nec —queshun Esus yacno nimbanquin abi tënëshaidën buampanëdash Esusbëd icquidon. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aden bëshun, Chuiquid dapa Esus nepanui, quec onqueshun Esusbëd icquidon aton dashcute bëntsecquid chictanquin cabayobitsecquid capucshun Esus catsadumpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aden Esus catsadunash nidnubien iccuededquidontsen aton dashcute bëntsecquid chictanquin podqued ansambanec nidanepanëdash. Chuiquid dapa Esus nepanui, queshun aidontsen adopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Adec nidanec macuësh Odibos caid budtuidequi iccuededquidtedimbo bëdambo iquec comapenen Nuquin Papan nadatiambocquin naid ambi isboed naden chiec comapenec onquecuededpanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Nuquin Papan chomiaid ambi chuiquid dapa icmiaid ambi bëdambo icmiaidquiobidi nec. Nuquin Papa yacno abëdi bëdamboec tabadequi icsaisatedi iquendac —quepanëdash iccuededquido comapenec cuëdcuededec. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Adec cuëdcuededsho tantiashun padiseyobon: —Adec onquenda, quequin mibëd icquido chuita —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Adoaquien: —Ëmbi naid chiec aidtedi cuëdcuededenquiocnoc cuënote podqued cuëman samëdquido onquianendac —quepanëdash Esus padiseyobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Adashic, adanec nidequi Edusaden anoentsëqui choquin anocquido abi tantiesabo tantiec shubiec Esus nadpanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Ëbi bëdambo icmequid Esus nec, quec nëbi ëbi tantiaquid mibi ictsiandac. Tantiesa icquin mibi chuiquid mimbi nibënacpadquid mimbi istuidtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yuecash choquin uimanëmënquidon mibi cuentiapimbocnoc tsicatebudcuenendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aden mibi tsicatebudcuenshun min bacuëbobëdtabi naimbudquin mibi unës uashun nendac. Min shubutedi nibëdquiendac. Nuquin Papan chomiaid ëbi tantiesa icsho cuidtequido mibi nendac —quepanëdash Esus. Edusaden uano icnuc abi tantiesabo tantiec unësquio icnuc anocquido chiacbimboec adpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Adashic, Edusaden yacno choash Nuquin Papa tabadte shubu uashunaidën puduedshun nuntanshunquio aton na bedtequid bednun menebanquido Esusën cuemepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Cuemec: —Nuquin Papan chuipampid nad iqueque. Tantia: “Ëbi tabadte shubu uashunaid ëbi chiec onquianete shubu iquendac,” quepampic. Aden Nuquin Papan chuipampid icnubi ampequido tabadte shubu Nuquin Papa tabadte shubu uashunaid mibitedishun icmebededayoc —quepanëdash Esus aidtedi cuemec. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Adoshombic, badiadquidën-badiadquidënquiec Nuquin Papa tabadte shubu uashunaidën puduedtenequin Nuquin Papan chiaid tantiamenuen Esusën chuibampanëdash. Anoshon chuibansho isun isadaidbo tsusiobon: ¿Mitsipadentsimbi Esus cuesunepeba? quequin caimbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aden caimbededquimbi Esusën chiaid tantianu quec dadpen Esus datsidadacsho isun ashunquio isadaidbon Esus cuesunemenuen bedtiapimbo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Adashic, Nuquin Papa tabadte shubu uashunaidën puduedshun, Nuquin Papa yacno yuedanquid iquec, quequin Esusën chuibanubien isadaidbo tsusiobo cho-chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Cho-choshon: —¿Tsundan chuibanta caid mibi neque? Tantianu. Ëbitedi chui —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Adoaquien: —Ëmbia tantianu. Ëbi chui. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nuquin Papan ëmbi chiaid chuibanshun mentobanta caidta Uan icpondash? Padenquio mibi quenuc, ¿Matsesën nata caidta nepondash, quequinda mimbi tantie? —quepanëdash Esus isadaidbo tsusiobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aden chiac isadaidbo tsusiobo onquecuededec nadpanëdash: —Nuquin Papan nata caid Uan pado nepondash, ëbitedi quesho tantiash Esus nadpendac. ¿Atotsieshun Uanën chuisho mibitedishun tantienquio icponda? ");
INSERT INTO mcfNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Matsesën nata caid Uan pado niondash, ëbitedi quesho tantiashun iccuededquidon cuënoten nuquitedi se-sependac. Nuquin Papan chuimiaid, Uan icpondash, quequin iccuededquidon tantiec —quepanëdash isadaidbo tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Adec onquecuededash: —¿Tsuntsin nata caid Uan pado icpondash? quequin tantiambo iccombi —quepanëdash tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Adoaquien: —Mimbi chienquio yacpadembi ëmbitsen ëbi chuita caquid mibi chienquio icoaimbi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aden isadaidbo tsusiobo chuishumbic, Utsi chuinu, quiacbimboen Esusën nadopanëdash: —Tied icbon aton tied nitsinshun aton tied cuësh-cuëshquin ambi ëbi neshcashunta caidtedi istuidash tied icbo nidposh. Nidaid utsin yuec tabadshumbic: ");
INSERT INTO mcfNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","‘Tiedën caniquid ënden bacuëpash. Ëbi neshcashunquidën musucaid con na bedmenu,’ queshun ambi namiaid aton tied yacno icbon nidmeposh. Nidmiac ambi bedtan caid tied yacno chosho isun cuestanquin tiedën caniquid bacuë ambi musucaid menenquiocquin abi neshcashunquidon icbon chomiaid nidmeoaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Adoshombic, icbon aton tied yacno ambi namiaid utsi nidmeoaposh. Aid chosho isun adembidi cuestanquin icsamboen nashun ambi musucaid menenquiocquin icbo neshcashunquidon aidtsen nidmeoaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Adoshombic, ambi namiaid utsitsen icbon nidmeoaposh. Aidi chosho isun chiuë-chiuëpambocnoc cuestanquin tied tsitsuno icbo neshcashunquidon aidi netamposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Netamboedi nidtoanec icbo yacno choacsho isash: ‘¿Mitsipadentsimbi napeba? Con madombobi ëbi cudasaid con tied yacno nidmembi. Aidi con tied yacno chosho bëdamboen ispec,’ quequin aton mado nidmeposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Aden nidmiac aton mado aton papan tied yacno chosho isash icbo neshcashunquido nadposh: ‘Tied icbo unësan aton natedi bedquid aton mado nepec. Aden bednushe aidi cuesunenuna. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aden cuesunian icbo unësan aton natedi nuquin na ictsiandac,’ quecuededshun tied tsitsuno icbon mado buanshun icbo neshcashunquidon cuesuneposh —quequin chiashic Esus: “ ‘Min mado cuesuniosh,’ quequin utsin chiac ¿atotsi tied icbon napec? ");
INSERT INTO mcfNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Naden napec. Abibi aton tied yacno nidshun abi neshcashunquido cuesuneshun aton tied ambi cuësh-cuëshaid abi neshcashunquid utsibo aton tied yacno tabadmendac —quepanëdash Esus. Adsho tantiash: —Adoenquio icpashun —quepanëdash iccuededquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Adoaquien iccuededquido bëisequi Esus nadpanëdash: —¿Nuquin Papan dada uamiaidën naden chienquioda icpampic? Ai, aidën chuipampid nad iquec: “Shubu uanuequidën isuidaid buintad utsin ambia nitsinaid icposh.” ");
INSERT INTO mcfNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Buintad sec uebudec podquëd-podquëdendac. Adembidi buintad uebudquin matses tish-tishendac. Adembidi, abi yacno puduedmianquid tantiauidquid Nuquin Papan cuëshëdmiac comapenen cuidte yacno tabadendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aden Esusën chuisho tantiash: —Nuqui naid chiacbimboen chiec Esus niosh —quiash isadaidbo tsusiobo Esus bedte buncuededquin iccuededquid dadpen icnuc Esus bedtiapimbo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Adec Esus bedte bunquin isadaidbo tsusiobon ambi Esus ista caido Esus yacno nidmepanëdash. Ambi ista caido, Bëdambocquid nebi, quequin ismiacbimboecquid icsho Esusën chuibanacno tsusiobon nidmepanëdash. Esus yacno nidshun ëmbi ista caidon chuimiac Esusën icsamboen chuitsiash. Aden chuisho isadaidpembo ancaquidën Esus bedpashun, quequin tantiaquin nidmepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aden nidmiac choash Esus ista caid abentsëc: —Mimbi tantiamequin chuibanaid bëdambo iquec, quequin tantiembi, Abitedi Nuquin Papan chiaid abimbo chuibanquid mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Adquid mibi icquin ëbi chui. Tantianu. ¿Ancanquid Sesad cuëmëdquid isadaidpembo icquin ambi piucquid shocoshëmpi bec cho caid isadaidbon menetiadquidida nepec? —quepanëdash isadaidbo tsusiobon ista caid Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aden chuisho tantiashun choboedën icsamboen tantiaid tantiaquin Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Piucquid shocoshëmpi ancanquidën bec cho caid sananquin abuc cadota —cac sananquin abuc cadosho isash: —¿Tsuntsin podo bitsi dada uaid aidën icpec? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Adoaquien: —Ancanquid Sesadën na nec —quepanëdash tsusiobon ista quequin chomiaid. Adoaquien: —Ancanquid, Bec cho, quesho meneta. Nuquin Papan naden nata cac adobanta —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aden chiac, Bëdamboen tantiaquidbimboec onquec, quequin tantiaquin icsamboen chuimetiapimbo yec tsusiobon chomiaid otacquio tabadcuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Adashic, saduseyobo caido yec ");
INSERT INTO mcfNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","unësaid uincuen uate nibëdec quequin chuiquido Esus yacno chopanëdash. Aido choash: —Unësaidën chido bedshun aidën tishmiaid unësaidën bacuëbobimboecquid iquendac, quequin Moisesën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aden Moisesën dada uaid icnuc dada 7ted iccuededposh. Aidted dada icnuc bëyuc tishaidën aton chido bedshun bacuë tishmiabi yec unësposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aton buchi unësan aidën chido bedash adecbidi bacuë tishmiabi yec unësoaposh aton utsi. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Adembidi, bëyuc tishaid tsibanquidën-tsibanquidënquien chido abentsëqui bedto-bedtoec bacuë tishmiabi yec unësbuneposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yuecash chidotsen unësoaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Adec chido abentsëcshun bënë dadpen icboedi uincuen uate ushë icnuc ¿mitsicquid chidon bënë icpeque? Ëbi chui. Tantianu —quepanëdash saduseyobo Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Adoaquien: —Nidaidënshun dadan aton chido bedec. Adecbidi, Min bënëbëd nidta, quequin aton papan chiac aton champi aton bënëbëd nidec. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Uincuen uate ushë choan Nuquin Papan bëdamboen isaido abëdi tabadquin chido bedenquio iquendac. Adembidi, aton champi menenquio aton papan iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Adecbidi, Nuquin Papan uaido mayan bëdabo unësesa yacpadquiequi Nuquin Papan uincuen uatequid unësenquio iquendac. Nuquin Papan uincuen uatequido aton bacuëbo nendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Adembidi chuinu. Tantia. Cuëtempi nëdënquiacbimboecquid isun Moisesën dada uapampid nec. Cuëte nëdënquiacbimboecsho isun Nuquin Papa chuiquin nadopampic: “Tsusedpa Abadauanën papa cain cuënaid mibi nec. Adecbidi tsusedpa Isaquën papa cain cuënaid mibi neoaic. Adecbidi tsusedpa Acobon papa cain cuënaid mibi nec,” quequin Moisesën chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moisesën tsusedpabo ambi chuiboed ënden unësampidën nami chodquiaidën papa cain Nuquin Papa cuëntiapimbo iquec. Aton nami chodquiash abi tantiaquidquio icquin tantiec tsadquidën papa cain Nuquin Papa cuënec —quepanëdash Esus saduseyobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aden Esusën chuisho tantiash Nuquin Papan naden nata quequin chiaid tantiamequid padiseyobo utsi-utsiec nadpanëdash: —Bëdamboen mimbi chuibanoc —quepanëdash Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aden Esusën chuisho tantiashun Esus chuimetiapimbo utsibo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aden utsibon abi icsamboen chuimetiapimbo icsho isun Esusën nadopanëdash: —Ëbi abia yampid icsho ¿mitsipadentsi tantiaquin tsusedpa, Dabidën mado Quidistu caid nec, quequin matsesën chuipec? ");
INSERT INTO mcfNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dabidën ambibi Sadmo caid dada uaquin naden chuipampic: “Icbo utsi yec con mado mibi chiembique. Tantia, quequin chiec icbo dapa nadpampic: ‘Ëquë con dayun abiucquio cainec tsadec cho ");
INSERT INTO mcfNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ma mibi chieshënquidtedi mimbi namiaid ma icpanu,’ ” quequin Nuquin Papan Esus chiaid Moisesën dada uapampid nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aden Dabid padon dada uaquin ¿mitsipadomboentsibi con icbo cashumbi con mado ëbi caoapampic Dabidën? —quepanëdash Esus abi chieshënquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aden chuishun iccuededquidon tantianubi abëd icquido Esusën nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Nuquin Papan naden nata quequin chiaid tantiamequidpadquid iquenda. Aido ancanquidbimboecsho utsibon ispashuni quequin nabanesa dasiuidacpadec dashcute ënapen icquid dasiuidcuededpec. Adomboembidi tantiec matses dadpen iccuededacno nidash capuequi, Ëbi bëquedquidon ëbi chuiquid dapabimboecsho isash onquequin chuipashuni quec tabadec. Adomboembidi tantiec Nuquin Papan chiaid chuibante shubun puduedash, Tsusio dapabimboecsho ispashuni, quec tsusiobo tsadacno tsadtenec. Adomboembidi tantiec, Pec cho cac chosho isash chuiquid dapabimboecsho ispashuni, quec tsusiobo tsadacno tsadtenec. Adquidpadquid iquenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aidon bëdamboen nabanacbimboen nianten natedi bedbanec. Aidombidi Nuquin Papa abimbo tantiacbimboec yuen chiec onquec. Aden bëdamboen nabanacbimboecquido Nuquin Papan comapenen cuidendac. Adoesa bëdiactsëc cuidendac —quepanëdash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Adashic, Nuquin Papa tabadte shubu uashunaid yacno tabadtuidash tsadquin Esusën isbampanëdash. Ambi isaido Nuquin Papa tabadte shubu nacnemete cuidnu, quequin menequin aid shubun shocosh tabëcaidën aton na bedtequid utsin-utsinquien sandobededpanëdash. Aton na bedtequid dadpen icquidon dadpen sandobededsho isquimbi ");
INSERT INTO mcfNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","nianten aton na nibëdquidëmbi aton na bedtequid shocosh daëd ictsëcquid sandosho ispanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Adosho isash: —Chuinu. Tantia. Nianten aton na bedtequid abitedimbo sandoposh. Adosho, Dadpen menequid nec, quequin Nuquin Papan niante isec. Utsibon aton na dadpen abi icnubi dadpen menesho, Daëdpactsëc menequido nec, quequin Nuquin Papan aido isoaic —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Adashic, Nuquin Papa tabadte shubu uashunaidbëdtabi matsesën dectanaid didiquesho isec: —Nuquin Papa tabadte shubu bëdaidquio iquec —quepanëdash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Adoaquien: —Mimbi nëbi isaid yuecash nidbëdquiendac. Matses utsibon nëid shubutedi chic-chicbudendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Adoaquien: —¿Mitsipadën Nuquin Papa tabadte shubu uashunaid chic-chicquin tauapec? ¿Aid ushë anoentsëqui yanuc mitsipadquid ismiante icpeque? Tantianu. Chui —quepanëdash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Adoaquien: —Cho-choshon muaquin chuisho tantienquiocta. Adquid cho-choash: “Nuquin Papan Chomiaid Quidistu nebique. Ëbëd iquec cho,” queded-quededendac. Aden chuiquid tsibanenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Adecbidi: “Cuesnancuededec,” quesho tantiash dacuëdenda. Nuquin Papan chiampicpadequi cuesnancuededteba iquendac. Aid icnubi abitedi naimbudte ushë badedquio choenquio iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aden chiequi abi onquebudec: —Adecbidi, abi ancaquid dapan nidmiac nidaid utsin icquidobëd cuesnancuededendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Adecbidi, nidaid utsi-utsiec yacno canchednuec ishcud-ishcudendac. Adecbidi, utsi-utsiec yacno bunquiote iquendac. Adecbidi, utsi-utsiec yacno daicsabudnete iquendac. Adecbidi, mibi dacuëdmetequid iquendac. Adecbidi, mimbi isacmaid abucuësh natiambo icsho mimbi isbededendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Aidtedi choabicnuc ëbi tantiaquid utsi-utsien bedshun mëyanendac. Adobanshumbic, Icsamboen naquid nec, quequin muaquin icsaquid cuidnuequid yacno mibi buanendac. Utsi-utsien ancanquid yacno buanac ");
INSERT INTO mcfNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","aidotsen tantiaquid yantsiash queshun ëbi chuibanta. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aden buanaqui, ¿atotsimbi ancanquid cape? quequin tantiec tsadenda. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nuquin Papan Mayanën tantiamiacpadomboen mimbi chuibanendac. Adoac, Icsambocquid mibi nec, quetiapimbo mibi chieshënquido iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Adembidi, Nuquin Papan chiaid tantiesan min shubun icquidën mibi bedshun cuidnuequid yacno buanash: ‘Cuidquin cuesuneta,’ quependac. Aton papambi adotsiash. Animbi aton mado adembidi adotsiash. Utsi aton buchimbi adoatsiash. Utsi aton chuchumbi adoatsiash. Utsin abëdtan isedquidëmbi adoatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ëbi tantiaquid chieshënquid dadpen iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Aden nabanquin mibi cuesunemenu, cac chieshenquio yec, Esus tantiaquid nebi, quequid icta. Adquid iquec unësash ënëdenquio yec Nuquin Papabëd mibi tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Adecbidi shubu dadpen icquid Edusaden caid yacno cuesanquid dadpen cho-choshon tsicatebudsho isash, Edusaden yacno naimbudte ushë choec, quequin mimbi tantiendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aden tantiec ma Cadidia yacnocquido macuësh dapa yacno cuempanuna. Adecbidi, Edusaden yanocquido ma auëshquio cuempanuna. Adecbidi, dëuequido Edusaden yacno ma nidenquiocpanuna. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aid ushë icnuc Nuquin Papan chiacpadomboen cuidtequid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aid ushë chonoc matses utsibon Edusaden yacno tsicatebudac pete naimbudnuc bacuë usunquidobëd bacuë chishmequido mëyadec natiaquiendac. Edusaden yacnocquido abi tantiesabo icsho Nuquin Papan natiambocquin cuidte iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Edusaden yacnocquid utsi-utsien chështen cuesendac. Utsi-utsien bedshun nidaid utsi yacno buanshun matses utsibon yuatequido iquendac. Isadaidpembo Edusaden yacno tsicateboedo Edusaden yacno tabadendac. Nuquin Papa, Chën, quenquiocnoc adec tabadendac. Chën, quenuc nidendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Adec Nuquin Papa, Chën, quian badiadën ushë, inchëshën ushë uispa chedo aidtedi ambi nadatiambocquin naid ismiantequid iquendac. Aid ismiante icsho isash, Uinsadpambo iquec, quec comapenec dacuëdec matsestedi tabadcuededendac. Acte natiambo chëuëdsho isash adquiecbidi comapenec dacuëdec matsestedi tabadcuededoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Adecbidi, uispa utsi-utsiec paëdted-paëdtednubi utsi-utsiec tididiquendac. Adsho isash matses dacuëdec padishendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Adnubini Nuquin Papan chomiaid matsesaid ëbi dasiuidaid bëchomauanquiec ushë chënquiacbimboec uëshëmbo yec nadatiambocquin nabanquidquio abu ushun ëbi budsho matsestedishun isbededendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Natiambocquin naid tauadoacsho isun, Nuquin Papa yacno ëbi yuedte ushë chote anoentsëqui yanec, quequin bëdambocquin abuc isteneta —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aden chuishumbic ambi chuiboed ushë chote tantiamenuen nadopanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","—Cuëtempi bacuëacsho isash, Ënden suc seccuduquiac nëbi seta taëec, quequin matsesën tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Adembidi ëmbi chuiboed icsho isun, Nuquin Papabëd tabadte ushë choec, quequin mimbi tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Abimbo chiembique. Tantia. Ëmbi chuibamboed naimbudabicnuc con tan matses isadaidbo naimëdbudenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Abubëdta naimbudtequid nidaid nendac. Ëmbi chiaid abimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Adembidi chuinu. Tantiata. Nidaidën capuquidën, Nëbi ëbi sec, quequin tantienquio yec capusho badedquio siac cuentiapimbo iquec. Adembidi, Natiate ushë choec, quequin tantienquio yec chieshquin badiadquidën-badiadquidënquien paëmbocquid actenepec. Adecbidi aton na bednuec abi buntequiduidi tantiec tabadpec. Adobanubien aid ushë choendac. ¿Matsestedi cuidte ushë choenda ictic? Ai, aid ushë choendac, quequin caimbudec bëdamboec tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ënenquiocquin aid ushë chote caimbunec tabadquin Nuquin Papa naden chuidoneta. Chieshmane mibi tantiaquidquio ëbi icme, Papa. Adembidi natiambocquin cuidte ushë chonoshe queshun ëbi mënchicta, Papa. Aid ushë chonoc ëbi bedshun mimbi chomiac matsesaidën dayun tsadquidquio ëbi icmeta, Papa, quec onquedeneta —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aden chuishumbic, badiadquidën-badiadquidënquien Nuquin Papa tabadte shubu uashunaid yacno nidshun matses tantiamenuen Esusën chuided-chuidedpanëdash. Adecbidi inchëshquidën-inchëshquidënquiec macuësh Odibos caid yacno nidash tabadtenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Adembidi, badiadquidën-badiadquidënquien Esusën chuibansho tantianuequido Nuquin Papa tabadte shubu uashunaid yacno choded-chodedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Adashic, nami uabicquid pete tantiate ushë, Pascuas caid, anoentsëqui yampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aid ushë choabicnuc isadaidbo tsusiobobëd Nuquin Papan naden nata quequin chiaid utsibo tantiamequido iccuededtenequin, ¿Mitsipaden Esus bedshun cuesuneque? Isnu, quequin isted-istedpanëdash. Aden isted-istedtanquin Esus tantiec datsidquido dadpen icsho isash dacuëdquin Esus bedenquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Adnubien Udas cashumbic Iscadiote caid Esusbëd icquid dapuduedshun Satanasën tantiamiac ");
INSERT INTO mcfNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Esus chieshënquid yampanëdash. Adquid yanash padiseyobo tsusiobo yec isadaidbo tsusio utsibo yec Nuquin Papa tabadte shubu uashunaid isquido yec quec Esus chieshënquid utsibo iquec quianec aido yacno Udas choash, Esus bedmete bunebi, quequin chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aden chiac isadaidbo tsusiobo bëdambo iquebi quetanquin: —Esus bedmiacsho mibi piucquid menenu —capanëdash Udas chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Adoaquien: —Adonuna —quianec Esus yacno nidoash abëd capuquimbi Esus tantiec datsidquido nibëdacnoshon abi chieshënquido, isadaidbo tsusiobo, Esus bedmembi, quequin isted-istedpanëdash Udasën. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Adnubien, nami uabicquid pete tantiate ushë chopanëdash. Aid ushën isadaidbon bëyuc tishaid bacuë unës uanushe queshun obeca bacuëded cuesuneshun shubu shëcuë ëcnoshcaid isun unës uainquiocquin Nuquin Papan uaido mayan bëdabon matanampid tantiate ushë icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aid ushë chonoc Uambëdta Petedo chuiquin: —Matante ushë tantianuequin obeca bacuë cuesuniaid penun nacnenta —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Adoaquien: —¿Mitsishumbimbi aid nacnempe? —quepanëdash Uambëd Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Adoaquien: —Nëbi shubu daëdpactsëc yacno nidshun matsun acte bëquid dada mimbi bëquedendac. Aid bëquedshun tsibananec shubun aid puduedacno nidshun ");
INSERT INTO mcfNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","shubun puduedabi naden shubu icbo chuita: ¿Mitsishumbimbi matante ushë tantiaquin ëbëd icquidobëdtan pepe? quiosh Esus, quequin chuita. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aden chiac abuc dectatoshon abuc quënëcquid mibi aidëmbi ismendac. Ashunquio penun nacnenta —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aden Esusën chiac nidaneshun Esusën chiacpadomboen istuidshun matamepampid ushë tantiaquin penun Uambëdtambi Petedon nacnempanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Adashic, inchëshën choash abëd icquidobëd pete sante cueste dayun uequi Esus: ");
INSERT INTO mcfNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—Ëbi mëyante yanabicnuc bëyuc tishaid cuesunianquidën cuesunenquiocquin matanampid tantiaquin pec mibëdi tabadtiadquio yanobi. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Matanampid tantiaquin obeca cuesuneshun nuqui pebocpadomboen mibëdtambi nidaidënshun padpiden penquio iquendambi. Matses icsaquid icsho cuidnushe queshun obecaded cuesuniaidpadquiocquid yanshun Nuquin Papa yacno choash tabadquidobëdtambi ashunquio pendambi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Adoshombic dëshote sananec Nuquin Papa chiec onqueshun actanquin abëd icquido menec: —Në, aniactse-aniactsen acban mibitedishun. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tiedën caniquid ënë nidaidënshun padpiden aquenquio iquendambi. Nuquin Papa yacno choash tabadquidobëdtambi ashunquio aquendambi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Adoshombic, pete bedshun Nuquin Papa chiec onqueshun cuësh-cuështanquin menebanquin: —Mibi icsaid bedshunacsho ëbided cuidquin mëyanquin cuesuniaid tantiaquin pebeded —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Adoshombic pete utsi petanquin dëshoten sicaid cushtoshon menec: —Ënden, Icsambocquin naombi, queshun obecaded cuesunemenuen isadaidbon menedeniac. Aden cuesuniaidën intac siquec unëso isun, Obeca cuesuneboed ëbi icsaquid icsho cuidnushe queshun cuidtequid nec, quiampicpaden abi chiec. Padnuen nëbi unës uashun siac aton intac siquec matses icsaid bedshunash Esusded cuidadac, quequin tantiatequidquio nendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ëbi chieshënquido ëbi bedmenuequin chuiquid pete sante dayun ëbëdi uec. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nuquin Papan chiampicpaden ëbi matsesacsho unës uaid iquendac. Ëbi chieshënquido bedmenuequin chuiquid comapenen cuidte iquendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aden Esusën chuisho tantiash abëd icquido: —¿Midacquidien capec? —quecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Adashic: —Doseted nuqui iquec. ¿Tsudain chuiquid icpec? quequin utsibon ispec —quepanëdash Esusbëd icquido. Aden chuitanec, Chuiquid nec, quequin utsibon ëbi ispec, Esusbëd abitedi nëishash comapenec chushcanampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Adec chushcanansho tantiash Esus nadpanëdash: —Isadaidpembo ancaquidën comapenen aton matses namebanquin daëdpactsëc menebanec. Aden meneshun, Ëmbi namiaido bëdambo icmequid nebi, quequin muaquin chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mibitedi adquid iquenda. Nadquidquio icta. Chuiquid nebi, quec tsyuec caniquidbimboecquid icta. Chuiquid icquin utsi namiacpaden nabanta. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Abi pemequid abi nashunquid nec. Adembidi pec tsadquid utsibo chuiquid nec, quequin utsibon ispec. Aden tantienda. Nëbi mibëdi pec tsadequi mibi nashunquid nebi. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ëbi chieshënquido icnuc ëbi nianesa ");
INSERT INTO mcfNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","icsho con Pan ëbi chuiquid icmiacpadquid chuiquid mibitedi icmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Aden chuiquid icmiac ëbëd icquin ëbëdtambi peshun aquec mibitedi tabadendac. Chuiquid icquin abuc tsadte icquidën tsadquin isadaidbon naid bëdabëdta ambi naid icsa cuidte ëbëdtambi mimbi chuibanendac —quepanëdash Esus abëd icquido caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aden chuishumbic Esusën nadopanëdash: —Mibi chuinu. Bëdamboen tantia, Simon. Mibitedi Satanasën yuatiadquio iquec. Aden yuanuequin piacbo macuesquin nainshun bitsi secacbimboen mëyantanquin ëbëd icboedi mibi cuëshëdmetiadquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aden mibi Satanasën yuatiadquio iquec, quequin tantiaquin Nuquin Papa naden chiombi. Simon ëbëd icquidquio iqueque. Yuadnushe queshun Satanasën niac-niacmete chiaid Petedo tantienquio icmeta, Papa, quequin chiombi. Adec ëbëd icboedi cuëshëdtsembosh choashun comapenen ëbi tantiaquin ëbëd icquid utsibo adomboembidi comapenen ëbi tantiameta, Simon —capanëdash Esusën Petedo chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Adoaquien: —Mibi caic, Quënën nauednu, quenuc mibëdi nauedadebi. Adecbidi mibi caic, Unës uanu, quenuc adecbidi mibëdi unës uadebi, Icbo —quepanëdash Petedo Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Adoaquien: —Chuinu. Tantiata, Petedo. Cachina bënë cuëdanabicnuc nëid inchëshëmbi, Esus ëmbi isacmaid nec, mibi queded-quededendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aden Petedo chuishumbic abëd icquidtedi chuiquin: —Mitsana bedtequid buanenquio yec shictoadte buanenquio yec dashcute utsi buanenquio yec quec nidaneta, ëmbi cac nidash ¿mibitedi bunecta tabado? —capanëdash Esusën. Adoaquien: —Padenquio —quepanëdash abëd icquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Adoaquien: —Ënden adquid buanenda, queboedi, Ëbi nibëdnuc mitsana bedtequid shictoadtebëdtabi buanta. Chështe bednu, queshun mitsana bedtequid nibëdnuc min dashcute abentsëc menequin chështe bedshun adembidi buanta, caimbi nëbi. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nuquin Papan ëbi chuiquin dada uamiampid nad iqueque. Tantia. Chuinu: “Icsambocquidbëdta unës uaindac,” quepampic. Aden Nuquin Papan ëbi chuiquin dada uamiampicpadomboembi nëbimbobi naimbudembi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Adoquien Esusën chuiboed tantienquio yec abëd icquido: —Në, chështe daëd iqueque. Is, Icbo —quepanëdash. Aden abëd icquidon tantienquiocsho isash: —Ai, padi —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Adashic, Edusaden caid yacnoësh macuësh Odibos caid yacno abi nidteniacpadën nidnuc abëd icquidon tsibanampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Adec nidequi abi tabadteniacno choshon Esusën: —Chieshëmënquidën ëbi namete bunacpaden natiapimbocquid ëbi icme, Papa, quequin Nuquin Papa chuideneta —capanëdash abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aden chiashic abiuidtsëqui uano nidash danëshën nidaidën sebudash Nuquin Papa chiec nadec yuec Esus onquetan-onquetampanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Mëyanquin mibi unës uanu, ëbi chieshënquidon casho tantiash bunenquio yec, Adoenda, quepatsiac mibi Papa. Adoshombic mibi bunacpadomboen nameta, Papa —capanëdash Esusën Nuquin Papa chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aden Esusën baded-badedquien chuishobi Nuquin Papan uaid mayan bëda choshon Esus chieshtomenquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aden uidën uaqui adec uëshquec Nuquin Papa chuiquiequi ichacbëd intacash nidaidën siquepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aden Nuquin Papa chiashic nidtoash abëd icquido yacno choaquimbi ambi chuisho tantiaboed tantiec uimabudash ushec uesho istuidshun: ");
INSERT INTO mcfNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿Atotsi quiash ushe? Nidtoshon ëbi chieshënquidën nametiadquio yacpaden natiapimbocquid ëbi icmeta, Papa, quequin adenuidi Nuquin Papa chuideneta —capanëdash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Adec Esus onquenubien Esusbëd icboedi, Esus bedmenu, quec bëyucanec matses dadpen bëec Udas chopanëdash. Adec choquimbi abi tanchoccanuesho isash: ");
INSERT INTO mcfNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","—¿Ëbi matsesaid icsho bedmenuen tanchoccaquinda ëbi chieshënquido isme, Udas? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aden Udasën nac Esus bednuesho isash Esusbëd icquido: —¿Cho-choquido nuquida cuesten cuespe? —quec ");
INSERT INTO mcfNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","onquetanquin abentsëcshun isadaidbo tsusio dapan yuan pabiate opioc pateshunepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Adosho isash: —Padi. Chën. Adoenda —quetanquin Esusën tsusio dapan yuan pabiate patiacno mishquin bëdamepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Adoshombic, isadaidbo tsusio dapabo Nuquin Papa tabadte shubu uashunaid isquido tsusiobobëdta tsusio utsibo caic: —¿Matses cuëshëdmequid nec, queshunda utsin-utsinquien chështe sananubi utsin-utsinquien cueste sananec cho-chopec? ");
INSERT INTO mcfNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Badiadquidën-badiadquidënquiec Nuquin Papa tabadte shubu uashunaid yacno icsho ëbi bedenquio mimbi icpoc. Mimbi ëbi bedte ushë nëidquiobi nendac. Satanasën tantiamiacpaden utsibo ismenquiocquin inchëshëmbi mimbi icsa uanuen ëbi bedendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aden mimbi icsa uanuen naindac, quequin Esusën chiacsho bedanquin isadaidbo tsusio dapan shubu yacno Esus buanubi Petedo uano tsyuec chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Adec choec umanuc cuëte dëtsiadoaid cuëec utsibo tabadacno Petedo cuëte cuëec tsadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ambo Petedo tsadsho isash tsusion yuaid chido anoentsëqui choshon bëdamboen isec: —Nëid bëboedbëd icboedi nec —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Adoaquien: —Bëboed ëmbi isacmaidquio nec —quepanëdash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Adashic, yuecpactsëcshun Petedo isec utsitsen: —Ma mibi bëboedbëd icquid neyoc —quepanëdash. Adoaquien: —Aidbëd iquenquio iccobi —quepanëdash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Adashic yuec-yuecpactsëc ictanec utsitsen: —Nëid Cadidia yacnoshon tishaid iquec. Ma bëboedbëd icquidi neyoc —queoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Adoaquien: —Mimbi chiaidbëd icquidpenquio nebi —quepanëdash Petedo. Aden chuinubien cachina bënë cuëdampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Adec cuëdanubi aton Icbon bidiadshun Petedo bëispanëdash. Adosho isun: “Nëbi, cachina bënë cuëdanabicnuc, ëmbi isacmaid nec, quequin tedesteden mimbi chiendac,” quequin aton Icbon chuiboed tantiash ");
INSERT INTO mcfNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","unësquio yec umanuc nidash Petedo shubiquiopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Adshumbic Esus cuenushe queshun abi isquidon, sondadon, Esus mamënshumbededquin cuesbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Adoshombic, dashcute cuëshaidën bëpucshun cuestanquin Esus sondadon nadopanëdash: —Mibi tantiaquidquio icquin ¿midaquidën mibi nëbi cueseque. Tantianu. Chui —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aden cuesbededquin Esus icsamboen chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Adshumbic badiadnubi isadaidbo tsusiobo iccuededacno Esus buanshun ");
INSERT INTO mcfNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","nënantanquio nidtomesho isash: —Nuquin Papan chomiaid, Quidistu caid, nebi, quecta ique? Tantianu. Chui —quepanëdash isadaidbo tsusiobo Esus caic. Adoaquien: —Ëmbi abimbo chuisho mibitedishun tantienquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Adembidi, ¿Mitsipadquidquio Nuquin Papan chomiaid neque? Tantianu. Ëbi chui, cac ëcbedenquio mimbi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nad iqueque. Chuinu. Tantia. Matsesash nidaidën tabadboedi ambi nadatiambocquin naidënquio Nuquin Papan dayunquio tsadendabi —quepanëdash Esus isadaidbo tsusiobo tantiamequin chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Adoaquien: —¿Nuquin Papan madombobi nebi, quequinda chio? —quepanëdash isadaidbo tsusiobo Esus caic. Adoaquien: —“Esus Nuquin Papan madombobi nec,” quequin abimbo chuiquid mibi nec —quepanëdash Esus isadaidbo tsusiobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Adoaquien: —Nuquin Papan madombobi nebi, quequin ambibi chiec Esus muec nec. Aden chuisho icsambo iqueque. Unës uatiad, quequin tantiashun, Esus icsaosh, quequin chuitiadquiocquin chuita, cainquio iquembi utsibo chuiquin. Adquid iquec, quequin nuqui tantiec —quepanëdash isadaidbo tsusiobo. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aden ambibi chiec Esus muec nec, isadaidbo tsusio abentsëc quesho tantiash isadaidbo tsusiobotedi nidtoshon Esus bedshun Pidato yacno buampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aden Pidato yacno Esus bëec choash: —Esusën chuibansho tantiash, Cuëshëdmianquid nec, quequin mibi yacno bëombi. Nëid ancanquid dapa Sesadën, Shocoshëmpi bec cho, cac menenda quiosh. Aidbidi, isadaidbo chuiquid dapa nebi, quiosh —quepanëdash isadaidbo tsusiobo Pidato chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Adoaquien Pidato: —¿Isadaidbo chuiquid dapada ne? —quepanëdash Esus caic. Adoaquien: —Mimbi chiaidquio abimbo iquec —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Adsho tantiash: —¿Atotsi nashoembi cuidpe? Ambi icsamboen naid nibëdec —quepanëdash Pidato isadaidbo tsusiobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Adoaquien: —Ambi tantiamiaidënquio Cadidia yacnocquido nëishmiac comapenec cuëdcuededosh. Anoshon tantiameshumbic Edusaden yacno choshon adomboembidi tantiameoaposh —quepanëdash isadaidbo tsusiobo Pidato caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aden chuisho tantiash: —¿Nidaid Cadidia yacnoësh choquidta Esus nec? —quepanëdash Pidato. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Adoaquien: —Ai. Cadidia yacnoësh choquid Esus nec —quepanëdash. Aden chiac Esus ancaquid Edodes nec, quequin Pidaton Edodes yacno Esus buamepanëdash Edusaden yacno Edodes choash tabadec, quesho tantiashun. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aden Edusaden yacno abi yacno bëacsho isash Edodes, Yuen Esus iste bunec nëbi bëdambo iquebi, quequin ëquëducshun tantiapanëdash. Nadatiambocquin nabanquidquio nec, quequin isquidon chiac Edodes Esus isec, Nadatiambocquin napashun. Isnu, quequin ambibi tantiec ");
INSERT INTO mcfNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Esus chuimenu quec Edodes onquepanëdash. Adoaqui Esusën ëcbedenquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Adnubien isadaidbo tsusiobo: —Esus icsambocquid nec —quepanëdash comapenec onquec Edodes chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Adoac Edodesbëd sondado Esus icsamboen chuiquin mamënshumbededshumbi chuiquid dapan dashcutebimboecquid abichobicquid Esus dasiuinshun Pidato yacno buameoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mimbi tantiacpaden Esus cuidta, quequin Pidato chuita, quequin Edodesën chuitanquin Pidato yacno Esus padpiden buamepanëdash. Adoac Edodesbëd Pidato bëdambo yampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Adashic, isadaidbo tsusiobobëdta isadaidbo utsibo chomeshun ");
INSERT INTO mcfNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Esus ismetanquin Pidaton nadopanëdash: —Nëid dada bëash: “Cuëshëdmianquid nec,” quequin mimbi ëbi chioc. Adoac aidbëdi onquiash, ¿Cuëshëmianquidta nedic? quendabi. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aden ëmbi tantiacpadomboen tantiaquin Edodesën ëbi yacno chomeoaposh. Esus unës uainquioctiadquidi nec. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aden tantiaquin mëyanshun aidi nidmenuna —quepanëdash isadaidbo tsusiobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aden chiac naden isadaidbon tantiapanëdash. Setan-setanquien icsambocquid con matses quënën nauedaid abentsëc ambi nidmiacpaden nëbi adquid utsi Pidaton nidmetsiash, quequin tantiec isadaidbo nadec cuëdcuededquin: ");
INSERT INTO mcfNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","—Nëid Esus caid unës uatiadquidi nec. Mimbi quënën nauednëdaid Badabas cuëmëdquid puduemeta —capanëdash comapenec cuëdcuededquin isadaidbon. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ancanquid bunenquiocquin utsibo cuëdcuededmiondaid utsi cuesuniondaidbidi Badabas icsho quënën nauedmepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Adec isadaidbo cuëdcuededsho tantiash Esus nidmetiadquio iquec: —Esus cuidenquioctiadquidi nec —quepanëdash Pidato isadaidbo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Adnubien: —Cuesten dectame —capanëdash isadaidbon yuec comapenec cuëdcuededquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Adec cuëdcuededsho tantiash: —¿Atotsi canun, Cuesten dectame, cai? ¿Atotsi icsamboen nasho isun mimbi chieque? Chui. Tantianu. Ma unës uainquioctiadquidi neyoc. Aden tantiaquin mëyameshun Esus nidmembi —quepanëdash Pidato. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Adoaquien: —Cuesten dectame —quepanëdash cuëdcuededoaic isadaidbo Pidato, Ai, camenuec. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Adoac iccuededquidon chiacpaden namenuen ");
INSERT INTO mcfNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pidaton: —Utsi cuesuniondaid Badabas puduemeshun Esus cuesten dectameta —capanëdash Pidaton cuesten dectamënquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pidaton, Esus cuesten dectameta, cac sondadon abi dectante cueste Esus buamequimbi Simon, Sidene yacnoshon tishaid, chosho bëquedtuidtanquin Esus dectante cueste Simon buamiac Esus tsibambëpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Adec Esus nidsho isun matses dadpenshun shubiquin tsibanampanëdash. Adembidi abi tsibanquid chidobo icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Adec chidobo abi tsibanec shubisho tantiash bidiadshun isec Esus: —Ëbi tantiec shubienda, Edusaden yacnocquidon chidobo. Mibibi tantiadec min bacuëbobëdta tantiec shubicuededta. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yuecash mëyantequid ushë choendac. Aid ushë chonoc bacuë tishtiapimbocquid caic utsibo nadendac: “Bacuëbo nibëdquid icquin min bacuëbo natiasho isenquio mimbi iquec. Adquid yec bëdamboshë mibitedi iquec.” ");
INSERT INTO mcfNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mëyantequid ushë chonoc matses utsibon natiambocquin mëyanaqui naden mimbi Nuquin Papa chiendac: “Natiamianquieque. Acte quiusudquid macuësh dapa catashmetabi, Papa, mibi quendac. Adecbidi, Acte quiusudquid macuësh masiametabi, Papa, utsi queoaindac.” ");
INSERT INTO mcfNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ëbi buansho isec shubiequi, Ëbi mëyantequid ushë choec, quequin tantiesa mibi icpec. Nëdënquenquioctiadquidi achuëshquiocquid nëdëncasho isash: “¿Tanunquiocquid badedquio nëdënquenquio icpec,” quecta mibi icti? Adembidi: “Cuidenquioctiadquidi nec,” queboedëmbi ëbi icsaisa unës uasho isash: “¿Ëbitedi icsambocquid comapenen cuidenquio icpec,” queoapecta mibi ique? Ai, quequin tantiatiad —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Adnubien Esusbëdta icsambocquid dada daëd nidmequimbi ");
INSERT INTO mcfNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","macuësh mapi canite caid yacno choshombi ëquë daëd dectambudcuentanquin nënantanquio Esus dectampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dectanac diadequi Esus Nuquin Papa caic: —Ëbi unës uanuequidon tantienquiocquin unës uainquioctiadquidi cuesten dectanoshibique. Aidon icsamboen nambo yacbimboec bëpiscudta, Papa —quepanëdash. Adnubic Esusën dashcute bednuequin sondadon dada uashun tëchun sandoshon cadotanequin dada uatempi puduemebanquin isquin Esusën dashcute bedbampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Adnubien matses dadpenshun isnubi Isadaidbo tsusiobo isec tabadquin mamënshumbededec: —¿Utsi-utsien Nuquin Papa yacno yuedanquidta nec? Aidi matses mënchictequid Nuquin Papan chomiaidquio iquec abibi budtiadquidi diadpec. ¿Ada budeque? Isnu —quec onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Adembidi sondadon mamënshumbededquin paëmbocquid mucambocquid sananquin Esus ismequimbi: ");
INSERT INTO mcfNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Isadaidbo chuiquid dapa iquec unësenquio iquebi, quiash nëid bednush bud —capanëdash sondadon. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Adnubic, abi dectanaid cuesten mapino abuc matoccaid Pidaton Esus chuiquin dada uamiaid nad icpanëdash: “Nëid, isadaidbo chuiquid dapa nec,” quequin dada uashun Esusën mapino dectamepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Adnubien, Esus icsamboen chiec icsambocquid Esusbëdta dectamboed abentsëc: —¿Nuquin Papan chomiaid, Quidistuda ne? Adquid icquin mimbi budmiac ëbi daëdi mibëd budebi —quepanëdash abëd diadquid. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Adec Esusbëdta dectamboed abentsëc onquesho tantiash aidbëdta dectamboed utsi: —¿Aidi unës uatequid yacpadquid mibi yec, Nuquin Papan ëbi cuidendac, quec dacuëdënenquioda mimbi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Icsamboen nabanacsho cuidaid ëbi daëdi nec. Aidi bëdambocquin nabanquid icsho cuidenquioctiadquidi nec —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aden chiashic Esus caic: —Mibi yacno choash chuiquid dapa icquin ëbi bëdamboen tantiaquin nata —quepanëdash Esusbëdta dectamboed utsi. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Adoaquien: —Abimbo chuinu. Tantia. Nëid ushëmbi abuc ëbi bëdamboec tabadacno ëbëdi mibi iquendac —quepanëdash Esus abëdta dectamboed abentsëc chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Adec onquenubi ushë cuembo yanuc bëtinacbimboec inchëshquio yashic ushë budtsan chënquedoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Inchëshquio icnubi Nuquin Papa tabadte shubu uashunaid yacno puduedtemaid quënën dashcute bitsipambocquid tsincabudquin dectanëdaid tembi daëdquio yec canchedbudcuempanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Adnubien unësbudec comapenec cuëdec: —Mibi yacno ëbi yuedta, Papa —quiash Esus unësbudpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Adec Esus unëso isequi ambi isboedtedi tantiaquin Nuquin Papan naid chiec sondado chuiquid: —Abimbo chiosh. Cuesten dectanaid Esus caid bëdambocquid niosh. Aidi unësenquioctiadquidi unës uaposh —quepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ambo tabadquin isquid utsibo Esus unëso isash unësquio yec aton shubuno nidanepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aido nidnubien nidaid Cadidia yacnoësh choshon chidobon Esus tsibanamboedon dadabëdtambi uano tabadquin isbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Adnubic, ambobi dada, Ose cuëmëdquid, isadaidbo tsusio utsibobëd iccuededquid abentsëc bëdambocquid icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Isadaidbo tsusio utsibo, Esus unës uatiadquidi nec, quenubi, Padi. Unës uainda, quepanëdash Ose. Aidi nidaid Udeya caid shubu dadpen icquid Adimateya caid yacnoshon tishaid icpanëdash. Aidi Nuquin Papan chomiaid chuiquid dapa iste bunquin cainquidquio icpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aidi Esus unëso isash Esusën dada nauedtiadquio yec Pidato yacno nidshun ambi tantiacpaden Osen chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aden chiaquien Pidaton: —Adotan —cac nidshun Esusën dada imbudshun dashcute ushumbocquidën dataneshun buanshumbic ambi macuësh cuënote shëcuë nacnenaid chucanquio Esus Osen badedquio nauedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Inchëshbudtsëqui seis yanuc chonoadtemaid ushë nec, queshun Esusën dada Osen nauedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Adnubien: Nauednu, quequin Osen buansho isun Cadidia yacnoësh Esusbëd choboedon chidobon tsibanshun shëcuën Esusën dada Osen nauedsho aidon isbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aden isash aton shubuno nidaneshun noadte bëda Esusën dada danoshcanu queshun danoshquete chidobon nacnempanëdash. Nacnenash inchëshbudtsëqui seis icnuc Nuquin Papan chiacpadec chonoadtemaid ushë nec, quiash Esus nauedacno nidenquio yec tabadpanëdash. Nuquin Papan chiacpadec tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Adashic, sabado inchëshbudtsëqui seis yanuc chonoadtemaid ushë naimëdan badiadnuc danoshcanun ambi nacnemboed buanec Esus nauedbocno isec chidobo nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ambo choshon Esus nauedshun bëtashaid cuënote shëcniacsho isashi ");
INSERT INTO mcfNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","shëcuën puduedash aton Icbo Esusën dada nibëdsho isec tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Adec tabadnubien dada daëd dashcute dasiuidacbimboec dasiuidash chënquec chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aid isash dacuëdcuededequi isenquio yec chidobo tabadpanëdash. Adsho isash dada daëd: —¿Atotsi canuen unësacsho nauedac uincuemiaid nibëne? ");
INSERT INTO mcfNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nëmbo nauedboedi nibëdec. Aidi uincuenaccosh. ¿Aidi Cadidia yacno mibëdi tabadquin chuisho tantienquioda icco? ");
INSERT INTO mcfNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Naden Esusën mibitedi chiondash: “Matsesaid ëbi icsho bedshun icsambocquid ëbi menendac. Aden meniac cuesten dectanac daëdec ushtanec uincuenoaibi,” quequin Esusën chiondash —quepanëdash dada daëd chidobo caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aden chiac chidobon Esusën chiaid abi bëpiscudaid padpiden tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aden tantiash Esus nauedaid shëcuë yacnoësh puduenanec Esus tantiaquid dadpen tabadacno choec puduedshun ambi isboedbëdtabi ambi tantiaboed chidobon chuibampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Madia shubu dadpen icquid Mactada caid yacnoshon tishaid yec Uana yec Madia utsi Uambëdtan Acobon tita yec chido utsibo yec quec choshon Esusën Ëbi chuibeneta caido chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aden chuisho tantiash: —Mimbi chiaid tantiatiapimbo iquebi —quecuededpanëdash iccuededquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Adnubien Petedo nidtoanec titinquec nauedaid shëcuë yacno choash shuebudquin shëcuë anisquin dataniaid dashcuteuidi uesho ispanëdash. Aden isanec nidequi: —¿Atodain nechitec? —quepanëdash Petedo tantienquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Adashic abi ushëmbi Edusaden yacnoësh utsibobëd iccuededboed dada daëd shubu daëdpactsëc icquid Emaus caid yacno nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Adec nidequi ambi Edusaden yacnoshon isboedbëdta ambi tantiaboed chiec onquepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aden chiec onquec nidshobi Esusën aid daëdi chinunash aidobëd nidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aden abi chinuntuidsho isac utsibimboec Esus isadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Adec nidequi Esus: —¿Atotsi chuibanec onquec nide? —quepanëdash. Adsho tantiash unësquio yec mamënenquio yec nidtuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Adec nidtuidash Quëdeyopas cuëmëdquid: —¿Edusaden yacno tabadtuidquin anoshon naboed mimbiuidtsëqui tantiamboda icco? —quepanëdash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Adoaquien: —¿Atotsi naid chiec ne? —quepanëdash Esus. Adoaquien: —Esus Nasaded yacnoësh choquid chiec nebi. Aidi Nuquin Papan ambi chiaid chuimiaid icquin ambi chuibaniaid ambi nabanaidbidi Nuquin Papabëdtan matses dadpenshun bëdamboen isaid icposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nuquin tsusio dapabobëdtan nuqui chuiquid utsibon Esus bedshun: “Unës uata,” quequin isadaidpembo chuiquid meniac cuesten dectanquin unës uaposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nëbi chuiquid dapa isadaidpembo iquenquiocpashun, quequin Esus isadaidbo yec isadaidbo chuiquid dapa ictsiash quequin ëbitedishun tantiapombi. Ëmbi caboedi unës uaposh. Aidi unës uan daëdec ushobi. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Adec daëdec ushun dacuëdanquiecnuc chidobon naden chuibededposh: “Esusën dada nauedbocno badiadnuc nidshun isac ");
INSERT INTO mcfNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nibëdosh. Ambobi icnubi Nuquin Papan uaido mayan bëdabo daëd icsho isac, ‘Mimbi nibënaid nibëdec. Uincuenac,’ quiosh,” quequin chidobon chuiposh. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aden chidobon chuisho tantienquio yec ëbëd icquido Esusën dada nauedbocno nidshun chidobon chuibocpadembi unës uaboed nibëdsho isposh —quepanëdash ambi chinunaido Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Adoaquien: —Ma bëdiactsëc tantiaquid mibi daëdi neyoc. Nuquin Papan ambi chiaid chuimiaidon dada uampid bëdiactsëc tantiatsec tantiesabidi ma mibi neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Bëdamboec tabadacno chuiquid dapa icnuec Esus mëyanaidba iquendactiosh? —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aden chuibanquin Moisesën dada uampidbëdtabi Nuquin Papan ambi yuecshun nanun chiaid chuimiaidon dada uampid tantiamequin Esusën chuibampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aden chuibanequi shubu daëdpactsëc icquid Emaus caid yacno anoentsëqui choshon datanshobimboecnuc Esus isun: ");
INSERT INTO mcfNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","—Inchësheque. Nëmbo ëbi yacno tabadec cho —abi daëdshun cac nidash aidobëd tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Adashic, shubu nuntan pete sante dayun abëdi uequin pete bedshun Nuquin Papa chuishun cuësh-cuëshun Esusën menebampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aden nasho isun badedi, Esus nec, quequin tantianubi Esus nibëdquio yampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Adsho isash: —¿Podquedën choquin Nuquin Papan chiaid dada uampid chuisho tantiash, Bëdambo yanobi, quenquiodabi ëbi daëdi ictio? —quepanëdash Esus yuedquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aden chuitanequi Emaus yacno choboed daëd badedi Edusaden yacno nidoapanëdash. Edusaden yacno choash Esusbëd icquido 11tedbëdi utsibo iccuededacno puduedacsho isash: ");
INSERT INTO mcfNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Abimbo iquec. Nuquin Icbo uincuempaccosh. Uincuenanec choquin aidëmbi Simon ismetuidposh —quepanëdash iccuededquido. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aden iccuededquidon chuisho tantiashun Emaus yacnoësh choaboed daëdshun Esusën abi chinunshun chiaidbëdta ambi pete bedshun Esusën cuësh-cuëshbamboed chuipanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Adec onquecuedednubi nënantanquio choshon Esusën: —Nuquin Papan bëdamboen isaido yec dacuëdenquio yec tabad —capanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Adec aid chosho isash: Podo bitsi nec, quec dacuëdequi abëd icquido tabadpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Adsho isashien Esus: —¿Atotsi quiash, ¿Esusida nepec? mibitedi quepe? ");
INSERT INTO mcfNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Con mëdantebëdta con taë is. Ëbibi nebique. ¿Mëtoccaid taëbëd chiuë nibëdecta ye? Mishec cho. Ëbi yacpadquid canitebëd nami icquid podobitsi nibëdec —quepanëdash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aden chuitanquin abi bëchun shuin mëtoccaid chiuë aton mëdantebëdta aton taë Esusën ismepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aden ismiac, Aidquiobi nec, quenquio yec abëd icquido mamëncuededquin isec bëdambo yanec, Adec uincuentequidshenda dectampaccosh, quequin tantiec tabadpanëdash. Adec tabadsho isun: —¿Ada pete iquec? —Esusën caquien ");
INSERT INTO mcfNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","nuëcquid shëaid cuëshë menepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aden meniac bedshun Esusën pepanëdash abëd icquidon isnubi. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aden piash: —Mibëd icquimbi naden chuipombi: “Nuquin Papan ëbi chuiquin ambi naden nata quequin Moises dada uamiampidbëdta ambi yuecshun nanun chiaid dada uamiampid naimbudtenendac,” quequin chuibanombi —quepanëdash abëd icquido tantiamenuec. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aden chuishumbic abëd icquido tantiamequioquin: ");
INSERT INTO mcfNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Nuquin Papan dada uamiampid nad iquec: “Nuquin Papan chomiaid, Quidistu caid, matsesën mëyanquin unës uaqui daëdec ushash uincuenendac. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aid tantiashun mibi icsaid mimbi ënsho isash, Icsaquid nec, quenquio yec mibi icsaid Nuquin Papa bëpiscudendac, quequin Edusaden yacnocquidoba ëbi tantiaquidon chuibanendac. Aden Edusaden yacnocquido chuishumbic nidaid utsi-utsiec yacno nidshun adomboembidi chuibanoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mëyanquin unës uaqui ëbi uincuenacsho mibitedishun ispoc. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aden isun tantiaquido mibitedi icsho Nuquin Papan ambi mibitedi menenu caid aton Mayan chomendambi. Aidi Nuquin Papan nadatiambocquin natequid iquec. Aid mibitedi meniabicnuc Edusaden yacnoshon aidi caimbudta,” —capanëdash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Adashic, bëyucanec nidequi Betania yacno anoentsëqui choash nidtuidshun aton mëdante abuc sananquin ismec: —Nëidtedi bëdamboen ista, Papa —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aden chiacsho abëd capucuenequido niamequin Esus aton Papan abuc indopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aden indosho isash, Ëbitedishun icbo nec, quequin ismec shuebudash: —Bëdambo iquebi —quianec Edusaden yacno nidanepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Adec Edusaden yacno nidoash tabadec Nuquin Papa tabadte shubu uashunaid yacno badiadquidën-badiadquidënquiec nidted-nidtedquin Nuquin Papan naid chuidenepanëdash. Padi. Aidted dada uaombi, Teyopido.");
INSERT INTO mcfNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ëndenquimboshë matses uabi yec abitedimbo uabi yequi Nuquin Papabëd Esus icpampic. Nuquin Papapadquidquiobidi yec: —Nadquio Nuquin Papa iquec —quec tantiamianquidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aidëmbi Nuquin Papabëd icquin ");
INSERT INTO mcfNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","abitedimbo uapampic. Abubëdta nidaid uashun aidën icquidtedi uapampic. Ambi uacmaid utsi nibëdec. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aidquio Nuquin Papa yacno tabadmianquid nec. Nuquin Papapadquidquiobidi yec: —Nadquio Nuquin Papa iquec —quequin paposhquiacbimboecnuc tantiamianquidbidi Esus nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Adembidi matses ambi icsamboen naid tantiamequid nec. Adquid icquin: —Con Pamboen bëdamboshë icquidquio nendac. Aidën chiaid niac-niaquec mibi icsamboec tabadec —quequin chuisho tantiatiapimbo icquin matsesën Esus chieshëmpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aden Esusën chuibeniabi icnuc con shënision acten mentoanquidëmba Nuquin Papan chiacpadomboen ambi chiaid chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","—“Nuquin Papa yacnuësh abi tantiamequidquio choendac,” quequin Uanën chuibansho tantiashun ma dadpenshun ambi chuiboed tantianu —quequin Nuquin Papan con shënisio abi chuibanquid icmepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nuquin Papa yacnuësh choacmaidëmbi con shënision: —Nuquin Papan chomiaid Esus nec —quequin chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aden ambi chuiboedquio Nuquin Papa tantiamenuec matsespanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Adash matsesbëd tabadsho ambi matses uaidombi tantienquio icquin chieshëmpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aden con matses isadaidbon Esus tantienquio iccondash. —Isadaidbo con matses nec —Nuquin Papa quenëdacpadquiec: —Isadaidbo con matses nec —queoapondash Esus. Adsho ambi con matses caidonquiobi dadpenshun Esus tantienquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Utsibombien daëdpactsëcshun: —Nuquin Papan Madombo Esus nec —quequin tantiasho Nuquin Papan: —Con mado nec. Con champi nec —cabempanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","—Con matsesuidien Nuquin Papan: “Con mado nec. Con champi nec,” capec —¿quequidta adopanëdash? Padenquio. —Nuquin Papan mado nebi —quequin ¿ambembi chuiquidta con mado capanëdash? Padenquio. Nuquin Papan Mayanën tantiamiacpadomboen aton Madombo Esus tantiasho dada con mado caquin chido con champi capanëdash. Adembidi Esus tantiasho adoendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Adec Nuquin Papa tantiamequidquio Esus matsespanëdash. Nuquin Papan Mado abentsëqui yec bëdamboshë icpondash. Ëbëd tabadquin nadatiambo icquin nabanquin matses bëdamboen nashumbampondash. Aden Nuquin Papambo tantiamepondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aid con shënision chuipondash. —Ëmbi chuiboedquio nec. “Ëbi icsaquid icnuc bëdamboshë icquidquio choec,” ëmbi caboedquio nec. “Ëmbia Nuquin Papan chiaid chuibambon aidëntsen tsyuec choshon chuibanendac. Ëbi bëyuc tishaidi tishabi icnubi aid ënden icpampic,” ëmbi caboedquiobi Esus nec —quepondash con shënisio. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Con shënision chiacpadquidquio icquin abi tantiaquido Nuquin Papan bëdamboen isaido icmeshun adenuidi Nuquin Papa nuqui bëdamboen ismec. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ëndenquimboshë Nuquin Papan chiaid dada uaquin Moisesën Nuquin Papan matses icsaido cuidte tantiamepampic. Padnuen Esuquidistun Nuquin Papan bëdamboen iste tantiamequin: —Nadquio Nuquin Papa iquec —quequin matses bëdamboen tantiamepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ambi isacmaidquio icsho matsesën Nuquin Papa bëdamboen tantiatiapimbo iquec. Padnuen aton Mado abentsëcshunquio aton dayun tsadquidënquiobi matsesun Nuquin Papa bëdamboen tantiamepondash. Aidquio chuinu. Tantia. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Con shënisio Nuquin Papa tantiabenquid acten mentobenequid niondash. Aden acten mentobenesho isash Moisesën chiampid namequido aid chuimenuec cho-chopondash. Edusaden yacnocquido isadaidbo tsusiobon: —Chuimetan —cac cho-choquin con shënisio chuituidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","—¿Tsuntsin chiac nai? ¿Mimbembida nai? “Bëdamboshë icquidquio Nuquin Papan chomendac,” quequin nuquin tsusedpan ¿dada uapampidta ne? —catuidpondash. Adoaquien: —Padenquio. Aidpenquio nebi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Adshobien: —¿Tsumintsi ne? ¿“Naden naindambi,” quequin Nuquin Papan chiaid chuibanquidquio unëspampid Edias uincuenaidta ne? —caquien: —Padenquio. Aidpenquio nebi —queoapondash. Adshobien padpiden: ¿Tsumintsimbo ne? “Moisespadquidquio choendac,” ¿capampidta ne? —caquien: —Padenquio. Aidpenquio nebi —queoapondash con shënisio. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Adshobien padpidemboen: —¿Tsumintsimbo ne? ¿Mimbenquiobienda nao? Ëbi: “Chuimetan,” caboed chiec nidnu. Baded ëbi chui —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—Nuquin Papan tantiamiac nuquin tsusedpa Isayasën naden chuipampid nebi. “Nuquin Papan bëdamboshë icquid chomiabi icnuc aid bëyuquec utsiba choendac. Aidën shubu nibëdacno capucuenequin chuibanendac naden. ‘Chuiquid dapambo choeque. Podqued andëdbanshunta,’ quiacbimboen chuiquin: ‘Nuquin Icbo choeque. Icsaid ënash bëdamboec tabadta,’ quequin chiendac bëyuc choshon,” quequin chuipampid nebi —quepondash con shënisio. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Adnubien con tsusedpabon chiampid namequidon padiseyobo caidontsen aton chuiquid dapan chiacpadomboen con shënisio chuituidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Utsibon: “¿Adquidta ne?” cac: “Adquidpenquio nebi,” queuidequi mibi iccoc. “¿Mitsipadquidquio icquin acten mentobano?” mibi caimbi —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—Nuquin Papan chiacpadomboen abi tantiabenquido acten mentobenec nebi. Ëmbi aden bëdamboen nanuc utsimbien bëdamboenshë naindac. Aidi mibëdi tabadshobi ma mimbi tantienquio icboc. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ëmbia Nuquin Papan chiaid chuibanombi. Aidëntsen tsyuec choshon comapenen tantiaquin Nuquin Papan chiaidquio chuiquin Nuquin Papambo tantiamendac. “Aidi bëdamboshë icquid icnuc ëbi icsaquid icsho ¿atotsieshun: ‘Aid choec,’ quequin chuiquidquio Nuquin Papan icmioshi?” quec tsadebi —quepondash con shënisio padiseyobo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Acte Odan caid uquë cuëmatsiucuësh shubu dadpen icquid Betania caid yacnuësh adpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Badiadshun padpiden con shënision matses acten mentobanoapondash. Aden mentobanubien Esus chopondash. Chosho isashien: —Is. Nuquin Papan namiaidquio obeca bacuëbimboecquid choeque. Aidi isadaidbon obeca bacuëded cuidquin unës uacbimboec matses icsaid bedshunec abided cuidadec unësendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ëmbi chianeboedquio nec. “Ëbi bëyuc tishaidi tishabi icnubi aidi ënden icpampic,” quiash: “Ëbi bëdapabi icnuc bëdamboshë icquidquio choendac,” quepobi. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aid chosho con matses isadaidbo tantiamenuen Nuquin Papan acten mentobenequid icmiondashi. Adondaidëmbi ëmbibi badedquio tantienquio iccombi. “Nuquin Papan chomiaid nec,” quequin tantienquio iccombi —quepondash con shënisio. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Adashic abi onquec: —Nuquin Papan naden ismiac tantiabenombi. Aton Mayan aton dada nibëdquiec dëbimbimboec budec: “Matsadtoendac,” quebocpadequi Esus matsadtosho ispombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Adsho isash: “Adquidshenda caposh Nuquin Papan: ‘Acten mentoanquid icta,’ ëbi caboedën. ‘Con Mayan dëbimbimboec budec matsadtoboedën abi tantiaquidobëd con Mayan tabadmendac,’ Nuquin Papan caboedshenda nepec,” quiobi Esus caic. Ëmbembi tantienquio ictsenombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aden ismiac: “Nuquin Papan Madombo Esus nec,” quequin tantiombi. Aden tantiashun: “Nuqui caimboed Nuquin Papan chomiaidquio Esus nec,” quequin mibi chiec nebi —quepondash con shënisio. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Adashic badiadash ambi acten mentobambocno con shënisio nidoapondash. Aid tsibanequi nidoapondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Adec nidquin isquien Esus cuempec. Cuensho isashien con shënisio: —Is. “Nuquin Papan namiaidquio obeca bacuëbimboecquid nec,” ëmbi caboed cueneque —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Adsho tantiatanequini con shënisiobëd iccondaid utsibëd Esus chinunec nidpondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nidquin chinunac bidiadquin istanequien: —¿Atotsi quec ne? —quepondash Esus. Adshobimbi: —Mibi isec nebi, Dabi. ¿Mitsimbo mibi ushaque? Isnu —capondambi. —Chuiquidquio nec —quequin con onquetembi Dabi caondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Adoac: —En isec cho —cac abi ushacno isec nidondabi. Ushë abucquio icnuc puduedash yuec tabadec onquetaniash inchështsëcnubi chondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ëbëdtan Esus chinunondaid Andedes niondash. Shubu dadpen icquid Betsaida caid yacnuësh caniquid niondash. Aton buchi Petedo niondash. Petedobidi Simon capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Adnubien Andedes aton buchi chiec nidpondash. Adec nidquin Petedo istuidash: —Nuquin tsusedpabon chuipampid Nuquin Papa yacnuësh choquid Mesias caid istuidombique. En isec cho, buchi —capac caondash. Nuquin Papa yacnuësh choquid Quidistu cashumbic con onqueten Mesias caic. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aden chiaquien aton buchi Esus isec chopondash. Chosho isash Esus: —Uanën mado mibi nec. Mibi Simon nec. “Nidaid moco utsi uatiapimbo yacbimboec mibi chieshtoenquio icquid yanendac,” quequin mibi nidaid moco cuënendambi —quepondash Esus Petedo caic. Con onqueten nidaid moco cain Sepas capondash Esusën. Quidieco matsesën onqueten Petedo capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Badiadash: —Con nidaid Cadidia caid yacno nidnu —quianec nidpondash Esus. Adec nidquimbi Uedipe istuidpondash. Istuidshun: —Nuquibi icnu. Cho —caquien Uedipe chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida yacnuësh caniquidbidi nepondash aid. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Esusbëd icquid yanashic dada utsitsen Natanaid caid chiec nidpondash Uedipe. Adec nidquin istuidshumbien: —Isec cho. Moisesën chiampicpadomboen chuiquin nuquin tsusedpabo utsibon: “Bëdamboshë icquid choendac,” quequin dada uapampicpadequi choshe. En isec cho. Shubu dadpen icquid Nasaded caid yacnuësh caniquid neque. Osen mado nec —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Adsho tantiash: —¿Nasaded yacnuështa dada bëdambo icquid chopatsiash? Auëshquio dada bëdambo icquid chotiapimbo iquendac —quepac caondash Natanaid. Adsho tantiash: —En isquiec cho —quepac caondash Uedipe. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Adoac choshobien Esusën: —Is. Isadaidbombo neque. Muesambo nec —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaidën: —¿Mitsipaden ëbi tantie? Mabi mimbi isacmaidquio nepayoc —capondash. Adoaquien: —Uedipen bedtanabi icnubi mibi cuëte icueda caid tayun tsadsho tantiombi —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Adsho tantiashumbien: —Nuquin Papan Madombobien mibi nec. Comapenen tantiaquid yec nuquin matses isadaidbo chuiquid dapambo mibi nendac —capondash Natanaidën: —Istiapimbo yacno chiosh —quequin tantiashun. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Adoaquien Esusën: —“Cuëte icueda caid tayun tsadsho mibi tantiombi,” ëbi quesho ¿tantiashta: “Nuquin Papan Madombobien nec,” badedquio que? Padpiden comapenen tantiaquin nabansho isun mimbi ëbi tantiaquiotsiandac. ");
INSERT INTO mcfNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tantia. Mibi chuinu. Isadaidbo tsusedpa Acobon Nuquin Papan abi yacnoshon uaido mayan bëdabo Nuquin Papa yacno dectatonesho isash: “Aidbëd tabadte Nuquin Papan ëbi tantiametiadquio iquec,” quequin tantiapampicpadomboen mimbi ëbi tantiendac. “Matsesun Nuquin Papan Madon matses abëd tabadte tantiamec,” quequin mimbi ëbi tantiendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Aden Natanaid chiash aton nidaid Cadidia caid yacnobi Esus tabadpondash. Ambo tabadec daëdec ushtsambi shubu dadpen icquid Cana caid yacnocquidën isadaidbon aton chido bedquin ismequin pemenuen aton shubuno matses dadpen cho-chomepondash. Adoac cho-chomiaidobëd Esusën tita puduedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Esustsen puduedpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Adec puduedash tabadquin uba chinaid actequid uesquin acbededpondash. Adsho isumbien anin Esus chuipondash. —Actequid naimëdoshe. Comapenen tantiaquid icquin mimbi tantiacpadomboen nata, mado —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Adoaquien: —¿Atotsi quequin mimbi ëbi chuipe, tita? Chiata. Con Pan tantiacpadënquio naimbique —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Adsho tantiatanquin anin yuabo actequid cushtobanquido chuipondash. —Con madon chiacpadomboen nata —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ambobi tëchu dapa 6tedi tabëcaid icpondash. Mëpamëdtembo acte nua 120 ditedos cactembi anidboedi acte naimëdaid icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Adnubien Esusën: —Në tabadquidën acte cushtoban —cac cubu-cubuctsëcquio icnuc acte cushtobampondash yuabon. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Cushtobanacsho isun Esusën: —Ueshun buanshun mibi ancaquid acmetan —cac acmetampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Adoac acquin tanaquien actequid bëdamboshë icquid icpac caondash acte icboedi. —Nibëda damboedquio ¿mitsimbo bedpash? —quepac caondash yuabo ancaquid. Adsho tantiashun yuabon: —Esusënquiobien naccosh —quequin tantiapac caondash. Adnubien yuabo ancaquidën chido bednuequid chuipondash: —Aidën actequid bëpash —queshun. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Nuquin matsesën actequid bëdambo icquidba isedanquido acmequid nendac. Adquid acmiac matses nua cubudacsho isash: “Actequid icsactsëcquidtsen acmenu,” quequid yendac. Aden mimbi nambo. Bëdambo icquidquio ma mimbi nëbi acmianeyoc —quepondash yuabo ancaquid chido bednuequid chiec. Adnubien yuabon actequid bëdamboshë icquid abitedi acmebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aden comapenen tantiaquid icquin ambembi actequid uaquin Esusën tauamboen ismebempondash. —Nuquin Papa yacnuësh choquid yec comapenen tantiaquidquio nebi —quequin aden tauamboen ismebenondash nidaid Cadidia caid yacnoshon shubu dadpen icquid Cana caid yacnoshonquio. Adosho isun: —Con matsesën chiampid Nuquin Papan chomiaidien nec —quequin tantiabenondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aden ambembi actequid uatanec nidec shubu dadpen icquid Capednaun caid yacno Esus nidondash. Aton tita yec aton buchi yec abëd icquido yec ëbi yec quec Esusbëd nidaniondabi. Ambo daëdpactsec ushec tabadondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ambo ushcuidanec nidequi shubu dadpen icquid Edusaden yacnotsen Esus nidaniondash. —Nuquin matses tsusedpabo unës uainquio icquin Nuquin Papan matamiampid inchësh tantiaquin obeca bacuë pec nëbi tabadeque. Isec nidnu. Nid —quianec nidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nidashic Nuquin Papa tabadte shubu uashunaid dapa daquënë uaidën puduedondash nuntanquio puduedabi. Puduedshun isquien matses dadpen nëish yua chedobëd tabadpec. Baca bënë yec obeca yec dëbimbimboecquid quënëmpin sauedaid yec quec tabadpondash. Aton yua menequin piucquid bednuec utsibo tabadnubi utsibo ambi tabëcaid dayun tabadpondash. Aido nidaid utsi yacnuësh choquido aton piucquid dadpen bedshun ampeshunquin daëdpactsëc menequido niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Adec tabadsho istanquimbien Esusën cueshcate badedquio nacnentanquin cuesquin niacumpondash umanuc abitedimbo. Aden umanuc niacuntanquin tabëcaidtsen bidiacbanquin piucquid siabudshumbampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Adotanquimbic dëbimbimboecquid yuaquidotsen chushcapondash. —Baded mitsana buanec nid. ¿Piucquid bednuen shubu uaidta nedic? Ma con Pa tantiate shubu neyoc —quequin chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Adsho isun naden tantiondambi. —Adquidshenda Nuquin Papan chiaid chuiquin con tsusedpan dada uapampic. “Aton Papan shubu cudasquidquio nendac,” quequin Esusën nate chuiquin dada uapampic —quequin tantiondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aden nicacsho isumbien con matses chuiquidon: —¿Tsuntsin chiac nao? “Nuquin Papan chomiaid icquin naombi,” quequin comapenen tantiaquin nabanquin ëbi isme —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ismenquio icquin ompoacbimboen Esusën chuipondash. Abibi cadequi: —Mimbi nëid shubu icsa uabocsho padpiden nacnenoaindambi bëdambo icnuc. Daëdec ushquin nacnenquin nainendambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Adsho tantiash Nuquin Papa tabadte shubu uashunaid dapa ca danec: —¿Badedquioda nacnempatsia? Nëid nacnenquin seta dadpenquioshë 46tedquiobi matamiac cadenec —quepondash con matses chuiquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","22","Yuecquio ictaneshun Esusën aden chiaid tantiondambi. Unës uacsho chococac daëdec ushash Esus uincuenaccondash. Uincuenacsho isash: —Abibi cadecshenda Esus nepondash. Abibi cadec: “Daëdec ushquin nacnenquin nainendambi,” quecshenda nepondash. Aden chuiquinshenda con tsusedpabon dada uapampic —quequin tantiondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nuquin Papa tabadte shubu uashunaid daquënë uacnoshon cuemeshumbic Edusaden yacnoshontsen comapenen tantiaquin nabanquin Esusën ismepondash. Adsho isun matses dadpenshun: —Nuquin tsusedpabon chiampid Nuquin Papan chomiaidien Esus nechitec —queshun Esus bëdiactsëc tantiatsëccondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aden tantiatsëcsho ambembi tantiash: —Ai, ëbi tantiaquidquio nec —quenquio icquin: —Ëbi bëdiactsëc tantiatsec —quequin tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Utsin chiambobi ambembi tantianëdash. Aden matses abitedishun otacquio tantiaid ambembi tantiaquidquio Esus niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Adnubien Edusaden yacnobi Nicodemo caid icpondash. Tsusedpabon chiampid namequido padiseyobo chuiquid dapa niondash. Tsusio utsibobëdtan aton matses namequid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Inchëshën Esusbëd onquenuec chopondash. Choshombic aidëmbi: —“Nuquin Papan icmiacpadquid chuiquidquio mibi nec,” quequin tantiembi. Mimbi comapenen tantiaquin nabansho isun: “Nuquin Papan namiaidënuidtsëquien adotsiash,” mibi caombi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Adsho tantiashun: —Ai, adquid nebi —quenquio icquin Esusën ompoacbimboen chuipondash naden. —Tantia. Mibi bëdamboen chuinu. Chuca uac Nuquin Papa yacno tabadtequid mibi ictsiandac. Chuca uabi yec mibi padenquio ictsiac ");
INSERT INTO mcfNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—quesho tantiashien: —¿Mitsipaden tsusiobi chuca uapatsiash? Chidon padpiden usundoshon tishtiapimboen iquec —quepondash Nicodemo. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Adsho tantiashun Esusën: —Nuquin Papan Mayanën tantiamiac: “Nuquin Papa tantiaquin ëbi icsaid ëntiadquio iquebi,” quiash bëdamboec tabadquid Nuquin Papabëd tabadtequid nendac. Adquid chuca uaid caimbi. Chuca uabi icquid Nuquin Papa yacno tabadtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chidon tishaiduidtsëqui yec Nuquin Papabëd tabadtiapimbo iquendac. Nuquin Papan Mayanën chuca uaid Nuquin Papabëd tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Chuca uaiduidtsëqui Nuquin Papabëd tabadendac,” ëbi quesho tantiash: “¿Midapaden chie?” quepequien mibi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tantia. Mibi chuinu. Cunquequid isadenquio icquid nec. Isadenquio icquimbi cuncac cuëte ishcudsho isash: “Abi cunquec,” mibi quepec. Adquiobidi isadenquio Nuquin Papan Mayan iquec. Isadenquio icquimbi aidën chuca uaid bëdamboec tabadsho isun: “Nuquin Papan Mayanën nac,” quequin mimbi tantiatsiac. “Nëid utsitsen natsiash,” quequin mimbi tantienquio icnubi Nuquin Papan tantiacpadomboen aton Mayanën utsitsen chuca uatsiandac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Adsho tantiash: —¿Midapadec? —quepondash Nicodemo. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Adoaquien: —¿Tantienquioda ique? Ma isadaidbo Nuquin Papan chiaid chuibanquid mibi neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ënden ushë utsin mibi chedo chiombi. Ëmbi isondaidquio chuiquinc ëmbi tantiondaidquio chuiquinc caombi. Adsho tantiash: “Tantiadenquio iquec,” ma mibi queboc. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","¿Ëmbi chuiboed tantiadenquio icnubi padpiden chuiquin ëmbi Nuquin Papan abi yacnoshon naid chuishomenda tantiatsia? ");
INSERT INTO mcfNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nuquin Papa yacno matses nidtanambo iquec. “Istanombi. Nadquio iquec,” quequin chuitiapimbo matses iquec. Ëmbien Nuquin Papa yacnuësh chondaidënquio: “Nadquio iquec,” quequin Nuquin Papa tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","¿Atotsi canuen nuquin tsusedpa Moisesën nisibimboecnuc shocosh nacnenaid dectampampic? “Nuquin Papan chiacpadec ma aid isec nisin piaid bëdanu,” quequin cuesten dectampampic. Adomboembidi matses cuidmenquio icnuec cuesten dectamëdendabi ëbided cuidadec unësec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ëbi tantiaquido unësacsho cuidenquio icquin Nuquin Papa yacno ëbëd tabadmenuec adendabi —quepondash Esus Nicodemo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Aden Esusën abided cuidadec unëste chuipondash. Nuquin Papan: —Ma adec abided cuidadec unësnu —quequin Esus chomepanëdash. —Unësquio iquec —quequin matses abitedi tantiaquidquio icquin Nuquin Papan cudasenquio icquin matsesmeshun aton Mado abentsëcquiobi abided cuidpanëdash. —Ëmbi adoaid con Mado tantiaquid unësacsho icsaido cuidacno nidmenquio icquin ëbëdi tabadmendambi —quequin aton Madoded cuidpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","¿Matses cuidnuenda Nuquin Papan Esus matsesmepanëdash? Padenquio. Matses cuidenquio icnuen napanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aden aton Mado Esus tantiaquido cuidenquio icquin Esus tantiesabo cuidendac: —Con Mado chieshëmpec —queshun. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nuquin Papan matsesmiaidën Esusën abi icsaid chuisho matses icsambo icquidon tantiatiapimbo iquec. Ambi icsamboen naid ëntiapimbo icquin Esus tantiatiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Adquidon: —Ëbi icsaid Esusën utsibo tantiamenushe. “Icsambo iquec,” ëbi canushe —queshun Esus chieshëmpec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nuquin Papan chiacpadec tabadquidombien Esus chieshënenquio iquec. —Nuquin Papan namiacpadec tabadquid nebique. Ma Esusën ëmbi bëdamboen naid chuibampanuna —quiash Esus tantiate bumpec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Adec Nicodemobëd onqueboshien Esus nidpondash. Edusaden yacnuësh nidec aid nidaidëmbi Udeya caidën capucueniondash. Abëd nidshobini Nuquin Papan chiaid Esusën chuibampondash. Adec nidshun Nuquin Papa tantiabenquido acten mentobeniondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Adnubien adomboembidi con shënisiontsen acten mentobeniac caondash. Enon caid yacnoshon Sadin caid anoentsëqui chunquen diadacnoshon matses dadpen acten mentoac caondash con shënision. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chieshëmënquidon quënën nauedabi adoac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Adnubien con shënisiobëd icquido con matses utsibëd: —Mimbi icsamboen chiec —quec chushcananac caondash. Con shënisiobëd icquido: —Uanën Nuquin Papa tantiabenquido bëdamboen acten mentobamposh —quesho tantiash: —Padenquio. Esusëmbien bëdamboen acten mentobaniosh —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Adshumbien con shënisiobëd icquidon: —Nuqui chuiquid chiec nidnu. Nid —quianec nidquin con shënisio chuituidpac caondash. —Acte Odan caid uquë cuëmatsiucshun ¿mitsicquid: “Nuquin Papan chomiaid nec,” mimbi cadio? Aidën mimbi naid dëniacquin matses dadpenquio acten mentobeniac caosh. ¿Ada bëda icpec? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","—“Nuquin Papan chiacpadomboen Esusën nash. Adomboembimbi naic,” queshun Esus chieshëntiapimbo iquendabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Nuquin Papan chomiaidpenquieni nec,” quequin mibi chiondambi. “ ‘Nuquin Papan chomiac bëdamboshë icquid choendac,’ quequin bëyuc choshon aid chiec nebi,” quiondabi mibi chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Ëmbi chuiboed nec,” quiash Esus chosho istanec cuishonquepobi. “Con matses aton chido bedmiombi,” quiash cuishonquiacbimboec cuishonquepobi. ¿Aden chido bedmequidën: “Min bënëbëd nidenda,” caquinda ictiosh? Padenquio. Bënëbëd nidmiash bëdambo yacbimboec Esusbëd nidanesho isash bëdambo iquebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ëmbibi Nuquin Papan chiacpadomboen Esus tantiamequin ënquin chuibanuc ëmbi acten mentoaido daëdpactsëc yanendac. Ëmbi chuiboedquio Esus tantiaquidoen dadpenquio yanendac. Aidquio bëdamboshë iquec —quepac caondash con shënisio abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Adshumbic con shënision naden chuipac caondash. —Esusquio bëdamboshë iquec. Nuquin Papa yacnuësh choquid abipadquid utsi nibëdec. Padnueni matses yec: “Nuquin Papa isondambi. Nadquio iccondash” quequin chuitiapimbo iquebi. Esusëmbien ");
INSERT INTO mcfNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ambi isondaidbëdta ambi tantiondaidquio chuipec. Aden chiaqui matses dadpen: “Abimbo caic,” quenquio icpec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Esus tantiaquidon: “Nuquin Papa muesambo nec. Ambi: ‘Bëdamboshë icquid choendac,’ quequin dada uamepampidquio Esus nec,” capec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nuquin Papan chomiaidquio icquin Nuquin Papan chiaidquio Esusën chuibanec. Nuquin Papan aton Mayan abëd tabadmiaid icquin comapenen tantiaquin ismebanquin chuibanec. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ambi tantiaidquio icsho aton Papan abitedishun Icbombo icmiac. ");
INSERT INTO mcfNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Adnuc: “Abitedishun Icbombo Esus nec,” quequin aton Mado tantiaquido unësacsho Nuquin Papan abëdi tabadmendac padpidec unësenquio icnuc. Esus chieshënquidoen Nuquin Papa yacno isenquio yec icsaido cuidquiacno nidendac —quequin con shënision chuipac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Esusbëd icquin Nuquin Papa tantiabenquido acten mentobanondambi. Adnubien con matses chuiquido padiseyo caidon: —“Uan acten mentoanquidën naid dëniacquin Esusën matses dadpenquio acten mentobanosh,” quiosh —queshun Esus chieshëmpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Esusën nainquio icnuc ëmbimbo nasho isun chiaqui aden Esus chieshënac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","—Mibi adosh —cac: —Con nidaidën nidnu —quianec nidondash Esus. Aid nidaid Udeya caid yacnuësh nidec aton nidaid Cadidia caid yacno nidondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aid podquedën nidequi nidaid utsi yacno Samadia caid yacno nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Adec nidquin ushë cuembo icnuc shubu dadpen icquid Sicad caid yacno istuidpondash. Aid anoentsëqui con tsusedpa Acobon tied uampid icpondash. Aid tied caic: —Ëbi unësan nëid tied: “Con na nec,” cata, mado —quequin aton mado Ose chiampid tied niondash. Ambo aidën uëdëshcampid acte uete icpondash. Aid dayunquiobi: —Tiboquenu —quec Esus tsadtuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Adec tsadtuidnubini: —Pete bedtanu —quianec shubuno nidanepondac. Esus abentsëqui nianec nidaniondabi. Adec nidan Samadia yacnocquid chido acte uec choquin Esus tsadsho istuidpaccondash. Choshobien Esusën: —Acte beccho. Acnu, champi —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—“Acte beccho,” ¿caquindabi ique? Ma isadaidbo mibi nepayoc. ¿Isadaidbo icquindabi: “Acte beccho,” cai? capac caondash acte uequid chidon. —Samadia yacnocquidbëd onquesambo isadaidbo nec —quequin tantiec adac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Adshobien Esusën badedquio cuembo chienquio icquin chuipac caondash. —Nuquin Papan bëdamboen isquin naidbëdta ëbi tantiaquin: “Acte beccho,” mimbi ëbi catsiac. Adsho acte bëdambo icmianquid mibi acmetsiambi —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Adoaquien acte uequid chidon actembo ca danquin: —¿Mitsipaden acte ueshun ëbi menetsia? Ma min tëchu nibëdpayoc. ¿Midapaden mimbi uetiapimboen acte uquëducquio iquec? ¿Mitsimbo acte bëdambo icmianquid ueshun ëbi acmetsia? ");
INSERT INTO mcfNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nëid acte nuquin tsusedpa Acobon uëdëshcapampid nec. Aton yuabobëdtan aton bacuëbon acpampid nec. Nuquin tsusedpa bëdambo icquin nampid icnuc ¿mitsipadquidquio icquin nai? ¿Bëdamboshë icquid icquinda mimbi acte bëdamboshë icquid ëbi acmepatsia? —capondash acte uequid chidon. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Adoaquien: —Nëid acash mibi bundoaic. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ëmbi acmiac mibi bundoenquio ictsiac. Acte bëdambo icmianquid acmiac ënëdenquio yec tabadquid mibi yantsiac —quepac caondash Esus badedi cuembo chienquio yec. —Ëbi tantiaquidobëd con Mayan tabadmiac bëdambo yanec unësacsho ëbëdi tabadmendambi —quequin tantiec adac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Adsho tantiashun padpiden acte ca danquin: —Adquidquio ëbi acme. Bundoenquio yec nëmbo acte uec choenquio ictsiabique —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Min bënë bedtan —capac caondash Esusën. —Nuquin Papan chomiaidquio yec comapenen tantiaquid mibi nec —camenuen adoac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Min bënë bedtan —caquien acte uequid chido: —Con bënë nibëdec —quepac caondash. Adshobien Esusën: —Abimbo mimbi caic. Min bënë nibëdec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dada mëdante auc abentsëctedquiobi min bënë icpadenec. Aidon mibi niambudnian nëbi mibëd icquid min bënëpenquio nec. Abimbo mimbi caic —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Adsho tantiash: —Isambobi comapenen tantiaquidien mibi nechitec. Mibipadquidquio chiec: “Nuquin Papan chomiaidquio nendac,” quepec con matses. Adquid icquin en ëbi chui. ¿Mitsishunquiembi Nuquin Papa bëdamboen tantiape? ");
INSERT INTO mcfNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Con matses: “Nëmboen Nuquin Papa iquec. Nëid macuësh dapanshunuidtsëqui Nuquin Papa tantiac bëdambo ictsiash,” quepec. Min matsesien: “Edusaden yacnoshonuidtsëqui Nuquin Papa tantiac bëdambo ictsiash,” quepec —quepac caondash acte uequid chido. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Adsho tantiashun Esusën: —Tantia. Mibi bëdamboen chuinu. Nëbi nëid macuësh dapanshunuidtsëqui Nuquin Papa tantienquio icquin Edusaden yacnoshonuidtsëqui tantienquio icquin nidaid utsi-utsiec yacnoshon adembidi Nuquin Papa tantiabededendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Min matsesën Nuquin Papan chiaid daëdpactsëc tantiatsëcshun Nuquin Papa bëdiactsëc tantiatsec. Con matses isadaidbombien Nuquin Papan chiaid dadpen tantiashun: “Nuquin Papan chomiaid nuquin matses bëdambo icmianquid nuquin matsesën tishendac,” quequin bëdamboen tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nëbien utsin-utsinquien muainquio icquin: “Con Icbo nec,” quequin Nuquin Papa tantiendac. Ambi chiacpadec bëdamboec tabadsho isash: “Adquid ëbi tantiaquidquio nec,” quetsiash Nuquin Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","“Nuquin Papa tantiaquid ictiadquio iquebi,” quequidën Nuquin Papan Mayanën tantiamiacpadomboen abi tantiaquin ambi chiacpadomboen naquid nendac —quepac caondash Esus acte uequid chido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Adsho tantiash chido: —“Nuquin Papan matses bëdambo icmequid chuiquid dapa chomendac,” quequin chuisho tantiondambi. Aid mesias caidi utsibon quidistu caposh. Aidëmbi nuqui tantienquio yaidtedi tantiametsiash. Aidbimboecquidien mibi nechitec —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Mimbi chiaidquiobini nec —quepac caondash Esus chido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Adnubini pete bedtanec chopondac. Adshun isquien chidobëd onquepec. Adsho isash: —¿Atotsi chiec chidobëd onquepec? —quepondabi utsibëd otacquio onquec. —¿Atotsi chiec chidobëd onquio? —cainquio iccondambi Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Adec ëbi chonobi tëchu nianec acte uec choquid chido nidpondash aton matses chiec shubuno nidec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Isec cho. Ëmbi isacmaid dadan ëmbi naid abitedi chioshi. ¿Nuquin Papa yacnuësh choquid Quidistu caidta nioshe? En isec cho —catuidac: ");
INSERT INTO mcfNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","—En isnu. Nid. Aidien nechitashe. Isnu —quianec matses dadpen cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aido choabi icnubi: —Në pete, Icbo —ëmbi caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Padi. Mimbi tantienquio yaid con na utsi iquec —quepondash Esus petepenquio chiequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Adsho tantiashini pete ca danec: —¿Utsibonda pete bëshumpash? —quecuededpondac ëbitedi. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Adsho tantiash Esus: —Ëbi cuishoncamete utsi iquec. Ëbi chomiondaid Nuquin Papan chiacpadomboen naic bëdambo iquebi pete piacbimboec. Ambi chiaidtedi nainuec dayacquio iquebi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Adashic padpidec: —“Ushë daëd-daëdquiecnuc nidmeshun nadquid adosbiecquid ëshëacsho bedembi,” quepec nuquin matses. Adosbiecquid ëshëacpaden ¿yuecshunda nëmbo icquidon ëbi tantiabempec? Padenquio. “Nëidon Esus tantiendac,” mimbi cacmaidobi cho-choeque. Is. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Acte uequid chido ëmbi chuiboedën chiac matses dadpen cho-choeque. Chuibanuna. Ëbi tantiash Nuquin Papabëd tabadtequid yanendac. Adsho isash nuqui cuishonquendac piucquid bedashbimboec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tied icbon: “Con na peta,” cac ambi nidtsinacmaid matsesën bedec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aden ambi nitsinacmaid bedacbimboen mimbi naic. Utsibomba Nuquin Papan chiaid chuibanëdaido nëmbo icquido mimbitsen chuibanec. Adoac nëmbo icquidon Nuquin Papabëdta ëbi tantiabenec. Cho-choeque. Is. En chuiban —capondash Esusën abëd icquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Adnubien Esusbëd onqueboed chidon chuitanaido cho-chopondash. —“Comapenen tantiaquin ëmbi naid abitedi chioshi,” quioshe. Nuquin Papa yacnuësh choquidien nechitashe. Isnu. Nid —quianec cho-chopac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cho-choquimbi badedi: —Ëbi yacno ushquin chiec cho —quequin beduanac Samadia yacno tabadquin chuibampondash Esusën. Aid matses chiec ambo daëdec ushpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aden Esusën chuisho tantiashien: —Nuquin Papa yacnuësh choquid Esus nec —quiampondash anocquido dadpen. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Adashic acte uequid chido chiec: —Mimbi chuishouidi tantiaboedëmbi nëembi aidënquio chuisho bëdamboen tantiaquioc. “Nuquin Papa matses bëdamboen ismequid nec,” quequin tantiembi —quiampondash Samadia yacnocquido dadpen. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Daëdec ushanec Samadia yacnuësh Esus nidondash. Abi caniondacno nidaid Cadidia caid yacno nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","—Ëmbi chiacpaden abi caniondacnoshon Nuquin Papan chiaid chuibanquidën chuisho aton matsesën tantienquio iquec. Con nidaidën nidsho con matsesën abi chuiquid dapa icmetiapimbo icpebi —quianec aton nidaidën chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Adsho isun: —Tantiesa nendac —Esusën caboedombi abi bëdiactsëc tantiatsëccondash. —¿Choecta icco? Nuquin Papan nuquin tsusedpabo unës uainquio icquin matamiampid inchësh tantianuec Edusaden yacno nidshun mimbi nadatiambo icquin nabansho isondambi —quepondash abi bëdiactsëc tantiatsëcquido Esus chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Adec aton nidaidën nidequi ambi actequid uaondacno Cana yacno nidpondash Esus. Adnubien shubu dadpen icquid utsi Capednaun caid yacno con matses chuiquid dapa icpac caondash. Aidën mado unës-tiadtsëcquio yampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Adashic: —Esus Udeya yacnuësh choac caoshe. Istanu —quianec chopac caondash unëstiadtsëcquio icquidën papa. Adec Esus yacno choshombien: —Con mado unëstiadtsëcquio iccoshe. Bëdamec cho —caqui ");
INSERT INTO mcfNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","nidenquio yec abi datsidadquido chiec: —Ëbimbo mimbi tantienquio iquec. Ëmbi bëdameteuidtsëqui mimbi tantiec. Ëmbi comapenen tantiaquin nabansho isunuidtsëqui: “Nuquin Papan chomiaidien nechitec,” quequin mimbi tantiec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Adec onqueshobien abi niacbidanquin padpiden: —Baded cho. Con mado unëstiadtsëcquio iccoshe —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Adoaquien Esus: —Padi. Min mado unësenquio ye. Nidec nid —quesho tantiash: —Abimbo caic —quianec nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Adec nidquimbi abi chuinuec cho-chosho aton yuabo bëquedac caondash. Aden bëquedaqui yuan: —Min mado bëdanosh —quesho tantiashun: ");
INSERT INTO mcfNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Mitsimbo ushë icnuc con mado bëdanosh? —cac: —Ënden ushë yaquëduidtsëcnubi da una yantsëcnubi bëdanosh —quepac caondash aton yuabo. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Adsho tantiash: —Adënquioshendabi: “Min mado unësenquio ye. Nidec nid,” caposh Esusën —quepac caondash unëstsemboedën papa. Adshun: —Nuquin Papan chomiaidquio yec comapenen tantiaquin nabanquidquio Esus nec —quequin aton shubun icquidobëdtambi Esus tantiapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Adec Udeya yacnuësh choash Cadidia yacnobidi ambi uba chinaid actequid uaquin ismequin tauaondacnobidi tabadquin bëdamequintsen Esusën ismepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuecquio ictanec Esus: —Edusaden yacno cuëdënuec nuquin matses cho-choeque. Nuquitsen nidnu. Nid —quianec nidanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Shubu dadpen icquid Edusaden caid dacuenadquin daquënë uaid puduedte shëcuë dadpen icnuc abentsëc obeca puduedte caid icpondash. Aid anoentsëqui acte tiquidimbo icquid icpondash. Aid con onqueten Betesada capondash. Ambobi daicsaido tabadte shubumpi mëdantetedi icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Acte nënantanquio icnuc dacuenadquiec shubumpi tabadquidën matses dadpen tabadpondash daicsaidouidquio. Bëshuaido yec capuenquio icquido yec canite tsasiaido yec quec tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","—“Nuquin Papan abi yacnoshon uaid mayan bëdan tëccuascaid acten abia mentoadquid bëdanquid,” quedeneque. Tëccuascaic ma chobono —quiash cainec tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Adnubien Esusën ënden caniaidquio ambobi uesho istuidpondash. Ëndenquimboshë aton dada icsabudash seta dadpen 38tedquiobi matamec capuenquio yec icsabudtsaidquio nepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Adsho istuidshun: —Ëndenquio daicsabudaid nec —quequin tantiashun: —¿Bëdanteda bune? —catuidpondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Adoaquien: —Ai ¿mitsipadequini bëdampe? Ëbi bëdiactsëcquio nidnuc utsiba badedquio mentoadteniosh. Ëbi buanquin mentoquid nibëdec —quepondash daicsatsaid. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Adshobien Esusën: —Min ushte nacnentanquin buanec nid —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","badedquio aton dada bëdantanquin aton ushte buanec nidpondash. Aid ushë chonoadenquio icte ushë niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aden buanshobien con matses chuiquidon: —¿Chonoadenquio icte ushënda ushte buampaid? Chonoadte ushëmbien ushte buanquid. Tsusedpabon dada uapampid ma mimbi niacpayoc —quequin chushcapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Adoaquien: —Ëbi bëdameboedën: “Buanec nid,” cac mambi naiyoc —quepac caondash Esusën bëdameboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Adsho tantiashun: —¿Tsuntsin naosh? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","—Tsaudi. Ëmbi isacmaid ëmbi isquiambobi badedquio nidaccosh matses dadpen icnuc —quepac caondash bëdameboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Adshumbic Nuquin Papa tabadte shubu uashunaid daquënë uacno puduedshun ambi bëdameboed daicsacboed Esusën istuidpondash. Istuidshumbien: —Tantia. Mibi chuinu. Ëmbi bëdameboedquio mibi neque. Mimbi icsamboen naid ënash bëdambo icta. “Nuquin Papan cuidquiac bëdanenquio yec daicsabudquiochitomane,” quiash adta —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Adoaquien bëdameboed abi: “¿Tsuntsin naosh?” caboedo chiec nidpac caondash. Nidshumbic: —Ëbi bëdameboed Esus niosh —quequin chuituidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aden chuisho tantiatanequien: —Chonoadenquio icte ushënuidi bëdamepac caosh. Icsambo iquec —quequin con matses chuiquidon Esus chieshëmpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Adnubien: —Mibi adosh —quesho tantiashun abi chieshënquido istuidshun Esusën naden chuipondash. —Mimbi Nuquin Papa caid con Pa ënenquio icquin matses nashunquidquio nec. Adecbidi ënenquio icquin matses nashunquidquio nebi. Chonoadenquio icte ushëmbidi con Pabëdtan adoquid nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Adsho tantiatanequien: —“Chonoadenquio icte ushën naquid icsambo iquec,” nuqui caboedquio: “Nuquin Papambo con pa nec,” quiosh. Adquid icsamboshë iquec. “Nuquin Papapadquidquio nebi,” quechitequien nioshe. Cuesunequimbien ictiad —quepac caondash con matses chuiquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Adec abi chieshënquido abi cuesunete bunshobien padpiden istuidshun chuipondash Esusën. —¿Ëmbimbo naidtambi nadio? Padenquio. Con Pan nasho isun aidën nacpadomboen mambi naboc. Adomboembidi Con Pan nacpadomboen naimbi. Ëmbentsëqui natiapimbo iquebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ëbi tantiaquin Con Pan ambi naidtedimbo ëbi tantiamec. Ambentsëqui nainquio iquec. Aidën tantiamiacpadomboen bëdiactsëc naquin nëid capuenquio icquid bëdamiombi. Adembidi ambi tantiamiacpadomboen naquin dacuëdampamboecnuc naindambi ma isquionoeshun. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Con Papadquidquio yec unësaid uincuemequidquio nebi. Matses ëmbi tantiaidotedi ëbëdi tabadmenuen uincuemendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","¿Ëbi tantiesabo cuidnuen ambiuidtsëqui chuiquidta con Pa nedic? Padenquio. Ëmbien ambi chiacpadomboen naden chiendac. “Nëid nuqui tantiaquid neque. Nuquibëdi tabadmenuna. Nëid ëbi tantiesa icsambo icsho cuidnuna,” caindambi con Pa. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aidëmbi: “Ëbi tantiacpaden ma con Madotsen bëdamboen tantianu,” queshun aden matses cuidte chuiquid icmiondashi. Ëbi adquid icmiondaid icsho ëbi tantiatiapimbo icquidon ëbi chomiondaid Nuquin Papatsen tantienquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","¿Muectabi nedi? Abimbo chuinu. Tantia. Ëbi chomiondaid con Pabëdtan ëbi tantiaquid unësacsho cuidenquio icquin ëbëdi tabadmendambi. Cuidtequid icboedi ëbi tantiash ëbëdi tabadtequid yanendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Adashic padpidec onquec: —Tantia. Mibi padpiden chuinu. Unësaidën tantienquio yacbimboen ëbi tantienquio icboedombi ëbi tantiabensho bëdamboen tantiamequin bëdamboec tabadquid icmendambi. Adshun aido unësacsho uincuemeshun ëbëdi tabadmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Con Pan icmiacpadequi unësaid uincuemequid nebi. Abibi unëstiapimbo icquid icquin unësaid uincuemequidquio con Pa nec. Ambi icmiacpadquiequi abi yacpadquidquio iquebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Adec unëstiapimbo iccondaidi matsesash icsaisambo icsho Con Pan matses icsaido cuidquid icmiondashi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ëbi adsho tantiashun: “¿Abimbobida capeba? Muequien nechitec,” ëbi cainda. ¿Muectabi nedi? Padenquio. Con Pan tantiacpadënquio ëmbi cuënac unësaidotedi uincuenendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Adec uincuenacsho ëbi tantiaquido ëbëdi tabadmequin ëbi tantiesabo icsaido cuidacno nidmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ëmbentsëqui nainquio iquembi. Con Pan chiacpadomboen naquin matses cuidte chiendambi. Matsesën naidtedi tantiaquid icquin adoendambi. Ëmbi naid nainquio icquin Con Pa bëdambo icmenuen aidën chiacpadomboen naimbi —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Adshumbic Esusën abi chieshënquido chuioapondash. —Nuquin matsesën naden chiec. “Abentsëcshun chiaid icsambo iquec. Daëdshun chiaid abimbo iquec,” quequin chiec. Aden chiaid tantiec ëbiuidtsëqui: “Nuquin Papan Mado nebi,” quesho tantiashun: “Abimbo mimbi caic,” mimbi ëbi catiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ëbi tantiaquin abimbo chuiquid ma utsi iqueyoc. Nuquin Papambini: “Con Madombo nec,” caindac. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aden ëbi chuiquid utsi acten mentoanquid Uan pado icpadenec. Aidëmbi ëbi abimbo capadenec. “¿Nuquin Papa yacnuësh choquidta ne?” quequin mimbi chuitanac: “Padenquio. Esusuidi Nuquin Papa yacnuësh choquid nec,” quepadenec Uan pado. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Aden chieshtoenquio icquin bëdamboen chuipadenec. Chuisho tantiatsash mibi bëdambo icuidtsëccondac. “Ëmbi Uan padon naid chuisho tantiashun: ‘Abimbo mimbi caic,’ ëbi capashun. Ëbi adosho bëdamboen istsiambi,” quequin mimbi tantiondaid Uan caombi. Matses icquimbi Uanën ëbi bëdiactsëc tantiamequin chuipadenec. ¿Adquid matsesënuidtsëquidabi abimbo chuipec? ");
INSERT INTO mcfNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Con Pambien: “Con Mado neque. Matses ismenu,” queshun comapenen tantiaquidquio icmepondashi. Ambi adomiaid icquin comapenen tantiaquin nabanquin ëmbi ismesho isash: “Ai, adquid nec,” quetiadquidi mibi nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ëbi chiecbidi onquequin Nuquin Papan nuquin tsusedpabo dada uamepampic. Adecbidi Nuquin Papa onquesho ¿ada mimbi tantiapadio? ¿Nuquin Papada istio? Padambo mimbi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Adembidi ambi dada uamequin chiampidquio ma mimbi bëdamboen tantienquio yoc. Aid bëdamboen tantiashumbien Nuquin Papan chomiondaid ëbitsen mimbi tantiatsiac. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mibi nadpec. “Nuquin Papan chiaid nuquin tsusedpabon dada uampid tantiaquidquio nebi. Aid isbanquid yec Nuquin Papabëd tabadtequid nebi,” mibi quepec. Ma ëbimbo chuiquin Nuquin Papan dada uamepampid neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Aden dada uamepampid isbanquidombi mimbi ëbi tantienquio iquec. Ëbi tantiashoembi mibi Nuquin Papa yacno ëbëd tabadmetsiandac. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ëbi adsho tantiashun ma matsesën ëbi: ‘Bëdambo mibi iquec,’ canu,” ¿quectabi ique? Padenquio. Con Pan chiacpadomboen nanuembimbi aden chioc. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ëbi tantienquio icsho isun: “Nuquin Papa tantiesabo nec,” quequin mibi tantiembi. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ëmbien Nuquin Papan chiacpadomboen naic. Aden nasho mimbi ëbi tantienquio iquec. Utsi: “Nuquin Papa yacnuësh choquid nebi,” quec muaquidien mimbi badedi tantiatsiac. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mibibi tantiadec: “Mibi bëdambo iquec,” cananteuidi bunquin mimbi Nuquin Papa tantiatiapimbo iquec. Aden mimbi Nuquin Papa: “Mibi bëdambo iquec,” cametiapimbo iquec —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Adashic padpidec: —¿Ëmbentsëquidambi: “Ëbi tantiesabo neque. Cuidnuna,” quequin mimbi naid Nuquin Papa chuipe? Padenquio. Mimbi tantiaidënquio Moisesëntsen: “Nëido icsambo iquec,” mibi caindac. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aidën chiampid bëdamboen tantiaquimbien mimbi ëbi tantiatsiac. Aidën chiampidi mabi neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aden Moisesën chiampid tantienquio icquin ëmbi chuiboedtsen mimbi tantiatiapimbo iquec —quequin Esusën abi chieshënquido chuipondash: —Moisesën chiampid tantiaquidquio nebi —quequido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yuecquio ictaniash Edusaden yacnuësh nidec Cadidia yacnobidi Esus nidpondash. Ambo nidash chian dapa Cadidia caidbidi budash cano antabëdtoshon potiacpondash. Aid chiambidi matses utsibon Tibedias capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","Poteshun nandoash pudundoanec macuësh dapa dectatoash macuësh poctsebi tabadtuidpondash. Ambo tabadquin ëbi chedo chuipondash. Adnubien Esusën matses dadpen bëdamesho isboedo Esus isnuec cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nuquin Papan isadaidbo unës uainquio icquin matamiampid inchësh tantianuec pec tabadte ushë nëbi yanuc niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aido cho-chosho istanequien Esus: —Uedipe, piucquid buanshun ¿mitsimbo pete bedtane nëido pemenun? —quepondash Uedipe chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","—¿Atoda queque? Tantianu —quiash adpondash Esus. —Pete bedabi icnuc ëmbibi pete uanu —quequin otacquio tantiequi adondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Adoaquien Uedipe: —Ma aidtedquio pemetiapimbo yoc. Inchëshën ushë 8tedquiobi nidmec chonoadshun bedaidtedimbo piucquid menequin pete bedshun: “Pemenu,” cac aidtedquio pemiadenquio ictsiash —quepondash Uedipe. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Adnubien Andedesën Petedon utsin: ");
INSERT INTO mcfNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ma në madompin panëmpi 5tedtsëc icpayoc, Icbo. Nuëcquidëmpi daëdquiobi ictsec. Matses dadpenquio iquec. Aidtedtsëcquid pemetiapimbo iquec —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Esusën: —Padi. Aidi bëdambo iquec. Abitedi: “Nëmbo tabad,” caban —cac: —Nëmbo tabad —cabanac sebad-sebadpambo icquidën uasinën matses dadpenquioshë tabadbudpondash. Dadauidtsëqui tambanac 5000ted icpondash. Chido bacuëbobëdta tambanambo icpondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Adshumbien Esusën madompin pete pamba bedtanquin Nuquin Papa chuipondash. —Pete uaquid yec mibi bëdamboshë iquec. Mimbi uaid nëid pete bëdambo iquec, Papa —quec onquetanquin: —Meneban —cac abëd icquidon tabadquido abitedi menebampondash. Adotanquimbic nuëcquidëmpitsen bedtanquin adembidi Nuquin Papa chuitanquin menebanoapondash. Adoac utsibon ambi piactembi pebedednubi utsibon ambi piactembidi pebededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aden ambi piactembi pebededacshobien Esusën: —Napi uaid secainda. Sandoshon dayun ua —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tsitsan dapan napiuaid sandoshon dayun uapondambi tsitsan 12tedquiobi sandoaid icnuc. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aden pemiaquien pemiaido: —Comapenen tantiaquin Esusën pete dadpenquio icmiac. Moisesën chuipampidshenda nepec. “Nuquin Papan bëdamboshë icquid chomendac,” capampidshenda nepec. Aidien nuqui chuiquid dapa icmetiad —quepac caondash Esus tantiamenquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Adsho ambembi tantiashien: —Abi chuiquid icmenuen ëbi “Bednu,” caique. Nëbi abi chuiquid ictiapimbo iquebique. Cuenu —quianec abentsëqui cuempac caondash Esus macuësh dapa dectatoec nidec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Esus cuembon inchëshbudtsëqui chian budondabi ëbitedi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","—Capednaun yacno nidnu —quec cano antabëdtoshon potenubi inchëshpondash Esus acte bëntse chopanushta. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Adnubien cunquequid dapa cunquetuidpondash. Acte comapenec tëccuasquenuc ");
INSERT INTO mcfNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","uncadenquio yampondash. Ënapen nidabi nëbi 6 quidometedos cactiontsëqui nidshun isquien matsesbimboec acte bëntse chopec. Adsho istanec dacuëdquiondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Adshobini: —Ëbi neque. Dacuëdenda —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Adoac: —Esus nec —quetanquin badedi antsadtomiondambi. Aid antsadtometanquin badedquio potepondambi. Nandoash ambobi ushondabi Capednaun yacno. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Adnubien abi pemebocnobi matses ushpac caondash. Badiadnuc isucunshun isaquien Esus nibëdec. Nibëdsho isashien: —Ma cano abentsëcquidëmbi abëd icquidon potepaboc. Ma aidbëd nidenquio icpaboc. ¿Mitsimbo nidpash? —quepac caondash pemiaido. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Adnubien shubu dadpen icquid Tibedias caid yacnocquidon cano dadpen bë-bëpac caondash. Pete pemebocno anoentsëqui nando-nandosho isash: ");
INSERT INTO mcfNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","—Potequimbien Esusën yashe. Nëid canobi antabëdtoshon potenuna —quetanec antabëdtoshon potiac-potiacpac caondash. Potiac-potiacash Capednaun yacno pudundoshon ");
INSERT INTO mcfNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nuquin Papan chiaid chuibante shubun abitedi puduedshun Esus istuidpondash. Istuidshun: —¿Mitsipaden potio, tsusio? —caquien: —Naden —quenquio yec: ");
INSERT INTO mcfNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","—Tantia. Mibitedi chuinu. ¿Ëbimbo tantianuecta chodio? Padenquio. Ëmbi pete uasho isash: “Nuquin Papan namiaidën naoshe. Istanu,” ¿quecta ictio? Peteuidtsëqui tantiaquin ma mimbi ëbi nibëneyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Peteuidtsëqui tantiaquin pete bednuen naquidquio ma mibi neyoc. Aidquio chodquetequid nendac. Chodquetiapimbo icquid tantiaquin bëdamboen nata. Aden nash ëmbi icmiacpadquiec Nuquin Papabëd tabadtequid mibi yanendac. Nuquin Papan: “Con Mado neque. Ismenu,” quequin namiacpadomboen comapenen tantiaquid icquin mibi adquid icmetsiambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Adsho tantiash: —“Nuquin Papan chiacpadomboen nata,” quepequien mibi iquec. Adomboen natiadquio icquin ¿atotsimbi nape? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Nuquin Papan chiacpadomboen natiadquio icquin ambi chomiondaidquio tantiata —quepondash Esus ambi pemiaido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Adoaquien: —¿Mimbi aden chuishouididambi: “Adquid nec,” quequin tantiape? ¿Atotsi utsi comapenen tantiaquin mimbi ëbi ismepatsia? ");
INSERT INTO mcfNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“Ëndenquimboshë pete nibëdacnoshon Moisesën con tsusedpabo nibedbëdi sequiaid pete pemianepampic,” quequin dada uapampid isombique. Adquid nacnenquin ëbi isme —quepondash pemiaido peteuidtsëqui tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Adoaquien Esus: —Nuquin tsusedpa Moisesën nainquien icpampic. Con Pambien aden pemepampic. Nëbi ambi chomiondaid petebimboecquid utsien Nuquin Papan mibi tantiametiadquio iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aid petebimboecquidën matses bëdambo icmetsiash pete piacbimboecnuc —quepondash Esus abibi cadequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Adsho tantiash petembo ca danec: —Ënenquio icquin adquid ëbi pemeta —quepondash pemiaido ambi peboeduidtsëqui tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Adshobien Esusën: —“Ëbiuidtsëqui petebimboecquid icquin matses bëdambo icmequid nebi,” caimbi. Ëbi tantiaquid ënenquio icquin bëdambo icmendambi petebëdi acte bundoenquio yacbimboecnuc. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ëmbi chuibocpadomboen ma mimbi ëbi tantienquio icboc. Ëmbi comapenen tantiaquin nabansho isumbi ma mimbi ëbi tantienquio icboc. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Utsibombien ëbi tantiendac. Nuquin Papan tantiamiaidtedishun ëbi tantiasho bëdamboen isquin cacumenquio iquendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","¿Ëmbi tantiacpadomboen naquidtabi nedi? Padenquio. Nuquin Papan chiacpadomboen nanuec mabi abi yacnuësh chondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aden aidën chiacpadomboen nanuen ëbi tantiaquido unësacsho uincuemeshun cuidenquio icquin ëbëdi tabadmendambi. Unësaid abitedi uincuemete ushën adoendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nuquin Papa bunacpaden ëbi tantiaquido uincuemeshun Nuquin Papa yacno ëbi tabadacnombo tabadmendambi —quepondash Esus ambi pemeboedo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Adec: —Nuquin Papa yacnuësh chondaid yec petebimboecquid nebi —quesho tantiashien con matses chuiquido: ");
INSERT INTO mcfNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Adquidida nepec? Ma icsamboen chuipayoc. ¿Nuquin Papa yacnuësh choaidta nedic? ¿Nuqui isacmaidta nedic? Ma Esus cuëmëdquid neyoc. Ma Osen mado neyoc. Anitsen tantiembi. Matsesën tishaid Nuquin Papa yacnuësh choquid ictiapimbo iquec —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Adshobien Esusën: —Shoshquetsëcquin ëbi icsamboen chienda. Abimboembi caoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ëbi chomiondaidën Nuquin Papan tantiamiabi yaido icquin mimbi ëbi tantiatiapimbo iquendac. Nuquin Papan tantiamiaid icquin mimbi ëbi tantiatsiac. Aden Nuquin Papan ëbi tantiamiaido unësacsho unësaid uincuemete ushën uincuemendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aden Nuquin Papan tantiamete chuiquin nuquin tsusedpan dada uapampic. “Nuquin Papambien ambi bëdamboen iste matses tantiamendac,” quequin chuipampic. Aden Nuquin Papan tantiamiaido ëbi tantiaquido yantsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ambi tantiamiaidën matsesën Nuquin Papa ispash,” quenquio iquebi. Ëmbiuidtsëqui abëd icquin Nuquin Papa isondambi. Aden abëd icquin abi isondaidi matsesondabi —quepondash Esus: —Matsesi nec —abi caquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Adashic padpidec: —Abimbo caombi. Ëbi tantiaquido Nuquin Papa yacnombo ëbëdi tabadmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Petebimboecquid icquin aden tabadmendambi. Adecbidi bëdamboec tabadmianquid nebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nuquin tsusedpabon pete utsi nibëdacnoshon mana caid pepampic. Aid pequidi tsusiobudash unëspampic unëstiapimbo icquid yanabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Petebimboecquid utsien Nuquin Papa yacnuësh chondaid nëmbobi iquec. Aid piash ëmbi chiacpadquiec padpidec unësenquio yec Nuquin Papabëd tabadtequid yanendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Adquidquio nebi. Con nami piash matses unëstiapimbo icquid yanendac. Adquidquio matses icmenuec ëbided cuidadquin con nami menendambi —quepondash Esus ompoacbimboen chiec. —Ëbi tantiaquido nëbi bëdamboen tabadmeshun unësacsho Nuquin Papa yacno ëbëdi tabadmendambi padpidec unëstiapimbo icnuc —quequin tantiec: —Petebimboecquid icsho ëbi piash matses unëstiapimbo icquid yanendac —quepondash Esus. —Ëbi tantiaquido cuidmenquio icnuec ëbided cuidadec unësendabi —quequin tantiec: —Con nami menendambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Adec: —Con nami piash matses unëstiapimbo icquid yanendac —quesho tantiashien namimbo ca danec con matses chuiquido onquecuededpondash. Utsi-utsiec: —¿Mitsipaden Esusën aton nami nuqui pemepatsiash? Aidquio tantiatiapimbo iquebi —quecuedednubi utsi-utsiec: —¿Atotsi chuitiadquio yec niosh? Chuisho tantianu —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","54","Adsho tantiashun Esusën ambi chiacpadomboembidi chuioapondash. —Tantia. Mibi chuinu. Matses tantiaquidquio nebi. Aden tantiaquiec ëbided cuidadec unësendabi. Ëbi adec unëso isun con nami pequinc con intac acquinc cash nidaidënuësh bëdamboec tabadquid yanash Nuquin Papabëd tabadtequid mibi yanendac. Adquid icsho unësaido uincuemete ushënquio uincuemendambi ëbëdi tabadmenuen. Ëmbi chiacpadomboen nainquio yash Nuquin Papabëd tabadtiapimbo mibi iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ai, con nami petebimboecquid nec. Con intac actebimboecquid nec. ¿Petebëdi acte naimëdanda mibi bëdambo icpatsia? Adecbidi con intac chididiquec con nami icsabudec ëbided cuidadec unësaid tantienquio yec mibi bëdamboec tabadtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aden ëmbi namibëdta intac chuisho bëdamboen tantiashun ëmbi chiacpadomboen matsesën natiadquio yanendac. Adsho isun aidbëd tëshnanenquio icquin bëdamboec tabadquid icmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nuquin Papa unëstiapimbo icquid yec matses uincuemequidquio nec. Aidën chomiac ambi namiacpadomboenuidi naquin ëbi tantiec tabadquid unësacsho uincuemequin unëstiapimbo icquid icmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aden ëmbi naid tantiamenuec: “Nuquin Papa yacnuësh chondaid petebimboecquid utsi iquec,” quiobi. Ëbi adquid icsho isash ëbi tantiaquid Nuquin Papabëd tabadtequid yantsiash. Nuquin tsusedpabon pepampidpadquidpenquio nebi. Adquid pequidi tsusiobudash unëspampic. Ëbi tantiaquidien padpidec unëstiapimbo icquid yanendac ");
INSERT INTO mcfNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","—quepondash Esus Nuquin Papan chiaid chuibante shubunuësh Capednaun yacnuësh. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Adec: —Con nami pequinc con intac acquinc cash mibi bëdambo ictsiac —Esus quesho tantiashien abëd icquido utsi-utsiec: —Aidën chiacpadomboen natiapimbo iquebi. Icsamboen chiec —quepondash Esus tantiamenquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Adec onquesho ambembi tantiash Esus onqueoapondash. —¿Ëmbi chuiboed tantiash chieshtotiadquioda ique? ");
INSERT INTO mcfNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nuquin Papan matsesmiaid yequi unësash ëbi iccondacno ëbi nidacsho isash ¿atoda mibi quendac? Abimbo caombi. Nuquin Papa yacnuësh chondaidini nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Namimbo intacquiobëdta ca danequien mibi nec. ¿Namimbo pequinc intacquio acquinc cashta mibi bëdambo icpatsia? Padenquio. Nuquin Papan Mayanën ëmbi chuiboedbëdta ëbi tantiamequin matses bëdamboec tabadquid icmetsiash. Adoaid unësash Nuquin Papa yacno ëbëdi tabadtsiash —quepondash Esus cuembo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Adashic padpidec: —Ëmbi aden bëdamboen chiaqui utsin-utsinquien mimbi ëbi tantienquio yanendac —quepondash abi tantiauidquido chiec. Aido tauamboec abëdi nidnuc: —Nëidën ëbi tantienquio yanendac. Nëid utsin ëbi chieshënquido ëbi bedmendac —quequin ambembi Esusën tantiapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Adashic padpidec: —Ëbi tantiauidquido tantiaquin naden chiombi. “Nuquin Papan tantiamiabi yaidën ëbi tantiatiapimbo iquendac. Nuquin Papan tantiamiaidënquien ëbi tantiatsiash,” quequin chiombi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Adsho tantiashun dadpenshun Esus nianondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aden nianaquien Esusën abëd icquido 12ted icquid chuipondash. —¿Mimbitsendabi niampe? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Petedo: —Padenquio. ¿Tsudabëd icnuendambi mibi nianuc? Mibipadquid utsi nibëdec. Mimbiuidtsëquien: “Ëbi tantiaquid bëdamboen isquin unësacsho uincuemeshun ëbëdi tabadmendambi,” quequin chuipoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","“Abimboen caosh,” quequin mibi tantiembi. “Nuquin Papa yacnuësh chonëdaid yec bëdamboshë icquidquien nec,” caombi mibi. Mibi niantiapimbo iquebi —quepondash Petedo Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Adoaquien Esus: —Ai, mibi adquid icnuc utsien icsambo iquec. Mibitedi: “Nuquibi icnu. Cho,” cabampondambi. Ëmbi adondaid abentsëc Satanasën namiaidquio yec icsamboshë iquendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","—Simon Iscadioten mado Udasën ëbi chieshënquido ëbi bedmendac —quequin ambembi tantiash adondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Abi tantiauidquidon nianac Cadidia yacnouidi yuec Esus capucuenepondash. —Nidaid Udeya caid yacnocquido con matses chuiquidon ëbi cuesunetiadquio iquec —quiash Udeya yacno nidenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Adnubien con matses abitedi: —Edusaden yacnuësh cuëdëntanu —quiampondash. Adanec nidaid utsi Udeya caidën nidec 7tedec ushec cuëdënuec matses dadpen nidacno Edusaden yacno nidanepondash. Cuëdënuec Esus nidenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Adec nidenquio icsho isumbien aton utsibon: —Edusaden yacno nidec nid. Mibëd ictiadquio icquid ano icnushe. Comapenen tantiaquin nabanquin aido ismec nid. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","¿“Ma matses dadpenshun ëbi tantianu,” quequinda matses daëdpactsëc yacnoshonuidi napec? Matses dadpen yacno nidshun comapenen tantiaquin nabanquin ismec nid —capondash aton utsibon. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","—Nuquin Papan chomenëdaidquio nec —quequin tantienquio icquimbi adopondash aton utsibon. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Adoaquien Esus: —Matses dadpen nidnuc nidtiadquio yec mibia nidta. Abitedishun isnuc nëbi nidtiapimbo iquebique. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mibien anocquidon chieshëntiapimbo ye. Mibia nidta. “Nuquin Papan chiaid niac-niaquec mibi icsaic,” ëmbi cac chieshënondashibique. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","“Cuesunenushe,” quiash nëbi nidtiapimbo iquebique. Mibia nidta. Nuquin Papan tantiacpadec nidendabi ");
INSERT INTO mcfNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","—quiash anobi Cadidia yacno Esus tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aden aton utsibo nidanemiash yuec-yuecpactsëc ictanec abitsen Esus nidpondash Edusaden yacnuësh cuëdënec nidec. Abitedi ismenquio yec tsyuec Esus nidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Adnubien con matses cuëdëncuededacnoshon abi chieshënquidon Esus nibëmpac caondash. —¿Mitsimbo icpec? ¿Ada nëmbo chosh? —quequin chuibenepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Adsho tantiash con matses Esus chieshënquido dacuëdënec utsibo tantiamenquio yec sho-shoshquetsëcquiec onquepac caondash. Utsi-utsiec: —Esus bëdamboshë icquid nec —quenubien utsi-utsiec: —Ma icsambo icquid neyoc. “Nuquin Papa yacnuësh chondaidini nec,” quec ma muequi neyoc —quec onquecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Adnubien con matses cuëdënec taëbon abentsëc choec ushash Nuquin Papa tabadte shubu uashunaid daquënë uaidën Esus puduedpondash. Puduedshumbic Nuquin Papan chiaid chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Adsho tantiash: —¿Mitsipaden tantiashun chuipen naic? Nuquibëdtan Nuquin Papan chiaid isbanambo aidën iquec —quepondash con matses chuiquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Adsho tantiash Esus: —Ëmbembi chienquio icquin ëbi chomiondaidën chiaidquio chiec nebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nuquin Papan chiacpadomboen natiadquio icquidën bëdamboen tantiatsiash. Ëmbi Nuquin Papan chiaid chuisho tantiash: “Nuquin Papan chiaidquio chiec nec,” quequin tantiatsiash. Ëmbembi chuisho tantiash: “Ambembi chiaid nec. Nuquin Papan chiaidpenquien nec,” quequin tantiatsiash Nuquin Papa tantiaquidën. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ambembi chuiquidën: “Mabi matsesën bëdambo canu,” quequinuidtsëqui chuibantsiash. Adquidpenquieni nec. Ëmbien: “Ëbi chomiondaidquio ma matsesën tantianu,” quequin ambi chiaidquio chiendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mimbien adoenquio iquec. Mimbi tantiaid nuquin tsusedpa Moisesën: “Cuesunenda,” quequin Nuquin Papan chiaidquio dada uapampic. Ëbi: “Cuesunenu,” caquin aidën chiaid ma mimbi niac-niaqueyoc —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Mimbi ëbi: “Cuesunenu,” caoc —Esus quesho tantiashumbien ano tabadquidon: —Podobitsi icsa dapuduedash mibi tantiadenquio yec onquepec. ¿Tsuntsin mibi cuesunepatsiash? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Adoaquien Esus: —Nëidën ëbi cuesunetsiash —quequin chienquio yec: —Chonoadenquio icte ushën comapenen tantiaquin dada bëdamepondambi. Aden bëdamiacsho isash: “Adopenshenda naic. Chonoadenquio icte ushën daicsatsaid bëdamequin Nuquin Papan chiaid niac-niacposh,” ma mibi quepondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","¿Ëmbentsëquidambi chonoadenquio icte ushën nadi? Ma min matsesën adoapaboc. Mimbi tantiaid Moisesën chiaid tantiaquin dada bacuë tishacsho 7tedec ushun shui dëbid dëteshunequid mibi nec. Moisesën aden tauambo iquec. Moises tishabi icnubien Nuquin Papan chiacpadomboen naquin: “Nuquin Papan yuambo nebique. Ismenu,” queshun Abadauanëmbien shui dëbid dëteshunequin tauapampic. Yuecquio ictaneshun adembidi Moisesëntsen adopampic. Nëbi adembidi naic chonoadenquio icte ushëmbi chonoadquimbi ma mimbi shui dëbid dëteshuneyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Aden Moisesën chiampid niaquenquio icquin shui nacnenquin mimbi bëdamboen naic. Ëmbitsen daicsatsaid dada abichobi bëdamequin mambi bëdamboen naondac. ¿Atotsi quequin ëbi chushcai? ");
INSERT INTO mcfNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Chonoadenquio icte ushën dada bëdamequid icsho: “Icsambo mibi iquec,” mimbi ëbi capec. Aden ëbi bëdamboen tantienquio icquin mimbi icsamboen chiec. Ëbi bëdamboen tantiaquioshon ëmbi naboed bëdamboen chui —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Adec Esus: —Chonoadenquio icte ushën naondambi —quesho tantiashien anocquido Edusaden yacnocquido nadec onquecuededpac caondash. —Nuqui chuiquidon: “Cuesunetiad,” caboedien nëid nechitec. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","En is. Abi chieshënquidobëdi tabadquin chieque. Chuisho ma chuiquidon chushcainquio icboc. “Nuquin Papa yacnuësh choquid Quidistu caid Esus nec,” quequin tantiashumbien nachitec —quetanequien ");
INSERT INTO mcfNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","aidobidi: —Nuquin Papa yacnuësh choquid ictiapimboen aid iquec. Abi caniacno tantiembi. Nuquin Papa yacnuësh choquid abi caniacno tantiadenquio ictsiash —quepondash ano tabadquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Adsho tantiashun Esusën Nuquin Papa tabadte shubu uashunaid daquënë uacnoshon chuibanquin abitedi tantiamenuen naden chuipondash. —“Ëmbi isondaid nec. Aton nidaid Cadidia caid yacnuësh caniquid nec,” ¿quequindabi bëdamboen tantiapadi? Ma mimbi padenquio yoc. Ëbembi chondaidpenquio nebi. Ëbi chomiondaid abi iquec. Ma mimbi aidquiobi tantienquio yoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ëmbien aidquio tantiendac. Aidbëd tabadondaidquio nebi. Adsho aidën: “Nid,” cac chondaid nebi —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","—“Con pa Nuquin Papambo nec,” quechitequien nec —queshun abi chieshënquidon: —Cuesunemenuembien bedtiad —quetanquin: —Bednu —caqui bedadenquio icpondash. —Nëbi ma Esus unës uainquio icnu —Nuquin Papa quenuc bedmenquio icquin Esusën mëtampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Esus cuesunetiadquio icnubien utsibon dadpenshun Esus tantiabempondash. —Nëidpadquid utsi nibëdtsiandac. Nuquin Papan chiaid chuiquin nuquin tsusedpabon dada uapampicpadomboen comapenen tantiaquin Esusën matses bëdamebamposh. Nuquin Papa yacnuësh choaid Quidistu caid Esus nec —quequin dadpenshun Esus tantiabempondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aden Esus chiec sho-shoshquetsëcquiec onqueshobien Esus chieshënquidon padiseyo caidon tantiapac caondash. Adshun abëdtan chuiquid utsibo chuipac caondash. —Ëmbi chuibocpaden Esusien bedtiad. Icsamboec onquioshe —cac: —Ai, adembien ictiad —quepac caondash. Adshumbic abëd icquido sondado chuiquin: —Baded bedtan —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Adoac nidanequin tantiatuidaquien nadec Esus onquepondash. —Yuec-yuecpactsec mibëd icashic ëbi chomiondaidbëdtsen tabadoaic nidendabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ëbi nibënquin ëbi istuidenquio mimbi iquendac. Ëbi nidacno mibi nidtiapimbo iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Adsho tantiash abi chieshënquido: —Nuqui istuidmenquio icnuec ¿mitsimbo nidpanuec nec? Matses utsi yacno tabadnuec con matses utsi-utsiec nidequi nidaniondacno nidshun ¿anocquidoda chuipatsiash? ");
INSERT INTO mcfNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tantiadenquio yec onquepec. ¿Atotsi quepec? “Ëbi nibënquin mimbi ëbi istuidenquio iquendac. Ëbi nidacno mibi nidtiapimbo iquec,” quepequien iccosh. ¿Atotsi quepash niosh? —quepac caondash Esus chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Adnubien cuëdënec ënëdte ushënquiobi con matses abitedimbo cuëdënuec cho-chopondash. Cho-choash tabadbudnubien nidtoash comapenec onquequin Esusën chuipondash. —Acte natia bunacbimboec Nuquin Papa tantiate bunquin ëbi bëdamboen tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Adsho Nuquin Papan chuiquin dada uamepampicpadomboen naindambi. Nuquin Papa tantiamequid utsi ëbi tantiaquidobëd tabadmendambi. Adoac mibëd tabadquin mibi bëdamboen tabadmequin utsibotsen Nuquin Papa tantiate bumetsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","—Nuquin Papabëdta ëbi tantiamequidquio Nuquin Papan Mayan nec —quequin tantiec adondash. Adquid abi tantiaquidobëd tabadmequin chomiabi aden chuipondash Esusën. Nuquin Papa yacno nidambien abi tantiaquidobëd Nuquin Papan Mayan tabadcuenondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","—Nuquin Papa tantiate bunquin ëbi tantiata —Esus quesho tantiashien Esus chiec ano tabadquido onquecuededpac caondash. Utsi-utsiec: —“Nuquin Papan chiaid chuiquidquio choendac,” quequin nuquin tsusedpa Moisesën chiampidien Esus nechitec —quenubien ");
INSERT INTO mcfNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","utsi-utsiec: —Nuquin Papa yacnuësh choquid Quidistu caidien Esus nechitec —quenubien utsi-utsiec: —¿Cadidia yacnuështa Nuquin Papa yacnuësh choquid chopadic? ");
INSERT INTO mcfNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Padenquio. Nuquin Papan chiaidquio naden dada uapampic. “Nuquin Papan chomiaid nuquin tsusedpa Dabidën tsyuecquid nendac. Dabid caniampicnoshon shubu daëdpactsëcquid Beden caid yacnoshon aidi tishendac,” quequin chuipampic. Ma Esus muequi neyoc. Beden yacnoshon tishaidpenquio nec —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Adec dadpen: —Bëdambo icquid nec —quenubi aidtedbidi: —Icsambo iquec —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Adnubien: —Icsambo iqueque. Cuesunemenuembien bedtiad —queuidpac caondash. Adshun Esus bedabi icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Adnubien: —Esus bedtan —caboedo sondado bedabi Esus chieshënquido chiec chopac caondash. Chosho: —¿Atotsi quiash bedabi cho? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Ma bëdamboenshë chuiboc. “Adomboen chuibanquid utsi nibëdec,” queshun bedtiapimbo iccobi —quesho ");
INSERT INTO mcfNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tantiashien: —Aid muasho tantiashun: “Abimbo caic,” ¿cainda icco? ");
INSERT INTO mcfNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Adambi Esus muasho tantiadio? ¿Ada tsusiobon tantiadiosh? Padenquio iccosh. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Utsibombien tantiash. Adquidon ëmbi bëdamboen tantiacpadomboen Nuquin Papan chiampid tantienquio iquec. Icsambo aido iquec. Aido cuidchitoshon. Esus icsambo iquec —quepac caondash con matses chuiquido padiseyobo Esus chieshënec. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Adnubien inchëshën puduedash Esusbëd onquiondaid Nicodemo caid abitsen chuiquid yec nadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Abibi chuimiabida cuidpec? Nuquin Papan chuipampid nad iquec. “ ‘Icsambo iquec,’ caidi abibi chuimequin: ‘¿Atotsi nao?’ cac chuisho tantiashun cuidquid yendac,” quepampic. Adoac bëdambo ictsiash. Chuimiabi cuidac icsambo ictsiash —quepac caondash Nicodemo abëdtan chuiquid utsibo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Adoaquien chuiquido: —Esus yacpadec Cadidia yacnuësh caniquid mibi nepanui. Aid tantiaquidien mibi nec. Nuquin Papan chiampid isbanta. Aid isbanshun: “Cadidia yacnuësh Nuquin Papan chiaid chuibanquidquio choenquio iquendac,” quequin mimbi tantiatsiac. Ma Esus muequi neyoc —quepac caondash chuiquido Nicodemo chushcaic. ");
INSERT INTO mcfNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","—¿Chuimiabida cuidpec? —quetsëcsho aden Nicodemo chushcanec abitedi nidaniac caondash aton shubuno ushec nidec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nicodemo chushcabon Esus macuësh dapa Odibos caid yacno ushec nidondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Adtanec choashic Nuquin Papa tabadte shubu uashunaid daquënë uaidën puduedpondash. Puduedsho isash matses dadpen cho-choec abi datsidadsho Esusën chuipondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aden chuinubien con matses tsusiobon aton bënëpenquio chudmesho istuidshun chido bëpondash. Moisesën dada uampid chuibanquidobëdtan tsusedpabon chiampid namequido padiseyobon Esus yacno bëshun chido nënantanquio nitsimpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Adshumbien Esus chuipondash. —Aton bënëpenquio chudmesho istuidshun nëid bëombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nuquin Papan chiaid Moisesën naden dada uapampic. “Aton bënëpenquio chudmesho istuidshun cuënoten seshunequin unës uaquid,” quepampic. ¿Adembidida mimbi tantie? —quepondash chido bëquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","—¿Atotsi Esus quepatsiash? Nuquin Papan chiampidquio chienquio icsho: “Mimbi icsamboen chiec,” catiad —quiash adondash. —¿Adembidida mimbi tantie? —caquien Esusën ëcbedenquio icquin shuebudshun mëdanten nidaid dada uapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Adshobien padpiden: —¿Adembidida tantie? —cado-cadoac nidtotanec: —Nuquin Papan chiaid niaquesambo icquin en mimbia cuënoten se —quetanec ");
INSERT INTO mcfNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","padpidec shuebudshun mëdanten nidaid dada uaoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Adnubien: —Nuquin Papan chiaid niaquesambo icquin en mimbia cuënoten se —cac: —Nuquin Papan chiaid niaquesamboen nibëdchitec. Setiapimbo iquec —quetanec nidanepondash. Tsusioboba nidanebon caniabotsen tsyuec nidanepondash chidouidtsëqui Esusbëd icnuc. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Adec nidanian Esusën nidtoquin isquien nibëdec. Nidaniac. Abi bëboedo nidaniacsho istanquin: —¿Mitsimbo nidosh, champi? ¿Mibi cuënoten sequidta nibëdosh? —Esusën cac: ");
INSERT INTO mcfNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Ai, nibëdosh —quesho tantiashien: —Ëmbimbo mibi cuënoten senquio iquembique. Mibi icsaid ënash bëdamboec tabadec nid, champi —capondash Esusën. Adoac chido nidondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yuec ictaniash Nuquin Papa tabadte shubu uashunaid daquënë uaidën Esus padpidec puduedoapondash. Puduedshumbien abi chieshënquido tantiamequin padpiden chuioapondash. —Pabiate cuembo icnuc con Pan bëdamboen iste matses tantiamequidquio nebi. Ëmbi tantiamiac ëbi tantiaquido icsateuidi bunenquio yanec bëdamboec tabadte buncuenendac. Adec ëbëd tabadtequid yanendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Adsho tantiash abi chieshënquido: —Mibentsëqui: “Adquid nebi,” quesho tantiatiapimbo iquebi. Muequien mibi nechitec. Matses daëdshun chiac bëdambo ictsiash —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Adsho tantiash Esus: —Ëbibi abimbo cadebi. “Con Pa yacnuësh chondash anobidi nidendabi,” quec muainquio iquebi. “Aton papa yacnuësh choash anobidi Esus nidoaindac,” quequin ma mimbi ëbi tantienquio icboc. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Cadidia yacnuësh choquid matsesuidien mimbi ëbi danec. Adquid danquin mimbi icsamboen chiec. Ëmbien abimbo chiec. Abimbo chuiquid icquin: “Nëid icsambo iqueque. Cuidnuna. Nëid bëdambo iqueque. Cuidenquio icnuna,” quequin nëbi chienquio iquembi. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aden chuiquin abimbo chuitsiambi. Ëmbentsëqui chienquio icquin ëbi chomiondaid Nuquin Papabëdtambi chuiquin abimboshë chuitsiambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nuquin Papan chiaidquio Moisesën naden dada uapampic. “ ‘Icsaosh,’ quequin daëdshun chuisho tantiash: ‘Abimbo chiec,’ quequid yendac. Adecbidi: ‘Bëdambo iquec,’ quequin daëdshumbidi chuisho tantiash: ‘Abimbo chiec,’ quequid yendac. Abentsëcshun chuishoen mua caquid yendac,” quequin Nuquin Papan chiaidquio Moisesën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aden Moisesën dada uampid tantiashun ëmbentsëqui chienquio iquembi. Ëbi chomiondaid con Pabëdtantsëqui chiembi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Adsho tantiashun abi chieshënquidon: —¿Mitsimbo papa icpec? —capondash. Adoaquien: —Con Pa ëbëdta ma mimbi tantienquio icboc. Ëbi tantiaquimbien mimbi con Patsen tantiatsiac —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Abi chieshënquido onquecuededec quënën tabadnubi aid quënë cachoctsëqui Nuquin Papa tantiaquin piucquid menequin nauedte tabëcacnoshon Esusën chuipondash. Adec Esus anoentsëqui tabadsho abi chieshënquidon bedabi icpondash. Nuquin Papa: —Ma ëmbi tantiacpadënquio matsesën unës uanu —quenuc Esus bedabi icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Adnubien Esusën abi chieshënquido padpiden chuioapondash. —Nidendabi. Ëbi nidan ëbi nibënquin mimbi ëbi istuidenquio iquendac. Ambi chiaid niac-niacquido icsho Nuquin Papan bëdamboen isambobi mibi unësendac. Adash ëbi nidacno mibi nidtiapimbo iquendac —quequin chuipondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Adsho tantiash Esus chieshënquido: —¿Abibida Esus cuesuniadpec? Abibi cuesuniadash Nuquin Papan icsaido cuidacno nidtsiash. Ambo nuqui nidtiapimbo iquec. ¿Aden chiecta: “Ëbi nidacno mibi nidtiapimbo iquec,” quepec? —quepondash abi chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Adsho tantiash Esus: —Mibi matses nec. Ëbien con Pa yacnuësh chondaidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","“Adquid icsho ëbi tantienquio icquid unësacsho Nuquin Papan ambi icsaido cuidacno nidmendac,” quequin tantiaquin: “Nuquin Papan bëdamboen isabi mibi unësendac,” mibi caombi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Adsho tantiash abi chieshënquido: —¿Mitsipadquid icquin ëbi aden chie? —quepondash Esus caic. Adoaquien: —Ëmbi chianeboedquiobi mabi neyoc —queoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Adashic padpidec: —Mimbi naid dadpen chuiquin mibi cuidte chiendambi. Ëmbembi chienquio icquin ëbi chomiondaid muesanquio chiaidquio chiendambi. Aidën chiaiduidi matses abitedi chiendambi —quenubien ");
INSERT INTO mcfNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Esus chieshënquidon: —Abi chomiondaid Nuquin Papambo nec —quequin tantienquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aden tantienquio icsho isun Esusën padpiden chuioapondash. —Matsesmiaidquio icshobi ëbi cuesten dectanshumbic mimbi ëbi tantiabenendac. “Ambi chiacpadquidshenda nepadenec. Ambembi chiaid chienquio icquin aton Papan chiaidquio chuiquin aidën chiacpadomboenshenda napadenec,” quequin ëbimbo mimbi tantiendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Adashic padpidec: —Nëbi ëbi chomiondaid ëbëd iquec. Aid bëdambo icmenuen ambi chiacpadomboen nasho isun ëbi nianenquio iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Adsho tantiashun: —Abimboen Esusën caic. Nuquin Papa yacnuësh choquidien nec —queshun Esus tantiauidtsëccondash dadpenshun. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Adsho isumbien Esusën abi bëdiactsëc tantiauidtsëcboedo chuipondash. —Ëbi tantiaquidën ëmbi chiacpadomboen natiadquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nuquin Papabëdta ëbi aden tantiasho icsamianquidën yua icboedi aidën yuapenquio mibi icmetsiambi —quepondash Esus abi tantiauidtsëcboedo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Adec Esus: —Yua —quesho tantiashien: —Abadauan yampidën tsyuecquido yec utsin yuacmaido nebi. Tantienquio icquin mimbi icsamboen chiec. ¿Atotsieshun: “Mibi yuapenquio icmetsiambi,” quequin ëbi chio? —capondash abi tantiauidtsëcboedon Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Adoaquien: —Tantia. Mibi abimbo chuinu. Uidën uacbimboen icsambo icquidën ambembi abi icsaid ëntiapimbo iquec. Abembi bëdambo ictiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","¿Mitsipadquid nuquin matsesën yuaid icpec? Aton madopen yec icsambo icsho icbon cuemequid. Aton madombo bëdamboen isquid. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aden con Pan aton Madombo icsho ëbi bëdamboen isquin ëbi tantiaquidotsen bëdamboen isendac. Aden ëbi tantiaquido bëdamboen isquin bëdamboec tabadte bumequin abi yacno ëbëd tabadtequido icmendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Adshumbic Esusën abi chieshënquido chuioapondash. —“Con tsusedpa Abadauan icpampic,” quequin mimbi abimbo chioc. Adboedëmbi ëbi cuesunetiadquio mibi iquec. Ëmbi abimbo chuisho tantiate bunenquio icquin ëbi cuesunetiadquio mibi icpec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","“Con Pabëd tabadquin isondambi,” quequin ëmbi bëdamboen chuisho tantienquio icquin min papabimboecquidën chiacpadomboen mimbi naindac —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Min papabimboecquidën chiacpadomboen mimbi naindac —queshobien: —Con tsusedpa Abadauanën nacpadomboen mambi napaboc —capondash Esus chieshënquidon. Adoaquien Esus: —Ma mimbi adoenquio yoc. Abadauanën nacpadomboen naquin mimbi bëdamboen natsiac. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bëdamboen natiapimbo icquin mimbi ëbi cuesunetiadquio iquec. Nuquin Papan chiaidquio abimbo chuisho mimbi adotiadquio iquec. Nuquin Papan chiaid tantiec ma Abadauan cuesuniantiapimbo icpampiyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Min papabimboecquidën namiacpadomboen naquidien mibi nec —capondash Esusën abi chieshënquido chuiquin. Adoaquien: —Mambi Nuquin Papauidtsëqui tantieyoc. Utsi tantiatiapimbo icquin Nuquin Papauidtsëqui con pa caimbi —quepondash Esus chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Adsho tantiashien Esus: —Nuquin Papambo tantiaquimbien mimbi ëbitsen tantiatsiac. Ëbembi choenquio iccondabi. Nuquin Papan: “Matsesbëd tabadec nid,” caquini chondac. Adoaid icsho Nuquin Papa tantiaquidën ëbitsen tantiatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Mitsipadquid yec ëmbi chiaid tantiash: “Tantiadenquien icpec,” quepe mibi? Ëmbi abimbo chuisho tantiate bunenquio yec pamumëdacbimboec mibi iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Min papabimboecquid Satanas nec. Aid bunacpadenuidi mimbi natiadquio iquec. Ëndenquimboshë Nuquin Papan tauamboen matses uanubi min papabimboecquid cuesunianquidquio nepampic. Aton padibi nec. Nuquin Papan chiacpadomboen namenquio yec chieshënec muaquidquio nec. Aton padibi icquid yec matses muamequidquio nec. Aidën madobimboecquin mimbi ëbi tantiatiapimbo icpec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ëmbi Nuquin Papan chiaidquio abimbo chuisho mimbi tantiatiapimbo iquec. Icsambo icquidën ambembi chuisho mimbi tantienquio yaquien bëdambo ictsiash. Mabi icsambo icquidpenquio neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Tsuntsimbini: “Mibi icsaoc,” capatsiash? Mabi adotiapimbo yoc. Icsaisambo nebi. Adquid icquin Nuquin Papan chiaid ëmbi abimbo chuisho ¿atotsi quequin tantienquio mimbi icpe? ");
INSERT INTO mcfNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuquin Papa tantianuequidën Nuquin Papan chiaidquio chuisho tantiatsiash. Nuquin Papa tantiesabombo ma mibi neyoc. Adquid icquin Nuquin Papan chiaid abimbo chuisho mimbi tantiatiapimbo iquec —quepondash Esus abi chieshënquido chushcaic. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","—Nuquin Papa tantiesabombo ma mibi neyoc —Esus quesho tantiashien abi chieshënquido: —Ma mibi podobitsi icsa dapuduedash neyoc. Tantiadenquio yec mibi onquec. Samadia yacnocquidobimboec icsamboshë ma mibi iqueyoc —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Esus: —Mabi podobitsi icsa dapuduedambo yoc. “Ma matsesën con Pa tantianu,” quequin mambi abimbo chuiboc. Adshobi: “Nuquin Papan chiaidquio abimbo mimbi chiec,” catiadquidi mimbi ëbi: “Muec nec,” capec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Mabi: ‘Bëdambo iquec,’ canu,” quenquio iccobi. Con Pambien: “Ma matsesën con Mado: ‘Bëdambo iquec,’ canu,” ëbi caindac. “Bëdambo iquec,” canesabotedi aidëmbi cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tantia. Mibi bëdamboen chuinu. Ëmbi chiacpadomboen naquidquio unësenquio ictsiash —quepondash Esus ompoacbimboen chiec. —Ëbi tantiaquido unësacsho uincuemeshun Nuquin Papa yacno ëbëdi tabadmendambi padpidec unëstiapimbo icnuc —quequin tantiec adondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Unësenquio ictsiash —quesho tantiash Esus chieshënquido: —Ma mimbi tantiadenquio icnuc chuipayoc. Adsho: “Mayan icsa dapuduedashien nec,” mibi caombi. “Ëmbi chiacpadomboen naquidquio unësenquio ictsiash,” quepequien mibi iquec. Nuquin tsusedpa Abadauan yec Nuquin Papan chiaid chuibanquido yec quequido Nuquin Papan bëdamboen isaidombo abitedi unëspampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Aido Nuquin Papan namiampidombo icnuc Nuquin Papan namequiaidquioda ne? ¿Mitsipadquid mibi nepe? Muequien mibi nechitec —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Adoaquien Esus: —Ëmbembi: “Mabi: ‘Bëdambo iquec,’ canu,” quequin ëmbi nac icsambo ictsiash. Mimbi: “Aiduidtsëqui tantiembi,” caboedëmbini: “Nëid con Mado Esus bëdambo iquec,” quequin ëbi comapenen tantiaquin namec. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","“Tantiembi,” mimbi caboed Nuquin Papa ma mimbi tantienquio yoc. Ëmbien Nuquin Papa tantiaquiec. “Aid tantienquio iquembi,” quec mibi yacpadec muatsiabi. Mambi con Pa tantiaquin ambi chiacpadomboen nayoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mimbi: “Con tsusedpan nacpadomboen naimbi,” caboed Abadauan: “Nuquin Papa yacnuësh choash bëdambo icmianquidquio matsesbëdi tabadendac,” quequin tantiec cuishonquepadenec. Nuquin Papan tantiamiac ëbi aden tantiapadenec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Adsho tantiashun Esus chieshënquidon: —Ma mimbi min seta 50tedi matamiambo yoc. Adash ma mibi tsusiobudabi iqueyoc. Abadauanën mibi tantiatiapimbo icpampic —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Esus: —Abimbo caimbique. Tantiata. Abadauan tishabi icnubi ëndenquimboshë ictenebi. Nuquin Papapadquidquio nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Adsho tantiash nëishtanequien: —¿Icsamboenda chuipec? ¿Nuquin Papada muauapebac? —quetanquin cuënote dapa bedtanequin: —Seshunenu —cac siadenquio yec ompodanec cuempondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yuecquio ictaniash chonoadenquio icte ushën capucuenequin Esusën dada bëshuaid istuidpondash. Anin bëshuacshobi tishnëdaid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","3","Aid istuidshumbimbi: —En chui, Icbo. Tantianu. ¿Atotsieshun Nuquin Papan bëshu uapanëdash? ¿Aton papabëd ani icsasho isun Nuquin Papan cuidquin bëshu uanëdaidta nepec? —caquien: —Padenquio. Utsi icsasho isun Nuquin Papan nambo icpanëdash —quepondash Esus. Adsho tantiashun padpiden: —¿Tishabi icnubi: “Abibi icsaindac,” quequin tantiashun Nuquin Papan bëshu uanëdaidta nepec? —caondambi. Adoaquien: —Padenquio. “Abibi icsaindac,” quequin tantiashun Nuquin Papan bëshu uambo icpanëdash. “Ma con Madon comapenen tantiaquin ismenu,” quequin ambi tantiacpaden Nuquin Papan bëshu uapanëdash. Adoacsho anin tishnëdaid nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nëbi ambi chiacpadomboen nanuna. “Nainabi inchëshmane,” quiash comapenec chonoadnuna. Inchëshën matses chonoadesa —quepondash Esus. —“Con Pan tantiaidtedi nainabi unësmane,” queshun unësabi icquin con Pan chiaidtedi nainendambi —quequin tantiec: —“Nainabi inchëshmane,” quiash comapenec chonoadnuna —quiondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Adashic: —Matsesbëd icquin Nuquin Papa bëdamboen tantiamequidquio nebique. Nëidtsen tantiamenu ");
INSERT INTO mcfNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","—quetanquin nidaidën uicchun cuishtucatanquin nidaidbëdta uicchun cabiuntsëcshun bëshuaid bëbitaccapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Adotanquimbic: —Acte tiquidimbo icquid Sidoe caidën bëpamëdec nid —cac nidash bëpamëdtanec bëdamboen isec aton shubuno nidpac caondash. Aid acte con onqueten Sidoe quequin buanaid caic. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aton shubuno nidshobi aton shubu anoentsëcquidon bëshuacboed istuidpac caondash. Adembidi utsibon: —Bëshuaid nebique. Piucquid beccho —quedonetsec tsadtsëcsho isboedontsen istuidpac caondash. Istuidshun: —¿Nuqui isboedquiobida nepec? “Beccho,” ¿quedoneboedquiobida nepec? —cabededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Utsi-utsiec: —Ai, aidquiobi nec —quenubi utsibo: —Padenquio. Aidbimboecquidien nec —quesho tantiash: —Aidi nebi —quepac caondash bëshuacboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Adsho tantiashun: —¿Mitsipadec bëdano? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Esus caidën bëdamioshi. Nidaidën uicchun cuishtucashun nidaidbëdta uicchun cabiunshun bëbitaccashun: “Acte tiquidimbo icquid Sidoe caidën bëpamëdec nid,” cac nidash bëpamëdec bëdanobi. Nëbi bëdamboen isembi —quepac caondash bëshuacboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Adsho tantiashun: —Mibi bëdamequid ¿mitsimbo iquec? —cac: —Tsaudi —quepac caondash bëshuacboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","—Bëdamioshi —quesho tantiashun: —¿Abimboda capec? Ma con chuiquidon chuimenu —quequin padiseyobo yacno bëshuacboed buampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Buanacshobien padiseyobon: —Chonoadenquio icte ushën nac caosh —quequin tantiaquin: ");
INSERT INTO mcfNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","—¿Mitsipadec bëdano? —caquien: —Esusën nidaidbëdta uicchun cabiunshun bëbitaccac bëpamëdec bëdanshun nëbi bëdamboen isembi —quepac caondash bëshuacboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Bëpamëdec bëdanobi —quesho tantiashien chuiquido onquecuededpac caondash. Utsi-utsiec: —Nuquin Papa tantiaquid icquin Nuquin Papan chiaid niac-niaquenquio ictsiash. Chonoadenquio icte ushën nëid bëdamequin ma Nuquin Papan chiaid niac-niacpayoc —quenubien utsibo: —¿Nuquin Papa tantiesanda aden bëdamepatsiash? Ma comapenen tantiaquin nacnempaboc —quepac caondash. Adshumbic abitedishun: —Esus icsambo iquec —cainquio icquin ");
INSERT INTO mcfNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","bëshuacboed chuipac caondash. —Mibi bëdamequid ¿tsutsi mimbi cape? —caquien: —Nuquin Papan: “ ‘Yuecshun naden naindambi,’ quequin chiaidquio chuiquidien nec,” caimbi —quetanec bëshuacboed nidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aid nidnubien Esus chieshënquido: —Bëshupenquien niash. Muequien niashe. Anibëdta amë chuimenun chomenuna —quetanquin ");
INSERT INTO mcfNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","20","chomeshun bëshuacboed cain: —¿Min madoda niosh? —capac caondash. Adoac: —Ai, con mado niosh —queshobien: —¿Bëshuacshobida tishonda? —capac caondash. Adoaquien: —Ai, bëshuacshobi tishondaid nec —ani queshobien: —Bëshuaid ¿mitsipadec bëdanosh? —capac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Adoaquien: —Tsaudi. Bëdansho isambo iccombi. ¿Tsundambien bëdamechitash? Dada ënden caniaid neque. Aidi chuime —quepac caondash bëshuacboedën tita amëbëdi. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","—“Nuquin Papa yacnuësh choquid Esus nec,” quequido Nuquin Papan chiaid chuibante shubun puduedmenquien ictiad —quequin chuiquidon chiaid tantiash dacuëdec: ");
INSERT INTO mcfNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","—Dada ënden caniaid neque. Aidi chuime —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Adoac padpiden bëshuacboed chomeoapac caondash padiseyobon. Chomiash: —“Nuquin Papan bëdamioshi. Nuquin Papa bëdambo iquec,” ¿quecta icco? Ma Esus Nuquin Papan chiaid niac-niacquid neyoc. Ma icsamboshë icquid neyoc —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Adsho tantiash bëshuacboed: —Icsamboshë icquidien Esus nechitec. Aden tantienquio iquembi. Mabi bëdameboc. Isenquio icboedëmbi mambi nëbi bëdamboen iseyoc. Adenuidtsëqui tantiembi —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Adsho tantiashun: —¿Mitsipaden mibi bëdamiosh? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Mambi mibi chuipaboc. Ma mimbimbobi tantienquio icboc. ¿Atotsi quequin padpiden: “Ëbi chui,” cai? ¿Esus tantiatiadquioda icti? —capac caondash bëshuacboedën. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Adsho tantiash nëishtanquin chushcapac caondash. —Mibi Esus tantiaquidquio nec. Mibi icsambo iquec. Ëbien nuquin tsusedpa Moises tantiaquidquio nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Moisesien Nuquin Papan chuiquin namepampic,” quequin tantiembi. ¿Tsuntsin chiac mibi bëdamequidën napash? Ma mibi bëdamequid ëmbi tantiacmaidquio neyoc —quepac caondash chuiquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Adoaquien bëshuacboed: —¿Abida cai? “Dadpenquio tantiembi,” ma mibi quepaboc. Adboedi: “Ëmbi tantiacmaidquio nec,” ¿quecta ique? Mimbi tantiacmaidëmbini bëdamiosh. Ma bëdambo yoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Abi icsaid ënabi icquidën chianesho Nuquin Papan tantienquio ictsiash. Abi tantiaquin ambi chiacpadomboen naquidën chianiac tantiashun Nuquin Papan nashuntsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Anin bëshuacshobi tishaid bëdamenquio ictenec. Adquid bëdamequid nibëdpadenec. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nuquin Papa tantienquio icquin Esusën ëbi bëdamenquio ictsenosh. Nuquin Papa tantiaquimbini bëdamiosh. Ma Esus bëdambo icquid neyoc —quepac caondash bëshuacboed. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Adsho tantiash nëishquioshon: —Bëshuacsho tishaid yec mibi icsamboshë iquec. Icsactsëcquidën chuitiapimbo iquebique. Baded nidec nid. Nëmbo padpidec puduedenda —quequin cuemepac caondash. Aden Esus chieshënquidon bëshuacboed Nuquin Papan chiaid chuibante shubun padpiden puduedmenquio icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Adnubien: —Mimbi bëdameboed cuemiac caosh —quesho tantiashun Esusën ambi bëdameboed istuidpondash. Istuidshumbic: —Nuquin Papan matsesmiaidquio caic: “Nuquin Papa yacnuësh choquid nec,” ¿quequinda mimbi tantiape? —capondash Esusën ambi bëshuaid bëdameboed chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Adoaquien: —¿Tsutsi neque? Isnu —cac: ");
INSERT INTO mcfNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Ëbi nec. Mibi bëdameboedi nebi —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Ai, Nuquin Papa yacnuësh choquid Quidistu caidien mibi nec. Comapenen tantiaquin nabanquidquio yec mibi bëdamboshë iquec —quetanec ismenuec danëshën tinquebudpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Adsho isumbic Esusën matses abi datsidadsho chuipondash. —Nuquin Papa matses bëdamboen ismequid nebi —quiash matsesbëd tabadec Nuquin Papa yacnuësh chondabi. Ëmbi bëshuaid bëdamiac tantiesa icboedëmbi ëbi tantiasho Nuquin Papan bëdamboen isec. Utsibo: “Nuquin Papa tantiaquiembi,” quec muaquidon ëbi tantiatiapimbo icquin Nuquin Papa tantienquio iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Adsho tantiash nëishtanec: —¿Nuquin Papa tantiesabodabi nedi? —quepondash Padiseyobo. ");
INSERT INTO mcfNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Adsho tantiashien: —Nuquin Papa tantiesambo icsho ëmbi tantiamiac Nuquin Papabëdta ëbi tantiasho Nuquin Papan mibi bëdamboen istsiash. “Nuquin Papa tantiaquiembi,” quec muaquin ambi chiaid bëdamboen tantienquio icsho Nuquin Papan mibi bëdamboen istiapimbo iquec —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Adshumbic abi chieshënquido Esusën padpiden chuioapondash ompoacbimboen chuiquin. —Tantia. Mibitedi chuinu. ¿Mitsipaden nuquin matsesën aton yua obeca dadpen dayun uaquin napec? Obeca daquënë uaidën puduedte shëcuënquio obeca icbo puduedquid. Daquënë uaid mayadec puduedquidien ampequid nendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Obeca icbon: “Puduednu. Shëcne,” cac ambi: “Con yua ista,” caidën shëcnequid. Adshumbic puduedtanquin ambi aton yua cuëmbanacpaden cuëmbanquin: “Cho,” caquid icbon. Adoac icbo tsibanquid obecan. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Adshobic icbon daquënë uaidën tabadquid abitedi niecumeshun abi buanec bëyuc nidsho aton yuan tsibanquid. “Con icbon ëbi cuëmbocpadomboen cuënec. Con icbo nec,” quequin icbo tsibanquid obecan. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Utsibon cuënaquien tsibanenquio yec dacuëdec cuenquid obeca. Icbouidtsëqui tsibanquid obeca nec —Esus quesho tantiashien: ");
INSERT INTO mcfNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","—Tantiadenquio yec mibi onquec —quepondash Esus chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Adsho tantiashun Esusën chuipondash. —Tantia. Mibi bëdamboen chuinu. Obeca daquënë uaid puduedte shëcuëbimboecquid nebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","10","Shëcuënuidi obeca puduedquid. Adecbidi ëbiuidtsëqui tantiash Nuquin Papa yacno matses puduedtsiash. Ëbi tantiesain Nuquin Papa yacno puduedtiapimbo iquendac. Ëbi tantiaquido cain obeca caombi. Aido bëdamboen dayun uaquin bëdamboec tabadquid icmendambi. Aido unësacsho uincuemeshun Nuquin Papa yacno ëbëdi tabadmendambi. Adec ëbi bëdambo icnuc ampebimboecquid abi iquec. Ëbi tantiaquido icsamete bunquido aido nendac. Ma adquido mibi neyoc. Nuquin Papan chiaid ma mimbi icsamboen chieyoc. Adoac mimbi chiaid tantiaquidon Nuquin Papa tantienquio iquec. Aido Nuquin Papan cuidtequidombo nendac. Padnuen ëbi tantiaquidon mimbi chiaid tantienquio icquimbi ëmbi chiaiduidtsëqui tantiendac —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Adashic Esus padpidec onqueoapondash. —Obeca icbobimboecquid nebi. Icbo cudasacbimboec ëbi tantiaquido cudasnuec ëbided cuidadec unësendabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Utsiboen adenquio ictsiash. Piucquid bednuen obeca isquidbimboec iquec. ¿Mitsipadopaid obeca isquidën? Bëdi dapa chosho isun: “Con napenquio nec,” quetanquin badedi obeca nianquid. Obeca nianacsho bëdin acshun siaquid. Aden utsi acsho isash acshun secabi icquid niquequid obeca. Obeca isquidën icbonpenquio nianacbimboen ma mimbi icsamboen napayoc. Nuquin Papa tantiate bunquido ma mimbi Nuquin Papambo tantiamenquio iqueyoc —quepondash Esus abi chieshënquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Adashic abi onquec: —Ëmbien matses bëdamboen tantiamequin ëbi tantiaquido dayun uaindac. Nuquin Papabëd ëbi tantiananacpadquiec ëbi tantiaquidobëdtsen tantiananquiebi. Aden ëbi tantiaquido tantiec Nuquin Papa cuidmenquio icnuec ëbided cuidadec unësendabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","¿Nëid matses isadaidbouidtsëqui tantiectabi adec unëspadi? Padenquio. Matses utsibontsen Nuquin Papan tantiamiaido icquin ëbi tantiendac. Aidobëdta nëid matses con matses caquin abitedi bëdamboen dayun uaindambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Con Pan tantiamiacpadec ëbided cuidadec unësendabi. Aden ambi chiacpadomboen ëmbi nasho con Pan ëbi tantiaquiec. Unësash ëbembi uincuenendabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Matsesën ambembi ëbi unës uatiapimbo ictsiash. Ëmbi tantiacpadquiequi matsesën unës uadendabi. Adecbidi uincuentiadquio yec ëbembi uincuenendabi. Aden con Pan namiacpadomboen naindambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Adsho tantiash con matses chuiquido nadec onquecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Esus chieshënquido: —Podobitsi icsa dapuduedash tantiadempambo yec onquepec. ¿Atotsi quequin aid tantie? Aidquio tantiatiapimbo iquendabi —quenubien ");
INSERT INTO mcfNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","utsibo: —Podobitsi icsa dapuduedashta ¿adec onquepatsiash? Bëdamboequien onquiosh. ¿Podobitsi icsa dapuduedaidënda aden bëshuaid bëdamepatsiash? Bëdambo icquidëmbien adotsiash —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuec ictanec con matses cuëdënuec Edusaden yacno cho-chopondash. “Nuquin Papa tabadte shubu uashunaidnoshon tsusedpabon icsa uaquido cuemenëdaid ushë tantiec cuëdëntanu,” quianec cho-chopondash. Ambo iquenuampamboec icpondash aton padibi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iquenuampamboec icnubien Esus Nuquin Papa tabadte shubu uashunaid daquënë uaidën puduedash shubunquio puduedabi quënë cachoqui capupondash. Aid quënë cachoc: “Sadomonën nacnenaid nec,” caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ambo Esus capusho isashien con matses chuiquido Esus natia datsidadshun: —En sebadënquio chui. Tantienquio yec tsadtiapimbo iquebique. Mimbi cuembo chuisho tantiatiadquio iquebi. ¿Nuquin Papan chomiaid Quidistu caidta ne? —capondash con matses chuiquidon. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Adoaquien Esus: —Mambi mibi chuipaboc. Ma mimbimbobi ëbi tantienquio icboc. Con Pan: “Adota,” cac comapenen tantiaquin nabandeniombi. Mibi bëdamboen tantiamenuen adodeniombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Adosho isash mibi: “Ai, Nuquin Papa yacnuësh choquidien nec,” quetiadquidëmbi mimbi ëbi tantienquio iccoc. Nuquin Papan tantiamiabi yaido icquin mimbi ëbi tantiatiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Con Pan tantiamiaidien ëbi tantiaquid yanendac. Adshun obecan aton icbo tsibanacbimboen ëmbi chiacpadomboen natiadquio yanendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aido unësacsho uincuemeshun Nuquin Papa yacno ëbëdi tabadmendambi padpidec unëstiapimbo icnuc. Unësabi icsho: “Con na nec,” queshun bëdamboen dayun uaindambi. Ëmbi adoacsho bedshunacbimboen icsambo icquidën yuaquin Nuquin Papan cuidtequido icmeoatiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Con Pantsen ëbi tantiaquido dayun uaindac. Abipadquid utsi nibëdquiecnuc con Pan ëbi tantiaquido dayun uasho adembidi mënchictiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aden ëbi bedshuntiapimbo icquin con Patsen bedshuntiapimbo iquendac. Con Papadquidquio nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","—Nuquin Papapadquidquio nebi —Esus quesho tantiash nëishtanquin cuënote dapa bedshun abi chieshënquidon Esus seshunetiadquio icoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Adsho isash: —Sianenda. Con Pan namiacpadomboen comapenen tantiaquin nabanombi. ¿Ëmbi adobansho isboedëmbidabi seshunepe? —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Adoaquien: —¿Bëdamboen nabanshodambi: “Mibi seshunenu,” cadi? Padenquio. “Con Papadquidquio nebi,” quequin Nuquin Papa muauasho mambi mibi nayoc. Matses icquin mimbi aden icsamboen chuisho tantiashumbimbi mibi seshunec —quepondash abi chieshënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Adshobien Esusën: —Nuquin Papan chiaidquio nuquin tsusedpan naden dada uapampic. “Nuquin Papa nadec onquec: ‘Min matsesën ëmbi chiacpadomboen nasho: Ëbipadquid nec, caombi,’ queposh Nuquin Papa,” quequin dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Matses caic: “Ëbipadquid mibi nec,” quequin Nuquin Papan chuipampid isun mimbi: “Nuquin Papan icsamboen chiac,” quequin chiambo iquec. “Muesambo icquin Nuquin Papan icsamboen chuitiapimbo iquec,” queshun mimbi chushcambo iquec. Nuquin Papa adoambobi ¿ëbida chushcai? ");
INSERT INTO mcfNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nuquin Papan namiacpadec abi yacnuësh chondaid nebi. Adquid yec: “Nuquin Papan Madombo nebi,” quiobi. Ëbi adsho tantiashun ¿atotsi quequin ëbi chushcai? ¿Nuquin Papadambi muauadio? Mambi abimbo caboc. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ëmbi chiaidquio tantiatiapimbo icquimbi ëmbi naidquio tantiata. Ëmbi Nuquin Papan namiacpadomboen comapenen tantiaquin nabanenquio icsho isun mimbi ëbi mua catsiac. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Con Pan namiacpadomboen nasho isun: “Ai, ambi chuibocpadquidshenda nepec,” ëbi cata. Ëmbi chiaiduidtsëqui tantiatiapimbo icquin adota. Adshun: “Ai, Nuquin Papapadquidquiobidien Esus nec,” quequin mimbi tantiabentsiac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Adsho tantiash padpidec nëishtanquin abi chieshënquidon: —Bedchitono —caqui bedadenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Adashic acte Odan caid potiash con shënision tauaquin matses acten mentodenecno Esus nidoapondash. Ambo ëbi chedobëdi tabadpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Adshumbic Esusën comapenen tantiaquin ismequin ambo icquido chuibampondash. Adsho tantiashun: —Uan padon chuidenedshenda nëid nepec. Ambibi comapenen tantiaquin ismiambobi comapenen tantiaquin nabanquid chuipadenec. Esusën adobansho isun: “Nëid chuiquinshenda Uan padon abimbo capadenec,” caimbi —cabededpondash anocquidon. ");
INSERT INTO mcfNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Adshumbic: —Nuquin Papa yacnuësh choquidien Esus nec —quequin Esus tantiabempondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Udeya yacnuësh Esus cuembon Dasado Esusën utsibimboecquid unëstiadtsëcquio yanac caondash. Shubu dadpen icquid Betania caid yacnocquid niondash. Aidbëd icquid aton chuchu daëd icpondash. Abentsëc Madta icnuc utsi Madia icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Madian aton manëdaidën ucbanquin Esus tanoshcabi icnuc adec aton utsi unëstiadtsëcquio yanac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Adnubien aton chuchun: —Esus chuitan —cac aton matsesën Esus chuituidpondash. —Mimbi con utsi caidquio unëstiadtsëcquio yanoshe. En isec cho —catuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Adoaquien Esus: —Chiata. ¿Unësash chodquequionoshida Dasado nepadiash? Padenquien iquec. “Ma matses: ‘Nuquin Papa bëdambo iquec. Ambi chomiondaid aton Madombotsen bëdambo iquec,’ quenu,” queshun naindambi —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Adbosh Dasado aton chuchubëdta tantiaquidquio yequi ");
INSERT INTO mcfNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","badedquio nidenquio yec anobi daëdec ushpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Daëdec ushumbic Esusën: —Nuqui icbocno Udeya caidën padpidec nidnu. Nid —capondashi. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Adoaquimbi: —Icbo, ma mibi anoshon cuënoten seshunetsempondac. ¿Anobidida nidtiad? ¿Ada: “Seshunequionoshe,” cadec? —capondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Adoaquien cuembo chienquio icquimbi: —Badiadën capuec tocoshquetanec uebudesa. Inchëshëmbien tocoshquetanec uebudquid —quequin Esusën chuipondashi. —Nëbi ëbi unës uatiapimbo iquec. Badiadën nidacbimboen con Pan tantiaidtedi nainabi icsho ëbi unës uatiapimbo iquec. Inchëshën uebudacbimboen ambi tantiaidtedi nainshobini ambi tantiacpadënquiobi matsesën ëbi unës uaindac —quequin tantiec adondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Adshumbic Esusën padpiden ompoacbimboen chuioapondash. —Ëmbi con utsi caid Dasado ushtoaccoshe. Isucumec nidnu. Nid —quesho ");
INSERT INTO mcfNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","tantiashini: —Ma ushnu. Ushash isucunquid —quepondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Esusën Dasado unësaid chuinubi Dasado ushe dantsëccondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Adnubien Esusën sebadënquio chuipondash. —Dasado unësaccosh. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","“Bëdamec nidtiadquidi niobi” ¿quepectabi ique? Padenquio. Mibi caic: “Ma nëidon ëbi bëdamboen tantianu,” queshun Dasado unëso istanambo iccombique. Nëbi mibi ismec nidnu. Nid ");
INSERT INTO mcfNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—caquien: —Ai, abëdquiobi unësec nidnu. Nid —quiampondash Tomas anin abi ushëmbi daëdpambo tishaid. Adanec abitedi nidondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Adashic unësacno anoentsëqui Esus chopondash. Choshon: —Unësacsho chococash daëd-daëdquiec ushobi —quetsëcquiec onquecuededsho tantiatuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Esus choabi icnuc con matses chuiquido Dasado unësacnuësh sedenquenuec Edusaden yacnuësh cho-chopac caondash. Unësaid nëbi ictsëcnuc tedes quidometedos tiontsëcquidën badedquio cho-chopac caondash. Cho-choash unësaidën chuchubëd sedenquec tabadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Adnubien: —Esus choec —quesho tantiash Madta bëquedec chopondash aton chibi Madia shubuno sedenquec tsadnubi. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Choequien Esus bëquedec: —Mibi icnuc con utsi unësenquio ictsenosh, Icbo. Con utsi unësosh. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mimbi chiacpadomboen Nuquin Papan nëbi natsiash —quepondash Madta: —¿Ada con utsi uincuemetsia? —quequin chuitiadquio yequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Adoaquien Esusën: —Min utsi uincuenendac —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Adsho tantiash: —“Ai, yuecash unësaido abitedimbo uincuemete ushën con utsi uincuenendac,” quequin tantiembi —quepondash Madta. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Adsho tantiashun Esusën: —Ëbibi matses unësaid uincuemequidquio nebi. Ëmbi tantiacpadënquio uincuenendac. Aden ëbi tantiaquido unësacsho uincuemendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ëmbi adoac Nuquin Papa yacno ëbëdi tabadendac padpidec unëstiapimbo yec. Ëmbi aden chuisho tantiash: “Ai, abimbo mimbi caindac,” ¿quequinda tantie? —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Adoaquien Madta: —Ai, adembi tantiembi. “Nuquin Papa yacnuësh choquid Quidistu caidien mibi nec. Nuquin Papan Madombo mibi nec. Con tsusedpabon dada uaquin chuipampidquien nec,” mibi caombi —quetanec ");
INSERT INTO mcfNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","nidpondash aton chibi chiec. Nidshun: —Nëmbo cho, chibi. Chuinu —cac aton chibi choshobien: —Esus chosh. Mibi iste bunoshe. En isec cho, chibi —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Esus bëquednuec badedi choquin istuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Shubu dadpen yacnombo choabi icsho Madtan bëquedacnobi Esus tabadsho Madiantsen istuidpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Adec Madia nidsho isun chococacnobi sedencaic nide danquin abëd sedenquenuequidon tsibanampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Adnubien Madia Esus istuidtanec dayumbudec sedenquiampondash aton utsi tantiec. Adec shubitanec ënëdash: —Mibi unësquio iccoc, Icbo. Bëdambo icquid mibi nec. Mibi icnuc con utsi unësenquio ictsenosh —quepondash Madia Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Adnubien Madia tsibanec cho-choec con matses chuiquido sedenquetuidpondash. Madiabëd sedenquecuededsho istanec: —Ai, unësquio icnuc nec —quiash Esus abitsen shubiantiadtsëcquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Adec shubiantiadtsëcquio tsadacnuëshien Esus: —¿Mitsimbo mimbi chococaye? En isnu. Nid —quepondash. Adoac: —En isec cho —quianec nidnubien ");
INSERT INTO mcfNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","shubinidequi nidpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Adec shubinidsho isumbien: —Ma Dasado unësquio icnuc shubieyoc —cabampondash con matses chuiquidon. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Adnubien utsibo: —¿Atotsieshun bëshuaid bëdamiondaidëmbi Dasado unëso bëdamenquio icposh? —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nidquimbi chococacno istuidequi Esus shubiantiadtsëcquio yanoapondash. Nidaid cuënoteuidpambo icquid macuësh tsimpiduc shëcuë uaidën unësaid nauedshun cuënote dapan bëtinacnuësh shubiantiadtsëcquio iccondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Adashien Esus: —Cuënote bidiacquin shëcuë shëcne —quepondash. Adsho tantiash unësaidën chuchu Madta: —Padi. Ënden pisenashe. Chococash mabi daëd-daëdquiec ushboc —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Adoaquien Esus: —Dacuëdenda. Mambi mibi chuiboc. Mimbi: “Nuquin Papan Madombobien mibi nec,” ëbi casho: “Ëmbi comapenen tantiaquin nabansho mimbi isendac,” mambi mibi capaboc. En na. Baded bëcune —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","cuënote shëcuë bëtinaid shëcnequin bëcunepondash. Adsho istanquimbien Esusën abuc isquin Nuquin Papa chuipondash comapenec onquequin. —Papa, ëmbi nëbi chuisho mimbi tantiec. Ëmbi chuibocpadomboen mimbi naindac. Mibi bëdambo iquec, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ëmbi otacquio chianiaid mimbi tantioc. Ëbi datsidadaido tantiamenuen nëbi comapenec onquequin mibi chiembi. “Mibi chuitanquin ëmbi comapenen tantiaquin nabansho isun: ‘Nuquin Papan chomiaidien nec,’ quequin ma nëidon ëbi tantianu,” queshun comapenec onquequin mibi chiembi, Papa. Padi, aidtedtsëqui mibi chiombi, Papa —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Adtanquimbien comapenen cuënquin: —Dasado, puduenec cho —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Adoaquien Dasado badedquio puduenanec chopondash abi dashcute dataniacchobi. Unësacsho uesquin dashcuten datanetanquin dashcuten abi bëpucacchobi chopondash. Adec chosho istanquin: —Baded dashcute dachic. Ma nidnu —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aden Esusën ënden unësaidquiobi uincuemesho isashien Madia tsibanec sedenquec cho-choboedo abentse-abentsec: —Nuquin Papan chomiaidien Esus nec —quiampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Adnubien utsin Edusaden yacno nidshun Esus chieshënquido padiseyobo chuituidpac caondash. —Esusën unësaid uincuemiosh —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Adsho tantiatanquimbien chuiquid dapan abëdtan chuiquid utsibo cho-chomepac caondash padiseyobo yec tsusio dapabo yec quenuc. Aden cho-chomiash tabadec onquepac caondash. —¿Mitsipadotiad? Nuquin matses ismequin comapenen tantiaquin dadpen nabampac caosh. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aden Esusën nabansho isun nuqui ëmiabi icsho nuquin matsesën abitedishun abi chuiquid dapa Esus icmetsiash. Adnubien nuqui yuaquido Doma yacnocquidon ambi chuiquid icmiacmaidquio chuiquid yansho isun nëishun nuqui acshun siatsiash. Nuquitedi acshun siatanquin Nuquin Papa tabadte shubu uashunaid dapatsen uesquin chic-chictsiash. ¿Mitsipadotiad Esus? —quepac caondash chieshëmënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Adnubien abëdtan chuiquido chuiquid dapambo aid setan icquin Caipas caidëntsen chuipac caondash. —¿Midapadotsëcquien mimbi chiendac? Tantiadentsëcquio icnuc ma mimbi chuipaboc. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tantia. Mibi bëdamboen chuinu. ¿Atotsi quec: “Abitedi unës uaindac,” mibi quepe? Ma nuquin matses abitedi unës uainquio icnueshun Esusded unës uamenuna —quepac caondash chuiquid dapambo abëdtan chuiquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aden chuiquin ambembi chiambo Nuquin Papan oncamiac Nuquin Papan chiaidquio aden chuipac caondash. —Nëid setan abëdtan chuiquido chuiquid dapambo nec —queshun Nuquin Papan aden oncamiaqui Caipas onquepanëdash. —Matses cuidmenquio icnuec con Madoded cuidadec unësendac —queshun Nuquin Papan Caipas aden oncamepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aden Caipasën chuinëdaid tantiaquin ëmbitsen chuinu. Tantia. ¿Isadaidbouidtsëqui cuidmenquio icnuecta Esus abided cuidadec unëstiondash? Padenquio. —Matses utsitsen abi tantiaquid yansho isun abëdi tabadmenuec Esusded cuidadec unëspondash —quequin tantiembi. Nëbi Caipasën chuisho tantiashun tsusiobon chiaid chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aden Caipasën Esus unës uamete chuisho tantiashien Esus chieshënquido: —Nëbimbobien Esus unës uametiad —quecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","—Tsusiobon mibi adosh —quesho tantiatanequien chieshëmënquido ismenquio yec Esus cuempondash. Cuenequi nidaid utsin nidash masi dapa yacno anoentsëqui shubu dadpen icquid Epadain caid yacno nidpondash. Ambo tabadquin ëbi chedo Esusën chuibampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Epadain caid yacno tabadnubien Nuquin Papan con tsusedpabo unës uainquio icquin matamiampid inchësh tantiec cuëdënuec Edusaden yacno con matses nidanepac caondash. Cuëdënec taëabi icnuc mishtemaid mishquidoba Edusaden yacno nidanepac caondash. —Mabi tsusion nesmenu. “Mishtemaid mishquid tsusion nesmiabi icquid cuëdëntemaid,” quedeneque —quianec nidanepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Adshumbien Edusaden yacnoshon Nuquin Papa tabadte shubu uashunaid daquënë uaidën puduedtanquin Esus iste bunquin nibëntuidpac caondash mishtemaid mishquidon. Nibëntuidshobien: —Nuqui chuiquido nadpac caosh. “Esus istuidshun ëbi chuita. Bedshun unës uamechitono,” quepac caosh —quesho tantiashien: —¿Ada Esus chopeba? “Unës uamenushe,” quiash choenquien icchitec —quecuededpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aden mishtemaid mishquidon abi nibënubien Edusaden anoentsëqui ambi Dasado uincuemiondacno Betania yacno Esus chopondash. Seistedec ushash Nuquin Papan matamiampid inchësh tantiec cuëdënec taënushi niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ambo chosho isash: —Esus bëdambo iqueque. Pemenu —queshun: —Pec cho —cac puduedash tabadpondash nëidtedi. Nëidic Esus. Nëidic Dasado. Nëidic shubu icbo. Nëidic Esusbëd icquid ëbi chedobi. Nëidic Dasadon chuchu daëd. Aidtedi icpondash. Adec penuec tabadsho Madtan pete menebampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Adnubien Madian: —Esus bëdamboshë iquec. Ismenu —quetanquin bëdamboshë nuadquidën Esus tanoshcapondash. Tanoshcatanquin aton manëdaidën taucpondash. Aden tanoshcaid shubu anuestsëcquiec comapenec nuadpondash. Piucquid dadpenquio menequin bedaid niondash. Sedunten cushtoaid bëdambo nuadquid nado caid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Adsho isun Esus bedmequidën Udasën Madia chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Padi. Mimbi uesquieque. Utsi uain nata. Nëid danoshcate meneshun piucquid dadpenquio seta abentsëc matamec chonoadaidtedquiobien bedtiad. Adoshombien piucquid nibëdquido aid piucquid menetiad —capondash Udasën. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Adomboen chuisho tantiashun Udas bëdambo icquidquio danondambi. Esusbëd icquido ëbitedishun piucquid bedshun sauedten sauedshun dayun uaquidquiembi danondac. Piucquid bëdamboec dayun uashumënenquio yequi abibi ampeshumënashi adondash Udas. Aden ambi ampiaid tantiequi: —Piucquid nibëdquidoen menetiad —quequin muaquin Madia chushcapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Adshobien Esusën: —Padi. Chushcainda. Ma nanu. Ma nuquin matsesën unësaid bëdambo nuadnuc danoshcapaid yoc. “Nëbi con Mado unësendac,” quequin Nuquin Papan tantiamiacpadomboen ëbi unëso chococate tantiaquin Madian ëbi tanoshcaquin naic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Piucquid nibëdquido dadpen iquec. Nibëdenquio iquendac. Ëbien mibëd icboedi nëbi nibëdquio yanendac. Ëbi tantiec Madia bëdambo iquec —quepondash Esus Udas chiec aidi: —Abi chieshënquido Esus bedmenu —quepanuda. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Adnubien: —Betania yacno Esus choaccosh —cac Edusaden yacnuësh matses dadpen Esus isec cho-chopondash. Ambobidi Dasado Esusën uincuemiondaid icsho aidtsen isnuec cho-chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Cho-choshon Dasado uincuemiondaid isumbien abentsëcshun abentsëcshunquien: —Comapenen tantiaquin nabanquidquio yec Nuquin Papapadquidquiobidien Esus nec. Nuquin Papan chomiaidien nec —quequin Esus tantiabempondash. Esus tantiabenshumbic abi chuiquidon chiaid tantienquio yampondash. Adsho isash nëishtanequien chuiquid dapabo: —“Uincuemiaid Dasado isun Esus tantiabenosh,” quioshe. Dasadotsembien unës uatiad —quianac caondash chieshëmënquiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Madian tanoshcaboc ushash Esus Edusaden yacno puduanec nidondash. Nidshobien Edusaden yacnuësh cuëdënuec cho-choboedon: —Esus choec —quesho tantiatanquin ");
INSERT INTO mcfNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","niste podobiecquid bedbëtsenec Esus bëquedec cho-chopondash. Esus bëquedshumbien: —Chuiquid dapa nec —quequin ismequin ambi bedbëtsemboed uic-uiccabededpondash. Aden uic-uiccaiqui: “Mibi bëdamboshë iqueque. Ëbi bëdamboen ista. Nuquin Papan chomiaid yec mibi bëdamboshë iquec. Con matses isadaidbo chuiquid dapambo mibi nendac,” quecuededpondash Esus caic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ambi podquedën choquin bedbëtsemboed cabayobitsecquidëmpi catsadtoanec Esus chosho isash adcuededpondash. Adec aid catsadte Nuquin Papan tantiamiacpadomboen con tsusedpan dada uaquin naden chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Edusaden yacnocquido chiec: ‘Dacuëdenda, Edusaden yacnocquido. Is. Cabayobitsecquidëmpi catsadtoanec mibi chuiquid dapambo choeque,’ quepec,” quequin Nuquin Papan chiaid dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Adec Esus catsadtoanec chosho isun aden chuipampid tantienquio iccondambi. Esus abuc nidambimbi ëbitedishun tantiabenondac. —Esus chuiquinshenda nuquin tsusedpan dada uapampic. Aidën chiacpadomboen niste podo uic-uiccaquin: “Bëdambo iquec,” quequin nuquin matsesën Esus ismebededpondash —quequin tantiabenondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Esus cabayobitsecquidëmpi catsadtoanec choabi icnuc Esusën Dasado uincuemesho isboedon: —Uincuemesho isombi —quequin matses dadpen chuibenepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Adsho tantiashun: —Unësaid uincuemequid Nuquin Papan chomiaidien neque. Istanu —quianec Esus bëquedec cho-choshon aden niste podo uic-uiccaquin ismepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","—Esus bëdamboshë iquec. Nuqui chuiquid dapa nendac —quecuededsho tantiashien Esus chieshënquido padiseyobo: —¿Midapadoendac nuqui? Tantia. Abitedishun: “Nuqui chuiquid dapa nendac,” cabededpeque. ¿Mitsipaden Esus cuesunetiad? —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Edusaden yacno cuëdënec cho-choboedo matses utsibo isadaidpembotsen icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Adnubien adquido matses utsibon Esus iste bunquin shubu dadpen icquid Betsaida caid yacnuësh caniquid Esusbëd icquid Uedipe chuituidpac caondash. —Esus istiadquio iquebi —quesho tantiashien: —Chiata. Chuitambono —quianec nidshun ");
INSERT INTO mcfNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Esusbëd icquid utsi Andedesba chuibëtsenec Andedesbëd choequi Uedipe Esus chiec chopondash. —Matses utsibon mibi istiadquio iquec —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","aid matses utsibo isadaidpembo tantiamenuec Esus comapenec onquepondash. —Nuquin Papan matsesmiondaidquio icquin nëbimbobimbi ambi chiaidtedi nainendac. Ëmbi adoacsho Nuquin Papan: “Mibi bëdambo iquec,” ëbi caindac —quepondash Esus abi unës uate chiequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Adshumbien ompoacbimboen chuipondash. —Tantia. Mibi chuinu. ¿Mitsipadquio pete ëshë chococaid icpec? Chococac caniash bacuëec bëdambo icpaid yoc. Chococabi bëdambo ictiapimbo iquec. Adoacbimboen chococabi yac matses bëdambo icmetiapimbo iquendabi. Unësacsho chococac matses bëdambo icmequid nendabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Adashic padpidec: —Ambi naiduidi naquin ëmbi chiaid niacquido Nuquin Papan cuidtequido nendac. Ambi naiduidi nainquio icquin ëmbi chiacpadomboen naquido ëbëdi tabadtequido yanendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Adquid ëmbi chiacpadomboen natiadquio yec ëbi yacpadec chieshtoenquio ictsiash. Adquidquio unësash uincuenash ëbëdi tabadsho Nuquin Papan: “Nëid con Mado tantiaquid bëdambo iquec,” capendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Adashic abi unës uate tantiec Esus nadpondash. —Unësquioshë yanuc: “Mimbi tantiacpadomboen natiapimbo iquebi, Papa,” ¿quectabi icti? Mabi con Pan chiacpadomboen nanuec chondac. Aden nanuec nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Adtanequien Nuquin Papa chiec: —Nuqui tantiacpadomboen nëbi nainembi, Papa. Ëmbi aden nainacsho: “Nuquin Papa bëdambo iquec,” matses cameta, Papa —quenubien abucuëshquio Nuquin Papa comapenec onquepondash. —Ai, ëmbi namiaid mibi icsho: “Nuquin Papan namiaid nec. Nuquin Papa bëdambo iquec,” matses camepombi. Nëbi padpiden adomeoaindambi —quepondash Nuquin Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Abucuësh onquesho bëdamboen tantiabi yec utsibo: —Abu cuëdtoec nec —quenubien utsibo: —Nuquin Papan abi yacnoshon uaid mayan bëdan Esus chuipash —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Adsho tantiash Esus: —¿Ëbi tantiamenuecta onquediosh? Padenquio. Mibi tantiamenuequien niosh. Aden tantiashun ëmbi bëdamboen chuisho tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nuquin Papa chieshënquid Satanasën yuaido matses dadpenquioshë iquec. Nëbi Nuquin Papan tantiacpadomboen aido utsi-utsien Satanas bedshunendambi: “Chën. Con na neque,” quequin. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ëbi abuc dectanac aden matses ëbi tantiaquid icmendambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","—Ëbi cuesten dectanquin unës uaindac —quequin tantiec: —Ëbi abuc dectanendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Adsho tantiash abi datsidadquido: —“Ëbi dectanendac,” quiosh. “Unësebi,” quepequien iccosh —quiashien Esus chiec: —“Nuquin Papa yacnuësh choquid Quidistu caid unësesambo nendac,” quequin Nuquin Papan chiaid nuquin matsesën chuinubi: “Unësebi,” ¿quecta icco? “Unësebi,” quequid Nuquin Papa yacnuësh choquid ictiapimbo mibi iquec. “Nuquin Papan matsesmiaid nebi,” quequid ¿tsutsi mibi nepe? —quepondash Esus datsidadquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Adoaquien Esusën: —Nadquid nebi —quenquio icquin ompoacbimboen naden chuipondash. —Mibi bëdamboen tantiamequid nëbi isadenquio iquendac. Aid nibëdnuc bëdamboen mimbi tantienquio iquendac. Nidabi aidën chuisho bëdamboen tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nuquin Papan bëdamboen iste tantiamequid tantiata. Adsho bëdambo icmequin Nuquin Papan cuidtiapimbo icquid mibi icmendac —quepondash Esus abibi cadequi. Adtanec nidpondash aidon istiapimbo icnuc. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ëmbi dadpen chuiquin dada uabanacpadomboembi Esusën comapenen tantiaquin dadpen nabansho isun con matses isadaidbon Esus tantiatiadquidi Esus tantienquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aden Esus tantienquio icte con tsusedpa Isayasën Nuquin Papan tantiamiacpadomboen chuiquin dada uapampic. “Nuquin Papa yacnuësh choash nadec onquendac. ‘Mimbi chiaidquio chuibansho tantiashun: Muequien mibi nec, ëbi caindac, Papa. Mimbi namiacpadomboen comapenen tantiaquin dadpen nabansho isash: Nuquin Papa yacnuësh choquidien nec, quetiadquidi adenquio iquendac, Papa,’ quependac,” quequin Esusën chuite Isayasën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nuquin Papan pamumëdacbimboecnuc icmiac con matsesën Esus tantienquio icpondash. Aden chuiquin Isayasën padpiden dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Isadaidbon ëbi tantiatiapimbo icsho isun ‘Ma adembi tantienquio icpanuna,’ caimbi. Ma adequi pabiate shëcuë nibëdacbimboec icchitono. Ëbi tantiasho abi icsaid bëpiscudquin bëdamboen ismane,” quequin Nuquin Papan ambi con matses caido nëishënshun chushcaid Isayasën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nuquin Papambo Esusbëd uinsadpambo yec tabadsho isondaid icquin Isayasën aden Esus tantienquio icte chuipampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Con matses dadpenshun Esus tantienquio icnubi con matses chuiquidon abentsëcshun abentsëcshunquien Esus tantiauidpac caondash. Adoboedi: —“Nuquin Papan chiaid chuibante shubun puduedenda,” canushe —quiash dacuëdquin: —Esus tantiaquid nebi —quequin chuitiadquidi utsibo chienquio icpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","—Ma con matsesëmbi ëbi bëdamboen isnu —quequinuidtsëqui tantiaquin aton matses chuitiapimbo icpac caondash. —Ma Nuquin Papan ëbi bëdamboen isnu. Aton Mado tantiaquid nebique —quetiadquidi adenquio yac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Abi tantiauidboedo Nuquin Papan chiaid isbanquido cho-choash abi datsidadacsho chuinuec Esus padpidec comapenec onquepondash. —¿Ëbi tantianuequidën ëbiuidtsëquida tantiapadic? Padenquio. Ëbi tantiaquidën ëbi chomiondaidtsen tantiatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Adembidi con Papadquiobidi ëbi icsho isun: “Ai, adquiobidien Nuquin Papa iquec,” quequin tantiatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nuquin Papan matses bëdamboen iste tantiamenuec matsesbëd tabadec chondabi. Adec matsesash: “Ëbi tantiaquido ma Nuquin Papan bëdamboen isquin bëdamboen tabadmenu,” quiash nebi. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ëmbi aden chuisho tantiatiapimbo icquido nëbi cuidnu,” ¿quectabi icti? Padenquio. Nëbi Nuquin Papan bëdamboen isquin cuidenquio icte chuinuequini nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuquin Papan cuidte ushëmbien ëbi tantiesabon: “Nuquin Papan chiaidshenda chuipadenec. Aid tantienquio yec icsabudquiopobi,” quequin ambibi tantiendac. Adsho Nuquin Papan cuidendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","¿Ëmbembi chuiquindambi nadi? Padenquio. Ëbi chomiondaid con Pan chiaidquio chiequini nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Ëbi tantiaquid ëbëdi tabadendac padpidec unësenquio yec,” queshun Nuquin Papan chiaiduidtsëqui chiequini nec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","2","Esusën comapenen tantiaquin nabanaid chuiquin aidtedi chiombi. Nëbi abi tantiaquido tantiaquiec abided cuidadec unësaid chuiquin unësash abi uincuenaidtsen chuinu. Tantia. Nuquin Papan con tsusedpabo unës uainquio icquin matamiampid inchësh tantiaquin pec tabadte ushë nëbi yanuc inchëshën Esusbëd pec bëdamboec tabadondabi. Padnuen Udas Simon Iscadioten mado Satanasën tantiamiacpadomboen Esus bedmete tantiec tsadpanëdash. Adnubien Esus: —Nëbi con Pa yacno nidebi nëido nianec. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Con Pabëd tabadec ambi tantiacpadec abëdi abitedishun Icbombo iccondaidi nëbi anobidi nidoash adquiobidi icoaindabi. Adquid icquin nëido bëdamboec tantianante ismenu —quequin tantiaquin ");
INSERT INTO mcfNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","yuan nacbimboen nadopondash. Uequin peboedi nidtotanec dashcute bëntse icquid dachiquidtanec daucudte tsibidiquepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tsibidiquetanquin pada-padaid dapan acte cushtotanquin abëd icquido tapambampondash. Daucudten taucbanquin tapambanondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aden tapambanquimbi: —Mibitsen tapanu —cac Petedon: —¿Icbonda yua tapampaid? Ëbi tapanenda, Icbo. Padi —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Adoaquien Esusën: —Ëmbi nasho nëbi mimbi tantienquio iquec. Yuecshun mimbi tantiendac. En tapanu —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Padi. Mibi bëdamboshë icquid nec. Ëbien icsaquid nec. Yua namiacbimboen mibi tapametiapimbo iquebique. Padi —caoapondash Petedon. Adoaquien: —Ëmbi tapanabi yac con yuambo mibi ictiapimbo ictsiac —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Adsho tantiashun Petedon: —En na, Icbo. Tapantanquimbi mapinobëdtabi ëbi mëpanta —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Padi. Nesboed mibi nec. Taënouidtsëqui bëchishacsho tapanembi. Ëmbi bëchish ucac mibi bëdambo iquec. Abentsëc icsambo iquec —quepondash Esus. —Bëchish ucacbimboen ëmbi nasho Nuquin Papan mibi bëdamboen isendac icsaid ucudacbimboecnuc —quequin tantiec: —Ëmbi bëchish ucac mibi bëdambo iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","—Udasën ëbi unës uamenuen bedmendac —quequin tantiec: —Abentsëc icsambo iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aden tapambanash dasiuidash samëdquin pebededquin abëd icquido Esusën chuipondash. —Ëmbi naboed ¿ada tantie? Tantia. Mibi chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Ëbi chuiquidquio mibi nec,” mimbi ëbi capec. Adembidi: “Con Icbo mibi nec,” mimbi ëbi capec. Bëdamboen mimbi chiec. Adquid nebique. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ëmbi nabocpadomboen mimbitsen nata. “Ëbëd icquid tantiaquioquin tapanquin nashunu,” queshun naombique. Adecbidi nashunanta. Naden tantiashun nata. “Esus tantiaquido tantiaquiembi. Con buchibimboecnuc nashunu,” quiash nashunanta. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ëmbi nabocpadomboen namenuen adombique. Mimbitsen nata. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","En chuinu. Tantia. ¿Icbon chiacta chieshpadic? ¿“Nid,” cacta nidenquio icpadic? Icbon chiacpadomboen yuan naquid yendac. Adomboen tantiaquin ëmbi chiacpadomboen nata. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ëmbi aden chuisho tantiashun ëmbi chiacpadomboen naic mibi bëdambo iquendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Adashic padpidec: —Mibitedi caic: “Bëdambo iquec,” quetiapimbo iquendabi. Tauamboen: “Nuquibi icnu. Cho,” ëmbi caondaido con yuabotedi tantiembi. Abentsëc icsambo iquec. “Aid con yuapenquio nec,” quequin ëmbi tantiaidi nec. Nuquin Papan tantiamiac aidën icsamboen nate chuiquin nuquin tsusedpan dada uapampic naden. “Ëbëdtan pianeboedëmbi ëbi unës uamenuen bedmendac,” quequin dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“ ‘Abi unës uametebi chioshi. Nuquin Papapadquidquiobi icquimbien naosh,’ quequin ma tantianu,” queshun mibi chiombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mibipadquidën nate mibi chuinu. Tantia. Mibipadquidën ëbi chuibansho tantiash: “Ai, abimbo caic,” queshun utsibon ëbi tantiatsiash. Adembidi ëbi tantiashun ëbi chomiondaid Nuquin Papatsen tantiatsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Adshumbien abi bedmequid Udas tantiac unësquio icnuc Esusën chuipondash. —Tantia. Mibitedi chuinu. Ëbëd icquidëmbi ëbi chieshënquido ëbi bedmendac —quesho ");
INSERT INTO mcfNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tantiash abëd icquidobëd bëisnanec: —¿Tsutsi capec? Nëidien cachitec —quecuededpondabi otacquio tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ëbi tantiaquidquio yec con cachoctsëqui Esus uepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Adec Esusën dayuntsëqui ueshobini: —“¿Tsutsi cai?” ca —capondash Petedon mëdquin onquenquio icquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Adoaquimbi cachoc isquin: —¿Tsutsi cai, Icbo? —capondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Adoaquien Esus: —En istac. Pete cuëshën ënë puntanquin menequin mibi ismenu —quetanquin pete cuëshën ënë puntanquin Udas Simon Iscadioten mado menepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Adoac penubi Satanasquio Udas dapuduedquiopanëdash ambi tantiaidquio namenuec. Adshobien Esusën: —Mimbi tantiacpadomboen baded nëbimbobi naic nid, Udas —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Adsho tantiashini ëbitedi: —Tantiadenquio yec onquepec. ¿Atotsi quiash: “Baded naic nid,” quepec? —quepondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Utsi: —Udas nuqui piucquid dayun uashunquid nec. “Piucquid buanshun pete bedtan,” quepequien iccosh —quenubien utsi: —“Piucquid nibëdquido piucquid menetan,” quepequien iccosh —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pete cuëshëmpi pesho: —Nëbimbobi baded naic nid —caquien Udas nidpondash. Inchëshëmbi nidpondash Esus bedmenuen chiec nidec. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Abi bedmenuen chiec Udas nidbombien Esus: —Nuquin Papan matsesmiaidquio icquin ambi tantiaidtedi nëbimbobimbi nainendac. Ëmbi nainsho isash con Pa bëdambo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ëbitsen bëdambo icmenuen con Pan comapenen tantiaquin ismendac. ¿Yuecshun quectabi icti? Nëbimbobimbi caindac —quepondash Esus. Abi unës uatebëdta abi unësash uincuenash Nuquin Papa yacno nidte chiec adpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Adashic ëbi chedo padpiden chiec: —Nëbimbobi nidebique. Chuiquid dapabo ëmbi chiondacpadomboen mibi chuioanu. Tantia, mado. Ëbi nidacsho mimbi ëbi istuidenquio iquendac. Ëbi nidacno mibi nidtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aden tantiaquin Nuquin Papan chiaid utsi mibi chuinu. Ëbi nidan ëmbi chiacpadomboen nata. Ëmbi mibi tantiaquiacpadquiec tantiananquiota. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ëbi tantiaquido tantianansho isun: “Adec tantiananquido Esus tantiaquidombo nec,” quequin utsibon tantiatsiash —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Adec —Nidebi —quesho tantiashun Petedon: —¿Mitsimbo nide, Icbo? —capondash. Adoaquien Esus: —Nëbi mibi nidtiapimbo yacno nidebi. Yuecash ambo mibitsen nidendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Adsho tantiash Petedo: —¿Atotsi quetiadquio yec: “Nëbi ëbëdi nidtiapimbo mibi iquec,” quepo mibi? Mibëd nidec dacuëdenquio ictsiabi. Mibi chieshënquidon: “Unës uanu,” mibi casho tantiash: “Ëbien natiad,” quetsiandabi —quepondash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Adsho tantiashien Esus: —“Ëbien natiad,” ¿quecta icpatsia? Padenquio mibi ictsiac. Cachina bënë cuëdanabi icnuc mibi chieshtouidendac. “Ëmbi isacmaid Esus nec,” mibi quendac. Adashic padpidec adecbidi. Adashic padpidec adecbidi. Cachina bënë cuëdanabi icnuc mibi adendac —quepondash Esus. Adsho tantiashini Esusbëd icquido ëbitedi dacuëdcuededpondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ëbitedi dacuëdcuededsho isashien Esus: —Dacuëdenda. “Ëbi dayun uaquid nec,” quequin mimbi Nuquin Papa tantiacpadomboen ëbitsen tantiaquiota. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mimbi tantiacpadquio Nuquin Papan shubu iquec. Quënë dadpenquioshë iquec. Tsucustiapimbo iquec. Adpenquio icsho mibi aden chienquio ictsiambi. Adquid tantiaquin: “Ëbi tantiaquido ëbëdi tabadmendambi,” quequin chiombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Adquid iquec,” quiash ëbia nidshun con Pa chiendambi. “Ëbi tantiaquido neque. Nuquibëdi tabadmenuna,” quequin chiendambi. Adashic ëbi yacno mibi buanuec choaindabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ëbi nidan ëbi nidacno nidte mimbi tantiec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Adsho tantiashun Tomasëntsen: —¿Mitsimbo nide, Icbo? Tantiambo iccombi. Podqued tantienquio iquembique. Ëbi chui —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Esus: —Nuquin Papa yacno nidte tantiamequidquio nebi. Nuquin Papan chiaiduidtsëqui chiec muesambo nebi. Adquid icquin ëbi tantiaquid Nuquin Papabëd tabadmendambi. Ëbi tantiesan Nuquin Papa tantiatiapimbo ictsiash. Ëbi tantiaquidënuidtsëqui Nuquin Papa tantiatsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ëbi caic: “Nuquin Papan Mado nec,” quequin mimbi Nuquin Papatsen tantiendac. Nëbi abipadquid ëbi icsho isun Nuquin Papambo isacbimboen mimbi tantiendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Adshobien Uedipentsen: —Nuquin Papa ëbi isme, Icbo. Nuquin Papa iste bunebique. Aid isash bëdambo ictsiabi —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","aidtsen Esusën: —¿Tantienquioda ique, Uedipe? Yuec mibëdi tabadobi. ¿Mimbi isacmaidtabi nedi? ¿Mibi chianenquiodambi ictio? Nuquin Papapadquidquiobidini nec. Ëbi adquid icsho isun: “ ‘Adquidquiobidi Nuquin Papa iquec,’ quequin Nuquin Papatsen mimbi tantiendac,” quequin mibi chiombi. ¿Atotsi quequimbini: “Nuquin Papa ëbi isme,” cai? ");
INSERT INTO mcfNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Nuquin Papapadquidquio nebi,” ëbi quesho tantiash: “Ai, abimbo caic,” ¿quenquioda icco? Ëmbembi chienquio iccombi. Con Pan chiaidquio chiequini nec. Adembidi ëmbembi nabanenquio iccombi. Ëbëd tëshnanenquio icquin con Pan namiaquimbi naoc. Ëmbembi nainquio iccombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Con Papadquidquio nebi,” ëbi quesho tantiashun: “Ai, abimbo caic,” cata. Ëmbi chiaid tantiatiapimbo icquin ëmbi comapenen tantiaquin dadpen nabamboedquio tantiata. Aden ëmbi nabamboed tantiaquin: “Nuquin Papan chomiaidënuidtsëquien adotsiash,” quequin tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tantia. Mibi chuinu. Ëmbi nacpadomboen ëbi tantiaquidontsen comapenen tantiaquin nabanendac. Ëmbi chuibanac daëdpactsëcshun ëbi tantiabentsëccosh. Con Pa yacno nidshun ëmbi chomiaidën con Mayanën namiac mibipadquidën ëbi chuibanac dadpenshun ëbi tantiabenendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ëmbi chiacpadomboen naquidën: “Ëbi nashunta, Icbo,” quesho tantiashun ambi chiacpadomboen nashunendambi. “Nuquin Papa bëdamboshë iquec,” camenuen ");
INSERT INTO mcfNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ëbi tantiaquidën chiacpadomboen nashunendambi —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Adashic abëd icquido padpiden chiec Esus: —Ëbi abimbo tantiaquidën ëmbi chiacpadomboen natiadquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Adotiadquio icsho isun con Pabëd icquin con Pa chiendambi naden. “Nuqui tantiaquido bëdamboen tantiamenuen nuquin Mayan aidobëd tabadmenuna, Papa,” ëmbi cac Nuquin Papan con Mayan mibëdi tabadmendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Adoac mibi nianenquio yec mibëdi tëshnanenquio iquendac. Mibëd icquin ëbi chuiquin mibi abimbo tantiamendac. Aid isadenquio icsho ëbi tantiesabon aid tantiatiapimbo iquec. Mimbien aid tantiec. Con Pan ëbëd icmiaidquio nec. Ambi namiaid ëbi icsho aid tantiashumbimboen mimbi tantiec. Ëbi nidan choash mibëdi tëshnanenquio yec tabadendac con Mayan. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","¿Shiadimpi mëyadacbitsec icnudambi mibi niampe? Padenquio. Nuquin Papan Mayan con Mayambi nec. Mibëd aid icnuc ëbëd yacbimboequi con Mayan tantiadendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nëbi ëbi nidacsho ëbi tantiesabon ëbi isenquio icnuc mimbi ëbi isendac uincuenacsho. Adec uincuenaid icquin con Mayan mibëd tabadmequin mibi unësacsho uincuemeshun ëbëdi tabadmendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ëbi uincuenaid ushëmbi mimbi naden tantiendac. “Esusën Nuquin Papa tantiaquiec aidbëd tëshnanenquio icquin aidën chiacpadomboenuidi naindac. Adecbidi Esusbëd tantiananquiec aidbëd tëshnanenquio icquin aidën chiacpadomboen natiadquio yec tabadebi,” quequin mimbi tantiendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ëmbi chiacpadomboen naquid ëbi tantiaquidquio nec. Ëbi tantiaquidquio mibi icsho con Pabëdtan mibi tantiaquioquin: “Adquio aton Papabëd Esus iquec,” camequin mibi bëdamboen tantiamendambi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Adsho tantiashun Udas utsin abi bedmequidënpenquio: —“Nuquin Papa yacnuësh choash con matses chuiquidquio yanshun abitedi ismequin tantiamendac,” quequin Nuquin Papan chiaid nuquin tsusedpabon dada uapampic. Nuquin Papa yacnuësh choquid icquin ¿atotsieshun ëbiuidtsëqui tantiame, Icbo? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Esus padpidec: —Ëbi tantiaquiduidtsëqui naden tantiamendambi. Ëbi tantiaquid ëmbi chiacpadomboen naquid nec. Aden nasho con Pabëdtan tantiaquioquin aidbëdi con Mayan tabadmendambi. Adoac con Mayanën tantiamiac ëbëd iquec con Pabëd iquec quiacbimboec tantiadendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ëbi tantienquio icquidoen ëmbi chiaid niac-niacquido nendac. ¿Ëmbiuidtsëqui chiaidta adquidën niac-niacpadic? Mambi Nuquin Papan chiaidquio chuiboc. Aidën chiaidquio adquidën niac-niaquec —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Adashic padpidec Esus onquiondash. —Mibi bëdiactsëc tantiamequin mibëd icquin con Pan chiaid chuibanombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Con Pa yacno nidshun ëmbi: “Nuquin Mayan aidobëdi tabadmenuna, Papa,” cac con Pan con Mayan matsesbëd tabadmendac. Adoac ëmbi naidbëdta ëmbi chiondaidtedimbo mibi bëdamboen tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Con Pa yacno nidshun con Mayan mibëdi tabadmequin dacuëdenquio icquid mibi icmendambi. Adoac dacuëdenquio yec bëdamboec tabadta. Ëbi tantiesabo dacuëdacbimboec dacuëdenda. Comapenec dacuëdtanec uinte paëdtanec aido tabadnubi mibi dacuëdenquio yec bëdamboec tabadta. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nëbimbobini con Pa yacno nidendac. Adtanequic choaindabi,” quepobi mibi chiec. Ëbi adsho tantiash ëbi tantiaquidombo cuishonquetsiash. “Esus abi namequid aton Papabëd tabadec nidec,” quiash ëbi tantiec cuishonquetsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nidnumbi mibi chiec nebi. “Unësash uincuenendabi. Adashic con Pa yacno nidendabi,” quiobi. “Ëmbi chiacpadec ëbi adsho isun ma nëidon: ‘Esusën abimboshenda capondash. Ambi chiondacpadquid Nuquin Papan Madombo nec,’ quequin tantianu,” quiash adobi. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nëbi ënquimbi chuinu. Ëbi tantiesabon icbo Satanas ëbi unës uamenuec choec. Ambembi aidën ëbi unës uametiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Con Pan tantiacpadequini unësendac. Ëbi adec unëso isash: “ ‘Nuquin Papa tantiaquin ambi chiacpadomboen naic abided cuidadec Esus unësac,’ quequin ma matses abitedishun tantianu,” quiash adebi. Nëbimbobimbi naique. Nidec nidnu. Nid —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Nidec nidnu. Nid —quetanquimbi padpiden chuipondashi ompoacbimboen chuiquin. —¿Mitsipadquio shancuinbiecquid uba caid icpec? Mapictsëc ictsequi cuidi-cuidipambo yanquid. Adquidic shancuin bacuëbimboec didiquequid. Uba dadan aton cuidi canimequin bëdambo icmequid. Adomboembidi ëbi tantiaquido bëdambo icmendambi. Nuquin Papain uba icbobimboecquid nec. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uba aton icbon cuidi utsiuc bacuëesa icsho pateshunepaid yoc. Adoacbimboen ëbi tantiauidtsëcboedon ambi icsamboen naid ëntiapimbo icsho con Pan ambi icsaido cuidacno nënendac. Uba icbombidi bëdamboen bacuëmenuen dadpen cuidi icquid cuidi dadpen pateshun siaquid. Adomboembidi ëbi tantiaquido bëdamboshë icmenuen Nuquin Papan aidon icsamboen naid ëmetsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ëmbi chiacpadomboen naic mibi bëdambo iquec. Aden ëbi tantiasho Nuquin Papan mibi bëdamboen isec. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ëbi adembidi tantiaquin ëmbi chiacpadomboen nata. Adsho isash mibi bëdamboen tabadmec mibëd iquendabi. Uba cuidi padquëdaid bacuëtiapimbo iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Adecbidi ëbëdi tëshnanash matses bëdambo ictiapimbo iqueque. Ëbëd tëshnanenquio yec bëdamboec tabadta. Bëdamboec tabadquin mimbi utsibo ëbi tantiametsiac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uba icbon cuidi utsiuc bacuëesa icsho pateshun tsindoshon nëdëncapaid yoc. Adoacbimboen ëbi tantiesabo unësacsho Nuquin Papan ambi icsaido cuidacno nësecaindac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Adshumbic Esusën padpiden chuipondash. —Ëbi tantiaquin ëmbi chiacpadomboen naquidën: “Ëbi nashunta, Papa,” cac ambi chiacpadomboen Nuquin Papan nashuntsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nuquin Papan adoshonac: “Nuquin Papa bëdambo iquec,” mimbi catsiac. Adembidi utsibotsen: “Nuquin Papa bëdambo iquec,” camenuen bëdamboec tabadquin ëbi tantiameta. Mimbi adosho: “Ai, ëbi tantiaquidquio nec,” caindambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Con Pan ëbi tantiaquiacpadomboembi mibi tantiaquiembi. Adoaid icquin ëbitsen tantiaquioquin ëmbi chiacpadomboen nata. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Abi tantiaquioquin ambi chiacpadomboen nashobini con Pan tantiaquiec. Adembidi ëbi tantiaquidën ëmbi chiacpadomboen nasho ëmbitsen aid tantiaquiendambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ëbi cuishonquiacpadquiecbidi ma ëbi tantiaquiec cuishonquequiono,” queshun aden mibi chiembi —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Adashic abëd icquido padpiden chiec Esus: —Ëmbi mibi tantiaquiacpadquiec tantiananta. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nadquiec caimbi. “Min utsi cuesnu,” cashunac: “Ëbien natiad,” quiacbimboec tantiananta. Aden mibi tantiec ëbided cuidadec unësendabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ëmbi chiacpadomboen nasho mibi con utsi caimbi. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ëmbi con yua caboedobi mibi con utsi caimbi. Icbon: “Tantia. Chuinu. Nadono. ¿Ada bëda icpec?” quequin aton yua chienquio icquin aton utsien aden chuipaid. Con Pan: “Ma abi tantiaquido chuinu,” caidtedi mibi chiombique. Mibi con utsi caimbi. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Esusbëd iquec nidnu,” ¿quequinda mimbembi tantiadionda? Ëmbien mibi: “Nuquibi icnu. Cho,” caondac. “Utsibo tantiamequin ma nëidon ëbi chuibenenu. Adoac utsibotsen ëbëd tabadtequid yanendac,” queshun mibi cho caondambi. Aden ëmbi chiacpadomboen naquidën Nuquin Papa chuiquin: “Min Mado Esus tantiaquid ëbi icsho ëmbi chiacpadomboen ëbi nashunta, Papa,” mimbi cac mimbi chiacpadomboen Nuquin Papan mibi nashuntsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ëbi adsho tantiash ëmbi chiacpadquiec tantiananta —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Adashic padpidec Esus onquepondash. —Ëbi tantienquio icquidon chieshënac: “Aden Esusba chieshënondash,” quequin tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ëbi tantiesabo icsho ëbi chieshënquidon mibi bëdamboen istsiandac. Adquid iccondaidi ëmbi: “Cho,” cac ëbi tantiaquid mibi yanondac. Adec ëbi tantiaquid icsho mibitsen chieshënoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Yuan icbon chiacpadomboen napaid yoc,” quequin ëmbi ¿chuiboedta tantie? Aden ëmbi chiacpadomboen nasho ëbi chieshënquidon mibitsen chieshënoaindac. Adembidi ëmbi chiaid tantiatiapimbo icquidën mimbi chiaidtsen tantiatiapimbo icoaindac. Padnuen ëmbi chiaid tantiaquidën mimbi chiaidtsen tantiendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ëbi chieshënquidombi ëbi chomiondaidquio tantiaquin ëbi chieshënenquio ictsiash. Ma ëbi chomiondaid Nuquin Papa tantienquio icquin aidon ëbi chieshëmpayoc. Adomboembidi ëbi tantiaquidotsen chieshënoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","23","¿Ëbi chieshënquidon ëbiuidtsëquida chieshëmpadic? Ma ëbi chieshënquin Nuquin Papatsen chieshëneyoc. Adquid icsamboshë iquec. Nuquin Papa yacnuësh choshon ambi chiaid ëmbi chiabi icnuc ëbi chieshënquido ëbi chieshënec icsainquio ictsenash. Nuquin Papa yacnuësh choshon mambi Nuquin Papan chiaidquio chuibamboc. Adnuc Nuquin Papan ëbi chieshënquido: “Mibi icsamboshë iquec,” caindac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Adembidi Nuquin Papa yacnuësh choshon ëmbi comapenen tantiaquin nabanquin ismiabi icnuc Nuquin Papan: “Con Mado chieshënec mibi icsambo iquec,” cainquio ictsenosh. Utsibon nabanacmaidquio comapenen tantiaquin mambi nabamboc. Adosho isash ëbi chieshënquido: “Icsapenquio iquebi,” quetiapimbo iquendac. Ëmbi nabansho isun ëbi chieshënquin con Patsen chieshënec. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Aden matsesën ambembi ëbi chieshëmpec,” caimbi. Ëmbi aden chuite chuiquin Nuquin Papan nuquin tsusedpa dada uamepampid ëbi chieshënquidon isbanaidi nec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Adashic padpidec: —Ëmbi con Pa yacno nidshun: “Nuquin Mayan ëbi tantiaquidobëd tabadmenuna, Papa,” cac: “Ai,” queshun Nuquin Papan chomiac mibëdi tabadquin abimbo chuiquin ëbi tantiamequiendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Adoac mimbitsen ëbi chuibanendac. “Yuec aidbëd tabadondashun Esus tantiembi,” queshun mimbi ëbi chuibanendac. Aden mimbi chuisho ëbi chieshënquidon mibitsen chieshënendac. Adoac dacuëdenda. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Chieshtonoshe,” queshun mibi aden chiombi. Mibitsen chieshënac dacuëdenda. Mibëd con Mayan tabadmembique. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ëbi tantiaquido caquin: “Isenda. Esus tantiaquid neque. Nuquin Papan chiaid chuibante shubun puduedmenda,” caindac. Shubu utsi-utsiec yacnuësh adendac. Adomboembidi mibi chieshënquin utsi-utsien cuesun secash: “Nuquin Papa tantiaquidquio icquin Esus tantiaquido cuesun secaombi,” quependac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aden Nuquin Papa ëbëdta tantienquio icquidon ëbi tantiaquidotsen chieshënendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mibi chieshënac: “ ‘Ai, adenshenda Esusën chuipondash. Ëbi tantiaquido cuesun secaindac, quepondash,’ ma nëido quenu,” queshun nëbi mibi chiembi. “Ëbi icnuc ëbi tantiaquido cuesun secadenquio iquec. Ëbi nidambien aido cuesun secabenendac,” quequin tantiaquin ënden aden mibi chienquio iccondambi. “Nëbi nidebi,” queshun nëbi mibi chiembi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Adashic: —Nëbi ëbi chomiondaidbëd tabadec nidendabi —quepondash Esus. Adsho tantiash padequimbo tabadpondabi. Adec ëbi padequimbo tabadsho isash Esus padpidec onquepondash. —“¿Mitsimbo nide?” ¿quenquioda ique? ");
INSERT INTO mcfNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ai, ëmbi chuiboed tantiac unësquio icnuen mimbi ëbi chienquio icchitec. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ëbi nibëdnuc mibi bëdambo iquendac. Ëbi nidenquio icnuc con Mayan mibi bëdamboen tantiamenuec choenquio ictsiash. Nidshumbimbi mibëdi tabadmenuen chomendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Adoac matses ambi icsamboen naid tantiamequin ëbitsen tantiamendac. Adomboembidi Nuquin Papan cuidtetsen tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aden Nuquin Papan Mayanën tantiamiac: “Esus tantienquio yec icsambo icchitebi,” quendac matses. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Adembidi ëbi bëdamboshë icquid tantiamiac: “Nuquin Papan Madombo yec Esus bëdamboshë icquid nec. Aid abentsëqui tantiashoeni Nuquin Papan bëdamboen istsiash,” quendac matses. Ëbi isadenquio yec con Pa yacno nidan con Mayanën tantiamiac matses adendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Adembidi Nuquin Papan cuidte tantiamiac: “Matses yuaquid Satanas ambi yuaido Esus tantienquio icquidobëdta Nuquin Papan cuidendac,” quendac matses. Con Mayanën tantiamiac adec matses onquendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Adashic abëd icquido chiec Esus: —Mibi dadpenquio chuitiadquio icquimbi nëbi dadpen chienquio iquembi. Nëbi ëmbi chuisho mimbi tantiatiapimbo iquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nuquin Papan Mayan choshombien mibi abimbo chuiquin ëbi tantiamendac. Ambembi chienquio icquin Nuquin Papan chiaiduidi chiendac. “Nadquio iquendac. Adecbidi nadquid choendac,” quequin mibi dadpen tantiamendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Adembidi ëmbi naidbëdta ëmbi chiaidtedi tantiamequin: “Esus bëdamboshë iquec,” camendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","¿Ëbiuidtsëqui tantiamenuenda con Mayanën adopec? Padenquio. Ëmbembi chiaid mambi chiambo yoc. Nuquin Papan chiacpadomboenuidi naquin ambi chiaiduidtsëquimbi chuibandenioc. “Con Mayanën ëbëdta con Pa tantiamendac,” quequin tantiec: “Ëmbi naidbëdta ëmbi chiaidtedi tantiamendac,” quiobi —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Adashic padpidec: —Nëbi isadenquio yanebi. Adashic yuecpactsëc yash isadcuenendabi —quepondash Esus. —Nëbi unësash uincuenash padpidec isadebi —quequin tantiec adondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Adsho tantiashini ëbitedi: —¿Atotsi quepec? Tantiadenquio yec onquepec. “Con Pa yacno nidash ëbi nibëdnuc mibi tabadendac,” ma quepaboc. ¿Atotsi chuitiadquio yec: “Nëbi isadenquio ictanec yuecpactsëc yash isadcuenendabi,” queposh? ");
INSERT INTO mcfNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Atotsi quepec nec? —quepondabi Esusbëd icquidobëd onquec. Esus tantiamenquio yec sho-shoshquetsëcquiec onquepondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Adsho ambembi tantiash: —Ëbëd icquidon ëbi chuitiadquio iquec —queshun Esusën: —“¿Atotsi chuitiadquio yec nio?” quequin ëbi chuite mibi buneque. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tantia. Mibi Chuinu. Ëbi unëso isash mibi sedenquenubi ëbi tantienquio icquido cuishonquendac. Adec sedenqueboedobi mibitsen cuishonquianendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","¿Mitsipadquio bacuë tishec chido icpec? Bacuë cuididiquenuc natiamboshë icboedi bacuë tishash cuishonquepaid yoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Adecbidi nëbimbobi ëbi unëso isash mibi natiaquiendac. Adboedi yuecpactsëcshun ëbi padpiden isash mibi cuishonquendac ënëdenquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Adnubini con Pa yacno nidendac. Ëbi adnuc mibi bëdambo iquendac. Ëbi nidan: “Ëbi nashunta,” ëbi catiapimbo icquimbi Nuquin Papa mimbi chianendac. Ëbi tantiaquidën: “Min Mado Esus tantiaquiembique. Ëbi nashunta, Papa,” cac ëbi tantiaquin con Pan mibi nashunendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Aden mimbi Nuquin Papa chianenquio iccoc. Nëbi adomboen chianeta. “Min Mado Esus tantiaquid icsho ëbi nashunta, Papa,” quequin chianeta. Mimbi adoac mimbi chiacpadomboen mibi nashunquin Nuquin Papan mibi cuishoncamendac —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Adashic abëd icquido padpiden chiec: —Ompoacbimboen dadpen chuibaniombi. Yuecpactsëcshun: “Con Pa nadquio iquec,” quequin mibi sebadënquio chiendambi —quepondash Esus. —Uincuenshun aden chiendambi —quequin tantiec adondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Adashic padpidec: —Con Pa yacno ëbi nidan mimbi: “Min Mado Esus tantiaquid nebique. Ëbi nashunta, Papa,” quequin Nuquin Papa mimbibi chianendac. “Ëmbiuidtsëqui: ‘Ëbi tantiaquid nashunta, Papa,’ cac ëbiuidtsëqui tantiaquin Nuquin Papan mibi nashuntsiash,” ¿quectabi ique? Padenquio. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mibitsen tantiaquin Nuquin Papan mimbi chianiac mibi nashunendac. “Nuquin Papa yacnuësh choquid Esus nec,” quequin ëbi tantiaquid mibi icsho con Pan mibitsen tantiaquioquin mibi nashunendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Matsesbëdi tabadec Nuquin Papa yacnuësh chondash nëbi con Pa yacnobidi nidendabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Adsho tantiashini ëbitedi: —Adquidshenda mibi nepec. Ma nëbi mimbi sebadënquio chieyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mibi: “Nëbi isadenquio yanebi,” quioc. Adashic: “Yuecpactsëc yash isadcuenendabi,” mibi quesho tantiash mibi tantiamenquio yec sho-shoshquetsëcquiec: “¿Atotsi quepec?” quecuededpobi. Mibi chuimetiadquio iccobi. Ëmbi chiambobi ma mimbibi tantiapaboc. Comapenen tantiaquidquio icquin ma mimbi abitedimbo tantiapayoc. Aden tantiaquid yec Nuquin Papa yacnuësh choquid mibi nec —quepondabi ëbitedi. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Adsho tantiash Esus: —Ai, nëbi mimbi ëbi tantiaquiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aden ëbi tantiaquidquiobi ëbi chieshënquin bedsho isanec mibi niquendac ëbi nianec. Mimbi niamënubi con Pan ëbi nianenquio iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ëbi nidan Nuquin Papan Mayan mibëd tabadendac. Ëbi tantiaquid Con Pan tantiaquiec,” quequin dadpen chuibanombi. “Ëbi tantiec dacuëdenquio yec ma tabadnu,” queshun mibi aden chuibanombi. Ëmbi chiaid tantiashun chieshëmënquido dacuëdënenda. Satanasën: “Icsamenu,” cac icsainquio iccondabi. Aden Satanas yuametiapimbo icquid icquin mibi cudasquin yuametiapimbo iquebique. Dacuëdenda —quepondash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","—Dacuëdenda —queshumbic ëbi tantiamenuen abuc isquin Esusën Nuquin Papa chuipondash. —Nuqui tantiactedi ëbi naimeta, Papa. Ëbi naimetanquin comapenen tantiaquin ëbi bëdambo icmeta. Aden mimbi bëdambo icmiac mibitsen bëdambo icmendambi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ëndenquimboshë mimbi ëbi chiondac naden chuiquin. “Nuqui matses uaidon abitedishun Icbo mibi nec, Mado,” quequin mimbi ëbi chiondac. Mimbi adondaid icquin mimbi tantiactedi matses nuquibëd tabadtequido icmendambi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Matsesën nadosho adoendambi. “Abipadquid utsi nibëdnuc Nuquin Papa iquec. Ambi chomiondaidquio Esus nec,” quequin tantiasho nuquibëd tabadtequido icmendambi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mimbi chiacpadomboen naquin nëbimbobimbi nainec. Ëmbi adoacsho isash matses: “Ambi chomiaid tantiasho Nuquin Papan nuqui bëdamboen isec. Nuquin Papa bëdamboshë iquec,” quependac, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nuqui tantiactedi ëmbi nainacsho mibi yacno nidmeshun mibëdi ëbi tabadmeoata nuqui matses uabi tabadtenecpadembi. “Nuquibi abitedimbo namenuna,” ëbi cata, Papa —quepondash Esus Nuquin Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Adshumbic Esusën abëd icquido ëbitedi chuiquin aton Papa chuioapondash. —Mimbi tantiactedi mimbi ëbi tantiaquid icmiacsho mimbi bëdamboen iste chuibanombi. Aden mimbi chiaidquio chiac: “Ai, adotiadquio iquebi,” quiosh, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Adembidi aidon: “Nuquin Papan namiaidquio nec. Ambembi nainquio iquec,” quequin ëbi tantiaposh. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mimbi chiaid ëmbi chuisho tantiashun mimbi comapenen tantiaquin nabamiaid nasho isun: “Ma Nuquin Papan chomiaidquio nepayoc,” caposhi ëbëd icquidon, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ëbi tantienquio icquido mibi chienquio iquembi, Papa. Ëbi tantiaquidouidtsëqui mibi chiec nebi. Mibi tantiaquido icsho mimbi tantiamiac ëbitsen tantiec aidon. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Adsho isun: “Nuqui tantiaquido nec,” caimbi, Papa. Aidon: “Mibi bëdambo iqueque. Con Icbo mibi canu. Mimbi chiacpadec bëdamboec tabadtiadquio iquebi,” quequin bëdambo icmioshi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mibi bëdamboshë iqueque. Ëbi mibi yacno nidan ëbi tantiaquido dayun uata, Papa. Ëbi chieshënquidon chieshtomenushe. Nëido bëdamboen dayun uata. Mimbi ëbi icmiacpadquidbidi comapenen tantiaquid mibi neque. Ma nuqui tantiananquiacpadquiec ma ëbi tantiaquido tantiananu. Nëido bëdamboen dayun uata, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aidobëd icquin mimbi chiaidquio bëdamboen chuibanquin chieshtomiambo iccombi. Aden bëdamboen dayun uaquin ëbi tantiaquido cudasënquin Satanas yuamiambo iccombi. Udas abentsëquien Satanasën yuatsaccosh. Mimbi chiaid matsesën dada uapampicpadomboen ëbi bedmenuen Satanasën Udas yuaccosh. Adoac ëbi bedmequid yanash mimbi cuidtequid iquendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nëbi mibi yacno nidendabi, Papa. “Ëbi nidan dacuëdec ëbi tantiaquido chieshtonoshe,” queshun mibi otacquio chienquio iquembi. “Ëmbi abi dayun uate chuisho tantiash ëbi yacpadec ma cuishonquenu,” quequin mibi otacquio chienquio iquembi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mimbi chiaidquio nëido chuibanombi. Adoac ëbi tantiaquido yansho ëbi chieshënquidon nëidotsen chieshëmpec. Ëbi yacpadec mimbi chiaid niac-niacte bunenquio icshobidi nëido chieshënquiec, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aden tantiash: “Ëbi tantienquio icquidobëdi ëbi tantiaquido tabadmenda,” ¿quectabi ique? Padenquio. “Ëbi tantiaquido chieshtomenda,” caimbi, Papa. Satanasën yuanushe. Bëdamboen dayun uaquin chieshtomenda, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ëbi tantiesabo tabadacpadec tabadenquio icquin ëmbi nabocpadomboen natiadquio iqueque. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mimbi chiaidquio pausunquioquin bëdamboen tabadme, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mimbi ëbi: “Matses chiec nid,” caondacpadomboen aido: “Ëbi chuibeneta,” caindambi. Adoac nëidon ëbi chuibenendac, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nëido tantiaquiec nëbimbobini mimbi chiacpadec ëbided cuidadec unësendac. “Adomboembidi ëbi tantiaquidon ma Nuquin Papan chiacpadomboen nanu,” quiash ëbi tantiaquido min yuabombo icmenuec adebi, Papa —quepondash Esus aton Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Adashic padpiden Nuquin Papa chiec Esus: —Ëbëd icquido mibi chuishumbic nëbi aidobëdta ëbi tantiaquid utsibotsen mibi chuinu, Papa. Ëmbi chiaidbëdta ëmbi naidtedi ëbëd icquidon utsibo chuibanac aidotsen ëbi tantiaquido yanendac. Adec ëbi tantiaquido dadpenquio yanendac. Ëbi tantiaquidotedi tantiaquin mibi chiec nebi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nuqui tëshnanenquio yacpadequi nuquibëd tëshnanenquio icquid icmeta, Papa. Nuqui tantiananquiacpadec ëbi tantiaquidotedi shubu abentsëquën tabadacbimboecnuc tantianameta, Papa. Adsho isash nuqui tantienquio icquido nadtsiash. “Esus tantiec bëdambo iquec. Aden Nuquin Papanuidtsëqui bëdambo icmetsiash. Nuquin Papan chomiaidquien Esus nechitec,” quetsiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Mibëd ëbi tantiananquiacpadquiec ma ëbi tantiaquido tantiananquiono. Ma chieshënanenquio icnu,” quequin mimbi ëbi namiacpadomboen ëbi tantiaquido namiombi, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nuqui tëshnanenquio yacpadec aidobëd tëshnanenquio iquendabi. “Chieshënanenquio yec tantiananquiec ma bëdamboec tabadnu,” quec aidobëd tëshnanenquio iquendabi, Papa. Adec ëbi tantiaquido bëdamboec tantianansho isun matsesën naden tantiatsiash. “Ambi chiacpadquid Nuquin Papan chomenëdaid icquin Esusën abi tantiaquido aden bëdamboen tabadmec. Ambi chomenëdaid aton Mado tantiaquiacpadomboen Nuquin Papan aid tantiaquido tantiaquiec,” quequin matsesën tantiatsiash, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mimbi ëbi tantiaquido icmiaido nuqui tabadacnombo tabadmeta. “Nuqui matses uabi icquin mimbi: ‘Ëmbi tantiaidquio mibi neque. Nuquibi nanuna, Mado,’ cac nuqui bëdamboshë yec tabadtenecpadequi nuqui tabadsho ma ëbi tantiaquidon isnu,” queshun mibi: “Nuqui yacno tabadmeta, Papa,” caimbi. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Icsaisambo mibi icsho icsambo icquidon mibi tantiatiapimbo icnubimbi mibi tantiaquiec. Mibi yacnuësh choquid icshobini ëbëd icquidon: “Ai, Nuquin Papa yacnuësh choquidien nec,” quequin tantiaposh, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aden tantiamenuen yuec ëbëd icquidobëd tabadquin mimbi naid chuibanombi. Ëbi nidan ëmbi chomiaidën con Mayanën adembidi ëbëd icquido tantiamendac. “Mimbi ëbi tantiaquiacpadomboen ma nuqui daëdi tantiaquiash ma tantiananquiono,” queshun con Mayan aidobëd tabadmendambi. Adoac ëbëd icacbimboec con Mayan tantiadendac, Papa —quepondash Esus Nuquin Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aden Nuquin Papa yuen chianec Esus nidpondash. Ëbi chedobëd nidquin acte Sededon caid potiash tiedno cuëte odibos caid nitsinacno ëbitedi chiec tabadtenebocnombo chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ambo tabadnubien Udas: —Ëbi abëd tabadtenebocno tiednoen nidchitash —quianec Esus bedmenuec ");
INSERT INTO mcfNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","chopondash. Aden chieshëmënquido chuiquid dapabo chuitanshun matses dadpen bëpondash nëidtedi. Nëidic con matses chuiquid dapabobëdtan padiseyobon namiaido sondado chedo. Nëidic con matses yuaquido Doma yacnocquido sondado dadpen. Nëidic aid sondado chuiquid. Aidtedi Udasën bëpondash. Tabotebëdta cueste sanambededtsëcquiec cho-chopondash. Utsibombic chështe. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Adec cho-chosho isash bëquedbanec nidquin: —Ëbi unës uamec —quequin tantiaquin Esusën: —¿Atotsi quec ne? ¿Tsutsi nibëne? —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Nasaded yacnuësh caniquid Esus bednuec nebi —quepondash sondado chuiquid. Adshun isac aidbëd Esus bedmequid Udas icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Adshobien Esusën: —Në iquebi —capondash. Nuquin Papapadquidquiobi icquin adoac dacuëdec: —Aucbidi cuenu —quec uebudcuededpondash bednuequidotedi. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Adshobien padpiden Esusën: —¿Tsutsi nibëne? —cac: —Nasaded yacnuësh caniquid Esus bednuec nebi —queoasho tantiashun: ");
INSERT INTO mcfNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—“Në iquebi,” caombi. Ëbiuidtsëqui bedta. Ëbëd icquido bedenda —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","—“Mimbi ëbi tantiaquid icmiaido Satanas chieshtomiambo iccombi, Papa,” quequin ëmbi Nuquin Papa chuibocpadomboen nëido chieshtometiapimbo iquebi —quequin tantiec: —Nëid bedenda —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Adnubien Petedon abi tsidiadaid chështe chictanquin chuiquid dapan yua abiucquio pateshunepondash. Aid yua Madco niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Adosho isashien Esus: —Padi. Chën. Min chështe naued. Nuquin Papan chiacpadec paëmbo icnuc unësendabi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Adshobien sondado chedon Esus bedpondash. Aden bedshun: —Cuidmenun chuiquid dapa yacno mibi buanu —catanquin catanepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","14","Aden cataneshun buanquin con matses chuiquid dapambo Caipas caidën cucun shubunoba buanondash. Aid setambi chuiquid dapambo Caipas iccondash. Esus chieshënec: —Nuquin matsestedi unës uamenquio icnuen Esusded unës uamenuna —queboed Caipas niondash. Aton cucu chuiquid dapabidi niondash. Aidi Anas niondash. Anasën shubunoba Esus buampondash. Ashunquio Caipas ismenuen buampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Esus buansho isun Petedobëdtan chinunondambi. Chinuntuidash nidequi Caipasën shubuno choash daquënë uaidën puduednuesho tantiashun shëcuë isquid chidon puduedmiondashi. Ambi isondaid icsho aden puduedmiondashi. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ëbi puduedmequin Petedo ambi isacmaid icsho puduedmenquio icpondash. Adsho istanquin: —Ëbëd icquid neque. Shëcneshun. Ma puduednu —capondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Adoac puduedmeshun shëcuë isquid chidon: —¿Në bedboed Esusbëd icquidta mibi ne? —capondash Petedo chuiquin. Adoaquien Petedo dacuëdec: —Padenquio —quepondash muequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Adnubien iquendoshon daquënë uacnoshon cuëte dëtsiadoshon sondado chedobëd anocquido yuabo cuëte cuëec tabadpondash. Adsho isashien Petedotsen cuëte cuënuec nidpondash ëbi shubunquio puduednuc. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Adec ëbi puduednubien Caipasën Esus chuimepondash. —Mibëd icquid ¿tedtsi iquec? ¿Ëbëd icquido dëniaquecta icpec? Mibëd icquido ¿mitsipaden chuibano? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Adoaquien Esusën chuipondash. —¿Ompoquindambi chuibandio? Nuquin Papa tabadte shubu uashunaid daquënë uaidën puduedshun mambi chuibandeneboc. Nuquin Papan chiaid chuibante shubun-shubunquiec puduedcuenequin mambi chuibeneboc. Ompoquin chiambo iccombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mimbi: “Icsamboen naosh,” caid ëbiuidtsëqui chuimenda. Ëbëd icboedotsen chuime. Ëmbi chiaid abitedi tantiashun aidombi mibi chuitsiashe. Aidotsen chuime —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Adsho tantiashun: —¿Chuiquid dapada adopaid? —quetanquin sondado chuiquidën mëdanten bëcuespondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Adoaquien: —¿Icsamboendambi chuidio? ¿Atotsimbi icsa uaoque? En chui. Mambi abimbo chuiboc. ¿Abimbo chuiquidta cuespaid? —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Adondash Esus Anasën abi cataniacchobi Caipasën shubuno bëac. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Adnubien Petedo abi cuëte cuëec tsadsho abëdtan cuëte cuëec tabadquidon: —Esusbëd icquidien mibi nechitec —capondash. Adoaquien Petedo: —Padenquio. Mabi aidbëd icambo yoc —quepac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Adshobien chuiquid dapan yua utsin Petedon pateshuneboedën matsesën: —Esus bedacnobimbi mibi ischitoc —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","padpidec: —Padenquio. Mabi ano nidambo yoc. Ëmbi isacmaidquio ma Esus neyoc —quenubien Esusën chuiboedquio cachina bënë cuëdampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Adnubien Caipas aton chuiquid utsibobëd: —Nuquin matses yuaquido ancaquid Pidato caid ismenuembien Esus buantiad. Aid Esus unës uamenuembien natiad —quecuededpondash. Badiadnubi Pidaton shubuno Esus buampondash. Buanashic: —Matses utsin shubun puduedshun mishtemaid mishash Nuquin Papan matamiampid inchësh tantiec con matsesbëd pec tabadtiapimbo icchitomane —quiash Pidaton shubun puduedenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Adnubien Pidaton aton shubunuësh puduentanquin Esus bëquido chuipondash. —¿Atotsi quequin nëid bëo? ¿Icsamboen naquidta nepec? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—¿Bëdambo icquidtambi mibi ismenuen bëdio? Con matses chuiquid dapa ictiadquio icquin icsamboen naoshe. Cuidquiota —quepondash chieshëmënquido. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Adoaquien Pidaton: —Mimbi cuidta. Min matsesën: “Icsamboshë icquid naden cuidquid yendac,” cacpadomboen nata —caquien: —Padi. Ëmbi cuidquin unës uacsho isash min matses chieshtonoshe. Min matsesën: “Con matsesënuidtsëqui unës uaquin cuidaquien bëdambo ictsiash,” queshun ëbitedi chieshënushe —quepondash Esus chieshënquido Pidatombo Esus unës uametiadquio yec. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ënden abi chieshënquidon bedabi icnuc: —Ëbi cuesten dectanquin unës uaindac —quequin Esusën chiacpadomboen namenuec adpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Adnubien aton shubun puduedtanquin Pidaton Esus chuimeoapondash. —Cho. Chuinu. ¿Min matses isadaidbo chuiquid dapada ne? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Esusën: —¿Mitsipadquid chuiquid cai? ¿Utsibon tantiacpadquidta cai? ¿Mibipadquidta cai? —capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Adoaquien Pidaton: —¿Isadaidbodabi nedi? Padenquio. Ëmbi tantiacpadquid caimbi. ¿Atotsieshun min matses chuiquid dapabon mibi bëosh? ¿Atotsi icsa uasho naosh? —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Esusën Pidaton bëyuc chuiboed tantiaquin: —Mibipadquid chuiquid dapapenquio nebi. Nidaidën con yua sondado nibëdec. Nidaidënuësh mibipadquid icquin con yuabo ëbi bedquido cuesun siametsenombi. Aden ëbi bedenquio ictsenosh. Mibipadquidpenquio nebi. Abucshun chuiquid dapambo nebi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Adsho tantiashun Pidaton: —Chuiquid dapambo nebi ¿quecta ique? —caquien: —Ai, adquid nebi. Chuiquid dapambo icnuec matsespondabi. Chuiquid icquin matses uaquid tantiamenuen abimbo chuibanombi. Adoac abimbo chuisho tantiate bunquidon ëbi tantiatsiandac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Adsho tantiash Pidato: —¿Tsuntsin matses uaquid quequin abimbo chuipatsiash? —quetanec puduenshun Esus chieshënquido chuioapondash. —¿Icsambo icquidta Esus nedic? Ma icsapenquio icquid neyoc. ");
INSERT INTO mcfNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nëid cuidtiapimbo icquin chuinu. Nuquin Papan matamiampid inchësh tantiate ushën min matses quënën nauedaid abentsëc cuemedeniondambi. Adembidi abentsëc cuemembi. ¿Mitsicquidimbi cueme? ¿Nëid mibi chuiquid dapa Esustambi cuemepe? —caquien: ");
INSERT INTO mcfNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—Padenquio. Esus nainda. Utsibi cuemeta. Badabas caid cuemeta —quecuededpondash. Badabas caid Doma yacnocquido cuesun siaquin cuemete bunquidquio icnuc adcuededpondash Esus chieshënquido Esus unës uamete bunquiec. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","—Badabasquio cuemeta —quesho tantiatanquin Pidaton: —Në Esus cueshcanuen buan —capondash. Adoaquien buanshun sondadon canite cuëshë dëdectanquin nacnenaid cueshcanten Esus comapenen cueshcapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cueshcatanquin pinchuc-pinchucpambo icquid mauete nacnenaid Esus mauemepac caondash. Adotanquimbic chuiquid dapan dashcutebimboecquid umucquid dasiuintanquin: ");
INSERT INTO mcfNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—Adec dasiuidquid chuiquid dapambo nec —quequin sondadon Esus mamënshumpac caondash. Aden mamënshunquimbi: —Isadaidbo matses chuiquid dapambo Esus neque. Is —quetanquin mëdanten bëcuesbanepac caondash. Adotanquin Pidato yacnobidi buanoapac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Buanoacsho istanequien Pidato padpidec puduenoash Esus bëquido chiec: —Mimbi bëboed Esus icsapenquio iquec. Icsambo icquid icsho: “Unës uata,” catsiambi badedi. Icsapenquio icquid icsho adotiapimbo iquebi. Padi. Cueshcaquin cuidombique —quepondash Pidato. Adnubien ");
INSERT INTO mcfNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Esus puduempondash. Pinchuc-pinchucpambo icquid mauemetanquin dashcute umucquid dasiuinac dasiuidpamboec puduenshobien Pidaton: —Is. Mimbi bëboed choeque —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","chosho istanequien: —Cuesten dectanquin unës uata. Cuesten dectanquin unës uata —quecuededpondash Esus chieshënquido comapenec cuëdec. Adoaquien Pidaton: —Mimbi cuesten dectanquin unës uatan. Ëmbimbo adotiapimbo iquebi. Icsapenquio icquid icsho Esus unës uatiapimbo iquebi —capondash Pidaton. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Adoaquien Esus chieshënquidon: —Con matsesën: “Nuquin Papa muauaquid unës uaquid yendac,” cacpadomboen natiadquio iquebi. Esusën: “Nuquin Papan Madombo nebi,” quequin Nuquin Papa muauaoshe. Unës uaquimbien ictiad —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","—“Nuquin Papan Madombo nebi,” quiosh —quesho tantiashien Pidato dacuëdquiec yampac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Adash aton shubun Esusbëdi puduedoashun Pidaton Esus chuioapondash. —¿Tsutsimbo ne? ¿Mitsiuëshquio chonda? —caqui Esusën ëcbedenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aden ëcbedenquio yac nëishashien Pidato: —¿Chuitiapimboda ique? ¿Tantienquioda ique? Ëmbi: “Cueme,” cac mibi cuemetsiash. Ëmbi: “Cuesten dectanquin unës ua,” cac mibi adotsiashe. En chui —caquien Esus: ");
INSERT INTO mcfNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—¿Mibembida chuiquid yano? Nuquin Papan chuiquid icmiac mibi nec. Nuquin Papan chuiquid icmiabi adquid ictiapimbo mibi ictsiac. Chuiquidpenquio icquin mimbi ëbi cuesten dectanquin unës uametiapimbo ictsiac. Ëbi cuesten dectanquin unës uamenuec mibi icsambo icnuc ëbi bëboedo chuiquid dapabo icsamboshë iquec —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Adsho tantiashien Pidato: —Esus unës uatiapimbo icchitebi. Cuemetiadquio iquebi —quetanquin padpiden Esus chieshënquido chuitanoapondash. —Esus cuemenu —caquien: —Icsambo iquec. Min matses abitedimbo chuiquid dapambo Sesad caid: “Ëbentsëqui chuiquid dapambo nebi,” quiac caosh. Aid dëniaquec Esus chuiquid dapa icte bunquiec. Esus cuemequin mibi chuiquid dapambo mimbi nëishmeque. Esus cuesten dectanquin unës ua —quecuededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Adsho tantiashun Esus puduemeoatanec cuënote nacnenaid abuc tsadunaidën cuidte chuinuec tsadten tsadtopondash Pidato. Aid cuënote nacnenaid con onqueten Cabata capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nuquin Papan matamiampid inchësh tantiate ushë badiadash icnuc niondash. Aid tsadten tsadtoshon Pidaton: —Në mibi chuiquid dapa iquec —capondash iccuededquido chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Adoaquien: —Cuesten dectanquin unës ua. Nëbimbobi buanshun cuesten dectanquin unës ua —quecuededpondash Esus chieshënquido. Adoaquien: —¿Mibi chuiquid dapadambi cuesten dectanquin unës uape? —Pidaton caquien Esus chieshënquido: —Mibi chuiquid dapambo Sesad caid aiduidtsëqui chuiquid dapa caimbique. Esus cuesten dectanquin unës ua —quecuededpondash Esus chieshënquido. —Nuquin Papa yacnuësh choshon nuqui yuaquido cuemepashun —queboedobi adondash abi yuaquidi chiequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Adoaquien Esus chieshënquidon chiacpadomboen: —Esus cuesten dectanquin unës uatan —capondash Pidaton aton sondado chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Adoac buanquin: —Nëidën dectanu —queshun sondadon cueste daëd napotiaid Esus chiadtomebidampondash. Abi dectantebi Esus chiadtomebidanec nidquimbi macuësh mapi canite caid yacno buampondash. Aid macuësh mapi canite cain con onqueten Cocata capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ambo nidshun aton dashcute dachictanquin bëchun shuin mëtoccaquinc tatoccaquinc catanquin cueste daëd napotiaid ambi bëboedëmbi Esus dectampondash. Icsambo icquid daëdpambo cuesten dectanaid uquë diadbudcuenec diadnuc Esusquio nënantanquio dectampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Adnubien Pidaton: —Nasaded yacnuësh caniquid yec Esus isadaidbo chuiquid dapa nec —quequin cueste pada uaidën dada uapac caondash. Aton matses Doma yacnocquidon onqueten dada uaquinc con onqueten dada uaquinc matses utsi Quidieco matsesën onqueten dada uaquinc catanquin Esus dectanaid cuesten dectampac caondash. —Ëmbi dada uaboed isash: “Isadaidbo chuiquid dapa icsho Esus cuidac,” ma abitedi quenu —queshun Pidaton adopac caondash. Aden dada uashun dectanaid isashien Esus chieshënquido nëishquiopac caondash. —Shubu dadpen icquid Edusaden caid anoentsëqui Esus dectanaid icnuc matses utsin onqueten-onquetenquien dada uaid matses dadpenshun isnushe —quiash ");
INSERT INTO mcfNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pidato chiec nidpac caondash. —Icsamboen chuiquin ma mimbi dada uapacboc. ¿Con matses chuiquid dapada Esus nedic? Adquidpenquio nec. Utsi uain dada uata. “ ‘Isadaidbo matses chuiquid dapa nebi,’ quequid Esus nec,” quequin cueste cuëshë utsin dada uata —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Padi. Mambi ëmbi tantiaboedquio dada uaboc. Utsi uain dada uaoatiapimbo iquebi —quepac caondash Pidato. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Adnubien Esus dectanquido sondado daëd-daëdquiec icpondash. Esusën dashcute 5ted icsho sondadon bedbanquin abentse-abentsen bedbededpondash abentsëc abi icnuc. Aid abucshun bedanquin abichobi daëdcaid tuscabi icquid niondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Adquid icsho isun: —Canchenquio icquin ¿tsundanquio bedeque? Isnuna —queshun abi cuëmëdquidtedi dada uabanshun tëchun sandoshon cadotanequin dada uaidëmpi abia puduemiaid isun aid dashcute bedondash. Aidon nate Nuquin Papan tantiamiac con tsusedpan naden dada uapampic. “ ‘Abentse-abentsen con dashcute bedosh. Con dashcute utsi bednu, quequin dada uaidëmpi abia puduemiaid isnuen naosh,’ quependac,” quequin dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Adnubien Esus dectanaid cueste tayun nëidtedi icpondash. Nëidic Esusën tita. Nëidic Esusën tita utsi. Nëidic Madia Codopasën chido. Nëidic Madia utsi Mactada yacnuësh choquid. Aidtedi chido icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Në chido tabadnuc ambobi uquëctsëc tabadondabi. Adec ambi tantiaidquio ëbi icsho isun Esusën aniba chuipondash. —Nëid con mado cata, tita. Ma mibi bëdamboen dayun uanu —capondash Esusën. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Adshumbic ëbitsen chuiquin: —Con ta tita cata. Adshun bëdamboen ëbi dayun uashunta —cac con shubunobi buanondambi bëdamboen Esus dayun uashunuen. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Adboshien unësquionoshi Esus: —Con Pan chiacpadomboen nainembi. Matses tantiec ëbided cuidadec unësebi —quequin tantiec con tsusedpan dada uaquin chuipampicpadec: —Acte bundobi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Adsho tantiashun matsun acte mucambo icquid anidquid shapu-shapupactsëcquidën punshun cueste dëdectanshun abuc sananquin ëccuëscadonetsëcquin chishmepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Adoac acte mucambo icquid chishtanequien: —Con Pan chiacpadomboen nainquiombi —quepondash. Adtanequi tëdquëdbudpondash Esus unësequi. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Adnubien Esus chieshënquido: —Badiadash Nuquin Papan matamiampid inchësh tantiate ushë iquec. Chonoadenquio icte ushë nec. Aidën cuesten dectanquin unës uaid chococac icsambo ictsiashe. Nëbimbobi chococamenu —queshun Pidato chuitampac caondash. —Baded nidte podquënquin unës uame. Inchësheque —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pidaton aden chiac sondadon nidte podquëntanondash. Esusbëdta dectanaid ëquë diadquidba nidte podquënshumbic utsiuc diadquidtsen. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Adotanquin isquien Esus ënden unësac. Adshobien nidte podquënenquio icpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Adotanquimbic: —Unësabi icnushe —queshun: —Unës uaquiobono —quetanquin sondadon cudan podo ansequin Esus uinte masepondash. Adoac nua intac chididiquiondash actebëdi. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","—Adosho ëmbimbo isondambi —caimbi. —Ëmbi dada uaid isun ma Esus tantianu —queshun abimbo chuiquin dada uaombi nëid dada uaquin. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nuquin Papan tantiamiac con tsusedpan: “Canite podquënenquio iquendac,” quequin dada uapampicpadomboen canite podquënenquio icpondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Adembidi podo ansete dada uapampic. “Ambi podo anseboed isec tabadendac,” quequin dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Adnubien shubu dadpen icquid Adimateya yacnocquid Ose chopondash. Esus tantiaquid aid niondash. Esus chieshënquido dacuëdënquin: —Esus tantiaquid nebi —quequin utsibo chienquio icboedëmbi Pidato chuitampac caondash. —Esus chococanun buanendambi —cac: —Ai —cac Esus buampondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Aidbëdi Nicodemo inchëshën Esusbëd onquiondaid nidpac caondash. Bëdambo nuadquid mida adoebëdta cabiunaid unësaid dabiunte bëac caondash. Nuamboshë. Yuëmbo icnuc 35 quidostembi icnuc bëac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Adshumbien Osebëdtambi Esus nua dabiunquin uesquin dataniac caondash dashcuten. Adshumbic padpiden dabiunoaquin. Adshumbic padpiden dataneoaquin. Adshumbic padpiden dabiunoaquin. Adshumbic dataneoaquin. Chococanun con matsesën adoquid. ");
INSERT INTO mcfNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","42","Adashic: —Badiadash Nuquin Papan matamiampid inchësh tantiate ushën unësaid chococac icsambo ictsiashe. Badedquio chococanu —queshun tied nëbi ictsëcquidën Esus buampac caondash. Buanshumbic cuënote dapa shëcuë uaid chucan matses chococabi icquidën Esus nauedpac caondash. Shëcuën nauedtanquin bëtimpac caondash cuënote dapambidi. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Esus chococan daëdec ushash badiadnuc dominco caid ushën ënden inchëshquio icnobi Mactada yacnocquid Madia chedo Esus chococacnuësh sedenquec nidpac caondash. Nidshun isquien shëcuë bëtinaid cuënote dapa bëcunepamboen shëcniac. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Cuënote dapa bëcunepamboen shëcniacsho istanec titinquianec choquin chuituidpondashi. —Esus padoen buanchitaccosh. ¿Mitsimbo buampash? —quepondash Madia Petedobëdta ëbi chuituidec. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Adoaquini: —Istanu —quianec ");
INSERT INTO mcfNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","titinquianec chococacno Petedobëdi nidpondac. Petedo nianec ëbia nidpondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Adshumbimbi puduedenquio icquin shëcuë anshuebudshun anispondac. Adshun isquien dashcute dataniaiduidtsëqui uec. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aden ëmbi anisnubien Petedo choequi badedi shëcuën puduedpondash. Aidëntsen dashcute dataniaiduidtsëqui istuidondash. Esus nibëdondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Në dataniaid uenubi udictsëc dashcutempi bëpucaid bëdamboen shëbunaid uiondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aid puduedsho istanec tsyuec puduedshun ëmbitsen isondambi. Adash: —Uincuenac. Nuquin Papan Madombobi nec —quepondabi Petedobëdtsëqui onquec. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","—Nuquin Papan tantiamiac con tsusedpabon aden Esus uincuente chuiquin dada uapampic —quequin tantienquio icboedi adondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aden istanec ëbi ushbocnobidi chiec choapondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Adnubien ëbi chuiuamboed Madia chococacnobidi isec nidoapac caondash. Nidash shëcuë cuëmano tsadec sedenquetuidpac caondash. Adec shëcuë cuëmano tsadec sedenquetanec shëcuë anshuebudshun isaquien ");
INSERT INTO mcfNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nuquin Papan abi yacnoshon uaido mayan bëda daëd ushumbo icquid dasiuidquid Esus uebocno tabadpec. Esus nibëdec. Mapi icbocno abentsëc tsadnuc utsi taë icbocno tsadpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Adshumbic aidën: —¿Atotsi quiash sedenque, champi? —caquien: —Con Icbo pado ¿midambo buanac? Istiadquio iquebi. ¿Mitsimbo buampashba? Unësquio iquec —quetanec ");
INSERT INTO mcfNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","aucbidi nidnuec bidiadshun isquien Esusquio icpec. Utsi dansho ");
INSERT INTO mcfNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Esusëntsen: —¿Atotsi quiash sedenque, champi? ¿Tsutsi nibëne? —caquien Madian tied neshcaquid danquin: —¿Con Icbo padoda buano? ¿Mitsimbo buano? Ëbi isme. Shëcuë utsin chococanun buanu —capac caondash Madian Esusquiobi chuiquimbi. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Abi adoshobien Esusën: —Ëbi nebi, Madia —cac bëisquiotanequien: —Esus nec. Ëbi chuiquidquio nec —quetanquin con onqueten cuënquin: —Dabi —capac caondash. Adotanquimbien Esus dayumbudpac caondash unësquio icsho. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aden abi dayumbudshobien Esusën: —Ëbi dayunenda. Padpidec nidenquio icte danquin ëbi dayunenda. Ëmbi chuibocpadec con Pa yacno nidabi yuec-yuecpactsec tabadtanec nidebique. Ëbëd icboedo ëmbi con utsibo caboedo ëmbi chuiboedquio chuitan. “ ‘Nuquin Papa yacno nidendabi,’ quiosh,” catan —quepac caondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Adoaquien ëbi chiec Madia chopondash. —Nuquin Icbo Esus isombi. Uincuenaccosh. Ambi chuiboed chuinu. Tantia —quequin Esusën abi chiaidquio chuituidpondashi Madian Mactada yacnocquidën. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Madian aden chuituidboed inchëshbudtsëqui shubun tabadpondabi Esusbëd icboedobëdi. Esus chieshënquido dacuëdënquin umanucuësh utsi puduedtiapimbo icnuc bëdamboen bëtashash tabadnubien shëcuënuësh puduedenquio icboedi nuntanquiobi Esus isadcuempondash. Adtanequien: —Dacuëdenda —quepondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Adtanquin abi bëchun shuin mëtoccaid abi podo ansiaidbëdta ismiaquini cuishonquiampondac: —Nuquin Icbo uincuenac —quiash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Adec cuishonquesho isashien ambi chuibocpadecbidi: —Dacuëdenda —quetanec: —Tantia. Mibi chuinu. Con Pan: “Matses chiec nid,” ëbi caondacpadomboembidi: “Ëbi chuibeneta,” mibi caimbi —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Adtanquin ëbi chedo dabushcabampondash. Dabushcabanashic: —Nuquin Papan Mayan mibëd tabadendac. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mibëd icquin Nuquin Papan tantiaidquio tantiamequin Nuquin Papan Mayanën mibi utsibo chuibamendac. Adoac mimbi aden chuibanaido caic: “Nuquin Papan chiaid niaquec icsambo icboedi Esus tantiaquid yansho Nuquin Papan nëid bëdamboen isec,” quequin mimbi chiacpadomboen Nuquin Papan bëdamboen istsiash. Utsien: “Nuquin Papan chiaid niaquec icsauidequi icsho nëid Nuquin Papan bëdamboen istiapimbo iquec,” quequin mimbi chiacpadomboembidi Nuquin Papan bëdamboen istiapimbo ictsiash —quepondash Esus ëbi chedo chiec. Adtanequi isadenquio yanoaondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Adec Esus isadenquio yanoanubien Esusbëd icboed utsi Tomas abi ushëmbi anin daëd tishaid chopondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Choshobi: —Esus isombi —cac: —¿Aidquiobida nepash? Utsien nechitash. Bëchun shuin mëtoccaid shëcuë isun aid shëcuë mëdanten bëmishquinc podo ansiaid bëmishquinc caquioshombimbi: “Ai, nuquin Icbo uincuenac,” quequin tantiatsiac. Padambobi: “Con Icbobien niash,” quetiapimbo iquebi —quepondash Tomas. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tomas adbon 7tedec ushash shubu nuntambidi tabadoapondabi. Tomas chedobëdi tabadondabi. Puduedtiapimbo icnuc padpiden bëtashoash tabadnubien shëcuë shëcniabi Esus isadcuenoapondash. Adashic: —Dacuëdenda —queoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Adtanequien: —Is con mëdante, Tomas. Shëcuë bëmishec cho. Në podo ansiaid iqueque. Aidtsen bëmishec cho. Adshun: “Uincuenabien icchitash,” queboedëmbi: “Uincuenaccosh,” quequin tantiata —caquien ");
INSERT INTO mcfNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","mishenquio yec badedi: —Tso. Con Icbombo ma mibi neyoc. Nuquin Papapadquidquiobidi ma mibi neyoc —quepondash Tomas. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Adsho tantiashien Esus: —Ëbi isun: “Nuquin Papapadquidquiobidi mibi nec,” quequin mimbi ëbi tantiec. Utsibombien ëbi isabi: “Ai, Esus Nuquin Papapadquidquiobidien nec,” quequin ëbi tantiasho Nuquin Papan bëdambo icmendac —quepondash Esus Tomas chiec. Adtanec isadenquio yanoapondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Comapenen tantiaquidquio yec abembi uincuenash Esus adpondash. Ënden unësabi icquin adembidi comapenen tantiaquin nabampondash. Aden ambi comapenen tantiaquin nabanaidtedi uesquin chiambo iccombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Padi, aidtedi chiombi. —“Nuquin Papan chomiaidquio yec Nuquin Papan Madombobien Esus nec,” quequin aid tantiash ma Nuquin Papa yacno abëd tabadtequido icpanu —quequin aidtedi dada uaombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tantia. —Edusaden yacnuësh isadboshic chian Tibedias caid cuëmanuështsen Esus isadpondash —quequin mibi chuinu. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Esus uincuenash daëdec isadan con nidaid Cadidia caid yacno nidanepondabi. Nidaniash nëidtedi tabadpondabi. Nëidic Petedo. Nëidic Tomas anin abi ushëmbi daëd tishaid ëmbi caboed. Nëidic Cana yacnocquid Natanaid. Nëidic ëbëdta tishaidquio. Nëidic ëbi. Nëidic Esusbëd icboed utsi daëd. Aidtedi icpondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Adnubien Petedo: —Ëmbi bedtenecpaden nëshaidën nuëcquid bedtanu —quepondash. Adshobimbi: —Nid. Nuquitedi nanu —capondac. Adash chian yacno nidash cano antabëdtoanec nënantan nidpondabi. Adshun nëshaid dapa nëneshun yuecshun cadoshon isac nibëdec. Adshumbic padpiden nëneoashun cadoshon isac nibëdoaic. Inchëshbudtsëc tauash nuëcquid bedambobi ambi badiadpondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Badiadquionobi acte cuëman masi dapan Esus nidsho istuidpondambi. Utsiembi dampondac. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Adshobini Esusën cuëmpondash. —Con utsibo ¿tedtsi bedo? —cac: —Padambo. Nibëdosh —capondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Adsho tantiashun: —Mimbi nëniauc nënenquio icquin cano utsiuc nëshaid nëne. Adoac nuëcquid bedadec —cac ambi chiauc nëshaid nënetanquin: —Indono —cac nëshaid indotiapimbo yuëmboshë icpondash. Nuëcquid dadpen bedac. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Adsho isumbimbi: —Ma Esus neyoc, Petedo. Nuquin Icbo nec —capondac. Adoaquien aton tsitsumi icquiduidtsëqui icnuc abi dachiquidboed aton dashcute utsi dasiuidtanec acte nëpudunash Petedo tan-tanidec nidpondash Esus isnuec. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ëbien utsibobëd canombi tsyuec nidondac nëshaid shoyombanec. Cuëma anoentsëqui nuëcquid bedash 100 metedos cactiontsëc nidondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tsyuec choash pudundoshon isquien pambëdi nuëcquid cuëten shëadtsec. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Adnubien Esusën: —Mimbi bedboed daëdpactsëc beccho. Penu —cac ");
INSERT INTO mcfNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Petedo: —Ai, bedtanu —quianec nidash cano anidtoshon nëshaid cubu-cubuctsëcquio icquid indopondash. Acte cuëmano tsindoshon isac dadpenquioshë 153tedi nuëcquid icpondash. Nua-nuaic tsadquido icpondash. Nëshaid tësëdtiadtsëcquio icnuc indondambi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","13","Adshumbic ambi: —Pec cho —cac cho-choash tabadsho pamba menebantanquin nuëcquidtsen Esusën menebampondashi. Adoac: —¿Tsutsi ne? —quenquio icquin: —Esus nec. Comapenen tantiaquin nuëcquid nuqui bedmiosh —quequin tantiondambi ëbitedishun. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Adec uincuenash shubu nuntan tabadnuc daëdec isadondashic chian cuëmanuështsen isadoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aden chian dapa cuëmanshun Esusbëdtan piondambi. Adshumbic Onas caidën mado Petedo Esusën chuipondash. —Tantia. Mibi chuinu, Petedo. Nëidon ëbi bëdiactsëc tantianuc ¿ada ëbi tantiaquie? —caquien: —Ai, mibi tantiembi. Aden ëmbi tantiaid mimbi tantiec —quepondash Petedo. Adsho tantiash: —Ëbi tantiaquin con obecabimboecquido ëbi dayun uashunta —quepondash Esus. —Obeca icbon aton yua dayun uacbimboen ëbi tantiaquido ëbi dayun uashunquin ëmbi chiaidbëdta ëmbi naidtedi chuibanta —quequin tantiec adpondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Adshumbic padpiden: —¿Ada ëbi tantiaquie, Petedo? —cac: —Ai, mambi mibi tantieyoc —quesho tantiashien padpidec: —Ëbi tantiaquin con obecabimboecquido ëbi dayun uashunta —queoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aden daëden chuishumbic padpiden Esusën: —¿Ada ëbi tantiaquie, Petedo? —cac shubiantiadtsëcquio yanondash Petedo. —Unës uabi icnuc: “Ëmbi isacmaid Esus nec,” quequin ëmbi chuiboctedembidi Esusën chiebi —quiash shubiantiadtsëcquio yanondash. Adashic: —Mibi con Icbo nec. Ma mimbi abitedimbo tantieyoc. “Petedon ëbi tantiaquiec,” quequin ma mimbi tantieyoc —quepondash Petedo. Adsho tantiash Esus padpidec: —Ëbi tantiaquin con obecabimboecquido ëbi dayun uashunta —queoapondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Adashic Petedobidi chuioaic: —Tantia. Utsien chuinu. Cania yec mibibi tsisiuidondac. Adanec mibi bunacno mibi nidtedniondac. Tsusiobudtsacshoen tsiumeshun utsibon ëquë mëdimbudcuentsëcshun mibi nidte bunacmanombo mibi buanendac —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","—Aden mimbitsen Nuquin Papan chiacpadomboenuidi nabansho ëbi chieshënquidon mibi unës uaindac —quequin tantiec adpondash Esus. Adashic: —Ënenquio icquin ëbi tantiata —quetanquimbic: —Cho. Nidnu —cac ëbitedi puduanec nidondabi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tsyuec nidshobini Petedon bidiadquin ispondash. Adshumbic: —Nëid Esusën tantiaidquio nec. Esus bedmiaid inchëshën Esus aton cachoctsëqui uesho aidën: “¿Tsutsi cao, Icbo?” capondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","¿Mitsipadec aid unëspatsiash? —queshun: —Ma nëid. ¿Mitsipadec unëspec? —capondash Petedon ëbi unëste Esus chuimequin. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Adoaquien Esus: —Ëbi bunacpadequi aidi unësendac. “Ëbi Nuquin Papa yacnuësh choabi yacpadec ma unësenquio icnu,” ëbi quiacpadec unësenquio ictsiash. Adecbidi: “Ëbi choabi icnuc ma unëspanu,” ëbi quiacpadec unëstsiash. “Nadec unësendac,” quequin mibi chienquio iquembique. Ënenquio icquin ëbi tantiata —quepondash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Adec: —Unësenquio ictsiash —Esus quesho tantiash ëbi caic: —Esusën tantiaidquio yec Uan unësenquio iquendac —quecuededpondash Esus tantiaquido. ¿Adenda Esusën chuidiondash? Ma padenquio iccondac. —Ëbi bunacpadequi aidi unësendac. “Ëbi Nuquin Papa yacnuësh choabi yacpadec ma unësenquio icnu,” ëbi quiacpadequien unësenquio ictsiash. “Adecbidi ëbi choabi icnuc ma unësnu,” ëbi quiacpadec unëstsiash —quequien iccondash. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aden Esusën nabanondaid ënquin chiombi. Ëmbi isondaidquio chuiquin abimbo chuiquin aidtedi dada uaombi. ");
INSERT INTO mcfNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Esusën naidtedimbo chuiquin dada uambo iccombi. Ëmbi tantiaidtedi naombi. Ambi naidtedimbo ambi chuibanaidtedimbo chuiquin dada uaquin dada uate dadpenquioshë naimbudnetsiambi. Padi. Aidtedi dada uaombi.");
INSERT INTO mcfNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Ducas nebi. Mibi Esus tantiamenu, quequin ënden dada uaondambi, Teyopido. Esusën tauain ismebanaid bedanquin abi abuc indoaid dënainquin dada uaondambi. Abuc nidnun Esusën ëbi chuibeneta quequin abëd icquido chuipanëdash aton Mayanën tantianubi. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cuesten dectanac unësash uincuenshun: “Uincuenobique. Is,” quequin Esusën utsi-utsien ismebampanëdash ma abimbo iquec quequin tantiaquin ëbi chuibenepanueshun. Ushë abentsëc nidmequin utsi choaid abi choauqui usudnuc 40ted ushquin aden ismeben-ismebenequin Nuquin Papa yacno tabadaid iquec quequin Esusën chuided-chuidedpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aden ismequimbi Edusaden caid yacnoshon ambi ëbi chuibeneta caidobëdtan pec tabadquimbi Esusën nadopanëdash: —Edusaden yacno tabadquin ëmbi chianeboed, con Mayan, Nuquin Papan mibi menetequid caimbudta. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Acten mentoanquid Uan pado icpondash. Padnuen ëmbi chianeboed Nuquin Papan aton Mayan mibitedi menendac —quepanëdash Esus. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Adshumbic, padpidec Esusbëd icquin abëd icquidon: —Yuen matses utsibon namiaido nuquin matses nec. ¿Nëbimbobida mibi nuquin matses chuiquid dapa icpeque? Tantianu. Chui —capanëdash Esus chuiquin. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Adoaquien: —Nuquin matses chuiquid icmete ushë choaid tantiesa mibi nec. Nuquin Papanuidtsëqui tantiacpadën adquid iquendac —quepanëdash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aden chuishumbic: —Aton Mayan Nuquin Papan meniac aidënquio tantiamequin pausunac ëbi chuibenequidquio mibi iquendac. Edusaden caid yacnoshomba mimbi ëbi chuibanendac. Adshumbic, nidaid Udeya caid yacnoshontsen ëbi mimbi chuibanendac. Adshumbic, nidaid Samadia caid yacnoshontsen, adembidi nidaid utsi-utsiec yacnoshontsen adembidi ëbi chuibanendac —quepanëdash Esus abëd icquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aden chuibanquin Esusën nabanquin nainanec macuësh yacno choacsho aton Papan Esus abuc indopanëdash abëd icquidobëdtan abi tantiaquid utsibon isbedednubi. Aden isec tabadnubi abu ushun Esus bëtimpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Adec Esusbëd choboedo isec tabadnubien dashcute ushumbocquid dasiuidquid daëd choash tabadec: ");
INSERT INTO mcfNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—Nidaid Cadidia caid yacnoësh choquido, ¿atotsi quiash abuc isec tabadec ne? Abuc indosho mimbi isboed Esus abu ushun choec budsho mimbi isendac padpiden —quepanëdash ushumbocquid dasiuidquid abuc isbededquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aden Esus abuc indosho isash abëd macuësh Odibos caid yacno choboedo Edusaden caid yacno nidoapanëdash. Chonoadtemaid ushë nec, quec aidtiontsëqui capunëdash. Aido Edusaden yacno choash abuc quënë yacno abi tabadbocno dectatoash tabadoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aid quënë nuntan Esusën ëbi chuibeneta caido nëidted icpanëdash: nëidic Petedo, utsibic Uan, utsibic Acobo, utsibic Andedes, utsibic Uedipe, utsibic Tomas, utsibic Badtodome, utsibic Mateyo, utsibic Adpeon mado Acobo cuëmëdquid, utsibic isadaidpembo namequin chuiquid bunesa, Simon cuëmëdquid, utsibic Acobo utsin mado Udas cuëmëdquid. Aidtedi Esusën ëbi chuibeneta caido aid quënë nuntan tabadnubi ");
INSERT INTO mcfNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","utsibo Esusën tita yec Esus tantiaquid chido utsibotedi yec Esusën utsibo yec quec ambobidi iccuededquin Nuquin Papa chiec abentsëc onquiacbimboec onquecuededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Adashic Esus tantiaquid 120ted iccuedednubi nënantanquio nidtoshon Esusën ëbi chuibeneta caid abentsëcshun Petedon naden chuipanëdash: ");
INSERT INTO mcfNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","—Udas pado chuibanu. Tantiata. Esusbëd icquin piucquid dayun uaquid icquimbi Esus chieshënquido Udasën Esus bedmepondash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aden Esus bedmeshun ambi piucquid bedboed menequin aton tiedëmpi bedashic aid tied nantanuësh tëtaniadash pobidisquiash paëdec aton pucu tishidpac caondash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pucu tishidec intac chiuidaid tied icsho tantiaquin Edusaden yacnocquidtedishun Aquedama cain aton onqueten cuëmbededpondash. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Adembidi ëndenquimboshë Udas pado tishabicnuc chuiquin Nuquin Papan Mayanën tantiamiacpadomboen tsusedpa Dabid caidën Udas cuidte tantiec cuëdënte Sadmo caid naden dada uapampic: “Ma adequi aton shubu mosadpanuna ma aidbidi aton matses nibëdquid shubu icpanuna.” Aden Udas pado cuidte chuiquin cuëdënte Sadmo caid utsitsen naden Dabid Padon dada uaoapampic: “Aidën icsain nacpaden tanenquiocquin ma utsin bëdamboen napanuna,” quequin Dabid padon dada uapampic —quepanëdash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aden chiashic abi onquec: —Udas pado nibëdnuc Esus chuibeneta quequin abentsëc nuquitedishun chuinuna. Nëid quënë nuntan nuquibëd capuquido dada dadpen iquec. Nuqui Esus chuibeneta caid nadquid ictiad. Chuinu. Tantia. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Esus Uan padon acten mentosho isash niamëdenquio yec Esusbëd capucueneshun Esus indosho isquidquio icsho, Esus chuibeneta, quequin nuqui chuitiad. Adoac Esusën ëbi chuibeneta caidobëdtan Esus uincuemiaid chuibantiad —quepanëdash Petedo iccuededquido chiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aden Petedon chuibanac daëd istuidash Petedobëd iccuededquido, Petedon chuibocpadquid nëid daëd iquec, quequin chuipanëdash aidon. Ambi istuidaid abentsëc Ose cashun Badsabas cashumbic Ustus, quequin cuënaid nepanëdash. Utsibic, Matias cuëmëdquid icpanëdash. Nëid daëd Petedon chuibocpadquid nec, quesho tantiashun: —Nënantanquio tabadec cho —cac abi daëdi choash tabadsho isash ");
INSERT INTO mcfNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nuquin Papa chiec nadec iccuededquido onquepanëdash: —Nënantanquio chomeboed nëid daëd iqueque. Is, Papa. ¿Mitsicquidimbi Esus chuibeneta, cape? Ëbitedi tantiame, Papa. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Udas pado tauidtiadpambo chian anëdënquiacno nidboedën nauidaid namenu, quequin mimbi bëdamboen isaid abentsëc ëbi isme. Papa. Aden mimbi ismiac ma aidëntsen Esus chuibenepanuna —quepanëdash Nuquin Papa chiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Aden chuitanquimbic aid daëd abi cuëmëdquid abentse-abentsen dada uatempin dada uashumbic tëchun sandoshon cadotaniac dada uatempi abia puduenaid istanquin, Matias cuëmëdquid nec, quequin isbededboshic, Esusën ëbi chuibeneta caido onseted icboedi nëbi Matiasbëd doseted yanosh, quequin chuibededpanëdash nuntan iccuededquidtedishumbi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Adashic isadaidbon ambi aton tiedën caniquid abia ëshëaid bedaid tantiaid ushë chotsëcnubi Esus tantiaquidtedi shubunuëshi iccuededoapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ambo iccuededquimbi badedquio shubu nuntan cunquequid dapa choec natiambo cunquiacbimboecsho abitedishun isbededpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aden aid isbedednubi cuëte dëtsisidacbimboecquid budec mais-maisec Nuquin Papan Mayan matsadtocuededpanëdash abi isquidtedi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nuquin Papan ma aidobëd tabadnueshun aton Mayan Esus tantiaquidtedi menebanac matses utsi-utsiec onquetenquio onquecuededpanëdash ambi matsadtomiaidotedi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aden Nuquin Papan aton Mayan menenubien isadaidbo utsibo Edusaden yacno cho-choash dadpen tabadpanëdash. Aido Esus tantiesabo yequi aton tsusedpabon chiampicpaden nanuec nidaid utsi-utsiec yacnoësh Edusaden yacno cho-chopanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ambo cho-choash tabadnubi Nuquin Papan aton Mayan meniaid-meniaidquiec nëmbobi choquidon onqueten-onquetenquiec onquesho tantiash nëbi cho-choboedo utsi-utsiec: ");
INSERT INTO mcfNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","—¡Padtec! Dacuëdanquiopaic. Ëbipadquiecshenda onquepec. ¿Onquequidotedi nidaid Cadidia yacnocquidoda nepec? ");
INSERT INTO mcfNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Mitsipaden con onquete bedash onquecuededpec nec? ");
INSERT INTO mcfNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ëbitedi nidaid utsi-utsiec yacnoësh cho-choquido nebi. Padtia yacnoësh choquido; utsibic, Media yacnoësh choquido; utsibic, Edan yacnoësh choquido; utsibic, Mesopotamia yacnoësh choquido; utsibic, Udeya yacnoësh choquido; utsibic, Capadosia yacnoësh choquido; utsibic, Ponto yacnoësh choquido; utsibic, Asia yacnoësh choquido; ");
INSERT INTO mcfNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","utsibic, Pidiquia yacnoësh choquido; utsibic, Pampidia yacnoësh choquido; utsibic, Equipito yacnoësh choquido; utsibic, Dibia Sidene udictsëcuësh choquido; utsibic, shubu dadpen icquid Doma caid yacnoësh choquido; utsibic, acte nënantan nidaid nacnëdquid Quideta caid yacnoësh choquido; utsibic, Adabia caid yacnoësh choquido. Isadaidbobëd isadaidbopadquio icnuequido Edusaden caid yacno tsusedpabon chiampicpaden nanuec cho-choboedo ëbitedi nebi. Ëbibimboec onquequidtedishun Nuquin Papan naid chuibansho tantiembi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","¿Mitsipaden tantiaquin oncamiaquien adec onquepec? —quepanëdash Edusaden yacno cho-choquid. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Adnubien: —¿Bëdamboec onquepequida onquec? Paëmbocquid cubudquin acshun tantienquiocquido nepanui —queoapanëdash utsibo. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Adec onquesho tantiashun Esusën ëbi chuibeneta caido cho-choquin Petedon nidtoshon tantiamenu quequin naden cho-choboedo comapenec onquequin chuipanëdash: —Mimbi icsamboen tantiaid chiembique. Tantiata. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ushë abuctotsëcnubi ëbitedishun paëmbocquid acamboccombi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Utsin-utsinquiec onqueten onquesho mimbi tantiaid Nuquin Papan ëndenquimboshë chiampicpadec onquec nebi. Tsusedpa Oedëmbi Nuquin Papan ma matsesbëd tabadnueshun aton Mayan menenun chiaid naden aidën dada uampic: ");
INSERT INTO mcfNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nëid nidaid naimbudnubi Con Mayan matses utsi-utsien menendambi. Aidon madobobëdtan aidon champibontsen ëmbi yuecquio icshun nanun chiaid chuibanendac. Adembidi caniabontsen ushquin ëmbi chiacpaden isendac. Adembidi tsusiobontsen ushquin ëmbi chiacpaden isendac. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aden con Mayan meniac ambi tantiacpadomboembidi ëmbi chuiquin namiaidon dadan chidobëdtan ëmbi yuecquio icshun nanun chiaidquiobidi chuibanoaindac. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Adembidi, con Mayanën tantiamiac ëmbi yuecquio icshun nanun chiaid matsesën chuibanubien abucuësh uinsadpamboctequid icnubi nidaidënshun ismete intacbimboectequidbëdtabi nëdënquetequid cuëte pushudquidbimboectequid abembi pushudquidbëdta adquidtedi mibi ismendambi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Adquid icnuc badiadën ushë chënquenquiocnoc inchëshacbimboectequid inchëshën ushë piu-piupambo yec intacbimboecsho mimbi isbededendac. Ëmbi ismiaidtedi icambi matses cuidte ushë choendac. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ismequimbi con Icbombo nec ëbi caquidquio mënchiquendambi,’ quequin Nuquin Papan chuimiacpaden Oedën dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Adembidi Nuquin Papan chomiaid chiembique. Tantiata, isadaidbo. Nasaded caid yacnoësh choquid, Esus, Nuquin Papan chomiaid icquin nadatiambocquin nabanquin ismebansho mimbi isondac. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aidi Nuquin Papan tantiampicpaden Esus bedshun mimbi isadaidpembo chuiquid menequin, Unës uata, cac cuesten dectanquin Esus unës uapanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aden mimbi nac unësacsho icsaisa chococacno yuec ictiapimbo iquec, queshun Nuquin Papan Esus uincuemepanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Adembidi ëndenquimboshë tsusedpa Dabid padon Esus chuibanquin naden dada uapampic: ‘Con Icbo abuc nidec bëyucanquid ëbëd tsadacbimboecsho isec nebi. Aidi con dayun tsadquid icsho isquin natiaic cametequid dacuëdënenquio iquendambi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Aid unësash uincuente tantiec ëbitsen uincuenendabi, Papa, quec cuëdënec bëdambo iquebi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nuquin Papa yacno tabadacpadec nidaidën tabadquin ismiac mibi yacno nidash mibëdi tabadec bëdamboshë iquebi mimbi camiaid iquendabi,’ quequin Esus tantiaquin Dabid padon dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Adomboen tantiaquin dada uash Dabid unësacsho chococapampid nëbi shëcuë iquec. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dabid Nuquin Papan ambi yuecquio icshun nanun chiaid chuiquid icquin nadopampic. Yuecquimboshë yash mibi ëndenquimbo unësampid icnuc min tsyuecquid chuiquid dapabidi iquendac, quequin Nuquin Papan chiaid abimbo iquec, quequin tantiaquiopampic Dabid padon. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aden Nuquin Papan nanun chiaid tantiaquin Esus uincuente isacbimboen dada uaquin, Nuquin Papan Chomiaid unësacsho chococaqui aton nami chodquenquio yec uincuenendac, quequin chuipampic Dabid padon. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ai, Dabid padon chiampicpadembi Nuquin Papan Esus uincuemepanëdash. Aid uincuemiacsho isondaid icquin mibitedi chuibanec nebi. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aid uincuenash Nuquin Papan dayunquio tabadendac nëbi. Ambo choacsho matses tantiaquin Nuquin Mayan ma aidbëd tabadnueshun matses mimbi meneta, aton Papan cacpaden abi tantiaquidtedi menebanquiac onquete utsin-utsinquiec onquesho nëbi mibitedishun tantiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dabid padon nami chodquiash abuc nidambocpampic. Aden aton namibi abuc indote chienquiocquin Esus chuiquin Nuquin Papan yuecquio icshun nanun chiaid naden Dabid padon chuibampampic: ‘Nuquin Papa Icbo Dapa icquin abipadquid icbo cain: Nëbi ëbëdi tsadec cho. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mibi chieshënquido dëniacquidquio mibi icmenun nabono. Chiata,’ quequin Nuquin Papan nanun chiaid Dabid padon dada uapampic. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aden tantiaquin Dabid padon chuipampid Esus mimbi cuesten dectanquin unës uaid uincuemequin matses icsaid bedshunash abided cuidadquid Nuquin Papan icmepondash. Adoac ëmbi chiaid abimbo iqueque. Esus tantiaquidquio icta, isadaidbo —quepanëdash Petedo. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aden Petedon chuisho tantiash iccuededquido abi icsaid tantiec unësquio yec: —Esus tantianuequin ¿atotsi nuqui nape? —quepanëdash utsi-utsiec Petedobëdta Esusën ëbi chuibeneta caid utsibo chiec. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Adoaquien Petedo: —Mibi icsaid ënshun, Esus con Icbombo nec, quequin abimbo tantiaquin acten mentometa ma ëbi icsaid Nuquin Papa bëpiscudnu queshun. Adoacsho aton Mayan mibi menendac. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Adembidi tantiasho isun min tsyuecquidtsen menendac. Adembidi nidaidtedi yacnocquidën tantiasho isun aton Mayan meneoaindac ambi chiampicpaden —quepanëdash Petedo Esus isquidquio. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Aden chuibanequi: —Mimbi icsamboen tantiaid ënta. Aden ënash Esus tantiaquidquio icta —quequin chuibudquin Petedon ëmpanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aden chuisho tantiash, Tantiaquiembi, quepanëdash utsi-utiec. Aid ushëmbi dadpenquioshë tedes midted Esus tantiaquid yampanëdash. Adquid icsho isun acten mentobampanëdash. ");
INSERT INTO mcfNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Adashic, Esus tantiembi, queboedo tantiabenabi iquec Esusën ëbi chuibeneta caidon Esus chuibansho tantiec tabadequi Nuquin Papa chiec onque